﻿USE sofia;
DROP TABLE IF EXISTS sofia.sue_vpl;
CREATE TABLE sue_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sue_vpl WRITE;
INSERT INTO sue_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ema kei awi-tupie dowa Yesu Kristo nu Abrahamto Dawidira saisibuna nusoto zo meni kei awenua, amira uge. ");
INSERT INTO sue_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham nu Isakara mama. Isaka nu Yakobora mama. Yakobo nu Yuda ata namisini nuso ata amira mama. ");
INSERT INTO sue_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda nu Pereseto Zerara mama. Mia nusoto awa Tema. Perese nu Hesronra mama. Hesron nu Ramura mama. ");
INSERT INTO sue_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramu nu Aminadapra mama. Aminadap nu Nasonra mama. Nason nu Salamonra mama. ");
INSERT INTO sue_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamon nu Boasira mama. Boasira mia awa Rehap. Boasi nu Obedera mama. Obedera mia awa Ruti. Obede nu Zesira mama. ");
INSERT INTO sue_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zesi nu ema tua Dawidi amira mama. Dawidi nu Solomonra mama. Solomonra mia awa Yurayara bama kuma. ");
INSERT INTO sue_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon nu Riaboamra mama. Riaboam nu Abaisara mama. Abaisa nu Asara mama. ");
INSERT INTO sue_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nu Yeosofatra mama. Yeosofat nu Yoramura mama. Yoramu nu Usayara mama. ");
INSERT INTO sue_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya nu Yotamura mama. Yotamu nu Ahasira mama. Ahasi nu Hesekayara mama. ");
INSERT INTO sue_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaya nu Manasara mama. Manasa nu Amosira mama. Amosi nu Yosayara mama. ");
INSERT INTO sue_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaya nu Yekonaya ata namisini nusore amira mama. Be amire Yuda emara iwo meni nukare beniro puro bamu zebu Bablilon amira niwa. ");
INSERT INTO sue_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nukare puro bamu Bablilon niwa amire Yekonaya nu Siatielira mama. Siatieli nu Zerababora mama. ");
INSERT INTO sue_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerababo nu Abiudura mama. Abiudu nu Elayakimra mama. Elayakim nu Azora mama. ");
INSERT INTO sue_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azo nu Zedokra mama. Zedok nu Akimura mama. Akimu nu Eliudura mama. ");
INSERT INTO sue_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudu nu Eleasara mama. Eleasa nu Matanra mama. Matan nu Yakobora mama. ");
INSERT INTO sue_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo nu Yosefera mama. Yosefe nu Mariara iu awa. Ota Maria meni awa mai Yesu zazo nuso Kristo sai, awa pumunua. ");
INSERT INTO sue_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kei awai awa ego ine kei awero muwa awa. Abrahamra nana ena kei awero tupie dowa Dawidi kei awenua, awa kei awai dubu nukare 14 wewa. Ota Dawidira nana ena kei awero tupie dowa iwo meni Yuda ema puro bamu Babilon zebura niwa awa kei awai dubu da ago ine 14 wewa. Ota be amira ana kei awero tupie dowa Kristo kei awenua awa da ago ine kei awai dubu 14 wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kristo kei awenua amira susu awa ego itia ewa. Mia nuso Maria nu Yosefere seroniwa noisowato awa. Ata nuto kaka tayamu seronai gege noiwato Ozana meni tani putoure wenu Maria wasou wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ago wenu iu seronai nuso Yosefe nu etutiro noisonua, are duba nuso meni ego senua awa, “Na nu saitiro duamunona. Nu bewana wisia amira na nu gera potana menai azu, saitiro kora wero duamunona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ago wamu kotupitinoise noinu Tuara angelo zo meni numore atuara ena kei awero ego senua awa, “O Yosefe, ni Dawidira sibuna, bama seronai niso Maria pumamu inoise kotumu-katumu oko wase. Bama mou wataya awa mai Ozanara awa. ");
INSERT INTO sue_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mai mata diri pumamunoya nune ami dubu nuso pasina nusokarera ina amira ena soero pumamunoya, are zazo nuso Yesu aseyo.” Angelo meni ago senua awa. Zazo amira susu awa Anutu Soyai Ema awa. ");
INSERT INTO sue_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nena bamubamu kei awenua awa porofete zo meni Tuara bera ge ego senua awa me waise kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Sana niniu. Mai bama diri zo gita ema zore kaka tayamu ami wasou wero mai mata diri pumamunoya amira zazo nuso Emanuel asamunora. (Ge nasokaira “Anutu meni namorekai dai nowia.”) ");
INSERT INTO sue_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosefe atua inoinu Tuara angelo meni ge numore senua, awa niniro giro seka wero eriro ge dimuro Maria puro witi so nusora ninua awa. ");
INSERT INTO sue_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ata iu ara kaka wamu nomiteto amire mai mata diri pumunua. Pumunu giro Yosefe meni mai zazo nuso Yesu asenua awa. ");
INSERT INTO sue_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herode meni ema tua wero noisonua be amire Yesu nu Betelehem nate ena Yudaya zebura ena kei awenua. Kei awenu amire waiko wititinowia amira kenara ena zebu zora ema ninai bamure meni Yerusalem nate kei awero atata wero sewa awa, ");
INSERT INTO sue_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Yuda ema, ema tua nisokare mai uno zo kei awitaya awa nata nago iti? Nakare waiko wititinowia amira kenara ena kuna nuso giro nuso nana koiniro nu bowi wamu sero tupenakare.” ");
INSERT INTO sue_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ago sewa ema tua Herode ata Yerusalem nata susu nukare te niniro azu wero titibi awewa awa. ");
INSERT INTO sue_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ago wero Herode meni Yuda emara pris babezinomare lo ge gipai emare zawa senu auniwa atata wero senua awa, “Soyai Ema nasokai awa nata nana kei awaise sai ni?” ");
INSERT INTO sue_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ago senu nukare ego sewa awa, “Betelehem nate Yudaya zebura ena kei awaise sai itia awa. Amira porofete zo meni Anutura bera ge ego gaenua awa, ");
INSERT INTO sue_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","O Betelehem nata, Yudaya zebura itia. Nata awa Yudaya zebura nata giti kopi amira osai zo oko aewa. Nata amira ana giti kopi bamubake zo kei awero Isreli ema dubu naso dia wero baitamunoya.” ");
INSERT INTO sue_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ge awa sewa niniro Herode meni ema ninai bamure awa nuso nana upene marise zawa senu nuso nana muwa awa. Nuso nana muwa kuna awa be nere kei awenu amira susu gamu sero nu nukare atata wenu sero baitiwa ginua awa. ");
INSERT INTO sue_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sewa giro nukare Betelehem nate bayarise sero ego senua awa, “Nikare baro tamai bua inoma mai tamuro giro muro na sawa na da ago ine bamuro koiniro nu bowi wane.” ");
INSERT INTO sue_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ema tua meni ago senu niniro bamuwa awa. Are kuna nusokare nana zebura ena giwa da ami eba gita wero susaumite so mai itinua ago dopenua awa. ");
INSERT INTO sue_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kuna ago dopenu nukare kuna giro yawa sara bamubake wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ago wero nukare sora witiro mai ata mia nuso Maria awa giro bawa diro nu bowi inoise maguru nusokare waura awa be apero gol ata nena ibosi zamare wai awa ata nena zama ewananare awa puro numore potiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Are Tua meni atuara ena nukare Herode nana kapeteniro bayai azu senu niniro eba zora susaumite zebu nusokare nana kei awewa awa. ");
INSERT INTO sue_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nukare ewesemuro susauwa Yosefe atua inoinu Tuara angelo zo meni nuso nana kei awero tugata wero ego senua awa, “Ni eriro mia maire pumuro Izip zebura baro ago ge naso dia nuawe. Nera kota, Herode meni mai kau inoma tamuro damu toya.” ");
INSERT INTO sue_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ago senu Yosefe meni eriro mia maire pumuro pire tara awero Izip zebura bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nukare baro ago noiwa Herode betenua awa. Nena ago ine kei awenu amire ge porofete zo meni Tuara bera ego senua awa me wenua awa, Mai naso Izip zebura noinu zawa sena doro ewesemunua. ");
INSERT INTO sue_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ema ninai bamure nukare Herode eteteniro bamuwa, awa Herode meni niniro tini kapai bamu tamunua. Ago wero soldia nuso senu bamu Betelehem nate niro nata amire nata pei-mamai zimuro itiwa amira mai mamatana zepa tani eto ana osero tupia awa dapikarago dero tepo-tapo wewa. Awa ema ninai bamure meni kuna kei awaira be sewa nininua te senu dewa betewa awa. ");
INSERT INTO sue_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ago wewa porofete Yeremia meni ge zo gita ego senua awa me wenua awa, ");
INSERT INTO sue_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rema nate ena awi kei awamunoya. Di saire duba naire bamu kei awamunoya. Bama Reso meni mai mamai nuso emo di sai uzutara te kaka wamu wamunoya. Nera kota, mai dago tepo wamunora . ");
INSERT INTO sue_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herode betenu Yosefe Izip zebura noise atua inoinu Tuara angelo zo meni nuso nana kei awero ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mai dara betaise sisera nukare awa betitara, are ni eriro mia maire pumuro Isreli zebura ewesemawe.” ");
INSERT INTO sue_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ago senu giro Yosefe meni eriro mai miere pumuro Isreli zebura ewesemuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ewesemuro Yosefe meni ge zo ego nininua awa, “Akeleas nu mama nuso Herodera bua pumuro Yudaya zebura ema tua wero nowia awa.” Ge ago niniro ago baro nuai azu wenua awa. Ago wero atuara ge niniro giro Yudaya zebu doro Galilaya zebura bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ago wero nata zo zazo nuso Nasarete ago baro noisonua awa. Are porofete meni ge Soyai Emare sewa awa me wenua awa. Ge awa ego ewa, Nu Nasarete ema asamunora. ");
INSERT INTO sue_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Be amira ana Yohane ge ou gutai zaawai ema ami Yudaya zebura kei awero ware noise ge ego tugata inoisonua awa, ");
INSERT INTO sue_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Utura itewia ami imata Tua wero nuamunoya amira be tupia, are nikare duba kapeteniu.” ");
INSERT INTO sue_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ge porofete Yesaya meni senua awa ema amira nana ena me wenua. Ge awa ego ewa, Zo nu ware gamu gamura ena zawa sero arero ego toya awa, “Tuara ebata kora weu sonae.” ");
INSERT INTO sue_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane meni tama woi wo kamel tu meni wai awa puro noisonua awa. Ago wero wora tata meni ipu sapi diro noisonua awa. Ota nena nai numa awa pikare koware awa ninoise noisonua awa. ");
INSERT INTO sue_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yerusalem natera enata Yudaya zebura enata ou Yodan enibarata enibara ema bama dapikarago nuso nana dowinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ago wero pasina nusokare kereniro duasara amire ou Yodan ena ge ou gutinoisonua awa. ");
INSERT INTO sue_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Are Farisayo ata Sadukayo nukare ge ou emo nuso nana kei awewa giro nu nukare ego tugata wenua awa, “Zira mai awiso, nikare pasinara ina kei awamunoya awa azu wero dainawise ai meni nimorekare sasai? ");
INSERT INTO sue_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nikare duba kapetenamunowa amira te me nisokare nana kei awaise. ");
INSERT INTO sue_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ota nikare tama puro wititinoise duba nisokare meni ego ine oko seu, ‘Nakare Abrahamra saisibuna, are Anutu meni nakare gera oko potamunoya.’ Na sana niniu. Anutu meni samu wero giro sai omata emi Abrahamra saisibuna kei awamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Anutu meni ota sia wero ni susura potinu itewia. Are ni zo me kokopai tepo itai giro zesero ape niaora namunoya. ");
INSERT INTO sue_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Duba nisokare kapetenawewa giro na ou meni gege nikare ge ou gutinowena. Na ema osai gege. Ota ema zo ama mamunoya nune meni awa ema putou bamure awa. Putou nuso meni putou naso dainitinoya. Nune na dainai, are na osai me osai meni sandol nuso dimai* te oko inoya. Nune meni awa Ozana nimorekare potamunoya. Noko nikare niaora potamunoya. ");
INSERT INTO sue_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nu sawol nuso wana nuso meni zizinoya. Puro muro wuit zasaira masira kei awero wowo bayaise sero wuit ape bisira namunoya. Wowo bayai wuit me awa sianiro poti sora namunoya. Ota wowo meni awa niao awinoise itai gege itai amira apamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Be amira ana Yesu nu Galilaya zebura ena Yodan oura baro Yohane meni nu ge ou gutaise senua. ");
INSERT INTO sue_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Are Yohane meni ginu te kaka wamu wenu giro ina ego senua awa, “Na ego ine emi ne wanise muro tosi? Nine na ge ou gutasa te wamia.” ");
INSERT INTO sue_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ago senu Yesu meni ge ina ego senua awa, “Ni zeme kotumu-katumu oko wase. Nage ge dimai bua dapikarago wanage te wai ewanana wamunoya.” Ago senu Yohane meni nininua awa. ");
INSERT INTO sue_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Are ge ou gutenu Yesu meni Yodan oura ena wititinoise ego ginua awa: Utu be zaumunu Anutura Ozana meni ni guma ine wero osero nuso nana tame witinu ginua awa. ");
INSERT INTO sue_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ago wenu utura ena ge zo ego ine osenua, “Ni Mai naso. Ni wama naso. Na ni emo yawa sara inona.” Ge ago ine osenua awa. ");
INSERT INTO sue_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Satan Yesu etetenaise Ozana meni Yesu uzumuro puro ware bamunua. ");
INSERT INTO sue_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Are Yesu nu pi 40 waiko 40 ago nena nai sieniro nomite meri betero itinua awa. ");
INSERT INTO sue_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ago wenu etetenaira mama kei awero ego senua awa, “Ni Anutura Mai me wero noma giro se omata ami ma wai nase.” ");
INSERT INTO sue_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ago senu giro Yesu meni ina ego senua awa, “Tepo awa. Nera kota, ge gayai zo ego itia awa, Erama meni nenara daba nuamunora, awa oko te wamunoya. Anutura nana bera ena ge osisinowia awa te ninitinoise ewanana nuamunora awa.” ");
INSERT INTO sue_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ago senu Satan meni Yesu uzumuro puro Anutura gegenai nata Yerusalem amira baro ibu bamura ene potinu witinua awa. ");
INSERT INTO sue_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ago wero numore ego senua awa, “Ni Anutura Mai me wero noma giro ena zokari awero ose. Ni oko waya wamunosa. Nera kota, ge gayai zo ego itia awa, Anutu meni sai angelo dubu nuso meni ni dia wamunora. Ago inoise te niso omata meni gayai azu, nukare ni wana meni soga inoise puro osamunora.” ");
INSERT INTO sue_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ago senu Yesu meni ina ego senua awa, “Ota ge gayai zo dai ego ine itia awa, Ni Tua Anutu niso awa gaero gamu oko wase.” ");
INSERT INTO sue_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ago senu Satan meni nu noko uzumuro puro dirumura witiro baro dopinoise zebu serora simena-gaena wai nusokare awa gipenua. ");
INSERT INTO sue_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ago wero ego senua awa, “Bawa giti diro na bowi wamunosa, awa nena awa dapikarago nimore potamunona.” ");
INSERT INTO sue_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ago senu Yesu meni ge ina ego senua awa, “Satan, ni na doro bamu. Ge gayai zo ego itia awa, Ni Tua niso Anutu awa bowi wase. Nu daimata awa gege sou wamunosa.” ");
INSERT INTO sue_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ago senu Satan meni nu doro bamunua awa. Satan bamunu angelo dubu eni kei awero Yesu kora wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yohane benai sora potiwa itinu Yesu meni amira oziga niniro giro zebu awa doro Galilaya zebura bamunua. ");
INSERT INTO sue_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ago wero Nasarete nata doro Kapaneam nate itai-matai wenua awa. Nata awa ou ubura zorage itinua. Nata awa Sebulonito Naftalira saisibunara zebu amira itinua. ");
INSERT INTO sue_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ago baro itai-matai wenu amire porofete Yesayara ge zo ego ine itia awa me wenua awa, ");
INSERT INTO sue_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zebu zo ou ubura kenara itewia amira Sebulonito Naftalira saisibuna nowera. Zebu awa ou Yodan enibara itia. Zebu amira zazo zo Galilaya. Ema Yudako meni amira kei awero nowera awa. ");
INSERT INTO sue_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Zebu amira ema dubu mumera nowera ami zasimai bamu gamunora. Betaira zumai amira nana nowera ema dubu amira nana zasimai kei awamunoya. Yesaya meni ge ago gaenua awa. ");
INSERT INTO sue_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Be amira ana Yesu meni zaawero utura ge toise ema bama ego tugata inoisonua awa, “Utura itewia ami imata Tua wero nuamunoya amira be zora awinoya, are nikare duba kapeteniu.” Ago toisonua awa. ");
INSERT INTO sue_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Are waiko zore Yesu meni Galilaya ou ubura kora-kora nomite ema eto maeto namire tamunua awa. Zo Simon zazo nuso zo Petoro, ata nami nuso Anderea. Nuto wo pumai ema, are nuto ou amira ana mona apitinoise noiwato tamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tamuro numoreto ego senua awa, “Nito muuto na ama ganaweto. Na nito gipana erama pumai ema waweto.” ");
INSERT INTO sue_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ago senu giro mona nusoto eya doro muro nu ama ganewato awa. ");
INSERT INTO sue_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ana eriro susaumite ema eto maeto namire da ago ine noko tamunua awa. Yakobo ata nami nuso Yohane nuto Zebedira mai eto awa. Nuto mama nusoto Zebedire dai wara itise mona nusokare kora inoiwa giro Yesu meni muro nu ama ganariseto senua awa. ");
INSERT INTO sue_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nu nuto zawa senu giro nuto mama wara ago doro nu ama ganewato awa. ");
INSERT INTO sue_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu meni Galilaya zebu zipinoise Yuda emara yere ibu sero witiro ge tugata inoise utura itewia ami imata Tua wero nuamunoya amira Oziga Ewanana tugata inoise ema yaya eure-taure puro noisowa awa kora inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ago inoinu bowi nuso Siria zebura te wenu niniro giro ema yaya-buyayare, ema bi nusokare nana mokara itai, ema eni aziamai, ata eni zabura wai ami dago eriro nuso nana muwa kora wero tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ago wenu Galilaya zebura, Dekapolis zebura, Yerusalem natera, Yudaya zebura, Yodan enibara ema dubu bamubake ami nuso nana kokouniro amire poti dara niro nu ama ganinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu meni ema dubu bamu awa giro dirumura witiro arumuro itinu bua mai nuso meni nuso nana zorage bamuwa amire ");
INSERT INTO sue_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nu ge ego toise ema bama sero gipero awenua awa. ");
INSERT INTO sue_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ema duba nusokare gawera osisinowia nukare ami yawa sara warise. Nera kota, nukare utura nata amira gegenai. ");
INSERT INTO sue_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ema duba nitinoise itewera nukare ami yawa sara warise. Nera kota, Anutu meni duba nusokare korawai nukare ewanana wamunora. ");
INSERT INTO sue_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ema zazo nusokare puro osisinowera nukare ami yawa sara waise. Nera kota, nukare Mama nusokarera zebu dapikarago pumamunora. ");
INSERT INTO sue_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ema tani saramai puro nuamu sero nenare oure emo betinowenakai ago ine inowera ami yawa sara warise. Nera kota, nukare pumara denamunoya. ");
INSERT INTO sue_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ema awa-diaire nowera ami yawa sara warise. Nera kota, Anutu meni nukare awa-diamunoya. ");
INSERT INTO sue_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ema duba etore kota, duba daimatare nowera ami yawa sara warise. Nera kota, nukare Anutu gamunora. ");
INSERT INTO sue_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ema bega kei awaise bua inowera ami yawa sara warise. Nera kota, nukare awa Anutu meni ‘mai bama dirire mata dirire naso’ asamunoya. ");
INSERT INTO sue_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ema eni tani saramai puro nuawera giro eni meni nukare doise bunise awinowera ami yawa sara warise. Nera kota, nukare utura nata amira gegenai. ");
INSERT INTO sue_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nikare dubu naso wero nuawa giro ema eni meni ge opi toise zazo nisokare puro osisinoise nikare dero tuninoise ge waya-kawaya nimorekare samunora, awa nikare yawa sara wewo. ");
INSERT INTO sue_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ago wara nikare duba ewanana inoise yawa sara weu. Nera kota, nikare utura ena zuma bamu pumamunowa. Porofete gita noisowa nukare awa da ago ine dero tunero awinoisowa. Amira te esa nusokare ama ganinowewa, are yawa sara wewo. ");
INSERT INTO sue_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Wo seka itima gugumusai azu, ema wo awa puro ewa meni anawera borere-barere ewanana itewia, da ago ine nikare zebura ema dapikarago ami emo ewa ine wero nowewa awa. Ota ewa bepa wamunoya, awa nakai nogo wanakai bapu nuso noko kei awamunoi? Tepo awa. Ewa bepa awa waya asero apawera erama meni patitinowera. ");
INSERT INTO sue_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nikare ema dapikaragora zasimai ine. Nata zo dirumura damu-damuke itai nena zo meni oko gogo wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ota nakai lam izimuro au meni oko wopunitinowenakai. Awa itai zara nusora potawenakai erama so du itewera awa te zasipitinowia. ");
INSERT INTO sue_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Are zasimai nisokare meni da ago ine eramara nana zasimaise. Ago wai nukare nuai nisokare gara ewanana wai Mama nisokare utura itewia awa bowi wamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nikare namore ego sanowa awa, ‘Nu Mosera lo gere porofetera gere disamu munua.’ Namore ago zo oko sawe. Ge awa tepo waise kota, me waise kei awena awa. ");
INSERT INTO sue_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na me memeka sane. Uture zebure itamunorato te Mosera lo ge da ago itamunoya awa. Ago inoise Mosera lo ge agewa-begewa da da awa dai itima oko tepo wamunoya. Awa me gege wero amire tepo wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Are ema zo meni lo ge pei-kaka mai zo dainitinoise eni da ago warise samunoya, awa utura itewia ami imata Tua wero nuamunoya be amire ema ami ema osai me osai wamunoya. Ota zo meni dipinoise eni da ago warise samunoya, nu awa utura itewia ami imata Tua wero nuamunoya be amire ema bamu wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Are sana niniu. Nikare lo ge gipai emare Farisayore amira etutiro nuai nusokare kaka dainamu wamunowa, awa nikare utura mokara oko toyamunowa. ");
INSERT INTO sue_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Apipie nasokaire ge zo ego sai awa, ‘Ni erama oko dasa betare. Zo nu mai dai betamunoya, nu awa ge buara gegenai wamunoya.’ ");
INSERT INTO sue_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ota nane meni awa nikare ego tugata inona awa: Zo nu otao nusore tini kapai tamamunoya, nu ami ge buara gegenai wamunoya. Zo nu otao nusore ‘Nima me waya’ ago samunoya, nu ema giti kopi dubura aunai amira gegenai wamunoya. Zo nu otao nusore, ‘Ni dau duba inagayai’ ago samunoya, nu awa so wayara baro niaora gegenai me wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Are ni altara dopero nena zo Anuture potamu inoise ego kotumamunosa, ‘Otao nasore ina-dua wai nasoto itia.’ ");
INSERT INTO sue_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ago sero nena niso demese potasa itai ni baro otao nisore ge kora weroto amire ewesemuro nena niso altara potase. ");
INSERT INTO sue_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ni zas nana baro ge bua wasise sara giro kaka kei awamure ebete noise amire ema ni gera potitinoya amire ge eya kora weyo. Ago kaka wamu wasa iwo niso meni ni eya zas nana potiro susu niso sai zas meni soldia nusore sai, ni benai sora potamunoya. ");
INSERT INTO sue_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na me sane. Ni ago itima tepo oko kei awamunosa. Otao nisora ina potasa tepo wero baitai amire ni kei damu namunosa awa. ");
INSERT INTO sue_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Apipie nasokaire ge zo ego sai awa: ‘Ni emata bama oko bewana wase.’ ");
INSERT INTO sue_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ota nane meni awa nikare ego tugata inona awa. Ema zo meni bama zo giro duba-duba wamunoya, awa bama awa duba meni emoko bewana wetia ago ine wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Are giti moka niso zo meni pasina wasise sai wamunosa, awa giti moka awa gusero apamunosa. Tama niso zere-dago puro nuasa so wayara niaora apara bayamesaya, saineba giti moka niso zo gera we. ");
INSERT INTO sue_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ota wana me niso meni ni pasinara potai wamunosa, awa wana awa kapero do. Tama niso zere-dago puro noma so wayara niaora bayamesaya, saineba wana niso zo gera we. ");
INSERT INTO sue_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Apipie nasokaire ge zo ego sai awa: ‘Zo nu bama nuso duamu wero giro bama duaira pas numore potiro amire bama iyetai bayaise.’ ");
INSERT INTO sue_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ota nane meni awa nikare ego tugata inona awa. Zo nu bama nuso bewana kaka wamu tepo duamunoya, awa nu bama nuso pasina bama waise wamunoya. Ota bama meni bewana wamunoya, awa ema nu dotinoise pasina oko dimamunoya. Zo nu bama ema zo meni donua awa atamunoya ami pasina wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Apipie nasokaire ge zo ego sai awa, ‘Ni Anutura nana giti mokara sai zewai wai ge niso awa opi-api oko sase. Ota sai zewai wai ge sero giro Tuara nana giti mokara dimuyo me wae.’ ");
INSERT INTO sue_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ota nane meni awa nikare ego tugata inona awa. Ge zo sasa ema bama gara me waise sero nena zora zazo zawa sero oko sase. Ota utura zazo zawa sero sai zewai wai awa ego emira duawise tona. Utu awa Anutura itai-matai nata. Are ni utura zazo zawa toise Anutura zazo dai zawa tosa ago inoya awa. ");
INSERT INTO sue_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Zebura zazo awa zawa sero sai zewai wai awa dai ego emira duawise tona. Zebu awa Anutura te guta wai awa. Are zebura zazo zawa toise Anutura zazo dai zawa tosa ago inoya awa. Ota Yerusalem natera zazo zawa sero sai zewai wai awa ego emira duawise tona. Yerusalem awa Tua bamura nata, are nata Yerusalemra zazo zawa toise Anutura zazo dai zawa tosa ago inoya awa. ");
INSERT INTO sue_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ota giti kopi nisokare zawa sero sai zewai wai awa dai duawise tona. Nera kota, nikare giti tu nisokare zo kapawai awa sawa inagayamita? Ota giti tu inagayai zo sawa kapawami? Awa tepo awa. ");
INSERT INTO sue_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Are nikare ge me samu wero giro “Iyo” gege, o “Tepo” gege ago sewo. Ge eni susumuro sai awa wayara mama amira nana ena tupewia. ");
INSERT INTO sue_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Apipie nasokaire ge zo ego sai awa, “Zo meni giti moka niso gayai gusai giro ina gayasa gusae. Ota zo meni di niso dai toumai giro ina de toumae.” ");
INSERT INTO sue_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ota nane meni awa nikare ego tugata inona awa. Ema waya meni nikare puro gera gaira wamu sara tama aiso nisokare oko soeu. Are zo meni opowa niso eniba dai giro eniba da ago poti dae. ");
INSERT INTO sue_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ota zo meni ni gera potiro tama woi niso zuma osai awa pumamu sai giro mo sawai niso zuma bamure awa dai numore poti pumae. ");
INSERT INTO sue_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ota soldia zo meni ni nena nuso dimuro puro eba apunu-kaka kilomita daimata bayasise sai ni nena nuso dipinoise eba iboi-tatana kilomita eto numore dai bamuyo. ");
INSERT INTO sue_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ota zo meni nena zo emo isa sai giro poti pumae. Ota nena niso zo tepo puro nuamu sai giro azu oko sase. ");
INSERT INTO sue_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Apipie nasokaire ge zo ego sai awa, “Ni otao niso kora weyo, ota iwo niso meni awa iwo we.” ");
INSERT INTO sue_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ota nane meni awa nikare ego tugata inona awa. Iwo nisokare otao wewo. Ota nikare dero tuninowera awa nukare emo Anutu isa seu. ");
INSERT INTO sue_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ago wamunowa, awa nikare Mama nisokare utura itewia amira mai mamai me wero nuamunowa. Nune ami sawi waiko nuso meni ema wayare kokore dapikarago zasimuro tepo inowia awa. Ota wa awa sawi ema ewananare ema nuai wayare amira nana te osisinowia awa. ");
INSERT INTO sue_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ema nikare duba bayao inowera nukare daba bayao wawa Anutu meni nogoro nikare gai ewanana wamunoi? Tani awa ema utura ge dotinowera ami dai inowera awa. ");
INSERT INTO sue_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nikare otao mamai nisokare gege otao wawa amire wai nisokare meni nogoro ema enira wai awa dainamunoi? Diga nukare da ago inoweri, tanita. ");
INSERT INTO sue_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ota ninekare meni awa utura Mama nisokare meni etutiro nowia amira te noiwo. ");
INSERT INTO sue_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nikare Tuara bua wanisekai sai awa tepo ema bama nikare bowi warise sero oko puro nuawe. Ago wawa Mama nisokare utura itewia ami nena kokopai nimorekare ina oko potamunoya. ");
INSERT INTO sue_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ni ema dumi pupinoise eni meni garise so oko pisamunosa. Opi ema me sao inowera ami yere ibura enata nata kakame ena ema dumi pupinowera awa eni meni giro nukare poti ike narise ago inowera awa. Na ge me nimorekare tona awa. Erama meni numorekare yawa sara inowera ami ina nusokare wawi tepo inowia. Noma ama ina ewanana zo oko pumamunora. ");
INSERT INTO sue_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ago ine oko wamunosa. Ni dumi pupinoise bayao niso awa bezero nebure oko sase. ");
INSERT INTO sue_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ago wasa dumi yagaba niso bezero itamunoya. Ago wai Mama niso nena bezai gosinowia ami ina ewanana nimore potamunoya. ");
INSERT INTO sue_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nikare isa samu wero giro opi ema me sao inowera ago ine oko wawe. Nukare yere ibura enata kakame ena dopero isa saira zewai inowera, awa ema bama meni giro nukare yaba warise ago inowera. Are ami ina nusokare wawi tepo inowia awa. Noma ama ina ewanana zo oko pumamunora. ");
INSERT INTO sue_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ota nima meni awa isa samu wero giro so nisora witiro so be gagatiro amire Mama niso bezero itewia amira nana isa seyo. Ago wasa Mama niso nena bezai gosinowia ami ina ewanana nimore potamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nikare isa tepo be meni daba oko sawe. Awa diga meni inowera amira tani. Nukare ami ge saisai isa tuanakai Anutu ninamunoya asinowera awa. ");
INSERT INTO sue_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Are nikare tani nusokare ine oko wawe. Mama nisokare meni nikare numore isa kaka samure nena kau inowewa awa gosinowia. ");
INSERT INTO sue_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Are nikare isa ego ine sewo: O Mama nasokare utura itewesa, zazo niso saramai itaise. ");
INSERT INTO sue_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mu, duba sero zebu sero amira Tua nasokare wase. Utura ena ge niso dipinowera, da ago ine zebura ena dimanekare. ");
INSERT INTO sue_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nena nai namorekare waiko be sero potitinowesa awa zeme potiyo. ");
INSERT INTO sue_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pasina ema eni meni namorekare inowera awa dotinonakare, da ago ine ni pasina nasokare doyo. ");
INSERT INTO sue_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ni nakare etetenaira oko potase. Ni nakare wayara mama amira nana wanera ena soero pumuyo. ");
INSERT INTO sue_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nikare eramara pasina duawa utura Mama nisokare meni pasina nisokare da ago ina duamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ota nikare eramara pasina puro nuawa Mama nisokare meni pasina nisokare da ago ine puro nuamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nikare Anutu emo nena nai sieniro noise benau nisokare oko yayare meni wago inoise nuawe. Opi ema me sao inowera ami ago wero benau nusokare awetu gutero nowera. Awa ema eni nukare sieniro nuai nusokare garise ago inowera. Na me sane. Erama meni numorekare yawa sara inowera ami ina nusokare wawi tepo inowia. Noma ama ina ewanana zo oko pumamunora. ");
INSERT INTO sue_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ota nine meni awa nena sieniro noise benau niso sewero giti tu niso kitaniro noiyo. ");
INSERT INTO sue_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ago wasa ema bama meni sieniro nuai niso oko gamunora. Mama niso bezero nowia ami imata gamunoya. Ago wero nu nena bezai gosinowia ami ina ewanana nimore potamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Wau nisokare awa zebura ena oko woi wawa itae. Zebura wau awa diko meni doinowera, o kayai wero waya inowia, o ema meni goma zausemuro bewana pupinowera. Are wau nisokare zebura ena oko woi wawe. ");
INSERT INTO sue_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wau nisokare awa utura ena woi wewo itae. Utura wau awa diko meni dai ine tepo, noko kayai wai ine tepo, noko ema meni goma zausemuro bewana pumai ine tepo. Are wau nisokare awa utura ena woi wewo itae. ");
INSERT INTO sue_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nera kota, masi wau niso itewia masi da amira duba niso itamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Giti moka niso awa tama nisora zasimai ine awa. Are giti moka niso ewanana itai amire tama aiso niso dago ewanana zasimaire itamunoya. ");
INSERT INTO sue_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ota giti moka niso waya wai amire tama aiso niso dago mume wamunoya awa. Are duba niso da ago awa. Duba niso meni mume wai, mume bamubake niso nana itamunoya. ");
INSERT INTO sue_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mai daimata meni dia ema etora nana sou bua wai te oko wamunoya. Awa nu zo otao inoise zore iwo wamunoya. Ota noko zo tuma didinoise zore biawa wamunoya. Nikare da ago ine Anutura sou bua ata wau monira sou bua awa eto dago wai ine tepo awa. ");
INSERT INTO sue_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Are na nimorekare sana niniu. Nikare nuai nisokare emo kotumu-katumu inoise ego oko sawe, “Nena nai nana tamamunonikai? Ou nai nana tamamunonikai?” Noko nikare tama aiso nisokare emo kotumu-katumu inoise ego oko sawe, “Tama woi nana tamamunonikai?” Nikare seu. Nuai nisokare meni meta nena meni me inoi? Tama aiso nisokare meni meta tama woi nisokare meni me inoi? ");
INSERT INTO sue_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nikare ni mamai kotumuro giu. Nukare bua zesise uriseta wo doise gaise awero oko ninowera. Nukare nena nai oko uru inowera. Ata utura Mama nisokare meni saineba nena nai nusokare tapinowia awa. Agoro nogo ni? Nikare osai nusokare ni? Awa tepo awa. Are nu nena ewa-gaewa nimorekare potamunoya. ");
INSERT INTO sue_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nisokare nana zo meni nuai nuso emo kotumu-katumu inoise noma waiko be eni nuai nusora susumai te wamunoita? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ago wai ine kaka itamu giro nogoro tama woire more emo pena-pana kotumu-katumu inowewi? Nikare ni ware ena agiti eriro uzi ditinowera amira susu awa kotumuro giu. Nukare asina araira bua oko inowera. Noko nukare mo gayaira bua oko inowera. ");
INSERT INTO sue_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ata na nimorekare tona ewa. Gita ema tua Solomon meni tama nuso simena-gaena wero baititinoisonua, ata simena-gaena wai nuso meni ni uzira simai awa oko daininua. ");
INSERT INTO sue_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ni uzi zeme ware ena ewanana ditinoya, ata auma awa erama meni wezero moyamunora awa. Ata saineba, Anutu meni sawi simai ewananare kei awero Solomonra simai ewanana awa dainitinowia. Anutu meni ago inowia, are nu nogoro nikare mo tama woi kaka tamamu wamunoi? O tuma diai besaire nikare, nu nikare mo tama woi ewa-awanana tamamunoya. ");
INSERT INTO sue_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Are nikare kotumu-katumu inoise ego pena-pana oko sawe. “Ne wero namunonikai? Ne puro nuamunonikai?” ");
INSERT INTO sue_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Awa diga meni kotumai nusokare amira potawera itewia awa. Nikare nena awa tepo ewanana oko nuamunowa, awa utura Mama nisokare meni ninitinowia awa. ");
INSERT INTO sue_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nikare duba nisokare poti utura ge nuso ata nuai saramai nuso amira niwo itae. Ago wawa nu amira tame nena dapikarago awa potai pumamunowa. ");
INSERT INTO sue_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Are yaya ama kei awamunora amira kotumu-katumu oko wawe. Aumara kotumu-katumu wai awa aumara gegenai daba. Waiko be sero amira yaya tamai nuso meni gegenai nuso itai te wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Anutu meni nikare gera potai azu, nikare zas meni wago wero ema eni gera oko potawe. ");
INSERT INTO sue_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nera kota, erama gera potitinoise ge samunowa, te Anutu meni nimorekare ina samunoya. Ota nikare nena eramare potamunowa, te Anutu meni nimorekare potamunoya. ");
INSERT INTO sue_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ni nogoro otao niso nana giti mokara wowo itia awa gosinoise niso nana giti mokara ni pena itia awa kaka giro baitamu inosi? ");
INSERT INTO sue_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ni pena niso nana giti mokara itai amire ni otao nisore ego sasa te wanoi? “Niso nana giti mokara wowo itia awa pumane.” ");
INSERT INTO sue_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Opi ema me sao inowewa, niso nana giti mokara ni pena itia awa gita pumuro amire giro baititinoise otao niso nana giti mokara wowo pumasa te wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nikare utura ge amira nena awa sunere oko potawe. Ota simai wau nisokare me awa pure oko apero duawe. Ago wawa nukare nena ago ine awa te meni patiro amire eya kapeteniro nikare gamamera. ");
INSERT INTO sue_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Nikare Anuture isa toma amire pumamunowa. Nikare tamaira bua inoma amire me tamamunowa. Nikare isa nisokare meni so be dago inoise nuawa Anutu meni ninamunoya. ");
INSERT INTO sue_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ema isa towera ami pupinowera. Ema tamaira bua inowera ami me tapinowera. Ema isa meni so be dago inowera amira isa awa Anutu meni ninitinowia. ");
INSERT INTO sue_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ota nisokare nana ema ai meni mai nuso ma emo sai yayau omata potamunoi? ");
INSERT INTO sue_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ota wo emo sai zi potamunoi? ");
INSERT INTO sue_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tepo awa. Nikare ema waya-kawaya meni mai awiso nisokarere nena kokopai potitinowewa awa. Are ego gosinonakai awa: Mama nisokare utura itewia ami erama dainitinoise ema isa towera amire nena ewa-gaewa witai potamunoya. ");
INSERT INTO sue_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nikare tani erama meni nimorekare warise yaba inowewa te ago ine numorekare wewo. Ami sai zewai wai ge dapikarago ata porofetera ge apikarago pumuro tepo inoya awa. ");
INSERT INTO sue_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Nikare nuai mera toyai-be pei-kaka amira toiwo. Gera wai nata amira toyai-be awa bamubake. Noko ebata nuso dai bamu. Amira erama witai meni susawewera awa. ");
INSERT INTO sue_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nuai mera nata amira toyai-be meni awa pei-kaka. Noko ebata nuso dai tama dai bamure. Are ema etokaka meni daba tapinowera awa. ");
INSERT INTO sue_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ge gipai ema opi nukare sao nusokare awa lamara ine, duba osai gege. Ata moka nusokare meni awa sunera moka ine, goroba me goroba. Are nukare uma wero baititinoise noiwo. ");
INSERT INTO sue_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ge nusokarera me awa giro amire susu nusokare gamunowa. Pura meni biza me duwai pumai ineta? Ota sasawara me nuso meni ona duwai pumai ine ni? ");
INSERT INTO sue_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tepo awa. Ni ewanana awa me ewanana zizinowia. Ni waya awa me waya zizinowia. ");
INSERT INTO sue_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ni ewananara ena me waya kei awai ine tepo awa. Noko ni wayara ena me ewanana kei awai ine tepo dai awa. ");
INSERT INTO sue_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Are ni zo me ewanana kaka kei awamu wai giro kapero ape niaora nai gege awa. ");
INSERT INTO sue_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Susu ago ine itia, are nikare ge nusokarera me awa giro amire susu nusokare gamunowa. ");
INSERT INTO sue_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ema meni namore “Tua naso, Tua naso” asinowera nukare te dapikarago utura mokara oko toyamunora. Mama naso utura itewia amira ge dipinowera nukare ami daba toyamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ema saisai meni be bamura ena ego ine namore samunora awa, “O Tua nasokare, nakare be nisora Anutura ge porofete meni sago wenakare. Ota be nisora bi tunenakare. Ota be nisora bua bamu wenakare.” ");
INSERT INTO sue_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ago sara na numorekare ego samunona awa, “Na nikare zo da di kaka gamu inona. Doro bozeu tepo wae, pasina ema nikare.” ");
INSERT INTO sue_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ema zo meni ge naso ei awa niniro dimamunoya, nu awa ema ninai bamure. Nu ema zo so nusora zasiwi ura me wamuro potinu dopenua ago ine awa. ");
INSERT INTO sue_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ago wenu itinu wa boruza osenu wama bamu muro so gaenu bisi bamu meni so awa denu so zewai wero itinua awa. Sora zasiwi gowero baitinua, are zewai wero itinua awa. ");
INSERT INTO sue_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ota ema zo meni ge naso ei awa niniro duamunoya, nu awa ema dau zo meni so nusora zasiwi tame dorou wenua, ago ine wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ago wenu itinu wa boruza osenu wama bamu muro so gaenu bisi bamu meni so awa denu yarasa awenua awa.” ");
INSERT INTO sue_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu meni ge awa tomite sero tepo wenu ema bama nukare ge diai nusora yaba inoise di tainiwa. ");
INSERT INTO sue_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Awa nera kota, nu gera susu meni ge diro baitinua. Awa lo ge gipai ema nusokare gipinoisowa, awa doro dainiro putoure senua awa. ");
INSERT INTO sue_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu meni dirumura ena osisinoinu ema bama dubu bamu ami nu ama ganero ");
INSERT INTO sue_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","osewa ema zo boya ayare meni nuso nana benaura zorage bamuro bawa diro koiniro ego senua awa, “Tua, ni putou niso itia, are ni na kora wamu wero giro kora wasa ewanana wamunona.” ");
INSERT INTO sue_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ago senu Yesu meni wana potiro tama nuso kimuro ego senua awa, “Na ago wamu kotupitinona, are boya niso wawa waise.” Ago tuaise boya nuso eya wawa wewa tama nuso ewanana wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu meni ago wero numore ego senua awa, “Tani nimore wetena amira bowi awa ema zore oko sase. Ni bamu, tama niso awa prisre gipasa gae. Ago inoise nena Mose meni Anuture potawise senua awa potasa yaya niso tepo wetia amira susu giro baitamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu meni Kapaneam nate baro noinu Roma soldiara giti kopi zo meni nuso nana kei awero nu zawa sero ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Tua, soumai naso yaya mou-mau puro sora duro itia.” ");
INSERT INTO sue_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ago senu Yesu meni ina ego senua awa, “Nane muro kora wamunona.” ");
INSERT INTO sue_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ago senu soldiara giti kopi meni ge ina ego senua awa, “Tua, na ema ewanana tepo. Are ni so nasora toyasa te oko wamunoya. Are ni ego itise amire ge daba sasa soumai naso ewanana wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Awa gosinona, nera kota, na ema babezinomara ama-zani nowena. Noko na soldia enira giti kopi. Are nusokare nana zo bayaise sana bayamunoya, ata zo maise sana mamunoya. Ota na soumai naso bua waise sana wamunoya. Are ni ego itise ge daba sasa soumai naso ewanana wamunoya, awa gosinona.” ");
INSERT INTO sue_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ago senu Yesu meni ge awa niniro di tainiro ema dubu nu ama ganinoiwa amire ego senua awa, “Na me nimorekare sane. Isreli ema nisokare nana ema tuma diai ago inere zo oko tapisena. ");
INSERT INTO sue_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Are ego tugata wana niniu. Waiko osaira enata witaira ena ema Yudako saisai meni kei awero Abrahamto Isakare ata Yakobo awa numorekare dai utura mokara auniro ana-bona wero arumuro ninoise yawa sara wamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ota ema utura mokara gegenai nunekare meni awa mumera baro di zawa gatero zarinoise itamunora.” ");
INSERT INTO sue_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ago sero soldiara giti kopire ego senua awa, “Ni bamu, tuma diai nisora me kei awamunoya.” Ago senu soumai nuso be da amire ewanana wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu meni Petoro nana sora witiro imeti-gagara nuso yaya tama mena-manare puro itinu ginua awa. ");
INSERT INTO sue_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Giro wana nuso zinu yaya bisi asenua. Ago wenu bama awa eriro Yesura nena sawenu ninua awa. ");
INSERT INTO sue_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tua zinu ema bama bi mokara itai dainiro puro kei awewa awa. Ago wewa Yesu meni bi nusokare be nuso meni tunenua awa. Ago inoise ema yayare dapikarago kora wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ago wenu porofete Yesaya meni ge ego gaenua awa me wenua. Nu yaya nasokai kora wai ewanana wamunonakai. Noko, nu mou nasokai dimamunoya. ");
INSERT INTO sue_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ema bama dainiro meni Yesu nana kei awero nu zimuwa giro bua mai nuso meni nu puro dawero ou ubu enibara potarise senua. ");
INSERT INTO sue_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Are bayamu sero inoiwa lo ge gipai ema zo meni nuso nana zora bamuro ego senua awa, “Gipai ema, ni nago nago bayamunosi awa na te ni ama ganamunona.” ");
INSERT INTO sue_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ago senu Yesu meni ina numore ego senua awa, “Wo zobina nukare awai masire. Noko ni mamai da ago nukare papamore. Ata na Emara Mai meni awa so-mara auka inoise nowena. Are eya na ama ganamu oko sase.” ");
INSERT INTO sue_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ago senu nusokare nana dubura zo meni numore ego senua awa, “Tua, ni ninasa na gita mama naso betai gowero amire ni ama ganane.” ");
INSERT INTO sue_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ago senu Yesu meni ina ego senua awa, “Ni na ama gane. Ema ititi tepo meni nuago inowera ami betai ema gowarise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ago sero wara witinu bua mai nuso witiwa amire bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Susauwa bisi bamu eya muro ewa gaenu kakawa eriro bamubake wenu ewa wa duru toinua. Ota Yesu meni awa gitawa inoinua awa. ");
INSERT INTO sue_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Are bua mai nuso meni baro awa-uzero ego sewa awa, “Tua, nakare soremu. Nakai dagimai sogo inonakai.” ");
INSERT INTO sue_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ago sewa giro ego senua awa, “Tuma diai nisokare bamuko. Nikare nogoro azu inowi?” Ago sero eriro kakaware bisire senenu so bisi binono denua awa. ");
INSERT INTO sue_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ago wenu ema meni giro di tainiro ego sewa awa, “Ema ei awa neni? Ata nena bamubamu bisire kakaware dabe ge nuso ninitinoweri?” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu meni ou ubu semuro Gadara emara zebu amira kei awenua awa. Kei awenu ema eto bi ditira ena muro nu tamuwato awa. Bi nusoto nana itasara nuto goroba bamu wasarato ema eni meni azu wero ebata amira muro baro kaka wamu inoisowa awa. ");
INSERT INTO sue_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Are nuto arero zawa gatero ego sewato awa, “Ni Anutura Mai meni namoreto ne wamu tupesi? Ni be bamu kaka kei awamure yaya bua namorekare potamu tupesita?” ");
INSERT INTO sue_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ota pu witai ami asikera kena ena nena ninoise itiwa. ");
INSERT INTO sue_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Are bi meni ge beina-baina wero Yesure ego sewa awa, “Ni nakare tunamu wero giro sasa pu dubu omira nana mokara toyanekare.” ");
INSERT INTO sue_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ago sewa giro nu numorekare ego senua awa, “Nikare bamuu!” Ago senu nukare ema eto doro bamuro pu dubu noiwa amira nana mokara toiwa awa. Ago wewa pu dapikarago sumai nusokare kei awenu pena-pana sumuro degara baro ou ubura dagimuro ou niro betero tepo wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ago wewa pu dia noiwa nukare dai bozewa awa. Bozero bamu nata bamura niro ge awa dapikarago kereniro sero tepo wewa awa. Nukare tani ema etora nana kei awenua amira ge uge awa wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Uge wewa giro nata bamura ema bama nukare dapikarago eriro Yesu tamamu muwa. Nukare muro nu giro numore ge zewai zawai toise nu zebu nusokare doro bayaise sewa awa. ");
INSERT INTO sue_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu meni wara witiro ou ubu noko semuro nata nuso nana bamunua. ");
INSERT INTO sue_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Baro kei awenu ema zo te-wana gigimai awa gogara potiwa duro itinu dimuro puro muwa awa. Ago wewa Yesu meni tuma diai nusokarera susu giro yaya emare ego senua awa, “Mai naka, ni azu oko wase. Zewai weyo. Pasina niso disero tepo inona awa.” ");
INSERT INTO sue_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ago senu Yudara lo ge gipai ema eni nukare duba nusokare meni ego kotumuwa awa, “Ema emi Anutu meni wago inoya, atonua!” ");
INSERT INTO sue_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ago kotupitinoiwa Yesu meni kotumai nusokare giro tepo wero ego senua awa, “Nikare nogoro ge waya kotupitinowi? ");
INSERT INTO sue_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nakai ema yayare amire ‘Eri, aita wase’ tepo ago sanakai nu kaka aita wamu wamunoya, awa nakai me namunonakai. Nera kota, ema bama meni ge nasokai gara opi wamunoya. Ata nakai ‘Na pasina niso disinona’ tepo ago samunonakai, awa nakai me oko namunonakai. Nera kota, ema bama meni ge nasokaira me awa gai ine tepo. ");
INSERT INTO sue_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Are na pasina disaira putou puro zebura nowena awa gawise sero na ge ei awa dai numore samunona: Na nimore ego tona, Eri, awai masi gogare niso puro niso nana bayase.” ");
INSERT INTO sue_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ago senu ema awa eriro nuso nana nate bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Are ema dubu bamu ami tani awa giro azu wero Anutu nu putou ago zo emara nana wanera potinua, awa giro nu bowi wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu meni ana eriro susaumite takis pumai ema zo zazo nuso Matiu nu takis pumaira sora itinu giro numore ego senua awa, “Ni mu, na ama ganase.” Ago senu giro eriro nu ama ganenua awa. ");
INSERT INTO sue_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ago wero nu Yesu so nuso nana ena nena naise senu witinu amire takis pumai ema ata Yudara lo ge dai ema witai ami kei awero Yesu bua mai nusore dai eroma nena niwa awa. ");
INSERT INTO sue_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ago inoiwa Farisayo meni nukare giro bua mai nusore ego sewa awa, “Gipai ema nisokare meni nogoro takis pumai emare Yudara lo ge dai emare dai itise nena ninori?” ");
INSERT INTO sue_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ago sewa ge awa Yesu meni niniro ina ego senua awa, “Ema yaya tepore meni dokta nana oko susawewera. Ata ema yayare meni gege dokta nana susawewera. ");
INSERT INTO sue_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nikare baro ge gayai ego itia amira susu kotumuro giu, Na Anutu meni zame moyaira kota, dumi pumaira ara tapinona. Na ema nuai nuso saramai asinoya awa zawa samu oko muna. Ata na ema pasina wai ema awa zawa samu muna.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Be amira ana Yohanera bua mai meni Yesu nana kei awero nu atata wero sewa awa, “Nakare ata Farisayo nakare nena nai sienitinoise nowenakare, ota bua mai niso meni awa nukare nogoro nena kaka sienamu inoweri?” ");
INSERT INTO sue_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ago sewa Yesu meni numorekare ina ego senua awa, “Ema bama ataira bona inoise itara ema nu bama atamunoya ami numorekare dai nuamunoya be amire duba nitinoise nena sienarise sawa ninamunorita? Tepo awa. Ota ama ema awa iwo meni puro bayara tepo wamunoya be amire nukare nena sienamunora. Da ago ine namore wara amire bua mai naso meni nena sienamunora. ");
INSERT INTO sue_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nakai mo toto takaniro gayamu sero mo sibi seka puro mo asora oko gainowenakai. Ago wamunonakai, awa mo seka meni zumai mo aso noko keyai toto bamubake wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nakai ou wain seka puro meme tata matura oko niginowenakai. Ago wamunonakai, awa ou wain meni dobu wero meme tata ziai bezai ou wainre meme tatare awa zainamunonakai. Nakai ou wain seka puro meme tata sekara niginowenakai. Ago wawenakai ou wain sekare meme tata sekare nuto neine itewerato awa.” Ago senua. Ge bezai awa tepo oko senua. Nukare susu ei awa garise sero senua: Nu nuai seka amira ge toisonua, are bua mai nuso meni Yudara tani matu awa doro tani seka gege puro nuamunonakai asenua awa. ");
INSERT INTO sue_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu nu ge awa toise itinu yere ibu dia ema zo meni nuso nana muro benaura koiniro ego senua awa, “Mai naso bama diri zeme betetia, ata ni puro bayana wana nuso nana tame potasa eramunoya.” ");
INSERT INTO sue_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ago sero bamunu Yesu meni eriro bua mai nusore dai dia ema awa ama ganero bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Susauwa bama zo orara pupinoise noe donu zepa 12 wenua ami Yesu nana ame bamuro Yesura tama woi tera ena kimunua awa. ");
INSERT INTO sue_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ago inoise nu nutope ego kotumunua awa, “Tama woi nuso gege kimuro ewanana wamunona.” ");
INSERT INTO sue_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ago kotumuro kimunu Yesu meni kapeteniro bama giro ego senua awa, “Mia naka, ni oko azu wase. Ni tuma diai nisora ewanana wetesa.” Ago senu bama eya ewanana wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ago wenu Yesu meni susaumite diara nana sora witiro bui pisai emare ema diti bamure ami dire buare inoise itiwa giro ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Nikare kei awero bamuu! Mai bama diri awa nu kaka betamu. Nu gitawa inoya.” Ago senu nukare nu isimuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ago wewa senu osero tepo wewa betai itinua amira nana baro mai bama diri wanera zinu erinua awa. ");
INSERT INTO sue_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ago wenua amira ge bowi meni zebu amira dago te wero bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu meni ana eriro susaunu ema giti guma wai eto meni nu ama ganero zawa toise ego sewato awa, “O Dawidira sibuna, ni nato emo zo amuyo.” ");
INSERT INTO sue_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu susaumite sora witinu nuto nuso nana zorage bamuro kei awewato awa. Nuso nana kei awewato giro Yesu meni nuto atata wero senua awa, “Giti moka kora waira putou naso nana itia asero gewato me weti mewitota?” Ago senu nuto sewato awa, “Iyo, Tua. Genato me inoya.” ");
INSERT INTO sue_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ago sewato giro nu giti moka nusoto kipinoise ego senua awa, “Tuma diai nisotora me nisoto nana kei awaise.” ");
INSERT INTO sue_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ago senu giti moka nusoto panenua awa. Ago wenu Yesu meni numoreto potai ge ego potinua awa, “Nito tani amira ge bowi ema enire oko saweto.” ");
INSERT INTO sue_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ago senua, ata nuto doro bamuro ge bowi nuso sero sero awewato zebu amira te wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yesu bua mai nusore ana eriro susauwa ema zo puro Yesu nana muwa awa. Bi zo nuso nana itinu nu ge amu noisonua. ");
INSERT INTO sue_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Are Yesu meni bi tunenu bamunu ema awa ge senua awa. Ge senu ema dubu bamu ami di tainiro ego sewa awa, “Isreli zebura ena gita nena ago ine zo oko kei awenu ginakai.” ");
INSERT INTO sue_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ago sewa awa, ata Farisayo meni Yesure ego sewa awa, “Bira giti kopi meni nu soremawi bi tuninowia awa.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Are Yesu nu ago inoise nata bamuta pei ni awa nu te noisonua awa. Ago inoise yere ibu nusokare sero toiro ge gipinoise Anutu imata Tua wero nuamunoya amira Oziga Ewanana tugata inoise noisonua awa. Ota ema yayare dapikarago kora wasai yaya nusokare bisi asero tepo inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Are nu ema dubu bamu awa giro nukare emo zo bamu wenua. Nera kota, nukare lama dubu dia tepo ine. Are nukare putou tepo duba nitinoise noisowa. ");
INSERT INTO sue_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Are nu bua mai nusore ego senua awa, “Nena buye ena zamuro itia, ata pumaira ema etokaka. ");
INSERT INTO sue_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Are nikare pumai buara mamere isa sawa nu nena pumai ema tamai bua nusora bayarise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu meni bua mai nuso 12 zawa senu muwa bi tunaira putoure yaya eure taure korawaira putou awa numorekare potinua awa. ");
INSERT INTO sue_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposolo 12 amira zazo nusokare awa ego ewa: Giti kopi Simon zazo nuso zo Petoro, nami nuso Anderea, Yakobo Zebedira mai, ata nami nuso Yohane, ");
INSERT INTO sue_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip ata Batolomiu, Tomas ata Matiu takis pumai ema, Yakobo Alifayora mai, ata Tadias, ");
INSERT INTO sue_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon Zelote ata Yudas Iskeriot nu noe Yesu kereninua awa. ");
INSERT INTO sue_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu meni bua mai nuso 12 awa nukare buara iyetitinoise ego senua awa, “Nikare ema Yudakora nana zebura oko bayawe, ata Samaria nata amira dai oko bayawe. ");
INSERT INTO sue_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isreli ema dubura lama tara awewenai amira nana daba bamuwo. ");
INSERT INTO sue_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Susawise ge ego ine tugata wewo: Anutu imata Tua wero nuamunoya amira be zora awinoya. ");
INSERT INTO sue_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ago inoise yayare awa kora weu. Ota bebetenai awa dai awa-uzeu. Ago inoise boyare awa kora weu boya wawa wae. Ota bi tuneu. Nikare putou awa zuma tepo pumewa, are nikare da ago bua awa zuma tepo weu. ");
INSERT INTO sue_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Moni bamuta moni pei-maai awa oko peniro puro bayamunowa. ");
INSERT INTO sue_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nikare ebete ena kaita oko desasenawe. Tama woi eto tepo, o sandol seka zo tepo, o bogi zo tepo, ago noiwo. Nera kota, bua ema nukare nena zuma tepo potai nai gege awa. ");
INSERT INTO sue_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Are nata zota zora kei awero giro gita ema kokopai zo kau wewo. Ago wero zo gawa ewanana wai giro so nusora witiro da ago gege awai-duwai inoma bamuwo. ");
INSERT INTO sue_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","So nusokarera wititinoise giro ego sewo, ‘Tuara gawa nisokare nana itaise.’ ");
INSERT INTO sue_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ago sawa sora mama meni ninai te wai giro ge nisokare meni nusokare nana ena me waise. Ota sora mama meni ninai te kaka wamu wai giro Tuara gawa nisokare nana ena gege me waise. ");
INSERT INTO sue_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nata zorata so zora bayawa nikare sawa kaka diamu wara, o ge nisokarera berea wai sara giro so awa doro bamuwo. Ago wero wowo nusokare te nisokarera itia awa deregiweu osae. ");
INSERT INTO sue_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na me memeka sane. Anutu meni erama awina-dawina inoise ina potamunoya be amire nata eto zazo nusoto Sodomto Gomorare amira ema ina mou tamamunora. Ota ge nisokare azu samunora nata amira ema meni awa ina mou-mau bamu tamamunora. ");
INSERT INTO sue_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sana niniu. Na nikare iyetitinona, awa lama eni abu sunara nana soe iyetai ago ine awa. Are nikare uma inoise noiwo. Ago wero goroba tepo betata-batata noiwo. ");
INSERT INTO sue_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nikare ema ite wero baititinoise noiu. Nukare nikare puro koto nusokarera bayamunora. Ata yere ibu nusokarera ena nikare wamu meni damunora. ");
INSERT INTO sue_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Awa daba kota, nikare bua mai naso nowewa amira ema giti kopira nanata ema tua nana puro bayara ge bua wamunowa. Are nikare nusokare nana benaurata noko diga nana benaura zewai wero Oziga Ewanana sero kereniwo. ");
INSERT INTO sue_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nukare nikare puro ema giti kopira nana potara ge nogo samunonikai asinoise kotumu-katumu oko wawe. Ina saira be kei awai amire ge samu wawa Ozana meni nimorekare ge potai samunowa awa. ");
INSERT INTO sue_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ge sawa ge nisokare oko wamunoya. Mama nisokarera Ozana meni duba nisokarera nuamunoya amira ge wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Namisini eni meni namisini nusokare betarise sero iwora wanera potamunora. Mamana eni meni mai awiso nusokare betarise sero iwora wanera potamunora. Mai awiso eni meni miamai mamana iwo inoise betarise sero iwora wanera potamunora. ");
INSERT INTO sue_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nikare zazo naso puro nowewa amira ema dapikarago nimorekare tini kapaire wamunora awa. Are zo nu zewai wero dopero noma betamunoya, nu awa Anutu meni soero pamunoya. ");
INSERT INTO sue_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Are nata zora nuawa dero tunara giro nata awa doro noko zora bamuwo. Na me sane. Nikare bua isusauma Isreli nata sero ena bua kaka wero pesunamu inuawa na Emara Mai meni noko kei awamunona awa. ");
INSERT INTO sue_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mai zota zo meni gipai ema nuso dainiro witai ine oko itia. Ota soumai meni ema tua nuso dainiro bamu wai ine awa dai oko itia. ");
INSERT INTO sue_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mai meni gipai ema nuso meni wago wai te wamunoya. Ota noko soumai meni ema tua nuso ine wai amire te wamunoya awa. Nukare namore Bira Mama asewa, are bua mai nasore da ago ine ge waya-kawaya samunora awa. ");
INSERT INTO sue_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ata saineba, susu nisokare bezero itia awa ama kei damu nai gamunora. Are nikare nukare giro azu oko wawe. ");
INSERT INTO sue_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ge eni nane bezero tugata inowena awa dubu bamura ena kereniu gare. Ota kiakara dana meni ninai awa dai damu damuke ena kereniro seu. ");
INSERT INTO sue_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tama aiso nisokare daba dero ititi nisokare damu inoise putou kau wamunora, nukare awa azu oko wawe. Tamare ititire eto dago musunai dega niaore amira bayamunoya amira putou awa nuso nana itia, nu awa giro azu weu. ");
INSERT INTO sue_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ni suriri awa nena me tepo, are maketira ena ni suriri eto amira zuma awa toea daimata gege. Ata Mama nisokare meni gai te kaka wamu wai zo oko duro betamunoya. ");
INSERT INTO sue_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ota ema nisokare nana meni awa Mama meni nikare dia wero baititinoise giti tu nisokare azimuro tepo inowia awa. ");
INSERT INTO sue_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ni suriri dainiro amira zuma awa bamu tepo, ota ninekare meni awa zuma bamure. Are nikare azu oko wawe. Mama meni gai te kaka wamu wai, nena waya zo nisokare nana tepo oko kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Zo nu emara nana benaura ena ‘Na Yesura mai wero nowena’ ago samunoya, awa nane ema amire utura Mama naso amira benaura ena ‘Nu awa mai naso’ ago samunona. ");
INSERT INTO sue_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ota zo nu erama nana benaura ena na begi wamunoya, nu awa nane utura Mama naso amira benaura ena ina begi wamunona awa. ");
INSERT INTO sue_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Na bega pumamu kota, ema bama zazaumamu sero muna awa. Are ge naso emo zazaumuro nuamunowa. ");
INSERT INTO sue_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mai mata dirire mamanare zaumamunora. Ata miamaire mai bama dirire zaumamunora. Babumanare imeti-gagarare da ago zaumamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dubu da ami zaumuro iwo ina-wa wamunora. ");
INSERT INTO sue_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Zo nu miata mama nuso ara tamai bamu inoise namore pei-kaka wamunoya ami gegenai naso wai ine tepo. Zo nu mai nuso mata dirita bama diri ara tamai bamu inoise namore pei-kaka wamunoya ami gegenai naso wai ine tepo. ");
INSERT INTO sue_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ota zo numa ni pasinai nuso dimuro na ama kaka wamu wamunoya, nu ami da ago ine gegenai naso wai ine tepo awa. ");
INSERT INTO sue_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Zo numa nuai nuso soyamunoya ami nuai nuso taragamunoya. Ota zo nu na emo inoise nuai nuso duamunoya ami nuai me tamamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ema zo nu nikare kora wamunoya, awa namore wetia ago ine wamunoya. Ota namore wamunoya, awa da ago ine na iyetinua amire wetia ago ine wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ema zo meni porofete zo porofete wero noi giro kora-makora wamunoya nu ami porofetera ina amira te pumamunoya. Zo nu ema etutiro nuai zo etutiro noi giro kora wamunoya ami ema etutiro nuaira ina amira te pumamunoya. ");
INSERT INTO sue_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na me memeka sane. Zo meni erama na ama ganinowera amira nana zo mai naso noi giro ou zobi-zabi dumuro potai namunoya, ou potamunoya ami ina nuso me pumamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu meni bua mai nuso 12 amire bua ge sero tepo wero ana eriro nata enira nana utura ge sero gipero awamu sero bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Are Yohane nu benai sora itise Kristo meni bua inoisonua amira bowi awa niniro giro bua mai nuso eni iyetinu ");
INSERT INTO sue_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","baro Yesu atata wero sewa awa, “Kristo maise sai awa ni awanita, ota zo mai gamu dia wamunonikare?” ");
INSERT INTO sue_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ago sewa Yesu meni numorekare ina ego senua awa, “Nikare ewesemuro baro nena gewa, o ge ninewa amira uge inoise Yohane tugata weu gae. ");
INSERT INTO sue_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Giti guma wai awa giti paninora; te waya wai awa noko aita inora; ema boya ayare awa tama ewanana inora; dana azai awa ge ninitinora; bebetenai awa seka ziro eritinora; ota bogamasa awa Oziga Ewanana ninitinora. ");
INSERT INTO sue_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Zo nu namore gai mou kaka wamu wamunoya ami yawa sara wamunoya.” ");
INSERT INTO sue_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ago senu Yohanera bua mai nukare ewesemuro susauwa Yesu meni ema diti bamu itiwa amire Yohanera ge ego tugata wenua awa, “Nikare Yohane nana ware gamu-gamura bamisewa, awa ema nogo wai awa gamu sero bamisewi? Nikare ema beyata zo bisi meni seba apawi muro baro awinowia ago ine gamu bamisewita? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nikare ema nogo wai awa gamu sero ware bamisewi? Ema zo tama woi nuso ewananare awa gamu sero bamisewita? Tepo awa. Ema tama woi ewananare nukare awa ema tuara sora itai-matai inowera. ");
INSERT INTO sue_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ota ema nogo wai awa gamu sero bamisewi? Porofete zo gamu sero bamisewita? Na sana niniu. Ema gamu sero bamisewa nu ami porofete inoise porofete noisowa awa dainitinoya. ");
INSERT INTO sue_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Numore awa ge gayai zo ego itia awa, Ei giu! Na oziga sai ema naso iyetamunona. Nu gita wero ebata niso kora wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na me memeka sana niniu. Yohane ge ou gutai zaawai ema ami zebura ema dapikarago dainitinoya. Ata Anutura natara gegenai zo osai me osai ami Yohane dainitinoya awa. ");
INSERT INTO sue_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yohane ge ou gutai zaawai ema ami bua pumunua be amira ana ema bama meni utura mokara toyamu sero ina-daina inoma ema putoure meni toyamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Porofete ata Mose ata nukare dapikarago Anutu imata Tua wero nuamunoya amira ge sise gaise awitupie dowa Yohane kei awenu porofetera ge ago dopenua awa. ");
INSERT INTO sue_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Are nikare ge nusokare gai me wai ine te giro ge ei awa giu me wae: Elia meni Soyai Emara ebata gita wero maise sai, awa Yohane awa. ");
INSERT INTO sue_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Zo nu danare meni ge ei awa ninaise. ");
INSERT INTO sue_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Are na ema bama zeme nowewa awa nena nera potiro sana te wamunoi? Nikare tani mai pei-mamaira ine inowewa. Mai pei-mamai nata kakame arumuro itise mai pei-mamai eni zawa sero ego tora awa, ");
INSERT INTO sue_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nakai ozina wamu nikare uzumuro boi detenakare, ata nikare yawa kaka wiamu wetewa. Noko nakare zo amaira dibia wetenakare, ata nikare dibia kaka wamu wetewa. Are nakare nogo wanakare gawa ewanana wamunoi?’ ago tora awa. ");
INSERT INTO sue_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohane meni bua nuso zaawero nena nai eni sienitinoise nuawi giro numore ego towewa awa, ‘Bi nuso nana mokara itia.’ ");
INSERT INTO sue_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Are na Emara Mai meni kei awero nena nise ou nise awawena giro namore ego towewa awa, ‘Giu! Nu ono nai ema. Nu ou wain pena-pana ninowia. Nu takis pumai ema ata Yudara lo ge dai ema amira otao.’ Ago towewa. Ata nato bua inowenato awa Anutura kotumaira inowenato amira susu awa bua nasotora me meni kerenawi ema bama gawera me inowia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu meni nata enira bua putoure dainiro inoise putou nusora susu kereninu giwa, ata duba kaka kapetenamu wewa. Are ge zaawero ego toise nukare ziro senenua awa, ");
INSERT INTO sue_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Yei Korasin ema! Yei Besaida ema. Mou bamubake nisokare nana kei awamunoya. Na tani putoure eni nisokare nana ena inowena awa na nata Tayato Saidonre amira ena wamena sia, awa nukare emoko duba kapeteniro pasina nusokare kotumuro duba nitinoise mo tama guigi-gaigi wai awa awero awetu gutero itamera. ");
INSERT INTO sue_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Are sana niniu. Anutu meni erama awina-dawina inoise ina numorekare potamunoya be amire Tayato Saidon natara ema bama meni ina osai tamamunora. Ota ninekare meni awa ina nisokare bamubake tamamunowa. ");
INSERT INTO sue_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ota nikare Kapaneam ema, ema bama meni zazo nisokare de ike namunorita? Tepo awa. Nukare zazo nisokare puro osamunora. Nisokare nana tani bamu kei awisia ago ine Sodom nate ena kei awami sia, awa nata awa oko sisamia. Zeme ewa itamia. ");
INSERT INTO sue_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Amira sana niniu. Ama Anutu meni ema bama awina-dawina inoise ina potamunoya be amire Sodom natara erama meni ina mou tamamunora. Ota ninekare meni awa ina mou-mau bamu tamamunowa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Be amire Yesu meni ge ego senua awa, “O Mama, ni uture zebure amira Tua. Nukare nutopekare gawera ema bamu inowera ema ago ami gai azu, ni putou nisora susu bezinowesa. Ota nukare nutopekare gawera mai morua inowia numorekare awa kerenitinowesa. Are na amira ni bowi inona. ");
INSERT INTO sue_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O Mama, ni ago gege wamu ara tapinowesa.” ");
INSERT INTO sue_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nu ge awa Mamere sero tepo wero ego senua awa, “Mama naso meni nena bamubamu dapikarago awa wana nasora potinua. Ema zo meni na Mamera Mai amira susu awa oko gosinowia; Mama meni imata gosinowia. Da ago ine ema zo meni Mamera susu oko gosinowia; na Mai meni imata gosinowena. Ota na Mai meni Mamera susu ema enire gipinowena, nukare ami Mamera susu gosinowera. ");
INSERT INTO sue_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nikare sai zewai wai ge dimamu kaputitinoise mou dipinowewa ami naso nana muwo. Muro zanatiai me tamawe. ");
INSERT INTO sue_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na duba osaire awa-diaire nowena, are naso nana muro anapa nasora agewa pumuro dipinoise susu naso giro baitawe. Ago wawa ititi nisokare zanatiro baitae. ");
INSERT INTO sue_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Anapa naso nimorekare potamunona awa ewanana. Ota nena ninekare dimawise potamunona awa peu-pepesa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ama Sabat pura zo amire Yesu gita wenu wuit bua soe bamuwa awa. Susawise bua mai nuso meni meri betero wuit me zisero niwa awa. ");
INSERT INTO sue_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ago wewa Farisayo ema nukare awa giro Yesu tugata wero ego sewa awa, “A gi! Bua mai niso bua inora awa lo meni Sabat pura bere tani awa wai azu sai itia.” ");
INSERT INTO sue_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ago sewa giro Yesu meni ego senua awa, “Dawidi ata ema eni numore dai noisowa amire nukare meri betinoise tani zo wewa amira uge awa nikare kaka azimuro gamu meni sago inowa, atonua! ");
INSERT INTO sue_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nukare Anutura ibu amira toiro ame Anutura giti mokara potitinoisowa awa puro niwa awa. Ame awa nukare ema osai meni nai ine tepo. Pris ema meni gege narise sai awa. Ata nukare niwa Anutu meni ginu waya oko wenua. ");
INSERT INTO sue_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ota ge zo lo bukura gayai itia awa nikare azimuro susu nuso kaka gamu inowewita? Ge awa ego ewa. Pris ema nukare Sabat pura bere ibu bamura ena bua inoise pura sisawera pasina oko inowia. ");
INSERT INTO sue_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ota nane sana niniu. Sai naso meni ibu bamura bua awa dainitinoya. ");
INSERT INTO sue_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ge gayai zo ego itia ewa, Na Anutu meni zame moyaira kota, dumi pumaira ara tapinona. Nikare ge amira susu ninamewa sia, awa bua mai naso pasina tepo emire ge oko samewa. ");
INSERT INTO sue_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na Emara Mai meni Sabat pura amira Tua wero nowena awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ago sero ana bamuro yere ibu nusokare zo amira witinua awa. ");
INSERT INTO sue_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Witinu ema zo wana nuso amai ami ago itinua awa. Are ema eni meni Yesu gera potamu sero, nera ikoniro gera potamunonikai asero nu atata wero sewa awa, “Ema Sabat pura zore kora wai awa te inoita?” ");
INSERT INTO sue_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ago sewa Yesu meni be nusokarera pumuro ego senua awa, “Nisokare nana zo meni lama nuso daimata Sabat pura zo amire duro urara osai nu kaka duamu wana meni ziro zumai witamunoi, tanita? ");
INSERT INTO sue_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Lama awa nena me tepo awa. Ota erama meni awa nena me awa. Are Sabat pura bere bua kokopai awa wai ine te awa.” ");
INSERT INTO sue_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ago sero emare ego senua awa, “Wana niso zuzuti.” Ago senu wana nuso zuzutinu ewanana wero zore dai te wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ago wenu Farisayo nukare tani awa giro dapikarago bamuro Yesu dara betaise sero ge sero gatero awewa awa. ");
INSERT INTO sue_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu meni ge awa niniro giro nata awa doro bamunua awa. Nata awa doro bamunu ema saisai meni nu ama ganewa giro yayare awa kora wenu ewanana wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ewanana wewa Yesu meni nukare ema enire susu nuso kerenai azu ge zewai-zawai senua awa. ");
INSERT INTO sue_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ago wenu ge gita Anutu meni senu porofete Yesaya meni gaenua, ge awa me wenua awa. Ge awa ego ewa, ");
INSERT INTO sue_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ei awa mai sou naso. Na nu awa giro pumuna awa. Nu wama naso. Na nu ara tapinona. Na Ozana naso nuso nana tame potana soremai nu diga emare nuai sonaira ge sero gipero awamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nu ge bawaita sero gunai awa oko wamunoya. Ota ge nusora awi kakame ena oko kei awai ninamunora. ");
INSERT INTO sue_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nu erama toku toumai ine awa waya wamu kota, kora wai zewai wamunora. Nu erama lamra wuiki kayai wai ine awa sisamu kota, kora wai ewanana wamunora awa. Ago inoise bua zizinuai sonaira ge meni nena bamubamu awa dainitinoise ewanana kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ago wai diga ema nani-nani ami nu tuma diamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ema zo bi meni mokara toinu giti guma wenu ge sai ine tepo inoisonua ema awa eni meni puro bamu Yesu nana niwa awa. Ago wewa Yesu meni kora wenu giti moka nuso panenu ge ina-sa wewato awa. ");
INSERT INTO sue_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ago wenu ema bama dubu bamu itiwa ami giro di tainiro yaba dasiga inoise ego sewa awa, “Dawidira sibuna maise sai awani, tanita?” ");
INSERT INTO sue_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ago sewa Farisayo meni ge awa niniro ego sewa awa, “Bira giti kopi zazo nuso Bielsebul ami nu soremawi bi tuninowia awa.” ");
INSERT INTO sue_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ago sewa Yesu meni kotumai nusokarera susu giro ge nusokare ina samu sero zebura potiro ego senua awa, “Zebu zo amira ema nukare awiniro ina-da wamunora, awa zebu awa eya zasu wero posamunoya. Ota nata zota dubu zo amira ema nukare awiniro ina-da wamunora, awa nata awa zewai oko itamunoya. ");
INSERT INTO sue_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Are Satanra dubu awiniro noise ina-da wamera sia, awa putou nuso sisero tepo wamia. ");
INSERT INTO sue_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Agoro na Bielsebulra putoura bi tuninowena asinowa, ge awa me sia, awa mai awiso nisokare bi tuninowera ami ara putoura bi tunameri? Nukare Anutura putoura bi tuninowera, are nunekare ami opi sai nisokarera susu kerenamunora. ");
INSERT INTO sue_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nama awa Anutura Ozana meni soremawi bi tuninowena, are Anutu imata Tua wero nuamunoya amira putou nisokare nana emoko kei awero itewia. ");
INSERT INTO sue_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ota zo meni ema putou bamure zo itai so nusora witiro wau nuso soero pumai awa te inoita? Awa tepo awa. Nu ema putou bamure awa gita beniro amire wau nuso soero pumamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Zo nu namore otao kaka wamu wamunoya ami namore iwo wamunoya. Noko zo nu na sorepitinoise poti dara nai bua naso kaka wamu wamunoya ami siso sis wai bua wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Are sana niniu. Eramara pasina susu giti ata Anutu isimaira ge susu giti awa disai ine te awa. Ata zo nu Ozana isimamunoya, ema amira pasina meni awa disai ine tepo awa. ");
INSERT INTO sue_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Zo nu na Emara Maire ge waya samunoya, awa Anutu meni pasina awa disamunoya. Ata zo meni Ozana sero ziamunoya awa pasina nuso zeme zebura enata ama utura ena disai tepo wai ine tepo awa. ");
INSERT INTO sue_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nikare ni zore ‘ewanana’ ago sero giro me nusore da ago ine ‘ewanana’ asewo. Ota ni zore ‘waya’ asero giro me nusore da ago ine ‘waya’ asewo. Nera kota, ni me meni nira susu kerenitinowia awa. ");
INSERT INTO sue_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nikare zira saisibuna, nikare waya meni nogo wero ge ewanana samunowi? Duba meni denenu itewia amira te be meni kereniro towia. ");
INSERT INTO sue_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ema kokopai awa kotumai kokopai nuso nana mokara itewia, are nu tani kokopai inowia. Ema waya awa nu kotumai waya-kawaya nuso nana mokara itewia, are nu tani waya-kawaya inowia. ");
INSERT INTO sue_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ata nane sana niniu. Ge giti agu towewa awa Anutu meni erama awina-dawina inoise ina potamunoya be amire ge amira ge bua wamunowa awa. ");
INSERT INTO sue_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Awa nera kota, ge towesa ami susu niso kerenai ewanana wai Anutu nana kotora ena ewanana wamunosa. Ota ge towesa ami susu niso kerenai waya wai Anutu nana kotora ena duwamunosa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ago toise tugata wenu lo ge gipai ema eni ata Farisayo eni nukare ami ge ego ine kapeteniro sewa awa, “Gipai ema, nine tani putoure zo we kei awai ganekare.” ");
INSERT INTO sue_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ago sewa ina ego senua awa, “Nikare ema waya-kawaya. Ema meni bama soa patitinowia da ago ine nikare Anutu soa patitinowewa. Nikare tani putoure zo wana gamu towewa. Ata nikare tani putoure zo oko gamunowa. Tani gita porofete Yonara nana kei awenua, da ago ine kei awai gamunowa. ");
INSERT INTO sue_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona nu pi waiko be etorobara ago wo bamu amira nana ogobera itinua, da ago ine na Emara Mai meni pi waiko be etorobara ago zebu mokara itamunona. ");
INSERT INTO sue_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Anutu meni erama awina-dawina inoise ina potamunoya be amire Niniwe ema meni eriro ema bama be zeme nowewa amira susu kerenara mou dimamunowa. Awa nera kota, Niniwe ema Yona meni Tuara ge tugata wenu niniro duba kapeteniwa. Ata na ego dopero itena ami Yona dainitinona. ");
INSERT INTO sue_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ota Siba zebura bama tua nu dai eriro ema bama zeme nowewa amira susu kerenai mou dimamunowa. Awa nera kota, bama ami Solomonra kotumai bamubake awa sai ninamu tama dero zebu zora-zarako amira ena munua awa. Ata na ego dopero itena ami Solomon dainitinona. ");
INSERT INTO sue_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Bi meni emara nana mokara ena kei awero zanatiaira masi ware ena tamamu bayamunoya. ");
INSERT INTO sue_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Baro kaka tamamu inoma giro ego samunoya, “So naso doro musena da amira noko ewesemuro bayamunona.” Ago sero baro so awa wazero kora wetera besuma sumuro itia awa gamunoya. ");
INSERT INTO sue_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Awa giro noko bamuro bi otao mamai 7 awa nu ine kota, waya me waya awa puro muro so da amira toiro itai-matai wamunora awa. Ago wara ema awa gita waya noisonua ami be amire waya me waya wamunoya. Are ema dubu waya zeme nowera amira nana ena da ago ine kei awamunoya awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu nu ge awa tugata inoise noinu nusokare nana atune ena mia namisinire nuso meni ge numore samu sero nu dia itiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ago itiwa ema zo meni Yesure ego senua awa, “Mia niso namisinire nukare ge nimore samu sero muro atune dopero itera.” ");
INSERT INTO sue_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ago senu Yesu meni ge ina ego senua awa, “Agai mia naso wero nowi? Arekare namisini naso wero noweri?” ");
INSERT INTO sue_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ago sero bua mai nuso ago itiwa amira nana wana uzuzu wero ego senua awa, “Giu. Miamai namisini naso ewa. ");
INSERT INTO sue_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Zo nu Mama naso utura itewia amira ge niniro dipinowia nu ami namita, nubamata, mia naso inoya awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Waiko be amire Yesu meni sora ena osero ou ubura kora bera arumuro itinua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ago itinu ema bama dubu bamubake meni nuso nana kei awewa awa. Kei awewa giro numa wa zora witiro arumuro itinu ema dubu bamu meni awa nukare ete dopewa awa. ");
INSERT INTO sue_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ago wewa Yesu meni ge bezai eni toise kotumai dainiro numorekare tugata inoinua. Tugata inoise ge ego senua awa, “Sana niniu. Ema zo meni nena we buye apamu sero bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bamuro nena we buye ena apitinoinu we eni meni awa ebete ena duuwa. Ago duro damu-damuke itiwa ni mamai meni tamuro niro tepo wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ota we eni meni awa zebu omata tame kara-kara wai amira duuwa awa. Zebu awa tumou tepo, are we ami eya eriwa awa. ");
INSERT INTO sue_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ago wero tatawi nusokare iboboi tepo, are waiko meni witiro moenu binero betewa tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ota we eni meni awa zebu iwera tatawi itiwa amira duuwa awa. We awa iwere dai dapikarago te tetemo eriro iwe meni nena awa denu me kaka ziamu wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ota we eni meni awa zebu me gawire amira duro eriro zamuro me saisai ziwa awa. Nena duro eriwa amira zora me nuso 100, zora me 60, ota zora me meni awa 30 ago kei awewa awa. ");
INSERT INTO sue_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Are zo nu danare meni ge ei awa ninaise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ge ago senu bua mai nuso meni nuso nana zora bamuro atata wero sewa awa, “Ni nogoro ge bezai eni awa numorekare towesi?” ");
INSERT INTO sue_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ago sewa Yesu meni ina ego senua awa, “Anutu imata Tua wero nuamunoya amira ge bezero itewia, amira susu awa nikare ninawise sai itia awa. Ata eni bamu awa tepo awa. ");
INSERT INTO sue_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Zo nu nena numore potai awa puro nuai giro noko mema potana nu zamai bamu tamamunoya. Ota zo nu nena numore potai awa doro tepo nuai giro na nena nuso soero pumana nu tepo nuamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nukare giti moka nusokare meni gosinowera, ata oko giro baititinowera. Ota dana meni uge ninitinowera, ata ugera susu awa oko giro baititinowera. Amira na ge bezai awa numorekare towena. ");
INSERT INTO sue_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Are ge zo porofete Yesaya meni gaenua ge awa nusokare nana ena me inoya. Ge ego awa, Nikare dana meni ninai awa ninamunowa, ata duba meni niniro baitai awa oko ninamunowa. Nikare giti moka meni gai awa gamunowa, ata nena giro baitai meni awa oko gamunowa. ");
INSERT INTO sue_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ema dubu ei awa nukare kotumai tepo. Ata nukare dana nusokare meni azai, are ge kaka ninamu inowera. Ota nukare giti moka nusokare sikimuwa. Ago kaka wamu wamera, awa giti moka meni nenara susu gamera; o dana meni gera susu ninamera; o duba meni nenara susu niniro baitamera. Ago kaka wamu wamera, awa nukare duba kapetenara na nukare kora wamena. ");
INSERT INTO sue_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ninekare meni awa giti moka panero giro baititinowewa. Noko dana potiro ninitinowewa. Are nikare yawa sara inowewa. ");
INSERT INTO sue_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Na ge me sane. Gita porofete dainiro ata etutiro nuai ema dainiro nukare ami nena gosinowewa awa gamu yaba inoisowa, ata nukare kaka gamu inoe bebeteniwa. Nukare ge ninitinowewa awa ninamu yaba inoisowa, ata kaka ninamu inoe bebeteniwa. ");
INSERT INTO sue_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Are nena me buye apaira ge bezai sesena amira susu awa kereniro sana niniu. ");
INSERT INTO sue_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nena we eni ebete ena duuwa amira susu ego ewa: Ema zo utura ge ninawi susu kaka kei awamu wawi pasinara mama meni nuso nana kei awero utura ge duba nusora toitinowia awa puro tara awinowia awa. ");
INSERT INTO sue_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ota nena we eni awa zebu omata tame kara-kara wai amira duuwa, amira susu ego ewa: Zo nu utura ge niniro eya pumuro yawa sara inowia. ");
INSERT INTO sue_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ata nu tatawi tepo, are nu be pei-kaka gege Tuara ebatara nuamunoya. Ago wero iwore gorobare utura ge emo kei awai nu eya duamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ota nena we eni iwe soe duuwa amira susu ego ewa: Zo nu utura ge ninitinowia, ata nu zebura nena emo kotumu-katumu wawi wau moni meni nu etete nitinowia, are tani ago ami utura ge gogowawera me oko kei awinowia. ");
INSERT INTO sue_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ota nena we eni zebu gawire amira duuwa amira susu ego ewa: Zo nu utura ge ninawi susu kei awinowia. Nu ami me zizinowia. Amira we zora nana me 100, zora nana 60, zora nana 30, ago ine kei awinowia awa.” Ge ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ago sero ge bezai zo dai ego toise senua awa, “Utura itewia ami imata Tua wero nuamunoya amira susu awa ego emira potiro sana te wae. Ema zo meni wuit me ewanana buye apenua. ");
INSERT INTO sue_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Me apenu amire pi tumoure iwo nuso meni kei awero wuit amira soe ena iwe zo dara nuso wuitra ine amira me awa puro baro apero doro tara awenua. ");
INSERT INTO sue_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ago wenu wuitre iwere te eriwa awa. Eriro me ziwa amire iwera benau kei damu ninua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ago wenu mai sou meni giro buara mama tugata wero ego sewa awa, “Ema tua, ni bua nisora nena me ewanana gege apisesa, ata iwe meni nana muro eritinoi?” Ago atata wewa senua awa, ");
INSERT INTO sue_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Awa iwo zo meni apisia ami eritinoya.” Ago senu noko atata wero sewa awa, “Agoro baro iwe awa sokanisekare kotupitinosita?” ");
INSERT INTO sue_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ge ago sewa ina ego senua awa, “Tepo. Nikare iwe sokinoise wuit dai sokamewa dowo. ");
INSERT INTO sue_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wuit awa iwere dai te itise erariseto. Ama wuit me pumaira be kei awai amire bua waira ema meni gita iwe sokero niaora moyamu sero tiarise samunona. Ata wuit me meni awa so nasora zuanarise samunona.” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu meni ge bezai zo ego senua awa, “Anutu imata Tua wero nuamunoya, awa ni mastet asinowenakai amira me ine awa. Ema nukare ni me awa bua nusokarera urinowera. ");
INSERT INTO sue_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ata urawera eriro ni pei-mamai zepa da gege itai awa dainiro bamu inowia. Ago wawi bona nuso babezinoma kei awawera ni mamai meni duga nusora muro bonara zau potitinowera.” ");
INSERT INTO sue_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu meni ago sero ge bezai zo ego ine dai senua awa, “Anutu imata Tua wero nuamunoya amira susu awa yis ine. Bama zo meni tewa bamu zora plaware yisre potiro dawenu yis sisiniro plawa pumunu dobu wenua awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu meni ema ge tugata inoisonua, awa ge bezai daba toisonua awa. Ge kereniro kaka samu wenua. ");
INSERT INTO sue_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ago wenu porofete zo meni gita ge ego senua awa me wenua awa, Na ge bezai toise kotumai bezai zebu kei awenua da amira ana kei awero munua awa kerenamunona. ");
INSERT INTO sue_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu meni ema potinu susauwa nu so nusora witinua awa. Witiro itinu bua mai nuso meni nuso nana baro ego sewa awa, “Ni wuit buye ena iwe eraira ge bezai sesesa amira susu awa se ninanekare.” Ago kerenaise sewa giro senua awa, ");
INSERT INTO sue_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","“Ema we ewanana apenua nu awa Emara Mai. ");
INSERT INTO sue_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Bua awa zebu bamu amira te awa. We ewanana awa utura gegenai dubu awa. Ota iwe meni awa pasinara mama amira mai awiso. ");
INSERT INTO sue_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iwo meni iwe me apenua awa Satan. Wuit me pumaira be awa be bamu. Bua waira ema awa angelo dubu. ");
INSERT INTO sue_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Iwe sokero niaora moinowera susu da ago ine awa be bamura ena kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Be bamura ena na Emara Mai meni angelo dubu naso iyetana osero pasina awita saira nena ata ema pasina inowera awa dapikarago Tua waira masi naso amira ena sia-saya niro ");
INSERT INTO sue_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","niao zewai-zawai itai gege itai amira apamunora awa. Ago wara ana di zawa gatero zarinoise itamunora. ");
INSERT INTO sue_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Be amire etutiro nuai ema nukare Mama nusokarera nana noise waiko zasipitinowia ago ine zasimamunora. Zo nu danare meni ge ei awa niniro baitaise. ");
INSERT INTO sue_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Anutu imata Tua wero nuamunoya amira susu awa ego awa. Maguru zo wau bamure notu zora bezai itisonua, awa ema zo meni tamuro noko bezenu dago itinu nu yawa sara inoise neu-nau nuso awa dapikarago emare potiro tepo wenu numore omata potiwa puro bamuro notu awa zuma gaero pumunua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Noko Anutu imata Tua wero nuamunoya amira susu awa ego awa. Ema zo nu pu dire suna dire tamaira bua wenua. ");
INSERT INTO sue_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tamai bua inoe ewanana zo tamuro neu-nau nuso dapikarago emare potiro tepo wenu numore omata potiwa puro bamuro pu dire zaimare awa zuma gaero pumunua awa.” Ago senua awa. Nakai zebura nena me tepo awa doro kotumai nasokai poti utura niro nuanisekai amira senua. ");
INSERT INTO sue_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu meni ego senua awa, “Anutu imata Tua wero nuamunoya amira susu awa mona ine. Ema meni mona ewara apewa mona meni wo neire neire zumunua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ago wero wo be munu zumuwa ete witinu ema arumuro wo siana-katana inoise wo nai meni awa pumuro poti tewara niwa. Ota napu meni awa apero dowa awa. ");
INSERT INTO sue_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Zebura be tepo wai amire susu ago ine kei awamunoya. Be amira ana angelo nukare zebu sero bamuro ema ewa-gaewa nana soe ena ema waya-kawaya siana-katana wero ");
INSERT INTO sue_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","niao zewai-zawai itai gege itai amira apara bayamunora awa. Ago wara ana di zawa gatero zarinoise itamunora.” ");
INSERT INTO sue_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu meni ago sero atata wero senua awa, “Nikare ge dapikarago amira susu niniro baititinowita?” Ago senu nukare sewa awa, “Niniro baititinonakare.” ");
INSERT INTO sue_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ago sewa giro ego senua awa, “Bua mai naso zo meni Anutu imata Tua wero nuaira susu awa ninitinowia ami sora mama ine wero noise maguru nusora ena nena neire neire sekare mature dapikarago pupinuamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu meni ge bezai neire neire awa tomite sero tepo wero zebu awa doro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ago wero nata nuso nana kei awero yere ibu nusokarera witiro utura ge tugata wenu ema meni di tainiro ego sewa awa, “Ema ami ninai bamu amire tani putoure wai amire awa nana tamunu? ");
INSERT INTO sue_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nakai susu nuso gosinonakai. Nu kapentara mai awa. Mia nuso zazo Maria. Ota namisini nuso zazo nusokare Yakoboto Yosefere ata Simonto Yudare. Ata nubabumana nuso dapikarago awa namorekai dai nowera. ");
INSERT INTO sue_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ata ema ami nena bamubamu awa nana tamunu?” ");
INSERT INTO sue_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ago sero numore kotumai waya pumuwa awa. Ago wewa Yesu meni numorekare ego senua awa, “Porofete nukare ema zazore. Ata nata nusokarera ena, o mama nusokarera nana ena nukare ema zazore tepo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nata amira ema nukare nu tuma kaka diamu wewa, are nu tani putoure saisai nusokare nana ena oko wenua. ");
INSERT INTO sue_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Be amira ana ema tua Herode meni Yesura ge bowi nininua awa. ");
INSERT INTO sue_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Niniro bua mai nusore ego senua awa, “Yohane ge ou gutai zaawai ema nune ami betaira ena eriro nowia, are nu tani putoure inowia.” ");
INSERT INTO sue_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ge awa tepo oko senua. Herode nu gita emoko nami nuso Filip amira bama soero pumunua, zazo nuso Herodia, bama ami emo wero senu soldia baro Yohane tere wanere beniro puro poti benai sora niwa. ");
INSERT INTO sue_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Awa Yohane meni ge ego senua amira wenua, “Ni bama awa pumusa te oko inoya.” ");
INSERT INTO sue_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ago senu Herode meni Yohane damu kotupitinoinua awa. Ata ema bama meni Yohanere porofete asinoisowa, are Herode meni nukare azu wero donua awa. ");
INSERT INTO sue_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Are Herode kei awai be nuso munu giro ema babezinoma senu nuso nana kei awero auniro itiwa Herodiara mai bama diri ami nusokare nana benaura yawa wienu Herode meni ginu ziri wenu giro ");
INSERT INTO sue_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","numore ego senua awa, “Na Anutura nana benaura ge me sana zewai wae. Ni nena zota zo emo wero giro sasa potamunona.” ");
INSERT INTO sue_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ago senu mai bama diri awa nu mia nuso meni kotumai zo potinu giro ego senua awa, “Ni Yohane ge ou gutai zaawai ema amira giti kopi awa poti tewara niro zeme puro mu namore potase.” ");
INSERT INTO sue_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ago senu ema tua nu duba nuso mou wenua awa. Ata Anutura nana benaura ge senu zewai wenua, noko ema dai itiwa amira nana ge nuso osago wai azu, ");
INSERT INTO sue_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","saineba asero niniro senu mai sou nukare baro Yohane benai sora ena duba nuso kapero ");
INSERT INTO sue_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","giti tewara potiro puro muro mai bama dirire potiwa awa. Potiwa mai meni pumuro mia nusore potinu pumunua awa. ");
INSERT INTO sue_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Are Yohane dewa betenu bua mai nuso meni kei awero woi nuso puro gowewa awa. Gowero baro Yesure ge uge wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu meni Yohanera oziga niniro giro zebu awa doro wa zora witiro zebu zo erama tepo amira imata nuamu sero bamunua awa. Susaunu ema meni oziga nuso niniro nata serora erama dubu bamu ami ete susaumite zebu da amira kei awewa awa. ");
INSERT INTO sue_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ago wewa Yesu meni wara ena osero ema dubu bamu awa giro zo bamu wenu giro ema yayare nusokare awa kora wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ago inoise noinu tua zizinoinu giro bua mai nuso meni nuso nana kei awero numore ego sewa awa, “Ware nonakai tua zizinoya, are ema potasa nata sero bamuro nena nai tamamunora.” ");
INSERT INTO sue_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ago sewa ina ego senua awa, “Nogoro bayarise towi? Ninekare nena potiu nare.” ");
INSERT INTO sue_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ago senu ina sewa awa, “Nkare ma wana da ata wo eto gege awa puro nonakare.” ");
INSERT INTO sue_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ago sewa giro Yesu meni senua awa, “Nena awa puro naso nana muu.” ");
INSERT INTO sue_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ago sero ema senu zewaka patiro arumuro itiwa awa. Ago wero ma wana da ata wo eto awa pumuro iri utura niro kokopai Anuture asero eweweniro bua mai nusore potinu puro emare kanowewa awa. ");
INSERT INTO sue_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ago wewa nukare dapikarago niwa te wenua awa. Ago wero nena itata eni awa poti dara niwa kana 12 te wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ota ema nena niwa ami awa 5,000 meni nena niwa awa. Ota miamai mai pei-mamaire awa kaka azimamu dowa awa. ");
INSERT INTO sue_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Are Yesu meni bua mai nusore senu imata wara witiro gita ou ubu enibara bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Susauwa Yesu meni senu ema bama bozero susauwa nu isa bua wamu imata witi dirumura ninua awa. Ago inoise noinu pi zinu nu imata ago noinua awa. ");
INSERT INTO sue_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Are wa meni susaumite ou ubu soe sieninua awa. Are susauwa bisi mewene ena tupinu kakawa bamu dai muro wa puro witiro osero inoinua. ");
INSERT INTO sue_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ago inoinu pina atamu inoinu Yesu meni ou ubu tame aita wero susaumite nukare tamamu zora awinoinu ");
INSERT INTO sue_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","bua mai meni nu ou tame aita inoinua awa giro mamana awero ‘bi meni tupia’ asero azu inoise zawa gatewa awa. ");
INSERT INTO sue_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Zawa gatewa Yesu meni ego senua awa, “Nikare zewai wewo. Nama awa. Azu oko wawe.” ");
INSERT INTO sue_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ago senu Petoro meni be nusora puro ego senua awa, “Tua, nine me tupesita se giro na dai ou tame aita wero niso nana mane.” ");
INSERT INTO sue_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ago senu Yesu meni ego senua awa, “Mu.” Ago senu Petoro meni wara ena osero ou tame aita wero Yesu nana bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nuso nana susawise bisi bamu inoinua awa giro azu wero oura dagipitinoise Yesu zawa sero ego senua awa, “Tua, na pumu!” ");
INSERT INTO sue_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ago senu Yesu meni eya wana nuso zizinoise ego senua awa, “Ni tuma diai bamureko, are dagipitinosa. Ni nogoro duba eto inosi?” ");
INSERT INTO sue_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ago sero wara witiwato bisi tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ago wenu ema wara itiwa ami Yesu nana koiniro ego sewa awa, “Ni Anutura Mai me.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nukare ou ubu semuro Genesaret zebura witiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ago wewa ema meni Yesu giwa ziwenu ge sero sero awewa nata sero bamunu erama yayare nusokare itisowa awa puro Yesu nana muwa. ");
INSERT INTO sue_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ago wewa ema bama yayare meni Yesu begomo sero tama woi nuso tera ena gege kimamu sewa. Are kimuwa amira yaya tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Be amira ana Yerusalem natara Farisayo ata lo ge gipai ema eni nukare ami Yesura nana kei awero atata wero sewa awa, ");
INSERT INTO sue_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bua mai niso nukare nogoro ewowo nasokaira tani dainitinoweri? Ago inoise wana kaka sewamu* nena tepo ninowera, atonua!” ");
INSERT INTO sue_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ago atata wewa giro Yesu meni ina ego senua awa, “Ota nikare dai nogoro tani nisokare matu ama ganinoise Anutura ge sai zewai wai awa doinowewi? ");
INSERT INTO sue_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anutura ge ego itia awa, ‘Ni tani kokopai mia mama nisore inoise noiyo.’ Noko ge zo ego ewa, ‘Zo nu mia mama nusore ge waya samunoya nu awa deu betae.’ ");
INSERT INTO sue_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Anutura ge ago ine itia awa, ata ninekare meni awa ego towewa awa, ‘Zo nu miata mama nuso ego tugata wamunoya, nune ami mia mama nuso souwaise sai oko itia, “Nena nimoreto potamena, ata nena awa emoko Anuture potamu sena zewai wenua.” ’ ");
INSERT INTO sue_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nikare ago towewa ami ewowora tani emo inoise Anutu mia mama sou wawise ge senua awa duawewa tepo inowia. ");
INSERT INTO sue_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nikare opi ema me sao inowewa! Porofete Yesaya meni ge gaenua ami nikare pupinoya. Ge gaenua awa ego ewa, ");
INSERT INTO sue_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tua meni ego toya, Erama emi na begiti meni bowi inowera, ata moka nusokare meni awa naso nana oko itia. ");
INSERT INTO sue_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nukare emara ge awa Anutura lo ge ine asero sero gipero awinowera. Are nukare na bowi wero zainitinowera.” ");
INSERT INTO sue_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu nu ago sero ema diti bamu uzumunu kei awewa ego tugata wenua awa, “Na ge sana niniro baitiu. ");
INSERT INTO sue_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nena be nisokarera toitinowia ami oko nikare wawi bemitire inowewa. Ge be nisokarera ena kei awinowia ami nikare wawi bemitire inowewa awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ago senu giro bua mai nuso meni nibo tepo nuso nana benaura bamuro nu atata wero sewa awa, “Ni ge sesesa awa Farisayo nukare ge awa niniro duba mou inora, awa gosinosita?” ");
INSERT INTO sue_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ago sewa giro ina ego senua awa, “Ni bamubamu utura Mama naso meni kaka uramu agiti eriwa awa dapikarago sokero tepo wamunona awa. ");
INSERT INTO sue_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Duba mou inora amira kotumu-katumu oko wawe. Nukare giti guma wai meni ebata gita wago inora. Ota ema giti guma wai zo meni otao nuso giti guma wai amira ebata gita wamu wai, nuto eto dago degara bayamunorato.” ");
INSERT INTO sue_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ago senu Petoro meni Yesure ego senua awa, “Ni ge bezai sesesa amira susu kereniyo ganekare.” ");
INSERT INTO sue_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ago senu Yesu meni ego senua awa, “Agoro nikare dai kotumai tepo dago nowewa, atonua! ");
INSERT INTO sue_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Susu ego ine kaka ninamu nowewita? Nena be meni nawenakai tini nasokaira bamuro eba nusora osisinowia. ");
INSERT INTO sue_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ota ge be nisokarera ena kei awinowia awa dubara ena kei awinowia, are ge ami nikare wawi bemitire inowewa awa. ");
INSERT INTO sue_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Emara nana dubara ena nena ego awa kei awinowia: kotumai waya, erama dai betai, bama bewana wai, nena bewana wai, kotora ena opi sai, opi sero emara zazo puro osai. ");
INSERT INTO sue_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nena ago ine ami nikare wawi Anutura benaura ena bemitire inowewa awa. Ota wana kaka sewero nena namu ami wawi nikare bemitire oko inowewa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu bua mai nusore zebu awa doro nata eto Taya ata Saidon itiwato amira bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Baro noiwa Kenan zebura bama Yudako zo meni muro Yesu zawa sero ego senua awa, “O Tua, ni Dawidira sibuna meni na kapo emo zo weyo. Mai bama diri naso awa bi meni daraumawi waya wero itewia.” ");
INSERT INTO sue_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ago senu Yesu meni niniro ge zo oko senua. Ago wenu bua mai nuso meni nuso nana kei awero ego sewa awa, “Ni bama se bayae. Nu nasokai nana ama tupise zawa toya.” ");
INSERT INTO sue_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ago sewa giro Yesu meni ego senua awa, “Na Isreli ema dubu lama tara awai ine numorekare daba gegenai.” ");
INSERT INTO sue_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ago tuaise bama awa nuso nana benaura kei awero koiniro isa toise ego senua awa, “O Tua, ni na soremu!” ");
INSERT INTO sue_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ago senu ina ego senua awa, “Mai mamaira nena nai soero suna* unai ine awa te oko inoya.” ");
INSERT INTO sue_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ago senu ge ina ego kapeteninua awa, “Tua, awa me tosa. Ata noko suna nukare dia nusokarera opa du ena nena mumuka osawi ninowera.” ");
INSERT INTO sue_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ago senu giro Yesu meni ego senua awa, “O bama, tuma diai niso bamubake. Are tosa ago waise.” Ago tuaise mai bama diri nuso awa ewanana wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu nu zebu awa doro noko tera ewesemuro tupimite Galilaya ou ubura kei awero kora-kora nomite dirumu zora witiro baro arumuro itinua awa. ");
INSERT INTO sue_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ago itinu ema dubu bamu ami ema bama yayare witai awa puro muro nuso nana kei awewa awa. Nukare eni te dimai, o eni giti guma wai, o eni te wana amai, o eni ge tepo dau ema, o eni witai awa yaya eure-taure, ago ine awa puro kei awero Yesu nana benaura potiwa dapikarago kora wero tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ago wenu dau meni ge uge-mage wewa, ota te wana amai meni ewanana wewa, ota te dimai meni ewanana wero aita wewa, ota giti guma wai meni awa giti panewa awa. Are ema bama diti bamu meni awa giro yaba dasiga bamu inoise Isreli emara Anutu poti ike nitinoise bowi wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu meni bua mai nuso zawa senu muwa ego senua awa, “Na ema dubu emi emo zo bamu inoya. Nera kota, nukare naso nana waiko be etorobara ago nomite nena nai tepo weti nena kau inora. Are nena tepo asana nukare ena eriro susauma ebete ena meri betai azu inona.” ");
INSERT INTO sue_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ago senu bua mai nuso meni ego sewa awa, “Ei awa: Ware nonakai, are ma witai nana tamuro ema dubu bamu ago ine amire potanakai nara te wamunoi?” ");
INSERT INTO sue_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ago sewa giro nu nukare atata wero senua awa, “Ma nisokare nazo iti?” Ago senu nukare ego sewa awa, “Ma 7 ata wo kikinaka etokaka gege awa.” ");
INSERT INTO sue_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ago sewa awa, are Yesu meni ago niniro ema arumarise senu arumuro itiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ago wewa ma 7 ata wo awa pumuro Anuture kokopai asero eweweniro bua mai nusore potinu nunekare kanowero eramare potiro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Potiro bamuwa ema niwa te wenua awa. Ago wewa nena itata awa poti dara niwa kana 7 te wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nena niwa ema namba nusokare 4,000. Ota bama mai awisore awa kaka azimamu. ");
INSERT INTO sue_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu meni erama iyetinu susauwa nune meni awa wara witiro susaumite Magadan zebura kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisayo ema ata Sadukayo ema nukare ami Yesura nana kei awero Yesu gaero gamu inoise etetenai ge ego sewa awa, “Nima sasa utura tani putoure zo kei awai ganekare.” ");
INSERT INTO sue_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ago sewa giro numorekare ina ego senua awa, “Nikare tua ziamu inuawi giro ego towewa awa, ‘Tua gori ewanana ziwero sawia, are auma waiko witamunoya.’ ");
INSERT INTO sue_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ota pina atamu inuawi giro ego towewa awa, ‘Bereze inagainoya, are zeme wa wamunoya.’ Nikare berezera susu gosinowewa, ata be emira susu awa nikare kaka gamu inowewa awa. ");
INSERT INTO sue_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nikare ema waya-kawaya. Ema meni bama soa patitinowia, da ago ine nikare Anutu soa patitinowewa. Nikare tani putoure zo wana gamu towewa. Ata nikare tani putoure zo oko gamunowa. Tani gita Yona nana kei awenua da ago ine kei awai gamunowa.” Yesu meni ago sero nukare doro bua mai nusore dai bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesura bua mai nukare ma nuweniro doro Yesure dai ou ubu semuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Semuro ete witiwa Yesu meni ego senua awa, “Farisayo ata Sadukayo amira yis awa semu nisokare nana nai azu, nikare uma wero baititinoise noiwo.” ");
INSERT INTO sue_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ago senu nukare ego toise ina-sa wewa awa, “Ma iti doro menakai awa ago toya, atonua.” ");
INSERT INTO sue_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ge amira toiwa awa enia wero giro ina numorekare ego senua awa, “Oi, tuma diai besaire nikare! Nogoro ma dotewa amira uge-mage inowi? ");
INSERT INTO sue_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nikare nogoro susu naso kaka gamu inowewi? Na ma wana da ami ema 5,000 amire potena nera deneti busa awa sianiro kana nazo wetewa be musi? ");
INSERT INTO sue_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ota ma 7 meni ema 4,000 amire potena nera deneti busa nuso sianiro kana nazo wetewa be musi? ");
INSERT INTO sue_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na ma naire oko sesena. Nikare nogoro kaka kotumuro baitamu wetewi? Farisayo ata Sadukayora yis awa semu nisokare nana nai azu, uma wero baitiro nuawise tona.” ");
INSERT INTO sue_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ge awa tugata wenu amire niniro giro ego sewa awa, “O, nu ma naira yis amire oko sesia. Farisayo ata Sadukayora gipai ge nusokarere sesia.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu nu nata Sisaria-Filipai amira zebura kei awero bua mai nuso atata wero senua awa, “Ema nukare na Emara Mai amire are asinoweri?” ");
INSERT INTO sue_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ago senu nukare numore ego sewa awa, “Eni meni awa nimore Yohane ge ou gutai zaawai ema asinowera, ota eni meni Elia asinowera, ota eni meni awa Yeremiata porofete gita noisowa amira zo, awa nimore ago towera awa.” ");
INSERT INTO sue_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ago sewa giro noko nukare atata wero senua awa, “Ina nikare nitopekare na are asinowewi?” ");
INSERT INTO sue_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ago senu giro Simon Petoro meni ego senua awa, “Ni Soyai Ema nasokare Kristo. Ni Anutu putoure amira Mai awa.” ");
INSERT INTO sue_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ago senu Yesu meni ina ego senua awa, “Simon Yonara mai, ni yawa sara wase. Nera kota, ge me sesesa awa emara mokara ena oko kei awinoya. Utura Mama naso meni sero kereni tosa awa. ");
INSERT INTO sue_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Are na zazo niso seka zo tona: Ni Petoro. (Ge nasokaira Omata). Are nane omata tame dubu naso potitinuana so ine kei awero bayamunoya. Are wayara putou meni nukare puro osamu wai te oko wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ago wero na utura nata amira ki awa nimore potamunona awa. Are ni nena zo zebura ena azu sasa giro nena awa Anutu meni utura ena da ago azu samunoya. Ota ni nena zo zebura ena gasa te wai giro nena awa Anutu meni utura ena da ago gai te wamunoya.” ");
INSERT INTO sue_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ago sero bua mai nusore ge zewai-zawai toise ego senua awa, “Na Soyai Ema nisokare Kristo nona awa emare oko sawe.” ");
INSERT INTO sue_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Be amira ana Yesu meni zaawero nena nuso nana ama kei awamu inoinua amira ge bua mai nusore sero kereniro ego senua awa, “Na Yerusalem nate witana ema giti kopi ata pris babezinoma ata lo ge gipai ema nukare ami yaya-buyaya namore potitinoma na iwora wanera potara dara betamunona. Betero waiko be etorobara tepo wai amire noko seka wero eramunona.” Ago sero amira ge dapikarago tugata wero sero tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ago senu giro Petoro meni nu uzumuro ewe bamuroto amire azu toise senua awa, “Tua, Anutu meni ninai nena ago ine oko kei awe niso nana naise.” ");
INSERT INTO sue_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ago senu Yesu meni zuzumeniro Petorore ina ego senua awa, “Satan, ni na doro daiti. Ni eba naso gagatitinosa. Ni ge tosa awa Anutura ge kota, emara ge inoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Be da amire Yesu meni bua mai nusore ego senua awa, “Zo nu na ama ganamu wero giro ara tamai nuso dapikarago doro duba naire yaya tamaire amira ni pasinai nuso dimuro na ama ganaise. ");
INSERT INTO sue_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nera kota, zo nu nuai nuso zebura awa soero puro nuamu kotumamunoya amira nuai nuso awa tepo wamunoya. Ota zo nu na emo wero giro nuai nuso duamunoya ami nuai ewanana tamamunoya. ");
INSERT INTO sue_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Zo nu zebura nena kokopai dapikarago awa pupinuamunoya, ata nuai nuso tepo wamunoya, awa nena nemi nuso nana itamunoi? Ota nuai nuso ewesemaise kotumuro zuma ne potai amire nuai nuso awa ina ewese nuso nana namunoi? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Na Emara Mai meni Mama nasora zasimaire angelo dubu nusore dai osero ema dapikarago amira nuai nusokarera te ina potamunona awa. ");
INSERT INTO sue_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na me sane: Ema eni meni ego dopero itera ami kaka betamu nuara na Emara Mai meni zebu serora Tua wero noma damu-damuke osana gamunora. ");
INSERT INTO sue_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yesu meni waiko be 6 nomite Petoroto Yakobore ata nami kiaka nuso Yohane nukare pumunu nukare imata dirumu bamu zo witiro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ago wero ana benau nusokarera dopero itinu benau nuso zo wenua awa. Giti benau nuso waikora zasimai ago ine zasimunu, noko tama woi nuso meni awa zasimai ine wero kapa wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ago inuaise Moseto Eliare meni osero nuso nana zora kei aweroto numore dai ge uge-mage inoise itiwa Petoro otao etore meni giwa awa. ");
INSERT INTO sue_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ago giwa Petoro meni Yesure ego senua awa, “Tua, nakai ego itenakai awa ewanana. Are ninasa na komboa etorobara sinane — zo niso, zo Mosera, zo Eliara.” ");
INSERT INTO sue_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ago tuaise bereze zasimai bamure zo osero nukare gogowenua. Ago wenu amire ge zo bereze mokara ena ego kei awenu niniwa awa, “Awa Mai bou naso. Na nu emo yawa sara inona. Nikare ge nuso niniu.” ");
INSERT INTO sue_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bua mai meni ge awa niniro giti benau nusokare gogo wero poti zebura niro azu boro-boro inoise itiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ago inoiwa Yesu meni nusokare nana zora baro nukare zizinoise ego senua awa, “Nikare eriro azu doro noiwo.” ");
INSERT INTO sue_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ago senu nukare giti panero Yesu daba giwa awa. ");
INSERT INTO sue_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Are dirumura ena osisinoise Yesu meni ego senua awa, “Nena benau seka zo gewa amira ge bowi ema zore oko samunowa. Mama meni na Emara Mai awa-uzai betaira ena seka wero erana amire ge bowi awa samunowa.” ");
INSERT INTO sue_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ago senu giro bua mai nuso meni nu atata wero sewa awa, “‘Elia gita mai amire Kristo mamunoya,’ awa lo ge gipai ema meni ge ago ine nogoro toweri?” ");
INSERT INTO sue_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ago atata wewa giro ina ego senua awa, “Elia nu me gita ewesemuro nena bamubamu dapikarago korawai amire Kristo mamunoya, awa ge me awa. ");
INSERT INTO sue_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ata sana niniu. Elia nu emoko kei awero noinu ema bama meni susu nuso giwa kaka kei awamu wenu numore tani tebe-tabe wewa awa. Are nukare na Emara Mai da ago puro doise gaise awamunora awa.” ");
INSERT INTO sue_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ago senu nukare nu Yohane ge ou gutai zaawai ema amire senua awa giwa awa. ");
INSERT INTO sue_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nukare dirumura ena osisinomite ema bama diti bamu amira nana kei awewa ema zo meni muro Yesura nana zorage koiniro ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Tua, ni mai naso emo zo amuyo. Nu eyaya aziapinoise yaya bamu tapinowia. Nu niaora duwise oura dagipise awinowia awa. ");
INSERT INTO sue_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Are na bua mai niso nana puro mena kora waira wetera te kaka wamu wetia.” ");
INSERT INTO sue_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ago senu Yesu meni ina ego senua awa, “O nikare ema bama waya, tuma diai tepo. Na be nazo nimorekare dai nuamunoni? Mai puro naso nana muu.” ");
INSERT INTO sue_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ago senu nukare mai puro muwa nu bi senero ge senu mai doro bamunu mai eya ewanana wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Are bua mai nuso meni nukare gege imata amire nu atata wero sewa awa, “Nakare nogoro bi tunaira bua wetenakare te kaka wamu weti?” ");
INSERT INTO sue_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ago sewa ina ego senua awa, “Tuma diai besai nisokarera. Na me nimorekare sana niniu. Tuma diai nisokare awa ni me kiaka zo ine eriro bamu wamunoya, ami meni awa nikare dirumu emire, ‘Ni ena sokero ogo bamu!’ ago sawa, sokero bayamunoya. Tuma diai ago ine awa nisokare nana itai nikare bua bamubamu wai te awa.  ");
INSERT INTO sue_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Bi ago ine tunai awa nena zota zo meni oko aewa. Isa saire nena sienaire meni gege tunai te awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Are noe bua mai nuso dapikarago Galilaya zebura ena nuso nana poti dara niwa Yesu meni ego senua awa, “Nuanakai na Emara Mai awa emara nana wanera potara ");
INSERT INTO sue_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","dara betana waiko be etorobara tepo wai amire Mama meni na awa-uzai eramunona awa.” Ago senu bua mai nukare niniro duba nusokare mou wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu bua mai nusore Kapaneam nate kei awewa ema eni Anutura ibu bamu amira takis bua inoisowa ami Petoro atata wero sewa awa, “Gipai ema nisokare meni ibu bamura takis 50 toea awa potitinowita?” ");
INSERT INTO sue_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ago sewa Petoro meni ego senua awa, “Iyo, potitinowia awa.” Ago sero nu noko tera Yesura nana sora witiro ge awa kaka kerenamu inoinu Yesu nu nutope Petoro atata wero senua awa, “Simon, susu ei awa gasa nogo wai giro ina se gane: Zebura ema tua nukare arakara nana takista kastam* pupinoweri, dubu nusokare nanata dubu zora nana ni?” ");
INSERT INTO sue_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ago senu Petoro meni ego senua awa, “Dubu zora nana.” Asenu Yesu meni ego senua awa, “Ewanana tosa, are ema tuara dubu nukare takis potarise sai oko itia. ");
INSERT INTO sue_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ata saineba, nukare namorekai kotumara waya wai azu, ni ou ubura baro asi apero wo zo gita dimamunosa awa zumasa witai be nuso ziasa zaumai kina zo tamamunosa. Awa ibura takis moni nasoge asero puro baro numorekare potiyo te wae.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Waiko be amire bua mai nuso nukare nuso nana bamuro atata wero sewa awa, “Utura itewia ami imata Tua wero nuai amire ai meni giti kopi bamu wero nuamunoi?” ");
INSERT INTO sue_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ago sewa Yesu meni mai pei-kaka zo senu munu nusokare nana soe potiro ");
INSERT INTO sue_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ego senua aw, “Na me nimorekare sane. Nikare duba kapeteniro mai pei-mamai ine kaka wero nuamu, awa utura mokara oko toyamunowa. ");
INSERT INTO sue_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Zo nu duba nuso puro osero mai ego ine wero nuamunoya, nu ami Anutu imata Tua wero nuai amire ema giti kopi bamu wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Are zo nu na emo inoise mai ego ine zo kora wamunoya, nu ami na kora wetia ago ine wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Zo nu mai kikinaka na tuma didinowera amira nana zo uzutai pasina tamai azu, nikare bere-bere omata bamubake zo ema amira nana dube kimeniro ewa surura musunawa dagimai te wamia. Nera kota, ema ami pasina kaka wamure oura dagimuro betamunoya, awa nena peu gege. Ota nu pasina wai amire Anutu meni ina potamunoya, awa nena mou-mau. ");
INSERT INTO sue_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Pasinara uzutai eure-taure ami kei awero ema bama uzutai pasinara duwamunora. Ata zo nu ema bama pasinara uzutamunoya ami waya waise. ");
INSERT INTO sue_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Are wana niso zo menita te niso zo meni pasina wamu sai giro kapero do. Nuai me ewanana pumamu kotumuro giro wana daimatare gege o te daimatare gege noma nuai me ewanana topetasa te wamunoya. Ota tere wanere zere dago puro nuasa ama ni niao zewai-zawai amira apara waya wamunosa. ");
INSERT INTO sue_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ota giti moka niso zo meni pasina tamamu wai giro gusero do. Nuai me ewanana pumamu kotumuro giro giti moka daimatare gege noma nuai me ewanana topetasa te wamunoya. Ota eto dago puro nuasa ama ni dega niaore amira apara waya wamunosa. ");
INSERT INTO sue_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nikare pei-mamai naso zore gawa oko osaise. Na ami emo sana niniu. Angelo nusokare utura nowera nukare utura Mama nasora nana benaura kei awinoise mai nusokarera uge inowera.  ");
INSERT INTO sue_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Na Emara Mai meni erama tiri-tara awai awa kau wero tamamu sero osena. ");
INSERT INTO sue_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ota ge zo sana kotumuro ina seu gane. Ema zo lama nuso 100 nusokare nana zo meni tara awai giro duamunoita? Tepo awa. Nu lama 99 nena ninoise itera awa doro bamu ware niro tara awai awa kau wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na me sane. Nu me kau inoma tamuro 99 kaka tara awamu nukare ami emo kota, tara aweti tamia ami emo duba ewanana wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Are da ago ine utura Mama nisokare meni pei-mamai naso nusokare nana zo meni Mamera nana gomara ena tara awai azu towia awa. ");
INSERT INTO sue_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Otao niso zo meni niso nana pasina tamai ni bamuro nito imata ge potiyo gae. Ago wasa nu ge niso niniro kotumai nuso ewanana tamai noko otao ina-wa wamunowato. ");
INSERT INTO sue_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ota ge niso dai giro doro baro ema data eto ago awa pumuro noko tera nuso nana bayawa nuto dai susu nuso gosinoise ge samunowato awa ninareto. ");
INSERT INTO sue_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ota ge nisokare te dago dai giro dubu nasora nana giti mokara kereni gare. Dubura ge da ago dai giro ninawa diga emare takis pumai emare te wae. ");
INSERT INTO sue_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Na me memeka sane. Nikare zebura ena zasero diawa Anutu meni da ago ine utura ena zasero diamunoya. Ota zebura ena besawa Anutu meni da ago ine utura ena besamunoya. ");
INSERT INTO sue_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","O zo susumuro sana niniu. Nisokare nana eto meni nena zo emo duba nusoto dara tiarato da wai isa sarato utura Mama naso meni isa nusoto niniro te wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nera kota, ema etota etorobara nukare na emo aunara na nusokare nana soe nuamunona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yesu meni ge ago senu Petoro meni atata wero senua awa, “Tua, otao naso namore pasina inuai na be nazo ago awa pasina nuso duamunoni? Be 7 ago awa duana te wanoita?” ");
INSERT INTO sue_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Atata wenu Yesu meni ina ego senua awa, “Na be 7 ago duasise oko tona. Ni be dainiro-bake 70 taims 7 ago ine te wero dotinuasise tona. ");
INSERT INTO sue_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Anutu imata Tua wero nuai amira susu awa na ema tua zora potiro sana niniu. Ema tua zo meni mai sou dubu nuso dinau nuso ina potarise ge bua awa zaawenua. ");
INSERT INTO sue_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Are ge bua zaawero soumai marise senu nusokare nana zo amira nana ina nuso 10 milion kina ami ema tuara nana kei awenua. ");
INSERT INTO sue_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nu ina nuso bamu awa potai ine tepo giro ema tua meni ego senua awa, ‘Ema ei awa ata bama maire nuso ata nata wo nuso ata nena wau nusore dago ema meni zuma gaero pumara na omata tamane.’ ");
INSERT INTO sue_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ago senu soumai meni ema tuara nana koiniro begomo toise ego senua awa, ‘Ema tua naso, ni na awa-diasa omata niso eagomai potamunona.’ ");
INSERT INTO sue_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Begomo senu ema tua nu zo amuro giro awa-diro ina nuso bamu awa donua. ");
INSERT INTO sue_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ago wenu sora ena osero bamuro soumai otao nuso zo tamunua, awa nuso nana ina nuso l00 kina itinua. Nu awa tamuro duba ziro doinoise ego senua awa, ‘Ina naso zeme-zemeke eya poti!’ ");
INSERT INTO sue_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ago wenu otao nuso nuso nana koiniro nu begomo toise ego senua awa, ‘Ni na awa-diasa omata niso potamunona.’ ");
INSERT INTO sue_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nu begomo senu ge nuso kaka ninamu baro senu otao nusore ego toise benai sora potiwa awa, ‘Ina nuso potiro tepo wero amire kei awamunosa.’ ");
INSERT INTO sue_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Are otao mamai nuso meni giro moka nusokare waya wenu bamuro ema tuare ge uge wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Are ema tua meni niniro soumai awa noko zawa senu munu ego tugata wenua awa, ‘Ni ema waya me waya atonua. Ni nama begomo sesesa duba naso nima emo waya weti giro ina naso bamu awa nimore dotena. ");
INSERT INTO sue_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Are na ni awa-diena ago ine nima otao nisore duba waya wai awa-diamesa, awa te wamia.’ ");
INSERT INTO sue_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ago sero dumu wero tini kapenu goroba emara nana potiro ego senua awa, ‘Nikare nena waya me waya numore wero susawiawa nu ina naso bamu awa potiro tepo wai amire duamunowa.’” ");
INSERT INTO sue_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu meni ago sero ge ei awa susumuro senua awa, “Are nikare duba peure pasina ina-dua kaka wamu wawa utura Mama naso meni nena mou-mau da ago ine nimorekare wamunoya awa.” ");
INSERT INTO sue_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu nu ge neire-neire awa sero tepo wero Galilaya zebu doro Yudaya zebu agewa ou Yodan enibara itinua ago bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Susaunu ema dubu bamu nu ama ganewa awa. Nukare zebu amira noiwa nu ema yayare kora wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ago inoinu Farisayo nu gaero gamu sero kei awero nu atata wero sewa awa, “Zo nu bama nuso susu zota zo emo wero duai te wamunoita?” ");
INSERT INTO sue_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ago sewa nu ina ego senua awa, “Nikare Tuara ge ego itia awa kaka azimuro gamu meni sago inowa, atonua! Tamai Mama meni nu zebu zaawaira ena ema tamamu inoise emare bamere te tamunua. ");
INSERT INTO sue_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tamuro ego senua awa, ‘Are ema meni mia mama nuso doro bama nusore dai gamuro baitiro nuto dubare tamare da wero nuamunorato.’ ");
INSERT INTO sue_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Are nuto eto kota, daimata wero nuamunorato. Anutu meni nuto dara potinu atiwato, are erama meni oko kaparise.” ");
INSERT INTO sue_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ago senu nukare ina ego sewa awa, “Ago sia, awa Mose meni nogoro ego senu, ‘Ema zo meni bama nuso duamu wero giro pas potiro sai bayaise.’ Mose meni nogoro ago ine senu?” ");
INSERT INTO sue_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ago sewa Yesu meni ina ego senua awa, “Mose nu nikare Anutura ge ninai azu giginowewa amira ina-dua waira sewa nininua awa. Ota zaawaira ena ebata ago ine zo oko itisonua. ");
INSERT INTO sue_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Are nane sana niniu. Zo nu bama nuso doro zo atamunoya nu ami susumai nusoto awa kapero nu bama bewana wetia ago ine wamunoya. Ota bama meni gita pasina tamunuta awa ina-dua waira pasina awa bama meni dimamunoya. Emara oko wamunoya.” ");
INSERT INTO sue_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ago senu bua mai nuso meni ego sewa awa, “Are sai amira susu ago iti sia, awa bama tepo nuai ami meni awa ewanana itaira ebata awa.” ");
INSERT INTO sue_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ago sewa Yesu meni ina ego senua awa, “Ema bamubamu meni ge awa niniro poti dube nai ine tepo. Ema putou potai meni gege pumuro poti dube namunora. ");
INSERT INTO sue_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ema eni miera nana tinira ena kei awero bama atai ine tepo somono nowera; ota eni meni awa ema meni wawera eroniro bama kaka atamu inowera; ota eni meni awa utura ge emo wero bama kaka atamu somono nowera. Are zo amira putou itai giro ge ei awa pumuro poti dube naise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ema bama nukare mai pei-mamai nusokare puro bamu Yesu nana niro wana nuso gitine potiro isa saise sewa. Ago wewa bua mai nuso meni ema bama senewa awa. ");
INSERT INTO sue_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Senewa giro Yesu meni ego senua awa, “Nikare mai pei-mamai dou naso nana mare. Ebata nusokare oko gazawe. Ago ine ami utura nata amira gegenai.” ");
INSERT INTO sue_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ago sero wana nuso nusokare nana gitine potinua. Ago wero zebu awa doro bamunua. ");
INSERT INTO sue_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ema zo meni Yesu nana kei awero atata wero senua awa, “Gipai ema, na bua ewanana zo ne wero amire nuai me ewanana tamamunoni?” ");
INSERT INTO sue_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ago senu Yesu meni ego senua awa, “Nena ewananara susu gamu sero nogoro na atata inosi? Ewananara susu daimata gege noya. Are ni nuai me ewanana amira gegenai wamu wero giro sai zewai wai ge nuso dimuyo.” ");
INSERT INTO sue_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ago senu giro nune sai zewai wai ge awa neni asinoise atata wenu Yesu meni ego senua awa, “Na sai zewai wai ge ego emire tona: ‘Ni erama oko dasa betare. Ni emata bama bewana oko wase. Ni bewana oko wase. Ni ema zo gera potamu opi oko sase. ");
INSERT INTO sue_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ni miato mamera ge dimuyo. Ota ni nitope ara tapinowesa, da ago ine ema enire weyo.’ Amire tona awa.” ");
INSERT INTO sue_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ago senu ema seka meni ina ego senua awa, “Awa emoko ona dipitupewena. Are zo nogo wana te wamunoi?” ");
INSERT INTO sue_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ago senu Yesu meni ego senua awa, “Ni etutiro nuamu kotumuro giro bamuro nena niso dapikarago potasa ema meni zuma gaero pumara wau moni niso awa ema bogamasare kanowasa pumare. Ago wasa wau niso utura itamunoya. Ago wero amire ni muro na ama ganase.” ");
INSERT INTO sue_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ago senu ema seka meni ge awa niniro kotumu-katumu inoise doro bamunua. Nera kota, wau moni nuso witai. ");
INSERT INTO sue_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Bamunu Yesu meni bua mai nusore ego senua awa, “Na me memeka sane. Erama wau moni bamure meni utura toyaira bua bamubake wamunora. ");
INSERT INTO sue_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na noko sane. Wo kamel meni boma sora toyai awa nena mou. Ota wau moni bamure meni Anutura nata amira bayai awa nena mou-mau.” ");
INSERT INTO sue_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bua mai nukare ge awa niniro titibi awero ego sewa awa, “Are agai meni utura baro nuai me ewanana tamai te inoi?” ");
INSERT INTO sue_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ago sewa Yesu meni nukare ua inoise ego senua awa, “Awa erama meni wai ine tepo. Ata Anutu meni ago wai te inoya.” ");
INSERT INTO sue_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ago senu Petoro meni bera puro ego senua awa, “Agoro nakare nena nasokare bamubamu dapikarago nuwenirokare ni ama ganinowenakare. Are noma amira ina ne nasokare nana kei awamunoi?” ");
INSERT INTO sue_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ago atata wenu Yesu meni ego senua awa, “Na me memeka sane. Noma nena bamubamu seka wero ewanana kei awamunoya be amire na Emara Mai meni arumai simaire nasora arumuro itana na ama ganewa nikare da ago ine ema tuara arumai 12 amira arumuro itise amire Isreli ema dubu 12 awa awina-dawina wamunowa. ");
INSERT INTO sue_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Are zo nu na emo inoise namisini o nubabumana, o meta mai, o mia mama mai awiso, o nata, o notu duamunoya — nu ami ina nena witai saisai ewa-gaewa pumuro amira tame nuai me ewanana dai mama wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ota ema gita inora amira nana eni meni ama wamunora. Ota ama inora amira nana eni meni gita wamunora. ");
INSERT INTO sue_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Anutu imata Tua wero nuamunoya amira susu awa wain buara mama zora potiro sane. Wain buara mama zo meni wain bua nuso emo wero bua ema pumamu pina gamu bamunua. ");
INSERT INTO sue_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ago wero eni pumuro bua be daimata amira zuma nuso K1.00 ago kereninu giwa te wenu giro bua nusora iyetinu bamuwa. ");
INSERT INTO sue_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Are pina 9 klok inoinu noko bamuro ema eni nata kakame tepo noiwa giro ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Wain bua naso itia baro wawa zuma te potamunona.’ ");
INSERT INTO sue_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ago senu niniro wain bua nusora bamuwa awa. Ago wero 12 klok amire mai eni pumuro 3 klokra dai pumunua. ");
INSERT INTO sue_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Are 5 klok noko bamuro ema eni bua tepo noiwa tamuro giro ego senua awa, ‘Nikare nogoro waiko ei awa bua kaka wamu timara nowa tua zizinoi?’ ");
INSERT INTO sue_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ago senu nukare ina ego sewa awa, ‘Nukare bua ge zo namorekare kaka samu.’ Ago sewa giro nukare iyetitinoise ego senua awa, ‘Wain bua naso itia bamuu wawe.’ ");
INSERT INTO sue_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Buara mama meni ago wenu tua zinu dia wai ema nuso zawa senu munu ego senua awa, ‘Ni bua ema dorowe dara niro zuma poti pumare. Are ama kei awetera ana zaawero potiti susauma gita kei awetera amira nana potiro tepo weyo.’ ");
INSERT INTO sue_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ago senu giro ama muwa awa senu muwa K1.00 potiro tepo wenua. ");
INSERT INTO sue_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Potinu gita muwa nukare giro ego kotupitinoiwa awa, ‘Zuma puro witiro potamunoya.’ Ago toise itiwa, ata dia meni K1.00 da awa numorekare potinua. ");
INSERT INTO sue_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Potinu pumuro gung-ga toise buara mamere kotumuwa waya wenua. Ago inoise ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ama mera nukare bua wan aua gege wetera. Ota nanekare meni awa waiko bamu amira yaya mena-mana tapinonakare tua zia, awa ni nogoro ama mera amire zuma te ago potitinosi?’ ");
INSERT INTO sue_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ago sewa buara mama meni nusokare nana zore ego senua awa, ‘Otao, na nikare oko waya inona. Na K1.00 sesena ninesa te wetia. ");
INSERT INTO sue_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Are omata niso puro bamu. Na ama mera awa nimore te ago potamu kotumena te wetia. ");
INSERT INTO sue_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na nena naso, are egota ago wana te wamunoya. Ni bayao nasora numorekare mou inosita?’” ");
INSERT INTO sue_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu meni uge awa diro pesuniro ge susumuro ego senua awa, “Are ama inora ami gita wamunora. Ota gita inora ami ama wamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu nu Yerusalem nate wititinomite bua mai nuso 12 awa daba pumuro bamu ewe niro amire nukare nutopekare ebete susawise ego tugata wenua, ");
INSERT INTO sue_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Sana giu. Nakai Yerusalem wititinonakai. Ago kei awanakai na Emara Mai awa pris babezinoma ata lo ge gipai emara nana wanera potara na betanise samunora. ");
INSERT INTO sue_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Betanise sero na puro ema Yudakora wanera potara na isipitinoise wamu meni doise awinoma ni pasinaira dara betamunona. Betana waiko be etorobara tepo wai amire noko eramunona awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Be amira ana Zebedira ara meni mai nuso eto puro Yesu nana zorage bamuro koiniro nena zo emo isa senua awa. ");
INSERT INTO sue_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ago wenu nu atata wero senua awa, “Ni ne emo inosi?” Ago senu giro numa ego senua awa, “Ni sasa mai naso eto ni Tua bamu kei damu namunosa be amira ana nuto niso nana zorage zo wana mera zo wana anikara itariseto.” ");
INSERT INTO sue_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ago senu Yesu meni ina ego senua awa, “Nikare ge towa amira susu oko gosinowa. Na ou dokaka zo namunona, awa nito te nanowato?” Ago senu nuto sewato awa, “Iyo, te namunonato.” ");
INSERT INTO sue_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ago sewato nu numoreto ina ego senua awa, “Ou dokaka zo namunona, awa namunowato. Ata nito naso nana zo wana mera zo wana anikara arumuro itamunowato amira ge awa nane sai ine tepo. Mama naso nu duba nuso meni mai eni kotupitinoise masi awa sia wenu itewia, are nukare ami masi amira arumuro itamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Are bua mai 10 nukare ge awa niniro otao nusokare etore giwa waya wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Are Yesu meni nukare zawa senu muwa ego senua awa, “Zebura ema tua meni ema bama nukare sou warise towera. Noko, ema babezinoma meni ema bama puro osero nunekare witai nusokare ine inowera, awa gosinowa. ");
INSERT INTO sue_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ota ninekare meni awa ago ine oko wawe. Nisokare nana zo meni bamu wamu wero giro enira ama-zani wero nuaise. ");
INSERT INTO sue_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ota giti kopi wamu wero giro enira soumai wero nuaise. ");
INSERT INTO sue_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Na Emara Mai meni da ago ine erama na sou warise kota, na natope sou bua inoise betero erama saisai wayara ena soero pumamu muna.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu bua mai nusore nukare Yeriko nate semuro doro susauwa ema dubu bamu ami ama ganero bamuwa. ");
INSERT INTO sue_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Are ema giti gumawai eto ebete denemuro arumuro itiseto Yesu muro susawia ago sewa niniro pena-pana zawa toise ego sewato awa, “Tua, ni Dawidira sibuna meni nato emo zo amuyo!” ");
INSERT INTO sue_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pena-pana zawa sewato ema meni numoreto toise azu sewa awa. Azu sewa nuto ninidanago inoise weso wero zawa toise ego sewato awa, “Tua, ni Dawidira sibuna meni nato emo zo amuyo!” ");
INSERT INTO sue_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ago sewato giro Yesu meni ebete dopero senu muwato nuto atata wero senua awa, “Na ne nimoreto wanise towito?” ");
INSERT INTO sue_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ago senu ina ego sewato awa, “Tua, giti moka nasoto sasa panaise tonato.” ");
INSERT INTO sue_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ago sewato Yesu meni nuto kapo zo amuro giro giti moka nusoto kimunu eya panewato awa. Ago wero Yesu ama ganewato awa. ");
INSERT INTO sue_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu bua mai nusore susaumite Yerusalem nate kei awamu zora awewa. Ago inoise Betefasi nata Oliwa dirumu susura itinua ago kei awero Yesu meni bua mai nuso amira nana eto iyetitinoise ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Nito baro nata mai kiaka ago itia gosinowato amira toiro baro wo donki maire mui wai iterato awa tamamunowato. Tamuro besero puro maweto. ");
INSERT INTO sue_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nito ago inuawato zo meni nto atata wai giro ego seuto, ‘Tuara bua emira itia.’ Ago sawato eya potamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nena awa tepo oko kei awenua. Ge porofete zo meni gita senua awa me waise ago wenua awa. Porofete meni ge ego ine gaenua awa, ");
INSERT INTO sue_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Nikare nata Zion ego tugata weu ninare: Ei giu! Ema tua nisokare meni nisokare nana tupia. Nu duba osaire noise wo donki tame arumuro tupia. Nu wo neu-nau dimai amira mai amira tame arumuro tupia. ");
INSERT INTO sue_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Are mai eto bamuro Yesura ge dipinoise ");
INSERT INTO sue_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","donki miere maire puro muwato tama woi nusokare meni tame sawa diwa Yesu witiro itinua awa. ");
INSERT INTO sue_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Are ema saisai meni tama woi nusokare dutuniro biriziro ebete sawa diwa. Ota eni meni awa ni gomi kapero ebete sawa diwa awa. ");
INSERT INTO sue_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ago wero ema bama witai meni gitare amare wero susawise arero ego sewa awa, “Oro, oro, Dawidira sibuna. Tuara bera tupesa, ni awa bowi wanekare. Utura nowera ami Anutu bowi warise.” ");
INSERT INTO sue_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Are Yesu Yerusalem nate witinu nata susu nukare buru-zara inoise ego sewa awa, “Ai meni tupi inori?” ");
INSERT INTO sue_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ago sewa ema diti bamu ami ina ego sewa awa, “Awa porofete Yesu. Nu Galilaya zebura Nasarete nate ena kei awenua ami tupi tora.” ");
INSERT INTO sue_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu meni Anutura ibu bamura witiro nena ina-pota inoise itiwa nukare awa tunenua awa. Ago inoise omata dadawa wai emara tebol ata ema ni guma ibura zame potai amira bua inoisowa amira arumai awa zinu kapeteniwa. ");
INSERT INTO sue_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ago inoise ego senua awa, “Ge gayai zo ego itia ewa, Ibu naso awa isa saira ibu itaise. Ota nikare wetewa ibu awa bewana wai emara bezai masi ine inoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ibu bamura ago noinu ema giti guma waire zabura waire nuso nana bamuwa kora wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ago wenu pris babezinoma ata lo ge gipai ema nukare tani putoure nuso giwa awa. Noko, mai mamai meni Anutura ibu bamura ena yawa sara inoise, “Oro, oro, Dawidira sibuna,” ago sewa niniwa awa. Are tani putoure giro mai mamaira ge niniro nukare tini kapenua. ");
INSERT INTO sue_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tini kapenu Yesure ego sewa awa, “Nukare emi ge ei awa tora ninitinosita?” Ago sewa ina ego senua awa, “Ninitinona. Ata nikare ge gayai zo ego itia awa kaka azimuro gamu meni sago inowa, atonua! Mai pei-mamai ata mai uno amira duba nusokare pumasa peu wai nusokare nana bera ena bowi wai niso ewanana kei awamunoya.” ");
INSERT INTO sue_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ago sero nukare doro Yerusalem nate ena osero witi Betani nate niro aunua awa. ");
INSERT INTO sue_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu meni pina gamu nata Betani doro noko tera Yerusalem witamu inoise meri wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ago wero ebata demabera ni fik zo dopero itinu giro ni susura bamuro me kau wero gi gege itinu giro nire ego senua awa, “Ni eroniro me kaka ziamu tepo ago itai gege itamunosa.” Ago senu apunu-kaka gege ni awa gi nuso sokenu amunua awa. ");
INSERT INTO sue_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Are bua mai nuso meni awa giro di tainiro ego sewa awa, “Ni awa nu nogoro eya apitai?” ");
INSERT INTO sue_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ago sewa Yesu meni ego senua awa, “Na me memeka sane. Nikare duba saisaire kaka wamu tuma diai mere dai nuamunowa ami tani nira kei awetia awa wamunowa. Awa daba kota, nikare dirumu omire ego samunowa, ‘Dirumu, ni sokero ewara dagimu.’ Ge samunowa, awa te kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ago wero tuma diai mere dai noise amire nena zota zo emo isa sawa kei awamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu meni susaumite Anutura ibu bamura witiro ema bama utura ge gipinoise itinu pris babezinoma ata Yuda emara simai ami nuso nana baro nu atata wero sewa awa, “Ni tani ena inowesa awa ara bera inowesi? Agai meni nimore senu inowesi?” ");
INSERT INTO sue_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ago sewa Yesu meni ge ina ego senua awa, “Na nikare atata zo wamunona. Nikare ina namore samunowa, awa nane da ago ine ara bera tani awa inoweni amira susu samunona. ");
INSERT INTO sue_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohane ge ou gutai bua nuso awa ara bera inoisi, emara berata Anutura bera ni?” Ago toise atata wenu nukare ge ne samunonikai asinoise duba saisai wewa awa. Ago wero nutopekare ge ina-sa inoise ego sewa awa, “Nakai ‘Anutura bera’ asamunonakai, awa nu ego samunoya, ‘Are nogoro ge nuso kaka ninamu wisewi?’ ");
INSERT INTO sue_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ota nakai ‘Emara bera’ ago samenakai, ata ema bama meni nakai waya wai azu inonakai. Nera kota, nukare Yohane gasara porofete me inoisia.” ");
INSERT INTO sue_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ago sero Yesure ego sewa awa, “Nakare kaka gamu inonakare.” Ago sewa Yesu meni ge ina ego senua awa, “Are na da ago ine ara bera tani awa inoweni amira susu oko samunona.” ");
INSERT INTO sue_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu meni ego senua awa, “Uge zo wana niniro seu. Ema daimatara mai eto noisowato awa. Are mama meni mai zore ego senua awa, ‘Mai, ni zeme bamu wain bua wase.’ ");
INSERT INTO sue_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ago senu ina senua awa, ‘Tepo. Na buye oko bayamunona.’ Ago sero nomite duba kapeteniro buye bamunua. ");
INSERT INTO sue_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Are mama meni mai zore ge da awa tugata wero senua awa. Senu giro ina ego senua awa, ‘Iyo, nama wamunona.’ Ago sero kaka bayamu dago itinua. ");
INSERT INTO sue_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Are nikare mai ai meni mama nusora ge dimunua asinowi?” Atata ago wenu nukare ego sewa awa, “Ge gita senua.” Ago sewa Yesu meni ego senua awa, “Na me memeka sane. Takis pumai emare bewana bamere nukare Anutu imata Tua nusokare waise sero gita inoise nuso nana mokara toitinuara ninekare meni awa ama wamunowa. ");
INSERT INTO sue_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nera kota, Yohane kei awero etutiro nuaira ebata nimorekare gipenu nikare ge nuso azu dowa takis pumai emare bewana bamere meni ge nuso niniwa awa. Ago wewa nikare giwa, ata nikare duba kaka kapetenamu, o ge nuso kaka ninamu wisewa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu meni ego senua awa, “Na ge bezai zo sana niniu. Ema bamu zo meni zebu zora wain urero pua gaero zimunua. Ago wero wain me zasaira ura bamu zo wamuro wain bua dia wai emara so dai wero awenua awa. Ago wero tepo wero dia potiro nu zebu zora-zarako amira bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Baro noinu wain paira be munu giro nu me eni pumamu kotumuro soumai nuso eni iyetinu bamuro dia nana kei awero sewa giro ");
INSERT INTO sue_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","dia meni eriro soumai puro zo dero musuna-masuna wewa, ota zo meni awa dewa betenua, ota zo meni awa omata meni dewa awa. ");
INSERT INTO sue_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ago wewa buara mama meni niniro noko soumai dainiro potasai bayasara da ago ine numorekare wero awewa awa. ");
INSERT INTO sue_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Are ama meni awa mai diai susu nuso me awa ego kotupitinoise iyetinua awa, ‘Mai naso baro kei awai nukare nu giro ge nuso dimamunora,’ asero iyetinu baro kei awenu ");
INSERT INTO sue_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","dia meni mai nuso diai susu me awa giro ego toise ina-sa wewa awa, ‘Nune ami noma zebu emira mama wamunoya. Are nakai nu danakai betai zebu ei awa nasokai wae.’ ");
INSERT INTO sue_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ago sero nu buye ena musuna-masuna inomite puro baro pua atune ena dewa betenua awa.” ");
INSERT INTO sue_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu meni ago sero ge susumuro ego ine senua awa, “Are buara mama nu kei awero bua dia wai emare nogo wamunoi?” ");
INSERT INTO sue_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ago senu nukare ego sewa awa, “Nu ema waya-kawaya awa dai oena-paena inoma betamunora awa. Ago wero dia ewanana eni bua nusora potai nukare me kei awinuai giro me pumuro mamere potitinoise nuamunora.” ");
INSERT INTO sue_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ago sewa Yesu meni ge ego ine susumuro senua awa, “Utura ge gayai zo ego itia, awa nikare azipitinowewita? So wai ema meni omata zo giwa waya wenu dowa awa. Ata omata ami so urura zasiwi wero itewia. Nena awa Tuara bera kei awenua, are ema meni genakare ewanana inoya awa. ");
INSERT INTO sue_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Amira sana niniu. Anutu imata Tua wero nuai amira ebata awa nisokare nana ena soero pumuro ema dubu zore potamunona. Ago wana nukare bua wero me pumuro mamere potamunora.  ");
INSERT INTO sue_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Zo nu omata amira duwamunoya ami zasamunoya. Ota omata ami ema zora nana tame duwamunoya, awa ema awa dai zasero mumuka gege wamunoya.” ");
INSERT INTO sue_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ge bezai ago senu pris babezinomare Farisayo emare nukare niniro giro ego sewa awa, “Oi, nu namorekai toya.” ");
INSERT INTO sue_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ago sero puro benamu kotumuro amire ema bama meni Yesu nu porofete asinoisowa giro nukare ema bama azu wero dowa awa. ");
INSERT INTO sue_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu nu ge bezai noko susumuro ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Utura itewia ami imata Tua wero nuamunoya amira susu awa ema tua zo meni mai nuso bama pumaise sero ana-bona wenua amira potiro sane. ");
INSERT INTO sue_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nu nena siawero bua mai nuso iyetinu nukare ema oziga emoko sai are uzumuro puro mamu bamuwa awa. Baro sewa ata nukare dowa. ");
INSERT INTO sue_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Dowa giro ema tua meni bua mai eni noko tera iyetitinoise ego senua awa, ‘Nikare bamuro ema oziga sai awa ego tugata weu: Nama nena emokore pumena kei awetia. Ota wo bulimakao babezinomare pei-mamai gawire awa emoko sesena dero azero awetera awa. Ago wero nena bamubamu dago sia-masia wero tepo wetera awa. Are nikare mawa bama emare potitinoise nena ninoise yawa sara wanekai.’ ");
INSERT INTO sue_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ema tua meni ago senu bua mai bamuro sewa nukare ninidanago inoise bozero tebe-tabe bamuwa awa. Zo nu bua nusora bamunua, zo nu stoa nusora bamunua, ");
INSERT INTO sue_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ota eni meni awa ema tuara bua mai sero zizinoise saniro pumuro dewa bebeteniwa awa. ");
INSERT INTO sue_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ago wewa ema tua meni niniro tini kapenu giro senu soldia nuso meni baro ema mai dewa betewa awa dero tepo-tapo wero nata nusokare guruniwa awenua awa. ");
INSERT INTO sue_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Are ema tua nu bua mai nusore ego senua awa, ‘Nena sawero siawai itia, ata amira oziga sai awa nukare azu dotinora, are na nukare ina dotinona. ");
INSERT INTO sue_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Are nikare nata kakamo sero baro erama tamamunowa awa te sero puro mawise tona.’ ");
INSERT INTO sue_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ago senu bua mai nuso nukare so sero noise ema wayare kokore tepo-tapo pumuwa kei awero aunai ibu awa bemuro itiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Itiwa ema tua meni nukare gamu sero witiro ema zo ana-bona waira tama woi tepo itinu giro numore ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Otao, ni nogoro ana-bonara tama woi kaka wosunamu muro itesi?’ Ago senu nu nogo sei wero doro itinua awa. ");
INSERT INTO sue_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Are ema tua meni bua mai nusore ego senua awa, ‘Nikare te wana nuso beniro ape damu mumera niu. Ana di zawa gatero zarinoise itae.’” ");
INSERT INTO sue_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu meni uge awa diro tepo wero ge susumuro ego senua awa, “Zawa sai ninai meni awa saisai, ata siana-katana wai meni awa etokaka.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yesu meni ago senu Farisayo nukare ewe bamuro ge meni wawa zo kazago wanakai gamamunoya asero ge siana-katana wewa. ");
INSERT INTO sue_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ago inomite bua mai nusokare ata Herodera Pati amira memba sai awa eni tugata wero iyetiwa Yesura nana bamuro ego sewa awa, “Gipai ema, nakare susu niso gosinowenakare. Ni ge opi zo kaka samu. Me daba towesa awa. Ota Anutura ebata meni awa witai osai te tugata wawesa ninitinowenakare. Ni ema witaire osaire awa giro azu oko inowesa. ");
INSERT INTO sue_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Are nakare ni atata inonakare, ni se. Nakai Yuda ema meni takis moni Roma emara ema tua Sisa amire potitinowenakai, awa ni gawesa te inowita tepo ni?” ");
INSERT INTO sue_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ago sewa nu duba nusokarera opi sai awa ginu kei awenu giro ego senua awa, “Opi ema me sao inowewa. Nogoro ge meni na wawa kazago inowi? ");
INSERT INTO sue_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nikare takis moni potitinowewa awa zo gipeu gane.” Ago senu omata zo tamuro gipewa giro ");
INSERT INTO sue_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","nu nukare atata wero senua awa, ");
INSERT INTO sue_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Ititire zazore monira itia ewa awara ni?” Ago senu nukare sewa awa, “Awa Sisara.” Ago sewa giro numorekare ego senua awa, “Nena Sisara asero giro Sisare potiu. Ota nena Anutura asero giro Anuture potiu.” ");
INSERT INTO sue_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ago senu nukare di tainiro doro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Waiko be da amira ana Sadukayo ema nukare Yesu nana kei awewa awa. Ema ami betai nukare noko oko eramunora ago toisowa awa. ");
INSERT INTO sue_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Nukare ami kei awero atata wero sewa awa, “Gipai ema, Mose nu ge ego gaenua, ‘Ema zo meni mai tepo betai giro nami nuso meni bama kuma nuso ataise. Ago wero amire nami nuso emo mai zo pumaise.’ ");
INSERT INTO sue_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Are nasokare nana soe namisini 7 noisowa. Are nami zewai nusokare meni bama pumuro mai kaka pumamu noe betenu, noko nami kiaka meni bama kuma nuso awa atinua. ");
INSERT INTO sue_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nu da ago ine nomite betenu nami kiaka zo meni bama da awa atinua. Ago werota wero awitupie namisini 7 dapikarago bama awa atiro betero tepo wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ago wewa amire bama kuma nusokare awa ama betenua awa. ");
INSERT INTO sue_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Are nukare dapikarago bama da awa atiwa, are be betai meni noko eramunora be amire bama awa ara wamunoi?” ");
INSERT INTO sue_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ago sewa Yesu meni numorekare ego senua awa, “Nikare Anutura ge gayaire Anutura putoure awa kaka gamu, are ge me wosunitinowa. ");
INSERT INTO sue_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Betai meni eriro noko oko ina-ata wamunora. Nukare utura angelo ine wero tepo nuamunora. ");
INSERT INTO sue_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Are eraira towa ami emo sane. Anutu nu ge ego ine nimorekare senua awa nikare kaka azimuro gamu meni sago inowa, atonua! ");
INSERT INTO sue_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nu ego senua awa, Na Abrahamto Isakare ata Yakobo amira Tua wero itewena. Anutu nu erama bebetenai asinowenakai awa gawi seka gege inowera. Are nu erama betaira Tua kota, nu erama seka itewera amira Tua wero itewia.” ");
INSERT INTO sue_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yesu meni ge ago ine senu ema bama dubu bamu ami ge nuso awa niniro di tainiro yawa sara wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesura ge meni Sadukayo ema puro osenua. Ago wenu Farisayo nukare niniro dara potiro ");
INSERT INTO sue_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","otao nusokare zo Yudara lo ge susu niniro baitai amire sewa nu Yesu etete namu sero ego ine senua awa, ");
INSERT INTO sue_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Gipai ema, lo ge nemi giti kopi bamu inoi?” ");
INSERT INTO sue_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ago senu Yesu meni ego senua awa, “‘Ara tamai niso bamubake awa Tua Anutu niso amira nana itaise. Ago inoise dubare ititire kotumaire niso meni nu sou weyo.’ ");
INSERT INTO sue_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lo ge ami lo ge dapikarago dainitinoise bamu inoya. ");
INSERT INTO sue_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ota otao nuso zo itia nuto da ago ine inorato awa. Awa ego awa, ‘Ni nitope ara tapinowesa, da ago ine ema enire weyo.’ ");
INSERT INTO sue_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lo ge eto ami Mose ata porofete ge nusokare dapikarago amira siwako inorato.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisayo ema poti dara niro noiwa Yesu meni nukare atata wero senua awa, ");
INSERT INTO sue_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nikare Yuda emara Soyai Ema zazo Kristo amire nogo towewi? Nu ara sibuna ni?” Ago senu nukare ina sewa awa, ");
INSERT INTO sue_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Nu Dawidira sibuna.” Ago sewa Yesu meni ina senua awa, “Agoro Dawidi nu Ozana meni gaenu nogoro amire Kristore Tua naso asenu? Ago tona, nera kota, Dawidi meni ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tua meni tua nasore ego senua awa, ‘Ni muro wana me nasora arumuro itasa na iwo dubu niso awa benau nisora potana isimamunosa.’ ");
INSERT INTO sue_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Are amire Dawidi meni Kristore Tua naso asenua awa. Are Kristo nu nogoro Dawidira sibuna wamunoi?” ");
INSERT INTO sue_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ago toise atata wenu nukare ge ina kapetenamu wero ge kau wewa awa. Ago wero nu noko atata wamu oko kotumuwa. ");
INSERT INTO sue_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Be amira ana Yesu meni ema dubu bamu ata bua mai nuso awa ego tugata wenua awa, ");
INSERT INTO sue_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lo ge gipai ema ata Farisayo nukare Mosera lo ge gipai ema wero nowera. ");
INSERT INTO sue_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Are ge sero gipero awara te niniro dimuwo. Ota nuai nusokare meni awa amira oko nuawe. Nera kota, nukare be meni sai ine awa towera awa, ata dimai meni awa oko dipinowera. ");
INSERT INTO sue_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nukare potai ge witai nena mou-mau ine awa siawero zasero diro nisokare nana tame potiro dimawise towera. Ata nutopekare dimai azu sero nowera awa. ");
INSERT INTO sue_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nena inowera awa ema meni giro ara tamarise awa daba inowera awa. Nukare Tuara ge eni gaero puro paus kikinakara potiro meweneta wanera diro puro nuarise sai*, awa dainiro paus babezinomara diro puro nowera, awa gosinowa. Noko, tama woi bera asina iboboi simawera bukere wero itewia, awa gosinowa. ");
INSERT INTO sue_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ago inoise ana-bona wero naira bera ena nukare ema bamu sia sero nena bamu potara namu towera. Ota yere ibura ena ema bama nana benaura arumamu yaba inowera. ");
INSERT INTO sue_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ema bama meni kakame ena nukare arenitinoise poti ike narise yaba inowera. Ago wero zazo nusokare gipai ema asara ninamu yaba inowera. ");
INSERT INTO sue_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ninekare meni awa nikare gipai ema asarise oko sawe. Nera kota, gipai ema nisokare daimata gege noya. Noko ninekare meni awa otao daba. ");
INSERT INTO sue_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ago wero zebura ema zore ‘gera mama nasokare’ oko sawe. Mama nisokare daimata utura awa daba awa. ");
INSERT INTO sue_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ago wero giti kopi asarise dai oko sawe. Giti kopi nikare daimata awa Soyai ma nisokare Kristo awa. ");
INSERT INTO sue_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Zo nu nimorekare enire sou wamunoya ami bamu nisokare wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Zo nu nutope puro wititinoise nuai giro Anutu meni nu puro osamunoya. Ota zo nu osero nuamunoya, awa Anutu meni zazo nuso de ike namunoya. ");
INSERT INTO sue_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yei, lo ge gipai ema ata Farisayo. Nikare opi ema me sao inowewa. Ema bama nukare utura mokara toyamu sawera ninekare nukare musunago inoise utura so be gazinowewa awa. Nikare nitopekare kaka toyamu inoise amire nukare toyamu sawera azu towewa awa.  ");
INSERT INTO sue_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yei, lo ge gipai ema ata Farisayo. Nikare opi ema me sao inowewa. Nikare bama iu betai amira wau awa soero pupinowewa. Ago inoise pasina nisokare gogo wero me irora inoise isa iboi-tatana towewa. Isa iboi-tatana meni pasina nisokare kaka gogo wamu wamewa sia, awa ama ina nisokare waya pei-kaka gege pumamewa. Ata nikare isa iboi-tatana meni pasina nisokare gogo wero me irora inowewa, are amira ama ina nisokare mou-mau bamu tamamunowa. ");
INSERT INTO sue_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Yei, lo ge gipai ema ata Farisayo. Nikare opi ema me sao inowewa. Nikare ema mai daimata ami tani nisokare ama ganaise zebure eware semuro susawewewa awa. Are ago ine ami nisokare nana susumawi uzumuro nuawewa nu dega niaore amira gegenai wero witiro nikare dainitinowia awa. ");
INSERT INTO sue_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yei, gita wai ema giti guma wai. Nikare ego towewa awa, ‘Anutura ibu bamu amira ikonitinoise sai zewai wai awa puti. Ota Anutura ibu bamura simai nena itia amira ikonitinoise sai zewai wai ami meni awa me.’ Ago towewa. ");
INSERT INTO sue_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yei, dau ema giti guma wai. Anutura ibu bamu awa saramai itewia ami emo simai nuso meni saramai inowia awa. Are amire nemi me memeka inoi, ibura simai nena menita ibu meni ni? ");
INSERT INTO sue_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","O zo ego towewa awa, ‘Altara ikonitinoise sai zewai wai awa me tepo. Ota zawi alta tame itia amira ikonitinoise sai zewai wai ami meni me awa.’ ");
INSERT INTO sue_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yei, ema giti guma wai nikare. Alta awa saramai itewia ami emo nuso nana tame zawi potai ami saramai inowia awa. Are nemi me inoi, zawi menita alta meni ni? ");
INSERT INTO sue_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Are zo nu altara ikoniro sai zewai wai alta ata alta tame nena itia awa dai pumamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ota zo numa Anutura ibu bamura ikoniro sai zewai wai giro ibu bamu ata Anutu ibu bamura nowia awa dai pumamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ota zo nu utura ikonitinoise sai zewai wamunoya, awa Anutura arumaire arumaira mamere dai pumamunoya. ");
INSERT INTO sue_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yei, lo ge gipai ema ata Farisayo. Nikare opi ema me sao inowewa. Nikare notu nisokarera nena puti awa tenira ena daimata te amira Tuara gegenai asero potitinowewa. Ago inoise lo gera agewa nena me, — eramare wanisekai saita dumi pumaita sero dimai — awa duawewa osisinowia awa. Nikare tenira ena daimata Anuture potitinoise nena me awa dai wamewa sia, awa te wamia. ");
INSERT INTO sue_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nikare gita wai ema giti guma wai. Nikare ou nai nisokarera kumisa dagimawi giro azu inoise usi potiro zozinowewa. Ota wo kamel nena bamu awa eya nukunitinowewa awa.* ");
INSERT INTO sue_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Yei, lo ge gipai ema ata Farisayo. Nikare opi ema me sao inowewa. Au-tewa nisokare tama meni awa sewawewa sarapitinowia. Ata amira mokara meni awa duba-duba wero bewana inowewa amira nena waya ami bera mai itia awa. ");
INSERT INTO sue_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisayo ema giti guma wai. Ni gita au-tewa moka sewasa saramai amire tama nuso da ago saramamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Yei, Farisayo, opi ema me sao inowewa. Nikare bi diti simena-gaena wai ine. Bi diti nu simia meni simena-gaena wai, ata tura mokara meni awa ema weture betai gugumure ami itia awa. ");
INSERT INTO sue_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nikare awa da ago ine tama aiso nisokare meni emara nana benaura saramai sao wero nowewa. Ota duba nisokare meni awa opi saire utura ge usi-besi wai meni bemai awa. ");
INSERT INTO sue_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yei, lo ge gipai ema ata Farisayo. Nikare opi ema me sao inowewa. Porofetera bi diti wawewa sarapitinowia, ota ge ema matura bi diti sipinowewa. ");
INSERT INTO sue_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ago inoise ego towewa, ‘Apipie nasokai noisowa amire nuamenakai, awa numorekare dai tairo porofete oko dero sisamenakai.’ ");
INSERT INTO sue_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nikare ge ago toise porofete dewa amira saisibuna nusokare nowa amira susu nisokare kerenitinowewa awa. ");
INSERT INTO sue_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Are porofete daira bua apipie nisokare meni zaawewa, awa wero pesuniu! ");
INSERT INTO sue_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nikare zi mamai. Nikare zira mai awiso. Pasinara ina dega niaore amira bayai awa zora awai nikare nogo wero dainamunowi? ");
INSERT INTO sue_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Are na ego tona awa. Na natope nisokare nana porofete ata kotumai ema ata gipai ema potana mara nikare eni dawa bebetenamunora, ota eni meni awa ni pasinaira damunowa awa, ota eni meni awa yere ibu nisokarera ena wamu meni damunowa, ota nikare ziro tunawa nata sero bayara baro pupise doise awamunowa. ");
INSERT INTO sue_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ago inuawa zebura ena ema saramai awa dewa bebetenitinoisowa amira ina nisokare nana kei awamunoya awa. Gita emokore ona ema saramai zo zazo Abel awa dewa betenua amira ana goroba zaawenua awa mai gege tupie donu ninekare Berekayara mai Zekaraya nu alta tumara ena dewa betenua amira ina awa nisokare nana kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na me memeka nimorekare sane. Goroba bamubamu amira pasinara ina awa ema zeme nowera amira nana kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O Yerusalem ema bama, Yerusalem ema bama. Nikare porofete dawewa betinowera. Noko Anutu meni ge ema nisokare nana potawi susawewera nukare awa omata meni dawewa betinowera. Kokara mia meni mai awiso nuso wabu duru potiro sanitinowia da ago ine nane ema bama nikare poti dara namu wawena nikare azu towewa. ");
INSERT INTO sue_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Are Anutu meni nata nisokare duai zozowa wero itamunowa, awa giu. ");
INSERT INTO sue_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sana niniu. Nikare na kaka gamu inoise noma ego toise amire na noko gamunowa, ‘Tuara bera tupia nu awa bowi wanekai.’” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu nu Anutura ibu bamura ena kei awero susaunu bua mai nuso meni nuso nana bamuro ibu bamura so gipamu sewa. ");
INSERT INTO sue_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ago wewa nu ge ina ego senua awa, “Nena bamubamu iti gosinowa amira na me memeka sana giu. Iwo meni ibu ziwero sisara tepo wamunoya. Ibura omata zo oko duara zora nana tame itamunoya.” ");
INSERT INTO sue_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu nu Oliwa dirumura witiro arumuro itinu bua mai nuso meni imata nuso nana zora bamuro atata wero sewa awa, “Nena sesesa awa be nazi kei awamunoi? Ota kei awai be niso, o zebu tepo waira be awa zora awinuai tani ne kei awai ganakare ziwamunoi?” ");
INSERT INTO sue_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ago sewa Yesu meni ego tugata wenua awa, “Ema eni meni duba nisokare sisameraya, uma wero baititinoise noiwo. ");
INSERT INTO sue_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nera kota, ema witai ami kei awero esega namore wero ego samunora, ‘Na Kristo Soyai Ema nisokare ewa.’ Ago toise erama eto oko duba siso-siso wamunora. ");
INSERT INTO sue_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nikare bogi-zuzuna zorage itamunora amire bogi-zuzuna zora-zarako itamunora amira oziga ninamunowa. Niniro azu oko wawe. Nena awa gita kei awaise sai itia. Nena ago ine kei awamunoya, ata zebura be eya oko tepo wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dubu zo meni eriro dubu zore dai bogi-zuzuna wamunora. Ota ema tua enira dubu meni eriro ema tua enira dubure dai bogi-zuzuna wamunora. Dora botiyo babezinoma kei awerota kei awero awamunora. Noko, duwi babezinoma sumurota sumuro awamunora. ");
INSERT INTO sue_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bama mai pumamu inowera amira yaya mena pei-kaka zaawinowia. Ata ama meni awa bamubake kei awinowia. Ago ine yaya sesena awa kei awai amire yaya bamubake ama kei awamunoya, awa gamunowa. ");
INSERT INTO sue_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Be amira ana ema eni meni nikare puro iwora wanera potara puro doise gaise awero dara bebetenamunowa. Ema zebu sero ami namore tini kapai pupinoise nikare bua mai naso amire iwo wamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Be amire ema saisai ami utura ge duamunora. Doro ge ina-busa inoise otao nusokare awa poti iwora wanera niro iwo ina-wa wamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ota porofete opi sai dainiro meni kei awero ema saisai duba sisamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Utura ge dai meni bamubake wamunoya susu amira ema dainiro amira nana dumi pumai tepo wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Are zo nu utura ge puro ziro tata-tata inoise zewai wero dopero noma betamunoya nu awa Anutu meni soero pumamunoya. ");
INSERT INTO sue_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anutu imata Tua wero nuamunoya amira ge bowi emi zebu sero te wero bayai ema dubu giti meni ninara amire be tepo wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Are nena waya me waya gera wai, porofete Daniel meni nena amira ge gaenua, ami ibu bamura masi saramai amira dopai gamunowa awa. (Ge azipitinosa ami niniro baitiyo.) ");
INSERT INTO sue_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ago ine kei awai giro Yudaya zebura itamunora ami azu sumuro bamu dirumura narise. ");
INSERT INTO sue_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ago inoise zo nu so nusora ope itamunoya ami neu-nau nuso sora itia awa pumamu oko toyaise. ");
INSERT INTO sue_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ota zo nu buye nuamunoya ami tama woi nuso doti itia awa pumamu oko ewesemuro nate bayaise. ");
INSERT INTO sue_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Oi, bama wasou wai ata bama mai unore, nukare pena-pana sumai ine tepo, are na nukare emo zo apinona. ");
INSERT INTO sue_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Azu bayai nisokare awa wara be amire o Sabat pura amira ana kei awai wa menita Sabat purara lo ge meni nikare gazai azu, Tua isa sewo. ");
INSERT INTO sue_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nera kota, be amira ana mou bamubake kei awamunoya awa. Zebu kei awenua ana zaawero tupie dowa mou zo ago ine oko kei awenua. Ata ama zo ago ine noko oko kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Are Tua meni be awa kaka kapamu wamia, awa erama dapikarago sisero tepo wamera. Ota nu gegenai dubu nuso emo wero amire be awa kapenua, are apunu-kaka wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Are be amire ema zo meni nimorekare ego sai oko ninawe, ‘Ewa Soyai Ema nasokai awa.’ Ota, ‘Soyai Ema nasokai owa.’ Ge ago ine sero muro baro awara oko ninawe. ");
INSERT INTO sue_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Be amira ana Soyai Ema opi enire porofete opi enire ami kei awamunora. Kei awero eramara duba siso-siso wamu sero tani putoure eni ata tani benau sekare witai awa wamunora. Ago inoise Anutura gegenai dubu awa dai amira duba siso-siso wamu sero bua bamu wamunora awa. Ata nukare Anutura gegenai dubu amira duba siso-siso wai ine tepo, are wero zainamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na nena ama kei awamunora amira ge nimorekare bere-bere tona. ");
INSERT INTO sue_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Are amire ‘Kristo so erama tepo amira ana kei aweti genakare,’ asara oko gamu bayawe. Ota ‘So du ena bezero iti genakare,’ awa dai sara oko ninawe. ");
INSERT INTO sue_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nera kota, piri-piri meni piri-piri awawi waiko witaira ena zasimuro eniba bamu waiko osaira niro tepo inowia, da ago ine na Emara Mai meni kei awamunona. ");
INSERT INTO sue_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bua awawi ni oa meni ibosi giro kokounitinowera. ");
INSERT INTO sue_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yaya mena-mana iwore dai tepo wai amire waiko mume wamunoya awa. Ago wai inuara zasimai awa dai tepo wamunoya awa. Ota kuna meni awa utura ena sokero osamunora awa. Ago inuai amire putou utura itewera ami zipamunora. ");
INSERT INTO sue_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ago wai amire Emara Mai amira owe utura ena kei awai ema zebu sero ami di toise itara na Emara Mai meni utura bereze tame putoure zasimai bamu nasore dai kei awana gamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Are so bamu pisara ge sai na angelo dubu naso iyetana zebu wenare wenare iketa bageni amira baro gegenai dubu naso pumamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Nikare ni fik amira tani awa kotumuro amire susu zo giu. Bona nuso gotu gi nuso zazawera be amire nikare giro, ‘O, waikora be zora awinoya,’ asinowewa awa. ");
INSERT INTO sue_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Are nena awa dapikarago kei awero tepo wai giro ego sewo, ‘Nu zora awetia. Toyai bera atune dopinoya.’ ");
INSERT INTO sue_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na me sane. Ema bama zeme zebura nora ami kaka betero tepo wamu nuara amire nena awa dapikarago kei awero tepo wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ama uture zebure nuto sisero tepo wamunorato awa, ata ge naso meni awa oko sisero tepo wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ota nena kei awai amira waiko beta aua be awa ema zo meni oko gosinoya. Utura angelo nukare da ago ine oko gosinora. Na Mai meni da ago ine oko gosinona. Mama nu imata gosinoya awa. ");
INSERT INTO sue_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tani gita Noa wara kaka witamure inoisowa da ago ine inuara na Emara Mai ewesemuro mamunona. ");
INSERT INTO sue_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nukare ou wama bamu kaka mamure nena pupise nise awinoise bama ina-pota wero atitinoise noisowa. Ago inoise noisouta asero noiwa Noa wara witinua awa. ");
INSERT INTO sue_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Witinu nukare ou wama tupinua awa kaka gamu itiwa ou wama bamu muro nukare gogowero tepo wenua awa. Emara Mai amira kei awai bera ena da ago ine wamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Be amira ana ema eto buye nuarato na zo pumuro zo duamunona awa. ");
INSERT INTO sue_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bama eto ma ditinoise itarato na zo pumuro zo duamunona awa. ");
INSERT INTO sue_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tua nisokare meni be nazi kei awamunoi, awa nikare kaka ninamu inowewa, are duba nisokare meni dia wero baititinoise noiwo. ");
INSERT INTO sue_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nikare susu ego giwo. So zora mama meni bewana ema pire mamunoya awa gamia, awa nu seka zisero itise so nuso dia wero baitai bewana ema oko toyamia. ");
INSERT INTO sue_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Are Emara Mai amira kei awai be kaka gamu inoise na oko mamunona ago tuawa be amire mamunona. Ami emo nikare sia inoise noiwo. ");
INSERT INTO sue_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nikare soumai kokopai wero noiwo. Soumai kokopai nu kotumai ewanana puro nuai giro ema tua nuso meni nu soumai nuso dapikarago dia waise samunoya. Nu nukare dia inoise wo ma numorekare potitinuaise samunoya awa. Ema tua nuso meni bua ge awa numore potiro doro baro nuamunoya. ");
INSERT INTO sue_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Are soumai ami bua numore sai awa te dipinoise nuai, ema tua nuso meni ewesemuro bua nusora me giro tani kokopai numore wai yawa sara wamunoya. ");
INSERT INTO sue_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na me memeka sane. Ema tua nuso meni dia bua bamu soumai amire potitinoise nena nuso bamubamu dapikarago dia waise samunoya. ");
INSERT INTO sue_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ota soumai awa dia waya noise duba nuso meni ego samunoya, ‘Ema tua naso meni eya oko ewesemamunoya. Noma ama ewesemamunoya.’ ");
INSERT INTO sue_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ago toise sou wai bua emare bamere dero usi-besi inoise otao nuso eni ou zewai niro dau inowera amire dai ana-bona wise ou zewai nise awinoise dau wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ago inoise noma ema tua nuso ewesemaira be awa kaka gamu inoise nu eya oko ewesemamunoya ago toise nuai, ema tua nuso ewesemuro mamunoya. ");
INSERT INTO sue_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Muro soumai awa pena-pana wezero dero ge opi sai emara ina tamamunora masi da amira potamunoya. Ana di zawa gatero zarinoise itamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Be bamu awa kei awai amire utura itewia ami imata Tua wero nuamunoya amira susu awa ego ine kei awamunoya. Na sou bama diri 10 amira potiro sana giwo. Ema zo meni seronai nuso atamu sero seronaira mamera nana tupia. Are sou bama diri 10 ami ema awa ebete ena tamuro puro mamu sero lam nusokare puro susawera awa. ");
INSERT INTO sue_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bama diri 5 nukare awa dau, ota 5 nukare meni awa kotumaire. ");
INSERT INTO sue_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Are dau meni awa lam nusokare daba pupinora awa. Botora ou meni awa kaka nigero pumamu. ");
INSERT INTO sue_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ata kotumaire meni awa lam nusokare pumuro ou botora dai nigero pumuro susawera awa. ");
INSERT INTO sue_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Are ema awa eya kaka mamu, borere noi nukare dia itimite betero giro gitawa inora awa. ");
INSERT INTO sue_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Gitawa inora pi soe sieniro zawa zo ego ine kei awinoya awa, ‘Ema tupia. Eriu, baro tamawe.’ ");
INSERT INTO sue_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Are bama diri 10 nukare niniro giro eriro lam nusokare sia-masia inora awa. ");
INSERT INTO sue_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Are bama diri dau nukare bama diri kotumaire amire ego tora awa, ‘Nakare lam nasokare sikipitinora, are nikare namorekare ou nigeu.’ ");
INSERT INTO sue_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ago tora bama diri kotumaire meni ina numorekare ego tora awa, ‘Tepo awa. Ou nakai dapikarago amira te oko wamunoi, tanita. Are nikare stoara baro nisokare zuma gaero pumuu.’ ");
INSERT INTO sue_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ago tora giro nukare ou zuma gayamu sasawera ema awa kei awinoya. Are sou bama diri 5 nena sia wero lam nusokarere dopero itera awa uzumi ataira ana-bona wamu mamera sora toitinora. Sora toiro so be gazero ana-bona ninoise itera awa. ");
INSERT INTO sue_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Itera ama bama diri dau nukare muro zawa toise ego tora awa, ‘O Tua nasokare, toyai be pieyo.’ ");
INSERT INTO sue_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Zawa tora ina ego toya awa, ‘Na me memeka nimorekare sane. Na nikare kaka gamu inowena.’ Ago toya awa.” ");
INSERT INTO sue_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu meni ago sero ge susumuro ego senua awa, “Nikare be awa kaka gamu, are dia wero baititinoise noiwo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu meni ego senua awa, “Utura itewia ami imata Tua wero nuamunoya amira susu gawise sero na soumai etorobara amira potiro sane. Ema tua zo meni zora-zarako bayamu sero dia dubu nuso dorowe dara niro moni nuso dia warise kanowenua. ");
INSERT INTO sue_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ago inoise soumai zore K5,000 potiro zore K2,000 potiro, zore K1,000 potinua awa. Awa moni tamaira putou nusokare te gosinoise potinua. Moni potiro tepo wero nu doro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nu susawaise sumai moni K5,000 pumunua ami omata awa puro bua wero susumurota susumuro awinoinu K5,000 ago te kei awenu moni nuso K10,000 wenua. ");
INSERT INTO sue_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ota otao nuso K2,000 pumunua numa da ago bua wenu K2,000 susumunu omata nuso K4,000 wenua. ");
INSERT INTO sue_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ata soumai K1,000 pumunua ami ema tua nusora moni puro baro gowenu itinua awa. ");
INSERT INTO sue_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Are ema tua nusokare be iboi-tatana noe ewesemuro kei awenua awa. Kei awero soumai moni dia waira awa poti dara niro moni puro noiwa nogo kei awenu awa sarise senua awa. ");
INSERT INTO sue_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Are K5,000 pumunua ami kei awero K5,000 potiro K5,000 zo susumuro ego senua awa, ‘Tua naso, ni K5,000 namore potisa na bua inoe dona K5,000 ago te noko kei awitaya ewa.’ ");
INSERT INTO sue_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ago senu ema tua nuso meni ego senua awa, ‘Soumai ewanana ge dimaire. Ni nena pei-kaka awa ewanana dia wisesa, are nane ni nena bamubakera dia potamunona awa. Are ni mu, na ema tua nisore dai yawa sara wanege.’ ");
INSERT INTO sue_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ago senu soumai K2,000 pumunua awa kei awero ego senua awa, ‘Ema tua naso, ni moni K2,000 namore potisa, awa nane puro bua inoe dona K2,000 ago noko kei awitaya ewa.’ ");
INSERT INTO sue_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ago senu ema tua nuso meni ego senua awa, ‘Soumai ewanana ge dimaire. Ni nena pei-kaka awa ewanana dia wisesa, are nane ni nena bamubakera dia potamunona awa. Are ni mu, na ema tua nisore dai yawa sara wanege.’ ");
INSERT INTO sue_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ago senu ama moni K1,000 pumunua ami kei awero ego senua awa, ‘Ema tua naso, na susu niso ego gosinowena awa. Ni ema dokakare. Ema zo meni buye nena urinowia awa ni me nuso pupinowesa. Ota zebu agewa zo amira ema zo meni wuit me apawi eriro zamawi ni wuit me nuso pupinowesa. ");
INSERT INTO sue_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Are na amira azu wero moni niso gowena itewia. Are zeme na moni niso nimore potitinona ewa.’ ");
INSERT INTO sue_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ago senu ema tua nuso meni ina ego senua awa, ‘Ni soumai waya timara. Ema zo meni buye nena urawi me nuso pupinowena, o ema zo meni wuit me apawi eriro zamawi pupinowena, awa gesa me weti sia, awa ");
INSERT INTO sue_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ni namore ago kotupitinoise moni naso awa moni dia wai emara nana potasa bua wara zapinuai kei awero pamena, awa te wamia.’ Ago sero soumai enire ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Are nikare moni nuso soero pumuro K5,000 puro nowia amire dai potiu pumae. ");
INSERT INTO sue_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Zo nu nena numore potai awa puro noise ami bua wai giro eni susumuro numore potamunona. Ago wana amire zamai nuso nana kei awamunoya awa. Ota zo nu nena numore potai awa puro noise ami bua kaka wamu wai giro na nena pei-kaka nuso nana itia awa soero pumamunona. Ago wana nu tepo nuamunoya. ");
INSERT INTO sue_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ota soumai timara nu awa pumuro asike mumera apawa ana di zawa gatero zarinoise itaise.’ ");
INSERT INTO sue_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Noma ama na Emara Mai meni utura zasimai nasore angelo dubure dai kei awero Tuara arumai simena-gaena wai amira arumuro itamunona. ");
INSERT INTO sue_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ago inoise ema zebu sero poti dara nana naso nana aunamunora awa. Are wo dia ema meni lamare memere awina-dawina inowia ago ine na erama awina-dawina wero ");
INSERT INTO sue_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","lama awa benau nasora dubu damunona awa. Ota meme meni awa naso nana atune dubu damunona awa. ");
INSERT INTO sue_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ago wero na Tua meni benau nasora itamunora numorekare ego samunona awa, ‘Mama naso meni gawa wenua nikare muu, utu nata nisokare topetawe. Nata awa gita emoko zebu kei awenua be amira ana nimorekare gegeninua. ");
INSERT INTO sue_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nera kota, nikare namore ego wewa: Meri betena giro na ma potiwa; ou uza betena giro na ou potiwa; esewa noise itai-matai kau inoina giro nikare na kora-makora wewa; ");
INSERT INTO sue_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","tama woi kauwena giro nikare na tama woi zo potiwa; yaya pumuna nikare na emo dumi pumuwa; benai sora itina nikare na soremuwa awa.’ ");
INSERT INTO sue_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ago sana etutiro nuai meni ge ego kapetenamunora awa, ‘Tua, ni nana meri betesa ni nena potinikare? Ota ni nana ou uza betesa ni ou potinikare? ");
INSERT INTO sue_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ota nana esewa noise itai-matai kau inoisa ni kora wenikare? Ota nana ena tama woi kauwesa nakare ni tama woi potinikare? ");
INSERT INTO sue_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ota noko nana benai sora yayare itisa ni kora wenikare?’ ");
INSERT INTO sue_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ago sara na Tua meni ego samunona awa, ‘Na me memeka nimorekare sane. Otao mamai naso osai nusokare nana daimata mai awa kora-makora wewa, awa namore wewa ago inoya awa.’ ");
INSERT INTO sue_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Numorekare ago sero amire naso nana atune itamunora numorekare awa ego samunona, ‘Dega niaore amira gegenai nikare. Nikare na doro bamuu, niao zewai-zawai Mama naso meni Satan ata angelo dubu nusore wenu awai gege awinowia amira nuawe. ");
INSERT INTO sue_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nera kota, nikare namore ego wewa: Na meri betena ma kaka potamu wewa; ou uza betena ou kaka potamu wewa; ");
INSERT INTO sue_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","esewa noise itai-matai kau inoina na kaka kora wamu wewa; tama woi kauwena na tama woi kaka potamu wewa; benai sorata yayare itina na kaka kora wamu wewa.’ ");
INSERT INTO sue_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ago sana naso nana atune itamunora ami ego samunora awa, ‘Tua, ni nana ma kau inoise, ou kau inoise, itai-matai kau inoise, mo kau inoise, yayareta benai sora itisa ni kaka soremamu wenikare?’ ");
INSERT INTO sue_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ago sara na ego samunona awa, ‘Na me memeka sane. Otao mamai naso osai nusokare nana daimata mai awa kaka kora wamu wewa, awa namore kaka wamu wewa ago inoya awa.’ ");
INSERT INTO sue_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ago sana nukare gera wai gege gera wai amira nate bayamunora. Ota etutiro nuai meni awa nuai me ewanana amira nate bayamunora.” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu nu ge awa dapikarago tomite sero tepo wero bua mai nusore ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Waiko be eto ganakai amire Betai Daininua amira pura kei awamunoya, awa gosinowa awa. Are be amira ana nukare na Emara Mai ni pasinaira betanise puro emara nana wanera potamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Are be amira ana pris babezinoma ata Yuda emara simai nukare pris bamu zazo Kayafa amira nana aunai sora witiro ");
INSERT INTO sue_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesu saitiro puro damu ge diwa dagimunua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ago inoise sewa awa, “Ema bama uzanakai tini kapai gorobare wai azu, pura be amire oko wanekai.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu meni Betani nate bamuro Simon boya ayare noinu kora wenua amira nana sora ena nena ninoise itinu ");
INSERT INTO sue_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","bama zo meni nuso nana bamuro ou zamare zuma bamubakere boto omata meni wai amira nigai, awa puro nuso nana gitine zozenu gutenua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ago wenu bua mai nuso meni giro dumu wero ego sewa awa, “Nena zuma bamure awa nogoro gera inoi? ");
INSERT INTO sue_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ami moni witai tamai ema bogamasare potaikai awa!” ");
INSERT INTO sue_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ago sewa Yesu meni niniro numorekare ego senua awa, “Nikare nogoro bamere zuzu towi? Bama nu namore dumi pupinoi ewanana inoya. ");
INSERT INTO sue_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Erama bogamasa nukare nimorekare dai be giti nowera nuamunora. Ata nane meni awa nimorekare dai oko nuai gege nuamunona. ");
INSERT INTO sue_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Na be pei-kaka noma betana gowamunowa awa. Are nu bere-bere tama naso simuro sia inoya. ");
INSERT INTO sue_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na me memeka sana niniu. Oziga Ewanana zebu sero susawiai amire tani ewanana namore wetia amira oziga awa dai sero sero awara bayamunoya awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Are bua mai nuso 12 nusokare nana zo zazo nuso Yudas Iskeriot nune ami pris babezinomara nana bamuro ");
INSERT INTO sue_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ego ine senua awa, “Na Yesu kereniro poti wana nisokarera nana nikare namore moni nazo potamunowi?” Ago atata wenu nukare silva moni 30* azimuwa pumunua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pumuro Yesu gera potaira ebata tamamu bua wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Betai Daininua amira pura kei awenu Yuda ema bama meni yis sienitinoise noiwa amire Yesura bua mai meni nu atata wero sewa awa, “Nakare zeme so nana Betai Daininua amira bona niso sawero sia-masia wanisekare kotupitinosi?” ");
INSERT INTO sue_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ago sewa ina ego senua awa, “Nikare Yerusalem nate bamuro ema zo gita sesena goisewa amire ego tugata wewo gae, ‘Gipai ema nasokai nu nimore ego toya awa: Be naso zora awinoya, are niso nana muro bua mai nasore dai Betai Daininua amira bona namukare tona,’ ago seu gae.” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Are Yesu meni ge awa senu bua mai nuso meni dimuro Betai Daininua amira bona sawero sia-masia wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tua zinu Yesu nu bua mai nuso 12 pumunu Yerusalem baro so amira witiro Betai Daininua amira bona niwa awa. ");
INSERT INTO sue_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ninoise Yesu meni ego senua awa, “Na me memeka nimorekare sane. Nisokare nana zo meni na kereniro iwora nana wanera potamunoya.” ");
INSERT INTO sue_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ago senu bua mai nuso nukare duba nitinoise da da nu atata wero sewa awa, “Tua, namore tosita?” ");
INSERT INTO sue_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Asewa nune ego senua awa, “Namore dai ame sura patamunonato nune ami na kerenamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Na Emara Mai meni ebata namore sero gaewa amira bayamu sero inona awa. Ota ema na kerenamunoya nu awa, oi! ina nuso nogo pumamunoi? Mia nu kaka pumamu wamia, awa nu waya oko tamamia.” ");
INSERT INTO sue_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ago senu Yudas kerenai ema ami da ago nu atata wero senua awa, “Gipai ema, namore tosita?” Ago senu ina ego senua awa, “Tosa awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nukare nena ninoise itiwa Yesu meni porong pumuro Anuture kokopai asero eweweniro bua mai nusore potitinoise ego senua awa, “Pumuro niu. Ei awa pisi naso.” ");
INSERT INTO sue_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ago sero akou ou wainre zo pumuro Anuture kokopai asero numorekare potitinoise ego senua awa, “Nikare dapikarago ami niu. ");
INSERT INTO sue_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ei awa orara naso. Orara ami Anuture tairo nuai amira ge ziai zewai wamunoya. Ema dainiro amira pasina disaise zozamunona. ");
INSERT INTO sue_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sana niniu. Na ou wain zeme ninonakai awa doro kaka namu noma Mama naso imata Tua wai amire nimorekare dai ou wain seka zo namunonakai awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nukare yere zo gamuro eriro Yerusalem doro bamuro dirumu zazo Oliwa amira witiro itiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ebete susawise Yesu meni ego senua awa, “Pi emire nikare dapikarago azu wero na doro bozamunowa. Nera kota, ge gayai zo ego itia awa me wamunoya, Na Anutu meni dia ema dana lama nukare sisamunora awa. ");
INSERT INTO sue_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ata na betaira ena eriro Galilaya zebura bayana nikare ama mamunowa.” ");
INSERT INTO sue_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ago senu Petoro meni ego senua awa, “Eni bamu awa dapikarago ni azu duara nane ni oko duamunona.” ");
INSERT INTO sue_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ago senu Yesu meni ego senua awa, “Na me memeka sana nini. Nine pi emire kokara ge kaka samure na begi wasa be etorobara wamunoya.” ");
INSERT INTO sue_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ago senu Petoro meni ego senua awa, “Nukare na nimore dai dara betanise samunora, ata saineba, na ni oko begi wamunona.” Ago senu bua mai otao mamai eni meni da ago nu soremuro sewa awa. ");
INSERT INTO sue_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu bua mai nusore susaumite ni bua zo zazo Gesemani amira kei awero Yesu meni bua mai nusore ego senua awa, “Nikare ego arumuro itawa nane ogo bamuro isa samunona.” ");
INSERT INTO sue_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ago sero Petoro ata Zebedira mai eto puro bamuwa awa. Bamuwa Yesu nu duba nitinoise duba mou wenu ");
INSERT INTO sue_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","numorekare ego senua awa, “Na duba nai bamure nona duba nai meni na puro osesi betanise inoya. Are nikare namore dai ego itise seka zisero uma wewo.” ");
INSERT INTO sue_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ago sero agewara bamuro giti benau nuso poti zebura niro ego toise isa senua awa, “Mama naso, ninasa wai sogo ine wai giro yaya bamu ei awa na dainae. Ata ge naso kota, ge niso meni me waise.” ");
INSERT INTO sue_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Isa ago sero mai etorobara nana ewesemuro nukare gitawa inoiwa giro Petorore ego senua awa, “Nikare namore dai aua daimata gege seka zisero itai ine tepo, atonua! ");
INSERT INTO sue_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nikare etetenaira beyata wai azu, seka zisero itise isa seu. Duba nisokare meni bua kokopai waira peu inoya, ata tama meni awa mou inoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Are noko baro ge ego toise isa senua awa, “Mama naso, yaya bamu ei awa na dainaise ninasa te kaka wamu wai giro saineba dimuro tepo wana ge niso meni me wae.” ");
INSERT INTO sue_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Isa ago sero ewesemuro bua mai nukare giti moweninu gitawara dago itiwa ginua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Giro doro noko bamuro isa senu be etorobara wenua. Ge gita senua da awa toise isa senua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Isa sero tepo wero bua mai nana ewesemuro ego senua awa, “Nikare gitawa gege inoise itewa, atonua! Be kei awetia. Emara Mai kerenera pasina emara nana wanera wititinona. ");
INSERT INTO sue_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kerenai ema tupia. Eriu, nusokare nana bayanekai.” ");
INSERT INTO sue_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ago tuaise bua mai 12 amira otao nusokare Yudas meni iwo dubu bamu gita wenu kei awewa awa. Iwo dubu awa pris babezinoma ata Yuda emara simai ami iyetiwa goroba wamu sero kasiware dobare pumuro puro kei awewa awa. ");
INSERT INTO sue_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Gita kerenai ema meni iwo dubu bamure ge zo gipero ego senua awa, “Ema nane saniro imamunona, numa awa. Nu awa saniro pumamunowa.” ");
INSERT INTO sue_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Are kei awero eya Yesu nana bamuro, “O gipai ema naso,” ago sero imunua. ");
INSERT INTO sue_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ago wenu Yesu meni ego senua awa, “Otao, bua niso wamu sero mesa awa we tepo wae.” Ago senu nukare muro nu puro wana beniwa awa. ");
INSERT INTO sue_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Are Yesure dai noiwa amira nana zo meni kasiwa nuso egira ena zinu kisimunu pris bamura soumai awa damu wero dana nuso kesenua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ago wenu Yesu meni ego senua awa, “Kasiwa niso egira poti toyae. Zo nu goroba wamunoya ami ina nuso da awa goroba tamamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ni susu naso itia awa kaka gamu inoise ago inosita? Mama naso isa sana zeme-zemeke angelo 70,000 potai osero na soremamera, ata dotinona. ");
INSERT INTO sue_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ago osero na soremara ge gayai meni eba naso ego ine kei awaise towia ami nogo wero me wamunoi?” ");
INSERT INTO sue_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ago sero ema dubu bamu nu pumamu muwa amire ego senua awa, “Nikare kasiware dobare puro tupewa, awa goroba ema zo puro benamu mago inowa. Be giti awa na nimorekare dai ibu bamura nuawena nikare ana nogoro na kaka pumamu inowewi? ");
INSERT INTO sue_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ota nena ei awa porofete meni ge gaewa awa me wero tepo waise kei awinoya.” Ago senu bua mai nuso nukare dapikarago Yesu doro zanero tepo wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ema Yesu ziro saniwa ami nu puro bamuro pris bamu zazo nuso Kayafa amira nana sora puro witiwa. So amira ena lo ge gipai emare simaire ami auniro itiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yesu puro susauwa Petoro nu asike ena ama ganinoise bezegi-bezegi bamunua awa. Susaumite kei awero pris bamu amira nana goma mokara toinua awa. Toiro pris bamura soumai amira nana soe ego sero arumuro itinua awa, “Yesura ge nogo sara zewai wamunoi, ego itise ninane.” ");
INSERT INTO sue_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Are pris babezinoma ata giti kopi dubu nukare te itise ema zo meni Yesure opi sai Yesu gera potiro dara betaise sero opi ge siana-katana wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ago inoise ge opi dainiro sewa kei awenu niniwa mou kaka wamu wenu giro opi ge ewanana zo tamamu sero bua inoise itiwa. Ago inoise itiwa ema eto eriroto ego sewato awa, ");
INSERT INTO sue_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Yesu nu ego sesi ninisenato awa, ‘Nane Anutura ibu bamu ziwero waiko be etorobara gege tepo wai amire noko wana dopamunoya. Na ago wai ine te.’ Ago sesi ninisenato awa.” ");
INSERT INTO sue_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ago sewato pris bamu ami eriro Yesure ego senua awa, “Ni nogoro ge niso torato amira ina kaka samu ge tepo itesi?” ");
INSERT INTO sue_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ago senu Yesu meni ge ina kaka samu tepo dopero itinua awa. Ago wenu pris bamu meni noko atata wero senua awa, “Anutu putoure amira nana benaura ni atata wana se zewai wae. Ni Yuda emara Soyai Ema zazo Kristo, Anutura Mai meta tepo ni?” ");
INSERT INTO sue_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Atata wenu Yesu meni ego senua awa, “Aware tosa awa. Ata zo sana niniu. Noma na Emara Mai meni Anutu Putoure amira nana wana mera arumuro itana gamunowa. Na utura berezera tame itana osero muro kei awai gamunowa.” ");
INSERT INTO sue_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ago senu pris bamu ami ge awa nininu waya wenu nu tama woi nuka nuso zinu keenu ema dubu nusore ego senua awa, “Nu Anutu dainamu inoise toya, are nakai nogoro ema eni muro nu gera potarise samunonikai? Nu nutope aware gera potia. ");
INSERT INTO sue_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ge waya awa nitopekare niniro nogo towi?” Ago senu nukare ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","“Nu betaira gegenai inoya awa.” Ago sero Yesu nana giti mokara pora pisero nu dero musuna-masuna wewa awa. Ota eni meni awa wana moka meni opowara dero ");
INSERT INTO sue_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","numore ego sewa awa, “Yei, Soyai Ema Kristo. Ni porofete wero giro se, ema ni doinoya amira zazo aweni?” ");
INSERT INTO sue_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ago inoise noiwa Petoro nu goma mokara nate kakame itinua awa. Itinu soumai bama diri zo meni nuso nana bamuro ego senua awa, “Nine ami Yesu Galilaya ema omire dai nowesa awa.” ");
INSERT INTO sue_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ago senu nune ema itiwa amira nana benaura begi inoise senua awa, “Ni ge tosa awa na kau inona.” ");
INSERT INTO sue_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ago sero eriro goma toyai bera kenara baro itinu noko soumai bama diri zo meni giro ema ago itiwa amire ego senua awa, “ma ei awa Yesu Nasarete natara amire dai nowia.” ");
INSERT INTO sue_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ago senu Petoro meni Anutura nana benaura senu zewai wenu noko begi inoise senua awa, “Na ema owa kaka gamu inowena.” ");
INSERT INTO sue_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ago sero dopinoinu be apunu-kaka tepo wenu ema itiwa ami Petoro nana bamuro ego sewa awa, “Nakare ou ge niso ninitinonakare Galilaya emara ge ine inoya. Ni me dubu nusora zo awa.” ");
INSERT INTO sue_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ago sewa nu noko Anutura nana benaura ge ego senu zewai wenua awa, “Na opi samunona, awa Anutu na dai betamunona. Na ema awa kaka gamu inowena.” Ago tuaise kokara meni ge senua awa. ");
INSERT INTO sue_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Are Yesu meni gita ge ego senua, “Kokara ge kaka samure nine na begi wasa be etorobara wamunoya,” ge awa kotumuro kei damu niro di bamu senua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pina atinu pris babezinomare simaire nukare poti dara niro te aunitinoise Yesu dara betaise sewa zewai wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ago wero sewa Yesura wana eto beniro puro Romara ema tua Pilato amira nana bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Betaise sewa zewai wenua awa Yudas kerenai ema meni niniro giro nogoro ago weteni asero duba nuso waya wenu moni potiwa awa puro bamuro pris babezinomare simaire potinua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ago inoise ego senua awa, “Na were-were wero ema pasina tepo awa kerenena pumewa.” Ago senu nukare ego sewa awa, “Nakare ne wanisekare muro tosi? Awa nena niso gege.” ");
INSERT INTO sue_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ago toise moni eseniwa puro bamuro Anutura ibu bamura apenu witinu nu doro baro mui dube wero betenua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ago wenu pris babezinoma meni moni silva awa sianiro poti dara niro ego sewa awa, “Moni ei awa dai betaira zuma, are ibu bamura akoura potanakai oko te wamunoya.” ");
INSERT INTO sue_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Are nukare moni ami ne wamunonikai asero ina-sa inomite sewa te wenu moni awa puro bamuro au wai emara nana zebu agewa zo zuma gaewa awa. Ema esewa muro betara ana gowara bi diti waise sero zuma gaewa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Are zebu amira zazo “Orara Zuma Gayaira” asewa zewai wenua itewia awa. ");
INSERT INTO sue_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Are porofete Yeremiara ge me wenua awa. Ge awa ego awa, Isreli ema nukare zuma nuso silva moni 30* asewa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ema moni silva 30 ami au wai emara nana zebu zuma gaewa awa. Tua meni namore senua da ago wewa. ");
INSERT INTO sue_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nukare Yesu puro bamuwa ema tua nana benaura dopenu ema tua meni atata wero senua awa, “Ni Yuda emara ema tua ni?” Ago senu Yesu meni ego senua awa, “Iyo, tosa awa.” ");
INSERT INTO sue_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ago senu pris babezinomare simaire meni nu gera potamu toiwa nu ge ina oko senua. ");
INSERT INTO sue_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ago wenu Pilato meni atata wero senua awa, “Nimore ge mou-mau tora awa ninitinosita?” ");
INSERT INTO sue_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ago senu Yesu meni ge ina kaka samu tepo itinu ema tua meni giro di taininua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Betai Daininua amira pura sero ema tua nu Yuda ema zo zazo sasara benai sora ena besero awinoisonua. ");
INSERT INTO sue_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Are be amira ana goroba ema waya me waya zo benai sora itinua zazo nuso Barabas. ");
INSERT INTO sue_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Are ema dapikarago auniro dopinoiwa Pilato meni atata wero senua awa, “Ema zota zo besanise towi? Na Barabas besanise towita Yesu nu ema tua Kristo asai, nu awa besanise towi?” ");
INSERT INTO sue_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato meni nukare Yesu zuzu sero tepo puro bamuro nuso nana potiwa awa kotumuro amire ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Are ema tua nu ge sai zewai wai masi nusora arumuro itinu bama nuso meni ge ego potinu bamunua awa, “Ni ema saramai amira ge osino zo oko sase. Nera kota, na zeme atua wero nu emo yaya bamu tapinomite gena.” ");
INSERT INTO sue_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Are pris babezinomare simaire nukare ema bama duba gaero ago sewa awa, “Barabas awa-diro Yesu darise seu.” Ago sewa. ");
INSERT INTO sue_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Are ema tua meni noko atata wero senua awa, “Zota zo besanise towi?” Ago senu nukare ego sewa awa, “Barabas.” ");
INSERT INTO sue_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ago sewa nu atata wero senua awa, “Agoro Yesu Soyai Ema Kristo asinowa numore nogo wamunoni?” Ago atata wenu beta-be wero arero ego sewa awa, “Nu ni pasinaira betaise.” ");
INSERT INTO sue_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ago sewa Pilato meni noko atata wero senua awa, “Nogoro ago towi? Nu pasina ne wisi?” Ago senu nukare atata amira susu kaka samu inoise arero-worero sewa awa, “Ni pasinaira betaise.” ");
INSERT INTO sue_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ago sewa Pilato meni uzutiro sero zainiro tetere wero giro bogi bamu kei awai azu inoise senu soumai ou puro muwa nu Yuda emara nana benaura wana nuso sewinoise ego senua awa, “Ema saramai ei awa dai betai amira pasina awa naso nana oko itaise. Awa nena nisokare gege.” ");
INSERT INTO sue_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ago senu nukare beta-be wero arinoise sewa awa, “Dai betai nusora pasina awa nakare ata saisibuna nasokare amira nana itaise.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Are Pilato meni senu Barabas besewa kei awenu nukare Yesu asi wo tata meni wai dirinare ami wezewa awa. Wezinomite dowa amire Pilato meni Yesu ni pasinaira dara betaise sero soldia nana wanera potinua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Roma ema tuara soldia eni meni Yesu puro Roma ema tuara sora witiro sewa soldia dapikarago nuso nana auniwa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aunitinoise Yesura tama woi dutero soldiara tama woi izai wosuniwa pumunua. Awa ema tuara tama woi wosunago wewa pumunua. ");
INSERT INTO sue_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ago wero asi dirinare puro bubuna wero giti nusora wosuniwa awa. Ago wero bogi zo potiwa wana me meni puro dopenua awa. Ago wero nuso nana zora baro bawa diro nu isipitinoise ego sewa awa, “Waiko koko, Yuda emara ema tua.” ");
INSERT INTO sue_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ago wero pora pisinoise bogi soero pumuro nu gitine dewa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ago inoise nu isipitinomite soldiara tama woi dutuniro doro tama woi nuso awa noko wosuniwa pumunu ni pasinaira damu sero puro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Puro susaumite ebete ena ema zo tamuwa zazo nuso Simon, nu Sairini natara. Nukare nu tamuro awita sewa Yesura ni pasinai soremuro dimunu bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Susaumite zebu zo zazo Goligata, ge nasokaira “Giti Kopira Wetu,” ago kei awewa. ");
INSERT INTO sue_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kei awero ou wainre ou dokaka yaya nuwenaira amire dai dawero potara naise potiwa niro giro donua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ago wero nu ni pasinaira dewa awa. Dero amire tama woi nuso itagi wero pumamu sero ozina laki wewa awa. Ago wero amire tama woi nuso kanowero pumuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ago wero nu dia inoise arumuro itiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Are gitine ike ena susu nera nu deu amira ge ego ine gaero potiwa itinua awa, “Ei awa Yesu, Yuda emara ema tua.” ");
INSERT INTO sue_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Are nukare bewana wai mai eto numore dai ni pasinaira dero zo enibara zo enibara ago potiwa dopewato awa. ");
INSERT INTO sue_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Are masi amira erama izima-sauma inoise Yesu isimuro numore ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ae, ibu bamu ziwero waiko be etorobara amire ibu seka wamu sisesa ami tama aiso niso gera waira ena soeyo. Ni Anutura mai me nowesa sia, are ni nitope ni pasinaira ena ose dopase.” ");
INSERT INTO sue_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Are pris babezinoma ata lo ge gipai emare simaire nukare da ago nu isipitinoise sewa awa, ");
INSERT INTO sue_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nu gita ema eni soremuro kora inoisia, ata nu nutope soremai ine tepo awa. Nu Isreli emara ema tua nasokai nowita, awa ni pasinaira ena zeme osai nu Soyai Ema nasokai me asamunonakai. ");
INSERT INTO sue_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nune ‘Na Anutura Mai’ asinoise Anutu tuma didinowia, are Anutu meni nu yaba inoise giro nu soero pumaise ganekai.” ");
INSERT INTO sue_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ago sewa pasina ema eto dai nuto Yesu da ago isimuwato awa. ");
INSERT INTO sue_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ago numore inoiwa waiko diti 12 klok wenu mume bamu kei awero zebu te wero itinu 3 klok wenua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Are 3 klok wenua amire Yesu meni arero ego senua awa, “Eli, Eli, lema sabaktani.” Ge nasokaira, “Anutu naso, Anutu naso, ni nogoro na dotinosi?” ");
INSERT INTO sue_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ago senu dopero itiwa amira eni meni niniro ego sewa awa, “Nu Elia zawa toya.” ");
INSERT INTO sue_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ota zo meni niniro eya sumuro baro ewara somisomi zo pumuro wain dokakara patiro utura gaero Yesu meni naise sero potinu witinua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ago wenu eni meni giro ego sewa awa, “Nima do. Elia meni muro nu dusuniro potai osamunoita, awa ganekai.” ");
INSERT INTO sue_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Are Yesu nu noko zawa bamu gatenu ozana tepo wenu betenua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Betenu ibu bamura mo bamu* kimenai awa ike ena zaawero keero eto wenua awa. Duwi bamu sumunu omata babezinoma bebezeniwa. ");
INSERT INTO sue_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ago wenu bi diti be zaumunu ge ema gita betai eni meni seka ziwa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ago wewa ama Yesu nu nutope gita wero erinu amire nukare diti nusokarera ena eriro Yerusalem nata saramai amira baro ema witai amira nana kei awewa giwa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldiara giti kopi ata ema nusore nukare Yesu dia dopewa ami duwire nena enire dai kei awenua awa giro azu wero sewa awa, “Ema ei awa me Anutura Mai awa.” ");
INSERT INTO sue_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bama witai Yesu Galilaya zebura ena ama ganinoise sou wewa ami aike dopero tani awa gosinoise itiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nusokare nana eni awa Maria Madara natera, ata Maria zazo nu Yakoboto Yosefera mia, ata Zebedira mai eto amira mia awa. ");
INSERT INTO sue_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tua zinu tuwe Arimatia natara ema waure zo zazo nuso Yosefe, Yesura ge ninitinoise noisonua, ami kei awero ");
INSERT INTO sue_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilato nana bamuro Yesura woi pumamu senu nininua awa. Niniro woi pumaise soldiare senu dowa. ");
INSERT INTO sue_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dowa Yosefe meni woi pumuro mo kapawai seka zo iboi-tatana meni ewero ");
INSERT INTO sue_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","puro bamuro omata so seka wamai bi diti nuka nuso gegenai amira Yesu potiro omata bamu zo dereweninu baro be gazenu doro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Are bi diti mai bera awa Maria Madala natara nu zazoreto arumuro itiwato awa. ");
INSERT INTO sue_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Fraide tuwe wena giti darawa wenu Sarerera be zaawewa be amire pris babezinomare Farisayore nukare poti dara niro Pilato nana bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bamuro ego sewa awa, “Ema tua nasokare, nakare ge zo kotupitinonakare, awa sanekare. Opi ema omi nu seka noise ego toisonua awa, ‘Betero waiko be etorobara wai amire seka ziro eramunona.’ ");
INSERT INTO sue_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Gita nu seka noise nutope Soyai Ema Kristo asasai waya inoisia. Ata zeme meni awa bua mai nuso meni bamuro woi nuso bewana puro tara awero amire, ‘Nu betaira ena eriro seka zia,’ opi ago namorekai sara waya me waya wamunoya. Are nukare ago wai azu ni ge sasa soldia meni baro dia wero baititinuara waiko be etorobara tepo waise.” ");
INSERT INTO sue_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ago sewa Pilato meni numorekare ego senua awa, “Soldia potitinona. Are nikare puro bamuro potiwo uma wero baititinoise itare.” ");
INSERT INTO sue_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ago senu nukare soldiare dai baro omata be gazai awa asi meni diwa. Ago wero asi sona besara itai gamu sero asi osino eto awa ni saora mu meni anewa awa. Ago wero soldia eni bi diti dia warise potiro awewa awa. ");
INSERT INTO sue_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat pura tepo wenu Sande pina atitinoinu Maria Madala natara nu zazo nusoreto bi diti gamu sero bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Susauwato duwi bamu sumunu Tuara angelo zo meni utura ena osero omata musuninu enibara bamunu nu tame arumuro itinua awa. ");
INSERT INTO sue_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Benau nuso awa piri-piri ine zasipitinoinua. Ota tama woi nuso iboi-tatana awa kapa me kapawai, poraga ine awa. ");
INSERT INTO sue_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Are dia ema nukare giro azu wetu zipenu duro ema bebetenai ine wero itiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Are bama eto baro kei awewato angelo meni ego senua awa, “Nito azu oko waweto. Na gosinona: Nito Yesu ni pasinaira dai awa gamu sero tupewato. ");
INSERT INTO sue_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ata nu ego oko itia. Nu gita nimorekare senua da ago wero eria. Nito muuto, masi nuso gaweto. ");
INSERT INTO sue_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Giti moka nisoto meni giro amire eya bamuro bua mai nusore ego seuto: Yesu nu betaira ena eriro Galilaya zebura gita susawia. Are nikare baro nu ana gamunowa. Ge aware tona awa.” ");
INSERT INTO sue_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Angelo meni ago senu giro nuto bi diti doro eya azu bamuwato. Ata nuto yawa sara bamu dai wero bua mai nusore oziga samuto sumai gege sumuro bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Susauwato Yesu meni ebete ena nuto tamunua. Tamuro numoreto ego senua awa, “Pina koko.” Ago senu nuto nuso nana zora koiniroto te nuso ziwato awa. ");
INSERT INTO sue_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ago wewato Yesu meni ego senua awa, “Nito azu oko waweto. Baro otao mamai naso sawato Galilaya zebura bamuro na gamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bama eto susauwato bi diti dia nusokare nana eni meni eya sumuro baro nate ena pris babezinomare uge inoise nena kei awenua amira uge wero tepo wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ago sewa niniro nukare simaire dai auniro ge sero niniro awero soldiare moni witai potitinoise ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Nikare ego seu, ‘Pire gitawa inonakare bua mai nuso meni kei awero woi nuso bewana puro baera.’ ");
INSERT INTO sue_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ge awa ema tua meni niniro nimorekare nena zo wai azu oko wawe. Nakare nu uzutiro sanakare ninamunoya.” ");
INSERT INTO sue_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ago sewa soldia meni moni awa pumuro ge sai awa dimuwa awa. Are opi ge awa Yuda emara nana te wenua. Te wero itewia itia. ");
INSERT INTO sue_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bua mai 11 nukare awa Galilaya zebura dirumu zo gita Yesu meni numorekare senua amira witiwa awa. ");
INSERT INTO sue_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Witiro numa giro nuso nana baro kokoiniwa awa. Da da meni awa duba saisai wewa awa. ");
INSERT INTO sue_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Are Yesu meni nusokare nana zora baro ego toise tugata wenua awa, “Putou bamubamu utura amire zebura amire dapikarago namore potiro tepo wai. ");
INSERT INTO sue_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Are nikare zebu sero susawise ema dubu sero ge tugata wawa niniro awiso naso ware. Ago inoise Mama ata Mai ata Ozana amira zazora susupitinoise ge ou guteu pumare. ");
INSERT INTO sue_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ota potai ge sero gipero awinowena awa gipeu dimuro tepo ware. Are sana niniu. Na waiko be giti nimorekare dai nuana zebura be tepo wamunoya awa.” ");
INSERT INTO sue_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Kristo Anutura Mai amira Oziga Ewanana ego ine kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Porofete zo zazo nuso Yesaya meni bukura ge ei awa gaenu itewia ewa, Ei giu! Na oziga sai ema naso iyetamunona. Nu gita wero ebata niso kora wamunoya. ");
INSERT INTO sue_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nu ware gamu-gamura ena zawa sero arero ego toya awa, “Tuara ebata awa kora weu sonae.” ");
INSERT INTO sue_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yesaya meni ge ago gaenua da ago ine Yohane ge ou gutai zaawai ema ami ware itise zewai ge sasai ninitinoisowa. Ego toisonua awa, “Nikare duba kapeteniro nuai waya nisokare duawa giro amire na nikare ge ou gutamunona. Ago wawa amire Anutu meni nuai waya nisokare disai tepo wamunoya.” Ago toisonua awa. ");
INSERT INTO sue_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yudaya zebura ema bama ata nata bamu Yerusalem amira ema bama dapikarago ami nuso nana baro pasina nusokare kerenasara nu nukare ou Yodan ena ge ou gutinoisonua awa. ");
INSERT INTO sue_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanera mo wo kamel tu puro wai. Ata ipu gei nuso awa wora tata. Nu koware pikare awa ninoisonua. ");
INSERT INTO sue_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohane meni Anutura ge ego toisonua awa, “Na gita inona, ata na putou tepo. Ota ema zo ama mamunoya amira putou bamubake. Nune na dainai. Na dupuniro sandol nusora asi besai ine te oko inoya.* ");
INSERT INTO sue_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nane ge ou gutai nimorekare potena pupitawa, ata nune Ozana nimorekare potai pumamunowa.” Ago toisonua awa. ");
INSERT INTO sue_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ago inoiwa amire Yesu nata Nasarete Galilaya provinsra itia amira ana munu Yohane meni nu ou Yodan ena ge ou gutenua awa. ");
INSERT INTO sue_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Are Yesu oura ena wititinoinu utu zaumunu Ozana meni nuso nana toyamu sero ni guma ine wero osisinoinua awa ginua. ");
INSERT INTO sue_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iri niro gosinoinu ge zo ego ine utura ena osenua awa, “Ni Mai naso. Ni wama naso. Na ni emo yawa sara inona.” ");
INSERT INTO sue_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ge osenu Ozana meni nu uzumunu ware bamunua. ");
INSERT INTO sue_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ware baro waiko be 40 itinu Satan meni nu etetenamu wenua. Yesu abu wora masira noinu angelo meni nu kora wewa. ");
INSERT INTO sue_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ema eni meni Yohane puro benai sora potiwa amire Yesu meni Anutura Oziga Ewanana awa sero sero Galilaya bamunua. ");
INSERT INTO sue_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Galilaya baro ego senua awa, “Be kei awetia. Anutu imata Tua wero nuamunoya amira be kei awetia. Nikare duba kapeteniro Oziga Ewanana niniwo me wae.” ");
INSERT INTO sue_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ago wero Yesu meni ou ubu Galilaya amira kora-kora nomite Simonto nami nuso Andereare nuto ami moga oura apitinoiwato ginua awa. Nuto wo pumai ema. ");
INSERT INTO sue_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu meni numoreto ego senua awa, “Nito muuto, na ama ganaweto. Na nito gipana erama pumai ema waweto.” ");
INSERT INTO sue_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ago senu giro nuto moga nusoto eya doro Yesu ama ganewato awa. ");
INSERT INTO sue_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu meni noko pei-kaka kora-kora baro nami eto zazo nusoto Yakoboto Yohanere, nuto Zebedira mai, ami wara itise moga kora inoiwato awa ginua. ");
INSERT INTO sue_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Giro zawa senu nuto mama nusoto Zebedi ata ama-zanire wara ago doro Yesure dai bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nukare bamu nata Kapaneam niwa. Ago noiwa zanatiaira pura zazo nuso Sabat awa kei awenu giro nu Yuda emara yere ibu amira toiro nukare ge tugata wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nu ge tugata inoinu nukare ge nuso niniro di tainiwa. Awa nera kota, nu gera susu meni ge diro baitinua, awa lo ge gipai ema nusokare gipinoisowa awa doro dainiro putoure senua awa. ");
INSERT INTO sue_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ago gipinoinu ema zo bi meni nuso nana toiro itinua ami yere ibu nusokarera ena kei awenua. ");
INSERT INTO sue_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kei awero ge gunero ego senua awa, “Yesu Nasarete natara ema, ni ne wamu sero nasokare nana tupesi? Ni nakare sisamu sero tupesi, tanita? Na susu niso gosinona. Ni Anutura Mai saramai.” ");
INSERT INTO sue_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ago senua awa, ata Yesu meni bi senero ego senua awa, “Ni ge doro numa doro bamu.” ");
INSERT INTO sue_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ago senu giro bi meni ema awa denu aziapinoinu bi zawa gatinoise nu doro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ago wenu ema meni giro di tainiro ge ina-sa inoise atata wero sewa awa, “Awa neni? Nu gipai ge seka zo gipinoiwa. Nu ema putoure ine wero ge sawi nena dapikarago ge nuso dipinowera. Bi dai ge nuso dipinora.” ");
INSERT INTO sue_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ago sewa oziga nuso meni baro Galilaya zebura te wenua. ");
INSERT INTO sue_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu bua mai nusore ago wero yere ibu doro Simonto Andereare nana sora toiwa Yakoboto Yohanere numorekare dai toiwato. ");
INSERT INTO sue_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simonra imeti-gagara meni yaya tama mena-manara puro duro itinu giro nukare oziga nuso Yesure sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sewa giro Yesu meni nuso nana baro wana nuso zinu erinu tama mena-mana awa tepo wenu nu nena nusokare sawero potinu niwa awa. ");
INSERT INTO sue_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tua amumuka inoinu nukare erama yayare amire erama bi puro noisowa amire awa puro nuso nana kei awewa. ");
INSERT INTO sue_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ago wewa natara ema bama dapikarago ami toyai bera ina-musa wero toyamu sero wewa. ");
INSERT INTO sue_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu meni senu ema bama dainiro yaya eure-taure puro noisowa ami kokopai wewa. Nu bi dainiro tunenu bamuwa. Bi meni nu gosinoiwa, are nu nukare ge sai azu senu nukare ge sai ine tepo wewa. ");
INSERT INTO sue_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pire pina kaka atamure nu eriro so doro so zo erama tepo amira baro isa toinu ");
INSERT INTO sue_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon ata ema numore dai noisowa ami nu kau wero baro ");
INSERT INTO sue_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","tamuro ego sewa awa, “Ema bama dapikarago ni kau inora.” ");
INSERT INTO sue_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ago sewa nu ego senua awa, “Nata babezinoma zorage itera amira dai bayanekai. Ago barokai na Anutura ge numorekare sane. Nera kota, na bua ami emo musena.” ");
INSERT INTO sue_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ago sero nu yere ibu nusokare Galilaya zebura itisowa amira baro Anutura ge tugata inoise bi eni tuninoise noisonua awa. ");
INSERT INTO sue_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yesu tani ago inoinu ema zo boya ayare meni Yesura nana muro ge beina wero bawa diro koiniro ego senua awa, “Ni putou niso itia, are ni na kora wamu wero giro kora wasa ewanana wamunona.” ");
INSERT INTO sue_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ago senu Yesu meni nu emo zo wenu giro nu kora wamu sero wana potiro nu kimuro ego senua awa, “Iyo, na ago wamu kotupitinona. Tama niso kokopai kei awaise.” ");
INSERT INTO sue_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ago tuaise boya aya nuso eya wawa wewa tama nuso ewanana wenua. ");
INSERT INTO sue_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ago wenu Yesu meni nu eya bayaise sero ge zewai numore ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tani nimore wetena amira bowi awa ema zore oko sase. Ata ni bamu, tama niso awa prisre gipasa gae. Ago inoise nena Mose meni Anuture potawise senua, awa potasa yaya niso tepo wetia amira susu giro baitamunora.” ");
INSERT INTO sue_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ago senu ema awa so doro bamunua awa. Ata nu ema dainirore ge toise amira oziga awa sena-sana wenua. Are Yesu meni nata zota zora eramara giti mokara bayai ine te kaka wamu wenu giro nu so erama tepo amira baro itasai erama enare-onare wero nuso nana kei awinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Waiko be eni tepo wenu Yesu meni noko tera bamu Kapaneam ninu ema bama meni Yesu nuso nana baro itinua awa niniwa. ");
INSERT INTO sue_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Niniro erama dainiro meni auniro itiwa aunaira zara tepo wenu so be atune dai zara tepo wenua awa. Ago wewa nu Anutura ge numorekare toise itinu ");
INSERT INTO sue_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ema eni meni ema zo te-wana amai awa puro muwa awa. Ema zoeto-zoeto ami ema awa dimuro puro muwa. ");
INSERT INTO sue_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ata erama witai itiwa, are nukare Yesura nana zorage bayai ine tepo wenu giro nukare so ena Yesu bage itinua ana be wero ema gogare potiwa osenua. ");
INSERT INTO sue_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ago wewa Yesu meni tuma diai nusokare giro mai yayare amire ego senua awa, “Mai naka, na pasina niso disinona.” ");
INSERT INTO sue_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ago senu Yudara lo ge gipai ema eni ego kotupitinoise itiwa, ");
INSERT INTO sue_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ema emi Anutu meni wago inoya, atonua! Ema zo meni pasina disai ine tepo awa. Awa Anutura bua gege.” ");
INSERT INTO sue_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ago kotupitinoiwa giro Yesu meni nukare kotupitinoiwa awa enia wero giro numorekare ego senua awa, “Nikare nogoro ago kotupitinowi? ");
INSERT INTO sue_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nakai ema yayare amire, ‘Eri, aita wase,’ tepo ago sanakai nu kaka aita wamu wamunoya, awa nakai me namunonakai. Nera kota, ema bama meni ge nasokai gara opi wamunoya. Ata nakai, ‘Na pasina niso disinona,’ tepo ago samunonakai, awa nakai me oko namunonakai. Nera kota, ema bama meni ge nasokaira me awa gai ine tepo. ");
INSERT INTO sue_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Are na pasina disaira putou puro zebura nowena, awa gawise sero na ge ei awa dai numore samunona awa, ");
INSERT INTO sue_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Na nimore ego tona: Eri, awai masi gogare niso puro niso nana bayase.” ");
INSERT INTO sue_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ago senu nu eriro awai masi gogare nuso puro emara nana giti mokara so doro bamunua awa. Ago wenu nukare di tainiro Anutu bowi wero ego sewa awa, “Nakai tani ego ine gita kaka gamu.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu meni so awa doro ou ubura zorage noko bamunu ema bama dapikarago meni nuso nana kei awasara ge tugata inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ago inoe so awa doro susaumite ema zo zazo nuso Lewi, nu Alifayora mai, nu ami takis potaira sora arumuro itinu giro numore ego senua awa, “Ni na ama gane.” Ago senu giro nu eriro nu ama ganenua awa. ");
INSERT INTO sue_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu meni Lewi nana sora baro arumuro nena ninoise itinu takis pumai ema ata Yudara lo ge dai ema witai ami Yesu ata bua mai nusore dai arumuro itiwa. Ema dainiro ago ami Yesu ama ganinoisowa. ");
INSERT INTO sue_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Are Farisayora lo ge gipai ema eni meni Yesu takis pumai ema ata Yudara lo ge dai emare dai nena ninoise itinua, awa giro bua mai nusore ego sewa awa, “Nu nogoro takis pumai emare ge dai emare dai nena ninoi?” ");
INSERT INTO sue_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ago sewa Yesu meni ge awa niniro numorekare ego senua awa, “Ema yaya tepore meni dokta nana oko susawewera. Ata ema yayare meni gege dokta nana susawewera. Na ema nuai nuso saramai asinoya awa zawa samu oko muna. Ata na ema pasina wai ema awa zawa samu muna.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Be amire Yohanera bua mai ata Farisayo nukare ami nena nai sienitinoise itiwa. Are ema eni meni muro Yesu atata wero sewa awa, “Nogoro Yohanera bua mai ata Farisayora bua mai ami nena sienitinora bua mai niso meni nena kaka sienamu inori?” ");
INSERT INTO sue_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ago sewa Yesu meni numorekare ego senua awa, “Ema bama ataira bona inoise itara ema nu bama atamunoya ami numorekare dai nuamunoya be amire nena sienarise sawa ninamunorita? Tepo awa. Nukare ema amire dai nuamunora be amire sienarise sawa oko ninamunora. ");
INSERT INTO sue_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ata ama ema awa iwo meni puro bayara tepo wamunoya be amire nukare nena sienamunora. Da ago ine namore wara amire bua mai naso meni nena sienamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesu meni ego senua awa, “Nakai mo toto takaniro gayamu sero mo sibi seka puro mo asora oko gainowenakai. Ago wamunonakai, awa mo seka meni zumai mo aso awa noko keyai toto bamubake wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Noko, nakai ou wain seka puro meme tata matura oko niginowenakai. Ago wamunonakai, awa ou wain meni dobu wero meme tata ziai keyai ou wainre meme tatare awa zainamunonakai. Nakai ou wain seka puro meme tata sekara niginowenakai.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat pura zore Yesu ata bua mai nusore ebete noise wuit bua zo sepinoise bua mai nuso meni wuit me zisero niwa. ");
INSERT INTO sue_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ago wewa giro Farisayo meni numore ego sewa awa, “Lo ge meni nukare bua zo Sabat pura amire wai azu toya awa inora, gosa.” ");
INSERT INTO sue_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ago sewa Yesu meni numorekare ina ego senua awa, “Nikare uge zo Dawidi ata ema eni numore dai noisowa amire nukare nena nai tepo, meri betinoise itiwa amira uge awa nikare kaka ninamu meni sago inowa, atonua! ");
INSERT INTO sue_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abayata meni pris bamu wero noisonua be amire Dawidi meni Anutura ibu amira toiro ame Anutura giti mokara potitinoisowa awa ninua. Ame awa nukare osai meni nai ine tepo. Pris meni gege narise sai awa. Ata Dawidi meni ame awa puro dubu nusore potinu niwa Anutu meni ginu waya oko wenua.” ");
INSERT INTO sue_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ago sero susumuro ego senua awa, “Anutu meni Sabat pura ami erama sogawaise potinua. Ata erama meni Sabat pura awa sogawarise oko potinua. ");
INSERT INTO sue_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Are na Emara Mai meni nena dapikaragora Tua wero nowena ami Sabat pura amira Tua dai wero nowena.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu meni yere ibura noko toiro ema zo wana amai ami ago itinu tamunua. ");
INSERT INTO sue_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Erama ago itiwa ami Yesu ua inoise, “Nu ema yayare awa Sabat pura be emire kora wamunoita?” asero itiwa. Nukare awa Yesu gera potamu sero kotupitinoiwa, ");
INSERT INTO sue_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","are Yesu meni ema wana amai amire ego senua awa, “Ego mu.” ");
INSERT INTO sue_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ago sero nu numorekare ego senua awa, “Nakai tani ewanana Sabat purare wanakai te wamunoita, tani waya wanakai te wamunoi? Ota nakai erama soremanakai kokopai wara te wamunoita, ema sisanakai betara te wamunoi?” Ago senua, ata nukare usero itiwa. ");
INSERT INTO sue_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Are nu gina-gana wero tini kapenu duba waya nusokare giro duba nuso Farisayo emo di toinu emare ego senua awa, “Wana zuzuti.” Ago senu wana zuzutinu wana ewanana noko wenua. ");
INSERT INTO sue_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisayo meni ibu doro eya baro Herodera Pati memba enie dai auniro Yesu dara betaise amira ebata tamamu sero wewa awa. ");
INSERT INTO sue_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu bua mai nusore bamu ou ubura niwa awa. Galilaya ema bama witai-bake meni numore dai bamuwa. Ago wewa ema Yudaya zebura amire ");
INSERT INTO sue_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ema nata Yerusalem amire ema Idumia zebura amire ema ou Yodan enibara amire ema nata Tayato Saidonre ami bua dapikarago Yesu meni inoisonua amira ge niniwa, are nukare witai ami nuso nana muwa. ");
INSERT INTO sue_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ago wewa nu bua mai nusore ego senua awa, “Ema bama na patamera, wa sia wero zorage potiu itae.” ");
INSERT INTO sue_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ago senua, nera kota, gita nu ema yayare dainiro awa kora wenu giro ema bama yayare dapikarago ami nu kimamu sero ina-musa inoise itiwa. ");
INSERT INTO sue_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Are ema bama bi nusokare nana itiwa ami nu giro te nusora duro zawa gatinoise ego toisowa awa, “Ni Anutura Mai.” ");
INSERT INTO sue_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ago sasara Yesu meni ge zewai-zawai bire toise nukare susu nuso ema enire kerenai azu toisonua. ");
INSERT INTO sue_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu meni dirumura witiro ema eni yaba wero zawa senu nuso nana muwa ");
INSERT INTO sue_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","nu nukare siana-katana wero ema 12 pumuro buara potiro nukare numore dai nuarise senua. Nu nukare iyetai Anutura ge sarise, ");
INSERT INTO sue_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","o bi tunaira putou awa pumarise senua awa. ");
INSERT INTO sue_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nu bua mai 12 sianiro pumunua amira zazo nusokare ewa: Nu zazo seka Simonre potiro Petoro asenua awa. ");
INSERT INTO sue_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo nu Zebedira mai amireto nami nuso Yohanere amira zazo seka Boanege asenua awa. (Ge nasokaira, “Tararara mai.”) ");
INSERT INTO sue_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anderea, Filip, Batolomiu, Matiu, Tomas, Yakobo nu Alifayora mai, Tadias, Simon Zelote, ");
INSERT INTO sue_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yudas Iskeriot nu Yesu kereniro iwora wanera potai ema. Yesu meni bua mai awa buara potiro nu bamu nuso nana ninua awa. ");
INSERT INTO sue_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ema bama dainiro meni noko Yesu nana muwa nu ata bua mai nuso nukare nena nai ine tepo noiwa. ");
INSERT INTO sue_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Are dubu nuso meni ge awa niniro, “Nu dau wago inoya,” asero nu soyamu bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yudara lo ge gipai ema eni meni Yerusalem ena osero muro ego toise itiwa awa, “Bi zazo nuso Bielsebul ami nuso nana toiro itia. Are bira giti kopi ami nu soremawi bi tuninowia.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Are Yesu meni ema zawa senu muwa ge bezai eni numorekare ego senua awa, “Satan meni nogo nogo wero nutope tunamunoi? ");
INSERT INTO sue_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nata da amira erama meni awiniro ina-da wamunora, awa nata awa zewai oko itamunoya. ");
INSERT INTO sue_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ota dubu zo awiniro ge ina-sa inoise iwo ina-wa wamunora, awa dubu awa zewai oko itamunora. ");
INSERT INTO sue_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satan meni nutope iwo nuso wero putou nuso zaumuro nuamia, awa nu zewai itai te oko wamia. Putou nuso tepo wamia. ");
INSERT INTO sue_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nakai ema putou bamure zo amira wau dapikarago pumamu sero gita ema awa beniro amire so nusora toiro wau nuso dapikarago pumamunonakai awa. ");
INSERT INTO sue_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Na me memeka sana niniu. Eramara pasina dapikarago ata Anutu isimai ge nusokare awa disai te inoya. ");
INSERT INTO sue_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ata zo nu Ozana isimamunoya ema amira pasina disai ine tepo awa. Pasina nuso itai gege itamunoya.” ");
INSERT INTO sue_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu ago senua. Awa nera kota, nukare numore ego sewa awa, “Bi meni nuso nana toiro itia.” ");
INSERT INTO sue_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mia nuso ata namisini nuso nukare muro so atune dopero ge numore potiro nusokare nana maise sewa. ");
INSERT INTO sue_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Are ema diti bamu meni Yesura nana zorage arumuro itiwa ami numore ego sewa awa, “Mia niso ata namisini niso ami ni gamu sero muro atune dopero itera.” ");
INSERT INTO sue_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ago sewa nu ina ego senua awa, “Mia naso ata namisini naso awa arekare ni?” ");
INSERT INTO sue_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ago sero nu ema bama nuso nana zorage arumuro itiwa awa gina-gana wero ego senua awa, “Ema bama emi miamai naso ata namisini naso inora. ");
INSERT INTO sue_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ema bama Anutura ge niniro dipinowera ami nami naso ata nubama naso ata mia naso inora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu nu ou ubura noko baro ge tugata inoinu ema bama dainiro-bake ami nuso nana kei awewa. Are nu wa isero witiro arumuro itinu ema diti bamu meni kora itiwa. ");
INSERT INTO sue_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ago itiwa nu numorekare ge bezai eni toise nena witai numorekare tugata inoinua. Tugata inoise numorekare ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Sana niniu. Ema zo meni nena we buye apamu sero bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bamuro nena we apitinoinu we eni ebete ena duuwa ni mamai meni tamuro niro tepo wewa awa. ");
INSERT INTO sue_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ota we eni meni awa zebu omata tame kara-kara wai amira duuwa awa. Zebu awa tumou tepo, are we ami eya eriwa awa. ");
INSERT INTO sue_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ago wero tatawi nusokare iboboi tepo, are waiko meni witiro moenu binero betewa tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ota we eni meni awa zebu iwera tatawi itiwa amira duuwa awa. We awa iwere dai dapikarago te tetemo eriro iwe meni nena awa denu me kaka ziamu wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ota we eni meni awa zebu me gawire amira duro eriro zamuro me saisai ziwa awa. We zora me 30 zinu, we zora me 60 zinu, we zora me 100 zinua.” ");
INSERT INTO sue_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ago sero senua awa, “Zo nu danare meni ge ei awa ninaise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ema bama bozewa amire ema eni meni Yesure dai noisowa ata bua mai nuso 12 ami ge bezaira susu gamu sero nu atata wewa. ");
INSERT INTO sue_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Atata wewa giro nu numorekare ego senua awa, “Anutu imata Tua wero nuamunoya amira ge bezero itewia, amira susu awa nikare ninawise sai itia awa. Ata eni bamu awa ge bezaira uge gege ninarise sero towena. ");
INSERT INTO sue_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Porofete Yesaya meni ge ego gaenua awa, Nukare duba kapeteniro nuai sekara nuara na Anutu meni pasina nusokare disamena, nukare giti moka nusokare meni garise, ata oko giro baitarise. Nukare uge ninarise, ata ugera susu oko niniro baitarise. Anutu meni ago senua, are na ge bezai gege numorekare towena.” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu meni ago sero numorekare ego senua awa, “Nikare ge bezai amira susu awa kaka gamu inowita? Are nikare nogo wero ge bezai eni amira susu giro baitamunowi? ");
INSERT INTO sue_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Susu nuso ego ewa: Ema we uramu apitinoya ami Oziga Ewanana amira ge we urinoya. ");
INSERT INTO sue_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ata ema enira duba awa ebatara zebu zewai ine. Nukare Oziga Ewanana ninitinuawera Satan meni eya muro Oziga Ewanana dana nusokarera toitinowia awa soinowia. ");
INSERT INTO sue_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Da ago ine ema eni nukare zebu omata tame kara-kara wai ago ine awa. Nukare utura ge niniro eya pumuro yawa sara inora. ");
INSERT INTO sue_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ata nukare tatawi tepo. Nukare Tuara ebata awa be pei-kaka gege ama ganero noma amire waya nusokare nana kei awawi erama meni utura ge emo iwo numorekare wawera giro nukare eya ebata awa dotinowera. ");
INSERT INTO sue_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ema eni nukare zebu iwere ine. Nukare ami utura ge ninitinora, ");
INSERT INTO sue_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ata nukare zebura nena emo kotumu-katumu inoise wau moni emo yawa sara inoise nena eure-taure amira duba-duba inoise nowera, are tani ago ami utura ge gogowara me oko kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ata ema eni meni awa zebu me gawire ine. Nukare ami utura ge niniro poti dube niro me zizinora — eni 30, eni 60, eni 100.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu meni numorekare ego senua awa, “Nakai lam gaero puro au sose piero potitinowenikaita? Tepo awa. Ota nakai lam awa so atune potitinowenikaita? Tepo awa. Nakai lam gabarira kimenitinowenakai. ");
INSERT INTO sue_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nena bezai dapikarago ama kei damu namunora. Nena gogowai dapikarago ama kei damu namunora. ");
INSERT INTO sue_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Zo nu danare meni ge ei awa ninaise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nu numorekare ego senua awa, “Ge ninitinowa awa niniro baitiu. Nikare nena eramare potamunowa te Anutu meni nimorekare potamunoya. Nena amire nena enire ewesemamunoya. ");
INSERT INTO sue_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Anutu meni ema zo ge me eni puro nowia amire ge me bamubake potamunoya. Ota ema zo ge me pei-kaka gege puro nowia amira ge me awa Anutu meni soero pumamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu meni ego senua awa, “Anutu imata Tua wero nuamunoya amira susu awa ego ine itia: Ema zo meni nena we bua nusora urinowia. ");
INSERT INTO sue_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nena we urero nu awiyo-ditiyo awinoma we meni eritinuawi ema meni we eraira susu kaka giro baitamu. ");
INSERT INTO sue_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Zebu meni nu nutope gawi nenare potitinowia. Gita pogi kei awinowia amire me zizinowia. Ago wero amire me pisisinowia awa. ");
INSERT INTO sue_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pisero izawi amire ema ami naira be kei awetia asero ema eni kasiwa orosowaire nena pumarise sero buye potitinowia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu meni ego senua awa, “Anutu imata Tua wero nuamunoya amira susu awa nogo ine asamunonikai? Nakai susu awa kerenamu sero ge bezai nogo ine sanakai te wamunoi? ");
INSERT INTO sue_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anutu imata Tua wero nuamunoya amira susu awa ni zo zazo mastet asinowenakai amira me ine awa. Ema meni me awa buye urinowera be amire me awa zebura ni me dapikarago itera amira osai nusokare awa. ");
INSERT INTO sue_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ata urawera eriro ni pei-mamai zepa da gege itai awa dainiro bamu inowia. Ago wawi bona nuso babezinoma kei awawera ni mamai meni duga nusora muro bonara zau potitinowera.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu meni ge bezai saisai toise Oziga Ewanana eramare toisonua awa. Ninai nusokarera te toisonua. ");
INSERT INTO sue_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nu ge bezai gege numorekare toisonua. Ata bua mai nuso imata numore dai itasara be amire nu gera susu numorekare kerenitinoisonua awa. ");
INSERT INTO sue_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Be amire tua zinu Yesu meni bua mai nusore ego senua awa, “Nakai ou ubu semuro enibara bayanekai.” ");
INSERT INTO sue_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ago senu giro nukare ema bama diti bamu awa doro Yesu wara dago itinu giro nu puro bamuwa. Wa eni numorekare dai bamuwa. ");
INSERT INTO sue_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Susauwa bisi pena-pana kei awenu kakawa meni wa kukunamu sero inoinua. ");
INSERT INTO sue_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ota Yesu meni awa wa awene baro giti guta waira duro gitawa inoinua. Are nukare nu awa-uzero numore ego sewa awa, “Gipai ema, nakai betai sogo inonakai ami emo kotupitinosita?” ");
INSERT INTO sue_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ago sewa nu eriro bisi senero kakaware ego senua awa, “Ni tepo we. Bisi dero iti.” Ago senu so bisi binono denu ");
INSERT INTO sue_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","nu numorekare ego senua awa, “Nikare nogoro wama bazizinoi? Nikare tuma diai tepo ni?” ");
INSERT INTO sue_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ago senu nukare mamaniro ina-sa wewa awa, “Ema ei awa neni? Bisire oure dai ge nuso dipinora.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu bua mai nusore nukare ou ubu semuro enibara kei awewa. Zebu awa Gerasa emara zebu. ");
INSERT INTO sue_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu wara ena witinu ema zo bi nuso nana toiro itisonua ami bi ditira ena muro Yesu nana kei awenua. ");
INSERT INTO sue_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ema awa bi ditira omata sora noisonua. Ema zo nu benai te wai ine tepo awa. Asi zewai zazo sen awa dai te kaka wamu. ");
INSERT INTO sue_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gita ema meni te-wana nuso sen meni benitinoisowa, ata nu wanera sen ziasai kapinoisonua, ota tera sen awa dasai kapinoisonua awa. Ema zo nu saniro patai te oko inoisonua. ");
INSERT INTO sue_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pi sero waiko sero nu bi ditira noise dirumura noise arinoise nutope omata meni kapinoisonua. ");
INSERT INTO sue_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nu ami aikera ena itimite Yesu giro sumuro muro Yesura nana ena duro koiniro ");
INSERT INTO sue_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","zawa gatero ego senua awa, “Yesu, ni Anutu ike itewia amira Mai, ami namore ne wamu tupesi? Na Anutura giti mokara toise ni na oko dasise tona.” ");
INSERT INTO sue_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ema ago senua, nera kota, Yesu numore emoko ego senua awa, “Bi, ni ema ewa doro bamu.” ");
INSERT INTO sue_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu meni nu atata wero senua awa, “Zazo ni aweni?” Ago senu ina ego senua awa, “Zazo naso Diti Bamu. Nera kota, nakare witai-bake.” ");
INSERT INTO sue_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ago sero ge beina-baina wero Yesure begomo senua awa, “Bi esenasa aike oko bayare.” ");
INSERT INTO sue_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Are nata pu saisai dirumu demabera nena kau inoise itiwa giro ");
INSERT INTO sue_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","bi meni Yesure begomo sero ego sewa awa, “Nakare esenasa pura nana toyanekare.” ");
INSERT INTO sue_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ago sewa giro Yesu meni ego senua awa, “Ago weu.” Ago senu bi meni emara nana ena kei awero doro pura nana toiwa pu meni sumuro degara baro ou ubura dagimuro ou niro betewa awa. Pu amira namba nusokare awa 2,000. ");
INSERT INTO sue_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pu dia wai ema ami bozero baro ema nate itiwa amire sero ema wo bowe itiwa amire sewa giro nukare tani kei awenua awa gamu sero muwa. ");
INSERT INTO sue_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nukare Yesu nana muro ema gita bi saisai nuso nana itiwa ami mo awero kotumai kokopai puro arumuro itinua awa giro azu wewa. ");
INSERT INTO sue_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ema eni tani emara nana kei awenu giwa ami ge tugata wewa. Ota tani pure kei awenua amira uge dai tugata wewa. ");
INSERT INTO sue_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ago wewa erama meni Yesure begomo sero zebu nusokare doro bayaise sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu wara wititinoinu ema gita bi nuso nana itiwa ami Yesure begomo sero numore dai nuamu senua. ");
INSERT INTO sue_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ata Yesu meni “Tepo” asero numore ego senua awa, “Dubu nisora nana baro Tua meni ni awa-diro tani kokopai nimore wetia awa se gare.” ");
INSERT INTO sue_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ago senu nu baro zebu zazo Dekapolis (ge nasokaira, “Nata wana eto”) amira kei awero tani Yesu meni numore wenua amira ge tugata-magata wasai erama dapikarago be anero ge nuso gege ninitinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu wara witiro ou ubu noko semuro enibara kei awero kora itinu erama dainiro meni nuso nana kei awewa. ");
INSERT INTO sue_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kei awero itiwa yere ibu simai ema zo zazo nuso Yairo ami Yesu giro nuso nana baro koiniro ");
INSERT INTO sue_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ge beina wero begomo sero ego senua awa, “Mai bama diri naso kiaka ami betamu sero inoya. Ni mu. Ni mai kora wamu sero giro wana niso nuso nana tame potasa nu kokopai wero nuamunoya, awa gosinona.” ");
INSERT INTO sue_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ago senu Yesu meni numore dai bamunua. Susaunu erama dainiro meni numore dai noise nu soe potiro puro susauwa. ");
INSERT INTO sue_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Are bama zo numorekare dai susaunua ami inua giro noe donu zepa 12 tepo wenu inua gaira orara nuso kaka touwamu. ");
INSERT INTO sue_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nu gita dokta saisai amira nana bayasai nukare bua wasara te kaka wamu wasai nu yaya bamubake tapinoisonua awa. Nu wau moni nuso dapikarago potinu tepo wenua, ata yaya kaka tepo wamu. Yaya bamubake kei awinoisonua. ");
INSERT INTO sue_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Are nu ami Yesura oziga niniro erama diti bamu amira nana gate-gate wero Yesu nana atune kei awero ");
INSERT INTO sue_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","nutope ego kotumunua awa, “Na tama woi nuso kimuro ewanana wamunona.” ");
INSERT INTO sue_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ago kotumuro kei awero Yesura mo kimunu orara nuso eya touwenu Yesu meni nu kora wenu yaya tepo wenua awa ginua. ");
INSERT INTO sue_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ago wenu Yesu meni kora waira putou eni nuso nana ena bamunua awa enia wero erama diti bamu amira nana soe ena eya kapeteniro ego senua awa, “Agai tama woi naso kimi?” ");
INSERT INTO sue_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ago senu bua mai nuso meni numore ego sewa awa, “Erama diti bamu meni ni musinora, ata ni ‘agai na kimi?’ asero atata inosua.” ");
INSERT INTO sue_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ago sewa ata Yesu meni, “Ai meni na kimi?” asero gamu sero gina-gana wenua. ");
INSERT INTO sue_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ata bama ami tani Yesu meni numore wenua awa giro azu wero boro-boro inoise Yesu nana muro te nusora duro susu nuso kereniro numore senua awa. ");
INSERT INTO sue_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ago wenu giro Yesu meni numore ego senua awa, “Mia naka, ni tuma diai nisora ewanana wetesa. Are ni yawa sara inoise bamuyo. Yaya niso oko ewesemamunoya.” ");
INSERT INTO sue_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu meni ago toise itinu ema eni meni simai emara nana sora ena muro ego sewa awa, “Mai bama diri niso betetia. Ni nogoro bua bamu gipai emare potamu tosi?” ");
INSERT INTO sue_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ago sewa, ata Yesu meni ge toiwa awa ninidanago wero yere ibu simai emare ego senua awa, “Kotumu-katumu oko wase. Tuma diaire gege noiyo.” ");
INSERT INTO sue_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ago sero nukare dapikarago numore dai bayai azu sero Petoro ata Yakoboto nami nuso Yohanere ami gege numore dai bayarise senua. ");
INSERT INTO sue_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nukare baro yere ibu simaira sora kei awero Yesu meni erama saisai pasi inoise itiwa awa ginua. Ema bama di toise dibe inoise itiwa. ");
INSERT INTO sue_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ago inoiwa giro Yesu sora toiro numorekare ego senua awa, “Nikare nogoro pasi inoise di towi? Mai awa kaka betamu. Nu gitawa inoya.” ");
INSERT INTO sue_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ago senu nukare nu sero ziwa. Ata nu nukare eseninu so doro bamuwa nu maira mamato miere ata ema numore dai itiwa awa puro masi mai itinua amira toinua. ");
INSERT INTO sue_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Toiro maira wana ziro numore Yuda gera ego senua awa, “Talita kumi.” Ge amira susu ego ewa: “Mai kiaka, erasise tona.” ");
INSERT INTO sue_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ago senu mai meni eya eriro aita wenua. Zepa nuso 12. Erama meni eya di tainiro yaka asewa. ");
INSERT INTO sue_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu meni nukare susu awa ema enire sai azu ge zewai senua. Ago sero nukare nena nai maire potarise senua awa. ");
INSERT INTO sue_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu meni nata awa doro nata nusora bamunua. Bua mai nuso meni numore dai bamuwa. ");
INSERT INTO sue_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Are Sabat pura kei awenu giro nu yere ibu du toiro ge tugata inoinu ema bama saisai meni ge nuso niniro di tainiro ego sewa awa, “Ema awa kotumai awa nana ena tapitai? Kotumai zewaine nuso nana kei awitai? Nu nogo wero tani erama gita kaka gamu awa inowi? ");
INSERT INTO sue_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ema ewa nu kapenda. Nu Mariara mai awa. Nu Yakobora Yosefera Yudara Simonra nami. Nubabumana nuso namorekai dai nowera.” Ago sero nukare Yesure kotumai waya pumuro duba mou wewa. ");
INSERT INTO sue_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ata Yesu meni numorekare ego senua awa, “Porofete nukare ema zazore. Ata nata nusokarera ena, o dubu nusokarera nana ena, o mama nusokarera nana ena, awa nukare ema zazore tepo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nu tani erama gita kaka gamu awa nusokare nana ena wai ine te kaka wamu wenua. Ata nu wana nuso meni ema yayare da da amira nana potinu yaya nusokare tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","“Nukare nogoro na tuma kaka diamu inori?” ago kotumuro nu aita wero nata kikinakara baro ge tugata wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu meni bua mai 12 zawa senu muwa bi tunaira putou awa numorekare potiro nukare eto-eto baro teya-taya warise sero nu numorekare ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“Ebatara nena zo oko pumawe. Wo ma tepo, kaita tepo, wau moni tepo. Ketu gege pumuwo. ");
INSERT INTO sue_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Te mokara sandol wosunamunowa, ata tama woi eto oko wosunawe. ");
INSERT INTO sue_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nikare esewa wero nata zora baro so da amira toiro itise muro baro awinoma nata awa duamu sero amire so awa dowo. ");
INSERT INTO sue_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nata zo meni nikare sawa kaka diamu, o ge nisokare kaka ninamu wara giro nata awa doro susu nusokare garise sero zebu nusokare te moka nisokarera itia awa deregi weu osae.” ");
INSERT INTO sue_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ago senu giro bua mai 12 ami baro eramare ego sewa awa, “Nikare duba kapeteniu.” ");
INSERT INTO sue_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ago sero sero bi saisai tunero gawi eni ema yayare saisai amira nana zozasara yaya nusokare tepo inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesura oziga baro ema bama dapikarago zebu sero amira te wenua. Ago wenu ema tua zo zazo nuso Herode ami Yesura oziga nininua. Ema eni meni Yesure ego toisowa awa, “Nu Yohane ge ou gutai zaawai ema. Nune ami betaira ena erinua, are nu tani putoure inowia.” ");
INSERT INTO sue_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Eni meni ago toisowa, ata eni meni ego toisowa awa, “Nu Elia.” Ota eni meni ego toisowa awa, “Nu porofete zo. Porofete gita noisowa ago ine.” Ago toisowa awa. ");
INSERT INTO sue_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ata Herode meni Yesura tani amira ge niniro ego senua awa, “Na ge sesena nukare Yohanera duba kapetera giti osisia, ata nu noko eriro noya.” ");
INSERT INTO sue_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herode meni ago senua, nera kota, gita nu soldia senu baro Yohane beniro puro poti benai sora niwa. Herode meni tani awa Herodia emo wenua, amira susu ego ewa: Herode meni nami nuso Filipra bama puro atinua awa. Bama amira zazo Herodia. ");
INSERT INTO sue_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ago wenu giro Yohane meni Herodere ego senua awa, “Ni nami nisora bama amire nowesa, awa te oko inoya. Lo ge itia.” ");
INSERT INTO sue_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yohane meni ago senu giro Herodia meni dumu wero Herode nu Yohane daise toisonua. ");
INSERT INTO sue_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ata Herode meni tani awa kaka wamu. Nera kota, nu Yohane emo azu inoisonua. Herode meni Yohane nu ema saramai, nu ema pasina kaka wamu, awa giro azu wero soinoisonua awa. Yohane nu ge sasai Herode meni niniro itazaita wero kotumu-katumu inoisonua, ata nu Yohanera ge ninamu yaba inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ata Herodia meni Yohane dai betaira be awa tamunua. Herode meni mia nu pumunua amira be awa kei awenu giro nu ema babezinoma nuso ata soldiara giti kopi eni ata Galilaya zebura ema babezinoma eni ami emo ana-bona wenua. ");
INSERT INTO sue_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Be amire Herodia meni Yohane dai betaira ebata tamunua. Awa ego ewa: Mai bama diri nuso meni Herodera ibura toiro yawa bamubake wienu Herode ata esewa numore dai itiwa ami giro yawa sara wewa. Ago wero giro Herode meni mai kanoware ego senua awa, “Ni nena zota zo yaba wero sasa giro potamunona. ");
INSERT INTO sue_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na Anutura giti mokara sana zewai wae. Ni nena zota zo emo sasa giro potamunona awa. Zebu naso agewa emo samunosa, awa potamunona.” ");
INSERT INTO sue_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ago senu nu so doro baro mia nusore ego senua awa, “Na ne potaise samunoni?” Ago senu mia nuso meni ego senua awa, “Yohane ge ou gutai zaawai ema amira giti nimore potaise samunosa.” ");
INSERT INTO sue_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ago senu nu eya sumuro Herode nana baro ego senua awa, “Zeme-zemeke ni Yohane ge ou gutai zaawai ema amira giti tewara potiro potasa pumane.” ");
INSERT INTO sue_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ago senu Herode meni kotumunu te kaka wamu wenu duba mou wenua. Ata nu Anutura nana giti mokara ge senu zewai wenua, noko ema dai itiwa amira nana ge nuso osago wai azu, ");
INSERT INTO sue_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","nu soldia zo meni Yohanera giti kapero puro maise senu baro benai sora ena duba nuso kapero ");
INSERT INTO sue_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","giti tewara potiro puro baro mai bama dirire potinu puro mia nusore potinua awa. ");
INSERT INTO sue_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ago wewa Yohanera bua mai meni tani amira oziga niniro giro baro woi nuso pumuro puro baro bi ditira potiwa awa. ");
INSERT INTO sue_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ema Yesu meni iyetinua ami Yesu nana ena auniro ge tugata inoise bua wewa awa dapikarago numore sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ota erama saisai Yesu nana muro baro awinoiwa Yesu ata bua mai nusore nena naira be tepo wenua. Ago wenu giro Yesu meni bua mai nusore ego senua awa, “Mukai. Nakai imata baro so erama tepora ena zanatianekai.” ");
INSERT INTO sue_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ago sero nukare wara witiro so erama tepo amira bayamu susauwa ");
INSERT INTO sue_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","erama saisai nata serora ami nukare susauwa giro kora-kora ama ganero bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu wa doro witi ete niro ema diti bamubake awa giro nukare emo zo amunua. Nera kota, nukare pu mamai meni mia kau inoise nowera ago ine. Ago giro zo amuro nu nukare ge tugata-magata inoinu ");
INSERT INTO sue_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","tua zizinoinu giro bua mai nuso meni nuso nana zorage muro numore ego sewa awa, “So ewa so waya. Nena nai tepo. Tua zizinoya, ");
INSERT INTO sue_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","are ni ema bama duasa baro nena nai nusokare pumamu nata zora-zara itera amira bayare.” ");
INSERT INTO sue_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ago sewa nu ego senua awa, “Ninekare nena nai potiu nare.” Ago senu nukare numore ego sewa awa, “Nakare baro ame moyai 200 kina meni zuma gaero numorekare potanakare narise tosa?” ");
INSERT INTO sue_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ago sewa nu numorekare ego senua awa, “Ame moyai nikare nazo ni? Bamuu, gawe.” Ago senu nukare baro giro noko muro ego sewa awa, “Ame wana dare wo etore gege itera.” ");
INSERT INTO sue_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ago sewa nu eramare ego senua awa, “Nikare dubu sero dopero gras uwiwai tame arumuu.” ");
INSERT INTO sue_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ago senu nukare dubu sero arumuwa; dubu eni erama 100, dubu eni erama 50, ago wero arumuwa awa. ");
INSERT INTO sue_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu meni ame wana dare wo etore puro iri utura niro Anuture kokopai asero ame awa eweweniro bua maire potinua awa. Awa bua mai meni eramare potarise sero ago wenua awa. Nu wo eto puro totoumuro kanowenu erama dapikarago ami pumuwa. ");
INSERT INTO sue_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nukare dapikarago niwa te wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ago wero nukare ame itatare wo itatare dara potiwa kana 12 te wenua. ");
INSERT INTO sue_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ema nena niwa amira namba nusokare awa 5,000. ");
INSERT INTO sue_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu meni bua mai nusore ego senua awa, “Nikare wara witiro ziriniro enibara Besaida nate gita bayamunowa. Na ema bama bozarise sero duamunona.” ");
INSERT INTO sue_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ago sero nu nukare gita iyetinu bamuwa nu isa samu sero dirumura witinua awa. ");
INSERT INTO sue_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Are tua zinu wa ou ubu soe tiara noinu Yesu imata ete itinua. ");
INSERT INTO sue_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ago itimite bisi meni nukare dero pumunu nukare wa dawaira yaya tapinoiwa awa ginua. Ago giro pina atamu inoinu amire nu ou ubu tame aita wero nusokare nana bayamu sero bamunua. Nu nukare dainamu sero inoinu ");
INSERT INTO sue_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","nukare nu ou tame aita inoinua awa giro nu ititi zota asero zawa gatewa. ");
INSERT INTO sue_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nukare zawa gatewa. Awa nera kota, nukare nu giro azu wero wetu wana zipewa. Ago wewa giro nu numorekare eya ego senua awa, “Nikare zewai wewo. Nama awa. Azu oko wawe.” ");
INSERT INTO sue_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ago sero nu wara witinu so bisi denua. Ago wenu nukare yaka asewa. ");
INSERT INTO sue_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nera kota, nukare tani Yesu meni ame eramare potinua amira susu kaka gamu. Giti munu nusokare omata me omata ine. ");
INSERT INTO sue_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nukare ou ubu semuro bamu zebu zazo Genesaret amira niro wa isewa witinua awa. ");
INSERT INTO sue_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ago wero wa doro witiwa erama Yesu gai ami nu giro ");
INSERT INTO sue_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","nata zora-zora itiwa amira sumuro ema bama keziawewenai goga gaero zuaniro, Yesu ago itia, asero ago potiwa awa. ");
INSERT INTO sue_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","So dapikarago Yesu meni bamunua — nata kikinaka, o nata babezinoma, o so nata tepo — so amira erama meni ema bama keziawewenai puro ebete potiwa ema bama yayare meni Yesu begomo sero mo be nuso gege kimamu sewa. Ema bama kimuwa amira yaya tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisayo eni ata lo ge gipai ema eni Yerusalem ena muwa ami Yesu nana auniwa. ");
INSERT INTO sue_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Auniro bua mai nuso meni wana saramai tepo, wana kaka sewamu nena ninoiwa awa giwa. ");
INSERT INTO sue_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Wana sewaira tani* amira susu ego ewa. Yuda ema dapikarago, Farisayo dai, nukare nena tepo oko ninowera. Nukare ewowo nusokarera sienai ama ganero wana sewero amire nena ninowera awa. ");
INSERT INTO sue_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nukare maketra ena ewesemuro gita ou gutero amire ama nena ninowera. Nukare ewowora sienai eure-taure inoise akoure teware aure sewinowera. ");
INSERT INTO sue_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Are Farisayo ata lo ge gipai ema ami Yesu atata wero sewa awa, “Bua mai niso meni nogoro ewowora sienai awa doro noweri?” ");
INSERT INTO sue_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ago sewa nu numorekare ego senua awa, “Nikare opi ema me sao inowewa. Porofete Yesaya meni ge gaenua ami nikare pupinoya. Ge gaenua awa ego ewa, Tua meni ego toya: Erama emi na begiti meni bowi inowera, ata moka nusokare naso nana oko itia. ");
INSERT INTO sue_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nukare emara ge awa Anutura lo ge ine asero sero gipero awinowera. Are nukare na bowi wero zainitinowera. Yesaya meni ago gaenua awa.” ");
INSERT INTO sue_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu meni ago sero amire ge susumuro ego senua awa, “Nikare Anutura lo ge doro eramara wini ge puro ziro baititinowewa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu meni ge zo noko numorekare ego senua awa, “Nikare Anutura lo ge apero doro ewowora tani ama ganero nowewa, awa kotumuro kokopai asinowewa, atonua! ");
INSERT INTO sue_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Na ago tona, nera kota, Mose meni ego senua awa, Ni tani kokopai mia mama nisore inoise noiyo. Noko, Zo nu mia mama nusore ge waya samunoya, nu awa deu betae. ");
INSERT INTO sue_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mose meni ago senua, ata nikare ego towewa awa: Zo nu mia mama nusore ego sai te wamunoya awa, ‘Na nena nimoreto potamena, ata na nena awa Koban asena.’ (Koban amira susu ego ewa: “Na nena awa Anuture potamu sena zewai wenua.”) ");
INSERT INTO sue_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mai zo ago samunoya, awa nikare nu mia mama soremai azu towewa. ");
INSERT INTO sue_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ago wero nikare Anutura lo ge poti ama niro ewowora tani poti gita niro maire gipinowewa. Tani saisai ago ine inowewa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu meni ago sero ema bama noko zawa senu muwa ego senua awa, “Ge sana niniu. Nikare dapikarago niniro baitiu. ");
INSERT INTO sue_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nena be nisokarera toitinowia ami oko nikare wawi bemitire inowewa. Ge be nisokarera ena kei awinowia ami nikare wawi bemitire inowewa awa.  ");
INSERT INTO sue_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Zo nu danare meni ge awa ninaise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ago sero ema bama doro bua maire dai sora toiro bua mai meni ge bezaira susu gamu sero nu atata wewa awa. ");
INSERT INTO sue_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Atata wewa giro nu numorekare ego senua awa, “Agoro nikare dai kaka gamu inowewita? Nikare susu ei awa gosinowita? Nena nai meni bera toiro nikare oko wawi bemitire inowewa. ");
INSERT INTO sue_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nera kota, nena nai ami duba nisokarera oko toitinowia. Nena awa tini nisokarera bamuro eba nusora osisinowia.” Yesu meni ge awa toise nena nai dapikarago siro beto wenua. ");
INSERT INTO sue_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ago sero amire ego senua awa, “Tani emara nana dubara ena kei awinowia ami ema awa wawi bemitire inowia. ");
INSERT INTO sue_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nera kota, emara nana mokara ena, o emara dubara ena kotumai waya meni kei awinowera — kuma wai, bewana wai, mai dai betai, soa patai, ");
INSERT INTO sue_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","duba-duba wai, tani waya wai, opi sai, gai waya wai, wiza atata wai, tama puro witai, wini ge dero nuai — ");
INSERT INTO sue_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","tani awa dapikarago emara nana mokara ena kei awero ema awa wawi bemitire inowia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu meni ana eriro bamu zebu zo nata zazo Taya itisonua amira niro so zora toiro itise ema bama nu ago itinua awa gai azu senua, ata nu nutope begi wai ine tepo. ");
INSERT INTO sue_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ago inoinu bama zo meni Yesura oziga nininua. Bama amira mai bama diri kiaka ami bi nuso nana itinua awa. Bama ami kei awe Yesu nana niro koininua. ");
INSERT INTO sue_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ota bama awa nu Yudako. Zebu nusora zazo Sirofonisia. Are nu Yesure begomo sero nu mai nusora bi tunaise senu ");
INSERT INTO sue_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu meni numore ge bezai ego senua awa, “Na nena mai mamaire gita potana nara te wae. Nera kota, mai mamaira nena nai soero suna unai ine awa te oko inoya.” ");
INSERT INTO sue_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ago senu giro bama meni ina ge bezai ego senua awa, “Tua, awa me tosa. Ata suna opa du itise nena mumuka mai meni wawera osawi ninowera.” ");
INSERT INTO sue_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ago senu giro Yesu meni numore ego senua awa, “Ge ewanana sesesa, are sora bamuyo. Bi meni mai niso doro bamia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ago senu bama meni noko tera nuso nana baro bi bamunu mai nuso duro itinua awa ginua. ");
INSERT INTO sue_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu meni ana eriro zebu nata Taya itinua awa doro nata Saidon busero zebu zazo Dekapolis awa busero kei awe ou ubu zo zazo Galilaya amira ninua. ");
INSERT INTO sue_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ago itinu ema eni meni ema zo puro muro poti Yesura nana niwa awa. Ema awa dana azai, ge tepo. Ema meni ema awa puro Yesu meni nu kimuro kora waise sero begomo sewa. ");
INSERT INTO sue_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ago wewa giro Yesu meni ema awa puro ema bama doro baro dopero wana sisino emara nana danara potiro pora pisero wana meni emara iwawa kimuro ");
INSERT INTO sue_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","iri ike niro usika apero emare ego senua awa, “Epata.” (Ge nasokaira, “Dana keyaise.”) ");
INSERT INTO sue_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ago senu dana keenu be peu wenu ge neine senua awa. ");
INSERT INTO sue_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ago wenu giro Yesu meni numorekare ego senua awa, “Nikare tani emira oziga sai azu tona.” Ago sasai nukare weso-waso wero oziga toisowa. ");
INSERT INTO sue_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ema bama eni meni niniro di tainiro titibi awero ego sewa awa, “Nu tani dapikarago neine inowia. Nu wawi ema dana azai meni ge noko ninitinowera, ota ema ge tepo ami ge noko towera.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Waiko be zore ema bama dainiro meni Yesu nana auniro nena nai tepo itiwa giro nu bua mai nuso zawa senu muwa ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Na ema bama emo zo inoya. Nera kota, nukare be etorobara namore dai nora nena nai tepo wetia. ");
INSERT INTO sue_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Are na nena numorekare kaka potamu tepo iyetamunona, awa nukare susauma ebete ena meri betero duwamunora. Nukare eni so zora-zarako ena mutara.” ");
INSERT INTO sue_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ago senu bua mai meni numore ego sewa awa, “Nakai soe ena nogo nogo wero ema bamera nena nai tamuro potamunonikai?” ");
INSERT INTO sue_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ago sewa senua awa, “Nikare ame moyai nazo ni?” Ago senu sewa awa, “Nakare ame moyai 7.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Are Yesu meni ema bama zebura arumarise senu arumuwa nu ame moyai 7 awa puro Anuture kokopai asero ame awa eweweniro bua maire potinua awa. Bua mai meni eramare potarise sero potinu puro ema bamere potiwa. ");
INSERT INTO sue_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ota wo kikinaka nusokare eni itiwa giro Yesu meni wo emo Anuture kokopai asero bua maire ego senua awa, “Wo dai ema bamere potiu.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Are potiwa niwa te wenua. Te wenu giro itata poti dara niwa kana 7 te wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Erama nena niwa amira namba nusokare awa 4,000. ");
INSERT INTO sue_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Niwa amire Yesu meni nukare senu bamuwa. Bamuwa nu bua mai nusore wara witiro zebu zazo Dalimanuta amira bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisayo eni meni Yesu nana muro numore dai ge bawewa awa. Nukare Yesu gaero gamu sero nu tani zo utura putoure wai gamu sewa. ");
INSERT INTO sue_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sewa Yesu meni ge nusokare ginu biawa wenu giro ego senua awa, “Ema zeme zebura nowera ami nogoro tani putoure zo gamu tori? Na ge me tona ewa. Ema zeme zebura nowera ami tani putoure zo oko gamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ago sero nu nukare doro wara noko witiro ou ubu enibara bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bua mai nuso meni ame kaka pumamu nuweniwa. Ame da gege numorekare dai wara itinua. ");
INSERT INTO sue_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Are Yesu meni dana-wena gayai ge numorekare toise ego senua awa, “Nikare uma weu. Farisayora yis ata Herodera yis ami semu nisokare nana nai azu, nikare uma wero baititinoise noiwo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nukare ge nuso awa niniro ina-sa wewa awa, “Nakai ame tepo.” ");
INSERT INTO sue_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ago sewa nukare Farisayora gipai ge kota, ame nai awa kotupitinoiwa giro Yesu meni numorekare ego senua awa, “Nakai ame tepo awa nogoro towi? Nikare zeme kaka gamu ni? Gitimunu nisokare omata ine ni? ");
INSERT INTO sue_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nikare giti mokare, ata nikare kaka gamu ni? Nikare danare, ata nikare kaka ninamu ni? Nikare nuwenitawita? ");
INSERT INTO sue_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Na ema 5,000 emo ame wana da ewewenisena be amire nikare itatara kana nazo diisewi?” Ago senu nukare sewa awa, “Kana 12 diisenakare.” ");
INSERT INTO sue_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ago sewa nu ego senua awa, “Na erama 4,000 emo ame 7 ewewenena nikare itatara kana nazo diisewi?” Ago senu sewa awa, “Kana 7 diisenakare.” ");
INSERT INTO sue_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ago sewa nu ego senua awa, “Nikare zeme kaka gamu ni?” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu bua mai nusore kei awe nata Besaida amira niwa ema eni meni ema giti guma wai zo puro Yesura nana muro Yesu meni nu kimaise sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ago sewa giro Yesu meni ema giti guma wai amira wana ziro puro nata doro baro be pora giti mokara pisero wana giti mokara potiro atata wero senua awa, “Nena zo gosinosita?” ");
INSERT INTO sue_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ago senu nu giti panero ina ego senua awa, “Na erama gosinona. Na nukare gena ni ipu ine inora, ata nukare aita inora.” ");
INSERT INTO sue_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ago senu giro Yesu meni wana nuso giti mokara noko potinu ema awa ua wenu giti moka nuso kokopai wenu nu nena dapikarago giro baitinua awa. ");
INSERT INTO sue_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ago wenu giro Yesu meni nu iyetamu sero ego senua awa, “Ni noko nata emira oko bayase. Ata niso nana bamu.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu bua mai nusore dai nata eni zebu zazo Sisaria-Filipai ago itiwa amira bamuwa. Susaumite Yesu meni bua mai atata wero senua awa, “Erama meni na are asinoweri?” ");
INSERT INTO sue_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ago senu ina sewa awa, “Eni meni ego tora: Ni Yohane ge ou gutai zaawai ema. Ata eni meni awa ego tora: Ni Elia. Ata eni meni awa ego tora: Ni porofete gita noisowa amira zo.” ");
INSERT INTO sue_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ago sewa giro nu nukare atata wero senua awa, “Ina ninekare nitopekare na are asinowewi?” Ago senu Petoro meni ego senua awa, “Ni Kristo, Soyai Ema nasokare.” ");
INSERT INTO sue_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ago senu Yesu numorekare ge zewai ego senua awa, “Ge naso awa ema zore oko sawe.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu meni nukare ge tugata wamu sero ego senua awa, “Na Emara Mai meni yaya-buyaya tamamunona. Yuda emara simai ata pris babezinoma ata lo ge gipai ema ami na azu sero na dara betamunona awa. Betana be etorobara tepo wai amire na noko seka wero eramunona.” ");
INSERT INTO sue_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ge awa senu kei awenu giwa. Are Petoro meni nu uzumuro senero ego senua awa, “Ago oko sase.” ");
INSERT INTO sue_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ago senu Yesu meni kapeteniro bua mai nuso eni giro ina Petoro senero ego senua awa, “Satan, ni na doro daiti. Ni ge tosa awa Anutura ge kota, emara ge inoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu meni bua mai nuso ata ema diti bamu awa zawa senu muwa ego senua awa, “Zo nu na ama ganamu wero giro ara tamai nuso dapikarago doro duba naire yaya tamaire amira ni pasinai nuso dimuro na ama ganaise. ");
INSERT INTO sue_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nera kota, zo nu zebura nuai nuso soero puro nuamu kotumamunoya amira nuai nuso tepo wamunoya. Ota zo nu na emo wero o Oziga Ewanana emo wero zebura nuai nuso duamunoya ami nuai ewanana tamamunoya. ");
INSERT INTO sue_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Zo nu zebura nena kokopai dapikarago awa pupinuamunoya, ata nuai nuso tepo wamunoya, awa nena nemi nuso nana itamunoi? ");
INSERT INTO sue_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ota nuai nuso ewesemaise kotumuro zuma ne potai amire nuai nuso awa ina ewese nuso nana namunoi? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ema pasina inoise Anutu soa patitinoise zebura nowera be amire ema zo meni na ata ge naso awa azu samunoya, awa na Emara Mai meni Mama nasora zasimaire angelo saramaire mamunona be amire na ina ema awa azu samunona.” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu meni numorekare ego senua awa, “Na ge me nimorekare tona ewa. Ema eni ego dopero itera ami kaka betamu nuara Anutu imata Tua wero nuamunoya amira putou kei damu nai gamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Waiko be 6 tepo wenu amire Yesu meni Petoroto Yakobore ata Yohane awa gege puro dirumu bamura witiwa Yesura tama meni giti moka nusokarera ewe wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mo nuso meni koa-koa wenua. Mo nuso awa kapa me kapa wai. Ema zo meni mo sewai ago wai ine tepo. ");
INSERT INTO sue_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bua mai nuso meni Eliato Mosere nuto Yesure dai ge toise itiwato awa giwa. ");
INSERT INTO sue_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Giro Petoro meni Yesure ego senua awa, “Gipai ema, nakai ego itenakai awa ewanana. Are ninasa nakare komboa etorobara sinanekare — zo niso, zo Mosera, zo Eliara.” ");
INSERT INTO sue_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petoro meni ne sei wero ge awa senua. Nera kota, nukare bua mai meni azu bamubake wewa. ");
INSERT INTO sue_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ago inoiwa bereze zo meni muro nukare gogowenua. Ago wenu ge zo bereze amira mokara ena ego kei awenu niniwa awa, “Awa mai naso. Nu wama naso. Ge nuso niniu.” ");
INSERT INTO sue_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bua mai meni ge awa niniro eya gina-gana wero erama zo kaka gamu wero Yesu gege numorekare dai itinua awa giwa. ");
INSERT INTO sue_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yesu bua mai nusore dirumura ena osero susaumite nu numorekare ge zewai toise ego senua awa, “Nikare tani gewa amira ge oko sawe. Na Emara Mai meni betero erana amire nikare ge awa sawa te wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Are nukare Yesura zewai ge dimuwa. Ata nukare Yesu betero eramunoya amira gera susu gamu sero kotumu-katumu wewa. ");
INSERT INTO sue_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ago inoise nu atata wero sewa awa, “Lo ge gipai ema meni ego towera, ‘Elia gita mai amire Kristo mamunoya.’ Nogoro ago toweri?” ");
INSERT INTO sue_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ago sewa giro Yesu meni numorekare ego senua awa, “Elia nu gita muro nena bamubamu dapikarago korawai amire Kristo mamunoya. Na Emara Maire ge ego gaewa itewia ewa, Nu yaya-buyaya tamamunoya. Nukare nu sero ziamunora awa. Nogoro ge awa gaewa itewi? ");
INSERT INTO sue_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ata na nimorekare tona ewa. Elia munua. Munu giro ema eni meni numore tani tebe-tabe wewa. Ge numore gaewa ago ine te wewa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nukare osero muro kei awe bua mai enira nana niro ema diti bamu bua maire dai itiwa giwa. Lo ge gipai ema eni meni bua maire ge bawero itiwa. ");
INSERT INTO sue_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Are ema bama meni Yesu tupinu giro mamaniro sumuro baro areniwa awa. ");
INSERT INTO sue_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ago wewa Yesu meni nukare atata wero senua awa, “Nikare ge ne numorekare dai towi?” ");
INSERT INTO sue_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ago senu diti bamu itiwa amira ema zo meni numore ego senua awa, “Gipai ema, na mai mata naso puro niso nana mena. Nera kota, bi nuso nana toiro itawi nu ge amu itewia. ");
INSERT INTO sue_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mai nago-nago nuawi bi meni nu daramunawi duro pora gutero di wiawi tama aiso nuso zewai-zawai inowia. Are na bua mai niso meni bi tunarise sesena, ata nukare tunai ine tepo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ago senu Yesu meni numorekare ego senua awa, “O nikare ema bama tuma diai tepo. Na be nazo nimorekare dai nuamunoni? Na be nazo bua nisokarera tama doinoise nuamunoni? Mai puro naso nana muu.” ");
INSERT INTO sue_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ago senu nukare mai puro nuso nana muwa bi meni Yesu giro mai darauninu duro pora gutinoise aziapinoinu ");
INSERT INTO sue_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu meni maira mama atata wero senua awa, “Be nazo yaya awa puro nowi?” Ago senu ina senua awa, “Nu mai morua amire pumunua. ");
INSERT INTO sue_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Are bi meni mai betaise sero nu dawi oura o niaora duwitinowia awa. Ata ni yaya awa kora wai ine te wamunoya, awa ni nakare emo zo wero nakare soremu.” ");
INSERT INTO sue_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ago senu giro Yesu meni bera pumuro ego senua awa, “Na yaya awa kora wai ine te wamunoita, asinosita? Ema zo nu tuma diaire ami tani dapikarago wai te inoya.” ");
INSERT INTO sue_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ago senu maira mama meni eya ego senua awa, “Na ni tuma didinona, ata ni na soremasa na ni tuma diro baitane.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Are Yesu meni ema bama witai nuso nana sumuro tupiwa giro nu bi senero ego senua awa, “Ni bi ge amu wai, o dana azai, na nimore ge zewai tona ewa. Ni mai doro nuso nana noko oko toyase.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ago senu bi meni zawa gaetero mai denu zewai-zawai aziamunu bi nu donu mai betai ine wenua. Ago wenu ema bama saisai meni giro ego sewa awa, “Mai betetia.” Ago sewa, ");
INSERT INTO sue_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ata Yesu meni maira wana ziro zinu erinua. ");
INSERT INTO sue_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu bua maire dai sora toiro bua mai meni erama zo tepo giro nu atata wero sewa awa, “Nakare bi awa tunamu wetenakare nogoro te kaka wamu weti?” ");
INSERT INTO sue_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ago sewa Yesu meni numorekare ego senua awa, “Nakai bi ago ine tunamu sero isa saira bua gege wero tuninowenakai. Tunaira ebata zo tepo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nukare ana eriro baro zebu zazo Galilaya awa busewa. Ata Yesu meni nukare susauwa awa ema bama meni gai azu senua. ");
INSERT INTO sue_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Azu senua, nera kota, nu bua mai nuso gipinoise ego senua awa, “Nukare na Emara Mai awa puro ema enira nana wanera potara na dara betamunona. Betero be etorobara tepo wai amire eramunona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ata nukare ge nusora susu kaka gamu. Noko nukare nu atata wai azu wewa awa. ");
INSERT INTO sue_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nukare susaumite bamu Kapaneam niro sora toiro itiwa amire Yesu meni nukare atata wero senua awa, “Nikare ebete ena ge nogo sesewi?” ");
INSERT INTO sue_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yesu ago atata wenua, ata nukare ge ina kaka samu. Nera kota, nukare ebete ena ego sewa awa, “Nasokai nana zo agai meni bamu inoi?” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Are Yesu meni arumuro bua mai nuso 12 zawa senu muwa ego senua awa, “Ema zo meni gita wamu samunoya, nu ami ama waise. Nu ema dapikarago amira sou waise.” ");
INSERT INTO sue_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ago sero amire nu mai zo puro poti soe niro mai saniro numorekare ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ema zo meni mai zo ego ine na emo kora wamunoya, nu ami na kora wetia ago ine wamunoya. Ema zo na kora wamunoya ami na daba kota, nu na iyetinu osena awa dai kora wetia ago ine wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohane meni numore ego senua awa, “Gipai ema, nakare ema zo namorekai dai kaka nuamu ami zazo niso zawa toise bi tuninoi goisenakare. Ata nu nakai kaka ama ganamu inowia, are duaise sisenakare.” ");
INSERT INTO sue_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ago senu Yesu meni ina ego senua awa, “Bua duaise awa oko sawe. Nera kota, ema zo meni zazo naso zawa toise tani putoure zo wamunoya ami eya zazo naso puro osai ine te kaka wamu wamunoya. ");
INSERT INTO sue_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ema iwo namorekai kaka wamu awa otao nasokai awa. ");
INSERT INTO sue_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na ge me nimorekare tona ewa. Ema zo meni nikare Kristora mai wero nowewa awa giro ou nai nimorekare potamunoya ami ina zuma nuso ewanana pumamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesu meni ego senua awa, “Zo nu mai kikinaka na tuma didinowera amira nana zo uzutai pasina tamai azu, nikare bere-bere omata bamubake zo ema amira nana dube kimeniro ewa surura musunawa dagimai te wamia. Nera kota, ema ami pasina kaka wamure oura dagimuro betamunoya, awa nena peu gege. Ota nu pasina wai amire Anutu meni ina potamunoya, awa nena mou-mau. ");
INSERT INTO sue_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ni wana zo meni pasina wamesaya, wana awa kapase. Ni wana daimatare gege noma ama utura baro nuasa ewanana wamunoya awa. Ata ni wana etore noma ama so niao awai gege awaira bayasa waya wamunoya.  ");
INSERT INTO sue_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","So waya amira zipa meni oko betinora. So amira niao oko osisinoya. ");
INSERT INTO sue_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ni te zo meni pasina wamesaya, te awa kapase. Ni te daimatare gege noma ama utura baro nuasa ewanana wamunoya awa. Ata ni te etore noma ama so niao awai gege awaira bayasa waya wamunoya awa.  ");
INSERT INTO sue_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","So waya amira zipa meni oko betinora. So amira niao oko osisinoya. ");
INSERT INTO sue_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ni giti moka zo meni pasina wamesaya, giti moka awa gusase. Ni giti moka daimatare gege noma ama Anutu imata Tua wero nuamunoya amira nate bayasa ewanana wamunoya awa. Ata ni giti moka etore noma ama so niao awai gege awaira bayasa waya wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","So waya amira zipa meni oko betinora. So amira niao oko osisinoya. ");
INSERT INTO sue_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nakai ewa puro nena naira tetawenakai ewanana inowia awa. Da ago ine yaya niao ine ami erama dapikarago ewanana wawise tetamunoya. ");
INSERT INTO sue_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ima awa nena kokopai. Ata ima berusa wamunoya, awa nakai nogo wanakai bapu nuso ewanana kei awamunoi? Nakai ewa puro nena tame tetawenakai ewanana inowia, da ago ine nikare duba-ozaire nuawa ewanana wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu bua mai nusore dai ana eriro bamu zebu zazo Yudaya amira niro noko doro bamu zebu ou Yodan enibara itinua amira niwa ema diti bamu meni nuso nana noko kei awasara nu numorekare utura ge gipinoisonua awa. ");
INSERT INTO sue_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisayo eni meni nuso nana kei awero nu gaero gamu sero atata wero sewa awa, “Ema meni bama nuso duai ine te inoita?” ");
INSERT INTO sue_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ago sewa nu ina ego senua awa, “Mose meni lo ge nimorekare potiro nogo senu?” ");
INSERT INTO sue_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ago senu nukare sewa awa, “Mose meni ego senua awa: Ema zo bama nuso duamu sero giro bama duaira pas zo gaero amire bama duaise. Mose meni ago senua awa.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ata Yesu numorekare ego senua awa, “Gigai nisokarera Mose meni ge awa nikare emo gaenua. ");
INSERT INTO sue_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ota Anutu meni nena dapikarago tapinoise emare bamere tamunua. ");
INSERT INTO sue_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Are ema meni mia mama nuso doro bama nusore dai gamuro baitiro ");
INSERT INTO sue_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","nuto dubare tamare da wero nuamunorato. Are nuto eto kota, daimata wero nuamunorato. ");
INSERT INTO sue_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anutu meni nuto dara potinu atiwato, are erama meni oko kaparise.” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nukare sora toiro itiwa bua mai nuso meni gera susu gamu sero nu atata wewa. ");
INSERT INTO sue_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Atata wewa giro nu numorekare ego senua awa, “Ema zo meni ara nuso doro bama seka atamunoya, awa nu pasina wamunoya. ");
INSERT INTO sue_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ota bama zo meni iu nuso doro ema zo atamunoya, awa nu pasina wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ema bama eni meni mai pei-mamai Yesu meni kimaise sero nuso nana puro tupiwa bua mai nuso meni ema bama senewa. ");
INSERT INTO sue_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ata Yesu meni giro dumu wero bua maire ego senua awa, “Nikare mai pei-mamai dou naso nana mare. Ebata nusokare oko gazawe. Ago ine ami Anutura nata amira gegenai. ");
INSERT INTO sue_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na ge me nimorekare tona ewa. Zo nu tuma diai mai pei-mamaira ine tepo ami Anutura nana nate bayai ine tepo.” ");
INSERT INTO sue_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yesu meni ge ago sero mai kikinaka puro saniro wana poti giti nusokarera niro gawa wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu meni bayamu sero ebata tapinoinu ema zo sumuro muro kei awe nuso nana niro koiniro ego senua awa, “O gipai ema ewanana, na nogo wero nuai me ewanana tamamunoni?” ");
INSERT INTO sue_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ago senu Yesu meni numore ego senua awa, “Ni na ewanana asinoise ewananara susu gosinosita? Anutu imata ewanana. ");
INSERT INTO sue_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ni Anutura lo ge gosinowesa awa: ‘Erama oko dasa betare; Emata bama bewana oko wase; Ni bewana oko wase; Ni ema zo gera potamu opi oko sase; Ema zora nena opi sero oko pumase; Miato mamera ge dimuyo.’ Lo ge ago itia.” ");
INSERT INTO sue_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ago senu nu numore ego senua awa, “Gipai ema, na seka nasore ge awa dapikarago dipi-tupewena.” ");
INSERT INTO sue_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ago senu Yesu iri niro nu gosinoise zo amuro giro numore ego senua awa, “Ni bua zo dosa itewia awa weyo. Ni bua ei awa wero amire nuai me ewanana tamamunosa. Ni baro nena niso dapikarago potasa ema meni zuma gaero pumara wau moni niso awa ema bogamasare kanowasa pumare. Ago wasa wau niso utura itamunoya awa. Ago wero amire muro na ama ganase.” ");
INSERT INTO sue_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesu meni ago senu nu tuma gosuna-gasuna wero kotumu-katumu inoise doro bamunua. Awa nera kota, wau moni nuso witai. ");
INSERT INTO sue_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Are Yesu meni gina-gana wero bua mai nusore ego senua awa, “Erama wau witaire ami Anutura nata amira bayaira bua bamubake wamunora.” ");
INSERT INTO sue_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ago senu bua mai meni ge awa niniro di tainiwa. Ata Yesu meni numorekare noko ego senua awa, “O bua mai naso, Anutura nata amira bayai awa bua bamubake. ");
INSERT INTO sue_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Wo kamel meni boma sora toyai awa nena mou awa. Ata ema wau witaire meni Anutura nata amira bayai awa nena mou-mau.” ");
INSERT INTO sue_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ago senu nukare di tainiro ina-sa wewa awa, “Are agai meni utura baro nuai me ewanana tamai te inoi?” ");
INSERT INTO sue_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ago sewa giro Yesu meni iri nusokare nana niro ego senua awa, “Erama meni ago wai ine tepo, ata Anutu meni ago wai te inoya. Nera kota, Anutu meni tani dapikarago wai te inoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ago senu giro Petoro meni numore ego senua awa, “Sana giyo. Nakare neu-nau nasokare dapikarago doro nima ama ganinoise nowenakare.” ");
INSERT INTO sue_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ago senu Yesu meni ego senua awa, “Na ge me nimorekare tona ewa. Ema zo meni nata nuso, o namisini nuso, o nubabumana nuso, o mia nuso, o mama nuso, o mai awiso nuso, o zebu nus awa nato Oziga Ewananare emo duamunoya, awa ");
INSERT INTO sue_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nu ami natare namisinire nubabumanare miamaire mai awisore zebure awa 100 be zeme emire tamamunoya. Ago inuai erama eni meni nu mai naso asero nu waya-waya inuamunora. Ama nu nuai me ewanana awa pumamunoya. ");
INSERT INTO sue_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ota erama gita inora amira eni meni ama wamunora. Erama ama inora ami gita wamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ema enire Yerusalem bayamu sero ebata tamuro susaumite Yesu nu gita inoinu bua mai nuso meni ama ena kotumu-katumu inoise susauwa ema eni ama muwa ami dai azu inoise bamuwa awa. Are Yesu meni bua mai nuso 12 puro tani ema meni ama numore wamunora amira ge numorekare kerenitinoise ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Sana niniu. Nakai Yerusalem wititinonakai. Witiro ago kei awero nuanakai amire ema zo meni na Emara Mai awa puro poti pris babezinoma ata lo ge gipai ema amira nana wanera nai nukare na dara betanise sero ema Yudakora nana wanera potamunora. ");
INSERT INTO sue_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ago potara ema Yudako meni na isipitinoise pora namore pisero wamu meni nama pena-pana dero dara betamunona. Betana waiko be etorobara tepo wai amire noko eramunona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedira mai eto zazo nusoto Yakoboto Yohanere, nuto ami Yesu nana muro ego sewato awa, “Gipai ema, ni namoreto nena zo wasise kotupitinonato.” ");
INSERT INTO sue_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ago sewato giro ina ego senua awa, “Na ne nimoreto wanise kotupitinowito?” ");
INSERT INTO sue_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ago senu nuto sewato awa, “Ni zasimaire itamunosa be amire nato demabe nisora arumuro itamunonato, zo wana mera, zo wana anikara, awa ninasise tonato.” ");
INSERT INTO sue_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ago sewato Yesu meni ina ge bezai numoreto senua awa, “Nito nenara susu kaka gamu wero na atata wetewato. Na ou dokaka zo namunona, awa nito te nanowato? Na ou gutai zo pumamunona, awa nito te pumanowato?” ");
INSERT INTO sue_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ago senu nuto numore ego sewato awa, “Nato te wamunonato.” Ago sewato giro Yesu meni numoreto ego senua awa, “Na ou dokaka zo namunona, awa nito dai namunowato. Na ou gutai zo pamunona, awa nito dai pamunowato. ");
INSERT INTO sue_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ata nito wana naso mera, o wana naso anikara arumuro itamunowato amira ge awa nane sai ine tepo. Anutu meni masi awa ema eni emo sia wenu itewia. Are nukare ami masi amira arumuro itamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bua mai 10 meni ge awa niniro Yakoboto Yohanere emo duba mou wewa. ");
INSERT INTO sue_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ago wewa giro Yesu meni bua mai 12 zawa senu muwa ego senua awa, “Zebura ema tua meni ema bama nukare sou warise towera. Noko ema babezinoma meni ema bama puro osero nunekare witai nusokare ine inowera, awa gosinowa. ");
INSERT INTO sue_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ata ninekare meni awa ago ine oko wawe. Nisokare nana zo meni ema bamu nisokare wamu wero giro enira ama-zani wero nuaise. ");
INSERT INTO sue_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ota giti kopi nisokare wamu wero giro enira soumai wero nuaise. ");
INSERT INTO sue_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nera kota, na Emara Mai meni erama na sou warise kota, na natope sou bua inoise betero erama saisai wayara ena soero pumamu muna.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu bua mai nusore kei awe Yeriko niro nata awa duamu sero ema bama saisai amire dai susauwa ema giti guma wai zo zazo nuso Batimea, nu Timeara mai, ami ebata enibara arumuro itinua awa. Nu moni emo begomo toisonua. ");
INSERT INTO sue_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Are nu ago itise Yesu Nasaretera ema ego tupia amira ge niniro arero ego senua awa, “O Yesu, ni Dawidira sibuna, ni na emo zo amuyo.” ");
INSERT INTO sue_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ago senu ema saisai meni nu senero sewa awa, “Ni ge do.” Ago sewa, ata nu noko arero senua awa, “O Dawidira sibuna, ni na emo zo amuyo.” ");
INSERT INTO sue_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ago senu giro Yesu meni dopero ego senua awa, “Zawa seu mae.” Ago senu nukare ema giti guma wai awa zawa sero sewa awa, “Azu oko wase. Eriro dope. Nu ni zawa toya.” ");
INSERT INTO sue_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ago sewa nu mo wape nuso kokero eya dopero kei awe Yesura nana ninu ");
INSERT INTO sue_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu meni numore ego senua awa, “Na ne nimore wanise tosi?” Ago senu ema giti guma wai ami ego senua awa, “Gipai ema, giti moka ewanana waise tona.” ");
INSERT INTO sue_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ago senu Yesu meni numore ego senua awa, “Ni bamuyo. Tuma diai niso meni ni kora wetia.” Ago senu giti moka nuso ewanana wenu nu Yesu ebete ena ama ganenua awa. ");
INSERT INTO sue_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nukare nata Yerusalem zorage kei awewa. Nata kiaka eto zazo nusoto Betefasito Betanire ago itisowato awa. Ago kei awero dirumu zazo nuso Oliwa awa busuniro Yesu meni bua mai nuso eto gita bayariseto sero numoreto ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Nito semuro nata zorage itia amira bamuwoto. Baroto ago kei awero wo donki amira mai zo kimenera itia awa tamamunowato awa. Erama zo da di wo amira tame kaka arumamu. Wo awa besero puro muuto. ");
INSERT INTO sue_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ota ema zo meni, ‘Nito ne wamu wo awa besinowito?’ ago samunoya, awa nito numore ego sewoto: ‘Tuara bua emira itia. Nu ego eya noko potamunoya.’ Ago sewoto.” ");
INSERT INTO sue_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yesu meni ago senu nuto baro wo donkira mai awa tamuwato. Wo awa ema meni so bera kimeniwa ebete itinua awa tamuro besewato awa. ");
INSERT INTO sue_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Asi besinoiwato ema eni ago itiwa ami numoreto ego sewa awa, “Nito ne wamu muro wora asi besinowito?” ");
INSERT INTO sue_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ago sewa giro nuto ge Yesu meni sariseto senua awa sewato giro dowa. ");
INSERT INTO sue_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ago wewa nuto wo awa puro bamu Yesura nana niwato nukare mo nusokare wo tame potiwa Yesu meni wo tame witiro arumunua. ");
INSERT INTO sue_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ago wenu ema saisai meni tama woi nusokare puro ebete ena sawa diwa. Eni meni buye baro ni bona kapero puro ebete potiro potiro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Are ema gita susauwa amire ema ama tupiwa ami arero sewa awa, “Ema Tuara bera tupia nu awa bowi wanekai. ");
INSERT INTO sue_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tua wero nuaira be nuso kei awamunoya, are nu bowi wanekai. Ewowo nasokai Dawidi amira ema tua waira be awa nune noko tamamunoya. Oro, oro, Anuture sanekai.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu meni Yerusalem kei awero Anutura ibu bamu amira toiro nena bamubamu awa ginua. Gosinoinu tua zizinoinu giro nu nata awa doro bua mai nuso 12 amire dai nata Betani amira bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pina atinu nukare nata Betani awa doro susauwa Yesu nu meri betero giro ");
INSERT INTO sue_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ni zo zazo nuso fik awa gire aike ena giro nu me eni itita asero gamu sero bamunua awa. Nu ni amira zorage kei awero me tepo gi gege ginua. Awa nera kota, me ziaira be tepo. ");
INSERT INTO sue_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Are Yesu meni nire waru ge ego senua awa, “Ema zo me niso oko namunoya.” Ago senu bua mai nuso meni ge awa niniwa awa. ");
INSERT INTO sue_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nukare kei awe Yerusalem niwa Yesu nu ibu bamura toiro ema ibu mokara ena nena ina-pota wai ema awa dero eseniro tunenua awa. Ago inoise nu ema moni ina-pota wai ema amira tebol awa zinu kapeteninu ema ni guma potai ema amira arumai dai kapeteninua awa. ");
INSERT INTO sue_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ago wero nukare nena dimuro ibu bamu amira izima-sauma wai azu senua. ");
INSERT INTO sue_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nu numorekare ego senua awa, “Ge gayai zo ego itia ewa, Ibu naso awa zebu serora isa saira ibu itaise. Ge gayai ago itia, ata nikare wetewa ibu awa bewana wai emara bezai masi ine inoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ema bama dapikarago meni Yesura ge niniro di tainiwa. Ago wewa pris babezinomare lo ge gipai ema enire meni ge awa niniro Yesu azu wero nu damu sero ebata tamamu wewa awa. ");
INSERT INTO sue_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tua zizinoinu Yesu bua mai nusore nukare Yerusalem doro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pina atinu nukare aita wero ni fik amira zorage baro ni binenua awa giwa. Tatawi nusore dai binenua. ");
INSERT INTO sue_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Are Petoro meni ni awa giro kotumuro Yesure ego senua awa, “Gipai ema, ei gi. Nima ni fik zo waru watasa ami binitaya.” ");
INSERT INTO sue_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ago senu Yesu meni ego senua awa, “Nikare Anutu tuma diwo. ");
INSERT INTO sue_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na ge me ego tona ewa. Ema zo meni dirumu emire ego samunoya awa, ‘Ni nitope eriro baro ewara dagimu.’ Nu ago samunoya, awa tani da ago ine nu emo kei awamunoya. Ata ema ami duba eto wamunoya, awa tani awa oko kei awamunoya. Nune, ‘Ge dirumure sesena awa me wamunoya,’ asero nuamunoya, awa tani awa nu emo kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Are na nimorekare tona ewa. Nikare nena zo pumamu sero giro isa samunowa be amire nikare ego kotumuwo: Anutu meni nena awa namorekare potamunoya. Ago kotumamunowa, awa nena awa pumamunowa. ");
INSERT INTO sue_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ota nikare isa samu sero giro dopero amire ema zore duba mou puro noma giro mou awa diseu. Mama nasokai utura itewia ami pasina nisokare dai disaise sero nikare emara pasina awa diseu.  ");
INSERT INTO sue_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ata nikare ema zora pasina kaka disamu wamunowa, awa Mama nasokai utura itewia ami pasina nisokare dai oko disamunoya.” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nukare noko tera baro Yerusalem kei awewa. Ago kei awewa Yesu meni ibu bamura ena aita inoinu pris babezinoma ata lo ge gipai ema eni ata simai eni ami nuso nana kei awero ");
INSERT INTO sue_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","numore ego sewa awa, “Ni namorekare se. Ni ara bera tani awa inowesi? Agai senu tani awa inowesi?” ");
INSERT INTO sue_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ago sewa Yesu meni numorekare ego senua awa, “Na nikare atata zo wamunona. Nikare ina namore samunowa, awa nane da ago ine ara bera tani awa inoweni amira susu samunona. ");
INSERT INTO sue_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohane ge ou bua nuso awa ara bera inoisi, — emara berata Anutura bera ni? Ge seu gane.” ");
INSERT INTO sue_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ago senu nukare nutopekare ge ina-sa inoise ego sewa awa, “Nakai Yohanera ou gutai awa utura nena asamunonakai, awa nu ego samunoya, ‘Are nikare nogoro ge nuso kaka ninamu wisewi?’ ");
INSERT INTO sue_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ata nakai ego samunonikaita? ‘Yohanera ou gutai awa eramara nena.’ Ago samunonikaita?” Ago ina-sa wewa. Awa nera kota, ema bama dapikarago meni Yohane gasara nu porofete me inoisonua, are nukare ema bama azu inoise ");
INSERT INTO sue_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yesure ego sewa awa, “Nakare kaka gamu inonakare.” Ago sewa Yesu meni numorekare ego senua awa, “Are na ara bera tani awa inoweni amira susu awa nimorekare oko kerenamunona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu meni ge bezai eni sero numorekare ego senua awa, “Ema zo meni wain bua urero pua gaero wain bua dia wai ema amira so wenua. Ago wero nu wain me zasaira ura bamu zo wamunua. Ago wero nu ema enire ego senua awa, ‘Na zebu zora bayamunona, are nikare bua naso dia weu. Dia wamunowa, awa na me nuso eni nimorekare potamunona.’ Ago sero nu doro zebu zora-zarako amira bamunua. ");
INSERT INTO sue_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Are wain me paira be munu giro buara mama meni bua mai zo ema bua nuso dia inoiwa amira nana baro wain me eni pumaise sero iyetinu bamunua. ");
INSERT INTO sue_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Baro kei awenu nukare nu puro wamu meni dero eseniwa tepo wana zipero bamunua. ");
INSERT INTO sue_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ago wenu giro buara mama meni noko bua mai zo nusokare nana bayaise sero iyetinu bamunu nukare nu puro sero ziro giti nuso dewa boya wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ago wewa giro buara mama meni noko bua mai zo iyetinu bamunu nukare nu dewa betenua awa. Tani ago ine inoise noisowa. Nu bua mai sasai potasai bayasara bua mai eni wamu meni dero bua mai eni dasara betinoisowa. ");
INSERT INTO sue_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ago inoe dowa ema daimata gege buara mama amira nana itinua. Nu mai mata nuso. Nu awa wama nuso. Are nu mai nuso nusokare nana bayaise sero ego senua awa, ‘Nukare mai nasora ge oko damunora.’ Ago sero iyetinu bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ata bua dia wai ema meni nutopekare ina-sa wero ego sewa awa, ‘Mai emira mama betai amire nu mamera zebu ewa pumamunoya. Nu danakai betai amire zebu nuso ewa zebu nasokai wamunoya awa. Mukai.’ ");
INSERT INTO sue_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ago sero nukare nu ziro dewa betenu woi nuso puro wain bua doro ape pua atune niwa awa. ");
INSERT INTO sue_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ago wewa, are wain buara mama meni nogo wamunoi? Nu muro dia wai ema awa dai betara amire ema eni meni zebu nuso dia warise samunoya awa. ");
INSERT INTO sue_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nikare Anutura ge ei awa kaka azimuro gamu meni sago inowa, atonua! So wai ema meni omata zo giwa waya wenu dowa. Ata omata ami so urura zasiwi wero itewia. ");
INSERT INTO sue_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nena awa Tuara bera kei awenua. Nakai genakai ziri inoya. Nikare ge awa gita azipisewita?” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nukare Yesura ge niniro nu ge bezai awa numorekare senua awa giro nu gera potamu sewa, ata nukare ema diti bamu ago itiwa awa azu wero giro Yesu doro bamuwa. ");
INSERT INTO sue_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yuda emara giti kopi eni meni Farisayo enire Herodera Pati memba enire awa Yesura nana iyetiwa bamuwa awa. Awa Yesura ge zo pumuro nu gera potamu sero bamuwa. ");
INSERT INTO sue_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nukare baro ge numore ego sewa awa, “Gipai ema, ni ge me gege towesa awa gosinonakare. Ni ema zo oko azu inosa. Ni ema zezewenaire ema osaire da ago ine gosinosa. Ni ge me toise Anutura ebata gipinowesa. Are nakai Yuda ema meni takis moni Roma emara ema tua Sisa amire potitinowenakai, awa ni gawesa te inowita tepo ni? ");
INSERT INTO sue_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nakai takis moni potamunonikaita duamunonikai?” Ago sewa awa. Ata nu opi nusokare giro ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","“Nikare nogoro na gaero gamu inowi? Moni zo potiu mai gane.” Ago senu nukare moni zo potiwa pumuro ego senua awa, “Ititire owere monira itia ewa awara ni?” Ago senu nukare ego sewa awa, “Awa Sisara.” ");
INSERT INTO sue_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ago sewa Yesu meni numorekare ego senua awa, “Nikare nena Sisara asero giro Sisare potiu. Ota nena Anutura asero giro Anuture potiu.” Ago senu nukare ge awa niniro di tainiwa awa. ");
INSERT INTO sue_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukayo ema meni ego toisowa, “Betai nukare noko oko eramunora.” Are Sadukayo eni meni Yesura nana muro atata wero sewa awa, ");
INSERT INTO sue_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Gipai ema, Mose meni namorekai ge ego gaenua awa: Ema zora nami betai ara nuso mai tepo itamunoya, awa ema ami nami nusora bama kuma awa atiro mai nami nuso emo pumaise. Mose meni ago gaenua awa. ");
INSERT INTO sue_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Are gita namisini 7 itisera. Nami zewai ami bama atiro mai kaka pumamu betisia. ");
INSERT INTO sue_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ago weti nami nuso namba tu ami bama da awa atiro mai kaka pumamu betisia. Ago weti nami namba tri da ago ine wisia. ");
INSERT INTO sue_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ago werota wero awinoe namisini 7 dapikarago dago bama awa atiro mai kaka pumamu betisera. Ama bama meni betisia. ");
INSERT INTO sue_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Namisini 7 meni nu atiro noisera, are bebetenai eramunora be amire bama awa ara wamunoi?” ");
INSERT INTO sue_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ago sewa Yesu meni numorekare ego senua awa, “Nikare Anutura ge gayaire Anutura putoure awa kaka gamu, are nikare ge me wosunitinowa. ");
INSERT INTO sue_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Betai meni eriro noko oko ina-ata wamunora. Nukare utura angelo ine wero nuamunora. ");
INSERT INTO sue_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nikare bebetenai eramunorita asero atata inowa, ata nikare ge Mose meni gaenua awa kaka azimuro gamu meni sago inowa, atonua! Nu ni payai zo awero kaka tepo wamu wenua amira uge awa gainomite amire ge zo Anutu meni numore senua awa ego gaenua awa, Na Abrahamto Isakare ata Yakobo amira Tua wero itewena. Nikare ge awa azipitinowewita? ");
INSERT INTO sue_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Anutu nu erama bebetenai asinowenakai awa gawi seka gege inowera. Are nu erama betaira Tua kota, nu erama seka itewera amira Tua wero itewia. Bebetenai eramunora amira susu wosuniro baititinowewa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lo ge gipai ema zo meni kei awero nukare ge ina-sa inoiwa ge awa nininua. Yesu meni numorekare ge ewanana ina-sa inoinu giro nu Yesu atata wero senua awa, “Lo ge na-ami namba wan inoi?” ");
INSERT INTO sue_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ago senu Yesu meni ego senua awa, “Lo namba wan awa ego itia, O Isreli ema, ge ei awa niniu. Bamu nasokai nu Anutu. Nu imata Tua nasokai. ");
INSERT INTO sue_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ara tamai niso bamubake awa Tua Anutu niso amira nana itaise. Ago inoise dubare ititire kotumaire putoure niso meni nu sou weyo. ");
INSERT INTO sue_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lo ge namba tu awa ego ewa, Ni nitope ara tapinowesa, da ago ine ema enire weyo. Lo ge eto ami gege bamu inorato. Lo ge zo ago ine tepo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ago senu lo ge gipai ema ami Yesure ego senua awa, “Gipai ema, me tosa. Anutu da gege itia. Tua zo tepo awa me sesesa. ");
INSERT INTO sue_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ota dubare kotumaire putoure meni Anutu ara tamai, o natopekai ara tamuro da ago ine erama enire wai, awa tani eto neine-naine awa. Ata tani nena Anuture potamu sero niaora potai awai, o tani wo Anuture potamu sero dai betai, awa tani eto neine pei-kaka gege.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ago senu Yesu meni ge nuso nininu ewanana wenu giro nu ema kotumaire giro numore ego senua awa, “Anutu meni Tua niso wai sogo inoya.” Ago senu ema bama dapikarago Yeu atata wai azu wewa awa. ");
INSERT INTO sue_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu meni Anutura ibu bamura toiro nukare ge tugata inoise ego senua awa, “Lo ge gipai ema meni ego towera, ‘Yuda emara Soyai Ema zazo nuso Kristo, nu ami Dawidira sibuna.’ Nogoro ago toweri? ");
INSERT INTO sue_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ozana meni kotumai Dawidire potinu Dawidi nu nutope ego senua awa, Anutu meni Tua nasore ego senua awa, ‘Ni muro wana me nasora arumuro itasa na iwo dubu niso awa benau nisora potana isimamunosa.’ Anutu meni Tua nasore ago senua awa. Dawidi ago senua awa.” Yesu meni ago sero susumuro ego senua awa, ");
INSERT INTO sue_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Dawidi meni ge ago toise Kristore Tua naso asenua. Are Kristo nu nogoro Dawidira sibuna wamunoi?” Yesu ago senu ema diti bamu meni ge nuso niniro yawa sara wewa awa. ");
INSERT INTO sue_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu meni ge tugata inoise ego senua awa, “Nikare lo ge gipai ema awa uma wewo. Nukare tama woi iboboi wosuniro aita inuara ema bama meni nukare kakame ena giro arenarise yaba inowera. ");
INSERT INTO sue_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Noko nukare yere ibura ena ema bama nana benaura arumamu yaba inowera. Noko nukare ana-bona waira bere ena masi zazore amira arumamu yaba inowera. ");
INSERT INTO sue_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nukare bama iu betai amira wau awa soero pupinowera. Ago inoise nukare pasina nusokare gogo wero me irora inoise isa iboi-tatana towera. Ema ami ina nusokare mou-mau bamu tamamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu meni Anutura ibu bamura toiro arumuro ema bama omata kolektara potitinoiwa awa ginua. Ema waure dainiro meni wau witai potitinoiwa ");
INSERT INTO sue_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","bama bogamasa zo iu betai ami muro toea eto potinua awa. ");
INSERT INTO sue_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ago wenu giro Yesu meni bua mai nuso zawa senu muwa ego senua awa, “Na ge me nimorekare tona ewa. Bama zo iu betai wau tepo ami omata potia awa ema dapikarago omata Anuture potitinora amira omata awa dainitinoya. ");
INSERT INTO sue_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nera kota, nukare awa omata witai itia, ata nukare eni gege Anuture potera. Ata bama awa omata nuso pei-kaka itia awa te potiro tepo wetia. Are nu nena zuma gaero naira zo oko itia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu bua maire dai ibu bamu doro kei damu nitinoiwa bua mai zo meni numore ego senua awa, “Gipai ema, ibura omata babezinoma awa giyo. Ibu neine-naine awa.” ");
INSERT INTO sue_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ago senu Yesu meni numore ego senua awa, “Ni ibu ewanana gosinosa. Ata ama ibura omata zo oko duara zora nana tame itamunoya. Ema meni ama ibura omata dapikarago ziwamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu meni dirumu zazo Oliwa amira witiro arumuro ibu bamu awa ua inoise itinu Petoroto Yakobore ata Yohaneto Andereare nukare ami imata numore dai itise giro nu atata wero sewa awa, ");
INSERT INTO sue_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Gire, tani awa be nazi kei awamunoi? Ota nakare tani ne giro susu amira me kei awinoya awa gamunonikare?” ");
INSERT INTO sue_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ago sewa Yesu meni numorekare ego senua awa, “Ema zo meni nikare etete nai azu, nikare giro baitiu. ");
INSERT INTO sue_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ema saisai meni muro opi toise ego samunora awa, ‘Na Kristo.’ Ago toise nukare erama saisai etete namunora. ");
INSERT INTO sue_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nikare bogi-zuzuna zorage itamunora amire bogi-zuzuna zora-zarako itamunora amira oziga niniro azu oko wawe. Bogi-zuzuna kei awamunora, ata kei awara zebura be oko eya pesunamunoya. Ama tani eni susumuro kei awamunora. ");
INSERT INTO sue_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dubu zo meni eriro dubu zore dai bogi-zuzuna wamunora. Ema tua enira dubu meni eriro ema tua enira dubure bogi-zuzuna wamunora. Duwi babezinoma sumamunora. Noko dora botiyo babezinoma kei awerota kei awero awamunora. Bama mai pumamu inowera amira yaya mena pei-kaka zaawinowia. Ata ama meni awa bamubake kei awinowia. Ago ine yaya sesena awa kei awai amire yaya bamubake ama kei awamunoya, awa gamunowa. ");
INSERT INTO sue_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ata nikare nitopekare giro baitiu. Nukare nikare puro gera potamunora. Nunekare nikare yere ibu duru ena wamu meni damunora. Nikare bua mai naso wero nowewa, are nunekare nikare puro ema babezinomare ema tuare amira nana potara dopamunowa awa. Dopero ge me numorekare samunowa. ");
INSERT INTO sue_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Oziga Ewanana zebu sero gita bayai amire tani awa ama kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ema meni nikare saniro puro gera potamunora be amire nikare ne sewi wero kotumu-katumu oko wawe. Nikare gera potamunora be amire ge Anutu meni nimorekare potai awa seu. Ninekare kota, Ozana meni ge samunoya. ");
INSERT INTO sue_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Namisini eni meni namisini nusokare betarise sero iwora wanera potamunora. Mamana eni meni mai awiso nusokare betarise sero iwora wanera potamunora. Mai awiso eni meni eriro miamai mamana iwo inoise betarise sero iwora wanera potamunora. ");
INSERT INTO sue_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nikare zazo naso itia, are ema bama dapikarago ami tini gamaire nimorekare wamunora. Ata zo nu zewai wero dopero noma betamunoya, nu awa Anutu meni soero pumamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu meni ago sero senua awa, “Sisaira nena waya ami so zora dopai te kaka wamu wamunoya, awa gamunowa. Be amire nukare Yudaya zebura itamunora ami azu sumuro bamu dirumura narise. (Ema ge gayai ei awa azipitinoya ami gera susu awa gaise.) ");
INSERT INTO sue_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Be amire zo nu so nusora ope itamunoya ami neu-nau nuso sora itia awa pumamu oko toyaise. ");
INSERT INTO sue_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Be amire zo nu buye nuamunoya ami tama woi nuso pumamu sero oko ewesemuro nate bayaise. ");
INSERT INTO sue_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Oi, bama wasou wai ata bama mai unore. Nukare pena-pana sumai ine tepo, are na nukare emo zo apinona. ");
INSERT INTO sue_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tani awa wara be amire kei awai wa meni nikare gazai azu, nikare isa sewo. ");
INSERT INTO sue_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nera kota, be amira ana mou bamubake kei awamunoya awa. Anutu meni zebu tamunua ana zaawero tupie dowa mou zo ago ine oko kei awenua. Ata ama zo ago ine noko oko kei awamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Are Tua meni be awa kaka kapamu wamia, awa erama dapikarago sisero tepo wamera. Ota nu gegenai dubu nuso emo wero amire be awa kapenua, are apunu-kaka wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Are be amire ema zo meni nimorekare ego sai oko ninawe, ‘Ewa Soyai Ema nasokai awa.’ Ota, ‘Soyai Ema nasokai owa.’ Ge ago ine sero muro baro awara oko ninawe. ");
INSERT INTO sue_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Be amira ana Soyai Ema opi enire porofete opi enire ami kei awamunora. Kei awero eramara duba siso-siso wamu sero tani putoure eni ata tani benau sekare witai awa wamunora. Ago inoise Anutura gegenai dubu amira duba dai siso-siso wamu sero bua bamu wamunora awa. Ata nukare Anutura gegenai dubu amira duba siso-siso wai ine tepo, are wero zainamunora awa. ");
INSERT INTO sue_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ata nikare nitopekare uma weu. Na tani ama kei awamunora amira ge bere-bere eware nimorekare kerenitinona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesu meni ago sero senua awa, “Yaya tamaira be awa tepo wai amire waiko mume wamunoya. Ago wai inuara zasimai awa dai tepo wamunoya. ");
INSERT INTO sue_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ago inuai amire putou utura itewera ami zipamunora. Ago wai kuna meni utura ena sokero osamunora. ");
INSERT INTO sue_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tani ago ine kei awai amire na Emara Mai meni putou zewaire zasimaire berezera ena osero tupiana ema bama meni gamunora awa. ");
INSERT INTO sue_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na osero angelo iyetiro erama dubu Anutu meni nuso warise gegeninua awa puro dara potarise samunona. Are angelo meni baro zebu wenare wenare iketa bage amira gegenai dubu naso pumamunora awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesu meni ago sero senua awa, “Nikare ni zazo fik amira tani awa kotumuro amire susu zo giu. Bona nuso gotu gi nuso zazawera be amire nikare giro, ‘O, waikora be kei awinoya,’ asinowewa. ");
INSERT INTO sue_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Are nena awa dapikarago kei awero tepo wai giro ego sewo, ‘Nu zora awetia. Toyai bera atune dopinoya.’ ");
INSERT INTO sue_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na ge me nimorekare tona ewa. Ema bama zeme zebura nora ami kaka betero tepo wamu nuara amire nena awa dapikarago kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ama uture zebure sisero tepo wamunorato, ata ge naso meni awa oko sisero tepo wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesu meni ago sero senua awa, “Ota tani awa kei awaira be nuso awa ema zo da di kaka gamu. Angelo utura nowera ami dai be awa kaka gamu. Na Anutura Mai meni dai be awa kaka gamu. Mama naso meni gege imata gosinoya awa. ");
INSERT INTO sue_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nikare uma inoise noiwo. Be nazi tani awa kei awamunoi, awa nikare kaka gamu. Are uma wero baitiu. ");
INSERT INTO sue_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Susu nuso ego ine itia. Ema zo meni zebu zora-zarako amira bayamu sero giro bua mai nuso nukare nena dapikarago dia warise sero buara potinua. Zo bua zora potiro zo bua zora potiro awenua awa. Ago inoise so be dia wai mai meni uma wero baitaise sero so doro bamunua. ");
INSERT INTO sue_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Are be nazi sora mama meni ewesemamunoi — tua ziaireta, pi soe sienirota, kokara ge tuai amireta, noko pina ataire ni? Awa nikare kaka gamu, are nikare uma wero baitiu. ");
INSERT INTO sue_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nu eya ewesemuro nikare gitawa inoise itawa tamai seroko nikare uma wero baitiu. ");
INSERT INTO sue_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na ge nimorekare daba kota, ema bama dapikarago amire tona. Nikare uma wero baitiu.” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Betai Daininua amira bona naira be kei awinoinu pura zo ame yis tepo amira bona naira be auma noko auma kei awamu inoinu giro pris babezinomare lo ge gipai ema enire ami Yesu eteteniro ziro dara betaise sero ebata tamamu wewa. ");
INSERT INTO sue_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nukare ego sewa awa, “Ema bama nakai dameraya, nakai bona naira be amire oko wanekai.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu bua mai nusore nata Betani ago baro ema zo zazo nuso Simon Boya Ayare amira nana sora itise nena ninoise itiwa bama zo kopi omata zazo nuso alabasta ami wai awa puro nuso nana munua. Ou zo zazo nuso nad, zama nuso ewanana, awa kopi mokara itinua. Zuma nuso witai. Are bama meni kei awero kopi awa toumuro ou zamare awa Yesura nana gitine zozenua. ");
INSERT INTO sue_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ago wenu ema eni ago itiwa ami wama erinu ina-sa wewa awa, “Nogoro giro ou awa zainitinoi? ");
INSERT INTO sue_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nu ou awa omata emo potiro 300 kina pumuro erama bogamasare potai te wamia.” Ago sero nukare bama senewa. ");
INSERT INTO sue_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ago sewa Yesu meni numorekare ego senua awa, “Nikare bama dou. Nikare nogoro bamere zuzu towi? Tani nu namore wetia, awa tani ewanana. ");
INSERT INTO sue_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nera kota, erama bogamasa nukare nimorekare dai nowera nuamunora. Are nikare nukare kora wamu sero kotumamunowa, awa ebata ago itamunoya. Ata nane meni awa nimorekare dai oko nuai gege nuamunona. ");
INSERT INTO sue_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Bama ami tani zo wai ine te inoi giro tani awa wetia. Ama nukare woi naso gowamunora, ata nu bere-bere muro betaira ou awa woi nasora potia. ");
INSERT INTO sue_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na ge me nimorekare tona ewa. Oziga Ewanana zebu sero susawiai amire tani ewanana namore wetia amira oziga awa dai sero sero awara bayamunoya awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Be amire Yudas Iskeriot, nu bua mai 12 amira zo, ami Yesu kereniro gera potamu sero pris babezinomara nana bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bamunu nukare ge nuso niniro yawa sara wero numore ego sewa awa, “Ago wasa nakare omata eni nimore potamunonakare.” Ago sewa giro nu Yesu gera potaira ebata tamamu bua wenua. ");
INSERT INTO sue_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pura yis amu amira be namba wan amire Yuda ema meni Betai Daininua amira bona awa namu sero wo sipsip mai zo dero azero ninoisowa. Are be awa kei awenu giro Yesura bua mai meni numore ego sewa awa, “Nakare nago baro Betai Daininua amira bona niso sia wanisekare kotupitinosi?” ");
INSERT INTO sue_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ago sewa giro Yesu meni bua mai nuso eto iyetitinoise numoreto ego senua awa, “Nito nate baroto ema zo ou aura dimuro puro susawia awa tamamunowato awa. Nito numore dai bayamunowato. ");
INSERT INTO sue_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nu sora toyai amire nito sora mamere ego seuto, ‘Gipai ema meni ni atata inoya. Nu nakare bua mai nusore Betai Daininua amira bona so moka na-amira ena namunonikare?’ ");
INSERT INTO sue_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ago sawato nu so moka bamu zo so ike itia awa nimoreto gipamunoya. So moka awa sawa diai au-tewa sia wai itia. Gipai giro ana nito bona naira nena sia wewoto.” ");
INSERT INTO sue_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ago senu giro bua mai eto meni eriro nate baro nena Yesu meni senua da ago ine tamuroto Betai Daininua amira bona naira nena sia wewato awa. ");
INSERT INTO sue_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tua zinu Yesu meni bua mai nuso 12 amire dai kei awewa. ");
INSERT INTO sue_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nukare arumuro nena ninoise itiwa amire Yesu meni ego senua awa, “Na ge me memeka nimorekare sane. Nisokare nana zo meni na kereniro iwora nana wanera potamunoya. Ema namore dai nena ninoya ami wamunoya.” ");
INSERT INTO sue_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ago senu nukare duba nitinoise imata-kamata numore ego sewa awa, “Nane oko wamunona. Me tonita?” ");
INSERT INTO sue_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ago sewa nu numorekare ego senua awa, “Nikare bua mai naso 12 amira zo meni wamunoya. Ema zo namore dai ame sura patitinoya ami wamunoya. ");
INSERT INTO sue_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ge gita gaewa itewia da ago ine na Emara Mai meni betamu susawena. Ata ema na Emara Mai kerenamunoya, nu awa, Oi, ina nuso nogo pumamunoi? Mia nu kaka pumamu wamia, awa nu waya oko tamamia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nukare nena ninoise itiwa Yesu meni porong pumuro Anuture kokopai asero eweweniro bua mai nusore potitinoise ego senua awa, “Pumuro niu. Ewa pisi naso.” ");
INSERT INTO sue_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ago sero nu akou ou wainre zo pumuro Anuture kokopai asero numorekare potinu nukare dapikarago puro niwa. ");
INSERT INTO sue_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ago wewa Yesu meni numorekare ego senua awa, “Awa orara naso. Orara naso meni Anuture tairo nuai amira ge ziai zewai wamunoya. Orara naso erama dainiro emo zozamunona. ");
INSERT INTO sue_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na ge me nimorekare tona ewa. Na ou wain noko oko namunona. Ama Anutu imata Tua wero nuaira be kei awai amire na ou wain seka namunona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nukare yere zo gamuro eriro Yerusalem doro bamuro dirumu zazo Oliwa amira witiro itiwa ");
INSERT INTO sue_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu meni numorekare ego senua awa, “Nikare dapikarago na duamunowa. Nera kota, ge gayai zo ego itia ewa, Na Anutu meni wo sipsip dia wai ema dana betai wo sipsip awa siso-siso wamunora. ");
INSERT INTO sue_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ata na betaira ena eriro Galilaya zebura bayana nikare ama mamunowa.” ");
INSERT INTO sue_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ago senu Petoro meni numore ego senua awa, “Nukare dapikarago ni duamunora, ata na ni oko duamunona.” ");
INSERT INTO sue_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ago senu Yesu meni numore ego senua awa, “Na ge me nimore tona ewa. Nine pi emire kokara meni ge be eto kaka samure na begi wasa be etorobara wamunoya.” ");
INSERT INTO sue_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ago senua, ata Petoro meni zewai ge senua awa, “Nukare na nimore dai dara betanise samunora. Ata saineba, na ni oko begi wamunona.” Petoro meni ago senu giro nukare dapikarago ami ge da ago ine sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu bua mai nusore nukare baro so zo zazo Gesemani amira kei awero nu bua mai nusore ego senua awa, “Nikare ego arumuu. Na isa samunona.” ");
INSERT INTO sue_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ago sero nu Petoroto Yakobore ata Yohane awa puro baro wetu wana nuso zipenu ");
INSERT INTO sue_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nu numorekare ego senua awa, “Na duba nai bamure nona. Duba nai meni na puro osesi betanise inoya. Nikare ego itise seka zisero uma weu.” ");
INSERT INTO sue_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ago sero nu pei-kaka baro zebura bawa diro isa toise yaya nuso nana kei awamu inoinua awa nu dainai te wai giro dainaise senua. ");
INSERT INTO sue_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Isa ago toise ego senua awa, “O Mama naso, ni tani dapikarago wai te inoya. Ni yaya ei awa naso nana ena pumuyo. Ata kotumai nasora kota, kotumai nisora weyo.” ");
INSERT INTO sue_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Isa ago sero ewesemuro nukare gitawa inoise itiwa giro nu Petorore ego senua awa, “Simon, gitawa inosua. Ni be pei-kaka gege seka zisero itai ine tepo ni? ");
INSERT INTO sue_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Etetenai meni nisokare nana kei awai azu, nikare seka zisero isa toise itiu. Duba nisokare meni bua kokopai waira peu inoya, ata tama meni mou inoya.” ");
INSERT INTO sue_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ago sero nu noko baro isa gita senua da ago ine noko senua. ");
INSERT INTO sue_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Isa sero ewesemuro nukare giti moweninu gitawara dago itiwa ginua. Giro senu nukare ne seri wero dowa. ");
INSERT INTO sue_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesu meni noko baro be namba tri ewesemuro numorekare ego senua awa, “Nikare zanatitinoise gitawa inowa, atonua! Te wetia. Be kei awetia. Emara Mai kerenera pasina emara nana wanera wititinona. ");
INSERT INTO sue_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kerenai ema tupia. Eriu, nusokare nana bayanekai.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ago tuaise bua mai 12 amira otao nusokare Yudas meni iwo dubu bamu gita wenu kei awewa awa. Iwo dubu awa pris babezinoma ata lo ge gipai ema ata simai ami iyetiwa goroba wamu sero kasiware dobare pumuro puro kei awewa awa. ");
INSERT INTO sue_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gita kerenai ema ami iwo dubu bamure ge zo gipero ego senua awa, “Ema nane saniro imamunona, numa awa. Are nikare nu saniro puro bayamunowa.” ");
INSERT INTO sue_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ge awa gita senua, are nu kei awero Yesura nana eya baro, “Gipai ema,” ago sero nu imunua awa. ");
INSERT INTO sue_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ago wenu giro iwo dubu meni Yesu ziwa. ");
INSERT INTO sue_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ago wewa ema dopero itiwa amira zo meni kasiwa nuso egira ena zinu kisimunu nu pris bamura soumai awa damu wero dana nuso kesenua. ");
INSERT INTO sue_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ago wenu Yesu meni iwo dubure ego senua awa, “Nikare kasiware dobare puro tupewa, awa goroba ema zo puro benamu mago inowa. ");
INSERT INTO sue_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Be giti awa na nimorekare dai ibu bamura ena nuawena nikare ana nogoro na kaka pumamu inowewi? Ata Anutura ge gayai awa me waise.” ");
INSERT INTO sue_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ago senu bua mai nuso dapikarago nu doro sumuro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mai seka zo meni mo kapawai zo gege awero Yesu ama ganinoinu iwo dubu meni nu sanamu wewa ");
INSERT INTO sue_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nu mo awai nuso uzero doro tepo sumuro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nukare Yesu puro pris bamura nana bamuwa pris babezinomare simai enire lo ge gipai ema enire ami so amira auniwa awa. ");
INSERT INTO sue_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ago wewa Petoro meni Yesu zora-zarako ena ama ganero muro pris bamura goma toiro baro uma wai ema amire dai arumuro ni awinoise kakame itinua awa. ");
INSERT INTO sue_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pris babezinomare giti kopi dubu dapikaragore nukare te itise ema zo meni Yesure opi sai Yesu gera potiro dara betaise sero opi ge siana-katana wewa awa. Ata nukare pasina nuso zo kaka tamamu wewa. ");
INSERT INTO sue_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ema saisai meni Yesu tani inoisonua amira ge uge inoise ge opi eni sewa, ata ge opi nusokare da awa gege tepo. ");
INSERT INTO sue_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Eni meni dopero opi sero ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nakare ge nuso ninisenakare. Nu ego sisia, ‘Na Anutura ibu erama meni wewa awa ziwamunona. Ziwana waiko be etorobara tepo wai amire na ibu zo wana meni wai kota, ewe zo wamunona.’ Nu ago sesi ninisenakare.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ata nukre ago toise ge da awa kaka samu wewa. ");
INSERT INTO sue_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pris bamu meni nusokare nana soe damu dopero Yesure ego senua awa, “Ni nogoro ge niso tora amira ina kaka samu ge tepo itesi?” ");
INSERT INTO sue_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ago senua, ata Yesu meni ge ina kaka samu tepo dopero itinua awa. Ago wenu pris bamu meni noko atata wero senua awa, “Ni Yuda emara Ema Tua zazo Kristo Anutura Mai meta tepo ni?” ");
INSERT INTO sue_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ago senu Yesu meni ego senua awa, “Na Kristo. Nikare na Emara Mai awa Anutu Putoure amira nana wana mera arumuro itana gamunowa. Na utura berezere dai tupiana gamunowa.” ");
INSERT INTO sue_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ago senu pris bamu meni Yesu nu Anutura zazo dena-betena wenu sia sero tama woi nuka nuso zinu keenu ego senua awa, “Nakai nogoro ema eni muro nu gera potarise samunonikai? Nu nutope aware gera potia. ");
INSERT INTO sue_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nikare ge waya nuso niniro nogo kotupitinowi?” Ago senu nukare sewa awa, “Pasina nuso waya, are dara betaise.” ");
INSERT INTO sue_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ago sewa eni meni be pora nuso nana tame pisero giti moka nuso gogowero wana meni dero amire ego sewa awa, “Yei porofete, ema ai meni ni deti, amira zazo nuso kereni ganekare.” Ago sewa nu beniro puro itiwa ami nu sowene pena-pana dewa awa. ");
INSERT INTO sue_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petoro meni bage kakame ena arumuro itinu pris bamura soumai bama diri zo meni muro Petoro ni awinoise itinu ");
INSERT INTO sue_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","giro nu ua inoise ego senua awa, “Ni dai Yesu Nasaretera ema amire dai nowesa.” ");
INSERT INTO sue_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ago senu nu ego senua awa, “Na kaka gamu. Ni ge tosa awa na kaka gamu inona.” Ago sero nu goma bera bamunu kokara zo meni ge senua awa. ");
INSERT INTO sue_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Petoro ago bamunu soumai bama diri da ami nu giro ema ago itiwa amire noko senua awa, “Ema ewa dubu nuso amira zo.” ");
INSERT INTO sue_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ago senu Petoro meni noko begi wero “Tepo awa,” ago senua awa. Be pei-kaka tepo wenu amire ema ago itiwa ami Petorore ego sewa awa, “Ge me tonakare awa. Ni dubu nuso amira zo awa. Nera kota, ni dai ni Galilaya ema zo.” ");
INSERT INTO sue_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ago sewa nu noko Anutura nana benaura ge ego senu zewai wenua awa, “Na opi samunona, awa Anutu meni na dai betamunona. Nikare ema zazo towa awa na nu kaka gamu.” ");
INSERT INTO sue_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ago senu kokara eya ge namba tu senua awa. Kokara ge senu Petoro meni Yesura ge kotumunua. Yesu meni gita Petorore ego senua awa, “Nine kokara ge be eto kaka samure na begi wasa be etorobara wamunoya.” Yesu meni gita ago senua, awa nutope kotumuro di bamu senua awa. ");
INSERT INTO sue_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pina atitinoinu pris babezinoma ata simaire lo ge gipai ema enire ata giti kopi dubu dapikarago nukare ami auniro ge te sero Yesura wana eto beniro puro Pilato nana bamuwa.* ");
INSERT INTO sue_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Puro bamuwa Pilato meni nu atata wero senua awa, “Ni Yuda emara ema tua ni?” Ago senu Yesu meni ina ego senua awa, “Iyo, tosa awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nukare Yesura ge bua inoiwa pris babezinoma meni opi toise Yesu nu tani waya saisai inoisonua ago sewa. ");
INSERT INTO sue_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ago sewa Pilato meni nu noko atata wero senua awa, “Ni ge ina sai ine tepo ni? Nukare tani waya niso amira ge saisai kerenitinora, gosa.” ");
INSERT INTO sue_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ago senua, ata Yesu meni ge zo kaka samu wenu giro Pilato meni kotumuro di taininua awa. ");
INSERT INTO sue_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Zepa sero bona waira be kei awasai Yuda ema meni benai sora mai zo emo sasara giro Pilato meni mai awa besinoisonua. ");
INSERT INTO sue_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Are ema zo zazo nuso Barabas ami ema enire dai benai sora itinua awa. Nukare gavman damu sero bogi wero ema eni dewa betewa, are nukare benai sora itiwa. ");
INSERT INTO sue_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Are ema diti bamu meni Pilato nana kei awero ego sewa awa, “Ni zepa sero tani zo nakare emo inowesa awa noko weyo.” ");
INSERT INTO sue_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ago sewa nu ego senua awa, “Na Yuda emara ema tua besero nimorekare potanise kotupitinowita?” ");
INSERT INTO sue_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato meni pris babezinoma nukare Yesu zuzu sero tepo puro bamuro nuso nana potiwa awa kotumuro amire ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ata pris babezinoma meni ema diti bamure ego sewa awa, “Nu Yesu kota, Barabas awa besaise seu.” Ema diti bamu ago sarise sewa zewai wenu giro ge da awa sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Are Pilato meni niniro numorekare noko ego senua awa, “Are ema nikare nu Yuda emara ema tua asinowewa, nu awa puro nogo wanise towi?” ");
INSERT INTO sue_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ago senu nukare ge gunero numore ego sewa awa, “Ni pasinaira poti betae.” ");
INSERT INTO sue_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ago sewa Pilato meni ina numorekare ego senua awa, “Nogoro ago towi? Nu pasina ne wisi?” Ago senua, ata nukare ge pena-pana gunero noko ego sewa awa, “Ni pasinaira poti betae.” ");
INSERT INTO sue_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ago sewa giro Pilato meni ema bama duba peu warise sero senu soldia meni Barabas besewa kei awenu nukare Yesu asi wo tata meni wai dirinare ami wezewa awa. Wezinomite dowa amire Pilato meni Yesu ni pasinaira dara betaise sero soldiara nana wanera potinua awa. ");
INSERT INTO sue_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Roma ema tuara soldia eni meni Yesu puro Roma ema tuara sora witiro sewa soldia dapikarago nuso nana auniwa. ");
INSERT INTO sue_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Auniro tama woi bewa dito ine numore wosuniro asi dirinare puro bubuna wero giti nusora wosuniwa awa. ");
INSERT INTO sue_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ago wero nu isipitinoise ema tua arenago inoise ego sewa awa, “Waiko koko, Yuda emara ema tua.” ");
INSERT INTO sue_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ago sero giti nuso wamu meni doinoise pora nuso nana tame pisinoise koiniro nu bowi etete wewa awa. ");
INSERT INTO sue_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nukare nu isipitinomite tama woi bewa dito ine awa dutuniro doro tama woi nuso noko wosuniwa pumunu ni pasinaira damu sero puro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ema zo zazo nuso Simon, zebu nuso Sairini, nu Alesandato Rufasra mama, nu soe zo ena muro Yerusalem bayamu inoinu nukare ge zewai numore ego sewa awa, “Nine ema emira ni pasinai awa dimu.” ");
INSERT INTO sue_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ago sero nukare Yesu puro bamu zebu zazo Goligata amira niwa awa. Zebu amira zazo awa susu nuso ego ewa, “Giti kopira wetu.” ");
INSERT INTO sue_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nukare ou wain puro duba dau waira ou zo zazo mira amire dai dawero numore potiwa, ata nu kaka namu donua. ");
INSERT INTO sue_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nukare nu ni pasinaira niri meni dero potiwa. Potiro mo nuso kanowamu sero, agai meni mo zo pamunoi, asero ozina laki wero mo nuso kanowewa awa. ");
INSERT INTO sue_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nukare nu dewa awa waiko diti 9 klok wenu nukare nu ni pasinaira potiwa. ");
INSERT INTO sue_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Are gitine ike ena susu nera nu deu amira ge ego ine gaero potiwa itinua awa, “Yuda emara ema tua.” ");
INSERT INTO sue_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Be amire nukare bewana wai mai eto dai ni pasinai nusotora dero Yesu nana zo enibara zo enibara potiwa dopewato awa.  ");
INSERT INTO sue_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ago wewa Anutura ge gita gaewa ami me wenua. Ge awa ego ewa, Nukare nu giwa pasina ema ine wenu giro nu pasina emare dai potiwa awa. Ge awa gita gaewa ami me wenua. ");
INSERT INTO sue_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ema bama meni izima-sauma inoise nu isimuro numore ego sewa awa, “Ae, ni ema ibu bamu ziwero waiko be etorobara gege ibu seka wero tepo wamu sisesa. ");
INSERT INTO sue_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ni nitope tama aiso niso gera waira ena soero ni pasinaira ena ose dopase.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Da ago ine pris babezinomare lo ge gipai ema enire meni Yesu isipitinoise ina-sa wewa awa, “Nu gita ema eni soremuro kora inoisia, ata nu nutope soremai ine tepo. ");
INSERT INTO sue_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristo nu Isreli emara ema tua nasokai nowia ami zeme ni pasinaira ena osaise. Osai giro, ‘Me sisia,’ asamunonakai.” Ago ina-sa wewa awa. Ema eto ni pasinaira itiwato ami dai nu isewato awa. ");
INSERT INTO sue_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Waiko diti 12 klok wenu mume bamu kei awero zebu te wero itinu 3 klok wenua amire ");
INSERT INTO sue_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yesu meni arero ego senua awa, “Eloi, Eloi, lama sabaktani.” Ge amira susu ego ewa, “Anutu naso, Anutu naso, ni nogoro na dotinosi?” ");
INSERT INTO sue_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ago senu ema eni zorage itiwa ami ge awa niniro ego sewa awa, “Giu. Nu Elia zawa toya.” ");
INSERT INTO sue_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ago sewa giro mai zo meni sumuro baro ewara somisomi zo ou wain dokakara patiro utura gaero Yesu meni naise sero numore potiro ego senua awa, “Nakai nu Elia meni muro ni pasinaira ena pamunoita, awa ganekai.” ");
INSERT INTO sue_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ago senu Yesu meni noko zawa gatero betenua awa. ");
INSERT INTO sue_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Betenu ibu bamura mo bamu* kimenai awa ike ena zaawero keero eto wenua awa. ");
INSERT INTO sue_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldia 100 amira kapten meni Yesu ua inoise itinu Yesu betenu giro ego senua awa, “Ema ami nu Anutura Mai me.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bama eni dai itiwa. Nukare asikera dopero ua inoise itiwa awa. Enira zazo nusokare Maria nata nuso Madala, ota Maria zo nu Yakobo Sekato Yosera mia, ota bama zo zazo nuso Salome. ");
INSERT INTO sue_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Gita Yesu Galilaya zebura noisonua be amire bama ami nu ama ganero nena nuso sawinoisowa awa. Ota bama saisai eni Yesure dai Yerusalem kei awewa ami numorekare dai ago dopero itiwa awa. ");
INSERT INTO sue_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Arimatia natara ema zo zazo nuso Yosefe, nu giti kopi dubu amira ema zo zazore awa. Nu dai Anutu imata Tua wero nuamunoya amira be dia noisonua. Are nu ami tua zizinoinu be bona sia waira be kei awenu auma awa Sabat pura giro nu zewai wero Pilato nana bamuro Yesura woi pumamu senua awa. ");
INSERT INTO sue_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yesura woi pumamu senu giro Pilato meni, nu betetita, asero soldia 100 amira kapten zawa senu munu ego senua awa, “Yesu betetita?” Ago senu kapten meni ego senua awa, “Nu betetia.” ");
INSERT INTO sue_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ago senu giro Pilato meni Yosefe baro Yesura woi pumaise senua. ");
INSERT INTO sue_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Senu Yosefe meni baro mo kapawai ewanana zo zuma gaero puro baro Yesura woi ni pasinaira ena bataniro mo ami ewero puro omata so wamai amira potinua. Ago potiro omata zo dereweninu baro omata sora be awa gazenua awa. ");
INSERT INTO sue_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ago wenu Maria eto, zo nata nuso Madala, zo nu Yosera mia, ami omata sora woi nuso potiwa awa giwato awa. ");
INSERT INTO sue_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat pura be tepo wenu Maria nata nuso Madala amireto Maria nu Yakobora mia, nuto ata bama Salome ami baro ou zama saira siwo Yesura woi tame zozamu sero zuma gaero pumuwa awa. ");
INSERT INTO sue_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Are purara be namba wan zazo nuso Sande awa kei awenu pina atinu nukare pina gamu bi diti nusora bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nukare susawise nutopekare ina-sa wewa awa, “Ai meni omata zo so be gazai awa nakai emo dereweniro enibara potamunoi?” ");
INSERT INTO sue_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ago sewa, nera kota, omata awa bamubake. Ago sero iri gita niro omata awa so be doro enibara itinua awa giwa. ");
INSERT INTO sue_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Are nukare omata sora toiro mai seka zo wana mera arumuro itinua awa giwa. Mai amira mo kapawai awa iboi-tatana. Bama meni nu giro mamana awewa. ");
INSERT INTO sue_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ago wewa mai ami numorekare ego senua awa, “Nikare azu wamu dou. Nikare Yesu Nasaretera ema detera betisia awa tamamu sero tupewa. Nu eria. Nu ego oko itia. Masi woi nuso ago potisera awa giu. ");
INSERT INTO sue_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ata nikare bamuu, bua mai nuso eni ata Petorore dai ego sawa gare, ‘Nu Galilaya zebura gita susawia. Are nikare baro nu ana gamunowa awa. Ge da ago ine gita nimorekare sisia.’ Ago seu gare.” ");
INSERT INTO sue_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ago senu nukare omata so doro sumuro bamuwa. Nera kota, nukare azu wero wetu wana zipewa. Are nukare azu inoise ge ema zore kaka samu wewa awa.  ");
INSERT INTO sue_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu meni purara be namba wan zazo Sande amire pina gamu eriro nutope gita Maria nata nuso Madala amira nana kei awenu ginua awa. Gita Yesu meni bi 7 Mariara nana ena tunenua. ");
INSERT INTO sue_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Bama ami baro Yesura dubu di toise dibe inoise itiwa amire ego senua awa, “Na nu gena.” ");
INSERT INTO sue_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ago senu nukare bama meni Yesu seka wero erinu ginua amira ge senua awa niniwa me oko wenua. ");
INSERT INTO sue_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ama Yesu meni benau ewe wero ema eto ebete susauwato soe ena nutope nusoto nana kei awenu giwato. ");
INSERT INTO sue_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nu numoreto dai noinu nu giwato kei awenu giro nuto noko tera Yerusalem baro Yesura dubu enire sewato, ata nukare ge nusoto niniwa me kaka wamu wenua. ");
INSERT INTO sue_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ama nu bua mai nuso 11 ami nena ninoise itiwa amire nutope nusokare nana kei awenu giwa. Ema bama eni meni Yesu erinu giwa amira ge sewa niniwa me kaka wamu wenua amira nu nukare senenua. ");
INSERT INTO sue_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nu numorekare ego senua awa, “Nikare teya-taya wero zebu sero baro Oziga Ewanana erama dapikaragore seu gare. ");
INSERT INTO sue_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Zo nu Oziga Ewanana niniro na tuma diro ge ou gutamunoya, nu awa Anutu meni soero pumamunoya. Ata zo nu Oziga Ewanana niniro na tuma kaka diamu wamunoya, nu awa Anutu meni gera potai duwamunoya awa. ");
INSERT INTO sue_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Erama na tuma diamunora ami tani putoure ego ine wamunora: Nukare bi be nasora tunamunora; nukare ge ewe-pape gita kaka ninamu awa samunora; ");
INSERT INTO sue_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","nukare zi mai gamai awa ziro oko waya wamunora; nukare ou waya niro betai awa namunora, awa nukare yaya oko pumamunora; nukare wana nusokare ema yayare amira nana tame potara ewanana wamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tua Yesu meni bua mai nusore ge senu tepo wenu Anutu meni nu puro witiro poti utura ninu nu Anutura wana mera arumunua awa. ");
INSERT INTO sue_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ago wenu nukare teya-taya wero Oziga Ewanana so dapikaragora ena toisowa. Ago wasara Tua meni ge nusokare sogawai zewai waise sero nukare soremasai tani putoure inoisowa awa. ");
INSERT INTO sue_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O ema bamu Teofilo, gita ema saisai meni nena bamubamu nasokare nana soe kei awenua amira uge awa gaero baitamu sero wewa. ");
INSERT INTO sue_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Uge awa ema eni nukare nena awa giti moka nusokare meni zaawaira ena gosi-tupisowa ami Oziga Ewananara bua mai wero noise tugata wasara ninitinoisonakare awa. ");
INSERT INTO sue_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Are nane da ago ine uge awa nimore gaero baitamu kotupitinona. Nera kota, na nena bamubamu amira susu niniro baitamu sero atata dainiro inoe tamuna. ");
INSERT INTO sue_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Are ge nima gipewa amira ge me susure awa gasa me memeka waise sero uge awa gayamu sero inona. ");
INSERT INTO sue_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Be Herode meni Yuda emara ema tua wero noisonua be amire pris zo zazo nuso Zekaraya ami noisonua. Nu awa pris dubu zazo Abaisa amira zo. Ota bama nuso meni awa Aronra dubu amira zo. Zazo nuso Elisabet. ");
INSERT INTO sue_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nuto Anutu nana giti mokara ewanana noisowato awa. Nuto Tuara lo ge zere dago te ama ganinoisowato awa. Ota Anutura ge te dipinoisowato awa. Nusoto nana mou zo tepo. ");
INSERT INTO sue_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ata nuto mai tepo. Nera kota, Elisabet nu eronai. Noko nuto zai wewato. ");
INSERT INTO sue_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zekarayara dubu nukare bua waira be nusokare kei awenu giro Zekaraya nu Anutura nana giti mokara pris bua inoinu ");
INSERT INTO sue_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","nukare nu zama saira zame potai amira bua waise sewa so moka saramai pris meni Tuare zame potitinoisowa amira toinua awa. ");
INSERT INTO sue_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Be zame potaira bera ena ema bama dubu bamu ami ibu atune auniro begomo toise itiwa. ");
INSERT INTO sue_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ago inoiwa amire Zekaraya nu Anutura angelo zo zame potaira alta amira wana mera dopero itinu ginua awa. ");
INSERT INTO sue_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nu angelo giro titibi awero azu wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ata angelo meni ego senua awa, “Zekaraya, ni azu oko wase. Anutu meni isa niso ninitinowia. Bama niso Elisabet mai niso mata pumai giro ni zazo nuso Yohane aseyo. ");
INSERT INTO sue_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ago wero ni duba niso ewanana itai yawa sara wase. Nu kei awai ema bama dainiro ami dai yawa sara wamunora. ");
INSERT INTO sue_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nu awa Tuara nana giti mokara ema bamu wamunoya. Ota nu ou wain oko namunoya. Ota ou zewai-zawai dai oko namunoya. Be numa miera nana tinira itai amire Ozana meni nuso nana mokara topetiro bera mamunoya. ");
INSERT INTO sue_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Numa Isreli ema bama dainiro zumai kapeteniro bamu Tua nusokare Anutura nana niro nuamunora. ");
INSERT INTO sue_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nu Elia ine wero tani nusore putou nusore puro nuamunoya. Ago wero nu Tuara ebata gita wamunoya. Nu mamanara kotumai ziai zuzumeniro mai mamai kotumamunora. Nu ge dai ema awa korawai kotumai ewanana tamamunora. Ago wero ema sia wai Tua mamunoya awa dia itamunora.” ");
INSERT INTO sue_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Angelo ago senu Zekaraya meni angelore ego senua awa, “Na nogo nogo wero ge awa me niniro baitamunoni? Nama zai wai. Bama naso da ago zai wai.” ");
INSERT INTO sue_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ago senu angelo meni ge ina kapeteniro ego senua awa, “Na Gebriel. Na Anutura nana giti mokara dopinowea ami Anutu meni na ge ewanana awa nimore sanise sesi giro muro tona. ");
INSERT INTO sue_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Are ni ninase. Ni ge naso ninesa me kaka wamu inoya, are be niso gazaise. Ago wai ni ge sai ine tepo nuasa ge naso ei awa be nusora me wai amire ge noko samunosa.” ");
INSERT INTO sue_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Emare bamere nukare Zekaraya dia wewa eya kaka kei awamu wenu giro kotumai saisai puro sewa awa, “Ne kei aweti nu so moka saramai amira nimoi-namoi iti?” ");
INSERT INTO sue_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ama nu kei damu niro amire numorekare ge sai ine te kaka wamu wenua awa. Are nukare numa giwa awa numa moka saramaira ena nena putoure zo tamunua ago wenua awa. Numa ge numorekare samu awa wana meni gege senua awa. Ota be nuso meni awa gazero itinua. ");
INSERT INTO sue_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ama Zekaraya nu bua nuso tepo wenu doro nata nusora bamunua. ");
INSERT INTO sue_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Are ama bama nuso Elisabet nu wasou wenua awa. Ago wero inua wana da awa nu bezero itisonua awa. Nu ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Tua meni na zo amuro giro namore ago wetia awa. Awa na eronai nasora menai awa ema bamera nana benaura ena disanise sero wetia.” ");
INSERT INTO sue_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet nu wasou wenu inua 6 tepo wenu amire Anutu meni senu angelo Gebriel meni nata bamu zo Galilaya zebura itinua zazo nuso Nasarete amira bamunua. ");
INSERT INTO sue_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nata amira mai bama diri zo zazo nuso Maria, nu ema zo zazo nuso Yosefe, nu Dawidira saisibuna amira zo, awa ataise seroniwa noisonua. ");
INSERT INTO sue_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Are Gebriel meni nuso nana bamuro ego senua awa, “Tua koko. Anutu ni gawi ewanana inowia. Tua meni nimore dai itewia.” ");
INSERT INTO sue_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria nu ge awa niniro kotumai nuso mou-mau wenua awa. Duba nuso meni kotumuro, “ge nogo toi,” asenua awa. ");
INSERT INTO sue_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ago wenu angelo meni numore ego senua awa, “Maria, ni oko azu wase. Anutu meni ni gi ewanana inoya. ");
INSERT INTO sue_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sana niniyo. Ni wasou wero mai mata diri zo puro zazo nuso Yesu asamunosa. ");
INSERT INTO sue_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nu ema bamu wero nuamunoya. Nu Anutu ike itewia amira Mai me memeka asamunora awa. Anutu meni nu ema tua potai ewowo nuso Dawidi ine wero itamunoya. ");
INSERT INTO sue_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nu ami Yakobora saisibuna amira ema tua wero be giti itai gege itamunoya. Ota ema tua wero nuaira bua nuso meni awa oko tepo wamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Angelo ago senu Maria meni angelore ego senua awa, “Ago awa nogo kei awamunoi? Na ema zo kaka atamuwa.” ");
INSERT INTO sue_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ago senu angelo meni ge nuso ina kapeteniro ego senua awa, “Ozana meni niso nana kei awamunoya. Ago wai Anutu ike itewia amira putou nuso meni ni gogo wamunoya. Ami emo mai pamunosa awa nukare numore ego samunora, ‘Nu saramai. Nu Anutura Mai.’ ");
INSERT INTO sue_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Sana giyo. Mia niso kiaka Elisabet nu zai wai, ata nu wasou wero noi mai mata diri tinira itia. Gita nukare numore ego toisowa, ‘Nu mai pai ine te kaka wamu.’ Ata zeme nu wasou weti inua 6 tepo wataya. ");
INSERT INTO sue_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nena zo tepo Anutu meni wai ine tepo awa oko itia.” ");
INSERT INTO sue_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Are Maria meni ego senua awa, “Na Tuara bua bama, are tosa ago waise.” Ago senu angelo doro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Be amire Maria nu awita sero eriro Yudaya zebura baro nata zo dirumura itinua amira bamunua. ");
INSERT INTO sue_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ago baro Zekaraya nana so mokara toiro Elisabet areninua. ");
INSERT INTO sue_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ago wenu Elisabet nu Mariara arenai ninitinoinu Elisabet nana tinira mai itinua awa pasi wenua. Ago wenu Ozana meni Elisabet nana mokara bera munua. ");
INSERT INTO sue_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Are nu zawa toise ego senua awa, “Ni gawa bamure. Gawa niso meni bama enira gawa dainitinoya. Ata mai niso nana tinira itia awa dai gaware awa. ");
INSERT INTO sue_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na aka ewananaya ni Tua nasora mia ami naso nana tupesi? ");
INSERT INTO sue_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Dana naso meni arenai niso ninitinona amire naso nana tinira mai itia ami yawa sara wero pasi wetia. ");
INSERT INTO sue_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ge Tua meni nimore sisia amira me awa ama kei awamunoya asinowesa, are ni yawa sara inoise nowesa.” Elisabet meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Are Maria nu ego senua awa, “Na moka naso meni Tuara zazo puro wititinona. ");
INSERT INTO sue_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ota ititi naso meni awa yawa sara Anutu Soyai Ema nasore inoya. ");
INSERT INTO sue_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nera kota, nu na bua bama diri nuso osai awa kotupisia. Are zemeta ama ago awa ema bama dapikarago ami namore ego samunora awa, ‘Anutu meni bama awa gawa wenu yawa sara bamu wenua.’ ");
INSERT INTO sue_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gara ago wamunoya, nera kota, Anutu putou bamure meni namore nena bamu wisia. Zazo nuso saramai ami wisia awa. ");
INSERT INTO sue_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ara tamai nuso ema nuso nana osai itera amira nana itewia. Noko mai mamai nana dubura ago gege susawise itamunoya. ");
INSERT INTO sue_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nu wana nuso meni bua zewai-zawai wamunoya. Tama puro witai ema kotumai nusokarera tama puro wititinowera, nukare awa tunai teya-taya wero bozamunora. ");
INSERT INTO sue_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Anutu meni ema tua zewai-zawai amira putou nusokare puro osamunoya. Ago wero ema zazo tepore awa puro witamunoya. ");
INSERT INTO sue_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nu ema bogamasa amire nena ewa-gaewa potamunoya. Ago wero ema wau witaire nukare tunai wana zipero tepo bayamunora. ");
INSERT INTO sue_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nu awa-diai nuso itewia amira gege bua mai nuso Isreli dubu sorepitinoise nuamunoya. ");
INSERT INTO sue_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ago inoise nu apipie nasokaire senua awa te wamunoya. Awa Abraham ata saisibuna nusore senua awa.” ");
INSERT INTO sue_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria meni Elisabetre dai iteye donu inua etorobara tepo wenu amire nu doro nata nuso nana bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mai pumaira be munu Elisabet meni mai mata pumunua. ");
INSERT INTO sue_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nata da nuso ata didikai nuso oziga niniwa Tua meni nu soremunu giro nukare te dago numore dai yawa sara wewa. ");
INSERT INTO sue_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nu mai pumunu waiko be 8 tepo wenu amire nukare maira tama aiso kapamu auniwa awa. Nukare mama nuso Zekarayara zazo samu sewa, ");
INSERT INTO sue_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ata maira mia meni “Tepo” asero ego senua awa, “Nakai zazo nuso Yohane asamunonakai.” ");
INSERT INTO sue_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ago senu nukare numore ego sewa awa, “Imo mamai nisora zazo ago zo tepo awa.” ");
INSERT INTO sue_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nukare wana meni etete wero mama atata wewa awa, “Ni maira zazo awe samu kotupitinosi?” ");
INSERT INTO sue_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ago sewa nu tape zo maise wenu giro puro muwa ego gaenua awa, “Zazo nuso Yohane.” Ago wenu nukare kotumai saisai wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ago inuaise be nuso keenu ge senua awa. Are nu ge toise Anutu bowi wenua. ");
INSERT INTO sue_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Are nata da nuso nukare zere dago azu wewa. Are amira oziga meni Yudaya zebura dirumu ema amira nata sero baro tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ema saisai ami oziga awa niniro poti dube niwa awa. Ago wero ego sewa awa, “Ama mai ami nogo itamunoi?” Nukare giwa Tuara putou numore dai itinua. ");
INSERT INTO sue_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ozana meni mama nuso Zekaraya nana be munu nu porofete meni sago inoise ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nakai Isrelira Tua Anutu amira zazo nuso puro witanekai. Nu muro nakai ema bama nuso soremuro zuma gayamunoya. ");
INSERT INTO sue_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bua mai nuso Dawidi amira nana dubura ena Soyai Ema zewai-zawai zo nasokai nana soe potitinoya. ");
INSERT INTO sue_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nu ago wamu sero gita me gita porofete saramai nusore senu nukare be nusokare meni kereniwa. ");
INSERT INTO sue_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nu ego ine wamu sero kereninua: Nu nakai iwora wanera ena soero pumamunoya. Ata ema kotumai waya namorekai pupinowera amira nana wanera ena dai soero pumamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nu apipie nasokai soremamu senua. Nu tairo nuaira ge senua awa kotupitinoise giro ago wamu senua. ");
INSERT INTO sue_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tairo nuaira ge awa nu apie nasokai Abrahamre senua. Are nu tairo nuaira ge awa toise ego wamu senua: ");
INSERT INTO sue_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Nu nakai iwora wanera ena soyamunoya. Ago wai nakai be nuamunonakai awa te azu tepo nuso nana benaura noise be giti nuai ewanana noisekai tani saramaire ata tani ewananare numa sou inoise nuamunonakai. ");
INSERT INTO sue_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ota mai naso, nine meni awa erama meni nimore Anutu ike itewia amira porofete asamunora. Nima Tuara ebata sia wamu sero gita wamunosa. ");
INSERT INTO sue_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nima ema bama nuso tugata wasa nukare ego gamunora: Nu pasina nusokare disero nukare soero pumamunoya. ");
INSERT INTO sue_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Awa Anutu nasokai meni awa-diai nusora ago wamunoya. Nu ema zo utura waiko ine awa potai nasokai nana witamunoya. ");
INSERT INTO sue_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Muro ema betai azu inoise mumera itewera amira nana zasimamunoya. Nu nakai duba ewananare nuaira ebatara potamunoya.” Zekaraya meni ago sero tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mai Yohane awa kei awero baziro bamubake wenu kotumai nuso zazero ewanana wenua awa. Ago wero nu Isreli dubura nana benaura kei awai amira be nuso dia inoise zebu erama tepo amira noisonua awa. ");
INSERT INTO sue_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Zekarayara ara meni mai Yohane pumunua be amire Romara ema tua Sisa Ogastas nu lo zo potiro nukare ema bamera zazo te dago gayarise senua awa. ");
INSERT INTO sue_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Awa zaawero mena zazo gaewa awa. Are Sairinias nu Siria zebura ema tua wero itisonua be amire zazo gaewa awa. ");
INSERT INTO sue_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Are be awa ema bama zere dago nukare zazo nusokare gayamu nata susu nusokarera bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosefe nu Dawidira saisibuna amira zo, are nu Galilaya zebura nata Nasarete awa doro bamu Yudaya zebura niro Dawidira nata zazo Betelehem asinoisowa amira bamunua. ");
INSERT INTO sue_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nu bama seronai nuso Mariato bamuwato awa. Nuto zazo nusoto gayarise sero bamuwato awa. Ata Maria nu mou wai. ");
INSERT INTO sue_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nuto nata amira itiwato Maria mai pumaira be nuso munua. ");
INSERT INTO sue_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","So esewara awa ema bama meni puro tepo wero itiwa. Are nu mai nuso mata mua mai awa pumuro mo meni dowero poti bulimakao betawara ninu itinua. ");
INSERT INTO sue_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nata amira atune ema eni wo sipsip nusokare pire dia inoiwa, ");
INSERT INTO sue_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tuara angelo zo meni nusokare nana kei awenu Tuara zasimai bamu zasimunu nukare giro azu bamu wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ata angelo meni numorekare ego senua awa, “Nikare azu oko wawe. Sana niniu. Na Oziga Ewanana puro nisokare nana tupena. Oziga awa emare bamere dapikarago niniro yawa sara bamubake wamunora. ");
INSERT INTO sue_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Be emire Dawidira nate ena bama zo mai pumia. Mai ami nikare wayara ena soero pumamunoya. Nu awa Tua nisokare Kristo awa. ");
INSERT INTO sue_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ata nikare nu ego ewa gawa kei awamunoya: Nikare mai zo gamunowa, awa mo meni dowai. Nu bulimakao betawara duro itia.” ");
INSERT INTO sue_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Angelo nu ago toinu utura angelo dubu dainiro nukare eya kei awero itiwa ami numore dai Anutura zazo de ike nitinoise ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Utura ena Anutura zazo bamu waise. Zebura ena ema bama Anutu meni gawi ewanana inowera amira nana bega kei awinoya.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angelo dubu nukare doro ewesemuro bamu utura nitinoiwa wo sipsip dia wai ema nukare ego sewa awa, “Nakai Betelehem nate barokai nena kei aweti Tua meni namorekai gipetia awa ganekai.” ");
INSERT INTO sue_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nukare eya baro Mariato Yosefere itiwato giro mai uno bulimakao betawara duro itinu giwa awa. ");
INSERT INTO sue_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nukare mai giro mai unora ge giwa awa kereniro sewa awa. ");
INSERT INTO sue_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ge awa kereniro sewa ema dago wo sipsip dia wai emara ge awa niniro kotumai saisai wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ata Maria nu ge bamubamu awa dago duba nusora potinu itinu nu kotupitinoise noisonua awa. ");
INSERT INTO sue_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wo dia nukare ewesemuro baro Anutu bowi inoise zazo nuso de ike niwa. Nera kota, angelo meni ge senu giwa awa dago te maira nana ena giwa. ");
INSERT INTO sue_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ama waiko be 8 ago tepo wenu nukare maira tama aiso kapero zazo nuso Yesu asewa. Nu miera nana tinira ena kaka kei awamure angelo meni zazo awa senua. ");
INSERT INTO sue_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mia maire korawai saramariseto Mose meni lo ge potinu itisonua, are be nuso awa munu giro mama mia meni mai awa Tuara nana benaura potamu sero puro bamu Yerusalem niwato awa. ");
INSERT INTO sue_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Awa Tuara lo ge gayai ego itia amira te wewa: “Mai mata mua mai nukare miera nana tinira ena kei awara giro nukare awa Tuara gegenai awa.” ");
INSERT INTO sue_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Noko nuto Tuare zame potamu sero bamuwato. Awa Tuara lo ge sai ego itia amira te wewato: “Nikare miera zame potamu sero giro ni niu etota ni guma seka eto awa potiwo.” ");
INSERT INTO sue_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Are ema zo Yerusalem itisonua zazo nuso Simion. Nu ema ewanana, ata nu Tuara ge ninai ema. Nu Isreli emara Soyai Ema awa kei awai gamu dia itisonua. Are Ozana meni Simionra nana itisonua. ");
INSERT INTO sue_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ozana meni numore emoko ego senua awa, “Ni eya oko betamunosa. Tepo awa. Ni noma Anutura Soyai Ema zazo Kristo awa giro amire betamunosa.” ");
INSERT INTO sue_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Are Ozana meni nu awa-uzenu nu baro Anutura ibu bamura toiro itinu mia mama meni mai Yesu puro muwato awa. Awa nuto tani warise sai awa numore wamu puro muwato awa. ");
INSERT INTO sue_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Are Simion nu wana nuso meni mai awa puro Anutu bowi ego wenua awa, ");
INSERT INTO sue_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Tua, ni ge gita namore sesa awa me wetia, are sasa na bua mai niso duba ewananare betane. ");
INSERT INTO sue_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Giti moka naso meni nena nakare soero pumaise wesa awa gosinona. ");
INSERT INTO sue_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ni Soyai Ema ei awa sia wesa, awa ema bama dapikarago garise sero wesa. ");
INSERT INTO sue_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nu awa zasimai ine awa. Are nu ebata niso ema Yudakore gipamunoya. Ago wero Isreli dubu amira zazo de ike namunoya.” ");
INSERT INTO sue_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesura mia mama nuto Simion meni numore ge ago senua amira kotumai saisai wewato. ");
INSERT INTO sue_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Are Simion meni nukare gawa wero maira mia Maria amire ego senua awa, “Sana niniyo. Mai ei awa Isreli ema bama zaumaise sai itia awa. Are eni meni nu giro duro waya wamunora. Ota eni meni awa nu giro zewai wero dopamunora. Nu awa Anutura ebata gipai ema awa. Are ema witai meni numore ge waya-kawaya samunora. ");
INSERT INTO sue_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ago wara kotumai nusokare bezai awa kei damu namunoya awa. Noko duba nai bamubake niso nana kei awamunoya. Duba nai awa moka niso kasiwa meni gayai ago ine kei awamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Porofete bama zo itisonua zazo nuso Ana. Nu Fanuelra mai. Nu Ase dubura zo. Nu zai me zai. Nu gita ema atiro ema nusore dai zepa 7 noiwato ");
INSERT INTO sue_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ema nuso betenu nu imata itisonua. Are zeme zepa nuso 84. Are nu Anutura ibu bamu kaka duamu noisonua. Nu nena nai sieniro isa bua inoise itisonua. Are nu Anutura bua pi waiko zizinoise noisonua awa. ");
INSERT INTO sue_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Are be amire nu dai zorage muro kokopai Anuture senua. Ago wero nu mai amira ge awa ema Anutu meni Yuda ema bama noko soero pumaise sero dia inoisowa amire kereniro senua awa. ");
INSERT INTO sue_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nukare nena bamubamu Tuara ge meni warise sai itinua awa dago wewa tepo wenu ewesemuro Galilaya zebura baro Nasarete nata nusokarera kei awewa awa. ");
INSERT INTO sue_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ana mai baziro bamu wero mai putoure wenua awa. Ago wero nu kotumai ewa-gaewa saisaire wenu Anutura gawa nuso nana itisonua awa. ");
INSERT INTO sue_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesura mia mama nuto zepa sero pura bamu zazo Betai Daininua awa gamu sero Yerusalem nate wititinoisowato awa. ");
INSERT INTO sue_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Are Yesura zepa 12 ago tepo wenu giro nukare tani awa ama ganero pura be amire Yerusalem nate witiwa. ");
INSERT INTO sue_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ama pura bamura be tepo wenu nukare ewesemuro bamuwa awa. Ata mai Yesu nu Yerusalem ago dago itinua. Mia mama nuso meni nu itinua awa kaka gamu. ");
INSERT INTO sue_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nuto nu ema bama enire dai aita wetia ago sewato. Are waiko nuto aita weroto dubu nusotorata noko otao mamai nana ena tamamu wewato tepo wenu ");
INSERT INTO sue_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","kau wewato ata tepo. Ago wenu giro nuto nu tamamu sero ewesemuro Yerusalem bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nuto nu tamaira bua wewato waiko be etorobara ago tepo wenua. Ago wero amire ama meni awa nu ibu bamu du itinu tamuwato awa. Nu gipai emara nana soe arumuro itise ge ina-sa wero ninitinoise itiwa. ");
INSERT INTO sue_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ema ge nuso awa niniwa ami kotumai nusota ina-sa wai nuso amira titibi awewa. ");
INSERT INTO sue_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Are nuto nu giroto titibi awero baitiwato awa. Ago weroto amire mia nuso meni numore ego senua awa, “Bou, ni nogoro namoreto ago wetesa nato mamere duba nasoto mou-mau weti ni tamai bua inonito?” ");
INSERT INTO sue_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ago senu nu mia mamere ego senua awa, “Nito nera nama tamai bua inowito? Nama Mama nasora sora itanise sai itia, awa nito kaka gamu ni?” ");
INSERT INTO sue_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ago senu nuto ge amira susu kau wewato awa. ");
INSERT INTO sue_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ago wero nu numoreto dai ewesemuro baro Nasarete kei awewa. Ago wero ana be giti nu ge nusoto dipinoise noisonua awa. Are mia nuso meni ge awa dapikarago poti duba nusora ninu itisonua awa. ");
INSERT INTO sue_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu noe baziro ema bamu wenu kotumai nuso ewanana kei awero baitinua awa. Are Anutu ata ema nukare Yesu giwa ewanana wero baitinua awa. ");
INSERT INTO sue_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Zekarayara mai Yohane nu zebu erama tepo amira noinu Anutu meni ge numore sero numa buara potinua. Awa ema emi ema babezinoma wero noisowa amire ago wenua awa: Roma emara ema tua Taibirias nu ema tua wero noinu zepa 15 tepo wenua, be amire Pontias Pilao numa Yudaya zebura ema dia wero noinua; ota Herode nu Galilaya zebura ema dia wero noinua; ota nami nuso Filip nu zebu eto zazo nusoto Ituriato Trekonaitisre amira ema dia wero noinua; ota Anasito Kayafare nuto pris bamu wero noiwato, be amire Anutu meni Yohane buara potinua. ");
INSERT INTO sue_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Are Yohane meni bamu ou Yodan garawira niro ago noise ema bama ge tugata inoise noisonua. Ema bama meni utura ge niniro duba kapeteniro ge ou gutara Anutu meni pasina nusokare disaise ago toisonua awa. ");
INSERT INTO sue_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Awa porofete Yesaya meni ge buku nusora gaenu itewia amira te wenua, Zo nu ware gamu-gamura ena zawa sero arero ego toya awa, ‘Tuara ebata awa kora weu sonae. ");
INSERT INTO sue_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Agata dapikarago korawawa neine wae. Dirumu pama dapikarago gizawa osero neine wae. Ebata orosowai awa kora wawa sonae. Ebata kitio-kotio itia awa dai kora wawa neine wae. ");
INSERT INTO sue_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ago wawa erama dapikarago Anutura korawai bua awa gamunora.’ ");
INSERT INTO sue_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ema bama saisai meni Yohane nana kei awero nu nukare ge ou gutaise sewa giro numorekare ego senua awa, “Nikare zi waya amira mai. Ai meni sesi amire nikare Anutu ina potamunoya awa dainamu sero tama meni gege ge ou gutamu towi? Nane ago oko sesena. ");
INSERT INTO sue_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nikare duba kapeteniro amire tani duba kapetenaira me awa tamuu. Nikare nitopekare ge ego ine oko sawe, ‘Abraham nu mama nasokare, are Anutura ina ami nasokare nana oko mamunoya.’ Na nimorekare tona ewa. Anutu meni sai omata burara ami te Abrahamra saisibuna kei awamunora. Amira putou nuso nana itia. ");
INSERT INTO sue_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tuara ota emoko ni susura potai itia awa. Ni me ewanana kaka ziamu itara giro awa nukare dago kapero ape niaora namunora.” ");
INSERT INTO sue_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nu ago senu nukare dago nu atata wero sewa awa, “Are nakare nogo wamunonikare?” ");
INSERT INTO sue_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ago sewa nu numorekare ge ina ego senua awa, “Ema tama woi eto puro noya ami saineba zo poti ema tama woi tepo amire naise. Ema eni meni nena naire noma giro da ago warise.” ");
INSERT INTO sue_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ema eni takis pumai ema nukare dai ge ou gutaise sero nuso nana muro numore ego sewa awa, “Gipai ema, nakare nogo wamunonikare?” ");
INSERT INTO sue_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ago sewa numa numorekare ego senua awa, “Nikare takis gavman meni pawise toya awa te pumuwo. Ota nikare eni oko tepo pumawe.” ");
INSERT INTO sue_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ago senu soldia eni meni nu atata wero sewa awa, “Agoro nanekare meni awa nogo wamunonikare?” Ago sewa nu numorekare ego senua awa, “Nikare ema tebe-tabe oko dawe. Ota ge opi-api sero emara omata oko soyawe. Nikare zuma nisokare te pumuwo.” ");
INSERT INTO sue_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Erama dainiro meni “Yuda emara Soyai Ema zazo Kristo ami mamunoya,” ago toisowa. Are nukare Yohanera susu giro itazaita inoise ego sewa awa, “Nu awa Kristo nasokaita tepo ni?” ");
INSERT INTO sue_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Are amire Yohane ina numorekare ego senua awa, “Na nimorekare ge ou gutai gege potitinona. Ata ema zo ama mamunoya amira putou meni putou naso dainamunoya. Na ema osai me osai ami sandol nusora asi besai ine te oko inoya.* Nune meni awa Ozana nimorekare potamunoya, noko niao nimorekare potamunoya. ");
INSERT INTO sue_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nu sawol nuso wana nuso meni zizinoya. Puro muro wuit zasaira masira kei awero wowo bayaise sero wuit ape bisira namunoya. Wowo bayai wuit me awa sianiro poti sora namunoya. Ota wowo meni awa niao awinoise itai gege itai amira apamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohane nu kotumai nusokare awa-uzamu sero ge neire-neire toise Oziga Ewanana numorekare tugata inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Dia ema nusokare Herode nu nami nusora bama Herodia awa soero pumunua. Awa daba kota, nu pasina eni dai inoise noisonua, are Yohane meni nu senenua. ");
INSERT INTO sue_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Senenu giro Herode meni tani waya zo dai susumuro Yohane puro beniro benai sora potinua awa.* ");
INSERT INTO sue_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ema bama dago ge ou gutero itiwa Yesu dai ge ou gutenua. Nu ge ou gutero isa toise itinu utu zaumunu ");
INSERT INTO sue_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ozana ni guma ine wero ose nuso nana ninua. Ago wenu utura ena ge zo ego ine osenua, “Ni Mai naso. Ni wama naso. Na ni emo yawa sara inona.” ");
INSERT INTO sue_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu zepa nuso 30 amire bua nuso zaawenua. Ema bama nukare numore ego toisowa awa, “Nu Yosefera mai.” ");
INSERT INTO sue_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","38","Yosefe nu Hilaira mai, Hilai nu Matatira mai, Matati nu Lewira mai, Lewi nu Melikaira mai, Melikai nu Yanaira mai, Yanai nu Yosefera mai, Yosefe nu Matatayara mai, Matataya nu Amosira mai, Amosi nu Neamra mai, Neam nu Esilira mai, Esili nu Nagaira mai, Nagai nu Meatira mai, Meati nu Matatayara mai, Matataya nu Semenra mai, Semen nu Yosekera mai, Yoseke nu Yodara mai, Yoda nu Zoananra mai, Zoanan nu Resara mai, Resa nu Zerababora mai, Zerababo nu Siatielra mai, Siatiel nu Neraira mai, Nerai nu Melikaira mai, Melikai nu Adira mai, Adi nu Kosamra mai, Kosam nu Elimadamra mai, Elimadam nu Erera mai, Ere nu Yosuara mai, Yosua nu Eliesara mai, Eliesa nu Yorimra mai, Yorim nu Matatira mai, Matati nu Lewira mai, Lewi nu Simionra mai, Simion nu Yudara mai, Yuda nu Yosefera mai, Yosefe nu Yonamra mai, Yonam nu Elayakimra mai, Elayakim nu Meliara mai, Melia nu Menara mai, Mena nu Matatara mai, Matata nu Netanra mai, Netan nu Dawidira mai, Dawidi nu Zesira mai, Zesi nu Obedera mai, Obede nu Boasira mai, Boasi nu Salara mai, Sala nu Nasonra mai, Nason nu Aminadapra mai, Aminadap nu Adaminra mai, Adamin nu Anira mai, Ani nu Hesronra mai, Hesron nu Peresera mai, Perese nu Yudara mai, Yuda nu Yakobora mai, Yakobo nu Isakara mai, Isaka nu Abrahamra mai, Abraham nu Terara mai, Tera nu Nehorira mai, Nehori nu Serakra mai, Serak nu Riyura mai, Riyu nu Pelekra mai, Pelek nu Ibara mai, Iba nu Selara mai, Sela nu Kainanra mai, Kainan nu Apasatra mai, Apasat nu Semra mai, Sem nu Noara mai, Noa nu Lemekra mai, Lemek nu Metusalara mai, Metusala nu Inokra mai, Inok nu Yeretra mai, Yeret nu Mahalalilira mai, Mahalalili nu Kainanra mai, Kainan nu Inosira mai, Inosi nu Setira mai, Seti nu Adamra mai, Adam nu Anutura mai. ");
INSERT INTO sue_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ozana meni Yesura nana mokara be munu Yesu nu ou Yodan doro ewesemuro bamunua. Ozana meni nu puro zebu erama tepo amira bamunua. ");
INSERT INTO sue_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ago wenu nu be 40 ago noinu Satan meni nu etetenamu wenua. Be amire Yesu nena kaka namu noinua. Ama be awa dago tepo wenu amire Yesu meri betenua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Are Satan meni numore ego senua awa, “Ni Anutura Mai me wero noma giro sasa omata ami ma wai nase.” ");
INSERT INTO sue_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ago senu Yesu meni ge ina ego senua awa, “Ge gayai zo ego itia ewa, ‘Ma meni daba emara nuai oko dia inowia.’” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Are Satan meni nu puro witiro bamu ike niro amire nena zebu serora itera awa Yesure eya gipenua. ");
INSERT INTO sue_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Gipero numore ego senua awa, “Na putou ei awa dapikarago nimore potamunona. O zebu serora wau dai nimore potamunona. Nena bamubamu awa zere dago naso wenua. Are na mai zore potamu sero giro awa potamunona. ");
INSERT INTO sue_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Are ni naso nana bawa diro na bowi wasa giro amire nena dapikarago nimore potamunona.” ");
INSERT INTO sue_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ago senu Yesu meni ge ina ego senua awa, “Ge gayai zo ego itia ewa, ‘Ni Tua niso Anutu awa bowi wase. Nu daimata awa gege sou wamunosa.’” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Are Satan meni Yesu puro Yerusalem nate bamuro Anutura ibu bopu bamu amira ike potinua. Potiro numore ego senua awa, “Ni Anutura Mai me wero noma giro ena zokari awero ose. Ni oko waya wamunosa. ");
INSERT INTO sue_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nera kota, ge gayai zo ego itia ewa, ‘Anutu meni sai angelo dubu nuso meni ni dia wamunora. ");
INSERT INTO sue_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ago inoise te niso omata meni gayai azu, nukare ni wana meni soga inoise puro osamunora.’” ");
INSERT INTO sue_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ago senu Yesu meni ina ego senua awa, “Ge gayai zo ego itia ewa, ‘Ni Tua niso Anutu awa oko gaero gamu wase.’” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Are Satan nu etetenai dapikarago wenu tepo wenu giro nu Yesu doro be zo ago awa dia wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu nu Ozanara putou nuso nana itinua, are nu noko tera ewesemuro Galilaya zebura bamunua. Bamunu oziga nuso meni zebu amira baro te wenua. ");
INSERT INTO sue_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nu ema bama yere ibu nusokarera ena gipasai witai meni zazo nuso poti ike nitinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu meni Nasarete bamunua. Gita nu mai morua amire nu nata amira ana bazinua. Nu Sabat pura sero yere ibu mokara toitinoisonua, are Sabat pura zore toinua. Toiro Anutura ge azimamu sero benau nusokarera dopenua. ");
INSERT INTO sue_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Are nukare porofete Yesayara buku zo numore potiwa nu puro piaka niro ge gayai ego ine itinua awa tamuro kereniro azimunua awa, ");
INSERT INTO sue_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Tuara Ozana naso nana itia. Awa na ema bogamasare oziga ewanana sanise sero na buara potitinoise Ozana namore potisia. Na ego tugata wanise sero iyetinu muna awa: Nikare benai ema, na nikare besana benai doro bayamunowa. Nikare ema giti moka guma wai, na nikare kora wana noko giti panamunowa. Ema sou bua waya-kawayara nuasara sou wai bua meni nukare beninua amira mui besana doro bayarise, o ");
INSERT INTO sue_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Anutu meni erama kora wamunoya amira be potinu itewia awa kerenanise sero na iyetinu muna awa. ");
INSERT INTO sue_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu meni buku wotokuniro yere ibu dia wai emare potiro ge samu arumunua. Ago wenu ema bama ibu mokara itiwa ami nukare te dago iri nuso nana niro itiwa ");
INSERT INTO sue_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","nu zaawero numorekare ego senua awa, “Ge azimena ninewa amira me zeme kei awinoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Are nukare zazo nuso poti ike nitinoise kotumai saisai kotumuwa. Nera kota, nuso nana bera ena ge ewa-gaewa kei awenua. Are nukare numore ego sewa awa, “Nu Yosefera mai ami ge ago toya, atonua!” ");
INSERT INTO sue_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Are nune numorekare ego senua awa, “Nikare namore ego samunowi, tanita, ‘Dokta, ni nitope tama aiso niso kora we giro me asanekare. Tani eni Kapaneam ena wisesa awa nakare ninisenakare. Are ni zeme da ago ine nata susu nisora ena we ganekare.’ Namore ago samunowi, tanita.” ");
INSERT INTO sue_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ago sero senua awa, “Na me nimorekare tona awa. Porofete zo meni nata susu nusora ena ge sai oko ninamunora. ");
INSERT INTO sue_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ewowo-kawowo nisokare meni porofete Eliara ge kaka ninamu wewa. Are Anutu meni senu wa kaka osamu waiko gege inoinu zepa etorobara ata inua 6 ago tepo wenua. Be amire dora botiyo bamubake kei awenu bama kuma dainiro meni Isreli zebura noise nena nai kau inoisowa. ");
INSERT INTO sue_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ata Anutu nu Elia oko senu Isrelira bama kuma zora nana bamunua. Tepo awa. Nu numa iyetinu Saidon zebura baro nata Sarefat amira gege kei awenua awa. Awa bama kuma zora nana kei awero nu nena naira sorepitinoise itisonua. ");
INSERT INTO sue_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Noko da ago ine porofete Elisare wewa awa. Nu noisonua be amire ema boya ayare dainiro Isreli emara nana itisowa. Ata nu nusokare nana zo oko korawenu ewanana wenua. Tepo awa. Siria zebura ema zo zazo Neaman nu awa gege kora wenu ewanana wenua awa.” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ago senu ema yere ibu mokara itiwa nukare ami ge awa niniwa tini kapenua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tini kapenu nukare eriro Yesu saniro puro nata atune bamuwa awa. Nata nusokare awa dirumu zora ike itisonua awa. Are nukare nu puro bamu dirumu amira bera niro nu ape degara namu wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ata nu nusokare nana soe ena aita wero doro bamunu tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nu osero Galilaya zebura nata zo zazo nuso Kapaneam amira bamunua. Are nu Sabat pura amira ana ema bama gipenua. ");
INSERT INTO sue_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ago wenu nukare ge nuso niniro di tainiwa. Awa nera kota, ge nuso awa putoure. ");
INSERT INTO sue_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ema zo yere ibu du itinua awa bi meni nuso nana mokara itisonua. Nu zawa gatero ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ae, Yesu Nasarete natara ema, ni ne wamu sero nasokare nana tupesi? Ni nakare sisamu sero tupesi, tanita. Na susu niso gosinona. Ni Anutura Mai saramai.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ata Yesu meni nu seninoise ego senua awa, “Ni ge doro emara nana ena kei awero mu, bayase.” Ago senu bi meni ema awa apenu erama soe ena zebura duunua awa. Ata numa waya kaka wamu doro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ago wenu ema dapikarago ami di tainiwa awa. Ago wero nutopekare ego ina-sa wewa awa, “Ei awa ge neni? Nu ema putou bamure noise potai ge bire sesi ge nuso dimuro ema doro susawera.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Are Yesura oziga ami sumuro zebu amira nata sero bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu nu eriro yere ibu awa doro Simonra sora witinua. Simonra imeti-gagara awa yaya tama mena-mana bamu awa puro itinua awa. Are nukare Yesu zawa sero nu kora waise sewa awa. ");
INSERT INTO sue_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Are nu bamuro nuso nana zora dopero yaya awa senenua awa. Ago wenu yaya tepo wenua awa. Tepo wenu bama ami eya eriro nukare kora wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tua zizinoinu Sabat pura awa tepo wenu ema meni didikai nusokare yaya neire-neire puro itiwa awa puro mu nuso nana niwa awa. Ago wewa nu ema bama dago amira nana da da sero wana nuso meni nusokare nana gitine potiro nukare kora wenu ewanana wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ago wenu bi eni meni ema bama dainiro doro susawise ego sewa awa, “Ni Anutura Mai.” Ata nu nukare senero ge sai azu senua. Awa nera kota, nukare nu Yuda emara Soyai Ema zazo Kristo noinua awa giwa. ");
INSERT INTO sue_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pina gamu nu nata awa doro agewa zo erama tepo amira bamunua. Are ema bama meni nu tamamu sero nuso nana baro nu nukare duai azu sewa. ");
INSERT INTO sue_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ata nu numorekare ego senua awa, “Anutu imata Tua wero nuamunoya amira Oziga Ewanana awa na nata enira dai noise samunona. Anutu meni na bua awa wanise sero iyetinu muna awa.” ");
INSERT INTO sue_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Are nu Yuda emara yere ibu sero amira noise ge tugata wai bua inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Be zo Yesu meni ou ubu zazo Genesaret* amira kora dopenu ema bama witai meni Anutura ge ninamu nuso nana kei awero ina-musa wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Are nu wa eto ou ubura kora itiwato ginua awa. Ata ema wo pumai ema nukare wa eto awa doro mona sewai bua inoise itiwa. ");
INSERT INTO sue_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Are nu wa zora witinua, awa Simonra wa amira witinua awa. Are nu Simon senu wa isenu kora doro pei-kaka baro dopenu nu wa tame arumuro ema bama ge tugata wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nu ge sero tepo wero amire ama meni awa Simonre ego senua awa, “Nakai ou surura bayanakai amire nikare mona apero wo pumawe.” ");
INSERT INTO sue_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ago senu Simon meni ge ina ego senua awa, “Gipai ema, nakare pi emire dago wo pumai bua bamu inonakare pina atia, ata wo zo kaka pumamu wetenakare. Ata nine tosa giro sana mona apara dagimamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ago senu nukare ago wewa amire wo dainiro ikewa mona kapai sogo wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ago wenu giro nukare otao mamai nusokare wa zora itiwa ami muro nukare soremarise sero tawa dewa. Ago wewa nukare muro wo poti wa etora niwa be munu wa eto dago dagimamu wewato awa. ");
INSERT INTO sue_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ago wenu Simon Petoro nu awa giro Yesu nana tera zorage damu bawa diro ego senua awa, “O Tua, na ema waya, are ni na doro bamu.” Ago senua. ");
INSERT INTO sue_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nera kota, nu ata ema eni numore dai itiwa ami wo zere dago pumuwa wo awa giro azu wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedira mai mata eto Yakoboto Yohanere nuto Petorore dai wo bua inoisowato ami dai giro azu wewato awa. Are Yesu meni Petorore ego senua awa, “Ni azu oko wase. Ni zeme zaawero ema bama pumaira bua inoise nuamunosa.” ");
INSERT INTO sue_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ago senu nukare wa eto isewa witiwato nena bamubamu zere dago doro nu ama ganero bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nata zora ena ema zo itisonua. Nu boya aya witai meni tama aiso nuso waya wai. Are Yesu nata amira kei awero noinu ema ami Yesu giro nuso nana baro bawa diro koiniro ego senua awa, “Tua, ni putou niso itia, are ni na kora wamu wero giro kora wasa ewanana wamunona.” ");
INSERT INTO sue_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ago senu Yesu meni wana potiro nu kimuro ego senua awa, “Iyo, na ago wamu kotupitinona. Are boya niso tepo wai ni saramase.” Ago tuaise boya aya nuso eya tepo wewa. ");
INSERT INTO sue_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ago wenu Yesu meni ge zewai-zawai numore ego senua awa, “Tani nimore wetena amira bowi awa ema zore oko sase. Ni bamu, tama aiso niso prisre gipasa gae. Ago inoise nena Mose meni Anuture potawise senua awa potasa yaya niso tepo wetia amira susu giro baitamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ata Yesu meni tani eni inoisonua amira oziga awa so sero bamunua. Are ema witai meni nuso nana ena ge niamu serota yaya nusokare kora wai ewanana wamu sero nuso nana tupisowa. ");
INSERT INTO sue_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ata nu eyaya bamu so erama tepo amira niro begomo toisonua awa. ");
INSERT INTO sue_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Be zore nu ema bama gipinoise itinu amire Farisayore lo ge gipai ema enire nukare dai ago arumuro itiwa awa. Nukare awa Yerusalem nate enata Galilaya zebura nata serora enata Yudaya zebura nata serora ena muro itiwa. Ata Tuara putou yaya ema korawaira awa Yesura nana itinua. ");
INSERT INTO sue_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Are ema eni nukare ema zo gogara dimuro puro muwa awa. Ema amira wetu awa betero mapeta wai. Nukare nu dimuro puro so du bamuro Yesu nana zorage potamu wewa. ");
INSERT INTO sue_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ata ema bama witai meni so gazewa, are nukare ema yayare awa puro bamu so du naira eba kau wewa. Ago wero giro nu pumuro so ike witiro so ena be wero ema awa gogare dai puro potiwa osenua awa. Awa ema bama Yesure dai itiwa amira soe osero Yesura benaura kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Are Yesu meni tuma diai nusokare giro ema amire ego senua awa, “Otao, na pasina niso disesena tepo wetia.” ");
INSERT INTO sue_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ago senu lo ge gipai emare Farisayore nukare nutopekare ge saisai toise ina-sa wewa awa, “Ema emi Anutu meni wago inoya, atonua! Ema zo meni pasina disai ine tepo awa. Awa Anutura bua gege.” ");
INSERT INTO sue_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu nu kotumai nusokare ago ine awa enia wero giro ge nusokare ina ego senua awa, “Nikare nogoro ago kotupitinowi? ");
INSERT INTO sue_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nakai ema yayare amire, ‘Eri, aita wase,’ tepo ago sanakai nu kaka aita wamu wamunoya, awa nakai me namunonakai. Nera kota, ema bama meni ge nasokai gara opi wamunoya. Ata nakai, ‘Na pasina niso disinona,’ tepo ago samunonakai, awa nakai me oko namunonakai. Nera kota, ema bama meni ge nasokaira me awa gai ine tepo. ");
INSERT INTO sue_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Are na pasina disaira putou puro zebura nowena, awa gawise sero na ge ei awa dai numore samunona, ‘Na nimore ego tona: Ni eri, awai masi gogare niso puro niso nana bayase.’” ");
INSERT INTO sue_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ago tuaise nu ema bama amira nana giti mokara eriro awai masi gogare nuso puro Anutura zazo de ike nitinoise bamu so nusora ninua awa. ");
INSERT INTO sue_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ago wenu ema dago ami di tainiwa awa. Ago wero nukare azu wero Anutura zazo de ike nitinoise ge ego ina-sa wewa awa, “Nakai tani zeme gosinonakai awa benau zo.” ");
INSERT INTO sue_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ama Yesu meni doro aita wero susaumite iri niro takis pumai ema zo, nu takis pumaira sora arumuro itinua, awa ginua. Ema zazo nuso Lewi. Are Yesu meni numore ego senua awa, “Ni mu, na ama ganase.” ");
INSERT INTO sue_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ago senu nu eriro nena bamubamu dago itinua awa doro Yesu ama ganero bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi meni Yesu emo nena naira bua bamu zo so nusora ena wenua. Ago wenu takis pumai ema witai ata ema witai eni ami numore dai arumuro nena ninoise itiwa. ");
INSERT INTO sue_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ago itiwa Farisayo eni ata dubu nusokarera lo ge gipai ema eni ami Yesura bua maire ge witai toise ego sewa awa, “Ae, nikare nogoro takis pumai emare ata pasina emare dai nenare oure dara ninowi?” ");
INSERT INTO sue_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ago sewa Yesu meni ge nusokare ina kapeteniro ego senua awa, “Ema yaya tepore meni dokta nana oko susawewera. Ata ema yayare meni gege dokta nana susawewera. ");
INSERT INTO sue_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na ema nuai nuso saramai asinoya awa zawa sana duba kapetenarise oko muna. Tepo awa. Na pasina ema awa zawa sana duba kapetenarise muna awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Are nukare Yesure ego sewa awa, “Yohanera bua mai meni eyaya nena nai sieniro begomo toise nowera. Noko Farisayora bua mai meni da ago inowera awa. Ota bua mai niso meni awa nena kaka sienamu nai gege ninowera.” ");
INSERT INTO sue_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ago sewa Yesu meni numorekare ego senua awa, “Ema bama ataira bona inoise itara ema bama atamunoya ami numorekare dai nuamunoya be amire nena sienarise sawa ninamunorita? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ota ama ema awa iwo meni puro bayara tepo wamunoya be amire nukare nena sienamunora. Da ago ine namore wara amire bua mai naso meni nena sienamunora.” ");
INSERT INTO sue_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu nu ge bezai zo dai numorekare toise ego senua awa, “Ema meni tama sawai sekara osino mai zo kapero tama sawai matura toto awa gayai ine awa tepo awa. Ema zo meni ago wamunoya, awa tama sawai seka awa wai waya wamunoya. Ago wai mo sibi mai tama sawai sekara awa tama sawai mature te da oko wamunorato. ");
INSERT INTO sue_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Noko zo sana giwo. Ou wain seka awa ema meni memera tata matu amira dumai ine tepo awa. Ema zo meni ago wai, ou wain seka meni dobu wero memera tata ziai zasai ou wain zebura zozamunoya awa. Ago wai meme tata dai waya wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ema nu ou wain seka awa meme tata sekara daba dumaise. ");
INSERT INTO sue_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ema nu ou wain matu nisia ami ou wain seka amire oko ara tapinoya. Nu ago towia awa, ‘Matu meni awa nena naso ewanana.’” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat pura zore Yesu meni wuit bua zora soe aita wenua awa. Ago noinu bua mai nuso meni wuit me eni zisero pumuwa. Pumuro wana nusokare meni zasero niwa. ");
INSERT INTO sue_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ago inoiwa Farisayo eni meni giro ego sewa awa, “Sabat purare nena awa wai azu sai itia, awa nogoro inowi?” ");
INSERT INTO sue_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ago sewa Yesu meni ina ego senua awa, “Tani Dawidi meni wenua amira uge awa nikare kaka ninamu meni sago inowa, atonua! Na ego emira tona awa. Be zore nu ata dubu nusore meri betewa awa. ");
INSERT INTO sue_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ago wewa Dawidi meni Anutura ibura toiro ame Anutura giti mokara potitinoisowa awa puro ninua awa. Ame awa nukare ema osai meni nai ine tepo; pris meni gege narise sai awa. Ata Dawidi meni niro dubu nusore dai potinu niwa Anutu meni ginu waya oko wenua. Nikare uge awa kaka gamu ni?” ");
INSERT INTO sue_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ago sero susumuro numorekare ego senua awa, “Na Emara Mai meni Sabat pura amira Tua wero nowena.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat pura zore nu yere ibu zora toiro ema bama ge tugata wenua. Ata ema zo itinua, awa wana me nuso amai. ");
INSERT INTO sue_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Are lo ge gipai ema ata Farisayo dubu nukare Yesu gera potaira ebata tamamu sero nu uma wewa awa. “Nu ema yayare awa Sabat pura emire kora wamunoita tepo ni,” asero gamu dia itiwa awa. ");
INSERT INTO sue_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ata nu nutope kotumai nusokare ginua awa. Are nu ema wana nuso amai amire ego senua awa, “Ni mu, soe dopase.” Ago senu nu eriro dopenua awa. ");
INSERT INTO sue_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ago wenu Yesu meni numorekare ego senua awa, “Na nikare atata inona. Nakai tani ewanana Sabat purare wanakai te wamunoita tani waya wanakai te wamunoi? Ota nakai erama soremanakai kokopai wara te wamunoita ema sisanakai waya wara te wamunoi?” ");
INSERT INTO sue_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ago sero nu ema itiwa awa gina-gana wero ema amire ego senua awa, “Wana niso zuzuti!” Ago senu ema awa wana zuzutinu wana nuso noko ewanana wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ata nukare tini kapai bamubake tamuwa awa. Ago wero nutopekare sewa awa, “Nakai tani ne numore wamunonikai?” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Be amire Yesu meni isa samu dirumura witiro bamunua. Baro pi awa nu Anuture isa gege toise itinu pina atinua awa. ");
INSERT INTO sue_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pina atinu nu bua mai nuso zawa senu muwa nu nusokare nana eni 12 awa sianiro pumuro zazo nusokare aposolo asenua awa. ");
INSERT INTO sue_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Zo Simon, ata Yesu meni zazo Petoro numore senua awa; ota Anderea awa nu Simonra nami; ota Yakobo ata Yohane; ota Filip ata Batolomiu; ");
INSERT INTO sue_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ota Matiu ata Tomas; ota Yakobo awa nu Alifayora mai; ota Simon awa zazo nu Pugeu* asinoisowa; ");
INSERT INTO sue_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ota Yuda awa Yakobora mai; ota Yudas Iskeriot, nu ami ama Yesu kereniro iwora nana wanera potinua. ");
INSERT INTO sue_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Are Yesu numorekare dai dirumura ena osero baro zebu garawi zora kei awero bua mai nuso enire ema diti bamu amire dai dopero itiwa tamuwa. Awa ema bama witai-bake Yudaya zebura ata Yerusalem natara ata ewa bera nata eto Tayato Saidonre amira ana muro auniro itiwa tamuwa. ");
INSERT INTO sue_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nukare ge nuso ninamu serota nu yaya nusokare korawaise sero muro itiwa. Are eni bi meni mokara toyai awa Yesu meni kora wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ota ema bama dapikarago wana meni nu ziamu wewa. Awa nera kota, putou nuso meni emara nana semuro nukare dapikarago kora wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Are Yesu meni bua mai nuso ua inoise ego senua awa, “Nikare ema bogamasa, nikare ami yawa sara weu. Nikare Anutura nata amira gegenai. ");
INSERT INTO sue_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nikare ema zeme meri inowa, nikare ami yawa sara weu. Ama nena nai nawa denamunoya awa. Nikare ema zeme di toise itewa, nikare ami yawa sara weu. Ama nikare gewi ziamunowa. ");
INSERT INTO sue_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ama ema bama meni nikare gara na Emara Mai amira bua mai wawa nukare tini kapai nimorekare tamuro esenamunora, ota nimorekare ge waya samunora, ota zazo nisokare wara waya wamunoya, amira nikare yawa sara wamunowa. ");
INSERT INTO sue_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nimorekare ago wara giro nikare yawa sara inoise zokari-zokari wawa moka nisokare ewanana waise. Nera kota, zuma nisokare utura ena pumamunowa awa bamubake. Ema waya nimorekare wamunora amira ewowo nusokare meni gita da ago ine gege porofete emare inoisowa. Are nikare porofete emara te esa patitinoise nowewa. ");
INSERT INTO sue_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ota nikare wau ema, nikare temuwo! Nikare moka nisokare ewanana waira nena awa emoko pupisewa. ");
INSERT INTO sue_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ota nikare ema zeme nena nawewa deninowia ami temuwo! Ama nikare meri betamunowa awa. Ota nikare ema gewi zizinowewa ami temuwo! Ama nikare duba nitinoise di sawa diriu osamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ota ema dapikarago meni zazo nisokare puro witamunora, awa nikare temuwo! Gita ewowo nusokare meni porofete opi saire da ago inoisowa awa. Are nimorekare ago sara nikare porofete opi sai amira te esa patitinoise nuanowa awa. ");
INSERT INTO sue_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ota nikare ge naso ninitinowa nimorekare ego sana niniu. Nikare iwo nisokarere dubara dumi pumuwo. Nikare tani kokopai ema tini kapai nimorekare puro nora amire wewo. ");
INSERT INTO sue_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ema waru ge nimorekare samunora, awa ina gawa ge numorekare sewo. Ota ema nimorekare waya wamunora, awa ina nukare soremuro isa sewo. ");
INSERT INTO sue_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ota ema zo meni ni sowene dai giro ni zuzumeniro sowa eniba nuso nana potiyo dae. Ota ema zo meni mo tama sawai niso pumai giro tama woi durura dai potiyo pumae. ");
INSERT INTO sue_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ota ema zo meni nena niso zo emo isa sai giro potiyo pumae. Ota ema zo meni nena niso pumai giro ina potaira oko sase. ");
INSERT INTO sue_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nikare tani erama meni nimorekare warise yaba inowewa te ago ine numorekare wewo. ");
INSERT INTO sue_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ota nikare ema dubara dumi nimorekare pupinowera amire ina dubara dumi pumawa nikare bowi wanora? Pasina ema nukare dai ema numorekare dubara dumi pupinowera amira ina dubara dumi pupinowera awa. ");
INSERT INTO sue_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ota ema tani kokopai nimorekare inowera amire ina tani kokopai wawa nikare bowi wanora? Pasina ema nukare dai tani ago ine inowera awa. ");
INSERT INTO sue_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ota nikare ema enire nena eni potiro noko tera ina nimorekare potarise kotumawa nikare bowi wanora? Pasina ema nukare dai pasina ema enire nena potiro noko nena da awa tera pupinowera awa. ");
INSERT INTO sue_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ata nikare meni awa iwo nisokarere dubara dumi pumuwo. Nikare tani ewanana numorekare wewo. Nikare nena eni numorekare potiro ina nena zo paira oko kotumawe. Nikare ago inoise noma ama zuma bamubake pamunowa awa. Ago wero ama nikare Anutu ike damu itewia amira mai me wamunowa awa. Ema eni numore kokopai kaka samu inowera, ata eni meni waya inoise nowera. Ata saineba, nu numorekare bayao inowia. ");
INSERT INTO sue_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nikare zo amai Mama nisokare meni inowia ago ine wewo. ");
INSERT INTO sue_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nikare zas meni wago wero ema eni oko gera potawe. Ago kaka wamu wamunowa, awa Anutu meni nikare oko gera potamunoya. Nikare zas meni wago wero mou ema enire oko potawe. Ago kaka wamu wamunowa, awa Anutu meni mou nimorekare oko potamunoya. Nikare ema enira pasina gagare duawa Anutu da ago ine pasina nisokare duamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nikare nena ema enire potawa giro Anutu meni nena nimorekare potamunoya. Nu nena nimorekare nigai be kasaba dero zozai pumamunowa. Nikare nena eramare potamunowa te Anutu meni nimorekare potamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu meni ge bezai zo numorekare toise ego senua awa, “Ema zo giti moka guma wai ami ema zo giti moka guma wai amire ebata gipai te wamunoita? Tepo awa. Nuto eto dago degara duwamunorato awa. ");
INSERT INTO sue_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ninai mai zo meni gipai mama nuso dainai ine oko itia. Nu ninai gita niniro amire gipai mama nuso ine wamunoya awa. Are ninai mai niso meni ni kaka dainamu wai giro nu gera oko potase. ");
INSERT INTO sue_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ni nogo wero otao niso nana giti mokara wowo itia awa gosinoise niso nana giti mokara ni pena itia awa kaka giro baitamu inosi? ");
INSERT INTO sue_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ni pena niso nana giti mokara itia awa ni kaka gamu inoise otao nisore ego sasa te wanoi? ‘Otao, niso nana giti mokara wowo itia awa pumane.’ Opi ema, ni nitope niso nana giti mokara ni pena itia awa gita pumuro amire giro baititinoise otao niso nana giti mokara wowo itia awa pumasa te wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ni ewanana meni me waya oko ziamunoya. Da ago ine ni waya meni me ewanana oko ziamunoya. ");
INSERT INTO sue_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ema nukare gita ni me giro amire ni wayata kokopai ni, awa gosinowera awa. Nakai sawase awa asi dirinare amira ena oko ziro itai tekamunonakai. Noko goawa awa nibara ena oko ziro itai uzamunonakai. ");
INSERT INTO sue_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ema kokopai awa kotumai kokopai nuso nana mokara itewia, are nu tani kokopai inowia. Ema waya awa nu kotumai waya-kawaya nuso nana mokara itewia, are nu tani waya-kawaya inowia. Duba meni denenu itewia amira te be meni kereniro towia awa. ");
INSERT INTO sue_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nikare nogoro begiti meni gege namore, ‘Tua naso, Tua naso,’ asinoise ge towena awa kaka dimamu inowewi? ");
INSERT INTO sue_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Zo nu naso nana muro ge naso niniro dimamunoya, susu nuso awa ema zore potiro sana niniu. ");
INSERT INTO sue_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ema awa nu ema zo so wenua ago ine awa. Nu gita ura me wamuro zasiwi potiro susu gaenu zewai wenu amire so potinu dopenua awa. Ama ou wama munu ou sumuro muro so awa kaka musunamu wenua. Nera kota, ema awa so ewanana wenua. ");
INSERT INTO sue_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ata ema ge naso niniro kaka dimamu inowia awa numa ema zo so zebura tame potiro wenua ago ine awa. Nu gita ura me kaka wamamu. Nu so amira zasiwi tame dorou wero wenua. Are ama ou wama sumuro muro so awa denu eya gowero duro sisero tepo wenua awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu meni ge awa ema bamere senu tepo wenu noko bamu Kapaneam nate ninua. ");
INSERT INTO sue_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Soldia 100 amira kapten zo awa ago itinua. Soumai nuso zo awa ginu kokopai wenua ami be amire yaya puro betamu inoise itinua. ");
INSERT INTO sue_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kapten meni Yesu itinua amira ge niniro giro Yuda emara giti kopi eni potinu baro Yesu nana ena nu zawa sero ego sewa awa, “Kapten meni ni baro soumai nuso kora wasise toya.” ");
INSERT INTO sue_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ago sero nukare Yesure ge pena-pana toise ego sewa awa, “Kapten awa nu kapten eni ine oko aewa. Nu kapten neine. Are ni soumai nuso korawasa te wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nu namorekai Yudare moka ewanana inowia. Nu nutope gita yere ibu nasokai zo wenua.” ");
INSERT INTO sue_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ago sewa giro Yesu meni numorekare dai bamunua. Baro kei sora zorage ninu amire kapten ami otao mamai enire ge senu puro bamuro ego sewa awa, “Tua, saineba, ni bua bamu oko wase. Na ema ewanana tepo, are ni so moka nasora toyasa te oko wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Noko na ema ewanana tepo ami niso nana zorage mana te oko wamunoya. Ata ni ago itise ge gege sasa soumai naso ewanana wamunoya, awa gosinona. ");
INSERT INTO sue_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nera kota, na ema giti kopira ama-zani nowena. Noko soldia dubu eni meni naso nana ama-zani nowera. Are nane nusokare nana zo bayaise sana bayamunoya. Ota zo maise sana mamunoya. Ota na soumai naso bua waise sana wamunoya. Are na putou nisora susu gena kei awinoya. Are ge gege sasa soumai naso ewanana wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ago senu Yesu meni ge awa niniro di tainiro zuzumeniro ema bama dubu bamu nu ama ganinoiwa amire ego senua awa, “Na nimorekare sane. Na Isreli ema nisokare nana ema tuma diai ego inere zo oko tapisena.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Are ema kaptenra ge puro muwa nukare ami noko bamu sora niro soumai awa ewanana wero itinu giwa awa. ");
INSERT INTO sue_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesu meni nomite nata zo zazo nuso Nen amira bamunua. Bua mai nuso ata ema bama dubu bamu ami numore dai bamuwa. ");
INSERT INTO sue_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Are numa bamuro natara goma amira toyai be bamu amira zorage kei awinoinu nukare mai betai zo puro bi ditira bayamu muwa. Mai betai amira mia awa mai da gege awa. Iu uso dai emoko betenua. Are nata amira ema bama witai eriro bama amire dai muwa. ");
INSERT INTO sue_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tua nu bama awa giro numore zo amunua, are nu bama amire ego senua awa, “Ni di oko sase.” ");
INSERT INTO sue_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ago sero nu zora baro wana goga tame potinu ema mai gogara dipinoiwa ami dopewa awa. Ago wewa Yesu meni ego senua awa, “Bou, ni erasise tona.” ");
INSERT INTO sue_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ago senu mai betai awa eriro arumuro ge senua. Ago wenu Yesu meni puro mia nusore potinua awa. ");
INSERT INTO sue_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ago wenu ema bama witai ami azu inoise Anutura zazo de ike niwa. Ago inoise ego sewa awa, “Nasokai nana soe ena porofete zo kei awetia.” Ago toise sewa awa, “Anutu dubu nuso soremamu kei awetia.” ");
INSERT INTO sue_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ago sewa Yesura oziga ami Yudaya zeburata zebu enira nana baro te wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohanera bua mai meni Yesura oziga numore sewa. ");
INSERT INTO sue_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Are Yohane meni bua mai nuso eto zawa senu muwato nuto ge zo puro Tuara nana bayariseto senua. Baro ego sariseto senua awa, “Agoro Kristo maise sai awa ni awanita, ota zo mai gamu dia wamunonikare?” ");
INSERT INTO sue_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ago senu ema eto awa baro Yesu nana kei aweroto ego sewato awa, “Yohane ge ou gutai zaawai ema ami nato sesi niso nana tupenato. Nato ni ego atata waniseto sesia, ‘Agoro Kristo maise sai awa ni awanita, ota zo mai gamu dia wamunonikare?’” Ago sewato awa. ");
INSERT INTO sue_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Are be amire Yesu meni ema bama dainiro amira yaya eure-taure awa kora wenua, ota bi mokara itai awa tunenua, ota giti guma wai awa kora wenu giti panewa awa. ");
INSERT INTO sue_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Are Yesu meni ge numoreto ina ego senua awa, “Nito ewesemuro baro nena zeme gosinowato, o ge ninitinowato awa Yohanere seuto ninae. Giti guma wai awa giti paninora; te waya wai awa noko aita inora; ema boya ayare awa tama ewanana inora; dana azai awa ge ninitinora; bebetenai awa seka ziro eritinora; ota bogamasa awa Oziga Ewanana ninitinora. ");
INSERT INTO sue_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Zo nu namore gai mou kaka wamu wamunoya ami yawa sara wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ema eto Yohanera ge puro muwato nuto ami noko tera ewesemuro bamuwato amire Yesu meni ema bama diti bamu amire Yohanera uge wenua. Ago inoise senua awa, “Nikare gita Yohane gamu sero zebu erama tepo amira bamisewa, awa nikare ema nogo wai gamu bamisewi? Nikare ema beyata zo bisi meni seba apawi muro baro awinowia ago ine awa gamu bamisewita? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nikare nena ne gamu bamisewi? Nikare ema zo tama woi ewananare noisia awa gamu bamisewita? Tepo awa. Erama nena sekare sekare inowera, o tamara nena ewa-gaewa pupinowera, erama ago ine awa nukare ema tuara nana sora itewera awa. ");
INSERT INTO sue_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ata nikare ne gamu bamisewi? Nikare porofete zo gamu bamisewita? Iyo. Nikare porofete zo gamu bamisewa. Are na nimorekare me sane. Nu awa porofete awa, ata nune porofete noisowa awa dainitinoya. ");
INSERT INTO sue_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Are ema amire ge gayai zo ego itia awa, Ei giu. Na oziga sai ema naso iyetamunona. Nu gita wero ebata niso kora wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na nimorekare sane. Yohane meni zebura ema dapikarago dainitinoya. Ata Anutura nata gegenai zo osai me osai ami Yohane dainitinoya awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ema bama dapikarago ata takis pumai ema nukare ge awa niniro ego sewa awa, “Iyo, Anutura tani awa me awa.” Ago sewa nera kota, gita Yohane meni nukare ge ou gutenua. ");
INSERT INTO sue_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ata Farisayo ata lo ge gipai ema nukare awa Yohane meni kaka ge ou gutamu, are nukare Anutu meni ebata nuarise senua awa azu sero dowa. ");
INSERT INTO sue_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Are Yesu meni ego senua awa, “Are na ema bama zeme nowewa awa nena nera potiro sana te wamunoi? Nikare ema nogo wai ni? ");
INSERT INTO sue_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nikare tani mai pei-mamaira ine inowewa. Mai pei-mamai nate kakame arumuro itise mai pei-mamai eni zawa sero ego tora awa, ‘Nakai ozina wamu nikare uzumuro boi detenakare, ata nikare yawa kaka wiamu wetewa. Noko nakare zo amira dibia wetenakare, ata nikare dibia kaka wamu wetewa. Are nakare nogo wanakare gawa ewanana wamunoi?’ Ago tora awa. ");
INSERT INTO sue_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Agoro Yohane ge ou gutai zaawai ema ami bua nuso zaawero nena nai eni sienitinoise ou wain dai sienitinoise nuawi giro numore ego towewa awa, ‘Bi nuso nana mokara itia.’ ");
INSERT INTO sue_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Are na Emara Mai meni kei awero nena nise ou nise awawena giro namore ego towewa awa, ‘Giu. Nu ono nai ema. Nu ou wain pena-pana ninowia. Nu takis pumai ema ata Yudara lo ge dai ema amira otao.’ Nikare namore ago towewa. ");
INSERT INTO sue_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ata nato bua inowenato awa Anutura kotumaira inowenato amira susu awa bua nasotora me meni kerenawi ema bama gawera me inowia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Are Farisayo zo meni Yesu nena naise sero so nusora uzumunu baro witiro nena namu arumuro itinua awa. Ago itinu ");
INSERT INTO sue_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","pasina bama zo nata amira itisonua ami ge bowi Yesu Farisayora nana sora ena nena ninoise itinua awa nininua. Are bama ami boto omata meni wai ou zama bamure awa puro munua awa. ");
INSERT INTO sue_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ago wero baro Yesu nana tera dopero di toise itinu diriu meni Yesura te gutenua. Ago wenu giti tu nuso meni gaenu touwenu te nuso imunua awa. Ago wero ou zama bamure ami Yesura te gutenua awa. ");
INSERT INTO sue_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Are Farisayo awa zazo nuso Simon, nu Yesu uzumunu munua ami tani awa giro ego kotumunua awa, “Ema awa nu porofete me nuami sia, awa nu bama ami nu kipinoya amira susu gamia. Nu awa pasina bama awa gamia.” ");
INSERT INTO sue_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ema ago kotupitinoinu giro Yesu meni numore ego senua awa, “Simon, na ge zo nimore samu kotupitinona.” Ago senu Simon meni ego senua awa, “Gipai ema, ni ge niso se ninane.” ");
INSERT INTO sue_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ago senu Yesu meni ego senua awa, “Mai eto nuto dinau ema zora nana wiserato awa. Zo meni 100 kina dinau wisia, ota zo meni awa 10 kina gege dinau wisia. ");
INSERT INTO sue_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nuto dinau awa ina potai ine awa te kaka wamu wisia. Are ema awa dinau nusoto eto dago awa dotisia. Are nusoto nana na-ami numore moka ewanana wamunoi?” ");
INSERT INTO sue_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ago senu Simon meni ge nuso amira ina ego senua awa, “Ema awa dinau nuso bamu dotisia nu ami wamunoi, tanita.” Ago senu Yesu meni numore ego senua awa, “Ni ewanana kotumesa.” ");
INSERT INTO sue_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ago sero nu iri bama amira nana niro Simonre ego senua awa, “Ni bama ei awa gi. Na so moka nisora mena ni te sewaira tani nasokai awa doro te sewaira ou namore kaka potamu wetesa. Ata bama emi meni awa te naso diriu nuso ami sewetia awa. Ago wero giti tu nuso meni gaeti touwetia awa. ");
INSERT INTO sue_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na niso nana mena ni na wana kaka ziamu wetesa awa. Ata bama emi meni awa be na toiro mena ana zaawero te naso imai gege ipinoise itia ewa. ");
INSERT INTO sue_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni giti tu naso kaka gawi meni gutamu wetesa awa. Ata bama emi meni awa te naso gawi zamare meni gutetia. ");
INSERT INTO sue_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Are na nimore sane. Pasina nuso witai-bake disesena tepo wetia, ami emo nu namore zo amai bamubake tamuro na kora wetia. Ota zo nu pasina nuso pei-kaka gege disana nu ina namore zo amai pei-kaka gege tamamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu meni ago sero bamere ego senua awa, “Na pasina niso disesena awa.” ");
INSERT INTO sue_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ago senu giro erama numore dai nena ninoise itiwa ami nukare nutopekare ina-sa inoise ego sewa awa, “Agoro ema awa nu nogo wai meni pasina disinoi?” ");
INSERT INTO sue_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ago sewa, ata Yesu meni bama amire ego senua awa, “Tuma diai nisora kokopai wetesa. Are ni duba ewananare bamuyo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ama Yesu meni nata babezinomare pei-mamaire zipinoise Anutu imata Tua wero nuamunoya amira ge tugata inoise noisonua awa. Ana bua mai 12 numore dai noisowa. ");
INSERT INTO sue_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ota bama eni gita Yesu meni bi nusokare nana ena tunenua ata yaya waya nusokare nana ena kora wenua nukare ami numore dai noisowa awa. Nusokare nana zo awa Maria. Nukare nu Maria Madala natera asinoisowa. Gita Yesu meni bi 7 nuso nana ena tunenua. ");
INSERT INTO sue_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ata bama Yoana awa nu Kusara bama. Iu nuso meni Herodera so dia inoisonua. Ota bama zo zazo nuso Susana, ata bama eni numore dai noise Yesu bua mai nusore awa wau nusokare meni sorepitinoise noisowa awa. ");
INSERT INTO sue_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ema bama dubu bamu nukare Yesura nana kokouniwa ema bama nata serora ami Yesu nana muwa giro nu ge bezai zo numorekare toise ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ema zo meni nena we buye ena apamu sero bamunua. Baro nena we apitinoinu we eni ebete duuwa awa. Ebete duuwa erama meni te meni patiwa, noko eni awa ni mamai meni tamuro niro tepo wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ota we eni meni awa agewa omata itinua amira tame duuwa. Duro eriwa, ata zebu awa ou tepo, are nena awa binero betenua awa. ");
INSERT INTO sue_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ota we eni meni awa iwera tatawi itiwa amira duuwa awa. We awa iwere dai dapikarago te-tetemo eriro iwe meni nena awa denu me kaka ziamu wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ota we eni meni awa zebu me gawire amira duro eriro zamuro me witai ziwa awa.” Yesu meni ago sero tepo wero zawa sero ego senua awa, “Are zo nu danare meni ge ei awa ninaise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bua mai nuso nukare nu ge bezai amira susu kerenaise sewa giro ");
INSERT INTO sue_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","nu ego senua awa, “Anutu imata Tua wero nuamunoya amira ge bezero itewia amira susu awa nikare ninawise sai itia awa. Ata eni bamu awa ge bezaira uge gege ninarise sero towena. Are giti moka nusokare meni garise, ata oko giro baitarise. Nukare uge gege ninarise, ata nukare ugera susu oko niniro baitarise. ");
INSERT INTO sue_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ge bezai amira susu awa ego ewa: Nena we awa Anutura ge awa. ");
INSERT INTO sue_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ota we eni ebete duuwa amira susu awa ego ewa: Ema nukare ge ninitinowera, ata Satan meni muro nukare ge awa niniro Anutu tuma diara nu nukare soero pumai azu nu ge awa nusokare nana kotumaira ena soero pupinowia. ");
INSERT INTO sue_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ota we eni zebu agewa omatare amira duuwa amira susu awa ego ewa: Ema nukare utura ge niniro dube potiro yawa sara inowera, ata nukare tatawi tepo. Nukare tuma diaire nuawera gaero gamu wai zo kei awawi amire nukare tuma diai nusokare besinowera. ");
INSERT INTO sue_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ota we eni iwe soe duuwa amira susu awa ego ewa: Ema nukare ge ninitinowera, ata nukare zebura nena emo kotumu-katumu inoise wau moni emo yawa sara inoise nena eure-taure ami emo duba-duba inoise nuawera nena ami nukare dimawi me nusokare oko kei awero bamu inowia. ");
INSERT INTO sue_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ota we eni zebu mera duuwa amira susu awa ego ewa: Ema nukare ge niniro duba nusokare koko-kakopai amira potiro ziro baititinoise zewai-zawai inoise me tapinowera awa. ");
INSERT INTO sue_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ema nakai lam gaero au sose piero oko potitinowenakai. Noko nakai lam poti beti du oko nitinowenakai. Tepo awa. Nakai poti gabarira nitinowenakai. Awa ema nukare muro so duru toiro zasimai garise sero ago inowenakai. ");
INSERT INTO sue_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nena bezai dapikarago ama kei damu namunora. Ota nena dowai dapikarago kei awe damu nara ema meni gamunora awa. ");
INSERT INTO sue_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nikare ge ninamu sero giro giro baitiro niniwo. Ota ema zo nu ge me puro nuamunoya, awa Anutu meni ge me bamubake numore potamunoya. Ota ema zo nu ge me kaka puro nuamu inoise ‘ge me naso nana itia,’ asamunoya, awa Anutu meni ge me nuso nana ena soero pumamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Be amire Yesura mia namisinire nukare nuso nana muwa. Ata ema bama witai itiwa, are nukare nuso nana zorage mai ine te kaka wamu wenua. ");
INSERT INTO sue_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Are ema eni meni numore ego sewa awa, “Mia niso namisinire nukare ni gamu sero muro atune dopero itera.” ");
INSERT INTO sue_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ago sewa nu ge nusokare ina ego senua awa, “Ema bama Anutura ge niniro dipinowera ami mia naso ata namisini naso inora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Be zore Yesu bua mai nusore wa zora witiro nu numorekare ego senua awa, “Nakai ou ubu semuro enibara bayanekai.” Ago sero semuro bamuwa. ");
INSERT INTO sue_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Susauwa Yesu nu gitawa inoinu bisi bamu zo dirumura ena ose ou ubura niro kakaware dai munua. Ago wenu wa kukunamu inoinu nukare kapo sisewa awa. ");
INSERT INTO sue_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Are nukare baro Yesu awa-uzero numore ego sewa awa, “Gipai ema, gipai ema, nakai sisamu inonakai!” Ago sewa nu eriro bisire kakawa bamu awa senenua. Senenu bisire kakawa bamure awa binono denua awa. Ago wenu ou awa pasi tepo me tepo wenua. ");
INSERT INTO sue_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Are nu numorekare ego senua awa, “Nikare nogoro tuma diai besinowi?” Ago senu nukare azu wero kotumai para-para wewa. Ago wero nutopekare ge ina-sa wero sewa awa, “Ema ei awa nogo wai ni? Nu bisire kakaware ge sesi ge nuso dipinorato, atonua!” ");
INSERT INTO sue_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu bua mai nusore meni ou ubu semuro Gegesa zebura kei awewa. Ou ubu awa Galilaya zebu enibara itawi, Gegesa zebu enibara ago itewerato. ");
INSERT INTO sue_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Yesu nu wa doro witi ete nitinoinu ema zo nata amira ami nuso nana munua. Bi eni ema amira nana mokara itiwa. Gita omire bi ami ema awa eyaya darau nitinoisowa. Ema eni nukare ema waya awa dia inoise sen meni benise hankap potise awinoisowa. Ago wasara numa eriro nena bamubamu awa ziasai kapasai bi ami numa puro bamu zebu agewa erama tepo amira nitinoisowa. Nu mo kaka awamu noisonua. Nu so mera kaka awamu. Nu bi ditira itima awinoisonua. Are ema ami Yesu giro zawa gatero baro Yesu nana tera ena zebura duunua. Duro zawa ike damu gatinoise ego senua awa, “Yesu, ni Anutu ike itewia amira Mai me nowesa ami namore ne wamu tupesi? Ni yaya bua namore oko potase.” Ago senua, nera kota, Yesu meni emoko bi awa ema doro bayarise senua awa. ");
INSERT INTO sue_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Are Yesu meni nu atata wero senua awa, “Zazo ni aweni?” Ago senu nu ego senua awa, “Zazo naso Dubu Bamu.” Ago senua, nera kota, bi dainiro meni gita nuso nana toiro itisowa awa. ");
INSERT INTO sue_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ago senu bi nukare begomo toise zawa gatero Yesure ego sewa awa, “Nakare dega niaore amira bayanisekare sero oko tunase.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pu dubu bamu dirumu demabera nena ninoise noiwa, are bi nukare Yesure ego sewa awa, “Ni ninasa nakare baro pu dubu bamu omira nana toyanekare.” Ago sewa Yesu meni ge nusokare nininua awa. ");
INSERT INTO sue_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Are bi nukare ema awa doro baro pura nana mokara toiwa pu dubu awa pena-pana sumuro degara baro ou ubura dagimuro ou niro betewa awa. ");
INSERT INTO sue_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ago wewa pu dia nukare nena awa giro azu sumuro baro ge awa kereniro ema bama nata bamurata agewa enira amire sewa awa. ");
INSERT INTO sue_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ago wewa giro ema bama nukare tani awa gamu sero bamuwa. Baro Yesu nana kei awero ema bi nu doro bamuwa awa giwa. Nu mo awero kotumai nuso noko ewanana wenu nu Yesure dai dara arumuro itinua awa giro azu wewa. ");
INSERT INTO sue_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ago wewa ema nukare gita tani awa giwa ami Yesu meni ema bi nuso nana itai awa korawenua amira uge awa wewa niniwa. ");
INSERT INTO sue_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ata Gegesa zebura ema dapikarago ami azu wero Yesu nu zebu nusokare doro bayaise sewa. Are nu bua mai nusore witi wara niro ewesemuro bayamu inoiwa ");
INSERT INTO sue_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ema bi nu doro bamuwa ami Yesu begomo toise ego senua awa, “Na nimore dai bayamu tona.” Ago senu Yesu meni azu toise numore ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ni ewesemuro nata nisora bamuro Anutu tani dainiro nimore wetia awa seyo gare.” Ago senu ema ami ewesemuro baro tani dainiro Yesu meni numore wenua amira ge uge inoise ema bama nata nusora amire senu giwa awa. ");
INSERT INTO sue_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu ou semuro noko ewesemuro munu ema bama dubu bamu nu dia itiwa ami nu giro yawa sara bamu wewa. ");
INSERT INTO sue_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Are ema zo zazo nuso Yairo nu awa simai bamu yere ibu dia wero noisonua ami muro Yesu nana zorage baro koiniro begomo toise ego senua awa, “Nima so nasora mu.” ");
INSERT INTO sue_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ago senua, nera kota, mai nuso bama diri daimata zepa nuso 12 gege ami betamu inoise itinua. Ago senu giro Yesu susaunu ema bama dubu bamu meni numa poti soe niro susauwa ");
INSERT INTO sue_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","amira nana bama zo be giti orara pupinoe donu zepa 12 ago wenua awa dai bamunua. Ata ema zo meni yaya nuso awa korawai ine te kaka wamu awa. ");
INSERT INTO sue_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bama ami Yesu nana gutipe muro wana potiro Yesura tama woi be kimunua. Nu ago inuaise orara nuso touwenua. ");
INSERT INTO sue_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ago wenu Yesu meni ego senua awa, “Ai meni tama woi naso kimi?” Ago senu nukare dapikarago ego sewa awa, “Na tepo. Na tepo.” Ago sero bamuwa Petoro meni ego senua awa, “Gipai ema, ema bama dubu bamu meni nima poti soe niro itera, gosa!” ");
INSERT INTO sue_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ago senu Yesu meni ego senua awa, “Zo gita wana nuso naso nana potia, awa enia wetena, nera kota, korawaira putou eni naso nana ena semuro bami gena.” Ago senu ");
INSERT INTO sue_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","bama awa susu nuso bezai ine tepo giro boro-boro inoise nuso nana zorage muro bawa giti meni zebura dinua. Ago wero ema bama dubu bamu itiwa amira giti mokara ena nu nogoro wana potiro Yesu kimunu amira susu awa kerenitinoise yaya nuso eya tepo wenua awa dai senu giwa. ");
INSERT INTO sue_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ago senu Yesu meni numore ina ego senua awa, “Mia naka, ni tuma diai nisora ewanana wetesa. Ni duba ewananare bamuyo.” ");
INSERT INTO sue_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nu ge toise itinu ema zo simaira nana sora ena muro simaire ego senua awa, “Mai niso betetia. Are bua bamu gipai emare oko potase.” ");
INSERT INTO sue_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ago senu Yesu meni ge awa niniro ema simai amire ego senua awa, “Ni kotumu-katumu oko wase. Ni tuma diaire gege nuasa mai niso kokopai wamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ago sero baro simai nana sora kei awero ema bama numore dai so duru toyai azu senua. Nu Petorora Yohanera Yakobora ata maira mia mama nukare awa gege puro toiwa awa. ");
INSERT INTO sue_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ota ema bama witai meni awa nukare mai emo dire-buare inoise itiwa, ata Yesu meni numorekare ego senua awa, “Nikare di oko sawe. Nu kaka betamu awa. Nu gitawa gege inoya.” ");
INSERT INTO sue_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ago senu nukare mai me betenua awa giwa, are nu sero ziwa. ");
INSERT INTO sue_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ata Yesu meni mai bama diri amira wana ziro zawa sero ego senua awa, “Zebi, ni eri.” ");
INSERT INTO sue_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ago senu maira ozana noko munu eya erinua. Ago wenu Yesu meni nena potara naise senua. ");
INSERT INTO sue_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Are maira mia mama nuto tani awa giwato beu denua. Ata Yesu ge zewai numoreto ego senua awa, “Nito tani emira oziga awa ema zore oko saweto.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu meni bua mai nuso 12 zawa senu muwa putou zewai-zawai — bi dapikarago tunaira putou, ata yaya neire-neire korawaira putou — awa numorekare potinua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ago wero nukare baro Anutu imata Tua wero nuamunoya amira ge sero gipinoise ema bama yayare kora warise sero iyetinua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iyetitinoise numorekare ego senua awa, “Nikare ebete nuamu inoise nena dainiro oko pumawe. Nikare bogita kaitata nena naita wau moni oko pumawe. Nikare tama woi eto oko pumawe. ");
INSERT INTO sue_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ota nikare esewa wero so zora toyamunowa da amira itai-matai inoma muro baro awinoise noma so awa doro bayamunowa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ota nikare nata zora bayawa nunekare nikare kaka puro toi so nusokarera namu wara giro nikare nata awa doro te nisokarera wowo deregi wewo nukare tani nusokare waya awa kotumare.” ");
INSERT INTO sue_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ago senu nukare bamuwa. Baro nata serora noise Oziga Ewanana sero gipero awinoise ema bama yayare awa korawewa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ema tua Herode meni Yesu tani bamubamu inoinua amira bowi niniro itazaita wenua. Nera kota, ema eni meni ego sewa awa, “Yohane betaira ena eriro noya.” ");
INSERT INTO sue_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ota eni meni ego sewa awa, “Elia noko kei awetia.” Ota eni meni ego sewa awa, “Porofete gitara zo seka ziro eriro noya.” ");
INSERT INTO sue_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ago toise noiwa Herode meni ego senua awa, “Na Yohanera duba kapena. Ata ema agai noi na ge bowi nuso ninitinoni?” Ago sero nu Yesu gaira ebata tamamu wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposolo 12 nukare noko tera Yesu nana muro bua bamubamu wewa amira uge wewa awa. Ago wewa Yesu meni nukare gege pumuro ema eni doro nukare bamu nata zo zazo Besaida amira niwa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ago wewa giro ema bama eni meni nu tamamu sero ama bamuwa awa. Baro nuso nana kei awewa giro nu yawa sara inoise Anutu imata Tua wero nuamunoya amira ge awa numorekare sero gipero awinoise ema bama yayare awa kora wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ago inoise itinu tua zizinoinu giro bua mai nuso 12 ami nuso nana muro ego sewa awa, “Ni ema bama iyeti nata zorage itera amira baro awamu inoise nena nai tamuro nare. Zebu nakai itenakai ewa nena nai tepo awa.” ");
INSERT INTO sue_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ago sewa, ata Yesu meni numorekare ego senua awa, “Nitopekare nena nai numorekare potiu nare.” Ago senu nukare sewa awa, “Nakare nena nai dainiro tepo. Nakare ame moyai wana da ata wo eto ami gege itera ewa. Ni nanekare baro ema bama emira nena nai zuma gaero potanisekare kotumuro tosita?” Ago sewa, nera kota, ");
INSERT INTO sue_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ema dubu awa 5,000 ami itiwa. Ago sewa Yesu meni bua mai nusore ego senua awa, “Nikare seu ema bama 5,000 ami dubu sero dubu sero 50-50 wero arumare.” ");
INSERT INTO sue_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ago senu bua mai nuso da ago sewa ema bama arumuwa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Arumuro itiwa Yesu meni ame wana da amire wo eto amire awa puro iri utura niro Anuture kokopai asero wore amere awa eweweniro bua mai nusore potinu nukare ema bamere potiwa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ago wewa ema bama dapikarago ami niwa te wenua awa. Ago wewa nena itata dago itinu giro poti dara niwa kana 12 te wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Be zore Yesu nu imata isa toise itinu bua mai nuso numore dai itiwa. Are nu nukare atata wero senua awa, “Erama meni na are asinoweri?” ");
INSERT INTO sue_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ago senu nukare ina numore ego sewa awa, “Eni meni nima Yohane ge ou gutai zaawai ema asinowera; eni Elia asinowera; eni porofete gita noisowa amira zo seka ziro nowia asinowera awa.” ");
INSERT INTO sue_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ago sewa nu ego senua awa, “Ina nikare nitopekare na are asinowewi?” Ago senu Petoro meni ina ego senua awa, “Nima awa Soyai Ema zazo Kristo, Anutu meni iyetamu senua.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu meni ge zewai-zawai sero nunekare susu nuso awa kereniro ema zore sai azu senua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nu azu toise ego senua awa, “Na Emara Mai meni yaya-buyaya tamamunona. Ago wana Yuda emara simaire pris babezinomare lo ge gipai emare ami na azu sero dara betana waiko be etorobara tepo wai amire na noko seka wero eramunona awa.” ");
INSERT INTO sue_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ago sero nu bua mai nuso dapikarago amire ego senua awa, “Zo nu na ama ganamu wero giro ara tamai nuso dapikarago doro be sero duba naire yaya tamaire amira ni pasinai nuso dimuro na ama ganaise. ");
INSERT INTO sue_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ago tona, nera kota, zo nu nuai nuso zebura awa soero puro nuamu kotumamunoya amira nuai nuso tepo wamunoya. Ota zo nu nuai nuso zebura awa na emo wero duamunoya ami nuai ewanana tamamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ota ema zo meni zebura nena kokopai dapikarago awa pupinuamunoya, ata ititi nuso sisero waya wai te wamunoita? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ota ema zo nu na ata ge naso awa azu samunoya, awa na Emara Mai meni simai zasimaire naso ata Mamera ata angelo dubu saramaire amira awa puro mamunona be amire na ina ema awa azu samunona. ");
INSERT INTO sue_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na ge me nimorekare tona awa. Ema eni ego dopero itera ami kaka betamu nuara Anutura putou eramara nana ena kei awai gamunora awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu ge awa senu waiko be 8 ago tepo wenu amire numa Petoroto Yohanere ata Yakobo nukare awa puro isa samu sero dirumura witiwa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nu isa toise itinu benau nuso awa zo wenu tama woi nuso awa zasipitinoise kapa me kapa wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ago wenu lo ge potaira mama Mose ata porofete bamu Elia nuto ami numore dai itise ge uge numore wewato awa. ");
INSERT INTO sue_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nuto simai zasimaire dai muroto Yesu meni Yerusalem ena betamu inoinua amira uge wewato awa. ");
INSERT INTO sue_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petoro ata otao nuso etore giti moweninu gitawa inomite eriro Yesura simai zasimaire ata ema eto numore dai dopero itiwa awagiwa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nuto Yesu doro bayamu inoiwato giro Petoro meni Yesure ego senua awa, “Gipai ema, nakai ego itenakai awa ewanana. Are ninasa nakare komboa etorobara sinanekare — zo niso, zo Mosera, zo Eliara.” Ago senua awa. Ata Petoro nu kaka giro baitamu inoise tepo senua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nu ago toinu bereze zo meni nukare gogowenua awa. Bereze nukare gogowenu nukare azu wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ago inoiwa ge zo bereze amira mokara ena ego kei awenu niniwa awa. “Awa Mai naso. Na nu pumuro buara gegenina. Nikare ge nuso niniu.” ");
INSERT INTO sue_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ge awa tepo wenu amire nukare iri niro Yesu imata itinu giwa awa. Are nukare be amire tani giwa, awa ema zore kaka samu duba nusokarera doro noisowa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pina atinu nukare dirumu doro osewa ema bama dubu bamu ami muro Yesu ebete ena tamuwa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ago wewa ema bama amira mokara ema zo meni zawa sero ego senua awa, “Gipai ema, na begomo nimore tona. Ni mai naso emo zo amuyo. Na mai awa daimata gege. ");
INSERT INTO sue_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Are bi zo meni nu daraunawi tutamu eya zawa gatinowia. Ago wawi bi ami nu dero musuna-masuna wawi pora bera kisa-kisa wawi yaya bamubake tamawi amire bi nu dotinowia. ");
INSERT INTO sue_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Are na bua mai nisore bi tunarise sero di sero awetena bi tunero zainera.” ");
INSERT INTO sue_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ago senu Yesu ge ina ego senua awa, “O nikare ema bama waya, tuma diai tepo. Na be nazo bua nisokarera tama doinoise nuamunoni? Mai niso puro naso nana mu!” Ago senu ");
INSERT INTO sue_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","nu mai nuso puro tupiaise bi meni apenu duunu puro apena-kapena wenua awa. Ata Yesu meni bi awa senero mai awa kora wero mama nusore noko tera potinua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ago wenu ema bama bamu ami Anutura putou bamu awa giro titibi awero di tainiwa awa. Nukare tani eni wenua amira kotumu-katumu inoise itiwa Yesu meni bua mai nusore ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nikare dana zaawero ge ewa niniro baitiwo. Nukare Emara Mai poti ema dubura wanera namunora awa.” ");
INSERT INTO sue_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ago senua, ata nukare ge awa kaka gamu. Nukare ego kotumuwa awa, “Nu ema tua nasokai sia tonakai amire betaira ge toya, ei tonua!” Ago kotumuro ge amira susu awa giwa beu denua. Ata nukare ge amira atata wai azu wero dowa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bua mai nuso meni, “Yesu meni ema tua nasokai wero nuai amire nasokai nana zo ai meni bamu wamunoi?”, amira sero buru zara wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kotumai awa nusokare nana mokara itinu Yesu ginua awa. Are nu mai kiaka zo puro nuso nana demabera potinu numore dai dopenu ");
INSERT INTO sue_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nu numorekare ego senua awa, “Ema zo nu mai kiaka ewa na emo kora wamunoya, awa nu na kora wetia ago ine wamunoya awa. Ota ema zo nu na kora wamunoya, awa nu na iyetinu muna awa kora wetia ago ine wamunoya awa. Ema zo nisokare nana soe ena nu nutope puro osero nuamunoya, nu ami bamu wamunoya awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ago senu Yohane meni ge ina ego senua awa, “Gipai ema, nakare ema zo meni zazo niso zawa toise bi tuninoi goisenakare awa. Ata nu nakai kaka ama ganamu inowia, are nu duaise sisenakare.” Ago senua, ");
INSERT INTO sue_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ata Yesu meni numore ego senua awa, “Nikare nu duaise oko sawe. Ema iwo nimorekare kaka wamu awa otao nisokare awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Be Anutu meni Yesu pumai witi utura naira be awa zorage munua awa. Ago wenu Yesu nu kotumuro giro nu Yerusalem bayamu denenua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Are nu ema eni iyetinu gita baro nena nuso kora wamu sero Samaria emara nata zora bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bamuwa ema nata amira ami Yesu nata nusokarera bayai azu sewa. Awa nera kota, nu Yerusalem bayamu inoinua.* ");
INSERT INTO sue_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Azu sewa giro bua mai eto Yakoboto Yohanere meni numore ego sewato awa, “Tua, nakare zawa sanakare utura ena niao osero ema bama ei awa awanoita?” ");
INSERT INTO sue_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ago sewato Yesu ewesemuro nuto senenua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Senero amire nu bua mai nusore dai nata awa doro nata zora bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nukare ebete susauwa ema zo meni numore ego senua awa, “Ni nago nago bayamunosi, awa na te ni ama ganamunona.” ");
INSERT INTO sue_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ago senu Yesu numore ego senua awa, “Wo zobina nukare awai masire. Noko ni mamai da ago nukare papamore. Ata na Emara Mai meni awa so-mara auka inoise nowena. Are eya na ama ganamu oko sase.” ");
INSERT INTO sue_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ago sero ema zore ego senua awa, “Ni mu, na ama ganase!” Ago senua awa. Ata ema awa ego senua awa, “Tua, ni ninasa na gita mama naso betai gowero amire ama ni ama ganane.” ");
INSERT INTO sue_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ago senu Yesu meni numore ego senua awa, “Saineba, ema ititi tepo meni nuago inowera ami betai ema gowarise. Ota nima meni awa ni baro Anutu imata Tua wero nuamunoya amira ge bowi awa sero gipero awase.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ota ema zo meni numore ego senua awa, “Tua, na ni ama ganamunona awa. Ata ni ninasa na gita baro dubu naso wana ziane.” ");
INSERT INTO sue_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ago senu Yesu meni numore ego senua awa, “Ema zo nu wa ama wamu wero giro iri ama nitinoise nuamunoya ami ebata doro demese bayamunoya. Da ago ine zo nu Anutura bua wamu wero giro iri ama niro zebura nena ua inoise nuamunoya ami bua awa wai ine te kaka wamu.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ama Tua meni bua mai seka 70 iyetitinoise eto eto baro nata babezinomare pei-mamaire amira nu nutope ama bayamu yaba inoinua amira bayarise senua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ago sero numorekare ego senua awa, “Nena buye ena zamuro itia, ata pumaira ema etokaka.* Are nikare pumai buara Mamere isa sawa nu nena pumai ema tamai bua nusora bayarise. ");
INSERT INTO sue_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nikare buara bamuwo. Na nikare iyetana nikare wo sipsip mai mamai ine wero abu suna itera amira nana mokara bayamunowa, a giwo. ");
INSERT INTO sue_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nikare moni woireta kaitata tera sandol oko pawe. Nikare ebete ena ema bama tamuro wana ziro ge uge oko wawe. ");
INSERT INTO sue_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ota nikare so zora toyamu inoma giro ego sewo, ‘Ema bama so emira awa Anutura gawa meni nusokare nana itaise.’ ");
INSERT INTO sue_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ago sawa ema zo utura gawa pumamu yaba inowia ami so amira itamunoya, awa gawa ge samunowa awa nuso nana ena me wamunoya. Ota ema gawa pumaira zo ago ine tepo, awa gawa ge nisokare awa noko tera ewese nisokare nana niro itamunoya. ");
INSERT INTO sue_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nikare so daimata amira gege itai-matai inoise noiwo. Ota nena naire oure nimorekare potara giro awa gege ninoise itiwo. Nera kota, bua ema awa nu bua inoya amira zuma te pamunoya awa. Nikare so zora witiro gawa waya wai giro doro so zora nana oko toyawe. ");
INSERT INTO sue_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ota nikare nata zora bayawa nukare nikare otao wero nena nimorekare potamunora awa puro niwo. ");
INSERT INTO sue_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nikare nata amira ema yayare awa kora wero numorekare ego sewo, ‘Anutu imata Tua wero nuamunoya amira putou awa nisokare nana kei awamu inoise inoya.’ ");
INSERT INTO sue_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ota nikare nata zora bayawa nukare nimorekare otao kaka wamu wara giro nikare baro kakame dopero ego sewo, ");
INSERT INTO sue_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Susu nisokare waya awa gawise sero nakare nata nisokarera wowo te nasokarera takimia awa deregi wetenakare nisokare nana bamia awa. Ata nikare susu ei awa giro baitiwo: Anutu imata Tua wero nuamunoya amira putou awa nisokare nana kei aweti nikare kaka pumamu wetewa nikare dainiro susawia.’ ");
INSERT INTO sue_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na nimorekare tona awa. Anutu meni erama awina-dawina inoise ina potamunoya be amire nata Sodomra erama ina mou tamamunora. Ata nata ge nisokare azu samunora ami ine mou-mau bamu tamamunora. ");
INSERT INTO sue_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yei Korasin ema! Yei Besaida ema! Mou bamubake nisokare nana kei awamunoya. Na tani putoure eni nisokare nana ena inowena awa na nata Tayato Saidonre amira ana wamena sia, awa nukare emoko duba kapeteniro pasina nusokare kotumuro duba nitinoise mo tama guigi-gaigi wai awa awero awetu gutero itamera. ");
INSERT INTO sue_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Anutu meni erama awina-dawina inoise ina potamunoya be amire Tayato Saidon natara ema bama meni ina osai tamamunora. Ota ninekare meni awa ina nisokare bamubake tamamunowa. ");
INSERT INTO sue_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ota nikare Kapaneam ema, ema bama meni zazo nisokare de ike namunorita? Tepo awa. Nukare zazo nisokare puro osamunora.” ");
INSERT INTO sue_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu meni ge ago sero bua mai nusore ego senua awa, “Zo nu ge nisokare dimamunoya, awa nu ge naso dipinoya ago ine wamunoya. Ota zo nu ge nisokare azu samunoya, awa nu ge naso azu sesia ago ine wamunoya. Ota zo nu ge naso azu samunoya, awa nu Anutu na iyetinu muna amira ge azu sesia ago ine wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ama bua mai 70 ami yawa sara inoise ewesemuro Yesure ego sewa awa, “Tua, nakare zazo niso zawa toise bua inonakare bi dai ge nasokare dipisera.” ");
INSERT INTO sue_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ago sewa nu numorekare ego senua awa, “Satan nu utura ena duunu gina, awa nu piri-piri meni wuru-were wero osago wenua. ");
INSERT INTO sue_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nikare ego niniwo. Na putou nimorekare potitana. Are nikare zire gogozare awa patawa nikare waya oko wamunora. Nikare iwora putou te puro osamunowa awa. Ago wawa nena zo meni nikare oko waya wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ata bi meni ge nisokare dipisera amira yawa sara oko wawe. Tepo awa. Nikare Anutu meni zazo nisokare utura gaenu itewia amira yawa sara weu.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Be amire Ozana meni Yesu nana mokara bamu wenu Yesu meni ego senua awa, “O Mama, ni uture zebure amira Tua. Nukare nutopekare gawera ema bamu inowia ema ago ami gai azu, ni putou nisora susu bezinowesa. Ota nukare nutopekare gawera mai morua inowia numorekare awa kerenitinowesa. Are na ni bowi inona. O Mama, ni ago gege wamu ara tapinowesa, are na ni bowi inona.” Nu ge awa Mamere sero tepo wero ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Mama naso meni nena bamubamu dapikarago awa wana nasora potinua. Ema zo meni na Mamera Mai amira susu awa oko gosinowia. Mama meni imata gosinowia. Da ago ine ema zo meni Mamera susu oko gosinowia. Na Mai meni imata gosinowena. Ota na Mai meni Mamera susu ema enire gipinowena nukare ami Mamera susu gosinowera.” ");
INSERT INTO sue_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ago sero kapeteniro bua mai nusore gege ego senua awa, “Nikare nena benau seka gosinoise nowa amira yawa sara weu. ");
INSERT INTO sue_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na nimorekare sane. Gita porofete dainiro ata ema tua dainiro nukare ami nena gosinowewa awa gamu yaba inoisowa, ata nukare kaka gamu inoe bebeteniwa. Nukare ge ninitinowewa awa ninamu yaba inoisowa, ata nukare kaka ninamu inoe bebeteniwa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lo ge ninai ema zo meni eriro Yesu gaero gamu sero atata wero senua awa, “Gipai ema, na nogo wero nuai me ewanana awa tamamunoni?” ");
INSERT INTO sue_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ago senu Yesu meni numore ego senua awa, “Lo ge nogo nogo gayai itewi? Ni azimuro gosinowesita?” ");
INSERT INTO sue_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ago senu nu ina ego senua awa, “Ara tamai niso bamubake awa Tua Anutu niso amira nana itaise. Ago inoise dubare ititire putoure kotumaire niso meni nu sou weyo. Ota ni nitope ara tapinowesa, da ago ine ema enire weyo.” ");
INSERT INTO sue_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ago senu Yesu meni numore ego senua awa, “Ge ina awa kokopai tosa. Ni ago wero noma nuai me ewanana awa tamamunosa.” ");
INSERT INTO sue_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ata lo ge ninai ema meni nu nutope zazo nuso wai ewanana waise sero Yesure ego senua awa, “Ota ema arekare kora wanise sai iti?” ");
INSERT INTO sue_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ago senu Yesu meni ge ina samu inoise uge ego dinua awa. “Ema zo Yerusalem doro Yeriko nate bayamu osero susaunu ema waya-kawaya eni meni ebete ena nu dewa betamu inoinu nena nuso dapikarago soero pumuro doro bamuwa awa. Ago wewa nu betamu inoise itinua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Be amire pris zo meni ebata awa ama ganero osero susaumite ema awa giro doro dainiro demabera gegero bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ago wenu pris dubura wana soga zo meni ebete susaumite nuso nana kei awero nu giro da ago dainiro demabera gegero bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ago wewato ema zo Samaria natara ami ebete susaumite ema awa tamuro zo amai bamu numore wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Are nu nuso nana zora asusumuro ziro ou wain ata ou gawire awa iso nusora zozero dowenua awa. Ago wero zinu erinu wo donki nusora tame potinu arumunu puro baro esewa sora potiro dia wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ago inoinu pina atinu nu esewa sora mamere kina eto potiro ego senua awa, ‘Ni ema ewa dia wero baitiyo. Ota moni niso numore duamunosa awa be na ewesemamunona amire moni niso ina potamunona awa.’” ");
INSERT INTO sue_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu meni uge diro amire emare ego senua awa, “Uge diena awa niniro nogo kotupitinosi? Ema dewa betamu inoise itinua amira nana ema etorobara kei awewa, amira nana ai meni ema korawai ema wenu?” ");
INSERT INTO sue_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ago senu lo ge ninai ema meni ego senua awa, “Ema nu zo amuro soremunua ami korawai ema me wenua awa.” Ago senu Yesu meni numore ego senua awa, “Are ni baro da ago gege inoise noiyo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu bua mai nusore susaumite nata zora kei awewa bama zo zazo nuso Mata ami nu puro so nuso nana bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Matara zawa zazo nuso Maria ami muro Tuara nana tera arumuro ge ninitinoise itinua awa. ");
INSERT INTO sue_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ata Mata meni nena naira bua bamu inoise kotumai saisai tamunua awa. Ago wero baro Yesure ego senua awa, “Tua, zawa naso na doti na nena naira bua imata inona, awa gesa te inoita? Ni numa se na soremae.” ");
INSERT INTO sue_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ago senu Tua meni ge nuso ina ego senua awa, “Mata, Mata, ni nena bamubamu amira kotumai niso sisinosa moka niso waya inoya. ");
INSERT INTO sue_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ata nena daimata gege pumanisekai sai awa. Are Maria nu nena kokopai awa pamu yaba inoya. Are nakai nena kokopai awa nuso nana ena oko soero pumanekai.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesu nu agewa zora itise isa senu tepo wenu amire ama bua mai nuso zo meni numore ego senua awa, “Tua, ni nakare isa saira susu gipeyo. Gita Yohane meni bua mai nuso gipenua, da ago ine gipasise.” ");
INSERT INTO sue_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ago senu nu numorekare ego senua awa, “Be nikare isa samu wero giro nikare ego sewo: O Mama, zazo niso saramai itaise. Mu, duba sero zebu sero amira Tua nasokare wase. ");
INSERT INTO sue_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nena nai namorekare waiko be sero potitinowesa awa zeme potiyo. ");
INSERT INTO sue_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pasina ema eni meni namorekare inowera awa dotinonakare, da ago ine ni pasina nasokare doyo. Ni nakare etete naira oko potase. Isa ago ine sewo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ago sero numorekare ego senua awa, “Na ego gosinona. Nisokare nana zo meni pi soe sieniro baro otao nuso awa-uzero ego samunoya awa, ‘O otao, ni nena itai giro namore potiyo. ");
INSERT INTO sue_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Otao naso zo nu ebete aita inomite muro naso nana kei awetia. Ago weti na nena nai tepo.’ ");
INSERT INTO sue_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ago sai sora mama meni ina ego samunoya awa, ‘Ni namore bua oko potase. So be na gazai awa. Ota mai awiso naso namore dai sawe awinora awa. Are na eriro nena nimore potai ine tepo.’” ");
INSERT INTO sue_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yesu meni ago sero susumuro ego senua awa, “Na nimorekare sana niniu. Sora mama meni ema amire, ‘nu otao naso,’ asero oko eriro nena potamunoya. Tepo awa. Ata saineba, nu so be borere-barere doinoi giro nu eriro nena kau inoya awa te numore potamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Are na nimorekare tona awa. Nikare Anuture isa toma amire pumamunowa; nikare tamaira bua inoma amire me tamamunowa; nikare isa nisokare meni so be dago inoise nuawa Anutu meni ninamunoya. ");
INSERT INTO sue_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ema isa towera ami pupinowera; ema tamaira bua inowera ami me tapinowera; ema isa meni so be dago inowera amira isa awa Anutu meni ninitinowia. ");
INSERT INTO sue_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ota nisokare nana ema zora mai meni wo emo sai mama nuso meni zi waya maire potanoi? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ota mai meni mama nusore ni munu zo numore potaise sai gogoza zo potanoi? Awa dai tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nikare ema waya-kawaya meni mai awiso nisokarere nena kokopai potitinowewa. Are ego gosinonakai awa: Mama utura itewia ami nikare erama dainitinoise Ozana ema isa towera amire potamunoya awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Bi zo ema zora nana toinu dau wero ge tepo noisonua. Are Yesu meni bi awa tunenu bamunu ema awa Yesure dai ge ina-sa wewato ema bama witai meni giro di tainiwa awa. ");
INSERT INTO sue_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ata ema eni meni numore ego sewa awa, “Nu bi tuninoya, awa bira giti kopi Bielsebul amira putoura tuninoya awa.” ");
INSERT INTO sue_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ago sewa, noko ema eni meni putou nuso atata wero utura tani putoure zo wai gamu sewa. ");
INSERT INTO sue_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ata nu kotumai nusokare giro numorekare ego senua awa, “Dub zo awina-dawina wero iwo ina-wa wamunora, awa ama sisero tepo wamunora. Ota ibu be zora mai awiso nukare iwo ina-wa wero noma sisero tepo wamunora. ");
INSERT INTO sue_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Are Satan meni soumai nusore iwo wero bogi wami sia, awa putou nuso meni nogo nogo zewai wero itami? Nikare namore ego towa: Nane Bielsebulra putoura bi tuninowena asinowa, ");
INSERT INTO sue_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","awa ge nisokare me sia, awa mai awiso nisokare bi tuninowera ami ara putoura bi tunameri? Nukare Anutura putoura bi tuninowera, are nunekare ami opi sai nisokarera susu kerenamunora. ");
INSERT INTO sue_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ota na Anutura putou meni bi tuninowena, are Anutu imata Tua wero nuamunoya amira putou nisokare nana emoko kei awero itewia. ");
INSERT INTO sue_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Susu nasoto Satanra ego ine itia ewa: Ema zo zewai wero gi ami ziro so nuso dia wamunoya, awa neu-nau nuso kokopai itamunora awa. ");
INSERT INTO sue_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ago inoise nuai amire ema zewai-zawai zo meni kei awero ema awa dero gi ami nuso tuma didinowia awa puro apamunoya awa. Ago wero amire neu-nau nuso awa pumuro ema enire bona wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Are zo nu namore otao kaka wamu wamunoya ami namore iwo wamunoya. Noko zo nu na sorepitinoise poti dara nai bua naso kaka wamu wamunoya ami siso-siso wai bua wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ota bi meni ema zora nana mokara ena kei awero zanatiaira masi ware ena tamamu bayamunoya. Baro kaka tamamu inoma giro ego samunoya awa, ‘So naso doro musena da amira noko ewesemuro bayamunona.’ ");
INSERT INTO sue_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ago sero baro so awa wazero kora wetera itia awa gamunoya. ");
INSERT INTO sue_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ago giro baro bi otao mamai 7 nu ine kota, waya me waya, awa puro muro so da amira toiro itai-matai wamunora. Ago wara ema awa gita waya noisonua ami waya me waya wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu ago senu amire ema bama itiwa amira nana soe ena bama zo meni arero ego senua awa, “Bama zo gita nima pumuro ami gaenua nu ami yawa sara waise.” ");
INSERT INTO sue_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ago senu Yesu meni ego senua awa, “Ago oko aewa. Ema bama Anutura ge niniro dipinoise nowera ami yawa sara warise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ema bama witai muro aunitinoiwa nu numorekare ego senua awa, “Ema bama be zeme emira awa ema bama waya-kawaya. Nukare tani putoure zo wana gamu towera. Ata tani putoure zo oko gamunora. Tani gita Yonara nana kei awenua da ago ine kei awai gamunora. ");
INSERT INTO sue_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gita Yona meni Anutura tani Niniwe emare gipenua. Da ago ine na Emara Mai meni Anutura tani ema bama be zeme nowera amire gipamunona awa. ");
INSERT INTO sue_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Anutu meni erama awina-dawina inoise ina potamunoya be amire Siba zebura bama tua nu dai eriro ema bama be zeme nowera amira susu kerenai mou dimamunora. Nera kota, bama tua ami Solomonra kotumai bamubake awa sai ninamu tama dero zebu zora-zarako ena munua awa. Ata na ego dopero itena ami Solomon dainitinona. ");
INSERT INTO sue_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Anutu meni erama awina-dawina inoise ina potamunoya be amire Niniwe ema meni eriro ema bama be zeme nowera amira tani waya nusokarera susu kerenara mou dimamunora. Nera kota, Niniwe ema bama nukare Yona meni Tuara ge tugata wenu niniro duba kapeteniwa. Ata na ego dopero itena ami Yona dainitinona. ");
INSERT INTO sue_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nakai lam gaero so dura ena ura wamuro oko potitinowenakai. Tepo awa. Ota noko au sose oko potitinowenakai. Tepo awa. Erama sora toitinowera ami zasimai awa garise sero nakai gabarira ikonawenakai zasipitinowia awa. ");
INSERT INTO sue_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Giti moka niso awa tama nisora lam ine awa. Are giti moka niso ewanana itai amire tama aiso niso dago ewanana zasimaire itamunoya. Ota giti moka niso waya wai amire tama aiso niso dago mume wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Are zasimai niso nana mokara itia awa mume wai azu, moka niso saitiro dia weyo. ");
INSERT INTO sue_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ota tama aiso niso dapikarago zasimai gege mume agewara tepo wamunoya, awa lam me meni zasipitinoise nakai poti damu nitinowia ago ine wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu ge awa senu tepo wenu amire Farisayo ema zo meni nu nena numore dai naise zawa senua awa. Senu giro nu Farisayo nana sora baro tebolra arumunua awa. ");
INSERT INTO sue_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nu Yudara tani wana sewinoisowa* awa kaka wamu tepo arumuro nena gege ninu Farisayo ema ami ginu te kaka wamu wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Are Tua meni numore ego senua awa, “Farisayo ema nikare au-tewa tama gege sewinowewa awa. Ata moka nisokare tani bewanara amire tani pasinara amire ami bemai awa. ");
INSERT INTO sue_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nikare ema dau awa. Anutu meni tamare mokare eto dago tamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ata nena au-tewa mokara itera awa nikare ema bogamasare potawa amire nena nisokare nana bamubamu awa saramamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ata nikare Farisayo ema, nikare temuwo! Nikare Anutura lo ge dipinoise noiware tagorore yare sianiro dubu dawewa wana eto wawi amire daimata Anuture potitinowewa awa. Ata nikare tani kokopai awa dainitinoise Anuture dubara dumi pumai amira tani awa kaka wamu. Ota nikare tani inowewa awa inoise eni sesena awa dai wamewa, awa te wamia. ");
INSERT INTO sue_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ota nikare Farisayo ema, nikare temuwo! Nikare Anutura ibura ena emara benaura arumamu yaba inowewa. Ota ema bama meni kakame ena nikare arenarise yaba inowewa. ");
INSERT INTO sue_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nikare temuwo! Bi diti zebu duru itawi ema bama meni kaka gamu bi diti tame aita wero tama bemitire inowera, bi diti ago ine nikare awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ago senu lo ge gipai ema zo meni ina ego senua awa, “Gipai ema, ni ge awa sesesa nakare dai pupinoya awa.” ");
INSERT INTO sue_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ago senu Yesu meni ina ego senua awa, “Nikare lo ge gipai ema, nikare temuwo! Nikare potai ge nisokare momou-mamou ema bamere potawewa dipinoise yaya tapinowera. Ata nitopekare wana zo meni oko soremawewa nena mou-mau awa dipinowera. ");
INSERT INTO sue_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nikare temuwo! Porofete ewowo-kawowo nisokare meni dewa bebeteniwa amira bi diti nusokare awa ninekare simena-gaena inowewa awa. ");
INSERT INTO sue_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Are ewowo-kawowo nisokare meni porofete dewa bebeteniwa ninekare porofetera bi diti awa simena-gaena inowewa. Ago inoise ewowo-kawowo nisokarera pasina awa gawewa ewanana inowia, ago ine inoya awa. ");
INSERT INTO sue_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Are Anutu ninai kokopaire ami nimorekare ego senua awa, ‘Na porofetere aposolore iyetana nusokare nana bayara ema meni tunara bozara eni dara bebetenamunora awa.’ ");
INSERT INTO sue_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Be zebu kei awenua amira ana zaawero porofete dasara bebetenitinoisowa amira ina awa ema bama zeme nowera amira nana kei awaise sero Anutu meni ago senua. Awa Abel dewa betenua amira ana goroba zaawenua awa mai gege tupie donu amire Zekaraya alta tumara ena dewa betenua awa. Are na me memeka tona ewa. Porofete dewa amira ina awa ema bama zeme nowera amira nana kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nikare lo ge gipai ema, nikare temuwo! Ge porofete meni sero gainoisowa awa nikare ema bamere kaka kereniro baitamu inowewa, are nikare nuai paira ki emoko sokero puro nowewa ago inoya awa. Ata nikare nitopekare nuai me ewanana amira sora kaka toyamu inoise amire eni meni toyamu wawera gazinowewa awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu so doro damu kei awero noinu lo ge gipai emare Farisayore nukare zewai-zawai wero nu ge tebe-tabe saise atata dainiro wewa. ");
INSERT INTO sue_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ago inoise nu uma inoise dana zaawero ge zo sai gara waya wai giro numa gera potamu sero wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ema bama witai-bake ami auniro ginero te ina-pata inoiwa be amire Yesu meni gita bua mai nusore ego senua awa, “Farisayora yis awa semu nisokare nana nai azu, uma wero baititinoise noiwo. Nukare me saora inoise amire moka meni waya puro nowera awa. ");
INSERT INTO sue_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nena dapikarago bezai itia awa ama kei damu namunoya awa. Nena dapikarago dowai itera awa ama ema meni gamunora awa. ");
INSERT INTO sue_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Are nikare ge pire bezero towewa awa ama ema bama meni waikore ninamunora awa. Are nikare so duru ena ge gugumara diwinowewa awa ama ema bama meni kakame dopero zawa sero ge samunora awa. ");
INSERT INTO sue_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Otao mamai naso, na nimorekare sane. Tama aiso nisokare gege dara betamunowa, ata amira tame nena zo wamu sero putou kau wamunora, nukare awa azu oko wawe. ");
INSERT INTO sue_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Are ema nikare azu wamunowa awa na nimorekare gipamunona awa. Nikare ema nu ema dai betai ape dega niaore amira naira putou nuso nana itia, nu awa azu wewo. Me tona awa. Nikare ema awa azu wewo. ");
INSERT INTO sue_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nikare giwo. Ema nukare maket inoise ni suriri wana da awa toea eto meni zuma gainowera awa. Ata Anutu nu ni mai pei-kaka zo kaka nuwenamu awa. ");
INSERT INTO sue_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Are nu giti tu nisokare dapikarago azimuro gosinowia awa. Nikare azu oko wawe. Ni suriri dainiro amira zuma awa bamu tepo. Ota ninekare meni awa zuma bamure. ");
INSERT INTO sue_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Are na nimorekare sane. Zo nu emara nana benaura ena, ‘Na Yesura mai wero nowena,’ ago samunoya, awa na Emara Mai meni da ago Anutura angelo dubura nana benaura ena, ‘Nu awa mai naso,’ ago samunona. ");
INSERT INTO sue_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ota zo nu emara nana benaura ena na begi wamunoya, awa na Anutura angelo dubura nana benaura ena ina nu begi wamunona. ");
INSERT INTO sue_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Zo nu na Emara Maire ge waya samunoya, awa Anutu meni pasina awa disamunoya. Ata zo nu Ozana isimamunoya ema amira pasina awa disai ine tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ota nunekare nikare puro bamu Anutura ibura niro dia ema ata ema zazore amira nana benaura puro bayara nikare azu wero, ‘Nakai ina nogo numorekare samunonikai? Nakai ge ne samunonikai?’ ago oko kotumawe. ");
INSERT INTO sue_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nikare gera potara amire ge Ozana meni nimorekare gipamunoya awa samunowa awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ema bama dubu bamu amira nana zo meni Yesure ego senua awa, “Gipai ema, ni sasa nami naso meni mama nasotora nena awa bona wero na agewa potaise tona.” ");
INSERT INTO sue_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ago senu Yesu meni numore ego senua awa, “Awa nogo ni? Agai meni na zas nisokare wero noise nena nisokare bona wanise senu? Tepo awa.” ");
INSERT INTO sue_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ago sero numorekare ego senua awa, “Nikare temuwo! Nikare nena bamubamu amira duba-duba wai azu. Ema waure ami wau nusora nuai koko oko pumamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ago sero numorekare ge bezai zo ego senua awa, “Ema waure amira nai bua zamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ago wenu wau ema nu ego kotumunua awa, ‘Na nogo wamunoni? Na nena naso witai awa potai amira so tepo.’ ");
INSERT INTO sue_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ago toise senua awa, ‘Na ego wamunona. Na nenara so naso dapikarago ziwero noko babezinoma wamunona awa. Ago wero na wuitre nena naso kokopai enire so amira dubu damunona. ");
INSERT INTO sue_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ago wero na natope duba meni ego kotumamunona awa: Nena naso witai zepa dainiro amira te itia. Are na zeme zanatiamunona awa. Na nena niro ou niro yawa sara inoise itamunona awa.’ Wau ema meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ata Anutu meni ego senua awa, ‘Ni ema dau awa. Ni pi zeme emire betamunosa awa. Ago wasa nena dapikarago sia wetesa itia awa agai meni pamunoi?’ Ago senua awa.” Yesu meni uge awa diro amire ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Zo nu tamara zamai dubu dero ago puro noise Anutura nana benaura ena dubara wau oko dubu damunoya, awa tani da ago ine nuso nana kei awamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu meni bua mai nusore ego senua awa, “Are na nimorekare sana niniu. Nikare nuai nisokare emo kotumu-katumu inoise ego oko sawe, ‘Nena nai nana tamamunonikai?’ Noko nikare tama aiso nisokare emo kotumu-katumu inoise ego oko sawe, ‘Tama woi nana tamamunonikai?’ Ago oko sawe. ");
INSERT INTO sue_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nena nai meni me oko inoya. Nuai meni me inoya. Noko tama woi meni me oko inoya. Tama aiso meni me inoya. ");
INSERT INTO sue_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nikare ni owa kotumuwo. Nukare nena urise pupise oko inowera. Nukare so nena naire nena dubu daire tepo awa. Ata Anutu meni nena nai numorekare potitinowia awa. Ota nikare ema bama meni ni mamai awa dainiro itewewa awa. ");
INSERT INTO sue_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ota nisokare nana zo meni nuai nuso emo kotumu-kotumu inoise noma waiko be eni nuai nusora noko susumai te wamunoita? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Are nikare bua pei-kaka ago ine wai ine tepo giro nogoro nena bamubamu ami emo kotumu-katumu inowewi? ");
INSERT INTO sue_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nikare ni uzi ditinowia amira susu awa kotumuro giu. Nukare asina araira bua oko inowera. Noko nukare mo gayaira bua oko inowera. Ata na nimorekare tona ewa. Gita ema tua Solomon meni tama nuso simena-gaena wero baititinoisonua, ata simena-gaena wai nuso meni ni uzira simai awa oko daininua. ");
INSERT INTO sue_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ni uzi zeme ware ena ewanana ditinoya, ata auma awa erama meni wezero moyamunora awa. Ata saineba, Anutu meni sawi simai ewananare kei awero Solomonra simai ewanana awa dainitinowia. Anutu meni ago inowia, are nu nogoro nikare mo tama woi kaka tamamu wamunoi? O tuma diai besaire nikare, nu nikare tama woi ewa-awanana tamamunoya. ");
INSERT INTO sue_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Are nikare kotumai saisai nena naire oure amira oko wawe. Nikare duba eto oko wawe. ");
INSERT INTO sue_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Zebu emira diga ema nukare kotumai saisai nena eni tamaira inowera awa. Ata Mama nisokare meni nena nawise inowia awa gosinowia. ");
INSERT INTO sue_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ewanana nikare Anutura nuai seka tamamu kotumawa nu amira tame nena enire dai nimorekare potamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Dubu pei-kaka nikare, nikare azu oko wawe. Mama nisokare meni nuai seka nimorekare potamu ge diditaya. ");
INSERT INTO sue_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nikare nena nisokare dapikarago zumara potiro moni pumuro moni awa ema bogamasa soremuro numorekare potiu. Nikare moni sisai ine tepo awa tamamu wewo. Ago inoise nuawa Anutu meni utura ena nena ewa-gaewa sisai ine tepo awa nikare emo dubu damunoya. Bewana ema utura zorage mai ine tepo awa. Ota ana nena diko kaka damu inowia. ");
INSERT INTO sue_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Masi wau niso itewia, masi da amira duba niso itamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Nikare ipu sapi diro amire lam nisokare gaero sia wero itiwo. ");
INSERT INTO sue_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Soumai eni nukare ema tua nusokare meni ana-bona doro ewesemuro so be dai eya piamu itera ago ine nikare itiwo. ");
INSERT INTO sue_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ota ema tua meni muro soumai nuso kaka gitawa wamu seka zisero itara gamunoya, awa nukare yawa sara wamunora awa. Na me memeka nimorekare sane. Ema tua nu nutope soumaira mo nena sawaira awa wosuniro nukare tebolra arumarise samunoya awa. Ago wara nu nutope muro nena nai numorekare potamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ota nu pi soe sieniro mamunoita pi tumore amire muro soumai seka zisero itara gamunoya, awa soumai nukare yawa sara wamunora. ");
INSERT INTO sue_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ota nikare nena ei awa kotumuwo: Sora mama meni bewana ema maira be nuso gamia, awa nu seka zisero itise so nuso dia wero baitai bewana ema oko toyamia. ");
INSERT INTO sue_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na Emara Mai meni mamunona, awa na oko mamunona ago tuawa be amire na mamunona. Ami emo nikare sia inoise noiwo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petoro meni Yesure ego senua awa, “Tua, ge bezai namorekare dabata ema bama dapikarago amire tosi?” ");
INSERT INTO sue_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ago senu Tua meni ego senua awa, “Nikare soumai kokopai wero noiwo. Soumai kokopai nu kotumai ewanana puro nuai giro ema tua nuso meni nu soumai nuso dapikarago dia waise samunoya. Nu nukare dia inoise wo ma numorekare potitinuaise samunoya awa. Ema tua nuso meni bua ge awa numore potiro doro baro nuamunoya. ");
INSERT INTO sue_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Are soumai ami bua numore sai awa te dipinoise nuai, ema tua nuso meni ewesemuro bua nusora me giro tani kokopai numore wai yawa sara wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na me nimorekare tona awa. Ema tua nuso meni dia wai bua bamu numore potitinoise nena nuso bamubamu dapikarago dia waise samunoya. ");
INSERT INTO sue_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ota soumai duba nuso meni ego samunoya awa, ‘Ema tua naso meni eya oko ewesemamunoya. Noma ama ewesemamunoya.’ Ago toise sou wai bua emare bamere dero usi-besi inoise ana-bona wise ou zewai nise awinoise dau wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ago inoise noma ema tua ewesemaira be nuso kaka gamu inoise, ‘Nu eya oko ewesemamunoya,’ ago toise nuai ema tua nuso meni ewesemuro mamunoya awa. Muro soumai awa pena-pana wezero dero ema tuma diai tepo ina tamamunora masi da amira potamunoya. ");
INSERT INTO sue_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Soumai nu ema tua nusora bua ge gosinowia, ata nu nena kaka sia wamu, o ema tua nusora bua ge awa kaka dimamu wamunoya, awa ema tua meni nu waya me waya damunoya. ");
INSERT INTO sue_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ata soumai nu ema tuara bua ge awa kaka gamu inoise ina waya tamaira nena wamunoya, awa ema tua nuso meni nu pei-kaka gege damunoya. Ema zore nena bamubake potamunora, awa nu ina bamubake potaise samunora. Noko ema bama meni ema zora wanera nena witai potamunora, awa nu ina witai-bake potaise samunora. ");
INSERT INTO sue_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Na muna, awa zebu niao meni gurunana awaise muna. Are eya awaise ago kotupitinona. ");
INSERT INTO sue_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na yaya tame nuanise sai itia, awa ou wama muro zebu topetitinoya ago ine yaya meni na topetamunoya awa. Zeme na yaya amira bua kaka wamu, ata moka naso meni awa mou-mau inoya awa. ");
INSERT INTO sue_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nikare nane muro zebura dumu-zuzuna ge dana betaise kotupitinowewi, tanita. Ata awa tepo awa. Na nimorekare sane. Na muna, awa ema bama zazaumamu muna awa. ");
INSERT INTO sue_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Zeme emireta ama omire ema bama wana da so dara itamunora, awa zaumuro dubu eto wamunora. Etorobara awa iwo etore wamunora. Ota eto awa iwo etorobarare wamunorato awa. ");
INSERT INTO sue_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nukare ego ine zazaumamunora: Mamato mai mata nusore nuto iwo ina-wa wamunorato; miato mai bama diri nusore nuto iwo ina-wa wamunorato; maira arato imeti-gagarare nuto iwo ina-wa wamunorato awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu meni ema bamere ego dai senua awa, “Nikare bereze inagayai dopawi giro eya ego towewa awa, ‘Wa wamu wetia.’ Ago sawewa wa inowia awa. ");
INSERT INTO sue_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Da ago ine so gori ziwawi giro nikare ego towewa awa, ‘Auma waiko bamu witamunoya.’ Ago sawewa me inowia. ");
INSERT INTO sue_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nikare opi ema me sao inowewa! Nikare ema zebure poragara owere giro baitai awa. Ata nikare nogoro be zeme emira susu kaka giro baitamu inowi? ");
INSERT INTO sue_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tani ewanana wawise sai awa nikare nitopekare nogoro kaka samuro gamu inowewi? ");
INSERT INTO sue_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Otao niso zo meni ni gera potiro kotora bayasise samunoya, awa ni bere-bere numore dai kaunsol nana baro ge awa sero kora wewoto tepo wae. Ago kaka wamu wamunosa, awa nu ni puro zas emara nana bayai zas ema meni ni poti polis nana nai nukare ni poti benai sora namunora. ");
INSERT INTO sue_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na nimore sane. Ni benai so tepo oko duamunosa. Ni gita otao nisora dinau dapikarago potiro tepo wero amire kei damu namunosa awa.” Yesu meni nakai ge nuso bere-bere ninanisekai ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Be amire ema eni meni Yesu nana kei awero ego sewa awa, “Galilaya ema eni meni wo dero azero puro Anuture zame potamu sero inora amire Pilato meni ge sesi goroba ema eni baro Galilaya ema awa detera betetera orara nusokare zamera tame zozisia awa.” ");
INSERT INTO sue_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ago sewa Yesu meni ina ego senua awa, “Nikare numorekare ego towi, tanita, ‘Pasina nusokare meni ema enira pasina dainiro itia, are ago ine betisera awa.’ ");
INSERT INTO sue_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ata tepo me tepo awa. Nikare duba kaka kapetenamu wamunowa, awa nikare dai sisamunowa awa. ");
INSERT INTO sue_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ata ema 18 gita Siloam so ike wai ami gowero du tame niro denu bebeteniwa, awa pasina nusokare meni ema eni Yerusalem itisowa amira pasina nusokare daininua amira betewa awa, ago towewi, tanita. ");
INSERT INTO sue_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ata tepo me tepo awa. Ata nikare duba kaka kapetenamu wamunowa, awa nikare dai sisamunowa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu meni ge bezai zo ego senua awa, “Ema zo gita ni fik awa notu nusora ena urenu itisonua. Iteye donu nu me eni tamamu munua, ata tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ago giro giro bua mai nusore ego senua awa, ‘Sana giyo. Na muro ni fik me pamu kau inoise noe dotena zepa etorobara tepo wataya. Are zese tepo wae. Nera kota, ni ami zebura gawi puro tepo inowia.’ ");
INSERT INTO sue_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ago senu bua mai meni ge ina numore ego senua awa, ‘Ema tua, ni doyo itai zepa emira mokara ena na zebu ni susura dero baro ga puro muro potiro awana wai gane. ");
INSERT INTO sue_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Zepa ama omire me ziamunoya, awa ewanana awa. Ata me kaka ziamu wamunoya, awa sasa zesamunona.’” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat pura zore Yesu meni ema bama yere ibura ena ge tugata inoinua. ");
INSERT INTO sue_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ata bama zo itinua, awa bi zo meni nuso nana mokara itise yaya numore potinu waya wero iteye donu zepa 18 tepo wenua. Are bama awa tipa sosai, are nu kaka dopero baitamu noisonua. ");
INSERT INTO sue_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Are Yesu meni bama awa giro zawa senu munu ego senua awa, “Bama, yaya niso tepo wetia.” ");
INSERT INTO sue_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ago sero wana poti bamera nana tamara ninu tipa nuso eya sonenua. Ago wenu bama ami Anutura zazo de ike ninua awa. ");
INSERT INTO sue_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ata yere ibura giti kopi ema nu tini kapai Yesure pumunua. Nera kota, nu Sabat pura amire bama awa kora wenua. Are giti kopi ema meni ema bamere ego senua awa, “Bua waira be 6 itia. Are nikare be amire muwo korawae. Ota nikare pura bere ena ago oko wero awawe.” ");
INSERT INTO sue_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ago senu Yesu meni ge ina ego senua awa, “Nikare opi ema me sao inowewa! Nikare dapikarago Sabat pura amire bulimakaota donki nisokare sora benawewa itewera awa besero puro bayawewa ou ninowera, atonua! ");
INSERT INTO sue_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ata bama ei awa nu Abrahamra sibuna zo, awa Satan meni emoko beninu zepa 18 ago tepo wenua. Are na nu pura be emire besesena awa nogoro gewa waya inoi?” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ago senu iwo ema nuso awa meniwa awa. Ago wewa ema bama meni nena dapikarago ewanana wenua amira yawa sara wewa. ");
INSERT INTO sue_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu meni ge zo susumuro ego senua awa, “Anutu imata Tua wero nuamunoya amira susu awa nena ne ine ni? Na nera potiro samunoni? Nu awa ni zo mastet asinowenakai amira me ine awa. ");
INSERT INTO sue_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ema nukare mastet me kiaka mai zo puro baro bua nusokarera urinowera. Awa ama baziro bamubake wero ni zo ine inowia. Ago wawi ni mamai muro ni amira bonara zau potitinowera.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ago sero noko ego senua awa, “Anutu imata Tua wero nuamunoya amira susu awa na nena nera potiro samunoni? ");
INSERT INTO sue_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Awa yis ine. Bama zo meni tewa bamu zora plaware yisre potiro dawenu yis sisiniro plawa pumunu dobu wenua.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu meni Yerusalem bayamu sero susawise nata babezinomata pei-mamai ni amira te noise utura ge tugata-magata inoise bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ago wero susaunu ema zo meni numore ego senua awa, “O Tua, Anutu meni mai etokaka gege soero pumamunoita?” Ago senu Yesu meni numorekare ina ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nikare utura so be pei-kaka amira toyamu sero di tata wero wetu wana ziwo zewai wai kosobuniro toyawe. Na nimorekare me tona. Ema dainiro meni ago toyamu wamunora, ata te oko wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ama so amira Mama nu eriro so be awa gazai amire nikare muro damu dopero so be dero zawa sero ego samunowa awa, ‘Tua, ni so be namorekare pie.’ Ago sawa nu ge ina ego samunoya awa, ‘Nikare na-ami ni? Na kaka gamu inona.’ ");
INSERT INTO sue_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ago sai nikare ego samunowa awa, ‘Nakare gita nimore dai nenare oure tewa dara ninoisonakai awa. Ata gita ni nata nasokarera dopero nakare gipinoisosa.’ ");
INSERT INTO sue_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ago sawa nu nimorekare ego samunoya awa, ‘Nikare na-ami ni? Na kaka gamu. Nikare awa pasina ema. Na doro bamuu!’ Ago samunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nikare giu. Abrahamra Isakara Yakobora ata porofete dapikarago Anutu nana mokara itara gamunowa, ata nikare esenara nikare damu itise di zawa gatero zarinoise itamunowa. ");
INSERT INTO sue_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ema bama agewa waiko witairata waiko osaira, ota iketa bage amira ana muro Anutura nate toiro arurumuro nena namunora. ");
INSERT INTO sue_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ota ema gita inora amira nana eni meni ama wamunora. Ata ama inora amira nana eni meni gita wamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yesu meni ago toinu be da amire Farisayo eni meni kei awero numore ego sewa awa, “Herode meni ni damu toya, are ni nata ewa doro agewa zora bayase.” ");
INSERT INTO sue_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ago sewa Yesu meni numorekare ego senua awa, “Nikare baro abu suna waya amire ego sawe: Zeme ata auma awa na bi esenamunona. Ago wero na yaya ema kora wamunona. Ago wero auma itimakai waiko zo omire na bua naso pesunamunona. ");
INSERT INTO sue_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Zeme ata auma ata noko auma amire awa na aita wero Yerusalem bayamunona. Nera kota, nukare porofete Yerusalem nate ena gege dara betai te wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Yerusalem ema bama, Yerusalem ema bama. Nikare porofete dawewa betinowera. Noko ge ema Anutu meni nisokare nana potawi susawewera nukare awa omata meni dawewa betinowera. Kokara mia meni mai awiso nuso wabu duru potiro sanitinowia, da ago ine nane ema bama nikare poti dara namu wawena nikare azu towewa. ");
INSERT INTO sue_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Anutu meni nata nisokare dotinoya, awa giu. Noko na ge zo sana niniu. Nikare na kaka gamu inoise noma ego toise amire na noko gamunowa, ‘Tuara bera tupia, nu awa bowi wanekai.’” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat pura zore Yesu meni baro Farisayora ema giti kopi zora nana sora ena nena naira itinu nu Sabat purara be sisai gamu dia itiwa. ");
INSERT INTO sue_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ata ema zo tama nukai awa Yesu nana zorage kei awenu ginua awa. ");
INSERT INTO sue_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Giro nu lo ge gipai emare Farisayore ego senua awa, “Nakai ema yayare awa Sabat purare kora waunikaita tepo ni?” ");
INSERT INTO sue_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ago senu nukare ge agu itiwa awa. Ago wewa giro nu ema awa puro kora wero iyetinu bamunua. ");
INSERT INTO sue_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ago wero numorekare ego senua awa, “Ota nisokare nana ema zo nu mai nuso zota bulimakao zo Sabat purare ou ura wamai amira dagimai numa awita sero zumanoita?” ");
INSERT INTO sue_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ago senu nukare ge ina sai ine tepo wewa. ");
INSERT INTO sue_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu nu ema nena namu muwa awa ginua: nukare nena bamu namu ara tamuwa. Ago wewa nu numorekare ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nima ema zo meni ataira ana-bona wero ni zawa sai baro nena bamu oko puro nase. ");
INSERT INTO sue_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nena bamu puro namunosa, awa ema zo zazo bamure kei awai amire bonara mama meni nena bamu puro muro ni dainiro ema zazore amire potamunoya. Ago wai ni me bamu nitinoise usero itamunosa. ");
INSERT INTO sue_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ata ema zo ni nena naira zawa samunoya, awa ni baro nena pei-kaka gege puro niyo. Ago wasa amire bonara mama meni muro nimore nena mema potamunoya. Ago wai amire ema nena ninoise itera ami ni gara ema zazore wamunosa. ");
INSERT INTO sue_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Zo nu nutope tama puro witamunoya, awa Anutu meni nu puro osamunoya. Ata zo nu osero nuamunoya, awa Anutu meni zazo nuso de ike namunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu meni ema numa muro nena naise zawa senua amire ego senua awa, “Ni nena pei-kakata nena bamu wero ema uzamamu wero giro otao mamaita namisinita didikaita nebu eni waure nukare awa oko zawa sase. Ago wasa nukare ami ama ina zawa sara ni baro so nusokare nana ena nena nasa ina niso tepo wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tepo awa. Ata ni nena bamu wero giro ema bogamasata ema tama waya waita te dimaita giti guma wai nukare awa zawa seyo. ");
INSERT INTO sue_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ema ago ine wewenai ami nena niso ina wai ine tepo awa. Are ni yawa sara wamunosa. Ama ema ewanana betaira ena eramunora be amire Anutu meni nena niso ina potamunoya awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ema Yesure dai nena ninoise itiwa amira nana zo meni ge awa niniro numore ego senua awa, “Zo nu Anutu imata Tua wero nuamunoya amira natara ena nena namunoya ami yawa sara wamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ago senu Yesu meni uge zo numore ego dinua awa, “Ema zo nu ana-bona bamubake wamu inoise be potiro erama dainiro marise senua awa. ");
INSERT INTO sue_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Are ana-bona waira be munu soumai nuso zo iyetinu ge puro baro ema gita marise ge potinu bamunua amira nana baro numorekare ego senua awa, ‘Nikare muu. Nena dapikarago sia wetenakare tepo wetia.’ ");
INSERT INTO sue_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ata nukare dapikarago ami eriro esega buara wewa. Ago inoise ema zo numore ego senua awa, ‘Na mamena, ata na zebu seka zo zuma gaetena tepo wetia, are na baro gamunona. Ni baro ema tua nisore sasa gai waya oko wae.’ Ago senu zo da ago senua awa, ");
INSERT INTO sue_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","‘Na mamena, ata na bulimakao wana eto bua wamu zuma gaetena, are na baro wo amira bua wero gamunona. Ni baro ema tua nisore sasa gai waya oko wae.’ ");
INSERT INTO sue_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ago senu zo meni ego senua awa, ‘Na zeme-zemeke bama seka atena, are na mai ine tepo.’ ");
INSERT INTO sue_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ago sewa bua mai ewesemuro baro ema tua nusore senua. Ago senu sora mama meni awa tini kapenu bua mai nusore ego senua awa, ‘Ni eya nata bamura ebata babezinomare pei-mamaire amira baro ema bogamasata ema tama waya waita ema giti guma waita ema te waya wai nukare awa puro mu so naso emira toyare.’ Ago senu ama bua mai meni ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","‘Tua, na ge niso dimuro pesunena, ata apamo eni tepo dago itera.’ ");
INSERT INTO sue_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ago senu ema tua meni bua maire ego senua awa, ‘Ni nata bamu amira atune baro ebata pei-mamai nata sero bayai amira ana ema bama uzumuro puro masa toyara so naso be mae. ");
INSERT INTO sue_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na nimore tona. Ema dapikarago gita zawa sisena ami ana-bona naso amira muka zo oko namunora.’” Yesu meni uge awa diro tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ema bama dubu bamubake nukare Yesure dai aita wero susaumite amire Yesu meni ewesemuro numorekare ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ema zo naso nana muro namore dai nuamu wero giro nu mia mama ata bama mai awisore ata namisini nubabumanare noko nuai nuso dai awa kaka poti atune namu wamunoya, awa nu mai naso wero nuai ine tepo. ");
INSERT INTO sue_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Zo nu duba naire yaya tamaire amira ni pasinai nuso dimuro na kaka ama ganamu wamunoya, awa nu mai naso wai te oko wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nisokare nana zo meni so bamubake zo wamu wero giro nu gita arumuro zuma sora kotumuro moni nuso giro ego samunoya awa, ‘Moni naso te werota te kaka wamu ni?’ Awa nu gita ago kaka wamu wamunoya, awa ama nu zasiwi potiro so awa wero tepo wai ine tepo ago wai amire ");
INSERT INTO sue_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ema dapikarago ami nu giro sero ziamunora. ");
INSERT INTO sue_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ago inoise numore ego samunora awa, ‘Ema awa so awa zaawetia ata nu oko wero tepo wamunoya.’ ");
INSERT INTO sue_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ema tua zo meni ema tua zore bogi wamu wero giro gita arumuro ego kotumamunoya awa, ‘Soldia naso 10,000 ami iwora soldia 20,000 amire dai bogi wara te wamunoita tepo ni?’ ");
INSERT INTO sue_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ago kotumuro gai te kaka wamu wai giro iwo asike dago itara amire nu bega pumaira ge bua wamu sero mai zo iyetai iwora nana bayamunoya. ");
INSERT INTO sue_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Are nisokare nana zo meni nena nuso poti atune kaka namu wamunoya, awa nu mai naso wai te oko wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ima awa nena ewanana. Ata ima mege tepo wamunoya, awa nakai nogo wanakai amira mege nuso noko kei awamunoi? ");
INSERT INTO sue_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ima ago ine ami zebu gawi potai ine tepo. Ota noko ima awa zebu gawi potaise nanekai bulimakaora ze amire dai dubu danakai te oko wamunoya. Nakai tepo apitinowenakai awa. Zo nu danare meni ge awa ninaise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takis pumai emare pasina emare nukare witai ami ge ninamu Yesu nana zorage muwa. ");
INSERT INTO sue_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ata Farisayo ata ema lo ge ninaire ami Yesure giwa waya wenu gugumara diwinoise ego sewa awa, “Ema awa nu pasina emare otao inoise nena dara ninoise nowera.” ");
INSERT INTO sue_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ago sewa giro Yesu meni ge bezai numorekare ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nisokare nana ema zora lama 100 amira zo tara awamunoya. Are lamara mama ami lama 99 awa duai nena ninoise agewa zora itara nu lama tara awisia awa tamamu sero bua wamunoya. Bua wero susauma tamuro ");
INSERT INTO sue_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","puro poti gape niro yawa sara inoise puro ewesemuro mamunoya. ");
INSERT INTO sue_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Puro muro so nusora kei awero otao nuso ata nata da nuso awa zawa sai nuso nana mara amire numorekare ego samunoya awa, ‘Na lama naso zo tara awisia awa tamuro puro mena, are nikare namore dai dara tairo yawa sara weu.’” ");
INSERT INTO sue_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesu meni uge awa diro ego senua awa, “Na nimorekare tona. Ema 99 ewanana nonakai asinoise duba kapetenaira kaka kotumamu nuara utura ena nukare emo yawa sara bamubake oko wamunora. Ota pasina mai daimata ami duba kapetenai amire nu emo utura ena yawa sara bamubake wamunora. ");
INSERT INTO sue_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ota bama zo nu 10 kina nuso nana itai zo ama tara awamunoya. Ago wai nu lam gaero amire so wazero kau inoma tamamunoya. ");
INSERT INTO sue_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tamuro pumuro amire otao mamai ata nata da nuso awa zawa sai nuso nana mara numorekare ego samunoya awa, ‘Omata naso zo tara awisia awa kau inomite tamuro pena, are namore dai dara tairo yawa sara weu.’” ");
INSERT INTO sue_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yesu meni ago sero ego senua awa, “Na nimorekare tona ewa. Ago ine Anutura angelo meni pasina ema zo duba kapetenawi yawa sara inowera awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu meni ego senua awa, “Ema zora mai mata diri eto noisowato. ");
INSERT INTO sue_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Are mai ama-zimi meni mamere ego senua awa, ‘Mama, omata nena niso ama kanowero namoreto potamunosa amira agewa namore sai awa zeme namore poti.’ Ago senu giro mama nena kanowero numoreto potinua. ");
INSERT INTO sue_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Potinu borere tepo ma ama-zimi meni nena nuso dapikarago dara potiro puro zebu zo zora-zarako amira baro noisonua. Nu ago itise tama puro witiro omata tebe-tabe sisero tepo wenua. ");
INSERT INTO sue_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Are nena nuso tepo-tapo wenu amire dora botiyo bamu zebu amira ana kei awenua. Ago wenu nu nena kau wenua. ");
INSERT INTO sue_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Are nu baro zebu amira mama zora nana ena bua pumunua. Ago wenu ema ami nu potinu bamu zebu nusora niro pu dia inoisonua. ");
INSERT INTO sue_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Are nu pura ma naira kotumunua. Ata ema meni nena zo numore kaka potamu wewa. Ago wewa amire nu duba kapeteniro ");
INSERT INTO sue_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ego senua awa, ‘Mama nasora bua mai dainiro nora ami nena tame nora. Ata nane meni awa ego itise meri waya betinona. ");
INSERT INTO sue_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Saineba, na eriro mama nasora nana baro numore ego samunona awa, ");
INSERT INTO sue_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","“Mama, na gita pasina Anuture wero nimore wisena. Are zeme na nogo nogo wero mai niso wamunoni? Nine na zawa sero mai naso oko samunosa. Ni na pumasa soumai niso gege nuane.” Na mamere ago samunona.’ ");
INSERT INTO sue_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ago sero eriro mamera nana bamunua awa. Nu tupinu mama meni nu asike ena ginua. Giro zo amuro sumuro baro mai nuso saniro imunua awa. ");
INSERT INTO sue_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ago wenu mai meni numore ego senua awa, ‘Mama, na gita pasina Anuture wero nimore wisena. Are zeme mai naso ago namore oko sase.’ ");
INSERT INTO sue_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ago senua ata mama meni bua mai nusore ego senua awa, ‘Ei awa mai naso me, are nikare tama woi koko-kakopai awa eya puro muro numore wosunawa pumae. Ago wero wana sisino nusora bubuna zo potawe. Ago wero sandol te nusora wosuniu pumae. ");
INSERT INTO sue_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ago wero bulimakao mai tama gawire awa puro muro deu ninoisekai yawa sara wanekai. ");
INSERT INTO sue_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nera kota, mai naso ewa betisia asinoise nowena ami kei awetia. Ota mai tara awisa awa zeme tamena.’ Ago senu nukare zaawero yawa sara wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ata mua mai nuso nu bua inoise noinua. Are nu buye ena tupimite so atune kei awero yawa wiinoiwa awi niniro ");
INSERT INTO sue_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","bua mai zo zawa sero atata wenua awa, ‘Tani owa nogoro inori?’ Ago atata wenu ");
INSERT INTO sue_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","bua mai meni numore ego senua awa, ‘Nami niso mia, amira mama niso meni bulimakao mai tama gawire zo detia. Nera kota, mai nuso tera pumi neine itia.’ ");
INSERT INTO sue_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ata mai mua mai awa tini kapenu baro sora toyai azu sero donua. ");
INSERT INTO sue_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ago wenu mama meni kei awero muro korawai bua inoise nu uzutinua awa. Ago wenu nu ge ina mamere ego senua awa, ‘Na zepa nazo niso nana sou bua inoweni? Na ge niso nazo doiseni? Ata nama otao mamai nasore yawa sara wanisekare wo zo da di namore kaka potamu inowesa. ");
INSERT INTO sue_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ata mai niso awa nu eba bamere noise nena niso sisero tepo wisia. Ago wero nu ewesemuro mi amire ni nu kotumuro sesesa bulimakao mai tama gawire zo dero azinora atonua!’ ");
INSERT INTO sue_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ago senu mama meni ego senua awa, ‘Bou, nage be giti dara itewenage, are nena naso bamu awa niso gege awa. ");
INSERT INTO sue_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ata zeme nakai yawa sara wanakai moka nasokai ewanana waise. Nera kota, nami niso betenua ami seka wero eria. Nu tara awenua ami kei awetia. Are nu emo yawa sara inonakai te inoya.’” ");
INSERT INTO sue_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu meni bua mai nusore ego senua awa, “Wau ema zo nu nena nuso awa mai zore senu dia inoisonua. Dia inoinu ema eni meni wau emare ego sewa awa, ‘Dia wai mai niso meni nena niso siso siso inowia.’ ");
INSERT INTO sue_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ago sewa niniro mai awa zawa senu munu numore ego senua awa, ‘Ni nogo nogo inosa ge niso sesera nineni? Ni bua naso dia wai ine tepo, are ni baro bua inowesa amira ge gayai puro muro gipasa gane.’ ");
INSERT INTO sue_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ago senu dia wai mai duba meni ego kotumunua awa, ‘Buara mama meni bua soyai amire na nogo wamunoni? Na bua mou-mau wai ine tepo, noko na nena emo emare isa samena, awa na me namena. ");
INSERT INTO sue_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ota buara mama meni na esenai amire erama eni meni namore otao wero na so nusokarera uzumuro kora warise sero na tani zo wamu kotupitinona.’ ");
INSERT INTO sue_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ago sero nu ema eni dinau nusokare nuso nana itinua nukare awa imata-kamata zawa senu da da bamuwa awa. Are nu zore ego senua awa, ‘Ni dinau nazo buara mama naso amira nana iti?’ ");
INSERT INTO sue_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ago senu nu ina ego senua awa, ‘Kerosinra daramu kikinaka 100.’ Ago senu nu senua awa, ‘Nenara doket niso ewa. Are eya arumuro 100 disero 50 gae.’ ");
INSERT INTO sue_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ago sero ema zore ego senua awa, ‘Dinau naso nazo niso nana iti?’ Ago senu nu senua awa, ‘Bek wuit 100.’ Ago senu nu numore senua awa, ‘Ni nenara doket niso puro 100 disero 80 gae.’ ");
INSERT INTO sue_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Are buara mama meni dia wai mai tani wenua amira susu ginu ema kotumaire meni wago wenua, are nu mai awa bowi wenua. Awa nera kota, zebura nena emo duba-duba inowera ami otao mamai nusokarere dai noise ema kotumaire meni wago inowera. Ota utura zasimai emo duba-duba inowera nukare ami zebura nena emo ema kotumaire meni wago kaka wamu inowera. ");
INSERT INTO sue_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na me memeka nimorekare tona: Nikare moni waya meni otao-gamao wewo. Ago wawa ama moni puro nuaira be tepo wai amire nukare nikare puro so itai gege amira potamunora. ");
INSERT INTO sue_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ota zo nu nena pei-kaka dia wero baitamunoya ami da ago nena bamu zo dia wero baitamunoya. Ota zo nu nena pei-kaka amira bua kaka wero baitamu wamunoya ami da ago ine bua bamu zo awa kaka wero baitamu wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ota nikare moni waya zebu emira awa dia waya-waya wamunowa, awa agai nena me nimorekare potai dia wamunowi? ");
INSERT INTO sue_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ota nikare nena ema zora awa dia kaka wero baitamu wamunowa, awa agai nena nisokare potai pamunowi? ");
INSERT INTO sue_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ota mai daimata meni dia ema etora nana sou bua oko wai te wamunoya. Awa nu zo otao inoise zore iwo wamunoya. Ota noko zo tuma didinoise zore biawa wamunoya. Nikare da ago ine Anutura sou bua ata wau monira sou bua awa eto dago wai ine tepo awa.” ");
INSERT INTO sue_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisayo nukare moni emo duba-duba inoisowa are Yesu meni ge senua awa niniro ge nusora sero ziwa. ");
INSERT INTO sue_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ago wewa nu numorekare ego senua awa, “Nikare zazo nisokare emara nana giti mokara ewanana waise inowewa. Ata Anutu meni moka nisokare gosinowia. Nena ema meni gawera ewanana inowia awa Anutu meni gawi nena waya me waya inowia. ");
INSERT INTO sue_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mosera lo gere porofetera ge awa zewai wero iteye donu Yohane kei awenua amira ana tepo wenua. Tepo wenu ana zaawero Anutu imata Tua wero nuamunoya amira Oziga Ewanana sero tupewera. Are ema dapikarago Anutura natara bayamu zewai-zawai inowera. ");
INSERT INTO sue_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Uture zebure amira be pesunamunoya awa nena peu gege. Ata lo gera owe mai pei-kaka zo awa duai ine tepo. ");
INSERT INTO sue_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ema zo nu bama nuso doro bama seka atamunoya, awa nu bama bewana wetia ago ine wamunoya. Ota ema zo nu bama ema zo meni gita atiro donua awa atamunoya, awa nu dai bama bewana waira pasina wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Gita wau ema zo noisonua. Nu tama woi owere ewa-gaewa pupinoise noisonua. Ago inoise waiko be sero ana-bona inoise yawa sarare noisonua. ");
INSERT INTO sue_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Are so be nusora nana zorage awa ema bogamasa zo arumuro ereniro itisonua, zazo nuso Lasaro. Tama nuso boya meni nai. ");
INSERT INTO sue_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nu nena mumuka wau emara tebolra ena osasai puro namu inoisonua. Ago itasai suna mamai meni muro boya nuso sewinoisowa. ");
INSERT INTO sue_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Are ama ema bogamasa awa betenu angelo meni puro baro Abrahamre dai dara potiwa itinua awa. Ago wenu amire wau ema betenu gowewa awa. Gowewa nu dega niaore amira itise yaya bamu tapinoisonua awa. ");
INSERT INTO sue_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ago inoise iri niro Abraham zora-zarako itinu Lasaro meni awa zorage numore dai itinu ginua awa. ");
INSERT INTO sue_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ago wero nu zawa gatero ego senua awa, ‘O mama naso Abraham, ni na emo zo amuyo. Ni Lasaro iyeti wana sisino dumu nuso oura patiro puro muro potai iwawa naso zobi pei-kaka wae. Na niao meni awinoi yaya waya tapinona.’ ");
INSERT INTO sue_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ago senu Abraham meni ina ego senua awa, ‘Mai naso, ni gita seka noise zamaire itise nena ewa-gaewa pupinoise noisosa. Ota Lasaro meni awa nena waya-kawaya pupinoisonua. Are zeme nata emira ena nu itai nuso ewanana tamuro itia. Ago inoi ni yaya tapinoise itesa. ");
INSERT INTO sue_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ata awa daba kota, nena zo dai itia. Nisokare nana ata nasokare nana soe aiwa bamu itewia. Are ema nukare ego itewera ami aiwa awa zausemuro nisokare nana bayamu wara te oko wamunoya. Da ago ine ema agewara itewera ami aiwa zausemuro nasokare nana mai ine tepo awa.’ ");
INSERT INTO sue_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ago senu wau ema meni ego senua awa, ‘Mama, ago amira na ni zawa tona. Ni Lasaro sasa mama nasora nana sora bayaise tona. ");
INSERT INTO sue_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Na namisini naso wana da itera. Awa Lasaro meni baro ge zewai-zawai numorekare saise nukare inoma masi emira muro yaya bamu tamai azu tona.’ ");
INSERT INTO sue_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ago senu Abraham meni ego senua awa, ‘Nukare Mosera ge itia, o noko porofetera ge itia, are nukare ge awa ninarise.’ ");
INSERT INTO sue_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ago senu wau ema meni ego senua awa, ‘O mama naso Abraham, tepo awa. Awa te kaka wamu awa. Ata betai zo meni bi ditira ena eriro baro nusokare nana kei awero ge sai duba kapetenamunora awa.’ ");
INSERT INTO sue_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ago senu Abraham meni ego senua awa, ‘Nukare Mosera geta porofetera ge kaka ninamu wamunora, awa ema zo meni bi ditira ena noko eriro baro ge sai gara me oko wamunoya.’” ");
INSERT INTO sue_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu meni bua mai nusore ego senua awa, “Pasinara uzutai eure-taure ami kei awero ema bama uzutai pasinara duwamunora. Ata zo nu ema bama pasinara uzutamunoya ami waya waise. ");
INSERT INTO sue_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ema ago ami mai kiaka zo uzutai pasina tamai azu, nikare bere-bere omata bamubake zo ema amira nana dube kimeniro ewa surura musunawa dagimai te wamia. Nera kota ema ami pasina kaka wamure oura dagimuro betamunoya, awa nena peu gege. Ota nu pasina wai amire Anutu meni ina potamunoya, awa nena mou-mau. ");
INSERT INTO sue_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nikare nitopekare dia wero baitiwo. Otao niso pasina wai giro ni nitope nu seneyo. Noko nu duba kapetenai giro ni dai pasina nuso doyo. ");
INSERT INTO sue_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Noko nu pasina nimore be 7 ago waiko da amire wamunoya, ata nu noko tera ewesemuro nimore samunoya, ‘Na duba kapetenitinona.’ Ago tuai be 7 wai saineba ni pasina nuso duamunosa awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposolo meni Tuare ego sewa awa, “Ni tuma diai nasokare ziasa zewai waise.” ");
INSERT INTO sue_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ago sewa Tua meni ego senua awa, “Tuma diai nisokare awa ni me kiaka zo ine eriro bamu wamia, awa nikare ni bamu omire ego ine samewa awa, ‘Ni ena sokero baro ewa soe ena dopero erase.’ Ago sawa ge nisokare dimamia awa. ");
INSERT INTO sue_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Agoro nisokare nana mai sou zo ma bua inomata bulimakao dia inoma tuwe noko ewesemuro mu nate nai dia nuso meni ego samunoita, ‘Ni eya mu arumuro nena nase.’ ");
INSERT INTO sue_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tepo awa. Nu numore ego samunoya awa, ‘Ni nena nai naso sia wero mo kapawai awero amire nena nai naso dumuro puro mu. Na nena nana denai amire ni ama nena nase.’ ");
INSERT INTO sue_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Agoro soumai meni bua numore sai awa wai amire dia nuso meni kokopai numore samunoita? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Susu nisokare da ago ine itia. Anutu meni bua nimorekare potinua awa wero pesuniro amire ego seu, ‘Nakareka bua mai meya tosa. Bua namorekare sai awa gege wetenakare.’ Ago sewo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu nu Yerusalem bayamu sero ebete aita wero Samaria zebura ata Galilaya zebu amira soe susaumite ");
INSERT INTO sue_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","kei nata zora ninua. Ago wenu ema boya ayare wana eto ami muro nu ebete ena tamuwa. ");
INSERT INTO sue_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nukare aikera dopero zawa sero ego sewa awa, “Yesu, ema tua, ni nakare emo zo amuyo.” ");
INSERT INTO sue_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ago sewa nu nukare giro ego senua awa, “Nikare baro tama aiso nisokare pris nana gipeu giro ewanena wetewa asare.” Ago senu nukare aita wero susauwa tama aiso nusokare ewanana wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ago wenu nusokare nana ema zo meni tama nuso ewanana wenu giro arero Anutura zazo bowire poti ike nitinoise ewesemunua awa. ");
INSERT INTO sue_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ewesemuro bamuro Yesu nana tera bawa diro benau poti zebura niro kokopai numore senua. Nu awa Samaria ema awa. ");
INSERT INTO sue_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu meni awa giro ego senua awa, “Na ema wana eto kora wetena ewanana wetera, ata eni 9 awa nago iteri? ");
INSERT INTO sue_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Agoro ema 9 dago ewesemuro Anutura zazo bowire de ike nai sogo awa, ema Yudako ami imata gege mia ewa.” ");
INSERT INTO sue_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ago sero numore ego senua awa, “Ni eriro bamu nuase. Tuma diai nisora ni ewanana wetesa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisayo meni Yesu atata wero sewa awa, “Be nere Anutu imata Tua wero nuamunoi?” Ago atata wewa Yesu meni ge nusokare ina ego senua awa, “Anutu imata Tua wero nuamunoya amira be awa eramara giti moka meni gai ine tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Noko nukare ge ego sai ine tepo awa, ‘Ei giu! Nu ego itia ewa,’ ota ‘Nu agewa zora ogo itia owa.’ Sana niniu. Anutu imata Tua wero nuai awa nisokare nana soe itia awa.” ");
INSERT INTO sue_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ago sero bua mai nusore ego senua awa, “Noma ama nikare na Emara Mai amira waiko be zo gaira yaba wamunowa, ata nikare be naso zo oko gamunowa. ");
INSERT INTO sue_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nukare nimorekare ego samunora, ‘Giu, nu ogo itia,’ ata ‘Giu, nu ego itia.’ Ago sara nikare oko baro nukare ama ganawe. ");
INSERT INTO sue_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Awa nera kota, be piri-piri awawi zasimai awa waegiro bamu utu agewa sero amira nitinowia, da ago ine na Emara Mai meni be na kei awamunona amire ago ine wamunona. ");
INSERT INTO sue_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ata gita na yaya bua witai tamamunona. Tamana ema zeme nowera ami na atune potiro duamunora. ");
INSERT INTO sue_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tani gita Noa wara kaka witamure inoisowa da ago ine inuara na Emara Mai ewesemuro mamunona. ");
INSERT INTO sue_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nukare ou wama bamu kaka mamure nena pupise nise awinoise bama ina-pota wero atitinoise noisowa. Ago inoise noisouta asero noiwa Noa wara witinua awa. Witinu ou wama bamu muro nukare gogowero tepo wenua. ");
INSERT INTO sue_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ema zazo Lati noisonua be amire da ago inoisowa. Nukare nena ninoise nena ina-pota inoise nai bua inoise so wise awinoise noe dowa ");
INSERT INTO sue_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lati meni nata Sodom doro dainitinoinu waiko be da amire awetu niaore utura ena wa boruza meni osago wero ema bama dago awero tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Erama meni da ago ine inoise kotumai nusokare poti zebura buara niro nuara na Emara Mai kei damu namunona awa. ");
INSERT INTO sue_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Be amire zo nu so nusora ope itamunoya ami neu-nau nuso sora itia awa pumamu oko toyaise. Ota zo nu buye nuamunoya ami oko ewesemuro nate bayaise. ");
INSERT INTO sue_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nikare tani Latira bama amira nana kei awenua* awa kotumuwo. ");
INSERT INTO sue_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ota zo nu nuai nuso zebura awa puro nuamu kotumamunoya ami zebura nuai nuso awa duamunoya. Ata zo nu nuai nuso na emo duamunoya ami nuai ewanana tamamunoya. ");
INSERT INTO sue_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na sana niniu. Pi amire ema eto masi da amira awinuarato na zo pumuro zo duamunona. ");
INSERT INTO sue_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bama eto meni ma ditinoise itarato na zo pumuro zo duamunona.  ");
INSERT INTO sue_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ema eto buye nuarato na zo pumuro zo duamunona.” ");
INSERT INTO sue_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ago senu nukare ge awa niniro ego sewa awa, “Ema tua, nena awa nana ena kei awamunoi?” Ago sewa Yesu meni ge bezero ego senua awa, “Bua awawi ni oa meni ibosi giro kokounitinowera awa.” ");
INSERT INTO sue_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu meni nukare isa saira berea tepo be giti isa toise nuarise sero ge bezai ego ine senua awa, ");
INSERT INTO sue_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Ema zas zo nata zora itisonua ami Anutu ata erama awa azu kaka wamu noisonua. ");
INSERT INTO sue_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nata amira bama kuma zo noisonua ami zas nana eyaya kei awero ego toisonua awa, ‘Iwo naso meni na waya wamu inowia, are ni na soremu.’ ");
INSERT INTO sue_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ago sasai zas meni ge nuso kaka ninamu inoe doro ego kotumunua awa, ‘Na Anutu ata erama awa azu oko inowena, ");
INSERT INTO sue_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ata bama kuma ewa nu bua bamu namore potitinowia. Inoma eyaya naso nana nuai na berea wamia, na nu kotora ena gera soremane.’” ");
INSERT INTO sue_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tua meni ge bezai awa sero ego senua awa, “Nikare zas waya amira ge awa niniro susu ego giwo. ");
INSERT INTO sue_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Anutura sianai dubu nu pi waiko zawa toise nowera nukare awa Anutu meni kotora ena gera soremamunoita? Ota nu nukare eya gera soremamunoita? ");
INSERT INTO sue_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iyo. Na me tona awa. Nu nukare eya gera soremamunoya. Ata na Emara Mai meni noko zebura ewesemuro muro ema tuma diaire eni isa toise nuara tamamunonita?” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ema eni nukare nutopekare gasara ema saramai wasai otao mamai enire gasara waya inoisonua numorekare Yesu meni ge bezai ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ema eto nuto isa samu seroto witi Anutura ibu bamura niwato awa. Zo awa Farisayo, ata zo awa takis pumai ema awa. ");
INSERT INTO sue_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisayo awa dopero itise moka nuso meni isa ego senua awa, ‘O Anutu, na ema eni ine oko aewa. Ago inoise giro na nimore kokopai tona. Nukare awa bewana wai ema ata taniwaya wai ema ata atai sisai ema awa. Ata na nukare ine oko aewa. Noko, na takis pumai ema ego ine oko aewa. ");
INSERT INTO sue_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na pura sero be eto ago nena sienitinowena. Ata nena dapikarago pupinowena awa gatero dubu dawena wana eto wawi zo nimore potitinowena awa.’ ");
INSERT INTO sue_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Isa ago senua awa, ata takis pumai ema awa asike dopero iri utura nai azu wenua. Nu pasina nuso ginu bamu wenu me nitinoise isa ego senua awa, ‘O Anutu, na pasina ema. Ni na awa diyo.’” Yesu meni uge awa diro ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Na nimorekare sane. Takis pumai ema awa Anutu meni nu ema saramai asenu nu ewesemuro so nusora bamunua. Ata ema zo awa tepo awa. Nera kota, zo nu tama puro witamunoya, awa Anutu meni nu puro osamunoya. Ata zo nu osero nuamunoya, awa Anutu meni zazo nuso de ike namunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Emare bamere nukare Yesu meni mai pei-mamai gawa waise sero puro nuso nana bamuwa. Ata bua mai nuso meni giwa waya wenu nukare senewa. ");
INSERT INTO sue_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ata Yesu meni mai pei-mamai nuso nana marise sero ego senua awa, “Nikare mai pei-mamai dou naso nana mare. Ebata nusokare oko gazawe. Ago ine ami Anutura nata amira gegenai. ");
INSERT INTO sue_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na ge me memeka nimorekare tona ewa. Zo nu tuma diai mai pei-mamaira ine tepo ami Anutura nana nate bayai ine tepo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Giti kopi zo meni Yesu atata wero ego senua awa, “O gipai ema ewanana, na nogo wero nuai me ewanana tamamunoni?” ");
INSERT INTO sue_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ago senu Yesu meni ina ego senua awa, “Ni na ewanana asinoise ewananara susu gosinosita? Anutu imata ewanana. ");
INSERT INTO sue_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ni Anutura lo ge gosinowesa. ‘Emata bama bewana oko wase; Ni erama oko dasa betare; Ni bewana oko wase; Ni ema zo gera potamu opi oko sase; Ni miato mamera ge dimuyo.’ Lo ge ago itia.” ");
INSERT INTO sue_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ago senu giti kopi meni ego senua awa, “Na seka nasore ge awa dapikarago dipi-tupewena.” ");
INSERT INTO sue_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ago senu Yesu meni niniro ego senua awa, “Ni bua zo dosa itewia, awa weyo. Ni baro nena niso dapikarago potasa ema meni zuma gaero pumara wau moni niso awa ema bogamasare kanowasa pumare. Ago wasa wau niso utura itamunoya. Ago wero amire muro na ama ganase.” ");
INSERT INTO sue_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ago senu ema giti kopi ami ge awa nininu duba nuso mou-mau wenua. Nera kota, nu wau bamure. ");
INSERT INTO sue_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ago wenu Yesu meni giro ego senua awa, “Erama wau witaire ami Anutura nata amira bayaira bua bamubake wamunora. ");
INSERT INTO sue_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Wo kamel meni boma sora toyai, awa nena mou awa. Ata ema wau witaire meni Anutura natara bayai, awa nena mou-mau awa.” ");
INSERT INTO sue_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ago senu erama ge awa niniro ego sewa awa, “Are agai meni utura baro nuai me ewanana awa tamai te inoi?” ");
INSERT INTO sue_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ago sewa Yesu meni ego senua awa, “Nena erama meni wai ine tepo awa Anutu meni wai te inoya.” ");
INSERT INTO sue_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ago senu Petoro meni ego senua awa, “Sana giyo. Nakare natare neu-nau nasokare dapikarago doro ni ama ganinoise nowenakare.” ");
INSERT INTO sue_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ago senu Yesu meni numorekare ego senua awa, “Na me memeka nimorekare tona. Zo nu Anutu imata Tua wero nuaise sero nata nusota bama nusota namisini numisini nusota mama mia nusota mai awiso nuso awa duamunoya, awa ");
INSERT INTO sue_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","amira Anutu meni zeme zebura ena ina nuso bamubake potamunoya. Noko ama numore nuai me ewanana potamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu meni bua mai 12 sero puro gita baro numorekare ego senua awa, “Sana niniu. Zeme nakai Yerusalem wititinonakai awa. Are ge gita porofete meni Emara Maire gaewa awa me wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Awa erama meni na poti ema Yudako nana wanera namunora. Ago wara na isipitinoise namore waya wise pora pisise awamunora. ");
INSERT INTO sue_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ago wero nukare na wamu meni pena-pana dero amire dara betamunona. Betana waiko be etorobara tepo wai amire noko eramunona.” ");
INSERT INTO sue_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ago senua, ata bua mai meni ge awa niniwa gera susu kaka kei awamu wenua. Nukare ge amira susu kau wero itazaita wewa. ");
INSERT INTO sue_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yeriko nate ena ema giti guma wai zo meni ebata demabera arumuro ema bama moni emo begomo toise itinua. Ago inoise itinu Yesu meni nata amira zorage kei awenua. ");
INSERT INTO sue_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kei awenu ema ami ema bama witai tupiwa amira awi niniro ema eni atata wero senua awa, “Nukare nogo inori?” ");
INSERT INTO sue_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ago senu nukare numore ego sewa awa, “Yesu Nasaretera ema ami tupia.” ");
INSERT INTO sue_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ago sewa giro nu zawa gatero ego senua awa, “Yesu ni Dawidira sibuna, ni na emo zo amuyo.” ");
INSERT INTO sue_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ago senu ema gita aita inoiwa ami nu seninoise nu ge duaise sewa. Ata nu noko zawa bamu gatero senua awa, “O Dawidira sibuna, ni na emo zo amuyo.” ");
INSERT INTO sue_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ago senu Yesu meni niniro ebete dopero numorekare ego senua awa, “Puro naso nana muwo.” Ago senu puro mu zora niwa Yesu meni atata wero senua awa, ");
INSERT INTO sue_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Na ne nimore wanise tosi?” Ago senu nu senua awa, “Tua, na sasa giti moka naso panaise tona.” ");
INSERT INTO sue_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ago senu Yesu meni numore ego senua awa, “Giti moka niso panaise. Tuma diai nisora ni ewanana wetesa.” ");
INSERT INTO sue_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ago tuaise giti moka nuso panenu nu so noko ginua. Ago wenu ema bama meni tani awa giro Anutu bowi wewa. ");
INSERT INTO sue_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu meni Yeriko nate toiro busero semuro bayamu wenua. ");
INSERT INTO sue_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Are nata amira ema zo noisonua zazo nuso Zakio. Nu ema takis pupinoisowa amira dia zo. Are nu moni witaire awa. ");
INSERT INTO sue_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Are nu Yesura benau giro baitamu kotumunua. Nu ema apunu, are ema bama witai itiwa ami nu gazewa nu Yesu gaira te kaka wamu wenua. ");
INSERT INTO sue_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Are nu sumuro gita baro Yesu ego tupiai gamunona asero witi ni zora ninua. ");
INSERT INTO sue_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ago itinu Yesu agewa amira muro iri ike niro numore ego senua awa, “Zakio, ni eya osero mu. Zeme na so nisora witiro itima awamunona.” ");
INSERT INTO sue_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ago senu nu eya osero muro yawa sara inoise Yesu puro bamu so nusora ninua. ");
INSERT INTO sue_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Are erama witai ami giwa waya wenu Yesure zuzu toise ego sewa awa, “Nu baro pasina ema zora so amira awaira susawia, atonua!” ");
INSERT INTO sue_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Are Zakio nu dopero Tuare ego senua awa, “Tua, sana niniyo. Zeme ara tamai na neu-nau naso puro dubu eto dero zo puro ema bogamasare potamunona. Ota gita ge opi sero ema zora nena daimata bewana pupisenita, awa na ina nuso zoeto-zoeto potamunona.” ");
INSERT INTO sue_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ago senu Yesu meni numore ego senua awa, “Zeme Anutu meni noko tera ema bama so emira awa pumia. Ema ewa dai nu Abrahamra sibuna. ");
INSERT INTO sue_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na Emara Mai meni ema tara awai ago ine awa kau wero tamuro korawamu muna.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ago senu niniwa amire susumuro ge bezai zo senua. Nera kota, nu kei Yerusalem nitinoinu nukare ego kotumuwa awa, “Zeme Anutu imata Tua wero nuamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ago kotupitinoiwa giro nu uge zo diamu ego senua awa, “Ema bamu zo nu zebu zo zora-zarako amira bayai ema tuara putou numore potara ewesemuro mamu senua. ");
INSERT INTO sue_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ago wamu sero bua mai nuso wana eto zawa senu muwa numorekare moni kanowero 200 kina 200 kina potinu pumuwa ego senua awa, ‘Nikare omata emi bua wawa zamai puro nuawa nama ewesemuro mane.’ ");
INSERT INTO sue_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ago sero doro susaunu zebu nusora erama meni numore berea wenu giro oziga potiwa puro nu ama ganero bamuwa awa. Baro kei awero ego sewa awa, “Ema ami ema tua nasokare wai azu tonakare.” ");
INSERT INTO sue_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ago sewa ata saineba nukare ema tuara putou numore potiwa pumunua awa. Putou potiwa pumuro ewesemuro muro zebu nusora kei awero bua mai wana eto gita omata potinua nukare awa zawa sarise senu zawa sewa muwa awa. Muwa nu nukare omata bua wewa nazo kei awenu awa gamu senua. ");
INSERT INTO sue_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Are bua mai zo meni nuso nana kei awero ego senua awa, ‘Ema tua, 200 kina namore potisesa ami bua wetena 2,000 kina kei awisia.’ ");
INSERT INTO sue_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ago senu ema tua meni numore ego senua awa, ‘Ni bua mai ewanana. Ni nena pei-kaka awa ewanana dia wisesa, are ni zeme nata wana eto ago ine dia wasise potamunona.’ ");
INSERT INTO sue_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ago senu bua mai zo meni muro ego senua awa, ‘Ema tua, 200 kina namore potisesa ami bua wetena 1,000 kina kei awisia.’ ");
INSERT INTO sue_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ago senu ema tua meni numore ego senua awa, ‘Na ni nata wana da awa dia wasise potamunona.’ ");
INSERT INTO sue_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Are bua mai zo meni muro ego senua awa, ‘Ema tua, 200 kina niso itia ewa. Na gita mo be zora potiro sipunina itewia ewa. ");
INSERT INTO sue_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Awa nera kota, na susu niso gosinowena. Ni nena emo duba-duba inoise zewai-zawai inowesa. Nena mai zo meni potawi itewia awa nine pupinowesa; nena mai zo meni urinowia awa nine pupinowesa; are na ni azu inowena.’ ");
INSERT INTO sue_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ago senu ema tua meni bua mai amire ego senua awa, ‘Ni bua mai waya me waya awa. Ge nika nisora na ni gera potitinona. Ni susu naso gosinowesa asinosa. Na nena emo duba-duba inoise zewai-zawai inowena. Ago wero nena erama eni meni potawera itewia awa nane pupinowena. Ago wero nena erama eni meni urinowera awa nane pupinowena, ago tosa awa ni? ");
INSERT INTO sue_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Agoro ni nogoro moni naso gita kaka poti benkira namu wisesi? Ago wamesa sia, awa na ewesemuro agewa nusore dai pumamena.’ ");
INSERT INTO sue_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ago sero nu ema eni zorage dopero itiwa amire ego senua awa, ‘Nikare 200 kina nuso awa soero pumuro potiwo ema 2,000 kina tapisia ami pumae.’ ");
INSERT INTO sue_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ago senu nukare ego sewa awa, ‘Tua, numa awa 2,000 kina itia!’ ");
INSERT INTO sue_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ago sewa ata nu senua awa, ‘Na nimorekare sane. Zo nu nena numore potai awa puro noise ami bua wai giro na eni susumuro numore potamunona. Ata zo nu nena numore potai awa puro noise ami bua kaka wamu wai giro na nena pei-kaka nuso nana itia awa soero pumamunona. Ago wana nu tepo nuamunoya. ");
INSERT INTO sue_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ota iwo naso meni awa nukare na ema tua nusokare wai azu sisera, nukare awa puro mu naso nana giti mokara ena dawa betare.’” ");
INSERT INTO sue_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu nu ge awa sero tepo wero Yerusalem witamu gita aita wero bamunua. ");
INSERT INTO sue_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nu dirumu zazo Oliwa awa witiro nata eto zazo nusoto Betfasito Betanire amira zorage kei awero bua mai nuso etore ego sero potinu gita bamuwato awa, ");
INSERT INTO sue_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Nito nata omira baro toiro bamuwoto. Baro wo donki seka bazai zo mui wetera itia awa gamunowato. Gita mai zo meni tame kaka arumamu awa. Nu awa mui besero puro muuto. ");
INSERT INTO sue_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ota besinuawato ema zo meni nito atata wero ‘Nito nogoro donki awa mui besinowita,’ ago sai giro nito ge nuso ina ego sewoto, ‘Tuara bua emira itia.’” ");
INSERT INTO sue_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesu meni ago sero nuto potinu bamuwato awa. Are nuto baroto nena senua awa te dago tamuwato awa. ");
INSERT INTO sue_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nuto donki seka amira asi besinoiwato wora mamana meni numoreto ego sewa awa, “Nito nogoro donki seka amira asi besinowito?” ");
INSERT INTO sue_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ago sewa nuto ego sewato awa, “Tuara bua emira itia.” ");
INSERT INTO sue_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Are nuto donki seka awa puro mu Yesu nana niwato awa. Ago wero nukare tama woi nena nusokare poti donki tame niro amire Yesu ziro soga wewa witi wo tame ninua. ");
INSERT INTO sue_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nu donki tame arumuro susaunu ema bama meni nukare tama woi nena nusokare ami ebete sawa di gita niwa. ");
INSERT INTO sue_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nu dirumu Oliwa osero baro Yerusalem zorage kei awinoinu bua mai dubu nuso bamu ami yawa sara wewa. Nukare tani putoure wasai gosinoisowa awa kotupitinoise arero Anutura zazo de ike nitinoise ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Ema tua nasokai Tuara bera tupia nu awa bowi wanekai. Utura tini kapai tepo wetia. Nakai Anutura zazo de ike nanekai!” ");
INSERT INTO sue_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ago sewa Farisayo eni ema bama bamu amira nana soe itiwa ami Yesure ego sewa awa, “Gipai ema, ema dubu niso meni ni ema tua asinora awa se duare.” ");
INSERT INTO sue_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ago sewa nu ina ego senua awa, “Na nimorekare sane. Nukare ge duamunora, awa omata meni ‘ema tua’ asinoise aramunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Are Yesu nu mu Yerusalem zorage niro nata bamu awa giro nata emo di senua. ");
INSERT INTO sue_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Di sero ego senua awa, “Nikare dai be zeme emire begara ebata gamewa sia, awa te wamia. Ata zeme begara ebata bezinoya. Are nikare oko gamunowa. ");
INSERT INTO sue_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Iwo meni nata nisokare zimuro itise aiwa pupinoise uze ape gita niro ami beri waise wamunora. Ago wero nikare poti soe nara nikare bayaira ebata kau wamunowa. ");
INSERT INTO sue_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nukare nata nisokare dara zasai toiro nikare dero tepo-tapo wamunora. Nukare omata zo zora nana tame itamunoya, awa oko awa-diamunora. Tani awa nisokare nana kei awamunoya, nera kota, Anutu meni nikare kora wamu musia amira be awa nikare kaka gamu inowewa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu meni Anutura ibu bamura toiro ema moni paira bua ibu mokara ena inoiwa giro tunenua. ");
INSERT INTO sue_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nu numorekare ego senu awa, “Ge gayai zo ego itia ewa, Ibu naso awa isa saira ibu itaise. Ata ninekare wetewa ibu awa bewana wai emara bezai masi nusokare ine inoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Are waiko be sero nu ibu mokara ena ema bama gipinoisonua. Are pris babezinoma ata lo ge gipai ema ata dia eni dabe nukare nu dara betaise amira ebata tamamu wewa. ");
INSERT INTO sue_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ata ema bama zere dago ami ge nuso ninaira zewai-zawai inoiwa giro nukare ebata zo oko tamuwa. ");
INSERT INTO sue_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Are be zore Yesu meni ema bama Anutura ibu mokara ena Tuara ge gipinoise Oziga Ewanana tugata inoinu pris babezinoma ata lo ge gipai ema ata simai eni ami nuso nana muro ");
INSERT INTO sue_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","numore ego sewa awa, “Ni namorekare se, ni ara bera tani awa inowesi? Agai senu tani awa inowesi?” ");
INSERT INTO sue_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ago sewa nu ge nusokare ina ego senua awa, “Na dai na ge zo nikare atata wamu kotupitinona. Nikare namore seu. ");
INSERT INTO sue_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohane meni ge ou bua nuso awa ara bera inoisi, emara berata Anutura bera ni?” ");
INSERT INTO sue_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ago senu nukare nutopekare ge ina-sa inoise ego sewa awa, “Nakai ‘Yohanera ou gutai awa utura nena’ asamunonakai, awa nu ego samunoya awa, ‘Are nikare nogoro ge nuso kaka ninamu wisewi?’ ");
INSERT INTO sue_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ata ego samunonikaita, ‘Yohanera ou gutai awa emara nena gege awa.’ Ago sanakai erama dapikarago emi omata nasokai nana apamunora. Nera kota, nukare Yohane gasara porofete me inoisia.” ");
INSERT INTO sue_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ago sero nukare Yesure ge ina ego sewa awa, “Yohanera ou gutai awa nana ena kei awenu, awa nakare kaka gamu inonakare.” ");
INSERT INTO sue_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ago sewa Yesu meni ina numorekare ego senua awa, “Ago towa, are na ara bera tani inoweni amira susu nimorekare oko samunona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu meni ema bamere ge bezai ego senua awa, “Ema zo meni wain bua urenua awa. Urero dia eni potiro nu zebu zora-zarako amira baro borere noisonua awa. ");
INSERT INTO sue_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Are wain me paira be munu giro nu bua mai iyetiro baro wain me eni paise senu bamunu dia meni dero tunewa tepo ewesemuro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bamunu wainra mama meni bua mai noko zo potinu bamunu dero isipitinoise tunewa tepo ewesemuro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Bamunu mama meni bua mai zo noko potinu bamunu dewa tama kakapuninu musuniwa. ");
INSERT INTO sue_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ago wewa buara mama meni giro ego senua awa, ‘Nogo wamunoni? Na mai naso nu wama naso awa potana bayamunoya. Bayai nukare nu yaba wamunorita?’ ");
INSERT INTO sue_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ago sero iyetinu bamunu dia meni mai awa giro ina-sa wero ego sewa awa, ‘Nu ami noma zebu emira mama wamunoya, are numa danakai betai zebu ewa nasokai wae.’ ");
INSERT INTO sue_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ago sero nu musuna-masuna inomite puro baro wain bua doro pua atune ena dewa betenua awa.” Yesu uge awa diro ema atata wero senua awa, “Buara mama meni dia wai emare nogo wamunoi? ");
INSERT INTO sue_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nu muro nukare damunoya. Ago wero dia seka bua nusora potamunoya.” Yesu ago senu nukare niniro ego sewa awa, “Tepo awa. Ago ine oko kei awaise!” ");
INSERT INTO sue_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ago sewa Yesu meni iri nusokare nana niro ego senua awa, “Are ge gayai emira susu nogo iti? So wai ema meni omata zo giwa waya wenu dowa awa. Ata omata ami so urura zasiwi wero itewia. ");
INSERT INTO sue_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Zo nu omata amira duwamunoya ami zasamunoya. Ota omata ami ema zora nana tame duwamunoya, awa ema awa dai zasero mumuka gege wamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ago senu lo ge gipai emare pris babezinomare meni ge bezai senua ami nukare pumunu giro waiko da amire nu benai sora potamu sewa, ata nukare ema bama azu wero giro dowa awa. ");
INSERT INTO sue_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Are nukare Yesu ziro puro ema tuara nana wanera potamu sero nu uma wewa. Ago inoise nukare ema eni potiwa baro ge ninaira esega wero nu gosinoiwa. Awa nu ge waya zo sai giro nu sanamu sero wewa. ");
INSERT INTO sue_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ago inoise nu atata wero ego sewa awa, “Gipai ema, nakare susu niso gosinonakare. Ge niso awa ewanana. Ni ge niso ewanana gege emare bamere towesa. Ni ema eni zazore amira azu oko inowesa. Tepo awa. Nima ema bama Anutura ge amira susu gipero baititinowesa. ");
INSERT INTO sue_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nima nogo kotupitinosi? Nakai Yuda ema meni Roma emara ema tua Sisa amire takis potitinowenakai awa ni gawesa te inowita?” ");
INSERT INTO sue_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ago sewa, ata Yesu meni ge opi nusokare toiwa awa giro numorekare ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Moni zo gipeu gane. Agoro ititire zazore monira itia ewa awara ni?” Ago senu nukare sewa awa, “Awa Sisara.” ");
INSERT INTO sue_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Are nu numorekare ego senua awa, “Are nena Sisara asero giro Sisare potiu. Ota nena Anutura asero giro Anuture potiu.” ");
INSERT INTO sue_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ago senu nukare nu ema bama nana benaura sanaira te kaka wamu wenua. Noko ge senua awa niniwa kotumai kaka kei awamu wenu ne seri wero giro dowa. ");
INSERT INTO sue_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ema eni Sadukayora dubu ami Yesu nana muwa awa. Nukare Sadukayo meni ge ego toisowa: Betai nukare noko oko eramunora. ");
INSERT INTO sue_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Are nukare nu atata wero ego sewa awa, “Gipai ema, Mose meni ge zo namorekai ego gaenua, ‘Ema zo bama atiro noma mai tepo ema awa betamunoya, awa nami nuso meni bama awa noko puro atamunoya. Ago wero nu ami nami nuso emo mai zo pumaise.’ ");
INSERT INTO sue_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Amira namisini 7 awa nukare gita noisowa awa. Nami zewai awa numa bama atiro noe mai tepo betenua. ");
INSERT INTO sue_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Are namba tu meni bama da awa noko atiro noe mai tepo betenu ");
INSERT INTO sue_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","namba tri meni bama da awa noko atiro noe mai tepo betenu, ago daba wero baro nukare namisini 7 ami bama da awa atiwa, ata nukare mai tepo betewa awa. ");
INSERT INTO sue_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Are ama bama dai betenua. ");
INSERT INTO sue_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nukare 7 ami gita bama da awa atiwa. Are be betai meni noko eramunora be amire bama awa ara wamunoi?” ");
INSERT INTO sue_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ago sewa Yesu meni numorekare ego senua awa, “Zeme zebura ena ema bama atitinoise nowera. ");
INSERT INTO sue_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ata noma be bamura ena erama eni nuai me ewanana topetarise Anutu meni gai te wamunora, nukare ami betaira ena eriro noko oko ina-ata wamunora. ");
INSERT INTO sue_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Anutu meni nukare betaira ena emoko awa-uzenu eriwa, are nukare mai nuso wero noise angelo ine wero itamunora. Nukare noko betai ine tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ota bebetenai meni eramunora, amira ge awa Mose meni dai gipenua. Nu ni payai zo awero kaka tepo wamu wenua amira uge awa gainomite amire ge zo Anutu meni numore senua awa ego gaenua awa, Na Abrahamto Isakare ata Yakobo amira Tua wero itewena. ");
INSERT INTO sue_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anutu nu erama bebetenai asinowenakai awa gawi seka gege inowera. Are nu erama betaira Tua kota, nu erama seka itewera amira Tua wero itewia.” ");
INSERT INTO sue_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nu ago senu lo ge gipai ema eni meni ego sewa awa, “Gipai ema, ge tosa awa genakare neine inoya.” ");
INSERT INTO sue_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ago sewa, nera kota, Sadukayo meni nu noko atata waira azu wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ata Yesu meni numorekare ego senua awa, “Agoro nukare nogoro ego toweri, ‘Yuda emara Soyai Ema zazo Kristo awa nu Dawidira sibuna?’ ");
INSERT INTO sue_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ata yere buku nasokai zazo Sam amira awa Dawidi nu nutope ego sero gaenua awa, Tua meni tua nasore ego senua awa, ‘Ni muro wana me nasora arumuro ");
INSERT INTO sue_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","itasa na iwo dubu niso awa benau nisora potana isimamunosa.’ ");
INSERT INTO sue_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawidi meni ge ago toise Kristore Tua naso asenua. Are Kristo nu nogoro Dawidira sibuna wamunoi?” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ema bama itiwa amira nana benaura Yesu meni bua mai nusore ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nikare lo ge gipai ema nukare awa uma wewo. Ema bama meni nukare samo darise sero tama woi iboboi wosuniro nowera. Ema bama meni nukare kakame ena giro arenarise yaba inowera. Nukare yere ibura ena ema bama nana benaura arumamu yaba inowera. Nukare ana-bona waira bere masi zazore amira arumamu yaba inowera. ");
INSERT INTO sue_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nukare bama iu betai amira wau awa soero pupinowera. Ago inoise nukare pasina nusokare gogo wero me irora inoise isa iboi-tatana towera. Are nukare ina nusokare mou-mau bamu tamamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu nu ibu bamura ena itise iri niro ema bama waure meni omata nusokare eni ibura kolekta amira potitinoiwa ");
INSERT INTO sue_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","gosinoise itinu bama zo iu betai wau tepo bogamasa noisonua ami kei awero toea eto kolektara potinu ginua awa. ");
INSERT INTO sue_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ago wenu Yesu meni giro ego senua awa, “Na ge me memeka nimorekare tona. Bama iu betai bogamasa emi omata potitinoya ami enira awa dainitinoya. ");
INSERT INTO sue_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nera kota, nukare awa omata witai itia ata nukare eni gege Anuture potera. Ata bama ami omata nuso pei-kaka itia awa te potiro tepo wetia. Are nu nena zuma gaero naira zo oko itia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ema eni nukare ibu bamura ge sewa. Nukare gita so awa omata ewa-gaewa ami simena-gaena wewa. Noko nena ewa-gaewa Anuture potitinoisowa ami dai simuwa, amira ge sewa Yesu meni ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nikare nena bamubamu zeme gosinowa amira susu nuso sane. Ama be zo kei awamunoya amire nukare ibura omata zo oko duara zora nana tame itamunoya. Nukare dero sisero apara osamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesu meni ago senu nukare nu atata wero ego sewa awa, “Gipai ema, nena tosa awa be nere kei aamunoi? Tani ne gita kei awai amire be awa zora awinoya awa gamunonikare?” ");
INSERT INTO sue_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ago sewa Yesu meni ego senua awa, “Nikare etete nameraya nikare uma wewo. Ema witai muro nikare eteteniro zazo naso toise nutopekare ‘Na ema awa’ asamunora. Noko ‘Be kei awetia’ ago samunora. Ata nikare baro nukare oko ama ganawe. ");
INSERT INTO sue_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nikare ge ego ine ninamunowa: ‘Bogi-zuzuna bamu inora, ota gavmanre iwo inoise nata sisinora.’ Ago sara niniro azu oko wawe. Tani awa gita kei awamunora, ata zebura be eya oko tepo wamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu meni ago sero numorekare ego senua awa, “Ema dubu eni nukare bogi-zuzuna ema dubu enire wamunora. Ota ema tua enira dubu ami ema tua enira dubure bogi-zuzuna wamunora. ");
INSERT INTO sue_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Duwi babezinoma sumamunora. Agewa eni dora-botiyo babezinoma kei awamunoya. Noko yaya bamubake eni meni erama sero nana witiro tepo wamunoya. Ota noko utura ena tani-butani babezinoma enita noko nena benau seka-seka eni ami kei awara giro erama azu bamu wamunora. ");
INSERT INTO sue_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ota nena awa dapikarago kaka kei awamure nukare nikare saniro yaya bua nimorekare potara tamamunowa. Ago wawa nikare puro poti yere ibura niro ana nikare gera potiro amire benai sora potamunora. Nikare zazo naso puro nowewa, ami emo nukare nikare puro ema tua nana benaurata noko ema tua osesenai enira nana potara ge bua wamunowa. ");
INSERT INTO sue_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ago wamunora be amire nikare Oziga Ewanana puro nowewa amira susu nisokare kerenamunowa. ");
INSERT INTO sue_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nikare ge ei awa kotumai nisokarera potiu zewai wae, ‘Na gera potamunora amire na ge oko sia wamunona.’ Ago toise noiwo. ");
INSERT INTO sue_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nera kota, nane kotumai ewanana nimorekare potamunona. Ago wana iwo nisokare meni ge awa azu sai ine tepo. Noko puro osai ine tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Miamai mamanare namisini numisinire didikai ata otao mamai nukare dai nikare iwora wanera potamunora. Ago wara nisokare nana eni awa dara bebetenamunora awa. ");
INSERT INTO sue_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ata ema witai ami nimorekare tini kapai pamunora. Awa nera kota, zazo naso awa nisokare nana itia. ");
INSERT INTO sue_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ota na nikare soremana giti tu nisokare zo oko sokero duamunoya. ");
INSERT INTO sue_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nikare zewai-zawai wero noma nuai me pumamunowa. ");
INSERT INTO sue_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ota ama goroba ema muro Yerusalem zimamu inuara giro ego gamunowa awa: nata bamu dero ziwaira be awa kei awetia. ");
INSERT INTO sue_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Be amira ana ema Yudaya zebura itamunora ami azu sumuro bamu dirumura narise. Ema Yerusalem mokara itamunora ami nata doro sumuro bayarise. Ema eni goma atune itamunora ami nate oko toyarise. ");
INSERT INTO sue_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nera kota, be amire Anutu meni ina nuso waya potamunoya. Ago wai ge gaewa awa dapikarago me wamunoya awa. ");
INSERT INTO sue_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Oi, bama wasou wai ata bama mai unore. Nukare pena-pana sumai ine tepo, are na nukare emo zo apinona. Nera kota, be amire mou bamubake zebu emira kei awamunoya. Noko Anutura tini gamai bamu ami ema bama dubu emira nana kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nukare awa goroba ema meni nukare puro kasiwa meni dara bebetenamunora. Ota noko goroba ema meni ziro beniro puro ema dubu sero amira nana bayara sou bua nusokare wamunora. Ota nata Yerusalem awa ema Yudako meni puro patiro usi-besi inoise nuara be nusokare pesunai amire duamunora. ");
INSERT INTO sue_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tani eni inuara enata, waikora enata, kunara ena kei awamunora. Noko zebura ena ewa bamubake eriro bezinuai erama dubu sero meni niniro azu inoise kotumu-katumu wamunora. ");
INSERT INTO sue_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ota putou utura itewera ami zipamunora. Ago wara erama meni nena zebura ena kei awinoya amira azu inoise kotumai tepo wai dopamunora. ");
INSERT INTO sue_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ago wara na Emara Mai meni putoure zasimai bamure bereze zora osero tupiana ema bama meni gamunora. ");
INSERT INTO sue_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ama nena awa kei awamu zaawinuai giro nikare dapikarago dopero iri ike niwo. Nera kota, be awa Anutu nikare noko tera pumaira be awa zora awetia.” ");
INSERT INTO sue_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu ago sero ge bezai zo numorekare ego senua awa, “Nikare ni fik ata ni eni amira tani kotumuro susu zo giu. ");
INSERT INTO sue_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bona nusokare gotu gi nusokare zazawera be amire nikare giro, ‘O, waikora be kei awamu inoya,’ ago towewa. ");
INSERT INTO sue_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Da ago ine tani kei awamu inoi sesena awa kei awai amire nikare ego sewo, ‘O, Anutu imata Tua wamunoya amira be kei awinoya.’ ");
INSERT INTO sue_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Na ge me memeka nimorekare sane. Ema bama zeme zebura nora ami kaka betero tepo wamu nuara amire nena awa dapikarago kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ama uture zebure sisero tepo wamunorato, ata ge naso meni awa oko sisero tepo wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nikare nena pena-pana nukinoise ou zewai niro dau inoise tamara nena emo duba-duba inoise nuawa be bamu meni nikare eya wawa meni dago wai azu, nikare nitopekare dia wero baitiwo. ");
INSERT INTO sue_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Be bamu awa erama zebu sero nowera amira nana kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nikare nena bamubamu kei awamunora amira mokara ena zewai wero noma na Emara Mai amira nana benaura dopamu sero duba gitawa tepo eyaya isa toise noiwo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu meni waikore ema bama ibu bamura ena gipinoisonua, ata pire nu doro dirumu zo zazo Oliwa amira baro awinoisonua. ");
INSERT INTO sue_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pina atasai ema bama witai meni ibu mokara ena ge sai ninamu nuso nana aunitinoisowa. ");
INSERT INTO sue_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pura bamu zo ame yis tepo ninoisowa amira waiko zo zazo nuso Betai Daininua amira pura awa kei awamu inoinu ");
INSERT INTO sue_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pris babezinomare lo ge gipai emare nukare ema bama azu inoise Yesu upene daira ebata kau wewa. ");
INSERT INTO sue_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kau inoiwa Satan meni Yudas nana mokara toinua. Yudas zazo nuso Iskeriot asinoisowa, nu bua mai 12 amira zo. ");
INSERT INTO sue_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nu ami baro pris babezinomare ibu bamura polis amira dia enire dai poti dara niro nu Yesu kereniro wana nusokarera potai parise senua. ");
INSERT INTO sue_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ago senu nukare niniro yawa sara inoise numore omata eni potamu sewa zewai wenua. ");
INSERT INTO sue_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ago sero sewa nu ge nusokare niniro, “Te wetia. Ago wamunona,” asero nu ego kotumunua awa, “Ema bama tepo Yesu imata nuai amire kerenamunona.” Ago kotupitinoise Yesu kereniro wana nusokarera potamu ebata tamaira bua wenua. ");
INSERT INTO sue_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pura ame yis tepo amira be kei awenua. Be amire nukare wo sipsip mai darise sai itisonua. ");
INSERT INTO sue_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Are Yesu nu mai eto Petoroto Yohanere iyetitinoise ego senua awa, “Nito baro ame nasokai sia wewoto muro nanekai.” ");
INSERT INTO sue_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ago senu nuto sewato awa, “Ni masi na-amira ena sia waninseto kotupitinosi?” ");
INSERT INTO sue_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ago sewato nu ego senua awa, “Nito niniuto. Nito nata mokara baro ema zo ou au bamu dimuro puro tupima nito ebete ena tamamunoya. Nito ema awa ama ganero baro so toyai giro nito so da amira toiroto ");
INSERT INTO sue_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","sora mama atata wero ego sewoto, ‘Nakare ata gipai ema ami so moka na-amira ena Betai Daininua amira bona namunonikare?’ ");
INSERT INTO sue_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ago sawato nu so moka bamu zo so ike itia awa nimoreto gipamunoya. So moka awa sawa diai au-tewa sia wai itia. Gipai giro ana nito bona naira nena sia wewoto.” ");
INSERT INTO sue_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ago senu nuto baro Yesu meni senua da ago ine tamuroto amire Betai Daininua amira ana-bona naira nena sia wewato awa. ");
INSERT INTO sue_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Naira be zora awenu Yesu nu nena naira masi amira baro aposolore dai arumuwa awa. ");
INSERT INTO sue_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ago wero nu numorekare ego senua awa, “Na yaya kaka tamamure bona ei awa nimorekare dai nanise duba wititinowia. ");
INSERT INTO sue_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Na me memeka nimorekare sana niniu. Na bona noko oko namunona. Bona me Anutu imata Tua wero nuamunoya amira natara ena kei awamunoya awa namunona.” ");
INSERT INTO sue_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ago sero nu akou zo pumuro Anuture kokopai asero amire ego senua awa, “Nikare akou ei awa puro te niwo. ");
INSERT INTO sue_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na nimorekare tona. Zeme emireta ama na ou wain noko oko namunona. Be Anutu imata Tua wamunoya amira be kei awai amire noko namunona.” ");
INSERT INTO sue_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ago sero nu porong pumuro Anuture kokopai asero eweweniro bua mai nusore potitinoise ego senua awa, “Pumuro niu. Ei awa pisi naso. Na nikare soremaise potitinona. Ama nikare na kotupitinoise ago ninoise noiwo.” ");
INSERT INTO sue_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ago senu nena niro tepo wewa amire akou ou wainire zo pumuro da ago inoise ego senua awa, “Ou wain ei awa orara naso. Orara naso awa nikare emo zozinona.* Orara ami Anuture tairo nuai amira ge seka awa ziai zewai wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ota gosinowa: ema na poti iwora nana wanera namu inoya ami namore dai nena naira masira itia. ");
INSERT INTO sue_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Na Emara Mai meni betai naso Anutu meni senu itewia amira te betamunona, ata ema na kerenamunoya nu awa, oi! ina nuso nogo pumamunoi?” ");
INSERT INTO sue_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nu ago senu giro nukare nutopekare atata ina-wa inoise ego sewa awa, “Nasokai nana ai meni wamunoi?” ");
INSERT INTO sue_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bua mai nukare ge meni ina-da inoise ego sewa awa, “Ai meni gita wai nasokai wamunoi?” ");
INSERT INTO sue_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ago sewa nu senua awa, “Zebura ema tua meni ema bama nukare souwarise towera. Noko ema putou bamure ami ema osai meni nukare bayao ema asarise towera. ");
INSERT INTO sue_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ata nikare ago oko wamunowa. Tepo awa. Ata ema zo nisokare nana ena bamu nisokare wamunoya ami osai ine wero nuaise. Ata giti kopi nisokare meni soumai ine wero nuaise. ");
INSERT INTO sue_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nikare seu. Ai meni bamu inoi — arumuro nena ninoise itia ami bamu inoita dopero nena potitinoya ami bamu inoi? Gosinowa, nena ninoise itia ami bamu inoya. Ata nane meni awa nisokare nana soe noise soumai ine wero nowena. ");
INSERT INTO sue_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Na yaya mokara nuawena nikare na kaka duamu namore dai nowewa. ");
INSERT INTO sue_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mama naso meni na nena dapikarago amira dia bamu wero nuanise putou namore potinua. Da ago nane putou nimorekare potitinona awa. ");
INSERT INTO sue_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Are na imata Tua wero nuamunona be amire nikare namore dai nena namunonakai. Nikare ema tuara arumai ago ine amira arumuro itise Isreli ema dubu 12 awa awina-dawina wamunowa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu meni Petoro emo zo amuro ego senua awa, “O Simon, sana nini. Wuit zasero wasawera me ewe puti ewe awinowia ago ine Satan meni nikare puro zasero wasamu sero senu Anutu meni nininua. ");
INSERT INTO sue_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ata na ni emo isa emoko sesena. Awa tuma diai niso besai azu isa sesena. Are ama ni noko ewesemuro otao mamai niso ziasa zewai wamunora.” ");
INSERT INTO sue_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ago senu Petoro meni numore ego senua awa, “Tua, ni benai sorata betaira bayasa na te bayamunona.” ");
INSERT INTO sue_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ago senu Yesu meni ego senua awa, “Petoro, na nimore me tona. Nine pi emire kokara ge kaka samure ‘Na Yesu kaka gamu’ ago sasa be etorobara wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nu numorekare ego senua awa, “Na gita nikare moni tepo kaita tepo sandol tepo iyetena nikare baro nena kau wisewita?” Ago senu nukare sewa awa, “Tepo.” ");
INSERT INTO sue_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ago sewa nu noko numorekare ego senua awa, “Ota zeme meni awa ema zo nu moni itia ami puro nuaise. Ota kaita puro noya ami da ago waise. Ota ema zo nu bogi waira kasiwa tepo giro tama woi nuso potaise zuma gayara nu noko bogi waira kasiwa zo zuma gaero pumae. ");
INSERT INTO sue_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na nimorekare tona ewa: Ge gayai ego itia ami naso nana ena me waise sai itia. Ge awa ego ewa, Nukare nu giwa lo ge dai ema ine wenua.” ");
INSERT INTO sue_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ago senu nukare ego sewa awa, “O Tua, giyo. Nakai bogi waira kasiwa eto itia ewa.” Ago sewa nu numorekare ego senua awa, “Nena amira oko tona. Dou!” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu nu Oliwa dirumura eyaya susawisonua, are be amire nu nata doro ago bamunua. Bamunu bua mai nukare nu ama ganero bamuwa. ");
INSERT INTO sue_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nu agewa amira kei awero numorekare ego senua awa, “Etetenai nisokare nana kei awamia, isa seu.” ");
INSERT INTO sue_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ago sero nu nukare doro omata saitiro apawenakai baro duwitinowia ago ine baro bawa diro isa toise ego senua awa, ");
INSERT INTO sue_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mama, ni yaya naso nana tupia awa gazamu wero giro gazeyo. Ota ni ara tamai nasora kota ara tamai nisora weyo.”  ");
INSERT INTO sue_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ago senu utura angelo zo meni osero nu zinu zewai wenua. ");
INSERT INTO sue_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu nu duba zazaumunu isa zewai wero toinu wiri nuso orara ine wero muro ose zebura ninua. ");
INSERT INTO sue_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nu isa tomite eriro bua mai nuso nana baro nukare duba nai tamuro mou wero gitawa inoiwa ginua. ");
INSERT INTO sue_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Giro awa-uzero numorekare ego senua awa, “Nikare nogoro gitawa inowi? Nikare eriu isa sawe. Inuawa nena etetenai ami muro nikare tamamia.” ");
INSERT INTO sue_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu nu ge ago toise itinu ema dubu bamu meni nuso nana muwa. Ema zazo nuso Yudas, nu awa bua mai 12 amira nana zo, nu ami gita wenu muwa. Nu Yesu imamu sero nuso nana zorage bamunua. ");
INSERT INTO sue_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ago wenu Yesu meni ego senua awa, “Yudas, ni nogoro na Emara Mai imai niso meni kereniro goroba emare potamu inosi?” ");
INSERT INTO sue_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ago senu bua mai Yesure dai itiwa nukare ami nena kei awamu inoinua awa giro ego sewa awa, “Tua, ni nakare kasiwa meni nukare danisekare kotupitinosita?” ");
INSERT INTO sue_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ago tuarise nusokare nana zo meni eriro pris bamura soumai awa damu wero dana wana mera awa kesenua. ");
INSERT INTO sue_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ago wenu Yesu nu awa giro ego senua awa, “Tani awa zeme do.” Ago sero nu wana poti danara ninu ewanana wenua. ");
INSERT INTO sue_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu nu pris babezinomare ibu bamura polis amira dia enire simai enire nukare nu ziro pumamu sero muwa giro numorekare ego senua awa, “Nikare kasiware dobare puro tupewa, awa goroba ema zo puro benamu mago inowa. ");
INSERT INTO sue_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Be giti awa na nimorekare dai ibu bamura ena nuawena nikare ana nogoro na kaka pumamu inowewi? Ata zeme ewa nikare ata mumera mama amira be awa.” ");
INSERT INTO sue_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ge ago senu nu saniro puro bamuwa. Nu puro pris bamubake amira nana so duru bamuwa. Ata Petoro meni awa asike noise nu ama ganenua awa. ");
INSERT INTO sue_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nukare so amira goma mokara toiwa eni meni niao wero amire arumuro awinoise itiwa Petoro nu numorekare dai arumuro itinua awa. ");
INSERT INTO sue_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sou bama diri zo meni Petoro niaora arumuro itinu ginu kei awenua, are nu ua inoise ego senua awa, “Ema ei awa nu Yesure dai nowia.” ");
INSERT INTO sue_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ago senua, ata Petoro meni begi inoise ego senua awa, “Bama, na nu awa kaka gamu.” ");
INSERT INTO sue_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ago senu borere tepo noko zo meni muro nu giro ego senua awa, “Ni dai ema amira bua mai zo.” Ago senu Petoro meni ego senua awa, “Otao, na tepo awa.” ");
INSERT INTO sue_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ama aua zo tepo wenu amire noko zo meni zewai wero ego senua awa, “Me memeka, ema ei awa numore dai nowia. Nu Galilaya ema zo.” ");
INSERT INTO sue_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ago senu Petoro meni ego senua awa, “Otao, ge niso tosa awa na kaka gamu awa.” Ago tuaise kokara ge senua. ");
INSERT INTO sue_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ago wenu Tua meni ewesemuro iri Petoro nana ninua. Ago wenu Petoro nu Tua meni ge gita numore ego senua awa kotumunua, “Nine pi emire kokara ge kaka samure gita ‘Na Yesu kaka gamu’ ago sasa be etorobara wamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petoro ge awa kotumuro kei damu niro di bamu senua awa. ");
INSERT INTO sue_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ema Yesu ziro puro itiwa ami nu sero isinoise dewa. ");
INSERT INTO sue_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ago inoise mo sibi meni giti moka nuso gogo wero zasero diro nu atata wero ego sewa awa, “Ni porofete wero giro se, ema ni doinoya amira zazo aweni?” ");
INSERT INTO sue_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ago sero nukare ge waya eni susumuro numore toise nu sero isewa awa. ");
INSERT INTO sue_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pina atinu Yuda emara giti kopire pris babezinomare lo ge gipai emare ami poti dara niro sewa ema Yesu puro aunaira bamuwa amire numore ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ni ge se. Ni Yuda emara Soyai Ema Kristota tepo ni?” asewa nu senua awa, “Na nimorekare samunona, ata nikare gawa oko me wamunoya. ");
INSERT INTO sue_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ota na ge enira nikare atata wamunona, awa nikare ge naso ina oko samunowa. ");
INSERT INTO sue_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ota be bamu bayamunonakai awa na Emara Mai meni Anutu putoure amira nana wana mera arumuro itamunona.” ");
INSERT INTO sue_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ago senu nukare ego sewa awa, “Are ni nitope Anutura Mai ni?” Asewa nu ego senua awa, “Iyo, na ewa. Aware nitopekare towa.” ");
INSERT INTO sue_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ago senu nukare ina-sa wero sewa awa, “Nakai ge ne noko ninamunonikai? Be nuso meni Anutura zazo dena-betena weti ninenakai waya wetia awa.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ago sero nukare dapikarago eriro nu puro baro Pilato nana potiwa. ");
INSERT INTO sue_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ana zaawero ge nuso sero ego sewa awa, “Ema ami nakare Yuda ema meni Roma emare bogi wanisekare duba nasokare gainoe doti susu nuso tamuo nu puro tupenakare. Nu nakare ema tua Sisare takis moni potai azu towia. Nu nutope ema tua nasokare zazo Kristo asinowia.” ");
INSERT INTO sue_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ago sewa Pilato meni nu atata wero senua awa, “Ni Yuda emara ema tua ni?” Asenu nu Pilatora ge ina toise ego senua awa, “Iyo. Tosa awa.” ");
INSERT INTO sue_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ago senu giro Pilato noko ewesemuro ema giti kopi ata ema bama diti bamu amire ego senua awa, “Na ge nera sero ema ei awa gera potamunoni? Na pasina nuso zo oko tamena.” ");
INSERT INTO sue_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ago senua, ata nukare ge beina wero ego sewa awa, “Nu nakare Roma emare bogi wanisekare duba gayawi ge nuso ami Yudaya zebu te inowia. Nu Galilaya zebura ena zaawero tupie nata emira ena da ago inoya.” ");
INSERT INTO sue_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ago sewa Pilato meni niniro nukare atata wero senua awa, “Ema ewa nu Galilaya emata?” ");
INSERT INTO sue_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ago atata wenu sewa nu Yesure ego ginua: nu zebu agewa Herode meni dia inoisonua amira mai zo. Be awa Herode nu Yerusalem nate itisonua, are Pilato meni Yesu potinu Herode nana bamunua. ");
INSERT INTO sue_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herode nu Yesu giro yawa sara wenua. Nera kota, nu gita bowi ge nuso niniro nu gamu yaba inoisonua. Nu Yesu meni tani putoure zo wai gamu toise noisonua. ");
INSERT INTO sue_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Are Herode nu atata werota wero awenua, ata Yesu meni ge zo numore ina kaka samu wenua. ");
INSERT INTO sue_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ata pris babezinomare lo ge gipai emare nukare ami nusoto nana zorage dopero Yesu gera zewai-zawai potiwa. ");
INSERT INTO sue_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ata Herode soldia nusore nukare nu puro osisinoise sero isimuwa. Isinoise mo owe neinere zo puro numa sawewa pumunu Herode ge senu numa noko puro Pilato nana bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Gita Herodeto Pilatore nuto iwo ina-wa inoise noisowato, ata waiko be amire awa nuto otao wewato awa. ");
INSERT INTO sue_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato nu pris babezinomare diare ema bamere zawa senu muro auniwa ");
INSERT INTO sue_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","numorekare ego senua awa, “Nikare ema ewa puro naso nana muro nu ema bama bogi warise duba gainoya ago sesewa, ata na benau nisokarera ena susu nuso gamu sero atata wetena. Ata sana niniu. Nikare ge nera sero ema ei awa gera potitinowi? Na pasina nuso zo da di oko tamena. Tepo awa. ");
INSERT INTO sue_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herode nu dai ago wero giro noko poti nasokai nana mia. Ata sana niniu. Pasina nuso meni betaira te oko inoya. ");
INSERT INTO sue_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Are na sana nu wamu meni dero besara bayamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ata tani ego ine inoisowa. Betai Daininua amira pura kei awasai Pilato meni ara tamai nusokarera mai zo besasai nusokare nana susawisonua. ");
INSERT INTO sue_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Are Pilato ge ago senu giro ema bama dubu bamu ami te-tetemo arero zawa sero ego sewa awa, “Ema awa deu betai, Barabas besawa kei awero nasokare nana mae.” ");
INSERT INTO sue_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas nu gita nata mokara ena bogi zo dia emare inomite mai zo denu betenu giro nu benai sora potiwa itisonua. ");
INSERT INTO sue_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato meni Yesu besamu sero numorekare ge noko senua, ");
INSERT INTO sue_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ata nukare noko zawa gatero ego sewa awa, “Nu ni pasinaira deu, nu ni pasinaira deu!” ");
INSERT INTO sue_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ago sewa nu noko numorekare senu be etorobara wenua, “Nogoro ago towi? Nu pasina ne wisi? Na pasina nuso waya nu dai betaira te awa kau inona. Are na sana nu wamu meni dero duara bayamunoya.” ");
INSERT INTO sue_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ata nukare ge beina inoise nu ni pasinaira ena betaise arero sewa. Ago sewa zawa gatai nusokare meni Pilatora ge puro osewa. ");
INSERT INTO sue_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ago sewa giro Pilato meni ge nusokare niniro zewai waise senua. ");
INSERT INTO sue_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ota ema gita bogi diare inomite mai denu betenu nu benai sora potiwa itisonua, nu awa ema bama meni pumamu sewa giro Pilato meni besenu bamunua. Ota Yesu meni awa Yuda ema meni nu betaise sewa giro Pilato meni soldia nana wanera potinua awa. ");
INSERT INTO sue_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nukare Yesu puro susaumite ema zo ebete ena tamuwa. Ema awa zazo nuso Simon; nu Sairini natara; nu muro nata bamura toyamu inoinu nukare nu saniro ni pasinai puro nuso nana gape potiwa dimuro Yesu ama ganero bamunua awa. ");
INSERT INTO sue_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ota ema bama dubu bamu nukare nu ama ganero bamuwa. Ota bama witai meni awa nu emo dire-buare inoise duba naire bamuwa. ");
INSERT INTO sue_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ata Yesu nu ewesemuro numorekare ego senua awa, “O Yerusalem bama mamai, nikare na emo oko di sawe. Nikare nitopekare ata mai awiso nisokare emo di seu. ");
INSERT INTO sue_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sana niniu. Ama be zo kei awamunoya be amire nikare duba nitinoise ego samunowa awa, ‘Bama eronaita bama tini azaita bama mai ami kaka gayamu ami* yawa sara warise.’ ");
INSERT INTO sue_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Be amire ema bama meni dirumure ego samunora awa, ‘Nikare nasokare nana tame duro patawe.’ Noko dirumu pei-mamaire ego samunora awa, ‘Nikare oseu nakare gowawe.’ ");
INSERT INTO sue_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nukare na ni busu wai ine awa puro niaora potitinora, are ama nukare nikare ni touwai ine awa puro nogo wamunori?” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nukare pasina mai eto Yesure dai dara betariseto puro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nukare bamuro so zo zazo Giti Kopira Wetu, amira kei awero Yesu ni pasinaira dewa awa. Ago wero pasina mai eto dai dero Yesu nana zo enibara zo enibara ago potiwa dopewato awa. ");
INSERT INTO sue_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ago wewa Yesu meni ego senua awa, “O Mama, nukare susu naso kaka gamu inoise tani ewa inoraya ni pasina nusokare do.” Ago senu nukare tama woi nuso awa kanowero pumaira kotumuro ozina laki wewa. ");
INSERT INTO sue_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ema bama nukare dopero ua inoise itiwa awa. Ota dia sai meni awa nukare numa isipitinoise ego sewa awa, “Nu gita ema eni soremuro kora inoisia, are Anutu nu pumunu Tua nasokai Kristo me wero noma giro nu nutope soremaise.” ");
INSERT INTO sue_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldia ema dai nu isimuwa. Nukare nuso nana zorage muro ou dokaka numore potiro ");
INSERT INTO sue_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ego sewa awa, “Ni Yuda emara ema tua noma giro ni nitope soremu.” ");
INSERT INTO sue_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Owe zo nuso nana ike ena ego gaewa awa, “Ema ewa Yuda emara ema tua.” ");
INSERT INTO sue_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pasina mai eto nuto dai ikoniwa amira zo meni Yesu isipitinoise ego senua awa, “Ni Soyai Ema nasokare Kristo asinoraya ni nitope sorepitinoise nato dai soremu.” ");
INSERT INTO sue_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ago senu pasina mai zo meni ge awa niniro numa seninoise ego senua awa, “Ni mou nune dipinoya ago ine dipinosa. Ni Anutu azu kaka wamu ni? ");
INSERT INTO sue_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nukare nage detera betinonage awa tani ewanana inora. Nera kota, nage tani waya gita wenage amira te tapinonage awa. Ata ema ami awa nu gita tani waya zo kaka wamu awa.” ");
INSERT INTO sue_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ago sero senua awa, “Yesu, ni ama ema tua wero noma kei awero na kotumuyo.” ");
INSERT INTO sue_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ago senu Yesu meni ego senua awa, “Na ge me nimore tona. Be zeme emire ni namore dai nata ewanana zazo Paradais amira itamunosa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Are waiko diti 12 klok wenu waikora zasimai tepo wenu mume bamu kei awero zebu te wero itinu 3 klok wenua awa. Ago wenu Anutura ibu bamura mo bamu* kimenai awa keero eto wenua. ");
INSERT INTO sue_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ago wenu Yesu nu zawa pena-pana gatero ego senua awa, “Mama, ititi naso wana nisora potitinona.” Ago senu ozana nuso tepo wenu betenua awa. ");
INSERT INTO sue_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldia emara dia meni tani awa giro Anutura zazo de ike nitinoise ego senua awa, “Me memeka, ema awa nu me pasina tepo.” ");
INSERT INTO sue_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ata ema bama dubu bamu muro dubu dero itise nena bamubamu kei awenua awa giro tepo wero nukare duba nitinoise noko ewesemuro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ata Yesura otao mamai ata bama mamai nukare nu ama ganero Galilaya ena muwa ami asikera dopero itise tani kei awenua awa giro tepo wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ema zo noisonua zazo nuso Yosefe. Nu Yuda emara nata zazo Arimatia amira ema. Numa Yuda emara giti kopi dubu amira zo. Numa ema kokopai, tani ewanana gege inoise noisonua. ");
INSERT INTO sue_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Otao mamai nuso meni Yesu gera potiro damu sewa nu ginu waya wenu nukare kaka soremamu donua. Ema ami Anutu imata Tua wero nuamunoya amira be dia noisonua. ");
INSERT INTO sue_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ema ami Pilato nana bamuro Yesura woi pumamu senua. ");
INSERT INTO sue_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Senu nininu woi nuso ni pasinaira ena puro mo kapawai iboi-tatana meni ewero poti omata so zo wamai amira ninua. Gita ema zora woi ago kaka potamu. ");
INSERT INTO sue_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tuwe Sabat purara nena amira korawai be amire omata sora potinu Sabat pura zora awenua. ");
INSERT INTO sue_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ota bama nukare gita Galilaya ena eriro Yesure dai muwa ami Yosefe ama ganero baro bi diti awa giwa awa. Ago inoise Yosefe nu Yesura woi nogo nogo potinu awa dai giwa. ");
INSERT INTO sue_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nukare giro noko ewesemuro so nusokare nana baro ou zamare ata gawi enire sia wewa. Sia wewa Sabat pura kei awenu giro nukare lo ge dipinoise doro itiwa awa. ");
INSERT INTO sue_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande pina atitinoinu pina-pana gamu nukare ou zamare gita sia wewa awa puro bi ditira bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Baro ego giwa: Omata bi ditira omata so gazai awa enibara baro itinu giwa. ");
INSERT INTO sue_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Are omata sora toiwa, ata nukare Tua Yesura woi kau wewa. ");
INSERT INTO sue_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nukare woi nuso kau wero itazaita inoise itiwa ema eto tama woi nusoto awa kapawero zasimai ami nusokare nana zorage dopero itiwato giwa. ");
INSERT INTO sue_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bama nukare giro azu wero iri dura zebura niro zebu ua wewa. Ata ema eto ami numorekare ego sewato awa, “Nikare nogoro giro ema nuai ewananare nowia awa betaira masira ena kau inowi? ");
INSERT INTO sue_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nu ego oko itia. Nu emoko eria. Nikare ge gita Galilaya itise nimorekare senua awa kotumuro giu. ");
INSERT INTO sue_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nu nimorekare ego senua, ‘Nukare na Emara Mai poti pasina emara nana wanera namunora. Ago wara nukare na ni pasinaira dara betamunona. Betero be etorobara ago tepo wai amire noko seka wero eramunona.’ Nimorekare ago senua.” ");
INSERT INTO sue_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ema eto meni ago sewato giro bama nukare Yesu ge gita senua awa kotumuwa kei awenua. ");
INSERT INTO sue_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Are nukare bi diti doro noko ewesemuro baro bua mai nuso 11 ata ema bama enire dai nena kei awenu giwa amira ge uge wewa awa. ");
INSERT INTO sue_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bama ami ge awa aposolore sewa: Maria nu Madalara, ata Yoana, ata Yakobora mia Maria, nukare ata bama eni ami ge awa aposolore sewa. ");
INSERT INTO sue_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ata aposolo meni bamera ge niniwa me amu wenu giro dowa. ");
INSERT INTO sue_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ata Petoro meni awa eriro sumuro baro omata sora ena dupuniro iri du niro mo gege itinu ginua. Ago wero noko ewesemuro sora baro nena kei awenua amira susu kau inoise kotumai saisai wenua. ");
INSERT INTO sue_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ata waiko be da amire nusokare nana ema eto nuto aita wero bamu nata kiaka zo zazo Emeas amira namu bamuwato. Ebata awa Yerusalem doro bamu Emeas nai awa 11 kilomita. ");
INSERT INTO sue_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nuto susawiseto ge nena bamubamu kei awenu giwato amira uge didinoise ");
INSERT INTO sue_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","susauwato Yesu nu nutope kei nusoto nana niro numoreto dai bamunua. ");
INSERT INTO sue_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nuto numore dai susawise nu giwato oko kei awenua, nera kota, Anutu meni kotumai nusoto siro-siro wenua. ");
INSERT INTO sue_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nu numoreto ego senua awa, “Nito nena nera toise susawewito?” Ago senu nuto doperoto duba nitinoise itiwato. ");
INSERT INTO sue_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ago inoise nusoto nana ema zo zazo nuso Kliopa ami ge ina ego senua awa, “Esewa Yerusalem ena aunitinoise nowera ami tani bamubamu be zeme emire kei awitaya amira oziga awa ninitinora. Ata ni imata ami kaka ninamu inosa, atonua!” ");
INSERT INTO sue_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ago senu Yesu meni nuto atata wero ego senua awa, “Tani nere towito?” Ago senu nuto numore ego sewato awa, “Tani awa Yesu Nasarete natara ema amira nana kei awitaya. Nu porofete, are nu tani putoure inoise ge putoure tugata inoise Anutu nana benaura o ema bama nana benaura nowia. ");
INSERT INTO sue_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ata pris babezinomare ema giti kopi babezinoma nasokaire meni numa iwora wanera potera nukare ge tiro nu dara betaise sero nu ni pasinaira detera betitaya. ");
INSERT INTO sue_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ata nakare ego kotupitinoise nowenakare. Ema ami Isreli ema nakare iwora wanera ena soyamunoya. Awa daba kota, detera beteti nonakai waiko be etorobara inoya. ");
INSERT INTO sue_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ata be zeme emire bama eni dubu nasokarera nunekare ami ge zo sesera nakare niniro kotumai sisinoise itazaita inonakare. Awa nukare pina-pana gamu eriro bi ditira baera. ");
INSERT INTO sue_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ata nukare Yesura woi kaka tamamu wetera. Ago wero nukare noko tera ewesemuro ge ego sesera, ‘Nakare angelo genakare angelo meni nu noko seka wero eria ago seserato.’ ");
INSERT INTO sue_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bama meni ago sesera giro ema eni dubu nasokarera ami eriro bi ditira baro bama meni sesera te ago ine gera. Ata numa kaka tamamu wetera.” ");
INSERT INTO sue_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ago sewato giro Yesu meni numoreto ge ego ine senua awa, “O nito kotumai tepo. Ge dapikarago porofete meni gaewa awa nikare nogoro gai me waira timara inowewi? ");
INSERT INTO sue_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Soyai Ema Kristo nu gita yaya tamuro amire ama simai zasimaire nuso pumaise sai itia, awa nikare kaka gamu ni?” ");
INSERT INTO sue_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesu meni ago sero ge nuso Tuara gera gaewa itewia amira susu awa numoreto kerenamu sero ge Mose ata porofete dapikarago meni gaewa amira ana zaawero tutuku-tataka niro senua awa. ");
INSERT INTO sue_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nukare susaumite nata amira kei awamu zorage awewa Yesu nu bayaira wenu ");
INSERT INTO sue_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","nuto nu soero sewato awa, “Waiko osisinoi pi emoko ziamu inoya. Are ni namoreto dai itamunosa.” Ago sewato giro nu numoreto dai toiro itinua. ");
INSERT INTO sue_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ago itise nukare nena namu inoise nu ame pumuro kokopai Anuture sero ewero numoreto potinua awa. ");
INSERT INTO sue_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nu ago numoreto wenu nuto nu giwato kei awenu giro nu tutamu tepo wenua. ");
INSERT INTO sue_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ago wenu nuto sewato awa, “Nakai ebete aita inonakai nu namorege ge tugata wetia, noko gera susu namorege kerenia, be amire moka nasoge meni kare wietia.” ");
INSERT INTO sue_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nuto ge ago toiseto eriro aita wero noko ewesemuro Yerusalem bamuwato awa. Ago wero nuto bua mai 11 ata otao mamai enire auniro itiwa tamuwato awa. ");
INSERT INTO sue_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tamuwato nukare numoreto ego sewa awa, “Me memeka, Tua noko tera eria. Eriro Simon nana kei aweti gia.” ");
INSERT INTO sue_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ago sewa nuto ebete ena aita inoise tani wewa amira uge didinoise sewato awa, “Nu ame eweti amire nato nu genato kei awetia.” Ago sewato awa. ");
INSERT INTO sue_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nukare ge awa toise itiwa Yesu nu nutope nusokare nana soe damu dopero ego senua awa, “Nikare duba ewananare itiwo.” ");
INSERT INTO sue_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ata nukare titibi awero bita asero azu bamu wewa. ");
INSERT INTO sue_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ata nune numorekare ego senua awa, “Nikare nogoro itazaita inoise kotumai nisokare sisinowi? ");
INSERT INTO sue_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nikare te-wana naso giu, na natope kei awero itena. Wana nisokare meni na ziro giu. Bi awa tama aiso tepo, ata nane meni awa tama aisore itena ewa.” ");
INSERT INTO sue_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ago sero nu te-wana nuso numorekare gipenua. ");
INSERT INTO sue_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ago wenu nukare nu giro yawa sara bamu wewa, ata noko itazaita wero ge tepo wenu usero itiwa awa. Ago wewa giro nu numorekare ego senua awa, “Nikare nena nai eni ego itita?” ");
INSERT INTO sue_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ago senu giro wo ita gita moewa itinua awa potiwa ");
INSERT INTO sue_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","nu nusokare nana benaura ena puro ninua. ");
INSERT INTO sue_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nu ge numorekare ego senua awa, “Gita na nimorekare dai noise ego sena awa, ‘Ge namore gita gaewa — Mosera lo ge enata porofetera bukura enata Sam bukura ena gaewa — ge awa dapikarago me wamunoya. Ago sena.” ");
INSERT INTO sue_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ago sero nu kotumai nusokare zinu zazenu nukare be amire Anutura ge gayai amira susu giwa kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nu numorekare ego senua awa, “Anutura ge gayai ego ine itia. Na Soyai Ema nisokare Kristo meni yaya tamuro betana waiko be etorobara tepo wai noko bi ditira ena eramunona. ");
INSERT INTO sue_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Are nikare Yerusalem ena zaawero oziga naso kerenawa ema bama dubu sero meni niniro zazo naso zawa toise duba kapetenara amire Anutu meni pasina nusokare duamunoya. ");
INSERT INTO sue_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nikare nena bamubamu gosinowewa amira ge kereniro toise noiwo. ");
INSERT INTO sue_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Sana niniu: Ozana Mama naso meni nimorekare potamu senua awa iyetana ose nisokare nana namunoya. Ata nikare nata ewa oko duawe. Nikare ego itawa putou utura ena ose nisokare nana nai amire nata doro buara bayamunowa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesu meni ago sero nukare puro bamu Betani nate niro nu wana buyaniro nukare gawa wenua. ");
INSERT INTO sue_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nu nukare gawa inuaise Anutu nu pumunu nu nukare doro witi utura ninua. ");
INSERT INTO sue_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ago wenu nukare nu bowi wero yawa sara bamubake inoise noko tera ewesemuro Yerusalem bamuwa. ");
INSERT INTO sue_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ago baro noise nukare be eyaya ibu bamura toiro Anutura zazo de ike nitinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bera ge* nu nuai gege noisonua. Bera ge nu Anutura nana giti mokara noisonua. Bera ge nu nutope Anutu. ");
INSERT INTO sue_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nu awa gita susura ena Anuture dai nuai gege noisonua. ");
INSERT INTO sue_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Bera ge nu Anutura wana wero nena dapikarago wero tepo wenua. Ota nena kei awenua, awa nu tepo nena zo oko kei awenua. ");
INSERT INTO sue_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ota wero nuai awa nuso nana itisonua. Are nuai awa emara nana zasimuro itisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Zasimai* ami mumera zasimunu mume meni zasimai siramu sero kaputinua, ata zasipitinowia awa. ");
INSERT INTO sue_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anutu meni ema zo potinu kei awero noisonua zazo nuso Yohane. ");
INSERT INTO sue_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nu ami zasimaira oziga samu munua. Ema bama dapikarago zasimaira Mama tuma diarise sero Anutu meni senu kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohane nu nutope zasimaira Mama oko aewa. Nu zasimaira oziga gege awa emare samu munua. ");
INSERT INTO sue_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Zasimai me nu ema bama dapikarago awa zasimai potitinowia ami be amire zebura kei awero noisonua. ");
INSERT INTO sue_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nu zebura itisonua. Awa gege oko aewa. Zebu dai nune wenua awa. Ago wenua, ata zebura ema bama nukare nu oko giro baitiwa. ");
INSERT INTO sue_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nu zebu nusora kei awenu dubu nuso meni nu giro gago-giago awewa. ");
INSERT INTO sue_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ata eni meni awa nukare Yesu otao wewa, o Yesu tuma diwa ami Anutura mai awiso warise sero Yesu meni zazo nusokare senua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nukare emara orarara ena oko kei awewa. Nukare emara ara tamaira kota, o emara sai zewai waira kota, nukare Anutura putoura kei awewa awa. ");
INSERT INTO sue_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bera ge nu ema wero kei awero nasokare nana soe noisonua awa. Ago wenu nakare simai zasimaire nuso ginakare. Nu Anutura Mai me, are simai zasimaire nuso nana gege itisonua awa. Nuai me ata dumi yagaba awa duba nusora bera munu puro osenua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Susu nuso Yohane meni poti damu niro zawa sero ego senua awa, “Na nu amire sena awa, ‘Ama tupia ami nu gita wai naso inoya. Nera kota, na kaka kei awamure nu noisonua.’” Yohane meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nakai dapikarago ami dumi yagaba ewa-gaewa awa zamai nusora ena purota puro awinowenakai. ");
INSERT INTO sue_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Anutu meni lo ge namorekai potamu sero Mosere potinua awa. Ota Anutu meni dumi yagabare nuai mere awa namorekai potamu sero Yesu Kristore potinu puro munua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Anutu nu ema zo meni oko ginua. Tepo-tapo awa. Are Mai nuso daimata nuso nana zazene itima awinoya ami Mama nuso namorekai kereninua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yuda ema meni Yerusalem ena pris enire wana soga enire sewa bamuro Yohane atata wero ego sewa awa, “Ni ema aweni?” ");
INSERT INTO sue_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ago sewa Yohane nu susu nuso kaka bezamu kereniro ego senua awa, “Na Soyai Ema nisokare Kristo tepo.” ");
INSERT INTO sue_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ago senu nukare noko atata wero ego sewa awa, “Ina ni aweni? Ni Elia, Kristora awi mai ni?” Ago sewa nu ego senua awa, “Na Elia tepo.” Ago senu nukare ego sewa awa, “Ni porofete dia inowenakare awa ni?” Ago sewa nu ego senua awa, “Tepo awa.” ");
INSERT INTO sue_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ago senu nukare noko atata wero ego sewa awa, “Ina ni aweni? Nakare baro ema babezinoma nakare sesera menakare amire nogo samunonikare? Ni nitope nogo towesi?” ");
INSERT INTO sue_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ago sewa nu ina ego senua awa, “Porofete Yesaya meni ge zo gaenua awa naso nana ena me inoya. Na oziga sai ema ware gamu-gamura ena noise ego towena awa, ‘Tuara ebata kora weu sonae.’” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ema Yohane nana muwa awa Farisayo meni potiwa muwa awa. ");
INSERT INTO sue_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Are nukare nu noko atata wero ego sewa awa, “Ni Soyai Ema nasokare Kristo-ko sia, o Elia-ko sia, o porofete-ko sia ago tosa agiyo. Are ni nogoro ema bama ge ou gutinosi?” ");
INSERT INTO sue_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ago sewa Yohane meni ina ego senua awa, “Na ema ou gege gutinona awa. Ota nisokare nana ena zo kei awamunoya, nikare nu oko gosinowewa. ");
INSERT INTO sue_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nune naso nana atune mamunoya ami ema bamubake awa. Na ema osai me osai ami sandol* nusora asi besai ine te oko inoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Susu awa nata zazo Betani, ou Yodan enibara itisonua, amira ana kei awenua. Yohane meni ago noise ana ema bama ge ou gutinoisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pina atinu Yesu meni Yohane nana susaunu aikera ena giro ego senua awa, “Ou giu. Anutura lama. Nune ami zebu serora pasina nusokare dimuro betamunoya. ");
INSERT INTO sue_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na nu amire sena awa, ‘Ama mamunoya nu ami gita wai naso inoya. Nera kota, na kaka kei awamure nu noisonua awa.’ Numa owa. ");
INSERT INTO sue_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na natope nu gita oko gina kei awenua. Ata Isreli ema nikare oziga nuso sana ninawise sero na kei awero ge ou zaawena.” ");
INSERT INTO sue_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohane meni emare ge ago sero senua awa, “Ozana meni ni guma ine wero utura ena osero nuso nana arumuro iti goisena. ");
INSERT INTO sue_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na gita nu oko gina kei awenua, ata Anutu meni nane ema bama ge ou gutanise sero ego senua awa, ‘Ozana osero nuso nana arumuro itai ema ami ge sai amire ema bama Ozana pumamunora.’ ");
INSERT INTO sue_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Are nama ana susu nuso giro ego tona ewa: Nu Anutura Mai me awa.” Yohane meni ge ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pina atinu Yohane ata bua mai nuso eto ami dopero itiwa ");
INSERT INTO sue_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesu tupinu giro Yohane meni ego senua awa, “Anutura lama owa.” ");
INSERT INTO sue_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ago senu bua mai nuso eto meni ge awa niniro Yesura nana ama bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bamuwato Yesu meni kapeteniro giro numoreto ego senua awa, “Nito ne kau inowito?” Ago senu nuto ego sewato awa, “Rabai, (Ge nasokaira, “Gipai ema”) ni so nera itesi?” ");
INSERT INTO sue_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ago sewato Yesu meni ego senua awa, “Muuto gaweto.” Ago senu mai eto meni nu ama ganero sora witiwato awa. Witiroto waiko be da numore dai itiwato. Awa waiko diti osisinoinu 4 klok wenua, are ago wewato awa. ");
INSERT INTO sue_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nuto Yohanera ge niniro Yesu ama ganewato amira zo zazo nuso Anderea. Nu Simon Petorora nami. ");
INSERT INTO sue_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anderea nu nami nuso Simon eya tamuro ego senua awa, “Nato Yuda emara Soyai Ema zazo Mesia awa tamenato.” (Mesia awa Kristo). ");
INSERT INTO sue_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ago sero Yesura nana uzumunu baro kei awewato Yesu meni Petoro giro ego senua awa, “Zazo niso Simon. Ni Yohanera mai. Ata na zazo niso seka Sifas asinona awa.” (Ge nasokaira, “Omata Arama”) Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pina atinu Yesu nu Galilaya zebura bayamu sero eriro Filip tamuro ego senua awa, “Ni na ama gane.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip nu Besaida natara. Andereato Petorore nuto dai nata da amira. ");
INSERT INTO sue_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Are Filip meni Nataniel tamuro ego senua awa, “Ema Mose meni lo gera ge nuso gaenua, o porofete eni meni da ago gaewa, ema awa tamenakare. Nu Yesu, Yosefera mai. Nu Nasarete natara awa.” ");
INSERT INTO sue_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ago senu Nataniel meni ge ina ego senua awa, “Nena kokopai zo meni Nasarete nate ena kei awai te inoita?” Ago senu Filip meni ina ego senua awa, “Ago tosaya mu baro gase.” ");
INSERT INTO sue_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ago senu Nataniel nu Yesu nana bamunu Yesu meni giro ego senua awa, “Ei giu. Ema ei awa Isreli ema me. Ge opi sai duba nusora tepo.” ");
INSERT INTO sue_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ago senu Nataniel meni Yesu atata wero ego senua awa, “Ni nogo nogo wero susu naso gosinosi?” Ago senu Yesu meni ina ego senua awa, “Filip meni ni kaka tamamure nane ni ni fik susura itesa gena awa.” ");
INSERT INTO sue_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ago senu Nataniel meni ina ego senua awa, “Gipai ema, ni Anutura Mai me. Ni Isreli emara ema tua.” ");
INSERT INTO sue_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ago senu Yesu meni ina ego senua awa, “Ni fik susura itesa giro sesena amira gege na tuma didinosua. Tani zeme gesa awa osino gege. Ata ama nena me bamu kei awero bayai gosinuamunosa.” ");
INSERT INTO sue_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ago sero numore ego senua awa, “Na me memeka sane. Nikare utu be zaumai amire Anutura angelo dubu meni na Emara Mai amira nana witiro osero awara gamunowa awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Waiko be eto tepo wenu Galilaya zebura nata zo zazo Kena amira ana ema zo bama ataise amira nena asa-waura wewa mu nate ninu Yesura mia dai ago itinua. ");
INSERT INTO sue_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu ata bua mai nuso nukare dai aunarise sewa giro baro auniwa awa. ");
INSERT INTO sue_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Auniro itise ou wain niwa tepo wenu giro Yesura mia meni numore ego senua awa, “Ou wain nusokare tepo wetia.” ");
INSERT INTO sue_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ago senu Yesu meni ina ego senua awa, “Na nukare soremamunona asero tosita? Amira be naso kaka mamu.” ");
INSERT INTO sue_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ago senu amire mia nuso meni soumaire ego senua awa, “Yesu meni bua zo wawise sai giro ge nuso dimuwo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Are so amira au babezinoma 6 ago itiwa awa. Yuda emara nana so sero au ago ine itasai amire nukare ewowora tani inoise nenare tamare sewinoisowa. Au awa babezinoma. Au daimata amira ou pake 10 meni niginoisowa. ");
INSERT INTO sue_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Are Yesu meni soumaire ego senua awa, “Nikare ou dumuro aura zozeu bera mare.” Ago senu soumai meni ou dumuro aura zozewa bera muwa awa. ");
INSERT INTO sue_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ago wewa amire nu ego senua awa, “Nikare ou aura awa eni dumuro bonara mamera nana puro bamuu.” Ago senu giro puro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Dumuro puro bonara mamera nana susauwa ou wain wenua awa. Puro bamuwa bonara mama meni ninu be zozowa wenua. Ago wenu nu ou wain awa nana munu amira susu nu kaka gamu, ata soumai ou dumuwa ami giwa. Are bonara mama meni ema bama atitinoinua awa zawa senu munu ");
INSERT INTO sue_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ego senua awa, “Gita ou wain me potawenakare nawera duba sirawi amire ou wain zuma osai awa ama potawenakare ninowera. Tani nasokare ago itia awa. Ata nine meni awa ou wain me bezero ou wain zuma osai gita potesa nera amire me ama puro potitinosa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu nu Kena nate Galilaya zebura ana tani putoure nuso gita zaawero tani awa wenua awa. Ago wero nu putou nuso kereninu bua mai nuso meni tani putoure awa giro nu tuma diwa awa. ");
INSERT INTO sue_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ataira bona tepo wenu Yesu nu Kena nate ena bamu Kapaneam nate namu inoinu mia nuso namisinire ata bua mai nuso nukare dai bamuwa awa. Baro ago be dainiro oko noiwa. ");
INSERT INTO sue_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yuda emara pura zo zazo nuso Betai Daininua amira be zora awenu giro Yesu meni Yerusalem witiro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yerusalem nate kei awero Anutura ibu bamu amira baro osi zora ena lama ata bulimakao ata ni guma awa puro baro ina-pota inoise noiwa ginua. Noko eni meni moni tebol tame potiro moni ina-pota inoise itiwa awa. ");
INSERT INTO sue_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ago inoiwa giro Yesu meni asi tenero ami lama bulimakao emare tunenu bamuwa tebol monire ziro kapeteninu moni ose dura ninua awa. ");
INSERT INTO sue_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ago wero ema ni guma puro dopero itiwa amire ego senua awa, “Puro bamuu. Nikare Mama nasora ibura ena nena ina-pota wawa stoa ibu ine wai azu tona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesu ago wenu bua mai nuso meni ge zo gayai itewia awa kotumuwa. Ge awa ego ewa, Ibu niso emi emo tini naso kapinoya. ");
INSERT INTO sue_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Are Yuda ema meni Yesu atata wero ego sewa awa, “Ai meni sesi tani awa wetesi? Anutu meni sai wamesa sia, awa susu awa poti damu namu sero tani putoure zo we ganekare.” ");
INSERT INTO sue_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ago sewa Yesu meni be nusokarera pumuro ina ego senua awa, “Nikare ibu ei awa ziwawa nane waiko be etorobara gege eya wana noko dopamunoya.” ");
INSERT INTO sue_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ago senu nukare ego sewa awa, “Mamana nasokare meni ibu ei awa zepa 46 ago gapinoe pesuniwa, awa nine waiko be etorobara gege wasa dopaise tosa?” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ata Yesu nu tama aiso nusora ge awa ibu bamura potiro senua awa. ");
INSERT INTO sue_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Are ama noe betero betaira ena seka wero erinu amire bua mai nuso meni ge awa kotumuwa awa. Ago kotupitinoise Anutura ge gayai eni amire ge Yesu meni senua amire awa giwa me wenua. ");
INSERT INTO sue_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu meni Yerusalem itise pura amira ana tani putoure eni wenu ema dainiro meni tani putoure awa giro Yesu tuma diwa awa. ");
INSERT INTO sue_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesu nu nutope emara moka gosinoise susu nuso numorekare kaka kerenamu wenua. ");
INSERT INTO sue_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nu ema zora susu gamu sero ema eni oko atata inoisonua. Nu nutope emara kotumai giro baititinoisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ema zo noisonua zazo nuso Nikodemo. Nu Farisayo zo. Nu Yuda emara gita wai bamubake noisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ema ami pire Yesu nana baro ego senua awa, “Gipai ema, nakare susu niso gosinowenakare. Ni gipai ema me meni Anutura bera mutasa. Ni tani inowesa awa ema zo meni Anutu tepo noise wai ine oko itia.” ");
INSERT INTO sue_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ago senu Yesu meni ina numore ego senua awa, “Na me memeka sana gi. Zo nu kei awai seka noko kaka kei awamu wamunoya, awa nu Anutura nata gai ine tepo wamunoya.” ");
INSERT INTO sue_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ago senu Nikodemo meni ina ego senua awa, “Zo nu zai wai meni nogo wero amire kei awai seka kei awamunoi? Nu miera tinira noko toyai amire pumai te oko inoi, tanita?” ");
INSERT INTO sue_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ago senu Yesu meni ina ego senua awa, “Na me memeka sana gi. Zo nu oura ata Ozanara putou amira kaka kei awamu wamunoya, awa nu Anutura nate bayai ine tepo wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Zo nu mia meni pumai awa zebura tama aisore dai nowia. Ata zo nu Ozana meni pumai awa Ozanare dai nowia. ");
INSERT INTO sue_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nikare kei awai seka kei awawise sesena awa niniro di oko tainase. ");
INSERT INTO sue_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bisi nu tebe-tabe tupewia, ata ni awi nuso gege ninitinowesa, o susu nana zaawero tupi, o baro nana tepo inoi, awa ni oko gosinowesa. Da ago ine zo nu Ozana meni pumai amira susu ni oko gosinowesa.” ");
INSERT INTO sue_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ago senu Nikodemo meni ina ego senua awa, “Tani awa nogo nogo wero kei awamunoi?” ");
INSERT INTO sue_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ago senu Yesu meni ina ego senua awa, “Ni Isreli emara gipai ema meni tani awa kaka gamu ni? ");
INSERT INTO sue_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na me memeka sane. Nakare nena kotumai meni gosinowenakare, o nena giti moka meni goisenakare da awa towenakare awa. Ago wawenakare amire nikare ge nasokare dotinowewa awa. ");
INSERT INTO sue_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nena zebura kei awinowia awa sawena gawewa me kaka wamu inowia ami utura nena itia awa sana nogo nogo wero gawa me wamunoi? ");
INSERT INTO sue_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ema zo meni utura witiro noe oko osenua. Na Emara Mai imata utura ena osena. Nane gege imata utura nena gosinona. ");
INSERT INTO sue_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mose meni gita ware ena kapa puro zi kewero puro witiro ni pasinaira ikoninua, da ago ine na Emara Mai ni pasinaira witanise sai itia. ");
INSERT INTO sue_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Are na tuma diamunora ami nuai me ewanana awa tamamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Zo nu Anutura Mai tuma diamunoya ami betaise kota, nu nuai me ewanana tamaise sero Anutu meni ema nakai emo duba bayao bamubake inoise Mai nuso daimata potinu osenua awa. ");
INSERT INTO sue_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anutura Mai meni ema gera potaise kota, ema soyaise sero Anutu meni senu osenua awa. ");
INSERT INTO sue_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Zo nu Anutura Mai tuma diamunoya ami Anutura kotora ena oko duwamunoya. Zo nu Anutura Mai kaka tuma diamu wamunoya nu ami kotora ena emoko duwia ago ine wamunoya. Nera kota, nu Anutura Mai daimata awa kaka tuma diamu inoya. ");
INSERT INTO sue_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Are kotora ena duwai amira susu ego itia awa. Zasimai meni zebura kei awenu ema nukare zasimaira bayai azu sero mumera dago itamu sewa awa. Nukare nuai nusokare waya, are ago wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Zo nu pasina inowia ami zasimai azu inowia. Zasimai meni pasina nusora susu kerenai azu inoise nu zasimaira oko kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nukare ge me niniro puro nowera ami zasimaira kei awinowera awa. Zo nu zasimaira kei awawi zasimai meni bua nusora susu kerenawi ema bama meni giro bua nusora me awa Anutura putoura kei awinowia, ago samunora awa. ");
INSERT INTO sue_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesu meni bua mai nuso pumunu Yerusalem doro Yudaya zebu agewara baro noisowa. Ago noise amire ema eni ge ou gutenua. ");
INSERT INTO sue_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohane dai ema bama ge ou gutinoise itinua. Nu zebu zo zazo Ainon, Selim nate kena ago noise ge ou gutai bua inoisonua. Nu zebu amira ana inoisonua, nera kota, ou bamu ago itisonua. Are ema bama nuso nana kokounasara ge ou gutinoisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yohane nu be amire Herode meni benai sora kaka potamu noise bua awa inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Are Yuda ema zo ata Yohanera bua mai nukare tama aiso sewaira tani amira ge ina-sa wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ge tomite bua mai meni bamu Yohane nana niro ego sewa awa, “Gipai ema, ni ou Yodan enibara ena nosa ema zo ni tami susu nuso kereniro namorekare sisesa. Ema ami be zeme emire ema bama ge ou gutinoise iti giro dapikarago nuso nana susawera.” ");
INSERT INTO sue_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ago sewa Yohane meni ego senua awa “Ema zo nu utura Mama meni nena numore kaka potamu wai nu nutope nena awa pai ine tepo. ");
INSERT INTO sue_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Na ego toise nimorekare sesena goisewa awa, ‘Na Kristo oko aewa. Anutu meni na potinu nane ebata nuso gita inona.’ ");
INSERT INTO sue_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ema zo bama atamunoya bama awa nuso gege awa.* Are nu yawa sara inuai otao nuso meni zorage dopero ge nuso niniro da ago duba kokopai wamunoya. Ema bama meni Yesura nana bamitara, are duba kokopai waira be naso kei awitaya. ");
INSERT INTO sue_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nune witai gege wititinuamunoya. Ata nane meni awa osamunona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ike ena osenua ami witai nasokai awa. Zo nu zebura ena kei awai ami zebu emira, are nu zebura ge towia. Ota utura ena osenua ami nakai dapikarago dainiro bamu nasokai wero nowia awa. ");
INSERT INTO sue_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nune utura nena gosinoisonua awa namorekai kereniro towia, ata ema meni ge nuso dotinowera. ");
INSERT INTO sue_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Zo nu Maira ge niniro puro poti dube niro nowia ami ago inoise “Anutu ge me towia,” asinowia. ");
INSERT INTO sue_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ema Anutu meni senu osenua ami Anutura ge towia. Nera kota, Anutu meni Ozana zere dago numore potai gege potitinowia. ");
INSERT INTO sue_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mama nu Mai nuso ara tapinoise nena bamubamu dapikarago Maira nana wanera potinu itewera. ");
INSERT INTO sue_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Zo nu Anutura Mai tuma didinowia ami nuai me ewanana puro nowia. Ata zo nu Anutura Mai amira ge dero nowia ami nuai me ewanana oko gamunoya. Ema ago amira nana Anutura tini kapai meni itai gege itamunoya. ");
INSERT INTO sue_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisayo nukare Yesura oziga ego niniwa awa, “Yesu nu ema dainiro puro ge ou gutinoya, are bua mai dubu nuso meni Yohanera bua mai dubu awa dainitinoya.” Ago niniwa awa. ");
INSERT INTO sue_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ata Yesu nu nutope ema zo ge ou kaka gutamu. Bua mai nuso meni ema bama ge ou gutinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Are Farisayo ge ago ine niniwa giro Yesu meni Yudaya zebu doro ewesemuro Galilaya zebura bamunua awa. ");
INSERT INTO sue_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ebata awa Samaria zebu busero susawisonua. ");
INSERT INTO sue_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesu meni zebu awa busero susaumite Samaria nata zo zazo Saika amira kei awenua awa. Nata awa Yakobo meni mai nuso Yosefere zebu agewa potinua amira zorage itisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ota zebu da amira Yakobora ou ura wamai zo itisonua. Are Yesu nu ago kei awero waiko soe dopenua, are putou tepo wenu giro ou ura wamai amira zorage arumunua awa. ");
INSERT INTO sue_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Arumuro itinu Samaria bama zo ou dumamu sero munua. Munu Yesu meni giro numore ego senua awa, “Ou poti nane.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Bua mai nuso nukare ma pumamu sero nate witiwa nu imata itimite bamere oura ge senua awa. ");
INSERT INTO sue_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Senu bama meni numore ego senua awa, “Ni Yuda ema meni nogoro ou emo Samaria bama namore ge tosi?” Ago senua, nera kota, Yuda emare Samaria emare nukare kapero noisowa, are bama meni ge awa senua. ");
INSERT INTO sue_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ago senu Yesu meni ego senua awa, “Ni Anutu dumi pai nusora susure, o ou emo tona amira susure gamesa, awa ni ou emo namore begomo sasa na nuai me ewanana amira ou awa nimore potamena.” ");
INSERT INTO sue_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ago senu bama meni ina ego senua awa, “Ou ura awa tura me tura. Agoro ni kopi ou dumai tepo. Are nuai me ewananara ou awa nana pamunosi? ");
INSERT INTO sue_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ewowo nasokai Yakobo nu ou ura ei awa wamunua. Ago wenu nu ata mai awiso nuso ata lama bulimakao nukare dapikarago ami ou ei awa ninoise noisowa. Nu ou ura ei awa namorekai dirieninua. Ata ni Yakobo dainitinosa, ago tosita?” ");
INSERT INTO sue_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ago senu Yesu meni ego senua awa, “Ou ei awa nawewa noko ou uza eya inowia. ");
INSERT INTO sue_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ata ou nane potamunona awa zo meni nai ou uza noko oko wamunoya. Nane ou awa ema zore potana duba nusora ena ou kupi-kupi inuamunoya. Ago inuai ema ami nuai me ewanana puro nuamunoya.” ");
INSERT INTO sue_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ago senu bama meni ego senua awa, “Ema, ni ou awa potasa niro ou uza kaka wamu nuane. Ago wero ou emo eyaya ego tupewena awa duane.” ");
INSERT INTO sue_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ago senu Yesu meni ego senua awa, “Ni baro ema niso puro maweto.” ");
INSERT INTO sue_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ago senu bama meni ina ego senua awa, “Na ema tepo.” Ago senu Yesu meni ego senua awa, “Ni ema niso tepo awa me tosa awa. ");
INSERT INTO sue_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ni ema wana da ago atiro doro awinowesa. Agoro be zeme ewa ni ema zore nosa, ata nu ema niso tepo, are ni ge me tosa.” ");
INSERT INTO sue_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ago senu bama meni ego senua awa, “Ema, na zeme susu niso gosinona. Ni porofete me. ");
INSERT INTO sue_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Are se gane. Zezewenai nasokare nukare dirumu emira* ena auniro Anutura yere gapise ge ninise awinoisowa. Ata Yuda ema ninekare meni awa Yerusalem nate ena Anutu isa sise yere gapise awinoise nuanisekai sai itia ago towewa.” ");
INSERT INTO sue_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ago senu Yesu meni ina ego senua awa, “Bama, na ge sana gasa me wae. Be zo zorage awinoya. Be awa kei awai amire nikare Mama isare yerere meni bowi wamu sero dirumu emirata Yerusalem nate ena oko wamunowa. ");
INSERT INTO sue_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ninekare awa kaka giro baitamu inoise yere isare towewa. Nanekare awa giro baititinoise yere isare towenakare. Nera kota, korawai ewanana wai awa Yudara nana ena gita kei awaise sai itia. ");
INSERT INTO sue_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Be zo mamunoya be amire Anutura ema dubu me meni nu bowi wamu sero ititire tani mere meni wamunora. Mama nu ema ago ine ami nu bowi warise yaba inowia. ");
INSERT INTO sue_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anutu nu tama aiso kota, nu ititi. Are nikare nu bowi wamu sero tama meni kota, ititire tani mere meni nu bowi inoise noiwo.” ");
INSERT INTO sue_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ago senu bama meni ina ego senua awa, “Na gosinona. Mesia zazo nuso zo Kristo ami mamunoya. Nu muro nena dapikarago poti damu namunoya.” ");
INSERT INTO sue_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ago senu Yesu meni ego senua awa, “Ge tosa awa zo tepo, ata na ewa nimore dai ge tona. Ge awa nama awa.” ");
INSERT INTO sue_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ge ago toinu bua mai nuso kei awewa. Kei awero bamere dai ge toiwato awa giro di tainiwa awa. Ota nena ne emo bamere ge toi, o nogoro toi, ago sero atata waira awa giwa te kaka wamu wenu giro dowa awa. ");
INSERT INTO sue_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ago wewa bama nu kopi ou dumai nuso doro sumuro bamu nate niro emare senua awa, ");
INSERT INTO sue_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nikare muu. Baro ema zo gawe. Nune nuai nasora susu dapikarago namore kerenia. Nu Kristo, tanita?” ");
INSERT INTO sue_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ago senu ema dago Yesu gamu bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nukare Yesura nana susauwa bua mai nuso meni Yesure ego sewa awa, “Gipai ema, ni nena ni.” ");
INSERT INTO sue_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ago sewa ina ego senua awa, “Ma naso itia. Awa nikare oko gosinowa.” ");
INSERT INTO sue_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ago senu bua mai nuso meni nutopekare ina-sa wero sewa awa, “Ai meni ma puro mi?” ");
INSERT INTO sue_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ago sewa giro nu ego senua awa, “Nu na potinu muna amira ge dimuro bua nuso wero susauma pesunamunona ami ma naso inoya awa. ");
INSERT INTO sue_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nikare nitopekare ego towewa awa, ‘Inua zoeto-zoeto ago tepo wai amire ma me wamunoya.’ Are nane sana niniu. Nikare irina-arina wero bua giu. Ma pumaira be* kei awero itia. ");
INSERT INTO sue_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ema zo nu ma puro poti dara nai bua inoya ami zuma pupinoya. Nu ma nuai me ewananara gegenai awa pumu sora nitinoya. Are ema ma urai ema ata ema ma pumai ema nuto ami eroma yawa sara wamunorato. ");
INSERT INTO sue_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Are ge ego towenakai ami ena me inoya, ‘Zo meni urai bua inowia, ota zo meni pumai bua inowia.’ ");
INSERT INTO sue_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ma nikare kaka uramu wisewa amira me awa pumu sora nawise sesena bayamunowa. Bua awa eni meni wisera amira me ninekare pumamunowa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Are Samaria ema bama dainiro meni bamera ge niniro Yesu tuma diwa awa. Ago wewa, nera kota, bama meni nuai nusora susu awa dapikarago Yesu meni kereninu giro ema bama susure senu niniwa. ");
INSERT INTO sue_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Are nukare Yesura nana muro Yesu numorekare dai nuaise uzumuro puro bamu nate namu sewa giro Yesu meni numorekare dai waiko be eto ago noinua awa. ");
INSERT INTO sue_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ago noise ge toise noinu ema dainiro meni ge nuso niniro nu tuma diwa. ");
INSERT INTO sue_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ago wero bamere ego sewa awa, “Gita nakare uge niso niniro nu tuma dienakare. Ota zeme ei awa nakare be so nusora ena ge niniro ego tonakare: Nu zebu serora ema bama amira Korawai Ema me.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu nu Samaria emare dai be eto itimite nukare doro Galilaya zebura bamunua awa. ");
INSERT INTO sue_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu nu ge gita ego senua awa, “Porofete nukare nata nusokarera kei awero ema zazore oko inowera.” ");
INSERT INTO sue_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Are Yesu meni Galilaya zebura baro kei awenu Galilaya ema nu giro areniro yawa sara wewa. Awa nera kota, be zore nukare bamu Yerusalem niro Yuda emara pura amira ana bua Yesu meni wenua awa giwa. ");
INSERT INTO sue_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu meni Galilaya zebura kei awero Kena nate bamunua. Nata amira ana nu gita ge senu ou meni wain wenua. Ago bamunu Kapaneam nate dia ema bamu zo noisonua amira mai yaya mou-mau puro itinua. ");
INSERT INTO sue_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Are “Yesu nu Yudaya zebu doro ewesemuro mu Galilaya zebura niro noya,” ago sewa giro dia ema ami bamu Kena nate niro Yesura nana bamunua awa. Baro mai nuso betamu sero inoinu giro Yesu uzumuro puro sora baro mai nuso kora waise senua. ");
INSERT INTO sue_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ago senu Yesu meni numore ego senua awa, “Nikare tani putoure eni ata bua bamu eni awa kaka gamu wamunowa, awa nikare na oko tuma diamunowa.” ");
INSERT INTO sue_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ago senu dia ema meni ego senua awa, “O Tua, mai naso betai azu, eya bayasise tona.” ");
INSERT INTO sue_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ago senu Yesu meni numore ego senua awa, “Ni tepo bamu. Mai niso ewanana wetia awa.” Ago senu dia ema nu Yesura ge nininu me wenu giro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ewesemuro susaunu soumai nuso eni meni oziga puro muro nu tamuro ego sewa awa, “Mai niso ewanana wero noya.” ");
INSERT INTO sue_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ago sewa giro mai ewanana wenua amira waiko be awa gamu sero atata wenu sewa awa, “Awenakai amire waiko soe dopero iti amire tama mena-mana nuso tepo wataya.” ");
INSERT INTO sue_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ago sewa dia ema meni susu ego ginua awa: “Be amire Yesu meni na ewesemanise sero ego sasaya, ‘Mai niso ewanana wetia.’” Are dia ema meni susu awa giro nu arere awisore Yesu tuma diwa awa. ");
INSERT INTO sue_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu Yudaya zebura ena ewesemuro Galilaya zebura kei awero tani awa wenua, awa tani putoure namba tu Galilaya zebura ena wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yuda emara pura zo amira be munu giro Yesu witiro bamu Yerusalem ninua awa. ");
INSERT INTO sue_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Goma zo nata Yerusalem zimai amira toyai be zo zazo nuso Lama Toyai Be. Toyai be amira ou butu zo itisonua zazo nuso Yuda gera Betesida. Ou amira bera bisi paira so wana da ago itisowa. ");
INSERT INTO sue_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","So amira ema yayare witai ami duro itisowa. Ema eni giti guma wai, o eni zabura wai, o eni orara touwai dainiro meni ago itisowa. Nukare ou pasi wai gamu dia itisowa. ");
INSERT INTO sue_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ago itasara be enire Tuara angelo zo meni osero ou butu dasai pasi wasai yaya emara nana zo meni gita gita wero ose oura niro dagimasai yaya nuso eya tepo wasai ewanana inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Are ema zo nu zabura wero noe donu zepa 38 wenua ami ago itinua. ");
INSERT INTO sue_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu meni ema awa giro yaya nuso borere-barere itisonua awa giro numore ego senua awa, “Ni ewanana wamu kotupitinosita?” ");
INSERT INTO sue_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ago senu ema zebura wai ami ina ego senua awa, “O ema, ou pasi wai amire ai meni na wana ziro pumai osero ou awa dagimuro ewanana wamunoni? Eni meni na dainiro ose oura nawera giro na itewena.” ");
INSERT INTO sue_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ago senu Yesu meni ina numore ego senua awa, “Ni eriro sawa niso puro aita we.” ");
INSERT INTO sue_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ago senu ema zebura waira tama kokopai wenu nu eriro sawa nuso pumuro aita wenua awa. Waiko be awa Yuda emara Sabat pura itiwa awa. ");
INSERT INTO sue_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Are Yuda ema meni ema ewanana wenua amire ego sewa awa, “Pura be emira sai zewai wai ge nasokai itia awa ni dainitinoise sawa masi niso puro nosa, atonua.” ");
INSERT INTO sue_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ago sewa nu ina ego senua awa, “Na kora wetia ami ego sesia awa, ‘Sawa niso puro aita we.’” ");
INSERT INTO sue_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ago senu sewa awa, “Sawa niso puro aita we, ago ema zazo ai meni sesi?” ");
INSERT INTO sue_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ago sewa ema senu kokopai wenua ami Yesura zazo kau wenua. Nera kota, Yesu nu ema dubu dopero itiwa amira nana soe ena saitiro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ama Yesu meni ema awa Anutura ibu bamura ena tamuro ego senua awa, “Ni tama niso ewanana watasa, ata mou-mau zo niso nana kei awai azu, pasina doro noiyo.” ");
INSERT INTO sue_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ago senu nu Yesu giro baitiro bamuro Yuda emare ego senua awa, “Ema na kora wetia awa zazo nuso Yesu.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesu nu Sabat pura amire bua ago ine wenua, are Yuda ema meni giro nu iwo wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ago wewa Yesu meni ego senua awa, “Mama naso nu bua wai gege inoise nowia, are na da ago ine bua inona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu nu Sabat pura sisenua, ota Anutu nu Mama nuka nuso asinoise nu Anutu ine awa senua, awa Yuda ema meni giwa waya wenu giro nukare Yesu damu sero ebata tamamu wewa. ");
INSERT INTO sue_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ago sewa Yesu meni ina ego senua awa, “Na me memeka sana niniu. Na Mai meni duba nasora bua oko inowena. Mama meni wawi giro inowena. Mama meni wawi giro na Mai meni da ago inowena. ");
INSERT INTO sue_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mama nu Mai nuso giro yaba dasiga inowia, are bua inowia awa te gipinowia. Ota bua ei awa gege kota, bua witai eni itera awa dai Maire gipai giro nikare titibi awero di tainamunowa awa. ");
INSERT INTO sue_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mama nu betai ema awa-uzawi seka inowera, da ago ine na Mai meni ara tamai nasora zota zo awa-uzana seka wamunora awa. ");
INSERT INTO sue_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mama nu emara zas oko inowia. Bua awa dapikarago Maira nana wanera potinua awa. ");
INSERT INTO sue_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Are ema nukare Mama bowi inowera, da ago ine Mai bowi warise. Zo nu Mai bowi kaka wamu wamunoya ami Mama na iyetinua awa dai bowi kaka wamu ago ine inoya. ");
INSERT INTO sue_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Na me memeka sana niniu. Zo meni ge naso ninitinoise Mama naso na iyetinua amira ge gi me inoya ami nuai me ewanana zeme emire puro noya. Nu kotora ena oko duwamunoya. Nu zewai wero betai doro nuaira kei awero nowia. ");
INSERT INTO sue_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na me memeka sana niniu. Ema bama nowera ami bebetenai ine. Be zo mamunoya — ota kei awero itia — be amire nukare Anutura Mai amira ge awi ninamunora. Eni meni ge niniro baitiro seka wero nuamunora awa. ");
INSERT INTO sue_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mama nu nuaira Mama, are nu Mai nusore da ago nuai dirieninu na nuaira Mama wero nowena. ");
INSERT INTO sue_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na Mai, na Emara Mai. Are Mama naso meni emara koto amira zas bua awa na Mamera bera wanise sero putou namore potinua. ");
INSERT INTO sue_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nikare ge awa niniro oko di tainawe. Nera kota, be zo potai itia awa mai amire bi ditira awinowera ami zawa naso ninamunora. ");
INSERT INTO sue_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ago niniro ewanana noisowa ami eriro nuai me ewanana tamamunora. Ota waya wero noisowa ami meni awa eriro koto wero kotora ena duwamunora awa. ");
INSERT INTO sue_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Na duba nasora bua zo wai ine oko itia. Na ge Mama nasora bera ena ninitinowena da awa inoise kotora zas inowena awa. Ago inoise kotora zas bua wana te wamunoya. Nera kota, na ara tamai nasora kota, nu senu osena amira ara tamaira wamu inowena awa. ");
INSERT INTO sue_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Na natope susu naso sana te oko wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Susu naso awa zo meni kerenitinowia. Nu susu naso kerenitinoise ge me toya awa gosinona. ");
INSERT INTO sue_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nikare sesewa bua mai nisokare meni Yohanera nana baro atata wetera nu ge me kereniro sisia awa. ");
INSERT INTO sue_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ema zo meni susu naso kerenaise awa oko yaba inona. Nikare susu naso ninawa Anutu meni nikare soero pumaise sero nimorekare sesena awa. ");
INSERT INTO sue_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane nu zasimai bamubake ine wero noise nikare zasimunua. Zasimai nuso giro yawa sara apunu-kaka gege inoise noisewa awa. ");
INSERT INTO sue_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ata susu naso kerenitinowia ami nu Yohane ine oko aewa. Nu witai. Na bua Mama meni wanise senua awa inowena. Bua ami susu naso ego ine kerenitinowia: Mama meni senu osena awa. ");
INSERT INTO sue_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Are Mama na senu osena ami susu naso kerenitinowia. Nikare be nusora ge kaka ninamu inowewa. Nikare giti moka nuso kaka gamu inowewa. ");
INSERT INTO sue_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ge nuso duba nisokarera oko itia. Nera kota, nikare Mama na senu osena amira ge ninawewa me kaka wamu inowia. ");
INSERT INTO sue_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nikare ego towewa awa, ‘Anutura ge gayai ami nuai me ewanana namorekai tamamunoya.’ Ago toise nuai me ewanana tamamu sero ge gayai azipitinowewa. Ge gayai ami susu naso kerenitinowia, ");
INSERT INTO sue_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ata nikare na nuai me ewanana nimorekare potanise sero namore dai dara tayai azu towewa. ");
INSERT INTO sue_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ema meni na bowi warise oko towena. ");
INSERT INTO sue_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Na susu nisokare gosinowena. Duba nisokare meni awa Anutu Mama nasora nana oko itewia. ");
INSERT INTO sue_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na Mama nasora ge dimuro nisokare nana osena awa, ata nikare ge naso doro na oko otao inowewa. Noma ema zo kotumai nusora kei nisokare nana nai amire numore dai otao wamunowa. ");
INSERT INTO sue_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nikare nitopekare bowi ina-wa inoise nowewa. Ota Anutu imata nikare bowi waise ago kaka samu inowewa ami nogo wero na tuma diamunowi? ");
INSERT INTO sue_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nikare namore ego oko sawe, ‘Nune nakai gera potai ge bua wamunonakai.’ Namore ago oko sawe. Nikare Mose tuma diro nowewa, are Mose meni nikare gera potamunoya. ");
INSERT INTO sue_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mose meni ge gaenua, awa namore gaenua awa. Nikare ge nuso ninawa me wamia, awa nikare ge naso dai ninawa me wamia. ");
INSERT INTO sue_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ota nikare Mosera ge gayai awa niniwa me kaka wamu wenu giro dowa, are nogo nogo wero ge naso ninawa me wamunoi?” Yesu meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesu meni ge awa senu tepo wenu Galilaya ou ubu semuro bamu enibara ninua awa. Ou ubu amira zazo zo Taibirias asinowera. ");
INSERT INTO sue_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Semuro bamunu nu ema bama yayare kora wasai ewanana inoisowa awa eni meni gosinoisowa, are ema diti bamu meni nu ama ganewa awa. ");
INSERT INTO sue_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ago wewa Yesu meni bua mai nuso pumuro witi dirumura niro arumuro itiwa awa. ");
INSERT INTO sue_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Be amira ana Yuda emara pura zo zazo nuso Betai Daininua amira be zora awenua awa. ");
INSERT INTO sue_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Are Yesu meni ema dubu bamu nuso nana tupiwa giro Filip atata wero ego senua awa, “Ma nana ena puro ema dubu bamu amire potanakai nara te wamunoi?” ");
INSERT INTO sue_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu nu bua zo wamu kotupitinoinua, ata nu Filip gaero gamu atata wero senua awa. ");
INSERT INTO sue_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ago senu Filip meni ego senua awa, “500 kina meni ma pumuro potanakai nara te kaka wamu wamunoi, tanita.” ");
INSERT INTO sue_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ago senu bua mai nusora nana zo Anderea, nu Simon Petorora nami, ami ego senua awa, ");
INSERT INTO sue_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mai zo meni ma wana dare ou wo etore puro noya. Ata ema dubu bamu, are te oko wamunoi, tanita.” ");
INSERT INTO sue_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ago senu Yesu meni ego senua awa, “Nikare seu ema poti dara niro arumare.” Zebu amira zewaka itisonua, are patiro arumuwa. Namba nusokare 5,000 ago ine ami arumuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ago wewa Yesu meni ma puro Anuture kokopai asero ema arumuro itiwa amire kanowenua. Ou wo da ago ine wenu te wenua. ");
INSERT INTO sue_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Niwa te wenu itata da ago dowa giro Yesu meni bua mai nusore ego senua awa, “Nena itata itima waya wamera, sianiu.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Are ma wana da niwa amira itata awa sianiwa kana 12 ago be muwa. ");
INSERT INTO sue_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ema meni tani putoure awa giro Yesu bowi inoise ego sewa awa, “Porofete bamubake zo zebura kei awaise sai awa ewa.” ");
INSERT INTO sue_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ago sero Yesu puro ema tua nusokare potara nuaise toiwa giro nu ema dubu awa doro imata witiro bamu dirumura ninua awa. ");
INSERT INTO sue_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tua zinu bua mai nuso meni ou ubura osero ");
INSERT INTO sue_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kapaneam nate ewesemuro bayamu sero wara witiro bamuwa awa. Ago susauwa pi zinu Yesu meni nusokare nana kaka kei awamu wenu ");
INSERT INTO sue_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","bisi zewai-zawai munu kakawa bamubake inoinu ");
INSERT INTO sue_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","nukare dawero bamu soe niro 5 kilomita ago awa inoiwa Yesu meni ou tame aita wero baro wa nusokare nana zorage kei awinoinu giro azu wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Azu wewa giro Yesu meni ego senua awa, “Azu oko wawe. Nane tupena awa.” ");
INSERT INTO sue_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ago senu giro nukare yawa sara inoise ziwa wara witinu wa meni nata bayamu sero inoiwa amira eya kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pina atinu ema ou ubu enibara awinoiwa ami ego sewa awa, “Pire wa daimata gege iti bua mai nuso meni Yesu doro nukare imata wara witiro bamitara awa.” ");
INSERT INTO sue_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ago sewa, ata wa eni Taibirias nate ena muro kakamo Tua meni ma gawa wenu niwa amira muwa awa. ");
INSERT INTO sue_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Are ema bama meni Yesu bua mai nusore awa kau inomite nukare tamamu sero wa muro itiwa amira witiro bamu Kapaneam nate niwa awa. ");
INSERT INTO sue_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bamu ou enibara niro Yesu kau inomite tamuro ego sewa awa, “Gipai ema, ni nazi mesi?” ");
INSERT INTO sue_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ago atata wewa Yesu meni ego senua awa, “Na me memeka sana niniu. Tani putoure wawena gosinowewa amira kota, ma potena nitawa amira gege na kau inowa. ");
INSERT INTO sue_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nikare ma sisai amira kota, nuai me ewananara ma amira bua wewo. Na Emara Mai awa Anutu Mama meni putou namore potinu pumuna. Are nuai me ewananara ma awa nane nimorekare potamunona.” ");
INSERT INTO sue_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ago senu nukare ge ina ego sewa awa, “Nakare nogo nogo wero Anutura bua wamunonikare?” ");
INSERT INTO sue_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ago sewa nu ego senua awa, “Anutura bua ego ewa. Na Anutu meni senu osena, nama awa tuma diwo.” ");
INSERT INTO sue_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ago senu nukare ge ina ego sewa awa, “Ni tani putoure ne wasa ganakare ge niso me wamunoi? ");
INSERT INTO sue_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ewowo-kawowo nasokare ware noise ma zazo mana awa ninoise noisowa. Amira ge gayai ego itia ewa, ‘Utura ma potasai ninoisowa.’” ");
INSERT INTO sue_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ago sewa Yesu meni numorekare ego senua awa, “Na me memeka sana niniu. Mose meni utura ma nimorekare oko potinua. Mama naso meni utura ma me nimorekare potitinowia awa. ");
INSERT INTO sue_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ma Anutu meni potitinowia ami utura ena osero zebura ema nimorekare nuai tapinowia.” ");
INSERT INTO sue_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ago senu ina ego sewa awa, “O Tua, ni ma tosa awa be giti namorekare potitinoiyo.” ");
INSERT INTO sue_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ago sewa ina ego senua awa, “Nuai potaira ma na ewa. Zo nu namore dara tairo nuamunoya ami meri oko wamunoya. Ota zo nu na tuma diamunoya ami ou uza oko wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na sesena gewa. Nikare na gosinowewa, ata nikare na kaka tuma diamu inowewa. ");
INSERT INTO sue_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ema Mama meni namore potitinowia ami dapikarago naso nana kei awamunora. Are zo nu naso nana mai na nu oko esenamunona. ");
INSERT INTO sue_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Utura ena osena awa kotumai nasora kota, Mamera bera bua nuso wamu sero osena awa. ");
INSERT INTO sue_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nu senu osena amira ara tamai ego ewa. Ema dubu namore potinua nukare ami sisero waya wai azu, na be bamura ena awa-uzana dapikarago erarise. ");
INSERT INTO sue_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mama nasora ara tamai awa ego ine itia awa. Nukare na Mai giro baitiro tuma diamunora ami nuai me ewanana pumamunora. Ago wara nane be bamura ena nukare awa-uzana eramunora. Mama nasora ara tamai ago itia awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesu meni, “Ma utura ena osenua na awa,” ago senua, are Yuda ema giwa waya wenu giro ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Ema awa nu Yesu. Nu Yosefera mai awa. Nakai mia mama nuso gosinowenakai. Are nogoro nu utura ena osenu sia toi?” ");
INSERT INTO sue_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ago sewa Yesu meni ego senua awa, “Nikare gung-ga oko sawe. ");
INSERT INTO sue_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Zo nu kotumai nusora naso nana mai ine oko itia. Mama na senu osena ami nu zumamunoya, awa nu naso nana mamunoya. Ago wai nane be bamura ena awa-uzana seka wero eramunoya. ");
INSERT INTO sue_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Porofete meni ge zo ego gaewa itewia ewa, ‘Anutu nu nutope ema dapikarago ge nuso tugata wamunoya.’ Are zo nu Mama meni ge gipai niniro kotumai tamamunoya ami naso nana mamunoya. ");
INSERT INTO sue_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ema agai meni Mama ginu? Tepo awa. Anutura nana ena osena na daimata ami Mama gina awa. ");
INSERT INTO sue_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Na me memeka sana niniu. Zo nu na tuma didinoise nowia ami nuai me ewanana awa puro nowia awa. ");
INSERT INTO sue_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nuaira ma na ewa. ");
INSERT INTO sue_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ewowo-kawowo nisokare ware noise ma zazo mana ninoise bebeteniwa. ");
INSERT INTO sue_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ota utura ma niro kaka betamu nuai gege nuai awa na ewa. ");
INSERT INTO sue_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nuaira ma utura ena osena na ewa. Are zo nu ma awa namunoya ami nuai gege nuamunoya. Pisi naso meni ma inoya awa. Are erama meni nuai tamarise potamunona.” ");
INSERT INTO sue_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ago senu Yuda ema nutopekare ina-sa wero ego sewa awa, “Nu nogo wero pisi nuso potai nanisekai toi?” ");
INSERT INTO sue_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ago sewa Yesu meni ego senua awa, “Na me tona. Nikare Mamera Mai amira pisire orarare kaka namu wamunowa, awa nuai me duba nisokarera oko itamunoya. ");
INSERT INTO sue_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Zo nu pisi nasore orara nasore namunoya ami nuai me ewanana tamamunoya. Ago wai nane be bamura ena nu awa-uzamunona awa. ");
INSERT INTO sue_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pisi naso meni ma me. Orara naso meni ou nai me. ");
INSERT INTO sue_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Pisi nasore orara nasore namunoya ami namore dai nuamunoya. Ago wai na da ago numore dai nuamunona. ");
INSERT INTO sue_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mama nu nuaira Mama ami na senu osena, are nuai na Mamera nana zewai-zawai itawi nowena. Are zo nu na namunoya awa da ago ine nuai nuso naso nana itai nuamunoya. ");
INSERT INTO sue_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Utura ma amira susu ago itia awa. Awa ewowo-kawowo nisokare meni niwa, ago ine oko aewa. Nukare ma awa ninoise bebeteniwa. Ota zo meni ma ei awa namunoya ami nuai gege nuamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu nu Kapaneam nate ena yere ibura ena ge awa emare tugata wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dubu nusora nana eni meni ge awa niniro ego sewa awa, “Ge awa ninenakai te kaka wamu inoya. Ge awa agai meni ninai te wamunoi?” ");
INSERT INTO sue_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ago toise duba tu meni gung-ga sewa giro Yesu meni enia wero giro ego senua awa, “Ge awa ninewa waya inoita? ");
INSERT INTO sue_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Are Mamera Mai meni noko ewesemuro utura witana gawa nogo wamunoi? ");
INSERT INTO sue_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ozana meni nuai emare potitinowia. Tamara pisi meni oko sorepitinowia. Na ge towena awa Ozanare ata nuaire awa. ");
INSERT INTO sue_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ata nikare eni meni niniro na tuma kaka diamu inowewa.” Yesu meni ago senua. Nera kota, nu nukare eni meni ge nuso niniro nu tuma kaka diamu wamunora amira benau nusokare gita ona ginu tepo wenua awa. Ota ema nu kerenamu inoinua amira benau dai ginu tepo wenua. Are ge awa senua awa. ");
INSERT INTO sue_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Are nu ge zo susumuro ego senua awa, “Na ami emo ego tona awa. Zo nu Mama meni kaka ninamu wai nu naso nana mai ine oko itia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Are be amira ana dubu nuso eni meni numore dai nuai awa biawa wenu giro nu doro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ago wewa Yesu meni bua mai nuso 12 atata wero ego senua awa, “Nikare da ago ine na duamu towita?” ");
INSERT INTO sue_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ago senu Simon Petoro meni ina ego senua awa, “Tua, ni doro zo ara nana bayamunonikare? Nuai me ewanana amira ge niso nana itewia. ");
INSERT INTO sue_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Are nakare ni tuma didinoise ego genakare me wetia awa: Ni Anutura Mai saramai.” ");
INSERT INTO sue_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ago senu Yesu meni ina ego senua awa, “Na nikare mai 12 sianiro pumuna. Ata nisokare nana zo meni nogoro Satan ine inoi?” ");
INSERT INTO sue_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ago senua, awa nu Simon Iskeriot amira mai zazo Yudas amire senua. Nu Yesura bua mai 12 amira otao zo ami ama Yesu kereniro iwora wanera potinua. ");
INSERT INTO sue_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yesu meni ago senu giro Yuda ema eni meni Yesu damu sero ge diwa dagimunu Yesu meni ge awa niniro giro Yudaya zebu doro Galilaya zebura baro noisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ago noinu Yuda emara pura zo zazo Komboara Pura* amira be zora awenua awa. ");
INSERT INTO sue_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ago wenu namisini nuso meni numore ego sewa awa, “Ni zebu ei awa doro Yudaya zebura baro bua inowesa awa ona wasa bua mai niso ago nowera ami gare. ");
INSERT INTO sue_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ema zo bua inowia ami ema bama garise sero oko bezinowia. Ni bua inowesa, are ni bamuro ema dapikarago amira nana giti mokara kei awero bua awa we gare.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Namisini nuso meni ge ago sewa, nera kota, nukare nu tuma kaka diamu noisowa. ");
INSERT INTO sue_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ago sewa Yesu meni numorekare ego senua awa, “Nikare be tepo amira ana bua zo wawewa te inowia. Ata be naso kaka mamu. ");
INSERT INTO sue_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ema bama meni nikare iwo wai ine tepo. Ata nane meni awa nuai nusokare waya awa kerenawena giro na iwo inowera. ");
INSERT INTO sue_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Are nikare aunaira bamuu. Nane aunai amira oko mamunona. Nera kota, be naso kaka kei awamu.” ");
INSERT INTO sue_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ago sero nu Galilaya zebura dago itinua awa. ");
INSERT INTO sue_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ago noinu nukare gita bamuwa amire nu ama imata upene bamunua awa. ");
INSERT INTO sue_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ago wenu pura zora awenu Yuda ema babezinoma meni nu kau inoise ego sewa awa, “Nu nago iti?” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ota ema dubu bamu ge dainiro sewa. Ago toiwa eni meni ego sewa awa, “Nu ema kokopai.” Ota eni meni ego sewa awa, “Tepowa. Nu opi toise ema bama etete nitinowia.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ata dubu bamu meni Yuda ema babezinoma awa azu inoise ge tura bezero sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pura soe sieninu Yesu meni Anutura ibu bamu amira mokara toiro ema bama ge tugata wenua. ");
INSERT INTO sue_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ge tugata inoinu Yuda ema gita wai meni giro di taniro ego sewa awa, “Nu ninai ibu nasokaira kaka toyamu ami nogo wero ge susure ninitinowi?” ");
INSERT INTO sue_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ago sewa Yesu meni ego senua awa, “Na gera susu nimorekare tugata inowena, awa naso kota, na senu osena amira awa. ");
INSERT INTO sue_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nikare na kotumai nasora gege towenita Anutura bera ge tugata inoweni, ago towewa. Ata ema zo meni Anutura ge dipinoise nuamunoya ami na ge towena amira susu gamunoya. ");
INSERT INTO sue_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Zo nu kotumai nusora towia ami tama nuso puro witamu towia. Ata zo nu buara mama amira bowi kei awaise towia ami opi tepo ge me gege towia. ");
INSERT INTO sue_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mose meni lo ge nimorekare potinua, ata nisokare nana zo meni oko dipinowia. Nikare nogoro na damu towi?” ");
INSERT INTO sue_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ago senu ema bama bamu ami girara asero ego sewa awa, “Ni bi meni duba nisora iti dau wero tosa. Ai meni ni damu toi?” ");
INSERT INTO sue_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ago sewa Yesu meni ina ego senua awa, “Na tani putoure daimata wetena nikare di tainiro itewa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sana niniu. Mose meni mai mamatana nisokarera tama aiso agewa kapawise senua. Ota Mose meni kota, ewowo meni zaawewa. Are bua awa waira be mawi pura bera ena inowewa. ");
INSERT INTO sue_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Awa Mosera sai zewai wai ge dainai azu, nikare pura bera ena mai mamatana nisokarera tama aiso kapinowewa awa. Ota nane meni awa ema zo me zere dago pura be nisokarera ena kora wisena. Amira nikare nogoro namore tini kapai pupinowi? ");
INSERT INTO sue_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Na pasina wago wisena asero bua naso waya oko sawe. Bua nasora susu giro baitiro amire bua kokota waya ni, awa seu.” ");
INSERT INTO sue_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ge ago senu Yerusalem ema eni meni ego sewa awa, “Ema damu towera awa ewa. ");
INSERT INTO sue_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Giu. Nu ge damu ena toya, ata nukare numore ge zo kaka samu inora. Pris nukare nu gawera Kristo inowita? Tepo tanita. ");
INSERT INTO sue_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nakai kei awai nuso gosinonakai. Ata Kristo mamunoya amira kei awai awa zo meni oko gamunoya.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu nu Anutura ibu bamura ena dopero ge tugata inoinu ge awa sewa niniro ina ego senua awa, “Nikare na gosinowewa, ota kei awai nasora susu gosinowewa. Ata na kotumai nasora oko osena. Nu senu osena nu awa me awa. Nikare nu oko gosinowewa. ");
INSERT INTO sue_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na nuso nana ena osena, noko nune senu osena, are na nu giro baititinowena.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ago senu nukare nu benamu sewa, ata be nuso kaka mamu, are wana nuso nana tame potai awa mou wero dowa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ago wewa ema bama dainiro meni Yesu tuma diro ego sewa awa, “Kristo mamunoya awa ema emi tani putoure inowia awa dainiro wamunoita? Tepo, tanita.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ema nukare ge ago ine awa upene toiwa Farisayo meni niniro pris babezinoma enire dai auniro ge sero Yesu benamu ge sero soldia iyetiwa Yesu pamu sero bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu meni ego senua awa, “Na be apunu nimorekare noma nu senu osena amira nana ewesemamunona awa. ");
INSERT INTO sue_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ago wana nikare na kau bamubake wero oko tamamunowa. Baro nuamunona amira nikare bayai ine tepo.” ");
INSERT INTO sue_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ge ago senu Yuda ema nutopekare ge ina-sa wero ego sewa awa, “Nu nago bayai kau wamunonakai asinoi? Yuda ema otao mamai nasokai Grik zebura nowera amira nana baro Grik ema ge tugata wamu toita? ");
INSERT INTO sue_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nu ego sesia, ‘Na kau wero oko tamamunowa. Ota bayamunona amira nikare bayai ine tepo.’ Ge ago ine awa nogo toi?” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pura be pesunitinoinu Yuda ema meni aunai bamu inoise itiwa amire Yesu meni eriro dopero zawa sero ego senua awa, “Zo nu ou uza wai giro naso nana muro ou naise. ");
INSERT INTO sue_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Zo nu na tuma diamunoya amira dubara ena nuai me ewanana amira ou sasa ine mai gege tupise itamunoya. Amira ge gayai zo itia awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Awa ema nu tuma didinora ami Ozana pamunora ago senua. Yesu meni Ozanara ge awa oura potiro ge awa senua. Be amira ana nu utura zasimaira kaka kapeteniro witamu wenua, are Ozana meni kaka osamu wenua. ");
INSERT INTO sue_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ema nukare ge awa niniro ego sewa awa, “Porofete dia inowenakai numa awa.” ");
INSERT INTO sue_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ota eni meni ego sewa awa, “Nu Kristo me.” Ago sewa eni meni enira ge dero ego sewa awa, “Kristo meni Galilaya ena nogoro kei awamunoi? Tepo tanita. ");
INSERT INTO sue_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Anutura ge gayai zo ego ine itia ewa, ‘Kristo nu Dawidira nata susu Betelehem ena saisibuna nusora nana soe ena kei awaise sai.’ Ge gayai ago ine itia.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ema nukare Yesure ge ago toise zazaumuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ago toise eni meni Yesu benamu ge sewa, ata zo da nu oko zinua. ");
INSERT INTO sue_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Soldia nukare pris babezinomare Farisayo nana ewesemuro bamuwa atata wero ego sewa awa, “Nikare nogoro nu kaka puro mamu wetewi?” ");
INSERT INTO sue_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ago atata wewa soldia meni ego sewa awa, “Nu ge towia ago ine ema zo meni sai ine oko itia.” ");
INSERT INTO sue_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ago sewa Farisayo ema meni ina ego sewa awa, “Nu nukare dai eteteni gewa me wetiwa. ");
INSERT INTO sue_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Simaire Farisayore nasokare nana zo ai meni nu tuma didinoi? ");
INSERT INTO sue_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Awa tepo awa. Ata ema dubu bamu nu ama ganinora ami Mosera lo ge kaka gamu inoise nowera, are waru nusokare nana itewia.” ");
INSERT INTO sue_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ago sewa otao nusokare zo zazo nuso Nikodemo nu gita be zore Yesura nana bamunua ami ego senua awa, ");
INSERT INTO sue_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nikare seu. Ema zo nakai susu nuso kaka gamu, ota pasina nuso kaka tamamu inoise nu tepo gera potanisekai sai itita? Lo ge nasokai meni go wanisekai toita?” ");
INSERT INTO sue_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ago senu otao mamai nuso meni ina ego sewa awa, “Ni da ago Galilaya ema ni? Ni lo ge nasokai azimai bua i-susauma ego gamunosa: Galilaya zebura ena porofete zo kei awaise sai oko itia.” ");
INSERT INTO sue_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ge ago tomite doro so sero bozero bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu nu Oliwa dirumura witinua. ");
INSERT INTO sue_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pina atinu ana ewesemuro bamuro Anutura ibu bamura toinu ema dainiro meni nuso nana auniwa giro arumuro ge tugata wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ago inoinu lo ge gipai emare Farisayore meni bama zo kuma inoinu tamuwa awa puro poti soe niro Yesure ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Gipai ema, bama ami bewana inoi tamera. ");
INSERT INTO sue_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mose meni lo ge nasokai gainoise bama ego ine awa omata meni danakai betarise senua. Ota ni nitope nogo wanisekare tosi?” ");
INSERT INTO sue_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ago sewa, awa ego emira: Nukare nu atata wara ina ge zo sai giro nu puro gera potamu sewa. Ago sewa Yesu nu numorekare ge ina kaka samu. Nu dupuniro zebu owe inoise itinua. ");
INSERT INTO sue_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ago wenu nukare nu atata werota wero awewa giro eriro ego senua awa, “Nisokare nana zo meni pasina amu nowia ami omata puro zaawero daise amire dawe.” ");
INSERT INTO sue_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ago sero noko dupuniro zebura owe wenua. ");
INSERT INTO sue_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ago wenu nukare ge nuso niniro bama awa doro zezewenai meni gita wewa tiri-tara awero baro tepo wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ago wewa bama imata itinu Yesu iri niro giro numore ego senua awa, “Nukare nani? Zo meni ni gera potita?” ");
INSERT INTO sue_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ago senu bama meni ina ego senua awa, “O Tua, tepo awa.” Ago senu Yesu meni ego senua awa, “Na da ago ni gera oko potamunona. Ni baro noise pasina noko oko wase.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu meni ema bamere ge zo ego senua awa, “Na zebu serora ema amira zasimai. Are zo nu na ama ganamunoya ami mumera oko susawiamunoya. Nu nuaira zasimai nuso nana itai nuamunoya awa.” ");
INSERT INTO sue_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ago senu Farisayo ema meni ego sewa awa, “Ni nitope susu niso kerenitinosa, awa genakare me oko inoya.” ");
INSERT INTO sue_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ago sewa giro Yesu meni ina ego senua awa, “Na natope susu naso kerenitinona ami me amu oko inoya. Na nana muni, ota nago susaweni, amira susu gosinoise ge towena. Ata ninekare meni awa na nana muni, ota na nago susaweni, amira susu kau inowewa awa. ");
INSERT INTO sue_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nikare tama naso gege giro na waya asinowa. Ata nane meni awa erama awina-dawina waira bua oko inona. ");
INSERT INTO sue_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ata na awina-dawina waira bua wamena, awa bua me wamia. Nera kota, na imata oko itena. Nu na senu osena ami namore dai nowia awa. ");
INSERT INTO sue_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lo ge gayai nisokare amira ego gayai itia awa, ‘Ema eto meni nena zora susu sarato te wamunoya. Ago wai me asamunora.’ ");
INSERT INTO sue_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Are susu naso awa na natope kerenawena Mama na senu osena ami dai kerenitinowia.” ");
INSERT INTO sue_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ago senu nukare nu atata wero ego sewa awa, “Mama niso nani?” Ago sewa nu ina ego senua awa, “Nikare na kaka giro baitamu inowewa. Are nikare Mama naso da ago kaka giro baitamu inowewa. Nikare na giro baitamewa, awa Mama naso dai giro baitamewa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu nu ibu bamura itise akou wau moni potitinoisowa amira zorage dopero ge tugata inoise amire ge awa senua. Ota betaira be nuso kaka mamu, are nukare nu kaka ziamu wewa. ");
INSERT INTO sue_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu meni numorekare noko ego senua awa, “Na nikare doro bayana na kau wero pasina nisokare amire dai noma betamunowa. Na baro nuamunona amira nikare bayai ine tepo.” ");
INSERT INTO sue_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ago senu Yuda ema meni ego ina-sa wewa awa, “Nu ego toya, ‘Na baro nuamunona amira nikare bayai ine tepo.’ Ge ago awa nogo toi? Nu nutope tama dero betamu toita?” ");
INSERT INTO sue_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ge ago sewa Yesu meni ina ego senua awa, “Nikare bagera. Na ikera. Nikare zebura. Na zebura oko aewa. ");
INSERT INTO sue_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ami emo na nimorekare ego sesena awa, ‘Nikare pasina nisokare amire dai noma betamunowa.’ Na susu naso kerenitinowena, awa ninawa me kaka wamu wamunoya, awa nikare pasina nisokare amire dai noma betamunowa.” ");
INSERT INTO sue_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ago senu nukare noko atata wero ego sewa awa, “Ni aweni?” Ago sewa nu ina ego senua awa, “Na sawena gosinowewa. ");
INSERT INTO sue_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na pasina nisokare dainiro kereniro nikare gera potamu wero giro te wero baitamena. Ata nu na senu osena ami ge me towia. Are nane be nusora nana ena ninina da awa gege zebura ena kerenitinowena.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nu Mamere ago senu nukare kaka giro baitamu wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Are Yesu meni noko ego senua awa, “Nikare na Emara Mai awa ni pasinaira ikoniro amire susu naso gamunowa awa. Be amire na bua inowena awa kotumai nasora oko inowena awa gamunowa. Mama meni gipenua ge awa puro noise towena awa dai gamunowa. ");
INSERT INTO sue_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nu na senu osena ami namore dai nowia. Be giti bamu awa bua wawena giro ara tapinowia. Are nu na kaka duwamu nowia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu ge ago senu ema dainiro meni nu tuma diwa. ");
INSERT INTO sue_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nukare awa Yuda ema, are Yesu meni numorekare ego senua awa, “Nikare ge naso niniro baitiro dimuro nuamunowa, awa nikare mai dubu naso me wero nuamunowa. ");
INSERT INTO sue_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nikare ago inoise ge me niniro baitawa ami mui nisokare besamunoya. Besai mui amu kokopai nuamunowa awa.” ");
INSERT INTO sue_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ago senu ina ego sewa awa, “Nakare Abrahamra saisibuna. Nakare ema zora soumai kaka wamu nowenakare. Nakare mui amu nuamunonakare, awa sesesa amira susu nogo iti?” ");
INSERT INTO sue_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ago sewa Yesu meni ina ego senua awa, “Na me memeka sane. Zo nu pasina inowia ami pasinara soumai inoya. ");
INSERT INTO sue_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Soumai meni ema tua nusora ibu marara oko nuai gege nuamunoya. Ata ema tuara mai meni mamera ibu marara nuai gege nuamunoya awa. ");
INSERT INTO sue_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Are Mai meni nikare besamunoya, awa nikare mui amu me amu nuamunowa. ");
INSERT INTO sue_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nikare Abrahamra saisibuna awa gosinona. Ata ge naso meni nisokare nana mokara kaka toyamu inowia, are nikare na dawa betanise towa. ");
INSERT INTO sue_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na Mama nasora nana ena nena gosinoise noisona awa nikare tugata inowena, ata ninekare meni awa mama nisokarera niniwa awa inowewa awa.” ");
INSERT INTO sue_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ago senu nukare ina ego sewa awa, “Nakare mama nakare Abraham.” Ago sewa Yesu meni ego senua awa, “Nikare Abrahamra saisibuna nuamewa sia, awa nikare Abrahamra tani puro nuamewa. ");
INSERT INTO sue_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Anutura nana ena ge me susure ninina awa nikare tugata inowena, nama nogoro damu towi? Goroba ago ine awa Abraham meni oko wenua. ");
INSERT INTO sue_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nikare mama nisokarera bua inowewa.” Ago senu nukare ego sewa awa, “Nakare eba mai oko aewa. Anutu nu Mama nasokare daimata.” ");
INSERT INTO sue_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ago sewa Yesu meni ina ego senua awa, “Mama nisokare Anutu sia, awa nikare na ara tamamewa. Nera kota, na Anutura nana ena muro nowena. Na kotumai nasora oko osena. Anutu meni senu osena. ");
INSERT INTO sue_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nikare nogoro ge naso kaka gamu inowewi? Nikare kaka gamu inowewa, nera kota, ge towena awa nikare ninai ine tepo. ");
INSERT INTO sue_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nikare mama nisokare Satan amira mai awiso, are ara tamai nuso ama ganero bua waya awa wamu towewa. Nu gita ona ema dasai betinoisowa, da ago ine i-tupewia awa. Nu ge me oko puro nowia. Nera kota, ge me zo nuso nana oko itia. Opi ge nuso meni nuso nana mokara be munua, are nu opi saira mama wero nowia awa. ");
INSERT INTO sue_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na ge me gege tona, are nikare ge naso gewa me kaka wamu inoya. ");
INSERT INTO sue_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nisokare nana zo meni na pasina ema ago sai me wamunoita? Tepo awa. Na ema agami ge me susure tugata wawena nogoro gawewa me kaka wamu inowi? ");
INSERT INTO sue_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Zo nu Anutura mai wero nowia ami Anutura ge ninitinowia. Nikare Anutura mai oko nowewa, are ge nuso azu towewa awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ago senu Yuda ema meni ego sewa awa, “Nakare nimore ego tonakare: Ni Samaria ema. Bi meni niso nana itia. Nimore ago toise ge me tonakare.” ");
INSERT INTO sue_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ago sewa Yesu meni ego senua awa, “Bi naso nana mokara oko itia. Na Mama naso bowi inowena, ata ninekare meni awa zazo naso puro osisinowewa. ");
INSERT INTO sue_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na zazo bowire naso wamu oko towena. Zo itia ami zazo naso de ike nitinowia. Nune zas inoya. ");
INSERT INTO sue_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na me memeka sana niniu. Zo nu ge naso niniro puro nuamunoya ami oko betamunoya. Nu nuai gege nuamunoya.” ");
INSERT INTO sue_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ge ago senu Yuda ema nukare ego sewa awa, “Bi niso nana mokara itia awa me towenakare. Abraham betenua, ota porofete eni nukare da ago bebeteniwa. Ata ni ego tosa, ‘Zo nu ge naso puro nuamunoya ami oko betamunoya.’ ");
INSERT INTO sue_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mama nasokare Abraham betenua. Ota nine nu dainamu tosita? Ina porofete dago betewa awa. Ni nogoro tama niso puro wititinosi?” ");
INSERT INTO sue_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ago sewa Yesu meni numorekare ego senua awa, “Na tama naso puro witana te oko wamunoya. Mama naso nowia, awa nikare Anutu nisokare asinowewa, nune ami na bowi inowia. ");
INSERT INTO sue_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nikare nu giro kaka giro baitamu inowewa. Nane meni awa giro baititinowena awa. ‘Na nu kaka gamu inowena,’ ago samena, awa na opi sai ema nikare ine wamena. Na nu giro baititinoise ge nuso dipinoise nowena awa. ");
INSERT INTO sue_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mama nisokare Abraham nu kei awaira be naso gamu sero yawa sara inoise noisonua. Are nu be naso giro yawa sara wenua awa.” ");
INSERT INTO sue_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ago senu Yuda ema meni ina ego sewa awa, “Ni zepa niso 50 kaka wamu ami Abraham gisita?” ");
INSERT INTO sue_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ago sewa nu ego senua awa, “Na me memeka sane. Na Abraham kaka kei awamure noisona nowena ewa.” ");
INSERT INTO sue_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ago senu nukare omata puro damu sero wewa ibu mokara ena tara awero kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu nu susaumite ema zo miera nana tinira ena giti guma wai kei awero itisonua awa tamunua. ");
INSERT INTO sue_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ago wenu bua mai nuso meni nu atata wero ego sewa awa, “Gipai ema, pasina ara amira ema ei awa giti guma wenu? Pasina nuso amirata mia mamera amira ni?” ");
INSERT INTO sue_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ago sewa Yesu meni ina ego senua awa, “Amira oko aewa. Pasina nusorata mia mamera amira oko aewa. Anutu putou nusora susu ami ema emira nana kei awaise ago wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ema bama waikore bua wawera pi ziawi giro bua dotinowera, da ago ine nakai nama senu osena amira bua waikore inoise nuanekai. Be zo mai amire bua nuso waira be tepo wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na zebura nuamunona, te zasimai naso meni nikare zasipitinuamunoya awa.” ");
INSERT INTO sue_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ago sero pora we zebura niro zebure dawero puro emara gitira anenua awa. ");
INSERT INTO sue_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Anero iyetitinoise ego senua awa, “Ni baro Siloam ou butura ana benau niso sewe.” Ago senua awa. (Siloam awa ge nasokaira “Iyetai”). Are ema awa baro ou butu amira ana giti moka sewenu giti moka keenua awa. ");
INSERT INTO sue_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Giti moka keenu ewesemunu otao mamaita ema nu nena emo begomo tuasai gosinoisowa ami nu giro ego sewa awa, “Nena emo begomo toise itewia awa ni, tanita?” ");
INSERT INTO sue_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ago sewa eni meni ego sewa awa, “Nu awa.” Ota eni meni ego sewa awa, “Nu tepo, ata nu ine zo.” Ago toiwa nu nutope ego senua awa, “Zo tepo, ata na ewa.” ");
INSERT INTO sue_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ago senu nukare nu atata wero ego sewa awa, “Nogo nogo wetesa giti moka niso kokopai weti?” Ago sewa nu ego senua awa, ");
INSERT INTO sue_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","“Ema zo zazo nuso Yesu ami zebu dawero giti moka nasora anero ego sero iyetia awa, ‘Siloam ou butura baro benau niso sewe.’ Ago sesi baro sewetena giti moka naso keetia.” ");
INSERT INTO sue_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ago senu nukare atata wero ego sewa awa, “Ema awa nago noi?” Ago sewa nu ego senua awa, “Na kaka gamu inona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ago senu nukare ema gita nu giti guma wai awa puro bamu Farisayo dubura nana niwa. ");
INSERT INTO sue_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesu meni zebu dawero emara giti mokara anenu keenua, awa Sabat pura amire wenua. ");
INSERT INTO sue_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Are Farisayo nukare da ago atata wero ego sewa awa, “Ni nogo wetesa giti moka niso keeti?” Ago sewa ema giti guma wai ami ego senua awa, “Nu zebu dawero giti moka nasora aneti na baro oura ena sewetena giti moka keetia.” ");
INSERT INTO sue_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ago senu Farisayo eni meni ego sewa awa, “Ema awa Sabat purara ge sai zewai wai awa doinoya, are nu Anutura nana ena oko munua.” Ota nusokare nana eni meni ego sewa awa, “Nu ema waya nuami sia, awa tani putoure ago ine oko wamia.” Ago toise ge ina-sa wero zazaumuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ago tomite ema giti guma wai awa noko atata wero ego sewa awa, “Giti niso sesi keetia numore nogo tosi?” Ago sewa nu ego senua awa, “Nu porofete.” ");
INSERT INTO sue_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ago senu Yuda ema meni ema giti keenua amira ge niniro giro, “Gita nu giti guma wai tepota,” asero mia mama nuso zawa sewa muwato atata wero ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Ei awa mai nisoto ni? Nu giti guma wai tinira ena kei awenuta? Ota nu nogoro giti moka keeti?” ");
INSERT INTO sue_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ago atata wewa ina ego sewato awa, “Nu mai nasoto awa gosinonato. Ota nu giti guma wai tinira ena kei awenua, awa gosinonato. ");
INSERT INTO sue_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ata nogo wero giti moka keeti amira susu nato kaka gamu inonato. Ata ai meni giti nuso sesi kokopai weti, awa nato kaka gamu inonato. Nu baziro ema wai, are nikare nu atata weu sai gawe.” ");
INSERT INTO sue_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mia mama nuso meni Yuda ema azu weroto ge ago sewato. Nera kota, Yuda ema nukare ge emoko ego sewa zewai wenua awa, “Zo nu Yesure ‘Nu Kristo’ asamunoya, nu awa tunero yere ibura ena esenamunonakai awa.” ");
INSERT INTO sue_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ago sewa, are mia mama nuto azu wero ego sewato awa, “Nu baziro ema wai, are nikare nu atata weu sai gawe.” ");
INSERT INTO sue_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Are nukare ema giti guma wai awa noko zawa sewa munu ego sewa awa, “Ni Anutura benaura ena ge me se. Nakare ema amira susu gosinonakare. Nu ema waya.” ");
INSERT INTO sue_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ago sewa nu ina ego senua awa, “Nu ema wayata nogo wai ni, awa na kaka gamu inona. Ata na giti guma wai noe dotena giti moka keetia ami meni awa gosinona.” ");
INSERT INTO sue_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ago senu nukare noko atata wero ego sewa awa, “Nimore nogo nogo weti, o nogo wero weti giti moka niso keeti?” ");
INSERT INTO sue_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ago sewa nu ina ego senua awa, “Na aware sesena awa. Nikare nogoro kaka ninamu wetewi? Nogoro sai matu da awa noko sana ninamu towi? Nikare dai bua mai nuso wamu towita?” ");
INSERT INTO sue_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ago senu nukare nu gona inoise ego sewa awa, “Nine bua mai nuso zo wero nosa. Nanekare meni awa Mosera bua mai awa. ");
INSERT INTO sue_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anutu meni Mosere ge tugata wenua. Ami meni awa ninitinowenakare. Ata ema awa nana ena kei awero munu, ami meni awa nakare kaka gamu inonakare.” ");
INSERT INTO sue_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ago sewa ema giti moka keenua ami di tainiro ego senua awa, “Nikare kei awai nusora susu kaka gamu inowa, ata saineba, nu weti giti naso keetia awa. ");
INSERT INTO sue_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nakai ego ine ninitinowenakai: Anutu meni ema waya-kawaya amira isa sai oko ninitinoya. Ata zo nu Anutu bowi inoise Anutura ara tamai inoya amira isa sai awa Anutu meni ninamunoya. ");
INSERT INTO sue_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ota ema zo giti guma wai tinira ena kei awenu zo senu giti keenua amira uge zo oko itia. Nakai uge zo ago ine gita ona kaka ninamu tupise noisonakai nowenakai. ");
INSERT INTO sue_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Are ema awa Anutura nana ena kaka mamu wami sia, awa nu bua ago ine wai ine te oko wamia.” ");
INSERT INTO sue_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ago senu nukare ego sewa awa, “Ni tinira ena kei awero pasina mai nowesa ami nakare tugata wamu tosita?” Ago sero nu yere ibura ena musuniro eseniwa awa. ");
INSERT INTO sue_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Eseniwa Yesu meni niniro nu tamuro ego senua awa, “Nine Emara Mai tuma didinosita?” Ago senu nu ina ego senua awa, ");
INSERT INTO sue_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“O Tua, ni are tosi? Gipe giro tuma diane.” ");
INSERT INTO sue_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ago senu Yesu meni ego senua awa, “Ni nu goitasa awa. Na ge tona, na ewa.” ");
INSERT INTO sue_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ago senu ema giti guma wai ami ego senua awa, “O Tua, na ni tuma didinona.” Ago sero muro nuso nana te gitira ena koininua awa. ");
INSERT INTO sue_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ago wenu Yesu meni ego senua awa, “Na ema susu nisokare kerenamu sero zebura osena awa. Ema duba giti guma wai ami garise sero, ota ema ‘nakare gai’ asinowera ami duba giti guma wai itarise sero osena awa.” ");
INSERT INTO sue_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ago senu Farisayo eni numore dai dopero itiwa ami niniro ego sewa awa, “Nakare dai duba giti guma wai ni?” ");
INSERT INTO sue_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ago sewa Yesu meni ina ego senua awa, “Nikare duba giti guma wai nuamewa sia, awa pasinara ina nisokare nana oko itamia. Ata nitopekare ego towewa, ‘Nakare gai awa.’ Are pasinara ina nisokare nana itai gege itewia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu meni ge ego senua awa, “Na me memeka sana niniu. Zo nu lamara goma amira toyamu sero so be doro demese ena goma zausemuro bamu mokara nitinoya, nu awa bewana ema. Nu nena ewera pai ema. ");
INSERT INTO sue_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Zo nu so be piakaniro toitinoya, nu ami lama dia me awa. ");
INSERT INTO sue_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nu mawi giro so be dia wai meni so be piakanawi lama nuka nuso meni ge bapu nuso ninawera goma mokara ena zazo nusokare sero sero awero uzumuro puro susawewia awa. ");
INSERT INTO sue_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nu lama nuso uzumawi ge bapu nuso ninawera nu gita wawi nukare nu ama ganero susawewera. ");
INSERT INTO sue_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ota ema zo ewe awa nukare oko ama anamunora. Nukare ge bapu nuso ewe niniro azu wero sumamunora.” ");
INSERT INTO sue_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu nu ge bezai awa senu nukare ge nusora susu kaka gamu wewa. ");
INSERT INTO sue_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu meni noko sero senua awa, “Na me memeka sana niniu. Lama toitinowera amira so be awa na ewa. ");
INSERT INTO sue_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na kaka kei awamure gita kei awewa nukare awa bewana ema. Nukare nena ewera pai ema. Ata lama meni ge nusokare doro azu wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Lamara so be awa na ewa. Zo nu goma mokara toyamu sero naso nana mamunoya, awa nu Anutu meni soero pamunoya. Ago wai nu toiro pusumuro awinoise nena zamai bamubake tamamunoya. ");
INSERT INTO sue_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bewana ema nu lama bewana wamu sero, o damu sero, o dero tepo-tapo wamu sero tupewia. Ata nane meni awa lama zamai bamubakere kokopai nuarise sero kei awena awa. ");
INSERT INTO sue_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Na lama dia wai kokopai. Dia kokopai meni lama dubu emo nuai nuso duamunoya. ");
INSERT INTO sue_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ota soumai meni awa, nu dia me tepo. Lama awa nuso kota, ewera, are abu suna kei awai giro nu lama dubu doro azu bayai abu suna meni gamai bozamunora. ");
INSERT INTO sue_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nu soumai gege. Nu lama dubu emo oko kotupitinoya. Are nu doro susawia. ");
INSERT INTO sue_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Na dia kokopai nowena. Nato Mamere ina-ga inowenato, da ago ine na ata lama dubu naso nakare ina-ga inoise nowenakare. Are na lama dubu emo nuai naso dotinona awa. ");
INSERT INTO sue_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Lama dubu naso zo nora, awa nukare goma emira oko aewa. Are na baro uzumuro puro mana ge naso ninamunora. Ago wana lama dubu daimata wero dia daimata wero nuamunora. ");
INSERT INTO sue_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na nuai naso doro noko pamunona, are Mama meni na ara tapinowia. ");
INSERT INTO sue_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nuai naso awa ema zo meni oko soero pamunoya. Awa kotumai nasora duamunona. Na nuai naso doro noko pamunona amira putou na itia. Mama naso meni ago wanise senua awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yuda ema nukare ge awa niniro zaumuro dubu eto wewa. ");
INSERT INTO sue_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Dubu bamu meni ego sewa awa, “Bi meni mokara toi dau inoya. Nogoro ge nuso ninitinowi?” ");
INSERT INTO sue_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ata eni meni ego sewa awa, “Bire meni ge ago ine oko samunoya. Bi meni ema giti guma wewenai awa sai giti panamunorita? Tepo awa.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yuda emara pura zo zazo nuso Ibu Bamu Korawewa* amira be munu giro nukare Yerusalem ena auniwa. Be awa zazamara be. ");
INSERT INTO sue_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Are Yesu meni ibu bamura osi zo zazo nuso Solomonra Osi amira izima-sauma awinoinu ");
INSERT INTO sue_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yuda ema nukare nu zimuro atata wero ego sewa awa, “Ni nogoro susu niso bezawesa nakare itazaita inowenikare? Ni Soyai Ema nasokare Kristo me noma giro kereniro se ganekare.” ");
INSERT INTO sue_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ago sewa Yesu meni numorekare ina ego senua awa, “Na sesena ninisewa, ata ninewa me kaka wamu inoya. Ata bua eni na Mama nasora bera inowena ami susu naso kerenitinowia. ");
INSERT INTO sue_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ata nikare lama dubu nasoko, are ge naso ninewa me kaka wamu inoya. ");
INSERT INTO sue_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Lama dubu naso wero nowera nukare awa ge naso ninitinowera. Are nane nukare gosinuawena na ama ganinowera. ");
INSERT INTO sue_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ago wawera na nuai me ewanana numorekare potawena kaka betamu nuai gege nowera. Nukare wana nasora ena zo meni soero pai ine oko itia. ");
INSERT INTO sue_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mama naso meni nukare namore potinua awa. Mama naso meni ema dapikarago ata nena dapikarago awa dainitinowia. Are zo meni Mama nasora wanera ena nukare soero pai ine tepo. ");
INSERT INTO sue_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na ata Mama awa nato daimata.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ago senu Yuda ema nukare omata meni Yesu noko damu wewa. ");
INSERT INTO sue_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Damu inoiwa Yesu meni ego senua awa, “Bua kokopai dainiro Mamera soremai amira wetena gewa, are nikare tani na-awa giro na omata meni damu towi?” ");
INSERT INTO sue_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ago senu nukare be nusora puro ego sewa awa, “Bua kokopai inowesa amira kota, ni da ago ema nowesa ami Anutu dainitinoise ni nitope Anutu asinowesa, ami emo nakare ni omata meni damu tonakare.” ");
INSERT INTO sue_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ago sewa Yesu meni ina ego senua awa, “Lo ge nisokarera ego gayai itia awa, ‘Anutu meni ego senua awa: Nikare tua.’ ");
INSERT INTO sue_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Agoro ge gayai itia awa doro zo sai ine oko itia. Are Anutura ge ewowo-kawowo nasokai amira nana kei awenu giro nu nukare ‘Tua’ asenua, ");
INSERT INTO sue_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","noko Mama nama gita ose zebura nanise sero na senu osena. Are na natope Anutura Mai asawena nikare nogoro na Anutu dainamu inona asinowewi? ");
INSERT INTO sue_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bua inowena awa gawa Mama nasora ine kaka wamu wamunoya, awa ge naso duawa te wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ota gawa Mama nasora ine wamunoya, awa ge nasora kota, bua wai nasora na gawa me waise. Ago inoise Mama meni namore dai nowia, da ago ine na Mamere dai nowena, amira susu awa giro baitamunowa.” ");
INSERT INTO sue_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ago senu giro nukare nu benamu sero wewa doro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu nu baro ou Yodan enibara Yohane meni gita ema bama ge ou gutinoisonua ago baro noisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ago noinu ema dainiro meni nuso nana baro ego sewa awa, “Yohane nu tani putoure zo kaka wamu. Ata ge Yohane meni ema emire sisia awa me inoya.” ");
INSERT INTO sue_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Are ema dainiro meni so amira ana Yesu tuma diwa awa. ");
INSERT INTO sue_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betani natara ema zo noisonua zazo nuso Lasaro. Nu ami yaya puro itinua. Mariato Matare, nuto maeto zawere, nuto nata da amira. ");
INSERT INTO sue_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Maria ou zamare meni Tuara te sewero giti tu nuso meni Tuara te gaenua amira numata Lasaro ami yaya puro itinua.) ");
INSERT INTO sue_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Are maeto zawere meni Yesura nana ge ego ine potiwato bamunua, “O Tua, ni nini. Otao niso yaya puro itia.” ");
INSERT INTO sue_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ge ago potiwato bamunu Yesu meni niniro giro ego senua awa, “Yaya amira me awa betai kei awaise kota, ema bama meni Anutu bowi warise sai awa. Ema bama meni Anutura Mai bowi warise sero yaya awa kei awitaya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesura ara tamai awa Matato zawere ata Lasaro amira nana itisonua. ");
INSERT INTO sue_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Are nu yaya ge niniro waiko be eto dago itinua. ");
INSERT INTO sue_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ago itimite nusokare nana bayamu sero bua mai nusore ego senua awa, “Muu. Yudaya zebura ewesemuro bayanekai.” ");
INSERT INTO sue_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ago senu bua mai nuso meni ego sewa awa, “Gipai ema, waiko be zo omire Yuda ema omata meni ni damu sisera, awa nogoro amire noko nusokare nana ewesemanisekai tosi?” ");
INSERT INTO sue_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ago sewa Yesu meni bua waira be nuso kaka tepo wamu dago itinua awa garise sero ge bezai zo ego senua awa, “Bua waira be 12 aua itia awa. Zo nu waikore ebete susauma te oko koinamunoya. Nera kota, nu zebura zasimai gosinoya. ");
INSERT INTO sue_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Zo nu pire ebete zasimai tepo susauma te koiniro duwamunoya.” ");
INSERT INTO sue_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ago sero ge zo ego senua awa, “Otao nasokai Lasaro gitawa inoya, ata nakai barokai na nu awa-uzamunona.” ");
INSERT INTO sue_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ago senu bua mai nuso meni ego sewa awa, “Tua, nu auro kokopai wamunoya.” ");
INSERT INTO sue_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu meni betaira ge awa gitawa waira potiro senu bua mai nuso meni gitawa mere toita asero ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Are Yesu meni kereniro ego senua awa, “Lasaro betitaya. ");
INSERT INTO sue_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na ago kaka baro nuamu ego nona betitaya, are na nikare emo duba naso kokopai inoya. Nikare tuma diai mere nuawise nena awa kei awitaya. Are nuso nana bayanekai.” ");
INSERT INTO sue_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ago senu Tomas zazo nuso zo Didimo nune ami otao mamaire ego senua awa, “Nakai baro numore dai betanekai.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lasaro bi ditira itinu be zoeto-zoeto wenu amire Yesu baro kei awenua. ");
INSERT INTO sue_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani nata awa Yerusalem nana zorage kena itinua. Bayaira ebata awa kilomita 4 gege. ");
INSERT INTO sue_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Are Yuda ema dainiro meni Matato Mariara numata betenua awa gamu muwa awa. ");
INSERT INTO sue_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Are Mata nu “Yesu tupia,” ago sewa giro Maria sora dago itinu nune baro Yesu ebete ena tamunua. ");
INSERT INTO sue_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tamuro numore ego senua awa, “O Tua, ni ego nuamesa, awa numata naso oko betamia. ");
INSERT INTO sue_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Agoro na susu niso gosinona. Ni zeme nena zo emo Anutu isa sasa ninamunoya.” ");
INSERT INTO sue_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ago senu Yesu meni ina ego senua awa, “Numata niso seka wero eramunoya.” ");
INSERT INTO sue_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ago senu Mata meni ina ego senua awa, “Ama be bamura ena seka wero eramunoya awa gosinona.” ");
INSERT INTO sue_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ago senu Yesu meni ego senua awa, “Seka wero erai ata nuai amira mama na ewa. Are zo nu na tuma diamunoya ami betero noko eriro nuamunoya. ");
INSERT INTO sue_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ota zo nu seka noise na tuma diro nuamunoya ami kaka betamu seka nuai gege nuamunoya. Ni ge awa ninesa me inoita?” ");
INSERT INTO sue_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ago senu Mata meni ego senua awa, “Ni Kristo, Anutura Mai me. Ni zebura osasise sai, awa ninena me weti giro ni tuma didinona.” ");
INSERT INTO sue_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ago sero baro zawa nuso Maria zawa senu munu upene ego senua awa, “Gipai ema muro ni zawa toya.” ");
INSERT INTO sue_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ago senu Maria meni niniro eya eriro Yesura nana bamunua. ");
INSERT INTO sue_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu nu nata atura ena Matare ge senua zara da amira dopero itinua. ");
INSERT INTO sue_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Itinu Maria eriro bamunu Yuda ema betaira muro itiwa ami “Maria bi ditira ena di samu susawia,” asero ama ganero bamuwa. ");
INSERT INTO sue_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Are Maria nu ose nata atura niro Yesu tamuro nuso nana koiniro ego senua awa, “O Tua, ni ego nuamesa, awa numata naso oko betamia.” ");
INSERT INTO sue_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ago sero di senu Yuda ema Maria ama ganewa ami Maria giro da ago di eroma sewa awa. Di sewa Yesu meni ginu mou wenu koininua awa. ");
INSERT INTO sue_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yesu meni atata wero ego senua awa, “Nu nago gowitawi?” Ago atata wenu ego sewa awa, “Tua, mu gase.” ");
INSERT INTO sue_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ago sewa Yesu di senu diriu munua. ");
INSERT INTO sue_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ago wenu Yuda ema nukare nu giro ego sewa awa, “Giu. Duba nuso bamubake Lasaro nana itia.” ");
INSERT INTO sue_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ago sewa eni meni ego sewa awa, “Giti guma wai zo senu giti panenua da ago ine ema ei awa betai azu wero nu kora wai kokopai wai te kaka wamu inoita?” ");
INSERT INTO sue_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ago toiwa Yesu ge awa niniro moka nuso meni yaya bamubake tamuro bamu bi ditira ninua. Betaira masi awa omata bamubake meni dereweniwa baro be gazenua. ");
INSERT INTO sue_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Are Yesu meni ego senua awa, “Omata be gazai awa derewieu bayae.” Ago senu Mata nu betaira nubama ami ego senua awa, “Tua, nu waiko zoeto-zoeto awia, are gugumu toya.” ");
INSERT INTO sue_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ago senu Yesu meni ina ego senua awa, “Na ego sesena awa, ‘Ni na tuma diamunosa, awa ni Anutura putou gamunosa.’ Ge awa sesena ninesita?” ");
INSERT INTO sue_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ago senu omata dereweniwa bamunu Yesu meni iri ike niro ego senua awa, “Mama, ni isa naso nenesa, are na nimore kokopai asinona. ");
INSERT INTO sue_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ni isa naso be giti ninitinowesa awa gosinowena. Ata ema dubu emi nine sesa osena awa gara me waise sero ge ago tona awa.” ");
INSERT INTO sue_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ago sero zawa sero ego senua awa, “Lasaro, ni pusumuro mu.” ");
INSERT INTO sue_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Zawa senu betai meni pusumuro munua awa. Te-wana nuso mo meni dowai, ota benau nuso mo meni gopai, are Yesu meni ego senua awa, “Mo beseu bayae.” Ago senu mo besewa bamunua awa. ");
INSERT INTO sue_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yuda ema Maria nana muro itiwa amira nana dainiro meni tani putoure awa giro Yesu tuma diwa awa. ");
INSERT INTO sue_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ata eni meni awa Farisayo emara nana bamuro Yesu meni tani wenua amira ge uge wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Are pris babezinomare Farisayo ema nukare ge awa niniro giti kopi dubu zawa sewa muwa auniro ego sewa awa, “Ema ami tani putoure dainiro inowia, are nu nogo wamunonikai? ");
INSERT INTO sue_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nakai nu duanakai tani ago ine inuai ema dapikarago nu tuma diara Roma emara soldia meni nakai iwo wero muro ibu bamu nasokaire dubu nasokaire awa gera wamunora.” ");
INSERT INTO sue_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ago sewa otao nusokare zo zazo Kayafa nu zepa amire pris bamu wero noisonua ami ego senua awa, “Nikare kotumai tepo nowewa. ");
INSERT INTO sue_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nikare ego giu. Ebata kokopai ego itia awa. Ema dubu nakai waya wai azu, ema daimata ami nakai emo betaise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ge awa kotumai nusora oko senua. Nu zepa be amire pris bamu wero noisonua, are nu porofete meni sago wero Yesu nu Yuda ema dubu emo betamu inoinua amira ge senua. ");
INSERT INTO sue_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yesu betamu inoinua, awa Yuda ema emo gege kota, nu Anutura mai awiso zebu sero nowera nukare dapikarago poti dara nai dubu daimata wero nuarise betamu inoinua awa. ");
INSERT INTO sue_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Are giti kopi dubu nukare waiko be amire Yesu puro daira ge bua zaawewa. ");
INSERT INTO sue_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Are Yesu nu Yuda emara nana noko kaka kei awero nuamu. Nu bua mai nuso puro bamuro nata zo zazo Efraim ware kena itinua amira noisowa awa. ");
INSERT INTO sue_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yuda emara pura zo zazo Betai Daininua amira be zora awenu giro nata pei-mamaira ema dainiro meni pasina disaira buara gita witiro bamu Yerusalem niwa. ");
INSERT INTO sue_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Are nukare Yesu kau inoise ibu bamura auniro ina-sa wero ego sewa awa, “Nikare nogo towi? Nu pura emire mamunoita, tepo ni?” ");
INSERT INTO sue_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pris babezinomare Farisayo emare nukare sai zewai wai ge ego sewa awa, “Ema zo meni nu tamuro giro saise nu puro benare.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Betai Daininua amira pura nusokarera waiko be 6 ago itinu Yesu meni Betani nate kei awenua. Nu gita nata amira ana Lasaro betaira ena awa-uzenu seka wero erinua awa. ");
INSERT INTO sue_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Are Yesu emo nena sawewa Mata meni dumunu Lasaro dai arumuro nena niwa awa. ");
INSERT INTO sue_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nena ninoise itiwa Maria meni boto kiaka zo ou zamare kokopai zazo nuso nad zuma bamubakere, awa puro Yesura te gutero giti tu nuso meni te nuso gaenua awa. Ago wenu so itiwa awa zama sere-sere wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ago wenu Yudas Iskeriot, nu Yesu kerenamu noinua, ami ego senua awa, ");
INSERT INTO sue_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nakai nogoro ou zamare awa potanakai 300 kina meni zuma gaero pumara moni awa bogamasare kaka potamu wetenikai?” ");
INSERT INTO sue_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nu ema bogamasare kotumuro oko senua. Yesu bua maire amira moni awa kaita zora potasara Yudas meni dia inoise moni eni bewana pupinoisonua awa. Are ge awa senua awa. ");
INSERT INTO sue_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ago senu Yesu meni ina ego senua awa, “Nikare bamere ge oko sawe. Nu ou zamare awa puro nuai na betana amire woi naso gutai gowawe. ");
INSERT INTO sue_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Erama bogamasa nukare be giti nimorekare dai nowera nuamunora. Ata nane meni awa nimorekare dai oko nuai gege nuamunona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yesu nata amira noinua amira oziga Yuda ema dainiro meni niniro muwa. Ota nukare Yesu gege gamu kota, Lasaro betaira ena awa-uzenu seka wero erinua awa dai gamu muwa. ");
INSERT INTO sue_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Are pris babezinoma meni Lasaro dai damu ge bua wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nera kota, Yuda ema dainiro meni Lasaro awa-uzenu seka wero erinua awa giro pris babezinoma doro Yesu tuma diwa, are nukare Lasaro dai damu sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pina atinu ema dubu bamubake meni pura nusokarera Yerusalem auniwa ami ge oziga ego niniwa awa, “Yesu tupia.” ");
INSERT INTO sue_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ge awa niniro giro ni gomi bozero wane-wane wero ebete ena tamamu bamuwa awa. Tamuro yawa sara inoise ego sewa awa, “Tuara bera nasokai nana tupia, nu awa bowi wanekai. Nu Tua nasokai Isreli emara.” ");
INSERT INTO sue_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu nu wo donki mai zo tamuro amira tame witiro arumuro bamunua. Awa ge gayai ego itia amira te wenua awa: ");
INSERT INTO sue_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Zion natara, nikare azu oko wawe. Giu. Ema tua nisokare tupia. Nu wo donki maira tame arumuro tupia. ");
INSERT INTO sue_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ge awa gita bua mai nuso meni kaka giro baitamu wewa awa. Noe Yesu nu witi utu zasimai nusora ninu amire ge awa kotumuro susu giwa awa. Ge awa numore gayai, are amira te wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nukare dubu bamu meni Yesu Lasaro zawa senu bi ditira ena kei awenu giwa ami ge uge wewa dubu bamu meni niniwa. ");
INSERT INTO sue_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tani amira oziga niniwa, are ema dainiro meni baro nu ebete ena tamuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ago wewa Farisayo nukare nutopekare ego toise sewa awa, “Gosinowa. Nikare ge bua gege kaputitinowa. Ema dapikarago nuso nana gege susawera.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yuda ema pura nusokarera Yerusalem aunitinoiwa Grik ema eni meni numorekare dai aunai amira noiwa awa. ");
INSERT INTO sue_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Are Grik ema ami Filip, nu Besaida natara Galilaya zebura, amira nana baro ego sewa awa, “Otao, nakare Yesu gamu tonakare.” ");
INSERT INTO sue_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ago sewa Filip meni baro Anderea sero eroma Yesura nana baro sewato awa. ");
INSERT INTO sue_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Sewato Yesu meni ina ego senua awa, “Na Emara Mai meni simai zasimaire pumamunona, amira be zora awinoya. ");
INSERT INTO sue_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Na ge me memeka sana niniu. Koni me zo zebura duro kaka zasamu wamunoya, awa nu imata tepo itamunoya. Ata nu zebura duro zasero eramunoya, awa nu me witai ziamunoya. ");
INSERT INTO sue_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Da ago ine, zo nu nuai nuso ara tapinowia amira nuai tepo wamunoya awa. Zo nu zebura noise nuai nuso iwo inowia ami nuai nuso zizinoise nuai me ewanana tamamunoya awa. ");
INSERT INTO sue_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Zo nu soumai naso wero nuamu wero giro na ama waise. Ago wero na nuamunona amira soumai naso nuamunoya awa. Zo nu na sou wamunoya nu awa Mama naso meni simamunoya. ");
INSERT INTO sue_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Zeme moka naso meni mamana awero zipinoya. Are na nogo samunoni? Mama, ni yaya ei awa musuni. Ago samunonita? Tepo awa. Na ge ago oko sane. Nera kota, na yaya ei awa umuro betamu sero osena. ");
INSERT INTO sue_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","O Mama, ni zazo niso de ike ni.” Yesu meni ago senu utura ena ge ego osenua awa, “Na zazo naso de ike nitana, noko de ike namunona.” ");
INSERT INTO sue_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ago senu ema dubu dopero itiwa ami niniro ego sewa awa, “Tarara gatetia.” Ota eni meni ego sewa awa, “Angelo zo meni ge numore sesi, tanita.” ");
INSERT INTO sue_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ago sewa Yesu meni nusokare nana bera puro ego senua awa, “Ge awa namore kota, nikare emo kei awetia. ");
INSERT INTO sue_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Zeme Anutu meni zebura ema bama awina-dawina wamunoya. Zeme na zebu emira tua* dereniro masi nuso pumamunona. ");
INSERT INTO sue_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nukare na zebura ena puro witi ike nara* zebu serora ema bama zumana naso nana mamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Awa betai nogo betamu inoinu amira ge awa senua. ");
INSERT INTO sue_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ago senu ema itiwa ami ego sewa awa, “Nakare ge gayai itia amira ego gosinowenakare awa: Soyai Ema nasokare Kristo nu kaka betamu nuai gege nuamunoya. Ata nine meni awa ego tosa, ‘Emara Mai puro witiro nira ikonamunora.’ Nogoro ago tosi? Emara Mai aweni?” ");
INSERT INTO sue_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ago sewa Yesu meni ge ina ego senua awa, “Zasimai meni nisokare nana ena be apunu-kaka gege zasimamunoya awa. Are mume meni nikare dowai azu, zasimai itai zasimaire noiwo. Zo nu mumera susawise ebata oko gosinoya. ");
INSERT INTO sue_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Are zasimai nisokare nana itai duba meni tuma didinoise dubu nuso wero noiwo.” Yesu meni ge ago sero nukare doro baro bezero noisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu nu tani putoure dainiro nusokare nana giti mokara wero munu gosinoise nu tuma kaka diamu wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Awa porofete Yesayara ge me waise ago ine wewa awa. Nu ge ego gaenua awa, Tua, oziga niso sawenakare ai meni gawi me inowi? Tua meni putou nuso are kereninu? ");
INSERT INTO sue_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Are nukare Yesura ge niniro nu tuma diai ine tepo wewa. Nera kota, Yesayara ge gayai zo itinua. Ge awa ego ewa, ");
INSERT INTO sue_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Anutu meni ego senua awa, “Nukare giti moka meni nena gai azu, o duba meni nena kotumuro gai azu, o duba nusokare kapetenara na nukare kora wai azu.” Anutu meni ago sero senu giti moka nusokare guma wenua, ota nu duba nusokare gazenu omata ine wenua. ");
INSERT INTO sue_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya meni ge awa gaenua. Nera kota, nu Yesura simai zasimaire giro ge awa Yesure senua awa. ");
INSERT INTO sue_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yuda emara gita wai ema dainiro meni Yesu tuma diwa. Ata nukare tuma diai nusokare kerenara Farisayo meni nukare yere ibura ena esenai azu, tuma diai bezero noisowa awa. ");
INSERT INTO sue_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ago wewa, nera kota, Anutu meni nukare bowi waise awa yaba pei-kaka inoisowa. Ata ema meni nukare bowi warise awa yaba bamubake inoisowa awa. ");
INSERT INTO sue_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu meni zawa sero ego senua awa, “Zo nu na tuma diamunoya ami na gege kota, na senu osena nu awa dai tuma diamunoya. ");
INSERT INTO sue_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ota zo nu na gamunoya ami na senu osena awa dai gamunoya. ");
INSERT INTO sue_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Zo nu na tuma diamunoya ami mumera itai azu sero na zasimai ine ami zebura osena awa. ");
INSERT INTO sue_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Zo nu ge naso niniro kaka dimamu duamunoya nu awa nane oko gera potamunona. Na ema gera potamu kota, korawamu osena awa. ");
INSERT INTO sue_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Zo nu ge naso niniro doro na azu samunoya amira zas itia. Ge towena ami ama be bamura ena zas nuso wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nera kota, na ge towena, awa duba nasora oko towena. Mama na senu osena ami ge sanise sero na tugata-magata wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na ego gosinowena: Mamera ge meni nuai me ewanana tapinowia. Are ge towena awa Mama meni sero gipenua te towena awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Betai Daininua amira pura be zora awinoinu Yesu nu nutope ego ginua awa, “Na zebu doro ewesemuro Mamera nana witamunona amira be zora awinoya.” Ago gosinoise giro bua mai nuso zebura noisowa awa dubara dumi pumunua. Dumi pumai nuso awa kaka tepo wamu. ");
INSERT INTO sue_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pire nukare nena namu auniro itiwa tani ego ine kei awenua. Simonra mai Yudas Iskeriot nu Yesu kerenaise Satan meni kotumai awa emoko duba nusora potinu itinua awa. ");
INSERT INTO sue_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Are Yesu meni ego ginua awa: “Mama nu nena dapikarago wana nasora potinu itewia. Na Anutura nana ena osena, noko Anutura nana ewesemuro witamunona.” ");
INSERT INTO sue_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kotumai ago gosinoise nena ninoinua awa doro eriro tama woi nuso tame awa dutero poti enibara niro tauli zo puro ipune awero ");
INSERT INTO sue_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ou tewara zozero bua mai nusora te sewenua awa. Sewero tauli ipune itinua ami te nusokare gaenua. ");
INSERT INTO sue_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ago inoise mai enira te sewero amire Simon Petorora te sewamu wenu nu ego senua awa, “Ni Tua meni te naso sewamu tosa?” ");
INSERT INTO sue_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ago senu Yesu meni ego senua awa, “Tani inona emira susu ni oko gosinosa. Noma ama gamunosa.” ");
INSERT INTO sue_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ago senu Petoro meni ego senua awa, “Tepo awa. Ni te naso oko sewamunosa.” Ago senu Yesu meni ina ego senua awa, “Na te niso kaka sewamu wana ni namore dai duba da wero oko nuamunosa.” ");
INSERT INTO sue_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ago senu Simon Petoro meni ina ego senua awa, “Tua, ago sero giro te naso gege kota, wanere gitire dai sewe.” ");
INSERT INTO sue_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ago senu Yesu meni ego senua awa, “Zo nu ou gutero noma te nuso gege sewai tama saramamunoya. Nikare saramai. Ata nisokare nana zo meni saramaire oko nowia.” ");
INSERT INTO sue_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nu kerenai ema awa gosinoise amire ego senua awa, “Nisokare nana zo meni saramaire oko nowia.” ");
INSERT INTO sue_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu meni te nusokare sewero pesuniro tama woi nuso iboi noko wosuniro arumuro itise ego senua awa, “Na nena nimorekare wetena amira susu gosinowita? ");
INSERT INTO sue_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nikare namore gipai ema asise, o Tua asise awinoise nowewa. Na ago wero nowena, are me towewa. ");
INSERT INTO sue_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Are na Tua nisokare o gipai ema nisokare meni na natope puro osisinoise te nisokare sewetena giro nikare nitopekare puro osisinoise te ina-sewa inoise nuawa te wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na tani nimorekare gipetena awa puro noise na wetena da ago ine inoise noiwo. ");
INSERT INTO sue_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na me memeka sana niniu. Soumai zo meni ema tua nusora nuai awa dainiro nuai ine oko itia. Ota buara senu bamunua ami buara mama dainai ine oko itia. ");
INSERT INTO sue_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Are nikare ge awa niniro baitiro amira te nuamunowa, awa nikare yawa sara wamunowa. ");
INSERT INTO sue_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Na ge sesena ami nikare dapikarago oko pupinoya. Dubu sianiro pumuna nikare awa gosinona. Ata ge gayai zo ego itia awa me waise sai itia, ‘Ma ewawena ninowia ami na damu toya.’ ");
INSERT INTO sue_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tani awa kaka kei awamure na nikare bere-bere tugata inona. Are ama tani awa kei awai amire nikare namore ego sewo, ‘Nu me Soyai Ema nasokai Kristo.’ ");
INSERT INTO sue_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na me memeka sane. Zo nu nikare buara potina awa sawa diamunoya ami buara mama na sawa dia ago ine wamunoya. Zo nu na sawa diamunoya ami na senu osena nu awa dai sawa dia ago ine wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu nu ge ago sero moka nuso waya wenu giro kereniro ego senua awa, “Na me memeka nimorekare sane. Nisokare nana zo meni na kereniro iwora nana wanera potamunoya.” ");
INSERT INTO sue_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ago senu bua mai nuso nukare ina-ga wero are toi asero kau wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Are mai zo Yesura nana zorage itinua. Yesu nu ara tapinoisonua. ");
INSERT INTO sue_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Are Simon Petoro meni giti-awa meni etete wero ego senua awa, “Atata we sai gase. Are toi?” ");
INSERT INTO sue_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ago senu mai ami Yesu nana zorage baro be dane potiro ego senua awa, “Tua, ni are tosi?” ");
INSERT INTO sue_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ago senu Yesu meni ina ego senua awa, “Porong sura patiro potana namunoya nu amire tona.” Ago sero porong sura patiro Simonra mai Yudas Iskeriot amire potinu ninua awa. ");
INSERT INTO sue_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ninu Satan meni moka nusora toinua awa. Ago wenu Yesu meni ego senua awa, “Tani wamu tosa awa eya weyo.” ");
INSERT INTO sue_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ge ago Yudasre senu eni dai itiwa ami gera susu kaka gamu wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Eni meni ego sewa awa, “Yudas nu moni nasokai dia inowia, are nu pura emira nena zo paise sesi susawita? Ota ema bogamasare moni kanowaise toi?” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas nu porong niro eya eriro pi mumere bamunua awa. ");
INSERT INTO sue_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas bamunu Yesu meni bua mai enire ego senua awa, “Emara Mai amira zazo de ike naira be zeme zora awetia. Tani naso nana kei awamunoya ami Anutura zazo de ike namunoya. ");
INSERT INTO sue_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Are na Emara Mai meni Anutura zazo de ike nana nu nutope zazo naso de ike namunoya. Agoro be iboi tepo, eya de ike namunoya. ");
INSERT INTO sue_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","O mai awiso naso, na be apunu-kaka nimorekare dai nuamunona. Ama nikare na kau wamunowa. Are na Yuda ema enire sisena da ago ine nimorekare sane. Na bayamunona amira nikare bayai ine oko itia. ");
INSERT INTO sue_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Are na potai ge seka zo nimorekare potitinona. Dubara dumi ina-pa wewo. Na nikare dubara dumi pumawena nowewa ago ine nitopekare dubara dumi ina-pa inoise noiwo. ");
INSERT INTO sue_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nikare dubara dumi ina-pa inoise nuawa ema nikare giro Yesura bua mai wero nora asamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ago senu Simon Petoro meni atata wero ego senua awa, “Tua, ni nago bayamunosi?” Ago atata wenu Yesu meni ina ego senua awa, “Na bayamunona amira ni zeme emire bayai ine oko itia. Noma ama bayamunosa.” ");
INSERT INTO sue_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ago senu Petoro meni ego senua awa, “Tua, ni nera na zeme nimore dai bayai ine oko itia asinosi? Na ni emo inoise nuai naso sisamunona te awa.” ");
INSERT INTO sue_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ago senu Yesu meni ego senua awa, “Ni na emo nuai niso sisamu tosa? Na me memeka sane. Kokara ge kaka samure nine na begi wasa be etorobara wamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu meni bua mai nusore ego senua awa, “Nikare duba nisokare oko sisawe. Nikare Anutu tuma didinoise na dai tuma diwo. ");
INSERT INTO sue_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mama nasora nata amira ibu-mara dainiro itera. Ago kaka itamu sia, awa na itai zara nisokare sia wamu bayamunona ago oko samena. ");
INSERT INTO sue_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Are na baro itai zara nisokare sia wero noko kapeteniro muro nikare uzumana baro na nuamunona da amira nuamunowa. ");
INSERT INTO sue_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bayamunona amira ebata awa gosinowewa.” ");
INSERT INTO sue_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ago senu Tomas meni ina ego senua awa, “Tua, ni nago bayamunosi, awa nakare kaka gamu inonakare. Are nogo wero ebata gamunonikare?” ");
INSERT INTO sue_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ago senu Yesu meni ina ego senua awa, “Ebata Mamera nana bayai awa na ewa. Ge me kerenai awa na ewa. Nuai seka potai awa na ewa. Na dainiro Mamera nana kei awai ine oko itia. ");
INSERT INTO sue_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nikare susu naso gamewa sia, awa nikare Mama nasora susu da ago gamewa. Zeme nikare Mama nasora susu gewa kei awinoya.” ");
INSERT INTO sue_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ago senu Filip meni ego senua awa, “Ni Mama gipasa giro te asamunonakare.” ");
INSERT INTO sue_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ago senu Yesu meni ego senua awa, “Filip, na be iboi-tatana nimorekare dai nuawena ni na kaka giro baitamu inowesita? Zo nu na gosinowia ami Mama gosinowia. Are ni nogoro, ‘Mama gipe ganekare,’ ago tosi? ");
INSERT INTO sue_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mama meni naso nana itewia, da ago na Mamera nana itewena, awa gesa me kaka wamu inoita? Ge nimorekare tugata inowena awa duba nasora oko tugata inowena. Mama meni duba nasora noise bua nuso inowia. ");
INSERT INTO sue_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mama meni namore itewia, o na da ago Mamere itewena ge awa niniwo me wae. Ota ge awa gawa me kaka wamu wai giro tani inowena awa kotumuro amire ge awa giwo me wae. ");
INSERT INTO sue_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na me memeka sana niniu. Zo nu na tuma diamunoya ami bua inowena da awa wamunoya. Na Mamera nana witamunona, are nu bua awa gege kota, wai nama awa dainiro bamu wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nikare zazo naso puro noise isa sawa te ninitinoise wamunona. Awa Mamera bowi kei awaise sero na Mai meni ago wamunona. ");
INSERT INTO sue_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nikare zazo naso puro noise na nena zo emo begomo sawa ninitinoise ago wamunona. ");
INSERT INTO sue_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ara tamai nisokare naso nana itamunoya, awa nikare ge naso dimamunowa. ");
INSERT INTO sue_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nane Mama begomo sana nu Soremai nisokare zo potai osero nimorekare dai nuai gege nuamunoya. ");
INSERT INTO sue_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nu awa Ozana. Nu ge me susure nimorekare gipamunoya. Ema na tuma kaka diamu inowera ami Ozana giti moka nusokare meni oko gosinowera. Noko nukare nu kotumai meni oko gosinowera. Are nukare Ozana puro nuai ine tepo. Ata nu nimorekare dai nowia, ota moka nisokarera toiro nuamunoya. Are nikare nu giro baititinowewa. ");
INSERT INTO sue_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na nikare duana popoiwo oko wero nuamunowa. Na nisokare nana noko ewesemuro mamunona. ");
INSERT INTO sue_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Be apunu-kaka zo itia awa tepo wai amire ema na tuma kaka diamu nowera ami na noko oko gamunora. Ata ninekare na gamunowa. Na nuai gege nowena, are nikare dai nuamunowa awa. ");
INSERT INTO sue_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ozana meni ose nisokare nana nai amire Mama meni namore dai nowia, ota na nimorekare dai nowena, ota nikare namore dai nowewa, amira susu awa giro baitamunowa. ");
INSERT INTO sue_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Zo nu bera ge naso niniro puro dipinoise nowia amira ara tamai awa naso nana itia. Are zo nu na ara tapinowia, da ago ine Mama naso meni nu ara tamamunoya. Ota nane da ago nu ara tapinoise susu naso numore kerenamunona.” ");
INSERT INTO sue_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ago senu Yudas Iskeriot amira zazo meni atata wero ego senua awa, “Tua, ni nogo wero susu niso namorekare gege kerenitinoise ema eni bamu amire kaka kerenamu bezamunosi?” ");
INSERT INTO sue_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ago senu Yesu meni ina ego senua awa, “Zo nu na ara tamamunoya ami ge naso niniro dimamunoya. Ago wai Mama naso meni nu ara tamamunoya. Ago inoise nato Mamere nuso nana kei awero nuamunonato awa. ");
INSERT INTO sue_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Zo nu na ara kaka tamamu wamunoya ami ge naso oko dimamunoya. Ota ge tugata wawena gosinowewa awa naso kota, Mama na iyetinua amira nana ena tupewia awa. ");
INSERT INTO sue_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na nimorekare dai noise ge ago ine tugata-magata inowena awa. ");
INSERT INTO sue_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ota Soremai nisokare Ozana awa nu Mama meni be nasora iyetai osero ge dapikarago nimorekare tugata-magata wamunoya. Ge nane tugata inowena da awa Ozana meni awa-uzero tepo wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na duba-ozaire nuai awa nimorekare potitinona. Na duba-ozaire nuai naka naso awa nimorekare potitinona. Zebura ema meni potitinowera ago ine kota, duba-ozaire nuai naso me awa nimorekare potitinona. Are duba nisokare azu wai tepo, kotumu-katumu wai tepo, itarise. ");
INSERT INTO sue_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na ego sesena ninewa awa. Na nikare doro baro noma noko nisokare nana ewesemuro mamunona. Nikare na ara tamamewa sia, awa na Mamera nana witamunona awa giro yawa sara wamewa. Nera kota, Mama nu witai naso nowia. ");
INSERT INTO sue_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tani naso nana kei awamunoya awa kaka kei awamure gita nimorekare tona. Are kei awai amire tuma diai nisokare zewai waise. ");
INSERT INTO sue_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na ge dainiro susumuro nimorekare oko samunona. Zebura tua Satan meni naso nana mamu inoise inoya. Ata nu namore tani zo wai ine tepo. ");
INSERT INTO sue_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ema na tuma kaka diamu inowera ami ara tamai naso Mamera nana itia awa garise sero bua ge towia awa inowena. Are eriu bayanekai.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu meni ego senua awa, “Na wain susu me. Mama naso meni wain buara mama. ");
INSERT INTO sue_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Bona zo naso nana itise me kaka ziamu wai giro kapero duamunoya. Ota bona zo mere itai giro me dainiro ziaise sero kapero kora wai saramamunoya. ");
INSERT INTO sue_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nikare awa ge tugata wena niniwa, are Mama naso meni waya nisokare kapero nikare kora wenu saramuro nowewa. ");
INSERT INTO sue_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Are nikare namore dai nuawa na da ago nimorekare dai nuamunona. Wain bona meni susure kaka gamamu nu gege itise me oko ziamunoya. Are nikare da ago ine namore kaka tayamu inoise me oko ziamunowa. ");
INSERT INTO sue_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Na awa wain susu. Nikare awa bona-wagana. Zo nu naso nana susumuro nuamunoya, awa na da ago nuso nana susumuro nuamunona. Ago wana nu me witai ziamunoya. Nikare na doro noise Anutura bua zo wai ine oko itia. ");
INSERT INTO sue_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Zo nu naso nana kaka susumamu wamunoya, nu awa duamunona. Ago wana wain bona duawera amawi sianiro niaora potawera awinowia ago ine wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nikare naso nana susumuro ge naso poti dube niro nuamunowa, awa nena zota zo emo begomo sawa nisokare nana kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nikare me bamubake zizinoise bua mai naso wero nuawa Mama nasora bowi kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mama meni na ara tapinowia, da ago ine nane nikare ara tapinowena. Are nikare ara tamai nasora noiwo. ");
INSERT INTO sue_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na Mama nasora ge dipinowena, are ara tamai nuso naso nana itewia. Da ago ine nikare ge naso dimamunowa, awa ara tamai naso nisokare nana itamunoya. ");
INSERT INTO sue_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yawa sara wai naso meni nisokare nana itai amire yawa sara nisokare meni moka nisokarera be muro itaise sero ge awa sesena. ");
INSERT INTO sue_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Potai ge naso ego itia awa: Na nikare ara tapinowena, da ago ine nitopekare ara ina-tama inoise noiwo. ");
INSERT INTO sue_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Zo nu otao mamai nuso soyamu wero giro nuai nuso nukare emo doro betamunoya amira ara tamai awa ara tamai me asamunora. ");
INSERT INTO sue_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ge potitinowena awa dimamunowa, awa nikare otao mamai naso wamunowa. ");
INSERT INTO sue_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na be zeme emire nimorekare soumai oko tona. Nera kota, soumai meni ema tua nusora kotumai itewia awa oko gosinowia. Na nikare soumai kota, otao mamai naso asinona. Nera kota, nane Mama nasora nana ena ge ninina awa te kereniro tugata wero tepo watana. Are na nikare gena otao mamai naso inowa awa. ");
INSERT INTO sue_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ninekare na buara bayanise sero oko pumuwa. Nane nikare buara bayawise sero pumuna. Are nikare baro buara me bamubake ziawise sena awa. Are me ziawa itai gege itaise. Ago wero zazo naso puro noise Mama begomo sawa te potamunoya. ");
INSERT INTO sue_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nikare nitopekare ara ina-tama inoise noiwo. Ge awa potai ge naso awa. ");
INSERT INTO sue_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ema ge naso kaka ninamu ami nikare iwo wara amire ego sewo, ‘Gita Tua ago zaawero iwo wewa.’ ");
INSERT INTO sue_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ema ge naso kaka ninamu amira mokara toyamewa sia, awa nukare nikare saore giro nimorekare otao wamera. Ata na nikare nusokare nana dubura ena sianiro pumuna nuai nusokare dowa, are nukare nikare iwo inowera awa. ");
INSERT INTO sue_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ge zo nimorekare ego sesena awa kotumuwo: Soumai meni ema tua nusora nuai awa nune dainiro nuai ine oko itia. Ge amira susu ego ewa. Eni meni ge naso niniro dipinora, da ago ine eni meni ge nisokare niniro dimamunora. Ota eni meni na iwo inora, da ago ine eni meni nikare iwo wamunora. ");
INSERT INTO sue_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nukare nu na iyetinua awa kaka gamu inowera, are da ago ine nimorekare wamunora. Nikare bua mai naso, are ago ine wamunora. ");
INSERT INTO sue_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na nusokare nana kaka osamu wamena, ota susu naso kaka tugata wamu wamena, awa nukare pasina amu nuamera. Ota zeme nukare pasina nusokare nogo nogo sero bezamunori? ");
INSERT INTO sue_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Zo nu na iwo inowia ami da ago ine Mama naso iwo inowia. ");
INSERT INTO sue_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na nusokare nana noise tani putoure ema meni wai ine tepo awa kaka wamu wamena, awa nukare pasina amu nuamera. Ata nukare tani putoure inowena awa giro na iwo inoise Mama naso da ago iwo inowera. ");
INSERT INTO sue_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ago wawera ge zo lo buku nusokarera gayai itewia awa me inowia. Ge awa ego ewa: ‘Nukare na tepo iwo wewa.’ ");
INSERT INTO sue_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ata Soremai nisokare Mamera nana itewia awa iyetana Mamera nana ena osero nikare sorepitinoise susu naso nimorekare kerenamunoya. Nu awa Ozana. Ge me saira mama numa awa. ");
INSERT INTO sue_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ota nikare be bua zaawena amira ana namore dai nowewa ami dai susu naso kerenamunowa. ");
INSERT INTO sue_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ama nukare nena mou-mau nimorekare wara nikare itazaita wero tuma diai nisokare besai azu, na ge ei awa bere-bere kerenitinona awa. ");
INSERT INTO sue_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nukare yere ibu soyamunora. Awa daba kota, be zo mamunoya be amire nukare ‘Anutura bua inowenakare’ asinoise nikare dara bebetenamunowa. ");
INSERT INTO sue_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nukare nato Mamere awa kaka giro baitamu inowera, are ago ine wamunora. ");
INSERT INTO sue_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ge tona ami me wai amire, ‘Yesu gita namorekai ago senua,’ ago sawise sero nikare bere-bere tugata inona. Na nikare gipamu sero bua zaawero noina be amire be naso iboi itinua, are na ge awa gita nimorekare kaka samu noisona. ");
INSERT INTO sue_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ata zeme meni awa na senu osena amira nana witamu sero inona, are ge awa sesena. Ata nisokare nana zo meni na ego kaka atata wamu inoya, ‘Ni nago bayamunosi?’ ");
INSERT INTO sue_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ge ago ine nimorekare sesena, are duba nai meni moka nisokare bera muro itia. ");
INSERT INTO sue_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na ge me sana niniu. Na ewesemuro witamunona, awa nikare kokopai itawise sero witamunona. Na kaka witamu wamunona, awa Soremai meni oko osamunoya. Ata na witiro iyetana osero nimorekare dai nuamunoya. ");
INSERT INTO sue_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Osero nena etorobara amira susu awa eramare kerenamunoya: pasinara susu, ata ewanana wero nuaira susu, ata pasinara ina tamai amira susu. Nu susu etorobara awa kerenai eraa meni gara me wamunoya. ");
INSERT INTO sue_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pasinara susu ego ine gipai gamunora: nukare na kaka tuma diamu inowera, are pasina nusokare dago itewia. ");
INSERT INTO sue_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ewanana wero nuaira susu ego ine gipai gamunora: na Mamera nana ewesemuro witana nikare na noko oko gamunowa. ");
INSERT INTO sue_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pasinara ina tamai amira susu ego ine gipai gamunora: zebu emira tua awa Anutura kotora ena duwaise sai itia. ");
INSERT INTO sue_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ge tugata wai naso dainiro dago itia, ata nikare zeme ninai ine tepo. ");
INSERT INTO sue_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ge me susure sai awa Ozana awa. Nune osero ge me dapikarago susure nimorekare gipamunoya. Ota ge awa kotumai nusora oko puro samunoya. Ge naneto Mamere samunonato awa niniro te nikare tugata wamunoya. Tani eure-taure ama kei awamunora awa dai bere-bere nimorekare kerenamunoya. ");
INSERT INTO sue_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Na ge sana Ozana meni niniro puro nimorekare kerenamunoya. Ago wai bowi naso kei awamunoya awa. ");
INSERT INTO sue_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mamera nena dapikarago awa nena naso, ami emo na nimorekare ego sesena awa, ‘Ozana meni nena naso puro nimorekare kerenamunoya.’ ");
INSERT INTO sue_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Be apunu-kaka itia awa tepo wai amire nikare na oko gamunowa. Noko be apunu-kaka tepo wai amire nikare na gamunowa.” ");
INSERT INTO sue_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yesu meni ago senu bua mai nuso nutopekare ge ina-sa wero ego sewa awa, “Nu ego toya, ‘Be apunu-kaka itia awa tepo wai amire nikare na oko gamunowa. Noko be apunu-kaka tepo wai amire nikare na gamunowa.’ Nu nogoro ago toi? Ota nu ge zo dai ego sesia awa, ‘Na Mamera nana witamunona.’ Ago sesia awa.” ");
INSERT INTO sue_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bua mai meni ago sero noko ego sewa awa, “Nu ego sesia, ‘Be apunu-kaka itia.’ Ago awa nogoro toi, nakai sirinonakai.” ");
INSERT INTO sue_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ago sero nu atata wamu sero wewa Yesu nu nutope giro ego senua awa, “Ge ego nimorekare sesena amira ina-sa inowita? ‘Be apunu-kaka itia awa tepo wai amire nikare na oko gamunowa. Noko be apunu-kaka tepo wai amire nikare na gamunowa.’ Ge amira susu sana gamu towita? ");
INSERT INTO sue_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na me memeka nimorekare tona. Nikare dire-buare inuawa ema na tuma kaka diamu ami yawa sara wamunora. Nikare duba naire nuawa duba nai nisokare meni kapetenai yawa sara wai nisokare nana kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Bama meni mai pamu inoma yaya tapinoise duba nitinowera. Ago inoma mai puro oreniro ‘mai pumena’ asero yawa sara inowera. Yaya tapinowera awa oko kotupitinowera. ");
INSERT INTO sue_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Da ago ine nikare zeme duba nitinowa. Ata na nikare noko gamunona be amire nikare yawa sara bamubake wamunowa. Yawa sara nisokare awa ema zo meni kapai tepo wai ine tepo. ");
INSERT INTO sue_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Are be amire nikare nena zo kau wero giro na oko atata wamunowa. Na me memeka sane. Nikare nena zo emo Mama begomo sawa nena awa potamunoya. Awa nera kota, nu na emo inoise potamunoya. ");
INSERT INTO sue_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Noisonakai amira ana tupise nikare zazo naso puro noise nena zo emo begomo kaka samu. Are yawa sara wai meni nisokare nana kei awero be muro itaise begomo seu. Begomo sawa potai pamunowa awa. ");
INSERT INTO sue_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ge nimorekare tugata wero tupewena awa ge bezai tugata inowena. Noma be zo mamunoya amire na ge bezai meni awa oko samunona. Be amire na Mamera susu poti damu namu ge bezero kota, me kereniro nimorekare samunona. ");
INSERT INTO sue_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Be amire nikare zazo naso puro noise Mama begomo samunowa. Na ego oko tona, ‘Nane nikare soremuro Mama begomo samunona.’ Awa oko tona. Awa nera kota, Mama meni nikare ara tapinowia. ");
INSERT INTO sue_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Na Mamera nana ena osena ge awa nikare niniwa me wenu na ara tapinowewa. Are Mama meni da ago ine nikare ara tapinowia. ");
INSERT INTO sue_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na Mama doro zebura osena, are na zebu doro noko Mamera nana wititinona.” ");
INSERT INTO sue_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ago senu bua mai nuso meni ego sewa awa, “Ni zeme ge bezai doro damu-damuke kereniro tosa awa. ");
INSERT INTO sue_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Are nimore ego gosinonakare: ni nitope nena dapikarago giro tepo inowesa. Nakare ni atata wamu kotupitinuawenakare ni nitope gosinowesa, ami emo ni Anutura nana ena osesa awa genakare me inoya.” ");
INSERT INTO sue_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ago sewa Yesu meni ego senua awa, “Nikare zeme gewa me inoita? ");
INSERT INTO sue_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Be zo itia awa eya mai amire na doro bozero nata nisokare sero baro tepo wamunowa. Ago wero na duawa na imata nuamunona. Ata na imata oko nuamunona. Mama meni namore dai nowia, are imata oko nuamunona. ");
INSERT INTO sue_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nikare azu doro oreniro nuawise sero ge ei awa nimorekare sesena. Nikare zebura yayare duba naire nuamunowa. Ata nane zebura nena dire-bere awa puro osero patitinona, are nikare putoure noiwo.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu nu ge awa sero tepo wero iri utura niro begomo toise ego senua awa, “Mama, be zora awinoya. Na Mai niso. Na zazo niso de ike nana bamu waise sero gita nine zazo naso de ike nasa bamu waise tona. ");
INSERT INTO sue_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ni ema eni namore potisa. Potiro na nuai me ewanana awa numorekare potanise sero na zebu serora ema bama amira mama bamubake potisa. ");
INSERT INTO sue_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nuai me ewanana amira susu ego itia: Ni Anutu me daimata. Ema iyetisa awa Yesu Kristo awa. Ema bama meni namorege gara me wai nukare nuai me ewanana pumamunora. ");
INSERT INTO sue_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Bua ge namore sesa awa wero tupie pesunitinona. Ago inoise zazo niso de ike nitana. ");
INSERT INTO sue_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Mama, zebu kaka kei awamure na nimore dai utu zasimai nasore noisona, da awa noko potiyo na puro nuane. ");
INSERT INTO sue_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Erama dapikarago amira nana ena ema eni sianiro namore potisa naso wewa. Are na susu niso numorekare kerenisena. Dubu niso asai noiwa awa namore potisa nukare ge niso niniro puro poti dube niro nowera. ");
INSERT INTO sue_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nukare zeme nena naso dapikarago niso nana ena gege tupewia awa gosinowera. ");
INSERT INTO sue_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ni ge namore potisa awa sena niniro pumuwa awa. Ago inoise niso nana ena osena awa giro me asewa awa, are nine bua ge namore sesa awa da ago niniwa me wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na nukare emo nimore begomo tona awa. Ema na tuma kaka diamu inowera nukare ami emo oko nimore begomo tona. Dubu namore potisa ami emo isa tona. Nera kota, nukare awa dubu niso me awa. ");
INSERT INTO sue_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ema naso dapikarago awa niso awa. Ota ema niso dapikarago awa naso awa. Are nukare zazo naso de ike nitinora. ");
INSERT INTO sue_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nane niso nana muro zebura oko itamunona. Ata nukare meni awa zebura itise nuamunora. O Mama saramai, nage duba da wero nowenage, da ago ine nukare duba da wero nuarise sero ni zazo niso namore potisa amira putou meni nukare dia weyo. ");
INSERT INTO sue_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na numorekare dai noise zazo nisora putou meni nukare dia inowena. Ni zazo awa namore potisa. Na nukare dia wero baititana, are zo meni kaka tara awamu. Ota ge gayai zo itia awa me waise daimata meni tara awero sisamunoya. Nu tara awaira gegenai. ");
INSERT INTO sue_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yawa sara wai naso meni duba nusokare topetaise sero na zebura itise niso nana mamu inoise ge ewa tona. ");
INSERT INTO sue_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na ge niso potawena puro nuawera zebura ema meni nukare iwo inowera. Nuai naso awa zebura ema amira nuai ine oko aewa. Da ago ine nuai nusokare awa zebura ema amira nuai ine oko aewa. Are zebura ema meni nukare iwo inowera. ");
INSERT INTO sue_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ni bua mai naso awa zebu emira ena soero pumasise kota, Satan meni nukare waya wai azu, ni nukare soremasise begomo tona ewa. ");
INSERT INTO sue_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nuai naso awa zebura ema amira nuai ine oko aewa. Da ago ine nuai nusokare awa zebura ema amira nuai ine oko aewa. ");
INSERT INTO sue_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ge niso me meni duba nusokare ziai dopero itai nukare saramuro gegenai niso warise. Ge niso awa ge me susure awa. ");
INSERT INTO sue_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nine na zebura ena bua wanise sesa, are da ago ine nane nukare zebura ena bua warise sena awa. ");
INSERT INTO sue_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ge me meni duba nusokare ziai zewai wai nuarise na nuai naso nukare emo wana nisora potitinona ewa. ");
INSERT INTO sue_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ota na nukare emo gege oko begomo tona. Ge tugata wara niniro na tuma diamunora nukare emo dai begomo tona. ");
INSERT INTO sue_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nukare duba da wero nuarise nimore begomo tona. O Mama, ni namore itewesa na da ago nimore itewena, da ago ine nukare namorege dai itarise. Ago wara ema na tuma kaka diamu inowera ami nine na iyetisa osena awa giro me asare. ");
INSERT INTO sue_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nage duba da wero nowenage, da ago ine nukare duba da wero nuarise sero ni putou namore potisa da awa numorekare potitinona. ");
INSERT INTO sue_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na numorekare dai itana ni da ago namore dai itasa nukare duba meni puniro daimata wero nuare. Ago wero nuara ema na tuma kaka diamu inowera ami na iyetisa osena awa garise. Agoro nine na duba meni punitinoise nukare dai punitinowesa awa giro baitarise. ");
INSERT INTO sue_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","O Mama, ema dubu namore potisa nukare awa na nuamunona da amira nuarise tona. Ago wero zebura siwako kaka kei awamure nine na ara tapinoise utura zasimai namore potisa zasimai awa namorege dai noise garise tona. ");
INSERT INTO sue_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Mama, ni saramaira mama. Ema na tuma kaka diamu inowera ami ni oko giro baititinowera. Nane meni awa ni giro baititinowena. Ota dubu naso meni nine na iyetisa osena awa giro baititinowera. ");
INSERT INTO sue_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ara tamai niso naso nana itewia da ami nusokare nana itai na numorekare dai nuamu sero oziga ge niso numorekare kerenitana. Ago gege kerenitinoise nuamunona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu nu begomora ge awa senu tepo wenu eriro bua mai nuso pumuro nate ena osero ou Kidoron semuro zebu zora ni bua itisonua amira bamuwa. ");
INSERT INTO sue_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesu bua mai nusore nukare be eyaya ago aunitinoisowa, are Yudas kerenai ema ami ni bua awa nu gai awa. ");
INSERT INTO sue_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Are Yesu bua mai nusore ago noiwa Yudas kerenai ema ami pris babezinomare Farisayore amira polis eni ata soldia eni awa puro gita wenu bana izimuro lam gaero gi ami puro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu meni nena dapikarago numore wamu inoiwa awa giro eriro gita baro nukare tamuro atata wero ego senua awa, “Nikare aware kau inowi?” ");
INSERT INTO sue_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ago senu nukare ego sewa awa, “Nasaretera ema zo zazo nuso Yesu awa kau inonakare.” Ago sewa nu ego senua awa, “Na ewa.” Ago senua awa. Yudas kerenai ema awa soldiare dai dopero itinua awa. ");
INSERT INTO sue_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Are Yesu meni, “Na ewa,” ago senu nukare azu atune baro duuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ago wewa noko atata wero ego senua awa, “Nikare aware kau inowi?” Ago senu nukare ego sewa awa, “Yesu Nasaretera ema.” ");
INSERT INTO sue_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ago sewa Yesu meni numorekare ego senua awa, “Na sesena awa. Na ewa. Nikare na kau inowa, are dubu naso awa dou bayare.” ");
INSERT INTO sue_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nu ge gita senua awa me waise sero bua mai nuso duarise senua. Ge gita ego senua awa, “Namore potisa nukare dia wetena zo da kaka tara awamu awa.” ");
INSERT INTO sue_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Are Simon Petoro nu kasiwa egira puro noinua awa zinu kisimunu pris bamura soumai zo amira dana wana mera awa kesenua. Mai awa zazo nuso Maliko. ");
INSERT INTO sue_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ago wenu Yesu meni Petorore ego senua awa, “Kasiwa niso egira poti toyae. Yaya ei awa Mama naso meni namore potitinoya, awa azu duanise inosita?” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ago senu soldiara dia wai meni senu soldia ata Yudara polis ami Yesu puro wana beniwa awa. ");
INSERT INTO sue_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Beniro puro gita bamu Anasira nana sora niwa awa. Zepa amire ema zo zazo nuso Kayafa ami pris bamu wero noisonua. Nune Anasira mai bama diri atiro noisonua. ");
INSERT INTO sue_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa nune gita Yuda emare ge ego senua awa, “Ema nakai dapikarago waya wero tepo wai azu, nu daimata ami nakai emo betaise sai itia.” Gita ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Polis meni Yesu poti Anasira nana niwa Simon Petoroto otao nuso zore nuto Yesu puro bamuwa awa ama ganero bamuwato awa. Petorora otao* awa pris bamu meni gosinoinsonua, are Yesu ama ganero toi goma mokara ninua awa. ");
INSERT INTO sue_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petoro meni awa goma atune dopenua awa. Ago wenu otao nuso meni awa pris bamura nana sora noisonua, are osero goma be dia wai mai bama diri zo amire senu goma be piaka ninu Petoro toi mokara ninua awa. ");
INSERT INTO sue_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Petoro toinu mai bama diri goma be dia wai ami Petoro giro ego senua awa, “Ema omira bua mai zo ni awani, tanita?” Ago senu Petoro meni ego senua awa, “Na tepo.” ");
INSERT INTO sue_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Pris bamura soumaire soldiare nukare zazama wenu giro ni wero awinoiwa Petoro nu da ago bamu nusokare nana soe niro ni awenua awa. ");
INSERT INTO sue_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pris bamu meni Yesu bua mai pumunua o ge tugata inoisonua amire atata wenua. ");
INSERT INTO sue_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Atata wenu Yesu meni ina ego senua awa, “Na ge damu ena gege towena. Yuda ema aunitinowera — yere ibura enata ibu bamura ena — amira ena na ge sero tugata wise gipise awinowena. Na bezero ge oko towena. ");
INSERT INTO sue_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Are ni nogoro na atata inosi? Ge sawena ninitinowera nukare awa atata wasa ge towena awa sara ninase.” ");
INSERT INTO sue_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ago senu dia ema dopero itiwa amira nana zo meni Yesu opewe dero ego senua awa, “Ni nogoro ge ago ine pris bamure tosi?” ");
INSERT INTO sue_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ago senu Yesu meni ina ego senua awa, “Ge waya sesena sia tosa amira susu se gare. Ota na ge kokopai tona amira nogoro na doinosi?” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anasi meni senu Yesu beniro puro bamu pris bamu zo zazo nuso Kayafa amira nana niwa awa. ");
INSERT INTO sue_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petoro nu ni awinoise itinu nukare nu noko atata wero ego sewa awa, “Bua mai nusora dubu amira nana zo ni awani, tanita?” Ago sewa nu begi wero ego senua awa, “Na tepo.” ");
INSERT INTO sue_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ago senu pris bamura soumai zo, Petoro meni dana kesenua amira dikai zo, ami ego senua awa, “Ina ni ni buara ena Yesure dai dopero itesa geni, tanita?” ");
INSERT INTO sue_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ago senu Petoro meni noko begi wenu amire kokara ge senua awa. ");
INSERT INTO sue_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pina atinu nukare Yesu Kayafara nana sora ena puro osero bamu Roma ema zo nukare dia inoisonua amira nana niwa awa. Yuda ema nukare Betai Daininua amira bona namu sero inoiwa, are nukare pura sisai azu, nukare Pilatora nana sora kaka toyamu wewa. Awa nera kota, Yuda ema meni ego toise noisowa awa, “Duba nasokai bemitire wai azu, nakai ema Yudakora nana oko toyanekai.” ");
INSERT INTO sue_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ago toisowa, are nukare dura dopewa Pilato meni kei damu niro nukare atata wero ego senua awa, “Ema ei awa pasina nera puro tupewi?” ");
INSERT INTO sue_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ago senu nukare ego sewa awa, “Nu pasina kaka wamu nuamia, awa nakare niso nana oko puro mamenakare.” ");
INSERT INTO sue_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ago sewa Pilato meni ego senua awa, “Lo ge nisokare itia amira te seu tepo wae.” Ago senu nukare ego sewa awa, “Nakare mai betarise sai tepo wai awa nasokare nana gazai itia. Nera kota, lo nisokare Roma emara ami gazinoya.* Ota nine sasa te wamunoya.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yuda ema ago wewa Yesu nu nutope gita, “Na ni pasinaira dara betamunona,” ago senua amira ge me wenua. ");
INSERT INTO sue_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato meni so mokara baro Yesu zawa senu bamunu ego senua awa, “Ni Yuda emara ema tua ni?” ");
INSERT INTO sue_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ago senu Yesu meni ina ego senua awa, “Ge awa duba nisora tosita eni meni oziga naso nimore sesera giro tosi?” ");
INSERT INTO sue_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ago senu Pilato meni ego senua awa, “Na Yuda ema oko aewa. Ema mamana niso ata pris babezinoma ami ni naso nana potitinora. Ni ne wetesi?” ");
INSERT INTO sue_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ago senu Yesu meni ego senua awa, “Na zebura ena ema tua oko wero nowena. Na zebura ena ema tua inoise nuamena, awa ema dubu naso meni gi ami puro na soremara Yuda ema na oko pamera. Tua wero nuaira bua naso awa zebura oko itia.” ");
INSERT INTO sue_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ago senu Pilato meni ego senua awa, “Agoro ni ema tua zo ni?” Ago senu Yesu meni ego senua awa, “Awa, are tosa awa. Na ema tua zo. Na ge me susure kerenamu sero osero zebura ena kei awena awa. Ge me yaba inowera ami ge naso ninitinowera.” ");
INSERT INTO sue_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ago senu Pilato meni ina ego senua awa, “Ge me awa neni?” Ago sero kei damu niro Yuda emare ego senua awa, “Na ema emira pasina tamamu sero kau inomite zo kaka tamamu wetena. ");
INSERT INTO sue_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ota tani nisokare zo itia. Betai Daininua amira pura nisokarera ena sawewa benai ema zo awa-diawena tepo susawewia. Are pura emire ninawa na Yuda emara ema tua nisokare awa-diana nuaise towita?” ");
INSERT INTO sue_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ago senu nukare arero sewa awa, “Tepo awa. Nu kota, Barabas awa awa-diasa mae.” Ago sewa awa. Barabas nu mai dero bewana wai ema. ");
INSERT INTO sue_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato meni senu soldia nukare Yesu asi dirinare meni dewa. ");
INSERT INTO sue_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ago wero nu isimamu sero asi dirinare puro bubuna wero giti nusora wosuniwa awa. Ago wero tama woi izasewai zo dai wosuniwa awa. ");
INSERT INTO sue_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ago wero bamu nuso nana zorage niro sowene doinoise ego sewa awa, “Waiko koko, Yuda emara ema tua.” ");
INSERT INTO sue_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato meni noko kei damu niro Yuda emare ego senua wa, “Giu. Na nu puro nisokare nana tupena. Na pasina nuso tamamu sero kau inomite zo kaka tamamu wetena.” ");
INSERT INTO sue_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ago senu Yesu nu asi dirinare bubuna wai amire tama woi izasewaire dai osero dopenu Pilato meni gipero ego senua awa, “Ema ewa giu.” ");
INSERT INTO sue_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ago senu pris babezinomare soldia nusokarere ami giro arero ego sewa awa, “Ni pasinaira witaise, ni pasinaira witaise.” Ago sewa Pilato meni be nusokarera pumuro ego senua awa, “Na pasina nuso kau inona. Nu pasina tepo. Are nikakare nitopekare puro ni pasinaira deu.” ");
INSERT INTO sue_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ago senu Yuda ema meni ego sewa awa, “Nu nutope, ‘Na Anutura mai,’ asinowia, are ema ago ine awa betarise lo ge nasokare amira sai itia, are betaise.” ");
INSERT INTO sue_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ago sewa Pilato meni ge awa niniro azu bamubake wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ago wero Yesu noko uzumuro so mokara puro baro atata wero senua awa, ‘Ni nana kei awesi?” Ago senu Yesu meni ina kaka samu donua. ");
INSERT INTO sue_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ago wenu Pilato meni ego senua awa, “Ni ge namore kaka samu inosa, atonua. Nane sana nuamunosita ni pasinaira betamunosi, amira putou namore potai, awa ni kaka gamu inosita?” ");
INSERT INTO sue_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ago senu Yesu meni ina ego senua awa, “Anutu meni putou awa nimore kaka potamu wamia, awa ni na betaira potai ine te oko wamia. Are na niso nana wanera potia amira pasina meni pasina niso dainitinoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ago senu Pilato meni ge awa niniro kei damu niro Yesu awa-diro duamu senu Yuda ema nukare arero ego sewa awa, “Ni ema nu awa awa-diro duaira samunosa, awa ni Romara ema tua Sisa amira otao noko oko nuamunosa. Zo nu nutope ema tua asamunoya ami Romara ema tua Sisa awa dainamunoya.” ");
INSERT INTO sue_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ago sewa Pilato meni ge awa niniro giro senu Yesu puro kei damu niwa Pilato meni ge sai tepo wai masi nusora arumuro itinua awa. Masi awa omata meni nabero wai. Masi amira zazo Yuda ema meni Gabata asinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Are Yuda ema pura itamu sero nena sia inoiwa waiko soe dopenu Pilato meni masi nusora itise Yuda emare ego senua awa, “Giu. Ema tua nisokare ewa.” ");
INSERT INTO sue_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ago senu nukare arero ego sewa awa, “Nu tepo waise. Nu tepo waise. Ni pasinaira witaise.” Ago sewa Pilato meni ego senua awa, “Ema tua nisokare sana ni pasinaira betaise towita?” Ago senu pris babezinoma meni ina ego sewa awa, “Nakare ema tua nasokare zo tepo. Roma emara ema tua Sisa ami gege inoya.” ");
INSERT INTO sue_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ago sewa giro Pilato meni ge nusokare niniro Yesu ni pasinaira betaise sero poti wana nusokarera ninua awa. ");
INSERT INTO sue_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Are soldia meni Yesu puro ni pasinai potiwa dimunu zebu zo zazo nuso Giti Kopira Wetu, ota Yuda gera Goligata, amira puro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Puro baro ni pasinaira dewa awa. Dero pasina mai eto ni pasinai etora dero zo enibara zo enibara Yesu soe ago urewa dopewa awa. ");
INSERT INTO sue_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato meni senu Yesura ni pasinaira owe ego ine potiwa awa, “Yesu Nasarete natara. Nu Yuda emara ema tua.” ");
INSERT INTO sue_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesu dewa zebu awa nata itinua amira zorage. Are Yuda ema dainiro meni izima-sauma awinoise owe awa azimuwa. Owe awa Yuda gera ata Roma gera ata Grik gera gaewa awa. ");
INSERT INTO sue_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Are Yuda emara pris babezinoma meni Pilatore ego sewa awa, “Ni ego gaetesa awa te oko inoya, ‘Yuda emara ema tua.’ Awa doro ego ine gaeyo, ‘Nu nutope na Yuda emara ema tua asinowia.’ Ago gaeyo.” ");
INSERT INTO sue_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ago sewa Pilato meni ego senua awa, “Gaetena ami itaise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldia nukare Yesu dero tama woi nuso tame awa zoeto-zoeto, are kanowero pumuwa awa. Ata tama woi tura awa be dara tairo gayai tepo. Ike ena gaero osero bayai awa. ");
INSERT INTO sue_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Are nukare ego sewa awa, “Awa kapanakai waya wamunoya. Are ozina laki wanakai ema zora nana kei awai giro ami paise.” Ago sero wewa awa. Ago wewa amire ge gayai zo ego itia ami me wenua, Nukare tama woi naso tame awa kanowewa. Tama woi naso emo ozina laki wewa. Ge gayai ago itinua, are soldia meni ago wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesura ni pasinai susura ena erama ego ami dopewa: mia nuso, miera zawa, Maria Kliopara ara, Maria nata nuso Madala. ");
INSERT INTO sue_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Are Yesu nu mia nuso ata bua mai nuso kokopai nuto dopero itiwato giro mia nusore ego senua awa, “Mia, mai niso awa.” ");
INSERT INTO sue_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ago sero bua mai nusore ego senua awa, “Mia niso awa.” Ago senu giro be amira ana nu Yesura mia uzumunu nuso nana witinu dia inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Are Yesu nu bua nuso tepo wenu giro ge gayai zo itinua awa me waise sero ego senua awa, “Na ou uza inoya.” ");
INSERT INTO sue_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ago senu nukare ewara somisomi zo puro ou wain dokaka akou zora itinua amira patiro utura gaero be nusora potiwa ninua awa. ");
INSERT INTO sue_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ou wain niro ego senua awa, “Bua wero pesunena.” Ago sero tuma gosumunu ozana nuso tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yuda ema nukare pura nusokarera nena sia inoise giro ego sewa awa, “Auma Betai Daininua amira pura bamubake, are ema ni pasinaira dai awa oko itare.” Ago sero Pilatore ego sewa awa, “Nukare eya betarise sero ni ge sasa soldia meni baro te nusokare dara toumara eya betara woi nusokare ni pasinaira ena parise.” Ago sewa Pilato meni ge nusokare nininua awa. ");
INSERT INTO sue_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Are soldia nukare pasina ema eto Yesure dai dewa amira zora te wetu dewa toumunu zora da ago dewa toumunu awewa awa. ");
INSERT INTO sue_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ago wero Yesura nana baro nu betero itinu giro wetu kaka dai toumamu dowa awa. ");
INSERT INTO sue_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ota soldia zo baro karao meni Yesu zezegira ena gaenu urukumunu orarare oure osenua awa. ");
INSERT INTO sue_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nane nena awa giti moka naso meni gina. Are na sero kerenitinona me inoya awa. Na gosinona, ge awa me awa. Nikare dai gawa me waise sero ge me kerenitinona awa. ");
INSERT INTO sue_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ge gayai zo ego itia awa me waise sero nena awa kei awenua, Nukare wetu nuso zo da di oko dara toumamunoya. ");
INSERT INTO sue_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ota ge gayai zo ego itia, Nukare nu gaewa urukumunua amira nana giti moka potiro gamunora. Ge gayai eto ago iterato awa. ");
INSERT INTO sue_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yosefe Arimatia natara nu Yesura mai zo wero noisonua, ata nu Yuda ema azu wero tuma diai nuso kaka kerenamu bezero puro noisonua. Nune ami Pilato nana baro Yesura woi ni pasinaira ena dusunamu sero atata wenua. Ago wenu Pilato meni nininu baro dusuninua awa. ");
INSERT INTO sue_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo nu gita pire Yesura nana kei awenua ami ni mu zamare mou nuso 34 kilogram ago puro bamuro Yosefe soremunua awa. ");
INSERT INTO sue_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ago wero Yesura woi ni mu zamare meni gutero mo kapawai meni ewewato awa. Yuda ema nukare erama betasara ago inoisowa awa. ");
INSERT INTO sue_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu dewa zebu amira agewara ni bua zo itinua, amira omata so zo bi ditira asero seka wamai itinua. Gita ema zora woi ago kaka potamu. ");
INSERT INTO sue_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Are Yuda emara pura amira nena sia waira be itinua, noko bi diti awa zorage itinu giro nuto Yesura woi ago potiwato awa. ");
INSERT INTO sue_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande pina kaka atiro baitamu Maria nata nuso Madala ami bi ditira bamunua awa. Baro ego ginua awa. Omata bi ditira so be gazai awa dainiro enibara baro itinua. ");
INSERT INTO sue_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ago giro sumuro bamuro Simon Petoroto Yesura bua mai kokopaire amira nana kei awero ego senua awa, “Nukare Tuara woi puro baera. Awa nago poteri?” ");
INSERT INTO sue_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ago senu giro Petoroto otao nuso zore bamu bi ditira niwato awa. ");
INSERT INTO sue_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ebete sumuro susawiseto otao ami Petoro dainiro gita baro bi ditira kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kei awero omata sora dupuniro mo woi nuso ewewato awa itinu ginua. Ata nu kaka toyamu. ");
INSERT INTO sue_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ago inoinu Simon Petoro ama kei awero omata sora toiro mo ginua. ");
INSERT INTO sue_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Mo zo gitine ewewato awa dai itinu ginua awa. Mo awa mo enire dai oko itinua. Nu imata enibara bozero baitai itinua. ");
INSERT INTO sue_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Are Petoro meni awa gosinoinu otao nuso gita baro omata sora bera dopenua ami ama toiro ginu me wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nuto Yesu betero seka wero eramunoya amira ge gayai itinua awa oko giro baitiwato. ");
INSERT INTO sue_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ago weroto nuto noko ewesemuro bamu nate niwato awa. ");
INSERT INTO sue_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria nu bi ditira so be zorage amira dopero di senua awa. Di toise baro omata sora bera dupuniro anegi wenua. ");
INSERT INTO sue_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Anegi wero angelo eto tama woi kapawaire Yesura zarara itiwato ginua. Zo nu Yesura giti itinua amira zarara, zo Yesura te itinua amira zarara, ago wero itiwato ginua awa. ");
INSERT INTO sue_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ginu nuto ego sewato awa, “Ni nogoro di tosi?” Ago sewato nu ego senua awa, “Tua nasora woi puro nago baerata kau inona.” ");
INSERT INTO sue_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ago sero kapeteniro Yesu dopero itinu ginua awa. Giro Yesura giti moka kaka giro baitamu wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ago wenu Yesu meni atata wero ego senua awa, “Ni nogoro di tosi? Ni are kau inosi?” Ago senu Maria nu ni buara mama meni dopero itinuta asero ego senua awa, “Nine Yesura woi puro baro agewa zora potesita? Se giro baro pumane.” ");
INSERT INTO sue_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ago senu Yesu meni ina ego senua awa, “Maria.” Ago senu nu zuzumeniro Yuda gera “Rabonai” asenua. (Ge nasokaira, “Gipai Ema.”) ");
INSERT INTO sue_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ago senu Yesu meni ego senua awa, “Na oko ziase. Na Mamera nana kaka witamu awa. Ni baro bua mai nasore ego se: Mama naso awa Mama nisokare. Anutu naso awa Anutu nisokare. Are amira nana witamunona. Ago se gare.” ");
INSERT INTO sue_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ago senu Maria nata nuso Madala ami ewesemuro baro Yesura bua mai amire ego senua awa, “Na Tua gena. Nu namore ge awa sesia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sande pi zinu bua mai meni Yuda ema azu wero auniro so be dewa gamunu itiwa Yesu meni nusokare nana soe ena kei awero dopero ego senua awa, “Azu doro kokopai itiwo.” ");
INSERT INTO sue_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ago sero boino zara wana etora amire zezegira amire gipenua. Ago wenu bua mai meni Tua nusokare giro yawa sara wewa awa. ");
INSERT INTO sue_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ago wewa nu noko numorekare ego senua awa, “Azu doro kokopai itiwo. Mama meni na iyetinua, da ago ine nane nikare iyetitinona.” ");
INSERT INTO sue_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ago sero ozana nuso pise nusokare nana niro ego senua awa, “Ozana pumuu. ");
INSERT INTO sue_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nikare emara pasina disawa tepo wamunoya. Ota nikare kaka disamu wawa itamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Otao nusokare Tomas, zazo nuso zo Didimo, nu awa agewa zora noinu Yesu meni mai enira nana kei awenua. ");
INSERT INTO sue_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Are otao mai eni meni oziga ge numore ego sewa awa, “Nakare Tua genakare.” Ago sewa nu ego senua awa, “Na natope giti moka naso me meni wanera boino zara giro, o wana sisino naso meni boino zara gaero giro, o zezegi nuso gaitara amira sora wana naso meni sineniro giro awamunona, awa ge nisokare me asamunona.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Waiko be 8 tepo wenu amire bua mai nuso eni ata Tomas dai so mokara toiro so be dapikarago dewa gamunu itiwa Yesu meni nusokare nana soe ena noko kei awero dopero ego senua awa, “Azu doro kokopai itiwo.” ");
INSERT INTO sue_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ago sero Tomasre ego senua awa, “Ni wana sisino niso meni wana naso ziro gi. Wana niso sineniro zezegi naso ziro gi. Ago wero duba eto noko oko we. Na seka nona awa gasa me wae.” ");
INSERT INTO sue_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ago senu Tomas meni ego senua awa, “Ni Tua naso. Ni Anutu naso.” ");
INSERT INTO sue_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ago senu Yesu meni ego senua awa, “Ni na gosinosa, are ni na tuma didinosa. Nukare na kaka gamu inoise na tuma diamunora nukare ami dai yawa sara wamunora.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Tani eni dainiro Yesu meni bua mai nusora nana giti mokara ena wenua awa na buku emira kaka gaero tepo wamu. ");
INSERT INTO sue_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ota ge gainona amira susu nogoro kota, ego emira awa: Nikare ge ei awa azimuro ninitinoise Yesu nu Soyai Ema Kristo, Anutura Mai, amira ge awa gawa me waise, o nu tuma didinoise zazo nuso emo inoise nuai me ewanana tamawise sero ge awa gainona. ");
INSERT INTO sue_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesura bua mai eni Taibirias* ou ubura noiwa nu nusokare nana kei awenua. Bua mai dubu ego amira nana kei awenua: ");
INSERT INTO sue_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petoro, Tomas zazo nuso zo Didimo, Nataniel Galilaya zebura Kena nata itisonua amira, amire Zebedira mai eto, amire zo eto dai. Ema ago ami poti dara niro itiwa ");
INSERT INTO sue_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petoro meni enire ego senua awa, “Na wo pumamu susawena.” Ago senu nukare ego sewa awa, “Nakare nimore dai bayanekai.” Ago sero wara witiro bamuwa awa. Susawise pi amire wo kaka pumamu wewa. ");
INSERT INTO sue_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Are ou ubura noiwa pina atitinoinu Yesu meni kora dopenua awa. Dopenu nukare benau nuso oko giro baitiwa. ");
INSERT INTO sue_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ago wewa Yesu meni nukare atata wero ego senua awa, “Mai awiso, wo nisokare zo itita?” Ago atata wenu nukare ego sewa awa, “Tepo.” ");
INSERT INTO sue_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ago sewa nu ego senua awa, “Wa wana mera ana mona potiwo osai wo ikai zumawe.” Ago senu mona potiwa osenu wo dainiro-bake ikewa awa. Ago wewa zumu wara namu kaputiwa awa. ");
INSERT INTO sue_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Are Yesura bua mai kokopai meni Petorore ego senua awa, “Awa Tua awa.” Ago senu Simon Petoro nu mo gege awero noinua, are nu “Tua noya owa,” awa niniro tama woi nuso tame awa wosuniro ewara dagimunua awa. ");
INSERT INTO sue_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nukare kora duku bera asike noiwa, are mai eni meni wa dawinoise mona wore zumuro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ago wero ete witiro nena ego ine giwa awa. Niao mokara wore mare sasinoise itinua. ");
INSERT INTO sue_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Itinu nukare witiro bamuwa Yesu meni ego senua awa, “Wo pumewa amira eni puro muu.” ");
INSERT INTO sue_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ago senu Simon Petoro meni wara witiro mona zumu ete ninua awa. Mona mokara wo babezinoma 153 ago itiwa, ata mona oko kapenua. ");
INSERT INTO sue_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Are Yesu meni numorekare ego senua awa, “Muu, nena nawe.” Ago senu bua mai nuso meni “Ni aweni?” ago atata wamu sero giwa mou wenu giro dowa. Nera kota, nu Tua awa, awa emoko giwa kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Are Yesu meni wo ma bona wero numorekare potinua awa. ");
INSERT INTO sue_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Are Yesu nu betaira ena seka wero eriro bua mai nusora nana kei awenu be etorobara wenua awa. ");
INSERT INTO sue_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nena niwa amire Yesu meni Simon Petoro atata wero ego senua awa, “Simon Yohanera mai, otao mamai niso nukare na ara tapinowera, awa nine nukare dainitinoise na ara bamu tapinowesa, awa me ni?” Ago senu Petoro meni ina ego senua awa, “Tua, nage otao wero nowenage, awa gosinosa.” Ago senu Yesu meni ego senua awa, “Ni lama dubu naso awa uninoise noiyo.” ");
INSERT INTO sue_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ago sero noko atata wero ego senua awa, “Simon Yohanera mai, ni me na ara tapinowesita?” Ago senu Petoro meni ego senua awa, “Tua, nage otao wero nowenage, awa gosinosa.” Ago senu Yesu meni ego senua awa, “Ni lama dubu nasora dia wero noiyo.” ");
INSERT INTO sue_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ago sero noko atata wero ego senua awa, “Simon Yohanera mia, nage otao wero nowenage, awa me ni?” Tairo nuaira atata wenu be etorobara wenu Petoro nu pumunu nuso nana mou wenu giro duba nitinoise ego senua awa, “Tua, ni nena bamubamu giro tepo inowesa. Nage otao wero nowenage awa gosinosa awa.” Ago senu Yesu meni ego senua awa, “Ni lama dubu naso uninoise noiyo. ");
INSERT INTO sue_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Na me memeka sane. Ni mai seka noise nitope ipu sapi diai niso diro ebata nago nago bayamu susawewesa. Ata noma zai wero wana niso suamasa ema zo meni ipu sapi diai niso diro masi oko bayamu samunosa amira ni puro bayamunoya.” ");
INSERT INTO sue_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu meni ago toise Petorora betai amira ge awa kereninua. Betai nuso meni Anutura zazo de ike namu inoinua awa senua awa. Ge ago sero numore ego senua awa, “Mu, na ama ganase.” ");
INSERT INTO sue_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Are Petoro meni zuzumeniro Yesura bua mai kokopai nuso nana atune susaunu ginua. Mai awa gita Betai Daininua amira bona ninoiwa amire Yesu nana zorage baro ge dane potiro atata wero ego senua awa, “Tua, ai meni ni kerenamunoi?” ");
INSERT INTO sue_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mai ago senua ami ama susaunu giro Petoro meni Yesu atata wero ego senua awa, “Tua, mai ei awa gire?” ");
INSERT INTO sue_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ago atata wenu Yesu meni ego senua awa, “Nu dago nuai na ewesemuro mamu samunona, awa nena awa nena niso oko aewa. Ni na ama gane.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Are ge ninai eni meni ama namore ge bisi ego sewa awa, “Mai awa nu oko betamunoya.” Ago toisowa awa. Ata Yesu meni namore ego oko senua, “Nu oko betamunoya.” Ge ego gege senua awa, “Nu dago nuai na ewesemuro mamu samunona, awa nena awa nena niso oko aewa.” ");
INSERT INTO sue_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na nena awa dapikarago giro baitina ami kereniro ge ei awa gaetena. Are nikare namore ego gosinowewa, ge naso me bamubake. ");
INSERT INTO sue_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ota Yesu meni tani eni-kani inoisonua awa. Ota ema meni tani Yesu inoisonua awa da da bukura gayamera, awa buku meni zebu sero topetiro tepo wami, tanita. ");
INSERT INTO sue_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Teofilo, na gita ge gaena, awa bua dapikarago Yesu meni inoisonua, o ge tugata inoisonua amira ge uge awa gita buku zora gaena awa. ");
INSERT INTO sue_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Yesu bua nuso zaawero inoe donu Anutu meni senu utura witinua amira uge gaero pesunina awa. Yesu kaka witamure Ozana meni nu soremunu nu aposolo dubu gita awininu noisowa numorekare bua ge potinua awa. ");
INSERT INTO sue_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nu yaya tapinomite betero noko seka wero eriro aposolo dubura nana waiko be 40 ago kei awero bezero awinoise Anutu imata Tua wero nuamunoya amira ge tugata-magata wero nu erinua amira susu dai kereniro baitinu giwa awa. ");
INSERT INTO sue_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nu numorekare dai noise potai ge ego potinua awa, “Nikare Yerusalem nata eya oko duawe. Mama meni Ozana potamu senua, awa dia inoise itiwo. Na amira gita sesena goisewa. ");
INSERT INTO sue_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Dia itawise tona, nera kota, Yohane meni ema bama ou gutinoisonua, ata be pei-kaka gege tepo wai amire Anutu meni Ozana nimorekare potamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aposolo nukare Yesure dai auniro itise nu atata wero ego sewa awa, “Tua, ni be emire Isreli ema dago poti dara nasa nakare natopekare zebu nasokarera mama wero nuamunonikareta?” ");
INSERT INTO sue_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ago sewa Yesu meni ina ego senua awa, “Mama nu putou nuso meni be iboire apunure potinu itewia, awa nikare ninai ine oko itia. ");
INSERT INTO sue_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ata Ozana meni osero nisokare nana toyai amire putou pumamunowa. Putou pumuro oziga sai ema naso wero nuamunowa. Ago wero Yerusalem nate ena zaawero Yudaya zeburata Samaria zebura o zebu sero amira nikare oziga naso puro bayamunowa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ge ago sero nusokare nana giti mokara witinua. Wititinoinu bereze meni nu gogo wero puro witinu kau wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Utura wititinoinu nukare iri ike niro kau inoiwa ema eto tama woi nusoto kapawaire meni nusokare nana eya kei awero dopewato. ");
INSERT INTO sue_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ago doperoto atata wero sewato awa, “Galilaya zebura ema, nikare nogoro giti iri utura niro itewi? Yesu nikare doro utura witi gewa da ago ine wero noko osamunoya.” Ago sewato awa. ");
INSERT INTO sue_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aposolo nukare dirumu zazo Oliwa amira ena ewesemuro Yerusalem nate muro toiwa. Ebata dirumu zazo Oliwa awa doro Yerusalem bayai awa apunu-kaka gege awa. ");
INSERT INTO sue_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nukare Yerusalem nate toiro esewa so itisowa da amira baro witiwa awa. Ago witiwa amira zazo nusokare ewa: Petoro, Yohane, Yakobo, Anderea, Filip, Tomas, Batolomiu, Matiu, Yakobo nu Alifayora mai, Simon Pugeu* asinoisowa, Yuda nu Yakobora zazo amira mai. ");
INSERT INTO sue_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ema awa ata Yesura mia Maria ata bama eni ata Yesura namisini, nukare ami duba da wero isa bua waiko be sero inoise itiwa awa. ");
INSERT INTO sue_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Be amire waiko be eto kaka tepo wamure Yesura ema bama 120 ami auniro itiwa Petoro meni nusokare nana soe ena eriro ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“O otao mamai naso, Yudas nu eba gita weti iwo meni Yesu pupisera amira ge nuso Ozana meni Dawidira be pumunu peu wenu ge senua, ge awa me waise sai itinua, are me wataya. ");
INSERT INTO sue_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas nu nasokare nana amira zo. Nu dai buara sai awa.” Petoro meni ago senua awa. (");
INSERT INTO sue_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yudas nu pasina wenu zuma gaewa amira moni awa puro baro ema zora zebu zuma gaero pumunua. Nu zebu amira baro duunu oti zaumunu ze wama berekuninu betenua awa. ");
INSERT INTO sue_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ago wenu oziga awa Yerusalem ema meni niniro zebu amira zazo ge nusokarera Akelidama asewa awa. Ge nasokaira Orara Berekunaira.) ");
INSERT INTO sue_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petoro meni ego senua awa, “Yere buku nasokai zazo Sam amira ena ego gayai itia awa, Nata nuso zasu kei awaise. So nusora ema zo oko nuaise. Agoro zo ego ewa, Bua nuso awa zo meni paise. ");
INSERT INTO sue_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ge gayai ago ine itia, are ema zo meni nakare soremai Yesu betaira ena seka wero erisia amira oziga nuso toise nuanekare. Ema ego ine ami nakare soremaise: ");
INSERT INTO sue_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Yohane meni ema bama ge ou gutinoinu Tua Yesu meni bua nuso zaawero nasokai nana soe nuasai nakai nu ama inoise noe donakai utura witisia, ema zo susura ena Yesu ama wero musia ami kei awero nakare soremaise.” ");
INSERT INTO sue_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Petoro meni ago senu ema eto tamuwa awa. Zo zazo nuso Yosefe. Eni meni nu Basaba asinoisowa, ata eni meni awa Zastas asinoisowa. Ema zo zazo nuso Matayas awa dai tamuwa. ");
INSERT INTO sue_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tamuro giro isa ego sewa awa, “O Tua, ni dubara gai, are ema eto ei awa nusoto nana are gesa te inoi, awa gipeyo giro ");
INSERT INTO sue_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","aposolo bua Yudas meni dotisia awa pumae. Yudas nu bua awa doro so gegenai nuso amira bamisia.” ");
INSERT INTO sue_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Isa ago sero vot wewa Matayas meni daininua. Ago wewa Matayas nu aposolo 11 amira nana tainua awa. ");
INSERT INTO sue_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pura bamu zazo nuso Pentekos amira be kei awenu giro Yesura ema bama dapikarago so daimata amira auniro itiwa awa. ");
INSERT INTO sue_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Itiwa awi zo bisi bamubake meni awi sago wero utura ena osenua. Osero so itiwa amira toiro be munua. ");
INSERT INTO sue_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ago wenu nukare gosinoiwa nena zo iwawa ine ami niao ine wero zazaumuro ema bama itiwa amira nana erama sero dopero zasimunua awa. ");
INSERT INTO sue_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ago wenu Ozana meni duba nusokarera toiro be munu Ozanara ge ewe-pape sewa. Awa Ozana meni duba nusokarera potinua awa te sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Be amire Yuda ema zebu sero meni gera Yerusalem auniro itiwa awa. Nukare yere sai ema awa. ");
INSERT INTO sue_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Are nukare awi bamu awa dai niniro ema bama dago muro zimuwa awa. Zimuro di tainiwa. Nera kota, aposolo meni ge zebu serora awa toiwa niniwa awa. ");
INSERT INTO sue_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Niniro wana di gamuro itazaita inoise ego sewa awa, “Ema dubu ge tora ei awa Galilaya ema gege. ");
INSERT INTO sue_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nukare nogo wero zebu kei awenakai amira ge eure-taure sesera ninenakai gera mamana meni sago inori? ");
INSERT INTO sue_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nakai ei awa Patia ema, Midia ema, Ilam ema, agoro Mesopotemia zebura, Yudaya zebura, Kapadosia zebura, Ponto zebura, Asia zebura, ");
INSERT INTO sue_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frizia zebura, Pamfilia zebura, Izip zebura, nata Sairini Libia zebura itia amira nata pei-mamaira, nakai eni meni nata Roma ena muro esewa inoise itenakai, ");
INSERT INTO sue_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yuda ema kei awaire Yuda ema meni nuago waire, agoro Krit emare Arebia emare. Nakai ami nonakai ge nasokai zebu serora awa toise tani ewa-gaewa Anutu meni inowia amira oziga ge sesera ninitinonakai awa.” ");
INSERT INTO sue_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ema nukare ago sewa duba sirenu kotumai dainiro pumuro ego sewa awa, “Tani awa neni?” ");
INSERT INTO sue_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ago sewa, ata eni meni awa aposolo dubu isinoise ego sewa awa, “Nukare ou wain pena-pana nera, are duba dau inoi ge ago ine tora awa.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ago sewa Petoro nu otao 11 amire dai dopero arero ego senua awa, “O Yuda ema otao mamai ata mai Yerusalem nate nowa, nikare dapikarago dana zaawewo ge sana ninawe. ");
INSERT INTO sue_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nikare ema dubu emire ego towa awa, ‘Ou wain ninomite duba dau inora.’ Ago tepo awa. Pina zeme atitinoya. Are ou wain nogoro namunonikare? ");
INSERT INTO sue_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nikare ge towa ago ine oko aewa. Tani gosinowa amira susu awa ego ewa. Porofete Yoeli meni ge ego gaenua awa me inoya. ");
INSERT INTO sue_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Anutu meni toya awa, Noma zebura be pesunitinuai* na Ozana naso potana wa boruza ine wero osero ema dapikarago amira nana mokara toyamunoya. Mai mamatanare babumanare nisokare meni porofete meni sago wamunora. Mai mamatana nisokare meni seka itise atua ine wero nena me gamunora. Ema zezewenai nisokare meni atua me wamunora. ");
INSERT INTO sue_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Be amire na Ozana naso ema bama naso amira nana potana nukare porofete meni sago wamunora. ");
INSERT INTO sue_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Sana bereze ike ena wagu eni kei awamunora. Ota zebura ena dai wagu eni kei awamunora. Wagu awa orarare niaore ibosi bamure ami kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Waiko diti sikimamunoya. Inua izero orara ine wamunoya. Wagu awa kei awara Tuara be bamu zasimaire kei awamunoya. ");
INSERT INTO sue_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Be amire zo nu Tua zawa samunoya, nu awa Tua meni soero pumamunoya. Yoeli meni ago gaenua awa. ");
INSERT INTO sue_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","O Isreli ema otao mamai naso, ge sana niniu. Anutu meni Yesu Nasarete ema buara potinua, awa gawise sero Anutu meni putou numore potinu nisokare nana soe noise bua zezewenaire tani sekare tani putoure wasai gosinoisewa awa. Susu awa gosinowa awa. ");
INSERT INTO sue_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nukare Yesu puro wana nisokarera potamunora, awa Anutu meni emoko ago ine warise senu zewai wenua. Noko emoko ginu te wenua. Are ebata senua te nikare Yesu betaise sero ema Yudara lo ge ninai tepo amira wanera potewa ni pasinaira detera betisia awa. ");
INSERT INTO sue_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nu awa betaira yaya tami Anutu meni yayara mui besero betaira mokara ena awa-uzesi seka wero erisia. Nera kota, betai meni nu soyai ine tepo. ");
INSERT INTO sue_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawidi meni Soyai Ema nasokai eramunoya amira ego senua awa, Tua nu benau nasora itawi gosinowena. Na azu wai azu, nu wana me nasora dopero itewia. ");
INSERT INTO sue_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Are moka naso meni yawa wawi iwawa naso meni yawa sara inowia. Awa daba kota, na betaira gegenai ami Anutu tuma didinoise kokopai zanatiamunona. ");
INSERT INTO sue_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ago wamunona. Nera kota, ititi naso meni betai natara itai azu, Anutu ni na oko duamunosa. Ni soumai me niso oko duasa woi naso gumu wero yarasa awamunoya. Tepo awa. ");
INSERT INTO sue_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ni nuai mera ebata awa namore gipesa. Ni namore dai itasa na yawa sara bamubake wamunona. ");
INSERT INTO sue_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Dawidi meni ago senua awa. O otao mamai naso, na ewowo nasokai Dawidira ge awa sero baitana niniu. Nu betenu gowewa diti nuso nasokai nana itewia. ");
INSERT INTO sue_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nu ami porofete noisonua, are nu ego ginua awa. Anutu meni Dawidira saisibuna dubu amira ena zo ema tua potai tua waira bua nuso awa pumaise ge senu zewai wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Anutu meni bua wamu senua, awa Dawidi meni ginua. Are nu Soyai Ema nasokai erai nusora ge ego ine senua awa, “Anutu nu oko duai betai natara itamunoya. Tama aiso nuso meni oko gumu wero yarasa awamunoya. Tepo awa.” ");
INSERT INTO sue_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu nu awa Anutu meni awa-uzesi seka wero erisia, awa me giti moka nasokare meni giro tonakare awa. ");
INSERT INTO sue_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Anutu Mama nusora zumai meni zumi witiro Anutura wana mera arumi Mama meni Ozana potamu senua, awa numore poti puro tani ninitinoise gosinowa awa weti kei awetia. ");
INSERT INTO sue_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Yesu utura witisa, ago ine awa Dawidi nu nutope utura kaka witamu. Ata nu ego senua awa, Anutu meni Tua nasore ego senua awa, “Ni muro wana me nasora arumuro itasa ");
INSERT INTO sue_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","na iwo dubu niso awa benau nisora potana isimamunosa.” ");
INSERT INTO sue_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Dawidi meni ago senua awa. Are nikare Isreli ema dapikarago ami ego giwo zewai wae. Nikare Yesu ni pasinaira doisewa, nu awa Anutu meni potinu nu Tua ata Soyai Ema nasokai wero nowia awa.” Petoro meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Petoro meni ge ago senu niniro duba niwa awa. Duba nitinoise nu ata aposolo eni awa atata wero ego sewa awa, “Otao mamai, nakare nogo wamunonikare?” ");
INSERT INTO sue_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ago sewa giro Petoro meni ego senua awa, “Anutu meni pasina nisokare disaise nikare duba kapeteniro Yesu Kristo tuma diawa nakare nikare ge ou gutanekare. Ago wanakare Anutu meni Ozana nimorekare potamunoya awa. ");
INSERT INTO sue_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nikare ata mai awiso nisokare ata eni asike nowera, awa Tua Anutu nasokai meni asa-waura inowia te Ozana nimorekare potamu towia awa.” ");
INSERT INTO sue_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petoro meni ge ago sero tepo wero ge eni susumuro toise potai ge dai potitinoise ego senua awa, “Ema waya-kawaya ego nowera ami pasinara ina tamamunora. Nikare numorekare dai waya wanowa awa.” ");
INSERT INTO sue_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Petoro ago senu erama eni ge awa niniwa me wenua, are nukare awa ge ou gutewa. Waiko be amire ema 3,000 Yesura dubure taiwa awa. ");
INSERT INTO sue_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Aposolo meni Yesura ge tugata wasara nukare ninamu yaba inoisowa awa. Ago inoise duba meni tairo baitiro bonarata begomora eyaya aunitinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aposolo nukare tani-butani putoure dainiro inoise nuasara ema bama dapikarago ami wana di gapinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kristo tuma didinoise noisowa ami duba meni ina-sipuna wero wau nena nusokare dubura gege asero noisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Eni meni noture wau nusokarere awa ema enire potiro ina moni pumuro otao mai eni bogamasa nuasara giro kano inoisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nukare waiko be sero duba da wero Anutura ibu bamura ena aunitinoisowa. Ota so nusokare sero auniro bona wero ninoisowa awa. Ago inoise ma meni awa kaka soyamu duba meni yawa sara inoise ninoisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ago inoise Anutu bowi inoise noisowa. Ago wewa ema dapikarago nukare giwa ziri wenua. Tua nu be giti ema eni soero pumasai nukare dubura nana susumuro noisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Waiko zore Petoroto Yohanere tuwe isa saira be munu giro Anutura ibu bamu amira toiwato awa. ");
INSERT INTO sue_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Toitinoiwato ema zo miera nana tinira ena zabura wai pumunua, awa dimuro puro muwa. Ema nu otao mai meni be giti dimuro puro baro ibu bamu amira so bera zorage potasara itima awinoisonua. So be awa So Be Neine asinoisowa. Ago itise ema toiro pusumuro awasara nena emo nukare begomo toisonua. ");
INSERT INTO sue_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Are Petoroto Yohanere ibu mokara toyamu inoiwato giro nu nena emo nuto begomo senua awa. ");
INSERT INTO sue_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Begomo senu nuto nu ua inoiseto Petoro meni ego senua awa, “Iri ni nato gase.” ");
INSERT INTO sue_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ago senu ema zabura wai meni nena zo potamu sewitota asero nuto pena-pana ua wenua. ");
INSERT INTO sue_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ago inoinu Petoro meni ego senua awa, “Nato wau moni tepo. Ata nena daimata itia, awa potana pumamunosa. Na Yesu Kristo Nasarete natara be nusora tona: eri, aita wase.” ");
INSERT INTO sue_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ago sero wana mera puro zinu erinua. Ago wenu te mere umure eya zewai wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Zewai wenu nu eya eriro dopero aita wenua. Ago wero numoreto dai ibu bamu amira mokara toiwa. Toiro nu zokari-zokari wero aita inoise Anutu bowi wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ema dapikarago meni nu aita inoise Anutu bowi inoinu giwa awa. ");
INSERT INTO sue_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Giro ego sewa awa, “Ibu bamura So Be Neine amira itise wau moni emo begomo towia, nu awa.” Ago sero nu kokopai wenua awa giro sopine awero kotumai kaka pamu wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ema nu Petoroto Yohanere sanitinoinu ema dapikarago ibu bamura osi zo zazo Solomonra amira sumuro nuto zimuro wana di gamuro dopewa awa. ");
INSERT INTO sue_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ema ago wewa Petoro meni giro ge ego senua awa, “O Isreli otao mamai naso, nikare nogoro ema ei awa giro wana di gapinowi? Nikare nogoro nato pena-pana ua inowi? Nato putou nasotora, o etutiro nuai nasotora ema ei awa kora wetenato aita inoya, asinowita? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isaka, ata Yakobo amira Anutu, nu ewowo-kawowo nasokaira Anutu, nune ami bua mai nuso Yesu amira zazo de ike nisia. Nu awa ninekare puro poti iwora wanera newa Pilato nu besai bayaise sesi nikare azu sisewa awa. ");
INSERT INTO sue_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ago inoise duba saramaire, o etutiro nuaira mama nu awa azu toise goroba ema nisokare awa-diaise Pilato uzutisewa. ");
INSERT INTO sue_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ago inoise nuaira gita wai ema awa detewa betisia awa. Ata Anutu meni awa-uzesi betaira ena seka wero eri giti moka nasoto meni goisenato, awa tonato ewa. ");
INSERT INTO sue_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ema ei awa gosinowewa. Nato Yesu tuma didinoise nowenato, are Yesu meni tuma diai nasoto awa awa-uzesi eriro zewai weti Yesura zazo amira putou meni ema ei awa kora weti tama nuso kokopai weti gosinowa. ");
INSERT INTO sue_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Otao mamai naso, na nimorekare ego gosinona. Nikare ata gita wai dubu nisokare ami tani wisewa amira susu kaka gamu inoise wisewa awa. ");
INSERT INTO sue_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Gita me gita Anutu meni Soyai Ema nuso Kristo yaya tapinoma betaise amira ge porofete dapikarago amira bera potinu sero gaewa, ge awa ago ine me wisia. ");
INSERT INTO sue_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Are Anutu meni pasina nisokare disaise sero nikare duba kapeteniro Anuture dai noiwo. ");
INSERT INTO sue_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tua meni nuso nana ena putou seka pumaira be potai maise, o Kristo nikare emo sia wenua, awa iyetai osaise nikare duba kapeteniro Anuture dai noiwo. Yuda emara Soyai Ema Kristo awa nu Yesu awa. ");
INSERT INTO sue_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nu ami zeme utura tise be zo dia itaise sai itia, are itia. Be amire Anutu meni sai nena dapikarago seka-sakama kei awamunoya. Anutu meni gita me gita ona ge nuso awa porofete dubu nuso gegenai amira bera potasai ago ine toisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mose nu ge ego senua awa, “Tua Anutu meni dubu nisokarera nana soe ena porofete zo na ego ine nimorekare tamamunoya. Nu ge tugata wamunoya awa te niniwo. ");
INSERT INTO sue_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Zo nu porofete amira ge ninai azu wai giro nu Isreli dubura nana tairo nuai azu, Tua meni dai betamunoya.” Mose meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ota porofete eni Samuel nuasai nuso nana atune kei awero tupisowa nukare dapikarago ami be zeme emira ge sero gaewa awa. ");
INSERT INTO sue_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Anutu meni nena ewa-gaewa potamu sero ge porofetera bera potasai nukare kereniro toisowa, nena awa ninekare pumawise senua awa. Noko tairo nuai Anutu meni ewowo-kawowo nisokare tamunua, amira me nikare awa. Tairo nuai awa Abrahamre ego toise tamunua awa, ‘Na saisibuna niso gawa wana gawa ami zebu sero ema te wamunoya.’ ");
INSERT INTO sue_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Anutu meni Mai nuso tamuro nisokare nana gita maise sero iyetinu osenua, awa nikare dapikarago gawa inoise wayara ebatara ena pumamu sero ago wenua awa.” Petoro meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petoroto Yohanere nuto ema ge ago tugata inoiwato prisre ibura polis amira gita waire Sadukayo emare nukare dai nusoto nana kei awewa. ");
INSERT INTO sue_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kei awero nuto ema ge tugata inoise Yesu nu betaira ena seka wero erinua are bebetenai eramunora, amira oziga kereniwato giwa waya wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Giwa waya wenu giro nuto pumuwa, ata tua zinu giro benai sora potiwa awinoiwato pina atinua awa. ");
INSERT INTO sue_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Are Petoro meni ge tugata wenu niniwa amira eni dubu bamu meni ge awa niniro Yesu tuma diro Yesura dubure susumuwa 5,000 ago wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pina atinu Yudara gita wai emare simaire lo ge gipai emare nukare Yerusalem nate ena auniwa awa. ");
INSERT INTO sue_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pris bamu zazo nuso Anasi ata Kayafa ata Yohane ata Alesanda ata pris bamura didikai dapikarago nukare ami numorekare dai auniwa awa. ");
INSERT INTO sue_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Auniro sewa aposolo eto aunai nusokarera puro bamuwa nusokare nana giti mokara dopewato atata wero sewa awa, “Ai meni nito soremi ema zabura wai awa kora watawito? Ara bera sesewato ewanana watai?” ");
INSERT INTO sue_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ago atata wewa Petoro nu Ozana meni mokara be munu ge ego senua awa, “Gita waire simaire, sana niniu. ");
INSERT INTO sue_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nato ema zabura wai emo tani kokopai watanato, amira, ‘Ai meni nito soremi ema ei awa kora watawito?’ asero koto inoise nato atata inowa. ");
INSERT INTO sue_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Are kerenana nikare ata Isreli ema dapikarago ami niniu. Yesu Kristo Nasarete natara ninekare ni pasinaira detewa betisia, ata Anutu meni betaira ena awa-uzesi eriro noya, putou nusora ema ei awa tama nuso kokopai weti nisokare nana giti mokara dopero itia ewa. ");
INSERT INTO sue_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ge gayai zo itia ami Yesure ego toya, So wai ema nikare omata zo giwa waya wenu dowa awa. Ata omata ami so urura zasiwi wero itewia. ");
INSERT INTO sue_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yesu imata nakai korawai te inoya. Anutu meni Yesura zazo eramare kereninua, are korawai ema nasokai zo zebura oko itia.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Petoroto Yohanere nuto azu wai tepo be nusoto peu wenu ge sewato, ema koto inoiwa ami niniro nuto ninai ibura kaka nuamu, nuto ema osai gege, awa giro sopine awero di tainiwa. Nuto Yesure dai noisowato awa giwa. ");
INSERT INTO sue_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Are ema kora wewato ami nusoto nana zorage dopero itinu nukare nu giro ge ina sai ine tepo wero dowa awa. ");
INSERT INTO sue_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ge kau wero nuto sewa ose kakame niwato nutopekare ego ina-sa wewa awa, ");
INSERT INTO sue_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nakai ema eto nogo wamunonikai? Nuto tani putoure bamu weterato kei aweti Yerusalem nata meni oziga niniro tepo wetera, are nakai tani nusoto begi wai ine tepo. ");
INSERT INTO sue_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Are ge awa nata sero bayai ninai azu, sanakai ema amira zazora noko oko ema ge tugata wareto.” ");
INSERT INTO sue_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ago sero nuto sewa witiwato ego sewa awa, “Nito Yesura zazora noko oko ge tugata-magata waweto.” ");
INSERT INTO sue_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ago sewa, ata Petoroto Yohanere meni ge ina ego sewato awa, “Nikare nitopekare kotumuro giu. Ge nisokare dipinoise Anutura ge azu sanato Anutu meni gai te wamunoita? Gai te oko wamunoya. ");
INSERT INTO sue_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ge ninisenato, o nena goisenato awa nato bezero puro nuai ine tepo.” ");
INSERT INTO sue_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ago sewato nukare azu saira ge noko tomite nuto dowa bamuwato awa. Natara ema bama dapikarago meni tani wewato awa giro Anutu bowi inoiwa, are nukare ema bama azu inoise numoreto tama yaya zo potaira ebata kau wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ema kora wewato awa zabura wero iteye donu zepa 40 wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nukare Petoroto Yohanere dowa nuto aunaira ena baro otao mamai tamuro pris babezinomare simaire ge numoreto sewa awa uge-mage wero pesuniwato. ");
INSERT INTO sue_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Are nukare ge awa niniro duba nusokare da wero Anutura nana potiro ego sewa awa, “O Tua bamubake, ni uture zebure eware nena bamubamu amire dai tamusa. ");
INSERT INTO sue_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Are nine sesa Ozana meni ewowo nasokare Dawidi nu soumai niso amira be pumunu peu wenu ge ego senua awa, Ema Yudako nukare nogoro Tuare tini kapai puro noweri? Ema dubu giti nogoro Tua waya wamu sero ebata kau wero zainitinori? ");
INSERT INTO sue_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Zebu serora ema tua ami Tuato Soyai Ema nuso Kristore awa iwo wamu sero zimuro dopewa awa. Ema babezinoma ami numoreto iwo wamu auniwa awa. ");
INSERT INTO sue_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ge Dawidi meni gaenua, ge awa nata emira ena me wisia. Herodeto Pilatore nuto ema Yudakore dai ata Isreli emare dai nukare Mai niso Yesu, nu bua nisora gegenai, nu awa iwo wamu sero aunisera awa. Nu awa Soyai Ema nasokare waise sesa. ");
INSERT INTO sue_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Sasa te wanoi, awa kaka samu wisera. Ata putou niso itia, are kei awaise towesa te kei awinowia. Are tani kei awaise sesa, amira te wisera awa. ");
INSERT INTO sue_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Tua, azu sai ge nusokare giro giro bua mai dubu nisore putou potasa ge niso azu wai tepo zewai wero sanekare. ");
INSERT INTO sue_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Putou niso gipasa garise sero ema yayare awa kora weyo. Nakare bua mai niso gegenai Yesura bera tani putoure wanekare.” ");
INSERT INTO sue_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Isa ago sewa so auniro itiwa awa zipe-zipe wenu Ozana meni nukare sero topetinu nukare azu wai tepo zewai wero Anutura ge ema bama tugata wamu zaawewa awa. ");
INSERT INTO sue_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yesu tuma didinoise noisowa ami duba da wero kotumai da wero noisowa. Ago inoise wau moni nusokare awa niso naso kaka samu, dubura gege asewa itisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposolo meni Tua Yesu betaira ena seka wero erinua amira oziga ge putoure sasara ema bama ninasara Tuara soremai bamubake nusokare nana itisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nusokare nana zo meni bogamasa oko noisonua. Ema zebure ibu marare noisowa ami nena nusokare awa ema enire potiro ina moni pumuro ");
INSERT INTO sue_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","moni awa aposolora wanera potitinoisowa. Ago wasara aposolo meni ema wau kau inoisowa awa te moni kanowero potasara pupinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Are ema zo noisonua zazo nuso Yosefe. Aposolo nukare zazo nuso zo Banaba asewa. Ge nasokaira Uzutai Ema. Nu Lewira saisibuna amira zo. Nu Saipras gutura ena kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ema ami notu nuso ema enire potinu moni potiwa awa dapikarago puro aposolo nana wanera potinua awa. ");
INSERT INTO sue_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ema zo noisonua zazo nuso Anania. Nu ara nuso Safairato ge uge weroto zebu nusoto emare potiwato ina moni potiwa pumuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nuto ge sero tiroto ema meni moni agewa bezero agewa gege aposolo nana wanera potinua awa. ");
INSERT INTO sue_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Potinu Petoro meni atata wero senua awa, “Anania, Satan meni duba niso topetiro Ozana etete nitinoise zebu nisora zuma agewa bezasise sesi nogoro niniro da ago wamu wetesi? ");
INSERT INTO sue_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Zebu niso itaise sero giro duasa itamia. Ota noko ema enire potiro moni pupitasa, moni awa nine gege mama inosa. Ni nogoro tani awa dube potisesi? Ni eramare kota, Anuture opi sesesa awa.” ");
INSERT INTO sue_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ago senu Anania meni ge awa niniro duro betenua awa. Ago wenu eni meni oziga awa niniro azu bamu wewa. ");
INSERT INTO sue_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Betenu mai seka itiwa ami eriro woi nuso mo meni dowero puro baro gowewa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ago wewa 3 aua ago tepo wenu ara nuso meni tani kei awenua awa kaka gamu inoise kei awero sora toinua awa. ");
INSERT INTO sue_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Sora toinu Petoro meni atata wero senua awa, “Gire, nito zebu potewato zuma potera pupisewato, awa kaka ewe ni?” Ago atata wenu bama meni ego senua awa, “Kaka awa gege awa.” ");
INSERT INTO sue_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ago senu giro Petoro meni ina ego senua awa, “Nito nogoro Tuara Ozana gaero gamu sero ge da sesewito? Iu niso gowetera mai dubu awa zeme-zemeke so be atune dopero itera. Are nukare ni da ago puro baro gowamunora.” ");
INSERT INTO sue_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ago senu bama ami nuso nana tera ena duro betenua awa. Betenu mai seka dubu ami toiro ara betenu giro puro baro iu gowewa da amira gowewa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Are Yesura dubu ata ema eni dai oziga nusoto niniro azu bamubake wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolo meni tani putoure dainiro emara nana inoisowa. Nukare dapikarago Anutura ibu bamu amira osi zazo Solomonra amira duba da wero aunitinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Aunasara ema eni meni numorekare tairo nuai azu wewa. Ata ema bama meni numorekare gasara wititinoisowa. ");
INSERT INTO sue_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Are emare bamere dainiro-bake ami Yesu tuma diro nuso nana susumuro noisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aposolo meni tani putoure inoise noiwa giro eni meni otao mamai nusokare yayare awa ebete ena sawa diro amira potitinoise ego sewa awa, “Ego itara Petoro meni ebete izima-sauma inoise nukare giro korawaise. Nu wana meni kaka kora wamu wamunoya, awa duga nuso meni enira nana semai ewanana warise.” Ago sero wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nata pei-mamai Yerusalem zimuro itiwa amira ema bama dainiro meni aposolora nana kokouniwa awa. Nukare otao nusokare yayare bi mokara itai amire dai puro masara kora wasara kokopai wero susawisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nena ago ine kei awenu giro pris bamure ema numore dai itisowa, nukare Sadukayo dubura, nukare ami aposolo dubure kotumai waya puro nukare waya wamu sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ago inoise aposolo dubu puro benai sora potiwa. ");
INSERT INTO sue_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ago wewa awinoiwa pire Tuara angelo zo meni so be piero nukare uzumuro puro osero ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nikare ibu bamura toiro ema dapikarago nuai sekara oziga ge kereniro baititinoise noiwo.” ");
INSERT INTO sue_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ago senu nukare niniro pina gamu ibu bamura toiro ge tugata wewa awa. Pris bamu ata ema dubu nuso ami poti dara niro giti kopi dubu ata Isreli ema babezinoma dapikarago awa zawa sewa auniwa awa. Auniro polis bamuro benai sora ena aposolo pumara marise sewa. ");
INSERT INTO sue_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ago sewa polis meni baro benai sora ena kau wero giro ewesemuro ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nakare baro so be lok dai gamai iti genakare. Noko dia nukare so be dia dopero itera. Ata nakare so be piakaniro toiro ema kau wetenakare.” ");
INSERT INTO sue_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ago sewa ibu bamura polis amira giti kopire pris babezinomare meni giwa te kaka wamu wenu, “Tani ei awa nogo wero pesunamunoi?” asewa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ago toiwa ema zo meni kei awero ego senua awa, “Benai sora potitawa awa nukare ibu bamura mokara ena ema ge tugata inora owa, giwo.” ");
INSERT INTO sue_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ago senu polisra giti kopi ami dubu nuso pumunu bamuro aposolo dubu wewetiro uzumuro puro muwa. Ema bama meni nukare aposolo dubu emo omata meni dai azu, nukare iwo pena-pana kaka wamu, saitiro puro muwa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nukare aposolo puro baro aunaira potiwa giti kopi dubura nana benaura dopewa pris bamu meni ge ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nikare ema amira zazora ema bama ge tugata wai azu sisenakare. Ata nikare ge awa noko Yerusalem ena tugata wetewa ema bama pu sunare dago ninitara. Ago inoise ema Yesu doisera amira pasina awa namorekare potamu sero inowa.” ");
INSERT INTO sue_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ago senu Petoro ata aposolo eni meni ina ego sewa awa, “Eramara ge dipinoise Anutura ge azu sai ine oko itia. ");
INSERT INTO sue_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nikare Yesu ni pasinaira detewa betisia, nu awa apipie nasokaira Anutu meni awa-uzesi seka wero erisia awa. ");
INSERT INTO sue_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Eri Anutu meni soero nuso nana wana mera potiro Gita Wai Ema, o Soyai Ema nasokai potisia. Isreli ema nakai duba nasokai kapetenanakai pasina nasokai disamu sero ago wisia awa. ");
INSERT INTO sue_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Amira oziga awa nakare ata Ozana ami towenakare. Ozana awa Anutu meni ge nuso dipinowera amire potitinowia.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Aposolo meni ago sewa niniro tini kapai waya puro aposolo damu sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Damu sewa, ata aunai nusokarera Farisayo zo itinua, zazo nuso Gameliel. Nu lo ge gipai ema zo. Ema bama dapikarago meni zazo nuso de ike nitinoise noisowa. Nune eriro polis meni aposolo puro ose kakame nara be pei-kaka ago itarise senu osewa, ");
INSERT INTO sue_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","otao mamai nusore ego senua awa, “Isreli otao mamai naso, nikare ema awa waya wamu sero giro kotumuro baitiro amire wewo. ");
INSERT INTO sue_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gita ema zo zazo nuso Tiudas ami kei awero ego senua awa, ‘Na putou bamubake naso nana itia.’ Ago senu ema 400 meni nuso nana bamuwa awa. Ata nu iwora wanera betenu dubu nuso bozewa bua nusokare tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ama be gavman meni ema bamera zazo gainoiwa be amire Galilaya zebura ema zo zazo nuso Yuda ami kei awero noisonua. Nune ema eni uzumunu nu ama ganinoisowa. Ago wenu nu dewa betenu dubu nuso bozewa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Are ema emire ge ego sana niniu. Nikare ema dubu ei awa waya oko wawe. Dou nuare. Ge tugata inowera, o bua inowera, awa kotumai nusokarera wamunora, awa duawa osero tepo wamunoya. ");
INSERT INTO sue_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ota bua inowera awa Anutura kotumaira inuamunora, awa ninekare nukare kaputamunowa. Nikare bua nusokare sisinoise Anutu iwo wanowa awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ge ago senu niniwa te wenu aposolo zawa sewa witi aunaira niwa wamu meni dewa. Dero Yesura zazo bowire amira ge noko tugata wai azu, azu sero iyetiwa bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Iyetiwa Tua numorekare ginu te wenu nukare zazo nuso emo wamu pumuwa amira yawa sara inoise aunaira ena osero bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Are nukare waiko be giti ibu bamura enata ibu mare ena Yesu Kristora Oziga Ewanana kaka duamu tugata-magata inoise noisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Be amire ema bama dainiro meni Yesu tuma diro dubu nusora susumuwa dubu bamu wenua. Nukare eni meni Grik ge toisowa, eni meni Yuda ge toisowa. Nukare waiko be sero nena naira moni kapero kano inoisowa awa. Ago inoiwa Grik ge sai ema ami Yuda ge sai ema amire dumu wero ego sewa awa, “Nikare tama sogawaira moni kano inoise bama kuma nasokare dotinowewa.” ");
INSERT INTO sue_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ago sewa aposolo 12 meni Yesura dubu dapikarago zawa sewa auniwa ego sewa awa, “Nakare tamara bua soga inoise Anutura ge tugata wai amira bua awa duanakare osai te oko wamunoya. ");
INSERT INTO sue_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Are otao mamai, nikare ema 7 nisokare nana soe ena pumuwo. Ema Ozana meni nusokare nana topetiro nowia, o ema kotumai ewananare, o ema ema bama eni meni gawera ewanana inowera, ema 7 ago ine awa pumuwo. Ago wawa bua awa sanakare ware. ");
INSERT INTO sue_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ata nanekare meni awa isa buare ge tugata waira buare awa wai gege wanekare.” ");
INSERT INTO sue_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ge ago sewa dubu meni niniwa te wenu, ema ego awa pumuwa: Stiwen, nu tuma diai bamubakere. Ozana meni nuso nana be muro itisonua. Agoro Filip ata Prokoro, Nikano, Timon, Pamena, Nikola nu Antiok natara ema. Nu Yuda ema me kota, nu Yuda ema meni nuago wero noisonua. ");
INSERT INTO sue_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Are ema dubu awa pumuwa nukare aposolo dubura nana zorage dopewa isa sero wana gitine potiro gawa wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Are Anutura ge sisiniro bamunu erama witai meni niniwa. Yerusalem ena ema bama dainiro meni Yesura dubu amira nana susumuwa. Ota pris dubura nana eni dainiro meni Yesura ge niniro dipinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Anutura gaware putoure Stiwenra nana itisonua, are nu emara nana giti mokara tani putou bamure eni wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ago wenu ema eni eriro Stiwenre dai ge ina-sa wewa. Ema dubu awa yere ibu nusokare amira zazo nuso Ema Souwai Buara Mui Amu amira Ibu asinoisowa. Nusokare nana ema eni ata Sairini ema eni ata Alesandria ema eni ata Silisia ema eni ata Asia ema eni ago ami dara tairo Stiwenre ge ina-sa wewa. ");
INSERT INTO sue_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ago wewa Ozana meni kotumai ewanana Stiwenre potinu ge me gege sero bamunu ge nukare opi wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nu nukare ago daininu giro nukare ema eni tamuroopi sarise sewa giro nukare Stiwenre ego sewa awa, “Stiwen nu Moseto Anuture isipitinoise ge waya numoreto sesi ninisenakare.” ");
INSERT INTO sue_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ago toise ema bama ata simaita lo ge gipai ema amira duba gaewa awa. Ago wewa nukare bamuro Stiwen saniro puro giti kopira aunai amira bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Puro baro ge opi samu sero sia wero otao mamai nusokarere potiwa puro noiwa. Are nukare kotora ena opi ge toise Stiwenre ego sewa awa, “Ema ami ibu bamu nasokaire lo ge nasokaire awa isinoise nowia. ");
INSERT INTO sue_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ego sesi nakare ninisenakare, ‘Yesu Nasarete natara ami ibu bamu ei awa dero ziwamunoya. Ago inoise tani Mose meni wanisekai sero gaenua awa doro tani zo wanisekai potamunoya,’ asisia.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ago sewa ema dubu aunaira itiwa ami Stiwen ua inoise benau nuso giwa angelora benau ine wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pris bamu meni Stiwen atata wero ego senua awa, “Ge tora awa ge me ni?” ");
INSERT INTO sue_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ago senu Stiwen meni ina ego senua awa, “O otao mamai naso, babezinoma naso, ge sana niniu. Ewowo nasokai Abraham nu Heran nate kaka bayamu Mesopotemia zebura dago noinu amire Anutu zasimaire meni kei awero numore ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Ni zebu susu niso ata dubu niso awa doro nane zebu zo gipamunona amira baro nuamunosa.’ ");
INSERT INTO sue_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ago senu nu ge awa niniro zebu nuso Kalidia awa doro Heran nate baro noisonua awa. Ago noinu mama nuso betenu Anutu meni zebu amira ana uzumuro puro mu zebu nowenakai amira ninua. ");
INSERT INTO sue_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Puro muro zebu oko dirieninu nuso wenua. Tepo awa. Agewa zo da di numore kaka potamu wenua. Nu ata saisibuna nusore meni ama topetarise seroninua. Awa nu mai tepo noinua be amire Anutu meni ago seroninua awa. ");
INSERT INTO sue_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Anutu meni ge zo numore ego senua awa, ‘Saisibuna niso meni zebu seka zora baro esewa noise sou bua gege inoise zepa 400 ago yayara tame nuamunora awa.’ ");
INSERT INTO sue_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ota nu ge zo susumuro ego senua awa, ‘Sou bua warise sero pumamunora, ema awa ina potana saisibuna niso duara zebu awa doro zebu emira muro na bowi inoise nuamunora.’ Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Anutu meni ago sero nukare numore dai tayarise sero tairo nuai nuso Abrahamre potiro tayai awa damu-damuke itaise Abraham ata dubu nusore meni tani tama aiso kapai awa puro nuarise senua. Are mai nuso Isaka kei awero itinu waiko be 8 wenu Abraham meni maira tama aiso kapenua. Da ago ine Isaka meni Yakobo kei awenu tama aiso nuso kapenua, noko Yakobo meni ewowo-kawowo nasokai 12 kei awasara tama aiso nusokare kapinoisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Are ewowo-kawowo nasokai meni kiaka nusokare Yosefere kotumai waya pumuro moni emo ema enira nana wanera potiwa puro bamu Izip zebura niwa sou bua inoisonua. Ago baro noinu Anutu meni numore dai noisonua. ");
INSERT INTO sue_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Noise Yosefe duba naira ena soero puro kotumai ewanana potinu Izip ema tua Fero meni ginu kokopai wenu giro ibu mara nusore natare emare awa dia nuaise ema tua potinua awa. ");
INSERT INTO sue_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Potinu noinu Izip zebura o Kenan zebura be dora botiyo bamubake kei awenu so dapikarago nena tepo wenua. Ago wenu ewowo-kawowo nasokai meri betero nena nai kau inoise noisowa. ");
INSERT INTO sue_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Are Yakobo meni ‘Izip zebura ma itia,’ asewa niniro giro mai awiso nuso iyetinu ago bamuwa. ");
INSERT INTO sue_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ama nukare Izip zebura noko bamuwa Yosefe meni susu nuso awa namisini nusore kereninua. Ago wenu Fero nu da ago Yosefera dubu ginua. ");
INSERT INTO sue_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Are Yosefe meni mama nuso Yakobo ata dubu nuso dapikarago ema bama 75 awa zawa senua awa. ");
INSERT INTO sue_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Zawa senu Yakobo dubu nusore Izip zebura baro iteye betenu ewowo-kawowo nasokai da ago bebeteniro tepo wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Betewa wetu nusokare puro kapeteniro bamu Sikem nate niwa awa. Gita Abraham meni Sikem nate Hemora saisibuna amira zebu zo bi ditira asero moni meni zuma gaenua amira gowewa awa. ");
INSERT INTO sue_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ge Anutu meni Abrahamre senua awa me waira be zora awinoinu nukare Izip zebura ena dainiro wisika asewa. ");
INSERT INTO sue_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ago inoise noiwa Izip ema tua seka zo kei awenua. Nu ami Yosefera susu kaka gamu wenua. ");
INSERT INTO sue_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Are ema tua ami ewowo-kawowo nasokai etete niro gera-gaira wenua. Ago inoise senu nukare mai uno nusokare betaira gegeniro apitinoisowa. ");
INSERT INTO sue_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Be amira ana Mose kei awenua. Nu mai giti boure. Kei awenu bezero mia mamera nana sora puro itiwa inua etorobara wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ago inoe ape betaira niwa Ferora mai bama diri meni tamuro mai nuso asero puro dia wenu bazinua. ");
INSERT INTO sue_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ago wenu Ferora ema dubu meni Izip emara ninai dapikarago gipewa niniro baitiro bua inoise ge senu kokopai gege wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Are Mose nu noe ema wenu zepa nuso 40 wenu Isreli ema otao mamai namisini nuso gamu sero bamunua. ");
INSERT INTO sue_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Baro Izip ema zo meni Isreli zo doinoinu giro otao nuso soero Izip ema ina denu betenua. ");
INSERT INTO sue_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ago inoise ego kotumunua awa, ‘Dubu naso Ferora wanera ena soero panise Anutu meni bua inoya, awa gamunora.’ Ago kotumunua, ata nukare oko giwa. ");
INSERT INTO sue_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ago wenu pina atinu Isreli ema eto ina-da inoiwato nu baro tamuro kapinoise ego senua awa, ‘Nito dubu da ami nogoro iwo ina-wa inowito?’ ");
INSERT INTO sue_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ago senu ema zuzuna zaawero otao nuso denua ami Mose ziriniro ge ina ego senua awa, ‘Ni ema tua nasokare ni? Ni dia ai meni potinu? ");
INSERT INTO sue_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Awenakai agore ni Izip ema zo doitasa, ago ine na damu tosita?’ ");
INSERT INTO sue_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ge ago senu Mose meni ge awa niniro giro azu baro Midian zebura ema enira nana soe esewa noisonua. Ago noise bama atiro mai mata diri eto pumunua awa. ");
INSERT INTO sue_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ago noinu zepa 40 tepo wenu bamu ware niro dirumu Sinai amira susura baro noinu ni pei-mamai itiwa amira zora niao awinoinu niao mokara ena angelo zo meni kei awenua. ");
INSERT INTO sue_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Are Mose nu niao awa nogoro kei awinoi, awa gane, asero zorage bamunu Tuara ge ego kei awenua awa, ");
INSERT INTO sue_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Na ewowo-kawowo nisokarera Anutu. Na Abrahamto Isakare ata Yakobo amira Tua wero itewena.’ Ago senu Mose te-wana zipenu azu inoise iri ago nai ine tepo wenu dopenua. ");
INSERT INTO sue_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dopenu Tua meni ego senua awa, ‘Zebu patitinosa awa saramai awa, are te nisora sandol dute. ");
INSERT INTO sue_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ema mamai naso Izip zebura ena dero kaputitinuawera dire-buare inowera awa iri bage niro gena. Are na nukare soero pamu sero osisinona awa. Are ni eri. Izip zebura iyetana noko bayamunosa.’ Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Are Isreli ema nukare Mose azu sero ego sewa awa, ‘Ni ai meni ema tuata dia nasokare potinu?’ Ema azu sewa da awa Anutu meni ema tua o soyai ema nusokare waise sero angelo nuso iyetinu niao mokara ena kei awero bua ge awa senua. ");
INSERT INTO sue_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Angelo ami nu soremunu zewai wero buara bamunua. Buara noise Izip zebura baro Isreli ema bama uzumuro Izip zeburata Ewa Izaira ena tani putoure inoise puro munua awa. Nu nukare puro ware noise tani putoure inoise noinu zepa 40 wenua. ");
INSERT INTO sue_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mose meni Isreli emare ge ego tugata wenua awa, ‘Anutu meni nisokare nana soe ena porofete zo na ine nimorekare tamamunoya.’ ");
INSERT INTO sue_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ago senua awa. Nu da ami zebu soe ena Isreli ema bama noisowa amire dai noisonua. Nu ewowo-kawowo nasokaire dai noise Sinai dirumura ena angelora bera zewai wai ge niniro ganisekai sero gaenua awa. ");
INSERT INTO sue_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ewowo-kawowo nasokai meni Mosera ge ninai azu sero Izip zebura kapetenamu sero duba nusokare bamu Izip zebura ninua. ");
INSERT INTO sue_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ago wenu nukare Aronre ego sewa awa, ‘Ni ititi eni kewasa tua nasokai asanakai ititi ami nakai gita wai bayanekai. Mose nakai Izip zebura ena uzumuro puro musia nu sisisita nogo wisi, awa nakai kaka gamu.’ Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ago sero ititi zo bulimakao mai ine wero zame potitinoise tua opi wana meni wewa amira bona inoise yawa sara wewa. ");
INSERT INTO sue_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nena awa wewa Anutu meni nukare doro pasina nusokarera ina tamarise senu duba nusokare sisero inuare kunare bowi inoisowa. Are porofetera buku amira ge ego gayai itia awa, Isreli dubu, nikare zepa 40 ware noise wora zameta zame eni potitinoise na emo potitinoisouta? Tepo awa. ");
INSERT INTO sue_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nikare tua opi zazo Molak amira seli boa yere ibu awa dimuro izima-sauma inoise noisowa. Nikare tua opi zo zazo Refan amira kunara ititi puro noisowa. Nikare nena awa bowi wamu sero wana meni wewa awa. Are na nikare nata Babilon amira atune potana nuamunowa awa. ");
INSERT INTO sue_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ewowo-kawowo nasokai meni ware noise seli ibu puro noisowa. Seli ibu ami ‘Anutu ego itia’ awa kerenitinoisonua. Anutu meni Mosere seli ibura ititi gipinoise da ago ine warise senu te wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Seli ibu awa ewowo-kawowo nasokai meni susumuro susumuro puro tupie dowa Yosua meni gita wenu ana Anutu meni ema dubu eni dero tunenu bamuwa. Are ewowo-kawowo nasokai meni dubu enira zebu awa puro mamana wero seli ibu nusokare puro ago potiwa itisonua itinu Dawidi kei awenua. ");
INSERT INTO sue_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawidi kei awero noinu Anutu meni nuai nuso ginu ewanana wenua. Are Dawidi meni Anutu Yakobo meni bowi inoisonua amira itai-matai tamamu sero Anutu begomo senua. ");
INSERT INTO sue_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ata Solomon meni Tua emo ibu wenua. ");
INSERT INTO sue_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ata Anutu bamubake ami ibu emara wana meni wai amira itai-matai oko inowia. Porofetera bera ge ego gayai itia ewa, ");
INSERT INTO sue_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Tua meni ego toya awa, ‘Utu awa arumai simaire naso awa. Ota zebu meni awa te guta wai naso. So naso nogo wai wawa te wamunoi? Ota itai-matai naso awa nogo nogo wai tamawa te wamunoi? ");
INSERT INTO sue_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Na wana naso meni nena dapikarago kaka tamamu weni, tanita? ");
INSERT INTO sue_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nikare ge dai ema. Dubare danare nisokare kaka keyamu diga emara ine. Ewowo-kawowo nisokare inoisowa da ago ine nikare inoise Ozanara ge dimai azu towewa. ");
INSERT INTO sue_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ewowo-kawowo nisokare meni porofete dapikarago kaka awa-diamu yaya potiwa awa. Ema Saramaira Mama kei awaise ge gita sewa ema dubu awa dai dewa betewa. Ota nikare nu awa betaise sero kereniro doisewa awa. ");
INSERT INTO sue_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Anutura lo ge angelora be meni sai awa ninekare pumuro kaka dimamu wisewa.” ");
INSERT INTO sue_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stiwen meni ge ago senu Yudara gita wai ema meni niniro tini gamai bamubake pumuwa. ");
INSERT INTO sue_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ata Stiwen nu Ozana meni moka nusora be munu iri utura nitinoise Anutura zasimai gosinoise Yesu Anutura wana mera dopero itinu giro ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Na utu be zaumi Emara Mai Anutura wana mera dopero iti gosinona.” ");
INSERT INTO sue_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ago senu ge guninoise dana wana meni gogowero dapikarago eriro muro nu saniwa awa. ");
INSERT INTO sue_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Saniro puro baro nata atura ena omata meni dewa. Ago inoise ema Stiwenre opi sewa ami tama woi nusokare dutero mai zo zazo nuso Saulo* amira nana dubu dewa. ");
INSERT INTO sue_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ago wero Stiwen omata meni doinoiwa begomo toise ego senua awa, “O Tua Yesu, ni ititi naso pumuyo.” ");
INSERT INTO sue_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ago sero bawa diro zawa gatero ego senua awa, “Tua, pasina nusokare ei awa diseyo.” Ago sero betenua. Dewa betenu Saulo meni ginu kokopai wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Are be da amire Yerusalem nate ena Yesura dubure gera iwo bamubake zaawewa. Ago wewa nukare bozero Yudaya zebura, o Samaria zebura bamuwa. Aposolo dubu meni gege kaka bozamu Yerusalem dago noisowa. ");
INSERT INTO sue_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ema eni Tuara gera ama inoise noisowa ami Stiwen gowero di bia bamu wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ata Saulo meni awa Yesura dubu gera-gaira inoise so sero witiro emare bamere dero zumuro puro benai sora potinua awa. ");
INSERT INTO sue_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yesura dubu bozewa ami nata sero noise Tuara ge tugata inoise noisowa. ");
INSERT INTO sue_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nusokare nana zo Filip meni Samaria emara nata giti kopi amira kei awero Kristora Oziga Ewanana awa tugata wenua. ");
INSERT INTO sue_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tugata wenu ema dubu bamubake meni ge nuso niniro tani putoure inoinua awa giro dana zaawero ge nuso niniro baitiwa. ");
INSERT INTO sue_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nu bi dainiro tunenu zawa gatero emara mokara ena kei awero bozero bamuwa. Ota nu zabura wewenaire te amaire awa kora wenu kokopai wewa. ");
INSERT INTO sue_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ago wenu nata amira yawa sara bamubake kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ata nata da amira ema zo noisonua zazo nuso Simon. Nu goe wai ema. Are nu nutope “Na ema bamubake” asero goe bua wasai Samaria ema dubu meni gasara nu witai inoisonua. ");
INSERT INTO sue_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Are ema witaita osai dapikarago ami dana zaawero ge nuso ninitinoise ego toisowa awa, “Ema ei awa Anutura putou bamubake numore potai awa.” ");
INSERT INTO sue_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nu be iboi-tatana goe nuso inoise emara duba sisinoisonua, are nukare dana zaawero ge nuso niniro awinoisowa. ");
INSERT INTO sue_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ata Filip meni Anutu imata Tua wero nuamunoya amira Oziga Ewanana tugata inoise Yesu Kristora ge uge tugata wenu niniro Yesu tuma diwa nu emare bamere ge ou gutenua awa. ");
INSERT INTO sue_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ago wenu Simon nu da ago Anutura ge nininu me wenu ge ou gutenu nu Filipre tairo noisonua awa. Ago noinu Filip meni tani putoure wasai giro di tainitinoise noisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria ema dubu nukare Anutura ge niniro duba nusokarera potiwa amira oziga meni Yerusalem nate aposolo dubura nana bamunu niniwa awa. Niniro giro Petoroto Yohanere Samaria zebura iyetiwa bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Baro kei aweroto Ozana meni nusokare nana toiro be maise Tua begomo sewato. ");
INSERT INTO sue_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nera kota, gita Ozana meni nusokare nana kaka osamu. Nukare Yesura zazora gege ge ou gutewa. ");
INSERT INTO sue_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Are aposolo eto wana nusoto giti nusokarera potiwato Ozana meni nusokare nana osero be munua awa. ");
INSERT INTO sue_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aposolo nuto emara nana gitine wana potiwato amira Anutu meni Ozana potinu pumuwa awa Simon meni giro moni puro bamu nusoto nana niro moni pumariseto sero ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nito Ozana potaira putou awa namore dai potawato wana naso ema zora nana gitine potana amire Ozana pumae.” ");
INSERT INTO sue_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ago senu Petoro meni numore ina ego senua awa, “Ozana potaira putou awa Anutu meni nupe potitinowia, putou awa nine moni meni zuma gaero pumamu tosa, are nima ata moni nisore dai gera wawiseto tona. ");
INSERT INTO sue_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Anutu meni duba niso gi te kaka wamu inoya. Are ni nakare tairo bua ewa wai sogo ine tepo. ");
INSERT INTO sue_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ni kotumai waya niso awa doro duba kapeteniro tani waya wamu kotupitinosa amira pasina Tua meni disaise isa seyo. ");
INSERT INTO sue_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ni duba-duba bamu wawesa pasinara mui meni ni beniro baitinu nowesa, awa gosinona.” ");
INSERT INTO sue_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ago senu Simon meni ina ego senua awa, “Nito na emo Tua begomo sawato nena towato awa naso nana oko kei awaise.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aposolo eto meni Yesura susu giwato amira ge kerenitinoise ema bama Tuara ge tugata wero amire Yerusalem nate ewesemuro bamuwato awa. Ewesemuro susawise Samaria zebura nata witai itiwa amira ana Oziga Ewanana tugata wero bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tuara angelo zo meni Filipre ego senua awa, “Ni sia wero ebata ike kena Yerusalem nate ena ose Gasa nate nitinowera ebata amira bamuyo.” (Ebata awa zebu erama tepo amira itia.) ");
INSERT INTO sue_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ago senu giro Filip meni eriro bamunua awa. Itiopia zebura bama tua bamu zo noisonua zazo nuso Kandasi amira soremai nuso zo nu bama tua bamu amira wau moni dia noisonua, nu ami Anutu bowi wamu sero bamu Yerusalem nate niro ");
INSERT INTO sue_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Anutu bowi wero noko tera nate bayamu sero karisira ewesemuro susawise ge porofete Yesaya meni gaenua awa azipitinoise susaunua. ");
INSERT INTO sue_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Susaunu Ozana meni Filipre ego senua awa, “Ni karisi omira zorage bamu, tairo bayase.” ");
INSERT INTO sue_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ago senu Filip meni sumuro baro tamuro ema nu porofete Yesayara ge gayai awa azipitinoinu giro atata wero senua awa, “Ge azipitinosa amira susu gosinosita?” ");
INSERT INTO sue_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ago senu ema ami ina ego senua awa, “Ema zo meni na kaka tugata wamu wai na natope nogo nogo wero gera susu ninamunoni?” Ago sero Filip wara witaise senu wara witiro arumunu eroma bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ge gayai azimunua awa ego ewa, Lama zo dero azamu sero puro susawewera ago ine nu awa. Ota lamara tu kapamu sero wawera ge amu inowera ago ine nu ge kaka samu wenua. ");
INSERT INTO sue_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nukare nu isimuwa. Nukare koto inoise ge me numore oko sewa. Zebura nuai nuso kapewa tepo wenua, are ai meni dubu nusora ge uge wai te inoi? ");
INSERT INTO sue_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Are ema giti kopi meni Filip atata wero senua awa, “Nine se ninane. Porofete nu are ago senu? Numoreta ema zore senu?” ");
INSERT INTO sue_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ago senu Filip meni porofetera ge awa puro Yesura nana potiro Yesura Oziga Ewanana tugata wenua. ");
INSERT INTO sue_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ago sero susaumiteto ou butu zora kei aweroto ema iti kopi ami ego senua awa, “Gi. Ou itia ewa. Na ge ou gutasa te wamunoita?” ");
INSERT INTO sue_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ago senu Filip meni ina ego senua awa, “Ge tugata wetena awa ziro tata-tata wasa giro na ni ge ou gutana te wamunoya.” Ago senu ina ego senua awa, “Yesu Kristo nu Anutura Mai me awa ziro tata-tata inona.” ");
INSERT INTO sue_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ago sero wo dopariseto senu dopewato nuto Filipre ose oura niwato awa. Osero Filip meni ema awa ge ou gutenua. ");
INSERT INTO sue_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ago wero oura ena wititinoiwato Tuara Ozana meni Filip tutamu puro ewe bamunu ema giti kopi meni Filip kaka gamu wero nu yawa sara inoise ebata nusora bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ota Filip nu Azoto nate kei awenua awa. Kei awero ana zaawero nata sero ge tugata wero susaumite Sisaria nate kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo nu Tuara dubu gera-gaira inoise dai betarise sero moka nusora goroba kei awenu giro bua waira peu wenua. Ago wero bamu pris bamura nana niro ");
INSERT INTO sue_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","pas potaise senu giro pas gaero potinua awa. Pas awa Yuda dubu Damaskas nate noisowa amira yere ibura potiro Saulora nuai nusore buare kereninua awa. Kereniro Tuara Ebata Sekara nuara tamuro beniro puro mu Yerusalem nate naise sero gaenua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Are nu pas awa puro susaumite Damaskas nate zorage awinoinu zasimai zo meni utura ena tutamu osero nuso nana gaenua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Gaenu Saulo zebura duro itise ge ego nininua awa, “Saulo, Saulo, ni nogoro na dero tuninoise nowesi?” ");
INSERT INTO sue_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ago senu Saulo meni atata wero senua awa, “Tua, ni aweni?” Ago senu Tua meni ina ego senua awa, “Dero tuninoise nowesa Yesu na awa. ");
INSERT INTO sue_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ata ni eri. Nate bayasa nena wasise sai itia, awa tugata wamunora awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ema numore dai tupiwa ami ge tepo wenu dopewa. Nukare ge gege niniwa awa. Ata emara giti moka meni awa kaka gamu wewa. ");
INSERT INTO sue_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Are Saulo nu zebura ena eriro giti panero so ginu mume gege wenua. Ago wenu ema dubu nuso meni wana ziro puro bamu Damaskas nate niwa ");
INSERT INTO sue_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","waiko be etorobara giti guma wenu nenare oure kaka namu itinua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskas nate Yesura dubu amira zo noisonua zazo nuso Anania. Nu atua ine inoinu Tua meni nu zawa senua awa, “Anania.” Zawa senu Anania meni ego senua awa, “Tua, na ewa.” ");
INSERT INTO sue_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ago senu Tua meni numore ego senua awa, “Ni eri. Ebata zazo Sonai asinowera amira baro ema zo zazo Yuda amira nana sora witiro ema zo zazo nuso Saulo, nu Taso natara, nu awa tamamunosa. Nu isa toise itia. ");
INSERT INTO sue_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nu atua ine inoise nena ego ine gia: Ema zo zazo nuso Anania ami nuso nana kei awero giti panaise wana nuso gitine potia.” ");
INSERT INTO sue_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Tua meni ge ago toise tugata wenu Anania meni ina ego senua awa, “Tua, ema amira uge waya diawera gosinowena. Nu Yerusalem ena dubu nisora nana eni dainiro gera-gaira inowia. Agoro nakare nata emira da ago zazo niso bowi inowenakare awa dai beniro puro bayaise pris babezinoma meni ge gaitara awa.” ");
INSERT INTO sue_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Anania meni ago senua, ata Tua meni ego senua awa, “Ni ago bayasise tona. Ema awa bua mai naso pupinona. Are nune zazo bowire naso puro ema Yudakora nanata ema tuara nanata Isreli dubura nana puro sero sero susawiaise. ");
INSERT INTO sue_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nu zazo bowire naso tugata wamu yayare duba naire nuamunoya, awa nane gipana gamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ago senu Anania meni baro so senua amira witiro wana nuso Saulora gitine potiro ego senua awa, “Saulo, otao naso, Tua ebete ena niso nana kei awisia, nu awa Yesu awa. Nu ami na iyeti niso nana tupena ewa. Ni giti panasa Ozana meni niso nana be mai nuase.” ");
INSERT INTO sue_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ago senu Saulora giti mokara ena wo tata ine osenu giti panenua awa. Ago wero eriro senu ge ou gutewa awa. ");
INSERT INTO sue_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ago wenu nena niro putou pumunua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Saulo meni Yesura dubu Damaskas noisowa amire dai waiko be eni ago noisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ago noise awita sero Yuda emara yere ibu ago itisowa amira baro toiro Yesura oziga kereniro tugata inoise ego toisonua awa, “Yesu nu Anutura Mai.” ");
INSERT INTO sue_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ago tugata wenu niniwa te kaka wamu wenu nukare nutopekare ego ina-sa wewa awa, “Ema ami Yerusalem nate ena Yesura zazo amira isa towera dubu awa giro gera-gaira inowia. Ota ena da ago nu Yesura dubu awa beniro puro pris babezinoma nana bayamu musia, nu ami mia awa.” Ago ina-sa wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ata Saulo meni zewai-zawai wero Yesu nu Soyai Ema Kristo me amira ge susure sero baitiro Yuda ema Damaskas nate noisowa awa tugata wenu niniro ne seri wero dowa. ");
INSERT INTO sue_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ago inoe donu Yuda ema auniro Saulo damu sero ge diwa dagimunua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ge diwa dagimunua, ata Saulo meni ge awa nininua awa. Nukare Saulo damu sero natara toyai be sero pire waikore uma inoise noisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ago inoiwa giro Saulora dubu meni pire nu kanera peniro natara goma atune potiwa osero bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo meni baro Yerusalem nate kei awero Yesura dubu amira nana susumamu senu giro azu wewa. Awa nera kota, nu Yesura mai wenua awa giwa me kaka wamu wenua. ");
INSERT INTO sue_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Azu wewa giro Banaba meni Saulore otao wero aposolo dubura nana puro baro Tua meni ebete ena Saulora nana kei awero ge tugata wenu Damaskas nate ena azu tepo Yesura Oziga Ewanana kereninua amira uge dinua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ago wenu Saulo nu numorekare dai noise Yerusalem nate ena izima-sauma inoisonua. ");
INSERT INTO sue_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ago itise Tuara ge awa emare azu kaka wamu tugata inoisonua. Ago wasai Yuda ema Grik ge ninai ami numore dai Tuara ge awa toise ge ina-sa inoisowa awa. Ago inoise Saulo damu sero ebata tamamu sero wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ago inoiwa giro otao mamai nuso meni nu uzumuro puro baro Sisaria nate kei awero wara potiro iyetiwa bamuro Taso nate kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nukare Saulo iyetiwa bamunu amire Yesura dubu Yudaya zebura ata Galilaya zebura ata Samaria zebura noisowa nusokare nana gera bega kei awenua awa. Begare noise gera putou poti dara niro zewai wewa. Ago wero Tuara zazo de ike nitinoise noisowa. Ago inoiwa Ozana meni nukare soremunu ema bama witai Yesura dubure tairo noisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petoro nu buara izima-sauma inoise noe osero Yesura dubu Lida nate noisowa amira nana kei awenua. ");
INSERT INTO sue_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ago kei awero ema zo zazo nuso Ainia awa ginua. Nu zabura wero iteye donu zepa 8 wenua. ");
INSERT INTO sue_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Are Petoro meni numore ego senua awa, “Ainia, Yesu Kristo meni ni kora inoya. Are eriro sawa niso boze.” Ago senu eya erinua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ago wenu Lida natara ata Seron garawira ema bama meni giro duba kapeteniro Tuara dubu wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yesura dubu amira nana bama zo Yopa nate noisonua, zazo nuso Tabita. Grik gera Dokas. Nu dumi pumai inoise kora wai bua dainiro inoisonua. ");
INSERT INTO sue_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Are Petoro nu Lida nate noinu Tabita yaya puro betenua awa. Betenu woi nuso sewero so moka zora puro witiro potiwa. ");
INSERT INTO sue_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida nata awa Yopa nata zorage itinua, are Yesura dubu meni Petorora bowi niniro ema eto iyetiwa nuso nana baro ego sewato awa, “Nato ni puro nata nasokarera eya bayanekai.” ");
INSERT INTO sue_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ago sewato Petoro meni ge awa niniro peu wero ema eto amire dai bamuwa awa. Baro kei awenu bama betai itinua amira nana sora puro witiwa awa. Witi sora niro bama kuma dapikarago Petoro zimuro di toise mo wapere tama woire Dokas meni seka noise gaenu pumuwa awa gipewa. ");
INSERT INTO sue_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ago wewa Petoro meni nukare eseninu ose dura niwa bawa diro isa senua. Isa sero tepo wero iri betaira nana niro ego senua awa, “Tabita, ni eri.” Ago senu giti panero Petoro giro eriro arumunua. ");
INSERT INTO sue_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Arumuro itinu Petoro meni wana ziro senu eriro dopenua. Ago wenu nu Yesura dubure bama kuma enire zawa senu witiwa Tabita nu seka wenua awa nusokare nana wanera potinua awa. ");
INSERT INTO sue_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Amira bowi meni baro Yopa natara te wenu dainiro meni Tua tuma diwa. ");
INSERT INTO sue_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petoro nu Yopa nate itise ema zo zazo Simon, nu wo aiso bua wai ema, amira sora be dainiro noisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaria nate ema zo noisonua zazo nuso Konilio. Nu Itali zebura soldia amira zo. Nu soldia 100 amira dia noisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nu ata awiso nuso nukare Anutu sou inoise etutiro noisowa awa. Ago inoise Yuda ema bama bogamasa amire dumi pumai bua dainiro inoise Anutura nana eyaya begomo sai gege toise noisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ago inoe waiko be zore tuwe 3 klok amire nu seka itise atua ine wero Anutura angelo zo meni nuso nana sora toinu ginua awa. Ago gosinoinu angelo meni zazo nuso zawa sero ego senua awa, “Konilio.” ");
INSERT INTO sue_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Zawa senu ua inoise azu wero titibi awero ego senua awa, “Tua, nogoro tosi?” Ago senu angelo meni numore ego senua awa, “Isa nisore dumi pumai nisore Anutura nana bayawi giro yaba inowia. ");
INSERT INTO sue_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Are ni soumai eni iyetasa bamu Yopa nate niro ema zo zazo nuso Simon Petoro awa tamuro puro mare. ");
INSERT INTO sue_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ema awa ema zo zazo nuso Simon, nu wo aiso bua inowia, amira nana sora itewia. So awa ewa bera itia.” ");
INSERT INTO sue_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Angelo ge awa tugata wero doro bamunu nu soumai nuso etore soldia nu sou inoisowa amira nana zo Tuara gera nuai amire nukare etorobara zawa senu muwa ");
INSERT INTO sue_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ge uge wero pesuniro Yopa nate iyetinu bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mai iyetinu susaumite ebete awinoiwa pina atinu noko susaumite nata tamamu sero inoiwa waiko soe dopenu Petoro meni begomo samu sero so tame witiro ");
INSERT INTO sue_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","begomo tomite meri betero senu nena sawinoiwa nu atua ine inoinu Tua meni numore nena ego gipenua awa: ");
INSERT INTO sue_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Utu zaumunu nena zo mo ine bamubake oko nuso zoeto-zoeto amira diai gamai awa zebura potiwa nuso nana osero munua. ");
INSERT INTO sue_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mo amira mokara ena wo eure-taure ata zi eure-taure ata ni eure-taure ami itiwa. ");
INSERT INTO sue_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Osenu ge zo ego kei awenua awa, “O Petoro, eriro dero azero ni.” ");
INSERT INTO sue_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ago senu Petoro meni ina ego senua awa, “Tua, ago oko sase. Na nena sienai waya awa oko ninowena.” ");
INSERT INTO sue_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ago senu ge noko ego kei awenua awa, “Anutu meni nena sewero kora inoya awa waya oko asase.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ge awa kei awenu be etorobara wenu amire eya noko zumuwa witiro bamu utura ninua awa. ");
INSERT INTO sue_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petoro nu nena awa atua wago wero ginua, are susu gamu sero kotumu-katumu inoise itinu Koniliora ema nukare nate kei awero Simonra so kau inoise atata wero susaumite so tamuro so bera dopewa awa. ");
INSERT INTO sue_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Dopero zawa toise ego sewa awa, “Simon zazo nuso zo Petoro nu so emira itita?” ");
INSERT INTO sue_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petoro nu nena ginua awa kotumuro susu gamu inoise itinu Ozana meni numore ego senua awa, “Ema etorobara muro ni kau inora, awa gi. ");
INSERT INTO sue_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Are ni eri. Osero numorekare dai bayamu sero inoise kotumu-katumu oko wase. Ema awa nane sesena mera awa.” ");
INSERT INTO sue_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ago senu giro Petoro meni nusokare nana osero ego senua awa, “Na kau inowa na ewa. Nera tupewi?” ");
INSERT INTO sue_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ago senu nukare ego tugata wewa awa, “Soldiara dia ema Konilio ami nakare iyeti tupenakare. Nu Anutu sou inoise etutiro nowia. Agoro Yuda ema numore gawera te inowia. Nu awa Anutura angelo zo meni nuso nana kei awero ni so nusora uzumuro be nisora ena ge eni ninaise sasaya.” ");
INSERT INTO sue_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ago sewa giro Petoro meni nukare kora-makora wenua awa. Kora wenu awinoiwa pina atinu nu ata Yopa natara ge ninai eni ata ema ona muwa amire dai bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nukare ebete ena pi daimata auro kei awe Sisaria nate niwa. Konilio nu sedikai nuso ata otao mamai nusore senu mu dara niwa nukare dia itiwa kei awewa. ");
INSERT INTO sue_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kei awero Petoro meni sora toyamu sero inoinu Konilio meni zorage muro nuso nana tera bawa diro yawa sara bamubake wenua. ");
INSERT INTO sue_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ago wenu Petoro meni eraise ego senua awa, “Ni eri. Na ema ni ago ine awa.” ");
INSERT INTO sue_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ago senua awa. Ago sero ge uge-mage weroto sora toiro ema auniro itiwa awa giro ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","“Nikare susu nasokare Yuda emara gosinowewa. Nakare ema Yudako amire tairo nuaita esewa we nisokare nana nai awa azu sai ge itia awa. Ata Anutu meni susu awa namore gipitaya, are na ema zo da di amire bemitire asero azu oko samunona. ");
INSERT INTO sue_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Are na manise uzumewa maira oko mou wetena. Are manise uzumewa tupena amira susu seu gane.” ");
INSERT INTO sue_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ago senu Konilio meni ego senua awa, “Awisenakai omire nena naso nana kei awisia amira uge wana giyo. Zeme waiko diti 3 klok inoya, da ago be amire waiko diti da ago inoisia. Waiko diti 3 klok inoi na isa toise itena ema zo tama woi nuso zasimaire ami naso nana tutamu kei awisia. ");
INSERT INTO sue_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kei awero namore ego sisia awa, ‘Konilio, Anutu meni isa niso ninitinoise dumi pumai niso giro nimore yaba inoya. ");
INSERT INTO sue_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Are ni ema iyetasa Yopa baro Simon zazo nuso zo Petoro awa puro marise. Nu ema zazo Simon wo aiso bua inowia amira nana sora itewia. So nuso ewa bera itia.’ ");
INSERT INTO sue_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ago sesi giro na ema eya iyetena niso nana bamisera. Amira ni ge naso niniro mesa nama duba naso kokopai inoya. Are Tua meni ge nimore tugata wisia awa te sasa ninamukare dapikarago Anutura giti mokara auniro itenakare ewa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petoro nu be peu wenu ge ego tugata wenua awa, “Anutu meni eramara tama gege gosinoise oko awina-dawina inowia, awa zeme gena me inoya. ");
INSERT INTO sue_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ema dubu giti amira nana eni meni nu sou inoise etutiro nowera nukare awa Anutu meni gawi te inowia. ");
INSERT INTO sue_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Oziga Anutu meni Isreli emare potinua amira bowi awa nikare ninitinowewa. Yesu Kristo, nu ema dapikaragora Tua, nu ami bega pumunua amira Oziga Ewanana Anutu meni kereniro poti damu ninua awa. Gita Yohane meni ema bama ge ou gutinoise ge tugata inoisonua be amira ana ");
INSERT INTO sue_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","oziga ami Galilaya zebura ena zaawero bamuro Yudaya zebura te wenua, awa gosinowa awa. ");
INSERT INTO sue_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ge ego emira tona. Anutu meni Yesu Nasarete natara buara potitinoise Ozana nuso nana iyetinu toinu Anutura putou pumunua awa. Putou pumuro izima-sauma inoise ema soremuro bua inoise eni Satan meni gera wenu waya wewa awa dapikarago kora inoisonua. Awa nera kota, Anutu meni nu soga wasai bua inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Bua nu Yuda zebura ata Yerusalem nate ena inoisonua amira oziga sai ema nakare awa. Nukare nu puro nira dewa betenua awa. ");
INSERT INTO sue_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Betero bi ditira itinu waiko be etorobara tepo wenu Anutu meni awa-uzenu seka wero eriro kei damu ninua. ");
INSERT INTO sue_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kei damu ninua, awa Yuda ema dapikarago amira nana kota, ema oziga sai ema nakare Anutu meni gita nuso sianiro pumunua nasokare nana gege kei awenua. Nakare numa betaira ena seka wero erinu numore dai nena ninakare awa. ");
INSERT INTO sue_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ota Anutu meni Yesu ema betaire seka nuaire amira zas bamu nasokai potinua, amira bowi ge awa ema dubu giti amira nana kereniro sanisekare senua awa. ");
INSERT INTO sue_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yesu tuma diamunora nukare awa Anutu meni Yesura zazo bowire emo inoise pasina nusokare disamunoya. Awa porofete dapikarago meni kereniro tepo wewa awa.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petoro nu ge ago toise dopero itinu nukare Oziga Ewanana ninitinoise itiwa Ozana meni osero nusokare nana toinua awa. ");
INSERT INTO sue_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ago wenu Yuda ema ge ninai Petorore dai bamuwa nukare Anutu meni ema Yudakore dai Ozana potinua awa giro di tainiwa awa. ");
INSERT INTO sue_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Di tainiwa, nera kota, ema Yudako nukare ge ewe-pape Ozana meni tapinowia awa toise Anutu bowi inoiwa niniwa awa. Ago wewa Petoro meni ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ozana nasokai nana toinua da ago ine nusokare nana toia, are ge ou gutai awa soyai ine oko itia.” ");
INSERT INTO sue_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ago sero senu ema nukare Yesu Kristora zazora susumuwa ge ou gutewa. Ago wewa nukare Petoro soewa waiko be eni numorekare dai ago itisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposolo eni ata Tuara dubu Yudaya zebura noisowa nukare ami ema Yudako dai Anutura ge niniwa amira bowi niniwa awa. ");
INSERT INTO sue_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Are Petoro meni Yerusalem nate ewesemuro witinu Yuda ema eni ema Yudakora tama aiso kapamu toisowa ami nu senero ego sewa awa, ");
INSERT INTO sue_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ni nogoro baro ema Yudako tama aiso kaka kapamu amire dai nena ninoisesi?” ");
INSERT INTO sue_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ago sewa Petoro meni ena kei awenua amira uge susura ena tutuku-tataka niro dinua awa. Diro ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Na Yopa nate ena begomo toise itena Tua meni kotumai naso kapeteni atua ine inoise nena ego ine goisena awa. Nena zo seli ine bamubake oko nuso zoeto-zoeto amira diai gamai awa utura ena potera osero muro naso nana zorage kei awisia awa. ");
INSERT INTO sue_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ago weti giro susu nuso gamu sero iri ago niro ua inoise mokara ena wo eure-taure — nata wore, di wore, zire, ni mamaire — itera goisena awa. ");
INSERT INTO sue_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Agoro naso nana zawa ego kei aweti ninisena awa, ‘Petoro, eri. Dero azero nase.’ ");
INSERT INTO sue_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ge ago kei aweti nane ego sisena awa, ‘Tua, ago oko sase. Na nena sienai waya awa oko ninowena.’ ");
INSERT INTO sue_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ago sesena utura ena ge ego ine noko kei awisia awa, ‘Anutu meni nena sewero kora inoya awa waya oko asase.’ Ago sisia awa. ");
INSERT INTO sue_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nena awa kei aweti be etorobara weti amire seli nenare awa zumera noko ewesemuro utura witisia awa. ");
INSERT INTO sue_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nena tepo inoi amire Sisaria nate ena ema etorobara awi puro naso nana baro so itisena amira kei awisera awa. ");
INSERT INTO sue_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kei awetera Ozana meni namore ego sisia awa, ‘Ni numorekare bayamu inoise kotumu-katumu oko wase.’ Ago sesi otao 6 meni namore dai baro kei awero Koniliora sora witisenakare awa. ");
INSERT INTO sue_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Witenakare ge uge ego ine wisia awa, ‘Angelo meni so nasora witiro namore ego sisia awa, “Ni Yopa nate mai iyeti baro Simon zazo nuso zo Petoro awa sero puro mare. ");
INSERT INTO sue_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Puro mara ni ata dubu niso nikare ge tugata wai ninawa Anutu meni nikare soero pumamunoya.” Angelo namore ago sisia.’ ");
INSERT INTO sue_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Konilio meni ago sesi giro na ge tugata inoise itena, gita Ozana nasokai nana osenua, da ago ine nusokare nana osisia awa. ");
INSERT INTO sue_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Osesi giro nane Tua meni ge ego senua awa kotupisena awa, ‘Yohane meni nikare ge ou gutinowia, ata Anutu meni Ozana nimorekare potamunoya.’ ");
INSERT INTO sue_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nakai Tua Yesu Kristo tuma dinakai Ozana namorekai potinua, Ozana da awa numorekare poti giro na osai ego emi nogo wero Anutu azu samunoni?” ");
INSERT INTO sue_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Petoro meni ago toise nukare tugata wenu niniro wama nusokare ozenu Anutu bowi inoise ego sewa awa, “Are Anutu meni ema Yudako dai duba kapeteniro nuai me ewanana amira gegenai wero nuarise towia awa.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Iwo meni Stiwen dero Yesura dubu amira nana eni dero tunewa bozero eni Fonisia zebura ata Saipras gutura ata Antiok nate bamuwa awa. Baro noise Tuara ge awa Yuda emare gege tugata wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ago inoiwa nusokare nana mokara Saipras guturata Sairini zebura ge ninai ema noisowa nukare ami Antiok nate kei awero ema Yudakore dai sero niniro awinoise Tua Yesura Oziga Ewanana tugata wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tuara putou nusokare nana itinua, are ge tugata wewa ema dubu bamubake meni ge awa niniro Tua tuma diro dubu nuso wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Dubu nuso wewa amira bowi awa Yesura dubu Yerusalem noisowa ami niniro Banaba iyetiwa Antiok nate bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Baro kei awero Anutura dumi yagaba nusokare nana itinua awa giro yawa sara inoise duba nusokare meni Anutu ziro baitarise sero nukare uzupitinoise ge tugata-magata wenua. ");
INSERT INTO sue_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba nu ema kokopai. Moka nusora Ozanare tuma diaire be munua. Are nata amira ema witai ami Tuara nana susumuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Are Banaba nu Saulo tamamu sero Taso nate bamunua. ");
INSERT INTO sue_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Baro tamunu eroma Antiok muwato awa. Nuto Yesura dubu amira nana zepa zo noise ema dainiro ge tugata inoisowato awa. Yesura dubu Kristen asinowera, zazo awa Antiok nate ena mena sewa zewai wenua. ");
INSERT INTO sue_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Be amire porofete ema eni meni Yerusalem ena eriro bamu Antiok nate niwa awa. ");
INSERT INTO sue_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nusokare nana ema zo zazo nuso Agabo, nu Ozana meni moka nusora dopero ge senu giro zebu sero dora botiyo bamubake kei awaise amira ge senua. (Dora botiyo awa Roma ema tua Klodio noinua amire kei awenua.) ");
INSERT INTO sue_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Are Kristen dubu nukare ge awa niniro moni sia wero poti dara niro Yudaya zebura otao mamai emo potara bayaise sewa zewai wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Are moni poti dara niwa awa Banabato Saulora nana wanera potiwa puro baroto Tuara dubu amira simai wero noisowa amire potiwato pumuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Be amira ana ema tua Herode meni Yesura dubu amira ema bama eni dero gera-gaira wero puro benai sora potinua. ");
INSERT INTO sue_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ago inoise senu Yohanera nami Yakobo awa kasiwa meni dewa betenua awa. ");
INSERT INTO sue_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ago wenu Yuda ema yawa sara wewa giro pasina zo susumuro senu Petoro dai beniro benai sora potiwa awa. Be awa Betai Daininua amira pura zora awenu Yuda ema yis sieniro noiwa amire beninua awa. ");
INSERT INTO sue_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herode meni Petoro beniro ego kotumunua awa, “Betai Daininua amira pura nusokare tepo wai amire na Petoro damu sero puro emara giti mokara koto wamunona.” Ago kotupitinoise senu benai sora potiwa soldia dubu 4 meni dia wewa. Dubu zo soldia 4, dubu zo soldia 4, ago ine wero nu dia wewa. ");
INSERT INTO sue_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Petoro benai sora itinu Tuara dubu meni nu emo begomo susumuro susumuro toiwa Anutura nana witai gege wititinoinua awa. ");
INSERT INTO sue_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Koto waira be zora awenu Herode meni ego kotumunua awa, “Pina atai na Petoro puro kei awana gamunora.” Ago kotupitinoise awinoinu pi amire soldia eto meni Petoro sen eto meni beniro puro awinoiwato, soldia eni meni awa so be atune dopero benai so dia wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Dopero itiwa Tuara angelo zo meni so mokara ena tutamu kei awenua. Kei awenu so moka zasi tamere ninua. Angelo meni Petoro awa-uzero ego senua awa, “Eya eri.” Ago tuaise Petorora wanera ena sen besewato awa. ");
INSERT INTO sue_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Sen besero osewato angelo meni Petorore ego senua awa, “Ipu gei niso diro sandol tera poti.” Ago senu wenu amire angelo meni noko senua awa, “Tama woi niso iboi wosuniro na ama gane.” ");
INSERT INTO sue_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ago senu giro ama ganinoise angelo meni tani inoinua awa ginu tani me kota atua ine wenua. ");
INSERT INTO sue_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nuto susaumiteto soldia zo dainiro noko zo dainiro susaumiteto so be nata kakame bayai aen meni wai amira kei awewato so be nutope piakaninu pusumuro kei damu niwato awa. Kei damu niro bamuroto ebata zo dainiroto angelo tutamu tara awenua. ");
INSERT INTO sue_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ago wenu Petoro nu kotumai kei awenu senua awa, “Zeme gosinona. Tua nu angelo nuso iyeti Herodera wanera ena o noko tani Yuda ema meni namore wamu tora amira ena soero pupinoya.” ");
INSERT INTO sue_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Asero susu me giro bamuro Yohane zo zazo nuso Mak amira mia zazo Maria amira nana sora kei awenua. So amira ema bama dainiro meni auniro begomo toise itiwa. ");
INSERT INTO sue_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ago inoiwa Petoro baro damu dopero toyai be denu au bama zo zazo nuso Roda nu, “Ai toyai be doinoi?” asero kei awenua. ");
INSERT INTO sue_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kei awero Petorora ge bapu niniro yawa sara inoise toyai be kaka piaka namu doro kapeteniro toiro, “Petoro muro toyai be atune dopero itia,” asero nukare tugata wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tugata wenu niniro ego sewa awa, “Ni duba dau inoiwa.” Ago sewa nu ge beina wero senua awa, “Nu me dopero itia ewa.” Ago senu nukare ego sewa awa, “Awa ititi nuso, tanita.” ");
INSERT INTO sue_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ago ina-sa inoiwa Petoro meni toyai be kikiri wai gege inoise itinu giro toyai be piero nu giro nukare ge tepo wewa. ");
INSERT INTO sue_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ago wewa Petoro meni ge duarise wana sapikore awero Tua meni benai sora ena besero puro munua amira ge uge wero pesuniro ego senua awa, “Nikare ge uge naso awa Yakobo ata otao mamai eni tugata weu ninare.” Ago sero nukare doro agewa zora bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pina atinu soldia meni Petoro kau wero nena nemi nogo weti asero kotumai kaka pamu wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herode meni tamarise senu kau wai bua wewa tepo wenu giro soldia Petoro dia itiwa awa dara betarise senua awa. Ago sero amire nu Yudaya zebu doro osero bamu Sisaria nate niro noisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herode nu be amira ana nata eto Tayato Saidonre amira ema iwo wenua. Are nata amira mamana nukare da wero nu gamu bamuwa awa. Baro kei awero ge kora wamu sero Herodera ema giti kopi zo zazo nuso Bilasto amire ge sero uzutiwa giro nukare soremunua. Gita nukare Herodera zebura ena wo ma zuma gaero pupinoisowa, are ge kora wero noko tairo nuamu sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ge kora wamu sewa Herode meni ge ina saira be potinua. Be awa munu giro tama nuso simena-gaena wero ema tua arumai zara nusora arumuro itise ge tama puro witaira toise ema tugata wenua. ");
INSERT INTO sue_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tugata wenu ema dapikarago ami arero ego sewa awa, “Ge awa ema zora ge ine kota, Tuara ge ine inoya.” ");
INSERT INTO sue_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ago sewa Herode meni emara ge azu kaka samu Anutu daininua, are Tuara angelo zo meni nu eyane dago wenua. Ago wenu zipa meni niwa betenua awa. ");
INSERT INTO sue_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Anutura ge meni awa wisika asero so sero bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabato Saulore Yerusalem nate ena bua sai awa te wewato tepo wenu nuto Antiok nate ewesemamu inoise Yohane zo zazo nuso Mak awa pumuro eroma bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Yesura dubu Antiok nate noisowa amira mokara porofete emare gipai emare ego ami noisowa: Banaba, Simion zazo nuso zo Naiza, Lusias nu Sairini natara, Saulo, ata Maneyen. Nu ata ema tua Herode nuto awa ziro bazai. Ema ago ami porofete ema ata gipai ema wero noisowa. ");
INSERT INTO sue_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nukare waiko be zore nena sieninoise Tua bowi inoiwa Ozana meni ge ego senua awa, “Banabato Saulore bua ge sena awa wariseto na emo inoise buara potiu.” ");
INSERT INTO sue_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ago senu nena sieniro isa tomite wana nusokare giti nusotora potiro gawa wero buara iyetiwa bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ozana meni nuto buara iyetinu giro ose ewa bera niro susaumiteto Selusia nate kei awewato awa. Ago kei awero wara witiro susaumiteto Saipras gutura kei awewato awa. ");
INSERT INTO sue_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ago kei aweroto nata giti kopi Salamis amira baroto Yuda emara yere ibu eni amira toiro Anutura ge tugata wewato awa. Yohane zo zazo nuso Mak ami numoreto dai noise nuto soremunua. ");
INSERT INTO sue_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nukare ana eriro aita wero gutu busero Pefos nate kei awewa. Ago kei awero goe wai ema zo zazo nuso Bara-Yesu awa tamuwa. Nu Yuda ema. Nu nutope, “Na Anutura porofete zo,” asinoise noisonua, ata nu Anutura porofete oko aewa. ");
INSERT INTO sue_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ema ami dia ema bamu zo zazo nuso Sezias Polas amira otao noisonua. Dia ema nu kotumai bamure. Nu Anutura ge ninamu sero yaba wero Banabato Saulore uzumunu so nusora witiwato awa. ");
INSERT INTO sue_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nu nuto uzumunu witiwato goe wai ema Elima (zazo awa Grik ge. Grik ema meni goe wai ema dapikarago awa Elima asinoisowa), nune dia ema Tuara ge soinoise nuto azu senua awa. ");
INSERT INTO sue_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ago wenu Saulo, zazo nuso zo Paulo asinoisowa, nuso nana Ozanara putou bamu kei awenu nu Elima ua inoise ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ni Satanra mai. Ni etutiro nuaira iwo ema. Duba nisora etetenaire wayare meni be mai. Ni Tuara ge me kapetenasa opi waise inowesa. ");
INSERT INTO sue_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Are Tuara putou ina niso nana zeme kei awinoya. Ni giti guma wamunoya. Waiko be enire noise waikora zasimai kaka gamu nuamunosa.” Ago senu eya giti guma wenu zaru-zaru inoise wana meni zigi-zigi inoise ema zo wana nuso ziro ebata gita waise ema kau wero bamunua. ");
INSERT INTO sue_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tani awa kei awenu dia ema meni giro Tuara ge ginu putoure wenu giro Yesu tuma dinua awa. ");
INSERT INTO sue_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo ata ema mamai nuso nukare Pefos nata doro noko wara witiro susaumite baro Pamfilia zebura nata zo zazo Pega amira kei awewa. Ana Yohane Mak meni nuto doro Yerusalem nate ewesemuro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ago wenu nuto Pega nata doro susaumite Pisidia zebura Antiok nata zo amira kei awewato. Kei awero ago noiwato Sabat pura zo munu giro nuto Yuda emara yere ibura toiro arumuro itiwato awa. ");
INSERT INTO sue_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ago itiwato yere ibura simai meni lo gere porofetera ge gayai eni awa azimuro tepo wero mai zo sewa baro numoreto ego senua awa, “Otao, Tuara ge susu eni kotupitinowitota, awa seuto ninanekare.” ");
INSERT INTO sue_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ago sewa Paulo meni eriro ge duarise wana meni sapikore awero ego senua awa, “Isreli otao mamai naso, nikare ata eni Anutu sou inowewa, dapikarago sana niniu. ");
INSERT INTO sue_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nakai Isreli ema amira Anutu meni ewowo-kawowo nasokai pumunu Izip zebura noiwa senu wisika asewa. Ago wewa putou nuso meni ana uzumuro puro munua. ");
INSERT INTO sue_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ago wero ware puro noise wo ma meni uninuasai noe dowa zepa 40 wenua. ");
INSERT INTO sue_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ago wero Kenan zebura ena ema dubu 7 itisowa, awa dero tepo wero senu ewowo-kawowo nasokai meni zebu awa zazaumuro mamere mamere wero puro noisowa awa. Ago wero noe dowa zepa 450 tepo wenua. ");
INSERT INTO sue_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kenan zebura noiwa gita wai ema potasai puro noe dowa porofete Samuel kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kei awenu ema tua pumamu sewa giro Anutu meni Benzaminra dubura ena Kisira mai Saulo senu ema tua nusokare wero zepa 40 nukare gita wero noisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ago wero noinu Anutu meni senu Saulo nu ema tua waira bua donu nu Dawidi awa ema tua nusokare potinua. Potiro numore ge ego senua awa, ‘Zesira mai Dawidi kotumai nato da awa, are sana ge naso dipinuamunoya.’ ");
INSERT INTO sue_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ago senua, are Dawidira saisibuna amira nana zo Isreli ema nasokai nana Soyai Ema zo kei awaise Yesu potinua awa. Ge gita senu zewai wenua awa me waise Anutu meni senu Yesu kei awenua. ");
INSERT INTO sue_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu emara nana soe kaka kei awamure, gita Yohane meni Isreli ema dapikarago duba nusokare kapetenara ge ou gutamu sero ge tugata inoise noisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohane meni bua nuso sai awa inoe pesunamu inoise ema ge ego tugata wenua awa, ‘Nu sia sero namore towewa, na ema awa oko aewa. Nu ama mamunoya. Nu witai, are nane sandol nuso dutana te oko wamunoya.’ Yohane meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Otao mamai naso, Abrahamra saisibuna nikare ata eni Anutu sou inowewa, sana niniu. Anutu meni nakai kora inoya amira oziga awa nasokai nana potinu kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yerusalem nate nowera nukare ata giti kopi nusokare ami Yesu nu Soyai Ema awa kaka giro baitamu inoise porofetera ge gayai awa Sabat pura sero azimuro niniro awinowera, awa dai kaka gamu inoise nu iwora wanera potiwa. Nukare ago wewa porofetera ge awa me wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nukare pasina nuso kau inoise susu zo kaka tamamu wewa. Ata saineba asero weso wero Pilato meni tepo dai betaise sewa. ");
INSERT INTO sue_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ago sewa Anutura ge gayai numore sai awa te wero pesuniwa. Ago wewa nu ni pasinaira ena dusuniro poti bi ditira niwa. ");
INSERT INTO sue_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ata Anutu meni betaira ena awa-uzenu seka wero erinua. ");
INSERT INTO sue_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Eni meni gita numore dai Galilaya zebura ena Yerusalem nate eroma bamuwa amira nana nu seka wero eriro kei awasai gosinoisowa. Ago inoinu waiko be dainiro tepo wenua. Are kei awenu giwa nukare ami oziga sai ema nuso wero oziga nuso Yuda emare kerenitinowera. ");
INSERT INTO sue_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ago inora nakare ego muro Oziga Ewanana nimorekare ego ine tugata inonakare ewa: Nena Anutu meni gita ewowo-kawowo nasokaire potamu seroninua, ");
INSERT INTO sue_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nena awa nakai saisibuna nusokare nowenakai amire potinua. Awa nu Yesu awa-uzenu erinu nena awa namorekai potinua. Ge gayai awa namba tu Sam amira ego gayai itia awa, Ni awa Mai naso awa. Na zeme Mama niso inona. ");
INSERT INTO sue_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yesu awa-uzai seka wero eriro noma ama betai noko oko tamamunoya amira Anutu meni ge ego senua awa, Na nena ewa-gaewa Dawidire potamu seronina amira me zewai wero itai awa nimorekare potamunona awa. ");
INSERT INTO sue_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ota ge gayai zo ego itia ewa, Ni ema niso saramai awa oko duasa gumu wero yarasa awamunoya. ");
INSERT INTO sue_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nakai Dawidire ego ninitinowenakai awa: Nu Anutu meni bua senua awa ema dubu nusore wero pesuniro betenua. Betenu apipie ewowo-kawowo nusora bi ditira potiwa gumu wero yarasa awenua. ");
INSERT INTO sue_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ata ema Anutu meni awa-uzenu erinua ami kaka gumu wero yarasa awamu wenua. ");
INSERT INTO sue_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Otao mamai naso, sana niniu. Anutu meni ema ami emo inoise pasina nisokare disamunoya. Are amira ge meni nisokare nana kei awinoya awa. ");
INSERT INTO sue_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mosera lo ge meni pasina nisokarera mui besai ine oko itia. Ata Yesu tuma diawa amire pasina nisokarera mui dapikarago besamunoya. ");
INSERT INTO sue_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Are porofete meni ge gaewa ge ami nisokare nana me wamia, nikare giro baitiu. Ge awa ego ewa, ");
INSERT INTO sue_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Yei, Tuara ge azu sai ema, nikare giro di tainiro waya wawe. Na Anutu meni bua zo be nisokare amire wamunona. Bua amira bowi awa zo meni sai nikare niniro gawa me oko wamunoya. Ge gayai ago ine itia.” Paulo meni ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pauloto Banabare yere ibura ena pusumamu inoiwato ema meni Sabat pura zora ena ge da awa noko tugata wariset sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Are nukare aunaira ena osero Yuda ema dainiro ata ema eni Yuda meni nuago inoisowa ami nuto ama ganewa giro Pauloto Banabare meni nukare Anutura dumi yagaba awa tuma diro nuarise potai ge potiwato awa. ");
INSERT INTO sue_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Are Sabat pura nusokare zo kei awenu ema nata amira dainiro ami Anutura ge ninamu sero auniwa. ");
INSERT INTO sue_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Auniwa Yuda ema meni erama diti bamu giro kotumai waya Paulore pumuro ge nuso puro osamu wero nu sero isewa awa. ");
INSERT INTO sue_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ago wewa Pauloto Banabare nuto zewai wero ge toise ego tugata wewato awa, “Yuda ema nikare Anutura ge gita ninawise sai itia awa. Are nikakare nitopekare azu toise nuai me ewananara seronai awa wai ine tepo towa, are nato nikare doro ema Yudako amira nana bayamunonato awa. ");
INSERT INTO sue_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tua meni potai ge namorekare ego ine potinua awa, Nane ni ema Yudakora zasimai potina. Are ema bama zebu sero nowera nukare awa ge tugata wasa soero pumane.” ");
INSERT INTO sue_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ago sewato ema Yudako meni niniro duba kokopai wenu Tuara ge emo yawa sara inoise peu wero niniwa awa. Nuai me ewananara seronai meni Yesu tuma diwa awa. ");
INSERT INTO sue_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Are Tuara ge meni zebu amira nata sero te wero bamunua. ");
INSERT INTO sue_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ata Yuda ema meni opi sero ge businoise yere sai bama eni zazo witaire ata natara ema giti kopi amira duba gaewa awa. Ago wero tairo Pauloto Banabare iwo inoise zebu nusokarera tanira ena tunewa bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Susawiseto pasina nusokare nana itinua awa garise sero nukare poti gutipe niro te nusotora ena wowo nusokare deregiwewato osenu Aikoniam nate bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yesura dubu Antiok nate noisowa ami yawa sara bamubake wewa. Noko Ozana meni nusokare nana mokara be munua awa. ");
INSERT INTO sue_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pauloto Banabare Aikoniam nate kei aweroto Yuda emara yere ibu amira eroma toiro ge tugata wewato giwa me wenua. Giwa me wenu Yuda ema ata Grik ema dainiro meni Yesu tuma diwa awa. ");
INSERT INTO sue_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ata Yuda ema eni nukare Tuara ge azu sero ema Yudako eni duba gaewa Kristora dubure tini kapai pumuwa. ");
INSERT INTO sue_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ata nuto saineba asero inua be eni nata amira noisowato awa. Ago noiseto Tuara nana ereniroto ge nuso azu tepo toise dumi yagaba nusora ge tugata inoiwato Tua meni ge nusoto awa ge me, awa garise nuto soremunu tani putoure eni wewato awa. ");
INSERT INTO sue_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ago wewato nata amira ema nukare zaumuro eni Yuda emare taiwa, eni aposolo etora nana taiwa. ");
INSERT INTO sue_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ago wewa giro ema Yudako eni ata Yuda ema eni ata giti kopi nusokare ami aposolo eto awa waya wamu sero o omata meni damu sero ge timuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ago wewa giroto nata awa eya doro bamu Likonia zebura niwato awa. Zebu amira noise Listera nateta Derebe nateta nata enira baro ");
INSERT INTO sue_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Oziga Ewanana sero susawise noisowato awa. ");
INSERT INTO sue_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listera nate ena ema zo itisonua nu te mapeta wai. Nu miera nana tinira ena ago wai dago kei awero izima-sauma wai tepo dago arumuro gege itisonua. ");
INSERT INTO sue_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Arumuro itise Paulo meni ema bama ge tugata inoinu ninitinoise itinu Paulo meni giti moka poti nuso nana niro nu ua inoise ema nu kokopai waira tuma diai itinu ginua. ");
INSERT INTO sue_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Giro zawa sero pena-pana senua awa, “Ni te niso meni patiro eriro dope.” Ago senu ema ami eya eriro aita inoise izima-sauma wenua. ");
INSERT INTO sue_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ago wenu ema dubu bamubake nukare Paulo meni tani wenua awa giro arero Likonia ge nusokarera ego sewa awa, “Utura Tua eni meni ema ine wero nasokai nana kei awero iterato ewa.” ");
INSERT INTO sue_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ago toise Banaba tua opi nusokare zo zazo Zus amira zazo sewa. Ota Paulo meni ge dainiro toise noisonua, are tua opi nusokare zo zazo Hemis amira zazo sewa. ");
INSERT INTO sue_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tua opi zazo Zus amira zame potai ibu nata atura itinua. Ibu amira zame potai ema ami senu bulimakao direre ni uzi tenai enire puro osero goma toyai bera Pauloto Banabare emo zame potamu sero wewa. ");
INSERT INTO sue_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ago wewa aposolo eto Banabato Paulore meni nena awa giro duba nitinoise tama woi nusoto ziwato keenu sumuro bamu ema diti bamu amira nana soe niro arero ego sewato awa, ");
INSERT INTO sue_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Yei, nikare nogoro ago inowi? Nato ema gege. Nato nikare ine awa. Nikare tua opi awa doro Tua nuaire awa tuma diawise Oziga Ewanana nuso nimorekare tonato. Nune uture zebure eware nena eure-taure tamuro tepo wenua. ");
INSERT INTO sue_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Gita noisowa be amire ema dubu sero nukare nininu nuai susu giti tamuro noisowa. ");
INSERT INTO sue_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ata nu susu nuso oko bezenua. Susu nuso gawise dumi yagaba inoise sawi utura ena wa wawi zamai kei awawi wise nise awinoise yawa sara inoise nowewa awa.” ");
INSERT INTO sue_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Aposolo eto meni ge ago toise nuto emo zame potai azu sewato nukare ge nusoto dai sogo wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ago wewa nuto ago noiwato Antiok nata zorata Aikoniam natara Yuda ema eni kei awero ema bama sero uzutiro awewa tairo Paulo omata meni dewa awa. Dewa betenuta asero zumuro puro bamuro nata atura potiwa. ");
INSERT INTO sue_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ago potiwa itinu Yesura dubu meni kokouniro nu zimuro itiwa nu eriro nata amira noko toiro bamunua. Ago wenu pina atinu nuto Banabare nata awa doro Derebe nate bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Baro ana Oziga Ewanana sewato ema dainiro meni niniro Yesura dubu wewa awa. Ago wewa nuto ebata bamuwato da amira ewesemuro Listera, Aikoniam, Antiok nate kei awero muwato awa. ");
INSERT INTO sue_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nate kei awero Yesura dubu zewai warise o tuma diai nusokare nana zewai wero itaise sero wini ge eni sewato awa. Wini ge toise ego sewato awa, “Nakai yayara tame noma Anutu imata Tua wero nowia amira nate bayanisekai sai awa.” ");
INSERT INTO sue_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Are nuto Yesura dubu sero amira nana da da kei awero nena sieninoise isa toise ema eni sianiro dubura giti kopi warise sero buara potiwato awa. Buara potiro Tua tuma didinoisowa amira wanera potiwato awa. ");
INSERT INTO sue_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nuto Pisidia zebu busero susaumite Pamfilia zebura kei awewato awa. ");
INSERT INTO sue_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ago kei awero Pega nate ena Oziga Ewanana tugata wero ose Atelia nate niwato awa. ");
INSERT INTO sue_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ana osero wara witiro susaumite Antiok nate kei awewato. Gita nata amira ana Yesura dubu meni nuto Anutu meni dia wai bua nuso wariseto buara iyetiwa bamuwato awa. Are bua awa zaawero inoe pesuniro noko ewesemuro muwato awa. ");
INSERT INTO sue_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Are muro kei aweroto Yesura dubu sewato auniwa Anutu meni nuto soremunu bua wewato, o Anutu meni ema Yudako emo tuma diaira ebata gipenu tuma diaire wewa, amira ge uge dapikarago wero tepo wewato awa. ");
INSERT INTO sue_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nuto be iboi kena Yesura dubure dai noisowato awa. ");
INSERT INTO sue_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ema eni meni Yudaya zebura ena osero Antiok nate baro Yesura dubure ego sewa awa, “Nikare tama aiso kapaira tani Mose meni wanisekai senua amira te tama aiso nisokare kaka kapamu wamunowa, awa Anutu meni nikare oko soero pamunoya.” ");
INSERT INTO sue_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ago sewa Pauloto Banabare meni nukare senewato ge bamubake bawinoiwa giro dubu meni ego sewa awa, “Pauloto Banabare ata ge ninai ema eni nukare ge awa puro aposolo dubu eni Yerusalem nate noise gera giti kopi nora, nusokare nana puro bayarise.” ");
INSERT INTO sue_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Dubu meni ago sero iyetiwa bamuwa. Susawise Fonisia zebu busero Samaria zebu busero awinoise Yesura dubu ago noisowa amire ge ego tugata wero bamuwa, “Ema Yudako dainiro meni gera mokara toitinora.” Ago tugata wewa niniro yawa sara bamubake wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Paulo dubure susaumite baro Yerusalem nate kei awewa Yesura dubure aposolore gera giti kopire meni nukare areniro yawa sara wewa awa. Ago wewa nukare Anutu meni soremunu bua wewa me wenua amira uge-mage wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Uge wewa tepo wenu Yesura dubu amira eni nukare Farisayora dubura noisowa ami ego sewa awa, “Ema Yudako tama aiso nusokare kaparise sai itia. Ota Mosera lo ge dimarise awa tugata wewo.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Aposolore gera giti kopire nukare ge awa kora wamu sero auniwa. ");
INSERT INTO sue_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Auniro ge bua inoise itiwa Petoro meni eriro ge ego tugata wenua awa, “Otao mamai naso, gita bua zaawenakai be amire nane Oziga Ewanana ema Yudakore tugata wana niniro Yesu tuma diarise Anutu meni nasokai nana ena na pumuro bua amira potinua, awa gosinowa. ");
INSERT INTO sue_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ago wena Anutu nu dubara gai meni Yuda ema namorekai Ozana potinua da ago ine ema Yudakore potitinoise tuma diai nusokare te asenua awa. ");
INSERT INTO sue_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nukare Yudako ewe, nakai Yuda ewe, ago oko senua. Nukare nu tuma diwa duba nusokare sewero kora inoise namorekai wenua da ago ine numorekare wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mosera lo ge awa nena mou-mau, are nikare nogoro Anutu gaero gamu inoise nena awa Kristenra gape potamu towi? Apipie nasokai ata nakai dai nena mou-mau awa dimai ine tepo awa. ");
INSERT INTO sue_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ata nakai ego gosinowenakai awa: Anutu meni Tua Yesura dumi yagabara nakai Yuda ema soero pumunua, da ago ine nu ema Yudako soero pupinoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ago senu ema auniro itiwa nukare dapikarago ge tepo wenu itiwa awa. Itiwa Banabato Paulore Anutura buara noiwato ema Yudakora nana tani putoure dainiro wariseto senu wewato amira ge uge inoise tugata wewato awa. ");
INSERT INTO sue_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nuto ge tugata inomite wero pesuniwato Yakobo meni ge ego tugata wenua awa, “Otao mamai, ge sana niniu. ");
INSERT INTO sue_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Anutu nu ema Yudakora nana ena ema eni pumai dubu nuso warise gita duba nuso poti nusokare nana ninua, amira ge uge awa Simon meni weti ninenakai awa. ");
INSERT INTO sue_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nu ge sesia, awa porofete meni gita da ago ine sewa awa. Porofetera ge gayai zo ego ine itia ewa, ");
INSERT INTO sue_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Tua meni ego toya awa, Nane noma ewesemuro Dawidira komboa zasai awa kora wamunona. Boa waya wai awa noko ziana eriro dopamunoya. ");
INSERT INTO sue_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ema dubu sero nukare dubu naso warise sena ami Tua kau wero tamarise ago wamunona awa. ");
INSERT INTO sue_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tua nu ge ago ine kereniro tupisonua tupewia ami ago toya awa.” ");
INSERT INTO sue_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobo meni ago sero ge susumuro ego senua awa, “Are kotumai naso ego ewa: Ema Yudako Anutura nana desenitinora amira nana nena mou-mau oko potanekai. ");
INSERT INTO sue_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ata nukare nena ei awa duarise sanekai. Wo tua opire zame potai awa oko narise; bama bewana oko warise; wo duba anisemawera betawera orara kaka zozamu inowera amira me oko narise; wora orara oko narise. Nukare nena ago awa duarise sanakai zewai wai pas zo gaero potanekai. ");
INSERT INTO sue_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Awa ego emira wanekai: Mosera lo ge awa emoko ona nata sero azimuro susu kerenitinoise tupisowa. Ata zeme da ago Sabat pura sero yere ibu sero azimuro ninitinowenakai, are Mosera lo ge oko osamunoya.” Ago senua awa. ");
INSERT INTO sue_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Are aposolo ata gera giti kopi nukare dubura ema dapikarago tugata wewa niniwa te wenu nusokare nana ema eto pumuwa. Ema eto awa puro Pauloto Banabare dai pas puro Antiok nate bayariseto sewa. Ema pumuwa amira zo zazo nuso Yuda. Zazo nuso zo Basaba. Zo zazo nuso Sila. Nuto dubura giti kopi noisowato awa. ");
INSERT INTO sue_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nukare nuto pumuro pas zo ego toise gaero potiwa awa, “Gera otao mamai nisokare aposolore gera giti kopire nakare gera otao mamai nasokare ema Yudako Antiok natara Siriato Silisia zebura nowa, nikare arenitinoise pas ei awa potitinonakare awa. ");
INSERT INTO sue_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nasokare nana ena ema eni baro ge nimorekare tugata inoise kotumai nisokare sisewa, awa ninisenakare. Ata nakare ago warise kaka samu. ");
INSERT INTO sue_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Are nakare ge awa niniro auniro ge te sero ema eto tamuro nisokare nana iyetitinonakare. Nuto otao nasokare eto Pauloto Banabare dai iyetenakare susawera awa. ");
INSERT INTO sue_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pauloto Banabare meni Tua nasokai Yesu Kristo emo nuai nusoto gera wai sogo wewato awa. ");
INSERT INTO sue_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Are ema eto tamenakare awa Yudato Silare. Nuto nisokare nana muro ge gainonakare ge da awa be meni tugata warato ninamunowa. ");
INSERT INTO sue_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ozana ata nakare ami nena mou zo oko susumamunonakare. Potai ge ei awa gege potamu sero sesenakare te wetia awa. ");
INSERT INTO sue_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nikare wo tua opire zame potai amira pisita wora orarata wo duba anisemai betai orara mokara itai, awata bama bewana wai, awa doro baitiwo. Nena awa duamunowa, awa kokopai nuamunowa. Ge kaka awa. Tuare dai noiwo.” ");
INSERT INTO sue_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Are dubu meni ema iyetiwa bamuwa awa. Susaumite baro Antiok nate kei awero Yesura dubu zawa sewa auniwa pas potiwa. ");
INSERT INTO sue_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Potiwa azimuro potai ge sero gaewa awa giro duba koko wenu yawa sara wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Are Yudato Silare nuto porofete noiwato, are ge dainiro tugata inoise Yesura dubu soga wewato zewai wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nuto pura eni ago nomiteto ema nuto iyetiwa amira nana ewesemuro bayamu sewato giro duba kokopaire yawa sara inoise iyetiwa. ");
INSERT INTO sue_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ata Sila meni numorekare dai ago dago itamu senua awa. ");
INSERT INTO sue_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pauloto Banabare nuto Antiok nate itisowato. Ago itiseto ema enire dai Tuara ge tugata-magata inoisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ago noeto Paulo meni Banabare ego senua awa, “Nage gita Tuara buara susawise Tuara ge tugata wenage nata sero otao mamai nasoge kei awewa nukare nogo nori awa baro ganege.” ");
INSERT INTO sue_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ago senu Banaba meni Yohane Mak numoreto dai bayaise senua awa. ");
INSERT INTO sue_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Mak nu gita numoreto dai susaumite Pamfilia zebura ena bua ziro zewai kaka wamu nuto doro ewesemunua, are Paulo meni nu numoreto dai bayaira ginu te kaka wamu wenua. ");
INSERT INTO sue_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Amira Pauloto Banabare ge bawinomiteto zaumuwato awa. Zaumuroto Banaba meni Mak puro wa selire amira witiroto Saipras gutura bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ota Paulo meni awa Sila pumunu Yesura dubu meni nuto Tuara buara iyetitinoise Tua nuto dia waise wana nusora potiwa bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bamuroto Siria zebure Silisia zebure businoise Yesura dubure potai ge potitinoise bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pauloto Silare meni susaumite Derebeto Listera nate kei awewato. Listera nate ena Yesura ge ninai mai zo zazo nuso Timoti itisonua. Mia nuso Yuda bama Yesu tuma diai, ata mama nuso Grik ema. ");
INSERT INTO sue_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listera ata Aikoniam natara ge ninai dubu nukare Timoti gasara ewanana inoisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Are Paulo meni Timoti numore dai nuaise senua. Ota zebu amira Yuda ema noisowa ami maira mama nu Grik ema awa giro tepo wewa. Are Paulo nu Yuda ema meni Timoti gara ewanana waise sero puro tama aiso nuso kapenua awa. ");
INSERT INTO sue_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ago wero nata sero susawise aposolota giti kopi meni Yerusalem nate ena sai zewai wai ge sewa awa dimarise sero Yesura dubu tugata wero bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ago inoise bua wewa Yesura dubu amira tuma diai zewai wenua. Are ema eni meni waiko be sero baro tairo tairo awewa dubu bamubake wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nukare Asia zebura ena ge tugata wamu sewa Ozana meni azu senu giro Frizia zebu ata Galata zebu amira soe bamuwa. ");
INSERT INTO sue_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bamuro Misia zebu tani wai amira kei awero Bitinia zebura bayamu wewa Yesura Ozana meni da ago bayai azu senua. ");
INSERT INTO sue_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Azu senu giro nukare Misia zebu busero baro ewa bera Troas nate kei awewa awa. ");
INSERT INTO sue_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ago kei awero pire Paulo meni atuara nena ego ine ginua: Masedonia ema zo meni nuso nana dopero ge beina wero ego senua awa, “Ni semuro mu Masedonia zebura niro nakare soremase.” ");
INSERT INTO sue_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo nu nena awa ginu ego senakare awa, “Anutu meni nakai Masedonia zebura baro Oziga Ewanana tugata wanisekai toya awa.” Ago sero bayamu sero sia wenakare awa. ");
INSERT INTO sue_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nakare sia wero wara witiro Troas nata doro daina-poina awero susaumite Samotres gutura kei awenakare. Pina atinu ana susaumite Neapoli nate kei awenakare. ");
INSERT INTO sue_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ana wara ena osero susaumite Filipai nate kei awenakare. Nata awa Masedonia zebura nata bamu zo awa. Roma ema meni nata amira mama wero noisowa. Are nakare nata amira waiko be eni ago noinakare awa. ");
INSERT INTO sue_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ago noinakare Sabat pura kei awenu nata atura ou zo itinua amira ego toise bamunakare, “Yuda ema begomo bua inowera amira kakamo zo ou paora itita baro ganekai.” Ago sero baro bama auniro itiwa tamuro itise ge tugata wenakare awa. ");
INSERT INTO sue_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nusokare nana bama zo meni Anutu sou inoise noisonua, zazo nuso Lidia. Nu mo bewa-dito zuma bamure amira stoara mia. Nu Tayataira natara. Are bama awa Tua meni senu kotumai nuso zazenu nu Paulora ge dana zaawero nininua. ");
INSERT INTO sue_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Are nakare nu ata awiso nuso awa ge ou gutenakare amire nu namorekare ego senua awa, “Nikare namore gewa Tuara mai me inona, are so nasora witiro itai-matai wewo.” Ago toise ge beina wenu witi sora ninakare awa. ");
INSERT INTO sue_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Be zore nakare begomo saira kakamo amira susaunakare sou bama diri zo meni nakare tamunua. Bama diri nu koi zawa sai bama noise nena ama emara nana kei awamu inoinua awa kerenitinoise noisonua. Ago inoise wau moni zumasai masai mamana nuso meni pupinoisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Are nu ami nakare eyaya tamuro ama ganinoise zawa sero ego toisonua awa, “Ema emi Anutu bamubakera bua mai noise kokopai wawise amira ebata nimorekare sero gipero awinowera.” ");
INSERT INTO sue_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Zawa sai awa waiko be giti toe donu giro Paulo nu amira berea wenu giro kapeteniro koire ego senua awa, “Na Yesu Kristora bera sana bamera mokara ena kei awero bamu.” Ago senu koi eya kei awero bamunua. ");
INSERT INTO sue_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ago wenu mai bama diri amira mamana meni wau moni nusokare kei awaira ebata tepo wenu giro Pauloto Silare ziro zumuro puro bamu nata mokara niro ema giti kopira nana potiwa awa. ");
INSERT INTO sue_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Natara giti kopi amira nana potiro ego sewa awa, “Nuto Yuda ema meni nata nasokaira muro nata nasokai gera inowerato awa. ");
INSERT INTO sue_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ago inoise tani-butani seka nakai Roma ema meni wai ine tepo, o tani eni lo nasokai meni gazinoya awa tamuro puro norato.” ");
INSERT INTO sue_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ago sewa ema dubu bamubake dopero itiwa ami numoreto tini kapai puro nuto iwo inoiwa ema giti kopi meni tama woi nusoto ziwa keenu dutero wamu meni darise sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wamu meni pena-pana dero amire eto dago benai sora potiwa awa. Potiro nuto azu bayai azu dia meni nuto dia wero baitaise sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ago sewa giro nu nuto benai so soe damu amira potiro te nusoto para wekimai meni wekimunu auwato awa. ");
INSERT INTO sue_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pi soe sieniro amire Pauloto Silare meni Anutu yerere isare meni bowi inoiwato benai ema eni meni ninitinoiwa ");
INSERT INTO sue_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","duwi bamubake tutamu sumunu benai sora zasiwi zipenu toyai be dapikarago piakaniwa ema dapikaragora mui besewa awa. ");
INSERT INTO sue_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ago wenu benai dia meni awai masira ena mamana awero eriro toyai be dapikarago piakanai gege giro benai ema bozero tepo weuta asero kaia nuso egira ena zinu kisimunu puro nutope gayamu sero inoinu ");
INSERT INTO sue_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Paulo meni arero ego senua awa, “Tama niso oko gera wase. Nakare dago itenakare ewa.” ");
INSERT INTO sue_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ago senu dia meni lam emo senu awiso nuso lam potiwa eya so mokara toiro te-wana zipenu Pauloto Silara nana koininua. ");
INSERT INTO sue_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ago wero so mokara ena uzumuro puro pusumuro nuto atata wero senua awa, “Ema tua naso, na nogo nogo wana Anutu meni na soero puro kora wamunoi?” ");
INSERT INTO sue_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ago senu nuto ina ego sewato awa, “Ni ata dubu nisore Tua Yesu Kristo tuma diawa amire Anutu meni nikare soero puro kora wamunoya.” ");
INSERT INTO sue_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ago sero nu ata dubu nuso awa Tuara ge tugata wewato awa. ");
INSERT INTO sue_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tugata wewato niniro dia meni pire nuto uzumuro puro baro wamu zara amira iso awa sewero dowenua. Ago wero senu nu ata dubu nuso awa ge ou gutewato awa. ");
INSERT INTO sue_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ago wewato nuto uzumuro so nusora puro witiro senu nena wewa niwato awa. Ota dia dubu nusore nukare Anutu tuma diwa soero puro kora wenu giro yawa sara wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pina atinu ema giti kopi meni polis iyetiwa baro ego sewa awa, “Ema eto bese bayareto.” ");
INSERT INTO sue_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ago sewa dia meni niniro Paulore ego senua awa, “Na nito iyetana bayawiseto ema giti kopi meni ge potera mia, are nito kei awero baroto begare noiwoto.” ");
INSERT INTO sue_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ago senu Paulo meni polisre ego senua awa, “Nato Roma ema kei awenato, ata nukare nato tepo emara giti mokara ena wamu meni dero poti benai sora nitara. Agoro nukare nogoro nato upene iyetitinori? Ago ine tepo awa. Nutopekare muro nato sara bayaneto.” ");
INSERT INTO sue_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Paulo ge ago senu polis meni ewesemuro baro giti kopi tugata wewa nukare ema eto Roma ema kei awewato amira oziga niniro azu wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Azu wero nusoto nana muro nuto uzutitinoise kora wero benai sora ena puro kei awero nata nusokare doro bayariseto sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ago sewa nuto benai sora ena kei awero Lidiara sora baro Yesura dubu giro sogawai ge tomiteto nata awa doro bamuwato awa. ");
INSERT INTO sue_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pauloto Silare Amfipoli nate kei aweroto nata awa doro susaumiteto Apolonia nate kei aweroto noko nata awa doro susaumite Tesalonika nate kei awewato awa. Ana Yuda emara yere ibu zo itinua. ");
INSERT INTO sue_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Are Paulo meni yere ibura susawisonua da ago nata amira itise Sabat pura etorobara yere ibu nusokarera toiro numorekare dai itise Tuara ge gayai azimuro sero niniro awewa. ");
INSERT INTO sue_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ago inoise Tuara ge gayai amira susu tugata-magata inoise ego senua awa, “Soyai Ema nasokai Kristo ami betero seka wero eraise sai awa ge gayaira itia, ge awa Yesura nana ena me wenua. Are Yesu nimorekare kerenitinona nu awa Soyai Ema me awa.” ");
INSERT INTO sue_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ago senu eni meni ge awa niniwa me wenu Pauloto Silara nana susumuwa. Ago wewa Grik ema Anutu sou inoise noisowa nukare dainiro meni da ago nusokare nana susumuwa. Ota ema giti kopira asini dainiro meni da ago wewa. ");
INSERT INTO sue_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ago wewa Yuda ema meni numoreto giwa waya wenu nukare ema waya-kawaya eni tebe-tabe noisowa, awa puro uzumuwa kokouniro ge sero gunero awero baro Zesonra so zimuro Pauloto Silare puro emara nana wanera potamu sero kau wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nukare nuto kau wero kaka tamamu wero giro Zeson ata ge ninai eni awa puro zumuro bamu nata dia wai ema amira nana niro arero ego sewa awa, “Ema eni meni ema zebu giti amira duba sisinoise nowera ami nasokai nana kei awetera. ");
INSERT INTO sue_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Kei awetera Zeson meni nukare sora poti nuso nana nora. Nukare Roma ema tua Sisa amira ge azu sero ema tua zo iti sia tora. Zazo nuso Yesu awa.” ");
INSERT INTO sue_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ago sewa ema eni ata nata dia wai ema ami giwa waya wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Are nukare Zeson ema mamaire moni potarise sewa wau moni diare potiwa pumuro nukare eseniwa bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tua zinu Yesura dubu meni Pauloto Silare eya iyetiwa bamu Beria nate niwato awa. Ago kei awero Yuda emara yere ibu amira toiro ge tugata wewato awa. ");
INSERT INTO sue_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nata amira Yuda ema nukare ge ninaira duba peure noisowa. Yuda ema Tesalonika nate noisowa ago ine tepo. Are Tuara ge ninamu yaba wewa. Are Pauloto Silare ge sewato ge nusoto meta opi ni, asinoise be giti amira susu tamamu sero Anutura ge gayai azipitinoisowa. ");
INSERT INTO sue_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ago wero nusokare nana ema bama dainiro meni Yesu tuma diwa. Ago wewa Grik bama zazore dainiro ata Grik ema dainiro meni da ago ine Yesu tuma diwa awa. ");
INSERT INTO sue_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Paulo meni Beria nate ena Anutura ge tugata wenu niniwa amira bowi nuso meni Tesalonika nate bamunu nata amira Yuda ema meni niniwa. Niniro Beria nate muro ema bama duba gaewa Paulore tini kapai pumarise wewa. ");
INSERT INTO sue_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ago wewa ge ninai dubu meni Paulo ema enire eya iyetiwa nata awa doro susaumite ewa bera kei awewa. Ata Silato Timotire nuto Beria nate dago itiwato awa. ");
INSERT INTO sue_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Are ema Paulore dai bamuwa ami nu Atens nate potiwa Paulo meni numorekare ego senua awa, “Nikare ewesemuro Silato Timotire sawa eya mareto.” Ago senu nukare nu doro ewesemuro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo meni Atens nate ena otao eto awa dia noise tua opi ni kewai dainiro itiwa giro duba mou wenua. ");
INSERT INTO sue_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Are nu Yuda emara yere ibura toiro Yuda ema nukare ata Grik ema eni Yuda emare dai noisowa numorekare dai Tuara ge sero niniro awewa. Ota waiko be giti nata kakame ena ema tamuro da ago ge sero niniro awewa. ");
INSERT INTO sue_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ota nata amira ninai ema noisowa zazo nusokare Epikurian dubu ata Stoik dubu, ema ami Paulore dai ge ina-sa wewa. Ema eni meni Paulore ego sewa awa, “Ema ge mamatu toise nowia ami muro ne samu toi?” Ago sewa eni meni ego sewa awa, “Nu zebu zora tua amira oziga toiwa.” Ago sewa, nera kota, Paulo nu Yesura ozigare betaira ena eraira ge senu amire nukare ge awa sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ago sero aunaira kakamo zo zazo Areo ago uzumuro puro witiro baro natara dia amira soe potiro ego sewa awa, “Ni ge seka tosa awa nera tosi? Sasa ninamu tonakare. ");
INSERT INTO sue_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nakare ge awa gita kaka ninamu, are zeme susure se ninanekare.” ");
INSERT INTO sue_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atens nata susure eseware nukare ge bowi seka sero niniro awinoise uge-mage dainiro inoise noisowa. ");
INSERT INTO sue_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Are Paulo meni Areo ge sai kakamora baro aunaira soe dopero emare ge ego tugata wenua awa, “O Atens natara ema mamai, na susu nisokare ego gosinona: Nikare tua saisai sou inowewa. ");
INSERT INTO sue_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Na nata kakamo nisokarera izima-sauma inoise tua bowi inowewa amira masi nisokare eni gosinomite alta zora owe ego ine iti azimena: ‘Alta ei awa tua zo nakai kaka gamu amira alta.’ Are tua zo nikare kaka gamu sou inowewa amira susu awa nimorekare kerenitinona. ");
INSERT INTO sue_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Anutu nu zebu tamuro amira tame nena dapikarago potiro pesuninua, nu ami ututo zebura Tua awa. Nu ibu emara wana meni wai amira itai-matai oko inowia. ");
INSERT INTO sue_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ota nena zo kau wai ema meni bua wero tamuro numore potai ine oko itia. Tepo awa. Nune gege ema namorekai nuaire ozanare nena dapikarago potai gege potitinowia awa. ");
INSERT INTO sue_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Anutu meni ema daimata senu kei awenua amira dubu nuso dainiro kei awero wisika asero nowenakai. Kei awenakai senu zebu sero bozero nowenakai awa. Gita dubu giti kaka kei awamure Anutu meni nuaira be nusokare ata zebu nusokarera tani awa potinua. ");
INSERT INTO sue_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Awa duba nasokai meni Anutu kau inoise susauma nu tamanisekai kotumuro ago wenua. Ata nu asike kota, nu nakai ema da da amira nana zorage itewia. ");
INSERT INTO sue_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nakai putou nusora noise bua inowenakai. Ninai ema nisokare eni meni ego sewa awa, ‘Nakai dai nuso nana ena kei awai.’ ");
INSERT INTO sue_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nakai mai awiso nuso, are ema nukare duba nusokarera golre silvare omatare meni ititi kewero simena-gaena inowera awa ganakai Anutu ine oko waise. ");
INSERT INTO sue_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ema diga nuasawa Anutu meni nikare awa-diro tupie donu amira be tepo wenua. Are zeme ei awa zebu sero ema duba kapetenanisekai toya. ");
INSERT INTO sue_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Awa nera kota, nu be potinua itia awa kei awai amire nu ema zebu giti amira susu kereniro ina te potamunoya. Ota ema zo awina-dawina waira bua awa waise potinua. Potiro zebura ema dapikarago nu giro baitanisekai sero betaira ena awa-uzenu seka wero eriro nowia.” ");
INSERT INTO sue_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Paulo nu betaira ena seka wero eraira ge senu eni meni niniro nu sero ziwa, ata eni meni awa ego sewa awa, “Ge awa be zore sasa ninanekare.” ");
INSERT INTO sue_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ago sewa Paulo meni aunai nusokare doro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ota ema eni meni awa Paulore tairo Yesura dubu wewa. Nusokare nana natara dia bamu zo zazo nuso Dayonisio, ata bama zo zazo nuso Damari. Nuto ata eni dai Yesu tuma diwa awa. ");
INSERT INTO sue_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Paulo nu Atens nata doro Korinti nate bamunua. ");
INSERT INTO sue_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Baro ana Yuda ema zo tamunua zazo nuso Akuila. Nu Ponto zebura ena kei awenua. Nuto bama nuso Prisilare dai Itali zebura ago noiwato Roma ema tua bamubake zazo nuso Klodio meni Roma nata soero Yuda ema dapikarago eseninua awa. Are nuto nata awa doro Korinti nate baro borere tepo itiwato Paulo meni nuto tamunua. Tamuro nusoto nana bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulo nu seli so bua inoisonua, bua da awa Akuilato arere meni inoisowato, are so nusoto amira eroma itise soga wenu bua eroma wewa. ");
INSERT INTO sue_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Paulo meni Sabat pura sero Yuda emara yere ibura toiro Yuda emare Grik emare ge ina-sa inoise noinu eni meni ge nuso giwa me wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Are Silato Timotire Masedonia zebura ena muwato amire Paulo meni tamara bua doro ge tugata waira bua zewai-zawai wero puro Yesu nu Yuda emara Soyai Ema me amira susu kereniro toise Yuda emare tugata wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ago wenu Yuda ema nukare ge nuso azu sero nu isimuwa ginu mou wenu nu nukare poti gutipe nago wero tama woi nuso deregiwenu wowo osenu numorekare ego senua awa, “Anutu meni be bamura ena nikare duamunoya amira susu awa naso kota, nisokare gege awa. ");
INSERT INTO sue_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Na nikare doro ema Yudakora nana baro nukare ge tugata wamunona.” Ago sero nukare doro ema zo zazo nuso Titio Zastas, nu Grik ema meni Anutu sou inoisonua, so nuso amira witiro itai-matai wenua. So nuso awa Yuda emara yere ibura zorage itisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Yuda emara yere ibura dia zazo nuso Krispo nu ata awiso nuso nukare ami ge niniro Tua tuma diwa. Noko Korinti ema dainiro meni Paulora ge niniro Yesu tuma diwa. Tuma diwa giro Paulora dubu meni nukare ge ou gutewa awa. ");
INSERT INTO sue_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pi zore Paulo atua ine inoinu Tua meni numore ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","“Na nimore dai nona awa. Ema meni ni oko waya wamunora. Nata emira ema mamai naso dubu bamubake nora, are ni azu doro zewai wero ge tugata wai gege inoise noiyo. Ge oko duase.” ");
INSERT INTO sue_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ago senu Paulo meni nata amira emare Anutura ge tugata-magata inoise noe donu zepa zore zora ageware tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio nu Akaya zebura dia bamu wero noisonua be amire Yuda ema nukare ge timuro Paulo iwo inoise diara nana puro bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Puro baro diare ego sewa awa, “Ema emi ema bama lo ge dero Anutu sou warise uzutitinoise awita towia.” ");
INSERT INTO sue_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ago sewa Paulo meni ge ina samu sero wenu Galio meni Yuda emare ego senua awa, “O Yuda ema, ema ami tani wayata pasina mou-mau tamami sia, awa na ge nisokare ninana te wamia. ");
INSERT INTO sue_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ata nikare ge gayai nisokarere emara zazore lo ge nisokarere amira ge bua numore potitinowa, are nitopekare seu tepo wae. Awa bua naso oko aewa.” ");
INSERT INTO sue_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ago sero eseninu so nuso doro bamuwa. ");
INSERT INTO sue_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Are nukare dapikarago ibura dia Sosteni saniro dia emara nana giti mokara ena dero gera-gaira wewa. Ago wewa dia meni giro gago-giagoawenua awa. ");
INSERT INTO sue_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo nu Korinti nate noe Yesura dubu awa wana ziro Siria zebura bayamu sero wara witinua. Witinu Prisilato Akuilare numore dai bamuwa. Wara witamu inoise Senkria nate ena giti tu nuso kapenua. Awa nera kota, giti tu nuso kapai azu, Anutura nana senu zewai wenua. Are giti tu nuso kaka kapamu noe donu sai zewai wai nusora be tepo wenua, are ago wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ago wero ana wara witiro susaumite Efeso nate kei awewa. Ago kei awero Paulo meni Prisilato Akuilare nata amira donu itisowato. Ata nu nutope Yuda emara yere ibura toiro numorekare dai Tuara gera ina-sa wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Eni meni nu numorekare dai nuaise sewa nu azu senua. Azu sero nukare duamu inoise ego senua awa, ");
INSERT INTO sue_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","“Anutu meni ninai na noko nisokare nana ewesemamunona.” Ago sero Efeso nate ena wara witiro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Susaumite Sisaria nate kei awenua. Kei awero wa doro witiro susaumite Yerusalem natara ge ninai dubu tamuro numorekare dai otao-gamao wewa awa. Ago wero nukare doro Antiok nate ewesemunua awa. ");
INSERT INTO sue_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Paulo meni Antiok nate ena pei-kaka nuago-nuago wero doro Tuara oziga puro noko bamunua awa. Ago wero Galata zebure Frizia zebure amira baro nata zimuro Yesura dubu potai ge potitinoise soremuro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ago inoinu Yuda ema zo zazo nuso Apolo ami Efeso nate kei awenua. Nu Alesandria natara ema. Nu ema ninai bamubakere. Nu Anutura ge gayai azipitinoise niniro baitinua. ");
INSERT INTO sue_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ago wero Tuara ebata gipewa giro baitinua. Giro baitiro Yesura ge awa zo da kaka wosunamu ema bama tugata inoisonua awa. Ata nu Yohanera ge ou gutai awa gege nininua. ");
INSERT INTO sue_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nu Yuda emara ibura ena zaawero ge tugata wenua, awa itazaita tepo, zewai wero tugata wenua. Ge ago gipenu giro Prisilato Akuilare meni niniro nu puro nusoto nana baro Anutura ebata giro baitaise ge sero tugata-magata wewato awa. ");
INSERT INTO sue_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ago wewato nu Akaya zebura bayamu senu giro Yesura dubu meni nu sorepitinoise ge ninai dubu ago noisowa amire pas ego gaewa awa, “Ema ei awa nisokare nana susawia, awa otao wewo.” Pas ago gaero potiwa puro bamunua. Baro Korinti nate kei awero ema bama Anutu meni soremunu nu tuma diwa, nukare awa soga bamu wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ago inoise Anutura ge gayai awa azimuro Yesu nu Soyai Ema me amira susu poti damu niro ema bamera giti mokara ena ge ina-sa inoise Yuda emara ge puro osenua awa. ");
INSERT INTO sue_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo nu Korinti nate noinu Paulo meni zebu busero susaumite Efeso nate kei awero ge ninai dubu eni tamunua. ");
INSERT INTO sue_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Tamuro atata wero ego senua awa, “Nikare tuma diwa Ozana meni nisokare nana toinuta?” Ago senu nukare ina ego sewa awa, “Tepo awa. Ozana noya amira oziga nakare kaka ninamu.” ");
INSERT INTO sue_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ago sewa noko atata wero ego senua awa, “Agoro nikare susu nera ge ou guteu?” Ago senu nukare ego sewa awa, “Nakare ge ou gutewa awa Yohane meni ema bama duba kapetenarise ge tugata inoisonua amira susura ge ou gutewa awa.” ");
INSERT INTO sue_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ago sewa Paulo meni ina ego senua awa, “Yohane meni awa ema bama duba kapetenarise ge ou gutinoise ego tugata inoisonua, ‘Naso nana atune mamunoya nu awa tuma diwo.’ Ge awa Yesure senua.” ");
INSERT INTO sue_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Paulo ge ago senu ema meni ge awa niniro Tua Yesura zazora susumuwa giro ge ou gutenua awa. ");
INSERT INTO sue_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ge ou gutero wana nuso giti nusokarera potinu Ozana nusokare nana osenu nukare Ozanara ge ewe-pape toise porofete meni sago wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ema ago wewa amira namba nusokare 12 awa. ");
INSERT INTO sue_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo meni Yuda emara yere ibura eyaya toitinoise Tuara ge itazaita tepo putoure inua etorobara ago ge tugata inoise noisonua awa. Ago wero nukare Anutu imata Tua wero nuamunoya amira ge awa gara me waise numorekare dai uge-mage inoise noisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ago inoinu ema eni nukare ge nuso ninai azu wero Yesura ge azu toise aunaira ena Tuara Ebata Seka awa waya asewa giro Paulo meni dumu inoise nukare donua. Nukare doro Tuara ge emo ara tamuwa nukare awa uzumuro puro ema zo zazo Tirano amira ninai ibura baro waiko be giti Yesura ge tugata-magata inoise noisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ago inoe donu zepa eto wenua. Are Yuda emare Grik emare Asia zebura noisowa ami dapikarago Tuara ge niniro tepo wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Anutu meni Paulo soremasai tani putoure erama meni gita kaka gamu awa dainiro inoisonua. ");
INSERT INTO sue_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Awa ego ewa: Ema eni meni Paulora tamara bua mo o poia nuso awa puro bamu yaya ema bamera nana nasara ziasara yaya tepo wasai kokopai inoisowa. Ota bi moka nusokare nana ena doro susawisowa awa. ");
INSERT INTO sue_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yuda ema eni bi tuninuai ema wero so sero keusema inoise noisowa nukare ami goe bi tunaira puro noisowa. Are Tua Yesura zazo bowire meni goe nusokare waise sero ema bire amire ego sewa awa, “Yesura zazo bowire Paulo meni towia amira bera bayasise tona.” ");
INSERT INTO sue_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yudara pris bamu zo zazo nuso Siwa amira mai mamatana 7 nukare ami da ago inoisowa. ");
INSERT INTO sue_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ago inoise sewa bi meni ge ego ine kapeteninua, “Yesu na gai. Paulo na gai. Ata nikare arekareni?” ");
INSERT INTO sue_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ge ago toise ema bire meni goroba bamubake wero mai dapikarago dero musuna-masuna inoise tama woi nusokare zinu kekeyemunu tama tepo ou orara gutero sora ena sumuro bozewa. ");
INSERT INTO sue_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ago wewa nena amira bowi meni kei awenu Efeso nate ena Yuda emare Grik emare niniro azu wero giro Tua Yesura zazo de ike damu nitinoisowa. ");
INSERT INTO sue_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ago wewa ge ninai dainiro meni kei awero digara tani inoisowa awa dapikarago gateniwa. ");
INSERT INTO sue_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Digara tani gateniro ema goe bua inoisowa amira nana dainiro meni goe waira buku asumuro puro kei awero ema bamera nana giti mokara niaora moewa awa. Are buku moewa amira zuma azimuwa 50,000 kina wenua. ");
INSERT INTO sue_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ago wewa Tuara ge meni putoure kei awero so te wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tani awa kei awero tepo wewa amire Ozana meni kotumai zo Paulore potinu nu Masedonia ata Akaya zebura baro nata temuro amire Yerusalem nate bayamu senua. Bayamu sero ego senua awa, “Na Yerusalem nate kei awero noko muro bamuro Roma nate kei awamunona.” ");
INSERT INTO sue_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Are bayamu sero soremai nuso eto Timotito Erastore Masedonia zebura iyetinu gita bamuwato awa. Nune meni awa Asia zebura itamu sero noko be pei-kaka susumuro noinua awa. ");
INSERT INTO sue_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Be amira ana Efeso nate ena Tuara Ebata Sekara ge gunai bamubake kei awenua. Awa ego emira. ");
INSERT INTO sue_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ititi silva meni wai ema zo noisonua zazo nuso Demitrio. Ema ami tua opi zo zazo Atemis amira ibu nusora ititi pei-mamai silva meni wasai ema meni zuma gaero pumasara numa ata bua mai nusore nusokare nana moni meni dainiro kei awinoisonua awa. ");
INSERT INTO sue_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Are Demitrio meni bua mai nusore silva bua wai ema enire zawa senu auniwa ego tugata wenua awa, “Otao mamai, nikare bua nasokai ami wau moni tapinowia, awa gosinowa. ");
INSERT INTO sue_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Agoro ema zo muro nowia zazo nuso Paulo. Nikare susu nuso niniro gosinowa. Nu Efeso nate ena daba kota, Asia zebu enira ema dainiro uzutiro duba sisinoise ego tugata inowia, ‘Ititi emara wana meni wai awa tua me tepo awa.’ ");
INSERT INTO sue_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nu ago inuai ema bama meni moni bua nasokai puro osago wamunora. A gege kota, tua bamubake nasokai Atemis amira ibu awa iwo wara osamunoiwa. Agoro Atemisra zazo bowire nuso osamunoiwa. Agoro Paulo meni bama tua Asia zeburata zebu enira ema dapikarago sou bua inowera amira zazo bowire puro osarise towia awa.” ");
INSERT INTO sue_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demitrio meni ge ago tugata wenu niniwa moka nusokare tini kapenu zawa gatero ego sewa awa, “Efeso natara Atemis nu tua bamubake.” ");
INSERT INTO sue_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ago toise ge gunewa nata ema dapikarago ge gege gunero bamu aunai kakamora niwa. Ago inoise Masedonia ema eto Paulo ama ganinoisowato zazo nusoto Gayasto Aristakore nuto awa puro ziro zumuro aunai kakamora bamuwa awa. ");
INSERT INTO sue_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ago wewa Paulo meni niniro emara aunaira nana mokara bayamu senu ge ninai ema meni soewa awa. ");
INSERT INTO sue_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ago wewa Asia zebura ema giti kopi eni Paulora otao mai wero noisowa ami Paulo aunaira mokara bayai azu, sai zewai wai ge potiwa nuso nana bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Aunai masira ena ema nukare eni ge zo sewa, eni ge zo sewa, ago inoise ge bamu gunewa. Ago wewa, nera kota, ema bama dubu bamu meni aunaira susu kaka gamu inoise itazaita wewa. ");
INSERT INTO sue_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ema nukare ago inoiwa Yuda ema nukare otao nusokare zo zazo Alesanda, nu emara nana soe dopero itinu ge saise musewa eni meni gera susu gaise tugata wewa niniro gera masira baro ge ina-sa wamu sero wana sapikore awenua awa. ");
INSERT INTO sue_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ago wenu ema nukare nu Yuda ema awa giwa kei awenu nukare dapikarago eroma arero ego sewa awa, “Efeso natara Atemis nu tua bamubake.” Ago toiwa aua eto tepo wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ago inoiwa natara kuskus meni ge duarise senu giro dowa numorekare ego senua awa, “Efeso otao mamai naso, nata emira ema meni Atemis bamu nasokaira ibu ata omata sienai utura ena osenua amira dia nowenakai, awa ai meni siramunoi? ");
INSERT INTO sue_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Awa tepo awa. Ema zo meni ge awa opi asai ine oko itia. Are nikare tani waya zo giti agu wai azu, duba nisokare puro osewo. ");
INSERT INTO sue_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nikare ema eto puro mewa nuto ami gita nena nisokare zo ibura ena oko bewana wewato. Ata nuto tua bama nasokai oko isewato. ");
INSERT INTO sue_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ata Demitrio nu bua mai nusore nukare ami ema zore gera waya inoita, pasinara ge bua waira be mawi zas ema nowera amira nana puro baro sarise. ");
INSERT INTO sue_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ata nisokare nana ge zo itai giro ema giti kopira aunai bamubake kei awai amire seu tepo wae. ");
INSERT INTO sue_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nikare zeme tini gamaira ge sero ge tepora ena iwo kei awamu wetia, amira Roma ema giti kopi meni niniro nakai zawa sai baro ge zota zo puro tugata wanakai ninai oko te wamunoya.” ");
INSERT INTO sue_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kuskus meni ge ago sero tugata wenu niniro zanewa awa. ");
INSERT INTO sue_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ge gunai tepo wenu Paulo meni Yesura dubu senu auniwa zewai wero nuarise ge tugata-magata wero nukare areniro doro bamu Masedonia zebura ninua. ");
INSERT INTO sue_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Zebu amira ete baro Yesura dubu ago noisowa awa zewai warise ge tugata-magata wero bamunua. Susaumite Grik zebura kei awenua. ");
INSERT INTO sue_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ago inua etorobara noe ewa bera baro wara witiro Siria zebura bayamu wenu Yuda ema eni meni ge potiro nu bayai damu sewa giro wa doro kapeteniro ete Masedonia zebura bayamu senua. ");
INSERT INTO sue_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ema ego ami numore dai bamuwa awa: Beria natara Sopata, nu Pirora mai; Tesalonika natara Aristakoto Sekundore; Derebe natara Gayas, ata Timoti; ata Asia zebura Tikikasto Trofimore. ");
INSERT INTO sue_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ema ami gita wero Troas nate ena nakare dia itiwa. ");
INSERT INTO sue_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yuda emara pura zazo Betai Daininua amira be tepo wenu nakare Filipai nate ena wara witiro susaunakare waiko be 5 tepo wenu Troas nate kei awero nukare tamunakare. Ago kei awero waiko be 7 ago noinakare awa. ");
INSERT INTO sue_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nakare Sarere pire* bona namu auninakare Paulo meni, na pina atai nikare doro bayamunona, asero nukare ge tugata inoise noinu pi soe sieninua. ");
INSERT INTO sue_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","So mokara ike masi itinakare amira lam dainiro meni zasimuro itiwa awa. ");
INSERT INTO sue_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Are mai zo zazo Yutiko ami so be kiakara arumuro ereniro itinu Paulo meni ge iboi tugata inoinu itimite gitawa wenua. Gitawa inomite so be kiaka amira ana duro betero itinu ziwa kaka eramu wenua. So ike damu 3 storira ena osero duuna awa. ");
INSERT INTO sue_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ago wenu Paulo meni osero mai saniro puro ema bamere ego senua awa, “Nikare dire-buare oko weu. Nu ozana nuso tupia.” ");
INSERT INTO sue_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ago sero so mokara toiro bona potinu ninakare. Nena niro numorekare dai Tuara ge sero niniro awinoiwa pina atinu nukare doro bamunua awa. ");
INSERT INTO sue_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Mai kokopai wenu puro bamu so nusora niro ana duba nai tepo yawa sara bamu wewa awa. ");
INSERT INTO sue_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nakare eni Paulo meni senu giro wara witiro Asos nate bamunakare. Baro nu ana tamanakare wara witamu senua. Paulo nu gita ete baro nakare Asos ena tamamu senua. ");
INSERT INTO sue_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Are baro Asos nate ena nakare tamunua awa. Tamuro wara witinu eroma bamunakare awa. Susaumite Mitilini nate kei awenakare. ");
INSERT INTO sue_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kei awero ana susaunakare pina atinu Kio gutu daininakare. Dainiro susaunakare pina atinu Samos gutura kei awenakare. Noko ana susaunakare pina atinu Mailitas nate kei awenakare. ");
INSERT INTO sue_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo nu pura zo zazo Pentekos awa Yerusalem nate ena gamu sero bayaira awita senua awa. Are nu Efeso nate ena wa doro Asia zebura nuai be tepo wai azu, nakare Efeso dainiro dago susaumite Mailitas nate kei awenakare awa. ");
INSERT INTO sue_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Paulo meni Mailitas nate kei awero oziga iyetinu bamu Efeso nate niro Yesura dubu amira simai gege sero puro muwa awa. ");
INSERT INTO sue_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Puro muwa Paulo meni ge ego tugata wenua awa, “Na Asia zebura kei awero nisokare nana bua naso zaawero wena awa dapikarago susura ena giro tupewewa. ");
INSERT INTO sue_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Na tama naso puro osero Tua sou inoisona. Ago inoise noina Yuda ema meni na iwo inoise damu sasara dire duba naire noisona, awa gosinowa awa. ");
INSERT INTO sue_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Na sogawai ge zo oko soena. Nikare ewanana wawise kakameta so sero gipise tugata wise awinoise noisona awa. ");
INSERT INTO sue_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ago wero Yuda emare Grik emare pasina nusokare awa doro Anutura nana ewesemuro Tua nasokai Yesu Kristo tuma diarise ge zewai-zawai toise noisona. ");
INSERT INTO sue_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Are zeme ei awa Ozana meni na uzupitinoi Yerusalem nate susawena. Ago baro kei awana ona nena nogo nogo naso nana kei awamunoi, awa na kaka gamu inona. ");
INSERT INTO sue_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ei gege gosinona: Benaire yayare ogo na dia itia. Awa nata sero nuawena Ozana meni namore kerenitinowia. ");
INSERT INTO sue_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ota na zebura nuai awa gena nena bamu oko inoya. Ata ebata namore sai amira patiro bayamu ara tapinowena. Anutura dumi yagaba amira Oziga Ewanana awa tugata wanise Tua Yesu meni bua namore senua, are bua awa duba naso meni yaba inoise wana kokopai waise kotupitinowena awa. ");
INSERT INTO sue_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Are sana niniu. Na Anutu imata Tua wero nuamunoya amira oziga ge tugata inoise nisokare nana soe nuawena gosinowewa, nikare ami ama benau naso noko oko gamunowa. ");
INSERT INTO sue_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Anutura kotumai namore potinua awa te nikare tugata wero tepo wena. Zo oko dona itewia. Are na ge me memeka sana niniu. Zo nu gera wamunoya, awa pasina nuso naso nana oko itamunoya. ");
INSERT INTO sue_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nikare nitopekare dia ina-wa inoise dubu nisokare da ago ine kokopai dia wewo. Ozana meni nikare simai nusokare potinua, are nikare Tuara dubu orara nuso meni zuma gaenua nukare awa gipinoise dia wewo. ");
INSERT INTO sue_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Na ego gosinona awa. Na nikare duana ema eni abu suna gorobare meni wago wero nisokare nana kei awero lama dubu oko awa-diamunora. ");
INSERT INTO sue_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Noko nisokare nana ema eni meni eriro Yesura dubu awa dubu nusokare warise opi ge meni uzumuro puro bayamunora. ");
INSERT INTO sue_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Are nikare uma inoise noiwo. Na zepa etorobara pi waiko duba naire noise potai ge imata-kamata tugata wai awa oko dona osenua. Are nikare awa kotupitinoise noiwo. ");
INSERT INTO sue_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Are na nikare Anutura wanera potitinoise dumi yagaba nuso amira ge meni nikare soremaise tona. Ge nuso meni duba nisokare sogawai zewai wai te inoya. Wau Anutura gegenai dapikarago meni pamunora, wau awa ge nuso meni nimorekare potai ine te. ");
INSERT INTO sue_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Na nisokare nana noise wau nisokare silvata golta mo ami emo duba-duba oko wena. ");
INSERT INTO sue_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Na ata ema mamai naso nakare emo wana naso meni tamara bua wasana nena kei awinoisonua, awa gosinowewa. ");
INSERT INTO sue_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Tamara bua zewai-zawai inoise ema sime-sime wai awa dumi pupinoise kora wawise amira ebata patitinoise susu giti nikare gipena. Are nikare ebata da amira patitinoise Tua Yesu meni ge ego senua awa kotumuwo, ‘Dumi pupise nise awaira yawa sara wai awa kota, dumi otao mai emo nupe gege wai ami meni awa duba yawa sarara nena me inoya awa.’ Tua Yesu meni gita ago senua awa.” ");
INSERT INTO sue_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo nu ge ago sero tepo wero numorekare dai bawa diro begomo senua. ");
INSERT INTO sue_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Begomo senu Paulo saniro imuro dire-buare wewa. ");
INSERT INTO sue_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nu gita ge ego senua awa, “Nikare benau naso noko oko gamunowa,” ge awa giwa mou-mau bamubake wenu dire-buare wewa. Ago wero u wara potiwa awa. ");
INSERT INTO sue_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nakare nukare doro wara witiro ebata da woiniro susaumite Kos gutura kei awenakare. Pina atinu Roza gutura kei awero doro susaumite Patara nate kei awenakare awa. ");
INSERT INTO sue_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ago wero ana wa zo Fonisia zebura bayamu sero nena pupinoinu tamuro amira witiro bamunakare. ");
INSERT INTO sue_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Susaumite Saipras gutu giti moka meni gege giro wana anikara itinu daininakare awa. Ago wero susaumite Siria zebura kei awero Taya nate witinakare awa. Ana wa meni nena poti ete ninua. ");
INSERT INTO sue_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ago inoinu nakare ana nate witiro Yesura dubu tamuro waiko be 7 ago noinakare awa. Ago noinakare Ozana meni nukare senu giro Paulo Yerusalem nate bayai azu sewa. ");
INSERT INTO sue_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Are bayaira be munu giro ema bamere mai awisore dapikarago eriro nakare puro nata doro bamu ewa bera niwa. Ago wero kora ena bawa diro isa serokare ina-arena wero ");
INSERT INTO sue_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","wara witinakare nukare ewesemuro bamu nate niwa awa. ");
INSERT INTO sue_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nakare Taya nate ena susaumite Tolemes nate kei awenakare. Ana Yesura dubu tamuro pi daimata numorekare dai aunakare. ");
INSERT INTO sue_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Pina atinu susaumite Sisaria nate kei awero Filip tamuro so nusora witinakare awa. Filip nu soga wai 7 Yerusalem ena gita sianiwa amira zo. ");
INSERT INTO sue_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Mai nuso bama diri 4 iu kaka pumamu noisowa nukare ami porofete meni sago inoise noisowa. ");
INSERT INTO sue_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Are nakare ago be susumuro noinakare Yudaya zebura ena porofete zo zazo nuso Agabo meni nasokare nana kei awenua awa. ");
INSERT INTO sue_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kei awero Paulora ipu gei puro ami te-wana nuso beniro ego senua awa, “Ozana meni ge ego toya, ‘Ipu gei emira mama nu Yerusalem nate baro kei awai Yuda ema meni nu ego ine beniro ema dubu zora wanera potamunora awa.’” ");
INSERT INTO sue_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ge ago senu nakare ata nata susu ami Paulo Yerusalem nate witai azu duaise ge beina wenakare awa. ");
INSERT INTO sue_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ge beina wenakare ego senua awa, “Nikare nogoro di toise duba nai namore potitinowi? Na Yerusalem nate ena Tua Yesu emo inoise benaira daba kota, nu emo inoise betamu sia wero nowena awa.” ");
INSERT INTO sue_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ago senu nakare ge senakare kaka ninamu wenu giro doro ego senakare awa, “Tuara ge me waise.” ");
INSERT INTO sue_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Waiko be eni tepo wenu Yerusalem nate witamu sero nena sia wero atira peninakare. ");
INSERT INTO sue_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Are Sisaria natara Kristen eni meni namorekare dai bamuwa. Nukare nakare puro poti ema zo zazo Neson amira sora niwa toinakare. Nu Saipras gutura ena kei awai. Nu Kristen matu awa. ");
INSERT INTO sue_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Are nakare ana susaumite Yerusalem nate kei awenakare Yesura dubu meni yawa sara inoise nakare areniro otao wewa. ");
INSERT INTO sue_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ago wewa pina atinu Paulo meni nakare uzumunu Yakobora nana sora witinakare awa. Witiro itinakare Yesura dubu amira gita wai dapikarago ami nuso nana kokouniwa. ");
INSERT INTO sue_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Kokouniwa Paulo meni wana nusokare ziro amire Anutu meni soremunu ema Yudakora nana bua wenu me wenua amira uge zo da kaka duamu diro pesuninua awa. ");
INSERT INTO sue_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Paulo meni uge wero pesuninu Anutu bowi wero Paulore ego sewa awa, “O otao, susu zo sanakare giyo. Yuda ema tausen giti meni Yesura dubu wero nowera. Nukare dapikarago Yesu tuma didinoise Mosera lo ge awa ziro baitiro puro nowera awa. ");
INSERT INTO sue_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Are ge niso ego mawi ninitinowenakare: Yuda ema, ema Yudakora nana soe nowera nukare Mosera lo ge duarise tugata inowesa sia. Ago inoise mai mamai nusokarera tama aiso kapai azu towesa sia. Yuda emara nuai awa duarise towesa sia. ");
INSERT INTO sue_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nata emira ge ninai ema nukare nimore ago gosinowera, are nogo wamunonikai? Ni Yerusalem nate mesa amira oziga ninamunora. ");
INSERT INTO sue_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Are nakare ge zo sanakare weyo. Nasokare nana ema zoeto-zoeto nora nukare ami Anutura nana sai zewai wai nusokare sisera, are giti tu nusokare kaka kapamu tepo nowera. ");
INSERT INTO sue_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Are ni numorekare tairo Yuda emara sewai saramai amira tani awa wewo. Wero zame potaira tani nusokare amira zuma gayasa giti tu nusokare kapare. Ni ago wasa ni giro nimore ego samunora, ‘Ge nuso munu nininakai awa me tepo. Nu Mosera lo ge awa dipinoise nowia.’ Nimore ago samunora. ");
INSERT INTO sue_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ota ema Yudako tuma diaire nukare wo tua opire zame potai awa oko narise, wora orara oko narise, wo duba anisemawera betawera orara kaka zozamu inowera amira me oko narise, bama bewana oko warise — nena ago awa duarise nakai ge te sero pas zo gaero potinakai awa.” Ago sewa awa. ");
INSERT INTO sue_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ago sewa Paulo meni ge nusokare niniro ema zoeto-zoeto nusokare nana susumunu pina atinu nu numorekare dai saramai nuamu sewai saramaira tani awa wenua. Ago wero ibu bamura toiro sewai saramaira be tepo waira be potamu o noko zame potai nusokare da da amira be potamu sero pris dubu tugata wenua awa. ");
INSERT INTO sue_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Saramai bua wamu sero sewa amira waiko be 7 awa tepo wamu inoinu Paulo meni ibu bamura toiro noinu Asia zebura Yuda ema nukare nu giro ema dapikarago duba gaewa buru zara wewa. ");
INSERT INTO sue_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Duba gaero Paulo saniro pumuro zawa sero ego sewa awa, “O Isreli ema, muu. Nakare soremawe. Ema emi zebu sero noise Yuda ema nakai iwo inoise lo ge nasokaire ibu bamu nasokaire puro osisinoise nowia. Ago wero ema Yudako eni uzumi ibu bamu nasokaira toiro ibu saramai ei awa bemiti wetera.” ");
INSERT INTO sue_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ago sewa, nera kota, gita Paulo meni Efeso ema zo zazo Trofimo amire dai nate ena izima-sauma wenu giwa. Are sirero ego sewa awa, “Ibu bamu nasokai awa ema Yudako meni toyai ine tepo, awa ema Yudako zo uzumuro puro toia.” ");
INSERT INTO sue_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ago sewa Yuda ema dapikarago tini kapenu sumuro muro kokouniro nu zimuwa. Ago wewa ema eni meni Paulo ibu mokara ena ziro zumuro puro osewa awa. Puro osewa ibura so be gazewa awa. ");
INSERT INTO sue_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ema nukare Paulo puro dara betaise inoiwa oziga Roma soldiara giti kopi amira nana bamunu nininua, “Yerusalem ema bama dapikarago bogi inora awa.” ");
INSERT INTO sue_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ge ago niniro giro soldia osaire witaire puro eya bamuwa. Bamuwa ema Paulo doinoiwa ami soldiara giti kopire soldia dubure kei awewa giro dowa. ");
INSERT INTO sue_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ago wewa soldiara giti kopi meni kei awero Paulo ziro sen eto meni benarise senu beniwa awa. Beniwa giti kopi meni atata wero senua awa, “Nu aweni? Nu pasina ne weti?” ");
INSERT INTO sue_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ago senu nukare eni ge zo sewa, eni ge zo sewa, ago inoise gunai bua wewa ge susu kaka ninamu wero giro senu soldia meni Paulo puro soldiara ibu zewai amira bamuwa. ");
INSERT INTO sue_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ago wewa Paulo nu niwira witamu sero wenu ema nukare zimuro goroba bamu inoiwa giro soldia meni Paulo dimuro puro niwira witiwa. ");
INSERT INTO sue_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ema dubu bamubake meni ama ganinoise zawa gatero ego sewa awa, “Deu betae.” ");
INSERT INTO sue_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Soldia meni Paulo puro so mokara toyamu sero inoiwa nu soldiara dia bamu atata wero senua awa, “Na ge zo nimore saunita?” Ago senu dia bamu meni ego senua awa, “Ni Grik ge gai ni? ");
INSERT INTO sue_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Gita Izip ema zo meni Romara 