﻿USE sofia;
DROP TABLE IF EXISTS sofia.suc_vpl;
CREATE TABLE suc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES suc_vpl WRITE;
INSERT INTO suc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ion non ini og sinulat paꞌali sog pikpongkatan ni Isukristu, nog ion tidu sog pangkat ni Datuꞌ Dabid. Bu si Datuꞌ Dabid tidu dosop sog pangkat ni Abraham. ");
INSERT INTO suc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham og gamaꞌ ni Isak. Si Isak og gamaꞌ ni Jakub. Si Jakub og gamaꞌ ni loꞌ Juda bu pigilugananan non. ");
INSERT INTO suc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda og gamaꞌ ni loꞌ Peres bu Sera, bu og ginaꞌ nilan si Tamar. Si Peres og gamaꞌ ni Hesron. Bu si Hesron og gamaꞌ ni Ram. ");
INSERT INTO suc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Ram og gamaꞌ ni Aminadab. Si Aminadab og gamaꞌ ni Nason bu si Nason og gamaꞌ ni Salmun. ");
INSERT INTO suc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmun og gamaꞌ ni Buas. Og ginaꞌ ni Buas ion non si Rahab. Si Buas og gamaꞌ ni Obed bu og ginaꞌ ni Obed si Rut. Si Obed og gamaꞌ ni Jese. ");
INSERT INTO suc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Si Jese og gamaꞌ ni Datuꞌ Dabid. Si Datuꞌ Dabid og gamaꞌ ni Solomon. Og ginaꞌ ni Solomon og kiboluan ni Urias. ");
INSERT INTO suc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon og gamaꞌ ni Rehobuam. Si Rehobuam og gamaꞌ ni Abidya bu si Abidya og gamaꞌ ni Asa. ");
INSERT INTO suc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa og gamaꞌ ni Jehosapat. Si Jehosapat og gamaꞌ ni Joram bu si Joram og gamaꞌ ni Usia. ");
INSERT INTO suc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Usia og gamaꞌ ni Jotam. Si Jotam og gamaꞌ ni Ahas bu si Ahas og gamaꞌ ni Hesekaya. ");
INSERT INTO suc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Hesekaya og gamaꞌ ni Manase. Si Manase og gamaꞌ ni Amon bu si Amon og gamaꞌ ni Josia. ");
INSERT INTO suc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josia og gamaꞌ ni loꞌ Jekonia bu pigilugananan non. Ion non ituꞌ og masa nog kobihag dia sog gotow Israelanan nog pinitang ilan dituꞌ sog bonua nog Babilon. ");
INSERT INTO suc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Dangan mitubus bihagoy og gotow Israelanan sog Babilon, si Jekonia og gamaꞌ ni Salatiel bu si Salatiel ion og gamaꞌ ni Serubabel. ");
INSERT INTO suc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Serubabel og gamaꞌ ni Abiud. Si Abiud ion non og gamaꞌ ni Eliakim bu si Eliakim og gamaꞌ ni Asur. ");
INSERT INTO suc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asur og gamaꞌ ni Saduk. Si Saduk og gamaꞌ ni Akim bu si Akim og gamaꞌ ni Eliud. ");
INSERT INTO suc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud og gamaꞌ ni Eliesar bu si Eliesar og gamaꞌ ni Matan bu si Matan og gamaꞌ ni Jakub. ");
INSERT INTO suc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jakub og gamaꞌ ni Jusep, og duoy ni Jusep si Maria og ginaꞌ ni Isus. Si Isus, ion non ion og iningolanan kituꞌ nog Kristu. ");
INSERT INTO suc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dadi, ongon sopuluꞌ bu pat pangkat tidu dia ni Abraham mangoy dia ni Dabid. Bu ongon sop sopuluꞌ bu pat pangkat tidu dia ni Dabid mangoy dia sog kobihag kituꞌ dia sog gotow Israelanan sog Babilon. Bu ongon dosop sopuluꞌ bu pat pangkat tidu dituꞌ mangoy sog kobataꞌ dia sog Kristu. ");
INSERT INTO suc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maꞌ nini og bianbian paꞌali sog kobataꞌ dia ni Isukristu. Si Maria, og ginaꞌ ni Isus, pigbayal ilan na ni Jusep. Tibua, sog daꞌ ilan pa pogampuꞌ ni Jusep, kisunan non na nog ion pogbogat bianan sog Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Sabap nog si Jusep koni midulus, dangan kisunan non nog migbogat na si Maria, mipikil non nog diꞌ non na ion pogduoyon. Sugaꞌid non, pogudasan non na si Maria nog ilanilan da poꞌ ompok ion nog kosipogan si Maria. ");
INSERT INTO suc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dadi, sintak non mokpikilpikil dun, mikotulug ion. Sog solian non koyon motulug, tinumuaꞌ dianon bianan sog toginopon og moloikat nog Mikpongon mangka poktaluꞌ nog, “Ika, Jusep, og pangkat a ni Dabid, naꞌ a mogalangalang mogduoy dia ni Maria. Poꞌ saꞌan ion migbogat poꞌ bianan sog Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mogbataꞌ ion nog glaki bu ingolanoy mu ion nog Isus poꞌ tobangon non og pigotowanan non tidu sog dusaanan nilan.” ");
INSERT INTO suc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Og glam nog bianbian koni, ion non og kotumanan nog tinaluꞌ kituꞌ nog Mikpongon bianan sog polomolatas nog taluꞌ non nog si Isaya nog, ");
INSERT INTO suc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ongon og sala kotow dolaga nog daꞌ sibon kotuyok, mogbodos mangka pogbataꞌ nog glaki. Og bataꞌ non koyon ingolanan nog Emanuel.” Somoꞌ ita da, og Mikpongon dia na nita. ");
INSERT INTO suc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Dangan mitanud si Jusep, inunut non og tinaluꞌ nog moloikat kituꞌ nog Mikpongon dianon. Dadi, pigduoy non si Maria. ");
INSERT INTO suc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tibua, daꞌ non tuyokoy si Maria taman da daꞌ non botaꞌoy og bataꞌ non koyon nog glaki. Dadi, iningolanan non og bataꞌ koyon nog Isus. ");
INSERT INTO suc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Dangan binataꞌ si Isus dituꞌ sog Betlehem nog sakup nog probinsia nog Judia sog masa nog kopogdatuꞌ ni Datuꞌ Herod, miobonobon golot non, ongon og polomitunanan nog miktidu sog silangan nog minangoy sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Dangan minatong ilan dituꞌ, miksak ilan sog gotowanan nog, “Ain noma og bataꞌ kituꞌ nog saꞌan ion binataꞌ poꞌ mogdatuꞌ sog bansa Hudyu? Poꞌ mitongow nami dituꞌ sog silangan og bitun non. Saꞌan minangoy ami dini poꞌ mangoy ami sumalam dianon.” ");
INSERT INTO suc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Dangan midongog ni Datuꞌ Herod og taluꞌ nilan koyon, misusa ion tokodoy dun. Bu konaꞌ non tibua, sugaꞌid non, asta og glam nog gotowanan sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Dadi, pilumpuk non og glam nog mokokotas nog boliananan bu og polopanadanan nog botad nog bansa Hudyu mangka non sakoy dianilan nog, “Ain dodaꞌ dapit botaꞌoy og Kristu?” ");
INSERT INTO suc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tinumabal ilan nog, “Sog Betlehem og sakup nog Judia. Kisunan nami ini poꞌ ion non ini og sinulat nog polomolatas nog taluꞌ nog Mikpongon nog si Mika, ");
INSERT INTO suc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ika, Betlehem, dia sog bonua nog Judia, ika og motas sog glam non poꞌ dianika poktidu og Kounutan nog mogipat nog pigotowan ku nog bansa Israel.’” ");
INSERT INTO suc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dadi, tinugun ni Herod og polomitunanan kituꞌ nog ilanilan da. Bu mitantu non tokodoy dianilan og tang nog kotongow nilan nog bitun kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tubus nituꞌ, dinondag non ilan mangoy dituꞌ sog Betlehem. Bu tinoluꞌan non ilan nog, “Panow amu, mangka niu ponontong nog mahatul og bataꞌ kituꞌ. Bu bila motongow niu na ion, posun niu dianakon bagun da akon siꞌoy, mokangoy u dosop sumalam dianon.” ");
INSERT INTO suc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Puꞌun midongog nilan og taluꞌ nog datuꞌ koyon, miglandan ilan sog gongayan nilan. Bu og bitun kituꞌ nog mitongow nilan sog silangan, miguna dianilan bu dituꞌ mikpotondong sog bonua kituꞌ nog binotaꞌan dia sog bataꞌ koyon. ");
INSERT INTO suc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Dangan mitongow nilan og bitun kituꞌ, landuꞌ na og daꞌdaꞌan nilan dun. ");
INSERT INTO suc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dangan minatong ilan sog baloy koyon, sinumolod ilan bu mitongow nilan og bataꞌ bu og ginaꞌ non nog si Maria. Dadi, mikpongingluꞌud mangka ilan salam sog bataꞌ koyon bu pingukad nilan og golotaꞌ kituꞌ nog inoit nilan bu uokiloy sog bataꞌ koyon og bulawan, bu og ginis nog komangyan nog landuꞌ kologan, bu og mira. ");
INSERT INTO suc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Dadi, dangan minuliꞌ ilan na, pigondiꞌan ilan nog Mikpongon bianan sog toginopon nog diꞌ ilan na mian dituꞌ ni Herod. Dadi, dia ilan minian sog len dalan posunguꞌ sog bonua nilan. ");
INSERT INTO suc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Dangan minuliꞌ na og polomitunanan kituꞌ, og moloikat nog Mikpongon mikpotongow dia ni Jusep bianan sog toginopon bu miktaluꞌ nog, “Pogbuat a. Oit mu molaguy og bataꞌ koyon ilan nog ginaꞌ non dituꞌ sog Ihiptu. Taman da diꞌ u ika dondagon mawaꞌ, dituꞌ amu pa pogonongonong. Poꞌ si Herod pokponontongon non og bataꞌ koyon poꞌ bunuꞌon non.” ");
INSERT INTO suc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dadi, sog sododuꞌun og gobi koyon, migbuat mogdayun si Jusep mangka non oitoy og bataꞌ koyon ilan nog ginaꞌ non dituꞌ sog Ihiptu. ");
INSERT INTO suc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bu dituꞌ ilan migonong asta minatoy si Herod. Bianan sog maꞌ nion koyon, mituman og tinaluꞌ kituꞌ nog Mikpongon bianan sog polomolatas non nog, “Sinabi u og bataꞌ u nog mawaꞌ na sog Ihiptu.” ");
INSERT INTO suc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Koni sop ni Herod, dangan kisunan non nog daꞌ pokokunut dianon og polomitunanan kituꞌ, linolingitan ion tokodoy dun. Dadi, dinondag non momunuꞌ og glam nog gombataꞌanan nog kolokian tidu sog kobotaꞌoy dun asta sog duaꞌ ton og tinonan non dituꞌ sog Betlehem bu asta sog glumibut nog bonua koyon. Poꞌ pigonaꞌonaꞌ non og tang nog kotaluꞌ nog polomitunanan kituꞌ dun dianon nog kotongow nilan nog bitun kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Dadi, og taluꞌ kituꞌ bianan dia sog polomolatas nog taluꞌ nog Mikpongon nog si Jerimaya mituman nog, ");
INSERT INTO suc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Midongog dituꞌ sog Rama og sogowanan bu og mikponglangos poꞌ piksogowan ni Rakel og gombataꞌanan non bu ondiꞌ ion kopongomuꞌan poꞌ mitipot na pomatoy og gombataꞌanan non.” ");
INSERT INTO suc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Dangan minatoy na si Herod, mikpotongow nosop og moloikat nog Mikpongon dia ni Jusep dituꞌ sog Ihiptu bianan sog toginopon ");
INSERT INTO suc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","bu poktaluꞌ nog, “Jusep, pogbuat a. Oit mu og bataꞌ koyon ilan nog ginaꞌ non mangka amu angoy sog bonua nog Israel. Poꞌ og gotow kituꞌ nog moksipi munuꞌ sog bataꞌ koyon minatoy na.” ");
INSERT INTO suc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dadi, migbuat si Jusep mangka non ilan pitangoy dituꞌ sog bonua nog Israel. ");
INSERT INTO suc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tibua, dangan kisunan ni Jusep nog si Arkelaus og mikosukli sog gamaꞌ non nog si Herod mogdatuꞌ sog Judia, miondok ion mangoy mogonong dituꞌ. Poꞌ pidonsamaꞌ tumaluꞌ dianon bianan sog toginopon. Saꞌan ituꞌ miglandan ion sog probinsia nog Galili. ");
INSERT INTO suc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Bu dituꞌ ilan migonong sog koliwagan bonua nog Nasaret. Ion non ini og kotumanan nog tinaluꞌ nog Mikpongon bianan sog polomolatas non kobon nituꞌ nog, “Ingolanan ion nog gotow Nasaret.” ");
INSERT INTO suc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Minian og tinonan, ongon sala kotow gotow polomali ngalan non si Jan nog Polomunyag. Dituꞌ ion mimali sog bonua kituꞌ nog mologon pogonongan nog dituꞌ sog Judia. ");
INSERT INTO suc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Og pomali non maꞌ nini, “Poglilaꞌ amu nog dusaanan niu poꞌ mosompol na og kopogdatuꞌ nog Mikpongon dianita.” ");
INSERT INTO suc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Jan, ion non ion og pigolong nog polomolatas kituꞌ nog taluꞌ nog Mikpongon nog si Isaya, “Ngon og moktawag sog bonua kituꞌ nog mologon pogonongan nog, ‘Simpan niu og bianan nog Pogbayaꞌ nog posunguꞌ matong bu pologdong niu og dalan non.’” ");
INSERT INTO suc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Si Jan, og ponopoton non og bombul nog kamel nog inabol. Bu bagos non og panit nog potubuꞌon. Bu og pongonganon non og gapan bu tonob. ");
INSERT INTO suc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Modakol og gotowanan nog mikpogangoy dituꞌ non nog mikpoktidu sog Jerusalem bu sog gliwag nog probinsia nog Judia bu sog bonuaanan nog mingigbid sog glawas nog tubig nog Jurdan. ");
INSERT INTO suc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mikpogangoy ilan moglilaꞌ nog dusaanan nilan sog Mikpongon mangka ilan pokpobunyag dia ni Jan dituꞌ sog glawas nog tubig nog Jurdan. ");
INSERT INTO suc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tibua, dangan mitongow non og modakol parasiuanan bu og sadusiuanan mikpogangoy dituꞌ non mokpobunyag, tinoluꞌan non ilan nog, “Amu, og tupuꞌanan amu nog mamak kituꞌ nog molala! Sima miktaluꞌ dun dianiu nog mokopolaguy amu sog posunguꞌ koyon matong nog polihalaꞌ nog Mikpongon? ");
INSERT INTO suc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sugaꞌid non, potongow niu nog miktantu amu tumolikud sog dusa niu bianan sog glangka niu. ");
INSERT INTO suc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bu naꞌ amu sumalig nog dangan pa og pangkat amu ni Abraham nog motabang amu na. Poꞌ toluꞌon ku dianiu, bila tibobaꞌon nog Mikpongon, minsan og batuanan koni moktimaluy nog pangkat ni Abraham. ");
INSERT INTO suc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Og bayuꞌ nog kopongukum nog Mikpongon ompononggiꞌ dia sog kapa nog pitom na dia sog pun nog kayu nog posunguꞌ na ponogaꞌon. Bu ain og kayu kituꞌ nog diꞌ mogbunga nog molongas, ponogaꞌon mangka tikpuꞌoy sog gapuy.” ");
INSERT INTO suc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Long sop ni Jan dun, “Akon, bunyagan ku amu bianan sog tubig ain moktantu tumolikud dia sog dusa non. Tibua, ongon sala kotow tumondug dianakon nog motas pa tokodoy dianakon poꞌ diꞌ u tanan patut minsan siꞌoy sagya kumeteng nog pongyapak non. Ion og momunyag dianiu bianan sog Bolakat nog Mikpongon bu og gapuy. ");
INSERT INTO suc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Poꞌ og bayuꞌ nog kopongukum non pinonggiꞌ dia sog gotow nog minangoy mokpalid nog paloy non. Ain og glinggas polenan non bu toguꞌoy dia sog komalig. Tibua, ain og pis doksulan non nog gapuy nog ondiꞌ ompalong somul non.” ");
INSERT INTO suc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tubus nituꞌ, ginumonat si Isus sog Galili mangka angoy sog glawas nog tubig nog Jurdan poꞌ mokpobunyag dia ni Jan. ");
INSERT INTO suc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tibua, ondiꞌ bosia bunyagan ni Jan. Maꞌ long non dun, “Akon pa tanan og ombaꞌis mokpobunyag dianika, saka ika ma og mangoy mokpobunyag dianakon?” ");
INSERT INTO suc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tibua, tinabal ion ni Isus nog, “Inang mu pa ion numun koni bagun munut og glam nog glegan nog Mikpongon.” Dadi, mioleg si Jan. ");
INSERT INTO suc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ampun midoksuꞌ bunyagoy si Isus, ginumawon ion sog tubig. Sog sododuꞌun koyon, mibukaꞌ og glangit bu mitongow non og Bolakat nog Mikpongon mamaꞌ nog kolopati nog posunguꞌ tumonaꞌ bu mangka apun dianon. ");
INSERT INTO suc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bu ngon og taluꞌ nog tidu sog glangit nog mamaꞌ nini, “Koni og bataꞌ u nog kololaman ku. Kisuꞌatan u tokodoy dianon.” ");
INSERT INTO suc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tubus nituꞌ, pinuluꞌan si Isus nog Bolakat nog Mikpongon mangoy dituꞌ sog bonua kituꞌ nog mologon pogonongan bagun ion pongyubaꞌan ni Kindagow. ");
INSERT INTO suc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dangan mitubus si Isus mokpuasa sog solod nog pat puluꞌ gobi, migutom ion. ");
INSERT INTO suc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tinuaꞌan ion nog Polongyubaꞌ kituꞌ mangka poktaluꞌ nog, “Bila motud nog Bataꞌ a dodaꞌ nog Mikpongon, dondag mu dow buan og batuanan koni nog moktimaluy pan.” ");
INSERT INTO suc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tinumabal si Isus nog, “Sinulat dia sog Kitab nog konaꞌ sagya og pan og kotubuꞌan nog gotow, sugaꞌid non, bianan sog glam nog taluꞌ nog toluꞌon nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tubus nituꞌ, inoit ion ni Kindagow dituꞌ sog Jerusalem mangka non ion popunoy dia sog kolowaan nog dibabow nog Baloy nog Poktomuyan dia sog Mikpongon mangka ion poktaluꞌ nog, ");
INSERT INTO suc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Bila motud nog Bataꞌ a dodaꞌ nog Mikpongon, okpu a! Poꞌ sinulat dia sog Kitab nog, ‘Og Mikpongon, dondagon non og moloikatanan non mogipat dianika. Bu toyakon nilan ika bagun da minsan siꞌoy og botis mu ondiꞌ mosugat dia sog batu.’” ");
INSERT INTO suc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Dadi, tinabal ion ni Isus nog, “Sinulat dosop dia sog Kitab nog, ‘Sumboy diꞌ mu sulayan og Mikpongon nog ion og Diwata mu.’” ");
INSERT INTO suc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tubus nituꞌ, inoit nosop ni Kindagow si Isus sog motas kituꞌ tokodoy nog bulud mangka non potongowoy dianon og glam nog pigdotuꞌan dini sog dunya bu og kolongas non mangka poktaluꞌ nog, ");
INSERT INTO suc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Og glam nog mitongow mu koni bogoyon ku dianika bila mombaꞌ a mangka a tamuy dianakon.” ");
INSERT INTO suc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dadi, tinoluꞌan ion ni Isus nog, “Awaꞌ a na dini, Kindagow! Poꞌ sinulat dia sog Kitab nog tamuy mu og Mikpongon nog ion og Diwata mu bu ion tibua og pokokunutoy mu.” ");
INSERT INTO suc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dadi, ginonatan ion ni Kindagow bu og moloikatanan nog Mikpongon minangoy dion non mangka nilan ion usibaꞌoy. ");
INSERT INTO suc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dangan midongog ni Isus nog kinolobusu si Jan nog Polomunyag, mikpuliꞌ ion sog Galili. ");
INSERT INTO suc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Minawaꞌ ion sog Nasaret, mangka angoy pogonong dituꞌ sog Kapernaum, nog dia sog goksid nog danow nog Galili nog bakas bonua niloꞌ Sibulun ilan ni Naptali kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ion non ion og kotumanan nog tinaluꞌ kituꞌ nog polomolatas nog Mikpongon nog si Isaya nog, ");
INSERT INTO suc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Og gotowanan sog bonua nog Sibulun bu Naptali nog dituꞌ dapit sog danow, bu sog dipag nog tubig nog Jurdan, dituꞌ sog Galili nog pigbonuaan nog konaꞌ Hudyu, ");
INSERT INTO suc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ilan og gotowanan koyon nog migonong sog modolom. Mitongow nilan na og dolag nog motilak tokodoy. Ilan koyon nog migonong dia sog bonua nog pigboyaꞌan nog patoy, kisilowan ilan nog dolag.” ");
INSERT INTO suc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tidu sog kangoy ni Isus kituꞌ sog Kapernaum, miktolipun ion momali nog, “Poglilaꞌ amu na nog dusaanan niu poꞌ mosompol na og kopogdatuꞌ nog Mikpongon dianita.” ");
INSERT INTO suc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tubus nituꞌ, sog solian ni Isus mokpopongoksid sog danow nog Galili koyon, mitongow non og duaꞌ kotow pogilug nog si Simun nog og koduaꞌ ngalan non si Piter bu og kongudan non nog si Andriu. Solian nilan monglaya sog danow koyon poꞌ og tolisodaꞌ ilan. ");
INSERT INTO suc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Dangan mitongow ilan ni Isus, tinoluꞌan non ilan nog, “Alung, pogunut amu dianakon poꞌ imungon ku amu nog moktolisodaꞌ nog gotow.” ");
INSERT INTO suc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sododuꞌun ginonatan nilan og glayaanan nilan koyon mangka ilan pogunut dianon. ");
INSERT INTO suc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Miglandan ilan. Bu sog solian nilan ompanow, mikotongow ilan nosop nog duaꞌ kotow pogilug si loꞌ Jems bu si Jan nog gombataꞌ ni Sebedi. Ilan bu og gamaꞌ nilan, dion ilan sog bolangoy sanan nilan momunaꞌ nog pokot nilan. Inonggat ilan ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sododuꞌun ginonatan nilan og bolangoy nilan bu og gamaꞌ nilan mangka ilan pogunut dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tubus nituꞌ, miguliugan si Isus sog gliwag nog Galili. Mikpanad ion dia sog baloyanan nog poglumpukan nog bansa Hudyu bu pogustal nog Gombaꞌis nog Guksugan paꞌali sog pigdotuꞌan nog Mikpongon. Bu pikodag non og glam nog diꞌ mokokodag bu ain og togo mosakit. ");
INSERT INTO suc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Og dongogan paꞌali dianon mipulonag dia sog gliwag nog bonua nog Siria. Bu pinitang nog gotowanan dituꞌ non og glam nog togo mosakit nog miglologinis og mokosakit nilan, bu ain miglogaga tokodoy nog mosakit, bu ain sinongonan nog glatdiwataanan, bu ain og bobuybobuyon, bu asta og dadayanan. Bu og glam non koyon kiuliꞌan ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sabap dion, modakol og gotowanan nog mikpogunut dianon, mikpoktidu sog Galili, sog Dikapolis, sog Jerusalem, sog Judia, bu sog dipag nog Jurdan. ");
INSERT INTO suc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Dadi, dangan mitongow ni Isus og modakol nog gotowanan nog migunut dianon, tinumukad ion mikaꞌan mangka ion ingkud. Pilonian ion nog sulangguꞌanan non ");
INSERT INTO suc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","bu pionadan non ilan. Maꞌ long non dun, ");
INSERT INTO suc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Pipia ain og kisunan nilan nog ngon pa og kulang nilan dia sog kinodiwata, poꞌ mikampuꞌ ilan sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Pipia ain lumangos poꞌ pongomuꞌan ilan da nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Pipia ain molumbang poꞌ motabuk nilan da og pinasad nog Mikpongon dianilan. ");
INSERT INTO suc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Pipia ain mogapas nog kodulusan poꞌ malap nilan da. ");
INSERT INTO suc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Pipia ain molilolatoy poꞌ kololatan ilan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Pipia ain ombaꞌis pikilan non, poꞌ motongow nilan og Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Pipia ain og mogapas nog kopoglogomigus poꞌ ingolanan ilan nog gombataꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Pipia ain pikposokitan sabap sog kopokokunut nilan dia sog kodulusan poꞌ mikampuꞌ ilan dia sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Pipia amu bila tompolaꞌon amu, bu pokposokitan amu, bu ponoluꞌnoluꞌan amu nog mokolaton nog ponoluꞌon nog diꞌ motud sabap sog kopokokunut niu dianakon. ");
INSERT INTO suc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pogloliag amu bu pogdaꞌdaꞌ amu poꞌ mosolag og sugda nog sinimpan dianiu dituꞌ sog glangit. Poꞌ maꞌ nituꞌ dosop og kopokposakit nilan nog polomolatasanan nog taluꞌ nog Mikpongon nog mikuna pa dianiu.” ");
INSERT INTO suc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Amu koyon, mamaꞌ amu nog masin dia sog gotowanan sog dunya koni. Tibua, bila molubas na og nanam non, daꞌidun nododaꞌ og pondayan dun bagun masin pa mokpuliꞌ. Dadi, daꞌidun na og potugyuan dun ual da sog pilakon na bu pogdogyakdogyakon tibua nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Bu mamaꞌ amu dosop nog tiow nog gotowanan dini sog dunya. Og koliwagan bonua nog dia sog bontud ondiꞌ ombuni. ");
INSERT INTO suc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bu daꞌidun sop gotow nog tumutud nog suluꞌ mangka non dugbaꞌoy nog sibulan. Sugaꞌid non, dia non nododaꞌ botangoy sog motampal poꞌ bagun da kodolagan og glam nilan dion sog dialom nog baloy koyon. ");
INSERT INTO suc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Domikian nog maꞌ nituꞌ amu dosop. Dadi, silow amu dia sog gotowanan, bagun nilan motongow og molongas nog kohinangan niu bu kosonglitan dun og Gamaꞌ niu dituꞌ sog glangit.” ");
INSERT INTO suc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Naꞌ amu momikil nog saꞌan minangoy u dini sog dunya koni poꞌ owaꞌon ku og Botad nog sinulat ni Muses bu og pomali nog polomolatasanan kituꞌ nog taluꞌ nog Mikpongon kobon nituꞌ. Sugaꞌid non, inangoy u tumanoy dianiu. ");
INSERT INTO suc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Toluꞌon ku dianiu, solian nog ongon pa og glangit bu og glupaꞌan, ondiꞌ sop kokulangan og Botad kituꞌ minsan mikaꞌan siꞌoy taman da ondiꞌ motuman og glam non koyon. ");
INSERT INTO suc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dadi, simasima og ondiꞌ mokokunut dun minsan siꞌoy long niu dun diꞌ bololagaꞌ, bu ponadan non og dumaanan non nog ondiꞌ dosop mokokunut nog dondagananan kituꞌ, kingolanan ion nog ombabaꞌ dia sog pigdotuꞌan nog Mikpongon. Tibua, ain og mikokunut sog dondagananan koni bu ponadan non dosop og dumaanan non mokokunut dun, kingolanan ion nog motas dia sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Toluꞌon ku dianiu, bog diꞌ amu da modulus labi pa sog kodulus nog parasiuanan bu polopanadanan nog botad nog bansa Hudyu, ondiꞌ amu nododaꞌ mokampuꞌ dia sog pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Donsamaꞌ niu na midongog nog og mokogulanganan ta kobon nituꞌ pimolian ilan nog, ‘Naꞌ amu momunuꞌ poꞌ simasima og momunuꞌ, ukumon ion.’ ");
INSERT INTO suc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tibua, toluꞌon ku dianiu, nog simasima og sagya mokangit dia sog pakasi non, sumboy ukumon ion. Bu simasima og monompolaꞌ dia sog pakasi non dangon sog motas nog gukum nog bansa Hudyu. Bu simasima sop og moktaluꞌ sog pakasi non nog, ‘Daꞌ gatag mu!’ gomonsunoy mokangoy ion dia sog danow nog gapuy.” ");
INSERT INTO suc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Dadi, bila dituꞌ a sog Baloy nog Poktomuyan dia sog Mikpongon bu posunguꞌ a muakil nog bogoy mu dianon, saka kilobotan mu nog ngon og duma mu nog miglolingit dianika, ");
INSERT INTO suc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","naꞌ mu pa sokaliꞌ uokilon og bogoy mu koyon. Sugaꞌid non, bagak mu pa poguna mangka a angoy poglokopia dianon mangka mu na uakil og bogoy mu kituꞌ sog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Bu bila dangon ka nog pakasi mu, mangka non ika pitangoy sog gukum, dia amu pa sog dalan, poksolikuna a na moglokopia dianon. Poꞌ bila diꞌ mu ilingon maꞌ nituꞌ, uokilon non ika dia sog gukum, bu og gukum sop muakil dianika dia sog pogbayaꞌ sog kolobusuan, bu ion na og kumolobusu dianika. ");
INSERT INTO suc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Toluꞌon ku dianika, nog bila mokolobusu a na, ondiꞌ a na dodaꞌ mokoluas bog diꞌ mu da koboyadan og glam nog kosolaꞌan mu.” ");
INSERT INTO suc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Midongog niu dosop og pomali tidu sog kobon nituꞌ nog, ‘Naꞌ amu momabal nog konaꞌ niu duoy.’ ");
INSERT INTO suc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Numun koni toluꞌon ku dianiu, nog simasima og glaki nog sagya tumontong dunut gimaan non dia sog glibun nog konaꞌ non og duoy, og gotow koyon itungan na nog milawas non na og glibun koyon. ");
INSERT INTO suc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Dadi, bila sabap sog mata mu nog dapit sog glintu mokodusa a dun, golom nika na uning mangka mu pilak. Poꞌ golom pa kowaꞌan ka nog sobolaꞌ mata, gabaꞌ nog sigbuon og tibuk nog glawas mu sog danow nog gapuy. ");
INSERT INTO suc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bu bila sabap sog komot mu nog glintu mokodusa a dun, golom nika na putuk mangka mu pilak. Poꞌ golom pa nog kowaꞌan ka nog sobolaꞌ komot, gabaꞌ nog mangoy og tibuk nog glawas mu sog danow nog gapuy.” ");
INSERT INTO suc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Pimali dosop kobon nituꞌ nog, ‘Simasima og molong nog glibun non, sumboy tumulun nog gitas nog tandaꞌ nog ilan kituꞌ migbolong na.’ ");
INSERT INTO suc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tibua, toluꞌon ku dianiu, simasima og glaki nog molong nog glibun non nog saka daꞌ da bosia koleg sog len glaki, mokodusa ion dun. Poꞌ sabap dituꞌ, mimung mokodusa dosop og glibun koyon dun bila mokopoglaki ion sog len glaki. Bu og glaki kituꞌ nog mokopogduoy dianon mokodusa dosop.” ");
INSERT INTO suc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Midongog niu dosop nog og gotowanan kituꞌ kobon nituꞌ, pimolian ilan nog bila sumapa ilan sumboy ondiꞌ nilan bolubaon, sugaꞌid non, tumanon nilan na dodaꞌ og sinopaan nilan kituꞌ dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tibua, toluꞌon ku dianiu, nog naꞌ amu tokodoy moksapasapa. Naꞌ niu lobiton og glangit, poꞌ ion non ion og gingkudan datuꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Otawaka naꞌ niu dosop lobiton og glupaꞌan, poꞌ ion non ion og guntulan nog botis non. Bu naꞌ niu dosop lobiton og koliwagan bonua nog Jerusalem, poꞌ ion non ion og koliwagan bonua nog motas kituꞌ nog Datuꞌ. ");
INSERT INTO suc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Naꞌ niu dosop lobiton og gulu niu, poꞌ og Mikpongon da og moto mogbayaꞌ bog pitomon non taꞌ otawaka poputiꞌon non taꞌ. ");
INSERT INTO suc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sugaꞌid non, bila tumabal amu, taluꞌ niu tibua nog, oꞌo bila oꞌo. Bu bila sop ondiꞌ, taluꞌ niu nog ondiꞌ. Poꞌ bila polobian niu, og pilabi niu kituꞌ dia na miktidu ni Kindagow.” ");
INSERT INTO suc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Midongog niu na og pomali kobon nituꞌ nog bila mibuta og sala kotow poꞌ kingulanan nog pakasi non, og mikongulan koyon dianon sumboy butaon dosop. Bu domikian dosop maꞌ nituꞌ, bila mikolupuꞌ ion nog ngisi, sumboy ion siꞌoy lupuꞌan dosop nog ngisi. ");
INSERT INTO suc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tibua, toluꞌon ku dianiu, nog ain moginang koyon nog molaton dianiu, naꞌ niu na ontuan. Bila dopiꞌon muluꞌ niu nog dapit sog glintu, tan niu sop dianon og sobolaꞌ muluꞌ niu. ");
INSERT INTO suc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bu bila dangon amu nog gotow mangka non amu oitoy sog gukum bagun non malap og glogdoy niu, naꞌ niu na pogondiꞌan dianon malap asta og sulagbon niu. ");
INSERT INTO suc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bila ngon gotow tumogol dianiu mokpitang nog pitangon non lagaꞌ nog sala kilumitru, pitang niu pa og pitangon non koyon asta sog duaꞌ kilumitru. ");
INSERT INTO suc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bila ongon og gotow nog mongoni dianiu, bogoyoy niu ilan. Bu bila ongon og gotow nog mogodam nog balan niu, podam niu.” ");
INSERT INTO suc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Midongog niu na og pomali kobon nituꞌ nog sumboy mololat a sog glokole mu bu kangit a sog banta mu. ");
INSERT INTO suc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tibua, toluꞌon ku dianiu, nog numun koni kololat amu sog ain minanta dianiu bu pogyokinoy og gotow nog ain mokposakit dianiu ");
INSERT INTO suc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","bagun amu mimung nog gombataꞌanan nog Gamaꞌ sog glangit. Poꞌ ondiꞌ ion mogbigyaꞌ. Pisilowan non nog gondow og gotowanan kituꞌ nog mokobaꞌis otawaka og mokolaton. Bu pidupiꞌan non dosop og gotowanan kituꞌ nog midulus otawaka ain daꞌ kodulus. ");
INSERT INTO suc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bila mololat amu tibua dia sog ain milolat kituꞌ dianiu, naꞌ amu mogdodama nog sugdaan amu nog Mikpongon. Poꞌ minsan og polongabat kituꞌ nog buis nog polonglimbung, mololat da sog ain mololat kituꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Bu bila og golunon niu og glokoleanan niu tibua, og duma gotowanan siꞌoy maꞌ nituꞌ dosop og ginangon nilan. Poꞌ minsan og gotowanan nog ondaꞌ poktamuy dia sog Mikpongon, mokopoginang ilan dosop ion dun. ");
INSERT INTO suc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dadi, sumboy mohurup amu mamaꞌ nog Gamaꞌ niu sog glangit nog mihurup ion.” ");
INSERT INTO suc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Maꞌ long sop ni Isus, “Naꞌ amu tokodoy moginang nog ginang niu dia sog kodulusan nog bagun tibua motongow nog gotowanan. Poꞌ bila maꞌ nituꞌ og ginangon niu, daꞌidun na og sugda nog motabuk niu nog miktidu sog Gamaꞌ niu sog glangit. ");
INSERT INTO suc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Dadi, bila mogbogoy amu dia sog miskinan, naꞌ niu pulonagon dia sog kodokolan nog gotow nog mamaꞌ nog poginangon nog gotowanan koyon nog mokpopotongow ilan tibua dia sog baloyanan nog poglumpukan nog bansa Hudyu bu dia dosop sog kosompagan nog gotowanan bagun ilan pogdongyaꞌan nog gotowanan dun. Toluꞌon ku dianiu nog mitabuk nilan na og glam nog sugda nilan. ");
INSERT INTO suc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tibua, bila mogbogoy amu sog miskinan, naꞌ niu tokodoy posunon minsan dia sog duma, minsan siꞌoy og pakasibataꞌ niu ");
INSERT INTO suc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","bagun da og bogoy niu koyon, daꞌidun mokosun dun lual da og Gamaꞌ niu sog glangit. Ion da og mokotongow nog ain ginang nog piglingod. Bu ion da sumugda dun dianiu.” ");
INSERT INTO suc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Maꞌ long sop ni Isus, “Bu bila sop mogyakin amu, naꞌ amu moglogiling dia sog gotowanan koyon nog mokpopotongow tibua. Loliagon ilan mindog mogyakin dia sog baloyanan nog poglumpukan nog bansa Hudyu bu dia sog kosompagan bagun ilan tibua motongow nog gotowanan. Toluꞌon ku dianiu nog mitabuk nilan na og glam nog sugda nilan. ");
INSERT INTO suc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tibua, bila mogyakin amu, solod amu sog dugu niu mangka amu pomintuꞌ bu pogyakin dia sog Gamaꞌ niu nog ondiꞌ motongow. Ion da og mokotongow nog ain ginang nog piglingod. Bu ion dosop og sumugda dun dianiu. ");
INSERT INTO suc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Bu bila mogyakin amu, naꞌ amu moglogiling sog gotowanan koyon nog daꞌ poktamuy sog Mikpongon nog bila mogyakin ilan, maꞌ nog poktubodon bu pomulakmulakan nilan og gyakin nilan. Poꞌ baluꞌ nilan dun, sabap sog kodakol nog taluꞌ nilan koyon, motabal og gyakin nilan dun. ");
INSERT INTO suc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Naꞌ amu moglogiling dianilan poꞌ og Gamaꞌ niu sog glangit, donsamaꞌ non na kisunan bog olo og kulang niu sog daꞌ amu pa pongoni dianon. ");
INSERT INTO suc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bu bila mogyakin amu, maꞌ nini og toluꞌon niu, ‘Amaꞌ nami sog glangit, pogodaban og ngalan mu poꞌ mosigda a. ");
INSERT INTO suc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bu sabaꞌ nami dun matong na dini og kopogdatuꞌ mu. Bu og glegan mu motuman dini sog glupaꞌan mamaꞌ nog mituman dituꞌ sog glangit. ");
INSERT INTO suc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bogoyoy mu ami nog ponganon nami gondow koni. ");
INSERT INTO suc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bu ompunoy mu na og dusaanan nami poꞌ ami siꞌoy, inompunan nami na ain og mikosalaꞌ dianami. ");
INSERT INTO suc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bu naꞌ mu ami potiangon koyubaꞌan, sugaꞌid non, ipat mu ami sog bayaꞌ ni Kindagow.’ ");
INSERT INTO suc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Bila ompunan niu og gotow nog mikosalaꞌ dianiu, og Gamaꞌ niu siꞌoy sog glangit, ompunan non dosop amu. ");
INSERT INTO suc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tibua, bila ondiꞌ niu ompunan og salaꞌ nilan dianiu, amu siꞌoy, og dusaanan niu ondiꞌ dosop ompunan nog Gamaꞌ niu sog glangit.” ");
INSERT INTO suc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Maꞌ long sop ni Isus, “Bila mokpuasa amu, naꞌ niu potongowon sog glangkalangka niu nog misusa amu mamaꞌ nog gotowanan kituꞌ nog mokpopotongow tibua. Ilan koyon, sopon nilan og bayuꞌbayuꞌ nilan bagun ilan kilolaan nog mikpuasa ilan dodaꞌ. Toluꞌon ku dianiu, nog mitabuk nilan na og sugda nilan. ");
INSERT INTO suc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tibua, bila mokpuasa amu, pongulaꞌup amu mangka amu ponundoy ");
INSERT INTO suc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","bagun ondiꞌ kosunan nog len gotow nog mikpuasa amu. Bu solabuk da og mokosun dun, ion og Gamaꞌ niu sog glangit nog ondiꞌ niu motongow. Ion og mokotongow nog ginang koyon nog piglingod, og sumugda dun dianiu.” ");
INSERT INTO suc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Maꞌ long sop ni Isus, “Naꞌ amu mogomud nog daya niu dini sog dunya poꞌ kokoton da nog gangnay, bu moglogang da, bu modakow da nog polonakow. ");
INSERT INTO suc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sugaꞌid non, pogomud amu nog daya niu dituꞌ sog glangit poꞌ dituꞌ ondiꞌ mokokut nog gangnay, bu diꞌ moglogang, bu daꞌidun na monakow dun. ");
INSERT INTO suc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Poꞌ minsan ain og daya niu, dituꞌ dosop og pomikilan niu.” ");
INSERT INTO suc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Maꞌ long sop ni Isus dun, “Og mata niu mamaꞌ da nog suluꞌ nog glawas niu. Dadi, bila og mata niu daꞌidun og glaꞌat non, og tibuk nog glawas niu kodolagan. ");
INSERT INTO suc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tibua, bila miglaꞌat og mata niu, og tibuk nog glawas niu molokop nog modolom. Dadi, bila maꞌ nituꞌ og dolag koyon dianiu modolom da, landuꞌ dodaꞌ kodolom.” ");
INSERT INTO suc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Maꞌ long ni Isus dun, “Ondiꞌ nododaꞌ mogusoy og gotow nog duaꞌ buk og kounutan non. Poꞌ bila maꞌ nituꞌ, mimung nog pokongitan non og sala kotow mangka non kololamoy og sala kotow. Otawaka, mokokunut sog sala kotow mangka pongantu sog sala kotow. Ondiꞌ mogusoy nog tigbungon niu og pikilan niu dia sog Mikpongon bu tigbungoy dosop dia sog pilak.” ");
INSERT INTO suc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Maꞌ long sop ni Isus dun, “Dadi, toluꞌon ku dianiu, nog naꞌ amu mosusa paꞌali sog kotubuꞌ niu bog olo og ponganon niu bu og ginumon niu, bu paꞌali sog glawas niu bog olo og koponapot niu. Konaꞌ taꞌ nog og kotubuꞌ bololagaꞌ pa dia sog ponganon bu og glawas bololagaꞌ pa sog ponopoton? ");
INSERT INTO suc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tontong niu poloꞌma og manukmanukanan koyon nog mokponglayug sog gawang. Diꞌ ilan tanan momula otawaka gumani. Bu daꞌidun tanan og pogomudan nilan nog pongonganon nilan. Tibua, maꞌ nituꞌ siꞌoy, daꞌ ilan da potiangoy nog Gamaꞌ niu sog glangit. Sugaꞌid non, pinoꞌuban non potanan ilan. Konaꞌ taꞌ buan nog bololagaꞌ amu pa tokodoy dianilan? ");
INSERT INTO suc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Poꞌ sima buan dianiu nog bianan sog susaan non, kosukpatan non og kopayat nog kotubuꞌ non? ");
INSERT INTO suc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Bu iduma mosusa amu ma buan nog koponapot niu? Tontong niu poloꞌma og kotubuꞌ nog bulakbulakanan. Daꞌ ilan tanan ponukat otawaka pongabol nog bagun ilan mokopoglogdoy. ");
INSERT INTO suc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tibua, toluꞌon ku dianiu, nog minsan si Datuꞌ Solomon kobon nituꞌ nog doyahan tokodoy, daꞌ pa sibon pokoponapot nog mokolongas nog maꞌ nog bayuꞌbayuꞌ nog bulakbulakanan koyon solabuk siꞌoy. ");
INSERT INTO suc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bila maꞌ nituꞌ ma og ginandun nog Mikpongon og koponapot non dia sog sigbotanan nog motongow ta numun koni nog saka, mogbolomaꞌ imungon nog tagun, amu potaꞌ gidoy og polukason non nog daꞌidun og ponopoton niu? Kulang dodaꞌ og salig niu. ");
INSERT INTO suc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Dadi, naꞌ amu mosusa bog olo og kokan niu bu kinum niu, otawaka koponapot niu. ");
INSERT INTO suc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Poꞌ koyon og pigopasan nog gotowanan koyon nog daꞌ poktamuy dia sog Mikpongon. Bu og Gamaꞌ niu sog glangit, kosunan non nog og glam nini sumboy ngon nododaꞌ dianiu dun. ");
INSERT INTO suc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sugaꞌid non, pogopasoy niu poguna og kopogdatuꞌ nog Mikpongon dianiu bu og kodulusan non, poꞌ og glam nini ponoꞌuban non da amu dun. ");
INSERT INTO suc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Poꞌ gondow gondow ngon susaan niu. Giap nog gondow ngon dili susaan nog gondow koyon. Dadi, naꞌ amu mosusa bog olo og matong bolomaꞌ poꞌ len da og susaan sog gondow koyon.” ");
INSERT INTO suc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Maꞌ long ni Isus, “Naꞌ amu mongukum nog pakasi niu bagun amu ondiꞌ dosop ukumon nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Poꞌ bianan sog kopongukum niu dianilan maꞌ nituꞌ dosop og koukuman dianiu. Poꞌ og galan nog gomiton niu dia sog pakasi niu, maꞌ nituꞌ dosop og gomiton nog Mikpongon nog galan non dianiu. ");
INSERT INTO suc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Iduma sokaliꞌ motongow niu og puling ma nog duma niu nog gahatgahat tanan kotongow, saka potiangon niu ma og puling nog migbolabag dia sog dili mata niu nog maꞌ nog glolosan kosolag? ");
INSERT INTO suc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Olo ma mogandun kotaluꞌ niu dia sog pakasi niu nog, ‘Takun dow, owaꞌon ta og puling mu,’ saka ngon og puling niu nog maꞌ nog glolosan kosolag migbolabag dia sog dili mata niu? ");
INSERT INTO suc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mokpopotongow amu dodaꞌ tibua! Awaꞌ niu poguna og glolosan koyon nog migbolabag dia sog dili mata niu, bagun niu motongow mahatul bu mawaꞌ niu og bataꞌbataꞌ puling sog mata nog pakasi niu. ");
INSERT INTO suc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Og mosigda nog balan nog tidu sog Mikpongon, naꞌ niu bogoyon dia sog gotowanan koyon nog mokolaton botad non. Poꞌ gomonsunoy mamaꞌ ilan nog gayam nog puliꞌon nilan amu gumupas. Og gustalan niu koyon bololagaꞌ tokodoy maꞌ nog mutiaꞌ. Dadi, naꞌ niu tikpuꞌon dia sog babuyanan poꞌ poglogekon nilan tibua nog daꞌ maꞌana non.” ");
INSERT INTO suc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Maꞌ long sop ni Isus dun, “Pongoni amu poꞌ bogayan amu. Ponontong amu poꞌ motongow niu. Bu pokibukaꞌ amu poꞌ og bongawan bukaꞌon da dianiu. ");
INSERT INTO suc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Poꞌ simasima og mongoni, mokotabuk. Bu simasima og monontong, mokotongow. Bu simasima sop og mokibukaꞌ, og bongawan bukaꞌon dianon. ");
INSERT INTO suc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Poꞌ ngon taꞌ og gotow dianiu nog bila mongoni og bataꞌ non nog pan, tulunan non nog batu? ");
INSERT INTO suc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Otawaka bila mongoni ion nog sodaꞌ, bogayan niu taꞌ ion nog mamak? Ondiꞌ, le! ");
INSERT INTO suc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Poꞌ amu, moto amu tanan mogbogoy nog ain molongas dia sog gombataꞌ niu nog saka bolodusaon amu. Labi na og Gamaꞌ niu sog glangit mogbogoy nododaꞌ nog molongas sog ain og mingoni kituꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Dadi, sog glam non, inang niu sog pakasi niu ain kolegan niu kituꞌ nog inangon non dianiu. Poꞌ mitigbung na dini og Dan Botad kituꞌ bu og pimali nog polomolatasanan kituꞌ nog taluꞌ nog Mikpongon kobon nituꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Maꞌ long sop ni Isus dun, “Bian amu sog mosikut nog bongawan nog posunguꞌ sog kotubuꞌ nog daꞌ kopus non. Poꞌ og bongawan nog posunguꞌ sog glaꞌat, moliwag bu molomu bianan. Bu modakol og mokpomian dun. ");
INSERT INTO suc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tibua, mosikut og bongawan bu mologon og dalan posunguꞌ sog kotubuꞌ nog daꞌ kopus non. Bu mikaꞌan da og mokotongow dun.” ");
INSERT INTO suc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Maꞌ long sop ni Isus dun, “Pongmohilat amu nog polomolatasanan koyon nog diꞌ motud. Tumuaꞌ ilan dion niu ompatong maꞌ nog bilibili. Tibua, og dialom pikilan nilan kondokondok mamaꞌ nog glimong. ");
INSERT INTO suc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kilolaan niu ilan bianan sog kohinangan nilan. Poꞌ og bunga nog paras ondiꞌ mupuꞌ dia sog totulug. Bu og bunga nog igera ondiꞌ mupuꞌ dia sog bonganga. ");
INSERT INTO suc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Domikian dosop maꞌ nituꞌ, og kayu nog daꞌ mosakit non, molongas sop og bunga non. Tibua, og kayu nog togo mosakit, molaton sop og bunga non. ");
INSERT INTO suc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Og kayu nog daꞌ mosakit non, ondiꞌ na dodaꞌ mogbunga nog molaton. Bu og molaton nog kayu ondiꞌ na dodaꞌ mogbunga nog mokolongas. ");
INSERT INTO suc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ain og kayu kituꞌ nog diꞌ mogbunga nog molongas, ponogaꞌon mangka tikpuꞌoy sog gapuy. ");
INSERT INTO suc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Dadi, toluꞌon ku dianiu, nog og gotowanan koyon, kilolaan niu na dodaꞌ ilan bianan sog kohinangan nilan.” ");
INSERT INTO suc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Maꞌ long sop ni Isus dun, “Konaꞌ og glam nog moksabi dianakon nog akon og kounutan non, nog mokampuꞌ sog pigdotuꞌan nog Mikpongon. Sugaꞌid non, ain da og mikokunut kituꞌ nog glegan nog Gamaꞌ u dituꞌ sog glangit. ");
INSERT INTO suc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bu toluꞌon ku dianiu, nog ongon gondow matong nog modakol og gotowanan nog moksabi dianakon nog, ‘Kounutan! Kounutan! Mimitua ami, bu mimugow ami nog glatdiwataanan bianan sog ngalan mu, bu modakol pa og miinang nami nog kosobuꞌsobuꞌ!’ ");
INSERT INTO suc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tibua, toluꞌan ku ilan nog, ‘Diꞌ u amu kilolaan. Sugaꞌid non, pokpolayuꞌ amu dianakon, amu koyon nog mokolaton og kohinangan non.’” ");
INSERT INTO suc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Maꞌ long sop ni Isus dun, “Dadi, simasima og mikodongog nog taluꞌ u koni mangka ion pokokunut dun, mamaꞌ ion nog gotow kituꞌ nog moto momikil nog dia non pinasok og baloy non sog dolonitan. ");
INSERT INTO suc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dangan migdupiꞌ bonua mangka pogbaꞌ bu inoyupan nog molandos nog galuꞌ, og baloy non koyon daꞌ da kobuksak poꞌ ompagon og piingkudan non nog baloy non koyon. ");
INSERT INTO suc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tibua, simasima og mikodongog nog taluꞌ u koni nog saka ondaꞌ non unutoy, mamaꞌ ion nog gotow kituꞌ nog gumowon. Sokaliꞌ non pinasok og baloy non sog pontadan. ");
INSERT INTO suc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dangan migdupiꞌ bonua mangka pogbaꞌ, bu inoyupan nog molandos nog galuꞌ, mibuksak og baloy non koyon bu kologlag.” ");
INSERT INTO suc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Dangan midoksuꞌ ni Isus toluꞌoy og glam non koyon, kisobuꞌan tokodoy og gotowanan nog kopokpanad non koyon. ");
INSERT INTO suc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Poꞌ og kopokpanad non, ion og togo bayaꞌ. Ondiꞌ mamaꞌ nog polopanadanan koyon nog botad nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Dinumiksun si Isus tidu sog bontud koyon. Dangan minatong sog dotagan, modakol og gotowanan nog mikpogunut dianon. ");
INSERT INTO suc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bu ngon og sala kotow gipulon nog mikpolani dianon mangka ingluꞌud sog sunguꞌan non bu poktaluꞌ nog, “Polopanad, somoꞌ moleg a da, ompokodag mu akon.” ");
INSERT INTO suc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dadi, dinoponan ion ni Isus mangka poktaluꞌ nog, “Moleg u da le. Kuliꞌan ka na!” Bu sododuꞌun miawaꞌ og mosakit nog gotow koyon. ");
INSERT INTO suc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tubus nion, tinoluꞌan non og gotow koyon nog, “Naꞌ mu ini tokodoy posunon minsan sima. Sugaꞌid non, angoy mu potongow og glawas mu dituꞌ sog bolian mangka a pomalas maꞌ nog dinondag ni Muses kituꞌ kobon nituꞌ poꞌ bagun nilan kotoksiꞌan.” ");
INSERT INTO suc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dangan minatong si Isus sog koliwagan bonua nog Kapernaum, linumpak ion nog kounutan nog sundaluanan mangka pokitabang dianon nog, ");
INSERT INTO suc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Kounutan, og dodondagon ku ondiꞌ mokodag bu ondiꞌ tanan mokopoglilow dituꞌ sog baloy. Misinsa tokodoy nog mosakit non.” ");
INSERT INTO suc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tinabal ion ni Isus nog, “Oꞌo, ongoyon ku da ion pokodagoy.” ");
INSERT INTO suc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tibua, tinumabal og kounutan nog sundaluanan koyon nog, “Kounutan, konaꞌ u patut mokpodangan dianika sog baloy u. Sugaꞌid non, taluꞌ mu tibua nog kumodag na og dodondagon ku kituꞌ, poꞌ kumodag na dun. ");
INSERT INTO suc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Poꞌ akon siꞌoy, ngon dosop og kounutan nog mogbayaꞌ dianakon. Bu ongon dosop og sundaluanan nog bila dondagon ku ompanow, mokokunut da dianakon. Bu bila sop dondagon ku mokpolani dianakon, mokokunut ilan dosop. Bu bila dondagon ku og sosuguꞌon ku nog moginang nog ain kolegan ku, inangon non dosop.” ");
INSERT INTO suc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Dangan midongog ni Isus og tinaluꞌ nog gotow koyon, kisobuꞌan ion dun nog boyaꞌan tinoluꞌan non og gotowanan koyon nog mikpogunut dianon nog, “Totu da, daꞌ u pa sibon pokolumpak nog gotow nog maꞌ nini kopagon og kopongandol non, minsan siꞌoy sog bansa Israel. ");
INSERT INTO suc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Toluꞌon ku dianiu, nog modakol og gotowanan nog mokpoktidu sog silangan sindopan madap ilan kuman dia ni loꞌ Abraham, si Isak, bu si Jakub sog pigdotuꞌan dituꞌ sog glangit. ");
INSERT INTO suc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tibua, og gotowanan kituꞌ nog mokampuꞌ bosia sog pigdotuꞌan nog Mikpongon, tikpuꞌon ilan sog glowasan dituꞌ sog kodoloman. Bu dituꞌ ilan poglulad bu mongolongot og ngisianan nilan.” ");
INSERT INTO suc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tubus nion, miktaluꞌ si Isus sog kounutan nog sundaluanan koyon nog, “Uliꞌ a na. Poꞌ motuman da dianika og tud mu koyon.” Bu og tang koyon kiuliꞌan dodaꞌ og dodondagon non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tubus nituꞌ, minangoy si Isus sog baloy ni Piter. Dangan sinumolod ion, mitongow non og ponugangan ni Piter nog glibun nog pogbolilid poꞌ mipanas. ");
INSERT INTO suc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dadi, dinoponan ni Isus og komot non bu kiowasan ion. Dadi, migbuat ion mangka non tologadoy si Isus. ");
INSERT INTO suc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dangan sinumindop na gondow, modakol og gotowanan nog pinosopan nog glatdiwataanan nog pingoit dituꞌ non. Pimugow non og glatdiwataanan kituꞌ bianan sog taluꞌ non. Bu og glam nog ondiꞌ mokokodag koyon dion kiuliꞌan non. ");
INSERT INTO suc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ion non ini og kotumanan nog tinaluꞌ kituꞌ nog polomolatas nog taluꞌ nog Mikpongon nog si Isaya kobon nituꞌ nog, “Kiuliꞌan non ita mangka non owaꞌoy og mokosakitanan ta.” ");
INSERT INTO suc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Dangan mitongow ni Isus nog modakol og gotowanan nog miglibut dianon, tinoluꞌan non og sulangguꞌanan non koyon nog, “Tumolipag ita dituꞌ sog dipag nog danow koni.” ");
INSERT INTO suc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sog daꞌ ilan pa gonat, mikpolani dianon og polopanad nog botad nog bansa Hudyu mangka poktaluꞌ nog, “Kounutan, mogunut u dianika minsan ain ka angoy.” ");
INSERT INTO suc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tinumabal si Isus nog, “Og tinggalung togo pogonongan, bu og manukmanuk togo salag. Tibua, og Binataꞌ sog Kilawan, daꞌidun tanan og dolopaꞌan non.” ");
INSERT INTO suc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Og sala kotow sop nog sulangguꞌ non miktaluꞌ dianon nog, “Kounutan, ondiꞌ u pa mokodunut dianika poꞌ lobongon ku pa poguna og gamaꞌ u.” ");
INSERT INTO suc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tinabal ion ni Isus nog, “Pogunut a dianakon. Potiang nika na ain og diꞌ bololagaꞌ dianilan og pigdotuꞌan nog Mikpongon nog ilan dona og lumobong nog bangkoy nilan.” ");
INSERT INTO suc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tubus nituꞌ, sinumakoy si Isus ilan nog sulangguꞌanan non koyon dia sog bolangoy mangka ilan tulak. ");
INSERT INTO suc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Gomonsunoy pa, tinumokow moglogoyup nog landuꞌ na kolandos dia sog danow koyon boyaꞌan nog kisigoban nog nabok og bolangoy nilan koyon. Tibua, si Isus poktulug. ");
INSERT INTO suc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dadi, inangoy ion tonudoy nog sulangguꞌanan non koyon, “Kounutan, tabang! Moglaꞌat ita!” ");
INSERT INTO suc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tubus nituꞌ, tinoluꞌan non ilan nog, “Iduma kondokan amu ma? Kulang dodaꞌ og kopongandol niu!” Mangka ion pogbuat bu polotaꞌoy og galuꞌ koyon bu og nabok nog mokoluksang. Sododuꞌun tinumodoꞌ tokodoy og danow koyon. ");
INSERT INTO suc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kisobuꞌan tokodoy og sulangguꞌanan non koyon mangka ilan poktaluꞌ nog, “Sima gidoy og gotow koni nog minsan siꞌoy og galuꞌ bu og nabok mogbilang ma dianon!” ");
INSERT INTO suc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sokaliꞌ ilan dinumongguꞌ dituꞌ sog dipag nog danow koyon sog bonua nog ngalan non Gadarinis. Linumpak ion nog duaꞌ kotow nog tinosopan nog glatdiwata nog dituꞌ ilan miktidu sog kolobongan. Bu kondokondok ilan tokodoy nog boyaꞌan nog daꞌidun tanan og mokobian sog dalan koyon. ");
INSERT INTO suc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bu mikpoktaluꞌ ilan nog mosikad nog, “Olo og dunon mu dianami, Ika og Bataꞌ a nog Mikpongon? Ongoyon mu taꞌ ami posinsaoy nog saka daꞌ pa datong og tang non?” ");
INSERT INTO suc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sog molayuꞌlayuꞌ nilan koyon, ngon og panun nog babuy nog pokponungkal. ");
INSERT INTO suc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Og glatdiwataanan koyon, migbubut ilan dia ni Isus nog bila bugowon non ilan, dia ilan sangon sog babuyanan koyon. ");
INSERT INTO suc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dadi, sinagda ilan ni Isus mokpongluas. Bu mikpongluas ilan tidu sog duaꞌ kotow koyon mangka ilan sangon sog babuyanan koyon. Bu og panun nog babuy koyon, mikponggobok ilan dumiksun mangka pokpongokpu sog danow koyon bu mitipot ilan pomoglaꞌat. ");
INSERT INTO suc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Dangan mitongow nog polongipat nog babuyanan koyon og maꞌ nion koyon, mikponggobok ilan mangka nilan poguksugoy dituꞌ sog koliwagan bonua og glam nion bu asta og kibianbianan nog duaꞌ kotow kituꞌ nog bakas tinosopan nog glatdiwataanan. ");
INSERT INTO suc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dadi, og glam nog gotowanan dituꞌ sog koliwagan bonua kituꞌ, inangoy nilan lumpakoy si Isus bu pigbubut nilan nog mawaꞌ pa dion sog bonua nilan koyon. ");
INSERT INTO suc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Dadi, sinumakoy si Isus sog bolangoy mangka ion tolipag posunguꞌ dituꞌ sog dili bonua non. ");
INSERT INTO suc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dangan minatong dituꞌ, ngon og daday nog inoyungan nog gotowanan sog pigbolilidan non posunguꞌ dituꞌ ni Isus. Dangan mitongow non og kopongandol nilan dianon, tinoluꞌan non og daday koyon nog, “Aki, pobaꞌis mu og pikilan mu, poꞌ og dusaanan mu inompunan na.” ");
INSERT INTO suc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dangan ion midongog nog duma polopanadanan koyon nog botad nog bansa Hudyu, migdialominawa ilan nog, “Og gotow koni moglakaꞌlakaꞌ ma monaluꞌ dia sog Mikpongon!” ");
INSERT INTO suc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tibua, kisunan ni Isus bog olo og pomikilan nilan koyon. Dadi, tinoluꞌan non ilan nog, “Iduma molaton ma og pomikilan niu dianakon? ");
INSERT INTO suc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ain gidoy og molomu toluꞌon, ‘Inompunan na og dusaanan mu,’ otawaka moktaluꞌ nog, ‘Pogbuat a mangka a panow?’ ");
INSERT INTO suc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tibua, bagun niu kosunan, potongowon ku dianiu nog og Binataꞌ sog Kilawan togo bayaꞌ mongampun nog dusa nog gotowanan dini sog glupaꞌan.” Mangka non toluꞌoy og daday koyon nog, “Pogbuat a le. Imud mu og pigbolilidan mu koyon bu pitang mu muliꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dadi, migbuat dodaꞌ og gotow koyon mangka ion uliꞌ. ");
INSERT INTO suc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Dangan mitongow nog gotowanan og maꞌ nion koyon, kiondokan ilan dun bu piksonglitan nilan og Mikpongon dun nog ion migbogoy nog bayaꞌ nog maꞌ nion dia sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Dangan miglandan si Isus, mitongow non og gotow nog ngalan non si Matiu pogingkud sog baloybaloy nog pokpongobatan non nog buis. Tinoluꞌan ion ni Isus nog, “Pogunut a le dianakon.” Dadi, migbuat ion mogdayun mangka pogunut dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tubus nituꞌ, si Isus bu og sulangguꞌanan non, migadap ilan kuman dituꞌ ni Matiu. Modakol og polongabatanan nog buis bu og bolodusaon nog minangoy ilan madap kuman dia ni Isus bu sulangguꞌanan non. ");
INSERT INTO suc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dangan mitongow nog parasiuanan og maꞌ nion koyon, sinakan nilan og sulangguꞌanan ni Isus nog, “Iduma og polopanad niu koyon mampuꞌ ma kuman dia sog polongabatanan nog buis bu sog bolodusaon?” ");
INSERT INTO suc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Dangan ion midongog ni Isus, tinoluꞌan non ilan nog, “Og gotow nog mokodag, daꞌidun na og balan non nog polomulung. Tibua, og gotow nog diꞌ mokodag, ngon kobalan non dun. ");
INSERT INTO suc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dadi, angoy niu pogonadoy bog olo og maꞌana nog sinulat koni sog Kitab nog, ‘Og kolegan ku og mololat amu gabaꞌ nog pomalas niu dianakon.’” Long sop ni Isus dun, “Poꞌ akon, konaꞌ gangoy u dini mangoy mongonggat sog ain mokpikil nog midulus ilan na. Sugaꞌid non, inangoy u onggatoy ain og gotow nog bolodusaon.” ");
INSERT INTO suc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tubus nituꞌ, og sulangguꞌanan ni Jan nog Polomunyag minangoy dituꞌ ni Isus mangka poksak nog, “Ami bu og parasiuanan, mokpuasa ami. Saka, og sulangguꞌanan mu ondiꞌ ma?” ");
INSERT INTO suc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tinabal ilan ni Isus nog, “Mogusoy taꞌ gidoy nog og pongantim mosusa nog kobon pa nog dion nilan og koingon koyon? Ondiꞌ na dodaꞌ. Tibua, ngon da gondow non nog bigdason dianilan og koingon koyon, mangka ilan pa pokpuasa.” ");
INSERT INTO suc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Long non sop dun, “Daꞌidun og gotow nog bila monilob, gumabas nog bogu ponopoton nog daꞌ pa koloꞌ mangka non tiloboy sog dan glogdoy. Poꞌ bila kumoloꞌ og tilob non koyon mogdungag lumiwag og bogyang nog dan glogdoy non koyon. ");
INSERT INTO suc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bu domikian dosop nog daꞌidun og gotow nog tumaguꞌ nog bogu galak dia sog dan toguꞌan nog diꞌ lumagyat. Poꞌ bila maꞌ nituꞌ, ombogdak og toguꞌan koyon dun poꞌ ondiꞌ na lumagyat. Dadi, moglaꞌat og toguꞌan non koyon bu mogulaꞌ og galak koyon. Og bogu galak sumboy dia na dodaꞌ toguꞌoy sog bogu toguꞌan nog lumagyat poꞌ bagun og galak koyon ondiꞌ mogasta bu og toguꞌan non koyon ondiꞌ dosop moglaꞌat.” ");
INSERT INTO suc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Solian pa ni Isus moktaluꞌ dia sog gotowanan koyon, ngon og gotow dion og polongokbit nog solabuk baloy nog poglumpukan nog bansa Hudyu. Og gotow koyon mikpolani dia ni Isus mangka ingluꞌud dia sog sunguꞌan non, mangka ion poktaluꞌ nog, “Og bataꞌ u nog glibun kotoktusoy non pa. Tibua, amoyamoy dianika, angoy mu pa ion doponoy bagun da motubuꞌ mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dadi, migbuat si Isus asta og sulangguꞌanan non koyon mangka ilan pogunut dianon. ");
INSERT INTO suc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sintak nilan ompanow, ngon og glibun nog sinumaꞌut dianilan. Og glibun koyon piglodasan nog duguꞌ sog solod nog sopuluꞌ bu duaꞌ ton. Mikpolani ion dia sog tolikudan ni Isus mangka non tuyokoy og sudung nog glogdoy ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Poꞌ donsamaꞌ na migdialom pikilan og glibun koyon nog, “Minsan siꞌoy sagya motuyok u og glogdoy non kuliꞌan u na dun.” ");
INSERT INTO suc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dadi, tinumolikud si Isus mangka sunguꞌ sog gotowanan bu mitongow non og glibun koyon. Dadi, tinoluꞌan non ion nog, “Ibun, pobaꞌis mu og pikilan mu, poꞌ sabap sog kopongandol mu kiuliꞌan ka.” Dadi, sododuꞌun kiuliꞌan dodaꞌ og glibun koyon. ");
INSERT INTO suc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Dangan minatong ilan sog baloy nog polongokbit kituꞌ, sinumolod ilan. Bu mitongow ni Isus og polomansiꞌanan bu og gotowanan koyon dion mikponglangos ilan. ");
INSERT INTO suc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Dadi, tinoluꞌan non ilan nog, “Pongawaꞌ amu dini! Poꞌ og bataꞌ koni ondaꞌ patoy, sugaꞌid non, sagya da ion mitulug.” Dadi, pigwanwan nilan si Isus dun. ");
INSERT INTO suc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tibua, dangan linumiu na og gotowanan kituꞌ, sinumolod si Isus sog dugu nog binotangan nog bataꞌlibun koyon mangka non pogoidoy sog komot bu og bataꞌ koyon migbuat. ");
INSERT INTO suc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Og dongogan koni mipulonag sog gliwag nog bonua koyon dion. ");
INSERT INTO suc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Dangan miglandan si Isus, ongon duaꞌ kotow og buta nog migunut dianon kobon nilan moktaluꞌ nog mosikad nog, “Pangkat ni Apuꞌ Dabid! Kololatoy mu pa ami!” ");
INSERT INTO suc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dangan sinumolod na si Isus sog baloy, og butaanan koyon, mikpolani ilan dianon. Dadi, sinakan non ilan, “Tumud amu taꞌ da nog kuliꞌan ku amu?” Tinumabal ilan nog, “Oꞌo Kounutan, tumud ami da!” ");
INSERT INTO suc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dadi, tinuyok ni Isus og mataanan nilan mangka ion poktaluꞌ nog, “Motuman nion dianiu og tinud niu koyon.” ");
INSERT INTO suc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bu mikotongow ilan na mogdayun mangka non pigondiꞌoy moguksug dianilan sog minsan sima. ");
INSERT INTO suc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tibua, miguliugan ilan sog gliwag nog bonua koyon mangka nilan pulonagoy og guksugan koyon paꞌali dianon. ");
INSERT INTO suc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Dangan ginumonat tibua og bakas butaanan koyon, ongon sala kotow og tinosopan nog glatdiwata nog boyaꞌan migbod tanan ion dun nog pinitang dituꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Midoksuꞌ non bugowoy og glatdiwata koyon, mikopoktaluꞌ na og bod koyon. Dadi, kisobuꞌan og gotowanan koyon dun mangka ilan poksitaluꞌ nog, “Daꞌ ita pa sibon pokotongow nog maꞌ nini koni dini sog bonua nog Israel!” ");
INSERT INTO suc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tibua, miktaluꞌ og parasiuanan koyon nog, “Saꞌan nion kopogboyaꞌan non og glatdiwataanan koyon poꞌ og bayaꞌ non koyon dia miktidu sog kounutan nog glatdiwataanan.” ");
INSERT INTO suc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tubus nituꞌ, miguliugan si Isus sog glam nog bonuaanan koyon dion. Mikpanad ion dia sog baloyanan nog poglumpukan nog bansa Hudyu bu pogustal nog Gombaꞌis nog Guksugan paꞌali sog pigdotuꞌan nog Mikpongon. Bu pikodag non og glam nog diꞌ mokokodag bu ain togo mosakit. ");
INSERT INTO suc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Solian non mogbantoy sog gotowanan koyon nog modakol, nog kilogonan ilan bu daꞌidun og kogobokan nilan, mololat ion tokodoy dianilan poꞌ mamaꞌ ilan nog bilibilianan kituꞌ nog daꞌidun og polongipat dianilan. ");
INSERT INTO suc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dadi, miktaluꞌ ion dia sog sulangguꞌanan non koyon nog, “Moliwag og gonion, tibua, mikaꞌan da og polonggani. ");
INSERT INTO suc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Dadi, pongoningoni amu dia sog gapuꞌ nog gonion koyon nog mokpoit ion dumungag nog polonggani dia sog gonion non koyon.” ");
INSERT INTO suc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ngon gondow non, sinabi ni Isus og sopuluꞌ bu duaꞌ sulangguꞌanan non moglumpuk dianon bu binogayan non ilan nog bayaꞌ momugow nog glatdiwataanan bu mokpokodag nog ain og diꞌ mokokodag bu ain og togo mosakit nog minsan olo mosokitoy dun. ");
INSERT INTO suc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Koni og ngalananan nog sopuluꞌ bu duaꞌ kotow og sosuguꞌonanan non. Og tiganaꞌ si Simun (og koduaꞌ ngalan non si Piter) bu og putupusod non nog si Andriu, si Jems bu og putupusod non nog si Jan, og gombataꞌ ilan ni Sebedi. ");
INSERT INTO suc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Si Pilip, si Bartolomi, si Tomas, bu si Matiu nog og polongabat nog buis, bu si Jems og bataꞌ ni Alpius, bu si Tadius. ");
INSERT INTO suc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Bu si Simun og omboluꞌ kituꞌ tumindog nog salu bansa non, bu si Judas Iskariot og miguakil kituꞌ dia ni Isus sog glaꞌat. ");
INSERT INTO suc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Og sopuluꞌ bu duaꞌ kotow koni pipanow ni Isus bu pimolian non ilan nog, “Naꞌ amu mangoy sog konaꞌ bansa Hudyu otawaka sog bonua nog Samaria. ");
INSERT INTO suc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sugaꞌid non, dituꞌ amu angoy sog gotow Israel kituꞌ nog pinonggiꞌ dia sog bilibilianan kituꞌ nog mikpogbolong. ");
INSERT INTO suc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Og panow niu koyon, mangoy amu mogustal nog, og kopogdatuꞌ nog Mikpongon mosompol na. ");
INSERT INTO suc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bu pokodag niu ain og diꞌ mokokodag bu ain og gipulon, bu potubuꞌ niu puliꞌ ain og minatoy, bu pomugow niu og glatdiwataanan. Mikalap amu nog bayaꞌ koyon dia sog Mikpongon nog daꞌ bayad dun. Dadi, naꞌ niu dosop poboyadon og gotowanan kituꞌ nog kitobangan niu. ");
INSERT INTO suc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Naꞌ amu mogoit nog sin nog minsan andun. ");
INSERT INTO suc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Naꞌ amu mogoit nog toguꞌan nog balanbalan, otawaka og gimolaan niu, otawaka og pongyapak niu bu tagad niu. Poꞌ og gotow nog moginang, patut nododaꞌ pokpotubuꞌon. ");
INSERT INTO suc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Bila mokodopot amu sog koliwagan bonua otawaka sog gimbolayan, ponontong niu og gotow kituꞌ nog pogodaban sog bonua koyon. Bu solian dion amu, dituꞌ amu non dukon. ");
INSERT INTO suc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ampun sumolod amu, maꞌ nini og taluꞌ niu, ‘Og kotiknaꞌ nog pikilan mongon dianiu.’ ");
INSERT INTO suc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bila og gotowanan sog baloy koyon patut toluꞌan dun, monugu dianilan og tinaluꞌ niu koyon. Tibua, bila ondiꞌ, muliꞌ da dianiu. ");
INSERT INTO suc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bila daꞌidun og tumolimaꞌ dianiu otawaka og mokinongog dianiu, pokpasoy niu og glopug nog glupaꞌ nog minokot sog botis niu mangka amu siꞌoy gonat sog baloy otawaka sog bonua koyon. ");
INSERT INTO suc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Toluꞌon ku dianiu, bila matong og gondow nog polihalaꞌ, labi pa og posakit dia sog gotowanan koyon nog diꞌ tumolimaꞌ dianiu, gabaꞌ nog posakit dia sog gotowanan kituꞌ sog bonua nog Sodom bu Gomora. ");
INSERT INTO suc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Poponowon ku amu nog mamaꞌ nog bilibilianan nog mangoy tumimbul dia sog glimonganan. Dadi, sumboy molig amu mamaꞌ nog mamak bu molumbang amu mamaꞌ nog kolopati. ");
INSERT INTO suc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pongmohilat amu dia sog gotowanan poꞌ pongukpaꞌan nilan amu mangka nilan amu uokiloy dia sog gukum bu pokposokitan amu dia sog baloyanan nog poglumpukan nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sabap sog kopokokunut niu dianakon, oiton nilan amu dia sog sunguꞌan nog gubernadoranan bu sog kodotuꞌananan. Bu bianan sog kopoksumodia nilan dianiu, mokopoguksug amu dianilan nog Gombaꞌis nog Guksugan sog bansa Hudyu bu asta sog konaꞌ Hudyu. ");
INSERT INTO suc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tibua, bila ukpaꞌan amu mangka amu poksumodiaoy, naꞌ amu mosusa bog olo og toluꞌon niu otawaka olo og kotaluꞌ niu dun. Poꞌ sog tang koyon bogayan amu da nog kotoan bog olo og poktoluꞌon niu. ");
INSERT INTO suc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Poꞌ og taluꞌ koyon konaꞌ niu dili taluꞌ, sugaꞌid non, og Bolakat nog Mikpongon og mokpotaluꞌ dun dianiu. ");
INSERT INTO suc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sog tang koyon pobunuꞌ nilan na og putupusod nilan. Bu maꞌ nituꞌ dosop og ginangon nog gamaꞌanan dia sog gombataꞌanan nilan. Bu og gombataꞌanan siꞌoy, mokpongantu ilan na sog mokogulanganan nilan mangka nilan pobunuꞌ. ");
INSERT INTO suc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pokongitan amu nog glam nog gotowanan sabap sog kopokokunut niu dianakon. Tibua, simasima og mokogaga asta sog doksuꞌan, motabang ion. ");
INSERT INTO suc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bila posokitan amu sog solabuk bonua, polaguy amu sog len bonua. Toluꞌon ku dianiu, mangka niu siꞌoy kulit pongongoyoy og bonua nog Israel koyon, matong na og Binataꞌ sog Kilawan. ");
INSERT INTO suc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Og pikponadan ondiꞌ nododaꞌ motas dia sog mikpanad koyon dianon. Bu og sosoligan, ondiꞌ non dosop pogboyaꞌan og kounutan non. ");
INSERT INTO suc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pada na bila og pikponadan, kilingan non og mikpanad koyon dianon. Bu domikian dosop maꞌ nituꞌ og sosoligan nog kilingan non og kounutan non. Bila iningolanan ma nog Belsibul og kounutan sog baloy, labi na kingolanoy og glaꞌayatanan non nog molaton. ");
INSERT INTO suc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Dadi, naꞌ amu mondok sog gotowanan poꞌ daꞌidun og pigbuni nog ondiꞌ ompotongow. Bu daꞌidun dosop og piglingod nog ondiꞌ kosunan. ");
INSERT INTO suc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ain og tinaluꞌ u kituꞌ dianiu nog ita ita da, podongog niu na sog glam nog gotowanan. Bu ain og inilom u kituꞌ dianiu, pulonag niu na sog kodokolan. ");
INSERT INTO suc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Naꞌ amu mondok nog gotowanan koyon nog glawas niu da ombunuꞌ nilan nog ondiꞌ nilan ombunuꞌ og glimukud niu. Sugaꞌid non, kondok amu dia sog mokopongulaꞌat kituꞌ nog glawas bu asta glimukud niu dituꞌ sog danow nog gapuy. ");
INSERT INTO suc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Konaꞌ taꞌ duaꞌ buk og gloksayowanan solad sin da og golagaꞌ non? Tibua, daꞌidun og modogdag dianilan bog konaꞌ da og glegan nog Gamaꞌ niu sog glangit. ");
INSERT INTO suc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tibua, amu, minsan siꞌoy sagya og binoluan nog buk niu, kosunan nog Mikpongon bog andun dakol non. ");
INSERT INTO suc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dadi, naꞌ amu mondok, poꞌ bololagaꞌ amu pa tokodoy dia sog gloksayowanan koyon. ");
INSERT INTO suc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Simasima og moktaluꞌ dia sog gotowanan nog ion mikokunut dianakon, akon siꞌoy, toluꞌon ku dosop dituꞌ sog Gamaꞌ u sog glangit nog ion og pigotowan ku. ");
INSERT INTO suc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tibua, simasima og sonsingan non akon dia sog sunguꞌan nog gotowanan, sonsingan ku sop ion dituꞌ sog Gamaꞌ u sog glangit. ");
INSERT INTO suc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Naꞌ amu momikil nog saꞌan minangoy u dini sog dunya poꞌ mokpitang u nog gomigus dia sog gotowanan, sugaꞌid non, og susian. ");
INSERT INTO suc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Poꞌ saꞌan minangoy u dini bagun og gamaꞌ susion nog gombataꞌanan nog kolokian, bu og ginaꞌ susion nog gombataꞌanan nog kolibunanan, bu og ponugangan nog glibun susion nog mimonugangan dianon nog glibun. ");
INSERT INTO suc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Og banta non og salu konglangan non da. ");
INSERT INTO suc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Dadi, simasima og mololat dia sog ginaꞌamaꞌ non nog labi pa sog glolatan non dianakon, ondiꞌ ion patut ingolanan nog sulangguꞌ u. Bu simasima og mololat dia sog gombataꞌanan non nog labi pa dia sog glolatan non dianakon, ondiꞌ ion dosop patut ingolanan nog sulangguꞌ u. ");
INSERT INTO suc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Simasima og ondiꞌ moleg mokpisan nog kudus non mangka pogunut dianakon, ondiꞌ ilan patut ingolanan nog sulangguꞌ u. ");
INSERT INTO suc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Simasima og mogapas nog dili kotubuꞌ non, kobolongan da ion dun. Tibua, simasima og lamig non na bolongon og dili kotubuꞌ non sabap sog kopokokunut non dianakon, kongonan ion dun. ");
INSERT INTO suc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Simasima og tumolimaꞌ dianiu, tinolimaꞌ non dosop akon. Bu simasima og tumolimaꞌ dianakon, tinolimaꞌ non dosop og dinumondag kituꞌ dianakon mangoy dini sog dunya. ");
INSERT INTO suc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Simasima og tumolimaꞌ dia sog polomolatas, nog saꞌan tinolimaꞌ non poꞌ og polomolatas nog taluꞌ nog Mikpongon, mokalap ion nog sugda nog bogoyon dia sog polomolatasanan. Bu simasima og tumolimaꞌ nog gotow nog midulus nog saꞌan tinolimaꞌ non poꞌ og gotow koyon midulus dodaꞌ, mokotabuk ion nog sugda nog bogoyon sog ain midulus dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Simasima og mogbogoy nog minsan sala saguk siꞌoy nog tubig nog motigdow dia sog gotow nog minsan andun kobabaꞌ poꞌ og gotow koyon og sulangguꞌ u, toluꞌon ku dianiu, kobogayan nododaꞌ ion nog sugda.” ");
INSERT INTO suc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Dangan mitubus tibua ni Isus pomolioy og sopuluꞌ bu duaꞌ sulangguꞌanan non koyon, miglandan ion sog duma bonuaanan nog molani dion poꞌ mangoy ion mokpanad bu mogustal. ");
INSERT INTO suc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Dangan midongog ni Jan nog Polomunyag dituꞌ sog kolobusuan og paꞌali sog piginang ni Kristu, dinondag non og duma sulangguꞌanan non mangoy moksak dianon nog, ");
INSERT INTO suc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ika notaꞌ og pokpodotongon kituꞌ nog mangoy dini nog moktidu sog Mikpongon, otawaka mogbagad ami potaꞌ nog len?” ");
INSERT INTO suc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tinabal ilan ni Isus nog, “Pokpuliꞌ amu dituꞌ ni Jan mangka niu pogobitoy dianon og midongog niu bu og mitongow niu. ");
INSERT INTO suc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Taluꞌ niu dianon nog og butaanan mikotongow na. Og dadayanan mikopanow na. Bu ain og gipulon kiuliꞌan na. Bu og bongolanan mikodongog na. Bu og minatoy mitubuꞌ puliꞌ. Bu ain og miskinan kisuksugan na nog Gombaꞌis nog Guksugan. ");
INSERT INTO suc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bu ain daꞌ kituꞌ pogduaꞌduaꞌ nog pikilan non dianakon, popiaon na.” ");
INSERT INTO suc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Dangan poglogonat na og sulangguꞌanan ni Jan, miktolipun si Isus mogustal sog gotowanan paꞌali dia ni Jan. Long non dun, “Dangan minangoy amu dituꞌ ni Jan sog bonua kituꞌ nog mologon pogonongan, olo ma og pigdodomaan niu nog motongow niu dituꞌ? Migdodama amu taꞌ nog si Jan og gotow kituꞌ nog moguyaꞌ og pomikilan non mamaꞌ nog dawon nog timbolow nog diadia kopalid bila oyupan nog galuꞌ? Ondiꞌ le! ");
INSERT INTO suc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bila maꞌ nituꞌ ondiꞌ ma, olo ma og pigdodomaan niu sog kangoy niu kituꞌ dituꞌ? Og gotow taꞌ kituꞌ nog ombaꞌis og ponopoton non? Konaꞌ le! Poꞌ og gotowanan koyon nog minapot nog mokologan, dia ilan migonong sog baloy nog datuꞌ. ");
INSERT INTO suc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Olo dodaꞌ buan og inangoy niu tontongoy dituꞌ? Og polomolatas taꞌ nog taluꞌ nog Mikpongon? Oꞌo, motud ion. Poꞌ toluꞌon ku dianiu, og mitongow niu kituꞌ dituꞌ konaꞌ tibua og polomolatas nog taluꞌ nog Mikpongon, sugaꞌid non, labi pa ion dituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Paꞌali dia ni Jan, ion og pigolong kituꞌ nog sinulat dia sog Kitab nog, ‘Ngon og sosuguꞌon ku nog punaon ku dianika moksimpan nog bianan mu.’ ");
INSERT INTO suc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Toluꞌon ku dianiu, og glam nog binataꞌ nog gotow sog dunya koni, daꞌidun og motas pa dia ni Jan nog Polomunyag. Tibua, og gotow kituꞌ nog ombabaꞌ sog glam non dia sog pigdotuꞌan nog Mikpongon, motas pa dia ni Jan. ");
INSERT INTO suc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tidu sog kopoktolipun ni Jan momali asta sog numun koni, og kopogdatuꞌ nog Mikpongon kobon non mogidud bu pogogowon nog gotowanan kituꞌ nog mokoboluꞌ. ");
INSERT INTO suc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Og glam nog polomolatasanan kituꞌ bu og Botad kituꞌ nog pilatas ni Muses mikpodonsamaꞌ nog posunguꞌ kituꞌ matong asta tinumuaꞌ si Jan. ");
INSERT INTO suc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Bila tudon niu ituꞌ, ion og pogolongon nilan kituꞌ nog si Iladya nog mokpuliꞌ kituꞌ dini. ");
INSERT INTO suc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Dadi, ain togo tolinga, sumboy pokinongogan non og piktaluꞌ u koni.” ");
INSERT INTO suc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Maꞌ long sop ni Isus dun, “Ain gidoy kopononggiꞌ og gotowanan numun koni? Olo gidoy og kimaꞌmaꞌan nilan? Mamaꞌ ilan nog gombataꞌanan kituꞌ nog miglumpuklumpuk dia sog tobuꞌan nog moktotowagoy ilan nog, ");
INSERT INTO suc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Miglami ami bosia saka ompok amu mongigal. Linumangos ami saka ondaꞌ amu ampuꞌ moksogow.’ ");
INSERT INTO suc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Dangan minangoy dini si Jan nog Polomunyag, mikpuasa ion bu daꞌ ion poginum nog ombisa. Tibua, mikpoktaluꞌ og gotowanan nog, ‘Tinosopan ion nog glatdiwata.’ ");
INSERT INTO suc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bu dangan minangoy dini og Binataꞌ sog Kilawan, bu og piginang non kuman bu moginum, mikpoktaluꞌ og gotowanan nog, ‘Gibogon bu pololangu ion, bu og pakasibataꞌanan non og polongabatanan nog buis bu og bolodusaon.’ Og kotoan nog Mikpongon kotoksiꞌan da nog motud bianan sog piginang non.” ");
INSERT INTO suc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tubus nituꞌ, miktolipun si Isus mogbinaꞌ sog gotowanan kituꞌ nog dia sog bonuaanan nog piginangan non og kodokolan nog gingyataꞌanan, poꞌ daꞌ ilan poglilaꞌ nog dusaanan nilan. ");
INSERT INTO suc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Dadi, miktaluꞌ ion nog, “Kosusasusa amu, og gotowanan sog bonua nog Korasin bu sog bonua nog Betsaida. Poꞌ somoꞌ og dakol nog gingyataꞌanan kituꞌ nog ininang u dituꞌ niu, dia u pa ininang sog bonua nog Tair bu Sidon, miobon ilan na bosia moglilaꞌ nog dusaanan nilan bu ponapot nog saku mangka ingkud dia sog gobuan. ");
INSERT INTO suc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tibua, toluꞌon ku dianiu, bila matong na og gondow nog poliholaꞌon nog Mikpongon og gotowanan, labi pa og posakit dianiu sog posakit dia sog gotowanan kituꞌ sog bonua nog Tair bu Sidon. ");
INSERT INTO suc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bu amu og gotowanan sog Kapernaum, moleg amu siꞌoy ompotas asta motingkuꞌ amu sog glangit, lobuꞌon amu da dia sog gapuy kituꞌ nog ondiꞌ ompalong. Poꞌ somoꞌ dituꞌ miinang sog koliwagan bonua nog Sodom og gingyataꞌanan kituꞌ nog ininang u dianiu, og Sodom kituꞌ dion pa bosia asta numun koni. ");
INSERT INTO suc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tibua, toluꞌon ku dianiu, bila matong na og gondow nog poliholaꞌon nog Mikpongon og gotowanan, labi pa og posakit dianiu sog posakit dia sog gotowanan sog bonua nog Sodom.” ");
INSERT INTO suc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tubus nituꞌ, migyakin si Isus nog, “Amaꞌ, Ika og Pogbayaꞌ sog pigloban nog glangit bu glupaꞌan. Mikposolamat u dianika poꞌ linimod mu og kohinangan kituꞌ dia sog ain gotowanan nog sabutbaꞌasa bu pitongow mu dia sog gotowanan kituꞌ nog kulang pa bosia og sabut non. ");
INSERT INTO suc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oꞌo, Amaꞌ, ininang mu ituꞌ poꞌ maꞌ nituꞌ og kosuꞌatan ka dun.” Tubus nituꞌ, miktaluꞌ nosop si Isus dianilan nog, ");
INSERT INTO suc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Og glam non inuakil na dianakon nog Gamaꞌ u. Daꞌidun og mokokilala bog sima og Bataꞌ lual da og Gamaꞌ. Bu daꞌidun dosop og mokokilala bog sima og Gamaꞌ lual da og Bataꞌ bu ain og kolegan nog Bataꞌ koyon potongowon dianon og Gamaꞌ non. ");
INSERT INTO suc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Angoy amu dini nakon, ain og milupug bu kibogatan poꞌ pulolion ku amu. ");
INSERT INTO suc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tabuk niu og pomali u nog popisanon ku dianiu bu poganad amu dianakon poꞌ moto u sumungod, bu ombabaꞌ og bolotabat u. Bu mokulali amu dun mahatul. ");
INSERT INTO suc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Poꞌ og pomali u molomu unuton bu ondiꞌ amu da kobogatan dun.” ");
INSERT INTO suc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ngon gondow non, og Gondow nog Pogulali, minian si Isus bu og sulangguꞌanan non dia sog polayan. Og sulangguꞌanan non koyon mingotuꞌ nog paloy mangka nilan pomoliasoy bu kanoy poꞌ mogutom ilan. ");
INSERT INTO suc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Dadi, dangan mitongow ilan nog parasiuanan koyon, miktaluꞌ ilan dia ni Isus nog, “Tontong nika poloꞌma og sulangguꞌanan mu koyon. Miginang ilan ma nog konaꞌ botad sog Gondow nog Pogulali.” ");
INSERT INTO suc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dadi, tinabal ilan ni Isus nog, “Daꞌ niu taꞌ buan kobasta og sinulat kituꞌ sog Kitab paꞌali sog gininang ni Dabid kituꞌ kobon nituꞌ dangan kigutoman ilan nog dumaanan non? ");
INSERT INTO suc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sinumolod ion sog dialom nog Baloy nog Poktomuyan dia sog Mikpongon bu kinuman ion nog pan kituꞌ nog inuakil na dia sog Mikpongon mangka non dosop pomogoyoy dun og dumaanan non. Saka daꞌidun bosia og mokokan dun lual da og boliananan poꞌ maꞌ nituꞌ og bonduan dia sog Botad. ");
INSERT INTO suc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bu koduaꞌ sop, daꞌ niu taꞌ kobasta og sinulat kituꞌ dia sog Botad nog, giap nog Gondow nog Pogulali, og boliananan moginang da sog Baloy nog Poktomuyan, tibua, daꞌ ilan da pokosalaꞌ dun. ");
INSERT INTO suc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Toluꞌon ku dianiu, nog numun kituꞌ ngon na dini bololagaꞌ pa dia sog Baloy nog Poktomuyan dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Somoꞌ bosia mosabut niu og maꞌana nog sinulat koni sog Kitab nog, ‘Og kolegan ku og mololat amu, gabaꞌ nog pomalas niu dianakon.’ Somoꞌ misabut niu da, diꞌ niu bosia poliholaꞌon og gotow nog daꞌ pokodusa. ");
INSERT INTO suc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Poꞌ og Binataꞌ sog Kilawan, ion og Pogbayaꞌ sog Gondow nog Pogulali.” ");
INSERT INTO suc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tidu ilan dion, sinumolod ilan dituꞌ sog baloy nog poglumpukan nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Bu ongon og glaki dion nog minguyomong og komot non. Sabap sog pogolapsobapan nilan si Isus, sinakan nilan ion nog, “Og botad taꞌ gidoy mokpokodag nog diꞌ mokodag sog Gondow nog Pogulali?” ");
INSERT INTO suc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tinabal ilan ni Isus bianan sog pononggiꞌan. Maꞌ long non dun, “Bila ngon sala kotow dianiu nog ngon solabuk bilibili non nog saka milabuꞌ dia sog gluang nog mitang sog Gondow nog Pogulali, potiangon niu taꞌ gidoy dion. Ondiꞌ niu taꞌ owaꞌon dion? ");
INSERT INTO suc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Og gotow labi pa kobololagaꞌ dia sog bilibili. Dadi, saꞌan ituꞌ, og botad da og moginang nog molongas minsan og Gondow nog Pogulali.” ");
INSERT INTO suc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tubus nituꞌ, tinoluꞌan non og gotow koyon nog minguyomong og komot non nog, “Ogot mu og komot mu koyon.” Dadi, inogot non dodaꞌ og komot non koyon bu mioksud na maꞌ nog dan, maꞌ da nog sobolaꞌ komot non koyon. ");
INSERT INTO suc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tibua, linumuas og parasiuanan koyon mangka ilan pogupakat bog olo pondayan nilan bagun nilan ompongulaꞌat si Isus. ");
INSERT INTO suc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tibua, kisunan ni Isus og pikilan nilan koyon. Dadi, minawaꞌ ion sog bonua koyon. Modakol og gotowanan nog mikpogunut dianon. Bu kiuliꞌan non og glam nog mosakitanan nilan ");
INSERT INTO suc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","mangka non ilan pogondiꞌoy moguksug paꞌali dianon. ");
INSERT INTO suc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Saꞌan ion maꞌ nion poꞌ bagun motuman og tinaluꞌ kituꞌ nog polomolatas nog Mikpongon nog si Isaya kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Koni og sosuguꞌon ku kituꞌ nog piniliꞌ u. Ion non og kololaman ku, bu kisuꞌatan u tokodoy dianon. Bogoyon ku dianon og Bolakat u bu pulonagon non og kodulusan minsan sog gotowanan nog konaꞌ Hudyu. ");
INSERT INTO suc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ondiꞌ ion moksusi, bu ondiꞌ ion moglogapis, bu diꞌ non posikadon og taluꞌ non dia sog kosompagan. ");
INSERT INTO suc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Og gotow nog moguyaꞌ og tud non pongdoloꞌisogan non. Bu tobangan non og gotow nog daꞌ na dodomaan non. Ondiꞌ ion lumotaꞌ asta popondagon non og kodulusan dia sog molaton. ");
INSERT INTO suc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bu og glam nog gotowanan mogdodama dianon.” ");
INSERT INTO suc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tubus nituꞌ, inoit nilan dituꞌ ni Isus og gotow nog tinosopan nog glatdiwata nog boyaꞌan mibuta bu migbod tanan dun. Bu kiuliꞌan ni Isus og gotow koyon nog boyaꞌan mikotongow na bu mikopoktaluꞌ na. ");
INSERT INTO suc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Og glam nog gotowanan koyon dion, kisobuꞌan ilan dun bu miksitaluꞌ ilan nog, “Ion non taꞌ gidoy ini og pangkat kituꞌ ni Apuꞌ Dabid?” ");
INSERT INTO suc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tibua, dangan midongog nog parasiuanan koyon, miktaluꞌ ilan nog, “Saꞌan ion kopogboyaꞌan non og glatdiwataanan koyon poꞌ sabap da sog bayaꞌ nog kounutan nog glatdiwataanan nog si Belsibul.” ");
INSERT INTO suc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tibua, kisunan ni Isus og dialom pikilan nilan. Dadi, tinoluꞌan non ilan nog, “Bila og sala pigdotuꞌan ombahagiꞌ bu mangka ilan poksusi ilan bu ilan, moglaꞌat ilan nododaꞌ. Bu bila og sala kobonua otawaka og sala kobaloy moksusi ilan bu ilan, ondiꞌ ilan nododaꞌ mokindog. ");
INSERT INTO suc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Bila si Kindagow bugowon non og pakasi non Kindagow, ombahagiꞌ ion dun bu diꞌ nododaꞌ mokindog og pigdotuꞌan non. ");
INSERT INTO suc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Dadi, bog maꞌ nituꞌ buan nog long niu dun, nog og bayaꞌ u dia miktidu sog bayaꞌ ni Belsibul, ain ma gidoy buan miktidu og bayaꞌ nog glaꞌayatanan niu koyon momugow dun? Dili da og glaꞌayatanan niu og mokotaksiꞌ dianiu nog diꞌ motud og poktoluꞌon niu koyon. ");
INSERT INTO suc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tibua, bila og bayaꞌ u koni momugow nog glatdiwataanan dia miktidu sog Bolakat nog Mikpongon, og maꞌana non minatong na og kopogdatuꞌ nog Mikpongon dianiu. ");
INSERT INTO suc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Bu doma maꞌ nini, olo gidoy mogandun kosolod nog gotow dia sog baloy nog gotow kituꞌ nog modasig bu mangka non pongolapoy og balananan nog gotow koyon, lual da boludon non poguna og gotow koyon nog modasig? Ombalud non tibua, malap non na og balananan nog glaki koyon. ");
INSERT INTO suc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Simasima og diꞌ sumolabuk dianakon, binanta non akon. Bu simasima diꞌ tumabang dianakon mokpolimud nog pigotowan ku, og maꞌana non, ion tanan og mogbinglag dun. ");
INSERT INTO suc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Dadi, toluꞌon ku dianiu, nog minsan olo dusaoy dun bu minsan olo og kopoglakaꞌlakaꞌ non sog Mikpongon, og gotowanan koyon kompunan da. Tibua, ain og moglakaꞌlakaꞌ dia sog Bolakat nog Mikpongon ondiꞌ nododaꞌ kompunan. ");
INSERT INTO suc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bu simasima og mantu dia sog Binataꞌ sog Kilawan bianan sog taluꞌ, kompunan da. Tibua, simasima og mantu dia sog Bolakat nog Mikpongon bianan sog taluꞌ, ondiꞌ nododaꞌ kompunan tidu sog numun koni asta sog gunan nog gondow.” ");
INSERT INTO suc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Long sop ni Isus dun, “Og kayu nog molongas, molongas sop og bunga non. Bu og kayu nog togo mosakit, molaton sop og bunga non poꞌ og kayu, kilolaan bianan sog bunga non. ");
INSERT INTO suc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Og tupuꞌanan amu nog mamak kituꞌ nog molala! Olo og mogandun kopoktaluꞌ niu nog molongas nog saka molaton amu nog gotow? Poꞌ og taluꞌ nog gotow nog lumuas sog babaꞌ non, dia miktidu sog dialom pikilan non. ");
INSERT INTO suc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Poꞌ bila molongas og mitaguꞌ dia sog pomikilan nog gotow, molongas dosop og polomotadon non bu ponoluꞌon non. Tibua, bila molaton og mitaguꞌ dia sog pomikilan nog gotow, molaton dosop og polomotadon non bu ponoluꞌon non. ");
INSERT INTO suc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Poꞌ toluꞌon ku dianiu, sog matong og gondow kituꞌ nog poliholaꞌon nog Mikpongon og glam nog gotowanan, og kokonia dianilan kosakan ilan nog minsan siꞌoy sotoktang og mitaluꞌ nilan nog daꞌidun sagnat non. ");
INSERT INTO suc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Poꞌ bianan sog tinaluꞌ niu kituꞌ, og taluꞌ niu kituꞌ og mukum dianiu bog kompunan amu taꞌ otawaka ondiꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tubus nituꞌ, og duma parasiuanan koyon dion bu og polopanadanan nog botad miktaluꞌ dia ni Isus nog, “Polopanad, potongowoy mu dow ami nog gingyataꞌ mu.” ");
INSERT INTO suc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tinumabal si Isus nog, “Og gotowanan numun koni nog mongambat ilan nog gingyataꞌ, molaton ilan nog gotow bu mogbaluꞌbaluꞌ ilan tibua moktamuy dia sog Mikpongon. Mongambat ilan siꞌoy dun, daꞌidun og gingyataꞌ nog potongowon dianilan lual da og gingyataꞌ nog paꞌali dia ni Jona, og polomolatas kituꞌ nog taluꞌ nog Mikpongon kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Domikian da maꞌ ni Jona nog tolu gobi tolu ondow ion sog dialom tian nog kosolagan nog sodaꞌ, maꞌ nituꞌ dosop og Binataꞌ sog Kilawan, tolu gobi bu tolu ondow dosop ion dia sog dialom nog glupaꞌ. ");
INSERT INTO suc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Poꞌ sog matong gondow nog polihalaꞌ og gotowanan sog koliwagan bonua nog Ninebe, mampuꞌ ilan mindog monusun sog gotowanan numun koni nog sumboy ukumon. Poꞌ ilan siꞌoy, dangan midongog nilan og gustalan ni Jona, miglilaꞌ ilan mogdayun nog dusaanan nilan. Saka numun koni ongon na dini og motas pa dia ni Jona. ");
INSERT INTO suc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Bu maꞌ nituꞌ dosop og baꞌi kituꞌ kobon nituꞌ nog tidu sog bonua nog Siba. Molayuꞌ siꞌoy tokodoy og piktiduan non, migapas da mangoy monginongog nog kotoan ni Datuꞌ Solomon. Ion siꞌoy, sog matong gondow nog polihalaꞌ, mindog dosop ion monusun sog gotowanan numun koni nog sumboy ukumon. Saka numun koni ongon na dini og motas pa dia ni Solomon.” ");
INSERT INTO suc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Maꞌ long sop ni Isus dun, “Bila lumuas og glatdiwata tidu sog glawas nog gotow nog sinongonan non, ginangon non moglinsuaꞌan sog ainain nog kolukan monontong nog gulolian non. Tibua, ondiꞌ ion mokotongow dun. ");
INSERT INTO suc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Dadi, moktaluꞌ ion nog, ‘Mokpuliꞌ u dituꞌ sog bakas tiniduan ku.’ Bila matong ion dion, motongow non nog daꞌidun og migonong dun, bu molonuꞌ, bu migusoyusoy. ");
INSERT INTO suc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mongonggat pa ion nog pitu buk glatdiwataanan nog duma non nog labi pa dianon kolaton mangka ilan sangon dia sog gotow koyon, bu pogonong dion. Dadi, og doksuꞌan nog gotow koyon, labi pa kolaton sog tiganaꞌ kituꞌ. Domikian da maꞌ nituꞌ og gotowanan numun koni nog mokolaton ilan.” ");
INSERT INTO suc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sog solian pa moktaluꞌ ni Isus sog gotowanan, minatong og ginaꞌ non bu og putupusodanan non nog kolokianan. Dituꞌ ilan pogindog sog glowasan poꞌ moleg ilan mogabitabit dianon. ");
INSERT INTO suc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ongon sala kotow dion miktaluꞌ dianon nog, “Polopanad, og ginaꞌ mu bu putupusodanan mu nog kolokianan, dituꞌ ilan sog glowasan poꞌ moleg ilan mogabitabit dianika.” ");
INSERT INTO suc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tinumabal si Isus nog, “Sima buan og ginaꞌ u bu og putupusodanan ku?” ");
INSERT INTO suc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tinonduꞌ non og sulangguꞌanan non mangka poktaluꞌ nog, “Koni og ginaꞌ u bu og putupusodanan ku. ");
INSERT INTO suc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Poꞌ simasima og mokokunut nog glegan nog Gamaꞌ u sog glangit, ilan og putupusodanan ku bu og ginaꞌ u.” ");
INSERT INTO suc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sog gondow koyon, linumuas si Isus sog baloy koyon mangka angoy ingkud sog goksid nog danow koyon poꞌ mokpanad ion. ");
INSERT INTO suc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Sabap sog kodakol nog gotowanan og linumumpuk dianon, sinumakoy ion sog bolangoy mangka ingkud dituꞌ. Bu og gotowanan koyon, dion ilan pogindog sog pontad. ");
INSERT INTO suc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bu modakol og pinanad non dianilan bianan sog pononggiꞌan. Maꞌ long non dun, “Ngon sala kotow minangoy sumigwag nog boniꞌ. ");
INSERT INTO suc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Dangan sinigwag non og boniꞌ non koyon, og duma dia mitonaꞌ sog dalan bu pingoktuk nog manukmanukanan. ");
INSERT INTO suc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Og duma sop dia mitonaꞌ sog dolonitan nog ombabow da og glupaꞌ non. Bu tinumubuꞌ mogdayun poꞌ ombabow og glupaꞌ non. ");
INSERT INTO suc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tibua, dangan pinodosan, milanos og pomulan koyon poꞌ sabap sog ombabow da og tinonoman nog gamut non. ");
INSERT INTO suc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Og duma sop dia mitonaꞌ sog sompinitan. Dadi, dangan linumawa og sompinit koyon, miumos og pomulan koyon dun. ");
INSERT INTO suc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Og duma sop dia mitonaꞌ sog monapuꞌ nog glupaꞌ. Dadi, dangan tinumubuꞌ og pomulan koyon, mokosubuk bu pogbunga mangka songkuꞌ. Og duma sinumongkuꞌ nog ginotusan, og duma sop sinumongkuꞌ nog pinuluꞌan, bu og duma sop glinongowan. ");
INSERT INTO suc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Dadi, ain togo tolinga, sumboy pokinongogan non og piktaluꞌ u koni.” ");
INSERT INTO suc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tubus nituꞌ, mikpolani og sulangguꞌanan non dianon mangka ilan poksak nog, “Iduma og gustalan mu dia sog gotowanan bianan ma sog pononggiꞌan?” ");
INSERT INTO suc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tinabal ilan ni Isus nog, “Amu koyon, pisabut na dianiu og milimod kituꞌ nog paꞌali sog pigdotuꞌan nog Mikpongon. Tibua, og duma gotowanan, ondaꞌ ilan bogoyoy dun. ");
INSERT INTO suc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Poꞌ ain og gotow nog ngon na sabut non, dungagan pa dianon bagun moksawadsawad og dianon. Tibua, simasima daꞌidun dianon, saka momikil nog ngon da dianon, owaꞌon dianon minsan siꞌoy og dakoldakol non na. ");
INSERT INTO suc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Saꞌan ituꞌ og gustalan ku dianilan bianan dia sog pononggiꞌan poꞌ minsan siꞌoy mokotongow ilan, ondiꞌ nilan da kosunan, bu mokinongog ilan siꞌoy, diꞌ nilan da modongog otawaka mosabut. ");
INSERT INTO suc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bianan dianilan mituman og pidonsamaꞌ kituꞌ tumaluꞌ ni Isaya, ‘Modongog niu siꞌoy kobon non, ondiꞌ niu da mosabut. Motongow niu siꞌoy kobon non, ondiꞌ niu da kosunan. ");
INSERT INTO suc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Poꞌ miglokobol og pikilan nilan. Bu tinimpong nilan og tolinga nilan, bu pinodong nilan og mataanan nilan. Somoꞌ bosia ondiꞌ ilan maꞌ nituꞌ, mokotongow ilan, bu mokodongog ilan, bu mokosabut ilan dosop nog boyaꞌan sumunguꞌ ilan dianakon poꞌ bagun ku ilan kuliꞌan.’ ");
INSERT INTO suc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Tibua, amu, pipia amu poꞌ mokotongow og mataanan niu bu mokodongog og tolingaanan niu. ");
INSERT INTO suc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Poꞌ toluꞌon ku dianiu, nog modakol og polomolatasanan bu og gotowanan nog midulus nog moksabaꞌ ilan bosia mokotongow nog mitongow niu koyon bu mokinongog nog midongog niu koyon. Tibua, daꞌ ilan dosop pokotongow bu pokodongog dun.” ");
INSERT INTO suc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Long pa ni Isus dun, “Dadi, pokinongogoy niu poloꞌma og maꞌana nog pononggiꞌan paꞌali sog sinumigwag kituꞌ nog boniꞌ. ");
INSERT INTO suc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Og gotow kituꞌ nog mikodongog nog gustalan paꞌali dia sog pigdotuꞌan nog Mikpongon nog saka ondaꞌ non kosabut, domikian da mamaꞌ nog dalan kituꞌ nog kitonaꞌan nog boniꞌ. Inangoy nog Soitan pongowaꞌoy dianon og midongog non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Og dolonitan kituꞌ nog ombabow da og glupaꞌ dun nog kitonaꞌan nog boniꞌ kituꞌ, domikian da mamaꞌ nog gotow kituꞌ nog, puꞌun midongog non og gustalan kituꞌ nog paꞌali sog Mikpongon, tinabuk non dunut landuꞌ og gloliag non dun. ");
INSERT INTO suc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tibua, daꞌ non ungodoy mahatul dia sog dialom pikilan non. Tinumud siꞌoy ion, solianlian da. Poꞌ bila dotongan ion nog glogon otawaka og posakit sabap sog kotabuk non nog gustalan kituꞌ, bolongon non mogdayun. ");
INSERT INTO suc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bu og sompinitan kituꞌ nog kitonaꞌan nog boniꞌ, domikian da mamaꞌ nog gotow kituꞌ nog midongog non siꞌoy og gustalan kituꞌ, tibua, sabap sog susaan nog kotubuꞌ non bu og gloliag non nog daya, mimung ondaꞌ doksuꞌ nog gustalan kituꞌ dia sog kotubuꞌ non. ");
INSERT INTO suc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bu og glupaꞌ kituꞌ nog monapuꞌ nog kitonaꞌan nog boniꞌ, domikian da mamaꞌ nog gotow kituꞌ nog mikodongog nog gustalan paꞌali sog pigdotuꞌan nog Mikpongon mangka non kosabut. Dadi, og gustalan kituꞌ sinumongkuꞌ sog kotubuꞌ nilan. Og duma sinumongkuꞌ nog ginotusan, og duma sop sinumongkuꞌ nog pinuluꞌan, bu og duma sop sinumongkuꞌ nog glinongowan.” ");
INSERT INTO suc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tubus nituꞌ, miguksug nosop si Isus nog len pononggiꞌan. Long non dun, “Og kopogdatuꞌ nog Mikpongon domikian da mamaꞌ nog gotow kituꞌ nog mimula nog molongas nog boniꞌ sog binalan non. ");
INSERT INTO suc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tibua, dangan mikponulug na gotowanan, minatong og banta non mangka sigwagoy nog boniꞌ nog sigbot mangka ion uliꞌ. ");
INSERT INTO suc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dadi, dangan tinumubuꞌ mangka pomonsut og pomulan non koyon, og sigbot siꞌoy koyon tinumakin dosop lumawa. ");
INSERT INTO suc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Dadi, og sosoligananan nog gapuꞌ nog binalan kituꞌ, minangoy ilan moktaluꞌ dianon nog, ‘Kounutan, konaꞌ taꞌ og boniꞌ kituꞌ nog sinigwag mu sog binalan mu lunsan molongas? Ain gidoy miktidu og sigbotanan kituꞌ nog mikponubuꞌ dituꞌ?’ ");
INSERT INTO suc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tinumabal og gotow kituꞌ nog, ‘Og banta ion, og miginang koyon nog maꞌ nion.’ Dadi, miksak ilan nosop nog, ‘Olo ma og kolegan mu? Ongoyon nami na pomogdutoy?’ ");
INSERT INTO suc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tinabal non sop ilan nog, ‘Naꞌ niu pa sokaliꞌ pomogduton poꞌ gomonsunoy mosunuꞌ og pomulan koyon dun. ");
INSERT INTO suc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Potiangon ta pa ilan mokponubuꞌ asta sog matong gumani. Poꞌ bila matong na og gumani, dondagon ku poguna momogdut og sigbotanan koyon dia sog polonggani mangka nilan pomogbodoy bu doksuloy mangka nilan pa gonioy og pomulan koyon bu oitoy sog gantib u.’” ");
INSERT INTO suc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tubus nituꞌ, miguksug nosop si Isus nog len pononggiꞌan. Long non dun, “Og pigdotuꞌan nog Mikpongon domikian da mamaꞌ nog bataꞌbataꞌ longow nog pimulan nog gotow dia sog binalan non. ");
INSERT INTO suc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Minsan siꞌoy ion bataꞌbataꞌ sog glam nog glongowanan, dangan tinumubuꞌ ion miimung molabung sog glam nog pomulananan dion bu miktimaluy kayu nog boyaꞌan og pangaanan non pogopunan tanan nog manukmanukanan.” ");
INSERT INTO suc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tubus nituꞌ, miguksug nosop ion nog len pononggiꞌan. Long non dun, “Og pigdotuꞌan nog Mikpongon domikian da mamaꞌ nog pokpotulin nog pan nog linimbual nog sala kotow glibun dia sog pitu gantang tapung asta miksagot ilan na nog tapung koyon boyaꞌan tinumulin dun.” ");
INSERT INTO suc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Og glam nog tinaluꞌ non dia sog gotowanan koyon pibian non dia sog pononggiꞌan. Bu daꞌidun gustalan non dianilan nog daꞌ non pobianoy sog pononggiꞌan. ");
INSERT INTO suc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Dadi, mituman og tinaluꞌ kituꞌ bianan dia sog polomolatas nog, “Toluꞌon ku dianilan bianan sog pononggiꞌan bu ustalon ku dianilan ain og mibuni kituꞌ nog tidu pa sog tolipunan.” ");
INSERT INTO suc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tubus nion, ginonatan ni Isus og gotowanan koyon mangka ion solod sog baloy. Bu mikpogunut dianon og sulangguꞌanan non mangka ilan poktaluꞌ nog, “Ustal mu pa dianami bog olo og maꞌana nog pononggiꞌan mu kituꞌ paꞌali sog sigbotanan sog binalan.” ");
INSERT INTO suc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tinabal non ilan nog, “Og sinumigwag nog boniꞌ koyon nog molongas, ion non ion og Binataꞌ sog Kilawan. ");
INSERT INTO suc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Og binalan sop koyon, ion non ion og dunya. Bu og molongas sop kituꞌ nog boniꞌ, ion non ion og pigotowan nog Mikpongon. Og sigbotanan sop kituꞌ, ion non ion og pigotowan nog Soitan. ");
INSERT INTO suc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Og banta kituꞌ nog sinumigwag nog boniꞌ nog sigbot, ion non ion si Kindagow. Bu og tang nog gumani, ion non ion og bungkas. Bu og polonggani kituꞌ, ion non ion og moloikatanan. ");
INSERT INTO suc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Og sigbotanan koyon nog pomogduton nilan bu doksuloy, maꞌ nion og dunon dia sog pigotowan ni Kindagow sog doksuꞌan nog dunya. ");
INSERT INTO suc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Og Binataꞌ sog Kilawan, popongoyon non og moloikatanan non mongawaꞌ nog ain minampuꞌ kituꞌ dia sog pigotowan non nog mokoit dianilan dumusa bu og glam nog mokpoginang kituꞌ nog sinoitan. ");
INSERT INTO suc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Sigbuon nilan dia sog gapuy nog diꞌ ompalong. Bu dituꞌ ilan poglulad bu mongolongot og ngisianan nilan. ");
INSERT INTO suc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tubus nituꞌ, ain og midulus, sumilow ilan mamaꞌ nog gondow dituꞌ sog pigdotuꞌan nog Gamaꞌ nilan nog ion og Mikpongon. Ain togo tolinga, sumboy pokinongogan non og piktaluꞌ u koni!” ");
INSERT INTO suc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Maꞌ long sop ni Isus dun, “Og kopogdatuꞌ nog Mikpongon domikian da mamaꞌ nog daya nog binuni dia sog binalan. Dangan mitongow nog gotow, binuni non mokpuliꞌ. Bu sabap sog daꞌdaꞌan non inangoy non pomoksaluy og glam nog gakodanan non mangka non soluyoy og binalan koyon.” ");
INSERT INTO suc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ngon dosop og pononggiꞌan non. “Og kopogdatuꞌ nog Mikpongon domikian da mamaꞌ nog polonaluy nog mutiaꞌ nog monontong nog mokolongas nog mutiaꞌ. ");
INSERT INTO suc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Dangan mikotongow ion nog landuꞌ kologan nog mutiaꞌ, inangoy non pomoksaluy og glam nog gakodanan non mangka non soluyoy og solabuk mutiaꞌ kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Maꞌ long sop ni Isus dun, “Og kopogdatuꞌ nog Mikpongon domikian dosop mamaꞌ nog pokot nog linabuꞌ dia sog danow nog mitaban nog miglologinis nog sodaꞌ. ");
INSERT INTO suc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Dangan mitaban nog modakol, linulut nilan sog goksid. Tubus nion, mikpongingkud ilan mangka nilan pomiliꞌoy. Ain og mokolongas dun pinginaguꞌ nilan dia sog tongkalanganan. Bu ain og mokolaton pimilak nilan. ");
INSERT INTO suc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mamaꞌ nini dosop og ginangon dia sog gotowanan sog matong og bungkas. Poꞌ og moloikatanan, ongoyon nilan siboyoy og mokolaton dia sog midulus. ");
INSERT INTO suc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Bu ain og mokolaton kituꞌ, sigbuon nilan dia sog gapuy nog diꞌ ompalong. Bu dituꞌ ilan poglulad bu mongolongot og ngisianan nilan.” ");
INSERT INTO suc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tubus nituꞌ, sinakan ilan ni Isus nog, “Misabut niu dotaꞌ da og piktaluꞌ u koni dianiu?” Tinumabal ilan nog, “Oꞌo, misabut nami da.” ");
INSERT INTO suc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tinoluꞌan non ilan, “Dadi, og polopanad nog Botad nog pilatas ni Muses nog pikponadan paꞌali sog pigdotuꞌan nog Mikpongon, mamaꞌ ion nog gotow kituꞌ nog togo baloy nog ngon dugu nog daya non dun. Ngon og bogu kalap, bu ngon sop og dan kalap nog potongowon non.” ");
INSERT INTO suc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Dangan midoksuꞌ si Isus moguksug nog pononggiꞌananan koyon, ginumonat na ion sog bonua koyon ");
INSERT INTO suc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","mangka ion uliꞌ sog dili bonua non. Dangan minatong ion dituꞌ, mikpanad ion dia sog gotowanan sog baloy nog poglumpukan nilan. Kisobuꞌan ilan nog pikpanad non koyon. Bu mikpoksitaluꞌ ilan nog, “Ain non gidoy ion mialap og kotoan non koyon bu og ginanganan non koyon nog kosobuꞌsobuꞌ? ");
INSERT INTO suc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Konaꞌ taꞌ ion og bataꞌ nog polongimung kituꞌ nog baloy? Bu konaꞌ non taꞌ ion og ginaꞌ si Maria? Og pigilugananan non si loꞌ Jems, si Jusep, si Simun, bu si Judas? ");
INSERT INTO suc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bu konaꞌ taꞌ nog mikunul ita nog glam nog kongudananan non nog kolibunanan? Ain non gidoy ion mialap og glam nog maꞌ nion koyon?” ");
INSERT INTO suc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sabap dion, kilotonan ilan dianon. Tibua, tinoluꞌan ilan ni Isus nog, “Og polomolatas nog taluꞌ nog Mikpongon pogodaban minsan ain, lual da sog dili bonua non otawaka sog dili baloy non.” ");
INSERT INTO suc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sabap sog kulang og tud nilan dianon, mikaꞌan da og gingyataꞌ nog pitongow non dion. ");
INSERT INTO suc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sog tang koyon, midongog ni Datuꞌ Herod og dongogan paꞌali dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Dadi, miktaluꞌ ion sog dodondagon non nog, “Og gotow koyon, ion non ion si Jan nog Polomunyag. Mitubuꞌ ion puliꞌ. Saꞌan mikopoginang ion nog kosobuꞌsobuꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Saꞌan miktaluꞌ si Herod nog maꞌ nituꞌ poꞌ ion og minukpaꞌ, bu minalud, bu kinumolobusu dia ni Jan poꞌ sabap dia ni Herodias, og duoy nog kongudan non nog si Pilip. Poꞌ pigduoy ni Herod si Herodias. ");
INSERT INTO suc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Dadi, pigbinaꞌan ni Jan si Herod nog maꞌ long non dun, “Konaꞌ ion og botad nog pogduoyon mu ion.” ");
INSERT INTO suc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Sabap dituꞌ, si Herod moleg bosia munuꞌ dia ni Jan, tibua, mondok ion sog gotowanan poꞌ tinolimaꞌ nilan si Jan nog polomolatas ion nog taluꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sog gondow nog binotaꞌan dia ni Herod, miglokologyaꞌan ion. Sog tang koyon, og bataꞌ ni Herodias nog glibun mingigal sog sunguꞌan nog gotowanan koyon dion. Bu linoliag tokodoy si Herod dun ");
INSERT INTO suc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","boyaꞌan nog sinumapa ion dia sog dolaga koyon nog, minsan olo og pongonion non bogoyon non nododaꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Og dolaga koyon, pimolian ion nog ginaꞌ non nog maꞌ nini og toluꞌon non, “Bogoy mu numun kituꞌ dianakon og gulu ni Jan nog Polomunyag nog dia toguꞌoy sog tabak.” ");
INSERT INTO suc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Miksonsol bosia og datuꞌ koyon nog taluꞌ non kituꞌ. Tibua, sabap sog kibulugan non na tumaluꞌ bu kitoksiꞌan noma og taluꞌ non kituꞌ nog gotowanan koyon dion nog pimosunan non, dinondag non gotow non bagun da motuman og pingoni nog dolaga koyon. ");
INSERT INTO suc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Dadi, pinutukan nog gulu si Jan dituꞌ sog kolobusuan, ");
INSERT INTO suc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","mangka nilan toguꞌoy sog tabak og gulu non koyon bu oitoy sog datuꞌ mangka bogoyoy sog dolaga kituꞌ. Bu ion na og migoit dun dia sog ginaꞌ non. ");
INSERT INTO suc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Og sulangguꞌanan ni Jan, inangoy nilan olapoy og bangkoy non mangka nilan lobongoy. Tubus nituꞌ, inangoy nilan toluꞌoy dituꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Dangan midongog ni Isus, migdoduoy ion sumakoy sog bolangoy mangka ion angoy sog bonua kituꞌ nog moliliꞌ. Tibua, dangan kisunan nog gotowanan koyon nog ginumonat ion, ilan siꞌoy ginumonat dosop bu poglondug dianon. Bigyaꞌ non, dia ilan minian sog kotasan. ");
INSERT INTO suc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Dangan dinumongguꞌ si Isus, mitongow non nog landuꞌ kodakol og gotowanan dion nog migbagad dianon. Milolat ion dianilan bu pikodag non ain og diꞌ mokokodag. ");
INSERT INTO suc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dangan miglolabung na bonua, mikpolani dianon og sulangguꞌanan non mangka ilan poktaluꞌ nog, “Og bonua koni molayuꞌ sog gimbolayan saka glolabung na. Golom nika na ilan dondagoy ompanow monukat nog ponganon nilan dituꞌ sog gimbolayananan nog bonua koni.” ");
INSERT INTO suc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tinabal ilan ni Isus nog, “Ondiꞌ ilan na sumboy ompanow poꞌ amu na pogbogoy nog ponganon dianilan.” ");
INSERT INTO suc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Aba! Kulang bayuꞌ non ini, poꞌ lima buk da og pan bu duaꞌ buk da sodaꞌ dini!” ");
INSERT INTO suc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Long ni Isus dun, “Oit niu dow buan ion dini.” ");
INSERT INTO suc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dadi, dinondag non og gotowanan mokpongingkud sog sigbotan koyon nog gombaꞌis ingkudan. Tubus nituꞌ, inimud non og lima buk pan bu duaꞌ buk sodaꞌ koyon mangka ion tongal sog glangit bu posolomatoy dia sog Mikpongon. Tubus nituꞌ, pimoti non og pan koyon mangka non pomogoyoy sog sulangguꞌanan non. Bu pimogoy dosop nog sulangguꞌanan non dia sog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dadi, mikpongongan og glam nilan bu mikpogbosug ilan tanan. Ngon pa og samaꞌ nog gotowanan kuman nog lagaꞌ nog sopuluꞌ bu duaꞌ bogyas og miomud nog sulangguꞌanan koyon dun. ");
INSERT INTO suc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Og dakol nog gotowanan koyon nog kinuman dun lima ngibu, daꞌ glakit nog kolibunanan bu gombataꞌanan. ");
INSERT INTO suc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tubus nituꞌ, piuna ni Isus og sulangguꞌanan non tumulak posunguꞌ sog dipag, poꞌ ion, pogonaton non pa poguna og gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Dangan miksuoy si Isus bu og gotowanan kituꞌ, migdoduoy ion tumukad sog bontud poꞌ mogyakin ion dituꞌ. Asta miglogobi salasala non da dion. ");
INSERT INTO suc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Og sulangguꞌanan non sop kituꞌ, modibabaꞌ na og bolangoy nilan. Pigdoksangan ilan nog nabok poꞌ misonsung nilan og galuꞌ. ");
INSERT INTO suc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dangan migdaliꞌondow tibua og bonua, minangoy si Isus dituꞌ nilan nog mipanow dia sog dibabow nog tubig nog danow koyon. ");
INSERT INTO suc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dangan ion mitongow nog sulangguꞌanan non nog pokpanow ion sog dibabow nog tubig, kiondokan ilan tokodoy dun. Dadi, mikpoktaluꞌ ilan kobon nilan moglosek nog, “Og mongondok!” ");
INSERT INTO suc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tibua, pigdoyunan ni Isus tumaluꞌ dianilan nog, “Potiknaꞌ niu og pikilan niu! Akon ini! Naꞌ amu kondokan!” ");
INSERT INTO suc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tibua, miktaluꞌ si Piter nog, “Kounutan, bila motud dodaꞌ nog ika ion, popangoy mu akon dion nika nog ompanow u dosop dia sog dibabow nog tubig.” ");
INSERT INTO suc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Dadi, tinumabal si Isus nog, “Angoy a loꞌ buan dini.” Dadi, tinumukpa dodaꞌ si Piter tidu sog bolangoy koyon mangka panow sog dibabow nog tubig posunguꞌ dituꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tibua, dangan mibatik non nog molandos og galuꞌ, kiondokan ion dun. Dadi, mingmayaꞌmayaꞌ ion molonod. Mikopoglosek ion mongintabang nog, “Kounutan ku, tobangoy mu akon!” ");
INSERT INTO suc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Pigdoyunan mogaid ni Isus si Piter kobon non moktaluꞌ nog, “Ika, kulang dodaꞌ og salig mu! Iduma ion mogduaꞌduaꞌ a ma?” ");
INSERT INTO suc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dadi, dangan sinumakoy ilan tibua sog bolangoy nilan koyon, mipadok og galuꞌ koyon. ");
INSERT INTO suc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tubus nituꞌ, og glam nilan koyon sog bolangoy, tinumamuy ilan dianon mangka poktaluꞌ nog, “Motud dodaꞌ nog ika, og Bataꞌ a nog Mikpongon!” ");
INSERT INTO suc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dangan mikotolipag ilan sog danow koyon, sokaliꞌ ilan dinumongguꞌ sog bonua nog Genesaret. ");
INSERT INTO suc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bu dangan kinilolaan nog gotowanan koyon dion si Isus, pinosunan nilan og glam nog gotowanan dion sog malugmalug nilan koyon, labi na ain og gotowanan kituꞌ nog togo mosakit pinitang nilan dituꞌ non. ");
INSERT INTO suc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bu migbubut ilan dianon nog potuyokon ilan pa nog sagya siꞌoy og sudung nog ponopoton non. Bu og glam nog mikotuyok dun, kiuliꞌan ilan. ");
INSERT INTO suc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tubus nituꞌ, ongon og parasiuanan bu polopanadanan nog botad nog bansa Hudyu nog tidu ilan sog Jerusalem, minangoy ilan moksak dituꞌ ni Isus. Maꞌ long nilan dun, ");
INSERT INTO suc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Iduma ion, og sulangguꞌanan mu koyon, ondiꞌ nilan ma unuton og botad nog mokogulang paꞌali sog kopongugas nog komotanan nilan mangka ilan siꞌoy kan?” ");
INSERT INTO suc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Dadi, sinakan ilan ni Isus, “Amu sop buan, iduma ion ondaꞌ niu ma unutoy og dondagan nog Mikpongon sabap sog kitogadan niu koyon? ");
INSERT INTO suc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Poꞌ miktaluꞌ og Mikpongon nog, ‘Pogodaboy niu og ginaꞌamaꞌ niu.’ Bu taluꞌ non dosop, ‘Simasima og sumolap monaluꞌ dia sog ginaꞌamaꞌ non, sumboy bunuꞌon.’ ");
INSERT INTO suc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tibua, amu, mokpanad amu nog og gotow bila moktaluꞌ dia sog ginaꞌamaꞌ non nog og tabang kituꞌ nog bogoyon non bosia dianilan, binogoy non na dia sog Mikpongon, ");
INSERT INTO suc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","mogusoy nog diꞌ non na pogodaban og ginaꞌamaꞌ non. Dadi, bianan sog pogbotadon niu koyon sinop niu og taluꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sagya amu tibua og mokpopotongow. Motud dodaꞌ og pidonsamaꞌ kituꞌ tumaluꞌ ni Isaya nog paꞌali dianiu. ");
INSERT INTO suc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Og gotowanan koni, og kopogadab nilan dianakon taman da nog babaꞌ nilan, tibua, og pomikilan nilan molayuꞌ tokodoy dianakon. ");
INSERT INTO suc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Daꞌidun og maꞌana nog kopoktamuy nilan dianakon poꞌ og pikpanad nilan koyon sagya da polomotadon nog pigimungimung nog sagyaotow.’” ");
INSERT INTO suc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tubus nituꞌ, sinabi ni Isus og gotowanan koyon nog mokpolani ilan dianon mangka ion poktaluꞌ nog, “Pokinongog amu mahatul bagun niu mosabut og poktoluꞌon ku koni. ");
INSERT INTO suc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ain og sumolod dia sog babaꞌ nog gotow ondiꞌ moglomuꞌ gotow dun dia sog Mikpongon. Sugaꞌid non, ain og lumuas nog molaton tidu sog babaꞌ non mimung moglomuꞌ og gotow dun.” ");
INSERT INTO suc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tubus nituꞌ, mikpolani og sulangguꞌanan non koyon mangka ilan poksak dianon nog, “Polopanad, daꞌ mu taꞌ kosunoy nog milaton nog parasiuanan og tinaluꞌ mu kituꞌ?” ");
INSERT INTO suc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tinumabal si Isus bianan sog pononggiꞌan nog, “Glam nog pomulan nog konaꞌ og gamaꞌ u sog glangit og mimula dun, bogduton da. ");
INSERT INTO suc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Potiang niu ilan poꞌ og polonuluꞌ ilan, nog saka mibuta ilan. Bila og buta og mogagak sog pakasi buta non, og duaꞌ ilan koyon molabuꞌ sog gluang.” ");
INSERT INTO suc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Miktaluꞌ si Piter nog, “Ustal mu pa dianami og pononggiꞌan mu kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Dadi, miktaluꞌ si Isus nog, “Kobon non mamaꞌ amu nog duma gotow nog diꞌ mokosabut! ");
INSERT INTO suc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Daꞌ niu taꞌ ion kosunoy nog ain sumolod sog babaꞌ nog gotow mogdayun sog tibuka, mangka na luas? ");
INSERT INTO suc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tibua, ain lumuas tidu sog babaꞌ, ion non ion og tidu sog dialom pikilan bu mimung nog moglomuꞌ og gotow dun dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Poꞌ tidu sog dialom pikilan nog gotow mimung nog mokopikil ion nog molaton bu mokinang nog molaton mamaꞌ nog momunuꞌ, bu momabal nog konaꞌ non duoy, bu duma pa nog ginang koyon nog sinoitan, bu monakow, bu monaksiꞌ nog diꞌ motud, bu bolotiboton. ");
INSERT INTO suc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Og maꞌ nion koyon nog kohinangan mimung moglomuꞌ og gotow dun. Tibua, og kuman nog diꞌ mongugas nog komot non, diꞌ ion mimung moglomuꞌ og gotow dun dia sog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tubus nituꞌ, ginumonat si Isus sog bonua koyon mangka angoy dituꞌ lambul sog koliwagan bonua nog Tair bu sog Sidon. ");
INSERT INTO suc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dangan minatong ion dituꞌ, ngon sala kotow glibun, nog gotow Kanaꞌan migonong dion, mikpolani ion dianon. Mikilolat ion dia ni Isus, kobon non moktaluꞌ nog, “Kounutan, ika og pangkat ni Dabid, kololatoy mu akon poꞌ og bataꞌ u nog glibun tinosopan nog glatdiwata bu misinsa ion tokodoy dun.” ");
INSERT INTO suc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tibua, ondaꞌ ion tobaloy ni Isus. Dadi, mikpolani dianon og sulangguꞌanan non mangka ilan poktaluꞌ nog, “Polopanad, dondag mu og glibun koyon mawaꞌ poꞌ mokosasow.” ");
INSERT INTO suc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tinumabal si Isus nog, “Saꞌan pipangoy u dini poꞌ tumabang u tibua sog gotow Israel kituꞌ nog pinonggiꞌ dia sog bilibilianan nog mikpogbolong.” ");
INSERT INTO suc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Og glibun koyon miningluꞌud dia sog sunguꞌan ni Isus mangka poktaluꞌ nog, “Kounutan, tobangan u pa, suꞌusa!” ");
INSERT INTO suc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tinabal ion ni Isus nog, “Ondiꞌ pia nog olapon og ponganon nog gombataꞌanan koyon mangka tikpuꞌoy dia sog gayamanan.” ");
INSERT INTO suc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dadi, tinumabal og glibun koyon nog, “Motud ion, tibua, minsan og gayamanan mokokan da nog mumu nog mokpoglabuꞌ tidu sog glomisahan nog gapuꞌ nilan.” ");
INSERT INTO suc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dadi, tinabal ni Isus og glibun koyon nog, “Ompagon dodaꞌ og kopongandol mu! Dadi, motuman na og pingoni mu koyon.” Bu sododuꞌun kinumodag og bataꞌ non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tubus nituꞌ, ginumonat si Isus dion mangka pongoksid sog danow nog Galili koyon. Tubus nituꞌ, tinumukad ion sog bontud koyon mangka ingkud. ");
INSERT INTO suc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Modakol og gotowanan nog minangoy dituꞌ non nog mikpokpitang nog dadayanan, og butaanan, og pingkaꞌanan, bu bodanan. Bu modakol pa og duma nog pingoit nilan dion mangka nilan botangoy sog sunguꞌan non. Bu og glam nilan koyon kiuliꞌan og mokosakitanan nilan. ");
INSERT INTO suc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Og gotowanan, kisobuꞌan ilan dun dangan mitongow nilan nog og bod mikopoktaluꞌ na, og dadayanan mikopanow na, og butaanan mikotongow na, bu og pingkaꞌanan kiuliꞌan na, mangka nilan poksonglitoy og Diwata nog poktomuyon nog bansa Israel. ");
INSERT INTO suc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sinabi ni Isus og sulangguꞌanan non nog mokpolani dianon mangka ion poktaluꞌ dianilan nog, “Milolat u nog gotowanan koni. Poꞌ sog solod nog tolu gobi bu toluondow ilan dini nakon, kinobus ilan na nog ponganon. Ondiꞌ u sop ilan kumboyon muliꞌ nog daꞌ pokanoy poꞌ gomonsunoy ombuksak ilan sog dalan sabap sog gutom nilan.” ");
INSERT INTO suc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dadi, tinabal ion nog sulangguꞌanan non koyon nog, “Dadi, ain ita gidoy pokalap nog ponganon nog bagun ta ilan ompokan poꞌ og bonua koni molayuꞌ sog gimbolayan. Saka modakol ilan tokodoy?” ");
INSERT INTO suc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Dadi, miksak si Isus dianilan nog, “Sanu buk buan og pan niu dion?” Tinumabal ilan nog, “Pitu buk da og pan bu ngon sop og mikaꞌan nog mokolintokon nog sodaꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dadi, dinondag ni Isus og gotowanan mokpongingkud. ");
INSERT INTO suc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Dangan mitabuk non og pitu buk pan kituꞌ bu og sodaꞌanan kituꞌ, pisolomatan non sog Mikpongon bu pomotioy og pan kituꞌ mangka non pomogoyoy sog sulangguꞌanan non koyon. Bu pimogoy sop nog sulangguꞌanan non dia sog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mikpongongan og glam nilan bu mikpogbosug ilan tanan. Ngon pa og samaꞌ nog gotowanan koyon kuman nog lagaꞌ nog pitu bogyas nog mikpokponuꞌ og miomud nog sulangguꞌanan non koyon. ");
INSERT INTO suc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Og dakol nog gotowanan koyon nog kinuman pat ngibu, daꞌ glakit nog kolibunanan bu gombataꞌanan. ");
INSERT INTO suc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tubus nion, dangan pigonat ni Isus og gotowanan koyon, sinumakoy ilan nog sulangguꞌanan non sog bolangoy mangka ilan tulak posunguꞌ sog bonua nog Magadan. ");
INSERT INTO suc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Og parasiuanan bu sadusiuanan minangoy dituꞌ ni Isus poꞌ poksulaysulayan nilan ion bianan sog kopongambat nilan dianon nog gingyataꞌ nog tidu sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tinumabal ion nog, “Maꞌ long pa nog ponoluꞌon niu dun, bila og sindopondow saka ompula og sindopan, mogbolomaꞌ ion, molongas og bonua. ");
INSERT INTO suc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bu sop, bila bukaꞌsiang bonua, saka ompulapula silangan bu mogdolom og bonua, posunguꞌ mogdupiꞌ. Moto amu mongmaꞌana nog ain motongow niu sog glangit, tibua, diꞌ amu moto mongmaꞌana nog gindanan nog posunguꞌ matong sog dunya. ");
INSERT INTO suc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Og gotowanan numun koni nog mongambat ilan nog gingyataꞌ, molaton ilan nog gotow bu mogbaluꞌbaluꞌ ilan tibua moktamuy dia sog Mikpongon. Daꞌidun og gingyataꞌ nog potongowon dianilan lual da og gingyataꞌ paꞌali dia ni Jona og polomolatas kituꞌ nog taluꞌ nog Mikpongon.” Bu dunut doma, ginonatan ilan ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dangan tinumolipag ilan nog sulangguꞌanan non sog danow koyon, mikolingow og sulangguꞌanan non mogbalun. ");
INSERT INTO suc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tinoluꞌan ilan ni Isus nog, “Pokpotubud amu bu pongandam amu bagun amu diꞌ moit nog pokpotulin nog pan nog parasiuanan bu sadusiuanan koyon.” ");
INSERT INTO suc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dadi, migabitabit ilan, ilan bu ilan paꞌali sog tinaluꞌ non koyon. Maꞌ long nilan dun, “Saꞌan bayuꞌ tinaluꞌ non nog maꞌ nituꞌ poꞌ daꞌ ita pokopogoit nog ponganon ta.” ");
INSERT INTO suc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tibua, kisunan da ni Isus og pigobitobitan nilan koyon. Dadi, tinoluꞌan non ilan nog, “Amu koyon, kulang salig niu. Iduma maꞌ nion ma og poktoluꞌon niu nog daꞌ amu pokpokpitang nog pan? ");
INSERT INTO suc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Diꞌ niu potaꞌ buan mosabut otawaka kolobotan nog lima buk da og pan saka lima ngibu og gotowanan kinuman dun? Bu sanu bogyas pa og miomud niu nog samaꞌ nilan kuman dun? ");
INSERT INTO suc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bu pitu buk sop pan kituꞌ nog saka pat ngibu kotow og mikokan dun, bu sanu bogyas sop og miomud niu nog samaꞌ nilan kuman dun? ");
INSERT INTO suc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Dadi, iduma ion ondiꞌ niu poma mosabut nog saka konaꞌ paꞌali sog pan og poktoluꞌon ku koni? Sugaꞌid non, pokpotubud amu bagun amu ondiꞌ moit nog pokpotulin nog pan nog parasiuanan bu sadusiuanan koyon.” ");
INSERT INTO suc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ugat nilan pa kosabut og maꞌana nog piktaluꞌ non nog konaꞌ dodaꞌ og pokpotulin nog pan, sugaꞌid non, sumboy mokpotubud ilan bagun ilan ondiꞌ moit nog pikpanad nog parasiuanan bu sadusiuanan koyon. ");
INSERT INTO suc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Dangan ion minangoy si Isus dituꞌ lambul sog molani nog Sisaria Pilipi. Minatong ilan dituꞌ, sinakan non og sulangguꞌanan non nog, “Sima gidoy long nog gotowanan dun og Binataꞌ sog Kilawan?” ");
INSERT INTO suc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tinumabal ilan nog, “Og duma koyon mokpoktaluꞌ ilan nog ika dow si Jan nog Polomunyag. Og duma sop mokpoktaluꞌ ilan nog ika dow si Iladya, og polomolatas kituꞌ nog taluꞌ nog Mikpongon kobon nituꞌ. Bu og duma sop mokpoktaluꞌ ilan nog ika dow si Jerimaya otawaka og solabuk og polomolatas nog taluꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sinakan non sop ilan nog, “Bila buan amu, sima u gidoy?” ");
INSERT INTO suc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tinumabal si Piter, “Ika og Kristu, og Bataꞌ nog Mikpongon nog ion totubuꞌ asta sog daꞌ kopus non.” ");
INSERT INTO suc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tinabal non si Piter nog, “Popiaon ka, ika, Simun, og bataꞌ ni Jona poꞌ og tinaluꞌ mu koyon konaꞌ sagyaotow og mikposun dun dianika, sugaꞌid non, og Gamaꞌ u sog glangit. ");
INSERT INTO suc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Bu toluꞌon ku dianika nog ika, si Piter. Bu dia u pindogoy sog dolonitan koni og baloy u nog ion non ion og pigotowan ku. Bu ondiꞌ dagon nog minsan og patoy. ");
INSERT INTO suc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Bogoyon ku dianika og konsianan nog pigdotuꞌan nog Mikpongon. Bu ain og pogbonduan mu dini sog glupaꞌan, maꞌ nituꞌ dosop og bonduan dituꞌ sog glangit. Bu ain og tinugdak mu dini sog glupaꞌan, tugdakon dosop dituꞌ sog glangit.” ");
INSERT INTO suc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tubus nituꞌ, pidonsamaꞌ non tumaluꞌ dia sog sulangguꞌanan non koyon nog ondiꞌ nilan poguksugan minsan sima nog ion dodaꞌ og Kristu. ");
INSERT INTO suc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tidu dion, tinolipun ni Isus mogustal dia sog sulangguꞌanan non nog sumboy mangoy ion sog Jerusalem bu posinsaon ion tokodoy nog kobogolalan nog bansa Hudyu, bu og mokokotas nog boliananan, bu og polopanadanan nog botad nog bansa Hudyu. Bu sumboy ion bunuꞌon. Tibua, sog kotolu ondow non motubuꞌ da ion puliꞌ. ");
INSERT INTO suc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dangan midongog ituꞌ ni Piter, inagak non ion sog molayuꞌlayuꞌ mangka non pomagoy. Long non dun, “Kounutan, polosili le, ondiꞌ mu nododaꞌ ion kobianan!” ");
INSERT INTO suc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tibua, sinunguꞌ ion ni Isus mangka poktaluꞌ nog, “Soitan, awaꞌ a dini nakon! Ika og mokobagla dianakon poꞌ og pomikilan mu koyon dia miktidu sog sagyaotow, ondaꞌ dia miktidu sog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tubus nituꞌ, miktaluꞌ ion sog sulangguꞌanan non nog, “Simasima moleg mogunut dianakon, sumboy tolikudan non og dili glegan non mangka non pisanoy og kudus non bu pogunut dianakon. ");
INSERT INTO suc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Poꞌ simasima og landuꞌ kopogapas non nog dili kotubuꞌ non, kobolongan da ion dun. Tibua, simasima og lamig non na bolongon og dili kotubuꞌ non sabap sog kopokokunut non dianakon, kongonan ion dun. ");
INSERT INTO suc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Poꞌ olo gidoy buan og glongas non nog makod nog gotow og daya sog tibuk nog dunya koni saka, ombolong og glimukud non? Kobolosan taꞌ nog gotow og dili glimukud non? ");
INSERT INTO suc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Poꞌ og Binataꞌ sog Kilawan, mokpuliꞌ dini sog dunya dunut og silow nog kotas nog Gamaꞌ non, bu dunut og moloikatanan non. Tubus nituꞌ, og glam nog gotowanan, tumbasan non og monala kotow dianilan ain sog miinang nilan. ");
INSERT INTO suc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Toluꞌon ku dianiu, ngon og dumaanan ta dini nog ondiꞌ ilan pa tagad patoy taman da ondiꞌ nilan motongow og Binataꞌ sog Kilawan matong, bu og kopogdatuꞌ non.” ");
INSERT INTO suc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gonom gobi tidu dituꞌ, inoit ni Isus tumukad dituꞌ sog molawa nog bontud si Piter, si Jems, bu si Jan nog gilug ni Jems nog ilan da bu ilan. ");
INSERT INTO suc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Dangan minatong ilan dituꞌ, mitongow nilan nog miksop og bayuꞌbayuꞌ ni Isus. Miglamag maꞌ nog gondow bu sinumilow og ponopoton non nog landuꞌ koputiꞌ. ");
INSERT INTO suc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Gomonsunoy pa, ngon duaꞌ kotow tinumuaꞌ, si Muses bu si Iladya. Migabitabit ilan ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dadi, miktaluꞌ si Piter dia ni Isus nog, “Ombaꞌis da nog mikodini ami, Kounutan. Bila moleg a da, imungan ku amu nog tolu buk glokowlokow dini, solabuk dianika, solabuk dia ni Muses, bu solabuk dia ni Iladya.” ");
INSERT INTO suc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sog sonuk non koyon moktaluꞌ dun, og ginampol nog miglamag mikpotondong dianilan. Bu ongon og taluꞌ nog midongog nilan nog miktidu sog ginampol koyon nog maꞌ nini, “Koni og bataꞌ u nog kololaman ku. Kisuꞌatan u tokodoy dianon. Pokinongog amu dianon.” ");
INSERT INTO suc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dangan midongog nog sulangguꞌanan koyon og taluꞌ kituꞌ, mikponglob ilan sog glupaꞌ kobal nog gondok nilan. ");
INSERT INTO suc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tibua, pilonian ilan ni Isus mangka non ilan doponoy mangka ion poktaluꞌ nog, “Pogbuat amu na bu naꞌ amu na kondokan.” ");
INSERT INTO suc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Dangan tinumingag ilan, daꞌidun na og mitongow nilan lual da si Isus. ");
INSERT INTO suc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tubus nituꞌ, sonuk nilan dumiksun tidu sog bontud koyon, pigondiꞌan ilan ni Isus nog, “Naꞌ niu tokodoy posunon minsan sima og mitongow niu koyon tontal da ondiꞌ motubuꞌ puliꞌ tidu matoy og Binataꞌ sog Kilawan.” ");
INSERT INTO suc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sinakan ion nog sulangguꞌanan non nog, “Iduma og polopanadanan koyon nog botad nog bansa Hudyu, moktaluꞌ ilan ma nog mokuna pa tuaꞌ si Iladya mangka siꞌoy tuaꞌ og Tinonduꞌ kituꞌ nog Mikpongon Mogdatuꞌ?” ");
INSERT INTO suc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Dadi, tinabal non ilan nog, “Oꞌo, motud ion nog mokuna si Iladya poꞌ oksudon non og glam non. ");
INSERT INTO suc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tibua, toluꞌon ku dianiu nog minatong na si Iladya. Tibua, ondaꞌ ion kilolaoy nog gotowanan. Ininang nilan na dianon minsan olo og kolegan nilan moginang. Domikian da maꞌ nituꞌ, og Binataꞌ sog Kilawan nog posinsaon nilan dosop akon.” ");
INSERT INTO suc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dadi, misabut nog sulangguꞌanan non og pigolong non kituꞌ nog si Iladya, ion non ion si Jan nog Polomunyag. ");
INSERT INTO suc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Dangan minatong ilan dia sog piglumpukan nog gotowanan koyon, ongon sala kotow og mikpolani dia ni Isus mangka ingluꞌud bu poktaluꞌ nog, ");
INSERT INTO suc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Kounutan, kololatoy mu pa og bataꞌ u poꞌ bobuybobuyon ion. Bu landuꞌ na og sinsaan non dun poꞌ bikaꞌbikaꞌ ombuksak na dia sog gapuy bu dia sog tubig. ");
INSERT INTO suc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inoit u na ion sog sulangguꞌanan mu, tibua, daꞌ nilan da ion kuliꞌoy.” ");
INSERT INTO suc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dadi, miktaluꞌ si Isus nog, “Amu, og gotowanan numun koni, ondiꞌ amu nododaꞌ tumud bu polongantu amu! Andun pa kopayat og gobon ku mokunul dianiu? Andun pa kopayat og gobon ku moglogaga dianiu? Oit niu dini og bataꞌ koyon.” ");
INSERT INTO suc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dangan inoit nilan og bataꞌlaki koyon dion ni Isus, binugow non og glatdiwata koyon bu sododuꞌun linumuas og glatdiwata koyon bu kiuliꞌan og bataꞌlaki koyon dun. ");
INSERT INTO suc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tubus nion, mikpolani og sulangguꞌanan non koyon dianon mangka ilan poksak dianon nog ilanilan da. “Iduma ondiꞌ nami ma ombugow og glatdiwata kituꞌ?” ");
INSERT INTO suc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tinumabal si Isus nog, “Sabap loꞌ ion sog kulang og kopongandol niu. Toluꞌon ku dianiu, bila ongon og kopongandol niu nog minsan siꞌoy mamaꞌ nog glongow nog mustasa kobataꞌbataꞌ, kotoluꞌan niu og bulud koyon nog moglalin dioyo, bu moglalin nododaꞌ ion. Bu daꞌidun og mologon nog diꞌ niu minang.  ");
INSERT INTO suc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tibua, og glatdiwata koyon nog maꞌ nion, ondiꞌ nododaꞌ ion lumuas, bog diꞌ da bianan dia sog gyakin bu sog kopokpuasa.” ");
INSERT INTO suc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tubus nituꞌ, dangan milumpuk si Isus ilan nog sulangguꞌanan non dituꞌ sog bonua nog Galili, miktaluꞌ ion dianilan nog, “Og Binataꞌ sog Kilawan uokilon dia sog bayaꞌ nog gotowanan ");
INSERT INTO suc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bu bunuꞌon nilan ion. Tibua, sog kotolu ondow non tidu nilan bunuꞌon, motubuꞌ da ion puliꞌ.” Dadi, misusa tokodoy og sulangguꞌanan non koyon dun. ");
INSERT INTO suc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Dangan minatong si loꞌ Isus dituꞌ sog Kapernaum, og polongabatanan nog buis nog Baloy nog Poktomuyan dia sog Mikpongon, mikpolani ilan dia ni Piter mangka ilan poksak nog, “Og kounutan niu koyon mogbayad dotaꞌ nog buis nog Baloy nog Poktomuyan dia sog Mikpongon?” ");
INSERT INTO suc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tinumabal si Piter nog, “Mogbayad, le!” Dadi, dangan sinumolod si Piter sog baloy koyon poꞌ pogobitan non bosia dia ni Isus, mikuna si Isus moksak dianon nog, “Olo gidoy bila ika, Piter? Ain gidoy pongabat nog buis og kodotuꞌananan dini sog dunya koni, dia taꞌ sog gombataꞌanan nilan otawaka sog len gotow?” ");
INSERT INTO suc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tinumabal si Piter nog, “Sog len gotow nododaꞌ.” Miktaluꞌ si Isus nog, “Dadi, og maꞌana non, ita og gombataꞌ nog Mikpongon, diꞌ ita nobuan mogbayad nog buis kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tibua, bagun ilan diꞌ kolotonan dianita, angoy a pa sog danow koyon bu pomonggit. Bu og tiganaꞌ mu malap nog sodaꞌ, bukaꞌ mu og babaꞌ non bu motongow mu og solad sinan. Og golagaꞌ non mokobayad nog buis nog duaꞌ kotow sog Baloy nog Poktomuyan dia sog Mikpongon. Alap mu og sin koyon mangka mu boyadoy og buis ta, duaꞌ ita.” ");
INSERT INTO suc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sog tang koyon, mikpolani og sulangguꞌanan ni Isus dianon mangka ilan poksak nog, “Kounutan, sima og motas sog glam non sog pigdotuꞌan nog Mikpongon?” ");
INSERT INTO suc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sinabi ni Isus og sala kotow bataꞌ mangka non pindogoy sog titongaꞌ nilan koyon ");
INSERT INTO suc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","mangka ion poktaluꞌ nog, “Toluꞌon ku dianiu, bila ondiꞌ niu da sopon og pomikilan niu mamaꞌ nog pomikilan nog gombataꞌ, ondiꞌ amu nododaꞌ mokampuꞌ dia sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Dadi, simasima pobobaꞌon non og bolotabat non maꞌ nog bataꞌ koni, mimung ion nog motas sog glam non sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Bu simasima og tumolimaꞌ dia sog mamaꞌ nog bataꞌ koni bianan sog ngalan ku, tinolimaꞌ non dosop akon. ");
INSERT INTO suc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Tibua, simasima og mokongulan sog sala kotow nog tinumud dianakon maꞌ nog bataꞌ koni nog boyaꞌan mokodusa ion dun, golom na lentengoy nog mosolag nog gilingan batu og glig non mangka lobuꞌoy sog dibabaꞌ dagat. ");
INSERT INTO suc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kosusasusa og gotowanan dini sog dunya poꞌ pongyubaꞌan ilan nododaꞌ! Tibua, sumboy nododaꞌ ini mian. Bu kondokondok og doksuꞌan sog gotow kituꞌ nog sabap dianon mokodusa og pakasiotow non dun. ");
INSERT INTO suc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Dadi, bila sabap sog komot mu otawaka sog botis mu mokodusa a dun, golom nika na putuk mangka mu pilak. Poꞌ golom pa nog kongonan ka nog kotubuꞌ nog daꞌ kopus non minsan siꞌoy sobolaꞌ da og komot mu otawaka botis mu, gabaꞌ nog sigbuon og tibuk nog glawas mu dia sog danow nog gapuy. ");
INSERT INTO suc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Domikian dosop nog bila sabap sog mata mu mokodusa a dun, golom nika na uning mangka mu pilak. Poꞌ golom pa nog kongonan ka nog kotubuꞌ nog daꞌ kopus non nog sobolaꞌ da og mata mu, gabaꞌ nog duaꞌ mogimpang mata mu saka sigbuon ka da dia sog gapuy nog diꞌ ompalong.” ");
INSERT INTO suc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Maꞌ long sop ni Isus dun, “Pokpotubud amu bagun niu ondiꞌ kopoksudiꞌan og gombataꞌanan koni minsan sala kotow siꞌoy dianilan. Poꞌ toluꞌon ku dianiu, og tinumabang dianilan og moloikatanan nog Mikpongon. Bu kobon non, dituꞌ ilan sog sunguꞌan nog Gamaꞌ u, dituꞌ sog glangit.  ");
INSERT INTO suc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Saꞌan minangoy dini sog dunya og Binataꞌ sog Kilawan poꞌ tobangan non ain og mibolong kobal nog dusaanan nilan. ");
INSERT INTO suc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Pomikil niu poloꞌma. Sopolati non, ngon og gotow nog og bilibilianan non sogatus kodakol, saka og solabuk dun misuoy dia sog dumaanan non bu mibolong. Olo ma gidoy og ginangon nog gotow koyon? Gonatan non nododaꞌ og siam puluꞌ bu siam bilibilianan non koyon dia sog pongoksaban nilan mangka non ponontongoy og mibolong kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bu bila motongow non na, loliagon nododaꞌ tokodoy ion dun. Labi pa og gloliag non dun sog siam puluꞌ bu siam kituꞌ nog ondaꞌ da kobolong. ");
INSERT INTO suc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Domikian da mamaꞌ nion og Gamaꞌ niu sog glangit, nog ondiꞌ ion moleg nog ngon mangoy sog glaꞌat, sala kotow siꞌoy nog maꞌ nog bataꞌ koni.” ");
INSERT INTO suc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Maꞌ long sop ni Isus dun, “Bila mikosalaꞌ dianiu og gilug niu, angoy amu dituꞌ non mangka taluꞌ dianon og glopangan non kituꞌ nog amu amu da. Bila inongogan non ika, og maꞌana non, miglokopia amu na. ");
INSERT INTO suc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tibua, bila diꞌ non ika inongogan, pogoit a nog sala kotow otawaka duaꞌ kotow og duma mu bagun niu da munut og tinaluꞌ kituꞌ dia sog Kitab nog, ‘Bila ngon sumbungan, sumboy duaꞌ kotow otawaka tolu kotow og mokotaksiꞌ dun.’ ");
INSERT INTO suc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Bila ondiꞌ non pa ilan inongogan, posun mu glam non dia sog glumpuk nog poktanudanan. Bu bila ondiꞌ non pa inongogan og glumpuk koyon, bibas niu na ion poꞌ mamaꞌ na ion nilan nog diꞌ moktamuy sog Mikpongon bu og polongabatanan nog buis. ");
INSERT INTO suc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Dadi, toluꞌon ku dianiu, nog ain og pogbonduan niu dini sog glupaꞌan, maꞌ nituꞌ dosop og bonduan dituꞌ sog glangit. Bu ain og tinugdak niu dini sog glupaꞌan, tugdakon dosop dituꞌ sog glangit. ");
INSERT INTO suc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Bu toluꞌon ku pa dianiu, nog bila duaꞌ kotow dianiu moksolabuk nog pongonion nilan dia sog Mikpongon nog minsan olo, inangon nododaꞌ dianilan nog Gamaꞌ u sog glangit. ");
INSERT INTO suc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Poꞌ minsan duaꞌ kotow otawaka tolu kotow moglumpuk sabap nog ilan og pigotowan ku, dia u dosop nilan.” ");
INSERT INTO suc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tubus nituꞌ, mikpolani si Piter dia ni Isus mangka poksak nog, “Kounutan, sanu kali u ompunoy og gilug u bila mokosalaꞌ dianakon? Pitu kali taꞌ?” ");
INSERT INTO suc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tinabal ion ni Isus nog, “Konaꞌ tibua pitu kali, sugaꞌid non, pitu puluꞌ kopitu kali. ");
INSERT INTO suc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Dadi, og kopogdatuꞌ nog Mikpongon sog gotowanan ompononggiꞌ dia sog solabuk datuꞌ nog moleg na boyadan nog sosuguꞌonanan non. ");
INSERT INTO suc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dangan miktolipun na ion mongabat, ngon og sala kotow sosuguꞌon non nog inoit dituꞌ non nog og dakol nog gutang non linoksaꞌan na. ");
INSERT INTO suc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sabap sog daꞌidun og pogbayad non dun, dinondag nog datuꞌ koyon nog poksaluy tidu sog glawas non mangoy sog duoy non asta pa og gombataꞌanan non bu og glam nog gakodanan non bagun non tibua koboyadan og gutang non. ");
INSERT INTO suc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tibua, miningluꞌud og sosuguꞌon non koyon sog sunguꞌan nog datuꞌ koyon mangka pongapuꞌngapuꞌ dianon nog, ‘Kounutan, longgungoy mu pa suꞌusa akon poꞌ boyadan ku da og glam non koyon dianika.’ ");
INSERT INTO suc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dadi, og datuꞌ koyon milolat dianon boyaꞌan nog piondaꞌ non na tanan og gutang non kituꞌ mangka non na ion dondagoy muliꞌ. ");
INSERT INTO suc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tubus nituꞌ, sonuk nog sosuguꞌon non koyon ompanow, milumpak non og pakasi sosuguꞌon non nog mikutang dianon mikaꞌan. Ginanggut non mogdayun mangka non longokoy bu poktaluꞌ nog, ‘Boyadoy mu na numun kituꞌ og gutang mu kituꞌ dianakon!’ ");
INSERT INTO suc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Miningluꞌud dosop og pakasi sosuguꞌon non kituꞌ mangka pongapuꞌngapuꞌ dianon nog, ‘Longgungoy mu pa akon! Poꞌ boyadan ku da og gutang u kituꞌ dianika.’ ");
INSERT INTO suc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tibua, daꞌ non nododaꞌ ion longgungoy. Sugaꞌid non, inoit non sog gukum bagun ion kolobusuon asta ombayad non na og gutang non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Dangan mitongow nog duma sosuguꞌonanan nog datuꞌ kituꞌ og kohinangan non koyon, ondaꞌ ilan tokodoy kosuꞌatoy dun. Dadi, inangoy nilan uksugoy dituꞌ sog datuꞌ og glam nog miinang non koyon. ");
INSERT INTO suc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Dadi, tinugun ion mogdayun nog datuꞌ kituꞌ. Dangan minatong ion dituꞌ, tinoluꞌan ion nog datuꞌ nog, ‘Ika, molaton ka nog gotow! Mikutang a dianakon nog mosolag tokodoy og golagaꞌ non. Tibua, sabap nog mingapuꞌngapuꞌ a dianakon, piondaꞌ u na og glam nog gutang mu kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Dumaꞌit bosia nog mololat a dosop dia sog pakasi sosuguꞌon mu mamaꞌ nog gininang u kituꞌ dianika!’ ");
INSERT INTO suc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dadi, sabap sog glolingit nog datuꞌ nilan koyon, inoit non ion sog gukum bagun pokposokitan asta mokobayad ion nog glam nog gutang non kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Dadi, long ni Isus dun, “Mamaꞌ nion dosop og ginangon nog Gamaꞌ u sog glangit dianiu bila ondiꞌ niu ompunan og pakasi niu nog gas nog pusung niu.” ");
INSERT INTO suc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Dadi, dangan midoksuꞌ na si Isus mokpanad, ginumonat ion sog Galili mangka angoy sog bonua nog Judia nog dituꞌ sog dipag nog Jurdan. ");
INSERT INTO suc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Modakol og gotowanan nog mikpogunut dianon. Bu dituꞌ kiuliꞌan non ain diꞌ mokokodag. ");
INSERT INTO suc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ongon og parasiuanan mikpolani dianon poꞌ poksulaysulayan nilan ion mangka ilan poksak dianon nog, “Og botad dotaꞌ nog og gotow nog bolongon non og glibun non nog minsan olo og piksobapan non?” ");
INSERT INTO suc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tinumabal si Isus nog, “Daꞌ niu taꞌ buan kobasta sog Kitab nog sog tolipunan, ‘Og Mikpongon, piongon non og glaki bu og glibun.’ ");
INSERT INTO suc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Bu ngon dosop og sinulat nog, ‘Saꞌan ituꞌ og glaki, gonatan non og ginaꞌamaꞌ non mangka ion ampuꞌ sog glibun non. Bu og duaꞌ ilan koyon mimung nog salulawas ilan na.’ ");
INSERT INTO suc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dadi, konaꞌ na nog duaꞌ kotow, sugaꞌid non, miksolabuk ilan na. Dadi, ain og pigampuꞌ nog Mikpongon, sumboy ondiꞌ popogbolongon nog sagyaotow.” ");
INSERT INTO suc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dadi, miksak nosop og parasiuanan koyon nog, “Saka buan dinondag ma ni Muses nog og glaki, bila bolongon non og glibun non, sumboy tumulun poguna nog gitas mangka non siꞌoy uokiloy og glibun non?” ");
INSERT INTO suc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tinabal ilan ni Isus nog, “Saꞌan ituꞌ tinugdak dianiu ni Muses nog ombolong niu og glibun niu poꞌ sabap nog diꞌ amu moleg pomolian. Tibua, sog tolipunan, ondiꞌ bosia maꞌ nituꞌ og botad. ");
INSERT INTO suc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Dadi, toluꞌon ku dianiu, nog simasima og glaki nog bolongon non og glibun non nog saka ondaꞌ da bosia koleg sog len glaki, bu pogduoy ion sog len, mokodusa ion dun.” ");
INSERT INTO suc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tubus nituꞌ, miktaluꞌ og sulangguꞌanan non dianon nog, “Bila maꞌ nion og botangbotang nog kopogduoy, golom na buan og gotow ondiꞌ mogduoy!” ");
INSERT INTO suc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tinumabal si Isus nog, “Og pikpanad u koni ondiꞌ tolimaꞌon nog glam nog gotow, sugaꞌid non, ain da kibogayan kituꞌ dun nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ongon gotowanan nog ondiꞌ mogduoy poꞌ donsamaꞌ na daꞌ pongonoy nog glegan mogduoy tidu pa sog kobataꞌ dianilan. Bu og duma sop linosian nog duma non. Bu ongon dosop gotowanan ondiꞌ mogduoy poꞌ tinigbung nilan na og pikilan nilan dia sog pigdotuꞌan nog Mikpongon. Dadi, ain og gotow nog tumolimaꞌ nog pikpanad u koni sumboy inangon non.” ");
INSERT INTO suc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tubus nituꞌ, ongon og gotowanan nog mikpogoit nog gombataꞌanan nilan dituꞌ ni Isus bagun non ilan kodoponan bu kopogyokinan dia sog Mikpongon nog popiaon ilan. Tibua, pimag ilan nog sulangguꞌanan ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tibua, miktaluꞌ si Isus nog, “Potiang niu og gombataꞌanan koyon mokpolani dianakon. Naꞌ niu ilan pogondiꞌan. Poꞌ maꞌ nog gombataꞌanan koyon, og gotowanan nog misakup sog pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dadi, pingdoponan non og gombataꞌanan koyon dion, mangka na ion poglandan. ");
INSERT INTO suc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tubus nituꞌ, ongon sala kotow mikpolani dia ni Isus mangka poksak nog, “Polopanad, olo gidoy og ombaꞌis u inangon bagun ku malap og kotubuꞌ nog daꞌ kopus non?” ");
INSERT INTO suc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tinabal ion ni Isus nog, “Iduma moksak a ma dianakon bog olo og ombaꞌis? Solabuk da og ombaꞌis, ion og Mikpongon. Sugaꞌid non, bila moleg a mokalap nog kotubuꞌ nog daꞌ kopus non, unut mu og dondagananan nog miktidu dianon.” ");
INSERT INTO suc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dadi, miksak og glaki koyon nog, “Ain sog dondagananan koyon nog sumboy u unuton?” Tinumabal si Isus nog, “Naꞌ a momunuꞌ, naꞌ a momabal nog konaꞌ mu duoy, naꞌ a monakow, bu naꞌ a tumaksiꞌ nog gloput. ");
INSERT INTO suc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pogbotadoy mu og ginaꞌamaꞌ mu, bu kolalam a sog sumbaloy mu mamaꞌ da nog glolaman mu sog dili glawas mu.” ");
INSERT INTO suc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tinumabal og glaki koyon nog, “Piginang u na og glam non koyon. Dadi, olo poma og kulang nog sumboy u pa inangon?” ");
INSERT INTO suc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dadi, tinabal ion ni Isus nog, “Bila moleg a dodaꞌ mohurup, angoy mu poksaluy og pogongonon mu mangka mu pomogoy og saluy non dia sog miskinananan poꞌ mogdaya a dun dituꞌ sog glangit. Tubus nituꞌ, pokpuliꞌ a mangka a pogunut dianakon.” ");
INSERT INTO suc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dangan midongog nog glaki koyon og taluꞌ ni Isus koyon, mipanguꞌ ion dun mangka awaꞌ poꞌ doyahan ion tokodoy. ");
INSERT INTO suc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tubus nituꞌ, miktaluꞌ si Isus sog sulangguꞌanan non nog, “Toluꞌon ku dianiu, nog mologon tokodoy og gotow nog doyahan nog mokampuꞌ ion dia sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bu toluꞌon ku dianiu, nog molomu pa kobian nog kamel dia sog gluang nog dialum, gabaꞌ nog doyahan, og kampuꞌ non dia sog pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dangan midongog nog sulangguꞌanan non og taluꞌ non koyon, kisobuꞌan ilan tokodoy dun nog boyaꞌan miksak ilan nog, “Bila maꞌ nituꞌ buan, sima ma og motabang?” ");
INSERT INTO suc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pigbontayan ilan ni Isus mangka ion poktaluꞌ nog, “Og maꞌ nion koyon ondiꞌ minang nog sagyaotow. Tibua, daꞌidun mologon dia sog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tinumabal si Piter nog, “Dadi Kounutan, ami sop buan koni nog lamig nami na tanan binolong og glam non mangka ami pogunut dianika. Olo ma matong dun dianami?” ");
INSERT INTO suc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tinumabal si Isus nog, “Toluꞌon ku dianiu, sog matong og pongimboguan nog Mikpongon og glam non, bu og Binataꞌ sog Kilawan mingkud na ion sog gingkudan datuꞌ dunut silow nog kotas nog bayaꞌ non, amu siꞌoy nog mikokunut koyon dianakon, pingkudon ku dosop amu dia sog sopuluꞌ bu duaꞌ gingkudan datuꞌ, mongukum nog sopuluꞌ bu duaꞌ pangkat nog bansa Israel. ");
INSERT INTO suc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bu ain ginonatan non og baloy non, og putupusodanan non, og mokogulanganan non, og gombataꞌanan non, otawaka glupaꞌ non sabap sog kopokokunut non dianakon, mokotabuk ion nog labi pa tokodoy dituꞌ og sugda dun dianon, bu kongonan ion dosop nog kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tibua, modakol og gotow nog mikuna nog mimung ombinayaꞌ ilan. Bu modakol dosop og gotowanan nog mibinayaꞌ nog mimung mokuna ilan.” ");
INSERT INTO suc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tubus nituꞌ, si Isus miguksug nog pononggiꞌan. Long non dun, “Og kopogdatuꞌ nog Mikpongon ompononggiꞌ dia sog gotow kituꞌ nog glupaꞌ non pimulanan nog bolagon nog molongas og bunga non, og ngalan non og paras. Daliꞌ ondow pa og bonua, minangoy na ion monontong nog gotow nog ain moleg tindanan moginang sog glupaꞌ non koyon. ");
INSERT INTO suc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dangan ion mikotongow nog tindanan non, miglokoposadan nilan nog boyadan non dianilan solad dinari poꞌ maꞌ nituꞌ og golagaꞌ nog sondow. Dadi, minangoy ilan na moginang sog glupaꞌ non koyon. ");
INSERT INTO suc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Dangan miginongaꞌ monek gondow, minangoy ion puliꞌ sog tobuꞌan. Mitongow non og duma gotowanan nog daꞌ ginang nilan, daꞌ lual og mogindogindog ilan tibua. ");
INSERT INTO suc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Dadi, tinoluꞌan non ilan nog, ‘Angoy amu poginang dituꞌ sog glupaꞌ u poꞌ boyadan ku da amu nog golagaꞌ nog ain og miinang niu.’ ");
INSERT INTO suc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dadi, minangoy ilan moginang dituꞌ. Og gapuꞌ nog glupaꞌ koyon, dangan minatong og tasondow bu miginongaꞌ monog gondow, mikpuliꞌ nosop sog tobuꞌan bu maꞌ nituꞌ dosop ininang non. ");
INSERT INTO suc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Dangan daliꞌ na sindop ondow, mikpuliꞌ nosop ion sog tobuꞌan bu mikotongow ion nosop nog gotowanan dituꞌ nog og duma daꞌ ginang nilan. Dadi, sinakan non ilan nog, ‘Iduma maꞌ nion amu ma, poloꞌ indogindog amu ma tibua? Ondiꞌ amu ma moginang?’ ");
INSERT INTO suc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tinumabal ilan nog, ‘Daꞌidun buan og tumindan dianami.’ Dadi, tinumabal og gapuꞌ nog glupaꞌ koyon nog, ‘Bila maꞌ nituꞌ, angoy amu poginang sog glupaꞌ u.’ Dadi, minangoy ilan moginang dituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Dangan sindop ondow na, miktaluꞌ og gapuꞌ nog glupaꞌ koyon dia sog sosoligan non. Long non dun, ‘Polumpuk mu og glam nog gotowanan koyon nog miginang sog glupaꞌ u gondow koni. Pogunaoy mu mogbayad ain og mibinayaꞌ, mangka mu siꞌoy boyadoy ain og mikuna kituꞌ.’ ");
INSERT INTO suc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dadi, sinabi non og gotowanan kituꞌ nog miktolipun ilan moginang nog poksindop na og gondow bu binoyadan non ilan nog golagaꞌ nog sondow. ");
INSERT INTO suc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dadi, dangan boyadan non na bosia og gotowanan kituꞌ nog mikuna moginang, migdodama ilan bosia nog modakoldakol og motabuk nilan dia sog mibinayaꞌ kituꞌ moginang. Tibua, migbatuk da kodakol og binayad non dianilan. ");
INSERT INTO suc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tinabuk nilan notibua og boyadan koyon dianilan kobon nilan mokumodumod bu tinoluꞌan nilan og gapuꞌ nog glupaꞌ koyon nog, ");
INSERT INTO suc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Og mibinayaꞌ koyon, podaliꞌ ilan da miginang. Tibua ami, sumondow ami na moginang sog podosan saka pigbatuk mu ma og kodakol og boyadan mu dianami?’ ");
INSERT INTO suc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dadi, tinumabal og gapuꞌ nog glupaꞌ koyon dia sog sala kotow dianilan. Long non dun, ‘Le, daꞌ u ika pogbigyaꞌoy. Mikpasad ita kopia nog boyadan ku amu nog golagaꞌ nog sondow. Dadi, saꞌan ion, maꞌ nion og binayad u dianiu. ");
INSERT INTO suc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dadi, tabuk niu ion mangka amu siꞌoy uliꞌ. Poꞌ maꞌ nituꞌ og glegan ku mogbogoy dia sog gotowanan koyon nog mibinayaꞌ ilan siꞌoy moginang, mamaꞌ nog binayad u koyon dianiu. ");
INSERT INTO suc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Daꞌidun taꞌ buan og bayaꞌ u nog minsan olo og gondunon ku nog sin ku? Diꞌ amu bosia moksibok dun bila motawal u sog duma.’” ");
INSERT INTO suc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dadi, maꞌ long pa ni Isus dun, “Og mibinayaꞌ mimung mokuna bu og mikuna ilan mimung ombinayaꞌ ilan.” ");
INSERT INTO suc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tubus nituꞌ, mipanow si Isus posunguꞌ sog Jerusalem. Sintak nilan koyon ompanow, pinitang non og sopuluꞌ bu duaꞌ sulangguꞌanan non koyon sog molayuꞌlayuꞌ mangka non ilan toluꞌoy nog, ");
INSERT INTO suc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Posunguꞌ ita loꞌ ini sog Jerusalem. Matong ita dituꞌ, og Binataꞌ sog Kilawan uokilon dia sog mokokotas nog boliananan bu sog polopanadanan nog botad nog bansa Hudyu. Og gukuman nilan dianon bunuꞌon ");
INSERT INTO suc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","mangka nilan ion uokiloy dia sog gongkoman nog gotowanan nog konaꞌ bansa Hudyu. Pogwanwanon nilan ion, pogdonogon nilan ion, bu lonsangon nilan ion sog kudus. Tibua, sog kotolu ondow non, motubuꞌ da ion mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tubus nituꞌ, og duoy ni Sebedi bu og duaꞌ kotow gombataꞌ non kituꞌ nog glaki, migdunut ilan mangoy dituꞌ ni Isus mangka ion ingluꞌud sog sunguꞌan ni Isus poꞌ ongon kolegan non mongoni. ");
INSERT INTO suc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Dadi, sinakan ion ni Isus nog, “Olo og kolegan mu koyon?” Tinumabal og glibun koyon nog, “Tugdak mu pa dianakon nog bila matong na mogdatuꞌ a, dia mu pa pingkud og sala kotow bataꞌ u koni dapit sog glintu mu bu og sala kotow sop koni dia dapit sog bibang mu.” ");
INSERT INTO suc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tinabal ion ni Isus nog, “Daꞌ mu kosabut bog olo og pingoni niu koyon. Mogaga niu taꞌ gidoy og sinsaan nog posunguꞌ u poglogogaon?” Tinumabal og duaꞌ kotow gombataꞌ nog glibun koyon nog, “Oꞌo, mogaga nami da ion.” ");
INSERT INTO suc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Miktaluꞌ si Isus nog, “Oꞌo, motud dodaꞌ nog mokinum amu sog ginuman ku. Tibua, konaꞌ u og momiliꞌ bog sima og mingkud sog dapit glintu u otawaka sog dapit bibang u. Poꞌ og gingkudananan koyon donsamaꞌ na piksimpan nog Gamaꞌ u.” ");
INSERT INTO suc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Dangan midongog ituꞌ nog sopuluꞌ sulangguꞌanan koyon, kodoluon ilan bosia dun og piginang nog pigilug koyon duaꞌ kotow. ");
INSERT INTO suc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dadi, pilumpuk ilan ni Isus mangka non ilan toluꞌoy nog, “Kosunan niu nog og kodotuꞌan dini sog dunya pogboyaꞌan nilan og pigotowan nilan. Bu ain mokokotas dianilan pogboyaꞌan nilan dosop ain ombabaꞌ pa dianilan. ");
INSERT INTO suc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tibua amu, sumboy ondiꞌ amu maꞌ nilan. Sugaꞌid non, ain og moleg nog ion og motas dianiu, sumboy ion mimung og sosuguꞌon niu. ");
INSERT INTO suc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bu ain sop dianiu og moleg nog ion og mokuna, sumboy ion mimung nog gulipon niu. ");
INSERT INTO suc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Domikian da maꞌ nog Binataꞌ sog Kilawan, ondaꞌ ion angoy dini sog dunya poꞌ bagun ion tobangan, sugaꞌid non, bagun ion og tumabang bu moguakil nog glawas non bunuꞌon bagun modakol og gotowanan og molokat tidu sog kouliponan nog dusa.” ");
INSERT INTO suc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Dangan ginumonat si Isus ilan nog sulangguꞌanan non sog koliwagan bonua nog Jeriku, modakol og gotowanan nog mikpogunut dianilan. ");
INSERT INTO suc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ongon og duaꞌ kotow buta, dia ilan pogingkud sog goksid nog dalan. Dangan kisunan nilan nog posunguꞌ mian dituꞌ si Isus, miglongag ilan moktawag, “Kounutan! Pangkat ni Apuꞌ Dabid! Kololatoy mu pa ami!” ");
INSERT INTO suc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pomagon ilan siꞌoy nog gotowanan dion, posisayaꞌ ilan da poktawag nog, “Kounutan! Pangkat ni Apuꞌ Dabid! Kololatoy mu pa ami, suꞌusa!” ");
INSERT INTO suc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dadi, migindog si Isus mangka non ilan sobioy bu poksak, “Olo og kolegan niu nog inangon ku dianiu?” ");
INSERT INTO suc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tinumabal ilan nog, “Kounutan, moleg ami bosia mokotongow puliꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dadi, milolat si Isus dianilan mangka non tuyokoy og mataanan nilan. Sog sododuꞌun koyon mikotongow ilan bu migunut ilan dianon. ");
INSERT INTO suc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Dangan molanilani ilan na sog Jerusalem, minatong ilan sog Betpage, dituꞌ sog pun bilid nog Olibu. Dinondag ni Isus moguna dituꞌ og duaꞌ kotow sulangguꞌanan koyon. ");
INSERT INTO suc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Bu miktaluꞌ ion dianilan nog, “Angoy amu sog gimbolayan koyon. Matong amu dituꞌ, mokotongow amu mogdayun nog inikotan og asnu bu og nati non. Ubad niu bu oit niu dini nakon. ");
INSERT INTO suc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bu bila ongon og moksak dun dianiu bog iduma ubadon niu ma, tabal niu tibua nog ongon og kobalan nog Kounutan dun. Poꞌ tugdakon da dianiu.” ");
INSERT INTO suc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Saꞌan ini miinang poꞌ og kotumanan nog tinaluꞌ nog polomolatas nog taluꞌ nog Mikpongon kobon nituꞌ nog, ");
INSERT INTO suc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Taluꞌ niu sog gotowanan sog Sion, tontong niu og datuꞌ niu posunguꞌ na matong dianiu. Ombabaꞌ og bolotabat non bu poksakoy ion sog asnu, og sinokayan non koyon og nati nog asnu.” ");
INSERT INTO suc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dadi, mipanow og sulangguꞌanan kituꞌ bu inunut nilan og pimali ni Isus kituꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inoit nilan og asnu kituꞌ, ilan nog nati non, dituꞌ ni Isus bu inonigan nilan nog glogdoyanan nilan mangka na sokoyoy ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Og gotowanan koyon nog landuꞌ kodakol, pingdondam nilan og sulagbonanan nilan dia sog dalan koyon nog bianan ni Isus. Og duma sop mikpongalap ilan nog dawon mamaꞌ nog dawon nog bunga mangka nilan botangoy sog dalan. ");
INSERT INTO suc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Og gotowanan koyon nog migunut dia ni Isus sog gunan binayaꞌ non, miglongag ilan mokpogekes nog, “Songlitan og pangkat ni Apuꞌ Dabid! Pipia ion nog minangoy dini bianan sog ngalan nog Mikpongon! Songlitan og Mikpongon!” ");
INSERT INTO suc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Dangan minatong si Isus sog Jerusalem, misasow og glam nog gotowanan koyon dion bu miksinaksakoy ilan nog, “Sima gidoy og gotow koyon?” ");
INSERT INTO suc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tinumabal og gotowanan koyon nog mikpogunut dia ni Isus nog, “Ion non ini si Isus, og polomolatas nog miktidu sog Nasaret dituꞌ sog Galili.” ");
INSERT INTO suc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tubus nituꞌ, si Isus sinumolod sog glomalomaan nog Baloy nog Poktomuyan koyon dia sog Mikpongon mangka non pomugowoy og glam nog gotowanan koyon nog mikpogdagangdagang bu polonaluyanan. Bu pimolitukaꞌ non og glomisahananan nog polomolos nog sin asta og gingkudananan nog mikpogdagang nog kolopatianan. ");
INSERT INTO suc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kobon non moktaluꞌ nog, “Sinulat dia sog Kitab og taluꞌ nog Mikpongon nog, ‘Og baloy u iningolanan og baloy nog pogyokinan.’ Tibua, inimung niu nog glihanan nog polonakowanan!” ");
INSERT INTO suc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Solian ni Isus sog glomalomaan nog Baloy koyon nog Poktomuyan, og butaanan bu og gotowanan kituꞌ nog diꞌ mokopanow, mikpolani ilan dianon bu kiuliꞌan non ilan. ");
INSERT INTO suc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tibua, og mokokotas nog boliananan bu og polopanadanan nog botad nog bansa Hudyu, miglolingit ilan dianon dangan mitongow nilan og kosobuꞌsobuꞌ nog gininang non bu midongog nilan og gekes nog gombataꞌanan dituꞌ sog glomalomaan nog Baloy nog Poktomuyan koyon nog, “Songlitan og pangkat ni Apuꞌ Dabid!” ");
INSERT INTO suc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Miksak og mokokotas nog boliananan bu polopanadanan kituꞌ dia ni Isus nog, “Midongog mu dotaꞌ bog olo og pogekeson nilan koyon?” Tinumabal ion nog, “Oꞌo, midongog u da. Ondaꞌ niu taꞌ buan sibon kobasta og sinulat dia sog Kitab nog, ‘Og gombataꞌanan asta og populaanan, pikponadan mu moksanglit?’” ");
INSERT INTO suc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tubus nituꞌ, ginonatan non ilan mangka ion angoy sog bonua nog Betani bu dituꞌ ion kisogobian. ");
INSERT INTO suc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Migbolomaꞌ sisolom, mikpuliꞌ si Isus dituꞌ sog Jerusalem. Sonuk non ompanow kigutoman ion. ");
INSERT INTO suc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mikotongow ion nog kayu sog goksid nog dalan og ngalan non igera. Dadi, pilonian non bosia, tibua, daꞌidun og mitongow non nog bunga non lual da lunsan dawon. Dadi, tinoluꞌan non kayu koyon nog, “Ondiꞌ a na nododaꞌ mogbunga mokpuliꞌ.” Bu sododuꞌun mibotug og kayu koyon. ");
INSERT INTO suc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Dangan mitongow nog sulangguꞌanan non nog sododuꞌun mibotug og kayu koyon, kisobuꞌan ilan dun kobon nilan moktaluꞌ nog, “Iduma ion gidoy mibotug ma mogdayun og kayu koyon?” ");
INSERT INTO suc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Dadi, tinumabal si Isus nog, “Toluꞌon ku dianiu, nog bila sumalig amu sog Mikpongon bu ondiꞌ amu mogduaꞌduaꞌ, konaꞌ tibua og minang niu mamaꞌ nog miinang u sog kayu koyon. Sugaꞌid non, minsan sagya toluꞌan niu og bulud koni nog, ‘Awaꞌ a dini bu poglalin ka sog dagat,’ motuman na dodaꞌ og taluꞌ niu koyon. ");
INSERT INTO suc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Bila tumud amu nog motabuk niu, minsan olo pongonion niu dia sog Mikpongon bianan dia sog gyakin, motabuk niu nododaꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tubus nion, sinumolod si Isus dituꞌ sog glomalomaan nog Baloy nog Poktomuyan dia sog Mikpongon mangka ion pokpanad sog gotowanan. Sonuk non mokpanad, ongon mikpolani dianon nog mokokotas nog boliananan bu kobogolalan nog gotow Hudyu mangka ilan poksak nog, “Olo bayaꞌ mu moginang nog maꞌ nion koyon? Bu sima og migbogoy dianika nog bayaꞌ koyon?” ");
INSERT INTO suc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tinabal non ilan nog, “Sakan ku dosop amu. Bila tobalon niu akon, posunon ku dosop dianiu bog ain ku tiniduan og bayaꞌ u koni moginang nog maꞌ nini koni. ");
INSERT INTO suc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Og sak u koni mamaꞌ nini, sima og migbogoy nog bayaꞌ dia ni Jan nog Polomunyag nog momunyag nog gotowanan? Og Mikpongon taꞌ otawaka og gotow?” Dadi, miksinaksakoy ilan, nog ilan bu ilan, “Bila ini toluꞌon ta nog dia tidu sog Mikpongon og bayaꞌ ni Jan, tobalon non ita nog iduma buan daꞌ ita ma tud dianon? ");
INSERT INTO suc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tibua, bila sop toluꞌon ta nog tidu dia sog gotow og bayaꞌ non, mondok ita sop nog gotowanan poꞌ og tud nilan si Jan, ion og polomolatas nog taluꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Dadi, tinabal nilan si Isus nog, “Daꞌ a sunoy. Ondiꞌ nami kosunan.” Dadi, miktaluꞌ sop si Isus dianilan nog, “Bila maꞌ nituꞌ, diꞌ u sop posunon dianiu bog sima migbogoy dianakon nog bayaꞌ nog mokopoginang u nog maꞌ nini koni.” ");
INSERT INTO suc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Maꞌ long sop ni Isus dun, “Pomikil niu poloꞌma. Ongon og gotow nog duaꞌ kotow gombataꞌ non nog lunsan laki. Minangoy ion sog gulangbataꞌ mangka poktaluꞌ nog, ‘Nuꞌ, angoy a pa poginang sog binalan ta kituꞌ gondow koni.’ ");
INSERT INTO suc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tinumabal og bataꞌ non koyon nog, ‘Ondiꞌ u.’ Tibua, sintak non mokpikilpikil dun, miksop og pikilan non bu minangoy da ion dituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tubus nituꞌ, og gamaꞌ nilan koyon minangoy sop sog bataꞌ non koyon nog kongudan mangka non sop dondagoy mangoy moginang sog binalan nilan koyon. Tinumabal og bataꞌ non koyon nog, ‘Oꞌo, Amaꞌ.’ Tibua, ondaꞌ da ion angoy dituꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Long sop ni Isus dianilan, “Bila buan amu, sima ma sog duaꞌ kotow koyon og ininang non og glegan nog gamaꞌ non?” Tinumabal ilan nog, “Og gulangbataꞌ kituꞌ.” Dadi, miktaluꞌ nosop si Isus nog, “Toluꞌon ku dianiu, nog og polongabatanan nog buis bu og tungkagonanan mokuna pa dianiu numun kituꞌ mampuꞌ sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Poꞌ saꞌan minangoy dini niu si Jan nog Polomunyag poꞌ potongowon non dianiu og bianan nog boyaꞌan mimung modulus amu dun. Tibua, ondaꞌ amu tud dianon. Bigyaꞌ non, og polongabatanan nog buis bu og tungkagonanan, tinumud ilan dianon nog boyaꞌan miksop og polomotadon nilan. Bu minsan mitongow niu na ilan nog maꞌ nion ilan, ondaꞌ amu da lotaꞌ moginang nog dusa bu tud dianon.” ");
INSERT INTO suc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tubus nituꞌ, miktaluꞌ si Isus nog, “Pokinongogoy niu nosop og solabuk pononggiꞌan koni. Ongon og gotow nog togo binalan nog pimulanan non nog bolagon nog ngalan non og paras. Inalad non og binalan non koyon mangka ion poglokukut nog pogdogyakan nog bunga nog bolagon non koyon. Bu inimungan non nog glokowlokow nog pogolungan. Tubus nituꞌ, piaksa non og binalan non koyon mangka ion panow sog len bonua. ");
INSERT INTO suc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Dangan daliꞌ na pongupuꞌoy og bunga nog pomulan non koyon, dinondag non og sosuguꞌonanan non mangoy mongabat nog bahagiꞌ non dituꞌ sog gotowanan kituꞌ nog minaksa nog pomulan non koyon. ");
INSERT INTO suc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tibua, dangan minatong ilan dituꞌ, ginanggut ilan nog minaksa koyon. Og sala kotow sosuguꞌon non koyon pigbadas nilan. Og sala kotow sop binunuꞌ nilan. Bu og kotolu non binatu nilan. ");
INSERT INTO suc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tubus nituꞌ, dinumondag nosop ion nog len sosuguꞌonanan non nog labi pa kodakol sog dinondag non kituꞌ tiganaꞌ. Tibua, og minaksa koyon, maꞌ nituꞌ dosop og ginandun nilan sog sosuguꞌonanan non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Bu sog gimpusan, dinondag non og dili bataꞌ non mangoy dituꞌ poꞌ long non dun, ‘Pogbotadan nilan ini og bataꞌ u koni.’ ");
INSERT INTO suc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tibua, dangan mitongow nog minaksa kituꞌ og bataꞌ non koyon, mikpoksitaluꞌ ilan nog, ‘Koyon na, og bataꞌ nog gapuꞌ nog glupaꞌ koni. Alung, ongoyon ta ion bunuꞌoy poꞌ bagun da ita na og gapuꞌ nog glupaꞌ koni.’ ");
INSERT INTO suc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dadi, ginanggut nilan og bataꞌ non koyon sog molayuꞌ mangka nilan bunuꞌoy.” ");
INSERT INTO suc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Dadi, long pa ni Isus dianilan, “Bila matong na og gapuꞌ nog binalan koyon, olo gidoy og gondunon non sog gotowanan kituꞌ nog minaksa koyon dianon?” ");
INSERT INTO suc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tinumabal ilan nog, “Pomunuꞌon non nododaꞌ og gotowanan kituꞌ nog mokolaton mangka non poksaoy og pomulan non koyon sog len gotowanan nog ain mogbogoy dianon nog bahagiꞌ non giap matong og tang non.” ");
INSERT INTO suc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Dadi, long sop ni Isus dun dianilan, “Daꞌ niu taꞌ buan kobasta og sinulat kituꞌ sog Kitab nog, ‘Og batu kituꞌ nog mosolag, nog pigbongkis nog polongimung nog baloy, miimung tanan nog bololagaꞌ nog polongkapan sog glam non. Ion non da og gininang nog Mikpongon bu molongas ituꞌ tokodoy dia sog tinontongan ta.’” ");
INSERT INTO suc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Long pa ni Isus dun, “Dadi, toluꞌon ku dianiu, og bahagiꞌ niu sog pigdotuꞌan nog Mikpongon owiꞌon dianiu bu bogoyon dia sog len gotowanan nog konaꞌ niu salu bansa poꞌ mokopoginang ilan nog ginang kituꞌ nog kosuꞌatan og Mikpongon dun.  ");
INSERT INTO suc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Simasima og ombuksak sog batu koni, molupot nododaꞌ og glawas non. Bu ain sop og kolobuꞌan nog batu koyon, ompusat og glawas non dun.” ");
INSERT INTO suc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Dangan midongog nog mokokotas nog boliananan bu parasiuanan og pononggiꞌananan ni Isus koyon, misabut nilan nog ilan og pigdolilan non koyon. ");
INSERT INTO suc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dadi, minontong ilan nog pondayan nog bagun nilan ion kukpaꞌan. Tibua, miondok ilan sog gotowanan poꞌ tinumud ilan nog si Isus og polomolatas nog taluꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tubus nituꞌ, miguksug nosop si Isus nog pononggiꞌan. ");
INSERT INTO suc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Maꞌ long non dun, “Og kopogdatuꞌ nog Mikpongon ompononggiꞌ dia sog sala kotow datuꞌ nog miksimpan nog kologyaꞌan poꞌ koingon og bataꞌ non nog glaki. ");
INSERT INTO suc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Dadi, dinumondag ion nog sosuguꞌonanan non mangoy mongonggat nog pimosobutan non kituꞌ sumakup sog kologyaꞌan non koyon. Tibua, migbolibad ilan. ");
INSERT INTO suc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tubus nituꞌ, dinondag non nosop og duma sosuguꞌonanan non mangka ion poktaluꞌ nog, ‘Taluꞌ niu dia sog sosuku pimosobutan kituꞌ nog misimpan na og dulang, bu pinumbaliꞌ na og sapiꞌanan ku, asta og piglombuꞌ kituꞌ nog natianan ku, bu sagad na og glam non. Dadi, sumboy tumuaꞌ ilan na nog kologyaꞌan koni.’ ");
INSERT INTO suc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tibua, daꞌ nilan ponglengleng, sugaꞌid non, mikpokpanow ilan tanan. Og sala kotow minangoy sog binalan non. Bu og sala kotow sop minangoy mogdagangdagang. ");
INSERT INTO suc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bu og dumaanan ginanggut nilan og sosuguꞌonanan nog datuꞌ kituꞌ mangka nilan pokposokitoy bu og duma pomunuꞌoy. ");
INSERT INTO suc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Dadi, linolingitan tokodoy og datuꞌ koyon dun. Bu dinondag non og sundaluanan non nog ongoyon nilan pomunuꞌoy bu pondoksuloy og koliwagan bonua nog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tubus nituꞌ, tinoluꞌan non og duma sosuguꞌonanan non nog, ‘Misimpan na og kologyaꞌan koni, tibua, og pimosobutan ku kituꞌ, ondiꞌ ilan patut sumakup dun. ");
INSERT INTO suc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dadi, angoy amu dia sog kosompagan nog gotowanan mangka niu onggat mangoy sumakup nog kologyaꞌan koni ain og motongow niu.’ ");
INSERT INTO suc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dadi, minangoy og sosuguꞌonanan koyon dia sog dalananan mangka nilan polumpukoy og gotowanan nog ain mitongow nilan, molongas otawaka molaton nog gotow. Dadi, og baloy koyon miponuꞌ nog gotowanan nog sinumakup nog kologyaꞌan koyon. ");
INSERT INTO suc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Dangan sinumolod og datuꞌ koyon poꞌ tontongon non og gotowanan koyon dion, mitongow non og sala kotow nog daꞌ posolugoy nog ponopoton kaing. ");
INSERT INTO suc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Miktaluꞌ og datuꞌ koyon nog, ‘Le, olo loꞌ ma kisolodoy mu koyon dini nog saka daꞌ a ponapot nog ponopoton kaing?’ Daꞌ pokotabal og gotow koyon. ");
INSERT INTO suc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dadi, dinondag non og sosuguꞌonanan non nog, ‘Balud niu gotow koyon mangka niu tikpuꞌ sog glowasan, dituꞌ sog kodoloman. Bu dituꞌ ion poglulad bu pongolongot og ngisianan non.’” ");
INSERT INTO suc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bu linuksad ni Isus tumaluꞌ nog, “Modakol bosia og pimosunan nog Mikpongon, tibua, mikaꞌan da og mipiliꞌ non.” ");
INSERT INTO suc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tubus nituꞌ, linumuas og parasiuanan koyon mangka ilan pogupakat bog olo pondayan nilan bagun nilan ion mosaꞌut bianan sog taluꞌ non. ");
INSERT INTO suc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dadi, dinondag nilan og duma sulangguꞌanan nilan bu duma glaꞌayatanan ni Herod mangoy dituꞌ ni Isus poꞌ pogolapsobapan nilan ion. Dangan minatong ilan dituꞌ non, miktaluꞌ ilan nog, “Polopanad, kosunan nami nog ika, moktaluꞌ a nog motud bu dumalan og pikpanad mu koyon paꞌali sog polomotadon nog glegan nog Mikpongon. Bu kisunan nami dosop nog ika, ondiꞌ a mogbigyaꞌ nog gotow minsan andun kotas non. ");
INSERT INTO suc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dadi buan, sog pikilan mu, mogusoy taꞌ nog mogbayad ita nog buis dia ni Sisar otawaka diꞌ?” ");
INSERT INTO suc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tibua, kisunan ni Isus bog olo og punan nilan moksak dun. Dadi, tinabal non ilan nog, “Iduma poksulaysulayan niu ma akon? Amu koyon, sagya mokpopotongow amu! ");
INSERT INTO suc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takun dow og sin koyon nog pogbayad nog buis.” Dadi, pitongow nilan dianon og sin koyon. ");
INSERT INTO suc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Sinakan non ilan nog, “Sima og glodawan nog mitaguꞌ dia sog sin koni? Bu sima og ngalan nog misulat koyon dini?” ");
INSERT INTO suc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Long nilan dun, “Si Sisar ma.” Miktaluꞌ si Isus nog, “Dadi, bogoy niu dia ni Sisar ain dianon. Bu bogoy niu dosop dia sog Mikpongon ain dianon.” ");
INSERT INTO suc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dangan midongog nilan ituꞌ kisobuꞌan ilan tokodoy dun bu ginonatan nilan si Isus. ");
INSERT INTO suc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sog gondow koyon, ngon dosop sadusiuanan mikpolani dia ni Isus. Og gotowanan koyon, ondiꞌ ilan tumud nog ngon motubuꞌ puliꞌ tidu matoy. Dadi, miksak ilan dia ni Isus nog, ");
INSERT INTO suc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Polopanad, maꞌ long pa nog sinulat kituꞌ ni Muses dianita nog bila og sala kopogduayan nog matoy og glaki non nog daꞌ ilan pogbataꞌ, sumboy og balulibun koyon pogduoyon nog pimikitan non bagun da bila mogbataꞌ ilan, mimung da maꞌ nog bataꞌ nilan nog glaki non kituꞌ tiganaꞌ. ");
INSERT INTO suc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ati, ngon og pitu kotow dianami, pomogilug nog lunsan laki. Og gulangbataꞌ koyon dianilan migduoy nog saka minatoy nog daꞌ ilan pogbataꞌ. Tubus nion, pigduoy nosop nog dumapit sog gulangbataꞌ og balulibun koyon. ");
INSERT INTO suc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Saka minatoy dosop og glaki koyon nog daꞌ pa bataꞌ nilan. Tubus nituꞌ, pigduoy nosop ion nog kotolu. Asta og pitu kotow pomogilug koyon mikobian mogduoy dia sog balulibun koyon. Tibua, lunsan ilan mikpomatoy nog daꞌidun og bataꞌ nilan. ");
INSERT INTO suc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Daꞌ ion kobon, og balulibun koyon minatoy dosop. ");
INSERT INTO suc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dadi, bila matong gondow nog potubuꞌon og gotowanan tidu matoy, sima ma gidoy sog pitu kotow kituꞌ nog pomogilug og kodumanan nog glibun koyon, nog saka og glam nilan koyon mikobian mogduoy dianon?” ");
INSERT INTO suc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Dadi, tinabal ilan ni Isus nog, “Milapang amu dodaꞌ tokodoy poꞌ ondaꞌidun sabut niu nog sinulat dia sog Kitab otawaka og dasig nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Poꞌ bila matong na potubuꞌon nog Mikpongon og gotowanan tidu matoy, ondiꞌ ilan na mokpogduoy poꞌ mamaꞌ ilan na nog moloikatanan sog glangit. ");
INSERT INTO suc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Bu paꞌali sop sog kopotubuꞌ nog gotowanan tidu matoy, ondaꞌ niu taꞌ kobasta og tinaluꞌ nog Mikpongon dianiu nog, ");
INSERT INTO suc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Akon og Mikpongon nog ion non og poktomuyon kituꞌ ni Abraham, ni Isak, bu ni Jakub.’ Og maꞌana nog taluꞌ nog Mikpongon kituꞌ, konaꞌ ion og poktomuyon nog ain minatoy, sugaꞌid non, ain totubuꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dangan midongog nog gotowanan og tabal ni Isus sog sadusiuanan koyon, kisobuꞌan ilan nog pikpanad non koyon. ");
INSERT INTO suc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Dangan midongog nog parasiuanan nog dinag dia ni Isus og sadusiuanan koyon, linumpukan nilan si Isus. ");
INSERT INTO suc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Og sala kotow dianilan moto tokodoy nog botad, sinulayan non si Isus moksak nog, ");
INSERT INTO suc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Polopanad, olo og dondagan kituꞌ nog bololagaꞌ sog glam non dia sog Botad?” ");
INSERT INTO suc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tinabal ion ni Isus nog, “‘Sumboy potigbungon mu og glolaman mu sog Pogbayaꞌ nog ion og Diwata mu, tidu sog pusung mu, mangoy sog glimukud mu, asta sog glam nog pomikilan mu.’ ");
INSERT INTO suc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ion non ini og mikuna nog bololagaꞌ sog glam nog dondagan. ");
INSERT INTO suc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bu ngon dosop og koduaꞌ non nog maꞌ da nituꞌ. ‘Sumboy molalam a sog sumbaloy mu mamaꞌ da nog glolaman mu sog dili glawas mu.’ ");
INSERT INTO suc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bila miunut mu og duaꞌ buk koni, og glam nog dondagan dia sog Botad nog sinulat ni Muses bu tidu sog polomolatasanan kobon nituꞌ, miunut mu na og glam non.” ");
INSERT INTO suc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sog solian pa moglumpuk nog parasiuanan koyon dion, sinakan ilan ni Isus nog, ");
INSERT INTO suc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Olo pikilan niu paꞌali sog Kristu? Sima gidoy ion pangkat dun?” Tinabal nilan si Isus nog, “Og pangkat le ni Apuꞌ Dabid.” ");
INSERT INTO suc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dadi, miktaluꞌ si Isus, “Bila maꞌ nituꞌ, olo sabap non nog si Dabid, bianan sog Bolakat nog Mikpongon, iningolanan non ion nog Kounutan non? Poꞌ long pa ni Dabid dun, ");
INSERT INTO suc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Og Pogbayaꞌ miktaluꞌ dia sog Kounutan ku, ingkud a sog dapit glintu u asta imungon ku og bantaanan mu nog gindogan nog botis mu?’ ");
INSERT INTO suc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dadi, bila si Dabid, iningolanan non na og Kristu nog Kounutan non, olo ma og kipongkatoy ni Dabid dianon?” ");
INSERT INTO suc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Daꞌidun, sala kotow siꞌoy dianilan, og mikotabal minsan sotoktang siꞌoy. Dadi, tidu dion, daꞌ ilan na giluꞌ moksak dianon. ");
INSERT INTO suc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tubus nituꞌ, miktaluꞌ si Isus dia sog gotowanan bu sulangguꞌanan non nog, ");
INSERT INTO suc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Og polopanadanan nog botad nog bansa Hudyu bu parasiuanan, binogayan ilan nog polosukuꞌan mokpanad nog botad nog pibian dia ni Muses. ");
INSERT INTO suc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dadi, sumboy pokokunut amu sog glam nog pikpanad nilan koyon. Tibua, naꞌ niu poglogilingan og kohinangan nilan koyon poꞌ ondaꞌ nilan unutoy og dili pikpanad nilan koyon. ");
INSERT INTO suc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Poꞌ og dondagananan nilan sog gotowanan ompononggiꞌ dia sog ombogat nog gobotan nog pipisan nilan dia sog gotowanan. Tibua, minsan og kolongkenge nilan, diꞌ nilan tanan potobangon mokpitang dun. ");
INSERT INTO suc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Glam nog kohinangan nilan koyon inangon nilan bagun tibua motongow nog gotowanan. Tontong niu poloꞌma, pisolag nilan og toguꞌan nog pinulatan nilan nog taluꞌ nog Kitab nog pingogbod nilan dia sog bingkonanan nilan bu dia sog gangasanan nilan. Bu pimoyabaꞌ nilan og gyambuyambu nog sudung nog ponopoton nilan. ");
INSERT INTO suc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bu bila dia ilan sog kologyaꞌan, kolegan nilan dia ilan pingkudoy sog gingkudan nog gotow kituꞌ nog pogodaban. Bu bila dia ilan sog baloy nog poglumpukan nog bansa Hudyu, kolegan nilan dia ilan pingkudoy sog gingkudan nog mokokotas nog gotow. ");
INSERT INTO suc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bu moleg ilan dosop nog pogodaban bu golunon nog gotowanan bila dia ilan sog kosompagan, bu sobion ilan nog gotowanan nog Rabi. ");
INSERT INTO suc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Tibua, amu, naꞌ niu potiangon nog sobion amu nog Rabi poꞌ pomogilug amu glam niu bu solabuk da og polopanad niu. ");
INSERT INTO suc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Naꞌ amu dosop sumabi nog Amaꞌ sog minsan sima dini sog glupaꞌan poꞌ solabuk da og Gamaꞌ niu. Ion non og Mikpongon nog dituꞌ sog glangit. ");
INSERT INTO suc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bu naꞌ niu potiangon nog sobion amu nog gotowanan nog kounutan poꞌ solabuk da og Kounutan niu nog ion non ion og Kristu. ");
INSERT INTO suc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Og motas sog glam niu sumboy mimung og sosuguꞌon niu. ");
INSERT INTO suc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Poꞌ simasima og mokpotas nog dili glawas non, pobobaꞌon da nog Mikpongon. Tibua, simasima og mokpobabaꞌ nog bolotabat non, potason sop ion nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kosusasusa amu, og polopanadanan nog botad nog bansa Hudyu bu og parasiuanan koyon, mokpopotongow amu tibua! Pinintuꞌ niu og bianan mangoy sog pigdotuꞌan nog Mikpongon. Ompok amu mampuꞌ dun bu opaꞌon niu pa og gotowanan koyon nog moleg bosia mampuꞌ dun.  ");
INSERT INTO suc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kosusasusa amu, og polopanadanan nog botad nog bansa Hudyu bu parasiuanan, mokpopotongow amu tibua! Og ginang niu moglimbung dia sog balulibunanan bagun niu malap og gakodanan nilan. Bu bila mogyakin amu, popoyaton niu tokodoy poꞌ baluꞌbaluꞌ molongas amu da nog gotow. Tibua, sog binayaꞌ nog gondow, ombogat tokodoy og polihalaꞌ nog Mikpongon dianiu. ");
INSERT INTO suc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kosusasusa amu, og polopanadanan nog botad nog bansa Hudyu bu parasiuanan, mokpopotongow amu tibua! Uliton niu og gliwag nog bonua bu tumolipag amu nog dagat monontong nog sala kotow siꞌoy nog moleg mokokunut dia sog pikpanad niu. Bila mokokunut na dianiu, imungon niu nog labi pa kolaton non dia sog kohinangan niu nog dituꞌ sigbuoy sog danow nog gapuy. ");
INSERT INTO suc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kosusasusa amu, nog amu og buta nog monuluꞌ dia sog gotowanan! Poꞌ long niu dun, bila og gotow moksapa dia sog Baloy nog Poktomuyan dia sog Mikpongon, mogusoy da nog diꞌ siꞌoy tumanon. Tibua, long niu dun, bila moksapa dia sog bulawan nog polongkapan nog Baloy nog Poktomuyan koyon, sumboy nododaꞌ tumanon non og sapa non koyon. ");
INSERT INTO suc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Buta amu dodaꞌ bu gumowon amu. Ain ma og bololagaꞌ? Og bulawan taꞌ otawaka og Baloy koyon nog Poktomuyan? Og Baloy nododaꞌ nog Poktomuyan poꞌ ain sog dialom non miimung og mosigda dun. ");
INSERT INTO suc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Bu long niu sop dun, bila og gotow moksapa dia sog pomolasan, mogusoy da nog diꞌ non siꞌoy tumanon. Tibua, long niu dun, bila moksapa dia sog binotang kituꞌ sog pomolasan, sumboy tumanon non nododaꞌ og sapa non koyon. ");
INSERT INTO suc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Og buta amu dodaꞌ! Ain ma og bololagaꞌ, og pimalas taꞌ otawaka og pomolasan taꞌ? Og pomolasan nododaꞌ poꞌ ain binotang sog pomolasan miimung mosigda dun. ");
INSERT INTO suc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dadi, bila sumapa og gotow dia sog pomolasan, misunuꞌ dosop ain og binotang dion. ");
INSERT INTO suc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Bu bila sumapa og gotow dia sog Baloy nog Poktomuyan dia sog Mikpongon, misunuꞌ dosop og Mikpongon nog ion migonong dion. ");
INSERT INTO suc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Bu bila sumapa og gotow dia sog glangit, misunuꞌ og gingkudan datuꞌ nog Mikpongon bu ion nog miningkud dion. ");
INSERT INTO suc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kosusasusa amu, og polopanadanan nog botad nog bansa Hudyu bu parasiuanan, mokpopotongow amu tibua! Migbogoy amu nog kosopuluꞌ bahagiꞌ nog palapalaanan niu dia sog Mikpongon, tibua, ondaꞌ niu unutoy og bololagaꞌ dia sog botad, bu pigbigyaꞌ niu og gotowanan, bu diꞌ amu mololat dianilan, bu diꞌ amu kopongondolan. Ininang niu bosia ituꞌ poguna, nog diꞌ niu dosop lotaꞌan og donsamaꞌ kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Amu og buta nog minuluꞌ dia sog gotowanan! Og gininang niu domikian da maꞌ nog minum amu nog ginumon bila poliguꞌan nog kamel, tibua, bila sagya da opunan nog glangow, diꞌ amu minum dun. ");
INSERT INTO suc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kosusasusa amu, og polopanadanan nog botad nog bansa Hudyu bu parasiuanan, mokpopotongow amu tibua! Bila mongugas amu nog saguk bu pinggan, lonuꞌan niu tibua og dibabow non, saka og dialom non kolomuꞌlomuꞌ da. Domikian da maꞌ nog dialom pikilan niu nog landuꞌ gabak bu lumobug amu sog dili glegan niu. ");
INSERT INTO suc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Amu parasiuanan, og buta amu dodaꞌ! Sumboy lonuꞌan niu pa poguna og dialom koyon. Poꞌ bila milonuꞌ na, og dibabow non siꞌoy molonuꞌ dosop. ");
INSERT INTO suc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kosusasusa amu, og polopanadanan nog botad nog bansa Hudyu bu og parasiuanan, mokpopotongow amu tibua! Mamaꞌ amu nog globonganan nog pinintaan nog putiꞌ. Molongas pogbontayan og dibabow non, tibua, sog dialom non miponuꞌ nog tulananan bu kolomuꞌlomuꞌ. ");
INSERT INTO suc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Domikian da maꞌ nion amu. Pogbontayan amu nog gotowanan mamaꞌ amu da nog midulus, tibua, sog dialom sagya amu da mokpopotongow bu landuꞌ amu tokodoy nog pokolaton nog gotow. ");
INSERT INTO suc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kosusasusa amu, og polopanadanan nog botad nog bansa Hudyu bu parasiuanan, mokpopotongow amu tibua! Poꞌ pingimungan niu nog gindanan og globonganan nog polomolatasanan nog taluꞌ nog Mikpongon, bu pingdoꞌitdoꞌitan niu og globonganan nog gotowanan kituꞌ nog midulus dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bu maꞌ long niu dun, ‘Somoꞌ totubuꞌ ami pa sog masa nilan kituꞌ kobon nituꞌ, ondiꞌ ami na dodaꞌ mampuꞌ dia sog mokogulanganan ta kituꞌ momunuꞌ nog polomolatasanan kituꞌ kobon nituꞌ.’” ");
INSERT INTO suc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bu long pa ni Isus dun, “Amu tanan og tinumaksiꞌ nog dili glawas niu nog amu og pangkat nog mimunuꞌ kituꞌ dia sog polomolatasanan nog taluꞌ nog Mikpongon kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dadi, doksuꞌ niu na og mokolaton kituꞌ nog kohinangan nog mokogulanganan niu kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Amu og mamakanan. Amu og tupuꞌanan nog mamak kituꞌ nog mokolala. Olo gidoy og pondayan niu bagun amu mokopolaguy sog polihalaꞌ kituꞌ dianiu sog danow nog gapuy? ");
INSERT INTO suc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dadi, saꞌan ituꞌ popongoyon ku dini niu og polomolatasanan nog taluꞌ nog Mikpongon, bu og gotowanan kituꞌ nog mokotalus, bu og polopanadanan nog motud. Tibua, og duma pomunuꞌon niu bu lonsangon niu sog kudus. Og duma sop pogbodason niu dia sog baloyanan nog poglumpukan niu, bu minsan ain ilan angoy nog bonuaanan losigon niu da ilan. ");
INSERT INTO suc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sabap dituꞌ, amu da kosakan nog duguꞌ nog glam nog pimunuꞌ nog gotowanan kituꞌ nog midulus dini sog glupaꞌan. Miktolipun sog kobunuꞌ dia ni Abel nog daꞌ salaꞌ non, asta sog kobunuꞌ kituꞌ dia ni Sakaraya, og bataꞌ kituꞌ ni Barakaya. Binunuꞌ niu dituꞌ sog Baloy nog Poktomuyan dia sog Mikpongon sog golot nog dugu kituꞌ nog mosigda bu sog pomolasan. ");
INSERT INTO suc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Toluꞌon ku dianiu, og gotowanan numun koni, ilan da og kodotongan nog glam non koni.” ");
INSERT INTO suc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Maꞌ long sop ni Isus dun, “O Jerusalem, Jerusalem, og gotowanan mu, pimunuꞌ nilan og polomolatasanan nog taluꞌ nog Mikpongon. Bu pimatu nilan ain og pipangoy non dion nika. Miobon u na bosia moleg lumumpuk nog gotowanan mu bagun ku ilan musibaꞌ, mamaꞌ nog dolukan nog dugbaꞌan non nog gokpak non og gititanan non. Tibua, ompok ilan dun. ");
INSERT INTO suc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tontong mu numun kituꞌ, og baloy mu tinolikudan na nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Toluꞌon ku dianika, nog ondiꞌ mu nododaꞌ akon motongow mokpuliꞌ asta matong gondow kituꞌ nog mokpoktaluꞌ og gotowanan mu nog, ‘Pipia ion nog minangoy dini bianan sog ngalan nog Mikpongon!’” ");
INSERT INTO suc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tubus nituꞌ, linumiu si Isus tidu sog Baloy koyon nog Poktomuyan dia sog Mikpongon. Sonuk non ompanow, mikpolani dianon og sulangguꞌanan non bu pigdolit nilan og Baloy nog Poktomuyan koyon bu og gimbolayan koyon sog glumibut non. ");
INSERT INTO suc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Dadi, miktaluꞌ si Isus dianilan nog, “Og pigdolit niu koyon, toluꞌon ku dianiu nog ngon gondow non nog minsan solabuk siꞌoy og polongkapan non koyon nog batu nog mitongow niu, daꞌidun nododaꞌ mosamaꞌ dun dia sog kibotangan non koyon poꞌ glam non koyon motipot pomoktugban.” ");
INSERT INTO suc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Dangan minatong ilan dituꞌ sog bulud nog Olibu, miningkud si Isus bu mikpolani dianon og sulangguꞌanan non nog ilanilan da, mangka ilan poksak dianon nog, “Kounutan, taluꞌ mu pa dianami bog nanu gidoy ion kotuman. Bu olo og gindanan dun og tang nog kopokpuliꞌ mu dini bu og gimpusan nog gondow?” ");
INSERT INTO suc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tinumabal si Isus nog, “Pokpotubud amu bagun amu ondiꞌ kolimbungan. ");
INSERT INTO suc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Poꞌ modakol og matong nog gomiton nilan og ngalan ku. Toluꞌon nilan nog ilan dow og Kristu. Bu modakol og kolimbungan dun. ");
INSERT INTO suc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bu bila mokodongog amu nog gonek nog mogbunuꞌ bu og dongogan nog mogbunuꞌ, naꞌ amu kiglaꞌan dun poꞌ og glam non koyon sumboy nododaꞌ ion mian. Tibua, konaꞌ pa ion og doksuꞌan. ");
INSERT INTO suc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Poꞌ og binonsaan mokpogbunuꞌ ilan bu ilan. Bu og pigdotuꞌan mantu dosop sog len pigdotuꞌan. Bu ngon dosop mian og gunus bu og glinug sog ainain nog bonua. ");
INSERT INTO suc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Og glam nini og tolipunan pa nog glogon nog ompononggiꞌ dia sog glibun nog pinokitan. ");
INSERT INTO suc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tubus nituꞌ, pongukpaꞌan amu mangka nilan amu pokposokitoy bu pomunuꞌoy. Bu pokongitan amu nog glam nog binonsaan sabap sog kopokokunut niu dianakon. ");
INSERT INTO suc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sabap dituꞌ, modakol og lumotaꞌ mongandol dianakon mangka ilan pokinongitoy nog ilan bu ilan nog boyaꞌan uokilon ilan sog glaꞌat nog ain minanta dianilan. ");
INSERT INTO suc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bu modakol mokponuaꞌ nog polomolatasanan nog diꞌ motud bu modakol nog gotowanan og moit nilan. ");
INSERT INTO suc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bu sabap sog kopogloknat nog kohinangan nog mokolaton, og kodokolan tumigdow na og glolat nilan. ");
INSERT INTO suc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tibua, simasima og mokogaga asta sog doksuꞌan, motabang ion. ");
INSERT INTO suc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bu og Gombaꞌis koni nog Guksugan paꞌali sog kopogdatuꞌ nog Mikpongon ompulonag na sog tibuk nog dunya bu kosunan na nog glam nog gotow og motud. Tubus nituꞌ, mangka na datong og bungkas.” ");
INSERT INTO suc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Long sop ni Isus, “Og polomolatas kituꞌ nog si Daniel, pidonsamaꞌ non tumaluꞌ kobon nituꞌ nog ngon motongow niu nog pindogon dia sog dugu nog mosigda og landuꞌ kolaton nog mimung moglomuꞌ dun og Baloy kituꞌ nog Poktomuyan dia sog Mikpongon. (Sumboy mosabut nog ain og mogbasta nini!) ");
INSERT INTO suc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bila, motongow niu na nog mituman na og tinaluꞌ ni Daniel kituꞌ, ain og gotowanan dini sog Judia koni, sumboy mokpolaguy ilan na sog kobukidan. ");
INSERT INTO suc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bu ain sop og gotowanan nog kotangan nog dia ilan sog glowasan nog baloy nilan, ondiꞌ ilan na mokotagad mogdangan monolimpan. ");
INSERT INTO suc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bu ain sop og gotowanan nog kotangan nog dituꞌ ilan sog binalan, ondiꞌ ilan na dosop mokotagad muliꞌ malap nog sulagbon nilan. ");
INSERT INTO suc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bu sog tang koyon, kololatlolat ain bodosanan bu ain og tigubataꞌ poꞌ ngon og kolumbeketan nilan. ");
INSERT INTO suc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pogyokinoy niu nog og kopolaguy niu ondiꞌ motang sog timpu dupiꞌ bu sog Gondow nog Pogulali. ");
INSERT INTO suc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Poꞌ sog tang koyon, landuꞌ na og sinsaan nog gotowanan. Daꞌ sibon kobianoy og maꞌ nion koyon nog sinsaan tidu pa sog tolipunan nog dunya. Bu og sinsaan koyon ondiꞌ kobotukan. ");
INSERT INTO suc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Somoꞌ ondaꞌ kulangoy nog Mikpongon og ginondowan nog sinsaan nilan koyon posunguꞌ, motipot nododaꞌ pomatoy og gotowanan. Tibua, saꞌan ituꞌ kulangan non poꞌ sabap sog pigotowan non. ");
INSERT INTO suc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Sog tang koyon, bila ngon moktaluꞌ dianiu nog, ‘Tontong niu, koni na og Kristu!’ otawaka, ‘Kituꞌ da ion!’ naꞌ amu tokodoy tumud dun. ");
INSERT INTO suc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Poꞌ modakol og mokponuaꞌ nog polomolatasanan nog diꞌ motud bu og gotowanan nog mogbaluꞌbaluꞌ nog ilan dow og Kristu. Bu poginangon nilan og gingyataꞌanan bu og kosobuꞌsobuꞌ bagun nilan moit og gotowanan, bu asta og pigotowan nog Mikpongon somoꞌ moit nilan da bosia. ");
INSERT INTO suc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dadi, pongmohilat amu poꞌ saꞌan ini pidonsamaꞌ u tumaluꞌ dianiu bagun amu mosimpan. ");
INSERT INTO suc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Dadi, bila ngon og moktaluꞌ dianiu nog, ‘Og Pipangoy kituꞌ nog Mikpongon Mogdatuꞌ, dituꞌ ion sog bonua kituꞌ nog daꞌidun migonong dun,’ naꞌ amu mangoy dituꞌ. Otawaka, ‘Dion ion mimintuꞌ sog dialom baloy,’ naꞌ amu tumud dun. ");
INSERT INTO suc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Poꞌ bila matong na og gondow nog pogdatong nog Binataꞌ sog Kilawan, ompononggiꞌ sog kilat nog gomonsunoy pa diadia pogbusiat tidu sog silangan mangoy sog sindopan. ");
INSERT INTO suc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Maꞌ long pa nog ponoluꞌon dun, ‘Ain og kibotangan nog bangkoy, dituꞌ dosop pogdopuꞌoy kuman nog guakanan.’” ");
INSERT INTO suc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Maꞌ long pa ni Isus, “Ampun modoksuꞌ og glogon koyon, mogdolom mogdayun og gondow, og bulan ondiꞌ na sumilow, og bitunanan sog glangit mokpogogdag, bu og glam nog dia sog glangit mokpoksop og botanganan nilan. ");
INSERT INTO suc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Sog tang koyon, motongow na sog glangit og gindanan nog Binataꞌ sog Kilawan. Bu og glam nog binonsaan sog glupaꞌan koni mokponglangos. Bu motongow nilan og Binataꞌ sog Kilawan posunguꞌ matong mogunut dia sog ginampol, bu dunut landuꞌ silow bu og kotas nog bayaꞌ non. ");
INSERT INTO suc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bu bianan sog koponombuliꞌ non nog mosikad, og moloikatanan non mangoy ilan lumimud og pigotowan nog Mikpongon sog pat pigyulu nog dunya.” ");
INSERT INTO suc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Maꞌ long pa ni Isus, “Maꞌ nini og manad niu dia sog kayu kituꞌ nog igera, bila lumoklag na bu pogbogudawon, kosunan niu nog daliꞌ na og timpu podos. ");
INSERT INTO suc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Domikian dosop nog bila motongow niu na og glam nog piktaluꞌ u koni mituman na, daliꞌ u na datong. ");
INSERT INTO suc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Poꞌ toluꞌon ku dianiu, mangka siꞌoy kotipot pomatoy og gotowanan numun koni, motuman na og glam nog piktaluꞌ u koni dianiu. ");
INSERT INTO suc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Og glangit bu glupaꞌan solianlian da, tibua, og taluꞌ u moksampoyumul nododaꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Maꞌ long pa ni Isus, “Daꞌidun og mokosun dun sala kotow siꞌoy og gondow otawaka og tang, minsan siꞌoy og moloikatanan sog glangit otawaka og Bataꞌ. Daꞌidun mokosun dun lual da og Gamaꞌ. ");
INSERT INTO suc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Dadi, bila daliꞌ na datong og Binataꞌ sog Kilawan, og glangkalangka nog gotowanan mamaꞌ dosop nog polomotadon nog gotowanan kituꞌ sog masa ni Nowa kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Poꞌ sog daꞌ pa datong og glayas nog masa ni Nowa, og poginangon nog gotowanan mikpoglokanlokan, mikpoginuminum, bu mimogduoy, asta sog gondow nog sinumolod si Nowa sog gagyung kituꞌ nog inimung non. ");
INSERT INTO suc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ondaꞌidun og sinisini nilan dun nog ngon posunguꞌ matong, asta minatong sog gondow kituꞌ nog miglayas, bu mitipot ilan kolomos. Domikian dosop maꞌ nituꞌ og kobianbianan nog gotowanan bila matong na og Binataꞌ sog Kilawan. ");
INSERT INTO suc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sog tang koyon, duaꞌ kotow glaki dituꞌ sog binalan, og sala kotow oiton, bu og sala kotow sop ombagak. ");
INSERT INTO suc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bu duaꞌ kotow glibun solian nilan gumiling, og sala kotow oiton, bu og sala kotow sop ombagak. ");
INSERT INTO suc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Dadi, saꞌan sumboy kobon non pongmohilat amu poꞌ ondiꞌ niu kosunan bog olo ondowoy dun og pogdatong nog Kounutan niu. ");
INSERT INTO suc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sabut niu og poktoluꞌon ku koni. Ibalat da sog gapuꞌ nog baloy nog pinokowan, somoꞌ kisunan non bosia bog andun kodalom nog gobi og pogdatong nog polonakow kituꞌ, oyanan non nododaꞌ bagun da ondiꞌ ion mokosolod. ");
INSERT INTO suc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Domikian da maꞌ nituꞌ, nog sumboy moksimpan amu kobon non, poꞌ og Binataꞌ sog Kilawan matong sog tang nog daꞌ niu dodomaoy.” ");
INSERT INTO suc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Maꞌ long sop ni Isus dun, “Og sosoligan kituꞌ nog kosoligan bu moto momikil, ion og ginuokilan kituꞌ nog kounutan non nog bayaꞌ mogokbit bu mogusibaꞌ dia sog pakasi sosoligan non sog tang nog ngon kobalan nilan dun. ");
INSERT INTO suc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kuntungan og sosoligan kituꞌ, nog kidotongan nog kounutan non sonuk non moginang nog dinondag kituꞌ moginang dianon. ");
INSERT INTO suc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Toluꞌon ku dianiu, og sosoligan koyon, uokilan nododaꞌ ion nog bayaꞌ mogokbit sog glam nog gakod nog kounutan non koyon. ");
INSERT INTO suc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tibua, bila mamaꞌ nog sosoligan kituꞌ nog molaton, nog moktaluꞌ sog dialom pikilan non nog, ‘E! Mobon pa datong og kounutan ku,’ ");
INSERT INTO suc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","bu mangka non tolipunoy mogdanog og pakasi sosoligananan non koyon, mangka ion poglokanlokan, bu dumuma moginuminum sog polonginumanan. ");
INSERT INTO suc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kotokowan ion nog matong og kounutan non koyon sog gondow nog daꞌ non bibolaꞌoy bu sog tang nog daꞌ non dodomaoy. ");
INSERT INTO suc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Og sosoligan koyon pogoktadon dodaꞌ ion nog kounutan non koyon mangka non ion pompuꞌoy mosinsa sog gotowanan kituꞌ nog mokpopotongow tibua. Bu dituꞌ ilan poglulad bu mongolongot og ngisianan nilan.” ");
INSERT INTO suc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Maꞌ long pa ni Isus, “Sog gondow nog mokpuliꞌ og Binataꞌ sog Kilawan dini sog glupaꞌan, og kopogdatuꞌ nog Mikpongon mamaꞌ nog kibianbianan nog sopuluꞌ kodologaanan. Og kodologaanan koyon, og monala kotow dianilan, mikpogoit ilan nog politaꞌan nilan lumumpak nog pongantim. ");
INSERT INTO suc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Og lima kotow dianilan gumowon bu og lima kotow sop moto momikil. ");
INSERT INTO suc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Og gumowon kituꞌ, mikpitang ilan siꞌoy nog politaꞌan, daꞌ ilan poksimpan nog dungag nog gas nilan. ");
INSERT INTO suc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tibua, og duma nog lima kotow kituꞌ, miksimpan ilan nog dungag nog gas nilan dia sog politaꞌan nilan. ");
INSERT INTO suc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Miobon tokodoy og pongantim kituꞌ. Dadi, sintak nilan mogbagad dun, tulugon ilan tokodoy boyaꞌan nog mikotulug ilan. ");
INSERT INTO suc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Dangan midopot tongaꞌ gobi, ngon og gekes nog, ‘Koni na og pongantim kituꞌ! Angoy niu na ion lumpak!’ ");
INSERT INTO suc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dadi, mikpoktanud og glam nog kodologaanan kituꞌ mangka nilan sugioy og politaꞌan nilan. ");
INSERT INTO suc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Miktaluꞌ og lima kotow kituꞌ nog gumowon sog mokokoto kituꞌ momikil, ‘Bogayan ami pole nog gas niu koyon mikaꞌan siꞌoy poꞌ daliꞌ na kopalong og politaꞌan nami koni.’ ");
INSERT INTO suc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tinumabal og lima kotow koyon, ‘Ondiꞌ amu na le kotulan dun poꞌ lomonlomon da dianami. Sugaꞌid non, angoy amu saluy dia sog ain og togo gas.’ ");
INSERT INTO suc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Dadi, minangoy og lima kotow koyon sumaluy nog gas nilan. Likud nilan koyon ompanow, minatong og pongantim kituꞌ. Og lima kotow kituꞌ nog misimpan, migunut ilan na dituꞌ sog poglokoingan kituꞌ. Dangan mikosolod ilan tibua, pinintuꞌ sop og bongawan kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ondaꞌ kobon golot non, minatong dosop og lima kotow kituꞌ. Bu mikibukaꞌ ilan bosia, ‘Kounutan! Kounutan! Bukaꞌoy niu pa ami suꞌusa!’ ");
INSERT INTO suc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tibua, tinabal non ilan nog, ‘Toluꞌon ku dianiu, ondiꞌ u amu kilolaan.’” ");
INSERT INTO suc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Dadi, long ni Isus dun, “Pongmohilat amu poꞌ ondiꞌ niu kosunan bog olo ondowoy dun otawaka tangoy dun nog pokpuliꞌ u dini.” ");
INSERT INTO suc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Maꞌ long pa ni Isus, “Sog gondow nog mokpuliꞌ og Binataꞌ sog Kilawan dini sog glupaꞌan, og kopogdatuꞌ nog Mikpongon mamaꞌ dosop nog gotow kituꞌ nog minangoy sog molayuꞌ nog bonua. Tibua, mangka siꞌoy ion gonat, pilimud non poguna og sosoligananan non mangka non pomilinoy dianilan og golotaꞌanan non. ");
INSERT INTO suc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Binogayan non og monala kotow dianilan ain og goktob nog ombaꞌug nilan. Og sala kotow binogayan non nog lima ngibu og pilak. Og sala kotow sop binogayan non nog duaꞌ ngibu. Bu og sala kotow sop binogayan non nog songibu, mangka na ion gonat. ");
INSERT INTO suc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Og sosoligan kituꞌ nog binogayan nog lima ngibu, piglitu non mogdayun og sin kituꞌ. Dadi, mikuntung ion dun lagaꞌ nog lima ngibu pilak. ");
INSERT INTO suc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Maꞌ dosop nituꞌ og sosoligan kituꞌ nog binogayan nog duaꞌ ngibu, bu mikuntung dosop ion dun lagaꞌ nog duaꞌ ngibu pilak. ");
INSERT INTO suc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tibua, og gotow kituꞌ nog binogayan nog songibu, inangoy non lobutoy dia sog glupaꞌ og sin nog kounutan non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Dangan miobon ion, minuliꞌ og kounutan nilan kituꞌ mangka non polimudoy og sosoligananan non poꞌ mogbahagiꞌ ilan. ");
INSERT INTO suc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Og sosoligan kituꞌ nog binogayan non nog lima ngibu, pinitang non sog kounutan non koyon og guntung non kituꞌ mangka poktaluꞌ nog, ‘Kounutan, inuakil mu dianakon og lima ngibu. Tontong mu ini! Mikuntung u pa dun lagaꞌ nog lima ngibu sop og dakol non.’ ");
INSERT INTO suc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Dadi, tinoluꞌan ion nog kounutan non koyon nog, ‘Ombaꞌis a dodaꞌ nog sosoligan, kosoligan ka tokodoy. Kosoligan ka ma sog mikaꞌan, dadi, uokilan ku sop ika mogokbit nog modakol. Angoy a na dini bu duma a mogdaꞌdaꞌ sog kounutan mu koni!’ ");
INSERT INTO suc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tubus nituꞌ, og sosoligan kituꞌ nog binogayan non nog duaꞌ ngibu, mikpolani dosop dianon mangka poktaluꞌ nog, ‘Kounutan, inuakil mu dianakon og duaꞌ ngibu. Tontong mu ini! Mikuntung u pa dun lagaꞌ nog duaꞌ ngibu sop og dakol non.’ ");
INSERT INTO suc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Dadi, tinoluꞌan ion nog kounutan non koyon nog, ‘Ombaꞌis a dodaꞌ nog sosoligan, kosoligan ka tokodoy. Kosoligan ka ma sog mikaꞌan, dadi, uokilan ku sop ika mogokbit nog modakol. Angoy a na dini bu duma a mogdaꞌdaꞌ sog kounutan mu koni!’ ");
INSERT INTO suc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tibua, og sosoligan kituꞌ nog binogayan nog songibu mikpolani dosop dianon mangka poktaluꞌ nog, ‘Kounutan, kosunan ku nog ika lenlen ka nog gotow. Olapon mu minsan konaꞌ nika og misinsa dun. Poꞌ gumani a nog konaꞌ nika og mimula dun. ");
INSERT INTO suc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Miondok u dianika. Dadi, linobut u sog glupaꞌ og binogoy mu kituꞌ dianakon nog sin. Koni da og sin mu kituꞌ.’ ");
INSERT INTO suc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tinumabal og kounutan non koyon nog, ‘Molaton ka dodaꞌ nog gotow bu mololaꞌ a nog sosoligan. Bila maꞌ nituꞌ og pikilan mu nog akon mongalap u minsan konaꞌ u moginang dun bu gumani u nog konaꞌ u mimula dun, ");
INSERT INTO suc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","iduma ondaꞌ nika ma buan toguꞌoy sog bangku og sin ku koyon bagun mogbataꞌ? Bu bila mokpuliꞌ u na, motabuk u ituꞌ bosia asta og bataꞌ non?’ ");
INSERT INTO suc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mangka poktaluꞌ og kounutan koyon dia sog duma sosoligananan koyon nog, ‘Alap niu og sin koyon dianon mangka niu bogoy dia sog sosoligan kituꞌ nog sopuluꞌ ngibu og sin non. ");
INSERT INTO suc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Poꞌ ain ngon na dianon, dungagan pa bagun ion kongonan. Tibua, ain daꞌidun dianon, minsan og dakoldakol non na, owaꞌon pa dianon. ");
INSERT INTO suc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Og sosoligan koni nog daꞌ sagnat non tikpuꞌ niu na sog glowasan, dituꞌ sog kodoloman. Bu dituꞌ ion poglulad bu pongolongot og ngisianan non.’” ");
INSERT INTO suc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Maꞌ long pa ni Isus dun, “Bila mokpuliꞌ na dini og Binataꞌ sog Kilawan, dunut kosilow nog bayaꞌ non, bu glam nog moloikatanan mogunut dianon, mingkud na ion dia sog gingkudan datuꞌ bu sumilow og kotas non. ");
INSERT INTO suc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Og glam nog binonsaan polimudon dianon mangka non ilan bohogiꞌoy duaꞌ bahagiꞌ mamaꞌ nog polongipat nog bilibilianan nog siboyon non og bilibilianan dia sog kambinganan. ");
INSERT INTO suc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Og Datuꞌ kituꞌ, siboyon non ain og midulus, bu dia non podopitoy sog glintu non. Bu ain sop og daꞌ kodulus, dia non podopitoy sog bibang non. ");
INSERT INTO suc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tubus nituꞌ, moktaluꞌ og Datuꞌ koyon dia sog gotowanan nog dia dapit sog glintu non nog, ‘Angoy amu na dini, amu og pipia nog Gamaꞌ u. Tabuk niu na og pusakaꞌ niu nog ion non og pigdotuꞌan nog Mikpongon nog sinimpan kituꞌ dianiu tidu pa sog tolipunan nog kopokpongon nog dunya. ");
INSERT INTO suc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Poꞌ kobon nog mogutom u, piokan niu akon. Kobon nog kinuow u, piinum niu akon. Ondaꞌ niu siꞌoy akon kilolaoy, tinolimaꞌ niu da akon sog baloyanan niu. ");
INSERT INTO suc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Dangan kiondaꞌan u nog ponopoton, piponopotan niu akon. Kobon nog ondiꞌ u mokodag, inusibaꞌ niu akon. Bu kobon nog mikolobusu u, binontow niu akon.’ ");
INSERT INTO suc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Tubus nituꞌ, og gotowanan nog midulus, tumabal ilan nog, ‘Kounutan, nanu nami ika mitongow nog kigutoman ka nog piokan nami ika? Otawaka, kinuow a nog piinum nami ika? ");
INSERT INTO suc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nanu nami sop ika tinolimaꞌ nog saka daꞌ nami ika kilolaoy? Otawaka, nanu a kiondaꞌan nog ponopoton nog piponopotan nami ika? ");
INSERT INTO suc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Bu nanu nami ika binontow nog ondiꞌ a mokodag otawaka mikolobusu a?’ ");
INSERT INTO suc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tobalon ilan nog Datuꞌ koyon nog maꞌ nini, ‘Toluꞌon ku dianiu, nog minsan olo og miinang niu dia sog pigilugananan ku nog ombabaꞌ ilan nog gotow, og ginang niu koyon dia niu nakon ininang.’ ");
INSERT INTO suc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Tubus nituꞌ, moktaluꞌ ion dia sog gotowanan nog dia dapit sog bibang non nog, ‘Awaꞌ amu dini nakon, amu koyon pinolihalaꞌ amu na nog Mikpongon. Dituꞌ amu angoy sog danow nog gapuy kituꞌ nog diꞌ ompalong nog sinimpan dia ni Kindagow bu glam nog glaꞌayatanan non nog moloikatanan. ");
INSERT INTO suc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Poꞌ kobon nog migutom u, daꞌ niu akon pokanoy. Kinuow u, tibua, ondaꞌ niu akon pinumoy. ");
INSERT INTO suc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Dangan pa daꞌ niu akon kilolaoy, daꞌ niu tanan akon tolimaꞌoy sog baloyanan niu. Ondaꞌidun og ponopoton ku, tibua, ondaꞌ niu tanan akon poponopotoy. Kobon nog ondiꞌ u mokodag bu mikolobusu u, ondaꞌ niu tanan akon usibaꞌoy.’ ");
INSERT INTO suc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Tubus nituꞌ, tumabal ilan dianon nog, ‘Kounutan, nanu nami ika mitongow nog migutom a, otawaka kinuow a, otawaka daꞌ nami ika kilolaoy, otawaka daꞌidun ponopoton mu, otawaka ondiꞌ a mokodag, otawaka mikolobusu a, nog daꞌ nami ika tobangoy?’ ");
INSERT INTO suc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Tobalon non ilan nog, ‘Toluꞌon ku dianiu, nog og daꞌ niu inangoy nog molongas dianilan nog ombabaꞌ ilan nog gotow, ondaꞌ niu dosop ituꞌ inangoy dianakon.’ ");
INSERT INTO suc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Tubus nituꞌ, og gotowanan koyon, dituꞌ ilan popongoyoy sog posakit kituꞌ nog daꞌidun kopus non. Tibua, og gotowanan kituꞌ nog midulus, dituꞌ ilan popongoyoy sog kotubuꞌ nog daꞌ kopus non.” ");
INSERT INTO suc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Dangan linuksad na ni Isus og glam nog pikpanad non koyon, miktaluꞌ ion dia sog sulangguꞌanan non nog, ");
INSERT INTO suc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kisunan niu nog duaꞌ ondow dona moktolipun na og kologyaꞌan kituꞌ nog Liniusan. Bu matong kologyaꞌan koyon, og Binataꞌ sog Kilawan uokilon dia sog gukum. Og gukuman dianon kuduson asta matoy.” ");
INSERT INTO suc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sog tang nog kopoktaluꞌ ni Isus koyon dun, og mokokotas nog boliananan, bu og kobogolalan nog bansa Hudyu, miglumpuk ilan dituꞌ sog baloy mosolag nog kounutan nog boliananan nog si Kaypas. ");
INSERT INTO suc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Pigisunisunan nilan bog olo bianan nilan mukpaꞌ dia ni Isus nog mondom daꞌidun og mokosun dun mangka nilan siꞌoy ion bunuꞌoy. ");
INSERT INTO suc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tibua, long nilan dun, “Sumboy diꞌ ta ion ukpaꞌan nog motang sog gondow nog kologyaꞌan koyon nog Liniusan poꞌ gomonsunoy mokpogulek og gotowanan dun.” ");
INSERT INTO suc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kobon ni Isus sog Betani, dituꞌ sog baloy ni Simun nog bakas gipulon, ");
INSERT INTO suc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","sonuk nilan mogadap kuman, ngon sala kotow glibun nog mikpolani dianon. Migoit ion nog glana momut nog landuꞌ kologan. Og pogomut koyon, tinaguꞌ non dia sog glolonan nog inimung tidu sog batu putiꞌ. Sokaliꞌ non tinuyung og pogomut koyon, dia sog glimpulu ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Dangan mitongow ituꞌ nog sulangguꞌanan ni Isus, piglolingitan nilan og glibun koyon bu ininggulaꞌan nilan og pogomut kituꞌ. Mikpokundomundom ilan nog, “Pigostaan non og pogomut koyon! ");
INSERT INTO suc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Somoꞌ bosia ion piksaluy, modakol nododaꞌ nog sin og ombogoy dia sog miskinananan.” ");
INSERT INTO suc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kisunan ni Isus og pikumodumod nilan koyon. Dadi, miktaluꞌ ion nog, “Balan niu moksasow dia sog glibun koni. Og gininang non koni dianakon molongas tokodoy. ");
INSERT INTO suc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Amu, kobon non mokunul amu da nog miskinan. Tibua akon, ondiꞌ ita niu kobon non mokunul. ");
INSERT INTO suc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Saꞌan ini maꞌ nini og ininang non dianakon poꞌ og kopoksimpan non nog glawas u bila lobongon u na. ");
INSERT INTO suc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Dadi, toluꞌon ku dianiu, minsan ain ustaloy og Gombaꞌis nog Guksugan sog gliwag nog dunya koni, og gininang nog glibun koni dianakon mosuksug dosop poꞌ og pomondoman dianon.” ");
INSERT INTO suc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tubus nituꞌ, sala kotow sog sopuluꞌ bu duaꞌ sulangguꞌanan non kituꞌ nog si Judas Iskariot, minangoy dituꞌ sog mokokotas nog boliananan ");
INSERT INTO suc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","mangka ion poksak dituꞌ nog, “Andun ma og bogoyon niu dianakon, bila muakil u dianiu si Isus?” Dadi, binogayan nilan ion nog tolu puluꞌ lad og solapiꞌ. ");
INSERT INTO suc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tidu dion, minamal si Judas monontong nog pondayan non bagun non muakil si Isus dianilan. ");
INSERT INTO suc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dangan minatong og tiganaꞌ ondow nog kologyaꞌan kituꞌ nog iningolanan nog Pan Nog Daꞌ Potulinoy, mikpolani og sulangguꞌanan ni Isus dianon mangka ilan poksak nog, “Kounutan, ain ka koleg simpanoy nog globungan mu nog Liniusan?” ");
INSERT INTO suc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tinumabal si Isus nog, “Angoy amu sog koliwagan bonua koyon, dituꞌ sog baloy nog sala kotow kituꞌ. Bu taluꞌ niu dianon nog, ‘Og Polopanad miktaluꞌ nog, daliꞌ na datong og sosaꞌ kituꞌ dianon bu moleg ion moglobungan nog Liniusan dunut og sulangguꞌanan non dini sog baloy mu.’” ");
INSERT INTO suc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dadi, ininang nilan maꞌ nog tinaluꞌ ni Isus kituꞌ dianilan. Dadi, pigasip nilan dion og globungan koyon nog iningolanan og Liniusan. ");
INSERT INTO suc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dangan miglogobi na, migadap si Isus bu og sopuluꞌ bu duaꞌ sulangguꞌanan non koyon kuman. ");
INSERT INTO suc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sonuk nilan koyon kuman, miktaluꞌ ion nog, “Toluꞌon ku dianiu, og sala kotow dianiu mongulaꞌat dianakon.” ");
INSERT INTO suc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dadi, miglaꞌat og dialom pikilan nilan dun bu monala kotow dianilan mikpoksak nog, “Kounutan, konaꞌ u taꞌ gidoy ion?” ");
INSERT INTO suc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tinumabal si Isus nog, “Og posunguꞌ kituꞌ mongulaꞌat dianakon, ion non og minabang kituꞌ kuman dia sog ponaksan ku. ");
INSERT INTO suc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Poꞌ og Binataꞌ sog Kilawan, og bianan non matoy mamaꞌ nog sinulat kituꞌ dia sog Kitab paꞌali dianon. Tibua, kondokondok tokodoy og doksuꞌan nog gotow koyon nog mongulaꞌat dianon. Golom pa bosia somoꞌ daꞌ na ion botaꞌoy.” ");
INSERT INTO suc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tubus nituꞌ, si Judas og moksipi kituꞌ mongulaꞌat dianon, miksak nog, “Polopanad, konaꞌ u taꞌ gidoy ion?” Tinabal ion ni Isus nog, “Ika, og pigolong u koni.” ");
INSERT INTO suc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sog sonuk nilan kuman, minalap si Isus nog pan mangka non posolomatoy sog Mikpongon, mangka non pomitakoy mangka non pomogoyoy sog sulangguꞌanan non kobon non moktaluꞌ nog, “Tabuk niu ini mangka niu kan poꞌ ion non ini og glawas u.” ");
INSERT INTO suc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tubus nituꞌ, inimud non og saguk koyon dion bu posolomatoy sog Mikpongon mangka non tulunoy sog sulangguꞌanan non kobon non moktaluꞌ nog, “Inum amu nini glam niu. ");
INSERT INTO suc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Poꞌ ion non ini og duguꞌ u nog moglayas bagun kompunan og dusaanan nog modakol nog gotowanan. Ion non ini og pagon nog bogu pasad nog Mikpongon sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Toluꞌon ku dianiu, nog ondiꞌ u na minum nini mokpuliꞌ asta mogadap ita mokpuliꞌ sog pigdotuꞌan nog Gamaꞌ u nog ion og Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tubus nituꞌ, mikpoksanglit ilan sog Mikpongon bianan sog bobat mangka ilan na angoy dituꞌ sog bulud nog Olibu. ");
INSERT INTO suc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sonuk nilan koyon ompanow posunguꞌ dituꞌ, miktaluꞌ si Isus dianilan nog, “Gobi koni og glam niu koyon, bolongon niu akon. Poꞌ sinulat sog Kitab nog, ‘Bunuꞌon ku og polongipat nog bilibili bu mokpokpolaꞌ og bilibilianan non.’ ");
INSERT INTO suc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tibua, bila motubuꞌ u na tidu matoy, moguna u dianiu dituꞌ sog Galili.” ");
INSERT INTO suc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tubus nituꞌ, miktaluꞌ si Piter dianon nog, “Kounutan, minsan glam nilan koyon molong dianika, akon, ondiꞌ u dodaꞌ ika bolongon!” ");
INSERT INTO suc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tinabal ion ni Isus nog, “Toluꞌon ku dianika, bombus, mangka siꞌoy poktukalaꞌ og manuk, tolu kali mu na akon sonsingoy sog gotowanan nog diꞌ mu akon kilolaan.” ");
INSERT INTO suc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tibua, tinumabal si Piter nog, “Kounutan, minsan siꞌoy sunuꞌon u munuꞌ dianika, ondiꞌ u nododaꞌ ika sonsingan!” Mamaꞌ dosop nituꞌ og tinaluꞌ nog duma sulangguꞌanan non. ");
INSERT INTO suc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tubus nituꞌ, minangoy si Isus bu og sulangguꞌanan non dituꞌ sog koyuan kituꞌ nog iningolanan og Getsemani. Miktaluꞌ ion dianilan nog, “Pogbagad amu pa dini poꞌ mangoy u pa dion sog gunanunan koyon mogyakin.” ");
INSERT INTO suc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Inoit non si Piter bu og duaꞌ kotow gombataꞌ ni Sebedi. Bu mibatik non na nog landuꞌ og susaan non bu ombogat og pikilan non. ");
INSERT INTO suc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dadi, miktaluꞌ ion dianilan nog, “Landuꞌ u na kobogatoy nog susaan ku nog boyaꞌan agonagon u na matoy dun. Pogbagad amu pa dini bu duma amu dianakon mogonduk mogyakin.” ");
INSERT INTO suc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tubus nituꞌ, minangoy ion sog gunanunan kolongod mangka ion lob mogyakin. Long non dun, “Amaꞌ, somoꞌ bosia mogusoy dianika, awaꞌ mu pa dianakon og posunguꞌ u koni poglogogaon nog sinsaan. Tibua, sumboy konaꞌ og glegan ku og kunutan, sugaꞌid non, og glegan mu.” ");
INSERT INTO suc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tubus nituꞌ, mikpuliꞌ ion dituꞌ sog tolu kotow sulangguꞌanan non koyon. Mitongow non ilan nog mikponulug ilan. Miktaluꞌ ion dia ni Piter nog, “Iduma ion ondiꞌ amu mokogaga dumuma mogonduk minsan sa oras siꞌoy? ");
INSERT INTO suc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pogonduk amu mogyakin bagun amu ondiꞌ koyubaꞌan. Moleg da bosia og pikilan niu, tibua, og glawas niu ondiꞌ mokogaga.” ");
INSERT INTO suc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tubus nituꞌ, mikpuliꞌ nosop si Isus mogyakin. Long non dun, “Amaꞌ, bila diꞌ mogusoy nog owaꞌon dianakon og sinsaan ku koni nog posunguꞌ u poglogogaon bog diꞌ u da kobianan, pobian mu na dianakon. Poꞌ sumboy og glegan mu og motuman, konaꞌ og glegan ku.” ");
INSERT INTO suc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tubus nituꞌ, mikpuliꞌ nosop ion dituꞌ sog sulangguꞌanan non bu kidotongan non nosop ilan nog mikponulug ilan poꞌ ondiꞌ nilan nododaꞌ kotigolan og tulug nilan. ");
INSERT INTO suc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dadi, mikpuliꞌ ion dituꞌ mogyakin nog maꞌ nog gyakin non sog koduaꞌ kali non kituꞌ mogyakin. ");
INSERT INTO suc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tubus nituꞌ, mikpuliꞌ nosop ion dituꞌ sog sulangguꞌanan non mangka ion poktaluꞌ nog, “Abu! Mikpogbobolilid amu poma dion motulug? Daliꞌ na datong og tang nog uokilon na og Binataꞌ sog Kilawan dia sog gongkoman nog gotowanan kituꞌ nog bolodusaon. ");
INSERT INTO suc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Dadi, pogbuat amu na poꞌ koni na og gotow kituꞌ nog moguakil dianakon dia sog glaꞌat. Alung na.” ");
INSERT INTO suc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sonuk pa ni Isus moktaluꞌ, minatong na si Judas, og duma nog sopuluꞌ bu duaꞌ og sulangguꞌanan non kituꞌ. Modakol nog gotowanan og dunutanan non nog migatul ilan nog kalisanan bu bobombalanan nilan. Pipangoy ilan nog mokokotas nog boliananan bu kobogolalan nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Og polonipu koyon nog si Judas bu og gotowanan koyon, ngon og koposadan nilan nog bagun nilan kilolaan si Isus. Long non dun, “Og gotow nog olokan ku, ion non ion og ponontongon niu kituꞌ. Dadi, ukpaꞌoy niu na ion.” ");
INSERT INTO suc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Dadi, mikpolani si Judas dia ni Isus mangka ion poktaluꞌ nog, “Polopanad, molongas gobi,” mangka non olokoy si Isus. ");
INSERT INTO suc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tinumabal si Isus nog, “Inang mu na le mogdayun og gangoy mu koyon dini.” Dadi, mikpolani og gotowanan mangka nilan si Isus ukpaꞌoy. ");
INSERT INTO suc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sala kotow og duma ni Isus, sinintak non og kalis non mangka non tigbasoy og kisonggulan nog kounutan nog boliananan koyon boyaꞌan nog misikpoy tanan og tolinga non. ");
INSERT INTO suc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Dadi, miktaluꞌ si Isus dia sog duma non koyon nog, “Umaꞌ mu og kalis mu koyon poꞌ ain sumintak nog kalis non, kalis dosop og bianan non matoy. ");
INSERT INTO suc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Baluꞌ mu dun, bila mokitabang u dia sog Gamaꞌ u, sododuꞌun popongoyon non dini og glinoksaꞌan nog moloikatanan? ");
INSERT INTO suc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tibua, bila ini mokitabang u, olo ma og kotuman nog pidonsamaꞌ kituꞌ tumaluꞌ nog Mikpongon dia sog Kitab nog sumboy nododaꞌ maꞌ nini og kobianbianan ku?” ");
INSERT INTO suc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tubus nituꞌ, miktaluꞌ si Isus sog gotowanan koyon dion nog, “Og polonglaꞌug u taꞌ nog bila ongoyon niu akon ukpaꞌoy mokpogoit amu poma nog kalisanan bu bobombalanan? Saka gondow gondow motongow niu akon mokpanad sog glomalomaan nog Baloy nog Poktomuyan dia sog Mikpongon. Saka ondaꞌ niu poma akon ukpaꞌoy dituꞌ? ");
INSERT INTO suc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Saꞌan miinang og glam non koni poꞌ og kotumanan nog sinulat nog polomolatasanan nog taluꞌ nog Mikpongon kobon nituꞌ.” Tubus nituꞌ, binolong ion nog glam nog sulangguꞌanan non koyon poꞌ mikpokpolaguy ilan. ");
INSERT INTO suc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tubus nituꞌ, inoit ion nog gotowanan kituꞌ nog minukpaꞌ dianon dituꞌ sog baloy ni Kaypas, og kounutan nog boliananan. Dituꞌ miglumpuk og polopanadanan nog botad bu og kobogolalan. ");
INSERT INTO suc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tibua, si Piter, piguyukuyukan non si Isus asta sog glomalomaan nog kounutan nog boliananan koyon. Sinumolod ion mangka ampuꞌ mingkud dia sog polongipatanan koyon dion poꞌ bagun non kosunan bog olo og gondunon nilan dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Og mokokotas nog boliananan bu og glam nog polongukumanan nog bansa Hudyu nog miglumpuk koyon dion, minontong ilan nog taksiꞌ nilan minsan siꞌoy diꞌ motud bagun nilan ombunuꞌ si Isus. ");
INSERT INTO suc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tibua, modakol siꞌoy tinumaksiꞌ dianon, ondaꞌ da ion komotudoy dun. Poꞌ diꞌ motud og koponaksiꞌ nilan koyon. Tubus nituꞌ, ngon duaꞌ kotow nog minindog mangka poktaluꞌ nog, ");
INSERT INTO suc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Midongog nami og gotow koni miktaluꞌ nog mogobaꞌ non dow og Baloy nog Poktomuyan dia sog Mikpongon bu ompindog non dow mokpuliꞌ sog solod nog tolu ondow.” ");
INSERT INTO suc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dangan midongog ituꞌ nog kounutan nog boliananan, minindog ion mangka poksak dia ni Isus nog, “Olo ma og tabal mu dun og sumbunganan nilan koyon dianika?” ");
INSERT INTO suc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tibua, si Isus ondaꞌ pogonekonek. Dadi, miktaluꞌ nosop og kounutan nog boliananan koyon nog, “Bianan sog ngalan nog Diwata nog daꞌ kopus non, taluꞌ mu dianami bog ika taꞌ og Kristu, nog Bataꞌ nog Mikpongon?” ");
INSERT INTO suc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tinumabal si Isus nog, “Mamaꞌ nog tinaluꞌ mu koyon. Tibua, toluꞌon ku dia sog glam niu. Sog gunanunan koyon, motongow niu da og Binataꞌ sog Kilawan pogingkud dia dapit sog glintu nog Pogbayaꞌ nog diꞌ kobotukan bu posunguꞌ ion matong nog dia sog ginampol sog glangit.” ");
INSERT INTO suc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Puꞌun midongog nog kounutan nog boliananan koyon, linolingitan ion dun. Dadi, binogyang non og ponopoton non mangka ion poktaluꞌ nog, “Og gotow koni piglokaꞌlokaꞌan non og Mikpongon. Daꞌidun na balan ta nog taksiꞌ poꞌ midongog niu na nog piglokaꞌlokaꞌan non og Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Dadi, olo ma og koposadan niu dun?” Tinumabal ilan nog, “Og gotow koyon patut nododaꞌ ion bunuꞌon.” ");
INSERT INTO suc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tubus nituꞌ, pigdulaꞌan nilan og bayuꞌbayuꞌ non mangka nilan poksuntukoy bu og dumaanan pigdapiꞌ nilan ion ");
INSERT INTO suc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kobon nilan mogwanwan dun nog, “Bila motud nog ika og Kristu, atuk mu dow buan bog sima og sinumuntuk koyon dianika.” ");
INSERT INTO suc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Si Piter, dituꞌ ion pogingkud sog glomalomaan. Sintak non mogingkudingkud dion, ngon og glibun og sosoligan nog mikpolani dianon bu poktaluꞌ nog, “Ika siꞌoy, og duma a dosop ni Isus nog gotow Galili.” ");
INSERT INTO suc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tibua, minonsing si Piter dion sog kodokolan nog gotowanan. Long non dun, “Diꞌ u sunan bog olo og poktoluꞌon mu koyon.” ");
INSERT INTO suc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tubus nituꞌ, minangoy ion sog bongawan nog glomalomaan kituꞌ bu ngon nosop og len glibun og mikotongow dianon nog miktaluꞌ sog gotowanan koyon dion nog, “Og gotow koni, ion non ini og duma kituꞌ ni Isus nog gotow Nasaret.” ");
INSERT INTO suc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Minonsing nosop si Piter dunut sinumapa nog, “Ondiꞌ u dodaꞌ kilolaan og gotow koyon.” ");
INSERT INTO suc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Daꞌ kobon golot non, og gotowanan koyon nog mipogindog dion, mikpolani dia ni Piter mangka poktaluꞌ nog, “Daꞌidun duaꞌduaꞌ non, ika siꞌoy og duma a dosop nog gotowanan koyon poꞌ kilolaan nami ika bianan sog kopoktaluꞌtaluꞌ mu.” ");
INSERT INTO suc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tubus nituꞌ, miksumpasumpa tanan si Piter dun nog, “Bila diꞌ motud og piktaluꞌ u koni, ngon matong dun sog kotubuꞌ u. Ondiꞌ u kilolaan og gotow koyon!” Puꞌun miluksad og taluꞌ non koyon, miktukalaꞌ og manuk. ");
INSERT INTO suc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kilobotan non og tinaluꞌ kituꞌ ni Isus dianon nog, “Mangka siꞌoy poktukalaꞌ og manuk, tolu kali mu na akon sonsingoy nog diꞌ mu akon kilolaan.” Tubus nituꞌ, linumiu si Piter mangka ion poglulad. ");
INSERT INTO suc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Dangan miksisolom bonua, og glam nog mokokotas nog boliananan bu kobogolalan nog bansa Hudyu miksolabuk og gupakat nilan nog bunuꞌon nilan si Isus. ");
INSERT INTO suc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Binalud nilan ion mangka nilan ogakoy dituꞌ sog gubernador kituꞌ nog si Pilatu mangka nilan uokiloy dianon. ");
INSERT INTO suc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Si Judas, og mingulaꞌat kituꞌ dia ni Isus, dangan kisunan non nog gukuman dia ni Isus bunuꞌon, landuꞌ og sonsolan non bu inuliꞌ non bosia og sin kituꞌ nog binayad nog mokokotas nog boliananan bu og bogolalanan dianon nog tolu puluꞌ lad og solapiꞌ. ");
INSERT INTO suc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Dangan minatong ion dituꞌ, miktaluꞌ ion nog, “Mikodusa u. Poꞌ sabap dianakon moglaꞌat og gotow koyon, saka daꞌ salaꞌ non.” Tibua, tinabal nilan ion nog, “Daꞌ balan nami dun, sugaꞌid non, kosolasolaan mu na ion.” ");
INSERT INTO suc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dadi, linabak ni Judas og sinanan kituꞌ sog Baloy nog Poktomuyan dia sog Mikpongon mangka ion panow. Tubus nituꞌ, mingogotan ion. Binitin non og glawas non. ");
INSERT INTO suc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Og mokokotas nog boliananan kituꞌ, pingimud nilan og sinanan kituꞌ nog pinglabak ni Judas, mangka ilan poktaluꞌ nog, “Konaꞌ og botad nog dituꞌ ta toguꞌoy og sin koni dia sog poktoguꞌan nog sin dia sog Baloy nog Poktomuyan dia sog Mikpongon poꞌ ion non ini og ginamit nog pogbunuꞌ dia sog sala kotow.” ");
INSERT INTO suc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dadi, pigogupokatan nilan nog poksaluy nilan ituꞌ nog glupaꞌ kituꞌ nog molongas pondiunon. Dadi, sinumaluy ilan nog glupaꞌ mangka nilan imungoy nog kolobongan nog gotow nog konaꞌ Hudyu. ");
INSERT INTO suc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Saꞌan iningolanan nilan og glupaꞌ koyon nog Glupaꞌ nog Duguꞌ asta sog numun koni. ");
INSERT INTO suc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ion non ion og kotumanan nog tinaluꞌ nog Mikpongon kituꞌ bianan dia sog polomolatas non nog si Jerimaya nog, “Inalap nilan og tolu puluꞌ lad solapiꞌ nog ginologaꞌan dianon nog duma gotow Israel. ");
INSERT INTO suc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bu ginamit nilan og solapiꞌ koyon mangka nilan poksaluy nog glupaꞌ nog molongas pondiunon. Ion non ini og dinondag nog Mikpongon dianakon.” ");
INSERT INTO suc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Dangan minatong ilan dituꞌ, piadap nilan si Isus dia sog gubernador mangka non sakoy si Isus nog, “Ika taꞌ og datuꞌ kituꞌ nog bansa Hudyu?” Tinumabal si Isus nog, “Mamaꞌ nog tinaluꞌ mu koyon.” ");
INSERT INTO suc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ondaꞌ non tobaloy og sumbungan nog mokokotas nog boliananan koyon bu og kobogolalan koyon. ");
INSERT INTO suc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dadi, sinakan ion ni Pilatu nog, “Ondaꞌ mu taꞌ ion kodongog og glam nog sumbungan nilan koyon dianika?” ");
INSERT INTO suc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tibua, ondaꞌ tabal si Isus dun minsan mikaꞌan siꞌoy. Saꞌan ituꞌ kisobuꞌan og gubernador koyon dun. ");
INSERT INTO suc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Giap matong og tang nog kologyaꞌan nog ngalan non og Liniusan, og botad nog gubernador, poluason non sala kotow nog kinolobusu, ain bubuton nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sog tang koyon ngon sala kotow nog kinolobusu nog mibantug kolaton og kohinangan non nog ngalan non si Barabas. ");
INSERT INTO suc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dadi, dangan miglumpuk na og gotowanan, sinakan ilan ni Pilatu nog, “Sima og kolegan niu nog poluason ku? Si Barabas taꞌ, otawaka si Isus nog ion iningolanan nog Kristu?” ");
INSERT INTO suc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Poꞌ kosunan ni Pilatu nog saꞌan inukpaꞌan si Isus nog kounutananan nog Hudyu poꞌ miksibok ilan dianon. ");
INSERT INTO suc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sog solian ni Pilatu pogingkud dituꞌ sog pongukuman non, pinoitan ion nog kodumanan non nog taluꞌ nog maꞌ nini, “Naꞌ a mogbabal nog gotow koyon nog daꞌ og salaꞌ non. Poꞌ kogobi misinsa u tokodoy nog toginopon ku paꞌali dianon.” ");
INSERT INTO suc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tibua, og mokokotas nog boliananan bu kobogolalan koyon tinogol nilan sumolabuk og gotowanan koyon dion nog si Barabas poluason bu si Isus og bunuꞌon. ");
INSERT INTO suc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tubus nituꞌ, miksak nosop si Pilatu dia sog gotowanan nog, “Sima sog duaꞌ kotow koni og kolegan niu nog poluason ku?” Miglongag ilan tumabal nog, “Si Barabas!” ");
INSERT INTO suc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tinabal ilan ni Pilatu nog, “Dadi buan, olo ma og gondunon ku dia ni Isus nog iningolanan nog Kristu?” Miglongag ilan tumabal nog, “Kudus mu ion!” ");
INSERT INTO suc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Iduma? Olo og salaꞌ nog miinang nog gotow koni?” Tibua, posisayaꞌ nilan tanan posikadoy og gapis nilan nog, “Kudus mu ion!” ");
INSERT INTO suc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dangan kisunan ni Pilatu nog daꞌidun na og minang non dun poꞌ og gotowanan moglamlam ilan na mokpoksasow, minalap ion nog tubig mangka ion pongugas nog komot non sog sunguꞌan nog gotowanan mangka ion poktaluꞌ nog, “Diꞌ u na kosakan nog duguꞌ bu og kopatoy nog gotow koni. Sugaꞌid non, amu na og kosakan dun.” ");
INSERT INTO suc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tinumabal og glam nog gotowanan koyon nog, “Oꞌo, ami na bu asta og gombataꞌanan nami og kosakan dun.” ");
INSERT INTO suc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tubus nituꞌ, piluas ni Pilatu si Barabas tidu sog kolobusuan mangka non dondagoy nog pogbodason si Isus, mangka non uokiloy dia sog sundaluanan nog kuduson nilan na ion. ");
INSERT INTO suc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tubus nion, inoit nog sundaluanan ni Pilatu si Isus sog glomalomaan nog baloy non. Piglumpukan ion nog modakol nog sundaluanan. ");
INSERT INTO suc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Inowaꞌan nilan ion nog ponopoton bu posolugoy nog glogdoy nog ompula. ");
INSERT INTO suc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tubus nituꞌ, linumikid ilan nog bolagon nog dugion mangka nilan posolugoy dia sog gulu non bu poponogadoy og komot non nog glintu mangka ilan pongingluꞌud sog sunguꞌan non bu mangka nilan pogwanwanoy. Long nilan dun, “Mololaki a ma le, og datuꞌ nog gotow Hudyu!” ");
INSERT INTO suc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pigdulaꞌan nilan ion mangka nilan olapoy dianon og tagad non kituꞌ mangka nilan pogbombaloy sog gulu non. ");
INSERT INTO suc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Dangan midoksuꞌ nilan na pogwanwanoy, linuas nilan na og glogdoy kituꞌ nog pisolug nilan dianon mangka nilan posolugoy puliꞌ dianon og dili glogdoy non. Tubus nituꞌ, pinitang nilan na ion poꞌ kuduson nilan na. ");
INSERT INTO suc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sintak nilan ompanow posunguꞌ sog kudusan nilan kituꞌ dianon, milumpak nilan si Simun og gotow Sirini. Tinogol nilan mokpopisan dianon og kudus ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Daꞌ kobon minatong ilan sog bonua nog iningolanan og Golgota. (Og maꞌana non, bakuk nog gulu.) ");
INSERT INTO suc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Piinum nilan bosia si Isus nog ginumon nog inompuꞌan nog podu. Tibua, dangan kiinaman non, ompok ion minum dun. ");
INSERT INTO suc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tubus nilan tibua kudusoy si Isus, og ponopoton non kituꞌ nog linuas nilan dianon, pigbahagiꞌ nilan bianan sog moglogindanan. ");
INSERT INTO suc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tubus nituꞌ, miningkud ilan kobon nilan mogipat dianon. ");
INSERT INTO suc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Og sumbungan kituꞌ dianon sinulat nog maꞌ nini, “Koni si Isus, og Datuꞌ nog Bansa Hudyu.” Pitapok nog sundaluanan sog kudus dia sog ditas nog gulu ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ngon duaꞌ kotow polonglaꞌug nog kinudus migimpang sog kilidan non. ");
INSERT INTO suc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Og gotowanan koyon nog mikpomian dion, pigundaundaan nilan si Isus kobon nilan mokisingising ");
INSERT INTO suc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","bu mangka ilan poktaluꞌ nog, “Long nika dun, gobaꞌon mu dow og Baloy nog Poktomuyan mangka mu pindogoy mokpuliꞌ sog solod nog tolu ondow. Tobangoy mu dow buan og glawas mu! Tukpa a sog kudus mu koyon bila dodaꞌ motud nog Bataꞌ a nog Mikpongon!” ");
INSERT INTO suc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bu maꞌ nituꞌ dosop og gininang nog mokokotas nog boliananan, bu og polopanadanan nog botad nog bansa Hudyu, bu og kobogolalan, pigwanwan nilan dosop ion. ");
INSERT INTO suc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Long nilan dun, “Og gotow koyon, mitabang non og duma gotow saka ondiꞌ non motabang og dili glawas non. Ion dow og Datuꞌ nog bansa Israel? Tontongon ta dow buan bog mokotukpa taꞌ dodaꞌ ion dia sog kudus non. Bila mokotukpa na ion, mangka ita pa tud dun. ");
INSERT INTO suc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Sinumalig ion sog Mikpongon. Tontongon ta dow buan bog moleg taꞌ og Mikpongon tumabang dianon numun kituꞌ poꞌ miktaluꞌ ion nog Bataꞌ dow ion nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bu og polonglaꞌuganan kituꞌ nog kinudus sog molani non, dinumuma dosop mogwanwan dianon. ");
INSERT INTO suc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tidu sog miglotuondow mangoy sog miginongaꞌ monog gondow, migdolom og tibuk nog bonua. ");
INSERT INTO suc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bu dangan miginongaꞌ na monog gondow, miktaluꞌ si Isus nog mosikad, “Eli, Eli lama sabaktani?” Og maꞌana non, “Diwata u, Diwata u, iduma pitiang mu ma akon?” ");
INSERT INTO suc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dangan midongog nog duma gotowanan koyon nog mikpogindog dion, miktaluꞌ ilan nog, “Sinabi non og polomolatas kituꞌ nog si Iladya.” ");
INSERT INTO suc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bu ngon og sala kotow dianilan ginumobok mangka alap nog ponopoton nog kodikpol bu molamit mangka potosopoy nog glanggow mangka non tukogoy sog sosungit bu tokmoꞌoy dia sog babaꞌ ni Isus bagun non bosia mosoksop. ");
INSERT INTO suc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tibua, og dumaanan dion miktaluꞌ nog, “Potiang mu ion poꞌ tontongon ta bog ongoyon taꞌ dodaꞌ ion tobangoy ni Iladya.” ");
INSERT INTO suc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tubus nituꞌ, miktaluꞌ nosop si Isus nog mosikad mangka na ion kotoktus. ");
INSERT INTO suc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sog tang koyon, og ponopoton kituꞌ nog modikpol og bolot sog Baloy nog Poktomuyan dia sog Mikpongon, migbogyang poginongaꞌ tidu sog ditas mangoy sog silung. Miglinug og glupaꞌan bu og batuanan mikpogbolaꞌ. ");
INSERT INTO suc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Bu og kolobongan mikpogbukaꞌ bu modakol og pigotowan nog Mikpongon nog mikpomatoy na nog mitubuꞌ puliꞌ. ");
INSERT INTO suc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mikpongluas ilan tidu sog globonganan nilan. Bu dangan mitubuꞌ puliꞌ si Isus tidu matoy, minangoy ilan sog Jerusalem. Bu modakol og gotowanan og mikotongow dianilan dituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Og sundaluanan bu kounutan nilan nog migipat dia ni Isus sog kudus, dangan miglinug bu mitongow nilan og glam nog bianbian koyon, kiondokan ilan tokodoy dun mangka ilan poktaluꞌ nog, “Motud dodaꞌ nog ion og Bataꞌ nog Mikpongon!” ");
INSERT INTO suc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ngon dion og modakol dosop og kolibunanan nog mikpogbantoy sog molayuꞌlayuꞌ. Mikpogunut ilan dia ni Isus tidu sog Galili nog minaꞌub nog kulang ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Og dumaanan nilan koyon dion, si Maria Magdalena. Bu si Maria nog og ginaꞌ ni Jems ilan ni Jusep, bu og ginaꞌ nog gombataꞌ ni Sebedi. ");
INSERT INTO suc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dangan miksindopondow na, ngon minatong sala kotow nog doyahan nog gotow Arimatea og ngalan non si Jusep. Ion siꞌoy og sulangguꞌ dosop ni Isus. ");
INSERT INTO suc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Minangoy ion dituꞌ ni Pilatu mangka non pogbubutoy og bangkoy ni Isus. Dinondag ni Pilatu nog bogoyon na dianon og bangkoy ni Isus koyon. ");
INSERT INTO suc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dadi, inangoy non og bangkoy koyon mangka non putusoy nog bulus ");
INSERT INTO suc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","mangka non botangoy og bangkoy ni Isus koyon dituꞌ sog globong non nog bogu kodoksuꞌ luangoy dia sog pampang, mangka non lilidoy nog mosolag nog batu og totimpong nog bongawan nog globong koyon mangka ion uliꞌ. ");
INSERT INTO suc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Si Maria Magdalena bu sala kotow Maria kituꞌ, miningkud ilan sog sunguꞌan nog globong koyon. ");
INSERT INTO suc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Migbolomaꞌ ion og Gondow nog Pogulali. Og mokokotas nog boliananan bu parasiuanan minangoy dituꞌ ni Pilatu mangka pogabit nog, ");
INSERT INTO suc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Gubernador, kolobotan nami nog kobon nog totubuꞌ pa og moloput kituꞌ, miktaluꞌ ion nog bila matoy dow ion, sog kotolu ondow non, motubuꞌ dow ion puliꞌ. ");
INSERT INTO suc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dadi Gubernador, molongas bosia bila ngon og modondag mu mogipat nog globong non kituꞌ sog solod nog kotolu ondow. Poꞌ gomonsunoy ongoyon dokowoy nog sulangguꞌanan non og bangkoy non, mangka nilan toluꞌoy dia sog gotowanan nog mitubuꞌ ion puliꞌ tidu matoy. Bila maꞌ nituꞌ og ginangon nilan, labi pa kolaton og doksuꞌ nog gloput nilan koyon dia sog gloput non kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tinumabal si Pilatu nog, “Mokodyadi ion. Pokpitang amu nog sundaluanan dituꞌ bu amu na koto mogipat dun mahatul.” ");
INSERT INTO suc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dadi, migoit ilan nog sundaluanan dituꞌ bu pidokotan nilan nog gindanan nilan dun og goksid nog batu koyon nog timpong nog globong non koyon mangka nilan dondagoy mogipat mahatul. ");
INSERT INTO suc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Milibuas og Gondow nog Pogulali, dangan migdaliꞌondow nog moglogondow Duminggu, si Maria Magdalena bu og sangoy non kituꞌ nog si Maria, inangoy nilan tontongoy og globong kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gomonsunoy pa miglinug nog landuꞌ kosikad poꞌ og moloikat nog Mikpongon minonog tidu sog glangit mangka non ongoyoy lilidoy og batu nog timpong nog globong kituꞌ mangka non ingkudoy. ");
INSERT INTO suc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Og bayuꞌbayuꞌ non sinumilow mamaꞌ nog kilat, bu og ponopoton non putiꞌ maꞌ nog gabun. ");
INSERT INTO suc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Og pogipat nog globong koyon, kiondokan ilan tokodoy nog moloikat koyon boyaꞌan nog inubas ilan nog gondok nilan. ");
INSERT INTO suc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tibua, miktaluꞌ og moloikat dia sog kolibunanan koyon nog, “Naꞌ amu kondokan poꞌ kosunan ku nog pokponontongon niu si Isus nog kinudus kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ondaꞌ ion dini poꞌ mitubuꞌ na ion puliꞌ mamaꞌ nog tinaluꞌ non kituꞌ dianiu. Tontong niu poloꞌma og binolilidan kituꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tubus nituꞌ, mangka amu pogdaliꞌ mangoy mokposun sog sulangguꞌanan non nog mitubuꞌ ion puliꞌ tidu matoy, bu migunauna ion dianiu dituꞌ sog Galili. Dituꞌ amu na non poktongow. Koyon da og motaluꞌ u dianiu.” ");
INSERT INTO suc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dadi, migdaliꞌdaliꞌ ilan mawaꞌ sog globong koyon. Bu miksagot og gondok nilan bu og daꞌdaꞌan nilan. Ginumobok ilan moguksug sog sulangguꞌanan non. ");
INSERT INTO suc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Gomonsunoy pa, linumpak ilan ni Isus mangka ion poktaluꞌ dianilan nog, “Og kotiknaꞌ nog pomikilan mongon dianiu.” Dadi, mikpolani ilan dianon mangka ilan sugyut bu salam dianon kobon nilan mogaid sog botis non. ");
INSERT INTO suc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Miktaluꞌ si Isus nog, “Naꞌ amu kondokan. Sugaꞌid non, angoy amu dituꞌ sog pigilugan ku bu taluꞌ niu dianilan nog mangoy ilan dituꞌ sog Galili poꞌ dituꞌ ami na nilan poktongow.” ");
INSERT INTO suc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sonuk nog kolibunanan kituꞌ ompanow, og duma polongipatanan kituꞌ, minangoy ilan sog koliwagan bonua mangka ilan poguksug sog mokokotas nog boliananan nog glam nog bianbian koyon. ");
INSERT INTO suc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dadi, og mokokotas nog boliananan, migupakat ilan nog kobogolalan koyon bog olo pondayan nilan. Og pondayan nilan dun, binogayan nilan og polongipatanan kituꞌ nog modakol nog sin ");
INSERT INTO suc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","mangka nilan poktungioy nog, “Taluꞌ niu dia sog gotowanan nog, ‘Dangan tongaꞌ gobi, sonuk nami motulug, inangoy nog sulangguꞌanan non dokowoy og glawas ni Isus dituꞌ sog globong.’ ");
INSERT INTO suc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bila modongog dituꞌ sog gubernador og dongogan koni, ami na og moto mogabitabit dun dianon nog bagun amu da ondiꞌ moglaꞌat dun.” ");
INSERT INTO suc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dadi, tinabuk nog polongipatanan og sin koyon mangka nilan unutoy og tinaluꞌ kituꞌ dianilan. Bu guksugan koni mipulonag dia sog gotow Hudyu asta sog numun koni. ");
INSERT INTO suc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Og sopuluꞌ bu sala sulangguꞌanan ni Isus, minangoy ilan dituꞌ sog Galili sog bulud kituꞌ nog tinaluꞌ ni Isus dianilan nog gongayan nilan. ");
INSERT INTO suc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bu dangan mitongow nilan si Isus dituꞌ, sinumugyut ilan dianon. Tibua, og duma dianilan migduaꞌduaꞌ. ");
INSERT INTO suc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dadi, mikpolani si Isus dianilan mangka poktaluꞌ nog, “Og glam nog bayaꞌ sog pigloban nog glangit bu glupaꞌan binogoy dianakon. ");
INSERT INTO suc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dadi, panow amu sog glam nog binonsaan bu imung niu ilan nog sulangguꞌanan ku bu bunyagoy niu ilan bianan sog ngalan nog Gamaꞌ, bu og Bataꞌ, bu og mosigda nog Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bu ponadoy niu ilan mokokunut sog glam nog dinondag u dianiu. Bu poktitukoy niu nog kobon non dia u niu asta sog doksuꞌan nog dunya.”");
INSERT INTO suc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Koni og tolipunan nog Gombaꞌis nog Guksugan paꞌali dia ni Isukristu, og Bataꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Maꞌ nini og sinulat nog polomolatas kituꞌ nog taluꞌ nog Mikpongon kobon nituꞌ nog si Isaya nog, “Ngon og sosuguꞌon ku nog punaon ku dianika moksimpan nog bianan mu. ");
INSERT INTO suc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ngon og moktawag sog bonua kituꞌ nog mologon pogonongan nog, ‘Simpan niu og bianan nog Pogbayaꞌ nog posunguꞌ matong bu pologdong niu og dalan non.’” ");
INSERT INTO suc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Dadi, ngon og gotow ngalan non si Jan, mimunyag nog gotowanan sog bonua kituꞌ nog mologon pogonongan. Mimali ion nog sumboy og gotow moglilaꞌ nog dusaanan non poꞌ kompunan ilan dun nog Mikpongon bu mangka ilan pokpobunyag. ");
INSERT INTO suc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dadi, mikpogangoy dituꞌ ni Jan og gotowanan tidu sog ainain nog bonua sog Judia bu gotowanan tidu sog koliwagan bonua nog Jerusalem poꞌ mangoy ilan moglilaꞌ nog dusaanan nilan dia sog Mikpongon mangka ilan pokpobunyag dia ni Jan dituꞌ sog glawas nog tubig nog Jurdan. ");
INSERT INTO suc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Si Jan, og ponopoton non og bombul nog kamel nog inabol. Bu bagos non og panit nog potubuꞌon. Bu og pongonganon non og gapan bu og tonob. ");
INSERT INTO suc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Og pigustal non koyon maꞌ nini, “Ngon og gotow tumondug dianakon nog motas pa ion dianakon poꞌ minsan siꞌoy og gikot nog pongyapak non, ondiꞌ u tanan patut mingluꞌud mubad dun. ");
INSERT INTO suc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Akon, binunyagan ku amu bianan sog tubig. Tibua, ion og bunyagan non amu bianan sog Bolakat nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Dadi, sog tang koyon, minangoy si Isus dituꞌ ni Jan tidu sog Nasaret sog solod nog Galili bu binunyagan ion ni Jan dituꞌ sog glawas nog tubig nog Jurdan. ");
INSERT INTO suc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sonuk ni Isus gumawon posunguꞌ sog kotasan, mitongow non mibukaꞌ og glangit bu og Bolakat nog Mikpongon mamaꞌ nog kolopati posunguꞌ tumonaꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bu ngon og taluꞌ nog tidu sog glangit nog maꞌ nini, “Ika og bataꞌ u nog kololaman ku. Kisuꞌatan u tokodoy dianika.” ");
INSERT INTO suc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tubus nituꞌ, pigdoyunan mokpopanow si Isus nog Bolakat nog Mikpongon dituꞌ sog bonua kituꞌ nog mologon pogonongan. ");
INSERT INTO suc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Sog solod nog pat puluꞌ gobi ion dituꞌ, pingyubaꞌan ion ni Kindagow. Bu migampuꞌ ilan na nog mokokaꞌidanan nog manusiaꞌanan dituꞌ. Tibua, inusibaꞌ da ion nog moloikatanan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Dangan mikolobusu si Jan, minangoy sop si Isus dituꞌ sog Galili mokpulonag nog Gombaꞌis nog Guksugan nog miktidu sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Miktaluꞌ ion nog, “Mosompol na og kopogdatuꞌ nog Mikpongon dini sog glupaꞌan. Dadi, poglilaꞌ amu na nog dusaanan niu bu tud amu sog Gombaꞌis nog Guksugan koni.” ");
INSERT INTO suc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sonuk ni Isus mokpopongoksid sog danow nog Galili koyon, mitongow non si Simun ilan nog kongudan non nog si Andriu solian nilan monglaya sog danow koyon poꞌ tolisodaꞌ ilan. ");
INSERT INTO suc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Miktaluꞌ si Isus dianilan, “Alung, pogunut amu dianakon poꞌ imungon ku amu nog moktolisodaꞌ nog gotow.” ");
INSERT INTO suc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dadi, sododuꞌun ginonatan nilan og glayaanan nilan koyon mangka ilan pogunut dianon. ");
INSERT INTO suc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Dangan migdayun ilan sog gunanunan, mitongow non og gombataꞌ ni Sebedi nog si Jems bu kongudan non nog si Jan sonuk nilan momunaꞌ nog pokot nilan dia sog bolangoy nilan koyon. ");
INSERT INTO suc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dadi, pigdoyunan ilan ni Isus monggat bu migunut ilan doma dianon. Dadi, ginonatan nilan og gamaꞌ nilan bu og gotowanan nog tinindanan nilan dia sog bolangoy koyon. ");
INSERT INTO suc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tubus nituꞌ, minangoy ilan sog koliwagan bonua nog Kapernaum. Bu dangan minatong og Gondow nog Pogulali, minangoy si Isus sog baloy nog poglumpukan nog bansa Hudyu mangka ion poktolipun mokpanad dion. ");
INSERT INTO suc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kisobuꞌan tokodoy og gotowanan nog kopokpanad non koyon. Poꞌ og kopokpanad non, ion og togo bayaꞌ. Ondiꞌ maꞌ nog polopanadanan koyon nog botad nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Gomonsunoy ngon og gotow nog tinosopan nog glatdiwata miglogapis dia sog dialom baloy koyon nog poglumpukan. Maꞌ long non dun, ");
INSERT INTO suc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ika Isus, og gotow Nasaret, olo og dunon mu dianami? Ongoyon mu notaꞌ ami loꞌatoy? Kilolaan ku da ika. Ika og Mosigda kituꞌ nog miktidu sog Mikpongon!” ");
INSERT INTO suc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tibua, pimag ni Isus og glatdiwata koyon nog, “Lotaꞌ a moktaluꞌ! Bu awaꞌ a dianon!” ");
INSERT INTO suc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dadi, og glatdiwata koyon, pilede non og gotow koyon bu poglosek mangka na awaꞌ. ");
INSERT INTO suc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Dadi, kisobuꞌan og glam nog gotowanan dion bu miksinaksakoy ilan nog, “Olo maꞌ nini koni? Og bogu ma ini nog pomali! Bu motas ma og bayaꞌ non! Ampun binugow non og glatdiwataanan kituꞌ migbilang ma dianon.” ");
INSERT INTO suc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dadi, og dongogan koyon paꞌali dianon mibantug mogdayun sog gliwag nog bonua koyon nog Galili. ");
INSERT INTO suc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Dangan linumiu si Isus sog baloy koyon nog poglumpukan, migunut ion dia ni Jems bu si Jan mangoy dituꞌ sog baloy ni Simun ilan ni Andriu. ");
INSERT INTO suc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Dangan minatong ilan dion, piguksugan nilan dia ni Isus nog og ponugangan ni Simun nog glibun pogbolilid poꞌ mipanas. ");
INSERT INTO suc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dadi, minangoy ion sog mogulang koyon mangka non pogoidoy sog komot bu mangka non buatoy. Dangan binuat non, kiowasan ion mangka piktologadan non ilan. ");
INSERT INTO suc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dangan sinumindop na gondow, pingoit dion ni Isus glam nog diꞌ mokokodag bu glam nog pinosopan nog glatdiwataanan. ");
INSERT INTO suc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Og glam nog gotowanan sog gliwag nog koliwagan bonua koyon miglumpuk sog baloy koyon. ");
INSERT INTO suc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Bu modakol kiuliꞌan ni Isus nog miglologinis og mokosakitanan nilan. Bu modakol dosop pimugow ni Isus nog glatdiwataanan dia sog gotowanan koyon. Tibua, pigondiꞌan ni Isus moktaluꞌ og glatdiwataanan koyon poꞌ kisunan nilan bog sima ion. ");
INSERT INTO suc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Dangan miampiampi gobi, migbuat si Isus bu linumiu sog baloy koyon poꞌ mangoy ion mogyakin sog moliliꞌ. ");
INSERT INTO suc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Si Simun bu dumaanan non, inangoy nilan ponontongoy si Isus. ");
INSERT INTO suc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Dangan mitongow nilan ion, miktaluꞌ ilan nog, “Pinontong a nog glam nog gotowanan kituꞌ!” ");
INSERT INTO suc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Dadi, tinumabal si Isus, “Alung, mogdayun ita sog duma koliwagan bonuaanan sog glumibut nog bonua koni, poꞌ bagun u dosop mokopomali dituꞌ. Poꞌ maꞌ nituꞌ og gangoy u dini sog dunya.” ");
INSERT INTO suc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dadi, miguliugan si Isus sog gliwag nog Galili mogustal dia sog baloyanan nog poglumpukan nog bansa Hudyu bu momugow nog glatdiwataanan dia sog ain tinosopan dun. ");
INSERT INTO suc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tubus nituꞌ, ngon og glaki, og gipulon nog mikpolani dia ni Isus. Miningluꞌud bu mikilolat dianon nog, “Somoꞌ moleg a da, ompokodag mu akon.” ");
INSERT INTO suc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Milolat si Isus tokodoy dianon. Dadi, dinoponan ion ni Isus mangka poktaluꞌ nog, “Moleg u da le. Kuliꞌan ka na!” ");
INSERT INTO suc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bu sododuꞌun miawaꞌ og gipul non kituꞌ bu kiuliꞌan. ");
INSERT INTO suc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mangka siꞌoy ion poponowoy ni Isus, pigondiꞌan non tokodoy mokposun. Long non dun, ");
INSERT INTO suc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Naꞌ mu ini tokodoy posunon minsan sima. Sugaꞌid non, angoy mu potongow og glawas mu dituꞌ sog bolian mangka a pomalas maꞌ nog dinondag ni Muses kituꞌ kobon nituꞌ poꞌ bagun nilan kotoksiꞌan.” ");
INSERT INTO suc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kolele nog unuton non og pimali kituꞌ ni Isus dianon, diadia non tanan pinguksugan. Dadi og doksuꞌ non, ondiꞌ na tanan si Isus mokopokangiasangias dia sog koliwagan bonuaanan koyon dion. Sugaꞌid non, dia notibua ion pogonong sog bonua koyon nog moliang gotow dun. Tibua, minsan siꞌoy maꞌ nituꞌ, modakol da og gotowanan nog mikpogangoy dituꞌ non nog mikpoktidu sog ainain nog bonua. ");
INSERT INTO suc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Daꞌ kobon golot non, mikpuliꞌ si Isus sog Kapernaum. Dangan kisunan nog gotowanan nog minuliꞌ na ion dituꞌ, ");
INSERT INTO suc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","landuꞌ kodakol nog gotow og miglumpuk dia sog baloy non koyon. Tiduanan sog ditas asta sog glonuꞌan milotok na nog gotow. Bu inustal ni Isus dianilan paꞌali sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Sintak non ion, minatong og gotowanan nog pogoit ilan nog daday. Og daday koyon inoyungan nog pat kotow. ");
INSERT INTO suc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kobal nog gotowanan koyon nog landuꞌ na kodakol, diꞌ ilan mokopolani dia ni Isus. Dadi, mimonek ilan sog gatop mangka nilan lodutoy og gatop nog baloy koyon sog tondong ni Isus, mangka nilan tontunoy dituꞌ non og daday koyon. ");
INSERT INTO suc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Dadi, dangan mitongow ni Isus og kopongandol nilan, tinoluꞌan non og daday koyon, “Aki, og dusaanan mu inompunan na.” ");
INSERT INTO suc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ngon og mikpogingkud dion nog polopanadanan nog botad nog bansa Hudyu. Migdialominawa ilan nog, ");
INSERT INTO suc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Iduma gidoy mamaꞌ ma nion og toluꞌon nog glaki koyon? Moglakaꞌlakaꞌ ma monaluꞌ dia sog Mikpongon! Saka daꞌidun lual og mokampun nog dusa lual da og Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tibua, kisunan ni Isus mogdayun og pomikilan nilan. Dadi, tinoluꞌan non ilan, “Iduma pogdialominowaan niu ma akon nog maꞌ nion? ");
INSERT INTO suc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ain gidoy og molomu toluꞌon sog daday koni, ‘Inompunan na og dusaanan mu,’ otawaka moktaluꞌ nog, ‘Pogbuat a, pitang mu og bolilidan mu mangka a panow?’ ");
INSERT INTO suc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tibua, bagun niu kosunan, potongowon ku dianiu nog og Binataꞌ sog Kilawan togo bayaꞌ mongampun nog dusa nog gotowanan dini sog glupaꞌan.” ");
INSERT INTO suc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Mangka non toluꞌoy og daday koyon nog, “Aki, toluꞌon ku dianika, pogbuat a na, imud mu og pigbolilidan mu koyon bu pitang mu muliꞌ.” ");
INSERT INTO suc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dadi, dia sog kodokolan koyon, migbuat dodaꞌ og gotow koyon mangka non imudoy og pigbolilidan non koyon mangka ion liu. Kisobuꞌan tokodoy glam nog gotowanan koyon dion bu piksonglitan nilan og Mikpongon. Mikpoktaluꞌ ilan nog, “Daꞌ ita sibon pokotongow nog kohinangan koni nog maꞌ nini!” ");
INSERT INTO suc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tubus nituꞌ, mikpuliꞌ si Isus sog goksid nog danow koyon nog Galili. Bu modakol nog gotowanan og linumumpak dianon. Dadi, miktolipun ion mokpanad dianilan. ");
INSERT INTO suc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sog solian ni Isus ompanow, mitongow non si Lebi, og bataꞌ ni Alpius, pogingkud sog baloybaloy non nog pokpongobatan nog buis. Tinoluꞌan ion ni Isus nog, “Pogunut a le dianakon.” Dadi, migbuat ion mogdayun mangka pogunut dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tubus nituꞌ, si Isus bu og sulangguꞌanan non, migadap ilan kuman dituꞌ ni loꞌ Lebi. Modakol og polongabatanan nog buis bu og bolodusaon minadap dianilan poꞌ modakol og gotowanan nog migunut dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Og polopanadanan nog botad nog bansa Hudyu nog ilan siꞌoy og parasiuanan dosop, dangan mitongow nilan nog minadap ion kuman sog bolodusaon bu polongabatanan nog buis, miksak ilan sog sulangguꞌanan ni Isus nog, “Iduma mampuꞌ ma ion kuman sog gotowanan koyon nog polongabat nog buis bu sog bolodusaon?” ");
INSERT INTO suc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Dangan midongog ni Isus og taluꞌ nilan koyon, tinabal non ilan nog, “Og gotow nog mokodag, daꞌidun na og balan non nog polomulung. Tibua, og gotow nog diꞌ mokodag, ngon og kobalan non dun. Dadi, konaꞌ og gangoy u dini mangoy mogonggat sog ain mokpikil nog midulus ilan na. Sugaꞌid non, inangoy u onggatoy ain og gotow nog bolodusaon.” ");
INSERT INTO suc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ngon gondow non, nog mikpuasa og sulangguꞌanan ni Jan bu parasiuanan koyon. Dadi, ngon og minangoy moksak dia ni Isus bog iduma og sulangguꞌanan ni Jan bu sulangguꞌanan nog parasiuanan koyon, mokpuasa ilan ma saka og sulangguꞌanan non, diꞌ ilan mampuꞌ mokpuasa. ");
INSERT INTO suc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tinabal ilan ni Isus bianan sog pononggiꞌan nog, “Mogusoy taꞌ gidoy nog og pongantim mokpuasa nog kobon dion pa nilan og koingon koyon? Ondiꞌ ilan nododaꞌ mokopuasa sog sonuk nog mikunul ilan pa. ");
INSERT INTO suc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tibua, ongon da gondow non nog bigdason dianilan og koingon koyon, mangka ilan pa pokpuasa.” ");
INSERT INTO suc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tubus nituꞌ, miktaluꞌ nosop ion nog len pononggiꞌan. Long non dun, “Daꞌidun og gotow nog bila monilob, gumabas nog bogu ponopoton nog daꞌ pa koloꞌ mangka non tiloboy sog dan ponopoton. Poꞌ bila kumoloꞌ og tilob non koyon, mogdungag lumiwag og bogyang og dan logdoy non koyon. ");
INSERT INTO suc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bu domikian dosop nog daꞌidun og gotow tumaguꞌ nog bogu galak dia sog dan toguꞌan nog diꞌ lumagyat. Poꞌ bila maꞌ nituꞌ, bila tumulin og bogu galak koyon, ombogdak og tinoguꞌan koyon dun. Dadi, doksuꞌ non, tidu sog toguꞌan koyon asta og galak koyon ombolong. Sugaꞌid non, og bogu galak dia na dodaꞌ toguꞌoy sog bogu toguꞌan nog lumagyat.” ");
INSERT INTO suc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ngon gondow non, og Gondow nog Pogulali, minian si Isus bu og sulangguꞌanan non sog polayan. Solian nilan mian dion, og sulangguꞌanan non koyon mingotuꞌ ilan nog bunga nog paloy koyon. ");
INSERT INTO suc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Dadi, miktaluꞌ parasiuanan koyon dianon nog, “Tontong nika poloꞌma og sulangguꞌanan mu koyon. Iduma moginang ilan ma nog konaꞌ og botad sog Gondow nog Pogulali?” ");
INSERT INTO suc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Dadi, tinabal ilan ni Isus nog, “Daꞌ niu taꞌ buan kobasta og sinulat kituꞌ sog Kitab paꞌali sog gininang ni Dabid kituꞌ dangan kilogonan ilan bu kigutoman ilan nog dumaanan non? ");
INSERT INTO suc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sog masa ni Abiatar nog ion og miglokounutan sog boliananan, sinumolod si Dabid sog dialom nog Baloy nog Poktomuyan dia sog Mikpongon, mangka non olapoy og pan kituꞌ nog inuakil na dia sog Mikpongon, mangka non kanoy, bu mangka non dosop pomogoyoy dun og dumaanan non saka, daꞌidun bosia og mokokan dun lual da og boliananan poꞌ maꞌ nituꞌ og bonduan dia sog Botad.” ");
INSERT INTO suc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tubus nituꞌ, tinoluꞌan non nosop ilan nog, “Og Gondow nog Pogulali, binogoy sog kopianan nog gotow. Tibua, og gotow ondaꞌ pongonoy bagun pogboyaꞌan nog Gondow nog Pogulali. ");
INSERT INTO suc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Saꞌan da og Binataꞌ sog Kilawan, ion og Pogbayaꞌ minsan sog Gondow nog Pogulali.” ");
INSERT INTO suc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ngon gondow non, sinumolod nosop si Isus sog baloy nog poglumpukan. Ngon og glaki dion nog minguyomong og komot non. ");
INSERT INTO suc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Og duma gotowanan koyon dion, piktimaꞌanan nilan si Isus bog uliꞌan non taꞌ og komot nog glaki koyon nog saka Gondow nog Pogulali. Poꞌ bila uliꞌan non dodaꞌ, sumbungon nilan ion dun. ");
INSERT INTO suc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dadi, miktaluꞌ si Isus dia sog glaki koyon nog minguyomong komot non nog, “Angoy a indog dini sog sunguꞌan nog gotowanan koni.” ");
INSERT INTO suc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mangka sakoy ni Isus og gotowanan koyon nog, “Olo gidoy og tinugdak dia sog botad nog ginangon ta sog Gondow nog Pogulali? Moginang taꞌ nog molaton otawaka molongas? Tumabang sog ain gotow nog kilogonan otawaka posinsaon taꞌ?” Tibua, daꞌ ilan pokopogonekonek dun. ");
INSERT INTO suc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Liniboyan ilan ni Isus nog mata poꞌ miglolingit bu mosakit pikilan non dun nog daꞌidun glanggung nilan. Dadi, miktaluꞌ ion dia sog glaki koyon nog minguyomong komot non nog, “Ogot mu og komot mu koyon.” Dadi, inogot non dodaꞌ bu mioksud na maꞌ nog dan og komot non koyon. ");
INSERT INTO suc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tibua, mikpongliu og parasiuanan koyon mangka ilan pogupakat mogdayun, ilan nog glaꞌayatanan ni Herod bog olo pondayan nilan bagun nilan ompongulaꞌat si Isus. ");
INSERT INTO suc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Dadi, minawaꞌ si Isus dituꞌ ilan nog sulangguꞌanan non mangka ilan angoy sog goksid nog danow koyon. Bu modakol og gotowanan nog mikpogunut dianon tidu sog bonua nog Galili. ");
INSERT INTO suc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Dangan mibantug na og kohinangan non, og gotowanan koyon sog Judia, bu sog koliwagan bonua nog Jerusalem, bu sog Idumia, bu og bonuaanan dituꞌ sog dipag nog Jurdan, bu sog glumibut nog koliwagan bonua nog Tair, bu koliwagan bonua nog Sidon, mikpogangoy ilan dituꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sabap sog kodakol nog gotowanan koyon nog mikpogangoy dion nilan, dinondag ni Isus og sulangguꞌanan koyon lumidus nog bolangoy poꞌ sokayan non bagun da diꞌ molodis nog gotowanan koyon dion. ");
INSERT INTO suc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Poꞌ modakol og diꞌ mokokodag nog kiuliꞌan non. Dadi, glam nog gotowanan nog ain togo mosakit, migagow ilan mokpolani dia ni Isus bagun nilan da ion motuyok. ");
INSERT INTO suc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Giap ion motongow nog glatdiwataanan nog tinumosop dia sog gotowanan koyon dion, mokpogbuksak ilan dia sog sunguꞌan non kobon nilan moglosek nog, “Ika og Bataꞌ nog Mikpongon!” ");
INSERT INTO suc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tibua, pigondiꞌan ilan ni Isus moguksug paꞌali dianon. ");
INSERT INTO suc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tubus nituꞌ, tinumukad si Isus sog bontud mangka non sobioy og gotowanan kituꞌ nog kolegan non momiliꞌ. Bu minangoy ilan doma dituꞌ non. ");
INSERT INTO suc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mangka non na pomiliꞌoy og sopuluꞌ bu duaꞌ kotow dianilan nog iningolanan non og sosuguꞌonanan non poꞌ dumuma ilan dianon, bu bagun non ilan modondag mangoy mogustal paꞌali sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bu bogayan non dosop ilan nog bayaꞌ bagun ilan mokopomugow nog glatdiwataanan dia sog ain tinosopan dun. ");
INSERT INTO suc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Koni og sopuluꞌ bu duaꞌ kotow kituꞌ nog pimiliꞌ non. Si Simun (nog iningolanan non dosop nog si Piter). ");
INSERT INTO suc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tubus nion, og gombataꞌ ni Sebedi nog si Jems bu si Jan (nog iningolanan non dosop og duaꞌ ilan nog si Bardyonis. Somoꞌ ita da og gombataꞌ ilan nog glotiꞌ). ");
INSERT INTO suc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Tubus nion si Andriu, si Pilip, si Bartolomi, si Matiu, si Tomas, bu si Jems og bataꞌ ni Alpius. Tubus nion si Tadius, mangka si Simun og omboluꞌ kituꞌ tumindog nog salu bansa non. ");
INSERT INTO suc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Tubus nion si Judas Iskariot, og miguakil kituꞌ dia ni Isus sog glaꞌat. ");
INSERT INTO suc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tubus nituꞌ, minuliꞌ si Isus sog baloy. Bu modakol nosop og gotowanan nog miglumpuk dianilan nog boyaꞌan ilan nog sulangguꞌanan non, daꞌ ilan na tanan pokosunguꞌ kuman kobal nog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Dangan midongog nog putupusodanan non bu ginaꞌ non og mamaꞌ nion koyon, inangoy nilan ion usibaꞌoy poꞌ long nilan dun, “Konaꞌ non na ion og dan pikilan!” ");
INSERT INTO suc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bu ngon og polopanadanan koyon nog botad nog bansa Hudyu nog miktidu sog Jerusalem, miktaluꞌ ilan dosop nog, “Si Isus sinongonan ni Belsibul. Bianan sog kounutan nog glatdiwataanan, mokobugow ion nog glatdiwataanan!” ");
INSERT INTO suc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dadi, sinabi non og gotowanan nog mokpolani dianon bu mangka non ilan uksugoy bianan sog pononggiꞌan nog, “Olo mogandun kobugow ni Kindagow sog pakasi Kindagow non? ");
INSERT INTO suc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bila sala pigdotuꞌan diꞌ mosulut bu mokpoksusi ilan, ilan bu ilan, ondiꞌ ilan nododaꞌ mikindog. ");
INSERT INTO suc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bu bila og sala kobaloy moksusi ilan, ilan bu ilan, ondiꞌ ilan nododaꞌ mokindog. ");
INSERT INTO suc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bu bila si Kindagow ontuan non og dili glawas non, ombahagiꞌ ion dun. Olo ma mogandun kopindog non nog pigdotuꞌan non? Mimung moglaꞌat da ion dun. ");
INSERT INTO suc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Bu doma maꞌ nini, olo gidoy mogandun kosolod nog gotow dia sog baloy nog gotow kituꞌ nog modasig bu mangka non pongolapoy og balananan nog gotow koyon, lual da boludon non poguna og gotow koyon nog modasig? Ombalud non tibua, malap non na og balananan nog glaki koyon. ");
INSERT INTO suc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Toluꞌon ku dianiu, minsan olo dusaoy dun bu og kopoglakaꞌlakaꞌ nog gotow, kompunan da nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tibua, ain og moglakaꞌlakaꞌ dia sog Bolakat nog Mikpongon, ondiꞌ nododaꞌ kompunan. Poꞌ dusa nog gotow koyon diꞌ mokulog dianon asta sog daꞌ kopus non.” ");
INSERT INTO suc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Saꞌan miktaluꞌ si Isus nog maꞌ nituꞌ poꞌ tinaluꞌ nilan nog, “Si Isus sinongonan nog glatdiwata.” ");
INSERT INTO suc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tubus nituꞌ, minatong na og ginaꞌ non bu og putupusodanan non nog kolokian. Migindog ilan sog glowasan nog baloy bu dinumondag ilan nog gotow nog sumabi dianon. ");
INSERT INTO suc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Og gotowanan koyon nog mikpongingkud dia sog glumibut ni Isus miktaluꞌ ilan nog, “Polopanad, og ginaꞌ mu bu putupusodanan mu nog kolokian, dituꞌ ilan sog glowasan. Moleg ilan moktongow dianika.” ");
INSERT INTO suc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tinumabal si Isus nog, “Sima buan og ginaꞌ u bu putupusodanan ku?” ");
INSERT INTO suc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Liniboyan non nog mata og miglibut koyon dianon mangka poktaluꞌ nog, “Koni og ginaꞌ u bu putupusodanan ku. ");
INSERT INTO suc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Poꞌ simasima og mokokunut nog glegan nog Mikpongon, ilan og putupusodanan ku bu og ginaꞌ u.” ");
INSERT INTO suc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ongon gondow non, mikpanad nosop si Isus sog gotowanan dion sog goksid nog danow koyon. Landuꞌ kodakol nog gotow linumpuk dianon. Dadi, sinumakoy ion sog bolangoy mangka ion ingkud dituꞌ. Bu og gotowanan koyon, dion ilan pogindog sog pontad. ");
INSERT INTO suc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Bu modakol og pinanad non dianilan bianan sog pononggiꞌan. Miktaluꞌ ion nog, ");
INSERT INTO suc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pokinongogoy niu. Ngon sala kotow minangoy sumigwag nog boniꞌ non. ");
INSERT INTO suc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Dangan sinigwag non og boniꞌ koyon, og duma dia mitonaꞌ sog dalan, bu pingoktuk mogdayun nog manukmanukanan. ");
INSERT INTO suc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Og duma sop, dia mitonaꞌ sog dolonitan nog ombabow da og glupaꞌ non. Tinumubuꞌ mogdayun poꞌ ombabow og glupaꞌ non. ");
INSERT INTO suc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tibua, dangan pinodosan, milanos og pomulan koyon poꞌ ondaꞌ pokoponginggamut mahatul. ");
INSERT INTO suc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Og duma sop, dia mitonaꞌ sog sompinitan. Dadi, dangan linumawa og sompinit koyon, miumos og pomulan koyon dun nog boyaꞌan ondaꞌ notanan pokopogbunga. ");
INSERT INTO suc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Og duma sop, dia mitonaꞌ sog monapuꞌ nog glupaꞌ. Dadi, dangan tinumubuꞌ og pomulan koyon, mokosubuk bu pogbunga mangka sinumongkuꞌ. Og duma ginowoyan non sinumongkuꞌ nog glinongowan da, og duma sop sinumongkuꞌ nog pinuluꞌan, bu og duma sinumongkuꞌ nog ginotusan. ");
INSERT INTO suc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Dadi, ain togo tolinga, sumboy pokinongogan non og piktaluꞌ u koni.” ");
INSERT INTO suc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tubus nituꞌ, dangan mikpoguliꞌ na og gotowanan, og sopuluꞌ bu duaꞌ kotow kituꞌ sulangguꞌanan non bu og duma sulangguꞌanan non nog mibagak dion, miksak ilan dianon bog olo og maꞌana nog pononggiꞌananan non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tinumabal si Isus nog, “Amu koyon, pisabut na dianiu og milimod kituꞌ nog paꞌali sog pigdotuꞌan nog Mikpongon. Tibua, ain og gotowanan kituꞌ nog konaꞌ niu sakup, og pomali u dianilan bianan sog pononggiꞌan. ");
INSERT INTO suc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Poꞌ sinulat sog Kitab nog, ‘Mokotongow ilan da bosia, tibua, diꞌ nilan kosunan. Mokinongog ilan da bosia, tibua, ondiꞌ nilan mosabut. Somoꞌ bosia diꞌ ilan maꞌ nituꞌ, mosop da og pikilan nilan dianakon boyaꞌan nog kompunan dusaanan nilan dun.’” ");
INSERT INTO suc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Dadi, long sop ni Isus dianilan, “Diꞌ niu taꞌ mosabut og pononggiꞌan ku koyon? Bila maꞌ nituꞌ nog ondiꞌ niu mosabut, olo ma mogandun kosabut niu nog duma pononggiꞌananan ku?” ");
INSERT INTO suc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Og pononggiꞌan ku koyon, maꞌ nini og maꞌana non. Og polonigwag nog boniꞌ koyon, ion non ion og migustal nog taluꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Dadi, og dalan koyon, ion non ion og gotowanan kituꞌ nog mikodongog nog gustalan paꞌali sog Mikpongon saka inangoy mogdayun owaꞌoy ni Kindagow dia sog dialom pikilan nilan. ");
INSERT INTO suc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Og duma gotowanan sop, mamaꞌ nog dolonitan kituꞌ nog ombabow da og glupaꞌ non nog kitonaꞌan nog boniꞌ. Puꞌun midongog nilan og gustalan kituꞌ nog paꞌali sog Mikpongon, tinabuk nilan dunut daꞌdaꞌan nilan dun. ");
INSERT INTO suc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tibua, daꞌ nilan ungodoy mahatul dia sog pikilan nilan. Tinumud siꞌoy ilan, solianlian da. Poꞌ bila dotongan ilan nog glogon otawaka og posakit sabap sog kotabuk nilan nog gustalan kituꞌ, bolongon nilan mogdayun. ");
INSERT INTO suc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Og duma sop gotowanan, mamaꞌ ilan nog glupaꞌ kituꞌ nog sompinitan nog kitonaꞌan nog boniꞌ. Midongog nilan og gustalan paꞌali sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tibua, kobal nog susaan nilan nog kotubuꞌ nilan, bu sabap sog gloliag nilan nog daya bu miglologinis og glegan nilan, ondaꞌ doksuꞌ nog gustalan kituꞌ dia sog kotubuꞌ nilan. ");
INSERT INTO suc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tibua, og duma gotowanan kituꞌ, mamaꞌ ilan nog glupaꞌ kituꞌ nog monapuꞌ. Midongog nilan og gustalan paꞌali sog Mikpongon bu tinabuk nilan. Dadi, og gustalan kituꞌ sinumongkuꞌ nododaꞌ. Og duma sinumongkuꞌ nog glinongowan, og duma sop sinumongkuꞌ nog pinuluꞌan, bu og duma sinumongkuꞌ nog ginotusan.” ");
INSERT INTO suc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Dadi, miktaluꞌ nosop si Isus dianilan, “Bila tumutud amu nog suluꞌ sog baloy niu, dugbaꞌan niu taꞌ buan nog sibulan otawaka lingodon niu taꞌ og dolag non? Potompalon niu nododaꞌ! ");
INSERT INTO suc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Poꞌ daꞌidun og milingod nog ondiꞌ da ompodolag. Bu ain daꞌ kosabut posobuton dosop da. ");
INSERT INTO suc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ain togo tolinga, sumboy pokinongogan non og piktaluꞌ u koni. ");
INSERT INTO suc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Dadi, potubudoy niu monginongog og pomali u koni poꞌ og galun nog gomiton niu, maꞌ nituꞌ dosop og galun nog Mikpongon dianiu, bu dungagan non pa. ");
INSERT INTO suc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Poꞌ simasima ngon na og sabut non, dungagan pa. Tibua, ain og daꞌidun og balan non dun, minsan og dakoldakol non na, owaꞌon pa dianon.” ");
INSERT INTO suc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Dadi, long sop ni Isus, “Og pigdotuꞌan nog Mikpongon domikian da mamaꞌ nog gotow kituꞌ nog sinumigwag nog boniꞌ. ");
INSERT INTO suc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sog gobi gondow, totanud otawaka totulug ion, tumubuꞌ da og boniꞌ koyon minsan siꞌoy daꞌidun sini sabut non dun. ");
INSERT INTO suc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Og maꞌana non, sabap sog glupaꞌ, saꞌan da tinumubuꞌ og boniꞌ koyon. Sog tagnaꞌ bodos mangka pomunsut mangka na kinug. ");
INSERT INTO suc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ampun minug, gonion na poꞌ minatong og timpu gumani.” ");
INSERT INTO suc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Dadi, long sop ni Isus dun, “Olo bayuꞌbayuꞌ nog pigdotuꞌan nog Mikpongon? Otawaka, ain ta gidoy kopononggiꞌ? ");
INSERT INTO suc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Og pigdotuꞌan nog Mikpongon domikian da mamaꞌ nog bataꞌbataꞌ longow nog pimula dia sog binalan. ");
INSERT INTO suc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Minsan siꞌoy ion og bataꞌbataꞌ longow, dangan tinumubuꞌ na, ion og mosolag sog glam nog pomulananan dion. Bu og pangaanan non pogopunan nog manukmanukanan.” ");
INSERT INTO suc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Dadi, maꞌ nion og gustalan non dianilan paꞌali sog Mikpongon bianan sog pononggiꞌan sog goktob nog ain mosabut nilan. ");
INSERT INTO suc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Daꞌidun gustalan non dianilan nog daꞌ non pobianoy sog pononggiꞌan. Tibua, glam non koyon inustal non kopia dia sog sulangguꞌanan non dangan midoduoy ilan. ");
INSERT INTO suc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dangan miglolabung tibua og bonua, miktaluꞌ si Isus dia sog sulangguꞌanan non, “Alung, mangoy ita dituꞌ sog dipag nog danow koni.” ");
INSERT INTO suc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dadi, sinumakoy ilan dia sog bolangoy koyon nog sinokayan non bu mangka ilan tulak. Ginonatan nilan og modakol nog gotowanan dia sog pontad. Bu ngon duma bolangoyanan nog tinumondug dianilan. ");
INSERT INTO suc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Sintak non ion, miglogoyup nog landuꞌ kolandos. Dadi, kisigoban nog tubig og bolangoy nilan koyon kobal nog nabok nog danow koyon. ");
INSERT INTO suc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Saka si Isus dituꞌ poktulug sog gikam dia sog gulinan nog bolangoy koyon. Dadi, tinanud nilan ion mangka ilan poktaluꞌ, “Polopanad! Potiangon mu taꞌ nog moglaꞌat ita?” ");
INSERT INTO suc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dadi, migbuat ion mangka non polotaꞌoy og galuꞌ koyon bu og nabok mokoluksang. Maꞌ long non dun, “Kotodoꞌ a na.” Dadi, milotaꞌ og galuꞌ bu sododuꞌun tinumodoꞌ tokodoy og danow koyon. ");
INSERT INTO suc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tubus nituꞌ, tinoluꞌan non ilan nog, “Iduma kondokan amu ma? Daꞌidun potaꞌ og kopongandol niu?” ");
INSERT INTO suc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dadi, kiondokan dunut kisobuꞌan ilan bu miksinaksakoy ilan nog, “Sima gidoy og gotow koni nog minsan siꞌoy og galuꞌ bu nabok mogbilang ma dianon!” ");
INSERT INTO suc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Dangan tinumolipag ilan sog danow koyon, sokaliꞌ ilan dinumongguꞌ sog bonua nog Gadarinis. ");
INSERT INTO suc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Dangan tinumukpa si Isus, linumpak ion nog gotow kituꞌ nog tinosopan nog glatdiwata nog dia miktidu sog kolobongan. ");
INSERT INTO suc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Poꞌ dia ion pogonong sog kolobongan. Ondiꞌ na ion ombalud nog minsan siꞌoy glantaylantay. ");
INSERT INTO suc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Poꞌ tatap na ion boludon nog glantaylantay, bu pusasan. Tibua, og glantaylantay koyon mogotus non bu og pusas non koyon mokpokpota poꞌ modasig ion tokodoy. ");
INSERT INTO suc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gobi gondow, sog kolobongan otawaka sog gimbukidan, poginangon non moglosek sog ain kongayan non bu pongongolan non og glawas non nog mokokutong nog batu. ");
INSERT INTO suc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dadi, dangan mitongow non si Isus sog molayuꞌ, ginumobok posunguꞌ dituꞌ non mangka ingluꞌud dia sog sunguꞌan non. ");
INSERT INTO suc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Bu pisikad non taluꞌ non nog, “Olo og dunon mu dianakon Isus, ika, og Bataꞌ a nog Mikpongon nog diꞌ kolobian? Olo gangoy mu dini nakon? Sapa a sog Mikpongon nog diꞌ mu pa akon posinsaon!” ");
INSERT INTO suc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Saꞌan tinaluꞌ non maꞌ nituꞌ poꞌ tinoluꞌan ion ni Isus nog, “Ika og glatdiwata, awaꞌ a na dia sog gotow koyon!” ");
INSERT INTO suc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sinakan ni Isus bog sima ngalan non. Tinumabal ion nog, “Og ngalan ku si Nginibuan poꞌ modakol ami.” ");
INSERT INTO suc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dadi, mingapuꞌngapuꞌ og glatdiwataanan koyon dia ni Isus nog diꞌ ilan pa powaꞌon dia sog bonua koyon. ");
INSERT INTO suc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sog molani nilan koyon, ngon og panun nog babuy nog solian nilan monungkal dia sog pun bilid koyon. ");
INSERT INTO suc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Migbubut og glatdiwataanan koyon dia ni Isus nog dia ilan sangon sog babuyanan koyon. ");
INSERT INTO suc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kinumboy ilan ni Isus. Dadi, mikpongluas ilan tidu sog gotow koyon mangka ilan sangon dia sog babuyanan koyon. Dadi, og panun nog babuyanan koyon, mikponggobok ilan dumiksun mangka ilan pokpongokpu sog danow koyon bu mitipot ilan kolomos. Og dakol nog babuyanan koyon ngon bayuꞌ duaꞌ ngibu. ");
INSERT INTO suc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Dangan mitongow nog polongipat nog babuyanan koyon og maꞌ nion koyon, mikponggobok ilan mangka nilan poguksugoy dituꞌ sog koliwagan bonua koyon. Dadi, inangoy nog gotowanan tontongoy og bianbian koyon. ");
INSERT INTO suc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Dangan minatong ilan dituꞌ ni Isus, mitongow nilan og gotow kituꞌ nog bakas poktosopan nog glatdiwataanan pogingkud dion nog minapot na bu molongas na og pomikilan non. Dadi, kiondokan ilan dun. ");
INSERT INTO suc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Og gotowanan sop nog ain og mikotongow nog bianbian koyon, piguksugan nilan dosop og kibianbianan nog gotow kituꞌ bu babuyanan kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dadi, og gotowanan koyon, pigbubut nilan si Isus nog mawaꞌ pa dion sog bonua nilan koyon. ");
INSERT INTO suc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dadi, pinipini ni Isus sumakoy sog bolangoy nilan, og gotow koyon nog bakas tinosopan nog glatdiwataanan, miksabaꞌ mogunut dianon. ");
INSERT INTO suc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tibua, ondaꞌ ion podunutoy ni Isus. Sugaꞌid non, tinoluꞌan non nog, “Uliꞌ a sog pigoloan mu mangka mu poguksugoy dianilan bog andun kosolag og miinang nog Pogbayaꞌ bu og glolat non dianika.” ");
INSERT INTO suc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dadi, mipanow ion mangka non ulitoy moguksug og glam nog gininang kituꞌ ni Isus dianon dia sog bonua koyon nog iningolanan Sopuluꞌ Kobonua. Ain mikodongog nog guksugan non kituꞌ, kisobuꞌan ilan dun. ");
INSERT INTO suc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Dangan tinumolipag nosop si Isus sog dipag, piglumpukan nosop ion nog landuꞌ kodakol nog gotowanan, dituꞌ sog goksid nog danow koyon. ");
INSERT INTO suc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ngon sop sala kotow dion nog linumumpak dianon nog si Jairus ngalan non. Ion og polongokbit nog solabuk baloy nog poglumpukan nog bansa Hudyu. Minangoy ion mingluꞌud dia sog sunguꞌan ni Isus ");
INSERT INTO suc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mangka ion pongoningoni dianon nog, “Bataꞌ u nog bataꞌlibun, migagowinawa na. Dadi, angoy mu pa doponoy bagun da kumodag bu motubuꞌ.” ");
INSERT INTO suc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dadi, migunut si Isus dianon. Bu landuꞌ kodakol nog gotowanan nog migunut dosop dianilan boyaꞌan nog miglotok ilan tanan. ");
INSERT INTO suc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tubus nituꞌ, ngon sala kotow glibun dion nog poglodasan nog duguꞌ sog solod nog sopuluꞌ bu duaꞌ ton. ");
INSERT INTO suc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Binulung siꞌoy nog polomulunganan, misinsa tibua dun. Poꞌ mitipot non na pogbayad og golotaꞌ non saka pododungag tanan og mosakit non koyon. ");
INSERT INTO suc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Dangan, midongog non og dongogan paꞌali sog kohinangan ni Isus, migapas ion mokopolani sog tolikudan ni Isus poꞌ bagun non motuyok og glogdoy ni Isus koyon. ");
INSERT INTO suc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Poꞌ donsamaꞌ na migdialominawa ion nog minsan siꞌoy sagya motuyok non og glogdoy ni Isus, kuliꞌan na og mosakit non koyon. Dadi, saꞌan ituꞌ migapas ion mokpolani sog tolikudan ni Isus poꞌ bagun non motuyok glogdoy ni Isus koyon. ");
INSERT INTO suc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Puꞌun tinuyok non og glogdoy ni Isus, sododuꞌun milotaꞌ ion poglodasan nog duguꞌ bu mibatik non sog glawas non nog kiuliꞌan na ion. ");
INSERT INTO suc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sododuꞌun, dangan mibatik ni Isus nog ngon linumuas dianon nog bayaꞌ, tinumolikud ion mangka sunguꞌ sog kodokolan nog gotowanan koyon dion, mangka non ilan sakoy bog sima tinumuyok nog glogdoy non. ");
INSERT INTO suc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dadi, miktaluꞌ og sulangguꞌanan non dianon, “Motuyok a nododaꞌ, Polopanad, poꞌ kobal nog dakol nog gotowanan koni nog milodis dianika!” ");
INSERT INTO suc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Liniboyan non og gotowanan koyon nog mata poꞌ ponontongon non bog sima dodaꞌ og tinumuyok kituꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kisunan nog glibun koyon nog kiuliꞌan ion. Dadi, mikpolani ion dia ni Isus mangka sugyut dianon bu pinglukuban ion kobal nog gondok non mangka non suksugoy dia ni Isus glam nog kibianbianan non nog mosakit non koyon. ");
INSERT INTO suc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Dadi, miktaluꞌ si Isus dianon nog, “Ibun, bianan sog kopongandol mu, kiuliꞌan ka. Sugaꞌid non, panow a na bu og kotiknaꞌ nog pikilan mongon dianika poꞌ kiuliꞌan ka na.” ");
INSERT INTO suc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sonuk pa ni Isus moktaluꞌ, ngon og minatong nog gobok nog tidu dituꞌ sog baloy ni Jairus. Miktaluꞌ ilan nog, “Og bataꞌ mu kituꞌ diꞌ nika na mosaꞌut. Dadi, diꞌ ta na pogonggaꞌon og polopanad koyon nog mangoy pa dituꞌ.” ");
INSERT INTO suc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tibua, pitiang ni Isus og guksugan nilan koyon bu poktaluꞌ dia ni Jairus nog, “Naꞌ a mosusa. Sugaꞌid non, tud a.” ");
INSERT INTO suc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Dadi, pigondiꞌan non og gotowanan koyon mogunut dianilan lual da si Piter bu duaꞌ kotow kituꞌ nog pokputupusod nog si Jems bu si Jan og pidunut non. ");
INSERT INTO suc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Dangan minatong ilan sog baloy ni Jairus, mitongow nilan og gotowanan nog landuꞌ na og longosan nilan. ");
INSERT INTO suc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sinumolod ilan sog baloy koyon bu tinoluꞌan ni Isus og gotowanan koyon nog, “Iduma ion, mamaꞌ ma nion og glangka niu? Og bataꞌ koni, ondaꞌ patoy, sugaꞌid non, sagya da ion mitulug.” ");
INSERT INTO suc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dadi, pigwanwan nilan ion dun. Dadi, piliu non og glam nilan sog baloy koyon mangka non onggatoy sumolod og sulangguꞌanan non bu ginaꞌamaꞌ nog bataꞌ koyon, dion sog dugu nog pigbolilidan nog bataꞌ koyon. ");
INSERT INTO suc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pigoidan ni Isus sog komot og bataꞌ koyon bu poktaluꞌ nog, “Talita koum.” Somoꞌ ita da, “Bataꞌlibun, toluꞌon ku dianika, pogbuat a na.” ");
INSERT INTO suc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dadi, migbuat mogdayun og bataꞌ koyon mangka pokpanowpanow dion. Kisobuꞌan ilan tokodoy dun. (Og bataꞌ koyon sopuluꞌ na bu duaꞌ ton tinonan non.) ");
INSERT INTO suc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tibua, pigondiꞌan tokodoy ni Isus mokposun dianilan minsan sima, mangka ion poktaluꞌ nog, “Pokan niu pa bataꞌ koyon.” ");
INSERT INTO suc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Dadi, ginonatan ni Isus og bonua koyon, mangka ion uliꞌ sog dili bonua non. Migunut dianon og sulangguꞌanan non koyon. ");
INSERT INTO suc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Dangan minatong og Gondow nog Pogulali, minangoy nosop si Isus mokpanad sog baloy nog poglumpukan nilan. Bu modakol og gotowanan dion nog mikodongog nog gustalan non koyon bu kisobuꞌan ilan dun. Maꞌ long nilan dun, “Ain gidoy tiniduan nog gotow koni og pikpanad non koyon? Sima gidoy og migbogoy nog kotoan koyon dianon? Minsan siꞌoy og gingyataꞌanan mokopoginang ma dun! ");
INSERT INTO suc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Konaꞌ non taꞌ ion og bataꞌ nog polongimung kituꞌ nog baloy? Konaꞌ non taꞌ ion og bataꞌ kituꞌ ni Maria, nog putupusod ni Jems, bu ni Jusep, bu ni Judas, bu ni Simun? Bu konaꞌ taꞌ ion mikunul ita tanan nog putupusodanan non nog kolibunanan?” Sabap dion kilotonan ilan dianon. ");
INSERT INTO suc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tibua, tinoluꞌan ilan ni Isus nog, “Og polomolatas nog taluꞌ nog Mikpongon pogbotadan minsan ain, lual da dia sog dili bonua non, bu sog dili pigoloan non, bu sog dili baloy non.” ");
INSERT INTO suc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Saꞌan ituꞌ mikaꞌan da og gingyataꞌ nog pitongow non dion lual da ngon mikaꞌan og dinoponan non nog gotowanan bu kiuliꞌan non ilan. ");
INSERT INTO suc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bu kisobuꞌan tokodoy si Isus dun nog diꞌ ilan tumud dianon. Dadi, miguliugan si Isus sog bonuaanan koyon dion mokpanad dia sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sinabi non og sopuluꞌ bu duaꞌ sosuguꞌonanan non koyon nog mokpolani ilan dianon. Poꞌ poponowon non ilan nog doduaꞌ kotow. Bu binogayan non ilan nog bayaꞌ bagun nilan kopogboyaꞌan og glatdiwataanan. ");
INSERT INTO suc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Bu dinondag non ilan nog, “Naꞌ amu mokpitang nog balun niu otawaka og sin niu otawaka og toguꞌan niu. Daꞌ lual sog tagad niu da. ");
INSERT INTO suc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bu solug amu nog pongyapak niu. Naꞌ amu mokpitang nog gimolaan niu. ");
INSERT INTO suc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bu ain og baloy nog tumolimaꞌ dianiu, dion amu na dukon asta gumonat amu sog koliwagan bonua koyon. ");
INSERT INTO suc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tibua, bila daꞌidun sog koliwagan bonua koyon og tumolimaꞌ dianiu bu ompok ilan mokinongog dianiu, bila gumonat amu, pokpasoy niu og glopug nog glupaꞌ nog minokot sog botis niu bagun nilan da kosunan og tandaꞌ nog diꞌ amu na kosakan nog minsan olo og matong dianilan.” ");
INSERT INTO suc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dadi, mipanow ilan mogustal dia sog gotowanan nog sumboy moglilaꞌ bu lumotaꞌ ilan na moginang nog mokodusa. ");
INSERT INTO suc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bu modakol og pimugow nilan nog glatdiwataanan nog tinumosop dia sog gotow. Bu modakol dosop nog gotowanan nog diꞌ mokokodag nog pingoklasan nilan nog glana bu kiuliꞌan ilan dun. ");
INSERT INTO suc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Dadi, og piginang nilan koyon midongog ni Datuꞌ Herod poꞌ og ngalan ni Isus koyon mibantug sog ainain nog bonua. Dadi, kisobuꞌan og gotowanan dun bog iduma mokopoginang ma ion nog gingyataꞌanan. Ngon gotowanan moktaluꞌ nog si Jan nog Polomunyag, mitubuꞌ ion puliꞌ. Saꞌan mokopoginang ion nog kosobuꞌsobuꞌ. ");
INSERT INTO suc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ngon sop moktaluꞌ nog si Isus, ion non dow og polomolatas kituꞌ nog taluꞌ nog Mikpongon nog si Iladya. Bu ngon sop moktaluꞌ nog ion dow og polomolatas mamaꞌ nog polomolatasanan nog taluꞌ nog Mikpongon kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tibua, dangan midongog ni Herod og dongogan kituꞌ paꞌali dia ni Isus, miktaluꞌ ion nog, “Ion non ion, si Jan nog Polomunyag nog sinuguꞌ u kituꞌ mutuk gulu non. Mitubuꞌ ion mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Saꞌan miktaluꞌ si Herod nog maꞌ nituꞌ poꞌ dinondag non mukpaꞌ si Jan mangka pusasoy, bu kolobusuoy. Saꞌan ininang non maꞌ nituꞌ poꞌ sabap dia ni Herodias, og duoy nog kongudan non nog si Pilip. Poꞌ pigduoy ni Herod si Herodias nog saka totubuꞌ pa si Pilip. ");
INSERT INTO suc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Dadi, pigbinaꞌan ni Jan si Herod nog maꞌ long non dun, “Konaꞌ ion og botad nog pogduoyon mu og duoy nog kongudan mu.” ");
INSERT INTO suc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Dadi, sabap dituꞌ, molaton ni Herodias dia ni Jan bu moleg na ion nog bunuꞌon si Jan. Tibua, mologon inangon ");
INSERT INTO suc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","poꞌ si Herod miondok dia ni Jan poꞌ kisunan non si Jan midulus nog gotow bu molonuꞌ pikilan non dia sog Mikpongon. Dadi, inusibaꞌ non si Jan sog kolobusuan koyon. Loliagon siꞌoy si Herod mokinongog nog pomali ni Jan, tibua, mibabong dosop pikilan non dun. ");
INSERT INTO suc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dangan minatong og gondow nog binotaꞌan dia ni Herod, miglokologyaꞌan ion bu pimosunan non og gotowanan nog mokokotas bu doyahananan bu og kounutananan nog sundaluanan tidu sog gliwag nog bonua nog Galili koyon. Dion mikalap si Herodias nog pondayan non. ");
INSERT INTO suc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sonuk nog kologyaꞌan nilan koyon, sinumolod og bataꞌ ni Herodias nog dolaga mangka ion pongigal sog sunguꞌan nog gotowanan. Dadi, kisuꞌatan tokodoy si Herod bu og gotowanan koyon dion nog gigal nog dolaga koyon. Dadi, miktaluꞌ og datuꞌ koyon dia sog dolaga koyon, “Bila maꞌ nion, minsan olo pongonion mu, pongoni mu poꞌ bogoyon ku dianika.” ");
INSERT INTO suc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Bu pitaksiꞌ non sog gotowanan koyon dion og taluꞌ non koyon nog minsan olo pongonion non sopoginongaꞌ siꞌoy nog pigdotuꞌan non bogoyon non da sog dolaga koyon. ");
INSERT INTO suc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dadi, linumiu og dolaga koyon mangka angoy poksak sog ginaꞌ non bog olo ombaꞌis pongonion. Tinumabal ginaꞌ non koyon, “Og pongoni mu og gulu ni Jan nog Polomunyag.” ");
INSERT INTO suc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dadi, migdaliꞌ sumolod mokpuliꞌ og dolaga koyon dituꞌ sog datuꞌ koyon mangka poktaluꞌ nog, “Daꞌidun lual pongonion ku dianika numun kituꞌ lual da og gulu ni Jan nog Polomunyag nog dia botangoy sog tabak.” ");
INSERT INTO suc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Dadi, miksonsol tokodoy bosia og datuꞌ koyon nog taluꞌ non kituꞌ. Tibua, sabap sog kibulugan non na tumaluꞌ bu kitoksiꞌan noma og taluꞌ non kituꞌ nog gotowanan koyon dion nog pomosunan non, ondaꞌ non na bolibadoy og pingoni nog dolaga koyon. ");
INSERT INTO suc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dadi, dinondag non mogdayun og sala kotow sundalu non mangoy dituꞌ sog kolobusuan mutuk nog gulu ni Jan. Dadi, minangoy sundalu koyon sog kolobusuan bu pinutuk non gulu ni Jan ");
INSERT INTO suc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mangka non botangoy sog tabak bu bogoyoy sog dolaga koyon. Ion non nion, tinabuk nog dolaga koyon mangka non bogoyoy sog ginaꞌ non. ");
INSERT INTO suc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dangan midongog nog sulangguꞌanan ni Jan nog minatoy na ion, inangoy nilan olapoy og bangkoy non koyon mangka nilan lobongoy. ");
INSERT INTO suc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Dangan minatong na og sosuguꞌonanan ni Isus kituꞌ tidu mangoy mogustal, piguksugan nilan dia ni Isus og glam nog piginang nilan bu pikpanad nilan. ");
INSERT INTO suc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tubus nituꞌ, miktaluꞌ si Isus nog, “Mangoy ita sog moliliꞌ nog ita ita tibua, poꞌ bagun amu mokulali.” Poꞌ saꞌan tinaluꞌ non maꞌ nituꞌ poꞌ kobon non og gotowanan mokpuliꞌpuliꞌ dituꞌ nilan. Dadi, minsan kokan nilan diꞌ nilan na tanan motayud. ");
INSERT INTO suc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dadi, migbolangoy si Isus bu sulangguꞌanan non koyon posunguꞌ sog bonua nog moliliꞌ. ");
INSERT INTO suc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tibua, mitongow ilan bu kinilolaan ilan nog modakol nog gotowanan sog koliwagan bonuaanan koyon sog goksid nog danow koyon. Dadi, migdaliꞌ og gotowanan koyon moguna dia sog posunguꞌan nilan. ");
INSERT INTO suc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Dangan dinumongguꞌ ilan, mitongow ni Isus nog landuꞌ kodakol og gotowanan dion nog migbagad dianon. Milolat ion dianilan poꞌ mamaꞌ ilan dow nog bilibilianan nog daꞌidun polongipat dun. Bu dion tinolipunan non ilan mokpanad nog gininisan nog pogonadan. ");
INSERT INTO suc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Dangan miglolabung na bonua, mikpolani dianon og sulangguꞌanan non mangka ilan poktaluꞌ nog, “Polopanad, og bonua koni molayuꞌ sog gimbolayan saka glolabung na. ");
INSERT INTO suc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Golom nika na ilan dondagoy ompanow bagun ilan mokoponukat nog ponganon nilan dituꞌ sog koliwagan bonua.” ");
INSERT INTO suc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tibua, tinabal ilan ni Isus nog, “Amu na pogbogoy nog ponganon dianilan.” Dadi, tinabal nilan si Isus nog, “Aba! Og dakol nog gotowanan koyon, og golagaꞌ nog pan nog pokanon dianilan bila soluyon, og golagaꞌ non sala tindanan sog sala kotow gotow bila moginang sog solod nog walu bulan! Mangoy ami taꞌ sumaluy dun mangka pokanoy dianilan?” ");
INSERT INTO suc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sinak ni Isus dianilan nog, “Sanu buk buan pan niu? Angoy niu tontong.” Dangan tinontong nilan, miktaluꞌ ilan nog, “Lima buk da og pan bu duaꞌ buk da og sodaꞌ.” ");
INSERT INTO suc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tubus nituꞌ, dinondag non og sulangguꞌanan non koyon nog pingkudon nilan og glam nog gotowanan koyon sog sigbotan koyon nog ombaꞌis ingkudan. ");
INSERT INTO suc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dadi, miglumpuklumpuk ilan mingkud. Ngon na dion sogatus, ngon na dion lima puluꞌ og piglumpuklumpukan nog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tubus nituꞌ, inimud ni Isus og lima buk pan bu duaꞌ buk sodaꞌ koyon mangka ion tongal sog glangit bu posolomatoy dia sog Mikpongon mangka non pomotioy og pan koyon bu pomogoyoy sog sulangguꞌanan non. Bu pimogoy dosop nog sulangguꞌanan non koyon dia sog gotowanan koyon. Bu pigbobahagiꞌ dosop ni Isus og duaꞌ buk sodaꞌ koyon dia sog glam nilan. ");
INSERT INTO suc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dadi, mikpongongan og glam nilan bu mikpogbosug ilan. ");
INSERT INTO suc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ngon pa og samaꞌ nog gotowanan koyon kuman nog lagaꞌ nog sopuluꞌ bu duaꞌ bogyas og miomud nog sulangguꞌanan koyon dun. ");
INSERT INTO suc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Og dakol nog kinuman nog kolokianan tibua, lima ngibu kotow. ");
INSERT INTO suc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tubus nituꞌ, sododuꞌun pigonat ni Isus poguna og sulangguꞌanan non koyon tumulak posunguꞌ sog Betsaida poꞌ ion pogonaton non pa gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Dangan miksuoy si Isus ilan nog gotowanan koyon, tinumukad ion sog bontud poꞌ mogyakin ion dituꞌ. ");
INSERT INTO suc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dangan miglogobi na, dia na sog titongaꞌ nog danow koyon og bolangoy nog sulangguꞌanan non, bu ion salasala non da sog bontud koyon. ");
INSERT INTO suc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Bu mitongow non og sulangguꞌanan non koyon nog kilogonan ilan momolula poꞌ misonsung nilan og galuꞌ. Dangan migdaliꞌondow tibua og bonua, minangoy si Isus dituꞌ nilan nog mipanow dia sog dibabow nog tubig nog danow koyon. Poꞌ moguna bosia ion dianilan. ");
INSERT INTO suc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Saka dangan mitongow ion nog sulangguꞌanan non nog pokpanow ion sog dibabow nog tubig, baluꞌ nilan dun og mongondok. Dadi, miglosek ilan. ");
INSERT INTO suc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Poꞌ glam nilan koyon mitongow nilan ion bu kiondokan ilan tokodoy dun. Tibua, pigdoyunan ni Isus tumaluꞌ dianilan nog, “Potiknaꞌ niu og pikilan niu! Akon ini! Naꞌ amu kondokan!” ");
INSERT INTO suc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ampun sinumakoy si Isus sog bolangoy nilan koyon mipadok og galuꞌ. Dadi, kisobuꞌan ilan tokodoy dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Poꞌ daꞌ nilan pa kosabut og kopokpokan ni Isus kituꞌ dia sog gotowanan. Poꞌ daꞌ kadal nog pomikilan nilan. ");
INSERT INTO suc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dangan mikotolipag ilan sog danow koyon, sokaliꞌ ilan dinumongguꞌ sog bonua nog Genesaret. Bu linabuꞌ nilan og sinipit nog bolangoy koyon dion. ");
INSERT INTO suc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ampun tinumukpa ilan, kinilolaan si Isus nog gotowanan koyon dion. ");
INSERT INTO suc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dadi, pigdoliꞌan nilan mongangoy og gotowanan sog gliwag nog bonua koyon nog sosuku diꞌ mokokodag bu inoyungan nilan posunguꞌ sog bonua kituꞌ nog kisunan nilan nog dituꞌ si Isus. ");
INSERT INTO suc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bu minsan ainain ion angoy nog gimbolayananan koyon dion sog bukid dibabaꞌ, sosuku nog diꞌ mokokodag dianilan pimotang sog tobuꞌananan poꞌ aluꞌaluꞌ dituꞌ bian si Isus. Bu migbubut ilan dianon nog potuyokon ilan pa nog sagya siꞌoy og sudung nog ponopoton non. Bu glam nog mikotuyok dun, kiuliꞌan ilan. ");
INSERT INTO suc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tubus nituꞌ, ngon og parasiuanan bu polopanadanan nog botad nog bansa Hudyu miktidu sog Jerusalem, piglumpukan nilan nosop si Isus. ");
INSERT INTO suc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mitongow nilan og duma sulangguꞌanan ni Isus kinuman nog saka daꞌ nilan unutoy og botad nog parasiuanan koyon nog kopongugas nilan nog komotanan nilan bila kuman ilan. Dadi, miimung nog kolomuꞌlomuꞌ ilan dow dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Og parasiuanan koyon bu glam nog gotow Hudyu mangka ilan siꞌoy kan sumboy unuton nilan pa poguna og botad nog mokogulang nilan kituꞌ kobon nituꞌ nog kopongugas nilan nog komotanan nilan bila kuman ilan. ");
INSERT INTO suc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bu ngon dosop og kitogadan nilan nog bila matong ilan tidu sog tobuꞌan, diꞌ ilan sokaliꞌ kuman, bila ondiꞌ ilan da mokopongugas poguna. Bu modakol pa duma nog pogbotadon nilan koyon mamaꞌ nog kopongugas nilan nog saguk, og toguꞌan ginumon, bu glangkapanan nog galang dia sog bolokanan.) ");
INSERT INTO suc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Dadi, sinakan si Isus nog parasiuanan koyon bu polopanadanan nog botad bog iduma og sulangguꞌanan non koyon, diꞌ ilan ma mokokunut nog botad nog mokogulang? Kuman ilan ma nog daꞌ ilan pongugas poguna nog komot nilan. ");
INSERT INTO suc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tinabal ilan ni Isus nog, “Motud dodaꞌ og tinaluꞌ nog polomolatas kituꞌ nog si Isaya paꞌali dianiu nog mokpopotongow amu tibua. Sinulat sog Kitab nog, ‘Og gotowanan koni, og kopogadab nilan dianakon taman da nog babaꞌ nilan, tibua, og pomikilan nilan molayuꞌ tokodoy dianakon. ");
INSERT INTO suc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Daꞌidun og maꞌana nog kopoktamuy nilan dianakon poꞌ og pikpanad nilan koyon sagya da polomotadon nog pigimungimung nog sagyaotow.’” ");
INSERT INTO suc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bu long pa ni Isus dun, “Daꞌ niu tombaꞌoy og dondagan nog miktidu sog Mikpongon. Bu sokaliꞌ og pigunut niu og botad nog sagyaotow. ");
INSERT INTO suc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Moto amu sumop nog dondagan nog Mikpongon bagun niu munut og dan nog botad niu. ");
INSERT INTO suc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Poꞌ miktaluꞌ si Muses kobon ituꞌ nog, ‘Pogodaboy niu ginaꞌamaꞌ niu.’ Bu taluꞌ non dosop, ‘Simasima og sumolap monaluꞌ dia sog ginaꞌamaꞌ non, sumboy bunuꞌon.’ ");
INSERT INTO suc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tibua, amu, mokpanad amu nog mogusoy da bila og gotow moktaluꞌ dia sog ginaꞌamaꞌ non nog, og tabang non kituꞌ nog bogoyon non bosia dianilan, iningolanan non na nog Korban. Maꞌana non, og bogoy non kituꞌ inuakil na dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Dadi, minsan siꞌoy kilogonan og mokogulang nog gotow koyon, diꞌ niu na ion tugdakon tumabang dia sog ginaꞌamaꞌ non. ");
INSERT INTO suc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Dadi, bianan sog pogbotadon niu koyon nog polotason niu, pigusayusayan niu sumop og taluꞌ nog Mikpongon. Modakol pa og duma pogbotadon niu nog mamaꞌ nion.” ");
INSERT INTO suc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tubus nituꞌ, sinabi non nosop og gotowanan koyon dion nog mokpolani ilan dianon mangka ion poktaluꞌ nog, “Pokinongog amu tokodoy dianakon glam niu bagun niu mosabut og poktoluꞌon ku koni. ");
INSERT INTO suc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Daꞌidun og sumolod dia sog babaꞌ nog gotow nog boyaꞌan mimung moglomuꞌ ion dun. Sugaꞌid non, ain og lumuas dia sog gotow mimung nog moglomuꞌ ion dun.  ");
INSERT INTO suc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Dadi, ain togo tolinga, sumboy pokinongogan non og piktaluꞌ u koni.” ");
INSERT INTO suc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Dangan ginonatan ni Isus og gotowanan koyon dion, mangka ion solod sog baloy, sinakan ion nog sulangguꞌanan non koyon bog olo maꞌana nog pononggiꞌan non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tinumabal si Isus nog, “Mologon amu dodaꞌ posobutan! Daꞌ niu taꞌ ion kosunoy nog ain sumolod sog babaꞌ nog gotow diꞌ mimung nog moglomuꞌ ion dun? ");
INSERT INTO suc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Poꞌ diꞌ da dia angoy sog pikilan non, sugaꞌid non, dia angoy sog tibuka non mangka na luas.” (Bianan sog taluꞌ ni Isus koni, og maꞌana non daꞌidun og gliꞌinan nog ponganon.) ");
INSERT INTO suc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Bu miktaluꞌ pa ion nog, “Ain lumuas tidu sog gotow, ion non ion og moglomuꞌ dun. ");
INSERT INTO suc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Poꞌ tidu sog dialom pikilan nog gotow, ion non ion og poktiduan og pikilan kituꞌ nog molaton, og momabal, og monakow, og momunuꞌ, bu mogbabal nog konaꞌ non duoy, ");
INSERT INTO suc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","og mogabak, og mogbolotibot, og moksoputi, og diꞌ na mosipog nog glawas non, og mima, og mogbolotibot, og motokabul, bu og moglogumow. ");
INSERT INTO suc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Dadi, glam nog kohinangan nog molaton dia da poktolipun sog pikilan nog gotow bu ion non nion mimung moglomuꞌ ion dun.” ");
INSERT INTO suc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Dangan ginumonat si Isus sog bonua koyon, sokaliꞌ ion minangoy dituꞌ lambul sog molani nog koliwagan bonua nog Tair. Dangan minatong ion dituꞌ, sinumolod sog solabuk baloy poꞌ ompok bosia ion kosunan nog gotowanan nog dion ion. Tibua, kisunan da ion nog gotowanan nog dion da ion. ");
INSERT INTO suc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ngon og glibun dion nog og bataꞌ non nog glibun tinosopan nog glatdiwata. Dangan midongog non nog dion si Isus, minangoy ion dituꞌ bu ingluꞌud sog sunguꞌan non. ");
INSERT INTO suc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Og glibun koyon konaꞌ og gotow Hudyu bu dituꞌ ion binataꞌ sog bonua nog Ponisia nog misakup sog bonua nog Siria. Mikilolat ion dia ni Isus nog bugowon pa ni Isus og glatdiwata kituꞌ nog tinumosop dia sog bataꞌ non koyon. ");
INSERT INTO suc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tinabal ion ni Isus nog, “Pokanon ta pa poguna og gombataꞌanan asta ombosug ilan poꞌ ondiꞌ pia nog olapon og ponganon nog gombataꞌanan koyon mangka tikpuꞌoy dia sog gayamanan.” ");
INSERT INTO suc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tinabal non si Isus, “Kounutan, motud ion. Tibua, minsan og gayamanan nog dia sog silung nog glomisahan, mokokan ilan da nog mumu nog gombataꞌanan koyon nog modogdag dia sog salog.” ");
INSERT INTO suc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dadi, long ni Isus dun, “Sabap sog tabal mu koyon, mokodyadi a na muliꞌ poꞌ og glatdiwata kituꞌ minawaꞌ na sog glawas nog bataꞌ mu.” ");
INSERT INTO suc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dadi, minuliꞌ glibun koyon. Dangan minatong ion, mitongow non og bataꞌ non koyon pogbobolilid sog dolopaꞌan non bu og glatdiwata kituꞌ daꞌ na dia. ");
INSERT INTO suc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Dangan ginumonat si Isus sog bonua koyon nog Tair, dituꞌ ion minian sog Sidon posunguꞌ sog danow koyon nog Galili. Bu minian pa sog bonua kituꞌ nog iningolanan nog Sopuluꞌ Kobonua. ");
INSERT INTO suc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Dadi, dangan minatong ion dituꞌ sog bonua kituꞌ, ongon og gotow nog mibongol bu kugol pa nog inagak nog gotowanan dituꞌ ni Isus. Mikilolat ilan dianon nog doponan non pa og gotow koyon. ");
INSERT INTO suc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dadi, inagak ni Isus og bongol koyon sog molayuꞌlayuꞌ mangka non losukoy og duaꞌ mogimpang tolinga nog gotow koyon, mangka ion dulaꞌ sog komot non bu dulitoy sog dilaꞌ nog gotow koyon, ");
INSERT INTO suc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","mangka ion tongal bu pogoksudinawa bu poktaluꞌ dianon nog, “Epata!” Somoꞌ ita da, kosuang a! ");
INSERT INTO suc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sododuꞌun og gotow koyon mikodongog bu misuang na taluꞌ non. Bu mokopogabitabit na mahatul. ");
INSERT INTO suc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Bu pigondiꞌan ilan ni Isus nog diꞌ nilan poguksugan minsan sima otowoy. Tibua, pigondiꞌan non siꞌoy ilan, angkin nilan tanan poguksugoy dia sog gotowanan dion. ");
INSERT INTO suc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Landuꞌ ilan tokodoy kosobuꞌoy dun. Poꞌ maꞌ long nilan dun, “Og glam nog gininang ni Isus koyon, og kopoginang non dun ombaꞌis. Poꞌ minsan siꞌoy og gotow nog bongol bu og kugol, kuliꞌan non.” ");
INSERT INTO suc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ngon gondow non, piglumpukan nosop si Isus nog modakol nog gotowanan. Og gotowanan koyon, daꞌidun na og ponganon nilan. Dadi, sinabi ni Isus og sulangguꞌanan non koyon mangka ion poktaluꞌ dianilan, ");
INSERT INTO suc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Milolat u nog gotowanan koni. Poꞌ sog solod nog tolu gobi bu tolu ondow ilan dini nakon, kinobus ilan na nog ponganon. ");
INSERT INTO suc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bu bila dondagon ku ilan muliꞌ, gomonsunoy ombuksak ilan sog dalan kobal nog gutom nilan poꞌ og duma dianilan molayuꞌ og guliꞌan non.” ");
INSERT INTO suc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tinabal ion nog sulangguꞌanan non koyon nog, “Dadi, olo ma ini pondayan ta? Daꞌidun ma og kolapan ta nog ponganon nog pokpokan ta dianilan dini sog bonua koni nog molayuꞌ sog gimbolayan.” ");
INSERT INTO suc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dadi, miksak si Isus dianilan nog, “Sanu buk buan og pan niu dion?” Tinumabal ilan nog, “Pitu buk da og pan dini.” ");
INSERT INTO suc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dadi, dinondag ni Isus og gotowanan koyon mokpongingkud. Dangan mitabuk non og pitu buk pan kituꞌ, pisolomatan non dia sog Mikpongon bu pomotioy og pan kituꞌ mangka non pomogoyoy sog sulangguꞌanan non koyon. Bu pimogoy sop nog sulangguꞌanan non dia sog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bu ngon sop mikaꞌan og sodaꞌ nilan nog mokolintokon. Tubus ion mokposolamat dia sog Mikpongon, binogoy non dia sog sulangguꞌanan non og sodaꞌanan kituꞌ nog mokolintok mangka non dondagoy momogoy dia sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dadi, mikpongongan og glam nilan koyon bu mikpogbosug ilan. Ngon pa og samaꞌ nog gotowanan koyon kuman nog lagaꞌ nog pitu bogyas nog mikpokponuꞌ og miomud nog sulangguꞌanan koyon. ");
INSERT INTO suc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Og dakol nog gotowanan koyon nog kinuman dun lagaꞌ nog pat ngibu. Tubus nituꞌ, dangan pigonat ni Isus og gotowanan koyon, ");
INSERT INTO suc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","migdayun ilan nog sulangguꞌanan non sumakoy dia sog bolangoy bu tinumulak ilan posunguꞌ sog bonua nog Dalmanuta. ");
INSERT INTO suc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dadi, dangan minatong ilan dituꞌ sog bonua koyon, linumpak ilan nog parasiuanan poꞌ poksulaysulayan nilan ion bianan sog kopongambat nilan nog gingyataꞌ dianon nog tidu dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Migoksudinawa si Isus mangka ion poktaluꞌ nog, “Iduma og gotowanan numun koni, mongambat ilan ma sop nog gingyataꞌ? Toluꞌon ku dianiu, daꞌidun og gingyataꞌ nog potongowon dia sog gotowanan numun koni.” ");
INSERT INTO suc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dadi, ginonatan ilan ni Isus. Sinumakoy ilan nosop sog bolangoy, mangka ilan tulak posunguꞌ sog dipag nog danow koyon. ");
INSERT INTO suc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mikolingow og sulangguꞌanan non koyon mogbalun nog pan lual da sog solabuk og mioit nilan. ");
INSERT INTO suc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Pidonsamaꞌ ni Isus tumaluꞌ dianilan nog, “Pokpotubud bu pongandam amu bagun amu ondiꞌ moit nog pokpotulin nog pan nog parasiuanan bu og pokpotulin dosop ni Herod.” ");
INSERT INTO suc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dadi, migabitabit sulangguꞌanan non koyon nog ilan da bu ilan paꞌali sog tinaluꞌ non kituꞌ. Maꞌ long nilan dun, “Saꞌan bayuꞌ tinaluꞌ non nog maꞌ nituꞌ poꞌ daꞌ ita pokopogoit nog ponganon ta.” ");
INSERT INTO suc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tibua, kisunan da ni Isus og pigobitobitan nilan koyon. Dadi, tinoluꞌan non ilan nog, “Iduma maꞌ nion ma og poktoluꞌon niu? Og pigolong u koni, konaꞌ nog daꞌ amu pogoit nog ponganon. Daꞌ niu pa taꞌ sibon kotongow otawaka kosabut? Mologon amu dodaꞌ pokposobutan! ");
INSERT INTO suc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Togo mata amu bosia saka iduma ion diꞌ amu ma mokotongow? Togo tolinga amu bosia saka iduma ion diꞌ amu ma mokodongog? Diꞌ niu taꞌ buan kolobotan? ");
INSERT INTO suc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tubus u kituꞌ pomotioy og lima buk pan nog mikokan dun og lima ngibu gotowanan, sanu bogyas ituꞌ og miomud niu nog samaꞌ nilan kuman dun?” Tinabal nilan ion, “Sopuluꞌ bu duaꞌ bogyas.” ");
INSERT INTO suc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sinakan ilan nosop ni Isus, “Dangan pimoti u og pitu buk pan kituꞌ nog saka pat ngibu gotowanan og kinuman dun, sanu bogyas og miomud niu nog samaꞌ nilan kuman dun?” Tinabal nilan ion, “Pitu bogyas.” ");
INSERT INTO suc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dadi, sinakan non ilan nog, “Dadi, ondaꞌ niu potaꞌ kosabut og maꞌana nog piktaluꞌ u komun paꞌali sog pokpotulin nog pan?” ");
INSERT INTO suc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Dadi, minatong ilan sog koliwagan bonua nog Betsaida. Ngon og buta dion nog pigagak nog gotowanan dituꞌ ni Isus. Mikilolat ilan dianon nog doponan non pa og buta koyon. ");
INSERT INTO suc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dadi, inagak ni Isus og buta koyon sog gunanunan nog gimbolayan koyon. Tubus nituꞌ, dinulaꞌan non og mata nog buta koyon mangka non doponoy. Bu sinakan non ion bog mokotongow notaꞌ. ");
INSERT INTO suc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dangan tinumingag og buta koyon, long non dun, “Mokotongow u na nog gotow, tibua, mamaꞌ nog kayu pokpanow.” ");
INSERT INTO suc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dadi, dinoponan nosop ni Isus og duaꞌ mogimpang mata non koyon. Bu mioksud na maꞌ nog dan og tinontongan non bu mikotongow na mahatul. ");
INSERT INTO suc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Dinondag ni Isus og gotow koyon muliꞌ bu pigondiꞌan non mian sog koliwagan bonua koyon nog Betsaida. ");
INSERT INTO suc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Dadi, migdayun si loꞌ Isus dituꞌ sog gimbolayananan sog glumibut nog koliwagan bonua nog Sisaria Pilipi. Sonuk nilan ompanow, sinakan ni Isus og sulangguꞌanan non koyon nog, “Sima u gidoy long nog gotowanan dun?” ");
INSERT INTO suc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tinumabal ilan nog, “Og duma mokpoktaluꞌ ilan nog ika dow si Jan nog Polomunyag. Og duma sop mokpoktaluꞌ ilan nog ika dow si Iladya, og polomolatas nog taluꞌ nog Mikpongon kobon nituꞌ. Bu og duma sop mokpoktaluꞌ ilan nog ika dow og solabuk og polomolatas nog taluꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sinakan non sop ilan nog, “Bila buan amu, sima u gidoy?” Tinumabal si Piter, “Ika og Kristu.” ");
INSERT INTO suc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dadi, pigondiꞌan non ilan moguksug paꞌali dianon sog minsan sima. ");
INSERT INTO suc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tubus nituꞌ, miktolipun si Isus mogustal dianilan nog sumboy og Binataꞌ sog Kilawan posinsaon ion tokodoy bu pogbongkison ion nog kobogolalan, og mokokotas nog boliananan, bu og polopanadanan nog botad nog bansa Hudyu. Bu sumboy ion bunuꞌon. Tibua, sog kotolu ondow non, motubuꞌ da ion puliꞌ. ");
INSERT INTO suc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Pitampal non dianilan og posunguꞌan non koyon bagun nilan mosabut. Dadi si Piter, inagak non si Isus sog molayuꞌlayuꞌ mangka non bosia pomagoy moktaluꞌ dun og maꞌ nituꞌ kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tibua, sinumunguꞌ si Isus sog duma sulangguꞌanan non koyon kobon non mogbantoy dianilan mangka non sop pogbinaꞌoy si Piter. Long non dun, “Soitan, awaꞌ a dini nakon! Poꞌ og pomikilan mu koyon dia miktidu sog sagyaotow, ondaꞌ dia miktidu sog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dadi, sinabi ni Isus og gotowanan koyon dion bu og sulangguꞌanan non nog mokpolani pa dianon mangka ion poktaluꞌ nog, “Simasima moleg mogunut dianakon sumboy tolikudan non og dili glegan non mangka non pisanoy og kudus non bu pogunut dianakon. ");
INSERT INTO suc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Poꞌ simasima og landuꞌ kopogapas non nog dili kotubuꞌ non, kobolongan da ion dun. Tibua, simasima og lamig non na bolongon og dili kotubuꞌ non sabap sog kopokokunut non dianakon bu sog Gombaꞌis nog Guksugan paꞌali sog Mikpongon, kongonan ion nog kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Poꞌ olo gidoy buan og glongas non nog makod nog gotow og daya sog tibuk nog dunya koni saka, ombolong og glimukud non? ");
INSERT INTO suc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kobolosan taꞌ nog gotow og dili glimukud non? ");
INSERT INTO suc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Sog tang nog numun koni og gotowanan bolodusaon bu momungyas ilan dia sog Mikpongon. Dadi, simasima og mosipog dianakon bu dia sog pomali u, akon, og Binataꞌ sog Kilawan, mosipog u dosop dianon, sog tang nog kopokpuliꞌ u dunut silow nog kotas nog Gamaꞌ u nog ion og Mikpongon bu asta og moloikatanan non kituꞌ nog mosigda.” ");
INSERT INTO suc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Bu long pa ni Isus dianilan, “Toluꞌon ku dianiu, ngon og dumaanan ta dini nog ondiꞌ ilan pa tagad patoy taman da ondiꞌ nilan motongow og kopogdatuꞌ nog Mikpongon dunut og bayaꞌ non nog diꞌ kolobian.” ");
INSERT INTO suc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Gonom gobi tidu dituꞌ, inoit ni Isus tumukad si loꞌ Piter, si Jems, bu si Jan dituꞌ sog molawa nog bontud nog ilan da bu ilan. Dangan minatong ilan dituꞌ, mitongow nilan nog miksop og bayuꞌbayuꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Bu sinumilow og ponopoton non nog landuꞌ koputiꞌ. Daꞌidun og gotow sog dunya og mokokula nog ponopoton nog maꞌ nog koputiꞌ nog ponopoton ni Isus koyon. ");
INSERT INTO suc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Gomonsunoy pa, ngon duaꞌ kotow tinumuaꞌ si Iladya bu si Muses. Migabitabit ilan ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Dadi, miktaluꞌ si Piter dia ni Isus nog, “Polopanad, ombaꞌis da nog mikodini ami. Mogimung ami nog tolu buk glokowlokow, solabuk dianika, solabuk dia ni Muses, bu solabuk dia ni Iladya.” ");
INSERT INTO suc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ondiꞌ kosunan ni Piter bog olo poktoluꞌon non poꞌ kiondokan ilan tokodoy.) ");
INSERT INTO suc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tubus nituꞌ, og ginampol mikpotondong dianilan bu ngon og taluꞌ nog midongog nilan miktidu sog ginampol koyon nog maꞌ nini, “Koni og bataꞌ u, nog kololaman ku. Pokinongog amu dianon.” ");
INSERT INTO suc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gomonsunoy pa, dangan tinumontong ilan, sala dona ni Isus og mitongow nilan. ");
INSERT INTO suc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sonuk nilan dumiksun tidu sog bontud koyon, pigondiꞌan ni Isus moguksug dianilan sog minsan sima og paꞌali dia sog mitongow nilan kituꞌ tontal da ondiꞌ motubuꞌ puliꞌ tidu matoy og Binataꞌ sog Kilawan. ");
INSERT INTO suc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dadi, og tinaluꞌ non koyon tinaguꞌ nilan sog dialom pikilan nilan mangka ilan poksinaksakoy nog ilan bu ilan bog olo dodaꞌ og maꞌana nog poktoluꞌon non koyon nog motubuꞌ puliꞌ tidu matoy. ");
INSERT INTO suc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bu sinakan nilan ion nog, “Iduma og polopanadanan koyon nog botad nog bansa Hudyu, moktaluꞌ ilan ma nog mokuna pa tuaꞌ si Iladya mangka siꞌoy tuaꞌ og Pipangoy kituꞌ nog Mikpongon Mogdatuꞌ?” ");
INSERT INTO suc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tinabal ilan ni Isus, “Oꞌo, motud ion nog mokuna si Iladya poꞌ oksudon non og glam non. Bu sinulat dosop sog Kitab nog og Binataꞌ sog Kilawan, sumboy posinsaon tokodoy bu pogbongkison. ");
INSERT INTO suc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tibua, toluꞌon ku dianiu nog, si Iladya, minatong na. Bu ininang nilan na dianon minsan olo og kolegan nilan moginang. Mituman na og sinulat kituꞌ sog Kitab paꞌali dianon.” ");
INSERT INTO suc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Dadi, dangan minatong ilan sog duma sulangguꞌanan non koyon, kidotongan nilan nog modakol og gotowanan nog miglibut dia sog sulangguꞌanan non koyon sonuk nilan moktinobaloy nog polopanadanan nog botad nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Dangan mitongow nog gotowanan koyon si Isus, migdaꞌdaꞌ ilan tokodoy bu mikponggobok ilan lumumpak dianon. ");
INSERT INTO suc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tubus nituꞌ, sinakan ilan ni Isus bog olo og piktinobalan nilan koyon. ");
INSERT INTO suc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ngon og sala kotow dion tinumabal dia ni Isus nog, “Polopanad, pinitang u bosia og bataꞌ u nog glaki dini nika poꞌ tinosopan ion nog glatdiwata boyaꞌan nog migbod tanan ion dun. ");
INSERT INTO suc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Giap nog matong dianon, ombuksak ion bu mogbulaꞌ babaꞌ non bu mokigot ngisi non mangka pongogel glawas non. Mikitabang u na bosia dia sog sulangguꞌanan mu koyon nog bugowon nilan pa, tibua, daꞌ da pogbilang dianilan.” ");
INSERT INTO suc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dadi, miktaluꞌ si Isus nog, “Amu, og gotowanan numun koni, diꞌ amu dodaꞌ tumud. Andun pa kopayat og gobon ku mokunul dianiu? Andun kopayat og gobon ku moglogaga dianiu? Oit niu dini og bataꞌ koyon.” ");
INSERT INTO suc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dadi, inoit nilan bataꞌ koyon dion ni Isus. Dangan mitongow nog glatdiwata koyon si Isus, binuksak non mogdayun bataꞌ koyon mangka non poledeoy bu pibulaꞌ non og babaꞌ nog bataꞌ koyon. ");
INSERT INTO suc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sinakan ni Isus og gamaꞌ nog bataꞌ koyon bog nanu pa miktolipun dianon og maꞌ nion koyon. Tinumabal ion nog, “Tidu pa sog kiikaꞌ non. ");
INSERT INTO suc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bu tatap na buksakon bataꞌ u koni nog glatdiwata koyon dia sog gapuy bu dia sog tubig poꞌ bagun ion moglaꞌat. Dadi, bila ngon og minang mu sog bataꞌ u koni, lolatoy mu pa ami bu tobangoy mu pa ami.” ");
INSERT INTO suc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tinabal ni Isus ion, “Iduma moktaluꞌ a ma maꞌ nion? Toluꞌon ku dianika, og glam non, minang nog Mikpongon sog ain og mongandol dianon.” ");
INSERT INTO suc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dadi, tinumabal mogdayun og gamaꞌ nog bataꞌ koyon nog, “Mongandol u na! Sugaꞌid non, tobangoy mu akon bagun da ompagon og kopongandol u!” ");
INSERT INTO suc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dangan mitongow ni Isus nog modakol gotowanan nog mikponggobok posunguꞌ dituꞌ non, binugow non og glatdiwata koyon. Maꞌ long non dun, “Ika, glatdiwata nog mokobongol bu mokopogbod, awaꞌ a na sog glawas nog bataꞌ koni bu naꞌ a na pokpuliꞌ dianon.” ");
INSERT INTO suc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dadi, miglosek og glatdiwata koyon bu pilede non nosop og bataꞌ koyon mangka na awaꞌ. Og bataꞌ koyon mamaꞌ tanan nog bangkoy. Dadi, miktaluꞌ gotowanan koyon dion nog, “Minatoy na, suꞌusa bataꞌ koyon.” ");
INSERT INTO suc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tibua, pigoidan ni Isus sog komot og bataꞌ koyon mangka non buatoy. Bu minindog doma og bataꞌ koyon. ");
INSERT INTO suc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dangan miksuoy ilan tibua nog gotowanan koyon, si Isus bu og sulangguꞌanan non, sinumolod ilan dia sog baloy nog ilanilan da. Bu miksak og sulangguꞌanan non dianon nog, “Iduma, bila ami og mugow nog glatdiwata kituꞌ, ondiꞌ nami ma ombugow?” ");
INSERT INTO suc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tinumabal si Isus nog, “Og glatdiwata nog maꞌ nion koyon ondiꞌ nododaꞌ lumuas, bog diꞌ da bianan sog gyakin.” ");
INSERT INTO suc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Minawaꞌ si Isus bu sulangguꞌanan non sog bonua koyon mangka ilan bian sog Galili. Ompok bosia si Isus nog kosunan nog gotowanan bog ain ilan dun. ");
INSERT INTO suc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Poꞌ solian non pa mokpanad sog sulangguꞌanan non. Bu miktaluꞌ ion dianilan nog, “Og Binataꞌ sog Kilawan uokilon dia sog bayaꞌ nog gotowanan bu bunuꞌon nilan ion. Tibua, sog kotolu ondow non tidu nilan bunuꞌon, motubuꞌ da ion puliꞌ.” ");
INSERT INTO suc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tibua, daꞌ nilan kosabut og maꞌana nog piktaluꞌ ni Isus koyon dianilan bu mondok ilan sumak dun. ");
INSERT INTO suc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dadi, minatong ilan sog Kapernaum. Dangan sinumolod ilan dia sog baloy, sinakan ni Isus sulangguꞌanan non koyon bog olo og piksusian nilan kituꞌ sog dalan. ");
INSERT INTO suc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Daꞌ ilan pogonekonek poꞌ og piksusian nilan kituꞌ sog dalan paꞌali bog sima og motas dianilan. ");
INSERT INTO suc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dadi, miningkud si Isus mangka non sobioy og sopuluꞌ bu duaꞌ sulangguꞌanan non koyon nog mokpolani ilan pa dianon mangka ion poktaluꞌ nog, “Simasima moleg nog ion mokuna, sumboy moksolibinayaꞌ ion. Bu sumboy dosop ion og sosuguꞌon sog glam niu.” ");
INSERT INTO suc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ngon og bataꞌ dion nog piindog ni Isus sog titongaꞌ nilan koyon. Kinokop non kobon non moktaluꞌ nog, ");
INSERT INTO suc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Simasima og tumolimaꞌ dia sog mamaꞌ nog bataꞌ koni sabap sog kopokokunut non dianakon, tinolimaꞌ non dosop akon. Bu bila tinolimaꞌ non akon, konaꞌ u tinolimaꞌ non. Sugaꞌid non, og tinolimaꞌ non, og dinumondag kituꞌ dianakon mangoy dini.” ");
INSERT INTO suc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Miktaluꞌ si Jan dia ni Isus nog, “Polopanad, mikotongow ami nog gotow nog mimugow nog glatdiwataanan bianan sog ngalan mu. Dadi, pigondiꞌan nami poꞌ konaꞌ ta ion og sakup poꞌ daꞌ ion pogunutunut dianita.” ");
INSERT INTO suc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tinumabal si Isus nog, “Naꞌ niu ion pogondiꞌan poꞌ ondaꞌidun og moginang nog kosobuꞌsobuꞌ nog ginang bianan sog ngalan ku nog tubus nituꞌ solapon non akon monaluꞌ. ");
INSERT INTO suc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Poꞌ simasima diꞌ sumusi dianita sugutan non ita. ");
INSERT INTO suc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Poꞌ toluꞌon ku dianiu, simasima mokpinum nog tubig dianiu sabap sog kopokokunut niu dia sog Kristu, ondiꞌ da ombolong og tumbas dun dianon.” ");
INSERT INTO suc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tibua,” long pa ni Isus dun, “simasima og mokongulan sog sala kotow nog tinumud dianakon maꞌ nog bataꞌ koni nog boyaꞌan mokodusa ion dun, golom na lentengoy nog mosolag nog gilingan batu og glig non mangka lobuꞌoy sog dibabaꞌ dagat. ");
INSERT INTO suc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Dadi, bila sabap sog komot mu mokodusa a dun, golom nika na putuk. Poꞌ golom pa nog kongonan ka nog kotubuꞌ nog daꞌ kopus non minsan siꞌoy sobolaꞌ da og komot mu, gabaꞌ nog sigbuon og tibuk nog glawas mu dia sog danow nog gapuy.  ");
INSERT INTO suc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‘Poꞌ og gulod dituꞌ diꞌ na matoy bu diꞌ na ompalong og gapuy dituꞌ.’ ");
INSERT INTO suc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Bu bila sabap sog botis mu mokodusa a dun, golom nika na putuk. Poꞌ golom pa nog kongonan ka nog kotubuꞌ nog daꞌ kopus non nog daꞌ siꞌoy og botis mu, gabaꞌ nog sigbuon og tibuk nog glawas mu dia sog danow nog gapuy.  ");
INSERT INTO suc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‘Poꞌ og gulod dituꞌ diꞌ na matoy bu diꞌ na ompalong og gapuy dituꞌ.’ ");
INSERT INTO suc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bu bila sabap sog mata mu mokodusa a dun, golom nika na uning. Poꞌ golom pa nog mokampuꞌ a sog pigdotuꞌan nog Mikpongon nog sobolaꞌ da og mata mu, gabaꞌ nog duaꞌ mogimpang mata mu saka sigbuon ka dia sog danow nog gapuy. ");
INSERT INTO suc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Poꞌ og gulod dituꞌ diꞌ na matoy bu diꞌ na ompalong og gapuy dituꞌ.’” ");
INSERT INTO suc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Bu long sop ni Isus dianilan, “Glam nog gotow dini sog glupaꞌan kobianan da nog sinsaan nog ion non ion maꞌ nog gapuy. ");
INSERT INTO suc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Bu og masin, ombaꞌis. Tibua, bila molubas na og kasin non, ondiꞌ nododaꞌ masin mokpuliꞌ. Amu siꞌoy sumboy kosinan og kotubuꞌ niu, somoꞌ ita da, mokpaꞌat og kotubuꞌ niu bagun amu da moglogomigus nog pakasi niu.” ");
INSERT INTO suc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Dadi, minawaꞌ si Isus sog koliwagan bonua koyon bu angoy dituꞌ sog Judia bu dituꞌ sog bonua nog sog dipag nog Jurdan. Dangan minatong ilan dituꞌ, piglumpukan nosop ion nog modakol nog gotowanan. Dadi, pikponadan non ilan poꞌ maꞌ nituꞌ og kiloyaman non. ");
INSERT INTO suc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ngon og parasiuanan mikpolani dianon bu pigolapsobapan bu piksulaysulayan nilan og kotoan non bianan sog sak nilan nog, “Og botad dotaꞌ nog og gotow bolongon non og glibun non?” ");
INSERT INTO suc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Dadi, tinumabal si Isus nog, “Olo buan og dondagan ni Muses dianiu?” ");
INSERT INTO suc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tinumabal ilan nog, “Tinugdak ni Muses nog og glaki, bila bolongon non og glibun non, sumboy tumulun poguna nog gitas mangka non siꞌoy uokiloy og glibun non.” ");
INSERT INTO suc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tibua, tinabal ilan ni Isus nog, “Saꞌan ituꞌ tinugdak dianiu bianan sog sinulat ni Muses poꞌ sabap sog kopongantu niu. ");
INSERT INTO suc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tibua, sog tolipunan nog dunya, ‘Og Mikpongon, piongon non og glaki bu og glibun.’ ");
INSERT INTO suc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Saꞌan ituꞌ og glaki, gonatan non og ginaꞌamaꞌ non mangka ion ampuꞌ sog glibun non. ");
INSERT INTO suc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Bu og duaꞌ ilan koyon mimung nog salulawas ilan na. Dadi, konaꞌ na nog duaꞌ kotow, sugaꞌid non, miksolabuk ilan na.’ ");
INSERT INTO suc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dadi, ain og pigampuꞌ nog Mikpongon, sumboy ondiꞌ popogbolongon nog sagyaotow.” ");
INSERT INTO suc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bu dangan minuliꞌ ilan na sog baloy, sinak nog sulangguꞌanan non dianon bog olo maꞌana nog tinaluꞌ non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Dadi, tinabal non ilan nog, “Simasima og molong nog glibun non bu mogduoy sog len, mokodusa ion dun poꞌ mimabal ion nog konaꞌ non og duoy. ");
INSERT INTO suc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bu domikian dosop sog glibun, bila bolongon non og glaki non bu mogduoy sog len, mokodusa ion dun poꞌ mimabal ion nog konaꞌ non og duoy.” ");
INSERT INTO suc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tubus nituꞌ, ngon og gotowanan nog mikpogoit nog gombataꞌanan nilan dia ni Isus bagun non ilan kodoponan. Tibua, pimag ilan nog sulangguꞌanan ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Dangan ion mitongow ni Isus, milaton non bu tinoluꞌan non ilan nog, “Potiang niu og gombataꞌanan koyon mokpolani dianakon. Naꞌ niu ilan pogondiꞌan. Poꞌ maꞌ nog gombataꞌanan koyon, og gotowanan nog misakup sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Toluꞌon ku dianiu, simasima ondiꞌ tumabuk nog kopogdatuꞌ nog Mikpongon mamaꞌ nog kotabuk nog bataꞌ koni dianakon, ondiꞌ nododaꞌ ion mokampuꞌ sog pigdotuꞌan non.” ");
INSERT INTO suc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dadi, pingokop non og gombataꞌanan koyon mangka non ilan doponoy kobon non mokpopia dianilan. ");
INSERT INTO suc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tubus nituꞌ, sog daliꞌdaliꞌ na gonat si Isus, ngon og gotow ginumobok dituꞌ non mangka ingluꞌud sog sunguꞌan non bu poktaluꞌ nog, “Polopanad, ombaꞌis a tokodoy. Olo gidoy sumboy inangon ku bagun ku malap og kotubuꞌ nog daꞌ kopus non?” ");
INSERT INTO suc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tinumabal si Isus nog, “Iduma ingolanan mu ma akon nog ombaꞌis? Saka daꞌidun og ombaꞌis lual da og Mikpongon? ");
INSERT INTO suc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kosunan mu da og dondagananan nog Mikpongon nog sinulat ni Muses nog, ‘Naꞌ a momunuꞌ, naꞌ a momabal nog konaꞌ mu duoy, naꞌ a monakow, naꞌ a tumaksiꞌ nog gloput, naꞌ a moglimbung, bu pogbotadoy mu ginaꞌamaꞌ mu.’” ");
INSERT INTO suc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tinumabal og glaki koyon nog, “Polopanad, glam non koyon pigunut u na tidu pa sog kikaꞌan ku.” ");
INSERT INTO suc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dadi si Isus, pigbontayan non gotow koyon bu milolat ion dun. Bu long non dun, “Ngon pa solabuk kulang mu nog sumboy inangon mu. Angoy mu poksaluy og pogongonon mu mangka mu pomogoy og saluy non dia sog miskinananan poꞌ mogdaya a dun dituꞌ sog glangit. Tubus nituꞌ, pokpuliꞌ a mangka a pogunut dianakon.” ");
INSERT INTO suc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dangan midongog nog glaki koyon og taluꞌ ni Isus koyon, mipanguꞌ ion dun mangka awaꞌ poꞌ doyahan ion tokodoy. ");
INSERT INTO suc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Liniboyan ni Isus nog mata og sulangguꞌanan non koyon mangka poktaluꞌ nog, “Mologon dodaꞌ tokodoy og gotow nog doyahan nog mokampuꞌ ion dia sog pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Dadi, kisobuꞌan ilan nog taluꞌ ni Isus koyon. Tibua, miktaluꞌ nosop dianilan, “Gombataꞌanan ku, mologon dodaꞌ og kampuꞌ nog gotow dia sog pigdotuꞌan nog Mikpongon! ");
INSERT INTO suc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Molomu pa kobian nog kamel dia sog gluang nog dialum, gabaꞌ nog doyahan, og kampuꞌ non dia sog pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kisobuꞌan ilan tokodoy mangka ilan poksinaksakoy nog, “Bila maꞌ nituꞌ buan, sima ma gidoy og motabang?” ");
INSERT INTO suc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Pigbontayan ilan ni Isus mangka ion poktaluꞌ nog, “Og maꞌ nion koyon ondiꞌ minang nog sagyaotow. Tibua, daꞌidun og mologon dia sog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dadi, miktaluꞌ si Piter dia ni Isus nog, “Dadi Kounutan, ami buan, nog lamig nami na tanan binolong og glam non mangka ami pogunut dianika?” ");
INSERT INTO suc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tinumabal si Isus nog, “Toluꞌon ku dianiu, ain ginonatan non og baloy non, og putupusodanan non, og mokogulang non, og gombataꞌanan non, otawaka og glupaꞌ non sabap sog kopokokunut non dianakon bu sog Gombaꞌis nog Guksugan koyon, ");
INSERT INTO suc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","minsan kobon non pa dini sog dunya, mokotabuk ion nog labi pa tokodoy dituꞌ og sugda non nog baloyanan, og putupusodanan non, og ginaꞌamaꞌ non, og gombataꞌanan, bu glupaꞌ, asta pa og pongulaꞌat sabap sog kopokokunut non dianakon. Bu sog binayaꞌ nog gondow kongonan ion nog kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tibua, modakol og gotow nog mikuna nog mimung ombinayaꞌ ilan. Bu modakol dosop og gotowanan nog mibinayaꞌ nog mimung mokuna ilan.” ");
INSERT INTO suc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tubus nituꞌ, mipanow ilan posunguꞌ sog Jerusalem. Sintak nilan ompanow mikuna si Isus. Og sulangguꞌanan non koyon misusa ilan bu og dumaanan nilan nog mibinayaꞌ, kiondokan. Dadi, pinitang ni Isus og sopuluꞌ bu duaꞌ sulangguꞌanan non koyon sog molayuꞌlayuꞌ mangka non puliꞌoy tumaluꞌ dianilan og posunguꞌ non koyon kobianbianan. ");
INSERT INTO suc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Maꞌ long non dun, “Posunguꞌ ita loꞌ ini sog Jerusalem. Matong ita dituꞌ, og Binataꞌ sog Kilawan uokilon dia sog mokokotas nog boliananan bu sog polopanadanan nog botad nog bansa Hudyu. Og gukuman nilan dianon bunuꞌon mangka nilan ion uokiloy dia sog gongkoman nog gotowanan nog konaꞌ bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pogwanwanon nilan ion, bu pogdulaꞌan nilan ion, bu pogdonogon nilan ion, mangka nilan ion bunuꞌoy. Tibua, sog kotolu ondow non tidu bunuꞌon, motubuꞌ da ion mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tubus nituꞌ, mikpolani dia ni Isus si Jems bu si Jan og gombataꞌ ni Sebedi mangka ilan poktaluꞌ dianon nog, “Polopanad, ngon bosia og kolegan nami nog inangon mu dianami.” ");
INSERT INTO suc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tinumabal si Isus, “Olo og kolegan niu nog inangon ku dianiu?” ");
INSERT INTO suc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Maꞌ long nilan dun, “Tugdak nika pa dianami mingkud dia sog glintu bibang nika bila matong mogdatuꞌ a na.” ");
INSERT INTO suc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tibua, tinabal ilan ni Isus, “Daꞌ niu kosabut bog olo og pingoni niu koyon. Mogaga niu taꞌ gidoy og sinsaan nog posunguꞌ u poglogogaon? Otawaka mogaga niu taꞌ gidoy og kobianbianan ku posunguꞌ?” ");
INSERT INTO suc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tinumabal ilan nog, “Oꞌo, mogaga nami da ion.” Miktaluꞌ si Isus nog, “Oꞌo, motud dodaꞌ nog mokinum amu sog ginuman ku bu mokobian amu sog kobianbianan ku. ");
INSERT INTO suc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tibua, konaꞌ u og momiliꞌ bog sima og mingkud sog glintu bibang u. Poꞌ og gingkudananan koyon donsamaꞌ na ngon piksimpanan dun.” ");
INSERT INTO suc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Dangan midongog ituꞌ nog sopuluꞌ sulangguꞌanan koyon, kodoluon ilan bosia dun og piginang ni Jems bu si Jan. ");
INSERT INTO suc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dadi, sinabi ilan ni Isus nog mokpolani ilan dianon mangka ion poktaluꞌ nog, “Kosunan niu nog og kodotuꞌan dini sog dunya, pogboyaꞌan nilan og pigotowanan nilan. Bu ain mokokotas dianilan, pogboyaꞌan nilan dosop ain ombabaꞌ pa dianilan. ");
INSERT INTO suc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tibua amu, sumboy ondiꞌ amu mamaꞌ nilan. Sugaꞌid non, ain og moleg nog ion og motas dianiu, sumboy ion mimung nog sosuguꞌon niu. ");
INSERT INTO suc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Bu ain sop dianiu og moleg nog ion og mokuna, sumboy ion mimung nog gulipon nog glam niu. ");
INSERT INTO suc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Poꞌ minsan og Binataꞌ sog Kilawan, ondaꞌ ion angoy dini sog dunya bagun ion tobangan, sugaꞌid non, bagun ion og tumabang, bu moguakil nog glawas non bunuꞌon bagun modakol og gotowanan og molokat tidu sog kouliponan nog dusa.” ");
INSERT INTO suc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tubus nituꞌ, minatong ilan sog Jeriku. Bu dangan mikogonat ilan sog koliwagan bonua koyon, modakol og gotowanan nog mikpogunut dia ni Isus bu sog sulangguꞌanan non. Ngon sala kotow buta dia pogingkud sog goksid nog dalan moktayak. Og ngalan non si Bartimius, og bataꞌ ion ni Timius. ");
INSERT INTO suc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Dangan midongog non nog minian si Isus og gotow Nasaret, miktawag ion nog, “Isus! Og pangkat ni Apuꞌ Dabid, kololatoy mu pa akon!” ");
INSERT INTO suc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pimag ion nog gotowanan nog diꞌ mokulekeꞌ. Tibua, posisayaꞌ non tanan posikadoy og tawag nog, “Pangkat ni Apuꞌ Dabid! Kololatoy mu pa suꞌusa akon!” ");
INSERT INTO suc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dadi, migindog si Isus mangka ion poktaluꞌ, “Sabi niu pa gotow koyon.” Dadi, sinabi nilan buta koyon mangka ilan poktaluꞌ nog, “Pobogan mu pikilan mu bu pogbuat a na poꞌ sinabi non na ika.” ");
INSERT INTO suc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dadi, pinilak non sulagbon non mangka pogdaliꞌ mogbuat mogapas mangoy dituꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sinakan ion ni Isus nog, “Olo og kolegan mu nog inangon ku dianika?” Tinumabal og buta koyon nog, “Polopanad, moleg u nog mokotongow u mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dadi, miktaluꞌ si Isus dianon nog, “Panow a na, poꞌ kiuliꞌan ka na sabap sog kopongandol mu dianakon.” Bu sododuꞌun mikotongow na bu migunut na ion dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Dangan molanilani ilan na sog Jerusalem, minatong ilan sog koliwagan bonua koyon nog Betani bu Betpage dia sog pun bilid nog Olibu. Dinondag ni Isus moguna dituꞌ og duaꞌ kotow sulangguꞌanan non mangka ion poktaluꞌ nog, ");
INSERT INTO suc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Angoy amu sog gimbolayan koyon. Bu bila matong amu dion, mokotongow amu mogdayun nog nati nog asnu koyon nog inikotan nog daꞌ pa sibon sokoyoy. Ubad niu bu oit niu dini. ");
INSERT INTO suc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bu bila ngon moksak dianiu bog iduma ubadon niu ma og nati koyon, tabal niu tibua nog ngon og kobalan nog Kounutan dun. Uliꞌon da bombus.” ");
INSERT INTO suc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dadi, mipanow ilan bu mitongow nilan og nati nog asnu dia sog dalan nog inikotan sog molani nog bongawan nog baloy. Solian nilan mubad dun, ");
INSERT INTO suc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","sinakan ilan nog gotowanan nog migindog dion nog, “Olo balan niu mubad nion?” ");
INSERT INTO suc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tinumabal ilan nog maꞌ nog tinaluꞌ ni Isus kituꞌ dianilan. Dadi, pitiang na nog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Inoit nilan nati koyon dituꞌ ni Isus mangka nilan onigoy og tolinting non nog glogdoy nilan mangka na sokoyoy ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Modakol gotowanan nog pingdondam nilan og sulagbon nilan dia sog dalan koyon nog bianan ni Isus. Bu og duma sop mikpongalap ilan nog dawon mamaꞌ nog dawon nog bunga mangka nilan botangoy sog dalan. ");
INSERT INTO suc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Og gotowanan koyon nog migunut dia ni Isus sog gunan binayaꞌ non, miglongag ilan mokpogekes nog, “Songlitan og Mikpongon! Pipia ion nog minangoy dini bianan sog ngalan nog Mikpongon! ");
INSERT INTO suc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Molongas og pigdotuꞌan nog gamaꞌ ta nog si Apuꞌ Dabid nog posunguꞌ na matong! Songlitan og Mikpongon sog glangit!” ");
INSERT INTO suc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Dadi, sinumolod ilan sog Jerusalem mangka pogdayun sog glomalomaan nog Baloy nog Poktomuyan dia sog Mikpongon. Dangan sinumolod ilan dituꞌ, diadia ion tinumontong. Tibua, sabap sog glolabung na, minuliꞌ ion sog Betani ilan nog sopuluꞌ bu duaꞌ sulangguꞌanan non koyon. ");
INSERT INTO suc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Dangan miksisolom bonua, ginumonat ilan sog Betani posunguꞌ sog Jerusalem. Sonuk nilan ompanow kigutoman si Isus. ");
INSERT INTO suc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mikotongow ion nog kayu nog migbogudawon dia sog gunanunan nilan koyon og ngalan non igera. Dadi, pilonian non bosia. Tibua, daꞌidun mitongow non nog bunga non lual da lunsan dawon. Poꞌ konaꞌ non pa timpu. ");
INSERT INTO suc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Dadi, tinoluꞌan non kayu koyon nog, “Ondiꞌ a na, nododaꞌ mogbunga mokpuliꞌ.” Bu midongog nog sulangguꞌanan non koyon og taluꞌ ni Isus koyon. ");
INSERT INTO suc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Dangan minatong ilan sog Jerusalem, sinumolod si Isus dia sog glomalomaan nog Baloy koyon nog Poktomuyan dia sog Mikpongon mangka non pomugowoy og gotowanan koyon nog mikpogdagangdagang bu og polonaluyanan. Bu pimolitukaꞌ non og glomisahananan nog polomolos nog sin asta og gingkudananan nog mikpogdagang nog kolopatianan. ");
INSERT INTO suc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Bu pigondiꞌan non og gotowanan koyon mian dion bila ngon pitangon nilan. ");
INSERT INTO suc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pikponadan ni Isus og gotowanan mangka ion poktaluꞌ dianilan nog, “Sinulat dia sog Kitab og taluꞌ nog Mikpongon nog, ‘Og baloy u iningolanan Baloy nog Pogyokinan nog glam nog binonsaan.’ Tibua, inimung niu nog glihanan nog polonakowanan!” ");
INSERT INTO suc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tibua, og mokokotas nog boliananan bu polopanadanan nog botad nog bansa Hudyu, dangan midongog nilan og taluꞌ non koyon, miktolipun ilan monontong nog bianan nilan lumaꞌat dia ni Isus poꞌ mondok ilan dianon. Saꞌan mondok ilan dianon poꞌ glam nog gotowanan kisobuꞌan ilan nog pikpanad non koyon. ");
INSERT INTO suc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tubus nituꞌ, dangan sindopondow na, ginumonat ilan dion sog koliwagan bonua koyon. ");
INSERT INTO suc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Dangan miksisolom bonua, minian ilan nosop sog kayu kituꞌ nog igera bu mitongow nilan nog mibotug. ");
INSERT INTO suc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bu kilobotan ni Piter og tinaluꞌ ni Isus kituꞌ sog kayu koyon. Dadi, maꞌ long non dun, “Polopanad! Tontong mu poloꞌma og kayu koyon nog tinoluꞌan mu nog diꞌ na mogbunga. Mibotug na tanan!” ");
INSERT INTO suc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tinumabal si Isus nog, “Pongandol amu sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Toluꞌon ku dianiu, minsan sima moktaluꞌ sog bulud koyon nog mawaꞌ na dion bu poglalin sog dagat, inangon nododaꞌ dianon og tinaluꞌ non koyon, bila diꞌ da mogduaꞌduaꞌ og dialom pikilan non bu tumud da ion nog poktoluꞌon non koyon, tumanon nododaꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Dadi, toluꞌon ku dianiu, minsan olo pongonion niu bianan sog gyakin niu sog Mikpongon, bila tudon niu nog mitabuk niu, bogoyon nododaꞌ ion dianiu. ");
INSERT INTO suc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Bu bila mindog amu mogyakin saka ngon pa kangit niu sog duma niu, ompunoy niu ion bagun da amu siꞌoy, kompunan amu dosop nog dusaanan niu nog Gamaꞌ sog glangit.  ");
INSERT INTO suc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tibua, bila diꞌ niu ompunan og pakasiotow niu, ondiꞌ amu dosop kompunan nog Gamaꞌ sog glangit nog dusaanan niu.” ");
INSERT INTO suc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Dadi, mikpuliꞌ ilan sog Jerusalem mangka ilan nosop solod sog glomalomaan nog Baloy nog Poktomuyan koyon. Sonuk non mogdundaan dion, mikpolani dianon og mokokotas nog boliananan bu og polopanadanan nog botad, bu og kobogolalan nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Sinakan nilan ion nog, “Olo bayaꞌ mu moginang nog maꞌ nion koyon? Bu sima migbogoy nog bayaꞌ koyon dianika moginang dun?” ");
INSERT INTO suc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Miktaluꞌ si Isus dianilan, “Sakan ku dosop amu. Bila tobalon niu akon, posunon ku dosop dianiu bog ain ku tiniduan og bayaꞌ u koni moginang nog maꞌ nini koni. ");
INSERT INTO suc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Og sak u koni mamaꞌ nini, sima og migbogoy nog bayaꞌ dia ni Jan nog Polomunyag nog momunyag nog gotowanan? Og Mikpongon taꞌ otawaka og gotow?” ");
INSERT INTO suc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dadi, miksinaksakoy ilan nog ilan bu ilan, “Bila ini toluꞌon ta nog dia tidu sog Mikpongon og bayaꞌ ni Jan, tobalon non ita nog iduma buan daꞌ ita ma tud dianon? ");
INSERT INTO suc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tibua, diꞌ dosop mogusoy nog toluꞌon ta nog dia tidu sog gotow.” Poꞌ mondok ilan nog gotowanan. Poꞌ og tud nog gotowanan si Jan, ion og tantu polomolatas nog taluꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Dadi, tinabal nilan si Isus nog, “Daꞌ a sunoy. Diꞌ nami kosunan.” Dadi, miktaluꞌ si Isus dianilan nog, “Bila maꞌ nituꞌ, diꞌ u sop posunon dianiu bog sima migbogoy dianakon nog bayaꞌ nog mokopoginang u nog maꞌ nini koni.” ");
INSERT INTO suc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tubus nituꞌ, migustal nosop si Isus dianilan bianan sog pononggiꞌan. Long non dun, “Ngon og gotow nog togo lupaꞌ nog pimulanan nog bolagon nog ngalan non og paras. Inalad non og glupaꞌ non koyon mangka ion poglokukut nog pogdogyakan nog bunga nog bolagon non koyon. Bu inimungan non nog glokowlokow nog pogolungan. Tubus nituꞌ, piaksa non og binalan non koyon mangka ion panow sog len bonua. ");
INSERT INTO suc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Dangan daliꞌ na pongopuꞌoy og bunga nog pomulan non koyon, dinondag non og sala kotow sosuguꞌon non mangoy mongabat nog bahagiꞌ non sog gotowanan kituꞌ nog minaksa nog pomulan non koyon. ");
INSERT INTO suc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tibua, dangan minatong ion dituꞌ, ginanggut nilan ion mangka nilan pogdonogoy mangka nilan bugowoy muliꞌ nog daꞌ pinitang non. ");
INSERT INTO suc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tubus nituꞌ, dinondag non nosop og len sosuguꞌon non. Bu dangan minatong dituꞌ, binombal nilan ion sog gulu mangka nilan solapsolapoy. ");
INSERT INTO suc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bu mikpuliꞌ pa ion dumondag nog len sosuguꞌon non mangoy dituꞌ. Dangan minatong ion dituꞌ, binunuꞌ nilan. Bu modakol pa og dinondag non mangoy dituꞌ. Og duma dianilan pigbadas, bu og duma pimunuꞌ nilan. ");
INSERT INTO suc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Sala kotow dona og daꞌ non dondagoy mangoy dituꞌ, og bataꞌ non nog kololaman non tokodoy. Sog gimpusan, dinondag non og dili bataꞌ non koyon mangoy dituꞌ poꞌ, long non dun, ‘Pogbotadan nilan ini og bataꞌ u koni.’ ");
INSERT INTO suc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Tibua, dangan mitongow nilan og bataꞌ non koyon, mikpoksitaluꞌ ilan nog, ‘Koyon na, og bataꞌ nog gapuꞌ nog glupaꞌ koni. Alung, ongoyon ta ion bunuꞌoy poꞌ bagun ita na og gapuꞌ nog glupaꞌ koni.’ ");
INSERT INTO suc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dadi, ginanggut nilan og bataꞌ nog gotow koyon mangka nilan bunuꞌoy mangka nilan pilakoy og bangkoy non sog molayuꞌ.” ");
INSERT INTO suc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Dadi, maꞌ long ni Isus dun dianilan, “Olo gidoy gondunon nog gapuꞌ nog glupaꞌ koyon dianilan? Ongoyon non nododaꞌ pomunuꞌoy og gotowanan koyon nog minaksa dianon mangka non bogoyoy og glupaꞌ non koyon sog len gotowanan. ");
INSERT INTO suc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Daꞌ niu taꞌ buan kobasta og sinulat dia sog Kitab nog, ‘Og batu kituꞌ nog mosolag, nog pigbongkis nog polongimung nog baloy, miimung tanan nog bololagaꞌ nog polongkapan sog glam non. ");
INSERT INTO suc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ion non da og gininang nog Mikpongon bu molongas ituꞌ tokodoy dia sog tinontongan ta.’” ");
INSERT INTO suc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dangan midongog nog mokokotas nog boliananan bu parasiuanan koyon, minontong ilan nog pondayan bagun nilan kukpaꞌan si Isus poꞌ misabut nilan nog pigdolilan ni Isus ilan. Tibua, mondok ilan sog gotowanan koyon dion. Dadi, ginonatan nilan si Isus dion. ");
INSERT INTO suc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Daꞌ kobon, dinondag nilan og duma parasiuanan bu og glaꞌayatanan ni Datuꞌ Herod mangoy dituꞌ ni Isus poꞌ pogolapsobapan nilan ion bianan sog taluꞌ non. ");
INSERT INTO suc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mikpolani ilan dianon mangka ilan poktaluꞌ nog, “Polopanad, kosunan nami nog ika, moktaluꞌ a nog motud, bu diꞌ a mogbigyaꞌ nog gotow minsan andun kotas non. Bu og pikpanad mu dumalan dia sog polomotadon nog glegan nog Mikpongon. Dadi, buan, sog pikilan mu, mogusoy taꞌ nog mogbayad ita nog buis dia ni Sisar otawaka ondiꞌ? ");
INSERT INTO suc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sumboy ita taꞌ nododaꞌ mogbayad otawaka ondiꞌ taꞌ?” Tibua, kisunan ni Isus og punan nilan koyon moksak dun. Dadi, tinabal non ilan, “Iduma poksulaysulayan niu ma akon? Pitang niu dini og sin koyon poꞌ tontongon ku.” ");
INSERT INTO suc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dadi, tinulun nilan dianon og sin koyon mangka non ilan sakoy bog sima og glodawan nog tinaguꞌ sog sin koni, bu sima og ngalan nog sinulat dini? Tinabal nilan nog, “Si Sisar ma.” ");
INSERT INTO suc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tinabal ilan ni Isus nog, “Dadi, bogoy niu dia ni Sisar ain dianon. Bu bogoy niu dosop dia sog Mikpongon ain dianon.” Dangan midongog nilan ituꞌ kisobuꞌan ilan dun dianon bu ginonatan nilan ion. ");
INSERT INTO suc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tubus nituꞌ, og sadusiuanan mikpolani dia ni Isus. Og gotowanan koyon, ondiꞌ ilan tumud nog ngon motubuꞌ puliꞌ tidu matoy. Dadi, miksak ilan dia ni Isus nog, ");
INSERT INTO suc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Polopanad, maꞌ long nog sinulat kituꞌ ni Muses dianita, nog bila og sala kopogduayan, matoy og glaki non nog saka ondaꞌidun og bataꞌ nilan, sumboy og balulibun koyon pogduoyon nog pimikitan non, bagun da bila mogbataꞌ ilan, mimung da maꞌ nog bataꞌ nilan nog glaki non kituꞌ tiganaꞌ. ");
INSERT INTO suc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ati, ngon og pitu kotow mogilug nog lunsan laki. Og gulangbataꞌ koyon dianilan migduoy nog saka minatoy nog daꞌ ilan pa pogbataꞌ. ");
INSERT INTO suc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tubus nituꞌ, pigduoy nosop nog dumapit sog gulangbataꞌ og balulibun koyon. Saka minatoy dosop nog daꞌ ilan pa pogbataꞌ. Tubus nituꞌ, pigduoy nosop ion nog kotolu bu daꞌidun dosop og bataꞌ nilan. ");
INSERT INTO suc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Asta mipogduoy non og pitu kotow pomogilug koyon nog mikpomatoy ilan saka daꞌ ilan pogbataꞌ. Sog gimpusan, asta og balulibun koyon minatoy dosop. ");
INSERT INTO suc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dadi, bila matong gondow nog potubuꞌon og gotowanan tidu matoy, sima ma og glaki nog glibun koyon nog saka og pitu kotow koyon mikobian mogduoy dianon?” ");
INSERT INTO suc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Dadi, tinabal ilan ni Isus nog, “Saꞌan milapang amu poꞌ daꞌidun sabut niu nog sinulat dia sog Kitab otawaka og dasig nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Poꞌ bila matong na potubuꞌon nog Mikpongon og gotowanan tidu matoy, ondiꞌ ilan na mokpogduoy poꞌ mamaꞌ ilan na nog moloikatanan sog glangit. ");
INSERT INTO suc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bu paꞌali sop sog kopotubuꞌ nog gotowanan tidu matoy, ondaꞌ niu taꞌ kobasta og sinulat ni Muses dia sog Kitab nog guksugan kituꞌ paꞌali dia sog polompung nog mitongow non mikpogligaꞌ? Maꞌ nini og taluꞌ nog Mikpongon dianon, ‘Akon og Mikpongon nog ion non og poktomuyon kituꞌ ni Abraham, bu ni Isak, bu ni Jakub.’ ");
INSERT INTO suc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Konaꞌ ion og poktomuyon nog ain og minatoy, sugaꞌid non, ain og totubuꞌ. Dadi, miktantu amu dodaꞌ molapang.” ");
INSERT INTO suc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Dadi, ngon sala kotow og polopanad nog botad nog bansa Hudyu, midongog non ilan mogabitabit bu mitongow non nog si Isus moto tumabal. Dadi, sinakan non si Isus nog, “Olo og dondagan kituꞌ nog bololagaꞌ sog glam non, dia sog Botad?” ");
INSERT INTO suc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tinabal ion ni Isus nog, “Og bololagaꞌ sog glam nog dondagan maꞌ nini, ‘Pokinongog amu gotow Israelanan, Og Pogbayaꞌ og Mikpongon bu sala non da og Kounutan ta! ");
INSERT INTO suc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Sumboy potigbungon mu og glolaman mu sog Pogbayaꞌ nog ion og Diwata mu, tidu sog pusung mu, mangoy sog glimukud mu, asta sog glam nog pomikilan mu, bu glam nog pagas mu.’ ");
INSERT INTO suc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Bu og koduaꞌ non maꞌ nini, ‘Sumboy molalam a dia sog sumbaloy mu mamaꞌ da nog glolaman mu sog dili glawas mu.’ Daꞌidun na og bololagaꞌ nog dondagan nog labi pa dini.” ");
INSERT INTO suc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dadi, tinabal non si Isus, “Molongas og tabal mu koyon, Polopanad. Bu motud og taluꞌ mu nog og Mikpongon da og Pogbayaꞌ bu daꞌidun na Diwata lual pa dianon. ");
INSERT INTO suc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bu moktidu sog pusung, bu sog glam nog pomikilan, bu sog glam nog pagas, sumboy molalam ita dianon. Bu sumboy molalam ita dosop sog sumbaloy ta nog maꞌ nog glolaman ta nog dili glawas ta. Og glam nion, bololagaꞌ pa dia sog glam nog pomalasanan ta kituꞌ dia sog Mikpongon nog tutungon.” ");
INSERT INTO suc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Dangan midongog ni Isus nog maꞌ nion og tabal non, tinoluꞌan non ion nog, “Molani a na sog pigdotuꞌan nog Mikpongon.” Tidu dion, daꞌidun na ginumiluꞌ moksak mokpuliꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Solian ni Isus mokpanad sog gotowanan dia sog glomalomaan nog Baloy koyon nog Poktomuyan dia sog Mikpongon, miktaluꞌ ion nog, “Olo gidoy og poktoluꞌon nog polopanandanan koyon nog botad nog bansa Hudyu nog, og Kristu nog ion og pangkat ni Dabid? ");
INSERT INTO suc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Poꞌ si Dabid, bianan sog Bolakat nog Mikpongon, miktaluꞌ nog, ‘Og Pogbayaꞌ miktaluꞌ dia sog Kounutan ku, Ingkud a sog dapit glintu u asta imungon ku og bantaanan mu nog gindogan nog botis mu.’ ");
INSERT INTO suc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Dadi, bila si Dabid, iningolanan non ma og Kristu nog Kounutan non, olo ma og kipongkatoy ni Dabid dianon?” Bu modakol nog gotowanan og linoliag mokinongog nog taluꞌ ni Isus koyon. ");
INSERT INTO suc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sog solian pa ni Isus mokpanad dia sog gotowanan koyon dion, miktaluꞌ ion nog, “Pokpotubud amu dia sog polopanadanan koyon nog botad nog bansa Hudyu poꞌ loliagon ilan monapot nog ponopoton molambak bila mokpanowpanow ilan poꞌ moleg ilan pogodaban bu golunon nog gotowanan bila dia ilan sog kosompagan. ");
INSERT INTO suc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bu bila dia ilan sog baloy nog poglumpukan nog bansa Hudyu, kolegan nilan dia ilan pingkudoy sog gingkudan nog mokokotas nog gotow. Bu maꞌ nituꞌ dosop bila dia ilan sog kologyaꞌan. ");
INSERT INTO suc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bu ginang nilan moglimbung dia sog balulibunanan bagun nilan malap og gakodanan nilan. Tubus nituꞌ, bila mogyakin ilan, popoyaton nilan tokodoy poꞌ baluꞌbaluꞌ molongas ilan nog gotow. Tibua, sog binayaꞌ nog gondow, ombogat tokodoy og polihalaꞌ nog Mikpongon dia sog gotowanan koyon nog maꞌ nion.” ");
INSERT INTO suc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tubus nituꞌ, miningkud si Isus sog sunguꞌan nog poktoguꞌan koyon nog sin nog inuakil sog Mikpongon dia sog Baloy nog Poktomuyan koyon. Pigbontayan non og gotowanan monginulod nog sin nilan dion sog poktoguꞌan koyon. Modakol og doyahananan nog modakol og tinulod nilan nog sin nilan dion. ");
INSERT INTO suc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tubus nituꞌ, mitongow non dosop og balulibun nog miskinan minangoy tumulod nog duaꞌ sin da dia sog poktoguꞌan koyon nog bogoy. ");
INSERT INTO suc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dadi, sinabi ni Isus og sulangguꞌanan non koyon nog mokpolani ilan dianon mangka ion poktaluꞌ nog, “Toluꞌon ku dianiu, og binogoy nog balulibun koyon labi pa dia sog bogoy nog duma gotowanan koyon dion. ");
INSERT INTO suc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Poꞌ og doyahananan koyon, saꞌan mikobogoy ilan poꞌ ngon dianilan. Tibua, og balulibun koyon, tinipot non mogbogoy og glam nog sukatan non.” ");
INSERT INTO suc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tubus nituꞌ, dangan linumiu si Isus tidu sog Baloy nog Poktomuyan koyon dia sog Mikpongon, miktaluꞌ og sulangguꞌ non dianon nog, “Tontong mu, Polopanad! Ombaꞌis tokodoy pogbontayan og polongkapan nog Baloy nog Poktomuyan koyon bu og gimbolayan koyon sog glumibut non.” ");
INSERT INTO suc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tinumabal si Isus nog, “Og pigdolit mu koyon nog gimbolayan, ngon gondow non nog minsan solabuk og polongkapan non koyon nog batu nog mitongow mu, daꞌidun nododaꞌ mosamaꞌ dun dia sog kibotangan non koyon poꞌ glam non koyon motipot pomoktugban.” ");
INSERT INTO suc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Dangan minatong ilan dituꞌ sog bulud nog Olibu, miningkud si Isus bu pigbontayan nilan sog dipag og Baloy koyon nog Poktomuyan. Mikpolani si Piter, si Jems, si Jan, bu si Andriu dia ni Isus mangka ilan poksak dianon nog ilan bu ilan, ");
INSERT INTO suc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kounutan, taluꞌ mu pa dianami bog nanu gidoy ion kotuman. Bu olo og gindanan dun nog posunguꞌ na motuman og glam non koni?” ");
INSERT INTO suc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tinabal ilan ni Isus nog, “Pokpotubud amu bagun amu ondiꞌ kolimbungan. ");
INSERT INTO suc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Poꞌ modakol og matong nog gomiton nilan og ngalan ku. Toluꞌon nilan nog ilan dow og Kristu. Bu modakol og kolimbungan dun. ");
INSERT INTO suc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bu bila mokodongog amu nog gonek nog mogbunuꞌ bu og dongogan nog mogbunuꞌ, naꞌ amu kiglaꞌan dun poꞌ glam non koyon sumboy nododaꞌ ion mian. Tibua, konaꞌ pa ion og doksuꞌan. ");
INSERT INTO suc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Poꞌ og binonsaan mokpogbunuꞌ ilan bu ilan. Bu og pigdotuꞌan mantu dosop sog len pigdotuꞌan. Bu ngon dosop mian nog glinuganan sog ainain nog bonua bu og gunus. Og glam nini og tolipunan pa nog glogon nog ompononggiꞌ dia sog glibun nog pinokitan. ");
INSERT INTO suc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Pongmohilat amu poꞌ pongukpaꞌan nilan amu mangka amu nilan uokiloy dia sog gukum. Bu pogdonogon amu dion sog baloyanan nog poglumpukan nog bansa Hudyu. Bu sabap sog kopokokunut niu dianakon, oiton nilan amu dia sog sunguꞌan nog gubernadoranan bu sog sunguꞌan nog kodotuꞌananan mangka amu ukumoy sabap sog kopokokunut niu dianakon. Bu bianan dituꞌ, mokopoguksug amu nog Gombaꞌis nog Guksugan dianilan. ");
INSERT INTO suc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Poꞌ og Gombaꞌis koni nog Guksugan sumboy kuksugan pa poguna dia sog glam nog binonsaan. ");
INSERT INTO suc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bila ukpaꞌan amu bu dia amu na sog sunguꞌan nog gukum, naꞌ amu mosusa dun bog olo og tabal niu dianilan. Sugaꞌid non, taluꞌ niu tibua ain bogoyon dianiu sog tang koyon. Poꞌ og taluꞌ koyon konaꞌ niu dili og taluꞌ, sugaꞌid non, og Bolakat nog Mikpongon og mokpotaluꞌ dun dianiu. ");
INSERT INTO suc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Bu sog tang koyon pobunuꞌ nilan na og putupusod nilan. Bu maꞌ nituꞌ dosop og ginangon nog gamaꞌanan dia sog gombataꞌanan nilan. Bu og gombataꞌanan siꞌoy, mokpongantu ilan na sog mokogulanganan nilan mangka nilan pobunuꞌ. ");
INSERT INTO suc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pokongitan amu nog glam nog gotowanan sabap sog kopokokunut niu dianakon. Tibua, simasima og mokogaga asta sog doksuꞌan, motabang ion. ");
INSERT INTO suc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ngon gondow non, motongow niu nog pindogon dia sog dugu nog mosigda nog dia sog Baloy nog Poktomuyan dia sog Mikpongon og landuꞌ kolaton nog miimung moglomuꞌ dun og Baloy kituꞌ nog Poktomuyan. (Sumboy mosabut nog ain og mogbasta nini!) Bila motongow niu ituꞌ nog piindog na, ain og gotowanan kituꞌ nog mikpogonong dini sog Judia koni, sumboy mokpolaguy ilan na sog kobukidan. ");
INSERT INTO suc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bu ain sop og gotowanan nog kotangan nog dia ilan sog glowasan nog baloy nilan, ondiꞌ ilan na mokotagad mogdangan monolimpan. ");
INSERT INTO suc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bu ain sop og gotowanan nog kotangan nog dituꞌ ilan sog binalan nilan, ondiꞌ ilan na dosop mokotagad muliꞌ malap nog sulagbon nilan. ");
INSERT INTO suc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bu sog tang koyon, kololatlolat ain bodosanan bu ain og tigubataꞌ poꞌ ngon og kolumbeketan nilan. ");
INSERT INTO suc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pogyokinoy niu nog og kopolaguy niu ondiꞌ motang sog timpu dupiꞌ. ");
INSERT INTO suc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Poꞌ sog tang koyon, landuꞌ na og sinsaan nog gotowanan. Daꞌ sibon kobianoy og maꞌ nion koyon nog sinsaan tidu pa sog kopokpongon nog dunya asta sog numun koni, bu og sinsaan koyon diꞌ kobotukan. ");
INSERT INTO suc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Somoꞌ ondaꞌ kulangoy nog Mikpongon og ginondowan nog sinsaan nilan koyon posunguꞌ, motipot nododaꞌ pomatoy og gotowanan. Tibua, saꞌan kinulangan non poꞌ sabap sog pigotowan non nog piniliꞌ non. ");
INSERT INTO suc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Dadi, sog tang koyon, bila ngon mokpoktaluꞌ nog ‘Tontong niu! Koni na og Kristu!’ otawaka, ‘Kituꞌ da ion!’ naꞌ amu tokodoy tumud dun. ");
INSERT INTO suc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Poꞌ modakol og mokponuaꞌ nog polomolatasanan nog diꞌ motud bu og gotowanan nog mogbaluꞌbaluꞌ nog ilan dow og Kristu. Bu poginangon nilan og gingyataꞌanan bu og kosobuꞌsobuꞌ bagun nilan moit og gotowanan, bu asta og pigotowan nog Mikpongon, somoꞌ moit nilan da bosia. ");
INSERT INTO suc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Dadi, pongmohilat amu poꞌ saꞌan ini pidonsamaꞌ u tumaluꞌ dianiu bagun amu mosimpan. ");
INSERT INTO suc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Bu bila modoksuꞌ og glogon koyon, sog tang koyon mogdolom og gondow. Bu og bulan ondiꞌ na sumilow. ");
INSERT INTO suc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Bu og bitunanan sog glangit mokpogogdag, bu og glam nog dia sog glangit mokpoksop og botanganan nilan. ");
INSERT INTO suc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Dadi, sog tang koyon, motongow nilan og Binataꞌ sog Kilawan posunguꞌ matong dini sog glupaꞌan mogunut dia sog ginampol, bu dunut landuꞌ silow og kotas nog bayaꞌ non. ");
INSERT INTO suc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tubus nion, popongoyon non og moloikatanan non poꞌ limudon nilan og pigotowan non sog pat pigyulu nog dunya. ");
INSERT INTO suc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Maꞌ nini og manad niu dia sog kayu kituꞌ nog igera. Bila lumoklag na bu pogbogudawon, kosunan niu nog daliꞌ na og timpu podos. ");
INSERT INTO suc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Domikian dosop nog bila motongow niu na og glam nog piktaluꞌ u koni mituman na, kosunan niu nog daliꞌ na datong og Binataꞌ sog Kilawan. ");
INSERT INTO suc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Poꞌ toluꞌon ku dianiu, mangka siꞌoy kotipot pomatoy og gotowanan numun koni, motuman na og glam nog piktaluꞌ u koni dianiu. ");
INSERT INTO suc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Og glangit bu glupaꞌan solianlian da, tibua, og taluꞌ u moksampoyumul nododaꞌ.” ");
INSERT INTO suc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Maꞌ long pa ni Isus, “Daꞌidun og mokosun dun, sala kotow siꞌoy, og gondow otawaka og tang, minsan siꞌoy og moloikatanan sog glangit, otawaka og Bataꞌ. Daꞌidun mokosun dun lual da og Gamaꞌ. ");
INSERT INTO suc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Dadi, saꞌan sumboy kobon non poktimaꞌan bu pongmohilat amu poꞌ diꞌ niu kosunan bog olo ondowoy dun og kotuman og pogolongon ku koni. ");
INSERT INTO suc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Domikian da mamaꞌ nog gotow nog posunguꞌ ompanow sog len bonua. Mangka siꞌoy ion gonat, pomilinan non poguna og sosuguꞌonanan non nog ginangon nilan bu bogayan non ilan nog polosukuꞌan nilan. Bu dondagon non dosop og polongipat nog bongawan nog baloy non koyon nog sumboy mongmohilat ion, mangka na ion panow. ");
INSERT INTO suc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Dadi, amu siꞌoy, mamaꞌ amu dosop nituꞌ. Sumboy pongmohilat amu poꞌ diꞌ niu kosunan bog nanu og kopokpuliꞌ nog gapuꞌ nog baloy koyon, sog tolipun gobi, otawaka sog tungaꞌ gobi taꞌ, otawaka sog daliꞌ ondow taꞌ, otawaka sog bukaꞌsiang. ");
INSERT INTO suc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Dadi, saꞌan pongmohilat amu bagun non amu diꞌ kodotongan nog poktulug amu, bila tumokow ion matong. ");
INSERT INTO suc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Og tinaluꞌ u koni dianiu nog pongmohilat amu, toluꞌon ku dosop sog glam non.” ");
INSERT INTO suc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Minatong duaꞌ ondow dona mangka siꞌoy poktolipun og kologyaꞌan kituꞌ nog Liniusan bu og kologyaꞌan nog Pan Nog Daꞌ Potulinoy, og mokokotas nog boliananan bu og polopanadanan nog botad nog bansa Hudyu, kobon non monontong ilan nog pondayan bagun nilan kukpaꞌan si Isus nog mondom daꞌidun og mokosun dun mangka nilan siꞌoy ion bunuꞌoy. ");
INSERT INTO suc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tibua, long nilan dun, “Sumboy diꞌ ta ion ukpaꞌan nog motang sog gondow nog kologyaꞌan koyon, poꞌ gomonsunoy mokpogulek og gotowanan dun.” ");
INSERT INTO suc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sonuk nog dituꞌ si Isus sog baloy ni Simun og bakas gipulon kituꞌ nog dituꞌ sog Betani, solian nilan kuman, ngon sala kotow glibun mikpolani dianon. Migoit ion nog glana momut nog tinaguꞌ sog glolonan nog inimung tidu sog batu putiꞌ. Og ngalan nog glana momut koyon nog landuꞌ kologan og Nard. Dadi, sinokpoꞌ non og glolonan koyon mangka non tuyungoy og pogomut koyon sog glimpulu ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tibua, og duma gotowanan dion piglolingitan nilan og glibun koyon mangka ilan pokundomundom nog ilan bu ilan nog, “Iduma ma gidoy ion? Pogostaan non ma og glana momut koyon! ");
INSERT INTO suc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Somoꞌ bosia ion piksaluy, og tolu gatus dinari koyon nog ombogoy pa bosia dia sog miskinananan.” Dadi, pigboluꞌan nilan ion. ");
INSERT INTO suc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Dadi, miktaluꞌ si Isus dianilan nog, “Polukas niu na glibun koni! Balan niu moksasow dianon? Og gininang non koni dianakon molongas tokodoy. ");
INSERT INTO suc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Amu, kobon non mokunul amu da nog miskinan. Bu bila ompikil niu tumabang amu dianilan, kotobangan niu da ilan. Tibua, akon, ondiꞌ ita niu kobon non mokunul. ");
INSERT INTO suc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Og gininang nog glibun koni og goktob nog ombaꞌug non. Og glana momut koyon nog tinuyung non sog glawas u, og kopoksimpan non ion nog kolobong dianakon. ");
INSERT INTO suc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Bu toluꞌon ku dianiu, minsan ain ustaloy og Gombaꞌis nog Guksugan sog gliwag nog dunya koni, og gininang nog glibun koni dianakon mosuksug dosop poꞌ og pomondoman dianon.” ");
INSERT INTO suc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tubus nituꞌ, og sala kotow sog sopuluꞌ bu duaꞌ sulangguꞌanan ni Isus koyon, nog si Judas Iskariot, minangoy sog mokokotas nog boliananan poꞌ uokilon non si Isus dianilan. ");
INSERT INTO suc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dangan midongog nilan og gangoy ni Judas koyon, kisuꞌatan ilan tokodoy dun bu pinosadan nilan si Judas nog bogayan nilan nog sin. Dadi, tidu dituꞌ, minontong si Judas nog pondayan non nog bagun non muakil si Isus dianilan. ");
INSERT INTO suc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dangan ion midopot og tiganaꞌ ondow nog kologyaꞌan kituꞌ nog iningolanan Pan Nog Daꞌ Potulinoy, og botad nilan sog gondow koyon, momalas ilan nog nati nog bilibilianan nilan nog simpan nilan kituꞌ nog pomalas nilan sog Liniusan. Dadi, miktaluꞌ sulangguꞌanan ni Isus dianon nog, “Polopanad, ain ka koleg simpanoy nog globungan nog Liniusan?” ");
INSERT INTO suc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dadi, dinondag ni Isus og duaꞌ kotow sulangguꞌanan non koyon mangka non ilan toluꞌoy nog, “Angoy amu sog koliwagan bonua koyon bu ngon og lumumpak dianiu nog glaki nog pokpisan nog baꞌing. Pogunut amu dianon. ");
INSERT INTO suc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bu ain baloy nog solodan non, taluꞌ niu sog gapuꞌ nog baloy koyon nog, ‘Og Polopanad miksak bog ain dow og dugu kituꞌ nog poglobunganan nilan nog sulangguꞌanan non sog gondow nog Liniusan?’ ");
INSERT INTO suc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Potongowon non dianiu og mosolag nog dugu dia sog ditas nog baloy koyon sog koduaꞌ lengkat non. Og dugu koyon misimpan na. Dituꞌ niu pogasip og glam non.” ");
INSERT INTO suc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dadi, mipanow sulangguꞌanan non koyon sog koliwagan bonua kituꞌ bu mitongow nilan dodaꞌ og glam nog piktaluꞌ ni Isus kituꞌ dianilan. Dadi, pigasip nilan dion og globungan koyon nog iningolanan og Liniusan. ");
INSERT INTO suc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Dangan miglogobi na, si Isus bu sulangguꞌanan non koyon nog sopuluꞌ bu duaꞌ kotow, minatong ilan sog baloy koyon. ");
INSERT INTO suc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sonuk nilan mogadap kuman, miktaluꞌ si Isus nog, “Toluꞌon ku dianiu, og sala kotow dianiu og mongulaꞌat dianakon. Og gadap u da dini kuman.” ");
INSERT INTO suc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dadi, miglaꞌat og dialom pikilan nilan dun mangka og monala kotow dianilan miksak dianon nog, “Konaꞌ u taꞌ gidoy ion?” ");
INSERT INTO suc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tinumabal si Isus nog, “Og moksipi kituꞌ muakil dianakon, og sala kotow dianiu sog sopuluꞌ bu duaꞌ sulangguꞌanan ku, og minabang kituꞌ kuman dia sog ponaksan ku. ");
INSERT INTO suc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Poꞌ og Binataꞌ sog Kilawan, og bianan non matoy mamaꞌ nog sinulat kituꞌ dia sog Kitab paꞌali dianon. Tibua, kondokondok tokodoy og doksuꞌan nog gotow koyon nog mongulaꞌat dianon. Golom pa bosia somoꞌ daꞌ na ion botaꞌoy.” ");
INSERT INTO suc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sog sonuk nilan poglokan, minalap si Isus nog pan mangka non posolomatoy sog Mikpongon, mangka non pomitakoy bu pomogoyoy dianilan kobon non moktaluꞌ nog, “Tabuk niu ini poꞌ ion non ini og glawas u.” ");
INSERT INTO suc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tubus nituꞌ, inimud non og saguk koyon dion bu posolomatoy sog Mikpongon mangka non tulunoy dianilan. Bu glam nilan koyon mininum dun. ");
INSERT INTO suc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Long sop ni Isus dun, “Ion non ini og duguꞌ u nog moglayas bagun kompunan og dusaanan nog modakol nog gotowanan. Ion non nion og pagon nog bogu pasad nog Mikpongon sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Toluꞌon ku dianiu, diꞌ u na minum nini mokpuliꞌ asta mogadap ita mokpuliꞌ sog pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tubus nituꞌ, mikpoksanglit ilan sog Mikpongon bianan sog bobat mangka ilan na angoy dituꞌ sog bulud nog Olibu. ");
INSERT INTO suc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sonuk nilan koyon ompanow posunguꞌ dituꞌ, long ni Isus dianilan, “Bombus og glam niu koyon, bolongon niu akon. Poꞌ sinulat sog Kitab nog, ‘Bunuꞌon ku og polongipat nog bilibili bu mokpokpolaꞌ og bilibilianan non.’ ");
INSERT INTO suc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tibua, bila motubuꞌ u na tidu matoy, moguna u dianiu dituꞌ sog Galili.” ");
INSERT INTO suc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tubus nituꞌ, miktaluꞌ si Piter dianon nog, “Kounutan, minsan glam nilan koyon molong dianika, akon, diꞌ u da ika bolongon!” ");
INSERT INTO suc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tinabal ni Isus si Piter nog, “Toluꞌon ku dianika, bombus mangka siꞌoy poktukalaꞌ manuk sog koduaꞌ kali non, tolu kali mu na akon sonsingoy dia sog gotowanan nog diꞌ mu akon kilolaan.” ");
INSERT INTO suc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tibua, posisayaꞌ tanan si Piter poktaluꞌ nog, “Kounutan, minsan siꞌoy sunuꞌon u munuꞌ dianika, diꞌ u nododaꞌ ika sonsingan!” Mamaꞌ dosop nituꞌ og tinaluꞌ nog duma sulangguꞌanan non. ");
INSERT INTO suc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tubus nituꞌ, migdayun si Isus ilan nog sulangguꞌanan non sog dialom nog koyuan koyon nog iningolanan og Getsemani. Miktaluꞌ ion dianilan nog, “Pongingkud amu pa dini poꞌ mangoy u pa mogyakin.” ");
INSERT INTO suc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bu inoit non si Piter, si Jems, bu si Jan. Landuꞌ tokodoy og susaan non poꞌ mibatik non na og posunguꞌ non kituꞌ kobianan. ");
INSERT INTO suc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Dadi, miktaluꞌ ion sog dumaanan non koyon nog, “Landuꞌ u na kobogatoy nog susaan ku nog boyaꞌan agonagon u na matoy dun. Pogbagad amu pa dini bu duma amu mogonduk mogyakin.” ");
INSERT INTO suc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tubus nituꞌ, minangoy ion sog gunanunan kolongod mangka ion lob mogyakin nog, somoꞌ bosia mogusoy da, diꞌ na ombaluy og sinsaan non koyon. ");
INSERT INTO suc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Maꞌ long non dun, “O Amaꞌ u, Amaꞌ, daꞌidun og mologon dianika. Awaꞌ mu pa dianakon og posunguꞌ u koni poglogogaon nog sinsaan. Tibua, sumboy konaꞌ og glegan ku og kunutan, sugaꞌid non, og glegan mu.” ");
INSERT INTO suc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tubus nituꞌ, mikpuliꞌ ion dituꞌ sog sulangguꞌanan non kituꞌ. Mitongow non ilan nog mikponulug ilan. Miktaluꞌ ion dia ni Piter, “Simun, mitulug a taꞌ? Diꞌ a ma mokogaga mogonduk podaliꞌ siꞌoy? ");
INSERT INTO suc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pogonduk amu mogyakin bagun amu ondiꞌ koyubaꞌan. Moleg da bosia og pikilan niu, tibua, og glawas niu ondiꞌ mokogaga.” ");
INSERT INTO suc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tubus nituꞌ, mikpuliꞌ nosop si Isus mogyakin mamaꞌ nog gyakin non kituꞌ ");
INSERT INTO suc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","mangka nosop pokpuliꞌ dituꞌ sog sulangguꞌanan non koyon. Bu kidotongan non nosop ilan nog mikponulug poꞌ ondiꞌ nilan na dodaꞌ kotigolan og tulug nilan. Bu diꞌ ilan moto tumabal dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tubus nituꞌ, mikpuliꞌ nosop si Isus sog kotolu kali non, mangka ion poktaluꞌ nog, “Abu! Mikpogbobolilid amu poma dion motulug? Pada na poꞌ minatong na og tang nog uokilon na og Binataꞌ sog Kilawan dia sog gongkoman nog gotowanan kituꞌ nog bolodusaon. ");
INSERT INTO suc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Dadi, pogbuat amu na poꞌ koni na og gotow kituꞌ nog moguakil dianakon sog glaꞌat. Alung na.” ");
INSERT INTO suc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sonuk pa ni Isus moktaluꞌ, minatong na si Judas og duma nog sopuluꞌ bu duaꞌ sulangguꞌanan non kituꞌ. Modakol nog gotowanan og dunutanan non nog migatul ilan nog kalisanan bu bobombalanan nilan. Pipangoy ilan nog mokokotas nog boliananan, bu og polopanadanan nog botad nog bansa Hudyu, bu og kobogolalan nog bansa Hudyu koyon. ");
INSERT INTO suc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Og polonipu kituꞌ nog si Judas bu og gotowanan koyon, ngon og koposadan nilan nog bagun nilan kilolaan si Isus. Long non dun, “Og gotow nog olokan ku, ion non ion og ponontongon niu kituꞌ. Dadi, ukpaꞌoy niu na ion mangka niu oit bu ipat niu mahatul.” ");
INSERT INTO suc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dadi, mikpolani si Judas dia ni Isus mangka ion poktaluꞌ nog, “Polopanad!” mangka non olokoy si Isus. ");
INSERT INTO suc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dadi, og gotowanan koyon pigdoyunan nilan mogaid bu ukpaꞌoy si Isus. ");
INSERT INTO suc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tibua, og sala kotow koyon nog pogindog dion, sinintak non og kalis non mangka non tigbasoy og kisonggulan nog kounutan nog boliananan koyon boyaꞌan nog misikpoy tanan og tolinga non. ");
INSERT INTO suc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tubus nituꞌ, miktaluꞌ si Isus sog gotowanan koyon nog, “Og polonglaꞌug u taꞌ nog mangoy amu dini nakon mokpogoit amu poma nog kalisanan bu bobombalanan? ");
INSERT INTO suc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Saka gondow gondow motongow niu akon mokpanad sog glomalomaan nog Baloy nog Poktomuyan dia sog Mikpongon. Saka daꞌ niu poma akon ukpaꞌoy dituꞌ. Tibua, sumboy dodaꞌ motuman og glam nog sinulat dia sog Kitab.” ");
INSERT INTO suc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tubus nituꞌ, binolong ion nog glam nog sulangguꞌanan non koyon poꞌ mikpokpolaguy ilan. ");
INSERT INTO suc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ngon sop sala kotow glitow dion nog migunut dia ni Isus nog daꞌ poglogdoy, sugaꞌid non, minapis tibua. Dangan inukpaꞌan ion bosia, ");
INSERT INTO suc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","milaguy ion nog mibagak og tapis non. ");
INSERT INTO suc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tubus nituꞌ, inoit nilan si Isus dituꞌ sog kounutan nog boliananan koyon. Dituꞌ miglumpuk og glam nog mokokotas nog boliananan, bu og polopanadanan nog botad nog bansa Hudyu, bu og kobogolalan. ");
INSERT INTO suc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tibua, si Piter piguyukuyukan non si Isus asta sog glomalomaan nog kounutan nog boliananan koyon. Bu minampuꞌ ion mingkud dia sog polongipatanan koyon dion kobon non mokpoponalang sog gapuy. ");
INSERT INTO suc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Og mokokotas nog boliananan, bu glam nog polongukumanan sog gukum nog bansa Hudyu, minontong ilan nog mondom komotudan si Isus bagun nilan ion ombunuꞌ. Tibua, daꞌ nilan ion kotongowoy nog mondom ombunuꞌ nilan ion dun. ");
INSERT INTO suc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Modakol og gotowanan migimungimung tumaksiꞌ dia ni Isus, tibua, diꞌ dumalan og koponaksiꞌ nilan koyon dianon. ");
INSERT INTO suc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tubus nituꞌ, ngon gotowanan minindog dion mangka ilan dosop poktaluꞌ nog diꞌ motud. ");
INSERT INTO suc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Midongog nami og gotow koni miktaluꞌ nog gobaꞌon non dow og Baloy nog Poktomuyan dia sog Mikpongon nog ginimung nog gotow bu, sog solod nog tolu ondow, mokpindog dow ion nog len nog konaꞌ kimungan nog gotow.” ");
INSERT INTO suc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tibua, minsan siꞌoy maꞌ nituꞌ, diꞌ da dumalan og koponaksiꞌ nilan dianon. ");
INSERT INTO suc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dadi, minindog og kounutan nog boliananan koyon sog titongaꞌ nog gukum mangka non sakoy si Isus nog, “Olo ma og tabal mu dun og sumbunganan nog gotowanan koyon dianika?” ");
INSERT INTO suc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tibua, si Isus daꞌ pogonekonek. Dadi, sinakan nosop nog kounutan nog boliananan koyon si Isus nog, “Ika taꞌ og Kristu nog og Bataꞌ nog Mikpongon?” ");
INSERT INTO suc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tinumabal si Isus nog, “Akon ma. Bu motongow niu da og Binataꞌ sog Kilawan pogingkud dia dapit sog glintu nog Pogbayaꞌ posunguꞌ ion matong nog dia sog ginampol sog glangit.” ");
INSERT INTO suc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Puꞌun midongog nog kounutan nog boliananan koyon, linolingitan ion dun. Dadi, binogyang non og ponopoton non mangka ion poktaluꞌ nog, “Og gotow koni piglokaꞌlokaꞌan non og Mikpongon! Daꞌidun na balan ta nog taksiꞌ poꞌ ");
INSERT INTO suc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","midongog niu na nog piglokaꞌlokaꞌan non og Mikpongon. Dadi, olo ma og koposadan niu dun?” Piksolobukan nilan tumaluꞌ nog sumboy bunuꞌon si Isus. ");
INSERT INTO suc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tubus nituꞌ, og duma nilan dion, pigdulaꞌan nilan si Isus. Bu binunti nilan ion mangka nilan suntukoy kobon nilan mogwanwan dianon, “Atuk mu dow buan bog sima sinumuntuk koyon dianika!” Bu og polongipatanan koyon dianon piksuntuk nilan dosop si Isus. ");
INSERT INTO suc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Solian nog dion pa si Piter sog glomalomaan koyon, ngon sala kotow og glibun dion, og sosoligan nog kounutan nog boliananan koyon, minangoy sog glomalomaan koyon. ");
INSERT INTO suc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Dangan mitongow non si Piter sonuk non monalang, pigimotimot non ion mangka poktaluꞌ nog, “Ika siꞌoy og duma a dosop ni Isus nog gotow Nasaret.” ");
INSERT INTO suc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tibua, minonsing si Piter nog, “Diꞌ u sunan bog olo poktoluꞌon mu koyon otawaka bog sima pogolongon mu koyon!” Bu minangoy si Piter sog bongawan nog glomalomaan kituꞌ mangka poktukalaꞌ manuk. ");
INSERT INTO suc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dadi, dangan mitongow nosop nog glibun kituꞌ si Piter, miktaluꞌ ion sog gotowanan koyon nog pogindog dion, “Og gotow koni og duma ni Isus.” ");
INSERT INTO suc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tibua, pinonsingan nosop ni Piter. Daꞌ kobon golot non og gotowanan koyon nog mikpogindog dion miktaluꞌ dia ni Piter nog, “Daꞌidun og duaꞌduaꞌ non, ika, og duma a dosop ni Isus poꞌ ika siꞌoy miktidu a dosop sog Galili.” ");
INSERT INTO suc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dadi, miksumpasumpa tanan si Piter dun nog, “Bila diꞌ motud piktaluꞌ u koni, ngon matong dun sog kotubuꞌ u. Diꞌ u sunan bog sima og pogolongon mu koyon!” ");
INSERT INTO suc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Puꞌun miluksad og taluꞌ ni Piter koyon, miktukalaꞌ nosop og manuk nog koduaꞌ kali non. Kilobotan ni Piter og tinaluꞌ kituꞌ ni Isus dianon nog, “Mangka siꞌoy poktukalaꞌ manuk sog koduaꞌ kali non tolu kali mu na akon pononsingoy.” Dadi, miglulad si Piter. ");
INSERT INTO suc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dangan miksisolom bonua, og mokokotas nog boliananan, bu og polopanadanan nog botad nog bansa Hudyu, bu og kobogolalan koyon, bu glam nog polongukumanan dion, miksolabuk ilan na nog pikilan. Dadi, binalud nilan si Isus mangka nilan ogakoy dituꞌ ni Pilatu mangka nilan uokiloy dianon. ");
INSERT INTO suc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sinak ni Pilatu dia ni Isus nog, “Ika taꞌ og datuꞌ nog bansa Hudyu?” Tinumabal si Isus nog, “Mamaꞌ nog tinaluꞌ mu koyon.” ");
INSERT INTO suc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tubus nion, modakol og tinaluꞌ nog mokokotas nog boliananan koyon nog sumbungan nilan dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dadi, sinakan nosop ion ni Pilatu nog, “Tontong mu dow, modakol ma og sumbungan nilan koyon dianika. Olo nion, daꞌidun taꞌ og tobalan mu dun?” ");
INSERT INTO suc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bigyaꞌ non, si Isus daꞌ tabal. Dadi, kisobuꞌan si Pilatu dun. ");
INSERT INTO suc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Giap matong og tang nog kologyaꞌan nog ngalan non Liniusan, og botad ni Pilatu, poluason non sala kotow nog kinolobusu, ain bubuton nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ngon sala kotow nog kinolobusu, og ngalan non si Barabas. Si Barabas koni bu og dumaanan non, mingantu ilan sog polinta nog bansa Roma nog boyaꞌan mikobunuꞌ ilan tanan nog gotow. ");
INSERT INTO suc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dadi, modakol nog gotowanan mikpolani sog sunguꞌan ni Pilatu poꞌ pongonion nilan dianon nog inangon non mamaꞌ nog pogbotadon non kituꞌ nog tonton. ");
INSERT INTO suc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dadi, tinabal ilan ni Pilatu nog, “Moleg amu taꞌ nog poluason ku dianiu og Datuꞌ koni nog bansa Hudyu?” ");
INSERT INTO suc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Poꞌ kosunan ni Pilatu nog saꞌan og mokokotas nog boliananan, inuakil nilan si Isus dianon poꞌ miksibok ilan dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tibua, og mokokotas nog boliananan koyon, tinogol nilan og gotowanan koyon dion nog bubuton nilan si Barabas nog poluason, konaꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tinabal ni Pilatu ilan nog, “Dadi buan, olo ma og gondunon ku dia sog gotow koni nog iningolanan niu og Datuꞌ nog Bansa Hudyu?” ");
INSERT INTO suc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Miglongag ilan mogekes nog, “Kudus mu ion!” ");
INSERT INTO suc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tinabal ni Pilatu ilan nog, “Iduma? Olo og salaꞌ nog miinang nog gotow koni?” Tibua, posisayaꞌ nilan tanan posikadoy og gapis nilan nog, “Kudus mu ion!” ");
INSERT INTO suc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Dadi, si Pilatu, sabap sog kolegan non ombaꞌis pikilan nog gotowanan koyon dianon, piluas non si Barabas tidu sog kolobusuan mangka non na dondagoy nog pogbodason nilan si Isus mangka non uokiloy dia sog sundaluanan koyon nog kuduson nilan ion. ");
INSERT INTO suc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dadi, og sundaluanan koyon inoit nilan si Isus sog glomalomaan nog baloy nog gubernador koyon. Bu piglumpukan ion nog modakol nog sundaluanan. ");
INSERT INTO suc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pisolugan nilan ion nog glogdoy datuꞌ nog ompula. Tubus nituꞌ linumikid ilan nog bolagon nog dugion mangka nilan posolugoy dia sog gulu non ");
INSERT INTO suc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","mangka ilan pogbaluꞌbaluꞌ mogadab dianon. Long nilan dun, “Mololaki a ma le, og datuꞌ nog bansa Hudyu!” ");
INSERT INTO suc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tubus nituꞌ, pigbombal nilan ion sog gulu nog tagad nilan mangka nilan ion pogdulaꞌoy. Mikpongingluꞌud ilan sog sunguꞌan non poꞌ migbaluꞌbaluꞌ ilan sumugyut dianon. ");
INSERT INTO suc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tubus nilan pogwanwanoy si Isus, linuas nilan og glogdoy datuꞌ kituꞌ nog gompula nog pisolug nilan dianon mangka nilan posolugoy puliꞌ dianon og dili glogdoy non kituꞌ mangka nilan na pitangoy si Isus lumiu poꞌ kuduson nilan na. ");
INSERT INTO suc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sintak nilan ompanow, milumpak nilan si Simun tidu sog bukid. Ion og gotow Sirini. Bu ion og gamaꞌ ni Aleksander ilan ni Rupus. Tinogol nog sundaluanan koyon mokpopisan dianon og kudus ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dadi, inoit nilan si Isus sog bonua nog ngalan non, Golgota. (Og maꞌana non, bakuk nog gulu.) ");
INSERT INTO suc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dangan minatong ilan dituꞌ, piinum nilan bosia si Isus nog ginumon nog inompuꞌan nog bulung nog ngalan non Mira. Tibua, ompok ion minum dun. ");
INSERT INTO suc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tubus nituꞌ, mangka nilan na ion kudusoy. Og ponopoton non kituꞌ nog linuas nilan dianon, pigbahagiꞌ nilan bianan sog moglogindanan. ");
INSERT INTO suc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Og kolansang nilan koyon dia ni Isus sog kudus, og ginongaꞌ monek gondow. ");
INSERT INTO suc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Og sumbungan kituꞌ dia ni Isus sinulat nilan maꞌ nini, “Koni og Datuꞌ nog Bansa Hudyu.” ");
INSERT INTO suc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ngon duaꞌ kotow polonglaꞌug nog kinudus migimpang sog kilidan ni Isus.  ");
INSERT INTO suc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Og kibianbian non koni, og kotuman nog sinulat kituꞌ sog Kitab nog maꞌ nini, “Piitungan nilan dianon mamaꞌ nog og gotowanan kituꞌ nog diꞌ mokokunut sog botad.” ");
INSERT INTO suc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Og gotowanan koyon nog mikpomian dion, pigundaundaan nilan si Isus kobon nilan mokisingising bu mangka ilan poktaluꞌ nog, “Long nika dun, gobaꞌon mu dow og Baloy nog Poktomuyan mangka mu pindogoy mokpuliꞌ sog solod nog tolu ondow. ");
INSERT INTO suc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tobangoy mu dow buan og glawas mu bu tukpa a na sog kudus mu koyon.” ");
INSERT INTO suc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bu maꞌ nituꞌ dosop og gininang nog mokokotas nog boliananan koyon, ilan nog polopanadanan nog botad nog bansa Hudyu. Mikpoksitaluꞌ ilan nog wanwanan nilan dianon. Long nilan dun, “Mitabang non og duma gotow saka diꞌ non motabang og dili glawas non. ");
INSERT INTO suc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ion dow og Kristu, og Datuꞌ sog bansa Israel. Tontongon ta dow buan bog mokotukpa taꞌ dodaꞌ ion dia sog kudus non koyon. Bog mokotukpa dodaꞌ, mangka ita tud dianon.” Bu og polonglaꞌuganan kituꞌ nog kinudus sog molani non, pigwanwan nilan dosop si Isus. ");
INSERT INTO suc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dangan midopot tasondow, migdolom og tibuk nog bonua asta ginongaꞌ na monog gondow. ");
INSERT INTO suc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dangan miginongaꞌ monog gondow, miktaluꞌ si Isus nog mosikad, “Iloy, Iloy, lama sabaktani?” Og maꞌana non, “Diwata u, Diwata u, iduma pitiang mu ma akon?” ");
INSERT INTO suc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dangan midongog nog duma gotowanan koyon nog mikpogindog sog molani non koyon, baluꞌ nilan dun, og piktaluꞌ non kituꞌ, sinabi non si Iladya. ");
INSERT INTO suc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sala kotow dion ginumobok mangka alap nog ponopoton nog kodikpol bu molamit mangka potosopoy nog glanggow bu tukogoy sog sosungit, mangka non tokmoꞌoy dia sog babaꞌ ni Isus bagun non bosia mosoksop mangka ion poktaluꞌ nog, “Potiangon ta ion poꞌ tontongon ta bog ongoyon taꞌ dodaꞌ ion tobangoy ni Iladya.” ");
INSERT INTO suc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tubus nituꞌ, miktaluꞌ nosop si Isus nog mosikad, mangka na ion kotoktus. ");
INSERT INTO suc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sog tang koyon, og ponopoton kituꞌ nog modikpol og bolot dia sog dialom nog Baloy nog Poktomuyan dia sog Mikpongon, migbogyang poginongaꞌ tidu sog ditas mangoy sog silung. ");
INSERT INTO suc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bu og kounutan nog sundaluanan nog migindog sog sunguꞌan ni Isus koyon, dangan modongog non og taluꞌ ni Isus kituꞌ bu mitongow non bog olo og migandun mitoktus non, miktaluꞌ ion nog, “Motud dodaꞌ nog og gotow koni og Bataꞌ nog Mikpongon!” ");
INSERT INTO suc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ngon dosop dion kolibunanan nog mikpogbantoy sog molayuꞌlayuꞌ. Og dumaanan nilan dion si Maria Magdalena, si Salumi, bu si Maria og ginaꞌ ni Jems ilan ni Joses. Si Jems og koduaꞌ ngalan non, si Jems nog kongudan. ");
INSERT INTO suc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mikpogunut ilan dia ni Isus tidu sog Galili bu ilan og minaꞌub nog kulang ni Isus. Ngon pa modakol og kolibunanan nog migunut dianon mangoy sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Dangan ion miksindopondow na bonua, og gondow nog Poksimpan, poꞌ mogbolomaꞌ ion, og Gondow nog Pogulali. ");
INSERT INTO suc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ngon og sala kotow nog gotow Arimatea nog ngalan non si Jusep. Ion siꞌoy og polongukum dosop og sakup nog gukum nog bansa Hudyu nog pogodaban. Bu migdodama ion dosop nog pigdotuꞌan nog Mikpongon. Miksiboluꞌ ion mangoy mogbubut nog bangkoy ni Isus dituꞌ ni Pilatu. ");
INSERT INTO suc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Dadi, kisobuꞌan si Pilatu nog misompun patoy si Isus. Dadi, sinabi non og kounutan nog sundaluanan kituꞌ mangka non sakoy dianon bog motud taꞌ nog minatoy dodaꞌ si Isus. ");
INSERT INTO suc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Dangan midongog non nog minatoy na si Isus, tinugdak non na malap dia ni Jusep og bangkoy koyon. ");
INSERT INTO suc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Dadi, sinumaluy si Jusep nog bulus mangka non polusoy og bangkoy ni Isus koyon bu putusoy nog bulus koyon mangka non botangoy sog kukut kituꞌ sog pampang. Tubus nituꞌ, mangka non lilidoy nog mosolag nog batu og totimpong nog bongawan nog globong koyon. ");
INSERT INTO suc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Si Maria Magdalena, bu si Maria og ginaꞌ ni Joses, mitongow nilan og binotangan nog bangkoy ni Isus koyon. ");
INSERT INTO suc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dangan milibuas og Gondow nog Pogulali, si Maria Magdalena, bu si Salumi, bu si Maria og ginaꞌ ni Jems, minangoy ilan sumaluy nog glana momut bu pogomut poꞌ ongoyon nilan lonaoy og bangkoy ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dangan miksisolom bonua nog gondow Duminggu, bukaꞌsiang pa, mipanow ilan na sog binotangan nog bangkoy ni Isus kituꞌ. ");
INSERT INTO suc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sonuk nilan koyon ompanow, miksinaksakoy ilan bog sima gidoy tumabang dianilan lumilid nog batu kituꞌ nog piktimpong nog globong ni Isus. ");
INSERT INTO suc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tibua, dangan minatong ilan dituꞌ, mitongow nilan nog og batu kituꞌ nog mosolag linilid na. ");
INSERT INTO suc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dadi, sinumolod ilan sog dialom nog kukut koyon bu mitongow nilan og glaki nog bogu bataꞌ pa pogingkud dapit sog glintu bu og glogdoy non omputiꞌ. Kiondokan og kolibunanan koyon dun. ");
INSERT INTO suc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Dadi, miktaluꞌ og glaki koyon dianilan nog, “Naꞌ amu kondokan. Og ponontongon niu koyon nog si Isus nog ion og gotow Nasaret, nog kinudus, daꞌ na ion dini poꞌ mitubuꞌ na ion puliꞌ. Tontong niu poloꞌma og binotangan koyon dianon. ");
INSERT INTO suc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dadi, angoy niu taluꞌ dia sog sulangguꞌanan non kituꞌ asta dia ni Piter nog migunauna na ion dianilan dituꞌ sog Galili poꞌ dituꞌ ilan dona poktongow nog maꞌ nog tinaluꞌ non kituꞌ dianilan.” ");
INSERT INTO suc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dadi, ginumobok ilan mawaꞌ sog globong koyon dunut glukub nilan bu mibabong pikilan nilan. Daꞌ ilan pokopoguksug mogdayun nog kibianbianan nilan koyon kobal nog kiondokan ilan tokodoy.  ");
INSERT INTO suc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Dangan miksisolom bonua nog gondow Duminggu, mitubuꞌ si Isus tidu matoy. Sog tiganaꞌ, mikpotongow ion dia ni Maria Magdalena. Ion non glibun kituꞌ nog sibon tosopan nog pitu buk glatdiwata nog inawaꞌ ni Isus dianon. ");
INSERT INTO suc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dadi, minangoy si Maria moguksug sog dumaanan ni Isus koyon nog solian nilan lumangos, nog mitubuꞌ na ion mokpuliꞌ. ");
INSERT INTO suc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Dangan midongog nilan nog si Isus mitubuꞌ mokpuliꞌ bu mitongow ion ni Maria, daꞌ ilan tud dun. ");
INSERT INTO suc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tubus nituꞌ, sonuk ompanow og duaꞌ kotow koyon sulangguꞌanan non, mikpotongow ion dianilan nog miksop bayuꞌbayuꞌ non. ");
INSERT INTO suc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dadi, minuliꞌ ilan moguksug sog dumaanan nilan. Tibua, minsan maꞌ nituꞌ siꞌoy, daꞌ ilan pa tud dun. ");
INSERT INTO suc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tubus nituꞌ, tinumuaꞌ si Isus dituꞌ sog sopuluꞌ bu sala sulangguꞌanan non nog sonuk nilan poglokan. Pigbobaꞌan non ilan poꞌ daꞌidun kopongandol nilan bu ompok ilan tumud nog guksugan nog dumaanan nilan koyon nog mikotongow dianon tidu ion motubuꞌ puliꞌ. ");
INSERT INTO suc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Maꞌ long ni Isus dun dianilan, “Angoy amu sog glam nog binonsaan sog gliwag nog dunya bu ustal niu dianilan og Gombaꞌis nog Guksugan koni. ");
INSERT INTO suc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ain tumud bu pokpobunyag, motabang ion dia sog dusaanan non. Tibua, ain diꞌ tumud, poliholaꞌon ion sabap sog dusaanan non. ");
INSERT INTO suc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bu ain tinumud, mokopoginang ilan nog gingyataꞌanan nog maꞌ nini, bianan sog ngalan ku, mokopomugow ilan nog glatdiwataanan sog ain tinosopan dun. Bu moto ilan moktaluꞌ nog taluꞌ nog daꞌ nilan konadoy. ");
INSERT INTO suc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bu mokimud ilan nog mamak, bu bila mokinum ilan nog salod, diꞌ ilan da moglaꞌat dun. Bu bila doponan nilan og gotowanan nog diꞌ mokokodag, kuliꞌan ilan.” ");
INSERT INTO suc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Dadi, mitubus tibua toluꞌoy dianilan nog Kounutan nog si Isus, piiknat ion sog glangit. Bu dituꞌ ion miningkud sog dapit glintu nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tubus nituꞌ, og sulangguꞌanan non koyon, minangoy ilan sog ainain nog bonua mogustal sog gotowanan nog Gombaꞌis nog Guksugan paꞌali sog Mikpongon. Bu si Isus og Kounutan, ion og dinumuma dianilan. Bu bianan sog gininang nilan nog kosobuꞌsobuꞌ, miimung og pagon nog og guksugan nilan kituꞌ paꞌali dia ni Isus motud.");
INSERT INTO suc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Og sulat koni tidu dia ni Luk posunguꞌ dia ni Teopilus. Modakol og gotow nog migapas sumulat nog guksugan paꞌali sog piginang ni Isukristu kobon nog dini pa ion nita. ");
INSERT INTO suc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Og sinulat nilan kituꞌ ion non og piguksugan nog gotowanan kituꞌ dianami nog mikotaksiꞌ nog ginang non tidu pa sog tolipunan. Bu ilan dosop og mikpulonag nog Gombaꞌis kituꞌ nog Guksugan paꞌali sog ginang nog Mikpongon dia sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Dadi, akon, pigonadan ku dosop mahatul og glam non kituꞌ tidu pa sog tolipunan non. Mipikil u dosop nog pokpolaspolason ku sumulat og guksugan paꞌali dianon bu poiton ku dianika, Pogodaban Teopilus, ");
INSERT INTO suc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","bagun mu da kosunan nog motud dodaꞌ og pianad kituꞌ dianika nog sakup ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kobon pa nog si Herod og migdatuꞌ sog probinsia nog Judia, ngon sala kotow bolian nog bansa Hudyu og ngalan non si Sakaraya. Ion og sakup nog sala kampung nog boliananan kituꞌ nog dia sog pangkat ni Apuꞌ Abidya. Bu og ngalan nog duoy non si Elisabet. Ion siꞌoy miktidu dosop dia sog pangkat ni Apuꞌ Aron. ");
INSERT INTO suc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Og pogduoy koyon midulus og kotubuꞌ nilan dia sog motaan nog Mikpongon bu ondaꞌ ilan kosimoy dia sog glam nog dondagan bu glam nog poꞌatan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tibua, daꞌidun og bataꞌ nilan poꞌ si Elisabet, asta mogulang na, ondiꞌ mogbataꞌ. ");
INSERT INTO suc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dadi, dangan minatong na og tang nog sakup nog kampung ni Apuꞌ Abidya og mogokbit sog Baloy nog Poktomuyan dia sog Mikpongon, si Sakaraya og bolian dun. ");
INSERT INTO suc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Poꞌ og botad nog boliananan, moglogindanan ilan bog sima tumutung nog komangyan dia sog poktutungan nilan kituꞌ sog dugu kituꞌ nog mosigda. Bu si Sakaraya og mipiliꞌ nilan. ");
INSERT INTO suc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sonuk ni Sakaraya moktutung nog komangyan, glam nog gotowanan dion, sosuku og miktamuy, migyakin ilan sog glowasan. ");
INSERT INTO suc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sonuk ni Sakaraya tumutung, gomonsunoy pa, og moloikat nog Mikpongon mikpotongow dianon nog dia pogindog sog dapit glintu nog poktutungan nog komangyan koyon. ");
INSERT INTO suc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Dadi, kitokowan ion bu kiondokan dun dangan mitongow non. ");
INSERT INTO suc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tibua, miktaluꞌ og moloikat koyon nog, “Naꞌ a kondokan Sakaraya poꞌ og gyakin mu midongog nog Mikpongon. Og duoy mu nog si Elisabet mogbataꞌ nog glaki bu sumboy ingolanan mu ion nog Jan. ");
INSERT INTO suc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Bu bila botaꞌon og bataꞌ koyon, landuꞌ gloliag mu dun bu modakol dosop og gotowanan og mogdaꞌdaꞌ dun. ");
INSERT INTO suc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Og bataꞌ niu koyon mimung motas dia sog motaan nog Mikpongon. Bu sumboy diꞌ ion minum nog sosuku mokobisa. Bu tidu sog kobataꞌ dianon, dia non na og Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bu bianan dianon modakol og pangkat ni Apuꞌ Israel og motiguliꞌ dia sog Mikpongon nog Kounutan nilan. ");
INSERT INTO suc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Bu ion moguna dia sog Kounutan. Mongon dianon og bolakat bu og bayaꞌ mamaꞌ nog bolakat kituꞌ bu og bayaꞌ nog dia ni Iladya, og polomolatas kituꞌ nog taluꞌ nog Mikpongon kobon nituꞌ. Bu sabap sog pomali nog bataꞌ mu koyon, og mokogulanganan bu og gombataꞌanan nilan nog daꞌ pomoksulut, motiguliꞌ ilan dun. Bu og gotowanan kituꞌ nog ondaꞌ pokokunut sog glegan nog Mikpongon, mokpuliꞌ na dia sog Mikpongon bu mokopikil ilan na moginang nog kodulusan. Bianan dianon, og gotowanan mosimpan sog kodatong nog Kounutan nilan.” ");
INSERT INTO suc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tubus nion, miktaluꞌ si Sakaraya dia sog moloikat koyon nog, “Olo ma kisunoy u dun nog og taluꞌ nika koyon motuman dodaꞌ? Poꞌ mogulang ami na!” ");
INSERT INTO suc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Dadi, tinumabal og moloikat koyon nog, “Akon si Gabriel nog miktidu dituꞌ sog sunguꞌan nog Mikpongon. Ion og dinumondag dianakon mangoy dini nika mangoy mogabit nog molongas nog guksugan koni. ");
INSERT INTO suc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tibua, sabap nog ondiꞌ a ma tumud nog tinaluꞌ u koni nog saka motud bosia, moktimaluy a bod. Moktolipun numun kituꞌ diꞌ a mokopoktaluꞌ asta sog gondow nog motuman na og piktaluꞌ u koni dianika.” ");
INSERT INTO suc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Og gotowanan sop kituꞌ nog migbagad dia ni Sakaraya dia sog glowasan nog Baloy nog Poktomuyan koyon, kisobuꞌan ilan bog olo og kiobon non sog dialom. ");
INSERT INTO suc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dangan linumiu si Sakaraya, ondiꞌ na ion mokopoktaluꞌ. Dadi, misabut nilan nog ongon pitongow nog Mikpongon dianon sonuk nog dituꞌ ion sog dialom. Dadi, sabap nog diꞌ ma ion mokopoktaluꞌ, mikpopononggiꞌ tibua ion dia sog gotowanan koyon dion. ");
INSERT INTO suc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Dangan midoksuꞌ na og polosukuꞌan ni Sakaraya dia sog Baloy nog Poktomuyan koyon, minuliꞌ ion dituꞌ sog bonua nilan. ");
INSERT INTO suc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tubus nituꞌ, si Elisabet migbogat dodaꞌ, bu lima bulan nog daꞌ ion pogliuliu sog baloy. ");
INSERT INTO suc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Bu miktaluꞌ ion nog, “Kilolatan u dodaꞌ tokodoy nog Pogbayaꞌ poꞌ bianan sog gininang non koni dianakon, miawaꞌ og sipogan ku dun dia sog gotowanan.” ");
INSERT INTO suc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Dangan midopot na gonom bulan og tian ni Elisabet, og moloikat kituꞌ nog si Gabriel dinondag nosop nog Mikpongon mangoy dituꞌ sog Nasaret nog sakup nog probinsia nog Galili, ");
INSERT INTO suc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","mangoy moguksug dia sog sala kotow dolaga nog daꞌ sibon kotuyok, og ngalan non si Maria. Si Maria koni, pigbayal ilan na ni Jusep og pangkat ni Apuꞌ Dabid. ");
INSERT INTO suc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bu og moloikat koyon mikpolani dianon mangka poktaluꞌ nog, “Og kotiknaꞌ nog pikilan mongon dianika, poꞌ pipia a nog Mikpongon bu Ion dion nika.” ");
INSERT INTO suc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dadi, kiondokan dun si Maria dangan midongog non og piktaluꞌ nog moloikat koyon, bu pikpikilpikil non bog olo og maꞌana nog kogolun kituꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bu miktaluꞌ nosop og moloikat koyon dianon nog, “Naꞌ a kondokan Maria, poꞌ kisuꞌatan dianika og Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Poꞌ diꞌ mobon mogbogat a. Bu bila mogbataꞌ a na, og bataꞌ mu og glaki bu ingolanoy mu ion nog Isus. ");
INSERT INTO suc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bu ion mimung nog motas bu og pogingalan dianon nog Bataꞌ nog Mikpongon. Og Mikpongon diꞌ kolobian. Bu ion og Pogbayaꞌ. Tugdakon non dianon og kopogdatuꞌ nog pangkat non kituꞌ nog si Dabid. ");
INSERT INTO suc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Bu ion og mogdatuꞌ dia sog pikpongkatan ni Jakub. Og kopogdatuꞌ non daꞌidun kopus non.” ");
INSERT INTO suc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Dadi, miktaluꞌ si Maria dia sog moloikat koyon nog, “Olo mogandun kopogbogat u nog daꞌ u pa tanan sibon kotuyok?” ");
INSERT INTO suc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tinumabal og moloikat koyon nog, “Og Bolakat nog Mikpongon tumonaꞌ dianika. Bu kotindungan ka nog bayaꞌ nog Mikpongon nog diꞌ kolobian. Dadi, og bataꞌ mu koyon daꞌ dusa non bu og pogingalan dianon og Bataꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Midongog mu taꞌ og goguapuꞌ mu kituꞌ nog si Elisabet, taluꞌ nog gotowanan dun, ondiꞌ na dow ion mogbataꞌ? Tibua, tontong mu, minsan siꞌoy mogulang na, numun koni gonom bulan na og tian non. ");
INSERT INTO suc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Poꞌ daꞌidun og mologon dia sog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tinumabal si Maria nog, “Akon koni, sagya u da og sosoligan nog Mikpongon. Dadi, molongas u da bila motuman dianakon og poktoluꞌon mu koyon.” Tubus nituꞌ, ginonatan ion nog moloikat koyon. ");
INSERT INTO suc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Dadi, migulikos si Maria mangka pogdaliꞌ dituꞌ sog kobukidan nog probinsia nog Judia, sog bonua ni loꞌ Sakaraya. ");
INSERT INTO suc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Dangan minatong ion dituꞌ sog baloy ni loꞌ Sakaraya, sinumolod ion bu ginolun non si Elisabet. ");
INSERT INTO suc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Dangan midongog ni Elisabet og taluꞌ ni Maria, migdodial mogdayun og bataꞌ dia sog dialom tian non. Bu og Bolakat nog Mikpongon minuluꞌ mogdayun dia ni Elisabet ");
INSERT INTO suc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","bu mangka ion poktaluꞌ nog mosikad nog, “Sog glam nog kolibunanan, ika og pipia nog Mikpongon. Bu popiaon dosop og bataꞌ koyon dia sog dialom tian mu. ");
INSERT INTO suc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ondaꞌ u tokodoy bibolaꞌoy nog og ginaꞌ nog Kounutan ku mokoponumbaloy dini nakon. ");
INSERT INTO suc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Saꞌan kisunan ku nog ika og ginaꞌ non, poꞌ dangan mibatik u ika, og bataꞌ koni sog dialom tian ku, migdayun mogdodial dun. ");
INSERT INTO suc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pipia a nog Mikpongon poꞌ sabap sog tud mu nog glam nog piktaluꞌ nog Mikpongon dianika, motuman nododaꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dadi, tinumabal si Maria, “Landuꞌ og sanglit u sog Pogbayaꞌ ");
INSERT INTO suc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","bu landuꞌ og daꞌdaꞌan ku poꞌ ion og Polonabang u. ");
INSERT INTO suc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Poꞌ daꞌ non akon suꞌusa kolingowoy minsan siꞌoy sagya u da ombabaꞌ nog sosoligan non. Dadi, moktolipun sog numun koni, og glam nog gotowanan moktaluꞌ nog akon pipia u nog Mikpongon ");
INSERT INTO suc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","poꞌ ion og diꞌ kontuan, mosolag og tabang nog miinang non dianakon. Mosigda og ngalan non. ");
INSERT INTO suc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tidu sog tiganaꞌ nog pangkat momangkat pitongow nog Mikpongon og glolat non dia sog glam nog gotowanan nog ain mogadab dianon. ");
INSERT INTO suc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bianan sog Bolakat non, pikpolaꞌ non og mokpotaspotas kituꞌ sog dialom pikilan non, ");
INSERT INTO suc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","mangka non pobobaꞌoy og mokokosog nog kodotuꞌan, bu potasoy og mikpobabaꞌ nog bolotabat non. ");
INSERT INTO suc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Piokan non og kigutoman nog sosuku mokobaꞌis, tibua, binugow non og pongdoyahan kituꞌ, nog daꞌidun og binogoy non dun. ");
INSERT INTO suc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ita og sosoligan non nog bansa Israel, tinobangan non ita. Bu daꞌ non kolingowoy og glolat non ");
INSERT INTO suc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","dia ni Apuꞌ Abraham bu glam nog pangkatanan non. Poꞌ tinuman non og pasad non dia sog mokogulanganan ta kituꞌ kobon nituꞌ asta sog pangkatanan nilan kituꞌ asta nog daꞌ kopus non.” ");
INSERT INTO suc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tubus nion, minguliꞌan si Maria dituꞌ ni Elisabet goktob nog tolu bulan mangka ion uliꞌ. ");
INSERT INTO suc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Dadi, dangan minatong og tang nog pogbotaꞌan ni Elisabet, migbataꞌ ion nog glaki. ");
INSERT INTO suc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bu glam nog sumbaloyanan non bu og pigoloanan non, mikpogdaꞌdaꞌ ilan dosop dangan midongog nilan nog kololatan tokodoy ion nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Dangan og bataꞌ koyon midopot walu ondow tidu botaꞌon, inangoy nilan tukoy ion. Bu songoyon nilan bosia og ngalan nog bataꞌ koyon dia sog ngalan nog gamaꞌ non nog si Sakaraya. ");
INSERT INTO suc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tibua, si Elisabet miktaluꞌ nog, “Diꞌ mogusoy! Poꞌ sumboy og ngalan non si Jan.” ");
INSERT INTO suc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dadi, mikpoktaluꞌ sala duaꞌ nog, “Oꞌo ma, tibua, sog glam nog pigilugananan nika daꞌidun pa maꞌ nion og ngalan non.” ");
INSERT INTO suc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mangka ilan pononggiꞌ dia ni Sakaraya bog sima og kolegan non og ngalan nog bataꞌ non koyon. ");
INSERT INTO suc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dadi, minonggiꞌ si Sakaraya nog bogayan ion nog ponulatan non mangka ion sulat nog, “Og ngalan non si Jan.” Dangan mitongow nog gotowanan og sinulat non koyon, kisobuꞌan ilan dun. ");
INSERT INTO suc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tubus non tibua sulatoy og ngalan koyon, miglandan ion mokopoktaluꞌ puliꞌ. Bu miksanglit ion mangka pokposolamat sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Og sumbaloyanan nilan, kisobuꞌan ilan dun dunut gondok nilan. Bu og dongogan koyon mipulonag mogdayun sog kobukidan nog probinsia nog Judia sabap sog guksugan nog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Dadi, ain mikodongog dun, mikpikilpikil ilan bog olo gidoy og bataꞌ koyon bila sumolag na poꞌ motampal tokodoy nog dianon og Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tubus nituꞌ, si Sakaraya og gamaꞌ nog bataꞌ koyon tinosopan nog Bolakat nog Mikpongon mangka pomitua nog taluꞌ nog Mikpongon nog, ");
INSERT INTO suc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Sanglit sog Mikpongon, og piktamuy nog bansa Israel poꞌ inangoy non tobangoy og pigotowan non. ");
INSERT INTO suc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bu pituaꞌ non dianita og bolokatan nog Polonabang nog ion tidu dia sog pangkat nog sosoligan kituꞌ nog Mikpongon nog si Apuꞌ Dabid. ");
INSERT INTO suc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kobon nituꞌ pa bianan sog polomolatasanan non kituꞌ nog midulus, ");
INSERT INTO suc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","pinasad non na nog tobangan non nododaꞌ ita tidu sog bantaanan ta bu tidu sog bayaꞌ nog ain mokangit dianita. ");
INSERT INTO suc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bu miktaluꞌ ion nog potongowon non og glolat non dia sog mokogulanganan ta kituꞌ bu ondiꞌ non nododaꞌ poksolingawan og pasad non dianilan. ");
INSERT INTO suc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Og pasad kituꞌ, ion non og pinasad non kituꞌ dia ni Apuꞌ Abraham nog tobangan non ita tidu sog bayaꞌ nog bantaanan ta ");
INSERT INTO suc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","bagun ita da mokokunut dianon bu ondiꞌ ita mondok dia sog bantaanan ta, ");
INSERT INTO suc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","bu bagun dosop modulus og kotubuꞌ ta bu molonuꞌ og pikilan ta dia sog motaan non solian totubuꞌ ita pa. ");
INSERT INTO suc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Bu ika sop bataꞌ u, sog gunanunan koyon, ingolanan ka nog polomolatas nog Mikpongon nog ion ondiꞌ kolobian. Moguna a dia sog kounutan ta moksimpan nog bianan non. ");
INSERT INTO suc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Poꞌ posunon mu dia sog pigotowan nog Mikpongon paꞌali sog tabang non dianilan bianan sog kopongampun nog dusaanan nilan ");
INSERT INTO suc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","sabap sog landuꞌ tokodoy og glolatan non dianilan. Og bayuꞌ nog kotabang non dianita ompononggiꞌ sog gondow nog mimolaꞌas dia sog silangan nog posunguꞌ na sumilow dianita. ");
INSERT INTO suc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Poꞌ ampun matong ion dini nita, ain dia sog kodoloman otawaka sog kopotayan, kosilowan ilan na nog dolag non bagun ilan da koponuluꞌan dia sog kotiknaꞌ nog kopoglokotubuꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bu og bataꞌ koyon sinumolag bu mipagon og pikilan non dia sog Mikpongon. Bu dituꞌ ion migonong sog bonua nog mologon pogonongan asta minatong og gondow nog mangoy ion mokpulonag nog pomali sog gotow Israelanan. ");
INSERT INTO suc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sog tang koyon, si Datuꞌ Agustu og migdatuꞌ dia sog glam nog bonuaanan nog mikaum nog bansa Roma. Dinondag non ain og misakup dia sog pigdotuꞌan non nog sumboy mangoy ilan mokpolista. ");
INSERT INTO suc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Og ginang koni nog monglista nog ngalan nog gotowanan ugat pa ini kinang dia sog bonua nog Siria masa nog kopoglogubernador ni Kirinius. ");
INSERT INTO suc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Dadi, kokonia dianilan sumboy mangoy ilan mokpolista dia sog dili bonua nog ganakapuꞌanan nilan. ");
INSERT INTO suc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Dadi, si Jusep tidu sog koliwagan bonua nog Nasaret nog misakup sog probinsia nog Galili tinumukad dosop dituꞌ sog koliwagan bonua ni Datuꞌ Dabid sog Betlehem nog dia misakup sog probinsia nog Judia poꞌ ion og pangkat ni Dabid. ");
INSERT INTO suc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bu si Maria, og posunguꞌ non kituꞌ pogduoyon, migunut dosop dianon mangoy mokpolista. Sog tang koyon mosolag na og tian ni Maria. ");
INSERT INTO suc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kobon nilan dituꞌ sog Betlehem, kisoꞌutan nog migbataꞌ si Maria. ");
INSERT INTO suc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Og bataꞌ non koyon og glaki. Tiganaꞌ non pa ion mogbataꞌ. Pilimumuꞌan non mangka non bolilidoy sog bogan poꞌ mitipot na og duguanan dion botukoy nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bu ngon og polongipatanan nog bilibilianan sog bukidbukid nog koliwagan bonua koyon nog migonduk ilan mogipat nog bilibilianan nilan. ");
INSERT INTO suc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sintak nilan mogonduk, mikpotongow dianilan og moloikat nog Mikpongon bu og dolag tidu sog Mikpongon sinumilow dianilan. Dadi, kiondokan ilan tokodoy dun. ");
INSERT INTO suc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tibua, miktaluꞌ og moloikat koyon dianilan nog, “Naꞌ amu mondok poꞌ ngon og molongas nog guksugan nog toluꞌon ku dianiu nog mimung landuꞌ daꞌdaꞌan nog glam nog gotowanan sog dunya. ");
INSERT INTO suc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Poꞌ gondow koni, og Polonabang niu, nog ion og Kristu, og Kounutan, binataꞌ na dituꞌ sog koliwagan bonua ni Dabid. ");
INSERT INTO suc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Og gindanan niu nog ion non dodaꞌ og bataꞌ koyon nog pogolongon ku, motongow niu ion pinutus nog glimumuꞌ bu binolilid dia sog bogan.” ");
INSERT INTO suc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Gomonsunoy pa mikponuaꞌ og landuꞌ kodakol nog moloikatanan tidu sog glangit minangoy mampuꞌ dia sog solabuk moloikat koyon mangka ilan poksanglit sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Long nilan dun, “Sanglit sog Mikpongon dituꞌ sog glangit, bu mongon og gomigus dia sog gotowanan kituꞌ dini sog dunya, ain kisuꞌatan og Mikpongon dun.” ");
INSERT INTO suc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Dangan ginonatan ilan nog moloikatanan koyon bu minuliꞌ ilan na dituꞌ sog glangit, miksitaluꞌ og polongipatanan koyon nog bilibilianan nog, “Alung, mangoy ita sog Betlehem! Ongoyon ta tontongoy bog olo miinang koyon dituꞌ, nog pinosun nog Mikpongon dianita.” ");
INSERT INTO suc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dadi, mikpogdaliꞌdaliꞌ ilan mangoy dituꞌ sog Betlehem. Minatong ilan dituꞌ, mitongow nilan dion si Maria bu si Jusep, bu mitongow nilan dosop og popula nog binolilid dia sog bogan. ");
INSERT INTO suc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Dangan mitongow nilan, piguksugan nilan dion og paꞌali dia sog bataꞌ koyon nog piosun nog moloikat dianilan. ");
INSERT INTO suc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bu glam nog mikodongog nog bitan nilan koyon, kisobuꞌan ilan dun. ");
INSERT INTO suc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tibua, piktitukan ni Maria og glam nog midongog non koyon bu tinaguꞌ non sog dialom pikilan non. ");
INSERT INTO suc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tubus nion, minuliꞌ og polongipatanan nog bilibilianan koyon dunut mikpogdaꞌdaꞌ ilan kobon nilan moksanglit sog Mikpongon sabap sog glam nog midongog bu mitongow nilan poꞌ motud dodaꞌ og glam nog tinaluꞌ nog moloikat kituꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dangan midopot na og gondow nog sumboy ion tukon, og kowalu ondow non tidu ion botaꞌon, tinuk nilan ion mangka nilan ingolanoy nog Isus. Ion non ion og ngalan nog binogoy nog moloikat kituꞌ nog kobon nog daꞌ pa si Maria pogbogat dun. ");
INSERT INTO suc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Dangan mitoktub na og ginondowan nog inangon og poꞌatan kituꞌ nog sinulat ni Muses kobon nituꞌ nog ngalan non og poglonuꞌ tidu mogbataꞌ, minangoy si Maria bu si Jusep dituꞌ sog Jerusalem, sog Baloy nog Poktomuyan dia sog Mikpongon poꞌ momalas ilan dituꞌ. Bu pinitang nilan og bataꞌ nilan koyon poꞌ uokilon nilan ion dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Poꞌ tinaluꞌ dosop dia sog poꞌatan nog sinulat ni Muses nog og glam nog tiganaꞌ nog bataꞌ bila glaki, sumboy nododaꞌ uokilon sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dadi, inunut nilan og pogbotadon kituꞌ nog binogoy nog Mikpongon dia ni Muses nog sumboy momalas ilan nog duaꞌ buk kolopati dokoꞌ bu dolukan otawaka duaꞌ buk kolopati nog mokolobud pa. ");
INSERT INTO suc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tubus nion, ngon sala kotow ngalan non si Simiun nog dion sog Jerusalem. Midulus ion bu polotamuy sog Mikpongon, bu dia non dosop og Bolakat nog Mikpongon. Migbagad ion nog tabang nog Mikpongon dia sog bansa Israel. ");
INSERT INTO suc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bu pisabut nog Bolakat nog Mikpongon dianon nog ondiꞌ ion matag matoy taman da ondiꞌ non motongow poguna og Kristu nog miktidu sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dadi, pinuluꞌan ion nog Bolakat nog Mikpongon mangoy dituꞌ sog Baloy nog Poktomuyan dia sog Mikpongon. Daꞌ kobon, minatong si Maria bu si Jusep dion sog Baloy nog Poktomuyan koyon bu pinitang nilan og bataꞌ nilan koyon mangoy tumuman dianon nog poꞌatan kituꞌ nog sinulat ni Muses kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Dangan mitongow ni Simiun og bataꞌ koyon, pigdoyunan non sumipit mangka ion pokposolamat sog Mikpongon nog, ");
INSERT INTO suc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mikpongon, songlitan ku ika, poꞌ ika og Pogbayaꞌ sog glam non. Bu tinuman mu og pasad mu. Dadi, numun kituꞌ minsan siꞌoy matoy u na, ombaꞌis na pikilan ku ");
INSERT INTO suc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","poꞌ mitongow u na og polonabang tidu dianika ");
INSERT INTO suc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nog sinimpan mu dia sog tinontongan nog glam nog gotow ");
INSERT INTO suc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","nog miimung ion nog dolag sumilow dia sog gotowanan nog konaꞌ Hudyu bagun nilan mosabut bog olo og glegan mu dianilan, bu bagun da kodongyaꞌan og bansa Israel, og pigotowan mu.” ");
INSERT INTO suc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Dangan miluksad og taluꞌ ni Simiun koyon, kisobuꞌan si Jusep ilan ni Maria nog glam nog piktaluꞌ nog mogulang koyon paꞌali sog bataꞌ koyon. ");
INSERT INTO suc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tubus nituꞌ, pigyokinan ilan ni Simiun mangka ion poktaluꞌ dia ni Maria nog, “Og bataꞌ koni og piniliꞌ nog Mikpongon. Sabap dianon, modakol gotow Israel og moglaꞌat. Bu modakol dosop og motabang. Bu mimung dosop ion nog gindanan tidu sog Mikpongon nog susion nilan ion. ");
INSERT INTO suc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Bianan dion mitampal og doksuꞌan nog dialom pikilan nog modakol nog gotowanan. Bu ika siꞌoy, og ginaꞌ non, miimung kosokitan pusung mu dun maꞌ nog kodoksoꞌan nog kalis.” ");
INSERT INTO suc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Bu ongon og mogulang glibun sog bonua koyon, og mokosun bu og ngalan non si Ana. Ion og bataꞌ ni Panuel bu og pangkat ion ni Apuꞌ Aser. Og mogulang koyon mikobian na mogduoy goktob nog pitu ton. ");
INSERT INTO suc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tibua, asta sog numun koni, balulibun pa bu ngon na tanan walu puluꞌ bu pat og tinonan non. Bu kobon non dia ion sog Baloy nog Poktomuyan dia sog Mikpongon, moktamuy ion gobi gondow bianan sog mogyakin bu mokpuasa. ");
INSERT INTO suc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Linumpak non si loꞌ Jusep mangka pokposolamat sog Mikpongon bu mangka non ustaloy dia sog gotowanan paꞌali sog bataꞌ koyon, sog ain og migdodama kituꞌ nog tabang nog Mikpongon dia sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Dangan midoksuꞌ ni loꞌ Jusep inangoy og polosukuꞌan nilan koyon nog botad tidu sog Mikpongon, minuliꞌ ilan na dituꞌ sog koliwagan bonua nog Nasaret nog dia sog sakup nog Galili. ");
INSERT INTO suc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bu og bataꞌ koyon sinumolag bu modasig. Bu ompantas og pomikilan non, bu og popia nog Mikpongon dianon kobon non. ");
INSERT INTO suc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Giap nog ton, og mokogulang ni Isus, mangoy ilan sog Jerusalem sumakup nog kologyaꞌan nog Hudyuanan nog iningolanan og Liniusan. ");
INSERT INTO suc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Dangan midopot na sopuluꞌ bu duaꞌ og tinonan non, minangoy ilan nosop sumakup sog kologyaꞌan poꞌ maꞌ nituꞌ og kiloyaman nilan. ");
INSERT INTO suc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Dangan midoksuꞌ na og kologyaꞌan koyon, og glam nog gotowanan mikponguliꞌ na sog konia konia bonuaanan nilan. Bigyaꞌ non, si Isus ondaꞌ dion sog gluyud koyon poꞌ mibagak dituꞌ sog Jerusalem. Tibua, daꞌ ion kosunoy nog mokogulang non ");
INSERT INTO suc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","poꞌ baluꞌ nilan dun, og bataꞌ nilan koyon dion da sog gluyud nilan koyon. Dadi, mipanow ilan sumondow koyon mangka nilan pa tolipunoy monontong dia sog pigoloan nilan bu sog pakasibataꞌanan nilan. ");
INSERT INTO suc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tibua, daꞌ nilan kotongow dion. Dadi, pinuliꞌ nilan monontong dituꞌ sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sog kotolu ondow non, sokaliꞌ nilan mitongow si Isus dituꞌ sog dialom nog Baloy nog Poktomuyan dia nog Mikpongon mikpogadapadap ilan nog polopanadanan nog botad nog bansa Hudyu. Og piginang ni Isus monginongog nog glam nog bitan nog gotowanan koyon bu moksak dosop dianilan. ");
INSERT INTO suc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Dadi, og glam nog mikodongog nog taluꞌ ni Isus koyon, kisobuꞌan ilan poꞌ bianan sog tabal non motongow nilan ompantas og sabut non. ");
INSERT INTO suc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bu og mokogulang non, kisobuꞌan ilan dosop dianon dangan mitongow nilan ion sog Baloy koyon nog Poktomuyan. Dadi, sinabi ion nog ginaꞌ non bu toluꞌoy nog, “Nuꞌ, iduma maꞌ nion ma og piginang mu dianami? Saka misusa ami monontong dianika?” ");
INSERT INTO suc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Dadi, tinumabal si Isus nog, “Daꞌ niu na bosia akon ponontongoy sog ainain nog bonua, poꞌ ondaꞌ niu taꞌ kosunoy nog dini u nododaꞌ sog baloy nog Gamaꞌ u?” ");
INSERT INTO suc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tibua, og mokogulang non koyon, ondaꞌ nilan kosabut og maꞌana nog piktaluꞌ ni Isus koyon. ");
INSERT INTO suc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tubus nion, si Isus migunut na dia sog mokogulang non koyon muliꞌ dituꞌ sog Nasaret bu mikokunut ion sog glam nog glegan nog mokogulang non koyon. Tibua, og glam nini tinaguꞌ nog ginaꞌ non dia sog dialom pikilan non. ");
INSERT INTO suc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Bu og bataꞌ koyon tinumulin bu pododungag og kotoan non, bu pododungag kosuꞌatoy dianon og Mikpongon bu og gotowanan. ");
INSERT INTO suc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sog kosopuluꞌ bu lima ton nog kopogdatuꞌ ni Datuꞌ Tiberias, si Puntus Pilatu og gubernador dia sog Judia. Si Herod, og miglokounutan dia sog bonua nog Galili, bu og gilug non kituꞌ nog si Pilip miglokounutan dia sog bonua nog Iturea bu Trankonitis, bu og miglokounutan dia sog bonua nog Abilen si Lisinas. ");
INSERT INTO suc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Og tang koni si Anas bu si Kaypas og kounutan nog boliananan nog bansa Hudyu. Bu si Jan, og bataꞌ kituꞌ ni Sakaraya, dituꞌ migonong sog bonua kituꞌ nog mologon pogonongan. Bu ongon og tinaluꞌ nog Mikpongon dianon. ");
INSERT INTO suc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Dadi, minangoy ion momali dia sog glam nog bonuaanan nog mingigbid sog glawas nog tubig nog Jurdan. Og pomali non koyon paꞌali dia sog kopoglilaꞌ nog dusa mangka pokpobunyag bagun ilan kompunan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ion non ini og kotumanan nog taluꞌ nog Mikpongon nog sinulat nog polomolatas non nog si Isaya kobon nituꞌ nog, “Ngon og moktawag sog bonua kituꞌ nog mologon pogonongan nog, ‘Simpan niu og bianan nog Pogbayaꞌ nog posunguꞌ matong bu pologdong niu og dalan non. ");
INSERT INTO suc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Glam nog kobuludbuludan bu globaklobakanan sumboy potagon, glam nog molikuꞌ nog dalan sumboy pologdongon, bu ain og mikpoglaꞌat sumboy pogusayan. ");
INSERT INTO suc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bianan dion, motongow nog glam nog gotow og tabang nog Mikpongon.’” ");
INSERT INTO suc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dadi, modakol nog gotowanan og mikpogangoy dituꞌ non poꞌ mangoy ilan mokpobunyag dianon. Tibua, maꞌ long ni Jan dia sog duma gotowanan koyon dion, “Amu, og tupuꞌanan amu nog mamak kituꞌ nog molala! Sima og miktaluꞌ dun dianiu nog mokopolaguy amu sog posunguꞌ koyon matong nog polihalaꞌ nog Mikpongon? ");
INSERT INTO suc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sumboy potongowon niu nog miktantu amu tumolikud dia sog dusa niu bianan sog glangkalangka niu. Bu naꞌ amu sumalig nog dangan pa pangkat amu ni Abraham nog motabang amu na. Poꞌ toluꞌon ku dianiu, bila tibobaꞌon nog Mikpongon, minsan og batuanan koni moktimaluy nog pangkat ni Abraham. ");
INSERT INTO suc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Og bayuꞌ nog kopongukum nog Mikpongon ompononggiꞌ dia sog kapa nog pitom na dia sog pun nog kayu nog posunguꞌ na ponogaꞌon. Bu ain og kayu kituꞌ nog ondiꞌ mogbunga nog molongas, ponogaꞌon mangka tikpuꞌoy sog gapuy.” ");
INSERT INTO suc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","“Dadi, olo ma buan og ginangon nami dun?” Maꞌ long nog gotowanan koyon dun. ");
INSERT INTO suc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tinabal non ilan nog, “Bila ongon dianiu og togo logdoy duaꞌ buk, bogoy niu og solabuk koyon dia sog ain daꞌidun glogdoy non. Bu bila ongon ponganon niu, otuloy niu og daꞌidun kituꞌ og ponganon non.” ");
INSERT INTO suc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ongon dosop og polongabatanan nog buis minangoy mokpobunyag dion. Miksak ilan dia ni Jan nog, “Polopanad, ami sop buan, olo ma sumboy inangon nami?” ");
INSERT INTO suc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tinabal non ilan, “Bila mongabat amu nog buis, naꞌ niu posowadan.” ");
INSERT INTO suc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bu ongon og sundaluanan dion nog miksak ilan dosop dianon nog, “Ami sop buan, olo sop sumboy inangon nami?” Tinabal ilan sop ni Jan nog, “Naꞌ niu na pongondokon otawaka pongimungan og gotow bagun amu mokosin dun. Sugaꞌid non, tolimaꞌ niu ain tindanan kituꞌ dianiu.” ");
INSERT INTO suc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dangan ion maꞌ nion, og gotowanan koyon nog migdodama nog pasad nog Mikpongon kituꞌ, mikpikilpikil ilan bog konaꞌ taꞌ gidoy ni Jan og Kristu? ");
INSERT INTO suc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tibua, dangan kisunan ni Jan nog maꞌ nion og pomikilan nog gotowanan koyon, miktaluꞌ ion dianilan nog, “Akon, bunyagan ku amu bianan sog tubig. Tibua, ongon sala kotow posunguꞌ matong nog motas pa tokodoy dianakon nog minsan og gikot nog pongyapak non, diꞌ u tanan patut mubad dun. Ion og momunyag dianiu bianan sog Bolakat nog Mikpongon bu og gapuy. ");
INSERT INTO suc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Poꞌ og bayuꞌ nog kopongukum non pinonggiꞌ dia sog gotow nog minangoy mokpalid nog paloy non. Ain og glinggas polenan non bu toguꞌoy sog komalig. Tibua, ain og pis, doksulan non nog gapuy nog ondiꞌ ompalong somul non.” ");
INSERT INTO suc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Bu modakol pa pomali ni Jan dia sog gotowanan bu gustalan non dianilan paꞌali sog Gombaꞌis nog Guksugan. ");
INSERT INTO suc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bu pigbinaꞌan ni Jan si Herod, og kounutan dia sog bonua koyon sabap sog pigduoyduoy non og pimikitan non nog si Herodias, bu sabap dosop sog modakol pa lumual og kohinangan ni Herod nog molaton. ");
INSERT INTO suc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Dadi, og dungag nog kohinangan ni Herod koyon nog molaton, kinolobusu non si Jan. ");
INSERT INTO suc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kobon nog daꞌ pa kolobusuoy si Jan, bu kobon non pa momunyag nog modakol nog gotow, si Isus siꞌoy binunyagan non dosop. Dangan midoksuꞌ na si Isus bunyagoy, migyakin ion. Sonuk non mogyakin mibukaꞌ glangit ");
INSERT INTO suc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","bu og Bolakat nog Mikpongon nog maꞌ nog bantuk nog kolopati tinumonaꞌ dianon. Bu ngon og taluꞌ nog tidu sog glangit nog maꞌ nini, “Ika og bataꞌ u, nog kololaman ku. Kisuꞌatan u tokodoy dianika.” ");
INSERT INTO suc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Si Isus miktolipun nog ginang non momali dangan midopot na ion tolu puluꞌ ton. Bu dia sog pomikilan nog gotowanan koyon si Isus og bataꞌ ni Jusep. Si Jusep og bataꞌ ni Heli. ");
INSERT INTO suc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Heli og bataꞌ ni Matat. Si Matat og bataꞌ ni Lebi. Si Lebi og bataꞌ ni Melki. Si Melki og bataꞌ ni Hanai. Si Hanai og bataꞌ ni Jusep. ");
INSERT INTO suc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Og Jusep koni og bataꞌ ni Matatias. Si Matatias og bataꞌ ni Amos. Si Amos og bataꞌ ni Nahum. Si Nahum og bataꞌ ni Esli. Si Esli og bataꞌ ni Nagai. ");
INSERT INTO suc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagai og bataꞌ ni Maat. Si Maat og bataꞌ ni Matatias. Og Matatias koni og bataꞌ ni Semein. Si Semein og bataꞌ ni Josek. Si Josek og bataꞌ ni Joda. ");
INSERT INTO suc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Joda og bataꞌ ni Joanan. Si Joanan og bataꞌ ni Resa. Si Resa og bataꞌ ni Serubabel. Si Serubabel og bataꞌ ni Seltiel. Si Seltiel og bataꞌ ni Neri. ");
INSERT INTO suc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri og bataꞌ ni Melki. Og Melki koni og bataꞌ ni Adi. Si Adi og bataꞌ ni Kosam. Si Kosam og bataꞌ ni Elmadam. Si Elmadam og bataꞌ ni Er. ");
INSERT INTO suc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er og bataꞌ ni Josua. Si Josua og bataꞌ ni Eliesar. Si Eliesar og bataꞌ ni Jorim. Si Jorim og bataꞌ ni Matat. Og Matat koni og bataꞌ ni Lebi. ");
INSERT INTO suc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Og Lebi koni og bataꞌ ni Simiun. Si Simiun og bataꞌ ni Juda. Si Juda og bataꞌ ni Jusep. Og Jusep koni og bataꞌ ni Jonam. Si Jonam og bataꞌ ni Eliakim. ");
INSERT INTO suc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliakim og bataꞌ ni Melia. Si Melia og bataꞌ ni Mina. Si Mina og bataꞌ ni Matata. Si Matata og bataꞌ ni Natan. Si Natan og bataꞌ ni Dabid. ");
INSERT INTO suc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si Dabid og bataꞌ ni Jese. Si Jese og bataꞌ ni Obed. Si Obed og bataꞌ ni Boas. Si Boas og bataꞌ ni Salmun. Si Salmun og bataꞌ ni Nason. ");
INSERT INTO suc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Nason og bataꞌ ni Aminadab. Si Aminadab og bataꞌ ni Ram. Si Ram og bataꞌ ni Hesron. Si Hesron og bataꞌ ni Peres. Si Peres og bataꞌ ni Juda. ");
INSERT INTO suc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Og Juda koni og bataꞌ ni Jakub. Si Jakub og bataꞌ ni Isak. Si Isak og bataꞌ ni Abraham. Si Abraham og bataꞌ ni Tera. Si Tera og bataꞌ ni Nahor. ");
INSERT INTO suc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor og bataꞌ ni Serug. Si Serug og bataꞌ ni Reu. Si Reu og bataꞌ ni Peleg. Si Peleg og bataꞌ ni Eber. Si Eber og bataꞌ ni Sela. ");
INSERT INTO suc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sela og bataꞌ ni Kainan. Si Kainan og bataꞌ ni Arpaksad. Si Arpaksad og bataꞌ ni Sem. Si Sem og bataꞌ ni Nowa. Si Nowa og bataꞌ ni Lamek. ");
INSERT INTO suc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamek og bataꞌ ni Metusela. Si Metusela og bataꞌ ni Inok. Si Inok og bataꞌ ni Jared. Si Jared og bataꞌ ni Mahalel. Si Mahalel og bataꞌ ni Kainan. ");
INSERT INTO suc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Og Kainan koni og bataꞌ ni Inos. Si Inos og bataꞌ ni Set. Si Set og bataꞌ ni Adan. Bu si Adan, og gamaꞌ non og Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Dangan midoksuꞌ bunyagoy si Isus sog glawas nog tubig nog Jurdan, bu tinosopan ion nog Bolakat nog Mikpongon, pinuluꞌan ion nog Bolakat mangoy sog bonua kituꞌ nog mologon pogonongan. ");
INSERT INTO suc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Sog solod nog pat puluꞌ gobi ion dituꞌ, pingyubaꞌan ion ni Kindagow. Bu sog tang koyon daꞌ ion poglokanlokan. Bu dangan mitimpus og pat puluꞌ gobi, migutom ion. ");
INSERT INTO suc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dadi, miktaluꞌ si Kindagow dia ni Isus. Long non dun, “Bila motud nog Bataꞌ a dodaꞌ nog Mikpongon, dondag mu dow buan og batu koni nog moktimaluy pan.” ");
INSERT INTO suc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tinumabal si Isus nog, “Sinulat dia sog Kitab nog konaꞌ sagya og pan og kotubuꞌan nog gotow.” ");
INSERT INTO suc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tubus nituꞌ, inoit nosop ion ni Kindagow dituꞌ sog ditas bu pigdoliꞌan non mokpotongow dia ni Isus og glam nog pigdotuꞌan dini sog dunya ");
INSERT INTO suc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","mangka non ion toluꞌoy nog, “Binogoy na dianakon og bayaꞌ mogdatuꞌ sog glam nion bu glam nog pogongonon dion. Bu ombogoy u dia sog ain og glegan ku kituꞌ nog bogayan ku dun. Dadi, bogoyon ku dianika og bayaꞌ bu glam nog pogongonon dion ");
INSERT INTO suc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","bila tomuyon mu akon. Og glam nini mimung ika na dun.” ");
INSERT INTO suc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tibua, tinabal ion ni Isus nog, “Sinulat dia sog Kitab nog tamuy mu og Mikpongon nog ion og Diwata mu bu ion da tibua og pokokunutoy mu.” ");
INSERT INTO suc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tubus nituꞌ, inoit ion ni Kindagow dituꞌ sog Jerusalem mangka non ion popunoy dia sog kolowaan nog dibabow nog Baloy nog Poktomuyan dia sog Mikpongon mangka ion poktaluꞌ nog, “Bila motud nog Bataꞌ a dodaꞌ nog Mikpongon, okpu a! ");
INSERT INTO suc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Poꞌ sinulat dia sog Kitab nog, ‘Og Mikpongon, dondagon non og moloikatanan non mogipat dianika mahatul. ");
INSERT INTO suc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bu toyakon nilan ika bagun da minsan siꞌoy og botis mu ondiꞌ mosugat dia sog batu.’” ");
INSERT INTO suc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tibua, tinumabal si Isus nog, “Tinaluꞌ dosop dia sog Kitab nog, ‘Sumboy diꞌ mu sulayan og Mikpongon nog ion og Diwata mu.’” ");
INSERT INTO suc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Dangan mitaman si Kindagow mongyubaꞌ dia ni Isus nog saka ondiꞌ non ion dagon, ginonatan non ion solianlian. ");
INSERT INTO suc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tubus nion, mikpuliꞌ si Isus sog Galili dunut og pagas nog Bolakat nog Mikpongon. Bu og dongogan non mipulonag dia sog gliwag nog bonua koyon. ");
INSERT INTO suc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Bu mikpanad ion sog gotowanan dia sog baloyanan nog poglumpukan nog bansa Hudyu. Bu pigdongyaꞌan ion nog glam nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tubus nituꞌ, minangoy si Isus dituꞌ sog Nasaret, og bonua koyon, dion ion sinumolag. Og kiloyaman non, giap matong og Gondow nog Pogulali, mangoy ion sog baloy nog poglumpukan nog bansa Hudyu. Dadi, sog gondow koyon minangoy ion dituꞌ. Tubus nituꞌ, minindog ion dia sog sunguꞌan nilan poꞌ mogbasta ion nog Kitab. ");
INSERT INTO suc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dadi, tinulun dianon og sinulat ni Isaya kituꞌ nog polomolatas nog taluꞌ nog Mikpongon kobon nituꞌ, mangka non bokladoy, bu mitongow non og taluꞌ dion mangka non bostaoy nog, ");
INSERT INTO suc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Og Bolakat nog Mikpongon dini nakon poꞌ tinonduꞌ non akon mogustal nog Gombaꞌis nog Guksugan dia sog ain miskinan. Pipangoy non akon mokpulonag sog ain miulipon nog bianan nilan mokoluas, bu ain og diꞌ mokotongow mokotongow ilan na, bu mangoy tumabang nog ain pibian dianon og glogon. ");
INSERT INTO suc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bu mangoy mokpulonag nog tang nog kogawon nog Mikpongon dia sog pigotowan non.” ");
INSERT INTO suc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Dangan midoksuꞌ ni Isus bostaoy og sinulat koyon, inuliꞌ non dia sog polongusibaꞌ koyon mangka ion ingkud sog sunguꞌan nilan mogustal nog maꞌana nog binasta non kituꞌ. Dadi, og glam nog mata nog gotowanan koyon dion mibunag dianon. ");
INSERT INTO suc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mangka ion poktaluꞌ nog, “Og taluꞌ koni sog Kitab mituman na bianan sog kobasta u dun dianiu gondow koni.” ");
INSERT INTO suc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dadi, kisuꞌatan og glam nog gotowanan koyon dianon. Bu kisobuꞌan ilan nog kolongas nog gustalan non. Tibua, mikpoktaluꞌ ilan nog, “Konaꞌ non taꞌ ion og bataꞌ ni Jusep kituꞌ?” ");
INSERT INTO suc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Maꞌ long ni Isus dianilan, “Sog daꞌidun duaꞌduaꞌ non, toluꞌan niu akon nog maꞌ nog ponoluꞌon kituꞌ nog mokogulang nog, ‘Ika polomulung, bulung nika glawas mu.’ Bu long niu dosop dun, sumboy inangon ku dosop dini sog dili bonua u og gingyataꞌ nog midongog niu nog ininang u dituꞌ sog Kapernaum. ");
INSERT INTO suc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tibua, toluꞌon ku dianiu nog og polomolatas nog taluꞌ nog Mikpongon ondiꞌ tolimaꞌon sog dili bonua non. ");
INSERT INTO suc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Motud ion, poꞌ toluꞌon ku dianiu nog masa pa ni Iladya, og polomolatas kituꞌ nog taluꞌ nog Mikpongon, minian nog daꞌ pogdupiꞌ sog solod nog tolu ton bu gonom bulan. Dadi, ginutom og gotowanan sog gliwag nog bonua. Sog tang koyon modakol og balulibunanan sog bonua ta nog Israel nog pingunusan. ");
INSERT INTO suc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tibua, si Iladya ondaꞌ dondagoy nog Mikpongon mangoy tumabang dianilan, sugaꞌid non, dituꞌ ion dinondag mangoy tumabang sog balulibun kituꞌ nog len bansa nog dituꞌ migonong sog Sarepat dia sog sakup nog bonua nog Sidon. ");
INSERT INTO suc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bu sog masa ni Elisiu, og polomolatas nog taluꞌ nog Mikpongon, modakol dosop og gotow sog bonua ta nog Israel og tinubuꞌan nog gipul. Tibua, minsan sala kotow siꞌoy dianilan, daꞌidun og kiuliꞌan dun lual dia ni Naaman nog gotow Siria nog saka konaꞌ tanan ion og Hudyu.” ");
INSERT INTO suc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Dangan midongog nog gotowanan koyon dion sog baloy koyon nog poglumpukan og tinaluꞌ ni Isus koyon, linolingitan ilan dun. ");
INSERT INTO suc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dadi, mikpogbuat ilan mangka nilan gonggutoy si Isus posunguꞌ sog glowasan nog koliwagan bonua koyon. Poꞌ poksipian nilan bosia ion lumabuꞌ sog pampang poꞌ og koliwagan bonua koyon dia sog dibabow nog bontud. ");
INSERT INTO suc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tibua, mingoklok notibua ion ompanow sog titongaꞌ nog kodokolan nog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tubus nituꞌ, dinumiksun si Isus posunguꞌ sog Kapernaum nog sakup nog Galili. Bu sog Gondow koyon nog Pogulali, mikpanad ion sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Glam nog gotowanan nog mikodongog nog pikpanad non koyon, kisobuꞌan ilan dun poꞌ og kopokpanad non, ion og togo bayaꞌ. ");
INSERT INTO suc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sog baloy koyon nog poglumpukan, ongon og gotow dion nog tinosopan nog glatdiwata. Dangan mitongow non si Isus, ginumapis nog mosikad. Long non dun, ");
INSERT INTO suc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hoy! Ika Isus, og gotow Nasaret, olo og dunon mu dianami? Ongoyon mu notaꞌ ami loꞌatoy? Kilolaan ku ika. Ika og Mosigda kituꞌ nog miktidu sog Mikpongon!” ");
INSERT INTO suc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tibua, pimag ni Isus og glatdiwata koyon nog, “Lotaꞌ a moktaluꞌ! Awaꞌ a na dianon!” Bu mangka siꞌoy awaꞌ, binuksak non pa poguna dia sog sunguꞌan nilan og gotow koyon nog sinongonan non, tibua, daꞌ da supisupi non. ");
INSERT INTO suc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Dadi, og glam nog gotowanan koyon dion, kisobuꞌan ilan dun bu miksinaksakoy ilan nog, “Olo gidoy og piktaluꞌ non koni? Togo bayaꞌ bu togo dasig poꞌ momugow ion nog glatdiwataanan bu momilang ma dianon!” ");
INSERT INTO suc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bu og dongogan paꞌali dia ni Isus, mipulonag na sog glam nog bonua dia sog glumibut nilan koyon. ");
INSERT INTO suc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tubus nion, ginonatan ni Isus ilan sog baloy koyon nog poglumpukan mangka poglandan sog baloy ni Simun. Sog tang koyon og ponugangan ni Simun nog glibun, ompatok tokodoy og panas non. Dadi, mikitabang ilan dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Dadi, pilonian ni Isus og diꞌ koyon mokodag mangka non dondagoy mawaꞌ og panas non koyon. Bu sododuꞌun kinumodag og mogulang koyon bu pogbuat mangka non ilan poktologadoy. ");
INSERT INTO suc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Dangan poksindop na og gondow, og glam nog gotowanan kituꞌ nog ngon og pakasibataꞌanan nilan nog miglologinis og mosakit non, pingoit nilan dituꞌ ni Isus. Dadi, pingdoponan ni Isus og monala kotow dianilan bu kiuliꞌan ilan. ");
INSERT INTO suc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bu og glatdiwataanan kituꞌ nog pimugow ni Isus mikpoglosek bu mangka pongluas kobon nilan moktaluꞌ, “Ika og Bataꞌ a dodaꞌ nog Mikpongon!” Tibua, pimag non ilan bu daꞌ non ilan tugdakoy moktaluꞌ dun. Poꞌ ilan koni, kisunan nilan nog si Isus ion og Kristu. ");
INSERT INTO suc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Dangan migdaliꞌondow bonua, minangoy si Isus mogyakin sog moliliꞌ. Dadi, pinontong ion nog gotowanan. Dangan mitongow nilan ion, pigondiꞌan nilan bosia ion gumonat. ");
INSERT INTO suc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tibua, miktaluꞌ si Isus dianilan nog, “Saꞌan ini pipangoy u dini poꞌ ustalon ku og Gombaꞌis nog Guksugan koni paꞌali sog pigdotuꞌan nog Mikpongon. Saꞌan naꞌ niu akon pogondiꞌan mogustal dun sog len bonuaan.” ");
INSERT INTO suc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Dadi, gininang ni Isus moguliugan sog bonua nog Hudyu mogustal dia sog baloyanan nog poglumpukan nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ongon gondow non, solian ni Isus mogindogindog sog goksid nog danow nog Genesaret, modakol og gotowanan nog mikpogagow mokpolani dianon mangoy monginongog nog taluꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ngon duaꞌ buk bolangoy nog mitongow non nog dia sog posaꞌan nabok nog danow koyon nog ginonatan nog gapuꞌanan non poꞌ mingugas ilan nog pokot nilan. ");
INSERT INTO suc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dadi, sinumakoy si Isus sog solabuk bolangoy koyon nog og gapuꞌ non si Simun, mangka non dondagoy sumindoꞌ dia ni Simun mangka ion ingkud dia sog bolangoy koyon momali dia sog gotowanan koyon dion. ");
INSERT INTO suc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Dangan midoksuꞌ si Isus momali, dinondag non si Simun mokpodibabaꞌ bu mangka nilan lobuꞌoy og pokot nilan. ");
INSERT INTO suc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Dadi, miktaluꞌ si Simun nog, “Polopanad, sogobi gobi ami na ini momokot, tibua, ondaꞌ ami pokalap. Bigyaꞌ non, og dondagan mu ma, inangon ku.” ");
INSERT INTO suc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dadi, linabuꞌ ni loꞌ Simun og pokot nilan koyon. Bu dangan binalut nilan, landuꞌ kodakol og taban non nog sodaꞌ nog boyaꞌan moksipi tanan ombogyang og pokot nilan koyon. ");
INSERT INTO suc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dadi, kinopayan nilan og dumaanan nilan sog solabuk bolangoy kituꞌ mangoy tumabang dianilan. Bu mikpolani ilan doma mangka nilan ponuꞌoy og duaꞌ buk bolangoy koyon nog sodaꞌ nog boyaꞌan agonagon ilan notanan molonod. ");
INSERT INTO suc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Dangan mitongow na ni Simun Piter og gininang ni Isus koyon, miningluꞌud ion dia sog sunguꞌan ni Isus mangka poktaluꞌ, “Kounutan, pokpolayuꞌ a dianakon poꞌ akon og gotow nog bolodusaon!” ");
INSERT INTO suc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Poꞌ si Simun bu og dumaanan non dion sog bolangoy koyon, kisobuꞌan ilan tokodoy nog landuꞌ kodakol og sodaꞌ nog mialap nilan. ");
INSERT INTO suc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bu og dumaanan non siꞌoy nog si loꞌ Jems bu si Jan nog gombataꞌ ni Sebedi, kisobuꞌan ilan dosop tokodoy dun. Dadi, si Isus miktaluꞌ dia ni Simun. Long non dun, “Naꞌ a mondok poꞌ moktolipun numun kituꞌ konaꞌ na og sodaꞌ og pogolapon mu, sugaꞌid non, og gotow na.” ");
INSERT INTO suc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tubus nion mikpongdongguꞌ ilan mangka nilan pongdekoy og bolangoyanan nilan koyon, bu gonatoy og glam non mangka ilan pogunut dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Solian ni Isus dia sog solabuk bonua, ongon og gotow dion nog milokop nog gipul og glawas non. Dangan mitongow non si Isus, mikpolani ion mangka ion ingluꞌud bu pokilolat dianon kobon non moktaluꞌ nog, “Polopanad, somoꞌ moleg a da, ompokodag mu akon.” ");
INSERT INTO suc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dadi, dinoponan ion ni Isus mangka poktaluꞌ nog, “Moleg u da, le. Kuliꞌan ka na!” Bu sododuꞌun og gotow koyon kiuliꞌan dodaꞌ. ");
INSERT INTO suc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Bu mangka ni Isus ion dondagoy nog, “Naꞌ mu ini posunoy og minsan sima. Sugaꞌid non, angoy a dituꞌ sog bolian bu potongow mu dianon og glawas mu mangka a pomalas sog Mikpongon nog maꞌ nog dinondag ni Muses kituꞌ kobon nituꞌ, bagun kotoksiꞌan nog gotowanan nog kiuliꞌan ka nododaꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tibua, og dongogan koyon paꞌali dia ni Isus migdungag tanan ompulonag nog boyaꞌan modakol og gotowanan mikpogangoy dituꞌ non mokinongog nog pomali non bu bagun kuliꞌan og mokosakitanan nilan. ");
INSERT INTO suc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tibua, si Isus aluꞌaluꞌ mangoy ion dia sog bonua kituꞌ nog moliliꞌliliꞌ mogyakin sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ongon gondow non, sonuk ni Isus mokpanad sog baloy, ongon og parasiuanan bu og polopanadanan nog botad nog bansa Hudyu nog mikpongingkud dion. Dituꞌ ilan miktidu sog bonuaanan nog sakup nog Galili, bu Judia, bu og koliwagan bonua nog Jerusalem. Minangoy ilan monginongog dia ni Isus. Poꞌ si Isus, dia non og pagas nog Bolakat nog Mikpongon mokokuliꞌ nog glam nog gininisan nog mosakit. ");
INSERT INTO suc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dadi, ongon og gotowanan minatong nog inoyungan nilan og daday sog pigbolilidan non. Bu mogapas ilan bosia sumolod sog baloy koyon, poꞌ botangon nilan sog sunguꞌan ni Isus og daday koyon. ");
INSERT INTO suc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tibua, daꞌ ilan pokosolod kobal nog gotowanan koyon dion. Dadi, mimonek ilan sog gatop mangka nilan lodutoy mangka nilan tontunoy og daday koyon dunut og pigbolilidan non koyon dia sog sunguꞌan ni Isus sog titongaꞌ nog piglumpukan nog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dangan mitongow ni Isus og kopongandol nilan, tinoluꞌan non og diꞌ koyon mokodag, “Aki, og dusaanan mu inompunan na.” ");
INSERT INTO suc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dangan midongog nog parasiuanan bu polopanadanan nog botad nog bansa Hudyu og tinaluꞌ ni Isus koyon, migdialominawa ilan nog, “Sima gidoy og gotow koni nog moglakaꞌlakaꞌ monaluꞌ dia sog Mikpongon? Poꞌ ondaꞌidun ma lual og mokampun nog dusa lual da og Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tibua, kisunan ni Isus og pomikilan nog gotowanan koyon. Dadi, miktaluꞌ ion dianilan nog, “Iduma pogdialominowaan niu ma akon nog maꞌ nion? ");
INSERT INTO suc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ain gidoy og molomu toluꞌon, ‘Og dusaanan mu inompunan na,’ otawaka moktaluꞌ nog, ‘Pogbuat a mangka a panow?’ ");
INSERT INTO suc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tibua, bagun niu kosunan, potongowon ku dianiu nog og Binataꞌ sog Kilawan togo bayaꞌ mongampun nog dusa nog gotowanan dini sog glupaꞌan.” Mangka non toluꞌoy og daday koyon nog, “Aki, toluꞌon ku dianika, pogbuat a na, imud mu og pigbolilidan mu koyon bu pitang mu muliꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dadi, sododuꞌun migbuat ion sog sunguꞌan nog glam nog gotowanan koyon dion, mangka non imudoy og pigbolilidan non koyon mangka uliꞌ kobon non moksanglit sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dadi, glam nilan koyon dion kisobuꞌan tokodoy dun bu miksanglit ilan dia sog Mikpongon dunut og gondok nilan kobon nilan moktaluꞌ nog, “Kosobuꞌsobuꞌ tokodoy og pitongow nog Mikpongon dianita gondow koni!” ");
INSERT INTO suc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tubus nituꞌ, dangan linumuas si Isus, mitongow non og polongabat nog buis nog ngalan non si Lebi pogingkud sog baloybaloy nog pokpongobatan non nog buis. Tinoluꞌan ion ni Isus nog, “Pogunut a le dianakon.” ");
INSERT INTO suc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dadi, migbuat ion mogdayun mangka non gonatoy og glam nog ginang non koyon bu pogunut dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dadi, sabap dion miglokologyaꞌan si Lebi dia sog baloy non bu modakol og polongabatanan nog buis bu duma gotowanan minadap ilan kuman dianilan. ");
INSERT INTO suc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tibua, og parasiuanan bu polopanadanan nog botad nilan, mitongow nilan si Isus, migadap ilan kuman nog gotowanan koyon. Dadi, sinilaꞌ nilan og sulangguꞌanan ni Isus nog, long nilan dun, “Iduma mampuꞌ amu ma kuman bu minum dia sog polongabatanan nog buis koyon bu sog bolodusaon?” ");
INSERT INTO suc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Dadi, tinabal ilan ni Isus. Long non dun, “Og gotow nog mokodag daꞌidun na og balan non nog polomulung. Tibua, og gotow nog diꞌ mokodag, ngon og kobalan non dun. ");
INSERT INTO suc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Dadi, konaꞌ og gangoy u dini mangoy mongonggat sog ain mokpikil nog ilan midulus na. Sugaꞌid non, inangoy u onggatoy ain og gotow nog bolodusaon nog moglilaꞌ ilan na nog dusa nilan.” ");
INSERT INTO suc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dadi, ongon gotowanan nog miksak dia ni Isus nog, “Og sulangguꞌanan ni Jan nog Polomunyag mokpokpuasa bu mokpogyakin bu maꞌ nituꞌ dosop og sulangguꞌanan nog parasiuanan koyon. Iduma og sulangguꞌanan mu koyon, ginangon nilan ma tibua og kuman bu minum?” ");
INSERT INTO suc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Dadi, tinumabal si Isus bianan sog pononggiꞌan nog, “Mogusoy taꞌ gidoy nog og pongantim mokpuasa nog kobon nog dion pa nilan og koingon koyon? Ondiꞌ nododaꞌ. ");
INSERT INTO suc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tibua, ongon da gondow non nog bigdason dianilan og koingon koyon, mangka ilan pa pokpuasa.” ");
INSERT INTO suc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tubus nion, inuksugan non nosop ilan nog len nog pononggiꞌan. Long non dun, “Daꞌidun og gotow nog bila monilob, gobason non og bogu logdoy non mangka non tiloboy nog danul. Poꞌ bila maꞌ nituꞌ, pigloꞌatan non tibua og bogu logdoy non koyon. Bu og bogu gabas koyon ondiꞌ dumaꞌit tilobon dia sog danul. ");
INSERT INTO suc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Bu domikian dosop nog daꞌidun og gotow tumaguꞌ nog bogu galak dia sog dan toguꞌan nog diꞌ na lumagyat. Poꞌ bila maꞌ nituꞌ, bila tumulin og bogu galak koyon, ombogdak og toguꞌan koyon dun. Dadi, doksuꞌ non moglaꞌat og tinoguꞌan non koyon bu mogulaꞌ og galak koyon. ");
INSERT INTO suc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Sugaꞌid non, og bogu galak dia nododaꞌ toguꞌoy sog bogu toguꞌan nog lumagyat. ");
INSERT INTO suc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Bu og gotow nog milayam na moginum nog galak nog migbatiꞌ ompok na minum nog bogu galak. Poꞌ long non dun, ombaꞌis og galak nog migbatiꞌ na.” ");
INSERT INTO suc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ongon gondow non, og Gondow nog Pogulali, minian si Isus bu sulangguꞌanan non sog polayan. Og sulangguꞌanan non koyon, mingotuꞌ ilan dun bu pomuliasoy mangka nilan kanoy. ");
INSERT INTO suc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dadi, ngon parasiuanan miksak dianilan nog, “Iduma moginang amu ma nog konaꞌ botad sog Gondow nog Pogulali?” ");
INSERT INTO suc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Dadi, tinabal ilan ni Isus, “Daꞌ niu taꞌ buan kobasta og sinulat kituꞌ sog Kitab paꞌali sog gininang ni Dabid kituꞌ nog dangan kigutoman ilan nog dumaanan non? ");
INSERT INTO suc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Sinumolod ion sog dialom nog Baloy nog Poktomuyan dia sog Mikpongon mangka non olapoy og pan kituꞌ nog inuakil na dia sog Mikpongon mangka non kanoy bu mangka non dosop pomogoyoy dun og dumaanan non. Saka daꞌidun bosia og mokokan dun lual da og boliananan poꞌ maꞌ nituꞌ og bonduan dia sog Botad. ");
INSERT INTO suc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Og Binataꞌ sog Kilawan, ion og Pogbayaꞌ sog Gondow nog Pogulali.” ");
INSERT INTO suc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Dangan minatong nosop og Gondow nog Pogulali, sinumolod bu mikpanad nosop si Isus sog baloy nog poglumpukan nog bansa Hudyu. Sog tang koyon ngon og glaki dion minguyomong og komot non nog glintu. ");
INSERT INTO suc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Og duma polopanadanan nog botad nog bansa Hudyu bu og duma parasiuanan koyon, piktimaꞌanan nilan si Isus bog uliꞌan non taꞌ og komot nog glaki koyon nog saka og Gondow nog Pogulali. Poꞌ bila uliꞌan non dodaꞌ, kituꞌ og gimungon nilan nog sumbungan dianon. ");
INSERT INTO suc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tibua, kisunan ni Isus og pomikilan nilan. Dadi, tinoluꞌan non og gotow koyon nog minguyomong komot non nog, “Le, pogbuat a, bu indog a sog sunguꞌan nog gotowanan koni.” Dadi, minindog gotow koyon dion sog sunguꞌan nilan. ");
INSERT INTO suc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tubus nion, miktaluꞌ si Isus sog gotowanan koyon nog, “Sakan ku poloꞌma amu. Olo gidoy og tinugdak dia sog botad nog ginangon ta sog Gondow nog Pogulali? Moginang taꞌ nog molaton otawaka og molongas, tumabang taꞌ otawaka lumaꞌat taꞌ?” ");
INSERT INTO suc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Liniboyan non nog mata og glam nog gotowanan koyon sog glumibut non mangka ion poktaluꞌ sog minguyomong koyon og komot non nog, “Ogot mu og komot mu koyon.” Dadi, inunut non og tinaluꞌ ni Isus koyon dianon bu mioksud na maꞌ nog dan og komot non koyon. ");
INSERT INTO suc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tibua, linolingitan ilan tokodoy dun dianon mangka ilan pogupakat bog olo og gondunon nilan dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ongon gondow non, tinumukad si Isus dituꞌ sog bontud bu miglokondawan ion mogyakin dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dangan miksisolom bonua, pilumpuk non og glaꞌayatanan non mangka non pomiliꞌoy og sopuluꞌ bu duaꞌ kotow dianilan nog iningolanan non dosop nog sosuguꞌonanan non. ");
INSERT INTO suc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Og pimiliꞌ non koyon, ion non ion si Simun (nog iningolanan non si Piter) bu og putupusod non nog si Andriu. Tubus nituꞌ si Jems, si Jan, si Pilip, si Bartolomi, ");
INSERT INTO suc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Matiu, si Tomas, si Jems dosop og bataꞌ ni Alpius, bu si Simun og omboluꞌ kituꞌ tumindog nog salu bansa non, ");
INSERT INTO suc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas og bataꞌ ni Jems, bu si Judas Iskariot, og mongulaꞌat kituꞌ dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tubus nion, migdunut ilan dumiksun dituꞌ sog dotagan. Bu dituꞌ modakol tokodoy og sulangguꞌanan non, bu duma gotowanan nog mikpoktidu ilan dia sog ainain nog bonua nog Judia, sog koliwagan bonua nog Jerusalem, bu tidu dosop dituꞌ sog goksid dagat nog koliwagan bonua nog Tair bu Sidon. ");
INSERT INTO suc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Miglumpuk ilan dion mangoy monginongog nog pomali ni Isus bu bagun non kuliꞌan og mokosakitanan nilan. Bu ain og gotowanan kituꞌ nog pisinsa nog glatdiwataanan, kiuliꞌan ilan dosop. ");
INSERT INTO suc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bu og glam nog gotowanan dion migapas tumuyok dianon poꞌ og pagas nog miktidu koyon dianon ion non da og mikokuliꞌ koyon dia sog glam nilan. ");
INSERT INTO suc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tubus nituꞌ, pigbontayan ni Isus og sulangguꞌanan non koyon mangka poktaluꞌ dianilan, “Pipia amu, amu og miskinan poꞌ mikampuꞌ amu na sog pigdotuꞌan nog Mikpongon! ");
INSERT INTO suc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Pipia amu, amu og kigutoman solian numun koni poꞌ ongon gondow non nog pobosugon amu nog Mikpongon! Pipia amu, amu og mikpoksogow solian numun koni poꞌ ongon da og gondow non nog mogloliag amu! ");
INSERT INTO suc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Pipia amu bila pokongitan amu, bu pogbongkis amu, bu tompolaꞌon amu, bu toluꞌan amu nog molaton amu nog gotow, sabap sog kopogunut niu dia sog Binataꞌ sog Kilawan! ");
INSERT INTO suc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Pogloliag amu bu pogloksuloksu amu nog daꞌdaꞌan niu bila kobianan niu og maꞌ nion koyon poꞌ mosolag og sugda nog sinimpan dianiu dituꞌ sog glangit. Poꞌ maꞌ nituꞌ dosop og piginang nog mokogulanganan nilan kituꞌ dia sog polomolatasanan nog taluꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Tibua, kosusasusa amu og pongdoyahan poꞌ mialap niu na og sugda dianiu sog solian niu pa dini sog dunya! ");
INSERT INTO suc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Kosusasusa amu dosop ain mibosug solian numun koni poꞌ matong da og gondow nog mogutom amu! Bu kosusasusa amu ain og mikpogloliag solian numun koni poꞌ ongon da og gondow nog mosusa amu bu moksogow amu! ");
INSERT INTO suc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kosusasusa amu bila pogdongyaꞌan amu nog glam nog gotow poꞌ maꞌ nituꞌ og piginang nog mokogulanganan nilan dia sog polomolatasanan kituꞌ nog diꞌ motud. ");
INSERT INTO suc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Tibua, toluꞌon ku dianiu sosuku og mikinongog dianakon, kololat amu sog ain minanta dianiu. Ain og mangit kituꞌ dianiu, inangoy niu ilan nog molongas. ");
INSERT INTO suc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ain monuyud dianiu popia niu. Bu ain og sumolap dianiu pogyokinoy niu. ");
INSERT INTO suc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bila dopiꞌon og sobolaꞌ muluꞌ niu, tan niu og sobolaꞌ muluꞌ niu dianon. Bila olapon dianiu og sulagbon niu, naꞌ niu ion pogondiꞌan malap minsan siꞌoy og glogdoy niu. ");
INSERT INTO suc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bogoyoy niu ain mongoni dianiu. Bu bila olapon nog gotow og balan niu, naꞌ niu na owiꞌon. ");
INSERT INTO suc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Inang niu dia sog pakasi niu ain og kolegan niu kituꞌ nog inangon non dianiu. ");
INSERT INTO suc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Bila mololat amu tibua sog ain og milolat kituꞌ dianiu, naꞌ amu mogdodama nog popiaon amu nog Mikpongon. Poꞌ minsan siꞌoy og bolodusaon, mololat ilan dosop dia sog ain mololat kituꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tubus nituꞌ, bila mokpolongas amu tibua sog ain molongas kituꞌ dianiu, naꞌ amu mogdodama nog popiaon amu nog Mikpongon. Poꞌ minsan og bolodusaon moginang ilan dosop nog maꞌ nion koyon. ");
INSERT INTO suc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bu bila og poboloson niu ain tibua og mokobayad kituꞌ dianiu, naꞌ amu mogdodama nog popiaon amu nog Mikpongon. Poꞌ minsan og bolodusaon mokpobolos ilan dosop sog maꞌ nilan, sog ain kituꞌ og motoktub og kopogbayad non dianilan. ");
INSERT INTO suc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tibua amu, kololat amu nog ain minanta dianiu bu inangoy niu ilan nog molongas mangka niu ilan pobolosoy nog diꞌ amu mogdodama nog boyadan nilan amu nog minsan olo. Bila maꞌ nituꞌ og ginangon niu, motas nog sugda dun dianiu bu mimung amu nog gombataꞌanan nog Mikpongon nog ion ondiꞌ kolobian. Poꞌ molongas ion dia sog ain mokolaton kituꞌ bu dia sog ain diꞌ kituꞌ moto mokposolamat. ");
INSERT INTO suc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sumboy molilolatoy amu dosop mamaꞌ nog Gamaꞌ niu sog glangit nog og Mikpongon nog ion molilolatoy. ");
INSERT INTO suc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Bu bila diꞌ amu mongukum nog pakasiotow niu, diꞌ amu dosop ukumon nog Mikpongon. Bu bila diꞌ amu momolihalaꞌ nog pakasiotow niu, diꞌ amu dosop poliholaꞌon nog Mikpongon. Bu bila ompunan niu og pakasiotow niu, ompunan amu dosop nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bila mogbogoy amu, bogayan amu dosop nog Mikpongon. Bu og bogoy non dianiu modakol tokodoy poꞌ kongkugon non pa, dosokon non pa, bu dungagoy boyaꞌan nog moglipuas sog toguꞌan niu dun. Poꞌ og galan nog gomiton niu dia sog pakasi niu, maꞌ nituꞌ dosop og gomiton nog Mikpongon nog galan non dianiu.” ");
INSERT INTO suc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Bu inuksug non dosop dianilan og gibolatan nog maꞌ nini, “Mogusoy taꞌ buan og gotow nog buta, mogagak sog pakasi non buta? Ondiꞌ le! Poꞌ og duaꞌ ilan koyon, molabuꞌ ilan sog gluang. ");
INSERT INTO suc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Og pikponadan ondiꞌ nododaꞌ motas dia sog mikpanad koyon dianon. Sugaꞌid non, bila mitoktub na og kopoganad non og pikponadan non koyon, og kotoan non mimung dosop mamaꞌ nog polopanad kituꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Iduma sokaliꞌ motongow niu og puling ma nog duma niu nog gahatgahat tanan kotongow, saka potiangon niu ma og puling nog migbolabag dia sog dili mata niu nog maꞌ nog glolosan kosolag? ");
INSERT INTO suc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Olo ma mogandun kotaluꞌ niu dia sog duma niu nog, ‘Takun dow, owaꞌon ta og puling mu,’ saka daꞌ niu tanan kotongow og dili puling nog mibolabag sog mata niu? Mokpopotongow amu dodaꞌ tibua! Awaꞌ niu poguna og puling nog migbolabag dia sog dili mata niu bagun niu motongow mahatul bu mawaꞌ niu og bataꞌbataꞌ puling sog mata nog pakasi niu.” ");
INSERT INTO suc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Bu maꞌ long sop ni Isus dun, “Og kayu nog molongas ondiꞌ mogbunga nog molaton, otawaka og kayu nog molaton ondiꞌ mogbunga nog molongas. ");
INSERT INTO suc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Og ginis nog kayu kilolaan bianan sog bunga non. Poꞌ og bunga nog paras ondiꞌ mupuꞌ dia sog totulug, bu og bunga nog igera ondiꞌ mupuꞌ dia sog bonganga. ");
INSERT INTO suc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Domikian dosop dia sog gotow. Poꞌ bila molongas og mitaguꞌ dia sog pomikilan non, molongas dosop og polomotadon non bu ponoluꞌon non. Tibua, bila molaton og mitaguꞌ dia sog pomikilan non, molaton dosop og polomotadon non bu ponoluꞌon non. Poꞌ og taluꞌ nog gotow nog lumuas sog babaꞌ non, dia miktidu sog dialom pikilan non.” ");
INSERT INTO suc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Bu maꞌ long sop ni Isus dun, “Iduma moksabi amu ma dianakon nog Kounutan, saka diꞌ niu tanan inangon ain og dondagan ku dianiu. ");
INSERT INTO suc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Simasima og mangoy mokinongog dianakon mangka non unutoy ain poktoluꞌon ku, suksugan ku dianiu bog olo og kimaꞌmaꞌan non. ");
INSERT INTO suc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mamaꞌ ion nog gotow kituꞌ nog mikpasok nog baloy non. Kinukutan non nog modalom mangka non pingkudoy og gugdokanan non dia sog dolonitan. Dangan binianan nog baꞌ nog modalom, og baloy non koyon, ondaꞌ kokunduꞌ poꞌ ompagon og kopasok non dun. ");
INSERT INTO suc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tibua, og gotow kituꞌ nog pikinongogan non og taluꞌ u saka daꞌ non unutoy, mamaꞌ ion nog gotow kituꞌ nog migimung nog baloy non nog sagya non tibua inuntul dia sog dibabow nog glupaꞌ. Dadi, dangan linudusan nog baꞌ, mibuksak og baloy non koyon boyaꞌan nog miloglag mahatul.” ");
INSERT INTO suc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Dangan midoksuꞌ ni Isus toluꞌoy og glam non koyon dia sog gotowanan, minangoy ion sog Kapernaum. ");
INSERT INTO suc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Bu sog koliwagan bonua koyon, ngon sala kotow dion og kounutan nog sundalu nog Roma. Ongon sala kotow dodondagon non nog kisuꞌatan ion tokodoy dun nog diꞌ mokodag nog moglamlam na matoy. ");
INSERT INTO suc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Midongog nog kounutan nog sundalu koyon paꞌali dia sog kohinangan ni Isus. Dadi, ongon og kobogolalan nog Hudyuanan pigobok non dituꞌ ni Isus poꞌ ongoyon non pa pokodagoy og dodondagon non koyon. ");
INSERT INTO suc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dangan minatong og gobokanan koyon dituꞌ ni Isus, mikilolat ilan tokodoy dianon nog, “Polopanad, og gotow kituꞌ ombaꞌis tokodoy tobangan. ");
INSERT INTO suc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Poꞌ milolat ion dia sog bansa ta koni. Ion tanan og mikpimung nog baloy nog poglumpukan nami nog bansa Hudyu.” ");
INSERT INTO suc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dadi, si Isus migunut dianilan. Dangan daliꞌ ilan na datong dia sog baloy nog kounutan nog sundaluanan koyon, og kounutan nog sundaluanan kituꞌ sinuguꞌ non og glokoleanan non lumumpak dia ni Isus mangka poktaluꞌ dianon nog, “Polopanad, long nog glokole nami kituꞌ nog naꞌ a na dow mogdayun poꞌ diꞌ dow ion patut mokpodangan dianika dia sog baloy non ");
INSERT INTO suc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","bu diꞌ dow ion ompatut nog minsan lumumpak dianika. Sugaꞌid non, toluꞌon mu dow tibua nog kumodag na og dodondagon non kituꞌ poꞌ kumodag na ion dun. ");
INSERT INTO suc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Poꞌ ion siꞌoy dow ngon dosop og kounutan nog mogbayaꞌ dianon. Bu ongon dosop dow og sundaluanan nog bila dondagon non ompanow mokokunut da dianon. Bu bila sop dondagon non mokpolani dianon mokokunut dosop. Bu bila dondagon non og sosuguꞌon non moginang nog ain kolegan non, inangon non dosop.” ");
INSERT INTO suc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Dangan midongog ni Isus og tinaluꞌ nog linumumpak koyon dianon, kisobuꞌan ion dun nog boyaꞌan sinunguꞌ non og gotowanan nog migunutunut dianon bu poktaluꞌ nog, “Totu da, daꞌ u pa sibon pokolumpak nog gotow nog maꞌ nini kopagon og kopongandol non, minsan siꞌoy sog bansa Israel.” ");
INSERT INTO suc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dadi, mikpuliꞌ na og linumumpak koyon dianon, dituꞌ sog baloy nog kounutan nog sundaluanan koyon bu kidotongan nilan og dodondagon non koyon mikodag na. ");
INSERT INTO suc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Daꞌ ion kobon, si Isus minangoy dituꞌ sog koliwagan bonua nog Nain dunut og sulangguꞌanan non bu modakol dosop og gotowanan nog migunut dianon. ");
INSERT INTO suc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Dangan daliꞌ ilan na datong sog koliwagan bonua koyon, milumpak nilan og gluyud nog gotowanan mian tidu sog bongawan nog koliwagan bonua koyon mangoy lumobut nog minatoy. Og minatoy koyon og bataꞌ nog balulibun nog boktung. Modakol og gotowanan dion migunut dianon. ");
INSERT INTO suc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dangan mitongow ni Isus og balulibun koyon nog linumangos, milolat ion dun mangka poktaluꞌ dianon, “Naꞌ a na moksogow.” ");
INSERT INTO suc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tubus nion, mikpolani si Isus mangka non doponoy og pigbolilidan nog bangkoy koyon bu migindog og gotowanan koyon nog mikpisan dun mangka toluꞌoy ni Isus nog, “Aki, toluꞌon ku dianika, pogbuat a.” ");
INSERT INTO suc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dadi, miningkud doma dodaꞌ og minatoy koyon mangka poktaluꞌ bu uokiloy ni Isus dia sog ginaꞌ non. ");
INSERT INTO suc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dadi, og glam nog gotowanan koyon dion, kisobuꞌan ilan bu kiondokan ilan. Bu miksanglit ilan sog Mikpongon mangka ilan poksitaluꞌ, “Og polomolatas nog molinggas minangoy na dini nita!” Bu miktaluꞌ ilan dosop, “Og Mikpongon minangoy na dini nita tumabang sog pigotowan non!” ");
INSERT INTO suc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bu og dongogan koni nog paꞌali dia ni Isus mipulonag na dia sog gliwag nog bonua nog Judia bu sog bonuaanan dion sog glumibut koyon. ");
INSERT INTO suc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Dangan tinaluꞌ nog sulangguꞌanan ni Jan dianon paꞌali sog glam nog gininang ni Isus koyon, sinabi non og duaꞌ kotow dianilan ");
INSERT INTO suc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","mangka non ilan dondagoy mangoy dituꞌ ni Isus moksak nog, “Ika notaꞌ og pokpodotongon kituꞌ nog mangoy dini nog moktidu sog Mikpongon, otawaka mogbagad ami potaꞌ nog len?” ");
INSERT INTO suc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dadi, dangan minatong ilan dituꞌ ni Isus miksak ilan. Long nilan dun, “Si Jan nog Polomunyag, dinondag non ami mangoy moksak dianika bog ika taꞌ dow og pokpodotongon kituꞌ nog popongoyon dini otawaka mogdodama ami potaꞌ nog len?” ");
INSERT INTO suc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sog tang koyon sonuk ni Isus monguliꞌ nog modakol nog mokosakitanan nog gotowanan, bu ain diꞌ mokokodag, asta dosop og ain pingtosopan kituꞌ nog glatdiwataanan. Bu ain og butaanan kituꞌ kiuliꞌan non dosop. ");
INSERT INTO suc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dadi, tinabal ilan ni Isus nog, “Pokpuliꞌ amu dituꞌ ni Jan mangka niu pogobitoy bog olo og mitongow niu bu midongog niu. Taluꞌ niu dianon nog og butaanan mikotongow na. Og dadayanan mikopanow na. Bu ain og gipulon kiuliꞌan na. Bu og bongolanan mikodongog na. Bu og minatoy mitubuꞌ puliꞌ. Bu ain og miskinan kisuksugan na nog Gombaꞌis nog Guksugan. ");
INSERT INTO suc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ain daꞌ kituꞌ pogduaꞌduaꞌ nog pikilan non dianakon, popiaon na.” ");
INSERT INTO suc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Dangan mikogonat na og dinondag ni Jan koyon, miktolipun si Isus mogustal sog gotowanan paꞌali dia ni Jan. Long non dun, “Dangan minangoy amu dituꞌ ni Jan sog bonua kituꞌ nog mologon pogonongan, olo ma og pigdodomaan niu nog motongow niu dituꞌ? Migdodama amu taꞌ nog si Jan og gotow kituꞌ nog moguyaꞌ og pomikilan non mamaꞌ nog dawon nog timbolow nog diadia kopalid bila oyupan nog galuꞌ? Ondiꞌ le! ");
INSERT INTO suc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bila maꞌ nituꞌ ondiꞌ ma, olo ma og pigdodomaan niu sog kangoy niu kituꞌ dituꞌ? Og gotow taꞌ kituꞌ nog ombaꞌis og ponopoton non? Konaꞌ le! Poꞌ og gotowanan koyon nog minapot nog mokologan bu molongas kibotangan non, dia migonong sog baloy nog datuꞌ. ");
INSERT INTO suc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Olo dodaꞌ buan og inangoy niu tontongoy dituꞌ? Og polomolatas taꞌ nog taluꞌ nog Mikpongon? Oꞌo, motud ion. Poꞌ toluꞌon ku dianiu, og mitongow niu kituꞌ dituꞌ konaꞌ tibua og polomolatas nog taluꞌ nog Mikpongon, sugaꞌid non, labi pa ion dituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Paꞌali dia ni Jan, ion og pigolong kituꞌ nog sinulat dia sog Kitab nog, ‘Ongon og sosuguꞌon ku nog punaon ku dianika moksimpan nog bianan mu.’” ");
INSERT INTO suc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Bu maꞌ long sop ni Isus dun, “Toluꞌon ku dianiu, og glam nog binataꞌ nog gotow sog dunya koni, daꞌidun og motas pa dia ni Jan. Tibua, og gotow kituꞌ nog ombabaꞌ sog glam non dia sog pigdotuꞌan nog Mikpongon, motas pa dia ni Jan.” ");
INSERT INTO suc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Dangan midongog nog glam nog gotowanan asta og polongabatanan nog buis og piktaluꞌ ni Isus koyon, mikopoktaluꞌ ilan nog motud dodaꞌ og gininang nog Mikpongon poꞌ binunyagan ilan buan ni Jan. ");
INSERT INTO suc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tibua, og parasiuanan bu og polopanadanan nog botad nog bansa Hudyu, daꞌ ilan pokokunut nog glegan nog Mikpongon dianilan. Dadi, daꞌ ilan pokpobunyag dia ni Jan. ");
INSERT INTO suc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Bu maꞌ long sop ni Isus dun, “Ain gidoy kopononggiꞌ og gotowanan numun koni? Olo gidoy kimaꞌmaꞌan nilan? ");
INSERT INTO suc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mamaꞌ ilan nog gombataꞌanan kituꞌ nog miglumpuklumpuk dia sog tobuꞌan nog moktotowagoy ilan nog, ‘Miglami ami bosia saka ompok amu mongigal. Linumangos ami saka ondaꞌ amu ampuꞌ moksogow.’ ");
INSERT INTO suc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Dangan minangoy dini si Jan nog Polomunyag nog og piginang non mokpuasa bu daꞌ poginum nog gombisa, tinoluꞌan niu ion nog tinosopan nog glatdiwata! ");
INSERT INTO suc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Bu dangan minangoy dini og Binataꞌ sog Kilawan bu og piginang non kuman bu moginum, tinoluꞌan niu dosop ion nog gibogon bu pololangu, bu og glokoleanan non og polongabatanan nog buis bu og bolodusaon. ");
INSERT INTO suc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tibua, kotoksiꞌan og kotoan nog miktidu sog Mikpongon og motud sog ain mikokunut dun.” ");
INSERT INTO suc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ongon gondow non, inonggat si Isus nog sala kotow parasiu mangoy kuman dituꞌ non. Dadi, migunut si Isus dituꞌ mangka ilan pogadap kuman. ");
INSERT INTO suc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sog bonua koyon ngon og glibun dion nog bolodusaon tokodoy. Dangan kisunan non nog si Isus dituꞌ sog baloy nog parasiu koyon, minangoy ion dituꞌ bu mikpitang ion nog bataꞌbataꞌ gunsuꞌ nog miponuꞌ nog pogomut. ");
INSERT INTO suc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bu minangoy ion mindog sog molani nog botis ni Isus, kobon non moksogow nog boyaꞌan mibasaꞌ og botis ni Isus nog gluaꞌ non. Tubus nion, pinunasan non nog buk non og botis ni Isus koyon mangka non pongolokoy bu mangka non ududoy nog pogomut non koyon. ");
INSERT INTO suc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Dangan mitongow nog parasiu koyon nog migonggat kituꞌ dianon og piginang nog glibun koyon dia ni Isus, migdialominawa ion nog, “Somoꞌ motud dodaꞌ og gotow koni nog ion og polomolatas nog taluꞌ nog Mikpongon, kosunan non bosia bog sima og glibun koni bu olo og tantu polomotadon non.” ");
INSERT INTO suc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tibua, kisunan ni Isus bog olo sog dialom pikilan nog parasiu koyon. Dadi, miktaluꞌ ion dianon nog, “Simun, ongon og toluꞌon ku dianika.” Tinumabal si Simun, “Olo nion, Polopanad?” ");
INSERT INTO suc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Long ni Isus dun, “Ongon og duaꞌ kotow nog mikutang nog sin dia sog sala kotow doyahan. Og sala kotow koyon, lima gatus dinari ");
INSERT INTO suc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tibua, daꞌidun og mikobayad dianilan. Dadi, piondaꞌ na nog doyahan koyon og gutang nog duaꞌ kotow kituꞌ. Dadi, sima gidoy sog duaꞌ ilan koyon og mololat tokodoy dia sog doyahan koyon?” ");
INSERT INTO suc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tinumabal si Simun, “Intoman ku dun, ain bayuꞌ og mikutang kituꞌ nog modakol poꞌ mosolag og gampun dianon.” Tinabal ion ni Isus, “Motud og tabal nika koyon, Simun.” ");
INSERT INTO suc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tubus nion, liningoy non og glibun koyon mangka ion poktaluꞌ dia ni Simun, “Mitongow mu og piginang nog glibun koni. Inonggat mu akon dini sog baloy mu koni, tibua, daꞌ mu tanan akon bogoyoy nog tubig nog pongugas u nog botis u saka maꞌ nituꞌ bosia og botad. Tibua, og glibun koni, inugasan non og botis u nog gluaꞌ non mangka non punasoy nog buk non. ");
INSERT INTO suc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bu dosop, daꞌ nika akon olokoy saka maꞌ nituꞌ bosia og botad. Tibua, og glibun koni, daꞌ non lotaꞌoy mongalok og botisanan ku dangan pa minatong ion dini. ");
INSERT INTO suc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bu daꞌ nika tanan lonaoy og gulu u nog saka maꞌ nituꞌ bosia og molongas nog botad. Tibua, og glibun koni, inududan non og botis u nog pogomut. ");
INSERT INTO suc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Toluꞌon ku dianika, minsan siꞌoy miinang nog glibun koni og modakol tokodoy nog dusa, mitampal dia sog glangka non nog kiompunan na ion poꞌ pitongow non nog landuꞌ og glolaman non dianakon. Tibua, ain mikaꞌan da og dusa non nog kiompunan nog Mikpongon, mikaꞌan dosop og glolaman non.” ");
INSERT INTO suc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tubus nituꞌ, miktaluꞌ si Isus dia sog glibun koyon, “Ibun, og glam nog dusa nika inompunan na.” ");
INSERT INTO suc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dangan midongog nog gadap nilan koyon kuman og piktaluꞌ ni Isus koyon, mikpokumodumod ilan. Long nilan dun, “Sima gidoy ini nog minsan og dusa kompunan non ma?” ");
INSERT INTO suc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tibua, miktaluꞌ si Isus sog glibun koyon nog, “Bianan dia sog kopongandol mu mitabang a. Dadi, panow a na bu kotiknaꞌ nog pikilan mongon dianika.” ");
INSERT INTO suc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tubus nituꞌ, miguliugan si Isus dia sog bonuaanan koyon dion mogustal nog Gombaꞌis nog Guksugan paꞌali dia sog pigdotuꞌan nog Mikpongon. Bu migunut dianon og sopuluꞌ kituꞌ bu duaꞌ sulangguꞌanan non, ");
INSERT INTO suc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","bu og duma kolibunanan kituꞌ nog kiuliꞌan og mosakit nilan, bu og binugowan non kituꞌ nog glatdiwata, mamaꞌ ni loꞌ Maria nog og koduaꞌ ngalan non si Magdalena. Ion non og tinosopan kituꞌ nog pitu ginis glatdiwataanan nog pimugow ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Migunut dosop si Jana og kodumanan ni Kusa og binogayan nog bayaꞌ ni Datuꞌ Herod, bu si Susana, bu modakol pa duma kolibunanan nog tinumabang monaꞌub dia ni Isus ilan nog sulangguꞌanan non bianan sog kopogbogoy nilan nog duma gakod nilan. ");
INSERT INTO suc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mikpogdatong na dituꞌ ni Isus og gotowanan nog miktidu sog ainain nog bonuaanan nog boyaꞌan modakol tokodoy miglumpuk dianon. Dadi, inuksugan non ilan nog solabuk pononggiꞌan. ");
INSERT INTO suc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Long non dun, “Ngon sala kotow minangoy sumigwag nog boniꞌ. Dangan sinigwag non og boniꞌ non koyon, og duma, dia mitonaꞌ sog dalan nog boyaꞌan midogyak nog gotowanan bu pingoktuk nog manukmanukanan. ");
INSERT INTO suc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Og duma sop, dia mitonaꞌ sog dolonitan. Dadi, dangan linumawa, milanos poꞌ og glupaꞌ koyon modaliꞌ pomala. ");
INSERT INTO suc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Og duma sop, dia mitonaꞌ sog sompinitan. Dadi, dangan linumawa og sompinitan koyon, miumos og pomulan koyon dun. ");
INSERT INTO suc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Bu og duma sop, dia mitonaꞌ sog monapuꞌ nog glupaꞌ. Dadi, dangan tinumubuꞌ, mokosubuk bu migbunga nog molongas mangka songkuꞌ.” Tubus nituꞌ, pisikad ni Isus og taluꞌ non, “Ain togo tolinga, sumboy pokinongogan non og piktaluꞌ u koni!” ");
INSERT INTO suc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tubus nion, miksak dia ni Isus og sulangguꞌanan non bog olo og maꞌana nog pononggiꞌan non koyon. ");
INSERT INTO suc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Dadi, tinabal non ilan nog, “Amu koyon, pisabut na dianiu og milimod kituꞌ nog paꞌali sog pigdotuꞌan nog Mikpongon. Tibua, podongogon ku dia sog duma gotowanan bianan sog pononggiꞌan nog minsan mokotongow ilan da bosia, tibua, ondiꞌ nilan kosunan. Bu minsan siꞌoy mokinongog ilan, ondiꞌ nilan mosabut.” ");
INSERT INTO suc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tubus nion, long ni Isus dun, “Maꞌ nini og maꞌana nog pononggiꞌan ku koyon. Og boniꞌ koyon, ion non og taluꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Og dalan kituꞌ nog kitonaꞌan nog boniꞌ domikian da maꞌ nog gotowanan kituꞌ nog mikodongog siꞌoy nog taluꞌ nog Mikpongon, tibua, inangoy owaꞌoy ni Kindagow dia sog pikilan nilan bagun ilan da diꞌ tumud boyaꞌan diꞌ ilan motabang dun. ");
INSERT INTO suc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Og dolonitan kituꞌ nog kitonaꞌan nog boniꞌ domikian da maꞌ nog gotowanan kituꞌ nog puꞌun midongog nilan og gustalan kituꞌ nog paꞌali sog Mikpongon tinabuk nilan dunut landuꞌ og gloliag nilan dun. Tibua, daꞌ nilan ungodoy mahatul dia sog pikilan nilan. Tinumud ilan solianlian tibua dangan dinotongan ilan nog suloy sog kotubuꞌ nilan, binolong nilan og tud nilan. ");
INSERT INTO suc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Og glupaꞌ kituꞌ nog sompinitan nog kitonaꞌan nog boniꞌ domikian da maꞌ nog gotowanan kituꞌ nog mikodongog nog taluꞌ nog Mikpongon. Tibua, dinag ilan nog susaan nilan bu kopogapas nilan nog daya, bu og gloliag nilan nog dinunya. Dadi, og tud nilan miimung daꞌ doksuꞌ non. ");
INSERT INTO suc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bu og glupaꞌ kituꞌ nog monapuꞌ nog kitonaꞌan nog boniꞌ domikian da maꞌ nog gotowanan kituꞌ nog molongas nog mikodongog nog taluꞌ nog Mikpongon nog inungod nilan dia sog pikilan nilan, bu kobon non potubudan nilan og glangka nilan bagun motongow og bunga nog tud nilan.” ");
INSERT INTO suc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Maꞌ long sop ni Isus dun, “Daꞌidun og tumutud nog suluꞌ nog dia non toguꞌoy sog dialom sibulan otawaka lingodon non og dolag non. Sugaꞌid non, dia non nododaꞌ botangoy sog motampal bagun da simasima sumolod dion kodolagan ilan dun. ");
INSERT INTO suc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Poꞌ daꞌidun og pigbuni nog ondiꞌ ompolantaꞌ. Bu og glam nog daꞌ niu kosabut posobuton da dianiu sog binayaꞌ nog gondow. ");
INSERT INTO suc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Saꞌan pokpotubud amu sog koponginongog niu nog pomali u koni poꞌ simasima ongon dianon dungagan pa. Tibua, ain baluꞌ non dun nog ongon na dianon, owaꞌon pa dianon, minsan siꞌoy dakoldakol non na.” ");
INSERT INTO suc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tubus nion, minangoy dituꞌ ni Isus og ginaꞌ non bu og putupusodanan non nog kolokian. Tibua, daꞌ ilan pokopokpolani dianon poꞌ modakol og gotowanan nog linumumpuk dianon. ");
INSERT INTO suc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dadi, ongon sala kotow dion nog miktaluꞌ dianon nog, “Polopanad, og ginaꞌ mu bu og putupusodanan mu nog kolokian, dituꞌ ilan sog glowasan poꞌ moleg ilan bosia moktongow dianika.” ");
INSERT INTO suc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tinumabal si Isus nog, “Og ginaꞌ u bu og putupusodanan ku, ion non og gotowanan kituꞌ nog mikinongog nog taluꞌ nog Mikpongon mangka ilan pokokunut dun.” ");
INSERT INTO suc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ongon gondow non miktaluꞌ si Isus dia sog sulangguꞌanan non nog, “Alung, tumolipag ita dituꞌ sog dipag nog danow koni.” Dadi, sinumakoy ilan sog bolangoy koyon mangka ilan tulak. ");
INSERT INTO suc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sonuk nilan koyon lumayag mikotulug si Isus. Gomonsunoy pa miglogoyup nog mosikad nog boyaꞌan kisigoban nog nabok og bolangoy nilan koyon. Dadi, kondokondok og kibotangan nilan koyon. ");
INSERT INTO suc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dadi, inangoy ion tonudoy nog sulangguꞌanan non. Long nilan dun, “Kounutan! Kounutan! Moglaꞌat ita!” Dadi, si Isus migbuat mangka non polotaꞌoy og galuꞌ koyon nog molandos bu og nabok koyon nog moluksang. Dadi, sododuꞌun tinumodoꞌ og danow koyon. ");
INSERT INTO suc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tubus nituꞌ, tinoluꞌan non ilan nog, “Ain noma og kopongandol niu?” Tibua, og sulangguꞌanan non koyon, kisobuꞌan bu kiondokan ilan mangka ilan poksinaksakoy nog, “Sima gidoy og gotow koni? Kopogboyaꞌan non ma og goyup bu nabok, bu mogbilang ma dianon!” ");
INSERT INTO suc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dadi, dituꞌ ilan dinumongguꞌ sog bonua nog ngalan non Gadarinis, migdipag ilan nog bonua nog Galili. ");
INSERT INTO suc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Dangan tinumukpa si Isus sog pontad, linumpak ion nog gotow nog tinosopan nog glatdiwataanan nog tidu ion sog bonua koyon. Miobon na ion daꞌ ponapot bu daꞌ pogonong sog baloy. Sugaꞌid non, dia na migonong sog kolobongan. ");
INSERT INTO suc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Dangan mitongow non si Isus, miglosek ion mangka kobuksak sog sunguꞌan ni Isus mangka poktaluꞌ nog mosikad nog, “Olo og dunon mu dianakon Isus, ika og Bataꞌ a nog Mikpongon nog diꞌ kolobian? Suꞌusa, naꞌ mu pa akon posinsaon.” ");
INSERT INTO suc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Saꞌan maꞌ nituꞌ poꞌ dinondag ni Isus og glatdiwataanan kituꞌ mawaꞌ dia sog glawas nog gotow koyon. Poꞌ tatap na ion posinsaon nog glatdiwataanan koyon mangka ion oitoy nog glatdiwataanan koyon dituꞌ sog bonua kituꞌ nog daꞌidun og migonong dun. Bu minsan siꞌoy pusasan og komot non bu botis non nog glantaylantay bu mangka ion pogipatoy, ponggotuson non da og glantaylantay non koyon. ");
INSERT INTO suc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Dadi, sinakan ion ni Isus nog, “Sima og ngalan mu?” Tinumabal og gotow koyon nog, “Og ngalan ku si Nginibuan.” Poꞌ landuꞌ kodakol og glatdiwataanan nog tinumosop dianon. ");
INSERT INTO suc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dadi, mingapuꞌngapuꞌ og glatdiwataanan koyon dia ni Isus nog diꞌ ilan na popongoyon dituꞌ sog dialom nog Abis. ");
INSERT INTO suc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Sog molani nilan koyon, ongon og panun nog babuy nog solian nilan monungkal dia sog pun bilid koyon. Migbubut og glatdiwataanan koyon nog dia ilan pa sangon sog babuyanan koyon. Dadi, kinumboy ilan ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dadi, mikpongluas og glatdiwataanan koyon tidu sog gotow koyon mangka ilan sangon sog babuyanan koyon. Bu og panun nog babuy koyon, mikponggobok ilan dumiksun mangka pokpongokpu sog danow bu mitipot ilan kolomos. ");
INSERT INTO suc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Dangan mitongow nog polongipat nog babuyanan koyon og maꞌ nion koyon, mikponggobok ilan mangka nilan poguksugoy dituꞌ sog koliwagan bonua koyon og glam nog mitongow nilan koyon. ");
INSERT INTO suc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dadi, inangoy nog gotowanan koyon tontongoy og bianbian koyon. Dangan minatong ilan dituꞌ ni Isus, mitongow nilan og gotow kituꞌ nog bakas poktosopan nog glatdiwataanan pogingkud dia sog sunguꞌan ni Isus nog minapot na bu molongas na og pomikilan non. Dadi, kiondokan ilan dun. ");
INSERT INTO suc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Og gotowanan sop nog ain mikotongow nog bianbian koyon, miguksug ilan dosop sog duma gotow bog olo bianbian nog gotow koyon nog boyaꞌan kiuliꞌan. ");
INSERT INTO suc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dadi, og glam nog gotow nog miktidu sog bonua nog Gadarinis, pigbubut nilan si Isus nog mawaꞌ pa dion sog bonua nilan koyon poꞌ kiondokan ilan tokodoy. Dadi, sinumakoy si Isus dia sog bolangoy poꞌ daliꞌ na tulak. ");
INSERT INTO suc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tibua, og gotow koyon nog kiuliꞌan, migbubut bosia mogunut dia ni Isus. Tibua, dinondag ni Isus muliꞌ mangka non toluꞌoy nog, ");
INSERT INTO suc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uliꞌ a mangka mu uksugoy bog andun kosolag og miinang nog Mikpongon dianika.” Dadi, minuliꞌ og gotow koyon bu migdundaan dia sog koliwagan bonua koyon kobon non moguksug nog gininang ni Isus kituꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Dangan mikpuliꞌ na si Isus sog dipag nog danow koyon, pigdodial ion nog modakol nog gotowanan poꞌ pigdodomaan nilan ion. ");
INSERT INTO suc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tubus nion, ongon minatong sala kotow ngalan non si Jairus og polongokbit nog solabuk baloy nog poglumpukan nog bansa Hudyu. Sinumugyut ion dia ni Isus mangka non pogbubutoy nog mogunut pa si Isus dianon dituꞌ sog baloy nilan. ");
INSERT INTO suc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Poꞌ dakoldakol nog bataꞌ non nog glibun nog sopuluꞌ pa bu duaꞌ og tinonan non pokpatoy na. Dadi, migunut si Isus dianon. Bu sonuk nilan ompanow, linumpukan ion nog gotowanan nog landuꞌ na kodakol. ");
INSERT INTO suc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bu ongon sala kotow glibun dion nog poglodasan nog duguꞌ sog solod nog sopuluꞌ bu duaꞌ ton. Diadia na ion mikpobulung nog polomulunganan, tibua, daꞌ da ion kuliꞌoy. ");
INSERT INTO suc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bu migapas ion mokopolani dia ni Isus. Dangan dia na ion sog tolikudan ni Isus, pigdoyunan non tumuyok og sudung nog glogdoy ni Isus bu sododuꞌun milotaꞌ ion poglodasan. ");
INSERT INTO suc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dadi, miksak si Isus nog, “Sima og tinumuyok kituꞌ dianakon?” Dangan minonsing og glam nog gotowanan koyon dion, miktaluꞌ si Piter nog, “Motuyok a nododaꞌ, Kounutan, kobal nog glumpuk nog gotowanan koni nog milodis dianika.” ");
INSERT INTO suc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tibua, long ni Isus dun, “Ongon nododaꞌ og tinumuyok dianakon poꞌ mibatik u sog glawas u nog ongon sala kotow dianiu og kiuliꞌan nog pagas u kobal non tumuyok dianakon.” ");
INSERT INTO suc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dangan kisunan nog glibun koyon nog kisunan ion ni Isus, linukuban ion kobon non mokpolani dituꞌ ni Isus mangka sugyut dianon. Sog glumpuk nog gotowanan koyon dion, inustal non dia ni Isus bog iduma tinuyok non ma ion bu olo og migandun nog kokodag non sododuꞌun. ");
INSERT INTO suc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dadi, miktaluꞌ si Isus dianon nog, “Ibun, bianan sog kopongandol mu, kiuliꞌan ka. Sugaꞌid non, panow a na bu og kotiknaꞌ nog pikilan mongon dianika.” ");
INSERT INTO suc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sonuk pa ni Isus moktaluꞌ, ongon og minatong og gobok tidu dituꞌ sog baloy ni Jairus. Long nog gotow koyon dia ni Jairus, “Og bataꞌ mu kituꞌ diꞌ nika na mosaꞌut. Dadi, diꞌ ta na pogonggaꞌon og polopanad koyon nog mangoy pa dituꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tibua, midongog ni Isus og guksugan non koyon. Dadi, miktaluꞌ ion dia ni Jairus, “Naꞌ a mosusa. Sugaꞌid non, tud a tibua poꞌ og bataꞌ nika kituꞌ kuliꞌan da.” ");
INSERT INTO suc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Dangan minatong si Isus sog baloy ni Jairus koyon, pigondiꞌan non og duma gotowanan koyon mogunut sumolod lual da si Piter, si Jan, si Jems, bu og ginaꞌamaꞌ nog bataꞌ koyon. ");
INSERT INTO suc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Glam nog gotowanan dion sog baloy koyon mikponglangos ilan sabap dia sog bataꞌ koyon. Tibua, long ni Isus dianilan, “Naꞌ amu lumangos poꞌ og bataꞌ koni ondaꞌ patoy, sugaꞌid non, sagya da ion mitulug.” ");
INSERT INTO suc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dadi, pigwanwan nilan si Isus dun poꞌ mitintu dianilan nog og bataꞌ koyon minatoy nododaꞌ. ");
INSERT INTO suc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tibua, pilonian ni Isus og bataꞌ koyon mangka non pogoidoy sog komot bu toluꞌoy nog, “Ibun, pogbuat a.” ");
INSERT INTO suc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dadi, og bataꞌ koyon mitubuꞌ mokpuliꞌ mangka pogbuat mogdayun. Tubus nion, dinondag ni Isus nog bogayan og bataꞌ koyon nog ponganon. ");
INSERT INTO suc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Dadi, kisobuꞌan tokodoy mokogulang nog bataꞌ koyon dun. Tibua, pigondiꞌan ilan ni Isus moguksug nog glam nog bianbian koyon. ");
INSERT INTO suc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pilumpuk ni Isus og sopuluꞌ bu duaꞌ sulangguꞌanan non koyon mangka non ilan bogoyoy nog pagas bu bayaꞌ momugow nog glam nog glatdiwataanan bu monguliꞌ nog gininisan nog mokosakit, ");
INSERT INTO suc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","mangka non ilan dondagoy mangoy momali paꞌali dia sog pigdotuꞌan nog Mikpongon bu monguliꞌ nog ain kituꞌ diꞌ mokokodag. ");
INSERT INTO suc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bu mangka non ilan toluꞌoy nog, “Sog panow niu koyon, naꞌ amu mogoit nog minsan olo, mamaꞌ nog tagad, og toguꞌan nog balan, og ponganon, og sin, bu minsan og gimolaan niu. ");
INSERT INTO suc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dituꞌ amu batuk sog baloy nog ain og tumolimaꞌ dianiu, asta sog gumonat amu sog koliwagan bonua koyon. ");
INSERT INTO suc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tibua, bila ngon og koliwagan bonua nog ondiꞌ tumolimaꞌ dianiu, pokpasoy niu og glopug nog glupaꞌ nog minokot sog botis niu bagun nilan da kosunan og tandaꞌ nog diꞌ amu na kosakan nog minsan olo og matong dianilan.” ");
INSERT INTO suc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dadi, ginumonat og sulangguꞌanan non koyon bu miguliugan ilan sog bonuaanan koyon mogustal nog Gombaꞌis nog Guksugan bu mokpokodag nog diꞌ mokokodag sog bonuaanan nog kodopotan nilan. ");
INSERT INTO suc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tubus nituꞌ, si Herod, og datuꞌ dia sog bonua nog Galili, midongog non og glam nog miinang ni Isus kituꞌ. Dadi, mibabong og pikilan non poꞌ mokpoktaluꞌ og duma gotowanan nog si Isus dow ion non na si Jan nog Polomunyag nog mitubuꞌ puliꞌ. ");
INSERT INTO suc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bu dumaanan sop mokpoktaluꞌ ilan nog ion dow si Iladya og polomolatas kituꞌ nog taluꞌ nog Mikpongon kobon nituꞌ mikpuliꞌ dow ion dini. Bu ongon sop moktaluꞌ nog ion dow og sala kotow polomolatas dosop nog taluꞌ nog Mikpongon kobon nituꞌ nog mitubuꞌ puliꞌ. ");
INSERT INTO suc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Dadi, miktaluꞌ si Herod nog, “Si Jan og Polomunyag kituꞌ, piputuk u na og gulu non. Dadi, sima gidoy ion buan og gotow koyon nog kobon non modongog u og dongogan non?” Saꞌan ion moleg tokodoy bosia si Herod moktongow dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Dangan mikponguliꞌ og sosuguꞌonanan ni Isus, piguksugan nilan dianon og glam nog miinang nilan. Tubus nituꞌ, inoit non ilan posunguꞌ sog bonua kituꞌ nog ngalan non og Betsaida nog ilanilan da. ");
INSERT INTO suc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Dangan kisunan nog gotowanan koyon nog ginumonat ilan na, miglondug ilan. Dadi, tinolimaꞌ ilan ni Isus mangka non suksugoy dianilan paꞌali sog pigdotuꞌan nog Mikpongon bu pikodag non ain diꞌ mokokodag. ");
INSERT INTO suc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dangan daliꞌ na sindop ondow, minangoy dituꞌ non og sopuluꞌ bu duaꞌ sulangguꞌanan non koyon mangka ilan poktaluꞌ nog, “Golom nika na ilan dondagoy ompanow poꞌ bagun ilan mokoponukat nog ponganon nilan bu mokoponontong nog kobotukan nilan sog gimbolayananan sog bonua. Poꞌ molayuꞌ ita pa sog gimbolayan.” ");
INSERT INTO suc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tibua, tinabal ilan ni Isus nog, “Amu na pogbogoy nog ponganon dianilan.” Dadi, tinumabal ilan, “Lima buk da pan bu duaꞌ buk da og sodaꞌ nami! Lual da mangoy ami poguna sumaluy nog ponganon nog gotowanan koni.” ");
INSERT INTO suc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Og dakol nog kolokian tibua koyon dion, lima ngibu kotow. Bu miktaluꞌ si Isus dianilan, “Pingkud niu og gotowanan koyon nog limalima puluꞌ kotow og solumpuk dun.” ");
INSERT INTO suc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dadi, ininang nog sulangguꞌanan non koyon og dinondag non koyon dianilan bu mikpongingkud ilan glam nilan. ");
INSERT INTO suc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tubus nituꞌ, inimud ni Isus og lima buk pan bu duaꞌ buk sodaꞌ koyon mangka ion tongal sog glangit bu posolomatoy dia sog Mikpongon mangka non pomotioy og pan bu sodaꞌ koyon bu pomogoyoy sog sulangguꞌanan non koyon mangka nilan pomogoyoy dia sog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dadi, mikpongongan og glam nilan bu mikpogbosug ilan. Ngon pa og samaꞌ nog gotowanan koyon kuman nog lagaꞌ nog sopuluꞌ bu duaꞌ bogyas og miomud nog sulangguꞌanan koyon dun. ");
INSERT INTO suc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ongon tang non migyakin si Isus salasala non. Og sulangguꞌanan non kituꞌ, dion ilan da sog molani non. Sinakan non ilan nog, “Sima u gidoy long nog gotowanan dun?” ");
INSERT INTO suc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tinumabal ilan nog, “Og duma mokpoktaluꞌ ilan nog ika dow si Jan nog Polomunyag. Og duma sop mokpoktaluꞌ ilan nog ika dow si Iladya. Bu og duma sop mokpoktaluꞌ ilan nog ika dow og solabuk polomolatas dosop nog taluꞌ nog Mikpongon kobon nituꞌ nog mitubuꞌ a puliꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dadi, sinakan non sop ilan nog, “Bila buan amu, sima u gidoy?” Tinumabal si Piter, “Ika og Kristu.” ");
INSERT INTO suc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tubus nion, pidonsamaꞌ non tumaluꞌ dianilan nog diꞌ nilan tokodoy posunon dia sog minsan sima bog sima ion. ");
INSERT INTO suc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Bu maꞌ long non dun, “Og Binataꞌ sog Kilawan sumboy mosinsa tokodoy bu pogbongkison ion nog bogolalanan, bu og mokokotas nog boliananan, bu og polopanadanan nog botad nog bansa Hudyu. Bu sumboy ion bunuꞌon. Tibua, sog kotolu ondow non motubuꞌ da ion puliꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tubus nion, miktaluꞌ si Isus sog glam nilan koyon dion nog, “Simasima moleg mogunut dianakon sumboy tolikudan non og dili glegan non mangka non pisanoy og kudus non gondow gondow bu pogunut dianakon. ");
INSERT INTO suc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Poꞌ simasima og landuꞌ kopogapas non nog dili kotubuꞌ non, kobolongan da ion dun. Tibua, simasima og lamig non na bolongon og dili kotubuꞌ non sabap sog kopokokunut non dianakon, kongonan ion dun. ");
INSERT INTO suc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Poꞌ olo gidoy buan og glongas non nog makod nog gotow og daya sog tibuk nog dunya koni saka, ombolong og glimukud non? ");
INSERT INTO suc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Poꞌ simasima og mosipog dianakon bu dia sog pomali u, akon, og Binataꞌ sog Kilawan mosipog u dosop dianon sog tang nog kopokpuliꞌ u, dunut silow nog kotas u dunut dosop silow nog kotas nog Gamaꞌ u nog ion og Mikpongon, bu asta og moloikatanan non kituꞌ nog mosigda. ");
INSERT INTO suc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Toluꞌon ku dianiu, ongon dumaanan ta dini nog diꞌ ilan pa tagad patoy taman da ondiꞌ nilan motongow og kopogdatuꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ngon na bayuꞌ walu gobi tidu toluꞌon ni Isus, inoit non si Piter, si Jan, bu si Jems tumukad sog bontud mangoy mogyakin. ");
INSERT INTO suc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sonuk ni Isus mogyakin, gomonsunoy pa miksop og bayuꞌbayuꞌ non bu sinumilow og ponopoton non. Miglamag maꞌ nog kilat. ");
INSERT INTO suc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Gomonsunoy pa mitongow nilan duaꞌ kotow dosop dion nog si Muses bu si Iladya. ");
INSERT INTO suc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bu ilan siꞌoy mikpoglamag ilan dosop. Migabitabit ilan ni Isus paꞌali sog glegan nog Mikpongon nog daliꞌ na kotuman ni Isus bianan sog kopatoy non dituꞌ sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Si Piter bu dumaanan non koyon, mikotulug ilan. Tibua, mitanud ilan bu mitongow nilan si Isus nog miglamag bu og duaꞌ kotow koyon nog sindog non. ");
INSERT INTO suc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dangan poglogonat na og duaꞌ kotow koyon, miktaluꞌ si Piter dia ni Isus. Long non dun, “Kounutan, ombaꞌis da nog mikodini ami. Mogimung ami nog tolu buk glokowlokow. Solabuk dianika, solabuk dia ni Muses, bu solabuk dia ni Iladya.” (Tibua, daꞌ kosunoy ni Piter bog olo piktaluꞌ non koyon.) ");
INSERT INTO suc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sonuk non koyon moktaluꞌ, gomonsunoy pa og ginampol mikpotondong dianilan. Bu kiondokan ilan dangan liniputusan ilan nog ginampol koyon. ");
INSERT INTO suc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tubus nion, ngon og taluꞌ nog midongog nilan miktidu sog ginampol koyon nog maꞌ nini, “Koni og bataꞌ u nog piniliꞌ u. Pokinongog amu dianon.” ");
INSERT INTO suc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dangan miluksad tibua og taluꞌ koyon, mitongow nilan sala dona ni Isus og pogindog dion. Tibua, og glam nog mitongow nog sulangguꞌanan koyon, daꞌ nilan pogobitoy sog gotowanan, minsan sala kotow siꞌoy. ");
INSERT INTO suc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Dangan miglen gondow, si Isus bu og dumaanan non koyon, dinumiksun ilan tidu sog bontud bu modakol og gotowanan linumumpak dianilan. ");
INSERT INTO suc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ongon sala kotow tidu sog glumpuk nog gotowanan koyon miktawag. Long non dun, “Polopanad, tontong nika pa suꞌusa og bataꞌ u koni nog glaki nog boktung. ");
INSERT INTO suc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Pikposinsa ion nog glatdiwata. Bu gomonsunoy pa moglosek na ion mangka lakus bu pogbulaꞌ og babaꞌ non. Dadi, ilakad na og sinsaan non dun poꞌ diꞌ na mokulog dianon og glatdiwata koyon. ");
INSERT INTO suc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mikitabang u na bosia dia sog sulangguꞌanan mu koyon nog bugowon nilan pa. Tibua, ondiꞌ nilan ombugow.” ");
INSERT INTO suc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dadi, tinumabal si Isus nog, “Amu, og gotowanan numun koni, diꞌ amu nododaꞌ tumud bu polongantu amu! Andun pa kopayat og gobon ku mokunul dianiu bu moglogaga dianiu? Oit mu dini og bataꞌ mu koyon.” ");
INSERT INTO suc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dangan molani na og bataꞌ koyon dia ni Isus, mibuksak nosop sog glupaꞌ mangka lakus poꞌ maꞌ nion og kopokposinsa nog glatdiwata koyon dianon. Dadi, binugow ni Isus og glatdiwata koyon bu kiuliꞌan og bataꞌ koyon bu mangka non uokiloy dia sog gamaꞌ non. ");
INSERT INTO suc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Glam nog gotowanan koyon dion kisobuꞌan nog kokosog nog bayaꞌ nog Mikpongon. Sonuk nilan koyon kosobuꞌan nog glam nog kohinangan ni Isus koyon, miktaluꞌ ion dia sog sulangguꞌanan non nog, ");
INSERT INTO suc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Poktitukoy niu og toluꞌon ku koni dianiu. Og Binataꞌ sog Kilawan uokilon dia sog bayaꞌ nog gotowanan bagun moglaꞌat ion.” ");
INSERT INTO suc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tibua, og sulangguꞌanan non koyon, daꞌ nilan kosabut og maꞌana nog piktaluꞌ non koyon poꞌ daꞌ non pa posobutoy dianilan nog boyaꞌan daꞌ kadal nog pikilan nilan. Bu mondok ilan dosop moksak dia ni Isus bog olo og maꞌana nog piktaluꞌ non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mikpoksusi og sulangguꞌanan koyon bog sima og motas dianilan. ");
INSERT INTO suc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tibua, kisunan ni Isus og dialom pikilan nilan. Dadi, minalap ion nog bataꞌ mangka non pindogoy sog molani non ");
INSERT INTO suc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","mangka poktaluꞌ dianilan, “Simasima og tumolimaꞌ sog bataꞌ koni bianan sog ngalan ku, tinolimaꞌ non dosop akon. Bu simasima og tumolimaꞌ dianakon, tinolimaꞌ non dosop og dinumondag dianakon mangoy dini. Poꞌ simasima dianiu og mokpobabaꞌ sog glam niu, ion sop og motas dia sog glam niu.” ");
INSERT INTO suc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tubus nituꞌ, miktaluꞌ si Jan dia ni Isus. Long non dun, “Kounutan, mikotongow ami nog gotow nog mimugow nog glatdiwataanan bianan sog ngalan mu. Dadi, pigondiꞌan nami poꞌ konaꞌ ta ion og sakup.” ");
INSERT INTO suc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tinumabal si Isus nog, “Naꞌ niu ion pogondiꞌan poꞌ simasima diꞌ sumusi dianiu, sugutan non amu.” ");
INSERT INTO suc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dangan daliꞌ na og tang nog kopokpuliꞌ ni Isus sog glangit, migapas ion mangoy sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bu ongon piuna non dituꞌ sog solabuk koliwagan bonua kituꞌ nog dituꞌ sog Samaria mangoy monolimpan nog kapit non dituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tibua, og gotowanan sog koliwagan bonua koyon ompok nog mapit si Isus dion nilan poꞌ kisunan nilan nog si Isus posunguꞌ mangoy sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Dangan midongog ni Jems bu si Jan og maꞌ nion koyon, miksak ilan dia ni Isus nog, “Kounutan, moleg a taꞌ nog mongoningoni ami nog kolobuꞌan pa nog gapuy tidu sog glangit og gotowanan koyon bagun ilan moglaꞌat dun?” ");
INSERT INTO suc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Liningoy ilan ni Isus mangka non ilan pomagoy. ");
INSERT INTO suc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bu miglandan ilan ompanow posunguꞌ dituꞌ sog len bonua. ");
INSERT INTO suc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sonuk nilan koyon ompanow, ongon sala kotow miktaluꞌ dia ni Isus. Long non dun, “Mogunut u dianika minsan ain ka angoy.” ");
INSERT INTO suc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tinumabal si Isus nog, “Og tinggalung togo pogonongan bu og manukmanuk togo salag. Tibua, og Binataꞌ sog Kilawan, daꞌidun tanan og dolopaꞌan non.” ");
INSERT INTO suc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Miktaluꞌ si Isus sog len gotow sop nog, “Ika, pogunut a dianakon.” Tibua, tinumabal og gotow koyon nog, “Kounutan, ondiꞌ u pa mokodunut dianika poꞌ lobongon ku pa poguna og gamaꞌ u.” ");
INSERT INTO suc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dadi, tinabal ion ni Isus, “Potiang nika na ain og diꞌ bololagaꞌ dianilan og pigdotuꞌan nog Mikpongon nog ilan dona og lumobong nog bangkoy nilan. Sugaꞌid non, ika, panow a mangka nika suksugoy paꞌali sog pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bu ongon dosop sala kotow miktaluꞌ, “Kounutan, mogunut u dianika. Tibua, mangoy pa poguna momuhun dituꞌ sog ginonglangan ku.” ");
INSERT INTO suc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Dadi, tinabal ion ni Isus, “Simasima og mikopoktolipun na mogbagyaꞌ saka kobon non da lumingoy, diꞌ ion ombaꞌis tumabang moginang dia sog pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tubus nituꞌ, og Kounutan mimiliꞌ dosop nog pitu puluꞌ bu duaꞌ kotow bu piuna non doduaꞌ kotow sog bonuaanan kituꞌ nog posunguꞌ non ongoyan. ");
INSERT INTO suc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Bu tinaluꞌ non dianilan nog, “Moliwag og gonion. Tibua, mikaꞌan da og polonggani. Dadi, pongoningoni amu sog gapuꞌ nog gonion nog mokpoit ion dumungag nog polonggani dia sog gonion non koni. ");
INSERT INTO suc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dadi, panow amu na. Tibua, pongmayaꞌ amu poꞌ poponowon ku amu nog mamaꞌ nog nati nog bilibilianan nog mangoy tumimbul dia sog glimonganan. ");
INSERT INTO suc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bu naꞌ amu mokpitang nog sin, bu og toguꞌan nog balanbalan, otawaka og pongyapak. Naꞌ amu dosop manggaꞌ mogabitabit nog gotowanan dia sog dalan. ");
INSERT INTO suc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bu bila mogdangan amu sog baloy, og tiganaꞌ toluꞌon niu maꞌ nini, ‘Popiaon og gotow sog baloy koni.’ ");
INSERT INTO suc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bila ongon gotow dion nog ombaꞌis pikilan non, og popia niu koyon mongon da dianon. Tibua, bila diꞌ, muliꞌ da dianiu. ");
INSERT INTO suc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dion amu batuk sog baloy koyon. Bu kan niu ain pokanon dianiu bu inum niu ain pinumon dianiu. Poꞌ og gotow nog moginang, patut nododaꞌ tumbasan. Bu naꞌ amu moktolopasan nog gimbolayan nog botukan niu. ");
INSERT INTO suc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Bila sop matong amu sog solabuk koliwagan bonua bu tolimaꞌon nilan amu, kan niu ain goktob nog sinimpan dianiu. ");
INSERT INTO suc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tubus nituꞌ, ponguliꞌoy niu ain diꞌ mokokodag sog bonua koyon. Bu taluꞌ niu sog gotowanan dion nog, ‘Og kopogbayaꞌ nog Mikpongon molani na dianiu.’ ");
INSERT INTO suc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tibua, bila sumolod amu sog koliwagan bonua saka diꞌ nilan amu tolimaꞌon, angoy amu sog tobuꞌan nog bonua koyon mangka niu toluꞌoy nog, ");
INSERT INTO suc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Minsan siꞌoy og glopug nog glupaꞌ sog bonua niu koni nog minokot sog botisanan nami, pokpason nami poꞌ kituꞌ og mokotaksiꞌ dianiu. Tibua, ilingon nami maꞌ nini bagun niu kosunan og kopogbayaꞌ nog Mikpongon molani na.’ ");
INSERT INTO suc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Toluꞌon ku dianiu, sog gondow nog polihalaꞌ nog Mikpongon, labi pa og posakit dia sog gotowanan koyon nog diꞌ tumolimaꞌ dianiu, gabaꞌ nog posakit dia sog gotowanan kituꞌ sog bonua nog Sodom. ");
INSERT INTO suc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Dadi, kosusasusa amu og gotowanan sog bonua nog Korasin bu sog bonua nog Betsaida. Poꞌ somoꞌ og dakol nog gingyataꞌanan kituꞌ nog ininang u dituꞌ niu, dia u pa ininang sog bonua nog Tair bu Sidon, miobon ilan na bosia moglilaꞌ nog dusaanan nilan bu ponapot nog saku mangka ingkud dia sog gobuan. ");
INSERT INTO suc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tibua, bila matong na gondow nog poliholaꞌon nog Mikpongon og gotowanan, labi pa og posakit dianiu sog posakit dia sog gotowanan kituꞌ sog bonua nog Tair bu bonua koyon nog Sidon. ");
INSERT INTO suc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bu amu og gotowanan sog Kapernaum, moleg amu siꞌoy ompotas asta motingkuꞌ amu sog glangit, lobuꞌon amu da dia sog gapuy kituꞌ nog ondiꞌ ompalong.” ");
INSERT INTO suc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Bu maꞌ long sop ni Isus dia sog sulangguꞌanan non koyon, “Simasima og monginongog dianiu, maꞌana non minginongog ilan dosop dianakon. Tibua, ain diꞌ tumolimaꞌ dianiu, maꞌana non diꞌ nilan dosop akon tolimaꞌon. Bu simasima og diꞌ non akon tolimaꞌon, maꞌana non diꞌ non dosop tolimaꞌon og dinumondag kituꞌ dianakon mangoy dini.” ");
INSERT INTO suc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Dangan mikpuliꞌ na og pitu puluꞌ bu duaꞌ kotow koyon nog pipanow ni Isus, landuꞌ tokodoy og daꞌdaꞌan nilan kobon nilan moguksug dia ni Isus. Long nilan dun, “Kounutan, minsan og glatdiwataanan migbilang ilan dianami bianan sog ngalan mu!” ");
INSERT INTO suc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dadi, tinabal ilan ni Isus, “Oꞌo dodaꞌ poꞌ mitongow u tanan si Kindagow nog midogdag maꞌ nog kilat tidu sog glangit. ");
INSERT INTO suc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Binogayan ku amu nog bayaꞌ mondogyak nog mamak bu gulasulas. Bu binogayan ku dosop amu nog bayaꞌ momondag dia sog glam nog bayaꞌ nog minanta kituꞌ dianiu bu daꞌidun og mogandun dianiu. ");
INSERT INTO suc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tibua, naꞌ amu mogdaꞌdaꞌ dun nog migbilang dianiu og glatdiwataanan. Sugaꞌid non, pogdaꞌdaꞌ amu nog og ngalananan niu sinulat na dituꞌ sog glangit.” ");
INSERT INTO suc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sog tang koyon, si Isus migdaꞌdaꞌ tokodoy sabap sog Bolakat nog Mikpongon bu miktaluꞌ ion nog, “Amaꞌ, ika og Pogbayaꞌ sog pigloban nog glangit bu glupaꞌan. Mikposolamat u dianika poꞌ linimod mu og kohinangan kituꞌ dia sog gotowanan nog sabutbaꞌasa bu pitongow mu dia sog gotowanan kituꞌ nog kulang pa bosia og sabut non. Oꞌo, Amaꞌ, ininang mu ituꞌ poꞌ maꞌ nituꞌ og kosuꞌatan ka dun.” ");
INSERT INTO suc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tubus nituꞌ, miktaluꞌ nosop si Isus dianilan nog, “Og glam non inuakil na dianakon nog Gamaꞌ u. Daꞌidun og mokokilala bog sima og Bataꞌ lual da og Gamaꞌ. Bu daꞌidun dosop mokokilala bog sima og Gamaꞌ lual da og Bataꞌ, bu ain og kolegan nog Bataꞌ koyon potongowon dianon og Gamaꞌ non.” ");
INSERT INTO suc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tubus nion, sinunguꞌ ni Isus og sulangguꞌanan non bu tinoluꞌan non ilan, “Popiaon og gotow kituꞌ nog motongow nilan ain og mitongow niu. ");
INSERT INTO suc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Poꞌ dini kituꞌ modakol og polomolatasanan bu datuꞌanan mogapas bosia mokotongow nog mitongow niu koyon bu mokinongog nog midongog niu koyon. Tibua, daꞌ ilan pokotongow bu pokodongog dun.” ");
INSERT INTO suc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ongon gondow non, ongon sala kotow polopanad nog botad nog bansa Hudyu minangoy dituꞌ ni Isus poꞌ pogolapsobapan non ion. Long non dun dia ni Isus, “Polopanad, olo gidoy sumboy inangon ku bagun ku malap og kotubuꞌ nog daꞌ kopus non?” ");
INSERT INTO suc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Dadi, tinumabal si Isus, “Olo buan og tinaguꞌ dia sog botad nog sinulat kituꞌ ni Muses? Olo buan og sabut nika dun?” ");
INSERT INTO suc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tinumabal og gotow koyon, “‘Sumboy potigbungon mu og glolaman mu sog Pogbayaꞌ nog ion og Diwata mu, tidu sog pusung mu, mangoy sog glimukud mu, bu sog pagas mu, bu asta sog pomikilan mu.’ Bu koduaꞌ non maꞌ nini, ‘Sumboy molalam a sog sumbaloy mu mamaꞌ da nog glolaman mu sog dili glawas mu.’” ");
INSERT INTO suc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Maꞌ long ni Isus dun, “Motud og tabal mu koyon. Dadi, inang nika og maꞌ nion koyon bagun mu malap og kotubuꞌ nog daꞌ kopus non.” ");
INSERT INTO suc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tibua, og gotow koyon minontong nog pondayan non bagun da diꞌ kosipogan. Dadi, sinakan non si Isus nog, “Sima buan og pogolongon koyon nog sumbaloy u?” ");
INSERT INTO suc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dadi, tinumabal si Isus bianan sog pononggiꞌan. Maꞌ long non dun, “Ati, ongon gondow, ongon sala kotow dinumiksun tidu sog bonua nog Jerusalem posunguꞌ sog Jeriku. Sonuk non ompanow, inapaꞌ ion nog polonglaꞌug mangka olapoy og glam nog golotaꞌ non bu linobasan ion, mangka pogbombaloy bu gonatoy sog goksid nog dalan koyon nog moglamlam na matoy. ");
INSERT INTO suc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tubus nion, kibianan nog sala kotow bolian nog bansa Hudyu. Dangan mitongow non gotow koyon, pigliow non bu dituꞌ ion minian sog dipag nog dalan. ");
INSERT INTO suc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tubus nion, ongon nosop minian dion sala kotow nog pangkat ni Lebi. Maꞌ nituꞌ dosop ininang non. Poꞌ dangan mitongow non gotow koyon, pigliow non dosop bu dituꞌ ion minian sog dipag nog dalan. ");
INSERT INTO suc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tubus nituꞌ, ongon sala kotow nog gotow Samaria minian dion. Dangan mitongow non gotow koyon, inangoy non tontongoy. Bu dangan miimotimot non og kimaꞌmaꞌan nog gotow koyon, milolat tokodoy ion dun. ");
INSERT INTO suc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Dadi, inududan non nog glana bu galak og gangol nog gotow koyon mangka non bogbodoy. Tubus nituꞌ, linulan non sog kudaꞌ non og gotow koyon mangka non pitangoy sog baloy nog pogdukonan bagun non musibaꞌ dituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Dangan migbolomaꞌ ion, tinulunan non nog duaꞌ dinari og gapuꞌ nog baloy koyon nog pogdukonan kobon non moktaluꞌ nog, ‘Usibaꞌ mu pa og gotow koni solian daꞌ u dini. Poꞌ bila mokpuliꞌ dini, boyadan ku da dianika ain og kipoktulaꞌan mu nog sin mu dia sog gotow koni.’” ");
INSERT INTO suc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tubus ni Isus suksugoy og pononggiꞌan koyon, sinakan non og polopanad nog botad koyon nog bansa Hudyu nog, “Dadi, sog pikilan mu dun, sog tolu ilan koyon, sima gidoy og milalam sog sumbaloy non?” ");
INSERT INTO suc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tinumabal gotow koyon nog, “Og gotow kituꞌ nog milolat bu tinumabang dianon.” Tinabal ion ni Isus, “Dadi, bog maꞌ nituꞌ, angoy mu poglogilingoy og piginang nog gotow kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dangan miglandan si Isus ilan nog sulangguꞌanan non koyon, minatong ilan sog gimbolayan. Ongon glibun dion ngalan non si Marta. Tinolimaꞌ non si Isus dia sog baloy non. ");
INSERT INTO suc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Bu si Marta, ongon gilug non nog glibun ngalan non si Maria. Si Maria minadap dia sog Kounutan poꞌ mokinongog ion nog pomali non. ");
INSERT INTO suc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tibua, si Marta kitopakan ion moksimpan nog ponganon. Dadi, minangoy ion dia ni Isus mangka poktaluꞌ nog, “Kounutan, potiangon nika ma og gilug u koni nog gonatan non akon, saka moligot ginang u, poꞌ ion mogingkudingkud tibua? Taluꞌ mu pa dianon nog ongoyon non pa akon tobangoy.” ");
INSERT INTO suc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dadi, tinabal ion nog Kounutan nog, “Marta, Marta, mosompun ka kosusa bu kosasow nog asaasa pa. ");
INSERT INTO suc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tibua, soginis da og bololagaꞌ. Si Maria, ininang non ain baꞌis inangon. Bu og mialap non koyon, ondaꞌidun nododaꞌ og mokalap dun dianon.” ");
INSERT INTO suc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ongon og gondow non, si Isus minangoy mogyakin. Dangan midoksuꞌ ion mogyakin, og sala kotow dia sog sulangguꞌanan non koyon mikpolani mangka poktaluꞌ dianon nog, “Kounutan, ponadoy mu pa ami mogyakin mamaꞌ ni Jan nog pionadan non og sulangguꞌanan non mogyakin.” ");
INSERT INTO suc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dadi, tinabal ilan ni Isus nog, “Bila mogyakin amu, maꞌ nini og toluꞌon niu, ‘Amaꞌ nami, pogodaban og ngalan mu poꞌ mosigda a. Bu sabaꞌ nami dun matong na dini og kopogdatuꞌ mu. ");
INSERT INTO suc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pogbogoyoy mu ami nog ponganon nami gondow gondow, ");
INSERT INTO suc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bu ompunoy mu na og dusaanan nami poꞌ ami siꞌoy, ompunan nami dosop ain og mikosalaꞌ dianami. Bu naꞌ mu ami potiangon koyubaꞌan.’” ");
INSERT INTO suc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tubus nion, long ni Isus dia sog sulangguꞌanan non koyon, “Sopolati non ongon sala kotow dianiu mangoy mogbubut molos nog bogas dituꞌ sog pakasibataꞌ non nog tongaꞌ gobi mangka ion poktaluꞌ nog, ");
INSERT INTO suc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘Poboloson u pa nog bogas poꞌ mogutom og pakasibataꞌ u nog minatong tidu sog molayuꞌ nog saka daꞌidun tanan og ompokan nami dianon.’ ");
INSERT INTO suc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Saka tinumabal og pakasibataꞌ non koyon sog dialom baloy nog, ‘Naꞌ mu ami poksosowon poꞌ mimintuꞌ ami na bu mikponulug na og gombataꞌanan nami. Dadi, ondiꞌ u na mogbuat mangka u ika bogoyoy nog pogbubuton mu koyon.’” ");
INSERT INTO suc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bu maꞌ long sop ni Isus, “Toluꞌon ku dianiu, minsan siꞌoy og pakasibataꞌ ilan ion, diꞌ ion mogbuat mogbogoy nog ponganon dianon. Tibua, sabap sog ondiꞌ ion motonop moguliꞌuliꞌ mongoni, kotogolan da mogbuat og gotow koyon bu tulunoy dianon ain og kulang non koyon. ");
INSERT INTO suc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Dadi, toluꞌon ku dianiu, pongoni amu poꞌ bogayan amu. Ponontong amu poꞌ motongow niu. Bu pokibukaꞌ amu poꞌ og bongawan bukaꞌon da dianiu. ");
INSERT INTO suc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Poꞌ simasima og mongoni, mokotabuk. Bu simasima og monontong, mokotongow. Bu simasima sop og mokibukaꞌ, og bongawan bukaꞌon dianon. ");
INSERT INTO suc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Sima gidoy dianiu, amu og gamaꞌ, nog bila mongoni dianiu og bataꞌ niu nog sodaꞌ, bogayan niu taꞌ gidoy ion nog mamak? ");
INSERT INTO suc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Otawaka bila mongoni ion nog bulinga dianiu, tulunan niu taꞌ ion nog gulasulas? Ondiꞌ, le! ");
INSERT INTO suc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Poꞌ amu, moto amu tanan mogbogoy nog ain molongas dia sog gombataꞌ niu nog saka bolodusaon amu. Labi na og Gamaꞌ niu sog glangit bogoyon non nododaꞌ og Bolakat non sog ain kituꞌ mongoni dianon.” ");
INSERT INTO suc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ongon og gondow non, binugow ni Isus og glatdiwata nog tinumosop dia sog gotow koyon nog migbod dun. Dangan minawaꞌ og glatdiwata koyon, mikopoktaluꞌ sop moglandan og gotow koyon. Dadi, og glam nog gotowanan nog mikotongow dun kisobuꞌan tokodoy. ");
INSERT INTO suc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tibua, og duma gotowanan dion miktaluꞌ ilan nog, “Saꞌan ion kopogboyaꞌan non og glatdiwataanan koyon poꞌ og bayaꞌ non koyon dia miktidu sog bayaꞌ nog kounutan nog glatdiwataanan nog si Belsibul.” ");
INSERT INTO suc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bu og duma gotowanan dion pigolapsobapan nilan si Isus. Mingoni ilan nog gingyataꞌ poꞌ tontongon nilan bog dia dotaꞌ miktidu sog Mikpongon og bayaꞌ non koyon. ");
INSERT INTO suc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tibua, kisunan ni Isus og dialom pikilan nilan. Dadi, miktaluꞌ ion nog, “Bila og sala pigdotuꞌan diꞌ moksulut, bu mokpoksusi ilan, ilan bu ilan, moglaꞌat ilan nododaꞌ. Bu mamaꞌ dosop nog sala konglangan nog mokpoksual ilan bu ilan, ombinglag ilan nododaꞌ. ");
INSERT INTO suc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Dadi, bila og pigdotuꞌan ni Kindagow diꞌ moksulut mangka poksusi ilan bu ilan, olo ma og mogandun nog kindog non? Saꞌan tinaluꞌ u ini poꞌ bila amu og moktaluꞌ, saꞌan dow mokopomugow u nog glatdiwataanan poꞌ long niu dun, binogayan u ni Belsibul nog bayaꞌ. ");
INSERT INTO suc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Dadi, bog maꞌ nituꞌ buan nog long niu dun, og bayaꞌ u dia miktidu sog bayaꞌ ni Belsibul, ain ma gidoy buan miktidu og bayaꞌ nog glaꞌayatanan niu koyon momugow dun? Dili da og glaꞌayatanan niu og mokotaksiꞌ dianiu nog diꞌ motud og poktoluꞌon niu koyon. ");
INSERT INTO suc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tibua, bila og bayaꞌ u koni momugow nog glatdiwataanan dia miktidu sog Bolakat nog Mikpongon, og maꞌana non minatong na og kopogdatuꞌ nog Mikpongon dianiu. ");
INSERT INTO suc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Bila ongon glaki nog modasig bu misukup ion nog bosi mangka non pogipatoy og baloy non, ondaꞌidun nododaꞌ og mokalap nog pogongonon non. ");
INSERT INTO suc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tibua, bila gubaton ion nog len glaki nog modasig pa dianon mangka ion dagoy, og glam nog bosianan non nog sinoligan non koyon malap dianon bu og glam nog gakod non motipot nilan pogbobohogiꞌoy.” ");
INSERT INTO suc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Dadi, maꞌ long ni Isus dun dianilan, “Simasima og diꞌ sumolabuk dianakon, binanta non akon. Bu simasima og diꞌ tumabang dianakon mokpolimud nog pigotowan ku, og maꞌana non, ion tanan og mogbinglag dun.” ");
INSERT INTO suc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Miktaluꞌ nosop si Isus nog, “Bila lumuas og glatdiwata tidu sog glawas nog gotow nog sinongonan non, ginangon non moglinsuaꞌan sog ainain nog kolukan monontong nog gulolian non. Tubus nion, bila diꞌ mokobalak, moktaluꞌ ion nog, ‘Mokpuliꞌ u dituꞌ sog bakas tiniduan ku.’ ");
INSERT INTO suc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dadi, bila matong ion dion bu motongow non og tiniduan non koyon nog molonuꞌ bu migusoyusoy, ");
INSERT INTO suc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","mongonggat pa ion nog pitu buk glatdiwataanan og duma non mogonong dion nog labi pa dianon kolaton mangka ilan sangon dia sog gotow koyon. Dadi, og doksuꞌan nog gotow koyon labi pa kolaton sog tiganaꞌ kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dangan miluksad og piktaluꞌ ni Isus koyon, ongon og sala kotow glibun sog glumpuk koyon miktaluꞌ nog mosikad dia ni Isus. Long non dun, “Mogloliag og ginaꞌ nog migbataꞌ dianika bu mikpoduduꞌ dianika.” ");
INSERT INTO suc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tinumabal si Isus nog, “Labi pa og gloliag nog ain minginongog kituꞌ nog taluꞌ nog Mikpongon bu mangka ion pokokunut dun.” ");
INSERT INTO suc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dangan dinumakol og gotowanan koyon nog mikpoglumpuk dia ni Isus, miktaluꞌ ion nog, “Og gotowanan numun koni molaton ilan nog gotow. Mongambat ilan nog gingyataꞌ, tibua, daꞌidun lual og gingyataꞌ nog potongowon dianilan lual da og gingyataꞌ paꞌali dia ni Jona, og polomolatas kituꞌ nog taluꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Poꞌ kobon nituꞌ si Jona miimung maꞌ nog tandaꞌ dia sog gotowanan sog koliwagan bonua nog Ninebe. Domikian dosop maꞌ nog Binataꞌ sog Kilawan, nog miimung dosop ion nog tandaꞌ dia sog gotowanan numun koni. ");
INSERT INTO suc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bu kobon nituꞌ, ngon og baꞌi tidu sog bonua nog Siba. Molayuꞌ siꞌoy tokodoy og piktiduan non, migapas da mangoy monginongog dituꞌ ni Datuꞌ Solomon nog kotoan non. Saka numun koni, ongon na dini motas pa dia ni Datuꞌ Solomon. Dadi, sog gondow nog polihalaꞌ nog glam nog gotowanan, og baꞌi kituꞌ mindog ion monusun nog gotowanan numun koni nog sumboy ukumon. ");
INSERT INTO suc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bu maꞌ nituꞌ dosop og gotowanan sog koliwagan bonua nog Ninebe. Sog gondow nog polihalaꞌ, mindog ilan dosop monusun sog gotowanan numun koni nog sumboy ukumon. Poꞌ ilan siꞌoy, dangan midongog nilan og gustalan ni Jona kobon nituꞌ, miglilaꞌ ilan mogdayun nog dusaanan nilan. Saka numun koni, ongon na dini og motas pa dia ni Jona. ");
INSERT INTO suc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Daꞌidun og tumutud nog suluꞌ mangka non bunioy otawaka dugbaꞌoy nog polonggana. Sugaꞌid non, dia non nododaꞌ botangoy sog motampal bagun da bila sumolod og gotowanan kodolagan ilan dun. ");
INSERT INTO suc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Domikian dosop nog maꞌ nituꞌ og mata niu, og suluꞌ dia sog glawas niu. Bila og mata niu daꞌidun og glaꞌat non, kosilowan nog dolag og tibuk nog glawas niu. Tibua, bila miglaꞌat og mata niu, og tibuk nog glawas niu molokop nog modolom. ");
INSERT INTO suc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Dadi, potubudoy niu og dolag koyon dianiu nog bagun ondiꞌ mimung nog modolom. ");
INSERT INTO suc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Poꞌ bila milokop og tibuk nog glawas niu nog dolag, daꞌidun nododaꞌ og modolom dun. Sumilow nododaꞌ og dolag non mamaꞌ nog dolag nog suluꞌ kituꞌ nog sinumilow dianiu.” ");
INSERT INTO suc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Dangan miluksad og piktaluꞌ ni Isus koyon, ongon sala kotow parasiu, inonggat non si Isus mangoy kuman dituꞌ sog baloy non. Dadi, migunut si Isus dianon. Dangan minadap si Isus kuman, ");
INSERT INTO suc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","kisobuꞌan og parasiu koyon dianon poꞌ daꞌ non unutoy og botad nog bansa Hudyu nog mangka siꞌoy kan sumboy mongugas poguna. ");
INSERT INTO suc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tibua, tinoluꞌan ion nog Kounutan nog, “Amu og parasiuanan, bila mongugas nog saguk bu pinggan, dia da sog dibabow og ugasan niu. Tibua, og pomikilan niu miponuꞌ nog gabak bu kolaton. ");
INSERT INTO suc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Gumowon amu dodaꞌ nog gotow. Daꞌ niu taꞌ kosunoy nog ion og mikpongon nog dibabow non koyon, piongon non dosop ain tinaguꞌ kituꞌ sog dialom non? ");
INSERT INTO suc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dadi, bogoy niu dia sog miskinan ain sog dialom bagun da glam non mimung molonuꞌ dianiu. ");
INSERT INTO suc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kosusasusa amu, amu og parasiuanan, poꞌ binogoy niu og kosopuluꞌ bahagiꞌ nog palapalaanan niu dia sog Mikpongon, tibua, pigbigyaꞌ niu og gotowanan bu diꞌ amu molalam dia sog Mikpongon. Ininang niu bosia ituꞌ poguna nog diꞌ niu dosop lotaꞌan og donsamaꞌ kituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kosusasusa amu, amu og parasiuanan, poꞌ bila dia amu sog baloy nog poglumpukan nog bansa Hudyu koyon, og kolegan niu dia amu pingkudoy sog gingkudan nog mokokotas nog gotow. Bu bila sog kodokolan nog gotow, kolegan niu pogodaban amu tokodoy. ");
INSERT INTO suc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Bu kosusasusa amu dosop poꞌ mamaꞌ amu nog globonganan kituꞌ nog daꞌ kilolaoy nog boyaꞌan kidogyakan nog gotowanan nog daꞌ nilan tibobaꞌoy.” ");
INSERT INTO suc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tubus nion, og sala kotow polopanad nog botad koyon nog bansa Hudyu miktaluꞌ dia ni Isus, “Polopanad, bila maꞌ nion buan og taluꞌ mu, misunuꞌ nika buan ami tompolaꞌoy.” ");
INSERT INTO suc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Dadi, tinabal ion ni Isus, “Olo pa buan dun. Poꞌ amu siꞌoy og polopanad amu nog botad nog bansa Hudyu, kosusasusa dosop og kodoksuꞌan niu poꞌ sabap sog modakol nog bonduan dia sog poꞌatan niu, kibogatan og gotowanan dun saka minsan og kolongkenge, diꞌ niu tanan potobangon mokpitang dun. ");
INSERT INTO suc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Bu kosusasusa amu dosop poꞌ pibaꞌis niu og globonganan nog polomolatasanan kituꞌ nog taluꞌ nog Mikpongon nog pimunuꞌ nog mokogulang niu kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Dadi, bianan sog kopokpobaꞌis niu nog globonganan nilan kituꞌ, motampal dianiu nog kisuꞌatan amu nog kohinangan nog mokogulanganan niu kituꞌ nog mimunuꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Dadi, saꞌan ituꞌ bianan sog kotalus non, miktaluꞌ og Mikpongon nog, ‘Popongoyon ku dianilan og polomolatasanan nog taluꞌ u bu sosuguꞌonanan ku. Tibua, og duma pomunuꞌon nilan bu og duma sop pokposokitan nilan.’ ");
INSERT INTO suc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dadi, amu og gotow numun koni, kosakan amu nog duguꞌ nog glam nog polomolatasanan nog taluꞌ nog Mikpongon nog pimunuꞌ tidu pa sog kopokpongon nog dunya. ");
INSERT INTO suc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Miktolipun sog kobunuꞌ dia ni Abel asta sog kobunuꞌ kituꞌ dia ni Sakaraya dituꞌ sog Baloy nog Poktomuyan dia sog Mikpongon sog golot nog pomolasan bu dugu kituꞌ nog mosigda. Dadi, toluꞌon ku dianiu, og gotowanan numun koni, ilan nododaꞌ og kosakan nog glam non koni. ");
INSERT INTO suc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Bu kosusasusa amu dosop, amu nog polopanad nog botad nog bansa Hudyu, poꞌ inawaꞌ niu og kunsi nog mokobukaꞌ nog kotoan bu inapaꞌ niu og dalan dun nog saka amu siꞌoy, daꞌ amu dosop gomitoy og kotoan kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pinipini ni Isus mawaꞌ dion, og parasiuanan bu og polopanadanan nog botad nog bansa Hudyu koyon, minamal ilan sumusi dianon mangka nilan ion pogolapsobapoy, ");
INSERT INTO suc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","poꞌ bagun bila ongon og motaluꞌ ni Isus nog diꞌ dumalan sog pogbotadon nog gotow Hudyu, ongon og soꞌutan nilan dianon. ");
INSERT INTO suc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dangan mimali si Isus, nginibuan nog gotowanan og mikpogbudoybudoy nog boyaꞌan kindogan nilan notanan og dumaanan nilan. Dadi, pimolian ni Isus poguna og sulangguꞌanan non nog, “Pongandam amu bagun amu ondiꞌ moit nog pokpotulin nog parasiuanan koyon, poꞌ og polomotadon nilan mokpopotongow tibua. ");
INSERT INTO suc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Poꞌ daꞌidun og pigbuni nog ondiꞌ ompotongow. Bu daꞌidun dosop og piglingod nog ondiꞌ kosunan. ");
INSERT INTO suc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bu ain og tinaluꞌ niu nog amu amu da, modongog da nog glam nog gotowanan. Bu ain og ginilom dia sog dialom nog dugu, ompulonag da dia sog kodokolan. ");
INSERT INTO suc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Glokoleanan ku, toluꞌon ku dianiu, naꞌ amu mondok nog gotowanan koyon nog glawas niu da og ombunuꞌ nilan, tubus nituꞌ daꞌidun na. ");
INSERT INTO suc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sugaꞌid non, toluꞌon ku dianiu bog sima dodaꞌ og baꞌis niu kondokan. Kondok amu sog Mikpongon. Poꞌ ion konaꞌ tibua togo bayaꞌ mongulaꞌat nog glawas niu, sugaꞌid non, minsan og glimukud niu kopogboyaꞌan non nog sigbuon non dia sog danow nog gapuy. Saꞌan kondok amu dianon. ");
INSERT INTO suc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Pikil niu poloꞌma, konaꞌ taꞌ lima buk gloksayowanan nog duaꞌ sin da golagaꞌ non, daꞌidun nododaꞌ solabuk siꞌoy dianilan, og pitiang nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Minsan og binoluan nog buk niu, kosunan nog Mikpongon bog andun dakol non. Dadi, naꞌ amu mondok, poꞌ bololagaꞌ amu pa tokodoy dia sog gloksayowanan koyon. ");
INSERT INTO suc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Toluꞌon ku dianiu, simasima og moktaluꞌ dia sog gotowanan nog ion mikokunut dianakon, toluꞌon dosop nog Binataꞌ sog Kilawan dia sog sunguꞌan nog moloikatanan nog Mikpongon nog ion og pigotowan ku. ");
INSERT INTO suc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tibua, simasima og sonsingan non akon dia sog sunguꞌan nog gotowanan, maꞌ nituꞌ dosop og inangon ku dianilan dia sog sunguꞌan nog moloikatanan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bu simasima og mantu dia sog Binataꞌ sog Kilawan bianan sog taluꞌ, kompunan da. Tibua, simasima og moglakaꞌlakaꞌ dia sog Bolakat nog Mikpongon, mologon nododaꞌ kompunoy. ");
INSERT INTO suc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Bila pitangon amu sog baloy nog poglumpukananan nog bansa Hudyu mangka amu ukumoy dion otawaka dia sog kounutananan bu duma mokotas nog gotow sabap sog kopokokunut niu dianakon, naꞌ amu mosusa bog olo og tabal niu dianilan. ");
INSERT INTO suc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Poꞌ sog tang koyon, og Bolakat nog Mikpongon og mokpanad dianiu bog olo og toluꞌon niu.” ");
INSERT INTO suc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ongon sala kotow tidu sog glumpuk koyon miktaluꞌ dia ni Isus nog, “Polopanad, botaꞌbotaꞌoy nika pa tumaluꞌ dia sog gilug u nog bohogiꞌan non na akon nog pusakaꞌ nami.” ");
INSERT INTO suc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Dadi, tinabal ion ni Isus nog, “Le, daꞌidun og bayaꞌ u dun poꞌ konaꞌ u ginang og momasad nog maꞌ nion koyon.” ");
INSERT INTO suc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mangka poktaluꞌ si Isus dia sog kodokolan nog gotowanan koyon nog, “Pongmohilat amu bu pokpotubud amu bagun amu ondiꞌ motaban nog gininisan nog gabak. Poꞌ og kotubuꞌ nog gotow daꞌ dia poktidu sog kodakol nog daya non.” ");
INSERT INTO suc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tubus nion, sinuksugan non ilan nog solabuk pononggiꞌan nog, “Ongon sala kotow doyahan nog sinongkuꞌan. ");
INSERT INTO suc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bu mikpikilpikil gotow koyon bog olo og pondayan non, poꞌ kulang og toguꞌan non nog songkuꞌ non koyon. ");
INSERT INTO suc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dadi, mipikil non nog loglagon non og dan komaliganan non koyon mangka pogimung nog mosolag nog komaliganan bagun mugat dituꞌ og songkuꞌ non koyon asta pa og duma pogongonon non. ");
INSERT INTO suc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bu long non dun dia sog pikilan non, ‘Ondaꞌ na pogondaꞌon ku minsan sanu ton, bu daꞌ na lual ginangon ku lumual sog kuman, moginuminum, bu mogloliag.’ ");
INSERT INTO suc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Tibua, maꞌ long nog Mikpongon dianon nog, ‘Gumowon ka nog gotow! Matong na gumul mu gobi koni. Dadi, sima noma og mokakod nog piksimpan mu koyon dia sog kotubuꞌ mu?’” ");
INSERT INTO suc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Dadi, long ni Isus dun dia sog gotowanan koyon, “Maꞌ nituꞌ og bianan nog gotow nog ain og mogomud nog daya non nog dia da sog glawas non dini sog kilawan, tibua, daꞌidun og daya non sog motaan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dadi, miktaluꞌ si Isus dia sog sulangguꞌanan non koyon nog, “Toluꞌon ku dianiu, nog naꞌ amu mosusa paꞌali sog kotubuꞌ niu bog olo og ponganon niu, bu paꞌali sog glawas niu bog olo og koponapot niu. ");
INSERT INTO suc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Poꞌ og kotubuꞌ, labi pa dia sog kokan. Bu og glawas niu koyon, labi pa dia sog ponopoton. ");
INSERT INTO suc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tontong niu poloꞌma og guakanan koyon. Diꞌ ilan tanan momula otawaka gumani. Bu daꞌidun tanan og ponginoguꞌan nilan somoꞌ ngon og songkuꞌ nilan. Tibua, daꞌ ilan da potiangoy nog Mikpongon. Bu bololagaꞌ amu pa tokodoy dia sog manukmanukanan koyon. ");
INSERT INTO suc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Poꞌ sima buan dianiu nog bianan sog susaan non, kosukpatan non og kopayat nog kotubuꞌ non? ");
INSERT INTO suc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bila diꞌ niu ma minang og maꞌ nion koyon nog molomu da bosia, iduma mosusa amu ma sog duma kituꞌ? ");
INSERT INTO suc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tontong niu poloꞌma og kotubuꞌ nog bulakbulakanan koyon. Daꞌ ilan tanan ponukat otawaka pongabol nog bagun ilan mokopoglogdoy. Tibua, toluꞌon ku dianiu, nog minsan si Datuꞌ Solomon kobon nituꞌ nog doyahan tokodoy, daꞌ pa sibon pokoponapot nog mokolongas maꞌ nog bayuꞌbayuꞌ nog bulakbulakanan koyon. ");
INSERT INTO suc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bila maꞌ nituꞌ ma og ginandun nog Mikpongon og koponapot non dia sog sigbotanan nog mitongow ta numun koni nog bolomaꞌ imungon nog tagun, labi pa dituꞌ og kopogusibaꞌ nog Mikpongon dianiu. Kulang dodaꞌ og salig niu. ");
INSERT INTO suc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dadi, naꞌ niu potigbungon og pikilan niu dia sog kokan niu bu ginumon niu. Naꞌ amu mosusa dun. ");
INSERT INTO suc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Poꞌ og gotowanan koyon nog daꞌ poktamuy dia sog Mikpongon, koyon og pigopasan nilan. Tibua, og Gamaꞌ niu sog glangit, kosunan non nog sumboy ngon nododaꞌ dianiu dun. ");
INSERT INTO suc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sugaꞌid non, pogopasoy niu og kopogdatuꞌ nog Mikpongon dianiu poꞌ ponoꞌuban non da amu dun.” ");
INSERT INTO suc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Bu maꞌ long ni Isus dun dia sog sulangguꞌanan non koyon nog, “Naꞌ amu mondok mikaꞌan amu siꞌoy, poꞌ og Gamaꞌ niu sog glangit, kisuꞌatan ion mogbogoy dianiu nog glam non nog dia sog pigdotuꞌan non. ");
INSERT INTO suc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dadi, poksaluy niu og pogongonon niu mangka niu bogoy og saluy non dia sog miskinananan. Poꞌ bila maꞌ nituꞌ og ginang niu, mokalap amu nog daya kituꞌ nog ondiꞌ moglaꞌat. Mamaꞌ amu mikomud nog daya kituꞌ sog glangit nog diꞌ motipot, bu diꞌ kongayan nog polonakow, bu diꞌ kokoton nog gangnay. ");
INSERT INTO suc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Poꞌ minsan ain og daya niu, dituꞌ dosop og pomikilan niu. ");
INSERT INTO suc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Dadi, poksimpan amu, bu poglogdoy amu nog mahatul, bu poligaꞌ niu somul non og suluꞌ niu! ");
INSERT INTO suc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ilingoy niu mamaꞌ nog sosoligananan kituꞌ nog migbagad ilan nog kopokpuliꞌ nog kounutan nilan nog miktidu dituꞌ sog kaing bagun nilan da kobukaꞌan mogdayun og kounutan nilan kituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Poꞌ mogloliag og sosoligananan koyon nog kodotongan ilan nog kounutan nog totanud ilan pa bu misimpan ilan nog kodatong non koyon. Poꞌ toluꞌon ku dianiu nog imungon non og dili glawas non maꞌ nog sosoligan mangka non ilan pingkudoy dia sog glomisahan, mangka non ilan poktologadoy. ");
INSERT INTO suc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bu kuntungan ilan bila misimpan ilan sog kodatong nog kounutan nilan minsan siꞌoy og tongaꞌ gobi otawaka daliꞌondow. ");
INSERT INTO suc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Sabut niu og poktoluꞌon ku koni. Somoꞌ kisunan nog gapuꞌ nog baloy og tang nog kangoy nog polonakow dia sog baloy non, oyanan non nododaꞌ bagun da ondiꞌ ion mokosolod. ");
INSERT INTO suc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Bu amu siꞌoy, sumboy moksimpan amu dosop poꞌ og Binataꞌ sog Kilawan matong sog tang nog daꞌ niu dodomaoy.” ");
INSERT INTO suc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tubus nion, miksak si Piter dia ni Isus, “Kounutan, ami taꞌ tibua og tinoluꞌan mu nog pononggiꞌan mu koyon otawaka sinunuꞌ mu taꞌ og glam non?” ");
INSERT INTO suc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tinumabal si Isus nog, “Og sosoligan nog mokokunut bu moto momikil, ion og guokilan nog kounutan non nog bayaꞌ mogokbit bu mogusibaꞌ dia sog pakasi sosoligananan non sog tang nog ngon kobolanon nilan dun. ");
INSERT INTO suc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kuntungan og sosoligan kituꞌ nog kidotongan nog kounutan nog sonuk non moginang nog dinondag kituꞌ moginang dianon. ");
INSERT INTO suc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Toluꞌon ku dianiu, og sosoligan koyon, uokilan nododaꞌ ion nog bayaꞌ mogokbit sog glam nog gakod nog kounutan non koyon. ");
INSERT INTO suc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tibua, bila mamaꞌ nog sosoligan kituꞌ nog moktaluꞌ sog dialom pikilan non, ‘E! Mobon pa datong og kounutan ku,’ mangka non ponglokposoy og pakasi sosoligananan non nog glibun laki mangka ion poglokanlokan bu poginuminum asta molangu, ");
INSERT INTO suc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kotokowan ion nog matong og kounutan non sog gondow nog daꞌ non bibolaꞌoy, bu sog tang nog daꞌ non dodomaoy. Pogoktadon nododaꞌ nog kounutan non koyon mangka non ion pompuꞌoy mosinsa sog gotowanan kituꞌ nog diꞌ tumud.” ");
INSERT INTO suc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Maꞌ long sop ni Isus, “Ain og sosoligan kituꞌ nog kisunan non bog olo og glegan nog kounutan non, saka daꞌ poksimpan bu daꞌ non ponglenglengoy moginang, podokolon nododaꞌ og badas dianon. ");
INSERT INTO suc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tibua, og sosoligan kituꞌ nog diꞌ non sunan og glegan nog kounutan non, saka mokinang nog ginang kituꞌ nog koposokitan dun, bodason siꞌoy mikaꞌan da. Poꞌ bila og gotow binogayan nog modakol, pongombatan dosop ion nog modakol. Bu og gotow nog inuokilan nog mosolag nog bayaꞌ, mosolag dosop og dodomaan dianon.” ");
INSERT INTO suc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tubus nion, miktaluꞌ nosop si Isus. Long non dun, “Minangoy u mokpitang nog gapuy dini sog dunya. Bu sabaꞌ u dun tutudan na. ");
INSERT INTO suc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tibua, mangka siꞌoy datong, ongon pa poguna og bunyag nog kobianan ku. Ombogat pikilan ku solian nog daꞌ u pa kobianoy. ");
INSERT INTO suc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Baluꞌ niu dun, minangoy u taꞌ dini mokpitang nog gomigus sog dunya? Konaꞌ. Sugaꞌid non, og gotowanan mimung nog diꞌ ilan mokpoksulut dun. ");
INSERT INTO suc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Moktidu sog numun kituꞌ, ongon og lima kotow sog sala konglangan ondiꞌ moksulut. Og duaꞌ kotow diꞌ sumulut sog tolu kotow bu og tolu kotow diꞌ sumulut sog duaꞌ kotow. ");
INSERT INTO suc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bu og gamaꞌ bu og gombataꞌ non nog glaki, ondiꞌ ilan dosop moksulut. Bu og ginaꞌ ilan nog gombataꞌanan non nog glibun, diꞌ ilan dosop moksulut. Bu ongon dosop og kolibunanan nog ondiꞌ ilan moksulut nog ponugangan nilan nog glibun.” ");
INSERT INTO suc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tubus nituꞌ, miktaluꞌ si Isus dia sog gotowanan nog, “Amu koyon, bila motongow niu nog mongitoman sog bukid, kosunan niu nog mogdupiꞌ posunguꞌ, bu mogdupiꞌ doma. ");
INSERT INTO suc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Bu bila sop moyup gutalaꞌ, moktaluꞌ amu dosop nog posunguꞌ na mokpodos, bu motuman doma. ");
INSERT INTO suc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Amu og gotow nog sagya tibua mokpopotongow! Kosunan niu mogustal og gindanan sog glangit bu sog glupaꞌan, saka diꞌ niu ma sunan mogustal og mitongow niu numun kituꞌ! ");
INSERT INTO suc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Iduma ondiꞌ niu ma inangon og dili pikilan niu kituꞌ nog ombaꞌis inangon? ");
INSERT INTO suc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Bila mikosalaꞌ a sog pakasi mu saka pitangon non ika dituꞌ sog gukum, dia amu pa sog dalan, sumboy pogopasan mu na nog moglokopia amu. Poꞌ bila muakil non na ika sog gukum, og gukum og muakil dianika sog pogaid nog kolobusuan. Tubus nituꞌ, ion na kumolobusu dianika. ");
INSERT INTO suc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Toluꞌon ku dianika, ondiꞌ a nododaꞌ mokoluas bog diꞌ mu da koboyadan og glam nog kosolaꞌan mu.” ");
INSERT INTO suc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sog tang koyon, ongon gotowanan miguksug dia ni Isus paꞌali dia sog gotow Galilianan nog pimunuꞌ ni Pilatu (og gubernador dia sog bonua nog Judia) sonuk nilan momalas dituꞌ sog Baloy nog Poktomuyan dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tinumabal si Isus nog, “Olo ma og pikilan niu dun? Saꞌan maꞌ nituꞌ og kibianbianan nilan poꞌ bolodusaon ilan potaꞌ gabaꞌ nog duma gotow Galilianan? ");
INSERT INTO suc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Toluꞌon ku dianiu, ondiꞌ! Poꞌ tontal da diꞌ amu moglilaꞌ nog dusaanan niu, matoy amu dosop mamaꞌ nilan. ");
INSERT INTO suc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bu kituꞌ sop buan og sopuluꞌ bu walu kotow kituꞌ nog mikpomatoy kobal nog kibuksakan ilan nog baloy nog molawa dituꞌ sog Siloam. Saꞌan maꞌ nituꞌ og kibianbianan nilan poꞌ bolodusaon ilan potaꞌ gidoy gabaꞌ nog duma gotowanan dituꞌ sog Jerusalem? ");
INSERT INTO suc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ondiꞌ dosop! Poꞌ toluꞌon ku dianiu, tontal da ondiꞌ amu moglilaꞌ nog dusaanan niu, amu siꞌoy matoy dosop maꞌ nilan.” ");
INSERT INTO suc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tubus nituꞌ, sinuksugan non ilan nog solabuk pononggiꞌan. “Ongon sala kotow mimula nog kayu dia sog binalan non, ngalan non igera. Ongon gondow non, inangoy non tontongoy bog migbunga notaꞌ og pomulan non koyon. Saka ondaꞌ pa pogbunga. ");
INSERT INTO suc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dadi, sinakan non og polongusibaꞌ nog pomulan non koyon nog, ‘Iduma? Olo gidoy og migandun nog kayu koyon nog daꞌ ma sibon pogbunga saka midopot na tolu ton? Pigdodomaan ku bosia nog mogbunga na.’ Dadi, dinondag non monagaꞌ dia sog migusibaꞌ koyon dun, poꞌ bagun da diꞌ mogasta og glupaꞌ nog pigindogan nog kayu koyon. ");
INSERT INTO suc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tibua, tinumabal og polongusibaꞌ koyon nog, ‘Diꞌ ta pa sokaliꞌ ponogaꞌon poꞌ usibaꞌon ku pa soton siꞌoy bu toguꞌan ku nog ponglombuꞌ nog pomulan bagun mogbunga. ");
INSERT INTO suc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tibua, bila matong sog len ton diꞌ pa mogbunga, ombaꞌis na ponogaꞌon.’” ");
INSERT INTO suc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sog tang nog Gondow nog Pogulali, mikpanad si Isus dituꞌ sog solabuk baloy nog poglumpukan nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ongon sala kotow glibun dion nog diꞌ mokodag solod nog sopuluꞌ bu walu ton poꞌ kobal nog glatdiwata. Dadi, migboktut tanan ion dun nog boyaꞌan ondiꞌ non mologdong og glawas non. ");
INSERT INTO suc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Dangan mitongow ion ni Isus, sinabi non ion nog mokpolani pa dianon mangka non ion toluꞌoy nog, “Dadaꞌ, kiuliꞌan na og diꞌ mu koyon kokodag.” ");
INSERT INTO suc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dunut dinoponan non og glibun koyon, bu sododuꞌun milogdong non na og boktut non. Dadi, og glibun koyon miksanglit dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tibua, og kounutan kituꞌ sog baloy nog poglumpukan nilan koyon, miglolingit ion poꞌ ngon pikodag ni Isus saka og Gondow nog Pogulali. Dadi, tinaluꞌ non dia sog gotowanan koyon nog, “Sog pitu ondow, binogayan ita gonom ondow moginang nog ginang ta. Bu bila moleg amu kumodag angoy amu dini sog solod nog gonom ondow koyon, konaꞌ sog Gondow nog Pogulali!” ");
INSERT INTO suc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tibua, tinabal ion ni Isus nog, “Amu, mokpopotongow amu tibua! Minsan amu, ongoyon niu da ubadoy og kudaꞌ niu otawaka sapiꞌ niu mangka niu pinumoy sog Gondow nog Pogulali. ");
INSERT INTO suc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Dadi, minsan siꞌoy og Gondow nog Pogulali, ondiꞌ taꞌ gidoy mogusoy nog tobangan og glibun koni nog ion og pangkat ni Apuꞌ Abraham nog pisinsa ni Kindagow sog solod nog sopuluꞌ bu walu ton?” ");
INSERT INTO suc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Dadi, kisipogan og glam nog sinumusi koyon dianon dion. Tibua, og duma gotowanan dion migloliag ilan sog glam nog kohinangan ni Isus koyon nog kosobuꞌsobuꞌ. ");
INSERT INTO suc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tubus nituꞌ, miksak si Isus nog, “Olo bayuꞌbayuꞌ nog pigdotuꞌan nog Mikpongon bu olo kopononggiꞌan ku dun? ");
INSERT INTO suc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dia u kopononggiꞌ sog bataꞌbataꞌ longow nog pimula nog gotow dia sog binalan non, nog dangan tinumubuꞌ miimung nog kayu boyaꞌan og pangaanan non pogopunan tanan nog manukmanukanan.” ");
INSERT INTO suc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Bu miktaluꞌ nosop si Isus nog, “Ain pa kopononggiꞌ og pigdotuꞌan nog Mikpongon? ");
INSERT INTO suc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ompononggiꞌ u dosop dia sog mikaꞌan nog pokpotulin nog pan nog linimbual nog sala kotow glibun dia sog pitu gantang tapung asta miksagot ilan na nog tapung koyon boyaꞌan tinumulin dun.” ");
INSERT INTO suc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Solian ni Isus ompanow posunguꞌ sog Jerusalem, minian ion dia sog modakol nog bonuaanan bu gimbolayan mokpanad dia sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sintak nion, ongon sala kotow miksak dia ni Isus nog, “Kounutan, mikaꞌan taꞌ da og gotowanan nog mogawon tidu sog dusa nilan?” ");
INSERT INTO suc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Tinumabal si Isus nog, “Pogapas amu tokodoy sumolod sog mosikut nog bongawan poꞌ toluꞌon ku dianiu nog modakol og sumuloy sumolod, tibua, ondiꞌ ilan mokosolod. ");
INSERT INTO suc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Poꞌ bila migbuat bu pinintuꞌ na nog gapuꞌ nog baloy koyon og bongawan non koyon, matag amu tibua mogindog sog glowasan mokibukaꞌ dianon nog ondiꞌ non amu bukaꞌan poꞌ long non dun, ondiꞌ non amu kilolaan bu ondiꞌ non kosunan bog ain amu mikpoktidu. ");
INSERT INTO suc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dadi, tumabal amu nog, ‘Kounutan, migadap ita potanan kuman bu minum bu mikpanad a pa tanan dituꞌ sog bonua nami!’ ");
INSERT INTO suc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tibua, tobalon non amu nog ondiꞌ non amu kilolaan bu ondiꞌ non kosunan bog ain amu mikpoktidu. Sugaꞌid non, toluꞌan non amu nog, ‘Pokpolayuꞌ amu dianakon, glam niu koyon nog bolodusaon!’” ");
INSERT INTO suc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Bu long sop ni Isus dun, “Moglulad amu bu mongolongot og ngisianan niu sog gondow kituꞌ nog motongow niu dion si Apuꞌ Abraham, si Apuꞌ Isak, si Apuꞌ Jakub, bu og glam nog polomolatasanan nog taluꞌ nog Mikpongon nog dituꞌ ilan sog pigdotuꞌan nog Mikpongon. Saka amu, dituꞌ amu sog glowasan. ");
INSERT INTO suc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bu modakol dosop og gotowanan nog mikpoktidu sog pat pigyulu nog dunya madap kuman dituꞌ sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bu toluꞌon ku dianiu nog ongon gotowanan nog mibinayaꞌ nog mimung mokuna ilan, bu ongon sop og mikuna nog mimung ombinayaꞌ ilan.” ");
INSERT INTO suc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sog tang koyon, ongon og parasiuanan minangoy dia ni Isus mangka ilan poktaluꞌ nog, “Sumboy mawaꞌ a dini sog bonua koni poꞌ si Datuꞌ Herod moleg munuꞌ dianika.” ");
INSERT INTO suc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tibua, tinumabal si Isus nog, “Angoy niu taluꞌ dia sog gotow kituꞌ nog modolut nog akon, momugow nododaꞌ nog glatdiwataanan bu pokodagon ku ain diꞌ kituꞌ mokokodag gondow koni bu bolomaꞌ. Bu sog kotoluondow non, modopot u na og pogdopoton ku kituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Saꞌan sumboy nododaꞌ mogdayun u gondow koni, bu bolomaꞌ, asta dinglag, poꞌ sumboy dituꞌ nododaꞌ bunuꞌoy og polomolatas nog Mikpongon sog Jerusalem.” ");
INSERT INTO suc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Maꞌ long sop ni Isus dun, “O Jerusalem, Jerusalem, og gotowanan mu, pimunuꞌ nilan og polomolatasanan nog taluꞌ nog Mikpongon. Bu pimatu nilan ain og dinondag non mangoy dion nika. Miobon u na bosia moleg lumumpuk nog gotowanan mu bagun ku ilan musibaꞌ, mamaꞌ nog dolukan nog dugbaꞌan non nog gokpak non og gititanan non. Tibua, ompok ilan dun. ");
INSERT INTO suc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tontong mu numun kituꞌ, og baloy mu tinolikudan na nog Mikpongon. Toluꞌon ku dianika nog ondiꞌ mu nododaꞌ akon motongow mokpuliꞌ asta matong gondow kituꞌ nog mokpoktaluꞌ og gotowanan mu nog, ‘Pipia og minangoy dini bianan sog ngalan nog Mikpongon!’” ");
INSERT INTO suc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sog tang nog Gondow nog Pogulali, si Isus inonggat nog sala kotow nog motas sog parasiuanan mangoy kuman sog baloy non. Bu ongon gotowanan dion, piktimaꞌanan nilan mahatul og poginangon ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bu sog sunguꞌan non koyon, ongon sala kotow dion nog diꞌ mokodag nog mimagaꞌ og botis bu komot non. ");
INSERT INTO suc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Dadi, miksak si Isus dia sog polopanadanan koyon nog botad nog bansa Hudyu bu sog parasiuanan koyon dion nog, “Dia sog Botad nog sinulat, pigondiꞌan ita taꞌ momulung bila og Gondow nog Pogulali?” ");
INSERT INTO suc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tibua, daꞌ pogonekonek og gotowanan koyon. Dadi, pigoidan ni Isus og gotow koyon nog diꞌ mokodag mangka non poboiꞌoy mosakit non bu dondagoy ompanow. ");
INSERT INTO suc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tubus nion, miksak si Isus dianilan, “Bila gidoy ongon og bataꞌ niu otawaka potubuꞌon niu molabuꞌ sog gluang nog modalom, saka motang sog Gondow nog Pogulali, ondiꞌ niu taꞌ pogdoyunan tumabang?” ");
INSERT INTO suc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Og gotowanan koyon ondaꞌ nosop pokotabal. ");
INSERT INTO suc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Dangan mitongow ni Isus og gotowanan koyon dion nog migunauna ilan mingkud dia sog gingkudan nog mokotas nog gotow, pimolian non ilan bianan sog pononggiꞌan. ");
INSERT INTO suc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Long non dun, “Bila pinosunan amu nog kaing, saka matong amu na dia sog baloy koyon nog piglokologyaꞌan, naꞌ amu mogunauna mingkud dia sog gingkudan nog mokokotas nog gotow. Poꞌ bila gomonsunoy ongon pa lumual gotow matong nog motas pa dianiu, ");
INSERT INTO suc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","og miglokologyaꞌan koyon nog mikposabut sog duaꞌ amu, mangoy ion moktaluꞌ dianiu nog, ‘Pingkudon ta pole og gotow konia sog pigingkudan mu koyon.’ Dadi, kosipogan amu dun bu dia amu pingkudoy sog gingkudan nog sempelsempel nog gingkudan. ");
INSERT INTO suc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sugaꞌid non, bila posobutan amu nog kaing, dia amu pongingkud sog sempelsempel nog gingkudan bagun amu ongoyon nog miglokologyaꞌan koyon mangka non amu toluꞌoy, ‘Le, dinian ka ingkud sog gingkudan nog mokokotas nog gotow.’ Dadi, kolele kosipogan amu dun, pogodaban amu tanan nog gotowanan dun. ");
INSERT INTO suc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Poꞌ ain og mokpotas nog dili glawas non, pobobaꞌon nog Mikpongon. Tibua, ain og gotow nog pobobaꞌon non og bolotabat non, potason ion.” ");
INSERT INTO suc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tubus nituꞌ, tinaluꞌ ni Isus dia sog parasiu koyon nog migonggat dianon nog, “Bila mongonggat a moktasondowan otawaka moglobungan nog ain tibua og pakasibataꞌanan mu, otawaka og pigilugananan mu, bu og pigoloan mu, otawaka pongdoyahan kituꞌ nog sumbaloyanan mu, bila maꞌ nion og ginangon mu, onggaton nilan dosop ika mangoy kuman sog baloy nilan. Bu kosuliꞌan nilan dosop ika nog miinang mu koyon dianilan. ");
INSERT INTO suc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tibua, bila moglokologyaꞌan ka, og posunan mu ain og miskinananan, bu og dadayanan, bu og pingkaꞌanan, bu og butaanan kituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bu popiaon ka nog Mikpongon dun. Poꞌ minsan siꞌoy diꞌ nilan ika kotumbasan, kotumbasan ka da bog matong gondow kituꞌ nog potubuꞌon puliꞌ nog Mikpongon og gotowanan kituꞌ nog midulus.” ");
INSERT INTO suc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Dangan midongog nog sala kotow gadap nilan koyon kuman, miktaluꞌ ion dia ni Isus nog, “Kuntungan og gotowanan koyon nog mokadap dia sog kologyaꞌan nog Mikpongon dituꞌ sog pigdotuꞌan non.” ");
INSERT INTO suc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tinumabal si Isus nog, “Ongon sala kotow og miksimpan nog mosolag nog kologyaꞌan bu modakol og pimosunan non nog gotow. ");
INSERT INTO suc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Dangan minatong na og gondow nog kologyaꞌan non koyon, dinondag non og kisonggulan non nog ongoyon na og gotowanan kituꞌ nog pimosunan non mangoy moktaluꞌ nog misimpan na og binolokan. Dadi, mipanow og kisonggulan non koyon. ");
INSERT INTO suc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tibua, dangan pigobitan nog kisonggulan koyon dia sog gotowanan og taluꞌ nog kounutan non koyon, glam nilan, minontong ilan nog daꞌawa nilan nog maꞌ long nog sala kotow koyon dun, ‘Ongon misaluy u nog glupaꞌ nog sumboy ongoyon ku pa tontongoy. Dadi, taluꞌ mu pa dituꞌ non nog diꞌ u da mokangoy dituꞌ.’ ");
INSERT INTO suc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tubus nion, miktaluꞌ sop og sala kotow koyon nog, ‘Ongoyon ku pa suloyoy mokpoguyud nog bagyaꞌ og sopuluꞌ buk sapiꞌ koyon nog sinaluy u bogu koni. Dadi, taluꞌ mu pa dituꞌ non nog diꞌ u da mokangoy dituꞌ.’ ");
INSERT INTO suc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Bu ngon dosop og miktaluꞌ nog, ‘Ondiꞌ u nododaꞌ mokotuaꞌ sog kologyaꞌan koyon poꞌ bogu ami da koingoy nog duoy u.’ ");
INSERT INTO suc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Dadi, og kisonggulan koyon minuliꞌ bu mangka non pogobitoy dia sog kounutan non koyon og glam nog daꞌawaanan nog gotowanan kituꞌ. “Dangan midongog nog gapuꞌ nog baloy koyon og gustalan nog kisonggulan non koyon, miglolingit ion dun. Dadi, dinondag non nosop og kisonggulan non koyon mogdaliꞌ mangoy sog dalananan bu sog ain mokoliliꞌ kituꞌ sog koliwagan bonua koyon bu oitoy dini og sosuku motongow non nog miskinan, og daday, og buta, bu og pingkaꞌ. ");
INSERT INTO suc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Dangan minatong ion tidu mangoy nog gotowanan kituꞌ, miktaluꞌ ion nog, ‘Kounutan, dini na og dinondag nika kituꞌ nog ongoyon ku. Tibua, modakol pa og samaꞌ gingkudananan nog daꞌ kingkudoy nog gotow.’ ");
INSERT INTO suc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Dadi, dinondag non nosop og kisonggulan non koyon nog, ‘Panow a pa mokpuliꞌ mangka a angoy dituꞌ sog dalananan bu kobukidan, mangka mu togol monggat og gotowanan nog molumpak nika bagun omponuꞌ nog gotow og baloy u koni. ");
INSERT INTO suc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Poꞌ toluꞌon ku dianiu nog og gotowanan kituꞌ nog pisobutan ku moguna, daꞌidun minsan sala kotow siꞌoy dianilan, og mokinam nog piksimpan ku koni nog ponganon!’” ");
INSERT INTO suc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tubus nion, dangan mipanow si Isus, landuꞌ kodakol nog gotowanan og migunut dianon. Dadi, sinunguꞌ non ilan mangka ion poktaluꞌ nog, ");
INSERT INTO suc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ain og moleg mogunut dianakon, ondiꞌ ion mimung nog sulangguꞌ u taman da ondiꞌ non potongowon og glolaman non dianakon nog labilabi pa sog glolaman non sog mokogulang non, bu sog duoy non, bu sog gombataꞌ non, bu sog pigilugan non, bu minsan sog dili glawas non. ");
INSERT INTO suc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Bu ain ondiꞌ mokpisan nog kudus non bu pogunut dianakon, diꞌ dosop mimung nog sulangguꞌ u. ");
INSERT INTO suc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Poꞌ sopolati non, ongon dianiu og moleg mokpasok nog molawa nog baloy. Mokpikilpikil pa poguna ion mangka non gontaꞌoy bog andun og golagaꞌ non, bagun non kosunan bog andun og golagaꞌ nog baloy non koyon bila modoksuꞌ. ");
INSERT INTO suc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Poꞌ bila posokon non og baloy non koyon saka diꞌ non modoksuꞌ, pogundaundaan ion nog gotowanan ain og mokotongow nog ganglag non koyon. ");
INSERT INTO suc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kobon nilan moktaluꞌ nog, ‘Og gotow koni, gumaꞌusgaꞌus pa mokpasok nog baloy non saka diꞌ non dosop ombaꞌug.’ ");
INSERT INTO suc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Otawaka mamaꞌ dosop nog datuꞌ nog posunguꞌ ilan mogbunuꞌ nog pakasi datuꞌ non. Og sala kotow datuꞌ koyon sopuluꞌ ngibu da og dakol nog sundalu non. Saka og pakasi datuꞌ non sop koyon duaꞌ puluꞌ ngibu dakol nog dianon. Mangka siꞌoy antu mogbunuꞌ og sala kotow datuꞌ koyon, mokpikilpikil pa ion poguna bog mokantu dotaꞌ og sundaluanan non koyon nog sopuluꞌ ngibu da dakol non. ");
INSERT INTO suc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bu bila mogantaꞌ non nog ondiꞌ dodaꞌ ion mokantu mogbunuꞌ, sumboy ongon og dondagon non lumumpak dia sog pakasi datuꞌ non koyon, mangoy mongoni nog kopoglogomigus nog dituꞌ ilan pa sog molayuꞌ. ");
INSERT INTO suc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Domikian dosop maꞌ nituꞌ amu, bila ondiꞌ niu bolongon og glam nog dili dianiu, ondiꞌ amu dosop mimung nog sulangguꞌ u. ");
INSERT INTO suc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Og masin, ombaꞌis. Tibua, bila molubas na og nanam non, daꞌidun nododaꞌ og pondayan dun bagun masin pa mokpuliꞌ. ");
INSERT INTO suc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dadi, daꞌidun na og potugyuan dun minsan siꞌoy sog glupaꞌ, lual da lobakon na. Dadi, ain togo tolinga, sumboy pokinongogan non og piktaluꞌ u koni!” ");
INSERT INTO suc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ongon gondow non, sonuk ni Isus momali, modakol og polongabatanan nog buis bu og gotowanan kituꞌ nog iningolanan nilan nog bolodusaon, miglumpuk ilan monginongog nog gustalan ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tibua, og parasiuanan bu polopanadanan nog botad nog bansa Hudyu, mikpokumodumod ilan nog, “Og gotow koni tumolimaꞌ ma nog gotow nog bolodusaon bu madap ma kuman dianilan!” ");
INSERT INTO suc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dadi, miktaluꞌ si Isus dianilan binianan sog pononggiꞌan. ");
INSERT INTO suc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sopolati non, og sala kotow dianiu, ngon og bilibilianan non sogatus kodakol, saka mibolong og solabuk dun. Olo ma gidoy og ginangon non? Gonatan non nododaꞌ og siam puluꞌ bu siam bilibilianan non koyon sog pongoksaban nilan mangka non ponontongoy og solabuk bilibili non kituꞌ asta motongow non. ");
INSERT INTO suc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bu bila mitongow non na, loliagon nododaꞌ tokodoy ion dun ");
INSERT INTO suc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","mangka non bolungoy muliꞌ. Bila matong ion sog baloy, polumpukon non og pakasibataꞌanan non bu sumbaloyanan non mangka ion poktaluꞌ dianilan nog, ‘Moksamasama ita niu mogloliag poꞌ mitongow u na og bilibili u kituꞌ nog mibolong.’ ");
INSERT INTO suc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Toluꞌon ku dianiu, domikian dosop nog maꞌ nituꞌ landuꞌ og daꞌdaꞌan dituꞌ sog glangit sabap sog sala kotow og bolodusaon moglilaꞌ nog dusa non, gabaꞌ nog siam puluꞌ bu siam kotow kituꞌ nog baluꞌ nilan midulus ilan na nog daꞌidun na balan nilan moglilaꞌ nog dusa nilan.” ");
INSERT INTO suc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Tubus nion, miguksug nosop si Isus nog len pononggiꞌan nog, “Ongon og sala kotow glibun nog togo sin nog sopuluꞌ lad, mibolong og solad sin dun. Olo ma gidoy og ginangon nog glibun koyon? Tumutud ion nog suluꞌ mangka non siligoy og baloy non koyon bu ponontongoy mahatul og sin non koyon asta motongow non. ");
INSERT INTO suc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bu bila mitongow non na, mangka non polumpukoy og pakasibataꞌanan non bu sumbaloyanan non mangka ion poktaluꞌ dianilan nog, ‘Moksamasama ita niu mogloliag poꞌ mitongow u na og sin ku kituꞌ nog mibolong.’ ");
INSERT INTO suc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Toluꞌon ku dianiu nog, domikian dosop nog maꞌ nituꞌ ongon daꞌdaꞌan dia sog sunguꞌan nog moloikatanan nog Mikpongon nog sala kotow bolodusaon og moglilaꞌ nog dusa non.” ");
INSERT INTO suc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tubus nion, miguksug nosop si Isus nog len pononggiꞌan nog, “Ongon gotow nog togo bataꞌ duaꞌ kotow nog lunsan laki. ");
INSERT INTO suc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ongon gondow non, og kongudan koyon, pingambat non bahagiꞌ non dia sog gamaꞌ non. Dadi, pigbahagiꞌ nog gamaꞌ non koyon dianilan og pogongonon nilan. ");
INSERT INTO suc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Daꞌ ion kobon, og kongudan koyon piksaluy non og glam nog bahagiꞌ non koyon mangka ion awaꞌ. Minangoy ion dituꞌ sog molayuꞌ nog bonua mangka non solapoy moktulaꞌ og sin non koyon. ");
INSERT INTO suc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Dangan mitipot non na poktulaꞌoy og glam nog sin non koyon, og bonua koyon nog dinotongan non, misugat nog minit nog gutom. Dadi, kilogonan ion. ");
INSERT INTO suc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Migbubut ion mogonong dia sog sala kotow sog bonua koyon. Dadi, dinondag ion mangoy dituꞌ sog kudal nog babuyanan. Bu og ginangon non dituꞌ og mokpokanpokan nog babuyanan koyon. ");
INSERT INTO suc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kobal nog kigutoman ion tokodoy, moleg na tanan ion bosia kuman nog kan nog babuyanan koyon asta ombosug. Poꞌ daꞌidun mogbogoy dianon nog ponganon nog minsan mikaꞌan siꞌoy. ");
INSERT INTO suc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Sintak non nion, mipikil non og glopangan non bu kilobotan non nog og glam nog sosoligan nog gamaꞌ non mikpoksawadsawad tanan og ponganon nilan. Saka ion agonagon na unusan. ");
INSERT INTO suc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dadi, long non dun, ‘Golom u na ini uliꞌ dituꞌ sog gamaꞌ u mangka u poktaluꞌ nog, Amaꞌ, mikodusa u tidu dianika bu kosolag non sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Dadi, diꞌ u na patut nog ingolanan u pa nog bataꞌ mu. Sugaꞌid non, imung mu na akon mamaꞌ nog sosuguꞌon mu koyon.’ ");
INSERT INTO suc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Dadi, migbuat ion mangka uliꞌ dituꞌ sog gamaꞌ non. “Dangan minatong ion sog bonua non, molayuꞌ pa, kinilolaan na ion nog gamaꞌ non. Bu sabap sog landuꞌ tokodoy og glolatan non dia sog bataꞌ non koyon, ginobok non kumokop dunut pingolokan non. ");
INSERT INTO suc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tibua, miktaluꞌ og bataꞌ non koyon, ‘Amaꞌ mikodusa u dianika kosolag non sog Mikpongon. Dadi, ondiꞌ u na patut nog ingolanan u pa nog bataꞌ mu akon.’ ");
INSERT INTO suc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Tibua, ondaꞌ ion tobaloy nog gamaꞌ non. Sugaꞌid non, dinondag non og sosoligananan non mangoy nog molongas nog gimolaan non mangka posolugoy dianon, mangka posolugoy nog pinolok, ilan nog pongyapak. ");
INSERT INTO suc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tubus nituꞌ, dinondag non ilan mangoy malap nog nati nog sapiꞌ kituꞌ nog piglombuꞌ nilan mangka nilan sumboliꞌoy poꞌ moglokologyaꞌan ilan. ");
INSERT INTO suc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Poꞌ long nog gamaꞌ non koyon, ‘Og bataꞌ u koni minatoy na, tibua, mitubuꞌ. Bu miobon na ion ombolong, tibua, numun kituꞌ mitongow na.’ Dadi, miktolipun ilan dodaꞌ mokpogloliag. ");
INSERT INTO suc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Solian nilan koyon moglamilami, og bataꞌ non kituꞌ nog gulangbataꞌ dituꞌ pa sog binalan. Dangan minuliꞌ ion, pinipini non matong sog baloy nilan koyon, kisobuꞌan ion nog midongog non og glomian bu og mogigal. ");
INSERT INTO suc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dadi, sinabi non og sala kotow kisonggulan nilan mangka ion ponginongogan bog olo og piginang nilan koyon dion. ");
INSERT INTO suc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tinumabal og kisonggulan nilan koyon, ‘Og kongudan mu kituꞌ minuliꞌ na dion. Dadi, sabap sog daꞌdaꞌan nog gamaꞌ mu nog minuliꞌ bu ombaꞌis da glawas non, dinondag non ami moksumbaliꞌ nog nati nog sapiꞌ kituꞌ nog pikpolombuꞌ mangka poglokologyaꞌan.’ ");
INSERT INTO suc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Dadi, linolingitan tokodoy dun og bataꞌ non koyon nog gulangbataꞌ bu ompok na tanan ion mogdangan sog baloy nilan koyon. Tibua, inangoy ion pogomuꞌomuꞌoy nog gamaꞌ non nog sumolod na. ");
INSERT INTO suc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sokaliꞌ miktaluꞌ og bataꞌ non koyon, ‘Tontong mu poloꞌma, Amaꞌ. Daꞌ a sunoy bog sanu ton u na mokpulipon dianika. Bu ondaꞌ u sibon ponusi sog glam nog glegan mu. Tibua, daꞌ nika tanan akon sibon bogoyoy nog minsan siꞌoy og nati nog kambing bagun ami mokopogloliag nog pakasibataꞌanan ku. ");
INSERT INTO suc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tibua, og bataꞌ nika koyon nog pigbusaꞌ non og gakod nika dia sog kolibunanan kituꞌ nog ponungkagon, dangan minuliꞌ ion dini, kododaliꞌ mu tanan monumbaliꞌ nog nati nog sapiꞌ nog pikpolombuꞌ mu!’ ");
INSERT INTO suc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Dadi, tinumabal og gamaꞌ non koyon, ‘Ika, og bataꞌ u, ondaꞌ a sibon pokulog dianakon. Bu og glam nog pogongonon ku ika dosop og gapuꞌ non. ");
INSERT INTO suc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Saꞌan sumboy ita moglokologyaꞌan bu poglololiag poꞌ sabap sog kongudan mu koyon nog minatoy na, tibua, numun kituꞌ mitubuꞌ. Bu miobon na ion ombolong, tibua, numun koni mitongow na.’” ");
INSERT INTO suc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Bu miguksug nosop si Isus nog pononggiꞌan dia sog sulangguꞌanan non koyon nog, “Ongon sala kotow og doyahan nog sinumbung dianon og sosoligan non nog pigbusaꞌ non og sin nog kounutan non koyon. ");
INSERT INTO suc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dadi, tinugun non ion mangka non sakoy nog, ‘Olo og midongog u koni paꞌali dianika? Bila maꞌ nion, tulun mu dianakon og glam nog dinondag u kituꞌ mogusibaꞌ dianika. Poꞌ moktidu sog gondow koni, diꞌ u na ika imungon nog sosoligan ku.’ ");
INSERT INTO suc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Dadi, migdialominawa og glaki koyon, ‘Olo noma gidoy ini og pondayan ku? Piawaꞌ u noma nog kounutan ku. Diꞌ u posop mokogaga moginang nog ombogat. Bu mosipog u dosop monontoliꞌ. ");
INSERT INTO suc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tibua, maꞌ nini og pondayan ku dun poꞌ bagun da minsan daꞌidun siꞌoy og ginangon ku, tolimaꞌon u da nog gotowanan dia sog baloy nilan.’ ");
INSERT INTO suc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Dadi, pinugun non og glam nog togo gutang kituꞌ dia sog kounutan non koyon mangka non sakoy monala kotow dianilan bog andun og gutanganan nilan dia sog kounutan non. Dadi, sinakan non og mikuna koyon bog andun og gutang non, ");
INSERT INTO suc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Akon, mikutang u sogatus bu nom puluꞌ lata nog glana.’ Dadi, long nog glaki koyon, ‘Koni og dakol nog gutang mu nog misulat. Ingkud a pa podaliꞌ mangka nika sop og dakol non mangka mu boyadoy tibua walu puluꞌ lata.’ ");
INSERT INTO suc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tubus nituꞌ, sinakan non nosop sala kotow bog andun og gutang non. Dadi, tinumabal ion nog, ‘Sogatus saku og bogas.’ Tinumabal sosoligan koyon nog, ‘Koni og dakol nog gutang mu nog misulat. Ingkud a pa podaliꞌ mangka nika sop og dakol non bu boyadoy mu tibua walu puluꞌ saku.’” ");
INSERT INTO suc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Dadi, long sop ni Isus dun, “Og sosoligan koyon nog diꞌ kosoligan, pigdongyaꞌan ion nog kounutan non koyon sabap sog kopondayan non. Poꞌ og gotowanan nog kinilawan koni, moto ilan sumuꞌat nog batuk nilan pikilan, gabaꞌ nog gotowanan dia sog kodolagan. ");
INSERT INTO suc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Dadi, toluꞌon ku dianiu, gamit niu og gakod niu dini sog dunya koni tumabang sog pakasiotow niu nog kilogonan bagun da bila motipot na og gakod niu koyon, motolimaꞌ amu dituꞌ sog pogonongan nog daꞌidun kopus non. ");
INSERT INTO suc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Simasima og kosoligan sog mikaꞌan, kosoligan dosop sog modakol. Bu simasima og moto monglimbung nog mikaꞌan, moto dosop monglimbung nog modakol. ");
INSERT INTO suc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Dadi, bila ondiꞌ amu kosoligan mogusibaꞌ nog gakod dini sog dunya, ondiꞌ amu dosop kosoligan nog Mikpongon mogusibaꞌ nog tantu daya dituꞌ sog glangit. ");
INSERT INTO suc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bu bila ondiꞌ amu kosoligan mogusibaꞌ nog balan nog duma niu dini, sima ma mogbogoy dianiu nog tantu gakod niu kituꞌ? ");
INSERT INTO suc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Toluꞌon ku dianiu, ondiꞌ nododaꞌ mogusoy og gulipon nog duaꞌ buk og gapuꞌ non. Poꞌ bila maꞌ nituꞌ, mimung nog pokongitan non og sala kotow mangka non kololamoy og sala kotow. Otawaka, mokokunut sog sala kotow mangka pongantu sog sala kotow. Diꞌ mogusoy nog tigbungon niu og pikilan niu dia sog Mikpongon bu tigbungoy dosop dia sog pilak.” ");
INSERT INTO suc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Dangan midongog nog parasiuanan nog maꞌ nion koyon, pigwanwanan nilan si Isus poꞌ bololagaꞌ tokodoy dianilan og sin. ");
INSERT INTO suc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dadi, tinoluꞌan ilan ni Isus nog, “Bila dia amu sog sunguꞌan nog gotowanan, baluꞌbaluꞌ mokolongas amu. Tibua, og Mikpongon, kosunan non da og dialom pikilan niu. Poꞌ og glam nog bololagaꞌ tokodoy dia sog sagyaotow, molomuꞌ dun og Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Og Botad kituꞌ nog binogoy nog Mikpongon dia ni Muses asta sog polomolatasanan kituꞌ nog taluꞌ nog Mikpongon kobon nituꞌ, inustal ituꞌ taman da dia ni Jan nog Polomunyag. Tidu dituꞌ, og Gombaꞌis nog Guksugan paꞌali sog pigdotuꞌan nog Mikpongon inustal na bu sala duaꞌ og gotowanan mogagow mampuꞌ dun. ");
INSERT INTO suc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tibua, og Botad kituꞌ, daꞌ nododaꞌ og piksopan non sotoktang siꞌoy. Molomu pa pondaꞌon og glangit bu glupaꞌan, tibua, og Botad kituꞌ ondiꞌ nododaꞌ kokulangan mikaꞌan siꞌoy. ");
INSERT INTO suc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Poꞌ bigyaꞌ pa og botad nog maꞌ nini, nog simasima og glaki molong nog glibun non mangka pogduoy sog len, mokodusa ion dun poꞌ maꞌana non mimabal ion nog len glibun. Bu og glaki siꞌoy kituꞌ nog migduoy dia sog bituanon koyon mokodusa dosop ion dun.” ");
INSERT INTO suc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Miguksug nosop si Isus nog pononggiꞌan non nog, “Ongon sala kotow doyahan nog minapot nog landuꞌ pokologan nog ponopoton bu molongas tokodoy og kotubuꞌ non. ");
INSERT INTO suc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bu ongon sala kotow og sontoliꞌ dion, og ngalan non si Lasarus. Milokop og glawas non nog nuka. Bu dia ion pigbotang sog molani nog bongawan nog baloy nog doyahan koyon. ");
INSERT INTO suc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Miksabaꞌ ion bosia kuman nog momu siꞌoy nog mokpogdogdag tidu sog glomisahan nog doyahan koyon. Bu pokponilaꞌan tanan nog gayamanan og nuka non koyon. ");
INSERT INTO suc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sintak non, minatoy og miskinan koyon. Dadi, inangoy nog moloikatanan mangka nilan oitoy dituꞌ sog molani ni Abraham. Daꞌ kobon golot non, minatoy dosop og doyahan koyon mangka lobongoy. ");
INSERT INTO suc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Dituꞌ ion mikangoy sog kosinsaan nog pogonongan nog mikpomatoy. Dangan tinumingag, mitongow non sog molayuꞌ si Abraham nog dia sog molani non si Lasarus. ");
INSERT INTO suc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dadi, mikilolat ion dia ni Abraham nog, ‘Apuꞌ Abraham, kololatoy mu pa suꞌusa akon. Bu dondag mu pa si Lasarus nog tokmoꞌon non pa og sung siꞌoy nog tonduꞌ non dia sog tubig mangka non potolongoy dia sog dilaꞌ u bagun u pa kotigdowan dun. Poꞌ diꞌ u na mogaga og gapuy koni nog landuꞌ kinit.’ ");
INSERT INTO suc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Tibua, tinabal ion ni Abraham nog, ‘Bataꞌ u, pikil nika poloꞌma nog kinobon pa nog dituꞌ a pa sog glupaꞌan. Glam nog momis molombuꞌ nog kotubuꞌ sog glupaꞌan miakod mu. Tibua, si Lasarus, miglogaga ion nog glam nog sinsaan kobon non sog glupaꞌan. Dadi, numun kituꞌ si Lasarus, ombaꞌis na og kibotangan non dini bu ika nosop og moglogaga nog sinsaan. ");
INSERT INTO suc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bu koduaꞌ non, ondiꞌ nododaꞌ mokobian ain og moleg tumolipag posunguꞌ dion otawaka posunguꞌ dini, poꞌ moliwag bu kodalom nog glikpa sog golot ta koyon.’ ");
INSERT INTO suc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Tinumabal og doyahan koyon nog, ‘Bog maꞌ nituꞌ buan Apuꞌ Abraham, pongonion ku pa suꞌusa dianika nog dondag mu pa si Lasarus mangoy dituꞌ nami. ");
INSERT INTO suc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Poꞌ ongon pa lima kotow pigilugananan ku dituꞌ. Bu sumboy kopomolian non pa ilan poꞌ bagun ilan pa suꞌusa ondiꞌ mokangoy dini sog kibonaꞌan ku koni nog sinsaan.’ ");
INSERT INTO suc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Tinumabal si Abraham nog, ‘Dituꞌ na og Botad nog sinulat ni Muses bu og polomolatasanan kituꞌ nog taluꞌ nog Mikpongon. Dadi, dituꞌ ilan na ponginongog.’ ");
INSERT INTO suc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Tibua, og doyahan koyon tinumabal nog, ‘Ondiꞌ ilan nododaꞌ tumud bu mokokunut dun Apuꞌ, lual da ngon mogbuat tidu sog patoy mangoy mogustal dianilan mangka ilan pa poglilaꞌ nog dusaanan nilan.’ ");
INSERT INTO suc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Tibua, tinumabal si Abraham nog, ‘Bila ondiꞌ ilan mokinongog bu pomilang sog pomali nog sinulat ni Muses bu duma polomolatasanan kituꞌ, ion non da, ondiꞌ ilan dosop tumud nog minsan siꞌoy ongon mogbuat tidu sog patoy.’” ");
INSERT INTO suc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Miktaluꞌ si Isus dia sog sulangguꞌanan non koyon nog, “Mologon nog diꞌ pongyubaꞌan og gotow. Tibua, kondokondok tokodoy og doksuꞌan sog ain mikongulan kituꞌ sog duma non nog boyaꞌan mokodusa dun. ");
INSERT INTO suc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Golom na lentengoy nog gilingan batu og glig non mangka lobuꞌoy sog dibabaꞌ dagat, gabaꞌ nog moit non mokodusa og sala kotow gombataꞌanan koni. ");
INSERT INTO suc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Dadi, pokpotubud amu nog kohinangan niu! “Bu bila ongon pakasi tanud niu nog mokosalaꞌ dianiu, pomag niu. Tubus nituꞌ, bila moglilaꞌ ion, ompunoy niu. ");
INSERT INTO suc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bu bila mikosalaꞌ ion dianiu pitu kali sondow, tubus nituꞌ mangoy moglilaꞌ dosop kobon non, sumboy ompunan niu dosop.” ");
INSERT INTO suc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dadi, miktaluꞌ nosop og sosuguꞌonanan non koyon nog, “Kounutan, popagon mu pa og kopongandol nami.” ");
INSERT INTO suc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tinumabal si Isus nog, “Bila ongon kopongandol niu nog minsan siꞌoy nog mamaꞌ nog glongow nog mustasa kobataꞌ, kotoluꞌan niu og kayu koni nog, ‘Kolungad a bu kopasok dituꞌ sog dagat,’ bu mogbilang da dianiu.” ");
INSERT INTO suc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Bu long sop ni Isus dianilan, “Bila ongon sala kotow dianiu togo sosuguꞌon mogbagyaꞌ otawaka mogipat nog bilibilianan, bila matong sosuguꞌon niu koyon tidu sog ginang non, ondiꞌ mu nododaꞌ onggaton ion mangoy kuman. ");
INSERT INTO suc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sugaꞌid non, toluꞌan mu pa tanan ion nog, ‘Imala a na bu poksimpan ka nog globungan ku mangka mu akon tologadoy, tubus nituꞌ, mangka a pa sukli kuman.’ ");
INSERT INTO suc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bu og sosuguꞌon ondiꞌ doꞌitan nog posolomatan nog miinang non poꞌ koyon nododaꞌ og polosukuꞌan non dia sog kounutan non. ");
INSERT INTO suc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Domikian dosop dianiu nog bila modoksuꞌ niu inangoy og ain dinondag dianiu, sumboy toluꞌon niu, ‘Sagya ami da nog sosuguꞌon, ininang nami tibua ain og polosukuꞌan nami.’” ");
INSERT INTO suc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Dangan posunguꞌ si Isus sog Jerusalem, dituꞌ ion minian sog tigad nog bonua nog Samaria bu Galili. ");
INSERT INTO suc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pinipini non matong sog gimbolayan koyon, linumpak ion nog sopuluꞌ kotow nog gipulon. Mikpogindog ilan dia sog molayuꞌ ");
INSERT INTO suc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","mangka ilan poktaluꞌ nog mosikad nog, “Kounutan Isus! Kololat a pa suꞌusa dianami!” ");
INSERT INTO suc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Dangan mitongow ni Isus og gotowanan koyon, tinoluꞌan non ilan nog, “Angoy niu potongow og glawas niu sog boliananan.” Dadi, mipanow ilan. Bu sonuk nilan ompanow, kiuliꞌan ilan. ");
INSERT INTO suc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sala kotow dianilan, dangan mibatik non nog kiuliꞌan gipul non, mikpuliꞌ ion dituꞌ ni Isus kobon non moksanglit nog mosikad sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bu minombaꞌ ion sog sunguꞌan ni Isus mangka pokposolamat dianon. Og gotow koyon og gotow Samaria. ");
INSERT INTO suc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Dadi, sinakan ion ni Isus nog, “Konaꞌ taꞌ nog sopuluꞌ kotow amu og kiuliꞌan kituꞌ? Ain noma og siam kotow dun? ");
INSERT INTO suc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Iduma sala mu doma og mikopikil mokpuliꞌ dini mokposolamat dia sog Mikpongon, saka konaꞌ a tanan og Hudyu?” ");
INSERT INTO suc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tubus nion, tinoluꞌan ion ni Isus nog, “Pogbuat a le, mangka a uliꞌ. Saꞌan kiuliꞌan ka poꞌ sabap sog kopongandol mu.” ");
INSERT INTO suc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Si Isus sinakan nog parasiuanan koyon dion bog nanu dodaꞌ datong og kopogdatuꞌ nog Mikpongon. Dadi, tinumabal si Isus nog, “Bila matong og kopogdatuꞌ nog Mikpongon, diꞌ motongow nog gotow. ");
INSERT INTO suc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Dadi, daꞌidun mokopoktaluꞌ nog, ‘Dini na’, otawaka, ‘Kituꞌ na!’ Poꞌ og kopogdatuꞌ nog Mikpongon dion na niu.” ");
INSERT INTO suc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tubus nion, miktaluꞌ nosop si Isus dia sog sulangguꞌanan non koyon nog, “Matong da og gondow nog sabaꞌ niu dun, motongow niu na bosia og sondow siꞌoy og Binataꞌ sog Kilawan mogdatuꞌ na. Tibua, ondiꞌ niu pa ion motongow. ");
INSERT INTO suc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bu ongon moktaluꞌ dianiu nog, ‘Dion na ion!’ otawaka, ‘Dini na ion!’ Tibua, naꞌ amu mogbilang mangoy tumontong dun. ");
INSERT INTO suc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Poꞌ bila matong na og gondow nog pogdatong nog Binataꞌ sog Kilawan, ompononggiꞌ sog kilat nog gomonsunoy pa diadia pogbusiat tidu sog silangan mangoy sog sindopan. ");
INSERT INTO suc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tibua, mangka siꞌoy og maꞌ nion koyon, mokobian poguna ion posinsaon tokodoy bu pogbongkison ion nog gotowanan numun koni. ");
INSERT INTO suc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Sog kodatong nog Binataꞌ sog Kilawan, og glangkalangka nog gotowanan mamaꞌ dosop nog polomotadon nog gotowanan kituꞌ sog masa ni Nowa kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Poꞌ og poginangon nilan, mikpoglokanlokan, mikpoginuminum, bu mimogduoy, asta sog gondow nog sinumolod si Nowa sog gagyung kituꞌ nog inimung non. Dadi, dangan minatong og glayas, og gotowanan koyon sog glowasan, mitipot ilan pomoglaꞌat. ");
INSERT INTO suc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bu maꞌ nituꞌ dosop og masa ni Lot kobon nituꞌ. Og poginangon nog gotowanan mikpoglokanlokan bu mikpoginuminum, mikpogdagangdagang, mikpogimula, bu mimogimung ilan nog baloy. ");
INSERT INTO suc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tibua, sog gondow kituꞌ nog ginumonat si Lot sog bonua koyon nog Sodom, gomonsunoy pa migdupiꞌ na nog gapuy bu asupri boyaꞌan og glam nog gotowanan dion sog bonua koyon mitipot ilan pomatoy. ");
INSERT INTO suc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bu domikian dosop maꞌ nituꞌ og gondow nog potongowon na og Binataꞌ sog Kilawan. ");
INSERT INTO suc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Bu sog gondow koyon, og gotow, bila kotangan nog dia ion sog glowasan nog baloy non, ondiꞌ na mokotagad sumolod mangoy mongalap nog balan non. Domikian dosop nog ain dia sog binalan non, diꞌ na dosop mokotagad muliꞌ sog baloy non. ");
INSERT INTO suc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Poktitukoy niu tibua og kibianbianan nog duoy ni Lot. ");
INSERT INTO suc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dadi, simasima og mogapas nog dili kotubuꞌ non, kobolongan ion dun. Tibua, simasima lamig non bolongon og dili kotubuꞌ non, kongonan nog kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Toluꞌon ku dianiu, ongon duaꞌ kotow miguboy sog glonsuan non, og gobi koyon sala kotow oiton bu og sala kotow ombagak. ");
INSERT INTO suc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bu duaꞌ kotow glibun, solian nilan gumiling, og sala kotow oiton bu og sala kotow sop ombagak.  ");
INSERT INTO suc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bu ongon dosop duaꞌ kotow glaki, dituꞌ ilan sog binalan, og sala kotow oiton bu og sala kotow sop ombagak.” ");
INSERT INTO suc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dadi, og sulangguꞌanan ni Isus koyon miksak nog, “Kounutan, ain mobuan ion kinang?” Dadi, tinabal ilan ni Isus nog, “Ain og kibotangan nog bangkoy, dituꞌ dosop pogdopuꞌoy kuman nog guakanan.” ");
INSERT INTO suc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tubus nituꞌ, migustal nosop si Isus sog sulangguꞌanan non koyon bianan sog pononggiꞌan bagun ilan ondiꞌ modaliꞌ kotonop mogyakin bu diꞌ ombolong og dodomaan nilan. ");
INSERT INTO suc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Long non dun, “Sog solabuk bonua ongon og sala kotow polomasad dion nog ondiꞌ mondok sog Mikpongon bu daꞌidun og baꞌasa non sog pakasiotow non. ");
INSERT INTO suc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bu ongon sop og balulibun dion nog kobon non mokpuliꞌpuliꞌ na dia sog polomasad koyon moktaluꞌ nog, ‘Naꞌ mu akon pogulaban nog botad nog pigdang u koyon dianika.’ ");
INSERT INTO suc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Og sumbungan nog balulibun koyon miobon na. Tibua, og polomasad koyon ondiꞌ non ponglenglengan masad. Sintak non, og polomasad koyon mikpikilpikil nog minsan na ondiꞌ ion mondok sog Mikpongon otawaka ondaꞌidun og baꞌasa non sog pakasiotow non, ");
INSERT INTO suc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","sumboy tobangan non da og balulibun koyon poꞌ gomonsunoy kowaꞌan ion nog ponutus sabap nog mosasow ion nog kopokpuliꞌpuliꞌ notibua og glibun koyon dianon.” ");
INSERT INTO suc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Maꞌ long nog Kounutan dun dia sog sulangguꞌanan non koyon, “Tontong niu poloꞌma og piginang nog polomasad koyon nog mogbigyaꞌ nog gotow, ");
INSERT INTO suc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","labi pa dituꞌ og Mikpongon nog sumugut dia sog pigotowan non nog mingoningoni dianon gobi gondow. Diꞌ ilan nododaꞌ potiangon, ");
INSERT INTO suc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","sugaꞌid non, tobangan non nododaꞌ ilan mogdayun. Tibua, sog tang nog kopokpuliꞌ nog Binataꞌ sog Kilawan dini sog dunya, ongon dotaꞌ gidoy og kodotongan non nog gotowanan nog mingandol dia sog Mikpongon?” ");
INSERT INTO suc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bu miguksug nosop si Isus nog pononggiꞌan non dia sog gotowanan kituꞌ nog baluꞌ nilan dun midulus ilan na bu mokpotaspotas ilan dia sog pakasiotow nilan. ");
INSERT INTO suc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ongon duaꞌ kotow og minangoy mogyakin sog Baloy nog Poktomuyan dia sog Mikpongon. Og sala kotow koyon og parasiu, bu og sala kotow sop koyon og polongabat nog buis. ");
INSERT INTO suc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Og parasiu koyon minindog mangka ion pogyakin nog, ‘Mikpongon, mikposolamat u poꞌ diꞌ u mamaꞌ nog duma gotow nog mabak, otawaka molimbung, otawaka momabal nog konaꞌ non duoy. Solamat poꞌ diꞌ u dosop mamaꞌ nog polongabat nog buis koyon. ");
INSERT INTO suc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Bu duaꞌ kali u tanan pokpuasa sog sala semana. Bu migbogoy u nog kosopuluꞌ bahagiꞌ nog glam nog sukatan ku.’ ");
INSERT INTO suc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Tibua, og polongabat nog buis koyon, dangan migyakin, dituꞌ ion minangoy sog goksukoksuk bu diꞌ tanan tumongal sog glangit kobon non moksampak nog gigdob non mangka poktaluꞌ nog, ‘Mikpongon, kololatoy mu pa akon poꞌ akon og gotow nog bolodusaon.’” ");
INSERT INTO suc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Maꞌ long ni Isus dun dianilan, “Toluꞌon ku dianiu nog og polongabat koyon nog buis, minuliꞌ ion nog midulus, konaꞌ og parasiu kituꞌ. Poꞌ ain og mokpotas nog bolotabat non, pobobaꞌon ion. Tibua, ain og mokpobabaꞌ nog bolotabat non, potason ion.” ");
INSERT INTO suc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tubus nituꞌ, ongon og gotowanan nog mikpogoit nog gombataꞌanan nilan dia ni Isus bagun non ilan kodoponan. Tibua, dangan mitongow nog sulangguꞌanan ni Isus og maꞌ nion koyon, pimag nilan og gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tibua, sinabi ni Isus og gombataꞌanan koyon mangoy dianon mangka ion poktaluꞌ sog gotowanan koyon nog, “Potiang niu og gombataꞌanan koyon mokpolani dianakon. Naꞌ niu ilan pogondiꞌan. Poꞌ maꞌ nog gombataꞌanan koyon, og gotowanan nog misakup sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Toluꞌon ku dianiu, nog simasima og diꞌ mamaꞌ nog bataꞌ og kotabuk non nog kopogdatuꞌ nog Mikpongon, ondiꞌ nododaꞌ mokampuꞌ sog pigdotuꞌan non.” ");
INSERT INTO suc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tubus nituꞌ, ongon sala kotow glaki og kounutan nog Hudyu minangoy moksak dia ni Isus nog, “Polopanad, ombaꞌis a tokodoy. Olo gidoy sumboy inangon ku bagun ku malap og kotubuꞌ nog daꞌ kopus non?” ");
INSERT INTO suc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tinumabal si Isus nog, “Iduma ingolanan mu ma akon nog ombaꞌis? Saka daꞌidun og ombaꞌis lual da og Mikpongon? ");
INSERT INTO suc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kosunan mu da og dondagananan nog Mikpongon nog sinulat ni Muses nog, ‘Naꞌ a momabal nog konaꞌ mu duoy, bu naꞌ a momunuꞌ, bu naꞌ a monakow, bu naꞌ a tumaksiꞌ nog gloput, bu pogbotadoy mu og ginaꞌamaꞌ mu.’” ");
INSERT INTO suc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tinumabal og glaki koyon nog, “Glam non koyon pigunut u na tidu pa sog kikaꞌan ku.” ");
INSERT INTO suc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Dangan midongog ni Isus og tabal non koyon, tinoluꞌan non og gotow koyon nog, “Ngon pa solabuk kulang mu nog sumboy inangon mu. Angoy mu poksaluy og glam nog pogongonon mu mangka mu pomogoy og saluy non dia sog miskinananan poꞌ mogdaya a dun dituꞌ sog glangit. Tubus nituꞌ, pokpuliꞌ a mangka a pogunut dianakon.” ");
INSERT INTO suc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tibua, dangan midongog nog glaki koyon og taluꞌ ni Isus koyon, mipanguꞌ ion dun poꞌ doyahan ion tokodoy. ");
INSERT INTO suc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Dadi, pigbontayan ni Isus glaki koyon bu poktaluꞌ nog, “Mologon dodaꞌ tokodoy og gotow nog doyahan nog mokampuꞌ ion dia sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Molomu pa kobian nog kamel dia sog gluang nog dialum, gabaꞌ nog doyahan, og kampuꞌ non dia sog pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dadi, og gotowanan nog mikodongog nog taluꞌ ni Isus koyon, miksak ilan dianon nog, “Bila maꞌ nituꞌ, sima ma buan og motabang?” ");
INSERT INTO suc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tinumabal si Isus nog, “Ain og diꞌ minang nog gotow, inangon da nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tubus nion, miksak si Piter dianon nog, “Dadi, ami buan nog lamig nami na tanan binolong og glam nog pogongonon nami bu pogunut dianika.” ");
INSERT INTO suc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tinumabal si Isus nog, “Toluꞌon ku dianiu, ain ginonatan non og baloy non, og duoy non, og pigilugan non, og mokogulang non, otawaka minsan gombataꞌanan non sabap sog kampuꞌ non dia sog pigdotuꞌan nog Mikpongon, ");
INSERT INTO suc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mokotabuk ion nog labi pa tokodoy dituꞌ og sugda dun dianon minsan siꞌoy solian non pa dini sog dunya. Bu sog binayaꞌ nog gondow, mokalap ion nog kotubuꞌ nog daꞌ kopus non.” ");
INSERT INTO suc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tubus nituꞌ, pinitang ni Isus og sopuluꞌ bu duaꞌ sulangguꞌanan non koyon sog molayuꞌlayuꞌ mangka non ilan toluꞌoy nog, “Posunguꞌ ita loꞌ ini sog Jerusalem bu glam nog sinulat nog polomolatasanan nog taluꞌ nog Mikpongon kobon nituꞌ nog paꞌali dia sog Binataꞌ sog Kilawan posunguꞌ na motuman dituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Poꞌ uokilon ion dia sog gongkoman nog gotowanan nog konaꞌ bansa Hudyu bu mangka nilan ion pogwanwanoy bu solapsolapoy, bu mangka nilan pogdulaꞌoy. ");
INSERT INTO suc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bu tubus nion, pogdonogon nilan ion mangka nilan bunuꞌoy. Tibua, sog kotolu ondow non, motubuꞌ da ion mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tibua, og glam nog piktaluꞌ ni Isus koyon, ondaꞌ kosabut nog sulangguꞌanan non koyon poꞌ og maꞌana non milingod pa dianilan. Saꞌan da ondaꞌ nilan kosabut og piktaluꞌ non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Dangan daliꞌdaliꞌ ilan na datong sog bonua nog Jeriku, ongon og buta dion pogingkud dia sog goksid nog dalan kobon non monontoliꞌ. ");
INSERT INTO suc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Dangan mibatik non nog modakol og mikpomian, miksak ion bog olo nituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dadi, ongon tinumabal nog, “Og minian koyon si Isus, og gotow Nasaret.” ");
INSERT INTO suc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dadi, miktaluꞌ og buta koyon nog mosikad nog, “Isus! Pangkat ni Apuꞌ Dabid. Kololatoy mu pa akon!” ");
INSERT INTO suc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dadi, pimag ion nog gotowanan mokulekeꞌ, ain sog gunan ni Isus. Tibua, posisayaꞌ non tanan posikadoy og tawag non nog, “Pangkat ni Apuꞌ Dabid! Kololatoy mu pa suꞌusa akon!” ");
INSERT INTO suc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dadi, migindog si Isus mangka non dondagoy mokpitang dituꞌ non og gotow koyon. Dangan milani tibua dianon, sinakan ion ni Isus nog, ");
INSERT INTO suc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Olo og kolegan mu nog inangon ku dianika?” Tinumabal og gotow koyon nog, “Kounutan, moleg u nog mokotongow u mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dadi, miktaluꞌ si Isus dianon nog, “Bog maꞌ nituꞌ buan, mokotongow a na. Sabap sog kopongandol mu kiuliꞌan ka na dun.” ");
INSERT INTO suc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bu sododuꞌun og gotow koyon mikotongow. Tubus nion, migunut ion dia ni Isus, kobon non mokposolamat bu moksanglit sog Mikpongon. Dangan mitongow ion nog kodokolan nog gotowanan koyon dion, miksanglit ilan dosop dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Dangan minatong na si Isus ilan nog sulangguꞌanan non sog koliwagan bonua nog Jeriku, minian ilan tibua dion, ");
INSERT INTO suc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ongon og gotow dion ngalan non si Sakius, og kounutan nog polongabatanan nog buis bu doyahan ion. ");
INSERT INTO suc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Bu moleg ion tumontong dia ni Isus. Tibua, sabap sog kodakol nog gotow, ondiꞌ non motongow si Isus poꞌ ompandak ion. ");
INSERT INTO suc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Dadi, ginumobok ion sog gunan nog gotowanan koyon mangka pomonek sog ditas nog kayu nog ngalan non Sikamur, bagun non motongow si Isus poꞌ posunguꞌ ion mian dion. ");
INSERT INTO suc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Dangan mitondong si Isus dianon, tinongalan non si Sakius mangka poktaluꞌ dianon nog, “Sakius, pogdaliꞌ a monog dini poꞌ gondow koni, sumboy monguliꞌan u sog baloy mu.” ");
INSERT INTO suc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dadi, migdaliꞌ lumoklus si Sakius mangka non tolimaꞌoy si Isus dituꞌ sog baloy non dunut landuꞌ og daꞌdaꞌan non. ");
INSERT INTO suc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dangan mitongow nog gotowanan sog glumibut og maꞌ nion koyon, mikpokumodumod ilan nog, “Og gotow koni tumibabaꞌ ma monumbaloy sog gotow nog bolodusaon.” ");
INSERT INTO suc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tibua, si Sakius, minindog ion mangka poktaluꞌ dia sog Kounutan nog, “Kounutan, moktolipun numun kituꞌ, og glam nog pogongonon ku sopoginongaꞌ dun bogoyon ku dia sog miskinananan. Bu bila mikolimbung u dia sog gotowanan, uliꞌon ku dianilan pat kali nog maꞌ nituꞌ golagaꞌ non.” ");
INSERT INTO suc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dadi, miktaluꞌ si Isus dianon nog, “Og gondow koni minatong na og tabang nog Mikpongon dia sog solod nog baloy koni. Poꞌ maꞌ nini siꞌoy og gotow koni, og pangkat da ni Apuꞌ Abraham. ");
INSERT INTO suc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Poꞌ saꞌan minangoy dini sog dunya og Binataꞌ sog Kilawan poꞌ monontong ion nog ain mibolong kobal nog dusa nilan bagun ilan da mogawon.” ");
INSERT INTO suc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sonuk nog gotowanan mokinongog dia ni Isus, miguksug ion nog pononggiꞌan poꞌ molani ilan na sog Jerusalem. Bu baluꞌ nog gotowanan koyon dun og kopogdatuꞌ nog Mikpongon daliꞌ na datong. ");
INSERT INTO suc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Dadi, long ni Isus dun, “Ongon og motas nog gotow nog minangoy sog molayuꞌ nog bonua bagun ion motonduꞌ mogdatuꞌ mangka siꞌoy ion uliꞌ. ");
INSERT INTO suc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tibua, mangka siꞌoy ion gonat, pilimud non poguna og sopuluꞌ kotow nog sosoligananan non mangka non ilan pomogoyoy monolabuk nog sin nog bulawan sog monala kotow dianilan kobon non momilin dianilan nog sin koyon gomiton nilan poꞌ bagun mogbataꞌ solian nog daꞌ pa ion datong. ");
INSERT INTO suc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tibua, pikongitan ion nog salu bonua non. Dadi, dangan mikolikudlikud tibua ion, ongon pilondug nilan nog gotowanan nog moktaluꞌ dituꞌ nog ompok ilan nog ion og mogdatuꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tibua, miimung da ion nog datuꞌ mangka ion uliꞌ. Dangan minatong ion dia sog bonua non koyon, tinugun non og pimogayan non kituꞌ nog sin nog bulawan poꞌ bagun non kosunan bog andun og guntung nog monala kotow dianilan. ");
INSERT INTO suc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Og tiganaꞌ matong nog sosoligan non miktaluꞌ nog, ‘Kounutan, og solabuk sin nog bulawan nog binogoy mu kituꞌ dianakon, mikuntung u dun lagaꞌ sopuluꞌ sin nog bulawan.’ ");
INSERT INTO suc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Dadi, tinumabal og kounutan non koyon nog, ‘Kisuꞌatan u tokodoy nog ginang mu koyon. Ombaꞌis a dodaꞌ nog sosuguꞌon. Dadi, kosoligan ka ma sog bataꞌbataꞌ balan, uokilon ku dianika og mogokbit dia sog sopuluꞌ koliwagan bonua.’ ");
INSERT INTO suc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Tubus nion, minatong dosop og koduaꞌ sosoligan non mangka poktaluꞌ nog, ‘Kounutan, og solabuk sin nog bulawan nog binogoy mu kituꞌ dianakon, mikuntung u dun lagaꞌ lima sin nog bulawan.’ ");
INSERT INTO suc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Tinumabal sop og kounutan non koyon nog, ‘Dadi, uokilon ku dianika og mogokbit dia sog lima buk koliwag bonua.’ ");
INSERT INTO suc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Tubus nion, minatong dosop og sala kotow sosoligan non mangka poktaluꞌ nog, ‘Kounutan, koni og sin kituꞌ nog tinulun mu dianakon. Pinutus u ini mahatul nog munsala mangka u bunioy ");
INSERT INTO suc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","sabap sog gondok u dianika. Poꞌ kosunan ku nog ika lenlen a nog gotow. Mongalap a minsan konaꞌ nika dili gapuꞌ non. Bu gumani a nog konaꞌ nika og mimula dun.’ ");
INSERT INTO suc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Tinumabal og kounutan non koyon nog, ‘Ika, molaton ka nog sosuguꞌon! Og taluꞌ mu koyon muliꞌ dianika. Long mu pa dun nog akon lenlen u nog gotow nog mongalap u nog konaꞌ u gapuꞌ non bu gumani u nog konaꞌ u og mimula dun. ");
INSERT INTO suc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Iduma daꞌ nika mobuan toguꞌoy sog bangku og sin koyon bagun mogbataꞌ mangka u siꞌoy olapoy dianika bila matong u na?’ ");
INSERT INTO suc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mangka og kounutan non koyon poktaluꞌ dianilan nog pogindog dion nog, ‘Alap niu og sin koyon dianon mangka niu bogoyoy dia sog sosoligan kituꞌ nog mikuntung nog sopuluꞌ sin og bulawan.’ ");
INSERT INTO suc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Tibua, tinumabal og gotowanan koyon, ‘Kounutan, iduma maꞌ nion ma nog saka, ongon na tanan sopuluꞌ sin bulawan non?’ ");
INSERT INTO suc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Dadi, tinumabal og kounutan nilan koyon nog, ‘Toluꞌon ku dianiu, ain ongon dianon, dungagan pa dianon. Tibua, ain daꞌidun dianon, minsan og dakoldakol non na owaꞌon pa dianon. ");
INSERT INTO suc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Bu kituꞌ siꞌoy og minanta dianakon nog ompok kituꞌ pogdotuꞌan dianakon, oit niu dini mangka niu bunuꞌ dini sog sunguꞌan ku.’” ");
INSERT INTO suc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Dangan midoksuꞌ ni Isus suksugoy og pononggiꞌan non koyon, miguna ion ompanow posunguꞌ dituꞌ sog Jerusalem sog gunan nog glumpuk nog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dangan daliꞌ na ion sog Betpage nog molani sog bonua nog Betani, dia sog pun bilid nog bulud nog Olibu, dinondag non moguna dituꞌ og duaꞌ kotow sulangguꞌanan non koyon. Bu miktaluꞌ ion nog, ");
INSERT INTO suc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Angoy amu sog gimbolayan koyon. Bu bila matong amu dion, mokotongow amu nog nati nog asnu inikotan nog ondaꞌ pa sibon sokoyoy. Ubad niu bu oit niu dini. ");
INSERT INTO suc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bu bila ongon og moksak dianiu bog iduma ubadon niu ma og nati koyon, tabal niu nog ongon og kobalan nog Kounutan dun.” ");
INSERT INTO suc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dadi, mipanow og duaꞌ kotow koyon bu mitongow nilan dodaꞌ og glam nog piktaluꞌ ni Isus kituꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Dadi, inubad nilan og gikot nog nati koyon. Solian nilan mubad dun, miktaluꞌ og gapuꞌ non nog, “Olo og balan niu mubad nog nati nami koyon?” ");
INSERT INTO suc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tinumabal ilan nog, “Ngon og kobalan nog Kounutan dun.” ");
INSERT INTO suc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dadi, inoit nilan og nati koyon dituꞌ ni Isus, mangka nilan onigoy nog glogdoy nilan og tolinting non mangka nilan posokoyoy si Isus dion. ");
INSERT INTO suc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Dangan pipanow na ni Isus og nati koyon, og gotowanan koyon dion, pingdondam nilan og sulagbon nilan dia sog dalan koyon nog bianan ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dangan daliꞌdaliꞌ na datong si Isus sog koliwagan bonua nog Jerusalem dia sog diksunan sog bulud nog Olibu, landuꞌ kodakol og sulangguꞌanan non, og glam nilan mikpoksanglit ilan nog mosikad sog Mikpongon dunut daꞌdaꞌan nilan sabap sog glam nog kosobuꞌsobuꞌ nog piginang ni Isus nog mitongow nilan. ");
INSERT INTO suc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Long nilan dun, “Pipia og datuꞌ nog minangoy na dini bianan sog ngalan nog Mikpongon! Ongon gomigus sog glangit bu kotas nog gadab dia sog Mikpongon!” ");
INSERT INTO suc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bu ongon og parasiuanan dion sog glumpuk koyon. Miktaluꞌ ilan dia ni Isus nog, “Polopanad, pomag mu pa mokulekeꞌ og pigotowan mu koyon!” ");
INSERT INTO suc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tibua, tinabal ilan ni Isus nog, “Toluꞌon ku dianiu, bila ondiꞌ ilan mokulekeꞌ, og batuanan og sumukli mogekes.” ");
INSERT INTO suc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pinipini nilan matong sog Jerusalem, dangan mitongow ni Isus og koliwagan bonua koyon, miksogow ion, ");
INSERT INTO suc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","kobon non moktaluꞌ nog, “Ombaꞌis bosia somoꞌ misabut niu gondow koni bog olo bianan dun bagun matong og kotiknaꞌ sog bonua niu koni. Tibua, numun kituꞌ milingod na dia sog mata niu. ");
INSERT INTO suc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Poꞌ matong gondow nog gubaton amu nog banta niu, poglibutan nilan amu mahatul sog bonua niu koni bagun daꞌidun mokopolaguy dianiu ");
INSERT INTO suc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","mangka nilan amu ponguloꞌatoy bataꞌ mogulang dianiu. Bu asta og baloyanan sog bonua niu koni, tipoton monggobaꞌ nog bantaanan niu. Saꞌan maꞌ nion og kobianbianan niu kobal nog daꞌ niu kilolaoy og kodatong nog Mikpongon dianiu.” ");
INSERT INTO suc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Dangan minatong si Isus sog Jerusalem, sinumolod ion sog glomalomaan nog Baloy nog Poktomuyan dia sog Mikpongon mangka non pomugowoy og gotowanan koyon nog mikpogdagangdagang dion ");
INSERT INTO suc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kobon non moktaluꞌ dianilan nog, “Sinulat dia sog Kitab og taluꞌ nog Mikpongon, nog og baloy non, og baloy nog pogyokinan. Tibua, inimung niu nog glihanan nog polonakowanan.” ");
INSERT INTO suc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Gondow gondow og poginangon ni Isus momali dion sog Baloy nog Poktomuyan dia sog Mikpongon. Bu og mokokotas nog boliananan, bu og polopanadanan nog botad nog bansa Hudyu, bu og kobogolalan dion sog bonua koyon, piksipian nilan bosia munuꞌ si Isus. ");
INSERT INTO suc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tibua, daꞌidun og bianan nilan dun poꞌ glam nog gotowanan koyon dion minginongog mahatul dia sog gustalan non. ");
INSERT INTO suc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ongon gondow non, si Isus mikpanad dia sog gotowanan sog Baloy nog Poktomuyan koyon dia sog Mikpongon bu migustal paꞌali sog Gombaꞌis nog Guksugan. Solian non mokpanad, og mokokotas nog boliananan, bu og polopanadanan nog botad nog bansa Hudyu, asta og kobogolalan dion, minangoy ilan dion ni Isus ");
INSERT INTO suc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","mangka ilan poksak nog, “Olo og bayaꞌ mu moginang nog maꞌ nion koyon? Bu sima migbogoy nog bayaꞌ koyon dianika?” ");
INSERT INTO suc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tinabal non ilan nog, “Sakan ku dosop amu. Taluꞌ niu dianakon ");
INSERT INTO suc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","sima og migbogoy nog bayaꞌ dia ni Jan nog Polomunyag nog momunyag nog gotowanan? Og Mikpongon taꞌ otawaka og gotow?” ");
INSERT INTO suc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dadi, miksinaksakoy ilan, nog ilan bu ilan bog olo og tabal nilan sog sak ni Isus koyon. Maꞌ long nilan dun, “Bila ini toluꞌon ta nog dia tidu sog Mikpongon og bayaꞌ ni Jan, tobalon non ita nog iduma buan ondaꞌ ita ma tud dianon? ");
INSERT INTO suc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tibua, bila sop toluꞌon ta nog tidu dia sog gotow og bayaꞌ non koyon, gomonsunoy og gotowanan koni dini mokpogbuat ilan mangka nilan ita botuoy. Poꞌ og tud nilan si Jan, ion og polomolatas nog taluꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dadi, tinumabal ilan nog ondiꞌ nilan kosunan bog ain miktidu og bayaꞌ non koyon. ");
INSERT INTO suc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dadi, miktaluꞌ sop si Isus nog, “Bila maꞌ nituꞌ, ondiꞌ u sop posunon dianiu bog sima og migbogoy dianakon nog bayaꞌ nog mokopoginang u nog maꞌ nini koni.” ");
INSERT INTO suc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tubus nion, miguksug nosop si Isus nog len pononggiꞌan sog gotowanan koyon dion. Maꞌ long non dun, “Ongon og gotow nog togo lupaꞌ nog pimulanan non nog bolagon nog ngalan non og paras. Tubus nituꞌ, piaksa non sog gotowanan, mangka ion panow sog len bonua. ");
INSERT INTO suc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Dangan minatong na og tang nog pongupuꞌon na og bunga nog pomulan non koyon, dinondag non sala kotow sosoligan non mangoy mongabat nog bahagiꞌ non dituꞌ sog gotowanan kituꞌ nog minaksa nog pomulan non koyon. Tibua, dangan ion minatong dituꞌ, pigdanog nog gotowanan koyon mangka nilan dondagoy muliꞌ nog daꞌidun tanan og mipitang non. ");
INSERT INTO suc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tubus nituꞌ, dinondag non nosop og len sosoligan non mangoy mongabat. Tibua, pigdanog nilan dosop ion bu solapsolapoy mangka nilan dondagoy muliꞌ nog daꞌidun mipitang non. ");
INSERT INTO suc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dadi, dinondag non nosop og kotolu mangoy mongabat. Tibua, maꞌ nituꞌ dosop og piginang nilan dianon mangka nilan ion bugowoy. ");
INSERT INTO suc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Dadi, miktaluꞌ og gapuꞌ nog glupaꞌ koyon nog, ‘Olo gidoy og pondayan ku? Maꞌ nini og pondayan ku! Popongoyon ku og bataꞌ u dituꞌ nog kololaman ku poꞌ tingala pogodaban nilan pa ion.’ ");
INSERT INTO suc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Tibua, dangan mitongow nilan og bataꞌ non koyon, mikpoksitaluꞌ ilan nog, ‘Koyon na, og bataꞌ nog gapuꞌ nog glupaꞌ koni. Bunuꞌon ta ion bagun da ita na og mokakod nog glupaꞌ non koni.’ ");
INSERT INTO suc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dadi, pigloguyud nilan dituꞌ sog molayuꞌ mangka nilan bunuꞌoy.” Dadi, maꞌ long ni Isus dun, “Olo gidoy og gondunon nog gapuꞌ nog glupaꞌ koyon dianilan? ");
INSERT INTO suc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ongoyon non pomunuꞌoy og minaksa koyon mangka non bogoyoy og glupaꞌ non koyon dia sog len gotowanan.” Og gotowanan koyon nog minginongog dia ni Isus, dangan midongog nilan og taluꞌ non koyon, mikponabal ilan nog, “Polosili le og maꞌ nion koyon!” ");
INSERT INTO suc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dadi, pigbontayan ilan ni Isus mangka non ilan sakoy nog, “Dadi, bila maꞌ nituꞌ buan, olo ma gidoy og poksabut niu sog sinulat kituꞌ dia sog Kitab nog, ‘Og batu kituꞌ nog mosolag nog pigbongkis nog polongimung nog baloy, miimung tanan nog bololagaꞌ nog polongkapan sog glam non.’ ");
INSERT INTO suc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Simasima og ombuksak sog batu koyon molupot nododaꞌ og glawas non. Bu ain sop og kolobuꞌan nog batu koyon, ompusat og glawas non dun.” ");
INSERT INTO suc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Dangan ion maꞌ nion, og polopanadanan nog botad nog bansa Hudyu bu og mokokotas nog boliananan koyon, moleg ilan bosia mukpaꞌ dia ni Isus nog sododuꞌun poꞌ misabut nilan nog ilan pigdolilan ni Isus koyon. Tibua, ondiꞌ nilan dosop minang poꞌ mondok ilan sog kodokolan nog gotowanan koyon dion. ");
INSERT INTO suc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Dadi, piktimaꞌanan nilan si Isus bu tinumindan ilan nog gotow nog baluꞌbaluꞌ moktantu ilan, poꞌ og pondayan nilan bagun nilan mosaꞌut si Isus bianan sog taluꞌ non mangka nilan ion uokiloy dia sog bayaꞌ nog gubernador. ");
INSERT INTO suc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dadi, miksak og gotowanan koyon dia ni Isus nog, “Polopanad, kosunan nami nog og piktaluꞌ mu koyon bu og pokponadon mu koyon dianami modulus. Bu kisunan nami dosop nog ondiꞌ a mogbigyaꞌ nog gotow. Bu og pikpanad mu dumalan dia sog polomotadon nog glegan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dadi buan, mogbayad ita taꞌ nog buis dia ni Sisar otawaka ondiꞌ?” ");
INSERT INTO suc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tibua, kisunan ni Isus bog olo og punan nilan koyon moksak. Dadi, tinabal non ilan nog, ");
INSERT INTO suc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Potongowoy niu dow akon nog sin. Sima og glodawan nog tinaguꞌ dia sog sin koyon? Bu sima og ngalan nog sinulat koyon dion?” ");
INSERT INTO suc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Long nilan dun, “Si Sisar ma.” Miktaluꞌ si Isus nog, “Dadi, bogoy niu dia ni Sisar ain dianon. Bu bogoy niu dosop dia sog Mikpongon ain dianon.” ");
INSERT INTO suc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Dadi, og gotowanan koyon, ondiꞌ nilan kopogolapsobapan si Isus dia sog kodokolan nog gotowanan bianan sog taluꞌ non. Bu sabap sog kisobuꞌan ilan dun, daꞌ ilan pokopogonekonek nog tabal ni Isus koyon. ");
INSERT INTO suc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ongon sadusiuanan dion minangoy moksak dituꞌ ni Isus. Og gotowanan koyon ondiꞌ ilan tumud nog ongon motubuꞌ tidu matoy. Dadi, miksak ilan dia ni Isus nog, ");
INSERT INTO suc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Polopanad, maꞌ long nog sinulat kituꞌ ni Muses dianita nog bila sala kopogduayan nog matoy og glaki non nog saka daꞌidun og bataꞌ nilan, sumboy og balulibun koyon pogduoyon nog pimikitan non bagun da bila mogbataꞌ ilan, mimung da maꞌ nog bataꞌ nilan nog glaki non kituꞌ tiganaꞌ. ");
INSERT INTO suc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ati, ongon pitu kotow mogilug nog lunsan laki. Og gulangbataꞌ koyon dianilan migduoy nog saka minatoy nog daꞌ ilan pa pogbataꞌ. ");
INSERT INTO suc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tubus nituꞌ, pigduoy nosop nog dumapit sog gulangbataꞌ ");
INSERT INTO suc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","og balulibun koyon saka minatoy nosop nog daꞌ ilan pa pogbataꞌ. Tubus nituꞌ, pigduoy nosop ion nog kotolu. Asta mipogduoy non og pitu kotow pomogilug koyon nog mikpomatoy ilan saka daꞌ ilan pogbataꞌ. ");
INSERT INTO suc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Daꞌ ion kobon, og balulibun koyon minatoy dosop. ");
INSERT INTO suc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Dadi, bila matong gondow nog potubuꞌon og gotowanan tidu matoy, sima ma og glaki nog glibun koyon saka og pitu kotow koyon mikobian mogduoy dianon?” ");
INSERT INTO suc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tinumabal si Isus nog, “Og gotowanan numun koni dini sog dunya glibun laki mokpogduoy. ");
INSERT INTO suc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tibua, sog binayaꞌ nog gondow, ain og patut potubuꞌon nog Mikpongon tidu matoy, ondiꞌ ilan na mokpogduoy ");
INSERT INTO suc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","poꞌ mamaꞌ ilan na nog moloikatanan nog Mikpongon poꞌ ondiꞌ ilan na matoy. Bu sabap nog pitubuꞌ ilan na nog Mikpongon tidu matoy, miimung ilan na nog gombataꞌanan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Poꞌ minsan si Muses mokotaksiꞌ nog ngon og motubuꞌ tidu matoy. Poꞌ kobon nituꞌ, sinulat non og taluꞌ nog Mikpongon nog midongog non dia sog polompung nog mitongow non mikpogligaꞌ. Iningolanan ni Muses og Pogbayaꞌ nog ion og poktomuyon kituꞌ ni Abraham, ni Isak, bu ni Jakub. ");
INSERT INTO suc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","“Og maꞌana nog tinaluꞌ non kituꞌ, og Mikpongon, konaꞌ ion og poktomuyon nog ain minatoy, sugaꞌid non, ain og totubuꞌ. Poꞌ ain og gotow nog dia non, og glam nilan totubuꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dadi, og duma polopanadanan nog botad nog bansa Hudyu mikpoktaluꞌ nog, “Polopanad, misugat tokodoy og tabal nika koyon!” ");
INSERT INTO suc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bu daꞌidun na ginumiluꞌ moksak mokpuliꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tubus nion, miksak si Isus dia sog polopanadanan koyon nog botad nog bansa Hudyu nog, “Olo gidoy og poktoluꞌon koyon nog og Kristu nog ion og pangkat ni Dabid? ");
INSERT INTO suc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Saka dia sog bobatan nog sinulat ni Dabid maꞌ nini og tinaluꞌ dun, ‘Og Pogbayaꞌ miktaluꞌ dia sog Kounutan ku, ingkud a sog dapit glintu u ");
INSERT INTO suc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asta imungon ku og bantaanan mu nog gindogan nog botis mu.’ ");
INSERT INTO suc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dadi, bila si Dabid, iningolanan non ma og Kristu nog Kounutan non, olo ma og kipongkatoy ni Dabid dianon?” ");
INSERT INTO suc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sonuk nog glam nog gotowanan mokinongog dia ni Isus, miktaluꞌ ion dia sog sulangguꞌanan non nog, ");
INSERT INTO suc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Pokpotubud amu dia sog polopanadanan nog botad nog bansa Hudyu poꞌ loliagon ilan monapot nog ponopoton nog molambak bila mokpanowpanow ilan poꞌ moleg ilan pogodaban bu golunon nog gotowanan bila dia ilan sog kosompagan. Bu bila dia ilan sog baloy nog poglumpukan nog bansa Hudyu, kolegan nilan dia ilan pingkudoy sog gingkudan nog mokokotas nog gotow. Bu maꞌ nituꞌ dosop bila dia ilan sog kologyaꞌan. ");
INSERT INTO suc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bu ginang nilan moglimbung dia sog balulibunanan bagun nilan malap og gakodanan nilan. Tubus nituꞌ, bila mogyakin ilan, popoyaton nilan tokodoy poꞌ baluꞌbaluꞌ molongas ilan da nog gotow. Tibua, sog gunan nog gondow, ombogat tokodoy og polihalaꞌ nog Mikpongon dia sog gotowanan koyon nog maꞌ nion.” ");
INSERT INTO suc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Dangan tinumingag si Isus, mitongow non og doyahananan solian nilan mokponulod nog bogoy nilan dia sog poktoguꞌan nog bogoy sog Mikpongon nog dia sog Baloy nog Poktomuyon koyon. ");
INSERT INTO suc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bu mitongow non dosop og balulibun nog miskinan tinumulod nog bogoy non dia sog Mikpongon golagaꞌ nog duaꞌ lad sin. ");
INSERT INTO suc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Dadi, miktaluꞌ si Isus nog, “Toluꞌon ku dianiu, og binogoy nog balulibun koyon labi pa dia sog bogoy nog duma gotowanan koyon dion. ");
INSERT INTO suc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Poꞌ og doyahananan koyon, saꞌan mikobogoy ilan poꞌ ngon dianilan. Tibua, og balulibun koyon, tinipot non mogbogoy og glam nog sukatan non.” ");
INSERT INTO suc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ongon dumaanan ni Isus dion nog pigdolit nilan og Baloy koyon nog Poktomuyan nog landuꞌ na kolongas og bantuk non poꞌ pimotangan nog batu koyon nog mokpogdilapdilap bu pingdoꞌitdoꞌitan nog pimogoy nog gotowanan dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Dadi, miktaluꞌ si Isus nog, “Og glam nog mitongow niu koyon, ngon gondow non, minsan solabuk siꞌoy og polongkapan non koyon nog batu, daꞌidun nododaꞌ mosamaꞌ dun dia sog kibotangan koyon poꞌ glam non koyon motipot pomoktugban.” ");
INSERT INTO suc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dadi, miksak og gotowanan koyon dia ni Isus nog, “Polopanad, nanu gidoy ion kotuman? Bu olo og gindanan dun nog posunguꞌ na motuman og pigolong mu koyon?” ");
INSERT INTO suc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tinumabal si Isus nog, “Pokpotubud amu bagun amu diꞌ kolimbungan. Poꞌ modakol og matong nog gomiton nilan og ngalan ku. Toluꞌon nilan nog ilan dow og Kristu. Bu moktaluꞌ ilan dosop nog minatong na og tang nog daliꞌ na bungkas. Tibua, naꞌ amu tokodoy mogunut dun. ");
INSERT INTO suc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bu bila ongon og modongog niu nog mogbunuꞌ bu og sasow, naꞌ amu kondokan dun poꞌ og glam non koyon sumboy nododaꞌ mian pa poguna. Tibua, konaꞌ pa ion og doksuꞌan.” ");
INSERT INTO suc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bu long pa ni Isus dun, “Og binonsaan mokpogbunuꞌ ilan bu ilan. Bu og pigdotuꞌan mantu dosop sog len pigdotuꞌan. ");
INSERT INTO suc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bu ongon dosop mian nog mosikad nog glinug, bu og gunus, bu og mosakit sog ainain nog bonua. Bu modakol og kosobuꞌsobuꞌ bu kondokondok nog gindanan nog motongow tidu sog glangit. ");
INSERT INTO suc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Tibua, mangka siꞌoy datong og glam nog pogolongon ku koni, pongukpaꞌan amu mangka solapsolapoy. Tubus nituꞌ, mangka nilan amu pitangoy sog baloyanan nog poglumpukan nog bansa Hudyu poꞌ ukumon nilan amu bu kolobusuoy. Pitangon nilan dosop amu dia sog kodotuꞌananan bu gubernadoranan sabap sog kopokokunut niu dianakon. ");
INSERT INTO suc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bu koyon og bianan niu mokopoguksug nog Gombaꞌis nog Guksugan dianilan. ");
INSERT INTO suc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tibua, sog daꞌ pa datong og tang koyon, popagon niu og pomikilan niu. Bu naꞌ amu mosusa bog olo og tabal niu dianilan. ");
INSERT INTO suc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Poꞌ bogayan ku da amu nog kotoan bagun amu moto tumabal dianilan, bagun da og minanta kituꞌ dianiu, diꞌ nilan amu kontuan. ");
INSERT INTO suc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bu sog tang koyon, minsan og mokogulang niu, bu og putupusodanan niu, bu og pigoloanan niu, bu og pakasibataꞌanan niu, ilan tanan og mogdang dianiu dia sog gukum. Bu og duma dianiu pomunuꞌon nilan tanan. ");
INSERT INTO suc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bu pokongitan amu nog glam nog gotowanan sabap sog kopokokunut niu dianakon. ");
INSERT INTO suc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tibua, ondaꞌidun da minsan sobalu siꞌoy og buk niu og moglaꞌat. ");
INSERT INTO suc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Saꞌan popagon niu og kopongandol niu poꞌ bila mokogaga amu, malap niu og kotubuꞌ nog daꞌ kopus non.” ");
INSERT INTO suc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Bu maꞌ long sop ni Isus dun, “Bila motongow niu na nog og Jerusalem poglibutan na nog sundaluanan nog banta nilan, dion kosunan niu na nog og bonua koyon daliꞌ na loꞌatoy. ");
INSERT INTO suc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bu sog tang koyon, ain og mikpogonong kituꞌ sog bonua nog Judia, sumboy mokpolaguy ilan na sog kobukidan. Bu ain og mikpogonong sog koliwagan bonua nog Jerusalem, sumboy lumuas ilan na. Bu ain sop dia sog glowasan, sumboy diꞌ ilan na sumolod puliꞌ. ");
INSERT INTO suc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Poꞌ ion non ion og pigolong kituꞌ nog posinsa og kotumanan nog sinulat kituꞌ dia sog Kitab. ");
INSERT INTO suc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sog tang koyon, kololatlolat ain bodosanan bu ain og tigubataꞌ poꞌ ngon og kolumbeketan nilan. Poꞌ landuꞌ og sinsaan dia sog bonua koni sabap sog polihalaꞌ nog Mikpongon dia sog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bu og duma dianilan pomunuꞌon bianan sog kalis. Bu og duma pomihagon mangka pitangoy sog glam nog bonuaanan sog gliwag nog dunya. Bu og Jerusalem poglogekon na nog gotowanan nog konaꞌ Hudyu, asta motoktub na og kopogbayaꞌ nilan sog bonua koyon.” ");
INSERT INTO suc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Maꞌ long sop ni Isus, “Bu ongon og gindanananan nog kosobuꞌsobuꞌ dia sog gondow, dia sog bulan, bu dia sog bitunanan. Bu ain dia sog glupaꞌan, ngon og binonsaan nog mosusa bu kondokan sabap sog doguk nog nabok sog dagat nog landuꞌ na koluksang. ");
INSERT INTO suc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bu og gotowanan sog tang koyon, kowaꞌan ilan nog tulik sabap sog gondok nilan poꞌ mosusa ilan bog olo gidoy og kodoksuꞌan nog mokpogdatong koni sog dunya. Poꞌ minsan og gondow bu og bulan bu og bitunanan, moksop na og botang nilan. ");
INSERT INTO suc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sog tang koyon, motongow nilan og Binataꞌ sog Kilawan posunguꞌ matong mogunut dia sog ginampol, bu dunut landuꞌ silow og kotas nog bayaꞌ non. ");
INSERT INTO suc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dadi, bila moktolipun na motuman og glam nog piktaluꞌ u koni dianiu, simpan niu og pomikilan niu bu pogloliag amu poꞌ daliꞌ amu na gowonoy nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tubus nituꞌ, miguksug nosop si Isus nog pononggiꞌan dianilan, “Pikil niu poloꞌma og kayu koyon nog ngalan non og igera, bu asta glam nog kayuanan. ");
INSERT INTO suc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bila motongow niu nog migbogudawon na, kosunan niu na nog daliꞌ na og timpu podos. ");
INSERT INTO suc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Domikian dosop nog bila motongow niu na og glam nog piktaluꞌ u koni mituman na, kosunan niu nog daliꞌ na datong og kopogdatuꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Poꞌ toluꞌon ku dianiu, mangka siꞌoy kotipot pomatoy og gotowanan numun koni, motuman na og glam nog piktaluꞌ u koni dianiu. ");
INSERT INTO suc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Og glangit bu glupaꞌan solianlian da, tibua, og taluꞌ u moksampoyumul nododaꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Bu miktaluꞌ sop si Isus nog, “Pokpotubud amu tokodoy bagun og pikilan niu diꞌ moit sog gloliag nog dinunya, mamaꞌ nog moglangulangu, otawaka kosusa nog kotubuꞌ niu. Poꞌ bila matong og gondow nog matong u, gomonsunoy kotokowan amu dun, mamaꞌ nog mitaban amu nog giman. ");
INSERT INTO suc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Poꞌ og gondow koyon matong nododaꞌ sog glam nog gotowanan sog gliwag nog dunya koni. ");
INSERT INTO suc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Saꞌan sumboy kobon non pongmohilat amu mangka amu pogyakin bagun amu bogayan nog Mikpongon nog pagas moglogaga nog glam nog posunguꞌ koyon matong, bu bagun amu dosop mokopongadap dia sog Binataꞌ sog Kilawan.” ");
INSERT INTO suc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Dadi, gondow gondow si Isus mokpanad dia sog Baloy nog Poktomuyan dia sog Mikpongon. Bu bila gobi, dituꞌ ion pogonong sog bulud nog Olibu. ");
INSERT INTO suc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bu og gotowanan sop, mosolom ilan dituꞌ sog Baloy nog Poktomuyan mangoy monginongog nog gustalan ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sog tang koyon, daliꞌ na datong og kologyaꞌan nog bansa Hudyu nog ngalan non Pan Nog Daꞌ Potulinoy bu og koduaꞌ ngalan non og Liniusan. ");
INSERT INTO suc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Og mokokotas nog boliananan bu og polopanadanan nog botad nog bansa Hudyu, kobon non monontong ilan nog pondayan nilan bagun nilan ombunuꞌ si Isus poꞌ mondok ilan mokpogulek og gotowanan. ");
INSERT INTO suc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tubus nituꞌ, og sala kotow sog sopuluꞌ bu duaꞌ sulangguꞌanan ni Isus koyon nog si Judas Iskariot, sinongonan ni Kindagow. ");
INSERT INTO suc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dadi, minangoy si Judas sog mokokotas nog boliananan bu dia sog kounutananan nog polongipat nog Baloy nog Poktomuyan dia sog Mikpongon. Inangoy non ilan upokatoy bog olo og bianan non muakil dia ni Isus dianilan. ");
INSERT INTO suc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Dadi, dangan midongog nog gotowanan koyon og taluꞌ ni Judas, mikpogdaꞌdaꞌ ilan, bu piksolobukan nilan nog tindanan nilan ion. ");
INSERT INTO suc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Bu dangan sinumanguꞌ na si Judas dun, pingontongan non nog pondayan bagun non muakil si Isus dianilan nog mondom diꞌ kosunan nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Dadi, minatong og gondow nog kologyaꞌan nilan koyon nog Pan Nog Daꞌ Potulinoy. Bu og gondow koyon, momalas ilan dosop nog nati nog bilibili nog sinimpan dia sog ginang nilan koyon nog ngalan non Liniusan. ");
INSERT INTO suc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dadi, sinuguꞌ ni Isus og duaꞌ kotow sulangguꞌ non nog si Piter bu si Jan, nog mangoy ilan moksimpan nog globungan nilan nog iningolanan nilan Liniusan. ");
INSERT INTO suc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dadi, miksak ilan nog, “Ain nika ma ami dondagoy moksimpan nog globungan koyon?” ");
INSERT INTO suc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tinumabal si Isus nog, “Bila matong amu sog koliwagan bonua koyon, ongon lumumpak dianiu nog glaki pokpisan nog baꞌing. Bu pogunut amu sog baloy nog ain solodan non. ");
INSERT INTO suc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Bu mangka niu taluꞌ sog gapuꞌ nog baloy koyon nog, ‘Og Polopanad miksak bog ain dow og dugu kituꞌ nog poglobunganan nilan nog sulangguꞌanan non sog gondow nog Liniusan?’ ");
INSERT INTO suc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Bu potongowon non da dianiu og mosolag nog dugu dia sog ditas nog baloy koyon sog koduaꞌ lengkat non. Sagad na og glam non dituꞌ og botangan niu nog globungan. Dituꞌ niu pogasip og glam non.” ");
INSERT INTO suc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dadi, mipanow og sulangguꞌanan koyon bu mitongow nilan dodaꞌ og glam nog piktaluꞌ ni Isus kituꞌ dianilan. Dadi, pigasip nilan og globungan koyon nog iningolanan nog Liniusan. ");
INSERT INTO suc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Dangan miglobungan ilan na, si Isus ilan nog sosuguꞌonanan non, mikpongadap ilan na dia sog dulang koyon. ");
INSERT INTO suc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Miktaluꞌ si Isus dianilan nog, “Maꞌ nini loꞌ og glegan ku tokodoy nog mangka u siꞌoy kosinsa, mogadap ita pa poguna kuman nog dulang koni nog Liniusan. ");
INSERT INTO suc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Toluꞌon ku dianiu, nog ondiꞌ u na kuman dun mokpuliꞌ tontal da nog diꞌ motuman og tantu maꞌana nini dituꞌ sog pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Inimud ni Isus og saguk koyon dion bu posolomatoy sog Mikpongon mangka ion poktaluꞌ dianilan nog, “Tabuk niu ini mangka niu pogbobahagiꞌ. ");
INSERT INTO suc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Poꞌ toluꞌon ku dianiu, nog ondiꞌ u na minum nini mokpuliꞌ tontal da diꞌ matong og pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mangka non nosop imudoy og pan koyon bu posolomatoy sog Mikpongon mangka non pomitakoy bu pomogoyoy dianilan kobon non moktaluꞌ nog, “Koni og glawas u nog bogoyon ku nog poglokat dianiu. Inang niu ini nog pomondoman niu dianakon.” ");
INSERT INTO suc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Bu maꞌ nituꞌ dosop, dangan mitubus ilan moglobungan, inimud non nosop og saguk kituꞌ mangka poktaluꞌ nog, “Og saguk koni og tandaꞌ nog bogu pasad nog Mikpongon dianiu bu og duguꞌ u nog ombuyus miimung og pagon non dia sog koboꞌisan niu. ");
INSERT INTO suc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tibua, og gotow kituꞌ nog posunguꞌ muakil dianakon sog glaꞌat, migadap ami kuman numun kituꞌ! ");
INSERT INTO suc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Poꞌ og Binataꞌ sog Kilawan matoy nododaꞌ poꞌ maꞌ nituꞌ og bayaꞌ nog Mikpongon. Tibua, kondokondok tokodoy og doksuꞌan nog gotow koyon nog mongulaꞌat dianon.” ");
INSERT INTO suc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dadi, mikpoksinaksakoy ilan bu ilan bog sima gidoy ion og pogolongon non koyon. ");
INSERT INTO suc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tubus nituꞌ, mikpoksusi og sulangguꞌanan non koyon bog sima dianilan mimung og motas. ");
INSERT INTO suc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dadi, miktaluꞌ si Isus dianilan nog, “Og kodotuꞌan nog konaꞌ Hudyu, pogboyaꞌan nilan og pigotowan nilan. Bu ain og mikpogbayaꞌ kituꞌ, ginolal nilan og dili glawas nilan nog Musibaꞌ nog Pakasi non. ");
INSERT INTO suc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tibua amu, naꞌ amu moglogiling dianilan. Sugaꞌid non, ain og motas dianiu, sumboy ion maꞌ nog kongudan sog glam non. Bu ain og moglokounutan, sumboy ion maꞌ nog sosuguꞌon. ");
INSERT INTO suc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Poꞌ sima buan og motas, og kinuman otawaka og migdulang koyon dianon? Motas nododaꞌ ain og kinuman. Tibua akon, dini u nog mikologad u dianiu. ");
INSERT INTO suc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Poꞌ amu og minunung dianakon sog glam nog glogon nog kibianbianan ku. ");
INSERT INTO suc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Dadi, bogayan ku amu nog bayaꞌ moglokounutan mamaꞌ dosop nog binogoy nog Gamaꞌ u dianakon nog bayaꞌ moglokounutan ");
INSERT INTO suc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","bagun amu da mokadap dianakon kuman bu minum dia sog pigdotuꞌan ku. Bu mingkud amu dosop sog gingkudan datuꞌ mongukum dia sog sopuluꞌ bu duaꞌ pangkat ni Apuꞌ Israel.” ");
INSERT INTO suc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tubus nion, miktaluꞌ si Isus dia ni Piter nog, “Simun, pokinongog a. Si Kindagow tinugdak nog Mikpongon sumisig dianiu poꞌ bagun kosunan bog sima og mosiboy. ");
INSERT INTO suc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tibua, pigyokinan ku ika Simun, dia sog Mikpongon nog ondiꞌ ombolong og tud mu. Tibua, gumuyaꞌ siꞌoy og kopongandol mu, sog tang nog mokpuliꞌ a dianakon, pongimogonoy mu og kopongandol nog pigilugananan mu koni.” ");
INSERT INTO suc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tinumabal si Piter nog, “Kounutan ku, unungan ku nododaꞌ ika minsan siꞌoy sog kolobusuan asta sog kopotayan.” ");
INSERT INTO suc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tinabal ion ni Isus nog, “Toluꞌon ku dianika Piter, mangka siꞌoy poktukalaꞌ og manuk bombus, tolu kali mu na akon sonsingoy nog diꞌ mu akon kilolaan.” ");
INSERT INTO suc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tubus nion, sinakan ni Isus og sulangguꞌanan non koyon nog, “Sog dinondag u kituꞌ amu ompanow nog pigondiꞌan ku amu mokpitang nog sin, bu og toguꞌan nog balan, bu og pongyapak, kiondaꞌan amu taꞌ nog minsan olo?” Sokaliꞌ ilan tinumabal, “Ondaꞌ ma!” ");
INSERT INTO suc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dadi, miktaluꞌ si Isus, “Motud ion. Tibua, numun koni miksop na. Dadi, ain dianiu nog togo sin otawaka togo toguꞌan nog balan, sumboy pitangon non bila ompanow. Bu ain dianiu nog daꞌidun og kalis non, sumboy poksaluy non og glogdoy non bagun pa mokosaluy nog kalis. ");
INSERT INTO suc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Poꞌ toluꞌon ku dianiu nog sumboy motuman dianakon og sinulat kituꞌ sog Kitab nog, ‘Sinunuꞌ ion dia sog mokolaton nog gotow.’ Poꞌ og sinulat kituꞌ paꞌali dianakon, posunguꞌ na motuman.” ");
INSERT INTO suc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tubus nituꞌ, miktaluꞌ og sulangguꞌanan koyon nog, “Kounutan, ongon og duaꞌ buk kalis nami dini.” Dadi, tinumabal si Isus, “Pada na!” ");
INSERT INTO suc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tubus nituꞌ, linumuas si Isus mangka angoy sog bulud nog Olibu poꞌ maꞌ nituꞌ og kiloyaman non. Bu og sulangguꞌanan non migunut dianon. ");
INSERT INTO suc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dangan minatong ilan sog bulud koyon, miktaluꞌ si Isus dianilan nog, “Pogyakin amu bagun amu ondiꞌ koyubaꞌan.” ");
INSERT INTO suc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mangka ion angoy sog molayuꞌlayuꞌ lomon lomon mosampot lobakoy nog batu mangka ingluꞌud mogyakin nog, ");
INSERT INTO suc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Amaꞌ, somoꞌ mosuꞌat da dianika, naꞌ mu na akon pobianon sog sinsaan ku koni posunguꞌ. Tibua, sumboy konaꞌ og glegan ku og motuman, sugaꞌid non, og glegan mu.” ");
INSERT INTO suc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bu og moloikat tidu sog Mikpongon tinumuaꞌ dion mongimagon dianon. ");
INSERT INTO suc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sabap sog kobogat nog susaan non koyon, posisayaꞌ ion ponamal mogyakin boyaꞌan mikpoktolong tanan og gulas non mamaꞌ nog duguꞌ. ");
INSERT INTO suc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Dangan migbuat ion tidu mogyakin, mikpuliꞌ ion dituꞌ sog sulangguꞌanan non bu mitongow non ilan nog mikponulug sabap sog glupugan nilan momikil nog susaan nilan koyon. ");
INSERT INTO suc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dadi, miktaluꞌ si Isus nog, “Iduma ion mokponulug amu ma? Pogbuat amu na mangka amu pogyakin bagun amu ondiꞌ koyubaꞌan.” ");
INSERT INTO suc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sonuk pa ni Isus moktaluꞌ, mikponuaꞌ na og modakol nog gotowanan. Bu og sala kotow sog sopuluꞌ bu duaꞌ sulangguꞌanan ni Isus nog ngalan non si Judas, og minuluꞌ dia sog gotowanan koyon. Bu miglandan ion mokpolani dia ni Isus mangka non olokoy. ");
INSERT INTO suc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tibua, sinakan ion ni Isus nog, “Judas, bianan taꞌ sog galok mu koyon og kopongulaꞌat mu dia sog Binataꞌ sog Kilawan?” ");
INSERT INTO suc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Dangan mitongow nog dumaanan ni Isus og posunguꞌ koyon inangon dianon, miksitaluꞌ ilan nog, “Kounutan, olo maꞌ nini, ponigbason nami na ilan nog kalis nami koni?” ");
INSERT INTO suc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bu og sala kotow dianilan tinigbas non og sosoligan koyon nog kounutan nog boliananan dion boyaꞌan misikpoy tanan og tolinga non dapit sog glintu. ");
INSERT INTO suc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Dadi, miktaluꞌ si Isus nog, “Pada na!” Bu kobon ni Isus mikap nog tolinga nog glaki koyon, bu kiuliꞌan doma. ");
INSERT INTO suc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tubus nion, tinoluꞌan ni Isus og mokokotas nog boliananan, bu og kounutananan nog polongipat nog Baloy nog Poktomuyan, bu og kobogolalan koyon dion nog minangoy mukpaꞌ dianon nog, “Og polonglaꞌug u taꞌ nog mangoy amu dini nakon nog mokpogoit amu poma nog kalisanan bu og bobombalanan? ");
INSERT INTO suc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gondow gondow mokunul ita dia sog Baloy nog Poktomuyan dia sog Mikpongon, saka daꞌ niu poma akon ukpaꞌoy dituꞌ? Tibua, koni minatong na dodaꞌ og tang poꞌ mogbayaꞌ pa og bayaꞌ nog kodoloman.” ");
INSERT INTO suc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tubus nion, inukpaꞌan nilan na si Isus mangka nilan pitangoy dituꞌ sog baloy nog kounutan nog boliananan. Bu miguyukuyuk si Piter dia sog binayaꞌ non. ");
INSERT INTO suc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dangan minatong ilan sog glomalomaan nog baloy koyon, miktagun og gotowanan sog titongaꞌ mangka ilan pongingkud dion poꞌ minalang ilan. Si Piter sop koni mikpolani dion mangka ampuꞌ mingkud monalang dianilan. ");
INSERT INTO suc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ongon og sala kotow glibun og sosoligan dion. Dangan mitongow non si Piter nog minampuꞌ dion, pigimotimot non ion mangka poktaluꞌ nog, “Og gotow koni, og duma dosop nog inukpaꞌan koyon.” ");
INSERT INTO suc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tibua, si Piter minonsing nog, “Konaꞌ bole! Diꞌ u tanan ion kilolaan.” ");
INSERT INTO suc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Daꞌ kobon, mitongow nosop ion nog len gotow bu tinoluꞌan dosop ion nog, “Ika siꞌoy, og duma a modosop nilan!” Tibua, tinumabal si Piter nog, “Konaꞌ u bole!” ");
INSERT INTO suc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Daꞌ nosop ion kobon, ongon nosop gotow nog dinoksol non tumaluꞌ dia ni Piter nog, “Ain sog motud, og gotow koni, og duma non nododaꞌ poꞌ salu bonua ilan nog gotow Galili!” ");
INSERT INTO suc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tibua, tinumabal nosop si Piter nog, “Toluꞌon ku dianika, daꞌidun tokodoy og sinisabut u nog poktoluꞌon mu koyon!” Sintak non, sonuk pa ni Piter moktaluꞌ, gomonsunoy miktukalaꞌ og manuk. ");
INSERT INTO suc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dadi, tinontong mogdayun ni Isus si Piter bu migbangmata ilan. Bu kilobotan mogdayun ni Piter og glam nog tinaluꞌ ni Isus kituꞌ dianon nog, “Mangka siꞌoy poktukalaꞌ og manuk bombus, tolu kali mu na akon sonsingoy nog diꞌ mu akon kilolaan.” ");
INSERT INTO suc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dadi, linumiu si Piter mangka poglulad. ");
INSERT INTO suc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Og gotowanan koyon nog migipat dia ni Isus, sinolapsolap nilan ion mangka nilan pokposokitoy. ");
INSERT INTO suc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bu binunti nilan ion mangka nilan sakoy, “Atuk mu dow buan bog sima og sinumuntuk koyon dianika!” ");
INSERT INTO suc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bu miglologinis pa nog tompolaꞌ og gininang nilan dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Dangan migbolomaꞌ ion, og kobogolalan nog bansa Hudyu, bu og mokokotas nog boliananan, bu og polopanadanan nog botad nog bansa Hudyu, miglumpuk ilan. Bu si Isus pinitang sog sunguꞌan nilan, mangka nilan ion poksumodiaoy nog, ");
INSERT INTO suc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Taluꞌ mu bog motud taꞌ dodaꞌ nog ika og Kristu!” Tinumabal si Isus nog, “Bila toluꞌon ku dianiu, ondiꞌ amu da tumud dun. ");
INSERT INTO suc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Bu bila sakan ku amu, ondiꞌ niu dosop akon tobalon. ");
INSERT INTO suc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tibua, moktolipun numun kituꞌ, og Binataꞌ sog Kilawan pingkudon na ion dia dapit sog glintu nog Pogbayaꞌ nog ion diꞌ kobotukan.” ");
INSERT INTO suc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dadi, og gotowanan koyon mikpoglongag ilan moksak nog, “Bila maꞌ nituꞌ buan, og Bataꞌ a buan nog Mikpongon?” Tinumabal si Isus nog, “Maꞌ nog tinaluꞌ niu koyon.” ");
INSERT INTO suc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dadi, mikpoktaluꞌ og gotowanan koyon nog, “Ondaꞌidun na kobalan ta nog duma pa taksiꞌ poꞌ midongog ta na og dili taluꞌ non!” ");
INSERT INTO suc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tubus nituꞌ, og glam nog mikpoglumpuk koyon dion mikpogbuat ilan mangka nilan pitangoy si Isus dituꞌ ni Pilatu. ");
INSERT INTO suc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dangan minatong ilan dituꞌ, sinumbung nilan ion. Maꞌ long nilan dun, “Inukpaꞌan nami og gotow koni poꞌ pinuluꞌan non og gotowanan sumimoy dia sog botad nami bu pigondiꞌan non ilan mogbayad nog buis dia ni Datuꞌ Sisar. Bu long non dun, ion dow og Kristu nog Tinonduꞌ nog Mikpongon Mogdatuꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dadi, sinakan ni Pilatu si Isus nog, “Motud taꞌ nog ika og datuꞌ nog bansa Hudyu?” Tinumabal si Isus nog, “Mamaꞌ nog tinaluꞌ mu koyon.” ");
INSERT INTO suc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dadi, si Pilatu miktaluꞌ dia sog mokokotas nog boliananan koyon bu dia sog kodokolan nog gotow nog, “Daꞌidun mitongow u nog motud og sumbungan niu koyon dianon.” ");
INSERT INTO suc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tibua, tinogol nilan da ituꞌ dianon nog, “Og gotowanan sog gliwag nog Judia misasow sabap sog pikpanad non. Miktolipun ion dituꞌ sog Galili asta midopot dini sog Jerusalem koni.” ");
INSERT INTO suc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Dangan midongog ni Pilatu og maꞌ nion koyon, sinak non dianilan nog si Isus og gotow Galili taꞌ. ");
INSERT INTO suc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Dadi, dangan kisunan non nog si Isus dia misakup sog pigdotuꞌan ni Herod, dinondag non mogoit si Isus dituꞌ ni Herod. Poꞌ kitangan nog dituꞌ dosop ion sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Dangan mitongow ni Herod si Isus, kisuꞌatan tokodoy ion dun poꞌ miobon na nog pongosamon non ion nog moktongow ilan ni Isus. Poꞌ sabap sog midongog non paꞌali dia ni Isus, dodomaan non nog motongow non ion moginang nog ginang nog kosobuꞌsobuꞌ. ");
INSERT INTO suc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Dadi, modakol og sak ni Herod dia ni Isus. Tibua, daꞌ ion tabal. ");
INSERT INTO suc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bu dion dosop og mokokotas nog boliananan, bu og polopanadanan nog botad nog bansa Hudyu, bu minamal ilan moksumbung paꞌali dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dadi, si Herod bu og sundaluanan non, pigwanwan nilan si Isus bu pogundaundaoy mangka nilan posolugoy nog ponopoton nog datuꞌ mangka non dondagoy nog pitangon nilan mokpuliꞌ si Isus dituꞌ ni Pilatu. ");
INSERT INTO suc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bu miktolipun sog gondow koyon, si Herod ilan ni Pilatu nog migbanta bosia, miglokopia na. ");
INSERT INTO suc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Dangan minatong ilan dituꞌ ni Pilatu, pilumpuk non og mokokotas nog boliananan, bu og kobogolalan nog bansa Hudyu, bu og gotowanan, ");
INSERT INTO suc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","mangka ion poktaluꞌ dianilan nog, “Koni, inoit niu dini nakon og gotow koni mangka amu poktaluꞌ nog ion dow og piksobapan nog saꞌan misasow og gotowanan dun. Dadi, sinakan ku ion kopia sog sunguꞌan niu. Tibua, ondaꞌidun motongow u sog sumbungan niu dianon nog komotudan ion dun. ");
INSERT INTO suc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Bu minsan si Herod maꞌ nituꞌ dosop. Saꞌan pipuliꞌ non dini nami og gotow koni. Dadi, og gotow koni, daꞌidun miinang non nog patut ion bunuꞌon. ");
INSERT INTO suc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Sugaꞌid non, tugdakon ku ion nog pogdonogon ion tibua mangka u ion na poluasoy.”  ");
INSERT INTO suc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Giap matong og kologyaꞌan koyon nog iningolanan nog Liniusan, ongon sala kotow og kinolobusu nog poluason. ");
INSERT INTO suc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tibua, og gotowanan koyon mikpoglongag ilan moglogapis nog, “Bunuꞌ mu ion! Poluas mu si Barabas dianami!” ");
INSERT INTO suc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Si Barabas, saꞌan ion mikolobusu poꞌ ion og miglokounutan moksasow sog koliwagan bonua koyon bu mikobunuꞌ.) ");
INSERT INTO suc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tibua, si Pilatu, og kolegan non bosia nog poluason si Isus. Dadi, pinuliꞌan non mogbubut dianilan. ");
INSERT INTO suc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tibua, posisayaꞌ nilan tanan posikadoy og kopoglogapis nilan nog, “Kudus mu ion! Kudus mu ion!” ");
INSERT INTO suc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tubus nion, sog kotolu kali non, miktaluꞌ nosop si Pilatu nog, “Iduma? Olo buan og salaꞌ nog miinang nog gotow koni? Akon, ondiꞌ u ion tokodoy kotongowan nog salaꞌ nog boyaꞌan patut ion bunuꞌon dun. Dadi, tugdakon ku nog pogdonogon ion mangka ion poluasoy.” ");
INSERT INTO suc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tibua, og gotowanan koyon posisayaꞌ nilan tanan posikadoy og gapis nilan nog sumboy ion kuduson. Dadi, sabap sog daꞌ ilan na lotaꞌ moglogapis ");
INSERT INTO suc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","mipikil ni Pilatu nog tugdakon non na dianilan og glegan nilan koyon. ");
INSERT INTO suc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Dadi, piluas non dianilan og gotow kituꞌ nog kounutan moksasow sog bonua koyon bu mikobunuꞌ poꞌ maꞌ nituꞌ og pigbubut nilan, mangka non uokiloy si Isus dia sog ain glegan nilan kituꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dadi, pinitang nilan lumiu si Isus posunguꞌ sog glowasan nog koliwagan bonua koyon. Sintak nilan ompanow, mitongow nilan si Simun nog gotow Sirini tidu sog bukid posunguꞌ sog Jerusalem. Ginanggut nilan mangka nilan popisanoy nog kudus bu podunutoy dia sog binayaꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bu modakol og gotowanan mikpogunut dianon, bu asta og kolibunanan nog mikponglangos dianon. ");
INSERT INTO suc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bu liningoy ni Isus og kolibunanan koyon mangka non ilan toluꞌoy nog, “Amu, kolibunanan dini sog Jerusalem, naꞌ niu akon longosan. Sugaꞌid non, kosusa amu nog glawas niu bu gombataꞌanan niu. ");
INSERT INTO suc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Poꞌ ongon gondow non, mokpoktaluꞌ amu nog mogdaꞌdaꞌ og kolibunanan kituꞌ nog daꞌ sibon pogbataꞌ bu daꞌ sibon pogduduꞌoy. ");
INSERT INTO suc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sog gondow koyon, mokpoktaluꞌ og gotowanan dia sog kodungusan nog, ‘kodigbun amu dianami!’ ");
INSERT INTO suc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bila ininang ma nog gotowanan og maꞌ nini koni sog sonuk nog kayu milow pa, olo gidoy og mogandun dun sog gunanunan koyon bila migangu na.” ");
INSERT INTO suc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ngon dosop duaꞌ kotow og mokolaton og kohinangan non nog sunuꞌon nilan munuꞌ dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dangan minatong ilan sog bonua koyon nog iningolanan og Bakuk nog Gulu, dion nilan kinudus si Isus, bu asta og duaꞌ kotow kituꞌ nog mokolaton og kohinangan nilan. Og sala kotow dia dapit sog glintu, sala kotow sop dia dapit sog bibang. ");
INSERT INTO suc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tubus nion, miktaluꞌ si Isus nog maꞌ nini, “Amaꞌ, ompunoy mu ilan poꞌ ondaꞌ nilan kosunoy og gininang nilan koni.” Tubus nion, pigbobahagiꞌ nilan og ponopoton non koyon bianan sog moglogindanan. ");
INSERT INTO suc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bu og kodokolan nog gotowanan koyon dion, mikpogindog ilan mogbantoy bu og kobogolalan koyon pigwanwan nilan ion. Maꞌ long nilan dun, “Mitabang non og duma gotow. Dadi, bila motud nog ion dodaꞌ og piniliꞌ kituꞌ nog Mikpongon nog Kristu, tontongon ta bog kotobangan non taꞌ dodaꞌ og dili glawas non!” ");
INSERT INTO suc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bu mikpolani dianon og sundaluanan koyon mangka nilan ion pogwanwanoy bu tinulunan nilan ion nog glanggow ");
INSERT INTO suc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kobon nilan moktaluꞌ nog, “Bila motud nog ika dodaꞌ og datuꞌ nog bansa Hudyu, tobangoy mu dow buan og glawas mu!” ");
INSERT INTO suc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bu ongon sinulat nog pitapok sog kudus dia sog ditas nog gulu non nog maꞌ nini, “Koni og Datuꞌ nog Bansa Hudyu.” ");
INSERT INTO suc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tubus nion, og sala kotow kituꞌ molaton og kohinangan non nog pidopa sog kudus, pigwanwan non si Isus. Long non dun, “Konaꞌ taꞌ nog ika dow og Kristu? Bila motud, tobangoy mu dow buan og dili glawas mu asta ami.” ");
INSERT INTO suc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tibua, og sala kotow koyon, pimag non og duma non koyon nog, “Iduma moktaluꞌ a ma nog maꞌ nion? Diꞌ a taꞌ mondok dia sog Mikpongon nog ita migbatuk og koukuman dianita? ");
INSERT INTO suc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Saka ion, daꞌidun tokodoy og miinang non nog molaton. Tibua ita, og gininang koni dianita og tumbas ini nog kohinangan ta.” ");
INSERT INTO suc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tubus nion, miktaluꞌ og gotow koyon dia ni Isus nog, “Isus, pikil nika da akon suꞌusa bila matong a na dituꞌ sog pigdotuꞌan mu.” ");
INSERT INTO suc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Dadi, tinabal ion ni Isus, “Toluꞌon ku dianika, gondow koni mokunul ita dituꞌ sog pogonongan kituꞌ nog landuꞌ kolongas.” ");
INSERT INTO suc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Midopot tasondow, migdolom og tibuk nog bonua asta ginongaꞌ monog gondow. ");
INSERT INTO suc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Poꞌ og gondow ondaꞌ silow. Bu og ponopoton kituꞌ nog modikpol nog bolot sog Baloy nog Poktomuyan dia sog Mikpongon, mibogyang poginongaꞌ. ");
INSERT INTO suc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Bu si Isus miktaluꞌ nog mosikad nog, “Amaꞌ, uokilon ku na dianika og glimukud u!” Miluksad tibua og taluꞌ non koyon, mitoktus ion. ");
INSERT INTO suc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Og kounutan sop nog sundaluanan koyon, dangan mitongow non og bianbian nog kopatoy ni Isus koyon, mikopoksanglit ion dia sog Mikpongon, mangka ion poktaluꞌ nog, “Motud dodaꞌ midulus og gotow koni!” ");
INSERT INTO suc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Dangan mitongow nog glam nog gotowanan koyon nog miglumpuk mogbantoy dion og bianbian koyon, mikponguliꞌ ilan kobon nilan moksampak nog gigdob nilan kobal nog susaan nilan. ");
INSERT INTO suc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tibua, og glam nog gotowanan nog mikosun dia ni Isus asta og kolibunanan kituꞌ nog mikpogunutunut dianon tidu pa sog Galili, mikpogindog ilan sog molayuꞌlayuꞌ mogbantoy nog glam nog bianbian koyon. ");
INSERT INTO suc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Bu ongon sala kotow dion og ngalan non si Jusep. Ion siꞌoy og polongukum dosop og sakup nog gukum nog bansa Hudyu. Ombaꞌis ion nog gotow bu midulus. ");
INSERT INTO suc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Daꞌ ion solabuk nog gupakat nilan koyon bu kohinangan nilan koyon. Bu migdodama ion nog pigdotuꞌan nog Mikpongon. Dituꞌ ion miktidu sog Arimatea nog sakup nog bonua nog Judia. ");
INSERT INTO suc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Inangoy non pogbubutoy dituꞌ ni Pilatu og bangkoy ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Dadi, inangoy non polusoy og bangkoy ni Isus koyon dia sog kudus bu putusoy nog bulus, mangka non botangoy og bangkoy koyon sog globong kituꞌ nog donsamaꞌ na linuangan nilan dia sog pampang nog daꞌidun pa linobong dun. ");
INSERT INTO suc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Og gondow koyon gondow Dyomaꞌat. Mogbolomaꞌ ion og Gondow nog Pogulali. ");
INSERT INTO suc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bu og kolibunanan koyon nog mikpogunut dia ni Isus tidu sog Galili, mikpogunut ilan dosop dia ni Jusep mangoy lumobong dia ni Isus. Dadi, mitongow nilan ain ion tinaguꞌ bu og bayuꞌbayuꞌ nog kolobong dianon. ");
INSERT INTO suc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tubus nituꞌ, minuliꞌ ilan mangka ilan poksimpan nog pogomut bu og glana momut. Tibua, dangan minatong og Gondow nog Pogulali, minulali ilan poꞌ inunut nilan og botad. ");
INSERT INTO suc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dangan migdaliꞌondow nog moglogondow Duminggu, og kolibunanan koyon, minangoy ilan dituꞌ sog binotangan nog bangkoy ni Isus. Bu pinitang nilan og piksimpan nilan kituꞌ nog pogomut. ");
INSERT INTO suc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dangan minatong ilan dion, mitongow nilan og batu kituꞌ nog piktimpong nog globong ni Isus, nog linilid na. ");
INSERT INTO suc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bu dangan sinumolod ilan, mitongow nilan nog daꞌ na dia og bangkoy ni Isus kituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dadi, sonuk nilan koyon mogindog nog kisobuꞌan ilan, gomonsunoy pa ongon duaꞌ kotow kolokian nog mikpoglamag og ponopoton nilan nog minindog sog molani nilan. ");
INSERT INTO suc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Dadi, sabap sog gondok nilan koyon dun, mikpongombaꞌ ilan sog glupaꞌ. Tibua, og kolokian koyon miktaluꞌ nog, “Iduma ponontongon niu ma og gotow nog totubuꞌ sog globong? ");
INSERT INTO suc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ondaꞌ ion dini poꞌ mitubuꞌ ion puliꞌ. Poktitukoy niu og taluꞌ non kituꞌ dianiu kobon nog dituꞌ pa ion niu sog Galili nog, ");
INSERT INTO suc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","og Binataꞌ sog Kilawan, sumboy uokilon dia sog gongkoman nog gotowanan nog bolodusaon bu kudusoy asta matoy. Tibua, sog kotolu ondow non motubuꞌ da ion mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dadi, ugat nilan pa kolobotoy og tinaluꞌ non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bu dangan minuliꞌ ilan tidu sog globong ni Isus, inuksugan nilan og glam nog kibianbianan nilan koyon dia sog sopuluꞌ bu sala bu sog duma sulangguꞌanan non. ");
INSERT INTO suc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Og miguksug koni dun dia sog sosuguꞌonanan non si Maria Magdalena, si Jana, bu si Maria nog ginaꞌ ni Jems, bu asta og duma nilan pa nog kolibunanan. ");
INSERT INTO suc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tibua, og gotowanan koyon, ondaꞌ ilan tud dun poꞌ og guksugan nilan koyon, baluꞌ nog gotowanan koyon dun, sagya da pigimungimung. ");
INSERT INTO suc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tibua, si Piter, dangan midongog non og guksugan koyon, migdayun ion mogbuat mangka gobok posunguꞌ sog linobongan kituꞌ dia ni Isus. Bu dangan minatong ion dituꞌ, sinolip non mogdayun. Tibua, daꞌidun og mitongow non, lual da og saput kituꞌ nog putus nog glawas ni Isus. Dadi, minuliꞌ ion nog kisobuꞌan bog olo og bianbian koyon. ");
INSERT INTO suc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Og gondow koyon, ngon og duaꞌ kotow dianilan mipanow posunguꞌ sog bonua nog Emaus. Og bonua koni moglamlam sopuluꞌ bu sala kilumitru og glayuꞌ non tidu sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Solian nilan koyon ompanow, og pigobitobitan nilan paꞌali sog glam nog bianbian ni Isus. ");
INSERT INTO suc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sintak nilan koyon mogabitabit, sinaꞌut ilan ni Isus mangka dolagan dianilan. ");
INSERT INTO suc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tibua, ondaꞌ ion pokpokilala dianilan. ");
INSERT INTO suc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Minginongogan ion dianilan nog, “Olo loꞌ ma og bitan niu koyon nog solian niu ompanow?” Dadi, migindog ilan nog bayuꞌbayuꞌanan nilan misusa. ");
INSERT INTO suc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Og sala kotow koyon nog og ngalan non si Kleopas miktaluꞌ dianon nog, “Sala mu da bayuꞌ og doksaꞌ sog Jerusalem nog ondaꞌ pokosun paꞌali sog bianbian kituꞌ sog timpu koni.” ");
INSERT INTO suc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Long sop ni Isus dun, “Iduma? Olo buan og pogolongon niu koyon?” Dadi, tinumabal ilan nog, “Og paꞌali dia ni Isus nog ion og gotow Nasaret. Ion og polomolatas nog taluꞌ nog Mikpongon nog og taluꞌ non bu ginang non bolokatan dia sog motaan nog Mikpongon bu sog glam nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tibua, og mokokotas nog boliananan bu og bogolalanan nami, pigdang nilan ion dia sog gukum nog bagun og koukuman dianon bunuꞌon. Bu kinudus nilan ion asta matoy. ");
INSERT INTO suc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tibua, migdodama ami bosia dianon nog ion og tumabang dia sog bansa Israel. Bu doma, og gondow koni kotolu ondow non na tidu minang og glam non koyon. ");
INSERT INTO suc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bu ngon pa doma og kisobuꞌan ami dun paꞌali sog guksugan nog dumaanan nami nog kolibunanan. Poꞌ dangan minangoy ilan dituꞌ sog linobongan dia ni Isus komun daliꞌondow, ");
INSERT INTO suc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","daꞌ nilan na kotongow og bangkoy non. Minangoy ilan moguksug dianami nog, ongon duaꞌ buk moloikat nog Mikpongon nog mikpotongow dianilan bu miktaluꞌ nog si Isus mitubuꞌ na puliꞌ. ");
INSERT INTO suc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Dadi, ongon dumaanan nami nog minangoy sog globong kituꞌ bu mitongow nilan nog mamaꞌ dodaꞌ nog guksugan nog kolibunanan kituꞌ. Tibua, daꞌ nilan ion kotongow dituꞌ.” ");
INSERT INTO suc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Miktaluꞌ si Isus nog, “Astaga! Landuꞌ amu dodaꞌ kologon posobutan bu diꞌ amu mosompun tud nog piktaluꞌ nog glam nog polomolatasanan nog taluꞌ nog Mikpongon kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Poꞌ og Kristu koni, sumboy nododaꞌ ion mosinsa poguna mangka non siꞌoy kotabuk og kotas nog bayaꞌ mogdatuꞌ sog glam nog gotow.” ");
INSERT INTO suc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tubus nion, inustal ni Isus dianilan og glam nog sinulat sog Kitab paꞌali dianon nog tinolipunan dia sog sinulat ni Muses bu sog glam nog polomolatasanan nog taluꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bu dangan daliꞌ ilan na datong dia sog gongayan nilan koyon, si Isus migbaluꞌbaluꞌ nog moglandan pa sog gunan. ");
INSERT INTO suc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tibua, tinogol nilan ion monggat. Long nilan dun, “Dini a na nami poꞌ gobi na.” Dadi, migunut ion dianilan. ");
INSERT INTO suc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dangan migadap ilan na kuman, inimud ni Isus og pan mangka non posolomatoy sog Mikpongon, mangka non pomotioy bu bogoyoy dianilan. ");
INSERT INTO suc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dadi, mibukaꞌ og tinontongan nilan bu ugat nilan pa ion kilolaoy. Tubus nituꞌ, mibolong na ion dia sog tinontongan nilan. ");
INSERT INTO suc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bu migabitabit ilan nog, “Saꞌan poma landuꞌ og daꞌdaꞌan ta kobon non kituꞌ mogabitabit dianita sog dalan bu mogustal nog taluꞌ nog Mikpongon dia sog Kitab.” ");
INSERT INTO suc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dadi, migbuat ilan mangka ilan pokpuliꞌ mogdayun sog Jerusalem. Bu kidotongan nilan dituꞌ og sopuluꞌ bu sala bu duma gotowanan nog mikpoglumpuk dion. ");
INSERT INTO suc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bu og gotowanan koyon, mikpoktaluꞌ ilan sog duaꞌ kotow koni nog, “Motud dodaꞌ nog mitubuꞌ puliꞌ og Kounutan ta kituꞌ poꞌ mikpotongow tanan ion dia ni Simun.” ");
INSERT INTO suc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dadi, og duaꞌ kotow koni piguksugan nilan dosop sog glam nilan koyon dion og kibianbianan nilan sog dalan bog olo migandun kokilala nilan dia ni Isus. Poꞌ kinilala nilan ion bianan sog kopomoti non nog pan. ");
INSERT INTO suc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sonuk nilan koyon moguksug paꞌali sog bianbian nilan kituꞌ, gomonsunoy pa, dion na ion pogindog sog titongaꞌ nilan bu miktaluꞌ ion nog, “Kotiknaꞌ mongon dianiu.” ");
INSERT INTO suc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tibua, kiondokan ilan tokodoy poꞌ baluꞌ nilan dun og mitongow nilan koni og molimatoy non. ");
INSERT INTO suc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Dadi, miktaluꞌ ion dianilan nog, “Iduma kondokan amu ma bu mogduaꞌduaꞌ ma og pikilan niu? ");
INSERT INTO suc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tontong niu poloꞌma og komotanan ku bu og botisanan ku. Ion non ini, akon! Tuyok niu poloꞌma bagun niu kosunan nog akon, konaꞌ u dodaꞌ og molimatoy. Poꞌ og molimatoy, daꞌidun og gungod non bu og tulan non. Diꞌ maꞌ nog mitongow niu koni dianakon.” ");
INSERT INTO suc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Solian non koyon moktaluꞌ dun, pitongow non og komotanan non bu og botisanan non. ");
INSERT INTO suc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tibua, daꞌ ilan pa tud dun poꞌ sabap sog miksagot og pikilan nilan nog gloliag bu kisobuꞌan ilan. Dadi, miksak si Isus dianilan nog, “Ongon taꞌ misimpan niu dini nog ponganon?” ");
INSERT INTO suc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bu binogayan nilan doma ion nog sodaꞌ nog milutuꞌ. ");
INSERT INTO suc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Dadi, tinabuk ni Isus mangka non kanoy dia sog sunguꞌan nilan koyon. ");
INSERT INTO suc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tubus nion, miktaluꞌ si Isus dianilan nog, “Og kibianbianan ku koni, ion non og tinaluꞌ u kituꞌ dianiu kobon nog kopokunul ta pa, nog sumboy motuman og glam nog sinulat kituꞌ paꞌali dianakon nog sinulat ni Muses kituꞌ, bu og sinulat nog polomolatasanan nog taluꞌ nog Mikpongon, bu asta og sinulat ni Dabid dia sog Salmu paꞌali dianakon.” ");
INSERT INTO suc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mangka ni Isus bukaꞌoy og pomikilan nilan bagun nilan mosabut og maꞌana nog glam nog tinaluꞌ nog Mikpongon kituꞌ nog sinulat dia sog Kitab. ");
INSERT INTO suc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Maꞌ long non dun dianilan, “Sinulat dia sog Kitab nog og Kristu, sumboy nododaꞌ mosinsa. Tibua, sog kotolu ondow non, motubuꞌ ion mokpuliꞌ tidu matoy. ");
INSERT INTO suc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bu sumboy ustalon bianan sog ngalan non dia sog glam nog binonsaan moktolipun dini sog Jerusalem, og kopoglilaꞌ bu og kopongampun nog dusaanan. ");
INSERT INTO suc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Amu og monaksiꞌ nog glam nini. ");
INSERT INTO suc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bu popongoyon ku dianiu og pinasad nog Gamaꞌ u nog bogoyon non dianiu. Dadi, pogbagad amu dini sog koliwagan bonua nog Jerusalem koni asta tumonaꞌ dianiu og Bolakat nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tubus nituꞌ, inoit ni Isus og sulangguꞌanan non koyon dituꞌ sog molani nog Betani mangka non ogotoy og komot non dianilan poꞌ popiaon non ilan. ");
INSERT INTO suc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sonuk non koyon mokpopia dianilan, ginonatan non ilan poꞌ piiknat na ion sog glangit. ");
INSERT INTO suc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tubus nion, tinamuy nilan ion mangka ilan uliꞌ sog Jerusalem nog landuꞌ og daꞌdaꞌan nilan. ");
INSERT INTO suc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bu kobon non mangoy ilan dia sog Baloy nog Poktomuyan poꞌ moksanglit ilan dia sog Mikpongon.");
INSERT INTO suc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sog tolipunan nog dunya, donsamaꞌ na og Taluꞌ. Og Taluꞌ koni, ilan nog Mikpongon. Bu ion non nion og Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tidu pa sog tolipunan, og Taluꞌ koyon miksolabuk ilan na nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Og glam nog piongon miongon bianan dianon bu daꞌidun og miongon nog konaꞌ bianan dianon. ");
INSERT INTO suc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dia non poktidu og kotubuꞌ bu og kotubuꞌ koyon og mokpodolag dia sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Og Dolag koyon nog sinumilow dia sog modolom, ondiꞌ nododaꞌ dagon sog modolom. ");
INSERT INTO suc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ongon gotow nog pipangoy nog Mikpongon, ngalan non si Jan. ");
INSERT INTO suc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Saꞌan ion pipangoy nog Mikpongon poꞌ ustalon non dia sog gotowanan paꞌali sog Dolag koyon bagun da, bianan sog gustalan non, tumud na bosia og glam nog gotowanan dun. ");
INSERT INTO suc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Si Jan, konaꞌ non og pogolongon kituꞌ nog og Dolag. Sugaꞌid non, ion sagya da minangoy mogustal paꞌali sog Dolag koyon. ");
INSERT INTO suc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Og tantu nog Dolag, ion non ion og minangoy dini sog dunya, og mokpodolag dia sog pomikilan nog glam nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Dadi, og Taluꞌ koyon migonong dini. Bu minsan siꞌoy og dunya miongon bianan dianon, og gotowanan dini sog dunya, ondaꞌ nilan ion kilolaoy. ");
INSERT INTO suc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Minangoy siꞌoy ion sog dili bonua non, daꞌ ion tobukoy nog salu bansa non. ");
INSERT INTO suc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tibua, glam nog ain tinumabuk dianon bu tinumud dia sog ngalan non, binogayan non ilan nog kopatut bagun ilan mimung nog gombataꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Og kopogbataꞌ dianilan ondiꞌ mamaꞌ nog kopogbataꞌ nog pogduoy, otawaka sagya glegan nog gotow, sugaꞌid non, bianan sog bayaꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Og Taluꞌ kituꞌ miktimaluy gotow bu minampuꞌ mogonong dianita solianlian. Molitulungoy bu dia non og motud. Bu mitongow nami dosop og silow nog kotas nog bayaꞌ non nog mitabuk non nog tidu sog Gamaꞌ non, ion og Bataꞌ nog Mikpongon nog Boktung. ");
INSERT INTO suc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Si Jan og migustal dia sog gotowanan paꞌali dianon. Pisikad non og taluꞌ non nog, “Ion non ini og pigolong u kituꞌ nog tumondug dianakon nog labi pa kotas dianakon. Poꞌ ion donsamaꞌ na sog ondaꞌ u pa botaꞌoy.” ");
INSERT INTO suc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ondiꞌ moglokobus og tulung non bu bianan dituꞌ miksawadsawad tanan og popia non dianita. ");
INSERT INTO suc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kobon nituꞌ, bianan dia ni Muses, mitabuk ta og botad nog Mikpongon. Tibua numun koni, og tulung nog Mikpongon bu og motud nog pomali, motabuk ta bianan dia ni Isukristu. ");
INSERT INTO suc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Daꞌidun pa sibon og mikotongow nog Mikpongon lual da og Bataꞌ non nog Boktung nog miksolabuk ilan nog Gamaꞌ sog glangit. Ion og mikposun sog gotowanan paꞌali dianon. ");
INSERT INTO suc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ongon gondow non og kobogolalan nog bansa Hudyu sog Jerusalem, dinondag nilan og boliananan bu duma pangkatanan ni Apuꞌ Lebi mangoy moksak dituꞌ ni Jan bog sima dodaꞌ ion. ");
INSERT INTO suc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Daꞌ pogalangalang tumabal si Jan bu pilogdong non tumaluꞌ nog, “Konaꞌ u og Kristu.” ");
INSERT INTO suc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dadi, miksak ilan nosop nog, “Bila konaꞌ a og Kristu, si Iladya a taꞌ?” Tibua, tinabal non ilan nog, “Konaꞌ u dosop.” “Dadi, bila maꞌ nituꞌ, ika taꞌ buan og pogdodomaan nami kituꞌ nog polomolatas nog taluꞌ nog Mikpongon?” Tinabal non ilan nog, “Konaꞌ u dosop.” ");
INSERT INTO suc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Dadi, sog gimpusan miktaluꞌ ilan, “Sima a ma buan? Posun mu dianami bagun nami dosop omposun dituꞌ sog dinumondag kituꞌ dianami mangoy dini. Olo buan motaluꞌ mu paꞌali dianika?” ");
INSERT INTO suc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dadi, dangan tinumabal si Jan, ginamit non og tinaluꞌ nog polomolatas kituꞌ nog si Isaya nog sinulat sog Kitab nog, “Akon og moktawag dituꞌ sog bonua kituꞌ nog mologon pogonongan nog, ‘Pologdong niu og bianan nog Pogbayaꞌ nog posunguꞌ matong.’” ");
INSERT INTO suc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ongon sop dumaanan nilan nog parasiuanan nog pipangoy moksak dianon. ");
INSERT INTO suc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Long nilan dun, “Bila konaꞌ a og Kristu, bu konaꞌ a dosop ni Iladya, otawaka og polomolatas nog taluꞌ nog Mikpongon kituꞌ, iduma buan momunyag a ma?” ");
INSERT INTO suc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Dadi, tinumabal si Jan nog, “Akon, momunyag u nog gotow bianan sog tubig. Tibua, ongon sala kotow dion niu nog daꞌ niu pa kilolaoy. ");
INSERT INTO suc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ion non ion og tumondug kituꞌ dianakon nog minsan og gikot nog pongyapak non, diꞌ u tanan patut mubad dun.” ");
INSERT INTO suc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Og glam nini dituꞌ miinang sog koliwagan bonua nog Betani, dituꞌ sog dipag nog tubig nog Jurdan, dia sog pimunyagan ni Jan nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Dangan migbolomaꞌ ion, mitongow ni Jan si Isus posunguꞌ dianon. Dadi, miktaluꞌ ion nog, “Kituꞌ da og pinonggiꞌ kituꞌ sog Nati nog Bilibili nog binogoy nog Mikpongon nog pomolason sog dusaanan nog glam nog gotow sog dunya. ");
INSERT INTO suc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ion non na ini og pigolong u kituꞌ nog tumondug dianakon nog motas pa dianakon. Poꞌ donsamaꞌ na ion sog daꞌ u pa botaꞌoy. ");
INSERT INTO suc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Sog tiganaꞌ, daꞌ u ion kosunoy. Tibua, saꞌan mimunyag u bianan sog tubig poꞌ bagun pa ion kosunan nog bansa Israel.” ");
INSERT INTO suc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Maꞌ nini og gustalan ni Jan dun, “Mitongow u og Bolakat nog Mikpongon nog tidu sog glangit mamaꞌ nog kolopati tinumonaꞌ dianon bu daꞌ na pokulog dianon. ");
INSERT INTO suc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ondaꞌ u ion kosunoy taman da daꞌ u kotongow og gindanan kituꞌ nog tinaluꞌ nog dinumondag kituꞌ dianakon momunyag bianan sog tubig nog, og gotow koyon nog momunyag bianan sog Bolakat nog Mikpongon, motongow mu tumonaꞌ dianon og Bolakat nog Mikpongon nog diꞌ na mokulog dianon. ");
INSERT INTO suc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Dadi, mitongow u na bu kitoksiꞌan ku na nog ion non ini og Bataꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Dangan migbolomaꞌ ion, si Jan bu og duaꞌ kotow sulangguꞌ non, dituꞌ ilan nosop. ");
INSERT INTO suc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Dangan mitongow non mian si Isus, miktaluꞌ si Jan nog, “Kituꞌ da! Og Nati nog Bilibili kituꞌ nog miktidu sog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Dadi, dangan midongog nog duaꞌ kotow sulangguꞌanan non koyon, migunut ilan dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Dangan linumingoy si Isus, mitongow non og duaꞌ kotow koyon. Miksak ion nog, “Olo pokponontongon niu koyon?” Tinabal nilan si Isus nog, “Rabi, ain ka migonong?” (Og maꞌana nog Rabi koni, Polopanad.) ");
INSERT INTO suc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tinabal ilan ni Isus nog, “Alung, pogunut amu dianakon bagun niu motongow.” Dadi, migunut ilan dianon bu mitongow nilan og pigonongan non koyon. Og kodatong nilan dituꞌ miliu na ginongaꞌ monog gondow. Dadi, dituꞌ ilan na non minatuk solianlian. ");
INSERT INTO suc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Og sala kotow sog duaꞌ kotow kituꞌ nog mikodongog nog taluꞌ ni Jan bu pogunut dia ni Isus, ion non si Andriu, og gilug ni Simun Piter. ");
INSERT INTO suc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Sododuꞌun pinongow non og gilug non nog si Simun mangka non toluꞌoy nog, “Mitongow nami na og Mesayas!” (Somoꞌ ita da, og Kristu.) ");
INSERT INTO suc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dadi, inoit non si Simun mangoy dituꞌ ni Isus. Dangan minatong ilan dituꞌ ni Isus, tinontong non si Piter mangka poktaluꞌ nog, “Ika Simun, og bataꞌ ni Jan, ingolanan ku ika nog Sipas.” (Og Sipas koni sog Inaramaik, ion non da og Piter.) ");
INSERT INTO suc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Dangan migbolomaꞌ ion, ininang na ni Isus og pikilan non kituꞌ nog mangoy ion sog probinsia nog Galili. Dangan minatong dituꞌ, mitongow non si Pilip. Dadi, tinoluꞌan non nog, “Alung, pogunut a dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Pilip og gotow Betsaida og salu bonua ni loꞌ Andriu bu si Piter. ");
INSERT INTO suc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Dadi, pinontong ni Pilip si Nataniel. Dangan mitongow non, pigobitan non dianon nog, “Mitongow nami og gotow kituꞌ nog sinulat ni Apuꞌ Muses dia sog Botad og paꞌali dianon. Bu sinulat dosop nog polomolatasanan kituꞌ nog taluꞌ nog Mikpongon. Og ngalan non si Isus, og bataꞌ ni Jusep nog gotow Nasaret.” ");
INSERT INTO suc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Dadi, miktaluꞌ si Nataniel, “E! Nasaret? Ongon taꞌ og molongas nog moktidu sog Nasaret?” Dadi, maꞌ long ni Pilip dun, “Alung poloꞌma, ongoyon ta tontongoy.” ");
INSERT INTO suc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Dangan mitongow ni Isus si Nataniel posunguꞌ dituꞌ non, miktaluꞌ ion nog, “Koni og tantu pangkat nog bansa Israel nog diꞌ kotongowan nog diꞌ motud.” ");
INSERT INTO suc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Dadi, miksak si Nataniel. “Olo loꞌ ma kisunoy mu dianakon?” Tinabal ion ni Isus nog, “Mitongow u ika sog silung nog kayu kituꞌ nog igera sog daꞌ a pa onggatoy ni Pilip dun.” ");
INSERT INTO suc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Dadi, miktaluꞌ si Nataniel, “Rabi, motud dodaꞌ nog ika og Bataꞌ nog Mikpongon bu og Datuꞌ nog bansa Israel!” ");
INSERT INTO suc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Miktaluꞌ si Isus nog, “Tinumud a taꞌ sabap sog taluꞌ u nog mitongow u ika sog tondong nog kayu kituꞌ? Toluꞌon ku dianika, mokotongow a pa nog labi pa dion nog kosobuꞌsobuꞌ. ");
INSERT INTO suc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Toluꞌon ku dianiu, nog motongow niu og glangit ombukaꞌ bu og moloikatanan nog Mikpongon mongmonog monek ilan dianakon, og Binataꞌ sog Kilawan.” ");
INSERT INTO suc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tolu ondow golot non, ongon og kaing dituꞌ sog koliwagan bonua nog Kana, og sakup nog Galili. Og ginaꞌ ni Isus tinumuaꞌ sog kaing koyon. ");
INSERT INTO suc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Si Isus bu sulangguꞌanan non, pinosunan ilan dosop nog kaing koyon. ");
INSERT INTO suc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dangan kinobus ilan nog ginumon, og ginaꞌ ni Isus miktaluꞌ dianon nog, “Kinobus ilan nog galak.” ");
INSERT INTO suc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tinabal ion ni Isus nog, “Potiang mu pa akon bog olo ginangon ku poꞌ daꞌ pa datong og tang u.” ");
INSERT INTO suc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dadi, og ginaꞌ non miktaluꞌ dia sog sosoligananan nog miglokologyaꞌan koyon nog, “Ain toluꞌon non dianiu inang niu.” ");
INSERT INTO suc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ongon gonom buk mokoluksang nog sibulan dia sog molani nilan koyon nog gomiton nog gotowanan dion bila moginang ilan nog pogbotadon nog gotow Hudyu kituꞌ nog mongugas. Og sibulananan koyon kugatan mogliu sog pat otawaka gonom lata og solabuk dun. ");
INSERT INTO suc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Dinondag ni Isus og sosoligananan koyon nog pomonuꞌon nilan nog tubig og glam non. Dadi, pimonuꞌ nilan nog tubig dia sog goktob nog babaꞌ nog sibulananan koyon. ");
INSERT INTO suc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tubus nituꞌ, miktaluꞌ si Isus nog, “Saguk amu dun bu oit niu sog gotow nog migokbit nog kologyaꞌan koni.” Dadi, migoit ilan nog tubig koyon ");
INSERT INTO suc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","mangka nilan bogoyoy dia sog migokbit nog kologyaꞌan koyon. Dangan kiinaman non og tubig koyon nog miktimaluy galak, ondaꞌ non kosunoy bog ain miktidu og galak koyon. Tibua, kisunan da nog ain sinumaguk kituꞌ dun. Dadi, dangan ininaman non og galak koyon, sinabi non moglandan og glaki kituꞌ nog kinaing ");
INSERT INTO suc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","mangka non toluꞌoy nog, “Konaꞌ taꞌ nog bila ongon og kologyaꞌan mamaꞌ nini, unanan ta dumulang dia sog gotowanan og galak kituꞌ nog ombaꞌis, bu bila mokinum na glam nilan nog mahatul, mangka pa dulangoy nog galak kituꞌ nog diꞌ tantu ombaꞌis? Tibua ika, pibinayaꞌ mu ma dumulang og ombaꞌis koni tokodoy nog galak.” ");
INSERT INTO suc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Koyon og tiganaꞌ gingyataꞌ nog ininang ni Isus. Dituꞌ non ininang sog Kana, og sakup nog Galili. Bianan sog gininang non kituꞌ, pitongow non na og kotas nog bayaꞌ non nog boyaꞌan tinumud og sulangguꞌanan non dianon. ");
INSERT INTO suc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tubus nituꞌ, dinumiksun si Isus bu ginaꞌ non, ilan nog pigilugananan non asta og sulangguꞌanan non, dituꞌ sog Kapernaum. Bu minguliꞌan ilan dituꞌ podaliꞌ. ");
INSERT INTO suc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Dangan daliꞌ na datong og kologyaꞌan kituꞌ nog gotow Hudyu nog ngalan non Liniusan, tinumukad si Isus sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Dangan minangoy ion dia sog glomalomaan nog Baloy nog Poktomuyan koyon dia sog Mikpongon, dinotongan non dion og gotowanan nog mikpogdagangdagang nog sapiꞌanan, og bilibilianan, bu og kolopatianan, asta og polomolosanan nog sin nog mikpongingkud ilan sog glomisahananan nilan. ");
INSERT INTO suc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dadi, minalap si Isus nog tali. Inimung non nog bobadas mangka non pomugowoy og glam nog sapiꞌanan bu bilibilianan, bu pimolitukaꞌ og glomisahananan nog boyaꞌan mikpogwalak og sinanan nilan, ");
INSERT INTO suc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","mangka non toluꞌoy og gotowanan kituꞌ nog mikpogdagang nog kolopati nog, “Awaꞌ niu dini og dogangananan niu koyon bu naꞌ niu imungon nog tobuꞌan og Baloy nog Gamaꞌ u!” ");
INSERT INTO suc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mipondom nog sulangguꞌanan non koyon og sinulat kobon nituꞌ nog, “Landuꞌ kopogastol u mogipat nog baloy mu asta moglaꞌat u dun.” ");
INSERT INTO suc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Dadi, og kounutananan nog bansa Hudyu koyon, linompang nilan mongambat nog gingyataꞌ. Maꞌ long nilan dun, “Olo og ginggyataꞌ nog ompotongow mu dianami nog togo bayaꞌ a dodaꞌ moginang nog mamaꞌ nini koni?” ");
INSERT INTO suc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sokaliꞌ tinumabal si Isus nog, “Gobaꞌ niu og Baloy nog Poktomuyan koni dia sog Mikpongon poꞌ sog solod nog tolu ondow pindogon ku mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tinabal nilan si Isus, “Pat puluꞌ bu nom ton pogimungon og Baloy nog Poktomuyan koni mangka siꞌoy kodoksuꞌ, saka, moktaluꞌ a nog pindogon mu ini mokpuliꞌ sog solod nog tolu ondow?” ");
INSERT INTO suc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tibua, og pigolong ni Isus koyon nog Baloy nog Poktomuyan dia sog Mikpongon, ion non og dili glawas non. ");
INSERT INTO suc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Dadi, dangan mitubuꞌ si Isus tidu matoy, mipondom nog sulangguꞌanan non og taluꞌ non kituꞌ. Sabap dituꞌ, tinumud ilan sog sinulat kobon nituꞌ dia sog Kitab paꞌali dianon bu tinumud ilan dosop nog tinaluꞌ non. ");
INSERT INTO suc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Dadi, kobon non pa dituꞌ sog Jerusalem sog tang nog ginang nilan kituꞌ nog iningolanan Liniusan, modakol gotow og tinumud dianon sabap sog gingyataꞌanan nog ininang non. ");
INSERT INTO suc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tibua, si Isus daꞌ salig non dianilan poꞌ kisunan non na og polomotadon nog glam nog gotow. ");
INSERT INTO suc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Diꞌ siꞌoy toluꞌon dianon nog gotow, donsamaꞌ non na kisunan bog olo og dia sog pomikilan nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ongon og sala kotow parasiu og sakup nog kobogolalan nog bansa Hudyu, ngalan non si Nikudimus. ");
INSERT INTO suc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ongon gobi, minangoy ion dituꞌ ni Isus mangka ion poktaluꞌ nog, “Rabi, kisunan nami nog ika og polopanad nog dinondag nog Mikpongon mangoy dini, poꞌ daꞌidun gotow og mokopoginang nog gingyataꞌanan mamaꞌ nog pinginang mu somoꞌ daꞌ ion dumaoy nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Dadi, tinumabal si Isus nog, “Toluꞌon ku dianika, taman da og gotow ondiꞌ botaꞌon mokpuliꞌ, ondiꞌ non nododaꞌ motongow og pigdotuꞌan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dadi, miksak si Nikudimus nog, “Olo og mogandun kobataꞌ mokpuliꞌ dia sog gotow nog saka mogulang na? Mokosolod potaꞌ buan ion puliꞌ sog tian nog ginaꞌ non?” ");
INSERT INTO suc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tinabal ion ni Isus nog, “Toluꞌon ku dianika, nog daꞌidun gotow og mokampuꞌ sog pigdotuꞌan nog Mikpongon bog daꞌ da ion botaꞌoy bianan sog tubig bu Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ain og binataꞌ nog gotow, og gotow da. Bu ain og binataꞌ bianan sog Bolakat nog Mikpongon, ion mimung nog bataꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Dadi, naꞌ a mosobuꞌ bila toluꞌon ku nog sumboy botaꞌon amu mokpuliꞌ. ");
INSERT INTO suc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Poꞌ ibalat da sog galuꞌ, og galuꞌ koyon moyup sog ain glegan non. Modongog mu tibua og dogus non nog diꞌ mu sunan bog ain miktidu bu ain posunguꞌ. Maꞌ nituꞌ dosop og gotow bila botaꞌon bianan sog Bolakat nog Mikpongon. Ondiꞌ non kosunan bog olo og ginandun dianon.” ");
INSERT INTO suc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Dadi, miksak nosop si Nikudimus nog, “Olo ma og gondunon dun?” ");
INSERT INTO suc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tinumabal si Isus nog, “Diꞌ mu tanan kosunan saka motas a bosia nog polopanad sog bansa Israel? ");
INSERT INTO suc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Toluꞌon ku dianika, miguksug ami nog ain kisunan nami bu tinumaksiꞌ ami nog ain mitongow nami. Tibua, minsan siꞌoy maꞌ nituꞌ, diꞌ amu pa tumud nog gustalan nami. ");
INSERT INTO suc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Olo ma mogandun kotud niu bila ustalan ku amu paꞌali sog kinodiwata nog minsan og gustalan ku dianiu nog paꞌali sog kinilawan, ondiꞌ niu tanan tudon? ");
INSERT INTO suc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Daꞌidun mikangoy dituꞌ sog glangit, lual da og sala kotow nog miktidu sog glangit. Ion og Binataꞌ sog Kilawan. ");
INSERT INTO suc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Kobon nituꞌ, dituꞌ sog bonua nog mologon pogonongan, si Muses, tinumunag nog galang, binantuk non maꞌ nog mamak mangka non tundokoy sog ditas bagun da, ain tinoktuk nog mamak, bila tumontong ilan dia sog tinundok kituꞌ, kuliꞌan ilan dun. Domikian dosop maꞌ nituꞌ, og Binataꞌ sog Kilawan, sumboy dosop tundokon sog kudus mangka patoy ");
INSERT INTO suc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","bagun da, ain og tumud dianon mokalap nog kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Poꞌ sabap sog landuꞌ kosolag og glolaman nog Mikpongon sog glam nog gotow sog dunya, binogoy non og Bataꞌ non nog Boktung matoy bagun ain og tumud dianon, ondiꞌ ion mokangoy sog kopatoy nog daꞌ kopus non, sugaꞌid non, mokalap ion nog kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Poꞌ og Mikpongon, daꞌ non dondagoy og Bataꞌ non mangoy momolihalaꞌ dini sog dunya. Sugaꞌid non, inangoy non ilan gowonoy tidu sog dusaanan nilan. ");
INSERT INTO suc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Dadi, og gotowanan nog ain tumud dia sog Bataꞌ non, ondiꞌ ilan poliholaꞌon. Tibua, og gotowanan nog ondiꞌ tumud dianon, pinolihalaꞌ ilan na poꞌ ondaꞌ ilan tud dia sog Bataꞌ nog Mikpongon nog Boktung. ");
INSERT INTO suc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mamaꞌ nini og kopomolihalaꞌ nog Mikpongon. Og Bataꞌ non minangoy sog dunya poꞌ mogbogoy nog dolag dia sog pikilan nog gotowanan. Tibua, ompok og gotowanan dun. Og kolegan nilan og dolom poꞌ mokolaton og kohinangan nilan. ");
INSERT INTO suc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Poꞌ og gotowanan kituꞌ nog moginang nog molaton, mangit dia sog dolag bu ompok mokpolani dun bagun ondiꞌ ompolantaꞌ og kohinangan nilan nog molaton. ");
INSERT INTO suc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tibua, ain og gotow nog pinuluꞌan nog motud, mangoy na dodaꞌ ion dia sog kodolagan bagun motongow nog og kohinangan non koyon, miunut non og glegan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tubus nituꞌ, si Isus bu og sulangguꞌanan non koyon minangoy ilan sog kobukidan nog Judia. Bu dituꞌ ilan pa migonongonong. Bu pimunyagan non pa og gotowanan dituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Bu si Jan siꞌoy mimunyag dosop dituꞌ sog bonua nog Ainon, sog molani nog koliwagan bonua nog Salem poꞌ modalom og tubig dituꞌ. Bu modakol og mikpogangoy nog gotowanan dion mokpogbunyag dia ni Jan. ");
INSERT INTO suc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Og tang koni daꞌ pa kolobusuoy si Jan dun.) ");
INSERT INTO suc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bu duma sulangguꞌanan ni Jan, mikpoksusisusi ilan nog sala kotow Hudyu paꞌali dia sog botad nog bansa Hudyu nog ginang nilan nog gugas. ");
INSERT INTO suc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dadi, minangoy ilan dituꞌ ni Jan mangka ilan pogabit nog, “Rabi, kolobotan mu taꞌ og gotow kituꞌ nog duma mu nog pigolong mu dianami dituꞌ sog dipag nog tubig nog Jurdan? Numun koni ion mimunyag dosop bu modakol og gotowanan nog mikpogunut dianon.” ");
INSERT INTO suc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tinumabal si Jan nog, “Daꞌidun og gotow mokinang nini bog daꞌ da bogoyoy nog Mikpongon dianon. ");
INSERT INTO suc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Minsan amu, kitoksiꞌan niu og tinaluꞌ u kituꞌ nog konaꞌ u og Kristu. Sugaꞌid non, akon og piuna mokposun paꞌali dianon. ");
INSERT INTO suc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ibalat da sog moglokaing, og glaki, ion og gapuꞌ nog koingon kituꞌ dianon. Tibua, og gunung nog glaki koyon mogumatiꞌ tibua ion nog taluꞌ nog glaki koyon. Bila modongog non og taluꞌ non, loliagon ion dun. Akon siꞌoy, maꞌ nituꞌ u dosop nog mitoktub na og gloliag u. ");
INSERT INTO suc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Poꞌ sumboy kobon non mogdungag og bontugan non. Bu og gianakon sumboy nododaꞌ moglokulang.” ");
INSERT INTO suc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ion og miktidu sog glangit, og motas sog glam non. Og gotowanan nog tidu dini sog dunya koni, dini ilan da goktob sog dunya koni. Bu og poglobiton nilan paꞌali dosop dini sog dunya koni. Tibua, ion og miktidu sog glangit, ion nododaꞌ og motas sog glam non. ");
INSERT INTO suc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Bu mogustal ion paꞌali sog ain mitongow non bu midongog non. Tibua, daꞌ nilan tobukoy og gustalan non. ");
INSERT INTO suc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tibua, ain og gotow nog tinumabuk nog gustalan non, miimung ion nog tandaꞌ nog og taluꞌ nog Mikpongon motud dodaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Poꞌ og dinondag koyon nog Mikpongon mangoy dini, ion og moktaluꞌ nog taluꞌ nog Mikpongon poꞌ binogayan ion nog Mikpongon nog Bolakat nog diꞌ moglokobus. ");
INSERT INTO suc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Og Gamaꞌ molalam sog Bataꞌ non bu inuakil non dia sog gongkoman non og glam non. ");
INSERT INTO suc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dadi, simasima og tumud dia sog Bataꞌ non, ion mokalap nog kotubuꞌ nog daꞌ kopus non. Tibua, simasima ompok mokokunut dianon, ondiꞌ ion mokalap nog kotubuꞌ nog daꞌ kopus non bu ondiꞌ mokawaꞌ dia sog polihalaꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Dadi, midongog nog parasiuanan nog og pimunyagan ni Isus modakol pa dia sog pimunyagan ni Jan bu modakol dosop og mikpogunut dianon. ");
INSERT INTO suc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Tibua og mimunyag koyon konaꞌ ni Isus, sugaꞌid non, og sulangguꞌanan non.) ");
INSERT INTO suc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Dangan kisunan ni Isus og dongogan nog maꞌ nion, ginumonat ilan sog Judia mangka ilan pokpuliꞌ sog Galili. ");
INSERT INTO suc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mangka ilan siꞌoy pokodatong sog Galili, sumboy mian ilan pa sog probinsia nog Samaria. ");
INSERT INTO suc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Dangan midopot ilan sog Samaria, minapit ilan sog bonua nog Sikar. Og Sikar koni molani sog glupaꞌ nog binogoy ni Jakub kobon nituꞌ dia sog bataꞌ non nog si Jusep. ");
INSERT INTO suc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Dituꞌ dosop og timbaꞌ ni Jakub. Dangan miglotuondow bonua, sabap sog glupugan non ompanow, miningkud si Isus sog molani nog timbaꞌ koyon. ");
INSERT INTO suc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Likud nog sulangguꞌanan non koyon mangoy sumaluy nog tasondowan nilan, gomonsunoy pa ongon og glibun minangoy sumigob. Og glibun koyon og gotow Samaria. Dadi, miktaluꞌ si Isus dianon nog, “Pinum nika pa akon.” ");
INSERT INTO suc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tinumabal og glibun koyon, “Iduma mongoni a ma nog tubig dianakon nog saka ika og Hudyu a bu akon og gotow Samaria u?” (Poꞌ og gotow Hudyu ompok ilan mogampuꞌ nog gotow Samaria.) ");
INSERT INTO suc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tinumabal si Isus nog, “Somoꞌ kisunan mu da bosia og bogoy nog Mikpongon, bu kilolaan mu og migbubut koni minum dianika, ika pa tanan bosia og baꞌis mongoni dianon nog tubig. Bu ion og mokobogoy dianika nog tubig nog moksologan nog kotubuꞌ dun.” ");
INSERT INTO suc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Maꞌ long nog glibun koyon dun, “Polopanad, ain ka ma pokalap nog tubig koyon nog moksologan nog kotubuꞌ dun? Poꞌ og timbaꞌ koni landuꞌ kodalom, bu daꞌidun og saguk mu dun. ");
INSERT INTO suc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Labi a potaꞌ dia sog mogulang nami kituꞌ nog si Jakub, og migbogoy nog timbaꞌ koni? Ion, asta gombataꞌanan non, bu potubuꞌonanan non, dini da pokponginum.” ");
INSERT INTO suc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Dadi, tinumabal si Isus nog, “Simasima og minum nog tubig koni kuowon da mokpuliꞌ. ");
INSERT INTO suc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tibua, simasima og mokinum nog tubig koni nog bogoyon ku, ondiꞌ nododaꞌ kuowon. Poꞌ og tubig koni nog bogoyon ku mimung nog moktobud dianon og sologan nog kotubuꞌ nog daꞌ kopus non.” ");
INSERT INTO suc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sokaliꞌ tinumabal og glibun koyon nog, “Polopanad, bila mogusoy da dianika, bogoyoy mu pa akon dun bagun u na diꞌ kuowon, bu bagun u na ondiꞌ mokpuliꞌpuliꞌ mangoy malap nog tubig dini.” ");
INSERT INTO suc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Dadi, tinoluꞌan non og glibun koyon, “Angoy mu sabi og kodumanan mu mangka pokpuliꞌ dini.” ");
INSERT INTO suc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tibua, tinumabal og glibun koyon nog, “Ondaꞌidun og kodumanan ku.” Miktaluꞌ si Isus dianon nog, “Motud og taluꞌ mu koyon nog daꞌidun og kodumanan mu. ");
INSERT INTO suc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tibua, lima buk na tanan og glaki mu bu og glaki koyon nog duma mu mogampuꞌ numun koni, konaꞌ mu tanan og duoy. Saꞌan motud dodaꞌ og taluꞌ mu koyon.” ");
INSERT INTO suc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Miktaluꞌ dosop og glibun koyon, “Polopanad, kisunan ku na nog ika dodaꞌ og polomolatas nog taluꞌ nog Mikpongon! ");
INSERT INTO suc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Og mokogulanganan nami, dini sog bulud koni miktamuy dia sog Mikpongon. Tibua, amu gotow Hudyu, long niu dun, sumboy dituꞌ tomuyoy sog Jerusalem og Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Dadi, miktaluꞌ si Isus nog, “Toluꞌon ku dianika nog tud a dianakon, ongon gondow non, bila og Gamaꞌ ta poktomuyon, ondaꞌ na dini sog bulud koni otawaka dituꞌ sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Amu og gotow Samaria, miktamuy amu nog diꞌ niu sunan. Tibua, ami gotow Hudyu, kosunan nami og piktamuy nami poꞌ og tabang sog gotowanan dia poktidu sog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tibua, posunguꞌ na matong, bu minatong na tanan, nog og tantu nog polotamuy moktamuy sog Gamaꞌ bianan sog Bolakat non bu sog motud. Poꞌ maꞌ nituꞌ og kolegan nog Gamaꞌ sog glangit nog ain moktamuy dianon. ");
INSERT INTO suc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Poꞌ og Mikpongon, ondiꞌ motongow. Dadi, ain og tumamuy dianon, sumboy moktamuy bianan sog Bolakat non bu og motud.” ");
INSERT INTO suc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Dadi, miktaluꞌ og glibun koyon nog, “Kosunan ku nog ongon gondow non, matong og Tinonduꞌ nog Mikpongon Mogdatuꞌ nog iningolanan og Kristu. Bila matong ion, ustalon non og glam non dianita.” ");
INSERT INTO suc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Dadi, miktaluꞌ si Isus nog, “Og pogolongon mu koyon, akon, og duma mu koni mogabitabit.” ");
INSERT INTO suc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sog tang koyon, minatong og sulangguꞌanan non. Bu kisobuꞌan ilan nog migabitabit si Isus ilan nog glibun koyon. Tibua, ondaꞌidun mikogonop moksak dia sog glibun koyon nog, “Olo og kolegan mu?” Bu daꞌ nilan dosop kosak dia ni Isus nog, “Iduma mogabitabit a ma dia sog glibun koyon?” ");
INSERT INTO suc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dadi, ginonatan nog glibun koyon og toguꞌan tubig non koyon mangka angoy sog gimbolayan koyon mangka non toluꞌoy dia sog gotowanan nog, ");
INSERT INTO suc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Pogunut amu poloꞌma dianakon. Ongoyon ta tontongoy og gotow kituꞌ nog tinaluꞌ non dianakon og glam nog kohinangan ku. Konaꞌ non taꞌ gidoy ion og pogolongon kituꞌ nog Kristu?” ");
INSERT INTO suc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dangan midongog nog gotowanan og taluꞌ nog glibun koyon, migdaliꞌdaliꞌ ilan mangoy dituꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Og likud nog glibun koyon nog daꞌ dion, inonggat ion kuman nog sulangguꞌanan non. Maꞌ long nilan dun, “Rabi, kan ka na.” ");
INSERT INTO suc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tibua, tinabal non ilan nog, “Ongon da ponganon ku nog ondiꞌ niu kosunan.” ");
INSERT INTO suc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dadi, miksinaksakoy ilan nog, “Ongon taꞌ gidoy og minatod nog ponganon non dini?” ");
INSERT INTO suc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Dadi, miktaluꞌ si Isus nog, “Og ponganon ku og moginang nog glegan nog mikpopangoy kituꞌ dianakon bu dumoksuꞌ nog ginang non. ");
INSERT INTO suc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Konaꞌ taꞌ long niu pa dun nog pat bulan dona, matong na og timpu gumani? Tibua, toluꞌon ku dianiu, tontong niu poloꞌma og binalananan koyon. Ombaꞌis ilan na gonion. ");
INSERT INTO suc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Og gotow koyon nog gumani, ion non ion og mokposabut kituꞌ dia sog gotowanan bagun ilan tumabuk dianakon. Og polonggani koyon mokotabuk da nog sugda non tidu sog Mikpongon. Bu ain gotow nog ginani non, mokotabuk nog kotubuꞌ nog daꞌ kopus non. Dadi, tiduan sog polomula asta sog polonggani, mansing ilan mokpogdaꞌdaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Motud og ponoluꞌon kituꞌ nog, ‘Ongon og polomula bu len dosop gumani dun.’ ");
INSERT INTO suc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Dinondag u amu gumani sog polayan nog konaꞌ niu mimula dun, sugaꞌid non, og len gotow. Bu numun koni, amu og mikogani nog pigulas sinsolaꞌan nilan.” ");
INSERT INTO suc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Dadi, modakol gotow Samaria sog koliwagan bonua koyon nog tinumud dia ni Isus sabap sog guksugan nog glibun kituꞌ nog kisunan dow ni Isus og glam nog kohinangan non. ");
INSERT INTO suc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Dangan minatong ilan dituꞌ ni Isus, sinosaꞌan nilan ion nog monguliꞌan pa dituꞌ nilan. Dadi, migonongonong ilan pa dituꞌ lagaꞌ duaꞌ gobi. ");
INSERT INTO suc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Dinumungag pa kodakol og tinumabuk dianon sabap sog gustalan non koyon. ");
INSERT INTO suc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Dadi, miktaluꞌ og gotowanan koyon dia sog glibun koyon nog, “Numun kituꞌ konaꞌ poꞌ tinumud ami sabap sog tinaluꞌ mu kituꞌ dianami, sugaꞌid non, sabap sog ami siꞌoy, midongog nog dili tolinga nami. Bu kisunan nami nog ion dodaꞌ og Polonabang nog glam nog gotow dini sog dunya.” ");
INSERT INTO suc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Midopot duaꞌ ondow golot non, miglandan si Isus dituꞌ sog Galili. ");
INSERT INTO suc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tinaluꞌ non na donsamaꞌ nog, “Og polomolatas nog taluꞌ nog Mikpongon ondiꞌ pogodaban sog dili bonua non.” ");
INSERT INTO suc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tibua, dangan minatong ion sog Galili, modakol og gotowanan nog tinumolimaꞌ dianon poꞌ mitongow nilan og glam nog gininang non kituꞌ sog Jerusalem sog tang nog kologyaꞌan kituꞌ nog Liniusan. Poꞌ ilan siꞌoy, tinumuaꞌ ilan dosop dituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tubus nituꞌ, mikpuliꞌ si Isus dituꞌ sog Kana nog sakup nog Galili, nog dituꞌ non pitimaluy og tubig kituꞌ dia sog galak. Ongon og bogolal dion, og bataꞌ non nog glaki ondiꞌ mokodag dituꞌ sog Kapernaum. ");
INSERT INTO suc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Dangan midongog non nog si Isus minatong na sog Galili tidu sog Judia, linumpak non ion mangka ion pokilolat dia ni Isus nog ongoyon non pa pokodagoy og bataꞌ non kituꞌ dituꞌ sog Kapernaum nog pokpatoy na. ");
INSERT INTO suc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sokaliꞌ miktaluꞌ si Isus, “Taman da ondiꞌ amu mokotongow nog gingyataꞌanan bu og kosobuꞌsobuꞌ nog kohinangan, ondiꞌ amu nododaꞌ tumud!” ");
INSERT INTO suc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tibua, tinumabal og bogolal koyon nog, “Sir, pogunut a pa dianakon solian nog totubuꞌ pa og bataꞌ u kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Miktaluꞌ si Isus dianon nog, “Panow a na poꞌ og bataꞌ mu kituꞌ motubuꞌ da.” Dadi, og gotow kituꞌ tinumud dia ni Isus mangka panow. ");
INSERT INTO suc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dia pa ion sog dalan, linumpak na nog sosoligananan non mangka poktaluꞌ nog, “Og bataꞌ mu kituꞌ mokodag na.” ");
INSERT INTO suc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dadi, miksak ion bog nanu kinumodag og bataꞌ non kituꞌ. Tinabal nilan ion nog, “Kolabung mipuaspuas tasondow miawaꞌ og panas non.” ");
INSERT INTO suc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dadi, sododuꞌun kisunan non nog og tang koyon, og tang sop nog kotaluꞌ ni Isus kituꞌ dianon nog, “Og bataꞌ mu motubuꞌ da.” Dadi, ion bu og glam nog glaꞌayatanan non tinumud dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Koni og koduaꞌ nog gingyataꞌ ni Isus nog ininang non nog kangoy non sog Galili tidu sog Judia. ");
INSERT INTO suc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tubus nituꞌ, ongon og kologyaꞌan nog gotow Hudyu dituꞌ sog Jerusalem nog tinumuaꞌ si Isus dun. ");
INSERT INTO suc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Sog galad nog koliwagan bonua koyon nog Jerusalem, ongon og bongawan dion nog ngalan non Bongawan nog Bilibilianan. Sog molani nog bongawan koyon, ongon og tobud dion nog ngalan non dia sog Hinibru Betesda. Bu sog glumibut nog tobud koyon ngon lima buk glokowlokow. ");
INSERT INTO suc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Modakol og mikpobobolilid nog gotowanan dion nog diꞌ mokokodag mamaꞌ nog buta, og pingkaꞌ, bu og daday. Pigbogadan nilan moglimbual og tubig koyon. ");
INSERT INTO suc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Poꞌ sumolingka og moloikat nog Mikpongon mangoy dion mangka non limbualoy og tubig koyon. Ain og mokuna sumigbu dia sog tobud koyon, kuliꞌan og mosakit non minsan olo mosokitoy dun. ");
INSERT INTO suc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ongon sala kotow dituꞌ, og daday. Tolu puluꞌ bu walu ton non na pogbotikon og mosakit non koyon. ");
INSERT INTO suc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Dangan mitongow ni Isus og gotow koyon nog pogbolilid dion, kisunan non nog miobon na nog daday koyon poglogogaan og mosakit non koyon. Dadi, sinakan non ion nog, “Moleg a taꞌ kuliꞌan?” ");
INSERT INTO suc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tinumabal og daday koyon nog, “Ondaꞌidun tanan og sumikwat dianakon sog tobud koyon bila limbualon na. Dadi, solian ku mogapas mangoy dion, ngon na og mokuna sumigbu dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dadi, miktaluꞌ si Isus dianon nog, “Pogbuat a bu imud mu og gikam nika koyon mangka a panow.” ");
INSERT INTO suc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sododuꞌun kiuliꞌan og gotow koyon. Inimud non og gikam non koyon mangka panow. Og gondow kituꞌ mibonaꞌ sog Gondow nog Pogulali. ");
INSERT INTO suc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Dadi, dangan mitongow nog kounutananan nog gotow Hudyu og gotow koyon nog kiuliꞌan nog migoitoit nog gikam non, tinoluꞌan nilan ion nog, “Iduma mogoitoit a ma nog gikam nika koyon nog saka og gondow koni, og Gondow nog Pogulali? Og bonduan ion dia sog pogbotadon ta!” ");
INSERT INTO suc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Dadi, tinumabal ion nog, “Og gotow nog mikpokodag dianakon miktaluꞌ dianakon nog, ‘Imud mu og gikam nika koyon mangka a panow.’” ");
INSERT INTO suc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dadi, sinakan nilan ion nog, “Sima otowoy og miktaluꞌ nion dianika?” ");
INSERT INTO suc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tibua, og kiuliꞌan koyon, daꞌ non kilolaoy bog sima og mikpokodag kituꞌ dianon poꞌ si Isus miksolingod na dia sog kodokolan nog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tubus nituꞌ, mitongow ni Isus og gotow kituꞌ nog kiuliꞌan dituꞌ sog Baloy nog Poktomuyan dia sog Mikpongon bu tinoluꞌan non nog, “Tontong mu, kiuliꞌan ka noma. Dadi, lotaꞌ a na moginang nog dusa bagun ka ondiꞌ kodotongan nog labi pa sog sinsaan mu kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dangan kisunan non bog sima og mikpokodag dianon, inangoy non pogobitoy dia sog kounutananan nog gotow Hudyu. ");
INSERT INTO suc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Dadi, sabap sog piginang ni Isus koyon sog Gondow nog Pogulali, og kounutananan nog bansa Hudyu koyon, pikongitan nilan si Isus. ");
INSERT INTO suc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tibua, miktaluꞌ si Isus dianilan nog, “Og Gamaꞌ u ondiꞌ mulali moginang gobi gondow. Bu akon siꞌoy maꞌ nituꞌ u dosop.” ");
INSERT INTO suc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Saꞌan ituꞌ migdungag og pokangit nilan dia ni Isus nog boyaꞌan poksipian nilan tanan ion munuꞌ dun. Poꞌ konaꞌ tibua nog daꞌ non unutoy og botad paꞌali sog Gondow nog Pogulali, sugaꞌid non, miktaluꞌ pa ion nog og dili Gamaꞌ non og Mikpongon. Og maꞌana non, pibatuk non og glawas non dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Dadi, tinabal ilan ni Isus nog, “Toluꞌon ku dianiu nog og Bataꞌ, daꞌidun og minang non bila ion da. Sugaꞌid non, og minang non ain da og mitongow non dia sog Gamaꞌ non. Poꞌ ain og ginangon nog Gamaꞌ non, kituꞌ dosop og ginangon nog Bataꞌ. ");
INSERT INTO suc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Og Gamaꞌ molalam dia sog Bataꞌ non, bu potongowon non og glam nog kohinangan non. Bu labi pa dini og kosobuꞌsobuꞌ nog potongowon non dianon bu kosobuꞌan amu tokodoy dun. ");
INSERT INTO suc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Poꞌ og Gamaꞌ, ompotubuꞌ non og minatoy. Bu og Bataꞌ non siꞌoy mokopotubuꞌ dosop sog ain kolegan non. ");
INSERT INTO suc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Og Gamaꞌ, ondiꞌ na mongukum minsan sala kotow. Sugaꞌid non, inuakil non na og bayaꞌ mongukum dia sog Bataꞌ non ");
INSERT INTO suc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","bagun pogodaban ion nog gotowanan mamaꞌ nog kopogadab nilan dia sog Gamaꞌ non. Bila og gotow nog ondiꞌ mogadab dia sog Bataꞌ, ondiꞌ non dosop godaban og Gamaꞌ, nog ion non ion og mikpopangoy dia sog Bataꞌ non dini sog dunya. ");
INSERT INTO suc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Toluꞌon ku dianiu, simasima og mokodongog nog taluꞌ u bu tumud dia sog mikpopangoy kituꞌ dianakon, ondiꞌ na ion poliholaꞌon. Sugaꞌid non, migawon na tidu sog patoy bu mikalap na ion nog kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Toluꞌon ku dianiu, ongon gondow matong, bu numun kituꞌ dini notanan, nog ain og mikpomatoy, modongog nilan og taluꞌ nog Bataꞌ nog Mikpongon. Bu ain gotow nog mokodongog dun, motubuꞌ ion. ");
INSERT INTO suc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Og Gamaꞌ u, ion non nion og poktiduan nog kotubuꞌ. Dadi, og Bataꞌ non siꞌoy, inimung non dosop nog poktiduan nog kotubuꞌ. ");
INSERT INTO suc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Bu binogayan dosop ion nog Gamaꞌ non nog bayaꞌ mongukum poꞌ ion og Binataꞌ sog Kilawan. ");
INSERT INTO suc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Naꞌ amu mosobuꞌ dun poꞌ ongon gondow matong nog glam nog ain mikpomatoy, modongog nilan og sowalan ku ");
INSERT INTO suc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mangka ilan pogbuat tidu sog globong. Ain og molongas og kohinangan non, mogbuat ilan poꞌ motubuꞌ ilan asta sog daꞌ kopus non. Tibua, ain molaton kituꞌ og kohinangan non, mogbuat ilan poꞌ poliholaꞌon ilan. ");
INSERT INTO suc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Daꞌidun og minang u, bila akon da. Og kopongukum u ain da og toluꞌon nog Gamaꞌ u. Bu bila mongukum u, diꞌ u mogbigyaꞌ. Og pogopasan ku moginang, ain kosuꞌatan dun og mikpopangoy kituꞌ dianakon, konaꞌ og dili glawas u. ");
INSERT INTO suc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Bila akon da og monaksiꞌ paꞌali dianakon, diꞌ baꞌis tudon. Tibua, ongon pa lual og tumaksiꞌ paꞌali dianakon. ");
INSERT INTO suc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bu kisunan ku nog og koponaksiꞌ non koyon paꞌali dianakon motud. ");
INSERT INTO suc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Pipangoy niu tanan og dodondagon niu dituꞌ ni Jan nog Polomunyag. Ion tinumaksiꞌ nog motud paꞌali dianakon. ");
INSERT INTO suc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Konaꞌ poꞌ sumboy nog ongon og gotow tumaksiꞌ paꞌali dianakon. Tibua, saꞌan ini tinaluꞌ u poꞌ bagun amu motabang tidu sog dusaanan niu. ");
INSERT INTO suc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Jan mamaꞌ nog tiow. Ion migbogoy nog dolag dianiu bu kisuꞌatan amu dun solianlian. ");
INSERT INTO suc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ongon pa lual og mokosog nog taksiꞌ lual dia ni Jan. Ion non ion og piginang u, og dinondag nog Gamaꞌ u dumoksuꞌ dianakon. Og piginang u numun koni, og mokotaksiꞌ nog ion dodaꞌ og mikpopangoy dianakon dini. ");
INSERT INTO suc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Og Gamaꞌ u nog ion mikpopangoy dianakon, ion dosop og dili tumaksiꞌ paꞌali dianakon. Amu koyon, daꞌ niu sibon kodongog og sowalan non bu daꞌ niu sibon kotongow og bayuꞌbayuꞌ non. ");
INSERT INTO suc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Bu ondaꞌ niu dosop ungodoy og taluꞌ non dianiu poꞌ ondiꞌ amu tumud dia sog pipangoy non kituꞌ dini. ");
INSERT INTO suc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gobi gondow moganad amu nog Kitab poꞌ baluꞌ niu, bianan dion, mokalap amu dun nog kotubuꞌ kituꞌ nog daꞌ kopus non. Tibua, ion non ion og Kitab kituꞌ nog tumaksiꞌ dianakon! ");
INSERT INTO suc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tibua, ompok amu mangoy dianakon malap nog kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Bu konaꞌ og ponontongon ku og dongyaꞌ nog sagyaotow. ");
INSERT INTO suc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tibua, kosunan ku amu nog ondiꞌ amu molalam dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Minangoy u dini bianan dia sog bayaꞌ nog ngalan nog Gamaꞌ u. Tibua, daꞌ niu akon tolimaꞌoy. Bigyaꞌ non, bila og len gotow mangoy dini bianan sog bayaꞌ nog dili ngalan non, tolimaꞌon niu da ion. ");
INSERT INTO suc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Loliagon amu tokodoy pogdongyaꞌan nog pakasiotow niu. Tibua, ondiꞌ amu loliagon mogapas moginang nog ginang kituꞌ nog mondom kodongyaꞌan dun og Mikpongon. Bila maꞌ nituꞌ, olo ma mogandun kotud niu dianakon? ");
INSERT INTO suc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Tibua, naꞌ amu momikil nog sumbungon ku amu dia sog Gamaꞌ u. Sugaꞌid non, si Muses og moksumbung dianiu, og dodomaan niu kituꞌ bosia nog tumabang dianiu. ");
INSERT INTO suc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Somoꞌ tinumud amu dia ni Muses, tumud amu dosop bosia dianakon poꞌ sinulat non kituꞌ og paꞌali dianakon. ");
INSERT INTO suc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Dadi, sabap sog ondiꞌ amu tumud dia sog sinulat non kituꞌ, olo ma og mogandun og kotud niu dia sog piktaluꞌ u koni?” ");
INSERT INTO suc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tubus nituꞌ, ongon gondow non, tinumolipag ilan sog danow nog Galili. Og koduaꞌ ngalan non og danow koyon og Tiberias. ");
INSERT INTO suc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Modakol og gotowanan nog mikpogunut dianon sabap sog gingyataꞌanan nog mitongow nilan nog kinumodag og gotowanan dun. ");
INSERT INTO suc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Bu tinumukad si Isus ilan nog sulangguꞌanan non sog buntud mangka ilan ingkud dion. ");
INSERT INTO suc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Bu daliꞌ na datong og tang nog kologyaꞌan nog gotow Hudyu nog iningolanan Liniusan. ");
INSERT INTO suc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Dangan mibontow ni Isus nog modakol og gotowanan posunguꞌ dituꞌ non, sinakan non si Pilip nog, “Ain ita gidoy pokosaluy nog ponganon bagun kokanan og gotowanan koni dun?” ");
INSERT INTO suc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Sinak non ini poꞌ og tontongan non dia ni Pilip. Tibua, sunan non na bog olo og inangon non. ");
INSERT INTO suc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tinumabal si Pilip nog, “Minsan siꞌoy tipoton ta moksaluy og duaꞌ gatus dinari, ondiꞌ ilan pa mogatul dun monopoti siꞌoy.” ");
INSERT INTO suc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tibua, si Andriu, og gilug ni Simun Piter bu solabuk dosop sulangguꞌ ni Isus, miktaluꞌ nog, ");
INSERT INTO suc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Koni og bataꞌ laki koni, migbalun nog lima buk mokolintokon nog pan nog barli bu duaꞌ buk sodaꞌ nog mokolintokon dosop. Tibua, olo ma mogandun kopogbonad dun dia sog dakol nog gotowanan koni?” ");
INSERT INTO suc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dadi, miktaluꞌ si Isus nog, “Pingkud niu og gotowanan koyon dion.” (Og bonua koyon og kan kolobowan.) Dadi, mikpongingkud og glam nog gotowanan koyon. Og dakol nog kolokianan tibua, ongon lima ngibu kotow. ");
INSERT INTO suc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tubus nion, inalap ni Isus og pan kituꞌ mangka non posolomatoy sog Mikpongon mangka non pogotuloy dia sog gotowanan koyon nog mikpongingkud dion sog goktob nog glegan nilan. Bu maꞌ nituꞌ dosop og kopogbahagiꞌ non nog sodaꞌ kituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Dangan mibosug ilan na, og glam nilan, miktaluꞌ si Isus sog sulangguꞌanan non nog, “Angoy niu pogalap og samaꞌ nilan koyon kuman bagun ondiꞌ mogasta.” ");
INSERT INTO suc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dadi, pingalap nilan og samaꞌ nilan koyon kuman nog pan nog barli. Og miomud nilan dun sopuluꞌ bu duaꞌ bogyas nog lunsan mikpokponuꞌ. ");
INSERT INTO suc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Og gotowanan nog mikotongow nog gingyataꞌ kituꞌ nog ininang ni Isus, miktaluꞌ ilan nog, “Ion non na bayuꞌ ini og Polomolatas kituꞌ nog taluꞌ nog Mikpongon nog pokpodotongon ta dini sog dunya!” ");
INSERT INTO suc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kisunan ni Isus nog poksipian nilan ion tumogol mimung nog datuꞌ nilan. Dadi, migdoduoy ion milaguy dituꞌ posunguꞌ sog bontud. ");
INSERT INTO suc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dangan miksindopondow na, minangoy og sulangguꞌanan non koyon sog goksid nog danow. ");
INSERT INTO suc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Sinumakoy ilan sog bolangoy nilan mangka ilan tulak posunguꞌ sog Kapernaum. Modolom na saka, ondaꞌ pa si Isus datong dituꞌ nilan. ");
INSERT INTO suc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bu linumandos og galuꞌ bu linumuksang og nabok. ");
INSERT INTO suc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Dangan mikpomolula ilan na lagaꞌ nog gonom kilumitru bu moginongaꞌ kumontas nog danow koyon, mitongow nilan si Isus pokpanow sog dibabow nog danow koyon posunguꞌ dituꞌ nilan. Dadi, kiondokan ilan tokodoy dun. ");
INSERT INTO suc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tibua, miktaluꞌ si Isus dianilan nog, “Naꞌ amu kondokan poꞌ akon da ini!” ");
INSERT INTO suc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dadi, daꞌ ilan da kondok mokposakoy dianon dia sog bolangoy nilan koyon bu sododuꞌun minatong ilan dituꞌ sog posunguꞌan nilan koyon. ");
INSERT INTO suc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Migbolomaꞌ ion, og gotowanan kituꞌ nog piokan ni Isus nog dituꞌ da mibagak sog dipag nog danow, kilobotan nilan nog kolabung solabuk da og bolangoy dion. Bu dangan tinumulak og sulangguꞌanan ni Isus, migdoduoy ilan tumulak nog ilanilan da poꞌ si Isus ondaꞌ pogunut dianilan. ");
INSERT INTO suc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tubus nituꞌ, ongon og bolangoyanan nog tidu sog Tiberias nog mikpongdongguꞌ ilan dituꞌ sog molani nog bonua kituꞌ nog piokanan ni Isus sog gotowanan nog pan mitubus non posolomatoy sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Dangan mitintu nog gotowanan koyon nog daꞌ dia si Isus bu og sulangguꞌanan non, mikponakoy ilan dia sog bolangoyanan kituꞌ mangka tulak posunguꞌ sog Kapernaum poꞌ ponontongon nilan ion dituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Dangan mitongow nilan si Isus dituꞌ sog dipag, sinakan nilan ion nog, “Rabi, nanu a pa minatong dini?” ");
INSERT INTO suc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tinabal non ilan nog, “Toluꞌon ku dianiu, nog saꞌan ion pokponontongon niu akon, konaꞌ poꞌ sabap sog mitongow niu og gingyataꞌanan nog gininang u, sugaꞌid non, sabap sog mikokan amu nog boyaꞌan mikpogbosug amu tanan. ");
INSERT INTO suc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Naꞌ amu monukat nog ponganon nog monglos da. Sugaꞌid non, ponomaloy niu moksukat og ponganon kituꞌ nog diꞌ monglos nog mokobogoy nog kotubuꞌ nog daꞌ kopus non. Og mokobogoy nog ponganon koni dianiu og Binataꞌ sog Kilawan. Poꞌ og tandaꞌ nog ion togo bayaꞌ, binogoy na dianon nog Gamaꞌ nog ion og Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dadi, miksak ilan dianon nog, “Olo ma og ginangon nami bagun nami minang og glegan nog Mikpongon?” ");
INSERT INTO suc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tinumabal si Isus nog, “Og glegan nog Mikpongon nog inangon niu maꞌ nini, sumboy tumud amu dia sog pipangoy non kituꞌ dini sog dunya.” ");
INSERT INTO suc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Dadi, miksak ilan nosop nog, “Olo ma og ompotongow mu nog gingyataꞌ dianami bagun ami tumud dianika? ");
INSERT INTO suc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Og mokogulanganan ta kobon nituꞌ, masa ni Muses nog dituꞌ ilan pa sog bonua kituꞌ nog mologon pogonongan, og piglokan nilan og mana. Maꞌ nog sinulat kituꞌ sog Kitab nog, ‘Binogayan non ilan nog ponganon nog miktidu sog glangit.’” ");
INSERT INTO suc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Dadi, maꞌ long ni Isus dun, “Toluꞌon ku dianiu nog konaꞌ ituꞌ ni Muses og migbogoy nog ponganon kituꞌ nog miktidu sog glangit. Sugaꞌid non, og Gamaꞌ u, ion og mogbogoy dun dianiu og tantu nog ponganon nog miktidu sog glangit. ");
INSERT INTO suc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Poꞌ og ponganon nog miktidu sog Mikpongon, ion non ion og tinumonaꞌ kituꞌ tidu sog glangit nog ion og mogbogoy nog kotubuꞌ dia sog gotowanan dini sog dunya.” ");
INSERT INTO suc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Dadi, miktaluꞌ ilan nog, “Polopanad, tidu numun kituꞌ, bogoyoy mu pa ami nog ponganon koyon.” ");
INSERT INTO suc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Miktaluꞌ si Isus nog, “Akon, ion non ion og ponganon koyon nog mogbogoy nog kotubuꞌ nog daꞌ kopus non. Ain og gotow nog mangoy dini nakon, ondiꞌ nododaꞌ ion kogutoman. Bu ain og tumud dianakon, ondiꞌ nododaꞌ ion kuowon. ");
INSERT INTO suc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tibua, tinaluꞌ u na, nog minsan siꞌoy mitongow niu na akon, ondiꞌ amu nododaꞌ tumud dianakon. ");
INSERT INTO suc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Og glam nog binogoy nog Gamaꞌ u dianakon nog gotowanan, mangoy ilan dini nakon. Bu simasima og mangoy dini nakon, ondiꞌ u ilan bugowon. ");
INSERT INTO suc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Poꞌ saꞌan minangoy u dini tidu sog glangit, konaꞌ poꞌ inangon ku og dili glegan ku, sugaꞌid non, og moginang nog glegan nog mikpopangoy kituꞌ dianakon. ");
INSERT INTO suc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Bu maꞌ nini og glegan nog mikpopangoy kituꞌ dianakon nog ondiꞌ u kobolongan nog glam nog binogoy non dianakon, minsan sala kotow siꞌoy. Sugaꞌid non, potubuꞌon ku da ilan puliꞌ sog matong og gimpusan nog gondow. ");
INSERT INTO suc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Poꞌ og glegan nog Gamaꞌ u nog simasima og mikotongow sog Bataꞌ non bu tinumud dianon, kongonan ilan nog kotubuꞌ nog daꞌ kopus non, bu potubuꞌon ku ilan puliꞌ sog gimpusan nog gondow.” ");
INSERT INTO suc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tubus nituꞌ, og kounutananan nog gotow Hudyu koyon, mikpokumodumod ilan sabap sog taluꞌ ni Isus kituꞌ nog ion og ponganon tinumonaꞌ tidu sog glangit. ");
INSERT INTO suc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Dadi, mikpoktaluꞌ ilan nog, “Konaꞌ taꞌ ion ni Isus nog og bataꞌ ni Jusep? Kilolaan ta og ginaꞌamaꞌ non. Saka moktaluꞌ ma nog ion og tinumonaꞌ kituꞌ tidu sog glangit?” ");
INSERT INTO suc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dadi, miktaluꞌ si Isus nog, “Naꞌ amu mokpokumodumod dion. ");
INSERT INTO suc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ondaꞌidun og mokangoy dini nakon taman da diꞌ ion ponuluꞌan nog Gamaꞌ u nog ion og mikpopangoy dianakon. Bu potubuꞌon ku ion puliꞌ sog gimpusan nog gondow. ");
INSERT INTO suc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Poꞌ sinulat nog polomolatasanan nog taluꞌ nog Mikpongon kobon nituꞌ nog, ‘Og glam nog gotow ponadan nog Mikpongon.’ Dadi, ain og monginongog dia sog Gamaꞌ bu moganad dianon, mangoy dini nakon. ");
INSERT INTO suc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ondaꞌidun og mikotongow nog Gamaꞌ lual da ion nog miktidu sog Mikpongon. Sala non da og mikotongow nog Gamaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Poꞌ toluꞌon ku dianiu nog simasima og tumud dianakon, mialap non na og kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Akon og ponganon nog poktiduan nog kotubuꞌ. ");
INSERT INTO suc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Og mokogulanganan niu kituꞌ kobon nituꞌ, masa pa nog dituꞌ ilan sog bonua kituꞌ nog mologon pogonongan, piglokan nilan og mana. Mamaꞌ nituꞌ siꞌoy, mikpomatoy ilan da. ");
INSERT INTO suc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tibua, og pogolongon ku koni nog ponganon, ion non og tinumonaꞌ tidu sog glangit. Simasima kuman dun ondiꞌ na matoy. ");
INSERT INTO suc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Akon og ponganon kituꞌ nog tinumonaꞌ tidu sog glangit nog mogbogoy nog kotubuꞌ. Simasima og kuman dun, ondiꞌ ion matoy, sugaꞌid non, motubuꞌ ion asta sog daꞌ kopus non. Og ponganon koni, ion non og gungod u nog bogoyon ku bagun mimung nog kotubuꞌ nog gotowanan dini sog dunya.” ");
INSERT INTO suc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dangan midongog nog kounutananan kituꞌ nog Hudyu og tinaluꞌ ni Isus koyon, miglanduꞌ og susian nilan ilan bu ilan. “Olo og mogandun kopokan nog gotow koyon dianita nog gungod non?” ");
INSERT INTO suc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Dadi, miktaluꞌ si Isus nog, “Toluꞌon ku dianiu nog taman da ondiꞌ amu kuman nog gungod nog Binataꞌ sog Kilawan bu minum nog duguꞌ non, ondaꞌidun kotubuꞌ dianiu. ");
INSERT INTO suc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Poꞌ simasima og kuman nog gungod u bu minum nog duguꞌ u, ion og mokalap nog kotubuꞌ nog daꞌ kopus non bu potubuꞌon ku ion puliꞌ sog gimpusan nog gondow. ");
INSERT INTO suc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Poꞌ og gungod u og tantu nog ponganon, bu og duguꞌ u og tantu nog ginumon. ");
INSERT INTO suc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Simasima og kuman nog gungod u bu minum nog duguꞌ u, ion sinumolabuk dianakon bu akon dia u non. ");
INSERT INTO suc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Og Gamaꞌ u nog og piktiduan nog kotubuꞌ, og mikpopangoy dianakon dini sog dunya. Bu saꞌan mitubuꞌ u poꞌ sabap dianon. Dadi, simasima og kuman dianakon, motubuꞌ ilan sabap dianakon. ");
INSERT INTO suc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ion non ion og pogolongon ku koyon nog ponganon nog tinumonaꞌ tidu sog glangit. Og mokogulanganan niu kobon nituꞌ, mikokan ilan siꞌoy nog mana, mikpomatoy ilan da. Tibua, ain og gotow kituꞌ nog kuman nog ponganon koni nog pigolong u, motubuꞌ asta sog daꞌ kopus non.” ");
INSERT INTO suc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Og glam nini tinaluꞌ ni Isus solian non mokpanad dituꞌ sog baloy nog poglumpukan nog bansa Hudyu dituꞌ sog Kapernaum. ");
INSERT INTO suc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dangan midongog nilan ini, modakol og sulangguꞌanan non og mikpoktaluꞌ nog, “Og pikpanad non koyon mologon tokodoy. Sima gidoy og moleg tumabuk dun?” ");
INSERT INTO suc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kisunan da ni Isus og pikumodumod nilan koyon. Dadi, miktaluꞌ ion nog, “Sabap dini ombagla taꞌ og tud niu dun dianakon? ");
INSERT INTO suc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Labi na bayuꞌ bila motongow niu nog og Binataꞌ sog Kilawan moktolabang posunguꞌ dituꞌ sog piktiduan non! ");
INSERT INTO suc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Og mokobogoy nog kotubuꞌ, og Bolakat da nog Mikpongon. Ondiꞌ ini minang nog sagyaotow. Og taluꞌ u kituꞌ nog tinaluꞌ u dianiu, mogokbit dianiu sog Bolakat nog Mikpongon nog ion mogbogoy nog kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tibua, og duma dianiu ondiꞌ tumud dun.” (Poꞌ donsamaꞌ na ni Isus kisunan bog sima dodaꞌ dianilan og ondiꞌ kituꞌ tumud bu sima dosop og moguakil kituꞌ dianon sog glaꞌat.) ");
INSERT INTO suc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Bu miktaluꞌ pa si Isus nog, “Saꞌan ini tinaluꞌ u dianiu nog daꞌidun mokangoy dini nakon, bog diꞌ da ion kumboyon nog Gamaꞌ u.” ");
INSERT INTO suc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sabap dituꞌ, modakol mikpogawaꞌ nog sulangguꞌanan non bu daꞌ ilan na pogunutunut dianon. ");
INSERT INTO suc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Dadi, tinoluꞌan ni Isus og sopuluꞌ bu duaꞌ kotow sulangguꞌanan non koyon nog, “Amu buan, gonatan niu taꞌ dosop akon?” ");
INSERT INTO suc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tinabal ion ni Simun Piter nog, “Kounutan, sima ma doga buan og pogunutan nami? Dia doma nika og taluꞌ kituꞌ nog mokobogoy nog kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Dadi, tinumud ami bu mitintu na dianami nog ika dodaꞌ og Mosigda kituꞌ nog miktidu sog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tubus nituꞌ, tinumabal si Isus nog, “Amu koyon, nog sopuluꞌ bu duaꞌ kotow, akon og mimiliꞌ dianiu. Tibua, maꞌ nituꞌ siꞌoy, ongon pa dianiu og pogboyaꞌan ni Kindagow.” ");
INSERT INTO suc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Og pigolong non koyon si Judas, og bataꞌ ni Simun Iskariot. Poꞌ minsan siꞌoy misunuꞌ na ion sog sopuluꞌ bu duaꞌ sulangguꞌanan ni Isus, ion da og miguakil dia ni Isus sog glaꞌat. ");
INSERT INTO suc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tubus nituꞌ, migdundaan si Isus sog bonua nog Galili poꞌ migolig ion mangoy sog Judia poꞌ poksipian ion munuꞌ nog kounutananan nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tibua, dangan daliꞌ na datong og kologyaꞌan nog bansa Hudyu nog iningolanan Og Ginang sog Kolokowan, ");
INSERT INTO suc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","miktaluꞌ og putupusodanan non dianon nog, “Gonatoy mu og bonua koni bu angoy a dituꞌ sog Judia bagun da motongow nog sulangguꞌanan mu dituꞌ og gingyataꞌanan mu. ");
INSERT INTO suc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Poꞌ og gotow nog moleg ompulonag og bontugan non, sumboy ondiꞌ non bunion og ginang non koyon. Dadi, bila ininang mu noma og maꞌ nion koyon, sumboy potongowon mu na og glawas mu sog glam nog gotowanan.” ");
INSERT INTO suc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Saꞌan ituꞌ maꞌ nituꞌ og tinaluꞌ nog putupusodanan non koyon dianon poꞌ ilan siꞌoy, daꞌ ilan pa tud dianon. ");
INSERT INTO suc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Dadi, tinabal ilan ni Isus nog, “Ondaꞌ pa datong og tang nog bagun u kilolaan nog gotowanan. Tibua amu, minsan olo tangoy dun, mogusoy da dianiu. ");
INSERT INTO suc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Poꞌ ondiꞌ amu da kopokongitan nog gotowanan dini sog dunya. Tibua akon, pokongitan nilan akon poꞌ sabap sog kobon non poktoluꞌon ku dianilan og kohinangan nilan nog molaton. ");
INSERT INTO suc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Dadi, angoy amu na tuaꞌ sog ginang kituꞌ. Akon, ondiꞌ u pa sokaliꞌ poꞌ konaꞌ pa og tang nog mokpotongow u.” ");
INSERT INTO suc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Dadi, migonongonong pa ion sog Galili. ");
INSERT INTO suc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Dangan mikogonat og putupusodanan non koyon posunguꞌ sog kologyaꞌan kituꞌ sog Jerusalem, ion siꞌoy minangoy dosop dituꞌ. Tibua, ondaꞌ ion pokpotampal dia sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Og kounutananan nog bansa Hudyu, pikponontong nilan ion dion sog kologyaꞌan koyon bu kobon nilan moksak dun nog, “Ain gidoy og gotow kituꞌ dun?” ");
INSERT INTO suc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bu og gotowanan koyon dion, mikpogilomilom ilan paꞌali dianon. Og dumaanan mokpoktaluꞌ ilan nog, “Molongas ion nog gotow.” Tibua, og dumaanan sop mokpoktaluꞌ nog, “E, ondiꞌ le, sugaꞌid non, og gotow koyon poglimbungan non tibua og gotowanan.” ");
INSERT INTO suc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tibua, daꞌ nilan toluꞌoy dia sog kodokolan poꞌ mondok ilan dia sog kounutananan nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Dangan migoginongaꞌ na og kologyaꞌan koyon, minangoy si Isus sog glomalomaan nog Baloy nog Poktomuyan dia sog Mikpongon mangka ion poktolipun mokpanad dituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Dangan midongog nog kounutananan nog bansa Hudyu og pikpanad non koyon, kisobuꞌan ilan tokodoy dun. Miksinaksakoy ilan nog, “Ain non gidoy mialap og kotoan non koyon saka ondaꞌidun og mikpanad dun dianon?” ");
INSERT INTO suc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Dadi, tinabal ilan ni Isus nog, “Og pikpanad u koni, ondaꞌ poktidu sog dili kotoan ku, sugaꞌid non, dituꞌ miktidu sog mikpopangoy kituꞌ dianakon dini. ");
INSERT INTO suc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ain og moleg mokokunut dia sog glegan nog Mikpongon, kosunan non bog ain miktidu og pikpanad u koni bog dia taꞌ sog Mikpongon otawaka dia taꞌ sog dili pomikilan ku. ");
INSERT INTO suc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bila og gotow mokpanad nog dia da tidu sog dili pomikilan non, og pogopason non bagun tibua pogdongyaꞌan nog gotowanan. Tibua, og gotow kituꞌ nog mogapas moginang bagun ompotas dun og mikpopangoy kituꞌ dianon, ondiꞌ ion kotongowan nog diꞌ motud. ");
INSERT INTO suc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Konaꞌ taꞌ nog binogayan amu ni Muses nog pogbotadon niu? Saka daꞌidun motanan, sala kotow siꞌoy, og mikokunut dun! Iduma poksipian niu ma akon munuꞌ?” ");
INSERT INTO suc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tinumabal og gotowanan nog, “Tinosopan ka bayuꞌ nog glatdiwata! Sima moleg munuꞌ dianika?” ");
INSERT INTO suc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tinumabal si Isus nog, “Saka buan mosobuꞌ amu ma dun bu pogokaꞌon niu ma akon dun dangan ininang u nog solabuk ginang kituꞌ nog kosobuꞌsobuꞌ sog Gondow nog Pogulali? ");
INSERT INTO suc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Si Muses dinumondag kobon nituꞌ nog og gombataꞌ niu nog glaki sumboy tukon. (Og botad kituꞌ ondaꞌ dianon miktidu, sugaꞌid non, dia pa miktidu sog mokogulanganan kituꞌ nog mikuna pa dianon.) Bu bila ombonaꞌ og kopoktuk nog gombataꞌ niu sog Gondow nog Pogulali, tukon niu da. ");
INSERT INTO suc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Dadi, bila tukon niu og gombataꞌ niu sog Gondow nog Pogulali bagun niu munut og pogbotadon ni Muses, iduma lolingitan amu ma dianakon bila pokodagon ku og gotow sog Gondow nog Pogulali? ");
INSERT INTO suc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Naꞌ niu ukumon og gotow nog sagya tibua motongow niu dianon. Sugaꞌid non, liling niu nog mahatul og kohinangan non bianan sog motud.” ");
INSERT INTO suc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tubus nituꞌ, ongon og duma gotowanan sog Jerusalem miksak nog, “Konaꞌ non taꞌ gidoy ion og gotow kituꞌ nog poksipian nilan munuꞌ? ");
INSERT INTO suc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tontong niu poloꞌma ion, dion ion mimali sog kodokolan nog gotow, saka, daꞌ nilan ma ion pomagoy dun. Og kounutananan koyon, mimikil ilan taꞌ gidoy nog ion non na ion og Kristu kituꞌ? ");
INSERT INTO suc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tibua, og gotow koni, kisunan ta na ini bog ain ion miktidu. Saka, og Kristu kituꞌ, bila matong na ion, ondaꞌidun og mokosun dun bog ain poktidu.” ");
INSERT INTO suc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Sog solian pa ni Isus mokpanad dion sog glomalomaan nog Baloy koyon nog Poktomuyan dia sog Mikpongon, miktaluꞌ ion nog mosikad nog, “Oꞌo! Bila amu, long niu dun, kisunan niu akon bu kosunan niu dosop bog ain u miktidu. Tibua, ondaꞌ u angoy dini nog dili bayaꞌ u. Sugaꞌid non, ngon og mikpopangoy dianakon dini bu ion motud. Ondaꞌ niu ion kilolaoy. ");
INSERT INTO suc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tibua akon, kilolaan ku ion poꞌ dituꞌ u non miktidu bu ion og mikpopangoy dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Dadi, sabap dituꞌ, inangoy nilan bosia ukpaꞌoy. Tibua, ondaꞌidun mokogonop mukpaꞌ dianon poꞌ daꞌ pa datong og tang non. ");
INSERT INTO suc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tibua, modakol da og gotowanan og tinumud dianon. Bu long nilan dun, “Bila matong na og Kristu, mokinang taꞌ gidoy ion nog gingyataꞌanan nog labi pa sog gininang nog gotow koni?” ");
INSERT INTO suc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Og parasiuanan koyon, midongog nilan og gilom nog gotowanan koyon paꞌali dia ni Isus. Dadi, ilan bu og mokokotas nog boliananan koyon, dinumondag ilan nog polongipatanan koyon nog Baloy nog Poktomuyan dia sog Mikpongon nog ongoyon nilan ukpaꞌoy si Isus. ");
INSERT INTO suc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Miktaluꞌ si Isus dia sog gotowanan nog, “Mokunul ita pa niu podaliꞌdaliꞌ. Tubus nituꞌ, mokpuliꞌ u na dituꞌ sog mikpopangoy kituꞌ dianakon. ");
INSERT INTO suc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pokponontongon niu akon, tibua, ondiꞌ niu akon motongow poꞌ og gongayan ku ondiꞌ amu mokangoy dun.” ");
INSERT INTO suc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dangan midongog nog kounutananan nog bansa Hudyu og tinaluꞌ ni Isus kituꞌ, miksinaksakoy ilan nog, “Ain gidoy poksipi mangoy og gotow koyon nog ondiꞌ ta ion motongow dun? Mangoy taꞌ gidoy ion sog bonuaanan nog Girik nog ain pigonongan nog pakasi Hudyuanan ta bu pokpanad ion dia sog gotow Girik? ");
INSERT INTO suc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Olo gidoy og maꞌana nog piktaluꞌ non koyon nog pokponontongon ta ion, tibua, ondiꞌ ta ion motongow bu ondiꞌ ita mokangoy sog ain gongayan non?” ");
INSERT INTO suc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Og gimpusan nog gondow nog kologyaꞌan koyon, ion non og bololagaꞌ tokodoy. Sog tang koyon minindog si Isus mangka poktaluꞌ nog mosikad nog, “Simasima og kuowon dianiu, mangoy ion dini nakon mangka inum! ");
INSERT INTO suc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Simasima og tumud dianakon, mimung maꞌ nog sinulat kituꞌ sog Kitab nog, ‘Moglayas tidu sog dialom non og tubig nog mogbogoy nog kotubuꞌ nog daꞌ kopus non.’” ");
INSERT INTO suc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Og pigolong non koyon, ion non og Bolakat nog Mikpongon nog motabuk nog gotowanan sog gunanunan koyon nog ain tinumud kituꞌ dia ni Isus. Sog tang kituꞌ, ondaꞌ pa bogoyoy og Bolakat nog Mikpongon poꞌ ondaꞌ pa si Isus potasoy dituꞌ sog glangit. ");
INSERT INTO suc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Dangan midongog nilan og piktaluꞌ ni Isus koyon, ongon miktaluꞌ nog, “Og gotow koni, ion non dodaꞌ og Polomolatas kituꞌ nog taluꞌ nog Mikpongon nog pokpodotongon ta.” ");
INSERT INTO suc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Miktaluꞌ sop og dumaanan nog, “Ion non ini og Kristu!” Ongon dosop miktaluꞌ nog, “Og Kristu, ondaꞌ ion dituꞌ poktidu sog Galili. ");
INSERT INTO suc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Poꞌ long pa nog sinulat nog taluꞌ nog Mikpongon, og Kristu kituꞌ dituꞌ poktidu sog pangkat ni Apuꞌ Dabid bu dituꞌ ion botaꞌoy sog Betlehem, og bonua nog pigonongan ni Apuꞌ Dabid kobon nituꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sabap sog maꞌ nituꞌ og pikilan nilan paꞌali dia ni Isus, mibahagiꞌ og gotowanan dun. ");
INSERT INTO suc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Og duma dianilan, moleg mukpaꞌ dianon. Tibua, daꞌ nilan kinang. ");
INSERT INTO suc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Dadi, og polongipatanan nog Baloy nog Poktomuyan koyon mikpuliꞌ sog parasiuanan bu mokokotas kituꞌ nog boliananan. Sinakan ilan nog, “Olo nion? Daꞌ niu ma ion oitoy dini!” ");
INSERT INTO suc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dadi, tinumabal og polongipatanan koyon nog, “Ondaꞌidun pa sibon gotow nog mikopoktaluꞌ mamaꞌ nog kopoktaluꞌ non.” ");
INSERT INTO suc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sokaliꞌ tinumabal og parasiuanan koyon nog, “Aba, amu siꞌoy, kibigyakan non dosop bayuꞌ amu? ");
INSERT INTO suc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Daꞌidun tanan sala kotow siꞌoy nog kounutananan nog bansa ta bu og parasiuanan koni og tinumud dianon. ");
INSERT INTO suc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Og gotowanan koyon, og sobuꞌ ilan nog botad nog pilatas ni Muses. Saꞌan da poliholaꞌon ilan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ongon sala kotow dianilan dion si Nikudimus. Ion non og parasiu kituꞌ nog sibon mangoy dituꞌ ni Isus nog gobi. Miktaluꞌ ion dianilan nog, ");
INSERT INTO suc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Long pa nog Botad ta, ondiꞌ ita mokopongdodaliꞌ mongukum nog gotow tontal da diꞌ ta inongogan mahatul bagun ta kosunan bog olo dodaꞌ og kohinangan non.” ");
INSERT INTO suc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Sokaliꞌ tinumabal og duma parasiuanan koyon nog, “Tidu a taꞌ dosop sog Galili? Liling mu mahatul bog olo og sinulat sog Kitab poꞌ dion nika kotongow nog daꞌidun og polomolatas nog taluꞌ nog Mikpongon nog moktidu sog Galili.”  ");
INSERT INTO suc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tubus nion og glam nilan dion, mikpoguliꞌ ilan na. ");
INSERT INTO suc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tibua, si Isus, minangoy ion sog bulud nog ngalan non Olibu. ");
INSERT INTO suc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Migbolomaꞌ ion, daliꞌondow pa bonua, minangoy ion puliꞌ sog glomalomaan nog Baloy koyon nog Poktomuyan dia sog Mikpongon. Modakol nog gotowanan og miglibut dianon. Dia ion pogingkud sog titongaꞌ nilan mokpanad dianilan. ");
INSERT INTO suc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Solian non mokpanad, minatong og polopanadanan nog botad nog bansa Hudyu bu og parasiuanan. Migoit ilan nog glibun nog kibuyaꞌan nilan monglaki mangka nilan pindogoy og glibun koyon sog sunguꞌan nog gotowanan koyon ");
INSERT INTO suc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","mangka ilan poktaluꞌ dia ni Isus nog, “Polopanad, og glibun koni kibuyaꞌan nami monglaki. ");
INSERT INTO suc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Long pa nog Botad ta dun, og dinondag ni Muses nog og gotow nog mokohinang mamaꞌ nog gininang nog glibun koni, sumboy botuon ion asta matoy. Bila buan ika, olo ma og motaluꞌ mu dun?” ");
INSERT INTO suc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Saꞌan ion sinakan nilan si Isus nog maꞌ nion poꞌ pogolapsobapan nilan ion bagun ongon og dalan nilan sumumbung dianon. Tibua, minakung si Isus mangka ponulat nog tonduꞌ non dia sog glupaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sintak nilan koyon moksak dianon, minindog si Isus mangka ion poktaluꞌ nog, “Sima og daꞌidun dusa non dianiu, ion og moguna matu sog glibun koni.” ");
INSERT INTO suc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tubus nituꞌ, minakung nosop ion mangka sulat mokpuliꞌ dia sog glupaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Dangan midongog nilan og taluꞌ ni Isus koyon, piksigonatan nilan ion miguna og mokogulanganan asta og mibagak dion si Isus bu og glibun koyon nog pogindog dion. ");
INSERT INTO suc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Dadi, minindog si Isus mangka ion poksak dia sog glibun koyon nog, “Ibun, ain ilan noma dun? Ondaꞌidun noma og misamaꞌ dianilan, og moleg mukum dianika?” ");
INSERT INTO suc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Ondaꞌidun na, Polopanad,” long nog glibun koyon dun. Miktaluꞌ si Isus nog, “Bila maꞌ nituꞌ, ondiꞌ u dosop ika ukumon. Uliꞌ a na bu naꞌ mu na inangon puliꞌ og kohinangan mu kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tubus nituꞌ, miktaluꞌ nosop si Isus sog gotowanan nog, “Akon og dolag dia sog glam nog gotowanan dini sog dunya. Simasima og mogunut dianakon, ondiꞌ na ompanow dia sog kodoloman. Sugaꞌid non, og pomikilan non kodolagan nog dolag nog mokobogoy nog kotubuꞌ nog daꞌ kopus non.” ");
INSERT INTO suc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dadi, tinoluꞌan ion nog parasiuanan koyon nog, “Ika, og pinoksiꞌan mu koyon og dili glawas mu da. Dadi, og tinaluꞌ mu koyon ondiꞌ baꞌis tudon.” ");
INSERT INTO suc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sokaliꞌ tinumabal si Isus nog, “Minsan siꞌoy tinoksiꞌan ku og dili glawas u, og piktaluꞌ u ombaꞌis tudon. Poꞌ kosunan ku ain og piktiduan ku bu ain sop og posunguꞌan ku. Tibua amu, ondiꞌ niu kosunan bog ain og piktiduan ku bu ain og posunguꞌan ku. ");
INSERT INTO suc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Amu, bila mongukum amu, dianiu da pobianoy sog kotoan nog sagyaotow. Tibua akon, ondiꞌ u mongukum. ");
INSERT INTO suc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tibua, somoꞌ mongukum u, og koukuman ku motud poꞌ konaꞌ u tibua sala, sugaꞌid non, duaꞌ ami nog Gamaꞌ u, og mikpopangoy kituꞌ dianakon. ");
INSERT INTO suc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sinulat dia sog botad niu nog bila og koponaksiꞌ nog duaꞌ kotow mogbatuk, og koponaksiꞌ nilan koyon motud. ");
INSERT INTO suc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tiganaꞌ, akon og mokotaksiꞌ nog dili glawas u bu koduaꞌ non, og Gamaꞌ u, og mikpopangoy kituꞌ dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dadi, sinakan nilan ion nog, “Ain noma buan dun og Gamaꞌ mu kituꞌ nog pogolongon mu nog tumaksiꞌ dianika?” Tinabal ilan ni Isus nog, “Daꞌ niu akon kilolaoy bog sima u. Bu daꞌ niu dosop kilolaoy og Gamaꞌ u. Somoꞌ kilolaan niu akon, kilolaan niu dosop bosia og Gamaꞌ u.” ");
INSERT INTO suc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Og glam nini tinaluꞌ ni Isus solian non mokpanad dia sog glomalomaan nog Baloy koyon nog Poktomuyan dia sog Mikpongon, sog molani nog poktoguꞌan nilan nog sin nog bogoy nog gotowanan dia sog Mikpongon. Tibua, daꞌidun og mikogonop mukpaꞌ dianon poꞌ ondaꞌ pa datong og tang nog mokpukpaꞌ ion dianilan. ");
INSERT INTO suc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Miktaluꞌ nosop si Isus dianilan nog, “Gumonat u na dini bu minsan siꞌoy ponontongon niu siꞌoy akon, ondiꞌ niu da akon motongow. Bu matag amu na matoy nog dia amu pa sog dusa niu. Ain og gongayan ku ondiꞌ amu mokangoy dun.” ");
INSERT INTO suc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dadi, mikpoktaluꞌ og kounutananan nog bansa Hudyu koyon nog, “Taluꞌ non, ondiꞌ ita mokangoy sog gongayan non. Olo gidoy og maꞌana nog tinaluꞌ non koyon? Mongogotan taꞌ gidoy ion?” ");
INSERT INTO suc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tibua, maꞌ long ni Isus dun, “Gotow lupaꞌan amu da. Tibua akon, miktidu u sog glangit. Bu amu, gotow amu da dini sog dunya koni. Tibua akon, konaꞌ u gotow dini. ");
INSERT INTO suc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tinaluꞌ u na dianiu nog matoy amu nog dia amu pa sog dusaanan niu. Bila ondiꞌ amu tumud dun nog Akon, ion non u na ini, matoy amu nododaꞌ nog dia amu pa sog dusaanan niu.” ");
INSERT INTO suc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dadi, sinakan nilan ion nog, “Sima a dodaꞌ buan?” Tinumabal ion nog, “Maꞌ da nog piktaluꞌ u kituꞌ dianiu tidu pa sog donsamaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Modakol pa og motaluꞌ u paꞌali sog kohinangan niu nog mimung mukum dianiu. Tibua akon, og poktoluꞌon ku dia sog gotowanan ain og midongog u kituꞌ sog mikpopangoy dianakon poꞌ og poktoluꞌon non motud. Dadi, og piktaluꞌ u kituꞌ dianiu motud.” ");
INSERT INTO suc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ondaꞌ nilan kosabut nog og piktaluꞌ non koyon, ion non og Gamaꞌ non sog glangit. ");
INSERT INTO suc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Dadi, miktaluꞌ si Isus nog, “Bila motundok niu na og Binataꞌ sog Kilawan, dion kosunan niu na nog Akon, ion non u na ini. Bu kosunan niu dosop nog daꞌ u poginang nog dili bayaꞌ u. Sugaꞌid non, miktaluꞌ u tibua nog ain pinanad nog Gamaꞌ u dianakon. ");
INSERT INTO suc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ion og mikpopangoy bu dinumuma dianakon. Bu daꞌ non akon potiangoy. Poꞌ moginang u somul non nog ain mosuꞌat kituꞌ dianon.” ");
INSERT INTO suc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Dadi, modakol og mikodongog nog piktaluꞌ non koyon nog boyaꞌan tinumud ilan dianon. ");
INSERT INTO suc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Dadi, miktaluꞌ si Isus dia sog Hudyuanan kituꞌ nog tinumud dianon nog, “Bila mokokunut amu dia sog pomali u, amu og tantu nog sulangguꞌanan ku. ");
INSERT INTO suc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Bu bianan dituꞌ kosunan niu bog olo og motud. Bu bianan sog motud koyon, mogawon amu dun tidu sog kouliponan.” ");
INSERT INTO suc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tinabal nilan ion nog, “Iduma moktaluꞌ a ma nog gowonon ami saka og pangkat ami ni Apuꞌ Abraham bu ondaꞌ ami sibon kulipon?” ");
INSERT INTO suc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tinabal ilan ni Isus nog, “Toluꞌon ku dianiu, ain og gotow nog ondiꞌ lumotaꞌ moginang nog dusa, ion miulipon nog dusa. ");
INSERT INTO suc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Og gulipon konaꞌ sakup sog konglangan. Tibua, og bataꞌ sakup nododaꞌ nog konglangan kobon non. ");
INSERT INTO suc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dadi, bila gowonon amu nog Bataꞌ nog Mikpongon, mogawon amu na dodaꞌ tidu sog kouliponan. ");
INSERT INTO suc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kosunan ku nog amu, pangkat amu ni Abraham. Tibua, pangkat non siꞌoy amu, poksipian niu akon munuꞌ poꞌ diꞌ niu tolimaꞌon og pomali u koni dianiu. ");
INSERT INTO suc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Og tinaluꞌ u koni dianiu ain og mitongow u kobon ku dia sog Gamaꞌ u. Tibua, og piginang niu koyon ain og midongog niu dia sog gamaꞌ niu.” ");
INSERT INTO suc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tinumabal ilan nog, “Og gamaꞌ nami si Abraham.” Dadi, tinabal ilan ni Isus nog, “Somoꞌ og tantu amu gombataꞌanan ni Abraham, ilingan niu bosia og ginang ni Abraham. ");
INSERT INTO suc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tibua, poksipian niu ma tanan akon munuꞌ. Saka akon og mikposampot dianiu nog motud nog midongog u sog Mikpongon. Si Abraham ondaꞌ poginang nog mamaꞌ nog kohinangan niu koyon. ");
INSERT INTO suc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Og piglogilingan niu koyon og kohinangan nog dili gamaꞌ niu.” Dadi, tinumabal ilan nog, “Konaꞌ ami og kolombiadaꞌ. Solabuk da og gamaꞌ nami, ion non og Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Miktaluꞌ si Isus nog, “Somoꞌ motud nog gamaꞌ niu og Mikpongon, mololat amu bosia dianakon. Poꞌ saꞌan dini u poꞌ dituꞌ u non miktidu. Konaꞌ u og dili bayaꞌ og kangoy u koni dini, sugaꞌid non, pipangoy non akon dini. ");
INSERT INTO suc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Iduma ondiꞌ niu ma mosabut og poktoluꞌon ku koni? Saꞌan ondiꞌ niu mosabut poꞌ diꞌ niu pokinongogan og taluꞌ u. ");
INSERT INTO suc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mingunut amu dodaꞌ sog dili gamaꞌ niu nog si Kindagow bu moleg amu moginang nog ain glegan non. Ion donsamaꞌ na polomunuꞌ bu daꞌidun og balan non nog motud poꞌ glam nog kohinangan non ondiꞌ motud. Og tantu ponoluꞌon non og gloput poꞌ moloput nododaꞌ ion. Bu ion og poktiduan nog gloput. ");
INSERT INTO suc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Saꞌan poma, dangan miktaluꞌ u nog motud, ondiꞌ amu tumud dianakon. ");
INSERT INTO suc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sima og mikotaksiꞌ dianiu dion nog akon togo dusa u? Bila moktaluꞌ u nog motud dianiu, iduma ondiꞌ amu ma tumud dun? ");
INSERT INTO suc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Og gombataꞌanan nog Mikpongon monginongog nog taluꞌ non. Saꞌan ondiꞌ amu mokinongog dianakon poꞌ sabap sog konaꞌ amu og gombataꞌanan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tinabal si Isus nog kounutananan nog bansa Hudyu nog, “Ondiꞌ taꞌ motud og poktoluꞌon nami koni nog ika og gotow Samaria bu sinongonan ka nog glatdiwata?” ");
INSERT INTO suc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tinumabal si Isus nog, “Daꞌ u songonoy nog glatdiwata. Sugaꞌid non, pigodaban ku og Gamaꞌ u, saka tinompolaꞌ niu akon. ");
INSERT INTO suc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ondaꞌ u pogapas nog dili dongog u. Tibua, ongon og mogapas dun bu ion mongukum bianan sog motud. ");
INSERT INTO suc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Toluꞌon ku dianiu, simasima og mokokunut dia sog pomali u, ondiꞌ na dodaꞌ matoy.” ");
INSERT INTO suc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Miktaluꞌ og Hudyuanan koyon dianon nog, “Na! Bila maꞌ nion, kisunan nami na nog tinosopan ka dodaꞌ nog glatdiwata. Si Abraham minatoy. Bu og polomolatasanan kituꞌ nog taluꞌ nog Mikpongon, mikpomatoy ilan dosop. Saka, moktaluꞌ a nog bila ngon og mokokunut dia sog taluꞌ mu, ondiꞌ na dodaꞌ ion matoy? ");
INSERT INTO suc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Labi a potaꞌ kotas sog mokogulanganan ta kituꞌ nog si Abraham bu og polomolatas kituꞌ nog taluꞌ nog Mikpongon kobon nituꞌ nog mikpomatoy na? Poꞌ baluꞌ mu dun, sima a buan!” ");
INSERT INTO suc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tinabal ilan ni Isus nog, “Bila potason ku og dili glawas u, og bontugan ku daꞌ sagnat non. Og mokpotas dianakon og Gamaꞌ u. Ion non ion og pogolongon niu nog Diwata niu. ");
INSERT INTO suc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Daꞌ niu ion sibon kilolaoy. Tibua akon, kilolaan ku ion. Bila toluꞌon ku nog diꞌ u ion kilolaan, moloput u buan mamaꞌ niu. Tibua, kilolaan ku ion bu mikokunut u dia sog pomali non. ");
INSERT INTO suc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Og mogulang niu kituꞌ nog si Abraham linoliag tokodoy mogdodama nog gondow nog matong u. Bu og gondow koyon mitongow non na bu migdaꞌdaꞌ ion tokodoy dun.” ");
INSERT INTO suc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Og Hudyuanan kituꞌ miktaluꞌ dianon nog, “Aba! Daꞌ pa tanan kodopot lima puluꞌ og tinonan mu saka moktaluꞌ a nog mitongow nika si Abraham?” ");
INSERT INTO suc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Dadi, tinabal ilan ni Isus nog, “Toluꞌon ku dianiu, sog daꞌ pa si Abraham botaꞌoy, Akon, ion non u na ini!” ");
INSERT INTO suc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Dadi, mikpongimud ilan nog batu poꞌ botuon nilan bosia ion. Tibua, miksolingod na si Isus mangka awaꞌ sog glomalomaan nog Baloy koyon nog Poktomuyan dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Solian nilan ompanow, si Isus bu og sulangguꞌanan non, mitongow nilan og gotow nog buta tidu pa sog kobataꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Dadi, miksak dianon og sulangguꞌanan non koyon nog, “Rabi, iduma ion gidoy mibuta ma og gotow koyon nog dangan pa binataꞌ? Sabap taꞌ gidoy sog dusa nog mokogulang non, otawaka sabap taꞌ sog dusa non?” ");
INSERT INTO suc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tinabal ilan ni Isus nog, “Konaꞌ sabap sog dusa non otawaka sog dusa nog mokogulang non. Saꞌan ion mibuta poꞌ bagun da bianan dianon motongow og dasig nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Solian nog gondow pa, sumboy inangon ta og ginang nog mikpopangoy kituꞌ dianakon dini. Poꞌ bila moglogobi na, daꞌidun na og mokopoginang. ");
INSERT INTO suc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sog solian nog dini pa sog dunya, akon og dolag nog dunya nog mokpodolag nog pomikilan nog gotow.” ");
INSERT INTO suc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Dangan miluksad og taluꞌ ni Isus koyon, dinumulaꞌ ion sog glupaꞌ mangka non loklasoy og glupaꞌ kituꞌ nog dinulaꞌan non dia sog mata nog buta koyon ");
INSERT INTO suc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","mangka non toluꞌoy og buta koyon nog, “Angoy a pongulaꞌup dituꞌ sog glibosung nog Siloam.” (Og maꞌana nog Siloam koni, Pipangoy.) Dadi, minangoy og buta koyon dituꞌ mangka pongulaꞌup. Dangan mikpuliꞌ ion, mikotongow na. ");
INSERT INTO suc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Og sumbaloyanan non bu ain og mikotongow dianon monontoliꞌ, mikpoktaluꞌ ilan nog, “Konaꞌ non taꞌ gidoy ion og gotow kituꞌ nog mogingkud bu poktayak mongoni nog sin?” ");
INSERT INTO suc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Og duma mikpoktaluꞌ nog ion non og buta kituꞌ. Og duma sop moktaluꞌ nog, “E! konaꞌ non, le. Og ganggid non tibua.” Dadi, miktaluꞌ og bakas buta kituꞌ nog, “Akon le, og buta kituꞌ!” ");
INSERT INTO suc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dadi, sinakan nilan ion nog, “Olo ma og migandun dun nog mokotongow a na ma?” ");
INSERT INTO suc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tinumabal ion nog, “Og gotow nog og ngalan non si Isus, ion dinumulaꞌ sog glupaꞌ mangka non loklasoy sog mata u og glupaꞌ kituꞌ nog dinulaꞌan non mangka ion poktaluꞌ nog, ‘Angoy a pongulaꞌup dituꞌ sog Siloam.’ Dadi, minangoy u mongulaꞌup dituꞌ. Dangan mitubus u mongulaꞌup, mokotongow u na.” ");
INSERT INTO suc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Dadi, miksak ilan nosop nog, “Ain noma ion dun?” Tinumabal ion nog, “Daꞌ a sunoy. Ondiꞌ u kosunan.” ");
INSERT INTO suc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dadi, inoit nilan dituꞌ sog parasiuanan og gotow kituꞌ nog bakas buta. ");
INSERT INTO suc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Og gondow kituꞌ nog koloklas ni Isus nog basak dia sog mata nog gotow kituꞌ mibonaꞌ sog Gondow nog Pogulali. ");
INSERT INTO suc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Dadi, sinakan ion nog parasiuanan koyon bog olo og migandun nog kopokotongow non. Tinabal non ilan nog, “Linoklasan non nog basak og mata u mangka u pongulaꞌup. Dadi, mokotongow u na numun kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mikpoktaluꞌ og duma parasiuanan nog, “Og gotow kituꞌ nog mikokuliꞌ dianon konaꞌ gonat sog Mikpongon poꞌ daꞌ non pogbotadoy og Gondow nog Pogulali.” Tibua, og duma mikpoktaluꞌ nog, “Ngon taꞌ og bolodusaon nog mokopoginang nog gingyataꞌanan mamaꞌ nog gininang non koyon?” Dadi, ondaꞌ ilan poksolabuk nog pomikilan. ");
INSERT INTO suc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sinakan nilan nosop ion mokpuliꞌ nog, “Bila ika buan, sima gidoy og gotow koyon nog long mu dun nog ion og mikokuliꞌ dianika?” Tinabal non ilan nog, “Ion og polomolatas nog taluꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Og kounutananan nog bansa Hudyu kituꞌ ondaꞌ tud nog og gotow kituꞌ, ion tantu nog bakas buta kituꞌ. Dadi, sinabi nilan og mokogulang non mangka nilan sakoy nog, ");
INSERT INTO suc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Og bataꞌ niu taꞌ ini? Bila og bataꞌ niu, motud taꞌ nog donsamaꞌ na og buta tidu pa sog kobataꞌ dianon? Bila motud, olo ma og migandun nog kopokotongow non?” ");
INSERT INTO suc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tinumabal og mokogulang non koyon nog, “Kisunan nami nog ion non ini og bataꞌ nami kituꞌ bu donsamaꞌ na ion og buta. ");
INSERT INTO suc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tibua, diꞌ nami kosunan bog olo og migandun nog iduma mokotongow noma ion otawaka bog sima og mikokuliꞌ dianon. Sugaꞌid non, sakoy niu ion poꞌ mosolag na ion bu moto da ion tumabal.” ");
INSERT INTO suc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Saꞌan maꞌ nituꞌ og tabal nilan dun poꞌ mondok ilan sog kounutananan kituꞌ nog Hudyu. Poꞌ og kounutananan kituꞌ, mikpodonsamaꞌ na moktaluꞌ nog minsan sima og moktaluꞌ nog si Isus, ion og Kristu, og gotow koyon ondiꞌ na kumboyon sumolod sog baloy nog poglumpukan nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Saꞌan tinumabal og mokogulang non koyon nog, “Sakoy niu ion poꞌ moto da ion tumabal.” ");
INSERT INTO suc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Dadi, sinabi nilan puliꞌ og bakas buta kituꞌ mangka nilan toluꞌoy dianon nog, “Sapa a sog sunguꞌan nog Mikpongon bu posun mu ain og motud. Kisunan nami nog og gotow kituꞌ, ion og bolodusaon.” ");
INSERT INTO suc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tinumabal og gotow koyon nog, “Ondiꞌ u kosunan bog bolodusaon taꞌ ion otawaka konaꞌ taꞌ. Sokot da og kosunan ku nog akon, dini kituꞌ og buta u, tibua, numun koni mokotongow u na.” ");
INSERT INTO suc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Sinakan nilan ion mokpuliꞌ nog, “Olo og ginandun non dianika? Olo ginandun non kobulung non nog mata mu?” ");
INSERT INTO suc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tinabal non ilan nog, “Tinaluꞌ u na dianiu. Tibua, daꞌ amu pokinongog dun. Iduma moleg amu ma nosop mokinongog dun mokpuliꞌ? Amu siꞌoy, moleg amu taꞌ moksulangguꞌ dianon?” ");
INSERT INTO suc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Piglolingitan nilan ion dun bu sinolap nilan ion monaluꞌ. Long nilan dun, “Ika, og sulangguꞌ a nog gotow kituꞌ. Tibua ami, sulangguꞌ ami ni Apuꞌ Muses! ");
INSERT INTO suc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kisunan nami nog og Mikpongon, ion miktaluꞌ dia ni Apuꞌ Muses. Tibua, og gotow koyon nog pogolongon mu nog mikokuliꞌ dianika, minsan siꞌoy og piktiduan non, ondiꞌ nami tanan kosunan.” ");
INSERT INTO suc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Dadi, og gotow kituꞌ nog kiuliꞌan miktaluꞌ nog, “Mosobuꞌ u tokodoy dun nog iduma ondiꞌ niu motanan kosunan og piktiduan non nog saka ion og mikobukaꞌ nog tinontongan ku. ");
INSERT INTO suc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kisunan ta nog og Mikpongon ondiꞌ monombaꞌ sog gotow nog bolodusaon. Sugaꞌid non, tumabang ion sog gotow nog mogadab dianon bu moginang nog glegan non. ");
INSERT INTO suc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tidu pa sog kopokpongon nog dunya asta sog numun koni, daꞌidun pa og midongog ta nog gotow nog mikokuliꞌ nog buta nog tidu pa sog kobataꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dadi, somoꞌ og gotow kituꞌ nog ondaꞌ gonat sog Mikpongon, ondiꞌ ion bosia mokopoginang dun.” ");
INSERT INTO suc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tinabal nilan ion nog, “Pokponadan nika taꞌ ion ami? Ika, og bolodusaon ka tidu pa sog kobataꞌ dianika.” Dadi, binugow nilan ion sog baloy nog poglumpukan nilan koyon bu tidu dituꞌ, daꞌ nilan na ion kumboyoy mampuꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Dangan midongog ni Isus nog og bakas buta kituꞌ binugow nilan na sog baloy nog poglumpukan nilan, pingumbalak non ion. Dangan mitongow ion ni Isus, sinakan non ion nog, “Tumud a taꞌ dia sog Binataꞌ sog Kilawan?” ");
INSERT INTO suc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tinumabal ion nog, “Sima ion, Sir? Posun mu pa dianakon bagun u tumud dianon.” ");
INSERT INTO suc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tinabal ion ni Isus nog, “Mitongow mu na ion. Og duma mu buan koni mogabitabit, ion non ini.” ");
INSERT INTO suc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dadi, miktaluꞌ og gotow koyon nog, “Kounutan ku, tumud u,” mangka non ion tomuyoy. ");
INSERT INTO suc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Miktaluꞌ si Isus nog, “Saꞌan minangoy u dini sog dunya poꞌ bagun ombahagiꞌ og gotowanan. Ain og buta mimung nog mokotongow bu ain og mokotongow, mimung ilan nog buta.” ");
INSERT INTO suc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Og duma parasiuanan koyon dion nog midongog nilan og taluꞌ ni Isus koyon, miksak ilan nog, “Poꞌ iduma, buta ami taꞌ buan?” ");
INSERT INTO suc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Dadi, tinumabal si Isus nog, “Somoꞌ mibuta amu, ondiꞌ amu bosia komotudan. Tibua, miktaluꞌ amu ma nog mokotongow amu, saꞌan ion kimotudan amu poꞌ daꞌ amu tud sog taluꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Dadi, miktaluꞌ nosop si Isus nog pononggiꞌan. Long non dun, “Toluꞌon ku dianiu, ain og gotow nog sumolod dia sog kudal nog bilibilianan nog diꞌ mian dia sog bongawan nog sumolap momian, og gotow koyon og polonakow otawaka og polonglampas. ");
INSERT INTO suc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tibua, bila og gotow dia bian sog bongawan, og gotow koyon og polongipat dodaꞌ nog bilibilianan non. ");
INSERT INTO suc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Bu bila sumolod ion, bukaꞌan mogdayun ion nog pogipat koyon nog bongawan mangka non posolodoy. Bu og bilibilianan koyon mokinongog dianon. Sobion non og ngalananan nog bilibilianan non mangka non ilan oitoy sog glowasan. ");
INSERT INTO suc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Bila poluason non na og bilibilianan non koyon, moguna ion dianilan bu mogunut ilan dianon poꞌ kilolaan nilan og gonek non. ");
INSERT INTO suc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tibua, ondiꞌ ilan mogunut sog len gotow. Mokponggobok ilan tanan poꞌ ondiꞌ nilan kilolaan og gonek non.” ");
INSERT INTO suc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Og pononggiꞌan koyon nog inuksugan ni Isus dianilan, ondaꞌ nilan kosabut bog olo og maꞌana non. ");
INSERT INTO suc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Dadi, miktaluꞌ nosop si Isus nog, “Toluꞌon ku dianiu, nog akon og bongawan kituꞌ nog bianan nog bilibilianan. ");
INSERT INTO suc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ain og gotowanan kituꞌ nog mikuna dianakon, polonakow bu polonglampasanan ilan. Tibua, og bilibilianan koyon ondaꞌ pokinongog dianilan. ");
INSERT INTO suc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Akon og bongawan. Ain og gotow sumolod nog mian dianakon, motabang ilan. Mokopogliusolod ilan bu motongow nilan og pongoksaban nilan. ");
INSERT INTO suc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Og polonakow mangoy tibua monakow, mongulaꞌat, bu momunuꞌ. Tibua akon, saꞌan minangoy u dini poꞌ bagun ilan da kongonan nog kotubuꞌ kituꞌ nog ondiꞌ kolobian og kobaꞌis non. ");
INSERT INTO suc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Akon da og molongas nog polongipat nog bilibilianan. Og molongas nog polongipat nog bilibili otason non matoy sog kopogipat non nog bilibilianan non. ");
INSERT INTO suc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Og gotow kituꞌ nog sagya da tinindanan mogipat nog bilibilianan, konaꞌ non og gapuꞌ nilan. Dadi, bila ngon og mokotuaꞌ nog glimong, gonatan non og bilibilianan koyon mangka gobok nog boyaꞌan mokpokpolaꞌ og bilibilianan koyon gumobok poꞌ ponglosigon ilan nog glimong. ");
INSERT INTO suc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Saꞌan ginumobok og gotow koyon poꞌ sagya da tinindanan. Dadi, daꞌidun og balan non nog bilibilianan kituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Akon da og molongas nog polongipat nog bilibilianan kituꞌ poꞌ kilolaan ku og bilibilianan ku bu ilan siꞌoy kilolaan nilan dosop akon. ");
INSERT INTO suc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Domikian dosop maꞌ nog Gamaꞌ u bu akon, nog kilolaan non akon bu kilolaan ku dosop ion. Bu otason ku matoy sabap dianilan. ");
INSERT INTO suc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ongon pa og duma bilibilianan ku nog daꞌ dini sog dialom nog kudal koni. Sumboy dosop koponuluꞌan ku ilan poꞌ ilan siꞌoy, mokinongog ilan dosop nog taluꞌ u boyaꞌan mimung nog solabuk og glam nog bilibilianan ku bu solabuk da og polongipat nilan. ");
INSERT INTO suc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Saꞌan molalam og Gamaꞌ u dianakon poꞌ mongatas u matoy bagun u motubuꞌ mokpuliꞌ. ");
INSERT INTO suc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Daꞌidun og mokopogbayaꞌ munuꞌ dianakon. Sugaꞌid non, uokilon ku og glawas u nog bunuꞌon poꞌ maꞌ nituꞌ og bayaꞌ nog binogoy nog Gamaꞌ u dianakon nog matoy u bu motubuꞌ u da mokpuliꞌ. Ion non ini og dondagan nog Gamaꞌ u dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sabap sog tinaluꞌ ni Isus koyon, mimung nog mibahagiꞌ nosop og pomikilan nog gotowanan dun. ");
INSERT INTO suc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Modakol ilan og miktaluꞌ nog, “Og gotow koyon tinosopan nog glatdiwata bu migbunog. Iduma monginongog ita ma dianon?” ");
INSERT INTO suc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tibua, og duma mikpoktaluꞌ ilan nog, “Somoꞌ tinosopan ion nog glatdiwata, ondiꞌ mamaꞌ nini og pomali non. Ongon taꞌ buan og glatdiwata nog kuliꞌan non og gotow nog donsamaꞌ na buta?” ");
INSERT INTO suc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tubus nituꞌ, dangan minatong og kologyaꞌan nilan koyon nog ngalan non og Guakil sog Mikpongon nog Baloy nog Poktomuyan dianon, dituꞌ sog Jerusalem, mibonaꞌ sog timpu motigdow. ");
INSERT INTO suc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Bu migdundaan si Isus sog glomalomaan nog Baloy koyon nog Poktomuyan, dia dapit sog iningolanan og Pogbianan ni Solomon. ");
INSERT INTO suc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Dadi, piglumpukan ion nog Hudyuanan mangka ilan poksak dianon nog, “Nanu mu potintuoy dianami bog sima a dodaꞌ? Bila ika og Kristu, pologdong mu dianami.” ");
INSERT INTO suc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tinabal ilan ni Isus nog, “Mitubus u na toluꞌoy dianiu, tibua, ondiꞌ amu tumud dianakon. Og piginang u kituꞌ nog gingyataꞌanan bianan sog ngalan nog Gamaꞌ u, mikotaksiꞌ paꞌali dianakon. ");
INSERT INTO suc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tibua, ondiꞌ amu tumud dun poꞌ konaꞌ u amu bilibilianan. ");
INSERT INTO suc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Og bilibilianan ku, monginongog ilan nog taluꞌ u. Kilolaan ku ilan bu mokokunut ilan dianakon. ");
INSERT INTO suc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Bogayan ku ilan nog kotubuꞌ nog daꞌidun kopus non bu diꞌ ilan na moglaꞌat. Bu daꞌidun og mokagow dianilan dia sog gongkoman ku. ");
INSERT INTO suc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Og Gamaꞌ u, ion motas sog glam non bu binogoy non ilan dianakon. Daꞌidun og mokagow dianilan tidu dia sog gongkoman non. ");
INSERT INTO suc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Akon bu Gamaꞌ u solabuk ami da.” ");
INSERT INTO suc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dadi, og Hudyuanan mikpongimud ilan nosop nog batu poꞌ botuon nilan bosia ion. ");
INSERT INTO suc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tibua, miktaluꞌ si Isus dianilan nog, “Pitongow u dianiu og molongas nog kohinangan nog dinondag dianakon nog Gamaꞌ u. Ain sog kohinangan ku kituꞌ nog molongas niu akon botuon dun?” ");
INSERT INTO suc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tinumabal og Hudyuanan kituꞌ nog, “Konaꞌ sabap sog kolongas nog kohinangan mu koyon nog boyaꞌan botuon nami ika dun, tibua, sabap nog piglokaꞌlokaꞌan mu monaluꞌ og Mikpongon poꞌ pibatuk mu og glawas mu dianon saka sagyaotow a da.” ");
INSERT INTO suc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Dadi, tinabal ilan ni Isus nog, “Ondaꞌ taꞌ sulatoy dia sog Botad kituꞌ nog taluꞌ nog Mikpongon dun nog, ‘Amu og kodiwotaan?’ ");
INSERT INTO suc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kisunan ta nog ain og misulat sog Botad kituꞌ ondiꞌ mosop. Bila tinoluꞌan ilan ma nog kodiwotaan og binogayan kituꞌ nog Botad, ");
INSERT INTO suc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","olo gidoy og kotaluꞌ niu dun dia sog piniliꞌ kituꞌ nog Gamaꞌ nog pipangoy non dini sog dunya? Iduma toluꞌan niu ma akon nog piglokaꞌlokaꞌan ku monaluꞌ og Mikpongon sabap nog tinaluꞌ u nog akon og Bataꞌ non? ");
INSERT INTO suc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Diꞌ amu pia tumud dianakon somoꞌ konaꞌ u piginang og ginang nog Gamaꞌ u. ");
INSERT INTO suc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tibua, bila ininang u da og ginang non kituꞌ, minsan siꞌoy ondiꞌ amu tumud dianakon, tud niu og kohinangan ku kituꞌ nog tumaksiꞌ dianakon bagun niu da sunan bu mosabut nog akon, dia u sog Gamaꞌ bu og Gamaꞌ dia dosop nakon.” ");
INSERT INTO suc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dadi, ukpaꞌan nilan nosop bosia ion. Tibua, ondaꞌ ion pokpukpaꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Dadi, minangoy ion puliꞌ dituꞌ sog dipag nog tubig nog Jurdan sog bakas pimunyagan kituꞌ ni Jan mangka ion pogonongonong dituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bu modakol og gotowanan og mikpogangoy dituꞌ non. Mikpoktaluꞌ ilan nog minsan si Jan, daꞌ poginang nog gingyataꞌanan. Tibua, og glam nog tinaluꞌ non paꞌali dia sog gotow koni motud. ");
INSERT INTO suc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Dadi, modakol nog gotowanan og tinumud dia ni Isus dion sog bonua koyon. ");
INSERT INTO suc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ongon og gotow nog ondiꞌ mokodag ngalan non si Lasarus, tidu sog koliwagan bonua nog Betani, og pigonongan ni Maria ilan nog putupusod non nog si Marta. ");
INSERT INTO suc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Si Maria, ion non og minudud kituꞌ nog pogomut dia sog botis ni Isus mangka non punasoy nog buk non. Og gilug nilan si Lasarus, ondiꞌ mokodag. ");
INSERT INTO suc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Dadi, pisobutan nog kolibunanan koyon si Isus nog, “Kounutan, og kololaman mu kituꞌ ondiꞌ mokodag.” ");
INSERT INTO suc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Dangan midongog ni Isus, miktaluꞌ ion nog, “Og mosakit ni Lasarus kituꞌ ondiꞌ mogdoksuꞌan sog patoy. Sugaꞌid non, sabap dion ompotas og Mikpongon dun bu akon siꞌoy nog Bataꞌ non, ompotas u dosop dun.” ");
INSERT INTO suc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Molalam si Isus nog pomogilug koyon. ");
INSERT INTO suc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tibua, minsan midongog non na nog ondiꞌ mokodag si Lasarus, migonong pa ion dion asta milibuas duaꞌ ondow. ");
INSERT INTO suc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tubus nituꞌ, miktaluꞌ si Isus dia sog sulangguꞌanan non nog, “Alung, mokpuliꞌ ita sog Judia.” ");
INSERT INTO suc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tibua, miktaluꞌ og sulangguꞌanan non dianon nog, “Rabi, bogu a dotanan poksipioy matu nog gotow Hudyuanan dituꞌ saka mokpuliꞌ a nosop dituꞌ?” ");
INSERT INTO suc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tinumabal si Isus nog, “Konaꞌ taꞌ nog sopuluꞌ bu duaꞌ oras og gondow? Og gotow, bila ompanow nog gondow pa, ondiꞌ ion mokosoksug poꞌ motongow non og bianan non kobal nog dolag nog dunya koni. ");
INSERT INTO suc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tibua, bila ompanow ion nog gobi, mokosoksug ion poꞌ mipalong na og tiow non.” ");
INSERT INTO suc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bu tubus nituꞌ, miktaluꞌ nosop si Isus nog, “Og glokole ta nog si Lasarus mikotulug. Saꞌan mangoy u dituꞌ poꞌ ongoyon ku ion tonudoy.” ");
INSERT INTO suc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tinumabal og sulangguꞌanan non nog, “Kounutan, bila sagya da mikotulug ion, molongas tanan bagun ion kuliꞌan.” ");
INSERT INTO suc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Og maꞌana nog tinaluꞌ ni Isus kituꞌ, si Lasarus minatoy. Tibua, baluꞌ nog sulangguꞌanan non koyon dun sagya da mikotulug. ");
INSERT INTO suc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Dadi, pilogdong ni Isus dianilan nog, “Si Lasarus minatoy. ");
INSERT INTO suc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Migdaꞌdaꞌ u nog daꞌ u dituꞌ sog tang nog kopatoy non poꞌ koboꞌisan amu dun. Poꞌ ongon og kolegan ku mokpotongow dianiu bagun dumungag og kopongandol niu dianakon. Dadi, alung, mangoy ita dituꞌ non.” ");
INSERT INTO suc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tubus nituꞌ, si Tomas, nog koduaꞌ ngalan non Gapid, miktaluꞌ dia sog pakasi sulangguꞌanan non nog, “Alung, mogunut ita dianon poꞌ unungan ta ion.” ");
INSERT INTO suc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Dangan minatong ilan dituꞌ sog Betani, midongog non nog pat ondow na tidu lobongon si Lasarus. ");
INSERT INTO suc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Og bonua nog Betani koni, ongon tolu kilumitru og glayuꞌ non tidu sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Dadi, modakol gotow Hudyu nog miktidu sog Jerusalem minangoy mongamuꞌ dia ni loꞌ Marta ilan ni Maria. ");
INSERT INTO suc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Dangan midongog ni Marta nog si Isus posunguꞌ matong, linumpak non ilan. Tibua, si Maria mibagak sog baloy nilan. ");
INSERT INTO suc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Dangan miglumpak ilan, miktaluꞌ si Marta dia ni Isus nog, “Kounutan, somoꞌ dini a da, ondiꞌ bosia matoy og gilug u kituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tibua, kosunan ku da nog minsan numun kituꞌ bogoyon nog Mikpongon dianika minsan olo og pongonion mu dianon.” ");
INSERT INTO suc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Miktaluꞌ si Isus dianon nog, “Og gilug niu kituꞌ motubuꞌ da mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tinumabal si Marta nog, “Kosunan ku nog motubuꞌ da ion mokpuliꞌ bila potubuꞌon na mokpuliꞌ sog gimpusan nog gondow og glam nog mikpomatoy kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dadi, miktaluꞌ si Isus dianon nog, “Akon og mokpotubuꞌ puliꞌ nog minatoy. Akon og poktiduan nog kotubuꞌ. Og gotow nog tumud dianakon, minsan siꞌoy matoy ion, motubuꞌ da ion mokpuliꞌ. ");
INSERT INTO suc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Bu og gotow nog totubuꞌ nog tumud dianakon, ondiꞌ ion mokangoy sog kopatoy nog daꞌ kopus non. Tumud a taꞌ dun og taluꞌ u koni dianika?” ");
INSERT INTO suc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tinumabal si Marta nog, “Oꞌo, Kounutan, tumud u nog ika og Kristu, og Bataꞌ nog Mikpongon nog pigdodomaan nami matong dini sog dunya.” ");
INSERT INTO suc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Dangan midoksuꞌ toluꞌoy ni Marta, inangoy non og gilug non nog si Maria mangka non ilomoy nog, “Og Polopanad minatong na bu sinabi non ika.” ");
INSERT INTO suc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ampun midongog ni Maria ini, migbuat ion mogdayun mangka angoy dituꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Bu si Isus daꞌ pa solod sog gimbolayan koyon. Dituꞌ pa ion sog linumpakan kituꞌ ni Marta dianon. ");
INSERT INTO suc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Og Hudyuanan koyon nog mingamuꞌ dia ni Maria, dangan mitongow nilan nog migdaliꞌdaliꞌ ion mogbuat mangka panow, inunutan nilan ion poꞌ baluꞌ nilan dun, mangoy ion moksogow dituꞌ sog globong nog gilug non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Dangan minatong si Maria dituꞌ bu mitongow non si Isus, miningluꞌud ion sog sunguꞌan non mangka poktaluꞌ nog, “Kounutan, somoꞌ dini a da, ondiꞌ bosia matoy og gilug u kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Dangan mitongow ni Isus si Maria dunut og Hudyuanan kituꞌ nog mikpoksogow, pingingloyuꞌan ion dun. ");
INSERT INTO suc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dadi, miksak ion nog, “Ain niu ion linobong?” Tinabal nilan ion, “Kounutan, ongoyon ta tontongoy.” ");
INSERT INTO suc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Miksogow si Isus. ");
INSERT INTO suc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Dadi, long nog Hudyuanan dun, “Landuꞌ og glolaman non dia ni Lasarus.” ");
INSERT INTO suc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tibua, ongon og duma gotow nog mikpoktaluꞌ ilan nog, “Bila kiuliꞌan non ma og buta kituꞌ, ombulung non dosop bosia si Lasarus bagun diꞌ matoy!” ");
INSERT INTO suc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pogdatong nilan dion, pingingloyuꞌan nosop si Isus. Og globong kituꞌ og sangub nog dia sog pampang nog tinimpong nog mosolag nog batu. ");
INSERT INTO suc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Miktaluꞌ si Isus nog, “Awaꞌ niu og batu koyon.” Tibua, miktaluꞌ si Marta nog, “Kounutan, minoduꞌ na poꞌ pat ondow na ion tidu lobongon.” ");
INSERT INTO suc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Miktaluꞌ si Isus dianon nog, “Ondaꞌ u taꞌ toluꞌoy dianika nog bila tumud a, motongow nika og kotas nog bayaꞌ nog Mikpongon?” ");
INSERT INTO suc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Dadi, inawaꞌ nilan og batu kituꞌ nog poktimpong nog globong koyon. Tubus nituꞌ, tinumongal si Isus sog glangit mangka poktaluꞌ nog, “Solamat Amaꞌ, poꞌ inginongogan mu akon. ");
INSERT INTO suc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kosunan ku nog kobon non ponginongogan mu akon. Tibua, sabap sog gotowanan koni dini, saꞌan ini podongogon ku bagun ilan tumud nog ika dodaꞌ og mikpopangoy dianakon dini sog dunya.” ");
INSERT INTO suc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tubus nituꞌ, miktaluꞌ nog mosikad si Isus nog, “Lasarus, luas a dion!” ");
INSERT INTO suc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dadi, linumuas mogdayun si Lasarus nog miputus pa nog saput og glawas non, og komot non, bu og botis non. Og gulu non binogbod nog pangyuꞌ. Miktaluꞌ si Isus, “Ubadoy niu ion bagun mokopanow.” ");
INSERT INTO suc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Modakol nog Hudyuanan kituꞌ nog minangoy mongamuꞌ dia ni Maria, tinumud ilan dia ni Isus dangan mitongow nilan og gininang non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tibua, og dumaanan nilan kituꞌ, minangoy ilan dituꞌ sog parasiuanan mangka nilan toluꞌoy og gininang ni Isus kituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Og mokokotas nog boliananan, bu og parasiuanan, migupakat ilan nog Polongukumanan nog Bansa Hudyu bog olo og gondunon nilan dia ni Isus poꞌ long nilan dun, “Og gotow koyon, modakol og ginang non nog kosobuꞌsobuꞌ. ");
INSERT INTO suc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bila potiangon ta ion, og glam nog gotow tumud dianon. Bu bila maꞌ nituꞌ, ongoyon ita nog sundaluanan nog pigdotuꞌan nog Roma, mangka nilan pogloꞌatoy og Baloy nog Poktomuyan ta bu asta og bansa ta.” ");
INSERT INTO suc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dadi, sala kotow dianilan, si Kaypas og kounutan nog boliananan sog ton koyon, miktaluꞌ ion nog, “Og sobuꞌ amu dodaꞌ tokodoy! ");
INSERT INTO suc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Daꞌ niu taꞌ kopikil nog golom pa og sala kotow tibua og matoy dia sog glam nog gotow gabaꞌ nog moglaꞌat og tibuk nog bansa ta?” ");
INSERT INTO suc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Daꞌ non ini toluꞌoy nog dili kotoan non. Tibua, sabap nog ion og kounutan nog boliananan sog ton koyon, saꞌan mitaluꞌ non. Poꞌ pipikil dianon nog Mikpongon nog podonsomaꞌon non tumaluꞌ nog sumboy si Isus sumoliu matoy sog tibuk nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Bu konaꞌ tibua sog bansa Hudyu, sugaꞌid non, sabap sog kopatoy non, og glam nog pigotowan nog Mikpongon limudon non tidu sog ainain nog bonua poꞌ poksolobukon non ilan. ");
INSERT INTO suc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tidu dituꞌ, og kounutananan nog bansa Hudyu, minontong ilan nog pondayan bagun nilan ombunuꞌ si Isus. ");
INSERT INTO suc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dadi, daꞌ na ion pokpotampal mogdundaan dia sog bonua nog Judia koyon. Sugaꞌid non, minangoy ion dituꞌ sog bonua nog ngalan non og Ipraim sog molani nog bonua koyon nog daꞌidun og gotow dun. Bu dituꞌ ilan migonongonong nog sulangguꞌanan non. ");
INSERT INTO suc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Dangan daliꞌ na datong og tang nog kologyaꞌan nog bansa Hudyu nog ngalan non og Liniusan, modakol og gotowanan nog mikpogangoy sog Jerusalem nog diadia mikpoktidu nog bonuaanan bagun nilan minang og pogbotadon nilan kituꞌ nog mongugas mangka siꞌoy datong og kologyaꞌan nilan kituꞌ nog Liniusan. ");
INSERT INTO suc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dadi, pikponontong nilan si Isus. Bu solian nilan koyon mogindog dia sog glomalomaan nog Baloy koyon nog Poktomuyan dia sog Mikpongon, miksinaksakoy ilan nog, “Mangoy taꞌ gidoy ituꞌ ion tumuaꞌ nog kologyaꞌan koni?” ");
INSERT INTO suc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tibua, og mokokotas nog boliananan koyon bu og parasiuanan koyon, tinaluꞌ nilan na nog bila ongon og mokotongow dia ni Isus, posunon nilan moglandan. Saꞌan ituꞌ poꞌ bagun nilan ion kukpaꞌan. ");
INSERT INTO suc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Gonom gobi dona mangka datong og kologyaꞌan nilan koyon nog iningolanan nog Liniusan, minangoy si Isus sog Betani, sog bonua ni Lasarus, og gotow kituꞌ nog pitubuꞌ non puliꞌ. ");
INSERT INTO suc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bu miksimpan ilan nog ponganon nog kidotongoy ni Isus dion nilan. Si Marta og miktolagad, bu si Lasarus koni minampuꞌ kuman dianilan. ");
INSERT INTO suc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Koni sop ni Maria, minalap ion nog landuꞌ kologan nog pogomut ngalan non og nard mangka non ududoy sog botis ni Isus bu punasoy nog buk non. Dadi, sinumongyub notibua og gomut nog pogomut koyon sog gliwag nog baloy koyon. ");
INSERT INTO suc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tibua, og sala kotow sulangguꞌ ni Isus koyon nog si Judas Iskariot, og mongulaꞌat kituꞌ dia ni Isus, miktaluꞌ ion nog, ");
INSERT INTO suc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mologan tokodoy og pogomut koyon. Iduma ondaꞌ ma poksaluy og glana momut koyon nog tolu gatus dinari mangka bogoyoy sog miskinananan?” ");
INSERT INTO suc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tinaluꞌ non ini, konaꞌ poꞌ milolat ion sog miskinananan, sugaꞌid non, og polonakow ion. Poꞌ ion og toliipat nog sin nilan bu sumolingka malap ion dun. ");
INSERT INTO suc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dadi, miktaluꞌ si Isus nog, “Potiang niu si Maria. Poꞌ saꞌan ion sinimpan non og pogomut koyon poꞌ bila matoy u, ududon non dianakon bila lobongon u na. ");
INSERT INTO suc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Og miskinan kobon non mokunul amu da nilan. Tibua akon, diꞌ ita niu kobon non mokunul.” ");
INSERT INTO suc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Modakol nog gotowanan og mikodongog nog si Isus dituꞌ sog Betani. Dadi, mikpogangoy ilan dituꞌ. Bu saꞌan mikpogangoy ilan dituꞌ konaꞌ tibua poꞌ moleg ilan tumontong dia ni Isus, sugaꞌid non, bagun nilan dosop motongow si Lasarus nog pitubuꞌ non kituꞌ puliꞌ. ");
INSERT INTO suc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Dadi, mipikil nog mokokotas nog boliananan koyon nog si Lasarus siꞌoy bunuꞌon nilan dosop. ");
INSERT INTO suc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Poꞌ sabap dianon modakol og gotow Hudyuanan nog tinumud dia ni Isus bu ondiꞌ ilan na mokokunut dia sog kounutananan nilan. ");
INSERT INTO suc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Migbolomaꞌ ion, modakol og gotowanan nog minangoy tumuaꞌ sog kologyaꞌan koyon sog Jerusalem, midongog nilan nog si Isus posunguꞌ dosop matong dituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Dadi, mikpongalap ilan nog dawon mamaꞌ nog dawon nog bunga mangka nilan lumpakoy si Isus dia sog dalan. Mikpogekes ilan nog, “Songlitan og Mikpongon! Pipia ion nog minangoy dini bianan sog ngalan nog Mikpongon! Pipia ion og Datuꞌ sog bansa Israel!” ");
INSERT INTO suc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Si Isus mikotongow nog nati nog asnu nog sokayan non. Poꞌ maꞌ nini og sinulat dia sog Kitab, ");
INSERT INTO suc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Amu gotowanan sog Sion, naꞌ amu mondok poꞌ tontong niu, og datuꞌ niu posunguꞌ na matong nog poksakoy dia sog nati nog asnu.” ");
INSERT INTO suc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tiganaꞌ, ondaꞌ pa kosabut nog sulangguꞌanan non koyon og bianbian ni Isus koyon. Tibua, dangan piotas na si Isus sog glangit, mipondom nilan nog sinulat kituꞌ sog Kitab paꞌali dianon, ion non na og ininang nilan kituꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Og gotowanan kituꞌ nog mikotongow dia ni Isus, sog kopotubuꞌ non bu kosabi non dia ni Lasarus tidu sog globong, pikpulonag nilan og dongogan nog ginang non koyon. ");
INSERT INTO suc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Saꞌan modakol og gotowanan nog linumumpak dianon poꞌ sabap sog gininang non kituꞌ nog kosobuꞌsobuꞌ. ");
INSERT INTO suc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Dadi, mikpogabitabit og parasiuanan koyon nog ilanilan da nog, “Na! Tontong niu! Ondiꞌ ita mokantu dianon poꞌ mikpogunut na dianon og glam nog gotowanan sog tibuk nog dunya koni!” ");
INSERT INTO suc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ongon dosop og duma gotowanan nog bansa Girik nog tinumuaꞌ sog kologyaꞌan kituꞌ sog Jerusalem poꞌ tumamuy ilan dosop sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Minangoy ilan dituꞌ ni Pilip. Og Pilip koni og gotow Betsaida nog sakup nog Galili. Long nilan dun dia ni Pilip, “Le, bila mogusoy da, moleg ami bosia moktongow dia ni Isus.” ");
INSERT INTO suc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dadi, inangoy uksugoy ni Pilip dituꞌ ni Andriu, mangka nilan ongoyoy pogobitoy dituꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Dadi, miktaluꞌ si Isus nog, “Minatong na og tang nog og Binataꞌ sog Kilawan, potason nododaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Toluꞌon ku dianiu, ibalat da sog solongow boniꞌ, bila ondiꞌ lobuton, ondiꞌ nododaꞌ tumubuꞌ bu sumongkuꞌ. Tibua, bila lobuton da, sumongkuꞌ nododaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Domikian dosop og gotow nog bila bololagaꞌ dianon og kotubuꞌ nog dini da sog kilawan, og kotubuꞌ non koyon ombolong da. Tibua, og gotow nog diꞌ non inggulaꞌan og kotubuꞌ non dini sog kilawan, og kotubuꞌ non koyon asta sog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Simasima og moleg mimung nog sosoligan ku, sumboy mokokunut dianakon. Poꞌ minsan ain u angoy, dituꞌ dosop og sosoligan ku. Bu potason ion nog Gamaꞌ u, ain og gotow nog tumuman nog dondagan ku. ");
INSERT INTO suc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Numun kituꞌ kilogonan u mokpikilpikil bog olo og poktoluꞌon ku. Bu diꞌ u dosop moktaluꞌ nog, ‘Amaꞌ, tobangan mu akon sog sinsaan ku koni posunguꞌ.’ Poꞌ saꞌan minangoy u dini sog dunya bagun ku kobianan og sinsaan koyon. ");
INSERT INTO suc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Sugaꞌid non, toluꞌon ku nog, ‘Amaꞌ, potongow mu sog gotowanan og kotas nog bayaꞌ mu.’” Gomonsunoy pa, ongon og taluꞌ nog midongog nilan nog miktidu sog glangit. Long pa nog taluꞌ koyon dun, “Pitongow u na og kotas nog bayaꞌ u bu potongowon ku pa mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Og gotowanan koyon dion nog mikodongog dun, miktaluꞌ ilan nog, “Miglugung le og bonua.” Tibua, og duma miktaluꞌ ilan nog, “Miktaluꞌ dianon og moloikat nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dadi, miktaluꞌ si Isus dianilan nog, “Og gonek koyon nog midongog niu, konaꞌ nakon og pidongogan dun, sugaꞌid non, amu. ");
INSERT INTO suc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Numun koni minatong na og tang nog og Mikpongon mongukum sog glam nog gotow. Bu si Kindagow, og datuꞌ dini sog dunya, dagon na og bayaꞌ non. ");
INSERT INTO suc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tibua akon, bila tundokon u na tidu sog glupaꞌ, lumpukon ku og glam nog gotowanan dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tinaluꞌ ini ni Isus poꞌ bagun nilan mosabut bog olo og potayan non. ");
INSERT INTO suc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Miktaluꞌ og gotowanan nog, “Long pa nog sinulat dia sog botad ta, og Kristu, ondiꞌ ion matoy. Tibua, ika, moktaluꞌ a ma nog og Binataꞌ sog Kilawan, sumboy tundokon sog kudus. Sima buan og pogolongon mu koyon nog Binataꞌ sog Kilawan?” ");
INSERT INTO suc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tinumabal si Isus nog, “Og dolag kituꞌ nog sinumilow dianiu ondiꞌ na mobon. Dadi, panow amu solian nog dini pa niu og dolag koyon bagun amu da ondiꞌ mosaꞌut nog gobi. Og gotow nog ompanow nog modolom, ondiꞌ non sunan bog ain posunguꞌ. ");
INSERT INTO suc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dadi, tud amu sog dolag koyon solian dion pa niu bagun amu da mimung nog pigotowan non.” Mitubus non ituꞌ toluꞌoy, ginumonat ion bu daꞌ ion pokpotongow dianilan. ");
INSERT INTO suc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Minsan siꞌoy mitongow nilan og kodakol nog gingyataꞌanan nog gininang ni Isus, tinibabaꞌ nilan nododaꞌ nog daꞌ ilan tud dianon. ");
INSERT INTO suc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Poꞌ bianan dianilan, og pidonsamaꞌ tumaluꞌ nog polomolatas kituꞌ kobon nituꞌ nog taluꞌ nog Mikpongon nog si Isaya mituman na. Long non dun, “Pogbayaꞌ, daꞌidun og tumud dia sog gustalan nami. Bu daꞌ nilan kosabut ain og mikotongow nog bayaꞌ mu.” ");
INSERT INTO suc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Saꞌan ion mologon ilan tud, poꞌ mamaꞌ dosop nog sinulat ni Isaya kituꞌ nog, ");
INSERT INTO suc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tinimpong non og mataanan nilan, bu pitogas non og pomikilan nilan boyaꞌan nog ondiꞌ ilan mokosabut, bu boyaꞌan nog ondiꞌ ilan mokotongow. Bu diꞌ ilan mangoy dianakon saka kuliꞌan ku ilan, maꞌ long nog Mikpongon dun.” ");
INSERT INTO suc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tinaluꞌ ini ni Isaya poꞌ donsamaꞌ non na mitongow og silow nog kotas nog bayaꞌ ni Isus. Saꞌan da tinaluꞌ non paꞌali dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Minsan siꞌoy maꞌ nituꞌ, modakol og kounutananan nog gotow Hudyu koyon og tinumud dianon. Tibua, ondaꞌ nilan potompaloy poꞌ mondok ilan nog kosunan nog parasiuanan koyon, poꞌ gomonsunoy bugowon ilan na sog baloy nog poglumpukan nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Saꞌan maꞌ nituꞌ og pomikilan nilan poꞌ dadi nilan pa nog pogdongyaꞌan ilan nog gotowanan, gabaꞌ nog pogdongyaꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Dadi, miktaluꞌ si Isus nog mosikad. “Simasima og tumud dianakon, konaꞌ tibua nakon og tinud non. Sugaꞌid non, tinumud dosop ion dia sog Mikpongon nog mikpopangoy dianakon. ");
INSERT INTO suc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Simasima og mikotongow dianakon, mitongow non dosop og Mikpongon nog mikpopangoy dianakon. ");
INSERT INTO suc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Saꞌan minangoy u dini sog dunya poꞌ mimung u nog dolag nog mokpodolag nog pomikilan nog gotowanan bagun da ain og tumud dianakon, ondiꞌ ilan na mogonong dia sog kodoloman. ");
INSERT INTO suc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tibua, bila ongon gotow nog mikodongog nog pomali u saka ondiꞌ mokokunut dun, ondiꞌ u ion ukumon poꞌ ondaꞌ u angoy dini sog dunya mongukum, sugaꞌid non, inangoy u ilan gowonoy. ");
INSERT INTO suc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Og gotow nog ondiꞌ tumabuk dianakon bu ondiꞌ mokokunut dia sog pomali u, ongon da og mukum dianon. Og taluꞌ u koyon nog pigustal u dianilan, koyon og mukum dianilan sog gimpusan nog gondow. ");
INSERT INTO suc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Poꞌ daꞌ u pogustal nog dili dianakon, sugaꞌid non, og dia nog Gamaꞌ u nog ion og mikpopangoy dianakon dini. Pimolian non akon bog olo og poktoluꞌon ku bu olo og mogandun kotaluꞌ u dun. ");
INSERT INTO suc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kosunan ku nog og dondagan non kituꞌ dianakon mokobogoy nog kotubuꞌ nog daꞌ kopus non. Dadi, ain og tinaluꞌ u kituꞌ dianiu, ion non og dinondag nog Gamaꞌ u tumaluꞌ dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pogbolomaꞌon dona og kologyaꞌan koyon nog iningolanan Liniusan, kisunan ni Isus nog daliꞌ na og tang nog gumonat na ion dini sog dunya mangoy na ion dituꞌ sog Gamaꞌ non. Kololaman non og pigotowan non dini sog dunya. Bu numun kituꞌ, pitongow non na dianilan bog andun dodaꞌ og glolaman non dianilan. ");
INSERT INTO suc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Si Isus bu og sulangguꞌanan non, migadap ilan moglobungan. Og sala kotow dianilan, ngalan non si Judas Iskariot og bataꞌ ni Simun, pipikilan na ni Kindagow nog uokilon non na si Isus dia sog glaꞌat. ");
INSERT INTO suc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Kisunan ni Isus nog binogayan ion nog Gamaꞌ non nog ion og mokopogbayaꞌ sog glam non. Kisunan non dosop nog ion miktidu sog Mikpongon bu ion mokpuliꞌ dituꞌ non. ");
INSERT INTO suc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Dadi, sog solian nilan koyon kuman, migbuat ion mangka non luasoy og sulagbon non bu pongandit nog tualia. ");
INSERT INTO suc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tubus nituꞌ, minudud ion nog tubig dia sog polonggana mangka non tolipunoy mongugas og botisanan nog sulangguꞌanan non bu pomunasoy nog tualia kituꞌ nog pingandit non. ");
INSERT INTO suc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pinipini non mugas nog botis ni Simun Piter, miktaluꞌ si Piter nog, “Kounutan, ugasan mu taꞌ og botis u?” ");
INSERT INTO suc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tinabal ion ni Isus nog, “Og piginang u koni ondiꞌ niu pa mosabut numun kituꞌ. Tibua, motubus ini, sog binayaꞌ nog gondow, mosabut niu da.” ");
INSERT INTO suc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tibua, miktaluꞌ si Piter nog, “Ondiꞌ u nododaꞌ moleg nog ugasan mu og botis u minsan nanu!” Tinabal ion ni Isus nog, “Bila ondiꞌ u kugasan og botis mu, konaꞌ u ika og sakup.” ");
INSERT INTO suc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Dadi, tinumabal si Piter nog, “Bila buan maꞌ nituꞌ Kounutan, konaꞌ tibua og botis u og ugasan mu, sugaꞌid non, ugasoy mu dosop asta og komot u bu og gulu u!” ");
INSERT INTO suc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tinabal ion ni Isus nog, “Og gotow nog mikopoliguꞌ na, milonuꞌ na og tibuk nog glawas non, lual da og botis non. Bu milonuꞌ amu na, lual da sog sala kotow dianiu.” ");
INSERT INTO suc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Saꞌan ini tinaluꞌ non poꞌ kisunan non na bog sima og posunguꞌ kituꞌ mongulaꞌat dianon. ");
INSERT INTO suc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Dangan midoksuꞌ non pongugasoy og botisanan nilan, sinolug non mokpuliꞌ og sulagbon non kituꞌ mangka ion pokpuliꞌ madap dianilan. Sinakan non ilan nog, “Misabut niu dotaꞌ bog olo og piginang u kituꞌ dianiu? ");
INSERT INTO suc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Og pogingalan niu dianakon, og Polopanad, bu og Kounutan. Motud ion poꞌ maꞌ nituꞌ u dodaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bila inugasan ku ma og botisanan niu saka og kounutan bu polopanad niu akon, amu siꞌoy, sumboy moginugasoy amu dosop nog botisanan niu. ");
INSERT INTO suc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Saꞌan ini ininang u poꞌ bagun niu poglogilingan og kopokpobabaꞌ u dianiu. ");
INSERT INTO suc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Toluꞌon ku dianiu, daꞌidun og kisonggulan nog motas pa dia sog pigonongan non. Domikian dosop maꞌ nituꞌ nog daꞌidun og sosuguꞌon nog motas pa ion dia sog mokpopanow dianon. ");
INSERT INTO suc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Numun kituꞌ kisunan niu noma ini, popiaon amu dun bila unuton niu. ");
INSERT INTO suc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Og piktoluꞌon ku koni konaꞌ paꞌali sog glam niu poꞌ kisunan ku og gotowanan kituꞌ nog piniliꞌ u. Tibua, sumboy nododaꞌ motuman og sinulat kituꞌ sog Kitab nog, ‘Og dinumuma dianakon kuman, ion og mongulaꞌat dianakon.’ ");
INSERT INTO suc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Saꞌan toluꞌon ku dianiu numun kituꞌ mangka siꞌoy kotuman, poꞌ bila motuman na ini, bagun amu tumud nog ion non ini akon. ");
INSERT INTO suc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Toluꞌon ku dianiu, simasima og tumolimaꞌ nog popongoyon ku koyon dion niu, tinolimaꞌ non dosop akon. Bu simasima og tumolimaꞌ dianakon, tinolimaꞌ non dosop og mikpopangoy kituꞌ dianakon dini sog dunya.” ");
INSERT INTO suc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Dangan midoksuꞌ non toluꞌoy, mitolimbasow ion tokodoy mangka ion poktaluꞌ nog, “Toluꞌon ku dianiu, og sala kotow dianiu og mongulaꞌat dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Dadi, miktinontongoy og sulangguꞌanan non koyon poꞌ kisobuꞌan ilan nog tinaluꞌ non koyon bu diꞌ nilan kosunan bog sima og pigolong non koyon. ");
INSERT INTO suc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Sala kotow dia sog sulangguꞌanan non koyon nog kololaman non tokodoy, dia sog molani non. ");
INSERT INTO suc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Dadi, si Simun Piter minonggiꞌ dia sog kololaman koyon mangka ion pogilom dianon nog, “Sakoy mu dow ion bog sima og pogolongon non koyon.” ");
INSERT INTO suc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dadi, og sulangguꞌ non kituꞌ linumodis dianon mangka ion poksak nog, “Kounutan, sima og pogolongon mu koyon?” ");
INSERT INTO suc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tinumabal si Isus nog, “Ain og tulunan ku nog pan koni nog gugowon ku sog sabow, ion og pigolong u kituꞌ.” Dangan migugow non na og pan kituꞌ, tinulun non dia ni Judas Iskariot, og bataꞌ ni Simun. ");
INSERT INTO suc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ampun mitabuk non og pan kituꞌ, miglandan sumangon dianon og Soitan. Miktaluꞌ si Isus dianon nog, “Inang mu moglandan olo og poksipian mu kituꞌ moginang.” ");
INSERT INTO suc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tibua, og dumaanan nilan koyon, daꞌ nilan kosabut bog olo og maꞌana nog tinaluꞌ ni Isus kituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Poꞌ si Judas, ion og migaid nog sin nilan. Dadi, baluꞌ nilan dun, dinondag ion mangoy sumaluy nog kulang nilan sog kologyaꞌan koyon, otawaka dinondag taꞌ ion mangoy momogoy dia sog miskinan. ");
INSERT INTO suc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Dadi, ampun mitabuk non og pan kituꞌ, linumiu ion moglandan. Bu gobi na. ");
INSERT INTO suc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Dangan mikogonat tibua si Judas, miktaluꞌ si Isus nog, “Numun kituꞌ motongow na og kotas nog Binataꞌ sog Kilawan. Bu bianan dianon motongow bog andun kotas og Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bu bila motongow og kotas nog Mikpongon bianan dia sog Binataꞌ sog Kilawan, og Mikpongon, potason non dosop og Binataꞌ sog Kilawan. Bu sododuꞌun inangon non. ");
INSERT INTO suc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Amu og gombataꞌanan ku, ondiꞌ ita na mobon mokunul niu. Ponontongon niu akon. Tibua, numun kituꞌ toluꞌon ku dianiu nog maꞌ nog tinaluꞌ u kituꞌ dia sog kounutananan nog bansa Hudyu, nog ain gongayan ku ondiꞌ amu mokangoy dun. ");
INSERT INTO suc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ongon og bogu dondagan ku dianiu. Pokilolamoy amu. Bu og kopokilolamoy niu koyon sumboy mamaꞌ nog glolaman ku dianiu. ");
INSERT INTO suc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bila moglinolamoy amu, kilolaan amu nog glam nog gotowanan nog sulangguꞌanan ku amu.” ");
INSERT INTO suc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dadi, si Simun Piter miksak nog, “Kounutan, ain ka buan angoy?” Tinabal ion ni Isus nog, “Ondiꞌ a mokodunut sog ain gongayan ku numun koni. Tibua, sog gunan nog gondow, moglondug a da.” ");
INSERT INTO suc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Miksak nosop si Piter nog, “Kounutan, iduma ondiꞌ u ma mokodunut dianika numun kituꞌ? Otason ku tanan sumoliu matoy dianika.” ");
INSERT INTO suc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tinabal ion ni Isus nog, “Otason mu da gidoy nog sumoliu matoy a dianakon? Toluꞌon ku dianika, nog mangka siꞌoy poktukalaꞌ og manuk, tolu kali mu na akon sonsingoy nog ondiꞌ mu akon kilolaan.” ");
INSERT INTO suc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Miktaluꞌ si Isus dia sog sulangguꞌanan non koyon nog, “Naꞌ amu mosusa. Pongandol amu kobon non dia sog Mikpongon, bu pongandol amu dosop dianakon. ");
INSERT INTO suc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Dituꞌ sog Gamaꞌ u modakol og pogonongan dun. Somoꞌ ondiꞌ motud og piktaluꞌ u koni, ondiꞌ u na bosia toluꞌon dianiu nog mangoy u moksimpan nog pogonongan niu. ");
INSERT INTO suc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Dadi, bila mokangoy u na moksimpan nog pogonongan niu dituꞌ, puliꞌon ku na amu poꞌ bagun da minsan ain u, dituꞌ amu dosop. ");
INSERT INTO suc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bu kosunan niu og bianan mangoy dituꞌ sog pogolongon ku koyon nog gongayan ku.” ");
INSERT INTO suc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Dadi, miktaluꞌ si Tomas dianon nog, “Kounutan, diꞌ nami kosunan bog ain ka angoy. Olo ma og mogandun kisunoy nami nog dalan posunguꞌ dituꞌ?” ");
INSERT INTO suc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Dadi, tinumabal si Isus nog, “Akon og Dalan, akon og Motud, bu akon og Kotubuꞌ. Ondaꞌidun og mokangoy sog pigonongan nog Gamaꞌ u bog ondiꞌ da ion mian dianakon. ");
INSERT INTO suc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bila kisunan niu noma akon, kisunan niu dosop og Gamaꞌ u. Tidu numun kituꞌ kisunan niu na ion bu mitongow niu na ion.” ");
INSERT INTO suc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Miktaluꞌ si Pilip nog, “Kounutan, potongow mu tibua dianami og Gamaꞌ poꞌ ombaꞌis nami na.” ");
INSERT INTO suc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tinabal ion ni Isus nog, “Pilip, miobon ita na mokunul saka ondiꞌ mu pa akon kosunan? Iduma moktaluꞌ a ma nog potongowon ku dianika og Gamaꞌ u? Toluꞌon ku dianika, nog simasima og mikotongow dianakon, mitongow non dosop og Gamaꞌ u. ");
INSERT INTO suc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Diꞌ a taꞌ tumud, Pilip, nog akon, dia u sog Gamaꞌ bu og Gamaꞌ dini dosop nakon? Poꞌ og glam nog pomali u dianiu, konaꞌ tibua akon dili og piktiduan dun, sugaꞌid non, og Gamaꞌ u nog ion dia nakon, ion og miginang nini. ");
INSERT INTO suc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tud niu og tinaluꞌ u kituꞌ nog akon, dia u sog Gamaꞌ bu ion dini nakon. Bila ondiꞌ amu pa tumud dun sabap sog taluꞌ u, tud amu sabap sog gingyataꞌanan kituꞌ nog gininang u. ");
INSERT INTO suc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Toluꞌon ku dianiu, simasima og mongandol dianakon, kilingan non dosop og gininang u kituꞌ. Bu labi pa dituꞌ og minang non poꞌ mokpuliꞌ u na dituꞌ sog Gamaꞌ u. ");
INSERT INTO suc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bu inangon ku ain og pongonion niu dianakon bianan sog ngalan ku, bagun da ompotongow u og kotas nog bayaꞌ nog Gamaꞌ u bianan dia sog Bataꞌ non. ");
INSERT INTO suc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Dadi, mokopongoni amu minsan olo bianan sog ngalan ku poꞌ inangon ku dianiu.” ");
INSERT INTO suc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Maꞌ long sop ni Isus, “Bila tantu dodaꞌ nog molalam amu dianakon, inangon niu nododaꞌ og dondagan ku. ");
INSERT INTO suc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mongoni u dia sog Gamaꞌ u bu bogayan non amu nog len og Tumabang dianiu nog sumoliu dianakon. Ion dumuma dianiu somul non. ");
INSERT INTO suc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ion og Bolakat nog Mikpongon bu ion non og mokpanad dianiu nog motud. Og gotowanan dini sog dunya nog daꞌ pongandol sog Mikpongon, ondiꞌ nilan ion motolimaꞌ poꞌ daꞌ nilan ion kotongow bu daꞌ nilan ion dosop kilolaoy. Tibua amu, kosunan niu ion poꞌ dia ion niu kobon non bu mogonong ion dianiu. ");
INSERT INTO suc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Minsan siꞌoy gumonat u na, ondiꞌ u amu gonatan nog amu amu da poꞌ akon, mokpuliꞌ u da dini niu. ");
INSERT INTO suc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Diꞌ mobon og gotowanan koyon nog daꞌ pongandol dia sog Mikpongon, ondiꞌ nilan na akon motongow. Tibua, amu, motongow niu da akon poꞌ motubuꞌ u da mokpuliꞌ. Bu sabap dituꞌ, amu siꞌoy, motubuꞌ amu dosop mamaꞌ nakon. ");
INSERT INTO suc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kosunan niu sog gondow koyon nog solabuk ami da nog Gamaꞌ u. Domikian dosop dianita nog dia amu nakon, bu akon siꞌoy, dia u dosop niu. ");
INSERT INTO suc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Simasima tumolimaꞌ nog dondagananan ku mangka non unutoy, ion miktantu molalam dianakon. Bu ain molalam dianakon, kololaman ion nog Gamaꞌ u. Bu akon siꞌoy, molalam u dosop dianon bu mokpotongow u dianon.” ");
INSERT INTO suc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Miktaluꞌ si Judas nog ion konaꞌ ni Judas Iskariot nog, “Kounutan, iduma nog ami ma tibua og potongowan mu dun? Iduma ondiꞌ nika ma dosop potongowon sog glam nog gotowanan dini sog glupaꞌan?” ");
INSERT INTO suc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tinumabal si Isus nog, “Simasima og molalam dianakon, unuton non og pomali u. Ion kololaman nog Gamaꞌ u. Og Gamaꞌ u bu akon mangoy dianon bu imungon nami ion nog pogonongan nami. ");
INSERT INTO suc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tibua, og gotow nog diꞌ molalam dianakon, ondiꞌ nododaꞌ mokokunut nog pomali u. Og tinaluꞌ u kituꞌ dianiu konaꞌ og dili taluꞌ u, sugaꞌid non, miktidu ituꞌ sog Gamaꞌ u nog ion og mikpopangoy dianakon dini. ");
INSERT INTO suc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tinaluꞌ u ini dianiu nog solian nog dini u pa niu. ");
INSERT INTO suc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tibua, og Tumabang kituꞌ dianiu, ion non og Bolakat nog Mikpongon, og dondagon nog Gamaꞌ u mangoy dianiu bianan sog ngalan ku, mokpanad ion dianiu sog glam non bu popondomon non dosop dianiu og glam nog tinaluꞌ u kituꞌ dianiu. ");
INSERT INTO suc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Dadi, bila gumonat u na, bogayan ku amu nog kotiknaꞌ nog pomikilan mamaꞌ nog kotiknaꞌ nog pikilan ku. Og gotowanan dini sog dunya nog daꞌ tud dianakon, ondiꞌ ilan mokobogoy nog kotiknaꞌ nog pomikilan nog mamaꞌ nituꞌ. Dadi, naꞌ amu mosusa bu naꞌ amu mondok. ");
INSERT INTO suc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Midongog niu og taluꞌ u nog gumonat u na bu mokpuliꞌ u da dini niu. Bila miktantu amu dodaꞌ molalam dianakon, mokpogdaꞌdaꞌ amu nog mangoy u dituꞌ sog Gamaꞌ u poꞌ ion labi pa kotas dianakon. ");
INSERT INTO suc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Saꞌan pidonsamaꞌ u ini tumaluꞌ dianiu poꞌ bagun amu tumud bila motuman na og glam nini dianakon. ");
INSERT INTO suc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ondiꞌ na ompayat og kopogabitabit ta niu poꞌ posunguꞌ na matong si Kindagow, og kounutan dini sog dunya. Tibua, ondaꞌidun da og bayaꞌ non dianakon. ");
INSERT INTO suc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tibua, sumboy kosunan nog gotowanan dini sog dunya nog molalam u sog Gamaꞌ u bu inangon ku ain da og dondagan non dianakon.” Mangka ion poktaluꞌ nog, “Alung, ompanow ita na.” ");
INSERT INTO suc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Migustal si Isus nog solabuk pononggiꞌan. Maꞌ long non dun, “Akon, mamaꞌ u nog tantu bolagon, bu og Gamaꞌ u, ion non og mogusibaꞌ dun. ");
INSERT INTO suc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Bila ngon og panga u nog ondiꞌ mogbunga, sopekon non. Bu ain og panga u kituꞌ nog mogbunga, kopunon non bagun dumungag mogbunga. ");
INSERT INTO suc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Milonuꞌ amu na sabap sog kopokokunut niu dia sog pomali u. ");
INSERT INTO suc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sumboy sumingkot amu dianakon poꞌ akon siꞌoy sumingkot u dosop dianiu. Poꞌ og panga, ondiꞌ nododaꞌ mogbunga bila ondiꞌ da sumingkot dia sog pun non. Bu amu siꞌoy, domikian dosop nog maꞌ nituꞌ, ondiꞌ amu dosop mogbunga bila ondiꞌ amu da sumingkot dianakon. ");
INSERT INTO suc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mamaꞌ u nog pun nog bolagon bu amu og pangaanan non. Bila og gotow sumingkot dianakon, bu akon siꞌoy sumingkot u dianon, mogbunga ion nog modakol. Poꞌ bila ondaꞌ u dianiu, daꞌidun nododaꞌ og minang niu. ");
INSERT INTO suc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bila og gotow sumuoy dianakon, daꞌ doksuꞌ nog kotubuꞌ non poꞌ mamaꞌ ion nog panga kituꞌ nog misopek bu potiangoy mogangu. Og pangaanan kituꞌ topukon mangka tikpuꞌoy dia sog gapuy bu kotutung. ");
INSERT INTO suc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bila sumingkot amu dianakon bu ungodon niu og taluꞌ u dianiu, minsan olo og pongonion niu dianakon, bogoyon da dianiu. ");
INSERT INTO suc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bu ompotas og Gamaꞌ u dun bila mogbunga amu nog modakol. Poꞌ bianan dituꞌ, kilolaan amu nog gotowanan nog sulangguꞌanan ku amu. ");
INSERT INTO suc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Og glolaman ku dianiu mamaꞌ dosop nog glolaman nog Gamaꞌ u dianakon. Dadi, naꞌ amu sumuoy dia sog glolaman ku. ");
INSERT INTO suc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bila mikokunut amu dia sog dondagananan ku, ondiꞌ amu sumuoy dia sog glolaman ku. Mamaꞌ dosop nog kopokokunut u dia sog dondagananan nog Gamaꞌ u nog ondaꞌ u suoy dia sog glolaman non. ");
INSERT INTO suc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Tinaluꞌ u ini dianiu bagun niu makod og daꞌdaꞌan ku, og daꞌdaꞌan kituꞌ nog diꞌ moglokobus. ");
INSERT INTO suc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Koni og dondagan ku, pokilolamoy amu mamaꞌ nog glolaman ku dianiu. ");
INSERT INTO suc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Poꞌ og glolaman nog ondiꞌ kolobian maꞌ nini, og gotow kituꞌ nog otason non sumoliu matoy dia sog pakasibataꞌ non. ");
INSERT INTO suc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Amu og pakasibataꞌanan ku bila mokokunut amu dia sog dondagan ku. ");
INSERT INTO suc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Diꞌ u na amu itungon nog kisonggulan ku. Poꞌ og kisonggulan ondiꞌ non sunan bog olo og ginangon nog kounutan non. Sugaꞌid non, initung u amu nog pakasibataꞌanan ku poꞌ og glam nog midongog u dia sog Gamaꞌ u piosun ku na dianiu. ");
INSERT INTO suc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Konaꞌ niu og mimiliꞌ dianakon, sugaꞌid non, piniliꞌ u amu mangka u amu poponowoy moginang nog molongas kituꞌ nog og bunga non asta sog daꞌ kopus non. Tubus nituꞌ, minsan olo og pongonion niu sog Gamaꞌ u bianan sog ngalan ku, bogoyon non dianiu. ");
INSERT INTO suc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Dadi, koni og dondagan ku dianiu, nog sumboy mokilolamoy amu. ");
INSERT INTO suc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Bila pokongitan amu nog gotowanan sog dunya koni, naꞌ amu mosobuꞌ dun poꞌ mikuna u pa nilan pokongitoy. ");
INSERT INTO suc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Somoꞌ sakup nilan amu, kololaman nilan amu maꞌ nilan. Tibua, saꞌan ion mangit ilan dianiu, poꞌ piniliꞌ u amu tidu dianilan. ");
INSERT INTO suc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Poktulikoy niu og tinaluꞌ u kituꞌ dianiu nog daꞌidun og kisonggulan nog motas pa dia sog kounutan non. Bu bila pisinsa nilan akon, og kounutan niu, posinsaon nilan dosop amu. Tibua, bila mikokunut ilan da sog pomali u, mokokunut ilan dosop dia sog pomali niu. ");
INSERT INTO suc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Poꞌ saꞌan ion maꞌ nion og ginangon nilan dianiu poꞌ dia amu nakon. Poꞌ diꞌ nilan kilolaan og mikpopangoy kituꞌ dianakon. ");
INSERT INTO suc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Somoꞌ ondaꞌ u angoy dini bu pomolioy ilan, ondiꞌ ilan bosia komotudan nog mikodusa ilan. Tibua, numun kituꞌ, ondiꞌ ilan na mokopononsing nog daꞌ ilan pokodusa. ");
INSERT INTO suc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Poꞌ simasima og mangit dianakon, pokongitan non dosop og Gamaꞌ u. ");
INSERT INTO suc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Somoꞌ daꞌ u inangoy dion nilan og gingyataꞌanan bu og ginang kituꞌ nog kosobuꞌsobuꞌ nog diꞌ minang nog sagyaotow, ondiꞌ ilan bosia komotudan nog mikodusa ilan. Tibua, minsan siꞌoy mitongow nilan na og gingyataꞌanan ku kituꞌ, pikongitan nilan da ami nog Gamaꞌ u. ");
INSERT INTO suc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ion non na ini og kotumanan nog sinulat kituꞌ dia sog botad nilan nog, ‘Mangit ilan dianakon nog daꞌ sabap non.’ ");
INSERT INTO suc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Matong da og Tumabang kituꞌ dianiu nog ion non og Bolakat nog Mikpongon, og moguksug nog motud paꞌali sog Mikpongon. Popongoyon ku ion dion niu tidu sog Gamaꞌ u bu tumaksiꞌ ion paꞌali dianakon. ");
INSERT INTO suc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Bu amu siꞌoy og taksiꞌ u dosop poꞌ mikunul ita niu tidu pa sog tolipunan. ");
INSERT INTO suc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Saꞌan ini tinaluꞌ u dianiu bagun amu da ondiꞌ mosuoy dianakon. ");
INSERT INTO suc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Og kounutananan nog bansa Hudyu, powaꞌon nilan na amu dia sog baloyanan koyon nog poglumpukan nilan. Bu ongon gondow non, og duma gotowanan, pomunuꞌon nilan amu poꞌ baluꞌ nilan dun maꞌ nituꞌ og bian nog kopokokunut nilan dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Saꞌan nion maꞌ nion ginangon nilan poꞌ daꞌ nilan kosunoy akon otawaka og Gamaꞌ u. ");
INSERT INTO suc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tibua, pidonsamaꞌ u ini tumaluꞌ dianiu bagun da bila matong og tang koyon, ompikil niu da og tinaluꞌ u koni.” Maꞌ long sop ni Isus, “Daꞌ u ini toluꞌoy dianiu sog tolipunan poꞌ mikunul ita pa. ");
INSERT INTO suc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Tibua, mokpuliꞌ u na dituꞌ sog mikpopangoy kituꞌ dianakon, saka daꞌidun motanan, sala kotow siꞌoy dianiu, og moksak dianakon bog ain u angoy. ");
INSERT INTO suc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Saꞌan landuꞌ og susaan niu dun poꞌ sabap sog tinaluꞌ u kituꞌ dianiu. ");
INSERT INTO suc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tibua, toluꞌon ku dianiu, og koboꞌisan niu ini saꞌan gonatan ku amu. Poꞌ bila ondiꞌ u amu gonatan, og Tumabang kituꞌ ondiꞌ mangoy dini niu. Tibua, bila gumonat u na, popongoyon ku ion dianiu. ");
INSERT INTO suc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Bu bila matong na ion dini, posobuton non dia sog gotowanan dini sog dunya nog misimoy og sabut nilan paꞌali sog dusa, sog kodulusan, bu sog kopomolihalaꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Saꞌan posobuton non dianilan paꞌali sog dusa poꞌ diꞌ ilan tumud dianakon. ");
INSERT INTO suc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Saꞌan posobuton non paꞌali sog kodulusan poꞌ mangoy u na dituꞌ sog Gamaꞌ u bu diꞌ niu na akon motongow. ");
INSERT INTO suc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bu saꞌan posobuton non paꞌali sog kopomolihalaꞌ nog Mikpongon sog dunya poꞌ si Kindagow, og kounutan dini sog dunya koni, inukum na donsamaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Modakol pa bosia og kolegan ku tumaluꞌ dianiu, tibua, ondiꞌ na mosalud dianiu. ");
INSERT INTO suc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tibua, bila matong na og Bolakat nog Mikpongon, ponuluꞌan non amu sog glam nog motud paꞌali dianakon. Ondiꞌ ion moktaluꞌ nog dili dianon. Sugaꞌid non, polotason non tibua dianiu ain og midongog non. Bu posobuton non dosop dianiu bog olo og matong sog gunan nog gondow. ");
INSERT INTO suc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Potason non akon poꞌ og glam nog posobuton non koyon dianiu, dianakon tidu. ");
INSERT INTO suc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Og glam nog dia sog Gamaꞌ u, akon dosop dun. Dadi saꞌan ituꞌ, tinaluꞌ u nog og Bolakat nog Mikpongon, og glam nog posobuton non koyon, dianakon tidu.” ");
INSERT INTO suc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Maꞌ long sop ni Isus, “Bombusombus ondiꞌ niu na akon motongow. Tubus nituꞌ, ondiꞌ mobon motongow niu dosop akon mokpuliꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dadi, og duma sulangguꞌanan non, miksinaksakoy ilan, ilan bu ilan nog, “Olo gidoy og maꞌana nog tinaluꞌ non kituꞌ nog bombus ondiꞌ ta ion motongow. Tibua, ondiꞌ mobon motongow ta dosop ion mokpuliꞌ? Olo sop gidoy og maꞌana nog tinaluꞌ non kituꞌ nog muliꞌ ion dituꞌ sog Gamaꞌ non?” ");
INSERT INTO suc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bu miksitaluꞌ ilan dosop nog, “Olo gidoy og maꞌana nog tinaluꞌ non kituꞌ nog ondiꞌ mobon? Mologon kosabut. Ondiꞌ ta kosunan bog olo og maꞌana non.” ");
INSERT INTO suc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tibua, si Isus, kisunan non nog moleg ilan bosia moksak dianon. Dadi, miktaluꞌ ion dianilan nog, “Moksinaksakoy amu ma paꞌali sog piktaluꞌ u kituꞌ komun nog bombusombus ondiꞌ niu na akon motongow, tubus nituꞌ, ondiꞌ mobon motongow niu dosop akon mokpuliꞌ? ");
INSERT INTO suc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Toluꞌon ku dianiu, nog og gotowanan nog ondiꞌ tumud dianakon, mokpogdaꞌdaꞌ ilan sabap sog posunguꞌ koni matong dianakon. Tibua amu, mokpoksogow amu kobal nog susaan niu dun. Bigyaꞌ non, og susaan niu koyon, og doksuꞌan non og daꞌdaꞌan. ");
INSERT INTO suc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ompononggiꞌ ta dia sog glibun. Bila ponokitan ion, moglogaga ion nog mosakit. Tibua, bila lumuas na og bataꞌ non, kolingawan non na og sinsaan non sabap sog daꞌdaꞌan non nog linumuas na og bataꞌ non. ");
INSERT INTO suc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Domikian dosop dianiu nog numun kituꞌ, solian niu mosusa poꞌ posunguꞌ niu na akon diꞌ motongow. Tibua, motongow niu da akon mokpuliꞌ bu mogdaꞌdaꞌ amu dun, og daꞌdaꞌan kituꞌ nog daꞌidun na mokagow dun dianiu. ");
INSERT INTO suc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Bila matong og gondow koyon, daꞌidun na og sakon niu dianakon. Poꞌ toluꞌon ku dianiu, nog minsan olo og pongonion niu bianan sog ngalan ku, bogoyon nog Gamaꞌ u dianiu. ");
INSERT INTO suc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Asta numun kituꞌ ondaꞌ amu pa sibon pongoni bianan sog ngalan ku. Pongoni amu bu motabuk niu, bu og daꞌdaꞌan niu ondiꞌ na moglokobus. ");
INSERT INTO suc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Og kodokolan nog piktaluꞌ u pibian ku sog dalil. Tibua, ongon da og gondow nog pologdongon ku tumaluꞌ dianiu paꞌali sog Gamaꞌ u. ");
INSERT INTO suc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Sog tang koyon, bila mongoni amu bianan sog ngalan ku, konaꞌ poꞌ sumboy u pa mongingolot dianiu mongoni sog Gamaꞌ u. ");
INSERT INTO suc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Poꞌ og Gamaꞌ u molalam dianiu poꞌ molalam amu buan dianakon. Bu tinumud amu nog dituꞌ u miktidu dianon. ");
INSERT INTO suc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Miktidu u dituꞌ sog Gamaꞌ u mangka u angoy sog kilawan bu numun kituꞌ gumonat u na dini sog kilawan poꞌ mokpuliꞌ u na dituꞌ non.” ");
INSERT INTO suc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dadi, miktaluꞌ og sulangguꞌanan non koyon nog, “Kounutan, numun kituꞌ mologdong na og taluꞌ mu koyon dianami. Ondaꞌ mu na doliloy. ");
INSERT INTO suc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Numun kituꞌ kisunan nami na nog kosunan mu og glam non. Poꞌ ondiꞌ nami pa toluꞌon og sak nami dianika, kosunan mu na donsamaꞌ bog olo og sakon nami dianika. Saꞌan ituꞌ tinumud ami nog miktidu a sog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Miktaluꞌ si Isus nog, “Dadi, numun kituꞌ tumud amu na buan dianakon? ");
INSERT INTO suc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Toluꞌon ku dianiu, nog ongon gondow matong bu numun kituꞌ minatong na, nog mokpokpolaꞌ amu. Monala kotow dianiu muliꞌ na sog konia konia baloy non bu gonatan niu na akon. Tibua, ondiꞌ u da mogdoduoy poꞌ og Gamaꞌ u dia da nakon. ");
INSERT INTO suc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Saꞌan ini tinaluꞌ u dianiu poꞌ bianan sog kosolabuk niu dianakon, kongonan amu nog kotiknaꞌ nog pomikilan. Mosinsa amu solian nog dini amu pa sog dunya. Tibua, pobogan niu og pomikilan niu poꞌ og dinunya dinag na dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mitubus tibua toluꞌoy ni Isus, tinumongal ion sog glangit mangka poktaluꞌ nog, “Amaꞌ, minatong na og tang. Potas mu na og Bataꞌ mu koni bagun non dosop ika ompotas. ");
INSERT INTO suc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Poꞌ binogoy mu dianon og bayaꞌ mogbayaꞌ dia sog glam nog gotow bagun non da kobogayan nog kotubuꞌ nog daꞌ kopus non, ain og gotowanan kituꞌ nog binogoy mu dianon. ");
INSERT INTO suc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Maꞌ nini og maꞌana nog kotubuꞌ koyon nog daꞌ kopus non, ain og gotowanan koyon nog kosunan nilan ika, nog ika da og Diwata, bu kosunan nilan dosop si Isukristu, nog ion og pipangoy mu dini, kobogayan ilan nog kotubuꞌ nog daꞌ kopus non. ");
INSERT INTO suc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Piotas u ika dini sog dunya koni bianan sog kodoksuꞌ u nog ginang nog dinondag mu moginang dianakon. ");
INSERT INTO suc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Dadi, numun kituꞌ potas mu akon, Amaꞌ, dia sog sunguꞌan mu mamaꞌ nog kotas u kituꞌ nog kobon ku dion nika sog daꞌ pa pongonoy og dunya. ");
INSERT INTO suc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Pinosun ku ika dia sog gotowanan koyon nog binogoy mu dianakon tidu sog dunya koni nog og gotowanan koyon donsamaꞌ na ika dun nog binogoy mu dianakon bu mikokunut ilan nog taluꞌ mu. ");
INSERT INTO suc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Numun kituꞌ kisunan nilan na nog og glam nog binogoy mu dianakon, ika dodaꞌ og piktiduan non. ");
INSERT INTO suc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Poꞌ pimali u dianilan og pikpanad mu dianakon, bu tinumud ilan dun. Saꞌan kisunan nilan mahatul nog akon, dia u nika miktidu. Bu tinumud ilan nog ika og mikpopangoy dianakon. ");
INSERT INTO suc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Pogyokinan ku ilan. Ondaꞌ u pogyakin nog duma gotowanan, sugaꞌid non, og pogyokinan ku og gotowanan kituꞌ nog binogoy mu dianakon. Poꞌ ilan koyon ika dun. ");
INSERT INTO suc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Og glam nog dianakon ika dun. Bu glam nog dianika akon dun. Bianan dianilan mipotas u dun. ");
INSERT INTO suc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ondiꞌ u na mobon sog dunya poꞌ mangoy u dion nika. Tibua, og gotowanan koyon nog binogoy mu dianakon, dini ilan pa sog dunya koni. Dadi, Amaꞌ, ika og midulus, ipat mu pa ilan bianan sog bayaꞌ nog ngalan mu, og ngalan koyon nog binogoy mu dianakon, bagun ilan moksolabuk mamaꞌ nog kopoksolabuk ta. ");
INSERT INTO suc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Solian nami mokunul, pitubudan ku ilan bu pigipat u ilan bianan sog bayaꞌ nog ngalan kituꞌ nog binogoy mu dianakon. Bu daꞌidun og mibolong dianilan, lual da dia sog sala kotow kituꞌ nog maꞌ nituꞌ nododaꞌ og kodoksuꞌan non, bagun da motuman og tinaluꞌ kituꞌ dia sog Kitab. ");
INSERT INTO suc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Posunguꞌ u na mangoy dion nika. Tibua, saꞌan ini tinaluꞌ u nog solian nog dini u pa sog dunya bagun da kongonan ilan nog daꞌdaꞌan ku nog diꞌ moglokobus. ");
INSERT INTO suc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Pimali u dianilan og taluꞌ mu. Bu og gotowanan dini sog dunya mikangit dianilan poꞌ konaꞌ nilan na og sakup. Mamaꞌ dosop nakon nog konaꞌ u nilan sakup. ");
INSERT INTO suc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ondaꞌ u pogyakin nog owaꞌon mu na ilan dini sog dunya koni. Sugaꞌid non, pogipat mu ilan dia sog kopongulaꞌat ni Kindagow. ");
INSERT INTO suc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Poꞌ konaꞌ ilan na og sakup nog gotowanan dini sog dunya. Maꞌ dosop nakon. ");
INSERT INTO suc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Dadi, siboy mu ilan dianika bianan sog motud. Og motud koyon, ion non og taluꞌ mu. ");
INSERT INTO suc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Domikian dosop nog akon pipangoy mu dini sog dunya, ilan siꞌoy dondagon ku dosop mangoy sog gotowanan dini sog dunya. ");
INSERT INTO suc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Sabap dianilan, siniboy u og glawas u dianika bagun da motantu tokodoy nog ilan koyon miakod mu. ");
INSERT INTO suc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Konaꞌ tibua nilan og pogyokinan ku, sugaꞌid non, asta og posunguꞌ kituꞌ tumud dianakon bianan sog gustalan nilan paꞌali dianakon. ");
INSERT INTO suc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Pogyakin ku ilan bagun ilan da mokosolabuk og glam nilan, Amaꞌ, mamaꞌ dosop nog ika bu akon nog akon dia u nika bu ika, diaan ka nakon. Ilan siꞌoy, pongonion ku nog dia ilan nita bagun og gotowanan dini sog dunya, tumud ilan nog pipangoy mu akon dini. ");
INSERT INTO suc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Binogayan ku ilan nog bayaꞌ mamaꞌ nog kotas nog bayaꞌ nog binogoy mu dianakon bagun moksolabuk og pomikilan nilan mamaꞌ nog kopoksolabuk ta. ");
INSERT INTO suc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Og maꞌana non, akon, dia u nilan bu ika diaan ka nakon bagun ilan da moksolabuk tokodoy. Bu bianan dituꞌ, og gotowanan dini sog dunya, kosunan nilan nog ika og mikpopangoy dianakon bu molalam a dianilan maꞌ nog glolaman mu dianakon. ");
INSERT INTO suc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Amaꞌ, kolegan ku bosia nog, og gotowanan koyon nog binogoy mu dianakon nog dia ilan nakon minsan ain u, bagun nilan motongow og kotas u nog binogoy mu dianakon sabap sog glolaman mu dianakon sog daꞌ pa pongonoy og dunya. ");
INSERT INTO suc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Amaꞌ, ika og midulus, minsan siꞌoy daꞌ a kilolaoy nog gotowanan dini sog dunya, kinilolaan ku da ika, bu og gotowanan kituꞌ nog tinumud dianakon, kisunan nilan nog ika og mikpopangoy dianakon. ");
INSERT INTO suc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Piosun ku na dianilan paꞌali dianika bu ondiꞌ u lumotaꞌ mokposun paꞌali dianika bagun da og glolaman mu dianakon mongon dianilan bu akon dia u nilan.” ");
INSERT INTO suc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Dangan midoksuꞌ na si Isus mogyakin, minangoy ilan nog sulangguꞌanan non sog dipag nog sapaꞌ nog Kidron. Bu sinumolop ilan sog pigimulanan koyon nog kayu dion. ");
INSERT INTO suc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Si Judas, og mongulaꞌat kituꞌ dia ni Isus, kisunan non og ginongayan nilan poꞌ aluꞌaluꞌ dituꞌ ilan poglumpuk nog sulangguꞌanan non. ");
INSERT INTO suc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Dadi, minangoy si Judas dituꞌ sog pigimulanan koyon. Pinuluꞌan non og sundaluanan nog Roma bu og polongipatanan nog Baloy nog Poktomuyan dia sog Mikpongon nog pipangoy nog mokokotas nog boliananan bu og parasiuanan. Mikpogatul ilan nog bosi bu mikpoktiow ilan nog kinokod nog glangkoy. ");
INSERT INTO suc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Donsamaꞌ na kisunan ni Isus bog olo og posunguꞌ matong dianon. Dadi, linumpak non ilan mangka ion poksak nog, “Sima og pokponontongon niu koyon?” ");
INSERT INTO suc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tinumabal ilan nog, “Si Isus, og gotow Nasaret.” Tinabal ilan ni Isus nog, “Ion non noini akon!” Si Judas og polonipu kituꞌ, dion dosop pogindog. ");
INSERT INTO suc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Dangan miktaluꞌ si Isus nog, “Ion non noini akon,” mikpongogdud ilan nog boyaꞌan mikpogbuksak ilan tanan dun. ");
INSERT INTO suc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Bu sinakan mokpuliꞌ ni Isus nog, “Sima dodaꞌ og pokponontongon niu koyon?” Tinumabal ilan nosop nog, “Si Isus, og gotow Nasaret.” ");
INSERT INTO suc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tinabal ilan ni Isus nog, “Tinaluꞌ u na dianiu nog akon si Isus. Bila akon og pokponontongon niu koyon, naꞌ niu topason og dumaanan ku.” ");
INSERT INTO suc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Saꞌan ini tinaluꞌ non bagun motuman og tinaluꞌ non kituꞌ nog, “Amaꞌ, daꞌ u kobolongoy minsan sala kotow siꞌoy nog binogoy mu kituꞌ dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Si Simun Piter, ngon kalis non. Sinintak non mangka non tigbasoy si Malkus, og kisonggulan nog kounutan nog boliananan koyon boyaꞌan misikpoy og tolinga non dapit sog glintu. ");
INSERT INTO suc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Dadi, miktaluꞌ si Isus dia ni Piter nog, “Umaꞌ mu og kalis mu koyon! Poꞌ sumboy gogaan ku og sinsaan koni nog binogoy nog Gamaꞌ u dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tubus nituꞌ, og sundaluanan koyon dunut og kounutan nilan bu og polongipatanan nog Baloy nog Poktomuyan dia sog Mikpongon, inukpaꞌan nilan si Isus mangka nilan boludoy. ");
INSERT INTO suc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bu tiganaꞌ, inoit nilan ion dituꞌ ni Anas, og ponugangan ni Kaypas. Si Kaypas koni, ion non og kounutan nog boliananan sog ton kituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ion non og miktaluꞌ kituꞌ sog kounutananan nog bansa Hudyu nog sumboy ongon sala kotow og sumoliu matoy dia sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Si Simun Piter bu solabuk sulangguꞌ ni Isus koyon, tinumuyuk ilan dianon. Og sulangguꞌ kituꞌ sala kotow, donsamaꞌ na kilolaan nog kounutan nog boliananan. Saꞌan mikodunut ion sumolod dia ni Isus dituꞌ sog glomalomaan nog baloy nog kounutan nog boliananan koyon. ");
INSERT INTO suc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tibua, si Piter dia da taman sog pintuꞌ nog galad koyon poꞌ diꞌ posolodon. Og sulangguꞌ kituꞌ nog donsamaꞌ na kilolaan nog kounutan nog boliananan, mikpuliꞌ lumiu mangka poktaluꞌ dia sog glibun koyon dion og toliipat nog pintuꞌ nog galad koyon, mangka non posolodoy si Piter. ");
INSERT INTO suc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Sinakan si Piter nog glibun koyon nog, “Konaꞌ a taꞌ og sulangguꞌ ni Isus?” Tinabal ion ni Piter nog, “Konaꞌ u, le!” ");
INSERT INTO suc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Motigdow og tang koyon. Dadi, og kisonggulananan bu og polongipatanan koyon, migindog ilan monalang sog piktogunan nilan koyon. Si Piter siꞌoy minampuꞌ dosop mindog monalang dianilan. ");
INSERT INTO suc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sintak non, piksumodiaan si Isus nog kounutan nog boliananan koyon paꞌali sog pikpanad non bu sog sulangguꞌanan non. ");
INSERT INTO suc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tinumabal si Isus nog, “Og glam nog pikpanad u kituꞌ, ondaꞌ u poglingodoy. Sugaꞌid non, dia u pikpanad sog Baloy nog Poktomuyan dia sog Mikpongon bu dia sog baloyanan nog poglumpukan nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Iduma akon ma og poksakan niu dun? Dia niu bosia sak sog gotowanan koyon nog mikodongog nog pikpanad u poꞌ kisunan nilan bog olo og tinaluꞌ u.” ");
INSERT INTO suc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Dangan miluksad og taluꞌ ni Isus koyon, dinapiꞌ ion nog sala kotow polongipat koyon dion pogindog sog molani non kobon non moktaluꞌ nog, “Iduma mamaꞌ ma nion og koponabal mu dia sog kounutan nog boliananan? Ondiꞌ a ma mogbotad dianon?” ");
INSERT INTO suc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tinumabal si Isus nog, “Bila miktaluꞌ u nog molaton, taluꞌ mu sog glam ta koni dini bog olo og molaton kituꞌ. Tibua, bila motud og tinaluꞌ u, iduma dopiꞌon mu ma akon?” ");
INSERT INTO suc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tubus nituꞌ, dinondag ni Anas nog oiton nilan si Isus dituꞌ ni Kaypas, og kounutan nog boliananan nog binalud pa ion. ");
INSERT INTO suc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Si Simun Piter, sog sonuk non mogindog monalang, sinakan ion nog gotowanan nog, “Ika, konaꞌ a taꞌ og sulangguꞌ nog gotow kituꞌ?” Tibua, minonsing si Piter. Long non dun, “Konaꞌ u, le!” ");
INSERT INTO suc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Bu ongon sala kotow og kisonggulan nog kounutan nog boliananan koyon dion, og golo nog tinigbas non kituꞌ dituꞌ sog pogimulanan kituꞌ nog kayu. Miktaluꞌ ion nog, “Ika bayuꞌ og mitongow u kituꞌ sog kukpaꞌ dia ni Isus?” ");
INSERT INTO suc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tibua, minonsing nosop si Piter. Sododuꞌun midongog non miktukalaꞌ og manuk. ");
INSERT INTO suc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tubus nituꞌ, modolomdolom pa, inoit nilan na si Isus tidu sog baloy ni Kaypas mangoy dituꞌ sog baloy ni Pilatu nog ion og gubernador tidu sog Roma. Dangan minatong ilan dituꞌ, og kounutananan nog bansa Hudyu koyon, ondaꞌ ilan solod sog baloy ni Pilatu koyon poꞌ og gliꞌinan nilan, bagun ilan da mokampuꞌ kuman nog dulang kituꞌ nog dia sog gondow nog Liniusan. ");
INSERT INTO suc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Dadi, linumuas si Pilatu mangka non ilan sakoy nog, “Olo og sumbungan niu paꞌali sog gotow koyon nog inoit niu dini?” ");
INSERT INTO suc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tinumabal ilan nog, “Somoꞌ daꞌidun salaꞌ nog gotow koyon, ondiꞌ nami nododaꞌ ion oiton dini nika!” ");
INSERT INTO suc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Dadi, miktaluꞌ si Pilatu nog, “Pitang niu na ion bu ukum niu bianan sog dili botad niu.” Tinumabal og gotowanan koyon nog, “Ondaꞌ ami tugdakoy munuꞌ nog gotow.” ");
INSERT INTO suc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Og glam nini kobianan non bagun motuman og tinaluꞌ non kituꞌ paꞌali sog potayan non. ");
INSERT INTO suc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Dadi si Pilatu, mikpuliꞌ ion sumolod sog baloy nog pongukuman. Bu sinabi non si Isus mangka non sakoy nog, “Ika taꞌ og datuꞌ nog bansa Hudyu?” ");
INSERT INTO suc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tinumabal si Isus nog, “Og sak mu koyon, dianika taꞌ miktidu, otawaka midongog mu taꞌ sog duma?” ");
INSERT INTO suc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tinumabal si Pilatu nog, “Iduma, Hudyu u taꞌ? Og pakasi Hudyuanan mu bu og mokokotas nog boliananan niu, ilan og miksumbung dianika dini nakon. Olo buan og salaꞌ mu?” ");
INSERT INTO suc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tinumabal si Isus nog, “Akon, og kopogdatuꞌ u konaꞌ dini sog dunya koni. Somoꞌ dini sog dunya og kopogdatuꞌ u, minantu bosia og pigotowan ku bagun ondiꞌ u kukpaꞌan nog gotow Hudyu. Tibua, toluꞌon ku mokpuliꞌ nog og kopogdatuꞌ u konaꞌ dini sog dunya koni.” ");
INSERT INTO suc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dadi, miktaluꞌ si Pilatu nog, “Og datuꞌ a buan!” Tinumabal si Isus nog, “Motud og tinaluꞌ mu koyon nog akon og datuꞌ. Saꞌan minangoy u dini sog dunya bu botaꞌoy poꞌ bagun ku ompanad og motud nog pomali. Simasima dia sog motud, ion monginongog dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dadi, miktaluꞌ si Pilatu nog, “Olo og motud?” Tubus nituꞌ, linumiu mokpuliꞌ si Pilatu dituꞌ sog Hudyuanan koyon bu poktaluꞌ nog, “Daꞌ u kotongowoy nog salaꞌ og gotow koyon. ");
INSERT INTO suc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tibua, ongon moda og botad niu nog giap matong og tang nog Ginang nog Liniusan, nog ngon sala kotow dia sog kolobusuan poluason ku dianiu. Moleg amu taꞌ nog koni na og poluason dianiu og datuꞌ koni nog Hudyuanan?” ");
INSERT INTO suc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dadi, miglogapis ilan nog, “Konaꞌ non! Sugaꞌid non, si Barabas og poluas mu!” (Si Barabas koni, ion og polonglaꞌug.) ");
INSERT INTO suc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tubus nituꞌ, dinondag ni Pilatu og sundaluanan nog pogdonogon nilan si Isus. ");
INSERT INTO suc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Linumikid og sundaluanan koyon nog bolagon nog dugion mangka nilan posolugoy dia sog gulu ni Isus, mangka nilan ion posolugoy nog ponopoton nog molugdom kopulaan non ");
INSERT INTO suc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","mangka nilan ion pogwanwanoy kobon nilan moktaluꞌ nog, “Mololaki le, og datuꞌ nog gotow Hudyuanan koni!” Mangka nilan ion pogdopiꞌoy. ");
INSERT INTO suc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Si Pilatu linumiu nosop mangka poktaluꞌ sog gotow Hudyuanan koyon nog, “Tontong niu! Oiton ku ion lumiu bagun niu kosunan nog daꞌidun og salaꞌ nog mitongow u dianon.” ");
INSERT INTO suc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Dadi, inoit non lumiu si Isus nog poglogdoy nog ompula nog pokpomangyuꞌ nog bolagon kituꞌ nog dugion. Miktaluꞌ si Pilatu dianilan nog, “Koni na og gotow kituꞌ!” ");
INSERT INTO suc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dangan mitongow nog mokokotas koyon nog boliananan bu og polongipatanan nog Baloy nog Poktomuyan si Isus, mikpoglogapis ilan nog, “Kudus niu ion! Kudus niu ion!” Sokaliꞌ tinumabal si Pilatu, “Amu na og kudus dianon poꞌ bila akon da, daꞌ u ion kotongowoy nog salaꞌ non.” ");
INSERT INTO suc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Dadi, miktaluꞌ og gotow Hudyuanan koyon dianon nog, “Bila unuton og botad nami, og gotow koyon sumboy bunuꞌon poꞌ ondaꞌ non unutoy og botad. Miktaluꞌ ion nog ion dow og Bataꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Dangan midongog ni Pilatu og maꞌ nion koyon, migdungag ion kondokan. ");
INSERT INTO suc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bu sinumolod ion mokpuliꞌ mangka non sakoy si Isus nog, “Ain ka dodaꞌ buan miktidu?” Tibua, ondaꞌ tabal si Isus. ");
INSERT INTO suc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Miktaluꞌ nosop si Pilatu dianon, “Iduma ondiꞌ mu ma akon tobalon? Daꞌ mu taꞌ kosunoy nog ongon og bayaꞌ u mokpoluas dianika otawaka kumudus dianika?” ");
INSERT INTO suc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tibua, tinumabal si Isus nog, “Daꞌidun bosia og bayaꞌ nika dianakon somoꞌ daꞌ a bogoyoy nog bayaꞌ tidu sog Mikpongon. Tibua, og gotow kituꞌ nog minuakil dianakon dianika, labi pa kobogat og dusa non dia sog dusa mu.” ");
INSERT INTO suc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dangan midongog ni Pilatu og maꞌ nion koyon, minontong ion nog pondayan dun bagun non bosia ompoluas si Isus. Tibua, mikpoktaluꞌ og gotowanan nog mosikad nog, “Bila poluason mu og gotow koyon, konaꞌ a buan og glokole ni Sisar, poꞌ og gotow nog moktaluꞌ nog ion og datuꞌ, mikopongantu ion dia ni Datuꞌ Sisar.” ");
INSERT INTO suc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Dangan midongog ni Pilatu og taluꞌ koyon, inoit non lumiu si Isus mangka ion ingkud sog gingkudan nog polongukum nog dituꞌ sog glomalomaan nog batu, nog iningolanan dia sog ponoluꞌon nog Hinibru, og Gabata. ");
INSERT INTO suc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Og gondow koyon, mogbolomaꞌ tibua, ion non na og ginang nilan kituꞌ nog iningolanan og Liniusan, bu daliꞌ na og glotuondow. Miktaluꞌ si Pilatu dianilan nog, “Koni na og datuꞌ niu.” ");
INSERT INTO suc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tibua, mikpoglogapis ilan nog, “Awaꞌ niu dion! Awaꞌ niu dion! Kudus niu ion!” Sinakan ilan ni Pilatu nog, “Moleg amu dotaꞌ nog kuduson og datuꞌ niu?” Tinumabal og mokokotas nog boliananan koyon nog, “Daꞌidun lual og datuꞌ nami lual da dia ni Datuꞌ Sisar!” ");
INSERT INTO suc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dadi, tinugdak ni Pilatu si Isus dianilan bagun nilan ion mokudus. Dadi, pinitang nog sundaluanan koyon si Isus. ");
INSERT INTO suc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Bu pipisanan nilan ion nog kudus mangka ilan gonat posunguꞌ sog bonua koyon nog ngalan non, og Bakuk nog Gulu. Sog ponoluꞌon nog Hinibru og ngalan non Golgota. ");
INSERT INTO suc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tubus nituꞌ, linansang nilan si Isus sog kudus. Bu ongon dosop duaꞌ kotow og kinudus nilan. Og sala kotow dia dapit sog glintu non bu og sala kotow dia dapit sog bibang non. Dia ion mibonaꞌ sog titongaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ongon og sinulat ni Pilatu nog pitapok nilan dia sog kudus ni Isus. Og maꞌana nog sinulat kituꞌ mamaꞌ nini, “Si Isus og Gotow Nasaret, og Datuꞌ nog Bansa Hudyu”. ");
INSERT INTO suc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Modakol og gotow Hudyuanan og mikobasta dun poꞌ og kinudusan kituꞌ dianon molani da dia sog Jerusalem. Og sinulat ni Pilatu kituꞌ sinulat non sog ponoluꞌon nog Hinibru, Linatin, bu ponoluꞌon nog Ginirik. ");
INSERT INTO suc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Dadi, miktaluꞌ og mokokotas nog boliananan kituꞌ dianon nog, “Naꞌ mu sulaton nog ion og Datuꞌ nog Bansa Hudyu, sugaꞌid non, sulat mu nog og gotow koni miktaluꞌ nog ion dow og Datuꞌ nog Bansa Hudyu!” ");
INSERT INTO suc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tinumabal si Pilatu nog, “Ondiꞌ u na sopon og sinulat u koyon.” ");
INSERT INTO suc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Dangan mitubus tibua nog sundaluanan koyon kudusoy si Isus, inalap nilan og ponopoton non mangka nilan pogbobohogiꞌoy sog pat bahagiꞌ poꞌ pat kotow ilan. Inalap nilan dosop og glapis nog glogdoy non kituꞌ nog daꞌidun og sinobotan non poꞌ donsamaꞌ na mamaꞌ nituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Long nilan dun, “Ondiꞌ ta ini bogyangon. Golom ita na poglogindanan bagun ta kosunan bog sima og mokalap dun.” Ion non ini og kotumanan nog sinulat kituꞌ sog Kitab nog, “Pigbobahagiꞌ nilan og ponopoton ku, bu miglogindanan ilan nog glapis nog glogdoy u.” Maꞌ nituꞌ og gininang nog sundaluanan koyon. ");
INSERT INTO suc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Og ginaꞌ ni Isus, bu og gilug nog ginaꞌ non nog glibun, bu si Maria nog kodumanan ni Kleopas, bu si Maria Magdalena, pogindog ilan dituꞌ sog molani nog kudus non koyon. ");
INSERT INTO suc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Dangan mitongow ni Isus og ginaꞌ non bu og sulangguꞌ kituꞌ nog kololaman non tokodoy pogindog dion, tinoluꞌan non og ginaꞌ non nog, “Tiduan sog numun kituꞌ, itung mu na ion nog bataꞌ mu.” ");
INSERT INTO suc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tubus nituꞌ, miktaluꞌ ion dia sog sulangguꞌ non kituꞌ nog, “Tiduan sog numun kituꞌ, itung mu na ion nog ginaꞌ mu.” Dadi, tidu dituꞌ, inusibaꞌ ion nog sulangguꞌ non koyon. ");
INSERT INTO suc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tubus nituꞌ, mitintu na dianon nog, og glam non miinang na, bu bagun motuman og sinulat dia sog Kitab, miktaluꞌ ion nog, “Kinuow u!” ");
INSERT INTO suc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ongon og sibulan dion nog toguꞌan glanggow dion. Bu ongon dosop og ponopoton nog molamit bu kodikpol nog ginugow nilan sog glanggow koyon mangka nilan toguꞌoy sog sung nog panga nog ngalan non og hisop, mangka nilan tokmoꞌoy sog babaꞌ ni Isus. ");
INSERT INTO suc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Dangan ininaman non, miktaluꞌ ion, “Midoksuꞌ na.” Tubus nituꞌ, minakung ion bu kotoktus. ");
INSERT INTO suc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Og gondow koyon og Gondow nog Poksimpan. Mogbolomaꞌ ion, og Gondow nog Pogulali bu og tolipunan nog Liniusan. Og gondow koyon og bololagaꞌ tokodoy sog Hudyuanan. Dadi, og kounutananan nog bansa Hudyu, ompok ilan nog ain kinudus kituꞌ ombagak og glawasanan nilan dia sog kudus sog gondow koyon. Dadi, pigbubut nilan dia ni Pilatu nog pomoliꞌon nilan og botisanan og gotowanan koyon nog kinudus mangka nilan siꞌoy potukpaoy. ");
INSERT INTO suc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Dadi, inangoy pomoliꞌoy nog sundaluanan koyon og botisanan nog pingudus kituꞌ dia sog duaꞌ mogimpang kilidan ni Isus. ");
INSERT INTO suc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tibua, dangan mitongow nilan nog minatoy na si Isus, daꞌ nilan na boliꞌoy og botis non. ");
INSERT INTO suc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sugaꞌid non, linaduk nog sala kotow sundalu kituꞌ og kilid ni Isus nog bugyak non. Sododuꞌun mibuyus og duguꞌ bu tubig tidu sog gangol non. ");
INSERT INTO suc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Og gotow kituꞌ nog mikotongow nini inuksugan non, bu og guksugan non motud. Bu kisunan non nog og piktaluꞌ non koni motud. Bu saꞌan ituꞌ tinoksiꞌan non bagun amu dosop tumud dun. ");
INSERT INTO suc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Saꞌan miinang nog maꞌ nini, bagun da motuman og sinulat kituꞌ dia sog Kitab nog, “Daꞌidun og ombaliꞌ nog tulan non solabuk siꞌoy.” ");
INSERT INTO suc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bu sinulat dosop sog Kitab nog, “Og gotowanan kituꞌ, pogbontayan nilan ion nog linaduk nilan og kilid non.” ");
INSERT INTO suc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tubus nituꞌ, si Jusep og gotow Arimatea, inangoy non pongonioy dituꞌ ni Pilatu og bangkoy ni Isus. Koni ni Jusep, daꞌ pokpotampal nog ion siꞌoy og sulangguꞌ ni Isus poꞌ mondok ion dia sog kounutananan nog bansa Hudyu. Tinugdak ni Pilatu dianon. Dadi, inangoy non owaꞌoy og bangkoy ni Isus kituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Duaꞌ ilan ni Nikudimus. (Ion non og gotow kituꞌ nog minangoy dituꞌ ni Isus nog gobi.) Migoit ion nog pogomut nog pigampuꞌ non og mira bu alu. Og pogomut koyon ongon bayuꞌ moglamlam pat puluꞌ bu lima kilu og bogat non. ");
INSERT INTO suc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inalap nilan og bangkoy ni Isus mangka nilan pomogomutoy bu putusoy nog ponopoton nog omputiꞌ poꞌ mamaꞌ nituꞌ og botad nog gotow Hudyu. ");
INSERT INTO suc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sog molani nog kinudusan koyon dia ni Isus, ongon og pigimulanan nog kayu dion. Ongon dituꞌ og bogu imungoy nog globong dia sog pampang nog daꞌ pa sibon lobongoy. ");
INSERT INTO suc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sabap sog gondow kituꞌ nog og Gondow nog Poksimpan, nog mogbolomaꞌ tibua og Gondow nog Pogulali, dituꞌ nilan na linobong si Isus poꞌ molani da. ");
INSERT INTO suc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dangan minatong og gondow nog Duminggu, daliꞌ ondow pa, minangoy na si Maria Magdalena dituꞌ sog globong ni Isus. Mitongow non nog miawaꞌ na og batu kituꞌ nog piktimpong sog globong koyon. ");
INSERT INTO suc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Dangan mitongow non ion, ginumobok ion posunguꞌ dituꞌ ni Simun Piter bu sog sulangguꞌ kituꞌ nog kololaman ni Isus tokodoy mangka ion poktaluꞌ nog, “Inawaꞌ nilan og bangkoy nog Kounutan ta dia sog linobongan kituꞌ dianon bu diꞌ nami kosunan bog ain nilan na ion tinaguꞌ!” ");
INSERT INTO suc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dadi, si Piter bu sala kotow sulangguꞌ kituꞌ, migdaliꞌdaliꞌ ilan mangoy sog globong kituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ginumobok ilan posunguꞌ dituꞌ. Tibua, og sala kotow kituꞌ kiunanan non si Piter. Dadi, mikuna ion matong dituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Sinolip non og globong kituꞌ, tibua, daꞌ ion solod. Mitongow non og saput ni Isus dion. ");
INSERT INTO suc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Dangan sop minatong si Simun Piter, miglandan ion sumolod sog globong koyon bu mitongow non dosop og saput ni Isus koyon. ");
INSERT INTO suc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Bu og saput non koyon nog linibod dia sog gulu non, migusoyusoy molupiꞌ bu misiboy dia sog saput non kituꞌ nog pinutus dia sog glawas non. ");
INSERT INTO suc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Og duma ni Piter kituꞌ nog mikuna matong dion, sinumolod dosop. Dangan mitongow non og glam non koyon, tinumud ion dun. ");
INSERT INTO suc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Daꞌ nilan pa kosabut nog ion non na ini og sinulat kituꞌ dia sog Kitab nog sumboy motubuꞌ si Isus mokpuliꞌ tidu matoy.) ");
INSERT INTO suc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tubus nituꞌ, minuliꞌ ilan na. ");
INSERT INTO suc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Si Maria, dituꞌ ion pogindog sog glowasan nog globong koyon kobon non moksogow. Minombaꞌ ion mangka non solipoy og globong koyon. ");
INSERT INTO suc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Gomonsunoy pa mitongow non og duaꞌ buk og moloikatanan nog miglinumbus nog putiꞌ pogingkud ilan dia sog bakas binotangan nog bangkoy ni Isus. Og solabuk dia dapit sog gulunanan non bu og solabuk sop dia dapit sog sikwayan non. ");
INSERT INTO suc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bu miksak ilan dia ni Maria nog, “Ibun, iduma ion moksogow a ma?” Tinabal ilan ni Maria nog, “Inalap nilan og bangkoy nog Kounutan ku bu diꞌ u kosunan bog ain nilan ion tinaguꞌ.” ");
INSERT INTO suc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tubus non ini toluꞌoy, linumingoy ion bu mitongow non si Isus pogindog dion. Tibua, daꞌ non kilolaoy bog si Isus taꞌ ituꞌ. ");
INSERT INTO suc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Dadi, miktaluꞌ si Isus dianon, “Ibun, olo og poksogowon mu koyon? Sima og pokponontongon mu?” Baluꞌ ni Maria dun og duma non koni mogabitabit og polongipat nog pomulananan koyon dion. Saꞌan ituꞌ tinoluꞌan non ion nog, “Sir, bila ika og minawaꞌ nog bangkoy non kituꞌ dini, posun mu pa dianakon bog ain mu ion tinaguꞌ poꞌ ongoyon ku olapoy.” ");
INSERT INTO suc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sinabi ion ni Isus nog, “Maria!” Dadi, sinumunguꞌ ion ni Maria mangka poktaluꞌ nog ponoluꞌon nog Inaramaik nog, “Raboni!” (Somoꞌ ita da, Polopanad.) ");
INSERT INTO suc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Miktaluꞌ si Isus nog, “Naꞌ mu akon pogoidan poꞌ daꞌ u pa pokpuliꞌ mangoy dituꞌ sog Gamaꞌ u. Sugaꞌid non, angoy a dituꞌ sog pigilugananan ku mangka mu pogobitoy dianilan nog akon, mokpuliꞌ u pa dituꞌ sog Gamaꞌ u nog ion Gamaꞌ niu dosop bu dituꞌ sog Diwata u nog ion Diwata niu dosop.” ");
INSERT INTO suc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dadi, mipanow si Maria Magdalena mangka non pogobitoy dia sog sulangguꞌanan ni Isus nog mitongow non na og Kounutan nilan. Sinuksugan non dianilan og tinaluꞌ ni Isus kituꞌ dianon. ");
INSERT INTO suc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Dangan miglogobi nog Duminggu, miglumpuk og sulangguꞌanan ni Isus sog solabuk baloy bu mimintuꞌ ilan nog mahatul poꞌ mondok ilan nog kounutananan nog bansa Hudyu. Gomonsunoy pa tinumuaꞌ si Isus, pogindog dia sog titongaꞌ nilan mangka ion poktaluꞌ nog, “Potiknaꞌ niu og pomikilan niu.” ");
INSERT INTO suc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tubus nion, pitongow non og komotanan non bu og kilid non. Sabap sog kopokpotongow nog Kounutan nilan koyon dianilan, migdaꞌdaꞌ ilan tokodoy dun. ");
INSERT INTO suc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Bu miktaluꞌ si Isus mokpuliꞌ dianilan nog, “Potiknaꞌ niu og pomikilan niu. Poponowon ku amu domikian da mamaꞌ nog kopokpopanow nog Gamaꞌ u dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Puꞌun miluksad og taluꞌ non koyon, inoyupan non ilan nog ginawa non mangka ion poktaluꞌ nog, “Tabuk niu og Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bila ompunan niu og dusaanan nog minsan sima otowoy, ompunan dosop nog Mikpongon. Tibua, bila ondiꞌ niu ompunan, ondiꞌ dosop ompunan nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Sog kopokpotongow ni Isus kituꞌ dia sog sulangguꞌanan non, og sala kotow sog sopuluꞌ bu duaꞌ sulangguanan non ondaꞌ ion dituꞌ. Og ngalan non si Tomas nog koduaꞌ ngalan non gapid. ");
INSERT INTO suc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Dadi, tinaluꞌ dianon nog pakasi sulangguꞌanan non nog, “Mitongow nami og Kounutan ta!” Tibua, tinumabal si Tomas nog, “Bila diꞌ u da motongow bu mokikap og glinonsangan dia sog komot non mangka u losukoy og kilid non, ondiꞌ u nododaꞌ tumud dun.” ");
INSERT INTO suc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pitu gobi golot non, mikpoglumpuk nosop og sulangguꞌanan ni Isus bu si Tomas dion. Mimintuꞌ ilan nosop nog mahatul. Tibua, mamaꞌ nituꞌ siꞌoy, gomonsunoy pa tinumuaꞌ nosop si Isus nog pogindog dia sog titongaꞌ nilan mangka poktaluꞌ nog, “Potiknaꞌ niu og pomikilan niu.” ");
INSERT INTO suc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mangka non toluꞌoy si Tomas nog, “Tontong mu og paladanan ku. Bu tuyok mu og komotanan ku bu losuk mu og kilid u. Bu naꞌ a na mogduaꞌduaꞌ, sugaꞌid non, tud a na.” ");
INSERT INTO suc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Miktaluꞌ si Tomas nog, “Ika og Kounutan ku bu og Diwata u.” ");
INSERT INTO suc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Tubus nituꞌ, miktaluꞌ si Isus dianon nog, “Tinumud a taꞌ dianakon poꞌ kobal nog mitongow mu akon? Toluꞌon ku dianika nog popiaon nododaꞌ og gotowanan kituꞌ nog tinumud dianakon minsan siꞌoy ondaꞌ nilan akon kotongow.” ");
INSERT INTO suc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Modakol pa og miinang ni Isus nog kosobuꞌsobuꞌ nog mitongow nog sulangguꞌanan non koyon nog ondaꞌ na sunuꞌoy sumulat dini sog libru koni. ");
INSERT INTO suc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Saꞌan sinulat u ini poꞌ bagun amu tumud nog si Isus, ion og Bataꞌ nog Mikpongon nog ion og Kristu. Bu bila tumud amu dianon, kongonan amu nog kotubuꞌ nog daꞌ kopus non bianan sog ngalan non. ");
INSERT INTO suc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tubus nituꞌ, ongon gondow non, tinumuaꞌ si Isus sog sulangguꞌanan non dia sog goksid nog danow nog Tiberias. Maꞌ nini og bianbian non, ");
INSERT INTO suc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","mangka siꞌoy si Isus pokpotongow dianilan, si Simun Piter, si Tomas nog koduaꞌ ngalan non Gapid, si Nataniel nog gotow Kana nog dituꞌ sog Galili, og gombataꞌ ni Sebedi, bu ongon pa og duaꞌ kotow sulangguꞌanan non nog miglumpuk ilan. ");
INSERT INTO suc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Miktaluꞌ si Simun Piter nog, “Mangoy u pa momokot.” Miktaluꞌ sop og dumaanan non koyon nog, “Mogunut ami.” Dadi, tinumulak ilan mangka ilan pomokot sog gobi koyon. Tibua, daꞌidun og galap nilan. ");
INSERT INTO suc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Miksisolom bonua, si Isus dia pogindog sog goksid nog danow koyon. Tibua, ondaꞌ nilan ion kilolaoy. ");
INSERT INTO suc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Miktaluꞌ si Isus dianilan nog, “O le, mikalap amu dotaꞌ da?” Tinumabal ilan nog, “Ondaꞌ, le.” ");
INSERT INTO suc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Sokaliꞌ miktaluꞌ si Isus nog, “Labuꞌ niu sog dapit glintu nog bolangoy niu og pokot niu koyon bu mokalap amu.” Dadi, linabuꞌ nilan dodaꞌ og pokot nilan koyon. Bu dangan binotong nilan, og pokot nilan koyon ondaꞌ nilan kodag poꞌ kobal nog landuꞌ kodakol nog sodaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Dadi, og sulangguꞌ non kituꞌ nog kololaman non tokodoy miktaluꞌ dia ni Piter nog, “Og Kounutan ta loꞌ ion!” Puꞌun midongog ion ni Simun Piter, sinolug non mogdayun og glogdoy non kituꞌ nog linuas non mangka okpu dia sog tubig bu langoy posunguꞌ sog goksid. ");
INSERT INTO suc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bu og dumaanan non nog mibagak sog bolangoy koyon, mikposoksid ilan kobon nilan moktundan nog pokot nilan koyon nog miponuꞌ nog sodaꞌ. Ondiꞌ ilan da ilakad kodibabaꞌ. Og glayuꞌ nilan tidu sog goksid ongon bayuꞌ lima puluꞌ dopa. ");
INSERT INTO suc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Dangan dinumongguꞌ ilan, ongon mitongow nilan og baga nog gapuy nog piktitiꞌan nog sodaꞌ. Bu ongon dosop og pan dion. ");
INSERT INTO suc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Sokaliꞌ miktaluꞌ si Isus, “Pokpitang amu nog sodaꞌ koyon nog kolapoy niu pa dun.” ");
INSERT INTO suc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dadi, minangoy si Simun Piter sog bolangoy nilan mangka non botongoy sog goksid og pokot koyon nog miponuꞌ nog mokoligon nog sodaꞌ. Sogatus bu lima puluꞌ bu tolu og dakol non. Tibua, minsan maꞌ nituꞌ siꞌoy og dakol non, ondaꞌ da kobogyang og pokot nilan koyon dun. ");
INSERT INTO suc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Miktaluꞌ si Isus dianilan nog, “Angoy amu dini, kuman ita niu.” Daꞌidun sog sulangguꞌanan non koyon ginumiluꞌ moksak dianon bog sima ion poꞌ kinilolaan nilan na nog ion dodaꞌ og Kounutan. ");
INSERT INTO suc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Inalap ni Isus og pan kituꞌ mangka non pogbobohogiꞌoy dianilan. Iniling non dosop maꞌ nituꞌ og sodaꞌ. ");
INSERT INTO suc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Koyon og kotolu kali ni Isus mokpotongow dia sog sulangguꞌanan non tidu ion potubuꞌon. ");
INSERT INTO suc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mitubus ilan kuman, miktaluꞌ si Isus dia ni Simun Piter nog, “Ika, Simun, og bataꞌ ni Jan, molalam a taꞌ dianakon labi pa sog duma?” Tinumabal si Piter nog, “Oꞌo, Kounutan ku, kisunan mu nog molalam u dianika.” Dadi, miktaluꞌ si Isus dianon nog, “Pogusibaꞌ mu loꞌ buan og natianan nog bilibilianan ku.” ");
INSERT INTO suc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pinuliꞌan nosop ni Isus moksak dianon nog, “Ika, Simun, og bataꞌ ni Jan, molalam a taꞌ dianakon?” Tinumabal nosop si Piter nog, “Oꞌo, Kounutan ku, kisunan mu nog molalam u dianika.” Dadi, miktaluꞌ si Isus dianon nog, “Pogusibaꞌ mu loꞌ buan og bilibilianan ku.” ");
INSERT INTO suc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sog kotolu kali moksak ni Isus dianon nog, “Ika Simun, og bataꞌ ni Jan, molalam a taꞌ dianakon?” Kisokitan si Piter dun, poꞌ tolu kali non na poguliꞌuliꞌoy moksak dianon nog, “Molalam a taꞌ dianakon.” Dadi, tinumabal si Piter dianon nog, “Kounutan, kisunan mu og glam non. Kisunan mu dosop nog molalam u dianika.” Dadi, tinoluꞌan ion ni Isus nog, “Pogusibaꞌ mu og bilibilianan ku. ");
INSERT INTO suc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Toluꞌon ku dianika, sog kobon nog bataꞌ a pa, poponopotan mu og dili glawas mu bu mogangoy a sog ain kolegan mu. Tibua, bila mogulang a na, mogdopa a bu len gotow na og malud dianika mangka nilan ika oitoy sog ain kopokan mu kituꞌ mangoy.” ");
INSERT INTO suc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Saꞌan tinaluꞌ ini ni Isus poꞌ bagun kosunan ni Piter bog olo og bianbian non matoy, bu sabap dion ompotas og Mikpongon dun. Tubus nituꞌ, tinoluꞌan ion ni Isus nog, “Pogunut a dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Dangan linumingoy si Piter, mitongow non og sulangguꞌ kituꞌ nog kololaman ni Isus tokodoy nog migunut dianilan. (Ion non og linumodis kituꞌ dia ni Isus sonuk nilan moglobungan mangka poksak nog, “Kounutan, sima og mongulaꞌat kituꞌ dianika?”) ");
INSERT INTO suc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Dangan mitongow ni Piter ion, miksak ion dia ni Isus, “Kounutan, og gotow buan konia, olo sop og kobianbianan non?” ");
INSERT INTO suc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tinabal ion ni Isus nog, “Bila moleg u nog motubuꞌ ion asta sog mokpuliꞌ u dini, olo ma og dianika dun? Sugaꞌid non, ika, pogunut a dianakon.” ");
INSERT INTO suc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sabap dituꞌ, mipulonag og dongogan dia sog pigilugananan nog og sala kotow og sulangguꞌ koyon nog diꞌ na ion matoy. Tibua, ondaꞌ da poktaluꞌ si Isus nog ondiꞌ na ion matoy. Sugaꞌid non, tinaluꞌ non tibua nog, “Bila moleg u nog ondiꞌ ion na matoy asta sog mokpuliꞌ u, olo ma og dianika dun?” ");
INSERT INTO suc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ion non ini og sulangguꞌ kituꞌ nog mikotaksiꞌ nog glam nini. Bu ion og sinumulat nini. Bu kisunan nami nog og pinoksiꞌan non kituꞌ motud. ");
INSERT INTO suc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Modakol pa og gininang ni Isus, tibua, ondaꞌ na sulatoy. Poꞌ bila sulaton pa og glam non, gomonsunoy ondiꞌ mugat dia sog gliwag nog dunya koni og sinulatan koyon dun.");
INSERT INTO suc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Sog tagnaꞌ libru u kituꞌ, Teopilus, sinulat u paꞌali sog glam nog kohinangan bu og pianad ni Isus, nog tidu pa sog tolipunan, ");
INSERT INTO suc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","asta sog gondow kituꞌ nog pitolabang ion dituꞌ sog glangit. Mangka siꞌoy ion tolobangoy, bianan sog Bolakat nog Mikpongon, mimilin ion dia sog sosuguꞌonanan non kituꞌ nog piniliꞌ non. ");
INSERT INTO suc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Poꞌ tidu ion potubuꞌon tidu matoy, sog solod nog pat puluꞌ ondow, tatap pa ion mokpotongow dianilan bu modakol og pitongow non dianilan bagun motintu og tud nilan nog ion mitubuꞌ dodaꞌ puliꞌ. Mikpotongow ion dianilan bu pimolian non ilan paꞌali sog pigdotuꞌan nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Dadi, sog solod nog pat puluꞌ ondow kituꞌ, ngon gondow non nog sonuk nilan kuman, mimilin si Isus dianilan nog, “Naꞌ amu mawaꞌ sog koliwagan bonua koni nog Jerusalem, sugaꞌid non, bogadoy niu pa og bogoy nog pinasad nog Gamaꞌ u kituꞌ nog tinaluꞌ u na sibon dianiu.” ");
INSERT INTO suc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Poꞌ si Jan, mimunyag bianan sog tubig. Tibua, sog gunanunan koyon og Bolakat na nog Mikpongon og bunyagon dianiu. ");
INSERT INTO suc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Dangan miglumpuk ilan nosop, miksak ilan dia ni Isus nog, “Kounutan, oksudon mu notaꞌ mokpuliꞌ numun koni nog maꞌ nog kobon nituꞌ og bansa ta nog Hudyu nog mogdatuꞌ mokpuliꞌ?” ");
INSERT INTO suc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tinabal ilan ni Isus nog, “Og Gamaꞌ u da og moto mogbayaꞌ nog timpu, diꞌ ini pokposun dianiu. ");
INSERT INTO suc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tibua, bogayan amu da nog tunung bila tosopan amu na nog Bolakat nog Mikpongon. Bu amu na mimung nog monaksiꞌ dianakon dini sog Jerusalem, bu sog gliwag nog Judia, bu sog gliwag nog Samaria, bu asta sog gliwag nog glupaꞌan.” ");
INSERT INTO suc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Dadi, dangan miluksad tibua og taluꞌ ni Isus koyon, piiknat ion sog gawang mangka ion lumpakoy nog ginampol bu milingod na ion dia sog tinontongan nilan kobal nog ginampol kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sintak nilan moktongal dia sog kitolopan ni Isus koyon, gomonsunoy pa ngon og duaꞌ kotow pogindog sog molani nilan nog minapot ilan nog putiꞌ mangka poktaluꞌ dianilan nog, ");
INSERT INTO suc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Amu, gotow Galili, olo pogindogon niu koyon dini kobon niu moktongal sog glangit? Si Isus, inawaꞌ siꞌoy dianiu bu pitolabang dituꞌ sog glangit, mokpuliꞌ da ion dini maꞌ da nog kotongow niu kituꞌ dianon.” ");
INSERT INTO suc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Dadi, minuliꞌ og sosuguꞌonanan ni Isus koyon dituꞌ sog Jerusalem tidu sog bulud koyon nog Olibu. Og glayuꞌ non tidu sog Jerusalem sala kilumitru. ");
INSERT INTO suc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Dangan minatong ilan sog Jerusalem, migdangan ilan sog ditas sog koduaꞌ lingkat nog baloy sog dugu kituꞌ nog dinokunan nilan. Glam nilan, dion na. Si Piter, si Jan, si Jems, si Andriu, si Pilip, si Tomas, si Bartolomi, si Matias, si Jems og bataꞌ ni Alpius bu si Simun, og omboluꞌ kituꞌ tumindog nog salu bansa non. Tubus nion, si Judas og bataꞌ ni Jems og sangoy non og bataꞌ ni Alpius kituꞌ nog si Jems. ");
INSERT INTO suc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bu dion ilan kobon non pogyakin bu asta og kolibunanan kituꞌ nog dumaanan ni Maria og ginaꞌ ni Isus bu asta og pigilugan non. ");
INSERT INTO suc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dadi, daꞌ kobon golot non, miglumpuk ilan nosop mokpuliꞌ dituꞌ. Bu og dakol nog pigilugananan sog tanud dion sogatus bu duaꞌ puluꞌ kotow. Si Piter minindog sog titongaꞌ nilan mangka ion poktaluꞌ dia sog glam nilan koyon. ");
INSERT INTO suc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ati pigilugan ku, maꞌ nini. Sumboy motuman og tinaluꞌ nog Mikpongon nog sinulat dia sog Kitab. Og taluꞌ nog Bolakat non koyon pibian dia ni Apuꞌ Dabid kobon nituꞌ paꞌali dia ni Judas nog ion minuluꞌ dia sog gotowanan kituꞌ nog minukpaꞌ dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si Judas og duma ta da bosia. Poꞌ ion piniliꞌ dosop bosia ni Isus nog dumuma dia sog ginang ta koni.” ");
INSERT INTO suc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Og tindanan kituꞌ dia ni Judas sog ginang non kituꞌ nog molaton, piksaluy non nog glupaꞌ nog ion non ion og kikoloban non kituꞌ nog mibogyang tian non dun nog boyaꞌan mibuyus og tene non. ");
INSERT INTO suc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Dadi, dangan migdongogan ion sog Jerusalem, og glupaꞌ koyon iningolanan nilan nog Akeldama. Somoꞌ ita da og Glupaꞌ nog Duguꞌ.) ");
INSERT INTO suc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Taluꞌ ni Piter dun paꞌali dia ni Judas nog, “Poꞌ sinulat dia sog libru nog Salmu, nog maꞌ nini, ‘Bolongon na og pogonongan non koyon bu daꞌidun na og mogonong dun.’ Bu sinulat dosop maꞌ nini, ‘Gontiꞌan nog len gotow og polosukuꞌan non.’ ");
INSERT INTO suc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Dadi bila maꞌ nituꞌ, sumboy momiliꞌ ita nog gantiꞌ ta dia ni Judas. Og pomiliꞌon ta ain og duma ta kituꞌ mogunutunut dia ni Isus ");
INSERT INTO suc_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","nog tidu pa sog kobunyag ni Jan kituꞌ dianon, bu asta sog kopoktolabang non tidu dini nita asta sog glangit. Sumboy maꞌ nituꞌ og kopomiliꞌ ta dun poꞌ bagun mokoduma dianita tumaksiꞌ nog si Isus pitubuꞌ dodaꞌ puliꞌ tidu matoy.” ");
INSERT INTO suc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Dadi, ngon og duma nilan dion duaꞌ kotow si Matias bu si Jusep. Og Jusep koni, koduaꞌ ngalan non, si Barsabas bu iningolanan dosop ion si Justus. ");
INSERT INTO suc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tubus nituꞌ, migyakin ilan nog maꞌ nini, “Kounutan, kosunan mu og dialom pikilan nog glam nog gotowanan. Potampal mu pa dianami bog sima sog duaꞌ kotow koni og kolegan mu nog ");
INSERT INTO suc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mokogantiꞌ dia ni Judas moginang nog polosukuꞌan non kituꞌ nog ion bosia og sosuguꞌon mu. Saka, ginonatan non poꞌ ion pidayun na sog bonua kituꞌ nog ain og pibonaꞌan dianon.” ");
INSERT INTO suc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tubus nituꞌ, mimiliꞌ ilan sog duaꞌ kotow koyon bianan sog moglogindanan. Sokaliꞌ og misugat nog gindanan nilan koyon si Matias. Dadi, og mikogantiꞌ dia ni Judas si Matias bu ion og pigoktub dia sog kosopuluꞌ bu sala nog sosuguꞌonanan ni Isus. ");
INSERT INTO suc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Dangan minatong gondow nog kologyaꞌan nog bansa Hudyuanan kituꞌ nog iningolanan og Pentikos, og glam nog poktanudanan dia ni Isus, miglumpuk ilan dia sog solabuk baloy. ");
INSERT INTO suc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sintak nilan moglumpuk dion, gomonsunoy pa mikodongog ilan nog gonek mamaꞌ nog dogus nog galuꞌ nog mosikad nog miktidu sog glangit bu mipulonag sog dialom nog baloy koyon nog piglumpukan nilan. ");
INSERT INTO suc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bu mikotongow ilan nog mamaꞌ nog gligaꞌ nog gapuy nog migatul sog monala kotow dianilan. ");
INSERT INTO suc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bu glam nilan koyon dion, tinosopan ilan nog Bolakat nog Mikpongon. Bu glam nilan koyon, mikpoktaluꞌ ilan nog miglologinis nog ponoluꞌon nog daꞌ nilan sibon konadoy. Bu og ponoluꞌon nilan koyon, og Bolakat nog Mikpongon og mikpotaluꞌ dun dianilan. ");
INSERT INTO suc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sog koliwagan bonua nog Jerusalem koyon, modakol og Hudyuanan dion nog polotanud nog miktidu sog ainain nog bonua. ");
INSERT INTO suc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Dangan midongog nilan og gonek nog gotowanan koyon dion sog baloy koyon, minangoy ilan mokinongog dun. Dangan minatong ilan dituꞌ, kisobuꞌan ilan poꞌ monala kotow dianilan, midongog nilan og dili ponoluꞌon nilan nog piktaluꞌ nog gotowanan koyon dion. ");
INSERT INTO suc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Dadi, miksinaksakoy ilan nog, “Konaꞌ taꞌ og mikpoktaluꞌ koyon og gotow Galilianan? ");
INSERT INTO suc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Olo gidoy migandun dun nog modongog ta ma dianilan og dili ponoluꞌon ta? ");
INSERT INTO suc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Og glam ta koni dini, diadia ita mikpoktidu nog bonua, sog Partia, sog Midia, sog Ilam. Bu ngon dosop mikpoktidu dituꞌ sog bonua nog Misopotamia, sog Judia, sog Kapadosia, sog Pontus, bu asta sog Bataꞌbataꞌ Asia. ");
INSERT INTO suc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Bu ngon miktidu sog Prigia, sog Pampilia, sog Ihiptu, bu sog bonua kituꞌ nog molani sog Sirini nog misakup nog Libia. Bu ongon miktidu dosop sog koliwagan bonua nog Roma, ");
INSERT INTO suc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","bu asta konaꞌ Hudyu nog minuliꞌ na sog tanud nog bansa ta Hudyu. Ngon dosop gotowanan nog miktidu sog puluꞌ nog Krit, bu sog Arabia. Og glam ta koni midongog ta dia sog gotow Galilianan koyon og dili ponoluꞌon ta nog piktaluꞌ nilan paꞌali sog kohinangan nog Mikpongon nog kosobuꞌsobuꞌ.” ");
INSERT INTO suc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Dadi, glam nilan dion, kisobuꞌan ilan bu mibabong pikilan nilan dun, kobon nilan moksinaksakoy bog olo maꞌana nini. ");
INSERT INTO suc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tibua, og dumaanan nilan koyon dion, pigwanwan nilan og poktanudanan koyon dia ni Isus kobon nilan moktaluꞌ nog, “E! Og gotowanan koyon mikpoglangu.” ");
INSERT INTO suc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dadi, si Piter bu dumaanan non kituꞌ nog sopuluꞌ bu sala, mikpongindog ilan mangka si Piter poktaluꞌ nog mosikad dia sog glam nog gotowanan koyon dion nog, “Ati maꞌ nini. Glam nog salu bansa u nog Hudyu nog migonong dini sog Jerusalem otawaka ondaꞌ pogonong dini, amoyamoy tokodoy dianiu, pokinongogoy niu mahatul og poktoluꞌon ku koni bog olo og maꞌana non. ");
INSERT INTO suc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Baluꞌ niu dun mikpoglangu ami. Daꞌidun milangu dianami, poꞌ ginongaꞌ monek pa gondow. Konaꞌ pa tang nog ngon molangu. ");
INSERT INTO suc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sugaꞌid non, og maꞌana nog mitongow niu koyon maꞌ nini, ion non ion og taluꞌ nog Mikpongon kituꞌ nog pilatas non dia sog polomolatas non kituꞌ nog si Joel kobon nituꞌ. Maꞌ long nog Mikpongon dun, ");
INSERT INTO suc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Sog matong daliꞌ na bungkas, maꞌ nini og ginangon ku. Potosopon ku og Bolakat u sog glam nog gotow. Dadi, og glibun laki nog ganakapuꞌanan niu mokopomitua nog taluꞌ nog Mikpongon. Og kolitowan koyon, mokotongow ilan nog potongowon ku dianilan. Bu og mokogulang sop nog gotow, ngon og potoginopon ku dianilan. ");
INSERT INTO suc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Minsan siꞌoy og sosoligananan ku, og glibun laki, potosopon ku dianilan og Bolakat u sog tang koyon. Bu mokopomitua ilan na. ");
INSERT INTO suc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Bu potongowon ku sog gotowanan og gingyataꞌanan dia sog glangit bu og siꞌat dia sog glupaꞌan. Tumuaꞌ og duguꞌ bu gapuy bu gobol nog motomuk tokodoy. ");
INSERT INTO suc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Og gondow ondiꞌ na sumilow bu og bulan mimung ompula mamaꞌ nog duguꞌ mangka siꞌoy datong og gondow kituꞌ nog bololagaꞌ tokodoy nog ion non og gondow nog mongukum og Pogbayaꞌ sog glam nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Bu minsan sima og mokitabang bianan sog ngalan nog Pogbayaꞌ, tobangan da ion.’ ");
INSERT INTO suc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Dadi, amu Hudyuanan, pokinongogoy niu mahatul og poktoluꞌon ku koni! Si Isus, og gotow Nasaret kituꞌ, bianan sog ginang non kituꞌ nog kosobuꞌsobuꞌ bu og gingyataꞌanan nog piinang nog Mikpongon dianon, pitampal nog Mikpongon dianiu nog ion miktidu dianon. Kisunan niu da ituꞌ poꞌ amu dili og mikotongow dun. ");
INSERT INTO suc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Og Mikpongon, donsamaꞌ non na kisunan, bu bianan dia sog dili glegan non, inuakil na si Isus dianiu. Bu bianan sog gotowanan kituꞌ nog mokolaton, pibunuꞌ niu ion bianan sog kolansang nilan dianon sog kudus. ");
INSERT INTO suc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tibua, pitubuꞌ da ion nog Mikpongon tidu matoy. Piluas non ion sog sinsaan nog patoy, poꞌ ondiꞌ nododaꞌ mogusoy nog pogboyaꞌan ion nog patoy. ");
INSERT INTO suc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Poꞌ kobon nituꞌ, si Apuꞌ Dabid miktaluꞌ paꞌali dianon nog, ‘Kobon non og Mikpongon, motongow u dia sog molani u. Saꞌan ondiꞌ u mosusa poꞌ kobon non dia ion sog glintu u. ");
INSERT INTO suc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Dadi, saꞌan kobon non mogdaꞌdaꞌ og dialom pikilan ku nog boyaꞌan motaluꞌ u og daꞌdaꞌan ku koni poꞌ minsan siꞌoy matoy u, ngon da og dodomaan ku. ");
INSERT INTO suc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Poꞌ diꞌ mu potiangon og glimukud u dituꞌ sog molimotayan poꞌ diꞌ mu kumboyon moludak og glawas nog sosoligan mu koni nog midulus. ");
INSERT INTO suc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bu pinosun mu dianakon og bianan posunguꞌ sog kotubuꞌ kituꞌ nog daꞌ kopus non. Bu sabap nog diaan ka kobon non sog molani u, miponuꞌ u nog daꞌdaꞌan.’ ");
INSERT INTO suc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Dadi pigilugan, diꞌ u mogalangalang moktaluꞌ dun dianiu, nog og pigolong non koni konaꞌ non dili glawas poꞌ og mokogulang ta kituꞌ nog si Apuꞌ Dabid, miobon na ion matoy bu globong non dion potanan asta numun koni. ");
INSERT INTO suc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tibua, ion og polomolatas nog taluꞌ nog Mikpongon. Dadi, kisunan non og pinasad nog Mikpongon dianon. Poꞌ og pasad bu dunut og sapa nog Mikpongon nog ngon gondow non, og solabuk pangkat ni Apuꞌ Dabid pindogon non mogdatuꞌ nog maꞌ nog kopogdatuꞌ non. ");
INSERT INTO suc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Bu kisunan non dosop bog olo og ginangon nog Mikpongon paꞌali sog solabuk piniliꞌ non kituꞌ nog mogdatuꞌ. Dadi, saꞌan ituꞌ linabit non paꞌali sog kopokpotubuꞌ dianon tidu matoy. “Poꞌ si Isus, daꞌ non nododaꞌ potiangoy og glimukud non dia sog molimotayan bu daꞌ nododaꞌ koludak og glawas non. ");
INSERT INTO suc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dadi, og glam nami koni mokotaksiꞌ nog maꞌ nini koni, nog si Isus pitubuꞌ dodaꞌ nog Mikpongon mokpuliꞌ tidu matoy. ");
INSERT INTO suc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dadi, numun koni, si Isus, piotas na ion dituꞌ sog glintu nog Mikpongon bu mitabuk non na og Bolakat nog Mikpongon nog pinasad kituꞌ nog Gamaꞌ non dianon. Bu Bolakat kituꞌ pitosop non na dianami. Ion non ion og mitongow niu bu midongog niu koyon dianami. ");
INSERT INTO suc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Poꞌ si Apuꞌ Dabid, daꞌ ion poktolabang dituꞌ sog glangit. Saka miktaluꞌ ion nog maꞌ nini, ‘Og Pogbayaꞌ miktaluꞌ dia sog kounutan ku nog, dinian ka ingkud sog glintu u ");
INSERT INTO suc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta imungon ku og bantaanan mu nog gindogan nog botis mu.’ ");
INSERT INTO suc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Dadi, og glam nog gotow Hudyuanan, sumboy kosunan nilan mahatul nog si Isus, og binunuꞌ niu kituꞌ dia sog kudus, ion og inimung nog Mikpongon nog Pogbayaꞌ bu ion dosop og Kristu.” ");
INSERT INTO suc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Dangan, midongog nog gotowanan koyon, misusa ilan tokodoy dun, mangka ilan poksak dia ni Piter bu sog duma sosuguꞌonanan koyon bog olo og pondayan nilan dun? ");
INSERT INTO suc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Dadi, tinabal ilan ni Piter nog, “Sumboy, monala kotow dianiu, moglilaꞌ amu nog dusaanan niu dia sog Mikpongon mangka amu pokpobunyag dia sog ngalan ni Isukristu poꞌ bagun da kompunan og dusaanan niu. Bu kobogayan amu nog bogoy nog ion non ion og Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Poꞌ kituꞌ og pasad nog Pogbayaꞌ nog ion og Diwata ta, sog glam nog sobion non tidu dianita, bu sog glam nog ganakapuꞌanan ta asta sog duma binonsaan.” ");
INSERT INTO suc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pindonsamaꞌ ni Piter tumaluꞌ dianilan. Bu modakol pa og tinaluꞌ non dianilan bagun ilan bosia ondiꞌ tokodoy moglogiling sog gotowanan koyon numun koni nog mokolaton og kohinangan non poꞌ bagun ilan diꞌ mosunuꞌ poliholaꞌoy dun. ");
INSERT INTO suc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ain tinumud nog gustalan non koyon binunyagan ilan. Dadi, migdungag og tinumud dia ni Isus lagaꞌ tolu ngibu kodakol sog sondow koyon. ");
INSERT INTO suc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bu og gotowanan koyon, migapas ilan moglumpuk bu moganad nog pikpanad nog sosuguꞌonanan ni Isus koyon. Bu kobon non daꞌ ilan lotaꞌ mogyakin bu moksolabuk ilan kuman nog Globungan ni Isus. ");
INSERT INTO suc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bu og sosuguꞌonanan koyon, modakol piginang nilan nog kosobuꞌsobuꞌ bu og gingyataꞌanan. Dadi, glam nog gotowanan, kisobuꞌan ilan tokodoy dun. ");
INSERT INTO suc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bu glam nog pigilugan sog tanud, minonayun og kopoksolabuk nilan boyaꞌan nog piksomasomaan nilan og gakodanan nilan. ");
INSERT INTO suc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bu piksaluy nilan og gakodanan nilan mangka nilan pobobohogiꞌoy dia sog pigilugan nilan kituꞌ sog tanud nog ain kilogonan. ");
INSERT INTO suc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bu gondow gondow moglumpuk ilan sog glomalomaan nog Baloy kituꞌ nog Poktomuyan dia sog Mikpongon. Bu moglumpuklumpuk ilan dosop kuman dia sog baloyanan nilan, dunut og daꞌdaꞌan bu kobabaꞌ nog bolotabat nilan. ");
INSERT INTO suc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bu kobon non moksanglit ilan dia sog Mikpongon bu kisuꞌatan og glam nog gotowanan dianilan. Bu gondow gondow, dungagan nog Pogbayaꞌ og dakol nog ain motabang tidu sog dusaanan nilan. ");
INSERT INTO suc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ngon gondow non, ginongaꞌ monog gondow, timpu nog kopogyakin nog bansa Hudyu, si Piter bu si Jan minangoy ilan mogyakin sog Baloy nog Poktomuyan dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ngon og gotow dion og daday nog tidu pa sog kobataꞌ dianon. Bu gondow gondow pokpitangon ion nog gotow dion mangka nilan ion pingkudoy sog molani nog bongawan koyon nog iningolanan nilan nog Molongas, poꞌ monontoliꞌ ion dia sog gotowanan nog ain sumolod dion. ");
INSERT INTO suc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Dangan mitongow non si Piter ilan ni Jan nog posunguꞌ ilan sumolod dion, pingonian non ilan nog sin. ");
INSERT INTO suc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Dadi, pigonglongan nilan og daday koyon mangka poktaluꞌ si Piter nog, “Tontong a dianami.” ");
INSERT INTO suc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dadi, tinumontong dodaꞌ og daday koyon dianilan poꞌ migdodama ion nog bogayan nilan, ");
INSERT INTO suc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","mangka ion toluꞌoy ni Piter nog, “Daꞌidun og gombogoy u dianika nog sin. Tibua, og goktob nog bogoyon ku dianika, bianan sog bayaꞌ nog ngalan ni Isukristu nog ion og gotow Nasaret, pogbuat a na mangka a panow!” ");
INSERT INTO suc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bu dunut pigoidan non og komot non nog glintu bagun ion mokindog. Bu dinumasig mogdayun botis non ");
INSERT INTO suc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","mangka poglandan lumoksu bu mangka pokpanowpanow, bu pogunut dia ni Piter ilan ni Jan sumolod sog glomalomaan nog Baloy nog Poktomuyan kobon non mokpanowpanow dunut pogloksuloksu bu poksanglit dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Dangan mitongow nog glam nog gotowanan koyon dion og piginang nog bakas daday koyon, nog mikpanowpanow kobon non moksanglit ");
INSERT INTO suc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","dia sog Mikpongon, kinilolaan nilan ion mogdayun nog ion non ion og daday kituꞌ nog kobon non monontoliꞌ notibua dia sog molani nog bongawan kituꞌ nog iningolanan nog Molongas. Dadi, pingala nog glam nilan koyon dion bu kisobuꞌan ilan dun bog olo og bianbian non kuliꞌan. ");
INSERT INTO suc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sonuk nog bakas daday koyon mogaid dia ni Piter bu dia ni Jan nog dion nilan pogindog sog iningolanan kituꞌ nog Pogbianan ni Solomon, mikponggobok og gotowanan koyon dion dituꞌ ni loꞌ Piter mangka nilan ion poglumpukoy poꞌ kisobuꞌan ilan tokodoy. ");
INSERT INTO suc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Dangan piglumpukan si loꞌ Piter nog gotowanan koyon dion, migustal ion dianilan nog maꞌ nini, “Amu, salu bansa u nog Israel, iduma kisobuꞌan amu dianon? Bu iduma pogonglongan niu ma ami? Baluꞌ niu dun, kiuliꞌan og daday koyon nog bianan dia sog dili tunung otawaka og kopondiwata nami? Konaꞌ nami mikokuliꞌ dianon, sugaꞌid non, og mikokuliꞌ dun maꞌ nini. ");
INSERT INTO suc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Og mokogulanganan ta kituꞌ kobon nituꞌ nog si loꞌ Abraham, si Isak, bu si Jakub, og Diwata nog piktamuy nilan, piotas non solabuk og sosoligan non kituꞌ nog si Isus. Tibua amu, inuakil niu ion dia sog gotowanan bagun ion bunuꞌon. Minsan siꞌoy poluason na ion bosia ni Pilatu, pigbongkis niu da ion. ");
INSERT INTO suc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pigbongkis niu si Isus nog ion midulus bu daꞌ dusa non. Bu og pigbubut niu nog poluason ni Pilatu dianiu og gotow kituꞌ nog polomunuꞌ. ");
INSERT INTO suc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Og binunuꞌ niu kituꞌ, og poktiduan nog kotubuꞌ. Tibua, pitubuꞌ da ion puliꞌ nog Mikpongon. Bu kitoksiꞌan nami tanan nini. ");
INSERT INTO suc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Dadi, bianan sog bayaꞌ nog ngalan ni Isus, og mikokuliꞌ nog daday koni nog kilolaan niu. Bu sabap sog ngalan non bu og kopongandol kituꞌ nog bianan dianon, mikokuliꞌ mahatul nog daday koni. ");
INSERT INTO suc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Dadi pigilugan, numun kituꞌ kisunan ku nog daꞌ niu kosunoy og piginang niu kituꞌ, amu bu og kounutananan niu kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pidonsamaꞌ na tumaluꞌ nog Mikpongon kobon nituꞌ pibian sog polomolatasanan non kituꞌ nog sumboy og Kristu mosinsa nododaꞌ. Og gininang niu kituꞌ dianon, ion non ituꞌ og kotumanan nog pidonsamaꞌ non kituꞌ tumaluꞌ. ");
INSERT INTO suc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Dadi, tolikudoy niu na og dusaanan niu mangka amu sunguꞌ dia sog Mikpongon bagun da kugasan og glam nog dusaanan niu ");
INSERT INTO suc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","nog boyaꞌan moksud og popia nog Pogbayaꞌ dianiu bu popongoyon non puliꞌ og Kristu nog ion non si Isus. ");
INSERT INTO suc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Poꞌ migbagad pa ion dituꞌ sog glangit asta matong og tang nog pongimboguan nog Mikpongon og glam non. Poꞌ maꞌ nituꞌ og pinasad non kobon nituꞌ bianan dia sog polomolatasanan non kituꞌ nog modulus. ");
INSERT INTO suc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Poꞌ maꞌ nini og tinaluꞌ ni Apuꞌ Muses dia sog bansa Israel kituꞌ kobon nituꞌ nog, ‘Og Pogbayaꞌ nog ion og Diwata niu, ngon gondow non, popongoyon non dia sog ganakapuꞌanan niu og polomolatas nog maꞌ nakon, og salu bansa niu da. Bu glam nog poktoluꞌon non sumboy pokinongogan niu.’ ");
INSERT INTO suc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","“Poꞌ ain og diꞌ mokinongog dianon polenan nilan nog Mikpongon, dia sog pigotowan non, mangka non ilan poliholaꞌoy. ");
INSERT INTO suc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bu maꞌ nituꞌ dosop og piktaluꞌ nog glam nog polomolatasanan non kituꞌ tidu dia ni Apuꞌ Samuel bu asta dia sog ain mikosukpat kituꞌ dianon. Og glam nilan mikpoktaluꞌ ilan paꞌali sog tang koni numun koni. ");
INSERT INTO suc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Dadi, og pasadanan nog Mikpongon kituꞌ nog pilatas nog polomolatasanan non kituꞌ, amu ituꞌ dun. Bu misunuꞌ amu dosop dia sog pinasad non kituꞌ dia sog mokogulanganan niu kituꞌ nog tinaluꞌ non dia ni Apuꞌ Abraham nog, ‘Bianan dia sog pangkat mu, glam nog gotowanan sog glupaꞌan popiaon non.’ ");
INSERT INTO suc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dadi, og Mikpongon, piniliꞌ non bu pipangoy non poguna dianiu og sosoligan non kituꞌ poꞌ popiaon non amu bianan sog kopokpotolikud non dia sog monala kotow dianiu sog kohinangan niu kituꞌ nog mokolaton.” ");
INSERT INTO suc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Dadi, solian ni Piter bu si Jan mogustal, tinuaꞌan ilan nog boliananan nog bansa Hudyu, bu asta kounutan nog polongipatanan nog Baloy kituꞌ nog Poktomuyan dia sog Mikpongon, bu asta dosop og gotowanan kituꞌ tidu sog kampung nog Sadusiu. ");
INSERT INTO suc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Misasow ilan, poꞌ mikpanad og sosuguꞌonanan ni Isus sog gotowanan nog og gotow motubuꞌ tidu matoy, bianan sog kopoktaluꞌ nilan nog si Isus, mitubuꞌ puliꞌ tidu matoy. ");
INSERT INTO suc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Dadi, inukpaꞌan nilan dun si loꞌ Piter ilan ni Jan mangka nilan kolobusuoy poꞌ daꞌ nilan na kotagad ukumoy poꞌ gobi na. ");
INSERT INTO suc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tibua, modakol nog gotow og tinumud, ain og mikodongog nog gustalan ni loꞌ Piter koyon. Og dakol nog tinumabuk dia ni Isus lagaꞌ lima ngibu kotow, daꞌ lakit nog kolibunanan bu gombataꞌanan. ");
INSERT INTO suc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Dangan migbolomaꞌ ion, miglumpuk sog Jerusalem og kounutananan nog bansa Hudyu bu og mokogulanganan bu asta og polopanadanan kituꞌ nog botad nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bu si Anas og kounutan nog boliananan nog bansa Hudyu, si Kaypas, bu og sangoy kituꞌ ni Jan, si Aleksander, bu duma piglogombataꞌanan ni Anas, tinumuaꞌ ilan dosop dion. ");
INSERT INTO suc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dangan milimud ilan na dion, piindog nilan si loꞌ Piter sog sunguꞌan nilan mangka nilan poksumodiaꞌoy. Long nilan dun, “Olo migandun kinang niu nog piginang niu koyon. Ain miktidu og tunung niu koyon, otawaka sima og ngalan nog ginamit niu moginang dun?” ");
INSERT INTO suc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dadi, si Piter nog pinuluꞌan nog Bolakat nog Mikpongon, tinumabal nog, “Amu og mokogulang bu og kobogolalan nog bansa Hudyu, ");
INSERT INTO suc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","bila og poksakon niu dianami paꞌali sog miinang dia sog bakas daday koni nog boyaꞌan kiuliꞌan, ustalon ku dianiu bu sog glam nog bansa Hudyu. Saꞌan kiuliꞌan og daday koni, bianan sog bayaꞌ ni Isukristu nog ion og gotow Nasaret nog binunuꞌ niu kituꞌ sog kudus, tibua, pitubuꞌ ion puliꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Isus, ion og pogolongon kituꞌ sog Kitab nog og batu kituꞌ nog mosolag nog pigbongkis nog polongimung nog baloy nog maꞌ niu. Saka ion tanan og miimung nog landuꞌ kobololagaꞌ nog batu nog polongkapan nog baloy. ");
INSERT INTO suc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Og maꞌana non, ion da mokogawon dia sog gotowanan. Poꞌ sog dibabow nog dunya koni, daꞌidun lual og binogoy nog Mikpongon nog ngalan nog poksobion ta nog mokotabang sog gotowanan tidu sog bayaꞌ nog dusa.” ");
INSERT INTO suc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Dadi, dangan miluksad og taluꞌ ni Piter koyon, kisobuꞌan glam nilan dun poꞌ daꞌ ilan kondok mogustal dun saka sagyaotow ilan da bu ombabaꞌ da og sabut nilan. Tibua, kinilolaan nilan nog ilan koyon og dumaanan nilan ni Isus. ");
INSERT INTO suc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Dadi, daꞌidun og motaluꞌ nilan sog piktaluꞌ ni loꞌ Piter koyon poꞌ og daday koyon nog kiuliꞌan, pogindog sog molani ni loꞌ Piter. ");
INSERT INTO suc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Dadi, piliu pa si loꞌ Piter sog gukum koyon podaliꞌ mangka og bogolalanan koyon pogisunisun. ");
INSERT INTO suc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bu miksinaksakoy ilan bog olo dodaꞌ og dunon nilan dia ni loꞌ Piter kobon nilan moktaluꞌ nog, “Glam nog gotowanan dini sog Jerusalem kosunan nilan nog og gotowanan koyon mikopoginang ilan nog kosobuꞌsobuꞌ nog ombaꞌis tokodoy nog diꞌ ta kobolibadan. ");
INSERT INTO suc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tibua, podanon ta tumaluꞌ dianilan nog diꞌ nilan na puliꞌan moglabit og ngalan ni Isus sog minsan sima poꞌ bagun da ondiꞌ na ompulonag og bontugan nog piginang nilan koyon.” ");
INSERT INTO suc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dadi, dangan midoksuꞌ ilan mogupakat, pisolod nilan puliꞌ si loꞌ Piter mangka nilan podanoy tumaluꞌ dianilan nog diꞌ nilan na puliꞌan moglabit og ngalan ni Isus otawaka mokpanad paꞌali dianon. ");
INSERT INTO suc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tibua, tinabal nilan og bogolalanan koyon nog, “Bila amu, ain gidoy og mosulut dia sog Mikpongon nog unuton nami, og glegan niu koyon otawaka og glegan non? ");
INSERT INTO suc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Poꞌ mologon nami lotaꞌoy mogustal ain og mitongow nami bu og midongog nami kituꞌ nog paꞌali dianon.” ");
INSERT INTO suc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dadi, dangan midongog nilan og tabal ni loꞌ Piter koyon, pinuliꞌan nilan nosop tumaluꞌ dianilan mangka ilan na poluasoy. Poꞌ daꞌidun og bianan nilan mokposakit dia ni loꞌ Piter ilan ni Jan. Poꞌ glam nog gotowanan dion, mikpoksanglit ilan dia sog Mikpongon sabap sog kobianbianan nog daday koyon. ");
INSERT INTO suc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Og daday koyon, mangka siꞌoy kuliꞌoy, og tinonan non labi na pat puluꞌ ton. ");
INSERT INTO suc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Dangan mikoluas ilan na, sokaliꞌ ilan minangoy dituꞌ sog dumaanan nilan, mangka nilan poguksugoy og taluꞌ nog mokokotas nog boliananan bu og kobogolalan kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Dangan midongog nog dumaanan nilan og guksugan ni loꞌ Piter koyon, mikpoglongag ilan mogyakin sog Mikpongon nog, “Apuꞌ Pogbayaꞌ, ika da mikpongon nog pigloban nog glangit bu glupaꞌan bu glam nog piongon. ");
INSERT INTO suc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bu bianan sog Bolakat mu, pilatas mu og taluꞌ mu dia sog sosoligan mu nog si Apuꞌ Dabid nog ion og mokogulang nami kituꞌ kobon nituꞌ. ‘Iduma og binonsaan nog konaꞌ Hudyu mokpogboluꞌ ilan ma? Bu iduma momikil ilan ma nog pikilan nilan koyon nog daꞌ doksuꞌ non? ");
INSERT INTO suc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Poꞌ og kodotuꞌananan sog dunya koni, mikpoksolabuk ilan na bu og kounutananan, mikpoglumpuk ilan ma, poꞌ ontuan nilan og Pogbayaꞌ bu og Tinonduꞌ non kituꞌ Mogdatuꞌ.’ ");
INSERT INTO suc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Motud dodaꞌ, Apuꞌ. Poꞌ si Herod bu si Pontus Pilatu, inupakat nilan og gotow Hudyu bu konaꞌ Hudyu dini sog Jerusalem. Poꞌ inontuan nilan si Isus nog ion daꞌ dusa non, og Tinonduꞌ mu kituꞌ Mogdatuꞌ. ");
INSERT INTO suc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Migupakat ilan moginang nog donsamaꞌ mu na kituꞌ kisunan, bu bianan dia sog glegan bu bayaꞌ mu, ininang nilan dianon. ");
INSERT INTO suc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Dadi, ika og Pogbayaꞌ, kosunan mu da bog olo og sad nilan kituꞌ dianami. Dadi, popagon mu pa og sosoligananan mu koni nog maꞌ nami poꞌ bagun nami kobon non omboluꞌ mogustal nog taluꞌ mu koni. ");
INSERT INTO suc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bu bianan sog bayaꞌ mu, kuliꞌan mu ain og togo mokosakit. Bu tugdak mu pa og ginang kituꞌ nog kosobuꞌsobuꞌ bu og gingyataꞌanan bianan dia sog ngalan ni Isus, og sosoligan mu kituꞌ nog daꞌ dusa non.” ");
INSERT INTO suc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Dangan miluksad tibua og gyakin nilan koyon, mikunduꞌ og baloy koyon, bu glam nilan, pinuluꞌan ilan nog Bolakat nog Mikpongon boyaꞌan miboluꞌ ilan mogustal nog taluꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Og glam nog tinumabuk dia ni Isus miksolabuk og glegan nilan, bu og pikilan nilan, poꞌ daꞌidun dianilan og moglukung gumamit nog dili balan non. Sugaꞌid non, og glam nilan piksomasomaan nilan og gakodanan nilan. ");
INSERT INTO suc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Og sosuguꞌonanan koyon, mokosog ilan tokodoy tumaksiꞌ paꞌali dia sog kotubuꞌ kituꞌ puliꞌ ni Isus. Bu glam nilan landuꞌ og popia nog Mikpongon dianilan. ");
INSERT INTO suc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Bu daꞌidun dianilan og kiondaꞌan. Poꞌ bila ngon dianilan og togo kulang, ngon sop dianilan og moksaluy nog glupaꞌ non otawaka og baloy non. ");
INSERT INTO suc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Bu og saluy non, uokilon nilan dia sog sosuguꞌonanan kituꞌ bu ilan dona og momogoy dun dia sog ain ngon kituꞌ og kulang non. ");
INSERT INTO suc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Dadi, ngon og duma nilan dion nog si Jusep og ngalan non. Bu pingongyuꞌan nog sosuguꞌonanan kituꞌ nog si Barnabas poꞌ og maꞌana nog pongangyuꞌ nilan koyon dianon, polondoloꞌisog. Ion og pangkat ni Apuꞌ Lebi. Bu ion og gotow tidu sog Siprus. ");
INSERT INTO suc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Si Barnabas koni, piksaluy non og sobuntak nog glupaꞌ non. Bu og saluy nog glupaꞌ non kituꞌ, inuakil non sog sosuguꞌonanan koyon. ");
INSERT INTO suc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Bu ngon dosop og pogduoy dion nog si Ananias ilan ni Sapira. Piksaluy nilan dosop og sobuntak glupaꞌ nilan. ");
INSERT INTO suc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Og duma saluy nog glupaꞌ nilan koyon, tinaguꞌ non poꞌ gomiton non sog dili glegan non. Bu og duoy non siꞌoy sinumolabuk dosop dia sog piginang non koyon. Bu og samaꞌ nog saluy nog glupaꞌ nilan koyon, inuakil non dia sog sosuguꞌonanan koyon. ");
INSERT INTO suc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Dadi, dangan inuakil non og sin koyon dianilan, miktaluꞌ si Piter dianon, “Ananias, iduma pitiang mu ma og Soitan mogbayaꞌ dianika nog boyaꞌan kipogloputan mu tanan dun og Bolakat nog Mikpongon? Poꞌ ngon pa og sinamaꞌ niu nog saluy nog glupaꞌ niu kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Og glupaꞌ niu koyon, sog daꞌ niu pa poksaluy, amu da gapuꞌ non. Bu minsan siꞌoy mitubus niu poksaluy, og saluy non amu dosop og gapuꞌ non. Saka olo og mikobal dun? Iduma mikopomikil amu ma moginang nog maꞌ nion koyon? Og pigloputan niu koyon konaꞌ sagyaotow, sugaꞌid non, og Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Dangan midongog ni Ananias og taluꞌ ni Piter koyon, mibuksak ion mogdayun mangka patoy. Bu ain mikodongog nog kibianbianan ni Ananias koyon, kiondokan ilan tokodoy dun. ");
INSERT INTO suc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dangan minatoy si Ananias, inangoy nog kolitowanan koyon putusoy bangkoy non mangka nilan pitangoy lumiu poꞌ lobongon nilan. ");
INSERT INTO suc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tolu oras og gligat non, minatong dion og duoy ni Ananias. Bu migdangan sog baloy koyon nog daꞌ non pa kosunoy bog olo kibianbianan nog glaki non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Dangan sinumolod ion, sinakan ion ni Piter bog maꞌ nituꞌ dotaꞌ da og golagaꞌ nog glupaꞌ nilan kituꞌ? Dadi, tinumabal ion, “Oꞌo, maꞌ nituꞌ da dakol non.” ");
INSERT INTO suc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dadi, tinoluꞌan ion ni Piter, “Iduma miksolabuk ma gupakat niu nog glaki mu nog sulayan niu og Bolakat nog Mikpongon? Dion na og kolitowanan kituꞌ nog linumobong dia sog glaki mu. Bu ika siꞌoy, pitangon nilan dosop ika sog pinitangan nilan nog glaki mu kituꞌ.” ");
INSERT INTO suc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Dangan miluksad tibua taluꞌ ni Piter koyon, mibuksak mogdayun og glibun koyon mangka patoy. Dadi, dangan sinumolod og kolitowanan kituꞌ, mitongow nilan og bangkoy nog glibun koyon. Dadi, inawaꞌ nilan dion mangka nilan ulidoy lumobong dia sog glaki non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Dadi, glam nog pigilugan sog tanud bu glam nog mikodongog nog bianbian nog sala kopogduayan koyon, kiondokan ilan tokodoy dun. ");
INSERT INTO suc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Modakol gininang nog sosuguꞌonanan kituꞌ nog kosobuꞌsobuꞌ. Bu modakol dosop og gingyataꞌanan nog pitongow nilan dia sog kodokolan nog gotowanan. Bu sog tang koyon, glam nog pigilugan sog tanud, kobon non moglumpuk ilan sog glomalomaan nog Baloy nog Poktomuyan dia sog Mikpongon, dia dapit sog iningolanan kituꞌ nog Pogbianan ni Solomon. ");
INSERT INTO suc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Minsan siꞌoy motas og gadab dianilan nog gotowanan, ain konaꞌ nilan batuk poktanud dia ni Isus, mondok mampuꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tibua, minsan maꞌ nituꞌ, glibun laki pododungag da kodakol og tumabuk dia ni Isus nog boyaꞌan kobon kobon non dumakol og polotanudanan. ");
INSERT INTO suc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Dadi, og doksuꞌan nog kohinangan nog sosuguꞌonanan koyon, modakol og diꞌ mokokodag pimitang bu bolilidoy sog pogbolilidan non sog goksid dalan poꞌ bagun da bila mian si Piter dion, kotindungan ilan nog sagya siꞌoy og nuni non. ");
INSERT INTO suc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bu modakol dosop gotowanan dion tidu sog glumibut nog Jerusalem koyon, pimitang nilan ain og diꞌ mokokodag bu og glam nog ain pisinsa nog glatdiwata. Bu glam nilan koyon kiuliꞌan. ");
INSERT INTO suc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Sabap dituꞌ, og kounutan nog boliananan nog Hudyu, bu glam nog dumaanan non koyon nog kampung nog Sadusiu, miksibok ilan tokodoy dun. ");
INSERT INTO suc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Dadi, inukpaꞌan nilan og sosuguꞌonanan koyon mangka nilan kolobusuoy. ");
INSERT INTO suc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tibua, og gobi koyon inangoy nog moloikat nog Mikpongon bukaꞌoy og pintuꞌ nog kolobusuan koyon, mangka non ilan pitangoy lumiu, mangka poktaluꞌ, ");
INSERT INTO suc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Angoy amu indog dituꞌ sog glomalomaan nog Baloy nog Poktomuyan dia sog Mikpongon, mangka niu uksugoy dia sog gotowanan dituꞌ og tibuk nog guksugan paꞌali sog bogu kotubuꞌ koni.” ");
INSERT INTO suc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Dadi, mimilang ilan nog taluꞌ koyon dianilan. Ampun migbukaꞌsiang bonua, sinumolod ilan dion sog glomalomaan nog Poktomuyan koyon mangka ilan poktolipun mokpanad sog gotowanan. Tibua, og kounutan nog boliananan kituꞌ bu dumaanan non, pilumpuk nilan glam nog kobogolalan nog bansa Israel mangka nilan dondagoy sog sundaluanan mangoy og sosuguꞌonanan kituꞌ sog kolobusuan. ");
INSERT INTO suc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Dadi, dangan minatong sundaluanan koyon dituꞌ, daꞌ nilan na kodotongoy dituꞌ og sosuguꞌonanan kituꞌ. Dadi, mikpuliꞌ ilan mangka ilan poguksug nog, ");
INSERT INTO suc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Dangan minatong ami dituꞌ, og kolobusuan kituꞌ kinunsi da. Og sundaluanan, dion ilan pogindog sog sobolaꞌ nog pintuꞌ sog glowasan. Saka dangan binukaꞌ nami, daꞌidun gotow dituꞌ sog dialom!” ");
INSERT INTO suc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dangan midongog nog kounutan nog polongipat nog Baloy koyon nog Poktomuyan, bu og mokokotas nog boliananan koyon, mibabong pikilan nilan poꞌ diꞌ nilan sunan bog olo migandun nog sosuguꞌonanan kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sintak non, ngon sala kotow minatong dion nilan bu miktaluꞌ nog, “Hoy! Og gotowanan kituꞌ nog kinolobusu niu, dituꞌ ilan pogindog sog glomalomaan nog Baloy kituꞌ nog Poktomuyan poꞌ mikpanad ilan dia sog gotowanan.” ");
INSERT INTO suc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dadi, og kounutan nog polongipat nog Baloy kituꞌ nog Poktomuyan, migunut dia sog sundaluanan non mangoy mukpaꞌ nog sosuguꞌonanan kituꞌ. Tibua, daꞌ nilan koposokitoy poꞌ mondok ilan botuon nog gotowanan koyon. ");
INSERT INTO suc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pinitang nilan dia sog sunguꞌan nog gukum nog bansa Hudyu koyon mangka ilan poksumodiaoy nog kounutan nog boliananan koyon nog, ");
INSERT INTO suc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Daꞌ nami taꞌ amu pomagoy mokpanad paꞌali sog ngalan ni Isus? Saka, minsan pimag nami na amu, tinogol niu doma moginang nog boyaꞌan miglop na tanan sog gotowanan dini sog Jerusalem og pikpanad niu koyon. Bu poksipian niu mononsol dianami og kopatoy ni Isus.” ");
INSERT INTO suc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tibua, si Piter bu duma sosuguꞌonanan koyon tinumabal nog, “Golom nami na bilangoy og Mikpongon gabaꞌ nog sagyaotow. ");
INSERT INTO suc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Poꞌ og binunuꞌ niu kituꞌ sog kudus nog si Isus, pitubuꞌ ion puliꞌ nog Diwata nog mokogulang ta kituꞌ kobon nituꞌ nog ion og Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Bu numun kituꞌ, si Isus, piotas na ion nog Mikpongon dia sog glintu non. Moglokounutan na ion bu ion na og polonabang ta poꞌ bagun ain og maꞌ nita nog gotow Hudyu, mokopoglilaꞌ ita nog dusaanan ta bu kompunan ita na dun. ");
INSERT INTO suc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Dadi, ami bu og Bolakat nog Mikpongon og mokotaksiꞌ nog glam non koyon. Bu og Bolakat non koyon, ion non ion binogoy non kituꞌ sog glam nog ain mikokunut dianon.” ");
INSERT INTO suc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Dangan midongog nog polongukumanan og taluꞌ ni Piter koyon, miangit ilan tokodoy dun boyaꞌan nog pobunuꞌ nilan tanan bosia og sosuguꞌonanan koyon. ");
INSERT INTO suc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tibua, ngon sala kotow og parasiu dion og ngalan non si Gomalial. Ion og polopanad nog botad nog bansa Hudyu, bu pogodaban ion nog glam nog gotow. Minindog ion mangka non dondagoy nog poliuon pa podaliꞌdaliꞌ og sosuguꞌonanan koyon ");
INSERT INTO suc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","mangka non toluꞌoy og gukum koyon nog, “Amu, og salu bansa u nog gotow Israel, pongmayaꞌ amu nog inangon niu koyon posunguꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Poꞌ dini kituꞌ, si Tiudas migbaluꞌbaluꞌ nog ion motas nog gotow. Bu pat gatus kotow og minampuꞌ dianon. Tibua, dangan binunuꞌ ion, mikpogulakpalik da og glaꞌayatanan non asta daꞌ na doksuꞌ non. ");
INSERT INTO suc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tubus nituꞌ, sog tang nog koponglista nog gotowanan, ngon nosop tinumuaꞌ nog si Judas, og gotow Galili. Modakol gotow nog migunut dianon nog mantu ilan dia sog pogaid nog botad. Tibua, binunuꞌ dosop ion bu og pigotowan non mikpogulakpalik dosop. ");
INSERT INTO suc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Dadi, numun koni maꞌ nini og pomali u dianiu paꞌali sog gotowanan koyon. Potiang niu ilan bu poluas niu na ilan. Poꞌ bila og ginang nilan koyon tidu da sog sagyaotow, daꞌ da og doksuꞌ non. ");
INSERT INTO suc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tibua, bila og tugyu bu og kohinangan nilan koyon tidu sog Mikpongon, diꞌ amu da mokantu dianilan. Bu gomonsunoy sokaliꞌ niu kobotikoy, og kopongontuan niu og Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Dadi, mioit ilan nog taluꞌ ni Gomalial koyon. Pisolod nilan og sosuguꞌonanan kituꞌ, mangka nilan tibua podanog mangka nilan nosop pomagoy ilan moglabit nog ngalan ni Isus, mangka nilan na poluasoy. ");
INSERT INTO suc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Dadi, og sosuguꞌonanan kituꞌ, ginonatan nilan gukum nog bansa Hudyu koyon. Mikpogdaꞌdaꞌ ilan poꞌ misabut nilan nog kisunan na nog Mikpongon nog patut ilan na moglogaga nog posakit bu posipog koyon dianilan sabap sog kopokokunut nilan dia sog ngalan ni Isus. ");
INSERT INTO suc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tidu dion, gondow gondow, dituꞌ ilan sog glomalomaan nog Baloy kituꞌ nog Poktomuyan dia sog Mikpongon bu moktolopasan nilan sog gimbolayan mokpanad bu mogustal nog Gombaꞌis nog Guksugan paꞌali dia ni Isus nog ion og Kristu. ");
INSERT INTO suc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sog tang kituꞌ nog kobon non pododungag og dakol nog pigotowan ni Isus, ngon dianilan og Hudyuanan nog ponoluꞌon nilan Ginirik. Miksusi ilan nog pakasi poktanudanan dia ni Isus, og Hudyuanan dosop, tibua, og ponoluꞌon nilan Inaramaik. Poꞌ ngon dow balulibunanan dion nog gotow Girik nog kiliusan mogbogoy nog kotubuꞌan kituꞌ nog pomogoyon dianilan gondow gondow. ");
INSERT INTO suc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dadi, og sopuluꞌ bu duaꞌ sosuguꞌonanan kituꞌ, pilumpuk nilan og glam nog poktanudanan dion mangka ilan poktaluꞌ nog, “Pigilugan, diꞌ mogusoy nog onggaꞌon nami og mogustal paꞌali sog taluꞌ nog Mikpongon, mangka nami sunguꞌoy og momogoy nog kotubuꞌan ta koyon. ");
INSERT INTO suc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Sugaꞌid non, pomiliꞌ amu nog dumaanan niu lagaꞌ pitu kotow. Bu sumboy og pomiliꞌon niu, ain kituꞌ nog mosolamin dianilan og polomotadon kituꞌ nog miktidu dia sog Bolakat nog Mikpongon. Bu sumboy dosop og gotowanan kituꞌ nog ompantas og sabut nilan. Poꞌ og ginang koni uokilon nami dianilan ");
INSERT INTO suc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","poꞌ bagun ami tokodoy mokotayow mogyakin bu mogustal paꞌali sog taluꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dadi, misuꞌat dia sog glam nilan og taluꞌ nog sosuguꞌonanan koyon. Dadi, og pimiliꞌ nilan si Esteban poꞌ ion ompagon og kopongandol non, bu kobon non mosolamin dianon og polomotadon kituꞌ nog miktidu dia sog Bolakat nog Mikpongon. Bu pimiliꞌ nilan dosop si Pilip, si Prokorus, si Nikanor, si Timun, si Parmenas, bu si Nikulas. Ion og gotow Antiok nog sakup sog tanud nog Hudyu. ");
INSERT INTO suc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Og pitu kotow koyon, inuakil nilan dia sog sosuguꞌonanan koyon. Dadi, dinoponan bu pigyokinan nilan. ");
INSERT INTO suc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Dadi, og taluꞌ nog Mikpongon kobon kobon non ompulonag. Bu og dakol nog poktanudanan dion sog Jerusalem koyon kobon non pododungag. Bu minsan og boliananan nog bansa Hudyu, modakol na og tinumabuk dun dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Dadi, si Esteban, pipia ion tokodoy nog Mikpongon bu binogayan ion nog tunung, bu modakol og gininang non nog gingyataꞌ nog kosobuꞌsobuꞌ nog pitongow non sog kodokolan nog gotowanan. ");
INSERT INTO suc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Minsan siꞌoy maꞌ nion kolongas og poginangon non, ngon og gotowanan nog sinumusi dianon. Og gotowanan koyon, miktidu ilan sog baloy nog poglumpukan nog bansa Hudyu nog iningolanan nog baloy nog poglumpukan nog ain miluas na tidu sog kouliponan. Ilan koyon og Hudyu nog miktidu sog koliwagan bonua nog Sirinia, bu sog koliwagan bonua nog Aleksandria, bu ngon dosop miktidu sog probinsia nog Silisia, bu asta sog Bataꞌbataꞌ Asia. ");
INSERT INTO suc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tibua, diꞌ ilan mokantu dia ni Esteban poꞌ og kotoan non moktaluꞌ miktidu dia sog Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Dadi, tinumindan ilan nog len gotowanan moktaluꞌ nog midongog nilan dow si Esteban moglakaꞌlakaꞌ monaluꞌ dia ni Apuꞌ Muses, bu asta sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Dadi, sabap sog kopongimung nilan koyon dia ni Esteban, kitungian dun og gotowanan, bu og mokogulanganan, bu og polopanadanan nog botad nog bansa Hudyu. Dadi, og gotowanan kituꞌ, inukpaꞌan nilan si Esteban mangka nilan pitangoy sog gukum nog bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mangka ilan alap nog taksiꞌanan nog tumaksiꞌ nog diꞌ motud. Og taluꞌ nilan dun, si Esteban dow, kobon non solapon non na monaluꞌ og Baloy nog Poktomuyan nilan koyon nog mosigda, bu asta og Botad nog pilatas ni Apuꞌ Muses dianilan. ");
INSERT INTO suc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bu miktaluꞌ ion dow nog si Isus og gotow Nasaret kituꞌ, loglagon non dow og Baloy nog Poktomuyan nilan koyon, mangka non dow sopoy og Botad nog pilatas ni Apuꞌ Muses kituꞌ dianilan. ");
INSERT INTO suc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bu glam nog gotowanan sog gukum koyon, pigonglongan nilan si Esteban. Sintak nilan koyon mogonglong dun, sog tinontongan nilan, og bayuꞌbayuꞌ non mamaꞌ nog bayuꞌbayuꞌ nog moloikat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Dadi, og kounutan nog boliananan, sinakan non si Esteban nog, “Motud taꞌ og sumbungan nog gotowanan koni dianika?” ");
INSERT INTO suc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Dadi, tinumabal si Esteban nog, “Mokogulang u bu pigilugan ku nog salu bansa u, pokinongog amu pa dianakon. Ati, kobon nituꞌ og Mikpongon nog ion og Diwata nog motas, tinumuaꞌ dia ni Apuꞌ Abraham kobon pa nog dituꞌ ion sog bonua nog Misopotamia sog daꞌ pa ion poglalin sog bonua nog Haran. ");
INSERT INTO suc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Og taluꞌ nog Mikpongon dianon maꞌ nini, ‘Gonatoy mu og bonua mu koni, bu asta og gusbawalisanan mu mangka a panow sog bonua kituꞌ nog potongowon ku dianika.’ ");
INSERT INTO suc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Dadi, ginonatan ni Abraham bonua non koyon nog Kaldia, bu mangka ion pogonong dituꞌ sog Haran. Ampun minatoy gamaꞌ non dituꞌ, dinondag ion nog Mikpongon mangoy sog bonua nog pigonongan ta koni numun koni. ");
INSERT INTO suc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Saka, daꞌ ion kobogoyoy nog glupaꞌ dituꞌ minsan mikaꞌan. Tibua, og pasad nog Mikpongon dianon nog ngon da gondow nog kobogayan ion nog glupaꞌ dion, poꞌ pusakaꞌ nog ganakapuꞌanan non dianon. Sog tang koyon nog kopoktaluꞌ nog Mikpongon dun dianon, daꞌidun pa og bataꞌ non. ");
INSERT INTO suc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Og Mikpongon miktaluꞌ dosop dia ni Apuꞌ Abraham nog maꞌ nini, ‘Og ganakapuꞌanan mu, sagya ilan da mogonong sog konaꞌ nilan bonua, bu uliponon ilan, bu solapsolapon ilan lagaꞌ pat gatus ton. ");
INSERT INTO suc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tibua, posokitan ku ain og gotowanan kituꞌ nog mongulipon dia sog ganakapuꞌanan ni Abraham, poꞌ bagun da og ganakapuꞌanan non koyon, mokoluas ilan na bu mangka ilan na pokopoktamuy dianakon dini sog bonua koni.’ Maꞌ long nog Mikpongon dun. ");
INSERT INTO suc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Tubus nituꞌ,” long ni Esteban dun, “og Mikpongon, dinondag non si Apuꞌ Abraham moktuk poꞌ maꞌ nituꞌ og tandaꞌ nog tumanon non da og koposadan nilan nog Mikpongon. Dadi, dangan binataꞌ ni Apuꞌ Abraham si Isak, midopot tibua walu ondow tidu botaꞌon, tinuk non. Dangan sop migbataꞌ si Isak dia ni Jakub, tinuk dosop ni Isak si Jakub. Bu si Jakub, tinuk non dosop og gombataꞌanan non kituꞌ nog kolokian nog sopuluꞌ bu duaꞌ kotow. Bu ilan og piktiduan nog pangkat nog bansa ta Hudyu. ");
INSERT INTO suc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Dadi, ngon bataꞌ ni Jakub nog ngalan non si Jusep. Piglinggi ion nog pigilugananan non boyaꞌan nog piksaluy nilan ion poꞌ bagun ion uliponon dituꞌ sog bonua nog Ihiptu. Tibua, og Mikpongon, kobon non dianon. ");
INSERT INTO suc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Bu tinobangan ion nog Mikpongon dia sog glam nog glogon non. Bu binogayan ion nog kotoan. Dangan mitongow nog datuꞌ sog Ihiptu og kotoan ni Jusep koyon bu og kobaꞌis nog polomotadon non, inimung non ion nog kounutan sog bonua nog Ihiptu koyon bu asta sog glam nog daya nog datuꞌ kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tubus nituꞌ, dinotongan nog gutom og tibuk bonua nog Ihiptu bu asta sog tibuk bonua nog Kanaꞌan. Dadi, og mokogulanganan ta kituꞌ kobon nituꞌ, daꞌidun og golapan nilan nog ponganon nilan. Dadi, misinsa tokodoy og glam nog gotowanan koyon dion. ");
INSERT INTO suc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Dangan midongog ni Jakub nog ngon dow ponganon sog bonua nog Ihiptu, sinuguꞌ non gombataꞌanan non kituꞌ nog ion non ion og mokogulanganan ta kituꞌ, mangoy momuku dituꞌ. Ugat ilan pa ion pokangoy dion. ");
INSERT INTO suc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dangan sog koduaꞌ puliꞌ nilan mangoy dion, mikpokilala na si Jusep dianilan. Bu tidu dion, kisunan nog datuꞌ dituꞌ paꞌali sog pigilugan bu mokogulang ni Jusep. ");
INSERT INTO suc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dadi, tinugun ni Jusep tidu sog gamaꞌ non nog si Apuꞌ Jakub asta og glam nilan. Minangoy ilan sog bonua nog Ihiptu. Og dakol nilan nog minangoy dituꞌ pitu puluꞌ bu lima kotow. ");
INSERT INTO suc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Dadi, mipanow ilan sog bonua nog Ihiptu, bu dituꞌ ilan na migonong. Bu dion ilan na mimatoy tidu dia ni Jakub asta duma mokogulanganan ta kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tibua, og tulananan nilan, pipuliꞌ da dituꞌ sog bonua nog Sekem. Bu dituꞌ ilan pinglobong sog kolobongan kituꞌ nog sinaluy ni Apuꞌ Abraham sog glaꞌayat ni Apuꞌ Hamur dituꞌ sog bonua nog Sekem. ");
INSERT INTO suc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Dadi,” long ni Esteban, “dangan daliꞌ na kotuman og pasad nog Mikpongon dia ni Apuꞌ Abraham, dinumakol tokodoy pangkat ta dituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tubus nituꞌ, kisuklian og datuꞌ koyon dion nog daꞌ non kosunoy og paꞌali dia ni Jusep. ");
INSERT INTO suc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Dadi, pigdagdag non mokogulanganan ta, bu ompihit og gokbitan non dianilan. Tinogol non dia sog mokogulanganan ta kituꞌ nog pomolongon nilan og populaanan nilan bagun mokpomatoy. ");
INSERT INTO suc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Og tang koyon, binataꞌ si Apuꞌ Muses. Molongas tokodoy ion nog bataꞌ. Dadi, pigusibaꞌ ion nog ginaꞌamaꞌ non lagaꞌ nog tolu bulan. ");
INSERT INTO suc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Dangan piluas nilan sog baloy og bataꞌ nilan koyon, mitongow nog bataꞌ nog datuꞌ kituꞌ nog baꞌi. Dadi, inalap non mangka non imungoy nog bataꞌ non. ");
INSERT INTO suc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bu si Apuꞌ Muses, pionadan nog glam nog kotoan dion sog bansa Ihiptu koyon nog boyaꞌan miimung mokosog ion moktaluꞌ bu biaksa nog glam nog ginang. ");
INSERT INTO suc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Dangan midopot pat puluꞌ ton tinonan ni Apuꞌ Muses, mipikil non monogikol nog salu bansa non nog Israel. ");
INSERT INTO suc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Dangan minangoy ion dituꞌ, mitongow non og gotow Israel pikposokitan nog gotow Ihiptu. Dadi, sinugutan non og gotow Israel koyon bu mangka non bunuꞌoy gotow Ihiptu koyon. ");
INSERT INTO suc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Poꞌ baluꞌ ni Apuꞌ Muses dun, mosabut nog salu bansa non Israel nog ion kituꞌ sinuguꞌ nog Mikpongon tumabang sog glam nog glogon nilan. Saka daꞌ ion tolimaꞌoy nog salu bansa non koyon. ");
INSERT INTO suc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Miglen gondow ion, mitongow non nosop duaꞌ kotow gotow Israel migbunuꞌ. Inangoy non ilan pomagoy poꞌ popoglogomiguson non ilan bosia. Miktaluꞌ ion, ‘Olo nion? Og salu bansa amu loꞌ ion, saka mogbunuꞌ amu ma?’ ");
INSERT INTO suc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Og gotow kituꞌ nog miglenlen dia sog duma non, dinondol non si Apuꞌ Muses mangka ion poktaluꞌ nog, ‘Sima dinumondag dianika nog mogbayaꞌbayaꞌ a dianami dini? ");
INSERT INTO suc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Olo dun, bunuꞌon mu akon maꞌ nog ininang mu kituꞌ kolabung sog gotow Ihiptu?’ ");
INSERT INTO suc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Dadi,” long ni Esteban, “dangan midongog ni Apuꞌ Muses og tabal koyon dianon, milaguy ion dituꞌ sog bonua nog Midian. “Sintak non mogonongonong dion, mikopogduoy ion dion boyaꞌan nog ngon og bataꞌ nilan duaꞌ kotow nog lunsan laki. ");
INSERT INTO suc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Dangan midopot ilan pat puluꞌ ton sog bonua koyon, minangoy si Apuꞌ Muses sog bonua kituꞌ nog mologon pogonongan dituꞌ sog molani nog bulud nog iningolanan og Sinai. Bu mikpotongow dianon og moloikat nog Mikpongon dia sog polompung nog migligaꞌ. ");
INSERT INTO suc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Dangan mitongow non og gligaꞌ koyon, kisobuꞌan ion dun. Bu inangoy non pogimotimotoy og gligaꞌ koyon. Midongog non og taluꞌ nog Pogbayaꞌ nog, ");
INSERT INTO suc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Akon og Diwata nog mokogulanganan mu kituꞌ kobon nituꞌ nog si Abraham ilan ni Isak bu si Jakub.’ Dadi, dangan midongog ni Apuꞌ Muses taluꞌ koyon, linukuban ion kobal nog gondok non bu diꞌ non kotingagan og gligaꞌ koyon. ");
INSERT INTO suc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Miktaluꞌ nosop og Pogbayaꞌ dianon nog, ‘Luas mu ponyapak mu, poꞌ og glupaꞌ koyon nog pigindogan mu mosigda. ");
INSERT INTO suc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Bu mitongow u pigotowan ku sog Ihiptu nog landuꞌ sinsaan nilan, bu midongog u og kolonganan nilan. Dadi, saꞌan ini tinumonaꞌ u dini, poꞌ gowonon ku ilan sog sinsaan nilan. Dadi Muses, populiꞌon ku ika dituꞌ sog Ihiptu.’ ");
INSERT INTO suc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Dadi,” maꞌ long ni Esteban dun, “si Apuꞌ Muses, ion non ion og pigbongkis kituꞌ nog salu bansa non, bu tinoluꞌan nilan ion nog, ‘Sima a otowoy og mogbayaꞌbayaꞌ dianami.’ Minsan siꞌoy maꞌ nituꞌ og taluꞌ nilan dianon, ion da og dinondag nog Mikpongon mogdatuꞌ bu tumabang dianilan. Og kodondag dianon bianan dia sog moloikat kituꞌ nog mitongow non sog gligaꞌ nog polompung. ");
INSERT INTO suc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Dadi, si Apuꞌ Muses og minuluꞌ dianilan mawaꞌ sog bonua nog Ihiptu. Bu pitongowan non ilan nog gingyataꞌanan nog kosobuꞌsobuꞌ dituꞌ sog bonua nog Ihiptu, bu sog dagat nog iningolanan Pula Dagat, bu sog kobon nilan dituꞌ sog bonua kituꞌ nog mologon pogonongan. Og gobon nilan dituꞌ pat puluꞌ ton. ");
INSERT INTO suc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Og Muses koni, ion non ini og miktaluꞌ kituꞌ sog bansa Israel nog ngon da gondow non nog Mikpongon, bogayan non amu nog polomolatas nog mamaꞌ nakon nog moktidu dia sog dili bansa niu. ");
INSERT INTO suc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Si Muses koni, og salu bansa nilan da bu duma nilan dosop kobon ilan dituꞌ sog bonua kituꞌ nog mologon pogonongan. Bu ion dosop og solabuk sog mokogulanganan ta kituꞌ kobon nituꞌ. Bu ion og tinoluꞌan nog moloikat kituꞌ dituꞌ sog bulud nog Sinai. Bu ion og binogayan nog taluꞌ nog Mikpongon nog diꞌ moksop nog bagun non polotason dianita. ");
INSERT INTO suc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Tibua, minsan maꞌ nituꞌ, og mokogulanganan ta kituꞌ kobon nituꞌ, ompok ilan da mokokunut dia ni Apuꞌ Muses, sugaꞌid non, binibas nilan tanan ion poꞌ og dialom pikilan nilan dituꞌ pa sog bonua nog Ihiptu. ");
INSERT INTO suc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“Dadi, likud ni Apuꞌ Muses dituꞌ sog bulud nog Sinai, miktaluꞌ og bansa Israel dia sog gulang bataꞌ kituꞌ dianon nog ngalan non si Aron. Pingoni nilan dianon og glodawan poꞌ imungon nilan dow nog diwataanan nilan nog monuluꞌ dianilan. Poꞌ maꞌ long nilan dun, ‘Diꞌ nami na kosunan bog ain si Muses dun saka ion loꞌ ituꞌ bosia og minuluꞌ dianita mawaꞌ tidu sog bonua nog Ihiptu.’ ");
INSERT INTO suc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Dadi,” long ni Esteban dun, “migimung ilan dodaꞌ nog glodawan nog maꞌ nog bantuk nog nati nog sapiꞌ, mangka nilan poktomuyoy, bu pomolasoy, bu mangka ilan poglomilomioy og ginimung nilan kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dadi, sabap sog kohinangan nilan koyon, tinolikudan ilan dun nog Mikpongon bu pitiang non ilan moktamuy sog bitunanan, bu bulan, bu gondow. Bu og taluꞌ nog Mikpongon nog sinulat nog polomolatasanan kituꞌ maꞌ nini, ‘Og bansa Israel, sog pat puluꞌ ton gobon niu dituꞌ sog bonua kituꞌ nog mologon pogonongan, daꞌ amu sibon pogbogoy nog pomalas niu dianakon! ");
INSERT INTO suc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Bu pikpitangpitang niu og toguꞌan nog glodawan nog glatdiwata nog ingolanan niu nog Molok, bu og glodawan nog bitun nog glatdiwata niu kituꞌ nog ingolanan nog Rapan. Og pikpitangpitang niu koyon, ion non ion og glodawananan kituꞌ nog poktomuyon niu. Dadi, sabap dion sog kohinangan niu koyon,’ taluꞌ nog Mikpongon dun, ‘bugowon ku amu bagun amu mokaum bu ompitang dituꞌ sog gunan pa nog koliwagan bonua nog Babilon.’ ");
INSERT INTO suc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Dadi,” long ni Esteban dun, “og mokogulanganan ta kituꞌ kobon nituꞌ, kobon nilan dituꞌ sog bonua kituꞌ nog mologon pogonongan, kobon non dianilan og Baloy kituꞌ nog Poktomuyan nilan dia sog Mikpongon. Og Baloy kituꞌ dinondag nog Mikpongon mogimung dia ni Apuꞌ Muses. Bu inunut ni Apuꞌ Muses og bantuk nog Baloy kituꞌ nog pitongow nog Mikpongon dianon. ");
INSERT INTO suc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","“Dadi, dangan minatong na timpu nog pingawaꞌ na nog Mikpongon og timonua sog bonua nog Kanaꞌan, og bonua koyon inuliꞌan nog mokogulanganan ta kituꞌ. Og timpu koyon mikosukli si Josua dia ni Muses. Bu og Baloy nog Poktomuyan nilan dia sog Mikpongon pikpitangpitang nilan dosop. Bu ginamit nilan ituꞌ asta sog minatong og kopogdatuꞌ ni Apuꞌ Dabid. ");
INSERT INTO suc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Og pogolongon koni nog si Apuꞌ Dabid, kisuꞌatan tokodoy og Mikpongon dianon. Bu pingoni non sog Mikpongon nog tugdakon bosia dianon og mogimung nog pogonongan nog Mikpongon, ion non og Diwata ni Apuꞌ Jakub kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tibua, og tinugdakan mogimung dun og bataꞌ non kituꞌ nog si Solomon. ");
INSERT INTO suc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tibua, og Mikpongon nog ion og Diwata nog motas, ondiꞌ ion mogonong sog baloy nog inimung nog gotow. Poꞌ maꞌ nini og taluꞌ nog Mikpongon nog pilatas nog polomolatasanan non kituꞌ, ");
INSERT INTO suc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Og glangit og gingkudan ku. Bu og glupaꞌan og gindogan ku poꞌ akon og mikpongon dun. Dadi, bila maꞌ nituꞌ, olo ma og baloy nog imungon niu dianakon? Otawaka olo ma og gimungon niu nog pogulolian ku? ");
INSERT INTO suc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Akon tanan og mikpongon nog glam non.’ ");
INSERT INTO suc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Dadi,” maꞌ long ni Esteban dun, “landuꞌ dodaꞌ kotogas og guluanan niu! Mamaꞌ amu nog bongol bu konaꞌ poktanud poꞌ polomungyas amu sog Mikpongon. Mingunut amu dodaꞌ dia sog mokogulanganan niu kituꞌ kobon nituꞌ nog kobon non mongantu amu dia sog Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Glam nog polomolatasanan kituꞌ kobon nituꞌ nog taluꞌ nog Mikpongon, pikposokitan nog mokogulanganan niu kituꞌ, bu pimunuꞌ nilan tanan ain og mikpodonsamaꞌ kituꞌ moktaluꞌ paꞌali sog pogdatong nog gotow kituꞌ nog midulus nog popongoyon nog Mikpongon dini nita. Bu dangan tinumuaꞌ ion, pigbolingulanan niu ion mangka niu bunuꞌoy. ");
INSERT INTO suc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tinumabuk amu dow sog Botad nog Mikpongon kituꞌ nog pilatas non dia sog moloikatanan non kituꞌ, saka daꞌ niu da unutoy.” ");
INSERT INTO suc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Dangan midongog nilan og tinaluꞌ ni Esteban kituꞌ, linolingitan ilan tokodoy dianon bu mikigut og ngisianan nilan dun. ");
INSERT INTO suc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tibua, si Esteban miponuꞌ nog Bolakat nog Mikpongon. Tinumongal ion sog glangit, bu mitongow non og silow nog Mikpongon bu pogindog si Isus sog dapit glintu nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Dadi, miktaluꞌ ion nog, “Tontong niu poloꞌma, kituꞌ da og glangit mibukaꞌ, bu og Binataꞌ kituꞌ sog Kilawan, pogindog ion dia sog dapit glintu nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Sabap sog tinaluꞌ non kituꞌ, og gotowanan koyon sog gukum, tinimpong nilan og tolingaanan nilan kobon nilan moglogapis. Bu mikpongindog ilan mangka nilan gobokoy si Esteban, ");
INSERT INTO suc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bu mangka nilan guyudoy sog glowasan nog koliwagan bonua koyon nog Jerusalem, mangka nilan ion tolipunoy mogbatu. Ain taksiꞌanan nilan koyon linuas nilan og glogdoyanan nilan mangka nilan botangoy sog molani nog sala kotow kituꞌ nog glitow nog og ngalan non si Saul. ");
INSERT INTO suc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Solian nilan koyon mogbatu dia ni Esteban, si Esteban migyakin nog, “Apuꞌ Isus, tabuk nika na og glimukud u.” ");
INSERT INTO suc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tubus nituꞌ, mikingluꞌud ion mangka ion poktaluꞌ nog mosikad, “Apuꞌ, naꞌ mu na ukaton dianilan og dusa nilan koni.” Bu mangka na ion kotoktus. ");
INSERT INTO suc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Kisuꞌatan tokodoy dun si Saul og kopatoy ni Esteban. Tibua, og polotamuyanan dia sog Mikpongon, linobong nilan si Esteban dunut landuꞌ glangos nilan. Tidu sog gondow koyon nog kopatoy ni Esteban miktolipun nog ilakad kopokposakit nog ain poktanudanan dia ni Isus sog Jerusalem. Dadi, mikpokpolaꞌ ilan sog gliwag nog bonua nog Judia bu bonua nog Samaria. Tibua, og sopuluꞌ bu duaꞌ sosuguꞌonanan kituꞌ, mibagak ilan dion sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Bu tinolipunan ni Saul mongulaꞌat og pigotowan nog Mikpongon. Bu miktolopasan na ion nog gimbolayananan monontong dianilan bu og glibun laki dianilan pingguyud non mangka non ilan pongolobusuoy. ");
INSERT INTO suc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tibua, og duma poktanudanan koyon nog mikpokpolaꞌ, ain og kiongayan nilan nog bonua, migustal ilan paꞌali dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Pilip minangoy sog koliwagan bonua nog dituꞌ sog Samaria mogustal paꞌali dia ni Isus nog ion og Kristu. ");
INSERT INTO suc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Dangan migustal si Pilip, bu pokpotongow nog gingyataꞌanan, pikinongogan nilan mahatul og piktaluꞌ non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Poꞌ modakol og glatdiwataanan nog tinumosop sog gotowanan nog pimugow non nog boyaꞌan mikpoglosek ilan. Bu ngon dosop og gotowanan dion nog pingkaꞌanan bu dadayanan nog kiuliꞌan ilan. ");
INSERT INTO suc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Dadi, mikpogdaꞌdaꞌ ilan tokodoy dion. ");
INSERT INTO suc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Dadi, ngon gotow sog bonua koyon og ngalan non si Simun nog miobonobon na ion nog polonolomangka. Sabap sog gininang non koyon, og gotow Samariaanan, mingala ilan dianon. Bu migbonsag ion nog motas dow ion nog gotow. ");
INSERT INTO suc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bu glam nog gotowanan dion motas otawaka diꞌ motas, mikinongog ilan dianon bu miksitaluꞌ ilan nog, “Og gotow koni, ion og bolakat kituꞌ nog Mikpongon nog iningolanan motas nog bolakat.” ");
INSERT INTO suc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Saꞌan ion migunutunut ilan dianon poꞌ miobon nilan na motongow og solomangka non kituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tibua, dangan midongog nilan og gustalan ni Pilip nog Gombaꞌis nog Guksugan paꞌali sog pigdotuꞌan nog Mikpongon bu paꞌali dosop dia ni Isukristu, tinumabuk ilan dun bu mangka ilan pokpobunyag, og glibun laki dianilan. ");
INSERT INTO suc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Dadi, asta si Simun tinumabuk dosop, mangka pokpobunyag dia ni Pilip, mangka pogunutunut dianon minsan ain ion angoy. Dangan mitongow non og gingyataꞌ bu kosobuꞌsobuꞌ nog miinang ni Pilip, kisobuꞌan ion dun. ");
INSERT INTO suc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tidu dion, midongog nog sosuguꞌonanan kituꞌ sog Jerusalem nog gotow Samariaanan tinumabuk na nog taluꞌ nog Mikpongon. Dadi, dinondag nilan si Piter bu si Jan ompanow dituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Dangan minatong ilan dion, pigyokinan og gotowanan koyon poꞌ bagun ilan tosopan nog Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Poꞌ og gotowanan koyon, sagya ilan da binunyagan sog ngalan ni Isus. Daꞌ ilan pa sibon tosopoy nog Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Dadi, dinoponan ilan ni Piter bu si Jan mangka ilan pa tosopoy nog Bolakat nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Dangan mitongow ni Simun nog tinosopan ilan nog Bolakat nog Mikpongon bianan sog kodopon nog sosuguꞌonanan kituꞌ, migbubut ion sumaluy dun dianilan. ");
INSERT INTO suc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Long non dun, “Bohogiꞌoy niu pa akon nog maꞌ nog tunung niu koyon bagun da akon siꞌoy ain kodoponan ku tosopan ilan dosop nog Bolakat nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tinabal ion ni Piter, “Mogdunut amu nog sin mu koyon mangoy sog glaꞌat, poꞌ baluꞌ mu dun, og bogoy nog Mikpongon nog og Bolakat non mosaluy nog sin. ");
INSERT INTO suc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Toluꞌon ku dianika nog daꞌidun bahagiꞌ mu sog ginang nami koni poꞌ pikilan mu koyon diꞌ mosuꞌat dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Dadi Simun, sumboy moglilaꞌ a nog pikilan mu koyon nog molaton dia sog Pogbayaꞌ bagun non ika ompunan dun. ");
INSERT INTO suc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bu kosunan ku nog ika, miponuꞌ a nog gimaan, bu mabak a, bu pigboyaꞌan ka pa nog dusa.” ");
INSERT INTO suc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dadi, miktaluꞌ ion dia ni loꞌ Piter, “Pogyokinoy niu pa akon dia sog Pogbayaꞌ, bagun u da diꞌ mosugat nog glaꞌat kituꞌ nog tidu sog Mikpongon nog maꞌ nog tinaluꞌ niu koyon.” ");
INSERT INTO suc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Dadi, dangan mitubus ilan monaksiꞌ sog gotowanan nog si Isus pitubuꞌ puliꞌ nog Mikpongon bu miustal nilan og taluꞌ non kituꞌ, mikpuliꞌ ilan sog Jerusalem. Mingopitan ilan pa mogustal nog Gombaꞌis nog Guksugan sog kodokolan nog bonuaanan dion sog Samaria koyon. ");
INSERT INTO suc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bu si Pilip tinoluꞌan nog moloikat nog Mikpongon nog maꞌ nini, “Panow a na bu unut nika dalan koyon nog tidu sog Jerusalem posunguꞌ dituꞌ sog Gasa nog dituꞌ mikobian sog bonua kituꞌ nog mologon pogonongan.” ");
INSERT INTO suc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Dadi, mipanow si Pilip. Sintak non nion ompanow, mikotongow ion nog gotow sala kotow. Og gotow koyon linosian, og gotow Itiopia nog posunguꞌ na ion muliꞌ tidu moktamuy dituꞌ sog Jerusalem. Bu ion og pogbayaꞌ nog glam nog daya ni Baꞌi Kandis, og datuꞌ kituꞌ sog Itiopia. ");
INSERT INTO suc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Poksakoy ion sog kalesa non solian non mogbasta dia sog Kitab nog sinulat ni Isaya, og polomolatas kituꞌ kobon nituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Dadi, og Bolakat nog Mikpongon, tinoluꞌan non si Pilip nog mokpolani ion sog kalesa koyon. ");
INSERT INTO suc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Dadi, linasig non og gotow koyon. Bu midongog non nog migbasta ion nog Kitab kituꞌ nog pilatas dia ni Isaya. Dadi, sinakan non og gotow koyon bog misabut non dotaꞌ og pigbasta non koyon. ");
INSERT INTO suc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tinumabal og glaki koyon dianon nog, “Olo ma mogandun kosabut u dun lual da ngon bosia og mogustal dun dianakon?” Dadi, pidangan non si Pilip sog sinokayan non koyon mangka non pingkudoy dia sog molani non. ");
INSERT INTO suc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Og mibasta non koyon dia sog Kitab maꞌ nini, “Diꞌ ion mogonekonek mamaꞌ nog bilibili kituꞌ nog inoit sog ponumboliꞌan dun. Otawaka mamaꞌ ion nog nati nog bilibili kituꞌ nog posunguꞌ guntingan, diꞌ non bukaꞌon og babaꞌ non. ");
INSERT INTO suc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kisipogan ion bu pinguklakan ion nog gukum. Daꞌidun mokosuksug paꞌali sog pangkat non poꞌ inawaꞌ nilan ion dini sog glupaꞌan koni.” ");
INSERT INTO suc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dadi, midoksuꞌ ion mogbasta nog Kitab koyon, sinakan non si Pilip bog sima og pogolongon ni Isaya koni, og dili glawas non taꞌ otawaka og len gotow taꞌ? ");
INSERT INTO suc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dadi, tinabal ion ni Pilip. Bu miktidu sog taluꞌ ni Isaya koyon kisuksugan dianon og Gombaꞌis nog Guksugan paꞌali dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Sonuk nilan koyon ompanow, mikobian ilan sog tubig. Og gotow koyon miktaluꞌ dia ni Pilip, “Koni og tubig. Mogusoy taꞌ nog bunyagan mu na akon numun kituꞌ?” Dadi, tinabal ion ni Pilip, “Mogusoy da bila tobukon mu si Isukristu nog daꞌidun og duaꞌduaꞌ nog dialom pikilan mu.” Tinumabal ion, “Tumud u dia ni Isukristu nog ion og Bataꞌ nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dadi, piindog non og sinokayan nilan koyon mangka ilan tukpa bu angoy sog tubig koyon mangka ion bunyagoy ni Pilip. ");
INSERT INTO suc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Dangan ginumawon ilan na tidu sog tubig, si Pilip inawaꞌ nog Bolakat nog Mikpongon dion. Bu daꞌ na ion kotongow mokpuliꞌ nog gotow koyon. Dadi, miglandan og gotow koyon dunut og daꞌdaꞌan non. ");
INSERT INTO suc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tibua, si Pilip sokaliꞌ mikotuaꞌ dituꞌ sog koliwagan bonua nog Asutus! Bu dangan minatong ion dituꞌ, miguliugan mogustal nog Gombaꞌis nog Guksugan dion asta midopot ion dituꞌ sog bonua nog Sisaria. ");
INSERT INTO suc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sintak nog maꞌ nion koyon, si Saul, minit og sad non sog poktanudanan dia sog Pogbayaꞌ nog ion si Isus. Dadi, minangoy ion sog kounutan nog boliananan nog bansa Hudyu ");
INSERT INTO suc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","mangka ion pongoni nog sulat nog posunguꞌ dituꞌ sog kounutananan nog baloyanan nog poglumpukan nog Hudyu dituꞌ sog koliwagan bonua nog Domaskus poꞌ bagun ngon og bayaꞌ non mongukpaꞌ nog ain motongow non nog glibun laki nog mikokunut dia sog gustalan paꞌali dia ni Isukristu. Bu ain og kukpaꞌan non, pitangon non dituꞌ sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Dadi, si Saul bu dumaanan non, mipanow ilan. Dangan milani ilan na sog Domaskus, gomonsunoy pa, ngon sinumilow nog molalak tokodoy nog silow tidu sog glangit dia ni Saul. ");
INSERT INTO suc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Dadi, mibuksak ion sog glupaꞌ mangka ion pokodongog nog taluꞌ. “Saul, Saul, iduma pikposokitan mu ma akon?” ");
INSERT INTO suc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tinumabal si Saul, “Sima a, Apuꞌ?” Dadi, tinabal ion, “Akon si Isus og pikposokitan mu koyon. ");
INSERT INTO suc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sugaꞌid non, pogbuat a mangka a pogdayun sog koliwagan bonua koyon, poꞌ matong a dituꞌ toluꞌon da dianika bog olo og ginangon mu.” ");
INSERT INTO suc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Og dumaanan ni Saul koyon migbonga ilan, nog mikodongog ilan nog gonek saka diꞌ nilan motongow. ");
INSERT INTO suc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Dadi, migbuat dodaꞌ si Saul. Saka dangan binulad non og mata non, ondiꞌ ion mokotongow. Dadi, pigagak ion nog dumaanan non koyon posunguꞌ sog Domaskus. ");
INSERT INTO suc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tolu ondow si Saul nog diꞌ mokotongow, bu daꞌ kan, bu daꞌ inum. ");
INSERT INTO suc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Dion sog bonua koyon nog Domaskus, ngon gotow nog poktanud dia ni Isus og ngalan non si Ananias. Gomonsunoy pa, dia sog kilowkilowan mata, mitongow non si Isus bu miktaluꞌ ion dianon nog, “Ananias.” Tinumabal si Ananias, “Olo dun, Apuꞌ?” ");
INSERT INTO suc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tinoluꞌan ion ni Isus nog, “Angoy a dituꞌ sog baloy ni Judas sog dalan kituꞌ nog iningolanan nog Mologdong. Sak mu dianilan dion si Saul og gotow Tarsus kituꞌ. Poꞌ numun kituꞌ solian non mogyakin. ");
INSERT INTO suc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Bu sog solian non koyon mogyakin, pitongow dianon sog kilowkilowan mata og gotow nog ngalan non si Ananias nog minangoy dion non mangka non ion doponoy poꞌ bagun da moksud mokpuliꞌ og tinontongan non.” ");
INSERT INTO suc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Dadi, tinabal ni Ananias si Isus nog, “Apuꞌ, modakol midongog u nog taluꞌ paꞌali sog gotow koyon nog molaton dow tokodoy og kohinangan non dia sog pigotowan mu dituꞌ sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Bu binogayan ion dow nog bayaꞌ tidu sog mokokotas nog boliananan poꞌ pongukpaꞌan non glam nog moksabi dia sog ngalan mu.” ");
INSERT INTO suc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Dadi, tinabal ion ni Isus nog, “Panow a dituꞌ poꞌ og gotow koyon piniliꞌ u poꞌ ngon og kobalan ku dianon. Ion og mogustal paꞌali dia sog ngalan ku sog binonsaan nog konaꞌ Hudyu bu sog kodotuꞌananan bu asta sog bansa Israel. ");
INSERT INTO suc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Bu potongowon ku dianon og glam nog posunguꞌ matong nog sinsaan non sabap sog kopokokunut non dianakon.” ");
INSERT INTO suc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Dadi, mipanow si Ananias. Dangan minatong ion dituꞌ, sinumolod ion sog baloy koyon. Dangan mitongow non si Saul dion, dinoponan non mangka ion poktaluꞌ nog, “Saul, ika og gilug u, og dinumondag dianakon mangoy dini nika, og Pogbayaꞌ nog ion si Isus og mikpotongow kituꞌ dianika dia sog dalan. Dinondag non akon mangoy dini poꞌ bagun da moksud og tinontongan mu mokpuliꞌ, bu bagun dosop tosopan ka nog Bolakat nog Mikpongon.” ");
INSERT INTO suc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ampun miluksad tibua og taluꞌ ni Ananias koyon, ngon midogdag mamaꞌ nog gunap tidu sog mata ni Saul. Bu migdayun ion mokotongow. Dadi, migbuat ion mangka ion bunyagoy. ");
INSERT INTO suc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mangka pa ion kan bu mioksud mokpuliꞌ og dasig non. Dadi, minguliꞌan pa ion nog podaliꞌdaliꞌ sog glaꞌayatanan ni Isus dion sog Domaskus koyon. ");
INSERT INTO suc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sog sododuꞌun koyon, miktolipun ion migustal dion sog baloyanan nog poglumpukan nog bansa Hudyu paꞌali dia ni Isus nog ion og Bataꞌ nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Og glam nog mikodongog nog gustalan non koyon, kisobuꞌan ilan dianon bu mikpoksinaksakoy ilan nog, “Konaꞌ non taꞌ ion og gotow kituꞌ nog posinsaon non ain og moksabi dia ni Isus dituꞌ sog Jerusalem? Konaꞌ taꞌ gidoy ion og gawoy non koyon dini mongukpaꞌ nog ain mikokunut kituꞌ dia sog gustalan paꞌali dia ni Isus poꞌ pitangon non sog mokokotas nog boliananan nog Hudyu dituꞌ sog Jerusalem?” ");
INSERT INTO suc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tibua, si Saul, kobon non dumungag og kotoan non mogustal. Bu mipotantu non dia sog gotow Hudyuanan koyon nog si Isus, ion dodaꞌ og Kristu nog boyaꞌan diꞌ ilan mokotabal dun dianon. ");
INSERT INTO suc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Miobonobon golot non, migupakat og kounutananan nog Hudyu nog bunuꞌon nilan si Saul. ");
INSERT INTO suc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Dadi, gobi gondow pogoyanan nilan ion sog glam nog dalananan kituꞌ nog posunguꞌ lumuas tidu sog Domaskus. Poꞌ bila mian ion dituꞌ, bunuꞌon nilan. Tibua, ngon og miksumbung dianon paꞌali sog pigupokatan nilan koyon. ");
INSERT INTO suc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Dadi, ngon gobi, tinaguꞌ ion nog glaꞌayatanan non sog duyanan, bu tontunoy sog sobolaꞌ nog galad nog koliwagan bonua koyon, ");
INSERT INTO suc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","mangka ion angoy dituꞌ sog Jerusalem. Dangan minatong ion dituꞌ, minampuꞌ ion bosia sog poktanudanan dia ni Isus. Tibua, kiondokan ilan dianon poꞌ daꞌ ilan pa tud nog tinumabuk na ion dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tibua, pinitang ion ni Barnabas sog sosuguꞌonanan kituꞌ, mangka non suksugoy dianilan og bianbian ni Saul boyaꞌan nog mitongow non og Pogbayaꞌ nog si Isus sog kopanow non kituꞌ sog Domaskus. Bu sinuksugan non dosop dianilan nog og Pogbayaꞌ miktaluꞌ dianon. Bu sinuksugan non dosop dianilan nog kobon ni Saul sog Domaskus, ondiꞌ ion mondok mogustal paꞌali dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dadi, si Saul migonong dion nilan. Bu miguliugan pa mogustal paꞌali dia ni Isus dion sog Jerusalem. ");
INSERT INTO suc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Si Saul mogabitabit ilan nog Hudyuanan koyon nog ponoluꞌon nilan og Ginirik boyaꞌan nog miktinobaloy ilan dun. Dadi, sabap sog maꞌ nion koyon, poksipian nilan nosop ion munuꞌ. ");
INSERT INTO suc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tibua, dangan kisunan nog pigilugan non sog tanud, inatod nilan ion dituꞌ sog bonua nog Sisaria, mangka nilan polondanoy dituꞌ sog koliwagan bonua nog Tarsus. ");
INSERT INTO suc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Bu tidu dion milotaꞌ pokposokitan og poktanudanan dia ni Isus sog gliwag nog bonua nog Judia, sog Galili, bu asta sog Samaria. Mipagon og kopongandol nilan bianan sog gondok nilan sog Mikpongon bu kipondoloꞌisogan ilan nog Bolakat nog Mikpongon. Bu kobon non dumakol ilan. ");
INSERT INTO suc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Dadi si Piter, migdundaan monogikol sog poktanudanan dion sog gliwag nog bonua koyon boyaꞌan nog mikodopot ion asta sog koliwagan bonua nog Lida. ");
INSERT INTO suc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ngon og daday nog mitongow non dion, og ngalan non si Anias. Ngon na walu ton nog diꞌ ion mokobuat sog pigbolilidan non. ");
INSERT INTO suc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Dangan mitongow ion ni Piter, tinoluꞌan non nog, “Anias, pikodag a na ni Isukristu. Dadi, pogbuat a na mangka a ponglulun.” Dadi, sog sododuꞌun koyon migbuat dodaꞌ og daday koyon. ");
INSERT INTO suc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bu glam nog gotow sog Lida bu sog Saron, mitongow nilan ion, bu tinumabuk ilan dia ni Isus. ");
INSERT INTO suc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ngon dosop koliwagan bonua nog molani dion. Og ngalan non og Jopa. Bu ngon sala kotow glibun dion og ngalan non si Tabita. Og ngalan non koyon bila sog Ginirik Dorkas. Og glibun koyon og glaꞌayat ni Isus, bu kobon non tobangan non ain og miskinan bu molongas og polomotadon non. ");
INSERT INTO suc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Diꞌ ion mokodag bu daꞌ kobon minatoy. Dangan ion minatoy, inugasan nilan og bangkoy non koyon mangka nilan toguꞌoy dituꞌ sog dugu nog koduaꞌ lingkat nog baloy koyon. ");
INSERT INTO suc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Og bonua koyon nog Lida bu Jopa mokolani ilan da. Dadi, dangan midongog nog glaꞌayatanan ni Isus nog si Piter dion sog Lida, ngon duaꞌ kotow nog pigobok nilan dituꞌ ni Piter. Pimunan nilan nog sumboy mogdaliꞌ si Piter mangoy dituꞌ nilan. ");
INSERT INTO suc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Dadi, migunut si Piter dianilan. Dangan minatong ion dituꞌ, pinitang nilan ion dituꞌ sog dugu kituꞌ nog tinoguꞌan nilan nog bangkoy ni Tabita. Bu piglibutan ion nog balulibunanan dion kobon nilan moksogow bu pitongow nilan dianon og ponopotonanan kituꞌ nog pingimung ni Tabita. ");
INSERT INTO suc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tibua, piliu ilan ni Piter mangka ion ingluꞌud mogyakin dia sog molani nog bangkoy ni Tabita koyon. Tubus nituꞌ, liningoy non bangkoy koyon mangka poktaluꞌ nog, “Tabita, pogbuat a na.” Dadi, migbulad si Tabita. Bu dangan mitongow non si Piter miningkud ion. ");
INSERT INTO suc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bu pigoidan ni Piter komot non mangka non ion buatoy, mangka non sobioy og poktanudanan dion bu balulibunanan kituꞌ mangka non uokiloy si Tobita dianilan nog totubuꞌ. ");
INSERT INTO suc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Dadi, og kibianbianan ni Tabita koyon mibantug sog tibuk nog bonua nog Jopa. Bu modakol dosop tinumabuk dia ni Isus sog bonua koyon. ");
INSERT INTO suc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bu si Piter, miobon pa dion. Dituꞌ ion migbotukan sog baloy ni Simun. Og Simun koni og ginang non og moktinaꞌ nog panit nog potubuꞌon. ");
INSERT INTO suc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ngon gotow dion sog koliwagan bonua koyon nog Sisaria og ngalan non si Kornilius. Ion og sala kotow kounutan nog sundaluanan nog Roma. Og sundaluanan non koyon iningolanan nog Kampung nog Gotow Italia. ");
INSERT INTO suc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ion bu asta og glam nog salu konglangan non koyon og polotamuy bu mogadab ilan dia sog Mikpongon. Bu motawal ion sog gotow Hudyuanan kituꞌ nog ain kinobus. Bu bikaꞌbikaꞌ mogyakin ion dia sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dadi, ngon gondow non nog ginongaꞌ monog og gondow, migyakin ion. Sintak non koyon mogyakin, gomonsunoy pa sog kilowkilowan mata mitongow non mahatul og moloikat nog Mikpongon minangoy dion non mangka poktaluꞌ nog, “Kornilius!” ");
INSERT INTO suc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Dangan mitongow non og moloikat koyon, mibonga ion bu kiondokan ion tokodoy mangka ion poktaluꞌ nog, “Olo dun, Apuꞌ?” Dadi, tinabal ion nog moloikat koyon nog, “Og gyakin mu bu og tabang mu sog miskinananan tinolimaꞌ na nog Mikpongon bu diꞌ non kolingawan. ");
INSERT INTO suc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Dadi, suguꞌ mu og pigotowan mu koyon mangoy dituꞌ sog Jopa poꞌ ongoyon nilan og gotow kituꞌ nog ngalan non si Simun nog og koduaꞌ ngalan non si Piter. ");
INSERT INTO suc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Dituꞌ ion migbotukan sog baloy nog sangoy non kituꞌ nog si Simun. Og Simun koni, og ginang non moninaꞌ nog panit nog potubuꞌon. Og baloy non dia sog babaꞌ dagat.” ");
INSERT INTO suc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tubus nituꞌ, dangan minawaꞌ na og moloikat koyon, sinabi ni Kornilius duaꞌ kotow sosoligan non bu sala kotow og sundalu non. Og sundalu non koyon og polotamuy dosop sog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Bu sinuksugan non dianilan og glam nog kibianbianan non kituꞌ mangka non siꞌoy ilan suguꞌoy mangoy dituꞌ sog Jopa. ");
INSERT INTO suc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Sogobi golot non, dapit tasondow bonua, molani ilan na sog bonua koyon nog Jopa. Bu lobitan ta sop si Piter. Sog tang koyon, migdangan ion sog dibabow nog gatop nog baloy nog binotukan non koyon poꞌ mangoy ion mogyakin dituꞌ. ");
INSERT INTO suc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Sintak non mogyakin dion, kigutoman ion bu moleg bosia ion kuman. Solian nog dumaanan non mogapuy, gomonsunoy pa maꞌ nog daꞌ sini non nog bonua. Dangan ion mikomongman, ngon mitongow non. ");
INSERT INTO suc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Og mitongow non koyon, og glangit mibukaꞌ. Bu ngon mamaꞌ nog kayab nog tinontun posunguꞌ sog glupaꞌan landuꞌ kolokpang pingikotan og mongatul pigyuluanan non. ");
INSERT INTO suc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Og taguꞌ nog kayab koyon og glam nog gininisan nog manusiaꞌ, bu mamakmamak, bu manukmanukanan. ");
INSERT INTO suc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Bu tinoluꞌan ion nog, “Piter, pogbuat a na mangka a poksumbaliꞌ bu kan.” ");
INSERT INTO suc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tibua, tinumabal si Piter nog, “Ondiꞌ u Apuꞌ, poꞌ daꞌ u pa sibon kan nog pongonganon koyon nog kolomuꞌlomuꞌ otawaka pinumpilian.” ");
INSERT INTO suc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dadi, tinoluꞌan nosop si Piter nog, “Naꞌ mu toluꞌan nog kolomuꞌlomuꞌ og tinoluꞌan nog Mikpongon nog milonuꞌ na.” ");
INSERT INTO suc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Og taluꞌ koyon piguliꞌuliꞌ tumaluꞌ dianon lagaꞌ tolu kali mangka siꞌoy botunoy og kayab koyon dituꞌ sog glangit. ");
INSERT INTO suc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Solian ni Piter mokpikilpikil paꞌali sog maꞌana nog pitongow koyon dianon, minatong sog baloy kituꞌ nog binotukan non, og tolu kotow kituꞌ nog sinuguꞌ ni Kornilius. Poꞌ pinosun ituꞌ dianilan, bu dion ilan na sog pintuꞌ nog galad nog baloy koyon. ");
INSERT INTO suc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Miksabi ilan bu sinak nilan bog dion taꞌ nilan minatuk si Simun nog og koduaꞌ ngalan non si Piter? ");
INSERT INTO suc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Bu solian sop ni Piter mokpikilpikil paꞌali sog pitongow kituꞌ dianon, miktaluꞌ og Bolakat nog Mikpongon dianon nog, “Simun, ngon dion tolu kotow gotow minontong dianika. ");
INSERT INTO suc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dadi, pogbuat a, mangka a ponog bu naꞌ a mogalangalang mogunut dianilan poꞌ akon dinumondag dianilan mangoy dini.” ");
INSERT INTO suc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Dadi, minonog si Piter mangka ion poktaluꞌ sog tolu kotow koyon nog, “Akon og pokponontongon niu kituꞌ. Olo buan og gawoy niu?” ");
INSERT INTO suc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tinabal nilan si Piter nog, “Dinondag ami ni Kornilius mangoy dini. Ion og sala kotow kounutan nog sundaluanan. Ombaꞌis bolotabat non, bu mondok ion dia sog Mikpongon, bu pogodaban ion nog glam nog gotow Hudyu. Tinoluꞌan ion nog moloikat nog Mikpongon nog onggaton non ika mangoy dituꞌ sog baloy non poꞌ bagun non modongog bog olo og toluꞌon mu dianon.” ");
INSERT INTO suc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Dadi, tinolimaꞌ ilan ni Piter bu dituꞌ ilan mitulug lagaꞌ nog sogobi. Dangan miglogondow bonua, si Piter bu duma pigilugan sog tanud dion sog Jopa migunut dianilan. ");
INSERT INTO suc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Miglen gondow sogobi golot non, minatong ilan dituꞌ sog Sisaria. Pigbogadan ilan ni Kornilius. Bu pilumpuk non sog baloy non og pigoloanan non bu asta glokoleanan non. ");
INSERT INTO suc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Dangan minatong si loꞌ Piter dion, pinipini non sumolod, linumpak ion ni Kornilius dunut miningluꞌud sumugyut dia ni Piter. ");
INSERT INTO suc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tibua, piindog ion ni Piter mangka ion poktaluꞌ nog, “Indog a, poꞌ akon og sagyaotow u da.” ");
INSERT INTO suc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bu mangka ilan solod kobon nilan mogabitabit. Bu mitongow ni Piter dion nog modakol og gotowanan nog miglumpuk dion nog konaꞌ og bansa Hudyu. ");
INSERT INTO suc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Dadi, miktaluꞌ si Piter dianilan nog, “Kisunan niu na bog olo og botad nog bansa nami. Konaꞌ nami bosia og botad nog mampuꞌ ami sog gotow nog konaꞌ bansa Hudyu minsan og sagya siꞌoy monumbaloy dianilan. Tibua, og Mikpongon, pitongow non dianakon nog sumboy diꞌ u ponumpilian og gotow nog konaꞌ Hudyu. ");
INSERT INTO suc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Saꞌan ituꞌ, dangan inangoy niu akon, daꞌ u pogbolibad mogunut dianilan dini niu minsan siꞌoy konaꞌ amu og bansa Hudyu. Dadi, naꞌ a poloꞌma, iduma inangoy niu ma akon?” ");
INSERT INTO suc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Dadi, tinumabal si Kornilius nog, “Liu solongondow maꞌ nikun tang non nog ginongaꞌ monog og gondow, migyakin u sog baloy u. Solian ku koyon mogyakin, gomonsunoy pa ngon og gotow nog miglamag dia sog sunguꞌan ku. ");
INSERT INTO suc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Miktaluꞌ ion nog og gyakin ku dow bu og bogoy u sog miskinananan tinolimaꞌ na nog Mikpongon. ");
INSERT INTO suc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Dadi, suguꞌon ku dow og sosoligan ku nog mangoy ilan dituꞌ sog Jopa poꞌ ongoyon nilan dow si Simun nog og koduaꞌ ngalan non si Piter. Dituꞌ dow ion migbotukan sog baloy ni Simun nog ion og gininang non og moktinaꞌ nog panit nog potubuꞌon. Og baloy non dow dia sog babaꞌ dagat. ");
INSERT INTO suc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Dadi, pigdoyunan ku ilan sumuguꞌ mangoy dituꞌ nika. Dadi, ombaꞌis u nog minangoy a dini. Saꞌan ini miglumpuk ami dini sog sunguꞌan nog Mikpongon poꞌ pokinongogan nami og glam nog sinuguꞌ tumaluꞌ nog Pogbayaꞌ dianika nog toluꞌon mu dianami.” ");
INSERT INTO suc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dadi, si Piter miktolipun mogustal dianilan. Maꞌ long non dun, “Numun kituꞌ kisunan ku na nog og Mikpongon diꞌ dodaꞌ mogbigyaꞌ. ");
INSERT INTO suc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sugaꞌid non, glam nog gotow tolimaꞌon non, ain mondok dianon bu ain mokososuꞌat og kohinangan non, minsan olo bonsaoy dun. ");
INSERT INTO suc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Pinoit non og taluꞌ non posunguꞌ sog bansa Hudyu nog ion non ion og Gombaꞌis kituꞌ nog Guksugan nog paꞌali sog kopoglogomigus nog bianan dia ni Isukristu nog ion og Pogbayaꞌ sog glam nog gotow. ");
INSERT INTO suc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kisunan niu og glam nog miinang kituꞌ dituꞌ sog bonua nog Hudyuanan nog miktolipun sog Galili nog dangan midoksuꞌ si Jan momali paꞌali sog kopogbunyag. ");
INSERT INTO suc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Bu kisunan niu dosop paꞌali dia ni Isus nog ion og gotow Nasaret. Bu binogayan ion nog tunung bu Bolakat nog Mikpongon. Bu ainain na ion midoksaꞌ nog bonua moginang nog molongas. Bu kiuliꞌan non ain tinosopan nog glatdiwata, poꞌ kobon non og Mikpongon dianon. ");
INSERT INTO suc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Bu kitoksiꞌan nami og glam nog kohinangan non sog bonua nog Hudyuanan bu asta sog koliwagan bonua nog Jerusalem. Bu binunuꞌ nilan ion bianan sog kolansang nilan dianon sog kudus. ");
INSERT INTO suc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tibua, dangan minatong tolu ondow tidu ion bunuꞌon, pitubuꞌ da ion puliꞌ nog Mikpongon mangka non potongowoy sog gotowanan. ");
INSERT INTO suc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Konaꞌ og glam nog gotow og mikotongow dianon, sugaꞌid non, ain tibua og piniliꞌ nog Mikpongon kituꞌ donsamaꞌ nog mokotaksiꞌ dianon nog mamaꞌ nami nog minadap dianon kuman bu minum tidu ion motubuꞌ puliꞌ tidu matoy. ");
INSERT INTO suc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Dinondag non ami mogustal nog Gombaꞌis nog Guksugan bu monaksiꞌ sog gotowanan nog ion og tinonduꞌ nog Mikpongon mongukum dia sog gotowanan nog totubuꞌ otawaka ain mikpomatoy na. ");
INSERT INTO suc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bu glam nog polomolatasanan kituꞌ, mikpoktaluꞌ ilan paꞌali dia ni Isukristu nog simasima tumud dianon, kompunan og dusaanan nilan bianan sog ngalan non.” ");
INSERT INTO suc_vpl VALUES ("AC10_44","074_10_4