﻿USE sofia;
DROP TABLE IF EXISTS sofia.sua_vpl;
CREATE TABLE sua_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sua_vpl WRITE;
INSERT INTO sua_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","6","E Yesus, ta vle te, Endo E Nut Thim Orom Ka Msasaen, va a hor to endo ta vle te, ka ngothoi ko tkaelha orom kalo pupnam ruk e Devit kar e Ebrehem. To kmelha orom a venloot to orom e Ebrehem ka grung kmis orom e Devit, e Yesus karo pupnam her mar ri arhe: E Ebrehem ta teit mang e Isak, e Isak ta teit mang e Yakop, e Yakop ta teit mang e Yuda kar kaornopeik, e Yuda ta teit mang klo hal ruk e Peres va e Sera, ennginduk ngin nan e Temar, e Peres ta teit mang e Hesron, e Hesron ta teit mang e Ram, e Ram ta teit mang e Aminadap, e Aminadap ta teit mang e Nason, e Nason ta teit mang e Salmon, e Salmon ta teit mang e Boas to knan e Rehap, e Boas ta teit mang e Obet to knan e Rut, e Obet ta teit mang e Yesi, e Yesi ta teit mang e Devit to ngat el en a Taven, en kam nho mang lIsrael. ");
INSERT INTO sua_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","To kle kaelha orom a venloot ko tok orom e Devit va ka grung kmis ko lBabilon ngata kakapom lIsrael kmen a kapnes ngang ngar ngok mBabilon, e Yesus karo pupnam her mar ri arhe: E Devit ta teit mang e Solomon vgum e Uraia ktavlom ko tlei orom, e Solomon ta teit mang e Rehoboam, e Rehoboam ta teit mang e Abaisia, e Abaisia ta teit mang e Asa, e Asa ta teit mang e Yehosapat, e Yehosapat ta teit mang e Yehoram, e Yehoram ta teit mang e Usaia, e Usaia ta teit mang e Yotam, e Yotam ta teit mang e Ehas, e Ehas ta teit mang e Hesekia, e Hesekia ta teit mang e Manase, e Manase ta teit mang e Emon, e Emon ta teit mang e Yosaia, e Yosaia ta teit mang e Yekonaia kar kaornopeik ruk ngata vle kun mnam a venloot to lBabilon ngat her kakapom lIsrael kmen a kapnes ngang ngar ngok mBabilon he. ");
INSERT INTO sua_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","To kle kaelha orom a venloot to lBabilon ngta kakapom lIsrael kmen a kapnes ngang ngar kmis mang e Yesus ko ta pis, e Yesus karo pupnam her mar ri arhe: E Yekonaia ta teit mang e Sialtiel, e Sialtiel ta teit mang e Serababel, e Serababel ta teit mang e Abiut, e Abiut ta teit mang e Elaiakim, e Elaiakim ta teit mang e Esor, e Esor ta teit mang e Sadok, e Sadok ta teit mang e Ekim, e Ekim ta teit mang e Eliut, e Eliut ta teit mang e Elieser, e Elieser ta teit mang e Matan, e Matan ta teit mang e Yakop, e Yakop ta teit mang e Yosep, to tlei orom e Maria to tkol e Yesus, endo o mia ngma mon te, Endo E Nut Thim Orom Ka Msasaen. ");
INSERT INTO sua_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yu! Her tok arhe. To kam pupam e Yesus karo pupnam ruk endri tgus ko ngata ngamngam mo kim o valngneik tgus ngat kais te, loktiek hori orom korlolo kmelha ko orom a venloot to tkol e Ebrehem ka grung kmis orom e Devit. Va loktiek hori orom korlolo yok vat kam le kaelha ko orom a venloot to tkol e Devit ka grung kmis ko lBabilon ngata kakapom lIsrael kmen a kapnes ngang ngar ngok mBabilon. Va loktiek hori orom korlolo kat kam le kaelha kat orom lBabilon ko ngata kakapom lIsrael kmen a kapnes ngang ngar ka grung kam le kngae her kais orom Endo E Nut Thim Orom Ka Msasaen. ");
INSERT INTO sua_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","To kam keknen mang e Yesus to E Nut Thim Orom Ka Msasaen ko knan tkol ta vle ti te: Tennik, a re ta plok mang e Yosep kre Maria te, min kam lei. E Maria tlo vle ko kim e Yosep vop, nangko ta senkrip ko ka nam he, ekam E Nunu A Totur. ");
INSERT INTO sua_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kmikkiem enang tok, ekam ko katngokol to e Yosep en a mhel to nam sim kut kaikkiem E Nut karo pos, tlua svil kam vua ngam a leep mang e Maria ko ma mmok e. He ekam tok, ta kle va ka lgem o rhek te, kam gia kser a lei he vur korim lvongnek, nang o mia tgus kam lua rere pum ma mmok. ");
INSERT INTO sua_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kam ngae, to Ngoldaip ka engyel ther gi pis he kngam tmik kim e Yosep ponit he kreng te, “Vae, Yosep, e Devit kaes to yin. Ngior kam vu kta papat nngia nngia mang e Maria, ko a sie to mnam ka vrek tpis ekam E Nunu A Totur mruo. To tok, ngiak vaeng a vlom to endo ngok mrek en kam vle ko kmin. ");
INSERT INTO sua_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Va koknaik nera kol a sie to a ngokol, he ngiak mon te, e Yesus ko tennik E Nut ther reng khal to en te, Yesusulgim ilaro mia mruo ko ngira lol ngaro kerkeknen patgiang ngaiting.” ");
INSERT INTO sua_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","E Maria tel ka nam ekam E Nunu A Totur, he kmikkiem gi enang tok, E Nut karo rhek ngat pis lmien orom ko tennik ka propet langto ta ktar kpavap mang ko tittiek te: ");
INSERT INTO sua_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Vae, a vlom langto lurokol ngat lo ehang vop, ner kael ka nam he kol a sie to a ngokol va o mia ngara kilegem te, e Emanuel”. To kam hortgem ka munik to enda ka pun ta vle te, “E Nut ta kmor he.” ");
INSERT INTO sua_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","E Nut tngam tmik kim e Yosep tok knop, to e Yosep thera hop kaikkiem Ngoldaip ka engyel karo rhek kam vaeng e Maria ngok mrek, en kam vle ko kim, ");
INSERT INTO sua_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","vanangko, tlo konit ko kim kam ngae kais ko te kol a sie to a ngokol. Kam ngae, to knan ta kol, to e Yosep thera mon te, e Yesus. ");
INSERT INTO sua_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","E Yesus knan tkol ko mBetlehem kun mnam a mhe to e Yudea mnam o kolkhek ruk lRom ngtel e Herot, en kam vle te, o Yuda nga taven ko tok. Tkol he, to o hirtek akuruk ngat vua mnor mang o ketor ngat kottek ko malhagenmok kun mnam a mhe to a kolkha nma hur mnam he kngae klal kpis ko mYerusalem. ");
INSERT INTO sua_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ngat pis he kaelha kam mamnganang o mia te, “O Yuda nga taven to knan tgi gnua kol namriem? Ko ngota vle oguon malhagenmok he ka vle kvokom a ketor ko ther gia hurpis ko he ksap kvuut. He ekam tok, ngot kaol ngte kam nngiar ngang va kam totu pum.” ");
INSERT INTO sua_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","A taven to e Herot ta ngnek mang ngar ko ngta mamnganang o mia mang o Yuda nga taven tok, to en kar lYerusalem kavurgem ruk ko tok mYudea ngaro papat ngat ho mi ktua kervavle mang. ");
INSERT INTO sua_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","To ekam tok, e Herot tvaeng o Yuda ngaro pris ruk laol va ngaro pattermia kmo pos kam mnganang ngar te, “O propet ngata ktar kpavap mang Endo E Nut Thim Orom Ka Msasaen ko knan nak kol mnam ani rengmat to lsir?” ");
INSERT INTO sua_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Va ngat koripang te, “Mnam e Betlehem to kun mnam a mhe to e Yudea kmikkiem gi enang ko a propet langto ta ktar kpavap mang gi enang tok tennik ko tittiegom E Nut karo mur rhek mruo te: ");
INSERT INTO sua_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Vanang a rengmat to e Betlehem kun mnam a mhe to e Yudea ila munik nak ho mi kut laut hak ekam ko ngora tavger a taven langto kun pgegom yin mruo kam sir ko kmuk he nera ktong kuaro mia ruk lIsrael he ktoot mang ngar.’” ");
INSERT INTO sua_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","E Herot ta ngnek tok, to ther vrua vaeng o hirtek lvongnek he kol a papat mkor mar mang ani kolkha lsir to a ketor to endo ta plok mnam. ");
INSERT INTO sua_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ngat mon a kolkha to endo, to e Herot ta kle pe gia havaeng ngar te, “Mguak ngae ngogut mBetlehem he sim ktua kngae ko kim o mia kam mamnganang ngar kam smia mnor mang a sie to endo, ngola? Mgua re kpis mang, va mguak kaeknik ngte khavaeng dok, dok vat kam kle kngae kpis ka nngiar ngang kam totu pum kat.” ");
INSERT INTO sua_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ngata ngnek mkor tok, to hera ngae. Ngata ngae kngae, va vgum a ketor to ngata vokom tesgun ko thera ktar ka plok mnam a mhe to a kolkha nma hur mnam he ksap kvuut, ko ngata vle oguon malhagenmok vop. Ta kta pis kat he kta sap kam kta ktong ngar kam ngae kngae kais ko te mia pis he ksir ka vle kuon malpgem a rek to lsir ko a sie ta vle kun mnam. ");
INSERT INTO sua_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ngat vokom a ketor tok, to ngat ngae sei kam sirei ge. ");
INSERT INTO sua_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","To ngat pis kvavaik ngogun ma rek, to hera vokom a sie to endo kar knan e Maria. Ngta vokom tok, to hera tubulkek ku penharom a sie to endo to kle kpepet ngaro ngaelpas he khohong ngaro gol va ngaro ku va ngaro vursien ruk ngma mon te, o prekensen, kam nngiar ngang a sie to ormar. ");
INSERT INTO sua_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ngat kaeharom tok knop, to ngat hera ngae kmonit. Ngat konit to E Nut ta ngam tmik kim mar ponit he khavaeng ngar kam lo kat kaeknik ngok kim e Herot kat e. He ekam tok, ngat kle vrua ngoropok kaekeknik kmikkiem a ngaelaut langto yok vat kam pis malhagenmok mnam nga rengmat mruo. ");
INSERT INTO sua_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","O hirtek ngat ngorpok he, to Ngoldaip ka engyel ta le kpis ko kim e Yosep vat, he kngam tmik kim ponit he khavaeng te, “Hop, he kol a sie to endo va vaeng knan he ngorpok orom min ngogu mIsip ekam ko e Herot ta re kam riring a sie to endo kmim kngam a yoror. He ngiaka vle ko tok kais ko dok mruo ngua mrua havaeng yin kmeknik.” ");
INSERT INTO sua_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","E Yosep ta kol a engyel ka re tok, to khop kokol a sie to endo va kvaeng knan to hera ngorpok orom min kam ngae ngogu mIsip mnam a segain to endo gi. ");
INSERT INTO sua_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ngta vle ko tok mIsip kais ko e Herot ta yor. He ekam ko ngta vle ko tok mIsip, E Nut karo rhek ngata pis lmien ko tennik ka propet langto ta ktar kpavap mang khal gi enang tok ko tittiek te, “Ko her vaeng ko hal ko mnam a mhe to e Isip, en kmottek petgim a mhe to endo.” ");
INSERT INTO sua_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ngta vle ku mIsip tok, to e Herot ta tar ko o hirtek ngat her kauyang he. To ta vrek kinkiin, to her kle kaen a volou to kmim o ngnes ruk lurokol tgus endruk ngaro pnes ngat kais mang alo pnes alomin he ka grung, kmikkiem a kolkha to o hirtek ngat mon, endo ko ngat vokom a ketor ko tpis mnam. Enang tok e Herot ten a re kmim o ngnes ruk lurokol tgus kun mnam e Betlehem va kun mnam o maksien ruk kanmok mang e Betlehem kat. ");
INSERT INTO sua_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ngtim mar, he enang tok, E Nut karo rhek akuruk vat ngata pis lmien ko tennik ka propet langto vat ta ktar kpavap mang e Yesus ka ngausie gi enang tok ko tittiek te, ");
INSERT INTO sua_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A rengmat to e Rama ko rkieng a rengmat to e Betlehem ngta vor pa ngaor va ktolpum o ngoven he kaee he kvulhi ku mmie kngae. Ngat kaee kngae mang ngles, he tang tho lo kut kais hak kam hagam mar e, ko ngles ngat her ho yayor tgus hak he.” Ii, her mar e Yesus ka ngausie to e Retsel ta pupur kim mar arhe. ");
INSERT INTO sua_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","To ko pekam ko e Herot tyor, Ngoldaip ka engyel ta kta pis ko kim e Yosep he kta ngam tmik kim ponit ko mIsip kat. ");
INSERT INTO sua_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ta reng te, “Hop, kol a sie va vaeng knan he eknik orom min ngoguon mnam o Yuda nga mmie to e Israel ekam ko e Herot mar, endruk ngat en a volou kmim a sie kngam a yoror ngat yayor tgus ngmeang he.” ");
INSERT INTO sua_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","To kmikkiem enang ko a engyel ta re, e Yosep thera hop, kol a sie va kvaeng knan he kaeknik orom min ngoguon mIsrael. ");
INSERT INTO sua_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tpis ormin ko mIsrael, vanangko ta ktar ru pum a re he te, e Akeleas ta le kol kteit to e Herot ka ngaekam kam nho mang o mia ruk ko mYudea va te sei kam gor mang a sie kam vle orom ko tok. He ekam tok, E Nut ka engyel ta kta ngam tmik kim ponit he kaengorang mang tok, to tle kngorpok ormin ngoguon mnam a mhe to e Galili. ");
INSERT INTO sua_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ta ngae kpis orom a sie to endo ko tok, to hera vle kun mnam a rengmat to e Nasaret. He enang tok, E Nut karo rhek akuruk ngat pis lmien orom a sie to endo ko tennik karo propet akuruk ngta ktar kpavap mang ko ngat ittiek te, “O mia ngara mon en te, en nkong ko mNasaret.” ");
INSERT INTO sua_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kun mnam a venloot to endo, e Yoanes to nma parrum o mia ta ngae he kpis kun ma kalputmok kun mYudea he kaelha ka tger o mia kngae ");
INSERT INTO sua_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","te, “E Nut ka tavgo ther mi pis, he ka vle mo pgegom mor he. He ekam tok, mguak kaitgung mularo kerkeknen.” ");
INSERT INTO sua_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ii, endo a propet to e Aisaia ta ktar kpavap mang her e Yoanes arhe. Ko tennik tittiek mang te, “A mhel langto ta vle ko ma kalputmok he ktetger o mia kam re la vlorum ngang ngar mang ngaro kerkeknen te: Mguak verang a ngaelaut ekam Ngoldaip, Endo E Nut Thim Orom Ka Msasaen va mguak hopeng kero kleimkor ekam kat.” ");
INSERT INTO sua_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Vanang e Yoanes, nam kaegenkar ka yet to ngat eharom orom a ngaemslang to a kamel karo ngairis. Va nma kleng ka vgon orom a pus to ngat eharom orom a bulmakau ka ptaik. Va nam kaemem o ngorveit va o lup ruk ko ma kalputmok kat. ");
INSERT INTO sua_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nma vle tok, he o mia kavurgem ngama mopatap kmotoot pum mar ruk ko mnam a rengmat to e Yerusalem he ngma veet kam pis ko kim e Yoanes ko ma kalputmok kam vongnek kim. Va si mnam a mmie ka mhe to e Yudea karo rengmat tgus va o rengmat kavurgem mnam a ye to e Yodan kalo ngaiting tgus va o mia ngma veet kam pis ko kim ko ma kalputmok kam vongnek kim. ");
INSERT INTO sua_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ngma veet ko kim tok, to nam kle kparrum mar orom E Nut ka munik kun mnam a ye to e Yodan ekam ko ngat mrua havae mang ngaro kerkeknen ma mmok. ");
INSERT INTO sua_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","E Yoanes nam kaeharom mar tok, to ma kolkha langto tvokom o Parisiau kar o Sadyusi kavurgem ko ngat pis ko kim, en kam parrum mar kat. Tvokong ngar tok, to hera reng ngar lserppak te, “Laro inkuol ruk muk orom mularo naprai alomin. Muta pat te, mut kais kam gia parrur kuo mang mularo gi pkor, ko enangthe kam pet a kapnes to E Nut tre kmen ngang nguk, nang kle kat kaeknik kmeharom o kerkeknen gi? ");
INSERT INTO sua_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","O-o, ho mi kut nop hak, mguak kle kaeharom o keknen lyar, endruk ngta khenam ngang o mia te, lmien te, mut mi itgung mularo kerkeknen. ");
INSERT INTO sua_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ii, va mguak or kam pat te, mut kais kam pe gi mrua koon mang nguk mruo orom mularo mur rhek kam tok orom mar kam re te, ‘Ngot pal mnam a ngausie ka pun to mkor ngores e Ebrehem, he ekam tok, ngrer lua kol a kapnes to endo e.’ Kmanker muk? Te mut si pal mnam a ngausie to mkor ngores e Ebrehem vanie, vanangko kua havaeng nguk te, si o gi krek ruk endri va E Nut tkais kam gia hortgem mar, mar kam pis te, e Ebrehem kaores msim ruk mar kat, mar kam kle kliepum muk ormar. ");
INSERT INTO sua_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kua mien ha, ko langto langto mnam muk tmi kut kaenang a ho to nam kaehi orom karo miel ruk nong lyar. Va her a venloot to E Nut kam hong pum ngma veet kam pis ko kim e Yoanes ko ma kalputmok kam vongnek kim o hi tgus arhe. Ko gi tete ta ka kom ther toto mang a ho atgiang atgiang karo kavgot he o hi tgus ruk ngaro miel ruk nong lyar va nera kovverik he kokovgom mar kngam mar oguo kia paei.” ");
INSERT INTO sua_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Vanang a mhel langto nera kaol knaek mang dok vanangko en tlaut mang dok. Va ka serppak tho mi kut laut kir kim dok, he klo vu kais mang en e. Si dok kam gi kokol kalo nhar mkor, va dok klo vu eveep is e, en kam mrua ppir mang en mruo, nang dok kam kokol min. Dok koma parrum o mia akuruk mnam muk orom a gi ye ekam ko mut itgung mularo kerkeknen, vanang Endo Ner Kaol knaek mang dok, en ner le ktua parrum akuruk mnam muk orom E Nunu A Totur ka munik, nang kle kngam akuruk mnam muk oguo kia paei. ");
INSERT INTO sua_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ii! Her en tuk to tkais kmeharom ka ngaeha enang tok arhe, ko ka ngaeha ta vle enang a mhel to ta kpom ka kriar ko ta re kam sngam a paei kam mrot o hi ngo kok. Nera mrot to le klol endruk lyar petgim endruk nong lyar, to her le klol endruk lyar kaelik kun ma rek langto. Vanang endruk nong lyar nera ngam mar oguo kia paei to a vleir kam rum mar tgus ngatngae.” ");
INSERT INTO sua_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","To mnam a venloot to e Yoanes ta vle ko ma kalputmok, e Yesus tottek kuon mnam a mhe to e Galili he ka grung ngogu ma ye to e Yodan ngok kim e Yoanes, en kam parrum kat. ");
INSERT INTO sua_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tpis ko kim, vanangko e Yoanes tre ka kser he kre te, “O kman ko ya le kpis mo kmok? Vanang yindo yin kam parrum dok ha.” ");
INSERT INTO sua_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Va e Yesus tkoripang te, “Na her gia vle tok na, kmaottam E Nut ka svil to kam susulgim o mia tgus.” E Yesus thavae tok, to e Yoanes ta le kngatkal ngang kam parrum. ");
INSERT INTO sua_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","E Yoanes ta parrum e Yesus orom E Nut ka munik knop, to e Yesus ther gia hop ku mnam a ye, va vgum a volkha ko tmommenik. Tmommenik, to e Yesus tvokom E Nunu A Totur ko E Nut ta meng, he ta nho enang a ngaining to a giu. Tvokom ko ta grung he kar kuon mang. ");
INSERT INTO sua_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tvokom tok, va vgum E Nut ka ktui ko tkottek kuon ma volkha he kre te, “Ko hal to yin. Kom vu kaelongtok mang in va ko sei kam higiang in.” ");
INSERT INTO sua_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","To E Nunu A Totur ta ktong e Yesus ngok ma kalputmok ka mhe langto ko yok vat, he nang e Seten kam kendom ngang e Yesus kmeharom o kerkeknen ko tok. ");
INSERT INTO sua_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Va ekam ko e Yesus ta pal kmo ol kais mnam o kolkhek va o rsegain ruk alo mhelom alomin, te sei kam vang. ");
INSERT INTO sua_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","To endo yek, e Seten to nam kaenen mkor o mia kmeharom o kerkeknen tkaelha kmegom e Yesus kam kendom ngang kam reng te, “Enang ko E Nut Khal msim to yin, va yin he, reng o krek ri, he nga hortgi el mar o bret, yin kmemik.” ");
INSERT INTO sua_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Va e Yesus tkokheng kam reng te, “O-o, ngat ittiegom E Nut karo rhek tennik he te, ‘A mhel ka ngorsang tlo gia vle mang kam her gia pat mang o ol ruk o bret he kvenu kmemik e. Nove! A mhel ka ngorsang ka pun msim ta vle mang kam ngan vgum E Nut karo rhek tgus ruk ngat ottek ko vgum.’” ");
INSERT INTO sua_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","E Yesus ta re tok, to e Seten ta kle kta ktong ngok mnam E Nut ka maksien to ko mnam a rengmat to a totur to e Yerusalem, to ka srim kuon kim E Nut ka maksien ka rek ka keik to kuo plut hak. ");
INSERT INTO sua_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","To ther kat kaegom kam kleim E Nut karo rhek kam kendom ngang te, “Enang ko E Nut khal msim to yin, va yin he, mur khenam in kam prik ngogu mmie. Ko enang ko ta mien mang in tok, va yi lo kais kam yor e, ko ngat ittiegom E Nut karo rhek mang in he te, ‘E Nut ner gi kaen a re ngang karo engyel mang in, he ngar mia hapong in orom ngakro singni ko kia gan. He ekam tok, si ila nhar ke smeik ngang, va ner lo kais kam gi vrua mot a kre tang hak.’” ");
INSERT INTO sua_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Va e Yesus ta kta kokheng kat te, “O-o, tennik ngat ittiegom E Nut karo rhek akuruk kat te, ‘Ngior kam kendom ngang Ngoldaip to E Nut, En kam khenam ka serppak ma mmok.’” ");
INSERT INTO sua_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","E Seten ta ngnek tok, to ther kta ktong e Yesus ngoguon kia vul to la hogor hak to ta khenam o marhok ngakro mhetor tgus orom ngakro gol ngang. ");
INSERT INTO sua_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","To e Seten thavaeng te, “Vokom o marhok ri ngakro serppak tgus na, ko ngora slak orom mar ngang in, yin kam nho mang ngar enangthe ngiak tubulkek ku penharom dok he ktotu pum dok.” ");
INSERT INTO sua_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Va e Yesus tho gia likim te, “Ekenok he Seten! Ko tennik ngat ittiegom E Nut karo rhek kat te, ‘Ngia gia totu pum ildaip to E Nut tuk he gi kaeha ngang En tuk.’” ");
INSERT INTO sua_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","E Seten ta ngnek tok, to hera ngae kparem, va vgum E Nut karo engyel ko ngat kle kpis ko kim e Yesus he kturang kmelha kam klang mo ol. ");
INSERT INTO sua_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","To mnam a venloot to e Yesus ta ngnek mang e Yoanes te, ngat enpasiker kun ma hengor, e Yesus tvur kaol kngae kam kat kaeknik ngoguon ma mhe to e Galili ");
INSERT INTO sua_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","kam ngae ka mlom ko tok mNasaret kam kle kngae korsang mKaparnam ko tok mnam a mhe to e Galili. Tngae tok, he korsang ko vanam a ngaenker to e Galili ko rkieng alo mhe ruk e Sebulun va e Naptali. ");
INSERT INTO sua_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","E Yesus teknik ngok mGalili, he kaottam E Nut ka propet to e Aisaia karo rhek, mar kam pis lmien, ko e Aisaia ta ktar kpavap mang enang tok ko tennik tittiek mang te, ");
INSERT INTO sua_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Vae, muk lSebulun va muk lNaptali muk ruk muta vle ekam a ngaelaut to ta ngae ko vanam a ngaenker to e Galili ko ekam a ye to e Yodan ka ngaiting to ngkun kuon. Muk alo mhe ruk ko rkieng lGalili msim, vanangko o vrong rhek ngta movavaik kun mnam muk. ");
INSERT INTO sua_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Muk ruk muma vle mnam alo mhe ruk kun ma slommok, mut her vokom a mmok to ta mmok klik kim o mia. Ii, muk ruk muta vle enangthe mut re kam yor kam lo kta kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik, kua havaeng nguk te, a mmok to endo ta valler muk.” ");
INSERT INTO sua_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","To kmelha mnam a venloot to endo kam ngae, e Yesus tkaelha kam tger o mia te, “Mguak kaitgung mularo kerkeknen ekam ko E Nut ka tavgo ther mi pis mo kmuk he.” ");
INSERT INTO sua_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tie ma kolkha langto, e Yesus ta ngae kaikkiem a ngaenker to e Galili ka ngaiting, va vokom lo monopia ruk e Saimon, endo koknaik e Yesus ta kilegem te, e Pita, kar knopia to e Andru. Tvokom min ko nginta hivuo kam ngam ngina klui kun ma ngaenker, ko min ngina ngaeha to kmit singol. E Yesus tvokom min tok, ");
INSERT INTO sua_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","to hera reng ngin te, “Mae aol ikkiem dok, he ngor kle kaelkim mae kmit o mia ngok kim dok mekam mekam gi enang ko mem kait o singol.” ");
INSERT INTO sua_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ngint re ngan ko ta re tok, to ngint her gi korim ngina ngaeha to kmit singol orom nginaro klui, nang her gi kaikkiem ngatngae. ");
INSERT INTO sua_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","E Yesus tvur kta ngae kat, to kta vokom lo monopia aloruk kat e Yems va e Yoanes. Min e Sepedi klo hal. Tvokong ngin kar ngin teit ko ngata vatvat ngaro klui he kaelel mo kim mar kuo ma langail. Tvokom min to hera vaeng ennginduk kat. ");
INSERT INTO sua_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","A gi hi to ta vaeng ngin, ngint her gia parem ngin teit va korim ngina ngaeha to kmit singol orom ngina langail, nang le kaikkiem ngatngae. ");
INSERT INTO sua_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ta vle tok, to e Yesus tkaelha kvaik kottek kun mnam a mhe to e Galili karo rengmat ngakro maksien tgus he kaelha kpatter o mia kun mnam o Yuda ngartaro rektor ruk kam rere mnam mar kun mnam a maksien langto langto. Ko tok nma polger o rhek ruk mang E Nut ka tavgo to tpis he re kam komor o mia. Va tkaeharom o mia pum ngaro yor ngo mamten tgus ruk kuo mang ngar kat. ");
INSERT INTO sua_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nam kaeharom mar tok mekam mekam, to o mia ngta ngongnek mang ko ka munik ta vaas kngae kun mnam o rengmat tgus kun mnam a mhe to ko mSiria. He ekam tok, ngata lol endruk ngta yayor ngok kim, en kmeharom mar. Tkaeharom endruk ngakro yor ngo mamten ruk enang o nganngannes ruk laol, endruk o kool ngta viging ngar, endruk a ngoulo tkaim mar, va endruk ngaro mhetor akuruk ngat yor kat. ");
INSERT INTO sua_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nam kaeharom mar tok, he o mumu ruk laol orom o mia ngta hohop he kbut kaikkiem. Endruk endri: endruk nkong ngar mnam a mhe to e Galili, akuruk nkong ngar mnam a mhe to ngma mon te, O Rengmat Ruk Loktiek, va akuruk nkong ngar ko mYerusalem va akuruk kun mnam o rengmat akuruk ko mYudea kat va endruk nkong ngar mnam a ye to e Yodan ka ngaiting to ngkun kuon kat. ");
INSERT INTO sua_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","To e Yesus ta vokom o mumu ruk laol ruk endruk, to hera grap ngoguon kim ke vul langto ka ngaiting he korsang ka vle. To kalngunes ngat kaikkiem he kaol kpis ko kim ");
INSERT INTO sua_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","to tkaelha kam patter mar ti te: ");
INSERT INTO sua_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Endruk ngam mrua pat mang ngar mruo te, ngaro papat ruk mang E Nut ngma tu kim mar, her mar ruk arhe ngata lgekol ekam ko her mar ruk arhe E Nut ka tavgo nera vle kuo mang ngar kuon ma volkha. ");
INSERT INTO sua_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Va endruk ngma kaee kam mrung o mia ngata lgekol kat ekam ko her mar ruk kat arhe E Nut nam kaen a vrek longeik ngang ngar. ");
INSERT INTO sua_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Va endruk ngam mrua slak ormar mruo, ngata lgekol kat ekam ko her mar ruk E Nut nera sulgim mar, mar kam vle koknaik ko mnam a mmie to a gunngar. ");
INSERT INTO sua_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Va endruk ngma vang mang E Nut karo keknen ruk ngta sir, kam sim kut kaikkiem mar, mar kat ngata lgekol ekam ko E Nut ner kaeharom ngaro vurkul kmisis. ");
INSERT INTO sua_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Va endruk ngma khenam nga mamrung ngang o mia, mar kat ngata lgekol ekam ko E Nut nera khenam ka mamrung ngang ngar tok kat. ");
INSERT INTO sua_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Va endruk ngam kael E Nut tuk ktar ko pum ngaro kerok, mar ngata lgekol tok kat ekam ko ngara plong vle ko kim En ngnik ngnik. ");
INSERT INTO sua_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Va endruk ngam kaen a monho kun pgegom endruk ngam mo esik ngang ngar, mar kat ngata lgekol ekam ko mar ngma vle te, E Nut kles msim. ");
INSERT INTO sua_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Va endruk o mia ngma kol a regesal mang ngar ekam ko ngam sim kut kaikkiem E Nut karo keknen ruk ngta sir, mar kat ngata lgekol ekam ko E Nut ka tavgo nera vle kuo mang ngar kuon ma volkha kat. ");
INSERT INTO sua_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Va muk ruk o mia ngma sisieng nguk va kol a regesal mang nguk he kerrereng nguk orom o rhek ruk la ppiagar ekam dok, va muk kat muta lgekol ekam ko her muk ruk kat arhe E Nut ther el mula keik to alautar kuon ma volkha kam paneng nguk ko tok. Ii! Mguak sirei he ho ksirei hak ekam ko muta kolkol ekam o propet ruk tennik, ko o mia ngat kol a regesal mang ngar gi enang tok kat.” ");
INSERT INTO sua_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mguaka vle enang a hormnek to orom ka karvuk ekam ko E Nut ther mi kut el muk kun pgegom o mia mo mmie kam vle tok arhe orom mularo keknen ruk lyar. Vanang enangthe a hormnek ka karvuk npa hortgi he knop, va ner kle ka vle nngia, en kam kta hortgi he kta karvuk kat? Nove! Tlo kat kais hak kam kta serppak kat e, ko ther ngae kernonho hak he. He ekam tok, ther gia vavle, he gi kais kam gia ngam ko ekam a ngaelaut, o mia kam gia ngongae karkar mang.” ");
INSERT INTO sua_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ii! Va gi enang tok kat, mguaka vle enang a paei he kpetpaei kim o mia mo mmie kat. Ii, muta pat nngia mang a rengmat to kuon kia vul ko ngta giem a paei? A paei tkais kam tvok kim o mia ngaro kerok ko ngta sir ku kvokom? O-o, nove! ");
INSERT INTO sua_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Gi enang tok kat, a mhel nam lua giem a paei he kle ktotokim orom a plo kat e! Nove! Nam kle va kaendavloum a rek ko pgeik msim he kgiem, en kam mmok kim o mia tgus ruk ngat re kam vavaik kun mnam a rek to endo, mar kam smia nho ma mmok. ");
INSERT INTO sua_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","He kmikkiem enang tok kat, E Nut tkaendavloum a mmie he el muk ko pgegom o mia orom mularo keknen ruk lyar ko ngaka vle gi enang tok kat, mar kam valler o mia, o mia kam vokong ngar he le khover mu Teit tkuon ma volkha ekmar.” ");
INSERT INTO sua_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mguak or kam pat te, ko her aol kam vrengem E Nut karo pos kar karo rhek ruk mkor o propet e. Nove! Klo pis kam vrengem mar tok e. Ko le ktua pis kam talharik ha. ");
INSERT INTO sua_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ko smia mien ngang nguk te, ke pos ngaro rittiek ke gi vur vgon ngang kun mnam E Nut karo rhek, i o ke gur ke ngaekam ngang kat tho lo is hak kam nop e. Karo rhek tgus ngaka ktar kpis lmien kmel mit na, ktar mang a mmie va a volkha kam nop. ");
INSERT INTO sua_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","He ekam tok, ani mhel to nak kenhor mang ke gi vur pos ke mhe tang mnam endruk, to le kenang klenar kmikkiem ka kerkeknen to tok, va E Nut to nma vle kuon ma volkha nera grung orom a mhel to endo ka munik kun pgegom E Nut karo mia mruo tgus ruk ka tavgo ta vle kuo mang ngar. Vanang ani mhel to na kle sim kut kaikkiem o pos ri va smia kenang klenar kmikkiem mar tok kat, va E Nut ner kle khover a mhel to endo ka munik kun pgegom E Nut karo mia mruo tgus ruk ka tavgo ta komor mar. ");
INSERT INTO sua_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ii, o Parisiau ngartaro mur keknen mruo gi. Vanangko dok ko kle ktua havaeng nguk ge te, enangthe mgua lo sim ktua papat yok mang E Nut ktaro keknen he kir kim o Parisiau kar o pattermia kmo pos ngartakor ormar, va mut ho lo mi is hak kam vaik kun mnam E Nut karo mia ruk ka tavgo ta komor mar e.” ");
INSERT INTO sua_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Tennik mut ngan vgum muorres ko ngat havae te, ‘Ngior kam pormia, va endo na mia pormia, mar ruk laol ngak kael en kam yor kat.’ ");
INSERT INTO sua_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Vanangko dok, ko kle sim ktua talhar a re to endo ka pun ngang nguk tete te: Si endo nam gi kaesik ngang kaela, her E Nut to arhe ner le kut kael en kam yor ekam ka kerkeknen to kmesik tok arhe. Ii, va tok kat, mut ngan vgum muorres kat ko ngat havae te, ani mhel to nak reng kaela te, ‘Ila lpek ta tok,’ va en nak sir ko kim mor o Yuda ke murgun to e Sanhendren endo nma vongnek kim o rhek. Vanangko dok, kua talhar a re to endo ka pun ngang nguk tete kat te: Si endo na gi kermuyang kaela enang tok, va her E Nut to arhe ner le kut kael en kam kerkolkol vgum a kapnes to ngogu kim a paei to a vleir ko mGehina vat. ");
INSERT INTO sua_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","He ekam tok, enangthe ip re kmen ila nngiar ngang E Nut kuon ma psen to a totur, va re gia pat mang ila ko ta kser a vet kun pgegom mae, ");
INSERT INTO sua_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","va ngiak korim ila nngiar ko tok na ko ma psen, nang kmarer kaeknik ngok kim ila he ka lgem a guya pum, yek endo yek, ngiak kaeknik ka nngiar ngang E Nut. ");
INSERT INTO sua_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ii, va kmikkiem a papat to endo kat, ngiak marer kam ktar ksisrim o rhek kar ila imuo ko va ngaelaut kat ko tre kmit yin kam srim yim ko kim ke valngan to nma vongnek kim o rhek. Ii, ngia mamarer ktar ksisrim o rhek gi enang tok kam rum kim mar ko he, matok koknaik ila imuo na kle kael yin ko maktiegom endo nama momngan kar o mia, to en ner le kael yin ko maktiegom o toot kmo mia, mar kmenpasiker yin kun mnam a hengor. ");
INSERT INTO sua_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ii, va kua havaeng nguk lmien te, ko tok mnam a hengor to ngira vle mnam, ngir lo kais hak kam kat kottek mnam kais ko ngia ngae ho mi kut rum a keik to ngat el kuon mang yin kmen.” ");
INSERT INTO sua_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Va mut ngan muorres ko ngat havae kat te, ‘Ngior kam kpoot mang a lei. ");
INSERT INTO sua_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Vanangko dok, ngor le sim ktua talhar a re to endo ka pun ngang nguk tete kat te: Endo na gia vokom a vlom tang he kyor mang, va ta vle te, ther mia vret a vlom to endo he kpoot mang ka lei tok arhe kun mnam ka ngaung. ");
INSERT INTO sua_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","He ekam tok, enangthe ila keik to a yar nap koop kmin kam harpeet mnam a kerkeknen tang enang tok, va ngiaka ksir pum a kerkeknen to ila keik tkoop kim yin kmeharom he kpet kngam, gi enangthe a mhel ta kalagam ka keik mruo kat he kpet kngam ko tkoop kim kmeharom a kerkeknen kat. Va enangthe ila miktiek kat, ko en ila ktiek to a yar, nap koop kim yin kam harpeet mnam a kerkeknen tang, va ngiaka ksir pum a kerkeknen to ila miktiek tkoop kim yin kmeharom he kpet kngam gi enangthe a mhel ta kser ka miktiek mruo hak he kpet kngam kat ko tkoop kim kmeharom a kerkeknen. Ngiak pat tok, ekam ko te sei kam ya ngang in, yin kam mrua ngam ke mhe tang ngang yin mruo petgim yin, he kol a ktalhok to kam vle ko kim E Nut ngnik ngnik tok. Nang ner mi ktua kernonho hak ngang in, E Nut kam ngam ila vok tgus kun mnam a paei to a vleir to ko mGehina.” ");
INSERT INTO sua_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Va muorres ngat havae kat te, ‘Ani ngokol to npa svil kam kser ka lei, va naka ktar gi kaittiegom a hor tang to her gi kaen ngang ktavlom na, yek endo yek ngina lei na hera ksir.’ ");
INSERT INTO sua_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Vanangko dok, ko le sim ktua talhar a pos to endo ka pun ngang nguk tete te: Endo napa kser ka lei tok, her en arhe ther mi kaeharom ktavlom kam kpoot mang ngina lei tok arhe. Ii, va endo na lei orom a vlom to katngokol tlikim, va a ngokol to kat, ther mi kaeharom a kerkeknen to kam kpoot mang a lei tok kat arhe. Enang tok, a mhel tho lo is hak kam kser a lei. Vanangko a mhel tkais kam kser ka lei kmikkiem ke gi papat ta tuk te, enangthe tang nap kaol mang kaela ktavlom i o katngokol va kaela tkais kam kser ngina lei kmikkiem ke gi mhe to endo tuk.” ");
INSERT INTO sua_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Va muta ngan muorres ko tennik ngat havae kat te, ‘Mguak or kam kpoot mang mularo tnangal ruk mum kaelik ngang Ngoldaip, vanangko mgua kle va sim kaikkiem mar lsir.’ ");
INSERT INTO sua_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","36","Muta ngnek tok, vanangko dok, ko kle sim ktua talhar a re to endo ka pun ngang nguk tete te: A volkha ta vle ngang E Nut enang ka ngorsang, En kmorsang ko tok he ka nho mang o mia. Va a mmie ta vle ngang E Nut, En kmel kalo nhar kuo mang kat. Va e Yerusalem ta vle te, a rengmat to mkor A Taven To A Laut Hak. Va si ilaro ngairis mruo kat va ngat lo is kam hortgi kas o katvu kaikkiem ila svil mruo kat e. He ekam tok, mu or kam gi vrong re kvat o tgoluk ruk tok kmelel o tnangal. ");
INSERT INTO sua_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mguak kle va re kmel a tnangal, va mgua gia re lsir te, ‘Mare’ i o ‘Nove.’ Va ke lo re ngin ke lo gi vgon ennginduk arhe ngina gi kut kael mit lsir tok arhe. Vanang oni rhek ruk mut kaelik kuo malpgem enngindi kmel a tnangal ormar, ngat ottek ekam e Seten to tho mi kut kernonho hak.” ");
INSERT INTO sua_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Va mut ngan ko muorres ngat havae kat te, ‘Yi kais kmoripang ila ko enangthe npa pilgem ila keik agitgiang va ip kais kmoripang kam pilgem kta keik tok kat. Va npa pullom ila gu he ka gu ngang yin ta het va ip kais kmoripang kam pullom ka gu kat he kheter ka gu ngang ko agitgiang tok kat.’ ");
INSERT INTO sua_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mut ngan o rhek ruk tok, vanangko dok, ko kle sim ktua talhar a re to endo ka pun ngang nguk tete kat te: Mguak or kam serppak kim o mia ruk ngata kernonho mang nguk kmoripang ngar. Ii, enangthe tang mnam mar na spom ila pis to a miktiek va ngia hortgi kael langto na spom kat. ");
INSERT INTO sua_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Va enangthe a mhel tang na kael yin ko maktiegom endruk ngma vongnek kim o rhek, en kam kol ila yet va ngia kle mur kat kaen tang kat malpgem endo kat. ");
INSERT INTO sua_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Va enangthe a mhel tang npa kolaspa mang yin kam tolpum karo tgoluk ekam a ngaelaut ka vgon to agitgiang va ngia kle mur kat kaen yin kam tolpum karo tgoluk he ksuom a ngaelaut ka vgon tang kat kam ngam nglomin orom malpgem endo atgiang. ");
INSERT INTO sua_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Va enangthe tang na kaurur kmin mang o tgoluk va ngiak kaenik. Ii, ngiaka tting ngang kmel a tol ko kmin, he kaelik ngang kmikkiem ko tkaurur kim yin mang ngar.” ");
INSERT INTO sua_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Va mut ngan ko muorres ngat havae kat te, ‘Mguak kaelongtok mang mulenar, nang kle vu kaelat endruk ngam kael imuo ngang nguk.’ ");
INSERT INTO sua_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Vanang dok ko kle sim ktua talhar a re to endo ka pun ngang nguk tete kat te: Mguak kle kya pum endruk ngat kael imuo ngang nguk he kngarkie mang endruk ngma kol a regesal mang nguk. ");
INSERT INTO sua_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mguak kaeharom gi enang tok kam kolkol ekam mu Teit kuon ma volkha ekam ko mu Teit nam kaeharom a kolkha kam nan kim o mia ruk ngat ho mi kut kernonho hak kar endruk lyar kat. Va nma meng a kus kmerik mang endruk ngam sim kut kaikkiem E Nut karo pos kar endruk ngam lo sim kut kaikkiem mar kat. Mguaka vle tok, he mguera vle enang E Nut kles ruk ngma kolkol ekam ngar Teit orom ngaro keknen tok. ");
INSERT INTO sua_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","47","Mu sim pat na, enangthe mgua gia khen endruk ngam kaelongtok mang nguk va muk ormar, i o enangthe mgua gia khen mulenar ruk ngma rere kar muk va muk ormar tok kat, va mut lo kais hak kam kol a keik ko mkor E Nut e. Ko si o vrong rhek kar o kermia ruk ngam kaelha klol o takis kat, va ngam kaeharom tok ngang ngarlenar mruo. ");
INSERT INTO sua_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","He ekam tok, mguaka srim E Nut ka keknen, endo kam ya pum endruk ngat vu kaelat muk. Va mguak or kam vrua tu kim tang kam ya mang e, ko mgua ho mi kut kaisis tgus kngae ka ngmeang orom a keknen to endo kam kolkol ekam mu Teit tkuon ma volkha, ko En tho mi kut kais tgus kngae ka ngmeang.” ");
INSERT INTO sua_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Enangthe mgua re kmeharom mularo reha ruk ngang E Nut, va mguak ngangreal ngang nguk mruo kam or kam mrua het muk kam khenam mar ma mmok ko pum o mia ngaro kerok mar kam vokong ngar, matok mgua kle lo kta kol mula keik kuon kim mu Teit to E Nut tkuon ma volkha.” ");
INSERT INTO sua_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ii, ko enangthe ngia re kam nngiar ngang o mia ruk ngata tu kmo tgoluk, va ngiak or kmel votgem o mia orom a nglung kmikkiem enang ko endruk ngakro naprai alomin ko ngam kael votgem o mia kmeharom gi enang tok orom a nglung kun mnam o Yuda ngartaro rektor ruk kam rere mnam mar va ko po pnes, o mia kam mnor mang ngar he khover mar tok. Lmien te, mar ngma vle tok arhe. Vanangko, muk mguak or kam vle tok e, ko kua havaeng nguk te, ngat her kut kol ngarta keik vgum o mia ngatngae her tok arhe. ");
INSERT INTO sua_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Vanangko langto langto mnam muk ngia re kam nngiar ngang o mia ruk ngata tu kmo tgoluk, va ngior kam mas orom E Nut kam tger ila ksienga kam vaeng o mia ngok kim in kam kenang ngar ila ngaeha to endo ko ya re kmeharom orom ila miktiek. ");
INSERT INTO sua_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","He ekam tok, enangthe ipa nngiar la tvok kim o mia ngaro kerok enang tok, va iTeit to nma vokong ilaro reha ruk im kaeharom mar la tvok tok, ner le kaen a keik ngang in kmikkiem enang tok kat.” ");
INSERT INTO sua_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Va tok kat, ko endruk ngaro naprai alomin ngam vua svil kam sir ko pum o mia he vua ngarkie ko pum ngaro kerok kun mnam o Yuda ngartaro rektor ruk kam rere mnam mar va ko po pnes kat, o mia kam vokom mar tok kat. Ii, lmien ngma vle tok arhe. Vanangko muk, mu or kam vle tok e, ko kua havaeng nguk te, ngat her kut kol ngarta keik vgum o mia ngatngae her tok kat arhe. ");
INSERT INTO sua_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nangko yin langto langto, ngiaka svil kam ngarkie, ngiak vaik kun mnam ila rek yin tuk he kvat ila ngaegot he kngarkie ko tok ngang iTeit to ngom lua vokom, he En, to nma vokong ilaro reha ruk im kaeharom mar la tvok tok, En ner le kaen a keik ngang in kmikkiem enang tok kat. ");
INSERT INTO sua_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ii, va mu or kam vua petpet o rhek kam hoger mularo ngarkie ngang E Nut kat e. Pat he nok muk o vrong rhek ruk ngat lua mnor mang E Nut vor ko mar ngam vua petpet o rhek ngang ngaro Nut ruk la ppiagar. Ii, ko mar ngma petpet o rhek ngang ngar enang tok, ekam ko ngma pat te, ngaro Nut ruk la ppiagar ruk endruk ngara ngan vgum mar ekam ko ngam vua petpet o rhek ngang ngar gi enang tok. ");
INSERT INTO sua_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Vanangko muk, mguak or kam petpet o rhek ngang mu Teit enang tok e, ko ta mnor mang o tgoluk ruk muta tu kmar, ktar mang ko muma re kmaurur kim mang ngar. ");
INSERT INTO sua_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","He kmikkiem enang tok, mguak kle va kngarkie enang ti: ‘Ngor Teit tkuon ma volkha ila munik tho mi kut laut hak. ");
INSERT INTO sua_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Va ngot kaurur kmin te, Yin kmaottam ila svil mruo to mang ila tavgo kam vaas kim o mia tgus mo mmie he komor mar tgus kmikkiem enang ko ye her aottam ila svil to mang ila tavgo to kuon ma volkha ko ther vaas kim endruk kuon ma volkha enang tok kat. ");
INSERT INTO sua_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Va ngot kaurur kim yin kat te, Yin kmeha vgum mor ma kolkha langto langto. ");
INSERT INTO sua_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Va ngot kaurur kim yin te, Yin kam lol nguaro kerkeknen patgiang ngaiting kmikkiem gi enang ko ngot lol ngorlenar ngaro kerkeknen ruk ngat eharom mar ngang ngor patgiang ngaiting tok kat. ");
INSERT INTO sua_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Va ngot kaurur kmin kat te, Yin kmenserpagam mor kat kam lo mrua ngam mor mruo ekam o ngaegom ruk ngak pis kim mor kat. Vanang ngiak kle va kpet mor petgim e Seten to tho mi kut kernonho hak. Ngiak kaeharom tok ekam ko her Yindo arhe ima vle ngnik ngnik orom ila serppak kar ila mmok, va mor ruk ilaro mia ngoma vle ku meorom ila tavgo.’ ");
INSERT INTO sua_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ii, mguak ngarkie gi enang tok he klol mulenar ngaro kerkeknen patgiang ngaiting enang tok to mu Teit vat tkuon ma volkha ner kle klol mutakor patgiang ngaiting gi enang tok kat. ");
INSERT INTO sua_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Vanang enangthe mgua lua lol o mia ngaro kerkeknen patgiang ngaiting he kikiangae mang ngar, va mu Teit kat ner lua lol mutakor patgiang ngaiting he lua kikiangae mang ngar kat e.” ");
INSERT INTO sua_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Va mguak paal kmo ol ko pum E Nut kalo keik va mguak or kam mrua pis ormuk ma mmok ko pum o mia kat e. Pat he nok muk endruk ngaro naprai alomin vor ko mar ngam gia pis ormar mruo ma mmok ko ngam mia nho lnganngannes kam kenang o mia te, ngata paal kmo ol ko pum E Nut kalo keik. Ii, lmien ngma vle gi enang tok arhe. Vanangko kua havaeng nguk te, ngat her kut kol ngarta keik vgum o mia ngatngae tok arhe. ");
INSERT INTO sua_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Vanangko muk, mguak paal kmo ol ko pum E Nut kalo keik va mguak kle smia nho lsirei, kmeharom tok la tvok o mia kam vokom muk he lua mnor mang nguk te, muta paal kmo ol e. Enang tok, mu Teit to ngom lua vokom, En nma vokong mularo reha ruk la tvok tok, to En ner le kaen a keik ngang nguk kmikkiem enang tok arhe.” ");
INSERT INTO sua_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Va mguak or kmel mularo gol ngo pneik ktar ko pum mularo kerok he kaelpas orom mar mo mnam a mmie ta. Ko o soma ngma papaam mar va a mou ka groop nma kering ngar kam lpus va kle o ngauruvik ngat kais kat kam halker mularo rektor he kvaik kaururik kat. ");
INSERT INTO sua_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Vanangko mguak kle va kael E Nut ktar ko pum mularo kerok he kaelpas orom En kun mnam mularo vurkul enangthe En muta gol ka pun to mut kaelpas orom kuon ma volkha. Ko ko tok kuon ma volkha, o soma va a mou ka groop ngint lo kais kam kering e, va o ngauruvik ngat lo is kam halker o rektor he kvaik kaurur kat e. ");
INSERT INTO sua_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ko ani tomhel to mut kaelpas orom kun mnam mularo vurkul te, mula gol ka pun, va her a tomhel to arhe mguera sovet kmel ktar ko pum mularo kerok kat. ");
INSERT INTO sua_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","24","Kmikkiem a papat to endo tok, a kalyie tang tlo kais kmel klo taip ngang ktar ko pum kalo keik kmeha ngang ngin tgus ko alomin e. Nove! Ko enangthe na re ka vle tok, va nera namlolo pum min kam ya pum tang, nang kle kernonho mang langto. I o ner kaeha lserppak ngang tang, nang kle kaitgung langto. Va kmikkiem enang tok, muk kat mut lo kais kat kam kaum kael E Nut va mularo gol ngo pneik ko pum mularo kerok tok kat e. Kmikkiem a papat to endo tok, ilalo keik nginma khenam a mmok ngang in kat. Va enangthe ilalo keik nginp smia ya he kol a mmok, va ngir ho gia vle yin tgus hak orom a mmok, nang nop ke vur mhe ngang in orom a slommok e. Vanang enangthe ilalo keik nginp kle kernonho he lua kol a mmok va nginera ngae ho mi ktua slok hak, va yin ngir ho gia vle yin tgus hak orom a slommok, nang nop ke vur mhe ngang in orom a mmok kat e. He ekam tok, ngiak ngangreal ngang yin kam smia kol a mmok, matok koknaik ngira senkrip kim ke mmok to kun mnam yin ko ka mi mit msim ta kle mia vle te, a ho slommok hak he.” ");
INSERT INTO sua_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","E Yesus ta re tok, to kle kreng kalngunes te, “Ekam tok, kua havaeng nguk te, mguak or kam vua ngaungputput mang mula ngorsang te, anito kmem, kmivie i o, oni tgoluk ruk mang mularo pkor kmegenkarik kat e. Pathe nok muta pat te, mularo olngaemik ngat laut he gi kir kim mularo ngorsang vor? I o, nok pathe mularo it ngata laut kir kim mularo pkor kat vor? ");
INSERT INTO sua_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mu vokom o iningol kuo kia gan na, ko mar ngam lua kap o tgoluk e, va ka lluol e. Va ngam lua kaelpas orom o olngaemik kun mnam ngakro ngainir kat e. Nove! Ngam lo kaeharom tok, vanangko mu Teit to tkuon ma volkha nma klang ngar mlol ge. To muk, muta pat nngia, E Nut nma khen mar kam smia tar mar, nang kle kikiangae mang nguk gi? ");
INSERT INTO sua_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mu havaeng dok na, erieto mnam muk tkais kam vrua hoger ka ngorsang mo mmie kam vur kta hok ko enangthe nam vua ngaungputput mang o vu tgoluk? ");
INSERT INTO sua_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","He ekam tok, kman ko mum vua ngaungputput mang mularo it tok. Mu pat mang o ngaergot ngakro rehi na, ko ngam mrua sreng ngar mruo orom ngartaro sreng nngia? Ko ngam lua pum ngaro katam kmegenkarik e. Nove. ");
INSERT INTO sua_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Vanangko kua havaeng nguk te, si e Solomon ko en karo it ruk nma pasrengem en mruo ormar ngaro vu kraen hak, vanangko en tlo kais mang o ngaergot ngakro rehi ruk e. Ko E Nut nma pasrengem mar kir kim e Solomon ktaro sreng ruk endruk. ");
INSERT INTO sua_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ii, mu vokom na, si o ngaergot ruk endri oguon mail ngam gi vrua vle nong ke laut e, to hera vui, to o mia ngam her gia ngampaei pmar, vanangko E Nut nam sim ktua pasrengem mar ge orom ngaro rehi enang tok. He ekam tok, enangthe E Nut nma pasrengem o ngaergot orom ngakro rehi enang tok, va muta pat nngia? En tlo kais ge kam smia tar muk orom o it kam pasrengem muk tok kat kir kim mar? E-e, muk ri arhe mut ho mi ktua kenhor mang E Nut hak! ");
INSERT INTO sua_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","He ekam tok, mguak or kam vua ngaungputput mang anito kmem va anito kmiviem va anito kmegenkar kat. Ii, mguak or kmel o tgoluk ruk endri ktar ko pum mularo kerok tok, ");
INSERT INTO sua_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ko her o vrong rhek ruk arhe ngam kael ngaung mang o tgoluk ruk endruk kmel mar ktar ko pum ngaro kerok enang tok arhe. Nangko mu Teit to tkuon ma volkha ta mnor he te, o tgoluk ruk endruk muma tu mang ngar. ");
INSERT INTO sua_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ii, mguak or kam vua riring ngar, nang mguak kle va kael E Nut ka tavgo ktar pum mularo kerok he ktagur pum E Nut ka ngaeha to kam srim mar ko kim kalo keik, he nang ka tavgo to endo kam vaas kim o mia kam komor mar tgus. Ii, ngiak kael E Nut ka tavgo ktar ko pum mularo kerok tok na, yek E Nut ner kle kaen o tgoluk ruk endruk ngang nguk kat. ");
INSERT INTO sua_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","He ekam tok, mguak or kam vua ngaungputput tete mang o vnek ruk ngara pagis koknaik kat ge, ko a kolkha langto langto karo mur kut vnek mruo ge he mut lo kais kam kaum klol mar tgus kun mnam a kolkha to atgiang e. He ekam tok, mguaka mnang endruk ngara pagis koknaik he ktua paneng ngartaro mur kolkhek mruo. Mgua kle gi pat mang endruk tuk ngat pagis kim muk gi tete ta.” ");
INSERT INTO sua_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Va mguak or kam tutut kam mon o mia orom ngaro kerkeknen, matok E Nut nera mon muk gi enang tok kat orom mutaro kerkeknen kat. ");
INSERT INTO sua_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ko kmikkiem enang a vnek to mut kael kam mon mulenar orom ngaro kerkeknen tok, E Nut ner sim kut koripang nguk kmikkiem a vnek to endo kais tok kat arhe. ");
INSERT INTO sua_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ngola, im smia kellu mang kam vokom a kvak to kun mnam inopia ka keik, nang lua paptang a ho kla vgon ko pita keik mruo? ");
INSERT INTO sua_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hai-e, to yi kais kam smia nho nngia he kmon inopia orom ka kerkeknen to ta vle enang a gi kvak kun mnam ka keik, vgum ita kerkeknen tok kat ko ta vle enang a ho kla vgon kun mnam itang? ");
INSERT INTO sua_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","O-o mularo naprai alomin hak! Ngiaka ktar khong a ho kla vgon ko pila keik mruo na, yek yin kam le smia nho kam le kpet a kvak to ko pum inopia kta keik vat.” ");
INSERT INTO sua_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","To e Yesus ta koka ngang o mia kat te, “E Nut tel a totu mang ka tavgo ko tkaenang a gol ka pun, he ekam tok mguak or kam koham E Nut ka gol ka pun to endo kmenik ngang o mia ruk ngat kaenang o pendol, matok nga kaesik he kle kaeknik kaelat muk kirpapaam muk ka ngmeang. Ii, mguak or kam koham E Nut ka gol ka pun to endo kmen ngang o mia ruk ngat kaenang o morek kat e, matok nga karkar mang he kenekerik.” ");
INSERT INTO sua_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Vanang mguak kaurur kim E Nut mekam mekam mang o papat ruk mang ka tavgo to endo he En ner kaen ngang nguk. Ii, mguak riring ngar ge ko vgum E Nut kat he En ner mrua khenam mar ngang nguk. Va mguak vae ngok kim E Nut mekam mekam, muk kam vaik ku meorom ka tavgo he En nera koregot kim muk kam vaik. ");
INSERT INTO sua_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ii, ta vle tok arhe ko ani mhel to nam kaurur kim E Nut mekam mekam mang ka tavgo, en nma kol ko mkor. Va ani mhel to nma riring o papat vgum E Nut mekam mekam mang ka tavgo kat, en nma pis mang ngar ko kim En kat. Ii, va ani mhel to nma vae ngok kim E Nut mang mekam mekam kat, E Nut nma koregot kim en, en kam vaik ku meorom ka tavgo. ");
INSERT INTO sua_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ii, mu vokom na, erieto mnam muk tkais kmen a kre ngang kalyie kmem enangthe npa mnganang mang a bret. ");
INSERT INTO sua_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","I o nap kais kmen a vim tang ngang kmem enangthe npa mnganang mang a slang tang? ");
INSERT INTO sua_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","He ekam tok, si muk ruk mularo kerkeknen ngat ho mi kut kernonho hak, vanangko mum kle sim ktua klang mu les ge orom o tgoluk ruk lyar, gi ekam ko ngat gia mnganang nguk mang ngar. Vanang muta pat nngia mang mu Teit to tkuon ma volkha? En tho lo kais ge kam ho ksovet kam klang kles ruk muk tok kat orom o tgoluk ruk lyar, gi ekam ko muma mnganang En mang ngar enang tok kat? ");
INSERT INTO sua_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yu! He ekam tok, oni keknen ruk muma svil mulenar kam sim kaeharom mar ngang nguk, va muk kat mguak sim kaeharom mar ngang mulenar kmikkiem gi enang tok kat. Mguak kaeharom gi enang tok ekam ko a papat to endo ta vle te, mor o Yuda nguaro pos va nguaro propet ngaro rhek nga pun msim to ngata sir kuo malpgem.” ");
INSERT INTO sua_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","To e Yesus ta kta koka ngang o mia te, “A ven to ta ktong o mia kmel mar ku meorom E Nut ka tavgo, mar kam kol a ktalhok to kam plong vle ko kim En ngnik ngnik, tvua kellet kmikkiem, he gi o mia lgititge ngam kaikkiem kam pis ko vgum ke gu he kvaik ku meorom ko tok. Vanangko a ngaelaut langto ta klup kta gu tvua slai he ka ktong o mia kam pis mnam a mhe to kam kol a yor. A ngaelaut to enda tkongeik kmikkiem, he o mia kavurgem ngam kaikkiem kam pis ko vgum ka gu to tvua slai. Vanang muk, mguak kaikkiem ke ven to tkoka kaut.” ");
INSERT INTO sua_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Va mguak ngangreal ngang nguk mang o propet ruk la ppiagar ko ngaro keknen ngat kaenang o pendol. Ii, ko mar ngam pe gia ngam mang ngar kam mur kael mar mruo enang o hip he kpis ko kmuk enang tok kam kering mularo papat. Ngata nho lya kuo mang ngaro pkor, vanangko ngaro keknen ngat ho mi ktua kernonho hak. ");
INSERT INTO sua_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Vanangko mut kais kam vokom ngaro keknen he kam mnor mang ngar, gi enang ko muma vokom o hi ngaro miel he ka mnor mang ngar tok kat. Ko o mia ngam ngae lua tamar o paslura ko vgum o kosmur e. Nove. Va o mia ngam ngae lua tamar o gaenip ko vgum o gigi kat e. Nove. ");
INSERT INTO sua_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","He kmikkiem enang tok, o hi tgus ruk lyar ngam kaehi orom ngaro miel ruk ngta ya kat. Ii, nang o hi tgus ruk nong lyar ngam kle kaehi orom ngaro miel ruk nong lyar kat. ");
INSERT INTO sua_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Enang tok, a ho to a yar tho lo mi kais hak kmehi orom karo miel ruk nong lyar e. Va a ho to nong a yar tok kat tlo is kmehi orom karo miel ruk lyar kat e. ");
INSERT INTO sua_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","He ekam tok, o hi ruk ngam lo kaehi orom ngo miel ruk lyar, o mia ngam kovverik he kngam mar oguo kia paei. ");
INSERT INTO sua_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ii, va mguer kais kam mia vokom o propet ruk la ppiagar ngaro kerkeknen he kam mnor mang ngar tok kat, gi enang ko muma mnor mang o hi ruk nong lyar ko ngam kaehi orom ngaro miel ruk nong lyar kat.” ");
INSERT INTO sua_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ii, kua mien tok arhe ko mguak or kam pat te, o mia tgus ruk ngam gia kvam dok te, ‘Ngoldaip, Ngoldaip,’ ngara vaik ku meorom E Nut ka tavgo e. Nop hak! Gi o mia ruk ngam sim kut kaikkiem E Titou to tkuon ma volkha ka svil, her gi mar ruk arhe ngara vaik ku meorom ka tavgo. ");
INSERT INTO sua_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Enang tok, ko mnam a kolkha to a kser kim, o mia kavurgem ngar kaur kim dok te, ‘Koldaip-o, te kom lua havaeng o mia mang yin orom ila serppak gi? Va kom lua kerer o kool orom ila serppak kat gi? Va kom lo kaeharom o reha kavurgem ruk lserpgue hak orom ila serppak kat gi?’ Ngar kaur kim dok tok ");
INSERT INTO sua_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","vanangko ngora likim mar lsir pum ngaro kerok he ka klai mang ngar te, ‘Ko ngae ho lo ktua mnor mang nguk hak! He mu ehenok petgim dok, muk ruk mum kael mularo yaik ngang E Nut he kaeharom o keknen ruk ngat ho mi kut kernonho hak.’” ");
INSERT INTO sua_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“He kmikkiem enang tok, endruk ngma lol kuaro rhek ruk endri he kaikkiem mar mekam mekam ngat kaenang a mhel to te smia ngangam kim ko tsim kaeharom ka rek to tvua serppak ko thong a nho ngku hak he kvat o ngtek ko engnang a kre to klalaut kun mnam a mmie. ");
INSERT INTO sua_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ta hover krum, to a ngausgi tsi kaol he ka spom ka rek klik va a kus tsi kaerik he a ye tkottek to ka lel ta klung engnang ka rek he kaegom kam kol, vanangko tlo kais kam lget e, ekam ko karo ngtek ngat gi serppak ngae gi ringring hak ku engnang a kre kun mnam a mmie ko tsim kut papuntom hak. ");
INSERT INTO sua_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Vanang endruk ngma vongnek kim kuaro rhek ruk endri, nang kle gi kaengnam mar, mar ngat kle kaenang a mhel to tlo smia ngangam kim en ko tlo sim kaeharom ka rek ko tgi ngam kuon ma vui. ");
INSERT INTO sua_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Thover krum to a ngausgi tkaol he ka spom ka rek klik va a kus tkaerik he a ye tkottek to ka lel ta klung engnang ka rek to her gia kvet kol kngorom ngatngae.” ");
INSERT INTO sua_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","A mumu ta vle kvongnek kim E Yesus karo rhek ko ta patter mar ormar tok knop, to ngate sei kmit ngaongtok kim karo rhek ");
INSERT INTO sua_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ko en tle ktua patter mar orom kta serppak mruo to yok gi, nang nong orom ke serppak to mkor o pattermia kmo pos e. ");
INSERT INTO sua_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","E Yesus ta rum karo rhek kuo kia vul, to thera grung kpis ku, va o mumu ngta veet kaikkiem kat. ");
INSERT INTO sua_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ngta ngae va vgum a mhel to tkol a yor to a lepra ko tpis ko kim e Yesus he ktubulkek ku penharom he kaurur kim te, “O, Kolaip, enangthe ngia svil va yi kais kmeharom dok, he dok kam kta vle la mmok ko pum E Nut kalo keik kat.” ");
INSERT INTO sua_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","To e Yesus ta tuom ka ktiek he gi kaehang va gia reng te, “Mare, kua svil! Ila vok na ngae gia mmok.” A gi hi to tgia re tok, ka yor ther gi nop kuo mang ngatngae va ther ngae gi mmok ko pum E Nut kalo keik kat. ");
INSERT INTO sua_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","To e Yesus thera reng te, “Ngiak or kam havaeng a mhel tang hak mang a ngaeha to ko eharom ngang yin. Vanang ngiak kle va kngae ngok kim a pris tang, en kmehehang yin, en kam tting mang in te, lmien te, yi ho mi mmok kat ko pum E Nut kalo keik. Ngiak kaeharom tok, to kle kngae ngok mnam E Nut ka maksien kam nngiar ngang E Nut, kmikkiem enang ko e Moses ka pos langto ta keknen tok mang a yor to endo ko yi her ottek mnam he. Ngiak kaeharom gi enang tok, nang o mia ngaro ngaongtok kmisis mang yin te, lmien te, yi ho mi mmok kat ko pum E Nut kalo keik.” ");
INSERT INTO sua_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","E Yesus teharom tok, to her kle kngae kpis kvaik kun mnam a rengmat to e Kaparnam. Ko tok a mhel to en a vrong rhek langto tpis ko kim he kaurur kim te, en kam turang. En lRom nga ngaomevek ka rkan langto ngalaip. ");
INSERT INTO sua_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tpis to kreng te, “Koldaip, kolkayie langto ta kru ku mrek ko te sei kam nganngannes hak orom ka yor to a gigruk ko tngae ho mi kut panaem hak.” ");
INSERT INTO sua_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","E Yesus ta ngnek tok, to koripang te, “Yu, ngor kaikkiem yin ngok mrek he kaeharom ilkayie, en kam kta ya kat.” ");
INSERT INTO sua_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Va a mhel to endo tkoripang te, “O-o, Kolaip dok klo vu eveep is miik, yin kam mrua ppir miik kmaol ngte kim dok e. Vanangko ngia her gia mon a re ke vgon tang, yek kolkayie ka yor na her gia ngan vgum yin he knop kuo mang. ");
INSERT INTO sua_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yi kais kmeharom tok, ekam ko gi enang dok kat koma ngan vgum endruk ngta laut va ka nho mang dok, vanang le kreng endruk ngma kar va tomten mko meorom dok kat ko kua nho kmar va mar ngam her gia ngan vgum dok kat. Ko kom re gia reng a mhel ta te, ‘Ngae,’ va en nam her gia ngan vgum dok he kngae. I o kom re gia vaeng a mhel to en tko gut te, ‘Aol, ngte kim dok na’ va en nam mi kaol ngte kim dok. Va kom re gia reng kolkayie kat te, ‘Eharom a ngaeha ta,’ va en nam her gia ngan vgum dok he kaeharom.” ");
INSERT INTO sua_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","E Yesus ta ngan karo rhek ruk endruk ko ngat kaeti te, tvu kor mnam en mang en tok, va tho mi kut senkrip hak, to kreng a mumu to ta veet kaikkiem te, “Kua havaeng nguk te, a mhel ta en tpua vle te, en a vrong rhek langto tvu kor mnam en mang dok hak, vanang si kun mnam muk lIsrael lsir hak klo vur pis mang tang ko tkor mnam en mang dok enang ti e. ");
INSERT INTO sua_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","12","Ii, ta sir tok ko, kua havaeng nguk te, tennik, muk lIsrael, E Nut ther ktar kmon muk mang mularo ngaekmol ruk mguak lol ko mguak tuur kun mnam ka pnes to nera kpom mnam a kolkha to ka tavgo nak komor o mia tgus. Vanangko o vrong rhek ngar le kottek ko mnam a mmie kalo ngaiting ruk ngma nku va ngma nkuon he kaum kam liepum muk kam lol mularo ngaekmol ko tok, mar kam kle ktua tuur mnam E Nut ka pnes kar e Ebrehem va e Isak va e Yakop. Ii, ngara pis enang tok he klol mularo ngaekmol kam lol ngang ngar mruo, nang E Nut ner kle ktua likim muk ruk ta ktar mon muk kam vle ku meorom ka tavgo, kngam muk ngku mnok ma slommok petgim karo mia ruk ka tavgo ta komor mar. He enang tok, mguer kle va ka vle ku mnok he ksovet kmeteti he khem mularo ngnorok mo kmar.” ");
INSERT INTO sua_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","E Yesus thavae tok ngang a mumu to endo knop, to kle kreng lRom nga ngaomevek ka rkan langto ngalaip to endo te, “Ngiak ngae he, ekam ko ngor kaeharom ilkayie kmikkiem enang ko yi her kor mnam yin mang dok kmeharom tok arhe.” Thavae tok ko kim a mhel to endo, nang ko mrek kalkayie ther gi ya ngatngae gi kun mnam ke vgon to endo ge ko e Yesus ta re tok. ");
INSERT INTO sua_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tie ma kolkha langto e Yesus ta vaik kun mnam e Pita ka rek va tvokom e Pita ka snerip to a vlom ko ta yayor he ka kru ko ma hep ko a manakain ta ngae kun mnam. ");
INSERT INTO sua_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tpis ko kim a vlom to endo he gi kaehang ka ktiek va a manakain ther gi nop kun mnam hak. To a vlom to endo ther gia hop ku to hera krong o ol ngang. ");
INSERT INTO sua_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","To mnam a kolkha to endo gi ko a kolkha ther vaik he, va o mia kavurgem ruk o kool ngat viging ngar, ngarlenar ngata plalam mar kam pis ngok kim e Yesus. Va e Yesus tkaeharom mar orom ka re ke gi vgon kam kerer o kool mnam mar. Va tkaeharom langto langto tok pum ngaro yor ngo mamten tgus. ");
INSERT INTO sua_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Vanangko E Yesus nam kaeharom o reha ruk endruk kmaottam E Nut ka propet to e Aisaia karo rhek ko e Aisaia ta ktar kpavap mang ormar te: “Nguaro nganngannes va nguaro yor en mruo tmur petik petgim mor.” ");
INSERT INTO sua_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","To e Yesus ta tar ko o mia ka ho vurgem hak ngta gun mang, to thera reng kalngunes kam poe kenker a ngaenker ngoguon pa ngaiting to ngkun kuon. ");
INSERT INTO sua_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","E Yesus tre kam kar mnam a langail va vgum a pattermia kmo pos langto ko tkaol kpis ko kim he kreng te, “Pattermia, ngor mi kaikkiem in ngok mnam oni mhetor tgus ruk ngiak ngae mnam mar.” ");
INSERT INTO sua_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Va e Yesus tkoripang te, “O-o, yi her ketoptop kmikkiem dok he, ko si o pendol ngartaro nhotor ruk kmonit mnam mar, va o iningol ruk kuon kia gan ngaro ngainirik kat, vanang A Mhel To Nkong Man Ma Volkha nop ke vur ngaekam tang ngang, en kam vur konget ka sai e.” ");
INSERT INTO sua_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","E Yesus ta re tok, to kalkayie langto vat thavaeng te, “Kolaip dok kat, vanangko ngiaka ktar gi vur orim dok na, he E Titou na yor na, he ngua eguyang, to endo yek ngua le kaikkiem yin kat.” ");
INSERT INTO sua_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Va e Yesus, tkokheng te, “Nove! Ngiak kaikkiem dok gi tete ha, he mnang o mia ruk ngara yor he koknaik lua kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik mar kam mrua kaeguyang ngaro mur yoror mruo.” ");
INSERT INTO sua_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","E Yesus thavae tok, to ta kar kun mnam a langail to endo he kalngunes ngat kaikkiem kam kar kun mnam kat. ");
INSERT INTO sua_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ngta ngae va ngat lua mnor te, a tomhel tang nera pis kim mar e. Ngata poe kpoe, va vgum a kalivurvur ko tkaenpgam a ngaenker he o vlung ngta klung engnang a langail he ksovet kam karir nkun mnam va a li ta klang kat he ta re kam ho gia vvuo ormar hak. Vanang e Yesus tonit. ");
INSERT INTO sua_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","To kalngunes ngata ngae ko kim he kvotgem to khavaeng te, “Ngoldaip, ngiak sulgim mor ko ketasuo mor kam vvuo he.” ");
INSERT INTO sua_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","To e Yesus ta psom mar te, “Her muk ruk arhe muk ruk mut ho mi ktua kenhor mang dok hak! Kman ko mute ksei kam gor?” To ta kle khop ksir he gia rere kam kser a ngausgi va o vlung, to ngint her mia nop to ngae gi nning. ");
INSERT INTO sua_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","To kalngunes ngta vokom tok, to ngat ngae gi mrua sor kmar kim, to hera mo mnganang ngar mruo te, “Hai-e! Ani mhel ta, ko si a ngausgi va o vlung ngata ngan vgum kat ge?” ");
INSERT INTO sua_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","To e Yesus mar ngata poe kngae kpis ko mnam a mhe to mkor lGadara ogut pa ngaenker ka ngaiting to tigut. Ko tok alo mhel ruk o kool ngat kaenvevem min nginma vle kun mnam o nhotor ruk mkor o yoror. O kool ruk ngata viging ngin ngat ho mi kut serppak hak kun mnam min he o mia ngma gor kam ngongae ekam a ngaelaut ka vgon to ko rkieng ngin. To alo mhel ri ngint kottek ko pum nginalo nho ruk mkor o yoror he kaol pis ko kim e Yesus ko va ngaenker. ");
INSERT INTO sua_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nginta pis ko kim, va vgum a koot langto kun mnam langto mnam min ko ta rere klik te, “E Nut Khal Msim to yin he ngot lua mtom yin kam pis ktoop kim mor mo e. Va kman ko ya kaeloong mnam a kolkha to E Nut tmur el kmen a kapnes ngang ngor ruk o kool he kpis moti kam kering ngor tete?” ");
INSERT INTO sua_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Vanang, ko tok rkieng ngar, o morek nga murgun to klalaut ngta hohek ko rkieng a veik ka ngaiting. ");
INSERT INTO sua_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","To o kool ruk ngata viging ngin ngta kle kaurur kim te, “Enang ko ngiak pet mor petgim alo mhel ri va ngiak meng ngor kam vaik kun mnam o morek ruk ngata hohek ko guon ho.” ");
INSERT INTO sua_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ngata re tok, to e Yesus ther gia reng ngar te, “Yu, mguak ngae he!” Tgia re enang tok, to ngat kottek mnam alo mhel ruk ennginduk, nang kle kngae kviging o morek. Ngata viging ngar, va vgum o morek tgus ko ngat her gia kolaspa kam sap ngpirik ekam a veik kam ngae kpis kvuvvuo kun mnam a ngaenker kyayor tgus ngmeang. ");
INSERT INTO sua_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","To o toot kmo morek ngta ngorpok ngok mnam a rengmat ka pun he khavae mang o morek va mang alo mhel ruk o kool ngat viging ngin kat. ");
INSERT INTO sua_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","E Yesus ta vle ko tok, va vgum o mia kavurgem ruk kun mnam a rengmat to endo ko ngat hera veet kpis ko kim kam vokom. Ngata vokom ko tok, to ngat kaurur kim, en kam ehenok petgim mar, he lo kta vle ko mnam nga mhe kat. ");
INSERT INTO sua_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","To e Yesus mar ngat her kta kar mnam a langail he kta kenker a ngaenker to le kngae kvaar mnam ka rengmat msim. ");
INSERT INTO sua_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ngata pis, va vgum o mia ko ngta kokol a mhel langto orom ka hep ko ta kru mnam ko ka vok tgus tyor. Ngat pis ngok kim e Yesus va e Yesus tvokom mar ko ngat vu kor mnam mar mang en enang tok, to thera reng a mhel to endo te, “Kambis, ngiak sirei na, ko dok mruo ko lol ilaro kerkeknen patgiang ngaiting he kikiangae mang ngar hak.” ");
INSERT INTO sua_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","E Yesus ta re tok, va vgum akuruk mnam o pattermia kmo pos ko ngata rere kun pgegom mar mruo te, “Hai-e, en ta kerrereng E Nut ka munik enang tok arhe!” ");
INSERT INTO sua_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nangko e Yesus ther tar ngaro papat ko ngat vua rere porom mar enang tok, to ta kle ka mnganang ngar te, “Kman ko mularo vurkul ngma tagur pum o kerpapat ruk endruk he ka mngan pum kua serppak to kam lol o mia ngaro kerkeknen patgiang ngaiting he kikiangae mang ngar tok? ");
INSERT INTO sua_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ani ngaeha to ta koppet kam khenam ma mmok? A ngaeha to kam gi reng a mhel ta te, ‘Ko lol ilaro kerkeknen patgiang ngaiting,’ i o endo kam mi kaeharom a mhel ta, he en kam mia hop he kngae ko pum mularo kerok? ");
INSERT INTO sua_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Vanangko tgia ya kat e, ko ngor mia khenam ma mmok ngang nguk te, E Nut tmi kaen a serppak ngang A Mhel To Nkong Man Ma Volkha to dok, dok kam lol o mia ngaro kerkeknen patgiang ngaiting mo mmie he kikiangae mang ngar.” Thavaeng ngar tok, to her gia reng a mhel to ka vok tgus tyor te, “Hop he, tolpum ila hep he kngae ngok mrek.” ");
INSERT INTO sua_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","E Yesus tgia re tok, to a yor to endo ther gia hop sir he kngae ngok mrek. ");
INSERT INTO sua_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nang a mumu to alautar tvokom tok, to a pagor ta komor mar. To ngat hera guyaya pum E Nut mang ko ther mi kaen a serppak ka mten to endo tok ngang o mia. ");
INSERT INTO sua_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","E Yesus teharom tok, to hera parem a mhe to endo to kta ngae va tvokom a mhel langto ka munik e Matyu ko tkorsang kun mnam o kermia ruk ngam kaelha klol o takis nga rek to kmelpas mnam. E Yesus tpis ko kim to kreng te, “Ngiak kaikkiem dok!” To e Matyu ther gia hop to her gi kaikkiem. ");
INSERT INTO sua_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kam ngae, to mnam a kolkha langto e Yesus kar kalngunes ngta kaum kaemik kun mnam e Matyu ka rek. Va o kermia kavurgem ruk ngam kaelha klol o takis kar o Yuda akuruk, endruk o Yuda ngalmialaol ngma keyang ngar ko ngam lo sim kaikkiem ngaro keknen, ngata kaum kaemik ko kim e Yesus kar kalngunes kat. ");
INSERT INTO sua_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","To o Parisiau ngata vokom ko e Yesus tkaum kaemik kar mar tok, to hera kirhek pum e Yesus kam palsie kim kalngunes te, “Kman ko mula pattermia tkaemik ko kim o kermia ruk ngam kaelha klol o takis kar o Yuda akuruk, endruk ngolmialaol ngma keyang ngar ko ngam lo sim kaikkiem mor o Yuda nguaro keknen?” ");
INSERT INTO sua_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","E Yesus ta ngnek tok, to tle ktootkinre kmoripang ngar te, “Muk, mguak lol o papat mang E Nut ka re to enda na, he smia ngangam kim muk ekam, ko E Nut ta re orom karo mur rhek mruo te, ‘A keknen to koma mtom ta vle ti te, muk kam mrung mulenar, nang nong mang endo kam gia nngiar ngang dok kun mnam kua maksien e.’ Ii, mgua smia ngangam kim muk ekam o rhek ruk endruk ko ‘A mhel to nam kaeharom o mia nma vle mang endruk ngo yor kmeharom mar, nang nam lua vle mang endruk ngat gia ya e.’ He gi enang tok kat, ko her pis mo mmie kam vle mang endruk o mia ngma keyang ngar pum ngaro kerkeknen, he nang dok kam tger mar kmitgung ngar. Nang klua pis kam vle mang endruk ngam mrua kansgum mar mruo kam pat mang ngar mruo te, ngaro keknen ngat ho mi kut sir hak ko pum E Nut kalo keik e.” ");
INSERT INTO sua_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","E Yesus ta hivuo kmemik vop, to e Yoanes kalngunes vat ngata pis he le kta mngan pum e Yesus mang ngaro keknen ruk nkong ngar tennik kat te, “Ngua keknen to kam paal kmo ol nkong ngar tennik, nang nong lgunngae nkong ngar tete e. He ekam tok, kman ko mor kar o Parisiau ngom kaikkiem ngua keknen to nkong ngar tennik, endo kam paal kmo ol tgus ko pum E Nut kalo keik he smia ngarkie ngang, vanang itlengunes ngam kle kaeharom a keknen to a gunngar ta yek, endo kam venu mang a ngaemik?” ");
INSERT INTO sua_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Va e Yesus ta tootkinre ngang ngar kam re lkoon mang ka yor mruo te, “Mnam a kolkha to msim ko a mhel tkaenkim ktavlom, klenar ngat lo kais kam gia mrung en he ktivik pum en e. Ho mi kut nop hak. Ko o kolkhek ruk kam tivik mnam mar ngrok ge. Ngara pis ko ngaka vret a mhel to endo mkor kalngunes, yek endo yek, kalngunes ngara mrung he ktivgim ko yek.” ");
INSERT INTO sua_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ta tootkinre tok knop, to kle kaenserpagam ka papat to endo mang en mruo kat te, “Mu vokom na, a mhel nam lua vatvat a yet ka kae to a gunngar engnang endo ka sgan e, matok naka plum va ka kae to a gunngar nera vui to kaursie to kait endo ka sgan to kle ho gi kael a pammok a ho laut hak kir kim endo tesgun ko ta vatvat. ");
INSERT INTO sua_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ii, va ngam lo kaeharom a ye to a vaen, endo a gunngar kun mnam ka merrip ko ka sgan kat e, ko a merrip to ka sgan ta karrai he nera khir. Ngam lo kaeharom tok, ekam ko a vaen ka serppak, ko nak hop kun mnam ka merrip ner kaur mang ka merrip to endo ka sgan he khalker. To a vaen nera gussuk. He enang tok, a vaen ka merrip nera kernonho ekam ko nera khir va a vaen nera gussuk kat. Nove, o mia ngam lo kaeharom tok e. Ngam kle va kaeharom a vaen to a gunngar kun mnam ka merrip to a gunngar kat ko tgi kongeik, nang min tgus kam vle lya.” ");
INSERT INTO sua_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","E Yesus ta rere kngae tok, va a taip langto nma nho mang o Yuda ngarta rek to kam rere mnam tvaik kun mnam e Matyu ka rek he kpis ko kim e Yesus ktubulkek ku penharom he kaurur kim te, “O-kola-o, ko kvek te gnua yor tete ta, vanangko ip kaol he gi kaehang va nap kais kam kta hop he kta vle kat.” ");
INSERT INTO sua_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","To e Yesus ta hop to en kar kalngunes ngat hera veet kaikkiem. ");
INSERT INTO sua_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ngata ngae ekam a ngaelaut va vgum a vlom langto ko ta pis ko kim. A vlom ta, ta kerkolkol vgum a yor to a vaeip kais mang o pnes ruk loktiek hori orom alomin. Tmur kor mnam en mruo te, “Enangthe ngua re gi vur ehang si ka yet va ngor gia ya he.” To ther gia knaek ekam e Yesus kpis to gi vur ehang ka yet ke gi gu mko ge. ");
INSERT INTO sua_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","A gi hi to tehang tok, a vlom to endo ka yor ther gi nop ngatngae. To e Yesus thortgi he kvokong to kreng te, “Kolkheng, ngiak sirei na ko ye her ya he, ekam ko ya kor mnam yin mang dok.” ");
INSERT INTO sua_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kam ngae, to e Yesus ta pis kvaik kun mnam a taip to endo ka rek va kvokong alo mumu alomin ko langto ngat hupum ngaro ngaesong kam khenam nga mamrung ma mmok va langto ngat kael a halum kmaee klik. ");
INSERT INTO sua_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tvokom o mia tok, to hera reng ngar te, “Mu ehenok ko, ko a vlom sie to enda tlua vle enang a mi yor e. Tgia vle enang a kalyie to tgi onit ko ner kta hop kat.” Ta re tok, va o mia ngat le gia kol a klel orom. ");
INSERT INTO sua_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","To e Yesus ta havaeng o mia kmottek ngogu mnok knop, to ta kle kvaik ogun ko tok ko ngat ngangater a yor ko ma hep. Ii, tmi yor hak he, vanangko e Yesus ta kle ka kpom a vlom sie to endo ka ktiek ge. Ta kpom ka ktiek to a vlom sie to endo ther gi kta hop sir kat he. ");
INSERT INTO sua_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","He ekam ka ngaeha to tok, a re to mang e Yesus ka munik ta senkir he kvaas kim o rengmat tgus kun mnam a mhe to endo. ");
INSERT INTO sua_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","E Yesus tkaeharom a vlom to endo knop, to le kparem a mhe to endo to kngae va alo vivisker aloruk ngint kaikkiem kngae he kvui orom ekam a ngaelaut te, “O-e Devit Kaes to yin, ngiaka mrung nguo vanie.” ");
INSERT INTO sua_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nginta vui orom kngae tok, to e Yesus tpis kun mnam a rengmat langto he kvaik kun ma rek va alo vivisker ri ngint kaol ngok kim to ta mnganang ngin te, “Nngia orom mae, met kor mnam mae mang dok te, ko kais kmeharom mealo keik, mae kam nho kat?” Va ngint koripang te, “Ge, mare Moldaip.” ");
INSERT INTO sua_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","To e Yesus tkaehang nginalo keik he khavaeng ngin te, “Kmikkiem enang ko meta kor mnam mae mang dok tok ko kaeharom mae he.” ");
INSERT INTO sua_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","E Yesus tgia re tok, to nginalo keik ngint ya he nginta nho. To e Yesus ther kaen a re lserpgar ngang ngin te, “Meak or kam havaeng a mhel tang mang kua ngaeha to enda.” ");
INSERT INTO sua_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Puoo, ngint le kottek va kle senker a re mang en kngae kun mnam a mhe to endo tgus. ");
INSERT INTO sua_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ennginduk ngint kottek he kngae to o mia ngat le kpis orom a mhel to a koot tim he kvat ka gu to le kael ko kim E Yesus vat. ");
INSERT INTO sua_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","To e Yesus ta kerer a koot petgim a mhel knop, to a mhel to endo ka gu ta mrer he kta rere kat. Va a mumu to ta vle ko kat ngat ho mi kut sor kmar he kre te, “O reha lserpgue ruk endri ngot lo vokom mar tennik kais mang tete mo mIsrael.” ");
INSERT INTO sua_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Vanang o Parisiau ngat kle ktua kokheng a mumu kam kerrereng e Yesus te, “O-o, o kool ngalaip ka serppak ta ti arhe a mhel to enda ta kemmeng kam paeim a mhel to endo orom ti he kerer karo valngneik mruo ruk o kool.” ");
INSERT INTO sua_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","E Yesus tkerer o kool knop to le kaelha kvaik kottek kun mnam o rengmat laol va o rengmat ngaro maksien he kaelha kpatter o mia kun mnam o Yuda ngartaro rektor mruo he ka knovvur orom e Seten ko E Nut ka serppak tkir kim ekam ko E Nut ka tavgo tpis he komor o mia. Va tkaeharom o mia pum ngaro yor ngo mamten kat. ");
INSERT INTO sua_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nma ngongae tok, he kvokong o mumu to nam ngae sei kam mrung ngar, ko mar, o mia ngam gi vrong kol a regesal mang ngar he ngam lo kais kam mrua toot mang ngar mruo e. Ii, mar ngta vle enang o sipsip ruk nop ngar teit ngang ngar kam toot mang ngar. ");
INSERT INTO sua_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","E Yesus tvokong ngar tok, to tkoka ngang kalngunes mang o mia ruk enang endri te, “O mia ri ngat kaenang E Nut ka loot to ther tettek he, he kpaneng o mia kam lluol mnam, ko o mia ri ngat her gia toot he kpaneng endruk kam havaeng ngar mang E Nut ka tavgo. Ii, o mia vang kun mnam E Nut ka loot ngat tettek tok, vanangko o mia ruk kam lluol mnam ka loot, mar lgititge e. ");
INSERT INTO sua_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","He ekam tok, mguak kaurur kim E Nut to ta nho mang ka loot to orom mar, En kmen a re ngang karo mia mruo kam meng ngar kam lluol kun mnam ka loot.” ");
INSERT INTO sua_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tie ma kolkha langto e Yesus ta vaeng kalngunes ruk loktiek hori orom alomin ngok kim he kaen a serppak ngang ngar, he nang mar kam kerer o kool va kmeharom o yor ngo mamten tgus kun mnam o mia orom. ");
INSERT INTO sua_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","O aposel ruk loktiek hori orom alomin ngaro munik endri: endo ktarang orom e Saimon endo ngma mon kat te, e Pita, en kar knopia e Andru; e Yems to e Sebedi khal kar knopia e Yoanes; ");
INSERT INTO sua_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","e Pilip kar e Bartalomius; e Tomas kar e Matyu to nam kaelha klol o takis; e Yems to e Alpias khal kar e Tadius; ");
INSERT INTO sua_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","e Saimon, endo mnam a valngan to mkor o Selot, endruk ngma mon mar kat te, o Kananea, kar e Yudas to nkong mIskariot, endo thortgi mang e Yesus kmel ko maktiegom o mia. ");
INSERT INTO sua_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Her mar ruk arhe e Yesus ten a serppak ngang ngar to her smia papsim mar he kmeng ngar orom karo rhek ruk endri te, “Mguak ngae ngok kim lIsrael tuk ko ngta vraik petgim E Nut kam vle malhagenmok mang vgum ngaro kerkeknen he gia vle enang o sipsip ruk ngta sosop he gi vrong kaolol ko nop ngaortek ngang ngar kam toot mang ngar. Vanang mguak or kam ngae kun mnam o vrong rhek ngaro mhetor. Va si kun mnam a rengmat tang ko mkor o Samaria kat, va mguak or kam vaik kun mnam kat. ");
INSERT INTO sua_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mguak ngae va mgua smia polger o rhek ngang ngar te, ‘E Nut ka tavgo ther mi pis he ka vle mo pgegom muk he.’ ");
INSERT INTO sua_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","He mguak kaeharom o yor va kta hover o yoror kam kta hop kat va kaeharom o yor ruk o lepra, mar kam kta nho lya kat ko pum E Nut kalo keik va kerer o kool ruk ngat kaim o mia. Kuaro reha ruk ko eharom mar ngang nguk tesgun kam ring ya mang nguk ormar kom lua krum kua serppak ormar kim muk e. Va kmikkiem enang tok, muk kat mguak kaeharom kuaro reha ri tgus ngang o mia kam ring ya mang ngar orom mar tok kat he lua krum kua serppak ormar kim mar kat e. ");
INSERT INTO sua_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ii, va mguak or kmeha kim o tgoluk akor ngang nguk ko mguak ngae. Mguak ngae va mguak or kmeha kim o krek kun mnam mularo psang to muma kleng mularo vgondik orom mar. ");
INSERT INTO sua_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Va o nharok va si o varkie kat, a kop va a ngaelpas kat. Mu or kmeha kim mar kmikkiem ko kua havae, ekam ko o mia ruk mguer kaeha ngang ngar, mar ngak kaeha vgum muk ormar. ");
INSERT INTO sua_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Va mguak ngae kpis mnam ani rengmat to, ani maksien to, va mguak ring a rek kteit tang ko karo keknen ngat vua ya, en kam ngatkal mang nguk kam vle ko kim na, ko en tkais kmeha vgum muk. Her endo arhe mguaka vle ko kim kais ko mguak parem a rengmat to endo. ");
INSERT INTO sua_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mguak pis kun mnam a rek to endo va mguak kaenpaeim a rek kteit. ");
INSERT INTO sua_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Va enangthe a rek kteit nak ngatkal mang nguk enang tok, va mularo rhek ngak kael mit ko kim. Vanang enangthe na lua ngatkal mang nguk va mularo rhek nga lo kais kmel mit ko kim e, ngak kaeknik ko kmuk. ");
INSERT INTO sua_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Vanang enangthe a rengmat i o, a valngan langto nga lua ngatkal ekam muk kam vle ko kmar i o, kam lua ngan vgum muk kat va mguak kaureik he kngetmmie ko vgum ngaro rektor i o, ko va rengmat ka gu kam rpem a mmie ka ngaor to ta vat engnang mularo nharok. Ii, mguak kaeharom tok to le klapsam a rengmat, i o a rek to endo. ");
INSERT INTO sua_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kua mien ha, mguak kaeharom tok arhe ko kua havaeng nguk te, ner vur kongeik ngang o kermia ruk lSodom va lGomora mnam a kolkha to ngak sir ko pum E Nut kalo keik. Vanang a rengmat to na lua ngatkal mang nguk, ner ho mi ktua kernonho ngang hak.” ");
INSERT INTO sua_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Muk ruk mut kaenang o sipsip ruk o sital, mu vokom na, kua meng nguk kun pgegom o mia ruk ngat kaenang o pendol kam polger o rhek mang dok. Mguak ngae he kting kim mar, va mguak sim kut kael ekmuk mang ngar enang o vimol, nang kle kya pum mar kat ge, enang o gennes ruk ngma ya mang nglenar kat. ");
INSERT INTO sua_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kmikkiem enang tok, mguak smia ngangreal ngang nguk mang o mia ko ngar kael muk ko maktiegom endruk ngma vongnek kim o rhek, he ngara kirmekon a khap mnam muk kun mnam o Yuda ngartaro rektor ruk kam rere mnam mar ");
INSERT INTO sua_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","her vgum dok arhe. He ko tok, mgua hera polger o rhek mang dok ngang ngar. Ii, va ngar kait muk he ka srim muk ko kim o taven va ko kim lRom ngalmialaol vgum dok tok kat, he ko tok, ko muta vle ko kim mar, mguak polger o rhek mang dok ngang ngar va si ngang o vrong rhek akuruk ko tok kat. ");
INSERT INTO sua_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Ii! O mia ngara kapom muk he ka srim muk ko kim mar tok, vanangko mguak or kam vua papat mang oni rhek ruk mguak polgerik mang dok, i o kam ring o rhek kam ri pmar kat. Ko oni rhek ruk mguak polgerik mang dok E Nut ner kle yek kmeng E Nunu A Totur kmen o rhek ruk endruk lsir mnam muk. He mnam ke venloot to endo msim, ner mur kael re ko vgum muk enang tok. ");
INSERT INTO sua_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ii! O mia ngar kaeharom tok ngang nguk, ko si o moornopeik mruo, va o motter mruo ge, ngar mur kael kut mar mruo ge ko maktiegom o mia kmim mar kngam mar o yoror. Va o ngnes kat ngar kle klaut mang ngaortek ngaornek kat he kael mar ko maktiegom o mia kmim mar kngam mar o yoror kat. ");
INSERT INTO sua_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","He enang tok, o mia kavurgem ngar kaelat muk ekam dok, vanangko erieto mnam muk napa matnge vgum o vnek ruk endruk he kle kor mnam en mang dok ge, kam ngae kais ma kolkha to a kser kim, her en arhe E Nut nera sulgim kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang. ");
INSERT INTO sua_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","He ekam tok, enangthe o mia ngak kol a regesal mang nguk kun mnam a rengmat tang va mguak kle kngorpok ngok mnam tang ko yok vat he kpolger o rhek mang dok ko tok. Kua mien ngang nguk te, mut lo kais kam rum o rengmat ruk endruk ko mIsrael vop kam polger o rhek mang dok, nang A Mhel To Nkong Man Ma Volkha to dok ner mrua khenam en mruo ma mmok. ");
INSERT INTO sua_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ii, o mia ngara kernonho ngang nguk tok, ekam ko ngara ktar kernonho mang dok gi enang tok kat. Nok pathe muma pat te, mut kais kam gi mrua vavle orom muk, kam gia laut mang dok vor. O-o, nove, ko a pattermia kalngunes ngat lo kais kam gi mrua vavle orom mar he klaut mang nga pattermia e. Va o mia ruk ngam kaeha ngang ngalaip, mar kat ngat lo kais kam gi mrua vavle orom mar he klaut mang ngalaip kat e. Nove. ");
INSERT INTO sua_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ko a pattermia kalngunes ngaro ngaongtok ngak kaisis mang nga pattermia kam kol vgum karo vnek gi enang o mia ruk ngam kaeha ngang ngalaip ngaro ngaongtok ngak kaisis mang ngalaip tok kat kam kol vgum ktaro vnek. Mare, va kmikkiem enang tok kat, enangthe a valngan kteit msim napa kerkol vgum o mia ko ngapa kermuyang kam mon en te, en e Beelsebup va ta khenam te, ka valngan kat ngara kerkol vgum mar tok kat.” ");
INSERT INTO sua_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Enang tok, mguak or kam gorang endruk ngara kol a regesal mang nguk. Ko tesgun E Nut ta tuvgom karo papat kim o mia, vanang tete ta svil muk kam kle kpolger o rhek mang ngar ma mmok. Ii, tesgun E Nut nma kir mang karo papat ruk endruk, vanangko tete ta svil muk kam kle krere orom o rhek mang ngar ma mmok. ");
INSERT INTO sua_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tok kat, ko o papat ruk kua havaeng nguk ormar ko gi mor tuk, mguak kle kpolger o rhek ormar ko ma mmok ko kim o mia tgus. Ii, o papat ruk ko enik ngang nguk tuk mguak kle krere orom o rhek mang ngar ko ma gi vle. ");
INSERT INTO sua_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","He ekam tok, mguak or kam gorang endruk ngat kais kmel muk kam ngatngae kim mularo gi pkor tuk, nang lo kais kam kering mularo nunu kopekam ko mut yor he. Vanang mguak kle va kgorang E Nut ha, ko her En arhe to tkais kam ngatngae kim mularo pkor va mularo nunu tgus kun mnam a paei to a vleir ko mGehina. ");
INSERT INTO sua_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mu vokom na, o gi vrong iningol, o mia ngam lo vu kaelongtok mang ngar e. Nove, ko o mia ngat kais kmenkim alomin orom ke gi kre to ke gi tgiang e. Vanangko E Nut nam kle ho ktua nho mang ngar ge. Va tang mnam mar na sia vuut ku mmie he kyor va E Nut ta mnor mang ge. ");
INSERT INTO sua_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kuo malpgem kat, va si mularo ngairis ko palpgem muk ta vle enang tok kat, ko E Nut ta mnor mang ngar ko ngat is mang te, aner kat he. ");
INSERT INTO sua_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","He ekam tok, mu or kam gorang ngar, ko E Nut ta mnor te, mut laut he kir kim o gi vrong iningol tgus. ");
INSERT INTO sua_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ii, gi enang tok, ani mhel to tlua gorang ngar, nang kle mrua havae mang en mruo ko kim o mia ngaro kerok te, en ta vle te, ka mhel to dok orom, va A Mhel To Nkong Man Ma Volkha to dok kat ngor mrua havae mang dok tok kat te, kua mhel to en orom ko kim E Titou tkuon ma volkha kalo keik kat. ");
INSERT INTO sua_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Vanang ani mhel to nama klai mang dok ko pum o mia ngaro kerok, va dok kat ngora klai mang a mhel to endo ko kim E Titou tkuon ma volkha kalo keik kat. ");
INSERT INTO sua_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nok pathe muta pat re te, kua pis to mo mmie ta vle mang kmel a mokaum kun pgegom o mia, he mar kam smia vle vor, ngola? O-o, ho mi kut nop hak! Kua pis tlua vle mang kmel a mokaum kun pgegom o mia e. Nove, te ktua vle enang a kom kun pgegom o mia kam mommen mar kmel mar alo valngan alomin mang dok. ");
INSERT INTO sua_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ii, ko her kaol kpis mo mmie kmeharom gi enang tok kmaottam a propet langto karo rhek ruk tennik ta ktar kpavap mang tok arhe te, ‘A ngokol nera sir kim kteit va a vlom nera sir kim knan va a vlom ka vla nera sir kim ka vla mruo kat. ");
INSERT INTO sua_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","He kmikkiem enang tok, a mhel karo imuo ngara vle te, karo valngneik msim ormar arhe.’ ");
INSERT INTO sua_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","He ekam tok, enangthe a mhel tang naka svil kmikkiem dok, vanang kle kael kteit, o knan, khal, i o ka kvek ko pum kalo keik ktar mang dok, va en tlo vu eveep kam mokpom kar dok. ");
INSERT INTO sua_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Va enangthe na lua matnge vgum o vnek he mrua slak orom en mruo kam yor mang dok kat, va a mhel to endo tlo vu eveep kmikkiem dok kat e. Ii, ko endo na lua svil kam vle enang a mhel to nam mrua slak orom en mruo kam mrua tolpum ka ho mruo to ngara krong orom o ot he kvat ko engnang kngam a yoror, kmikkiem dok enang tok, va a mhel to endo tlo vu eveep hak kam mokpom kar dok kat e. ");
INSERT INTO sua_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ko endo nam vu kaelongtok mang ka ngorsang to mo mmie, en ner lua kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik e. Vanang endo nam mrua slak orom ka ngorsang to mo mmie ekam ko tkor mnam en mang dok, va her a mhel to arhe nera kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik.” ");
INSERT INTO sua_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ani mhel to ta ngatkal mang nguk, ther mia ngatkal mang dok tok kat. Va endo ta ngatkal mang dok tok, ther mia ngatkal mang E Nut to ta meng dok kat arhe. ");
INSERT INTO sua_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Va endo nak ngatkal mang a propet tang, gi ekam ko en a mi propet msim va en nera kol a keik enang endo mkor o propet ko ngara kol. Va endo nak ngatkal mang a mhel to nam sim kut kaikkiem E Nut karo pos ekam ko en nam sim kut kaikkiem mar enang tok, va en nera kol a keik kat enang endo mkor a mhel to nam sim kut kaikkiem E Nut karo pos ko nera kol kat. ");
INSERT INTO sua_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Va ani mhel to na gi kaen a ye ke mhe to ta menglol ngang o gi vrong mia ruk ngarlenar ngam lua nho orom mar ko mar kolngunes ruk mar, va kua havaeng nguk lmien te, E Nut ner lo kais kam kikiangae hak mang a mhel to endo ka keik kat e.” ");
INSERT INTO sua_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","E Yesus ta patter kalngunes ruk loktiek hori orom alomin knop, to hera parem a mhe to endo to kngae kun mnam o rengmat ngo pneik mnam a mhe to e Galili he le kpolger E Nut karo rhek va kpatter o mia. ");
INSERT INTO sua_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nangko tesgun ngat enpasiker e Yoanes kun pa hengor, he e Yoanes ta ngnek ko tok mang o reha ruk mkor Endo E Nut Thim Orom Ka Msasaen ko nam kaeharom mar. To thera meng klo kaloyie ngok kim orom a re ");
INSERT INTO sua_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kam mnganang te, “Ngola, yin msim to o propet ngta ktar kpavap mang te, nak kaol, i o tang ko ngnok vop, mor kam paneng he ka nho mkor te, en kam sulgim mor?” ");
INSERT INTO sua_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Va e Yesus ta kle koripang ngin te, “Meak kaeknik, he khavaeng e Yoanes mang o reha ruk endri ko met her vokong ngar. Ko akro vivisker ngata nonho va akro nharyor ngata ngongae, akro yor ruk o lepra ngata yaya ko pum E Nut kalo keik, va akro ngaelatok ngata ngongnek, va akro yoror ngata hohop. Va meak havaeng mang kuaro rhek ruk met her nganik ko dok koma knovvur orom e Seten ngang endruk ngma tu kmo tgoluk ko E Nut ka serppak tkir kim he. ");
INSERT INTO sua_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","He enang tok, endruk ngata mokpom kar dok he lua lopumtang pum dok he lua ksir petgim dok, her mar ruk arhe ngata lgekol.” ");
INSERT INTO sua_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","E Yesus thavae tok, to e Yoanes klo kaloyie ngint kaeknik, nang e Yesus ta kle kaelha kam keknen ngang a mumu mang e Yoanes te, “Muta veet ngok ma kalputmok kam vokom e Yoanes ko en ta vle nngia? Pathe nok kam vokom a mhel to ta vle enang a mguit to a ngausgi nma koom vor ngola? O-o, nove! E Yoanes nam lua vle tok e. ");
INSERT INTO sua_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Va muta put kman? Nok kam vokom a mhel ko nam vu kaegenkar karo it ruk orom ngakro kraen lvu yar hak vor, ngola? Nove, endruk ngam kaegen tok, o mia ngma vokom mar ko ngma vle mo rektor ruk laol mkor o taven. ");
INSERT INTO sua_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Vanang kman ko mut vua veet? Pathe nok kam vokom a propet tang vor? Mare, her endo arhe. He a propet to endo tho mi kut laut hak kir kim akro propet tgus. ");
INSERT INTO sua_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ekam ko her endo a propet langto ta ktar kpavap mang arhe, ko tennik E Nut treng Endo Thim Orom Ka Msasaen mang te, ‘Vokom na, kua re kam meng kua propet langto, en kam ktar mang in, he en kam verang a ngaelaut ekam in ktar mang in kam pis.’ ");
INSERT INTO sua_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kua mien ngang nguk te, E Yoanes to nma parrum o mia, tpu hop he klaut kir kim o mia tgus mo mmie, endruk tennik kais mang nguk tete, va si nong tang kat kun pgegom muk tlaut kir kim en kat e. Vanangko ani mhel to ta vle ku meorom E Nut ka tavgo orom ka munik ko tkok lo vua laut, vanang a mhel to endo ta kle klaut kir kim e Yoanes kat gi. ");
INSERT INTO sua_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","14","Ii, e Yoanes ta vle tok, ko E Nut ktaro pos va ktaro propet ngam gia ktar kpavap mang e Elaisa te, en naka ktar kaol kpis ktar mang Endo E Nut Thim Orom Ka Msasaen. Ii, ngata ktar kpavap mang e Elaisa tok, to o rhek ruk endruk ngata pis lmien orom e Yoanes to nma parrum o mia ko her en arhe tmi kaottam o rhek ruk endruk ko tpis. He enangthe mularo vurkul nga gia mrer vgum a papat to mang e Yoanes te, tkaottam o rhek ruk endruk enang tok ko ta pis, va mguak le kaur pum e Yoanes kat te, tpis tok, he her en arhe tkol e Elaisa ka ngaekam ko E Nut karo rhek ruk ngat ittiegom mar ngat gi ktar kpavap mang tok. Ii, E Nut karo propet ngta ktar kpavap mang tok, kais ko ngaro rhek ngat kol e Yoanes ko ther pis kam mi kaottam mar hak. Vanang kam kle kaelha ko e Yoanes ta pis kam ngae, E Nut ta ktong ka tavgo kmottgan pum he ka serppak tkaur kam komor o mia tgus mo mmie. Va o mia ruk ka tavgo tre kam komor mar, ngama kaenenker kam vaillam o vrong papat akuruk yok, mar kam smia kpom. ");
INSERT INTO sua_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Muk ruk muta vongnek kim dok, mgua sim kael rela ekam kuaro rhek ri kam sim kut kaikkiem mar.” ");
INSERT INTO sua_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","E Yesus thavae tok to le kekner mar te, “Yu! Te ma te muk o mia nga main to tete muta vle enang erie mar e? Nok mut kaenang alo valngan ruk orom o ngnes ko ngma kees kam tting ngang ngarlenar ko nginta kaum ko pum a gaep ka pun he kureik kmel ngakro ktui kim mar mruo, kmit ngarlenar kam khanier kar mar ko langto ta kni te, ");
INSERT INTO sua_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ngota pum a kamop kmit muk kmerep, vanang muma kees kam tting kmerep.’ Va langto tkoripang kam kni kat te, ‘Ngota kni orom a kni to a tningel kmit muk kmaee, vanangko muma kees kam tting kmaee kat.’ ");
INSERT INTO sua_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ii, mut kaenang ngar tok arhe, ko e Yoanes to nma parrum o mia ther aol he ikkiem ka keknen to kam paal kmo ol ko pum E Nut kalo keik va kam paal kmiviem a ye to a serpgar, he kureik kmel ka ktui kim muk kmit muk tok kat, vanang muk muta kees kam tting mang en, he krere kim te, ‘Hai-e, a mhel to enda a koot tim he envevem.’ ");
INSERT INTO sua_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ii, mu vokom Endo Nkong Man Ma Volkha to dok kat ko ko her kaol ngte kat, he kom kaikkiem kua keknen to kam venu kmemik he kaiviem a ye to a serpgar, he kureik kmel kua ktui kim muk kmit muk tok kat, vanang muk muma kees kam tting mang dok kat, to kle krere kim dok kat te, ‘Hai-e, mu vokom na, a mhel to enda nma vle pum ka keknen to kam vu kaemik va kam vu kaivie he kveve, va nma kambisam o kermia ruk ngam kaelha klol o takis kar endruk o Yuda ngalmialaol ngama keyang ngar ekam ko ngam lo sim kut kaikkiem ngaro keknen.’ Muk, mut gi kureik kmel mularo ktui kim muo tok, vanangko si enang tok, ‘E Nut To Tho Mi Kut Sir Hak karo reha ngaro miel msim ngar mur kaimim kim o rhek mang karo keknen mruo.’” ");
INSERT INTO sua_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","To o rengmat ruk e Yesus tsi eharom karo vu reha ruk lserpgue kun mnam mar, e Yesus tkaelha kam mon mar orom ngakro kerkeknen ekam ko ngat lo kaitgung ngar. ");
INSERT INTO sua_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ta kle kukueng ngar te, “O-suvrum muk ruk lKorasin va muk ruk lBetsaida ko enangthe o reha ruk lserpgue ruk endri ngap pis kun pgegom o kermia ruk lTaira va lSaidon va si mar ngap ho lo mi hus hak tiok he, kmitgung ngaro kerkeknen. Ii, va ngap lo hus kat kam vor pa ngaor va ktolpum o ngoven kam khenam ma mmok te, ngat mrua mrung ngar mruo vgum ngaro kerkeknen ruk ngat eharom mar. Vanang suvrum kelenar ruk lKorasin va lBetsaida ko o reha ruk lserpgue ruk endri ngat sia pis ko kmuk vanang muk, mut ho lo vur itgung mularo kerkeknen e. ");
INSERT INTO sua_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","He ekam tok, kua havaeng nguk te, mnam a kolkha to muk ruk lKorasin va muk ruk lBetsaida mguak sir ko pum E Nut kalo keik, va mguera kerkol vgum a kapnes to a ho laut hak kir kim si endo E Nut ner kaen ngang o kermia ruk lTaira va lSaidon. ");
INSERT INTO sua_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Va muk ruk lKaparnam kat, mum mrua pat mang nguk mruo te, E Nut nera hover muk, muk kam laut hak kir kim o rengmat tgus mo mmie. Vanangko, ho mi kut nop hak. Ko En ner kle va ho mi ktua grung ormuk kam ngam muk ngogu mLol. Ii, ner kaeharom tok ngang nguk, ko enangthe o reha ruk lserpgue ruk ko eharom mar ko kmuk ngap pis ngok kim lSodom kat va nok lSodom ngap kais kmor mnam mar mang dok vor, he a rengmat to e Sodom ngap kais kam vle kais mang tete gi. ");
INSERT INTO sua_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Vanangko kua havaeng nguk kat te, mnam a kolkha to mguak sir ko pum E Nut kalo keik, muk ruk lKaparnam mguera kerkol vgum a kapnes to a ho laut hak kir kim si endo E Nut ner kaen ngang o kermia ruk lSodom.” ");
INSERT INTO sua_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","To mnam a kolkha to endo ke vgon to endo ge, e Yesus ta kle kngarkie ngang E Nut kam kanprim te, “Titou, yin arhe yindo ya kueng a volkha va a mmie. Kua kanprim yin ko yi tuvgong o papat ruk mang ila tavgo to endo kim o mia ruk ngam mrua hover mar mruo vgum ngakro papat ruk vu laol, vanang kle ka khenam mar ma mmok ngang endruk ngat kaenang o ngnes. ");
INSERT INTO sua_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mare, Titou yeharom tok, kmikkiem gi enang ko yin mruo yi mur svil kam ring ya mang endruk ngat kaenang o ngnes kmeharom tok ngang ngar.” ");
INSERT INTO sua_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tngarkie tok knop, to le kreng a mumu te, “E Nut tel ka serppak tgus ko maktiegom dok, nang nong a mhel tang ta mnor mang E Nut Khal e, gi E Titou tuk. Va nong tang ta mnor mang E Titou kat e, gi Khal mruo tuk, kar endruk kua re pmar kam khenam En ngang ngar.” ");
INSERT INTO sua_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Muk ruk muma kerkol vgum o vnek he kngae lo kat kaurur vgum mar, mguak kaol ngte kim dok na, va dok ngor kael a vrek longeik ngang nguk. ");
INSERT INTO sua_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mguaka slak orom muk mruo he ka tting kam vat kar dok va klol o rhek vgum dok, ekam ko dok koma grung orom dok mruo, he lua guragura ormok mang o mia e. Mguaka tting kam vat kar dok va klol o rhek vgum dok, he ekam tok, dok ngor kael a vrek longeik ngang nguk he mularo vurkul ngara ya vgum dok tok. ");
INSERT INTO sua_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ii, mularo vurkul ngara vle tok, ko a tol to koma tolpum o mia orom, kom sim kael, en kam lua hembik ko porom muk. Va a vut to koma him o mia orom kat, kom kael o nni orom, en kam lo kaem o lpetuk.” ");
INSERT INTO sua_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tie ma Sabat langto kun mnam o kolkhek ruk endruk, e Yesus kar kalngunes ngat kaikkiem a ngaelaut to ta kser a loot langto orom o sigla va kalngunes ngat kaelha kolonget o sigla he kaemik ko ngata vang. ");
INSERT INTO sua_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ngat kaemik kngae, to o Parisiau akuruk ngta vokong ngar to hera pis kpalsie kim e Yesus te, “Hai-e! Vokom ilengunes na, ko ngata kpoot mang ngua pos to kam paal ma Sabat.” ");
INSERT INTO sua_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Va e Yesus tkoripang ngar te, “Nok pathe mut lo him a ngothoi to mang e Devit kar klenar ko ngta vang vor? ");
INSERT INTO sua_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ko a ngothoi to endo ta havae mang e Devit, ko tennik tvaik ogun mnam E Nut maksien ka rek Ka Taban To A Totur, he klol o bret ruk o Yuda ngam kaelik ko kim E Nut. Ii, tlol to kaisis kim kalngunes orom mar, va mar tgus ngat kaum kaemik mnam mar. Ngat si eharom tok, vanangko nguaro pos ngta havae te, gi o pris ruk laol tuk ngat gi kais kmemik mnam o bret ruk endruk, nang o vrong mia, nove. ");
INSERT INTO sua_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mare, va nok mut lua mmok mang o pos kat gi. Ko ngata havae mang o pris, ko mar mruo ngam kaeha mo Sabat tgus kam vaik ogun mnam E Nut ka maksien ka rek to a totur kmeharom a ngaeha to kmel o bret ruk endruk ko kim E Nut arhe. Ii, ngam mia kpoot mang a kolkha to endo gi kmeha enang tok arhe, vanangko mut lo smia mmok vop? Ko ngam lo kaeharom a kerkeknen tang orom nga ngaeha to tok e! ");
INSERT INTO sua_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mu vokom na, muma sovet kam totu pum E Nut ka maksien ka rek to a totur, vanangko kua havaeng nguk tete te, a tomhel langta he, enda mo kmuk he, tngae ho mi kut laut hak kir kim E Nut ka maksien ka rek to a totur. ");
INSERT INTO sua_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ii, va muma sovet kam rere pum kolngunes kat te, mar o kermia, vanangko ngat lo kaeharom a kerkeknen tang e. Mu vokom a propet karo rhek na, ko tennik ta le ka ktar khavae mang E Nut ka svil te, ‘A keknen to koma svil mang ta vle ti te, muk kam mrung o mia, nang nong endo kam gia vaik ogun mnam kua maksien he ka nngiar ngang dok e.’ He enangthe mup smia mmok mang E Nut ka re to endo ka pun, va mup lo kais hak kam rere pum mar tok e. ");
INSERT INTO sua_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","He kmikkiem gi enang tok kat, A Mhel To Nkong Man Ma Volkha nma mrung o mia tok kat he ka nho mang a Sabat!” ");
INSERT INTO sua_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","E Yesus thera parem a loot to endo, to kvaik kun mnam o Yuda ngarta rek langto kam rere mnam. ");
INSERT INTO sua_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta vle ko tok, va vgum a mhel to ka ktiek tyor ko ta vle ko tok kat. To o Parisiau ngat pe gia mnganang e Yesus te, “Kmikkiem mor o Yuda nguaro pos, tkais gi kmeharom o yor, mar kam ya ma Sabat i o nop?” O Parisiau ngat pe gia mnganang tok, ko ngata svil kam pis mang a kerkeknen to kam mon en orom. ");
INSERT INTO sua_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Va ta mnganang ngar te, “Erieto mnam muk tlo kais kam mamarer kngae kam kpom ka sipsip to agitgiang he khong ko npa vuut ku pa huop ma Sabat? ");
INSERT INTO sua_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Muta pat te, E Nut nma pat mang o sipsip kir kim o mia? Nop hak! He ekam tok, enangthe mut kais kmeharom o reha ruk lyar ngang o sipsip ma Sabat, va ta sir hak kun mnam o pos kmeharom o reha ruk lyar ngang o mia ma Sabat kat.” ");
INSERT INTO sua_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Thavae tok, to kreng a mhel to ka ktiek tyor te, “Yin he, tuom ila ktiek na.” A mhel to endo tre kam tuom ka ktiek va te, ka ktiek ther gi ya hak ngatngae, gi lya hak enang ka ktiek langto tok kat. ");
INSERT INTO sua_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Teharom tok vanangko, o Parisiau akuruk ngat kottek he kaum kmelha kam papat mang a ngaelaut tang, mar kam lgem o rhek mang, he nang kmim kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","E Yesus ta mnor mang nga papat ko ta vle tok, to ther gi vur kaol kparem a mhe to endo he kngae ko yok. Kam ngae, to a mumu ta veet ekam kat he e Yesus tkaeharom o yor tgus kun mnam mar. ");
INSERT INTO sua_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Vanang ta sopong ngar kam hagam mar kam lua polger o rhek mang. ");
INSERT INTO sua_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ta sopong ngar kam lua polger rhek mang tok, ekam ko tennik E Nut ta rere vgum ka propet to e Aisaia kam ktar kpavap mang te, ");
INSERT INTO sua_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mu vokom na, kolkayie msim ta arhe, endo ko mur re pum, he kom kaelongtok mang he ko sei kam higiang. Ngor kaenserpagam orom E Nunu A Totur to tottek mo kmok, en kam havaeng o vrong rhek ruk mo mmie tgus mang ka ngaeha to kam susulgim mar. ");
INSERT INTO sua_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Va en ner lo kaekon o rhek va kgegervik kam gupiris ko ma gi vle, kmit o mia mang e. O mia ngar lua ngan tok e. Nove. Ko ner lua vle tok. ");
INSERT INTO sua_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","21","Vanang ner kle va smia nho mang o mia, endruk ngaro imuo ngma kolaspa mang ngar. Ii, ner smia nho mang ngar enang a mhel to nam smia toot mang ka loot he kael a tataeng orom a veep ko nma kolongret. Ii, va ner lua rum kim o mia ruk ngam lo vua serppak kat e. Nove. Ko en ner lua vle enang a mhel to ta tver a paei ko tgia vur ktep e. Ii, va nera polger o rhek ruk mang kam mokpom kar dok ngang o vrong rhek kais ko kua serppak nak kir kim mar tgus he kua tavgo kam komor mar. He vgum kua tavgo enang tok, o vrong rhek ngar kael ngaro papat lserppak kam nho mkor kolkayie msim ta arhe.” ");
INSERT INTO sua_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kam ngae, to o mia ngata ktong a mhel langto ngok kim e Yesus ko a koot tim he kalo keik nginta psik va ka gu tvat. Ngata pis orom, to e Yesus tkaeharom he kerer a koot to endo, to a mhel to endo ta kta rere va kta nho kat. ");
INSERT INTO sua_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","E Yesus teharom tok, to o mia ngat le ksenkrip kim to hera mo mnganang ngar mruo te, “Ngola, nok e Devit Kaes ta arhe?” ");
INSERT INTO sua_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Vanangko o Parisiau ngta ngan mar ko ngta re tok, to ngat kle kerrereng te, “O-o, o kool ngalaip to e Beelsebul ka serppak ta ti arhe a mhel to enda nma kemmeng kam paeim o mia he kerer karo valngneik mruo ruk o kool orom ti.” ");
INSERT INTO sua_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Vanangko e Yesus ther mnor mang ngakro kerpapat ko ngta pat tok, to kreng ngar te, “Mu vokom na, a rengmat, a maksien, i o a valngan tang ko a serpgar tlo kais hak kmommenik he kaus kar mar mruo va kmopet mar mruo e, matok ngar mrua kering ngar mruo. Ko enangthe ngpa vle enang tok, va nga serppak ner lua vle lhok e! ");
INSERT INTO sua_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","He kmikkiem gi enang tok kat, e Seten ka valngan ruk o kool ngat lo is hak kmommenik he mur kaus kar mar mruo va kmopet mar mruo kat, matok ngar mrua kering ngar mruo gi enang tok kat ko nga serppak ner lua vle lhok kat e. ");
INSERT INTO sua_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Vanangko enangthe lmien mang dok te, koma kerer E Seten ka valngan ruk o kool orom ka serppak mruo kmikkiem ko muta kerrereng dok enang tok, va mguak kle kerrereng mutaro mia mruo tok kat, ko mar kat ngama kerer e Seten ka valngan gi enang ko dok koma kerer mar kat. He ekam tok, mutaro mia mruo ngara kokheng nguk orom mularo rhek ruk mut kerrereng dok ormar. ");
INSERT INTO sua_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Vanangko ekam ko koma kerer o kool orom E Nunu A Totur ka serppak ko E Nut ten ngang dok, va ta khenam te, E Nut ka tavgo ther mi pis mo pgegom muk tok arhe. ");
INSERT INTO sua_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Vanang dok, kua vle enang ti te, enangthe a mhel to a serpgar nap mur kaelel mang he ktoot mang ka rek va kakro tgoluk, va nong a mhel tang tkais kam pis ka vretik mkor e. Vanang enangthe kaela tang ko yok ko ka serppak ta laut kir kim endo a serpgar nap pis kaussiem, to endo yek, kaela to endo tmi kut kais hak kam veret kakro tgoluk mkor. ");
INSERT INTO sua_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ii, va yindo im lua mokpom kar dok kmus kar endo a serpgar he kturang dok kam veret o mia mkor, he kaelkim mar kmelriring dok, va ima vle te, im hera kapter dok tok arhe, he im mi kaen sop ngang ngar mang dok tok kat arhe. ");
INSERT INTO sua_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","He ekam tok, kua havaeng nguk te, E Nut ner mia lol o mia ngaro kerkeknen tgus patgiang ngaiting he kikiangae mang ngar hak. Va si ngaro kerkeknen ruk kam kerrereng E Nut kat va nera lol patgiang ngaiting he kikiangae mang ngar kat. Vanangko a kerkeknen to kam kerrereng E Nunu A Totur, E Nut ner ho lua kol a kerkeknen to endo patgiang ngaiting he lua kikiangae mang hak. ");
INSERT INTO sua_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Va nera vle tok kat, ngang o mia ruk ngta rere vgum A Mhel To Nkong Man Ma Volkha to dok, ko E Nut tkais kam mia lol ngaro rhek patgiang ngaiting. Vanang ani mhel to ta kerrereng E Nunu A Totur, E Nut nera kpom karo rhek he lua lol patgiang ngaiting. Nera kpom mar tete ko a mmie to enda ta vle vop kam ngae kais ngnik ngnik ko a mmie to a gunngar nak pis.” ");
INSERT INTO sua_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“O mia ngma vokom ka mnor mang a ho karo miel he ka mnor mang te, en a ho a yar, i o en a ho nong a yar. Ko a ho to a yar nam kaehi orom karo miel ruk lyar. Va a ho to nong a yar nam kle kaehi orom ngaro miel ruk nong lyar. He enang tok, muk mguaka vle gi enang tok kat arhe. ");
INSERT INTO sua_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Muk ruk o Parisiau laro inkuol ruk muk, ko mum gia rere lya kngae kiangnes malpgem o kerkeknen ruk ngat kottep kun mnam mularo vurkul ruk ngat kernonho! Vanangko mut ho lo kais hak kam mia rere lya, ekam ko o rhek ruk muma rere ormar ngam kottek kun mnam mularo vurkul ruk ngat kernonho he ka khenam mularo kerkeknen ruk ngat ottep kun mnam muk ko tok. ");
INSERT INTO sua_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ii, muma vle tok kmikkiem enang a mhel to nong a yar, ko en nam vu kaelpas orom karo vu kerkeknen ruk kun mnam ka vrek he ka khenam mar ma mmok ko nma rere ormar. He nam mrua pat mang karo kerkeknen ruk endruk ko tok te, karo gol nga pun. Vanangko a mhel to a yar nam kle kaelpas orom karo keknen ruk lyar kun mnam ka vrek kat he ka khenam mar ma mmok ko ngma rere ormar tok kat. He nam kle mrua pat mang karo keknen lyar ruk endruk ko tok te, karo gol nga pun tok kat. ");
INSERT INTO sua_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Muma vle tok, vanangko kua havaeng nguk te, mnam a kolkha to o mia ngak sir ko pum E Nut kalo keik, ngar mia sisrim ngaro rhek ngo vgondik ruk ngat gi vrong ngam mar ngang ngarlenar. ");
INSERT INTO sua_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nera vle tok, ko langto langto mnam muk, karo rhek mruo, endruk tgi vrong ngam mar ngang klenar, ngar mur kaeknik ngang en mruo kmimim kim o rhek mang, i o karo rhek ruk tgi vrong ngam mar ngang klenar ngara kaeknik ngang en kam mrua mon en orom o kerkeknen.” ");
INSERT INTO sua_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","To o Parisiau akuruk kar o pattermia kmo pos akuruk ngat pis ko kim e Yesus he kreng te, “Pattermia, ngiak kaeharom a ngaelmir tang ko a serpgar mo kmor kam vokom na!” ");
INSERT INTO sua_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Va e Yesus tkoripang ngar te, “Muk o mia nga main to tete mut ho mi kut kernonho hak. Mut kaenang o mia ruk ngma kpoot mang a lei, ko muma kpoot mang E Nut karo pos he ka ksir petgim En, nang kle sim ktua riring kriring a ngaelmir tang mo krok. Vanangko ngor ho lua khenam tang hak ngang nguk e. Nangko ngor kle va gi kael pat kmuk mang a ngaelmir langto ko tpis lmien orom a propet to e Yona. ");
INSERT INTO sua_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ko kmikiem gi enang tennik ko e Yona ta vle kun mnam a slang to klalaut ka vrek kais mang o kolkhek va o rsegain ruk korlotge, va A Mhel To Nkong Man Ma Volkha to dok kat ngora vle kun mnam a mmie ka ngaesik kais mang o kolkhek va o rsegain ruk korlotge tok kat. ");
INSERT INTO sua_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ii, e Yona tpis ko kim lNiniva he ka tger mar orom karo rhek va mar ngata ngan vgum he itgung ngaro kerkeknen. Vanang mu vokom na, a tomhel langta tpis he, enda mo kmuk he, tngae ho mi kut laut hak mang e Yona, va mut lua svil kam ngan vgum kmitgung mularo kerkeknen e. He ekam tok, mnam a kolkha to mguak sir ko pum E Nut kalo keik, lNiniva ngara sir kar muk ruk mula main to tete, va her mar ruk arhe ngar mia mon muk orom mularo kerkeknen he kael muk kam yor vgum mar ko her mar ruk ngat itgung ngaro kerkeknen arhe, nang muk nove. ");
INSERT INTO sua_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ii, va a Kheng to nkong mSiba kat, ta parem ka mmie ka pun he klal kngae ngte kam vongnek kim e Solomon karo papat ruk lvu laol. Vanangko, mu vokom na, a tomhel langta tpis he, enda mo kmuk he, tngae ho mi kut laut hak mang e Solomon va mut lua svil kam mmok mang he lua svil kam ngan vgum kat e. He ekam tok, mnam a kolkha to mguak sir ko pum E Nut kalo keik, a Kheng to endo nera sir kat ko kim E Nut kar muk ruk mula main to tete he kmon muk orom mularo kerkeknen he kael muk kam yor vgum mar gi enang tok kat.” ");
INSERT INTO sua_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ii, mnam a kolkha to muk o Yuda mguak sir ko pum E Nut kalo keik, mularo kerkeknen ngara kaeknik ngang nguk gi enang a koot to nma kaeknik mnam a mhel to mut mur kerer a koot mnam petgim. Ko a koot ka keknen ta vle te, nam kottek petgim a mhel, to nma ktar kngae ngok po turvek kam riring ngaekmol ko ma mngarmok. To tlo pis mang a mhe tang, ");
INSERT INTO sua_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","to nam kle kta pat mang ka ngaekam to tesgun kun mnam a mhel to tottek mnam, en kmeknik ngok mnam kat. Nam her kaeknik kpis mang a mhel to endo he kvokong ko a mhel ka vok tkaenang a gunmhel ka rek to ka gi kolhi ko ngat ngamakalam va pasrengem kam paneng a gunmhel tang ko yok vat. ");
INSERT INTO sua_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","A koot nma pat tok, to le ka nglum klenar akuruk aktiek hori orom alomin kat, endruk ngat ho mi kut kernonho hak mang en, he ngat kaikkiem kmeknik kaol kpis kviging a mhel to endo to kle ho gi kaim kir kim mang tesgun ko en tuk ta ktar im. Ii, a mhel to endo tkerkol vgum a kapnes tok va muk ruk mula main to tete mut ho mi kut kernonho hak va mguera kerkol vgum a kapnes koknaik gi enang a mhel to endo tok arhe mnam a kolkha to mguak sir ko pum E Nut kalo keik.” ");
INSERT INTO sua_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","E Yesus ta rere ngang a mumu kngae, to knan kar kaornopeik ngat kaol te, kam pis mang. Ngat pis ksir ku mnok he kaen a re mang ko ngata svil kam rere kar. ");
INSERT INTO sua_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","To a mhel langto thavaeng e Yesus te, “Vae, inan kar ingornopeik ngta sir ku mnok he ka mngan mang yin kam rere kar in.” ");
INSERT INTO sua_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Va e Yesus tkoripang endo thavaeng mang ngar te, “Erie mar ruk koornek va koornopeik ormar e?” ");
INSERT INTO sua_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ta mnganang tok, to kngater kalo ktiek kam khenam kalngunes ma mmok to kle ka kvam mar te, “Mu vokom endri na, ko her mar ri arhe koornek va koornopeik ha. ");
INSERT INTO sua_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ii, ngta vle tok, ko erieto nam kaikkiem E Titou tkuon ma volkha ka svil her en lsir arhe nguaka kvam te, konopia va koetem va ko nan orom.” ");
INSERT INTO sua_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Gi mnam a kolkha to endo gi, e Yesus tkottek kun mnam a rek langto, he kngae ko vanam a ngaenker to korsang. ");
INSERT INTO sua_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Va a mumu alautar tsovet kam mopet kam gun kairkleim kais ko ta ring ngaekam ekam mnam a langail langto kuo kia ngaenker. Ta kar kun mnam he korsang, nang ka mnang o mia tgus ko ngata sisir ko vanam a ngaenker ogun paat. ");
INSERT INTO sua_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","To ta rere mang o tgoluk kavurgem ko tgia koka ngang ngar. Ta koka te, “Mnam a kolkha langto a mhel tkaelha kngamngam a ho karo khek kun mnam ka loot. ");
INSERT INTO sua_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ta ngamngam mar kngae, va akuruk ngta vuvuut ko ekam a ngaelaut. To o iningol ruk kuon mail ngat pis kokorong ngar he krum kim mar hak. ");
INSERT INTO sua_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Va akuruk ngta vuvuut kun pgegom o krek ko a vur mmie ge. To ngta mamarer kam pagis ekam ko a mmie ta rara. ");
INSERT INTO sua_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ngata pagis ka vle gi nong ke laut e, ekam ko ngata viging a kolkha ka koppetmok. To a koppetmok to endo tgi ktim mar to ngat her gi vuvui he kmamarer kam vuvuut ekam ko ngaro kmen ngata puung kim o krek. ");
INSERT INTO sua_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Va akuruk ngta vuvuut kun pgegom o ngaergot ruk o kosmur. To o kosmur ngta lalaut hop kim mar kvuvuem mar to her gia komor mar. ");
INSERT INTO sua_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Vanang akuruk ngta vuvuut ko mnam a mmie to a yar, to kpupus he klalaut to kaehi. Akuruk mnam mar ngakro maineik ruk ngam kaehi ngta ngamngam va ngta ngamngam ge, va akuruk vat mnam mar ngakro maineik ruk ngam kaehi ngam vrua ngamngam kais tok va akuruk vat mnam mar ngakro maineik ruk ngam kaehi ngam vrua ngamngam kat ge.” ");
INSERT INTO sua_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","E Yesus ta koka tok knop, to kre te, “Muk ruk muta vongnek kim dok, mgua sim kael rela ekam kuaro rhek ri kam sim kut kaikkiem mar.” ");
INSERT INTO sua_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","To e Yesus kalngunes ngata pis ko kim he ka mnganang te, “Ngola, kman ko ima rere ngang a mumu ta orom o koka?” ");
INSERT INTO sua_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Va e Yesus tkoripang ngar te, “Tennik kam ngae kais mang tete E Nut tkuon ma volkha nama tuvgom karo papat ruk mang ka tavgo kim o mia. Vanangko tete ta polger o rhek mang ngang nguk kam khenam ka tavgo to endo ma mmok ko kim muk ko ther mi pis ko kim mularo kerok to le komor muk he. Va her muk ruk arhe mut mia vokom kam mnor mang. Vanang a mumu ta, ngat lua svil kam vokom kam mnor mang e. ");
INSERT INTO sua_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ii, E Nut ta polger o rhek mang ka tavgo ngang nguk ekam ko endo ta kpom E Nut karo rhek he ngat kael mit kun mnam, E Nut ner kle ho gia sovet kam kat kaen karo rhek akuruk mnam kat. To enang tok, a mhel to endo ner gia vle kia vul ormar tok. Vanang endo tlua svil kam smia kpom E Nut ke re ke vur vgon mang ngang ko ke sie, en kmel mit kun mnam, va si ke ni re ke vur vgon to endo ko ta kpom, va E Nut ner kle ho gia vret mkor petgim hak. ");
INSERT INTO sua_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ii, kom gia koka ngang ngar enang tok, kmikkiem gi enang ko a propet to e Aisaia ta ktar kpavap mang ngar te, ‘Ngam gia vokom E Nut ka tavgo orom ngaro gi pkor, he kaennegiang e. Va ngam sia ngnek ka ngnek mang kat, vanang kle gi kael rela petgim ge.’ ");
INSERT INTO sua_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ii, a propet to e Aisaia ka re tmia pis lmien orom mar ko ta ktar kpavap mang ngar kat te, ‘Her muk ruk arhe mum pua ngnek ka ngnek mang, vanangko mum ngae lua svil kam smia ngangam kim muk kam mmok mang hak. Va mum pua vokom kvokom, vanang mum kaennegiang he lua svil kam vokom kam mnor mang kat e. ");
INSERT INTO sua_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ii, o mia ri ngam lua vokom kam mnor mang, ekam ko ngaro vurkul ngam lua khi mang kuaro rhek e. Ii, ngma ngnek mang, vanangko ngam kle ktok pelam mar he lua ngangam kim mar mang va ngma vutko kim he kaennegiang. He ekam tok, ngam lua mmok mang e. Enangthe ngap lua tok pelam mar he kvutko kim enang tok, va ngap kle kais kam vokom E Nut ka tavgo kam mnor mang va kle ka ngnek mang ka tavgo he kol a papat mang, va ngat kais kam hortgi ngte kim dok va dok kop kais kam lol ngaro kerkeknen patgiang ngaiting.’ ");
INSERT INTO sua_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Vanangko her muk ruk arhe, muta lgekol ekam ko mum mia vokom E Nut ka tavgo mo kmuk he ka mnor mang va mut mia ngan o rhek mang he smia lol o papat mang kat. ");
INSERT INTO sua_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ii, kua havaeng nguk lmien te, si o propet kavurgem va endruk kavurgem ruk ngam sim kut kaikkiem E Nut karo pos kat, va ngat ho mi ktua svil hak kam mia vokom E Nut ka tavgo va kngan o rhek mang kat, enang nguk ko muta vokom va ka ngnek mang tete, vanangko E Nut ka tavgo to enda tlo pis ko kim mar e.” ");
INSERT INTO sua_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","To e Yesus tle kreng kalngunes te, “Mgua smia vongnek kim kuaro rhek na, he ngora halger a koka to endo ka pun ngang nguk. ");
INSERT INTO sua_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ta vle ti te: O mia ruk ngma ngan o rhek ruk mang E Nut ka tavgo, vanang lua svil kam smia ngangam kmar mang ngar, ngta vle enang a ho karo khek ruk ngta vuut ko ekam a ngaelaut. Ngta vle enang tok, ekam ko ngma ngan o rhek ruk mang E Nut ka tavgo, to e Seten nam her gi kat pis ge, gi veret o rhek ruk endruk E Nut ta ktar kngam mar ngkun mnam ngaro vurkul petgim mar he krum kim mar hak. ");
INSERT INTO sua_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Va o mia ruk ngma ngan E Nut karo rhek he kmarer kam kpom mar kun mnam ngaro vurkul he ksirei mang ngar va kngatkal mang ngar ngatngae, endri ngta vle enang a ho karo khek ruk ngta vuvuut kun pgegom o gi krek. ");
INSERT INTO sua_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ngta vle tok ekam ko E Nut karo rhek ngat gia puung ngaro vurkul ekam ko ngam gi vur matnge vgum o vnek nong ke laut kmor mnam mar mang E Nut orom ngaro gi pkor. Vanangko mnam o kolkhek ruk o mia ri ngta viging a koppetmok vgum E Nut karo rhek ruk endruk ko ngarlenar ngata kol a regesal mang ngar, a koppetmok to endo nam gi ktim mar he khos kim ngaro papat ruk kmor mnam mar mang E Nut, to E Nut karo rhek ngam her gi kat nop hak kun mnam mar hak. ");
INSERT INTO sua_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Vanang o mia akuruk yok ngma ngan E Nut karo rhek. Endri ngta vle enang a ho karo khek ruk ngta vuvuut kun pgegom o ngaergot ruk o kosmur vat. Ngta vle tok ekam ko ngma ngan E Nut karo rhek, vanang o papat ruk mang nga ngorsang to mo mmie ngaro vnek va o papat ruk kam lol o vu krek kavurgem ngma vaik kun mnam ngaro vurkul he ka kpom mar. To o papat ri ngma hop kim E Nut karo rhek kun mnam ngaro vurkul he kvuvuem mar, to her gi komor mar. He enang tok, E Nut karo rhek ngam lo kael mit kun mnam mar e. ");
INSERT INTO sua_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Vanang o mia ruk ngma ngan E Nut karo rhek he smia ngangam kmar he ka kpom mar lserppak kun mnam ngaro vurkul, mar ngta vle enang a ho karo khek ruk ngta vuvuut ko mnam a mmie to a yar. Ngta vle tok, ekam ko E Nut karo rhek tgus ngam mi kut kael mit kun mnam mar. He akuruk mnam mar ngaro maineik ruk ngam kaehi ngta ngamngam va ngta ngamngam ge. Va akuruk vat mnam mar ngakro maineik ruk ngam kaehi ngam vrua ngamngam kais tok. Va akuruk vat mnam mar ngakro maineik ruk ngam kaehi ngam vrua ngamngam kat ge.” ");
INSERT INTO sua_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","25","E Yesus ta rere knop, to ta kle koka ngang ngar orom a koka langto yok vat te, “E Nut ka tavgo ta vle enang ko a mhel langto ta ngamngam ke ho to a vit ngo kok ruk lyar kun mnam ka loot. To ma segain phevgom o mia ko ngata hivuo kmonit, ka imuo ta kle kaol kpis kngamngam o gigi ngaro kok vat kun mnam ka loot to kat to kngorpok. ");
INSERT INTO sua_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kam ngae, to o vit ngo kok ngta kohir he kpapagis he gnua papaam ngaro rehi, va o gigi ngta rar kngae ko vanam mar kat. ");
INSERT INTO sua_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","To a mmie kteit kalngunes ngat kaol kpis khavaeng te, ‘Ngola ngolaip, yi lo ngamngam o vit ruk lyar kun mnam ila loot gi? Vanang o gigi ruk ngta rar kun mnam a loot ngta kle kut papagis nngia?’ ");
INSERT INTO sua_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Va a mmie kteit tkoripang ngar te, ‘Ai! Nok ka imuo ngaok teharom tok vor!’ To kalngunes ngta mnganang te, ‘Ya svil te, ngor kam ngae khethetik?’ ");
INSERT INTO sua_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Va tkat koripang ngar te, ‘O-o, klua svil e! Ko matok mgua kle kaum khethetik kar o sigla. ");
INSERT INTO sua_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mgua gia mnang min tgus ko na, he ngina gia kaum ka vle tgus, kam ngae kais mnam a kolkha to kam lluol mnam. To mnam a kolkha to endo ngora havaeng endruk kam lluol mnam a loot kam ktar khethet o gigi he ka lgem o ptiek to ka knim a paei pum mar, to endo yek mgua kle mia kaser o sigla he klol ngte he kngetik kun mnam kua rek. Ii, E Nut ka tavgo ta vle gi enang tok.’” ");
INSERT INTO sua_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","To e Yesus ta kta koka ngang o mia te, “E Nut ka tavgo ta vle enang ko a mhel tkol a ho to a mastat ka kok he kavang kun mnam ka loot. ");
INSERT INTO sua_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ko a ho to a mastat ka kok ke ho mi laut hak mang o tgoluk tgus ngo kok ruk ngma kap kun mnam a loot, vanangko ko pekam ko a mhel nma kap, va a ho ka kok to endo nma pus he klaut kngae kael en a ho he khop kir kim klenar tgus kun mnam a loot kais mang o iningol ruk kuo kia gan kmaol kpis kngam ngainirik ko vgum karo khator.” ");
INSERT INTO sua_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","To ta kta keknen ngang ngar orom a koka langto vat te, “E Nut to kuon ma volkha ka tavgo ta vle enang ko a vlom langto ta kol a bret ka mit to klalaut he kael ke ngaor to a yis kam movavaik kar. A yis ta movavaik kar he le ho kaeharom a bret ka mit kam himhim orom to a bret ta kle ho gia hibul hak vgum.” ");
INSERT INTO sua_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","E Yesus ta patter a mumu orom karo koka ruk endri tgus. Nang nam lo gia rere lsir kmel karo rhek ngaro pneik ma mmok kam patter mar tok e. Nove, nam kle gia koka ngang ngar enang tok arhe. ");
INSERT INTO sua_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nama koka ngang ngar tok, ekam ko E Nut ka propet langto ta ktar kpavap mang tok te, “Ngor gia koka ngang o mia he kpolger a re to ta tvok kim mar tennik ko a mmie to enda tlo pis vop.” ");
INSERT INTO sua_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","To e Yesus ta parem a mumu to endo to kvaik ngogun mnam a rek langto he kalngunes ngat kaol kpis ko kim he kreng te, “Sim halger a koka to mang o gigi ruk kun ma loot ngang ngor.” ");
INSERT INTO sua_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","To ther kaelha kam halger te, “Endo ta ngamngam o sigla ruk lyar ngo kok, ta vle enang A Mhel To Nkong Man Ma Volkha to dok. ");
INSERT INTO sua_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A loot ta vle enang a mmie, va o sigla ruk lyar ngo kok, mar ngta vle enang E Nut kles ruk ngma vle ku meorom ka tavgo. Va o gigi ngata vle enang e Seten to tho mi kut kernonho hak kles ruk ngma vle ku meorom kta tavgo. ");
INSERT INTO sua_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Va a mhel to endo ka imuo to ta ngamngam o gigi, en ta vle enang e Seten mruo. Va a kolkha to kam lluol mnam a loot, ta vle enang a kolkha to a kser kim va o mia ruk kam lluol mnam a loot, mar ngta vle enang o engyel. ");
INSERT INTO sua_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Va kmikkiem enang ko o mia ngta lluol mnam a loot he khethet o gigi he ka lgem o ptiek kam knim a paei pum mar, va nera vle enang tok kat ngang o mia mnam a kolkha to a kser kim. ");
INSERT INTO sua_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ko A Mhel To Nkong Man Ma Volkha to dok ngora meng kuaro engyel kam heter e Seten kles ruk ngam kaeharom o kerkeknen kar kles ruk ngam koop kim o mia kmeharom o kerkeknen kat petgim E Nut kles ruk ngta vle ku meorom ka tavgo. ");
INSERT INTO sua_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kuaro engyel ngara heter E Seten kles enang tok, to le kngam mar ngok kia paei to a vleir to te sei kmeel. Ko tok ngara sei kmeteti he khem ngaro ngnorok mo kmar. ");
INSERT INTO sua_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nang E Nut kles ruk ngam sim kut kaikkiem karo pos ngar kle kael ngla mmok he kvaller o mia ekam ko ngma vle ku meorom E Nut ka tavgo. ‘Muk ruk muta vongnek kim dok, mgua sim kael rela ekam kuaro rhek ri kam sim kut kaikkiem mar.’” ");
INSERT INTO sua_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Va e Yesus ta kta koka kat te, “E Nut ka tavgo ta vle gi enang ko a mhel tpis mang a gol ka pun to ta tvok kun mnam a mmie. A mhel ta pis mang, he ho ksirei mang to ta kta tuvgong kat kun ma mmie ka mhe to kat ge. To ekam ko ta sirei alaut kam kol, thera ngae kle mur kael karo tgoluk tgus hak, o mia kmenenkim mar mkor, to hera ngae kle kaenkim a mmie ka mhe to endo a gol ka pun ta vle kun mnam.” ");
INSERT INTO sua_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Gi enang tok kat, E Nut ka tavgo ta vle gi enang ko a mhel to nam kaenkim o kirpik nam smia riring endruk lvu yar hak. ");
INSERT INTO sua_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","To tpis mang a gol ka pun he, to thera sirei alaut kam kol to hera ngae mur kael karo tgoluk tgus hak, o mia kmenenkim mar mkor, to thera kaeknik he kaenkim a pek to endo.” ");
INSERT INTO sua_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Gi tok kat ge, E Nut ka tavgo ta vle kat gi enang ko o mia akuruk ngata ngam a klui oguo mou he o singol ngaro mamten ngaro mamten ngat pis kru pum. ");
INSERT INTO sua_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","O singol ngta ngae ru pum a klui tgus to o mia ngat kait ngogun paat. To ngat korosang kam mommen o singol ruk lyar petgim endruk nong lyar. To ngat hera klang o rat orom endruk lyar, nang endruk nong lyar ngat kle kngam mar. ");
INSERT INTO sua_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Va nera vle enang tok kat arhe mnam a kolkha to a kser kim, ko o engyel ngara kaol kpis kmommen o mia ruk ngam sim kut kaikkiem E Nut karo pos petgim endruk ngam lo sim kut kaikkiem mar. ");
INSERT INTO sua_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nang endruk ngam lo sim kut kaikkiem E Nut karo pos o engyel ngar kle kngam mar ngok kia paei to a vleir to te sei kmeel. Va ko tok ngar ngae sei kmeteti va khem ngaro ngnorok mo kmar.” ");
INSERT INTO sua_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","E Yesus ta koka tok knop, to le ka mnganang ngar te, “Vae, mut smia mmok mang o papat ri o gunngae mang E Nut ka tavgo he?” Va ngat koripang te, “Mare!” ");
INSERT INTO sua_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Va e Yesus ta kle kreng ngar te, “Yu! He kmikkiem enang tok, o pattermia kmo pos ruk ngma vle orom ngaro papat ruk nkong ngar tennik, enanghte ngpa lol o papat ruk endri ko mar o gunngae mang E Nut ka tavgo, he kpupam mar kar endruk nkong ngar tennik, va ngar mia vle enang a pnes kteit to tkais yek kam sillom karo kirpik ruk o sangneik va endruk o gunngae kat kun mnam ka ngaelpas to atgiang.” ");
INSERT INTO sua_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","E Yesus ta rum karo koka ruk endruk knop, to hera parem a mhe to endo he kngae ");
INSERT INTO sua_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ngok mnam ka rengmat ka pun mruo. Tpis to her kaelha kam patter o mia kun mnam o Yuda ngarta rek to kam rere mnam. Ngta vongnek kim to ngat ngae sei kmit ongtok kim karo rhek he kaelha kam mo mnganang ngar mruo pum te, “Ngola, a mhel to enda tem anito ko karo vu papat laol he nam kaeharom karo reha ri lvu laol ko ngat vua serppak? ");
INSERT INTO sua_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Te endo nma ngamrektor khal ta ngola? Va te, knan e Maria va kaornopeik ruk e Yems, e Yosep, e Saimon va e Yudas kat ngola? ");
INSERT INTO sua_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Va kaorotmeik gi endri kmor mo kat ngola? Enang tok, to a mhel to enda tlol karo keknen ruk endri mkor erie msim?” ");
INSERT INTO sua_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","He ekam tok, o mia ngat kaelha kmelat e Yesus ko tok. Vanang e Yesus tle gia reng ngar te, “O mia ngma totu pum o propet ruk o hirtek, vanang endruk o pgirmia, o mia ngam lua totu pum mar e.” ");
INSERT INTO sua_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Va ekam ko ngat lo kor mnam mar mang e Yesus, e Yesus tlo kaeharom o reha kavurgem ruk lserpgue ko mnam a rengmat to endo e. ");
INSERT INTO sua_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","To mnam o kolkhek ruk endruk lRom ngalaip kalkayie to e Herot ta nho mang lGalili va ta ngnek mang a re to mang e Yesus ka munik. ");
INSERT INTO sua_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ta ngnek mang tok, to hera reng kalngunes te, “E Yesus, her en e Yoanes to arhe endo nma parrum o mia, he en nam kaeharom o reha ruk endri lserpgue vgum ka serppak to tkol ko thop petgim ka nnak.” ");
INSERT INTO sua_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","E Herot ta mrua pat te, e Yesus, nok en e Yoanes to tkat hop petgim ka nnak tok vor, ekam ko tiok her e Herot mruo arhe to ta ktar en a volou mang e Yoanes. Ten a voluo mang tok, ko tiok e Yoanes nam sia kser e Herot mang knopia to e Pilip ktavlom, e Herodias ko e Herot ta vret petgim e Pilip he kle klei orom. Va e Yoanes nma palsie kim e Herot mang e Herodias kam havaeng te, “Nguaro pos ngat lua ngatkal mang in kam lei orom inan e Herodias tok e.” He ekam ko e Yoanes nma palsie kim tok, e Herot ten a volou mang tok arhe, o mia kam kpom e Yoanes kaussiem he kaenpasiker kun pa hengor. E Herot ka papat ta serppak kmim e Yoanes kngam a yoror, vanangko ta gorang o mia pum, ko o mia tgus ngat el e Yoanes te, en a propet langto. ");
INSERT INTO sua_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","To mnam a kolkha langto e Herot ta kunngir kim a kolkha to knan tkol. Va kun mnam a kolkha to endo e Herodias ka kvek tkaerep ko pum o mia ngaro kerok he e Herot tngae sei kam sirei mang hak. ");
INSERT INTO sua_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tngae sei kam sirei mang to kael a tnangal ngang kam re te, ani tomhel tang ko na sia mnganang en mang, va ner gi kaen ngang. ");
INSERT INTO sua_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Va knan tkaenenker mnam ka kvek kam mnganang e Herot mang e Yoanes. To a vlom sie to endo thera ngae he kreng e Herot te, “E Yoanes to nma parrum o mia kua svil yin kam ptum ka ngoro gi tete ta he kael ka lpek kun mnam a plo kmen ngang dok.” ");
INSERT INTO sua_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","La taven to endo ta ngan ka mngan tok, to te sei kam kosnok kun mnam en mruo. Vanang ekam ko ther el ka tnangal ko pum klenar ngaro kerok, ta kle her gia tting ngang a vlom sie to endo ka mngan. ");
INSERT INTO sua_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","To thera reng o mia kam ptum e Yoanes ka ngoro kun pa hengor. Ngata ptum knop, ");
INSERT INTO sua_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","to her kael ka lpek kun mnam a plo to le kaen ngang a vlom sie to endo, to en ther kle klapsam ngang knan. ");
INSERT INTO sua_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nang e Yoanes kalngunes ngat le kpis kol ka mnes to hera ngae ka me kael kun mnam a kre ka nho. Ngat el knop, to le kngae khavaeng e Yesus mang. ");
INSERT INTO sua_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","E Yesus mar ngta kol a re mang tok, to ngat le kngae kar mnam a langail he gi vur kaol kparem a mhe to endo. To ngata poe kam ngae ngok ma lootpgeik langto, mar kam vle mar tuk ko tok. Vanangko o mumu ngta ngnek mang e Yesus ko ta ngae ko tok, to ngata veet kparem ngaro rengmat he kaikkiem ko paat. ");
INSERT INTO sua_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","E Yesus mar ngta pis kvaar he kottek paat, va vgum a mumu alautar ko ta vle kpaneng. E Yesus ta vokom mar to ta sei kam mrung ngar hak to her kaelha kmeharom endruk mnam mar orom ngakro yor. ");
INSERT INTO sua_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tkaeharom mar tok, to ma segain to endo kalngunes ngat pis ngok kim he kreng te, “A kolkha tvaik he, va mor ri ngot gia vle mo ma lootpgeik kat. He ekam tok, ngiak meng a mumu ta ngak vaik ngok mnam o rengmat ruk kanmok, mar kmenkim o ol ngang ngar.” ");
INSERT INTO sua_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ngta re tok, va e Yesus tkoripang ngar te, “Ngat lo kais kam ngae e, ekam ko muk mruo mgua mrua klang ngar mo ol ha, mar kmemik.” ");
INSERT INTO sua_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Va kalngunes ngta reng te, “Hai-e, ngruaro gi ol ruk alo gi slang alomin va o bret ruk aktiek, endri mo maktiegom mor.” ");
INSERT INTO sua_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Va e Yesus ta reng ngar te, “Mu lol ngte na.” ");
INSERT INTO sua_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","To e Yesus treng a mumu kmorosang ku ma kle, nang ta lol o bret ruk aktiek va alo slang he ka nho ngpalmai to kanprim E Nut mang ngar, to le kommenik to kaenik ngang kalngunes. To kalngnunes ngta kaklang o mia. ");
INSERT INTO sua_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","To o mia tgus ngat kaemik kvi tgus, to e Yesus kalngunes ngata kaum o ol ngo mhetor ruk e Yesus tommenik va a mumu ta penkim mar. Ngta kaklang o ngauret ruk loktiek hori orom alomin ormar va ngat ngae ottep. ");
INSERT INTO sua_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Vanang kam him gi lurokol ruk mnam endruk tgus ko ngat emik ko tok, mar ngat kais mang te, 5,000, nangko ngat lo him o is va lraip ruk ngat emik kar mar kat e. ");
INSERT INTO sua_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ngat gi gun kaemik knop, to e Yesus thera tger kalngunes kam kar mnam a langail kam ktar kam ngae ngogut pa ngaenker ka ngaiting tigut, nang en ta kle ka vle ko tok kmel a mumu ko va ngaelaut. ");
INSERT INTO sua_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tkael mar knop, to en tuk ta kle ka grap ngok kia vul langto ka ngaiting kam ngarkie. Ta vle en tuk ko tok kais ko a kolkha ta vaik mang. ");
INSERT INTO sua_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Vanang a langail ther ngae kngae he ka vle malhagenmok mang ogun paat kuon kia vul. Ta vle ko tok, va vgum a ngausgi ku ma ngaenker ko tngorom kmekon kim endruk kun ma langail. Va o vlung ngata klung engnang a langail kat. ");
INSERT INTO sua_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","O vlung ngta klung engnang a langail kngorom kngorom kais mo kao, to e Yesus thera ngae kuon kia ngaenker ka las ngok kmar. ");
INSERT INTO sua_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kalngunes ngta vokom ko ta ngae kuon kia ngaenker ka las enang tok, va ngaro nunu ngat ho mi kut parem mar hak he ngta vuvui kim te, “Yoooi, a ngomiem to ho!” Va ngata vuvui kvuvui kim ko ngat ho mi ktua gor hak! ");
INSERT INTO sua_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A gi hi to ngata vuvui, e Yesus ta hagam mar kam reng ngar te, “Mgua serppak ha, ko dok ta he. Mu or kam kta gor kat e.” ");
INSERT INTO sua_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","E Pita ta ngnek tok, to ta re te, “Koldaip, enangthe lmien te, yin msim to, va vaeng dok he ko ngae kuon kia ngaenker ka las kat ngok kmin.” ");
INSERT INTO sua_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Va e Yesus ta reng te, “Yu, yin he, aol.” To e Pita ther kootpum kun ma langail he kngae kam ngae ngok kim e Yesus kuon kia ngaenker ka las. ");
INSERT INTO sua_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ta ngae kngae, vanangko ta kle kpat mang a ngausgi ka serppak ko ta spom, to te sei kam gor hak to her kaelha kam vvuo. To ta vui kaurur kim e Yesus te, “Koldaip, mamarer sulgim dok.” ");
INSERT INTO sua_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","A gi hi to ta kaurur kim e Yesus, e Yesus ta tuom ka ktiek he ka kpom va kreng te, “Ye ho mi ktua kenhor mang dok hak! Kman ko im vua sei kam lopumtang pum dok?” ");
INSERT INTO sua_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Thavae tok, to nginta grap ngkun ma langail va vgum a ngausgi ko ther gi rurruom. ");
INSERT INTO sua_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Va mar tgus kun mnam a langail ngata vokom tok, to ktubulkek ku penharom e Yesus he ktotu pum, to le kanprim kam mrua havae mang te, “O lmien hak he, E Nut Khal msim to yin!” ");
INSERT INTO sua_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kam ngae, to ngta poe kpis he kvaar ogut pa ngaenker ka ngaiting tigut ko mGenesaret. ");
INSERT INTO sua_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ngat pis ko tok, to o mia ngata vokom e Yesus ka mnor, to ngat her kaen a re ngang o rengmat ruk kanmok he o mia ngata plalam o mia ruk ngaro yor ngo mamten tgus ngok kim. ");
INSERT INTO sua_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ngat pis kaurur kim, en kam gia mnang o mia ruk ngaro yor, mar kam gi vur ehang si ka yet ke gi gu mko ge. He enang tok, endruk tgus ruk ngat vur kaehang ka yet, va ngaro yor ngata nanop kuo mang ngar. ");
INSERT INTO sua_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","To o Parisiau akuruk kar o pattermia kmo pos ngat kootpum mar ko mYerusalem he kngae ngok kim e Yesus he ka mnganang te, ");
INSERT INTO sua_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mor ri ngom sim kut kaikkiem ngolmialaol nga keknen to kam smia parrur kmelel singni ktar mang ngor kmemik. Vanang nngia orom itlengunes ko mar ngama kpoot mang ngua keknen to endo he lua parrur ktar mang ngar kmemik e?” ");
INSERT INTO sua_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","4","Va e Yesus tkaekon ngang ngar te, “Vanang muk, kman ko muma kpoot mang E Nut kalo pos ruk alomin? Ko langto thavae te, ‘Mguak totu pum muortek va muornek’ va langto thavae te, ‘Endo nak sisieng tang mnam min, va o mia ngak lalaem kngam a yoror.’ Ii, muma kpoot mang alo pos ruk ennginduk, he nang muk kam kle sim kut kaikkiem muta mur keknen mruo to tkottek mkor mutlmialaol mruo. ");
INSERT INTO sua_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Muma kpoot mang alo pos ruk ennginduk ekam ko muma sisieng muortek va muornek ko mum sim kut kaikkiem mutlmialaol ngarta keknen mruo ko ngam kle va kokheng alo pos ruk ennginduk kam havae te, ‘A nngiar to a mhel ta ktar mon E Nut mang, he kre kam nngiar ngang E Nut orom, a mhel to endo tho lo mi kut kais hak kam kle ka vrengem kam totu pum knan i o kteit orom ko ta svil kam smia tar min orom.’ ");
INSERT INTO sua_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","He ekam ko mum kaikkiem mutlmialaol nga keknen to endo tok, mum mia hos kim E Nut ka pos mruo he kokomor kim orom tok, he nang muk kam kle sim kut kaikkiem muta mur keknen mruo tok. ");
INSERT INTO sua_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mularo naprai alomin hak! A propet to e Aisaia te smia mien mang nguk ko ka re to mang nguk ther mi pis lmien ormuk ko tennik ta ktar kpavap mang nguk te, ");
INSERT INTO sua_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘O mia ruk endri ngam gia gupiris kam gia totu pum dok orom ngaro gi pkor, vanang ngam lua vokom dok orom ngaro keknen e. ");
INSERT INTO sua_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","He ekam tok, ngam gi mrua ngampaei pum mar mruo kam totu pum dok tok arhe, ko ngma patter o mia orom ngartaro keknen mruo ruk ngat kottek mkor ngatlmialaol mruo, ko enangthe ngat ottek ekam dok.’” ");
INSERT INTO sua_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","E Yesus ta reng ngar tok, to kta vaeng a mumu ngok kim kat he kreng ngar te, “Muk mgua smia ngangam kim muk kam mmok mang kuaro rhek na, ");
INSERT INTO sua_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ekam ko o mia akuruk, ngma pat te, ngara ru pum o mgun ruk kuo mang o ol, ko ngam kaemik he kaengnam mar ogun mnam mar, he o ol ngara kla orom mar he ngar lua vle la mmok ko pum E Nut kalo keik vgum tok. Vanang nop hak! Ko o tgoluk ruk ngat lua mmok ko pum E Nut kalo keik, her mar ruk ngam kle kottek kun mnam o mia ngaro vurkul ko ngma rere ormar, he o her tgoluk ruk arhe ngama kla orom o mia he ngam lua vle la mmok ko pum E Nut kalo keik vgum mar.” ");
INSERT INTO sua_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","E Yesus ta keknen tok, to kalngunes ngat kaol kpis ka mnganang te, “Pathe nok yi lua mnor kat te, o Parisiau ngat leep vgum o rhek ruk endruk ko ya ngam mar ngang ngar?” ");
INSERT INTO sua_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Va e Yesus tkoripang ngar te, “Tgia ya kat e, ko o tgoluk ruk E Titou tkuon ma volkha tlo kakap, En nera hethetik. ");
INSERT INTO sua_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","He ekam tok, mgua korim o Parisiau tok, ko mar, ngma vle enang o vivisker ruk ngma ktong o mia. He enangthe endo a vivisker ta kpom kaela to a vivisker kat, he ka ktong kngorom, pathe nok min tgus ngint lo kais kam kaum kaol pa huop gi?” ");
INSERT INTO sua_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","E Yesus thavaeng ngar tok, to e Pita ta reng te, “Sim halger ila koka to endo mang o ol ngang ngor na.” ");
INSERT INTO sua_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Va e Yesus tkoripang e Pita he kreng te, “Puoo, te muk kat, mularo lpetuk ngta tok vop? ");
INSERT INTO sua_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mut lua mmok gi te, o ol ruk a mhel nma ngam mar ogun vgum, ngata vaik ogun mnam ko nam kaemik he ngma kolongret ngogun mnam ka vrek to le gia kottek kat ko a mhel nama ppie ormar. ");
INSERT INTO sua_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Vanang o kerkeknen ruk a mhel nam kotoongu ormar ko ngam kottek kun mnam ka vrek msim, her endruk arhe ngma kla orom a mhel to endo he nam lua vle la mmok ko pum E Nut kalo keik vgum mar, ko o kerkeknen ruk endruk ngam mia kottek her kun mnam ka vrek enang tok arhe. ");
INSERT INTO sua_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ii, ta vle tok arhe, ko o kerkeknen ngam kottek kun mnam a mhel ka vrek. Ii, endruk endri te: kmel o papat kmeharom o kerkeknen, kam pormia, kam kpoot mang a lei, kam mo vret mar, kmuruvik, kam vua ppiak kam gi vrong mon o mia orom a kerkeknen, va kam rere pum o mia kam kering ngaro mnok. ");
INSERT INTO sua_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ii, o kerkeknen ri arhe ko momonik, ngama kla orom a mhel he nam lua vle la mmok ko pum E Nut kalo keik enang tok. Vanang a keknen to kam lo parrur kmelel singni he kaemik, a keknen to endo nam lua kla orom a mhel, he en kam lua vle la mmok ko pum E Nut kalo keik e!” ");
INSERT INTO sua_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","To e Yesus ther gi vur aol kparem a mhe to endo, nang kle kngae mnam a mhe langto yok ko rkieng alo rengmat ruk e Taira va e Saidon. ");
INSERT INTO sua_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ta pis, va vgum a vlom to nkong ko tok ko en a vrong rhek to ko mKenan, nang nong a Yuda msim to en e. Tkaol kpis ko kim e Yesus he kaurur kim te, “Kolaip, yindo E Devit Kaes To Yin, he ngia mrung dok vanie, ko a koot tviging ko kvek he kering kngae panaem hak.” ");
INSERT INTO sua_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","A vlom tkaurur kim, vanangko e Yesus tlua kakhi rkieng e. To kalngunes ngat kaol kpis ko kim e Yesus he kle kaurur kim vat te, “A vlom ta tvu kaelkeyang ngor kmikkiem mor. He likim he na ngae he.” ");
INSERT INTO sua_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Va e Yesus ta reng a vlom te, “E Nut tmeng dok ngang gi lIsrael tuk ruk ngta vraik petgim En kam vle malhagenmok mang vgum ngaro kerkeknen he gia vle enang o sipsip ruk ngata sosop, nang tlua meng dok ngang o vrong rhek e.” ");
INSERT INTO sua_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Vanang a vlom to endo tgi kaur kat ge, he kpis ktubulkek ku penharom he kat kaurur kim te, “Kolaip, he ngia turang dok vanie.” ");
INSERT INTO sua_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Va e Yesus tkoripang a vlom ta te, “Tlo vua ya dok kam lol o ngnes ruk lIsrael ngaro oreek he kngam mar ogu kam klang o vela ruk o vrong rhek ormar e.” ");
INSERT INTO sua_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Va a vlom tkat kaurur kim gi te, “Kolaip kua mnor, vanangko si o vela kat va ngam kaem o ol ngaro gi ngommes ruk mkor ngaortek ko ngma vuvuut kuo ma psen.” ");
INSERT INTO sua_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","A vlom thavae tok, va e Yesus tkoripang te, “Yu, kolkheng, yi sei kmor mnam yin mang dok hak he. He ekam tok, kua ngatkal mang ila mngan ko ya svil mang dok kmeharom tok.” A gi hi to ta re tok, a vlom ka kvek ther gi ya ngatngae. ");
INSERT INTO sua_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","E Yesus teharom tok knop, to le kparem a mhe to e Taira he kngae ko paat ekam a ngaenker lsir. To ta grap ekam a vul langto ka ngaiting he korsang ko tok. ");
INSERT INTO sua_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ta vle ko tok, va o mumu vang ruk laol ngat kaol ngok kim orom o mia ngo yor ngo mamten, endruk o nharyor, o kernonhor, o vivisker, o guvat va o vrong yor akuruk kat. Ngata plalam o mia orom ngo yor ngo mamten he kael mar tgus ko pum kalo keik to ther kaeharom mar. ");
INSERT INTO sua_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","O mia ngta vokom o yor ngo mamten ko ngaro yor ngata nanop kuo mang ngar tgus hak he ngata mrua sor kmar kim e Yesus ko o guvat ngta rere, o nharyor ngta ngongae, endruk o kernonhor ngat sim vle, va o vivisker ngta nho kat. Ii, ngta vokom mar tok, to ngae sei kam sor hak kim tok, to le kanprim E Nut to lIsrael ngma totu pum. ");
INSERT INTO sua_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kam ngae, to e Yesus ta vaeng kalngunes ngok kim to khavaeng ngar te, “Ko sei kam mrung a mumu to enda, ko ngata vle mo kmok kais kmo kolkhek korlotge he, he ngat lo vur kaemik e. He klua svil kam gia meng ngar kam gia vang kngae e, matok nga le kyor ka ktal ko ekam a ngaelaut.” ");
INSERT INTO sua_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","To kalngunes ngata mnganang te, “To ngruak ring o bret mriem moti ma gi kalputmok kmis mang la mumu to enda ko tvua laut, mar kmemik?” ");
INSERT INTO sua_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","To e Yesus ta kle ka mnganang ngar te, “Nang mularo bret o gutnei aner?” Va ngat koripang te, “Aktiek hori orom alomin va kero singol lgititge e.” ");
INSERT INTO sua_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ngat havaeng tok, to e Yesus ta reng a mumu kmorosang ku mmie. ");
INSERT INTO sua_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ngat korosang knop, to ta lol o bret va o singol to kanprim E Nut mang ngar to tkommenik he kaenik ngang kalngunes, to kalngunes ngat le kaisis kim a mumu ormar. ");
INSERT INTO sua_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","To mar tgus ngat kaemik ngae kvi tgus knop, to e Yesus kalngunes ngata kaum o ol ngo mhetor ruk e Yesus tommenik va a mumu ta penkim mar, to ngat hera klang o ngauret ruk aktiek hori orom alomin ormar va ngat ngae ottep. ");
INSERT INTO sua_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Vanang kam him gi lurokol ruk mnam endruk tgus ko ngat emik ko tok, mar ngat kais mang te, 4,000, nangko ngat lo him o is va lraip ruk ngat emik kar mar kat e. ");
INSERT INTO sua_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ngat kaklang o ngauret knop, to e Yesus thera kaekon a mumu ngok mnam ngaro rengmat, nang en ta kle kar mnam a langail kngae mnam a mmie ka mhe to e Magadan. ");
INSERT INTO sua_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tie ma kolkha langto o Parisiau kar o Sadyusi ngta veet ngok kim e Yesus he kpis kpe kaegom kam kendom ngang te, en kam khenam a ngaelmir langto ngang ngar ma mmok, mar kam mia mmok mang en te, lmien te, her en arhe Endo E Nut Thim Orom Ka Msasaen. ");
INSERT INTO sua_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ngat pis, to e Yesus thavaeng ngar te, “Muk muma mnorvek pum a ngaelmir to nma ktong a kolkha ko mum vokom a volkha ko nma svel mo vlemkor va mum hera havae te, ‘A kolkha nera vle.’ ");
INSERT INTO sua_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Va muma mnorvek pum a ngaelmir to nma ktong a kus kat ko mo ruteik mum kle re vokom a volkha ko o varhek ngma kaum he ngae ka slok va mum her kta havae kat te, ‘A kus ner mi kaerik he.’ Ii, mut sim ktua mnorvek pum o ngaelmir ruk orom a ngausgi man ma volkha tok, vanang kman ko mut lo kais kam mnorvek pum o ngaelmir ruk kun mnam ke venloot ta mang Endo E Nut Thim Orom Ka Msasaen?” ");
INSERT INTO sua_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“Muk o mia nga main to tete mut ho mi kut kernonho hak. Mut kaenang o mia ruk ngma kpoot mang a lei, ko muma kpoot mang E Nut karo pos he ka ksir petgim En, nang kle sim ktua riring kriring ge mang a ngaelmir tang mo krok. Vanangko ngor ho lua khenam tang hak ngang nguk e. Ngor kle va gi kael pat kmuk, mang a ngaelmir langto, endo tpis orom a propet to e Yona.” Ta re tok, to hera ngae kam kar mnam a langail to hera parem mar. ");
INSERT INTO sua_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ngata poe kngae to kvaar ogut pa ngaenker ka ngaiting tigut, vanang kalngunes ngat kikiangae kam lol o ol akor. ");
INSERT INTO sua_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ngat vaar ka vle, to e Yesus thavaeng ngar te, “Mgua sim ktua papat he kngangreal ngang nguk hak mang o Parisiau va o Sadyusi ko ngta vle enang ke ngaor to a yis ko nma himhim orom a bret kam ho gia hibul hak.” ");
INSERT INTO sua_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","To kalngunes ngat kaelha kam mo mnganang ngar mruo he kre te, “Ngola, nok pathe ta re tok ekam ko ngot kikiangae kam lol o ol akor vor?” ");
INSERT INTO sua_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","To e Yesus ta tar ko ngta re tok, to ta le ka kner mar te, “Kman ko muta vle krere mang te, nop o ol ngang nguk? Mut ho mi ktua kenhor mang dok her tok arhe! ");
INSERT INTO sua_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mut lo sim kol dok vop, ko mut her kikiangae he mang kero bret ruk aktiek va kelo slang ruk alomin, endruk ko klang lurokol ruk ngat kais te, 5,000 ormar. Ko kopekam ko o mia tgus ngat emik kvi, muta klang o ngauret aner orom o ol ngo mhetor ruk ngat penkim mar? ");
INSERT INTO sua_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","I o o bret ruk aktiek hori orom alomin kat endruk ko klang lurokol ruk ngat kais te, 4,000 ormar kat, nok mut kikiangae mang ngar kat ko kopekam ko o mia tgus ngat emik kvi kat, muta klang o ngauret aner orom o ol ngo mhetor ruk ngat penkim mar? ");
INSERT INTO sua_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","To nngia, ko mut lo sim lol kuaro rhek ko klo mia rere msim mang o ol e? Nove. Ko kle mia havaeng nguk mang o Parisiau kar o Sadyusi, muk kam smia ngangreal ngang nguk mang ngaro papat ruk ngma ker patter o mia ormar ko ngta vle enang ke ngaor to nma himhim orom a bret kam ho gia hibul hak.” ");
INSERT INTO sua_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","E Yesus ta re tok, to endo yek kalngunes ngat hera mmok te, tlua havaeng ngar kam ngangreal ngang ngar mang o mi ol e. Nove, ngta mmok yek te, thavaeng ngar kam ngangreal ngang ngar mang o Parisiau kar o Sadyusi ngaro papat ko ngma ker patter o mia ormar. ");
INSERT INTO sua_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tie ma kolkha to e Yesus tpis mnam a mhe to ko mSisiria Pilipai ther kaelha kam mnganang kalngunes te, “O mia ngma mngan pum A Mhel To Nkong Man Ma Volkha to dok he kmon dok te, dok erieto?” ");
INSERT INTO sua_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Va ngat koripang te, “Akuruk ngma mon yin te, yin e Yoanes to nma parrum o mia. Akuruk ngam ktua mon yin te, yin e Elaisia, nang akuruk yok ngma mon yin te, yin e Yeremaia, i o tang mnam o propet ruk tennik.” ");
INSERT INTO sua_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","To e Yesus ther kle ka mnganang ngar vat te, “Vanang muk ri, mut ktua pat te, dok erie?” ");
INSERT INTO sua_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Va e Saimon Pita tkoripang te, “Her E Nut to nma plong vle ngnik ngnik Khal to yin arhe, Endo E Nut Thim Orom Ka Msasaen.” ");
INSERT INTO sua_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","To e Yesus thera reng te, “E Yona khal to yin arhe Saimon, ye lgekol ekam ko nong a gi vrong mhel tang to tpolger a re to endo ngang in e, gi E Titou mruo tkuon ma volkha. ");
INSERT INTO sua_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","He kua kilegem yin te, e Pita enang tok ekam ko ye kaenang a kre to kemilaut e, he ngor kle ktavger kua ngaomevek malpgem a kre to alautar to endo, he a rengmat to ngogu mLol ka serppak tlo kais hak kam kir kim kua ngaomevek to endo, mar kam yor ngmeang gi enang endruk ko mLol tok e. ");
INSERT INTO sua_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Va ngor kaen a serppak to mang E Nut ka tavgo ngang in, yin kam kpom, he anito tkaisis kun mnam in mo mmie, va nera kaisis kun mnam E Nut tkuon ma volkha gi enang tok kat. Va anito ye kaiso kim mang mo mmie, va En ner le kaiso kim kuon ma volkha enang tok kat.” ");
INSERT INTO sua_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","E Yesus thavae tok, to hera reng kalngunes lserppak hak, kam hagam mar kam lua polger a re to mang en ngang a mhel tang te, en ta vle te, Endo E Nut Thim Orom Ka Msasaen. ");
INSERT INTO sua_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","To kmelha mnam a venloot to endo msim e Yesus tkaelha kam keknen ngang kalngunes te, nak ngae mYerusalem kam lol o vnek kavurgem ko vgum o pris ruk laol va o pattermia kmo pos va o Yuda ngalmialaol, mar kmim kngam a yoror. Va naka kru kun ma mmie kais mo kolkhek ruk korlotge, yek E Nut nak kle khover petgim ka nnak. ");
INSERT INTO sua_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","E Yesus ta keknen ngang ngar tok, to e Pita ta ker ngangan karo rhek ruk endruk, to te vrua vaeng e Yesus petgim klenar he kaekon kim o rhek ngang kam kner mang ka papat to endo te, “O-o, Koldaip, klua svil hak! Ilaro rhek ruk endruk E Nut nak ngam mar pa kolsei, mar kam lua pis lmien e.” ");
INSERT INTO sua_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","To e Yesus thortgi ngok kim e Pita he kle ka kner kam reng te, “Ehenok ko petgim kualo keik, ekam ko ye ru kim e Seten he kaegom kam hagam dok, ko ilalo keik ngint gia vle mang o tgoluk ruk mo mmie, nang nong mang o tgoluk ruk mkor E Nut e.” ");
INSERT INTO sua_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","To ta kle kreng kalngunes te, “Erieto mnam muk nak papat kam vle te, kolkayie to en, en nak kikiangae mang karo svil mruo, nang kle mrua krus orom en mruo kmel en mruo kam yor enang a mhel to ta mrua tolpum kta ho mruo to ngara krong orom o ot kvat ko engnang kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ko endo tvua sovet kmelongtok mang ka ngorsang to mo mmie, a mhel to endo ner lua kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik e. Vanang endo nam mrua slak orom ka ngorsang to mo mmie ekam dok va her en arhe nera kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik. ");
INSERT INTO sua_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ii, ko a mhel nera vle nngia koknaik enangthe napa ktar rum karo mur svil mruo tgus hak mang ka ngorsang to mo mmie tete, vanang koknaik gia huo mang kalo ktiek ko tkosnok ko tlua kol a ktalhok to endo? Ko nop ke vur tomhel ngang hak, ko en nak kol mo mmie to tkais kmel ekam en mruo orom kam mopel kar a ktalhok to endo hak, he nang en kam le kol. ");
INSERT INTO sua_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nop hak, vanangko A Mhel To Nkong Man Ma Volkha to dok ngor kaeknik kar o engyel ruk ngma totu pum dok. Va ngor kaeknik orom E Titou ka mmok, yek endo yek, E Titou ner kaekon a mhel langto langto orom a keik, i o a mgu kmoripang karo reha. ");
INSERT INTO sua_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ii, kua havaeng nguk lmien te, akuruk mnam muk ri muta vle mo, mguer lua yor vop kais ko mguer mia vokom A Mhel To Nkong Man Ma Volkha to dok ko nguaka ktar hop orom kua tavgo to nak komor o mia tgus.” ");
INSERT INTO sua_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kopekam ko o kolkhek ruk aktiek hori orom atgiang ko ngat nop, e Yesus thera nglum e Pita kar lo monopia ruk e Yems kre Yoanes he ka ktong ngar kam grap ngoguon kia vul to a hogor petgim o mia. ");
INSERT INTO sua_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ngata vle ko tok, to e Yesus ka vok tkaelha kam horotgi ko pum ngaro kerok ko kalo keik ngint ngae gi valler mar enang a kolkha ko nma nan va karo it ngate ksei kam ho mi les hak he kmamallek. ");
INSERT INTO sua_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","E Pita kar e Yoanes va e Yems ngat re ka nho, va vgum e Moses kre Elaisa ko ngint her gi pis ko pum ngaro kerok he krere kar e Yesus. ");
INSERT INTO sua_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ngta vokom mar tok, to e Pita ther gi vrong ngam a re ngang e Yesus kam reng te, “Vae, Koldaip, tho mi kut ya hak ko mor korlotge ngota vle mo he. Ko ngiaka tting he ngruaka ngam o rambel akor ko korlotge ngang nguk, tang ngang in, e Moses kat ngang va tang ngang e Elaisa kat!” ");
INSERT INTO sua_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","E Pita ta rere kngae vop, va te vgum a varhek to la mallegar ko tpis va ka ngoumi ta komor mar. Va ngta ngan a ktui ko tkottek kuon mnam a varhek to endo he kre te, “Ko hal ta arhe, kom vu kaelongtok mang va ko sei kam higiang. He mgua smia ngan vgum!” ");
INSERT INTO sua_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","E Yesus kalngunes ngta ngnek tok, va o rhek ruk endri ngat kaengorang ngar he ngaro nunu ngat ho mi kut parem mar hak to ngta mrua ngam mar ku mmie kvavham. ");
INSERT INTO sua_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Vanangko e Yesus tkaol ngok kmar he kaehang ngar va kreng ngar te, “Mu hohop, mu or kam gor.” ");
INSERT INTO sua_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","To ngata hover ngaro lpetuk he re ka nho va si nhong e Moses kre Elaisa, nang kle gia vokom e Yesus tuk ko tgia sir en tuk ko pum ngaro kerok. ");
INSERT INTO sua_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kam ngae, to ngat kaelha kam grung ngpirik he kngae ekam a ngaelaut, to e Yesus thera reng ngar lserppak te, “Mguak or kam polger o rhek ngang a mhel tang hak mang anito muta vokong moti kam ngae kais ko E Nut na hover A Mhel To Nkong Man Ma Volkha to dok petgim kua nnak na.” ");
INSERT INTO sua_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","E Yesus treng ngar tok, to kalngunes ngat kle hera mnganang te, “Yu! Vanang kman ko o pattermia kmo pos ngam kle khavae te, e Elaisa naka ktar kpis na, ktar mang Endo E Nut Thim Orom Ka Msasaen?” ");
INSERT INTO sua_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Va e Yesus tkoripang ngar te, “Nop, lmien tok ha. E Elaisa na mi kaottam E Nut karo rhek, mar kam pis lmien orom en mruo ko naka ktar kaol kpis tok kmelel o papat mnam o mia, mar kam kat kaeknik ko kim E Nut, he nang mar kam kta mokpom kar En, yek Endo E Nut Thim Orom Ka Msasaen nak pis.” ");
INSERT INTO sua_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Vanangko ko smia mien ngang nguk te, e Elaisa ther mi pis he, nangko o mia ngat lua vokom kam mnor mang e. Nove! Ngat her kle va ksisieng kmikkiem ngartaro svil mruo. Ii, va gi enang en tok kat ge, A Mhel To Nkong Man Ma Volkha to dok nera lol o vnek her vgum mar tok kat arhe.” ");
INSERT INTO sua_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","E Yesus ta re tok, to endo yek, kalngunes ngat her smia lol karo rhek mang e Elaisa te, ta rere kvat e Elaisa ka munik kam rere mang e Yoanes to nma parrum o mia arhe. ");
INSERT INTO sua_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kam ngae, to e Yesus mar ngta pis ku kim a mumu ku pa vul, to a mhel langto tpis ktubulkek ku penharom e Yesus he kaurur kim te, ");
INSERT INTO sua_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Kolaip, ngia mrung ko hal vanie. Ko te sei kam kerkolkol a nganngannes vgum a koot to a ngoulo ko nam kaim he kngam kun mnam a ye va kuo kio paeyol kat. ");
INSERT INTO sua_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Va ko plalam ngte mo kim ilengunes ri, mar kmeharom, nangko ngat lo is mang a koot to endo kam kerer petgim e.” ");
INSERT INTO sua_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","E Yesus ta ngnek tok, to kle ka kner kalngunes te, “Muk o mia nga main to tete, mum vu kaungtu ekam mularo mur kerpapat mruo, nang vua vrengem E Nut karo papat he kekenhor mang dok hak. Kua kapngan kim muk he, ko kua vle mo kmuk lhok he, vanang mut lo vur kaeha vop orom kua serppak to ko en ngang nguk.” Ta kner mar tok, to le kreng ngar te, “Mu marer plalam a kalyie to endo ngte kim dok na.” ");
INSERT INTO sua_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","A gi hi to e Yesus ta kerer a koot to endo, ta ngorpok petgim a kalyie to, to a kalyie ther gi ya ngatngae. ");
INSERT INTO sua_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kam ngae, to e Yesus kalngunes ngat kaol ngok kim ko gi en tuk he ka mnganang te, “Ngola kman ko mor mruo ngot lo is kam kerer a koot to endo petgim?” ");
INSERT INTO sua_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Va tkoripang ngar te, “Ekam ko mum vua kenhor ngaok, mut lo kais mang e. Lmien ko kua havaeng nguk te, enangthe mularo papat ruk mum kor mnam muk mang dok ngap laut kais enang a ho to a mastat ke kok to kemilaut hak va mguer kais kam reng a vul ta te, ‘Ehenok ogut,’ va a vul to endo ner mia ngan vgum muk. Ii, enangthe mularo papat ruk endruk ngpa vle tok, va mguer kais kmeharom o vrong tgoluk tgus.” ");
INSERT INTO sua_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","“Vanangko kam pet a koot ka mten to enda ko tvua serppak, mguak ngarkie va kpaal kmo ol ko pum E Nut kalo keik kam kol a serppak vgum gi En tuk, nang nong vgum a tomhel tang kat e.” ");
INSERT INTO sua_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","E Yesus kalngunes ngat kaum ko mGalili knop, to e Yesus thavaeng ngar te, “A mhel langto nera hortgi mang A Mhel To Nkong Man Ma Volkha, he kael ko maktiegom kakro imuo, ");
INSERT INTO sua_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","mar kmim kngam a yoror. Va naka kru kun mnam a kre ka nho kais mo kolkhek ruk korlotge to E Nut nak kle kta hover petgim ka nnak en kam kta hop kat.” E Yesus tre tok, va karo rhek ruk endruk ngat ho mi kut kerngorom kalngunes hak. ");
INSERT INTO sua_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mnam a kolkha to e Yesus kar kalngunes ngat pis ko mKaparnam o Yuda ruk ngama kol a kre to alomin mnam mang a takis to mang E Nut ka maksien ko mkor o mia ngta pis ko kim e Pita he ka mnganang te, “Ngola, mula pattermia nma ngam kta kre to alomin mnam mang E Nut ka maksien kat?” ");
INSERT INTO sua_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","To e Pita ther koripang ngar te, “Mare, en nma ngam ktalo kat.” To e Pita thera ngae ngok mrek. Tvaik kun mnam a rek he lo kaelha kam rere vop, vanang e Yesus ta ktar gi mnganang ge te, “Vae Saimon, ya pat nngia mang a taven to mnam a mmie to enda, ko nma lol o takis mkor erie mar, mkor kles mruo i o, mkor o gi vrong mia?” ");
INSERT INTO sua_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","To e Pita tkoripang te, “He, o gi vrong mia.” To e Yesus tkoripang te, “Yu! Te enang tok, a taven nma poom kles msim, ngola? Ii, he gi enang tok kat, mor ruk E Nut kles msim, E Nut ta poom mor kat kam lua ngam a takis mang ka maksien kat e. ");
INSERT INTO sua_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Vanangko si enang tok, kam gi kael longeik ngang endruk laol ngakro vurkul ngiak mamarer kngae ngogu ma ngaenker he ngam ila ngausie. To a slang to naka ktar kaelatik ngiak kait he pgangam ka gu va ngira pis mang a kre to korlolo mnam ko vgum. Ngiak kol a kre to endo he kngam ngang ngar mang nguo tgus mang a takis to mang E Nut ka maksien.” ");
INSERT INTO sua_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","To kun mnam ke vgon to endo, e Yesus kalngunes ngat kat kaol ngok kim he ka mnganang te, “Ngola, edim mnam mor ka munik ta laut kun mnam mor tgus ruk E Nut tkuon ma volkha ka tavgo tkomor mor?” ");
INSERT INTO sua_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","To e Yesus ta vaeng ke kalyie langto he ka srim kun pgegom mar ko pum ngaro kerok tgus, ");
INSERT INTO sua_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","to khavaeng ngar te, “Kua havaeng nguk lmien te, enangthe mgua lo ktar khortgem mularo keknen, he nang kam vle enang ke kalyie ta, va mguer lo kais hak kam vaik kun meorom E Nut ka tavgo e. ");
INSERT INTO sua_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ii, he ekam tok, endruk ngam mrua krus orom mar mruo he kol ke kalyie ta kakro keknen, her mar ruk arhe ngta laut kun mnam endruk tgus ruk E Nut ka tavgo ta komor mar. ");
INSERT INTO sua_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Va ani mhel to na mrua krus orom en mrua ko pum o mia ruk ngaro mnok ngat lo vua laut enang ke kalyie ta, he kngatkal mang ngar ko ngat kor mnam mar mang dok, va a mhel to endo ther mia ngatkal mang her dok kat arhe.” ");
INSERT INTO sua_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Vanangko, kolngunes ruk endri orom ngaro papat ruk kmor mnam mar mang dok ko ngat lo vua serppak mang dok vop, enangthe a mhel nap kaop kim kolkayie tang mnam mar kam mrua ksir petgim dok, va te sei kam ya hak ngang a mhel to enda kam vle vgum a kapnes to kam kleng a kre to klalaut ko porom ka ngoro he kngam ngogu ma ho mlin, en kam yor. Vanang ner kle ho mi ktua kernonho hak ngang a mhel to endo, en kam vle vgum a kapnes to E Nut ner kaen ngang enangthe nap kait tang kun mnam mar, he na harpeet enang tok.” ");
INSERT INTO sua_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","To e Yesus ther kle kre te, “Suvrum mu kelenar he, muk ruk muma kaop kim mulenar he ngata harpeet ekam mularo kerkeknen. Ii, o mia ruk ngma kaop kim nglenar kmeharom o kerkeknen ngar mia pagis, vanangko suvrum endo msim tmi kaop kim mar kmeharom mar tok. ");
INSERT INTO sua_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","He ekam tok, enangthe ip kaeharom a kerkeknen tang orom ila ktiek i o ila nhar mruo, ko na re kaop kim kolkayie tang kmeharom a kerkeknen tok kat, va ngiaka ksir pum a kerkeknen to endo, he ka vle gi enang a mhel to napa kser ka ktiek i o ka nhar mruo ko tkaeharom a kerkeknen tang orom he kpet kngam. Ngiak kaeharom tok, ekam ko te sei kam ya hak ngang in, yin kam mrua ngam ke mhe tang ngang yin mruo, he nang yin kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik tok, vanang ner ho mi ktua kernonho hak ngang in kam vle vgum a kapnes to E Nut kam ngam ila vok tgus kun mnam a paei to a vleir. ");
INSERT INTO sua_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Va enangthe ip kaeharom a kerkeknen tang orom ila keik kat ko na re kaop kim kolkayie tang kmeharom tok kat, va ngiaka ksir pum a kerkeknen to endo kat, he ka vle gi enang a mhel to nap kalagam ka keik mruo he kpet kngam kat ko tkaeharom a kerkeknen orom. Ngiak kaeharom tok, ko te sei kam ya hak ngang in, yin kam mrua kalagam ila keik mruo he kpet kngam, he nang yin kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik tok. Vanang ner mi ktua kernonho hak ngang in kam vle vgum a kapnes to E Nut kam ngam ila vok tgus kun mnam a paei to a vleir to ko mGehina.” ");
INSERT INTO sua_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","To e Yesus ta rere kngae vop te, “He ekam tok, mguak ngangreal ngang nguk kam lua karkar mang tang mnam kolngunes ruk endruk ngat vur kor mnam mar mang dok orom ngaro papat ruk ngat lo vua serppak mang dok vop. Ko si ngaro engyel ruk kuon ma volkha va ngma toot mang ngar ko kim E Titou tkuon ma volkha kalo keik kat. ");
INSERT INTO sua_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Naka vle tok, ekam ko A Mhel To Nkong Man Ma Volkha to dok ther kaol ngte mang her endruk ngata vle malhagenmok mang ngar Teit to E Nut vgum ngakro kerkeknen tok arhe, he en kam lol ngakro kerkeknen patgiang ngaiting kam sulgim mar enang tok. ");
INSERT INTO sua_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","To muta pat nngia mang a mhel to karo sipsip ngang ko ngat kais te, o mhelom aktiek, to tang mnam mar nap sosop ogun poturvek malhagenmok mang kteit, va kteit nap kan? Tlo kais kmorim karo sipsip ruk o mhelom korlolo he loktiek hori orom aktiek hori orom korlolo ko tok ma hogun, nang kle kngae na, he kriring endo tsosop gi? ");
INSERT INTO sua_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mare, va kua havaeng nguk lmien te, enangthe na ngae pis mang va ner mi ktua sirei alaut hak mang kir kim endruk torim mar ko ma hugun ko ngat lua sosop. ");
INSERT INTO sua_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Va gi enang a sipsip to endo tok kat, E Titou tkuon ma volkha nam ho lua svil hak mang tang mnam endruk endri orom ngaro papat ruk ngat lo vua serppak mang dok vop kam yor kat he lua kol a ktalhok to kam plong vle ko kim En ngnik ngnik e.” ");
INSERT INTO sua_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","E Yesus ta keknen kngae vop te, “Enangthe knopia ngang in na kaeharom a kerkeknen tang ngang in va ngia ngae ngok kim he kpalsie kim kam srim a vnek to endo, ko gi mae tuk na. He enangthe nap ngan vgum in va ye her it inopia vanam yin kat he. ");
INSERT INTO sua_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Vanang enangthe na lua ngan vgum in, va ngiak vaeng kaela ngang in, i o alo ko yok kmikkiem yin kmenserpgam o rhek kmikkiem enang ko mor o Yuda ngua pos thavae tok. Ko a pos to endo thavae te, ‘O mia ruk ngak kais te, alomin i o korlotge ngak sir pekam ngaela kmenserpagam karo rhek.’ ");
INSERT INTO sua_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Vanang enangthe na ngae ho kaengnam muk korlotge mularo rhek kat va mguak kael a vnek to endo ko maktiegom kua ngaomevek to ormuk. Va enangthe na kaengnam si kua ngaomevek to ormuk mularo rhek kat va mguak kle her gia likim a mhel to endo petgim kua ngaomevek to ormuk he gia pat mang en te, en tkaenang o tamatan ruk ngat lo mokpom kar E Nut, i o enang a kermhel langto nam kaelha klol o takis kat. ");
INSERT INTO sua_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ii, kua havaeng nguk lmien te, naka vle tok, ekam ko ani papat to muta lgem he tkaisis kun mnam muk mo mmie, va E Nut tkuon ma volkha nera lgem a papat to endo kmisis kun mnam En enang tok kat. Va anito mut kaiso kim mo mmie kat, va En ner le kaiso kim kuon ma volkha enang tok kat. ");
INSERT INTO sua_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Gi tok kat ge, ko kua havaeng nguk te, enangthe gi si alo nginp kaisis kun mnam min tgus mang a gi vrong papat tang ko ngint kaurur kim E Nut mang, va E Titou tkuon ma volkha ner mi kaisis kun mnam en mang a papat to endo tok kat. ");
INSERT INTO sua_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ii, nera vle tok arhe ko, si alomin i o gi korlotge ruk ngat kor mnam dok, enangthe ngapa kaum mang a papat tang orom kua munik va her dok to arhe ormar.” ");
INSERT INTO sua_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","To e Pita tkaol ngok kim e Yesus he ka mnganang te, “Ngola Koldaip, kola napa venu kam kering dok, va nguak lol karo kerkeknen patgiang ngaiting kais mang aner? Nok kam ngam aktiek hori orom alomin ngola?” ");
INSERT INTO sua_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","E Pita ta mngan tok, to e Yesus tkoripang te, “Nop hak, nong gi aktiek hori orom alomin e. Ko a keknen to kam lol o mia ngaro kerkeknen patgiang ngaiting kam ngam kais mang aner, ta vle enang ti te, ho mi kut nop ka tu ngang hak. ");
INSERT INTO sua_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ii, va E Nut ka tavgo ta vle gi enang tok kat arhe. Ko E Nut ka tavgo ta vle enang ko a taven langto ta sirsrim kalngunes ruk ngam kaeha ngang ko ngat el o tol ko kim. ");
INSERT INTO sua_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tkaelha kam sirsrim mar, ko ta ktar kvaeng kalkayie to tel a tol ko kim orom o vu krek ruk ka ho vurgem hak. ");
INSERT INTO sua_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","To a taven ta tar ko kalkayie to endo tlo vu kais hak kam srim ka tol ko kim, to treng kalngunes akuruk kmen a mhel to ngang o mia, mar kmenkim en kar ktavlom, kles va karo tgoluk tgus hak ko mkor, he nang kalkayie kam kol a kre kam ru vgum ka tol to ko kim. ");
INSERT INTO sua_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","A re to endo ta kerngorom a taven kalkayie to endo, to ta tubulkek ku penharom ka taven kmurur kim te, ‘O kolaip, ngia mrung dok vanie, he orim dok na, nang ngora srim kua tol ko kim yin tgus.’ ");
INSERT INTO sua_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Va ekam ko tkaurur kim ka taven tok, a taven to endo te sei kam mrung he ta kle khagam mang ka tol tgus hak kam kol patgiang ngaiting he korim en kam ngae. ");
INSERT INTO sua_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kam ngae, to a taven kalkayie to endo gi ta ngae ekam a ngaelaut va ting kim kaela langto nama kaum kaeha kar ngang ngina taven to endo kat. Kaela to enda tesgun tel a tol gi nong ke laut ko kim vat. Tpis mang kaela tok, to kpat mang kaela ka tol to ko kim to le ta vottegem ka ngoro he kreng lserppak te, ‘Ke srim ila tol to yel ko kim dok na.’ ");
INSERT INTO sua_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Karo rhek ngata kerngorom kaela to endo, to ta tubulkek ku penharom kmurur kim te, ‘O ngia mrung dok vanie, he orim dok na, nang ngora srim kua tol ko kim yin tgus.’ ");
INSERT INTO sua_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Vanang tlua tting e. Ta kle her gia kol a hagie mang gi kam reng o mia kmenpasiker kun pa hengor kam vle kais ko nak rum ka tol to ko kim na. ");
INSERT INTO sua_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nginlenar ngata ketar pum ko teharom tok ngang ngaela tok, to ngaro vurkul ngate ksei kam kiin mang to kle kngae ngok kim nga taven to endo to le khavaeng mang ka keknen to endo tok. ");
INSERT INTO sua_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ngta havaeng nga taven tok, to thera kaen a re mang kalkayie to endo. Tpis ko kim to ka taven treng te, ‘Kolkayie to yinda, ye ho mi kut kernonho hak! Ko her hak mang ila tol tgus to ko kim dok he kol patgiang ngaiting ekam ko ye urur kim dok. ");
INSERT INTO sua_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Va yin ip kol ekmok he ka mrung ila enang dok orom in ko ko mrung yin tok kat!’ ");
INSERT INTO sua_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","To ka taven ta sei kam vrek kiin ngang to tle kael ko maktiegom o mia kam kol a hagie mang kmenpasiker kun pa hengor, en kam kerkol vgum o nganngannes ruk laol hak he ka vle ko tok kais ko en nak rum ka tol to ko kim tgus na. ");
INSERT INTO sua_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Va gi enang a taven kalkayie to endo, muk tgus ruk mum lua lol mulenar ngaro kerkeknen patgiang ngaiting, va E Titou tkuon ma volkha ner mi kaeharom ngang nguk gi enang tok he lua lol mularo kerkeknen patgiang ngaiting tok kat.” ");
INSERT INTO sua_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","To e Yesus trum karo rhek ruk endruk, to kle kparem a mhe to e Galili he kngae mnam a mmie ka mhe to mYudea ngkun kut pekam a ye to e Yodan ka ngaiting tigut. ");
INSERT INTO sua_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Va o mumu laol ngta veet ekam, he nam kaeharom mar ko tok pum ngakro yor, mar kam ya. ");
INSERT INTO sua_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","To o Parisiau akuruk ngat pis ko kim e Yesus kam pe gia kaegom, en kam mrua ru pum karo mur rhek mruo. Ngat pis to pe gia mnganang te, “Ngola, tgia sir kmikkiem E Nut karo pos gi ngang a ngokol kam gia kser en kar ktavlom ngina lei vgum o gi vrong papat akor?” ");
INSERT INTO sua_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Va e Yesus tkoripang ngar te, “Puoo, mum lua mmok mang E Nut karo pos gi? Ko tennik ngat ittiegom karo rhek ri ti te, ‘Ta kueng o mia he kmommen mar kam vle te, lurokol va lraip.’ Ta kueng ngar kmommen mar tok to le ");
INSERT INTO sua_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","kael ka re langto vat ko ngat ittiegom kat te, ‘Ekam ko ko kueng o mia he kmommen mar tok, a ngokol nak parem kteit va knan he mrua pet kmikkiem ktavlom, min kam kaum ka vle te, min atgiang.’ ");
INSERT INTO sua_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gi enang tok, ngina lo kta vle te, langto ge langto ge e. Ko her min atgiang he, min kam vle atgiang. He enang tok, ekam ko E Nut tngam min mo kmin enang tok, va muk ruk o gi mia, mguak or kam ngatkal mang a mhel tang kam kser min mo kmin e.” ");
INSERT INTO sua_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Va ngat koripang te, “Yu! Vanang e Moses ka pos to tgi pis pgeik orom? Kman ko ta ngatkal mang a ngokol te, en ‘kmittiegom a gi hor ngang ktavlom kam kser ngina lei orom tok?’” ");
INSERT INTO sua_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Va e Yesus ta kle koripang ngar te, “Lmien ko tete e Moses ta ngatkal mang a mhel kam kser a lei ekam ko mum gi kaengnam E Nut karo rhek. Vanangko tennik ko E Nut tkueng lurokol va lraip, tlua kueng ngar kam kser ngina lei tok e. ");
INSERT INTO sua_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Vanangko dok, kua kle ktua havaeng nguk te, enangthe a ngokol tang napa kser ka lei he kle klei orom a vlom tang ko yok, yek endo yek, a mhel to endo ta kpoot mang ngina lei tok arhe. Vanangko a mhel tkais kam kser a lei kmikkiem ke gi mhe ta tuk, endo te, enangthe tang nap kaol mang kaela ktavlom i o katngokol va kaela tkais kam kser ngina lei.” ");
INSERT INTO sua_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","E Yesus ta re tok, to kalngunes ngat hera reng te, “Te ma te, enangthe ngot lo is kam kser a lei enang tok, va ther gia ya te, kam ho lo kta lei kat he.” ");
INSERT INTO sua_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Va e Yesus tkoripang te, “Nop muta mien tok, vanangko o mia tgus ngat lo kais kam kol mula papat to endo e, gi endruk E Nut te ktuel mar tuk kam ktua vle enang tok. ");
INSERT INTO sua_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ii, kua rere mang endruk ngaornek ngat kut llues orom mar kam gia vavle tok he lua lei. Va endruk kat nglenar ngata mon mar o yunek ko ngat mia ngnit mar he lua lei, va si endruk ngam mrua tokim a papat kun mnam mar mruo kam lua lei kat ko ngama kor mnam mar mang E Nut to tkuon ma volkha, he nang mar kam seneker ka tavgo kam vaas kim o mia tgus. Gi endruk arhe E Nut te ktuel mar kam ktua vle enang tok. Muk ruk mut kais kam kol a papat to enda, yu, muk he!” ");
INSERT INTO sua_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","To ko tok, o mia ngata kurkeik kim e Yesus kmel o ngnes ngok kim, en kmel kalo ktiek kuo mang ngar kam ngamyammok mang ngar va kngarkie mang ngar. Ngata kurkeik kim tok, to kalngunes ngata kner mar. ");
INSERT INTO sua_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Vanangko e Yesus ta kle kreng kalngunes te, “Mguak orim mar he ngak kaol ngte kim dok na. Mguak or kam tokim mar e, ko o mia ruk ngat kaenang o ngnes ruk enang endri, her mar ruk arhe E Nut to tkuon ma volkha ka tavgo ta komor mar.” ");
INSERT INTO sua_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","E Yesus thavae tok, to le kael kalo ktiek kuo mang ngar va kngarkie mang ngar. Tngarkie knop, to hera parem a mhe to endo he kngae. ");
INSERT INTO sua_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","To mnam a kolkha langto a ngokol langto tpis ko kim e Yesus he ka mnganang te, “Pattermia, havaeng dok na te, nguak kaeharom anito ko a yar, he nang dok kmis mang E Nut kmen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang dok?” ");
INSERT INTO sua_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Va e Yesus tkoripang te, “Kman ko ya mnganang dok mang a tomhel ko en a yar, ko gi E Nut tuk to atgiang ko En a yar. He ekam tok, enangthe ipa svil kam kol a ktalhok to kam plong vle ko kim En ngnik ngnik va ngia sim kut kaikkiem karo pos.” ");
INSERT INTO sua_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Va a ngokol to endo tkoripang te, “Endrim mnam mar msim ngua sim kut kaikkiem mar?” Va e Yesus tkoripang te, “Endruk endri te: ‘Or kam por mia, or kam kpoot mang a lei, or kmuruvik, or kam ppiak kam mon ilenar orom o kerkeknen ko kim endruk ngma vongnek kim o rhek, ");
INSERT INTO sua_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ngiak totu pum iteit va inan va ngiak kaelongtok mang ilenar enang ko im mur kaelongtok mang yin mruo.’” ");
INSERT INTO sua_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","E Yesus ta re tok, to a ngokol to endo tkat koripang te, “Te o pos ruk endri kom sim kut kaikkiem mar ha, vanang anito ngnok vop endo kua kpoot mang?” ");
INSERT INTO sua_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Va e Yesus vat tkat koripang te, “Enangthe ipa svil kam sarim o pos tgus va ngiak lol ilaro tgoluk tgus he kaenik ngang o mia, mar kmenkim mar mkor in. To ngiak lol o krek to le kaenik ngang endruk ngma tu kmo tgoluk. Ngiak kaeharom tok, yin kam kol a ktalhok to kam plong vle ngnik ngnik ko a ktalhok to endo ta vle enang ila gol ka pun to kmelpas orom kuon ma volkha. Ii, ngiak kaeharom tok knop, to her kaol ikkiem dok.” ");
INSERT INTO sua_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","E Yesus ta re tok, to karo rhek ruk endruk ngat ho mi kut kosogi pum a ngokol to endo hak, to ther gi him kalo ktiek he ksei kam mrua mrung en mruo ko karo vu tgoluk ka ho vurgem hak. Thim kalo ktiek tok, to hera ngae parem e Yesus mar. ");
INSERT INTO sua_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","E Yesus tvokom tok, to kle khortgi ngok kim kalngunes he kreng ngar te, “Lmien, ko kua havaeng nguk te, ner vua kellet ngang o mia ruk ngaro vu tgoluk kam vaik ku meorom E Nut tkuon ma volkha ka tavgo. ");
INSERT INTO sua_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ii, kua havaeng nguk te, tlo vua kellet tok ngang a ngaemslang to alautar hak to a kamel kam khanang kam vaik ku meorom ke gudor tang ko ke mi laut. Vanang a mhel to karo vu tgoluk, ta kle ho mi ktua kellet hak ngang en kam vaik ku meorom E Nut ka tavgo.” ");
INSERT INTO sua_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","E Yesus ta re tok, to kalngunes ngat ho mi kut it ngaro ngaongtok kim karo rhek to kle kmamngan te, “Enangthe ilaro rhek ngata mien, va nop a mhel tang hak tkais kam mrua sulgim en mruo he kvaik ku meorom E Nut ka tavgo hak kat e.” ");
INSERT INTO sua_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","To e Yesus kalo keik ngint kaem mar to thera reng ngar te, “Ii, o mia kam mrua sulgim mar mruo kam vaik ku meorom E Nut ka tavgo, ngat ho lo mi ktuis hak kmeharom tok e. Vanangko E Nut tmi ktuis kmeharom o vrong mia tgus, mar kam vle te, ngat kais kam vaik ku meorom.” ");
INSERT INTO sua_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","To e Pita vat ta le kreng e Yesus te, “Vokom na, endruk ya rere mang ngar ko ngat paparem ngakro vu tgoluk tgus, nang kle mokpom kar in kmikkiem yin, her mor ri arhe. He ekam tok, ngurera kol ani keik ekam tok?” ");
INSERT INTO sua_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Va e Yesus vat ta kle koripang te, “Ko smia mien ngang nguk te, mnam a kolkha to E Nut ner kta kueng a mmie to a gunngar, A Mhel To Nkong Man Ma Volkha to dok nera kol ka ngaekam orom kla mmok, endo kmorsang mnam kam vongnek kim o rhek ruk mkor o mia. Va kun mnam a kolkha to endo, muk ruk muta mokpom kar dok he kaikkiem dok mguera tuur mnam kua tavgo kat he klol o ngaekmol ruk loktiek hori orom alomin kmorsang mnam mar kam turang dok kam vongnek kim o rhek ruk mkor lIsrael ngaro usiel ngo pneik ruk loktiek hori orom alomin kat. ");
INSERT INTO sua_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ii, va ani mhel to ta parem ka rengmat, kaornopeik, kaorotmeik, kaornek, kaortek, kles, i o karo luteik kam mokpom kar dok kmikkiem dok kam hover kua munik, va a mhel to endo E Nut ner ho mia klang mo tgoluk he nera vle kia vul ormar. Va koknaik kat E Nut ner kle kaen a ktalhok to kam plong vle ko kim En mruo ngnik ngnik ngang kat. ");
INSERT INTO sua_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Vanang o mia ruk ngaro mnok ngta laut tete, kavurgem mnam mar E Nut ner kle ka krus ormar koknaik. Va tok kat ngang endruk ngaro mnok ngta grung tete, ko her kavurgem mnam mar tok kat arhe E Nut ner kle khover mar koknaik.” ");
INSERT INTO sua_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","E Yesus ta kta koka ngang ngar te, “Ii, E Nut ka tavgo ta vle tok kat arhe. Ko ta vle enang ko a mmie kteit langto ta hop khalki marot msim he kngae kam ngamhu mang o mia kam lluol kun mnam ka loot. ");
INSERT INTO sua_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta ktar ka lgem o rhek kar mar kmenkim mar orom a keik to kmis mang a kolkha to atgiang tgus, to le kmeng ngar kam hera lluol kun mnam ka loot. ");
INSERT INTO sua_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A kolkha tirie ktal he knan, to a mmie kteit to ther kta ngae kat he kpis mang o mia akuruk yok vat ko ngat gia sisir ngpang ngar ko ma gi vle. To ta kta ngamhung ngar tok kat kam ngae ka lluol kun mnam ka loot. ");
INSERT INTO sua_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Thavaeng ngar te, ‘Muk ri mguak ngae ka lluol ngang dok kat kun mnam kua loot, he ngora srim muk kmikkiem ko mut kut kaeha kais tok.’ Thavaeng ngar tok, ");
INSERT INTO sua_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","to ngat hera ngae. Teharom tok kat ko a kolkha tho sir he. Kvavle kat to tkaeharom enang tok kat ko a kolkha ta vraik. ");
INSERT INTO sua_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ka vle to a kolkha tre kam ho kvaik he, to ta kta ngae kat gi. To ta pis mang o mia akuruk yok vat ko ngate gia sisir ngpang ngar. To ta mnganang ngar te, ‘Kman ko mute gi mrua vavle orom muk mruo he koham a kolkha ta tgus?’ ");
INSERT INTO sua_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Va ngat koripang te, ‘Ko tang tlo ngamhung ngor e.’ To a mmie kteit thera ngamhung ngar knaek mang endruk tgus kam reng ngar te, ‘Yu! Muk kat mguak ngae he ka lluol kun mnam kua loot kat.’ ");
INSERT INTO sua_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","To a kolkha ta vaik he, to a mmie kteit to enda ta vaeng kalkayie to ta nho mang endruk tngamhung ngar to kreng te, ‘Ngiak vovaeng endruk tgus ko ngamhung ngar kam lluol, he ngiak kaenenkim mar. Ngiak kaelha orom endruk ko ngamhung ngar knaek kam ngae kmis mang endruk ngat mi elha marot msim.’ ");
INSERT INTO sua_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Thavaeng tok, to endruk a mmie kteit ta ngamhung ngar knaek ko a kolkha tre kam vaik ngat kaol to a mmie kteit kalkayie to endo tkaenkim mar orom a keik to a dinaris to atgiang ko tkaiser a kolkha to atgiang tgus. ");
INSERT INTO sua_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kam ngae, to endruk a mmie kteit ta ktar kngamhung ngar te, marot msim ngat kaol kle kpis vat. Ngta vokom ko a mmie kteit kalkayie ta srim endruk nanga tok to ngat mrua kansgum mar he ka nho mkor kmenkim mar kir kim endruk nanga, vanangko mar tgus ngat gi kle kol a keik to a dinaris atgiang mang a kolkha to tgus enang tok ge. ");
INSERT INTO sua_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ngta kpom ngaro krek he, to kaelha kam rere porom mar mang a mmie kteit. ");
INSERT INTO sua_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ngta havae te, ‘O mia ruk endri ya ngamhung ngar ho gi tete vlemas he ngat gi kopom ka nan mang ngor e, vanang ya kle enkim mar orom a keik tkaiser mor ri kat ko mor ngot vaik mnam a ngaeha ka mit msim hak kam vle kim a kolkha to enda tgus ka manakain he kaeha.’ ");
INSERT INTO sua_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Vanangko a mmie kteit tkoripang langto mnam mar te, ‘Kambis, klua mas orom in he kvethas ngang in tok e. Ko mota ktar kaum lgem o rhek mang a pat to mang a keik to yin kam kol he! ");
INSERT INTO sua_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Te, yin he, kol ila keik to endo he kngae he, ko dok mruo ko her mur ktua svil tok ge kmenkim endruk ngat kaol knaek hak kmiser mula keik enang tok ge. ");
INSERT INTO sua_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kua ngaeha to orom kuaro tgoluk mruo ngola? Nang tang tlo is kam kpoot mang dok e. Pathe nok ye kaesik ngang o mia he gia vokom mar orom ila keik ka ngaiting ekam ko dok ko sim vokom mar he lua kulpang kim mar vor?’ ");
INSERT INTO sua_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ii, he kmikkiem gi enang tok nera vle tok, ngang endruk ngam mrua kansgum mar kmel mar kuo ktar tete, ko koknaik E Nut ner kle kael mar knaek. Va endruk ngam mur kael mar knaek tete, koknaik E Nut ner kle kael mar kuo ktar kat.” ");
INSERT INTO sua_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","To mnam a kolkha langto e Yesus tkaikkiem a ngaelaut kngae kam ngae ngoguon mYerusalem to ta nglum karo aposel ruk loktiek hori orom alomin petgim kalngunes akuruk to khavaeng ngar ko ekam a ngaelaut te, ");
INSERT INTO sua_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Vae, mu vokom na, ko ngruaka grap ngoguon mYerusalem he A Mhel To Nkong Man Ma Volkha to dok o mia ngar kael ko maktiegom o pris ruk laol va o pattermia kmo pos, mar kam monik kim a yor ngang. ");
INSERT INTO sua_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","To ngar kle kael ko maktiegom o vrong rhek, mar kam klel orom, va kam kirmekon a khap mnam, to le ka krong orom o ot kvat engnang a ho kmim kngam a yoror. Ngar kaeharom tok ngang, vanangko ko pekam o kolkhek ruk korlotge kat E Nut ner kta hover petgim ka nnak.” ");
INSERT INTO sua_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","To e Sebedi klo hal ngin nan ta kaol ngorom min ngok kim e Yesus. Tpis ktubulkek ku penharom to ka mnganang, en kmeharom a ngaeha langto ngang. ");
INSERT INTO sua_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Va e Yesus thera mnganang te, “Ya svil mang anito?” Va ngin nan tkoripang te, “Ngiaka tting orom klo yie ri, he kun mnam a kolkha to ila tavgo nak vaas kim o mia tgus he komor mar, min nginak kol alo ngaekam ruk E Nut nma nho orom min, tang ko vanam ila miktiek va langto ko vanam ila ksienga, min kam kaum kar yin kam nho mang o mia kar yin orom ila tavgo.” ");
INSERT INTO sua_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Va e Yesus tkoripang ngin te, “O-o, met ho mi ktua ketoptop hak mang dok tok arhe, ko meta pat re te, met kais kat kam lol o nganngannes ruk dok mruo ngora lol gi?” Va ngint koripang te, “Ii, mot kais!” ");
INSERT INTO sua_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Va e Yesus tkat koripang ngin te, “Nop, mer mia lol o nganngannes ruk endruk ge! Vanangko kam mon te, erie minduk nginera korsang ko vanam kua miktiek va langto ko vanam kua ksienga, kam kaum kar dok kam nho mang o mia, a papat to endo nong kua ngaeha to dok kmeharom e. Gi E Titou mruo to ner mur kaen alo ngaekam ruk ennginduk ngang alo ni mhel ruk En mruo ta ktar el ka papat tennik mang ngin kmen alo ngaekam ruk ennginduk ngang ngin he.” ");
INSERT INTO sua_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","To nginlenar ruk loktiek ngat re ngnek mang a rere to endo va ngaro vurkul ngate ksei kam kiin hak ngang ngin. ");
INSERT INTO sua_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","To e Yesus ta vaeng ngar tgus ngok kim to kreng ngar te, “Muk muta mnor he mang o vrong rhek ngakro taven kar ngalmialaol ngakro keknen ko ngma karkar mang ngakro mia mruo he o mia ngma kerkolkol vgum ngaro serppak ngola? ");
INSERT INTO sua_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Vanang kun pgegom muk na lua vle enang tok ngang nguk e. Ko endo mnam muk naka svil ka munik kam laut mang klenar, mar kam nho orom, va her endo arhe na kle mrua krus orom en mruo, nang kle gi kaeha ngang nguk ha! Mare, na kle ho mi ktua krus orom en mruo, nang kle gi kaeha ngang nguk tok arhe! ");
INSERT INTO sua_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ii, en naka vle tok kmikkiem enang ko A Mhel To Nkong Man Ma Volkha to dok ko si en mruo tpis nong mang o mia kmeha ngang e. Nove, ta kle kpis kam mrua slak orom ka vok mruo kmel ekmar orom ka vok to endo, he nang kam kta lol mar tgus kam kta vle ngang E Nut kat.” ");
INSERT INTO sua_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","E Yesus kar kalngunes ngata ngae ekam a ngaelaut vop he kparem a rengmat to e Yeriko va a mumu to alautar ngta veet kaikkiem. ");
INSERT INTO sua_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ngta ngae va vgum alo mhel ruk alo vivisker ko ngint korsang ko vanam a ngaelaut. Alo vivisker ri nginta ngnek te, E Yesus mar ngta ngae rkieng ngin he re kam lapsam min to ngint le kvui orom te, “O-e Devit kaes to yin Yesus-o, ngia mrung nguo vanie!” ");
INSERT INTO sua_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","To a mumu tkaekon kim min kam hagam min kam lua rere. Vanangko ngat le ho gi kaoppom min klik, min kam ho gia vui klik kat ge te, “O-e Devit kaes to yin Yesus-o, ngia mrung nguo vanie!” ");
INSERT INTO sua_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","To e Yesus ther gia sir ko va ngaelaut to kvaeng ngin ngok kim he ka mnganang ngin te, “Me havaeng dok na, meta svil mang dok kmanker mae?” ");
INSERT INTO sua_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","To ngint hera re te, “Mo laip, mota svil yin kmeharom moalo keik he muo kam nho!” ");
INSERT INTO sua_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","To e Yesus ta mrung ngin. To a gi hi to tkaehang nginalo keik, mint her gi nho ngatngae to her gi kaikkiem. ");
INSERT INTO sua_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","E Yesus mar ngta ngae he konner a rengmat to e Yerusalem. Ngta vle ko va ngaelaut ka gu to mang a rengmat to e Betpagi kuon kim ke vul to e Olip. To e Yesus thera meng klo kaloyie aloruk kam ktar mang ngar ");
INSERT INTO sua_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ko thavaeng ngin te, “Meaka ktar kngae ngok ma rengmat tma kuon he mera pis mang a dongki kar ka sie ko ngta kleng ngin he ngint gia sir. Meak halger nginalo ngausie he kait min ngte kim dok. ");
INSERT INTO sua_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nang enangthe tang nak re kam hagam mae mang ngin, va meak koripang te, ‘Ngoldaip ta re mang ngin, he ner lo hus kam gi kat kaekon min kat e.’” ");
INSERT INTO sua_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","E Yesus tmeng ngin tok, ekam ko tennik E Nut ka propet langto ta ktar kpavap mang gi enang tok te: ");
INSERT INTO sua_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Havaeng lSaion, endruk lYerusalem te, ‘Vae! Mu vokom na, ko mula Taven tkaol kam pis ko kmuk orom ka keknen to kam lua guragura orom mang o mia, ko tkorsang kuo mang a dongki orom ka sie ko vanam kat.’” ");
INSERT INTO sua_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ta reng ngin tok, to ngint hera ngae kaeharom enang ko e Yesus tsim papsim min tok. ");
INSERT INTO sua_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ngint kait a dongki orom ka sie he kaeknik kngorom min kpis ngok kim e Yesus to le kpasrengem min orom ngaro it. To e Yesus ta grap he korsang kuo mang endo ke sie, to le ksap orom kmikkiem a ngaelaut. ");
INSERT INTO sua_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ta ngae va o mia kavurgem kun mnam a mumu to ngta veet ekam ngat kaelha kam pasrengem a ngaelaut kam vevher ngakro it ekam a ngaelaut. Va akuruk ngta kuung o kneng ngo hor he kaenerik ekam a ngaelaut kat. ");
INSERT INTO sua_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Va endruk ngta ktong e Yesus kar endruk ngata knaek mang ngat kaelha kam mariu orom va kael kavres kam kni pum te, “Ngota kanprim yin E Devit Kaes To Yin, ko her yin arhe yindo kam sulgim mor. Lmien te, E Nut ta ngamyammok mang ka taven to yin ko ya pis orom ka munik. He ekam tok, ngruera kanprim E Nut to man ma volkha ko her En arhe Endo kam sulgim mor.” ");
INSERT INTO sua_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ngata hivuo kam kni kngorom tok, to e Yesus thera vaik ngogun mYerusalem he. To lYerusalem tgus ngaro pkor ngta hop kim to ngta momnganang ngar mruo te, “Ngola ani mhel langta ti e?” ");
INSERT INTO sua_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","To a mumu to ngta veet ekam ngta havae te, “He en e Yesus to nkong mNasaret kun mGalili, her en arhe a propet to e Moses ta ktar kpavap mang.” ");
INSERT INTO sua_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","To e Yesus thera ngae kvaik ogun mnam E Nut ka maksien. Tvaik, to her kaelha kam kekerer endruk tgus ngam kanko kmelel o tgoluk, o mia kmenenkim mar mkor mar, kam le ka nngiar ngang E Nut ormar. To thera kootmerom o psen ruk mkor endruk ngma mopatap orom o krek. To tle kootmerom o ngorsang ruk mkor endruk ngam kael o giu, he nang o mia kmenkim mar mkor mar kam le ka nngiar ormar kat. ");
INSERT INTO sua_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tkaeharom tok, he keknen ngang ngar te, “Ngat ittiegom E Nut karo rhek te, ‘Kua maksien ka ngaeha ka pun na gia vle tuk her gi mang a ngaeha to kam ngarkie mnam.’ Vanangko muk ri, mut her hortgem ka ngaeha ka pun msim ko mut kle kael enangthe a mhe to kam vaik kun mnam kmurur o mia ngaro krek. Ii, mut hortgem he en ta kle kpis enangthe a kre ka nho to o ngauruvik ngma tvok mnam kam totokim mar he koon mang ngar.” ");
INSERT INTO sua_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Teharom tok knop, to kam ngae, to endruk o vivisker kar endruk o kernonhor ngat kaol ngok kim ko tok mnam E Nut ka maksien he tkaeharom mar ko tok. ");
INSERT INTO sua_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","To o ngnes ngat kaelha kmel kavres orom ko tok kat kam kni pum te, “Ngota kanprim yindo E Devit Kaes To Yin ko her yin arhe yindo kam sulgim mor.” Nang o pris ruk laol va o pattermia kmo pos ngta vokong e Yesus karo reha ruk lvu yar ko tkaeharom mar tok va kngan o ngnes kat ko ngat kael kavres orom tok, to ngaro vurkul ngate ksei kam kinkiin ngang he. ");
INSERT INTO sua_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","To ngat pis ko kim he ka mnganang te, “Ngola, yi lua ngan endri ko ngta kni pum in tok gi?” Va e Yesus tkoripang ngar te, “Mare! Mut lo him a propet karo rhek gi, endruk E Nut ta ktar khavaeng dok mang o ngnes ri orom mar te, ‘Yin mruo yi mur kaoppom o ngnes kar o gunsvel mar kam sim ktua kanprim yin hak.’” ");
INSERT INTO sua_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ta re tok, to thera parem mar, nang kngae ngoguo mnam a rengmat to e Betani kam kol a ngonit ko tok. ");
INSERT INTO sua_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","To hop enang ngmo tie marot msim, e Yesus tkottek kuo mBetani he ka grung kmikkiem a ngaelaut kam kta grap ngoguon kmeknik ngok mYerusalem to ta vang. ");
INSERT INTO sua_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ta ngae va kvokom a ho to a pik ko ta sir ko vanam a ngaelaut, to hera ngae kam nho ko vgum va karo gi im ruk o gunsur, nang nop karo miel ngang e. To tkaen o rhek mnam te, “Yin ke pik to enda ngia lo kat kaehi kmelha tete kam ngae kais ngnik ngnik kat e.” A gi hi to tgia re tok, a ho to endo ther gi vui ngatngae. ");
INSERT INTO sua_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kalngunes ngta vokom tok, to ngat ngae gia sor kmar he, to le kmo mnganang ngar te, “He, ngola, a ho to enda tgi marer her gi vui vgum anito e?” ");
INSERT INTO sua_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Va e Yesus ther koripang ngar te, “Kua mien ngang nguk te, enangthe mguak kor mnam muk mang E Nut te, En tkais mang o tgoluk tgus, nang lua lopumtang pum En, va mut kais kmeharom a ho enang tok kat, gi enang ko dok ko eharom tok. Va si a vul to enda va mguer kais kmen o rhek mnam kam reng kat te, ‘Hop ko tok he kle kngae ksir ogu mou,’ va en ner mia ngan vgum muk. ");
INSERT INTO sua_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","He ekam tok, o gi vrong tgoluk ruk mum kaurur kim E Nut mang ngar, E Nut ner mi kaenik ngang nguk enangthe mup kor mnam muk mang En kmenik ngang nguk enang tok.” ");
INSERT INTO sua_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","To e Yesus ta ngae kpis kvaik kun mnam E Nut ka maksien kat he kaelha kam patter o mia. Ta patter mar kngae, va o pris ruk laol kar o Yuda ngalmialaol ngat kaol kpis ko kim he ka mngan pum te, “Erieto tmeng yin kam kerer mor mo mnam E Nut ka maksien ta tok?” ");
INSERT INTO sua_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Va e Yesus tkoripang ngar te, “Vanang dok kat, ngor kle ka ktar ka mnganang nguk kat na. He enangthe mgua re koripang dok, to dok kat, ngor le koripang nguk kam havaeng nguk mang erieto tmeng dok kmeharom tok.” ");
INSERT INTO sua_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Thavaeng ngar tok, to le ka mnganang ngar te, “Erieto tmeng e Yoanes, en kam parrum o mia, E Nut tkuon ma volkha, i o a gi vrong mhel tang?” To ngata mo hem mar mang a papat to endo, to kmo reng ngar mruo te, “Ngola, enangthe ngrua koripang he kre khavaeng te, ‘E Nut to tmeng,’ va en ner kle kaekon ngang ngor te, ‘Va kman ko mut lo kor mnam muk mang?’ ");
INSERT INTO sua_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Vanang enangthe ngrua kle re khavaeng te, ‘A gi vrong mhel tang to tmeng,’ va ngruak kle kgorang a mumu ta kat, ko mar tgus ngtel ngaro papat lserppak mang e Yoanes he, te en a mi propet langto.” ");
INSERT INTO sua_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","He ekam tok, ngat her gi koripang e Yesus he te, “Ngot lua mnor mang e.” Va e Yesus tkat koripang ngar tok kat te, “Te dok kat, klo kais kam havaeng nguk mang Endo tmeng dok kmeharom a ngaeha to endo kat e.” ");
INSERT INTO sua_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","E Yesus tre tok, to kle koka ngang ngar te, “Yu! To muk ruk o Yuda ngalmialaol va muk ruk o pris ruk laol mute ktua pat nngia mang a mhel langto ko klo hal alomin ko ta ktar kngae ngok kim a molpou he kreng te, ‘Vae, tete ma kolkha ta ngiak ngae he kaeha ko ma loot.’ ");
INSERT INTO sua_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Va khal to enda ta ktar khavaeng kteit te, ‘O-o, kua kees.’ To vrua vle, to kta hortgem ka papat to endo to le kngae kaeha kun mnam kteit ka loot. ");
INSERT INTO sua_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","To a mhel ta, ta ngae ngok kim khal langto vat he kta reng tok kat gi. Va khal to endo ta ktar kauyang te, ‘Yu! Titou ngora ngae,’ nang kle va gi vle. Tlo kat ngae e. ");
INSERT INTO sua_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","To mnam lomonopia ri, edim mnam min tkaikkiem kteit ka svil e?” Va ngat koripang te, “Endo a molpou.” To e Yesus thera re kvat ka koka to endo mang o Yuda ngalmialaol va o pris ruk laol te, “Yu! Kua havaeng nguk lmien te, kmikkiem enang tok kat, o kermia ruk ngam kaelha klol o takis kar lraip ruk ngam mur kaen mar mruo ngang lurokol ngta ktar kam kir kmuk he kvavaik ku meorom E Nut ka tavgo. ");
INSERT INTO sua_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ngta ktar tok, ekam ko e Yoanes tpis mo kmuk ruk o Yuda kam khenam muk mang a ngaelaut to E Nut kam susulgim muk tgus, vanang muk, mut lo kor mnam muk mang en he lo kaitgung mularo kerkeknen e. Vanangko o kermia ruk ngam kaelha klol o takis va lraip ruk ngam mur kaen mar mruo ngang lurokol, mar ngat kor mnam mar mang he kle kaitgung ngaro kerkeknen. Ii, mut sia vokom mar ko ngat kor mnam mar mang e Yoanes he kaitgung ngaro kerkeknen tok, vanang mut ngae ho lua svil ge, kmor mnam muk mang en kat he kaitgung mutakor e.” ");
INSERT INTO sua_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","E Yesus ta rum ka koka to endo, to kle kta koka kat te, “Yu! mguak vongnek kim a koka langta kat na. A mmie kteit langto ta kavang ka loot. Ta kurhennek krum to kngam a pal kam paneng a loot kam ttek, va kngam a rambel langto kam toot mang a loot kat. To tkael sarek mnam ngang o mia kam kavang ngaro usiel ruk o grep, nang en thera ngae mnam a mhe langto ko yok. ");
INSERT INTO sua_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kam ngae, to ka loot ta ttek he, to a mmie kteit thera meng kalngunes ngok kim endruk ngata tutuur mnam ka loot, mar kam lluol ngang he ktatar mang a mmie. ");
INSERT INTO sua_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kalngunes ngat pis ko kmar, vanangko endruk ngta tutuur mnam ka loot ngta vle im langto ekon, va por langto kat kngam a yoror, va lalaem langto kat orom o krek. ");
INSERT INTO sua_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","To a mmie kteit ta kta meng kalngunes akuruk kat ge ngok kmar. Endruk endri ngata khor mang endruk tesgun. Va endruk ngta tuur kun mnam ka loot ngta vle gi kteharom tok kat ge ngang kalngunes ruk endri, enang endruk tesgun tok kat. ");
INSERT INTO sua_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kam ngae, to a mmie kteit ta trong orom khal msim kam meng ngok kmar vat ko ta pat re te, ‘Nok pathe ngara totu pum ko hal msim vor.’ ");
INSERT INTO sua_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Vanangko endruk ngta tutuur mnam ka loot ngta vle vokom khal to kmo havaeng ngar te, ‘O, her khal msim to kam kol kteit ka mmie ta arhe. Ngor tarkanang kmim, nang mor kam le kol a mmie ta.’ ");
INSERT INTO sua_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ngat mo havaeng ngar tok, to ngta kleng singni mnam to kait ngku mnok he kngam petgim a loot to endo, to her kaim kngam a yoror.” ");
INSERT INTO sua_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","E Yesus ta rum ka koka to endo, to kle ka mnganang endruk laol te, “To ekam tok, a mmie kteit nak kaol to kanker endruk ngta tutuur kun mnam ka loot?” ");
INSERT INTO sua_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Va endruk laol ngat koripang e Yesus te, “O ker mia ruk endruk, a mmie kteit nera pet mar petgim ka loot he ho mi kut kaim mar lhomye tgus hak, nang kle kael sarek mnam ngang o mia akor ko yok vat, mar kam lluol ngang kun mnam ka loot ko nak ngae ktettek.” ");
INSERT INTO sua_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ngat koripang tok, to e Yesus tle kreng ngar te, “Te nok pathe mut lo him E Nut karo rhek ruk endri gi? Ko ngat ittiegom mar mang her muk ri arhe ko ngat havae te, ‘Endruk ngma ngamrektor ngat keyang a ho langto he kait petgim a rek he ka vlengam. Vanangko a her gi ho to endo arhe ther kle ka vle te, a ho to mang a hokidek to arhe, endo kam sir orom a rek. Va a ho to endo, ta vle ngang ngar tok, ekam ko Ngoldaip mruo ta mrua svil en kam mi ktua vle enang tok arhe. Va ngota vokom tok kat, he kngae kpat mang te, a papat to endo tngae gia ya pum nguaro kerok he!’ ");
INSERT INTO sua_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","He ekam tok, kua havaeng nguk ruk lIsrael te, E Nut nera pet ka tavgo petgim muk gi enang tok kat, to le kael o mia akor ko yok vat, mar kam liepum muk kam vaik ku meorom. Ii, ner kael o mia akor ko yok vat enang tok ekam ko mar ngma khenam ngaro singni orom ngaro keknen ruk vgum E Nut ka tavgo.” ");
INSERT INTO sua_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Ii, va ani mhel to na tunvie pum a hokidek to endo he kvuut malpgem, a hokidek nera krong kpaam kngam a yoror. Vanang ani mhel to a hokidek ta na le ktua vuut kuo malpgem, a hokidek ner mi ktua memelesem hak.” ");
INSERT INTO sua_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","To o pris ruk laol va o Parisiau ngata ngan e Yesus ka koka to tok to le kael te, tmia koka mang ngar lsir. ");
INSERT INTO sua_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","He ekam tok, ngat sia khanang ngar kam kapom kmenpasiker kun ma hengor. Vanangko ngat lo is e, ekam ko ngta gorang a mumu pum, ko mar ngta pat mang e Yesus kat te, en a propet langto kat. ");
INSERT INTO sua_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","To e Yesus ta le kta koka kat ge ngang ngar te, ");
INSERT INTO sua_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“E Nut ka tavgo ta vle enang ko a taven langto ta kunngir kim khal ko ta re kam lei. ");
INSERT INTO sua_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ko tmeng kalngunes kam ngae kvaeng klenar ruk tme mang ngar kam pis ko kim, vanangko klenar ruk endruk ngata kapngan he lo kaelel kuo mang ngar kam ngae e. ");
INSERT INTO sua_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","To a taven to enda ta kta meng kalngunes akuruk yok he smia papsim mar te, ‘Mguak kaen a re ngang endruk ko her me mang ngar te: Kua rum kim kua ngaeha he, he a bulmakau to ko el mang a ngaeha, ngat im, va klenar ruk o sital kat. Va lraip ngat kikhi tgus, he ekam tok mguak kaol he kunngir kim a kolkha ta.’ ");
INSERT INTO sua_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ngta havae tok, vanangko klenar ruk endruk ngata kle kat kael rela to parahi ngok yok. Langto tngae ngok mnam ka loot va langto tkut ngae kmeharom karo reha mruo. ");
INSERT INTO sua_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Vanang akuruk ngta vle ka kleng singni mnam a taven ta kalngunes to ksisieng ngar to kaim mar kngam mar o yoror. ");
INSERT INTO sua_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ngat kaeharom tok, to a taven to enda te sei kam vrek kinkiin hak, to ta meng ka ngaomevek he ngta ngae kngam a ktung kim o erep ruk endruk he krum kim mar tgus va kngampaei pum nga rengmat kat. ");
INSERT INTO sua_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","To a taven to enda thera reng kalngunes akuruk te, ‘Kua re kam tarkanang ko hal kam palengem he, vanangko endruk ko mia me mang ngar ngat lo kteveep is kam pis kunngir kim e. ");
INSERT INTO sua_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","He ekam tok, mgua le kngae vat ngok mo gi vle he gi vrong kvovaeng o vrong mia tgus ruk mguak pis mang ngar ko tok. Mguak vaeng ngar ngte kim dok na, mar kam kunngir kim ko hal kun mnam kua pnes vat.’ ");
INSERT INTO sua_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","To kalngunes ngat hera ngae to kaelha kvovaeng o gi vrong mia tgus ruk ngata pis mang ngar he, endruk o yar va si endruk nong lyar kat. To o mia ri ngat hera ngae ka krong a taven ka rek tngae ho mi kut ottep hak. ");
INSERT INTO sua_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","To endo, a taven vat ther kaol kpis kvuvokom o guliel, va ta nho kvokom a mhel to tlo sim kut kaelel kuo mang kam sreng kam vaik mnam ka pnes e. ");
INSERT INTO sua_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","To thera mnganang te, ‘Ai, kambis ye ktaol ngte nngia kam pis kvaik mo, ko ye lo sim sreng?’ Va en ther gi mtum ka gu kim. ");
INSERT INTO sua_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","To a taven ta thera reng kalngunes ruk ngta toot mang ka pnes te, ‘Muk he, mu ussiem a mhel ta kalo ktiek va kalo nhar he kngam ngku mnok ma slommok, ko tok ko mnam a mhe to o mia ngma vle he vu kaeteti he khem ngaro ngnorok mo kmar.’ ");
INSERT INTO sua_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ii, va gi enang tok, E Nut nma me mang o mia kavurgem kam vaik ku meorom ka tavgo gi enang a taven to tok, vanangko gi mar ruk lgititge ngam sim kut kaelel kuo mang ngar kam vaik ku meorom.” ");
INSERT INTO sua_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kam ngae, to o Parisiau akuruk ngta ngae parem e Yesus ko tok kun mnam E Nut ka maksien he kngae kmo hem mar mang o papat te, mar kam pe gia mnganang e Yesus mang a papat tang, en kam mrua ru pum karo mur rhek mruo. ");
INSERT INTO sua_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","To ngat hera meng ngatlngunes mruo kar ke valngan to mkor e Herot kam ngae kpis ko kim ko tok. Ngat pis ko kim e Yesus he pe gia kanprim te, “O, pattermia ngot sim ktua mnor miik ko im vua mien orom ilaro rhek va ima patter o mia lsir mang E Nut karo pos. Va im lua ruokar kim o gi vrong mia kat e, ko ima rere he lo gia tar yin pum o mia akor kam pat mang ngar, nang ka mnang akuruk e. ");
INSERT INTO sua_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","He ekam tok, ngiak havaeng ngor orom ilaro papat na te, ta sir ngang ngor ruk o Yuda kam ngam o takis ngang lRom ngalaip to tkol a ngaekam to ngma mon te, e Sisa, i o nop?” ");
INSERT INTO sua_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngat pe gia mnganang tok, vanangko e Yesus ta tar ko ngta svil kam kering to kle ka mnganang ngar te, “Muk ruk mularo naprai alomin, kman ko muta kendom ngang dok? ");
INSERT INTO sua_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ma te, mu khenam a kre to kmenkim a takis orom ngang dok, he ko vokom na.” To ngat her kait a kre langto he kaen mkor. ");
INSERT INTO sua_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","To e Yesus thera mnganang ngar te, “Erieto ka nunu va ka munik ta vle kuo mang a kre to enda?” ");
INSERT INTO sua_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Va ngat koripang te, “He e Sisa.” Va e Yesus tkat koripang ngar kat te, “He ekam tok, mguak kaekon o tgoluk ruk ngta khenam e Sisa ka nunu ngak kaeknik ngang kat, vanang kle kaekon muk mruo ngang E Nut ko muta khenam E Nut ka nunu ormuk mruo enang tok kat.” ");
INSERT INTO sua_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ngta ngan ko ta re tok, to ngata senkrip kim tok to ngat her gia parem kngae. ");
INSERT INTO sua_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","To mnam a kolkha to endo gi, o Sadyusi akuruk ngat kle kaol ngok kim e Yesus vat. Her o Sadyusi ruk ngam ktua pat te, o mia ngma yor va ngar lua hop petgim ngaro nnak e. Endri ngat kaol kpis ko kim to pe gia mnganang vat te, ");
INSERT INTO sua_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Pattermia, tennik e Moses tittiegom a pos langto te, ‘Enangthe a mhel tang nak yor, nang nong kles ngang, va knopia nak kle kliepak ekam, nang ktavlom kam llues, en kam hover knopia ka ngausie enang tok.’ ");
INSERT INTO sua_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yu! A pos to endo ta vle tok arhe, vanang ma te, enangthe napa vle tok ko o moornopeik aktiek hori orom alomin ngata vle tete mo kmor, to endo a molpou tlei to yor parem ktavlom, nang tlo llues e. To knopia tle klei orom. ");
INSERT INTO sua_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","To gi enang tok kat mang endo ko pekam min ko ta liepak ekam knopia tok kat to her yor kat. To ta vle enang tok kat mang ngar tgus kam grung kam kol mar tgus ruk aktiek hori orom alomin. ");
INSERT INTO sua_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","To ko pekam ko mar tgus ngat lei orom a vlom to endo he yor, a vlom kat ta le ktua yor vat. ");
INSERT INTO sua_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","To kmikkiem ke ngothoi to endo tok, koknaik mnam a kolkha to E Nut nak kta hover o yoror petgim ngaro nnak, a vlom to enda naka vle te, edim mnam moornopeik ruk aktiek hori orom alomin ktavlom msim, ko mar tgus ngat lei orom?” ");
INSERT INTO sua_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","E Yesus ta ngnek tok, to kle koripang ngar te, “Mularo papat ruk mang o yoror ngat lo vua sir e, ekam ko mut ho lo mi ktua mmok hak mang E Nut karo rhek ruk ngat ittiegom mar kun mnam ka meer va mut lua mmok mang E Nut ka serppak kat. ");
INSERT INTO sua_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ko E Nut ka papat to a minar mang o yoror ta vle ti te, mnam a kolkha to E Nut nak hover o yoror kam kol a ktalhok to kam plong vle ko kim En ngnik ngnik, mar ngar lo kat kael lraip he lurokol kam kta lei ormar kat e. Ko o mia ngar kle va kaenang o engyel kuon ma volkha ruk ngama vle orom a ktalhok to kam vle ngnik ngnik he lua lei kat e. ");
INSERT INTO sua_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Vanang kun mnam E Nut karo rhek ruk mang o yoror, e Ebrehem va e Isak va e Yakop ngata khenam a papat to mang o yoror ma mmok te, ngar mi ktua hop petgim ngaro nnak. Vanangko nok pathe, mut lo him E Moses ka hor to endo vop? Ko E Nut thavae te, ");
INSERT INTO sua_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Her dok arhe dok to e Ebrehem va e Isak va e Yakop ngma vle ko kim dok he ktotu pum dok tennik kngae kais mang tete.’ Ii, thavae tok, he ka khenam a papat to mang o yoror ma mmok te, endruk ngat kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik kam totu pum, her mar ruk ngata kta hop petgim ngaro nnak, nang nong endruk ngat yor he lo kta hop kat e.” ");
INSERT INTO sua_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","E Yesus ta re tok, to a mumu to ta veet ekam ngta ngan ko ta patter o Sadyusi tok, to a mumu tho mi ktua senkrip kim karo papat ruk tpatter mar ormar. ");
INSERT INTO sua_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","To o Parisiau ngta ngnek ko e Yesus ther tver kim o Sadyusi tok, to mar vat ngat kle kaum kpis ko kim e Yesus. ");
INSERT INTO sua_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","To o Parisiau ngaela langto a pattermia kmo pos ther kle kendom ngang e Yesus te, en kam mrua ru pum karo rhek mruo. Tpe gia mnganang te, ");
INSERT INTO sua_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ngola pattermia, kun mnam o pos tgus, edim mnam mar msim ta vle te, a pos to a ngaenpaeir he kir kim klenar tgus?” ");
INSERT INTO sua_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Va e Yesus tkoripang te, a pos to a ngaenpaeir ta vle ti te, “‘Ngiak sovet kmelongtok mang E Nut orom ila ngaung tgus, ila svil tgus va ilaro papat tgus.’ ");
INSERT INTO sua_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A pos to a ngaenpaeir her endo arhe ta laut kir kim klenar tgus. ");
INSERT INTO sua_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Va a pos to ta knaek mang endo thavae ti te, ‘Ngiak kaelongtok mang ilenar kmikkiem enang ko im mur kaelongtok mang yin mruo enang tok kat.’ ");
INSERT INTO sua_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ii, o pos tgus ruk mkor e Moses kar o propet ngartakor ngam her ngae kngarngar mang her alo pos alo ngaenpaeir ri arhe.” ");
INSERT INTO sua_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","O Parisiau ngata kaum ka vle ko tok vop, to e Yesus ta kle ka mnganang ngar te, ");
INSERT INTO sua_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“To mum ktua pat nngia mang Endo E Nut Thim Orom Ka Msasaen te, kaes erieto?” Va ngat koripang te, “En kaes a hipun to e Devit!” ");
INSERT INTO sua_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Va e Yesus ther le koripang ngar te, “Enangthe npa mien te, a hipun to e Devit ka munik ta laut mang Endo E Nut Thim Orom Ka Msasaen ka munik, va kman ko e Devit mruo ta kvam Endo E Nut Thim Orom Ka Msasaen te, Kaldaip to en? Ko E Nunu A Totur ten o rhek mnam e Devit he e Devit ta rere vgum E Nunu A Totur kam havae mang Endo E Nut Thim Orom Ka Msasaen orom karo mur rhek mruo ruk endri te, ");
INSERT INTO sua_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘E Nut thavaeng Koldaip te, ngiak tuur mnam kua tavgo he korsang kuo mang a ngorsang to a miktiek, endo koma nho orom kam ngae kais ko nguak kir kim ilaro imuo, yin kam karkar mang ngar hak.’ ");
INSERT INTO sua_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Vanang mu vokom na. Ma te enangthe tennik, a hipun to e Devit mruo ta mrua hover kaes to E Nut Thim Orom Ka Msasaen kam mrua mon te, ‘Kaldaip to en,’ va nngia ko o mia ngam kaekon kim a hipun to e Devit karo rhek mruo he ka grung orom Endo E Nut Thim Orom Ka Msasaen ka munik kam gia mon te, en kaes a hipun to e Devit, vanang en ta ktar vle tennik ktar mang e Devit?” ");
INSERT INTO sua_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","E Yesus tre tok, to nong tang hak mnam o Parisiau to tkais mang kmoripang e, ko tho tver kmar hak. To kmelha ko tok kngae nong a mhel tang hak ta re kam kat kaegom kta serppak mruo kam mnganang e Yesus mang a papat tang kat e. ");
INSERT INTO sua_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","To e Yesus ta havaeng kalngunes kar o mumu te, ");
INSERT INTO sua_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“O pattermia kmo pos kar o Parisiau ngta kol e Moses ka ngaekam to kam halger karo pos, ");
INSERT INTO sua_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","he ekam tok, mguak lol ngakro rhek tgus ruk ngma pos ngang nguk ormar he kaikkiem mar. Vanang mguak or kam tarhigiang ngar he kolkol ekam mar orom ngaro keknen ruk ngam kaeharom mar, ekam ko ngam lo sim kut kaikkiem ngaro mur rhek mruo e. ");
INSERT INTO sua_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nove, ngam vu kaen o pos ruk lvankue mnam o mia, mar kam sei vgum mar, he ngma kapnes vgum mar kmegom kam sim kut kaikkiem mar. Vanang mar mruo ngam ngae her gi mrua sisrim singni, nang lo vrua turang o mia kmikkiem mar e. ");
INSERT INTO sua_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Va ngam mrua het mar mruo ma mmok te, o mia kam vokom mar he kalpak kim ngaro vu prongran kavurgem va ngaro kangal ko ngarla vha orom E Nut karo rhek ruk ngat ittiegom mar kuo mang ngar kam mrua khenam mar mruo te, ngam vua ngarkie ngang E Nut. Ii, va ngma hover mar mruo kam sreng orom ngaro katam ruk ngat ngae gia rarip ku, kam mrua khenam mar mruo ma mmok kat te, ngat vua sovet kmel ngaro papat mang E Nut kat. ");
INSERT INTO sua_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Va mar ngma sovet kam mrua kakansgum mar mruo kam lol o ngorsang ruk o mia ngma nho orom mar ko po pnes. Va ngma sovet kam mrua kakansgum mar mruo kat kmorsang mnam o ngorsang ruk o mia ngma nho orom mar kun mnam o Yuda ngartaro rektor ruk kam rere mnam mar kat. ");
INSERT INTO sua_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Va ngma sovet kam mrua khenam mar mruo ma mmok ngang o mia ko mo vlemkor kat, o mia kam hover singni ngang ngar ko pum nglenar ngo kerok he kmon mar te, ‘Pattermia.’ ");
INSERT INTO sua_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ii, ngma vle tok, vanang muk mguak kle kor kam tting ngang o mia kam mon ‘a pattermia’ ormuk enang tok e. Ekam ko muk tgus muk o gi moornopeik, nang gi mula pattermia atgiang. ");
INSERT INTO sua_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Vanang muk mguak or kam mon mu teit orom a gi vrong mhel tang mo mmie kat e, ko her mu Teit to atgiang En tkuon ma volkha. ");
INSERT INTO sua_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Va gi tok kat ge, mguak or kam tting ngang o mia, mar kam mon ngaldaip ormuk ko muk Muldaip atgiang, Endo E Nut Thim Orom Ka Msasaen. ");
INSERT INTO sua_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ii, ko endo ka munik ta laut kir kim klenar tgus, her endo arhe nak kle kaeha ngang ngar ha. ");
INSERT INTO sua_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ko endo nam mrua hover en mruo E Nut ner kle ka krus orom. Vanang endo nam mrua krus orom en mruo E Nut ner kle khover.” ");
INSERT INTO sua_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Vanangko suvrum muk ruk o pattermia kmo pos va muk ruk o Parisiau orom mularo naprai alomin. Mguera kol a kapnes ko vgum E Nut, ko muma hos kim o papat ruk mang E Nut ka tavgo he kavettom o mia ko ngma re kam vaik ku meorom kat. He ekam tok, muk mut mur kavettom muk mruo enang tok kat, he lo vaik ku meorom E Nut ka tavgo kat e.  ");
INSERT INTO sua_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Va suvrum muk gi tok kat ge, muk ruk o pattermia kmo pos va muk ruk o Parisiau orom mularo naprai alomin. Ko muk muma kauyang o tahek he klikim mar kun mnam ngartaro rektor mruo, nang kle klol o rektor ruk endruk ngang nguk mruo vat. Va mum ngorom a hoger mularo ngarkie khogerik ko pum o mia ngaro kerok, mar kam vokom muk tok to le kanprim muk. Ii, E Nut ner mi kut kaen a ho kapnes to lho vanker hak ngang nguk kir kim o kapnes tgus hak. ");
INSERT INTO sua_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Va suvrum muk gi tok kat ge, muk ruk o pattermia kmo pos va muk ruk o Parisiau orom mularo naprai alomin. Ko mum ngae sei mang a ruongae kuo ma mou va ko paat kmit si a gi vrong mhel tang ko atgiang kmikkiem mutaro mur keknen mruo. Nang mut her tarkanang kmit ngok kmuk he, va ta vle te, mut her op kim he, en kmis E Nut kam ngam oguo kia paei to a vleir kam ho kir kim muk mruo tok arhe ko muk kat mut kais E Nut kam le kngam muk oguo kia paei to a vleir kat. ");
INSERT INTO sua_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Va suvrum muk gi tok kat ge! Ko muma vle enang o vivisker ruk ngma ker ktong ngarlenar. Ko muk mruo muma havae te, ‘Enangthe a mhel nap kael ka tnangal he kre kvat E Nut ka maksien kmenserpgam ka tnangal tok, va ka tnangal nop ka serppak ngang ekam tok e.’ Ii, vanang mum kle ktua havae te, ‘Enangthe a mhel nap kael ka tnangal he kre kvat E Nut ka maksien ka gol kmenserpgam ka tnangal tok, va ka tnangal ta serppak he a mhel to endo nak kaikkiem ka tnangal enang tok.’ ");
INSERT INTO sua_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hai-e! Mularo lpetuk ngat ho mi ktua tok hak he mularo kerok ngat mi kut psik hak! Ko mut lua mmok te, E Nut ka maksien ka gol tlo laut kir kim E Nut ka maksien msim e, ko her E Nut ka maksien to arhe nam koop kim ka gol, yek ta vle a gol to a totur! ");
INSERT INTO sua_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Va enang tok kat ko mum gi kta havae kat te, ‘Enangthe a mhel nap kael ka tnangal he kre kvat E Nut ka psen to a totur kmenserpgam ka tnangal tok, va ka tnangal nop ka serppak ngang ekam tok e.’ Ii, vanang mum kle ktua havae te, ‘Enangthe a mhel nap kael ka tnangal he kre kvat a gi nngiar to kuo malpgem E Nut ka psen to a totur to endo kmenserpgam ka tnangal tok, va ka tnangal ta serppk he a mhel to endo nak kaikkiem ka tnangal ekam tok arhe.’ ");
INSERT INTO sua_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","He ekam tok, mum ho mia vle enang o vivisker ekam ko mut lua mmok te, a gi nngiar to kuo malpgem E Nut ka psen to a totur to endo tlo laut kir kim E Nut ka psen to a totur msim e, ko her E Nut ka psen to a totur arhe nam koop kim a nngiar to kuo mang, yek ta vle a nngiar to a totur kat! ");
INSERT INTO sua_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","He ekam tok, ani mhel to tkael ka tnangal he kre kvat E Nut ka psen to a totur kmenserpgam ka tnangal enang tok, va karo rhek ngat her mia komor E Nut to nma sirei mang o nngiar tgus ruk kuo malpgem ka psen to kat he. ");
INSERT INTO sua_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Gi enang tok kat ko endo tkael ka tnangal he kre kvat E Nut ka maksien kmenserpgam ka tnangal enang tok kat, va karo rhek ngat her mia komor E Nut to nma vle ko tok mnam ka maksien to endo kat. ");
INSERT INTO sua_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Gi tok kat ge mang endo tkael ka tnangal he kre kvat a volkha kmenserpgam ka tnangal enang tok, ko karo rhek ngat her mia komor E Nut to nam korsang ko mnam ka ngaekam ko tok he ka nho mang o mia kat. ");
INSERT INTO sua_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Va suvrum muk ruk o pattermia kmo pos va muk ruk o Parisiau gi enang tok kat ge. Ko mularo naprai alomin he. Ko muma tagur pum mut ket keknen mruo to ta mrer, endo kam koprang orom o kummin ruk o pnul, o tiptip va o lkiet he kmommen ngaro mhetor te, loktiek he vua nngiar ngang E Nut orom nga mhe to atgiang, nang kle gia kaennegiang E Nut karo keknen ruk lvankue kun mnam karo pos: Endruk kam ring ya mang mulenar, va kam mrung mulenar, va kmor mnam muk mang E Nut kat. Mup kle kpupam o keknen ruk endruk tgus ha, he lua tagur pum mut ket kor tuk e. ");
INSERT INTO sua_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ii, muma vle enang o vivisker ruk ngma ker ktong ngarlenar tok arhe ekam ko muma kolhor mang mut ket keknen to kemilaut hak to endo, nang kle khos kim he kaengnam E Nut karo rhek ruk laol. Gi enang tok, mut kaenang a vivisker to ta glot ka ye orom ke malmget to kemilaut kun kam pet, nang kle kaivie orom a ngaemslang to alautar to a kamel kmengnam. ");
INSERT INTO sua_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Va suvrum muk gi tok kat ge, muk ruk o pattermia kmo pos va muk ruk o Parisiau orom mularo naprai alomin he. Ko muma vle enang o kolhi va o tonggai ruk muma momgol mar ko muma momgol ngakro gi pkor ku mnok, nang kam mnang kun mnam mar. Muta vle tok, ko mum gi mrua momgol mularo gi pkor tuk tok kat, he nang mularo gi pkor kam mmok ko pum E Nut kalo keik, vanang kun mnam muk, muma sovet kam kol a regesal mang o mia kmurur ngaro krek mkor mar ekam mularo vurkul ruk o ho mi kut kaumluo orom o tgoluk. ");
INSERT INTO sua_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Muk o Parisiau mularo kerok ngat ho mi kut vipsik hak ko mut kaenang o kolhi va o tonggai ruk endruk enang tok. He ekam tok, mguaka ktar ka momgol mularo vurkul kun mnam muk na, gi enang ko muma momgol o kolhi va o tonggai kun mnam mar tok kat, yek mularo pkor ngara vle la mmok ko pum E Nut kalo keik tok kat. ");
INSERT INTO sua_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Va suvrum muk gi tok kat ge, muk ruk o pattermia kmo pos va muk ruk o Parisiau orom mularo naprai alomin he. Ko muma vle enang o nnak ruk ngma kavang o nhek va o porkhe kuo kim mar kam pasrengem mar gi kuon mail, vanang kun mnam mar ngat ottep orom a voon to orom o mia ngaro sogi va o tgoluk akuruk ngma kering nguk ko pum E Nut kalo keik. ");
INSERT INTO sua_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ii, muta vle gi enang tok arhe ekam ko kuo mang mularo gi pkor muma khenam ngang o mia te, mut sim kut kaikkiem E Nut karo pos, vanang kun mnam mularo vurkul mum vua kerruru hak kam vua kpoot mang ngar orom mularo kerkeknen ruk ngat ho mi kut kernonho hak. ");
INSERT INTO sua_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Va suvrum muk gi tok kat ge, muk ruk o pattermia kmo pos va muk ruk o Parisiau. Ko tete muma ring ngaekmol ekam o propet ruk tennik ngakro sogi kmelik, va kpasrengem o nnak ruk mkor endruk ngat sim kut kaikkiem E Nut karo pos kat. ");
INSERT INTO sua_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mum kaeharom tok, to kaegom kmimim kim o rhek mang nguk mruo kam re te, ‘Hai-e, enangthe mor ri tete, ngopa vle kar ngorores ruk tennik va ngop lo kais kmenang ngar hak he kturang ngar kmim nguaro propet kngam mar o yoror e.’ ");
INSERT INTO sua_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","He ekam tok, mu vokom na, mularo rhek mruo ruk endruk ngat her mia ngae rkieng nguk tok arhe ko muta vle te, endruk ngtim o propet ngarores ruk muk msim arhe. ");
INSERT INTO sua_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Muk ge muk ge! Mguak tarkanang dok tok kat, gi enang mulmialaol nga kerkeknen to endo ko a val to kmim o propet ta vle kuo mang nguk vop! ");
INSERT INTO sua_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Muk laro inkuol ruk mut ho mi kut kernonho hak! Muta pat re te, mguer kais kmehenam a kapnes to E Nut ta mon muk mang, endo kam ngam muk oguo kia paei to a vleir to ko mGehina? ");
INSERT INTO sua_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","He ekam tok, ngor kaen kuaro propet kar endruk ngaro papat ruk vu laol va o pattermia ngang nguk. Vanang akuruk mnam mar mguer kaim mar he ka krong ngar orom o ot kvat mar engnang o hi kngam mar o yoror, va akuruk mguera kirmekon o khap mnam mar kun mnam o Yuda ngataro rektor mruo kam rere mnam mar ko mguer kaelha kvaik kottek kun mnam a rengmat langto langto kam kol a regesal mang ngar kngae. ");
INSERT INTO sua_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ii, endruk endri ngam sim kut kaikkiem E Nut karo pos ngora meng ngar ngang nguk he mguera kaeharom tok ngang ngar tgus mo mmie. He ekam tok, ngaro gidiel tgus ngara vle kuo mang nguk, he nang E Nut kam mon muk orom ngaro gidiel tgus tok. Ko kmelha orom e Abel ka gidiel ko tennik en tsim kut kaikkiem E Nut karo pos, kngae kais orom a gidiel to mkor e Barakia khal to E Sekaraia, endo mungores ngat im kun mnam E Nut ka maksien ko pgegom E Nut ka psen to a totur va ka maksien ke rek to a totur. ");
INSERT INTO sua_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ii, ko mi ktua havaeng nguk lmien te, muk o mia nga main to tete her muk ruk arhe E Nut ner kael a kapnes ngang nguk vgum ngaro gidiel ekam ko ngaro gidiel ngta vle kuo mang nguk.” ");
INSERT INTO sua_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O-kelenar-Yerusalem-o, a rengmat to e Yerusalem he, mum ngorom a im o propet ruk E Nut tmeng ngar ngok kmuk ko muma lalaem mar kngam mar o yoror. He kom si kaelha tiok he kngorom a svil kam koon mang nguk enang a ngaining ko nma koon mang kles ku meorom kalo ngaeho, vanangko muma kees ge. ");
INSERT INTO sua_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ekam tok, mu vokom na, E Nut nera parem muk petgim mula rengmat hak. ");
INSERT INTO sua_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Va kua havaeng nguk te, mguer lo kta vokom dok, kam ngae kais mnam a kolkha to mguer kael kavres orom dok he ka kni pum dok te, ‘E Nut ta ngamyammok mang ka taven to yin ko ya pis orom ka munik.’” ");
INSERT INTO sua_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","E Yesus ta rum karo rhek ko tok, to her kottek kun mnam E Nut ka maksien he kngae petgim to le kaikkiem a ngaelaut, to kalngunes ngta pis ksir ko kim he kalpak kim o rektor ruk mkor a maksien to endo. ");
INSERT INTO sua_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ngta kalpak kim mar tok, vanang e Yesus tkoripang ngar te, “Kua mien ngang nguk te, o rektor ruk endri ko muta vokom mar tete, koknaik nong ke vur kre tang hak mnam mar ner kais kam kta kru kuo mang kaela ngang kat e, ko o mia ngara pis kmemget tgus krum kim mar hak.” ");
INSERT INTO sua_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kam ngae, to e Yesus tkorsang kuo kim ke vul to e Olip to kalngunes ngat pis ngok kim ko gi mar tuk va ngta mnganang te, “Ngola, havaeng ngor te, mnam ani kolkha to msim ilaro rhek ngar kael mit? Va a kolkha to ngir kaeknik mnam karo ni ngaelmir ruk ngaka ktar kpis? Va a kolkha to a mmie nak nop mnam karo ni ngaelmir ruk ngaka ktar kpis kat?” ");
INSERT INTO sua_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Va e Yesus ta kle koripang ngar te, “Mguak ngangreal ngang nguk tete, matok o mia ngara vraik ormuk petgim dok. ");
INSERT INTO sua_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ko, ktar mang a kolkha to a kser kim kam pis, o mia kavurgem ngara pis he mur kaelel mar mruo orom kua munik. Ngara pis tok, he langto langto ner mrua havae mang en te, her en mruo arhe Endo E Nut Thim Orom Ka Msasaen. He enang tok, o vu ppiagar ri ngara vraik orom o mia kavurgem. ");
INSERT INTO sua_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ii, va ktar mang a kolkha to a kser kim kam pis kat, mguera ngan o ngaus ngaro muktim va mguera lol o rhek pa nghek mang o ngaus kat. Pu tok, vanangko mguak ngangreal ngang nguk kam lua gor, ko o tgoluk ruk endruk ngaka ktar kpapagis mang a kolkha to a kser kim. Vanangko a mi kolkha to endo ngnok vop. ");
INSERT INTO sua_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ko a mmie karo mhetor kavurgem va o serppak kavurgem ngaka ktar khop na, he kmo sir malngaeng ngar mruo na, he kmo kir mo kmar. Va a vang nera vle kun mnam a mmie karo mhetor kavurgem va a koot naka khiker o marhok kavurgem klik kat. ");
INSERT INTO sua_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ii, o ngaelmir ruk endri ngta vle te, a kolkha to a kser kim karo gi ngaelmir, gi enang ko a vlom kalyie nam kaimim kmel a ngaelmir ngang te, ka kolkha to kam llues ta pis he. ");
INSERT INTO sua_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","To o mia ngar kael muk ko maktiegom o mia ruk ngma vongnek kim o rhek, mar kam kol a regesal mang nguk he kael muk kam yor. Va o vrong rhek tgus kat ngar kaelat muk vgum dok. ");
INSERT INTO sua_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","To endo yek, kolngunes kavurgem ngara ksir petgim dok va ngar le kmo hortgi mo kmar mruo he kmo elat mar kat. ");
INSERT INTO sua_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Va o propet la ppiagar kavurgem ngara pis he ka vraik orom o mia kavurgem petgim dok kat. ");
INSERT INTO sua_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Va ekam ko o mia ngara sovet kam kpoot mang E Nut karo rhek kmeharom o kerkeknen, kolngunes kavurgem ngaro papat ruk kmelongtok mang E Nut ngara ngae kmenglol. ");
INSERT INTO sua_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Vanang endruk ngat kle kmatnge vgum o vnek ruk endruk kam kle kor mnam mar mang dok ge kngae kais mnam a kolkha to a kser kim msim, va E Nut nera sulgim mar he kaen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang ngar. ");
INSERT INTO sua_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Va a knovvur to enda orom e Seten ko E Nut ka serppak tkir kim, o mia ngaka ktar khavae orom kngae mnam o mhetor tgus, nang o mia tgus kam ngnek mang na, to endo yek, a kolkha to a kser kim nera pis.” ");
INSERT INTO sua_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“To mguera vokom E Nut ka imuo to a propet to e Daniel ta ktar kpavap mang ko nak pis ksir kun mnam E Nut ka maksien kam likim o mia kam lo kta vaik kun mnam kat. (Vanang muk ruk muta him a hor ta, mgua sim ktua ngangam kmuk ekam o rhek ri na!) ");
INSERT INTO sua_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ii, ko mnam a kolkha to muk ruk ko mYudea mgua re kvokom endo ko nak sir ko tok, va mguak ngoropok kgegerap ngoguon kio vlik. ");
INSERT INTO sua_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Va endruk ngta vle ku mnok ko ma ngoumi, ngak or hak kam kta vaik ngogun ma rek kam kta momlom kat. ");
INSERT INTO sua_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ta vle enang tok kat ngang endruk ngta vle ko gunkas ko ngak or kam kat kaeknik ngok mrek kam lol ngaro it kat. ");
INSERT INTO sua_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ii, va suvrum kekhengol ruk ngakro namtor va endruk ngat gia mmeng ngles vop mnam a kolkha to enda kat. ");
INSERT INTO sua_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","He ekam tok, mguak kaurur kim E Nut te, muk kam lua kar va ngaelaut ka gu mnam a ven va mnam a Sabat kat ko mguak ngoropok mnam a kolkha to endo. ");
INSERT INTO sua_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mguak kaurur kim E Nut tok, ekam ko mnam a kolkha to E Nut ka imuo nak sir, a kernonhommok alaut hak nera vle kat. Va nong a kernonhommok tang, kmelha tennik ko E Nut ta kueng mmie kngae kais tete to tkaiser endo enda hak. Va si tang koknaik kat va ner ho lo mi kaiser endo enda kat e. ");
INSERT INTO sua_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Vanangko E Nut ner kait kokonor o kolkhek ruk endruk. Ko enangthe nap lua kait kokonor mang ngar, va a mhel tang ner ho lo is kam vle hak. Vanangko E Nut ner kait kokonor mang ngar, ekam ko ta pat mang kalngunes ruk tmur re pum mar kam vle ngang En mruo, kam hong ngar pum a kernonhommok to endo. ");
INSERT INTO sua_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","To enang tok, enangthe tang nak pis mnam o kolkhek ruk endruk he khavaeng nguk te, ‘Mu nho na, Endo E Nut Thim Orom Ka Msasaen enda he, i o en tko gut ho,’ va mguak or kmor mnam muk mang karo rhek ruk endruk. ");
INSERT INTO sua_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ko o propet ruk la ppiagar ngara pagis kar endruk ngara ppiak kmel mar mruo te, E Nut tenuram mar, he ngta vle te, Endo Thim Orom Ka Msasaen. Ii, ngar mia pagis orom o ngaelmir ruk ngara reim sor mnam o mia kam mi ktua krong ngaro vrongtok he ka vraik orom kavurgem mnam mar. Va si endruk E Nut tmur re pum mar kam vle ngang En mruo kat, va o kermia ri ngara kaegom kam krong ngaro vrongtok he ka vraik orom mar kat, gi enangthe nga mi kais. ");
INSERT INTO sua_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yu! Ko her havaeng nguk he, mang a kolkha to endo karo ngaelmir ktar mang ngar kam pagis. ");
INSERT INTO sua_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","He ekam tok, enangthe ani mhel tang na re kpis ko kmuk he kreng nguk te, ‘Vokom na, Endo E Nut Thim Orom Ka Msasaen edi gut ko ma kalputmok,’ va mguak or kam ngae ngok kim e. I o enangthe na havaeng nguk te, ‘Edim mkon ta tvok mkon ma rek,’ va mguak or kmor mnam muk mang karo rhek kat. ");
INSERT INTO sua_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mguak or kmor mnam muk mang karo rhek ekam ko mnam a kolkha to A Mhel To Nkong Man Ma Volkha to dok ner kaol kpis mnam, o mia ngar mia vokom ko ma mmok, gi enang ko o mia ngma vokom a koot ma mmok ko nma gurmik klik he kses ngpirik kam valler a volkha karo ngaitngol tgus. ");
INSERT INTO sua_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ii, muk mruo mguer mrua vokom a kolkha to endo he ka mnor mang, gi enang ko a talkou nma vokom a slang ko tkaemik he kam mnor mang he ka kviet kngae mang.” ");
INSERT INTO sua_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Vanangko gi ko pekam a kernonhommok ko nera vle enang tok, E Nut nera rpem a volkha kakro serppak orom o ketor he ngara harapeet kun kuon kia gan va a kolkha nera tep. Va a kenho ner lo kta mmok kat e. ");
INSERT INTO sua_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","To endo yek, A Mhel To Nkong Man Ma Volkha kta ngaelmir vat ner le ktua pis kun kuon kia gan. Ko o mia ngara vokom A Mhel To Nkong Man Ma Volkha ko nera pis orom o varhek kuon ma volkha, va ngara vokom kla serppak va kla mmok. O mia ngara vokom tok, to o vrong rhek tgus ruk mnam o marhok ruk mo mmie ngar kosnok to le kvor pa ngaor he ktolpum o ngoven he kaee kvulhi ku mmie mang ngar mruo. ");
INSERT INTO sua_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ii, A Mhel To Nkong Man Ma Volkha nera pis tok, ko a nglung nak kaeti, to na hera meng kakro engyel kam ngae mnam a mmie karo ngaitngol tgus kam kaum endruk E Nut tmur re pum mar kam vle ngang En mruo ngok matgiang, kam ngae krurum a mmie karo ngaitngol tgus hak.” ");
INSERT INTO sua_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mu vokom a ho to a pik he kol a papat to mang a kolkha to kser kim na. Ekam ko nam re kuur va mum hera mnor te, o-ketasuo he ka venloot to kmel rehi mnam kam pis he. ");
INSERT INTO sua_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mare! Her gi enang tok kat arhe, ko mgua re kvokom a kolkha to a kser kim karo ngaelmir ruk enang tok ko ngaka ktar kpagis kat, va mgua hera mnor kat te, o ketasuo he A Mhel To Nkong Man Ma Volkha en kam pis kat ko ngnok va ngaelaut ka gu he. ");
INSERT INTO sua_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ii, kua mien ngang nguk te, o mia nga main to enda tete, ngat lo kais kam yor vop kais ko E Nut naka ktar kaottam o ngaelmir ruk endri, mar kam pis lmien na. ");
INSERT INTO sua_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ii, a volkha kar a mmie nginera loloong, vanang kuaro rhek ngat lo kais kam loloong hak.” ");
INSERT INTO sua_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Vanangko a kolkha to a kser kim msim, nong a mhel tang hak ta mnor mang te, ani marot to, i o ani vlemas to, i o ani pkolkha to lsir A Mhel To Nkong Man Ma Volkha to dok nera kser kim kpis mnam. Ii, o engyel ruk man ma volkha va ngat lua mnor mang ani kolkha to lsir kat e. Va si E Nut Khal mruo kat, va tlua mnor mang ani kolkha to lsir kat e. Gi E Nut tuk to ta mnor. ");
INSERT INTO sua_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","38","O kolkhek ruk ktar mang a kolkha to A Mhel To Nkong Man Ma Volkha kam kser kim ngar sim kut kaenang endruk ktarang mang e Noa, ktar mang ko tlo kar mnam ka langail vop. Ngar sim kut kaenang ngar tok, ekam ko kun mnam o kolkhek ruk endruk tennik ktar mang ko a kus tlo vuvvuom a mmie tgus vop, o mia ngma hivuo pum a ngaempnes, a ngaenkim lraip, a ngaivie, va a ngaeha to kam palengem ngles kngae kais mnam a kolkha to e Noa mar ngta kar mnam ka langail. Ngta hivuo tok kam ngae kais ko o itok ngat kottek. ");
INSERT INTO sua_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","O itok ngat kottek, nang o mia ngat ngae lo kta paptang anito nera pis kmar e. To ngata senkrip kim o itok ko ngat kottek he kvuvvuom mar tgus. Ii, va a kolkha to A Mhel To Nkong Man Ma Volkha nera kser kim ner mi kael senkrip kim o mia gi enang tok kat. ");
INSERT INTO sua_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nera vle enang tok arhe ko alo ngokol nginera kaum kaeha ko ma loot, he E Nut nera vaeng tang, nang ka mnang langto. ");
INSERT INTO sua_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ii, va alo vlom nginera kaum knonhop, va E Nut nera vaeng tang, nang ka mnang langto. ");
INSERT INTO sua_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","He ekam tok, mgua sim kut kaelel kuo mang nguk he ktoot, ko mut lua mnor mang ani kolkha to lsir endo Muldaip nera kser kim kmeknik mnam. ");
INSERT INTO sua_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Vanangko mguak kol a papat to enda na, ko enangthe a rek kteit npa ktar ka mnor mang a segain ka ni mhe to lsir a ngauruvik ner kaol mnam, va na sim kut kaennei he ktoot mang ka rek mnam ke vgon to endo gi kam lo kaennegiang a ngauruvik kam kher e. ");
INSERT INTO sua_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ii, he enang tok, muk kat mgua sim kut kaelel kuo mang muk mruo tok kat arhe he kpaneng A Mhel To Nkong Man Ma Volkha to dok ko en kat nera pis pangnaom muk gi enang tok kat arhe.” ");
INSERT INTO sua_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ngora havaeng nguk mang a taven kalkayie to karo papat ruk vu laol ko tvu sim kut kael kalaip to endo kmeharom karo reha ruk nam kaelik maktiegom. Va her kalyie to arhe kalaip tel kam nho mang kalngunes tgus ruk ngam kaeharom karo reha tgus va kam klang ngar mlol mnam ngaro kolkhek ruk kam lol mnam mar ko kalaip ta ngae ngok mnam a mhe langto ko yok. ");
INSERT INTO sua_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","47","Kua havaeng nguk lmien te, enangthe kalaip nap kaeknik kpis pangnaom ko nma hivuo kam sim kaeharom karo reha ruk telik maktiegom, va kalyie to endo ta lgekol hak. Ta lgekol ekam ko kalaip ner le ho gi kael kam nho mang karo reha tgus hak. ");
INSERT INTO sua_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Vanang enangthe kalkayie to endo, en a ker mhel he napa vle ktar lhus kim ko ta pat te, ‘O-kolaip te ho khus hak kmeknik he,’ ");
INSERT INTO sua_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","to kle kaelha kmim klenar tgus he gia vle pum a ngaemik va a ngaivie kngae kveve kar klenar ruk ngam kaivie kveve, va ner ho mi ktua senkrip kim ");
INSERT INTO sua_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kalaip ko kalaip ner kaeknik kpis pangnaom. ");
INSERT INTO sua_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","To kalaip ner kaim lhomye kmen o kapnes ruk lvankue hak ngang to le kael en kam kol a kapnes to endruk ngma kerruru ngara kol, ko ngar kaeteti he khem ngaro ngnorok mo kmar.” ");
INSERT INTO sua_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","To e Yesus ta kta koka kat te, “Mnam a kolkha to A Mhel To Nkong Man Ma Volkha to dok nera pis mnam E Nut ka tavgo to nera vle kuo mang o mia nera vle enang ko a vlom langto te gnua lei orom katngokol. Ko a vlom to endo klenar ruk lraivles ruk loktiek ngta sgam ngakro mmok he kngae kam toot kam paneng katngokol to endo, mar kam puknim ekam a ngaelaut to en kam her kaeknik ekam ngok mrek orom ktavlom, he nang mar tgus kam kaum ko tok ko mrek kam kunngir kim. ");
INSERT INTO sua_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Vanang ktar mang a ngokol ko tlo pis vop, a ktiek mnam lraivles ruk endruk ngat sim kut kaelel kuo mang ngar, vanang nglenar ruk aktiek ngaro papat ngta tu. ");
INSERT INTO sua_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","Endruk ngat sim kut kaelel kuo mang ngar, ngat lol ngaro mmok kar ngaro kolhi ruk orom a ye to kam klang ngaro mmok orom. Vanang endruk ngaro papat ngta tu ngat her gi kpom ngaro mmok tuk, nang lo pat mang a ye to kam kta klang ngaro mmok orom kat e. ");
INSERT INTO sua_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","To mar tgus ngta vle to ktar lhus kim a ngokol to endo, ko te ho khus he, to a kenap te ho kvurvrum mar tgus to ngat her ngae onit. ");
INSERT INTO sua_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Vanang tie ma segain ka ho ngaenvurgem hak a movae ta pis te, ‘Vae, mu hohop he, a ngokol to te gnua lei, enda he, mo va ngaelaut ka gu he, he ngruak kaol he, mor kam puknim.’ ");
INSERT INTO sua_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","To lraivles ruk tgus ngta hohop to kpat kam klang ngaro mmok orom a ye. ");
INSERT INTO sua_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","To endruk ngaro papat ngata tu ngat hera kongrang nglenar ruk ngat sim kut kaelel kuo mang ngar te, ‘Mu klang ngor mo itok mang nguaro mmok na, ko ngta re kam tep he.’ ");
INSERT INTO sua_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Vanang endruk ngat sim kut kaelel kuo mang ngar, ngat koripang ngar te, ‘Nove, muta pat te, a ye tis mang ngor tgus? Vanang muk kam ngae ngok kim endruk ngam kael o itok ngang o mia he le kaenkim mutakor ngang nguk mruo.’ ");
INSERT INTO sua_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Phevgom endri ko ngta vle ekam a ngaelaut ko ngta ngae kmenkim a ye, a ngokol to te gnua lei thera pis kvaik kun mnam ka rek. To endruk ngat sim kut kaelel kuo mang ngar he ktoot ka nho ngat hera vavaik kun mnam ka rek ekam kat. To a ngokol to endo thera vat a ngaegot, he mar ngta tuur mnam ka ngaemik. ");
INSERT INTO sua_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Vanang nglenar ngat kaolol knaek kpis to kaurur kim te, ‘O, ngolaip pet a ngaegot kim mor vanie.’ ");
INSERT INTO sua_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Va tkoripang ngar te, ‘Ko smia mien ngang nguk te, ko ngae ho lo ktua mnor mang nguk hak.’” ");
INSERT INTO sua_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","E Yesus ta koka tok ngang o mia knop, to le kreng ngar te, “He ekam ko a kolkha to A Mhel To Nkong Man Ma Volkha na pis mnam nera pis pangnaom muk enang tok kat, va mgua sim kut kaelel kuo mang nguk, ekam ko muk kat mut lua mnor mang ani kolkha to, i o a kolkha ka ni mhe to lsir A Mhel To Nkong Man Ma Volkha to dok nera kser kim kpis mnam.” ");
INSERT INTO sua_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ii, a kolkha to A Mhel To Nkong Man Ma Volkha nera kser kim kpis mnam nera vle enang ko, a mhel langto ta re kam ngae kpunpa ko ma mhe langto ko yok. Ta re kam ngae vanang ta ktar en ka re ngang kalngunes ruk korlotge, mar kmeha malpgem ka gol ka pun. Ten a re, to her kaisis kim mar orom karo kirpik. ");
INSERT INTO sua_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tel karo kirpik ruk aktiek ko maktiegom langto. Va langto yok tel alomin ko maktiegom. Va langto tel agitgiang ko maktiegom. Telik ko maktiegom langto langto tok, kmikkiem langto langto ka serppak tok ge. Telik ko maktiegom mar knop, to hera ngae ngok mnam a mhe langto ko yok. ");
INSERT INTO sua_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","To endo tlol o kirpik ruk aktiek thera ngae ngatngae to kpis kaeha malpgem ngar to hera kla orom o kirpik ruk aktiek kat malpgem aktiek ruk tesgun. ");
INSERT INTO sua_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Gi enang tok kat, mang kaela to tkol alo pek ruk alomin ko ther ngae he kut kaeha malpgem min, to hera kla orom alo pek alomin malpgem ennginduk tesgun kat. ");
INSERT INTO sua_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Vanang nginla to tkol a pek to agitgiang ta kle kut ngae kpis her gi eguyang ku ma mmie kam sim kut tuvgom a pek to mkor kalaip hak. ");
INSERT INTO sua_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kam ngae, to endruk endri ngalaip ther kaeknik kpis ko kim langto langto mnam mar he smia kol a re mang ka gol ka pun. ");
INSERT INTO sua_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","To endo ta kpom o kirpik ruk aktiek ther kaol kpis ko kim kalaip orom endruk aktiek ruk kuo malpgem endruk aktiek tesgun to khavaeng te, ‘Vae, kolaip yel o kirpik ruk aktiek ko maktiegom dok, va ko ngae eha malpgem mar he kat kla orom akuruk aktiek malpgem mar.’ ");
INSERT INTO sua_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","To kalaip tkanprim te, ‘O, kolkayie a yar hak to yin, ekam ko yi ngae sim kut tar kuaro kirpik he sim kut papuntom ike ngaeha atgiang to enda, va tete ngor le kael yin kam ho gia nho mang o reha ruk ngarlavurgem vat. Yu! He vaik ngte kim dok kam kaum ksirei kar dok mnam kua pnes.’ ");
INSERT INTO sua_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Va kalkayie to ta kpom alo pek alomin tkaol kpis ko kim kalaip kat, to khavaeng vat te, ‘Kolaip ye el alo pek alomin ko maktiegom dok va ko eha malpgem min he kat kla orom aloruk malpgem min kat.’ ");
INSERT INTO sua_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","To kalaip tkoripang te, ‘O, kolkayie a yar hak to yin, yi her sim kut papuntom ike ngaeha to kat he, he tete ngor le kael yin kam nho mang o reha ruk ngarlavurgem vat. Yu! Va yin kat ngiak vaik ngte kim dok kam kaum ksirei kar dok mnam kua pnes kat!’ ");
INSERT INTO sua_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Vanang endo ta kpom a pek to agitgiang ta kle kaol kpis vat, to kreng kalaip te, ‘O, kolaip yin a mhel to enda, ko sim kut mnor mang ilaro keknen hak ko im lua non mang o mia e. Im gia vle kam gluegengnam o mia akuruk ngaro tgoluk. Ii, ima vle enang a mhel to nam gi vrong kolaspa kam lluol mnam akuruk yok ngakro luteik, nang en mruo nam lo mrua pet kmeha kam kavang o tgoluk ngang en mruo e. ");
INSERT INTO sua_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kua mnor mang ilaro keknen ruk tok, he kua gor pum ila pek to her gi kut ngae her eguyang hak. He vokom na, ila pek ta he.’ ");
INSERT INTO sua_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ta re tok, vanangko kalaip tkoripang te, ‘Kolkayie to ye ho mi kut kernonho hak to yin, va la lo ehaneng hak to yin. Yu! Ye her mnor mang dok tok te, kom gia vle kam gluegengnam o mia akuruk ngaro tgoluk he ka lluol mnam akuruk yok ngakro luteik, nang lo mur kaeha ngang dok mruo ngola? ");
INSERT INTO sua_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","To yin he, kman ko ye lo en kua pek to ko el ko maktiegom yin ngang a mhel tang to ta re kmel ka kvek, en kmel a tol ko kim yin orom, he nang en kam le kaeha orom kua pek to endo, nang yin kam kol ka mgu va langto malpgem kat?’ ");
INSERT INTO sua_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","To kalaip thera reng kalngunes akuruk yok vat te, ‘Mu marer vret a pek to endo ko maktiegom, nang kle kaen ngang endo teha malpgem endruk aktiek he kat kla orom endruk aktiek kuo malpgem mar kat.’” ");
INSERT INTO sua_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","E Yesus tkoka tok, to le kre te, “A kolkha to A Mhel To Nkong Man Ma Volkha nera kser kim kpis mnam nera vle tok arhe ko endruk ngat sim kut papuntom ngaro reha ruk E Nut telik ko maktiegom mar, va E Nut ner le ho gia sovet kmel o reha akuruk vat ko maktiegom mar, mar kam sim kaeha orom mar kam sim papuntom mar kat. Vanang endruk ngat lo sim kut papuntom ngartaro reha, va si ke ngaeha to kemilaut to E Nut tel ko maktiegom mar, va ke ngaeha to endo E Nut ner kle ho gia vret petgim mar hak. ");
INSERT INTO sua_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Vanang kolkayie to karo reha ngat kle lo vur kael mit, nguak le klikim he kngam ngku mnok petgim kua tavgo ko ma slommok, ko ko tok o mia ngam kaeteti he khem ngaro ngnorok mo kmar.” ");
INSERT INTO sua_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","To e Yesus ta rere kngae vop kam re te, “Mnam a kolkha to A Mhel To Nkong Man Ma Volkha to dok nak pis mnam, nera pis enang a Taven kar karo engyel. Va ner korsang ko mnam ka ngaekam to orom kla mmok to E Nut ten ngang kam nho mang o mia. ");
INSERT INTO sua_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","He mnam a kolkha to endo nera kaum o vrong rhek tgus he ngara sir ko pum kalo keik. To nera mommen mar tgus enang a mhel to nma nho mang o sipsip ko nma mommen mar tok kat he knantom o ngaemslang ruk yok, endruk o got he kaelik ko vanam ka ksienga petgim o sipsip ruk nam kaelik ko vanam ka miktiek. ");
INSERT INTO sua_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","To a Taven to endo nera reng endruk ko vanam ka miktiek te, ‘E Titou ta ngamyammok mang nguk. Mguak kaol he kvaik ku meorom E Nut ka tavgo kam kol a ktalhok to kam plong vle ko kim En ngnik ngnik, endo te mur el kmen ngang nguk tiok he, ko tlo kueng a mmie to enda vop. (Ii, E Nut ka tavgo ta vle te, ka nngiar ngang nguk ruk kles ormuk.) ");
INSERT INTO sua_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kua vaeng nguk kam vaik ku meorom E Nut ka tavgo enang tok, ekam ko kue kvang va mut her klang dok mo ol he. Va kue kat ngaivie va mut her kainir ngang dok kat. Va kue kpis ko kim muk enang a gunmhel va mut hera vaeng dok ngok kmuk kat. ");
INSERT INTO sua_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Va nop o it ngang dok va mut her klang dok kmegen kat. Va kue kyayor va mut smia tar dok va kue ka vle kun pa hengor va mut her kaol kam ptang dok kat.’ ");
INSERT INTO sua_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","To endruk ngat sim kut kaikkiem E Nut karo pos he ka vle ko vanam ka miktiek ngar le ka mnganang te, ‘Ai, Ngoldaip, ngot vokom yin tenngor ko ye kvang va kat kngaivie he ngot her klang yin mo ol va kainir ngang yin e? ");
INSERT INTO sua_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","I o ye kpis mo kmor enang a gunmhel tenngor he ngot her vaeng yin ngok kim mor? Va ngot vokom yin tenngor ko nop o it ngang yin va ngot hera klang yin kmegen kat e? ");
INSERT INTO sua_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Va ye kyayor va ka vle kun pa hengor tenngor he ngot her kaol kam ptang yin?’ ");
INSERT INTO sua_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Va a Taven to endo ner koripang endruk ko vanam ka miktiek te, ‘Kua havaeng nguk lmien te, ekam ko mum kaeharom tok ngang kuaro mia ruk endri, ko ngaro mnok ngat lo vua laut hak va ta khenam te, mut her mi eharom ngang dok tok kat arhe.’ ");
INSERT INTO sua_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Na havaeng endruk ko vanam ka miktiek tok, to ner kle khortgi mang endruk ko vanam ka ksienga to kreng ngar vat te, ‘Mu ehenok ko pum kualo keik ko E Nut tkaengring nguk kam ngae ngok kia paei to a vleir, endo E Nut tmur el kmen ngang e Seten kar karo ker engyel ruk o kool. ");
INSERT INTO sua_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ii, E Nut tkaengring nguk kam vle tok, ekam ko kue kvang va mut lo klang dok mlol e. Va kue kat kngaivie va mut lo kainir ngang dok kat e. ");
INSERT INTO sua_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Va kue kpis ko kim muk enang a gunmhel va mut lo vaeng dok ngok kmuk e. Va nop o it ngang dok kat va mut lo klang dok kmegen kat e. Va kue kyayor va kue ka vle kun pa hengor va mut lo smia tar va ka ptang dok kat e.’ ");
INSERT INTO sua_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Va mar ruk ko vanam ka ksienga ngara koripang te, ‘Ai, Ngoldaip, ngot vokom yin tenngor ko ye kvang va kat ngaivie va ye kpis ko kmor enang a gunmhel va yin nop o it ngang ngin, i o ye kyayor va ka vle kun pa hengor va ngot lo turang yin?’ ");
INSERT INTO sua_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","To a Taven to endo ner koripang ngar ko tok te, ‘Kua havaeng nguk lmien te, mgua lo eharom ngang ikela tang to ka munik tlo vua laut kun mnam endri va mut lo her mi eharom ngang dok kat tok arhe.’ ");
INSERT INTO sua_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ii, o mia ruk ko mnam ka ksienga, E Nut nera likim mar petgim mar kam vle ngok mnam a mhe to ngar kerkol vgum o kapnes ruk lvankue hak, mar kam vle kuo mang ngar ngnik ngnik. Vanang endruk ngat sim kut kaikkiem E Nut karo pos he ka vle ko vanam ka miktiek, E Nut ner kle kaen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang ngar.” ");
INSERT INTO sua_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","E Yesus trum karo rhek tgus ruk endruk to hera reng kalngunes te, ");
INSERT INTO sua_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mut mur mnor he te, a ngaelatong tete, he o Yuda ngara kunngir kim A Pnes To A Engyel Tvarpaam O Yuda Ngaro Molpou. He ngatku ngpalngaim ngar kael A Mhel To Nkong Man Ma Volkha to dok ko maktiegom karo imuo, ngar kam krong orom o ot kvat engnang a ho kngam a yoror kat.” ");
INSERT INTO sua_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ta re tok, to o pris ruk laol va o Yuda ngalmialaol ngat hera kaum kun mnam ngoulu to klalaut to mkor o pris ruk laol ngalaip to e Kaiapas ");
INSERT INTO sua_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","he ngta vle he mo ngam o rhek mo kmar te, nngia he o mia ngar kais kam vur kaol ma mmek he kol a hagie mang e Yesus kmim kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Vanangko ngta mo havaeng ngar te, “O-o, ngruak or kmeharom pa pnes ta e, matok o mia ngar kaum to le kaen ekmor mang.” ");
INSERT INTO sua_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kam ngae, to e Yesus te ka vle mBetani kun mnam a rek to mkor a mhel to tkol a yor to a lepra tesgun. A mhel to enda ka munik e Saimon. ");
INSERT INTO sua_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","E Yesus tkorsang ku mmie he khivuo kmemik, to a vlom langto tpis orom a ku to tenkim orom ka keik to te sei kam grap hak. A ku ta, ta vle kun mnam ka kre to ngma mon te, a alabasta ko o mia ngat hong mnam. A vlom to endo tpis ko kim e Yesus orom a ku to endo he ka glot kuon malpgem. ");
INSERT INTO sua_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Va e Yesus kalngunes ngat her vokom a vlom to endo he, to ngaro vurkul ngat ngae sei kam kiin hak to ngta mo reng ngar te, “Kman ko a vlom ta tgia koham a ku ta ti e? ");
INSERT INTO sua_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ko tis en kmel ngang o mia, mar kmenkim mkor ko ka keik te sei kam grap hak he npa lol o krek ruk kavurgem to le kaenik ngang endruk ngta tu kmo tgoluk.” ");
INSERT INTO sua_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Vanangko e Yesus ta tar ko ngta mo reng ngar tok, to thera reng ngar te, “Mut lo kais kam rere pum a vlom to endo tok e! Ko en teharom a keknen to tho mi kut ya hak ngang dok. ");
INSERT INTO sua_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mguak orim tok, ko endruk ngma tu kmo tgoluk ngara vle mo kmuk lhok ge, muk kam turang ngar. Vanang dok ngor lo kta vle mo kmuk lhok kat e. ");
INSERT INTO sua_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ii, ta glot a ku to endo kuon malpgem dok tok, he ther kael a lte ormok enang tok arhe, ngar kmeguyang dok he. ");
INSERT INTO sua_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kua havaeng nguk lmien te, mnam oni mhetor tgus ruk mo mmie ko o mia ngak polger o rhek mang a knovvur va o mia ngar kta havae mang a keknen to a vlom ta teharom ngang dok tete, o mia kam kuvi mang kat kam vokong en orom.” ");
INSERT INTO sua_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","To gi mnam a kolkha to endo gi ngaela langto mnam o aposel ruk loktiek hori orom alomin ka munik e Yudas to nkong mIskariot thera ngae ngok kim o pris ruk laol ");
INSERT INTO sua_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","he ka mnganang ngar te, “Vae, mut kais kmen anito ngaok ko nguak mas orom e Yesus he kael maktiegom muk e?” To ngat le khim o krek kmis te, a mhelom he hori orom loktiek to her kaenkim en orom mar. ");
INSERT INTO sua_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","To e Yudas ther kaelha kam vur kael onit ngang e Yesus en kam mas orom he kael ko maktiegom mar. ");
INSERT INTO sua_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kam ngae, to tie palngaem ko o Yuda ngat kaem a pnes to ngma mon kat te, A Gi Bret, e Yesus kalngunes ngat kaol ngok kim to ka mnganang te, “Ngola, ya svil mang ngor kmelel mo kim o olngaemik mnam ani mhe to, yin kam kunngir kim a kolkha to A Engyel Tvarpaam O Yuda Nguaro Molpou?” ");
INSERT INTO sua_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","To e Yesus thera havaeng klo kaloyie aloruk te, “Meak ngae mYerusalem ngok kim kua mhel langto he kaen a re ngang kam havaeng te, ‘E Pattermia tkaen a re ta ngang yin te: Ta koner tang mang kua kolkha he, he dok kar kolngunes ngruera pis kam kunngir kim a kolkha to A Engyel Tvarpaam O Yuda Nguaro Molpou.’” ");
INSERT INTO sua_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","To ngint hera ngae to kaelel mo kim o ol mar tgus kam kaum kunngir kim a kolkha to endo kmikkiem gi enang ko e Yesus tmur havaeng ngin tok. ");
INSERT INTO sua_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tie ko a kolkha ta vaik e Yesus kar kalngunes ruk loktiek hori orom alomin ngat her korosang ku mmie kam her kaemik he. ");
INSERT INTO sua_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ngta hivuo kmemik, to e Yesus thera havaeng ngar te, “Kua mien ngang nguk te, langto mnam muk nera hortgi mang dok he kael dok ko maktiegom kuaro imuo.” ");
INSERT INTO sua_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tre tok, to kalngunes ngate sei kam mrua mrung ngar hak to langto langto mnam mar ta mamnganang e Yesus te, “Ngoldaip, nok ya re mang dok vor?” ");
INSERT INTO sua_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Va e Yesus tkoripang ngar te, “Endo ta vasgem ka bret ka mhe kun ma plo kar dok her en to arhe nera hortgi mang dok. ");
INSERT INTO sua_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ii, kua havaeng nguk te, A Mhel To Nkong Man Ma Volkha to dok nak yor kmikkiem gi enang ko E Nut karo propet ngat ittiek mang ko ngata ktar kpavap mang enang tok arhe. Va si enang tok, suvrum kela to nera hortgi mang dok, ko tmi ya hak enangthe knan nap lo kol. Vanangko tho mi kut kernonho hak ko knan tkol he, ko nera kol a kapnes vgum E Nut pum ka kerkeknen to endo.” ");
INSERT INTO sua_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","To e Yudas ther kle ka mnganang vat te, “Pattermia, nok ye lua re mang dok ge?” To e Yesus ther le koripang kam re te, “Mare, her yin arhe gi enang ko yin mruo ye mrua havae.” ");
INSERT INTO sua_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Phevgom e Yesus kar kalngunes ko ngata hivuo kmemik, e Yesus thera kol a bret langto to kanprim E Nut mang to kommen he kaisis kim kalngunes to kreng ngar te, “Mgua kol a bret ta he kaem. Kua vok ta arhe.” ");
INSERT INTO sua_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","To ther kle kol a kolhi orom a ye to a vaen vat he kanprim E Nut mang kat to kaen ngang kalngunes to kreng ngar te, “Muk tgus mguak kol he kmaen kmivie mnam. ");
INSERT INTO sua_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ko kua her gidiel ta arhe to E Nut ta sir malpgem kam mokpom kar o mia orom, ko nera ksuk mang o mia tgus, nang E Nut kam lol o mia ngaro kerkeknen patgiang ngaiting he kikiangae mang ngar vgum arhe. ");
INSERT INTO sua_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ii, kua havaeng nguk kat gi te, kmelha tete ngor lo kat kaiviem a ye to a vaen ta kar muk kat e, kam ngae kais ko ngurer kta kaum kat kmiviem endo a gunngar vat kam tuur mnam E Titou ka pnes to nera kpom mnam a kolkha to ka tavgo nak komor o mia tgus.” ");
INSERT INTO sua_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ngat kaemik knop, to kael a kni to her kottek to ka grap ngoguon kim ke vul to e Olip. ");
INSERT INTO sua_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","To ko tok ma vul to e Olip, e Yesus thera reng kalngunes te, “Muk tgus mguera kpom klaem petgim dok ekam o vnek ruk ngara pis kim dok. Ii, mguera ksir petgim dok tok, kmikkiem gi enang ko E Nut karo propet ngata ktar kpavap mang nguk tok gi ko ngat ittiek te, ‘E Nut nera tgem o sipsip ngar teit he ka valngan to orom o sipsip ngara ngorpok petgim.’ ");
INSERT INTO sua_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Vanang ko pekam ko E Nut nak hover dok petgim kua nnak, ngora ktar mang nguk kam ngae ngok mGalili.” ");
INSERT INTO sua_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","To e Pita thera hop ku to kaekon ngang te, “Dok, ko ngae ho lo kais hak kam ngorpok parem yin e. Si enangthe kolenar tgus ngak ngorpok parem yin ekam o vnek ruk ngara pis kim yin vanie, vanang dok nove!” ");
INSERT INTO sua_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Va e Yesus ta kokheng e Pita kam reng te, “O-o, Pita kua mien ngang in te, gi ngka ma segain ta, ktar mang a ngaining kmeti ngira klai mang dok kngam ngkorlotge te, yi lua mnor mang dok e.” ");
INSERT INTO sua_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Va e Pita tkut kaur gi kmoripang te, “Si enangthe ngua ngae sia yor kar yin va kho lo is hak kam klai mang in e.” To e Yesus kalngunes tgus ngata kol vgum e Pita kam reng en tok kat. ");
INSERT INTO sua_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","To e Yesus kar kalngunes ngata ngae kvaik kun mnam a loot to ngma mon te, e Getsemeni. To e Yesus thera reng ngar te, “Mguak korsang mo na, nang dok ngora ngae vur ngko gut ho he kngarkie.” ");
INSERT INTO sua_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","To ther gia nglum e Pita va e Sebedi klo hal, to endo he, a mamrung alautar hak tkaelha kam kolkol he kerngorom he, ko karo papat ngat ho mi ktua kervavle hak. ");
INSERT INTO sua_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","To thera reng ngar te, “O, a mamrung a ho lautar hak tho mi ktua kolkol dok he. He tre kmim dok, kngam dok hak. He ekam tok, mgua gia vle mo he kaennei he ktoot kar dok.” ");
INSERT INTO sua_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tre tok, to her vur kael a long mang ngar to hera kru ka vham oguon mmie to kngarkie te, “Yoko dok gi Titou-o, enangthe ka papat ngang in ngnok vop va ngia pet la vut to enda orom kua yor ko tre kam kol dok vanie. Vanangko ngior kam kolkol ekmok e, ngiak kle va kaikkiem ila svil mruo ge.” ");
INSERT INTO sua_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tngarkie tok knop, to her kaeknik ngok kim kalngunes ruk korlotge he kvotgem mar ko ngat her onnit he, to kreng e Pita te, “Ngola, nngia orom muk korlotge? Mgua lo vur kais gi kam vur kaennei he ktoot kar dok? ");
INSERT INTO sua_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Vanang mguak mrua toot mang nguk mruo he kngarkie, muk kam lo mrua ngam muk ekam o kerkeknen ruk ngam kaegom muk. Ko muma serppak mang kmikkiem mularo svil ruk kmeharom o keknen ruk lyar, vanangko mularo pkor ngaro svil ruk ngam kaenen muk kmeharom o kerkeknen ngam kle khos kim mularo svil ruk kmeharom o keknen ruk lyar.” ");
INSERT INTO sua_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","E Yesus treng ngar tok, to ther kta parem mar kat kngam nglomin kam kta votam karo ngarkie ruk kat ge te, “Titou, enangthe nop a papat tang ngnok vop, va yin he, ngia her gi kael a vnek to endo kuo mang dok he kaikkiem ila svil mruo.” ");
INSERT INTO sua_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ta kta ngarkie tok knop, to her kat kaeknik ngok kim kalngunes va kpis gi kta votgem mar ko a kenap alautar tho kvurvrum mar he ngat ho onnit ngae hak. ");
INSERT INTO sua_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","To ther kta parem mar kat gi, he kta ngam ngkorlotge he kta votam karo ngarkie ruk kat ge. ");
INSERT INTO sua_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","To ther kaeknik kpis mang kalngunes to her kta votgem mar kat he kreng ngar te, “Ngola, mut le kaol kam pis sim konit vat? Mu nho na, ko her ke longmok to a mhel kam hortgi mang A Mhel To Nkong Man Ma Volkha ta arhe, he nang en kmel ko maktiegom o mia ruk ngam kaeharom o kerkeknen. ");
INSERT INTO sua_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mu hohop he, he mu sor kim a mhel to kam hortgi mang dok na, enda he. So mor he ngor khorong.” ");
INSERT INTO sua_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","E Yesus ta rere vop, nang endruk loktiek hori orom alomin ngaela langto mruo to e Yudas, tkaol orom a rkan to alautar he kpis ko kim e Yesus mar. Ngta pis orom ngakro komtok va ngakro kier ko o pris ruk laol va o Yuda ngalmialaol ngat her meng ngar enang tok arhe. ");
INSERT INTO sua_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Vanangko endo ta hortgi mang e Yesus thera ktar keknen ngang ngar mang a ngaelmir to mar kam mnor mang ko nak pis kaeharom ngang ko thavaeng ngar te, “Mguak vokom dok ko endo nguak pis ko kim he vrua pum ka volha kam mrung tok va her endo arhe. Mguak vokom tok, to le kmarer kpis hera kapom he.” ");
INSERT INTO sua_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","To endo he, e Yudas ther gia ngae lsir rkieng e Yesus to hera kvam te, “O, Kolaip, her yinda arhe” va ta vrua pum ka volha he. ");
INSERT INTO sua_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ta kvam tok, va e Yesus tkoripang te, “Kambis, ya kta hus kman? Ngiak kaeharom a ngaeha to yi kaol ngte mang he.” To a rkan to endo ta murmur mang e Yesus koleng singni mnam he kapom. ");
INSERT INTO sua_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ngta kapom, va vgum e Yesus kalkayie langto ko ther gi kait ka kom ku her gia ngam mang o pris ruk laol ngalaip kalkayie langto va her gi kser ka ngaela ka pun kpet hak. ");
INSERT INTO sua_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","To e Yesus thera tagrie ngang kalkayie te, “Ktel ila kom ko ekam na, ko endruk ngma sovet kmus orom o komtok, her mar ruk arhe ngma yor her vgum a ngaus her tok arhe. ");
INSERT INTO sua_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","He ye lua ngam kim yin ge? Ko her gi tete ta enangthe kop kaen a re ngang E Titou, va en tis kmeng o engyel ngaro ngaomevek akor ko loktiek hori orom alomin ko nak grap, mar kam turang dok. ");
INSERT INTO sua_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Vanangko kop kaen a re ngang tok, mar kam pis krum kim o mia ri va E Nut nak kaottam karo rhek ruk o propet ngat ittiegom mar, mar kam pis lmien nngia, ko karo rhek ngat mur havae ge te, ngak kael mit her gi enang ti arhe.” ");
INSERT INTO sua_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","To e Yesus ta kle kreng a rkan to endo te, “Ngola, nok pathe mut vua kokho orom o komtok va o kier kmurmur mang dok kam kapom dok ko enangthe dok a mhel to koma kaenpgam o mia kam kaum kaen ekam lRom he kaus kar mar vor? Vanang mo kolkhek tgus kom her gi korsang ko kim muk he kpatter o mia ma mmok ko mnam E Nut ka maksien, va mum lua re kam hera kapom dok ko tok? ");
INSERT INTO sua_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Vanangko mguaka kapom dok vanie, ko o tgoluk ruk endri ngak papagis lsir gi enang ti arhe kmaottam o propet ngaro rhek ruk ngat ittiegom mar tok.” E Yesus ta re tok knop, to kalngunes tgus ngat hera ngorpok kparem. ");
INSERT INTO sua_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","To a rkan to ta kapom e Yesus ngta ktong kngorom ngok mnam o pris ruk laol ngalaip to e Kaiapas ka ngoulu to klalaut ko tok mnam E Nut ka maksien. Ngat pis ko mnam a taban to o pattermia kmo pos va o Yuda ngalmialaol ngama kaum mnam kam ngan o rhek mang. ");
INSERT INTO sua_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Vanang e Pita tgi vrua pepem mar kngae orom e Yesus, gi kam ngae kais ko ngata vaik kun mnam o pris ruk laol ngalaip ka ngoulu to klalaut ka taban to ko mnok ko ma gi vle. Ther pis kvaik ko tok korsang kar endruk ngma toot mang a rek he ktoot kam vokom mar pum e Yesus ko ngak ngae ktu orom nngia. ");
INSERT INTO sua_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","To o pris ruk laol va si o Yuda Ngar Ke Murgun tgus, endo nma vongnek kim o rhek ngat kaim o papat he, kam pis mang o mia akor kam ngam o rhek akor ko lserpgue kam ppiak mang e Yesus ormar, nang mar kmim kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Vanangko ngat lo vur pis mang a mhel tang ko karo rhek ngata serppak is e, ko o mia kavurgem ngat sia ngam o rhek kam ppiak mang va ngat lo is mang o mia kmim kngam a yoror e. Kam ngae, to endo he, alo mhel aloruk nginta hop ");
INSERT INTO sua_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","he kngam o rhek kam havae te, “A mhel to enda thavae te, ‘Ngora lget E Nut ka maksien ta, he lo hus kam kta hover kun mnam o kolkhek ruk korlotge.’” ");
INSERT INTO sua_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","To o pris ruk laol ngalaip thop ku sir ko kim o mia to ka mnganang e Yesus te, “Ngola, ya ngan o rhek ruk ngat kaelik kuo mang yin, va nop o rhek ngang in gi kmoripang ngar?” ");
INSERT INTO sua_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Vanangko e Yesus tlua svil kmoripang e, ther gia sir lvongnek. To o pris ruk laol ngalaip ta tger e Yesus kam kta mnganang te, “Kua havaeng in orom E Nut to nma plong vle ngnik ngnik ka munik te, yin kam re lmien kam havaeng ngor te, lmien mang in te, E Nut Khal, Endo E Nut Thim Orom Ka Msasaen her yindo arhe i nop gi?” ");
INSERT INTO sua_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Va e Yesus tkoripang te, “Yin mruo ye her ngae rkieng dok he orom a re to endo. Va kua havaeng nguk tgus te, kmelha tete kngae ngnik ngnik, mguera vokom A Mhel To Nkong Man Ma Volkha ko ner korsang ko mnam E Nut To La Vu Ngaurar Hak ka miktiek. Va mguera vokom kat ko ner kaol kpis kun kuon ma volkha orom o varhek.” ");
INSERT INTO sua_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","O pris ruk laol ngalaip ta ngan ko e Yesus ta re tok, to ther hop ekam karo it to her kommenik kam polger ka ngaesik, to kre te, “Ngrua lo kat kais kam kta vae mang o mia akor kam pis kam ngam o rhek mang kat e, ko muk mruo mut her mur ngan ko ther mur kerrereng E Nut orom karo mur rhek mruo enang tok arhe. ");
INSERT INTO sua_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Va muta pat nngia? Mguer kael ani vnek to kuo mang e?” Va ngat koripang te, “Tho mi kut is mang en, mar kmim kngam a yoror hak.” ");
INSERT INTO sua_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","To akuruk mnam mar ngat kaelha kam guguspa mang kalo keik to khim singni malpgem va kpokpelam. ");
INSERT INTO sua_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Va ngta reng te, “Yindo E Nut Thim Yin Orom Ka Msasaen va yindo a propet, va yin he, ngiak mon edim mnam mor tim yin.” ");
INSERT INTO sua_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Vanangko e Pita tkorsang ha ku mnok vop kun mnam o pris ruk laol ngalaip ka ngoulu to klalaut ka taban to ko ma gi vle. To a vlom to nam kaeha ko tok tkaol ngok kim to kreng te, “Yinda kat arhe im kaikkiem e Yesus to nkong mGalili.” ");
INSERT INTO sua_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Vanangko e Pita ta klai ko kim mar tgus te, “O-o, klua mnor mang o rhek ruk ya rere orom mar e.” ");
INSERT INTO sua_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","To e Pita ther kottek kam vrua kle ngogu va gudor ngku mnok va a vlom langto kat tgi kta vokom to khavaeng o mia ruk ko tok mang kat te, “A mhel ta, nam kaikkiem e Yesus to nkong mNasaret kat.” ");
INSERT INTO sua_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Va e Pita tho gi kaur ge kam re kvat E Nut ka munik kam klai kat te, “Ko ngae ho lua mnor mang a mhel to enda hak.” ");
INSERT INTO sua_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ngata vrua vle, to o mia akuruk ngta sisir ko rkieng ngata kta reng e Pita kat gi te, “O lmien hak he, kalkayie langto yin arhe ko im kollom ktui enang ngar tok arhe.” ");
INSERT INTO sua_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Va e Pita thera koripang ngar he mur kaengring mruo te, “Yu! Enangthe nguaka ppiak va E Nut nak kaim dok kngam dok a yoror. Kua havaeng nguk te, klua mnor mang a mhel to endo hak.” A gi hi to ta re tok, va vgum a ngaining ko ther kaeti. ");
INSERT INTO sua_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tkaeti, yek e Pita ther gia pat mang e Yesus karo rhek ruk ta ktar kpavap mang en ormar te, “Ktar mang a ngaining kmeti, ngira klai mang dok kngam ngkorlotge te, yi lua mnor mang dok.” E Pita ta pat mang o rhek ruk endruk to her kottek kun mnam a maksien to endo he kngae kpolger karo reti laut. ");
INSERT INTO sua_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kam ngae, to tie marot msim, o pris ruk laol kar o Yuda ngalmialaol tgus ngat kaum lgem a re, mar kmim e Yesus kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","To ngat le kaussiem e Yesus kalo ktiek to hera kottek orom kun mnam E Nut ka maksien he ka ktong kngorom to kael ko maktiegom e Pailet, endo lRom ngtel kam nho mang lYudea. ");
INSERT INTO sua_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","To e Yudas, endo thortgi mang e Yesus, ta tar ko ngat kaum lgem a re kmel e Yesus kam yor, to ta mrua koon pum, to klol o krek ruk a mhelom hori orom loktiek to her ngae kmekonik ngang o pris ruk laol va o Yuda ngalmialaol. ");
INSERT INTO sua_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tkaekonik he khavaeng ngar te, “O, ko eharom a kerkeknen to kam hortgi mang a mhel ta tlo eharom a kerkeknen tang e, he ngara kaim kngam a yoror he.” Va ngat koripang te, “He kmanker yin? Ita ngaeha mruo ko he!” ");
INSERT INTO sua_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","To e Yudas thera ngam o krek ku mmie ko tok kun mnam E Nut ka maksien, nang her kottek kparem mar kngae, to her ngae mrua rgom. ");
INSERT INTO sua_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","To o pris ruk laol ngat her le klol o krek ruk endruk to kre te, “O krek ruk endri ngat her vle mang a mhel ka gidiel he, he ekam tok, tlo vua sir kmikkiem e Moses karo pos ngor kmelik kun mnam E Nut ka maksien ka ngaelpas e.” ");
INSERT INTO sua_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","To ngat hera lgem rhek mang a kre to endo kmenkim a mmie ka mhe to kmeguyang o vrong rhek ruk o hirtek mnam. A mmie ka mhe to endo ka munik msim ta vle te, “e Potter.” ");
INSERT INTO sua_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","To tar ko ngma mon a mmie ka mhe to endo te, “A Mhe To A Gidiel” kngae kais tete tok ge. ");
INSERT INTO sua_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","He kmikkiem enang tok, o Yuda ngalmialaol ngat enkim a mmie ka mhe to endo he kaottam E Nut ka propet to e Yeremaia karo mur rhek mruo ko tennik ta ktar kpavap mang o Yuda ngalmialaol ri orom mar te, “Ngat lol o krek ruk a mhelom hori orom loktiek, a her keik to arhe lIsrael akuruk ngat mur monik kim en mang, ");
INSERT INTO sua_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","he kle enkim a mmie ka mhe to ngma mon te, “e Potter” ormar kmikkiem enang ko Ngoldaip tmur keknen ngang dok tok ge.” ");
INSERT INTO sua_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ngata lgem o rhek kmenkim a mmie ka mhe to endo, nang o mia ngat hera srim e Yesus ko kim e Pailet kalo keik. To e Pailet thera mnganang te, “Ngola, O Yuda Nga Taven msim to yin arhe?” Va e Yesus tkoripang te, “Yin mruo yi her ngae rkieng dok he, orom a re to endo!” ");
INSERT INTO sua_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Va o pris ruk laol va o Yuda ngalmialaol ngat kael o rhek kuo mang, vanang en tlo ktua re kmoripang ngar e. ");
INSERT INTO sua_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","To e Pailet ta kle ka mnganang te, “Ngola, yi lua ngan o rhek kavurgem ri gi, o mia ngata mon yin ormar?” ");
INSERT INTO sua_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Va e Yesus tlo kta svil kmoripang a re tang hak. He ekam tok, e Pailet te sei kam mrua sor mang. ");
INSERT INTO sua_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Vanang mnam a pnes to endo ko Yuda ngma kunngir kim, lYuda ngalmialaol ruk lRom ngam kaikkiem a keknen to kam hong a mhel tang kun mnam a hengor, en kmeknik ngok kim o Yuda. A mhel to, o Yuda mruo ngama svil mang lRom kam hong en kmeknik ngok kmar. ");
INSERT INTO sua_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Va mnam o kolkhek ruk endruk lRom ngat el a mhel langto kun mnam a hengor, ka munik e Barabas. O mia tgus ngta mnor mang ko nam vua kerngnek. ");
INSERT INTO sua_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","To a mumu tpis kaum ko kim e Pailet to e Pailet thera mnganang ngar te, “Yu! Muta svil mang edim mnam min, dok kam hong ngok kmuk, e Barabas i o e Yesus, endo o mia ngma mon kat te, Endo E Nut Thim Orom Ka Msasaen?” ");
INSERT INTO sua_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","E Pailet tpe gia mnganang ngar tok ekam ko ta mnor mang lYuda ngalmialaol ko ngam kaesik kim e Yesus, he ekam tok ngat her gi kael ko maktiegom mruo. ");
INSERT INTO sua_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Vanang phevgom e Pailet ko tkorsang he kvongnek kim e Yesus, e Pailet ktavlom ten a re to mang e Yesus ngang kam hagam ko thavaeng te, “A mhel to endo, en a mhel to nam sim kut kaikkiem E Nut karo pos he ngiak or hak kmel ila gu kuon mang e, ko tenkier ko engogo orom, he tete kua sei kam gor vgum her en arhe.” ");
INSERT INTO sua_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Vanangko o pris ruk laol va o Yuda ngalmialaol ngata rere mnam a mumu ge, mar kam reng e Pailet, en kam hong e Barabas, nang kle kaen e Yesus ngang o mia, mar kmim kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","To e Pailet ta kta mnganang ngar kat ge te, “Yu! Muta svil dok kam hong edim mnam min ngok kmuk.” Va ngat koripang he kre te, “E Barabas!” ");
INSERT INTO sua_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","To e Pailet ta kta mnganang ngar te, “Vanang nguak kanker e Yesus, endo o mia ngma mon te, Endo E Nut Thim Orom Ka Msasaen?” Va mar tgus ngat kaum koripang te, “Krong orom o ot kvat engnang a ho!” ");
INSERT INTO sua_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Va e Pailet tkoripang ngar te, “Kman? Muk mruo mguak havae mang ani kerkeknen to msim teharom.” Vanangko a mumu ta kle va ho gia vui klik hak te, “Krong orom o ot kvat engnang a ho!” ");
INSERT INTO sua_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","To e Pailet ta vokom ko tsi mur kaenang pmar, va ta vokom ko o mia ngat re kaum kmen ekam en, to ta kol a plo orom a ye to her reng ngar te, “Ko kaelelsingni kam khenam ngang nguk te, a mhel to enda ka gidiel mut lo is kmel kuo mang dok e. He muk, mula ngaeha orom ko he.” Tre tok, to her kaelelsingni ko pum a mumu ngaro kerok. ");
INSERT INTO sua_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","To a mumu to endo ngat kaum koripang kam vui te, “Yu! He te vanie! E Nut nak mon mor kar ngorores ruk koknaik orom a mhel to endo ka gidiel.” ");
INSERT INTO sua_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ngat re tok, to e Pailet thera hong e Barabas ngok kmar, nang kreng a rkan kam kirmekon a khap mnam e Yesus. Ngata kirmekon a khap mnam knop, to e Pailet ther kle kael ko maktiegom endruk ngma kar va tomten, mar kam le ka krong orom o ot kvat engnang a ho. ");
INSERT INTO sua_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","To e Pailet kalngunes ruk ngma kar va tomten ngta kpom e Yesus kngae kvaik orom kun mnam a ngoulu to klalaut to mkor lRom nga ngaomevek ngalaip. To ngata vaeng nglenar tgus ruk kun mnam nga rkan to endo kam kaum ko kim kat. ");
INSERT INTO sua_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","To ngata kuit pum, nang kle kaegenkar vat orom a yet to a svel, enang endo o taven ngam kaegenkar. ");
INSERT INTO sua_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","To ngat hera llum a vlak he ka llim kuon malpgem to le kael a kop ko maktiegom ka miktiek kam sreng enang a mi taven. To langto langto mnam mar ta tubulkek ku penharom kam klel orom kam reng te, “Yu! O Yuda Nga Taven to yin arhe!” ");
INSERT INTO sua_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","To ngta guguspa mang to ka vret a kop to endo ko maktiegom he khim palpgem. ");
INSERT INTO sua_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ngat hera klel orom tok knop, to ngat le khong a yet to endo, nang kle kat kaegenkar orom kta yet mruo. To ngat hera ktong kngorom kngae ka me ka krong orom o ot kvat engnang a ho. ");
INSERT INTO sua_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ngat kottek kun mnam a rengmat to endo he ka ktong kngorom e Yesus ekam a ngaelaut. To ngta ting kim a mhel langto ka munik e Saimon to nkong mSairini. To endruk ngma kar va tomten ngata kol a hagie mang kam sopong en kam tolpum e Yesus ka ho to kmoreker kuon. ");
INSERT INTO sua_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ngta ngae kngorom to kpis ko mnam a mhe to ngma mon te, e Golgota. (Vanang a munik to e Golgota ka pun ta vle te, “A mhe to ta nho enang a mhel ka lpek ka kolhi.”) ");
INSERT INTO sua_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","To ko tok ngat hera kol a ye to a vaen ka mten to ngat mo vavaikar orom a lkiet ka ye to ngat kaegom kmen ngang. Tre egom va mnor mang, to kees kmiviem. ");
INSERT INTO sua_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kam ngae, to ngat le ka krong orom o ot kvat engnang a ho. To endruk ngma kar va tomten ngat kaelha kam khanier kam kir mo kmar kmisis kim karo it. He enang tok, ngat kaottam a propet ka re langto kat ko tennik ta ktar kpavap mang ngar gi enang tok te, “Ngata khanier kam kir mo kmar kmisis kim kuaro it.” ");
INSERT INTO sua_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ngata khanier tok knop, to her gi korsang ko tok kam gia toot mang. ");
INSERT INTO sua_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Va kuo malpgem ko engnang a ho ngat el o rhek ruk ngta mon en ormar te: ");
INSERT INTO sua_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Vanang ko vanam e Yesus ngta krong alo ngauruvik aloruk orom o ot kvat min engnang ngintalo ho kat. Langto ko vanam ka miktiek va langto ko vanam ka ksienga. ");
INSERT INTO sua_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nang o mia ruk ngama kaol ekam a ngaelaut ngam kaol va ngma kirhek ngang e Yesus he kaerer ngaro lpetuk kim ");
INSERT INTO sua_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","he kreng te, “Ngola, yindo ima havae te, ngira lget E Nut ka maksien he gi kta hover mnam o kolkhek ruk korlotge, her yinda arhe? Te yin he, mur sulgim yin mruo ko tok he grung petgim a ho to ngta krong yin orom o ot kvat yin ko engnang. Ii, enangthe lmien te, E Nut Khal to yin, va yin he, mur hong in he grung ngku kuon petgim a ho to ngata krong yin orom o ot kvat yin ko engnang.” ");
INSERT INTO sua_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Va o pris ruk laol kar o Yuda ngalmialaol va o pattermia kmo pos ngta kol a klel orom gi enang tok kat kam reng te, ");
INSERT INTO sua_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Te en nma sulgim o mia akuruk, vanang kman ko tlo kaeharom ngang en mruo tok? He nong lIsrael Nga Taven to en gi? Va enangthe lmien tok, va en npa grung ngku kuon petgim a ho to endo na, yek ngrer mi kor mnam mor mang en. ");
INSERT INTO sua_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","He nong en a mhel to nma kap kim E Nut gi? Yu! Te en he, ngruak vokom E Nut kam sulgim tete mo he, enangthe npa svil, ko en nam mrua havae mang en mruo orom karo mur rhek mruo te, ‘E Nut Khal to en.’” ");
INSERT INTO sua_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Va si alo ngauruvik ruk ngta krong ngin orom o ot kvat min engnang alo ho ruk ko rkieng e Yesus kat va min tgus nginta kirhek ngang e Yesus kat. ");
INSERT INTO sua_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pkolkha vop, va vgum a slommok ko ther gi pis pgeik komor a volkha va a mmie tgus kngae kais mavlemas. ");
INSERT INTO sua_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","To rkieng ko a slommok tre kam nop mavlemas, E Yesus ther kael ka ktui orom ka re mruo te, “Eli, Eli, lama sabaktani.” To kam hortgem ka re to endo ka pun ta vle te, “Nut-o, Nut-o, yindo kom kor mnam dok mang in, kman ko ya ksir petgim dok?” ");
INSERT INTO sua_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Vanang o mia akuruk ngta sisir ko tok, ngta ngan ko thavae tok, to ngata havae te, “Ta munik kim e Elaisia vor.” ");
INSERT INTO sua_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","To langto mnam mar ther gia hop ku he ksap kvasgem a paspas kun mnam a ye to ngat eharom orom a ho ka ye to tgia gruk. To ta kleng ko vgum a kerker he kngae ktuom ngok vgum e Yesus te, en kmiviem. ");
INSERT INTO sua_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Vanangko klenar ngta hagam kam reng te, “Ngruak or na, he ngor kam vokom te, e Elaisia ner mi kaol kpis kam sulgim o nop.” ");
INSERT INTO sua_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","To e Yesus tkat kael ka ktui klik kat gi, to ka nunu thera parem. ");
INSERT INTO sua_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tyor tok, va vgum a yet to nam kaeltoot mang E Nut ka maksien ke rek Ka Taban To A Ho Totur Hak ko ther gi kommenik kam ngam ko vgum kalo gu tgus kmel kalo kae alomin. Va a mmie ta khi he o krek ngta kokohir. ");
INSERT INTO sua_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Va o yoror ngaro nnak kat ngata kommenik he o yoror kavurgem ruk ngam sim kut kaikkiem E Nut karo pos tennik ngta kta ktal he kta hop kat. ");
INSERT INTO sua_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","To ngat kottek kun mnam ngakro nnak. (Vanang ko pekam ko E Nut thover e Yesus petgim ka nnak, o yoror ri, ngta vavaik kun mnam a rengmat ka pun to e Yerusalem he mrua kekhenam mar mruo ngang o mia kavurgem.) ");
INSERT INTO sua_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","To lRom nga ngaomevek ka rkan langto kalaip kar kalngunes ruk ngta vle ko kim e Yesus he ktoot mang, ngta vokong ko a mmie ta khi va kvokom o tgoluk tgus kat ko ngta papagis enang tok, to mar ngat ngae sei kam gor to kre te, “Ai, ho mi kut lmien hak he, a mhel to enda her E Nut Khal Msim ta arhe.” ");
INSERT INTO sua_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Vanang lraip kavurgem kat, endruk ngata mokpom kar e Yesus ko mGalili he kaikkiem kmelha kaeha vgum, ngta vrua sisir ko vur hagenmok mang he ka vle kvokom mar orom kat. ");
INSERT INTO sua_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lraip ruk ngta sisir ko tok, mar e Maria to nkong mMagdala, kar kyok to e Yems kre e Yosep ngin nan, va e Sebedi kles ngar nan. ");
INSERT INTO sua_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","To a kolkha tre kam vaik to a mhel langto nkong mAramatea ta vle. Ka munik e Yosep, en e Yesus kalkayie langto kat. Va tvu kais kmo krek kat. ");
INSERT INTO sua_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ta ngae ngok kim e Pailet he ka mnganang mang e Yesus ka mnes, en kam kol he kael. To e Pailet tkaen a re, mar kmorim e Yesus ka mnes maktiegom. ");
INSERT INTO sua_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","To e Yosep thera ngae kharpet e Yesus ka mnes kuo va ho, to le kokomor orom a yet to a gi gunngar. ");
INSERT INTO sua_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","To thera kokol kngorom to kael kun mnam kta nnak mruo, endo a gunngar ko ngat gi gnua hong mnam a kre he lo el a mhel ka mnes tang kun mnam vop. Tel knop, to kvulhagam a kre to alautar ko va kre ka nho ka gu kmelegot orom. Tkaelegot orom knop to hera ngae. ");
INSERT INTO sua_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Vanang e Maria to nkong mMagdala kar kyok ngint korsang he ka nho rkieng ka nnak. ");
INSERT INTO sua_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mnam a kolkha to endo o Yuda ngat kaelel mo kim o tgoluk kam paneng a Sabat ko tre kam vuut. To hop enang ngmo ko a Sabat vop, o pris ruk laol va o Parisiau ngta kaum ko kim e Pailet he kael a re kim kam reng te, ");
INSERT INTO sua_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Ngorlaip ngota pat mang a mhel to endo, ko nam vua ppiak ko tesgun ko ta vle vop, tre orom karo rhek ruk endri te, ‘Ko pekam o kolkhek ruk korlotge E Nut ner kta hover dok petgim kua nnak kat.’ ");
INSERT INTO sua_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","He ekam ko ta re tok, ngiak kaen a re ngang a rkan tang kam vle ko va nnak kam toot mang kais mang o kolkhek korlotge ri na, nang kalngunes kam lua pis kaurur ka mnes he le kauyang o mia mang te, tkat hop petgim ka nnak kat. Te matok, ka ppiak to endo aktarang ner vrua vle tok, vanang kalngunes kat ngar, koknaik, ner kle ho mia ker vavle hak.” ");
INSERT INTO sua_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","To e Pailet ther kaen a re te, “Yu! Ngor kael a rkan tang ko maktiegom muk va mguak ngae he kreng ngar kam sim ktua toot mang hak kmikkiem mularo papat kmeharom gi enang tok.” ");
INSERT INTO sua_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","To a rkan tngae kpis ko tok to ngat hera kleng o minmin ko va nnak ka gudor kam her smia toot mang enang tok. ");
INSERT INTO sua_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","To hop enang ngmo ko a Sabat tnop, ko a kolkha tre kam plek, e Maria to nkong mMagdala kar kyok ngint hop khalki tie mo kao he kngae kam vokom e Yesus ka nnak. ");
INSERT INTO sua_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nginta ngae va vgum a mmie ko ta khi klik hak. To a engyel langto ta grung ngkun kuon ma volkha he kngae ko pe Yesus ka nnak to kvulhagam a kre to ngat elegot kim e Yesus ka nnak ka gu orom petgim a nho. Tvulhagam knop, to korsang mang. ");
INSERT INTO sua_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Vanang a engyel ka vok tho mi kut nan hak enang a koot ko nma gurmik he kmallek. Va karo it ngat ngae gia kas hak enang o varhek ruk la mongar hak. ");
INSERT INTO sua_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","To a rkan to ko tok, ta vokom tok, to kgorang he ngaro nunu ngat ho mi kut parem mar hak. Va ngaro pkor tgus ngta khi he ngta vuvuut oguo mmie he kyor ka ktal. ");
INSERT INTO sua_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ngat yor ka ktal ko, nang a engyel ta reng alo vlom ruk ennginduk te, “Me or kam gor, ko kua mnor te, meta pis kam vokom e Yesus to ngat krong orom o ot kvat engnang a ho. ");
INSERT INTO sua_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nangko en nong mo e, ko ther hop petgim ka nnak ta he, kmikkiem gi enang ko ta ktar khavae tok. He meak marer aol ngte he vokom ka ngaekam to ngat el mnam na. ");
INSERT INTO sua_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Meak vokom na, to meak le kngae khavaeng kalngunes mang te, ‘Tkat hop petgim ka nnak he, he en nera ktar mang nguk kam ngae ngok mGalili. He her ko tok arhe mguer kta vokom kat.’ Yu! Ko her havaeng ngae he.” ");
INSERT INTO sua_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nginta ngnek tok, to her lo hus hak kam parem a nnak to endo ko nginta gor. Ngint sia gor, vanangko ngint le ksirei kat ge, mang a engyel karo rhek kat. Nginta sirei tok, to ksap kmeknik kam havaeng kalngunes mang, ");
INSERT INTO sua_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","va vgum e Yesus mruo ko thera sir ko pum nginalo keik ko va ngaelaut. Nginta vokom ko tok, to e Yesus ta havaeng ngin te, “Mealo vrek nginak kongeik.” Ngint ngan ko ta re tok, to kaol kpis ko kim to ktubulkek ku penharom he ka kpom kalo nhar kam totu pum. ");
INSERT INTO sua_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Va e Yesus thavaeng ngin te, “Meak or kam gor. Vanang meak kle kngae khavaeng kuaro mia kam ngae ngok mGalili ko ngara vokom dok ko tok.” ");
INSERT INTO sua_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Phevgom alo vlom ri ko nginta hivuo kmeknik, akuruk mnam a rkan to endo ngat kaeknik kat ko mYerusalem he khavaeng o pris ruk laol mang o tgoluk tgus ruk ngat pagis kim mar. ");
INSERT INTO sua_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","To o pris ruk laol ngta vaeng o Yuda ngalmialaol he ngata kaum kam lgem o rhek mang a papat tang, mar kmeharom. To ngat kaenkim endruk mnam a rkan to endo orom a keik alaut ");
INSERT INTO sua_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","he kreng ngar te, “Mguak hohos kim a re ngang o mia te, ‘Mut hivuo kmonit masegain, nang kalngunes ngat pis urur ka mnes.’ ");
INSERT INTO sua_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mguaka ppiak tok, va enangthe e Pailet na kol a re mang nguk te, mut onit tok, va ngurer kael vrek longeik ngang, en kam lo kael muk kam yor e.” ");
INSERT INTO sua_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Endruk mnam a rkan to endo ngata ngan o rhek tok, to ngata tting kam ppiak enang tok kam lol o krek. To ngat hera ngae kaikkiem o pris ruk laol ngaro rhek enang tok ko ngat havaeng ngar. He ekam tok, a ppiak to endo ta vaas kim o Yuda tgus ko ngma maen kngae kais mang tete tok ge. ");
INSERT INTO sua_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","To E Yesus kalngunes ruk loktiek hori orom atgiang ngata ngae ngok mGalili to kgerap ngoguo kia vul to ta ktar mur havaeng ngar kam ngae ko tok. ");
INSERT INTO sua_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ngta gerap ngoguo kia vul knop, va kvokom e Yesus ko ta vrua vle malhagenmok mang ngar vop, to ngat hera tubulkek kam totu pum. Vanang akuruk mnam mar ngata lopumtang pum vop. ");
INSERT INTO sua_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","To e Yesus tkaursie ngok kmar he khavaeng ngar te, “E Nut thim dok orom ka msasaen kam nho mang o tgoluk tgus ruk mo mmie va kuon ma volkha kat orom kua serppak. ");
INSERT INTO sua_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","He ekam tok, mguak havaeng o mia tgus mang dok. Va mguak ngae ngok kim o vrong rhek tgus ngo valngneik ngo pneik kam patter mar kmikkiem dok. Ii, mguak patter mar tok, he kparrum mar orom E Titou kar Khal va E Nunu A Totur nga munik. ");
INSERT INTO sua_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Va mgua smia keknen ngang ngar kat kam vle pum o rhek tgus ruk ko her havaeng nguk orom mar. Ii, kua mien ngang nguk te, mguak kaeharom tok va ngora plong vle mo kmuk mekam mekam mo kolkhek tgus kam ngae kais mnam a kolkha to a kser kim.” ");
INSERT INTO sua_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Ngor kothoi mang a knovvur to mang e Yesus to E Nut Khal, Endo E Nut Thim Orom Ka Msasaen ko tkir kim e Seten. Ka ngothoi tkaelha tennik kmikkiem a propet to e Aisaia karo rhek ruk ngat ittiegom mar. Ko e Aisaia ta ktar kpavap orom E Nut karo mur rhek mruo ruk E Nut ta smia papsim Khal ormar. Ko E Nut thavaeng Khal te, “Vokom na, kua re kam meng kua propet langto, en kam ktar mang in, he en kam verang a ngaelaut ekam in. ");
INSERT INTO sua_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ii, nera ktar mang in he kpis ko ma kalputmok kmen a re to mang yin ngang o mia, he nang mar kmitgung ngaro kerkeknen. Ii, ko nera pis he ktetger o mia kam re la vlorum ngang ngar mang ngaro kerkeknen te, ‘Mguak hopeng kero kleimkor ekam Ngoldaip kam verang a ngaelaut ekam.’” ");
INSERT INTO sua_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","To mnam a kolkha langto, a mhel langto ka munik e Yoanes, ther mia pis ko ma kalputmok kmaottam E Nut karo rhek ruk endruk, mar kam pis lmien orom en mruo tok, kmikkiem gi enang ko e Aisaia ta ktar kpavap orom mar. Ii, endo e Yoanes, en nam kaegenkar ka yet to ngat eharom orom a ngaemslang to a kamel karo ngairis. Va nma kleng ka vgon orom a pus to ngat eharom orom a bulmakau ka ptaik. Va nam kaemem o ngorveit va o lup ruk ko ma kalputmok kat. Ii, e Yoanes ta ktar kpis enang tok, he kaen a re ngang o mia kam tetger mar te, “Mguak kaitgung mularo kerkeknen to kle kparrur orom E Nut ka munik, he nang muk kam mrua khenam muk mruo ma mmok tok te, mut mi kaitgung mularo kerkeknen, he nang E Nut kam lol patgiang ngaiting he kikiangae mang ngar.” E Yoanes nma tetger o mia kavurgem tok, ko mo kolkhek tgus ngama mopatap kmotoot pum mar ko mYerusalem va si mYudea karo mhetor tgus kat he kveet kpis ngok kim e Yoanes ko ma kalputmok kam vongnek kim. Ngma veet kam pis ko kim tok, to nam her kle kparrum mar orom E Nut ka munik kun mnam a ye to e Yodan ekam ko ngat mrua havae mang ngaro kerkeknen mruo ma mmok. ");
INSERT INTO sua_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Ii, e Yoanes nma havaeng o mia ko tok orom karo rhek akuruk kat te, “Dok, ko gia parrum muk orom a gi ye. Vanang Endo Nera Kaol knaek mang dok, en ner kle ktua parrum muk ko pum E Nut kalo keik orom E Nunu A Totur ka munik. Ner kaeharom tok, ko en ta laut mang dok hak. Ka serppak tho mi kut laut kir kim dok. Si dok kam kerrei he khong kalo nhar nginalo vanvan nginalo ngausie mkor, va dok klo vu eveep is e, en kam mrua ppir mang en mruo, nang dok kam hong ngin mkor kat e.” ");
INSERT INTO sua_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","To mnam a venloot to endo ko e Yoanes ta vle ko ma kalputmok vop, e Yesus tottek kun mnam ka rengmat ka pun to ko mNasaret, kun mnam a mhe to e Galili he kngae ngok ma kalputmok kat. To e Yoanes tparrum en kat orom E Nut ka munik kun mnam a ye to e Yodan. ");
INSERT INTO sua_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","A gi hi to ta parrum knop, e Yesus ther gia hop kun mnam a ye va ther gia vokong a volkha ko tmommenik. A volkha tmommenik, to E Nunu A Totur ta grung enang a giu he kpis kar kuon mang. ");
INSERT INTO sua_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","To E Nut ka ktui tkottek kuon ma volkha he kre te, “Ko hal to yin. Kom vu kaelongtok mang in, va ko sei kam higiang in.” ");
INSERT INTO sua_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","A gi hi to tre gia parrur knop, E Nunu A Totur ta tger E Yesus he ka ktong kam ngae ngok ma kalputmok ka mhe langto ko yok vat. ");
INSERT INTO sua_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","To mnam o kolkhek ruk alo mhelom alomin, en tuk ta vle ko ma kalputmok, ko tok ko o ngaemslang ruk ngta sop ngama vle mnam. He e Seten tkaenen mkor kmeharom o kerkeknen. Vanang E Nut karo engyel ngma turang kam klang mo ol. ");
INSERT INTO sua_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kam ngae, to kopekam ko ngat enpasiker E Yoanes kun pa hengor, e Yesus tkaeknik ngoguon mGalili to kaelha kam polger o rhek ruk mang en mruo, endruk E Nut telik maktiegom en kam polgerik tok. ");
INSERT INTO sua_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nma havaeng o mia te, “A venloot to mang E Nut ka tavgo kam komor o mia ther mi pis mo kmuk he. He ekam tok, mguak kaitgung mularo kerkeknen he kor mnam muk mang o rhek ruk koma polgerik ngang nguk.” ");
INSERT INTO sua_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tie ma kolkha langto, e Yesus ta ngae kaikkiem a ngaenker to e Galili ka ngaiting, va kvokom a mhel langto ka munik e Saimon kar knopia e Andru ko nginta hivuo kam ngam ngina klui kun ma ngaenker ko min ngina ngaeha to kmit singol. E Yesus tvokom min tok, ");
INSERT INTO sua_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","to kreng ngin te, “Me aol ikkiem dok, he ngor kle kaelkim mae kmit o mia ngok kim dok mekam mekam gi enang ko mem kait o singol.” ");
INSERT INTO sua_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","A gi hi to nginta ngan ko ta re tok, ngint her gi korim ngina ngaeha to kmit singol orom nginaro klui, nang her gi kaikkiem ngatngae. ");
INSERT INTO sua_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","E Yesus tvur kta ngae nong ke laut, to kta vokom e Sepedi klo hal ruk e Yems va e Yoanes ko nginta vatvat nginaro klui he kaelel mo kmar kuo ma langail. ");
INSERT INTO sua_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","A gi hi to ta vokom min ta vaeng ngin kat. Ta vaeng ngin, to ngint her gia parem ngin teit kar endruk ngam kaeha ngang ngar ko tok mnam a langail, nang her kat kaikkiem kat. ");
INSERT INTO sua_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kam ngae, to mnam a kolkha langto e Yesus mar ngata ngae he kpis kun ma rengmat to e Kaparnam he ka vle. A gi hi to a Sabat ta vuut, e Yesus ta vaik ogun mnam o Yuda nga rek to kam rere mnam he kaelha kam patter o mia. ");
INSERT INTO sua_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","O mia ngata vongnek kim to ngate sei kmit ngaongtok kim karo rhek ko en tle ktua patter mar orom kta serppak mruo to yok gi, nang nong orom ke serppak to mkor o pattermia ruk kmo pos e. ");
INSERT INTO sua_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ii, e Yesus ta rere kngae kun mnam o Yuda ngarta rek to kam rere mnam, va vgum a mhel langto a koot to nong a yar hak tim he envevem ko ta vaik. ");
INSERT INTO sua_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ta vle to a koot ta gervik klik kim e Yesus te, “Yin a mhel to endo kua mnor miik. Yin e Yesus to nkong mNasaret. Yindo E Nut Tmur Re Pum Yin. He mor o kool ngot lua mtom yin kam pis he ktoop kmor mo e. Ya pis moti kam rum kim mor, i nop gi?” ");
INSERT INTO sua_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","A koot tgervik kim tok, vanangko e Yesus ther gi reng a koot to endo te, “Ngiak tu ko he. Ottek kun mnam a mhel to.” E Yesus tgia havae tok, ");
INSERT INTO sua_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","to a koot tkootmerom a mhel to endo kngam, ta kongrek ogu mmie he kervuvui klik, to hera parem. ");
INSERT INTO sua_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","O mia tgus ngate gi mrua sor kmar to kaelha kmo mnganang ngar te, “Ngola, a mhel to tem anito e? Ko karo rhek ruk endri ngat ho mi ktua serppak hak! Ngola, nok a serppak tang ko a gunngar ta vor vat! Vokom na, ko si o kool, va ngama ngan vgum ko tgia kererik orom karo gi rhek ruk ngat vua serppak ko tgia reng ngar ormar.” ");
INSERT INTO sua_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Va vgum ka ngaeha to tok, a re to mang E Yesus thera ngae ngatngae he kvaas kim o mia kun mnam o rengmat tgus ruk kun mnam a mhe to e Galili. ");
INSERT INTO sua_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","To e Yesus kar e Yems va e Yoanes ngat kootpum mar ko mnam o Yuda ngarta rek to kam rere mnam to hop kngae lsir ngok mnam a rek to mkor e Saimon va e Andru. ");
INSERT INTO sua_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kun mnam a rek to endo, e Saimon ka snerip to a vlom ta yayor he ka kru kuo ma hep vgum a manakain ko ta ngae kun mnam. Ngata vaik, va e Yesus kalngunes ngat lo hus kam havaeng mang. ");
INSERT INTO sua_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","E Yesus ta ngnek, to ta ngae ngok kim he re gia kpom ka ktiek khover, va a manakain ther gi nop kun mnam hak. To a vlom to endo ther gia hop ku to hera krong o ol ngang ngar. ");
INSERT INTO sua_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","To mnam a kolkha to endo gi, ma rorongmia, ko a kolkha tvaik he, o mia kavurgem ruk ngta yayor kar endruk o kool ngta viging ngar, ngarlenar ngta plalam mar kam pis ngok kim e Yesus. ");
INSERT INTO sua_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Va o mia kavurgem ruk kun mnam a rengmat to endo ngata kaum ko va rek ka gudor to mkor e Saimon kre Andru. ");
INSERT INTO sua_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","To e Yesus tkaeharom o mia ngarlavurgem pum ngaro yor ngo mamten hak. Va ta kerer o kool kavurgem ruk ngat viging o mia kat. E Yesus tkaeharom tok, vanang ta kle khahagam o kool ruk tkererik, mar kam lua polger o rhek mang en ekam ko ngat mur mnor mang en te, en her Endo E Nut Thim Orom Ka Msasaen arhe. ");
INSERT INTO sua_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hop enang ngmo, tie mo kao, e Yesus thop halki he kparem a rek to endo, nang kngae ngok ma gi lootpgeik he kngarkie ko tok. ");
INSERT INTO sua_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","To e Saimon kar klenar ruk ngam kaikkiem ngat kaelha kriring. ");
INSERT INTO sua_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","To ngat re kpis mang, to ngat havaeng te, “O mia kavurgem ngata riring yin.” ");
INSERT INTO sua_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Va e Yesus tkoripang ngar te, “Mu so mor ngok mnam o rengmat ruk kan mmok, dok kam polger E Nut karo rhek ko tok mnam mar kat, ko E Nut tmi kut meng dok ngte mmie, dok kam mi kut kaeha tok arhe.” ");
INSERT INTO sua_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","To e Yesus tkaelha kvaik kottek kun mnam a mhe to e Galili karo rengmat ngakro maksien tgus he kaelha kam polger E Nut karo rhek ngang o Yuda kun mnam ngaro rektor ruk kam rere mnam mar. Va nma kerer o kool kat. ");
INSERT INTO sua_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","To mnam a kolkha langto, a mhel to tkol a yor to a lepra tpis ko kim e Yesus, ktubulkek ku penharom he kaurur kim te, “Enangthe ngiaka svil va yi kais kmeharom dok, he dok kam kta vle la mmok ko pum E Nut kalo keik kat.” ");
INSERT INTO sua_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","To e Yesus ta mrung to her gia tuom ka ktiek he gi kaehang va her gia reng te, “Mare, kua svil! Ila vok na ngae gia mmok.” ");
INSERT INTO sua_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A gi hi to tgia re tok, ka yor ther gi nop kuo mang ngatngae. ");
INSERT INTO sua_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","To e Yesus ta reng a mhel to endo lserppak te, “Ngiak or kam havaeng a mhel tang hak mang a ngaeha to ko eharom ngang in. Vanang ngiak kle va kngae ngok kim a pris tang, en kmehehang yin, en kam tting mang in te, lmien te, yi ho mi mmok ko pum E Nut kalo keik kat. Ngiak kaeharom tok, to kle kngae ngok mnam E Nut ka maksien he ka nngiar ngang E Nut, kmikkiem gi enang ko e Moses ka pos langto ta keknen tok mang a yor to endo ko yi her ottek mnam he. Ngiak kaeharom gi enang tok, nang o mia ngaro ngaongtok kmisis mang yin te, lmien te, yi ho mi mmok kat ko pum E Nut kalo keik.” E Yesus treng a mhel to tok, to le kmeng ta ngae orom karo rhek ruk endruk. ");
INSERT INTO sua_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tsi hagam a mhel to endo, vanangko a mhel to endo tlo kat kaikkiem ka re e. Ta kle va gia hahavae mang ngang o vrong mia tgus ruk ngat gi vrong papagis mang. Ii, tgia senker a re mang tok, kam ngae kais ko e Yesus te ho lo kat kais kam kta vaik mnam a rengmat tang ma gi mmok kat e, ko o mia kavurgem ngat kle ho gia motarhik mang. He ekam tok, e Yesus tgia vle ko ma gi kalputmok. Tsia vle ko tok, vanang o mia ngma mopatap kmotoot pum mar ko mnam a mmie karo ngaitngol tgus kam veet ngok kim mnam a mhe to endo ge. ");
INSERT INTO sua_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ko pekam ko o kolkhek akuruk ngat nop, e Yesus tkat kaeknik ngok mrek ko mKaparnam. O mia tgus ruk kun ma rengmat to endo ngata ngnek mang te, tpis he ka vle, ");
INSERT INTO sua_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","va ngta sovet kam gun mang, to a rek tngae ho mi kut ottep hak kais ko nong a vur ngaekam tang ko tgia vavle. Va si ko rkieng a gudor kat tngae ho mi kut ottep kat. To e Yesus ta patter mar kngae, va vgum ");
INSERT INTO sua_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","o mia ruk korlolo ko ngata kokol a mhel to ka vok tgus tyor he kngorom ngok kim e Yesus. ");
INSERT INTO sua_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ngata riring o longmok ekam kam kokol kam vaik orom kam pis ko kim e Yesus, vanangko ngat lo is e, ekam ko o mia vang ngata totok. To ngta grap orom kuo kim a rek he khalker a rek ka keik kmel a longmok ekam kuo malpgem e Yesus lsir. Ngat halker a rek knop, to ngta kol a hep to orom a yor he ngat konget a mhel to enda orom o usiel ruk ngta kleng ka hep orom mar. ");
INSERT INTO sua_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","E Yesus tvokom mar ko ngat vu kor mnam mar mang en enang tok, to kreng a mhel to endo te, “Kambis, dok mruo ko lol ilaro kerkeknen patgiang ngaiting he kikiangae mang ngar hak.” ");
INSERT INTO sua_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ta re tok, va akuruk mnam o pattermia kmo pos ngat korsang kun ma rek to endo kat he kvongnek kim e Yesus. Nangko kun mnam ngakro vurkul ngat si koror mnam mar mruo ekam he ka mngan pum te, ");
INSERT INTO sua_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Hai-e! Kman ko a mhel to enda ta re ti? Ta kerrereng E Nut ka munik tok arhe! Ko ta mrua tattap orom en mruo te, en E mi Nut msim orom karo rhek ruk tok. Ii, ko gi E Nut tuk to tis kam lol o mia ngaro kerkeknen patgiang ngaiting he kikiangae mang ngar, nang nong o gi vrong mia e, nop hak!” ");
INSERT INTO sua_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","E Yesus ther gia mnor mang ngar ngatngae ko ngata mngan pum en enang tok, to ta kle ka mnganang ngar te, “Mularo vurkul ngata horrotgi pum dok kman, he muta mngan pum kua serppak to kam lol o mia ngaro kerkeknen patgiang ngaiting he kikiangae mang ngar tok? ");
INSERT INTO sua_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ani ngaeha to ta koppet kam khenam ma mmok? A ngaeha to kam gia reng a mhel ta te, ‘Ko lol ilaro kerkeknen patgiang ngaiting,’ i o endo kam mi kaeharom a mhel ta, he en kam hop kol ka hep he kngae ko pum mularo kerok. ");
INSERT INTO sua_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vanangko tgia ya kat e, ko ngor mia khenam ma mmok ngang nguk te, E Nut tmi en ka serppak ngang A Mhel To Nkong Man Ma Volkha to dok, dok kam lol o mia ngaro kerkeknen patgiang ngaiting mo mmie he kikiangae mang ngar hak.” Thavaeng ngar tok, to her gia reng a mhel to ka vok tgus tyor te, ");
INSERT INTO sua_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Yu! Kua havaeng in te, hop, tolpum ila hep he kngae ngok mrek.” ");
INSERT INTO sua_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A gi hi to e Yesus tgia re tok, a mhel to endo ther gia hop ksir, to kokol ka hep to gi mrua ngongae kmottek ko pum o mia ngaro kerok ko arhe. He ekam tok, o mia ngat vokom ka ngaeha to tok to ngat gia nganga kim e Yesus he kguyaya pum E Nut kam mo havaeng ngar te, “A ngaeha to enda a serpgar ngom lua vokong tennik kam ngae kais mang tete. Enda ngota vokong tete yek.” ");
INSERT INTO sua_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","To e Yesus ta ngae ko vanam a ngaenker ka ngaiting va a mumu ta veet ngok kim to e Yesus tkaelha kam patter mar. ");
INSERT INTO sua_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tpatter mar knop, to hera parem a mhe to endo to kta ngae va kvokom a mhel langto ka munik e Livai, endo e Alpias khal ko tkorsang kun mnam o kermia ruk ngam kaelha klol o takis nga rek to kmelpas mnam. To e Yesus tpis ko kim to kreng te, “Ngiak kaikkiem dok!” To e Livai ther gia hop to kaikkiem. ");
INSERT INTO sua_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kam ngae, to mnam a kolkha langto e Livai tkaeharom a ngorsang langto ngang e Yesus ko mnam ka rek. Va o kermia ruk ngam kaelha klol o takis va o Yuda akuruk, endruk ngalmialaol ngma keyang ngar ko ngam lo sim kut kaikkiem o Yuda ngaro keknen ngat pis kaum kaemik ko kim e Yesus mar ekam ko kavurgem mnam mar ngat kaikkiem e Yesus kat. ");
INSERT INTO sua_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","To o pattermia kmo pos ruk o Parisiau ngata vokom e Yesus ko tkaum kaemik kar mar tok, to ngat kaelha kam kirhek pum e Yesus kam palsie kim kalngunes te, “Ngola, kman ko endo tkaemik ko kim o kermia ruk ngam kaelha klol o takis kar o Yuda akuruk, endruk ngolmialaol ngma keyang ngar ko ngam lo sim kut kaikkiem mor o Yuda nguaro keknen?” ");
INSERT INTO sua_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","E Yesus ta ngnek tok, to le ktootkinre kmoripang ngar te, “A mhel to nam kaeharom o mia nma vle mang endruk ngakro yor kmeharom mar, nang nam lua vle mang endruk ngat gia ya e. He gi enang tok kat, ko her pis mo mmie kam vle ngang endruk o mia ngma keyang ngar pum ngaro kerkeknen, he nang dok kam tger mar kmitgung ngar. Nang klua pis kam vle ngang endruk ngam mrua kansgum mar mruo kam pat mang ngar mruo te, ngaro keknen ngat ho mi kut sir hak ko pum E Nut kalo keik e.” ");
INSERT INTO sua_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mnam o kolkhek ruk endruk, e Yoanes kalngunes va o Parisiau ngma paal kmo ol ko pum E Nut kalo keik. To mnam a kolkha langto, o mia akuruk ngat pis ko kim e Yesus he ka mngan pum mang o Yuda ngaro keknen mruo ruk nkong ngar tennik te, “Ngua keknen to kam paal kmo ol ko pum E Nut kalo keik nkong ngolmialaol ruk tennik, nang nong lgunngae nkong ngar tete e. He ekam tok, kman ko e Yoanes kalngunes va a valngan to mkor o Parisiau ngam kaikkiem ngua keknen to nkong ngar tennik, endo kam paal kmo ol ko pum E Nut kalo keik he smia ngarkie ngang, vanang itlengunes ngam kle kaeharom a keknen to a gunngar ta yek, endo kam venu mang a ngaemik?” ");
INSERT INTO sua_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Va e Yesus ta tootkinre ngang ngar kam re lkoon mang ka yor mruo te, “Mnam a kolkha msim ko a mhel tkaenkim ktavlom, klenar ngat lo kais kam palam o ol e. Ho mi kut nop hak! Ko a mhel to endo ta vle ko kmar vop. ");
INSERT INTO sua_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Vanang o kolkhek ruk kam tivik mnam mar ngrok ge. Ngara pis koknaik ko ngaka vret a mhel to endo mkor kalngunes, yek endo yek, kalngunes ngaka mrung he ktivgim ko yek.” ");
INSERT INTO sua_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ta tootkinre tok knop, to kle kaenserpagam ka papat to endo mang karo keknen mruo kat te, “Mu vokom na, a mhel nam lua vatvat a yet ka kae to a gunngar engnang endo ka sgan e, matok naka plum he ka kae to a gunngar nera vui to kaursie to kait endo ka sgan to kle ho gi kael a pammok a ho lautar hak kir kim endo tesgun ko ta vatvat. ");
INSERT INTO sua_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ii, va ngam lo kaeharom a ye to a vaen, endo a gunngar kun mnam ka merrip ko ka sgan kat e, ko a merrip to ka sgan ta karrai he nera khir. Ngam lo kaeharom tok, ekam ko a vaen ka serppak, ko nak hop kun mnam ka merrip ner kaur mang ka merrip to endo ka sgan he khalker. To a vaen nera gussuk. He enang tok, a vaen kar ka merrip tgus nginera kernonho ka ngmeang tgus tok. Nove, o mia ngam lo kaeharom tok e. Ngam kle va kaeharom a vaen to a gunngar kun mnam ka merrip to a gunngar ko tgi kongeik.” ");
INSERT INTO sua_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tie ma Sabat langto, e Yesus kar kalngunes ngat kaikkiem a ngaelaut to ta kser a loot langto orom o sigla va kalngunes ngat kaelha kolonget o sigla he kaemik. ");
INSERT INTO sua_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ngat kaemik kngae, to o Parisiau akuruk ngat pis kpalsie kim e Yesus te, “Ai! Vokom ilengunes na, kman ko ngta kpoot mang ngua pos to kam paal ma Sabat?” ");
INSERT INTO sua_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Va e Yesus tkoripang ngar te, “Nok pathe mut lo him a ngothoi to mang e Devit kar klenar ko ngta vang, nang nong o ol ngang ngar kmemik vor? ");
INSERT INTO sua_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ko a ngothoi to endo ta havae mang e Devit, ko tennik mnam o kolkhek ruk o pris ruk laol ngaldaip to e Abiatar ta vle vop, e Devit tvaik ogun mnam E Nut ka maksien ka rek Ka Taban To A Totur he klol o bret ruk o Yuda ngam kaelik ko kim E Nut to kle kaisis kim kalngunes ormar va mar tgus ngat kaum kaemik mnam mar. Ngat si eharom tok, vanangko nguaro pos ngat havae te, gi o pris ruk laol tuk ngat gi kais kmemik mnam o bret ruk endruk, nang o gi vrong mia, nove! ");
INSERT INTO sua_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Enang tok, ta khenam te, E Nut tel a kolkha to a Sabat ngang o mia, mar kam nho mang, nang tlo el a Sabat kam nho mang o mia e. ");
INSERT INTO sua_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","He ekam tok, si a kolkha to a Sabat, va her A Mhel To Nkong Man Ma Volkha to arhe nma nho mang a kolkha to endo kat.” ");
INSERT INTO sua_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tie ma Sabat langto yok vat, e Yesus ta kta vaik kun mnam o Yuda ngarta rek langto kam rere mnam, nang a mhel langto ka ktiek tyor ta vle ko kat. ");
INSERT INTO sua_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Vanang o Parisiau ngat sim ktua keketar e Yesus ko ngta papat kam mon orom a kerkeknen tang enangthe naka kpoot mang a pos to ma Sabat kmeharom a mhel to endo. ");
INSERT INTO sua_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","To e Yesus ta reng a mhel to ka ktiek tyor te, “Hop, aol ngte na.” ");
INSERT INTO sua_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Thavae tok, to her kle ka mnganang o mia te, “Kmikkiem mor o Yuda nguaro pos, ani ngaeha to ta sir kmeharom ma Sabat, endo kmennegiang a mhel, en kam yor, i o endo kam turang en kmeharom kam ya?” Ta mnganang ngar tok, vanangko ngat lo koripang e. Ngat gia korsang kvongnek. ");
INSERT INTO sua_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","To kalo keik ngint kaem o mia tgus ko ka vrek te sei kam kiin hak ngang ngar. Ii, tkaesik tok va kle ka mrung ngar kat vgum ko ngaro papat ngat mi ktua kaendel pum E Nut karo rhek kngam mar ge. To thera havaeng a mhel to te, “Yin he, tuom ila ktiek na.” Va a mhel to endo ta tuom ka ktiek va te, ka ktiek ther gi ya hak ngatngae. ");
INSERT INTO sua_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","O Parisiau ngat vokom tok, to kottek kngae klapsa kam kaum kar a valngan to mkor e Herot kmelha kam papat mang a ngaelaut tang, mar kam lgem o rhek mang, he nang mar kmim kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","To e Yesus kar kalngunes ngat gi vur kaol kparem a rengmat to, he kngae ko vanam a ngaenker to e Galili ka vle. Va a mumu alautar orom o mia ruk ko mGalili ngat hohop he kveet kmikkiem kat. Va o mia kavurgem ngata ngnek mang ko nam kaeharom o mia vang ko tok, to ngat kotootpum mar ko mYerusalem km pis ngok kim e Yesus. Va si a mhe to e Yudea karo rengmat tgus, va o mia ngat kotootpum mar ko mnam mar kam pis gok kim. Va akuruk ngat kotootpum mar ko mIdumea va mnam o mhetor ruk mnam a ye to e Yodan ka ngaiting tigut va mnam o mhetor ruk ko rkieng alo mhe ruk e Taira va e Saidon kat. ");
INSERT INTO sua_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","To o yayor vang ruk mnam mar ngta mo pet kmursie ngok kim e Yesus kmehang ko en nam kaeharom o mia kavurgem pum ngaro yor. Ngama sovet kmotarhik ngok kim kais ko ngam re kam gia klung mnam hak. He ekam tok, e Yesus ta reng kalngunes kam kol a langail tang, nang en kam sir kun mnam, matok ngara karkar mang. ");
INSERT INTO sua_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Vanang o kool ruk ngat viging o mia, ngama vokom e Yesus to le gia tubulkek ku penharom he kvui te, “Her E Nut Khal to yin arhe.” ");
INSERT INTO sua_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Vanangko e Yesus tkaen a re lserppak ngang ngar kam hagam mar kam lua polger o rhek mang en enang tok. ");
INSERT INTO sua_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","To koknaik e Yesus ta grap ngoguon kim ke vul langto ka ngaiting. Ko tok ta vaeng o mia ruk en mruo tmur ktua svil mang ngar. To ngat ngan vgum he kaikkiem. ");
INSERT INTO sua_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","He enang tok, e Yesus ta plam a valngan to a gunngar ormar ruk loktiek hori orom alomin he kilegem mar te, “O Aposel.” Ta plam mar tok, mar kmikkiem va en kam meng ngar kam polger karo rhek ngang o mia mang E Nut. Va tkaenserpgam mar kmus kar o kool kam kerer mar orom ka serppak mruo. ");
INSERT INTO sua_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mar ruk endri: e Saimon, endo e Yesus ta kilegem te, e Pita, ");
INSERT INTO sua_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","e Sebedi klo hal ruk e Yems kar knopia e Yoanes, ennginduk e Yesus ta kilegem min tgus orom o Hibru nga re mruo te, e Boanerges. Vanang kam hortgem ngina munik to endo ka pun ta vle te, “Alo Krovger.” ");
INSERT INTO sua_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Va e Andru, e Pilip, e Bartalomius, e Matyu, e Tomas, e Yems to e Alpias khal, e Tadius, va e Saimon to ta vle mnam a valngan to mkor o Selot, endruk ngma mon mar kat te, o Kananea. ");
INSERT INTO sua_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Va e Yudas to nkong mIskariot kat, endo thortgi mang e Yesus kmel ko maktiegom o kermia. ");
INSERT INTO sua_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","To e Yesus ther kat kaeknik ngok mrek va o mia vang ngat sovet kam gun kam mopatap ngok kim, mar kam ngae kais ko en ta svil kmemik va tlo ktuis kat e. ");
INSERT INTO sua_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","To e Yesus ka valngan msim ngata ngnek mang tok, to kle khavae mang te, “Ka mrang tpis kim.” Ngat havae tok, to ngta hop he kngae kam kapom, mar kam nho mang. ");
INSERT INTO sua_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ngata ngae vop, va o pattermia kmo pos ruk ngat otootpum mar kuon mYerusalem ngata vle ko tok mGalili kat. Ngat re te, “O-o, o kool ngalaip to e Beelsebul ka serppak ta ti arhe a mhel to enda nma kemmeng kam paeim o mia he kerer karo valngneik mruo ruk o kool orom ti.” ");
INSERT INTO sua_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ngat re tok, to e Yesus ta vaeng ngar kmaol ngok kim to le ktootkinre ngang ngar mang en mruo te, “Nngia orom e Seten, ko en tis kam kerer karo valngneik mruo kat gi? O-o, nove ko ");
INSERT INTO sua_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","25","enangthe a rengmat i o a valngan tang ko a serpgar npa mommenik he mur kaus kar mar mruo va kmopet kmar mruo, va a rengmat i o valngan to endo ka serppak tlo kais kam vle lhok e! ");
INSERT INTO sua_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","E Seten ta vle gi enang tok kat, ko enangthe e Seten npa hop he kaus kar karo valngneik mruo ruk o kool he kmommen mar va ka serppak tlo kais kam vle lhok kat e. Nove, ka serppak ketasuo kam nop he. ");
INSERT INTO sua_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Vanang dok, kua vle enang ti te, enangthe a mhel to a serpgar nap kaelel mo kim mang he ktoot mang ka rek va kakro tgoluk, va nong a mhel tang tkais kam pis kam vretik mkor e. Vanang enangthe kaela ngang ko yok ko ka serppak tho laut kir kim endo a serpgar nap pis kaussiem a mhel to a serpgar, to endo yek, kaela to endo arhe tmi kut kais hak kam veret kakro tgoluk mkor. ");
INSERT INTO sua_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ii, he ekam tok, kua havaeng nguk te, E Nut ner mia lol o mia ngaro kerkeknen tgus patgiang ngaiting he kikiangae mang ngar hak. Va si ngaro kerkeknen ruk kam kerrereng E Nut kat va nera lol patgiang ngaiting he kikiangae mang ngar. ");
INSERT INTO sua_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Vanangko ner ho lo kais hak kam lol ngaro kerkeknen ruk kam kerrereng E Nunu A Totur patgiang ngaiting he kikiangae mang ngar hak e. Ko E Nut ner mia mon mar orom ngaro kerkeknen ruk endruk, he ngaro kerkeknen nga vnek nera vle ngnik ngnik kuo mang ngar hak.” ");
INSERT INTO sua_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","E Yesus tkoripang ngar tok, ekam ko ngata kerrereng en te, “Nma kemmeng a koot langto ka serppak kam paeim o mia orom.” ");
INSERT INTO sua_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","To e Yesus knan kar kaornopeik ngat kaol te, kam pis mang. Ngat pis ksir ku mnok to kmeng o mia kam vaik kun ma rek kam vaeng. To langto mnam a mumu to ngat korosang kairkleim e Yesus kun mnam a rek to endo, thavaeng te, “Vae, inan kar ingornopeik va ingoretmeik ngta sir ku mnok he ka mngan mang in.” ");
INSERT INTO sua_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Va e Yesus tkoripang te, “Erie mar ruk koornek va koornopeik ormar e?” ");
INSERT INTO sua_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ta mngan tok, to kalo keik ngint kaem o mia ruk ngat korosang kairkleim ko tok, to ta kle krere va ka kvam mar te, “Mu vokom endri na, ko her mar ri arhe koornek va koornopeik ha. ");
INSERT INTO sua_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ii, ngta vle tok, ko erieto nam kaikkiem E Titou ka svil, her en lsir arhe nguaka kvam te, konopia va koetem va konan orom.” ");
INSERT INTO sua_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","To e Yesus ta kta ngae kat he kaelha kam patter o mia ko vanam a ngaenker ka ngaiting. Va a mumu alautar ta sovet kam mopet kam gun kairkleim kais ko ta ring ngaekam ekam mnam a langail langto kuo kia ngaenker. To tkar kun mnam he korsang ko tok, nang ka mnang o mia tgus ko ngata sisir ko vanam a ngaenker ogun paat. ");
INSERT INTO sua_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ko tok ta patter mar mang o tgoluk kavurgem ko tgia koka ngang ngar. Ta koka ngang ngar orom karo rhek ruk endri te, ");
INSERT INTO sua_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mu smia ngnek na! Mnam a kolkha langto a mhel tkaelha kngamngam a ho karo khek kun mnam ka loot. ");
INSERT INTO sua_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ta ngamngam mar kngae, va akuruk ngata vuvuut ko ekam a ngaelaut. To o iningol ruk kuon mail ngat pis kokorong ngar he krum kim mar hak. ");
INSERT INTO sua_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Va akuruk ngta vuvuut kun pgegom o krek ko a vur mmie ge. To ngta mamarer kam pagis ekam ko a mmie ta rara. ");
INSERT INTO sua_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ngata pagis ka vle gi nong ke laut e, ekam ko ngata viging a kolkha ka koppetmok to a koppetmok to endo tgi ktim mar to ngat her gi vuvui he kmamarer kam vuvuut ekam ko ngaro kmen ngata puung kim o krek. ");
INSERT INTO sua_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Va akuruk ngta vuvuut kun pgegom o ngaergot ruk o kosmur. To o kosmur ngta lalaut, hop kim mar kvuvuem mar to her gia komor kmar. He enang tok, a ho karo khek ruk endruk ngat lo kaehi e. ");
INSERT INTO sua_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Vanang akuruk ngta vuvuut ko mnam a mmie to a yar, to kpupus he klalaut to kaehi. Akuruk mnam mar ngakro maineik ruk ngam kaehi ngta ngamngam va ngta ngamngam ge, va akuruk vat mnam mar ngakro maineik ruk ngam kaehi ngam vrua ngamngam kais tok va akuruk vat mnam mar ngakro maineik ruk ngam kaehi ngam vrua ngamngam kat ge.” ");
INSERT INTO sua_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","E Yesus ta koka tok knop, to kre te, “Muk ruk muta vongnek kim dok, mgua sim kael rela ekam kuaro rhek ri kam sim kut kaikkiem mar.” ");
INSERT INTO sua_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","To koknaik, ko e Yesus te ka vle en tuk, o aposel va kalngunes ruk ngata ngan karo rhek ko ta koka ormar, ngata mnganang e Yesus kam halger o rhek ruk mang te, kman ko nma koka ngang o mia. ");
INSERT INTO sua_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Va ta reng ngar te, “Tennik kam ngae kais mang tete, E Nut nama tuvgom karo papat ruk mang ka tavgo ko kim o mia. Vanangko tete, ta polger o rhek mang ngang nguk kam khenam ka tavgo to endo ma mmok, ko ther mi pis ko kim mularo kerok, he ta komor muk he. Va her muk ruk arhe mut mia vokom kam mnor mang. Vanang o mia ruk E Nut ka tavgo tlo komor mar vop, her endruk kom gia koka ngang ngar arhe. ");
INSERT INTO sua_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kom gia koka ngang ngar enang tok, he nang a propet langto karo rhek kmel mit ko ta ktar kpavap mang o mia ruk endruk kam havae mang ngar te, ‘Ngam gia vokom E Nut ka tavgo orom o gi pkor, he kaennegiang. Va ngam sia ngnek ka ngnek mang kat, vanang kle gi kael rela petgim ge. Vanangko enangthe ngap lo kael rela petgim tok, va ngap kaitgung ngaro kerkeknen, va E Nut napa lol patgiang ngaiting he kikiangae mang ngar hak.’” ");
INSERT INTO sua_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","To e Yesus tle kreng kalngunes te, “Po, te mut lua mmok mang a koka to enda kat gi? Enangthe mgua lua mmok mang a koka ta, va mguera mmok mang o koka akuruk nngia e? ");
INSERT INTO sua_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A mhel to ta ngamngam a ho karo khek ta vle enang a mhel to nma polger E Nut karo rhek mang ka tavgo ngang o mia. ");
INSERT INTO sua_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Va o mia ruk ngma ngan o rhek ruk mang E Nut ka tavgo, vanang lo sim ktua ngangam kmar mang ngar, ngta vle enang a ho karo khek ruk ngta vuvuut ko ekam a ngaelaut. Ko ngma ngan o rhek ruk mang E Nut ka tavgo, vanang e Seten nam her gi kat pis ge, gi veveret o rhek ruk E Nut ta ktar kngam mar ngkun mnam ngaro vurkul petgim mar kam rum kim mar hak. ");
INSERT INTO sua_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Va o mia ruk ngma ngan E Nut karo rhek he kmarer kam kpom mar kun mnam ngaro vurkul he ksirei mang ngar va kngatkal mang ngar ngatngae, endri ngta vle enang a ho karo khek ruk ngta vuut kun pgegom o gi krek. ");
INSERT INTO sua_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ngta vle tok, ekam ko E Nut karo rhek ngat gia puung ngaro vurkul, ko ngam gi vur matnge vgum o vnek nong ke laut he kor mnam mar mang E Nut ge, orom ngaro gi pkor. Vanangko mnam o kolkhek ruk o mia ri ngta viging a koppetmok vgum E Nut karo rhek ruk endruk ko ngarlenar ngata kol a regesal mang ngar, a koppetmok to endo nam gi ktim mar he khos kim ngaro papat ruk kmor mnam mar mang E Nut to o papat ruk endruk ngam her gi kat nop hak kun mnam mar. ");
INSERT INTO sua_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Vanang o mia akuruk yok ngama ngan E Nut karo rhek. Endri ngta vle enang a ho karo khek ruk ngta vuut kun pgegom o ngaergot ruk o kosmur vat. Ngta vle tok, ekam ko ngma ngan E Nut karo rhek, vanang o papat ruk mang nga ngorsang to mo mmie ngaro vnek va o papat ruk kam lol o vu krek ngma vaik kun mnam ngaro vurkul kat he ka kpom mar. To o papat ri ngma hop kim E Nut karo rhek kun mnam ngaro vurkul he kvuvuem mar to her gi komor mar, he E Nut karo rhek ruk endruk ngam lo kaehi kun mnam mar e. ");
INSERT INTO sua_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Vanang o mia ruk ngma ngan E Nut karo rhek he sim ngangam kmar ka kpom mar lserppak kun mnam ngaro vurkul ngta vle enang a ho karo khek ruk ngta vuut ko mnam a mmie to a yar. Ngta vle tok, ekam ko E Nut karo rhek tgus ngam mi kut kael mit kun mnam mar. He akuruk mnam mar ngaro maineik ruk ngam kaehi ngta ngamngam va ngta ngamngam ge. Va akuruk vat mnam mar ngakro maineik ruk ngam kaehi ngam vrua ngamngam kais tok. Va akuruk vat mnam mar ngakro maineik ruk ngam kaehi ngam vrua ngamngam kat ge.” ");
INSERT INTO sua_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","To e Yesus ta kta koka kat mang o papat ruk mkor E Nut ka tavgo to o mia ngma vaik ku meorom te, “Mum lua giem a paei he tuvgom ku meorom a plo e, i o ku meorom a hep kat e. Nove! Mum kle va kaendavloum a rek ko pgeik msim he kgiem, en kam mmok kim o mia ngola? ");
INSERT INTO sua_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","He kmikkiem enang tok, o papat ruk mang E Nut ka tavgo ko ngta tvok kim o mia tennik, E Nut ta kaendavloum a mmie enang tok kat he ka khenam mar ma mmok tete kat he. Ii, tesgun E Nut ta tokim o papat ruk endruk mang ka tavgo kim o mia, vanang tete ta kle khalgerik he kaelik ma mmok he.” ");
INSERT INTO sua_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","E Yesus ta koka tok knop to le kre te, “Muk ruk muta vongnek kim dok, mgua sim kael rela ekam kuaro rhek ri kam sim kut kaikkiem mar.” ");
INSERT INTO sua_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tre tok, to ta trong orom karo rhek ruk endri te, “Mgua sim kor mnam muk mang kuaro rhek ruk muta ngannik ko E Nut ner kaekon kmen a mmok ngang nguk kmis mang mularo svil ruk muk mruo mut kor mnam muk mang ngar kais tok. Va ner kle ho gia kaen a mmok ngang nguk malpgem a mmok to endo gi. ");
INSERT INTO sua_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mare! E Nut ner kaekon kmen a mmok ngang nguk tok, ekam ko endo ta kpom E Nut karo rhek he ngat kael mit kun mnam, E Nut ner kle ho gia sovet kam kat kaen karo rhek akuruk mnam kat. Vanang endo tlo smia kpom E Nut ke re ke vur vgon ngang ko ke sie, he en kmel mit kun mnam, va si ke re ke vur vgon ko ta kpom kun mnam, va E Nut ner kle ho gia vret mkor kpetgim hak.” ");
INSERT INTO sua_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","To e Yesus ta kta koka kat te, “A mhel langto tngamngam a ho karo khek kun mnam ka loot knop to kngae. ");
INSERT INTO sua_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nam konit mo segain va khop mo ruteik tgus nang a ho karo khek ngat mur kokohir he kpupus ngpang ngar mruo ko he. Va a mhel to enda tlua paptang ngar ko ngat kokohir he kpupus kngae nngia enang tok e. ");
INSERT INTO sua_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tlua paptang tok, ko a mmie mruo nam mur kaenserpgam a ho karo khek he ngta ktar kam papaam ngo kerok. To koknaik a loot ther kael hingrip to ho koknaik hak a loot tho gia tettek he. ");
INSERT INTO sua_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A loot na tettek knop, to a mmie kteit na mamarer kngae kam lluol mnam ko o tgoluk ngat hera volvol he. Ii, E Nut ka tavgo to nma komor o mia ta vle her gi enang tok kat.” ");
INSERT INTO sua_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","To e Yesus tkat koka kat te, “E Nut ka tavgo ta vle nngia? Ani koka to tkais he dok kam keknen orom mang E Nut ka tavgo? ");
INSERT INTO sua_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","E Nut ka tavgo ta vle enang ko a mhel ta kol a ho to a mastat ka khek ko ke ho mi laut hak mang o tgoluk tgus ngo khek ruk ngma kap kun mo luteik. ");
INSERT INTO sua_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ta pus he klaut kngae kael en a ho orom karo khator ruk laol he khop kir kim klenar tgus kun mnam a loot kais mang o iningol ruk kuo kia gan kmaol kpis kngam ngainirik ko vgum ka ngoumi.” ");
INSERT INTO sua_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","E Yesus tpatter mar kun ma langail tok, kmikkiem ngaro papat ko ngate ktua kais tok. Nam lua rere lsir ngang ngar kmel karo rhek ngaro pneik ma mmok kam patter mar tok e. Nove, nam kle gia polger E Nut karo rhek orom o gi koka kavurgem tuk enang endruk. Vanang koknaik ko gi kalngunes tuk, nam kle khalger ngaro pneik tgus ma mmok ngang ngar. ");
INSERT INTO sua_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","36","Tie mavlemas mnam a kolkha to endo, e Yesus tkorsang kun ma langail vop he kreng kalngunes te, “Mu somor he, ngor poe kenker a ngaenker ta ogut pa ngaiting tigut vat.” To ngata parem a mumu ko pa ngaenker ogun paat he kar mnam a langail to e Yesus tkorsang kun mnam he ngta poe orom. Va o mia akuruk ngata poe ka knaek orom ngartaro laktok kat kmikkiem mar. ");
INSERT INTO sua_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ngta poe kngae, va vgum a kalivurvur ko tpis he kaenpgam a ngaenker. Va o vlung ngta sovet kam klung engnang a langail he karir nkun mnam va ta re kam vallum hak. ");
INSERT INTO sua_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nangko e Yesus tonit kuo ma klui kun ma langail ka plangail, nang lua paptang. To kalngunes ngata votgem he ka mnganang te, “Pattermia, yi lua papat mang ngor gi, ko ngot re kam vvuo?” ");
INSERT INTO sua_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","To e Yesus thop to her gia re lserppak kam kser a ngausgi to khagam o vlung kam re te, “Rurruom he vur vle!” Tgia re tok, to a kalivurvur ther mi nop hak va o vlung ngat ngae her gi rurruom ngatngae. ");
INSERT INTO sua_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","41","Kalngunes ngata vokom tok, to ngaro nunu ngat ho mi kut parem ngaro mit hak kim, he ngta mo mnganang ngar mruo te, “Hai-e! Ani mhel langta ti e, ko si a ngausgi va a ngaenker va nginta ngan vgum kat?” To e Yesus thera kner mar te, “Kman ko muta gor? Mutlo kor mnam muk mang dok vop?” ");
INSERT INTO sua_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","To e Yesus mar ngata poe to kngae kpis ko mnam a mhe to mkor lGerasa ogut pa ngaenker ka ngaiting tigut. ");
INSERT INTO sua_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Va e Yesus ta prik ngok paat, va vgum a mhel to o kool ruk nong lyar ngtim he kviging ko tpis mang ko tottek kun mnam o nhotor ruk mkor o yoror. ");
INSERT INTO sua_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A mhel to endo nam her gi konit ko mnam o nhotor ruk mkor o yoror ko tok, ko nong a mhel tang ka serppak tkat kais mang kam kta kaussiem kat e. Va si kmussiem orom o sen va o sen ngat lo is mang kat e. ");
INSERT INTO sua_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ko tesgun o mia ngam kaussiem kalo ktiek va kalo nhar orom o sen va en nam gi kat kaur mang o sen kokohirik gi he kngorpok kat. He enang tok, nong a mhel tang ka serppak tkais kam hagam e. ");
INSERT INTO sua_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mo segain va mo kolkhek tgus nma punpa ko mnam o nhotor ruk mkor o yoror va ko po turvek he mur kaerergat orom o mandrap ngo kaenatok. ");
INSERT INTO sua_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tvokom e Yesus ko ta sir vur hagenmok mang to her gia sap pis ksir ko kim to ktubulkek ku penharom. ");
INSERT INTO sua_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","9","To e Yesus ta ktar ka mnganang te, “Ila munik erieto?” Va a koot langto kun mnam tkoripang te, “Ngua munik ‘e Ngaomevek’ ko mor o kool ruk a ngaomevek to orom mor ngot viging a mhel to enda.” E Yesus ta ngnek tok, to thera reng a koot to endo te, “Mu ottek kun mnam a mhel to enda.” Ngta ngnek ko e Yesus ta reng ngar tok, to a koot ta rere klik hak he kreng e Yesus te, “Yesus, Yin E Nut To Tho Mi Laut Hak Khal to yin. He mor o kool ngot lua mtom yin kam pis ktoop kmor mo e. Ngot kaurur kmin te, yin kmel ila tnangal ngang ngor ko pum E Nut kalo keik te, yin kmor kmen a kapnes ngang ngor he kering ngor.” ");
INSERT INTO sua_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","13","Vanang ko tok rkieng ngar, o morek nga murgun ngta hohek kuon kia hogun ko rkieng a veik ka ngaiting. Va a ngaenker ta vle ku pa veik ka pun. To o kool tgus ngat le kaum kaurur kim e Yesus te, “Ngior kam kerer mor ngok po turvek petgim a mmie ka mhe to enda e, vanang ngiak kle kmeng ngor kam viging o morek ruk endruk ho.” Ngata re tok, to e Yesus ta ngatkal ormar. To o kool ngat her kottek mnam a mhel to endo, nang kle kviging o morek. Ngata viging ngar, va vgum o morek tgus ruk ngat is mang te, 2,000 ko ngat her gia kolaspa kam sap ngpirik ekam a veik kam ngae kpis kvuvvuo kun mnam a ngaenker kyayor tgus ngmeang. ");
INSERT INTO sua_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","To o toot kmo morek ngta ngorpok ngok mnam a rengmat ka pun va o rengmat tgus ruk ko rkieng a mhe to endo, he kvaik kottek mnam mar kam havae kngae mang he. To o mia ngta veet kam vokong anito tpis. ");
INSERT INTO sua_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ngta pis ko kim e Yesus va vokom a mhel to a ngaomevek to orom o kool ngat viging tesgun ko tsim kut egen he korsang ko tmi ya he, va tsim kta papat kat. Ngat vokom ka mnor mang, to ngate ksei kam gor hak. ");
INSERT INTO sua_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","To o toot kmo morek, endruk ngat mi vokom ko e Yesus ta kerer o kool kun mnam a mhel to endo, ngat kaelha kam havaeng o mia mang e Yesus ko teharom tok va si mang o morek kat ko ngat yayor tgus tok. ");
INSERT INTO sua_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","To o mia ngat kaelha kmurur kim e Yesus, en kmehenok petgim mar ko mnam ngarta mmie ka mhe to endo. ");
INSERT INTO sua_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","To e Yesus ta ngnek mkor mar va re kar kun ma langail te, en kam hera ngae, va a mhel to endo e Yesus teharom pum o kool, tkaurur kim te, en kmikkiem, ");
INSERT INTO sua_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","vanang e Yesus tlua svil e. Thagam te, “Ngiak kaeknik ngok mnam ila rengmat he khavaeng ilenar mang E Nut ko ta mrung yin he ka srim yin pum o kool ruk endruk.” ");
INSERT INTO sua_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","To a mhel to endo ta vaik kottek kun mnam o rengmat ruk ngma mon mar te, O Rengmat Ruk Loktiek he kaelha khavae mang o reha laol tgus ruk e Yesus teharom mar ngang. Va o mia ruk ngta ngan karo rhek ngat sei kam sor kim mar. ");
INSERT INTO sua_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","To e Yesus mar ngata kta poe kmeknik ngkun kut pa ngaenker ka ngaiting tigut kat, to a mumu alautar ngata kta kaum ko kim kairkleim ko tok pa ngaenker ogun paat kat. ");
INSERT INTO sua_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ko tok, a taip langto ka munik e Yairus ta vle kat. En nma nho mang o Yuda ngarta rek langto kam rere mnam. Ta vokong e Yesus to kaol ngok kim ktubulkek ku penharom ");
INSERT INTO sua_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","he kaurur kim te, “O-kola-o, ko kvek te sei kam yayor he kre kam yor he. He aol ikkiem dok ngogu mrek he ehang, en kam kta ya he ka vle kat.” ");
INSERT INTO sua_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","To e Yesus ta ngan vgum to her kaikkiem. Va a mumu alautar ngata sovet kam puung mang he kaikkiem kat. ");
INSERT INTO sua_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Vanang a vlom to orom ka yor to a vaeip ta vle ko tok kun mnam a mumu to kat. Ta vle orom ka yor to endo kais mang o pnes loktiek hori orom alomin. ");
INSERT INTO sua_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ta vle vgum o mia kavurgem ko ngat si kaegom kmeharom en pum ka yor to endo, vanang ngat lo is e. Va en tkoham karo krek tgus mang ngar va te lua ya e. Nove, ka yor ta kle va ho kserppak mang mo kolkhek tgus. ");
INSERT INTO sua_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","To a vlom to endo tre gia ngnek mang e Yesus to hera pis gia vaik mnam a mumu ekam ko ta pat kun mnam en mruo te, “Enangthe ngua re gi vur kaehang si ka yet ke gi gu mko gi, va ngor gia ya ge!” To ther gia knaek ekam e Yesus kpis to tkaehang. ");
INSERT INTO sua_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","A gi hi to tkaehang ka yet, va te, ka yor ther gi nop ngatngae! Va ta mrua ngan ka vok kat ko ther ho ya hak, ko ka yor ther gi nop ngatngae. ");
INSERT INTO sua_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Va a gi hi to a vlom ta tkaehang e Yesus karo it, e Yesus ta ngan ka vok kat ko ka serppak to nam kaeharom o mia orom tparem. Ta ngan tok, to hera hortgi ngok kim a mumu he ka mnganang ngar te, “Ngola, erieto tehang kuaro it?” ");
INSERT INTO sua_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","To kalngunes ngat koripang te, “Ya vokom ko la mhel vang ta te vua mopet ngte kim in, va ya mngan kam mngan gi te, erieto tehang in?” ");
INSERT INTO sua_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Va tar e Yesus ta petela vop kam ring endo tehang, ");
INSERT INTO sua_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","to a vlom to endo ther mrua ngan ka vok mruo enang tok, to kle kaelha kam gor va kakhi kim e Yesus. To ther kaol kpis ktubulkek ku penharom to khavaeng mang en mruo lmien te, en lsir arhe endo tehang tok. ");
INSERT INTO sua_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","To e Yesus thera reng te, “Kolkheng, yi her ya he, ekam ko ya kor mnam yin mang dok. He ekam tok, ngiak ngae he ka vle orom a vrek longeik ko ila vok ther ho ya he.” ");
INSERT INTO sua_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","E Yesus ta rere vop va o mia akuruk ngat ottek ko mnam a taip to e Yairus ka rek he kpis ko kim e Yairus. Ngat pis her gia havaeng e Yairus te, “O-o, Yairus, ikvek tyor he, ngior kam kat kaelreha ngang a pattermia ta kat e, ngia her gi kor ko he.” ");
INSERT INTO sua_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Vanangko e Yesus ther kaennegiang ngaro rhek ruk endruk, nang le ktua reng e Yairus ge te, “Ngiak or kam gor e, ngia kle va gi kut kor mnam yin mang dok ge.” ");
INSERT INTO sua_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","To e Yesus tkaikkiem e Yairus he lo kta tting orom a mhel tang kat, en kmikkiem klapsa kngae e, gi e Pita va e Yems kar knopia e Yoanes. ");
INSERT INTO sua_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ngat ngae to kpis ko mnam e Yairus ka rek, va e Yesus ta vokom a mumu ko ngat kael a halum ko ngat kaee kuon mail he mur kaim mar mruo mang a kalyie to endo. ");
INSERT INTO sua_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ta pis kvaik to kreng ngar te, “Kman ko mut ngae vu kaee enang tok? Ko a kalyie to enda tlua vle enang a mi yor e. Tgia vle enang a kalyie to tgi onit ko ner kta hop kat.” ");
INSERT INTO sua_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ta re tok, va o mia ngat le gia kol a klel orom. To e Yesus thavaeng o mia kmottek ngogu mnok, nang hera vaeng a vlom sie kteit kar knan va kalngunes mruo ruk korlotge, to ngat hera vavaik ngok mnam a taban to ngat ngangater a yor he ta kru mnam. ");
INSERT INTO sua_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tpis to hera kpom a yor ka ktiek he khover va kreng orom ka re mruo te, “Talita koum.” A re ta ka pun ta vle te, “Ke vlom sie, kua reng in te, hop he.” ");
INSERT INTO sua_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ta re tok, to a vlom sie to endo ther gia hop ngatngae to kngongae. To mar ruk ngta vle ko tok ngta vokom a ngaeha to endo, to her ngae gia nganga kim. (Ko a vlom sie to enda karo pnes ngat is te, aktiek hori orom alomin.) ");
INSERT INTO sua_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Vanangko e Yesus tle ktua sopong ngar lserppak hak kam hagam mar kam lua havaeng a mhel tang mang ka ngaeha to endo. To thera reng ngar kam klang a vlom to endo mlol, en kmemik. ");
INSERT INTO sua_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","E Yesus teharom tok, to hera parem a mhe to endo he kngae ngok mnam ka rengmat ka pun mruo. Va kalngunes ngat kaikkiem kat. ");
INSERT INTO sua_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","To a Sabat ta pis to e Yesus ther kaelha kam patter o mia kun mnam o Yuda ngarta rek to kam rere mnam. Va o mia ruk ngata vongnek kim ngate sei kmit ngaongtok kim karo rhek hak he le kaelha kam mo mnganang ngar mruo pum te, “Ngola, a mhel to enda tem anito ko tkol karo vu papat ruk laol nngia? He nam kaeharom o reha ri lvu laol nngia? ");
INSERT INTO sua_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Te gi endo nma ngamrektor ta ngola? Va te, e Maria khal va kaornopeik ruk e Yems, e Yosep, e Yudas va e Saimon kat ngola? Va kaorotmeik gi endri mo kmor kat ngola?” Ngta mamngan pum e Yesus tok, to ngat kaelha kmelat. ");
INSERT INTO sua_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","To e Yesus tgia reng ngar te, “O mia ngma totu pum a propet to a hirtek, vanang endo a pgirmia ngam lua totu pum e, ko a propet to a pgirmia nma rere kar karo valngneik mruo va karo usiel mruo ruk kun mnam karo rengmat ngo pneik mruo va ka valngan mruo ngam lua ngan vgum e.” ");
INSERT INTO sua_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Va e Yesus te sei kam sor kmar ekam ko ngat lo kor mnam mar mang en tok. He ekam tok, tho lo is hak kmeharom o reha ruk lserpgue ko mnam ka rengmat ka pun to endo e. Vanangko ther gi kaehang o mia lgititge kmeharom mar pum ngaro yayor. He ekam tok, e Yesus tngae parem mar ko tok to kle kaelha kvaik kottek kun mnam o rengmat ngaro maksien he kaelha kpatter o mia. ");
INSERT INTO sua_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","To mnam a kolkha langto e Yesus ta kaum karo aposel ruk loktiek hori orom alomin ko kim he kaen a serppak mnam mar, mar kam kerer o kool ko ta re kmelha kam memeng ngar alomin alomin kmeha. ");
INSERT INTO sua_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","To ta reng ngar te, “Mguak or kmeha kim a tomhel tang hak ko mguak ngae. Vanang mang a gi kop va o nharok ngaro vanvan tuk, mut kais kmeha kmar. Vanang mang o ol va o ngaelpas va o krek ruk kmelik kun mnam mularo psang ruk muma kleng mularo vgondik orom mar va o varkie akor, mguak or kmeha kim mar kat e.” ");
INSERT INTO sua_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","To ther kta reng ngar kat te, “Mguak ngae, va mguak pis mnam a ni rengmat to he kvaik mnam a rek tang, ko a rek kteit nak ngatkal ekmuk. He mguaka vle ko kim endo arhe kais ko mguak parem a rengmat to endo. Nang mguak or kam prik ka prik mnam o gi vrong rektor akuruk e. ");
INSERT INTO sua_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Vanang enangthe o mia nga lua ngatkal ekam muk kam vle ko kmar, i o enangthe nga kael rela kim muk, va mguak kaureik he kngetmmie ko vgum ngaro rektor kam rpem a mmie ka ngaor to ta vat engnang mularo nharok kam khenam ngang ngar te, mut hera tu kam pis ko kmar orom E Nut karo rhek, he E Nut ner kael a mgu ngang ngar koknaik. Mguak kaeharom tok, to klapsam nga rengmat to endo ge.” ");
INSERT INTO sua_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","E Yesus ta rere tok knop, to kalngunes ngat her kaelha kam parahi kam hahavaeng o mia te, ngak kaitgung ngaro kerkeknen he kor mnam mar mang E Nut. ");
INSERT INTO sua_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Va o mia kavurgem ruk ngat yayor va kalngunes ngat koror mar orom a ku kat he ngata kta yaya kat. Va ngata kerer o kool kavurgem kun mnam mar kat. ");
INSERT INTO sua_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","To lRom ngalaip kalkayie langto ka munik e Herot, endo ta mrua kansgum en mruo kam mrua mon en mruo te, en a Taven, ta ngnek mang e Yesus karo reha ruk nam kaeharom mar ko maktiegom karo aposel ruk tok, ko e Yesus ka munik tngae ho klaut hak vgum mar. Ko o mia akuruk ngat kaelha kam havae ma mmok mang e Yesus te, “En e Yoanes to nama parrum o mia, he en nam kaeharom o reha ruk endri lserpgue vgum ka serppak to tkol ko thop petgim ka nnak.” ");
INSERT INTO sua_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Gi akuruk ngate ktua havae mang te, “En e Elaisa.” Nang akuruk yok vat ngta havae mang te, “En a propet enang tang mnam endruk tennik.” ");
INSERT INTO sua_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Vanang e Herot ta ngan ko o mia ngta mon E Yesus te, en e Yoanes to nama parrum o mia, to en kat ther le mrua havae mang e Yesus tok kat kam mrua havae te, “E Yoanes to ko en a volou mang tesgun, o mia kam ptum ka ngoro kngam a yoror, nok her en ta kat arhe, ko nok tkat hop petgim ka nnak vor!” ");
INSERT INTO sua_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","E Herot tpat tok, ko tiok, her en mruo to ten a volou mang e Yoanes, o mia kam kapom he kaussiem to le kaenpasiker kun ma hengor. Ii, e Herot ten a volou mang e Yoanes tok, ko tiok e Yoanes nama kser e Herot mang ktavlom to e Herodias. Ko tesgun e Herodias ta vle te, e Herot knopia to e Pilip ktavlom, nang e Herot ta vret e Herodias mkor knopia to kle klei orom, en kam vle te, ktavlom mruo. ");
INSERT INTO sua_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","He ekam tok, e Yoanes nma palsie kim e Herot mang ka kerkeknen to endo tok kam havaeng te, “Nguaro pos ngat lua ngatkal mang in kam lei orom inan tok e.” ");
INSERT INTO sua_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","He ekam tok, e Herodias nma vrek kiin ngang e Yoanes he ksei kam svil kmim kngam a yoror. Ii, nma svil kmim e Yoanes kngam a yoror, vanangko tlo is, ");
INSERT INTO sua_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ekam ko katngokol e Herot nma ruokar kim e Yoanes he mrua koon mang ko ta mnor mang e Yoanes karo keknen ko e Yoanes nam sim kut kaikkiem E Nut karo rhek va ko nma totu pum E Nut kat. Vanang mnam o kolkhek ruk e Yoanes nma vle kun pa hengor, e Yoanes nma patter e Herot, va e Herot ka vrek nam sia kervavle pum karo rhek, vanangko nma sirei kam ngan mar ge. ");
INSERT INTO sua_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","E Herot nma koon mang kam ngae, to mnam a kolkha langto e Herodias ka papat tpis kim ko e Herot ta kunngir kim kalmialaol mruo va kalngunes ruk ngma kar va tomten ngalmialaol va lGalili ngalmialaol kat. Ta kunngir kim mar kam pat mang a kolkha to knan tkol mnam. Ko mnam a kolkha to endo ");
INSERT INTO sua_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","e Herot mar ngat korosang kaemik to e Herodias ka kvek ta vaik he kaerep ko pum ngaro kerok. Tkaerep knop, to e Herot kar karo mia ngat ngae sei kam sirei mang hak. Ngta sirei mang to a taven to e Herot treng a vlom sie to endo te, “Ani tomhel lang ko ngiaka mnganang dok mang, va ngor gi kaen ngang in.” ");
INSERT INTO sua_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ta havae tok, to kael ka tnangal ngang lsir he kmon a tomhel langto kmenserpgam ka tnangal to endo ko treng te, “Ani tomhel lang ko ngia mnganang dok mang, va ngor gi kaen ngang in. Si o tgoluk ruk ngota nho mang ngar kais mang nga mhe va dok ngora tting mang ila mngan mang ngar ge.” ");
INSERT INTO sua_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A vlom sie ta ngnek tok, to le kparem e Herot he kpis ngok kim knan to ka mnganang te, “Anito nguaka mnganang mang?” To endo yek, knan ta havaeng te, “E Yoanes to nma parrum o mia, kua svil mar kam ptum ka ngoro.” ");
INSERT INTO sua_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","To a vlom sie ta parem knan he kmarer kmeknik ngok kim e Herot to kreng te, “ E Yoanes to nma parrum o mia, kua svil yin kam ptum ka ngoro gi tete ta he kael ka lpek kun mnam a plo kmen ngang dok.” ");
INSERT INTO sua_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A taven to endo ta ngan ka mngan tok, to te sei kam kosnok kun mnam en mruo. Vanangko ekam ko ther mon a tomhel langto kmenserpagam ka tnangal ko pum klenar ngaro kerok, tlo kais hak kam kser a vlom sie to endo ka mngan e. ");
INSERT INTO sua_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","To ther kaengu ngang langto mnam endruk ngma kar va tomten ngatngae en kam ngae ka ptum e Yoanes ka ngoro to kaeknik orom. To thera ngae kun pa hengor, ta ptum e Yoanes ka ngoro, kael kun mnam a plo ");
INSERT INTO sua_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","to kaeknik orom. Tkaeknik orom to kpis her kaen a plo to orom e Yoanes ka lpek ngang a vlom sie to endo to en thera lapsam ngang knan. Ii, e Yoanes ka yor thera vle tok arhe. ");
INSERT INTO sua_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","To e Yoanes kalngunes ngat kol a re mang ko tyor tok, to ngat kle kpis kol ka mnes to hera ngae ka me kael kun mnam a kre ka nho. ");
INSERT INTO sua_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","To o aposel ngata rum ngaro reha tgus to kaekeknik kpis ko kim e Yesus he khavaeng mang ngaro reha tgus ruk ngat eharom mar va ngaro rhek tgus ruk ngata patter o mia ormar kat. ");
INSERT INTO sua_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nang o mumu ngma mopatap ngok kim e Yesus kam ngae kais ko e Yesus mar ngat si kaemik va ngat lo ktis kat e. He ekam tok, e Yesus treng kalngunes te, “So mor ngor ngae ngok ma lootpgeik na, mor kam vrua vle mor tuk kam kta kol a serppak na.” ");
INSERT INTO sua_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","To ngat kar mnam a langail to hera poe kam ngae parem a mhe to endo kam ngae ngok ma lootpgeik langto, mar kam vle mar tuk ko tok. ");
INSERT INTO sua_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Vanangko o mia kavurgem ngta vokom mar he hera mnor mang ngar to hera veet parem ngaro rengmat kaikkiem ko paat he ktar pis mnam a mhe to e Yesus mar ngat re kam ngae mnam. ");
INSERT INTO sua_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","To e Yesus mar ngta pis kvaar he kottek paat, va vgum a mumu alautar ko ta vle kpaneng. Tvokom mar to ta mrung ngar ko ngta vle enang o sipsip ruk nop ngar teit ngang ngar kam toot mang ngar. To tkaelha kam patter mar mang o papat kavurgem. ");
INSERT INTO sua_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kam ngae, to a kolkha ta vaik. To e Yesus kalngunes ngat pis ngok kim he kreng te, “Ta re kam slok he, he te va mor ri ngot gia vle mo ma lootpgeik kat. ");
INSERT INTO sua_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","He ekam tok, ngiak meng a mumu ta he nak ngae ngok mnam o rengmat laol va o maksien ruk ko kan mmok, mar kmenkim o ol ngang ngar.” ");
INSERT INTO sua_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ngata re tok, va e Yesus tkoripang ngar te, “Muk mruo mgua mrua klang ngar mo ol ha, mar kmemik.” Va kalngunes ngta mnganang te, “Ya re mor kam ngae he krum a kre alautar hak kmenkim o ol he ka klang ngar ngar kmemik? Tang mnam mor nak kaeha kais mo kenho ruk aktiek hori orom korlotge kmit o krek ruk ngat is kmenkim o ol ngang ngar.” ");
INSERT INTO sua_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","To e Yesus ta mnganang ngar te, “Yu! Mularo bret ruk o gutnei ngat is te, aner? Mu ngae he him mar na.” Ngata him mar knop to ngat gia re te, “Mor nguaro bret aktiek va alo slang agi lomin e.” ");
INSERT INTO sua_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","To e Yesus ta reng a mumu kmorsang ku ma ngaergot to tgi gnua rer, he kaum o valngneik. ");
INSERT INTO sua_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","A mumu ta ngan vgum to akuruk ngat korosang mnam o valngneik ruk orom o mia ruk ngat is mang o mhelom aktiek mnam langto langto. Va akuruk ngat korosang mnam o valngneik ruk orom o mia ruk ngat is mang alo mhelom alomin hori orom loktiek mnam langto langto kat. ");
INSERT INTO sua_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ngat korosang enang tok knop, to e Yesus ta lol o bret ruk aktiek va alo slang he ka nho ngpalmai to kanprim E Nut mang ngar to kle kommenik to kaenik ngang kalngunes mar kmisis kim o mia. Va ta kol alo slang kat he kaisis kim mar tgus enang tok kat. ");
INSERT INTO sua_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","To o mia tgus ngat kaemik ngae vi tgus knop, to ");
INSERT INTO sua_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","e Yesus kalngunes ngata kaum o bret ngo mhetor ruk e Yesus tommenik va o slang akuruk ko a mumu ta penkim mar. Ngta kaklang o ngauret ruk loktiek hori orom alomin ormar va ngat ngae kottep. ");
INSERT INTO sua_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Vanang kam him gi lurokol ruk mnam endruk tgus ko ngat emik ko tok, mar ngat kais mang te, 5,000. ");
INSERT INTO sua_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A gi hi to ngata gun kaemik knop, e Yesus thera tger kalngunes kam kar mnam a langail he ngta ktar kam ngae ngogut pa ngaenker ka ngaiting tigut ko mBetsaida, nang en ta kle ka vle ko tok kmel a mumu ko va ngaelaut. ");
INSERT INTO sua_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tkael mar knop, to kle ka grap ngok kia vul langto ka ngaiting kam ngarkie. ");
INSERT INTO sua_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ta vle, to a kolkha ta vaik mang, vanang a langail ther ngae he ngam ogu ma mlin he, nang en ta vle en tuk ko paat kuon kia vul. ");
INSERT INTO sua_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ta nho va kvokom mar ko ngat kaekon kim a ngausgi he sia khanang ngar kam poe. Tvokom mar ko ngta vle enang tok kais mo kao. To e Yesus thera ngae kuon kia ngaenker ka las ngok kmar. Ta re kmotter mar, ");
INSERT INTO sua_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","vanangko kalngunes ngta vokom ko ta ngae kuon kia ngaenker ka las enang tok, va ngaro nunu ngat ho mi kut parem ngaro mit hak he ngta vuvui kim ko ngta pat re te, a ngomiem to en. A gi hi to ngta vuvui, e Yesus ta hagam mar kam reng ngar te, “Mgua serppak, ko dok ta he. Mu or kam kta gor kat e.” ");
INSERT INTO sua_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Thavae tok, to ta grap ngkun ma langail kar mar, va vgum a ngausgi ko ther gia rurruom. Ngata vokom tok, to ngae gia nganga kim ");
INSERT INTO sua_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ko ngat lo smia mmok mang ka ngaeha ka pun, endo orom o bret, ko ngaro papat ngat gi kaendel pum en kngam ge. ");
INSERT INTO sua_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kam ngae, to ngta poe kpis he kvaar ogut pa ngaenker ka ngaiting tigut ko mGenesaret. ");
INSERT INTO sua_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","To ngat re kottek paat to o mia ngat re gia vokong e Yesus ka mnor, ");
INSERT INTO sua_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","to ngta sap kparhi ogut oguon kun mnam a mhe to endo he kaelha kam plalam o yor ruk ngta kru kun mnam ngaro hevor he kael mar ko kim e Yesus kun mnam o ni vrong maksien ruk o mia ngata havae te, e Yesus ta vle kun mnam mar. ");
INSERT INTO sua_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Va mnam kero maksien, i o o rengmat ruk lkaprik va si o mhetor tgus ruk e Yesus nma ngae mnam mar, va o mia ngam kael endruk ngta yayor ko ma gi mhe to ngam kaenkim o ol mnam he kaurur kim en kam gia mnang o yor, he mar kam gi vur kaehang si ka yet ke gi gu mko ge. He enang tok, endruk tgus ruk ngat gi vur kaehang, ngaro yor ngata nanop kuo mang ngar. ");
INSERT INTO sua_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","O Parisiau va si o Yuda tgus ngam kaikkiem ngalmialaol ruk tennik ngaro vrong keknen kmoror o tgoluk vop. Ii, ngma vle ti te, enangthe o Yuda ngap kotootpum mar kun mnam a mumu to orom o vrong rhek va nga lo kais kmemik kais ko ngaka ktar kngae na kam mrua parrum o mgun ruk ngta ru pum mar kun mnam a mumu to endo. Va ngam kaikkiem o keknen akuruk kat, endruk kmelel o lheik va o plo va o tonggai va o hevor kat kam pet o mgun kuo mang ngar kat. Va si nga keknen to kam sim kaelel singni va ngam sim kaikkiem endo kat. He nga lo kais hak kmemik enangthe nga lua ktar sim kaelel singni na. Ngaka ktar sim kaelel singni na, to endo yek, ngat kais kmemik. To mnam a kolkha langto o Parisiau akuruk kar o pattermia ngat kotootpum mar mYerusalem he kngae ngogun kim e Yesus mar. Ngata vokom ko e Yesus kalngunes akuruk ngat gi kaemik, nang lo sim kaikkiem o Yuda nga keknen to kam sim kaelel singni ktar mang ngar kmemik he ngta pat re te, e Yesus kalngunes ngat mur kael mar mruo enang tok orom o mgur ko pum E Nut kalo keik. ");
INSERT INTO sua_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","To o Parisiau kar o pattermia ruk endruk ngata vokom tok, to ka mnganang e Yesus te, “Mor ri ngom sim kut kaikkiem ngolmialaol nga keknen to kam smia parrur kmelel singni ktar mang ngor kmemik. Vanang nngia orom itlengunes ko mar ngam lo smia parrur kmelel singni ktar mang ngar kmemik tok e?” ");
INSERT INTO sua_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Va e Yesus tkoripang ngar te, “Muk mularo naprai alomin hak! A propet to e Aisaia te smia mien mang nguk ko ka re to ngat ittiegom mang nguk ther mi kaottam kpis lmien ormuk ko tennik ta ktar kpavap mang nguk te, ‘O mia ruk endri ngam gia gupiris kam totu pum dok orom ngaro gi pkor, vanang ngam lua vokom dok orom ngaro keknen e. ");
INSERT INTO sua_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ngam gi mrua ngampaei pum mar mruo kam totu pum dok tok, ko ngma patter o mia orom ngartaro keknen mruo ruk ngat kottek mkor ngalmialaol mruo ko enangthe mar kuaro rhek mruo ruk ngat ottek mkor dok.’ ");
INSERT INTO sua_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ii, mum gia vle tok arhe ko mut her korim E Nut karo pos, nang kle klie pmar orom mutaro mur keknen mruo ruk ngat kottek mkor mutlmialaol mruo ko muma kpom mar lserppak tete.” ");
INSERT INTO sua_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","To thera reng ngar kat te, “Mum mrua kanprim muk mruo ko mut her keyang E Nut karo mur pos ruk tok he khos kim mar kam kokomor kim mar, he nang muk kam kle va kaikkiem mutaro keknen mruo ruk ngat kottek mkor mutlmialaol mruo. ");
INSERT INTO sua_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ii, mut korim E Nut kalo pos ruk e Moses tel min tennik ko langto thavae te, ‘Mguak totu pum muortek va muornek’ va langto thavae te, ‘Endo nak sisieng tang mnam min, va o mia ngak lalaem kngam a yoror.’ ");
INSERT INTO sua_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ii, mut her hos kim alo pos ruk ennginduk vgum ko muma tting mang o mia kam sisieng ngaornek va ngaortek orom muta mur keknen mruo, endo ko mum kle va khavaeng o mia orom te, ‘A nngiar to a mhel ta ktar mon E Nut mang, he kre kam nngiar ngang E Nut orom, a mhel to endo tho lo mi kut kais hak kam kle ka vrengem kam totu pum knan i o kteit orom ko ta svil kam smia tar min orom.’ Ii, muma tok orom alo pos ruk ennginduk kam mon a nngiar to endo te, ‘A Koban.’ (A re to te, a Koban ka pun ta vle te, ‘E Nut Nang.’) ");
INSERT INTO sua_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ii, muma hagam a mhel to enda kam sim kut kaikkiem alo pos ruk tok ko muma tok orom min orom muta mur keknen mruo, en kam lo smia tar kteit kar knan enang tok arhe. ");
INSERT INTO sua_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","He gi ekam tok, muma hohos kim E Nut kalo pos ruk tok he ktatar mang ngin orom muta mur keknen mruo to endo. He o mia akuruk ngma kolkol ekam mula keknen mruo to endo enang tok kat arhe. Va mum ngae khos kim E Nut karo rhek kavurgem kam kokomor kim mar enang tok vat.” ");
INSERT INTO sua_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","E Yesus ta reng ngar tok, to kta vaeng a mumu ngok kim kat he kreng ngar te, “Muk tgus mgua smia ngangam kim muk kam mmok mang kuaro rhek na, ");
INSERT INTO sua_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ekam ko o mia akuruk, ngma pat te, ngara ru pum o mgun ruk kuo mang o ol, ko ngam kaemik he kaengnam mar ogun mnam mar, he o ol ngara kla orom mar he ngar lo kta vle la mmok ko pum E Nut kalo keik vgum tok. Vanang nop hak! Ko o tgoluk ruk ngat lua mmok ko pum E Nut kalo keik, her mar ruk ngam kle kottek kun mnam a mhel ka vrek, he her o tgoluk ruk kat arhe ngama kla orom o mia he ngam lo kta vle la mmok ko pum E Nut kalo keik ormar tok arhe.” ");
INSERT INTO sua_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“Muk ruk muta vongnek kim dok, mgua sim kael rela ekam kuaro rhek ri kam sim kut kaikkiem mar.” ");
INSERT INTO sua_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","To e Yesus ta parem a mumu ku mnok, nang kvaik ogun ma rek. To kalngunes ngata mnganang mang ka ngothoi to endo mang o ol. ");
INSERT INTO sua_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","To e Yesus ta reng ngar te, “Puoo, te muk kat, va mularo lpetuk ngta tok kat? Mut lua mmok gi te, o ol ruk a mhel nma ngam mar ogun vgum, ngat lo kais hak kam kla orom a mhel to endo he en kam vle lua mmok ko pum E Nut kalo keik? ");
INSERT INTO sua_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ii, ngat lo is tok, ekam ko ngam lua kolongret ogun mnam ka ngaung e. Nove, ngam kle gia kolongret ngogun mnam ka vrek to kle gi kottek kat ko a mhel nam gia ppie ormar.” (He ekam e Yesus karo rhek ruk endruk tok, e Yesus ta tting mang o gi vrong ol tgus te, ngata mmok kmemik.) ");
INSERT INTO sua_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","To e Yesus ta kle kre kngae kat te, “Vanang o kerkeknen ruk ngam kottek kun mnam a mhel ka ngaung, her endruk arhe ngama kla orom a mhel to endo he nam lua vle la mmok ko pum E Nut kalo keik vgum mar enang tok. ");
INSERT INTO sua_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ii, ta vle tok arhe, ko o kerkeknen ruk kun mnam a mhel ka ngaung, her endruk arhe ngam kottek ko a mhel nam kaeharom mar. Ii, endruk endri te: kmel o papat kmeharom o kerkeknen, kam vret o mia, kmuruvik, kam pormia, kam kpoot mang a lei, ");
INSERT INTO sua_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kam ring mnam mang a vlom, kmeharom o keknen ruk kam kering o mia, kam kauyang o mia, kam kpiem E Nut karo rhek hak, kam ring mnam mang o mia ngaro tgoluk, kam rere pum o mia he kering ngaro mnok, va a mhel kam mrua hover en mruo, va kam lo kor mnam en mang E Nut. ");
INSERT INTO sua_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ii, o kerkeknen ri arhe kua momonik, ngama kla orom a mhel he nam lua vle la mmok ko pum E Nut kalo keik vgum mar enang tok, ekam ko ngma vle kun mnam a mhel ka ngaung he kottek ko nam kaeharom mar tok arhe.” ");
INSERT INTO sua_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","E Yesus treng ngar tok, to kngae parem a mhe to endo, nang kle kngae ko mnam a mhe langto yok ko rkieng alo rengmat ruk e Taira va e Saidon. To ta vaik kun ma rek he lua svil mang o mia kam mnor mang ko ta vle ko e. Vanangko tlo is kam tvok ");
INSERT INTO sua_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","ko a vlom langto ko a koot tviging ka kvek to ke sie tre ka ngnek mang e Yesus ko te gnua pis ko tok. To ther gia ngae ngatngae kpis ktubulkek ku penharom he kaurur kim, en kam kerer a koot to kun mnam ka kvek to endo. Vanang a vlom to endo, en a vrong rhek langto mnam o Ponisia, endruk ko mnam a mmie ka mhe to mSiria, nang nong a Yuda to en e. ");
INSERT INTO sua_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tkaurur kim tok, vanangko e Yesus thavaeng te, “Tlo vua ya dok kam lol o ngnes ruk lIsrael ngaro oreek he kngam mar ogu kam klang o vela ruk o vrong rhek ormar e. O ngnes ngak kaemik kvi na.” ");
INSERT INTO sua_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Va a vlom tkat kaurur kim gi te, “Kolaip, kua mnor, vanangko si o vela ruk ngma vle ku meorom o psen kat va ngam kaem o ngnes ngaro ol ngaro gi ngommes ruk ngma vuvuut kuo va psen.” ");
INSERT INTO sua_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tre tok, va e Yesus tkoripang te, “Ekam ko ye sim koripang tok, a koot to kun mnam ikvek tngorpok he kparem he. He ekam tok, ngiak ngae ogu mrek.” ");
INSERT INTO sua_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A vlom tngan tok, to her gia ngae ngok mrek he kpis mang ka kvek ko tkonit ko ma hep ko a koot ther ngorpok parem. ");
INSERT INTO sua_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","To e Yesus thera ngae kparem a mhe to mTaira, nang hera ngae kaelha kvaik kottek kun mnam o maksien ruk mnam a rengmat to e Saidon to le kngae kvaik kottek kun mnam o rengmat akuruk kat, endruk ngma mon mar te, O Rengmat Ruk Loktiek. Tngongae tok, to hera pis ogu pa ngaenker to ko mGalili. ");
INSERT INTO sua_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ta vle ko tok, to o mia akuruk ngta pis orom a ngokol langto kalo ngaela nginta tok va ka gu nma vavnek kam rere. To ngat kaurur kim e Yesus kmehang kmeharom en kam ya. ");
INSERT INTO sua_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","To e Yesus ta ktong a ngokol to endo petgim a mumu kngorom en tuk. Min tuk nginta vle, to e Yesus ta guspa ko mang ka ktiek mruo he kvorang a mhel ka naprai orom karo gusgus to kle kael kalo smeik mruo kat ogun mnam a mhel ta kalo ngaela. Tkaeharom tok knop, to kle ");
INSERT INTO sua_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ka nho oguon ma volkha to khong ka ngaung he kre lHibru te, “Epeta.” Va kam hortgem a re to enda ka pun ta vle te, “Pa he.” ");
INSERT INTO sua_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","E Yesus ther gia re tok, to a ngokol kalo ngaela ngint her gi pa he, va ka naprai ther gi kta mrer, he nam lo kta sisie pum o rhek kat e. ");
INSERT INTO sua_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","E Yesus tkaeharom tok, to krere lserppak ngang o mia kam hagam mar kam lua havaeng a mhel tang mang ka ngaeha to endo. Nma plong hagam mar tok, vanangko e Yesus karo rhek ruk endruk ngat kle ho gi kaenen mkor mar kam vua hahavaeng o mia kavurgem mang. ");
INSERT INTO sua_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Va o mia ngate sei kmit ngaongtok kim e Yesus to ngta mo reng ngar mruo te, “Te sim kaeharom o tgoluk tgus va si o relatok kar o guvat, va en tis kat kmeharom mar, he ngata kta ngnek va kta rere kat.” ");
INSERT INTO sua_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mnam o kolkhek ruk endruk a mumu alautar langto vat ta kta sovet ko kim e Yesus va nop o ol, mar kmemik e. To e Yesus ta vaeng kalngunes ngok kim to khavaeng ngar te, ");
INSERT INTO sua_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ko sei kam mrung a mumu to enda, ko ngata vle mo kmok kais kmo kolkhek ruk korlotge he, he ngat lo vur kaemik vop ");
INSERT INTO sua_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","he ngta vang he. Vanangko enangthe kopa meng ngar kmekeknik ngogu mrek enang tok, nok pathe ngar kle kyor ktal ko ekam a ngaelaut vor. Ko akuruk mnam mar ngat otootpum mar malhagenmok he kaol ngte.” ");
INSERT INTO sua_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Thavae tok, to kalngunes ngat kle ka mnganang te, “Ngruak ring o bret mrie moti ma gi kalputmok he nang ngor kam klang ngar kmemik?” ");
INSERT INTO sua_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Va e Yesus ta kle ka mnganang ngar te, “Nang mularo bret ruk o gutnei aner?” Va ngat koripang te, “Aktiek hori orom alomin.” ");
INSERT INTO sua_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ngat havaeng tok, to e Yesus ta reng a mumu kmorosang ku mmie. Ngat korosang knop, to ta lol o bret to kanprim E Nut mang ngar to tkommenik he kaenik ngang kalngunes, mar kam le kaisis kim a mumu ormar. To kalngunes ngat lol mkor to kle kaisis kim a mumu ormar. ");
INSERT INTO sua_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Va kekro singol ruk ngat lo khor ngta kpom mar kat. To e Yesus ta kanprim E Nut mang ngar kat to ta kta reng kalngunes kam lol mkor he kaisis kim o mia kat. ");
INSERT INTO sua_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","To mar tgus ngtemik kngae vi tgus knop, to e Yesus kalngunes ngata kaum o ol ngo mhetor ruk e Yesus tommenik ko a mumu ta penkim mar, to ngat hera klang o ngauret ruk aktiek hori orom alomin ormar va ngat ngae ottep. ");
INSERT INTO sua_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Vanang gi lurokol ruk mnam endruk tgus ngat emik ko tok, kam him gi mar tuk, mar ngat kais mang te, 4,000. ");
INSERT INTO sua_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ngat kaklang o ngauret knop, to e Yesus tkaekon a mumu ngok mnam ngaro rengmat, nang en ta kle kar mnam a langail kar kalngunes he kngae mnam a mmie ka mhe to e Dalmanuta. ");
INSERT INTO sua_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tie ma kolkha langto ko e Yesus ta vle ko mDalmanuta, o Parisiau akuruk ngta veet ngok kim he kpis kmus kar kam pe gia kendom ngang te, en kam khenam a ngaelmir tang ngang ngar ma mmok, he nang mar kam mia mmok mang en te, lmien te, en arhe Endo E Nut Thim Orom Ka Msasaen. ");
INSERT INTO sua_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ngat pis ko kim va e Yesus tho mi kut kaissuo kim mar to kerer ka lpek he kre te, “Muk o mia ruk nga main to tete mum sim ktua riring kriring ge mang a ngaelmir tang mo krok. Vanangko kua mien ngang nguk te, ngor ho lua khenam tang hak ngang nguk e.” ");
INSERT INTO sua_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ta re tok, to hera parem mar he kta kar mnam ka langail to ngat hera poe kngae ogut pa ngaenker ka ngaiting tigut. ");
INSERT INTO sua_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ngata pis kvaar to kngae, vanangko kalngunes ngat kikiangae kam lol o ol. A gi bret to a gutnar atgiang tuk e, ngat el kun ma langail. ");
INSERT INTO sua_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","To e Yesus ta koka kmel a pagor ngang ngar te, “Mgua sim ktua papat he kngangreal ngang nguk hak mang e Herot kar o Parisiau ngaro papat ruk ngma kerruru ormar ko ngma ker patter o mia ormar. Ko ngaro papat ruk endruk ngta vle enang ke ngaor to a yis ko nma himhim orom a bret kam ho khibul hak.” ");
INSERT INTO sua_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","To kalngunes ngat kaelha kam mo mnganang ngar mruo he kre te, “Ngola, ta re ti, ekam ko ngot kikiangae kam lol o ol akor vor?” ");
INSERT INTO sua_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","To e Yesus ta tar ko ngta re tok, to ta kle ka psom mar te, “Kman ko muta vle krere mang te, nop o ol ngang nguk? Mut lo smia ngangam kim muk he kol dok vop, ko mularo papat ngama vle ho mi ktua kaendel pum dok kngam dok ge. ");
INSERT INTO sua_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ii, muma vle tok ko muma ngan kuaro rhek, vanangko mum lo smia ngangam kim muk ekam mar e. Va mum sia vokom dok, vanangko mum lua vokom dok kam mia mnor dok kat e. Mu havaeng dok na, mut kais kam pat mang ");
INSERT INTO sua_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","o bret o gutnei ruk aktiek, endruk ko ommenik he ka klang lurokol ruk ngat kais te, 5,000 ormar? Ko kopekam ko ngat emik kvi, muta klang o ngauret aner orom o bret ngo mhetor ruk ngat penkim mar?” Va kalngunes ngat koripang te, “Ngota klang o ngauret ruk loktiek hori orom alomin.” ");
INSERT INTO sua_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","To ta kta mnganang ngar kat te, “Va mang o bret o gutnei ruk aktiek hori orom alomin, endruk ko ommenik he ka klang lurokol ruk ngat kais te, 4,000 ormar, mut kais kam pat mang ngar kat ko kopekam ko ngat emik kvi kat ko muta klang o ngauret aner orom o bret ngo mhetor ruk ngata penkim mar?” Va kalngunes ngat koripang kat te, “Aktiek hori orom alomin.” ");
INSERT INTO sua_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ngta re tok, to e Yesus ta le ka mnganang ngar te, “Mare, va mut lua mmok vop mang dok ge?” ");
INSERT INTO sua_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","To ngata ngae to kpis ko mBetsaida. To o mia akuruk ngat kaol he kpis ko kim e Yesus orom a mhel to ta vipsik. Ngata pis he kaurur kim, en kmehang kmeharom en kam ya. ");
INSERT INTO sua_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","To e Yesus ta kpom a mhel ka ktiek to hera ktong kngorom petgim a rengmat to endo. To ta guspa mang a mhel ta kalo keik to hera vat kalo ktiek kuo mang ngin. Teharom tok knop, to ta mnganang a mhel to endo te, “Yi vrua vokom a tomhel tang he?” ");
INSERT INTO sua_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","To a mhel ta ta malegem kalo keik he kreng te, “Kua vokom o mia ko ngata nho enang o hi ruk ngata ngongae.” ");
INSERT INTO sua_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","To e Yesus ta kta vat kalo ktiek kuo mang a mhel kalo keik kat. Tvat knop, to a mhel ta kaenker klik kam nho, to tle smia nho he kvokong o tgoluk tgus ko ngat vua mmok hak. ");
INSERT INTO sua_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","E Yesus tkaeharom tok, to kmeng a mhel to endo kam ngae klapsa ngok mrek orom karo rhek te, “Ngiak or kam marer kmeknik kun ma rengmat tma kuon e.” ");
INSERT INTO sua_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","To e Yesus ta ngae kar kalngunes kam ngae mnam o maksien ruk ko rkieng a rengmat to e Sisiria Pilipai. Ngta ngae ekam a ngaelaut, to e Yesus ta mnganang kalngunes te, “O mia ngma mngan pmok he khavae te, dok erie?” ");
INSERT INTO sua_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Va ngat kaekon ngang te, “Akuruk ngma havae te, yin e Yoanes to nama parrum o mia. Akuruk ngam ktua mon yin te, yin e Elaisia, nang akuruk yok ngma mon yin te, yin a propet langto enang ngar ruk tennik.” ");
INSERT INTO sua_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","To e Yesus ta kle ka mnganang ngar te, “Vanang muk ri, mum ktua pat te, dok erie?” Va e Pita tkoripang te, “He her yinda arhe, Endo E Nut Thim Orom Ka Msasaen.” ");
INSERT INTO sua_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","E Yesus ta ngan tok, to hera reng kalngunes lserppak kam lua polger a re to endo mang en tok ngang a mhel tang vop. ");
INSERT INTO sua_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","E Pita thavae tok, to endo yek, e Yesus tkaelha kam patter kalngunes mang en mruo te, “A Mhel To Nkong Man Ma Volkha nera lol o vnek kavurgem vgum o pris ruk laol va o pattermia kmo pos va o Yuda ngalmialaol ko ngara rere kim he kaen a volou mang, mar kmim kngam a yoror. Va naka kru mnam ka nnak kais mo kolkhek ruk korlotge, yek E Nut na kle khover petgim ka nnak kat.” ");
INSERT INTO sua_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","E Yesus tlua tuvgom karo rhek ruk mang ka yor e. Tmia havaeng ngar orom a re ka mit ma mmok tok. Ta re tok, to e Pita ta ker ngangan karo rhek ruk endruk, to te vrua vaeng e Yesus petgim klenar he kaekon kim o rhek ngang kam kner mang a papat to endo. ");
INSERT INTO sua_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","To e Yesus thortgi he kvokom kalngunes to kle ka kner e Pita kam reng te, “Ehenok ko, petgim kualo keik, ekam ko ye ru kim e Seten, ko ilalo keik ngint gia vle mang o tgoluk ruk mo mmie, nang nong mang o tgoluk ruk mkor E Nut e.” ");
INSERT INTO sua_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ta re tok, to her kle kvaeng a mumu kar kalngunes ngok kim to kreng ngar te, “Erieto mnam muk na papat kam vle te, kua kalyie to en, en na kikiangae mang karo svil mruo, nang kle mrua krus orom en mruo, kmel en mruo kam yor, kam vle gi enang a mhel to ta mrua tolpum kta ho mruo to ngara krong orom o ot kvat ko engnang kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ko endo tvua sovet kam svil hak mang ka ngorsang to mo mmie, a mhel to endo ner lua kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik e. Vanang endo nam mrua slak orom ka ngorsang to mo mmie kam kpom a knovvur he le khavaeng o mia mang dok orom, her en arhe nera kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik. ");
INSERT INTO sua_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ii, ko a mhel nera vle nngia koknaik enangthe napa rum karo mur svil mruo tgus hak mang ka ngorsang to mo mmie tete, vanang koknaik, na gia huo mang kalo ktiek ko tkosnok ko tlua kol a ktalhok to endo? ");
INSERT INTO sua_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ko nop ke vur tomhel ngang hak ko en mruo nak kol mo mmie to tis kmel ekam en mruo orom kam mopel kar a ktalhok to endo hak, he nang en kam le kol e. ");
INSERT INTO sua_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ii, ko o mia nga main to tete ngam kaeharom o kerkeknen he kparem E Nut he ka vle ngang E Nut enang o mia ruk ngma kpoot mang a lei. He a ni mhel to nak leep kim mar pum dok va pum kuaro rhek ko a mhel to endo nma vle kun pgegom mar, va A Mhel To Nkong Man Ma Volkha to dok kat, ngora leep kim E Nut pum a mhel to endo tok kat. Ii, nera vle tok arhe, mnam a kolkha to A Mhel To Nkong Man Ma Volkha to dok ngua kaeknik mnam. Ko mnam a kolkha to endo ngor kaeknik orom E Titou kar karo engyel ruk o totur nga mmok.” ");
INSERT INTO sua_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","“Ii, kua havaeng nguk lmien te, akuruk mnam muk ri muta vle mo, mguer lua yor vop kais ko mguer mia vokom E Nut ka tavgo to ormok ko ka tavgo to endo nak pis lserppak he kaelha kam komor o mia.” ");
INSERT INTO sua_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kopekam o kolkhek ruk aktiek hori orom atgiang ko ngat nop, e Yesus thera nglum e Pita kre Yems va e Yoanes he ka ktong ngar kam grap ngoguon kia vul to a hogor petgim o mia, mar kam vle mar tuk. Ngata vle ko tok, to e Yesus ka vok tkaelha kam horotgi ko pum ngaro kerok. ");
INSERT INTO sua_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Va karo it ngat ngae sei kam pilpil ko ngat ngae ho mi kut les hak kir kim o it tgus ruk mo mmie ko o mia ngma plum mar orom a ye to a serpgar mar kam mmok hak. ");
INSERT INTO sua_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","E Pita kar e Yoanes va e Yems ngat re ka nho, va vgum e Elaisia kre Moses ko ngint her gi pis ko pum ngaro kerok he krere kar e Yesus. ");
INSERT INTO sua_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ngta vokom mar tok, to e Pita ther gi vrong kngam a re ngang e Yesus te, “Vae, pattermia, tho mi kut ya hak ko mor korlotge ngot hera vle mo he. Mor he, ngruaka ngam o rambel akor ko korlotge ngang nguk, tang ngang in, e Moses kat ngang va tang ngang e Elaisia kat!” ");
INSERT INTO sua_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","E Pita ther gi vrong kngam a re ngang e Yesus enang tok, ekam ko a gor a ho laut hak tkol mar. ");
INSERT INTO sua_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","E Pita ta rere vop, va vgum a varhek ko tpis va ka ngoumi ta komor mar. Va ngta ngan a ktui ko tkottek kuon mnam a varhek to endo he kre te, “Ko hal ta arhe, kom vu kaelongtok mang en. He mgua smia ngan vgum!” ");
INSERT INTO sua_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","To ngat her gia petela he re ka nho va si nhong e Moses kre Elaisia, nang kle gia vokom e Yesus tuk ko tgia sir en tuk ko pum ngaro kerok. ");
INSERT INTO sua_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kam ngae, to ngat kaelha kam grung kun kuon kia vul ekam a ngaelaut, to e Yesus thera reng ngar lserppak, mar kam lua polger o rhek ngang a mhel tang mang anito ngat vokom kuo kia vul kam ngae kais ko A Mhel To Man Ma Volkha to en na hop petgim ka nnak. ");
INSERT INTO sua_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","E Yesus ta rere lserppak ngang ngar tok, to kalngunes ngat her gia kir mang a re kun mnam mar mruo, nang gia momnganang ngar mruo mang o rhek ngo pneik ruk te, “kam hop petgim a nnak.” ");
INSERT INTO sua_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","To kalngunes ngat kle hera mnganang te, “Yu! Vanang kman ko o pattermia kmo pos ngam kle khavae te, e Elaisa naka ktar kaol kpis na, ktar mang Endo E Nut Thim Orom Ka Msasaen?” ");
INSERT INTO sua_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Va e Yesus tkoripang ngar te, “Nop, lmien tok ha, ko e Elaisa na mi kaottam E Nut karo rhek, mar kam pis lmien orom en mruo ko naka ktar kaol he kpis tok, kmelel o papat ngang o mia te, nga kta kaeknik ko kim E Nut, he nang mar kam kta mokpom kar En. Ii, nak kaottam E Nut karo rhek, mar kam pis lmien orom en mruo tok, vanangko nngia orom E Nut karo rittiek akuruk kat, endruk mang A Mhel To Man Ma Volkha, ko ngata ktar kpavap mang te, nak lol o vnek vgum o mia he ngak keyang kat. Va o rhek ruk endruk nga lo kais kam pis lmien orom tok kat ge? ");
INSERT INTO sua_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kua havaeng nguk te, e Elaisa ther mi pis he, nangko o mia ngat kle keyang kmikkiem ngartaro svil mruo kmikkiem enang ko E Nut karo rittiek ngata ktar kpavap mang en enang tok arhe.” ");
INSERT INTO sua_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","E Yesus mar ngta grung kun kuon kia vul, he re gia pis mang kalngunes akuruk ku pa vul knop, to ta nho he kvokom a mumu alautar ko ta sovet ngok kmar ko o pattermia kmo pos ngta vle he kmus kar mar. ");
INSERT INTO sua_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A gi hi to a mumu ngta vokong e Yesus ko te gnua pis, ngat ho mrua sor kmar to ksap he kaen nga mamrung ngang. ");
INSERT INTO sua_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","To e Yesus ta mnganang ngar te, “Muta mo maen o rhek kar mar mang anito?” ");
INSERT INTO sua_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","To a mhel langto kun mnam a mumu ko tok, thavae te, “Pattermia kua plalam ko hal ngte kim in ko a koot to a ngoulo tviging he kvat ka gu he. ");
INSERT INTO sua_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ko a koot nam kaim he kootmerom kam krongreik ku mmie to karo guggus ngma klang ka gu. Va nama hem kakro ngnorok va ka vok nam ngae gia serppak kat. Nma vle tok, he kua plalam ngte kim ilengunes he ka mnganang ngar kam kerer a koot to kun mnam petgim, nangko ngat lo is e.” ");
INSERT INTO sua_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","E Yesus ta ngnek tok, to kle ka kner kalngunes te, “Muk ruk o mia nga main to tete, mum vua vrengem E Nut karo papat he kekenhor mang dok hak. Kua kapngan kim muk he, ko kua vle mo kmuk lhok he, vanang mut lo vur kaeha vop orom kua serppak to ko en ngang nguk.” Ta kner mar tok, to le kreng ngar te, “Mu marer plalam a kalyie to endo ngte kim dok na.” ");
INSERT INTO sua_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","To ngat plalam a kalyie to ngok kim. To a koot tre gia vokom e Yesus to gia kakhiker a kalyie he kootmerom kam krongreik ku mmie, he karo gusgus ngat kta klang ka gu kat. ");
INSERT INTO sua_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","To e Yesus ta mnganang a kalyie kteit te, “Nma pis kim mnam o kolkhek aner?” Va tkoripang te, “Kais ko en ke kalyie gi ");
INSERT INTO sua_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","a koot nma ngam kun ma paei va kun ma ye kmegom kmim kngam a yoror. Nangko enangthe ip kais kmeharom a tomhel tang, va ngiaka mrung nguo vanie he kturang nguo.” ");
INSERT INTO sua_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Va e Yesus ta kle kreng te, “Kman ko ye havae te, ‘Ip kais.’ Ko enangthe ip kor mnam yin mang E Nut te, En tis kmeharom o gi vrong tgoluk tgus, va ner mi kaeharom o gi vrong tgoluk ruk endruk gi enang tok.” ");
INSERT INTO sua_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","To a kalyie kteit ta re kngan e Yesus ko ta re tok, va tlo hus kmurur kim te, “Ko gi vur kor mnam dok mang E Nut gi nong ke laut e, vanangko ngiak kaenserpagam dok kam ho sim kut kor mnam dok mang alaut gi.” ");
INSERT INTO sua_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","To e Yesus ta vokom a mumu ko ngat kaelha kam sap klik kam gun mang, to tkaekon kim a koot kreng te, “Yin a koot to ima tokim a mhel kalo ngaela va kvat ka gu arhe. Kua re lserppak ngang in te: Ottek kun mnam a kalyie ta, he or hak kam kta viging ngnik ngnik kat e.” ");
INSERT INTO sua_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","E Yesus treng tok, to a koot ta kervuvui va ka khikher a kalyie to endo klik to kottek kparem. Ta parem knop, to a kalyie ka vok tgia vle enang a mhel ka mnes. Va o mia kavurgem ngat hera re te, “Tyor he.” ");
INSERT INTO sua_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Vanangko e Yesus ta kpom a kalyie to endo ka ktiek he khover to ta hop ksir. ");
INSERT INTO sua_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","E Yesus teharom tok, to hera vaik ngogun ma rek langto ka vle kar kalngunes mar tuk. Ngta vle mar tuk ko tok, to ngta mnganang e Yesus te, “Ngola, kman ko mor mruo ngot lo is kam kerer a koot to endo petgim?” ");
INSERT INTO sua_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Va e Yesus tkoripang ngar te, “A koot ka mten to endo, o vrong tgoluk ngat lo is kam kerer e. Ngiak ngarkie ngang E Nut tuk, to endo yek, E Nut nera kerer.” ");
INSERT INTO sua_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","To ngata parem a mhe to endo to kaelha kam vaik kottek kun mnam o rengmat ruk kun mnam a mhe to e Galili. Vanang e Yesus tlua svil mang a mhel tang kam mnor te, ta vle ko tok e, ");
INSERT INTO sua_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ko ta hivuo kam patter kalngunes. Ta patter mar te, “A mhel langto nera hortgi mang A Mhel To Nkong Man Ma Volkha, he kael ko maktiegom kakro imuo, mar kmim kngam a yoror. Nak yor hak he ka kru kun mnam a kre ka nho kais mo kolkhek ruk korlotge to E Nut na kle kta hover petgim ka nnak, en kam kta hop kat.” ");
INSERT INTO sua_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ta patter mar khavae tok, vanangko kalngunes ngata moruo pum karo rhek ngaro pneik. Va ngta gor kam mnganang en mang ngar kat. ");
INSERT INTO sua_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","To ngta ngae ekam a ngaelaut vop, to le kngae kpis ko mnam a rengmat to e Kaparnam. Ngta vaik kun ma rek langto, to e Yesus ta mnganang kalngunes te, “Muta ngae ekam a ngaelaut va muta mo hem mang anito?” ");
INSERT INTO sua_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ta mnganang ngar tok, vanang ngat gia vongnek kim, ekam ko ngata mus ekam a ngaelaut he kmo kir kmar mang edim mnam mar ruk E Nut ka tavgo ta komor mar ka munik ta laut mang klenar. ");
INSERT INTO sua_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ngat gia vongnek kim e Yesus tok, to e Yesus tkorsang he kvaeng ngar ruk loktiek hori orom alomin ngogu kim. To thavaeng ngar te, “Enangthe a mhel tang naka svil ka munik kam laut kir kim klenar tgus, va her a mhel to endo arhe na mrua krus orom en mruo he kaeha ngang klenar.” ");
INSERT INTO sua_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ta re tok, to kvaeng ke kalyie langto he ka srim kun pgegom mar ko pum ngaro kerok. To tle kaorom maktiegom he khavaeng ngar te, ");
INSERT INTO sua_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mu vokom na, ani mhel to na mrua krus orom en mrua ko pum o mia ruk ngaro mnok ruk ngat lo vua laut enang ke kalyie ta, kam ngatkal mang ngar ko ngat kor mnam mar mang dok, va a mhel to endo ther mi ngatkal mang dok tok kat arhe. Ii, va ani mhel to ta ngatkal mang dok tok, ther mi ngatkal mang her E Nut to tmeng dok ngte tok kat.” ");
INSERT INTO sua_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Va e Yoanes thera koripang te, “Pattermia, ngot vokong a gi vrong mhel langto ko tkaeharom o mia he kerer o kool orom ila munik ka serppak, va ngot lua ngatkal mang, nang kle khagam ko en nam lo kaikkiem mor e.” ");
INSERT INTO sua_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Va e Yesus ta srim te, “Mu or kam hagam e, ekam ko ani mhel to nam kaeharom o ngaelmir ruk lserpgue orom kua munik ka serppak, tlo kais kam kle khortgi mang dok he kta kerrereng dok kat, gi kopekam ko tkaeharom tok e. ");
INSERT INTO sua_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kua re tok, ko enangthe a mhel tang nap lo kael imuo ngang nguk, va her a mhel to tmia ngatkal mang nguk tok arhe. ");
INSERT INTO sua_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ii, kua mien ngang nguk te, ani mhel to na gi kaen a ye ke mhe ngang nguk ekam ko mum kaikkiem Endo E Nut Thim Orom Ka Msasaen, va E Nut ner ho lo kais hak kam kikiangae mang a mhel to endo ka keik e.” ");
INSERT INTO sua_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Va e Yesus ta rere kngae vop te, “Va, kolngunes ruk endri orom ngaro papat ruk kmor mnam mar mang dok ko ngat lo vua serppak mang dok vop, enangthe a mhel tang nap kaop kim kua kalyie tang mnam mar kam mrua ksir petgim dok, va ner vrua ya ngang a mhel to enda kam vle vgum a kapnes to kam kleng a kre to klalaut ko porom ka ngoro he kngam ogu ma ho mlin, en kam yor. Vanang ner kle ho mi ktua kernonho hak ngang a mhel to endo kam vle vgum a kapnes to E Nut ner kaen ngang enangthe nap kaop kim tang mnam kolngunes ruk endri ko tvur kor mnam en mang dok ko ka munik tlo vua laut, he en kam harpeet enang tok. ");
INSERT INTO sua_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ii, he ekam tok, enangthe ip kaeharom a kerkeknen tang orom ila ktiek mruo he na re kaop kim kolkayie tang kmeharom a kerkeknen tok kat, va ngiak kle ka ksir pum a kerkeknen to endo he ka vle gi enang a mhel to napa kser ka ktiek mruo hak he kpet kngam. Ngiak kaeharom tok, ekam ko te sei kam ya hak ngang in, yin kam mrua ngam ke mhe tang ngang yin mruo he kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik tok. Vanang ner kle ho mi ktua kernonho hak ngang in kam vle vgum a kapnes to E Nut kam ngam ila vok tgus kun mnam a paei to a vleir ko mGehina.  ");
INSERT INTO sua_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ko tok mnam a mhe to endo, o ngneng ruk ngam kaem o yor ngaro mnes ngam her gia ktal kim mar ka vle ka vle hak va a paei kat nam lua tep kat e. ");
INSERT INTO sua_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Gi enang tok kat, ko enangthe ip kaeharom a kerkeknen tang orom ila nhar mruo kat he na re kaop kim kolkayie kmeharom a kerkeknen to kat, va ngiak kle ka ksir pum a kerkeknen to endo kat gi, he ka vle gi enang a mhel to nap mrua kser ka nhar mruo hak he kpet kngam. Ngiak kaeharom tok, ko te sei kam ya ngang in, yin kam mrua ngam ke mhe tang ngang yin mruo he kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik tok. Vanang ner kle ho mi ktua kernonho hak ngang in kam vle vgum a kapnes to E Nut kam ngam ila vok tgus kun mnam a paei to a vleir ko mGehina.  ");
INSERT INTO sua_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ko tok mnam a mhe to endo o ngneng ruk ngam kaem o yor ngaro mnes ngam her gia ktal kim mar ka vle ka vle hak va a paei kat nam lua tep kat e. ");
INSERT INTO sua_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Va enangthe ip kaeharom a kerkeknen tang orom ila keik he na re kaop kim kolkayie kat kmeharom a kerkeknen tok kat, va ngiak kle ka ksir pum a kerkeknen to endo kat gi he ka vle gi enang a mhel to nap mrua kalagam ka keik mruo he kpet kngam kat. Ngiak kaeharom tok, ko te sei kam ya hak ngang in, yin kam mrua kalagam ila keik mruo he kpet kngam, he nang yin kam vaik ku meorom E Nut ka tavgo orom ila keik to atgiang tok. Vanang ner kle ho mi ktua kernonho hak ngang in kam vle vgum a kapnes to E Nut kam ngam ila vok tgus orom ilalo keik tgus kun mnam a paei to a vleir. ");
INSERT INTO sua_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Ko tok, mnam a mhe to endo o ngneng ruk ngam kaem o yor ngaro mnes ngam her gia ktal kim mar ka vle ka vle hak va a paei kat nam lua tep kat e.’ ");
INSERT INTO sua_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nera vle ngang ngar enang tok arhe, ekam ko E Nut ner kael a paei kuo mang o mia tgus ngaro pkor, kmikkiem gi enang ko o mia ngam kael a hormnek kuo mang o relot tok kat. ");
INSERT INTO sua_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ii, ko a hormnek nma mgae orom ka karvuk mekam mekam. Vanang enangthe ka karvuk npa hortgi he knop, va ngir kais kam kta kaenserpagam nngia, en kam kta karvuk kat? He enang tok, muk kat, mularo keknen ngak kaeharom mularo ngorsang mo kmuk tgus kam ya va kmisis kun pgegom muk kat.” ");
INSERT INTO sua_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","E Yesus trum karo rhek ruk endruk to kle kparem a mhe to endo he kngae mnam a mmie ka mhe to mYudea to le kngae kat mnam a mhe to ngkun kut pekam a ye to e Yodan ka ngaiting tigut. Va o mumu laol ngta kaum ngok kim ko tok kat. To kmikkiem ka keknen mruo to kam patter o mia, nma patter mar ko tok kat. ");
INSERT INTO sua_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","To o Parisiau akuruk ngat pis ko kim e Yesus ko tok, ko ngata svil kam pe gi kaegom, he nang en kam mrua ru pum karo rhek mruo. Ngat pis to pe gia mnganang te, “Ngola, kmikkiem E Nut karo pos tgia sir gi ngang a ngokol kam gia kser en kar ktavlom ngina lei?” ");
INSERT INTO sua_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Va e Yesus tkoripang ngar te, “Vanang e Moses, ta pos ngang nguk nngia?” ");
INSERT INTO sua_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ngat koripang te, “E Moses ta tting mang te, a ngokol kam kser a lei, enangthe naka ktar kaittiegom a hor ngang ktavlom kam kser ka lei orom.” ");
INSERT INTO sua_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Va e Yesus tkoripang ngar te, “Mare, vanangko tgi havae tok, ekam ko mularo papat ngma vle gi kaendel pum E Nut kngam ge. ");
INSERT INTO sua_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Vanangko tennik mnam o kolkhek ruk E Nut tkueng o tgoluk, ta kueng o mia he kmommen mar kam vle te, lurokol va lraip. ");
INSERT INTO sua_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","He ekam ko E Nut tkueng o mia tok, a ngokol nak parem kteit va knan he mrua pet orom kmikkiem ktavlom, ");
INSERT INTO sua_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","min kam kaum ka vle te, min atgiang. Gi enang tok, ngint lo kta vle te, langto ge langto ge e. Ko her min atgiang he, min kam vle atgiang. ");
INSERT INTO sua_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","He enang tok, ekam ko E Nut tngam min mo kmin enang tok, va muk ruk o gi mia, mguak or kam ngatkal mang a mhel tang kam kser min mo kmin e.” ");
INSERT INTO sua_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","E Yesus ta re tok, to thera vaik kun ma rek. Ko tok, kalngunes ngata kta mnganang mang karo rhek kat. ");
INSERT INTO sua_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Va e Yesus ta reng ngar te, “Enangthe a ngokol tang napa kser ka lei, nang kle klei orom a vlom tang ko yok, yek endo yek, a mhel to endo tmi kaeharom a kerkeknen ngang ktavlom to ta ktar lei orom ko ta kpoot mang ngina lei tok arhe. ");
INSERT INTO sua_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Va ta vle tok kat ngang a vlom to napa kser ka lei kar katngokol, nang kle klei orom a ngokol tang ko yok, ko en kat ta kpoot mang ngina lei, enangthe npa lei orom a ngokol tang ko yok enang tok.” ");
INSERT INTO sua_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","To ko tok, o mia ngat kurkeik kim e Yesus orom o ngnes kam lol ngok kim, en kmel kalo ktiek kuon mang ngar kam ngamyammok mang ngar. Ngat kurkeik kim tok, to kalngunes ngata kner mar. ");
INSERT INTO sua_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","E Yesus tvokom mar ko ngta re kmekon mar tok, to ka vrek ta kiin ngang ngar he kreng ngar te, “Mguak orim mar kmaol ngte kim dok na, ekam ko o mia ruk ngat kaenang o ngnes ruk enang endri, her mar ruk arhe E Nut ka tavgo ta komor mar. ");
INSERT INTO sua_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ii, lmien ko kua havaeng nguk te, mguak toot he ka nho na, ko endo nam lua kolaspa kam tting kam vaik ku meorom E Nut ka tavgo enang o ngnes ruk endri, ko mar ngam gia kolaspa mang o tgoluk enang tok, va en tlo kais hak kam vaik ku meorom e. Nop hak!” ");
INSERT INTO sua_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","To e Yesus thera kaorom o ngnes akuruk he kael kalo ktiek kuon mang ngar kam ngamyammok mang langto langto mnam mar tok. ");
INSERT INTO sua_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","To E Yesus ta re kam parem a mhe to endo, to a mhel langto ta sap ko kim he ktubulkek ku penharom to ka mnganang te, “Pattermia, yin a mhel a yar, he havaeng dok na te, nguak kaeharom anito, he nang dok kmis mang E Nut kmen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang dok?” ");
INSERT INTO sua_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Va e Yesus tkoripang te, “Kman ko ya mon dok te, a mhel to a yar, ko gi atgiang En tuk a yar, gi E Nut tuk arhe, nang nong a mhel tang ko a yar kat e. ");
INSERT INTO sua_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yin mruo ya mnor mang o pos ruk endri te, ‘Or kam por mia, or kam kpoot mang a lei, or kmuruvik, or kam ppiak kam mon ilenar orom o kerkeknen ko kim endruk ngma vongnek kim o rhek, or kam kauyang o mia kmuruvik mkor mar, va ngiak totu pum iteit va inan.’” ");
INSERT INTO sua_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Va a mhel to enda tkat koripang e Yesus te, “Pattermia, te o pos ruk endri ko elha kam sim kut kaikkiem mar tiok he ko dok a gi kalyie vop kam ngae kais tete.” ");
INSERT INTO sua_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","E Yesus tre ngan ko ta re tok, to kalo keik ngint kaem a mhel to endo to te sei kmelongtok mang to hera reng te, “Vanangko a tomhel langto yi lo eharom vop. Ngiak ngae he klol ilaro tgoluk tgus he kaenik ngang o mia, mar kmenkim mar mkor in. To ngiak lol o krek he le kaenik ngang o mia ruk ngma tu kim o tgoluk. Ngiak kaeharom tok, he nang yin kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ko a ktalhok to endo ta vle enang ila gol ka pun to kmelpas orom kuon ma volkha. Ii, ngiak kaeharom tok knop, to her kaol he kaikkiem dok.” ");
INSERT INTO sua_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A mhel to endo tngan e Yesus karo rhek ruk endruk to ka spang tho mi kut ksir hak. To ther gia him kalo ktiek he ksei kam mrung en mruo ko karo vu tgoluk ka ho vurgem hak. Ii, thim kalo ktiek to hera ngae kparem e Yesus mar. ");
INSERT INTO sua_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ta ngae, to e Yesus thortgi ngok kim kalngunes he kpetela mang ngar to kreng ngar te, “Ner vua kellet hak ngang o mia ruk ngaro vu tgoluk, mar kam vaik ku meorom E Nut ka tavgo.” ");
INSERT INTO sua_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tre tok, to kalngunes ngta sor kim karo rhek. To e Yesus thera reng ngar te, “Kolenar, kua mien ha, ko tmia kellet hak ngang o mia kam vaik ku meorom E Nut ka tavgo. ");
INSERT INTO sua_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ii, tlo vua kellet tok ngang a ngaemslang to alautar hak to a kamel kam khanang kam vaik ku meorom ke gudor tang ko ke mi laut. Vanang a mhel to karo vu tgoluk, ta kle ho mi ktua kellet hak ngang en kam vaik ku meorom E Nut ka tavgo.” ");
INSERT INTO sua_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kalngunes ngta ngnek tok, to ngat ho mi kut kait ngaro ngaongtok kim karo rhek to kle kmo mnganang ngar te, “Enangthe karo rhek ngata mien, va nop a mhel tang hak tkais kam mrua sulgim en mruo he kvaik ku meorom E Nut ka tavgo hak kat e.” ");
INSERT INTO sua_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","To e Yesus kalo keik ngint kaem mar to thera reng ngar te, “O mia kam mrua sulgim mar mruo kam vaik ku meorom E Nut ka tavgo ngat ho lo mi ktuis hak kmeharom tok e. Vanangko E Nut tmi ktuis kmeharom o vrong mia tgus he kaeharom mar he ngat kais kam vaik ku meorom.” ");
INSERT INTO sua_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","To e Pita tkaelha kam havaeng e Yesus te, “Vokom na, endruk ya rere mang ngar ko ngat paparem ngakro vu tgoluk tgus, nang kle kaikkiem yin, her mor ri arhe.” ");
INSERT INTO sua_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tkaelha kam re tok, vanangko e Yesus ta kser e Pita karo rhek kam reng te, “Ko smia mien ngang nguk te, ani mhel to tparem ka rengmat, i o kaornopeik, kaorotmeik, kaortek, kaornek, i o kles ko ta kor mnam en mang dok he khavaeng o mia mang a knovvur, ");
INSERT INTO sua_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","va a mhel to endo E Nut ner ho mia klang mo tgoluk he nera vle kia vul ormar tete mnam a venloot to enda. Ii, E Nut nera klang orom o rektor akuruk, o kaornopeik akuruk, o kaorlok akuruk, o kaorotmeik, o kaoroyel, o kaornek, o ngnes, va o marhok akuruk kat. Nera lol mar tgus kar o vnek kat tete, ko o mia ngara kol a regesal mang vgum dok. Va koknaik kat mnam a venloot to nera pis yek, a mhel to endo nera kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik kat. ");
INSERT INTO sua_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Vanang o mia ruk ngaro mnok ngta laut tete, kavurgem mnam mar E Nut ner kle ka krus ormar koknaik. Va tok kat ngang endruk ngaro mnok ngta grung tete, ko her kavurgem mnam mar tok kat arhe E Nut ner kle khover mar koknaik.” ");
INSERT INTO sua_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","To e Yesus ta ktong kalngunes he kaikkiem a ngaelaut kam grap ngoguon mYerusalem. Va kalngunes ngat kaikkiem he ksor kim va endruk pekam mar ngta gor kat. To e Yesus ta kta nglum mar ruk loktiek hori orom alomin petgim o mia he kta havaeng ngar mang o vnek ruk nga re kam pis kim. ");
INSERT INTO sua_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Thavaeng ngar te, “Vae, mu vokom na, ko ngruaka grap ngoguon mYerusalem he A Mhel To Nkong Man Ma Volkha o mia ngar kael ko maktiegom o pris ruk laol va o pattermia kmo pos, mar kam monik kim a yor ngang. To ngar kle kael ko maktiegom o vrong rhek ");
INSERT INTO sua_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","he ngara klel orom he kguguspa mang to kirmekon a khap mnam, to le kaim kngam a yoror. Ii, ngar kaeharom tok ngang, vanangko ko pekam o kolkhek ruk korlotge kat, ner kta hop petgim ka nnak.” ");
INSERT INTO sua_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","To e Sebedi klo hal ruk e Yems kre Yoanes ngint kaol kpis ko kim e Yesus he kreng te, “Pattermia mota svil mang yin kmeharom a ni vrong tomhel to mota mnganang yin mang.” ");
INSERT INTO sua_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Va e Yesus ta mngan te, “Meta svil mang dok kmeharom anito ngang ngae?” ");
INSERT INTO sua_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Va minta re te, “Ngiaka tting orom muo kun mnam a kolkha to o mia tgus ngak vokong ila lo ktiek vgum ila tavgo ko na re kvaas kim o mia tgus he komor mar, va moak kol alo ngaekam ruk E Nut nma nho orom min, tang ko vanam ila miktiek va langto ko vanam ila ksienga, muo kam kaum kar yin kam nho mang o mia kar yin orom ila tavgo ko tok mnam ila yammok.” ");
INSERT INTO sua_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Va e Yesus tkoripang ngin te, “O-o, met ho mi ktua ketoptop hak mang dok tok arhe, ko meta pat re te, met kais kat kam lol o nganngannes ruk dok mruo ngora lol gi? Va a vnek to ketasuo kam vuvvuem dok ko nera vle enang a ye ko nma vuvvuem a rengmat, va met kais kam viging a vnek to endo kat?” ");
INSERT INTO sua_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Va mint koripang te, “Ii, mot kais!” Va e Yesus tkat koripang ngin te, “Nop, o vnek ruk ketasuo dok kam lol, va mae kat mera lol metakor. Va a vnek to ketasuo kam vuvvuem dok, va mae kat mer mia viging metang gi enang dok tok kat. ");
INSERT INTO sua_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Vanangko kam mon te, erie minduk minera korsang ko vanam kua miktiek va langto ko vanam kua ksienga, kam kaum kar dok kam nho mang o mia, a papat to endo nong kua ngaeha to dok kmeharom e. Gi E Nut tuk to ner mur kaen alo ngaekam ruk ennginduk ngang alo ni mhel ruk En mruo ta ktar el ka papat mang ngin tennik kmen alo ngaekam ruk ennginduk ngang ngin.” ");
INSERT INTO sua_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","To nginlenar ruk loktiek ngat re ngnek mang a rere to endo va ngaro vurkul ngat kaelha kam kiin hak ngang ngin. ");
INSERT INTO sua_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","To e Yesus ta vaeng ngar tgus ngok kim to kreng ngar te, “Muk, muta mnor he mang o vrong rhek ngakro taven kar ngalmialaol ngakro keknen ko ngam mrua kansgum mar mruo kam kol a ngaekam to kam nho mang ngakro mia mruo, ngola? Ii, ngma karkar mang ngar he o mia ngma kerkolkol vgum ngaro serppak. ");
INSERT INTO sua_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Vanang kun pgegom muk, na lua vle enang tok ngang nguk e, ko endo mnam muk naka svil ka munik kam laut mang klenar, mar kam nho orom, va her endo arhe na kle mrua krus orom en mruo, nang kle gi kaeha ngang nguk ha! Mare, na kle ho mi ktua krus orom en mruo, nang kle gi kaeha ngang nguk tok arhe! ");
INSERT INTO sua_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ii, en naka vle tok arhe kmikkiem gi enang A Mhel To Nkong Man Ma Volkha, ko si en mruo kat tpis nong mang o mia kmeha ngang e. Nove, ta kle kpis kam mrua slak orom ka vok mruo kmel ekmar orom ka vok to endo, he nang kam kta lol mar tgus kam kta vle ngang E Nut kat.” ");
INSERT INTO sua_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","E Yesus mar ngata ngae ekam a ngaelaut vop to kpis kun ma rengmat to e Yeriko. Kam ngae, to ngata parem a rengmat to endo kar kalngunes kam kta ngae kat. Va a mumu alautar tkaikkiem mar kat. Ngta ngae, va vgum a mhel to tvipsik ko tkorsang ko vanam a ngaelaut he kngangarang o mia kmo krek. A mhel to endo, ka munik te, e Bartimeas, endo e Timeas khal. ");
INSERT INTO sua_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ta vle he kngangarang o mia tok, to ka ngnek te, e Yesus to nkong mNasaret ta ngae ekam a ngaelaut. Ta ngnek tok, to her kaelha kam vui orom te, “O-e Devit kaes to yin, Yesus-o, ngiaka mrung dok vanie!” ");
INSERT INTO sua_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","To o mia kavurgem ngta vokom tok, to ngat kaekon kim kam hagam kam rere. Vanangko ngat le ho gi kaoppom klik en kam ho gia vui klik kat ge te, “O-e Devit kaes to yin e Yesus-o, ngiaka mrung dok vanie!” ");
INSERT INTO sua_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","To e Yesus ther gia sir ko va ngaelaut to kreng o mia te, “Mu vaeng endo ngte kim dok na.” To ngta vaeng he kreng te, “Serppak na, ko thera vaeng yin he. Hop sir!” ");
INSERT INTO sua_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","To e Bartimeas thera hop klik kngam ka yet to kuon mail petgim he kngae ngok kim e Yesus. ");
INSERT INTO sua_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","To e Yesus ta mnganang te, “Havaeng dok na, ya svil mang dok kmanker in?” Va endo ta vipsik ta reng te, “Pattermia, kua svil yin kmeharom kua lo keik, he dok kam nho!” ");
INSERT INTO sua_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Va e Yesus ther gia re te, “Yu, ngiak ngae he! Ko kaeharom ila lo keik he ngint ya he, ekam ko yi kor mnam yin mang dok kmeharom tok.” A gi hi to e Yesus tgia re tok, a mhel to endo ther gia nho ngatngae, to her kaelha kmikkiem e Yesus ekam a ngaelaut to ngoguon mYerusalem. ");
INSERT INTO sua_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","E Yesus mar ngta ngae he konner a rengmat to e Yerusalem ko ngat pis ko va ngaelaut to mang alo rengmat ruk e Betpagi va e Betani kuon kim ke vul to e Olip. To e Yesus thera meng klo kaloyie aloruk kam ktar mang ngar ");
INSERT INTO sua_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ko thavaeng ngin te, “Meaka ktar kngae ngok ma rengmat tma kuon he mera vaik mnam a rengmat ka gu he mera pis mang a dongki to ke sie ko ngta kleng he tgia sir. A mhel tang tlo sap orom vop. Meak pis mang va meak halger a ngausie pum he it ngte kim dok. ");
INSERT INTO sua_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nang enangthe tang naka mnganang ngae mang te, ‘Ngola, meta halger a ngausie pum a dongki to kman?’ va meak koripang te, ‘Ngoldaip ta re mang he ner lo hus kam gi kat kaekon kmeknik ngok kim yin kat e.’” ");
INSERT INTO sua_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ta reng ngin tok, to ngint hera ngae her gi pis mang a dongki to ke sie ko ngta kleng ko va rek ka gudor ko ma mmok ekam a ngaelaut. To ngint hera halger a ngausie pum. ");
INSERT INTO sua_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ngint re khalger a ngausie pum to o mia akuruk ruk ngta sir ko tok ngta mnganang ngin te, “Met kan ko meta halger a ngausie pum a dongki to ke sie to endo?” ");
INSERT INTO sua_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Va ngint her gi koripang ngar gi enang ko e Yesus ta kenang ngin tok. To ngta ngatkal mang ngin to ngint hera kol a dongki to ke sie kait kngorom. ");
INSERT INTO sua_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ngint kait kngorom kpis ngok kim e Yesus to le kpasrengem orom nginaro it. To e Yesus ta grap korsang kuo mang to le ksap orom kmikkiem a ngaelaut. ");
INSERT INTO sua_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ta ngae va o mia kavurgem kun mnam a mumu to tveet ekam, ngat kaelha kam pasrengem a ngaelaut kam vevher ngakro it ekam. Va akuruk ngta kuung o kneng ngo hor ko ma lootpgeik he kaenerik ekam a ngaelaut kat. ");
INSERT INTO sua_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Va endruk ngata ktong e Yesus kar endruk ngata knaek mang ngat kaelha kam mariu orom va kael kavres orom kat te, “Ngota kanprim yin ko her yindo kam sulgim mor arhe. ");
INSERT INTO sua_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","E Nut ta ngamyammok mang ka taven to yin ko ya pis orom ka munik. Ii, yindo ngores to e Devit kaes to E Nut na ngamyammok mang ko ketasuo yin kam pis orom ila tavgo to na komor o mia tgus. He ekam tok, Ngruera kanprim E Nut to man ma volkha ko her En arhe Endo tel yin kam sulgim mor.” ");
INSERT INTO sua_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ngata hivuo kam kni kngorom tok, to e Yesus thera vaik ngogun mYerusalem he. To ta ngae kvaik kun mnam E Nut ka maksien he gia punpa kun mnam he kvokom o tgoluk tgus. Vanangko ekam ko a kolkha tre kam vaik, thera ngae kaeknik ngok mBetani kar kalngunes ruk loktiek hori orom alomin. ");
INSERT INTO sua_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","To hop enang ngmo, e Yesus mar ngta parem a rengmat to e Betani he kat ngae ekam a ngaelaut to kam grap ngoguon mYerusalem va e Yesus ta vang. ");
INSERT INTO sua_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ta ngae va vokom a ho to a pik ko ta sir vur hagenmok mang orom karo vu im ruk o gunsur. To thera ngae ko rkieng kam nho ko vgum. Tpis ko kim va tngae lo vur vokom kakro miel ngang hak. Kakro gi im tuk ko nong a ho ka main kmehi vop. ");
INSERT INTO sua_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","To ther kaen o rhek mnam te, “Yin ke pik to enda ngia lo kat kaehi, o mia kam lo kat kaemik vgum yin kmelha tete kam ngae kais ngnik ngnik kat.” Va kalngunes ngta ngan kakro rhek ko thavae tok. ");
INSERT INTO sua_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","To ngta ngae to kpis ko mYerusalem to e Yesus thera ngae kta vaik ogun mnam E Nut ka maksien. Ta vaik, to her kaelha kam kerer endruk ngma kanko kmelel o tgoluk, o mia kmenenkim mar mkor mar, nang kle ka nngiar ngang E Nut ormar. To thera kootmerom o psen ruk mkor endruk ngma mopatap orom o krek. To tle kootmerom o ngorsang ruk mkor endruk ngam kael o giu, o mia kmenkim mar mkor mar kam le ka nngiar ormar kat. ");
INSERT INTO sua_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Va tle ka kser o mia kam lo kta lol o gi vrong tgoluk he kngae kpoottom a ngaelaut ko tok mnam E Nut ka maksien ormar kat. ");
INSERT INTO sua_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tkaeharom tok, he keknen ngang ngar te, “Nok mut lua mmok mang E Nut karo rhek ruk ngat ittiegom mar ko ngat havae te, ‘Kua maksien ka ngaeha ka pun na gia vle tuk her gi mang a ngaeha to kam ngarkie mnam, he nang o vrong rhek tgus kam ngarkie ko tok.’ Vanangko muk ri, mut her hortgem ka ngaeha ka pun msim ko mut kle kael enangthe a mhe to kam vaik kun mnam kmurur o mia ngaro krek. Ii, mut hortgem, he en ta kle kpis enangthe a kre ka nho to o ngauruvik ngma tvok mnam kam totokim mar he koon mang ngar.” ");
INSERT INTO sua_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","O pris ruk laol kar o pattermia kmo pos ngta ngan ko e Yesus teharom tok, to endo yek, ngat kaelha kam riring a ngaelaut tang lvongnek, he nang o mia kmim kngam a yoror ko ngta gor te, o mia ngar mrua ksir petgim mar, nang kle kaikkiem en, ekam ko ngat itit ngaongtok kim kakro rhek. ");
INSERT INTO sua_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","To a kolkha tre vaik, to e Yesus kar kalngunes ngat kat kottek kun mnam e Yerusalem to her kta ngae. ");
INSERT INTO sua_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","To hop enang ngmo marot, E Yesus mar ngat kta hop he kta ngae. Ngta ngae ekam a ngaelaut he kta pis mang a ho to a pik to kvokom kakro im va kakro kavgot tgus ko ngat her gi vui ngatngae. ");
INSERT INTO sua_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","To e Pita ta pat mang e Yesus ko ten o rhek mnam a ho to endo to kreng te, “Ngoldaip, vokom a ho to yen o rhek mnam, ko tngae her gi vui ngatngae he.” ");
INSERT INTO sua_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Va e Yesus tkoripang te, “Ii, va kua havaeng nguk lmien te, mguak kor mnam muk mang E Nut te, En tkais kmeharom o tgoluk tgus, nang mu or kam lopumtang mang e. Ko endo na si kaen o rhek mnam a vul to enda kam reng te, ‘Hop ko tok, he kle kngae ksir oguo mou’, va a vul to enda ner mia ngan vgum. Ii, nera ngan vgum enangthe a mhel to endo na kor mnam en mruo mang E Nut te, E Nut ner mi kais kmeharom karo rhek, mar kmel mit kmikkiem enang ko tkor mnam en mang E Nut tok. ");
INSERT INTO sua_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","He ekam tok, o gi vrong tgoluk ruk mum kaurur kim E Nut mang ngar, E Nut ner kaenik ngang nguk enangthe mup kor mnam muk mang En kmenik ngang nguk enang tok. ");
INSERT INTO sua_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ii, mguer kais kmeharom tok, vanang enangthe ngiaka ktar ksir he kngarkie ngang E Nut malpgem a tutu to ila tel ngang in, va ngiak kol ila to endo ka kerkeknen patgiang ngaiting he kikiangae mang enangthe ipa svil mang iTeit tkuon ma volkha kam lol ilaro kerkeknen patgiang ngaiting he kikiangae mang ngar tok kat.” ");
INSERT INTO sua_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“Vanang enangthe mgua lua ktar klol o mia ngaro kerkeknen patgiang ngaiting he lua kikiangae mang ngar, va mu Teit tkuon ma volkha ner lua lol mutakor patgiang ngaiting he lua kikiangae mang ngar tok kat e.” ");
INSERT INTO sua_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","To ngta ngae ekam a ngaelaut to kpis kta vaik kun mnam e Yerusalem kat. To e Yesus tngae he kpunpa kun mnam E Nut ka maksien to o pris ruk laol kar o pattermia kmo pos va o Yuda ngalmialaol ngat kaol kpis ko kim ");
INSERT INTO sua_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","he ka mngan pum te, “Erieto tmeng yin kam kerer mor tok mo mnam E Nut ka maksien ta?” ");
INSERT INTO sua_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Va e Yesus tkoripang ngar te, “Vanang dok kat, ngor le ka ktar ka mnganang nguk kat na. He mgua re oripang dok, to dok kat, ngor le koripang nguk kam havaeng nguk mang Endo tmeng dok kmeharom tok.” ");
INSERT INTO sua_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Thavaeng ngar tok, to le ka mnganang ngar te, “Erieto tmeng e Yoanes, en kam parrum o mia, E Nut tkuon ma volkha, i o a gi vrong mhel tang? Mu havaeng dok na!” ");
INSERT INTO sua_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","To ngata mo hem mar mang a papat to endo, to mo reng ngar mruo te, “Ngola, enangthe ngrua re koripang he re khavaeng te, ‘E Nut to tmeng,’ va en ner kle kaekon ngang ngor te, ‘Va kman ko mut lo kor mnam muk mang?’ ");
INSERT INTO sua_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Va ngot ho lo kais kat kam havae te, ‘A gi vrong mhel tang to tmeng.’” Ngata havae tok, ko ngata gorang o mia pum e Yoanes, ko mar tgus ngtel ngaro papat lserppak mang e Yoanes te, en a mi propet langto. ");
INSERT INTO sua_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","He ekam tok, ngat her gi koripang e Yesus te, “Ngot lua mnor mang e.” Va e Yesus tkat tkoripang ngar tok kat te, “Te dok kat, klo kais kam havaeng nguk mang Endo tmeng dok kmeharom a ngaeha to endo kat e.” ");
INSERT INTO sua_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ko pekam ka re to endo, e Yesus tkaelha kam koka ngang o pris ruk laol kar o pattermia kmo pos va o Yuda ngalmialaol kam havaeng ngar te, “A mmie kteit langto tkaeharom ka loot. Ta kurhennek krum to kngam a pal kam paneng a loot kam ttek, va kngam a rambel langto kam toot mang a loot kat. To tkael sarek mnam ngang o mia kam kavang ngaro ol, nang en thera ngae mnam a mhe langto ko yok. ");
INSERT INTO sua_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kam ngae, to ka loot ta tettek he, to a mmie kteit thera meng kalkayie langto ngok kim endruk ngat tutuur mnam ka loot, mar kam lluol ngang he ktatar en mang a mmie. ");
INSERT INTO sua_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kalkayie tpis ko kmar, vanangko endruk ngata tutuur mnam a mmie kteit ka loot ngta vle her gi im to kaekon tgia ngongae kaeknik. ");
INSERT INTO sua_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","To a mmie kteit ta kta meng kalkayie langto kat ge ngok kmar. Va enda, ngat him singni malpgem he kaeharom o kerkeknen ngang, endruk kam ho mi kut ngamleep mang hak. ");
INSERT INTO sua_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","To ta kta meng kalkayie langto vat ngok kmar. Va enda, ngat por kngam a yoror. Ngat eharom tok ngang kalngunes akuruk kat ko mar kavurgem ko tmeng ngar ngok kmar enang tok kat. Va akuruk ngat kaim mar va akuruk ngta por mar kngam mar o yoror. ");
INSERT INTO sua_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","To a her gi tgiang to tgia vle vop, endo khal msim vat. En khal to nam vu kaelongtok mang. Tpat re te, ‘Ngara totu pum ko hal msim ta.’ To ko pekam mar tgus, ta trong orom khal msim to endo kam meng ngok kmar. ");
INSERT INTO sua_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Vanangko endruk ngta tutuur mnam ka loot ngta mo havaeng ngar mruo te, ‘O, her khal msim to kam kol kteit ka mmie ta arhe. Ngor tarkanang he im, nang mor kam le kol a mmie ta.’ ");
INSERT INTO sua_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","To ngat hera kapom he kpor kngam a yoror to ngat hera kokol ka mnes he kngam ngku mnok petgim a loot.” ");
INSERT INTO sua_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","E Yesus ta rum ka koka to endo, to kle ka mnganang endruk laol te, “To muta pat te, a mmie kteit na kanker endruk ngat tutuur kun mnam ka loot? Te ner kle kngae kpis krum kim mar tgus hak, nang kle kael sarek mnam ngang o mia akor ko yok vat, ngola?” ");
INSERT INTO sua_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Thavae tok, to kle kaenserpagam ka re to te, “Te nok pathe mut lo him E Nut ka ngaittiek ta ge, ko thavae te, ‘Endruk ngma ngamrektor ngat keyang a ho langto he kait petgim a rek he ka vlengam. Vanangko a her gi ho to endo arhe ther kle ka vle te, a ho to mang a hokidek to arhe, endo kam sir orom a rek. ");
INSERT INTO sua_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Va a ho to endo ta vle ngang ngar tok ekam ko Ngoldaip mruo ta mrua svil en kam mi ktua vle enang tok arhe. Va ngot vokom tok kat, he kngae kpat mang te, a papat to endo tngae gia yaya pum nguaro kerok he!’” ");
INSERT INTO sua_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","E Yesus thavae tok, to o Yuda ngalmialaol ngata tar ko ta koka mang ngar lsir, to ngat sia khanang ngar kam kapom kmenpasiker kun ma hengor. Vanangko ngat lo is ekam ko ngata gorang a mumu pum, to ngat her gia parem kngae. ");
INSERT INTO sua_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kam ngae, to o Yuda ngalmialaol ngta meng o Parisiau kar o mia akuruk kun mnam a valngan to mkor e Herot ngok kim e Yesus kmenen mkor, en kam mrua ru pum karo mur rhek mruo. ");
INSERT INTO sua_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ngta pis ko kim e Yesus he pe gia kanprim te, “O, pattermia ngot sim ktua mnor miik, ko im vua mien orom ilaro rhek va ima patter o mia lsir kmikkiem E Nut karo pos lsir. Va im lua ruokar kim o gi vrong mia kat e, ko ima rere he lo gia tar yin pum o mia akor kam pat mang ngar, nang ka mnang akuruk e. Nove. He ekam tok, ngiak havaeng ngor na te, ta sir ngang ngor ruk o Yuda kam ngam o takis ngang lRom ngalaip to ngma mon te, e Sisa, i o nop ge? ");
INSERT INTO sua_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Havaeng ngor na te, ngruak kaenkim a takis, i o nop?” Ngat pe gia mnganang tok, vanangko e Yesus ta tar ko ngata kerruru enang tok, to kle ka mnganang ngar te, “Kman ko muta kendom ngang dok? Ma te, mu en a kre tang ngte ko vokom na.” ");
INSERT INTO sua_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","To ngat her kait a kre langto he kaen mkor. To e Yesus thera mnganang ngar te, “Erieto ka nunu va ka munik ta vle kuo mang a kre to enda?” Va ngat koripang te, “He e Sisa.” ");
INSERT INTO sua_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","To e Yesus tkat koripang ngar kat te, “He ekam tok, mguak kaekon o tgoluk ruk ngta khenam e Sisa ka nunu ngak kat kaeknik ngang kat, vanang kle kaekon muk mruo ngang E Nut ko muta khenam E Nut ka nunu ormuk mruo enang tok kat.” Ngta ngan karo rhek ko ta re tok, to ngat ho mi ktua sor kim karo papat. ");
INSERT INTO sua_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","To vrua vle, to o Sadyusi akuruk ngat kle kaol ngok kim e Yesus vat. Vanang mar ngam ktua pat te, o mia ngama yor va ngar lua hop petgim ngakro nnak e. Endri ngat kaol kpis ko kim e Yesus he pe gia mnganang kat te, ");
INSERT INTO sua_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Pattermia, tennik e Moses tittiegom a pos langto ngang ngor te, enangthe a mhel tang knopia nak yor parem ktavlom, nang nong kles ngang, va en nak kle kliepak ekam knopia to tyor, nang a vlom kam llues, en kam hover knopia ktavlom ka ngausie. ");
INSERT INTO sua_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yu! A pos to endo ta vle tok arhe, vanang enangthe napa vle tok ko o moornopeik aktiek hori orom alomin ngata vle tete mo kmor, to endo a molpou tlei to le kyor parem ktavlom, nang tlo llues e. ");
INSERT INTO sua_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","To gi enang tok kat mang endo ko pekam ko ta liepak ekam knopia kat to ther gi kat yor kat, nang nong kles ngang kat e. To endo ko pekam min kat, ta le kta liepak ekam endo kat to kta yor. ");
INSERT INTO sua_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Va si o moornopeik tgus ruk aktiek hori orom alomin ngta vle tgus tok, ko ngat yor kparem a vlom, nang tlo llues e. Kam ngae, to a vlom to endo kat ta le ktua yor vat. ");
INSERT INTO sua_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To kmikkiem ke ngothoi to endo tok, koknaik mnam a kolkha to E Nut na kta hover o yoror petgim ngakro nnak, a vlom to enda naka vle te, edim mnam o moornopeik ri ktavlom msim to, ko mar tgus ruk aktiek hori orom alomin ngat lei orom?” ");
INSERT INTO sua_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","E Yesus ta ngnek tok, to kle koripang ngar te, “Nok pathe mularo papat ruk mang o yoror ngat lo vua sir hak, ekam ko mut ho lo kta mmok hak mang E Nut karo rittiek va mang E Nut ka serppak kat e. ");
INSERT INTO sua_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ko E Nut ka papat to a minar mang o yoror ta vle ti te, mnam a kolkha to E Nut na hover o yoror, mar kam kol a ktalhok to kam plong vle ko kim En ngnik ngnik, ngar lo kat kael lraip, he lurokol kam kta lei orom mar kat e. Ko o mia ngar kle va kaenang o engyel ruk kuon ma volkha. ");
INSERT INTO sua_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Vanang kun mnam E Nut karo rhek ruk mang o yoror, e Ebrehem va e Isak va e Yakop ngata khenam a papat to mang o yoror ma mmok te, ngar mi ktua hop petgim ngaro nnak. Vanangko nok pathe, mut lo him E Moses ka hor to endo vop? Ko kun mnam a ngothoi to mang ke turvek to a paei ta vurvur pum he lo kaem, E Nut thavaeng e Moses te, ‘Her dok ta arhe, dok to e Ebrehem va e Isak va e Yakop ngma vle ko kim dok he ktotu pum dok tennik kngae kais mang tete.’ ");
INSERT INTO sua_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ii, thavae tok, he ka khenam a papat to mang o yoror ma mmok te, endruk ngat kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik kam totu pum, her mar ruk ngata kta hop petgim ngaro nnak, nang nong endruk ngat yor he lo kta hop kat e.” ");
INSERT INTO sua_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Vanang langto mnam o pattermia kmo pos tkaol pis ko kim o Sadyusi he kngan mar ko ngata mo maen o rhek kar e Yesus. Ta ngan e Yesus ko tsim koripang ngar, to ta le kaenen mkor e Yesus kam pe gia mnganang kat te, “Ngola, kun mnam o pos tgus, edim mnam mar msim ta vle te, a pos to a ngaenpaeir he kir kim klenar tgus?” ");
INSERT INTO sua_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Va e Yesus tkoripang te, “A pos to a ngaenpaeir he kir kim klenar tgus, enda ti te: ‘Muk lIsrael mguaka ngnek na, Ngoldaip to E Nut, En arhe mgua gia totu pum En tuk. ");
INSERT INTO sua_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ngiak kmelongtok mang Ngoldaip orom ila ngaung tgus, ila svil tgus, ilaro papat tgus va ilaro serppak tgus.’ ");
INSERT INTO sua_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Va a pos to ta knaek mang endo thavae ti te: ‘Ngiak kaelongtok mang ilenar kmikkiem enang ko im mur kaelongtok mang yin mruo kat.’ Nang nong a pos tang ta laut kir kim alo pos ruk enngindi e.” ");
INSERT INTO sua_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","E Yesus thavae tok, to a pattermia to endo ta kle khavaeng te, “Pattermia, yi sim oripang dok. Ko ya mien te, ‘Ngoldaip to E Nut her En arhe ngua gia totu pum En tuk, nang nong a tomhel tang kat e.’ ");
INSERT INTO sua_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Va ya mien kat te, a keknen to kam ‘kmelongtok mang E Nut, he ka khenam tok orom nguaro svil, nguaro papat va nguaro serppak kat’, va a keknen to kam ‘kmelongtok mang ngolenar kmikkiem enang ko ngom mur kaelongtok mang ngor mruo’ ngint laut kir kim o keknen tgus ruk kam nngiar ngang E Nut orom o relot ruk ngoma momrot va o gi vrong nngiar tgus kat.” ");
INSERT INTO sua_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","E Yesus tngan a mhel to enda ko tsim koripang orom karo rhek tok, to thavaeng te, “Ketasuo yin kam vaik ku meorom E Nut ka tavgo he!” To ko pekam e Yesus kakro rhek ruk endruk, nop a mhel tang hak ta kta re kmegom kta serppak mruo kam mnganang e Yesus mang a papat tang kat e. ");
INSERT INTO sua_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","E Yesus ta patter o mia kun mnam E Nut ka maksien ka mhe to ko ma gi vle vop, to ka mnganang ngar te, “Nngia ko o pattermia kmo pos ngma grung orom Endo E Nut Thim Orom Ka Msasaen ka munik kam gia havae mang te, en a hipun to e Devit kaes? ");
INSERT INTO sua_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Enangthe npa mien te, a hipun to e Devit ka munik ta laut mang Endo E Nut Thim Orom Ka Msasaen ka munik, va kman ko e Devit mruo ta kvam Endo E Nut Thim Orom Ka Msasaen te, Kaldaip to en? Ko E Nunu A Totur ten o rhek mnam e Devit he e Devit ta rere vgum E Nunu A Totur kam havae mang Endo E Nut Thim Orom Ka Msasaen orom karo mur rhek mruo ruk endri te, ‘E Nut thavaeng Koldaip te, ngiak tuur mnam kua tavgo he korsang na, ko pa ngorsang to a miktiek, endo koma nho orom ko vanam dok kam ngae kais ko nguak kir kim ilaro imuo, yin kam karkar mang ngar hak.’ ");
INSERT INTO sua_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Vanang mu vokom na. Ma te, enangthe tennik, e Devit mruo tmur hover kaes to E Nut Thim Orom Ka Msasaen kam mrua mon te, ‘Kaldaip to en’ tok, va nngia ko o pattermia kmo pos ngam kaekon kim a hipun to e Devit karo rhek mruo kam le kmon Endo E Nut Thim Orom Ka Msasaen te, en gi kaes to mkor a hipun to e Devit?” E Yesus ta keknen ngang ngar tok va o mumu ho laol ruk ngta vle ko tok ngat ho mi kut svil hak kam ngan e Yesus karo rhek ko ngat mia mgae ngang ngar hak.” ");
INSERT INTO sua_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","To e Yesus ta patter mar kngae orom o rhek ruk endri kat te, “Mguak ngangreal ngang nguk mang o pattermia kmo pos ko mar ngam mrua hover mar mrua kam sreng orom o it ruk ngat ngae gia rarip ku he kpunpa ormar ko pum o mia ngaro kerok. Ii, va mar ngam mrua khenam mar mruo ma mmok ngang o mia ko po pnes, he nang o mia kam hover singni ngang ngar ko pum nglenar ngo kerok. ");
INSERT INTO sua_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Va mar ngma sovet kam mrua kakansgum mar mruo kam lol o ngorsang ruk o mia ngma nho orom mar ko mo pnes va endruk kun mnam o Yuda ngaro rektor ruk kam rere mnam mar kat. ");
INSERT INTO sua_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Va ngma kauyang o tahek he klikim mar kun mnam ngaro rektor mruo, nang kle klol o rektor ruk endruk ngang ngar mruo vat. Va ngam ngorom a hoger ngaro ngarkie khogerik ko pum o mia ngaro kerok, he nang klenar kam gia vokom mar tok to le kanprim mar. Ii, o mia ruk ngat kaenang o pattermia kmo pos tok, her endruk E Nut ner ho mi ktua monik kim o ho kapnes ruk lho vankue hak ngang ngar arhe kir kim o kapnes tgus hak.” ");
INSERT INTO sua_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","E Yesus ta vle kun mnam E Nut ka maksien vop to le korsang he ka nho rkieng ka ngaelpas, endo o mia ngma ngam ngaro nngiar ngang E Nut kun mnam. Ta vle ko tok he kvokom a mumu ko ngta mopatap kam ngam o krek kun mnam. Ii, tvokom endruk ngakro vu gol ko ngata sovet kam ngam ngakro krek laol kun ma ngaelpas to endo. ");
INSERT INTO sua_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Vanangko tvokom kat ko kela a tahek langto ko en ho mi kut nop o krek ngang hak ko ta kol kelo kre ruk lo svel he kpis to vrua ngam min kun ma ngaelpas kat. ");
INSERT INTO sua_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tvokong tok, to kvaeng kalngunes ko kim he khavaeng ngar te, “Kua mien ngang nguk te, a vlom to enda tngam ka nngiar kun mnam a ngaelpas tho mi kut kir kim o mia tgus ruk endri hak ");
INSERT INTO sua_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ko mar tgus ruk ngta nngiar ngang E Nut, ngat gia vethas orom ngakro vu gol ngarkero gi mhetor mnam mar ruk ka ho vuvurgem hak. Vanang a vlom to enda, ta kle ho mi ktua nngiar ngang E Nut orom kelo kre ruk ennginduk ko tmia rum kim ennginduk tre kpas kmin kmenkim o ol ngang ormin.” ");
INSERT INTO sua_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","E Yesus ther ottek kun mnam E Nut ka maksien to kalkayie langto ta kalpak kim o rektor ruk ngat eharom mar orom o krek he kngam a maksien to endo ormar. Ta re te, “Pattermia, vokom o krek ruk endri ngat sim kut tetgem mar kmeharom o rektor ri lvu yar hak.” ");
INSERT INTO sua_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Va e Yesus tkoripang te, “O rektor ruk lvu yar ruk endri ko muta vokom mar tete, koknaik nong ke vur kre tang hak mnam mar ner kais kam kta kru kuon mang kaela ngang kat e, ko o mia ngara pis kmemgetik tgus krum kim mar hak.” ");
INSERT INTO sua_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kam ngae, to e Yesus tkorsang kuo kim ke vul to e Olip to ngkun kut he ka nho rkieng E Nut ka maksien ko ta vle ku. To kalngunes ruk e Pita, e Yems kre Yoanes va e Andru ngata mnganang ko mar tuk te, ");
INSERT INTO sua_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ngola, havaeng ngor na te, mnam ani kolkha to msim ilaro rhek ngar kael mit mnam? Va a kolkha to endo karo ni ngaelmir ruk ngaka ktar kpis, he E Nut kmaottam ilaro rhek kat?” ");
INSERT INTO sua_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Va e Yesus ta kle khavaeng ngar mang a kolkha to a kser kim te, “Mguak ngangreal ngang nguk tete matok o mia ngara vraik ormuk petgim dok. ");
INSERT INTO sua_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ko ktar mang a kolkha to a kser kim kam pis, o mia kavurgem ngara pis he mur kaelel mar mruo orom kua munik. Ngara pis tok, he langto langto ner mrua havae mang en mruo te, her en arhe Endo E Nut Thim Orom Ka Msasaen. He enang tok, o mia ri la ppiagar ngara vraik orom o mia kavurgem. ");
INSERT INTO sua_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ii, va ktar mang a kolkha to a kser kim kam pis kat, mguera ngan o ngaus ngaro muktim va mguera lol o rhek pa nghek mang o ngaus kat. Pu tok, vanangko mguak ngangreal ngang nguk kam lua gor, ko o tgoluk ruk endruk ngaka ktar kpapagis mang a kolkha to a kser kim. Vanangko a mi kolkha to endo ngnok vop. ");
INSERT INTO sua_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ko o mhetor kavurgem va o serppak kavurgem ngaka ktar khop na, he kmo sir malngaeng ngar mruo na, he kmo kir mo kmar. Va a vang nera vle kun mnam o mhetor kavurgem va a koot naka khikher o marhok kavurgem klik kat. Ii, o ngaelmir ruk endri ngta vle te, a kolkha to a kser kim karo gi ngaelmir gi enang ko a vlom kalyie nam kaimim kmel a ngaelmir ngang te, ka kolkha to kam llues ta pis he. ");
INSERT INTO sua_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ii, mnam o kolkhek ruk o ngaelmir ruk endri ngak pagis, mguak ngangreal ngang nguk mruo ko o mia ngar kael muk ko maktiegom endruk ngma vongnek kim o rhek, va akuruk ngar kaimim muk orom a khap kun mnam o Yuda ngartaro rektor ruk kam rere mnam mar. He enang tok, mgua hera polger o rhek mang dok ngang ngar her ko tok arhe. Ii, va ngar kait muk ka srim muk ko kim o taven va ko kim a gavman ngalmialaol kat gi ekam ko mut kor mnam muk mang dok. He her mula venloot to arhe, muk kam polger o rhek mang dok ngang ngar. ");
INSERT INTO sua_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Enang tok, o vrong rhek tgus ngaka ktar kngan a knovvur na, to endo yek a kolkha to a kser kim nak pis. ");
INSERT INTO sua_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ii, o mia ngara srim muk ko pum mar enang tok, vanangko ktar mang tok, mguak or kam vua papat mang oni rhek ruk mguak polgerik mang dok ngang ngar. Ko oni rhek ruk mguak polgerik mang dok, E Nunu A Totur ner kle yek kaen o rhek ruk endruk mnam muk. Ko mnam ke venloot to endo msim her E Nunu A Totur to arhe ner mur kaelre ko vgum muk enang tok orom o rhek ruk endruk. ");
INSERT INTO sua_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ii, o mia ngar kaeharom tok ngang nguk, ko si o moornopeik mruo, va o motter mruo ge, ngar mur kael mar mruo ge maktiegom o mia kmim mar kngam mar o yoror. Va o ngnes kat ngar kle klaut mang ngaortek ngaornek kat kmel mar ko maktiegom o mia kmim mar kngam mar o yoror. ");
INSERT INTO sua_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","He enang tok, o mia kavurgem ngar kaelat muk ekam ko mut kor mnam muk mang dok. Vanang endo nak matnge vgum o vnek he kle kor mnam en mang dok ge, kngae kais mnam a kolkha to a kser kim msim, E Nut nera sulgim en he kaen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang.” ");
INSERT INTO sua_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“To mguera vokom E Nut ka imuo, endo nera likim o mia kun mnam E Nut ka maksien, ko nak pis ksir kun mnam E Nut ka maksien ko tok ko E Nut tlua tting mang en kam sir ko. (Vanang muk ruk muta him a hor ta, mgua sim ktua ngangam kmuk ekam o rhek ri na!) Ii, mnam a kolkha to muk ruk ko mYudea mgua re kvokom endo ko nak sir ko tok, va mguak ngoropok kgegerap ngoguon kio vlik. ");
INSERT INTO sua_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Va endruk ngta vle ku mnok ko ma ngoumi, ngak or hak kam kta vaik ngogun ma rek kam momlom kat. ");
INSERT INTO sua_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ta vle enang tok kat ngang endruk ngta vle ko gunkas ko ngak or kam kat kaeknik ngok mrek kam lol ngaro it kat. ");
INSERT INTO sua_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ii, va suvrum kekhengol ruk ngakro namtor va endruk ngat gia mmeng ngles vop mnam o kolkhek ruk endruk kat. ");
INSERT INTO sua_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","He ekam tok, mguak kaurur kim E Nut te, o kolkhek ruk endruk nga lua pis ko mnam a ven, he nang muk kam lua kar va ngaelaut ka gu kun ma kernonhommok to endo. ");
INSERT INTO sua_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ko mnam o kolkhek ruk endruk a kervavle alaut hak nera vle. Va a kervavle tang ko tennik ko E Nut ta kueng a mmie kngae kais mang tete, va si tang koknaik koknaik ner lo kaiser endo enda hak. ");
INSERT INTO sua_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Vanangko E Nut ner kait kokonor o kolkhek ruk endruk. Ko enangthe na re lo kait kokonor mang ngar, va nong a mhel tang hak to ner kais kam vle. Vanangko E Nut ner kait kokonor mang ngar, ekam ko ta pat mang kalngunes ruk tmur re pum mar kam vle ngang En mruo, kam hong ngar pum a kernonhommok to endo. ");
INSERT INTO sua_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","To enang tok, enangthe tang nak pis mnam o kolkhek ruk endruk he khavaeng nguk te, ‘Mu nho na, Endo E Nut Thim Orom Ka Msasaen enda he,’ i o ‘en tko gut ho,’ va mguak or kmor mnam muk mang o rhek ruk endruk. ");
INSERT INTO sua_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ko o propet ruk la ppiagar ngara pagis kar endruk ngara ppiak kmel mar mruo te, E Nut Thim Mar Orom Ka Msasaen. Ngar mia papagis orom o ngaelmir ruk kam reim sor mnam o mia kam mi ktua krong o mia ngaro vrongtok kam vraik orom kavurgem mnam mar. Va si endruk E Nut tmur re pum mar kam vle ngang En mruo kat, va o kermia ri ngar kaegom kam krong ngaro vrongtok he ka vraik orom mar kat, gi enangthe nga mi kais. ");
INSERT INTO sua_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yu! Ko hera havaeng nguk he mang a kolkha to endo karo ngaelmir ktar mang ngar kam pagis. He ekam tok, mguak ngangreal ngang nguk mang ngar.” ");
INSERT INTO sua_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","“Vanangko gi ko pekam a kernonhommok ko nera vle enang tok, E Nut nera rpem a volkha kakro serppak orom o ketor he ngara harapeet kun kuon kia gan va a kolkha nera tep. Va a kenho ner lo kta mmok kat e. ");
INSERT INTO sua_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","To endo yek, o mia ngar mia vokom A Mhel To Nkong Man Ma Volkha ko nera pis mnam o varhek orom kla saen va kla serppak. ");
INSERT INTO sua_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","To ner kle kmeng kakro engyel kam ngae mnam a mmie karo ngaitngol tgus kam kakaum endruk E Nut mruo tmur re pum mar kam vle ngang En mruo ngok matgiang kam ngae krurum a mmie karo ngaitngol tgus hak.” ");
INSERT INTO sua_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mu vokom a ho to a pik he kol a papat mang na. Ekam ko nam re kuur va mum hera mnor te, o, ka venloot to kmel rehi mnam ketasuo kam pis he. ");
INSERT INTO sua_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mare! Her gi enang tok kat arhe, ko mgua re kvokom o ngaelmir ruk endruk ko ngaka ktar kpapagis enang tok, va mgua hera mnor kat te, he ketasuo he A mhel To Nkong Man Ma Volkha en kam pis kat ko ngnok va ngaelaut ka gu he. ");
INSERT INTO sua_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ii, kua mien ngang nguk te, o mia nga main to enda tete, ngat lo kais kam yor vop kais ko E Nut naka ktar kaottam o ngaelmir ruk endri, mar kam pis pis lmien na. ");
INSERT INTO sua_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ii, a volkha kar a mmie nginera loloong, vanang kuaro rhek ngat lo kais kam loloong hak.” ");
INSERT INTO sua_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Vanangko a kolkha to a kser kim, nong a mhel tang hak to ta mnor mang ani marot to, i o ani vlemas to, i o ani kolkha to lsir A Mhel To Nkong Man Ma Volkha nera kser kim kpis mnam. O engyel ruk man ma volkha kat va si A Mhel To Nkong Man Ma Volkha to dok mruo kat ngot lua mnor mang ani kolkha to lsir kat e. Gi E Titou tuk to ta mnor. ");
INSERT INTO sua_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","He ekam ko a kolkha to enda nera pis pangnaom muk tok, va mguak ngangreal ngang nguk he sim kut kaelel kuo mang nguk mang kam paneng ko mut lua mnor mang a ni kolkha to msim nera pis mnam e. ");
INSERT INTO sua_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ii, a kolkha to A Mhel To Nkong Man Ma Volkha nera kser kim kpis mnam nera vle enang ko a mhel langto ta re kam ngae kpunpa ko ma mhe langto ko yok. Ko ta re kam ngae vanang ta ktar el karo reha ko maktiegom langto langto mnam kalngunes, nang kael tang ko va gudor kam nho mang ka rek. To mar ngata nho mang o reha ruk mkor ngalaip, nang en thera ngae kpunpa kun mnam a mhe langto ko yok. ");
INSERT INTO sua_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Gi kmikkiem enang tok kat, mgua sim kut kaelel kuo mang nguk he ktoot enang tok kat arhe ko muk kat mut lo smia mnor mang ani kolkha to a rek kteit nera kser kim kmeknik mnam. Mgua smia toot enang tok, matok nap sia kaeknik pangnaom muk ma segain, i o ma ho segain ka ngaenvurgem, i o ko a ngaining tkaeti, i o mo kao. ");
INSERT INTO sua_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Vanang suvrum muk ruk tkaeknik pangnaom muk ko mut hivuo kmonit he. ");
INSERT INTO sua_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A re ta ko hera havaeng nguk orom, ko kle khavaeng o mia tgus kat her enang tok kat te, mgua smia toot he kpaneng.” ");
INSERT INTO sua_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tie ma ngaelatong ko o Yuda ngma kunngir kim A Pnes To A Engyel Tvarpaam O Yuda Ngaro Molpou, endo ngma mon kat te, A Pnes To Kmem A Gi Bret, o pris ruk laol kar o pattermia kmo pos ngta vle he ka khanang ngar kam riring a papat tang te, nngia he o mia ngar kais kam vur kaol ma mmek he kol a hagie mang e Yesus kmim kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Vanangko ngat mo havaeng ngar te, “O-o ngruak or kmeharom ma pnes ta e, matok o mia ngara kaum kaen ekmor mang.” ");
INSERT INTO sua_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kam ngae, to e Yesus ta vle mBetani kun mnam a rek to mkor mhel to tkol a yor to a lepra tesgun. A mhel to enda ka munik e Saimon. E Yesus tkorsang ku mmie he khivuo kmemik, to a vlom langto tpis orom a ku to ngma mon te, a nat. Vanang a ku to endo ka keik to kmenkim te sei kam grap hak ko ngat eharom orom a ho to a nat ka kavgot ka ye va tlua movavaik kar a tomhel tang kat e. Va a ku to, ta vle kun mnam a kolhi to a kre to a alabasta ko o mia ngat hong mnam. To a vlom to enda tpis ko kim e Yesus, pet a kolhi to endo ka keik to ka glot malpgem. ");
INSERT INTO sua_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","To o mia akuruk ko tok ngat hera vokom a vlom to endo, to ngaro vurkul ngat ngae sei kam kiin hak to ngata mo reng ngar mruo te, “Kman ko a vlom ta tgia koham a ku ta ti e? ");
INSERT INTO sua_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ko en tis kmel ngang o mia, ngar kmenkim mkor ko ka keik te sei kam grap he npa lol o krek kavurgem hak to le kaenik ngang endruk ngta tu kmo tgoluk.” Ngta mo havaeng ngar tok, to kle ka psom a vlom orom o rhek akuruk kat. ");
INSERT INTO sua_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Vanangko e Yesus ther le kaekon ngang ngar te, “Mu orim! Mut lo kais kam rere pum a vlom to endo tok e! Ko en teharom a keknen to tho mi kut ya hak ngang dok. ");
INSERT INTO sua_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mguak orim ko tok, ko endruk ngma tu kmo tgoluk ngara vle mo kmuk lhok ge he muk kam turang ngar kmikkiem mularo svil. Vanang dok, ngor lo kta vle mo kmuk lhok kat e. ");
INSERT INTO sua_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A vlom ta teharom kta ngaeha to kmiser en mruo ge, ko ta glot a ku to endo kuo malpgem dok tok. He enang tok, tkael a lte ormok kam pungnim kua vok enang tok arhe, mar kmeguyang dok he. ");
INSERT INTO sua_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kua havaeng nguk lmien te, mnam oni mhetor tgus ruk mo mmie ko o mia ngak polger o rhek ruk mang a knovvur va o mia ngar kta havae mang a keknen to a vlom ta teharom ngang dok tete, o mia kam kuvi mang kat kam vokong en orom.” ");
INSERT INTO sua_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","To gi mnam a kolkha to endo gi, ngaela langto mnam o aposel ruk loktiek hori orom alomin ka munik e Yudas, endo nkong mIskariot thera ngae ngok kim o pris ruk laol kmel ka papat to kam hortgi mang e Yesus he kael maktiegom mar. ");
INSERT INTO sua_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ngata ngan e Yudas karo rhek to ngata sei kam sirei alaut mang. To ngat kaenserpgam ka papat to kmenkim orom o krek. To e Yudas ther kaelha kam vur kael onit ngang e Yesus en kam mas orom he kael ko maktiegom mar. ");
INSERT INTO sua_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kam ngae, to tie ma palngaem, o Yuda ngam kaem a pnes to ngma mon te, A Gi Bret. Vanang mnam a pnes to endo ngam kaim o sipsip ruk o sital kam mur kael pat kim mar mruo mang ko a engyel tvarpaam o Yuda ngaro molpou ruk tennik. To e Yesus kalngunes ngat kaol ngok kim to ka mnganang te, “Ngola, ya svil mang ngor kmelel mo kim o olngaemik mnam ani mhe to, yin kam kunngir kim a kolkha to A Engyel Tvarpaam O Yuda Ngaro Molpou?” ");
INSERT INTO sua_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","To e Yesus thera meng klo kaloyie aloruk he khavaeng ngin te, “Meak ngae mYerusalem he mera horong a ngokol langto ekam a ngaelaut ko tiniram ka ye he ktolpum ngok mrek. Mea her kaikkiem her endo arhe ");
INSERT INTO sua_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ngok mnam ani rek to nak vaik mnam. Meak pis khavaeng a rek kteit te, ‘E Pattermia ta svil kam kunngir kim a kolkha to A Engyel Tvarpaam O Yuda Ngaro Molpou kar kalngunes. Va ta svil kam mnganang yin te, ila taban to mkor o gunmia nam, mor kmelel mo kim o ol kun mnam?’ ");
INSERT INTO sua_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Meaka mnganang tok, yek en ner mrua khenam ka rek ka taban to kuon mail ko ngat pasrengem he sim elel o ngorsang va a psen kun. To mea her kaelel o ol ko mnam a taban to arhe.” ");
INSERT INTO sua_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Te smia papsim min tok knop, to ngint hera ngae to kpis mang a mhel to endo her sim kut enang ko e Yesus tpapsim min tok arhe. To ngint her kaelel mo kim o ol ko tok, mar kam kunngir kim a kolkha to endo. ");
INSERT INTO sua_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ngint kaelel mo kim o ol knop, to a kolkha ta vaik he, to e Yesus kar kalngunes ruk loktiek hori orom alomin ngata ngae kpis kun ma rek to endo, to her korosang kam her kaemik he. ");
INSERT INTO sua_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ngat korosang he khivuo kmemik, to e Yesus thera havaeng ngar te, “Kua mien ngang nguk te, langto mnam muk ruk mut kaemik kar dok tete nera hortgi mang dok.” ");
INSERT INTO sua_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tre tok, to kalngunes ngate sei kam mrua mrung ngar mruo hak. To langto langto mnam mar tkaelha kam mnganang te, “Ngoldaip, nok ya re mang dok vor?” ");
INSERT INTO sua_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Va e Yesus tkoripang ngar te, “A mhel to ta vasgem ka bret ka mhe kun ma plo kar dok, her endo mnam muk ruk loktiek hori orom alomin arhe nera hortgi mang dok. ");
INSERT INTO sua_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ii, nera hortgi mang dok, gi enang ko A Mhel To Nkong Man Ma Volkha nak yor kmikkiem gi enang ko E Nut karo rittiek ngata ktar khavae mang tok. Va si enang tok, suvrum kela to nera hortgi mang dok, ko tmi ya hak enangthe knan nap lo kol. Vanangko tho mi kut kernonho hak ko knan tkol he, ko nera kol a kapnes vgum E Nut pum ka kerkeknen to endo.” ");
INSERT INTO sua_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Phevgom e Yesus kar kalngunes ko ngata hivuo kmemik, e Yesus thera kol a bret langto to kanprim E Nut mang to kommen he kaisis kim kalngunes to kreng ngar te, “Mgua kol a bret ta. Kua vok ta arhe.” ");
INSERT INTO sua_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","To ther kle kol a kolhi orom a ye to a vaen vat he kanprim E Nut mang to kaen ngang kalngunes to mar tgus ngat ivie mnam. ");
INSERT INTO sua_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","To treng ngar te, “Kua gidiel ta arhe to nera ksuk mang o mia tgus, endo E Nut ta sir malpgem kmel ka mokpom kar o mia orom. ");
INSERT INTO sua_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ii, kua mien ngang nguk kat gi te, kmelha tete, ngor lo kat kaiviem a ye to a vaen ta kar muk kat e, kam ngae kais ko ngurer kta kaum kat kmiviem endo a gunngar vat kam tuur mnam E Nut ka pnes to orom endo nera kpom mnam a kolkha to ka tavgo nak komor o mia tgus.” ");
INSERT INTO sua_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ngat kaemik knop, to kael a kni langto to her kottek to ka grap ngoguon kim ke vul to e Olip. ");
INSERT INTO sua_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","To ko tok kia vul to e Olip, e Yesus thera reng kalngunes te, “Muk tgus mguera kpom klaem petgim dok kmikkiem enang ko E Nut karo propet ngta ktar kaittiek mang nguk tok gi te, ‘E Nut nera tgem o sipsip ngar teit he ka valngan to orom o sipsip ngara ngorpok petgim.’ ");
INSERT INTO sua_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Vanangko ko pekam ko E Nut nak hover dok petgim kua nnak, ngora ktar mang nguk kam ngae ngok mGalili.” ");
INSERT INTO sua_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","To e Pita thera hop ku he koripang te, “Dok ko ngae ho lo kais hak kam ngorpok parem yin e. Si enangthe kolenar tgus ngak ngorpok parem yin vanie, vanang dok nove!” ");
INSERT INTO sua_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Va e Yesus ta kokheng e Pita kam reng te, “O-o, Pita kua mien ngang in te, gi ngka masegain ta, ktar mang a ngaining kmeti ngira klai mang dok kngam ngkorlotge te, yi lua mnor mang dok.” ");
INSERT INTO sua_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Va e Pita tkut kaesik he kaur gi kmoripang te, “Si enangthe ngua ngae sia yor kar yin va kho lo is hak kam klai mang in e.” To e Yesus kalngunes tgus ngata kol vgum e Pita kam reng en tok kat. ");
INSERT INTO sua_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","To e Yesus kar kalngunes ngata ngae kvaik kun mnam a loot to ngma mon te, e Getsemeni. To e Yesus thera reng ngar te, “Mguak korsang mo na, nang dok ngora ngae he kngarkie.” ");
INSERT INTO sua_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","To ther gia nglum e Pita va e Yems kre Yoanes, to endo he, a vnek alautar hak tkaelha kam kerngorom ko karo papat ngat ho mi ktua kervavle hak. ");
INSERT INTO sua_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","To thera reng ngar te, “O-o, a mamrung a ho lautar hak tho mi ktua kokol dok he. He tre kmim dok, kngam dok hak. He ekam tok, mgua gia vle mo he kaennei he ktoot.” ");
INSERT INTO sua_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tre tok, to her vur kael a long mang ngar to ka kru ka vham oguon mmie to kngarkie ngang E Nut te, enangthe ka papat ngang ngnok vop, va nak pet ke longmok to tre kam kol, endo orom la vut to orom ka yor. ");
INSERT INTO sua_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tngarkie ti te, “Yoko dok gi, Titou-o, ilaro papat ngat kais mang o reha tgus yin kmeharom mar. He ekam tok, ngia pet la vut to enda orom kua yor to tre kam kol dok vanie. Vanangko ngior kam kokol ekmok e, ngiak kle va kaikkiem ila svil mruo ge.” ");
INSERT INTO sua_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tngarkie tok knop, to her kaeknik ngok kim kalngunes ruk korlotge he kvotgem mar ko ngat her onnit he. To treng e Pita te, “Ngola, nngia orom muk korlotge, he mut lo vur kais kam vur kaennei he ktoot gi? ");
INSERT INTO sua_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Vanang mguak mrua toot mang nguk mruo he kngarkie, muk kam lo mrua ngam muk ekam o kerkeknen ruk ngam kaegom muk. Ko muma serppak mang kmikkiem mularo svil ruk kmeharom o keknen ruk lyar, vanangko mularo pkor ngaro svil ruk ngam kaenen muk kmeharom o kerkeknen ngam kle khos kim mularo svil ruk kmeharom o keknen ruk lyar.” ");
INSERT INTO sua_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","E Yesus treng ngar tok, to ther kta parem mar kat kngam nglomin kam kta votam karo ngarkie ruk kat ge. ");
INSERT INTO sua_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ta kta ngarkie tok knop, to her kat kaeknik ngok kim kalngunes va pis gi kta votgem mar kat ko a kenap alautar te ho kvurvrum mar hak he ngat ho ngae onnit ngae hak. Va ngat hop, nang gia vongnek kim ko nop o rhek ngang ngar kmoripang e. ");
INSERT INTO sua_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","To ta vle tok kat kam ngam ngkorlotge mang kalngunes ko ther kaeknik kpis mang ngar to her kta votgem mar kat he kreng ngar te, “Ngola, mut le kaol kam pis sim konit vat? Tis he, ko her ke longmok ta arhe ngang endo kam hortgi mang A Mhel To Nkong Man Ma Volkha kmel dok maktiegom o mia ruk ngam kaeharom o kerkeknen. ");
INSERT INTO sua_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mu hohop he, he mu sor kim na. A mhel to kam hortgi mang dok, enda he. So mor he ngor khorong.” ");
INSERT INTO sua_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","E Yesus ta rere vop, nang endruk loktiek hori orom alomin ngaela langto mruo to e Yudas, tkaol orom a rkan langto ko ngata pis ko kim e Yesus he. Ngta pis orom ngakro komtok va ngakro kier ko o pris ruk laol va o pattermia kmo pos va o Yuda ngalmialaol ngat her meng ngar enang tok arhe. ");
INSERT INTO sua_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Vanang endo thortgi mang e Yesus ta ktar keknen ngang ngar mang a ngaelmir to mar kam mnor mang ko ner pis kaeharom ngang ko thavaeng ngar te, “Mguak vokom dok ko endo ngua pis ko kim he vrua pum ka volha kam mrung tok, va her endo arhe. Mguak marer kpis to kpuung mang he kapom ktoot mang kam ktong kngorom.” ");
INSERT INTO sua_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","To endo he, e Yudas ther gia ngae lsir rkieng e Yesus to hera kvam te, “O, Kolaip.” va vrua pum ka volha kam mrung enang tok. ");
INSERT INTO sua_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","To a rkan to endo ta murmur mang e Yesus koleng singni mnam he kapom. ");
INSERT INTO sua_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngata kapom, va vgum e Yesus kalkayie langto ta sir ko vanam e Yesus ko ther gi kait ka kom ku her gia ngam mang o pris ruk laol ngalaip kalkayie langto va her gi kser ka ngaela ka pun kpet hak. ");
INSERT INTO sua_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Vanang e Yesus ta le kreng a rkan te, “Ngola, nok pathe mut vua kokho orom o komtok va o kier kngae mang dok kam kapom dok enangthe dok a mhel to koma kaenpgam o mia kam kaum kaen ekam lRom he kaus kar mar vor? ");
INSERT INTO sua_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Vanang mo kolkhek tgus kom her gia patter o mia ma mmok ko mnam E Nut ka maksien, va mum lua re kam hera kapom dok ko tok? Vanangko mguaka kapom dok vanie, ko E Nut nak kaottam karo rittiek, mar kam pis lmien kmikkiem gi enang ti arhe.” ");
INSERT INTO sua_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","E Yesus ta rere tok knop, to kalngunes tgus ngat hera ngorpok kparem. ");
INSERT INTO sua_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Vanangko kalkayie langto tgia kokomor orom a gi yet tuk to ka keik ta grap, ta pepem mar orom e Yesus. He a rkan ngat re ka kpom en kat, ");
INSERT INTO sua_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","vanangko ngat gi kpom ka yet khalger kuo mang to tgia ngorpok a gi mit, vanang ngat gi kpom mar ko a gi yet. ");
INSERT INTO sua_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","E Yesus kalngunes ngta ngorpok kparem to a rkan to ta koleng singni mnam e Yesus ngta ktong kngorom he kael ngok kim o pris ruk laol ngalaip kun kuo mnam ka ngoulu to klalaut ka taban to ku mnok ko ma gi vle ko tok mnam E Nut ka maksien. Nang o gi vrong mia ngat gia vle ku klangtar orom. Ngat el ko tok kun kuo mnam a ngoulu to klalaut to endo, to o pris ruk laol tgus va o pattermia kmo pos kar o Yuda ngalmialaol ngat kaum kam ngan o rhek mang. ");
INSERT INTO sua_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Vanang e Pita tgi vrua pepem mar kngae orom e Yesus gi kam ngae kais ko ngata vaik kun mnam o pris ruk laol ngalaip ka rek ka mhe to ku mnok ko ma gi vle. To ther pis kvaik korsang kar endruk ngma toot mang a rek kam kuk pa paei. ");
INSERT INTO sua_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","To o pris ruk laol va si o Yuda Ngar Ke Murgun tgus, endo nma vongnek kim o rhek ngat kaim o papat kam pis mang o mia akor kam ngam o rhek ko lserpgue kam rere kim e Yesus ormar, nang lRom kmim kngam a yoror. Vanangko ngat lo vur pis mang tang ko karo rhek ngata serppak is e. ");
INSERT INTO sua_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ii, ko o mia kavurgem ngat sia ngam o rhek kam ppiak mang, vanang ngaro rhek ngat lo maenang e. ");
INSERT INTO sua_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kam ngae, to endo he, o mia akuruk ngata hop he kngam o rhek ri kam ppiak mang te, ");
INSERT INTO sua_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ngota ngan a mhel to enda ko thavae te, ‘E Nut ka maksien ta o mia ngat hover orom ngaro singni mruo, ngora lget he lo hus kam kta hover langto yok vat kun mnam o kolkhek ruk korlotge, a mten to o mia ngat lo kais kam hover orom ngaro singni e.’” ");
INSERT INTO sua_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ngata havae tok, vanang si o mia ruk endri va ngaro rhek ngat lo maenang kmis kmenserpagam a re tang kmim kngam a yoror e. ");
INSERT INTO sua_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","To o pris ruk laol ngalaip thera sir kun pgegom mar tgus to ka mnganang e Yesus te, “Ngola, ya ngan o rhek ruk ngat kaelik kuo mang yin va nop o rhek ngang in gi kmoripang ngar?” ");
INSERT INTO sua_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Vanangko e Yesus tlua svil kmekon ngang e, ther gi sir kvongnek kim. To o pris ruk laol ngalaip ta tger e Yesus kam kta mngan kat te, “Lmien mang in te, Endo E Nut Thim Orom Ka Msasaen her yindo arhe, i o nop gi? Va E Nut To Nma Ngamyammok Mang O Mia, Khal to yin, i o nop?” ");
INSERT INTO sua_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Va e Yesus tkoripang te, “Mare, her dok ta arhe. Va kua havaeng in te, kmelha tete kngae ngnik ngnik, mguera vokom A Mhel To Nkong Man Ma Volkha ko ner korsang ko mnam E Nut To La Vu Ngaurar Hak ka miktiek. Va mguera vokom kat ko nera kaol kpis kun kuon ma volkha orom o varhek.” ");
INSERT INTO sua_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","O pris ruk laol ngalaip ta ngan ko e Yesus ta re tok, to thera hop ekam karo it to kommenik kam polger ka ngaesik, to kre te, “Ngrua lo kat kais kam kta vae mang o mia akor kam pis kam ngam o rhek mang kat e, ");
INSERT INTO sua_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ko muk mruo mut mur ngan ko ther mur kerrereng E Nut orom karo mur rhek mruo enang tok arhe. Va muta pat nngia? Mguer kael ani vnek to kuo mang e?” Va ngat monik kim a yor ngang ko ngat koripang te, tho mi kut is mang en, mar kmim kngam a yoror hak. ");
INSERT INTO sua_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","To akuruk mnam mar ngat kaelha kam guguspa mang to ka kleng kalo keik kam tokim min, en kam lua nho, to khim singni malpgem he kreng te, “Yindo a propet ngola, ngiak mon edim mnam mor ko tim yin!” Ngat eharom tok, to o toot kmo mia ngata kta him singni malpgem kat. ");
INSERT INTO sua_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","E Pita ta vle ha ku mnok vop kun mnam o pris ruk laol ngalaip ka ngoulu to klalaut ka taban to ku mnok ko ma gi vle, va a vlom langto nam kaeha ko tok tgi kaol ngok kim he ");
INSERT INTO sua_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","kpis vokong ko ta kuk pa paei. Te smia kellu mang ka mnor to kreng te, “Yinda kat arhe im kaikkiem e Yesus to nkong mNasaret kat.” ");
INSERT INTO sua_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Vanangko e Pita ta klai mang te, “O-o, klua mnor mang a papat to ya rere mang. Klua mmok mang ilaro rhek e.” To e Pita te vrua kle ngogu va gudor ngku mnok va vgum a ngaining ko tkaeti. ");
INSERT INTO sua_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","To a vlom to nam kaeha ko tok, ta kta vokom e Pita kat, to kle ho gi kaur ge he kreng endruk ngta sisir ko rkieng kat te, “Mare, a mhel ta, her kalkayie langto arhe!” ");
INSERT INTO sua_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Vanangko e Pita ta kta klai mang kat. Ngat vrua vle, to o mia akuruk ngta sisir ko rkieng ngata kta reng e Pita kat gi te, “O, lmien hak he, kalkayie langto yin arhe, ko yindo nkong in mGalili kat.” ");
INSERT INTO sua_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Va e Pita thera koripang ngar he mur kael a lte mang en mruo te, “Yu! Enangthe nguaka ppiak va E Nut nak kaim dok kngam dok a yoror. Kua havaeng nguk te, klua mnor mang a mhel to muta rere mang e.” ");
INSERT INTO sua_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ta rere vop va vgum a ngaining ko tkaeti kngam nglomin. Tkaeti, yek e Pita ther gia pat mang e Yesus karo rhek ruk ta ktar kpavap mang en ormar te, “Ktar mang a ngaining kmeti kngam nglomin, ngira klai mang dok kngam ngkorlotge te, yi lua mnor mang dok.” E Pita ta pat mang o rhek ruk endruk to her gia polger karo reti laut he. ");
INSERT INTO sua_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kam ngae, to hop tie marot msim o Yuda Ngar Ke Murgun to nma vongnek kim o rhek, endruk tgus o Yuda ngalmialaol, va o pris ruk laol va o pattermia kmo pos ngat kaum he ka lgem o rhek, lRom kmim e Yesus kngam a yoror. Ngat eharom tok knop, to ngat kaussiem e Yesus kalo ktiek to her kottek orom kun mnam E Nut ka maksien he ka ktong kngorom kmel ko maktiegom e Pailet, endo lRom ngat el kam nho mang lYudea. ");
INSERT INTO sua_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","To e Pailet thera mnganang e Yesus te, “Ngola, O Yuda Nga Taven msim to yin arhe?” Va e Yesus tkoripang te, “Yin mruo yi her ngae rkieng dok orom a re to endo!” ");
INSERT INTO sua_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Thavae tok, to o pris ruk laol ngat kael o rhek kavurgem kuo mang. ");
INSERT INTO sua_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","He ekam tok, e Pailet ta kle ka mnganang te, “Ngola, ya ngan o rhek kavurgem ri ngat kaelik kuo mang yin va nop o rhek ngang in gi kmoripang ngar?” ");
INSERT INTO sua_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Va e Yesus tlo kta svil kmoripang en kat hak. He ekam tok, e Pailet te sei kam mrua sor mang he. ");
INSERT INTO sua_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vanang mnam a pnes to endo ko o Yuda ngma kunngir kim mo pnes tgus, o Yuda ngalaip ko en a Rom, nam kaikkiem a keknen to kam hong a mhel tang kun mnam a hengor, en kmeknik ngok kim o Yuda, ko o Yuda mruo ngam mrua mon ngang lRom, mar kam hong petgim a hengor. ");
INSERT INTO sua_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Va mnam o kolkhek ruk endruk lRom ngat el a mhel langto ka munik e Barabas kun mnam a hengor kar klenar ruk ngat kaenpgam o mia kam kaum kaen ekam lRom he kaus kar mar. He en tim a mhel langto kngam a yoror kun mnam a kolkha to o mia ngat kaus kar mar. ");
INSERT INTO sua_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","To o Yuda ngat pis kaum ko kim o Yuda ngalaip to e Pailet, va e Pailet thera mnganang ngar kam mon a mhel tang ka munik kmikkiem a keknen to endo kam hong a mhel langto ngok kmar mo pnes tgus. ");
INSERT INTO sua_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","E Pailet ta pe gia mnganang ngar te, “Yu! Muta svil dok kam hong muk ruk O Yuda Mula Taven ngok kmuk?” ");
INSERT INTO sua_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ta pe gia mnganang ngar tok, ekam ko ta mnor mang lYuda ngalmialaol ko ngam kaesik ngang e Yesus, he ekam tok, ngat kael ko maktiegom mruo. ");
INSERT INTO sua_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Vanangko o pris ruk laol ngat kaenpgam a mumu kam kle va ka mnganang e Pailet kam hong e Barabas ngok kmar. ");
INSERT INTO sua_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","To e Pailet ta kta mnganang ngar te, “Vanang ngua kanker e Yesus, endo o mia ngma mon te, O Yuda Nga Taven?” ");
INSERT INTO sua_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Va ngat koripang te, “Krong orom o ot kvat engnang a ho!” ");
INSERT INTO sua_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","To e Pailet ther kta mnganang ngar te, “Kman? Muk mruo mguaka ktar khavae mang ani kerkeknen to msim teharom!” Vanangko a mumu ta kle va ho gia vui klik hak te, “Krong orom o ot kvat engnang a ho!” ");
INSERT INTO sua_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","He ekam ko e Pailet ta svil kmel longeik ngang a mumu, ta le khong e Barabas ngok kmar, nang kreng a rkan kam kirmekon a khap mnam e Yesus. Ngat pis kirmekon a khap mnam knop, to e Pailet ther kle kael ko maktiegom endruk ngma kar va tomten, mar kam le ka krong orom o ot kvat engnang a ho. ");
INSERT INTO sua_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","To endruk ngma kar va tomten ngta ktong e Yesus he kpis kvaik orom kun mnam a ngoulu to klalaut to mkor lRom nga ngaomevek ngalaip. To ngat hera vaeng nglenar tgus ruk kun mnam nga rkan to endo kam kaum ko kim kat. ");
INSERT INTO sua_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","To ko tok, ngata kaum to hera kuit pum, nang kle kaegenkar vat orom a yet to a svel, enang endo o taven ngam kaegenkar. To ngat hera lum a vlak he ka llim kuon malpgem. ");
INSERT INTO sua_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","19","Ngat eharom tok, to langto langto mnam mar ngat kaelha kam tubulkek ku penharom to kpetpet o rhek ngang kam klel orom kam reng te, “O Yuda Nga Taven to yinda arhe!” Va ngata him a khap palpgem va kguspa mang kat. ");
INSERT INTO sua_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ngat klel orom tok knop, to ngat le khong a yet to endo, nang kle kat kaegenkar orom kta yet mruo. To ngat hera ktong kngorom kngae ka krong orom o ot kvat engnang a ho. ");
INSERT INTO sua_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ngata ktong kngorom e Yesus ekam a ngaelaut, to ngta ting kim a mhel langto ko tottek ko ma lootpgeik he kaeknik ngok mrek. A mhel ta ka munik e Saimon to nkong mSairini. En e Aleksanda va e Rupus ngin teit. Tottek ko ma lootpgeik he re kmotter mar, vanang endruk ngma kar va tomten ngat hera kol a hagie mang kam sopong en kam tolpum e Yesus ka ho to kmoreker kuon. ");
INSERT INTO sua_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","To ngta ktong kngorom e Yesus to kpis ko mnam a mhe to ngma mon te, e Golgota. (Vanang a munik to e Golgota, ka pun ta vle te, “A mhe to ta nho enang a mhel ka lpek ka kolhi.”) ");
INSERT INTO sua_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","To ko tok ngat kol a ku langto ngma mon te, a miir, endo ngat eharom orom a ye to a vaen ka mten to ngat mo vavaikar kar a lkiet ka ye langto to le kaegom kmen ngang. Vanangko tlo iviem e. ");
INSERT INTO sua_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Tie marot vop, va endruk ngma kar va tomten ngata krong e Yesus orom o ot kvat engnang a ho ko tok. “To ngat le ka khanier kam kir mo kmar kam mnor te, edim mnam mar kam kol langto langto mnam karo it. To ngat kaisis kim karo it enang tok.” ");
INSERT INTO sua_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Va kuo malpgem ko engnang a ho ngat el o rhek ruk ngta mon en ormar te, ");
INSERT INTO sua_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Vanang, ko vanam e Yesus ngta krong alo ngauruvik aloruk orom o ot kvat min ko engnang ngintalo ho kat. Langto ko vanam ka miktiek va langto ko vanam ka ksienga. ");
INSERT INTO sua_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Gi enang tok, E Nut karo rittiek ngat pis lmien orom e Yesus ko ngat havae te, “En nera kol a kapnes to o ngauruvik ngma kol enang tok kat.” ");
INSERT INTO sua_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nang o mia ruk ngam kaol ekam a ngaelaut ngam kaol va ngma kirhek ngang e Yesus he kaerer ngaro lpetuk kim he ka klel orom te, “Oho! Yindo ima havae te, ngira lget E Nut ka maksien he gi kta hover mnam o kolkhek ruk korlotge, her yinda arhe? ");
INSERT INTO sua_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Te yin he, mur sulgim yin mruo ko tok he grung ngku kuon petgim a ho to ngata vat yin ko engnang.” ");
INSERT INTO sua_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Va o pris ruk laol kar o pattermia kmo pos ngta kol a klel orom gi enang tok kat kam mo reng ngar mruo te, “Te en nma sulgim o mia akuruk, vanang kman ko tlo kaeharom ngang en mruo tok? ");
INSERT INTO sua_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","He nong lIsrael Nga Taven to en gi? Va enangthe lmien te, en Endo E Nut Thim Orom Ka Msasaen msim, va npa grung ngku kuon petgim a ho to endo ko pum nguaro kerok, yek ngrera kor mnam mor mang en vgum tok.” Va si alo ngauruvik ruk ngta krong ngin orom o ot kvat min engnang nginalo ho ko vanam e Yesus kat, va min tgus nginta kirhek ngang gi enang tok kat. ");
INSERT INTO sua_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pkolkha vop, va vgum a slommok ko ther gi pis pgeik komor a volkha va a mmie tgus kngae kais ma vlemas. ");
INSERT INTO sua_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","To rkieng ko a slommok tre kam nop ma vlemas, E Yesus ther kael ka ktui orom ka re mruo te, “Eloi, Eloi, lama sabaktani.” To kam hortgem ka re to endo ka pun ta vle te, “Nut-o, Nut-o, yindo kom kor mnam dok mang in, kman ko ya ksir petgim dok?” ");
INSERT INTO sua_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Vanang o mia akuruk ngta sisir ko tok, ngta ngan ko thavae tok, to ngata havae te, “Mu vokom na, ta munik kim e Elaisia vor.” ");
INSERT INTO sua_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","To langto mnam mar ther gia hop ku he ksap kvasgem a paspas kun mnam a ho ka ye to tngae gia gruk, to ta kleng ko vgum a kerker he kngae ktuom ngok vgum e Yesus te, en kmiviem. To thera reng klenar te, “Ngruak or na, he ngor kam vokom te, e Elaisia ner mi kaol kpis kam sulgim he khong kuon petgim a ho to endo, i o nop.” ");
INSERT INTO sua_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","To e Yesus tkat kael ka ktui klik kat gi to ka ngaung thera mtiet he. ");
INSERT INTO sua_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tyor tok, va vgum a yet to nam kaeltoot mang E Nut ka maksien ke rek Ka Taban To A Ho Totur Hak ko ther gi kommenik kam ngam ko vgum kalo gu tgus he kael kalo kae alomin. ");
INSERT INTO sua_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","To lRom nga ngaomevek ka rkan langto kalaip tvokong ko E Yesus tyor enang tok, to thera re te “Ai, ho mi kut lmien hak he, a mhel to enda her E Nut Khal Msim ta arhe.” ");
INSERT INTO sua_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Vanang lraip akuruk kat, endruk ngata mokpom kar e Yesus ko mGalili he kaikkiem kmelha kaeha vgum ko tok, mar ngta vrua sisir ko vur hagenmok mang he ka vle kvokom mar orom. Lraip ruk, ngta sisir ko tok, mar e Maria to nkong mMagdala kar kyok e Maria to e Yoses to a molpou va knopia to ta knaek mang e Yems ngin nan. Va e Salome ta vle ko tok kat kar lraip kavurgem ruk ngat kaikkiem e Yesus oguo mYerusalem. ");
INSERT INTO sua_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nangko ma kolkha to endo ko ngata krong e Yesus orom o ot kvat engnang a ho ta vle te, a kolkha to o Yuda kmelel mo kim o tgoluk kam paneng a Sabat ko ketasuo en kam vuut. To a kolkha tre kam vaik, ");
INSERT INTO sua_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","va a mhel langto nkong mAramatea ta vle. Ka munik e Yosep. En nma paneng Endo E Nut Thim Orom Ka Msasaen kam pis kat he ka tavgo kam komor o mia tgus. Va nam kaeha kar o Yuda Ngar Ke Murgun to nma vongnek kim o rhek kat va o mia ngma totu pum. E Yosep tpat mang a Sabat kat he karo krovek ngta ngae kun mnam en mruo kam ngae ngok kim e Pailet kam mnganang mang e Yesus ka mnes en kam kol he kael. ");
INSERT INTO sua_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","To e Pailet ta senkrip kim e Yosep ka mngan ko tlua mnor mang e Yesus te, tmi yor, i o nop vop. To e Pailet tle kvaeng lRom nga ngaomevek ka rkan langto ngalaip. Tpis to e Herot ta mnganang mang e Yesus te, “Tmi yor he, i nop vop?” ");
INSERT INTO sua_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tkol a re vgum endo te, ther mi yor he, to ther le ka tting mang e Yosep ka mngan. ");
INSERT INTO sua_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","To e Yosep ta ngae kaenkim a yet to ka keik tvua grap he kngae kharpeet e Yesus ka mnes kuo va ho, to le kokomor orom. To thera kokol kngorom to kael kun mnam ka nnak to ngat gi gnua hong mnam a kre he lo el a mhel ka mnes tang kun mnam vop. Tkael knop, to hera vulham a kre to klalaut ko va kre ka nho ka gu kmelegot orom. ");
INSERT INTO sua_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Vanang e Maria to nkong mMagdala kar kyok e Maria to e Yoses knan nginta vle he kvokom e Yesus ka nnak ko ngat vokom e Yosep ko tel e Yesus ka mnes kun mnam! ");
INSERT INTO sua_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","To a Sabat ther nop ko a kolkha ther vaik he, to e Maria to nkong mMagdala kar kyok e Maria to e Yems knan va e Salome mar tgus ngta kaum kngae he kaenkim o ku, mar kam ngae he kpungnim e Yesus ka mnes orom mar. ");
INSERT INTO sua_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","To hop enang ngmo ma Sande, lraip ruk endruk ngata hop halkie tie mo kao, to kngae ngok pe Yesus ka nnak. Ngta pis ko pa nnak va a kolkha tgi gnua plek. ");
INSERT INTO sua_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ngat kaikkiem a ngaelaut to hera mo mnganang ngar mruo te, “Erieto nera vulham a kre kam koregot kim mor?” ");
INSERT INTO sua_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ngta mo mnganang ngar tok, to re kvokom a kre ka nho, va vgum a kre to tvu laut hak, endo ngat elegot kim e Yesus ka nnak ka gu orom, ko tollok he kvulhi he ka vle petgim a nho he. ");
INSERT INTO sua_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","To ngat pis re gia vavaik ogun ma nho va le gi vokom a ngokol langto ko tvaik pum ka yet to ta les he korsang kun ma nho ka ngaiting to a miktiek. Ngat vokom tok, to ngaro ngaongtok ngta ksir. ");
INSERT INTO sua_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Vanang a ngokol to endo ta reng ngar te, “Mu or kam ngaungput e. E Yesus to nkong mNasaret, endo ngat krong orom o ot kvat engnang a ho, mut sia riring moti, nangko en nong mo e, ko ther hop petgim ka nnak ta he. Mu aol ngte he vokom ka ngaekam to ngat el mnam na. ");
INSERT INTO sua_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ii, mu or kam gia sir ko tok he kgor, vanangko mguak kle va kngae smia papsim kalngunes, va si e Pita kat, va mguak smia papsim te, ‘En nera ktar mang nguk kam ngae ngok mGalili. He her ko tok arhe mguer kta vokom kat, kmikkiem gi enang ko ta ktar mur havaeng nguk gi enang tok arhe.’” ");
INSERT INTO sua_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ngata ngnek tok, to ngaro nunu ngat ngae ho mi kut parem ngaro mit hak va ngaro pkor ngat kaelha kam khi. To ngat hera marer kngorpok petgim a nnak to endo, nang ngae lua havaeng a mhel tang mang, ko ngata gor. ");
INSERT INTO sua_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Va mnam a kolkha to a Sande, ko e Yesus thop petgim ka nnak, ta ktar mrua khenam ngang e Maria to nkong mMagdala, endo tesgun ta kerer o kool ruk aktiek hori orom alomin kun mnam. ");
INSERT INTO sua_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","To e Maria thera ngae he kle khavaeng endruk ngam kaikkiem ko ngata vur pa ngaor he ktolpum o ngoven kam vua mrung va kaee mang. ");
INSERT INTO sua_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ngta ngan karo rhek ko thavaeng ngar mang e Yesus te, thop he, he en mruo tmur vokom, vanang ngat lo kor mnam mar mang karo rhek e. ");
INSERT INTO sua_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tie mavlemas to endo, e Yesus tmur kta khenam ngang klo kaloyie ko nginta ngae ko ekam a ngaelaut ko ma gi lootpgeik. ");
INSERT INTO sua_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","To enngindi kat, ngint her kaeknik he kle khavaeng endruk ngam kaikkiem mang tok kat. Vanang, ngat lo gi kor mnam mar mang nginaro rhek kat e. ");
INSERT INTO sua_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kopekam tok, endruk loktiek hori orom atgiang ngat korsang ku mmie he kaemik, to e Yesus ta le mur kta khenam ngang ngar kat. Ta mrua pis ko kmar he le ka psom mar pum ngaro papat ruk ngama vle gi kaendel pum E Nut kngam ge, ko ngat lo kor mnam mar mang o rhek ruk mkor endruk ngat mi vokom, kopekam ko thera hop petgim ka nnak he. ");
INSERT INTO sua_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","E Yesus ta psom mar knop, to le khavaeng ngar te, “Mguak ngae mnam o marhok tgus he kpolger o rhek ruk mang a knovvur ngang o mia tgus ko E Nut tkueng ngar. ");
INSERT INTO sua_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Va endruk ngat lo kor mnam mar mang dok, E Nut ner kle kmonik kim a yor ngang ngar, mar kam yor pum ngaro kerkeknen. Vanang endruk ngat kor mnam mar mang dok he kparrur orom E Nut ka munik, her mar ruk arhe E Nut nera sulgim mar he kaen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang ngar. ");
INSERT INTO sua_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","He enang tok, ngor kaeharom o ngaelmir ruk lserpgue ruk endri ko maktiegom mar kam mi kaenserpagam kuaro rhek ma mmok. Ii, ko ngara kerer o kool orom kua munik va ngara rere orom o vrong rhek akuruk yok. ");
INSERT INTO sua_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Va enangthe ngpa kapom o vimol, i o enangthe o mia ngapa sumger mar va ngat lo is kam yor e. Ii, va ngara kaehang endruk ngta yayor va ngar kta yaya kat.” ");
INSERT INTO sua_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ngoldaip to E Yesus ta rere kar mar knop, to E Nut thera kol ka grap orom ngoguon ma volkha he kael a ngorsang ngang ko mnam ka miktiek, endo nma nho orom. ");
INSERT INTO sua_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ta vle tok, to kalngunes ngat hera ngae kun mnam o marhok tgus he kaelha kam polger o rhek mang e Yesus ngang o mia. Ii, he enang tok, e Yesus nam kaeha maktiegom mar kmenserpagam karo rhek ruk endruk, her gi orom o ngaelmir ruk ngma pis vgum karo rhek ruk tok. ");
INSERT INTO sua_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Vae, kolaip e Tiopilas, E Nut karo reha ruk o propet ngta ktar kpavap mang ngar tiok ngat mia pis lmien ma mmok ko kim o mia ruk ngat mur vokom mar orom ngaro mur kerok mruo mnam a venloot to ngat mi pis lmien mnam. To koknaik o mia ruk endruk ngat kaelha kmeha kngae kam polger a re mang o reha ruk endruk kat. He her mar ruk arhe ngat smia papsim mor ruk tete orom o rhek ruk mang E Nut karo reha ruk endruk kat. Kam ngae, to o mia kavurgem tete, endruk ngat smia lol o rhek ruk endruk mang o reha ruk endruk ngat sim kut ikkiem o rhek ruk mkor mar ruk ngat mia vokom mar orom ngaro kerok mruo he le kaelel mo kmar momalpek kmittiegom mar kam smia havaeng o mia akuruk tete kat mang ngar. He kmikkiem enang tok, kolaip, ko hera pat mang yin tok kat. He ekam tok, dok kat, ko her sim kut non ekam o rhek ruk endri tiok kngae kais mang tete, he knantom mar kmelel mar momalpek kmittiegom mar ngang in, yin kam sim ktua mmok te, o ngothoi ruk endruk ngat patter in mang ngar, ngat mi ktua mien hak. Ii, o ngothoi ruk endruk her endri arhe. ");
INSERT INTO sua_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","7","Tennik, mnam a venloot to e Herot to vlou, ta vle te, o Yudea nga taven, a pris langto ka munik e Sekaraia kar ktavlom to e Lisabet nginta vle. Nginm sim kut kaikkiem E Nut kakro pos va o mia ngam lo kais kam mon min orom a kerkeknen tang. Kelua min alo ho hipun he, vanangko, e Lisabet nma vle orom a leep ko pum o mia ngaro kerok ekam ko tgia mait, nop kles ngin e. Lomevek ri nkong ngin mnam o pris nga ngausie to me Eron. Va e Sekaraia nam kaeha ku meorom a pris to alaut to e Abaisia kta ngaiting. ");
INSERT INTO sua_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","To mnam a kolkha langto e Abaisia ka ngaiting tkaeha, he e Sekaraia tkol a pris ka ngaekam to kmeha ko pum E Nut ka lo keik. ");
INSERT INTO sua_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Va ngat ikkiem o pris nga keknen, he klenar ngat mur el en kam vaik ogun mnam E Nut ka maksien ke rek Ka Taban To A Totur Hak kam raom a ho ka ye ko kim E Nut. Ii, e Sekaraia tvaik kmeharom tok, ");
INSERT INTO sua_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","11","vanang o mia vang ngta kaum mnam a taban langto yok gi ku mnok he kngarkie kam hover E Nut ka munik, phevgom e Sekaraia ko ther vaik ogun mnam a taban ogun ktar kam raom a ho ka ye to ka gri tvua ya kuo mang a psen to a totur. E Sekaraia tkaeha kam raom a ho ka ye kuo mang a psen to a totur, va te E Nut tmeng ka engyel langto ko tpis her gi mur khenam kam sir ko vanam a psen to endo ko pa ngaiting to a miktiek. ");
INSERT INTO sua_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","E Sekaraia tre gia vokom, va ka ngaung ta ksir he ksei kam gor hak. ");
INSERT INTO sua_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Vanangko a engyel ta reng te, “Sekaraia, ya gor kman? Or tok, ko E Nut ther ngan ila ngarkie he, he itavlom nera kol kalyie ngang in. Nak kol, va ngiak mon te, e Yoanes. ");
INSERT INTO sua_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","En ner kaensireim yin, he ila sirei ner ho mi ktua hover in hak, va o mia kavurgem ruk ngara ngnek mang ko knan na kol, va en ner kaensireim mar kat ");
INSERT INTO sua_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ko E Nut mruo nera teiver kam vokom te, en a taip. Va na ho lo kat kaiviem o itok ruk lserpgue hak, ngaro serppak kam lua viging, ekam ko E Nunu A Totur tuk ner kle va kviging. Ii, si kun mnam a kolkha to knan nak kol mnam E Nunu A Totur nera viging ge. ");
INSERT INTO sua_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Va ner kaelel o papat mnam lIsrael, mar kam kat kaeknik ko kim Ngaldaip to E Nut, he nang mar kam kta mokpom kar En. ");
INSERT INTO sua_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ii, ko naka ktar kaol kpis ktar mang Endo E Nut Thim Orom Ka Msasaen orom a serppak to enang e Elaisia ktang va orom kakro krovek ruk enang e Elaisia ktakor kat he nera vaer ekam tok. Nera ktar tok, kam hortgem o ngnes ngaortek ngaro keknen, mar kam kta ngaung ya mang ngles kat, va kam hortgem o kerngnek, mar kam sim kut kaikkiem o papat ruk lyar ruk mkor endruk ngam sim kut kaikkiem E Nut karo rhek. Ner sim kaelel mo kim o mia enang tok, en kmeharom mar, mar kam ttek he kpaneng Ngoldaip.” ");
INSERT INTO sua_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","A engyel thavaeng tok, to e Sekaraia tkoripang te, “Hai-e, nguaka mnor te, ilaro rhek ngar mi kael mit nngia? Ko dok kar kotavlom muo alo ho hipun he. Mot lo is kmel a sie tang e!” ");
INSERT INTO sua_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Va a engyel tkoripang te, “Dok e Kambriel, koma vle ko kim E Nut he klol o rhek vgum to kpis ormar mo kmin, ko tmeng dok kam havaeng in orom o rhek ruk endri lyar. ");
INSERT INTO sua_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ther gia ya kat e, vanangko vokom na, ekam ko ya lopumtang pum kuaro rhek, ila gu nera vat kmelha tete, kam ngae kais mnam a kolkha to E Nut karo rhek ngak kael mit.” ");
INSERT INTO sua_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","22","Phevgom ko e Sekaraia ta rere kar a engyel to endo, o mia ruk ngta gun ko ma taban to ku mnok, ngta paneng e Sekaraia va ngat sia papat mang te, “Ngola, enda te vua hus ko tkan?” Ngta pat tok, to hera mnor he te, “O, E Nut telmir ngang orom a nunu tang kun to he.” Ka vle, to e Sekaraia tkottek, to ngta vokom ko tlo is kam kta rere kat e, to ngat her mia mnor te, o, lmien, pusner ko tgia kikier, nang lo kta rere va ka ngnek. ");
INSERT INTO sua_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","E Sekaraia ta vle tok, nang kle kaeharom karo reha ge, krum karo kolkhek ruk ngtelik ngang. Trum mar, to ther kaeknik ngok mrek. ");
INSERT INTO sua_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Ta vle ko mrek kam ngae, to ktavlom e Lisabet ther kael ka vrek mang. To e Lisabet ther gi mur kaetim en mruo te, “E Nut ta khenam ngang dok te, ta higiang dok tete, ko ta pet kua leep to koma vle orom ko pum o mia ngakro kerok he. Ii, En mruo teharom tok ngang dok.” Tmur kaetim tok, to ther gia vle ko mrek orom a sirei. Va tlo kta pupunpa orom ka vrek e, kais kmo kenho ruk a ktiek ko ngat ngae knop. ");
INSERT INTO sua_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mu vokom na, mnam e Lisabet ka kenho to a ktiek he hori ko ther gia vle orom ka vrek, E Nut ta kta meng ka engyel to e Kambriel kam ngae mGalili ngok ma maksien to e Nasaret. ");
INSERT INTO sua_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tngae pis ko kim a vlom sie langto ka munik e Maria, endo lurokol ngat lo ehang vop. Ngat polger re mang he te, en kam lei orom e Yosep, endo kaes to a hipun to e Devit. ");
INSERT INTO sua_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tpis ko kim to kreng te, “Vae, E Nut tho mi kut higiang in he nma vle ko kmin.” ");
INSERT INTO sua_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","E Maria ta ngan karo rhek tok, to tsia vavle ngang ngar he gia moruo kun mnam en mruo pum mar te, “Ngola, ani re ta, enda ta havae orom ti?” ");
INSERT INTO sua_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","31","To a engyel ta kta rere kreng te, “Maria ngior kam gor ekam ko E Nut te sei kam higiang in he! Vokom na, ngir kael ila vrek he kol ihal to ngiak mon te, e Yesus. ");
INSERT INTO sua_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","En ner ho mia laut hak va E Nut nera kvam en te, E Nut To A Ho Lautar Hak Khal Msim, va ekam tok, Ngoldaip to E Nut ner kael en kam kpom a ngaekam to mkor kaes to a hipun to e Devit ngang, en kam laut va ka nho mang o mia. ");
INSERT INTO sua_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ii, he nera nho mang lIsrael kam ngae ngnik ngnik hak va ka serppak ner lo kais kam nop e.” ");
INSERT INTO sua_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","E Kambriel ta rere knop, to e Maria ta mnganang te, “Ngola, nak pis nngia ko a ngokol tang tlo ehang dok vop?” ");
INSERT INTO sua_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Va e Kambriel tkoripang te, “E Nut To A Ho Lautar Hak kta serppak mruo nera pis kmin he nera kokomor yin to ngir le kael ila vrek ekam E Nunu A Totur. Ekam tok, o mia ngara mon ilyie to ngira kol te, E Nut Khal To A Totur. ");
INSERT INTO sua_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Vokom na, o gi vrong reha tgus E Nut tis kmeharom mar. Ko si ila ngausie ka pun msim to e Lisabet, endo a ho ngoumie hak kat he o mia ngma havae te, tgia mait, en tel ka vrek mang katngokol he, va ka vrek ther gia vle te, o kenho aktiek hori orom agitgiang he.” ");
INSERT INTO sua_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","To e Maria tkoripang te, “Yu, o tgoluk ruk ya havaeng dok mang ngar, ngak pis kmok, gi enang ko ya re tok. Ko vokom dok na, ko gia vle te, E Nut kalkayie ormok.” Thavae tok, to a engyel thera parem to kngae. ");
INSERT INTO sua_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","To mnam o kolkhek ruk endruk e Maria ta ktar kaen a re ngang e Lisabet to kngae oguon mnam a mhe to e Yudea karo mhetor ruk kuo kio vlik kam ptang ka ngausie ka pun msim to e Lisabet. ");
INSERT INTO sua_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tpis ko tok, to kvaik kun mnam e Sekaraia ka rek to her gia rere kam mrung e Lisabet. A gi hi to ta mrung knop, ");
INSERT INTO sua_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","e Lisabet kalyie thera prik kun mnam ka vrek. Ta ngan ko E Nunu A Totur tviging tok, ");
INSERT INTO sua_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","to tkaelha kam kanprim e Maria kuon mail te, “E Nut ta khenger yin kir kim lraip tgus hak. Ko a sie to kun mnam ila vrek E Nut ta teiver. ");
INSERT INTO sua_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","44","Vokom na, yi re gia rere kar dok va a sie ta mnam kua vrek ta prik kun mnam dok ko ta prik orom a sirei to mang a sie to ngira kol. Vanang, nngia ko E Nut ta le ksei kam higiang dok he kmeng yin ngte kam pis mo kmok ko klo is enang yin e, ko her yindo arhe, ngira kol Koldaip. ");
INSERT INTO sua_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ii, her yin arhe ya lgekol ekam ko yi her kor mnam yin mang E Nut karo rhek ruk ka engyel ta havaeng yin ormar te, ngar mi kael mit hak.” ");
INSERT INTO sua_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","E Maria ta ngnek tok, to her le koripang vat kmetim E Nut orom ka kni te, “Koma kanprim Ngoldaip ");
INSERT INTO sua_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","va ko ho mi ktua sirei hak ko her E Nut arhe Endo Ta Sulgim dok. ");
INSERT INTO sua_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Va si kalkayie ta dok, ko gia vle enang a gi vrong vlom langto ko mrek va ta pat mang dok ge. He ekam tok, o gi vrong mia tgus ruk tete va endruk koknaik koknaik ngara re te, dok kua lgekol. ");
INSERT INTO sua_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kua sirei mang E Nut To A Serpgar ko teharom o reha ruk laol, endruk ngat papagis kim dok he. En, ka munik a ho totur hak. ");
INSERT INTO sua_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Va ka mamrung nma vaas kim o gi vrong mia ruk ngma totu pum, endruk nga main to tete kar ngaro maineik ruk koknaik koknaik kat. ");
INSERT INTO sua_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","52","Va her Endo teharom o reha ruk lho mi vankue hak orom ka serppak ko thera rum kim o taven ruk ngat lol o ngaekmol ruk kam nho mang o mia he kseneker mar ko ngam mrua hover mar mruo. Vanang endruk ngalmialaol ngma kol a regesal mang ngar he ker kol vgum o vnek vgum mar, E Nut ther kle khover mar. ");
INSERT INTO sua_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ii, va endruk ngma vang, her E Nut to ta klang ngar orom o tgoluk ruk lyar mar kmis, vanang endruk ngat vu kais kmo tgoluk, ta kle her gia likim mar kmeng ngar kam gia ngongae. ");
INSERT INTO sua_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ii, va E Nut ther turang kalngunes ruk mor lIsrael ko thera pat mang ka tnangal to tel ngang ngorores, endo kam mrung e Ebrehem kar kaores tgus ruk koknaik koknaik. Ta pat mang ka tnangal tok he kaenserpgam kam mitom he, kam turang ngor orom tete kat.” ");
INSERT INTO sua_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","E Maria tkaetim E Nut orom ka kni to endo knop, to le ka vle ko kim e Lisabet mnam o kenho ruk korlotge, to her kaeknik ngok mrek. ");
INSERT INTO sua_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","E Lisabet ta vle, to kalyie tkaimim kam hera kol. To thera kol kalyie to a ngokol. ");
INSERT INTO sua_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","To o mia ruk kun mnam ka ngausie ka pun msim va o mia akuruk ko yok, ngta ngnek mang ko ta llues, to ngta pat mang E Nut ko tho mi kut mrung e Lisabet tok, to ngta kaum kam sirei kar. ");
INSERT INTO sua_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","To pekam o kolkhek ruk aktiek hori orom alomin ko ngat nop, o mia ngta ngam a sie kun moulu va ngta re kam mon orom kteit e Sekaraia ka munik mruo. ");
INSERT INTO sua_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Vanangko ngat lo is e, ko knan tkaur kmar he kre te, “O-o, ngruak mon te, e Yoanes.” ");
INSERT INTO sua_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Va ngta havaeng te, “A munik to endo ingores ruk tennik ngat lo mnok orom vop.” ");
INSERT INTO sua_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","To ngat kle kikier ngang a gunsvel kteit kam mnor te, en te ktua svil mang ani munik to. ");
INSERT INTO sua_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","To tgi kta kikier ngang ngar, mar kmen a pla tang ngang. Tkol he, to kaittiek kuo mang te, “Ka munik e Yoanes.” Tkaittiegom tok knop, va te o mia ngat gi senkrip kim ko ");
INSERT INTO sua_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","tre gi kaittiek knop va te ka naprai ther mrua halgir to ther kaelha kam kta rere kat kam kanprim E Nut. ");
INSERT INTO sua_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kam ngae, to o mia ruk ngta vle ko rkieng ngar, ngte sei kam senkrip kim o tgoluk ruk ngat pis kim e Sekaraia enang tok. Va o mia ruk kun mnam e Yudea karo mhetor ruk kuo kio vlik ngam ngae her gia mo rere kar mar mang ngar. ");
INSERT INTO sua_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","He enang tok, ngat kaelha kam sia ngam kmar he, he kmo mnganang ngar te, “Ngola, a sie to enda karo reha ngara vle enang erie e?” Ii, o mia ngam sia ngam kmar tok arhe ekam ko E Nut tkaenkrovgem a sie to orom kta serppak mruo. ");
INSERT INTO sua_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kam ngae, to E Nunu A Totur ta viging e Sekaraia vat he kaenkrovgem, to e Sekraia ta ktar ka kni kam ktar kpavap mang o tgoluk ruk ngar le kpis koknaik yek te, ");
INSERT INTO sua_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","69","“Ko ho mi ktua kanprim Ngoldaip to E Nut, Endo lIsrael ngma totu pum, ko En tkaelha kam tavger Endo Tvua Serppak, Endo Kam Sulgim Mor Kam Hong Ngor Pum Nguaro Kerkeknen. He en nera pis mnam a ngausie ka pun to mkor E Nut kalkayie to e Devit, he E Nut tre kmel ko ma mmok orom ka serppak, en kam sulgim mor kam hong ngor pum nguaro kerkeknen tok arhe. Ii, her endo arhe tre kam ptang ngor he, he kael ekmor ruk karo mia ormor kam hong ngor ko maktiegom nguaro imuo. ");
INSERT INTO sua_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","E Nut tkaelha he kam tavger endo tok kmikkiem karo rhek mruo ruk ta ktar kpavap mang tennik ko vgum o propet ruk o totur ko ngat havae te, ");
INSERT INTO sua_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","en nak sulgim mor he khong ngor ko maktiegom nguaro imuo ruk ngam kaelat mor. ");
INSERT INTO sua_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Ii, E Nut ther tavger endo tok, kmaottam ka tnangal to a totur, endo ta khenam ka mamrung ngang ngores orom, en kam pis lmien orom tok. A tnangal to endo, E Nut ther ktar el orom ka serppak mruo ngang ngores to e Ebrehem ko ta ktar kpavap mang te, ");
INSERT INTO sua_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","nera turang ngor he khong ngor ko maktiegom nguaro imuo, mor kmeha ngang En mruo mekam mekam he lo kta gorang ngar kat e. Ii, nera turang ngor tok, mor kam kle sim kut kaikkiem karo pos, mor kam vle la mmok hak ko pum kalo keik. Ii, E Nut nama svil mor kam vle tok mekam mekam. ");
INSERT INTO sua_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Vanang yindo kua gidiel ormin, o mia ngara kvam in te, E Nut To A Ho Laut Hak ka propet to yin, ko ngira ktar mang Endo E Nut Thim Orom Ka Msasaen kam vaer ekam. ");
INSERT INTO sua_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ngira ktar tok, ko E Nut nera meng yin ngok kim karo mia mruo ruk ormor kam havaeng ngor mang a papat to enda te, E Nut nera sulgim mor he khong ngor pum nguaro kerkeknen ko nera lol patgiang ngaiting. ");
INSERT INTO sua_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ii, E Nut nera lol nguaro kerkeknen patgiang ngaiting ekam ko nam vua mrung ngor. Ii, E Nut nera mrung ngor he kmeng Endo E Nut Thim Orom Ka Msasaen, ko ner kottek kuon ma volkha he kaol ngte kmor kam valler mor enang a kolkha ko nma plek he kvaller mor tgus tok kat. Ner kaeharom tok, he nang mor kam mmok mang te, her en arhe endo kam sulgim mor he khong ngor pum nguaro kerkeknen. ");
INSERT INTO sua_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ii, en ner kaol he kpis enang tok, kam valler o mia ruk ngma vle kun mnam a slommok ko ngma vle enang o mia ruk ngat yor he. Va a mmok to endo nera ktong ngor, mor kmikkiem a ngaelaut to kam smia kol a vrek longeik kar E Nut.” ");
INSERT INTO sua_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","E Sekaraia ta kni knop to ka vle. Nang e Yoanes nam her gia vle ko ma kalputmok to ngae klaut ko tok orom kakro krovek ruk ngta serppak, kam ngae kais ko mnam a kolkha to tngae kpis ma mmok ko kim lIsrael. ");
INSERT INTO sua_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tie ma venloot to e Lisabet ta llues mnam, lRom Ngalaip to ka munik e Ogastas tkol lRom nga ngaekam to ngma mon te, e Sisa. En tkaen a re ngang o mia ruk kun mnam o Rom ngakro rengmat tgus, mar kmel ngakro mnok. ");
INSERT INTO sua_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(A re to enda ngta pakvom yek kun mnam a venloot to e Sairinias ta nho mang lRom nga mhe to e Siria.) ");
INSERT INTO sua_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ekam tok, o mia tgus ngat kaelha kam veet kmeknik ngok mnam ngakro rengmat ngo pneik mruo kmel ngakro mnok tgus. ");
INSERT INTO sua_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Va ekam ko e Yosep nkong mnam a ngausie ka pun to me Devit, en tkottek ko mnam ka maksien to e Nasaret kun mGalili he ka grung ngogu mYudea ngok ma maksien to mBetlehem, ko e Devit ka rengmat ka pun to arhe. ");
INSERT INTO sua_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","En kar ktavlom to e Maria, endo ngat polger re mang te, ngin kam lei, nginta grung ngogu kmen nginalo munik, vanangko e Maria ka her vrek he. ");
INSERT INTO sua_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nginta pis he ka vle ko tok, to e Maria kalyie tkaimim en kam hera kol he. ");
INSERT INTO sua_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Vanangko nop a ngaekam tang ngang ngin kun mnam o gunmia nga rek to tok e. Ekam tok, ther gia kol khal to a molpou kun mnam a liplip to le kokomor orom o it he kael kun mnam a plo. ");
INSERT INTO sua_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mnam a segain to endo o toot kmo sipsip ngta vle kun mo mhetor ruk ko rkieng a rengmat to e Betlehem he ktoot mang ngaro sipsip. ");
INSERT INTO sua_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ngta vle ko tok, va vgum E Nut ka engyel langto ko E Nut ta meng kam ngae kpis kmar. Ther gi pis orom Ngoldaip ka mmok he kvaller mar to ngat sei kam gorang. ");
INSERT INTO sua_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","To a engyel ta reng ngar te, “Mguak or kam gor e. Ko mu vokom na, ko pis orom E Nut ka re to kmensireim o mia tgus, ko ");
INSERT INTO sua_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","tete kun mnam e Devit ka rengmat ka pun, a gunsvel langto knan tkol he, he her en arhe, Endo Kam Sulgim O Mia Kam Hong Ngar Pum Ngaro Kerkeknen. Ii, a gunsvel to endo, her en Ngoldaip to E Nut Thim Orom Ka Msasaen to arhe. ");
INSERT INTO sua_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ii, mguer mrua vokom a gunsvel to endo ko ngata kokomor orom o it he kael nera kru kun mnam a plo. He vgum alo ngaelmir ruk orom a plo va o it mguera mnorvek pum tok arhe.” ");
INSERT INTO sua_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Thavae tok, va vgum a ngaen to alautar ko tottek kuon ma volkha he kpis kaum kar a engyel to endo, he mar tgus ngta mo turang kam kni kam kanprim E Nut te, ");
INSERT INTO sua_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ngruak guya pum E Nut to man ma volkha ka munik ko ta re kmel a vrek longeik kun pgegom o mia ruk ta higiang ngar kar En mruo.” ");
INSERT INTO sua_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","O engyel ngata kni tok, to ngat hera parem o toot kmo sipsip to kaeknik ngoguon ma volkha. To o toot kmo sipsip ngat kaelha kam mo reng ngar te, “Puoo-te-tok, he mu somor ngok mBetlehem he ngor kam ngae kvokom a gunsvel ta E Nut ta havaeng ngor mang ko ther pis he.” ");
INSERT INTO sua_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","To ngta marer kngae. Ngta kngae kpis kriring to kpis mang e Maria kre Yosep va a gunsvel ta he, ko tgia kru kun mnam a plo. ");
INSERT INTO sua_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ngta pis kvokong he, to ngat kle kparem mar he kngae kpolger a engyel karo rhek mang a gunsvel to endo. ");
INSERT INTO sua_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Endruk ngta ngan o rhek ko vgum o toot kmo sipsip ngat ngae her mrua sor kmar, ");
INSERT INTO sua_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","vanang e Maria, tlo kat korim o papat ruk endri e, ther gi kaelik mo malpek he, he gia pat mang ngar tok. ");
INSERT INTO sua_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","O toot kmo sipsip ngat polger o rhek tok, to her kaekeknik to kanprim E Nut mang o ngaelmir ruk ngat vokom mar va ka ngnek mang ngar ko ngat mi papagis msim tok kmikkiem a engyel ka re ko thavaeng ngar mang ngar enang tok. Ngat kanprim E Nut mang ngar kam hover E Nut ka munik ko pum o mia ngaro kerok enang tok. ");
INSERT INTO sua_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","To kopekam o kolkhek ruk aktiek hori orom alomin ko ngat nop, ngta ngam ngin lyie kun moulu he kmon orom a munik to e Yesus, ko E Nut ka engyel mruo ta ktar sgum tok, nang knan nong ka vrek orom vop. ");
INSERT INTO sua_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","E Maria kar kalyie ngint parrur knop kmikkiem enang ko e Moses ta keknen tok, to alomevek ri nginta kol ngin lyie he kngorom ngoguo mYerusalem kam teiver kmel maktiegom Ngoldaip to E Nut ");
INSERT INTO sua_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kmikkiem o rhek ruk ngat ittiegom mar kun mnam Ngoldaip ka hor to orom o pos te, “A yie to a molpou ngiak teiver he ka khenam ngang E Nut te, ta polok petgim o gi vrong mia kam vle ko maktiegom E Nut mruo.” ");
INSERT INTO sua_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Enang tok, ngint ngae ngoguo mYerusalem kam ngae ngok kim a pris langto ko tok, kmen ngin lyie ko maktiegom E Nut va kmen o nngiar kmikkiem Ngoldaip ka pos langto tok ko thavae te, kam nngiar ngang “Orom o iningol korlolo, endruk alo gennes alomin, va alo giu lomin ruk o sital.” ");
INSERT INTO sua_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ngint pis kmeharom tok, vanang a mhel langto ka munik e Simion ta vle ko mYerusalem kat. En a mhel a yar ko nam vu kael ongtok mang E Nut he sim kut kaikkiem karo pos va nma paneng Endo Kam Sulgim lIsrael Kam Hong ngar petgim ngaro imuo ko nera pis. Ta vle tok orom E Nunu A Totur kakro krovek ko ta viging. ");
INSERT INTO sua_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ii, va tesgun E Nunu A Totur ta kenang te, ner lua yor vop kais ko nak vokom Endo E Nut Thim Orom Ka Msasaen, endo Ngoldaip tel ka tnangal mang te, en kam pis. ");
INSERT INTO sua_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","E Simion ta vle tok, va E Nunu A Totur te mrua ktong kngorom ngok mnam E Nut ka maksien ka taban to ko ma gi vle. To lomevek ri ngint re kvaik orom ngin lyie kam teiver va ka khenam ngang E Nut kmikkiem ngaro pos ko ngat keknen tok. ");
INSERT INTO sua_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","To e Simion tkaol ngok kim min to kol ngin lyie korreiker maktiegom to hera kanprim E Nut kmetim te, ");
INSERT INTO sua_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Ngoldaip yin mruo im vua nho mang o tgoluk tgus he ekam tok, ngiak kaikkiem ila tnangal to ye her el ngang dok, endo kam vaeng dok ngok kmin yek, ekam ko ko her vokom Endo Kam Sulgim O Mia He Khong Ngar Pum Ngaro Kerkeknen he. Ii, kua vrek thera vle longeik ekam ko ko mur vokom endo orom kua lo keik mruo. ");
INSERT INTO sua_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Her en arhe yin mruo ya re kam mur kael en kam khenam mo pgegom o mia tgus ngo kerok ");
INSERT INTO sua_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","en kam vle te, a mmok to kam valler o vrong rhek, mar kam mmok mang en te, en arhe endo kam sulgim mar he khong ngar pum ngaro kerkeknen. Va en nera vle kat orom kla saen to kam valler lIsrael tok kat, o mia tgus, kam guya pmar ekam en.” ");
INSERT INTO sua_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","E Simion tkaetim E Nut knop, to lomevek ngint ngae her gia mo sor kmin kim o rhek ruk e Simion tkaetim E Nut mang ngin lyie ormar. ");
INSERT INTO sua_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","To e Simion tngamyammok mang ngin to le ka ktar kpavap mang ngin lyie ngang knan te, “Vokom na, a gunsvel to enda E Nut tmi el kam mommen lIsrael kavurgem ko en nera kaop kim akuruk kam harapeet petgim va akuruk yok nera kaop kim mar, mar kam le ksisir vanam. He ekam tok, nera vle enang a totu to mkor E Nut. Va si enang tok, o mia ngar le krere pum ge. En nera vle tok arhe, he nang en kmommen o mia tgus kam khenam ngaro vurkul ma mmok, nang koknaik o mia ngara krong orom o ot. He enang tok, en ner kaop kmin kat kam kol a ho mamrung alautar hak ko a mamrung to endo ner ngae sei kam krong yin kat.” ");
INSERT INTO sua_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mnam a kolkha to endo, a propet langto a vlom ta vle kat. En a tahek to a ho ngoumie hak he. Ka munik e Ana. En nkong mnam a ngausie ka pun to me Aser va kteit e Panuel. E Ana tlei tiok he, he ka vle ko kim katngokol mnam o pnes a ktiek hori orom alomin ");
INSERT INTO sua_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","to katngokol thera yor kparem. Nang en, ther gia vle en a tahek kam ngae kais tete ko en a ho ngoumie hak he. Va nam lo korim E Nut ka maksien e. Nam gia kanko kpis ko tok va khivuo kam paal kmo ol tgus ko kim E Nut kam hover ka munik he kngarkie ngang mnam o kolkhek va o rsegain tgus. ");
INSERT INTO sua_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","To kun mnam ke vgon to endo ge e Ana ther kaol kpis mang e Simion mar ko e Simion ta hivuo kam rere ngang e Maria vop. Tpis to her gia kanprim E Nut ko kim mar to le kaelha kam havaeng o mia ruk ngata vle he kpaneng Endo Kam Sulgim lYerusalem He Khong Ngar Petgim Ngaro Imuo mang a gunsvel to endo. ");
INSERT INTO sua_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ngint eharom ngaro reha ruk endri kmikkiem E Nut karo pos knop, ko ngat havae tok, to ngint kaeknik orom ngin hal kam ngae ko mGalili ngok mnam nga rengmat msim to e Nasaret. ");
INSERT INTO sua_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ko tok, a gunsvel to enda ta ngae klaut he kserppak va vua nganrhek mekam mekam va E Nut nam vu kael o papat mnam. ");
INSERT INTO sua_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mnam o pnes tgus e Yosep kre Maria nginma kanko kngae mYerusalem kam kunngir kim a pnes to ngma mon te, A Engyel Tvarpaam O Yuda Ngaro Molpou. ");
INSERT INTO sua_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","E Yesus karo pnes ngat kais te, lo ktiek hori orom alomin. To mnam a kolkha langto tkaikkiem lomevek ri kam grap ngoguon kam kunngir kim a pnes to enda kmikkiem enang ko ngma kanko kmeharom mo pnes tgus tok. ");
INSERT INTO sua_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ngat kunngir kim a pnes to endo knop, to lomevek ri ngint kaelha kmeknik ngogu mrek, vanang lua paptang e Yesus ko en tlo eknik ekmin e. Ta kle va her gi vle ko tok mYerusalem. ");
INSERT INTO sua_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Vanang min, nginta kle kpat re the, ther ikkiem a valngan to ngat kaeknik ngogu mrek, to ngint her gia kolaspa kam ngae mnam a kolkha to agitgiang tgus ngok mrek. Kam ngae, to ngint kaelha kam riring e Yesus kun pgegom nginaro valngneik va ngin lenar mruo. ");
INSERT INTO sua_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Vanangko ngint lo pis mang e, to ngint kaeknik ngoguon mYerusalem kat kam ngae kta riring. ");
INSERT INTO sua_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","To mnam o kolkhek ruk korlotge ko ngint sia riring, vanangko tngae ka vle kun mnam E Nut ka maksien ko nam korsang kun pgegom o pattermia kmo pos he ka mnganang ngar va kvongnek kim ngaro rhek. ");
INSERT INTO sua_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","O mia ruk ngata ngan ko tkoripang o mngan ngat her gia senkrip kim ekam ko tsim ktua ngangam kim kmoripang ngar orom karo vu papat ruk laol. ");
INSERT INTO sua_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","To e Yosep min ngint pis re gia vokom ngin hal ko tok, nginalo nunu ngint ho mi kut parem nginalo mit hak. To knan tkootporeng te, “Ngola, kman ko ya kirmekon muo tok, ko mote ksei kam papat miik he kriring in?” ");
INSERT INTO sua_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Va E Yesus tkoripang knan te, “Met vua riring dok kman? Met lua mnor gi, ko meta kta riring dok kat, ko nguaka vle mo mnam E Titou msim ka maksien he?” ");
INSERT INTO sua_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Thavaeng ngin tok, vanang min ngint lua mmok mang karo rhek e. ");
INSERT INTO sua_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","To e Yosep kar ktavlom nginta vaeng e Yesus to ngta parem e Yerusalem to hera ngae ngogu mNasaret. Ngma vle ko tok, va e Yesus nma ngan vgum min mekam mekam. Va knan tlo korim o papat ruk endri e, ther gi kaelik mo malpek he, he gia pat mang mar tok. ");
INSERT INTO sua_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kam ngae, to e Yesus ta laut kngae he vua nganrhek mekam mekam. Va E Nut tsei kam higiang he kael o papat mnam. Va o mia ngma higiang kat. ");
INSERT INTO sua_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","E Yesus tlaut mnam a venloot to lRom Ngalaip to ka munik e Taibirias tkol lRom nga ngaekam to ngma mon te, e Sisa. A venloot to endo ta vle te, e Taibirias tkol a ngaeha to kam nho mang lRom tgus kngae kais ko o pnes ruk loktiek he hori orom a nhar ngat nop. Va mnam a pnes to endo ko ta nho mang ngar kais ko tok, e Taibirias kalkayie to e Pontius Pailet tkol a ngaeha to kam nho mang a mhe to e Yudea. Va e Herot te ktua nho mang a mhe to e Galili va knopia to e Pilip, te ktua nho mang alo mhe ruk e Iturea va e Trakonitis va a mhel langto yok, endo e Lisanias te ktua nho mang a mhe to e Abelene kat. ");
INSERT INTO sua_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Va mnam a venloot to endo kat o pris ruk laol ngalotaip ruk e Anas kre Kaiapas nginta nho mang o pris tgus. Ii, her a venloot to enda arhe E Nut tkael a re mnam e Sekaraia khal to e Yoanes ko ma kalputmok. ");
INSERT INTO sua_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","He ekam tok, e Yoanes tkaikkiem a re to endo tok, he kngae mnam o mhetor tgus ko rkieng a ye to e Yodan he ka tger o mia te, “Mguak kaitgung mularo kerkeknen he kparrur orom E Nut ka munik, he nang muk kam mrua khenam muk mruo ma mmok tok te, mut mi itgung mularo kerkeknen, nang E Nut kam lol patgiang ngaiting he kikiangae mang ngar.” ");
INSERT INTO sua_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ii, her e Yoanes to tpis tok arhe kmikkiem enang ko a propet to e Aisaia ta ktar kpavap mang tennik te, “A mhel langto ta vle ko ma kalputmok he ktetger o mia kam re la vlorum ngang ngar mang ngaro kerkeknen te, ‘Mguak verang a ngaelaut ekam Ngoldaip, Endo E Nut Thim Orom Ka Msasaen va mguak hopeng kero kleimkor ekam kat. ");
INSERT INTO sua_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Va mguak koveet o vlik va o kharmai ngpirik, nang khopeng o tonglou ruk laol ngpalmai, mar kam mo is he ksirsir enang a sirsirmok. Va mguak sirsrim o tutummok kam sir he kaeharom o kernonhommok kam kta sir kat. ");
INSERT INTO sua_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mguak kaeharom tok, he o gi vrong mia tgus ngar mia vokom Endo ko E Nut nera sulgim mar kam hong ngar pum ngaro kerkeknen vgum en.’” ");
INSERT INTO sua_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","E Yoanes nam kaeharom tok, va o mumu kavurgem ngta veet ngok kim, en kam parrum mar kat. Tvokom mar, to thera kner mar kam re te, “Laro inkuol ruk muk orom mularo naprai alomin ko muta pat re te, mut kais kam gia parrur kuo mang mularo gi pkor enangthe kam pet a kapnes to E Nut tre kmen ngang nguk, nang kle kat kaeknik kmeharom o kerkeknen? ");
INSERT INTO sua_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Te ho mi kut nop hak, ko mguak kle va kaeharom o keknen lyar ruk ngta khenam ngang o mia te, lmien te, mut mi itgung mularo kerkeknen. Ii, va mguak or kam pat te, mut kais kam pe gi mrua koon mang nguk mruo orom mularo mur rhek kam tok orom mar kam re te, ‘Ngot pal mnam a ngausie ka pun to mkor ngorores to e Ebrehem, he ekam tok, ngrer lua kol a kapnes to endo e.’ Kmanker muk? Te mut si pal mnam a ngausie to mkor ngores to e Ebrehem vanie, ko kua havaeng nguk te, si o gi krek ruk endri va E Nut tkais kam hortgem mar, mar kam pis te, e Ebrehem kaores msim ruk mar kat, mar kam le gi liepum muk ormar. ");
INSERT INTO sua_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kua mien, ko langto langto mnam muk tmi kut kaenang a ho to nam kaehi orom karo miel ruk nong lyar. He ekam tok, E Nut ketasuo en kam hong pum a ho to endo he. Ko gi tete ta, ka kom ther toto mang karo kavgot, ko ta paneng endruk tgus ngaro miel ruk nong lyar kmovverik he kokovgom mar kngam mar kuo kia paei.” ");
INSERT INTO sua_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","E Yoanes ta re tok, to o mia kavurgem ngta mamnganang te, “Vanang ngruak kaeharom anito he nang E Nut kam lo kaen a kapnes to ner kaen ngang ngor?” ");
INSERT INTO sua_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Va e Yoanes tkaekon ngang ngar te, “Endo kalo yet alomin, nak kaen tang ngang kaela to en nop, va endo ta vi naka nngiar ngang klenar ruk nop o ol ngang ngar.” ");
INSERT INTO sua_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ta re tok, to o ker mia ruk ngam kaelha klol o takis ngat kaol ngok kim e Yoanes, en kam parrum mar kat. Va ngata mnganang kat te, “Pattermia, vanang mor, ngruak kle kut kaeharom anito he nang E Nut kam lo kaen a kapnes to ner kaen ngang ngor?” ");
INSERT INTO sua_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Va e Yoanes tkoripang ngar te, “A tong to lRom ngtel, o mia kmikkiem kam ngam o takis kais ko tok, mguak or kmaur kim o mia kam grap mang a tong to endo.” ");
INSERT INTO sua_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Va akuruk mnam lRom ruk ngma kar va tomten ngat le kaol kmikie kam kta mnganang vat te, “Vanang nngia mang ngor? Ngruak kaeharom anito he nang E Nut kam lo kaen a kapnes to ner kaen ngang ngor?” Va e Yoanes tkoripang ngar te, “Mguak or kam kol a hagie mang o mia, mar kmen o krek ngang nguk. Nangko mgua le gia sirei mang a kre to muma kpom. Va mguak or kam ppiak mang o mia ko kim endruk ngma vongnek kim o rhek.” ");
INSERT INTO sua_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Va ekam ko o mia ngat gia toot kam nho mang Endo E Nut Thim Orom Ka Msasaen, ngat kaungtu mang e Yoanes, he kpat re te nok her endo arhe. ");
INSERT INTO sua_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Vanangko e Yoanes ta srim mar mang en mruo te, “A mhel langto ner kaol knaek mang dok, vanangko en tlaut mang dok. Ka serppak tho mi kut laut kir kim dok he klo vu is mang en hak. Si dok kam hong ka lo nhar ngina lo ngausie mkor va dok klo vu eveep is e, en kam ppir orom en mruo, nang dok kam hong min mkor. Dok, koma parrum muk orom a gi ye e, vanang Endo Ner Kaol knaek mang dok, en ner le ktua parrum o mia akuruk mnam muk orom E Nunu A Totur ka munik. Vanang akuruk mnam muk ner kle kngam mar oguo kia paei. ");
INSERT INTO sua_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ii! Her en tuk to tkais kmeharom ka ngaeha enang tok arhe, ko ka ngaeha ta vle enang a mhel to ta kpom a kriar ko ta re kam sngam a paei kam mrot o hi ngo khek. Nera mrot to le klol endruk lyar petgim endruk nong lyar, nang kle klol endruk lyar he kaelik kun ma rek langto. Vanang endruk nong lyar nera ngam mar oguo kia paei to a vleir kam hera raom mar tgus ngatngae.” ");
INSERT INTO sua_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ii, kmikkiem enang tok, e Yoanes nma tetger o mia orom karo rhek kavurgem kam hahavae mang a re to mang e Yesus tok. ");
INSERT INTO sua_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Vanang tesgun e Yoanes nma mon lRom ngalaip kalkayie to e Herot orom karo kerkeknen ngo mamten tgus. To mnam a kolkha langto e Yoanes ta kner e Herot pum ka kerkeknen langto, ko e Herot tparem ktavlom, nang kle klei orom knopia to e Pilip ktavlom to e Herodias. ");
INSERT INTO sua_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","To e Herot teharom a kerkeknen langto kuo mang karo kerkeknen tgus ruk tesgun. Va ka kerkeknen to endo tkernonho hak kir kim endruk tgus tesgun, endo kmenpasiker e Yoanes kmel kun ma hengor. ");
INSERT INTO sua_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nangko ktar mang ko ngat lo enpasiker e Yoanes kun pa hengor vop, e Yoanes tparrum o mia tgus to le kparrum e Yesus kat. To e Yesus ta ngarkie ko tok, va a volkha tmommenik, ");
INSERT INTO sua_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","he E Nunu A Totur to tmur ellik mang a giu ta grung he kar kuon mang. To E Nut ka ktui tkottek kun kuon ma volkha he kre te, “Ko hal to yin. Kom vu kaelongtok mang in va ko sei kam higiang in.” ");
INSERT INTO sua_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Enang tok, e Yesus karo pnes ngat kais te, a mhelom he lo ktiek ko tkaelha kmeharom karo reha. Nang o mia ngma pat re te, e Yesus, e Yosep khal msim. Va e Yosep e Hilai khal, ");
INSERT INTO sua_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","e Hilai e Mattat khal, e Mattat e Livai khal, e Livai e Melki khal, e Melki e Yanai khal, e Yanai e Yosep khal, ");
INSERT INTO sua_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","e Yosep e Matatias khal, e Matatias e Emos khal, e Emos e Nahum khal, e Nahum e Eslai khal, e Eslai e Nagai khal, ");
INSERT INTO sua_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","e Nagai e Meat khal, e Meat e Matatias khal, e Matatias e Semein khal, e Semein e Yosek khal, e Yosek e Yoda khal, ");
INSERT INTO sua_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","e Yoda e Yoanan khal, e Yoanan e Resa khal, e Resa e Serababel khal, e Serababel e Sealtiel khal, e Sealtiel e Nerai khal, ");
INSERT INTO sua_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","e Nerai e Melki khal, e Melki e Edai khal, e Edai e Kosam khal, e Kosam e Elmadam khal, e Elmadam e Er khal, ");
INSERT INTO sua_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","e Er e Yosua khal, e Yosua e Elieser khal, e Elieser e Yorim khal, e Yorim e Mattat khal, e Mattat e Livai khal, ");
INSERT INTO sua_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","e Livai e Simion khal, e Simion e Yuda khal, e Yuda e Yosep khal, e Yosep e Yonam khal, e Yonam e Elaiakim khal, ");
INSERT INTO sua_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","e Elaiakim e Melia khal, e Melia e Menna khal, e Menna e Mattata khal, e Mattata e Natan khal, e Natan e Devit khal, ");
INSERT INTO sua_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","e Devit e Yesi khal, e Yesi e Obet khal, e Obet e Boas khal, e Boas e Salmon khal, e Salmon e Nason khal, ");
INSERT INTO sua_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","e Nason e Aminadap khal, e Aminadap e Ram khal, e Ram e Hesron khal, e Hesron e Peres khal, e Peres e Yuda khal, ");
INSERT INTO sua_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","e Yuda e Yakop khal, e Yakop e Isak khal, e Isak e Ebrehem khal, e Ebrehem e Tera khal, e Tera e Nahor khal, ");
INSERT INTO sua_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","e Nahor e Seruk khal, e Seruk e Reu khal, e Reu e Pelek khal, e Pelek e Eber khal, e Eber e Sela khal, ");
INSERT INTO sua_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","e Sela e Kenan khal, e Kenan e Arpaksat khal, e Arpaksat e Sem khal, e Sem e Noa khal, e Noa e Lamek khal, ");
INSERT INTO sua_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","e Lamek e Metusela khal, e Metusela e Inok khal, e Inok e Yaret khal, e Yaret e Mahalalel khal, e Mahalalel e Kenan khal, ");
INSERT INTO sua_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","e Kenan e Inos khal, e Inos e Set khal, e Set e Adam khal va e Adam E Nut khal. ");
INSERT INTO sua_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","To E Nunu A Totur tkaenkrovgem e Yesus kmottek mnam a mhe to ko rkieng a ye to e Yodan, he ka ktong ngok ma kalputmok ka mhe langto ko yok vat. ");
INSERT INTO sua_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","To ko tok, e Yesus tgia paal kmo ol ko kim E Nut mnam o kolkhek ruk alo mhelom alomin, to te ksei kam vang. Va mnam a venloot to endo kat e Seten tkaenen mkor e Yesus kam kendom ngang, te en kmeharom a kerkeknen tang. ");
INSERT INTO sua_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ii, e Seten tkaelha kmenen mkor e Yesus kam kendom ngang kam reng te, “Enang ko E Nut Khal msim to yin, va yin he reng a kre ta, he nhortgi el en a bret, yin kmem.” ");
INSERT INTO sua_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Va e Yesus ta kokheng te, “O-o, ngat ittiegom E Nut karo rhek tennik he te, ‘A mhel ka ngorsang tlo gia vle mang kam her gia pat mang o gi ol tuk he kvenu kmemik e.’” ");
INSERT INTO sua_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","E Seten ta ngnek tok, to ther kta ktong e Yesus ko ma mhe to oguon mail hak. Va vgum o marhok ngakro mhetor tgus ko e Seten ther gia khenam mar ngang mnam ke gi venloot to endo gi. ");
INSERT INTO sua_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","To e Seten ta havaeng te, “Va yin, o marhok ngakro serppak va ngakro gol tgus ruk endri E Nut telik ko maktiegom dok he ko kais kmenik ngang in. Ko ko kais kmenik ngang tang enangthe kopa svil. ");
INSERT INTO sua_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Enang yin, ngora slak orom o marhok tgus ruk endri ngakro serppak kar ngakro gol ngang in, yin kam nho mang ngar enangthe ngiak totu pum dok.” ");
INSERT INTO sua_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Va e Yesus ta kta kokheng ge te, “Tennik ngat ittiegom E Nut karo rhek kat te, ‘Ngia gia totu pum Ildaip to E Nut tuk he kaeha ngang gi En tuk.’” ");
INSERT INTO sua_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","E Yesus ta re tok, to e Seten ther kta ktong ngok mnam E Nut ka maksien to ko mYerusalem, to hera srim kuon mang E Nut ka maksien ka rek ka keik to kuo plut hak. To ther kat kaegom kam kleim E Nut karo rhek kam kendom ngang te, “Enang ko E Nut khal msim to yin, va yin he, mur khenam in kam prik ngogu mmie. ");
INSERT INTO sua_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ko enang ko lmien mang in tok, va yi lo is kam yor e, ko ngat ittiegom E Nut karo rhek mang yin kat te, ‘E Nut ner kael a re ngang karo engyel, mar kam smia nho ekam yin. ");
INSERT INTO sua_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","He ngar gia hapong in orom ngakro singni ko kia gan. He ekam tok, si ila nhar ke smeik ngang ner lo kais kam gi vrua mot a kre tang hak.’” ");
INSERT INTO sua_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","To e Yesus ta kta kokheng kat te, “O-o, tennik ngat ittiegom E Nut karo rhek akuruk kat te, ‘Ngior kam kendom ngang Ngoldaip to E Nut, En kam khenam ka serppak ma mmok.’ ");
INSERT INTO sua_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","E Seten ta kendom ngang e Yesus orom o ngaegom ruk endri tgus knop, to ther gi korim to kpaal mang en kam vle kat kaegom mnam a kolkha langto vat. ");
INSERT INTO sua_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","To e Yesus tkaeknik ngoguon mnam a mhe to e Galili he kaelpun kvaik kottek mnam o Yuda ngartaro rektor ruk kam rere mnam mar. Va E Nunu A Totur tkaenkrovgem he nma patter o mia orom ka serppak, va o mia ngam ngae sei kam hover ka munik hak. He ekam tok, a re to mang en, ta ngae kvaas kim o mia ruk kun mnam a mhe to endo tgus. ");
INSERT INTO sua_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","To e Yesus ta ngae kun mnam ka rengmat ka pun to e Nasaret ko tlaut ko. Va a Sabat langto tpis. He kmikkiem ka keknen to kam vaik ngok mnam o Yuda ngartaro rektor ruk kam rere mnam mar mo Sabat tgus, ta vaik ogun mnam o Yuda ngarta rek ko tok mNasaret kat he ksir ogun ktar kam kol a ngaekam to kam him E Nut karo rhek. ");
INSERT INTO sua_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ngat kaen a meer to mkor a propet to e Aisaia ngang, to ta lamher he kpis ko mnam a mhe to e Aisaia tittiek mang Endo E Nut Thim Orom Ka Msasaen to khim te, ");
INSERT INTO sua_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ngoldaip tmeng E Nunu A Totur kmenkrovgem dok ekam ko E Nut thim dok orom ka msasaen kmenserpagam dok kmel a re ngang o mia mang ka tavgo. Ii, tmeng dok ngang endruk ngta tu kmo tgoluk kam havaeng ngar te, E Nut ka tavgo tkais kam hong ngar petgim ngaro kernonhommok. Va ngang endruk ngta vle ku meorom e Seten ka tavgo kat, E Nut tmeng dok ngang ngar kat, dok kam havaeng ngar mang a knovvur te, E Nut ka tavgo tkais kam hong ngar kat petgim e Seten ka tavgo hak. Va ngang o vivisker, tmeng dok ngang ngar kam havaeng ngar te, ka tavgo tkais kmeharom mar, mar kam kta nho kat. Va ngang endruk o mia ngma kol a regesal mang ngar, tmeng dok ngang ngar kat kam havaeng ngar te, E Nut ka tavgo tkais kam hong ngar petgim endruk ngma kol a regesal mang ngar. ");
INSERT INTO sua_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ii, tmeng dok ngang endruk arhe, dok kam pis kael o rhek ngang ngar tete tok arhe te, a venloot to E Nut telha orom kam hong ngar pum ngaro kernonhommok her tete msim arhe.” ");
INSERT INTO sua_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ta him a meer tok knop, to ta kta llum to her kaen ngang a mhel to nam kaeha ko tok. To ther korsang kam patter mar. O mia ruk kun ma rek to endo ngat her gia ketlam, va ngaro kerok ngat lo kat korim e. ");
INSERT INTO sua_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","To ther kaelha kam havaeng ngar te, “Tete mnam a kolkha to enda msim, E Nut karo rhek ruk endri ngat her el mit ormok he, ko muta vongnek kim mar ko pelam muk mo.” ");
INSERT INTO sua_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","E Yesus tsim ktua rere kngae, he ekam tok, o mia ngata sor kim to her gi kaelha kam guya pum. Va ngaro papat ngata horotgi he ngat kaelha kmelat he kaesik ngang te, “He ngola, te e gi Yosep khal ta!” ");
INSERT INTO sua_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Va e Yesus tkoripang ngar te, “Mguer mia keyang dok he kre kvat a re to enda mang dok ko koknaik mguer mia re orom te, ‘Yindo im kaeharom o mia, ma te yin he, mur kaeharom yin mruo.’ Va enang tok kat, mguera kendom ngang dok kat kam khenam o reha ruk lserpgue mo mrek mo kmuk, endruk muta ngnek mang ngar ko ngat pagis kim lKaparnam kat. ");
INSERT INTO sua_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Lmien, mguera keyang dok enang tok ko a re langto, enda he, ther el mit ormok he, ko ta re te, ‘O propet tgus ruk o pgirmia, ngaro mia mruo ngama keyang ngar.’ ");
INSERT INTO sua_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mu sim ngnek na! lIsrael ngma keyang a propet to e Elaisia gi enang tok, he a re to endo ta pis lmien tok arhe orom en tok kat. Ko mnam a venloot to e Elaisia ta vle, o tahek kavurgem ruk nkong ngar mIsrael msim ngma ker kol vgum a vang alautar hak ekam ko a kolkha alautar ta vle mnam o pnes ruk korlotge he ka mhe ko tok mIsrael. ");
INSERT INTO sua_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Si o tahek ruk mar lIsrael msim ngma vle tok, vanang E Nut tlo meng e Elaisia ngok kim mar kam turang ngar e. Vanang a vrong rhek langto yok endo a tahek to nkong mSarapat ko rkieng a rengmat alaut to e Saidon, va E Nut ta kle va kmeng e Elaisia ngok kim a vrong rhek langto yok to enda tuk. ");
INSERT INTO sua_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","He gi enang e Elaisia, lIsrael ngma keyang E Nut ka propet langto yok e Elaisa tok kat. He a re to endo ta pis lmien orom en kat. Ko kun mnam a venloot to en ta vle mnam, klenar msim ruk lIsrael kavurgem ngta ker kol vgum a yor to a lepra vanangko E Nut thavaeng e Elaisa kam lua parrum tang mnam mar hak. Vanang ta kle khavaeng kam le kparrum a vrong rhek langto yok tuk, endo e Naman to nkong mSiria en kam kta nho lya pum E Nut kalo keik.” ");
INSERT INTO sua_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","E Yesus ta rere tok knop, to o mia tgus ruk ngata ngan karo rhek kun mnam o Yuda nga rek to kam rere mnam, ngta tar ko ta kekner mar orom karo rhek ruk tok, to ngakro vurkul ngat ho mi ktua kiin ngang hak. ");
INSERT INTO sua_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","To ngta kapom he kait kngorom ngogu mnok petgim a rengmat kngorom ngok kia veik to a rengmat to endo ta vle kuon malpgem, mar kam vle kngam ogu. ");
INSERT INTO sua_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ngat pis ko tok, he re kngam ogu va ta kle her gia ngongae kmommen mar to her gia parem mar. ");
INSERT INTO sua_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","33","To e Yesus ta ngae ngogu mnam a rengmat laut to e Kaparnam kun mnam a mhe to e Galili. Ta pis to kvaik kun mnam o Yuda ngarta rek to kam rere mnam to ko tok, he kpos ngang o mia tie ma Sabat. O mia vang ngta vongnek kim to ngate sei kmit ngaongtok kim karo rhek ko en tle ktua patter mar orom kta serppak mruo to yok gi. To kun mnam o Yuda ngarta rek to endo a mhel langto a koot to nong a yar hak tim he kaenvevem ta vle kun pgegom mar kat. Ta vle to a koot ta vuvui klik kim e Yesus te, ");
INSERT INTO sua_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ai! Yin a mhel to endo kua mnor miik, yin e Yesus to nkong mNasaret. Yindo E Nut Tmur Re Pum Yin. He mor o kool ngot lua mtom yin kam pis he ktoop kmor mo e. Ya pis moti kam rum kim mor, i nop gi?” A koot ta vuvui klik tok, ");
INSERT INTO sua_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","vanangko e Yesus tkaen a re to a serpgar ngang a koot to endo te, “Ngiak tu ko he. Ottek kun mnam a mhel to.” E Yesus ther gia havae tok, to a koot tkootmerom a mhel to endo kngam ogu mmie kun pgegom mar, to thera parem. Vanang a koot to endo tlua kering a mhel to e. ");
INSERT INTO sua_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","O mia tgus ngate gi mrua sor kmar to kaelha kmo mnganang ngar te, “Ngola, a mhel ta tem anito e? Ko karo rhek ruk endri ngat ho mi ktua serppak hak! Vokom na, si o kool va tgia kererik orom karo gi rhek ruk ngat vua serppak.” ");
INSERT INTO sua_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ekam tok, a re to mang en ta ngae he kvaas kim o mia kun mnam o mhetor tgus ruk mnam a mmie ka mhe to endo. ");
INSERT INTO sua_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","E Yesus tkootpum ko mnam o Yuda ngarta rek to kam rere mnam to hera ngae klapsa ngok mnam e Saimon ka rek. Kun mnam a rek to endo e Saimon ka snerip to a vlom ta yayor vgum a manakain ko tsei kam ngae kun mnam. To e Yesus kalngunes ngat kaurur kim mang kam turang. ");
INSERT INTO sua_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","E Yesus ta kol a re, to ta ngae kpis ksir ko vanam ka hep to keep he kaen a re ngang a manakain to kun mnam orom karo gi rhek. To a manakain ther gia nop kun mnam hak. Va a vlom ther gia hop ku ngatngae to hera krong o ol ngang ngar. ");
INSERT INTO sua_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","To mnam a kolkha to endo gi ko ta rorongmia, o mia ruk ngta yayor orom o yor ngo mamten, ngarlenar ngta plalam mar ngok kim e Yesus. Va ther gi kaehang o yor kuo mang langto langto mnam mar kmeharom mar tok va ngat her gia ya ngatngae. ");
INSERT INTO sua_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Si o kool kat, va tkererik kun mnam o mia. Ii, o kool ngat vuvui kuon mail klik kam re te, “E Nut Khal to yin” to her le kotoot pum mar. Ngata vuvui tok, vanang e Yesus tho gia kser mar kam hagam mar kam ho lo kta rere mang en kam polger o rhek mang en tok hak ko ngat mur mnor mang en te, her en arhe Endo E Nut Thim Orom Ka Msasaen. ");
INSERT INTO sua_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","To hop enang ngmo, e Yesus thop halki kparem a rengmat to endo, nang kngae ngok ma gi lootpgeik kam ngarkie. To o mia ngat kaelha kam riring. Ngata riring kam ngae kngae to ngate pis mang. To ngat re kam hagam te, en kam lo kta ngae parem mar kat e, ");
INSERT INTO sua_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","vanangko ta kokheng ngar te, “O-o, ngua ktua ngae ge kun mnam o rengmat akuruk yok kat, kmelha kpolger o rhek ruk mang E Nut ka tavgo ko tpis he komor o mia, ko E Nut tmi kut meng dok kam mi kut kaeha tok arhe.” ");
INSERT INTO sua_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","To thera ngae kaelpun kvaik kottek kun mnam o Yuda ngakro marhok tgus he kaelha kpolger o rhek kun mnam ngartaro rektor ruk ngma rere mnam mar. ");
INSERT INTO sua_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","To mnam a kolkha langto kun mnam o kolkhek ruk endruk e Yesus ta sir ko vanam a ngaenker to e Genesaret he kpatter o mia. Va o mia ngta sovet kam mopet kam gun ngok kim kam konner kam ngan E Nut karo rhek ko ta patter mar ormar. ");
INSERT INTO sua_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","O mia ngata sovet kam mopet ngok kim enang tok, to ta sir va ta nho kvokom alo langail ruk o mia ngta khie knop he it min el min ko paat, nang ka plum ngaro klui. ");
INSERT INTO sua_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ekam tok, e Yesus ta kar mnam langto mnam min, endo mkor e Saimon, to hera reng kam vrua korsom orom oguon va ngaenker ka ngaiting, vanang en tkorsang mnam he kaelha kam patter mar ko tok. ");
INSERT INTO sua_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ta patter mar kngae knop, to kreng e Saimon te, “Saimon, si vur poe orom a langail ngogu ma vvuommok he yin kar ilenar mu ngam mularo klui.” ");
INSERT INTO sua_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Va e Saimon tkoripang te, “O-o, Kua taven, kua kees ko ngot si kaegom egom mnam a segain to tenkier va ngot ho sim mur kaenang ngor hak, ngot ngae ho gi mos hak. Va ko tevanie, ekam ko ya reng ngor, ngurer gi vrong kta ngmar kat na.” ");
INSERT INTO sua_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ngta ngam ngaro klui ogu ma ngaenker, to o singol ka ho vurgem hak ngat pis roro, to ngaro klui va ngat re kam gia kassir hak. ");
INSERT INTO sua_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ngta vokom tok, to ngta tger ngaro lpetuk kim ngarlenar kmaol orom a langail langto kam turang ngar. To ngta klang alo langail tgus ngint ngae ho mi kut ottep hak ketasuo min tgus kam vvuo. ");
INSERT INTO sua_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","To e Saimon Pita ta vokom tok, to ta tubulkek ku penharom e Yesus to kreng te, “O-o, koldaip, klo vu kais, yin kam vle mo kmok e, ko dok kuaro vu kerkeknen.” ");
INSERT INTO sua_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","E Pita ta re tok, ekam ko en kar klenar ngate sor kim o singol vang ruk ngat kaum mar. ");
INSERT INTO sua_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ii, mar kar e Sepedi klo hal e Yems va e Yoanes ennginduk nginma kaikkiem e Pita, mar tgus ngate gia sor kim o singol tok. E Yesus ta ngan e Pita karo rhek ruk endruk tok to thera reng e Saimon Pita te, “Ngiak or kam kta gor kat e, ko kmelha tete kngae, ila ngaeha to kmit singol ta tu ko he, nang ngir kle va kaelha kmit o mia ngok kim dok mekam mekam.” ");
INSERT INTO sua_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","E Yesus ta re tok knop, to e Saimon Pita mar ngta poe kvaar to her kait ngalo langail kael min ko paat, to her korim ngaro reha tgus ruk kmit o singol orom ngaro klui va ngaro laktok, nang her kle kaikkiem. ");
INSERT INTO sua_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","E Yesus ta vle kun mnam a rengmat langto, va vgum a mhel langto tkol a yor to a lepra ko tpis ko kim. A mhel ta, ka yor tho mi kut rum ka vok tgus hak. Tre vokom e Yesus va ther gi konit ka vham ku mmie kmaurur kim te, “O, kolaip enangthe ngia svil va yi kais kmeharom dok, he dok kam kta vle la mmok ko pum E Nut kalo keik kat.” ");
INSERT INTO sua_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","To e Yesus ta tuom ka ktiek he gi kaehang va gia reng te, “Mare, kua svil! Ila vok na ngae gia mmok.” A gi hi to tgia re tok, ka yor ther gi nop kuo mang ngatngae. ");
INSERT INTO sua_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","To e Yesus ther kaen a re lserppak ngang te, “Ngiak or kam havaeng a mhel tang hak mang a ngaeha to ko eharom ngang in. Vanang ngiak kle va kngae ngok kim a pris tang, en kmehehang yin, en kam tting mang in te, lmien te, yi ho mi mmok ko pum E Nut kalo keik kat he. Ngiak kaeharom tok, to kle kngae ngok mnam E Nut ka maksien kam nngiar ngang E Nut, kmikkiem gi enang ko e Moses ka pos langto ta keknen tok mang a yor to endo ko yi her ottek mnam he. Ngiak kaeharom gi enang tok, nang o mia ngaro ngaongtok kmisis mang yin te, lmien te, yi ho mi mmok kat he, ko pum E Nut kalo keik.” ");
INSERT INTO sua_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","16","Tsi reng a mhel to endo kam lua polger rhek mang tok, vanangko o rhek ruk mang e Yesus ka munik ta kle ho gia senekerik kngae gi, he o mia ngo valngneik ngta ngongnek he kirpapagis ko kim kam vongnek kim va en kmeharom mar pum ngaro yor kat. Tkaeharom mar knop, to her le gi vur kaol kparem mar to kngae ngok ma gi lootpgeik kam ngarkie ko tok. ");
INSERT INTO sua_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","18","To mnam a kolkha langto E Nut tkat kaenkrovgem e Yesus orom ka serppak kmeharom o mia akuruk yok pum ngaro yor. Tkorsang kun mnam a rek langto ko mGalili ko pum o mia ngo kerok he kpatter mar, va a valngan langto orom o Parisiau kar o pattermia kmo pos ngat korsang he kvongnek kim kat. A valngan to enda ngat ottek mnam o rengmat tgus ruk ko mnam e Galili, va e Yudea. Va si a rengmat laut to e Yerusalem kat va akuruk ngat ottek kun mnam a rengmat to endo he ka vle ko kim. Ta patter mar kngae kun mnam a rek to endo, va vgum o mia ko ngta kokol a mhel langto ka vok tgus tyor he kaegom kam pis ko kim orom. Ta kru kun mnam ka hep, he ngat pis orom he kring longmok ekam kam kol he kvaik orom kmel ko kim e Yesus. ");
INSERT INTO sua_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ngata ring longmok ekam, vanangko ngat lo is e, ko o mia vang he ngata totok. To ngat le ka grap he khalker a rek ka keik kmel a longmok ekam kuo malpgem e Yesus lsir. Ngata halker a rek ka keik knop, to ngta kol a hep to orom a yor, to ngat her konget a mhel to enda orom o usiel ruk ngta kleng ka hep orom mar. Ngat konget ngok pum e Yesus kalo keik ko tok kun pgegom o mia. ");
INSERT INTO sua_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","E Yesus ta vokom mar ko ngat vu kor mnam mar mang en enang tok, to thera reng a mhel to endo te, “Lakai, dok mruo ko lol ilaro kerkeknen patgiang ngaiting he kikiangae mang ngar hak.” ");
INSERT INTO sua_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ta re tok, to o Parisiau va o pattermia kmo pos ngat kaelha kam mngan pum te, “Hai-e, ani mhel ta e, ko en ta kerrereng E Nut ka munik tok arhe! Ko ta mrua tattap orom en mruo te, en E mi Nut msim orom karo rhek ruk endruk. Ii, ko gi E Nut tuk to tis kam lol o mia ngaro kerkeknen patgiang ngaiting, nang nong o gi vrong mia e, nop hak!” ");
INSERT INTO sua_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","E Yesus ta tar mar ko ngat vua rere porom mar kam mngan pum en enang tok, to ta kle ka mnganang ngar te, “Mularo vurkul ngta horrotgi pum dok kman? Va kman ko muta mngan pum kua serppak to kam lol o mia ngaro kerkeknen patgiang ngaiting he kikiangae mang ngar tok? ");
INSERT INTO sua_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ani ngaeha to ta koppet kam khenam ma mmok? A ngaeha to kam gia reng a mhel ta te, ‘Ko lol ilaro kerkeknen patgiang ngaiting’, i o endo kam mi kaeharom a mhel ta, he en kam mia hop he kngae ko pum mularo kerok? ");
INSERT INTO sua_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Vanangko tgia ya kat e, ko ngor mia khenam ma mmok ngang nguk te, E Nut tmi en a serppak ngang A Mhel To Nkong Man Ma Volkha to dok, dok kam lol o mia ngaro kerkeknen patgiang ngaiting mo mmie he kikiangae mang ngar.” Thavaeng ngar tok, to her gia reng a mhel to ka vok tgus tyor te, “Yu! Kua havaeng in te, hop he, tolpum ila hep he kngae ngok mrek.” ");
INSERT INTO sua_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","A gi hi to e Yesus tgia re tok, a yor to endo ther gia hop ksir ngatngae ko pum o mia ngaro kerok ko arhe, he ktolpum ka hep to tesgun ta kru mnam to her kaelha kam hover E Nut ka munik va kngae ngok mrek. ");
INSERT INTO sua_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","O mia ruk ngta vokom a ngaeha to tok, ngat ngae gia nganga kim, to ngata gor he kguyaya pum E Nut kam mo havaeng ngar te, “A mhel ta tmi kut kael senkrip kim mor orom karo reha ruk lserpgue, endruk yok gi ngot vokom mar tete.” ");
INSERT INTO sua_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","To kopekam ko teharom a mhel to endo, e Yesus ta ngae kparem mar. Ta ngae va kvokom a mhel langto ka munik e Livai, ko tkorsang kun mnam o kermia ruk ngam kaelha klol o takis nga rek to kmelpas mnam. E Yesus tpis ko kim to kreng te, “Ngiak kaikkiem dok!” ");
INSERT INTO sua_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ta re tok, to e Livai ther gia hop ku korim kakro reha tgus ruk endruk ko tok to her kle kaikkiem. ");
INSERT INTO sua_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kam ngae, to mnam a kolkha langto e Livai tkaeharom a ngorsang to alaut ngang e Yesus ko mnam ka rek. Va o kermia kavurgem ruk ngam kaelha klol o takis kar o Yuda akuruk, endruk ngalmialaol ngma keyang ngar ko ngam lo sim kut kaikkiem o Yuda ngaro keknen, ngata kaum kaemik ko kim e Yesus kar kalngunes kat. ");
INSERT INTO sua_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Vanangko o pattermia kmo pos ruk o Parisiau ngat kaelha kam kirhek pum e Yesus kam palsie kim kalngunes te, “Ngola, kman ko mum kaemik va kaivie ko kim o kermia ruk ngam kaelha klol o takis kar o Yuda akuruk, endruk ngolmialaol ngma keyang ngar ekam ko ngam lo sim kut kaikkiem mor o Yuda nguaro keknen?” ");
INSERT INTO sua_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Va e Yesus tkoripang ngar te, “A mhel to nam kaeharom o mia nma vle mang endruk ngo yor kmeharom mar, nang nam lua vle mang endruk ngat gia ya e. ");
INSERT INTO sua_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","He gi enang tok, ko her pis mo mmie kam vle mang endruk o mia ngma keyang ngar pum ngaro kerkeknen, he nang dok kam tger mar kmitgung ngar. Nang klua pis kam vle mang endruk ngam mrua kansgum mar mruo kam pat mang ngar mruo te, ngaro keknen ngat ho mi kut sir hak ko pum E Nut kalo keik e.” ");
INSERT INTO sua_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","E Yesus ta havae tok, to a valngan to mkor o Parisiau ngat kta mngan pum e Yesus mang ngaro keknen ruk nkong ngalmialaol ruk tennik te, “Ngua keknen to kam paal kmo ol ko pum E Nut kalo keik nkong ngolmialaol ruk tennik, nang nong lgunngae nkong ngar tete e. He ekam tok, kman ko e Yoanes kalngunes va o Parisiau ngartakor ngam kaikkiem ngua keknen to nkong ngolmialaol ruk tennik, endo kam paal kmo ol tgus ko pum E Nut kalo keik he smia ngarkie ngang, vanang itlengunes ngam kaeharom a keknen to a gunngar ta yek, endo kam venu mang a ngaemik va a ngaivie?” ");
INSERT INTO sua_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Va e Yesus ta tootkinre ngang ngar kam re lkoon mang ka yor mruo te, “Mnam a kolkha msim ko a mhel tkaenkim ktavlom, a ngokol to tre kam lei tlo kais hak kam gia hover klenar kam tivik pum en mruo e. Ho mi kut nop hak. ");
INSERT INTO sua_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ko o kolkhek ruk kam tivik mnam mar ngrok ge. Ngara pis ko ngaka vret a mhel to mkor kalngunes, yek endo yek, kalngunes ngara mrung he ktivgim ko yek.” ");
INSERT INTO sua_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ta tootkinre tok knop to kle kaenserpagam ka papat to endo mang en mruo kam kta koka kat te, “Mu vokom na, a mhel nam lo kommen a yet to a gunngar kam kol ka kae langto to le kvatvat a yet ka kae to endo ko a gunngar engnang endo ka sgan e, matok na kering endo a gunngar ko ther kommen he. Ko a yet ka kae to a gunngar ner lua maenang endo ka sgan kat e. ");
INSERT INTO sua_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ii, va ngam lo kaeharom a ye to a vaen, endo a gunngar kun mnam ka merrip to ka sgan kat e, ko a merrip to ka sgan ta karrai he nera khir. Ngam lo kaeharom tok, ekam ko a vaen ka serppak, ko nak hop kun mnam ka merrip, ner kaur mang ka merrip to endo ka sgan he khalker. To a vaen nera gussuk. He enang tok, a vaen ka merrip nera kernonho ekam ko a merrip nera khir va a vaen nera gussuk kat. ");
INSERT INTO sua_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nove, o mia ngam lo kaeharom tok e. Ngam kle va kaeharom a vaen to a gunngar kun mnam ka merrip to a gunngar kat ko tgi kongeik. ");
INSERT INTO sua_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ii, vanang mu vokom na, endruk ngam kaiviem a ye to a vaen to ngat eharom tennik he her ngan mgaem, her mar ruk arhe ngam gia tagur pum kmiviem, nang kle keyang a vaen to a gunngar he lua lua svil hak kmegom e. Ii, ngam kle gia re te, ka dok ma vaen to ngat eharom tennik ha, ko tvua mgae hak kir kim endo a gunngar.” ");
INSERT INTO sua_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tie ma Sabat langto, e Yesus kar kalngunes ngat kaikkiem a ngaelaut to ta kser a loot langto orom o sigla. To kalngunes ngat kaelha kam kolonget o sigla he kaemik. ");
INSERT INTO sua_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ngat kaemik kngae, to o Parisiau akuruk ngata pis kpalsie kim e Yesus te, “Hai! Kman ko muta kpoot mang ngua pos to kam paal ma Sabat?” ");
INSERT INTO sua_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Va e Yesus tkoripang ngar te, “Nok pathe mut lo him a ngothoi to mang e Devit kar klenar ko ngta vang vor? ");
INSERT INTO sua_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ko a ngothoi to endo ta havae mang e Devit, ko tennik ta mrung klenar he kvaik ogun mnam E Nut ka maksien rek Ka Taban To A Totur he klol o bret ruk o Yuda ngam kaelik ko kim E Nut. Tkol to kle kaisis kim kalngunes ormar va mar tgus ngat kaum kaemik mnam mar. Ngat si eharom tok, vanangko nguaro pos ngat havae te, o pris ruk laol tuk ngat gi kais kmem o bret ruk endruk.” ");
INSERT INTO sua_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","He kmikkiem a ngothoi to endo tok kat, e Yesus thavaeng ngar te, “A Mhel To Nkong Man Ma Volkha nma mrung o mia enang tok kat he ka nho mang a kolkha to a Sabat!” ");
INSERT INTO sua_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tie ma Sabat langto yok vat, e Yesus tvaik kun mnam o Yuda ngarta rek langto kam rere mnam he patter o mia. Va a mhel langto ka miktiek tyor ta vle ko kat. ");
INSERT INTO sua_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Va o Parisiau kar o pattermia kmo pos ngat sim ktua keketar ko ngta papat kam mon e Yesus orom a kerkeknen tang enangthe naka kpoot mang a pos to ma Sabat he kaeha kmeharom a mhel to endo. ");
INSERT INTO sua_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Vanangko e Yesus ta ktar mnor he mang ngaro papat, to ta reng a mhel to ka miktiek tyor te, “Hop he aol ngte he sir ko vanam dok na, he o mia tgus kam vokong in.” To ta ngan vgum e Yesus to hera hop sir. ");
INSERT INTO sua_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","To e Yesus thera mnganang ngar te, “Kmikkiem mor o Yuda nguaro pos, ani ngaeha to ta sir kmeharom ma Sabat: endo kmennegiang a mhel en kam yor, i o endo kam turang he kaeharom kam ya.” ");
INSERT INTO sua_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Thavae tok, to ka lo keik ngint kaem o mia tgus to thortgi he kreng a mhel to endo te, “Yin he, tuom ila ktiek ngte na.” Tre gia tuom ka ktiek va te, ka ktiek ther gi ya hak ngatngae. ");
INSERT INTO sua_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","He ekam tok, o Parisiau ngaro vurkul ngat ngae sei kam kiin ngang hak to ngat kaelha kam lgem o rhek mang e Yesus te, ngak rum kim nngia. ");
INSERT INTO sua_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","To mnam o kolkhek ruk endruk e Yesus ta grap ngoguon ekam ke vul langto ka ngaiting. Ko tok mnam a segain to endo tgus kngae kais marot ta ngarkie ngang Ngoldaip. ");
INSERT INTO sua_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","To hop enang ngmo, ta vaeng kalngunes tgus kam kaum ko kim to hera momon endruk loktiek hori orom alomin, he le kilegem mar te, o aposel. ");
INSERT INTO sua_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mar ruk endri te: e Saimon endo ta kilegem te, e Pita, en kar knopia e Andru; e Yems, e Yoanes, e Pilip, e Bartalomius, ");
INSERT INTO sua_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","e Matyu, e Tomas, e Yems to e Alpias khal, e Saimon to nma vle kun mnam a valngan to o Selot, ");
INSERT INTO sua_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","e Yudas to e Yems khal va e Yudas to nkong mIskariot, endo thortgi mang e Yesus kmel ko maktiegom o kermia koknaik mang a kolkha to endo gi ko e Yesus tvaeng. ");
INSERT INTO sua_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","E Yesus ta momon karo aposel knop, to ngta grung kpis ku pa vul ko ma gi sirsirmok to ngta kaum kar kalngunes akuruk kat ko tok. Nang a mumu alaut hak orom o mia ngo valngneik ruk mnam e Yerusalem va mnam o mhetor akuruk yok kun mnam a mhe to e Yudea va endruk nkong ngar mnam alo rengmat ruk ku va mou nginalo munik te, e Taira va e Saidon ngat hera pis he ka vle kpaneng kam vongnek kim va en kmeharom ngakro yor. Ii, va endruk o kool ngat kaim mar kat, ngata papagis ko kim, he ta pepet o kool kun mnam langto langto mnam mar. ");
INSERT INTO sua_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","He ekam tok, o mia ngat kaelha kam ho gi kaenenker kmehang ka vok kam kol ka serppak to nama lol endruk ngata ktar pis kaehang ko ngma ya vgum tok. ");
INSERT INTO sua_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","26","O mia ngta vle tok, to e Yesus thortgi ngok kim kalngunes he kvokom mar to hera reng ngar ti te, “Muk ruk muma tu kmo tgoluk tete, muta lgekol ekam ko her muk ruk arhe E Nut ka tavgo ta vle kuon mang nguk. Vanang suvrum muk kelenar ruk mut kais kmo tgoluk tete ko mut hera higiang ngar ngatngae he. Muk ruk muma vang tete, muta lgekol ekam ko her muk ruk arhe E Nut ner kaeharom mularo vurkul kmisis. Vanang suvrum muk kelenar ruk muta vi tete ko, a vang alaut nera pis kmuk. Muk ruk mum kaee tete kat, muta lgekol ekam ko her muk ruk kat arhe E Nut ner kaensireim muk kam halla. Vanang suvrum mu kelenar ruk muma sirei he khalla tete ko mguer kle kvor pa ngaor va ktolpum o ngoven he le kaee mang nguk mruo ko mguera yor. Muk ruk o mia ngam kaelat muk he klikim muk, ksisieng nguk va kerrereng nguk orom o rhek ruk la ppiagar ekam A Mhel To Nkong Man Ma Volkha, her muk ruk kat arhe muta lgekol ekam ko her muk ruk E Nut tel a keik to alautar kam paneng nguk kuon ma volkha. Mu vokom na, mguak sirei he kpum rengtek kun mnam a kolkha to o vnek ri ngat lol muk ekam ko mut kolkol ekam o propet ruk tennik, ko ngarores ngata ktar kaeharom o kerkeknen ruk endri ngang ngar tok kat. Vanang suvrum mu kelenar ruk muma svil mang o mia kam kanprim muk tete, ko mguera vle gi enang o propet ruk la ppiagar tennik endruk ngalmialaol ngma kanprim mar tok kat.” ");
INSERT INTO sua_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Vanang muk ruk muta vongnek kim dok tete, kua havaeng nguk tgus te, endruk ngak sisieng nguk ko ngat kael imuo ngang nguk tok, mguak kle kaelongtok mang ngar ge. Va mguak ya pum endruk ngam vu kaelat muk kat. ");
INSERT INTO sua_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mguak ngamyammok mang endruk ngama re orom muk kam yor. Va mguak ngarkie mang endruk ngma koskalil orom muk kat. ");
INSERT INTO sua_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Va enangthe tang mnam mar na kol a regesal mang in kam spom ila pis va ngiak hortgi el langto naka spom kat. Tok kat, enangthe tang na vret ila yet petgim yin va ngiak or kam krum kmen itang langto ngang malpgem endo kat. ");
INSERT INTO sua_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Va muaka tting ngang o mia ruk ngap kaurur kmuk kmel o tol ko kmuk kat mar kam lol mularo tgoluk. Va enangthe a mhel napa lol mularo tgoluk va mguak or kam kta papat mang ngar kmoripang ngar ngang nguk kat e. ");
INSERT INTO sua_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mguak kaeharom gi enang tok, ekam ko oni keknen ruk muma svil mulenar kmeharom mar ngang nguk, va muk kat mguaka ktar kaeharom mar ngang mulenar enang tok kat. ");
INSERT INTO sua_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","34","Va enang ko mum gia khen endruk ngam kaelongtok mang nguk va muk ormar, i o enangthe mgua gia khen mulenar ruk ngma ya pmuk va muk ormar tok kat, i o enang ko muma tting ngang mulenar kmel a tol ko kmuk, ko muma pat te, mar kmoripang mularo tgoluk, va mut lo is hak kam kol a keik ko mkor E Nut e. Ko si endruk mor o Yuda ngalmialaol ngoma keyang ngar ko ngam lo sim kut kaikkiem nguaro keknen, va ngam gia khen nglenar va nglenar ormar tok kat. ");
INSERT INTO sua_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","36","He ekam tok, mguak or kam vle enang ngar tok e. Vanang muk, si orom mularo imuo vat, va mguak kle kya pmar he ka tting ngang ngar kmel a tol ko kmuk, nang or kam kta papat mang ngar kmoripang ngar ngang nguk kat e. Mguak kaeha tok, kmikkiem enang ko E Nut nma ya pum endruk ngma kulpang va gia prik. Va nma ya pum endruk ngat kernonho kat. Mguaka mrung o mia kat kmenang mu Teit ko En nma mrung o gi vrong mia tgus kat. Va enangthe mupa vle tok, va E Nut ner kaen a keik to tho mi laut hak ngang nguk va mguera vle te, Endo A Ho Lautar Hak kles ruk muk enang tok.” ");
INSERT INTO sua_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","38","“Va mguak or kam tutut kam mon o mia orom ngaro kerkeknen, matok E Nut nera mon muk tok kat orom mutakor. Ii, ner kaekon ngang nguk kam mon muk orom mutaro kerkeknen kmikkiem gi enang ko muma mon o mia tok kat. Va mguak or kam tutut kmel o mia kam kol a kapnes pum ngaro kerkeknen kat e, matok E Nut ner le kael muk kam kol a kapnes pum mutakor gi enang tok kat. Va a kapnes to endo ner kle ho kpunpum he ner ho ka mnek hak. Va mguak lol o mia ngaro kerkeknen patgiang ngaiting he E Nut ner le klol mutakor patgiang ngaiting tok kat. Ko kmikkiem enang ko muma lol o mia ngaro kerkeknen patgiang ngaiting tok, E Nut ner sim kut koripang nguk gi enang tok kmo iser muk kat kam lol mutakor patgiang ngaiting. ");
INSERT INTO sua_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","40","Nok muma pat te, mut kais kam gi mrua vavle orom muk, kam gia laut mang dok vor. O-o, nove, ko a pattermia kalngunes ngat lo kais kam gi mrua vavle orom mar kat he klaut mang nga pattermia kat. Vanangko ko pekam ko a kalyie langto nak lol o papat vgum ka pattermia kais ko npa rum mar, yek endo yek a kalyie to endo kakro papat ngara laut kmo iser ka pattermia enang tok kat. Ii, va alo vivisker kat ngint lo kais kam mo kpom min he kmo ktong ngin kngae e, matok min tgus nginera kaum kaol pa huop ko min tgus ngint gi mo is ko ngint vipsik. ");
INSERT INTO sua_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ii, ta vle tok kat arhe ngang nguk, ko kman ko im smia kellu kam vokom a kvak to kun mnam inopia ka keik nang lua paptang a ho kla vgon ko pita keik mruo? ");
INSERT INTO sua_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","He enang tok, yi kais kam smia nho nngia kam mon inopia orom ka kerkeknen to ta vle enang a gi kvak kun mnam ka keik, vgum ita kerkeknen tok kat ko ta vle enang a ho kla vgon kun mnam itang. O-mularo naprai alomin hak! Ngiaka ktar khong a ho kla vgon ko pila keik mruo na, yek in kam le smia nho kam pet a kvak ko pum ila kta keik vat.” ");
INSERT INTO sua_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","44","“O mia ngma vokom ka mnor mang o hi ngo mamten ruk lyar vgum ngaro miel ruk lyar tok kat. Va o hi ruk nong lyar o mia ngma vokom ka mnor mang ngar enang tok kat, ko o mia ngam ngae lua tamar o vlus ko vgum a hohoi e. Nove. Va ngam lua tamar o paslura ko vgum o gigi kat e. Nove. He kmikkiem enang tok, a ho to ta serppak tho lo mi kais hak kmehi orom karo miel ruk ngta mgulglang e. Va a ho to tre kam vui kat tho lo mi kais hak kmehi orom karo miel ruk ngta karvuk kat e. ");
INSERT INTO sua_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","He o mia ngma vle tok kat, ko a mhel to a yar kat nma khenam o keknen ruk lyar ko ngam kottek kun mnam ka vrek ko nam kaelpas orom mar ko tok. Vanang a mhel to nong a yar nam kle ktua khenam o kerkeknen ruk ngam kottek kun mnam ka vrek ko nam kaelpas orom mar ko tok kat. Ii, ta vle tok, ko o gi vrong keknen tgus, endruk lyar va endruk nong lyar ngam kottep kun mnam a mhel ka vrek ko nam kaelpas orom mar ko tok, yek ngat kottek ko nma rere ormar.” ");
INSERT INTO sua_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ekam tok, mguak or kam gia kvam dok te, ‘Koldaip,’ ko mum lua ngan vgum dok e. ");
INSERT INTO sua_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ngor kothoi mang a mhel ka mten to nma kanko kam pis mo kmok he kvongnek kim kuaro rhek to le kngae kaikkiem mar mekam mekam ko a mhel ka mten to endo tkaenang ");
INSERT INTO sua_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","a mhel to tkaeharom ka rek to tvua serppak ko ta hek ngogu hak he kvatvat o ngtek ko engnang a kre to klalaut ku ma mmie. Ta hover krum, to a ye tkottek to ka slul orom, vanangko tlo kais kam lget e, ekam ko karo ngtek ngat gi serppak ngae gi ringring hak ku ma mmie ko tsim kut papuntom hak. ");
INSERT INTO sua_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Vanang a mhel to nma vongnek kim kuaro rhek, nang kle gi kaengnam mar, en ta kle kaenang a mhel to tkaeharom ka rek, nang lo smia papuntom ko tlo smia hong a mmie kam srim o ngtek kat e. Tgia srim karo ngtek kuo mang a mmie. Ta hover krum, to a ye tkottek he ka slul orom a rek to endo va ther gia kviet kol kngorom ngatngae.” ");
INSERT INTO sua_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","O mia ngta vongnek kim e Yesus ko ta rum karo rhek ruk endruk, to en thera ngae mKaparnam. ");
INSERT INTO sua_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ko tok mKaparnam, a vrong rhek langto ta vle. En lRom nga ngaomevek ka rkan langto kalaip. Va kalkayie langto nam vua svil mang ta yayor he re kam yor he. ");
INSERT INTO sua_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","To a mhel to enda tre ka ngnek te, e Yesus tpis ko mKaparnam, to thera meng o Yuda ngalmialaol akuruk kam ngae ka mnganang, en kam pis he kaeharom kalkayie to endo. ");
INSERT INTO sua_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","To ngta ngae kpis ko kim, he kaurur kim kmonget o rhek ngang mang ngalaip to endo ko tmeng ngar. Ngata reng te, “A mhel to enda, en a vrong rhek langto, vanangko en ta vat kar mor lIsrael he kturang ngor kat ko ten o krek ngang ngor kam ngam mor lKaparnam ngorta rek to kam rere mnam, he ekam tok, a mhel to enda tkais te, yin kam turang kat.” ");
INSERT INTO sua_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","E Yesus ta ngnek tok, to her kaikkiem mar ngok kim ngalaip to endo ka maksien he. Ngta re kam konner a mhel to endo ka rek, vanangko a taip to endo kalngunes akuruk ngata puknim e Yesus ko ekam a ngaelaut ekam ko a taip tmeng ngar kam hagam e Yesus kam lua pis. To kalngunes ri ngat havaeng e Yesus orom a taip to endo karo mur rhek mruo ti te, “O-o, kolaip klua svil kmelkeyang yin, ekam ko dok klo vu kais, yin kam mrua ppir miik kmaol ngte kim dok e. ");
INSERT INTO sua_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","He ekam tok, klo vua pat mang dok msim kam mia pis ko kmin ekam a ngaelaut e, kam havaeng yin kmor kam pis ko kim dok. Vanang ngia her gia mon a re ke vgon tang kmeharom kolkayie tok, to a yor to kuo mang na her gia ngan vgum yin kparem ngatngae. ");
INSERT INTO sua_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngia her gia mon a re tang tok, gi enang ko dok kat koma ngan vgum endruk ngta laut va ka nho mang dok, vanang kle kreng endruk ngma kar va tomten mko meorom dok ko kua nho kmar va mar ngam her gia ngan vgum dok tok kat. Ko kom re gia reng a mhel ta te, ‘Ngae’ va en ner gia ngan vgum dok he kngae. I o kom re gia vaeng a mhel to en tko gut te, ‘Aol’ va en ner gi kaol ngte. Va kom re gia reng kolkayie to kat te, ‘Eharom a ngaeha ta’, va en ner gia ngan vgum dok he kaeharom.” ");
INSERT INTO sua_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","E Yesus tre ngan o rhek ruk endri tho mi kut senkrip kim hak to le khortgi ngok kim a mumu to ta veet ekam to kreng ngar te, “Kua havaeng nguk te, a mhel ta, en tpua vle te, en a vrong rhek langto, vanangko tvu kor mnam en mang dok ge. Va si kun mnam muk lIsrael lsir hak klo vur pis mang tang enang en, ko tkor mnam en mang dok enang ti e.” ");
INSERT INTO sua_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Thavae tok knop, to a taip to endo klenar ngat her kaekeknik ngok kim, he kvokong kalkayie ko ther ya he. ");
INSERT INTO sua_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","To vur koknaik he, to e Yesus ta ngae ngok ma rengmat to e Naen va kalngunes kar a mumu to alaut ngta veet ekam kat. ");
INSERT INTO sua_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","E Yesus ta konner a rengmat ka gu, va vgum o mia akuruk ko ngta kokol a yor langto orom ka hep he kottek orom kam ngae kael. A yor to endo, en a kalyie to ke tro. En tuk nma vle ko kim knan to a tahek ko kteit ther yor parem he. Va o mia ruk nkong ngar ko ma rengmat to endo ngta kaum ko kim knan orom. ");
INSERT INTO sua_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ngoldaip tre vokom a yor knan, va tho mi kut mrung hak. To ta hagam te, “Or kmaee e.” ");
INSERT INTO sua_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","To thera ngae ngogut kim endruk ngta kokol a yor, to her kaehang a hep to endo. Ngta vokom tok, to her gia sir. To e Yesus tgia reng a yor to te, “Vae, kambis, kua havaeng yin, hop he.” ");
INSERT INTO sua_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tre gia re tok, va a kalyie to enda ther gi kta ktal kat to hera hop korsang to kaelha kam rere va ka grung ksir ku mmie, to e Yesus thera ktong kngorom kam ngae pis kat kael ko maktiegom knan. ");
INSERT INTO sua_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","O mia ruk ngta vle ko tok ngat ngae gia sor kim to kaelha kam hover E Nut ka munik kam re te, “E Nut ta tavger a propet to alaut mo pgegom mor ko E Nut ta ptang ngor he kre kam sulgim mor karo mia ruk ormor vgum, he nang en kam hong ngor pum nguaro imuo petgim mor.” ");
INSERT INTO sua_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","To a re to mang e Yesus ta ngae mnam o rengmat tgus ruk mnam e Yudea va o rengmat ruk malhagenmok mang kat. ");
INSERT INTO sua_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","E Yesus karo reha ruk lserpgue ruk endri ngta pagis tok, to e Yoanes to nma parrum o mia kalngunes ngta havaeng e Yoanes mang ngar. To e Yoanes ta vaeng kalo kaloyie aloruk ");
INSERT INTO sua_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","to kmeng ngin kam ngae smia kol a re tang ko kim Ngoldaip to e Yesus kam mnganang orom e Yoanes karo mur rhek mruo te, “Ngola, yin msim to e Moses ta ktar kpavap mang te, nak kaol, i o tang ngnok vop, mor kam paneng kam nho mkor te, en kam sulgim mor?” ");
INSERT INTO sua_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","To nginta kol e Yoanes ka mngan enang tok to kngae orom, to kpis ko kim e Yesus to her le ka mnganang tok arhe te, “E Yoanes to nma parrum o mia ta meng nguo ngte kmin kam mnganang yin te, ‘Yin msim to e Moses ta ktar kpavap mang te nak kaol, i o tang ngnok vop, mor kam paneng kam nho mkor en kam sulgim mor?’” ");
INSERT INTO sua_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mnam o kolkhek ruk endruk lsir, ko e Yoanes kalngunes ngta pis ko kim orom ka mngan, e Yesus nam kaeharom o mia pum ngakro yor ngo mamten kavurgem va kerer o kool kun mnam endruk o kool ngtim mar kat, va kaeharom o mia ruk ngta vipsik he ngta kta nho kat. ");
INSERT INTO sua_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ekam tok, e Yesus tkoripang e Yoanes kalo kayie te, “Meak kaeknik, he khavaeng e Yoanes mang o reha ruk endri ko met her vokong ngar ko akro vivisker ngata nonho, akro nharyor ngata ngongae, akro yor ruk o lepra ngata yaya ko pum E Nut kalo keik kat, va akro ngaelatok ngata ngongnek, va akro yoror ngata hohop kat. Va meak havaeng mang kuaro rhek ruk mut her nganik ko dok koma knovvur orom e Seten ngang endruk ngama tu kmo tgoluk ekam ko E Nut ka serppak tkir kim he. ");
INSERT INTO sua_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","He enang tok, endruk ngata ktar mokpom kar dok he lua lopumtang pum dok kam lua ksir petgim dok, her mar ruk arhe ngata lgekol.” ");
INSERT INTO sua_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","E Yesus thavae tok, to e Yoanes kalo kaloyie ngint hera ngae kparem. To e Yesus ta patter a mumu mang e Yoanes te, “Muta veet ngok ma kalputmok kam vokom e Yoanes ko ta vle nngia e? Pathe ta vle enang a mguit to a ngausgi nma koom vor ngola? O-o, Nove! E Yoanes nam lua vle tok e. ");
INSERT INTO sua_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","To erieto he muta putput kam vokom? Nok a mhel to nam vu kaegenkar karo it ruk orom ngakro kraen lvu yar hak vor, ngola? Nove, endruk ngam kaegen tok orom ngaro it ruk ngo kerok ngta grap kmenkim mar he ngma vle pum ngaro vu tgoluk ruk lyar, o mia ngma vokom mar ko ngma vle mo rektor ruk laol mkor o taven. ");
INSERT INTO sua_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Vanang mut veet kam vokong erieto lsir? Pathe nok a propet tang vor? Mare, he a propet to en tho mi kut laut hak kir kim akro propet tgus. ");
INSERT INTO sua_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Va ekam ko en tho mi kut laut hak kir kim akro propet tgus, her e Yoanes to a propet langto ta ktar kpavap mang arhe, ko tennik E Nut treng Endo Thim Orom Ka Msasaen mang te, ‘Vokom na, kua re kam meng kua propet langto, en kam ktar mang in, he en kam verang a ngaelaut ekam in ktar mang in kam pis.’ ");
INSERT INTO sua_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kua havaeng nguk te, e Yoanes tpu hop he klalaut kir kim o mia tgus mo mmie, endruk tennik kam ngae kais mang nguk tete, va si nong tang hak kun pgegom muk tete tlaut kir kim en kat e. Pu tok, vanangko ani mhel to ta vle ku meorom E Nut ka tavgo orom ka munik ko tkok lo vua laut, a mhel to endo ta kle klaut kir kim e Yoanes kat gi.” ");
INSERT INTO sua_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Nang o mia tgus ruk ngata ngnek ko e Yesus ta re mang e Yoanes tok, ngta ngatkal mang e Yesus karo papat ruk mang e Yoanes to le mrua havae mang E Nut te, E Nut karo papat ruk mang e Yoanes ngat ho mi kut sir hak. Va si o kermia ruk ngam kaelha klol o takis kat, va ngta ngatkal mang e Yesus karo papat tok kat. Ii, mar tgus ngat mrua khenam mar mruo ma mmok te, ngata ngatkal mang e Yesus karo papat tok ko ngat hera ktar ka tting ngang e Yoanes kam parrum mar. ");
INSERT INTO sua_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Vanang a valngan to o Parisiau kar o pattermia kmo pos ngta kees kam tting ngang e Yoanes kam parrum mar, he enang tok ngat mrua khenam mar mruo ma mmok kat te, ngat her el ngakro yaik ngang E Nut ka svil, endo kam kpom mar enang tok.) ");
INSERT INTO sua_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ngta vle tok, to e Yesus ta le kekner mar te, “Yu! Te ma te muk o mia ruk nga main to tete muta vle enang erie mar e?” ");
INSERT INTO sua_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nok mut kaenang alo valngan ruk orom o ngnes ko ngma kees kam tting ngang ngarlenar ko nginta kaum ko pum a gaep ka pun he kureik kmel ngakro ktui kim mar mruo, kmit ngarlenar kam khanier kar mar ko langto ta kni te: ‘Ngota pum a kamop kmit muk kmerep, vanang muma kees kam tting kmerep.’ Va langto tkoripang kam kni kat te, ‘Ngota kni orom a kni to a tningel kmit muk kmaee, vanangko muma kees kam tting kmaee kat.’ ");
INSERT INTO sua_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ii, mut kaenang ngar tok arhe, ko e Yoanes to nma parrum o mia ther aol he ikkiem ka keknen to kam paal kmo ol ko pum E Nut kalo keik va kam paal kmiviem a ye to a serpgar, he kureik kim muk kmit muk tok kat, vanang muk, muma kees kam tting mang en, nang kle krere kim te, ‘Hai-e, a mhel to enda a koot tim he envevem.’ ");
INSERT INTO sua_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ii, va mu vokom Endo Nkong Man Ma Volkha to dok kat ko ko her aol kat, he kaikkiem kua keknen to kam venu kmemik he kaiviem a ye to a serpgar he kureik kmel kua ktui kim muk kmit muk tok kat, vanang muk muta kees kam tting mang dok kat, nang kle krere kim dok tok kat te, ‘Hai-e, mu vokom na, ko a mhel to enda nma vle pum ka keknen to kam vu kaemik va kam vu kaivie he kveve, va nma kambisam o kermia ruk ngam kaelha klol o takis kar endruk mor o Yuda ngolmialaol ngama keyang ngar ekam ko ngam lo sim kut kaikkiem nguaro keknen.’ ");
INSERT INTO sua_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ii, mut si rere kim muo tok, vanangko si enang tok, E Nut To Tho Mi Kut Sir Hak karo reha ngaro miel msim ngar mur kaimim kim o rhek mang karo keknen mruo.” ");
INSERT INTO sua_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tie ma kolkha langto a mhel langto mnam a valngan to mkor o Parisiau ka munik e Saimon tvaeng e Yesus kmemik ko kim en kar klenar. To e Yesus ta ngae kpis her korsang ku mmie kar mar kmemik ko he. ");
INSERT INTO sua_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tkaemik kar mar va a vlom langto nam mur kaenen ngang lurokol kun mnam a rengmat to endo ta ngnek te, e Yesus ta vle kaemik kun mnam a Parisiau to endo ka rek. To ta kol ka ku to kun mnam a kre to a alabasta ko o mia ngat hong mnam. Vanang a ku to, ka keik to kmenkim te ksei kam grap hak ko ngat eharom orom a ho to a nat ka kavgot ka ye va tlua movavaik kar a tomhel tang hak. A vlom to endo tkol ka kolhi to endo he kaol orom to ");
INSERT INTO sua_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","hera ngae kpis ko kim e Yesus he ksir ko pekam. Ta sir ko pekam tok to kulmar ku penharom he gi kaeti ko tok mang en mruo. Tkaeti to kalo keik nginaro vrek ngta lul ngpirik kuo mang e Yesus kalo nhar. Ta vokom tok, to le keep he kaelha kam momgol min orom karo ir ruk lhogue kuon malpgem. Ta momgol min knop, to le kvorang ngin orom ka ku to ka gri la vu yar hak to thera kpom min kam khenam ka mamrung ma mmok. ");
INSERT INTO sua_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","To a Parisiau to tvaeng e Yesus kmemik ko kim ta vokom tok, to tgia pat kun mnam en mruo he te, “Hai-e! Tlua mnor mang a vlom ta gi, ko tkaennegiang en kmehang tok? Enangthe a mhel ta, npa vle te, en a mi propet msim va nok nap kais kam mnor mang a vlom ta ko en a ho mi kut kernonhor hak.” ");
INSERT INTO sua_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Te mrua pat kun mnam en mruo tok, to e Yesus thera havaeng te, “Saimon, kua papat langto kua svil kam havaeng yin mang.” Va e Saimon tkaekon ngang te, “Pattermia, yin he, si vur havaeng dok na.” ");
INSERT INTO sua_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","To e Yesus tkothoi ngang te, “Alo mhel alomin nginta vle. Va min tgus ngint el a tol ko kim a taven langto ka ngaeha to kmel o tol kim o mia. Langto kta tol tis mang o kirpik ruk loktiek va langto kta tol tis mang a pek to agitgiang e. ");
INSERT INTO sua_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Min tgus ngint lo is kmoripang nginalo tol ngang a taven to enda kam srim e. Ekam tok, a taven ta, ta kser nginalo tol ruk ko kim hak. To edim mnam min ner kaelongtok mang a taven to ta kser ka tol to ko kim he kir kim kaela orom ka sirei to mang?” ");
INSERT INTO sua_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","To e Saimon tkoripang te, “Nok endo ka tol ta grap kir kim kaela vor.” E Saimon ta re tok, to e Yesus tkoripang te, “Her tok arhe yi sim kut ngae rkieng hak.” ");
INSERT INTO sua_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","To e Yesus ta hortgi ngok kim a vlom to endo, to hera kner e Saimon te, “Ya vokom a vlom ta? Dok, ko vaik moti mnam ila rek ta, va yi lo khenam te, ye kaelongtok mang dok kmoror kua lo nhar orom a gi ye kmikkiem mor o Yuda ngua keknen tok e. Vanang en ta khenam te, tkaelongtok mang dok ko tkaeti he koror kualo nhar orom kalo keik nginaro vrek to le ho gi ktua momgol min orom kakro ir ruk lhogue kuon malpgem kat. ");
INSERT INTO sua_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Vanang yin, yi lua khenam te, ya kaelongtok mang dok kam vrua kpom kua ktiek kam mrung dok e, vanang en, ko ko gnua pis va ta khenam te, tkaelongtok mang dok ko tho mi ktua sovet hak kam mrung dok, he lo korim kam ho gia kulmar ku penharom dok kam kpom kua lo nhar. ");
INSERT INTO sua_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ii, tkaenang tok kat ngang yindo, ko yi lo khenam te, ya kaelongtok mang dok ko yi lo kol ke vur ye tang he ka glot ke gi vur mhe ngang malpgem dok, dok kam serppak pum, vanangko en, ta khenam te, tkaelongtok mang dok ko ta kol a ku to ka gri la vu yar hak va ka keik kat to kmenkim tsei kam grap he ka glot tgus kuo mang kualo nhar. ");
INSERT INTO sua_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","He ekam tok, kua havaeng yin te, ekam ko a vlom ta, ta khenam te, tvu kaelongtok mang dok enang tok, ka keknen ta, ta khenam te, E Nut ther lol karo kerkeknen ruk kavurgem patgiang ngaiting he. Vanang endo tlua khenam te, tlo vur kaelongtok mang dok, ka keknen to enda, ta le ktua khenam kat te, E Nut tlo lol karo kerkeknen ruk kavurgem patgiang ngaiting e.” ");
INSERT INTO sua_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","E Yesus thavaeng e Saimon tok knop, to le khavaeng a vlom to enda te, “Ko lol ilaro kerkeknen patgiang ngaiting he.” ");
INSERT INTO sua_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Va endruk ngta tuur mnam a ngaemik to endo, ngta ngan e Yesus karo rhek ruk tok, to ngta mo mnganang ngar mruo te, “Hai-e! A mhel ta en erieto ko si en ta pat te, en mruo tis kam lol o mia ngaro kerkeknen patgiang ngaiting kat?” ");
INSERT INTO sua_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","To e Yesus thera reng a vlom to enda te, “E Nut ther lol ilaro kerkeknen patgiang ngaiting he, ekam ko ye her kor mnam in mang dok enang tok he. He ngae he, he ka vle orom a vrek longeik kar E Nut.” ");
INSERT INTO sua_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","To koknaik he e Yesus tkaelha kvaik kottek kun mnam o rengmat ruk laol va o rengmat ngakro maksien kar karo aposel ruk loktiek hori orom alomin he kaelha kam knovvur orom e Seten ko E Nut ka serppak tkir kim, he E Nut ka tavgo tpis ka vle kuon mang o mia. ");
INSERT INTO sua_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Va lraip akuruk ngam kaikkiem e Yesus kat. Lraip ri e Yesus mruo tmur kaeharom mar pum ngakro yor kam kerer o kool petgim mar. Endruk e Maria, endo nkong mMagdala, ko e Yesus tkerer o kool ruk aktiek hori orom alomin petgim. ");
INSERT INTO sua_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Va alo vlom aloruk e Susana va e Yoana to katngokol e Kusa, endo nama nho mang e Herot karo gol nga pun, va lraip akuruk kat ngam kaikkiem e Yesus kat. Ii, lraip ri tgus ngma turang e Yesus kar kalngunes orom o krek va ngakro olngaemik va kring ngaekmol ekmar kat. ");
INSERT INTO sua_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ngta vle he o mia ngta veet va ngta veet gi ko ngat kottek ko mnam ngaro rengmat ngo pneik he kngae kgun ngok kim e Yesus. Ngat pis kaum to e Yesus ta koka ngang ngar te, ");
INSERT INTO sua_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mnam a kolkha langto a mhel tkaelha kngamngam a ho karo khek kun mnam ka loot. Ta ngamngam mar kngae, va akuruk ngta vuvuut ko ekam a ngaelaut, to o mia ngam kaol va karkar mang ngar. To o iningol ruk kuon mail ngat le kpis kokorong ngar krum kim mar hak. ");
INSERT INTO sua_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Va akuruk ngta vuvuut ko mnam a mhe to o gi krek. Ngat pagis to her gi kta vuvui to kyor vgum a koppetmok he ho gia nop hak ko nop a ye ngang ngar e. ");
INSERT INTO sua_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Va akuruk ngta vuvuut kun pgegom o ngaergot ruk o kosmur. To o kosmur ngta lalaut hop kim mar kvuvuem mar to her gia komor kmar. ");
INSERT INTO sua_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Vanang akuruk ngta vuvuut ko mnam a mhe to a yar, he kpagis to klalaut to ho mia sovet hak kmehi. Ngakro maineik ruk ngam kaehi ngta ngamngam va ngta ngamngam ge, o kaineik va laol hak kir kim endruk ko a mhel ta ktar kngamngam mar.” E Yesus ta koka tok knop, to kre te, “Muk ruk muta vongnek kim dok, mgua sim kael rela ekam kuaro rhek ri kam sim kut kaikkiem mar.” ");
INSERT INTO sua_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kam ngae, to kalngunes ngta mnganang e Yesus mang ka koka to mang a ho karo khek ka pun. ");
INSERT INTO sua_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Va e Yesus ta reng ngar te, “Tennik kam ngae kais mang tete E Nut nma tuvgom karo papat ruk mang ka tavgo kim o mia. Vanangko tete ta polger a re mang ngang nguk kam khenam ka tavgo to endo ma mmok ko pum mularo kerok, he ta komor muk. Va her muk ruk arhe mut mi vokom ka mnor mang. Vanang a mumu ta, ngat lua vokom ka mnor mang vop. He ekam tok, kom gia koka ngang ngar ge, kmikiem enang ko a propet karo rhek ngat her mi pis lmien ormar arhe. Ko a propet to endo ta ktar kpavap mang ngar te, ‘Ngam gia vokom E Nut ka tavgo orom ngaro gi pkor, he kaennegiang. Va ngam sia ngnek ka ngnek mang kat, vanang kle gi kael rela petgim gi.’” ");
INSERT INTO sua_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","To e Yesus ta keknen ngang ngar te, “A koka to endo ka pun ta vle ti te: A ho karo khek ngta vle enang E Nut karo rhek. ");
INSERT INTO sua_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Va o mia ruk ngma ngan o rhek ruk mang E Nut ka tavgo, nang lo smia ngangam kim mar mang ngar, ngta vle enang a ho karo khek ruk ngat vuvuut ekam a ngaelaut ko ngma ngnek mang E Nut karo rhek, vanang e Seten nam her gi kat pis ge, gi veveret o rhek ruk E Nut ta ktar kngam mar ngkun mnam ngaro vurkul petgim mar kam rum kim mar. He ekam tok, o mia ruk endruk ngat lo is kmor mnam mar mang E Nut, va E Nut tlo is kam sulgim mar kam hong ngar pum ngaro kerkeknen kam lol mar patgiang ngaiting kat e. ");
INSERT INTO sua_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Va o mia ruk ngma ngan E Nut karo rhek he kmarer ka kpom mar kun mnam ngaro vurkul he ksirei mang ngar va kngatkal mang ngar ngatngae, mar ngta vle enang a ho karo khek ruk ngta vuut kun pgegom o gi krek. Ngta vle tok, ekam ko E Nut karo rhek ngat gia puung ngakro vurkul ko ngam gi vur kor mnam mar mang E Nut nong ke laut orom ngaro gi pkor to e Seten nam re gi kaegom mar, va a koppetmok nama hos kim ngaro papat ruk kmor mnam mar mang E Nut to o papat ruk endruk ngam her gi kat nop hak kun mnam mar. ");
INSERT INTO sua_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Vanang o mia akuruk yok ngma ngan E Nut karo rhek. Endri ngta vle enang a ho karo khek ruk ngat vuvuut kun pgegom o ngaergot ruk o kosmur vat. Ngma ngan E Nut karo rhek he kaelha kmel ngaro ngorsang kuo mang ngar, vanang o vrong tgoluk ruk mnam a mmie to enda, enang o vnek, o gol va o sirei ngata kpom mar. To o papat ri ngma hop kim E Nut karo rhek kun mnam ngaro vurkul he kvuvuem mar, to her gia komor mar, he E Nut karo rhek ngam lua laut kun mnam mar kam sim kael mit e. ");
INSERT INTO sua_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Vanang o mia ruk ngaro papat ruk lyar hak ngta vle enang a ho karo khek ruk ngat vuut kun mnam a mmie to a yar ko ngma svil kam smia ngan E Nut karo rhek, mar kam kpom ngakro vurkul he ka vle lserppak hak kun mnam ngaro vurkul ruk o yar ko ngma mien orom ngaro svil ruk mang E Nut tok. To ngam kaenker kam matnge vgum o vnek he ekam tok, E Nut karo rhek ngam kael mit kun mnam mar.” ");
INSERT INTO sua_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","E Yesus ta rere vop mang E Nut ka tavgo he kre te, “A mhel nam lua giem a paei to le ktotokim orom a plo e, i o ktuvgom ku meorom a hep kat e. Nove! Nam kle va kaendavloum a rek ko pgeik msim he kgiem, en kam mmok kim o mia tgus ruk ngat re kam vavaik va mar kam smia nho ma mmok. ");
INSERT INTO sua_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","He kmikkiem enang tok, E Nut to nma tuvgom ka tavgo kim o mia tennik, ta le kaendavloum a mmie he ka khenam ma mmok tete he. Ii, tesgun E Nut ta totokim ka tavgo kim o mia, vanang tete ta kle kpolger a re mang kmel ma mmok he. ");
INSERT INTO sua_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ekam tok, mgua sim ktua ngangam kim muk mang kuaro rhek he kvongnek kim dok. Ko endo naka kpom E Nut karo rhek he ngat kael mit kun mnam, E Nut ner kle ho gia sovet kam kta kaen karo rhek akuruk mnam kat. Vanang endo na lo smia kpom E Nut ke re ke vur vgon ngang ko ke sie, he en kmel mit kun mnam, va si ke re ke vur vgon to na re ka kpom, va E Nut ner kle ho gia vret mkor petgim hak.” ");
INSERT INTO sua_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","To e Yesus knan kar kaornopeik ngat kaol te, kam rere kar, vanangko ngat lo is hak kam pis ko kim, ekam ko o mia ngate ksovet hak, he nong ke vur longmok tang ko kim e. ");
INSERT INTO sua_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","To a mhel langto thavaeng e Yesus te, “Vae, inan kar ingornopeik ngta sir ku mnok he ka svil kam rere kar in.” ");
INSERT INTO sua_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Va e Yesus tkoripang te, “O mia ruk ngta ngan E Nut karo rhek he kaikkiem mar her mar ruk arhe nguaka kvam mar te, koornek va koornopeik.” ");
INSERT INTO sua_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","To mnam a kolkha langto e Yesus ta kar mnam a langail va kreng kalngunes te, “Mu so mor he ngor ngae ngogut ma ngaenker ka ngaiting tigut vat.” To ngta poe kngae. ");
INSERT INTO sua_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ngta poe kngae, va vgum a kalivurvur ko ta pis he kaenpgam a ngaenker. Va o vlung ngta sovet kam karir ngkun mnam a langail va tre kam vallum mar hak he. Vanangko e Yesus tonit. ");
INSERT INTO sua_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","To kalngunes ngata ngae ngok kim va kvokom ko ta hivuo kmonit to ngata votgem he khavaeng te, “O-ngor taip-o, ketasuo mor kam vvuo he.” To e Yesus ta hop to her gia re lserppak kam kser a ngausgi va kam hagam o vlung ruk laol. Ther gi re tok, to a kalivurvur ther gi nop hak va o vlung ngat ngae her gi rurruom ngatngae. ");
INSERT INTO sua_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","E Yesus kalngunes ngat vokom tok, to ngaro ngaongtok ngta ksir kim to ngat le mrua sor kmar to kmo mnganang ngar mruo te, “Hai-e! Ani mhel langta ti e, ko si a ngausgi va o vlung va ngata ngan vgum?” To e Yesus thera kner mar te, “Kman ko mut lo kor mnam muk mang dok vop?” ");
INSERT INTO sua_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","To e Yesus kar kalngunes ngat ottek mGalili to kpoe ogut pa ngaenker ka ngaiting tigut, to kngae kpis ko mnam a mhe to mkor lGerasa. ");
INSERT INTO sua_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","30","E Yesus tre gia prik ngok paat, to ta ting kim a mhel langto nkong ko mnam a rengmat to endo ko o kool ngtim he kviging. A mhel to endo o kool ngat envevem tiok he, he nam lo kaegen va lua vle ko mrek e. O mia ngam kaussiem kalo ktiek va kalo nhar orom o sen he ktoot mang oguo mrek, vanang mnam o kolkhek kavurgem o kool ngam kaen sop kar gi, va si o sen, va en nam gi kat kaur mang ngar kokohirrik to her gia ngorpok kngae ko po turvek kmikkiem o kool ruk endruk ko ngma vaeng. He nam gi konit ko mnam o nhotor ruk mkor o yoror ko tok. A mhel to endo tvokom e Yesus to ther gi pis ksir ko kim he ktubulkek ku penharom. To e Yesus ta ktar ka mnganang te, “Ila munik erieto?” Va a koot langto kun mnam tkoripang te, “Ngua munik e Ngaomevek.” Tkoripang tok, ko o kool ngarlavurgem ngarlavurgem ngat viging he. E Yesus ta ngnek tok, to thera reng ngar kmottek kun mnam a mhel to endo. Ngta ngnek ko e Yesus treng ngar tok, to a koot ta rere klik hak kam reng te, “Yesus, yindo E Nut To Tho Mi Laut Hak Khal to yin. He ngot lua mtom yin kam pis ktoop kmor mo e. Ngot kaurur kmin kmor kmen a kapnes ngang ngor kam kering ngor.” ");
INSERT INTO sua_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Vanang ko tok rkieng ngar, o morek nga murgun ngta hohek ko rkieng a veik ka ngaiting. Va a ngaenker ta vle ku pa veik ka pun. To a koot to endo tkaurur kim he kaenker ngang, en kam lo kaen a re ngang ngar, kmenpasiker mar kun mnam o kool nga hengor to ngogu pa nho to mnam a mmie ka ngaesik hak, nang en nak kle kaen a re ngang ngar kmeng ngar kam viging o morek ruk endruk. Ngata kaurur kim tok, to e Yesus ta ngatkal ormar. ");
INSERT INTO sua_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","To o kool ngat her kottek mnam a mhel to endo, nang kle kviging o morek. Ngat viging ngar, to o morek tgus ngat her gia kolaspa kam sap ngpirik ekam a veik kam ngae kpis kvuvvuo kun mnam a ngaenker kyayor tgus ka ngmeang. ");
INSERT INTO sua_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","To o toot kmo morek ngta vokom tok, to ngta ngorpok ngok mnam a rengmat ka pun va o rengmat ruk ko rkieng a mhe to endo, he kaelpun kvaik kottek mnam mar kam havae kngae mang he. ");
INSERT INTO sua_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","To o mia ngta veet kam vokong anito tpis. Ngta pis ko kim e Yesus va ngta vokom a mhel to endo ko o kool ngat her parem ko tsim kut kaegen va gi korsang ku penharom e Yesus ko tho gi ya hak he, va tsim kta papat kat. To o mia ngate ksei kam gor hak. ");
INSERT INTO sua_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","To o toot kmo morek ruk ngata vle ko tok va mi vokom ko e Yesus ta kerer o kool kun mnam a mhel to endo, ngat kaelha khavaeng o mia mang e Yesus ko teharom tok. ");
INSERT INTO sua_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","To o mia akuruk mnam a mhe to e Gerasa ngat kaurur kim e Yesus, en kam ngae petgim mar, en kam lo kta vle kar mar kat e, ko ngat ho mi ktua gor hak. To e Yesus ta ngnek mkor mar he re kar kun ma langail te, en kam ngae, ");
INSERT INTO sua_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","va a mhel to endo e Yesus teharom pum o kool, tkaurur kim te, en kmikkiem, vanang e Yesus tlua svil e. Ta kle va kmeng, en kam ngae orom karo rhek ri te, ");
INSERT INTO sua_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ngiak kaeknik ngok mnam ila rengmat ka pun he khavae mang o tgoluk tgus ruk E Nut teharom mar ngang in.” To a mhel to endo ta vaik kottek kun mnam o maksien tgus ruk kun mnam a rengmat to endo kam havae mang o reha ruk laol tgus ruk e Yesus teharom mar ngang. ");
INSERT INTO sua_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tie ko e Yesus tkat kaeknik ma ngaenker ka ngaiting tkun kuon he kpis, o mia ngta vle ksirei mang en kam pis ko tok ko ngat her gia vle kpaneng he. ");
INSERT INTO sua_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tpis ko tok, va vgum a taip langto ka munik e Yairus, endo nma nho mang o Yuda ngarta rek to kam rere mnam ko tkaol pis he ktubulkek ku penharom e Yesus to kaurur kim, en kmikkiem ngok mnam ka rek ");
INSERT INTO sua_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ko ka kvek to ke tro, ta re kam yor ko en a vlom sie vop. Karo pnes gi loktiek hori orom alomin e. To e Yesus tngan vgum to her kaikkiem. Tngae va o mia ngta mopet kmikkiem kat he kuklung mnam hak. ");
INSERT INTO sua_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Vanang a vlom langto orom ka yor to a vaeip ta vle kun mnam endruk ngat kuklung mnam e Yesus ko tok kat. Ta vle orom ka yor to endo kais mang o pnes loktiek hori orom alomin he. He a mhel tang tlo ktuis kmeharom en pum, he en kam kta ya kat e. Tsi ho gi rum kakro krek tgus kmenkim o mia kmeharom, vanangko ngat lo is e. ");
INSERT INTO sua_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A vlom ta, tgia knaek ekam e Yesus kpis to a gi hi to tkaehang ka yet ke gi gu mko gi, ka yor ther gi nop ngatngae. ");
INSERT INTO sua_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","To e Yesus ta mnganang o mia he te, “Ngola, erieto tehang dok?” Va o mia tgus ngta klai. To e Pita tkoripang te, “Kua taven, yi lua vokom ko la mhel vang ta, te vua mopet ngte kim in gi?” ");
INSERT INTO sua_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Va e Yesus tkut kaur ge kam havae te, “Nove, a mhel tang tmi ehang dok ge, ko ko mur ngan kua vok ko kua serppak to kmeharom o mia orom tparem dok he.” ");
INSERT INTO sua_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","To a vlom to endo ta tar ko e Yesus ta mnor mang, to ther gia khi kngae kpis ktubulkek ku penharom. To ther gi mrua havae mang en mruo ko pum o mia tgus ngo kerok ko kman ko tehang e Yesus va mang ko yek ka yor to edo ta nop. ");
INSERT INTO sua_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","To e Yesus thera reng te, “Kolkheng, ye her ya he, ekam ko ye kor mnam yin mang dok. He ekam tok, ngiak ngae he, he ka vle orom a vrek longeik kar E Nut.” ");
INSERT INTO sua_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","E Yesus ta rere vop, va a mhel langto tottek ko mnam a taip to e Yairus ka rek he kpis ko kim e Yairus. Ta pis to le gia havaeng e Yairus he te, “O-o, Yairus, ikvek tyor he, ngior kam kat kaelreha ngang a pattermia ta kat e, ngia her gi kor he.” ");
INSERT INTO sua_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Vanang e Yesus ther vur ngnek he, to thera reng e Yairus te, “Ngiak or kam gor e, ngia gi kor mnam yin mang dok ge, he ikvek ner kta hop kam kta ktal kat.” ");
INSERT INTO sua_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","To ngta ngae kpis ko mnam e Yairus ka rek, va e Yesus tvokom o mia ko ngat kael a halum he kaee kuon mail va mur kaim mar mruo mang a vlom sie to endo. To e Yesus ta reng ngar te, “Mu or kmaee tok, ko a vlom sie to enda, tlua vle enang a mi yor e. Tgia vle enang a kalyie to tgi onit ko ner kta hop kat.” Ta re tok, va o mia ngat le gia kol a klel orom ko ngat mia mnor hak te, tmi yor hak he. Ekam tok, e Yesus ta hagam mar kam lua vavaik ekam e, gi e Pita, e Yems, e Yoanes va a yor kteit va knan. ");
INSERT INTO sua_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ii, tmi yor hak he, vanang ngat vaik kpis ko kim to e Yesus ta kpom ka ktiek to gi kreng te, “Yin, ke vlom sie, hop he.” ");
INSERT INTO sua_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ta re tok, va ke vlom sie to endo tkat kaelha kam kta ngam ka ngaung kat, to ther gi hop sir ngatngae. To e Yesus ta reng ngar kam klang mo ol en kmemik. ");
INSERT INTO sua_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","To a vlom sie to endo kteit kar knan ngint ho mi kut senkrip kim, vanangko e Yesus tkaen a re to a serpgar ngang ngin kam lua havae mang a ngaeha to endo ko tpis kim min tok. ");
INSERT INTO sua_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","To e Yesus ta kaum karo aposel ruk loktiek hori orom alomin to kaen a serppak kmeharom o yor ngang ngar va tkael a serppak malpgem mar kat, mar kam kerer o kool ngo mamten tgus kat. ");
INSERT INTO sua_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Teharom tok, kam meng ngar kam ngae kaelha kpolger a re mang E Nut ka tavgo to kam komor o mia tgus. Va ta meng ngar kmeharom endruk ngta yayor kat. ");
INSERT INTO sua_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","E Yesus tkaenrhek mnam mar te, “Mguak or kmeha kim o tgoluk akor ngang nguk ko mguak ngae e. Ii, mguak or kmeha kim o kviek, o ngaelpas, o olngaemik, o krek, va si o varkie kat. ");
INSERT INTO sua_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Va mguak ngae kpis mnam ani rengmat to, va mguak kvaik mnam a rek tang, ko a rek kteit nak ngatkal ekmuk. Va mguaka vle ko kim endo arhe kais ko mguak parem a rengmat to endo. Nang mguak kor kam prik ka prik mnam o gi vrong rektor akuruk e. ");
INSERT INTO sua_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Vanang enangthe o mia nga lua ngatkal ekam muk kam vle ko kmar, va mguak kaureik he kngetmmie ko vgum ngaro rektor kam rpem a mmie to ta vat engnang mularo nharok kam khenam ngang ngar te, mut hera tu kam pis ko kmar, nang E Nut kmen a kapnes ngang ngar koknaik. Mguak kaeharom tok, nang kle klapsam nga rengmat to endo.” ");
INSERT INTO sua_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","E Yesus tkaenrhek mnam mar tok knop, to ngat her kaelha kam parahi kngae kun mnam a rengmat langto langto. Ko tok ngat kaelha kam polger o rhek kam knovvur orom e Seten ko E Nut ka serppak tkir kim he, va ngat kaelha kaeharom o mia ko mnam o mhetor tgus. ");
INSERT INTO sua_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Kam ngae, to o rhek ruk mang e Yesus karo aposel ngta vaas kim o mia ko ngam kaeharom o reha ruk lserpgue kun mnam o mhetor tgus. Enang tok, o mia ngat kaelha kam havae mang e Yesus te, en e Elaisia he tkat hop kat ko tyor. Va akuruk ngta havae te, en a propet langto nkong ngar tennik he tkat hop kat. Va akuruk kat ngta ktua havae mang te, en e Yoanes to nama parrum o mia he tkat hop petgim ka nnak kat. Va e Herot to lGalili ngarlaip ta ngan o rhek ruk mang e Yesus karo reha ruk lserpgue ruk endruk kat. Va ta ngan o rhek mang e Yesus kat ko o mia ngta mon e Yesus te, en e Yoanes to nam parrum o mia, va te sei kam lopumtang pum e Yoanes hak he ka vrek te sei kam kiin ko ");
INSERT INTO sua_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","en ta mrua pat kun mnam en mruo te, “Te e Yoanes her dok msim to ko re, mar kam kser ka ngoro kngam a yoror, vanang ani tok mhel langta ti vat, ko le kngangan o rhek ri mang ti?” Ekam tok, tkut kaenenker hak kam sim ktua me mang e Yesus kam pis ko kim ko ta svil kam smia mnor mang. ");
INSERT INTO sua_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kam ngae, to e Yesus karo aposel ngat her kaekeknik kpis ko kim he khavaeng mang ngaro reha tgus ruk ngat eharomar. To ta le kvaeng ngar ko mar tuk ngok kim, to mar tgus ngat poe kngae mar tuk kam ngae ngok ma rengmat ka pun to e Betsaida. ");
INSERT INTO sua_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Vanang o mia ngat kol a re mang ngar te, ngta ngae, to o mia ngata veet ko paat ekam mar he. Ngat pis mang e Yesus ko ta vaar, he ta ngatkal mang ngar kam vle ko kim ko tok. To tkaelha kam havaeng ngar mang E Nut ka tavgo va kaeharom endruk mnam mar orom ngakro yor. ");
INSERT INTO sua_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tie ma rorongmia ko a kolkha tvaik, karo aposel ruk loktiek hori orom alomin, ngat pis ngok kim he kreng te, “Ngiak meng a mumu ta, he nak ngae ko mnam o rengmat laol ri vur kanmok, mar kmememik va kol a ngonit na, ko mor ri ngot gia vle mo ma lootpgeik.” ");
INSERT INTO sua_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngat re tok, va e Yesus tkoripang ngar te, “Muk mruo mgua mrua klang ngar mo ol ha, mar kmemik!” Va karo aposel ruk, ngta havaeng te, “Hai-e, nguraro gi ol ruk alo gi slang alomin va o bret ruk aktiek mo maktiegom mor. Va ngot lo is hak kmenkim o ol akor kngam kuon malpgem endri kmis mang o mia vang ri e.” ");
INSERT INTO sua_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ngat re tok, ekam ko o mia vang ngat kaemik ko tok, va kam him gi lurokol tuk mnam endruk tgus ko ngat re kmemik, mar ngat kais mang te, 5,000.) To Yesus tkoripang ngar te, “Mguak mommen mar, mar kmorosang he kaum mnam a valngan langto langto nak kais mang te, alo mhelom alomin hori orom lo ktiek va a valngan langto langto tok kat.” ");
INSERT INTO sua_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","To karo aposel ngata reng ngar to ngat korosang kngae knop, ");
INSERT INTO sua_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","to e Yesus ta lol o bret ruk aktiek va alo slang to le ka nho ngpalmai he kanprim E Nut mang ngar to le kommenik to kaenik ngang karo aposel, mar kmisis kim o mia. ");
INSERT INTO sua_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","To mar tgus ngat kaemik ngae vi tgus knop, to e Yesus kalngunes ngata kaum o ol ngo mhetor ruk e Yesus tommenik ko a mumu ta penkim mar. Ngta kaklang o ngauret ruk loktiek hori orom alomin ormar. ");
INSERT INTO sua_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mnam a kolkha langto ko e Yesus kar kalngunes ngta ngarkie ko mar tuk, e Yesus ta mnganang kalngunes te, “O mumu ngma mngan pum dok te, dok erie?” ");
INSERT INTO sua_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Va ngat koripang te, “Akuruk ngma havae te, yin e Yoanes to nama parrum o mia. Gi akuruk ngam ktua mon yin te, yin e Elaisia, nang akuruk yok ngma mon yin te, yin a propet langto mnam mar ruk tennik he ye kta hop petgim ila nnak.” ");
INSERT INTO sua_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","To e Yesus ta kle ka mnganang ngar te, “Vanang muk ri, mum ktua pat te, dok erie?” Va e Pita tkoripang te, “He her yinda arhe, Endo E Nut Thim Orom Ka Msasaen, Endo E Nut tel ka tnangal miik te, yin kam pis ksusulgim o mia.” ");
INSERT INTO sua_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","E Yesus tngan tok, to ta reng ngar lserppak kam hagam mar kam lua polger a papat to endo ngang a mhel tang vop. ");
INSERT INTO sua_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","To e Yesus thera havaeng ngar te, “A Mhel To Nkong Man Ma Volkha to dok nera lol o vnek kavurgem vgum o pris ruk laol va o pattermia kmo pos va o Yuda ngalmialaol ko ngara rere kim he kaim kngam a yoror. Va naka kru mnam a mmie kais mo kolkhek ruk korlotge, yek E Nut na kle hover petgim ka nnak.” ");
INSERT INTO sua_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","To ta kle kreng ngar tgus te, “Erieto mnam muk na papat kam vle te, kolkayie to en, en na kikiangae mang karo svil mruo, nang kle mrua krus orom en mruo kmel en mruo kam yor enang a mhel to ta mrua tolpum kta ho to ngara krong orom o ot kvat ko engnang kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ko endo tvua sovet hak kmelongtok mang ka ngorsang to mo mmie, a mhel to endo ner lua kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik e. Vanang endo nam mrua slak orom ka ngorsang to mo mmie ekam dok, her en arhe nera kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik. ");
INSERT INTO sua_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ii, ko a mhel nera vle nngia enangthe napa rum karo mur svil mruo tgus hak mang ka ngorsang to mo mmie tete, vanang koknaik gi huo mang kalo ktiek ko tkosnok ko tlua kol a ktalhok to endo? ");
INSERT INTO sua_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ii, ko a ni mhel to napa leep kim o mia pum dok va pum kuaro rhek, va A Mhel To Nkong Man Ma Volkha to dok, ngora leep kim E Nut pum a mhel to endo tok kat. Ii, nera vle tok arhe, mnam a kolkha to A Mhel To Nkong Man Ma Volkha to dok ngor kaeknik mnam ko ngor kaeknik la momogor orom E Titou kar karo engyel ruk o totur nga mmok kat. ");
INSERT INTO sua_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ii, kua havaeng nguk lmien te, akuruk mnam muk ri muta vle mo, mguer lua yor vop kais ko mguer mia vokom E Nut ka tavgo to orom dok ko ka tavgo to endo nak pis komor o mia.” ");
INSERT INTO sua_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nok kopekam ko o kolkhek ruk aktiek hori orom korlotge vor, e Yesus thera nglum e Pita kre Yoanes va e Yems he ngat kaum ka grap ngoguon kia vul langto kam ngae kngarkie. ");
INSERT INTO sua_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ngata vle ko tok, vanang phevgom e Yesus ko ta ngarkie, ka vok tkaelha kam horotgi he kael a mmok va karo it ngate ksei kam ngae gia les hak he kmamallek enang a koot ko nma gurmik he kses ngpirik. ");
INSERT INTO sua_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ta ngarkie kngae tok, va vgum e Moses kre Elaisia ko ngint her gi pis ho la momogor hak he krere kar e Yesus mang ka yor to E Nut ketasuo kmaottam kpis lmien mang ko mYerusalem. ");
INSERT INTO sua_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Vanang e Pita kar klo lua a ngonit ta vurvrum mar vop. To ngta hop va kvulvokong ngar to ngaro kerok ngate smia mmok to ngat hera vokom e Yesus ko en la momogor kar ennginduk nginta sir ko kim. ");
INSERT INTO sua_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","E Moses min nginta rere kar knop he re kam ngae, to e Pita ther gi vrong kngam a re ngang e Yesus te, “Vae, pattermia, tho mi kut ya hak ko mor korlotge ngota vle mo. Mor he, ngruak ngam o rambel akor ko korlotge ngang nguk, tang ngang in, e Moses kat ngang va tang ngang e Elaisia kat!” ");
INSERT INTO sua_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","E Pita ta rere kngae vop, to a varhek langto ta grung kpis komor mar, to ngate ksei kam gor hak ko ka ngoumi ta komor mar tgus hak. ");
INSERT INTO sua_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","To ngta ngan a ktui ko tottek kun mnam a varhek he kre te, “Ko hal ta arhe, her Enda Ko Mur Re Pum, he mgua smia ngan vgum!” ");
INSERT INTO sua_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ngat ngan a ktui to enda ko ta rere tok, to ngat gi vokom e Yesus ko ther gia sir en tuk ko pum ngaro kerok. Kam ngae, to kalngunes ngat her gia kir mang a re kun mnam mar mruo, nang lo kta havaeng tang mnam o kolkhek ruk endruk mang a tomhel to endo ngat vokom. ");
INSERT INTO sua_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","To hop enang ngmo, e Yesus mar ngta grung kun kuon kia vul, to kpis mang a mumu alautar ko ta vle he kpaneng ku pa vul. ");
INSERT INTO sua_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tpis mang ngar, va vgum a mhel langto kun mnam mar ko ta vui klik kmaurur kim te, “Pattermia, ko kaurur kmin mang ko hal to ke tro ta, he ngia turang vanie, ");
INSERT INTO sua_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ko a koot to a ngoulo nam gi kaelriring kmim kmootmerom. Nam kaim enang tok, va vgum a kalyie ko nma vui klik ta krongreik ogu mmie to karo gusgus ngma klang ka gu. A koot to endo nam kaim kvurvrum hak he gia venu mang, nang lo korim hak. ");
INSERT INTO sua_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","He ko si kaurur kim ilengunes ri te, mar kam kerer a koot to kun mnam petgim, nangko ngat lo is mang e.” ");
INSERT INTO sua_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","E Yesus ta ngnek tok, to kle ka kner kalngunes te, “Muk o mia nga main to tete mum vu kaungtu ekam mularo mur kerpapat mruo, nang kle vua vrengem E Nut karo papat kam kekenhor mang dok hak. Kua kapngan kim muk he, ko kua vle mo kmuk lhok, vanang mut lo vur kaeha vop orom kua serppak to ko en ngang nguk e.” Ta kner mar tok, to le kreng a kalyie to endo kteit te, “Marer plalam ihal ngte kim dok na.” ");
INSERT INTO sua_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","To kteit tsia plalam kngorom va a koot to endo tpis gi kat im kat kootmerom kam krongreik oguo mmie. Vanangko e Yesus tgi kaekon kim a koot to endo kmen a re to a serpgar ngang, to a kalyie ther gi ya hak ngatngae. E Yesus teharom a kalyie to tok, to her kaekon ngok maktiegom kteit. ");
INSERT INTO sua_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","To o mia ruk ngta vle ko tok ngat ho mi kut senkrip hak kim e Yesus karo reha ruk lserpgue ruk E Nut teharom mar maktiegom. O mia ngta senkrip kim e Yesus karo reha ruk endruk, va ta le kreng kalngunes te, ");
INSERT INTO sua_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mgua smia ngangam kim muk mang kuaro rhek ri ko kua havaeng nguk te, a mhel langto nera hortgi mang A Mhel To Nkong Man Ma Volkha to dok, he kael ko maktiegom karo imuo.” ");
INSERT INTO sua_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Thavae tok, vanangko kalngunes ngata moruo pum karo rhek ngaro pneik ekam ko E Nut ta tuvgom mar kim mar, mar kam lua mmok mang ngar enang tok. Va ngta gor kam mnganang mang ngar kat. ");
INSERT INTO sua_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","To e Yesus kalngunes ngat kaelha kmo maen o rhek kam mo kir kmar mang te, edim mnam mar ka munik ta laut mang klenar. ");
INSERT INTO sua_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Vanangko e Yesus ther mnor mang ngakro papat ko ngta vle tok, to kvaeng ke kalyie langto he ka srim ko vanam, ");
INSERT INTO sua_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","to hera reng ngar te, “Mu vokom na, ani mhel to na mrua krus orom en mruo ko pum o mia ruk ngaro mnok ngat lo vua laut enang ke kalyie ta, kam ngatkal mang ngar ko ngat kor mnam mar mang dok, va a mhel to endo ther mi ngatkal mang dok her tok kat arhe. Va ani mhel to nak ngatkal mang dok enang tok, ther mi ngatkal mang her E Nut to tmeng dok ngte tok kat. He ekam tok, endo nam mrua krus orom en mruo tok, her endo arhe E Nut ta pat mang te, ka munik tho mi laut hak.” ");
INSERT INTO sua_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Va e Yoanes thera koripang te, “Pattermia, ngot vokong a gi vrong mhel langto ko tkaeharom o mia he kerer o kool orom ila munik ka serppak, va ngot lo ngatkal mang, nang kle khagam ko en nam lo kaikkiem mor e.” ");
INSERT INTO sua_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Va e Yesus ta srim te, “Mu or kam hagam e, ekam ko ani mhel to tlo kael imuo ngang nguk, her a mhel to arhe tmia vle te, ther mi ngatkal mang nguk tok arhe.” ");
INSERT INTO sua_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ta konner a kolkha to E Nut karo rhek kmel mit orom e Yesus, en kam yor he kta khop kam grap oguon ma volkha, to e Yesus tkael ka pat lserppak kam lapsa kngae mYerusalem. ");
INSERT INTO sua_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","To thera meng kalngunes akuruk kam ktar ngok mnam a rengmat tang mnam a mhe to e Samaria kam ring a ngaekam tang ekam. ");
INSERT INTO sua_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Vanangko o mia ruk ko tok ngat lo ngatkal ekam e, ko ta re kam ktua lapsam mar gi he kngae mYerusalem. ");
INSERT INTO sua_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","To e Yems kre Yoanes nginalo ngaela nginta prik kim o rhek ruk endruk, to ngint hera mnganang e Yesus te, “Ngoldaip, ngia tting vanie, he ngor en a re ngang E Nut mang a paei tang kun kuon ma volkha he En na ngampaei pum a rengmat to endo he ho gi kaem kraom tgus hak kam rum kim o mia tgus.” ");
INSERT INTO sua_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Vanangko e Yesus thortgi ngok kmar he ka kner min mang a keknen to kam vrek kiin. “Nok met lua mmok mang E Nunu A Totur kakro keknen gi, ko A Mhel To Nkong Man Ma Volkha to dok tlo pis kam rum kim o mia e. Ho mi kut nop hak! Ta kle kpis kam kle va klol ngaro kerkeknen patgiang ngaiting ha.” ");
INSERT INTO sua_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ta kner min tok knop, to ngat her kle kngae ngok mnam a rengmat langto yok. ");
INSERT INTO sua_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","59","Ko ekam a ngaelaut ko ngat kaikkiem kngae mYerusalem vop, e Yesus ta reng a mhel langto te, “Ngiak kaikkiem dok na.” Va a mhel to endo tkoripang te, “Ngor kaikkiem yin ngok mnam oni mhetor tgus ruk ngiak ngae mnam mar.” Va e Yesus tkoripang te, “O-o, yi her ketoptop kmikkiem dok he, ko si o pendol ngartaro nhotor ruk kmonit mnam mar, va o iningol ruk kuon kia gan, mar ngartaro ngainirik kat, vanang A Mhel To Nkong Man Ma Volkha, nop ke vur ngaekam tang ngang, en kam vur konget ka sai e.” Kam ngae, to e Yesus ta reng a mhel langto vat te, “Ngiak kaikkiem dok.” Va a mhel to endo ta le khavae te, “Yu! Vanangko ngiaka ktar na gi vur korim dok he E Titou na yor he ko eguyang na, to endo yek ngua le kaikkiem yin.” ");
INSERT INTO sua_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Va e Yesus, tkokheng te, “Nove! O mia ruk ngara yor he koknaik lua kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik, ngiaka mnang ngar kam mrua kaeguyang ngaro mur yoror mruo. Vanang yin ngiak ngae he khivuo kam havaeng o mia mang E Nut ka tavgo to nera komor o mia tgus.” ");
INSERT INTO sua_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ge a mhel langto kat thavaeng e Yesus tok kat te, “Kolaip ngor mi kaikkiem in kat, vanangko ngiaka ktar na gi vur orim dok, he nguak kaeknik ngok kim kua valngan mruo he kunngir kim mar.” ");
INSERT INTO sua_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Thavae tok, va e Yesus ta kokheng kat te, “O-o, ani mhel to telha pum ka loot kam hegem a mmie kam ngam a ror, nang kle gi kta nho knaek kam vokom o gi vrong tgol akuruk yok, va a mhel to endo tlo kais kam smia kpom ka loot e. Ii, ta vle ngang nguk gi enang tok kat arhe ko a mhel to tre kam vaik ku meorom E Nut ka tavgo, nang kle gi kta nho knaek mang o gi vrong tgol akuruk yok kat, va en ner lo kais kam smia kpom E Nut tok kat e.” ");
INSERT INTO sua_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ngoldaip ta rere tok knop, to tkael kalngunes ruk o mhelom korlotge he loktiek hori orom alomin kam meng ngar, mar alomin alomin kam ktar mang he kngae ngok mnam o rengmat ruk en ner kle ka knaek kngae mnam mar kat. ");
INSERT INTO sua_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","To thera tger mar te, “Kua re kam meng nguk ngok kim o mia ruk ngat kaenang E Nut ka loot to tettek he, he kpaneng E Nut karo mia mruo kam lluol mnam, ko o mia ruk endruk ngat her gia toot he kpaneng E Nut karo mia mruo kam havaeng ngar mang E Nut ka tavgo. Ii, o mia vang kun mnam E Nut ka loot ngat tettek tok, vanangko o mia ruk kam lluol mnam, mar lgititge e. He ekam tok, mguak kaurur kim E Nut to ta nho mang ka loot to orom mar, En kmen a re ngang karo mia mruo kam meng ngar kam lluol kun mnam ka loot. ");
INSERT INTO sua_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","4","Mguak ngae va mguak or kam koham a kolkha ka keik kam vua pamlok kar o mia ko ekam a ngaelaut kat e. Yu! Mguak ngae he, ko kua meng nguk ruk mut kaenang o sipsip ruk o sital kam vle kun pgegom o mia ruk ngat kaenang o pendol. Mguak ngae va mguak or kmeha kim o ngaelpas, o psang va o nharok akor kat e. ");
INSERT INTO sua_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Vanang mguak pis kun mnam a rek to ko mnam a rengmat langto va mguak kaenpaeim a rek kteit te, ‘E Nut nak ngamyammok mang ila valngan.’ ");
INSERT INTO sua_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Va enangthe en a mhel nong a yar va mularo rhek ngak kat kaeknik ngok kmuk. Vanang enangthe en a mhel a yar, va ilaro rhek ngaka vle kuo mang. ");
INSERT INTO sua_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ii, va mguaka vle ko kim a mhel to endo, va kaem o tgol ruk ngat kaenik ngang nguk va kaivie ko kim kat, ko her en arhe na kaeha vgum muk. Mguak or kam prik ka prik ngok kim o rektor akuruk kam vle kar o mia akuruk yok, mar kmeha vgum muk kat e. ");
INSERT INTO sua_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Va enangthe mguak vaik kun mnam a rengmat tang he ngapa ngatkal mang mularo reha ko muta ring ngaekmol ekmuk, va mguak kaem oni vrong tgoluk ruk ngam kaenik ngang nguk. ");
INSERT INTO sua_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Va mguak kaeha ngang a rengmat to endo kmeharom o yor ruk nkong ngar ko tok. Ii, mguak kaeharom mar tok, va khavaeng ngar te, E Nut ka tavgo ther mi pis ko kmar gi enang tok arhe. ");
INSERT INTO sua_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Vanangko enangthe mguak vaik kun mnam a rengmat tang he nga lua ngatkal mang mularo reha ko muta ring ngaekmol ekmuk, va mguak kle ksir ku ekam a rengmat to endo ka ngaelaut ka gu he kngetmmie va khavaeng ngar orom mularo mur rhek ri te, ‘Si mula mmie to enda ko ta vat engnang nguaro nharok va ngot kaesik orom he ka rpem petgim nguaro nharok kam khenam ngang nguk te, ngruera tu kam vle mo kmuk he mguera kol a kapnes ko vgum E Nut ekam tok arhe.’ Mguak re tok, to le sim ktua havaeng ngar te, ‘Mut lua ngatkal mang ngor vanie, vanangko mgua smia mmok mang E Nut ka tavgo te, ther mi pis mo kmuk ge.’ ");
INSERT INTO sua_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","He ekam tok, kolngunes, kua havaeng nguk te, mnam a kolkha to o mia ngak sir ko kim E Nut, endruk ngat lua ngatkal mang nguk ngara ker kol vgum a kapnes to a ho laut hak, kir kim si endo E Nut ner kaen ngang o kermia ruk lSodom. Ii, E Nut nera mrung lSodom, vanang endruk ngat lua ngatkal mang nguk, ho mi kut nop hak.” ");
INSERT INTO sua_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","To e Yesus ta kle kukueng o rengmat ruk ngat lo ngatkal mang kalngunes te, “O-suvrum muk ruk lKorasin va muk ruk lBetsaida ko enangthe o reha ruk lserpgue ruk endri ngap pis kun pgegom o kermia ruk lTaira va lSaidon va si mar ngap ho lo mi hus hak tiok he, kmitgung ngaro kerkeknen. Ii, va ngap lo hus kat kam vor pa ngaor va ktolpum o ngoven kam khenam ma mmok te, ngat mrua mrung ngar mruo vgum ngaro kerkeknen ruk ngam kaeharom mar. Vanang suvrum muk kelenar ruk lKorasin va muk ruk lBetsaida ko o reha ruk lserpgue ruk endri ngat sia pis ko kmuk, vanang mut ho lo vur itgung mularo kerkeknen e. ");
INSERT INTO sua_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","He ekam tok, mnam a kolkha to muk ruk lKorasin va muk ruk lBetsaida mguak sir ko pum E Nut kalo keik, va mguera mia ker kol vgum a kapnes to a ho laut hak kir kim si endo E Nut ner kaen ngang o kermia ruk lTaira va lSaidon. ");
INSERT INTO sua_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Va muk ruk lKaparnam, muk mum mrua pat mang nguk mruo te, E Nut nera hover muk, muk kam vua laut hak kir kim o rengmat tgus mo mmie. Vanangko, ho mi kut nop hak. Ko En ner kle va ho mi ktua grung ormuk kam ngam muk ngogu mLol hak. ");
INSERT INTO sua_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ii, kolngunes, kua re tok, ko endruk ngapa ngan vgum muk, tmia khenam te, ngat mia ngan vgum her dok tok kat arhe. Va endruk ngapa keyang nguk ta kle ka khenam kat te, ngat her mia keyang her dok tok kat arhe. Va endruk ngapa keyang dok tok, tmia khenam kat te, ngat her mia keyang E Nut to tmeng dok kat.” ");
INSERT INTO sua_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","E Yesus kalngunes ngat ngae kaeha knop, to her kaeknik ngok kim orom a sirei alautar he kreng te, “Ngoldaip, ngoma kerer o kool kun mnam o mia orom ila munik va ngam mia ngan vgum mor he kngoropok petgim mar hak.” ");
INSERT INTO sua_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Va e Yesus tkoripang ngar te, “Nang nop! Ngat ngan vgum muk tok va ko her ketar e Seten he, ko tvuut ngpirik kun kuon ma volkha enang a koot ko ta gurmik he kses ngpirik. ");
INSERT INTO sua_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ii, mu vokom na, o kool ngaro keknen ngta vle enang o vimol va o kidot ruk e Seten tel karo serppak ko maktiegom mar. Vanangko dok, ko her enserpagam muk orom kua serppak mruo kmim kvurvrum o kool ruk endri kam kir kim e Seten karo serppak tgus hak tok. Ii, her endo nam vu kael imuo ngang nguk arhe. He ekam tok, en tho lo kat kais hak kam kta kering nguk e. ");
INSERT INTO sua_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Si enang tok, mguak or kam sirei ko o kool ngta ngan vgum muk e. Nove! Mguak kle va ksirei, ko E Nut ta kser a ken mang nguk kmittiegom mularo mnok kun mnam ka hor to kuon ma volkha.” ");
INSERT INTO sua_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","To mnam a kolkha to endo ke vgon to endo gi, E Nunu A Totur tkaenkrovgem e Yesus kmensireim. To e Yesus ta ngarkie ngang E Nut kam kanprim te, “Titou, yin arhe yindo ya kueng a volkha va a mmie. Kua kanprim yin ko yi tuvgong a papat to mang ila tavgo kim o mia ruk ngam mrua hover mar mruo vgum ngakro papat vul laol, vanang ka kle ka khenam ma mmok ngang endruk ngat kaenang o ngnes. Ii, lmien Titou yeharom tok, kmikkiem gi enang ko yin mruo yi mur svil kam ring ya mang endruk ngat kaenang o ngnes.” ");
INSERT INTO sua_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tngarkie tok knop, to le kreng a mumu te, “E Nut tel ka serppak tgus ko maktiegom dok, nang nong a mhel tang ta mnor mang E Nut Khal e, gi E Titou tuk. Va nong tang ta mnor mang E Titou kat e, gi Khal mruo tuk, kar endruk kua re pmar kam khenam En ma mmok ngang ngar.” ");
INSERT INTO sua_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Thavaeng a mumu tok, to thortgi ngok kim kalngunes ko gi mar tuk he kreng ngar te, “Her muk ruk arhe muta lgekol, ekam ko mum mia vokom E Nut ka tavgo mo kmuk orom mularo kerok mruo he ka mnor mang. ");
INSERT INTO sua_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Muta lgekol tok, ekam ko kua havaeng nguk te, si o propet kavurgem va o taven kavurgem, va ngat ho mi ktua svil hak kam mia vokom E Nut ka tavgo va kngan o rhek mang kat, enang nguk ko muta vokom va ka ngnek mang tete, vanangko E Nut ka tavgo tlo pis ko kim mar e.” ");
INSERT INTO sua_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mnam a kolkha langto a pattermia kmo pos langto tngae kpis ksir ko kim e Yesus he kendom ngang, he nang e Yesus kam mrua ru pum karo mur rhek mruo. Tpe gia mnganang e Yesus te, “Ngola pattermia, nguak kaikkiem a ni keknen to, he nang dok kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik?” ");
INSERT INTO sua_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Va e Yesus tkoripang orom ka mngan vat te, “Vanang o pos ruk ngat ittiegom mar kun mnam O Pos, ko ima him mar va o pos ruk endruk ngta vle nngia ngang in?” ");
INSERT INTO sua_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Va a mhel to enda ta koripang te, “O pos ngta re te, ‘Ngiak kaelongtok mang Ngoldaip orom ila ngaung tgus, ila svil tgus, ila serppak tgus.’ va ilaro papat tgus. Va ‘Ngiak kaelongtok mang ilenar kmikkiem gi enang ko im mur kaelongtok mang yin mruo tok kat.’” ");
INSERT INTO sua_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","A pattermia kmo pos tkoripang tok, to e Yesus ta reng he te, “Her tok arhe. Yi sim kut oripang he. Va yin he, ngiak ngae he kaeha kaikkiem alo pos ruk ennginduk tok arhe, nang in kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik.” ");
INSERT INTO sua_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Va a mhel to enda ta svil kam mur kaimim kim o rhek mang en mruo to le kta mnganang e Yesus kat te, “Vanang erie mar ruk ngta vle te, kolenar ruk ormar?” ");
INSERT INTO sua_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","To kmekon a mhel to enda ka mngan, e Yesus ta havaeng mang a ngothoi langto te, “A mhel langto tootpum mYerusalem he ka grung kngae mYeriko. Ta ngae, to ta ting kim o ngauruvik. To ngat im vurvrum ngam oguon mmie la gi mit, en kam yor ko he ekam a ngaelaut to endo. ");
INSERT INTO sua_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ta kru ko tok, to a pris langto tkaikkiem a ngaelaut to kpis mang va sia vokom, nangko tgi vrua vraik petgim he kaikkiem a ngaelaut to endo ka ngaiting tigut he kvarpaam, nang klapsa kngae ge. ");
INSERT INTO sua_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","To a Livai langto vat ta kle ka knaek ekam a ngaelaut to endo ge, to kta pis mang kat. Ta vokom enda ko ta kru va en kat tgi vrua vraik petgim he kaikkiem a ngaelaut to endo ka ngaiting tigut he kvarpaam klapsa kngae kat ge. ");
INSERT INTO sua_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kam ngae, to a mhel to nkong mSamaria ta kle kut kaol vat ekam a ngaelaut to endo. Tkaol va vokom enda ko ta kru to te sei kam mrung hak. ");
INSERT INTO sua_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ta pis ko kim to kturang kam glot a ho ka ye kuon mang ikela ka vok to hera momgol to komor karo turok. To thera hover kael kuon mang kta dongki mruo. To ta kol kngorom kam ngae kpis mi kael ko mo gunmia nga rek, en kam smia tar, he en kam kta ya kat. ");
INSERT INTO sua_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","To hop enang ngmo, tkael alo kre ngang a rek kteit, to khavaeng te, “Ngiaka nho mang kais ko nak ya na, to ngor kaeknik kpis to le kaenkim o tgoluk ruk ngia koham mar mang.” ");
INSERT INTO sua_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","E Yesus tkothoi tok ngang a pattermia kmo pos to endo knop, to le ka mnganang te, “Kun mnam o mia ri korlotge a ni mhel to mnam mar ta vle te, endo o ngauruvik ngat im kaela msim hak?” ");
INSERT INTO sua_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Va ta re he te, “Endo tpis vokom he ka mrung.” Va e Yesus ta reng he te, “Yu! He ngiak ngae kaikkiem a keknen to arhe.” ");
INSERT INTO sua_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kam ngae, to ngat kaikkiem a ngaelaut kngae mYerusalem vop, to e Yesus tpis kvaik ko mnam a rengmat langto. Ko tok lomoyel nginta vle, va langto ka munik e Marta ther vaeng e Yesus kmemik kar min he. ");
INSERT INTO sua_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nang kyel to e Maria tgi korsang ku penharom e Yesus kam smia ngan karo rhek. ");
INSERT INTO sua_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Vanangko e Marta ta ker kol vgum o reha ruk mang a ngaemik to endo. To tpis kim e Yesus he ka mnganang te, “Koldaip, ye kaennegiang ko yel ko kman, nang dok tuk kam vle pum o reha ri? He meng ngte he na turang dok na.” ");
INSERT INTO sua_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","To e Yesus tkaerer ka lpek kim e Marta he kreng te, “O-Marta, im vua papat va kervavle vgum o gi vrong tgoluk he. ");
INSERT INTO sua_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Vanangko a gi papat agitgiang msim hak to ngiak kaelnam yin mang, endo a yar, her enda arhe e Maria ther mi papat mang mo kim dok he, he mot lo is kam hagam mang a papat ta e.” ");
INSERT INTO sua_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tie ma kolkha langto e Yesus ta ngarkie mnam a mhe langto. Ta ngarkie knop, to kalkayie langto tpis kreng te, “Ngoldaip, kenang ngor kam ngarkie na, enang e Yoanes to nma parrum o mia ko tkut kenang kalngunes tok kat.” ");
INSERT INTO sua_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","To thera kenang ngar te, “Mguak re kam ngarkie va mguak ngarkie enang ti, ‘Titou, ila munik tho mi kut laut hak. Va ngot kaurur kmin mang ila tavgo kam vaas kim o mia tgus mo mmie he komor mar. ");
INSERT INTO sua_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Va ngota kaurur kmin kmeha vgum mor ma kolkha langto langto. ");
INSERT INTO sua_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Va ngota kaurur kmin kam lol nguaro kerkeknen patgiang ngaiting kmikkiem gi enang ko ngot lol ngolenar ngaro kerkeknen ruk ngat eharom mar ngang ngor patgiang ngaiting tok kat. Va ngota kaurur kmin kmenserpagam mor kam lo mrua ngam mor mruo ekam o ngaegom ruk ngat pis kim mor kat.’” ");
INSERT INTO sua_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ta kenang ngar tok knop, to her kaenserpgam karo rhek ruk mang kam ngarkie te, “Enangthe tang mnam muk npa ngae ngok kim kaela ma ho segain ka ho ngaenvurgem hak, he kpis kreng te, ‘Kola, kua re kam lol o bret akor ko korlotge na, ");
INSERT INTO sua_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ko kola langto ta lal kngae ngte he kpis he kvaik kim dok he dok nop o ol ngang dok kam klang e.’ ");
INSERT INTO sua_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","To ila to kun ma rek nap koripang yin te, ‘Ehenok he, ngior kmelkeyang dok ko ngot elegot he, he dok kar koles ngot onnit, he klo kat kais kam kta hop he kta klang in mlol e.’” ");
INSERT INTO sua_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","E Yesus ta kothoi tok knop, to khavaeng kalngunes te, “Kua havaeng nguk te, si a mhel to ku mnok kaela msim to en, vanangko, endo kun ma rek ner lua hop kam klang mlol e. Nop hak! Vanangko ner mia hop he ho gia klang mlol ekam ko kaela to ku mnok tkaenenker he kaurur kim urur kim ge. ");
INSERT INTO sua_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Va muk kat, muaka vle gi enang a mhel to ku mnok tok arhe, ko kua havaeng nguk te, mguak kaurur kim E Nut mekam mekam gi enang tok kat mang a tomhel to muma tu kim, he En ner kaen ngang nguk. Ii, mguak riring riring ge ko vgum E Nut kat he En ner mrua khenam ngang nguk. Va mguak vae ngok kim E Nut mekam mekam kam kol he En nera koregot kim muk kam vaik kam kol kat. ");
INSERT INTO sua_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ii, ta vle tok arhe ko ani mhel to nam kaurur kim E Nut mekam mekam mang a tomhel tang, en nma kol ko mkor. Va ani mhel to nama riring kriring vgum E Nut mekam mekam, en nma pis mang ko kim En kat. Ii, va ani mhel to nma vae ngok kim E Nut mekam mekam kat, E Nut nam mia koregot kim kam vaik kam kol kat. ");
INSERT INTO sua_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ii, mu vokom na, ani teit tang mnam muk tkais kmen a vim tang ngang kalyie kmem enangthe npa mnganang mang a slang? ");
INSERT INTO sua_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","I o nap kais kmen a kidot tang ngang kmem enangthe npa mnganang mang a ngaining ka khek tang? ");
INSERT INTO sua_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","He ekam tok, si muk ruk mularo kerkeknen ngat ho mi kut kernonho hak, vanangko mum sim ktua klang mules ge orom o tgoluk ruk lyar, gi ekam ko ngat gia mnganang nguk mang ngar. Vanang muta pat nngia mang mu Teit tkuon ma volkha to tmi kut ya hak? En tho lo kais ge kam ho ksovet kam klang kles ruk muk tok kat orom E Nunu A Totur gi ekam ko muma mnganang En mang enang tok kat?” ");
INSERT INTO sua_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tie ma kolkha langto e Yesus ta hivuo kmeharom a mhel langto ko a koot tim he ka gu tvat. E Yesus tkerer a koot knop, to a koot thera parem a mhel to endo, to ka gu ta mrer he ta kta rere kat. Va a mumu to ta vle ko tok, te sei kam senkrip kim hak. ");
INSERT INTO sua_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Vanang akuruk ngata kerrereng e Yesus te, “O-o, o kool ngarlaip to e Beelsebul ka serppak ta ti arhe a mhel to enda nma kemmeng kam paeim o mia kerer karo valngneik mruo ruk o kool orom ti.” ");
INSERT INTO sua_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Gi akuruk ngata pis pe kendom ngang te, en nak khenam a ngaelmir tang ngang ngar ma mmok, mar kam mia mmok mang en te, lmien te, en arhe Endo E Nut Thim Orom Ka Msasaen. ");
INSERT INTO sua_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Vanangko e Yesus ther mnor mang ngakro kerpapat ko ngta pat tok, to kreng ngar te, “Mu vokom na, a rengmat, i o a valngan tang tlo is hak kmommenik he mur kaus kar mar mruo va kam mopet mar mruo, matok ngara kering ngar mruo. Ko enangthe ngpa vle tok, va a rengmat to endo ka serppak tlo kais kam vle lhok e! ");
INSERT INTO sua_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","He kmikkiem gi enang tok kat, enangthe e Seten nap kaus kar ka valngan mruo ruk o kool he kmommen mar, kmopet mar, va en nera vle tok kat, ko ka serppak tlo kais kam vle lhok kat e. To nngia ko muta kerrereng dok te, kua kpom e Seten ka serppak he mur kta kerer karo valngneik mruo ruk o kool kat gi? Mularo papat ngat lua sir hak. ");
INSERT INTO sua_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Vu vokom na, enangthe lmien mang dok te, koma kerer e Seten ka valngan ruk o kool orom kta serppak mruo kmikkiem ko muta kerrereng dok enang tok, va mguak le kerrereng mutaro mia mruo tok kat, ko mar ngma kerer e Seten ka valngan kat. He ekam tok, mutaro mia mruo ngara kokheng nguk orom mularo rhek ruk muta kerrereng dok ormar. ");
INSERT INTO sua_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","He ekam tok, kua ngaeha to kam kerer o kool tmia khenam ma mmok te, her E Nut ka serppak arhe ko mi kpom he kerer o kool orom. He ekam kua ngaeha to tok kat, ta le kta khenam ma mmok kat te, E Nut ka tavgo ther mi pis mo pgegom muk tok arhe. ");
INSERT INTO sua_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Vanang dok, kua vle enang ti te, enangthe a mhel to a serpgar nap kaelel mo kim mang he ktoot mang ka rek va kakro tgoluk, va nong a mhel tang tkais kam pis ka vretik mkor e. ");
INSERT INTO sua_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Vanang enangthe kaela ko yok ko ka serppak ta laut kir kim endo a serpgar nap pis kaus kar he im vurvrum he le kir kim ka serppak to nam vua per orom mekam mekam, to endo yek, her kaela to endo arhe tmi kut kais hak kam veret endo a serpgar kakro tgoluk mkor, endruk tururik tesgun, nang le klol kaisis kim klenar mruo ormar. ");
INSERT INTO sua_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","He ekam tok, indo im lua mokpom kar dok kmaus kar endo a serpgar kam turang dok kam veret o mia mkor kmel kim mar kmelriring dok, va ima vle te, im hera kapter dok tok arhe, he im mi kaen sop ngang o mia mang dok tok kat.” ");
INSERT INTO sua_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“To a koot ka keknen nma vle te, nam kottek kun mnam a mhel, va nma ktar kngae ngok po turvek kam riring ngaekmol ko ma mngarmok ngola? To tlo pis mang a mhe tang, to nam le kta pat mang ka ngaekam to tesgun kun mnam a mhel ko tottek ko tok, en kmeknik ngok mnam kat. ");
INSERT INTO sua_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nam her kaeknik kpis mang a mhel to endo he kvokong ko a mhel ka vok tkaenang a gunmhel ka rek to ka gi kolhi ko ngat ngamakalam va pasrengem kam paneng a gunmhel tang ko yok vat. ");
INSERT INTO sua_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","A koot to endo nama pat tok, to her ka nglum klenar akuruk aktiek hori orom alomin kat, endruk ngat ho mi kut kernonho hak mang en, he ngat kaikkiem kaol kpis kviging a mhel to endo to kle ho gi kaim hak ho mi kut kir kim mang tesgun ko a koot to agitgiang en tuk ta ktar im. He kmikkiem enang tok, a mhel to endo ta vle ko ma ho kernonhommok hak kir kim tesgun kat.” ");
INSERT INTO sua_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","E Yesus ta hivuo kam rere vop, va vgum a vlom langto kun pgegom a mumu to endo ko ta vui klik kam kanprim te, “O, inan ta lgekol ko tkol in he kpavloum in.” ");
INSERT INTO sua_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Va e Yesus tkoripang kam kokheng te, “O-o, endruk ngma ngan E Nut kakro rhek he kaikkiem mar, her mar ruk arhe ngta lgekol ha.” ");
INSERT INTO sua_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","O mumu ngat ho gia laut kngae he, ko ngma pis ngok kim e Yesus. To thera reng ngar te, “Muk o mia nga main to tete mut ho mi kut kernonho hak, ekam ko mum sim ktua riring kriring ge mang a ngaelmir tang ko a serpgar mo krok. Vanang ngor ho lua khenam tang hak ngang nguk e. Nangko ngor kle va gi kael pat kmuk mang a ngaelmir langto, endo tpis lmien orom a propet to e Yona. ");
INSERT INTO sua_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ko e Yona te ka vle te, en a ngaelmir ngang lNiniva. He gi enang tok kat, A Mhel To Nkong Man Ma Volkha to dok ngora vle te, a ngaelmir ngang nguk ruk o mia nga main to tete kat. ");
INSERT INTO sua_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Mu vokom na, lNiniva ngata mmok mang e Yona he kngan vgum ko tpis tok kam pos ngang ngar orom karo rhek va mar ngat itgung ngartaro kerkeknen. Vanangko a tomhel langta tpis he, enda he mo kmuk he, tngae ho mi kut laut hak mang e Yona va mut lua mmok mang, he lua ngan vgum kmitgung mutaro kerkeknen e. He ekam tok, mnam a kolkha to o mia ngara sir ko pum E Nut kalo keik, lNiniva ngara sir kar muk ruk o mia nga main to tete va her mar ruk arhe ngar mia mon muk orom mularo kerkeknen ko her lNiniva ruk arhe ngat itgung ngaro kerkeknen, nang muk nove. Ii, va a kheng to nkong mSiba kat, ta parem ka mmie ka pun he klal kngae ngte kam vongnek kim e Solomon karo vu papat ruk lvu laol. Vanangko, mu vokom na, a tomhel langta tpis he, enda he mo kmuk he, tngae ho mi kut laut hak mang e Solomon va mut lua mmok mang, he lua ngan vgum kat e. He ekam tok, mnam a kolkha to mguak sir ko pum E Nut kalo keik, a kheng to endo nera sir kat ko kim E Nut kar muk ruk o mia nga main to tete he kmon muk orom mularo kerkeknen enang tok kat.” ");
INSERT INTO sua_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Mu vokom na, a mhel nam lua sgam a mmok to kle totokim orom a plo, i o kam tuvgom ko ma tong kat e! Nove! Nam kle va kaendavloum a rek ko pgeik msim he kael kmel a mmok kim o mia tgus ruk ngat re kam vavaik kun ma rek, mar kam smia nho kim a mmok to endo. ");
INSERT INTO sua_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","He kmikkiem a papat to endo tok, ila lo keik nginma khenam a mmok ngang in kat. Va enangthe ila lo keik nginp smia ya he kol a mmok to endo, va ngir ho gia vle, yin tgus hak orom a mmok, nang nop ke vur mhe ngang in orom a slommok e. Vanang enangthe ila lo keik nginp kle kernonho he lua kol a mmok va nginera ngae ho mi ktua slok hak, va yin ngir ho gia vle yin tgus hak orom a slommok, nang nop ke vur mhe ngang in orom a mmok kat e. ");
INSERT INTO sua_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","He ekam tok, ngiak ngangreal ngang yin kam smia kol a mmok, matok koknaik ngira senkrip kim ke mmok to kun mnam yin ko ka mi mit msim ta kle mia vle te, a ho slommok hak he. ");
INSERT INTO sua_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ko enangthe ngia ho vle yin tgus hak orom a mmok to endo, nang nop ke vur mhe ngang in orom a slommok, va ngir kle ho gia mmok tgus hak gi enang a mmok to nma mmok klik he kvaller yin.” ");
INSERT INTO sua_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","E Yesus ta rere knop, to a Parisiau langto ta vaeng kam ngae kaemik ko kim. To thera ngae kpis korsang kmemik. ");
INSERT INTO sua_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Vanangko a Parisiau to endo ta vokom e Yesus ko tlo sim ktar kaelel singni kam parrur na, en kam mmok ko pum E Nut kalo keik, nang kle gi kolaspa kmemik to ther kait ka ngaung kim he. ");
INSERT INTO sua_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","To Ngoldaip ta tar tok, to kreng te, “Muk o Parisiau muma vle enang o kolhi va o tonggai ruk muma momgol mar ko muma momgol ngakro gi vok ku mnok, nang kam mnang ngar kun mnam mar. Muta vle tok, ko mum gi mrua momgol mularo gi vok tuk tok kat, he nang mularo gi vok kam mmok ko pum E Nut kalo keik, vanang kun mnam muk, muma sovet kam kol a regesal mang o mia kmaurur ngaro krek mkor mar vgum mularo vurkul ruk ngat ho mi kut kernonho hak. ");
INSERT INTO sua_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ii, muk mularo lpetuk ngat ho mi ktua tok hak, ko E Nut tkueng mularo vok va mularo ngaongtok kat. ");
INSERT INTO sua_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ekam tok, endruk ngma tu kmo tgoluk, her mar ruk arhe mguak kle ka mrung ngar kun mnam mularo vurkul he ka nngiar ngang ngar na, yek mguer kle kpis la mmok ko pum E Nut kalo keik vgum tok. ");
INSERT INTO sua_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Vanang suvrum muk ruk o Parisiau, ko muma tagur pum mut ke keknen mruo to kam koprang orom o pnul, o tiptip va o lkiet he kmommen ngaro mhetor te loktiek kam vua nngiar ngang E Nut orom nga mhe to atgiang, nang kle gia kaennegiang E Nut ka keknen to kam ring ya mang mulenar va mang ka keknen to kmelongtok mang E Nut kat. Mup kle kpupam o keknen ruk endri tgus ha, he lo gia tagur pum mut ke kor tuk e. ");
INSERT INTO sua_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Va suvrum muk gi tok kat ge! Ko muk ruk o Parisiau mum mrua kansgum muk mang o ngorsang ruk o mia ngma nho orom mar kun mnam muk o Yuda mutaro rektor ruk ngma rere mnam mar. Va muma sovet mang o mia kam mon muk te, ngalmialaol orom muk ko pum o mia ngaro kerok ko mnam o mhetor ruk ko ma gi vle kat. ");
INSERT INTO sua_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Va suvrum muk gi tok kat ge! Ko mut kaenang o nnak ruk o mia ngat eguyang o mnes kun mnam mar, nang lo kavang o nhep akor ko kim mar kam khenam mar ngang o mia, mar kam mnor mang ngar e. To o mia ngam gi kaol kpis gia karkar malpgem mar, nang lua mnor mang e, he o yoror ngaro val ngma hori mang ngar tok.” ");
INSERT INTO sua_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","E Yesus ta re tok, to a pattermia kmo pos langto tkaekon ngang te, “Pattermia ya kering ngor kat orom ilaro rhek ruk endruk.” ");
INSERT INTO sua_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Va e Yesus tkoripang te, “He suvrum muk kelenar ruk o pattermia kmo pos kat, ko mum vu kaen o pos ruk lvankue ngang o mia, mar kam sei vgum mar he ngma kapnes vgum mar ko ngam sia khanang ngar kmikkiem mar. Vanang muk, mum ngae her gi mrua sisrim singni, nang lo vrua turang ngar kmikkiem mar e. ");
INSERT INTO sua_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Va suvrum muk gi tok kat ge, muk ruk mungores ngat im o propet ruk tennik, ko her muk ri tete arhe mum kaem a pnes to a nnik kam ring ngaekmol kmelel o propet ruk endruk ngakro sogi. ");
INSERT INTO sua_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","He ekam ko muma ring ngaekmol kmelel ngakro sogi, tmia khenam te, muta tting kmenserpgam a pat to mkor mungores, endo kmim mar kngam mar o yoror tok kat arhe. ");
INSERT INTO sua_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","He ekam tok, her muk ri tete arhe, E Nut ka pat langto tmi kael mit ormuk. Ko E Nut ta ktar kpavap mang nguk orom karo papat ruk lvu laol hak enang tok arhe te, ‘Ngor kaen kuaro propet kar kuaro aposel ngang ngar, he ngara kol a regesal mang akuruk va kaim akuruk kngam mar o yoror.’ E Nut te mrua pat orom ka pat tok, he ");
INSERT INTO sua_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ekam tok, her muk o mia ruk nga main to tete arhe mguer mia ngam vgum o gidiel ruk mkor o propet tgus, endruk mungores ngtim mar tennik. Ii, mguer mia ker kol a kapnes to mang o propet ngaro gidiel tgus tok vgum E Nut. Ko o propet ruk kmelha tennik ko E Nut tgi gnua kueng a mmie kngae kais mang endruk tete, ngaro gidiel ngta vle kuo mang nguk. ");
INSERT INTO sua_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ii, ko mungores ngat kaelha orom e Abel kmimim mar tgus kam ngae krum orom e Sekaraia ko ngtim kun mnam E Nut ka maksien ko pgegom a psen to a totur va ka rek to a totur. Ii, ko mi ktua havaeng nguk te, her muk ri tete arhe mguera ker kol a kapnes to endo mang ngaro gidiel tgus. ");
INSERT INTO sua_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ii, muk o pattermia kmo pos mguera kerkol a kapnes ko vgum E Nut tok, ekam ko muma hohos kim o papat ruk o minar mang E Nut ka tavgo he kavettom o mia ko ngma re kam kol. He ekam tok, muk kat mut mrua kavettom muk mruo enang tok kat arhe, he lua vaik ku meorom E Nut ka tavgo kat e.” ");
INSERT INTO sua_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","E Yesus trum karo rhek, to kparem o Yuda nga rek to kam rere mnam ko tok, to o pattermia kmo pos kar o Parisiau akuruk ngat her kaelha kam ho ksovet kam sir malngaeng orom ngaro vu resik ngang he, he kirpagis orom o rhek. ");
INSERT INTO sua_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ngta vle tok, ko ngta svil mang e Yesus kam mrua ru pum karo mur rhek mruo, nang mar kam le kmon orom a kerkeknen tok. ");
INSERT INTO sua_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","O Parisiau va o pattermia kmo pos ngta vle ko tok vop, vanang o mia kavurgem hak ngat hera veet va kveet gi he kmopet ngok kim e Yesus he kmo klung mnam mar kais ko ngat mrua karkar mang ngar mruo. To e Yesus tkaelha kam reng kalngunes ko kim a mumu to endo mang a ngaor to ngma mon te, a yis. Thavaeng ngar te, “Mgua sim ktua ngangreal ngang nguk mang o Parisiau ngaro papat ruk ngam vua kerruru ormar ko ngma ker patter o mia ormar. Ko ngaro papat ruk endruk ngta vle enang ke ngaor to a yis ko nma himhim orom a bret kam ho khibul hak. ");
INSERT INTO sua_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ii, mgua sim ktua ngangreal ngang nguk mang ngar, ekam ko o papat tgus ruk o mia ngma kir mang ngar kam tuvgom mar, E Nut ner kle ka khenam mar ma mmok. ");
INSERT INTO sua_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","He ekam tok, oni rhek ruk muma koon mang ngar he krere mang ngar ko ma slommok, E Nut ner kle kpolgerik ma mmok. Va o rhek ruk mum vur re ormar ko ma tvokmok, E Nut ner kle kpolgerik ko ma vle ko kim o mia ngaro kerok kat. ");
INSERT INTO sua_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","He ekam tok, kolenar, kua havaeng nguk te, mguak or kam gorang endruk ngat gi kais kmel muk kam ngatngae kim mulakro gi pkor tuk, nang lo kais kam kering mularo nunu kopekam ko mut yor e. ");
INSERT INTO sua_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Vanang ngor kle kaengorang nguk mang Endo mguak gorang. Mguak kle kgorang E Nut ha, ko her En arhe to ta kpom a serppak to kam ngam muk ngogu mGehina ko tok mnam a paei to a vleir, kopekam ko o mia ngat ngatngae kim mularo pkor he kngam muk o yoror. ");
INSERT INTO sua_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mu vokom na, o gi vrong iningol, o mia ngam lo vu kaelongtok mang ngar e. Nove, ko o mia ngat kais kmenkim aktiek orom ke lo gi kre ruk a gi lomin e. Vanangko E Nut nam kle ho lua kikiangae mang tang mnam mar hak. ");
INSERT INTO sua_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Si mularo ngairis ko malpgem muk kat, va E Nut ta kser a ken mang ngar te, ngat is te, aner. Ekam tok, muta kta gorang o mia kman, ko E Nut ta mnor te, mut vu laut kir kim o gi vrong iningol tgus. ");
INSERT INTO sua_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Gi enang tok, ani mhel to na mrua havae mang en mruo ko kim o mia ngaro kerok te, ka mhel to dok orom, va A Mhel To Nkong Man Ma Volkha to dok kat ngor mrua havae mang dok kat ko pum E Nut karo engyel ngaro kerok kat te, kua mhel to en orom tok kat. ");
INSERT INTO sua_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Vanang ani mhel to na ker kvam dok ko pum o mia ngaro kerok, va dok kat ngora ker kvam a mhel to endo ko pum E Nut karo engyel ngaro kerok tok kat. ");
INSERT INTO sua_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Va o mia tgus ruk ngta rere vgum A Mhel To Nkong Man Ma Volkha to dok, E Nut tkais kam mia lol ngaro rhek patgiang ngaiting. Vanang a ni mhel to ta kerrereng E Nunu A Totur, E Nut ner mia kpom karo rhek he lua lol patgiang ngaiting he lua kikiangae mang ngar hak. ");
INSERT INTO sua_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","He mnam o kolkhek ruk ngaka srim muk kun mnam o Yuda ngartaro rektor ruk kam rere mnam mar va ko pum endruk ngma vongnek kim o rhek va endruk ngta nho mang nguk, va mguak or kam vua papat te, kam mrua havae nngia mang dok. Va mguak or kam vua papat mang oni rhek ruk mguak koripang ngar ormar. Va mguak or kam vua papat kat mang oni rhek ruk kam mrua hahaong nguk ormar kat. ");
INSERT INTO sua_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ekam ko E Nunu A Totur mruo ner mur kaen o rhek kun mnam muk orom oni papat ruk muk kam rere ormar mnam a kolkha to endo ke vgon to endo msim.” ");
INSERT INTO sua_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","E Yesus thavae tok knop, to a mhel langto kun pgegom a mumu to ta re te, “Pattermia, havaeng ko nopia he en kmommen o tgoluk ruk mkor mo teit he is kim muo ko mo teit tyor parem muo ormar.” ");
INSERT INTO sua_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Va e Yesus tkoripang te, “Kambis, klo kais e, ko dok nong a mhel to ngat el kam vongnek kim o rhek mo kmae e.” ");
INSERT INTO sua_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","To ta hoger karo rhek kam reng ngar te, “Mgua le va sim kut mur kaelel kuo mang nguk he sim ktua toot mang nguk mruo, muk kam lua knun mang o gi vrong tgoluk. Ko a mhel tlo kais kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik vgum karo vu tgoluk e.” ");
INSERT INTO sua_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","To e Yesus ta kle keknen mang ka papat to endo orom ka ngothoi ta te, “A mhel to karo vu tgoluk, ka loot te sei kam ya orom karo tgoluk ruk tkap. ");
INSERT INTO sua_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","To a mhel ta, ta pat he te, ‘Ngola, nguak kanker kuaro tgoluk ri, ko nop ka rek ngang dok ko ta laut is dok kam lluol mnam kua loot he kaelpas orom o olngaemik kun mnam e.’ ");
INSERT INTO sua_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","To tpis mang a papat langto he te, ‘Ngor kaeharom ti: Ngora lelget kuaro rektor ruk nong ker laol, nang kle khover endruk vur laol, dok kmelpas orom o olngaemik kun mnam mar. ");
INSERT INTO sua_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","To dok kam her gia higiang ngar he, ko ngat her gia vle ko rkieng dok mang koknaik koknaik, he dok kam lo kta papat mang ani tomhel tang kat e. Ngor gia vle kmorsang he gi kaemik va kaivie ngnik ngnik ko he.’ ");
INSERT INTO sua_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ta sovet orom ka papat tok, vanang E Nut te ktua re te, ‘Yindo ila lpek tho mi ktua tok hak, ko ngka masegain ngora vaeng in petgim ilaro tgoluk ruk endruk, to erieto nak lol ilaro tgoluk ruk endruk yi elpas ormar ngang in mruo?’” ");
INSERT INTO sua_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","E Yesus tkothoi knop, to hera rum karo rhek kam reng ngar te, “Nera vle gi enang tok arhe ngang o mia ruk ngam vu kaelpas ngang ngar mruo orom o tgoluk ruk mo mmie, nang lo vu kaelpas orom mar mruo ngang E Nut.” ");
INSERT INTO sua_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","E Yesus ta re tok, to kle kreng kalngunes te, “Ekam tok, kua havaeng nguk te, mguak or kam vua ngaungputput mang mula ngorsang te, anito kmem, i o oni tgoluk ruk mang mularo pkor kmegenkarik kat e. ");
INSERT INTO sua_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pathe nok muta pat te, mularo olngaemik ngat laut gi kir kim mularo ngorsang vor? I o nok pathe mularo it ngata laut kir kim mularo pkor kat vor? ");
INSERT INTO sua_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mu pat mang o porgagat na, ko mar ngam lua kap o tgoluk e, va ka lluol e. Va ngam lo kaelpas orom o olngaemik kun mnam ngakro ngainir, i o kun mnam o hi ngakro nhotor kat e. Nove! Ngam lo kaeharom tok, vanangko E Nut nam kle ktua klang ngar mlol ge. To muta pat nngia? E Nut nma khen mar, nang kle kikiangae mang nguk gi? ");
INSERT INTO sua_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mu havaeng dok na, erieto mnam muk tkais kam vrua hoger ka ngorsang mo mmie kam vur kta hok ko enangthe nam vua ngaungputput mang o vu tgoluk? ");
INSERT INTO sua_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","He ekam tok, ekam ko mut lo kais kam vur kta hoger mularo ngorsang tok, va kman ko mum vua ngaungputput mang o vu tgoluk tok. ");
INSERT INTO sua_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kmikkiem enang tok kat, mu pat mang o ngaergot ngakro rehi na, ko ngam mrua pasrengem mar mruo orom ngartaro sreng nngia? Ko ngam lua pum ngaro katam kmegenkarik e. Nove. Vanangko kua havaeng nguk te, si e Solomon ko en karo it ruk nma pasrengem en mruo ormar ngaro vu kraen hak, vanangko en tlo kais mang o ngaergot ngakro rehi ruk e. Ko E Nut nma pasrengem mar kir kim e Solomon ktaro sreng ruk endruk. ");
INSERT INTO sua_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ii, mu vokom na, si o ngaergot ruk endri oguon mail ngam gi vrua vle nong ke laut e, to hera vui, nang o mia ngam her gia ngampaei pmar, vanangko E Nut nam kle sim ktua pasrengem mar ge orom ngaro rehi enang tok kat. He ekam tok, enangthe E Nut nma pasrengem o ngaergot orom ngakro rehi enang tok, va muta pat nngia? En tlo kais ge kam smia tar muk kat kam pasrengem muk tok kat kir kim mar? E-e, muk ri arhe mut ho mi ktua kenhor mang E Nut hak! ");
INSERT INTO sua_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","He ekam tok, mguak or kam ngaungputput mang anito kmem va mang anito kmiviem kam vua riring ngar e. Ii, mu or kmel o tgoluk ruk endri ktar ko pum mularo kerok tok, ");
INSERT INTO sua_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ko her o vrong rhek ruk mo mmie arhe ngam kael ngaung mang o tgoluk ruk endruk kmel mar ktar ko pum ngaro kerok enang tok arhe. Nangko mu Teit ta mnor te, o tgoluk ruk endruk ngma tu kim muk. ");
INSERT INTO sua_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Vanangko muk, mguak kle va kael E Nut ka tavgo ktar ko pum mularo kerok he ktagur pum en kam vaas kim o mia, kam komor mar, yek E Nut ner kle sim tar muk orom o tgoluk ruk endri kat. ");
INSERT INTO sua_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","He ekam tok, muk ruk mut kaenang ke murgun to orom o sipsip mu or kam gor e, ko mu Teit ta sirei kmel muk kam vle ku meorom ka tavgo. ");
INSERT INTO sua_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ii, he ekam tok, mularo tgoluk ruk mum kaelpas ormar mguak kaenik ngang o mia, mar kmenenkim mar mkor muk. To mguak lol o krek to le kaenik ngang endruk ngma tu kmo tgoluk. He enang tok, a keknen to endo nera vle te, her mula gol ka pun msim arhe, endo mut mi kaelpas orom kuon ma volkha. Ko ko tok kuon ma volkha ta vle te, mula ngaelpas msim to tlo is hak kam kernonho. Ii, va mularo gol ngo pneik ruk kuon ma ngaelpas to tok, ngat lo is kam nop kat e, va o ngauruvik ngat lo is kmururik, va o soma ngat lo kais kat kam papaamrik kat e. ");
INSERT INTO sua_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ii, mguak kaeharom tok, ekam ko ani tomhel to mut kaelpas orom kun mnam mularo vurkul te, mula gol ka pun, va a her tomhel to arhe mguera sovet kmel ktar ko pum mularo kerok kat.” ");
INSERT INTO sua_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mgua sgam o mmok kam gia mmok va sim kut kaegenkar mularo it kserpgam mar, ");
INSERT INTO sua_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","enang a taven kalngunes ko ngama sgam a mmok va kaegenkar ngaro it kmeha ngang ngarlaip to ngat paneng ko tre kmeknik ko pa pnes to mkor a lei. Ko ngat paneng kam her kaeknik, mar kam gia koregot kim ngatngae, nang lo kta hus kat ko nera pis he kvae ngang ngar. ");
INSERT INTO sua_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kua havaeng nguk lmien te, a taven kalngunes ruk ngat sim kaelel kuo mang ngar he kpaneng ngalaip tok ko nap sia pis pangnaom mar ko ngta vle gia toot mang, ngar mi ktua sirei hak. Ii, ngara sirei ekam ko ngalaip mruo ner kle kpis kaegenkar kta yet mruo smia serpgam, nang kle kreng ngar kmorsang, en mruo kam le ktua krong o ol ngang ngar. ");
INSERT INTO sua_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ii, kalngunes ri ngar mi ktua sirei hak tok, ko si enangthe ngalaip nap sia pis pangnaom mar ma segain ka ho ngaenvurgem, i o mo kao, va mar ngat her kael kuo mang ngar kpaneng he. ");
INSERT INTO sua_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Vanangko mgua kol a papat to enda na, ko enangthe a rek kteit npa ktar mnor mang ani kolkha ka ni mhe to lsir a ngauruvik ner kaol mnam, va tlo is kmennegiang ka rek, he a ngauruvik kam kher e. ");
INSERT INTO sua_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ii, he enang tok, muk kat mgua sim kut kaelel kuo mang nguk mruo he ktoot tok kat arhe kam paneng A Mhel To Nkong Man Ma Volkha ko en kat nera pis pangnaom muk gi enang tok kat arhe.” ");
INSERT INTO sua_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","E Yesus ta re tok, to e Pita ta mnganang te, “Ngola Ngoldaip, yi kothoi ngang ngor tuk, i o ngang o mia ri tgus?” ");
INSERT INTO sua_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Va Ngoldaip tgi koripang e Pita te, “Ngora havaeng nguk mang a taven kalkayie to karo papat ruk vu laol he vu sim kut kael kalaip he sim kut kaeharom karo reha ruk nam kaelik maktiegom. Va her kalkayie to arhe kalaip tel kam nho mang kalngunes tgus ruk ngam kaeharom karo reha tgus en kam klang ngar mlol mnam ngaro kolkhek ruk kam lol mnam mar ko en ta ngae ngok mnam a mhe langto ko yok. ");
INSERT INTO sua_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","44","Enangthe kalaip nap kaeknik kpis pangnaom ko nam hivuo kam sim kaeharom karo reha ruk telik maktiegom va kalkayie to endo ta lgekol hak. Ta lgekol ekam ko kalaip ner kle ho gi kael kam nho mang karo reha tgus hak. ");
INSERT INTO sua_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Vanang enangthe kalkayie to endo npa vle ktar lhus kim kalaip te, ‘O-kolaip te hok khus hak kmeknik,’ to le kaelha kmim klenar ruk lurokol va lraip tgus he gia vle pum a ngaemik va a ngaivie kngae kveve, va ner mi ktua senkrip kim ");
INSERT INTO sua_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kalaip ko kalaip na le kaeknik kpis pangnaom enang tok. To kalaip nera kaim lhomye kmen o kapnes ruk lvankue hak ngang to le kaen en kam kol a kapnes to endruk ngam lua ngan vgum E Nut ngara kol. ");
INSERT INTO sua_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ii, o kapnes ngara sovet ngang tok arhe, ko ani kayie to te smia mmok mang kalaip karo svil, vanang kle lo sim kut kaelel kuon mang, i o lo kaeha kaikkiem kalaip karo svil ruk endruk, her en arhe ner ho mi ktua lol o kapnes ruk lvankue hak ekam ko tvua mmok mang kalaip karo svil ruk tok, nang lo kaikkiem mar. ");
INSERT INTO sua_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Vanang a kayie to tlo smia mmok mang kalaip karo svil, nang kaeharom o kerkeknen ruk kmiser a kapnes, en ner lo vua kol a kapnes a vu laut e. Ii, ta vle tok arhe, ko endruk E Nut nam kael o papat va o reha maktiegom mar, E Nut nma nho mkor mar kam sim kut kaeha orom mar kmikkiem kais tok. Vanang endruk E Nut nam kael karo vu papat va karo vu reha kavurgem maktiegom mar endruk ngarlavurgem kir kim ngarlenar, E Nut nam ho vua nho mkor mar kam sim kut kaeha orom mar kmikkiem kais tok kir kim ngarlenar tok kat.” ");
INSERT INTO sua_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","To e Yesus ta le kre te, “Vanangko kua vnek ngnok vop, va a vnek to enda nam gia kokol dok he kom sia vavle ngang ekam ko ner mia rum kim dok enang a paei to nam kaem a rengmat tgus. He kom gia svil hak mang a paei to endo kam vurvur to le kharap he. Ii, kua vnek to endo ta vle enang a paei ko, ko her pis moti kam giem a paei kun pgegom o mia. ");
INSERT INTO sua_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nok pathe muta pat re te, kua pis to mo mmie ta vle mang kmel a mokaum kun pgegom o mia, he mar kam smia vle vor, ngola? O-o, ho mi kut nop hak! Ko vgum dok, a mokrur ner le ka vle kun pgegom o mia kam mo kser mar. ");
INSERT INTO sua_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ii, ko kmelha tete kam ngae, kun mnam a valngan langto orom endruk aktiek, ngar mrua mommen mar mruo ko korlotge mnam mar ngar kaum ksir mo kmar kam kikir kim aloruk mang dok. ");
INSERT INTO sua_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ii, nera vle tok, ko “Omotter ge, o monner ge, o morvleik tgus ngar mrua sir mo kmar ge kut mar mruo ge he kmo kikir kim mar mruo mang dok.” ");
INSERT INTO sua_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","To e Yesus ta havaeng a mumu to endo te, “Muk muma vokom o varhek ko ngma kaum ogun ko a kolkha nma vaik va muma havae te, ‘O, a kus ner mi kaerik he,’ to lmien a kus nam her kaerik. ");
INSERT INTO sua_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Va mum re ngan a ngausgi ko nam kaol ngman kuon va mum hera havae te, ‘Ii, a kolkha nera vle,’ to lmien ko a kus nam lo kaerik e. ");
INSERT INTO sua_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Muk mularo naprai alomin, ko mut sim ktua mnorvek pum o ngaelmir ruk orom a ngausgi va o varhek ruk man ma volkha va endruk mo mmie kat, vanang kman ko mut lo kais kam mnorvek pum o ngaelmir ruk ngta pis ormok kun mnam ke venloot to tete?” ");
INSERT INTO sua_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kmikkiem enang tok, muk mruo mgua marer he smia ngangam kim muk mruo mang o ngaelmir ruk mang dok, muk kam mia mnor kun mnam muk mruo, he mrua havae mang ngar lsir te, mar o minar o nop. ");
INSERT INTO sua_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ii, langto langto mnam muk ngiak marer he sim kut kaeharom tok, gi enang ko ima marer kam ngangam kmin kam sirim o rhek kar ila imuo ko ta mon yin orom ila kerkeknen he kait yin kngorom yin ngok kim endo nma vongnek kim o rhek. Ii, ngiaka ktar kmarer kam ngangam kmin mang ila imuo tok ko va ngaelaut, matok meak pis ko kim endo nma vongnek kim o rhek va ila imuo nap kir kim yin to kle kael yin ko maktiegom o momngan, to en ner le kael yin ko maktiegom o toot kmo mia, mar kmenpasiker yin kun mnam a hengor. ");
INSERT INTO sua_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ii, va kua havaeng nguk te, ko tok mnam a hengor to ngira vle mnam, ngir lo kais hak kam kat kottek mnam kais ko ngiak ngae ho mi kut rum a keik to ngat el kuo mang yin kmen.” ");
INSERT INTO sua_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mnam a kolkha to endo o mia akuruk kun mnam a mumu to endo ngta havaeng e Yesus mang lGalili akuruk ko tesgun mnam a kolkha langto ngta hivuo kam nngiar ngang E Nut, he e Pailet tengu ngar kmim mar kun mnam E Nut ka maksien. Ngat kaim mar he ngakro gidiel ngta ksuk ku mmie kmo vavaik kar ngakro ngaemslang ngakro gidiel ruk ngat us kam nngiar ormar ko ngakro gidiel ngta ksuk ku mmie kat. ");
INSERT INTO sua_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","To e Yesus tkoripang ngar te, “To ekam tok, muta pat re te, lGalili ruk endruk ngat vu eharom o kerkeknen kir kim nglenar, he ekam tok, ngat kol a yor ka mten to endo? ");
INSERT INTO sua_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ho mi kut nop hak! Vanang ngor kle khavaeng nguk te, enangthe mgua lo kaitgung mularo kerkeknen va mguera kol a kapnes to la vanker enang ngar ko ngat kol a yor to la vanker tok kat arhe. ");
INSERT INTO sua_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ii, o muta pat re te, lSiloam ruk loktiek he aktiek hori orom korlotge ngat vu eharom o kerkeknen kir kim endruk tgus mYerusalem he ekam tok, nga rek to klahok ta vuut malpgem mar he kaim mar tgus vgum tok kat? ");
INSERT INTO sua_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ho mi kut nop hak! Vanang ngor kle khavaeng nguk kat te, enangthe mgua lo kaitgung mularo kerkeknen, va mguera kol a kapnes to la vanker enang ngar ko ngat kol a yor to la vanker tok kat arhe.” ");
INSERT INTO sua_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","To e Yesus ta kle kothoi ngang ngar te, “A mhel langto ka ho to a pik ta sir kun mnam ka loot to orom o grep he nma ngae kam tamarik va nam pis sia nho. ");
INSERT INTO sua_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","To ta reng kalkayie to ta nho mang ka loot te, ‘Kua kanko kam pis ktamar o pik mo vgum a ho ta mo pnes ruk korlotge va kom pis sia nho vgum, he tete ngiak kovver ko tgia hop kim o tgoluk va ka mraen tkaim mar, he ngat lo kaehi e.’ ");
INSERT INTO sua_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Va kalkayie tkoripang te, ‘Kolaip, ta ya yin kam mnang na, he kvokom mnam a pnes to en man te, en na kaehi i o nop, ko ngora kaum a mmie ku pum na. ");
INSERT INTO sua_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","To enangthe na kaehi mnam a pnes to en man va ta ya, ngor lo kovver, vanang enangthe nop to ngua her le kovver ko tok he.’” ");
INSERT INTO sua_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tie ma Sabat langto e Yesus ta vaik kun mnam o Yuda ngartara rek langto kam rere mnam ko tok mnam a rengmat to endo. Ta vaik to le kpatter o mia. ");
INSERT INTO sua_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Va ko tok a vlom langto ta vle kat. Ka sai tkal vgum a koot ko tviging he ka kpom mnam o pnes ruk loktiek he aktiek hori orom korlotge he. Va ka sai tho mi kut kal hak he tlo kat kais hak kam kta sir kat e. ");
INSERT INTO sua_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","E Yesus tre kvokong tok, to hera vaeng ngok kim, to hera reng te, “Kolkheng, ko her hong in pum a koot to tviging yin ka serppak.” Ta re tok, va a gi hi to tkael kalo ktiek kuo mang, ka sai ther gi sir ngatngae to ther kaelha kam kanprim E Nut. ");
INSERT INTO sua_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","To a mhel to ta nho mang o Yuda ngarta rek to endo tkaesik ko e Yesus teharom a vlom to ma Sabat, to tle ka kner o mia te, “O kolkhek ruk kmeha mnam mar ngat kais te, aktiek hori orom atgiang, he ngruak pis mnam o kolkhek ruk endruk kmeharom o mia, vanang mnam o Sabat ngruak or.” ");
INSERT INTO sua_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","To Ngoldaip ta kle ka kner en he kpupam o mia tgus kam re te, “Muk mularo naprai alomin, ko langto langto mnam muk na lua hong ka bulmakau i o ka dongki pum ka ngausie kat gi ko nam totokim kun ma hengor he ka ktong kngorom kam ngae vur kaivie mnam o Sabat gi? ");
INSERT INTO sua_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","He ekam tok, mu vokom a vlom ta na. En e Ebrehem kaes msim, va e Seten te ktotokim mnam o pnes ruk loktiek he aktiek hori orom korlotge he, he tete ma Sabat to enda klo kais gi kam hong en pum e Seten ka serppak, ko tngae vua tokim tok kat?” ");
INSERT INTO sua_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Karo rhek ruk endri ta rere ormar tok ngat mi ngam leep hak mang karo imuo ruk ngta vle ko tok he ngat mrua koon pum mar, vanang o mia ruk pa rengmat ka pun ngta kle va khigiang karo reha ko ngate sei kam sor kmar hak. ");
INSERT INTO sua_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","To e Yesus tkat kothoi te, “E Nut ka tavgo ta vle nngia? Ani koka to tkais he dok kam keknen orom mang E Nut ka tavgo? ");
INSERT INTO sua_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","E Nut ka tavgo ta vle enang ko a mhel ta kol a ho to a mastat ka khek ko ke ho mi laut hak mang o tgoluk tgus ngo khek ruk ngma kap kun mo luteik. Tkol he kngae kavang kun mnam ka loot. Ta pus he klaut kngae kael en a ho, to o iningol ruk kuo kia gan ngam hera ngae kpis kngam ngainirik ko vgum karo khator.” ");
INSERT INTO sua_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","To ta kta keknen ngang ngar orom a koka langto vat te, “E Nut ka tavgo ta vle enang ko a vlom langto ta kol a bret ka mit to klalaut he kael ke ngaor to a yis kun mnam kam movavaik kar. A yis ta movavaik kar he le ho kaeharom a bret ka mit kam himhim orom to ta kle ho gia hibul hak vgum.” ");
INSERT INTO sua_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","To e Yesus ta ngae kaelha kvaik kottek mnam o rengmat va o maksien he kpatter o mia gi, kmikkiem a ngaelaut ko ta ngae mYerusalem. ");
INSERT INTO sua_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","To ko mnam a rengmat langto a mhel langto ta mnganang e Yesus te, “Kolaip, nok o mia lgititge E Nut nera sulgim mar he klol ngaro kerkeknen patgiang ngaiting kmen a ktalhok ngang ngar, i nop gi?” Ta mnganang tok, va e Yesus tgia pupam o mia tgus ruk kun ma rengmat to endo he kreng ngar te, ");
INSERT INTO sua_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mguak mur kaenenker orom muk mruo tete kam vaik ku meorom E Nut ka tavgo ko vgum ke ven ka gu to ta koka kaut, muk kam kol a ktalhok to kam plong vle ko kim En ngnik ngnik. Ko o mia kavurgem ngma kaegegom ko yok kam vaik ku meorom, vanangko ngat lo kais e. ");
INSERT INTO sua_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mguak mur kaenenker orom muk mruo tete tok, ekam ko a rek kteit na re gi hop he gi vat a ngaegot kim muk he mguer gia sir ku mnok he kaelha kmaurur kim te, ‘O-ngortaip-o, he ngia koregot kim mor vanie.’ Vanangko en ner kle koripang nguk te, ‘He klua mnor mang nguk ri e. Va klua mnor mang nguk te, mut ottek tam kat e!’ ");
INSERT INTO sua_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","To muk mguer kaur kim gi te, ‘He mor ri arhe ruk ngom kaem pnes kar yin va yin ima patter mor kngae kun mnam nguaro rengmat kat.’ ");
INSERT INTO sua_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Va a rek kteit ner kat koripang nguk te, ‘He klua mnor mang nguk ri e. Va klua mnor mang nguk te, mut ottek tam kat e! He mu ehenok petgim dok, muk ruk mum kaeharom o kerkeknen ruk ngat ho mi kut kernonho hak.’ ");
INSERT INTO sua_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","29","A rek kteit nera likim muk ngku mnok to mguera sir ko tok he khem mularo ngnorok mo kmar va kaee he kervuvui vgum o nganngannes ruk mguera lol. To mguera kosnok kim e Ebrehem, e Isak, e Yakop, o propet tgus va o vrong rhek kat ko ngar kottek ko mnam a mmie karo ngaitngol tgus he kaum ku meorom E Nut ka tavgo. Ngara kaum tok, kam liepum muk kam lol mularo ngaekmol ngang ngar mruo, mar kam kle ktua tuur mnam E Nut ka pnes to nera kpom mnam a kolkha to ka tavgo nak komor o mia tgus. Vanang muk, nove! Ko a rek kteit nera pepet muk, muk kam lua tuur mnam ka pnes to endo e. ");
INSERT INTO sua_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ii, mu vokom na, nera vle tok kat ngang endruk ngaro mnok tete ko E Nut ner kle ka krus orom akuruk mnam mar koknaik. Va nera vle tok kat ngang endruk nop kero vur mnok ngang ngar tete, ko E Nut ner kle khover mar koknaik kat.” ");
INSERT INTO sua_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mnam o kolkhek ruk endruk o Parisiau akuruk ngat kaol kpis ko kim e Yesus to kreng te, “E Herot tkaen a re mang in, ngar kam por in, he ngiak parem a mhe to enda, nang kngae ngok mnam a mhe tang ko yok he.” ");
INSERT INTO sua_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Va e Yesus tkoripang ngar te, “Mguak kaeknik he khavaeng la pendol to en te, ‘Ngor vur kaeharom kuaro reha vur kat na kam kerer o kool va kmeharom o mia pum ngakro yor. Ngor kaeha tok kam rum kuaro reha tgus na, to endo yek, nga hera tarkanang dok ko tok.’ Pu tok, vanangko, ngora ngae ge kam ngae ngok mYerusalem kmeharom kua ngaeha, endo mar kam her kaim dok kngam dok a yoror, ko a val to kmim o propet ta vle vop mang her mar ruk lYerusalem arhe ko tok mnam nga rengmat lsir. ");
INSERT INTO sua_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O-kelenar-lYerusalem-o, a rengmat to e Yerusalem he, mum ngorom a im o propet ruk E Nut tmeng ngar ngok kmuk ko muma lalaem mar kngam mar o yoror. He kom si kaelha tiok he kngorom a svil kam koon mang nguk enang a ngaining ko nma koon mang kles ku meorom kalo ngaeho, vanangko muma kees ge. ");
INSERT INTO sua_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","He ekam tok, E Nut nera parem muk petgim ka maksien to endo. Va kua havaeng nguk te, mguer lo kta vokom dok, kam ngae kais mnam a kolkha to mguak kael a kavres orom dok he ka kni te, ‘E Nut ta ngamyammok mang ka taven to yin ko ya pis orom ka munik.’ ");
INSERT INTO sua_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tie ma Sabat langto e Yesus tpis kvaik kun mnam o Parisiau ngarlaip langto ka rek kmemik kar, va o mia akuruk ko tok ngat gia vle he smia keketar. ");
INSERT INTO sua_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Va ko tok, a mhel to ka vok ta lulussul ta vle ko kim kalo keik. ");
INSERT INTO sua_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","To e Yesus ta mnganang o Parisiau kar o pattermia kmo pos te, “Tkais kmeharom o yor ma Sabat, i o nop ge?” ");
INSERT INTO sua_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Vanangko ngat gia vongnek. To e Yesus thera kpom a mhel to endo kmeharom kam hong pum ka yor. E Yesus teharom tok knop, to hera meng kmeknik ngok mrek. ");
INSERT INTO sua_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","To ta kle ka mnganang ngar te, “Erieto mnam muk tlo kais kam ngae mamarer khong ka dongki i o ka bulmakau to agitgiang ko nap vuut ko pa huop ma Sabat?” ");
INSERT INTO sua_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ta mnganang ngar tok, vanangko ngat her gia vongnek kim kat. ");
INSERT INTO sua_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kam ngae, to ta tar ko o mia ruk ngat korosang kmemik ngta mrua kansgum mar kam lol o ngorsang ruk ngma nho ormar. To tkaelha kam patter mar orom ka koka to enda te, ");
INSERT INTO sua_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“O mia ngak me miik ngok ma pnes to mkor a lei, va ngiak or kam pis mrua kansgum in kam kol a ngorsang to ngma nho orom, matok a pnes kteit na le me mang tang ko ka munik ta laut kir kim in, en kam kol a ngorsang to endo. ");
INSERT INTO sua_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Enang tok, a pnes kteit to tme mang ngae tgus ner kaol kreng in te, ‘Ursie he en a ngorsang to endo ngang a taven ta na.’ To ngir ngae sei kam leep ko pum o mia ngaro kerok ko ngir kle korsang ko mnam a ngorsang to ko ngtu hak. ");
INSERT INTO sua_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","He ekam tok, nga re me miik ngok ma pnes tang, va ngiak pis korsang ko ngtu hak na. To a pnes kteit ner le mur kaol kreng in ko pum o mia tgus ruk ta me kmar ngaro kerok te, ‘Kola, hop he aol orsang moti mnam a ngorsang ta koma nho orom.’ He enang tok, o mia tgus ruk a pnes kteit ta me kmar ngar kle ka nho orom in vgum tok.” ");
INSERT INTO sua_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","E Yesus ta keknen tok knop, to hera reng ngar te, “Ii, o mia ruk ngam mrua kansgum mar mruo kam laut, E Nut ner kle ka krus ormar. Vanang endruk ngam mrua krus ormar mruo na, her mar ruk arhe E Nut ner kle ka nho ormar, mar kam laut kat.” ");
INSERT INTO sua_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tkothoi tok, to ta reng a ngorsang to endo kteit te, “Enangthe ngiaka me mang o mia mang ita ngorsang mruo va ngior kam me mang ilenar, iorkaik, i o ila valngan mruo. Va si ilaro pgirmia mruo ruk ngaro vu kirpik kat va ngior kam me mang ngar kat e, ko mar o mia ruk endruk ngat kais kmoripang in tok kat. To mguer gi kta moikie kam mo me mo kmuk ngnik ngnik tok arhe. ");
INSERT INTO sua_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Vanangko ngiaka kpom ila ngorsang va ngiak kle va kme mang endruk ngma tu kmo tgoluk, va endruk o kernonhor kar o nharyor va o vivisker kat. ");
INSERT INTO sua_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Enangthe ngiak kaeharom tok, va mguera lgekol ekam ko si enangthe ngat lo is kmoripang in tete, va E Nut ner kle kol nga ngaekam kam kle koripang in koknaik kun mnam a kolkha to nera hover endruk ngam sim kaikkiem karo pos petgim ngaro nnak.” ");
INSERT INTO sua_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","E Yesus ta rere knop, to a mhel langto kun mnam o mia ruk ngat kaemik ko tok, tre ngan e Yesus ko ta re tok, to thera re te, “Endruk ngar kaemik mnam E Nut ka pnes to nera kpom kun mnam a kolkha to ka tavgo nera vaas kim o mia tgus he komor mar, her mar ruk arhe ngat lgekol.” ");
INSERT INTO sua_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Va e Yesus tkoripang orom a ngothoi ta te, “A taven langto ta kpom ka pnes he kme mang o mia vang kam pagis. ");
INSERT INTO sua_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tie palngaem, ta meng kalkayie langto kam ngae kaen a re ngang o mia ruk tme mang ngar te, ‘Aol ngte na, ko kolaip karo ol ngat kikhi pum mar he.’ ");
INSERT INTO sua_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Vanangko langto langto mnam mar tgus ngat kaelha kmel ngakro praen. Langto ta reng te, ‘O-o, klo is kam pis e, ko ko gun enkim kua mmie ka mhe, he ngora ngae ktarkanang kam vokom na, he ilaip nak or kam vu kael ka pat mang dok e.’ ");
INSERT INTO sua_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","To langto ta re te, ‘O-o, ko gun enkim kuaro bulmakau ruk loktiek he kua re kam tarkanang ngar kmegom mar kam hegem a mmie ormar na, he ilaip nak or kam vu kael ka pat mang dok kat e.’ ");
INSERT INTO sua_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Va langto vat, ta le ktua tok orom kta pat to te, ‘O-o, ko gun lei he klo kais kam pis kat e.’ ");
INSERT INTO sua_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","To a taven kalkayie to enda tkaeknik kam pis kun mnam kalaip ka rek to kaekon a re ngang ekam o mia ri enang tok. To a pnes kteit to endo te sei kmesik ko ta ngnek tok, to ta kle kreng kalkayie he te, ‘Ngiak marer kvaik kottek kun mnam o rengmat va kero maksien, he ngia gi vrong kait endruk ngma tu kmo tgoluk va endruk o kernonhor kar o nharyor va o vivisker kat vanie mar kam pis kol o ngaekmol mo mnam kua pnes.’ ");
INSERT INTO sua_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kam ngae, to kalkayie to endo teknik to her pis khavaeng kalaip te, ‘Ngola kolaip, ko eharom a ngaeha to ye reng dok kmeharom he, vanangko o ngaekmol kavurgem ri ngat gia vavle vop.’ ");
INSERT INTO sua_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","To kalaip ta kta reng kat te, ‘Yu, tete ngiak lapsa kngae ngok mnam o rengmat ruk oguon mail vat he kaur kim o mia he kait mar ngte kam krong kua rek kais ko nak ngae kottep hak. ");
INSERT INTO sua_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ko kua havaeng nguk ruk mut gi gnua pis te, nong tang hak mnam endruk ko mia me mang ngar lsir, tkais kam tuur mnam kua pnes e.’” ");
INSERT INTO sua_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","To mnam a kolkha langto e Yesus tkaikkiem a ngaelaut va o mia kavurgem ngta veet ekam. To ta hortgi ngok kmar to khavaeng ngar te, ");
INSERT INTO sua_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Enangthe a mhel tang naka svil kmikkiem dok, vanang kle kael kteit, o knan, ktavlom, kles, kaornopeik, kaorlok, kaorotmeik, kaoroyel va si en mruo kat ko pum kalo keik ktar mang dok, va en tlo kais hak kam vle te, kolkayie to en e. ");
INSERT INTO sua_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ii, va enangthe na lua matnge vgum o vnek he mrua slak orom en mruo kam yor mang dok kat va a mhel to endo tlo kais hak kam vle te, kolkayie to en kat e. Ii, ko endo na lua svil kam vle enang a mhel to nam mrua slak orom en mruo kam mrua tolpum ka ho mruo to ngara krong orom o ot he kvat ko engnang kngam a yoror, he kaikkiem dok enang tok, va a mhel to endo tlo kais hak kam vle te, kolkayie to en kat e. ");
INSERT INTO sua_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mu ngnek na, enangthe a mhel tang na re kam ngam ka rek ngang, va ner kan? Tlo kais kam ktar korsang na he smia papat he kngangam kim ekam ka rek kam pat mang ka serppak te, ngola, kuaro krek ruk endri ngat kais mang a rek kam ngae ho mi ktua rum hak i o nop ge? ");
INSERT INTO sua_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ko enangthe na lua ktar korsang he smia papat mang ka serppak na enang tok, nang kle gia sovet kmelha pum ka rek ka pun ku kam ngam, to karo krek ngpa tu, to ka rek ner gia sir karo gi logaen. To o mia ngara vokom ka rek ko ta vle tok va ngara klel orom ");
INSERT INTO sua_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kam re te, ‘Hai-e, a mhel to enda tlo is e, ko ther gi elha pum ka rek, nang lo kat kais kam kta rum e.’ ");
INSERT INTO sua_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","I o enangthe a taven to na re kam ngae kaus kar a taven langto ko yok va ner kan kat? Ner lo kais kam ktar korsang gi kam smia papat he kngangam kim ekam a ngaus kam pat mang ka serppak kat te, ngola, ko kais kam kir kim kola ta orom kua ngaomevek ta ko mar lgititge o nop, ko kta ngaomevek ta laut hak kir kim ko tang? ");
INSERT INTO sua_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","To enangthe na re kvokom mnor te, na lo kais kam kir kim a taven to endo, to nera ktar kmeng kalngunes akuruk kam ngae he khorong a taven to endo ko ekam a ngaelaut he konget ka vrek, mar kam kta mokpom kar kat.” ");
INSERT INTO sua_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","E Yesus ta re tok, to krum kakro rhek te, “Ta vle ngang nguk enang tok kat arhe, ko enangthe mgua lua ktar korsang kam smia pat he kngangam kim muk ekam dok kam pet o tgoluk tgus ruk mum kaelik ktar ko pum mularo kerok he kaelik ko pekmuk, va mutlo kais hak kam vle te, kolngunes ormuk e.” ");
INSERT INTO sua_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“A hormnek nma mgae orom ka karvuk mekam mekam. Vanang enangthe ka karvuk npa hortgi he knop, va ner kle ka vle nngia, en kam kta hortgi kam kta karvuk kat? Nove! ");
INSERT INTO sua_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tlo kat kais hak kam kta serppak kat e. Ko ther ngae gi kernonho hak he. He ekam tok, ther gia vavle he. Va si ke serppak ngang vop, he nang kam gia ngam ku pa maap, va tlo ktuis hak mang kmeharom tok kat e. Ko ka serppak tlo kat kais kmeharom a ngaeha tang kat e. Muk ruk muta vongnek kim dok, mgua sim kael rela ekam kuaro rhek ri kam sim kut kaikkiem mar.” ");
INSERT INTO sua_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","To mnam o kolkhek ruk endruk, o kermia ruk ngam kaelha klol o takis kar endruk o Yuda ngalmialaol ngma keyang ngar ko ngam lo sim kut kaikkiem o Yuda ngaro keknen, ngma kanko kam kaum kar e Yesus kam vongnek kim. ");
INSERT INTO sua_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","To mnam a kolkha langto o Parisiau kar o pattermia kmo pos ngta rere porom mar te, “Endruk o Yuda ngalmialaol ngama keyang ngar ko ngam lo sim kut kaikkiem nguaro keknen, a mhel to enda nma tting kam kaum kar mar he kaemik kar mar kman?” ");
INSERT INTO sua_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ngta mngan tok, to e Yesus ta koka ngang ngar te, ");
INSERT INTO sua_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Enangthe tang mnam muk karo sipsip ngang ko ngtis te, o mhelom aktiek, to tang mnam mar nap sop ngok poturvek, va en ner kan? Tlo kais kmorim klenar ruk o mhelom korlolo he loktiek hori orom aktiek hori orom korlolo ko tok ma lootpgeik, nang kngae na, he kriring endo tsop, kam ngae kais ko na ngae pis mang na gi? Ii, mare, ");
INSERT INTO sua_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ner kaeharom gi enang tok arhe, ko nera riring riring kais ko na pis mang. Na re pis mang va a sirei nera viging, he nera kulum a sipsip to endo he ");
INSERT INTO sua_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","kaeknik orom ngok mrek he kat kael ngok kim klenar akuruk. To na me mang klenar kar o mia ruk kanmok kam havaeng ngar te, ‘Mguak sirei kar dok he kunngir kim kua sipsip to enda ko tngae sosop he, vanangko tete kue kat pis mang kat he.’” ");
INSERT INTO sua_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","To e Yesus thera rum karo rhek ruk mang a papat to te, “Ii, kua havaeng nguk te, a gi vrong mhel tang to na itgung karo kerkeknen ruk nam kaeharom mar, E Nut karo engyel ngara sirei mang he kunngir kim a mhel to endo man ma volkha gi enang tok kat. Va si en agitgiang tuk va E Nut karo engyel ngara sirei mang gi kir kim klenar ruk o mhelom korlolo he loktiek hori orom aktiek hori orom korlolo kat, ko mar ngam mrua papat mang ngar mruo te, mar nong ngaro kerkeknen ngang ngar, he nang E Nut kam lua lol mar patgiang ngaiting.” ");
INSERT INTO sua_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“I o enangthe a vlom to karo ngaik ruk o sing ruk loktiek, nang nap lo ptang ko tang mnam mar nap vuut ko ma ttong kun mnam ka rek, va en tlo kais kam sngam o ngnung va ngamakalam ka rek kam riring riring kngae kais ko na pis mang gi? Ii, mare, ner kaeharom tok arhe. ");
INSERT INTO sua_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ii, na re pis mang, va a sirei nera viging he nera me mang klenar va o mia ruk kanmok he khavaeng ngar te, ‘Mguaka sirei kar dok he kunngir kim kua ngaik to a sing to enda ko klo ptang ko korim tam, vanangko tete kue kat pis mang kat he.’” ");
INSERT INTO sua_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","E Yesus trum ka koka to endo, to khavaeng ngar te, “Gi enang tok kat kua havaeng nguk te, a gi vrong mhel tang to titgung karo kerkeknen ruk nam kaeharom mar, E Nut karo engyel ngara sirei mang he kunngir kim a mhel to endo man ma volkha gi enang tok kat. Va si en agitgiang tuk va E Nut karo engyel ngara sirei mang enang tok gi.” ");
INSERT INTO sua_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","To e Yesus ta rere kngae vop kam koka ngang a valngan to o Parisiau te, “A taip langto klo hal lomin. ");
INSERT INTO sua_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","To khal to knaek ta reng kteit te, ‘Kua svil te, yin kam mommen ilaro marhok he kaen kotakor ruk ye her mon dok mang ngar ngang dok.’ To kteit ther kaikkiem ka re to endo, to hera mommenik kais kim klo hal tgus. ");
INSERT INTO sua_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","To koknaik he, khal to endo tkaen ktaro marhok ngang o mia mar kmenkim mar mkor, to kaum o krek to kngae ngok mnam a mmie langto ko yok. Ta vle ko tok, to gi vrong seneker kakro krek mang o gi vrong tgoluk ruk kam ker sirei ormar he, to ho gi kut koham mar tgus hak. ");
INSERT INTO sua_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kopekam ko ta koham karo krek tgus ruk endruk, a vang alautar ta pis kun mnam a mmie to endo. To en kat ta ker kol vgum a vang ko he. ");
INSERT INTO sua_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","To ta hop to kngae ngok kim a mhel langto nkong ko tok mnam a mmie to endo kam ngae mur kaen en mruo ngang kmeha ngang. To a mhel to endo ta meng en ngok mnam o hengor ruk mkor kam toot mang karo morek kam klang ngar. ");
INSERT INTO sua_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","To a taip khal to endo nma vle ko he kaeha he. To nma vokong o morek ko ngat kaemik va ka gu nam ngae sei kam lili mang o morek ngakro ol ko o morek ngar teit nam lua klang en mlol hak. ");
INSERT INTO sua_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ta vle tok, to ka papat tkat kaeknik mang kteit kat he, to ta mrua reng te, ‘Hai-e, si o mia ruk ngam kaeha ngang e titou va ngam kaemik kvi he o ol ngo mhetor ngam vrua vle ge, vanang dok ta, kom mia vang hak mo mnam a mhe to enda yok kam yor mnam he. ");
INSERT INTO sua_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ekam tok, ngor kat kaeknik kngae ngok kim e titou kat he, he khavaeng te: O-titou-o, ko ngae ho mi kut eharom a kerkeknen hak ngang Ngoldaip tkuon ma volkha va ngang in kat ");
INSERT INTO sua_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","he tete yi lo kat kais kam kta kvam dok te, ihal ta ormok kat e. Ngia kle gia mon dok te, ila gi vrong kayie langto ormok.’ ");
INSERT INTO sua_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ta mrua pat kun mnam en mruo tok, to khop ku to her mia ngae ngok kim kteit kat. Ta ngae va kpis kun kut vgum kteit ka rengmat ka ngaelaut ka gi gu vop, to kteit ta vle her vokom he. To ka ngaung te sei kam mrung khal hak. Ta mrung to her gia tngungu ksap kam horong. Tpis ko kim he kngam kalo ktiek kuo mang kam volpsim va kpupum ka sai. ");
INSERT INTO sua_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","To khal ta reng te, ‘O-titou-o, ko ngae ho mi kut eharom a kerkeknen hak ngang Ngoldaip tkuon ma volkha va ngang in kat,he tete yi lo kat kais kam kta kvam dok te, ihal ta ormok kat e. Ngia kle gia mon dok te, ila gi vrong kayie langto ormok.’ ");
INSERT INTO sua_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ta rere kngae vop, to kteit ta kser karo rhek kam reng kalngunes te, ‘Mu marer he pasrengem orom a ngoven tang ko porom va a prongran ko mnam ka ktiek va pasrengem kalo nhar kat. ");
INSERT INTO sua_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Va mguak kaussiem a bulmakau to la sital to kaim he kmamat, ko kua svil kam kunngir kim ko hal to enda ekam ko ");
INSERT INTO sua_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ko hal to enda tngorpogom dok he, he ngae vle enang te, ther yor e, va tete teknik kpis he, he kta vle enang te, thop kam ktal kat he.’ Thavae tok to ngat her kaelha kam sirei mang. ");
INSERT INTO sua_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kteit mar ngata sirei mang kngae, vanang kteit tlua ptang khal to a molpou ko ta vle ogut mnam a loot vop. Tre aol kpis ko rkieng kteit ka rek va kngan o muktim ko ngta kni he kaerep. ");
INSERT INTO sua_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ta ngan o muktim tok, to hera vaeng kteit kalkayie langto, to ka mnganang mang o muktim ruk ta nganik. ");
INSERT INTO sua_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","To ta havaeng te, ‘Inopia tngorpok he kat eknik kpis kat he, he iteit treng ngor he ngot im a bulmakau to la sital ekam ko ta svil kam kunngir kim inopia, ko tkat eknik kpis ko kim en a gi yar.’ ");
INSERT INTO sua_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","To khal to a molpou to endo ta ngnek tok, to ka vrek te sei kam kiin hak he tlo kta svil kam kta vaik ogun kim mar e. Tkaesik tok, to kteit tottek he kaur kim te, en kam vaik. ");
INSERT INTO sua_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Vanangko ta rere vgum kteit kam re te, ‘Vokom na, mnam o pnes tgus ruk kua vle mo kmin, kom kaeha kngae ka prongyek ka psek hak, va kom lo vrua kerngnek vgum in e. Vanang yi ngae lo vur im a bulmakau tang ngang dok hak, dok kam sirei ko kim kolenar. Va si ke gi vrong ngaemslang to a got ko vur tok va ho mi kut nop hak. ");
INSERT INTO sua_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Vanang tete vokom ike hal ta na, tngae he kngae seneker karo krek ruk tlol ekam ilaro marhok mang lraip ruk ngam mur kaenen mar ngang lurokol to her le kaol kpis mo kmin va yi lo hus hak kmen a re ngang ngar kmim a bulmakau to la sital ngang kam kunngir kim.’ ");
INSERT INTO sua_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tkaesik tok, to kteit tkoripang te, ‘O-yindo a molpou, im her gia vavle mo kmok he, he kuaro tgoluk tgus ruk endri va ngta vle te, nang in he. ");
INSERT INTO sua_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Vanang inopia ta tesgun ta vle enang te, a mhel to ther yor he, ko tngorpok. Va tete teknik kpis mo kim mor he, ko ta vle enang te, tkat hop kat he. Ekam tok ngruak kunngir kim a kolkha to enda he ksirei mang enang tok.’” ");
INSERT INTO sua_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tie ma kolkha langto, e Yesus tkat kothoi ngang kalngunes he kre te, “A taven langto kakro vu gol va kalkayie to alaut ta nho mang ngar. To o mia ngta mon kalkayie to endo orom ka kerkeknen kam havae te, kalkayie tgia kokoham kakro vu tgoluk ruk endruk. ");
INSERT INTO sua_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","A taven to endo ta ngan a re to endo mang kalkayie to endo to kvaeng he kreng te, ‘Ko lol o rhek mang in, he ekam tok, ila ngaeha nera tu tete he. Ngia sim kaelel momalpek kim kuaro tgoluk na, to hera ngae ko ila ngaeha tnop he.’ ");
INSERT INTO sua_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","To kalkayie ta pat kun mnam en mruo te, ‘O-ketasuo kolaip kam pet dok kun mnam kua ngaeha he, to nguak kan, ko klo vu ktua serppak kmeha mo luteik e. Va ngor mi ktua leep hak kmelha kongrang o mia kat he.’ ");
INSERT INTO sua_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","To ka papat langto tpis kim to ta re te, ‘Kua mnor mang a ngaeha to ngor kaeharom tete ngang o mia he mur kael ekmok, nang mar kam sirei mang dok he kvaeng dok ngok mnam ngakro rektor koknaik, kopekam ko kolaip na pet dok petgim kua ngaeha.’ ");
INSERT INTO sua_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ta mrua pat kmel ekam tok, to kngae kvaeng o mia ruk kalaip karo tol ngta vle ko kmar langto langto. To ta mnganang endo ta ktar te, ‘Yin kolaip ka tol to ko kmin tis te, aner?’ ");
INSERT INTO sua_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Va tkoripang te, ka tol to mang a ho to a olip ngo itok ngat is mang kakro kolhi ruk 800. To a taven kalkayie to endo thera reng endo te, ‘Ke marer kol ila hor to ko ittiegom ila tol mnam he orsang he horang endo, nang grung orom o kolhi ruk endruk he le ittiegom mar nga le gi is mang o kolhi ruk 400 vat.’ ");
INSERT INTO sua_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","A taven kalkayie teharom tok, to ta kta mnganang langto vat te, ‘Nang yin, kolaip ka tol to ko kmin tis te, aner?’ To endo tkoripang te, ka tol to mang o roneng ruk ngat is te 1,000 ko ngat ottep orom o sigla. To a taven kalkayie to endo thera reng endo te, ‘Ke marer kol ila hor to endo he kle ittiegom mar, nang grung orom o roneng nga le gi is te, 800.’ ");
INSERT INTO sua_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Teharom tok knop, to kalaip ther vokom mnor ko kalkayie tkakauyang, to ta kle va le kanprim ekam ko ta smia ngangam kim en mruo he sim kut el ekam en mruo enang tok.” E Yesus trum ka koka to endo, to hera psom kalngunes te, “A kalyie to endo kalaip tkanprim tok, kmikkiem enang ko o mia ruk ngam kaeha mo mmie tete ngam sim kut kael ekmar mruo ko kim nglenar orom ngaro tgoluk tok arhe. Vanang kman ko o mia ruk ngma mmok mang E Nut ngam lo sim kut kael ekmar mruo ko kim nglenar orom ngaro tgoluk kmikkiem enang ngar tok kat? ");
INSERT INTO sua_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kmikkiem enang tok, kua havaeng nguk lmien te, mularo gol ngo pneik ruk mo mmie ngar lua vle koknaik koknaik kat e. He ekam tok, mgua sim kut kael ekmuk gi enang tok kat, he smia tar o mia ormar tete, yek endo yek, E Nut nera sirei kam kunngir kim muk koknaik ko mguera kol a ktalhok to kam plong vle ko kim En ngnik ngnik. ");
INSERT INTO sua_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ii, ta vle gi enang tok ngang o mia, ko mu vokom na, enangthe a kayie tang nap mrua khenam karo keknen ruk lyar ma mmok ko nam smia tar ka taven kakro tgoluk ruk nong ker laol, va tmi khenam en mruo ma mmok tok kat te, ner le smia tar ka taven kakro tgoluk ruk lvu laol kat. Vanang a kayie to nma ppiak orom ka taven kakro tgoluk ruk nong ker laol, va tmi khenam karo keknen ruk nong lyar ma mmok enang tok kat te, en ner le ka ppiak orom ka taven kakro tgoluk ruk lvu laol tok kat. ");
INSERT INTO sua_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","12","He enangthe muma ppiak orom o mia ngartaro tgoluk ruk mo mmie tok, va E Nut karo papat ngat ho lo vua serppak mang nguk hak kmel karo tgoluk mruo ko maktiegom muk e. Va enangthe muma ppiak orom o gol ruk mo mnam a mmie kat, va E Nut karo papat ngat ho lo vua serppak mang nguk hak kat kmel ktaro gol ruk kuon ma volkha, ko maktiegom muk kam vle ngang nguk kat e. ");
INSERT INTO sua_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","He ekam tok, a kayie tang tlo kais kmel klo taip ngang ktar ko pum kalo keik kmeha ngang ngin tgus ko min alomin e. Nove! Ko enangthe na re ka vle tok, va nera namlolo pum min kam ya pum tang, nang kle kernonho mang langto. I o ner kaeha lserppak ngang tang, nang kle kaitgung langto. Va kmikkiem enang tok, muk kat mut lo kais kam kaum kael E Nut va mularo gol ngo pneik ko pum mularo kerok kat e.” ");
INSERT INTO sua_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","To o Parisiau ruk ngam vu kaelongtok mang a gol ka pun ngta ngan ko ta re tok, va ngat kle gia kpiem karo rhek kam klel orom. ");
INSERT INTO sua_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","To e Yesus ta reng ngar te, “Muk ge, muk ge! Ko her muk ruk arhe mum kaimim kim o rhek he krere ko pum o mia ngaro kerok te, muk o mia ruk lyar. Vanang kun mnam muk msim hak E Nut ta mnor mang nguk. Ii, ko a gi vrong papat to o mia ngam mrua kansgum mar mruo orom he kael ktar ko pum ngaro kerok mruo, a papat to endo, E Nut tho mi kut kaitgung hak. ");
INSERT INTO sua_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ii, mu ngnek na, E Nut ktaro pos va ktaro propet ngta ktar kpavap mang Endo E Nut Thim Orom Ka Msasaen kais ko e Yoanes tpis. Vanang kam le kaelha ko e Yoanes ta pis kngae kais mang tete, kua polger o rhek ruk mang a knovvur to orom e Seten ko E Nut ka serppak tkir kim he, he o mia ruk ngata svil kam vaik ku meorom E Nut ka tavgo ngam kaenenker he kvaillam muk ruk a valngan to o Parisiau kam vavaik ku meorom. ");
INSERT INTO sua_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ii, ko mu vokom na, a mmie va a volkha, ngint gi kongeik min kam nop, vanangko E Nut karo rhek ruk endruk ke gur ke ngaekam ngang kun mnam mar tho lo kais hak kam nop e. ");
INSERT INTO sua_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ii, he ekam tok, E Nut karo rhek ngaro serppak ngata kpom muk vop orom ka pos to mang a lei, ko enangthe a ngokol tang napa kser ka lei he kle klei orom a vlom tang ko yok, yek endo yek, a mhel to endo ta kpoot mang ngina lei tok arhe. Va a pos to enda nera mon muk orom a kerkeknen to endo tok. Va ta vle tok kat ngang a ngokol to tlei orom a vlom to katngokol tlikim kat, ko en kat ta kpoot mang ngina lei enangthe napa lei orom.” ");
INSERT INTO sua_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“A mhel langto ta vle, en karo vu gol. Va mnam o kolkhek tgus nma sreng orom o it ruk lvu yar hak, to gi korsang gia vle he ksirei orom karo vu tgoluk ruk lyar ko mnam ka maksien. ");
INSERT INTO sua_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Vanang a mhel langto yok ta vle kat. Ka munik e Lasarus, en ka ngaeha kam kongrang o mia, va ka vok ta kva va si o vela va ngma pis khuguo mang ka vok. O mia ngma kanko he kael ko va gudor to mkor a mhel to karo vu gol ka rek ka taban to ku mnok. Nma vle ko tok mo kolkhek tgus he ka gu nma lili mang o ol ngo ngommes ruk ngma vuvuut kuo mnam a mhel to enda ka psen. ");
INSERT INTO sua_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kam ngae, to kela to e Lasarus thera yor, va E Nut karo engyel ngat pis kokol ka nunu ka nglum ngok mnam E Nut ka pnes, en kmorsang ko vanam kaes to e Ebrehem, endo ta nho mang a pnes to endo ko tok ma Loot To Lvu Yar Hak. Kam ngae, to a mhel to karo vu gol ta kta yor kat to ngat marer kam her gi kaeguyang he, vanang ka nunu ");
INSERT INTO sua_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","te ktua ngae kam ngae ka vle ko mLol ko mnam a paei to a vleir. Ko tok ta ker kol vgum o nganngannes laol ko ngta kokol. Ta vle to ta nho ngpalmai va kvokom e Lasarus ko vanam e Ebrehem ko nginta vle ho malhagenmok mang hak. ");
INSERT INTO sua_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","To ta vle kvae ngang e Ebrehem te, ‘O-yiya e Ebrehem-o, ngia mrung dok vanie, he meng e Lasarus he na ngae inir he vur tap mang kua naprai na ko kua ker kol a kapnes vgum a koppetmok alautar ko te sei kam kokol dok mo mnam a paei to enda.’ ");
INSERT INTO sua_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Va e Ebrehem tkoripang te, ‘Yiya, nok yi kikiangae mang ila ngorsang to tennik ko yin ima kpom ilaro tgoluk ruk lvu yar hak, vanang e Lasarus tgia kpom o tgoluk ruk nong lyar. Vanangko tete, E Nut ther ring ya ekam he, nang yin ngiak ker kokol vgum o nganngannes ko tok he. ");
INSERT INTO sua_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Va kat, klo is e, ko E Nut ther el a tonglou a ho lautar hak he tkaeltom mor he tang tlo kais kmottek mo kngae ngkogu kmuk ruk ko e. Va tok kat mang tang mnam muk ko naka svil kmottek ko he ka grap ngte va en tlo kais kat e.’ ");
INSERT INTO sua_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Va tkoripang e Ebrehem te, ‘Yu! Te ma te, o-yiya-o, ngia meng e Lasarus na ngae ngok mnam e titou ka rek ");
INSERT INTO sua_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ko kim koornopeik ruk aktiek, en kmengorang ngar kam lo kaikkiem kuaro keknen e, he nang mar kam lua kol a nganngannes to alaut to enda ta kokol dok mo e.’ ");
INSERT INTO sua_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Va e Ebrehem tkoripang te, ‘O-o, nove! E Moses karo pos va o rhek ruk mkor o propet ngta vle ngang ngar he, mar kam ngan vgum mar.’ ");
INSERT INTO sua_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Va en tkaenker gi te, ‘Nove yiya, ta ya enangthe tang mnam endruk ngat yor nak kat kaeknik ngok kim mar kat, to nok mar ngara ngan vgum he kaitgung ngaro kerkeknen vor.’ ");
INSERT INTO sua_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Va e Ebrehem tkoripang te, ‘Enangthe nga lua ngan vgum e Moses kar o propet ngaro rhek va enangthe tang ko na yor he kat hop he eknik ko kmar va si a mhel to endo ner lo kais kam rere mnam mar kat e.’” ");
INSERT INTO sua_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","To e Yesus ta reng kalngunes te, “O mia ngar mia pagis he kaop kim ngarlenar kmeharom o kerkeknen. Vanangko suvrum endo msim na mia kaop kim mar tok. ");
INSERT INTO sua_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ii, ko te sei kam ya hak ngang a mhel to enda kam vle vgum a kapnes to ngaka kleng a kre to klalaut ko porom ka ngoro he kngam ogu ma ho mlin, en kam yor. Vanang ner mi ktua kernonho hak ngang, en kam vle vgum a kapnes to E Nut ner kaen ngang ko nap kait tang kun mnam o mia ruk endri ko ngaro papat ruk mang dok ngat lo vua serppak vop he nak kaeharom a kerkeknen ekam tok. ");
INSERT INTO sua_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ekam tok, mguak ngangreal ngang nguk mruo. Va enangthe kaela ngang in na kaeharom a kerkeknen tang ngang in va ngia mia psom ko pum kalo keik. He enangthe na re itgung ka kerkeknen to endo va ngiak kol ka kerkeknen to endo patgiang ngaiting. ");
INSERT INTO sua_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Va enangthe na kering yin kais mang te, aktiek hori orom alomin kun mnam a kolkha to agitgiang tuk va nma kanko kam kirmekeknik ngok kmin kais mang te, aktiek hori orom alomin kat he khavaeng in te, titgung karo kerkeknen ruk teharom mar ngang in tok, va ngiak lol kakro kerkeknen ruk endruk patgiang ngaiting kat.” ");
INSERT INTO sua_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","E Yesus ta re tok, to o aposel ngta reng e Yesus te, “Yu! Ngoldaip, enserpgam nguaro ngaongtok mang E Nut mor kam lol o mia ngaro kerkeknen patgiang ngaiting kmikkiem enang ko ye gnua re tok.” ");
INSERT INTO sua_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Va tkoripang ngar te, “Enangthe mularo papat ruk kmor mnam muk mang dok ngap laut kais enang a ho to a mastat ke khek to ke mi laut hak va mguer kais kam reng a ho to alaut enang a ho to a sikamo ta te, ‘Tollok ko na, nang kle ngae sir ogu mou,’ va en ner mia ngan vgum muk. Enang tok kat, ko enangthe mularo papat ruk kmor mnam muk mang dok ngap laut kais enang a ho to a mastat ke khek tok ko ke mi laut hak va mguer kais kat kam lol o mia ngaro kerkeknen patgiang ngaiting enang tok kat arhe.” ");
INSERT INTO sua_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Mu ngnek na, ko enangthe tang mnam muk kalkayie ngang npa kakap ko mnam ila loot, i o ka nho mang ilaro morek he kottek ko vgum a ngaeha he kpis ko kmin, va ye kais gi kam reng ilkayie to endo te, ‘Orsang na he emik’? ");
INSERT INTO sua_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ho mi nop hak! Ko ngir kle va kta meng kam sim kut kaegenkar karo it kserpgam mar to le kngae kmomrot ilaro ol mruo kam rum karo reha tgus ngang in tok na ngola? Naka ktar rum karo reha ngang yin kais ko ngia kaemik va kaivie kngae sim kut nop na. To endo yek, en na le kaemik va kaivie kopekam yin. ");
INSERT INTO sua_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ilkayie naka ktar kaeha ngang yin tok, nang kalaip to yin ngir lo kais kam gu ya pum kat e, ekam ko ilkayie tlo mur kaeharom a ngaeha tang kat kuo malpgem endruk yelik ngang e. Nove, tgia paneng o rhek ko vgum yin, nang lo kaeharom ktakor ngang mruo. Tgia ngan vgum kalaip to yin he gi kaeha gi kaikkiem ilaro gi rhek enang ko ya re tok.” ");
INSERT INTO sua_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","E Yesus ta rum karo rhek ruk endruk to le kre kvat ka ngothoi to endo mang o mia kam re te, “Mguak rum o reha ruk E Nut telik ngang nguk kmeharom mar tok kat, to mguak le gia pat mang nguk mruo gi enang tok kat te, muk E Nut kalngunes ri ormuk mut ho lo vur kais enang tok, E Nut kam gu ya pmuk kat e, ekam ko mut gia ngan vgum he gi kaeharom karo reha ruk endruk kmikkiem karo rhek lsir enang tok.” ");
INSERT INTO sua_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","E Yesus ta ngae mYerusalem vop he kaikkiem a ngaelaut to tkaeltoot mang e Samaria va mang e Galili. ");
INSERT INTO sua_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","To tpis re kvaik ngok mnam a rengmat langto, va vgum o mia ruk loktiek orom a yor to a lepra ko ngata vle ko malhagenmok mang vop he vle vokom he. ");
INSERT INTO sua_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ngta vle ko tok he vle kvae kuon mail te, “Ngolaip to yin e Yesus, ngia mrung ngor vanie.” ");
INSERT INTO sua_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","To e Yesus ta nho kvokom mar to her gia reng ngar te, “Mgua hera ngae he, he mrua khenam mularo vok ngang o pris.” To gi ko ekam a ngaelaut ko ngata ngae, ngaro yor ngat hera nop kuo mang ngar he, to ngat her gia mmok ngatngae ko pum E Nut kalo keik. ");
INSERT INTO sua_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","To langto mnam mar tvokom ko ka vok ta kta mmok kat ko pum E Nut kalo keik tok, to tkaelha kam rere klik kam khover E Nut ka munik he kaeknik ngok kim e Yesus. ");
INSERT INTO sua_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ta pis ktubulkek ku penharom he kanprim. Va a mhel to enda nong en a Yuda e, en a vrong rhek langto yok nkong mSamaria. ");
INSERT INTO sua_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","To e Yesus ta mnganang te, “Muk tgus ruk loktiek ko eharom muk ngola? To yin tuk yinda, vanang ilenar akuruk ngram? ");
INSERT INTO sua_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Va kman ko nong a Yuda tang tkaeknik kam kanprim E Nut, vanang yinda a vrong rhek langto yok tuk ta yi eknik. ");
INSERT INTO sua_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Va ko tevanie! Ekam ko yi kor mnam yin mang dok, ko her eharom yin pum ila yor he. He ngia hop he kngae he.” ");
INSERT INTO sua_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tie ma kolkha langto o Parisiau akuruk ngta reng e Yesus te, “Ngola, sim havaeng ngor na te, mnam a ni kolkha to msim E Nut ka tavgo nera pis!” Va e Yesus tkoripang ngar te, “Mut ho lo is hak kam vokom o ngaelmir akor kam mnor mang E Nut ka tavgo vgum mar tok e. ");
INSERT INTO sua_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Va o mia ngat lo is kam khenam ngang nglenar kam re te, ‘Endo E Nut Thim Orom Ka Msasaen enda he, i o en tko gut ho.’ Ngar lo kais kam vokom E Nut ka tavgo tok ko ther mi pis he, he enda mo kmuk he.” ");
INSERT INTO sua_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","E Yesus ta havae tok, to ta le kreng kalngunes te, “A Mhel To Nkong Man Ma Volkha to dok nera pis mnam a kolkha to a kser kim he ka tavgo nera komor o mia tgus mnam a venloot to endo. Vanang o kolkhek ruk mnam a venloot to endo mguera svil hak kam mia vokom a kolkha tang mnam endruk, vanangko mguer lua vokom e. ");
INSERT INTO sua_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ii, va kun mnam o kolkhek ruk endruk mguera ngan o rhek pa nghek ko o mia ngara havae te, ‘Mu vokom na, en tko gut ho.’ Va ngara havae te, ‘O-o enda ge.’ Vanang mguak or kam mrua ngam muk mruo ekmar kmikkiem mar e. ");
INSERT INTO sua_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ekam ko o mia tgus ruk koknaik yek ngar mia mnor mang a kolkha to a kser kim msim ko ngar mia vokom A Mhel To Nkong Man Ma Volkha to dok enang ko o mia ngma vokom a koot ko nma gurmik klik he kses ngpirik kam valler a volkha karo ngaitngol tgus. Ii, ner mia pis mnam a kolkha to a kser kim gi enang tok he o mia tgus ngar mia vokom kam mnor mang tok arhe. ");
INSERT INTO sua_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Vanang ktar mang a kolkha to endo kam pis, o mia ruk endri tete ngak likim A Mhel To Nkong Man Ma Volkha to dok na, va kael o vnek kavurgem malpgem. ");
INSERT INTO sua_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","O kolkhek ruk ktar mang a kolkha to A Mhel To Nkong Man Ma Volkha kam kser kim ngar sim kut kaenang endruk ktarang mang e Noa ko tlo kar mnam ka langail vop. ");
INSERT INTO sua_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ngar sim kut kaenang ngar ruk tennik tok, ekam ko kun mnam o kolkhek ruk endruk ktar mang a kus ko tlo vuvvuem a mmie tgus vop, o mia ngma hivuo pum a empnes, a ngaenkim lraip, a ngaivie, va a ngaeha to kam palengem ngles kngae kais mnam a kolkha to e Noa mar ngat kar mnam ka langail. Ngam hivuo tok kam ngae kais ko o itok ngat kottek he. O itok ngat kottek to o mia tgus ngat her gi vuvvuo ngatngae. ");
INSERT INTO sua_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Tkaenang tok kat, ko o kolkhek ruk ktarang mang a kolkha to a kser kim, ngar sim kut kaenang enang o kolkhek ruk ktarang mang e Lot kat ko tlo ngorpok petgim a paei vop kun mnam a rengmat to e Sodom. Ngar sim kut kaenang tok, ekam ko lSodom ngta hivuo kmempnes, kaerep, gia pupunpa mang ngaro mur reha mruo kmenenkim o tgoluk va kmelel o tgoluk, kakavang o luteik va kaeharom ngaro rektor kat. Vanang mnam a kolkha to e Lot ta ngorpok petgim a rengmat to e Sodom, o mia ngat lua paptang E Nut ko tre kam ngampaei pum a rengmat to endo ho mi kut kaem kam rum kim mar tgus hak.” ");
INSERT INTO sua_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","36","“Ii, ner sim ktua vle enang tok arhe mnam a kolkha to a kser kim msim ko o mia ngara senkrip kim A Mhel To Nkong Man Ma Volkha ko E Nut nera khenam ma mmok. Ko mnam a segain to endo alo mhel alomin nginak kaum konnit ko mnam a hep atgiang va E Nut nera vaeng tang, nang kle ka mnang langto. Va alo mhel alomin nginak kaum kaeha ko ma loot va E Nut nera vaeng tang, nang kle ka mnang langto. Va alo vlom alomin nginaka kaum knonhop va E Nut nera vaeng tang, nang kle ka mnang langto kat. Ko mnam a kolkha to endo o mia ruk ngat korsang ku mnok ko ma ngoumi ngak or kam kta vaik ngogun ma rek kam kta momlom e. Ta vle enang tok kat ngang endruk ngta vle ko gunkas ko ngak kor kam kat kaeknik ngok mrek kam lol ngakro tgoluk kat e. Ii, muta pat mang e Lot ktavlom kat ko ta ngorpok he ka nho knaek? Nera vle gi enang tok mang nguk kat ekam ko endo nam vu kaelongtok mang ka ngorsang to mo mmie, en ner lua kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik e. Vanang endo nam mrua slak orom ka ngorsang to mo mmie, her a mhel to arhe nera kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik.” ");
INSERT INTO sua_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","E Yesus ta re tok knop, to kalngunes ngta mnganang te, “Ngoldaip, a kolkha to endo nak pis mang ngor tam e?” To e Yesus tkoripang ngar te, “Muk mruo mguer mrua vokom a kolkha to endo he ka mnor mang gi enang ko a talkou nma vokom a slang ko tkaemik he ka mnor mang he ka kviet kngae mang kat.” ");
INSERT INTO sua_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","To e Yesus tkothoi ngang kalngunes kam patter mar mang a keknen to kam ngarkie mekam mekam, he nang lua kapngan kim E Nut kmorim ngaro papat ruk mang. ");
INSERT INTO sua_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ta re te, “Ko tok mnam a rengmat langto a mhel ta vle. Ka ngaeha ta vle te, kam vongnek kim o rhek. A mhel to enda, nam lua totu pum E Nut va nam lua non mang o mia kat e. ");
INSERT INTO sua_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Va kun mnam a rengmat to endo kat a vlom langto ta vle. A vlom ta, en a tahek va en nma kanko kpis ko kim a mhel to enda he kaurur kim te, en kam lgem o rhek pum a re he kturang, nang en kam kir kim kaela to tel imuo ngang. ");
INSERT INTO sua_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Va a mhel to enda, nma vle gia hoger khoger ngang a vlom to enda he lua tting mang kam ngan vgum mekam mekam kat e. Kam ngae, to mnam a kolkha langto, ta mrua reng te, ‘Dok kom lua totu pum E Nut e, va kom lua non mang o mia kat e, ");
INSERT INTO sua_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","vanang ekam ko a vlom to enda nam gi kael keyang dok kam gia kanko ngte kim dok, he tete ngora srim orom a pat langto, nang en kam kir kim ka imuo, he en kam lo vu kat kael kapngan ngang dok kam gia kanko ngte kim dok kmaurur kim dok kat e.’” ");
INSERT INTO sua_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","E Yesus tkoka tok, to kreng kalngunes te, “A mhel to endo, si en a mhel to nong a yar hak, vanang ta kle ka sirim a vlom to endo gi enang ko mut ngan ko ta re. ");
INSERT INTO sua_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","To muta pat nngia, E Nut ner lua srim endruk ta re pmar gi, ko ngam kaurur kim mekam mekam gi enang a vlom to endo kat? Va muta pat te, E Nut nera vle he gia hoger khoger ngang o mia mekam mekam kat? ");
INSERT INTO sua_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","O-o nove, kua havaeng nguk te, ekam ko o mia ngma kaurur kim E Nut, E Nut ner mia ngan vgum mar, he her gia marer kam srim mar ngatngae. Vanangko, klua mnor! Mnam a kolkha to A Mhel To Nkong Man Ma Volkha to dok ngora pis mnam, va ngora pis mang o mia akor ko ngat kor mnam mar mang E Nut enang tok kat, i o nop?” ");
INSERT INTO sua_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","To e Yesus tkat koka ngang o mia ruk ngam mrua hover mar mruo he kre te, ngat gia ya, ekam ko ngam sim kut kaikkiem o Yuda ngaro pos, nang kle ka kpiem ngarlenar. Tkaelha kam koka ngang ngar te, ");
INSERT INTO sua_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","11","“Alo mhel alomin nginta grap ngoguon he kvaik ogun mnam E Nut ka maksien kam ngarkie. Langto a Parisiau va langto a ker mhel to nam kaelha klol o takis. Endo a Parisiau, ta mrua hover en mruo kam sir oguon ktar mang o mia. Vanang a ker mhel to nam kaelha klol o takis ta ktua sir kun ku knaek hak. To a Parisiau to ta mrua hover en mruo kam sir oguon ktar tkaelha kam ngarkie kam rere kuon mail hak ko kim E Nut kalo keik mang en mruo te, ‘Koldaip kua kanprim in, ko dok klo kaenang o mia akuruk yok e, endruk enang o ngauruvik, va o kerngnek, va endruk ngma kpoot mang o lei, va si enang a ker mhel to nam kaelha klol o takis enang en ma ku pekmok kat e. ");
INSERT INTO sua_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Klo kaenang ngar e, ko o kolkhek ruk aktiek hori orom alomin ngam lua nop vop, nangko koma paal kmemik ko kim ila lo keik nglomin mnam mar. Va koma mommen kuakro tgoluk tgus kmo mhetor loktiek, he ka nngiar ngang in orom nga mhe atgiang.’ ");
INSERT INTO sua_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ta ngarkie tok knop, vanang a ker mhel to nam kaelha klol o takis tgia sir kun ku knaek vop. Tgia sir ko tok he kulmar va lua re kam nho ngpalmai ko kim E Nut kalo keik e. Tgi kaerer ka lpek he le ktua ngarkie te, ‘Koldaip, dok a mhel to kom vu kaeharom o kerkeknen. Ngia mrung dok vanie.’” ");
INSERT INTO sua_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","E Yesus tkothoi tok knop, to le khalger ka koka ngang ngar te, “Alo mhel ri tgus ngint ngarkie knop to her kaeknik ngok mrek, vanang kua havaeng nguk te, her a ker mhel to nam kaelha klol o takis to E Nut tmi srim arhe. He ekam tok, her endo arhe ta vle lya ko kim E Nut kalo keik hak, vanang endo a Parisiau, ho mi kut nop hak.” To e Yesus ta kta re te, “Ta vle ngang nguk gi enang tok kat arhe, ko o mia ruk ngam mrua krus orom mar mruo, E Nut ner le khover mar. Vanang endruk ngam mrua hover mar mruo, E Nut ner kle ka krus ormar.” ");
INSERT INTO sua_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tie ma kolkha langto o mia ngata kurkeik kim e Yesus kmel o ngnes ko kim. Si endruk o gunsvel kat va o mia ngta lol ngok kim, en kmel kalo ktiek kuon mang ngar kam ngamyammok mang ngar. Kalngunes ngat re vokom tok, to ngta kner mar. ");
INSERT INTO sua_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Vanangko e Yesus ta le kvaeng ngar ge, ngok kim he kreng kalngunes te, “Mguak orim mar kmaol ngte kim dok na. Ko o mia ruk ngat kaenang o ngnes ruk enang endri, her mar ruk arhe E Nut ka tavgo ta komor mar. ");
INSERT INTO sua_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ii, lmien ko kua havaeng nguk te, endo nam lua kolaspa kam tting kam vaik ku meorom E Nut ka tavgo enang o ngnes ruk endri, ko mar ngama kolaspa mang o gi vrong tgoluk enang tok, va en tlo kais hak kam vaik kun meorom e. Nop hak!” ");
INSERT INTO sua_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tie ma kolkha langto a mhel to nma nho mang o Yuda ngarta rek langto kam rere mnam tpis ko kim e Yesus he ka mnganang te, “Pattermia, yin a mhel a yar, he havaeng dok na te, nguak kaeharom anito, he nang E Nut kmen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang dok?” ");
INSERT INTO sua_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Va e Yesus tkoripang te, “Kman ko ya mon dok te, a mhel a yar, ko gi E Nut atgiang tuk to En a yar, nang nong a mhel tang ko a yar kat e. ");
INSERT INTO sua_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yin mruo ya mnor mang o pos ruk endri te: ‘Or kam kpoot mang a lei, or kam por mia, or kmuruvik, or kam ppiak kam mon ilenar orom o kerkeknen ko pum endruk ngma vongnek kim o rhek, va ngiak totu pum iteit va inan.’” ");
INSERT INTO sua_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","E Yesus thavae tok, to a mhel to enda tkat koripang te, “Te o pos ruk endri ko elha kam sim kut kaikkiem mar tiok he ko dok a gi kalyie vop kam ngae kais mang tete.” ");
INSERT INTO sua_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","E Yesus tre ngan ko ta re tok, to hera reng te, “Vanangko a tomhel langto yi lo eharom vop. Ngiak lol ilaro tgoluk tgus he kaenik ngang o mia, mar kmenkim mar mkor in. To ngiak lol o krek he le kaisis kim o mia ruk ngta tu kmo tgoluk. Ngiak kaeharom tok, he nang yin kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ko a ktalhok to endo ta vle enang ila gol ka pun to kmelpas orom kuon ma volkha. Ii, ngiak kaeharom tok knop, to her kaol ikkiem dok.” ");
INSERT INTO sua_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","E Yesus ta re tok, to karo rhek ruk endri ngat ho mi kut kosogi pum a mhel to endo hak, to ther gi him kalo ktiek he ksei kam mrua mrung en mruo ko karo vu tgoluk ka ho vurgem hak. ");
INSERT INTO sua_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","To e Yesus ta nho kvokom ko ta vle tok, to hera reng te, “Tho mi kut kellet hak ngang o mia ruk ngaro vu tgoluk, mar kam vaik ku meorom E Nut ka tavgo. ");
INSERT INTO sua_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ii, kua havaeng nguk te, tlo vua kellet tok kat ge ngang a ngaemslang to alautar hak to a kamel kam vaik ku meorom ke gudor ko ke mi laut. Vanang a mhel to karo vu tgoluk, ta kle ho mi ktua kellet hak ngang en kam vaik ku meorom E Nut ka tavgo.” ");
INSERT INTO sua_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Endruk ngta ngan e Yesus ko ta re tok, ngat reng te, “Enangthe ilaro rhek ngata mien, va nop a mhel tang hak tkais kam mrua sulgim en mruo kam vaik ku meorom E Nut ka tavgo hak kat e.” ");
INSERT INTO sua_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Va e Yesus tkoripang ngar te, “O mia kam mrua sulgim mar mruo he kvaik ku meorom E Nut ka tavgo ngat ho lo mi ktuis hak kmeharom tok e. Vanangko E Nut tmi ktuis kmeharom o vrong mia tgus, mar kmis kam vaik ku meorom.” ");
INSERT INTO sua_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","To e Pita ta le kreng e Yesus te, “Vokom na, endruk ya rere mang ngar ko ngat parem ngakro valngan mruo ogu mrek, nang kle kaikkiem yin, her mor ri arhe.” ");
INSERT INTO sua_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Va e Yesus tkoripang te, “Ko smia mien ngang nguk te, ani mhel to tparem ka rengmat, ktavlom, kaornopeik, kaortek, kaornek, i o kles ekam E Nut ka tavgo, ");
INSERT INTO sua_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","E Nut ner ho mia klang mo tgoluk akuruk tete mnam a venloot to enda. Va koknaik a mhel to endo nera kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik kat.” ");
INSERT INTO sua_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Mnam a kolkha langto e Yesus ta nglum karo aposel ruk loktiek hori orom alomin petgim kalngunes akuruk he khavaeng ngar te, “Mu ngnek na, ko ngruaka grap ngoguon mYerusalem he o rhek tgus ruk o propet ngat ittiegom mar ko ngta ktar kpavap mang A Mhel To Nkong Man Ma Volkha to dok ormar, ngara pis lmien mang ko mnam a rengmat to arhe. ");
INSERT INTO sua_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ngar kael mit mang ko tok ekam ko o mia ngar kael ko maktiegom o vrong rhek, va ngara klel orom va ksisieng va kguguspa mang. ");
INSERT INTO sua_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Va ngara kirmekon a khap mnam to le ka krong orom o ot kvat engnang a ho kngam a yoror. Ngar kaeharom tok ngang, vanangko ko pekam o kolkhek ruk korlotge kat ner kta hop petgim ka nnak.” ");
INSERT INTO sua_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","E Yesus thavae lsir tok, vanangko ngat lua kol karo rhek tgus hak. Ngat gia vle he kmoruo pum mar he lua mmok mang ngar e. ");
INSERT INTO sua_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","E Yesus ta ngae mYerusalem vop he kaol konner a rengmat to e Yeriko, va vgum a mhel to ta vipsik ko tkorsang ko vanam a ngaelaut he kngangrang o mia kmo krek. ");
INSERT INTO sua_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","To ta ngan a mumu to ngta ngae ko rkieng he re klapsam, to thera mnganang ngar te, “Anie to tok?” ");
INSERT INTO sua_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Va ngta havaeng te, “He e Yesus to nkong mNasaret, endo tre kmaol klapsam yin ko arhe.” ");
INSERT INTO sua_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","To ta vui orom te, “O-e Devit kaes to yin, Yesus-o, ngia mrung dok vanie!” ");
INSERT INTO sua_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","To endruk ngta ktar ngat re kvokom tok, to ngat kaekon kim kam hagam en kam lua rere. Vanangko enang tok, ngat le ho gi kaoppom klik en kam ho gia vui klik kat ge te, “O-e Devit kaes to yin Yesus-o, ngia mrung dok vanie!” ");
INSERT INTO sua_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","To e Yesus ther gia sir ko va ngaelaut to kreng o mia, mar kam ktong ngok kim. To ta pis, to e Yesus thera mnganang te, ");
INSERT INTO sua_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Havaeng dok na, ya svil mang dok kmanker in?” Va ta re te, “Koldaip, kua svil yin kmeharom kualo keik, he dok kam nho!” ");
INSERT INTO sua_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","To e Yesus ther gia re te, “Yu! Ngiaka nho. Ko kaeharom ila lo keik he ngint ya he, ekam ko ye kor mnam yin mang dok kmeharom tok.” ");
INSERT INTO sua_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","A gi hi to e Yesus tgia re tok, a mhel to endo ther gi kat nho ngatngae to her le kaikkiem e Yesus va kaelha kam kanprim E Nut ka munik. To o mia tgus ruk ko tok, ngta vokom tok, to kanprim E Nut ka munik kat. ");
INSERT INTO sua_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","E Yesus ta ngae mYerusalem vop he kpis mYeriko he re kam lapsam a rengmat gi. ");
INSERT INTO sua_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Va a mhel langto ka munik e Sakias ta vle ko tok kat. En karo vu gol ekam ko ta kpom a ngaeha to kam nho mang o kermia ruk ngam kaelha klol o takis. ");
INSERT INTO sua_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","E Sakias ta svil kam mnor mang e Yesus te, edimriem mnam a mumu to endo, vanangko tsia khanang kam vokom ko en a gi knor e. To tsia hoger ka ngoro kam smia vokom, vanangko o mia ngta totokim ge. ");
INSERT INTO sua_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","To ta ktar ksap kam pis kaitgi ko vgum a ho to ngma mon te, a sikamo, endo ko rkieng a ngaelaut to e Yesus tkaikkiem, nang en kam smia vokom. ");
INSERT INTO sua_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","To e Yesus tkaol kpis ko pum a ho to endo, to thera nho ngpalmai he kreng e Sakias te, “Sakias, ke grung kun kuon ko tete ngiak kael a ngaekam tang ngang dok kun mnam ila rek.” ");
INSERT INTO sua_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ta ngnek tok, to hera marer kam gugrung to her gia sirei he kam vaeng e Yesus ngok mnam ka rek. ");
INSERT INTO sua_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","A mumu to endo tvokom tok, to ngat kaelha kam mo vur re ngang ngar mruo mang e Yesus te, “Hai-e, ngola a mhel to enda ther ring ngaekmol ekam ko kim tang mnam endruk mor o Yuda ngolmialaol ngoma keyang ngar ekam ko ngam lo sim kut kaikkiem nguaro keknen kat?” ");
INSERT INTO sua_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mar ngta pat tok, nang e Yesus mar ngat pis korsang kmemik. Kam ngae, to e Sakias ta mrua koon pum to thop ku ksir ko kim klenar to kreng e Yesus te, “Kolaip, vokom na, tete ngor kaen kuaro tgoluk tgus nga mhe ngang o mia ruk ngta tu kim o tgoluk. Va endruk ko kermamas ngang ngar kmurur ngakro krek, va tete kat ngor le koripang ngar ngkorlolo ngkuon malpgem endruk ko ururik ko kmar.” ");
INSERT INTO sua_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","To e Yesus ta ngnek tok, to khavaeng o mia te, “Her gi tete ta, ko her lol a rek to enda kakro kerkeknen patgiang ngaiting he, ekam ko a mhel ta tpal mnam e Ebrehem ka ngausie ka pun kat. ");
INSERT INTO sua_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ii, ko her lol ngakro kerkeknen patgiang ngaiting tok, ekam ko A Mhel To Nkong Man Ma Volkha to dok ther kaol ngte mang her endruk ngata vraik petgim E Nut vgum ngakro kerkeknen tok arhe, he en kam riring ngar va ksulgim mar he klol ngakro kerkeknen patgiang ngaiting.” ");
INSERT INTO sua_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ngta vongnek kim ko ta rere vop kun mnam e Sakias ka rek, to o mia ngta mnor ko ngta konner e Yerusalem, he ekam tok ngta pat re te, ketasuo E Nut ka tavgo kam mia pis yek, ko e Yesus nak vaik kun mnam a rengmat to endo, he ketasuo mar kam mi ktua vokom E Nut orom ka tavgo ko tok. ");
INSERT INTO sua_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","To thera koka ngang ngar kam re lkoon mang en mruo te, “Mnam a kolkha langto a taven to a ho mongor hak khal to a molpou tngae ngok mnam a mmie langto yok, mar kmel a serppak malpgem, he en kmeknik to klaut va ka nho mang o mia. ");
INSERT INTO sua_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Vanang ktar mang a molpou to endo kam ngae ta vaeng kalngunes ruk loktiek he kael a pek atgiang ko maktiegom langto langto mnam mar, mar kmeha malpgem. To a molpou to endo thavaeng ngar te, ‘Nguak ngae mnam a mmie tang ko yok, va langto langto mnam muk nak kaeha malpgem o kirpik ruk ko elik maktiegom muk kais ko nguak kat kaeknik.’ Ta re tok, to hera ngae. ");
INSERT INTO sua_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","A molpou to endo ta hivuo kam ngae vop, to o mia ruk en nma nho mang ngar endruk ngam kaelat, ngta meng ke valngan langto kam knaek ekam kam ktar kpis ko kim endo kmel a serppak kuo malpgem, kam havaeng orom ngaro rhek lsir te, ‘Ngot lua svil mang a mhel to endo kam laut va ka nho mang ngor kat e.’ ");
INSERT INTO sua_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ngat havaeng tok, vanangko a molpou to endo tkol a serppak ge to kam laut va ka nho mang ngar, to her kaeknik ngok mrek. Ta pis to her kaen a re mang kalngunes ruk tesgun endruk tel karo kirpik ko maktiegom mar, kam mnor mang ngar te, ngat eha malpgem karo kirpik ruk endruk i o nop? ");
INSERT INTO sua_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Endo ta ktar kpis ko kim thavaeng te, ‘Kolaip dok ko eha he lol o kirpik ruk loktiek kat malpgem endo yi ktar el maktiegom dok.’ ");
INSERT INTO sua_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","To kalaip tkanprim te, ‘O kolkayie a yar hak to yin, ekam ko yi ngae sim kut tar kua pek to a sim kut tgiang hak he sim kut papuntom ila ngaeha. He ekam ko yi sim kut papuntom ke ngaeha ko atgiang to endo, va tete ngor le ho gi kael o rengmat ruk loktiek ko maktiegom yin, he nang yin kam nho mang ngar kat.’ ");
INSERT INTO sua_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ta re tok, to kalkayie langto tpis ko kim he kreng te, ‘Kolaip dok ko eha he lol o kirpik ruk aktiek kuo malpgem endo yi ktar el maktiegom dok.’ ");
INSERT INTO sua_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Va kalaip tkoripang tok kat te, ‘Yu! Ekam tok, ngor kael o rengmat ruk aktiek kat maktiegom yin, yin kam nho mang ngar.’ ");
INSERT INTO sua_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kam ngae, to kalkayie langto vat tkaol kpis ko kim kat to kreng kalaip te, ‘O kolaip, vokom na ila pek to ya ktar el maktiegom dok, enda ge. Ko ko komor orom a yet ka kae he ngae sim kut eguyang hak ");
INSERT INTO sua_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ekam ko kua gorang in ko ko sim kut mnor mang ilaro keknen hak ko im lua non mang o mia e. Im gia vle kam gluegengnam o mia akuruk ngaro tgoluk. Ii, ima vle enang a mhel to nam gi vrong kolaspa kam lluol mnam akuruk yok ngakro luteik, nang en mruo nam lo mrua pet kmeha kam kavang o tgoluk ngang en mruo e.’ ");
INSERT INTO sua_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kalaip ta ngan karo rhek ruk tok, to ta reng te, ‘Kolkayie to ye ho mi kut kernonho hak to yin. Ngor kaikkiem ilaro rhek ruk mruo tok arhe kmel yin kam ker kol vgum a kapnes to a vanker hak. Ko ye her mur mnor mang dok te, kom lua non mang o mia. Va ya mien mang dok ko koma vle enang a mhel to nam gi vrong kolaspa kam lluol mnam akuruk yok ngakro luteik, nang en mruo nam lo mrua pet kmeha kam kavang o tgoluk ngang en mruo e. ");
INSERT INTO sua_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Enang ko ya mnor mang kuaro keknen ko ngta vle enang tok, va kman ko ye lo en kua pek to ko el ko maktiegom yin ngang a mhel tang to ta re kmel ka kvek, en kmel a tol ko kmin orom, he nang en kam le kaeha orom kua pek to endo, nang yin kam kol ka mgu va langto malpgem kat?’ ");
INSERT INTO sua_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","To kalaip ta reng o mia ruk ngta sisir ko rkieng te, ‘Mu marer vret a pek to endo ko maktiegom he le kaen ngang endo teha malpgem a pek to atgiang he kat lol endruk loktiek kuon malpgem mar kat.’ ");
INSERT INTO sua_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Va o mia ruk endruk ngat koripang te, ‘O-o ngolaip te a mhel to endo ther kpom endruk ngat is te, loktiek he.’ ");
INSERT INTO sua_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Va ngalaip tkoripang ngar te, ‘Endruk ngat sim kut papuntom ngaro reha ruk E Nut telik ko maktiegom mar, va E Nut ner le ho gia sovet kam kat kael o reha akuruk vat ko maktiegom mar, mar kam sim kaeha orom mar kam sim kut papuntom mar kat. Vanang endruk ngat lo sim kut papuntom ngartaro reha, va si ke ngaeha to kemilaut to E Nut tel ko maktiegom mar, va ke ngaeha to endo E Nut ner le ho gia pet petgim mar hak. ");
INSERT INTO sua_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Vanang kuaro imuo ruk ngta rere pum dok kam re te, ngat lua svil dok kam laut va ka nho mang ngar, mguaka kpom mar ngte he kaim mar kngam mar o yoror mo pum kualo keik.’” ");
INSERT INTO sua_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","E Yesus ta rere knop, to hera hop kun mnam e Sakias ka rek kottek to her kta ngae kmikkiem a ngaelaut ngok mYerusalem. ");
INSERT INTO sua_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ta konner alo rengmat ruk e Betpagi va e Betani kuon kim ke vul to e Olip, to thera meng klo kaloyie aloruk orom karo rhek ruk endri te, ");
INSERT INTO sua_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Meaka ktar kngae ngok mnam a rengmat tma kuon he mera pis mang a dongki to ke sie, ko ngta kleng he tgia sir. A mhel tang tlo sap orom vop. Meak pis mang va meak halger pum ka ngausie he kait ngte kim dok. ");
INSERT INTO sua_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nang enangthe tang naka mnganang ngae mang te, ‘Ngola, meta halger a dongki to ke sie pum ka ngausie kman?’, va meak koripang te, ‘Ngoldaip ta re mang.’” ");
INSERT INTO sua_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ta meng ngin tok, to ngint hera ngae ka ktar ngok mnam a rengmat to endo, to her gi pis mang enang ko ta reng ngin tok. ");
INSERT INTO sua_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nginta hivuo kam halger pum ka ngausie va vgum a dongki to ke sie to endo kaortek ko ngta vle ko tok he ka mnganang ngin te, “Ngola meta halger a dongki to ke sie to endo pum ka ngausie kman?” ");
INSERT INTO sua_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Va ngint her gi koripang ngar te, “Ngoldaip ta re mang.” ");
INSERT INTO sua_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","To ngint her gi kait a dongki to ke sie to endo, to kngorom kpis ngok kim e Yesus to le kpasrengem orom nginaro it. Nginta pasrengem knop, to hera kenpgam e Yesus kael kuo mang. ");
INSERT INTO sua_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ta ngae ekam a ngaelaut va o mia ngat kaelha kam pasrengem a ngaelaet to endo kam vevher ngakro it ko ekam. To e Yesus ther kaelha kmikkiem ko ngta ktong kngorom. ");
INSERT INTO sua_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tkaol kaikkiem ke vul ka lalngan he kpis ko vgum ka gu to kam grung ngogu pum ke vul to endo. To a mumu to orom kalngunes ngat kaelha kam mariu orom ko tok va kael kavres orom kat kam kanprim E Nut he ksirei mang. Ngta kni klik mang karo reha ruk lserpgue ruk ngat vokong ngar. ");
INSERT INTO sua_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ngta kni te, “E Nut ta ngamyammok mang ka taven to yin ko ya pis orom ka munik. He ekam tok, ngruak guya pum E Nut to man ma volkha ka munik ko tel a vrek longeik kun pgegom o mia kar En mruo.” ");
INSERT INTO sua_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ngata hivuo kam kni kngorom tok, to o Parisiau akuruk kun mnam a mumu to endo ngta havaeng e Yesus te, “Pattermia ngiaka kner ilengunes kam hagam mar kam or kam kni tok.” ");
INSERT INTO sua_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Va e Yesus tkoripang ngar te, “Kua havaeng nguk te, enangthe mgua re khagam mar kam polger o rhek mang dok enang tok, va o krek ri ngar le mi kael ngaro ktui kam le kpolger o rhek mang dok vat.” ");
INSERT INTO sua_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ta grung vop, to hera konner e Yerusalem to ka nho ogu kvokom to hera polger karo reti ma mmok he. Tkaeti mang a rengmat to endo, ");
INSERT INTO sua_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","va kre te, “O-kelenar muk ruk lYerusalem-o, ko mi kut svil hak muk kam vokom kam mnor mang dok te, her dok ta arhe, endo tkais kam klang nguk ma vrek longeik kar E Nut. Vanangko muma moruo pum dok ge, he lua vokom kam mnor mang dok e. ");
INSERT INTO sua_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ekam tok, o kolkhek ruk o kernonhor ngara pis kim muk koknaik, ko mularo imuo ngara pis mnam mar he ktotokim muk he kairkakleim mula rengmat karo ngaitngol tgus. ");
INSERT INTO sua_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ii, ngara pis kaimim muk kar mules he kmemget mula rengmat tgus hak, nang ho lo kat kais hak ka mnang ke vur kre tang hak kam kta sir kuon mang kaela ngang e. Ii, ngara vle kar muk tok, ekam ko tete E Nut tpis ormok mo kmuk kam sulgim muk he klol mularo kerkeknen patgiang ngaiting va mut mia tataar mang dok ge.” ");
INSERT INTO sua_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","E Yesus ta rere tok knop, to ta pis mnam a rengmat to e Yerusalem msim. To thera ngae kvaik ogun mnam E Nut ka maksien, to her kaelha kam kekerer endruk ngma kanko kmelel o tgoluk, o mia kmenenkim mar mkor mar, to le ka nngiar ngang E Nut ormar. ");
INSERT INTO sua_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Teharom tok, he keknen ngang ngar te, “Ngat ittiegom E Nut karo rhek te, ‘Kua maksien ka ngaeha ka pun na gia vle tuk her gi mang a ngaeha to kam ngarkie mnam. Vanangko muk ri, mut her hortgem ka ngaeha ka pun msim ko mut kle kael enangthe a mhe to kam vaik kun mnam kmurur o mia ngaro krek. Ii, mut hortgem he en ta kle kpis enangthe a kre ka nho to o ngauruvik ngma tvok mnam kam totokim mar he koon mang ngar.’” ");
INSERT INTO sua_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","48","O pris ruk laol kar o pattermia kmo pos va o Yuda ngalmialaol ngta vokom ko teharom tok kun mnam E Nut ka maksien to ngam sia khanang ngar kam pis mang a ngaelaut tang kmim kngam a yoror. Vanangko ngat lo is e, ko o mia tgus ngma vaat kar kam vongnek kim karo rhek ko nma patter mar ko tok mo kolkhek tgus. ");
INSERT INTO sua_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","To mnam a kolkha langto kun mnam o kolkhek ruk endruk e Yesus ta kta vle ko mnam E Nut ka maksien he kpatter o mia mang a knovvur. To o pris ruk laol kar o pattermia kmo pos va o Yuda ngalmialaol ngat kaol kpis ko kim, ");
INSERT INTO sua_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","he ka mngan pum te, “Erieto tmeng yin kam kerer mor mo mnam E Nut ka maksien ta tok? Havaeng ngor na!” ");
INSERT INTO sua_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Va e Yesus tkoripang ngar te, “Vanang dok kat, ngor le ka ktar ka mnganang nguk kat na. He mgua le khavaeng dok te: ");
INSERT INTO sua_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Erieto tmeng e Yoanes, en kam parrum o mia, E Nut tkuon ma volkha, i o a gi vrong mhel tang?” ");
INSERT INTO sua_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","To ngata mo hem mar mang a papat to endo, to mo reng ngar mruo te, “Ngola, enangthe ngrua koripang he kre khavaeng te, ‘E Nut to tmeng,’ va en ner kle kaekon ngang ngor te, ‘Va kman ko mut lo kor mnam muk mang?’ ");
INSERT INTO sua_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Vanang enangthe ngrua kle kre khavaeng te, ‘A gi vrong mhel tang to tmeng,’ va o mia ngar kle kut lalaem mor kngam mor o yoror kat, ekam ko mar ngtel ngaro papat lserppak mang he te, e Yoanes en a mi propet langto.” ");
INSERT INTO sua_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","He ekam tok, ngat her gi koripang te, “Ngot lua mnor mang endo tmeng e.” ");
INSERT INTO sua_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Va e Yesus tkat tkoripang ngar tok kat te, “Te dok kat, klo kais kam havaeng nguk mang Endo tmeng dok kmeharom a ngaeha to endo kat e.” ");
INSERT INTO sua_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","To e Yesus tkaelha kam koka ngang o Yuda ngalmialaol ruk endruk te, “A mmie kteit teharom ka loot to orom o usiel ruk o grep to tkael sarek mnam ngang o mia kam kavang ngaro usiel ruk o grep, nang en thera ngae he ka vle lhok mnam a mhe langto ko yok. ");
INSERT INTO sua_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kam ngae, to ka loot ta tettek he, to a mmie kteit thera meng kalkayie langto ngok kim endruk ngat tutuur mnam ka loot mar kam lluol ngang he ktatar en. Kalkayie tpis ko kmar, vanangko endruk ngta tutuur mnam a mmie kteit ka loot ngta vle her gi im to kaekon tgia ngongae. ");
INSERT INTO sua_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","To a mmie kteit ta kta meng kalkayie langto kat ge ngok mar. Va enda ngat her gi im tok kat va kaeharom o kerkeknen ngang kam ho mi kut ngamleep mang hak to kle kaekon tgia ngongae kat. ");
INSERT INTO sua_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Va si endo korlotge orom kat ge, ko a mmie kteit tmeng ngok mar, va ngat kaim ho panaem hak he ka gidiel tlul to ngat her gi ngam ku mnok petgim mar. ");
INSERT INTO sua_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","To a mmie kteit tsia ngam kim en kam pat te, ‘Nguak kan e? Nok nguak meng ko hal msim to kom vu kaelongtok mang, he nok ngar le ktotu pum ko hal msim to endo he kngan vgum vor.’ ");
INSERT INTO sua_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Vanangko endruk ngta tutuur mnam ka loot ngta vle vokom khal to kmo havaeng ngar te, ‘O, her khal msim to kam kol kteit ka mmie ta arhe. Ngor tarkanang he im, nang ngor kam le kol a mmie ta.’ ");
INSERT INTO sua_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","To ngat kait ngku mnok he kngam petgim a loot to endo, to her kaim kngam a yoror.” E Yesus trum ka koka to endo, to kle ka mnganang endruk laol te, “To muta pat te, a mmie kteit nak kanker endruk ngat tutuur kun mnam ka loot? ");
INSERT INTO sua_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Te ner le kpis rum kim mar tgus hak, nang kle kael sarek mnam ngang o mia akor ko yok vat ngola?” O Yuda ngalmialaol ruk endruk ngta ngan e Yesus ko ta re tok, to ngata kokheng te, “O-o E Nut ta mnor te, ngot lo kais hak kam vle tok e. Ho mi kut nop hak!” ");
INSERT INTO sua_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","To e Yesus kalo keik ngint kaem mar lsir to ta le kokheng ngar vat te, “Te ma te E Nut karo rhek ruk ngat ittiegom mar ngata vle nngia mang nguk ko ngata ktar kpavap mang nguk te, ‘Endruk ngma ngamrektor ngat keyang a ho langto he kait petgim a rek he ka vlengam. Vanangko a her gi ho to endo arhe ther kle ka vle te, a ho to mang a hokidek to arhe, endo kam sir orom a rek.’ ");
INSERT INTO sua_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ii, va a ni mhel to na tunvie pum a hokidek to endo he kvuut malpgem, a hokidek nera krong kpaam kngam a yoror. Vanang a ni mhel to a hokidek ta na kle kut vuut kuon malpgem a hokidek ner mi ktua memelesem hak.” ");
INSERT INTO sua_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","To ekam ko o pattermia kmo pos va o pris ruk laol ngata tar ko e Yesus ta koka mang ngar lsir orom ka koka to endo, ngat sia khanang ngar kam kapom ngatngae kun mnam a kolkha to endo ke vgon to endo gi, mar kmenpasiker kun ma hengor. Vanangko ngat lo is ekam ko ngta gorang o mia pum. ");
INSERT INTO sua_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","To o pattermia kmo pos va o pris ruk laol ngat smia keketar e Yesus ko tok mnam E Nut ka maksien va kmeng o mia akuruk kam ngae ngok kim he kmas orom kam pe gia re te, mar ngat mia kambisam, mar kam keketar kat. Ngat eharom tok, ekam ko ngat her kaelnam mar te, mar kam pe gia kaegom, en kam mrua ru pum karo mur rhek mruo, nang mar kam kle kael maktiegom a serppak to mkor lRom ngalaip to ta nho mang lYudea pum karo rhek ruk endruk. ");
INSERT INTO sua_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ngat pis ko kim e Yesus he pe gia kanprim te, “O, pattermia, ngot sim ktua mnor miik, ko o rhek ruk ima patter mor mang ngar, mar o mi kut minar hak. Va ngota mnor mang in kat te, ima rere he lo gia tar yin pum o mia akor kam pat mang ngar, nang ka mnang akuruk e. Nove, im her gi ktua patter o mia lsir kmikkiem E Nut karo pos lsir. ");
INSERT INTO sua_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","He ekam tok, ngiak havaeng ngor na te, ta sir ngang ngor ruk o Yuda kam ngam o takis ngang lRom ngalaip to ngma mon te, e Sisa, i nop ge?” ");
INSERT INTO sua_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ngat pe gia mnganang tok, vanangko e Yesus ta tar ko ngat kaegom kam mas orom to kle kreng ngar te, ");
INSERT INTO sua_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ma te, mu khenam a kre tang ngang dok, ko vokom na.” To ta kol a kre mkor mar to ka mnganang ngar te, “Erieto ka nunu va ka munik ta vle kuo mang a kre to enda?” ");
INSERT INTO sua_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Va ngat koripang te, “He, e Sisa.” Va e Yesus tkat koripang ngar kat te, “Te muk he, mguak kaekon o tgoluk ruk ngta khenam lRom ngalaip to e Sisa ka nunu ngak kat kaeknik ngang kat, vanang kle kaekon muk mruo ngang E Nut ko muta khenam E Nut ka nunu ormuk mruo enang tok kat.” ");
INSERT INTO sua_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","O pattermia kmo pos va o pris ruk laol ngate sia khanang ngar kmegom e Yesus, en kam mrua ru pum karo mur rhek ruk endruk ko ma mmok tok, vanang ngat lo is e. Ngat kle gia senkrip kim karo rhek to her le gia korim kam vongnek kim ko tok. ");
INSERT INTO sua_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","To a valngan langto ngma mon mar te, o Sadyusi, ngat kle kaol ngok kim e Yesus ko tok mnam E Nut ka maksien kat. Mar, ngam ktua pat te, o mia ngama yor va ngar lua hop petgim ngaro nnak e. Endri ngat kaol kpis ko kim to pe gia mnganang kat te, ");
INSERT INTO sua_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Pattermia, tennik e Moses tittiegom a pos langto ngang ngor te, ‘Enangthe a mhel tang knopia na yor parem ktavlom, nang nong kles ngang, va en nak le kliepak ekam knopia to tyor, nang a vlom kam llues, en kam hover knopia ktavlom ka ngausie.’ ");
INSERT INTO sua_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yu! A pos to endo ta vle tok arhe, vanang ma te, enangthe napa vle tok tete ko o moornopeik aktiek hori orom alomin ngata vle, to endo a molpou tlei he yor parem ktavlom, nang tlo llues e. ");
INSERT INTO sua_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","To gi enang tok kat mang endo kopekam ko ta liepak ekam knopia kat to ther gi kat yor kat. ");
INSERT INTO sua_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","To endo kopekam min ta le kta liepak ekam endo kat to kta yor. Mar tgus ruk aktiek hori orom alomin ngta vle tgus tok ko ngat yor parem a vlom, nang tlo llues e. ");
INSERT INTO sua_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kam ngae, to a vlom to endo kat ta le ktua yor vat. ");
INSERT INTO sua_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","To kmikkiem ke ngothoi to endo tok, sim havaeng ngor mang a papat to kam yor he khop petgim a nnak na, ko naka vle nngia ko koknaik mnam a kolkha to E Nut nak hover o yoror petgim ngaro nnak, a vlom to enda naka vle te, edim mnam mar ktavlom msim, ko mar tgus ruk aktiek hori orom alomin ngat lei orom?” ");
INSERT INTO sua_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","E Yesus ta ngnek tok, to kle koripang ngar te, “Lraip va lurokol tgus, ruk mnam o mia nga main to tete ngam kael lraip va lurokol kam mo lei ormar. ");
INSERT INTO sua_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Vanang mnam a venloot to koknaik ko E Nut nak hover o yoror petgim ngaro nnak, E Nut nera pat mang o mia akuruk te, ngata eveep kam vle kun mnam a venloot to endo. Va nera pat mang ngar kat te, ngata eveep kam kaum kar o yoror, he nang En kam hover mar petgim ngaro nnak kat, mar kam kol a ktalhok to kam plong vle ko kim En ngnik ngnik. Va kun mnam a venloot to endo ngar lo kat kael lraip va lurokol kam mo lei ormar kat e. ");
INSERT INTO sua_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ii, ngar lo kta lei kat ekam ko ngar kaenang E Nut karo engyel ruk ngama vle orom a ktalhok to kam plong vle ngnik ngnik. Ii, ko o yoror ruk endruk ngar mia hop petgim ngaro nnak kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik. Va ngar lo kais kam kta yor kat e. Nove, ngar kle va ka vle te, E Nut kles msim ruk mar ekam ko ngara hop enang tok. ");
INSERT INTO sua_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Vanang si e Moses karo rittiek ruk mang o yoror ruk e Ebrehem va e Isak va e Yakop ngata khenam a papat to mang o yoror ma mmok te, ngar mi ktua hop petgim ngaro nnak. Vanangko nok pathe, mut lo him e Moses ka hor to endo vor. Ko kun mnam a ngothoi to mang ke turvek to a paei ta vurvur pum he lo kaem, E Nut thavaeng e Moses te, ‘Her dok ta arhe endo e Ebrehem va e Isak va e Yakop ngma vle ko kim dok he ktotu pum dok tennik kngae kais mang tete.’ ");
INSERT INTO sua_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mu vokom o rhek ruk endruk na, ko ngata khenam a papat to mang o yoror ma mmok te, endruk ngat kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik kam totu pum, her mar ruk ngata kta hop petgim ngaro nnak, nang nong endruk ngat yor he lo kta hop kat e. Ii, ko o yoror tgus ngar mia hop petgim ngaro nnak tgus, akuruk ngta mokpom kar E Nut, mar kam vle ko kim ngnik ngnik va akuruk ngat lua mokpom kar, mar kam lua vle ko kim ngnik ngnik.” ");
INSERT INTO sua_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ta re tok knop, to o pattermia kmo pos ngata koripang te, “Pattermia, ye her sim kut koripang hak.” ");
INSERT INTO sua_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","To nop a mhel tang hak ta kta re kmegom kta serppak mruo kam mnganang e Yesus mang a papat tang kat e. ");
INSERT INTO sua_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","To e Yesus ta le kreng o pattermia kmo pos te, “Nngia ko o mia ngma grung orom Endo E Nut Thim Orom Ka Msasaen ka munik kam havae mang te, ‘En kaes to mkor a hipun to e Devit?’ ");
INSERT INTO sua_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Enangthe npa mien te, e Devit ka munik ta laut mang Endo E Nut Thim Orom Ka Msasaen, va kman ko e Devit ta kle mur hover Endo E Nut Thim Orom Ka Msasaen ka munik, ko tennik kun mnam a hor to orom O Knituk, e Devit mruo tmur hover Endo E Nut Thim Orom Ka Msasaen kam mrua mon te, ‘Kaldaip to en’ ko e Devit thavae te, ‘E Nut thavaeng Koldaip te, ngiak tuur mnam kua tavgo he korsang na, ko pa ngorsang to a miktiek, endo koma nho orom ko vanam dok ");
INSERT INTO sua_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kam ngae kais ko nguak kir kim ilaro imuo, yin kam karkar mang ngar hak.’ ");
INSERT INTO sua_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Vanang mu vokom na. Ma te enangthe tennik, a hipun to e Devit mruo ta mrua hover kaes to E Nut Thim Orom Ka Msasaen kam mrua mon te, ‘Kaldaip to en,’ va nngia ko mum kaekon kim a hipun to e Devit karo rhek mruo kam mon Endo E Nut Thim Orom Ka Msasaen te, en gi kaes a hipun to e Devit, vanang en ta ktar vle tennik ktar mang e Devit?” ");
INSERT INTO sua_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ko tok mnam E Nut ka maksien o mia tgus ngata ngan e Yesus ko thavaeng kalngunes te, ");
INSERT INTO sua_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mguak ngangreal ngang nguk mang o pattermia kmo pos ko mar ngam mrua hover mar mrua kam sreng orom o it ruk ngat ngae gia rarip ku he kpunpa ormar ko pum o mia ngaro kerok. Ii, va mar ngam mrua khenam mar mruo ma mmok ngang o mia ko mo vlemkor, o mia kam hover singni ngang ngar ko pum nglenar ngo kerok. Va mar ngma sovet kam mrua kakansgum mar mruo kam lol o ngorsang ruk o mia ngma nho orom mar ko po pnes va endruk kun mnam o Yuda ngaro rektor ruk kam rere mnam mar kat. ");
INSERT INTO sua_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Va ngma kauyang o tahek he klikim mar kun mnam ngartaro rektor mruo, nang kle klol o rektor ruk endruk ngang ngar mruo vat. Va ngam ngorom a hoger ngaro ngarkie khogerik ko pum o mia ngaro kerok, mar kam gia vokom mar tok to le kanprim mar. Ii, o mia ruk ngta vle enang o pattermia kmo pos tok, her endruk E Nut ner ho mi ktua monik kim o ho kapnes ruk lho vankue hak ngang ngar arhe kir kim o kapnes tgus hak.” ");
INSERT INTO sua_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","E Yesus ta rere tok kun mnam E Nut ka maksien knop, to re ka nho va vokom o mia ruk ngakro vu gol ko ngata nngiar ngang E Nut ormar kam klang E Nut ka maksien ka ngaelpas. ");
INSERT INTO sua_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Vanangko tvokom kat ko kela a tahek langto ko en ho mi kut nop o krek ngang hak ko ta kol kelo kre ruk lo svel he kpis to vrua ngam min kun ma ngaelpas kat. ");
INSERT INTO sua_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ta vokom tok, to hera re te, “Kua mien ngang nguk te, a vlom to endo ta ngam ka nngiar kun mnam a ngaelpas ho mi kut kir kim o mia tgus ruk endri hak ");
INSERT INTO sua_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ko mar tgus ruk ngta nngiar ngang E Nut ngat gia vethas mnam ngakro vu gol ngarkero gi mhetor mnam mar ruk ka ho vuvurgem hak. Vanang a vlom to enda, ta kle ho mi ktua nngiar ngang E Nut orom kelo kre ruk ennginduk ko tmia rum kim ennginduk tre kpas ormin kmenkim o ol ngang ormin.” ");
INSERT INTO sua_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kam ngae, to kalngunes akuruk ngta rere he kalpak kim o rektor ruk kun mnam E Nut ka maksien ko mia ngat sim kut papuntom kmeharom mar orom o krek ruk ngate sim kut tetgem mar he. Va ngta kanprim o sreng ruk ngta pasrengem o rektor ruk endruk ormar kat ko o mia ngta nngiar ormar kam ngam o rektor ruk endruk ormar. Kalngunes ngat kaeharom tok, vanang e Yesus ta le koripang ngar te, ");
INSERT INTO sua_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“O rektor ruk endri muta vokom mar tete, a kolkha langto ner ktua pis ge ko nong ke vur kre tang hak mnam mar ner kais kam kta kru kuon mang kaela ngang e, ko o mia ngara pis kmemgetik tgus krum kim mar hak.” ");
INSERT INTO sua_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kam ngae, to kalngunes ngta mnganang te, “Ngola pattermia, havaeng ngor na te, mnam ani kolkha to msim ilaro rhek ngar kael mit mnam, he o mia ngara pis kam rum kim a rengmat to enda? Va a kolkha to endo karo ni ngaelmir ruk ngaka ktar kpis kam khenam te, ilaro rhek nga re kmel mit kat?” ");
INSERT INTO sua_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Va e Yesus ta kle khavaeng ngar mang a kolkha to a kser kim te, “Mguak ngangreal ngang nguk matok o mia ngara vraik orom muk petgim dok. Ko o mia kavurgem ngara pis he mur kaelel mar mruo orom kua munik kam re te, ‘A kolkha ta tete, her endo E Nut kmaottam karo rhek tgus mnam.’ Va langto langto ner mur kaelel en mruo orom kua munik kat kam re te, her en arhe Endo E Nut Thim Orom Ka Msasaen. Ngar pua havae tok, vanangko mguak or kam mrua ngam muk ekam mar ge. ");
INSERT INTO sua_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ii, va mguera ngnek mang o ngaus va mguera ngnek mang o mhetor ko ngara kaum kmo kaen ekmar, vanang mguak or kam gor e, ko o tgoluk ruk endri ngaka ktar kpagis ktar mang a kolkha to a kser kim kam pis. Vanangko a mi kolkha to endo ner lua pis ngatngae e. ");
INSERT INTO sua_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nove, ko o mhetor kavurgem ruk endruk mo mmie va o serppak kavurgem kat ngaka ktar khop na, he kmo sir malngaeng ngar mruo kam mo kir mo kmar kat, ");
INSERT INTO sua_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","va a koot naka khikher a mmie klik hak va a vang nera vle kun mnam o mhetor kavurgem. Va o yor ngar gi vrong pagis kat va o ngaelmir ruk lvankue ngar gi vrong pagis kuon ma volkha he ngar mi kut kaengorang o mia kat. ");
INSERT INTO sua_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Vanangko si ktar mang o ngaelmir ruk endri kam pagis na, o mia ngara kapom muk, kol a regesal mang nguk he kael muk ko maktiegom endruk ngma vongnek kim o rhek kun mnam o Yuda ngaro rektor ruk kam rere mnam mar, he ngar kael muk ko kim o taven va endruk ngma nho mang o mia. Va ngara kaenpasiker muk kun mnam a hengor her vgum ko mut kor mnam muk mang dok arhe. ");
INSERT INTO sua_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ii, E Nut tel o vnek ruk endri kam pis ko kmuk tok, he nang muk kam mi ktua polger o rhek mang dok ma mmok ko kim mar kun mnam ke venloot to endo gi enang tok arhe. ");
INSERT INTO sua_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","He ekam tok, mguaka ktar sim kut kaelel o papat te, kam lo vua papat mang o rhek kam mrua hahaong nguk ormar kat e ");
INSERT INTO sua_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ekam ko dok mruo ngor kael o rhek ko vgum muk va o papat ruk lyar kun mnam muk kat. Ii, he ekam tok, mularo imuo ngar lo kais hak kam sir malngaeng nguk kam kokheng nguk mang ngar hak. ");
INSERT INTO sua_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ii, si muortek, muornek, muornopeik, muorlok va muorkaik, kar mulenar kat ngara mas orom muk he kael muk maktiegom endruk ngma vongnek kim o rhek va ngar kaim akuruk kun mnam muk kngam muk o yoror her vgum dok arhe. ");
INSERT INTO sua_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","He enang tok, o mia kavurgem ngar kaelat muk vgum dok. ");
INSERT INTO sua_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Vanang enangthe mgua matnge vgum mar he kor mnam muk mang dok ge, va mguera kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik koknaik. Va si nop ke vur ngairis tang hak kuon malpgem muk tkais kam loloong kat e.” ");
INSERT INTO sua_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Va e Yesus tkoripang ngar te, “Vanangko mguer re kvokom a rengmat to e Yerusalem ko o ngaomevek ngak pis kairkakleim va mguera mnor he te, o-tete ngara likim mar he krum kim e Yerusalem hak he. ");
INSERT INTO sua_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mguer re kvokom tok to endruk ko mYudea ngak ngorpok kgegerap ngoguon kio vlik. Va endruk kun mYerusalem msim ngak ngoropok petgim a rengmat to endo va endruk oguon mail nga lo kta gugrung kam kta vavaik ngogun kat e. ");
INSERT INTO sua_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mguak kaeharom tok, ekam ko kun mnam a venloot to endo E Nut ner kaen a kapnes ngang lYuda kmaottam karo rhek tgus ruk o propet ngat ittiegom mar mang ko ngar mi kael mit msim mang orom a kapnes to endo. ");
INSERT INTO sua_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","He enang tok, suvrum kekhengol ruk ngakro namtor va endruk ngat gia mmeng ngles vop mnam o kolkhek ruk endruk, ekam ko kun mnam a venloot to endo a ho mi kut kernonhommok alaut hak nera kol a mmie ka mhe to endo ko E Nut ner mia khenam ka ngaesik kuon malpgem lYuda kmen a kapnes to endo ngang ngar enang tok. ");
INSERT INTO sua_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ii, va lYuda ngar kaus kar o vrong rhek orom o mus, vanangko o vrong rhek ngar mi kaim mar kngam mar o yoror he o vrong rhek ruk endri ngara seneker o Yuda akuruk kat mar kam vle ku meorom o vrong rhek akuruk yok ko mnam a mmie tgus ngaro singni. Vanang a rengmat to e Yerusalem, o vrong rhek ruk endruk ngara kar mnam he krum kim hak. He a rengmat to endo nera vle tok arhe kam ngae kais ko E Nut mruo ner kaottam o kolkhek ruk telik ngang o vrong rhek, mar kam tu kam nho mang a rengmat to endo kmikkiem o kolkhek ruk endruk kais tok.” ");
INSERT INTO sua_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","27","“Vanangko ktar mang a kolkha to a kser kim kam pis, o vrong rhek tgus ruk mo mmie ngar ho mi ktua gor hak kim a kenho va a kolkha va o ketor ko ngakro serppak ngara mo im mar he kael o ngaelmir ngang o mia enang tok. Ii, va o mia ngara rute krute kat ko ngara moruo pum a mou ka muktim to a ho lautar hak kat va ko o vlung ruk o ho lautar hak ngara lol mar he ngar mia ker kol a ngannes vgum mar hak. To ngar ngae ksei kam gor hak he kyor ka ktal vgum ngaro papat ko ngara horotgi vgum o tgoluk ruk endri ko ngak kirpagis kim mar enang tok. To endo yek, o mia ngara vokom A Mhel To Nkong Man Ma Volkha ko nera pis kun mnam o varhek orom kla mmok va kla serppak. ");
INSERT INTO sua_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ii, o tgoluk ruk endri nga re kpagis enang tok, va mguak sirei he ka nho mkor E Nut ko ketasuo En kmel ekam muk kam lol mularo kerkeknen patgiang ngaiting.” ");
INSERT INTO sua_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","“Ii, mu sim pat na mang a ho to a pik va si o gi vrong hi akuruk kat ");
INSERT INTO sua_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ko mum mrua vokom mar orom mularo kerok mruo ko ngam re kuur va mum hera mnor te, o, ka venloot to kmel rehi mnam ketasuo kam pis. ");
INSERT INTO sua_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mare! Her gi enang tok kat arhe, ko mgua re kvokom o ngaelmir ruk endruk ko ngaka ktar kpapagis enang tok kat, va mgua hera mnor kat te, ketasuo E Nut ka tavgo kam pis kam komor o mia tgus. ");
INSERT INTO sua_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ii, kua mien ngang nguk te, o mia nga main to tete ngat lo kais kam yor vop kam ngae kais ko E Nut naka ktar kaottam o ngaelmir ruk endruk mar kam pis lmien na. ");
INSERT INTO sua_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ii, a volkha kar a mmie nginera loloong, vanang kuaro rhek ngat lo kais kam loloong hak. ");
INSERT INTO sua_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","He ekam tok, mguak ngangreal ngang nguk, matok o kerkeknen ngara vrengem mularo papat ruk mang a kolkha to endo, nang a kolkha to endo nak le kpis pangnaom muk enang a pnol ko nma senkrip kim a baor ko ther gi ru pum he. Ii, mguak ngangreal ngang nguk mang a kerkeknen to kam sovet mang a ngaiviem a ye to a serpgar va endo kam sovet mang a ngaemik. Va mguak ngangreal ngang nguk mang o gi vrong vnek ruk mo mmie kat, endruk ngma kpom o mia he kvanker mar. ");
INSERT INTO sua_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ii, o mia ruk mnam a mmie karo ngaitngol tgus ko ngam gi vrong kvavle ngpang ngar, ngara ru pum a kolkha to endo kat. ");
INSERT INTO sua_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","He ekam ko a kolkha to endo nera pis pangnaom muk tok, va mguak sim kut kaelel kuo mang nguk mo kolkhek tgus he kaurur kim E Nut, En kmenserpgam muk kam matnge vgum o vnek ruk endruk ko ngak pagis kim muk gi enang tok, he nang mularo vurkul kam mrer kun mnam a kolkha to endo, ko mguera sir ko kim A Mhel To Nkong Man Ma Volkha kalo keik, en kam mon muk orom mularo kerkeknen.” ");
INSERT INTO sua_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","E Yesus nma patter o mia tok mo ruteik tgus kun mnam E Nut ka maksien ko ngma hop khalki kam vongnek kim. To mo vlemkor tgus nma parem e Yerusalem, nang hera grap ngoguon kim a vul to e Olip kam ngae konit. ");
INSERT INTO sua_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","To ta konner mar kmem a pnes to ngma mon te, A Pnes To Kmem A Gi Bret, endo o Yuda ngma mon kat te, A Pnes To A Engyel Tvarpaam O Yuda Ngaro Molpou. ");
INSERT INTO sua_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","To o pris ruk laol va o pattermia kmo pos ngata khanang ngar kam riring a papat tang te, nngia he o mia ngar kais kam rum kim e Yesus lvongnek. Ngata svil kmeharom lvongnek tok, ekam ko ngta gor te, o mia ngara kaum kaen ekmar pum, enangthe ngap kaim ma mmok ko pa pnes. ");
INSERT INTO sua_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","To e Seten ta viging ngaela langto mnam o aposel ruk loktiek hori orom alomin, endo ka munik e Yudas to nkong mIskariot. ");
INSERT INTO sua_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","To thera ngae kpis ngok kim o pris ruk laol kar endruk ngma toot mang E Nut ka maksien he krere kar mar mang a ngaelaut to en kam mas orom e Yesus kmel maktiegom mar. ");
INSERT INTO sua_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ngata rere knop, to ngate ksei kam sirei he kaenserpgam a papat to endo kmenkim e Yudas orom o krek. ");
INSERT INTO sua_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","E Yudas thera tting mang o krek, to ther gi vrua vle kael onit ngang e Yesus, en kam mas orom kmel maktiegom mar lvongnek. ");
INSERT INTO sua_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tie palngaem ko o Yuda ngta kunngir kim a pnes to ngma mon te, A Gi Bret. Vanang mnam a pnes to endo ngam kaim o sipsip ruk o sital kam mur kael pat kmar mruo mang ko a engyel tvarpaam o Yuda ngaro molpou ruk tennik. ");
INSERT INTO sua_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","To e Yesus ta meng e Pita kre Yoanes he khavaeng ngin te, “Meak ngae he kaelel mo kim o ol ngang ngor mang a pnes to enda mor kmemik.” ");
INSERT INTO sua_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Va ngint koripang te, “Te moak ngae ngok mnam ani rek to?” ");
INSERT INTO sua_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Va e Yesus te smia papsim min te, “Mea ngae kpis kvaik kun mYerusalem va mera pis mang a ngokol langto ko tiniram ka ye he ktolpum ngok mrek. Meak her kaikkiem her endo arhe ngok mnam ka rek ko nera vaik kun mnam. ");
INSERT INTO sua_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mea pis ko tok he khavaeng a rek kteit te, ‘E Pattermia ta svil kam kunngir kim a kolkha to A Engyel Tvarpaam O Yuda Ngaro Molpou kar kalngunes. Va ta mnganang yin te: Ila taban to mkor o gunmia nam, mor kmelel mo kim o ol kun mnam?’ ");
INSERT INTO sua_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Meaka mnganang tok, yek ner mrua khenam a taban tkuon mail ko ngat pasrengem he sim elel o ngorsang va a psen he. To meak kaelel mo kim o ol ko mnam a taban to arhe.” ");
INSERT INTO sua_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Te smia papsim min tok knop, to ngint hera ngae to kpis mang sim kut enang tok arhe ko e Yesus tpapsim min tok. To ngint her kaelel mo kim o ol ko tok, mar kam kunngir kim a kolkha to endo. ");
INSERT INTO sua_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ngint kaelel mo kim o ol knop, to a kolkha ta vaik he, to e Yesus kar o aposel ngat ngae kpis kun ma rek to endo, to her korosang kam her kaemik he. ");
INSERT INTO sua_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ngata hivuo kmemik, to e Yesus thera reng ngar te, “Ko mi ktua svil hak kam mia kunngir kim a kolkha to enda kar muk tete ktar mang dok kam ker kol vgum o nganngannes. ");
INSERT INTO sua_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ko kua havaeng nguk te, ngor lo kta kunngir kim a kolkha to enda kar muk kat e, kam ngae kais ko E Nut ner kael a pnes to enda ka pun msim ma mmok mnam a kolkha to ka tavgo nera komor o mia tgus.” ");
INSERT INTO sua_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ta re tok, to ta kol a kolhi orom a ye to vaen maktiegom ka kayie langto to kanprim E Nut mang to kaen ngang kalngunes he kreng ngar te, “Mguak kol he kmaen kmivie mnam ");
INSERT INTO sua_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ko kua havaeng nguk te, ngor lo kat kaiviem a ye to a vaen ta kar muk kat e, kam ngae kais ko E Nut ka tavgo nak pis ma mmok.” ");
INSERT INTO sua_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","To thera kol a bret vat, to kta kanprim E Nut mang he kommen to kaisis kim mar kam klang ngar orom kat he kreng ngar te, “Kua vok ta arhe ko kaen mang nguk. Mguak kol a bret ta kmaen kmemik mnam mekam mekam kam pat mang dok orom.” ");
INSERT INTO sua_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ngat kaemik knop, to ta kta kol a kolhi orom a ye to a vaen vat he kanprim E Nut mang kat, to kaen ngang ngar he kreng ngar te, “A kolhi orom a ye to a vaen ta, ta vle te, kua gidiel ta arhe, endo ta ksuk mang nguk. E Nut ta sir malpgem kua gidiel ta kmelha pum ka mokpom to a gunngar kar muk.” ");
INSERT INTO sua_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","E Yesus ta kta rere kat te, “Va mu vokom na, si a ngaemik to enda tete va endo nera hortgi mang dok ta tuur mnam mo kim dok kat. ");
INSERT INTO sua_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ii, nera hortgi mang dok tok, kmikkiem lsir gi enang ko E Nut mruo ta ktar el A Mhel To Nkong Man Ma Volkha kam yor tok. Vanangko suvrum kela to nera hortgi mang.” ");
INSERT INTO sua_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","E Yesus thavae tok, to ngat her kaelha kam mo mnganang ngar te, edim mnam mar msim te, nera hortgi mang tok. ");
INSERT INTO sua_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Vanang ktar mang ko ngat lo korsang kmemik vop, ngata mo kir kmar orom o rhek te, edim mnam mar nak kol a ngaekam to ngma nho orom ko vanam a ngorsang kteit. ");
INSERT INTO sua_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","To ta reng ngar te, “O vrong rhek ngakro taven ngma karkar mang ngakro mia mruo kam sopong ngar kam mon ngakro taven ormar. ");
INSERT INTO sua_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Vanang muk mguak or kmenang ngar tok e, ko enangthe tang mnam muk naka svil ka munik kam laut, va na kle mrua krus orom en mruo he kle ka vle enang a kalyie tang. Ii, va endo naka svil kam nho mang o mia, va her endo kat arhe, na kle mur kael en mruo kmeha ngang ngar. ");
INSERT INTO sua_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mu vokom na, edim mnam alo mhel ri ta laut kir kim kaela, endo tkol a ngaekam to kmorsang ko va psen kmemik, i o endo nam kaeha ngang o mia kam krong o ol ngang ngar? Te her endo nam korsang ko va psen ngola? Mare. Vanangko mu vokom na, dok ko her pis mo pgegom muk kam kle va ka vle enang endo nam kaeha ngang o mia. ");
INSERT INTO sua_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Va her muk ri arhe ruk muma tuur mnam kuaro vnek ruk ngat pis mang dok ko mutlo ngorpok parem dok e. ");
INSERT INTO sua_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","He ekam tok, her muk ruk arhe mguera tuur mnam E Nut ka tavgo to tel maktiegom dok tok, ko dok mruo ngor le kael maktiegom muk kat. ");
INSERT INTO sua_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ngor kael E Nut ka tavgo maktiegom muk tok, muk kam kunngir kim dok kun mnam a kolkha to kua tavgo nak vaas kim o mia tgus he komor mar. Ii, mguera tuur mnam E Nut ka tavgo tok he klol o ngaekmol ruk kmorsang mnam mar kvongnek kim o rhek ruk mkor lIsrael ngaro usiel ngo pneik ruk loktiek hori orom alomin kat.” ");
INSERT INTO sua_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Va e Yesus ta kta reng e Saimon to e Pita kat te, “O, Saimon vokom na, E Nut ta tting mang e Seten kmegom muk, he nang en kam khikher kolngunes tgus ruk muk, en kmommen muk ruk lyar petgim endruk nong lyar enang a mhel to nama khikher a kotop kmommen ka ngaor petgim kakro khek. ");
INSERT INTO sua_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Vanangko Saimon dok ko her kaurur kim E Nut mang in he, yin kam sir kserppak orom ilaro papat ruk kmor mnam yin mang dok he lua ksir petgim dok hak. Vanangko, kopekam ko ngia klai mang dok to kle kat kael ilaro papat lserppak kmor mnam yin mang dok, ngiak le kaenserpgam ilenar kmel ngaro papat lserppak kmor mnam mar mang dok tok kat.” ");
INSERT INTO sua_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","E Yesus ta re tok, to e Pita ta kokheng kmaur kim te, “O-o koldaip ko her gia toot he mar kam her gi kaenpasiker dok va kaim dok kar yin ha.” ");
INSERT INTO sua_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Va e Yesus tkokheng e Pita te, “Kua havaeng in Pita, ktar mang ko a ngaining kmeti ngkir mo kao, yin ngira klai mang dok ngkorlotge kam havae te, yi lua mnor mang dok e.” ");
INSERT INTO sua_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Va e Yesus ta mnganang ngar kat te, “Tie ko kua meng nguk he khavaeng nguk kam lo kaeha kim a ngaelpas tang, a psang tang va o nharok akor va muta pat nngia, te muta ngae he muta tu kmo tgoluk akor kat o nop?” Va ngat koripang te, “O-o nove!” ");
INSERT INTO sua_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","To thera reng ngar te, “Yu! Vanangko tete ko kle khavaeng nguk vat te, enangthe kakro ngaelpas ngang nguk va kakro vasngeik ngang nguk va mguak lol he. Va enangthe nop o mus ngang nguk tete va mguak kaen mularo it ngang o mia mar kmenenkim mar mkor muk, he muk kam le kaenkim akor. ");
INSERT INTO sua_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mguak kaenkim o mus enang tok, ekam ko E Nut karo rhek ketasuo mar kmel mit ormok ko o propet ngat ittiegom mar mang dok te, ‘En nera ker kol vgum a kapnes ka mten to o ngauruvik ngma kol enang tok kat.’ Va kua havaeng nguk te, E Nut karo rhek ruk endri ngak kael mit orom dok arhe he vur kat ngar kam ngae kpis ko tok msim he.” ");
INSERT INTO sua_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ta re tok, to kalngunes ngat her koripang te, “Ngoldaip vokom na, alo mus alo ri he.” To thera havae te, “Tis ko he!” ");
INSERT INTO sua_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ngat kaemik knop, to e Yesus tkottek he kngae ka grap ngoguon kia vul to e Olip kmikkiem ko nma grap kngae ko tok. Va kalngunes ngat kaikkiem kat. ");
INSERT INTO sua_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ngta grap to pis kuon, to e Yesus ta reng ngar te, “Mguak ngarkie mang nguk mruo, muk kam lo mrua ngam muk mruo ekam o kerkeknen ruk ngam kaegom muk.” ");
INSERT INTO sua_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tre tok, to tgi vur kaol kparem mar ko tok, to ktubulkek he kngarkie ngang E Nut kam re te, ");
INSERT INTO sua_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Yoko dok gi, Titou-o, ngia svil va ngia pet la vut to enda orom kua yor to tre kam kol dok vanie. Vanangko ngior kam kokol ekmok e, ngiak kle va kaikkiem ila svil mruo ge.” ");
INSERT INTO sua_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","A vnek to endo ta kol he tsia vavle vgum, he ekam tok, tho gi kaenenker he ksovet kam ngarkie kngae. Ta ngarkie tok kngae, va karo prongyek ngta lul klik hak ekam ogu mmie enang a gidiel. Kam ngae, to a engyel langto tottek kuon ma volkha he kpis ko kim he kaenserpagam. ");
INSERT INTO sua_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tngarkie knop, to khop kngae kmeknik ngok kim kalngunes he kvokom mar ko a ngonit ta vurvrum mar vgum nga mamrung to mang en mruo ko ta ngormar. ");
INSERT INTO sua_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tvokom mar tok, to ta votgem mar he ka mnganang ngar te, “Kman ko mut konnit? Mu hohop he kngarkie mang nguk mruo, muk kam lo mrua ngam muk ekam o kerkeknen ruk ngam kaegom muk.” ");
INSERT INTO sua_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","E Yesus ta rere vop, nang endruk loktiek hori orom alomin ngaela langto mruo to ngma mon te, e Yudas, ta ktong a rkan langto orom o Yuda ngalmialaol. To endo he, e Yudas ther gia ngae lsir rkieng e Yesus kam vrua pum ka volha kam mrung tok, ");
INSERT INTO sua_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","vanangko e Yesus ta mnganang te, “Ngola Yudas, ya mrung dok tok kam hera mas orom A Mhel To Nkong Man Ma Volkha kmel ko maktiegom karo imuo kman?” ");
INSERT INTO sua_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","E Yesus kalngunes ngta vokom ko ngat re kam kpom to ngta mnganang te, “Ngola, Ngoldaip ngrua kaus kar mar orom nguaro mus ri?” ");
INSERT INTO sua_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ngata mnganang tok, va vgum langto mnam e Yesus kalngunes ko ther gi kait ka kom ku her gia ngam mang o pris ruk laol ngalaip kalkayie langto va her gi kser ka ngaela to a miktiek ka pun kpet hak. ");
INSERT INTO sua_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Vanangko e Yesus ta hagam te, “Tis ko he,” nang ther kaehang a mhel to enda ka ngaela to thera srim kam vat kat. ");
INSERT INTO sua_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","To e Yesus ta mnganang o pris ruk laol va o tootmia ruk ngma toot mang E Nut ka maksien va o Yuda ngalmialaol ruk ngat kaol kam kpom te, “Ngola, nok pathe mut vua kokho orom o komtok va o kier kmurmur mang dok kam kpom dok va enangthe dok a mhel to kom kaenpgam o mia kam kaum kaen ekam lRom he kaus kar mar vor? ");
INSERT INTO sua_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ma te mo kolkhek tgus kom gia vavle ko pgegom muk kun mnam E Nut ka maksien va mum her lua pat gi kam hera kpom dok ko tok? Vanang her mu ke venloot ta arhe kam kpom dok ko tho mi kut slok hak ko e Seten ta nho mang orom ka tavgo.” ");
INSERT INTO sua_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","To a rkan to endo ngta murmur mang e Yesus he ka koleng singni mnam to ka ktong kngorom ngok kim o pris ruk laol ngalaip ka ngoulu to klalaut ko tok mnam E Nut ka maksien, nang e Pita tgi vrua pepem mar kngae orom e Yesus. ");
INSERT INTO sua_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ngata pis kvaik kun kuo mnam o pris ruk laol ngalaip ka ngoulu, nang e Pita ther pis knaek mang ngar ngok mnam E Nut ka maksien to endo ka mhe to ha ku mnok ko ma gi vle he gia vle klangtar orom oguon ma ngoulu. Va o mia ruk ko tok ngat giem a paei kun pgegom a mhe to endo, va e Pita tkorsang ko kim mar kat. ");
INSERT INTO sua_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ta vle ko tok, to a vlom to nam kaeha ko tok tvokom ko tkorsang ko kim a paei ka mmok to sim ktua kellu mnam kam mnor, to le kreng klenar te, “Ai, a mhel to enda, nam kaikkiem e Yesus kat.” ");
INSERT INTO sua_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Vanangko e Pita ta klai mang te, “Kolkheng, kua havaeng yin te, klua mnor mang a mhel to endo e.” ");
INSERT INTO sua_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","To ngta vrua vle nong ke laut to a ngokol langto kat ta kta nho vokom e Pita to kreng te, “Mare, yinda kalkayie langto yin arhe!” Va e Pita ta kta klai kat te, “O-o dok nove.” ");
INSERT INTO sua_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","To ka vle ko a loot tvur hok he, to a ngokol langto ta kta reng klenar te, “O lmien hak he, kalkayie langto en arhe ko en nkong ko mGalili kat.” ");
INSERT INTO sua_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Va e Pita ta kta klai kat te, “O-o, klua mnor mang ilaro rhek ruk e.” E Pit ta rere vop, va vgum a ngaining ko ther kaeti. ");
INSERT INTO sua_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","To e Yesus thortgi he kalo keik ngint kaem e Pita, yek e Pita thera pat mang e Yesus karo rhek ruk tmur ktar khavaeng ormar te, “Ktar mang ko a ngaining kmeti ngkir mo kao ngira klai mang dok ngkorlotge.” ");
INSERT INTO sua_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","E Pita ta pat mang o rhek ruk endruk to her kottek mnam E Nut ka maksien to endo to kngae kpolger karo reti klik. ");
INSERT INTO sua_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Va o Yuda ruk ngma toot mang e Yesus ngat kaelha kam klel orom he ka kleng kalo keik kam tokim min, en kam lua nho to khim singni malpgem to khavaeng te, “Yindo a propet, yin he, mon edim mnam mor tim yin!” ");
INSERT INTO sua_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ngat eharom tok ngang, to le ho ksisieng kat orom ngaro rhek akuruk kat. ");
INSERT INTO sua_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ngta vle kar e Yesus tok kam ngae, to tie marot ngta srim ko pum o Yuda Ngar Ke Murgun to ngma vongnek kim o rhek, endruk o Yuda ngalmialaol, va o pris ruk laol va o pattermia kmo pos ko ngta kaum kun mnam ngarta rek mruo kam vongnek kim e Yesus karo rhek. ");
INSERT INTO sua_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","To ngat hera havaeng te, “Enangthe lmien te, Endo E Nut Thim Orom Ka Msasaen to yin, va yin he, havaeng ngor lsir tok.” Va e Yesus tkoripang ngar te, “Enangthe ngua re khavaeng nguk tok, va mguer lua serppak mang kuaro rhek e. ");
INSERT INTO sua_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Va enangthe kopa mnganang nguk tok kat, va mup lua svil kmoripang dok lsir kat e. ");
INSERT INTO sua_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Vanangko kmelha tete kngae ngnik ngnik A Mhel To Nkong Man Ma Volkha nera korsang ko mnam E Nut To A Ho Ngaurar Hak ka miktiek.” ");
INSERT INTO sua_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","E Yesus ta re tok, yek ngat her le ka mnganang te, “Te ma te, ekam tok E Nut Khal to yin?” Va e Yesus tkoripang ngar te, “Muk mruo mut her ngae rkieng dok he, orom a re to endo.” ");
INSERT INTO sua_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ngata ngnek tok, to kmo havaeng ngar te, “Ngrua lo kta khanang ngor kam lol o rhek akor kat e, ko ther mur vat en mruo tok he, kmel en mruo ma kernonhommok orom karo mur rhek ruk endruk.” ");
INSERT INTO sua_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ngta nop orom ko kim o Yuda Ngar Ke Murgun to orom ngalmialaol, to mar tgus ngta hohop ku to kottek kun mnam E Nut ka maksien to endo he ka ktong e Yesus kam ngae ka srim ko kim e Pailet vat, endo lRom ngat el kam nho mang lYudea. ");
INSERT INTO sua_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ngta pis orom ko tok, to ngat her kaelha kam ppiak he ka krong orom o rhek te, “Mor mruo ruk lYuda ngota vokom te, a mhel to enda nam kaenpgam o mia kam kering muk lRom mula serppak ko nma rere kim mula pos to mula taven tmur el, endo kam ngam o takis ngang lRom. Va en nam mrua vat en mruo te, en Endo E Nut Thim Orom Ka Msasaen arhe, endo mor o Yuda ngua taven msim.” ");
INSERT INTO sua_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","E Pailet ta ngnek tok, to hera mnganang e Yesus te, “Ngola, O Yuda Nga Taven msim to yin arhe?” Va e Yesus tkoripang te, “Yin mruo yi her ngae rkieng dok he, orom a re to endo!” ");
INSERT INTO sua_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","E Pailet ta mnganang knop, to ta kaum o pris ruk laol va a mumu to ko tok to hera reng ngar te, “O rhek ruk ko ngannik vgum ngta khenam te, klo kais kam mon en orom a kerkeknen tang e.” ");
INSERT INTO sua_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Vanangko ngat kaenker he kreng te, “Nove, lmien te, nam kaenpgam o mia mo mYudea tgus kam rere kim lRom mula serppak ko nma patter mar tok. Vokom na, telha mGalili he, he kngae kam ngae kais moti.” ");
INSERT INTO sua_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","E Pailet ta ngan ko ngta mon a rengmat to e Galili to thera mnganang ngar te, “Te a mhel to enda nkong mGalili?” ");
INSERT INTO sua_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tkol a re mang tok, to ta mnor te, e Herot ka serppak ta komor a mhel to endo. To thera meng e Yesus ngok maktiegom e Herot, ko e Herot, en tgi vrong kvavle ko mYerusalem kun mnam ke venloot to endo kat. ");
INSERT INTO sua_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","E Herot tre kvokom e Yesus, va te sei kam sirei hak, ko nam kaelha tiok he, he gia ngongnek mang ko en nam kaeharom o reha ruk lserpgue va nma pat lserppak kam mia vokom te, en kmeharom a ngaeha tang ko a serpgar ko pum kalo keik msim. ");
INSERT INTO sua_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","To e Herot ta petpet o mngan ngang he, vanang e Yesus tlo ktua re kmoripang ngar e. ");
INSERT INTO sua_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ta vle tok, to o pris ruk laol va o pattermia kmo pos ruk ngata sir ko rkieng ngat le kol e Yesus ka ngaekam kam mo turang ngar pum e Yesus kam ho gia sovet kam petpet o resik malpgem vat kam mon orom karo kerkeknen. ");
INSERT INTO sua_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kam ngae, to e Herot kar karo mia ruk ngma kar va tomten ngat kaelha kam klel orom e Yesus, he ho ksisieng hak kam pasrengem orom o taven nga yet langto orom karo vu kraen. Ngat pasrengem knop, to ngat her kat kaekon kam kta srim ngok pum e Pailet kalo keik tok kat. ");
INSERT INTO sua_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","(Vanangko tesgun e Pailet kre Herot ngin mo kael imuo mo kmin tiok kam ngae kais mnam a kolkha to endo, yek ngint le kmokpom.) ");
INSERT INTO sua_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","To e Pailet ta kta kaum o Yuda ngalmialaol va o pris ruk laol va a mumu alautar kat ");
INSERT INTO sua_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","he kreng ngar te, “Mut kol a mhel to enda he kpis orom mo kmok he khavae mang te, ‘Tkaenpgam o mia kam rere kim mor lRom ngua serppak’, va dok ko her vongnek kim nanga he, mo pum mularo kerok mruo va ko vokom te, mularo rhek ruk muta krong en ormar ngat lo vua sir e, he ngat lo is kam mon en orom a kerkeknen tang kat e. ");
INSERT INTO sua_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Va si e Herot kat te gnua vokom enang tok kat, he tkat kaekon ngte kim mor ko tlo pis mang ka keknen ngang to kmiser a kapnes to kmim kngam a yoror kat e, he enda kim mor kat he. ");
INSERT INTO sua_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nangko si enang tok, ngor gi kaen a re na, mar kam kirmekon a khap mnam, to ngor sim kaikkiem mor lRom ngua keknen mruo, endo kam hong a mhel tang kun ma hengor ko ngot kaenpasiker ko tok. Nguak kaikkiem a keknen to enda, he khong e Yesus kmeng, en kam hera ngae.”  ");
INSERT INTO sua_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Vanang e Pailet tel ka papat to kam hong e Yesus tok, kmikkiem ko mnam a pnes to endo tgus ko o Yuda ngam kaem, lYuda ngalaip to lRom nam kaikkiem a keknen to kam hong a mhel tang kun mnam a hengor ngok kmar, endo lYuda mruo ngam mrua re mang. ");
INSERT INTO sua_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Va ekam ko e Herot ta havae mang kam hong e Yesus tok, o mia tgus ngta mo turang ngar kam rere klik kam re te, “O-o, ngiak hong e Barabas ngte kmor, nang en ngiak kaim kngam a yoror.” ");
INSERT INTO sua_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ngat mon e Barabas ko en a mhel langto lRom ngat el kun ma hengor ekam ko tkaoppom o rhek mnam o mia kmus kar lRom ko mnam a rengmat to endo va ko tim a mhel langto kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","To e Pailet tkat kaegom kmaur kim a mumu ko en ta svil kam hong e Yesus. ");
INSERT INTO sua_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Vanangko ngat le ho gia sovet kam ho gia rere klik kmoikie kam re te, “Ngiak krong orom o ot kvat engnang a ho! Ngiak krong orom o ot kvat engnang a ho!” ");
INSERT INTO sua_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","To e Pailet tkat kaegom ngkorlotge kam reng ngar te, “Nguak kaim kman? Muk mruo mgua havae mang ani kerkeknen msim ko teharom to kmiser a kapnes to kmim kngam a yoror, ko dok klo pis mang a kerkeknen tang to teharom to tkaiser tok e. Nangko si enang tok, ngor gi kaen a re na, ngar kam kirmekon a khap mnam, to ngua kaikkiem ngua keknen he khong, en kam hera ngae.” ");
INSERT INTO sua_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Vanangko ngat kle ho gi kael a halum kam ho gi kaenker ngang, kam re lserppak te, en kam krong orom o ot kvat engnang a ho. Ngat sovet kam vui tok, he ho gia kir kim e Pailet he. ");
INSERT INTO sua_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Enang tok, e Pailet thera tting kam srim nga papat to endo he le kmonik kim a yor ngang e Yesus. ");
INSERT INTO sua_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","To e Pailet tkaen a re kam hong e Barabas, endo o Yuda ngat kaenker en kam hong. Ngat hong e Barabas knop, vanang kle kael e Yesus maktiegom a rkan to mkor lRom, mar kmim kngam a yoror kmikkiem o Yuda nga svil to tok. ");
INSERT INTO sua_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kam ngae, to a rkan to endo ngta ktong e Yesus kngorom ekam a ngaelaut. Ngta ngae to kting kim a mhel langto ka munik e Saimon to nkong mSairini ko tottek ko ma lootpgeik he kaeknik ngok mrek. Va endruk ngma kar va tomten ngat kael singni mnam to ktolpum orom e Yesus ka ho to kmoreker kuon, en kam knaek ekam e Yesus orom. ");
INSERT INTO sua_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ngta ngorom tok, va a mumu alautar ta knaek ekam kar lraip ruk ngta him ngaro singni he kaelha kaee mang kaikkiem. ");
INSERT INTO sua_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","To e Yesus thortgi ka nho knaek mang ngar to kreng ngar te, “Muk lraip ruk mYerusalem mu or kam kat kaee mang dok e. Mguak kle va mur kaee mang nguk mruo va mules ha, ");
INSERT INTO sua_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ekam ko a kolkha to a kernonhor nera pis kim muk he o mia ngara re mang nguk te, ‘Lraip ruk ngat gia mait, kar endruk ngat lua llues vop va endruk ngat lo mmeng ngles vop, ngata lgekol ko nera mrer ngang ngar kam ngorpok petgim a rengmat to enda.’ ");
INSERT INTO sua_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ko mnam a kolkha to endo msim a propet karo rhek ngar kael mit ormuk te, ‘O mia ngara kukueng o vlik te, “Mguak kuviet kuon mang ngor he, he kaeguyang ngor.’” ");
INSERT INTO sua_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ii, a kolkha to enda nera vle enang tok arhe ngang nguk, ko enangthe lRom ngata sovet mang Endo E Nut Thim Orom Ka Msasaen kam rum kim, gi enang ko mut her mrua vokom tete ta, va ta khenam kat te, koknaik ngar le kta sovet mang nguk ruk o gi vrong Yuda mo mYerusalem tok kat kam ho mi ktua rum kim muk kat. Ii, gi enang ‘O mia ngata sovet mang kam rum kim A Ho To A Katlar tete, va ta khenam kat te, ngar le ksovet mang o gi vrong hi ruk ngata vui kat kam ho mi ktua rum kim mar tok kat.’” ");
INSERT INTO sua_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Va alo ngauruvik aloruk kat ngta ktong ngin kngorom min ekam a ngaelaut kam ngae kaim min kat. ");
INSERT INTO sua_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","To ngta ngorom kngae kpis ko mnam a mhe to ngma mon te, “A Mhel Ka Lpek Ka Kolhi.” To mnam a mhe to endo, ngat hera kaum e Yesus kar alo ngauruvik kam kaum ka krong ngar orom o ot kvat mar engnang o hi. Ko ngta srim a ngauruvik langto ko vanam e Yesus ka miktiek va langto ko vanam ka ksienga. ");
INSERT INTO sua_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ngta krong ngar engnang o hi knop, to e Yesus ta re te, “Titou ngia kol nga kerkeknen to enda patgiang ngaiting, ekam ko ngat lua mnor mang te, a ni ngaeha to msim ngat kaeharom e.” Ta re tok, to endruk ngma kar va tomten ngata khanier kam kir mo kmar kam mnor te, edim mnam mar nera kol langto langto mnam e Yesus karo it. ");
INSERT INTO sua_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nang o mia ngat her gia sir ko tok he keketar, va o Yuda ngalmialaol ngta kinknim ngakro vorngap kim he ka klel orom te, “Nma sulgim o mia akuruk, vanang tete enangthe lmien te, En Mruo Msim To E Nut Tmur Re Pum, Endo E Nut Thim Orom Ka Msasaen va en he, na mrua khenam tok mo kmor he mrua sulgim en mruo tete.” ");
INSERT INTO sua_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","38","Va kuo malpgem ko engnang a ho ngat el o rhek ruk ngta mon en ormar te: “O YUDA NGA TAVEN TA ARHE.” To endruk ngma kar va tomten ngat pis ko pum ka ho kam klel orom kat kam reng te, “Enangthe lmien mang in te, o Yuda nga taven to yin, va yin he, mur sulgim yin mruo.” Va ngta klel orom enangthe en a mi taven langto msim ko ngat kauyang orom a ho ka ye to tngae gia gruk ko ngat re kmen ngang en kmiviem. ");
INSERT INTO sua_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","To tang mnam alo ngauruvik ruk nginta valval ko rkieng e Yesus, ta petpet o rhek ngang kam klel orom kat te, “Ngola, ima havae te, her yindo arhe Endo E Nut Thim Orom Ka Msasaen ngola? Va yin he, pupam mor tgus he sulgim mor.” ");
INSERT INTO sua_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Vanangko kaela ta kner te, “Or tok, yi lua gorang a kapnes to ketasuo E Nut mruo ner kaen ngang in gi? Ko mor tgus ri ngot kol a kapnes to enda he re kam yor he, va muo lmien mang nguo ko mot kais kam kol a kapnes to enda, vanang en tlo eharom a kerkeknen tang to kmiser a kapnes to enda e.” ");
INSERT INTO sua_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","To thera reng e Yesus te, “O-Yesus, koknaik ko ila tavgo na komor o mia tgus, va ngiak pat mang dok.” ");
INSERT INTO sua_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Va e Yesus tkoripang te, “Kua havaeng yin lmien te, her gi tete ta yin ngira korsang kar dok kuon ma Loot To La Vu Yar Hak.” ");
INSERT INTO sua_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pkolkha vop, va vgum a slommok ko ther gi pis pgeik komor a volkha va a mmie tgus kngae kais mavlemas ");
INSERT INTO sua_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","46","ko a kolkha tlo kta nan kat e. Tgi slok ngatngae. A kolkha ta slok vop, to e Yesus ta kael ka ktui klik kam re kuon mail te, “Titou, ngiak vaeng kua nunu ngok kmin ko ko kael ko maktiegom in.” Tre gia re tok knop, to ka ngaung thera mtiet he. Tyor tok, va vgum a yet to ta kaeltoot mang E Nut ka maksien ke rek Ka Taban To A Ho Totur Hak ko ther gi kommenik kam ngam ko vgum kalo gu tgus kmel kalo kae alomin. ");
INSERT INTO sua_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","To lRom nga ngaomevek ka rkan langto kalaip tvokom ko e Yesus tyor tok, to khover E Nut ka munik kam re te, “O lmien hak he, a mhel to enda, en a mhel langto tlo vur eharom a kerkeknen tang hak.” ");
INSERT INTO sua_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","To o mia tgus ruk ngta gun he ksor kim ko o mia ngta ngam o leep kuon mang ko pum ngaro kerok tok, ngta him ngaro singni to her kaekeknik kun mnam a rengmat. ");
INSERT INTO sua_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Vanang endruk ngat smia mnor mang e Yesus ngat her gia sisir ko vur malhagenmok mang kar lraip ruk ngat ottek mGalili he kaikkiem. Ngta sisir ko tok he kvokom mar pum. ");
INSERT INTO sua_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ngat vokong ko e Yesus tyor tok, to a mhel langto nkong mAramatea ko mYudea ta vle. Ka munik e Yosep. En a mhel a yar ko en nam sim kut kaikkiem E Nut karo pos he nma paneng Endo E Nut Thim Orom Ka Msasaen kam pis he ka tavgo kam komor o mia tgus. Nam kaeha kar o Yuda Ngar Ke Murgun to ngma vongnek kim o rhek kat. Vanangko en tlo tting mang nga papat to kmim e Yesus kngam a yoror e. ");
INSERT INTO sua_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","E Yosep ta ngae ngok kim e Pailet he ka mnganang mang e Yesus ka mnes en kam kol he kael. ");
INSERT INTO sua_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","E Pailet ta tting orom, to e Yosep thera ngae kpis kharpeet e Yesus ka mnes kuo va ho to kokomor orom a yet. To thera kokol kngorom to kael kun mnam a kre ka nho to ngat gi gnua hong he lo el a mhel ka mnes tang kun mnam vop. ");
INSERT INTO sua_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tel ka mnes knop, nangko ma kolkha to endo ko tel ka mnes ta vle te, o Yuda nga kolkha to kmelel mo kim o tgoluk kam paneng a Sabat ko ketasuo en kam vuut. ");
INSERT INTO sua_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","E Yosep tel ka mnes ko tok, va lraip ruk ngat ottek mGalili he kaikkiem e Yesus, ngat kaikkiem e Yosep he kvokom e Yesus ka nnak va ngat sim ktua keketar e Yosep pum ko tel ka mnes ko tok. ");
INSERT INTO sua_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ngta vokom tok, to her kaekeknik ngok mrek ngok mYerusalem he kpis kaelha kam mat o ku kam pungnim e Yesus ka mnes orom mar, vanangko a Sabat ther pis kmar he, to ngat her lo kat kaeha kat e. Ngat gia vavle kam paal ma Sabat kmikkiem ngaro pos enang tok. ");
INSERT INTO sua_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","To hop enang ngmo ma Sande, lraip ruk endruk ngat hop halki tie mo kao he klol o ku ruk ngat her momrot he, to hera ngae ngok pe Yesus ka nnak kam pungnim ka vok orom mar. ");
INSERT INTO sua_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ngat re kpis va vokom a kre to klaut, endo ngat elegot kim e Yesus ka nnak ka gu orom ko tollok he kvulhi he ka vle petgim a nho he. ");
INSERT INTO sua_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","To ngat pis kvavaik ogun ma nho, vanangko a nho ka gi kolhi ko Ngoldaip to e Yesus ka mnes tlo vle kun kat e. ");
INSERT INTO sua_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","To ngat mrua sor mo kmar kngae va vgum alo ngokol alomin ko ngint gi pis ko pgegom mar orom nginalo yet ruk nginta nan hak ko ngint ngae gia vle enang a koot ko nma gurmik he kvaller a volkha. ");
INSERT INTO sua_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Lraip ruk endruk ngat vokom min tok, to ngat ngae ho mi kut gor hak to kulmar ku penharom min, vanangko alo mhel ri nginta reng ngar te, “Kman ko muta riring endo tgia ktal mo mnam a mhe to mkor o yoror. ");
INSERT INTO sua_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","En nong mo e, ko ther hop petgim ka nnak he, kmikkiem karo rhek ruk tmur ktar kpavap ngang nguk orom mar mnam o kolkhek ruk muta vle ko mGalili. He mut lua pat mang karo rhek ruk endruk gi? ");
INSERT INTO sua_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ko ta ktar kpavap mang en mruo orom karo rhek ruk endri te, ‘A Mhel To Nkong Man Ma Volkha o mia ngak kael maktiegom endruk ngam kaeharom o kerkeknen, mar kam krong orom o ot kvat engnang a ho, vanangko kopekam o kolkhek ruk korlotge ko ngat el he, nak hop petgim ka nnak.’” ");
INSERT INTO sua_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ngint re tok, to ngat hera pat mang karo rhek ruk endruk. ");
INSERT INTO sua_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","To ngat kaekeknik kngae to kpis khavaeng o aposel ruk loktiek hori orom atgiang kar nglenar akuruk kat mang o tgoluk ruk ngat pis kim mar. ");
INSERT INTO sua_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ii, lraip ruk e Maria to nkong mMagdala, e Yoana, va e Maria to e Yesus knan va ngarlenar akuruk kat, her mar ruk arhe ngata havaeng o aposel mang o tgoluk ruk endruk. ");
INSERT INTO sua_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","O aposel ngta ngan ngaro rhek ruk tok, vanangko ngat lo kor mnam mar mang lraip ruk endruk ngaro rhek e, ekam ko ngata pat re te, ngaro rhek ngat kaeti lveve.  ");
INSERT INTO sua_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ngta pat tok, vanangko e Pita, ta le gia hop he ksap ngok pe Yesus ka nnak. Tpis he keep kam vaik ogun, va her gi vokong o it ngo vgondik ruk ngat kokomor e Yesus ka mnes orom mar ko tgi vavaom mar he ngta kru mar tuk ko tok. To ther kaeknik kngae he kaelha kam moruo kun mnam en mruo te, “Ai, o tgoluk ri ngat ngae vle nngia ti e?” ");
INSERT INTO sua_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Gi mnam a kolkha to kat gi, e Yesus klo kaloyie aloruk ngint kaikkiem a ngaelaut kam ngae mEmeus ko tvur vle malhagenmok mang e Yerusalem. ");
INSERT INTO sua_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ngint kaikkiem a ngaelaut va kaelha kmo rere kar min mang o tgoluk ruk endruk ngat papagis he. ");
INSERT INTO sua_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nginta hivuo kam mo rere kar min mang o tgoluk ruk endruk tok, to e Yesus mruo ther gi pis he ka knaek ekmin, ");
INSERT INTO sua_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","vanangko nginta kerruong ko E Nut tngam slommok pum nginalo keik. ");
INSERT INTO sua_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","To tpe gia mnganang ngin te, “He met vua mo rere kar mae mang anito mo ekam a ngaelaut?” Nginta ngan a mngan to tok, to ngint her gia sir, to hera him nginalo ktiek. ");
INSERT INTO sua_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","To langto mnam min, endo ka munik e Kliopas ta mnganang te, “Nok pathe yin atgiang to a gi gunmhel mo mYerusalem ko yi lua mnor mang o tgoluk ruk ngat papagis kun mnam o kolkhek ruk endri?” ");
INSERT INTO sua_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Va ther koripang ngin te, “Oni tgoluk ruk?” Va ngint koripang te, “He o tgoluk ruk ngat papagis kim e Yesus to nkong mNasaret. Ko en a propet to E Nut ta ngatkal mang kam khenam ka serppak vgum karo vu reha va karo vu rhek ruk lserpgue. He o mia ngma ngatkal mang ngar gi enang tok kat. ");
INSERT INTO sua_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Vanangko o pris ruk laol va o Yuda Ngar Ke Murgun to orom ngalmialaol, endruk ngma vongnek kim o rhek, ngat kle va kael ko maktiegom lRom to mar ngat her el, ngar kmim kngam a yoror. He ekam tok, ngata krong orom o ot kvat engnang a ho. ");
INSERT INTO sua_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Va mor vat, mor ruk ngot kor mnam mor mang en, ngot le ka nho mkor te, her en to tpis kam sulgim mor lIsrael he khong ngor petgim nguaro imuo arhe. Vanangko tete, tlua nho tok e, ko ther yor he, he kmanker ko o kolkhek ruk korlotge ngat nop ko ngat her el he. ");
INSERT INTO sua_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Vanang molenar ruk lraip ngat hop halki ngok pum ka nnak he kpis kreimsor ngang ngor kam havaeng ngor te, ngat lo pis mang ka mnes ko e. Va kat, ngat kta havaeng ngor te, E Nut tpis kim mar orom kalo engyel ko ngint havaeng ngar mang te, tkat ktal kat he. ");
INSERT INTO sua_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","To ngorlenar akuruk vat, ngta kle kngae ngok pum ka nnak kat, ngat pis gi kta vokom enang tok ge, ko lraip ngat havae mang tok, nang en mruo msim ngat lo vokom e.” ");
INSERT INTO sua_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Alo mhel ri nginta havaeng e Yesus mang o tgoluk ruk tok, to e Yesus ta havaeng ngin te, “Nngia ormae, nok melalo lpek nginta tok, ko mem vua hus kmor mnam mae mang o rhek ruk mkor o propet ko ngta ktar kpavap ormar te, ");
INSERT INTO sua_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Endo E Nut Thim Orom Ka Msasaen nak lol o vnek ruk endruk ktar na, to endo yek, en tkais kam le ktuur mnam E Nut ka tavgo.” ");
INSERT INTO sua_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ta re tok, to tkaelha kam halger E Nut karo rhek tgus ruk ngat ittiegom mar kam ktar kpavap mang en mruo. Ii, tkaelha orom e Moses karo rhek kam ngae krum mar orom o propet tgus ngartaro rhek kat kam halger mar mang en mruo tok. ");
INSERT INTO sua_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Thalger E Nut karo rhek ngang ngin kam ngae ekam a ngaelaut to ngta konner a rengmat to e Emeus va e Yesus tre kam lapsa kam ngae vop ");
INSERT INTO sua_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","vanang ngint kaur kim lserppak te, “O, ta re kam slok he, he ngia kaikkiem muo he ka vle mo kmuo na.” To ta ngan vgum min to her kaikkiem min. ");
INSERT INTO sua_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ngat pis korsang ko vanam a psen kam her kaemik, to thera kol a ngaemik, he kanprim E Nut mang, to kommen to re kmis kim min ");
INSERT INTO sua_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","va vgum e Yesus ko E Nut thera pet a slommok petgim nginalo keik, to ngint hera vokom kam mnor yek. Nginta mnor mang tok, to ther gi loloong ko pum nginalo keik. ");
INSERT INTO sua_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","To ngint hera mo havaeng ngin mruo te, “Lmien hak he, a mhel to enda thalger E Nut karo rhek ngang nguo ko ekam a ngaelaut, va karo rhek ngat ho mi kut heter mualo ngaung hak.” ");
INSERT INTO sua_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","To nginta hop to le kat kaeknik ngok mYerusalem ngatngae. Nginta ngae kpis mang o aposel ruk loktiek hori orom atgiang kar ngarlenar akuruk ko ngta kaum ko kmar. ");
INSERT INTO sua_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","To ngata havaeng ngin te, “Ho mi kut lmien hak he te, Ngoldaip tmi hop petgim ka nnak he, he tmur khenam ngang e Saimon.” ");
INSERT INTO sua_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ngat havae tok, to ngint kaelha kam havaeng ngar kat mang ko ngint kaikkiem a ngaelaut to kam ngae mEmeus he o tgoluk ruk endruk ngta pis kmin ko tok. Va nginta havaeng ngar mang ko nginta vokom e Yesus kam mnor mang ko tkommen a ngaemik kat. ");
INSERT INTO sua_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","E Yesus kalngunes ngata hivuo kam rere kngae mang en tok, va vgum e Yesus ko ther gi mur kat khenam kam her gi pis sir kar mar. Tpis enang tok, to kaenpaeim mar te, “Vae, mu sim vle orom a vrek longeik na.” ");
INSERT INTO sua_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ngata vokom tok, va ngaro pkor ngat ngae ho mi kut rres tgus va ngat ngae sei kam gor ko ngta pat re te ngata vokom a ngomiem tang. ");
INSERT INTO sua_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","To ta kner mar te, “Mguak or kam kta lopumtang pmok va kgorang dok e, ");
INSERT INTO sua_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ko a ngomiem nop ka mi mit kar karo sogi ngang msim e. Va dok ko muta vokom dok mut mia vokom kua mi mit kar kuakro sogi msim, ngola? He mu aol ehang kualo ktiek va kua lo nhar na, muk kam vokom o ot ngaro ngaekmol kam mia mnor te, her dok msim ta arhe.” ");
INSERT INTO sua_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ta re tok knop, to hera khenam kalo ktiek va kalo nhar ngang ngar. ");
INSERT INTO sua_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Vanangko mar ngat lo kael ngaro pat lserppak kmor mnam mar mang en vop, ekam ko ngate sei kam mrua sor kmar va ko a sirei ta ngorom mar kat. Va ekam ko ngata lopumtang pum vop, e Yesus ta mnganang ngar te, “Yu! He mut lo el o ol akor kmemik ge?” ");
INSERT INTO sua_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","To ngat her kaen a slang to ngat silat ngang ");
INSERT INTO sua_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","to thera kol to her gi kaem ko pum ngakro kerok. ");
INSERT INTO sua_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tkaemik knop, to hera rere kar mar kam havaeng ngar te, “Tiok ko koma vle kar muk vop ko her havaeng nguk tesgun he te: O rhek ruk kun mnam E Moses karo pos va O Propet Ngaro Rhek va O Knituk kat ngak kaottam he kael mit ormok arhe.” ");
INSERT INTO sua_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Thavaeng ngar tok, to le kpet a slommok pum ngaro kerok mar kam mmok mang E Nut karo propet ngaro rhek. ");
INSERT INTO sua_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tpet a slommok orom karo rhek ri ko thavaeng ngar te, “O rhek ri arhe ngat ittiegom mar kun mnam E Nut karo rhek te: Endo E Nut Thim Orom Ka Msasaen nak lol o vnek he khop petgim ka nnak kopekam o kolkhek ruk korlotge. ");
INSERT INTO sua_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","He ekam tok, kalngunes ngak kaelha mo mYerusalem kam polger o rhek orom e Yesus ka munik kam havaeng o mia te, ‘mguak kaitgung mularo kerkeknen he E Nut nera lol mar patgiang ngaiting.’ ");
INSERT INTO sua_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ii, mguak kaelha kam ngae kpolger o rhek tok ko her muk ri arhe mut mi vokong dok ko o rhek ruk endri ngat el mit ormok ko pum mularo kerok mruo. ");
INSERT INTO sua_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","He ekam tok, ngora meng E Nunu A Totur ngte kmuk, ekam ko E Titou mruo tel ka tnangal mang, En kam meng tok. Vanang mgua gia vle mo mnam a rengmat ta na, kais ko en nak pis he kaenserpagam muk orom ka serppak to nera komor muk.” ");
INSERT INTO sua_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ngata vle ko tok, to e Yesus thera ktong ngar ngok petgim e Yerusalem he vrua ngae kpis ko rkieng a rengmat to e Betani. Ko tok, thera hover kalo ktiek malpgem mar to hera ngamyammok mang ngar. ");
INSERT INTO sua_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ta hivuo kam ngamyammok mang ngar tok, to ther gia polok petgim mar kam grap ngpalmai ngoguon ma volkha. ");
INSERT INTO sua_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ta ngae tok, nang ngat her gia vle ko he ktotu pum. Ngata totu pum knop, to ngat her kaekeknik ngok mYerusalem orom a sirei to alautar. ");
INSERT INTO sua_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","To ko tok ngat her gia vle kun mnam E Nut ka maksien kam vle her gia kanprim mekam mekam ko he. ");
INSERT INTO sua_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tesgun ko a mmie tlo pal vop, va Endo ngat kilegem te, E Nut Ka Re ta ktar vle he. En nma vle ko kim E Nut mruo, va En tho mi kut kaenang E Nut msim hak. ");
INSERT INTO sua_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ii, her a papat to arhe te, tesgun ko a mmie tlo pal vop, va Endo ngat kilegem te, E Nut Ka Re, tkut vle ko kim E Nut. ");
INSERT INTO sua_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","He enang tok, Endo ngat kilegem te, E Nut Ka Re tkaum kar E Nut kam kueng o tgoluk tgus, nang nong a tomhel tang hak to tpal, ko en tlo kueng e. Nop hak! Ko o tgoluk tgus ruk ngat pal, Endo ngat kilegem te, E Nut Ka Re tkaum kar E Nut kam kueng ngar tgus. ");
INSERT INTO sua_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ii, va a ktalhok to kam plong vle ko kim E Nut ngnik ngnik tottek ekam Endo kat. Va a ktalhok to endo ta vle kat te, her a mmok ka pun msim to kam valler o mia tgus arhe. ");
INSERT INTO sua_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ii, a mmok ka pun to en, ta valler a slommok va a slommok tho lo kais hak kam kir kim e. Ii, Endo ngat kilegem te, E Nut Ka Re thera vle te, a mmok ka pun tok arhe! Va o slomkor ngam lua mmok mang kam mnorvek e.” ");
INSERT INTO sua_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Vanangko ktar mang ko a mmok ka pun to endo ta pis, E Nut thera khenam a mmok ka pun to endo ngang kalkayie langto ka munik e Yoanes. Ta khenam ngang e Yoanes tok, to her kle kmeng, en kam ktar kpavap mang a mmok ka pun to endo ngang o mia, he nang mar kmor mnam mar mang he kmokpom kar gi vgum en tok arhe. ");
INSERT INTO sua_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Vanangko e Yoanes, en mruo, ho nong a mmok ka pun to endo msim ta mur havae mang e. Nop gi! En tgia pis kam gi ktar kpavap mang a mmok ka pun to endo. ");
INSERT INTO sua_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Vanang a mi mmok ka pun msim, endo kam valler o mia tgus, tennik ta re kam mia pis mo mmie he. ");
INSERT INTO sua_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kam ngae, to E Nut Ka Re ther mi kut pis he ka vle mo mmie, endo en mruo tkueng. Ii, pu enang ko her en arhe tkueng a mmie ta, vanangko o mia tgus ngat lo vokom kam mnor mang tok e. ");
INSERT INTO sua_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mare, ta mrua kaol kpis mo mnam ka mmie msim ko tkueng, nang kakro mia mruo ruk tel mar mnam, ngat lua ngatkal ngang en kam vle mo kmar e. ");
INSERT INTO sua_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Vanangko akuruk, ngta ngatkal ngang, he kor mnam mar mang ka munik he kmokpom kar. Va her endruk arhe ta tting orom mar, mar kam vle te, E Nut kles msim. ");
INSERT INTO sua_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Enang tok, ngat lo pis te, E Nut kles msim, ko ngat pal mnam ngakro usiel ruk ko mrek mruo e, kmikkiem a vlom ka papat ko ta svil kam hover ka ngausie ka munik e. Va ngat lo pis kat te, E Nut kles msim tok ko ngat pal kmikkiem a teit kar a nan ngina svil kat e. Nove! Ngat kle va ka vle te, mar E Nut kles msim gi ekam ko ngat mi pal mnam E Nut kta ngausie msim kmikkiem ka mur svil mruo ha. ");
INSERT INTO sua_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ii, Endo ngat kilegem te, E Nut Ka Re, en tmur ellik orom enang a mhel, he kael ka ngorsang mo pgeik kmor. Ngota vokong he keketar karo keknen ruk lyar hak, ko en E Nut Khal to ke tro to tottek kuo kim Kteit. Va ngota vokom te, en a ho minar hak va en nam ho mia ring ya mang o mia tgus kat. ");
INSERT INTO sua_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Va e Yoanes nma havae mang en arhe. Ko nma rere malpgem o mia kam havaeng ngar te, “Her en arhe, endo tesgun koma havaeng nguk mang te, ‘Nera knaek ekmok. En tsei kam laut kir kim dok ko her en arhe ta ktar vle tesgun he, ko kim E Nut.’” ");
INSERT INTO sua_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Va ka keknen to kam ring ya mang o mia, tngae sei mnam en mruo va tngae vle kia vul orom ko nma ngamyammok mang ngor orom ka keknen to endo. He enang tok nam sim ktua ring ya mang ngor he kngamyammok mang ngor mekam mekam orom ka keknen to endo. ");
INSERT INTO sua_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ii, E Nut ta ktar khenam karo pos ma mmok vgum e Moses. Vanang ka keknen to kam ring ya mang o mia va kakro papat ruk o minar ta khenam mar ma mmok tete, her vgum e Yesus arhe, Endo E Nut Thim Orom Ka Msasaen. ");
INSERT INTO sua_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Va nong a mhel tang hak to tvur vokom E Nut e. Gi khal to ke tro mruo, endo tsim kut vle kaenang E Nut va tsim kut vle ko vanam, her en tuk arhe tmur khenam E Nut ngang ngor orom ka keknen to kam ring ya mang o mia va orom karo papat ruk o minar. ");
INSERT INTO sua_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yu! Va e Yoanes karo mur rhek ri arhe endruk nma havae mang e Yesus orom mar. Ko mnam a kolkha langto o Yuda ngalmialaol ko mYerusalem, ngta meng o pris kar o Livai akuruk kam ngae smia mnganang e Yoanes mang en mruo. Ngta pis ko kim to ka mnganang te, “Ani mhel to yin? Endo E Nut Thim Orom Ka Msasaen her yindo arhe i o nop gi?” ");
INSERT INTO sua_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Va e Yoanes tlua tuvgom a re kim mar e. Te smia havaeng ngar lsir te, “Nong dok Endo E Nut Thim Orom Ka Msasaen e. Nop gi.” ");
INSERT INTO sua_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","To ngta mnganang kat te, “Nang yin erie gi? Yin e Elaisia?” Va e Yoanes ta klai ngang ngar te, “Nong dok e Elaisia kat e.” To ngata kta mnganang kat gi te, “Yin a propet to ngta ktar kpavap mang te, ner kaol ngte?” Va e Yoanes ta kta klai ngang ngar te, “Nong dok to kat e.” ");
INSERT INTO sua_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","To ngata reng te, “Te sim havaeng ngor na te, yin erie msim. Ko ngota svil kam smia kol a re tang ko vgum yin mruo, mor kmeknik orom he khavaeng endruk ngat meng ngor. Ngia mrua havae miik nngia e?” ");
INSERT INTO sua_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Va e Yoanes ta hop ku to krere ngang ngar orom e Aisaia karo rhek kam havaeng ngar te, ‘Dok a mhel to kua vle ko ma kalputmok he khavaeng o mia mang ngaro kerkeknen te, ‘Muak verang a ngaelaut ekam Ngoldaip, Endo E Nut Thim Orom Ka Msasaen.’” ");
INSERT INTO sua_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kam ngae, to o Yuda ngalmialaol ngat meng o Parisiau akuruk ngok kim e Yoanes. ");
INSERT INTO sua_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ngata pis ko kim he kta mnganang te, “Enang ko lmien te, nong yin Endo E Nut Thim Orom Ka Msasaen, va nong yin e Elaisia va nong yin a propet to e Moses ta ktar kpavap mang te, ner kaol ngte, vanang kman ko ima parrum o mia?” ");
INSERT INTO sua_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ngta mnganang tok, to e Yoanes tkoripang ngar te, “Dok koma parrum o mia orom a gi ye e. Vanang kun pgegom muk, a mhel langto ta sir ka vle va mum lua vokom kam mnor mang hak. ");
INSERT INTO sua_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ii, kua re mang her endo nera knaek ekmok arhe. Si kam hong kalo nhar nginalo ngausie mkor va klo vu eveep hak kam hong min e. En na mrua ppir mang en mruo, nang dok kmis kam hong min mkor.” ");
INSERT INTO sua_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","O tgoluk tgus ruk endruk, ngata pagis mnam a rengmat to e Betani, mnam a ye to e Yodan ka ngaiting to ngkun kuo ko tok ko e Yoanes nama parrum o mia. ");
INSERT INTO sua_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","To hop enang ngmo, e Yoanes ta vokom e Yesus ko tkaol ngok kim lsir, to ta re te, “Mu vokom a mhel to na, en tkaenang A Sipsip To A Sital To Kam Nngiar Ngang E Nut Orom. Ko en nak yor mang o mia tgus mo mmie ngaro kerkeknen, he ka gidiel na lul ormar, he nang E Nut kam lol patgiang ngaiting he kikiangae mang ngar hak. ");
INSERT INTO sua_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","A mhel ta, her endo arhe tesgun kua havaeng nguk mang te, ‘Nera knaek ekmok. En ka munik tsei kam laut kir kim kotang ko her en arhe ta ktar vle tesgun he ko kim E Nut.’ ");
INSERT INTO sua_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tesgun dok mruo klua mnor mang en te, en Endo E Nut Thim Orom Ka Msasaen e. Vanangko tete, kua ngaeha to kam parrum o mia, endo ko kaol ngte kmeharom, ka pun ta vle ti te, kam her mi ktua polger En ma mmok tok arhe ngang lIsrael.” ");
INSERT INTO sua_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","E Yoanes thavae tok, to le kta havae orom karo mur rhek ri kat te, “Kua ngaeha ka pun ta mmok ngang dok tete yek, ekam ko ko her vokom E Nunu A Totur ko ta vo ka grung kun kuon ma volkha enang a ngaining to a giu ko tpis kar kuon malpgem. Va dok ngua lo is kam mnor mang tok, gi enangthe Endo tmeng dok kam parrum o mia orom a ye, na lua ktar kpavap ngang dok mang te, ‘Ngiak vokong E Nunu A Totur ko naka grung kun kuon he kar kuon malpgem a mhel tang, va her en a mhel to arhe, endo nera parrum o mia orom E Nunu A Totur ka munik.’” ");
INSERT INTO sua_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ko mur vokong gi enang tok, to her le smia mnor mang yek. He enang tok, kua le khavaeng nguk kat te, “A mhel to enda, her en E Nut Khal msim to arhe.” ");
INSERT INTO sua_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","To hop enang ngmo, ta kta vle kar klo kaloyie aloruk, ");
INSERT INTO sua_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","va kvokong e Yesus ko tkaol kre kotter mar, to e Yoanes ta le kta re te, “Mu vokom a mhel to na, en tkaenang A Sipsip To A Sital To Kam Nngiar Ngang E Nut Orom.” ");
INSERT INTO sua_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","E Yoanes klo kaloyie nginta ngan ko ta re tok, to ngint her kaelha kmikkiem e Yesus mnam a kolkha to endo gi. ");
INSERT INTO sua_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","To e Yesus ta nho knaek va kvokom min ko ngint kaikkiem, to ka mnganang ngin te, “Meta riring erieto?” Va mint le ka mnganang te, “Rabai, ima vle tamrie?” (To kam hortgem a munik to e Rabai ka pun ta vle te, “A Pattermia”.) ");
INSERT INTO sua_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Va e Yesus tgia reng ngin te, “Meak kaol he mrua vokom.” Vanang ta vlemas he, to mint kaikkiem e Yesus va kpis kvokong ka mhe to nama vle mnam, to nginta vle ko kim ma vlemas to endo. ");
INSERT INTO sua_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Vanang langto mnam ennginduk ko ta ngan e Yoanes karo rhek to kle kaikkiem e Yesus, ka munik e Andru. E Andru e Saimon Pita knopia. ");
INSERT INTO sua_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","To e Andru tngae klapsa kpis mang knopia e Saimon, to kle khavaeng te, “Ngot pis mang endo mor o Yuda ngoma mon te, Endo E Nut Thim Orom Ka Msasaen he.” (To kam hortgem a munik to te, “Endo E Nut Thim Orom Ka Msasaen” o Grik ngma mon te, “e Kristus.”) ");
INSERT INTO sua_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","To e Andru ta nglum knopia ngok kim e Yesus. To e Yesus ta vokom e Saimon to kreng te, “Ila munik e Saimon, va iteit e Yoanes, vanang tete kua kilegem yin te, e Sipas.” (To kam hortgem a munik to “e Sipas” ta vle te, “A kre”.) ");
INSERT INTO sua_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","To hop enang ngmo, e Yesus tel ka papat to kam ngae ngok mGalili. Ta ngae to puknim a mhel langto ka munik e Pilip, endo nkong mBetsaida, a rengmat to mkor e Andru kre Pita kat. To tvaeng te, “Aol he ikkiem dok.” ");
INSERT INTO sua_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","To e Pilip ta ngae kpis mang e Nataniel to khavaeng te, “Ngot pis mang a propet to e Moses ta ktar kpavap mang kun mnam E Nut kakro pos. Ii, her endo o propet tgus ngata ktar kpavap mang kat arhe. Ka munik e Yesus to nkong mNasaret va kteit e Yosep.” ");
INSERT INTO sua_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","E Nataniel ta ngnek tok, to kle kokheng e Pilip te, “Ai, nong a tomhel tang hak ko a vu yar tkais kam plek ko mNasaret e.” Va e Pilip ta le kreng te, “Yu! Yin he, aol he mur vokom orom ila lo keik mruo.” ");
INSERT INTO sua_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kam ngae, to e Yesus ta vokom e Nataniel ko tkaol ngok kim, to ta re te, “Mu vokong a mhel to na, en nam sim kut kaikkiem mor lIsrael nguaro keknen. Va nong a re tang ko a ppiagar ta vle kun mnam e.” ");
INSERT INTO sua_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Va e Nataniel ta mnganang e Yesus te, “Ya mnor mang dok nngia?” Va e Yesus tkoripang te, “Ktar mang ko e Pilip tlo vaeng in vop, ko ya vle ku me orom a ho to a pik, ko ktar vokom in he.” ");
INSERT INTO sua_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","To e Nataniel ta senkrip to le kreng te, “Pattermia, her yindo arhe E Nut Khal msim to in. Endo mor lIsrael ngua Taven msim.” ");
INSERT INTO sua_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","To e Yesus ta mnganang te, “Ngola, ye her kor mnam yin mang dok tok, gi ekam ko kua havaeng yin tete te, ‘Ko vokom in ko yi korsang ku meorom a ho to a pik?’ Vanang koknaik yek va ngira vokong o tgoluk ruk ngara pagis, ko ngara kir kim kua re to endo ko gi gnua havaeng yin orom.” ");
INSERT INTO sua_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ta re tok, to kle kpupam o mia tgus khavaeng ngar te, “Ii, ko smia mien ngang nguk te, mguera vokom o tgoluk ruk tok, ko a volkha nera mommenik va mguera vokom A Mhel To Nkong Man Ma Volkha to dok ko ngor gia vle enang a kaknang to E Nut karo engyel ngama grung ka grap ekam.” ");
INSERT INTO sua_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","To ko pekam o kolkhek ruk korlotge, o mia ngat kaem a pnes to kmenkim lraip ogu mKana kun mnam a mmie ka mhe to e Galili. Va o guliel ngata gun ko tok kam mari. Va a pnes kteit msim tvae mang E Yesus knan kar e Yesus va kalngunes kat mang a ngaeha to endo. ");
INSERT INTO sua_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tie palngaem o mia ngat kaemik kngae, to a ye to a vaen te ktu kim o guliel, to e Yesus knan ta havaeng te, “A vaen tnop he.” ");
INSERT INTO sua_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Va e Yesus ta reng knan te, “Kolkheng, ya havaeng dok tok, va klo is kam gia pis ma gi kirtang orom kua ngaeha e, ekam ko kua kolkha tlo pis vop.” ");
INSERT INTO sua_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Vanangko e Yesus knan ta ktua reng a pnes kaortek gi te, “Mgua gi kaikkiem ka ni re ngang ko na havaeng nguk orom.” ");
INSERT INTO sua_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Vanang o Yuda ngam sim kut kaikkiem nga keknen to kmelel singni na, yek kaemik. Va o itok ngo kolhi ruk aktiek hori orom agitgiang, endruk ngat hong ngar mnam o krek ngam kainir ogu pmar ngata vle ko rkieng ngar ko tok ko ngata gun. Va akuruk mnam mar ngat kais kminiram a ye pum mar kmis mang o lita ruk 75, nang akuruk kam grap kais mang o lita ruk 115. ");
INSERT INTO sua_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","To e Yesus thera reng a pnes kaortek te, “Mu iniram a ye ogu pum o kolhi ri na.” To ngat kainir ogu pmar va ngat ngae gi riprip kuo vgum ngakro ngnorok. ");
INSERT INTO sua_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","To ta le kreng langto mnam mar te, “Pir pum a ye to, he kol ngorom en ngang a pnes kteit msim.” To ta pir pum a ye to le kaen ngang. ");
INSERT INTO sua_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","A pnes kteit msim tkol a ye to e Yesus thortgem he el en a vaen to kaegom. En tlo ptang ko e Yesus thortgem e. Vanangko a pnes kaortek ngata mnor mang ko ngat pir pum a ye he en ngang. To a pnes kteit msim thera vaeng a ngokol to te gnua lei petgim klenar, to kanprim ");
INSERT INTO sua_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","te, “O mia tgus ngama ktar ka nngiar orom a vaen to a mgaer ngang o guliel, mar kmivie kveve na, to koknaik ngama nngiar orom a vaen to tlua mgae. Vanangko yin, ye her kier mang a vaen to tvua mgae hak kais mang tete ge.” ");
INSERT INTO sua_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Enang tok, e Yesus ta pakvom kam khenam karo ngaelmir ruk lserpgue ma mmok, ko tok mKana kun mnam a mhe to e Galili orom ka ngaelmir to a serpgar to yek. He ko tok mKana, E Yesus tkaelha pum kam mrua polger ka serppak orom a ngaelmir to a serpgar to endo enang tok. He ekam tok, kalngunes ngat her le sim kor mnam mar mang he kmokpom kar. ");
INSERT INTO sua_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","To ko pekam a ngaelmir to a serpgar ko e Yesus teharom ko mKana, e Yesus kar knan, va kaornopeik, va kalngunes ngat hera ngae ngogu to kpis ko mKaparnam. Ngat pis to gia vle ko tok mnam o kolkhek lgititge. ");
INSERT INTO sua_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","To rkieng ko o Yuda kam kunngir kim a pnes to ngama mon te, A Pnes To A Engyel Tvarpaam O Yuda Ngaro Molpou, e Yesus ta ngae ka grap ngoguon mYerusalem pa pnes to kat. ");
INSERT INTO sua_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ta ngae kpis ko tok, to kvaik kun mnam E Nut ka maksien ka mhe to ko ma gi vle. Ta vokom o mia ko tok ko ngata gun orom ngaro iningol ruk o giu va ngaro bulmakau va ngaro sipsip ko ngat elik, o mia kmenen kmar mkor mar. Va ta vokom o mia akuruk ko ngat korosang ko mo psen he kmopatap orom o krek ruk mkor a maksien to endo orom o vrong rhek ngakro mur krek. ");
INSERT INTO sua_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tvokom mar tok, to kvuum o usiel to le kekerer o mia orom kun mnam a maksien ka mhe to ko ma gi vle. Si o bulmakau va o sipsip va ta kekerer mar kat. Ta kerer mar knop, to le kseneker o krek ruk ngma mopatap orom mar, to le klelget ngakro psen kat. ");
INSERT INTO sua_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Teharom tok, to le kreng endruk ngam kael o giu, o mia kmenen kmar te, “Mguak lol mulakro tgol ri tgus he kngae petgim a maksien ta. Mguak or kam lol o klel orom E Titou ka maksien he khortgem kam vle te, a gi mhe to kmel o vrong tgoluk kam lol o krek orom.” ");
INSERT INTO sua_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Va kalngunes ngat her gia vokom e Yesus ko teharom tok, to kpat mang E Nut karo rhek ruk tennik o propet ngat her ittiegom mar kam ktar kpavap mang te, “Kua vrek ta sovet kam matmat dok mang ila maksien, enang a paei ko nama sovet mang a ho kmem tok kat kngorom.” ");
INSERT INTO sua_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","To o Yuda ngalmialaol ngaro vurkul ngta kiin, to ngat kaeknik ngok kim to kpis kam mnganang te, “A ni ngaelmir to a serpgar ngiak khenam ma mmok ngang ngor, mor kam vokom ila serppak he smia mnor mang in te, E Nut thim yin orom ka msasaen, he nang yin kmeharom tok?” ");
INSERT INTO sua_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Va e Yesus tkoripang ngar te, “Enangthe mupa rum kim a maksien ta, va dok ngor le kta hover kun mnam o kolkhek ruk a korlotge kat.” ");
INSERT INTO sua_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Va o Yuda ngalmialaol ngat le ka mnganang e Yesus te, “Hai-e! Ngolmialaol ngat eha mnam o pnes ruk alo mhelom va aktiek hori orom atgiang kam hover a maksien ta, va yin yi kais gi kam kta hover a maksien ta mnam o kolkhek ruk a gi korlotge kat?” ");
INSERT INTO sua_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngata mnganang tok, vanang ngat lua mnor mang e Yesus ka re ta, ko a re to te, “a maksien” ko ta rere mang, ta mrua rere mang ka vok mruo. ");
INSERT INTO sua_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","To koknaik mnam a kolkha ko ta hop petgim ka nnak, kalngunes ngata pat mang ka re ta ta rere orom, to ngat le kor mnam mar mang e Yesus karo mur rhek ruk endruk tok, va mang E Nut karo rhek ruk ngat ittiegom mar tennik kun mnam E Nut Ka Meer. ");
INSERT INTO sua_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kam ngae, to e Yesus tkaeharom o ngaelmir ruk lserpgue ko tok mYerusalem ko ta vle ko pa pnes to endo vop. Va o mia ngarlatgep ngat mrua vokom mar enang tok, to her kle gi kor mnam mar mang ka munik he kmokpom kar kat. ");
INSERT INTO sua_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Vanangko e Yesus tlo kaungtu ekam a mhel tang hak kam vat engnang ko ther mi kut mnor hak mang o mia ngaro keknen tgus he. ");
INSERT INTO sua_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Va nong a mhel tang kat to tkais kam polger o rhek ngang mang o mia kat e, ko en mruo ther ktar mur mnor mang ngakro papat kun mnam mar he. ");
INSERT INTO sua_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Tie ma segain langto a mhel to ka munik e Nikodimas tkaol kpis ngok kim e Yesus. En a Parisiau langto nma kaum kun mnam o Yuda Ngar Ke Murgun to nma vongnek kim o rhek. Tpis ko kim to kreng te, “Pattermia, ngota mnor miik te, her yin a pattermia langto E Nut tmeng in ngte. Ngota mnor tok, ekam ko enangthe E Nut na lua vle kar a mhel, va en tlo is kmeharom o ngaelmir ruk lserpgue ruk im kaeharom mar e.” ");
INSERT INTO sua_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Va e Yesus tkoripang te, “Kua mien te, a gi vrong mhel tang tlo is hak kam vle ku meorom E Nut ka tavgo e. Gi enangthe E Nut tkuon ma volkha naka ktar kaeharom a mhel ta te, en a mhel to a gunngar na, he nang en kam pal mnam E Nut ka ngausie ka pun msim enang tok, to endo yek ther kais kam vle ku meorom E Nut ka tavgo tok.” ");
INSERT INTO sua_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","E Nikodimas ta ngan tok, to kle ka mnganang e Yesus te, “Na ngae ktua nho nngia ngang a mhel to tlaut he, E Nut kam kta kueng kat he en kam pis te, en a mhel to a gunngar? Ko a mhel tang tlo kat kais kam kta vaik ogun mnam knan ka vrek he knan kam kta kol kat e!” ");
INSERT INTO sua_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Va e Yesus ta havaeng te, “Ii, enang ko ko havae, kua mien te, a gi vrong mhel tang tlo kais hak kam vle ku meorom E Nut ka tavgo e. Tgi kais mang ko naka ktar pal mnam E Nunu To A Totur ko nak parrur kun ma ye orom ka munik, to tkais. ");
INSERT INTO sua_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ii, ko a mhel to ta pal mnam knan ka ngausie ka pun vanie. Vanang a papat to a ngaenpaeir ta vle te, a mhel nak pal mnam E Nunu A Totur. ");
INSERT INTO sua_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","He ekam tok, ngior kam senkrip kim kuaro rhek ruk kua havaeng in ormar te, ‘E Nut na kat kaeharom o mia tgus o gunngae orom E Nunu A Totur ka munik tok arhe.’ ");
INSERT INTO sua_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ya mnor mang a ngausgi ko nam gi vrong pis he kovvor o vrong tgoluk. Im gia ngan ka muktim, nang im lua vokom kam mnor te, ta pis tam va kngae ngam. Gi enang tok, E Nunu A Totur ta vle enang a ngausgi tok kat arhe ko o mia ruk E Nut ta ktar kaeharom mar te, mar o gunngae, o mia ngat lo is kam vokom E Nunu A Totur, ko ngat pal mnam en enang tok kat e.” ");
INSERT INTO sua_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","E Nikodimas ta le kta mnganang e Yesus te, “O rhek ri ngak pis va ka vle nngia?” ");
INSERT INTO sua_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Va e Yesus tkoripang te, “Ngola, yin ima patter lIsrael, va yi lua mmok mang o rhek ri gi? ");
INSERT INTO sua_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kua mien te, tesgun ngom sia rere mang o tgoluk ruk mor mruo ngot mur mnor mang ngar, va ya havae lmien mang E Nut karo reha ruk ngot mur vokong ngar kat, vanang nong tang mnam muk nama svil kam lol nguakro rhek ge. ");
INSERT INTO sua_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Vanang mu vokom na, ko hera ktar khavaeng nguk ruk lIsrael mang o gi vrong tgoluk ruk mo mmie, va mum lo kor mnam muk mang dok ge. Nang nngia ngang nguk, enangthe kop le khavaeng nguk mang o tgoluk ruk kuon ma volkha vat? ");
INSERT INTO sua_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","A mhel tang tlo grap ngoguon ma totummok vop. Gi en tuk, endo A Mhel To Nkong Man Ma Volkha to dok ko kua grung kun kuon ko tok, ma totummok. ");
INSERT INTO sua_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ii, her A Mhel To Nkong Man Ma Volkha to dok arhe E Nut ta ktar mur el ka pat to mang dok te, o mia ngak hover a ho orom dok, gi enang e Moses ko ma kalputmok ko thover a ho to orom a vim ka nunu tok kat ko ngat eharom orom a kre to ngma mon te, a bras. ");
INSERT INTO sua_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ii, ngara hover dok tok. He ekam tok, endruk tgus ruk nga le kor mnam mar mang dok he kmokpom kar dok, mar o mia ruk ngara kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik. ");
INSERT INTO sua_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ii, E Nut ta ktar mur re kam hover dok tok, ekam ko ta ngae sei kmelongtok mang o mia ruk mo mmie. Ther mi kut svil mang ngar tok, to her mur el khal to ke tro mruo to dok he, ko maktiegom o mia, mar kam hover a ho orom dok tok. Va endruk ngat kor mnam mar mang dok he kmokpom kar dok, her mar ruk arhe ngara kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik. Nang ngat ho lo is hak kam kol a kapnes ko ma kernonhommok petgim e. ");
INSERT INTO sua_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ii, ngara vle tok, ekam ko E Nut tlo en khal mruo kam pis mo mmie kmel o mia kam kol a kapnes tok e. Nove! E Nut ta kle mur en khal mruo kam pis mo mmie, he nang E Nut kam susulgim mar vgum En. ");
INSERT INTO sua_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","He ekam tok, ani mhel to nak kor mnam en mang E Nut Khal te, lmien mang te, En E Nut Khal to ke tro msim enang tok he kmokpom kar, va a mhel to endo E Nut ner lo kael en kam kol a kapnes e. Vanang ani mhel to na lo kor mnam en mang E Nut Khal tok he lua mokpom kar, va thera vle ngang tete te, E Nut ther mi el a mhel to endo he, en kam kol a kapnes to endo mkor tok. ");
INSERT INTO sua_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","E Nut ther el ka papat ngang o mia ruk endruk te, A mmok langto ther mi pis mo mmie he, vanang o mia ngam kle va ka svil mang a slommok. Ngam lua svil mang a mmok, ekam ko ngama svil kmeharom ngaro kerkeknen. ");
INSERT INTO sua_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ii, va ani mhel to nam kaeharom o kerkeknen nama kees kam vle kun mnam a mmok to endo, ekam ko nma gor te, a mmok to endo nera valler en orom karo kerkeknen ruk endruk he kaelik ma mmok. ");
INSERT INTO sua_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Vanang ani mhel to nam sim kaeharom o keknen ruk lyar, endruk o minar, nam mrua vaik kun mnam a mmok to he, a mmok kam valler karo keknen ma mmok, he o mia ngam smia mnor mang te, tkaeharom o keknen ruk endruk mkor E Nut.” ");
INSERT INTO sua_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","To kopekam o kolkhek akuruk, e Yesus kar kalngunes ngata ngae ngok ma ngaendapgeik langto ko mYudea. Ko tok, ta kaum ka vle ko kmar mo kolkhek akuruk he kparrum o mia. ");
INSERT INTO sua_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Vanang e Yoanes nma parrum o mia kat ko mInon ko rkieng a rengmat to e Salim. Va o mia ngama veet ngok kim, en kam parrum mar ko tok, ko o itok ngarlatgep ko mnam a mhe to endo. ");
INSERT INTO sua_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ii, e Yoanes nam kaeharom tok, ktar mang ko ngat lo el kun pa hengor vop.) ");
INSERT INTO sua_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","To e Yoanes kalngunes akuruk ngat kaelha kam maen o rhek kar a mhel langto mang ngar ruk o Yuda nga keknen to kam parrum o mia. ");
INSERT INTO sua_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","To ngata ngae ngok kim e Yoanes va khavaeng te, “Pattermia, a mhel to ya ktar kpavap mang, endo tesgun ta vle ko kmin ko mnam a ye to e Yodan ka ngaiting to ngkun kuon kat, a mhel to, o mia ngma veet ngok kim he nma parrum mar kat.” ");
INSERT INTO sua_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","To e Yoanes tkaekon ngang ngar te, “A gi vrong serppak tang ko a mhel tkol, nam her kol her vgum E Nut to arhe. ");
INSERT INTO sua_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Muk mruo mut her ngan dok tesgun he, ko koma klai mang dok te, ‘Dok nong Endo E Nut Thim Orom Ka Msasaen e.’ Ii, kom kle mrua havae mang dok te, ‘Dok a gi mhel to naka ktar mang en.’ Ii, ko dok ko gia vle enang endo ta gnua lei kaela msim, ");
INSERT INTO sua_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ko enangthe a ngokol npa lei orom a vlom, va a vlom tgia vle te, ktavlom to. Vanang a ngokol to tlei, va kaela msim naka ktar mang kam sir ekam a ngaelaut kpaneng, en kam puknim ko nak kaol orom ktavlom ko ngint lei he. Naka vle kpaneng to nak ngan a ngokol ka ktui ko nak rere, to ner re ksei kam sirei alaut gi, ko tngan ka ktui. Ii, va dok kat kua vle enang a ngokol to tlei kaela to endo tok, ko tete koma sei kam sirei gi enang tok kat ko kua sirei ther mia pis orom endo he. ");
INSERT INTO sua_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ii, va kmaottam E Nut ka ppat to mang en, her endo arhe o mia ngak hover, nang dok ngua kle mrua krus orom dok mruo ha. ");
INSERT INTO sua_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","34","Ii, dok ngua kle mrua krus orom dok mruo ekam ko endo tottek kun kuon ma volkha ko E Nut ther meng, ka munik ta laut kir kim mor tgus ngortakor, ko her en arhe ta le kut kol E Nut ka gu kam rere orom E Nut karo reha ruk en mruo nam mrua vokong ngar va kngan mar. Vanang dok to ko ottek mo mmie, dok nkong dok mo mmie va kom kle gia rere mang o gi vrong tgoluk ruk mo mmie kat. Ii, enang ko ko havae, endo tottek man kuon ma volkha, ka munik ta laut kir kim mor tgus ekam ko nma rere lmien orom E Nut karo rhek mruo ekam ko E Nut nam lua tu kmen E Nunu A Totur ngang. Vanangko o mia kavurgem ngam lo kor mnam mar mang kakro rhek e. Vanang ani mhel to nam le kor mnam en mang kakro rhek ruk endruk, a mhel to endo nam kaenserpagam a papat to te, E Nut nma mien orom karo tnangal. ");
INSERT INTO sua_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ii, E Nut nam kaelongtok mang Khal mruo va her E Nut to tel o tgoluk tgus ko maktiegom En kat arhe. ");
INSERT INTO sua_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","He ekam tok, ani mhel to ta kor mnam en mang E Nut Khal to endo he kmokpom kar, a mhel to endo ther kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ko mkor E Nut he. Vanang endo ta kle va kerngnek vgum Khal he lo kor mnam en mang he lua mokpom kar, a mhel to endo ner ho lo kais hak kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ko mkor kat e. Tlo is ekam ko E Nut ka ngaesik ta vle kuo mang vop.” ");
INSERT INTO sua_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","O Parisiau ngata ngnek mang e Yesus te, o mia kavurgem ngta sovet kam gun ngok kim kir kim e Yoanes, he nang en kam parrum mar, nang mar kam vle te, kalngunes ruk mar. ");
INSERT INTO sua_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Vanang e Yesus mruo nam lo mrua parrum o mia e, gi kalngunes tuk ruk ngama parrum mar. ");
INSERT INTO sua_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","E Yesus tkol a re mang o mia te, ngma rere pum tok to ta ngae korim mar ko tok mnam a mhe to e Yudea to hera ngae kat kaeknik ngok mGalili ngok mrek. ");
INSERT INTO sua_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ta ngae kut kaikkiem a ngaelaut to ta ngae kpis kun mnam a mhe to e Samaria ekam ko E Nut ta ktar mur el ka pat to mang te, nak pis ko tok. ");
INSERT INTO sua_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ko tok mSamaria, ta pis ko mnam a rengmat to ngata mon te, e Sikar. A rengmat ta vle ko rkieng a mmie ka mhe to e Yakop ten ngang khal to e Yosep tennik he. ");
INSERT INTO sua_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ko mnam a mhe to endo a vugye to e Yakop kalngunes ngat hong ta vle ko kat. To e Yesus ta kapnes vgum a ngaelaut ko pkolkha he, to kpis korsang ko va vugye to endo. ");
INSERT INTO sua_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","E Yesus ta vle ko vgum a vugye, nang kalngunes ngat her ngae ngogu ma rengmat laut kmenenkim o ol ngang ngar. To a vlom langto nkong mSamaria tkaol kminir. Tre kminir va vgum e Yesus ko ta reng te, “Inir ngte he ko ivie na.” ");
INSERT INTO sua_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Va a vlom ta, ta reng te, “Yin nkong mYuda va dok nkong dok mo mSamaria, va kman ko ya reng dok kminir he yin kmivie?” (Ta re tok, ekam ko o Yuda ngam kaitgung o kolhi ruk lSamaria ngam kaehang ngar.) ");
INSERT INTO sua_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","E Yesus ta reng te, “Enangthe ipa mnor mang E Nut ka nngiar, va ipa mnor mang dok to kua mnganang in kmivie, va nok ip kle va ka mnganang dok va dok kop kaen a ye to tis kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang in.” ");
INSERT INTO sua_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","To a vlom ta ta reng te, “Kolaip, nop ka kolhi ngang in kminir o gu pum, va a vugye to enda ta vvuo, to ngia ngae kol a ye nngia? Va ngira kol a ye to tis kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik tamrie? ");
INSERT INTO sua_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ko her ngores to e Yakop arhe ten a vugye ta ngang ngor, va en kar kles va karo ngaemslang ngam kaivie mnam kat. Pathe yi vur laut kir kim e Yakop vor?” ");
INSERT INTO sua_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Va e Yesus tkoripang te, “Endo nam kaivie mo mnam a vugye ta, nam kta katngaivie kat. ");
INSERT INTO sua_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Vanang endo nam kaivie mnam a ye to kom kaen ngang, nam ho lo kta katngaivie kat e. Ii, lmien te, a ye to kom kaen ngang a mhel nera vle kun mnam en enang a vugye to nma gos he ka plul orom a ktalhok to kam plong vle ko kim E Nut ngnik ngnik.” ");
INSERT INTO sua_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A vlom ta ngnek tok, to le kreng e Yesus te, “Kolaip, klang dok orom a ye to, he nang dok kam lo kta katngaivie kat, va dok kam lo kta kanko ngte kminir mo va vugye ta.” ");
INSERT INTO sua_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Va e Yesus tkoripang te, “Ngiak ngae he kvaeng itngokol he kaeknik orom na.” ");
INSERT INTO sua_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Va a vlom ta, ta klai ngang e Yesus kam re te, “Nop katngokol ngang dok e.” Va e Yesus thera reng te, “Ye her mien kam klai va khavae te, nop katngokol ngang in. ");
INSERT INTO sua_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ko kua mnor mang in te, lmien ko tesgun ye her kerlei orom ilmialurokol ruk aktiek. Va si endo tete ya vle kar, nop itngokol to msim kat e. Ye ktar mur havae mang in lmien mruo tok arhe.” ");
INSERT INTO sua_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A vlom ta ta ngnek tok, to hera reng e Yesus te, “Kolaip kua tar yin ko yin a propet langto. ");
INSERT INTO sua_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mor o Samaria ngorores ngama ngarkie va ktotu pum E Nut kuon kim a vul mo arhe, vanang muk o Yuda mum kle va kokheng ngor he kre te, a mi rengmat to kam ngarkie va ktotu pum E Nut mnam her e Yerusalem arhe.” ");
INSERT INTO sua_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ta re tok, to e Yesus ta kle kreng te, “Ngiak kor mnam in mang kuaro rhek ri ko kua havaeng in te, koknaik ngia re vokom a kolkha langto ko nera pis he kle yek ngira kalpak kim a vul ta va a rengmat to e Yerusalem ko o mia ngar kais kam totu pum E Nut mnam o gi vrong mhetor tgus mo mmie, nang nong gi mnam alo mhe ruk enngindi tuk e. ");
INSERT INTO sua_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Muk ruk lSamaria mum lo smia mnor mang E Nut to muma totu pum, vanang mor o Yuda, ngom smia mnor mang he ktotu pum, ko E Nut ka ngaeha to kam susulgim o mia ka pun msim ther ottek ekam mor o Yuda ruk arhe. ");
INSERT INTO sua_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Vanangko ketasuo mang a kolkha to endo kam pis, ko kun mnam a kolkha to endo endruk nga smia totu pum Ngor Teit ngar mia totu pum orom ngaro papat ruk o minar, endruk E Nunu A Totur nam kaenkrovgem mar kam totu pum En ormar tok. Va lmien ko a kolkha to endo ther mi pis ormok tete he. Ii, endruk ngma totu pum E Nut tok, her endruk arhe E Nut nma svil mang ngar kam mi ktua totu pum En enang tok. ");
INSERT INTO sua_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ii, E Nut kar E Nunu A Totur min atgiang. He ekam tok, o mia ruk ngama svil kam mia totu pum En, nga mia totu pum vgum E Nunu A Totur enang tok.” ");
INSERT INTO sua_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A vlom ta, ta ngnek tok, to kle kreng te, “Kua mnor ko Endo E Nut Thim Orom Ka Msasaen, nak pis va mnam a kolkha to nak pis mnam, nera polger o rhek ngang ngor mang o papat tgus.” (A munik to te, “Endo E Nut Thim Orom Ka Msasaen,” o Grik ngma mon te, e Kristus.) ");
INSERT INTO sua_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","A vlom thavae tok, to e Yesus thera polger o rhek mang en mruo te, “Her dok ta arhe, ye mrua rere kar mo arhe.” ");
INSERT INTO sua_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tie ko e Yesus ta re tok, kalngunes ngat kaeknik kpis ngok kim, va vgum e Yesus ko ngat vokom ko ta rere kar a vlom to. Vanangko tang tlua mnganang te, “Ya svil mang anito?” I o ngat lua mnganang te, “Kman ko ya rere kar a vlom to?” ");
INSERT INTO sua_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","To a vlom ta, torim ka ye ka kolhi ko, to kle kaeknik ngogu mrek to kpis khavaeng o mia ko tok te, ");
INSERT INTO sua_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mu aol na, he vokong a mhel to thavaeng dok mang o gi vrong keknen tgus ruk ko eharom mar he. Pathe nok Endo E Nut Thim Orom Ka Msasaen vor?” ");
INSERT INTO sua_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","O mia ngat ngan karo rhek ruk tok, to mar tgus ngata parem nga rengmat to kveet kam ngae ngok kim e Yesus. ");
INSERT INTO sua_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Vanang phevgom ko o mia ngata veet ngok kim e Yesus, kalngunes ngata nanam kmemik te, “Pattermia ngia vur emik na.” ");
INSERT INTO sua_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Va ta koripang ngar te, “Pu o ol dok kmemik, endruk mut lua mnor mang ngar hak.” ");
INSERT INTO sua_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Thavae tok, to kalngunes ngat kaelha kam vur mo mamnganang ngar te, “Pathe ngot lo ptang ko a mhel tang ta klang mlol he temik vor?” ");
INSERT INTO sua_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","To e Yesus thera reng ngar te, “Kua ngaemik ta vle gi te, dok kmeharom o reha ruk Endo ta meng dok ta svil dok kmeharom mar kam tarkanang ngar hak. ");
INSERT INTO sua_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ii, mu vokom na, muk muma havae te, ‘Ngiak paal ko yi ngam a vui mnam ila loot mo kenho ruk korlolo vop to ngiak le ka lluol.’ Vanangko mu smia vokom E Nut ka loot to orom o mia na. Ko kua kle va khavaeng nguk te, o ol ruk orom o mia ko mnam E Nut ka loot ngta tettek he, va E Nut tgia vle kpaneng kalngunes kam lluol mnam. ");
INSERT INTO sua_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Si tete ta, ko ani mhel to nak lluol mnam a loot, va a loot kteit na kaenkim. Ii, va si tete, ani mhel to nma lluol mnam E Nut ka loot nam kaum o ol ruk orom o mia kmelpas ormar, he nang mar kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik. He enang tok, endo na kavang o ol va endo na lluol mnam a loot ngint kais kam kaum ksirei tgus. ");
INSERT INTO sua_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Va muk muma havae orom a re to a minar kat te, ‘A mhel langto nma kakap va langto nma lluol.’ Ii, mu vokom na, mularo rhek ruk endruk mar o minar, ");
INSERT INTO sua_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ko dok ko hera meng nguk kam lluol ko mnam E Nut ka loot to mut lo vur tuom singni mnam hak. Ii, o mia akuruk ngate ka prongyek ka psek pum ka loot to, nang muk mut gia ngae kam lluol ko mnam ngakro serppak.” ");
INSERT INTO sua_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","To ko tok mSamaria, o mia kavurgem ngat kor mnam mar mang e Yesus he kmokpom kar ekam ko a vlom to endo tngae khavaeng ngar mang te, “A mhel to ta havaeng dok mang o gi vrong keknen tgus ruk ko eharom mar he.” ");
INSERT INTO sua_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","To lSamaria ngat re kpis ko kim ko va vugye, va ngata nanam kam vle ko kmar. Va e Yesus ta vle ko kmar mnam alo kolkha lomin he krere kar mar. ");
INSERT INTO sua_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Va akuruk kat ko mar ngarlatgep ngat kor mnam mar mang en he kmokpom kar vgum karo mur rhek mruo kat. ");
INSERT INTO sua_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","O mia ruk endri ngat havaeng a vlom to endo te, “Ngot ho lo kta serppak mang ilaro rhek tuk kmor mnam mor mang he kmokpom kar En vgum mar tuk e. Nove. Ngot kle va kserppak mang karo rhek mruo ko ngot mur ngan karo rhek tete. He ekam tok, tete ngot her mi kut mnor mang he te, En her Endo Kam Susulgim o mia tgus ruk mo mmie arhe.” ");
INSERT INTO sua_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","To ko pekam alo kolkha alomin ko e Yesus ta vle ko mSamaria, tle kparem mar ko tok he kngae ngok mGalili. ");
INSERT INTO sua_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Vanang en mruo tmur hover a papat ta te, o mia ngam lua totu pum a propet ko mnam ka rengmat ka pun msim e.) ");
INSERT INTO sua_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tie ko ta pis ko mGalili, o mia ngata sirei kam vaeng ngok kmar. Ngta sirei mang tok ekam ko tie ko ngat ngae pa pnes to ko mYerusalem, endo o Yuda ngma mon te, A Pnes To A Engyel Ta Varpaam O Yuda Ngaro Molpou, ngat her ktar mur vokong karo reha ruk lserpgue, endruk teharom mar ko tok. ");
INSERT INTO sua_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kam ngae, to e Yesus tkat kaeknik ngok mKana kun mnam a mhe to e Galili, ko tok ko thortgem a ye he el en a vaen. Vanang a taven kalkayie langto, ta vle oguon mKaparnam, he ksia papat mang khal ko ta yayor. ");
INSERT INTO sua_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tre gia ngnek mang e Yesus ko tgun ottek ku mYudea he kngae ko tok to ta ngae ngok kim to kaurur kim kmeknik kngae ngok mKaparnam kmeharom khal ko ta re kam yor he. ");
INSERT INTO sua_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","E Yesus ta ngnek tok, to kle kpupam o mia tgus kam reng ngar te, “Mum smia ring ti, ngua sim kaeharom o ngaelmir ruk lserpgue va o reha ruk kam sor kmar ko pum mularo kerok, yek mguak kor mnam muk mang dok he kmokpom kar dok. Vanang enangthe ngua lo kaeharom mar tok, va muma kees kmor mnam muk mang dok he kmokpom kar dok.” ");
INSERT INTO sua_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ta reng ngar tok, to a taven kalkayie to endo, thera reng e Yesus te, “Kolaip, ikkiem dok na, matok ko hal na le yor.” ");
INSERT INTO sua_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Va e Yesus tgia reng te, “Ngiak ngae he, ihal tya.” A taven kalkayie to enda ther gia ngan e Yesus karo rhek ruk endruk to her gi lol lserppak kun mnam to hera ngae kngae ngok mrek. ");
INSERT INTO sua_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kam ngae, to ko ekam a ngaelaut kalngunes ngata puknim to khavaeng orom a re te, “Ihal tya.” ");
INSERT INTO sua_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","To ta mnganang ngar mang khal te, “Tkat ya tenngor?” Va ngat havaeng te, “Tenmo pkolkha a yor ta nop kuo mang.” ");
INSERT INTO sua_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","To a taven to enda, ta tar te, her gi kut tenmo ko pkolkha msim to arhe ko e Yesus thavaeng te, “Ihal tya.” He ekam tok, en kar ka valngan tgus ngat kor mnam mar mang e Yesus he kmokpom kar. ");
INSERT INTO sua_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Va e Yesus ka ngaelmir a serpgar to enda ta vle te, endo alomin orom teharom ko tok mKana, ko pekam ko ta kootpum ko mYudea he kngae ko mGalili. ");
INSERT INTO sua_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kam ngae, to o kolkhek kavurgem ngat nop ko e Yesus tkootpum ko mYudea he kngae ko mGalili. To ta ngae ngoguon mYerusalem mang o Yuda nga pnes langto. ");
INSERT INTO sua_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Va ko rkieng a rengmat to e Yerusalem ka ngaegot to ngma mon te, A Sipsip Ka Ngaegot, ke ngaenker langto ta vle endo ngama mon lHibru te, e Betesta. Ke ngaenker to endo ngat ngam a rek ka gi keik tuk malpgem orom o ngtek ruk aktiek. ");
INSERT INTO sua_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Va a mumu to klalaut orom o yor ngo mamten ngama kurkru kakleim karo ngaitngol. Endruk o vivisker, endruk ngma kernget, va o nharyor kat. Va mar tgus ngma paneng ke ngaenker to endo ko nam kael lili he ka grap, ekam ko ");
INSERT INTO sua_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","mo kolkhek akuruk ko Ngoldaip nma meng ka engyel langto kam grung he kaenpgam kmel lili enang tok. Va o mia ngama vokom ko nam kael lili enang tok, to ngama mamarer kam prik kun mnam. He ekam tok, a gi hi to nam kael lili, endo nma ktar ka prik mnam va ka ni yor to mnam, nam ho mi kut nop kuo mang ngatngae. ");
INSERT INTO sua_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","To a mhel langto kalo nhar ngint yor he ka vle tok kais mang o pnes ruk a mhelom va lo ktiek hori orom aktiek hori orom korlotge nma kru ko tok. ");
INSERT INTO sua_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","E Yesus ta vokom ko ta kru oguo mmie, to kol a re mang te, ta vle tok mang o pnes ngarlatgep to le ka mnganang te, “Ya svil kam ya?” ");
INSERT INTO sua_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Va endo a nharyor, thavaeng te, “Kolaip, nop a mhel lang mo kam plalam dok kmel dok kun mnam a ngaenker ko nam kael lilie e. Kom sia khanang dok kam ngae ngogu ma ngaenker, vanangko a mhel langto nama grung he ka ktar kur kun mnam.” ");
INSERT INTO sua_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","E Yesus ta ngnek tok, to her kle gia reng te, “Hop sir, he tolpum ila tomngen he kngae.” ");
INSERT INTO sua_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","A gi hi to e Yesus tre gia reng tok, a nharyor to endo ther gia ya ngatngae, to khop ksir ktolpum ka tomngen to hera ngae. Va a kolkha to endo a Sabat. ");
INSERT INTO sua_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","He ekam tok, o Yuda ngalmialaol ngata kekner a mhel to endo ko e Yesus tgi gun eharom mnam ka yor kam reng te, “A kolkha ta, a Sabat he. Nguaro pos ngat lua ngatkal ngang in kam tolpum ila tomngen e.” ");
INSERT INTO sua_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Va a mhel to tkoripang ngar te, “A mhel to teharom dok kam kta ya kat en arhe treng dok kam tolpum kua tomngen he kngae.” ");
INSERT INTO sua_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ngata ngnek tok, to kle ka mnganang te, “Ani mhel to ya rere mang ko treng in kam tolpum he kngorom?” ");
INSERT INTO sua_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Vanangko a mhel ta, tngae lo kta mnor mang ani mhel to e Yesus hak, ekam ko e Yesus ther vur aol kun pgegom a mumu to ta gun ko tok, he vur ngae parem ko. ");
INSERT INTO sua_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Vur koknaik he, to e Yesus ta puknim a mhel to endo kun mnam E Nut ka maksien to kreng te, “Vokom ila vok na. Yi ya tete he. He ekam tok, ngiak or kam kta vle pum o kerkeknen kat, matok a tomhel tang ko tho kernonho hak nera pis miik kir kim endo tesgun.” ");
INSERT INTO sua_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","To a mhel to endo thera ngae to khavaeng o Yuda ngalmialaol te, e Yesus arhe endo teharom he tya. ");
INSERT INTO sua_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","O Yuda ngalmialaol ngat kol a re mang e Yesus te, nam kaeha mnam a Sabat tok, to ngat kaelha kam kol a regesal mang. ");
INSERT INTO sua_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","To e Yesus ta reng ngar te, “E Titou nama plong kaeharom karo reha kngae kais ma kolkha to enda. Va dok kat, koma plong kaeharom kuaro reha enang tok kat.” ");
INSERT INTO sua_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tesgun o Yuda ngalmialaol ngama svil kmim e Yesus kngam a yoror ekam ko nma kpanaem mang o pos ruk mang a Sabat. Vanangko karo rhek ruk endruk, ngat el vrek kiin mnam mar, mar kam ho gia khanang ngar kmim kngam a yoror kir kim tesgun. Ngat kaesik ngang tok, ko tlo gi kpanaem mang o pos ruk mang a Sabat tuk e. Nove! Orom karo rhek ruk endruk tngae le mrua mon en kat te, E Nut khal to orom en mruo. Ii, ta mrua mon en tok he khover en mruo te, en tkais mang E Nut kat. ");
INSERT INTO sua_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Va e Yesus ta kle koripang ngar orom karo rhek ri te, “Ii, kua mien ngang nguk te, E Nut Khal tlo is kmeharom a ngaeha tang orom ka serppak mruo ko en tuk e. Nove! En tgi kais kmeharom o tgoluk ruk nma vokom Kteit ko nam kaeharom mar, ko Khal nam her gia kolkol ekam Kteit enang tok. ");
INSERT INTO sua_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ii, E Nut Khal nam gia kolkol ekam Kteit kmeharom karo reha tok, ekam ko Kteit nam vu kaelongtok mang Khal, he le mrua khenam karo reha ngang en kmeharom mar tok. Ii, va mgua re vokom E Nut Khal karo ngaelmir ruk lserpgue ko E Nut nera khenam mar ko maktiegom, va mguera senkrip kim mar ekam ko ngara kir kim endo enda tete ko ko srim endo ka nhar tyor. ");
INSERT INTO sua_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ko kmikkiem gi enang ko E Nut nma hover o yoror petgim ngakro nnak kmen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang ngar, va Khal kat ner kaikkiem Kteit ka ngaeha to kat, kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang endruk en mruo nma svil kmen ngang ngar. ");
INSERT INTO sua_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Va kmenserpagam a papat to endo kua havaeng nguk kat te, E Nut nam lua monik kim a yor ngang o mia pum ngaro kerkeknen e. Nove! Ko ther el a ngaeha to endo ko maktiegom Khal he. ");
INSERT INTO sua_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ii, tel a ngaeha to endo maktiegom Khal tok, he nang o mia tgus kam totu pum Khal, gi enang ko ngma totu pum Kteit to E Nut tok kat. He ekam tok, endo nam lua totu pum E Nut Khal, a mhel to endo tmia khenam en mruo ma mmok te, en nam lua totu pum E Nut tok kat arhe. ");
INSERT INTO sua_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ii, kua mien ngang nguk tok, ko endo na ngan vgum dok he kor mnam en mang E Nut to tmeng dok, E Nut ner lua monik kim a yor ngang. Nove, ner kle va kaen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang, en kam vle ko kim En mekam mekam. Ii, a mhel to endo ner lo is kam yor ekam ko ther ottek mnam a yor he, he le kvaik mnam a ktalhok to kam pong vle ko kim E Nut ngnik ngnik. ");
INSERT INTO sua_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kua mien ngang nguk te, a kolkha langto nera pis va tete ko her elha pum he, ko mnam a kolkha to endo endruk ngat gia vle enang o yoror ko ngam lua kor mnam mar mang E Nut he lua mokpom kar ngar mia ngan E Nut Khal ka ktui, va endruk mnam mar ngta ngan vgum he kor mnam mar mang he kmokpom kar, E Nut ner kaen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang ngar. ");
INSERT INTO sua_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ngara kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik her vgum E Nut Khal tok, ekam ko a serppak to kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik tottek ko kim E Nut he E Nut ther le kaen a serppak to endo ngang Khal, en kmen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang o mia kat. ");
INSERT INTO sua_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Va E Nut ther him Khal orom ka msasaen mruo kat, en kam monik kim a yor ngang o mia tgus pum ngaro kerkeknen ko her en mruo A Mhel To Nkong Man Ma Volkha arhe. ");
INSERT INTO sua_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ii, va mguak or kam senkrip kim kuaro rhek ri kat ko kua havaeng nguk te, a kolkha langto kat koknaik ner mia pis ko o yoror tgus ruk kun mnam ngakro nnak ngara ngan E Nut Khal ka ktui, ");
INSERT INTO sua_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","to le kaum khohop petgim ngakro nnak. To endruk ngat eharom o keknen ruk lyar ko ngma vle ngara hop to E Nut ner le kaen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang ngar. Vanang endruk ngat eharom o kerkeknen ko ngma vle ngara hop kat, vanang E Nut ner kle va kmonik kim a yor ngang ngar kam pet mar petgim En, he ka vle tok ngnik ngnik. ");
INSERT INTO sua_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Klo is kam mrua kansgum dok kmeharom a ngaeha tang he kmonik kim a yor ngang ngar pum ngaro kerkeknen kmikkiem kua serppak mruo e. Nove. Kom kle va kmonik kim a yor ngang ngar pum ngaro kerkeknen kmikkiem gi enang ko E Nut mruo nma reng dok kmeharom tok. Va kuaro papat ruk kom kaelik ngang ngar enang tok, mar tgus ngata sir. Va ngta sir tok, kmikkien enang ko kom lo mrua kansgum dok kmikkiem kua mur svil mruo e. Nove! Kom kle va kaikkiem Endo tmeng dok ka svil.” ");
INSERT INTO sua_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Enangthe dok atgiang tuk kop mrua rere orom dok mruo, va kuaro rhek ngat lo kaur e. ");
INSERT INTO sua_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Vanangko langto yok nma sir vanam dok he krere ormok kat, va kua mnor te, karo rhek ruk nma rere ormar mang dok, ngat is kmenserpgam kuaro rhek mruo mang dok. ");
INSERT INTO sua_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ii, vanangko mut her meng mularo mia mruo ngok kim e Yoanes va en tsi havaeng nguk lmien mang o rhek ruk mang dok ko ngata mien tok, ");
INSERT INTO sua_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","vanangko kom lo kaur mnam dok mang a gi mhel to endo tuk kam sir vanam dok he kaenserpgam kuaro rhek ruk mang dok kat e. Vanangko ko kle va kre kvat e Yoanes tok, muk kmor mnam muk mang karo rhek ruk mang dok, he E Nut kam susulgim muk vgum mar. ");
INSERT INTO sua_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ii, tesgun e Yoanes tkaenang a paei to ta vurvur he kvaller o mia ko nam kael o mia ma mmok mang dok, vanang mut gi vrua svil mang a mmok to endo he lo vua sirei mang lhok e. ");
INSERT INTO sua_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Vanang kuaro mur reha kat, endruk E Titou telik maktiegom dok kmeharom mar kam tarkanang ngar, mar kat ngam kaenserpagam o rhek ruk mang dok kat. Ii, ngat kaenserpagam mar kir kim e Yoanes karo rhek ruk ther rere mang dok ormar kat. Va kom kaeharom o reha ruk endruk gi tete ta vop. Va her o reha ri arhe ngma khenam ngang nguk ma mmok te, E Nut ther mia meng dok ngte kmuk he. ");
INSERT INTO sua_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Va kmenserpagam a papat to endo kat kua havaeng nguk te, E Titou mruo kat, Endo ther mi meng dok ngte, her En mruo arhe ta rere ormok kmenserpgam o rhek ruk mang dok tok kat. Vanangko muk, mut ngae ho lo vur ngan ka ktui va lua vokom ka mnor mang ka mit vop. ");
INSERT INTO sua_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Va ekam ko mum lo kor mnam muk mang dok te, E Nut tmi meng dok ngte mo kmuk he lua mokpom kar dok, va ta kle ka khenam muk ma mmok te, E Nut kakro rhek ngat lo el rengmat kun mnam mularo vurkul e. ");
INSERT INTO sua_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Muma kellu mnam E Nut ka meer kam riring o rhek ngo pneik ekam ko muma pat re te, o rhek ri arhe ngar kaen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang nguk. Vanangko o rhek ruk endri her mar ruk arhe ngat kle va khavae mang dok to ko is kmen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang nguk. ");
INSERT INTO sua_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ngta havae mang dok si enang tok, vanangko mum lua svil kmaol ngte kim dok, dok kmen a ktalhok to endo ngang nguk e. ");
INSERT INTO sua_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Va kom lua lol o gi vrong mia ngaro vrong rhek ko ngma kanprim dok ormar kat e. ");
INSERT INTO sua_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Vanangko muk, ko ho mi kut mnor mang nguk hak, va kua mnor te, mum ho lo kaelongtok mang E Nut e. ");
INSERT INTO sua_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mu vokom na, enangthe a gi vrong mhel tang nap kaol kpis orom ka mur munik mruo va mum her gia svil mang. Vanangko dok ko her aol ngte kmuk orom E Titou ka munik mruo, va mum ngae ho lo kta svil mang dok hak. ");
INSERT INTO sua_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ii, mum vua svil kam mrua kanprim muk mruo, nang kman ko mum lua svil mang E Nut to en atgiang tuk kmen a ktalhok ngang nguk, he E Nut kam kanprim muk mang tok? He ekam ko muma svil kam gi mrua kanprim muk mruo tok, va mguer kais kmor mnam muk mang dok he kmokpom kar dok nngia e? ");
INSERT INTO sua_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kua re tok, vanangko mguak or kam pat re te, dok to ngora mon muk orom mularo kerkeknen ko kim E Titou. Nove, ngor lua kaeharom tok e, ko her E Moses to arhe, endo nera mon muk orom mar ekam ko muma vle pum karo rhek kam nho mkor mar, enangthe mar ngat kais kmel muk kam vle la mmok ko pum E Nut kalo keik. ");
INSERT INTO sua_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Te tok, enangthe mup mia kor mnam muk mang e Moses, va nok mup kor mnam muk mang dok kat vor, ko her dok to e Moses ta ktar ittiek mang arhe. ");
INSERT INTO sua_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Vanang enangthe mut lo kor mnam muk mang e Moses karo rhek ruk tittiegom mar mang dok, va mut kais kmor mnam muk mang kuaro rhek nngia?” ");
INSERT INTO sua_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kam ngae, to o kolkhek kavurgem ngat nop ko pekam ko e Yesus teharom a mhel to kalo nhar ngint yor, to ta ngae kenker a ngaenker to ko mGalili. Va ngma mon a ngaenker to endo kat te, A Ngaenker To ko mTaibirias. Tkenker to kpis ko ma ngaenker ka ngaiting to ngkun kuon. ");
INSERT INTO sua_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Va a mumu alautar ta mur kaikkiem ko ngat her vokong ko teharom o yor orom o ngaelmir ruk lserpgue ko mnam a rengmat to endo. ");
INSERT INTO sua_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tvaar to le kngae ka grap ngoguon ekam a vul langto ka ngaiting, to kpis korsang ko tok kar kalngunes. ");
INSERT INTO sua_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Vanang a kolkha to mang o Yuda kmem nga pnes to ngma mon te, A Engyel Ta Varpaam O Yuda Ngaro Molpou ta kokon he. ");
INSERT INTO sua_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ngat korsang ko tok, to e Yesus ta nonho va kvokong a mumu alautar ko ta grap ngoguon kpis ko kim, to e Yesus tpe gia mnganang e Pilip te, “Ngrua kaenkim o ol tamriem mor kam klang o mia ri?” ");
INSERT INTO sua_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Vanang e Yesus tpe gia mnganang e Pilip tok kam gi kaegom, ko ta ktar mnor he mang a ngaeha to en mruo ner mur kaeharom. ");
INSERT INTO sua_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","To e Pilip tkaekon a re ngang te, “Tang mnam mor nak kaeha kais mo kenho ruk aktiek hori orom korlotge kmit o krek ruk ngat is te, o dinaris ruk 200 kmenkim o ol ngang ngar. Va si o krek ruk endruk va ngar lo kais ge kmenkim o bret ruk ngat kais mang o mia ri, mar kam gi vrua kauyang ngaro vurkul.” ");
INSERT INTO sua_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","E Pilip ta re tok, to e Yesus kalkayie langto, e Andru to e Saimon Pita knopia thavae te, ");
INSERT INTO sua_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ke kalyie to enda kero bret ruk aktiek o gutnei, endruk ngat eharom mar orom ke ho to a bali ka ngaor va ke lo slang lomin ri kat. Vanangko ngat ngae ho lo is hak mang o mia ngarlavurgem ri e.” ");
INSERT INTO sua_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","E Yesus ta reng kalngunes te, “Mu reng ngar he ngrorosang.” To ngat her le korosang ko tok mnam a mhe to enda tgi ya ko a kle tses mnam. To kam him gi lurokol ruk kun mnam mar tgus ko ngta korsang ko tok, mar ngat kais te, 5,000. ");
INSERT INTO sua_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ngat korosang knop, to e Yesus ta lol o bret o gutnei to kanprim E Nut mang ngar to le kaisis kim endruk ngat korosang ko tok kmikkiem langto langto ko ta vang. To ta le kaeharom tok kat orom alo slang kat. ");
INSERT INTO sua_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","To mar tgus ngat kaemik. Ngat kaemik ngae smia vi, to e Yesus ta le kreng kalngunes te, “Muak or kam koham o ol e. Mguak kaum o ol ngaro mhetor ruk ngat penkim mar.” ");
INSERT INTO sua_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","To e Yesus kalngunes ngata kaum o bret ngo mhetor ruk ko ngat emik he penkim mar to ka klang o ngauret ruk loktiek hori orom alomin ormar. ");
INSERT INTO sua_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","A mumu to tok, ta vokom a ngaelmir a serpgar to endo ko e Yesus teharom, to ngat le kaelpun kam polger o rhek mang te, “Lmien mang a mhel ta he, en her a Propet to E Moses ta ktar kpavap mang arhe te, nak kaol ngte.” ");
INSERT INTO sua_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ngat kaelha kam polger o rhek mang enang tok, to e Yesus ta tar ko ngta re kmaol ngok kim he ksovet kmenpasiker kam teiver, en kam vle te, mar o Yuda nga Taven. Ta tar ko ngat re kmeharom tok, to tvur aol kparem mar to kngae en tuk ngoguon kia vul. ");
INSERT INTO sua_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tie ma rorongmia, e Yesus kalngunes ngta grung ngogu ma ngaenker ");
INSERT INTO sua_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","to kpis korsom nga langail to kpoe kenker a ngaenker kmeknik ngok mKaparnam. Ngat poe kpoe to a kolkha ther vaik to ta slok he, va e Yesus tlo kaol puknim mar vop. ");
INSERT INTO sua_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","To a ngausgi te sei kam pis alaut gi va a ngaenker ta karir lesik. ");
INSERT INTO sua_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ngat vur poe hogen he, he ka vle ogu ma mlin, to kle yek ngta vokong e Yesus ko ta ngae kaol rkieng a langail ko ta ngae kuon kia ngaenker ka las. Ngat vokom tok, to ngat sei kam gor hak. ");
INSERT INTO sua_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ngat gor tok, vanangko e Yesus ta kle kreng ngar te, “Mu or kam gor e, ko dok ta.” ");
INSERT INTO sua_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","E Yesus ta re tok, to kalngunes ngta tting mang en kam le kar kuo kmar. A gi hi to ta kar kuo kmar, ngat her gi pis ko va mou ko tok mnam a rengmat to ngta poe kngae ngok mnam. ");
INSERT INTO sua_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","To hop enang ngmo, a mumu to ta vle ko va ngaenker ka ngaiting to ngko gut he lo kaikkiem e Yesus ngkun kuon tgi gnua tar te, tesgun a langail to agitgiang tuk te ka vle ko tok ko va ngaenker ka ngaiting to ngko gut. Va o mia ngata mnor mang e Yesus kat te, tlo kar kun mnam a langail to endo kar kalngunes kat e. Ngat gi vokom kalngunes ko gi mar tuk ngat kar mnam a langail to endo he kngae, nang e Yesus nove. ");
INSERT INTO sua_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","To o laktok akuruk ngat ottek mTaibirias kpis kvavaar ko rkieng a mhe to Ngoldaip ta klang a mumu kmo ol ko pekam ko ta kanprim E Nut mang ngar. Ngat pis kvaar, ");
INSERT INTO sua_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","to a mumu tkol a re to mang e Yesus mar te, ngat lo vle ko tok, to o mia ngat kle kta karkar kun mo laktok ruk to hera ngae mKaparnam kmelha kriring. ");
INSERT INTO sua_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ngat sia riring e Yesus to kpis mang ko tok ma ngaenker ka ngaiting to ngkun kuon to ngata mnganang te, “Pattermia, ye pis mo tenngor?” ");
INSERT INTO sua_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Va e Yesus tkoripang ngar te, “Kua mien ngang nguk te, Mut sia riring dok gi ekam ko mut em o ol he, he ngae sim vi kmar. Vanangko mut lo mia riring dok ekam ko mut vokom mnor mang kuaro ngaelmir ruk lserpgue e. ");
INSERT INTO sua_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Muak or kam gia vle pum o ol ruk ngma hevri. Vanangko muak kle va ka vle pum o ol ruk orom a ktalhok to kam plong vle ko kim E Nut ngnik ngnik, endo A Mhel To Nkong Man Ma Volkha to dok ngor kaen ngang nguk. Ii, ngor kaen a ktalhok to endo ngang nguk ekam ko E Titou to E Nut ther him dok orom ka msasaen kam khenam ngang o mia te, ther ngatkal orom dok tok arhe.” ");
INSERT INTO sua_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","E Yesus ta re tok, to o mia ngta kle ka mnganang te, “Yu! Te tok, va sim havaeng ngor na, ngruak kaeharom oni ruk lsir, mor kmaottam E Nut karo reha ruk telik ngang ngor kmeharom mar?” ");
INSERT INTO sua_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Va e Yesus tkoripang ngar te, “E Nut ka ngaeha msim ta vle ti te, a mhel kmor mnam en mang dok to E Nut mruo tmi meng dok ngte he kmokpom kar dok.” ");
INSERT INTO sua_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ngta ngan e Yesus karo rhek ruk tok, to kle kta mnganang kat te, “Yu! Vanang ani ngaelmir to a serpgar ngiaka khenam ngang ngor kam khenam ila serppak ma mmok, he nang mor kam vokong he kor mnam mor mang in te, lmien mang in tok. Yin he! ");
INSERT INTO sua_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ko tennik nguaro pupnam ngta vle ko ma kalputmok he ngat em o bret ruk o mana, endruk ngat ottek kun kuon ma volkha. Ngat ittiek mang ngar te, ‘Nma klang ngar mo bret ruk o mana, endruk ngat ottek kun kuon ma volkha.’” ");
INSERT INTO sua_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","To e Yesus thera havaeng ngar te, “Ko smia mien ngang nguk te, o bret ruk o mana ruk mut lol tennik kun kuon ma volkha, nong e Moses to ta klang nguk orom mar e. Nove! E Titou mruo, to ther klang nguk orom o bret ruk o mana ko ngat ottek kun kuon ma volkha. Va her En tete kat arhe to ther en a bret ka mten langto yok, ngang o mia, endo tottek kun kuon ma volkha kat. ");
INSERT INTO sua_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ii, ko a bret to endo E Nut ther meng he, he ther grung kun kuon ma volkha he her pis mo mmie he. He her en arhe tkais kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang o mia tgus ruk mo mmie.” ");
INSERT INTO sua_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","E Yesus ta re tok, to ngta reng te, “Ngolaip, ngia kaelha tete he, he ka klang ngor mo kolkhek tgus orom a bret ka mten to ya rere mang.” ");
INSERT INTO sua_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Va e Yesus ta havaeng ngar te, “A bret to kua rere mang her dok ta arhe, endo tkais kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang o mia. Va ani mhel to na kaol ngte kim dok tlo kat kais kam kta vang kat e. Va endo na kor mnam en mang dok he kmokpom kar dok, a mhel to endo tlo kat kais kam kta katngaivie kat e. ");
INSERT INTO sua_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Vanang ko her havaeng nguk he te, mut sia vokom dok orom kua ngaeha to orom o bret lsir, vanang muma kees ge kmor mnam muk mang dok he kmokpom kar dok. ");
INSERT INTO sua_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","O mia tgus ruk E Titou telik maktiegom dok, her mar ruk arhe ngar mi kaol ngte kim dok kmor mnam mar mang dok he kmokpom kar dok. Va ko ho lo is hak kam likim tang, ko na kaol ngte kim dok kmor mnam en mang dok he kmokpom kar tok e. ");
INSERT INTO sua_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ko ho lo is kam likim tang tok, ekam ko klo ottek kun kuon ma volkha ka grung kmaol ngte mmie kmeharom kua mur svil mruo e. Nove! Ko kle va kaol ngte kmikkiem Endo tmeng dok, ka svil. ");
INSERT INTO sua_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ii, va Endo tmeng dok her ka svil ta arhe te, Dok kam lua moslam tang hak mnam endruk telik maktiegom dok. Ii, ta svil dok kam lo korim tang mnam mar, vanang kle va khover mar tgus petgim ngaro nnak kun mnam a kolkha to a kser kim. ");
INSERT INTO sua_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ii, kua havaeng nguk te, her E Titou ka svil to arhe ekam ko En nma svil o mia kam smia riring Khal to dok he kpis mang dok. Ii, ta svil mar kam pis mang Khal to dok tok, to le kor mnam mar mang dok he kmokpom kar dok, he nang E Nut kmen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang ngar ekam tok. Na kaen a ktalhok ngang ngar tok, he nang dok mruo kam le kta hover mar petgim ngaro nnak mnam a kolkha to a kser kim tok arhe.” ");
INSERT INTO sua_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","O Yuda ngalmialaol ngat ngan e Yesus ko ta mrua havae mang te, “A bret to E Nut ther meng he, her dok ta arhe, ko ko her ottek kun kuon ma volkha he ka grung kmaol ngte mmie he.” Ngat ngan tok, to ngat le kaelha kam rere porom mar mang e Yesus karo rhek ruk endruk. ");
INSERT INTO sua_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ngat havae te, “A mhel ta, her en e Yesus to e Yosep khal ngola? Va kteit va knan ngota mnor mang ngin kat ngola? Vanang kman ko ta havae te, ‘Ko her ottek kun kuon ma volkha he ka grung kmaol ngte mmie’?” ");
INSERT INTO sua_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","To e Yesus ta kser mar te, “Muak or kam vua rere porom muk pum dok. ");
INSERT INTO sua_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mu vokom na, a mhel tang ko en mruo tuk tlo kais hak kam mur kaol ngte kim dok kmor mnam en mang dok he kmokpom kar dok e. Nove, gi E Titou mruo, Endo tmeng dok naka ktar mur kait a mhel to endo kmaol ngte kim dok, yek en ner kais kam pat kmor mnam en mang dok. Ii, E Titou naka ktar kait o mia ngte kim dok na, to endo yek, dok mruo ngora hover mar petgim ngaro nnak kun mnam a kolkha to a kser kim. ");
INSERT INTO sua_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ii, o mia tgus ruk ngat sim kael ngaro rela ngang Ngor Teit kam lol karo rhek mkor, her o mia ruk arhe ngam kaol ngte kim dok. Ii, ta vle tok, kmikkiem gi enang ko o propet ngat ittiek te, ‘Her E Nut to arhe Endo nera patter o mia tgus.’ ");
INSERT INTO sua_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","A mhel tang tlo vokong E Titou to E Nut vop. Gi endo tuk to tottek ko kim En, en tuk to tvokom. ");
INSERT INTO sua_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","48","Ko smia mien ngang nguk te, endo ta kor mnam en mang dok te, dok a bret ka mten to tkais kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang o mia, va ngor kle mi kaen a ktalhok to endo ngang. ");
INSERT INTO sua_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mu vokom na, a bret to dok, endo kua rere mang, tlua vle enang o bret ruk o mana e, endruk mularo pupnam ngat emik ko ma kalputmok, ko ngat si emik va ngat yor ge. ");
INSERT INTO sua_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Vanang a bret ta, en a bret to te ktua vle gi, ko tottek kun kuon ma volkha he ka grung ngte mmie he o mia ngat kais kmemik mnam he kol ktalhok to kam plong vle ko kim E Nut ngnik ngnik vgum. ");
INSERT INTO sua_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ii, a bret to endo her dok ta arhe, dok to ko her ottek kun kuon ma volkha, dok to ko kais kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang o mia. He ekam tok, endo na kaemik mnam a bret to ormok, her a mhel to nera kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik arhe. Va a bret to kua rere mang her kua vok msim ta arhe, endo ngor mur kael, ngar kmim kngam a yoror mang o mia, he nang mar kam kol a ktalhok to endo vgum tok.” ");
INSERT INTO sua_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","E Yesus ta re kvat ka vok tok, to o Yuda ngalmialaol ngat kaelha kam mo maen o rhek lesik mo ngar mruo te, “A mhel ta na kaen ka vok ngang ngor, mor kmem nngia e?” ");
INSERT INTO sua_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ngat re tok, to e Yesus ta kle khavaeng ngar te, “Kua mien ngang nguk te, enangthe mgua lo kaem A Mhel To Nkong Man Ma Volkha to dok kua vok va kaivie mnam kua gidiel va E Nut tho lo is hak kmen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang nguk e. ");
INSERT INTO sua_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Vanangko endo na kle va kaem kua vok va kaivie mnam kua gidiel va E Nut ner mi kaen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang, va koknaik mnam a kolkha to a kser kim ngora hover petgim ka nnak kat. ");
INSERT INTO sua_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","He ekam tok, o olngaemik ruk kmemik va kmivie kam serppak vgum mar kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik endruk her kua vok msim va kua gidiel arhe. ");
INSERT INTO sua_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Va kmikkiem tok kat, endo nam kaem kua vok va kaivie mnam kua gidiel her endo arhe nma par mnam dok to kua vle enang ke ho ka pun va dok koma kha orom endo kat. ");
INSERT INTO sua_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","E Titou to tmeng dok ngte mmie ta vle orom a ktalhok to kam plong vle ko kim En ngnik ngnik. Va dok kat kua vle orom a ktalhok to endo vgum ko En ta vle orom tok kat. Va kmikkiem enang tok, endo nam kaem kua vok, a mhel to endo nera vle orom a ktalhok to kam plong vle ko kim E Nut ngnik ngnik kat ekam ko dok koma vle orom tok kat. ");
INSERT INTO sua_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ii, enang ko ko havae, a bret to kua rere mang her endo tottek kun kuon ma volkha he ka grung ngte mmie arhe. Mu vokom na, a bret ta, tlua vle enang o bret ruk o mana, endruk mularo pupnam ngat emik e, ko ngat si emik va ngata yor ge. Vanangko endo nam kaem a bret ta, E Nut ner kaen a ktalhok to kam plong vle ko kim En ngnik ngnik ngang.” ");
INSERT INTO sua_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","E Yesus ta rere tok, ko ta patter o mia kun mnam o Yuda ngarta rek to kam rere mnam ko tok mKaparnam. ");
INSERT INTO sua_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","E Yesus ta re tok, to kalngunes ngarlavurgem ngta ngan ka re to endo to karo rhek ruk endruk ngat kerngorom mar he ngata kaprere pum mar te, “A re to enda tvua koppet kmikkiem. Erieto tis kam kol he kaikkiem?” ");
INSERT INTO sua_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","E Yesus ta tar ko ngata kaprere pum karo rhek ruk, to ta kle kreng ngar te, “O rhek ri ngat el resik kun mnam muk he mguera ksir petgim dok gi? ");
INSERT INTO sua_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Vanang enangthe mupa vokom A Mhel To Nkong Man Ma Volkha to dok ko nguak kat kaeknik ngoguon ma volkha ekam ko tesgun koma vle ko, va nok mguer kle kosnok vor? ");
INSERT INTO sua_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mu vokom na, her E Nunu A Totur tuk to tis kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang o mia. Vanang kua mi vok to ner mia parem muk kmeknik tok, tlo is e. Ii, va E Nunu A Totur nam kaen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang o mia her vgum kuaro rhek ri arhe, endruk ko her havaeng nguk ormar. ");
INSERT INTO sua_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Vanangko akuruk mnam muk mut lo kor mnam muk mang ngar gi.” Vanang e Yesus ta reng ngar tok, ekam ko ktar mang ko tlo vaeng kalngunes vop ta ktar her mnor mang ngar he te, edrim mnam mar, ngar lo kor mnam mar mang he lua mokpom kar, va edim mnam mar lsir ner le mrua hortgi mang. ");
INSERT INTO sua_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Va ta kta reng ngar te, “Kua havaeng nguk mang ngar tok, kam khenam ngang nguk te, enangthe E Titou mruo na lo ktar kait a mhel kmaol ngte kim dok va tlo is hak kmaol ngte kim dok kmor mnam en mang dok he kmokpom kar dok e.” ");
INSERT INTO sua_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ii, e Yesus kalngunes ngata ker kokol karo rhek ruk endruk tok, to kmelpun mnam a kolkha to endo yek ngarlavurgem ngata ksir petgim va ho lo kta kaikkiem kat e. ");
INSERT INTO sua_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","E Yesus tvokom mar tok, to her kle ka mnganang endruk Loktiek Hori Orom Alomin te, “Vanang muk, muta svil kam ksir petgim dok kat?” ");
INSERT INTO sua_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Va e Saimon to e Yesus ta kilegem te, e Pita, tkoripang te, “Ngoldaip, ngrua kta ngae ngok kim erieto? Ko her vgum yin tuk arhe ngot kais kam kol a ktalhok to kam vle ko kim E Nut ngnik ngnik ko ngot lol ilaro rhek. ");
INSERT INTO sua_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ngot kor mnam mor mang in he kmokpom kar yin he, ko ngota mnor mang in te, Yindo A Totur, Yindo E Nut tmeng in ngte mmie.” ");
INSERT INTO sua_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","E Yesus ta ngan e Pita ko ta re tok, to thera pupam o mia tgus kam reng ngar te, “Dok mruo kua re pmuk ruk Lo Ktiek Hori Orom Alomin he kvaeng nguk kmor mnam muk mang dok he kmokpom kar dok, vanangko langto kun mnam muk e Seten tviging he.” ");
INSERT INTO sua_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(E Yesus ta re kvat e Seten kam havae mang e Yudas to e Saimon to nkong mIskariot khal, ko tsi vle en langto mnam endruk Lo Ktiek Hori Orom Alomin, vanangko koknaik ta mrua hortgi mang ge.) ");
INSERT INTO sua_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kam ngae to, e Yesus te ktua ngae kpupunpa kngongae ko mGalili. Te lo mi ktua svil kam kta punpa ko mYudea kat e, ekam ko o Yuda ngalmialaol ngta re kmim kngam a yoror. ");
INSERT INTO sua_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","To o kolkhek ruk o Yuda kmem a pnes to ngma mon te, A Pnes To Kam Kunngir Kim E Nut Kun Mnam O Rambel ngta kokon he, ");
INSERT INTO sua_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","to e Yesus kaornopeik ngat pe gi kaenen mkor te, “Ipa parem a mhe ta he kngae ngogu mYerusalem ko mYudea, he nang itlengunes kam vokong ilaro reha ruk lserpgue ma mmok, endruk im kaeharom mar. ");
INSERT INTO sua_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ii, ko a mhel to ta svil kam mrua polgom en mruo ma mmok ko pum o mia ngaro kerok, nam lo mrua tuvgong karo reha e. He ekam tok, ekam ko im kaeharom o reha ruk lserpgue ruk endri, va ngia mrua polgom yin mruo ormar ma mmok ko pa pnes ko pum o mia ruk mo mmie ngaro kerok.” ");
INSERT INTO sua_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Vanang e Yesus kaornopeik mruo ngat kaenen mkor tok, ekam ko si mar kaornopeik msim, vanang ngat lo kor mnam mar mang he kmokpom kar kat e. ");
INSERT INTO sua_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Va e Yesus tkoripang ngar te, “Kua kolkha msim tlo pis vop. Nang muk, mut is kam gi vrong ktua ngae ge. ");
INSERT INTO sua_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","O mia ruk mo mmie ngat lo is kam kapter muk e, vanang dok, ngam kle va ksei kam kapter dok ekam ko koma palsie kim mar pum ngakro kerkeknen ruk ngat ho mi kut kernonho hak. ");
INSERT INTO sua_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Muk he, mguak ngae ngok pa pnes ge. Nang dok, ngor lua ngae ngok pa pnes ta vop ko kua kolkha msim tlo pis vop.” ");
INSERT INTO sua_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ta re tok, to vrua vle ko mGalili ge. ");
INSERT INTO sua_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","To ko pekam kaornopeik ko ngata ktar kngae ngok pa pnes, e Yesus ta kle ka knaek kat, nang tlo mrua plok orom ma mmok kim o mia e. Tgi vrua tutvok kngongae lvongnek kun mnam o guliel. ");
INSERT INTO sua_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Vanang ko tok mYerusalem ko pa pnes kat o Yuda ngalmialaol ngat vrua nhong va kmamngan mang te, “A mhel to namrie?” ");
INSERT INTO sua_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Va o mia ngate ksei kam vrua vur re kngae kun pgegom mar, ko akuruk ngat havae mang te, “A mhel ta, en a mhel a yar.” Vanang akuruk ngat kle kokheng nglenar he kre te, “Nop ge, nam vua kermamas ngang o mia.” ");
INSERT INTO sua_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Vanangko o mia akuruk ngat si mnor mang, vanangko ngat lua hophop mang ko ma mmok e, ko ngta gorang o Yuda ngalmialaol. ");
INSERT INTO sua_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kam ngae kais ko tkaendavloum a pnes karo kolkhek, to e Yesus ta ngae kvaik kun mnam E Nut ka maksien ka mhe to ko ma gi vle he kaelha kam patter o mia ko tok. ");
INSERT INTO sua_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","O Yuda ngalmialaol ngta ngan karo rhek he ksesenkrip kim to kle mrua mo mnganang ngar te, “A mhel tang tlo patter va keknen ngang, vanang nngia orom ko tvu sim mnor mang o papat ngarlatgep?” ");
INSERT INTO sua_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Va e Yesus tkoripang ngar te, “O rhek ruk koma patter o mia orom mar nong nang dok mruo e. Nove, o rhek ri ngat ottek ekam Endo tmeng dok ngte. ");
INSERT INTO sua_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ii, va ani mhel to na smia vle pum E Nut ka svil, ner kle yek mrua mnor mang kuaro rhek te, kuaro rhek ri koma rere ormar ngat ottek ekam E Nut, i o ngat ottek ekam kua serppak mruo. ");
INSERT INTO sua_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mu vokom na, a mhel to nma rere orom ka serppak mruo, nam mrua hover en mruo tok, he nang o mia kam kanprim en. Vanang a mhel to nma kol kalaip to tmeng ka gu, he krere kam hover kalaip to endo, her en a mhel to nam sim kut kaikkiem o papat ruk o minar, va o rhek ruk la ppiagar ngam ho lo kottek ko vgum hak. ");
INSERT INTO sua_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Vanangko nong tang mnam muk nam smia vle pum o pos ruk e Moses tennik ngang nguk e. He ekam tok, kman ko mut re kmim dok kngam dok a yoror?” ");
INSERT INTO sua_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","E Yesus ta re tok, to o guliel ngta reng te, “A koot tenvevem yin he, erieto nam kaegom kmim in kngam yin a yoror?” ");
INSERT INTO sua_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Va e Yesus tkoripang ngar te, “Ko gi eharom a ngaeha to atgiang ko en a serpgar mnam a Sabat, va muk tgus mut sei kam senkrip kim dok ko ko eha ma Sabat tok. ");
INSERT INTO sua_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Vanang muk? E Moses ta reng nguk kam papaam mu les ruk lurokol ngola? Vanang enangthe mula keknen to kam paam mu les na mi kut vuut mnam a Sabat lsir va mum lo kaeha mo Sabat kam paam mar kat gi? Ii, e Moses ta reng nguk kam papaam mu les kmeharom ke vok ke gi mhe to ke gi sie tok, va mum kaikkiem tok tete. (Vanang nong e Moses msim to telha pum a keknen to kam paam lurokol e. Nove, mularo pupnam ruk ngat elha pum.) ");
INSERT INTO sua_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Va si enangthe a Sabat na re vuut, vanang mum le gia paam mar ge, he nang muk kam lua kpanaem mang e Moses ka pos to kam paam lurokol tok. He enang ko muma paam lurokol mo Sabat tok, to kman ko mut kaesik ngaok, ko ko eha ma Sabat he kaeharom a mhel ka vok tgus kam kta ya kat. ");
INSERT INTO sua_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","He ekam tok, mguak or kam sovet kam mon o mia orom a kerkeknen kmikkiem o pos ngaro gi lpetuk. Mguak kle smia ngangam kmuk mang ngaro pneik to le kmon mar orom a kerkeknen kmikkiem o pos ngaro pneik lsir.” ");
INSERT INTO sua_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","To o mia akuruk ko mYerusalem ngat kaelha kam vrua mo mnganang ngar mruo mang e Yesus te, “A mhel to mor o Yuda ngor ke murgun to nma vongnek kim o rhek ngat re kmim kngam a yoror, enda arhe? ");
INSERT INTO sua_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Vokom na, tsia rere ko ma gi vle mo kim o mia vanang mor o Yuda ngor ke murgun ngat lua rere vgum ge! Pathe nok mor o Yuda ngor ke murgun to nma vongnek kim o rhek ngat kle ka mnorvek pum yek te, her en arhe Endo E Nut Thim Orom Ka Msasaen vor. ");
INSERT INTO sua_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Vanangko ngat kais kam pat tok nngia, ko ngota mnor mang Endo E Nut Thim Orom Ka Msasaen te, nak pis va nong a mhel tang tis hak kam mnor mang ka rengmat ka pun ko na kottek mnam. Vanang a mhel to enda mor tgus ngot sim ktua mnor mang ka rengmat ka pun ko tottek ko mnam.” ");
INSERT INTO sua_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Vanang e Yesus ta hivuo kam patter o mia kun mnam E Nut ka maksien vop, to ta rere malpgem mar te, “Mare, mut smia mnor mang dok va mut smia mnor mang kua rengmat ka pun kat! Vanang klo mrua kansgum dok kam pis mo orom kua serppak mruo e. Nove, E Nut to orom karo papat ruk o minar, her Endo tmeng dok arhe. Vanang muk mut lua mnor mang En hak. ");
INSERT INTO sua_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Vanangko dok kua mnor mang En, ko ko her ottek ko kim En, ko her En arhe tmeng dok ngte.” ");
INSERT INTO sua_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","E Yesus ta re tok, va her vgum karo rhek ruk arhe ngat re kam kleng singni mnam, vanangko nong tang mnam mar tngam kalo ktiek mang e, ekam ko ka kolkha tlo pis vop. ");
INSERT INTO sua_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","A mumu nam pua vle kar e Yesus tok, vanangko kavurgem mnam mar ngat kle kor mnam mar mang en he kmokpom kar ge. Ngma havae mang te, “Her en arhe Endo E Nut Thim Orom Ka Msasaen ko nong a mhel tang hak na pis kmeharom o reha ruk lserpgue ho mi kir kim endruk a mhel ta nam kaeharom mar!” ");
INSERT INTO sua_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","To o Parisiau akuruk ngta ngan a mumu to ko tok, ko ngat vrua vur re orom o rhek ruk endruk mang e Yesus, to mar o Parisiau kar o pris ruk laol ngta meng o pris akuruk ngma toot mang E Nut ka maksien kam ngae kam kpom. ");
INSERT INTO sua_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","To e Yesus thera reng o Yuda ngalmialaol ruk endruk te, “Ngor gi vrua vavle mo kmuk to ngor kat kaeknik kngae ngok kim Endo tmeng dok. ");
INSERT INTO sua_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Va mguera nonhong dok, vanangko mguer lua pis mang dok e. Va muk, mut lo is hak kam ngae ko mnam a mhe to dok kua re kam vle mnam e.” ");
INSERT INTO sua_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","E Yesus ta re tok, to o Yuda ngalmialaol ruk endruk ngata mo mnganang ngar te, “Ta re kam ngae ngam, he ngot lo is kam pis mang? Nok ta re kam ngae ngok kio Grik ko nguaro mia mruo akuruk ngta parahi ngok kim mar ka vle, he en kam patter o Grik vor? ");
INSERT INTO sua_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Va ta re te, ‘Mguera nonhong dok, vanangko mguer lua pis mang dok e,’ va ta re kat te, ‘Muk, mut lo is hak kam ngae ko mnam a mhe to dok kua re kam vle mnam.’ Ta re tok, vanang ka re ka pun ta vle nngia?” ");
INSERT INTO sua_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mpalngaem mnam a Pnes to endo, e Yesus ta hop ksir to krere malpgem o guliel te, “Erieto nak katngaivie va nak kaol ngte kmok kmivie. ");
INSERT INTO sua_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ii, va kmikkiem gi enang ko ngat ittiegom E Nut karo rhek, erieto tkor mnam en mang dok he kmokpom kar dok, va a vugye nera gos kun mnam, en kmivie mnam a ye ka mten to tkais kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang.” ");
INSERT INTO sua_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nang e Yesus ta re kvat a ye ka mten to endo tok kam keknen mang E Nunu A Totur to E Nut nak kaen ngang endruk ngar kor mnam mar mang En he kmokpom kar koknaik. Tennik kam ngae kais ko tok, E Nut tlo en E Nunu A Totur ngang o mia vop, ekam ko e Yesus tlo yor he kat hop petgim ka nnak vop. ");
INSERT INTO sua_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","O mia akuruk kun pgegom endruk ngta gun ko tok, ngata ngan ko e Yesus ta rere tok, to ngat kle mrua havae mang te, “Lmien, a mhel ta, en her a propet to ngta ktar kpavap mang ti arhe te, nera kaol ngte!” ");
INSERT INTO sua_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nang akuruk ngat kle va khavae te, “Her en arhe Endo E Nut Thim Orom Ka Msasaen.” Vanang akuruk yok vat ngta kokhe kre te, “Endo E Nut Thim Orom Ka Msasaen ner lo kottek ko mGalili gi, ");
INSERT INTO sua_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ekam ko ngat ittiegom E Nut karo rhek mang te, Endo E Nut Thim Orom Ka Msasaen nera pal mnam e Devit ka ngausie, va knan nera kol mBetlehem, ko tok mnam a mhe to kaes e Devit tkorsang ka vle mnam tennik kat.” ");
INSERT INTO sua_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Gi enang tok, o mia ngta mommenik va kmo kokheng ngar mruo mang e Yesus. ");
INSERT INTO sua_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Akuruk ngata svil kam kleng singni mnam, vanangko nong tang mnam mar tngam kalo ktiek mang e. ");
INSERT INTO sua_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","To o pris ruk endruk ngma toot mang E Nut ka maksien, ngat kat kaeknik ngok kim o Parisiau kar o pris ruk laol, endruk ngta ktar meng ngar kam ngae ka kpom e Yesus. To o Parisiau ngta mnganang ngar te, “Kman ko mut lua kpom kngorom ngte?” ");
INSERT INTO sua_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Va ngta kle gia re te, “Nong a mhel tang tngae vu smia rere enang a mhel ta gi.” ");
INSERT INTO sua_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Va ngalmialaol ngta re lsinvi kam mnganang ngar te, “He, tmas ormuk kat, ");
INSERT INTO sua_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","49","enang ko ta mas orom a mumu to orom o takpun ruk ngat lua mnor mang mor o Yuda nguaro pos? Hai-e, E Nut ka ngaesik ta vle kuon mang ngar he! Mu havaeng ngor na, mut sim mnor mang kaela ngang ngor ruk o Yuda ngor ke murgun to nma vongnek kim o rhek, i o kaela ngang ngor ruk o Parisiau ko ta kor mnam en mang a mhel to endo he kmokpom kar? Ho mi kut nop hak!” ");
INSERT INTO sua_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ngat re lsinvi ngang o pris ruk ngma toot mang E Nut ka maksien tok, vanang endruk laol kar o Parisiau ngaela langto te ktua vle ko tok, he kaum kar mar, ka munik e Nikodimas. E Nikodimas, endo tesgun ta ngae he ka ptang e Yesus. Ta hop ksir he kreng klenar te, ");
INSERT INTO sua_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nguaro pos ngat hagam mor kam gi vrong kolaspa mang a mhel kam tutut kmel kam yor, nang lo ktar smia vongnek kim karo rhek, kam mnor mang karo keknen e.” ");
INSERT INTO sua_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Va ngta hop ku he le kre lsinvi kat te, “Pathe yin nkong mGalili kat ngola? Ngae he, sim kellu mnam E Nut karo rhek he non ekam mar, yek ngira mnor te, a propet to ngata ktar kpavap mang tennik te, ner kaol ngte, en ner lua kottek ko mGalili e.” ");
INSERT INTO sua_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ngat re tok, to langto langto ta ngae ngok mnam ka rek mruo, ");
INSERT INTO sua_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","nang e Yesus ta kle ktua grap ngoguon kia vul to e Olip. ");
INSERT INTO sua_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","To hop enang ngmo ko a kolkha tgi gnua plek, e Yesus tkat kaeknik ngok mnam E Nut ka maksien ka mhe to ko ma gi vle. O mia ngarlavurgem ngta mur ka kleim to tkorsang kam patter mar. ");
INSERT INTO sua_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","To o pattermia kmo pos kar o Parisiau ngat kaol orom a vlom langto ko o mia ngat pis mang ko ta kpanaem mang ka lei. Ngta kaol orom he ka srim ko pum mar tgus ngaro kerok. ");
INSERT INTO sua_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","To ngat pe gia mnganang e Yesus te, “Pattermia, a vlom ta ngat pis mang ko ta kpanaem mang ka lei. ");
INSERT INTO sua_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","He e Moses karo pos ngat havaeng ngor kam lalaem lraip ruk enang ti orom o krek kngam mar o yoror. Vanang yin, ngir ktua reng nngia?” ");
INSERT INTO sua_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ngat pe gia mnganang e Yesus tok, en kam mrua ru pum karo mur rhek mruo, nang mar kam kle kmon orom karo mur rhek ruk endruk. Vanangko e Yesus ta kle gia kerreku he kaelha kmittiek orom ka smeik kuo mang a mmie ka ngaor. ");
INSERT INTO sua_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nangko ngat kaenenker kam mamnganang vop, to e Yesus ta ngatier ku to ksir, to kreng ngar te, “Tang mnam muk ko ho nop a kerkeknen tang hak ngang, her en arhe naka ktar ka kla mang orom a kre.” ");
INSERT INTO sua_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ta re tok, to kta kerreku to kat kaittiek kuo mang a mmie ka ngaor kat. ");
INSERT INTO sua_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ngata ngnek ko ta reng ngar tok, to mar tgus ngat kaelha kam gilvik ka kle langto langto. Kmelha orom o hipun, ngat veet kparem e Yesus kar a vlom to, ko ta sir en tuk ko tok ge. ");
INSERT INTO sua_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","To e Yesus ta ngatier ku to ksir to ka mnganang a vlom to endo te, “He ngram? Kolkheng, nop a mhel tang kat kam kat kael in kam yor he?” ");
INSERT INTO sua_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Va a vlom tkoripang te, “Kolaip, nop tang e.” To e Yesus ta reng te, “To dok kat, klo kael yin kam yor kat e. He kngae he, vanangko kmelha tete ngior kam kat kaeharom tok kat e!” ");
INSERT INTO sua_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","To e Yesus ta kta rere kar o mia he khavaeng ngar te, “Her dok ta arhe a mmok ka pun msim to kam valler o mia tgus mo mmie. Endo nak kaikkiem a mmok ka pun msim to dok, ngora ktong kam kol a ktalhok to kam plong vle ko kim E Nut ngnik ngnik. He ner ho lo kta ngae kun mnam a slommok kam yor kat e.” ");
INSERT INTO sua_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","E Yesus thavae tok, to o Parisiau ngta rere vgum te, “Mur vokom yin na, tete yin atgiang tuk e yi mrua rere ormin mruo. He ekam tok, o rhek ri ya rere ormar ngat lo kaur e.” ");
INSERT INTO sua_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Va e Yesus ta kokheng ngar kam re te, “Nop hak! Ko si enangthe dok atgiang tuk kop mrua rere orom dok mruo, va kuaro rhek ngat kaur ge, ekam ko dok, kua mnor mang dok te, ko her ottek ko kim E Titou va kua mnor mang dok kat te, ngor kat kaeknik ngok kim kat. Vanang muk, mut lo kta mnor mang dok hak te, ko her ottek ko kim E Titou tok e, va mut lo kta mnor mang dok kat ko ngora kat kaeknik ngok kim kat e. ");
INSERT INTO sua_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Vanang muk, muma vokom o mia he kmon mar orom mutaro mur papat mruo! Vanang dok kom lua vokom o mia he kmon mar enang tok e. ");
INSERT INTO sua_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Vanangko enangthe lmien te, kop sia vokom a mhel tang he kmon orom kotaro mur papat mruo enang tok, va kopa mien orom kuaro papat ruk endruk va nga ngae ho mia mien hak ge. Ko dok, kom lua vle dok atgiang tuk e. Nove, E Titou to tmeng dok ta sir pekmok kat. ");
INSERT INTO sua_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tgia nho kngae gi enang muk o Yuda mutaro mur pos mruo ko ngat mrua havae te, “Enangthe alo mhel alomin ngina kaum kre mang a tomhel to, va ngina re to endo tkaur.” ");
INSERT INTO sua_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","He kmikkiem muta mur pos to endo tok, dok mruo koma rere orom dok va E Titou to tmeng dok ta ngam alomin orom kam rere orom dok kat. He enang tok muo alomin tok moma kaum krere orom dok.” ");
INSERT INTO sua_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ngta ngan ko e Yesus ta re kvat kteit to ngta mnganang te, “Iteit nam?” Va e Yesus tkoripang ngar te, “Mut lua mnor mang dok va E Titou e. Enangthe mupa mnor mang dok, va mup kle ka mnor mang E Titou kat.” ");
INSERT INTO sua_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","E Yesus ta rere orom o rhek ri ko tok ko ta patter o mia kun mnam E Nut ka maksien ka mhe to ko rkieng a mhe to kmelpas orom o krek ruk o mia ngma nngiar ngang E Nut ormar. Ta patter mar ma mmok enang tok, vanangko nong a mhel tang ta kpom, ngar kmim kngam a yoror, ekam ko ka kolkha tlo pis vop. ");
INSERT INTO sua_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","To e Yesus ta kta havaeng o Yuda ngalmialaol te, “Ngora ngae kparem muk to mguer kle knonhong dok, nangko mguer gia yor orom mula kerkeknen to kam keyang dok. He ekam tok, her muk ruk arhe mut lo kais hak kam ngae ko mnam a mhe to dok mruo kua re kam ngae mnam e.” ");
INSERT INTO sua_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","E Yesus karo rhek ruk endruk ngat hover o Yuda ngalmialaol ruk endruk ngaro papat to ngat kle kmo mnganang ngar mruo te, “Pathe nok ner mur kaim en mruo vor ko ta re te, ‘Mut lo kais hak kam ngae ko mnam a mhe to kua re kam ngae mnam’.” ");
INSERT INTO sua_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ngat mo mnganang ngar tok, vanangko e Yesus tgia rere vop te, “Dok nkong dok man ma volkha, nang klo pal mo ma mmie ta e. Vanang muk nkong nguk mo mmie va muk mut pal mnam a mmie ta. ");
INSERT INTO sua_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ko hera ktar khavaeng nguk he te, mguer mia yor her vgum mula kerkeknen to endo enangthe mgua lua kor mnam muk mang dok te, Endo ta vle orom a ktalhok to kam plong vle ko kim E Nut ngnik ngnik her dok msim ta arhe, dok to kom mrua havae ormok.” ");
INSERT INTO sua_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","E Yesus thavae tok to ngat kle ka mnganang te, “Te yin erieto?” Va tkoripang ngar te, “Her dok ta arhe, dok to tesgun kom mur havae orom dok tok. ");
INSERT INTO sua_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Va kuaro rhek ngarlatgep vop kam mon muk orom mularo kerkeknen ormar kat. Va Endo tmeng dok, En lminam, he koma havaeng nguk ruk mo mmie orom karo mur rhek mruo ruk kua nganik mkor.” ");
INSERT INTO sua_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","E Yesus thavae tok, vanang ngat lua mmok te, ta rere ngang ngar mang Kteit E Nut e. ");
INSERT INTO sua_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","He ekam tok, ta kle khavaeng ngar te, “Mnam a kolkha to mguak hover a ho orom A Mhel To Nkong Man Ma Volkha to dok, to endo yek mguera mnor mang dok te, her dok ta arhe endo kom mrua havae ormok tok. Ii, mnam a kolkha to endo kat gi, mguera mnor mang dok kat te, kom lo is kmeharom a ngaeha tang orom kotaro mur serppak mruo tuk e. Nove! Kom gia rere kmikkiem lsir gi enang ko E Titou nma kaenang dok. ");
INSERT INTO sua_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ii, Endo tmeng dok nma vle mo kmok he lua parem dok e, ekam ko kom gi kaeharom o keknen ruk En nma higiang ngar.” ");
INSERT INTO sua_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","E Yesus tgia rere kngae ko tok, va o mia ngarlatgep ruk ngta ngan karo rhek ruk endruk ngat kle kor mnam mar mang en he kmokpom kar ko gi. ");
INSERT INTO sua_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","To o Yuda ruk ngat kor mnam mar mang e Yesus he kmokpom kar kuo mang ngaro gi pkor, e Yesus te ktua reng ngar te, “Endruk ngma vle pum kuaro rhek, her mar kolngunes msim ruk ormar arhe. ");
INSERT INTO sua_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ii, mguaka vle pum kuaro rhek tok, va mguera mnor mang dok to la minar to dok. He ekam tok, dok to la minar ngora hong nguk pum o vrong serppak tgus ruk ngma kpom muk kserpagam muk.” ");
INSERT INTO sua_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Va ngat koripang te, “Hai-e, her mor ri arhe endruk e Ebrehem ta plam ngua ngausie msim. Va mor e Ebrehem kaores msim ormor kat he. To nngia ko ya havae te, ngira hong ngor pum o vrong serppak ko mor ngot ngae lo vur vle pum a serppak tang hak ko nong a tomhel lang ka serppak ta kpom mor kserpagam mor hak!” ");
INSERT INTO sua_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Va e Yesus ta kle kpatter mar kmoripang ngar te, “Ko smia mien ngang nguk te, endruk ngama vle pum o kerkeknen mekam ngma khenam mar ma mmok te, nong ngaro serppak ngang ngar kam mrua hong ngar pum ngaro kerkeknen ruk endruk ko ngama kpom mar kserpagam mar. ");
INSERT INTO sua_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","He kmikkiem gi enang tok, a kayie to nam gi kaeha ngang ka taven, nong ka serppak mruo ngang hak kun mnam ka taven ka valngan kat e. Gi a taven to endo khal msim ka serppak ngang kun mnam kteit ka valngan. ");
INSERT INTO sua_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","He ekam tok, E Nut Khal msim to dok orom kua serppak kho mi kut kais hak kam hong nguk pum mularo kerkeknen ruk o pos ngaro serppak ngma mon muk orom mar. He ekam tok, enangthe kopa hong nguk pum mar tok, va mularo pkor ngara parhi ko o pos ngaro serppak ngar lo kat kais kam kta kpom muk hak kam mon muk ormar enang tok kat e. ");
INSERT INTO sua_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Vanang kua mnor mang nguk. Si e Ebrehem ta plam mula ngausie va muk kaores msim, vanangko muma khanang nguk kmim dok ge, ekam ko muma kees kam ring mnam muk mang kuaro rhek. ");
INSERT INTO sua_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ii, E Titou to tmia plam dok, koma rere mang karo keknen ko ta khenam mar ngang dok ko koma vle ko kim. Vanangko muk muma kees kat kam vle pum kuaro rhek ruk endruk e, ekam ko mum le ktua svil kam vle pum endo ta plam muk karo keknen ko nma havaeng nguk kmeharom mar ge.” ");
INSERT INTO sua_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ngta ngan karo rhek tok to kle kreng te, “Endo ta plam mor her e Ebrehem msim to arhe.” Va e Yesus tkaekon ngang ngar te, “Mularo keknen ngam lua khenam te, muk e Ebrehem kaores e. Ko enangthe e Ebrehem msim to ta plam muk, va mup sim kaikkiem karo keknen ruk en mruo nam kaeharom mar kat. ");
INSERT INTO sua_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mu vokom na, tete dok ko gi her havaeng nguk orom o papat ruk o minar, endruk ko nganik ko mkor E Nut, vanang muk mum kle kaikkiem a papat langto gi, endo kam khanang nguk kam por dok kngam dok a yoror. Nang e Ebrehem nam lo eharom a keknen ta gi. ");
INSERT INTO sua_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ii, mum lo kaikkiem o keknen ruk mkor munges e Ebrehem e. Mum kle va kaikkiem o keknen ruk mkor endo lsir tmi plam muk.” Ngta ngan e Yesus karo rhek ruk tok, to ngta kner kam re lsinvi te, “Ai, mor ngot mia mnor mang endo tmia plam mor, her En ngor Teit msim E Nut tuk arhe, nang ngoornek ngat lo lol mor kilturvek, enang ko inan tkol yin tok e.” ");
INSERT INTO sua_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Va e Yesus tkoripang ngar te, “Enangthe lmien mang nguk te, mu Teit msim to E Nut, va mup kaelongtok mang dok, ekam ko ko her ottek ko kim her E Nut arhe. He tete ko her aol ngte kim muk he. Klo mrua kansgum dok kam pis mo orom kua serppak mruo e. Nove, vanang her E Nut msim arhe to tmeng dok kmaol ngte. ");
INSERT INTO sua_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Vanang kman ko mut lua mmok mang kuaro rhek vop? Te mut lua mmok vop ekam ko muk mruo mum mi mrua tok pelam muk ha. ");
INSERT INTO sua_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ii, muma vle tok, ekam ko tennik ko E Nut tlo kueng a mmie vop, e Seten to tmi plam muk msim ta kees kam vle pum o rhek ruk o minar kat e. Ko nop a vur papat tang ko a minar hak kun mnam gi. Ko en a ho vu ppiagar hak. Ii, ko en nma rere va nma rere orom ka re mruo to orom karo rhek ruk la ppiagar ekam ko nam vua ppiak ormar. Va o gi vrong rhek tgus ruk la ppiagar ngam kottek mkor her en mruo arhe, ekam ko en o vu ppiagar ngar teit msim to en arhe. Ii, tennik tmur hong en mruo pum o rhek ruk o minar tok petgim mar, to kle khortgi kam vle te, a pormia msim. He ekam ko muma svil kmikkiem e Seten ka svil mruo, endo kam pormia enang tok kat, va ta khenam muk mruo ma mmok te, her endo a vu ppiagar mu teit msim arhe, endo tmia plam muk. ");
INSERT INTO sua_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","He ekam ko koma rere ngang nguk orom kuaro rhek ruk o minar enang ti tete, mum ho mi ktua kees hak kmor mnam muk mang dok he kmokpom kar dok. ");
INSERT INTO sua_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ii, kua mien ko nop a mhel tang tkais kmel dok ma mmok he kam mon dok orom a kerkeknen tang hak. To enang tok, ekam ko koma mien ngang nguk orom kuaro rhek ruk o minar ruk endri, va kman ko muma kees ge kam lol he kor mnam muk mang dok pum mar he kmokpom kar dok? ");
INSERT INTO sua_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mu vokom na, gi ekam ko muma kees kam lol kuaro rhek ruk o minar ruk endruk he lua kor mnam muk mang dok pum mar kam mokpom kar dok, va tmia khenam muk ma mmok kat te, muk nop E Nut kles msim e, ekam ko E Nut kles msim ngma lol karo rhek ruk o minar he kor mnam mar mang En pum mar he kmokpom kar ge.” ");
INSERT INTO sua_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","E Yesus ta re tok, to o Yuda ngalmialaol ngat kaekon ngang vat te, “Nok ngot lua mien miik vor, ko ngota re te, a Samaria to yin, endo a koot tenvevem?” ");
INSERT INTO sua_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","E Yesus ta klai ngang ngar te, “O-o, nop a koot tang tkaenvevem dok e. Nove, kom kle va smia totu pum E Titou, vanang muk mum kle va ka kpiem dok hak. ");
INSERT INTO sua_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kom lua vle pum a papat to kam mrua hover dok mruo e, vanangko E Titou nama vle pum a papat to kam hover dok, he her En arhe nera mon muk orom mularo kerkeknen. ");
INSERT INTO sua_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Lmien ko kua havaeng nguk te, endo nma vle pum kuaro rhek, E Nut ner lua mon orom karo kerkeknen he kael en kam yor vgum mar hak.” ");
INSERT INTO sua_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","O Yuda ngalmialaol ngta ngan e Yesus karo rhek ruk endruk to ngta re lsinvi te, “Pusner ko tete ngota mnor yin yek te, a koot ther mi kaenvevem yin he. Ko e Ebrehem tyor va o propet ngat yor kat va yindo yi sia re te, endo nama vle pum ilaro rhek ner lua yor gi? ");
INSERT INTO sua_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Anito? Ye ho laut gi, kir kim ngores e Ebrehem? Ko en tmi yor hak hak he, va o propet kat! Ya mrua kansgum in kmel in aniem to?” ");
INSERT INTO sua_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Va e Yesus ta kle kre te, “Enangthe dok atgiang tuk ko ko mrua kansgum dok kam mrua hover dok mruo, va kuaro rhek ngat lo is kmaur e. Vanangko gi E Titou to E Nut, Endo mum mrua havae mang nguk te, muma plong totu pum, her En arhe nma hover dok. ");
INSERT INTO sua_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ii, nok mut lua mnor mang Endo vor. Vanang dok kua mnor mang. Kopa re te, klua mnor mang Endo, to dok kat a vu ppiagar enang nguk. Vanangko ko mi ktua mnor mang va koma vle pum karo rhek kat. ");
INSERT INTO sua_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Munges e Ebrehem nma sirei mang a papat to kam vokom a venloot to kua vle mnam tete. Va lmien te, ther vokom a venloot to enda he, to her le ksirei mang kat.” ");
INSERT INTO sua_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","To o Yuda ngalmialaol ngat kle ka kner e Yesus lsinvi te, “Nong yin a hipun vop, va ye her vokom e Ebrehem he?” ");
INSERT INTO sua_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Va e Yesus tkoripang ngar te, “Kua havaeng nguk lmien te, E Ebrehem nop vop, vanang dok ko ktar vle.” ");
INSERT INTO sua_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","O Yuda ngalmialaol ngat ngan e Yesus karo rhek ruk tok mnam E Nut ka maksien ka mhe to ko ma gi vle, to ngat lol o krek kam lalaem ormar, vanang e Yesus ta tutvok he vur aol kmottek parem a maksien to endo. ");
INSERT INTO sua_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","E Yesus tparem mar ko tok, nang kle kngae kaikkiem a ngaelaut kngae, va vgum a mhel langto ko tvipsik, ko knan tkut kol tok he. ");
INSERT INTO sua_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","To E Yesus kalngunes ngta mnganang te, “Pattermia, erieto karo kerkeknen ngat kamliker he knan tkol ko a vivisker, en mruo, i o kteit kar knan?” ");
INSERT INTO sua_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Va E Yesus tkoripang ngar te, “Nop karo kerkeknen mruo, va nop kteit kar knan nginaro kerkeknen ruk ngat kamliker he tvipsik e. Knan tkol a vivisker enang tok, he nang E Nut kam palgem va kpolger ka serppak vgum her enang tok arhe. ");
INSERT INTO sua_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","Mnam a venloot to kua vle mo mmie koma vle enang a kolkha to nma valler o mia he ka mmok kim mar. Ii, a kolkha to endo her dok ta arhe. He ngua vrua nan kim o mia tgus mo mmie na, to endo yek ngruak kaeharom o reha ruk mkor Endo tmeng dok. Ko koknaik nguak ngae kparem muk to nera vle enang a segain he a mhel lang ner lo kat kais kmeha kat e.” ");
INSERT INTO sua_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","E Yesus ta re tok, to kle kguspa ku mmie to ktaem a mmie kmeharom ke paat. To ta hemhem endo tvipsik kalo keik orom. ");
INSERT INTO sua_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ta hemhem kalo keik to kreng te, “Ngiak ngae he kaelel ilalo keik kuo mnam a ngaenker to e Siloam.” (A ngaenker ka munik ta ka pun ta vle te, “Meng.”) E Yesus ta meng kmelel kalo keik tok, to a mhel ta, tgia ngae kaelel kalo keik to her gi kaeknik gia nho ngatngae, to hera ngae ngok mrek. ");
INSERT INTO sua_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tkaeknik ngok mrek, to klenar va o mia akuruk, endruk ngma vokong tesgun ko nam korsang he ka vle kaurur kio mia va kngangrang ngar ngta mo mnganang ngar te, “A mhel to nam korsang he ka vle kngangrang ngar enda arhe?” ");
INSERT INTO sua_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Va o mia akuruk ngta havae te, “Lmien, enda arhe.” Vanang akuruk yok ngta havae te, “O-o, nove. Tgia nho enang a mhel to endo.” Vanangko en mruo, ta mrua havae mang en mruo te, “Mare! Her dok ta arhe!” ");
INSERT INTO sua_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","To o mia ngat kle ka mnganang te, “Havaeng ngor na, nngia va yan, ko ye kta nho kat?” ");
INSERT INTO sua_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Va a mhel to endo tkoripang ngar te, “A mhel to ngma mon te, e Yesus ta guspa ku mmie he ktaem a mmie kmeharom ke paat to khemhem kualo keik orom. Ta hemhem min, to kreng dok kam ngae kaelel kualo keik kuo mnam a ngaenker to e Siloam. To kua ngae kaelel kualo keik to re kaeknik va kle her gia nho he.” ");
INSERT INTO sua_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ngta ngan a mhel to endo ko ta re tok, to kle ka mnganang lesik te, “Va endo ya rere mang ngnamrie?” Va ta havaeng ngar te, “Klua mnor gi.” ");
INSERT INTO sua_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Vanang a kolkha to a Sabat to arhe ko e Yesus tguspa ku mmie he ktaem a mmie kmeharom ke paat to khemhem a vivisker to endo kalo keik orom he en ta kta nho kat. He ekam tok, o mia ngta nglum a vivisker to endo kngorom ngok kim o Parisiau. ");
INSERT INTO sua_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ngata srim a mhel to endo ko kim o Parisiau to mar kat ngat le ka mnganang mang ko nngia he ta kta nho kat. To a mhel to endo tgi havaeng ngar te, “Ta guspa mang a mmie he ktaem kmeharom ke paat to khemhem kualo keik orom. To ko ngae gi kaelel kualo keik to tete kua nho he.” ");
INSERT INTO sua_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","To o Parisiau akuruk ngata mo reng ngar mruo te, “A mhel to teharom a ngaeha to endo tlo ottek ko kim E Nut gi, ko tlua totu pum ngua kolkha to a Sabat e.” Vanang akuruk ngat kle va ka mngan pum ngarlenar ruk o Parisiau kat te, “Nngia ko a mhel to ta ru mnam o kerkeknen tkais kmeharom a ngaelmir to a serpgar enang endo?” To ngta mo kokheng ngar kmommen mar mruo mang. ");
INSERT INTO sua_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","O Parisiau ngta mo kokheng ngar tok knop, to her kle kta mnganang a mhel ta kat gi te, “Her ilalo keik arhe tehang ngin he ya nho, to ngia re nngia mang?” Va a mhel ta, ta koripang ngar te, “En a propet langto.” ");
INSERT INTO sua_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Vanang a mhel to endo tpu vle te, tesgun en a mi vivisker he tete ta kta nho kat, vanangko o Yuda ngalmialaol ngat lo vu kor mnam mar mang o rhek ruk mang tok gi. To ngat vaeng kteit kar knan he ka mngan ngin mang. To endo yek ngat kor mnam mar mang o rhek ruk endruk. ");
INSERT INTO sua_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ko ngat vaeng ngin he ka mnganang ngin te, “Me hal ta ngola, endo mae meta havae te, knan tkol a vivisker? Vanang nngia ko tete ta nho?” ");
INSERT INTO sua_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Va kteit kar knan ngint koripang ngar te, “Mota mnor he te, mo hal ta arhe, va mota mnor kat te, knan tkut kol a vivisker tok kat gi, ");
INSERT INTO sua_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","vanang mot lua mnor mang ko nngia he ta nho, va mot lua mnor kat mang a mhel to teharom kalo keik he ta nho e. Mu mnganang en mruo, ko tlaut he, he en tmur kais kam mrua havae mang en mruo.” ");
INSERT INTO sua_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kteit kar knan nginta re tok, ekam ko nginta gorang o Yuda ngalmialaol ko tesgun ngata ktar lgem o rhek te, ani mhel to na mrua havae mang e Yesus te, En Endo E Nut Thim Orom Ka Msasaen ngak likim a mhel to endo kam kser, he en kam lo kat kaum ktotu pum E Nut kar mar kat kun mnam o Yuda ngarta rek to kam rere mnam. ");
INSERT INTO sua_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","He ekam ko nginta gor tok, nginta havaeng o Yuda ngalmialaol te, “Mu mnganang en mruo, ko tlaut he, he en tmur kais kam mrua havae mang en mruo he.” ");
INSERT INTO sua_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","To ngata kta vaeng a mhel to kam kta sir ko kmar, to ngata havaeng lserppak te, “Ngota havaeng yin tete kam smia re lmien mo pum E Nut kalo keik he. Ko ngota mnor mang a mhel to endo te, en a mhel to ta ru mnam o kerkeknen gi.” ");
INSERT INTO sua_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Va ta reng ngar te, “Klua mnor te, en a mhel to ta ru mnam o kerkeknen o nop, vanangko ko gia mnor mang a tomhel atgiang ta te, tesgun ko vipsik vanang tete kua nho he.” ");
INSERT INTO sua_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Thavae tok, to o Yuda ngalmialaol ngta kta mnganang kat gi te, “Teharom in nngia he ya nho?” ");
INSERT INTO sua_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Va thavaeng ngar te, “Ko her havaeng nguk nanga he va mut lua ngnek gi? Kman ko muta svil dok kam kta votam kuaro rhek? Nok pathe muta svil kam vle te, en kalngunes ormuk kat vor?” ");
INSERT INTO sua_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ngata ngnek tok, to ngat kle kpetpet o rhek ngang kam klel orom he ho ksisieng hak kam reng te, “Ai, her yin arhe to en kalkayie ormin, vanang mor e Moses kalngunes ormor. ");
INSERT INTO sua_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ngot ho mi kut mnor hak te, E Nut tmi rere kar e Moses. Vanang mang a mhel to endo ya rere mang ngot ngae ho lua mnor mang gi, ko tpal mnam ani pupnam to.” ");
INSERT INTO sua_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ngat havaeng a mhel to tok, va en tkoripang ngar ge te, “Ai, ko ho mi kut senkrip kim muk hak ekam ko a mhel to endo teharom dok tok tete, he kua nho, va muk mut lo is gi kam kol a pat mang te, tottek tam? ");
INSERT INTO sua_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","33","Tennik kam ngae kais mang tete, o mia ngat lo vur ngnek hak mang a mhel lang te, en kmeharom kaela ngang ko tvipsik, en kam nho e. Mu vokom na, enangthe a mhel ta nap lo kottek ko kim E Nut va nap ho lo is hak kmeharom a ngaeha tang ko a serpgar enang endo enda teharom ngang dok tete. Nap lo is enang tok, ekam ko ngota mnor mang E Nut te, nam lua ngan vgum endruk ngta ru mnam o kerkeknen gi. Nove, nam kle ktua ngan vgum endo nam sim kut kaikkiem karo pos va kaeharom karo svil ge.” ");
INSERT INTO sua_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","To ngat koripang a mhel to te, “Her yin arhe, endo E Nut nam lua ngan vgum, ekam ko inan tkut kol in ko yin a vivisker va ta khenam yin ma mmok te, yin yi her ho ru hak mnam o kerkeknen. Ya re kam patter mor he lua ruokar kim mor gi?” Ngat re tok, to hera likim ka kser hak kam lo kta vaik kun mnam o Yuda ngarta rek to kam rere mnam kam kaum totu pum E Nut kar mar. ");
INSERT INTO sua_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","E Yesus tkol a re te, ngata kser a mhel to tvipsik ti, to vur koknaik ta puknim a mhel to endo ekam a ngaelaut to ka mnganang te, “Yi kor mnam yin mang A Mhel To Nkong Man Ma Volkha he?” ");
INSERT INTO sua_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Va a mhel ta, ta mnganang te, “Sim havaeng dok na mang ani mhel to en, nang dok kmor mnam dok mang.” ");
INSERT INTO sua_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Thavae tok, to e Yesus thera reng te, “Yi her vokom lsir tete he, ko her dok ta arhe, ko mrua rere kar yin mo arhe.” ");
INSERT INTO sua_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","A mhel ta, tgia hop ku to kre te, “Koldaip, ko kor mnam dok mang in he.” To ta tubulkek ku penharom e Yesus he ktotu pum. ");
INSERT INTO sua_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","E Yesus ta re te, “Ko kaol ngte mmie kmommen o mia, ko endruk ngta vle enang o vivisker nga vokom ka mnor dok to le kor mnam mar mang dok he kmokpom kar dok. Vanang endruk ngma vokom kuaro reha ruk endruk he kees kmor mnam mar mang dok he lua kmokpom kar dok, mar ngam kle ka vle enang o vivisker enang tok.” ");
INSERT INTO sua_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","To o Parisiau akuruk ngta vle ko kim e Yesus kat. Ngta ngan ko ta rere tok, to ka mnganang te, “Lmien te, yi lua rere kvat mor gi, ko ya re te, mor o vivisker?” ");
INSERT INTO sua_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Va e Yesus tkoripang ngar te, “Enangthe mup mrua havae orom muk mruo te, muk o vivisker to le kor mnam muk mang dok he kmokpom kar dok, va E Nut na lo kat kais kam mon muk orom mularo kerkeknen gi. Vanangko ekam ko mut mrua rere kvat muk mruo te, mut lua vipsik, va muk gi, ta nho enangthe E Nut na kle va kmon muk orom mularo kerkeknen gi.” ");
INSERT INTO sua_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","5","To e Yesus ta le kta rere te, “Ko smia mien ngang nguk te, a mhel to nma vaik ko vo sipsip nga hengor ka gudor msim, en a mhel msim to nma nho mang karo sipsip va endo nma vle ktoot ko va gudor nma koregot kim her endo arhe. Va her a mhel to msim arhe nma mon karo sipsip mruo ngaro mnok msim kam ktong ngar petgim a hengor, va karo sipsip ngam kaikkiem ko ngma ngan ka ktui ka mnor. Nma ktong karo mur sipsip mruo tgus petgim a hengor to nma ktar mang ngar va karo sipsip ngam kaikkiem ekam ko ngma ngan ka ktui ka mnor. Vanangko a mhel lang ko yok, endo nam lua vaik ko va hengor ka gudor ko nam kle gia pa ko yok, en a mhel to a ngauruvik to ta svil kmaurur o sipsip ruk endruk. Ii, va o sipsip nga ho lo is kmikkiem a mhel to endo hak ko ngat lua mnor mang e. Nove, ngam kle gia ngorpgom a vrong mhel to enang tok, ko ngam lua mnor mang ko kta ktui gi.” ");
INSERT INTO sua_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","E Yesus tkothoi ngang o Parisiau orom ke ngothoi to endo, vanangko ngat lua mmok mang karo rhek ngo pneik e. ");
INSERT INTO sua_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","He ekam ko ngat lua mmok mang karo rhek ruk endruk, tle khalger ngang ngar te, “Ko smia mien ngang nguk te, dok ko kaenang a hengor ka gudor to o sipsip ruk o mia kam vaik ku meorom E Nut ka tavgo ko vgum. ");
INSERT INTO sua_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Endruk tgus hak ngata ktar kpis mo ktar mang dok kam vle enang dok, mar o ngauruvik ruk ngta svil kmaurur o sipsip. Vanang o sipsip ruk o mia, ngam lua ngan vgum mar gi. ");
INSERT INTO sua_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ii, her dok ta arhe endo tkaenang a gudor. Va ani mhel to ta vaik ku meorom E Nut ka tavgo ko va gudor to dok, E Nut nera sulgim he klol karo kerkeknen patgiang ngaiting he kikiangae mang ngar hak. Va ner gia vle lya hak, he ho lua gorang a tomhel tang hak ko kim. ");
INSERT INTO sua_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ii, mu vokom na, a ngauruvik nama ngae kpis kmuruvik, va kaus va kam kering o tgoluk. Vanang dok ko her mi ktua pis kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang endruk ngma ngan vgum dok, va mar kam her gia ktal hak orom tok he. ");
INSERT INTO sua_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ii, va a toot kmo o sipsip her dok ta kat arhe. Ko endo nam smia nho mang o sipsip nam mrua slak orom en mruo kam yor mang ngar, he khos kim mar. ");
INSERT INTO sua_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Endo yok to tgi kaeha kmo krek kam nho mang o sipsip, nong en msim to nma nho mang o sipsip ko nong kakro sipsip mruo ruk e. Ii, ko na re kvokom a pendol ko tkaol, va nera ngorpok kparem o sipsip. To a pendol na kaop ekam a murgun to orom o sipsip he kseneker mar. ");
INSERT INTO sua_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ii, endo tkaeha kmo krek nera ngorpok tok, ekam ko tgi kaeha kam lol o krek, nang tho lua pat mang o sipsip e. ");
INSERT INTO sua_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Enang ko kua re, endo nam smia nho mang o sipsip her dok ta arhe, va kua mnor mang kuaro sipsip va mar ngata mnor mang dok kat. ");
INSERT INTO sua_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ta vle enang tok, gi enang ko E Titou ta mnor mang dok va dok kua mnor mang E Titou tok kat. Ii, kua mnor mang ngar he gia slak ormok kam yor mang ngar, he khos kim mar. ");
INSERT INTO sua_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Va akro sipsip akuruk yok ngang dok kat, ko ngat lo kaum ka vle kar muk mo ma hengor ta vop. He nguak le kvaeng ngar kam vaik kun ma hengor ta kat. Nguak vaeng ngar va ngak ngan kua ktui, he ekam tok, koknaik mar kat ngara ngan vgum dok he kaum ka vle kar kuaro sipsip akuruk kat kun mnam a murgun to agitgiang orom nga toot kmo sipsip to agitgiang to dok tok kat. ");
INSERT INTO sua_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","E Titou tkaelongtok mang dok ekam ko dok mruo ko mrua slak ormok kam yor mang o sipsip he khos kim mar, he nang dok kam mi ktua hop petgim kua nnak kat. ");
INSERT INTO sua_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Dok mruo kom mrua slak ormok mruo, kmikkiem kua mur svil mruo, nang nong a mhel tang hak tsopong dok kam yor tok e. Kmikkiem kua mur serppak mruo to E Nut tel kuo malpgem dok, kua tting mang dok mruo kam yor va kam kta hop kat. Va a serppak to ko her kol, he nang dok kam yor he kta hop tok, tottek ekam E Titou ko her En arhe to ten a re to a serpgar ngang dok kmeharom tok.” ");
INSERT INTO sua_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","O Yuda ngalmialaol ngta ngan e Yesus karo rhek ruk endruk to ngta kta mo maen o rhek mang he kmommen mar mruo ekam tok. ");
INSERT INTO sua_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Akuruk mnam mar ngat havae te, “A koot tviging he, he kho envevem hak. Ngot lo is kam ngan vgum e!” ");
INSERT INTO sua_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Va akuruk yok ngat kle kokheng ngarlenar te, “A mhel to a koot tviging nam lua rere orom o rhek ruk tok e. A koot tis kmeharom a vivisker kalo keik, en kam nho?” ");
INSERT INTO sua_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kun mnam a venloot to a ven, a kolkha langto tpis, endo o Yuda ngma kunngir kim mo pnes tgus kam pat mang ngalmialaol ko ngat kat el a totu mang E Nut Ka Maksien Ka Rek Ke Taban To A Ho Totur Hak. To lYerusalem ngat kaem pnes. ");
INSERT INTO sua_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","To mnam a kolkha langto ko o Yuda ngat kaem a pnes to endo vop, e Yesus ta vle kun mnam E Nut ka maksien ka mhe to ngma mon orom E Solomon. A mhe to endo ngat ngam a rek ka gi keik tuk kuon malpgem orom o ngtek ngarlakhor. Va e Yesus ta vle kpunpa ko tok ");
INSERT INTO sua_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","to o Yuda akuruk ngat kaum kpis ko kim he ka mnganang te, “Ngira polger ilaro rhek ruk mang in mruo nganngor, he mor kam lo kta lopumtang pum in? Ngiak havaeng ngor lsir na te, Endo E Nut Thim Orom Ka Msasaen her yin arhe i o nop?” ");
INSERT INTO sua_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Va e Yesus tkoripang ngar te, “Ko her polgom dok he, orom kuaro reha ruk lserpgue, ko her mar ruk arhe ngma rere orom dok he ka khenam dok ma mmok te, her dok ta arhe endo E Titou tmeng ngte mmie orom ka munik kmeharom karo reha. Vanangko muma kees kmor mnam muk mang dok tok he kmokpom kar dok ge. ");
INSERT INTO sua_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ii, mut lua svil kmor mnam muk mang dok tok, ekam ko muk nong kuaro sipsip mruo ruk muk e. ");
INSERT INTO sua_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ko kuaro sipsip mruo ngma ngan kua ktui kam mnor mang dok he kaikkiem dok, he dok kua mnor mang ngar kat. ");
INSERT INTO sua_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Va her dok ta arhe endo nam kaen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang ngar. Va koknaik koknaik kat ngat lo is kam yor hak, ekam ko nong a mhel tang to tis kam vret mar mo maktiegom dok petgim dok e. ");
INSERT INTO sua_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ii, E Titou to tel mar maktiegom dok ta laut kir kim o vrong tgoluk tgus, he ekam tok, nong a mhel tang to tis kam vret mar ko maktiegom En petgim En kat e. ");
INSERT INTO sua_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ta vle enang tok ekam ko E Titou kar dok tgus moma vle te, mot gi mo enang nguo.” ");
INSERT INTO sua_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","E Yesus ta re tok, to o Yuda ngata kta lol o krek kam lalaem orom mar, ");
INSERT INTO sua_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","vanangko e Yesus tle khavaeng ngar te, “Ko her mrua khenam E Nut karo reha ruk lserpgue ma mmok mo maktiegom dok. Va mu havaeng dok na, mut re kam lalaem dok mang edim mnam mar?” ");
INSERT INTO sua_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","To o Yuda ngalmialaol ngat koripang te, “Ngot lua re kam lalaem yin mang ilaro reha ruk endruk e. Vanangko ngot re kam lalaem yin ekam ko yi her kerrereng E Nut tok arhe ko yin a gi mhel e, nang yi kle mrua mon yin te, yin E Nut msim.” ");
INSERT INTO sua_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ngat havaeng e Yesus tok, va tle koripang ngar te, “Tennik ngat ittiegom E Nut karo mur rhek akuruk ngang nguk, endruk kun mnam muk o Yuda mutaro pos mruo te, ‘Ko her mon muk lIsrael te, her muk ruk arhe muta vle enangthe muk kar E Nut mut gi mo enang.’ ");
INSERT INTO sua_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mu vokom na, her muk ruk lIsrael arhe, endruk tennik E Nut ten karo mur rhek mruo ngang nguk va le kmon muk te, her muk ruk arhe muta vle enangthe muk kar E Nut mut gi mo enang. E Nut tmur mon muk tok, va nong a mhel tang to tis hak kam kser karo rhek ruk endruk e. ");
INSERT INTO sua_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ii, he ekam ko E Nut ther mon muk ruk o gi mia tok, va muta pat nngia mang dok to E Nut mruo tmur re pum dok kam vle ngang En mruo he kmeng dok ngte mmie kam sir orom En? Va kman ko muta mon dok orom a kerkeknen to kam kerrereng E Nut orom kuaro rhek ruk ko kua havaeng nguk ormar te, ‘E Nut Khal to dok’? ");
INSERT INTO sua_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ko mrua mon dok tok, vanang mguak or kmor mnam muk mang dok vgum kuaro gi rhek ri e. Gi enangthe mgua kle kvokom E Titou karo mur reha ruk lserpgue ko maktiegom dok, to endo yek mguak kor mnam muk mang dok ekmar tok! ");
INSERT INTO sua_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Si mut lo kor mnam muk mang kuaro rhek, vanangko mupa kle kor mnam muk mang E Nut karo reha ruk lserpgue, endruk nam kaeharom mar ko maktiegom dok gi, he nang mar kmel muk ma hor mang dok, muk ka mnor mang dok te, E Titou va dok, muo tgus moma vle te, mot gi mo enang nguo.” ");
INSERT INTO sua_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","E Yesus ta re tok, to o Yuda ngata kta papat kam kleng singni mnam, vanangko tvur vros aol kun pgegom mar. ");
INSERT INTO sua_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","To e Yesus ta ngae ngkun kut pekam a ye to e Yodan ka ngaiting tigut, ko mnam a mhe to e Yoanes nma parrum o mia mnam o kolkhek ruk tesgun. Va ta vle ko tok, ");
INSERT INTO sua_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","he o mia kavurgem ngma pis ko kim kam ngan karo rhek. Va ngama mohavaeng ngar mruo mang e Yesus te, “Pu lmien te, E Yoanes tlo eharom a ngaeha tang ko a serpgar e, vanangko karo rhek tgus ruk mang a mhel to enda ngta mien.” ");
INSERT INTO sua_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","He ekam tok, o mia kavurgem ngat kor mnam mar mang e Yesus he kmokpom kar ko mnam a mhe to endo. ");
INSERT INTO sua_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kam ngae, to a mhel langto ka munik e Lasarus ta yayor he ka vle ko mnam ka rengmat to e Betani. A rengmat to e Betani, e Maria kar kyel to e Marta ngina rengmat to kat. ");
INSERT INTO sua_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","E Maria to endo, her a vlom to ta pungnim e Yesus kalo nhar arhe orom a ku ka mten to ngma mon te, a miir to ka gri a yar va kmomgol min orom karo ngairis ruk kuo malpgem. Va klu to e Lasarus ta kru ko ma hep orom ka yor. ");
INSERT INTO sua_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","To lo mo yel ri ngint kaen a re mang e Yesus kam reng te, “Ngoldaip, ila to im vu kaelongtok mang, ta kru ko ma hep orom ka yor.” ");
INSERT INTO sua_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","E Yesus tre ngnek va ta kle gia re te, “A yor to ta kol e Lasarus, tlo is kam ngam, he en kam kru mnam ka nnak hak e! Nove, ko a yor to tkol, tkol tok, nang E Nut kam mrua khenam ka serppak ko maktiegom Khal, he nang o mia kam kanprim vgum.” ");
INSERT INTO sua_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Pu e Yesus tvu kaelongtok mang e Maria kar kyel va nginlu e Lasarus, ");
INSERT INTO sua_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","vanangko ma kolkha to e Yesus tsi ngnek mang e Lasarus ko ta yayor, va ta vle mang alo kolkha alomin ge, ko mnam a mhe to endo ta vle mnam. ");
INSERT INTO sua_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","To pekam alo kolkha ruk, ta reng kalngunes te, “Mu so mor he, ngruak kaeknik ngoguon mYudea.” ");
INSERT INTO sua_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Va kalngunes ngata reng te, “Tetku, o mia ngat re kam gnua lalaem in va kaim in ko ha, he ya re kmeknik ngok kat?” ");
INSERT INTO sua_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Vanang e Yesus ta kle gia reng ngar te, “A kolkha ke ngaego ta vop! Va ani mhel to nma ngae kun mnam a mmok to enda nam lua tunvie he kharpeet ekam a ngaelaut ge, ko nama ngae kun mnam a mmok to ta valler o mia ruk mo mnam a mmie ta. ");
INSERT INTO sua_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Vanang ani mhel to nma ngae ma slommok, her endo arhe nama tunvie he kharpeet ko ekam a ngaelaut ko nong a mmok tang ekam.” ");
INSERT INTO sua_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","E Yesus ta rere ti, to kle khavaeng ngar te, “Ngola to e Lasarus tgia kru ko ma hep e, vanangko kua ngae ngok kim kam ngae kam votgem he khover.” ");
INSERT INTO sua_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Va kalngunes ngta reng te, “Enangthe nap gia kru ko mnam a hep va ta ya ko nera ya kat.” ");
INSERT INTO sua_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","E Yesus ta re ti, mang e Lasarus ko tyor, vanang kalngunes ngat kle kpat re te, ta rere mang ko tmi onit. ");
INSERT INTO sua_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","To e Yesus tle smia havaeng ngar lsir te, “E Lasarus tmi yor he, ");
INSERT INTO sua_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","vanangko kua sirei mang nguk ko klo vle ko kim ko tyor he, he nang muk kam vokom kua ngaeha mang to kle kaelha kmor mnam muk mang dok he kmokpom kar dok. Tpu yor, vanangko ngruak ngae ngok kim ge.” ");
INSERT INTO sua_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","To e Tomas (endo ngama mon kat te, E Demas) ta reng klenar te, “Mu so mor ngurak kaikkiem, he nang mor kam kaum kyor kren tgus.” ");
INSERT INTO sua_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","E Yesus tpis va ta kol a pat mang e Lasarus te, ngat el kun mnam a kre ka nho, he ta vle mang o kolkhek ruk korlolo he. ");
INSERT INTO sua_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","A rengmat to e Betani tlo vu vle malhagenmok mang a rengmat to e Yerusalem e, ");
INSERT INTO sua_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","he ekam tok lYuda ngarlatgep ngat pagis kmonit ko kim e Marta kre Maria ko ngin lu tyor. ");
INSERT INTO sua_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","E Marta tre gia ngnek te, e Yesus tkaol, va thera ngae kam horong ko va ngaelaut, vanang e Maria tgia vle kun ma rek. ");
INSERT INTO sua_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","E Marta tpis ko kim e Yesus to kreng te, “Koldaip, ipa vle mo va ko lu nap lo yor e. ");
INSERT INTO sua_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pu tok, vanangko kua mnor te, tete E Nut ner kaen ani tomhel to ngiaka mnganang mang kmen ngang in.” ");
INSERT INTO sua_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Va e Yesus tkoripang te, “Ilu ner kta hop kat.” ");
INSERT INTO sua_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Va e Marta tkoripang kat te, “Kua mnor ko ner kta hop kat petgim ka nnak mnam a kolkha to E Nut nak hover o mia tgus mnam a kolkha to a kser kim.” ");
INSERT INTO sua_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","To e Yesus thavaeng te, “Endo tkais kam hover o mia petgim ngaro nnak kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang ngar her dok ta arhe. He ani mhel to tkor mnam en mang dok he kmokpom kar dok na si yor, nangko nera kol a ktalhok to kam plong vle ngnik ngnik ge. ");
INSERT INTO sua_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Va ani mhel to tkor mnam en mang dok he kmokpom kar dok, ner mia kol a ktalhok to kam plong vle ngnik ngnik vgum dok, nang ho lo kat kais kam yor kat e. Va yin, yi kor mnam in mang kuaro rhek ri kat?” ");
INSERT INTO sua_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Va e Marta tkoripang te, “Koldaip mare, koma kor mnam dok mang in te, Endo E Nut Thim Orom Ka Msasaen her yinda arhe, E Nut Khal to yin, Endo mor o Yuda ngota paneng kmaol kpis mo mmie.” ");
INSERT INTO sua_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","E Marta ta re tok, to kaeknik kpis vrua vaeng kyel lvongnek he khavaeng te, “A Pattermia tpis he, he kmamngan miik.” ");
INSERT INTO sua_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","E Maria tre gia ngnek tok, va thera hop ku va kmarer kottek he kngae kam ngae kpis mang e Yesus ");
INSERT INTO sua_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ko tgia vle ko mnam a mhe to e Marta thorong ko va ngaelaut ko tlo pis ko mrek vop. ");
INSERT INTO sua_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Va o Yuda ruk ngta gun kun ma rek kmonit ko kim e Maria ngat kaikkiem kat ko ngta vokong ko ta hop he kmarer kmottek. Ngata pat re te, ta ngae ngok ma mhe to ngat el klu mnam kam ngae kaetim. ");
INSERT INTO sua_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","E Maria ta puknim e Yesus ko va ngaelaut to tre gia vokong to mrua ngam ku penharom he kreng te, “Koldaip ipa vle mo, va ko lu nap lo yor e!” ");
INSERT INTO sua_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","E Yesus ta vokong e Maria kar o Yuda ruk ngat kaikkiem ko ngat vua sovet kmaee tgus he ka vrek te sei kam horotgi va te sovet kam mrung ngar hak. ");
INSERT INTO sua_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","To ta mnganang ngar te, “Mut tel tam?” Va ngat koripang te, “Ngoldaip, aol he mur vokom.” ");
INSERT INTO sua_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","To e Yesus tkaeti. ");
INSERT INTO sua_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","O Yuda ngata vokong ko tkaeti, to kre te, “Mu vokong na, kela tvu kaelongtok mang kaela ko te sei kam mrung he.” ");
INSERT INTO sua_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Vanang akuruk mnam mar ngata kle krere pum te, “A mhel to, tgia re va kaeharom a vivisker he ta kta nho kat ngola? Va kman ko tlo eharom e Lasarus tie tok, enang tok kat, he en kam lua yor?” ");
INSERT INTO sua_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","E Yesus tre kngae ngok va nnak va ka vrek te sei kam horotgi kat. Ko va nnak to a kre ka nho, ngat vulhagam a kre to alautar ko va gudor kam tokim. ");
INSERT INTO sua_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tpis ngok, to ta reng o mia te, “Mu pet a kre petgim a nho na.” E Marta to klu tyor treng e Yesus te, “Koldaip, a mhel ka gri ner kaim mor ko ngat el he ta vle mang karo kolkhek ruk korlolo orom endo tete he.” ");
INSERT INTO sua_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Va e Yesus tkoripang te, “Ko her havaeng yin he te, enangthe ip kor mnam yin mang dok he kmokpom kar dok va ngir mia vokom E Nut kla serppak ko maktiegom dok!” ");
INSERT INTO sua_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","To ngata vulham a kre petgim a kre ka nho, to e Yesus ta langtar ngpalmai oguon ma volkha to kngarkie te, “Kua kanprim yin Titou ko yi her ngan vgum dok tete he, ");
INSERT INTO sua_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","gi enang ko kua mnor ko ima ngan vgum dok tok. Vanangko kua kanprim yin mang a papat ta kam hover a mhel to enda, he nang o mia ruk ngta sir mo, mar kmor mnam mar mang dok te, her yin arhe yindo ye mi meng dok ngte kim mar.” ");
INSERT INTO sua_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ta rere tok, to ta vae kuon mail orom e Lasarus te, “Lasarus, hop he ottek.” ");
INSERT INTO sua_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","To a yor to e Lasarus ta hop he kottek orom o it ngakro kaenatok tgus ruk ngma rorot mang o yor ormar, ko ngat rorot mang ka vok tgus he ktokim kalo ktiek va kalo nhar. Va a yet ka kae langto ngat rot mang ka lpek orom kat. Tottek tok, to e Yesus thera reng ngar te, “Mu halager o it kuo mang he orim, en kam ngae.” ");
INSERT INTO sua_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","He ekam tok, o Yuda kavurgem ruk ngat aol kmonit ko kim e Maria va kvokom e Yesus ka ngaeha to teharom ngat kor mnam mar mang en he kmokpom kar. ");
INSERT INTO sua_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Vanang akuruk mnam mar ngat kle kngae ngok kim o Parisiau to khavaeng ngar mang a ngaeha to e Yesus tgun eharom he. ");
INSERT INTO sua_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","To o Parisiau kar akuruk mnam o pris ruk laol ngata vaeng nglenar tgus ruk ngma vaik kun mnam o Yuda Ngar Ke Murgun to ngma mon te, a Sanhendren, mar kam kaum kam rere. Ngat kaum he kmo mnganang ngar mruo te, “Ngruak kan e? Ko a mhel to endo, nam kaeharom o ngaelmir ruk lserpgue ngarlavurgem hak. ");
INSERT INTO sua_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Enangthe ngurak korim he nak kaeha ka vle ti kngorom kngorom, va o mia kavurgem ngar ho gi kor mnam mar mang en he kael a halum. He ekam tok, o Rom ngalmialaol nga pis va nga re kut tur kam havae nngia va ngara lget E Nut Ka Maksien Ka Rek To A Totur he krum kim mor ruk o Yuda tgus hak.” ");
INSERT INTO sua_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","To langto mnam mar ruk e Sanhendren, ka munik e Kaiapas, en o pris ruk laol ngalaip mnam a pnes to endo, thop ku he kreng klenar te, “Muk, mularo lpetuk ngta tok! ");
INSERT INTO sua_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mut lua nho va kpat ge te, tvu ya hak ngang ngor ruk o Yuda enangthe a mhel tang ko atgiang nak yor mang ngor tgus, vanang o Rom ngalmialaol kam rum kim mor tgus tlo vua ya e.” ");
INSERT INTO sua_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","E Kaiapas ta re tok, vanangko tlo mrua re orom ka mur pat mruo to e. Nove, E Nunu A Totur tel o rhek mnam ekam ko en tkol a ngaekam to mkor o pris ruk laol ngalaip mnam a pnes to endo, he ka ktar kpavap mang e Yesus orom karo rhek ruk endruk kam havae te, ngak kaim tok he nak yor mang o Yuda ngaro usiel tgus. ");
INSERT INTO sua_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Vanang nak yor nong te, gi mang o Yuda tuk e. Nove, nak yor mang E Nut kles ruk ngata parahi kngae mnam o mhetor tgus mo mmie kat, he nang en kam kta kaum mar, mar kam mokaum, he ka vle tgus te, a valngan to atgiang. ");
INSERT INTO sua_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","To kmikkiem enang tok, mnam a kolkha to endo gi, o Yuda ngalmialaol ngat kaelha kam lgem o rhek mang e Yesus kmim kngam a yoror he ngat ngae orom a papat to endo. ");
INSERT INTO sua_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","He ekam tok, e Yesus tlo kta pupunpa va kpopolok ngang ngar ko mYudea kat e. Ta kle kparem a mhe to, to vur ngae ngok mnam a rengmat to e Epreim ko rkieng a kalputmok, he ka vle ko kim kalngunes mruo. ");
INSERT INTO sua_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kam ngae to ta kokon mang o Yuda kmem nga pnes to ngma mon te, A Engyel Ta Varpaam O Yuda Ngaro Molpou he o mia ngarlatgep ngat otoot pum mar ko mnam ngaro rengmat ruk ko mo lootpgeik he ka grap ngok mYerusalem, mar kam parrur ktar mang ko ngak kaem a pnes to enda. ");
INSERT INTO sua_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ngat pis ko tok, he re kaum kun mnam E Nut ka maksien he kriring kriring e Yesus. Va ngat hera momngan ngar mruo te, “Muta pat nngia?’ Nok ner ho lo kta pis mo pa pnes ta vor e.” ");
INSERT INTO sua_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Vanang o Parisiau kar o pris ruk laol ngat kle kael a re to a serpgar ngang o mia khavaeng ngar te, enangthe tang mnam mar nap re ka mnor mang e Yesus ko ta vle mnam ani mhe to, va nak havae mang, nang mar kam kpom. ");
INSERT INTO sua_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","A kolkha to a ktiek hori ktar mang a pnes to A Engyel Tvarpaam O Yuda Ngaro Molpou, va e Yesus ta pis mBetani, mnam e Lasarus ka rengmat ko tok ko e Yesus thover petgim ka nnak. ");
INSERT INTO sua_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ko ma rengmat to, ngata mrot kim e Yesus he e Marta ta krong o ol, va e Lasarus tkorsang ko kim o mia ruk ngata vle kmemik ko kim kat. ");
INSERT INTO sua_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","To e Maria ta kol a ku ka mten to ngma mon te, a miir to ka gri a yar, endo ka keik kmenkim ta grap, ko ngat eharom orom a gi ho atgiang tuk to a nat karo kavgot. Ta kol to ka glot kuo mang e Yesus kalo nhar va kpungnim min orom karo ngairis ruk kuon malpgem. Ta glot a ku to nok tkais mang a lita ka mhe vor kuo mang ngin va ka gri tngae pum kngae kun ma rek to tgus. ");
INSERT INTO sua_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","E Maria teharom tok, vanang e Yesus kalkayie langto e Yudas to nkong mIskariot, endo koknaik tmur hortgi mang, tkaesik he pe gia mngan te, ");
INSERT INTO sua_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ngot lo is kmel a ku ta gi, he mar kmenkim, nang mor kam kle klol o krek orom he kle kaenik ngang o mia ruk ngma tu kmo tgoluk? Ko a ku ta, ka keik to kmenkim tho mi ktua grap hak, tkais kmeha mang mnam a pnes tang ko a vutnar kmis mang ka keik.” ");
INSERT INTO sua_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Vanang e Yudas ta pe gia mngan tok, ko tlo mi kut kaelongtok lmien mang endruk ngma tu kmo tgoluk e. Nove, ta re ti, ekam ko en a mhel to nam vu kauruvik, ko nam mrua kambim o aposel ngakro krek ogu pa vie to ngam kaelpas mnam, endo en mruo nma nho mang. ");
INSERT INTO sua_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","To e Yesus tkoripang te, “Orim! Ko tkaelpas orom a ku to endo, kam pungnim kua vok orom enang ti arhe, kmelmir mang te, ngara ngangater kua mnes kam pungnim mnam a kolkha to ngat re kmel kun mnam a nho. ");
INSERT INTO sua_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ii, endruk ngma tu kmo tgoluk ngara vle mo kmuk lhok ge, vanang dok ngor lo kta vle mo kmuk lhok kat e.” ");
INSERT INTO sua_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Phevgom e Yesus ko e Maria ta pungnim kalo nhar, o Yuda ngarlavurgem ngata ngnek te, e Yesus ta vle mBetani to ngata ngae ngok. Ngata ngae ngok kam lo gia vokong e Yesus tuk e. Ngat ngae ngok kam vokong e Lasarus kat, endo e Yesus thover petgim ka nnak ko tho yor hak he. ");
INSERT INTO sua_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","He ekam tok, o pris ruk laol ngata vle ka lgem o rhek lvongnek kmim e Lasarus kngam a yoror kat ");
INSERT INTO sua_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ko her vgum e Lasarus arhe o Yuda kavurgem ngat korim mar va kle gi kael kerok ekam e Yesus va kor mnam mar mang en he kmokpom kar. ");
INSERT INTO sua_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","To hop enang ngmo o mia vang ruk ngat veet pa pnes to endo ngata ngnek te, e Yesus ta ngongae ekam a ngaelaut kam ngae ngok mYerusalem kat. ");
INSERT INTO sua_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","To ngata keneker o kneng ngakro im to kngae kam puknim ko ekam a ngaelaut. Va ngata vuvui kam kni pum te, “E Nut ta ngamyammok mang ka taven to yin ko yi pis orom ka munik. Ngota kanprim yin ko her yindo arhe kam susulgim mor. Ii, E Nut ta teiver mor lIsrael ngua Taven to yin.” ");
INSERT INTO sua_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ngata kni pum en tok, nang E Yesus tkol a dongki he ka grap korsang kuon mang, kmikkiem o propet ngaro rhek ruk tennik, kmaottam mar kmel mit ko ngata ktar kpavap mang en tennik ormar te, ");
INSERT INTO sua_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Muk lSaion ruk lYerusalem mguak or kam gor ekam ko mulaip to a Taven ta arhe tkaol ngte kim muk ko tkorsang kuon mang a dongki ka sie.” ");
INSERT INTO sua_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tie mnam a kolkha to endo, e Yesus kalngunes ngat lua mmok mang o propet ngaro rhek ruk endruk ko o mia ngat kael o kavres orom e Yesus ormar e. Gi koknaik he, ko pekam ko e Yesus tyor he khop petgim ka nnak va kaeknik ko kim Kteit, ngat kol a pat mang e Yesus te, ngat ittiegom o propet ngaro rhek ruk endruk her mang e Yesus arhe, gi enang ko o mia ngat kael o kavres orom En ormar. He enang tok, o mia ngat kaottam o propet ngaro rhek ruk gi enang tok arhe. ");
INSERT INTO sua_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nangko o mia ruk ngta vle ko kim e Yesus he kvokong ko thover e Lasarus ko pa nnak ko tyor he kvaeng kmottek, mar ngata hahavae kngae mang ka ngaelmir to a serpgar to endo he kseneker a re mang vop. ");
INSERT INTO sua_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","He ekam tok, o mia ngarlavurgem ngata veet ngok kim ko ngat her ngnek ko teharom a ngaelmir to a serpgar to endo. ");
INSERT INTO sua_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","To o Parisiau ngata kle kmo reng ngar te, “Mu vokom na, ngot ho mrua koham mor he, ko o mia vang hak ngat parem mor he ho gi kael kerok ekam a mhel to he.” ");
INSERT INTO sua_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","To o vrong rhek akuruk ngta kpom o Yuda ngaro keknen he ktotu pum E Nut ormar ngat pagis kat pa pnes to A Engyel Ta Varpaam O Yuda Ngaro Molpou ko mYerusalem kam totu pum E Nut. ");
INSERT INTO sua_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ngata ngae ngok kim e Pilip to nkong mBetsaida mnam a mhe to e Galili to ka mnganang te, “Ngolaip, ngota svil kam vokong e Yesus.” ");
INSERT INTO sua_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","To e Pilip tngae khavaeng e Andru to min tgus nginta ngae to khavaeng e Yesus. ");
INSERT INTO sua_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","E Yesus ta ngnek tok, to kle khavaeng ngar tgus te, “Kua kolkha to kam yor he kta hop kat tre kam pis, he E Nut kam mrua khenam A Mhel To Nkong Man Ma Volkha to dok ka serppak ma mmok he. ");
INSERT INTO sua_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ii, ko smia mien ngang nguk te, enangthe ke ho to ngma mon te, a vit ngo khek ngap lua vui na, he ka rpuo ku mmie to kpagis va ke ho to a vit ner gia vle en tuk tok arhe! Vanang enangthe a vit ngo khek ngap mia vui he ka rpuo ku mmie he kpagis va ke ho to a vit kakro miel ngara tgep. ");
INSERT INTO sua_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","He kmikkiem gi enang tok, enangthe a mhel tang nap mur kaelongtok mang ka ngorsang to mo mmie kir kim dok, nang lo mur kaen en mruo kam yor mang dok, va nera vle en tuk tok kat arhe he kmoslam a ktalhok to kam plong vle ko kim E Nut ngnik ngnik. Vanang endo nam le mur kaen en mruo kam yor mang dok ko nam lo vua pat kmelongtok mang ka ngorsang to mo mmie, her endo arhe E Nut ner mia kir mang a ktalhok to kam plong vle ko kim En ngnik ngnik kmen ngang koknaik. ");
INSERT INTO sua_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ii, endo nma svil kmeha ngang dok, na smia mokpom kar dok va karkar ekam kuaro leik. He enang tok, kolkayie to en, nera vle ko kim dok mekam mekam mnam a mhe to koma vle mnam. Va E Titou nera teiver endo arhe nam kaeha ngaok. ");
INSERT INTO sua_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Vanangko tete ta, kua ngaung tlo sim kat kaisis he, va nguak re nngia? Ko klo is kam re te, ‘Titou ngiak sulgim dok he kpet kua kolkha to kam yor mnam e.’ Nove, klo is kam re tok e, ekam ko a her sim kut kolkha to arhe ko her aol ngte kam paneng, en kam pis, he dok kam yor mnam. ");
INSERT INTO sua_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Titou, yin ge! Ngia mrua khenam ila serppak ngang o mia, mar kam kanprim ila munik.” E Yesus thavae tok, to a ktui langto tkottek kun kuon ma volkha he kre te, “Ko her khenam he, va ngor kta khenam kat.” ");
INSERT INTO sua_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A ktui ta re tok, to a murgun to ngta sir ko tok he kngan a ktui ta, ngat re te, “A koot ta kullung.” Vanang akuruk ngat kle kre te, “A engyel langto ta rere kar.” ");
INSERT INTO sua_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Vanangko E Yesus ta reng ngar te, “A ktui ta muta ngan, tlo pis dok kam kol a serppak vgum e. Ta kle kpis ngang nguk, muk kam serppak vgum arhe. ");
INSERT INTO sua_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mare! Tete, a ngaeha to kam mommen o mia mo mmie ther kaelha mnam a kolkha ta he. Ko tete o kool ngalaip to nma nho mang a mmie ta, E Nut ka serppak ner kaim kta serppak he kir kim. ");
INSERT INTO sua_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Enang tok, kopekam ko ngak hover a ho orom dok, he dok kam parem a mmie ta kmeknik ngok kim E Titou, va ngor kait o mia tgus kam mur kaen mar mruo ngang dok.” ");
INSERT INTO sua_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Vanang e Yesus ta re te, “Ngak hover a ho orom dok” tok, kam khenam ma mmok mang en mruo te, nak yor nngia! ");
INSERT INTO sua_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ii, thavae tok, va o mia ngat kaekon ngang kam re te, “Ngoma ngan ngolmialaol ko ngma him E Nut karo rhek ngang ngor ko ngama havae te, Endo E Nut Thim Orom Ka Msasaen ner gia vle ka vle ngnik ngnik he. Va nngia, ko yin, ya havae te, ‘Ngara hover a ho orom A Mhel To Nkong Man Ma Volkha’? A Mhel To Nkong Man Ma Volkha eriem to tok ya rere kngae mang ti?” ");
INSERT INTO sua_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Va e Yesus tkoripang ngar te, “A mmok ka pun to dok ngor vrua vle lhok mo kmuk vop. He ekam tok, mguak kaikkiem a mmok ka pun to dok ge, ko koma mmok kim o mia vop, ktar mang ko naka slok kmuk. Ko endo nma ngongae ma klinglon nam lua nho kpaam mnam kam mnor mang ani mhe to ta ngae mnam. ");
INSERT INTO sua_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ii, he ekam tok, mguak kor mnam muk mang a mmok ka pun to dok he kmokpom kar dok, gi mnam o kolkhek ruk koma mmok kim muk vop, he nang muk kam vle te, E Nut to karo keknen ruk ngta mmok kles ruk muk kat.” E Yesus ta rere tok knop, to kngae ka tvok kim mar. ");
INSERT INTO sua_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pu lmien te, e Yesus tpolger o ngaelmir ri lserpgue ko pum o Yuda ngakro kerok, vanang ngarlavurgem mnam mar ngama kees kmor mnam mar mang en he lua mokpom kar ge. ");
INSERT INTO sua_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ngat lo kor mnam mar mang en he lua mokpom kar enang tok, he kaottam a propet to e Aisaia karo rhek ko ngat el mit ormar ko tennik ta ktar kpavap mang ngar te, “Ngoldaip, yi pua khenam ilalo ktiek lserppak ma mmok ngang o mia, vanang ngat lo kor mnam mar mang nguaro rhek ruk ngoma havae ormar ge!” ");
INSERT INTO sua_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Va o mia ri ngat lo is kmor mnam mar mang e Yesus tok, kmikkiem e Aisaia karo rhek akuruk kat, ko ta ktar kpavap mang ngar ormar ko mnam a mhe langto yok kam havae te, ");
INSERT INTO sua_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ngoldaip tngam slommok pum ngakro kerok va kngam tok kim ngakro lpetuk, mar kam lua vokom ka mnor mang En to kle khortgi ngok kim, he nang En kam sulgim mar.” ");
INSERT INTO sua_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ii, e Aisaia ta re tok, ekam ko ta ktar kaengogo orom e Yesus ka serppak to kam hop petgim ka nnak, to tle ka ktar kpavap mang orom karo rhek ruk endruk tok arhe. ");
INSERT INTO sua_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pu o Yuda ngarlavurgem ngat lo kor mnam mar mang e Yesus he lua mokpom kar, vanang akuruk ngat kut kor mnam mar mang en he kmokpom kar ge. Si o Yuda ngalmialaol kat va ngarlakhor mnam mar ngat kor mnam mar mang he kmokpom kar kat ge. Vanang ngat lo mrua hophop ormar mrua ma mmok, ekam ko ngata gorang o Parisiau ko ngak rere kmar he kle klikim mar kam kser mar ko mnam o Yuda ngakro rektor ruk kam rere mnam mar, mar kam lo kta kaum ktotu pum E Nut kar mar kat. ");
INSERT INTO sua_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ngam lo mrua hophop ormar mruo ma mmok tok, ekam ko ngam ho mi ktua svil hak te, o mia kam re pmar va kmon mar, nang ngam lo vua svil mang E Nut kam re pmar va kmon mar tok e. ");
INSERT INTO sua_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","To e Yesus thop krere kuo malpgem o mia te, “Ani mhel to tkor mnam en mang dok he kmokpom kar dok tlo gi mokpom kar dok tuk e. Ther mokpom kar Endo tmeng dok kat. ");
INSERT INTO sua_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Va ani mhel to tvokong dok, tlo gi vokong dok tuk kat e. Ther vokong Endo tmeng dok kat. ");
INSERT INTO sua_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ii, va kua pis mo mmie enang a mmok, he nang o mia tgus ruk ngat kor mnam mar mang dok he kmokpom kar dok, kam lo kta vle ma slommok kat e. ");
INSERT INTO sua_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ii, va enangthe a mhel lang nak ngan kuaro rhek, nang lua ngan vgum dok, nong kua ngaeha to kam momngan kar e. Ko klo aol ngte kam momngan kar o mia ruk mo mmie e. Nove, ko aol ngte kam sulgim mar ha, kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang ngar. ");
INSERT INTO sua_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Vanangko a mhel to nma keyang dok he lua ngan vgum dok, her E Titou arhe to ner mia momngan kar a mhel to endo kun mnam a kolkha to a kser kim. Va ner kaikkiem kuaro rhek ruk ko her rere ormar kam monik kim a yor ngang. ");
INSERT INTO sua_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ner kaeharom tok, ekam ko dok, klo mrua rere orom kua serppak mruo e. Nove, vanang E Titou to tmeng dok, tsim kut papsim dok va kenang dok orom o rhek ruk nguak rere ormar, va ta kenang dok kam rere ormar nngia nngia. ");
INSERT INTO sua_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Va kua mnor te, o rhek ruk E Titou tsim kut papsim dok ormar ngat is kam ktong o mia kam kol a ktalhok to kam plong vle ko kim En ngnik ngnik. He ekam tok, oni rhek oni rhek ruk koma rere ormar, kom sim kut kaikkiem mar kngae tok, gi enang ko E Titou ther sim kut papsim dok ormar va kenang dok kam rere ormar kngae tok.” ");
INSERT INTO sua_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","3","To mnam a kolkha to a ngaelonpik mnam a pnes to A Engyel Tvarpaam O Yuda Ngaro Molpou, e Yesus ta tar ko ka kolkha to kam yor mnam he kparem klenar ruk mo mmie kmeknik ngok kim Kteit tpis he. Vanang e Seten thera ktar kaenkrovgem e Yudas to e Saimon to nkong mIskariot khal nanga he, he nang en kam mrua hortgi mang. Va e Yesus ta ktua mnor kat te, Kteit tel o tgoluk tgus ko maktiegom en, ko ther ottek ko kim Kteit va ketasuo en kam kat kaeknik ngok kim kat. Tie ma segain to endo, phevgom ko ngat kaum kmemik, ko ngta krong o ol ngang ngar, e Yesus tkaelha kam mrua pis orom ka keknen to kam vu kaelongtok mang ngar kam khenam ma mmok te, tvu kaelongtok mang klenar mruo msim mo mmie. ");
INSERT INTO sua_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ko ta hop ku to khong ka yet, endo nma vaik pum kuo porom, to kle kol a yet to nma momgol ka vok orom to ka kleng ko mnam ka vgon. ");
INSERT INTO sua_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Teharom tok, to ka glot a ye kun mnam a plo, to kaelha kmelel kalngunes ngaro nharok va kmomgol mar orom a yet to ta kleng ko mnam ka vgon. ");
INSERT INTO sua_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","E Yesus tkaelel o nharok kpis ko kim e Saimon to e Pita, to e Pita thera mnganang te, “Ai! Koldaip yin mruo yindo ngir mur kaelel kualo nhar?” ");
INSERT INTO sua_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Va e Yesus tkoripang te, “Yi lua mmok mang a keknen ta ko kaeha orom ngang in tete, vanang koknaik yek ngir kle ka mmok mang.” ");
INSERT INTO sua_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","To e Pita tho gia kokheng te, “Nove! Tho ngae lo mi kut kais hak yin kmelel kua lo nhar e.” Va e Yesus tkoripang te, “Enangthe ngua lo momgol yin va yi ho lo kais hak kam kol a ngaekam kam vle ku meorom E Nut ka tavgo e.” ");
INSERT INTO sua_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","E Yesus ta re tok, va e Saimon Pita ta kle kreng te, “Koldaip enangthe ipa mien tok, va ngiak or kam gia khen kualo nhar kmelel min tuk e. Ngiak kle kaelel kua lo ktiek va kua lpek kat.” ");
INSERT INTO sua_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Va e Yesus tkoripang te, “Ani mhel to tparrur tgus, ther mmok he, va nam lo kat kais kam kat korop kat e. Nak kle her gia ka khen kalo nhar tuk kmelel min. Ii, va muk tgus muta mmok ka vle he, vanang a gi mhel atgiang to kun pgegom muk to tlua mmok.” ");
INSERT INTO sua_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","E Yesus ta ktar her mnor mang erieto mnam mar na mrua hortgi mang, he ekam tok, treng ngar tok te, “Muk tgus muta mmok, vanang a mhel atgiang kun pgegom muk to tlua mmok.” ");
INSERT INTO sua_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","E Yesus tkaelel ngaro nharok tgus knop, to kta vaik pum ka yet kuo porom, to kaeknik kpis korsang ko ekam kat, to kle ka mnganang ngar te, “Muta mmok mang a keknen ta ka pun ko eharom ngang nguk kat? ");
INSERT INTO sua_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mu vokom na, muma mon dok te, e Pattermia, va ka kvam dok kat te, Mulaip ormok, va ta sir ge ko muak mon dok tok ge, ekam ko dok kua vle gi enang tok arhe. ");
INSERT INTO sua_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yu! Ko gun elel mulakro nharok tok, ekam ko muma mon dok te, Mulaip va mula pattermia ta dok. Va muk kat mguak kle kaelel o mia ngaro nharok mekam mekam gi enang tok kat. ");
INSERT INTO sua_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ii, ko her mur el dok ko pum mularo kerok kam kenang nguk mang a keknen to endo, he nang muk kam kle kaeharom gi enang ko ko eharom tok ngang nguk tete. ");
INSERT INTO sua_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ko smia mien ngang nguk te, mut lo kais hak kmottek mnam a keknen ta e, gi enang a mhel to nam kaeha lkapnes ngang kalaip ko en kat nam lua laut mang kalaip kmis en kmottek mnam karo keknen kat e. Va endo tkol a mhel ka gu, en kat nam lua laut mang ka taven to tmeng kmis en kmottek mnam ka taven karo keknen tok kat e. ");
INSERT INTO sua_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Va tete, ekam ko muta mnor mang a papat to enda, mguer mia lgekol enangthe muak kaelha ka khenam a keknen ta ma mmok kmeharom ngang o mia mekam mekam.” ");
INSERT INTO sua_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ko havae he mang a mhel to tlua mmok, vanang klua rere mang nguk tgus e, ko kua mnor mang nguk ruk ko her vaeng nguk. Vanangko E Nut karo rhek ruk o propet ngat ittiegom mar tennik ngak kaottam kpis lmien orom a mhel to ko ngat rere ormar mang te, ‘Endo ta mokpom kar dok he kaum kaemik kar dok, ta kle mrua hortgi mang dok.’ ");
INSERT INTO sua_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","He ekam tok, kua ktar khavaeng nguk tete, ktar mang endo kam hortgi mang dok koknaik tok, her mi kut mang nguk kam pat mang kuaro rhek ri tete, to kle kor mnam muk mang dok te, Endo ta vle orom a ktalhok to kam plong vle ko kim E Nut ngnik ngnik her dok msim ta arhe. ");
INSERT INTO sua_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ii, ko smia mien ngang nguk te, ani mhel to nak ngatkal mang ani mhel to kua meng ko tkol kua gu, ther mia ngatkal kam vle ku meorom kua tavgo tok kat arhe. Va ani mhel to ta ngatkal mang kam vle ku meorom kua tavgo tok, ther kle mia ngatkal kat kam vle ku meorom Endo tmeng dok ngte ka tavgo tok kat.” ");
INSERT INTO sua_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","E Yesus ta rere ti knop, to ka ngaung tho lo sim kat kaisis hak to khavaeng kalngunes lsir te, “Ko smia havaeng nguk ma mmok te, langto kun pgegom muk ner mrua hortgi mang dok.” ");
INSERT INTO sua_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kalngunes ngata ngan e Yesus karo rhek tok, to kle gia mo vokong ngar, va le ho kmoruo mang te, “Ta rere mang erieto mnam mor?” ");
INSERT INTO sua_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","To langto mnam mar, endo e Yesus nam vu kaelongtok mang, tkorsang ko vanam e Yesus va ");
INSERT INTO sua_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","e Saimon Pita ta tger ka ktiek ngang he kreng te, “Ngia mnganang te, ta rere mang erieto mo pgegom mor?” ");
INSERT INTO sua_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","To endo e Yesus nam vu kaelongtok mang ta ngam ka lpek knaek engnang e Yesus ka ngaengtek, he ka mnganang te, “Koldaip ya rere mang erieto?” ");
INSERT INTO sua_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Va e Yesus tkoripang te, “Endo nguak vasgem a bret ka mhe ta kun ma plo he kaen ngang, her en a mhel to arhe.” Ta re tok, to le kvasgem a bret ka mhe to le kaen ngang e Yudas, endo e Saimon to nkong mIskariot khal. ");
INSERT INTO sua_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","E Yudas tre gia kol a bret mkor e Yesus tok, va e Seten ther gi viging ngatngae. To e Yesus ta reng e Yudas te, “Ngia ke kmarer kmeharom a ngaeha to ya re kmeharom.” ");
INSERT INTO sua_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","E Yesus ta re tok, vanangko nong tang mnam mar ruk ngata kaum kaemik ta mmok te, kman ko e Yesus ta reng e Yudas tok. ");
INSERT INTO sua_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Vanang ekam ko e Yudas nama nho mang nga ngaelpas to kmelpas orom o krek mnam, e Yesus kalngunes akuruk ngata pat re te, ta reng kam ngae kaenkim o ol orom o krek ruk endruk, ngar kmemik pa pnes, i o kam ngae ka nngiar ngang endruk ngma tu kmo tgoluk. ");
INSERT INTO sua_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","E Yudas tre gia kol a bret ka mhe mkor e Yesus to ther gi ottek kngae, nangko ta slok he. ");
INSERT INTO sua_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pekam ko e Yudas tottek kngae, e Yesus tle khavaeng kalngunes te, “Tete, E Nut tre kam khenam A Mhel To Nkong Man Ma Volkha to dok ka serppak ma mmok. Va A Mhel To Nkong Man Ma Volkha to dok ngor kta khenam E Nut ka serppak vgum dok kat. ");
INSERT INTO sua_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ii, va enang ko A Mhel To Nkong Man Ma Volkha to dok ngora khenam E Nut ka serppak vgum dok mruo tok, va E Nut mruo ner le kta khenam A Mhel To Nkong Man Ma Volkha to dok kua serppak vgum En mruo gi enang tok kat. He E Nut tre kmeharom tok gi tete ta. ");
INSERT INTO sua_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Koles ruk muk, tete ngua lo kat kais kam vle lhok mo kmuk kat e. Nguak ngae, va mguera nonhong dok, vanangko kua havaeng nguk tete, gi enang ko ko her havaeng o Yuda ngalmialaol te: Mut lo is kam ngae ko mnam a mhe to dok kua re kam ngae mnam e. ");
INSERT INTO sua_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Va tete ko kaen a pos langto yok to a gunngar ngang nguk te, mguak kaelongtok mo nguk. Ii, va mguak kaelongtok mo nguk enang tok, kmikkiem gi enang ko kom vu kaelongtok mang nguk tok kat. ");
INSERT INTO sua_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yu, he enangthe mguak khenam muk ma mmok te, mum vu kaelongtok mo nguk tok, va o mia tgus ngar mia mnor mang nguk te, muk ruk kolngunes ormuk her vgum a keknen to endo tok arhe.” ");
INSERT INTO sua_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","E Yesus ta re tok, to e Saimon Pita ta mnganang te, “Koldaip, ya re kam ngae ngam?” Va e Yesus tkoripang te, “A mhe to kua re kam ngae ko mnam, yi lo is kmikkiem dok kam ngae ko mnam tete e. Vanangko ngir kle yek kaikkiem dok koknaik kam ngae mnam.” ");
INSERT INTO sua_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Va e Pita ta kle ka mnganang te, “Koldaip kman ko klo is kmikkiem in tete? Ko dok kua re kam mur el dok kam yor kar yin he.” ");
INSERT INTO sua_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","To e Yesus tle ka mnganang e Pita kat te, “Ai! Ya smia mien te, ngir mi kael yin kam yor kar dok kat? Vanang ko smia mien ngang in te, ktar mang a ngaining kmeti ngkir mo kao, yin ngira klai mang dok ngkorlotge kam havae te, yi lua mnor mang dok.” ");
INSERT INTO sua_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Mularo vurkul ngak or kam kervavle vgum kuaro rhek ruk endri. Mgua kle gi kor mnam muk mang E Nut va kor mnam muk mang dok kat he kmokpom kar dok. ");
INSERT INTO sua_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","E Titou ka rek to oguon ma volkha karo tabneik ngarlavurgem. Va kua re kam ngae ktatar o ngaekmol ekmuk. Enangthe lmien te, nop o mi ngaekmol kuo mnam E Titou ka rek, va kop mia havaeng nguk lmien tok arhe. ");
INSERT INTO sua_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Vanang ekam ko kua re kam ngae ktatar o ngaekmol ruk endruk ekmuk, va ngor kat kaeknik kam pis ka nglum muk kat, muk kam ngae ka vle ko kim dok, ko tok mnam a mhe to dok mruo kua re kam vle mnam. ");
INSERT INTO sua_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Va mut hera mnor mang a ngaelaut to ta ngae ngok mnam a mhe to dok mruo, kua re kam ngae mnam.” ");
INSERT INTO sua_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","To e Tomas ta mnganang te, “Koldaip, ngot ho lua mnor hak mang ani mhe to ya re kam ngae mnam gi, to ngruaka mnor mang a ngaelaut nngia?” ");
INSERT INTO sua_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Va e Yesus tkoripang te, “Her dok a mi ngaelaut msim ta arhe, dok to orom o papat ruk o minar kmen a ktalhok to kam plong vle ko kim E Nut ngnik ngnik ngang nguk. Ii, he ekam tok, nong a mhel tang hak to tis hak kam mrua kansgum en mruo kam ngae kpis ko kim E Titou e. Nove! Ko her gi vgum dok tuk, yek a mhel tkais kam ngae kpis ko kim E Titou. ");
INSERT INTO sua_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Vanang enangthe o mia ngapa mnor mang dok tete, va ngap kais kam mnor mang E Titou tok kat. He kmelha tete kngae, mut her mia mnor mang E Nut msim ko mut her mia vokom dok orom En he.” ");
INSERT INTO sua_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","To e Pilip ta mnganang te, “Koldaip, ngia khenam Ngor Teit ngang ngor to ner kais ngang ngor tok he.” ");
INSERT INTO sua_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Va e Yesus tkoripang te, “Ai! Pilip, ko hera vle lhok mo kmuk he, va yi lua mmok mang dok vop? Ko ani mhel to tvokom dok, ther mi vokom dok orom E Titou he. To nngia ko yi kta reng dok kam khenam E Titou ngang nguk? ");
INSERT INTO sua_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pilip, im lo kor mnam yin mang dok gi te, dok kar E Nut muo tgus moma vle te, her muo atgiang? Ko o rhek ruk koma rere ormar, ngam lo kottek ko vgum dok tuk e. Nove, vanang E Titou to ka serppak nma vle mnam dok, nam kle mur kaeharom karo reha mruo maktiegom dok ta arhe. ");
INSERT INTO sua_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","He ekam tok, muk tgus mgua sim kor mnam muk he kmokpom kar dok vgum kuaro rhek ruk ko havaeng nguk ormar he te, dok kar E Nut, muo tgus moma vle te, her muo atgiang. Enangthe nop, va mgua kle gi kor mnam muk mang dok he kmokpom kar dok vgum E Nut karo reha ruk lserpgue, endruk nam kaeharom mar maktiegom dok ko mut vokom mar. ");
INSERT INTO sua_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ii, kua mien ngang nguk te, ani mhel to tkor mnam en mang dok he kmokpom kar dok, a mhel to endo ner mi kaeharom o reha ri lserpgue kat, gi enang dok mruo ko kom kaeharom mar tok kat. Va ner mi kaeharom mar kir kim endri kom kaeharom mar ekam ko kua re kam ngae ngok kim E Titou. ");
INSERT INTO sua_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","He kmikkiem enang tok, ani tomhelo mguaka mnganang dok mang orom kua munik, va ngor mia ngan vgum muk he kaeharom gi enang tok. Ngor kaeharom tok, he nang o mia kam teiver E Titou her vgum Khal to dok tok arhe. ");
INSERT INTO sua_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ii, mut kais kam mnganang dok mang a gi vrong tomhel tang orom kua munik, va dok mruo ngor kaeharom.” ");
INSERT INTO sua_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","To e Yesus ta kta reng kalngunes kat te, “Enangthe mup kaelongtok mang dok va mguak kle kta khenam muk mruo ma mmok tok kmikkiem kuaro rhek ruk koma havaeng nguk ormar. ");
INSERT INTO sua_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mguaka vle tok, va ngora mnganang E Titou, va nera meng tang kat ngang nguk en kam plong vle ko kim muk ngnik ngnik. Her endo ngma mon te, Endo Kam Tuturang Nguk. ");
INSERT INTO sua_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","En E Nunu A Totur to nma polger o papat ruk o minar ngang o mia. He vrong o mia ruk mo mmie ngat lo is hak kam kol, en kam vle ko kmar, ko ngat lo is kam vokom va ka mnor mang. Vanangko muk, her muk ruk arhe muta mnor mang, ekam ko tgia vle mo kim muk va nera viging nguk kmel rengmat kun mnam muk kat. ");
INSERT INTO sua_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ii, va nguak yor va kta hop he kaeknik ngok kim E Titou, vanang ngor lua mnang nguk kam gia vle enang o tumrek e. Nove! Ngor kat kaeknik ngte kmuk kat. ");
INSERT INTO sua_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ii, ketasuo dok kam yor he o mia ruk mo mmie ngar lo kat kais kam kta vokong dok kat e. Vanangko muk, mguera vokong dok ge, ko ngora hop petgim kua nnak he ka vle orom a ktalhok to kam plong vle ko kim E Nut ngnik ngnik. Va ekam ko kua vle tok, muk kat mguera vle orom a ktalhok to kam plong vle ko kim E Nut ngnik ngnik tok kat. ");
INSERT INTO sua_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","He mnam a kolkha to ngua hop he kat kaeknik ngok kim E Titou, mguer mia kol a pat te, dok va E Nut kar muk, mor tgus ngoma kaum ka vle enang a ho to atgiang tgus ko dok kua par mnam E Titou, va muk muta par mnam dok, va dok kua kha orom muk. ");
INSERT INTO sua_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Va ani mhel to ta ngan kuaro rhek ruk koma havaeng nguk ormar he kaikkiem mar, her en a mhel to arhe ta khenam en mruo ma mmok te, nam vu kaelongtok mang dok. Va E Titou ner kaelongtok mang ani mhel to nma khenam ma mmok tok te, nam vu kaelongtok mang dok kat. Va dok vat, ngor vu kaelongtok mang a mhel to kat, to le mrua khenam dok mruo ngang.” ");
INSERT INTO sua_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","To e Yudas, (nop e Yudas to nkong mIskariot e, langto yok) en ta reng te, “Koldaip, nngia ko ngir gi mrua khenam in ngang ngor, vanang o mia mo mmie tgus nop?” ");
INSERT INTO sua_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Va e Yesus tkoripang te, “Ani mhel to nam vu kaelongtok mang dok, ner mrua khenam en mruo ma mmok tok he kaikkiem kuaro rhek ruk koma patter o mia ormar. He enang ko kua re, E Titou vat, ner vu kaelongtok mang a mhel to kat, va dok krE Titou tgus mor kaol ngok kim he kael rengmat kun mnam. ");
INSERT INTO sua_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Vanangko endo nam lo vu kaelongtok mang dok, nam kle ka khenam en ma mmok tok kat te, nam lua ngan vgum dok he lo kaikkiem kuaro rhek ruk koma patter o mia ormar kat e. Va o rhek ruk muta ngannik tete, nong nang dok mruo e, ngat kle kottek ko kim E Titou to tmeng dok. ");
INSERT INTO sua_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ko her havaeng nguk mang o papat ri he, ekam ko ko vrua vle mo kmuk vop. ");
INSERT INTO sua_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Vanang koknaik, E Titou nera meng E Nunu A Totur ngang nguk orom kua munik. Va her Endo Kam Tuturang Nguk arhe, ko en ner le kpatter muk mang o papat tgus, va ner