﻿USE sofia;
DROP TABLE IF EXISTS sofia.stpNT_vpl;
CREATE TABLE stpNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES stpNT_vpl WRITE;
INSERT INTO stpNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Gu Dabii gio gu Abraam jir diꞌ pɨx am gu bopxiꞌñ guch Xoiꞌkam. Jaꞌpni jaꞌk moo tu tuꞌiiꞌ: ");
INSERT INTO stpNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Gu Abraam maaꞌn tu mar kat na Isaak tɨɨgich. Miꞌ dhɨr baꞌ moo gu Isaak maaꞌn jup tu mar kat na Jakob jup tɨɨgich. Miꞌ dhɨr baꞌ moo gu Jakob jɨꞌkchip tu maamar kat, maadɨt jir diꞌ guiꞌ na Judaa tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Miꞌ dhɨr baꞌ gu Judaa gook jup tu maamar kat, maaꞌn Paaris tɨɨgich, gu jumai baꞌ Saara, gu ja naan baꞌ Tamaar jup tɨɨgich. Baꞌ gu Paaris maaꞌn jup tu mar kat, Isroom jup tɨɨgich. Miꞌ dhɨr baꞌ gu Isroom maaꞌn jup tu mar kat, Araam jup tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Miꞌ dhɨr baꞌ gu Araam maaꞌn jup tu mar kat, Aminadaa jup tɨɨgich. Miꞌ dhɨr baꞌ gu Aminadaa maaꞌn jup tu mar kat, Nasoon jup tɨɨgich. Miꞌ dhɨr baꞌ gu Nasoon maaꞌn jup tu mar kat, Salomoon jup tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Baꞌ gu Salomoon miꞌ dhɨr maaꞌn jup tu mar kat na Boos jup tɨɨgich, gu dɨꞌɨɨꞌn baꞌ Raab jup tɨɨgich. Baꞌ gu Boos miꞌ dhɨr maaꞌn jup tu mar kat, Obed jup tɨɨgich, gu dɨꞌɨɨꞌn baꞌ Rut jup tɨɨgich. Miꞌ dhɨr baꞌ gu Obed maaꞌn jup tu mar kat, Isayii jup tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Miꞌ dhɨr baꞌ gu Isayii maaꞌn jup tu mar kat na puiꞌ tɨɨgich Dabii. Miꞌ dhɨr baꞌ gu Dabii maaꞌn jup tu mar kat na Salomoon jup tɨɨgich, guiꞌ nar dɨꞌɨɨꞌn guiꞌ na bɨɨpɨꞌ dɨr jir bɨngaꞌn kat gu Uriiyas. ");
INSERT INTO stpNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Baꞌ gu Salomoon miꞌ dhɨr maaꞌn jup tu mar kat, Roboam jup tɨɨgich. Miꞌ dhɨr baꞌ gu Roboam maaꞌn jup tu mar kat, Abiiyas jup tɨɨgich. Miꞌ dhɨr baꞌ gu Abiiyas maaꞌn jup tu mar kat, Asaa jup tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Miꞌ dhɨr baꞌ gu Asaa maaꞌn jup tu mar kat, Josapaat jup tɨɨgich. Miꞌ dhɨr baꞌ gu Josapaat maaꞌn jup tu mar kat, Joraam jup tɨɨgich. Miꞌ dhɨr baꞌ gu Joraam maaꞌn jup tu mar kat, Usiiyas jup tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Miꞌ dhɨr baꞌ gu Usiiyas maaꞌn jup tu mar kat, Jotaam jup tɨɨgich. Miꞌ dhɨr baꞌ gu Jotaam maaꞌn jup tu mar kat, Akaas jup tɨɨgich. Miꞌ dhɨr baꞌ gu Akaas maaꞌn jup tu mar kat, Esekiiyas jup tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Miꞌ dhɨr baꞌ gu Esekiiyas maaꞌn jup tu mar kat na Manasees jup tɨɨgich. Miꞌ dhɨr baꞌ gu Manasees maaꞌn jup tu mar kat, Amoon jup tɨɨgich. Miꞌ dhɨr baꞌ gu Amoon maaꞌn jup tu mar kat, Josiiyas jup tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Miꞌ dhɨr baꞌ gu Josiiyas jɨꞌkchip tu maamar kat janoꞌ na mɨt paiꞌ dhuuk ja uꞌuuk gu Israel kam jaꞌtkam mu jaꞌk Babiloonia. Baꞌ maadɨt Jekoniiyas tɨɨgich guiꞌ jɨꞌ nam jir maamraꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baꞌ mɨkkat gatuuk nam paiꞌ dhuuk mu jaꞌk xi oiꞌñkat Babiloonia, maaꞌn jup tu mar kat gu Jekoniiyas na Salatial jup tɨɨgich. Miꞌ dhɨr baꞌ gu Salatial maaꞌn jup tu mar kat, Robabeel jup tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Miꞌ dhɨr baꞌ gu Robabeel maaꞌn jup tu mar kat, Abiot jup tɨɨgich. Miꞌ dhɨr baꞌ gu Abiot maaꞌn jup tu mar kat, Eliakiim jup tɨɨgich. Miꞌ dhɨr baꞌ gu Eliakiim maaꞌn jup tu mar kat, Asoor jup tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Miꞌ dhɨr baꞌ gu Asoor maaꞌn jup tu mar kat, Sadook jup tɨɨgich. Miꞌ dhɨr baꞌ gu Sadook maaꞌn jup tu mar kat, Akiim jup tɨɨgich. Miꞌ dhɨr baꞌ gu Akiim maaꞌn jup tu mar kat, Eliob jup tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Miꞌ dhɨr baꞌ gu Eliob maaꞌn jup tu mar kat, Eliasaar jup tɨɨgich. Miꞌ dhɨr baꞌ gu Eliasaar maaꞌn jup tu mar kat, Mataan jup tɨɨgich. Miꞌ dhɨr baꞌ gu Mataan maaꞌn jup tu mar kat, Jakob jup tɨɨgich. ");
INSERT INTO stpNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Miꞌ dhɨr baꞌ gu Jakob maaꞌn jup tu mar kat na Josee jup tɨɨgich, guiꞌ nar bɨngaꞌn kat gu Mariiya guiꞌ nar dɨꞌɨɨꞌn guch Xoiꞌkam guiꞌ na Jesuus tɨɨꞌ, guiꞌ na saak Dios puꞌñi bha jootsaꞌ jix dhaam dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Baꞌ janoꞌ dɨr nat paiꞌ dhuuk maaxir gu Abraam, mambhɨɨx daman maakob ai mɨt gu jaꞌtkam nat baꞌp ba maaxir gu Dabii. Gio baꞌ miꞌ dhɨr gatuuk jaꞌkbuiꞌ aixkam jup ai mɨt na mɨt maaxir janoꞌ dɨr nat paiꞌ dhuuk gu Dabii maaxir miꞌ juugɨt na mɨt paiꞌ dhuuk ja uꞌuuk gu Israel kam jaꞌtkam mu jaꞌk Babiloonia. Gio baꞌ miꞌ dhɨr janoꞌ nam paiꞌ dhuuk mu jaꞌk xi oiꞌñkat Babiloonia gu Israel kam jaꞌtkam, jaꞌkbuiꞌp ai mɨt mambhɨɨx daman maakob na mɨt maaxir gu jaꞌtkam miꞌ juugɨt nat paiꞌ dhuuk maaxir guch Xoiꞌkam guiꞌ na saak Dios puꞌñi bha jootsaꞌ jix dhaam dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jaꞌpni jaꞌk jum duu guch Xoiꞌkam janoꞌ nat paiꞌ dhuuk maaxir. Gu dɨꞌɨɨꞌn Mariiya tu taandaꞌ am na sap bɨɨmaꞌn tu kiichaꞌ maaꞌn gu chioꞌñ na puiꞌ tɨɨꞌ Josee, guꞌ ji na guꞌ bɨɨpɨꞌ dɨr nat chakui bɨɨmaꞌn tu kiicha, dɨɨlh pɨx bar alhiꞌch kɨɨkam kaꞌ gu Mariiya, sia kum tɨi chakuir jum bɨpnagɨm, na guꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ nat puiꞌ jaꞌk bhaan jum tajaa na baꞌ dɨɨlh pɨx ba tɨgiaꞌ maaꞌn gu alhii. ");
INSERT INTO stpNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Guꞌ baꞌ na guꞌ gu Josee jup jir jix bhaiꞌkam kaꞌ, guiꞌ na bɨɨmaꞌn jix chu kiicham kaꞌ gu Mariiya, puiꞌ bam aagɨt nam jix xɨꞌlhim xim jɨꞌdɨlhkadai gɨt cham tuꞌ bhaan ji chu aꞌgat, na guꞌx joiꞌgɨꞌn gu Mariiya, baꞌ cham aaꞌ na ba ji iattulhdhaꞌ ja bui gu gɇꞌgɇrkam jum aaꞌndam, nam baꞌ cham tu chiñiaꞌ nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Baꞌ puiꞌ bam aagɨk na moo maiꞌ ba buaꞌ gɨt gu Mariiya, guꞌ ji nat guꞌ ba tɨɨ maaꞌn gu nobiiꞌñ guch Gɨꞌkoraꞌ tɨɨtkiꞌ bhaan na sap jup tɨtda: ―Aapiꞌ Josee nap jir boxiiꞌñ gu Dabii, chaꞌp jax jum aagɨt bɨɨmaꞌn xi chu kiichai gu Mariiya, na guꞌ gu alhii guiꞌ na tɨgiaꞌ, dhiꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ pɨx nat puiꞌ jaꞌk tu duu nat bhaan jum tajaa. ");
INSERT INTO stpNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Baꞌ guiꞌ jɨꞌ gu alhii na tɨgiaꞌ gu Mariiya, Jesuus jap tɨɨtgɨꞌ, na guꞌ dhiꞌ ya jaꞌp uañchudaꞌ gu ja uaꞌtulhdharaꞌ gu Israel kam jaꞌtkam. Puiꞌ ku baꞌr am na puꞌñi jaꞌk tɨɨꞌnkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Baꞌ dhiꞌ puꞌñi jaꞌk tum duu janoꞌ nat tum kuugalh gu puiꞌ nat jax jaꞌk tɨꞌɨɨk bɨjɨk guch Gɨꞌkoraꞌ nat bhaan jim uaꞌrgidhak maadɨt guiꞌ nam bɨjɨk bhaankam tu aꞌgimɨk, nat puiꞌ jaꞌk tu uaꞌnak na jaꞌpnim kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Dɨɨlh pɨx ba tɨgiaꞌ gu alhii maaꞌn gu ubii tɨyaa. Emanoil jam baꞌ tɨɨtgɨꞌ. Baꞌ dhiꞌ jaꞌp kaiꞌñkam jup jum kaiꞌch: Jich aꞌm tɨ nɨiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Baꞌ nat paiꞌ dhuuk ba ñiñia gu Josee, cham jax ji chɨꞌɨɨk bhaiꞌp ji bhɨi gu Mariiya na jax ba tɨtda gu nobiiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ku guꞌ chakui maap jix bhaiꞌ tu oiꞌñcha mɨt ji jaꞌp na moo na jax noꞌm jir jum bɨpnagɨm. Dai gatuuk nat paiꞌ dhuuk ba tɨɨ gu alhii gu Mariiya na mɨt baꞌ maap ba tu oiꞌñcha. Baꞌ gu Josee, Jesuus tɨɨt gu alhii nat jax chia na tɨɨtgɨꞌ gu nobiiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Baꞌ gu Jesuus bhammɨ maaxir na paiꞌ puiꞌ tɨ tɨɨꞌ Beleen guiꞌ na bhaan bipioꞌ gu Judea dɨbɨɨr, baꞌ janoꞌ maaxir na paiꞌ dhuuk jir gɇꞌkam kaꞌ gu Eroodis na jɨꞌx jir Judea. Baꞌ janoꞌ jɨꞌkchi bhammɨp ba ji bubua mɨt Jerusaleen guiꞌ nam mu jaꞌk oiꞌñkaꞌ xiaꞌlhbui, guiꞌ nam jix maatɨt ja nɨiꞌñdhaꞌ gu chiichiaꞌ, na mɨt muiꞌ ba tɨɨgim guch Xoiꞌkam nat ba maaxir. ");
INSERT INTO stpNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Baꞌ bhaiꞌ ba tɨ tɨkka am na sap pa jaꞌk jax chuꞌiiꞌ, jup kaiꞌch am: ―¿Pa jaꞌk jax chuꞌiiꞌ guch Xoiꞌkam guiꞌ nat ba maaxir, guiꞌ na saak jir ja gɇꞌkam tuk kaꞌ gu yaꞌ kam dhi Israel? Maaꞌn tɨɨ chich gu gɇꞌ chiꞌɨɨꞌ na puiꞌr jum duukam nat yaꞌ paiꞌ ba maaxir guch Xoiꞌkam. Puiꞌ ku chich baꞌ aach moo bhaiꞌ xi jii na chich bhaiꞌ bha tu daañim buiñor. ");
INSERT INTO stpNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Baꞌ gampaiꞌ ji dhuu gu Eroodis nat puiꞌ jɨꞌ ja kai, panaas kut giilhim jix buam jum ɨlh, gio gu jaiꞌ nam jɨꞌk bhaiꞌ oiꞌdhaꞌ Jerusaleen ba puiꞌ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Baꞌ ba ja bai gu Eroodis gu ja gɇꞌgɇrkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, baꞌ bhaiꞌ ba ja tɨkka na paiꞌ baꞌ puiꞌ maaxilhiaꞌ guch Xoiꞌkam guiꞌ na saak Dios bha jootsaꞌ jix dhaam dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Baꞌ guiꞌp tɨtda am: ―Dho miꞌ dho saak na paiꞌr Beleen guiꞌ na bhaan bipioꞌ yaꞌ dhi Judea dɨbɨɨr, na guꞌ puiꞌm kaiꞌch gu ñioꞌkiꞌñ gu Dios miꞌ nat paiꞌ tu uaꞌnak maadɨt guiꞌ nam bɨjɨk bhaankamuꞌn tu aꞌgimɨk, na jaꞌpnim kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Baꞌ aapiꞌm na pim jɨꞌk miꞌ oiꞌdhaꞌ na paiꞌ puiꞌ tɨ tɨɨꞌ Beleen, guiꞌ na bhaan bipioꞌ gu Judea dɨbɨɨr, cham tuꞌ gampaiꞌ bipioꞌ pim, sia ku guꞌ jaiꞌ kap tɨi gɇꞌgɇr jir kikcham yaꞌ dhi Judea, na guꞌ miꞌ aapiꞌm jam bui maaꞌn maaxilhiaꞌ guiꞌ nar gɇꞌkam kaꞌ ja bui guñ jaꞌtkam tuk Israel kam. ");
INSERT INTO stpNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Baꞌ ba ja bai ɨp gu Eroodis guiꞌ nam jix maatɨt nɨiꞌñdhaꞌ gu chiichiaꞌ, baꞌ mu jaꞌp dɨlhkob jix xɨꞌlhim ba ja tɨkka nam paiꞌ baꞌ duuk mu paiꞌ pu nɨiꞌñ gu gɇꞌ chiꞌɨɨꞌ na bhaan jix maatɨꞌ nat ba maaxir guch Xoiꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Baꞌ daipuꞌ nat xi ja tɨkkak muiꞌ xi ja joot mu jaꞌk Beleen, jup ja tɨtda: ―Ea na pim mu jimiaꞌ mu Beleen. Mi jaꞌp japim naiꞌ tu gaaꞌngɨmɨi tɨgiaꞌ gu alhii guiꞌ na puiꞌr jich Xoiꞌkam. Baꞌ noꞌ pimɨt miꞌ paiꞌ tɨɨ, yaꞌ pim xiñ aaꞌñdhidhat na pim paiꞌ dhuuk gio jaꞌk jup ba suulhgiaꞌ na paiꞌ sɨlh jup tuiꞌkaꞌ, nañ baꞌ aañ muiꞌp jimiaꞌ nañ tu daañmɨraꞌ buiñor. ");
INSERT INTO stpNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Baꞌ guiꞌ daipuꞌ nat jax puꞌñi xi ja tɨɨꞌn gu Eroodis, pu jii mɨt. Baꞌ gamaiꞌ gu bɨɨx boi nam mu jiim, bɨɨpɨꞌ gamaiꞌ ba jim gu gɇꞌ chiꞌɨɨꞌ bha jaꞌp jix dhaam, guiꞌ na mɨt bɨɨpɨꞌ dɨr mummɨ jaꞌk tɨɨ ja kiꞌaam na bha jaꞌp daa jix dhaam, baꞌ muiꞌ pu jim bha jaꞌp jix dhaam gammɨjɨ nam jax jiim gu bɨɨx boi. Baꞌ na mɨt paiꞌ dhuuk ba ai mummɨ Beleen, bhaiꞌ pɨx jaꞌp ji dhaibu gu gɇꞌ chiꞌɨɨꞌ sɨlh miꞌ na paiꞌp tuꞌiiꞌ gu alhii guiꞌ nar jich Xoiꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Baꞌ joidham jix bhaiꞌm ɨlh jamɨt guiꞌ nam jix maatɨt ja nɨiꞌñdhaꞌ gu chiichiaꞌ na mɨt ba tɨɨ gu gɇꞌ chiꞌɨɨꞌ nat bhaiꞌ pɨx jaꞌp ji dhaibu, nam guꞌx maat na miꞌ bap tuꞌiiꞌ guch Xoiꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Baꞌ na mɨt muiꞌ ji baap mɨjɨ baꞌk chɨr, miꞌ pɨx ji chɨɨ mɨt gu alhii na mi jaꞌp daa, gio gu dɨꞌɨɨꞌn. Baꞌ nam jax jiim, ja oꞌlhia kɨꞌn guꞌkɨk bhaiꞌ ji chu daanɨ mɨt buiñor gu alhii guiꞌ nar jich Xoiꞌkam, gio na mɨt xi chu kukpioꞌkak mi jaꞌp xi chu dalhxi guiꞌ na miꞌ tu jim guiꞌ nax dhaꞌram tu namɨɨk, puiꞌ na jax gu diꞌoor, gio guiꞌ na joidham uub, gio baꞌ guiꞌ na kɨꞌn tum kubhiondaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Gatuuk baꞌ dai na mɨt mi jaꞌp ba tɨbia. Baꞌ ba tɨ tɨɨtkɨ mɨt na sap cham bhaaiꞌ nam mu jaꞌk ka jiimdaꞌ buiñor gu Eroodis, na guꞌx bhaam buiñor gu alhii guiꞌ nar jich Xoiꞌkam. Baꞌ maakam jaꞌk bhɨi mɨt na mɨt paiꞌ dhuuk ba jii mu jaꞌk ja kiꞌaam. ");
INSERT INTO stpNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Baꞌ gatuuk na mɨt paiꞌ dhuuk ba jii guiꞌ nam jix maatɨt ja nɨiꞌñdhaꞌ gu chiichiaꞌ, ba tɨɨ gu Josee maaꞌn gu nobiiꞌñ gu Dios tɨɨtkiꞌ bhaan, baꞌp tɨtda: ―Xi bamiiꞌ Josee, jix kɨɨꞌ bim duuñ kup maiꞌ daiꞌññiaꞌ mu jaꞌk Ejipto, xi bhɨɨji ap dhi alhii, gio gu dɨꞌɨɨꞌn jap bɨɨx jup xi baidhai. Mummɨp baꞌ moo pɨx daakaꞌ, aañ dɨɨlh bam aagiꞌñdhaꞌ na paiꞌ dhuuk jix bhaaiꞌn kaꞌ nap gio bhaiꞌp ba jimiaꞌ, na guꞌ yaꞌ gu Eroodis bha jimdaꞌ jia na bha gaaꞌmɨraꞌ dhi alhii na baꞌ yaꞌ muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Baꞌ nat paiꞌ dhuuk ba ñiñia gu Josee, pu tukaaꞌñ chaꞌm miꞌ bhɨi nat maiꞌ ba mɨɨ mu jaꞌk Ejipto, xi bhɨɨk gu alhii gio gu dɨꞌɨɨꞌn bɨɨx jup xi baidhak. ");
INSERT INTO stpNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mu jaꞌk baꞌ pu daakaꞌ na jɨꞌx duakat gu Eroodis. Baꞌ dhiꞌ puꞌñi jaꞌk jum kuugalh gu puiꞌ nat jax jaꞌk tɨꞌɨɨk gu Gɇꞌkam jich Gɨꞌkoraꞌ bhaan jim uaꞌrgidhak maadɨt guiꞌ nam bɨjɨk bhaankam tu aꞌgimɨk, nat puiꞌ jaꞌk tu uaꞌnak na jaꞌpnim kaiꞌch: “Mummɨ dɨr Ejipto ñich bha jaꞌk bai guñ mar.” ");
INSERT INTO stpNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Baꞌ nat paiꞌ dhuuk puiꞌ ba tɨ kai gu Eroodis na mɨt maakam jaꞌk pɨx ba bhɨi guiꞌ nam jix maatɨt ja nɨiꞌñdhaꞌ gu chiichiaꞌ, giilhim bhaiꞌ ji bhaam, na guꞌ tɨi ka ja nɨɨrat nam saak gio bhaiꞌ bhɨɨyaꞌ gɨt nam bhaiꞌ xi aaꞌñdhidhaꞌ gɨt na paiꞌp tuꞌiiꞌ guch Xoiꞌkam. Baꞌ mu ja joot gu sandaaruiꞌx chugiꞌñ mu Beleen nam sap ja koodaꞌ bɨɨx gu aꞌaalh nam jɨꞌk miꞌ jaiꞌch kaꞌ, sia guiꞌ nam mu jaꞌp oiꞌñkaꞌ juꞌñdharan. Baꞌ dai guiꞌ nam jɨꞌk jix ioꞌm jir aꞌlhich tu chia nam ja koodaꞌ, gio guiꞌ nam jɨꞌk gook oidhaꞌ ba biaꞌ, na jɨꞌx ɨlhiiꞌñ na bar gɇꞌ guch Xoiꞌkam janoꞌ dɨr nam paiꞌ dhuuk tu aagiꞌñ na mɨt tɨɨ gu gɇꞌ chiꞌɨɨꞌ guiꞌ nam jix maatɨt ja nɨiꞌñdhaꞌ gu chiichiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Baꞌ dhiꞌ puꞌñi jaꞌk jum kuugalh gu puiꞌ nat jax jaꞌk tu uaꞌnak gu Jeremiiyas guiꞌ na bɨjɨk bhaankamuꞌn tu aꞌgimɨk na jaꞌpnim kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Mu na paiꞌ puiꞌ tɨ tɨɨꞌ Ramaa pɨx giilhim tɨm tɨi nat bhaiꞌ ji chum susuanɨ, panaas kum giilhim jix buam jum aagɨt gɇꞌgɇr kɨꞌn suan, guꞌ bak gu Rakeel na suak na mɨt ba ja koi gu maamraꞌn. Baꞌ cham jɨꞌx tɨ jɨjɨkgɨr na guꞌ giilhim jix buam jum aaꞌ, nam guꞌ ba koꞌiix gu maamraꞌn na xi ja nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Baꞌ gatuuk nat paiꞌ dhuuk ba muu gu Eroodis gio buiñor jup bam maax gu Josee gu nobiiꞌñ gu Dios na mu jaꞌk ka daa Egipto, baꞌp tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Xi bamiiꞌ Josee. Xib baꞌ bax bhaaiꞌ nap giop ba jimiaꞌ bhammɨ jaꞌk Israel, xi bhɨɨji ap dhi alhii gio dhi dɨꞌɨɨꞌn jap bɨɨx jup xi baidhai, na mɨt guꞌ ba koi guiꞌ nam jaroiꞌ kax bhaamkidhat dhi alhii. ");
INSERT INTO stpNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Baꞌ gu Josee nat jax jup bam pu jii ɨp bhammɨ jaꞌk Israel, xi bhɨɨk gu alhii, gio gu dɨꞌɨɨꞌn bɨɨx jup xi baidhak. ");
INSERT INTO stpNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Guꞌ ji na guꞌ nat chakui bhammɨ ai, puiꞌ ba tɨ kai na gu Arkelao bhaiꞌp bar gɇꞌkam na jɨꞌx jir Judea, guiꞌ nar maraaꞌn gu Eroodis kat. Baꞌ puiꞌ cham muiꞌ ka ai gu Josee, na guꞌx ɨɨbhiꞌñ. Baꞌ gio buiñor jup bam maax gu nobiiꞌñ gu Dios tɨɨtkiꞌ bhaan, baꞌ puiꞌ tɨtda na mu jaꞌk bhɨɨyaꞌ Galilea. Baꞌ gu Josee pu sɨlh bhɨi ɨp mu jaꞌk na paiꞌ tu aagiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Baꞌ nat jax mummɨ ai, miꞌ dhɨr mu jaꞌk jup bhɨi na puiꞌ tɨ tɨɨꞌ Nasareet. Baꞌ dhiꞌ puꞌñi jaꞌk jum kuugalh gu puiꞌ na mɨt jax jaꞌk tu uaꞌnak guiꞌ nam bɨjɨk bhaankam tu aꞌgimɨk gu Dios, na saak guch Xoiꞌkam puiꞌ jaꞌk jix mat kaꞌ am gu jaꞌtkam: Jesuus Nasareet kam. ");
INSERT INTO stpNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Baꞌ janoꞌ mu jaꞌp gampɨx jix chu gak kɨr guiꞌ na bhaan bipioꞌ gu Judea dɨbɨɨr, pɨx ba kaiꞌñkaꞌ gu Juan jaꞌtkam bopkondam na oirɨt tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam, ");
INSERT INTO stpNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","jup ja tɨtdadaꞌ: ―Yaꞌ mam ai na paiꞌ dhuuk maaxik jum maaxdhaꞌ gu Dios aapiꞌm jam bui. Miꞌ pim sap puiꞌ ba jimiaꞌ na jax jix aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Baꞌ gu Juan jaꞌtkam bopkondam jir diꞌ na aagɨt jup kaiꞌch gu Isaiiyas guiꞌ na bɨjɨk bhaankamuꞌn tu aꞌgimɨk gu Dios nat puiꞌ jaꞌk tu uaꞌnak na jaꞌpnim kaiꞌch: Maaꞌn gu maaꞌnkam mu jaꞌp gampɨx jix chu gak kɨr pɨx oirɨt ba tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam, jup ja tɨtdadaꞌ: “Gor jix kɨɨꞌ bim duuñ, jaꞌp pɨk bhaiꞌ bar jimdam gu Gɇꞌkam. Miꞌ pim sap puiꞌ ba jimiaꞌ na jax jix aaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Baꞌ gu Juan gu tɨiꞌdhar gaꞌn, kameeyo bapoo jir jup duiñxim kaꞌ, gio gu bhiisparuꞌn jir joꞌ kaꞌ ɨp. Gio baꞌ gu koiꞌdhar gaꞌn, gu sossoi ɨp na ja daꞌngɨt ja kuaꞌdaꞌ gio baꞌ gu mɨɨbat guiꞌ na mu jaꞌp gampɨx jix jaiꞌch kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Baꞌ muiꞌ jaꞌtkam miꞌ aajidhaꞌ am miꞌ na paiꞌ oirɨdaꞌ gu Juan nam jix kaim kaꞌ na jax tu aꞌgadaꞌ, puiꞌ na jax gu Jerusaleen kam, gio baꞌ guiꞌ nam mu jaꞌp jup oiꞌñkaꞌ bɨɨx kap guiꞌ na dhiꞌ pɨx bhaan jup bipioꞌ gu Judea dɨbɨɨr, gio baꞌ guiꞌ nam jɨꞌk mi jaꞌp amuub jup oiꞌdhaꞌ na paiꞌr Jordaan Ak. ");
INSERT INTO stpNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Baꞌ puiꞌ ba tɨtdadaꞌ am gu Juan nam sap cham ka aaꞌ nam puiꞌ jaꞌk tu jimdaꞌ na jax bɨɨpɨꞌ dɨr nam bɨɨx aixim jum uaꞌtulhiꞌñdhaꞌ, baꞌ gu Juan dai na xi ja bopkondaꞌ suudaiꞌ kɨꞌn miꞌ na paiꞌr Jordaan Ak. ");
INSERT INTO stpNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Baꞌ janoꞌ muiꞌ miꞌp ba ai mɨt guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ gio baꞌ guiꞌ nam saduseos jup jum tɨɨtɨꞌndaꞌ nam puiꞌp xim bopkonamtuꞌ. Baꞌp ja tɨtda gu Juan: ―¿Jaroo jam aagiꞌñ na cham xiim jam tulhiiñchudaꞌ gu Dios ku pim baꞌ gaꞌm ba jiim na pim jix aaꞌ nañ jam bopkonaꞌ na baꞌ cham jam tulhiiñchudaꞌ? Giilhim guꞌ na pim jix bhaaꞌmnaꞌ jaꞌp na gu kookoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Guꞌ dhiꞌ jam aꞌm jum aaꞌ ji na pim yaꞌ dɨr jaꞌp jaꞌk jix kɨɨꞌp jum duukam bap tu buadaꞌ na baꞌ bhaan jix maatɨꞌ kaꞌ na pim sɨlhkam miꞌ puiꞌ ba jiim na jax jix aaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Chaꞌpim jax jum aaꞌndaꞌ: “Aach matgɨm jich aꞌm tɨ nɨiꞌñ ji gu Dios, nach guꞌr bopxiꞌñ gu Abraam.” Jax dhui na guꞌ gu Dios sia guꞌñi joodai jix bhaaiꞌ na puiꞌ ja duñiaꞌ nam jir bopxiꞌñ kaꞌ gu Abraam, aapiꞌm baꞌ jaꞌp xi jam dui noꞌ pimɨt cham miꞌ puiꞌ jii na jax jix aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Baꞌ amuub ba kaat gu baiñdhas guiꞌ na kɨꞌn jum ɨꞌkiaꞌ gu takaaꞌn gu ɨꞌɨɨx, na guꞌ gu jax chuꞌm ɨꞌɨɨx noꞌ cham kɨɨꞌ tu iꞌbhaiꞌñchar, jix bhaaiꞌ nam ɨɨkɨi mu baas buaji bhaiꞌ xi mɨidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Baꞌ aañ nañ xib yaꞌ tu bopkon, jir suudaiꞌ kɨꞌn pɨx, jaꞌppɨx na bhaan jix maatɨꞌ kaꞌ nam jɨꞌk miꞌ puiꞌ jimiim na jax jix aaꞌ gu Dios. Baꞌ guiꞌ na gatuuk bha jim, guiꞌ dho gi guꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ ji na kɨꞌn jam bopkonaꞌ, gio baꞌ na bɨɨx mɨidhaꞌ gu jam uaꞌtulhdharaꞌ jaꞌp tuꞌm na gu tai kɨꞌn. Baꞌ guiꞌx ioꞌm bɨxchuꞌx aichuꞌn na pu tu duñiaꞌ, cham tuꞌ puiꞌ na jax aañ. Pu cham jɨꞌx jir jupaabkamuꞌn iñ dho moo nam iam tuꞌ suuskaꞌn muiꞌ ba uiꞌdhikaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Baꞌ na paiꞌ dhuuk bha jimdaꞌ, pu uaꞌkaꞌ guiꞌ na kɨꞌn jɨlhbidhaꞌ gu tiriik, baꞌ xi kɨɨꞌmpigai dai ba ulhñaꞌ guiꞌ na jɨꞌk jix kɨɨꞌ, gu tanaaraꞌ baꞌ mu jaꞌk xi ñuꞌaaꞌ na paiꞌ cham jɨꞌxkat tuutkɨ gu tai. ");
INSERT INTO stpNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Baꞌ janoꞌ jɨꞌ na mummɨ gampɨx jix chu gak kɨr oirɨt ja bopkon gu Juan gu jaꞌtkam, miꞌ dhɨr muiꞌ ma jii Galilea gu Jesuus nat ba chiañim ɨp na puiꞌp bakuanaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Baꞌ nat paiꞌ dhuuk mummɨ ba ai, jaꞌkbuiꞌ kat bhaiꞌ bax aaꞌ gu Juan na bakuanaꞌ gu Jesuus, jup tɨtda: ―Guꞌ aañ puiꞌ ɨlhiiꞌñ ji nap aap jaꞌkbuiꞌ kat jiñ bakuanaꞌ, guꞌ aap jaꞌkbuiꞌ kat bhaiꞌ bañ chiañim nañ jum bakuanaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Baꞌp tɨtda gu Jesuus: ―Dho guꞌr am kat dho jia, guꞌ pɨx ji na guꞌch aꞌm jum aaꞌ nach puiꞌ jaꞌk tu kuugalhdhaꞌ na jax tu uaꞌñix gu ñioꞌkiꞌñ gu Dios. Baꞌ puiꞌ cham jax ka tɨi gu Juan, dai nat ba bakua gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Baꞌ nat jax miꞌ dhɨr gamaiꞌ ji buus gu Jesuus suudaiꞌ chɨr, panaas kut joidham bhaiꞌ jim kukpioꞌ gux dhaam, baꞌ ba tɨɨ gu Jesuus nat maaxik bhammɨ dɨr bhaiꞌ ji chɨm gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ jaꞌp tuꞌm na gu giodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Miꞌ dhɨr baꞌ bhaiꞌ ji chum ñio bhammɨ dɨr jix dhaam, jup tum kaiꞌch: ―Dhiꞌñir diꞌ guñ mar nañ jix ioꞌm jix dhaꞌ, na ñich guꞌ pu bɨjɨk dɨr bhaan tɨ tɨɨ. ");
INSERT INTO stpNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Baꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ puiꞌ jaꞌk xi jurtuda gu Jesuus na mu jimiaꞌ mummɨ gampɨx jix chu gak kɨr na sap baꞌ miꞌ maiꞌchiaꞌ gɨt gu jaꞌook. ");
INSERT INTO stpNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Baꞌ mam saabu gook ooꞌm tanoolh gio gook ooꞌm tukaaꞌ nat pu cham tuꞌ juu, baꞌ gatuuk jix ioꞌm tɨi bax bhioꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Baꞌ miꞌ ba ai gu jaꞌook na tɨi bax maiꞌchim, jup tɨtda: ―Eap puiꞌ xi ja tɨɨꞌn dhi joodai na paan jup jum duñiaꞌ noꞌp baabuiꞌ sɨlhkam Dios jir Maraaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Baꞌp tɨtda gu Jesuus: ―Jax dhui nap jum kaiꞌch gu ñioꞌkiꞌñ gu Dios miꞌ na paiꞌ tu uaꞌñix na cham tuꞌ dai tuꞌ koiꞌ kɨꞌn dua gu maaꞌnkam, guꞌ jaꞌpji sia ji noꞌ miꞌ puiꞌ jim na jɨꞌk jax jum kaiꞌch gu ñioꞌkiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Baꞌ gatuuk ma baidhak gu jaꞌook gu Jesuus bhammɨ Jerusaleen na tɨi ɨlhdhat na ma maiꞌchiaꞌ gɨt. Baꞌ bhɨjɨmmɨ daam dɨr kuugaran gu gɇꞌ chiop xi chɨsaaꞌñdhak bhaiꞌ na paiꞌx ioꞌm jix chu xidhuu kaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","jup tɨtda baꞌ bhaiꞌ xi kɨɨsak kookbaꞌn: ―Eap yaꞌ dɨr muiꞌ xi chuudaiñ noꞌ pich moo baabuiꞌ cham muu, na baꞌx maatɨꞌ kaꞌ noꞌp baabuiꞌ moo sɨlhkam Dios jir Maraaꞌn. Na guꞌp jum kaiꞌch miꞌ uꞌuan taꞌm na tu uaꞌñix na jaꞌpni muiꞌ jim kɨksa: Gu Dios bham joochxidhaꞌ gu noonbiꞌñ nam baꞌm nuukdaidhaꞌ, gio nam jum noonob am tu daagɨi tɇꞌkob jum uaꞌkaꞌ nap baꞌ cham jodai chaꞌm jutbui ɨlhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Baꞌp tɨtda ɨp gio gu Jesuus: ―Jax dhui na moo jaꞌpnip jum kaiꞌch ɨp miꞌ na paiꞌ tu uaꞌñix gu ñioꞌkiꞌñ gu Dios na jaꞌpni muiꞌ jim kɨksa: “Cham jir am nap mamaiꞌchɨkdaꞌ gu Gɇꞌkam jich Gɨꞌkoraꞌ, na guꞌx ioꞌm jix xidhuu.” ");
INSERT INTO stpNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Baꞌ gatuuk maakam jaꞌk tɨip baidhak gu jaꞌook gu Jesuus maaꞌn kap na paiꞌ tɇꞌkob jir oidhaꞌ taꞌm, baꞌ bhammɨ kookbaꞌn xi kɨɨsak mu jaꞌp naiꞌ xi chu joojoiꞌñchuda bɨɨx kap na jɨꞌx jir oiꞌñgaꞌn na baꞌ tɨ tɨgiaꞌ na jɨꞌk tuꞌ naiꞌ jaꞌp jix chu jaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Miꞌ dhɨr baꞌ moop tɨtda: ―Dhiꞌ bɨɨx nap jɨꞌk tuꞌ mu jaꞌp nɨiꞌñ nax chu jaiꞌch, dhiꞌ bɨɨx jir aañ gaꞌn. Baꞌ aañ bɨɨx tum makiaꞌ noꞌ pich miꞌñi jaꞌp jum oꞌlhia kɨꞌn xi kɨkbok bhaiꞌ xiñ dhaanɨ. ");
INSERT INTO stpNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Guꞌ ji na guꞌp tɨtda pɨx gu Jesuus: ―Mu bi jim jaꞌook. Chaꞌp tuꞌ kɨꞌn kañ juandaꞌ. Na guꞌp jum kaiꞌch ɨp miꞌ na paiꞌ tu uaꞌñix gu ñioꞌkiꞌñ gu Dios na jaꞌpni muiꞌ jim kɨksa: “Xi chu daanɨt ap buiñor gu Dios guiꞌ nar gɇꞌkam. Baꞌ dai guiꞌ buiñor jap pɨx tu daandaꞌ, cham tuꞌ jumai buiñor ɨp.” ");
INSERT INTO stpNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Baꞌ puiꞌ ma jii gu jaꞌook, nat guꞌ cham jɨꞌxkat maꞌiich gu Jesuus. Baꞌ miꞌ ba ai mɨt gu noonbiꞌñ gu Dios nam baꞌ palhbuidhaꞌ gu Jesuus gu tuꞌ na aꞌmiram jum aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Baꞌ nat paiꞌ dhuuk puiꞌ ba tɨ kai gu Jesuus na mɨt ba kuu gu Juan jaꞌtkam bopkondam, pu jii mu jaꞌk Nasareet guiꞌ na bhaan bipioꞌ gu Galilea dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Baꞌ miꞌ dhɨr mu jaꞌk jup bhɨi na paiꞌ puiꞌ tɨ tɨɨꞌ Kapernaum guiꞌ na mummɨ bipioꞌ na paiꞌ gɇꞌgɇr susdaꞌkaꞌ gu suudaiꞌ, miꞌ na paiꞌ jax bhaan bipioꞌ gu ja dɨrbaꞌ gu bopxiꞌñ gu Sabuloon gio baꞌ gu Neptalii. ");
INSERT INTO stpNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ba dhiꞌ puꞌñi jaꞌk jum kuugalh gu puiꞌ nat jax jaꞌk tu uaꞌnak gu Isaiiyas guiꞌ na bɨjɨk bhaankam tu aꞌgimɨk gu Dios na jaꞌpnim kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Baꞌ mummɨ na paiꞌ jax tɨ dɨrbaꞌ gu Sabuloon, gio baꞌ miꞌ na paiꞌ jax jup tɨ dɨrbaꞌ gu Neptalii, mummɨ na paiꞌ baasɨꞌn dɨr jaꞌk bipioꞌ miꞌ na paiꞌr Jordaan Ak, mummɨ nam paiꞌ oiꞌdhaꞌ guiꞌ nam cham jir Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Gu jaꞌtkam guiꞌ na jaꞌp ji buusan nam jix chu tukgam tɨr ka oipot na paiꞌx chu muukiꞌ, ampɨx ja aꞌm ton guiꞌ na jaꞌp ji buusan nax chu maax. ");
INSERT INTO stpNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Baꞌ janoꞌ dɨr miꞌ jɨꞌ dɨr bhaiꞌ ji chɨbgai gu Jesuus nat bhaiꞌ ji chu ja aꞌgi gu jaꞌtkam, jup ja tɨtdadaꞌ: ―Yaꞌ mam aiñ jaaduñ na paiꞌ dhuuk saak maaxik jum maaxdhaꞌ gu Dios aapiꞌm jam bui. Baꞌ dai na jam aꞌm jum aaꞌ na pim miꞌ puiꞌ ba jimiaꞌ na jax jix aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Baꞌ na mu jaꞌp ka jim gu Jesuus bɨɨx juꞌñdharan gu gɇꞌ suudaiꞌ guiꞌ na Galilea bhaan bipioꞌ, baꞌ miꞌ ba ja tɨɨ gook gu jaꞌtkam daim sɨspidhim nam mu jaꞌp buppaim suudaiꞌ chɨr maaꞌn gu gɇꞌ asaak nam miꞌ tu bhibhia gu boptop. Baꞌ maadɨt dhiꞌ jɨꞌ Simoon tɨɨꞌ, guiꞌ nam Peegro kɨꞌn jup jix mat kaꞌ, gu jumaiꞌ baꞌ Anrees jup tɨɨꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Baꞌ ba ja baidhim gu Jesuus nam sap kaichgɨdaꞌ, jup ja tɨtda: ―Aañ puiꞌ ɨlhiiꞌñ jiñ jaaduñ na pim xib dɨr jaꞌp jaꞌk bañ kaichgɨdaꞌ na pim baꞌ bar jaꞌtkam bhiadam kaꞌ, na pim tu ja aꞌgidhaꞌ gux bhaiꞌm kaiꞌchdham ñiꞌook. Baꞌ guiꞌ nam jɨꞌk tɨ jɨɨꞌñdhaꞌ, puiꞌ ji buusniaꞌ na pim ba ja bhiaꞌ jaꞌp na gu boptop. ");
INSERT INTO stpNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Baꞌ guiꞌ cham jax ji chɨꞌɨɨk jup ma oi mɨt. Miꞌ puiꞌ pup tu tuꞌiiꞌ gu gɇꞌgɇr ja aꞌsak guiꞌ nam kɨꞌn ka tu bhiadat gu boptop. ");
INSERT INTO stpNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Baꞌ gammɨjɨ gu bɨɨx juꞌñdharan gu gɇꞌ suudaiꞌ nam gamaiꞌ jiim, jaiꞌ miꞌp ba ja tɨɨ gu Jesuus gook gu jaꞌtkam nam puiꞌp jir jum sɨspidhim. Baꞌ maadɨt jir diꞌ gu Jakoobo, gu jumai baꞌr Juan, guiꞌ nam jir maamraꞌn gu Sebedeo. Baꞌ bhaiꞌ gɇꞌ kanuub taꞌm ji dharaat jix bhaiꞌ ka ja bua am gu gɇꞌgɇr ja aꞌsak guiꞌ nam kɨꞌn tu bhiadaꞌ gu boptop. Baꞌ gu Jesuus puiꞌp ba ja tɨtda nat jax ja tɨɨdak ja baidhak gu jaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Baꞌ guiꞌ puiꞌ cham jax ji chɨꞌɨɨk jup ma oi mɨt. Miꞌ puiꞌ pup tuꞌiiꞌ ɨp gu gɇꞌ ja kanuub guiꞌ nam bhaan ka tu bhiadat gu boptop, dai baꞌ gu ja taat miꞌ pup oirɨ. ");
INSERT INTO stpNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Baꞌ miꞌ dhɨr bɨɨx kap naiꞌ ji chu aꞌga gu Jesuus na jɨꞌx bhaan bipioꞌ gu Galilea dɨbɨɨr mu jaꞌp nam paiꞌ jax tu daandaꞌ gu dai Israel kam jaꞌtkam, na ja aaꞌñdhidhaꞌ gux bhaiꞌm kaiꞌchdham ñiꞌook nam jax jaꞌk duuji buiñor aayaꞌ gu Dios, gio baꞌ na xi ja duduaꞌñdhidhat guiꞌ nam jɨꞌk jix kakoꞌk kaꞌ na bɨɨx aixim tuꞌm ja ɇɇkaꞌ gu koꞌkdaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Baꞌ pɨx jaꞌx puiꞌ tu aꞌgadaꞌ am gu jaꞌtkam bɨɨx na jɨꞌx bhaan bipioꞌ gu Siiria dɨbɨɨr na gu Jesuus mu paiꞌ pɨx oirɨt jix kɨɨꞌp jum duukam jup tu bua. Baꞌ jaiꞌ dhɨt na bɨɨx aixim tuꞌm ja ɇɇkaꞌ gu koꞌkdaiꞌ, muiꞌ ma ja uꞌuuk jamɨt mummɨ na paiꞌ oirɨdaꞌ gu Jesuus na mɨt ba chiañim na ja duduaꞌñdhaꞌ, puiꞌ na jax guiꞌ nam jix ñanaanbiꞌ kaꞌ na ja aꞌm jup tuiꞌñgɨdaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ, gio baꞌ jaiꞌ guiꞌ nam ampɨx tu kaammukdaꞌ, gio baꞌ jaiꞌ guiꞌ nam jix mamaꞌmkulhiꞌ kaꞌ. Baꞌ bɨɨx ja duduaꞌñ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Baꞌ mu jaꞌp na jax jimdaꞌ gu Jesuus, muiꞌ jaꞌtkam pɨx chɨbɨɨp kattuꞌndaꞌ am nam oiꞌñchuꞌndaꞌ, puiꞌ na jax gu miꞌ kam Galilea, gio baꞌ jaiꞌ gu Dekaapolis kam, gio baꞌ gu Jerusaleen kam, gio baꞌ guiꞌ nam mu jaꞌp jup oiꞌñkaꞌ na paiꞌ jax bhaan bipioꞌ gu Judea dɨbɨɨr, gio baꞌ guiꞌ nam baasɨꞌn dɨr jup oiꞌñkaꞌ miꞌ na paiꞌr Jordaan Ak, na paiꞌ xiaꞌlhbui jaꞌk bipioꞌ guiꞌ gu dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Baꞌ na naiꞌ xi ja nɨiꞌñ gu Jesuus gu jaꞌtkam nam jix ioꞌm nammɨ xi juꞌ nam muiꞌ miꞌp tuꞌiiꞌ, baꞌ maaꞌn kap oidhaꞌ taꞌm xi jimɨɨk bha jaꞌp ji dhaibo. Baꞌ gu noonbiꞌñ muiꞌ ji ai mɨt amuub, ");
INSERT INTO stpNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","baꞌ gu Jesuus bhaiꞌ ji chu ja aꞌgi, jup ja tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Jaꞌp moo joidham jix bhaiꞌ tu ja jim guiꞌ nam jɨꞌk jix maat na ja aꞌm jum aaꞌ nam miꞌ puiꞌ jiimdaꞌ na jax jix aaꞌ gu Dios, na guꞌ gammɨjɨ ja aꞌm tɨ nɨidhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Jaꞌp moo joidham jix bhaiꞌ tu ja jim guiꞌ nam jɨꞌk jix buam jum aaꞌ, nam guꞌx maat na gu Dios gammɨjɨ ja guguuxiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Jaꞌp moo joidham jix bhaiꞌ tu ja jim guiꞌ nam jɨꞌk cham gɇꞌgɇrkam jum taat, na guꞌ gu Dios ja makiaꞌ guiꞌ nat tuꞌ ja iimchuda. ");
INSERT INTO stpNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Jaꞌp moo joidham jix bhaiꞌ tu ja jim guiꞌ nam jɨꞌk jaꞌp ji buan nam jix bhioꞌ gu ja iꞌiiꞌmdaꞌ am bhaan, nam jix aaꞌ nam gammɨjɨ miꞌ puiꞌ jiimdaꞌ na jax jix aaꞌ gu Dios, na guꞌ puiꞌ tu duñiaꞌ na puiꞌ ji buusniaꞌ nam jax ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Jaꞌp moo joidham jix bhaiꞌ tu ja jim guiꞌ nam jɨꞌk jix chu joiꞌgɨꞌn, na guꞌ gu Dios puiꞌx joiꞌmdaip ja tɨgiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Jaꞌp moo joidham jix bhaiꞌ tu ja jim guiꞌ nam jɨꞌk cham uꞌuaꞌtulhdhix gu ja jujur am bhaan, nam guꞌx maat nar tuꞌp tuꞌm daꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Jaꞌp moo joidham jix bhaiꞌ tu ja jim guiꞌ nam jɨꞌk gammɨjɨr jix bhabhaiꞌkam kaꞌ, na guꞌ gu Dios puiꞌ ja iim nam jir maamraꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Jaꞌp moo joidham jix bhaiꞌ tu ja jim guiꞌ nam giilhim jum tulhiiñ nam jix ja bhaamkiꞌñ gu jaꞌtkam nam miꞌ puiꞌ jiim na jax jix aaꞌ gu Dios, na guꞌ gammɨjɨ ja aꞌm ba tɨ nɨidhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Jaꞌp moo joidham jix bhaiꞌ tu jam jimiaꞌ noꞌ pim cham jax jum aaꞌ nam paiꞌ dhuuk giilhim jam tɨtdadaꞌ gu jaꞌtkam, piam noꞌm buam pɨx jam bua, piam noꞌm bɨɨx aixim jam iattulhiꞌñ nam xi jam bhaamkidhat na pim tɨ jɨɨgiꞌñ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Baꞌ aapiꞌm cham jax jum aaꞌndaꞌ sia kum cham jam kɨɨgalhiꞌñ gu jaꞌtkam, jix bhaiꞌ pim pɨx jum taat kaꞌ, na pim guꞌ maiꞌchiaꞌ gux dhaꞌram namkɨm bhammɨx dhaam. Na guꞌ sia guiꞌ nam jɨꞌk bɨjɨk ya jaꞌp bhaankam jup tu aꞌgimɨk gu Dios puꞌñi cham jup ja kɨɨgalh jamɨt gu jaꞌtkam, dai na mɨt bɨɨx aixim ja buimɨk ja koi nam cham ja kaim kaꞌ nam tɨi tu ja aagiꞌñdhaꞌ na jax jaꞌk jix aaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Baꞌ aapiꞌm jaꞌp ji buan yaꞌ dhi oiꞌñgaꞌn na jax gu on. Noꞌ gu on miꞌ jotmodaꞌ cham ka onkak, ¿jax japim dui ɨlhiiꞌñ na giop ka onkalhiaꞌ? Aañ pu kaiꞌch na cham jɨꞌxkat ka onkalhiaꞌ, pu cham tuꞌ ka bhaiꞌ kaꞌ dho baꞌ, dai na mu jaꞌp xim nuꞌaaꞌ dɨɨrap. Miꞌ dho guꞌ pu kɨɨyasaꞌ am gu jaꞌtkam nam mi jaꞌp oipodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Gio baꞌ moo jaꞌpnip ji buan japim yaꞌ dhi oiꞌñgaꞌn na jax gux chu maax, na guꞌ na pim jax bax maat jia paiꞌ jax chuꞌm oidhaꞌ taꞌm noꞌ daaꞌñxim jir gɇꞌ kiicham, na guꞌ mɨk dɨr jaꞌp bhammɨx chu maax kaꞌ, baꞌ cham jɨꞌxkat jum ɨxchuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ni na cham jaroiꞌ jaiꞌch gu maaꞌnkam na xi mɨichdhai gu kañdhiir mɨjɨ jaꞌp paiꞌ xi chaaꞌbidhaꞌ tuꞌ kɨꞌn, guꞌ jaꞌpji na bhammɨ jaꞌp xi kɨɨsaꞌ ji tɇꞌkob na baꞌx chu maax kaꞌ miꞌ nam paiꞌp tuiꞌkaꞌ guiꞌ nam miꞌ darkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Baꞌ aapiꞌm puꞌñi jaꞌk jup ji buan, jam aꞌm jum aaꞌ na pim jir jix bhabhaiꞌkam kaꞌ ja bui gu jaꞌtkam nam baꞌ ji jam tɨɨgɨi jaiꞌ bhaiꞌp ji chu dañiaꞌ buiñor guñ Gɨꞌkoraꞌ guiꞌ nax dhaam jup tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Aañ cham tuꞌ pu kaiꞌñkam bha jii ji nañ yaꞌ ja sooꞌmchulhdhaꞌ gu jaꞌtkam gu puiꞌ nat jax jaꞌk ja chianɨk gu Moisees nam miꞌ puiꞌ jiimdaꞌ gio gu puiꞌ na mɨt jax jaꞌk ja aaꞌñdhak guiꞌ nam bhaankamuꞌn tu aꞌgimɨk gu Dios, guꞌ aañ ji baꞌr diꞌ na ñich bhaiꞌ ba tu kuugalhdham na mɨt jax tu daasak. ");
INSERT INTO stpNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨtda, noꞌ gux dhaam ka pup jaiꞌch gio dhi dɨbɨɨr, chakui dho jɨꞌxdhat jum pataasaꞌ gu puiꞌ nat jax jaꞌk ja tɨɨdak gu Moisees nam miꞌ puiꞌ jiimdaꞌ gu jaꞌtkam, janoꞌ ji baꞌ na paiꞌ dhuuk bɨɨx ba tum kuugalhdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Baꞌ noꞌ jaroiꞌ cham tuꞌ kaꞌm nɨiꞌñ gu puiꞌ nat jax jaꞌk ja tɨɨdak gu Moisees nam miꞌ puiꞌ jiimdaꞌ gu jaꞌtkam, sia ku moo miꞌ paiꞌ maaꞌn kap tɨi cham pɨk jum aaꞌ, gio noꞌ cham ja aagiꞌñ gu jaꞌtkam nam baꞌ tuꞌ kaꞌm nɨiꞌñdhaꞌ, dho guꞌ palhɨɨp jup jum duukam bhaan ji biꞌyaꞌ dho jix dhaam jaꞌk buiñor gu Dios. Baꞌ gu jaroiꞌ noꞌ tuꞌ kaꞌm nɨiꞌñ, gio noꞌ xi ja aagiꞌñ gu jaꞌtkam nam tuꞌ kaꞌm nɨiꞌñdhaꞌ, dho guꞌ gɇꞌp jum duukam bhaan ji chu biꞌyaꞌ dho jix dhaam jaꞌk buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Baꞌ aañ pu jam tɨtda, noꞌ pim cham ja bhaiꞌbchichuꞌ guiꞌ nam sap jix maat kaꞌ gu ñioꞌkiꞌñ gu Dios gio guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, noꞌ pim guꞌ cham miꞌ puiꞌ jiim na jax jix aaꞌ gu Dios, dho guꞌ pu cham jɨꞌxkat aayaꞌ pim dhox dhaam na paiꞌ daa gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Na guꞌ na pim jax bax maat jia gu puiꞌ na mɨt jax jaꞌk tu ja daaxdhak gu jam bopxi kat nam jaꞌpni ja tɨtda: “Chaꞌp ja kooꞌndaꞌ gu jaꞌtkam, na guꞌ gu jaroiꞌ na puꞌñi ja kooꞌndaꞌ gu jaꞌtkam, giilhim tulhiiñchudaꞌ gu Dios, na guꞌ bam uaꞌtulhdhaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Baꞌ aañ yaꞌ pu jam tɨtda na sia ji nar uaꞌtulhdharaꞌ gu jaroiꞌ noꞌx bhaam pɨx buiñor gu jax chuꞌm jaꞌnniꞌñ, piam noꞌ giilhim tɨtda na jax cham jir am. Puiꞌ pɨx bax bhaaiꞌ nam daagɨi mu bhɨikaꞌ buiñor gu jax chuꞌm gɇꞌkam nam baꞌ miꞌ maap jum jumpadai tu aꞌgidhaꞌ. Piam noꞌx bhaamut jax tɨtda gu jaꞌnniꞌñ na cham juraaꞌn biaꞌ, dho guꞌ pu jimiaꞌ dho mu jaꞌk na paiꞌ gammɨjɨ miꞌ pup jum tulhiiñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Baꞌ noꞌ aapiꞌm maadɨt bax chu makgɨrxidham gu Dios, noꞌ pich guꞌ ampɨk ba tɨꞌñcho nam buix bhaam gu jax chuꞌm jum jaduuñ, ");
INSERT INTO stpNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jum aaꞌ nap bɨɨpɨꞌ mu jimɨi xi chu aꞌgiꞌñmɨrai na baꞌ cham ka bhaam kaꞌm bui. Gatuuk jap baꞌ miꞌ ɇɇji ba tu makgɨrxidhaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Piam ku guꞌ noꞌ jaroiꞌ ba xim iattulhdham buiñor gu jax chuꞌm gɇꞌkam, jum aaꞌ nap bɨɨpɨꞌ dɨr pu ba tu aꞌgidhaꞌ na baꞌ cham kam iattulhdhaꞌ. Na guꞌ noꞌt pu mummɨ bam aich buiñor gu gɇꞌkam, dho guꞌ dai dho na ba ja chiñiaꞌ gu sandaaruiꞌx chugiꞌñ nam jum kuupaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Baꞌ aañ yaꞌ pum tɨtda nap cham jɨꞌxkat buusniaꞌ miꞌ paiꞌ nam jum kuupaꞌ noꞌ pich cham tu namki nam jɨꞌk bham taandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Gio baꞌ moo jaꞌpni jaꞌk jup jum tɨi ɨp na pim jax bax maat jiñ jaaduñ: “Chaꞌp jix bhaiꞌ ja tɨtdadaꞌ gu uꞌuub guiꞌ nam tɨ bɨpnaꞌ, na guꞌr uaꞌtulhdharaꞌ buiñor gu Dios.” ");
INSERT INTO stpNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","’Baꞌ aañ yaꞌ pu jam tɨtda na sia ji nar uaꞌtulhdharaꞌ gu jaroiꞌ noꞌ tɨi tɨ bɨɨnaꞌ noꞌx joidhat nɨiꞌñ gu jax chuꞌm jumai ubii, na guꞌ puiꞌ ji buusniaꞌ na pu bɨɨmaꞌn ba boꞌyaꞌ sia kut puiꞌ pɨx jum aa. ");
INSERT INTO stpNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Baꞌ noꞌp guꞌ gu jax chuꞌm jum bui kɨꞌn jum uaꞌtulhiꞌñ, jir am nap jupnai baas buaꞌ. Cham jax bua sia kup maap dɨr pɨx ba tu bui, na guꞌ cham jir am noꞌ mɨt bɨnkam mu jaꞌk xim bua nap paiꞌ gammɨjɨ miꞌ pup jum tulhiiñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Piam ku guꞌ gu jax chuꞌm jum nob kɨꞌn jum uaꞌtulhiꞌñ ap, jir am ɨp nap ɨɨkɨi baas buaꞌ. Cham jax bua sia kup maap dɨr pɨx tu nob, na guꞌ cham jir am noꞌ mɨt bɨnkam mu jaꞌk xim bua nap paiꞌ gammɨjɨ miꞌ pup jum tulhiiñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Gio baꞌ moo jaꞌpni jaꞌk jup jum tɨi ɨp na tu aagix kaꞌ: “Gu jaroiꞌ noꞌt maiꞌ ba bua gu bɨngaꞌn, jum aaꞌ na bɨɨpɨꞌ xi chu uaꞌnai makiaꞌ na baꞌ bhaan jix maatɨt kaꞌ nam cham kar jum bɨpnagɨm kaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Baꞌ aañ yaꞌ pu jam tɨtda na cham jir am na maiꞌ buaꞌ gu jaroiꞌ gu bɨngaꞌn noꞌt cham jumai bɨɨmaꞌn tɨɨ. Baꞌ gu ubii noꞌt jumai tɨi xi oi gu chioꞌñ, dho guꞌ dai na bam uaꞌtulhdhaꞌ buiñor gu Dios, gio gu chioꞌñ ba puiꞌ ɨp noꞌt tɨi jumai bhaiꞌp ji bhɨi gu ubii noꞌ jumai tɨ bɨɨnaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Gio baꞌ moo jaꞌpni jaꞌk jup ja tɨɨdak jamɨt gu jam bopxi kat: “Moop miꞌ puiꞌ xi dhuñiidhat nap jax jaꞌk tu daasaꞌ buiñor gu Dios nap tu duñiaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Baꞌ aañ yaꞌ pu jam tɨtda na cham jir am na pim tu daꞌñxiꞌñdhaꞌ gu Dios na pim pu tu duñiaꞌ gu tuꞌ, na guꞌ giilhim jix xijai, cham pɨk jaroiꞌ miꞌ puiꞌ xi dhuñiaꞌ. Chaꞌpim jax kaiꞌchdhaꞌ na gux dhaam bhaan jix maatɨꞌ kaꞌ na pim puiꞌ tu duñiaꞌ, na guꞌ cham jir am, na guꞌ dhiꞌr diꞌ na bhaan daa guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni dhi oiꞌñgaꞌn ku pim bha aaꞌndaꞌ na bhaan jix maatɨꞌ kaꞌ na pim puiꞌ tu duñiaꞌ, na guꞌ dhiꞌ ya jaꞌp bhaan tɨ kɨisap guñ Gɨꞌkoraꞌ. Ni bhaiꞌ Jerusaleen ku pim cham bhaiꞌ tu aaꞌndaꞌ na bhaan jix maatɨꞌ kaꞌ, na guꞌ bhaiꞌr kiaꞌmiꞌñ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni sia gu aapiꞌm dɨɨlh jam moꞌ ku pim cham bha aaꞌndaꞌ, na pim guꞌ cham maat na pim jax dhui jix chuap duñiaꞌ gu jam kuup piam jix chuk, nim maaꞌn kuup dho moo kux bhaaiꞌ na pim maakam tuꞌm jup duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Baꞌ noꞌ pim jax kaiꞌch na jɨɨꞌ, pur maaꞌn ɨp na pim jax tɨꞌyaꞌ, cham tuꞌ na pim gatuuk maakam jup ba kaiꞌchdhaꞌ. Piam noꞌ pim jax kaiꞌch na cham, pur maaꞌn ɨp na pim jax tɨꞌyaꞌ. Na guꞌ noꞌ pim bɨɨx aixim kaiꞌch, dhiꞌ gux buam jum duukam pɨx puiꞌ jaꞌk jix aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Gio baꞌ moo jaꞌpni jaꞌk jup jum tɨi ɨp na pim jax bax maat jiñ jaaduñ: “Gu jaroiꞌ noꞌt jum bui am jum gɨɨꞌ, jir am nap aap puiꞌ bhaiꞌp gɨɨꞌbiaꞌ buiꞌran. Piam ku guꞌ noꞌt jum chiñ am jum gɨɨꞌ, jir am ɨp nap aap puiꞌ bhaiꞌp gɨɨꞌbiaꞌ chiñiꞌran.” ");
INSERT INTO stpNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Baꞌ aañ yaꞌ pu jam tɨtda na cham jir am na pim puiꞌ bhaiꞌp gɨɨꞌbiaꞌ gu jaroiꞌ noꞌt jam gɨɨꞌ, guꞌ jaꞌpji na pim pɨx am jix bhaiꞌ tɨtdadaꞌ ji. Puiꞌ na jax noꞌt jum kaam am jum gɨɨꞌ, jaꞌp dɨr jap mu jaꞌk jup xi dhaaꞌñdhaꞌ ku bham gɨɨꞌbiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Piam kut guꞌ jaroiꞌm iattulh buiñor gu jax chuꞌm gɇꞌkam, noꞌ guꞌ bham taan gum kutuun nap makiaꞌ, aap bɨɨx mu jaꞌk jup xi bhɨidhaꞌ gu daam dɨr kam jum kutuun. ");
INSERT INTO stpNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Piam noꞌt guꞌ jaroiꞌ jam chia na pim bhɨidhikaꞌ jɨꞌx juugɨt gu tuꞌ, aapiꞌm jix ioꞌm gama jaꞌk pup xi aichulhdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Piam ku guꞌ jaroiꞌ tuꞌ jam taan, aapiꞌm cham jax ji chɨꞌji xi makiaꞌ, cham tuꞌ na pim dai miꞌp ka ji ñiokboꞌ. Piam ku guꞌ noꞌ tuꞌm taiñbuiꞌñ, aapiꞌm cham jax ji chɨꞌji xi chaiñbuidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Gio baꞌ moo jaꞌpni jaꞌk jup jum tɨi ɨp na tu aagix kaꞌ na pim jax bax maat jiñ jaaduñ: “Dai guiꞌ nam cham jam bhaamkiꞌñdhaꞌ pim jix bhaiꞌ ja tɨtdadaꞌ, guiꞌ baꞌ nam xi jam bhaamkiꞌñ cham.” ");
INSERT INTO stpNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ku baꞌ guꞌ aañ yaꞌ pu jam tɨtda ji na cham jir am gu dhiꞌ puꞌñi jaꞌk na pim tu jimdaꞌ, guꞌ jaꞌpji na pim jaꞌkbuiꞌ kat pɨx am jix bhaiꞌ ja tɨtdadaꞌ ji guiꞌ nam jɨꞌk xi jam bhaamkiꞌñdhaꞌ. Gio baꞌ puiꞌ na jax guiꞌ nam jɨꞌk xi jam koodak kaꞌ, aapiꞌm ja aꞌmkam pɨx xi chu ja daañxidaꞌ buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Baꞌ dhiꞌ puꞌñi jaꞌk jir maamraꞌn kaꞌ pim guñ Gɨꞌkoraꞌ guiꞌ nax dhaam jup tuꞌiiꞌ, na guꞌ guiꞌ puꞌñir jix bhaiꞌkam jia, bɨɨx maaꞌn na jax ja ɨlhiiꞌñ gu jaꞌtkam. Tɨɨꞌ na bɨɨx ja bɨꞌñxiꞌñ kɨꞌn gu tanoolh guiꞌ nam jix uꞌuaꞌtulhdhix gio guiꞌ nam cham uꞌuaꞌtulhdhix, gio na bɨɨx ja dukxiꞌñ ɨp, cham tuꞌ jɨꞌk pɨx. ");
INSERT INTO stpNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Na guꞌ noꞌ pim aapiꞌm dai guiꞌx bhaiꞌ ja tɨtda nam jɨꞌk cham jam bhaamkiꞌñdhaꞌ, dho guꞌ pu cham jam aꞌm tɨ nɨidhidhaꞌ dho guñ Gɨꞌkoraꞌ, na pim guꞌ jaꞌp pɨx ba ji buandaꞌ na jax guiꞌ nam jir tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam. ");
INSERT INTO stpNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Piam ku guꞌ noꞌ pim dai gu jam jaaduñ pɨx ja ñioꞌkiꞌñ, dho guꞌ pu cham dho jam aꞌm tɨ nɨidhidhaꞌ dho guñ Gɨꞌkoraꞌ, na pim guꞌ jaꞌp pɨx ba ji buandaꞌ na jax guiꞌ nam cham tuꞌ kaꞌm nɨiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Baꞌ dhiꞌ puꞌñi jaꞌk jam aꞌm jum aaꞌ na pim gammɨjɨr jix bhabhaiꞌkam kaꞌ, jaꞌp na jax guñ Gɨꞌkoraꞌ guiꞌ nax dhaam jup tuꞌiiꞌ na gammɨjɨr jix bhaiꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Chaꞌpim maaxik ja nɨiꞌñchudat gu jaꞌtkam tu ja maakdaꞌ gu tuꞌ guiꞌ nam jɨꞌk cham tuꞌ biaꞌ. Na guꞌ noꞌ pim puꞌñi jaꞌk tu jim, cham jɨꞌxkat jam makiaꞌ guñ Gɨꞌkoraꞌ jix dhaam jaꞌk gux dhaꞌram namkɨm. ");
INSERT INTO stpNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Baꞌ na pim paiꞌ dhuuk tu ja maakdaꞌ gu tuꞌ guiꞌ nam cham tuꞌ biaꞌ, chaꞌpim jaroiꞌ aagiꞌñdhaꞌ na pimɨt tuꞌ ja onbaiꞌ, na guꞌ dhiꞌ guiꞌ nam sap pɨk baꞌ tuꞌ kaꞌm nɨiꞌñ gu Dios na puꞌñi jaꞌk ja koꞌraar nam mu jaꞌp puiꞌ ba tu aꞌgidhaꞌ na paiꞌ jax tum daandaꞌ gio baꞌ mu jaꞌp ɨrban gu gɇꞌ kiicham nam paiꞌ oipodaꞌ gu jaꞌtkam, sap nam baꞌ puiꞌ ja biaꞌkaꞌ gu jaꞌtkam nam joidham jir jix bhabhaiꞌkam. Baꞌ aañ yaꞌ pu jam tɨtda na daipuꞌ dhiꞌ kɨꞌn bar ja namkiꞌ gu puiꞌ nam jɨꞌk jax tu jim, cham tuꞌ ka maiꞌchiaꞌ am jix dhaam jaꞌk gux dhaꞌram namkɨm buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Guꞌ baꞌ na pim paiꞌ dhuuk tu ja maakdaꞌ gu tuꞌ guiꞌ nam cham tuꞌ biaꞌ, chaꞌpim jaroiꞌ aagiꞌñdhaꞌ, ni gu jax chuꞌm miaꞌn jam bhaiꞌ kaiꞌchdham tuk dho moo. ");
INSERT INTO stpNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Guꞌ jaꞌpji jix ɨxchuixim ji na pim tu ja maakdaꞌ, na baꞌ guꞌ guñ Gɨꞌkoraꞌ maaxik jam makiaꞌ gu tuꞌ na jam aꞌm jum aaꞌndaꞌ na puꞌñi ji jam tɨɨgɨi na pim jix ɨxchuixim jix bhaiꞌ tu bua. ");
INSERT INTO stpNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Gio na pim paiꞌ dhuuk tu daandaꞌ buiñor gu Dios, chaꞌpim puiꞌ jaꞌk tu daandaꞌ na jax guiꞌ nam sap pɨk baꞌ tuꞌ kaꞌm nɨiꞌñ gu Dios, na ja koꞌraar nam guꞌkat tu daandaꞌ mu jaꞌp na paiꞌ jax tum daandaꞌ gio baꞌ mu jaꞌp ɨrban gu gɇꞌ kiicham nam paiꞌ oipodaꞌ gu jaꞌtkam, nam sap baꞌ xi ja nɨiꞌñdhaꞌ nam sap pɨk baꞌ tu daandaꞌ buiñor gu Dios. Baꞌ aañ yaꞌ pu jam tɨtdañ jaaduñ na daipuꞌ dhiꞌ kɨꞌn bar ja namkiꞌ kaꞌ gu puiꞌ nam jɨꞌk jax tu jim, cham tuꞌ ka maiꞌchiaꞌ am jix dhaam jaꞌk gux dhaꞌram namkɨm buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Baꞌ noꞌ jaroiꞌ aapiꞌm maadɨt bax chu daañim, jum aaꞌ nap mu paiꞌ dɨlhkob xim kuupai jax chuꞌm baꞌk chɨr na baꞌ cham jaroiꞌm nɨiꞌñdhaꞌ nap tu daandaꞌ buiñor gu Dios. Baꞌ noꞌ puꞌñim nɨiꞌñ guñ Gɨꞌkoraꞌ nap jix ɨxchuixim tu daan, jum makiaꞌ dho jix dhaam jaꞌk gux dhaꞌram namkɨm. ");
INSERT INTO stpNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Baꞌ na pim paiꞌ dhuuk tu daandaꞌ, chaꞌpim pɨx puiꞌ ji kaiꞌchdhaꞌ jax ña pim jaꞌk tu daandaꞌ, na guꞌ dhiꞌ guiꞌ nam cham tuꞌ kaꞌm nɨiꞌñ gu Dios na puꞌñi jaꞌk ja koꞌraar nam tu daandaꞌ, nam guꞌ jaꞌp jum aaꞌndaꞌ na puꞌñi jaꞌk jix ioꞌm jix bhaiꞌ ja kaayaꞌ gɨt gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Baꞌ aapiꞌm cham puiꞌ jaꞌk tu daandaꞌ nam jax jaꞌk tu daan guiꞌam. Jax dhui na guꞌ guñ Gɨꞌkoraꞌ pu bɨɨpɨꞌ dɨr jix bhaiꞌ bax maat kaꞌ na tuꞌ jam aꞌm jum aaꞌndaꞌ, sia ku pimɨt chakui pu tɨi. ");
INSERT INTO stpNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Baꞌ jaꞌp japim kaiꞌchdhaꞌ na pim paiꞌ dhuuk tu daandaꞌ buiñor gu Dios: Aapiꞌ Gɇꞌkam jich Gɨꞌkoraꞌ nap jix dhaam jup tuꞌiiꞌ, nap jix ioꞌm jir jix uañ, ");
INSERT INTO stpNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","iam jap ja mattudaꞌ gu jaꞌtkam yaꞌ dhi oiꞌñgaꞌn nam jax jaꞌk duuji miꞌ puiꞌ jimiaꞌ nap jax jix aaꞌ, baꞌ gammɨjɨ ja aꞌm ba tɨ nɨidhidhaꞌ ap. Puiꞌ tɨich aaꞌ ich ɨp nap gɨt puiꞌ joidham jix bhaiꞌm duukam jup tu buadaꞌ ya jaꞌp dhi oiꞌñgaꞌn bhaan, jaꞌp nap jax jix bhaiꞌm duukam jup tu bua jix dhaam jaꞌk. Ku guꞌ aap dɨɨlh ji noꞌp moo puiꞌp jix aaꞌndaꞌ gɨt, aach puiꞌ pɨx tɨip jum kaiꞌchuꞌn ji. ");
INSERT INTO stpNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gio baꞌ dhich chutkuꞌ nam tuꞌ kɨꞌn jup dudua, aap gammɨjɨ nabap tanoolh xi ja maakidhat nam baꞌ kɨꞌn jum guguuxiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gio baꞌ nap iam tuch uañiꞌñkaꞌ ɨp nach jɨꞌx mach uaꞌtulhdhaꞌ aap jum bui, nach guꞌ aach puiꞌp tu ja uañiꞌñ guiꞌ nam puiꞌp jum uaꞌtulhiꞌñ aach jich bui. ");
INSERT INTO stpNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gio baꞌ nap gammɨjɨ jich aꞌm tɨ nɨidhidhaꞌ na baꞌ cham jich maiꞌchiaꞌ gux buam jum duukam. Jaꞌpni daipuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Na guꞌ noꞌ pim puꞌñi tu ja uañiꞌñ guiꞌ nam jum uaꞌtulhiꞌñ aapiꞌm jam bui, dho guꞌ puiꞌ dhop tu jam uañiꞌñkaꞌ guñ Gɨꞌkoraꞌ guiꞌ nax dhaam jup tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Guꞌ noꞌ pim cham tu ja uañiꞌñ guiꞌ nam jum uaꞌtulhiꞌñ aapiꞌm jam bui, dho guꞌ puiꞌ dho cham jup tu jam uañiꞌñkaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Gio baꞌ moo jaꞌp jañ jup xi jam tɨɨdam jiñ jaaduñ na pim cham tuꞌ puiꞌ jaꞌk tuiꞌkaꞌ na pim paiꞌ dhuuk jum saabdaꞌ na jax guiꞌ nam sap pɨk baꞌ tuꞌ kaꞌm nɨiꞌñ gu Dios, na ja koꞌraardaꞌ nam jaꞌp tuiꞌkaꞌ noꞌm jum saab na jax noꞌm jix buam jum aaꞌ, nam sap baꞌ xi ja nɨiꞌñdhaꞌ gu jaꞌtkam nam jum saab. Baꞌ aañ yaꞌ pu jam tɨtda na daipuꞌ dhiꞌ kɨꞌn bar ja namkiꞌ gu puiꞌ nam jɨꞌk jax tu jim. ");
INSERT INTO stpNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Baꞌ noꞌ pim aapiꞌm paiꞌ dhuuk ba xim saabum, jum aaꞌ na pim jix bhaiꞌ xim ikoimdhai, gio baꞌ na pim jix bhaiꞌ xim dui, ");
INSERT INTO stpNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nam baꞌ cham machiaꞌ gu jaꞌtkam na pim jum saab, guꞌ jaꞌpji daipuꞌ guñ Gɨꞌkoraꞌ guiꞌ nax dhaam jup tuꞌiiꞌ na baꞌx mat kaꞌ na pim jum saab. Baꞌ na puꞌñi jam nɨiꞌñdhaꞌ na pim jix ɨxchuixim jum saab, jam makiaꞌ dho jix dhaam jaꞌk gux dhaꞌram namkɨm. ");
INSERT INTO stpNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Gio baꞌ moo jaꞌpni jaꞌk jañ jup xi chu jam aꞌgidham jiñ jaaduñ, na pim cham tu jumpadidhaꞌ gu tuꞌx dhaꞌram namkɨm yaꞌ dhi oiꞌñgaꞌn bhaan, nam guꞌ ya jaꞌp jix jaiꞌch guiꞌ nam xi chu xibua na baꞌ miꞌ dhɨr cham tuꞌ ka bhaaiꞌñ kaꞌ, gio nam jix jaiꞌch gu ɨꞌxkum. ");
INSERT INTO stpNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Jix dhaam jaꞌk dho gi guꞌr am ji na pim jir jix chutumñigam kaꞌ, nam guꞌ cham jaiꞌch guiꞌ nam puꞌñi xi chu xibua, gio nam cham jaiꞌch gu ɨꞌxkum. ");
INSERT INTO stpNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Na guꞌ paiꞌ na pim tu biaꞌkaꞌ gu tuꞌx dhaꞌram namkɨm, miꞌ jaꞌk jup jujurtɨkaꞌ pim. ");
INSERT INTO stpNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Baꞌ gu jam buupui jaꞌp ji buan na jax gu kañdhiir noꞌ mɨim, na joidham gɇꞌ tanoordaꞌ na nammɨx chu maax kaꞌ. Baꞌ noꞌ gu jam buupui joidham jix kɨkɨɨꞌ, noꞌ guꞌ cham jɨꞌx jam ɇɇ gu buupui koꞌk, dho guꞌ joidham dho jix bhaiꞌx chu maax kaꞌ na pim naiꞌ xi chɨ nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Guꞌ ji noꞌ guꞌ gu jam buupui cham kɨkɨɨꞌ, noꞌ guꞌ jam ɇɇ gu buupui koꞌk, dho guꞌ pu cham tu maax kaꞌ dho na pim naiꞌ tɨi xi chɨ nɨiꞌñdhaꞌ, baꞌ pu cham bhaaiꞌñ kaꞌ dho na pim paiꞌ jaꞌk bhɨɨyaꞌ, na guꞌ jaꞌp ji buusandaꞌ na pim jix chu tukgam kɨr oipodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Gio baꞌ moo jaꞌpni jaꞌk jañ jup xi jam tɨɨdam jiñ jaaduñ, na pim dai gu Dios pɨx buiñor tu daandaꞌ, chaꞌpim gu tuumiñ bhaan jup jujurtɨkaꞌ. Na guꞌ na pim jax bax maat na cham tuꞌ jaroiꞌ jaiꞌch gu maaꞌnkam na gook kap tu juan, na guꞌ jumai pɨx jix bhaiꞌp tɨꞌyaꞌ gu gɇꞌkam, gio gu tujuandam jumai pɨx jix bhaiꞌp tu juañxidhaꞌ, gio mɨkkat jumai ɨp. Miꞌ pum buadaꞌ, pu cham jɨꞌxkat jax chuꞌm jix bhaiꞌ tu juañxidhaꞌ. Baꞌ aapiꞌm puꞌñip ji buandaꞌ noꞌ pim tɨi buiñor tu daan gu Dios gio noꞌ pim jɨꞌx tuumiñ bhaan jup jujurtɨk. ");
INSERT INTO stpNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Gio baꞌ moo jaꞌpni jaꞌk jañ jup xi jam tɨɨdam ɨp jiñ jaaduñ, na pim cham jax jum aaꞌndaꞌ sia ku pim cham ka biaꞌ na pim tuꞌ jugiaꞌ, piam noꞌ pim cham ka biaꞌ na pim tuꞌ iꞌyaꞌ, ni ku pim cham jax jum aaꞌndaꞌ na pim tuꞌ tɨꞌyaꞌ noꞌt ma saaskɨ gu jam jajannulh. Na guꞌ cham pɨk jum aaꞌ gu jajannulh gio gu koiꞌ, guꞌ guiꞌ ji nax ioꞌm jum aaꞌ na pim miꞌ puiꞌ duñiidhaꞌ na jax jaꞌk jix kɨɨꞌ kaꞌm nɨiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Guꞌ matgɨm gu tuꞌ na pim jugiaꞌ, dɨɨlh jam makiaꞌ ji guñ Gɨꞌkoraꞌ. ¿Jax japim gi ja nɨiꞌñ guꞌñi uꞌjiꞌ nam bha jaꞌp nɨnɨꞌ jix dhaam? Jaiñ nam cham paiꞌ tɨ ɨsdat tu kuaꞌ, ni nam cham paiꞌ tu baꞌpkichat mɨjɨ nammɨ ji chɨ kɨɨs gu tuꞌ nam kuaꞌ, na guꞌ tu ja maak guñ Gɨꞌkoraꞌ guiꞌ nat yaꞌ ja doꞌñcho dhi oiꞌñgaꞌn bhaan. Guꞌ gi baꞌ aapiꞌm nax ioꞌm xi jam daꞌ na pim jir jaꞌtkam, matgɨm jam makiaꞌ ji gu tuꞌ na jam aꞌm jum aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Gio na guꞌ cham jɨꞌxkat jaroiꞌ jaꞌkbuiꞌ oidhaꞌ duakaꞌ na jɨꞌk tɨi xi ɨlhiiꞌñdhaꞌ dɨɨlh, sia chi moo tɨi bɨɨx juraaꞌn kɨꞌn puiꞌm aaꞌ na jaꞌkbuiꞌ oiꞌdhaꞌ duakaꞌ gɨt, na guꞌ cham jaroiꞌ jɨꞌxkat dɨɨlh jup duñiaꞌ gu iiꞌmdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Baꞌ chaꞌpim jax jum aaꞌndaꞌ sia ku cham ka jaiꞌch na pim tuꞌ tɨꞌyaꞌ noꞌt ma saaskɨ gu jam jajannulh, na guꞌ dɨɨlh jam makiaꞌ guñ Gɨꞌkoraꞌ. ¿Jax japim gi nɨiꞌñ guꞌñi yooxiꞌ na miꞌñi jaꞌp tuut? Dɨɨlh pɨx na joidham tuꞌm ba yootaꞌ noꞌ bar gɇꞌgɇr, cham tuꞌ nam guꞌ ka jip tu duñiaꞌ gu ja tɨꞌaa, piam kum guꞌ mu paiꞌ ka ji chu juanpuꞌ nam baꞌ joidham jix aꞌbhar ma tɨm tɨiꞌdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Jax dhui na guꞌr saiꞌ pɨx na pim jax ba nɨiꞌñ, ni kut iam puꞌñi joidham tuꞌm jix aꞌbhar tɨm tɨiꞌdhak gu Salomoon guiꞌ na bɨjɨk jir gɇꞌkam kat. Sia ku moo tɨi gux ioꞌm jix aꞌbhar jajannulh xi chɨm tɨtɨiꞌñdhaꞌ, matgɨm gu yooxiꞌ jix ioꞌm ji nax aꞌbhar. ");
INSERT INTO stpNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gu Dios dho mi jaꞌp ja ɨꞌxcha gux aꞌbhar yooxiꞌ. Baꞌ noꞌt ba yoo, jaꞌp ji buusniaꞌ na joidham jix aꞌbhar ba tu ja tɨiꞌdhaꞌ. Tɨir saiꞌ pɨx guꞌ na pim jax ba nɨiꞌñ, dai ji na guꞌ cham muiꞌ juruuxiꞌñ. Jɨꞌk gook tanoolh pɨx juruuñdhaꞌ piam jɨꞌk baik, jumai buimgidhak jix gak mi jaꞌp tuutkaꞌ. ¿Gu baꞌ aapiꞌm cham puꞌñi joidham jix aꞌbhar jup tu jam tɨiꞌdhaꞌ aa guñ Gɨꞌkoraꞌ noꞌ pim bɨɨx jam jujur kɨꞌn tɨ jɨɨgiꞌñ buiñor? ");
INSERT INTO stpNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Guꞌ jaꞌpji na pim cham jax jum aaꞌndaꞌ ji jiñ jaaduñ sia ku cham ka jaiꞌch na pim tuꞌ jugiaꞌ. Chaꞌpim jax kaiꞌchdhaꞌ: “¿Tuꞌch baꞌ jugiaꞌ chi?” Piam ku guꞌ noꞌ cham ka jaiꞌch na pim tuꞌ iꞌyaꞌ, chaꞌpim jax kaiꞌchdhaꞌ: “¿Tuꞌch baꞌ ka iꞌyaꞌ chi?” Piam ku guꞌ na pim tuꞌ tɨꞌyaꞌ noꞌt ma saaskɨ gu jam jajannulh, aapiꞌm sia cham jax jum aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Na guꞌ dɨɨlh jix maat gu Dios na jax dhuuji jam makiaꞌ gu tuꞌ na jam aꞌm jum aaꞌndaꞌ. Na guꞌ noꞌ pim jix buam jum aaꞌ, cham jir am, na guꞌ dhiꞌ guiꞌ nam cham maat guiꞌ na jaroiꞌ tu maak gu tuꞌ nañ aꞌm jum aaꞌndaꞌ nam baꞌ puꞌñi jaꞌk tu jim. Miꞌ cham ka bhaaiꞌn kaꞌ nam jax jum duñiaꞌ noꞌm cham ka biaꞌ gu tuꞌ nam jugiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dai pɨx ji na pim gammɨjɨ miꞌ puiꞌ jiimdaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ na baꞌ jam makiidhaꞌ gu tuꞌ na jam aꞌm jum aagidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Chaꞌpim tuꞌ bhaan jax jum aaꞌndaꞌ, dai gu Dios japim pɨx buiñor jix biiñak kaꞌ gammɨjɨ nabap tanoolh na baꞌ jam aꞌm tɨ nɨidhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Gio baꞌ moo jaꞌpni jaꞌk jañ jup xi jam tɨɨdam jiñ jaaduñ, na pim cham juandaꞌ gu jaroiꞌ sia kut jix buam jum duukam jup tu duu jam bui. Tu uañiꞌñkaꞌ pim pɨx. ");
INSERT INTO stpNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Na guꞌ noꞌ pim cham tu uañiꞌñ gu jaroiꞌ, gu Dios puiꞌ cham jup tu jam uañdhaꞌ. Jaꞌxbuiꞌ puiꞌp jam tɨɨdaꞌ na pim jax tɨɨdaꞌ gu jaroiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aapiꞌm jax jix ñɨiꞌñdhaꞌ gu jax chuꞌm jam jaduuñ noꞌt palhɨɨp buupuiram suulh gu tanaaraꞌ, aapiꞌm dɨɨlh guꞌ pu cham nɨiꞌñdhaꞌ ji na gɇꞌgɇr iam bha bɨtkaꞌ jam buupui am. ");
INSERT INTO stpNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Baꞌ cham jir am na pim jax tɨɨdaꞌ: “Bha jaꞌk jiñ jaduuñ kuñ xim boosgidhaꞌ dhi tanaaraꞌ na bha bɨɨt jum buupui am”, noꞌ pim guꞌ aapiꞌm dɨɨlh pu cham nɨiꞌñ na gɇꞌgɇr iam bha bɨɨt jam buupui am. ");
INSERT INTO stpNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Bɨɨpɨꞌm aaꞌ na pim xi boosgai na pim baꞌx bhaiꞌ nɨiꞌñdhaꞌ na pim jup boosgidhaꞌ gu jax chuꞌm jam jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Cham jir am na pim ja aagiꞌñdhaꞌ gux kɨɨꞌp jum duukam guiꞌ nam jaꞌp ji buan na jax gu goꞌngox nam giilhim jix bhaaꞌmnaꞌ, nam baꞌ cham bhaakui taꞌtak jup jam doodaꞌ, ni guiꞌ nam jaꞌp ji buan na jax gu tatooxkolh ku pim cham jax ja tɨtdadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Gio baꞌ moo jaꞌpniñ jup xi jam tɨɨdam jiñ jaaduñ na pim tu daandaꞌ buiñor guñ Gɨꞌkoraꞌ. Baꞌ gu tuꞌ na pim mu taandaꞌ, jam makiaꞌ dho, gio gu tuꞌ na pim jix maachim kaꞌ, machiaꞌ pim dho, na guꞌ guiꞌ dɨɨlh jam makiaꞌ gu matdaꞌ. Na guꞌ dhiꞌ jaꞌpni ji buusan jia na jax noꞌñ mu paiꞌ kiicham paxiaraim nañ muiꞌ xi chu ñioꞌkdhaꞌ, na guꞌ bañ kupioꞌkdhaꞌ gu kiꞌñgob gu kiokam, miꞌ dhɨr baꞌ dai na bañ chiñiaꞌ nañ mu jaꞌk ba bakiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Baꞌ puꞌñi jaꞌk ji buusan noꞌ pim tuꞌ taan guñ Gɨꞌkoraꞌ soiꞌm ɨlhdhat, jam makiaꞌ dho, na guꞌx chu joiꞌgɨꞌn. Gio gu tuꞌ noꞌ pim jix maachim, machiaꞌ pim dho, na guꞌ guiꞌ dɨɨlh jam makiaꞌ gu matdaꞌ. Na guꞌ dhiꞌ kaiꞌñkam jaꞌp ji buusan jia na jax noꞌñ mu tu ñioꞌkiꞌñ kiꞌñgob, dai na bañ kupioꞌkdhaꞌ gu kiokam, miꞌ dhɨr baꞌ bañ chiñiaꞌ nañ mu jaꞌk ba bakiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Na guꞌ na pim jax bax maat jia na cham jaroiꞌ jaiꞌch gu maaꞌnkam na jodai pɨx mu makiaꞌ gu maraaꞌn noꞌ tuꞌ taan nar jum kuaꞌdam. ");
INSERT INTO stpNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Piam ku guꞌ noꞌ tuꞌ batoop taan, ¿kaꞌ koꞌ aa pɨx muiꞌ ba daagiꞌñkaꞌ? ¿Jia na guꞌ cham jaroiꞌ jaiꞌch na puꞌñi jaꞌk tu bua? Nam guꞌ bɨɨx pɨx jix ja daꞌ gu ja maamar. ");
INSERT INTO stpNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Dho jaña nam jax joidham jix bhaiꞌ tu ja maakdaꞌ gu ja maamar gu jaꞌtkam, sia kum guꞌ cham tuꞌ kaꞌm tɨ nɨiꞌñ. Guꞌ gi baꞌ guñ Gɨꞌkoraꞌ guiꞌ nax dhaam jup tuꞌiiꞌ na joidham jir jix bhaiꞌkam, matgɨm bha jam joochxidhaꞌ ji gux kɨɨꞌp jum duukam noꞌ pim taan. ");
INSERT INTO stpNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Baꞌ puꞌñi jam aꞌm jum aaꞌ na pim jix bhaiꞌ ja buadaꞌ gu jaꞌtkam, sia kum mu dɨr bha jaꞌk cham bhaiꞌ jam bua, na guꞌ puꞌñi jaꞌk tu aagix ja bui gu yaꞌ kam dhi Israel, na mɨt guꞌ puiꞌ jaꞌk tu uaꞌnak guiꞌ nam bɨjɨk bhaankam tu aꞌgimɨk gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Baꞌ noꞌ pim jix aaꞌ jiñ jaaduñ na pim buiñor aayaꞌ gu Dios, jum aaꞌ na pim gu ɨlhiꞌch kiꞌñgob kaꞌm bhaan mu baapkiaꞌ na pim baꞌ aayaꞌ buiñor guiꞌ. Na guꞌ jumaip jix jaiꞌch jia gu kiꞌñgob guiꞌ nax ioꞌm jir gɇꞌ na bhaan mu jaꞌk jup tum bapkɨ na paiꞌ gammɨjɨr tu tulhiiñaraꞌ, gio baꞌ maaꞌn jup jix jaiꞌch ɨp gu komaarak gu boi, na dhiꞌ pɨx jir diꞌ na bhaan mu tɨm bhɨbhɨɨ mu jaꞌk. Baꞌ muiꞌ gu jaꞌtkam dhiꞌ kaꞌm bhaan mu baapkim am gu gɇꞌ kiꞌñgob mu jaꞌk na paiꞌ maiꞌx chɨ gɨɨxiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Baꞌr ɨlhiꞌch gu kiꞌñgob guiꞌ na bhaan mu tum bapkɨ mu jaꞌk na paiꞌ gammɨjɨ cham jir tu tulhiiñaraꞌ, gio gu boi jir ɨrdiꞌch guiꞌ na bhaan mu tɨm bhɨbhɨɨ. Baꞌ cham pɨk jaroiꞌ xim guguuxiꞌñ na dhiꞌ kaꞌm bhɨɨyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Moo pim cham ja kɇkɇɇdaꞌ guiꞌ nam sap pɨk baꞌ bhaankamuꞌn tu aꞌgadaꞌ gu Dios, na ja koꞌraardaꞌ nam jaꞌp xim buadaꞌ nam panaas cham bhaaꞌmnaꞌ jaꞌp na gu kakasnir, guꞌ gu ja jujur am bhaan giilhim ji nam jix buam tomaat jaꞌp na jax gu sɨsɨɨꞌ gux bhaaꞌmnagɨm. ");
INSERT INTO stpNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Na guꞌx maatɨꞌ kaꞌ jia nam jax jaꞌk tu jimdaꞌ na pim xi ja nɨiꞌñdhaꞌ. Na guꞌ na pim jax bax maat na cham jax chuꞌm jaiꞌch gu ɨꞌɨɨx nax maikak tu iꞌbhaiꞌñchar na moo gatuuk jix maimdagɨm jup ba iibhaiꞌñchaꞌ, ni gu jax chuꞌm ɨꞌɨɨx guiꞌ na pux maimdagɨm tu iꞌbhaiꞌñchar ku moo joidham jix maikak jup ba iibhaiꞌñchaꞌ gatuuk. ");
INSERT INTO stpNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Na guꞌ guiꞌ nar jix kɨɨꞌ ɨꞌɨɨx kaꞌ, joidham pux maikak tu iꞌbhaiꞌñchardaꞌ, gio guiꞌ na cham kɨɨꞌ kaꞌ gu ɨꞌɨɨx, pu maaꞌn na jax jix maimdagɨm jup tu iꞌbhaiꞌñchardaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Baꞌ pu maaꞌn na jax jix maikak tu iꞌbhaiꞌñchardaꞌ gux kɨɨꞌ ɨꞌɨɨx, gio guiꞌ na pux maimdagɨm jup tu iꞌbhaiꞌñchar gu ɨꞌɨɨx, pu maaꞌn ɨp na jax chuꞌm tu iꞌbhaiꞌñchardaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Baꞌ gu jax chuꞌm ɨꞌɨɨx noꞌ puꞌñi cham kɨɨꞌ tu iꞌbhaiꞌñchar, jir am nam soiñchɨi mu baas buaji bhaiꞌ xi kɨɨxdhaꞌ gu tai. ");
INSERT INTO stpNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Baꞌ puꞌñi jaꞌk jup ji buan am guiꞌ nam sap pɨk baꞌ bhaankamuꞌn tu aꞌgadaꞌ gu Dios, jix maatɨꞌ kaꞌ nam jax jaꞌk tu jimdaꞌ na pim xi ja nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Baꞌ cham tuꞌ bɨɨx aayaꞌ am buiñor gu Dios guiꞌ nam puiꞌñ chɨtdadaꞌ nañ aañ jir gɇꞌkam, guꞌ jaꞌpji dai ji guiꞌ nam jɨꞌk miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ guiꞌ nax dhaam jup tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Muiꞌ puiꞌñ chɨɨdaꞌ am janoꞌ na paiꞌ dhuuk ba tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn, jup kaiꞌchdhaꞌ am: “Aach jum aꞌmkam tu aꞌgimɨk aapiꞌ Gɇꞌkam jich Gɨꞌkoraꞌ, gio nach jum aꞌmkam maiꞌ ja jootsaimɨk gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gu jaꞌtkam, gio baꞌ nach jum aꞌmkam joidham jix bhaiꞌ xi chu buimɨk nam tuꞌ cham paiꞌ nɨidhat gu jaꞌtkam.” ");
INSERT INTO stpNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Baꞌ aañ yaꞌ dɨr mu jaꞌk jup ja tɨɨdaꞌ: “Chaam ji nañ jam maat. Mu pim baas oipodaꞌ, na pim guꞌ cham tuꞌ kaꞌm tɨ nɨiꞌñ.” ");
INSERT INTO stpNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Baꞌ gu jaroiꞌ noꞌt jiñ kɇɇk miꞌ puiꞌ ba jii gu dhiꞌ puiꞌ nañ jax kaiꞌch, jaꞌp ji buusniaꞌ na jax gu jaroiꞌ noꞌx chu matdaꞌ na miꞌ kɨɨsaꞌ gu baꞌkiꞌñ na paiꞌr aiꞌ chaꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Baꞌ na paiꞌ dhuuk jɨbɨɨlh kɨꞌn bhaiꞌ ji dhuuduyaꞌ gio na muiꞌ ji mɨlhiaꞌ gu suudaiꞌ, pu cham jɨꞌxkat ɨlhiaꞌ gu baꞌaak, na guꞌx bhaiꞌ miꞌ kɨɨkaꞌ bhaan gu aiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Guꞌ baꞌ gu jaroiꞌ noꞌt cham miꞌ puiꞌ jii gu dhiꞌ puiꞌ nañ jax kaiꞌch, dhiꞌ jaꞌp jup ji buusniaꞌ na jax gu jaroiꞌ na cham tu matdaꞌ kaꞌ na miꞌ kɨɨsaꞌ gu baꞌkiꞌñ na paiꞌx chu moik bhaan gu oꞌya. ");
INSERT INTO stpNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Baꞌ na paiꞌ dhuuk jɨbɨɨlh kɨꞌn bhaiꞌ ji dhuuduyaꞌ gio na muiꞌ ji mɨlhiaꞌ gu suudaiꞌ, pu maaꞌn na jax ɨlhiaꞌ gu baꞌaak, na guꞌx chu moik kaꞌ miꞌ na paiꞌ kɨɨkaꞌ bhaan gu oꞌya. ");
INSERT INTO stpNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Baꞌ nat paiꞌ dhuuk tɨɨmo gu Jesuus na puꞌñi xi chu ja aꞌgidhimɨk, bɨɨx miꞌ puiꞌ pup tuꞌiiꞌ am gu jaꞌtkam, na mɨt guꞌx ioꞌm joidham kai. ");
INSERT INTO stpNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Na guꞌ joidham jix bhaiꞌ xi bua na tu aꞌga, cham tuꞌ puiꞌ na jax guiꞌ nam sap pɨk baꞌx maat kaꞌ gu ñioꞌkiꞌñ gu Dios nam puiꞌ tɨip tu ja aꞌgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Baꞌ nat paiꞌ dhuuk ba jii gu Jesuus bhaiꞌ dhɨr oidhaꞌ taꞌm, muiꞌ jaꞌtkam pɨx chɨbɨɨp kattuꞌ am nam oiꞌñchuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Baꞌ maaꞌn miꞌ ba ai buiñor gu Jesuus guiꞌ na tootolhidhat bha gakiidhaꞌ gu tukgaꞌn, baꞌ mi jaꞌp bɨɨpɨꞌ dɨr oꞌlhiaꞌn kɨꞌn xi kɨkbok jup tɨtda: ―Aañ jaꞌp tɨi soiꞌ bham tɨɨdam jiñ jaduuñ noꞌp moo puiꞌp ɨlhiiꞌñdhaꞌ gɨt nap iam jiñ dhuaꞌñdhaꞌ gɨt nañ ɇɇ dhi koꞌkdaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Baꞌ gu Jesuus bhaiꞌ xi dhaagɨk jup tɨtda: ―Ea, jum duaꞌñdhaꞌ iñ dho. Baꞌ miꞌ jotmodaꞌ jix kɨɨꞌp jum duu guiꞌ na tootolhidhat bhaiꞌ ka gakiidhat gu tukgaꞌn. Miꞌ dhɨr baꞌ moop tɨtda ɨp gio gu Jesuus: ―Jaña, bax kɨɨꞌ ap dhoñ jaduuñ. Chaꞌp jax kam aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Baꞌ xi sooꞌmchulhdhak ɨp na sap cham jaroiꞌ aagiꞌñdhaꞌ nat duaꞌñ, jup tɨtda: ―Dai nap moo cham jaroiꞌ aagiꞌñdhaꞌ na ñich aañ jum duaꞌñ. Dai nap sɨlh jimiaꞌ pɨx mu na paiꞌr chiop na paiꞌ daa guiꞌ na ja palhbuiꞌñ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, na baꞌm tɨgiaꞌ nap bax kɨɨꞌ. Xi chɨkkadaꞌ ap. Baꞌ noꞌ jax kaiꞌch nap bax kɨɨꞌ, dho guꞌ dai dho nap tu makgɨrtaꞌ na jax tu aagix nat tu uaꞌnak gu Moisees nam baꞌ bax mat kaꞌ gu jaꞌtkam na pich ba dua na kam ɇɇkat gu koꞌkdaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Baꞌ nat jax mummɨ ai gu Jesuus na paiꞌr Kapernaum, miꞌ ba ai buiñor maaꞌn gu ja gɇꞌkam tuk gu sandaaruiꞌx Rooma kam. Baꞌ soiꞌ ba tɨtda gu Jesuus, ");
INSERT INTO stpNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","jup tɨtda: ―Aañ jaꞌp tɨi soiꞌ bham tɨɨdam jiñ jaduuñ noꞌp moo puiꞌp ɨlhiiꞌñdhaꞌ gɨt nap iam duaꞌñdhaꞌ gɨt guñ chujuandam tuk nax ioꞌm jix kaꞌook. Pu cham bhaaiꞌ na bamgiaꞌ, na guꞌx ioꞌm jix chu koꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Baꞌ gu Jesuus jup tɨtda: ―Ea, mu jimiaꞌ iñ dho nañ dhuaꞌñdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Baꞌ gio muiꞌp ji ñio gu ja gɇꞌkam tuk gu sandaaruiꞌx, jup kaiꞌch: ―Guꞌ pɨx ji nañ guꞌ cham jir jum jupaabkam jiñ jaduuñ nap iam mu bakiaꞌ gɨt jiñ kiꞌaam, nap guꞌ aap jix ioꞌm jir gɇꞌkam. Ku baꞌ guꞌ aañ jix maat ji na dai noꞌ pich puiꞌ ba tɨi sia yaꞌ dɨr, pu dodhiaꞌ guñ chujuandam tuk. ");
INSERT INTO stpNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nañ guꞌ aañ cham gɇꞌkam jiñ chaat, nañ guꞌ bɨtaꞌn jup tuꞌiiꞌ ja bui gu gɇꞌgɇrkam na mɨt yaꞌñ dhai. Guiꞌ pɨx mu jaꞌk jup ja kaichuꞌ iñ. Baꞌ puiꞌp ja biaꞌ iñ jɨꞌkchi gu sandaaruiꞌx nañ puiꞌp tu ja chian, baꞌ xiñ kɇɇ am. Noꞌñ jaroiꞌ maadɨt mu paiꞌ jootos, mu jimiaꞌ cham jax ji chɨꞌji. Piam noꞌñ mu paiꞌ dhɨr baiꞌñ, mu jimiaꞌ ɨp. Bɨɨx guñ chujuandam tuk miꞌ puiꞌ duñiidhaꞌ am nañ tuꞌ ja chiandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Baꞌ miꞌ puiꞌ pup tuꞌiiꞌ gu Jesuus nat puꞌñi kai gu ja gɇꞌkam tuk gu sandaaruiꞌx. Miꞌ dhɨr baꞌ moop ja tɨtda gu jaꞌtkam guiꞌ nam oiꞌñchuꞌ: ―Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨtdañ jaaduñ na cham jaroiꞌ jaiꞌch gu Israel kam na jaꞌxbuiꞌ puiꞌ bɨɨx juraaꞌn kɨꞌn jix biiñak buiñor gu Dios na jax dhiñ jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Baꞌ aañ pu kaiꞌch nam muiꞌ ka jaiꞌchdhɨlhiaꞌ mu jaꞌk na paiꞌ dhɨr jir xiaꞌlhbui guiꞌ nam puꞌñix biiñak kaꞌ buiñor gu Dios, gio baꞌ jaiꞌ mu dɨr jaꞌk jurnip. Baꞌ gatuuk na paiꞌ dhuuk ba tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn, maap ba daraibuꞌ am gu Abraam, gio baꞌ gu Isaak, gio baꞌ gu Jakob, nam ba tu jugiaꞌ gu koiꞌ jix dhaam jaꞌk na tu ja makiaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Guꞌ baꞌ gu Israel kam jaꞌtkam nam tɨi aagix nam buiñor aayaꞌ gɨt gu Dios, mu jaꞌp pɨx ji biꞌyaꞌ am dɨɨrap dɨr na paiꞌ giilhim jix chu tukgam, baꞌ tɨi bhaiꞌ ji susuañiaꞌ am nam giilhim jix buam jum aaꞌndaꞌ na mɨt cham miꞌ puiꞌ jii na jax jix aaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Miꞌ dhɨr baꞌ moop tɨtda gu ja gɇꞌkam tuk gu sandaaruiꞌx: ―Ea ku gi na moo puiꞌ tu tuiꞌkaꞌ nap jax kaiꞌch jiñ jaduuñ. Ba jimiaꞌ ap jum kiꞌaam jaꞌk cham jax jim aagɨt. Baꞌ moo janoꞌ pu dua gu tujuandam tugiꞌñ, jix kɨɨꞌp jum duu. ");
INSERT INTO stpNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Baꞌ gatuuk ma paxiaram gu Jesuus mu jaꞌp na paiꞌ kiokaꞌ gu Peegro. Baꞌ miꞌ pɨx ji chɨɨ gu daadaꞌn nam bakxidhat mi jaꞌp boꞌ na ɇɇ gu toiñdhiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Baꞌ amuub xi ɇɇk miꞌ xi dhaa nobiꞌran. Baꞌ jotmodaꞌ jix bhaiꞌ ji chu tatdat, jix kɨɨꞌ dho guꞌp jum duu na ka ɇɇkat gu toiñdhiꞌ. Miꞌ dhɨr dho guꞌ dai nat bamgɨk ba tu ja onbaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Baꞌ jaꞌxpɨx nat ba ji chuk, jix ioꞌm muiꞌ miꞌ ba aichulh jamɨt gu Jesuus gu jaꞌtkam guiꞌ nam ampɨx puiꞌx ñanaanbiꞌ kaꞌ na puiꞌ jaꞌk ja duukaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ na ja aꞌm jup tuiꞌkaꞌ, gio baꞌ jaiꞌ guiꞌ nam jaꞌppɨx jix kakoꞌk kaꞌ. Baꞌ gu Jesuus pɨx jaꞌx jup ji ja duduaꞌñ, pu bɨɨx jix kɨkɨɨꞌp jum duu mɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Baꞌ dhiꞌ puꞌñi jaꞌk jum kuugalh gu puiꞌ nat jax jaꞌk tu uaꞌnak gu Isaiiyas guiꞌ na bɨjɨk bhaankamuꞌn tu aꞌgimɨk gu Dios na bhaan tu aꞌga guch Xoiꞌkam na jaꞌpnim kaiꞌch: “Pu bɨɨx bhaan ji chu bii gu koꞌkdaiꞌ na kach ɇɇkat.” ");
INSERT INTO stpNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Baꞌ na mi jaꞌp naiꞌ xi ja nɨiꞌñ gu Jesuus nam jix ioꞌm muiꞌ miꞌ baꞌp tuꞌiiꞌ gu jaꞌtkam, nam guꞌ pɨx miꞌ ji aajim, ba ja baidhim guiꞌ nam kaichuꞌ nam sap baasɨꞌn dɨr jaꞌk bhɨɨyaꞌ gu jumai juꞌñdharan gu gɇꞌ suudaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Baꞌ jotmodaꞌ maaꞌn miꞌ ba ai guiꞌ na sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, baꞌp tɨtda: ―Aañ jaꞌp ɨlhiiꞌñ jiñ jaduuñ nañ aañ bɨɨx jup bam kaichgɨdaꞌ paiꞌ nap jaꞌk oilhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Baꞌ gu Jesuus jup tɨtda: ―Jax dhui na guꞌ aañ nat bhañ joot guñ Gɨꞌkoraꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, pu cham paiꞌ bhaaiꞌ nañ gɨt joidham xiñ jɨɨpiꞌñkaꞌ, cham puiꞌ na jax gu kaxio, na guꞌ sɨlh jimiaꞌ mu paiꞌ nar chiob kaꞌ noꞌ bax kooxim. Gio gu uꞌiiꞌ na guꞌ puiꞌp tu kos kaꞌ, dai na ba koxiaꞌ na paiꞌ dhuuk ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Baꞌ maaꞌn miꞌ dhɨr jaꞌp muiꞌp ji ñio guiꞌ nam kaichuꞌ, jup kaiꞌch: ―Aañ dho puiꞌp ɨlhiiꞌñ jiñ jaduuñ nañ gammɨjɨ bam kaichgɨdaꞌ. Dai nap ka xiñ ñɨɨraꞌ nañ ka xi yaaspai guñ chaat noꞌt ba muu. ");
INSERT INTO stpNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Baꞌ gu Jesuus jup tɨtda: ―Aap moo cham tuꞌ bhaan jim tukgidhat xiñ kaichgɨdaꞌ. Matgɨm gu jaꞌtkam gammɨjɨ koꞌiidhat jum yaaspaidhaꞌ am ji. ");
INSERT INTO stpNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Baꞌ gatuuk na miꞌ puiꞌ jɨꞌ xi chu ja aꞌgidhimɨk gu Jesuus gu jaꞌtkam pu jii, dai nat jax bha tɨs bhaan gu gɇꞌ kanuub, baꞌ bɨɨx jup oiꞌñchuꞌ am gu noonbiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Baꞌ nammɨ gama jaꞌk ɨrban gu gɇꞌ suudaiꞌ nam ba jiim, ba koi gu Jesuus. Baꞌ jotmodaꞌ pɨx jix ioꞌm bhaiꞌ jɨb, bhaiꞌ ji guꞌngukɨ gu suudaiꞌ, pɨx bhaiꞌ ba jim tuꞌaim kanuub taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Baꞌ gu noonbiꞌñ mu jimɨɨk ba ñiññichuꞌn am gu Jesuus, jup tɨtda am: ―¡Xi ñiñia jich jaduuñ! ¡Yaꞌ chich ba ji bhaꞌiik! ¡Iam xich palhbuiꞌñ nach baꞌ cham bhaiꞌkoꞌ! ");
INSERT INTO stpNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Baꞌ ñiñiak jup ja tɨtda gu Jesuus: ―¿Kux moo jaꞌp chakui bɨɨx jam jujur kɨꞌn jix biiñak japim aa aañ jiñ bui ku pim baꞌ moo jaꞌp jup bax chotdontuꞌ? Baꞌ puiꞌ xi chɨꞌɨɨk bamgɨk xi ñiok gu jɨbɨɨlh gio gu suudaiꞌ. Baꞌ miꞌ jotmodaꞌ naiꞌ ampɨx ji chu juu, pu cham paiꞌ ka jɨbɨɨr, ni gu suudaiꞌ ku ka guꞌnguk. ");
INSERT INTO stpNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Baꞌ gu noonbiꞌñ miꞌ puiꞌ pup tuiꞌdhiꞌ am, dai nam jup jum tɨ tɨtdaim jix dhuꞌnpiꞌñ kɨꞌn: ―¡Jaꞌp moor gɇꞌkam ji bak jia dhich jaduuñ na baꞌ gam jɨbɨɨlh gio suudaiꞌ jix jɨɨgiꞌñ! ");
INSERT INTO stpNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Baꞌ puiꞌ jim buidhat bhammɨ dɨr ba ai mɨt jumai juꞌñdharan gu gɇꞌ suudaiꞌ guiꞌ na Gadaara dɨbɨɨr bhaan bipioꞌ. Baꞌ bhaiꞌ dhɨr jaꞌp muiꞌ ba boopoꞌ am gook gu jaꞌtkam nam jix ñanaanbiꞌchuꞌ, nam puiꞌ jaꞌk ja duukaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ na ja aꞌm jup tuiꞌñgɨdaꞌ, baꞌ mi jaꞌp ji guguu mɨt na paiꞌp tuꞌiiꞌ gu Jesuus. Mu dɨr jaꞌk xi boopoꞌ am nam paiꞌm yassapdaꞌ gu koiꞌñgaꞌn, nam guꞌ miꞌx joiꞌñdhaꞌ nam oipodaꞌ, gio puiꞌx dhaꞌnpakat ɨp. Baꞌ cham jaroiꞌ mi jaꞌp bhɨbhɨɨdaꞌ nam guꞌx ja ɨɨbhiꞌñdhaꞌ, nam guꞌ giilhim jix bhaaꞌmnaꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Baꞌ gɇꞌ kɨꞌn jiiñkɨt jup tɨtda am gu Jesuus: ―¡Aapiꞌ Jesuus nap jir Maraaꞌn gu Dios, chakuip jich chulhiiñchuꞌndaꞌ, nat guꞌ chakuim ai janoꞌ nap paiꞌ dhuuk jich chulhiiñchudaꞌ! ");
INSERT INTO stpNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Baꞌ muiꞌ gu tatooxkolh amuub bha jaꞌp jup tum bipiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Baꞌ soiꞌ ba tɨtda am gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ gu Jesuus na sap bhammɨ jaꞌk ka xi ja jootsaꞌ nam ja aꞌm ka xi baapkiaꞌ gu tatooxkolh, nam baꞌ cham jimiaꞌ mu jaꞌk nam paiꞌ giilhim jum tulhiiñaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Baꞌ gu Jesuus bhammɨ jaꞌk jup xi ja joot. Baꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ jotmodaꞌ bhaiꞌ dhɨr bubuakɨk bhammɨ jaꞌk pu baap jamɨt. Baꞌ gu tatooxkolh bhaiꞌ dhɨr ji boop jamɨt naiꞌ gu aꞌnsap, pu mɨjɨmmɨ ji baap jamɨt suudaiꞌ chɨr, pu koi mɨt dho guꞌ bhaiꞌkuk. ");
INSERT INTO stpNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Baꞌ guiꞌ nam bhaiꞌ ka tu bipiaꞌdat gu tatooxkolh, totdonɨk pu jiboiꞌññor jamɨt mu jaꞌk na paiꞌ muiꞌ daaꞌñxim jir kikcham kaꞌ, baꞌ ba ja aagiꞌñ am gu jaꞌtkam na mɨt jax jum duu gu tatooxkolh gio gu gook gu jaꞌtkam na mɨt dudua nam kax ñanaanbiꞌ kat na ja aꞌm jup tuiꞌñgɨt gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Baꞌ bɨɨx gu jaꞌtkam nam jɨꞌk miꞌ maap oiꞌñkaꞌ, muiꞌ ma jii mɨt na mɨt mu tɨɨgim gu Jesuus. Baꞌ mu ji ɇɇk soiꞌ ba tɨtda am na sap ba jimiaꞌ miꞌ dhɨr, nam guꞌx ɨɨbhidhat nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Baꞌ gu Jesuus pu jii ɨp nat jax bha tɨs bhaan gu gɇꞌ kanuub guiꞌ na pu bhaan jim na mi jaꞌp sɇꞌ amuub suudaiꞌ jugiiꞌñ, baꞌ sɨlh pu bhɨi bhammɨ dɨr jaꞌk na paiꞌ kiokaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Baꞌ cham jɨꞌx mɨɨkim na mɨt maaꞌn miꞌ ba aichulh gux maꞌmkulhiꞌ bhaan gu bakxidharaꞌ. Baꞌ gu Jesuus nat ba ja tɨɨ nam buiñor jix biiñaktuꞌ guiꞌ nam mu uaꞌ, jup tɨtda gux koꞌkkam: ―Chaꞌp jax kam aaꞌndaꞌ jiñ jaduuñ. Ba uañchudhix ji matgɨm gum uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Baꞌ jɨꞌkchi miꞌp tuꞌiiꞌ am ɨp guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, baꞌp jum aaꞌ am ja jujur am bhaan: “¿Jax baꞌ ɨlhdhat jup kaiꞌch? ¿Jaꞌxbuiꞌ aa sap tɨi gɇꞌkam jup xim ɨlhiiꞌñ na jax gu Dios?” ");
INSERT INTO stpNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Guꞌ ji na guꞌ gu Jesuus jix bhaiꞌx maat nam jax jum aaꞌ gu ja jujur am bhaan, baꞌp ja tɨtda: ―Ni jɨꞌx iam kur puiꞌ na pim jax jum aaꞌ gu jam jujur am bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Na guꞌ cham pɨk xijai jia noꞌñ jax kaiꞌch: “Ba uañchudhix ji matgɨm gum uaꞌtulhdharaꞌ”, na guꞌ cham maatɨꞌ kaꞌ noꞌ moo puiꞌ ji chu buusniaꞌ kaꞌ baꞌ guꞌ cham. Guꞌ ji noꞌñ jax kaiꞌch: “Xi bamiiꞌ, munip jaꞌp ba oirɨdaꞌ”, dho gi guꞌx xijai ji, na guꞌx maatɨꞌ kaꞌ noꞌt cham puiꞌ ji chu buus. ");
INSERT INTO stpNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ku baꞌ guꞌ aañ xib yaꞌ duaꞌñdhaꞌ ji dhiñ jaduuñ nax maꞌmkulhiꞌ na pim baꞌx mat kaꞌ nañ aañ jir gɇꞌkam nat bhañ joot gu Dios jix dhaam dɨr nañ baꞌ yaꞌ uañchudaꞌ gu ja uaꞌtulhdharaꞌ gu jaꞌtkam. Baꞌ puiꞌ xi chɨꞌɨɨk jup tɨtda gux maꞌmkulhiꞌ: ―Xi bamiiꞌñ jaduuñ. Ba jimiaꞌ ap jum kiꞌaam jaꞌk bhɨɨji ap dhim bakxidharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Baꞌx kɨɨꞌ bhaiꞌ ji bam guiꞌ na kax maꞌmkulhiꞌ kat nat jax pu tɨɨꞌn gu Jesuus. Miꞌ dhɨr baꞌ dai nat ba jii xi bhɨɨk gu bakxidharuꞌn, miꞌ ba buus ja saagiꞌñ gu jaꞌtkam, gaammɨjɨ ji dhuu. ");
INSERT INTO stpNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Baꞌ bɨɨx miꞌ puiꞌ pup tuꞌiiꞌ am gu jaꞌtkam na mɨt puiꞌ jɨꞌ tɨ tɨɨ, na mɨt guꞌ bax chootoꞌn. Miꞌ dhɨr baꞌ dai na mɨt ma tu daanɨ buiñor gu Dios, nam guꞌ cham jɨꞌxkat jaroiꞌ puiꞌ nɨidhat na tu duduadhiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Baꞌ jaꞌxpɨx nat miꞌ dhɨr buusnɨk ba jii gu Jesuus, na mu jaꞌp ka jim, miꞌ ba tɨɨ maaꞌn gu maaꞌnkam, Mateo tɨɨgim, guiꞌ nar tuumiñ tutaandam tugiꞌñ kaꞌ gux ioꞌm gɇꞌkam Rooma kam, na miꞌ daakat pɨx ji dhaagim gu tuumiñ guiꞌ nam jɨꞌk mi chu namkidhim. Baꞌ gu Jesuus miaꞌn xi ɇɇk jup tɨtda: ―Aañ puiꞌ ɨlhiiꞌñ jiñ jaduuñ nap xib dɨr gammɨjɨ bañ kaichgɨdaꞌ. Baꞌ gu Mateo nat jax jup kɨkbo pɨx miꞌp daibu cham jax ji chɨꞌɨɨk, gammɨjɨ pɨx jiim am. ");
INSERT INTO stpNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Baꞌ mɨkkat mu jaꞌk daakat jup ba tu kuaꞌ gu Jesuus na paiꞌ kio gu Mateo ja bɨɨm gu noonbiꞌñ, gio baꞌ muiꞌ guiꞌ nam jir tuumiñ tutaandam tugiꞌñ kaꞌ gux ioꞌm gɇꞌkam Rooma kam, gio baꞌ jaiꞌ guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñdhaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Baꞌ guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, am jix bhaak am na mɨt puiꞌ jɨꞌ tɨɨ gu Jesuus, baꞌp ja tɨtda am gu noonbiꞌñ: ―¿Jax ku baꞌ ja bɨɨm tu kuaꞌ dhi jam gɇꞌkam tuk dhiꞌ nam jir tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam, gio dhi jaiꞌ jaꞌtkam nam cham tuꞌ kaꞌm tɨ nɨiꞌñ? Giilhim nam jix uꞌuaꞌtulhdhix. ");
INSERT INTO stpNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Baꞌp ja tɨtda gu Jesuus, na guꞌ ja kɇɇ nam jax kaiꞌch: ―Dho na guꞌ dhiꞌ jaꞌpni ji buusan jia na jax gu jaꞌtkam noꞌm jix kɨkɨɨꞌ, na guꞌ cham tuꞌ ja aꞌm jum aaꞌndaꞌ na jaroiꞌ ja duduaꞌñdhaꞌ, guꞌ guiꞌ ji nam jix kakoꞌk kaꞌ na baꞌ ja aꞌm jum aaꞌndaꞌ na jaroiꞌ ja duduaꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pu kagɨt na pim moo mu paiꞌ jimɨi xi chu jiñkuidhaꞌ miꞌ na paiꞌ tu uaꞌñix, miꞌ dhɨr japim baꞌ xim gaꞌngadaꞌ na jax kaiꞌñkam puiꞌm kaiꞌch miꞌ na paiꞌ jaꞌpni tu uaꞌñix: “Guꞌ aañ nañ jix aaꞌ ji na pim jix chu joiꞌgɨꞌndaꞌ, cham tuꞌ na dai na pim tuñ makgɨrxiꞌñdhaꞌ gu sasoiꞌ.” Baꞌ aañ na ñich bha jii yaꞌ dhi oiꞌñgaꞌn bhaan, cham tuꞌ pu kaiꞌñkam bha jii ñich nañ baꞌ ja baidhikaꞌ guiꞌ nam puiꞌm aaꞌ nam tuꞌ kaꞌm tɨ nɨiꞌñ, guꞌ guiꞌ ji nam jix uꞌuaꞌtulhdhix na ñich bha ja baidham. ");
INSERT INTO stpNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Baꞌ miꞌ ba ai mɨt guiꞌ nam kaichgɨdaꞌ gu Juan jaꞌtkam bopkondam, baꞌ bhaiꞌ ba tɨkka am gu Jesuus na sap jax kum baꞌ cham jum saabdaꞌ gu jaꞌtkam tugiꞌñ, jup tɨtda am: ―¿Jax kum baꞌ cham jum saabdaꞌ dhim jaꞌtkam tuk? Nach baꞌ aach gammɨjɨch xaabdaꞌ, gio gu pariseos ba puiꞌ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Baꞌp ja tɨtda gu Jesuus: ―Dho na guꞌ dhiꞌ jaꞌpni ji buusan jia na jax gu jaroiꞌ noꞌ mu paiꞌ ba xim tɨɨmom, nam guꞌ cham jɨꞌx jum saabum jum ɨlhiiꞌñdhaꞌ gu jaꞌtkam miꞌ jotmodaꞌ, nam guꞌx chu nak kaꞌ gu koiꞌ. Miꞌ dhɨr baꞌ noꞌt ba jii guiꞌ na miꞌ xim tɨɨmui nam dho gi baꞌ xim saabum bam ɨlhiiꞌñdhaꞌ ji gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Cham jaroiꞌ jaiꞌch gu maaꞌnkam na alhiꞌch ɨɨkɨi gu xibkam jannulh bhaiꞌ jaꞌk daaxdhaꞌ bhaan gu kɨlhiiꞌñgaꞌn, na guꞌ maaꞌn na jax sarniaꞌ bɨɨx xikoolh dhɨr na paiꞌ dhuuk bhaiꞌ ji soꞌlhkaꞌ gu xibkam jannulh, miꞌ dhɨr dho gi baꞌ guꞌx ioꞌm bam duñiaꞌ ji, cham puiꞌ kiaꞌ na jax bɨɨpɨꞌ dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni gu biiñ gux oꞌjoꞌ ku cham mim tuaꞌba bhaan gu kɨklhiꞌñgaꞌn jajoꞌ bopko, na guꞌ pu xi xipñiaꞌ noꞌt jax dhuukat mim tua gux oꞌjoꞌ, bar tuꞌ kub kaꞌ baꞌ gu biiñ na bam nuꞌaaꞌ, gio gu jajoꞌ bopko ba puiꞌ ɨp na guꞌ ba saaskiaꞌ, pu cham tuꞌ ka bhaiꞌn kaꞌ. Puiꞌ ku baꞌm aaꞌ na xixiibkam jajoꞌ bopko bhaan jum tuꞌaidhaꞌ gu biiñ gux oꞌjoꞌ na baꞌ cham jax jum duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Baꞌ na miꞌ ka tu ja aꞌgiꞌñ gu Jesuus gu jaꞌtkam, miꞌ ba ai maadɨt guiꞌ nam jir ja gɇꞌgɇrkam tuk kaꞌ gu Israel kam jaꞌtkam. Baꞌ mi jaꞌp oꞌlhiaꞌn kɨꞌn ji kɨkbok soiꞌ ba tɨtda gu Jesuus, jup kaiꞌch: ―Aañ jaꞌp tɨi soiꞌ bham tɨɨdam jiñ jaduuñ noꞌp moo puiꞌp ɨlhiiꞌñdhaꞌ gɨt nap mu jimiaꞌ gɨt jiñ kiꞌaam nap duaꞌñdharaꞌ guñ maraax nat ma muu xib kiaꞌpɨx. ");
INSERT INTO stpNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Baꞌ gu Jesuus nat jax kɨkbo cham jax ji chɨꞌɨɨk pɨx miꞌp daibu ja bɨɨm gu noonbiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Baꞌ maaꞌn gatuuk dɨr muiꞌp ja oiꞌñchuꞌ gu ubii na mambhɨɨx daman gook oidhaꞌ bax kaꞌook kaꞌ na ampɨx mɨrdaꞌ gu ɨꞌraꞌn. Baꞌ gatuuk dɨr miaꞌn xi ɇɇk bhaiꞌ xi dhaa juꞌñdharan gu jannulhiꞌñ gu Jesuus guiꞌ na daam dɨr tɨiꞌchuꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","na guꞌ jaꞌp jum aaꞌ: “Dai noꞌñ ba dagiaꞌ gɨt pɨx sia juꞌñdharan gu jannulhiꞌñ guiꞌ na daam dɨr tɨiꞌchuꞌ, pu dodhiaꞌ iñ.” ");
INSERT INTO stpNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Baꞌ gu Jesuus jaꞌk xi gɨɨsɨk jup tɨtda gu ubii: ―Chaꞌp jax kam aaꞌndaꞌñ jaduuñ. Pu ba dua pich ji matgɨm, nap guꞌ aañ jiñ bui bax biiñak. Baꞌ miꞌ jotmodaꞌ joidham jix bhaiꞌ bhaiꞌ ji chu tatdat gu ubii nat jax pu tɨɨꞌn gu Jesuus, jix kɨɨꞌ dhop jum duu na ka mɨrdat gu ɨꞌraꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Baꞌ nat paiꞌ dhuuk mu ba ai gu Jesuus mu na paiꞌ kio gu Jairo, jix ioꞌm tum suan, gio gu sasabdam nam miꞌp tuꞌiiꞌ nam bax yaaspapuk gu alhii tɨɨyax na miꞌ muukix. ");
INSERT INTO stpNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Baꞌ gu Jesuus jup ja tɨtda: ―Ea na pim alhio ka xi bubuakiaꞌñ jaaduñ, na guꞌ cham tuꞌ muukix jia dhi alhii tɨɨyax, guꞌ miꞌ pɨx ji na koos. Baꞌ guiꞌ dai na mɨt xi aꞌsɨk. ");
INSERT INTO stpNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Baꞌ bɨɨx xi ja bubuaxdhak gu Jesuus, dɨɨlh baꞌ mɨjɨ ji baa na paiꞌ kaat gu alhii tɨɨyax. Baꞌ miꞌ pɨx xi dhaa nobiꞌran, pu joidham jix kɨɨꞌ bhaiꞌ ji bam. ");
INSERT INTO stpNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Baꞌ bɨɨx kap naiꞌ puiꞌ ba tɨm tɨi na jɨꞌx bhaan bipioꞌ guiꞌ gu dɨbɨɨr gu dhiꞌ puiꞌ nat jax tum duu. ");
INSERT INTO stpNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Baꞌ nat jax kiaꞌpɨx miꞌ dhɨr gamaiꞌ ji buus gu Jesuus, gook gu jaꞌtkam cham ñiññia kam gatuuk dɨr muiꞌ ba jiñkuidhim am, jup tɨtdaim am: ―¡Aapiꞌch jaduuñ nap jir boxiiꞌñ gu Dabii, iam jap xich joiꞌmdai xich chɨɨgɨi xich dhuduaꞌñdhai nach cham ñiññia! ");
INSERT INTO stpNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Baꞌ nammɨ gama jaꞌk nat mɨjɨ ba baa jumai baꞌk chɨr gu Jesuus, muiꞌ ji ai mɨt miaꞌn guiꞌ nam cham ñiññia kaꞌ, baꞌ bhaiꞌ ba ja tɨkka gu Jesuus noꞌm sap moo tɨ jɨɨgiꞌñ nax bhaaiꞌ na ja duduaꞌñdhaꞌ nam cham ñiññia. Baꞌ guiꞌp tɨtda am nam sap tɨ jɨɨgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Baꞌ gu Jesuus bhaiꞌ xi ja daagɨk ja buupui am jup ja tɨtda: ―Ea ku gi na moo puiꞌ tu tuiꞌkaꞌ na pim jax kaiꞌch jiñ jaaduñ, na pim guꞌ aañ jiñ bui bax biiñak. ");
INSERT INTO stpNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Baꞌ miꞌ jotmodaꞌ bhaiꞌ ji ñiññiata mɨt nat jax pu ja tɨɨꞌn gu Jesuus, jix kɨkɨɨꞌ dho guꞌp jum duu mɨt. Baꞌ xi ja sooꞌmchulhdhak nam sap cham jaroiꞌ aagiꞌñdhaꞌ nat ja duduaꞌñ, jup ja tɨtda: ―Dai na pim moo cham jaroiꞌ aagiꞌñdhaꞌ na ñich jam duduaꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Guꞌ ji na guꞌ moo janoꞌ na mɨt jax miꞌ dhɨr bubua, mi jaꞌp pɨx jaꞌx puiꞌ tu ja aꞌgiꞌñ am gu jaꞌtkam. Bɨɨx puiꞌ bax chu maat am nam jɨꞌk mi jaꞌp oiꞌdhaꞌ bhaan guiꞌ gu dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Baꞌ moo janoꞌ na mɨt jax kiaꞌpɨx miꞌ dhɨr gamaiꞌ ji bubua guiꞌ nam cham ñiññia kat, jɨꞌkchi gu jaꞌtkam miꞌ ba aichulh jamɨt gu Jesuus maaꞌn gu maaꞌnkam na cham tu ñiokdaꞌ, na puiꞌ jaꞌk duukaꞌ maaꞌn gu cham kɨɨꞌ iiꞌmdaꞌ na bhaan jup tuiꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Baꞌ gu Jesuus pu maiꞌ joot gu cham kɨɨꞌ iiꞌmdaꞌ bhaiꞌ dhɨr bhaan gu maaꞌnkam. Baꞌ jotmodaꞌ bhaiꞌ ji chu ñiokcha, jix kɨɨꞌ dho guꞌp jum duu. Baꞌ miꞌ puiꞌ pup tuꞌiiꞌ am gu jaꞌtkam na mɨt puiꞌ jɨꞌ tɨ tɨɨ, dai nam jup jum tɨ tɨtda: ―Mooch pɨk jaꞌp cham jɨꞌxkat puiꞌ tɨ nɨidhat ji yaꞌ dhi Israel nach jax tɨ nɨiꞌñ xib. ");
INSERT INTO stpNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Guꞌ baꞌ guiꞌ nam pariseos jup jum tɨɨtɨꞌndaꞌ jup kaiꞌch am ɨp: ―Ja gɇꞌkam tuk dho gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ na bhaan jup tuiꞌdhiꞌ dhi maaꞌnkam, puiꞌ ku baꞌx bhaaiꞌ na maiꞌ ja jootos gu bɨpnagaꞌn tuutuꞌm cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Baꞌ bɨɨx kap ai gu Jesuus mu jaꞌp na paiꞌ jax ɨꞌlhich daaꞌñxim jir kikcham kaꞌ, gio baꞌ mu jaꞌp na paiꞌ jax jɨꞌdɨlh jup jir kikcham kaꞌ, tu ja aꞌgidhidhaꞌ gu Israel kam jaꞌtkam mu jaꞌp nam paiꞌ jax tu daandaꞌ, na ja aaꞌñdhidhaꞌ nam jax jaꞌk miꞌ puiꞌ jimiaꞌ na baꞌ ja aꞌm ba tɨ nɨidhidhaꞌ gu Dios, gio baꞌ na xi ja duduaꞌñdhidhat gux kakoꞌkkam na bɨɨx aixim tuꞌm ja ɇɇkaꞌ gu koꞌkdaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Baꞌx joiꞌmdat ja nɨidhidhaꞌ gu Jesuus gu jaꞌtkam mu jaꞌp na paiꞌ jax aꞌjidhaꞌ, na guꞌ sap cham bhaaiꞌn kaꞌ nam jax xim buadaꞌ, gio na cham jaroiꞌ jaiꞌch na ja guguuxdhaꞌ. Jaꞌp ji buusan am na jax gu kakasnir noꞌ cham jaroiꞌ ja bipiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Baꞌ puiꞌ xim aagɨt jup ja tɨtda guiꞌ nam kaichuꞌ: ―Umri moo gɇꞌr gaa tɨr ya jaꞌp, guꞌ baꞌ gu ordam jir gook alh am. Nam guꞌr muiꞌ guiꞌ nam tɨix kaim gu ñioꞌkiꞌñ gu Dios, guꞌ baꞌ guiꞌ nam tu aꞌga, jir gook alh am. ");
INSERT INTO stpNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Baꞌ jam aꞌm jum aaꞌ na pim pu tɨɨdaꞌ gu Dios guiꞌ na jaꞌp ji buusan na yaꞌ tu gaa, na jaiꞌ bhaiꞌp ja jootsaꞌ guiꞌ nam ya jaꞌp tu ja aꞌgidhaꞌ gu jaꞌtkam gux bhaiꞌm kaiꞌchdham ñioꞌkiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Baꞌ ba ja bai gu Jesuus gu mambhɨɨx daman gook gu noonbiꞌñ, baꞌ puiꞌ ba ja tɨtda na sap bax bhaaiꞌ nam puiꞌ maiꞌp ba ja jootosdaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gu jaꞌtkam guiꞌ nam ampɨx puiꞌx ñanaanbiꞌ kaꞌ, gio sap baꞌ bax bhaaiꞌn kaꞌ ɨp nam puiꞌp ba ja duduadhiꞌñdhaꞌ gux kakoꞌkkam guiꞌ na bɨɨx aixim tuꞌm ja ɇɇkaꞌ gu koꞌkdaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Baꞌ dhiꞌ nam jir jaroiꞌ dhaꞌ gu noonbiꞌñ gu Jesuus: Moo gu Simoon guiꞌ nam Peegro kɨꞌn jup jix mat kaꞌ, gio baꞌ gu jaꞌnniꞌñ Anrees. Gio baꞌ moo gu Jakoobo ɨp, gio baꞌ gu jaꞌnniꞌñ Juan, guiꞌ nam jir maamraꞌn gu Sebedeo. ");
INSERT INTO stpNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Gio baꞌ moo gu Piliip ɨp, gio baꞌ gu Bartolomee, gio baꞌ moo gu Tomaas ɨp. Gio baꞌ gu Mateo guiꞌ na bɨɨpɨꞌ dɨr jir tuumiñ tutaandam tugiꞌñ kat gux ioꞌm gɇꞌkam Rooma kam. Gio baꞌ moo gu jumai na puiꞌp tɨɨꞌ Jakoobo guiꞌ na Alpeo jir maraaꞌn, gio baꞌ moo gu Tadeo ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Gio baꞌ moo gu jumai na puiꞌp tɨɨꞌ Simoon guiꞌ na bɨɨpɨꞌ dɨr ka ja kaichgɨdaꞌ guiꞌ nam Kananiistas jum tɨɨtɨꞌndaꞌ. Gio baꞌ moo gu Juudas Iskarioti ɨp guiꞌ na gatuuk ja aaꞌñdharaꞌ gu gɇꞌgɇrkam jum aaꞌndam na paiꞌ oirɨdaꞌ gu Jesuus nam baꞌ daagɨi tu chiñiaꞌ nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Baꞌ mu jaꞌp naiꞌ ba ja jootos gu Jesuus gu mambhɨɨx daman gook gu noonbiꞌñ nam sap tu ja aꞌgiꞌñpuꞌ gu jaꞌtkam gu ñioꞌkiꞌñ gu Dios, jup ja tɨtda: ―Chakui pim mu jaꞌk jimmɨdaꞌ ja bui guiꞌ nam cham jir Israel kam jaꞌtkam, ni mu jaꞌk ja bui guiꞌ nam jir Samaaria kam. ");
INSERT INTO stpNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Naiꞌ jaꞌp ji na pim jimiaꞌ ja bui guiꞌ nam jir Israel kam jaꞌtkam, guiꞌ nam jaꞌp ji buan na jax gu kakasnir nam maiꞌ suulhgix. ");
INSERT INTO stpNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xi ja aagiꞌñdhaꞌ pim nat bam ai nam paiꞌ dhuuk machiaꞌ nam jax jaꞌk miꞌ puiꞌ jimiaꞌ na baꞌ ja aꞌm ba tɨ nɨidhidhaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gio baꞌ na pim xi ja duduaꞌñdhidhat ɨp gux kakoꞌkkam puiꞌ na jax guiꞌ na tootolhidhat bha gakiidhaꞌ gu ja tutkuꞌ. Gio guiꞌ nam ba koꞌiix kaꞌ pim sia xi ja duduaꞌñdhidhat. Gio baꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ na pim maiꞌ ja jootsaidhaꞌ ja aꞌm dɨr gu jaꞌtkam guiꞌ nam ampɨx puiꞌx ñanaanbiꞌ kaꞌ. Baꞌ na pim paiꞌ dhuuk puꞌñi xi ja duduaꞌñdhidhat, chaꞌpim bha ja taandaꞌ gu tuumiñ, na guꞌ dhiꞌ na pim tuꞌ kɨꞌn ja duduaꞌñdhaꞌ, dhiꞌ puiꞌ pɨx jam maa jia gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Baꞌ cham jum aaꞌ na pim uaꞌkaꞌ gu tuumiñ gux uam totbikdam, ni gux chooto totbikdam, piam guiꞌ nax chɨɨdoꞌ totbikdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nix chuꞌ asaak dho moo ku pim kusbiodaꞌ, gio gu jam sussak pu daipuꞌ ɨp na pim jax ja aaꞌntuꞌndaꞌ, cham tuꞌ na pim guꞌ jaiꞌp ja uaꞌkaꞌ na pim mu paiꞌ ba aadaꞌ noꞌt ma juu. Ni gu oxia ku pim uaꞌkaꞌ na pim kɨꞌn oxiakkidhaꞌ, na guꞌ gu jaroiꞌ na puꞌñi tu juandaꞌ bhaankam gu Dios, pu bɨɨx tu makiidhaꞌ am mu jaꞌp na jax aꞌjidhaꞌ gu tuꞌ na aꞌmiram jum aagidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Baꞌ mu paiꞌ jax chuꞌm kiicham na pim aayaꞌ na paiꞌ muiꞌ maap daaꞌñxim jir kikcham kaꞌ, mi jaꞌp japim naiꞌ xi gaagaꞌ gu jaroiꞌ nar jix bhaiꞌkam kaꞌ, miꞌ pim baꞌ xi juruuñdhai buiñor na pim jɨꞌx juugɨt tɨɨmoꞌ na pim tu ja aꞌgidhimɨi gu jaꞌtkam guiꞌ nam mi jaꞌp oiꞌñkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Baꞌ na pim jax muiꞌ ji baapkiaꞌ miꞌ paiꞌ jax chuꞌm kiicham, xi chu ja daañxidhai pim muiꞌ xi ja ñioꞌkdhaꞌ guiꞌ nam miꞌ oiꞌñkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Baꞌ noꞌ mɨt jix kɨɨgalh gu puiꞌ na pim jax tɨꞌyaꞌ, dho guꞌ puiꞌ dho ji chu buusniaꞌ na pim jax jaꞌk tu ja daañxidhaꞌ. Piam noꞌ mɨt guꞌ cham kɨɨgalh gu puiꞌ na pim jax tɨꞌyaꞌ, dho guꞌ pu cham dho puiꞌ ji chu buusniaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Piam ku guꞌ noꞌ ni jɨꞌx kum cham jam kɨɨgalhiꞌñ, gio noꞌm pu cham jam kaim, pu jimiaꞌ pim miꞌ dhɨr maakam jaꞌk, dai na pim mi jaꞌp xi xiixkai gu jam tooton nat jɨꞌx miꞌ bam tɨɨ gu dɨbɨɨr na baꞌ bhaan jix maatɨꞌ kaꞌ na mɨt cham jam kɨɨgalh. ");
INSERT INTO stpNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Baꞌ aañ yaꞌ pu jam tɨtda nax ioꞌm cham bhaiꞌ tu ja jimiaꞌ dhiꞌ dhi jaꞌtkam janoꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, nam guꞌ giilhim jum tulhiiñaꞌ, cham tuꞌ puiꞌ na jax gu Sodooma kam gio gu Gomorra kam. ");
INSERT INTO stpNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Baꞌ aañ muiꞌ xi jam jootsaꞌ jaꞌp na kakasnir mu jaꞌp ja bui guiꞌ nam jaꞌp ji buan na jax gu sɨsɨɨꞌ nam giilhim jix bhaaꞌmnaꞌ. Baꞌ jam aꞌm jum aaꞌ na pim jix chu matdaꞌ kaꞌ na pim jax dhuim palhbuidhaꞌ jaꞌp na jax gu kookoꞌ guiꞌ nam jix chu mamatdaꞌ, gio baꞌ na pim cham bhakkudaꞌ jaꞌp na gu giokdaꞌ nam cham bhaaꞌmnaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Moo pim cham jax jum aaꞌndaꞌ, nam guꞌ jam daꞌngɨi jam uiꞌkaꞌ ji ja bui gu gɇꞌgɇrkam jum aaꞌndam, gio baꞌ nam jam gɨɨꞌbiaꞌ mu jaꞌp nam paiꞌ jax tu daandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gio baꞌ gux ioꞌm gɇꞌgɇrkam ja buim jup jam uiꞌkaꞌ noꞌm xi ɨlhiiꞌñ. Baꞌ dhi puꞌñi jaꞌk jiñ aꞌmkam tu ja aꞌgidhaꞌ pim gu gɇꞌgɇrkam jum aaꞌndam gio baꞌ guiꞌ nam cham tuꞌ kaꞌm nɨiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Baꞌ nam paiꞌ dhuuk mu ba jam aichdhaꞌ ja bui gu gɇꞌgɇrkam, chaꞌpim jax jum aaꞌndaꞌ na pim jax jaꞌk tɨꞌyaꞌ, na guꞌ jam makiaꞌ jia gu matdaꞌ gu Dios na pim jax jaꞌk tɨꞌyaꞌ na pim paiꞌ dhuuk muiꞌ ji chu aꞌgaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Baꞌ cham tuꞌ aapiꞌm mu tu aꞌgaꞌ, guꞌ guiꞌ jix Dhuuduꞌ kam jix Uañ Iiꞌmdagaꞌn guñ Gɨꞌkoraꞌ na jam makiaꞌ gu matdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Baꞌ guiꞌ nam jɨꞌk tɨ jɨɨꞌñdhaꞌ aañ jiñ bui, bhaiꞌ ji ja bhaamkidhaꞌ am gu ja jaaduñ. Puiꞌ na jax gu ja maamar noꞌ mɨt tɨ jɨɨꞌñ aañ jiñ bui, gu ja tataat jam bhaiꞌp ji ja bhaamkidhaꞌ. Piam ku guꞌ noꞌ mɨt gu ja tataat jiñ bui tɨ jɨɨꞌñ, gu ja maamar jam bhaiꞌp ji ja bhaamkidhaꞌ, ja koodaꞌ am dho guꞌ noꞌm xi ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Baꞌ bɨɨx pɨx xi jam bhaamkiꞌñdhaꞌ am gu jaꞌtkam na pim jɨꞌk tɨ jɨɨgiꞌñ aañ jiñ bui. Ku baꞌ guꞌ gu jaroiꞌ noꞌ gammɨjɨ cham jax jim aagɨt pu tɨ jɨɨgiꞌñ aañ jiñ bui, jix bhaiꞌ tu jimiaꞌ ji, na guꞌ jimiaꞌ jix dhaam jaꞌk na paiꞌ dhuuk mukiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Baꞌ nam paiꞌ dhuuk bhaiꞌ ji jam oꞌbhaiꞌñdhaꞌ mu paiꞌ jax chuꞌm gɇꞌ kiicham, aapiꞌm miꞌ dhɨr pu ji jimiaꞌ maakam jaꞌk jumai gɇꞌ kiicham, na guꞌ aañ nañ xib bhaankamuꞌn yaꞌ oirɨ guñ Gɨꞌkoraꞌ, cham xiim gio bhaiꞌp jim iñ, aapiꞌm chakui bɨɨx tɨɨmoꞌ na pim tu aꞌgimɨi na jɨꞌk kap jir kikcham yaꞌ dhi Israel. ");
INSERT INTO stpNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Na guꞌ na pim jax bax maat jiñ jaaduñ, na cham jaroiꞌ jaiꞌch gu maaꞌnkam na moo jaꞌxbuiꞌp xim taat na jax gu jax chuꞌm gɇꞌkam tugiꞌñ, ni na cham jaiꞌch gu tujuandam na moo jaꞌxbuiꞌ puiꞌp xim ɨlhiiꞌñdhaꞌ na jax guiꞌ na miꞌ buiñor tujuandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Guꞌ dai ji na kɇɇjidhaꞌ pɨx na jax jaꞌk tɨɨdaidhaꞌ guiꞌ na kaichgɨdaꞌ, cham tuꞌ na guꞌ miꞌ bɨɨpɨꞌ kat gɇꞌkam jup bam taat kaꞌ, gio gu tujuandam na jax jaꞌk tɨɨdaidhaꞌ pɨx ɨp gu gɇꞌkam tugiꞌñ, miꞌ puiꞌ duñiidhaꞌ. Gio puiꞌ na jax gu kiokam noꞌm jax tɨtda na jaꞌook bhaan jup tuꞌiiꞌ, ¿cham aa pim ɨlhiiꞌñ nam giilhim jix buam ja tɨtdadaꞌ guiꞌ nam jɨꞌk maap miꞌ oiꞌñkaꞌ? Baꞌ aapiꞌm puꞌñip jam tɨtdadaꞌ am gu jaꞌtkam na pim tɨ jɨɨgiꞌñ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Baꞌ aañ yaꞌ pu jam tɨtda na pim cham ja ɨɨbhiꞌñdhaꞌ gu jaꞌtkam, na guꞌ puiꞌ pɨx cham jɨꞌxkat jup jum ɨxchuꞌ gu tuꞌ na jax jum kaiꞌchdhaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, pu maaꞌn nam jax machiaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Baꞌ nañ jax jam tɨtdadaꞌ gux ɨxchuixim, aapiꞌm maaxik bhaamɨ jaꞌp baꞌbhak dhaam xi guꞌkɨi gɇꞌ kɨꞌn pu ja tɨɨdaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Chaꞌpim ja ɨɨbhidhat guiꞌ nam xi jam koodam kaꞌ, na guꞌ dai gu jam tutkuꞌ nam jam koodaꞌ, guꞌ gu jam iꞌiiꞌmdaꞌ pu cham ji nam jax ja doodaꞌ, na guꞌ pu cham bhaaiꞌ nam jax dhui ja koodaꞌ. Guꞌ guiꞌ ji Dios na pim baꞌx ɨɨbhiꞌñdhaꞌ, na guꞌx bhaaiꞌ na mu jaꞌk ja jootsaꞌ gu jam iꞌiiꞌmdaꞌ nam paiꞌ gammɨjɨ miꞌ pup jum tulhiiñdhaꞌ noꞌ xi ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Na guꞌ na pim jax bax maat jia, nam panaas cham muiꞌ namɨɨk gu uꞌjiꞌ guiꞌ nam mu jaꞌp jum gaꞌra. Noꞌt jaroiꞌ jɨꞌk maakob tumñix kaꞌm ja sabaꞌlh, muiꞌ ja aichdhaꞌ. Ku guꞌ bɨɨx ja nɨidhat jup tuꞌiiꞌ ji guñ Gɨꞌkoraꞌ, sia kum guꞌ tɨi cham muiꞌ namɨɨk. ");
INSERT INTO stpNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Baꞌ aapiꞌm jix ioꞌm jix dhaꞌram jam ɨlhiiꞌñ gu Dios, cham tuꞌ puiꞌ na jax gu uꞌjiꞌ. Bɨɨx sia jam kuup jix maat na jɨꞌk aix, sia ku guꞌ tɨix bii alh. Baꞌ aañ yaꞌ pu jam tɨtda na pim cham jax jum aaꞌndaꞌ sia kum giilhim jam tɨtda gu jaꞌtkam, na guꞌ jam aꞌm tɨ nɨiꞌñ jia gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Baꞌ noꞌm ba jam tɨkka gu jaꞌtkam noꞌ pim moo sɨlhkam tɨ jɨɨgiꞌñ aañ jiñ bui, baꞌ noꞌ pimɨt cham jax ji chɨꞌɨɨk jup xi ja aagiꞌñ nar sɨlhkam, dho guꞌ aañ puiꞌ dhop aagiꞌñdhaꞌ guñ Gɨꞌkoraꞌ nax dhaam jup tuꞌiiꞌ na pim maaxik sɨlhkam jiñ bui tɨ jɨɨgiꞌñ na baꞌ jam aꞌm tɨ nɨidhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Guꞌ ji noꞌ pim guꞌx ja ɨɨbhidhat cham ja aagiꞌñ na pim tɨ jɨɨgiꞌñ aañ jiñ bui, dho guꞌ aañ puiꞌ pɨx jup tɨɨdaꞌ dho guñ Gɨꞌkoraꞌ nax dhaam jup tuꞌiiꞌ na pim maaxik pu cham tɨ jɨɨgiꞌñ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Chaꞌpim jax jum aaꞌndaꞌ jiñ jaaduñ na ñich aañ panaas pu kaiꞌñkam bha jii yaꞌ dhi oiꞌñgaꞌn bhaan nañ baꞌ yaꞌ maaꞌn ñiꞌook jup ja duñiaꞌ gu jaꞌtkam nam ka xim bhabhaakuiꞌñdhaꞌ, guꞌ jaꞌkbuiꞌ kat jaꞌp ji buus ji na ñich bha ja kookdhichdham. ");
INSERT INTO stpNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na guꞌ jaiꞌ dhɨt noꞌm tɨi ba tɨ jɨɨgiꞌñ aañ jiñ bui, bhaiꞌ ji ja bhaamkidhaꞌ am gu ja maamar, piam gu ja maamar gu ja gɨꞌkoraꞌm bhaiꞌp ji ja bhaamkidhaꞌ, jaiꞌ baꞌ gu ja kakaꞌmdaꞌm bhaiꞌp ji ja bhaamkidhaꞌ gu ja dadaaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dɨɨlh dho guꞌ daim oiꞌdhagɨm nam cham maaꞌn ñiꞌook jup duukaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Baꞌ gu jaroiꞌ noꞌ aañ jiñ bui tɨi tɨ jɨɨgiꞌñ, noꞌ guꞌ dai gu taataꞌn pɨx jix ioꞌm jix dhaan, dhiꞌ jaꞌp ji buusan na pu cham tɨ jɨɨgiꞌñ aañ jiñ bui, na guꞌ cham pɨk jiñ buix biiñak kaꞌ. Piam mu dɨr bha jaꞌk gu ja gɨꞌkoraꞌ noꞌm dai gu ja maamar pɨx jix ioꞌm jix ja daꞌ, puiꞌ jaꞌp jup ji buusan nam pu cham tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Gio gu jaroiꞌ noꞌt dai ba ji chooꞌn noꞌm bax muꞌaam na tɨ jɨɨgiꞌñ aañ jiñ bui, puiꞌ jaꞌp jup ji buusandaꞌ na pu cham tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Na guꞌ gu jaroiꞌ noꞌ tɨix aaꞌ na gammɨjɨx bhaiꞌ tu jimdaꞌ yaꞌ maaxik bhaan, gatuuk cham bhaiꞌ tu jimiaꞌ, na guꞌ jimiaꞌ mu jaꞌk na paiꞌ gammɨjɨ miꞌ pup jum tulhiiñdhaꞌ. Guꞌ cham ji noꞌ guꞌ cham tuꞌ ji kɇkɇɇdat gammɨjɨ pu tɨ jɨɨgiꞌñ aañ jiñ bui sia ku mɨt ma mua, dai na ba jimiaꞌ pɨx jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Baꞌ gu jaroiꞌ noꞌt jix bhaiꞌ jam tɨɨdak jix bhaiꞌ ba jam duu, dhiꞌ jaꞌp ji buusniaꞌ nat aañ jix bhaiꞌ bañ dhuu. Piam ku guꞌ noꞌt aañ jiñ bui tɨ jɨɨꞌñdhak jix bhaiꞌ ba jam duu, dhiꞌ jaꞌp jup ji buusniaꞌ nat guiꞌx bhaiꞌ ba duu nat jaroiꞌ bhañ joot jix dhaam dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Baꞌ gu jaroiꞌ na puꞌñix bhaiꞌ tɨɨdaix bhaiꞌ ba duñiaꞌ guiꞌ na bhaankam tu aꞌgadaꞌ gu Dios, noꞌ guꞌx maat pɨx nat Dios bha joot, dho guꞌ pu chuꞌm dhop maiꞌchiaꞌ jix dhaam jaꞌk buiñor gu Dios na jax chuꞌm maiꞌchiaꞌ guiꞌ na bhaankamuꞌn tu aꞌgadaꞌ gu Dios. Piam puiꞌ na jax gu jaroiꞌ noꞌr jix bhaiꞌkam, noꞌt jaroiꞌx bhaiꞌ tɨɨdak jix bhaiꞌ ba duu, dho guꞌ pu chuꞌm dhop maiꞌchiaꞌ jix dhaam jaꞌk buiñor gu Dios na jax chuꞌm maiꞌchiaꞌ guiꞌ nar jix bhaiꞌkam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Baꞌ gu jaroiꞌ noꞌt puꞌñix bhaiꞌ tɨɨdak jix bhaiꞌ ba duu maadɨt guiꞌ nam puꞌñi tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui, sia tuꞌ suudaiꞌ pɨx noꞌt ba toiꞌ, dhiꞌ kɨꞌn ba maiꞌchiaꞌ gux dhaꞌram namkɨm jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ, aañ moo yaꞌ pu jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Baꞌ nat paiꞌ dhuuk tɨɨmo gu Jesuus na tu ja aꞌgidhimɨk gu mambhɨɨx daman gook noonbiꞌñ, pu jii mu jaꞌp na paiꞌ ɨꞌlhich jir kikcham kaꞌ guiꞌ na dhiꞌ pɨx bhaan jup bipioꞌ gu dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Baꞌ bhammɨ na paiꞌ kuupkaꞌ gu Juan jaꞌtkam bopkondam, puiꞌ ba tɨ kai na mu paiꞌ pɨx oirɨt jix kɨɨꞌp jum duukam jup tu bua gu Jesuus. Baꞌ muiꞌ ma ja joot jɨꞌkchi gu jaꞌtkam tugiꞌñ guiꞌ nam kaichgɨdaꞌ ");
INSERT INTO stpNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nam sap tɨtkapuꞌ noꞌ sap moor diꞌ guch Xoiꞌkam guiꞌ na saak bha jootsaꞌ gu Dios jix dhaam dɨr, piam ku guꞌ sap noꞌ jax kaiꞌch nar jumai nam baꞌ nɨɨradaꞌ guiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Baꞌ mummɨ jiimdat puiꞌp ba tɨtdaim am gu Jesuus. Baꞌ guiꞌ cham ja aagiꞌñ miꞌ jotmodaꞌ, dai nat xim jotmaꞌñ pɨx nat mi jaꞌp naiꞌ xi ja duduaꞌñ gux kakoꞌkkam. Miꞌ dhɨr baꞌ moop ja tɨtda: ―Ea na pim aaꞌñdhapuꞌ gu Juan jaꞌtkam bopkondam gu puiꞌ na pimɨt jax bañ chɨɨ na ñich ja duduaꞌñ dhiñ jaaduñ nam kax kakoꞌk kat, gio baꞌ puiꞌ na pimɨt jax bañ kai nañ ja aagiꞌñ nam jax jaꞌk duñiaꞌ nam baꞌ jimiaꞌ jix dhaam jaꞌk buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jaꞌp japim tɨɨdaꞌ na ñich tu ja tɨɨꞌñchoda guiꞌ nam cham ñiññia kat, gio baꞌ guiꞌ na tootolhidhat ka gakiidhat gu ja tutkuꞌ na ñich bɨɨx jup ja duduaꞌñ. Gio baꞌ guiꞌ nam kax mamaꞌmkulhiꞌ kat nam pu cham tu oipot, bɨɨx japim jup xi aagiꞌñdhaꞌ na ñich ja duduaꞌñ, gio baꞌ jaiꞌ guiꞌ nam cham tɇ kɇɇkɇt. Gio baꞌ jaiꞌ guiꞌ nam ba koꞌiix kat na ñich bɨɨx jup ja baapmiꞌ ja duduaꞌñdhak. Gio baꞌ nañ tu ja aꞌgiꞌñdhaꞌ gux bhaiꞌm kaiꞌchdham ñioꞌkiꞌñ gu Dios guiꞌ nam cham tuꞌ biaꞌ nam gampaiꞌ tuꞌm, nam soiꞌ pɨx jum ɨlhiiꞌñ, nañ ja aagiꞌñdhaꞌ nam jax jaꞌk duñiaꞌ nam baꞌ jimiaꞌ jix dhaam jaꞌk buiñor. ");
INSERT INTO stpNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jaꞌp moo joidham jix bhaiꞌ tu jimiaꞌ gu jaroiꞌ noꞌ pu gammɨjɨ tɨ jɨɨgiꞌñ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Baꞌ pu jii mɨt gu jaꞌtkam tugiꞌñ gu Juan jaꞌtkam bopkondam daipuꞌ nat puꞌñi xi ja tɨɨꞌn gu Jesuus. Miꞌ dhɨr baꞌ moop ja tɨtda gu Jesuus gu jaꞌtkam guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ: ―¿Tuꞌ pimɨt mu tɨɨꞌmpuk mummɨ gampɨx jix chu gak kɨr janoꞌ na pimɨt paiꞌ dhuuk mu jimɨɨk? ¿Gu junboꞌ aa na miꞌ joidham jum bua na bhaiꞌ xi jɨbɨɨr? ");
INSERT INTO stpNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Kaꞌ tuꞌ ji pimɨt mu tɨɨꞌmpuk na pimɨt baꞌ moom dɨkooꞌñ na pimɨt mu jii? ¿Kaꞌ jaroiꞌ aa mi oirɨ ji chɨm tɨiꞌdhat gu jajannulh jix aꞌbhar jix dhaꞌram namkɨm? Moo chi guꞌ cham ji, na guꞌ na pim jax bax maat bo jia na guiꞌ nam pu chuꞌm tɨm tɨꞌiiꞌñkaꞌ, dai mummɨx joiꞌñdhaꞌ am nam darkaꞌ ja bui gux ioꞌm gɇꞌgɇrkam jum aaꞌndam. ");
INSERT INTO stpNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Moo chi guꞌ guiꞌ ji na pimɨt mu tɨɨgim guiꞌ nax ioꞌm jix bhaiꞌ xi buadaꞌ na tu aꞌgadaꞌ, cham tuꞌ puiꞌ na jax guiꞌ nam bɨjɨk bhaankamuꞌn jup tu aꞌgimɨk gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Guiꞌ dho Juan jaꞌtkam bopkondam jañ aagat jup kaiꞌch, na guꞌ dhiꞌ aagat jup kaiꞌch guñ Gɨꞌkoraꞌ miꞌ na paiꞌ tu uaꞌñix gu ñioꞌkiꞌñ na jaꞌpnim kaiꞌch: Jumaiñ bɨɨpɨꞌ mu jootsaꞌ na baꞌ ba ja mattudaꞌ gu jaꞌtkam nap jootom muiꞌ ba jim. ");
INSERT INTO stpNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Baꞌ gu Juan jaꞌtkam bopkondam, aañ gɇꞌkam kɨꞌn biaꞌ ja bui gu jaꞌtkam, nat guꞌ gɇꞌkam kɨꞌn bhaan tɨ tɨɨ guñ Gɨꞌkoraꞌ. Ku baꞌ guꞌ gu jaroiꞌ noꞌ miꞌ puiꞌ ba jim na jax jix aaꞌ guñ Gɨꞌkoraꞌ, puiꞌ pɨx gɇꞌkam kɨꞌn jup biaꞌkaꞌ iñ ji, na guꞌ jaꞌxbuiꞌ puiꞌ bhaan jup ba tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Baꞌ tɨix muꞌaam kaꞌ am gu jaꞌtkam gu Juan jaꞌtkam bopkondam janoꞌ dɨr nat paiꞌ dhuuk ya ai, nam guꞌ tɨi cham kaim kaꞌ na tɨi ja aagiꞌñdhaꞌ nam jax jaꞌk duñiaꞌ na baꞌ ja aꞌm ba tɨ nɨidhidhaꞌ gɨt gu Dios, guꞌ ji nam guꞌ dai xix bhaakut. ");
INSERT INTO stpNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Baꞌ puꞌñi tɨi pu tu ja aꞌgiꞌñdhaꞌ am gu jaꞌtkam guiꞌ nam bɨjɨk bhaankam jup tu aꞌgimɨk gu Dios na jax jaꞌk tu ja aꞌgidhimɨk gu Juan jaꞌtkam bopkondam, gio baꞌ na mɨt tɨi tu uaꞌnak gu ñioꞌkiꞌñ gu Dios nam baꞌ jiñkuidhai miꞌ puiꞌ ba jimiaꞌ gɨt, guꞌ ji nam guꞌ ba puiꞌ pɨx cham jup tɨ jɨɨgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Baꞌ gu Juan jaꞌtkam bopkondam jir diꞌ pɨx gu Eliiyas guiꞌ na bɨjɨk bhaankamuꞌn tu aꞌgimɨk gu Dios, na guꞌ puiꞌ jaꞌk tu uaꞌñix gu ñioꞌkiꞌñ gu Dios na saak puꞌñi gio yaꞌp ba aayaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Moo pim jix bhaiꞌ xim gaꞌngadaꞌ na jax jir jum duukam gu dhiꞌ puiꞌ nañ jax jam tɨtda na pim baꞌ miꞌ puiꞌ jimiaꞌ noꞌ pim tɨ jɨɨgiꞌñ nar sɨlhkam. ");
INSERT INTO stpNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Tuꞌñ gɨt bhaan ji uaꞌrgidhai tu jam aagidhaꞌ nam jax jaꞌk ji buan gu jaꞌtkam guiꞌ nam xib jix jaiꞌch? Jaꞌp ji buan am dho na jax gu aꞌaalh noꞌ mɨt muiꞌ maap xim daagɨk mu paiꞌ ma tɨtbim jax chuꞌm giotɨr. Baꞌ noꞌ mɨt jaiꞌ bha jaꞌp ji dharaibuk ma tu saas, baꞌ nam paiꞌ dhuuk xi saasbichui jup ja tɨɨdaꞌ am gu jaiꞌ ja bɨpnaꞌ aꞌaalh: ");
INSERT INTO stpNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ni jɨꞌx ku pimɨt iam tɨ nɨi na chich tɨi ma tu saas, ni ku pimɨt xi susuanɨ na tɨi joiꞌmdam jum kaiꞌchɨt gu saasab.” ");
INSERT INTO stpNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Puꞌñi jaꞌk ji buan am gu jaꞌtkam guiꞌ nam xib jix jaiꞌch. Tɨɨꞌ na guꞌ gu Juan jaꞌtkam bopkondam nat tɨi yaꞌ xi ɇɇk ja bui, puiꞌ aiꞌchux jamɨt na jaꞌook bhaan jup tuiꞌñgɨdaꞌ, sia ku guꞌ gammɨjɨ tɨim saabdaꞌ gio na tɨi cham paiꞌ dhuuk ioꞌdaꞌ gu biiñ. ");
INSERT INTO stpNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Gio baꞌ aañ nat bhañ joot guñ Gɨꞌkoraꞌ, maakam jup jiñ aiꞌchux jamɨt, sia kuñ guꞌ tɨi cham paiꞌ dhuuk jiñ xaabdaꞌ. Puiꞌ kaiꞌchdhaꞌ am nañ sap giilhim gɇꞌ tu kuaꞌ gio sap nañ giilhim jix iꞌmuk, jix ja oiꞌñ iñ sap guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñ gio guiꞌ nam jir tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam. Ku baꞌ guꞌ gu Dios pɨx mattudaꞌ ji gu jaroiꞌ na tuꞌ sɨlhkam jix maachim kaꞌ nañ jir tuꞌp tuꞌm daꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Baꞌ bhaan bhaiꞌp ji chu aꞌga gu Jesuus gook kap na paiꞌ muiꞌ maap daaꞌñxim jir kikcham kaꞌ, miꞌ nat paiꞌ pɨk jix ioꞌm muiꞌx kɨɨꞌp jum duukam jup tu duu, guꞌ ji na mɨt guꞌ cham miꞌ puiꞌ jii na jax jix aaꞌ gu Dios. Baꞌp kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Jaꞌp moo cham bhaiꞌ tu jam jimiaꞌ aapiꞌm na pim Korasiiñ oiꞌdhaꞌ gio baꞌ aapiꞌm na pim Betsaida jaꞌk jup oiꞌdhaꞌ, na pimɨt guꞌ cham miꞌ puiꞌ jii na jax jix aaꞌ guñ Gɨꞌkoraꞌ! Tɨi ñich jam nɨiꞌñchudat joidham jix kɨɨꞌp jum duukam jup tu duu jam bui na pim tuꞌ cham paiꞌ dhuuk nɨidhat. Iam chi na pimɨt guꞌ tɨɨgɨk miꞌ puiꞌ ba jii. Na guꞌ noꞌñ mu jaꞌk Tiiro puiꞌ joidham jix bhaiꞌm duukam jup tu duñiaꞌ gɨt, gio mu jaꞌk na paiꞌ Sidoon jup tɨ tɨɨꞌ, moo janoꞌ gɨt nam tɨ jɨɨꞌñdhai gu jaꞌtkam buiñor guñ Gɨꞌkoraꞌ miꞌ puiꞌ ba jimiaꞌ na jax jix aaꞌ, baꞌ dai nam ba tɨm tɨiꞌdhaꞌ gɨt gu jajannulh jix xaasak, ni kum bar tu batbiadam kaꞌ gɨt, gio nam mu jaꞌp pɨx ba daraakaꞌ gɨt na paiꞌ jax kaat gu matai, baꞌ dhiꞌ bhaan jix maatɨꞌ kaꞌ gɨt nam jix ioꞌm soiꞌ bam ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Baꞌ xib tuꞌ na jax chuiꞌkaꞌ, janoꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, na paiꞌ dhuuk guñ Gɨꞌkoraꞌ ja aagiꞌñdhaꞌ bɨɨx gu jaꞌtkam nam jɨꞌk tuꞌ jax buimɨi, aapiꞌm giilhim jam tulhiiñchudaꞌ, cham tuꞌ puiꞌ na jax gu Sidoon kam jaꞌtkam gio gu Tiiro kam. ");
INSERT INTO stpNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Baꞌ aapiꞌm na pim Kapernaum oiꞌdhaꞌ, ¿jaꞌp jum aaꞌ pim aa na pim aayaꞌ jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ? Matgɨm mu jaꞌk ji na xi jam jootsaꞌ jix ioꞌm tuukab jaꞌk na paiꞌ gɇꞌ tɨ dɨꞌ, na pimɨt guꞌ cham miꞌ puiꞌ jii na jax jix aaꞌ. Na guꞌ noꞌñ mu jaꞌk Sodooma puiꞌ joidham jix kɨɨꞌp jum duukam jup tu duñiaꞌ gɨt, moo janoꞌ gɨt nam tɨ jɨɨꞌñdhai miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ, xib dho pui miꞌr kiicham kaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Baꞌ aañ yaꞌ pu jam tɨtda na janoꞌ na paiꞌ dhuuk ja aagiꞌñdhaꞌ guñ Gɨꞌkoraꞌ bɨɨx gu jaꞌtkam nam tuꞌ jax buimɨi, aapiꞌm giilhim jam tulhiiñchudaꞌ, cham tuꞌ puiꞌ na jax gu Sodooma kam kat. ");
INSERT INTO stpNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Baꞌ miꞌ puiꞌ xi kaiꞌchimɨk gu Jesuus, bhaiꞌ ji chu daanɨ jix dhaam jaꞌk, jup kaiꞌch: ―Taxchaab baꞌñ Gɨꞌkoraꞌ nap jir Gɇꞌkam jix dhaam gio yaꞌ dhi oiꞌñgaꞌn bhaan, na pich guꞌ ba ja mattuda gu jaꞌtkam guiꞌ nam cham gɇꞌgɇrkam jum ɨlhiiꞌñ na tuꞌr jix bhaiꞌm duukam. Jaꞌp xi ja duuk japich guiꞌ nam puiꞌm aaꞌ nam panaas jix ioꞌm jix maat gum ñiꞌook, na guꞌ dai nam bhaan pɨx gɇꞌgɇrkam jum ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Puiꞌ dhoñ Gɨꞌkoraꞌ, puiꞌ jaꞌk jix aaꞌ ap. ");
INSERT INTO stpNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Miꞌ dhɨr baꞌ moo jaꞌpni bhaiꞌp ji chu ja aꞌgi gu jaꞌtkam, jup ja tɨtda: ―Aañ bhañ joot guñ Gɨꞌkoraꞌ jix dhaam dɨr nañ baꞌ bhaankam ya jaꞌp ja aagiꞌñdhaꞌ gu jaꞌtkam na tuꞌr jix bhaiꞌm duukam. Baꞌ dɨɨlh pɨx jix maat guñ Gɨꞌkoraꞌ nañ jir tuꞌp tuꞌm daꞌ, nañ guꞌr Maraaꞌn, gio aañ yaꞌ dɨr mu jaꞌk dɨɨlh pɨx jup jix maat ɨp guñ Gɨꞌkoraꞌ nar tuꞌp tuꞌm daꞌ. Ku baꞌ guꞌ gu jaroiꞌ noꞌ moo jaꞌp tuꞌ sɨlhkam kɨꞌn jix maachim nach jir tuꞌp tuꞌm daꞌ gook dɨt guñ Gɨꞌkoraꞌ, aañiꞌ dho aagiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Bañ kaichgɨdaꞌ pim bɨɨx na pim jɨꞌk jix xijaim tu jim, aañ jam aagiꞌñdhaꞌ na pim jax jaꞌk duñiaꞌ na pim baꞌ cham puiꞌ jaꞌk ka tu jimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Miꞌ pim puiꞌ xi jimɨi nañ jax jam tɨtda, chaꞌpim dai gɇꞌgɇrkam jum taat kaꞌ, jaꞌp na jax aañ nañ guꞌ gampaiꞌñ ɨlhiiꞌñ, cham tuꞌ gɇꞌkam jiñ chaat iñ. Baꞌ aapiꞌm puꞌñi jaꞌk jam aꞌm jup jum aaꞌ na pim miꞌ puiꞌ jimiaꞌ na pim baꞌx bhaiꞌm taat kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Baꞌ dhiꞌ puiꞌ nañ jax jaꞌk jam aagiꞌñ na pim jiñ kaichgɨdaꞌ, cham tuꞌ puiꞌx xijai na pim miꞌ puiꞌ jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Baꞌ maaꞌnnim na paiꞌ dhuuk aagix kaꞌ na cham tum juandaꞌ ja bui gu dai Israel kam jaꞌtkam, ma jii gu Jesuus, moo miꞌ buusnichuꞌ na paiꞌ tɨ ɨx kaꞌ gu tiriik. Baꞌ gu jaꞌtkam tugiꞌñ na ja bɨɨm mu jim, tu kaipgaidhat tu koꞌiim am gu tiriik, nam guꞌ bax bhioꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Guꞌ baꞌ nam guꞌ jaiꞌ muiꞌp jiim jia guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, baꞌ am jix bhaaktuꞌ am nam ja nɨiꞌñ nam puiꞌ jɨꞌ tu buim gu jaꞌtkam tugiꞌñ gu Jesuus, baꞌp tɨtda am: ―¿Jax kum baꞌ tu kaipgaidhat tu koꞌiim gu tiriik dhim jaꞌtkam tuk? ¿Kux cham maat am aa na xib aagix na cham tum juandaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Baꞌp ja tɨtda gu Jesuus: ―¿Kux aapiꞌm cham jɨꞌxkat tu jiñkuiꞌñ aa miꞌ na paiꞌ tu uaꞌñix gu ñioꞌkiꞌñ gu Dios nat jax tu duu gu Dabii gio gu jaꞌtkam tugiꞌñ janoꞌ nam paiꞌ dhuuk ba uaꞌmaim? ");
INSERT INTO stpNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Na mɨt tu juu bo gu paan gux xidhuu kam guiꞌ na miꞌ tɨkiix kat gɇꞌ chiop na saak dai guiꞌx bhaaiꞌ nam kuaꞌdaꞌ guiꞌ nam miꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, cham tuꞌ gu tuꞌ jaꞌppɨx jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Gio baꞌ miꞌ nat paiꞌp tu uaꞌnak ɨp gu Moisees nap jum kaiꞌch ɨp na saak guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, saak cham tuꞌm uaꞌtulhiꞌñdhaꞌ am sia kum pu tu juan janoꞌ na paiꞌ dhuuk aagix na cham tum juandaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Baꞌ aañ yaꞌ pu jam tɨtda na maadɨt ya oirɨ nax ioꞌm jum aaꞌ na pim tuꞌ kaꞌm nɨiꞌñdhaꞌ, cham tuꞌ puiꞌ na pim jax tuꞌ kaꞌm tɨ nɨiꞌñ bhaiꞌ gɇꞌ chiop. ");
INSERT INTO stpNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Cham dho bak maatɨt kɇɇ pim jia gu puiꞌ na jax jaꞌk tu uaꞌñix gu ñioꞌkiꞌñ gu Dios na jaꞌpnim kaiꞌch: “Guꞌ aañ nañ jix aaꞌ ji na pim jix chu joiꞌgɨꞌndaꞌ, cham tuꞌ na pim jax jum aaꞌndaꞌ nañ aañ jix aaꞌ na pim dai na pim tuñ makgɨrxiꞌñdhaꞌ pɨx gu tuꞌ sasoiꞌ, dhiꞌ kɨꞌn miꞌ puiꞌ ba jiim japim nañ jax jix aaꞌ.” Na guꞌ noꞌ pim jix maatɨt kɇɇkɇꞌ gɨt gu dhiꞌ puiꞌ jɨꞌ na jax jaꞌk jum kaiꞌch, cham tuꞌ puiꞌ kaiꞌchdhaꞌ pim gɨt nam jum uaꞌtulhiꞌñ dhiñ jaꞌtkam tuk, sia kum guꞌ tɨi cham tuꞌm uaꞌtulhiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Baꞌ aañ nat bhañ joot guñ Gɨꞌkoraꞌ yaꞌ pu jam tɨtda na cham jax bua gu tuꞌ noꞌñ jax jix dhuñiim janoꞌ na paiꞌ dhuuk aagix na tɨi cham tum juandaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Baꞌ na miꞌ jɨꞌ puiꞌ xi chu ja aꞌgidhimɨk gu Jesuus gu jaꞌtkam, ma jii maaꞌn kap mu jaꞌp nam paiꞌ tu daandaꞌ gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Baꞌ moo maaꞌn miꞌp jaiꞌch kaꞌ gu maaꞌnkam na maap dɨr jix muuk kaꞌ gu nobiiꞌñ. Baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios gio baꞌ guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, ba tɨkkaꞌ am gu Jesuus noꞌ sap jix bhaaiꞌ na duaꞌñdhaꞌ gu maaꞌnkam guiꞌ na maap dɨr jix muuk gu nobiiꞌñ janoꞌ na paiꞌ dhuuk aagix na cham tum juandaꞌ, sap baꞌ noꞌ jax kaiꞌch nax bhaaiꞌ na duaꞌñdhaꞌ, dhiꞌ bhaan jix bhaiꞌ bhɨɨyaꞌ am nam iattulhdhai tu chiñiaꞌ nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Guꞌ ji na guꞌp ja tɨtda gu Jesuus: ―¿Kux aapiꞌm jaroo maadɨt moo daas na miꞌ pɨx xi nɨiꞌñdhaꞌ gu soigaꞌn noꞌt miꞌ paiꞌ ba gɨi jax chuꞌm tɨ dɨꞌn kɨr, noꞌ guꞌ janoꞌ pɨk na paiꞌ dhuuk aagix na cham tum juandaꞌ? ¿Cham aa guꞌ moo janoꞌ mu jimɨi xi bhiaji ap, cham tuꞌ nap guꞌ miꞌ pɨx xi nɨiꞌñdhaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Guꞌ gi baꞌ dhiꞌ nar maaꞌnkam, ¿cham aa guꞌx ioꞌm jum aaꞌ nañ jix bhaiꞌ dhuñiaꞌ, cham tuꞌ puiꞌ na jax gu tuꞌ soiꞌ? Jaꞌpji na moo pu cham jax bua ji noꞌñ jax jix dhuñiim gux bhaiꞌm duukam, sia ku cham tum juan. ");
INSERT INTO stpNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Baꞌ puiꞌ xi chɨꞌɨɨk jup tɨtda guiꞌ nax muuk kaꞌ gu nobiiꞌñ: ―Ea nap xi sɨlhñaꞌ dhim nob jiñ jaduuñ. Baꞌ guiꞌ jaꞌp jup xi sɨlh, jix kɨɨꞌp jum duu miꞌ jotmodaꞌ jaꞌp na jax gu jaꞌp dɨr kam nobiiꞌñ, panaas ku moo pu cham paiꞌ muuk kat. ");
INSERT INTO stpNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Baꞌ gu pariseos bhaakuk miꞌ dhɨr pu jii mɨt, baꞌ ba tu aꞌga mɨt nam jax jaꞌk duñiaꞌ nam baꞌ tu chiñiaꞌ nam muꞌaaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Guꞌ ji nat guꞌ pu jii gu Jesuus nat jax puiꞌ tɨ kai nam bax muꞌaam, baꞌ muiꞌ jaꞌtkam pɨx chuꞌp jum duu mɨt na mɨt ba oi. Baꞌ gammɨjɨ kikcham na jax aꞌjim, xi ja duduaꞌñdhidhat bɨɨx gux kakoꞌk kam nam jɨꞌk mi jaꞌp jix jaiꞌch kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Baꞌ xi ja sooꞌmchulhdhidhat nam sap cham jaroiꞌ aagiꞌñdhaꞌ nat jaroiꞌ ja duduaꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Baꞌ dhiꞌ puꞌñi jaꞌk tum kuugalh gu puiꞌ nat jax jaꞌk tu uaꞌnak gu Isaiiyas guiꞌ na bɨjɨk bhaankam tu aꞌgimɨk gu Dios, na jaꞌpnim kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Dhiꞌñi jir diꞌ guñ mar na ñich bhaan tɨ tɨɨ, baꞌx ioꞌm jix dhaꞌ iñ gio nañ jix bhaiꞌñ chaat buiñor. Baꞌ tajaañxidhaꞌ iñ gux Dhuuduꞌ kam jix Uañ jiñ Iiꞌmdaꞌ, miꞌ dhɨr baꞌ dai na ba tu ja aagiꞌñdhaꞌ gu jaꞌtkam nam jax jaꞌk duñiaꞌ na baꞌx bhaiꞌ tu ja jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Baꞌ cham paiꞌ dhuuk jaroiꞌ kokdaꞌ, ni na cham paiꞌ dhuuk am gɇꞌ kɨꞌn jiñkuiꞌñdhaꞌ gu jaroiꞌ, ni mu jaꞌp dho moo na paiꞌ jax gɇꞌ daaꞌñxim jir kiicham kaꞌ ku cham paiꞌ pɨx am jaroiꞌ kɇɇkɇꞌ na am bhaamdaꞌ kɨꞌn tu aꞌgadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gio baꞌ na bɨɨx pɨx jix ja kɨɨgalhiꞌñdhaꞌ gu jaꞌtkam, cham tuꞌ jaroiꞌ maadɨt gampaiꞌ biaꞌkaꞌ. Gio na gammɨjɨ pu tu ja aagiꞌñdhaꞌ gu jaꞌtkam nam jax jaꞌk duñiaꞌ na baꞌx bhaiꞌ tu ja jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Baꞌ bɨɨx na jɨꞌx jir oiꞌñgaꞌn bax mat kaꞌ am nax bhaaiꞌ nam dai guiꞌ buiñor pɨx jix biiñak kaꞌ nam baꞌ jimiaꞌ jix dhaam jaꞌk buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Baꞌ jaꞌxpɨx miꞌ ba aiꞌchulh jamɨt gu Jesuus maaꞌn gu maaꞌnkam na bhaan jup tuiꞌñgɨdaꞌ gu cham kɨɨꞌ iiꞌmdaꞌ na puiꞌ jaꞌk duukaꞌ na cham ñia kaꞌ gio na cham tu ñiokdaꞌ. Baꞌ cham jax ji chɨꞌɨɨk jup xi dhuaꞌñ gu Jesuus, jix kɨɨꞌ dho guꞌp jum duu, ba tu ñiok gio na bax ñia. ");
INSERT INTO stpNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Baꞌ gu jaꞌtkam na mɨt puiꞌ jɨꞌ tɨ tɨɨ, miꞌ puiꞌ pup tuꞌiiꞌ am, dai nam jup kaiꞌch: ―¿Dhiꞌ aa chi baꞌ saak bar diꞌ guch Xoiꞌkam guiꞌ na saak bha jimdaꞌ gɨt, nar boxiiꞌñ kaꞌ gu Dabii? ");
INSERT INTO stpNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Baꞌ guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ na mɨt puiꞌ jɨꞌ ja kai nam kaiꞌch, jup ja tɨtda am: ―Chaam tuꞌ ji nar puiꞌ na pim jax ɨlhiiꞌñ. Jaꞌpji ja gɇꞌkam tuk ji gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ na bhaan jup tuiꞌdhiꞌ dhi maaꞌnkam. Puiꞌ kum baꞌx jɨɨgiꞌñdhaꞌ na maiꞌ ja jootosdaꞌ gu bɨpnagaꞌn tuutuꞌm cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Baꞌp ja tɨtda gu Jesuus, na guꞌx bhaiꞌx maat nam jax jum aagɨt jup kaiꞌch: ―Matgɨm cham tuꞌ ji nar puiꞌ na pim jax ɨlhiiꞌñ jiñ jaaduñ. Jax dhui na guꞌ gu ja gɇꞌkam tuk gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ jaꞌp pɨx ji buusan na jax paiꞌ gɇꞌ kiicham noꞌm cham maaꞌn ñiꞌook jup duuk gu tuꞌ noꞌm tɨi jax jix dhuñiik. Piam paiꞌ noꞌ palhɨɨp jir kiicham piam ku guꞌ gu dai maap jum oiꞌdhagɨm, noꞌm cham maaꞌn ñiꞌook jup duuk, dho pu cham tuꞌ dho jax ji dhuñiaꞌ am, nam guꞌ daix bhaak kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Baꞌ puꞌñi jaꞌk jup ji buusan gu ja gɇꞌkam tuk gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ noꞌt tɨi bhaiꞌ ji bhaam ja bui gu bɨpnagaꞌn tuutuꞌm cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ, nam guꞌ cham maaꞌn ñiꞌook kap duukaꞌ nam guꞌ ba bhaakuꞌ buiñor. ");
INSERT INTO stpNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Guꞌ baꞌ aapiꞌm na pim puiꞌ kaiꞌch na puiꞌ aañ jiñ aꞌm jup tuiꞌdhiꞌ gu ja gɇꞌkam tuk gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ, ¿aapiꞌm baꞌ moo puꞌñi ɨp aa gu jam jaꞌtkam tuk guiꞌ nam jam kaichuꞌ, puꞌñi aa ja gɇꞌkam tuk gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm jup tuiꞌdhiꞌ, nam baꞌx ja jɨɨgiꞌñdhaꞌ nam puꞌñi maiꞌ ja jootosdaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gu jaꞌtkam? ¿Piam aa na guꞌ cham? Na guꞌ puꞌñi pɨx jaꞌk ji buusniaꞌ nañ jax ba kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Guꞌ aañ matgɨm gux Dhuuduꞌ kam jix Uañ Iiꞌmdagaꞌn ji gu Dios nañ aꞌm jup tuiꞌdhiꞌ, puiꞌ ku baꞌx bhaaiꞌ nañ maiꞌ ja jootos gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gu jaꞌtkam, na pim baꞌ ba machiaꞌ na dhiꞌ jaꞌp jir jup duukam nat yaꞌ bam ai na pim paiꞌ dhuuk machiaꞌ na pim jax jaꞌk duñiaꞌ na baꞌ gammɨjɨ jam aꞌm ba tɨ nɨiꞌñdhaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Na guꞌ cham jir am gu jaroiꞌ na mu baakɨi baꞌkiram tɨ ɨɨxdhaꞌ gu bɨxchugaꞌn gu maaꞌnkam jix oogɨm noꞌm guꞌ gook dɨt maaꞌn ñiꞌook jup duuk. Dai noꞌm cham maaꞌn ñiꞌook jup duuk na baꞌx bhaaiꞌ na xi buuprai tɨ ɨxdhaꞌ gu bɨxchugaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Gio puiꞌ na jax gu jaꞌtkam jɨꞌk gook noꞌm mu paiꞌ tu or noꞌm cham maaꞌn ñiꞌook jup duuk. Baꞌ maaꞌn noꞌ bɨɨx gaamuim guiꞌ na jɨꞌk oraidhaꞌ, dhiꞌ jaꞌp ji buusniaꞌ na tu ja aꞌgidhaꞌ gu jaꞌtkam nañ jax jaꞌk ɨlhiiꞌñdhaꞌ aañ. Guꞌ baꞌ gu jumai noꞌ maiꞌ xi iabuidhat guiꞌ na jɨꞌk tɨip oraidhaꞌ, dhiꞌ jaꞌp jup ji buusniaꞌ na cham jɨꞌxkat puiꞌ tu ja aꞌgidhaꞌ gu jaꞌtkam nañ aañ jax jup ɨlhiiꞌñdhaꞌ, guꞌ jaꞌkbuiꞌ kat maakam xi ja iatgiꞌñdhaꞌ ji na dɨɨlh jax jup ɨlhiiꞌñdhaꞌ. Dhiꞌ baꞌ jaꞌp jup ji buusandaꞌ na cham maaꞌn ñiꞌook jup duuk aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Baꞌ aañ yaꞌ pu jam tɨtda na gu Dios jix bhaaiꞌ na tu ja uañdhaꞌ gu jaꞌtkam bɨɨx nam jɨꞌk jax jix uꞌuaꞌtulhdhix kaꞌ noꞌm soiꞌm ɨlhiiꞌñ buiñor. Piam noꞌm guꞌ gampaiꞌ pɨx biaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdagaꞌn gu Dios, noꞌ guꞌ tɨi ja mattuꞌn nam jix uꞌuaꞌtulhdhix, dho guꞌ pu cham dho tu ja uañdhaꞌ gu Dios gu ja uaꞌtulhdharaꞌ, nam guꞌ cham soiꞌm ɨlhiiꞌñdhaꞌ buiñor. ");
INSERT INTO stpNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Baꞌ noꞌm guꞌ gampaiꞌ pɨx jiñ biaꞌ aañ nat bhañ joot guñ Gɨꞌkoraꞌ, siax bhaaiꞌ na tu ja uañdhaꞌ gu Dios gu ja uaꞌtulhdharaꞌ noꞌm soiꞌm ɨlhiiꞌñ buiñor. Guꞌ baꞌ noꞌm guꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdagaꞌn gu Dios gampaiꞌ pɨx biaꞌ, dho gi guꞌ pu cham jɨꞌxkat tu ja uañdhaꞌ ji gu Dios gu ja uaꞌtulhdharaꞌ sia pɨk nar jax kaꞌ gɨt, nam guꞌ cham soiꞌm ɨlhiiꞌñdhaꞌ buiñor. ");
INSERT INTO stpNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Noꞌ pimɨt jix bhaiꞌ moikxi gu jax chuꞌm jam ɨꞌɨɨx, joidham jix kɨɨꞌ iꞌbhaiꞌñchaꞌ dho. Piam ku guꞌ noꞌ pimɨt cham bhaiꞌ moikxi, cham kɨɨꞌ iꞌbhaiꞌñchaꞌ dho. ");
INSERT INTO stpNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Baꞌ aapiꞌm puꞌñi ɨp noꞌ pim guꞌ cham jir kɨkɨɨꞌ jaꞌtkam, cham bhaaiꞌ na pim jax dhuix bhaiꞌ tu ñiokdaꞌ na jax jaꞌk jir am kaꞌ, na guꞌ dai puiꞌ jaꞌk jam chiñ am dɨr buusnidhaꞌ na pim jax jaꞌk jum aaꞌndaꞌ gu jam jujur am bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Na guꞌ gu jaroiꞌ noꞌ dɨɨlh pur jix bhaiꞌkam, joidham jix bhaiꞌ tu ñiokdaꞌ, na guꞌ dai puiꞌ jaꞌk jum aaꞌndaꞌ juraꞌran bhaan. Guꞌ baꞌ gu jaroiꞌ noꞌ pu dɨɨlh cham jir kɨɨꞌ maaꞌnkam, giilhim jix buam tu ñiokdaꞌ, na guꞌ dai puiꞌ jaꞌk jup jum aaꞌndaꞌ juraꞌran bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Baꞌ aañ yaꞌ pu jam tɨtda na bɨɨx matgilhiaꞌ jix dhaam jaꞌk na pim jɨꞌk jax jix buam tu ñiokdaꞌ, janoꞌ na paiꞌ dhuuk guñ Gɨꞌkoraꞌ ja aagiꞌñdhaꞌ bɨɨx gu jaꞌtkam nam jɨꞌk tuꞌ jax buimɨi yaꞌ dhi oiꞌñgaꞌn bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Na guꞌ noꞌ pimɨt cham soiꞌm ɨlh buiñor na baꞌ tu jam uañdhaꞌ gu jam uaꞌtulhdharaꞌ, dai na pim pɨx am tɨꞌñchokaꞌ na jam aaꞌñdhai giilhim jam tulhiiñchudaꞌ, noꞌ pimɨt cham jaꞌp xi dhuuk gu dhiꞌ puiꞌ na pim jax jix buam tu ñiokdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Baꞌ jaiꞌ dhɨt guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, ba chian am gu Jesuus na sap maaꞌn jup tu duñiaꞌ jix bhaiꞌm duukam ja nɨiꞌñchudat. Jup tɨtda am: ―Eap jix bhaiꞌm duukam xip duuñ nach tuꞌ cham paiꞌ dhuuk nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Guꞌ ji na guꞌp kaiꞌch gu Jesuus: ―Tɨix aaꞌ am dhi jaꞌtkam nam cham tuꞌ kaꞌm tɨ nɨiꞌñ nañ jix bhaiꞌm duukam jup tu duñiaꞌ ja nɨiꞌñchudat nam tuꞌ cham paiꞌ dhuuk pu chuꞌm nɨiꞌñ, guꞌ ji nañ guꞌ aañ cham tuꞌ puiꞌ tu duñiaꞌ, nam guꞌ cham tuꞌ miꞌ puiꞌ jimiik kat jup kaiꞌch na jax jix aaꞌ guñ Gɨꞌkoraꞌ. Dai gatuuk nam jiñ chɨgiaꞌ nañ puiꞌ jaꞌk jup jiñ dhuñiaꞌ nat jax jum duu bɨjɨk gu Jonaas. ");
INSERT INTO stpNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Baꞌ puꞌñi nat jax jum duu gu Jonaas nat baik tanoolh jup duu gio baik tukaaꞌ na mɨjɨ pu jim ɨrban dɨr gu gɇꞌ batoop, baꞌ aañ puꞌñi ɨp nat bhañ joot guñ Gɨꞌkoraꞌ, baik tanoolh gio baik tukaaꞌñ miꞌ pu yaasapkaꞌ dɨbɨɨr bɨtaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Baꞌ janoꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ na ja aagiꞌñdhaꞌ guñ Gɨꞌkoraꞌ bɨɨx gu jaꞌtkam nam tuꞌ jax buimɨi yaꞌ dhi oiꞌñgaꞌn bhaan, guiꞌ nam Niinibe oiꞌñkat xi guꞌkɨi pu tɨꞌyaꞌ am na pim maaxik pu cham tuꞌ kaꞌm tɨ nɨiꞌñ. Na guꞌ gu Niinibe oiꞌñkam kat moo janoꞌ cham jax ji chɨꞌɨɨk miꞌ puiꞌ jii mɨt na jax jix aaꞌ guñ Gɨꞌkoraꞌ na paiꞌ dhuuk puiꞌ ba tu ja aꞌgiꞌñ gu Jonaas. Baꞌ aañ nañ xib yaꞌ oirɨ aapiꞌm jam bui, jix ioꞌm jir gɇꞌkam iñ, cham tuꞌ puiꞌ na jax gu Jonaas. ");
INSERT INTO stpNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gio guiꞌ na bɨjɨk jix ioꞌm jup jir gɇꞌkam kat gu ubii na muni jaꞌk kiokat jurnip, puiꞌp xi kɨkboi puiꞌ xi chɨꞌyaꞌ na pim maaxik pu cham tuꞌ kaꞌm tɨ nɨiꞌñ. Na guꞌ guiꞌ jɨꞌ gu ubii jum dɨkooꞌñ nat mɨk dɨr bha jii nat bha kaim gu Salomoon guiꞌ na yaꞌr gɇꞌkam kat, na puiꞌ tɇ kɇɇkɇꞌ nax ioꞌm jix chu matdaꞌ kaꞌ. Baꞌ aañ nañ xib yaꞌ oirɨ aapiꞌm jam bui, jix ioꞌm jix chu matdaꞌ iñ, cham tuꞌ puiꞌ na jax gu Salomoon. ");
INSERT INTO stpNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Gu cham kɨɨꞌ iiꞌmdaꞌ noꞌt ba buus bhaan dɨr gu maaꞌnkam, ba jimiaꞌ mummɨ jaꞌp paiꞌ gampɨx jix chu gak kɨr, tu gaagidhaꞌ na pa jaꞌk jix bhaaiꞌ na kiichaꞌ. Baꞌ noꞌt cham paiꞌ ji chɨɨ nar joidham na kiichaꞌ, jup jum aaꞌndaꞌ: ");
INSERT INTO stpNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Gi noꞌ ñich moo gio muiꞌp jii mummɨ nañ paiꞌ kiokat.” Baꞌ na gio bhaan jup ba bakiaꞌ gu maaꞌnkam, joidham tɨ tɨgiaꞌ, na guꞌ jaꞌp tɨ ɨlhiiꞌñdhaꞌ na cham ka tu tanaaraꞌ kaꞌ noꞌ bax kɨɨꞌ gu maaꞌnkam. ");
INSERT INTO stpNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Baꞌ xi dhaiꞌññiaꞌ na jaiꞌp ja baiꞌñmɨraꞌ gu bɨpnagaꞌn tuutuꞌm cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ jɨꞌk xijum gook pup aixim guiꞌ nam giilhim xi chu xibua. Baꞌ nam paiꞌ dhuuk gio maap bhaiꞌp ba baapkiaꞌ bhaan gu maaꞌnkam, giilhim bhaiꞌ jim naanbichaꞌ dho gi ji baꞌ, cham tuꞌ puiꞌ kiaꞌ na jax bɨɨpɨꞌ dɨr. Baꞌ puꞌñi jaꞌk jup tu ja jimiaꞌ gu jaꞌtkam guiꞌ nam jɨꞌk cham tuꞌ kaꞌm tɨ nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Baꞌ na pui miꞌ ka tu ja aꞌgiꞌñchuꞌ gu Jesuus gu jaꞌtkam, miꞌ ba ai mɨt gu jajaaꞌnniꞌñ gio gu dɨꞌɨɨꞌn nam jix chu aꞌgidhamtuꞌ, baꞌ mummɨ jaꞌp dɨɨrap dɨr pɨx ji guguu mɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Baꞌ maadɨt mu ba aaꞌñdhim gu Jesuus, jup tɨtda: ―Muni mɨt ba ai gum jaaduñ gio gum naan. Muiꞌp sap xi jimdaꞌ nam tum aꞌgidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Baꞌp tɨtda gu Jesuus guiꞌ na miꞌ puiꞌ jɨꞌ kaiꞌch: ―Jax dhui nañ aañ cham tuꞌ puiꞌ ɨlhiiꞌñ nam dai guiꞌr jiñ jaaduñ gio na dai guiꞌr jiñ ñaan. ");
INSERT INTO stpNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Baꞌ nobiiꞌñ kɨꞌn muiꞌ xi ja aaꞌ guiꞌ nam kaichuꞌ nam mi jaꞌp daraa, jup kaiꞌch baꞌ: ―Guꞌ bɨɨx ji sia dhiꞌñi nam jɨꞌk jiñ kaichuꞌ nañ puiꞌ ja ɨlhiiꞌñ nam jir jiñ jaaduñ gio nam jir jiñ ñaan. ");
INSERT INTO stpNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Na guꞌ gu jaroiꞌ na puꞌñi miꞌ puiꞌ ba jimdaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ guiꞌ nax dhaam jup tuꞌiiꞌ, dhiꞌ puiꞌ ji buusandaꞌ na bar jiñ jaaduñ kaꞌ gio na bar jiñ ñaan kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Baꞌ moo janoꞌ pu jii gu Jesuus miꞌ dhɨr kiicham mu jaꞌk na paiꞌ gɇꞌ suuꞌnkaꞌ gu suudaiꞌ, baꞌ mi jaꞌp juꞌñdharan daakat bam jɨɨpiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Baꞌ cham jɨꞌx mɨɨkim na mɨt jix ioꞌm muiꞌ miꞌ mam jumaap gu jaꞌtkam, alh nammɨ ba xi juꞌ am. Baꞌ puiꞌ bhaiꞌ ma tɨs gu Jesuus bhaan gu gɇꞌ kanuub na mi jaꞌp jup sɇꞌ amuub suudaiꞌ jugiꞌñ, ");
INSERT INTO stpNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","bhaiꞌ baꞌ ji dhaakat ma tu ja aꞌgi gu jaꞌtkam bɨxchuꞌ bhaan ji chu uaꞌrgidhak na tuꞌ ya jaꞌp jix chu jaiꞌch dhi oiꞌñgaꞌn bhaan, jup ja tɨtda: ―Maaꞌnnim maaꞌn gu maaꞌnkam ma tu giiꞌñdham gu tiriik. ");
INSERT INTO stpNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Baꞌ nat paiꞌ dhuuk muiꞌ ji chu giiꞌ, jaiꞌ mu jaꞌk suulh na paiꞌ pɨx am boi ba katkaꞌ na mi jaꞌp tum oipodaꞌ gu tuꞌ, baꞌ maaꞌn na mɨt jax jugio gu uꞌjiꞌ nam mi jaꞌp nɨnɨꞌdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Baꞌ jaiꞌ nat jaꞌp jaꞌk iam jup suulh na paiꞌr aiꞌ chaꞌm nax komaalhim jir dɨbɨɨr, dhiꞌ dho gi guꞌ tɨi jotmodaꞌ bubua ji, nat guꞌ daaman jum yaas. ");
INSERT INTO stpNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Guꞌ ji na guꞌ nat paiꞌ dhuuk bhaan miꞌ ji chotnorimɨ, maaꞌn nat jax gaa, nat guꞌ cham tuukab takta. ");
INSERT INTO stpNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Baꞌ jaiꞌ nat jaꞌp jaꞌk iam jup suulh na paiꞌ tuutkaꞌ gu tuꞌx bii uꞌuux jix joꞌiiꞌ, maaꞌn nat jax bhaiꞌbich, jix uꞌuam miꞌ pup tuut gu tiriik, baꞌ pu cham tuꞌ ka bhaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Baꞌ jaiꞌ nat jaꞌp jaꞌk iam jup suulh na paiꞌx kɨɨꞌ gu dɨbɨɨr, dhiꞌ dho gi guꞌ joidham jix bhaiꞌm duu ji. Alh jaꞌp saꞌsbar xim kaip, jɨꞌmaꞌn moom kaip maaꞌn ooꞌm daman mambhɨɨx, jaiꞌ baꞌ baik ooꞌm, jaiꞌ jix chamaam ooꞌm, miꞌ pɨx puiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Moo pim jix bhaiꞌ xim gaꞌngadaꞌ na pim jɨꞌk jiñ kɇɇ na jax jir jum duukam gu dhiꞌ puiꞌ nañ jax jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Baꞌ puiꞌ ba tɨtda am gu noonbiꞌñ gu Jesuus na sap ja aagiꞌñdhaꞌ na jax kaiꞌñkam puiꞌ jaꞌk tu ja aꞌgiꞌñ gu jaꞌtkam na bhaan ji chu uaꞌrgidhat gu tuꞌ na yaꞌx chu jaiꞌch dhi oiꞌñgaꞌn bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Baꞌp ja tɨtda gu Jesuus: ―Matgɨm aapiꞌm saalh ka jam mattudaꞌ ji gu Dios na pim jax jaꞌk duñiaꞌ na baꞌ gammɨjɨ jam aꞌm ba tɨ nɨidhidhaꞌ, na pim guꞌ bañ kaichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Na guꞌ gu jaroiꞌ noꞌ puꞌñi tɨ jɨɨgiꞌñ, jix ioꞌm ba mattudaꞌ guñ Gɨꞌkoraꞌ, baꞌx ioꞌm bax mat kaꞌ, cham tuꞌ puiꞌ na jax bɨɨpɨꞌ dɨr. Baꞌ gu jaroiꞌ noꞌ cham maachim, sia ku tɨi palhɨɨp am jix maat, saalh puiꞌ dho cham ka tɨꞌñchokaꞌ, mɨkkat pu cham ka mat kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Puiꞌ kuñ baꞌ aañ puꞌñi pɨx jaꞌk tu ja aꞌgiꞌñ gu jaꞌtkam bɨxchuꞌ bhaan ji chu uaꞌrgidhat na tuꞌ ya jaꞌp jix chu jaiꞌch dhi oiꞌñgaꞌn bhaan, na guꞌ sia kum tɨiñ nɨiꞌñ gux bhaiꞌm duukam nañ jup tu bua, pu cham maatɨꞌ nɨiꞌñdhaꞌ am, gio baꞌ noꞌm tɨiñ kɇɇ nañ jax tu ja aꞌgiꞌñdhaꞌ, pu cham maatɨt jup jiñ kɇɇkɇꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Baꞌ dhiꞌ ja bui puiꞌ ba tum kuugalh nat jax tu uaꞌnak gu Isaiiyas guiꞌ na bɨjɨk bhaankam tu aꞌgimɨk gu Dios na jaꞌpnim kaiꞌch: Noꞌm tɨi tɇ kɇɇ, cham maatɨt kaayaꞌ am, gio noꞌm tɨi jax tɨ nɨiꞌñ, cham maatɨt tɨgiaꞌ am na jax jir jum duukam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nam guꞌ dɨɨlh cham maatɨt tɇ kɇɇkɇꞌ dhiꞌ dhi jaꞌtkam, panaas baꞌ ku jaꞌp ji buusandaꞌ nam pu cham ñiññia kaꞌ gio nam pu cham tɇ kɇɇkɇꞌ, guꞌ na baꞌ jax dhui pɨx cham bhaaiꞌn kaꞌ nam jix maatɨt tɇ kɇɇkɇꞌ, gio na cham bhaaiꞌn kaꞌ nam jix maatɨt tɨ nɨiꞌñdhaꞌ, nam baꞌ cham maatɨi miꞌ puiꞌ jimiaꞌ nañ jax jix aaꞌ, baꞌ aañ cham tuꞌp jiñ buixiꞌñdhaꞌ ja bui. ");
INSERT INTO stpNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Ku guꞌ aapiꞌm jix bhaiꞌ tu jam jim ji, na pim guꞌx maatɨt tɇ kɇɇ gio na pim jix maatɨt tɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tuꞌ sɨlhkam kɨꞌn jañ pu jam tɨtda nam muiꞌ guiꞌ nam bhaankam tu aꞌgimɨk gu Dios gio guiꞌ nam jaꞌppɨx jir jix bhabhaiꞌkam kat, pu chuꞌm tɨip jix chɨ tɨɨgik kat am na pim jax tɨ nɨiꞌñ gu xib, guꞌ ji na mɨt guꞌ cham pu chuꞌm tɨ tɨɨ, gio nam pu chuꞌm tɨip jix chɨ kaik kat na pim aapiꞌm jax tɇ kɇɇ gu xib, guꞌ ji na mɨt guꞌ cham pu chuꞌm tɨ kai. ");
INSERT INTO stpNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Ea na pim jix bhaiꞌ xiñ kaayaꞌñ jaaduñ nañ jam aagiꞌñdhaꞌ na jax jir jum duukam gu tiriik nat tu giiꞌ gu maaꞌnkam. ");
INSERT INTO stpNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jaꞌp jañ dho kaiꞌñkam jup kaiꞌch: Gu jaꞌtkam noꞌ mɨt tɨi kai gux bhaiꞌm kaiꞌchdham ñioꞌkiꞌñ gu Dios na jax jaꞌk ja aꞌm ba tɨ nɨidhidhaꞌ gɨt, noꞌ mɨt guꞌ cham maatɨt kai, dhiꞌ jaꞌp ji buusniaꞌ na jax gu tiriik nat miꞌ suulh boi chaꞌm na paiꞌx chu kabaak. Baꞌ na paiꞌ dhuuk miꞌ ji ɇɇji gu jaꞌook, maakam xi jurtudaꞌ, miꞌ pu cham tuꞌ bhaan ka tɨtɨɨꞌñchokaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Guꞌ baꞌ guiꞌ nat miꞌ jaꞌk jup suulh na paiꞌx komaalhim jir dɨbɨɨr nar aiꞌ chaꞌm, dhiꞌ guiꞌ nam jotmodaꞌ tɨi tɨ jɨɨꞌñdhaꞌ jix bhaiꞌm ɨlhdhai, ");
INSERT INTO stpNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","guꞌ ji nam guꞌ puiꞌ ji bubuakiaꞌ na jax gu tiriik nat cham tuukab takta. Baꞌ noꞌ tuꞌ jax ba ja duiñchuꞌ, mummɨ puiꞌ giop suulhgiaꞌ am, nam guꞌ cham bɨɨx ja jujur kɨꞌn tɨ jɨɨgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Baꞌ guiꞌ nat miꞌ jaꞌk jup suulh na paiꞌ tuutkaꞌ gu tuꞌx bii uꞌuux jix joꞌiiꞌ, dhiꞌ guiꞌ nam puiꞌ tɨi joidham jup kaayaꞌ, guꞌ ji na guꞌ bhaiꞌ ji ja tukgidhaꞌ gu tuꞌ na yaꞌx chu jaiꞌch dhi oiꞌñgaꞌn bhaan. Tuꞌ nam pɨx bax joiꞌñdhaꞌ nam biaꞌkaꞌ jix dhaꞌram namkɨm, piam ku tuꞌ nam pɨx jax bax dhuñiim kaꞌ na tuꞌ cham jum aagidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Baꞌ guiꞌ nat miꞌ jaꞌk jup suulh na paiꞌ joidham jix kɨɨꞌ gu dɨbɨɨr nat jum kaip jix chamaam ooꞌm, gio jaiꞌ baik ooꞌm, gio baꞌ jaiꞌ maaꞌn ooꞌm daman mambhɨɨx, dhiꞌ guiꞌ nam bɨɨx ja jujur kɨꞌn tɨ jɨɨꞌñdhai miꞌ puiꞌ ba jimiaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ, baꞌ cham jɨꞌxkat jaꞌk ka suulhgiaꞌ am, nam guꞌ gammɨjɨ buiñor bax biiñak kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Baꞌ gio bhaan jup ji uaꞌrgidhak gu tiriik bhaiꞌ ji chu ja aꞌgi gu Jesuus gu jaꞌtkam, jup ja tɨtda: ―Gu jaroiꞌ na bhaan tɨ nɨidhidhaꞌ gu Dios jaꞌp ji buusniaꞌ na jax gu jaroiꞌ noꞌt mu paiꞌ tu giiꞌ gu tiriik paiꞌ na tu gaꞌmbhar kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Baꞌ noꞌt guꞌ moo janoꞌ pu guiꞌ gu tukaaꞌ bhaan na paiꞌ dhuuk bɨɨx ka tum kookos kaꞌ, miꞌ ji ɇɇk guiꞌ nax bhaamkiꞌñ daam dɨr miꞌp xi giiꞌñdhak ba jii gu saiꞌ gu kaiꞌñ guiꞌ na cham bhaiꞌ bua gu tiriik. ");
INSERT INTO stpNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Baꞌ nat paiꞌ dhuuk bhaiꞌ ji bubua gu tiriik, gatuuk dɨr bhaiꞌp ji bubuakiaꞌ gu saiꞌ guiꞌ na cham bhaiꞌ bua. ");
INSERT INTO stpNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Baꞌ na mɨt paiꞌ dhuuk ba tɨɨ guiꞌ nam miꞌ tu juandaꞌ, mu jimɨɨk ba aagiꞌñ am guiꞌ nat miꞌ tu giiꞌ gu tiriik, jup tɨtda am: “Aapiꞌch jaduuñ, gu tiriik na pich mu tu giiꞌ, ¿saiꞌ bɨnkam aa pich miꞌ ɨi na baꞌ jaiꞌ miꞌp tuut na cham bhaiꞌ bua gu tiriik? ¿Kaꞌ jaroo ji chi miꞌ ɨi?” ");
INSERT INTO stpNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Baꞌ guiꞌ na miꞌ tu gaa jup kaiꞌch: “Jaroiꞌ dho na xiñ bhaamkiꞌñ nat baꞌ miꞌ ɨi dhiꞌ pu chuꞌm.” Baꞌ gu tujuandam tugiꞌñ ba tɨkka am, jup tɨtda am: “¿Cham jir am aa noꞌ chich boopnɨk mu baas iabu?” ");
INSERT INTO stpNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Baꞌ guiꞌ na miꞌ tu gaa jup kaiꞌch: “Cham ji nar am, na guꞌ na pim paiꞌ dhuuk bhaiꞌ ji boopñiaꞌ, bɨɨx bhaiꞌp jim takbonaꞌ gu tiriik. ");
INSERT INTO stpNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Miꞌ puiꞌ ji na ba gɨꞌlhiaꞌ bɨnkam, gatuuk baꞌ nañ paiꞌ dhuuk ba ji chu oraaꞌ nañ baꞌ tu chiñiaꞌ nam aꞌlhiok buuprai mɨidhaꞌ, dai gu tiriik jañ baꞌ tu chiñiaꞌ nam ulhñaꞌ miꞌ na paiꞌm ulhiis.” ");
INSERT INTO stpNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Baꞌ jumai bhaan ji uaꞌrgidhak gio bhaiꞌp ji chu ja aꞌgi gu Jesuus gu jaꞌtkam, jup ja tɨtda: ―Jaꞌpni jaꞌk jup ji buusan gu jaroiꞌ noꞌ bhaan ba tɨ nɨidhim gu Dios, na jax gu jaroiꞌ noꞌt mu paiꞌ ɨi gu mostaasa kai. ");
INSERT INTO stpNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Cham jax chuꞌm jaꞌxbuiꞌx jaiꞌch dho gu kaichuk na jɨꞌx jir ɨlhiꞌch guiꞌ, ku guꞌ noꞌ ñich mi jaꞌp xi ɨi, joidham gɇꞌ gɨgɨꞌr ji, cham tuꞌ jaꞌxbuiꞌ na jɨꞌx jup tɨ gɨgɨꞌr gu jaiꞌ ɨꞌɨɨx guiꞌ na puiꞌp jir jum ɨsdam. Jix bhaiꞌ nam bha jaꞌp maamragaran tu kakos kaꞌ gu uꞌjiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Baꞌ jaꞌpni jaꞌk bhaan ji uaꞌrgidhak gio bhaiꞌp ji chu ja aꞌgi gu Jesuus gu jaꞌtkam, jup ja tɨtda: ―Jaꞌpni jaꞌk jup ji buusan ɨp gu jaroiꞌ noꞌ bhaan ba tɨ nɨidhim gu Dios, na jax gu jax chuꞌm ubii noꞌt ba jip duu gu paan na palhɨɨp bɨndaꞌ guiꞌ na kɨꞌn jappukar, sia ku guꞌ tɨir gɇꞌ gu tuiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Baꞌ dhiꞌ puꞌñi jaꞌk tu ja aꞌgidhimɨk gu Jesuus gu jaꞌtkam bɨxchuꞌ bhaan ji chu uaꞌrgidhimɨk na tuꞌ ya jaꞌp jix chu jaiꞌch dhi oiꞌñgaꞌn bhaan. Dai puꞌñi jaꞌk pɨx tu ja aꞌgiꞌñdhaꞌ nam baꞌx maatɨt kaayaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Baꞌ dhiꞌ puꞌñi jaꞌk jum kuugalh gu puiꞌ nat jax jaꞌk tu uaꞌnak maadɨt guiꞌ nam bɨjɨk bhaankam tu aꞌgimɨk gu Dios, na jaꞌpnim kaiꞌch: Aañ bɨɨx aixim bhaan ji chu uaꞌrgidhai tu aꞌgaꞌ na tuꞌx maax dhi oiꞌñgaꞌn bhaan, baꞌ dhiꞌ bhaan pɨx tu aꞌgat jup kaiꞌchdhaꞌ iñ guiꞌ nam tuꞌ cham maat gu jaꞌtkam janoꞌ dɨr nat jax jup duu gu Dios dhi oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Baꞌ miꞌ dhɨr ba jii gu Jesuus xi ja ñioꞌkdhak gu jaꞌtkam, nammɨ jaꞌk gama jaꞌk ji baa baꞌk chɨr. Baꞌ guiꞌ nam kaichgɨdaꞌ miaꞌn xi ɇɇk puiꞌ ba tɨtda am na sap ja aagiꞌñdhaꞌ na jax jir jum duukam gu saiꞌ guiꞌ na cham bhaiꞌ bua gu tiriik nat baꞌ puiꞌ bhaiꞌp ji bubua miꞌ na paiꞌm giiꞌ gu tiriik. ");
INSERT INTO stpNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Baꞌ gu Jesuus jup ja tɨtda: ―Dho gu tiriik giigiꞌñdham, dhiꞌ aañ dɨɨlh jiñ aagat jup kaiꞌch, aañ nat bhañ joot guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Guꞌ baꞌ gu gaabhar, dhiꞌ gu oiꞌñgaꞌn jañ aagat jup kaiꞌch, gio baꞌ gu tiriik, dhiꞌ guiꞌ na jɨꞌk ja aꞌm ba tɨ nɨidhidhaꞌ gu Dios jañ ja aagɨt jup kaiꞌch. Guꞌ baꞌ gu saiꞌ guiꞌ na cham bhaiꞌ bua gu tiriik, dhiꞌ gu jaꞌtkam guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñ jañ ja aagɨt jup kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Guꞌ baꞌ guiꞌ nat miꞌp ɨi gu saiꞌ guiꞌ na cham bhaiꞌ bua gu tiriik, dhiꞌ gu jaꞌook jañ aagat jup kaiꞌch. Gio baꞌ gu maaꞌnkam guiꞌ na tu oraaꞌ, dhiꞌ janoꞌ tu aagɨt jup kaiꞌch iñ na paiꞌ dhuuk tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan. Baꞌ guiꞌ nañ jup ja aaꞌ nam jix bhaiꞌ dhui ba ulhñaꞌ guiꞌ na jɨꞌk jum oraaꞌ gu tiriik, dhiꞌ gu noonbiꞌñ guñ Gɨꞌkoraꞌ nañ ja aagɨt jup kaiꞌch ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Baꞌ puiꞌ na jax gu saiꞌ nam maap xi jumpadai bhaiꞌ xi kɨɨxdhaꞌ gu tai, puꞌñi jaꞌk jup tum duñiaꞌ janoꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Baꞌ aañ nat bhañ joot guñ Gɨꞌkoraꞌ, naiꞌ ja jootsaꞌ iñ gu noonbiꞌñ nam maap ja jumpadaꞌ guiꞌ nam jɨꞌk ja chiandaꞌ gu jaiꞌ jaꞌtkam nam pu tu duñiaꞌ gu tuꞌ nar jix buam jum duukam, gio baꞌ bɨɨx nam jɨꞌk jix buam tu buadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Miꞌ dhɨr baꞌ dai nam mu jaꞌk xi ja iabuꞌ na paiꞌ gammɨjɨ cham tutkɨ gu tai, baꞌ miꞌ pu tɨi suandaꞌ am gammɨjɨ na giilhim tɨix buam tu tatdaꞌkaꞌ na ja mɨidhidhaꞌ gu tai. ");
INSERT INTO stpNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Guꞌ baꞌ guiꞌ nam jɨꞌk gammɨjɨ miꞌ puiꞌ jiimdat na jax jix aaꞌ guñ Gɨꞌkoraꞌ, joidham tuꞌm jix aꞌbhar totbikdam jup jum duñiaꞌ am janoꞌ nam paiꞌ dhuuk buiñor bap tuiꞌkaꞌ, jaꞌp tuꞌm jum maaxiꞌñdhaꞌ am na jax gu tanoolh. Moo pim jix bhaiꞌ xim gaꞌngadaꞌ na pim jɨꞌk jiñ kɇɇ na jax jir jum duukam gu dhiꞌ puiꞌ nañ jax jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Baꞌ gu jaroiꞌ noꞌ bhaan tɨ nɨidhim gu Dios, jaꞌp ji buusan na jax gu jaroiꞌ noꞌt mu paiꞌ ba tɨɨ gux dhaꞌram namkɨm na mu paiꞌ ɨxchuix kaꞌ jax chuꞌm dɨrbagaran gu jaroiꞌ. Baꞌ jotmodaꞌ gio miꞌp xi ɨxchui xi dhaiꞌññiaꞌ na tu gaꞌraraꞌ gu bɨxchugaꞌn na jɨꞌk tuꞌ biaꞌkaꞌ na baꞌ kɨꞌn ba sabaꞌdaꞌ gu dɨbɨɨr miꞌ na paiꞌ ɨxchuix kaꞌ gux dhaꞌram namkɨm. ");
INSERT INTO stpNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Gu jaroiꞌ noꞌ bhaan tɨ nɨidhim gu Dios, jaꞌp ji buusan na jax maaꞌn gu maaꞌnkam noꞌ mu jaꞌp paiꞌ jimdat tu sabaꞌdaim gu joodai gux aꞌbhar jix dhaꞌram namkɨm. ");
INSERT INTO stpNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Baꞌ noꞌt maaꞌn miꞌ paiꞌ ba tɨɨ gux ioꞌm jix dhaꞌram namkɨm, xi dhaiꞌññiaꞌ na tu gaꞌraraꞌ gu bɨxchugaꞌn na jɨꞌk tuꞌ biaꞌkaꞌ na baꞌ kɨꞌn ba sabaꞌdaꞌ gu joodaix abhaar jix dhaꞌram namkɨm, na baꞌ miꞌ dhɨr jaꞌp jaꞌk gaꞌraꞌ jix dhaꞌram iam. ");
INSERT INTO stpNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Gio jaꞌpni jaꞌk jup ji busaak gu jaroiꞌ noꞌ bhaan tɨ nɨidhim gu Dios, na jax gu jaꞌtkam noꞌm mu paiꞌ tu bhia gu boptop, noꞌ mɨt muiꞌ xi bua suudaiꞌ chɨr gu gɇꞌ asaak nam bɨɨx aixim tuꞌm mim gaamuꞌ gu boptop. ");
INSERT INTO stpNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Baꞌ nam paiꞌ dhuuk suuduyaꞌ gu boptop bhaan gu gɇꞌ asaak, ba bhɨikaꞌ am guiꞌ nam miꞌ tu bhiadaꞌ mu jaꞌp juꞌñdharan gu gɇꞌ suudaiꞌ. Baꞌ mi jaꞌp daraibui xi gaamuimɨi am baalh chaꞌm dai guiꞌ na jɨꞌk jix kɨɨꞌ gu boptop, guꞌ baꞌ guiꞌ na jɨꞌk cham tuꞌ bhaiꞌ kaꞌ, mummɨ paiꞌ baas xi iabui am. ");
INSERT INTO stpNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Baꞌ puꞌñi jaꞌk jup tum duñiaꞌ janoꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan. Naiꞌ jaꞌp ji jimiaꞌ am gu noonbiꞌñ guñ Gɨꞌkoraꞌ nam ja boosgapuꞌ guiꞌ nam jɨꞌk cham tuꞌ kaꞌm tɨ nɨiꞌñdhaꞌ miꞌ dhɨr ja bui guiꞌ nam tuꞌ kaꞌm tɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Miꞌ dhɨr baꞌ dai nam mu jaꞌk xi ja iabuꞌ na paiꞌ gammɨjɨ cham tutkɨ gu tai, baꞌ miꞌ pu tɨi suandaꞌ am gammɨjɨ na giilhim jix buam tu tatdaꞌkaꞌ na ja mɨidhidhaꞌ gu tai. ");
INSERT INTO stpNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Miꞌ dhɨr baꞌ moo bhaiꞌ ba ja tɨkka gu Jesuus, jup ja tɨtda: ―¿Jix maatɨt aa pimɨt kai gu dhiꞌ puiꞌ na ñich jax tu jam aꞌgi? Baꞌ guiꞌp kaiꞌch am: ―Jix maatɨt jachich dho kai. ");
INSERT INTO stpNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Baꞌ gio muiꞌp ji ñio gu Jesuus, jup ja tɨtda: ―Noꞌ maadɨt guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios miꞌ puiꞌ ba jii na jax pɨk jaꞌk bhaan ba tɨ nɨidhidhaꞌ, jaꞌp ji buusandaꞌ na jax gu jaroiꞌ noꞌ miꞌ paiꞌ tu biaꞌ gu bɨxchugaꞌn, na guꞌ bɨɨx pɨx joidham tɨ nɨiꞌñdhaꞌ, sia ku jaiꞌ tɨir kɨklhiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Baꞌ pu jii gu Jesuus nat paiꞌ dhuuk tɨɨmo na miꞌ puꞌñi xi chu ja aꞌgidhimɨk gu jaꞌtkam bɨxchuꞌ bhaan ji chu uaꞌrgidhimɨk na tuꞌ ya jaꞌp jix chu jaiꞌch dhi oiꞌñgaꞌn bhaan, ");
INSERT INTO stpNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","mummɨ jaꞌk baꞌ ba ai nat paiꞌ pɨk jaꞌk gɨꞌɨɨr. Baꞌ miꞌ bhaiꞌp ji chu aꞌga miꞌ nam paiꞌ tu daandaꞌ gu Israel kam jaꞌtkam guiꞌ nam miꞌ oiꞌñkaꞌ janoꞌ na paiꞌ dhuuk aagix kaꞌ na cham tum juandaꞌ. Baꞌ miꞌ puiꞌ pup tuꞌiiꞌ am na mɨt ba kai na joidham jix bhaiꞌ xi bua na tu aꞌga, baꞌp jum tɨ tɨtda am: ―¿Paa chi baꞌ ji chum mamtuxdhak puiꞌ pɨk joidham jix bhaiꞌ xi bua na xi chu aꞌga dhich jaduuñ? ¿Jax moo duukat jix aichuꞌn nap tu bua gux bhaiꞌm duukam? ");
INSERT INTO stpNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Cham aa pɨn jir diꞌ nar maraaꞌn guiꞌ na uꞌuux tu jiibdat jup tu buadaꞌ gu bɨxchuꞌ, na Mariiya jir dɨꞌɨɨꞌn, nam jir jum jajaaꞌnnim gu Jakoobo, gio gu Josee, gio gu Simoon, gio baꞌ gu Juudas? ");
INSERT INTO stpNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Gio gu uꞌuub jajaaꞌnniꞌñ, ¿cham ja pɨn yaꞌ tu oiꞌdhaꞌ am aach jich bui? ¿Guꞌ jax ji chi baꞌ duukat jix chu matdaꞌ dhich jaduuñ? ");
INSERT INTO stpNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Baꞌ puiꞌ xi kaiꞌchimɨk miꞌ puiꞌ cham tuꞌ kap jum buixiꞌñ am. Baꞌp ja tɨtda gu Jesuus: ―Gu jaroiꞌ na tu aꞌgadaꞌ bhaankam gu Dios, cham kɨɨgalhiꞌñdhaꞌ am gu jaꞌtkam miꞌ nar paiꞌ kam kaꞌ, sia ji guꞌ gu miꞌ kiaꞌmiꞌñ kam. Dai noꞌr maakam jaꞌk kam nam baꞌ bɨɨx kap jix kɨɨgalhiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Baꞌ cham tuꞌ muiꞌx bhaiꞌm duukam jup tu duu gu Jesuus miꞌ na paiꞌr Nasareet, nam guꞌ cham tɨ jɨɨgiꞌñ gu miꞌ kam noꞌ moop jir diꞌ guch Xoiꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Baꞌ janoꞌ puiꞌ ba tɨ kai gu Eroodis guiꞌ na miꞌr gɇꞌkam kaꞌ Galilea na mu paiꞌ pɨx oirɨt tu ja aꞌgiꞌñ gu Jesuus gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Baꞌp ja tɨtda guiꞌ nam maap miꞌr gɇꞌgɇrkam kaꞌ: ―¿Jir diꞌ dho bak jia gu Juan jaꞌtkam bopkondam nat duadɨk giop ba bam mu dɨr koiꞌñgaꞌn tɨr? Puiꞌ ku baꞌ puiꞌ joidham jix bhaiꞌm duukam jup tu bua. ");
INSERT INTO stpNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Guꞌ nax chooꞌnnɨt jup kaiꞌch gu Eroodis, nat guꞌ bɨɨpɨꞌ dɨr tu chia nam daagɨi kuupaꞌ gu Juan buuplhixim kɨꞌn gu bapaiñum tɨtropiñ, nat tuꞌm daꞌp duu gu Erodiiyas guiꞌ nar bɨngaꞌn kat gu Piliip jaꞌnniꞌñ gu Eroodis, guꞌ ji nat guꞌ bhaiꞌ ji chɨ ɨɨx. ");
INSERT INTO stpNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Baꞌ na puiꞌ tɨi xi chɨtdadaꞌ gu Juan gu Eroodis na cham jir am na bɨɨmaꞌn tu kiokaꞌ gu Erodiiyas na guꞌ jaꞌnniꞌñ jir bɨngaꞌn, guꞌ ji nat guꞌ dai bhaiꞌ ji bhaam. ");
INSERT INTO stpNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Baꞌ cham bhaaiꞌn kaꞌ na jax dhui tu chiñiaꞌ gu Eroodis nam muꞌaaꞌ gu Juan na guꞌx ja ɨɨbhiꞌñdhaꞌ gu jaꞌtkam, nam guꞌ bɨɨx pɨx jix bhaiꞌx mat kaꞌ na gu Juan bhaankamuꞌn tu aꞌgadaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Guꞌ ji na guꞌ nat paiꞌ dhuuk jum ai nar paiꞌ dhuuk kam gu Eroodis, ma tu chia nam tu bhaidhaꞌ gu koiꞌ nam baꞌ tu jugiaꞌ. Baꞌ nam miꞌ ka tu kuaꞌ, miꞌ ba ai gu tɨyaa maraaꞌn gu Erodiiyas, baꞌ mi jaꞌp ma tɨ nɨi ja nɨiꞌñchudat gu jaꞌtkam nam miꞌp tuꞌiiꞌ. Baꞌ iam koꞌraaro gu Eroodis gu puiꞌ nat jax jaꞌk tɨ nɨi, ");
INSERT INTO stpNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","baꞌ puiꞌ ba tɨtda na makiaꞌ na tuꞌ ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Baꞌ gu tɨyaa xi mɨɨ nat tɨkkam gu dɨꞌɨɨꞌn na tuꞌ bha tañiaꞌ, baꞌ jaꞌxpɨx gio miꞌp ba ai, jup tɨtda baꞌ gu Eroodis: ―Dho aañ jix aaꞌ nap jiñ makiaꞌ jooxiaꞌ taꞌm gu maꞌooꞌn gu Juan jaꞌtkam bopkondam. ");
INSERT INTO stpNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Baꞌ naiꞌ soiꞌ jim duu gu Eroodis, giilhim jix buam jum ɨlh. Guꞌ ji nat guꞌ moo puiꞌp ba tɨɨꞌn miꞌ ja kaixdhat guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ na makiaꞌ na tuꞌ ɨlhiiꞌñdhaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","baꞌ puiꞌ ma tu joot nam ɨɨkpuꞌ gu maꞌooꞌn gu Juan mu na paiꞌ kuupkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Baꞌ jaꞌxpɨx miꞌ ba aich jamɨt jooxiaꞌ taꞌm, miꞌ xi maa mɨt gu tɨyaa. Miꞌ dhɨr baꞌ gu tɨyaa mu jaꞌk jup xi bhɨidhak gu dɨꞌɨɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Baꞌ na mɨt puiꞌ ba tɨ kai gu jaꞌtkam tugiꞌñ gu Juan na mɨt ba mua, muiꞌ ma jii mɨt na mɨt bhɨim gu tukgaꞌn nam baꞌ yaaspaꞌ. Miꞌ dhɨr baꞌ mu jaꞌk jup bhɨi mɨt na paiꞌ oirɨ gu Jesuus na mɨt aaꞌñdham na mɨt ba mua gu Juan jaꞌtkam bopkondam. ");
INSERT INTO stpNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Baꞌ pu jii gu Jesuus nat paiꞌ dhuuk puiꞌ ba tɨ kai na mɨt ba mua gu Juan jaꞌtkam bopkondam, baasɨꞌn dɨr jaꞌk pu bhɨi na paiꞌr gampɨx kaꞌ na cham jaroiꞌ oirɨdaꞌ, dai nat jax bha tɨs bhaan gu gɇꞌ kanuub na mi jaꞌp jup sɇꞌ amuub suudaiꞌ jugiiꞌñ. Baꞌ na mɨt ba maat gu jaꞌtkam guiꞌ nam mi jaꞌp oiꞌñkaꞌ jɨꞌdɨlh kikcham nat pa jaꞌk bhɨi gu Jesuus, bhammɨ dɨr jaꞌp gakoolh jamɨt ji bhɨɨk bɨɨx dɨbɨɨr taꞌm bhammɨ dɨr ba dar bɨɨpɨꞌ dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Baꞌ nat paiꞌ dhuuk bhammɨ dɨr ba ai gu Jesuus, nat jax muiꞌ ji chɨm bhaiꞌ dhɨr bhaan gu gɇꞌ kanuub, bhaiꞌ pɨx ji ja tɨɨ gu jaꞌtkam nam jix ioꞌm muiꞌ nammɨ juꞌ nam bhaiꞌp tuꞌiiꞌ juꞌñdharan gu gɇꞌ suudaiꞌ. Baꞌx joiꞌmdak ba ja tɨɨ, baꞌ bhaiꞌ ji ja duduaꞌñ gux kakoꞌkkam guiꞌ nam ja uaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Baꞌ jaꞌxpɨx nat paiꞌ dhuuk ba ji jur, mu jimɨɨk jup tɨtda am gu Jesuus gu noonbiꞌñ: ―Yaꞌ ba ji jur jich jaduuñ. ¿Jax jach jich dhuñiaꞌ, na guꞌ ya jaꞌp jir gampɨx? ¿Cham jir am aa nap ba ja jootsaꞌ dhi jaꞌtkam kum ba jimiaꞌ mu jaꞌp paiꞌ nar kikcham kum ba tu taañpuꞌ gu tuꞌ nam jugiaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Baꞌ gu Jesuus jup ja tɨtda: ―Yaaꞌ pim dho ka tu ja makiaꞌ aapiꞌm, ¿tuꞌ gi pɨk ɨp? Cham jum aaꞌ nam moop jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Baꞌ guiꞌp kaiꞌch am: ―¿Tuꞌch gip ja makiaꞌ, nach guꞌ cham tuꞌ uaꞌ gu tuꞌ koiꞌ? Dai siamri jɨꞌk jix chamaam gu paan muni paiꞌ pɨx uaꞌ maadɨt, gio baꞌ gook gu boptop. ");
INSERT INTO stpNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Baꞌp ja tɨtda gu Jesuus: ―Dhiiꞌ dho kɨꞌn ba kokbaꞌn am. ¡Ka gor bhañ uꞌiiꞌñ! ");
INSERT INTO stpNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Baꞌ xi ja chia gu jaꞌtkam nam mi jaꞌp xi dharaibuꞌ saiꞌ dhaam, baꞌ xi dhaagɨk gu paan jix dhaam jaꞌk xi chɨ tɨɨgɨk xi chu taxchaabgi buiñor gu Dios. Miꞌ dhɨr baꞌ dai nat pɨx taꞌtak muiꞌ ji ja maa gu noonbiꞌñ, guiꞌ baꞌ miꞌ dhɨr pɨx mu jaꞌk jup ji ja maa mɨt gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Baꞌ bɨɨx tu juu mɨt nam jɨꞌk miꞌp tuꞌiiꞌ, sia kum guꞌx ioꞌm tɨir muiꞌ, tu koiꞌmɨk am nam jɨꞌx ɨlhiiꞌñ. Jaiꞌ mɨt pu cham ka jugio. Puiꞌ mɨt giop ma tu jumaap nat jɨꞌk bii, mambhɨɨx daman gook bapaalh dho moo giop suusuꞌn gu paan. ");
INSERT INTO stpNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Baꞌ bɨɨx dhiꞌ na mɨt jɨꞌk miꞌ tu juu gu jaꞌtkam, aix am jix chamaam mambhɨɨx jix chaꞌtmam ooꞌm (5000) gu dai chichioꞌñ, gu uꞌuub guꞌ cham aagix kam ji gam aꞌaalh. ");
INSERT INTO stpNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Miꞌ dhɨr baꞌ dai nat ba ja chia gu Jesuus gu noonbiꞌñ nam bha tɨɨsdiaꞌ bhaan gu gɇꞌ kanuub, bɨɨpɨꞌ baꞌ gamaiꞌ xi ja joot nam bhammɨ dɨr ba aayaꞌ baasɨꞌn dɨr jaꞌk jumai juꞌñdharan gu gɇꞌ suudaiꞌ. Dɨɨlh baꞌ miꞌ pup oirɨ, na guꞌ mi jaꞌp ka tabuimgiꞌñ gu muiꞌ jaꞌtkam nam miꞌp tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jaꞌxpɨx baꞌ nat paiꞌ dhuuk bɨɨx xi ja tabuimgidhak, pu jii maaꞌn kap na paiꞌr oidhaꞌ taꞌm bhammɨ na paiꞌ cham jaroiꞌ oirɨdaꞌ nat ba tu daañim buiñor guch Gɨꞌkoraꞌ. Dɨɨlh baꞌ bhaiꞌ pu tu daan, sia ku bax chukgam. ");
INSERT INTO stpNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Baꞌ gu noonbiꞌñ jiim am gammɨjɨ bɨɨx suudaiꞌ dhaam bhaan gu gɇꞌ kanuub. Baꞌ na mɨt jix ioꞌm mɨk ba bhɨi nammɨ paiꞌ na bar ɨrban gu gɇꞌ suudaiꞌ, jix ioꞌm bhaiꞌ ji jɨb mu dɨr jaꞌk nam paiꞌ jaꞌk jiim, baꞌ bhaiꞌ ji giꞌndukɨ gu suudaiꞌ, naiꞌ tɇꞌkob ba baapmigim gu gɇꞌ kanuub. ");
INSERT INTO stpNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Baꞌ nammɨ na paiꞌ bar katukgab, muiꞌ ma jii gu Jesuus, bhammɨ dɨr pɨx chuꞌm duu naiꞌ gu bɨɨx aꞌnsap, mummɨ baꞌ ba ai ɨp gio juꞌñdharan na paiꞌ gɇꞌ suuꞌnkaꞌ gu suudaiꞌ. Miꞌ dhɨr baꞌ gamaiꞌ bɨɨx suudaiꞌ dhaam pɨx chuꞌm duu nat ba jii mu jaꞌk nam paiꞌ jiim gu noonbiꞌñ bhaan gu gɇꞌ kanuub. ");
INSERT INTO stpNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Baꞌ nat mi jaꞌp jupaaban ji bhɨi nam paiꞌ jiim gu noonbiꞌñ, ba tɨɨ mɨt gu Jesuus na mi jaꞌp ba jim suudaiꞌ dhaam. Baꞌx chotdonɨt gɇꞌgɇr kɨꞌn ba jiiñ jamɨt, jup kaiꞌch am: ―¡Kani gu tuꞌ mi jaꞌp ba jim! ");
INSERT INTO stpNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Guꞌ ji nat guꞌ jotmodaꞌ mu ñio gu Jesuus, jup ja tɨtda: ―Chaꞌpim totdon kaꞌ. Aañiꞌ pɨx jup tuiꞌdhiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Baꞌ muiꞌ ji ñio gu Peegro, jup kaiꞌch: ―Noꞌp baabuiꞌ sɨlhkam aap jir diꞌñ jaduuñ, puiꞌp xi chɨꞌyaꞌ nañ aañ yaꞌ dɨr muiꞌ xi jimiaꞌ bɨɨx suudaiꞌ dhaam miꞌ nap paiꞌ dhɨr bha jim. ");
INSERT INTO stpNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Baꞌ gu Jesuus jup tɨtda: ―Dho kap bhaiꞌ xi jim. Baꞌ gu Peegro nat jax jup tɨm bhaiꞌ dhɨr bhaan gu gɇꞌ kanuub, gamaiꞌ pɨx chuꞌp jum duu bɨɨx suudaiꞌ dhaam mu jaꞌk na paiꞌ dhɨr bha jim gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Guꞌ ji nat guꞌ gama jaꞌk bhaiꞌ ji chooꞌn, na guꞌx ɨɨbhidhat nɨiꞌñ gu suudaiꞌ na bha sɨlh guꞌnguk. Baꞌ miꞌ gamaiꞌ ba ji baa gu Peegro, jup tɨtda gu Jesuus gɇꞌ kɨꞌn: ―¡Xiñ dhaaꞌñ jaduuñ! ");
INSERT INTO stpNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Baꞌ gu Jesuus jotmodaꞌ xi dhaa ɨp, jup tɨtda baꞌ: ―¿Jax ku pich baꞌ dai ba ji chooꞌn? ¿Moo chakui bɨɨx jum jur kɨꞌn tɨ jɨɨgiꞌñ ap aa aañ jiñ bui? ");
INSERT INTO stpNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Baꞌ jaꞌxpɨx bhaiꞌ ba tɨɨtɨs jamɨt bhaan gu gɇꞌ kanuub, baꞌ jotmodaꞌ naiꞌ pɨx ji kɨkbo gu jɨbɨɨlh na jix ioꞌm bhaiꞌ ka jɨbɨɨrdat. ");
INSERT INTO stpNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Baꞌ guiꞌ nam jɨꞌk bha jiim bhaan gu gɇꞌ kanuub, jotmodaꞌ mi jaꞌp ja oꞌlhia kɨꞌn guꞌkɨk jup tɨtda am gu Jesuus: ―Tuꞌ sɨlhkam ji bak aap jir diꞌ gu Dios gu Maraaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Baꞌ jaꞌxpɨx bhammɨ dɨr ba tɨɨtɨs jamɨt na paiꞌ Genesareet bhaan bipioꞌ gu dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Baꞌ gu jaꞌtkam guiꞌ nam bhaiꞌ oiꞌñkaꞌ jix maatɨt tɨɨ mɨt na maadɨt jir diꞌ gu Jesuus, baꞌ jotmodaꞌ naiꞌ xi boop jamɨt mɨjɨ jaꞌp kikcham guiꞌ na dhiꞌ pɨx bhaan jup bipioꞌ gu dɨbɨɨr na mɨt tu aagam nat bhaiꞌ ba ai gu Jesuus. Baꞌ cham jɨꞌx mɨɨkim jix ioꞌm muiꞌ bhaiꞌ ba aichulh jamɨt gu Jesuus gux kakoꞌk kam, ");
INSERT INTO stpNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","baꞌ soiꞌ ba tɨtdaim am nam sap palhɨɨp bhaiꞌ xi dhagiaꞌ gu jannulhiꞌñ nam baꞌ ba duduadhiaꞌ. Baꞌ na mɨt paiꞌ dhuuk bhaiꞌ xi dhaa, pu dudua mɨt, bɨɨx jamɨt dho guꞌx kɨkɨɨꞌp jum duu. ");
INSERT INTO stpNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Baꞌ janoꞌ jɨꞌkchi miꞌp ba ji bubua mɨt buiñor gu Jesuus bhammɨ dɨr jaꞌk Jerusaleen guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, baꞌx bhaakut bhaiꞌ ba tɨkka am gu Jesuus, jup kaiꞌch am: ");
INSERT INTO stpNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Jax kum baꞌ cham miꞌ puiꞌ ka jiim dhim jaꞌtkam tuk gu puiꞌ nam jax jaꞌk tu jimdat guch bopxi kat? Tɨɨꞌ na mɨt cham muiꞌ kim jum ikoimdhak ba ji chu juu. ");
INSERT INTO stpNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Baꞌp ja tɨtda gu Jesuus: ―Dho puiꞌ na jax aapiꞌm na pim guꞌ cham miꞌ puiꞌ jiim na jax jaꞌk tu daaxix gu ñioꞌkiꞌñ gu Dios, dai dɨɨlh na pim jax ɨlhiiꞌñ na pim baꞌ pu tu bua. Guꞌ na jax pɨk jaꞌk jum kaiꞌch gu ñioꞌkiꞌñ gu Dios, pu cham ji na pim miꞌ puiꞌ jiim. ");
INSERT INTO stpNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Puiꞌ na jax maaꞌn kap na jaꞌpni tɨi tu uaꞌñix gu ñioꞌkiꞌñ gu Dios: “Tuꞌ kaꞌm jap nɨidhat gum taat gio gum naan.” Gio baꞌ moo jaꞌpnip jum kaiꞌch ɨp: “Gu jaroiꞌ na cham tuꞌ kaꞌm nɨiꞌñdhaꞌ gu taataꞌn gio gu dɨꞌɨɨꞌn, am tɨꞌñchokaꞌ na joodai kɨꞌn maiꞌyaxix kam muukix kaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Guꞌ ji na pim guꞌ aapiꞌm maakam ja tɨtdadaꞌ gu jaꞌtkam na jax cham puiꞌ jaꞌk tu daaxix gu ñioꞌkiꞌñ gu Dios, na pim puiꞌ ja tɨtdadaꞌ na cham kam aaꞌ gu jaroiꞌ na palhbuiꞌñdhaꞌ gu taataꞌn piam gu dɨꞌɨɨꞌn, dai sap na jaꞌpni pɨx xi chɨɨdai: “Jaꞌp moo cham jax kax bhaaiꞌ ji guꞌ nañ jax dhuim palhbuidhaꞌ, na ñich guꞌ puiꞌ ba tɨɨꞌn gu Dios nañ bɨɨx mu tuꞌaaꞌ chiop gu tuꞌ nañ jɨꞌk biaꞌkaꞌ. Cham jax kax bhaaiꞌ nañ jax dhuim taiñbuidhaꞌ, sia ku jaꞌp moo tɨim aꞌm jum aaꞌ.” Jaiñ na pim guꞌ maakam ja aagiꞌñdhaꞌ gu jaꞌtkam, guꞌ baꞌ gu puiꞌ na jax pɨk jaꞌk tu daaxix gu ñioꞌkiꞌñ gu Dios, bɨɨx jaꞌp xi dhuukat japim, dɨɨlh japim baꞌ pu tu bua na pim jax ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bak guꞌr puiꞌ nat jax jaꞌk tu uaꞌnak gu Isaiiyas guiꞌ na bɨjɨk bhaankam tu aꞌgimɨk gu Dios na aapiꞌm jam aagɨt jup kaiꞌch, na jaꞌpnim kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Dhi jaꞌtkam puiꞌ tɨi xi kaiꞌchdhaꞌ am nam sap aañ jiñ bui tu daan, guꞌ ji nam guꞌ cham tuꞌ aañ jiñ bui jujurtɨkat jup kaiꞌchdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","¿Tuꞌm gi miꞌp tɨgiaꞌ sia kum bɨɨx aixim tɨi tu jim? Na guꞌ dai nam jax pɨx jaꞌk ja aagiꞌñdhaꞌ gu jaꞌtkam nam baꞌ pu tu bua. ");
INSERT INTO stpNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Baꞌ puiꞌ xi chɨꞌɨɨk bɨɨx maap xi ja jumpadak gu jaꞌtkam gu Jesuus, jup ja tɨtda: ―Ka na pim moox bhaiꞌ xiñ kaayaꞌñ jaaduñ nañ jax jam tɨɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jax dhui na moo cham tuꞌ xidhuu gu tuꞌ koiꞌ noꞌ moo tu kuaꞌ pɨx gu jaroiꞌ. Guꞌ ji noꞌ giilhim kaiꞌch na jax cham jir am na baꞌ puiꞌm kaiꞌch nax xidhuu, na guꞌr uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Baꞌ guiꞌ nam jɨꞌk kaichuꞌ miaꞌn xi ɇɇk jup tɨtda am gu Jesuus: ―¿Jix maat ap aa na mɨt giilhim bhaak gu pariseos na mɨt jum kai gu dhiꞌ puiꞌ jɨꞌ na pich jax tu aꞌga? ");
INSERT INTO stpNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Baꞌp ja tɨtda gu Jesuus: ―¿Dho jax gip bua? Na guꞌ gu ɨꞌɨɨx guiꞌ nat cham ya ɨꞌxcha guñ Gɨꞌkoraꞌ, jix bhaaiꞌ na takbonai mu baas buaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Chaꞌpim jax jum aagɨt ja nɨiꞌñdhaꞌ dhiꞌ dhi jaꞌtkam, nam guꞌ dhiꞌ jaꞌp pɨx ji buan na jax gu cham ñiññia kam nam ja baiꞌñchuꞌ gu jaiꞌ cham ñiññia kam. Baꞌ gu jax chuꞌm cham ñia kam noꞌ tɨi baiꞌñchuꞌ gu jumai cham ñia kam, maap jam dho miꞌ paiꞌ suulhgiaꞌ jax chuꞌm tɨ dɨꞌn kɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Baꞌ gu Peegro puiꞌ ba tɨtda gu Jesuus na sap ja aagiꞌñdhaꞌ na jax jir jum duukam gu puiꞌ nat jax jaꞌk tu ja aꞌgi bɨɨpɨꞌ dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Baꞌp ja tɨtda gu Jesuus: ―¿Kux aapiꞌm aa puiꞌ cham maatɨt jup jiñ kɇɇ nañ jax kaiꞌñkam jup kaiꞌch? ");
INSERT INTO stpNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Jaꞌp jañ dho kaiꞌñkam jup kaiꞌch: Na cham xidhuu gu tuꞌ koiꞌ noꞌ moo tu kuaꞌ pɨx gu jaroiꞌ, na guꞌ sɨlh bhɨɨyaꞌ bookaran jaꞌk, miꞌ dhɨr gatuuk dai na giop ba buusniaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Guꞌ jaꞌpji noꞌ giilhim kaiꞌch ji gu maaꞌnkam na jax cham jir am na baꞌ puiꞌm kaiꞌch nax xidhuu, na guꞌr uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Na guꞌ ja jujur am dɨr bhaan gu jaꞌtkam nam gɨgɨꞌlhiꞌñ gux buam jum duukam, puiꞌ na jax gu jaꞌtkam nam jix ja koodam kaꞌ, gio guiꞌ nam jaiꞌ ja biaꞌkaꞌ gu uꞌuub sia kum tɨi tɨ bɨpnaꞌ, gio guiꞌ nam jir ganaiꞌ pɨx kaꞌ, gio baꞌ guiꞌ nam tɨ ɨɨxiꞌñdhaꞌ, gio baꞌ guiꞌ nam iatdaꞌ, gio guiꞌ nam giilhim ja tɨtdadaꞌ gu jaꞌtkam na jax cham jir am. ");
INSERT INTO stpNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dhiꞌ jɨꞌ na baꞌ puiꞌm kaiꞌch nax xidhuu, na guꞌr uaꞌtulhdharaꞌ noꞌm pu tu bua. Guꞌ gu koiꞌ pɨx noꞌm tu kuaꞌ, chaam ji nax xidhuu, sia ku mɨt cham muiꞌ kim jum ikoimdhak tu juu. ");
INSERT INTO stpNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Miꞌ dhɨr baꞌ ma jii gu Jesuus mu jaꞌk na paiꞌ bhaan bipioꞌ gu Tiiro dɨbɨɨr gio baꞌ guiꞌ na bhaan jup bipioꞌ gu Sidoon. ");
INSERT INTO stpNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Baꞌ maaꞌn miꞌ ba jimchuꞌ gu ubii guiꞌ na pur miꞌ kam kaꞌ, baꞌ soiꞌm ɨlhdhat suakɨt jup tɨtda gɇꞌ kɨꞌn gu Jesuus: ―Aapiꞌñ jaduuñ nap jir boxiiꞌñ gu Dabii, iam jap jix joiꞌmdai xiñ chɨɨgɨi xi dhuaꞌñdharai guñ maraax na ampɨx puiꞌx ñaanbiꞌ kaꞌ na bhaan jup tuꞌiiꞌ gu cham kɨɨꞌ iiꞌmdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Baꞌ gu Jesuus cham tuꞌp jum buixiꞌñ sia ku jax kaiꞌch gu ubii. Baꞌp tɨtda am gu noonbiꞌñ: ―Mu xi jootos dhi ubii ku mu ba jimiaꞌ. Bha jaꞌk jix oodam kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Baꞌp ja tɨtda gu Jesuus: ―Dho guꞌ aañ gu Dios bhañ joot ji nañ bha ja gaaꞌmɨraꞌ dai guiꞌ nam jɨꞌk jir Israel kam jaꞌtkam nam jaꞌp ji buan na jax gu kakasnir noꞌm maiꞌ suulhgix. ");
INSERT INTO stpNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Guꞌ ji nat guꞌ gu ubii jix ioꞌm miaꞌn xi ɇɇk mi jaꞌp oꞌlhiaꞌn kɨꞌn xi kɨkbok jup tɨtda gu Jesuus: ―Noꞌ pich gi moo iam duaꞌñ guñ maraax. ");
INSERT INTO stpNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Guꞌ ji na guꞌp tɨtda pɨx gu Jesuus: ―Jaꞌpji na guꞌ cham jir am noꞌ ñich tɨip xi dhuaꞌñ gum maraax jiñ jaduuñ, na guꞌ bɨɨpɨꞌ aagix gu Israel kam jaꞌtkam nañ jix bhaiꞌ ja duñiaꞌ. Na guꞌ noꞌ ñich aap bɨɨpɨꞌ jix bhaiꞌm duu, jaꞌp ji buusniaꞌ na jax gu aꞌaalh noꞌm mu paiꞌ ka tu kuaꞌ gu tuꞌ noꞌ ñich miꞌ dhɨr ja boppoidhak mu jaꞌk xi ja maa gu goꞌngox. ");
INSERT INTO stpNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Baꞌp kaiꞌch ɨp gio gu ubii: ―Dho guꞌr puiꞌ dat dho jia tɨiñ jaduuñ, guꞌ pɨx ji nañ guꞌ aañ soiꞌñ ɨlhiiꞌñ. ¿Cham aa guꞌ cham jax jup bua noꞌp moo xiñ joiꞌmdaip jiñ chɨgiaꞌ gɨt? Na guꞌ jaꞌp ji buusniaꞌ na jax gu goꞌngox noꞌm miꞌ paiꞌ tɨ tɨɨtɨb gu biimñigaꞌn gu koiꞌ na iigɨsdaꞌ nam tu kuaꞌdaꞌ guiꞌ nam jaroiꞌr ja goꞌngoxiꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Baꞌp tɨtda ɨp gio gu Jesuus: ―Aa guꞌ moo jaꞌp tuꞌ sɨlhkam soiꞌm ɨlhiiꞌñ ap ji jiañ jaduuñ. Ea ku gi na moo puiꞌ tu tuiꞌkaꞌ nap jax kaiꞌch. Baꞌ moo janoꞌ nat jax puiꞌ jɨꞌ tɨi gu Jesuus, jix kɨɨꞌp jum duu gu tɨɨyax, pu dua na kax ñaanbiꞌ kat na bhaan jup tuiꞌñgɨt gu cham kɨɨꞌ iiꞌmdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Baꞌ miꞌ dhɨr giop ba jii gu Jesuus mu jaꞌk juꞌñdharan na paiꞌ gɇꞌ suuꞌnkaꞌ gu suudaiꞌ na Galilea bhaan bipioꞌ. Baꞌ maaꞌn kap oidhaꞌ daam xi jimɨɨk bha jaꞌp bam jɨɨpiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Baꞌ cham jɨꞌx mɨɨkim muiꞌ gu jaꞌtkam pɨx jaꞌx ji ai mɨt miꞌ na paiꞌp tuꞌiiꞌ ji ja uaꞌdat am gux kakoꞌk kam, puiꞌ na jax guiꞌ nam jix mamaꞌmkulhiꞌ kaꞌ nam cham tu oipodaꞌ, gio guiꞌ nam cham ñiññia kaꞌ, gio baꞌ guiꞌ nam jix mumuuk tu noonob kaꞌ, gio guiꞌ nam cham tu ñiokdaꞌ, gio baꞌ jaiꞌ muiꞌ guiꞌ na bɨɨx aixim tuꞌm ja ɇɇkaꞌ gu koꞌkdaiꞌ. Baꞌ bɨɨx ja duduaꞌñ gu Jesuus, jix kɨkɨɨꞌ mɨt jup jum duu. ");
INSERT INTO stpNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Baꞌ gu jaꞌtkam nam jɨꞌk miꞌp tuꞌiiꞌ, miꞌ puiꞌ pup tuꞌiiꞌ am na mɨt ja tɨɨ na mɨt bhaiꞌ ji chu ñiokcha guiꞌ nam cham tu ñiokdat, gio guiꞌ nam jix muuk tu noonob kat na mɨt jix kɨkɨɨꞌp jum duu, gio guiꞌ nam jix mamaꞌmkulhiꞌ kat nam cham tu oipodat, gio guiꞌ nam cham ñiññia kat. Baꞌ bɨɨx dhɨt bhaiꞌ ji chu daanɨ mɨt buiñor gu Dios, nam guꞌx bhaiꞌm taat gu dhiꞌ puiꞌ jɨꞌ na mɨt jax tɨ tɨɨ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Baꞌ ba ja bai gu Jesuus gu noonbiꞌñ, jup ja tɨtda: ―Jix joiꞌmdat ja nɨiꞌñ iñ dhi jaꞌtkam, na guꞌ cham jaiꞌch nam tuꞌ ka jugiaꞌ, na mɨt guꞌ baik tanoolh yaꞌ ba juruuñ aañ jiñ bui. Gio guꞌ cham jup jir am noꞌ ñich tɨip xi ja joot nam ba jimiaꞌ ja kiꞌaam jaꞌk, nam guꞌ mu paiꞌ tu kaamui miꞌ pup bɨtkaꞌ boi chaꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Baꞌp tɨtda am gu noonbiꞌñ: ―¿Dho tuꞌch gip ja makiaꞌ aach yaꞌ, nach guꞌ cham gɇꞌ uaꞌ gu koiꞌ? Gio guꞌ ya jaꞌp jir gampɨx, ¿paach gip tu tañiaꞌ? Gio guꞌr muiꞌ am dhi jaꞌtkam, cham tuꞌ tuꞌr gook alh am. ");
INSERT INTO stpNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Baꞌp ja tɨtda gu Jesuus: ―¿Guꞌ aapiꞌm jɨꞌk pɨx uaꞌ gu paan na pim saak uaꞌ? Baꞌ guiꞌp tɨtda am: ―Dho xijum gook dho pɨx, gio baꞌ jɨꞌkchi ɨp gu boptop. ");
INSERT INTO stpNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Baꞌ xi ja chia nam pu ja tɨɨdaꞌ gu jaꞌtkam nam mi jaꞌp xi dharaibuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Miꞌ dhɨr baꞌ dai nat xi dhaagɨk gu xijum gook gu paan gio baꞌ gu boptop, jix dhaam jaꞌk xi chɨ tɨɨgɨk xi chu taxchaabgi buiñor gu Dios. Miꞌ dhɨr baꞌ dai nat pɨx muiꞌ ji ja maa taꞌtak gu noonbiꞌñ, guiꞌ baꞌ miꞌ dhɨr mu jaꞌk pɨx muiꞌp ji ja maa mɨt gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Baꞌ bɨɨx tu juu mɨt nam jɨꞌk miꞌp tuꞌiiꞌ sia kum jix ioꞌm tɨir muiꞌ, tu koiꞌmɨk am nam jɨꞌx ɨlhiiꞌñ, jaiꞌ mɨt pu cham ka jugio. Baꞌ puiꞌ giop ma tu jumaap jamɨt gu taꞌtak gaꞌn nat bii, xijum gook bapaalh dho moo giop suusuꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Baꞌ bɨɨx dhiꞌ na mɨt jɨꞌk miꞌ tu juu gu jaꞌtkam, aixim am maakob mambhɨɨx jix chaꞌtmam ooꞌm (4000) gu dai chichioꞌñ, gu uꞌuub guꞌ cham aagix kam ji gam aꞌaalh. ");
INSERT INTO stpNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Baꞌ daipuꞌ nat miꞌ puiꞌ xi chu ja maakak gu Jesuus gu muiꞌ jaꞌtkam, pu jii xi ja ñioꞌkdhak, dai nat jax bha tɨs bhaan gu gɇꞌ kanuub na mi jaꞌp jup sɇꞌ amuub suudaiꞌ jugiiꞌñ, sɨlh bhɨi mu jaꞌk na paiꞌ bhaan bipioꞌ gu Magdaala dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Baꞌ jɨꞌkchi mummɨp ba ji bubua mɨt buiñor gu Jesuus guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ gio baꞌ guiꞌ nam saduseos jup jum tɨɨtɨꞌndaꞌ. Baꞌ tɨi bax aaꞌ am na ja nɨiꞌñchudat jup duñiaꞌ gɨt gu tuꞌ nar jix bhaiꞌm duukam, guꞌ nam jax dhui pɨx jix maiꞌchim noꞌt sap moo baabuiꞌ sɨlhkam Dios bha joot. ");
INSERT INTO stpNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Guꞌ ji na guꞌp ja tɨtda pɨx gu Jesuus: ―¿Guꞌ jax dhuukat jix mat kaꞌ pim na jax chuꞌm oidhaꞌ jimiidhaꞌ na pim baꞌ guꞌp kaiꞌchdhaꞌ paiꞌjɨ jax chuꞌm jurnɨk: “Xib moox kɨɨꞌ oidhaꞌ jimiim, tɨɨꞌ na guꞌx bɨꞌm maaxiꞌñ gux dhaam”? ");
INSERT INTO stpNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Gio baꞌ moop kaiꞌchdhaꞌ pim ɨp paiꞌjɨ jax chuꞌm kabuimuk: “Xib moo cham kɨɨꞌ oidhaꞌ jimiim. Jaiñ na guꞌx bɨꞌm maaxiꞌñ gux dhaam gio nax chɨbaaꞌ.” ¿Guꞌ baꞌ cham puꞌñix maatɨt jup jiñ ñɨiꞌñ japim aa aañ nañ jir tuꞌp tuꞌm daꞌ? Tɨɨꞌ na pim baꞌ guꞌx maatɨt nɨiꞌñdhaꞌ gu tuꞌ na jax chuꞌm oidhaꞌ jimiidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Pu chuutuꞌm gu jaꞌtkam nam cham tuꞌ kaꞌm tɨ nɨiꞌñ, aañ cham tuꞌ ja tɨɨꞌñchudaꞌ gux kɨɨꞌp jum duukam, sia kum bhaiꞌ tɨi aaꞌ. Dai gatuuk nam jiñ chɨgiaꞌ nañ iampɨx puiꞌ jaꞌk jup jiñ dhuñiaꞌ na jax gu Jonaas. Baꞌ daipuꞌ xi ja tɨɨdak pu jii. ");
INSERT INTO stpNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Baꞌ na mɨt paiꞌ dhuuk miꞌ dhɨr ba jii baasɨꞌn dɨr jaꞌk jumai juꞌñdharan gu gɇꞌ suudaiꞌ, cham ka tɨꞌñcho am gu paan gu noonbiꞌñ gu Jesuus nam gɨt xi gaamui nam mu paiꞌ ba jugiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Baꞌ tu ja aꞌgidhim gu Jesuus gu noonbiꞌñ, jup ja tɨtdaim: ―Moo pim cham ja kɇkɇɇdaꞌ guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ gio guiꞌ nam saduseos jup jum tɨɨtɨꞌndaꞌ, nam guꞌ joidham jix bhaiꞌ xi buadaꞌ nam tu aꞌgadaꞌ, jaꞌp ji buusan na jax guiꞌ na kɨꞌn jappukar gu paan na giilhim jix chu iaꞌñdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Baꞌ gu noonbiꞌñ gu Jesuus dai paan bhaan jup tu aꞌgim am, jup kaiꞌchim am: ―Bak guꞌ cham bhaiꞌ xi gaamuk jachich gu paan nach mu paiꞌ ba jugiaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Baꞌ ba ja kai gu Jesuus nam jax kaiꞌchim, baꞌp ja tɨtda: ―¿Jax ku pim baꞌ moox buam jup bam aaꞌntuꞌ gu tuꞌ paan na pim cham uaꞌ? ¿Moo chakui bɨɨx jam jujur kɨꞌn tɨ jɨɨgiꞌñ japim aa aañ jiñ bui nañ aañ jir gɇꞌkam? ");
INSERT INTO stpNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Chakui aa pim maatɨt jiñ ñɨiꞌñ nañ jir tuꞌp tuꞌm daꞌ? ¿Cham aa pim tɨꞌñcho na ñich aañ muiꞌdhalh gu paan gux chamaam na ñich tu ja maa gu muiꞌ jaꞌtkam aixkam jix chamaam mambhɨɨx jix chaꞌtmam ooꞌm? Na mɨt jaiꞌ cham ka jugio bo na pimɨt baꞌ aapiꞌm giop ma tu jumaap bapaalh chaꞌm. ¿Cham aa pim tɨꞌñcho na pimɨt jɨꞌk ja susduiꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Gio baꞌ gatuuk na ñich giop muiꞌdhalh gu xijum gook gu paan na ñich giop tu ja maa bo gu jaꞌtkam gu maakob mambhɨɨx jix chaꞌtmam ooꞌm aixkam, baꞌ jaiꞌ puiꞌ cham jup ka jugio mɨt, baꞌ aapiꞌm giop ma tu jumaap bapaalh chaꞌm. ¿Cham aa pim tɨꞌñcho na pimɨt jɨꞌk giop ja susduiꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Guꞌ jax ji ku pim baꞌ cham maatɨt jiñ kɇɇ nañ aañ cham tuꞌ paan aagidhat jup kaiꞌchim? Guꞌ jaꞌpji guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ ji gio baꞌ guiꞌ nam saduseos jup jum tɨɨtɨꞌndaꞌ nañ ja aagɨt jup kaiꞌchim na pim cham mi ja kɇkɇɇdaꞌ, nam guꞌ joidham jix bhaiꞌ xi buadaꞌ nam paiꞌ dhuuk tu aꞌgadaꞌ, jaꞌp ji buusan na jax guiꞌ na kɨꞌn jappukar gu paan na giilhim jix chu iaꞌñdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Baꞌx maatɨt ba kai mɨt gu Jesuus na cham tuꞌ guiꞌ aagɨt jup kaiꞌch na kɨꞌn jappukar gu paan, guꞌ jaꞌpji guiꞌ ji nam pariseos jum tɨɨtɨꞌndaꞌ gio baꞌ guiꞌ nam saduseos jup jum tɨɨtɨꞌndaꞌ na ja aagidhat jup kaiꞌchim nam cham ja kɇkɇɇdaꞌ gu puiꞌ nam jax jaꞌk tu aꞌgadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Baꞌ miꞌ dhɨr giop ba jii gu Jesuus mu jaꞌk na paiꞌ Sesarea Piliipo tɨ tɨɨgim bhaan bipioꞌ gu dɨbɨɨr. Baꞌ ba ja tɨkka gu noonbiꞌñ, jup ja tɨtda: ―¿Jax jam kaiꞌchdhaꞌ gu jaꞌtkam? ¿Jaroo sap daꞌ iñ aañ nat bhañ joot guñ Gɨꞌkoraꞌ? ¿Tuꞌñ sap jir jup tuꞌm daꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Baꞌ guiꞌp kaiꞌch am: ―Dho jɨꞌmaꞌn jup kaiꞌchdhaꞌ am nap sap aap jir diꞌ gu Juan jaꞌtkam bopkondam. Jaiꞌ baꞌp kaiꞌchdhaꞌ am ɨp nap sap aap jir diꞌ gu Eliiyas guiꞌ nat saak puiꞌ maaxik duakam jii jix dhaam jaꞌk. Jaiꞌp baꞌp kaiꞌchdhaꞌ am ɨp nap sap aap jir diꞌ gu Jeremiiyas, gio baꞌ moo jɨꞌx jup kaiꞌchdhaꞌ am ɨp nap sap aap maadɨt jir diꞌ guiꞌ nam bɨjɨk bhaankam tu aꞌgimɨk gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Baꞌ dɨɨlh jup xi ja tɨkka gu noonbiꞌñ gu Jesuus, jup ja tɨtda: ―¿Aapiꞌm gi, xiñ maat japim aa nañ jir tuꞌp tuꞌm daꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Baꞌ muiꞌ ji ñio gu Simoon guiꞌ nam Peegro kɨꞌn jup jix mat kaꞌ, jup kaiꞌch: ―Dho aapiꞌ dhor diꞌ guch Xoiꞌkam guiꞌ na saak bha jootsaꞌ gɨt gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Baꞌp tɨtda gu Jesuus: ―Jaꞌp moo joidham jix bhaiꞌ tum jii Simoon aap nap jir maraaꞌn gu Jonaas, nat guꞌ cham tuꞌ jaroiꞌ yaꞌ kam dhi oiꞌñgaꞌn jum aaꞌñ gu dhiꞌ puiꞌ na pich jax jaꞌk tɨi nañ jir tuꞌp tuꞌm daꞌ aañ, guꞌ guñ Gɨꞌkoraꞌ ji guiꞌ nax dhaam jup tuꞌiiꞌ nat jum aaꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Baꞌ xib aañ pum tɨtda, aap nap Peegro kɨꞌn jup tɨɨꞌ, na jaꞌp kaiꞌñkam jup jum kaiꞌch nap jir jodai, aap yaꞌ ka ja sɨlhkaꞌndaꞌ guiꞌ nam jɨꞌk jiñ bui tɨ jɨɨgiꞌñ gu jaꞌtkam nam baꞌ gammɨjɨ miꞌ puiꞌ jiimdaꞌ nañ jax tu jam aꞌgiꞌñ. Baꞌ dhiꞌ jaꞌp ji buusniaꞌ nañ jodai chaꞌm ba kɨɨsaꞌ guñ chiop. Baꞌ cham jɨꞌxkat jax dhoodaꞌ gux buam jum duukam, sia ku jax tɨi ɨlhiiꞌñdhaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jum makiaꞌ iñ guiꞌ na bhaan jix maatɨꞌ kaꞌ na bɨɨx jum aꞌm ji chu biꞌyaꞌ gu tuꞌ nap jax jix dhuñiim kaꞌ, jix dhaam dɨr jañ yaꞌ tum aichulhdhaꞌ. Baꞌ jax ñap tɨꞌiidhaꞌ yaꞌ dhi oiꞌñgaꞌn, puiꞌp tu tuiꞌkaꞌ jix dhaam jaꞌk, gio gu tuꞌ nap jax jix dhuñiim kaꞌ, puiꞌ jaꞌk jup tu tuiꞌkaꞌ jix dhaam jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Miꞌ dhɨr baꞌ dai nat xi ja sooꞌmchulhdhak gu Jesuus gu noonbiꞌñ nam sap chakui jaroiꞌ aagiꞌñdhaꞌ na dhiꞌr diꞌ guch Xoiꞌkam guiꞌ na saak bha jootsaꞌ gɨt gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Baꞌ ba ja aagiꞌñ gu Jesuus gu noonbiꞌñ na sap bhammɨ jaꞌk jim Jerusaleen, sap baꞌ noꞌt bhammɨ ba ai, tu chiñiaꞌ am nam tulhiiñchudai muꞌaaꞌ gu ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam, gio gu ja gɇꞌgɇrkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios. Ku baꞌ guꞌ sap baik tanoolh kɨꞌn duadɨi miꞌ ji na jax ba oirɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Baꞌ gu Peegro mu jaꞌp dɨlhkob xi baakuk jup tɨtda gu Jesuus na sap cham jir am gu puiꞌ na jax kaiꞌch, jup tɨtda: ―Chaam ji nar am gu puiꞌ nap jax kaiꞌch jiñ jaduuñ. Jax dhui na moo cham puiꞌ aaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Guꞌ ji nat guꞌ jotmodaꞌ kuꞌ xi kɨkbok gu Jesuus jup tɨtda: ―Moop cham tuꞌ kɨꞌn jiñ juandaꞌ toobilhik, nap guꞌ cham puiꞌ ɨlhiiꞌñ na jax jix aaꞌ gu Dios, dai nam jax pɨx jaꞌk ɨlhiiꞌñ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Miꞌ dhɨr baꞌ moop ja tɨtda bɨɨx gu noonbiꞌñ gu Jesuus: ―Noꞌ jaroiꞌx aaꞌ na gammɨjɨ bañ kaichgɨdaꞌ, jum aaꞌ na jaꞌp xi dhuuji na dɨɨlh jax ɨlhiiꞌñdhaꞌ, dai na pɨx bhaan ji bamgiaꞌ, cham jax bua sia kum jix muꞌaam. ");
INSERT INTO stpNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Na guꞌ gu jaroiꞌ noꞌ tɨix aaꞌ na gɨt jix bhaiꞌ tu jimdaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, cham bhaiꞌ tu jimiaꞌ gatuuk. Guꞌ cham ji noꞌ guꞌ cham tuꞌ ji kɇkɇɇdat gammɨjɨñ kaichuꞌ sia ku mɨt ma mua, na guꞌx bhaiꞌ tu jimiaꞌ miꞌ dhɨr jaꞌp jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Tuꞌ gi miꞌp tɨgiaꞌ gu jaroiꞌ sia ku tɨi bɨxchuꞌ tu biaꞌ gu tuꞌ na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch? Na guꞌ cham jɨꞌxkat palhbuidhaꞌ na tɨsdiaꞌ jix dhaam jaꞌk noꞌt jotmodaꞌ am xi muu. ");
INSERT INTO stpNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Na guꞌ aañ nañ paiꞌ dhuuk gio bhaiꞌp jimdaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, jix ioꞌm gɇꞌkam kɨꞌn bha jimdaꞌ iñ, na guꞌñ aꞌm tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ, sia gu noonbiꞌñ jam jiñ bɨɨm jiimdaꞌ. Baꞌ yaꞌ ja makiaꞌ iñ bɨɨx gu jaꞌtkam gu tuꞌ nar ja maiꞌchɨk kaꞌ bɨɨx jɨꞌmaꞌn nam tuꞌ jax buimɨi yaꞌ dhi oiꞌñgaꞌn bhaan, noꞌm miꞌ puiꞌ jiimdat na jax jix aaꞌ gu Dios piam ku guꞌ cham. ");
INSERT INTO stpNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨtdañ jaaduñ na pim jɨꞌk yaꞌp tuꞌiiꞌ gu xib, na pim jaiꞌ dhɨt pui kapup duduakaꞌ nañ gio yaꞌ ɇɇji bar gɇꞌkam kaꞌ dhi oiꞌñgaꞌn bhaan, aañ nañ bhaankam yaꞌ oirɨ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Baꞌ gatuuk jɨꞌk xijum maaꞌn jurniꞌñ kɨꞌn ma jii gu Jesuus maaꞌn kap na paiꞌr oidhaꞌ taꞌm nax ioꞌm jir tɇꞌkob, xi ja baidhak baik gu noonbiꞌñ, moo gu Peegro, gio gu Jakoobo, gio baꞌ gu Juan jaꞌnniꞌñ dhiꞌ jɨꞌ dhi Jakoobo. ");
INSERT INTO stpNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Baꞌ na mɨt paiꞌ dhuuk bhɨjɨmmɨ ba tɨɨtɨs daam dɨr gu oidhaꞌ, jotmodaꞌ maakam tuꞌm jup jum duu gu buibsaꞌn gu Jesuus, jaꞌp tuꞌm jum maaxiꞌñ na jax gu tanoolh, gio gu jajannulhiꞌñ joidham jix chooto totbikdam jup jum duu, jaꞌp tuꞌm jum maaxiꞌñ na jax gu tuꞌ noꞌ mɨichdhix na joidham tanoordaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Baꞌ ba ja tɨɨ mɨt gu noonbiꞌñ gu Jesuus gook gu jaꞌtkam na mɨt miꞌ bam maax, maaꞌn jir diꞌ gu Moisees, maaꞌn baꞌr Eliiyas. Baꞌ miꞌ guꞌkat tu aꞌgiꞌñ am gu Jesuus nam muiꞌ xi chɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Baꞌ gu Peegro jotmodaꞌ cham jum matdaꞌ ɨr muiꞌ ba ñio, jup tɨtda gu Jesuus: ―Umri moor am jiñ jaduuñ nach kapbhaiꞌ yaꞌp tuꞌiiꞌ aap jum bui. Jɨꞌmaꞌn jach jam tuttuidhaꞌ gu oꞌnam, maaꞌn moor aap gaꞌn kaꞌ, maaꞌn baꞌr Moisees gaꞌn kaꞌ, maaꞌn baꞌr Eliiyas gaꞌn kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Baꞌ na miꞌ puiꞌ ka kaiꞌch gu Peegro, jotmodaꞌ bhaiꞌ ji chɨbgɨr, jix chutuap tum duu miꞌ nam paiꞌp tuꞌiiꞌ. Baꞌ bhɨjɨ dɨr jaꞌp tɨbaaꞌñ chaꞌm bhaiꞌ ji chum ñio, jup tum kaiꞌch: ―Dhi Jesuus aañ jir jiñ mar, baꞌx ioꞌm jix dhaꞌ iñ. Aañiꞌ yaꞌ dɨr mu joot na pim baꞌ miꞌ puiꞌ xi jimɨi na jax jam tɨɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Baꞌ na mɨt jax puiꞌ tɨ kai gu noonbiꞌñ guch Xoiꞌkam, mi jaꞌp ja oꞌlhia kɨꞌn pu guguu mɨt na mɨt bax chootoꞌn, dɨɨrap xi chu siisap gu ja moom. ");
INSERT INTO stpNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Baꞌ gu Jesuus jaꞌxpɨx mu jimɨɨk miꞌ xi ja joiñdhak jup ja tɨtda: ―Xi baapmiꞌ gor. Chaꞌpim totdon kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Baꞌ na mɨt paiꞌ dhuuk gio muiꞌp ji chɨ tɨɨ, cham paiꞌ tu jaiꞌch am gu jaꞌtkam guiꞌ nam miꞌ ka guꞌkat, dai dɨɨlh gu Jesuus mi jaꞌp kɨɨk. ");
INSERT INTO stpNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Baꞌ giop ba jii mɨt bhaiꞌ dhɨr oidhaꞌ taꞌm. Baꞌ nammɨ paiꞌ aꞌnsap nam ba juurkichuꞌ, jup ja tɨtda gu Jesuus nam sap chakui jaroiꞌ aagiꞌñdhaꞌ gu puiꞌ na mɨt jax tɨ tɨɨ, jup kaiꞌch: ―Moo pim chakui jaroiꞌ aagiꞌñdhaꞌ gu dhiꞌ puiꞌ na pimɨt jax tɨ tɨɨ. Dai noꞌ ñich muukɨk giop ba dua na pim baꞌ ba tu aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Baꞌ moo jaꞌpni bhaiꞌp ba tɨkka am gu Jesuus gu noonbiꞌñ, jup kaiꞌch am: ―¿Jax kum baꞌp kaiꞌchdhaꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios na gu Eliiyas bɨɨpɨꞌ yaꞌ aayaꞌ na baꞌ guch Xoiꞌkam yaꞌp ba aayaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Baꞌp ja tɨtda gu Jesuus: ―Dho guꞌr puiꞌ dho na bɨɨpɨꞌ yaꞌ aayaꞌ gu Eliiyas na yaꞌ ja sɨlhkadaꞌ gu jaꞌtkam na baꞌ miꞌ dhɨr yaꞌp ba aayaꞌ guch Xoiꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ku baꞌ guꞌ jaꞌp moo gu tuꞌx matgɨm nañ yaꞌ jam aagiꞌñdhaꞌ, matgɨm gu Eliiyas yaꞌ ba ai ji, guꞌ ji na mɨt guꞌ cham jɨꞌxkat maat gu jaꞌtkam noꞌ moop jir diꞌ, dai na mɨt tuꞌ pɨx ɨlh. Baꞌ aañ nañ xib yaꞌ oirɨ aapiꞌm jam bui nat bhañ joot guñ Gɨꞌkoraꞌ, puꞌñi tuꞌ pɨx jup jiñ ɨlhdhaꞌ am gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bax maatɨt ba kai mɨt gu Jesuus gu noonbiꞌñ na gu Juan jaꞌtkam bopkondam aagɨt jup kaiꞌch nar diꞌ gu Eliiyas. ");
INSERT INTO stpNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Baꞌ na mɨt paiꞌ dhuuk mummɨ ba ai nam paiꞌ daraa gu muiꞌ jaꞌtkam, maaꞌn miꞌ dhɨr jaꞌp muiꞌ ji ai buiñor gu Jesuus, baꞌ mi jaꞌp oꞌlhiaꞌn kɨꞌn xi kɨkbok soiꞌ ba tɨtda, jup kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Aañ jaꞌp tɨi kaiꞌchidhat jiñ jaduuñ nap gɨt iam duaꞌñdhaꞌ dhiñ alhii chuk na giilhim jum tulhiiñ na tu kaammukdaꞌ. Jɨꞌx tai chɨr ba gɨxiaꞌ piam suudaiꞌ chɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tɨi ñich ya ja aichulh dhiꞌ nam jum kaichuꞌ, guꞌ ji na mɨt guꞌ cham jɨꞌxkat duaꞌñ, na guꞌ chix xijai jax ña jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Baꞌp kaiꞌch gu Jesuus: ―¿Moo jaꞌp chakui bɨɨx jam jujur kɨꞌn jix biiñak japim aa buiñor gu Dios? ¿Jɨꞌx jañ baꞌ yaꞌ pu oirɨt jup jam aagiꞌñdhaꞌ? Bhaiꞌ gor jiñ baiꞌñxiꞌñbop gux koꞌkkam yaꞌni jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Baꞌ guiꞌ xi baiꞌñpuk miꞌp ba aichulh jamɨt. Baꞌ ba ñiok gu Jesuus gu cham kɨɨꞌ iiꞌmdaꞌ na bhaan jup tuiꞌdhiꞌ gu biapmaꞌ, jup tɨtda: ―Mup buusniaꞌ bhaiꞌ dhɨr bhaan dhi biapmaꞌ. Chaꞌp bhaiꞌ pu tuiꞌñgɨdaꞌ. Baꞌx kɨɨꞌp jum duu gu biapmaꞌ miꞌ jotmodaꞌ nat jax pu tɨɨꞌn gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Baꞌ gatuuk mu jaꞌp dɨlhkob ba tɨkka am gu Jesuus guiꞌ nam kaichuꞌ, jup tɨtda am: ―¿Jax baꞌr jum duukam chi ku chich baꞌ aach cham jɨꞌxkat maiꞌ joot gu cham kɨɨꞌ iiꞌmdaꞌ bhaiꞌ dhɨr bhaan gu biapmaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Baꞌp ja tɨtda gu Jesuus: ―Dho na pim cham bɨɨx jam jujur kɨꞌn tɨ jɨɨgiꞌñ dho buiñor guñ Gɨꞌkoraꞌ. Na guꞌ noꞌ pim bɨɨx jam jujur kɨꞌn tɨ jɨɨgiꞌñdhaꞌ gɨt buiñor, sia ku pim guꞌ panaas cham tuꞌ bhaigɨm tuꞌiiꞌ, jaꞌp na jax gu mostaasa kai na panaas cham tuꞌ bhaigɨm tuꞌiiꞌ, aañ pu jam tɨtda na sia dhi oidhaꞌ jix bhaaiꞌ na pim pu tɨɨdaꞌ na maakam jaꞌk jimiaꞌ, puiꞌ dho ji chu buusniaꞌ noꞌ pim moo tuꞌ sɨlhkam tɨ jɨɨgiꞌñ buiñor guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Baꞌ gu pu chuutuꞌm cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ, saabuix kam jum aaꞌ na baꞌx bhaaiꞌn kaꞌ nañ maiꞌ ja jootosdaꞌ, gio baꞌ nañ gammɨjɨ xi tu daanɨt buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Baꞌ nam pui maap miꞌ ka oipo na paiꞌ bhaan bipioꞌ gu Galilea dɨbɨɨr, jup ja tɨtda gu Jesuus gu noonbiꞌñ: ―Jum aayaꞌ nam paiꞌ dhuuk jiñ dhagiaꞌ guiꞌ nam jiñ oꞌbhagiꞌñ aañ nat bhañ joot guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Miꞌ dhɨr baꞌ dai nam ba tu chiñiaꞌ nam jiñ muꞌaaꞌ, ku baꞌ guꞌ aañ baik tanoolh kɨꞌn yaꞌ ji nañ jax ba oirɨdaꞌ. Baꞌ bhaiꞌx buam jim ɨlh jamɨt gu noonbiꞌñ na mɨt puiꞌ jɨꞌ kai gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Baꞌ nat paiꞌ dhuuk mummɨ jaꞌk jup ba ai gu Jesuus na paiꞌr Kapernaum ja bɨɨm guiꞌ nam kaichuꞌ, miꞌ ba ji bubua mɨt buiñor gu Peegro guiꞌ nam tu taandaꞌ gu tuumiñ na jɨꞌk aagix nam tu maakdaꞌ bhammɨ gɇꞌ chiop. Baꞌ jaꞌpni bhaiꞌ ba tɨkka am: ―¿Tu namkiꞌñ aa guiꞌ na pim kaichuꞌ na jɨꞌk bhaan bipioꞌ gu gɇꞌ chiop? ");
INSERT INTO stpNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Baꞌp ja tɨtda gu Peegro: ―Tu namkiꞌñ ji matgɨm. Baꞌ xi mɨɨ nat tɨkkam gu Jesuus na jax jaꞌk jix bhaiꞌ gu dhiꞌ puiꞌ. Baꞌ na kiaꞌpɨx muiꞌ ji baakim mɨjɨ baꞌk chɨr, bɨɨpɨꞌ kat bhaiꞌ ba ñio gu Jesuus, jup kaiꞌch: ―¿Aap jax ɨlhiiꞌñ Simoon ja bui gux ioꞌm gɇꞌgɇrkam jum aaꞌndam nam jix jaiꞌch yaꞌ dhi oiꞌñgaꞌn bhaan? ¿Jaroom aagix nam ja namkiꞌñdhaꞌ, gu dɨɨlh ja jaꞌtkam tuk aa, kaꞌ gu jaiꞌ aa momkoran kam noꞌm ja daam kɨɨk? ");
INSERT INTO stpNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Baꞌp kaiꞌch gu Peegro: ―Dho guiꞌ dho nam jir momkoran kam. Baꞌp tɨtda ɨp gio gu Jesuus: ―Jir puiꞌ dho nap jax kaiꞌch, guꞌ baꞌ guiꞌ nam jir ja jaꞌtkam tuk tɨi cham tuꞌ aagix nam ja namkiꞌñdhaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Baꞌ aach puꞌñi ɨp, tɨi cham tuꞌ aagix nach tu namkiꞌñdhaꞌ gɨt, nach guꞌ puiꞌp jir ja jaꞌtkam tuk. Ku baꞌ guꞌ ea nap mu jimiaꞌ mummɨ na paiꞌ gɇꞌ suuꞌn gu suudaiꞌ xi bhɨɨji ap gu bhaiꞌchdhakar, mup baꞌ xi buaꞌ suudaiꞌ chɨr. Baꞌ gu jax chuꞌm na bɨɨpɨꞌ miꞌ saꞌyaꞌ gu batoop, maaꞌn tɨgiaꞌ ap gu tuumiñ na mi jimdaꞌ chiñiꞌran, aixkam na jɨꞌk jum aaꞌ nach kɨꞌn tu namkidhaꞌ aap gio aañ. Baꞌ xi bhɨɨji ap kɨꞌn mu xi ja namkiꞌñmɨraꞌ guiꞌ nam puiꞌ bham taan nam baꞌ cham tuꞌ kɨꞌn kach juandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Baꞌ moo jaꞌpni bhaiꞌp ba tɨkka am gu Jesuus gu noonbiꞌñ, jup tɨtda am: ―¿Jaroo chi baꞌx ioꞌm jir gɇꞌkam kaꞌ jix dhaam jaꞌk buiñor gu Dios? ");
INSERT INTO stpNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Baꞌ xi baiꞌñmɨrak gu Jesuus maaꞌn gu alhii mi jaꞌp ja saagiꞌñ xi kɨɨsak ");
INSERT INTO stpNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","jup ja tɨtda: ―Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨtda, gu jaroiꞌ noꞌ cham puiꞌm ɨlhiiꞌñ na jax dhiꞌñi alhii, cham jɨꞌxkat jimiaꞌ jix dhaam jaꞌk buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Baꞌ gu jaroiꞌ na puiꞌm ɨlhiiꞌñdhaꞌ na jax gu alhii na soiꞌm ɨlhiiꞌñdhaꞌ, dhiꞌ jɨꞌ ji na bar gɇꞌkam kaꞌ jix dhaam jaꞌk buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Guꞌ baꞌ gu jaroiꞌ noꞌt jix bhaiꞌ ba duu gu jax chuꞌm alhii aañ jiñ aꞌmkam jaꞌp na jax dhiꞌñi nañ yaꞌ daaꞌ, jaꞌp ji buusniaꞌ nat aañ jix bhaiꞌ bañ dhuu. ");
INSERT INTO stpNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Baꞌ gu jaroiꞌ noꞌt maakam iatgidhak jix buam ba tu mamtux gu jax chuꞌm alhii puiꞌ na jax dhiꞌñi nañ yaꞌ daaꞌ, noꞌ guꞌ tɨi ka tɨ jɨɨꞌñdhat aañ jiñ bui, jir am kat nam kuxboran buulhdhai gu mattur mu nuiꞌññaꞌ mu paiꞌ na gɇꞌ suuꞌnkaꞌ gu suudaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jaꞌp moox buam iam ja bui gu jaꞌtkam, nam guꞌ gammɨjɨ jaiꞌch kaꞌ ja bui guiꞌ nam ja baidhidhaꞌ nam jix buam jum duukam jup tu duiñpuꞌ. Ku baꞌ guꞌ gu jaroiꞌ na puꞌñi ja baidhidhaꞌ gu jaꞌtkam nam jum uꞌuaꞌtulhdhapuꞌ, giilhim joiꞌmdam jum duñiaꞌ ji gatuuk na paiꞌ dhuuk tulhiiñchudaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Guꞌ baꞌ noꞌp guꞌ aap gum nob kɨꞌn jum uaꞌtulhiꞌñ piam gum toon kɨꞌn, jix bhaiꞌ nap ɨɨkɨi mu baas buaꞌ nap baꞌ cham gammɨjɨ kɨꞌn pup jum uaꞌtulhiꞌñdhaꞌ, cham jax bua sia kup maap dɨr cham tu nobtuꞌ piam kup cham tu toontuꞌ nap paiꞌ dhuuk ba aayaꞌ jix dhaam. Na guꞌ xiꞌ cham jir am noꞌ mɨt guꞌ bɨnkam mu jaꞌk xim bua na paiꞌ gammɨjɨ cham tutkɨ gu tai nap miꞌ pup jum tulhiiñdhaꞌ gammɨjɨ, sia kup bɨɨx gook tɨi xi chu noonobtuꞌ piam kup bɨɨx gook tɨi tu tootontuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Piam ku guꞌ noꞌp guꞌ maap dɨr gum buupui kɨꞌn jup jum uaꞌtulhiꞌñ, jix bhaiꞌ ɨp puiꞌ nap jupnai mu baas buaꞌ nap baꞌ cham gammɨjɨ kɨꞌn pup jum uaꞌtulhiꞌñdhaꞌ. Na guꞌ xiꞌ cham jir am noꞌ mɨt bɨnkam mu jaꞌk xim bua na paiꞌ gammɨjɨ cham tutkɨ gu tai nap miꞌ pup jum tulhiiñdhaꞌ gammɨjɨ. Guꞌ cham ji noꞌp maap dɨr pɨx tu buupuichuꞌ nap paiꞌ dhuuk ba aayaꞌ jix dhaam, cham jax bua, na guꞌx bhaiꞌ ba tum jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Baꞌ aañ yaꞌ pu jam tɨtdañ jaaduñ na pim cham tuꞌ pɨx ja ɨlhiiꞌñdhaꞌ gu aꞌaalh jaꞌp na jax dhiꞌñi nañ yaꞌ daaꞌ, ni jax chuꞌm dho moo, nam guꞌ dhiꞌ ja aꞌm tɨ nɨidhat jup tuꞌiiꞌ jia gu noonbiꞌñ guñ Gɨꞌkoraꞌ guiꞌ nam jix dhaam jup tuꞌiiꞌ buiñor. ");
INSERT INTO stpNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nat guꞌ aañ pu kaiꞌñkam bhañ joot jia guñ Gɨꞌkoraꞌ yaꞌ dhi oiꞌñgaꞌn bhaan nañ yaꞌ ja palhbuidhaꞌ nañ ja boosgaꞌ guiꞌ nam jɨꞌk mu jaꞌk bhɨichuꞌ nam paiꞌ gammɨjɨ miꞌ pup jum tulhiiñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Jax japim ɨlhdhat jiñ kɇɇ? Puiꞌ na jax maaꞌn gu maaꞌnkam noꞌ ja biaꞌ gu kakasnir jɨꞌk maaꞌn jix chamaam ooꞌm aix kam. Guꞌ baꞌ noꞌt guꞌ jax dhuukat maaꞌn maiꞌ ma bua mu paiꞌ gampɨx noꞌ ka tu bipiaꞌ, ¿cham japim ɨlhiiꞌñ na miꞌ ka xi ja doꞌñchoi gu jaiꞌ xi dhaiꞌññiaꞌ na tu gaaꞌmɨraꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Baꞌ na paiꞌ dhuuk tɨgiaꞌ, jix ioꞌm jix dhaꞌdam dagiaꞌ, cham tuꞌ puiꞌ ɨlhiiꞌñdhaꞌ na jax gu jaiꞌ na mu paiꞌ xi ja doꞌñchoi. ");
INSERT INTO stpNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Baꞌ puꞌñi ɨp guñ Gɨꞌkoraꞌ nax dhaam jup tuꞌiiꞌ, cham aaꞌ na jaroiꞌ maadɨt maiꞌ gɨxiaꞌ dhiꞌ dhi aꞌaalh. ");
INSERT INTO stpNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Guꞌ baꞌ noꞌ jax dhuukat aapiꞌm maadɨt tuꞌ jax ma jam duiñ gu jax chuꞌm jam jaduuñ, jix bhaiꞌ nap mu jaꞌp dɨlhkob xi baabui xi chu aꞌgidhaꞌ na cham bhaiꞌ na puiꞌ tu buadaꞌ. Baꞌ noꞌ jax kaiꞌch na cham puiꞌ ka tu buadaꞌ, dho guꞌ puiꞌ dho na pim jax jix bhaiꞌ ba kaiꞌchdhaꞌ na jax bɨɨpɨꞌ dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piam ku guꞌ noꞌt guꞌ jax dhuukat cham jum kai gu puiꞌ nap jax tu aꞌgidhaꞌ, jir am nap jumaip xi baiꞌñmɨrai gu jaroiꞌ piam jɨꞌk gook na pim baꞌ baik dɨt tu aꞌgidhaꞌ, katti iam jam kɇɇji miꞌ puiꞌ ba jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Piam ku guꞌ maaꞌn nat jax cham jam kai, dho guꞌ jaiꞌp dho giop xi ja baiꞌñmɨrai bɨɨx nam jɨꞌk tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui na pim baꞌ muiꞌ dhɨt tu aꞌgidhaꞌ. Baꞌ noꞌ guꞌ maaꞌn nat jax cham jam kai, dho guꞌ puiꞌp dho cham ka juandaꞌ, dai nap puiꞌ pɨx ba biaꞌkaꞌ na jax guiꞌ nam cham tɨ jɨɨgiꞌñ aañ jiñ bui, piam puiꞌ na jax guiꞌ nam jir tuumiñ tu taandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam nam cham tuꞌ kaꞌm tɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Baꞌ jax ña pim jix aaꞌndaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, puiꞌ jaꞌk jup tu tuiꞌkaꞌ jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ, aañ moo yaꞌ pu jam tɨtda. Piam na pim jax tɨꞌiidhaꞌ gio na pim tuꞌ cham aaꞌndaꞌ na puiꞌ tu tuiꞌkaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, puiꞌ jaꞌk jup tu tuiꞌkaꞌ jix dhaam jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Baꞌ noꞌ pimɨt jɨꞌk gook maap xi chu aꞌgak ma tu daanɨ buiñor guñ Gɨꞌkoraꞌ, jam makiaꞌ dho na pim tuꞌ taandaꞌ, aañ moo yaꞌ pu jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Na guꞌ noꞌm jɨꞌk gook piam jɨꞌk baik miꞌ paiꞌ tu daan gu jaꞌtkam aañ jiñ bui, aañ miꞌp tuiꞌñgɨdaꞌ ja bui. ");
INSERT INTO stpNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Baꞌ gu Peegro mu jimɨɨk amuub bhaiꞌ ba tɨkka gu Jesuus, jup tɨtda: ―¿Guꞌ baꞌ jɨꞌkim jix bhaiꞌ nañ pu tɨɨdaꞌ gu jax chuꞌm jiñ jaduuñ noꞌt tuꞌ jax jiñ duiñ nañ puiꞌ pɨx ka tu uañiꞌñkaꞌ, jɨꞌk xijum gookim aa? ");
INSERT INTO stpNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Baꞌ gu Jesuus jup tɨtda: ―Jaꞌpji muiꞌ kim ji nax bhaiꞌ nap pu tɨɨdaꞌ nap puiꞌ pɨx ka tu uañiꞌñkaꞌ, cham tuꞌ gu tuꞌ xijum gookim pɨx, guꞌ jaꞌpji jɨꞌk baik ooꞌm daman mambhɨɨx jaꞌkbuiꞌ kim ji. ");
INSERT INTO stpNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Baꞌ gu jaroiꞌ noꞌ bhaan ba tɨ nɨidhim gu Dios, jaꞌp ji buusan na jax maaꞌn gu jax chuꞌm gɇꞌkam noꞌt mu paiꞌ ba ji chu jaꞌkɨlh nam jɨꞌk uaꞌtuꞌndaꞌ guiꞌ nam jɨꞌk palhbuiꞌñdhaꞌ gu tuꞌ na jax buadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Baꞌ nat jax kiaꞌpɨx muiꞌ ji chu jaꞌkɨlh, ba tɨɨ na maaꞌn jix ioꞌm muiꞌ tuumiñ uaꞌtuꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Baꞌ ba tu chia nam daagɨi gaꞌraꞌ bɨɨmaꞌn gu bɨngaꞌn, gio gu maamraꞌn, gio baꞌ na jɨꞌk tuꞌ biaꞌkaꞌ, nam sap baꞌ puiꞌ pɨx tujuandam kɨꞌn ji biꞌyaꞌ cham ji namkidhat na sap baꞌ puꞌñi jaꞌk cham ka uaꞌtuꞌndaꞌ, na guꞌ cham biaꞌkaꞌ na tuꞌ kɨꞌn tu namkidhaꞌ dhiꞌ dhi maaꞌnkam. ");
INSERT INTO stpNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Guꞌ ji nat guꞌ jotmodaꞌ mi jaꞌp oꞌlhiaꞌn kɨꞌn xi kɨkbok bhaiꞌ soiꞌ ji chɨɨꞌn gu gɇꞌkam guiꞌ jɨꞌ gu maaꞌnkam na muiꞌ tuumiñ uaꞌtuꞌndaꞌ, jup tɨtda: “Ka tuñ uañiꞌñkaꞌ ap jiñ jaduuñ. Aañ matgɨm jum namkidhaꞌ ji bɨɨx nañ jɨꞌk jum uaꞌtuꞌn.” ");
INSERT INTO stpNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Baꞌ gu gɇꞌkam jix joiꞌmdak ma kai, puiꞌ cham ka juan sia ku uaꞌtuꞌn, dai nat ba tu chia nam giop doꞌñchoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Guꞌ ji na guꞌ moo janoꞌ nat jax miꞌ dhɨr buus guiꞌ jɨꞌ gu maaꞌnkam na tu uaꞌtuꞌndat, maaꞌn mi jaꞌp jup ba tɨɨ guiꞌ nam maap tu juandaꞌ na palhɨɨp jup uaꞌtuꞌndaꞌ. Baꞌ bhaiꞌ pu ji dhaa kuxboran, bhaiꞌ xi bhiikchuꞌntuꞌ jup xi chɨtdat: “Bhaiꞌp jiñ ñamkidhaꞌ guiꞌ nap jiñ uaꞌtuꞌn.” ");
INSERT INTO stpNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Baꞌ puiꞌ tɨip xi chum uañ buiñor guiꞌ na miꞌx bhaam, jup tɨtda: “Ka tuñ uañiꞌñkaꞌ ap jiñ jaduuñ. Aañ matgɨm jum namkidhaꞌ ji bɨɨx nañ jɨꞌk jum uaꞌtuꞌn.” ");
INSERT INTO stpNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Guꞌ ji na guꞌ cham puiꞌ ɨlhiiꞌñ guiꞌ na miꞌx bhaam, jaꞌpji na bha taan ji na jɨꞌk uaꞌtuꞌn. Tu chia dho guꞌ nam kuupaꞌ na sap baꞌ namkidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Baꞌ na mɨt puiꞌ jɨꞌ tɨɨ nat tu dooda guiꞌ nam puiꞌp jir tujuandam tugiꞌñ kaꞌ gu gɇꞌkam, giilhim jix buam jum ɨlh jamɨt, baꞌ mu jimɨɨk ba aagiꞌñ am gu gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Baꞌ gu gɇꞌkam mu tu joochxi na mu jimdaꞌ buiñor. Baꞌ nat paiꞌ dhuuk miꞌ ba ai, jup tɨtda: “Jaꞌp moo alh jix buam tomaat ap. Tɨɨꞌ aa na ñich aañ cham jax jum dooda nap jix ioꞌm muiꞌ tuumiñ jiñ uaꞌtuꞌndat, na ñich guꞌx joiꞌmdak jum kai na pich bhaiꞌ soiꞌ jiñ chɨɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Moo cham bhaaiꞌ aa nap puꞌñix joiꞌmdaip kaayaꞌ guiꞌ na puiꞌm uaꞌtuꞌn na ñich aañ jax xim joiꞌmdak jum kai nap soiꞌ bañ chɨtda?” ");
INSERT INTO stpNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Baꞌ bhaamuk tu chia gu gɇꞌkam nam tulhiiñchudaꞌ na baꞌ namkidhaꞌ ɨp gio guiꞌ nat jɨꞌk puiꞌ tɨi ba tɨɨdak na cham ka namkidhaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Baꞌ miꞌ pɨx juugɨt tu aꞌga gu Jesuus gu dhiꞌ puꞌñi jaꞌk. Miꞌ dhɨr baꞌ moop ja tɨtda: ―Baꞌ aapiꞌm puꞌñip jam doodaꞌ guñ Gɨꞌkoraꞌ guiꞌ nax dhaam jup tuꞌiiꞌ noꞌ pim cham tu ja uañiꞌñ gu jam jaaduñ bɨɨx jam jujur kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Baꞌ gatuuk na miꞌ puiꞌ jɨꞌ xi chu ja aꞌgidhimɨk gu Jesuus gu noonbiꞌñ, pu jii miꞌ dhɨr na paiꞌ bhaan bipioꞌ gu Galilea dɨbɨɨr, mu jaꞌk jup bhɨi na paiꞌ bhaan jup bipioꞌ gu Judea dɨbɨɨr, maaꞌn kap na paiꞌ iampɨx xiaꞌlhbui jaꞌk bipioꞌ miꞌ na paiꞌ bhɨix gu Jordaan Ak. ");
INSERT INTO stpNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Baꞌ cham jɨꞌx mɨɨkim jix ioꞌm muiꞌ miꞌ mam jumaap jamɨt gu jaꞌtkam ji ja uaꞌdat am gux kakoꞌkkam, baꞌ gu Jesuus cham jax ji chɨꞌɨɨk pɨx jaꞌx jup ji ja duduaꞌñ. Bɨɨx jamɨt dho guꞌx kɨɨꞌp jum duu. ");
INSERT INTO stpNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Baꞌ moo jɨꞌkchi miꞌp ba ai mɨt guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, baꞌ bhaiꞌ ba tɨkka am gu Jesuus nam miꞌ pɨx jix maiꞌchim noꞌ sap moo jax kaiꞌch na cham jir am nam baꞌ puiꞌ jaꞌk iattulhdhai tu chiñiaꞌ nam muꞌaaꞌ, jup tɨtda am: ―¿Jix bhaaiꞌ aa gu jaroiꞌ noꞌ cham ka joiꞌñ gu bɨngaꞌn na maiꞌ xi buaji jumai bhaiꞌp ji bhɨɨyaꞌ, kaꞌ guꞌ cham aa? ");
INSERT INTO stpNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Baꞌp ja tɨtda gu Jesuus: ―¿Kux aapiꞌm aa cham jɨꞌxkat tu jiñkuiꞌñ miꞌ na mɨt paiꞌ tu uaꞌnak gu bɨjɨk dɨr kam nap jum kaiꞌch nat guñ Gɨꞌkoraꞌ pu kaiꞌñkam jup duu gu chioꞌñ gio gu ubii nam baꞌ gammɨjɨ maap tu oiꞌñkaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Gio baꞌ moo jaꞌpnip jum kaiꞌch ɨp: “Baꞌ dɨlhkob jaꞌk ba tu kiichaꞌ gu chioꞌñ na paiꞌ dhuuk bhɨɨyaꞌ gu ubii, cham tuꞌ miꞌ ka tu kiokaꞌ nam paiꞌ oiꞌñkaꞌ gu gɨꞌkorgaꞌn. Baꞌ dhi gook jaꞌp ji buan am nam jir maaꞌn maaꞌnkam kaꞌ pɨx gu chioꞌñ gio gu ubii.” ");
INSERT INTO stpNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Puiꞌ kuñ baꞌp kaiꞌch nam cham tuꞌ kar gookaꞌn kaꞌ, guꞌ maaꞌn pɨx ji. Baꞌ cham jir am na jaroiꞌ jaꞌp xi dhuuji gu puiꞌ nat jax jaꞌk duu gu Dios nam gammɨjɨ maap tu oiꞌñkaꞌ gu chioꞌñ gio gu ubii. ");
INSERT INTO stpNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Baꞌp kaiꞌch am guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ: ―¿Guꞌ jax ji nat baꞌ gu Moisees puiꞌ jaꞌk ja chianɨk gu bɨjɨk dɨr kam na sap jix bhaaiꞌ gu jaroiꞌ na palhɨɨp xi chu uaꞌnai miꞌ xi makiaꞌ gu bɨngaꞌn na baꞌ miꞌ dhɨr bhaan jix maatɨꞌ kaꞌ nam cham kar jum bɨpnagɨm kaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Baꞌp ja tɨtda ɨp gio gu Jesuus: ―Dho na guꞌ nam jax bar tuutuꞌm kaꞌ jaꞌp na jax aapiꞌm nam cham maatɨt tɇ kɇɇkɇꞌ ni jɨꞌx, na guꞌx kaapak kaꞌ gu ja jujur, cham aaꞌndaꞌ am nam miꞌ puiꞌ jimiaꞌ na jax jir am. Puiꞌ kut baꞌ puꞌñi jaꞌk ja chianɨk gu Moisees nax bhaaiꞌ gu jaroiꞌ na maiꞌ buaꞌ gu bɨngaꞌn, guꞌ bɨɨpɨꞌ dɨr cham tuꞌ puiꞌ jaꞌk tu jimdat am ji. ");
INSERT INTO stpNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ku guꞌ jaꞌp moo gu tuꞌx matgɨm nañ yaꞌ jam aagiꞌñdhaꞌ, jaꞌpji na cham jir am ji na maiꞌ buaꞌ gu jaroiꞌ gu bɨngaꞌn noꞌt cham bɨɨpɨꞌ jumai bɨɨmaꞌn tɨɨ na boꞌkaꞌ. Na guꞌ noꞌt jumai tɨi bhaiꞌ ji bhɨi gu chioꞌñ gu ubii, cham tuꞌ puiꞌ ka ji buandaꞌ am nam jir jum bɨpnagɨm, nam guꞌ jaꞌp pɨx ba tu jimdaꞌ panaas na jax guiꞌ nam jir ganaiꞌ pɨx. ");
INSERT INTO stpNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Baꞌ gu noonbiꞌñ gu Jesuus jup tɨtda am: ―Dho bak guꞌr am kat ji na pu cham jaroiꞌ maadɨt bhɨbhɨɨdaꞌ gu ubii, na guꞌ noꞌt jaroiꞌ puꞌñi ma tɨɨ na jumai bɨɨmaꞌn boꞌkaꞌ gu bɨngaꞌn, cham jir am na gio maiꞌp ba buaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Baꞌp ja tɨtda gu Jesuus: ―Jax dhui nam guꞌ cham tuꞌ bɨɨx gu jaꞌtkam jix maat noꞌr am nam tɨ bɨpnaꞌ kaꞌ piam ku guꞌ cham, dai jɨꞌk pɨx ji guiꞌ nat pu puiꞌ jaꞌk ja aꞌm tɨ tɨɨ gu Dios nam baꞌx maat. ");
INSERT INTO stpNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Baꞌ jaiꞌp jix jaiꞌch am gu jaꞌtkam nam dɨɨlh jir pu chuꞌm nam cham tɨ bɨpnaꞌ kaꞌ, jaiꞌ baꞌ nam jaꞌp pɨx cham ja doꞌñchokaꞌ, jaiꞌ baꞌ jaꞌp kaiꞌñkam cham jup tɨ bɨpnaꞌ kaꞌ am nam gammɨjɨ miꞌ puiꞌ duiñchuꞌndaꞌ na jax jaꞌk jix aaꞌ gu Dios. Aapiꞌm baꞌ dɨɨlh jix bhaiꞌ xim gaagidhaꞌ na pim jax jaꞌk tuꞌt tu oiꞌñkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Baꞌ moo jaꞌxpɨx gu jaꞌtkam miꞌp ba aichulh jamɨt gu Jesuus gu ja aꞌaalh chuk nam jix aaꞌ na bhaiꞌ xi ja daagɨi tu ja daañxidhaꞌ jix dhaam jaꞌk buiñor guch Gɨꞌkoraꞌ. Guꞌ ji nam guꞌ cham aaꞌ gu noonbiꞌñ, dai na mɨt bhaiꞌ ji ja ñiok, jup ja tɨtda am nam sap cham mu jaꞌk ja uaꞌdaꞌ gu ja aꞌaalh chuk. ");
INSERT INTO stpNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Guꞌ ji na guꞌ cham puiꞌ ɨlhiiꞌñ gu Jesuus, jup ja tɨtda: ―Chaꞌpim ja ñiokiꞌñdhaꞌ dhich jaaduñ nam bha ja uaꞌ gu ja aꞌaalh chuk, na guꞌ dhiꞌ pɨk jix ioꞌm ja aꞌm tɨ nɨiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Baꞌ bhaiꞌ xi ja daagɨk ma tu daanɨ buiñor guch Gɨꞌkoraꞌ. Miꞌ dhɨr baꞌ dai nat ba jii. ");
INSERT INTO stpNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Baꞌ moo maaꞌn miꞌp ba ai gu biapmaꞌ miꞌ na paiꞌ oirɨ gu Jesuus, baꞌ jaꞌpni bhaiꞌ ba tɨkka: ―Aañ jaꞌp tuꞌm bham tɨkkam jiñ jaduuñ nañ jaꞌp tɇ kɇɇ nap jir jix bhaiꞌkam, nañ tɨix maachim nap jiñ aagiꞌñdhaꞌ gɨt nañ tuꞌx kɨɨꞌp jum duukam pu duñiaꞌ nañ baꞌ jimiaꞌ jix dhaam jaꞌk buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Baꞌp tɨtda gu Jesuus: ―¿Guꞌ jax duukat jap jix maat jiñ jaduuñ nañ jir jix bhaiꞌkam? Na guꞌ jumaip jix jaiꞌch jia guiꞌ na puiꞌp jir jix bhaiꞌkam, guiꞌ dhoñ Gɨꞌkoraꞌ nax dhaam jup tuꞌiiꞌ. Baꞌ noꞌp jix aaꞌ nap jimiaꞌ buiñor, jum aaꞌ nap bɨɨpɨꞌ miꞌ puiꞌ jimiaꞌ na jax jum kaiꞌch gu ñioꞌkiꞌñ miꞌ na paiꞌ tu uaꞌñix. ");
INSERT INTO stpNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Baꞌp kaiꞌch gu biapmaꞌ: ―¿Jax gi jaꞌk tu uaꞌñix? Baꞌ gu Jesuus jup xi aagiꞌñ jup tɨtda: ―Dho miꞌ na paiꞌ jaꞌpnim kaiꞌch: “Chaꞌp ja kooꞌndaꞌ gu jaꞌtkam. Gio nap cham maiꞌ xi buaji gum bɨɨnaꞌ jumai bhaiꞌ ji bhɨɨyaꞌ gu ubii. Gio nap cham naiꞌ tɨ ɨɨxiꞌñdhaꞌ. Gio nap cham naiꞌ ja iatgiꞌñdhaꞌ gu jaꞌtkam, ni jaroiꞌ dho moo. ");
INSERT INTO stpNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gio baꞌ nap tuꞌ kaꞌm nɨidhat gum taat gio gum naan. Gio baꞌ nap bɨɨx pɨx jix ja joiꞌgɨꞌndaꞌ gu jaꞌtkam sia nar jaroiꞌ kaꞌ gɨt, jaꞌp nap jax xim joiꞌgɨꞌndaꞌ aap dɨɨlh.” ");
INSERT INTO stpNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Baꞌp kaiꞌch ɨp gio gu biapmaꞌ: ―Dho guꞌ aañ bɨɨx miꞌ puiꞌ tɨi duiñchuꞌ ji gu dhiꞌ puiꞌ nap jɨꞌk jax kaiꞌch jiñ jaduuñ. ¿Chi guꞌ moo cham ji jia? ");
INSERT INTO stpNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Baꞌp tɨtda ɨp gio gu Jesuus: ―Dho guꞌ maaꞌn kam biꞌiix ji nap pu tu duñiaꞌ, puiꞌ na jax guiꞌ nap jɨꞌk tuꞌ biaꞌ nap tu gaꞌrai ja makiaꞌ gu tuumiñ guiꞌ nam cham biaꞌ nam paiꞌ dhɨr uꞌji kɨꞌn tu sabaꞌdaꞌ. Baꞌ dhiꞌ puꞌñi jaꞌk jir jix chumñigam kaꞌ ap jix dhaam jaꞌk. Miꞌ dhɨr baꞌ dai nap gammɨjɨ bañ kaichgɨdaꞌ cham tuꞌ bhaan jim tukgidhat. ");
INSERT INTO stpNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Baꞌ giilhim bhaiꞌx buam jim ɨlh gu biapmaꞌ nat puiꞌ jɨꞌ kai gu Jesuus, jix buam jum aagɨt pɨx ba jii, na guꞌ tɨi cham aaꞌ na tu gaꞌraꞌ gu bɨxchuꞌ na tu biaꞌ, na guꞌ giilhim jir jix chumñigam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Baꞌp ja tɨtda gu Jesuus gu noonbiꞌñ: ―Dho jaña nam jax jix xijaim ɨlhiiꞌñ gux chutumñigam nam miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ na baꞌ ja aꞌm ba tɨ nɨidhidhaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gu kameeyo chi iam cham xijaim jup ɨlhiiꞌñ ji na buupuiram baakɨi gu soomkar jaꞌp dɨr jaꞌk buusniaꞌ, cham tuꞌ puiꞌ na jax gux chutumñigam nam giilhim jix xijaim ɨlhiiꞌñ nam miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ, nam guꞌ dai mu jaꞌk bhaan jix chutkagix kaꞌ gu tuꞌ nam biaꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Baꞌ gu noonbiꞌñ miꞌ puiꞌ pup tuꞌiiꞌ am na mɨt puiꞌ jɨꞌ kai, cham bhaaiꞌ nam jax xim duñiaꞌ, dai nam jup jum tɨ tɨtda dɨɨlh: ―Dho bak guꞌ cham jɨꞌxkat jaroiꞌ aayaꞌ ji buiñor gu Dios, na guꞌ bak puiꞌ giilhim jix xijai nañ miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Baꞌp ja tɨtda gu Jesuus muiꞌ xi ja tɨɨgɨk: ―Jax dhui na cham tuꞌ xijai kam ɨlhiiꞌñ gu Dios gu tuꞌ nam jix xijai kam ɨlhiiꞌñdhaꞌ gu jaꞌtkam yaꞌ dhi oiꞌñgaꞌn bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Baꞌ gu Peegro miꞌ dhɨr jaꞌp muiꞌp ji ñio, jup kaiꞌch: ―¿Aach baꞌ tuꞌ maiꞌchiaꞌ jix dhaam jaꞌk, na chich guꞌ cham tuꞌ kap jich buix gu tuꞌ nach biaꞌkat janoꞌ dɨr na chich paiꞌ dhuuk jum kai? ");
INSERT INTO stpNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Baꞌ gu Jesuus jup ja tɨtda bɨɨx nam jɨꞌk jir gu noonbiꞌñ: ―Dho guꞌ dai dho na pim jiñ bɨɨm ba daraibuꞌ mambhɨɨx kap daman gook bhaiꞌ nañ paiꞌ ba daibuꞌ aañ nat bhañ joot guñ Gɨꞌkoraꞌ nañ paiꞌ dhɨr naiꞌr gɇꞌkam kaꞌ, na joidham jix chu abhaar, janoꞌ na paiꞌ dhuuk jum aayaꞌ na bɨɨx xixiibkam jup tum duñiaꞌ gu tuꞌ. Baꞌ ba ja aagiꞌñdhaꞌ pim gu ja bopxi gu mambhɨɨx daman gook maamraꞌn gu Israel nam tuꞌ jax buimɨi yaꞌ dhi oiꞌñgaꞌn bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Guꞌ baꞌ gu jaroiꞌ noꞌt cham tuꞌp jim buixdhak gammɨjɨ bañ kaichuꞌ, na cham bhaan ka tɨtɨɨꞌñchokaꞌ gu baꞌkiꞌñ, piam gu sɨspidhiꞌñ, piam gu taataꞌn, piam gu dɨꞌɨɨꞌn, piam gu maamraꞌn, piam gu dɨrbagaꞌn, cham jax bua dho, na guꞌx ioꞌm muiꞌ bhaan ba tu biꞌyaꞌ gatuuk, gio na pu jimiaꞌ jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Guꞌ baꞌ guiꞌ nam xib jir gɇꞌgɇrkam yaꞌ dhi oiꞌñgaꞌn bhaan, kam aayaꞌ gatuuk nam jir cham tuꞌ kaꞌ, guꞌ baꞌ guiꞌ nam xib jir jaꞌppɨx jaꞌtkam yaꞌ dhi oiꞌñgaꞌn bhaan, gatuuk gɇꞌgɇrkam kɨꞌn ji biꞌyaꞌ am jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Baꞌ gu jaroiꞌ noꞌ bhaan ba tɨ nɨidhim gu Dios, jaꞌp ji buusan na jax gu jaroiꞌ noꞌ mu paiꞌ tɨ ɨꞌɨɨx gu bhaidhaꞌ. Baꞌ noꞌ bar am na paiꞌ dhuuk tu uꞌyaꞌ, kapbhuimuk ba ja umuaꞌñdharaꞌ gu tujuandam nam tu uꞌyaꞌ gu bhaidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Baꞌ na paiꞌ dhuuk ba ja tɨgiaꞌ, xi ja aagiꞌñdhaꞌ na jɨꞌk ja namkidhaꞌ gu maaꞌn tanoolh, baꞌ xi ja baidhai miꞌ xi ja chiñiaꞌ nam tɨ ɨꞌkiaꞌ gu bhaidhaꞌ na paiꞌ tɨ ɨꞌɨɨx kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Baꞌ moo jaꞌxpɨx tɇꞌkob paꞌ duuk iam, gio jaiꞌp ma ja umuaꞌñdham gu tujuandam, baꞌ ba ja tɨɨ ɨp jɨꞌkchi nam mummu jaꞌp pɨx daraa ɨrban gu gɇꞌ kiicham nam cham tuꞌ jax bua. ");
INSERT INTO stpNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Baꞌ puiꞌp ba ja tɨtda, jup kaiꞌch: “Aañ bha jam umuaꞌñdham jiñ jaaduñ na pim jiñ palhbuidhaꞌ na pim tɨ ɨꞌkiaꞌ gu bhaidhaꞌ mu nañ paiꞌ tɨ ɨꞌɨɨx.” Baꞌ guiꞌ cham jax ji chɨꞌɨɨk jup ma oi mɨt na mɨt tu juanam. ");
INSERT INTO stpNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Baꞌ nat miꞌ xi ja doꞌñchok, jaꞌxpɨx jix dhaam duuk jaiꞌ giop ma ja umuaꞌñdham. Baꞌ puiꞌp ba ja tɨtda nat paiꞌ dhuuk ba ja tɨɨ nat jax ja tɨɨdak ja baidhak gu jaiꞌ. Baꞌ xi ja baidhak mu xi ja doꞌñchok ɨp. Miꞌ dhɨr baꞌ jaꞌxpɨx mia ji dhunɨɨk, gio jaiꞌp ma ja umuaꞌñdham. Baꞌ ba ja tɨɨ ɨp jaiꞌ, baꞌ puiꞌp ba ja tɨtda nat jax ja tɨɨdak ja baidhak gu jaiꞌ. Baꞌ puiꞌp xi ja baidhak mu xi ja doꞌñchok ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mɨkkat baꞌ nat jix ioꞌm ba ji jur, jaiꞌ giop ma ja umuaꞌñdham mu jaꞌp ɨrban gu gɇꞌ kiicham. Baꞌ ba ja tɨɨ ɨp jaiꞌ nam miꞌ pɨx jaꞌp daraa nam cham tuꞌ jax bua. Baꞌ ba ja tɨkkaꞌ na sap jax kum baꞌ cham tu juan, jup ja tɨtda: “¿Jax ku pim baꞌ cham tu juan jiñ jaaduñ? Yaꞌ pɨx pu daraa japim bɨx chanoolh.” ");
INSERT INTO stpNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Baꞌ guiꞌp kaiꞌch am: “Dho na cham jaroiꞌch umuagiꞌñ dho.” Baꞌ guiꞌp ja tɨtda ɨp gio: “Dho guꞌ aañ bha jam umuaꞌñdham dho na pim jiñ palhbuidhaꞌ na pim tu uꞌyaꞌ gu bhaidhaꞌ mu nañ paiꞌ tɨ ɨꞌɨɨx.” Baꞌ guiꞌ cham jax ji chɨꞌɨɨk jup ma oi mɨt na mɨt tu juanam. ");
INSERT INTO stpNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Baꞌ gatuuk nat paiꞌ dhuuk ba ji chuk, jup tɨtda gu tujuandam tugiꞌñ guiꞌ na miꞌ tɨ ɨꞌɨɨx kaꞌ gu bhaidhaꞌ: “Eap baꞌ xib bhaiꞌ xi ja baiꞌñ guiꞌ na mɨt jich palhbui na mɨt tɨ ɨꞌkɨ gu bhaidhaꞌ, miꞌp xi ja namkidhaꞌ. Bɨɨpɨꞌp bhaiꞌ ji ja namkidhaꞌ guiꞌ na mɨt jɨꞌk jix ioꞌm gatuuk yaꞌ ai, mu jaꞌk jap ji chɨɨmoꞌ ja bui guiꞌ na mɨt jɨꞌk kabuimuk dɨr bhaiꞌ ji chu jua.” ");
INSERT INTO stpNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Baꞌ moo miꞌ ba ai mɨt guiꞌ na mɨt jɨꞌk jix ioꞌm jurnɨk ka tu jua, baꞌ miꞌ xi ja namki mɨt. Baꞌ maaꞌn na mɨt jɨꞌk ja namki na jɨꞌk tum namkiꞌñdhaꞌ gu maaꞌn tanoolh sia ku mɨt tɨi palhɨɨp pɨx tu jua. ");
INSERT INTO stpNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Baꞌ moo jaꞌxpɨx miꞌp ba ai mɨt guiꞌ na mɨt kabuimuk dɨr bhaiꞌ ji chu jua. Baꞌ tɨi ɨlhdhat am nam muiꞌ paꞌ ja namkidhaꞌ gɨt, guꞌ ji na mɨt guꞌ jaꞌkbuiꞌ pɨx jup ja namki na jɨꞌk tum namkiꞌñdhaꞌ gu maaꞌn tanoolh. ");
INSERT INTO stpNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Baꞌ gatuuk na mɨt bɨɨx xi ja namki, bhaiꞌ ji ñiokbo mɨt buiñor guiꞌ na miꞌ tɨ ɨꞌɨɨx kaꞌ gu bhaidhaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","jup tɨtda am: “¿Jax ku pich baꞌ dhiꞌ jaꞌkbuiꞌ pɨx jup ja namki na pich jɨꞌk jich ñamki aach? ¿Cham bhaaiꞌ aa nap muiꞌ paꞌch ñamkidhaꞌ gɨt aach, na chich guꞌ bɨx chanoolh jich chulhii na chich tu jua, gio na bhax chatoiñ? Guꞌ dhiꞌ tɨi palhɨɨp pɨx tu jua mɨt, na mɨt guꞌ jurnɨk yaꞌ ka ai.” ");
INSERT INTO stpNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Baꞌp kaiꞌch guiꞌ na miꞌ tɨ ɨꞌɨɨx kaꞌ gu bhaidhaꞌ: “Aañ cham paiꞌ jax kaiꞌch jiñ jaaduñ nañ cham bɨɨx jam namkidhaꞌ, nañ guꞌ pu jam aagiꞌñ nañ pu jaꞌkbuiꞌ pɨx jam namkidhaꞌ gu maaꞌn tanoolh. ");
INSERT INTO stpNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jaꞌpji na pim cham jax ji kaiꞌchɨt xi gaamui dhi tuumiñ na ñich jam maa, na guꞌ dhiꞌ aañ dɨɨlh jup jix maat na ñich baꞌ jaꞌkbuiꞌp ja namki na ñich jɨꞌk jam namki aapiꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na guꞌ dɨɨlh jir jiñ chumñiꞌ siañ jax bua. ¿Kaꞌ pim ji xiñ jɨɨgam aa nañ jir jix bhaiꞌkam ja bui dhi jaaduñ?” ");
INSERT INTO stpNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Baꞌ miꞌ pɨx juugɨt tu aꞌga gu Jesuus gu dhiꞌ puꞌñi jaꞌk, miꞌ dhɨr baꞌ moop ja tɨtda: ―Baꞌ puꞌñi jaꞌk jup tu ja jimiaꞌ guiꞌ nam xib jir gɇꞌgɇrkam yaꞌ dhi oiꞌñgaꞌn bhaan, gatuuk cham tuꞌ kɨꞌn ji biꞌyaꞌ am. Guꞌ baꞌ guiꞌ nam xib jir cham tuꞌ, gatuuk gɇꞌgɇrkam kɨꞌn jup ji biꞌyaꞌ am jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Baꞌ na paiꞌ dhuuk gamaiꞌ ba jimchuꞌ gu Jesuus bhammɨ jaꞌk Jerusaleen, mu jaꞌp xi ja boosgak dɨlhkob gu mambhɨɨx daman gook noonbiꞌñ, jup ja tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Xib jach baꞌ moo ba jiimchuꞌ bhammɨ jaꞌk Jerusaleen nach jax yaꞌ ba jiim gu xib. Baꞌ aañ nat bhañ joot guñ Gɨꞌkoraꞌ, jiñ dhagiaꞌ am guiꞌ nam xiñ bhaamkiꞌñ gu jaꞌtkam, miꞌ dhɨr baꞌ dai nam jiñ bhɨikaꞌ mu jaꞌk nam paiꞌ darkaꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios gio baꞌ guiꞌ nam jir ja gɇꞌgɇrkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios. Baꞌ maap xim daagɨi ja chiñiaꞌ am gu jaiꞌ jaꞌtkam nam cham jir Israel kam nam jiñ muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Baꞌ guiꞌ bɨɨx aixim xiñ buimɨi kuruus taꞌm jiñ sissapai xiñ muꞌaaꞌ am. Ku baꞌ guꞌ aañ baik tanoolh kɨꞌn yaꞌ ji nañ jax ba oirɨdaꞌ, nañ guꞌ duadɨi giop bamgiaꞌ miꞌ dhɨr koiꞌñgaꞌn tɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Baꞌ gu bɨngaꞌn gu Sebedeo xi ja baidhak gu maamraꞌn muiꞌ ji ai miꞌ na paiꞌp tuꞌiiꞌ gu Jesuus, baꞌ mi jaꞌp oꞌlhiaꞌn kɨꞌn xi kɨkbok soiꞌ jim duu. ");
INSERT INTO stpNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Baꞌ gu Jesuus xi chɨkka na tuꞌ baꞌx aagɨt miꞌ soiꞌ ba tuꞌiiꞌ, baꞌ guiꞌp kaiꞌch: ―Dho nañ puiꞌ tɨi ɨlhiiꞌñ dho nap puiꞌ xi chɨꞌyaꞌ gɨt nam jum sanoop darkaꞌ dhiñ maamar janoꞌ nap paiꞌ dhuuk gɇꞌkam kɨꞌn ba daakaꞌ, maaꞌn kɨɨꞌn dɨr jaꞌk nap chiñiaꞌ na daakaꞌ, maaꞌn baꞌ oꞌnsop dɨr jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Baꞌp ja tɨtda gu Jesuus: ―Matgɨm giilhim jix xijai ji na baꞌ puiꞌ tu tuiꞌkaꞌ gu dhiꞌ puiꞌ na pim jax ɨlhiiꞌñ, na guꞌ bɨɨpɨꞌm aaꞌ na pim giilhim jum tulhiiñaꞌ, jaꞌp na jax aañ. ¿Kaꞌ pim jix ñakooꞌ aa na pim jum tulhiiñaꞌ? Baꞌ guiꞌp kaiꞌch am: ―Jix ñakooꞌ ich ji matgɨm. ");
INSERT INTO stpNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Baꞌp ja tɨtda ɨp gio gu Jesuus: ―Dho guꞌr am dho noꞌ pim guꞌx ñakooꞌ na pim jum tulhiiñaꞌ. Ku baꞌ guꞌ aañ cham jax jam tɨɨdaꞌ ji na moo puiꞌ tu tuiꞌkaꞌ gu dhiꞌ na pim tuꞌ bhaan tu aꞌga, na puiꞌ maaꞌn kɨɨꞌn dɨr jaꞌk jiñ xanoop daakaꞌ, gu jumai baꞌ oꞌnsop dɨr jaꞌk. Na guꞌ dai janoꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan na baꞌx maatɨꞌ kaꞌ na jaroiꞌ bhaiꞌ ji aagaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Baꞌ gu jaiꞌ mambhɨɨx noonbiꞌñ gu Jesuus am bhaak jamɨt ja bui gu jaiꞌ gook nam puiꞌp jir noonbiꞌñ nam jir jum sɨspidhim na mɨt puiꞌ jɨꞌ ja kai. ");
INSERT INTO stpNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Guꞌ ji nat guꞌ gu Jesuus jotmodaꞌ maap xi ja jumpadak jup ja tɨtda: ―Jax dhui na cham jir am na pim moo kɨꞌn jup bax bhaak na pim jix aagɨt na pim jir gɇꞌgɇrkam kaꞌ. Na guꞌ dhiꞌ jaꞌp pɨx ba ji buusan na jax guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñ, puiꞌ na jax guiꞌ nam jix kakaiꞌ kɨꞌn dadarrɨ nam xiꞌ gɇꞌgɇrkam jum taat kaꞌ ja bui gu ja jaꞌtkam tuk, sia ji guꞌ noꞌm jir miamdagaꞌn pɨx, gɇꞌgɇrkam bam taat kaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Guꞌ aapiꞌm matgɨm cham jir am ji na pim moo puiꞌ jaꞌk jup tu jimdaꞌ na jax guiꞌ am. Guꞌ matgɨm noꞌ pim moo baabuiꞌx aaꞌ na pim jir gɇꞌgɇrkam kaꞌ, jum aaꞌ ji na pim soiꞌm duukat ja palhbuiꞌñdhaꞌ gu jaꞌtkam sia nar jaroiꞌ kaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Baꞌ noꞌ puꞌñi aapiꞌm maadɨt jix aaꞌ na pim jir gɇꞌgɇrkam kaꞌ, jum aaꞌ na pim puiꞌm ɨlhiiꞌñdhaꞌ na jax guiꞌ nam puiꞌ pɨx tu juandaꞌ nam cham ja namkiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Na guꞌ sia aañ nat bhañ joot guñ Gɨꞌkoraꞌ, cham tuꞌ gɇꞌkam jiñ ɨlhiiꞌñ iñ, na ñich guꞌ cham tuꞌ pu kaiꞌñkam bha jii yaꞌ dhi oiꞌñgaꞌn bhaan nam baꞌ yaꞌñ palhbuiꞌñdhaꞌ gu jaꞌtkam tuꞌ na pɨx kɨꞌn. Guꞌ jaꞌpji na ñich jaꞌkbuiꞌ kat bha ja palhbuidham ji nañ ja aꞌmkam mukiaꞌ na baꞌ miꞌ dhɨr ba tu namkix kaꞌ gu ja uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Baꞌ nat paiꞌ dhuuk miꞌ dhɨr gamaiꞌ ji jii gu Jesuus na paiꞌr Jerikoo ja bɨɨm gu noonbiꞌñ, muiꞌ jaꞌtkam pɨx chuꞌp jum duu mɨt na mɨt ba oi. ");
INSERT INTO stpNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Baꞌ palhɨɨp gama jaꞌk nam ba bhɨichuꞌ, miꞌ ba daraa am boi jugiiꞌñ gook gu jaꞌtkam nam cham ñiññia kaꞌ. Baꞌ na mɨt puiꞌ ba tɨ kai na gu Jesuus mi jaꞌp jim muiꞌ ja bɨɨm, muiꞌ ji jiñkui mɨt, jup tɨtda am: ―¡Aapiꞌ jich jaduuñ nap jir boxiiꞌñ gu Dabii, iam jap xich joiꞌmdai jich chɨgiaꞌ! ");
INSERT INTO stpNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Baꞌ gu jaꞌtkam nam muiꞌp oiꞌñchuꞌ gu Jesuus, am jix bhaaktuꞌ am, jup ja tɨtda am nam sap cham ñiokat darkaꞌ. Guꞌ ji na mɨt guꞌ guiꞌx ioꞌm ba xi jii nam gɇꞌ kɨꞌn mu jiiñak, jup kaiꞌch am: ―¡Aapiꞌ jich jaduuñ nap jir boxiiꞌñ gu Dabii, iam jap xich joiꞌmdai jich chɨgiaꞌ! ");
INSERT INTO stpNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Baꞌ gu Jesuus miꞌ gan ji kɨkbo, dai na muiꞌ pup tɨ nɨiꞌñ mu nam paiꞌ dhɨr bha jiiñak gu jaꞌtkam guiꞌ nam cham ñiññia kaꞌ, baꞌ xi ja bai nam mu jimiaꞌ. Baꞌ na mɨt paiꞌ dhuuk miꞌ ba ai, jup ja tɨtda: ―¿Tuꞌni aa jam duuk jiñ jaaduñ na pim baꞌ bhañ jiñkuiꞌñ? ");
INSERT INTO stpNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Baꞌ guiꞌp kaiꞌch am: ―Dho nach puiꞌ tɨi ɨlhiiꞌñ dho nap xich dhuduaꞌñdhai gɨt nach cham ñiññia. ");
INSERT INTO stpNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Baꞌ gu Jesuus cham jax ji chɨꞌɨɨk jix ja joiꞌmdak jup xi ja duduaꞌñdhak, dai nat bhaiꞌ pɨx xi ja daa ja buupui am, pux kɨkɨɨꞌp jum duu mɨt miꞌ jotmodaꞌ. Miꞌ dhɨr baꞌ dai na mɨt jaiꞌp ma oi mu jaꞌk na paiꞌ jim. ");
INSERT INTO stpNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Baꞌ bhammɨ amuub ba ai gu Jesuus na paiꞌr Jerusaleen, maaꞌn kap na paiꞌ puiꞌ tɨ tɨɨꞌ Betpajee, sonpan gu oidhaꞌ guiꞌ nam Oliibus kɨꞌn jup jix mat kaꞌ gu jaꞌtkam. Baꞌ ba ja jootos gook gu noonbiꞌñ nam tɨɨmɨlhdhapuꞌ maaꞌn gu bhuruꞌx, ");
INSERT INTO stpNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","jup ja tɨtda: ―Ea na pim mu jimiaꞌ bhammɨni na paiꞌ pɨx jɨꞌdɨlh jir kikcham na pim jiñ chɨɨmɨlhdhapuꞌ maaꞌn gu bhuruꞌx. Miꞌ moo bulhkaꞌ na pim jax yaꞌ dɨr mu aajidhaꞌ. Baꞌ dai na pim jax xi buplhioꞌkai bhaiꞌ pu tɨɨmɨrikaꞌ, bɨɨx sia gu maraaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Guꞌ baꞌ noꞌ guꞌ jaroiꞌ ampɨk ba jam tɨkka na pim jax dhuñiaꞌ gu bhuruꞌx, jaꞌp japim tɨɨdaꞌ: “Dho gu Gɇꞌkam nat bhach joot. Cham maat ich na tuꞌ mi bhiiñoraꞌ, ku baꞌ guꞌ sap jaꞌxñi gio yaꞌp bam aichulhdhaꞌ ji.” ");
INSERT INTO stpNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Baꞌ dhiꞌ puꞌñi jaꞌk tum kuugalh gu puiꞌ nat jax jaꞌk tu uaꞌnak maadɨt guiꞌ nam bɨjɨk bhaankam tu aꞌgimɨk gu Dios na jaꞌpnim kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Xi ja aagiꞌñ gor gu Sion oiꞌñkam na soiꞌ jim duiñchugɨt bhuruꞌx chaꞌm muiꞌ ba jim gu ja gɇꞌkam tuk. Jir bhiꞌññordam gu bhuruꞌx na bhaan jim. ");
INSERT INTO stpNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","7","Baꞌ gu noonbiꞌñ cham jax ji chɨꞌɨɨk muiꞌp ma jii mɨt mu nat paiꞌ ja joot gu Jesuus. Baꞌ puiꞌ ji chu buus na jax ja tɨtda, miꞌ bulh gu bhuruꞌx na paiꞌ tu ja aagiꞌñ, baꞌ guiꞌ dai na mɨt jax buplhioꞌ xi chɨɨmɨrak jamɨt bɨnkam gu maraaꞌn. Baꞌ mu ja aichdhak bhaiꞌ xi ja bakxi mɨt gu ja kuktun, baꞌ gu Jesuus maaꞌn bhaiꞌ xi dhaibuk gamaiꞌ pɨx chuꞌm duu bɨɨx boi. ");
INSERT INTO stpNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Baꞌ gu jaꞌtkam joidham jix bhaiꞌ jim taatugɨt bɨɨpɨꞌ dɨr bapoiꞌdhat ja kookosidhat miꞌ ja iabuim am boi chaꞌm gu ja kuktun, nam guꞌx ioꞌm muiꞌ mu jiim nam oiꞌñchuꞌ gu Jesuus, gam jaiꞌ gu tua jaajaꞌ nam omsaidhat miꞌ iabuim miꞌ na paiꞌ jax bhɨɨjim gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Baꞌ nam puiꞌ xi chu buidhat pɨx jiiñak bɨttu am bɨɨx guiꞌ nam jɨꞌk bɨɨpɨꞌ dɨr jiim gio guiꞌ nam gatuuk dɨr jup jiim, jup kaiꞌchim am: ―¡Taxchaab baꞌ guch Gɨꞌkoraꞌ nat bhaiꞌ bach joochxi gu boxiiꞌñ gu Dabii guiꞌ na bɨjɨk yaꞌr gɇꞌkam kat! ");
INSERT INTO stpNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Baꞌ jaꞌxpɨx nat paiꞌ dhuuk bhammɨ ba ai gu Jesuus na paiꞌr Jerusaleen, cham maat am gu bhaiꞌ oiꞌñkam nar jaroiꞌ dhaꞌ. Naiꞌ tɨim tɨ tɨkka am, jup kaiꞌch am: ―¿Jaroo chi baꞌ daꞌ dhi maaꞌnkam? ");
INSERT INTO stpNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Baꞌ jaiꞌ dhɨt jup kaiꞌch am: ―Dho dhiꞌ dhor diꞌ gu Jesuus guiꞌ na bhaankamuꞌn tu aꞌga gu Dios, guiꞌ na mummɨ kio Nasareet guiꞌ na miꞌ bipioꞌ na paiꞌ jax jir Galilea. ");
INSERT INTO stpNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Baꞌ jaꞌxpɨx mu jaꞌk jup ba ai gu Jesuus na paiꞌr gɇꞌ chiop, baꞌ miꞌ pɨx ji ja tɨɨ gu jaꞌtkam nam jix ioꞌm muiꞌ mɨjɨ tu gaꞌra gu bɨxchuꞌ. Baꞌ bɨɨx miꞌ dhɨr jaꞌk ji ja aadi nam jɨꞌk bhaiꞌ ka tu gaꞌra gio guiꞌ nam bhaiꞌ ka tu sabaꞌn, ja iaꞌlhxichulh gu ja memees guiꞌ nam bhaiꞌ bhaan ka tuaꞌ gu tuumiñ nam bhaiꞌ ja pataaxiꞌñ gu jaꞌtkam kɨꞌn gu jaiꞌ tuumiñ, gio baꞌ guiꞌ nam giokdaꞌ bhaan bhaiꞌp ka ja kuup nam bhaiꞌ ka ja gaꞌra, bɨɨx jup ja iaꞌlhxichulh. ");
INSERT INTO stpNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Baꞌp ja tɨtda puiꞌ xi ja doodak: ―¿Kux cham maat japim aa nap jum kaiꞌch gu ñioꞌkiꞌñ guñ Gɨꞌkoraꞌ miꞌ na paiꞌ tu uaꞌñix: “Dhi chiop nat miꞌm kɨi, miꞌ dhɨr jix bhaaiꞌ nam bha tuñ aꞌgiꞌñdhaꞌ gu jaꞌtkam soiꞌ jim ɨlhdhat”? Aapiꞌm guꞌ ya jaꞌp tuꞌiiꞌ na jax paiꞌ noꞌm jum jumpaꞌn gu ɨꞌxkum. ");
INSERT INTO stpNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Baꞌ na pui bhaiꞌ ka oirɨ gu Jesuus na paiꞌr gɇꞌ chiop, bhaiꞌ ba ai mɨt jɨꞌkchi gu jaꞌtkam nam cham ñiññia kaꞌ gio baꞌ jaiꞌ guiꞌ nam jix mamaꞌmkulhiꞌ kaꞌ, baꞌ soiꞌ ba tɨtda am na ja duduaꞌñdhaꞌ. Baꞌ guiꞌ cham jax ji chɨꞌɨɨk jix ja joiꞌmdak jup xi ja duduaꞌñ, jix kɨkɨɨꞌ mɨt jup jum duu. ");
INSERT INTO stpNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Baꞌ giilhim bhaiꞌ ji bhaak jamɨt gu ja gɇꞌgɇrkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, na mɨt tɨɨ gu Jesuus nat ja duduaꞌñ gux kakoꞌk kam. Gio guꞌ gu aꞌaalh miꞌ dhɨr jaꞌp pɨx jiiñak jup bɨɨt am nam jix bhaiꞌm taat buiñor gu Jesuus, jup kaiꞌch am: “Taxchaab baꞌ guch Gɨꞌkoraꞌ nat bhaiꞌ bach joochxi gu boxiiꞌñ gu Dabii guiꞌ na bɨjɨk yaꞌr gɇꞌkam kat.” ");
INSERT INTO stpNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Baꞌp tɨtda am gu Jesuus gu gɇꞌgɇrkam jum aaꞌndam: ―Jaꞌp xi ja tɨɨꞌn nam cham ñiokdaꞌ dhi aꞌaalh. Moo jaꞌp ja kɇɇ ap pɨx nam jax kaiꞌch. Baꞌp ja tɨtda gu Jesuus: ―Dho jax gip bua siam jax kaiꞌch, na guꞌ puiꞌm kaiꞌch gu ñioꞌkiꞌñ guñ Gɨꞌkoraꞌ miꞌ na paiꞌ tu uaꞌñix na saak siax bhaaiꞌ gu aꞌaalh nam tu daandaꞌ buiñor gu Dios, sia guiꞌ nam ka xioꞌdaꞌ. ¿Cham aa pim jɨꞌxkat tu jiñkuiꞌñ miꞌ na paiꞌ puꞌñim kaiꞌch? ");
INSERT INTO stpNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Baꞌ daipuꞌ xi ja tɨɨdak gu Jesuus miꞌ dhɨr pu jii mu jaꞌk na paiꞌr Betaania, miꞌ baꞌ gan ji chɨbia. ");
INSERT INTO stpNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Baꞌ kabuimuk nat giop ba xiaꞌ, ma jii ɨp gio gu Jesuus bhammɨ jaꞌk gɇꞌ kiicham. Baꞌ na gamaiꞌ ka jimchuꞌ, am jix bhiogɨm ba tu tatdatuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Baꞌ ba tɨɨ na mu jaꞌp kɨɨk boi jugiiꞌñ maaꞌn gu iigɨx, baꞌ muiꞌ ma jii nat tɨɨgim. Baꞌ na bha jaꞌp tɨi xi ñɨnɨiꞌñ, pu nim maaꞌn kut tɨɨ gu iibhaiꞌñgaꞌn, baꞌp kaiꞌch: ―Alh moo cham jɨꞌxkat ka iibhaiꞌñchaꞌ dhi iigɨx. Baꞌ moo janoꞌ nat jax pu tɨɨꞌn, pu miꞌ naiꞌ ji gaa gu iigɨx. ");
INSERT INTO stpNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Baꞌ miꞌ puiꞌ pup tuꞌiiꞌ am gu noonbiꞌñ na mɨt puiꞌ jɨꞌ tɨ tɨɨ, jaꞌxpɨx baꞌ ba tɨkka am gu Jesuus nat jax dhuukat naiꞌ ji gaa gu iigɨx nat jax pu tɨɨꞌn na cham ka iibhaiꞌñchaꞌ, jup tɨtda am: ―¿Jax chi kut baꞌ moo jotmodaꞌ naiꞌ ji gaa dhi iigɨx na pich jax pu tɨɨꞌn na cham ka iibhaiꞌñchaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Baꞌp ja tɨtda gu Jesuus: ―Dho na bhaan jix maatɨꞌ kaꞌ na cham tuꞌ daipuꞌ puꞌñix bhaaiꞌ na pim pu tu duñiaꞌ noꞌ pim jix biiñak buiñor guñ Gɨꞌkoraꞌ, guꞌ jaꞌpji sia ji guꞌñi oidhaꞌ noꞌ pim jax tɨtda: “Eap yaꞌ dɨr jaꞌk jim muni jaꞌk na paiꞌ gɇꞌ suuꞌn gu suudaiꞌ”, dho guꞌ puiꞌ dho ji chu buusniaꞌ noꞌ pim bɨɨx jam jujur kɨꞌn tɨ jɨɨgiꞌñ na puiꞌ ji chu buusniaꞌ na pim jax tɨꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Guꞌ baꞌ puꞌñi ɨp noꞌ pim bɨɨx jam jujur kɨꞌn jix biiñak buiñor guñ Gɨꞌkoraꞌ, jam makiaꞌ dho tuꞌ na pim taandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Baꞌ gio miꞌp ba ai gu Jesuus na paiꞌr gɇꞌ chiop. Baꞌ na miꞌ ka tu ja aꞌgiꞌñ gu jaꞌtkam, miꞌ ba ai mɨt gu ja gɇꞌgɇrkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio baꞌ guiꞌ nam jir ja gɇꞌgɇrkam tuk kaꞌ gu Israel kam jaꞌtkam. Baꞌ bhaiꞌ ba tɨkka am, jup tɨtda am: ―¿Jax jap baꞌ kaiꞌñkam yaꞌ pu tu bua? ¿Jaroom chianɨk bham joot nap yaꞌ pu tu duñiaꞌ nap dɨɨlh jax ɨlhiiꞌñ? ");
INSERT INTO stpNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Baꞌ gu Jesuus jup ja tɨtda: ―Dho ea nañ aañ maaꞌn jup xi jam tɨkkaꞌ gu tuꞌx buadam na jax jir jum duukam. ¿Jaroo bha joot saak gu Juan na ja bopkonaꞌ gu jaꞌtkam? ¿Dios aa, kaꞌ dɨɨlh aa mɨt chia gu jaꞌtkam na ja bopkonaꞌ? Ea gor xiñ aagiꞌñ nañ baꞌ aañ jup jam aagiꞌñdhaꞌ. Baꞌ guiꞌ dai na mɨt ba jim tɨ tɨkka dɨɨlh, jup kaiꞌch am: ―¿Jax jach jaꞌk tɨɨdaꞌ? Na guꞌ noꞌch jax kaiꞌch nat gu Dios bha joot gu Juan, puiꞌ dho ji chɨꞌyaꞌ: “¿Guꞌ jax ji ku pimɨt baꞌ cham miꞌ puiꞌ jii na jax tɨi pup tu jam aꞌgidhimɨk?” ");
INSERT INTO stpNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Gio noꞌ chich jax tɨip xi chɨɨꞌn na mɨt dɨɨlh chia gu jaꞌtkam na ja bopkonaꞌ, bhaakuim dhoch maꞌyasai joodai kɨꞌn jich koodaꞌ, nam guꞌ bɨɨx pɨx tɨ jɨɨgiꞌñ na gu Juan bhaankam tu aꞌgimɨk gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Baꞌ puiꞌ cham bhaaiꞌ nam jax tɨɨdaꞌ, dai nam jup tɨtda pɨx: ―Chaam ji nach maat nat jaroiꞌ bha joot gu Juan. Baꞌp ja tɨtda gu Jesuus: ―Dho bak aañ puiꞌ cham jup jam aagiꞌñdhaꞌ ku gi nat jaroiꞌ bhañ joot nañ baꞌ yaꞌ puiꞌ tu bua. ");
INSERT INTO stpNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Baꞌ moo miꞌ dhɨr jaꞌpni bhaiꞌp ba ja tɨkka gu Jesuus, jup kaiꞌch: ―¿Aapiꞌm jax ɨlhdhat kɇɇ? Puiꞌ na jax maaꞌn gu maaꞌnkam noꞌ gook tu maamar, baꞌ noꞌ maaꞌn jax tɨtda: “Ea nap mu jimiaꞌ mu gaa tɨr nap tu juanmɨraꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Baꞌ noꞌ guꞌ jax kaiꞌch pɨx gu maraaꞌn: “Aañ cham. Aañ moox ooꞌn. Cham paiꞌ jimiim jiñ ɨlhiiꞌñ iñ.” Baꞌ na puiꞌ xi kaiꞌchimɨk jaꞌxpɨx siamri dɨkoo ma jii. ");
INSERT INTO stpNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Guꞌ baꞌ gu jumai puiꞌp ba tɨtda ɨp, guiꞌ dho gi guꞌx bhaiꞌm taatɨt jup kaiꞌch ji: “Ea ku gi nañ moo mu jimiaꞌ.” Baꞌ daipuꞌ xi chɨꞌɨɨk pu cham muiꞌ ba ji jii, pu cham jɨꞌxkat dho guꞌ mu jii mu nat paiꞌ joot gu taataꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Baꞌ miꞌ dhɨr jup ja tɨtda gu Jesuus: ―¿Jax chuꞌm gu gook jii mu nat paiꞌ joot gu taataꞌn nam tu juanpuꞌ? Baꞌ guiꞌp kaiꞌch am: ―Dho guiꞌ nat jax bɨɨpɨꞌ dɨr pu tɨɨꞌn dho. Baꞌp ja tɨtda ɨp gio gu Jesuus: ―Dho aapiꞌm puꞌñip ji buusan na jax guiꞌ nat pu cham jii mu nat paiꞌ joot gu taataꞌn. Guꞌ baꞌ dhiꞌ jaꞌp jir jum duukam nam bɨɨpɨꞌ jimiaꞌ jix dhaam jaꞌk buiñor gu Dios guiꞌ nam jir tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam, gio gu uꞌuub guiꞌ nam jir ganaiꞌ pɨx kaꞌ. Guꞌ baꞌ aapiꞌm cham, sia ku pim puiꞌ tɨi xi ɨlhiiꞌñ na pim aapiꞌm bɨɨpɨꞌ jimiaꞌ gɨt jix dhaam jaꞌk, ");
INSERT INTO stpNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","na pimɨt guꞌ cham miꞌ puiꞌ jii na jax tɨi pup tu jam aꞌgidhimɨk gu Juan jaꞌtkam bopkondam, dai na pimɨt tuꞌ pɨx ɨlh. Guꞌ gu tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam, sia kum giilhim tɨix uꞌuaꞌtulhdhix, gio gu uꞌuub guiꞌ nam jir ganaiꞌ pɨx kaꞌ, moo janoꞌ soiꞌ jim ɨlhdhak miꞌ puiꞌ jii mɨt nat jax tu ja aꞌgi gu Juan. Guꞌ aapiꞌm pu cham miꞌ puiꞌ jii ji, sia ku pimɨt tɨi kai nat jax tu aꞌga gio na pimɨt jax tɨɨ nat joidham jix bhaiꞌ tu duu. ");
INSERT INTO stpNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Miꞌ dhɨr baꞌ moo jaꞌpni bhaan ji uaꞌrgidhak bhaiꞌp ji chu aꞌga gu Jesuus, jup ja tɨtda: ―Kani na pim moo jumaip xiñ kaayaꞌ nañ tuꞌ bhaan jup tu jam aꞌgidhaꞌ. Maaꞌnnim maaꞌn gu maaꞌnkam tu darsak gu uubas gio baꞌ nat tu kuu miꞌ nat jɨꞌx juugɨt tu darai. Miꞌ dhɨr baꞌ moo tu echkai ɨp miꞌ na paiꞌx bhaiꞌn kaꞌ nam ba kɨiꞌdaꞌ, gio baꞌ nat miꞌ kɨi ɨp maaꞌn gu tɇb bhiꞌñbak na baꞌ bhaiꞌ dhɨr bhaan daakat naiꞌ tɨ nɨiꞌñdhaꞌ na tu nuukaꞌndaꞌ. ’Guꞌ ji na guꞌ moo ampɨk jup bar jimdam mɨk jaꞌk. Baꞌ miꞌ ka xi ja doꞌñchok jɨꞌkchi gu jaꞌtkam nam miꞌ ka tu juandaꞌ pu jii baꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Baꞌ nat paiꞌ dhuuk ba bhai gu uubas, muiꞌ ba ja joot gu tujuandam tugiꞌñ mu nat paiꞌ ka xi ja doꞌñchok gu jaiꞌ tujuandam tugiꞌñ nam uaꞌpuꞌ guiꞌ na jɨꞌk bhaan bipioꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Guꞌ ji na guꞌ na mɨt paiꞌ dhuuk tɨi mu ba ai gu tujuandam guiꞌ nat mu ja joot, dai na mɨt bhaiꞌ ji ja daꞌngɨ, ja gɨbiimɨk am, jaiꞌ mɨt pu ja koi, jaiꞌ baꞌ dai na mɨt joodai kɨꞌn xi ja maꞌyasak gio puiꞌ mɨjɨp xi ja joot. ");
INSERT INTO stpNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Baꞌ gatuuk jaiꞌ muiꞌ tɨip ja joot, muiꞌ paꞌ iam, cham tuꞌ jaꞌkbuiꞌ nat jɨꞌk mu ja joot bɨɨpɨꞌ dɨr, guꞌ ji na guꞌ maaꞌn na mɨt jax ja dooda. ");
INSERT INTO stpNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Guꞌ baꞌ mɨkkat na cham ka jaiꞌch na jaroiꞌ muiꞌ ka jootsaꞌ, dai gu maraaꞌn pɨx ba bii guiꞌ nax ioꞌm jix dhaꞌdaꞌ. Baꞌ puiꞌ muiꞌp ma joot jup xi chɨꞌɨɨk: “Dhiꞌ dho gi guꞌ chi jɨɨgiꞌñdhaꞌ am ji, nam guꞌx maat na aañ jir jiñ mar.” ");
INSERT INTO stpNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Guꞌ ji nat guꞌ cham puiꞌ ji chu buus nat paiꞌ dhuuk mu tɨip ba ai gu maraaꞌn. Jup kaiꞌch am dɨɨlh jix dhuꞌnpiꞌñ kɨꞌn gu tujuandam: “Dhiꞌ moo bhaan ji chu biꞌyaꞌ bɨɨx na jɨꞌk tuꞌ yaꞌx chu jaiꞌch noꞌt ba muu gu taataꞌn. Jaꞌpji nar am ji nach muꞌaaꞌ na baꞌ aach jich aꞌm ji chu biꞌyaꞌ kapbhaiꞌ nat dɨɨlh yaꞌ ka ai.” ");
INSERT INTO stpNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Baꞌ puiꞌ xi chɨꞌɨɨk bhaiꞌ ji dhaa mɨt, baas dɨr jaꞌp koraar bɨɨbhiꞌ mɨt xi baidhak xi muꞌaak. ");
INSERT INTO stpNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’¿Guꞌ baꞌ aapiꞌm jax ɨlhiiꞌñ na ja doodaꞌ dhiꞌ dhi tujuandam na mɨt buam pɨx tu dooda na paiꞌ dhuuk miꞌ aayaꞌ guiꞌ nat miꞌ tu darsak gu uubas? ");
INSERT INTO stpNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Baꞌ guiꞌp kaiꞌch am: ―Dho guꞌ ja koodaꞌ dho jia, jaiꞌ baꞌ miꞌ ja iabuꞌ gu tujuandam, nam baꞌ miꞌ dhɨr ba maakidhaꞌ guiꞌ na jɨꞌk bhaan bipioꞌdaꞌ na paiꞌ dhuuk bax bhai kaꞌ gu uubas. ");
INSERT INTO stpNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Baꞌp ja tɨtda ɨp gio gu Jesuus: ―¿Cham aa pim jɨꞌxkat tu jiñkuiꞌñ gu ñioꞌkiꞌñ gu Dios miꞌ na paiꞌ tu uaꞌñix na jaꞌpnim kaiꞌch: Gu jodai na mɨt maiꞌ xi buak gu bhibhiꞌñbakchadam, guꞌ ji nat guꞌ gio miꞌp dai guch Gɨꞌkoraꞌ na baꞌ bhaan darkaꞌ gu jaiꞌ joodai, na guꞌ puiꞌ jaꞌk jix aaꞌ, baꞌ aañ joidham jix bhaiꞌñ chaat buiñor gu dhiꞌ puiꞌ nat jax tu duu? ");
INSERT INTO stpNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Baꞌ aapiꞌm puꞌñip ji buusan na jax gu bhibhiꞌñbakchadam na mɨt maiꞌ xi buak gu jodai gux kɨɨꞌ, baꞌ cham jɨꞌxkat aayaꞌ pim jix dhaam jaꞌk buiñor gu Dios. Dai guiꞌ nam jɨꞌk miꞌ puiꞌ jiim na jax jix aaꞌ nam baꞌ jimiaꞌ buiñor. ");
INSERT INTO stpNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Baꞌ aañ yaꞌ pu jam tɨtda na pu taꞌtak jup jum duñiaꞌ gu jaroiꞌ noꞌt bhaan jutbuk ia dhiꞌ dhix kɨɨꞌ jodai. Piam ku guꞌ noꞌt jax dhuukat bhaan gɨi gu jaroiꞌ noꞌ miꞌ paiꞌ ka oirɨ, pu matai dhop jum duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Baꞌ tɨix dhaagik am gu Jesuus gu gɇꞌgɇrkam jum aaꞌndam, nam guꞌx maat na dhiꞌ ja aagɨt jup kaiꞌch nat tu aꞌga bhaan ji uaꞌrgidhak gu tujuandam na mɨt buam pɨx tu dooda. ");
INSERT INTO stpNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Guꞌ ji nam guꞌ moop jix ja ɨɨbhiꞌñ gu jaꞌtkam, nam guꞌ bɨɨx pɨx jix bhaiꞌx mat kaꞌ na gu Jesuus sɨlhkam Dios bhaankamuꞌn tu aꞌgadaꞌ. Baꞌ puiꞌ cham jɨꞌxkat jax dhooda mɨt gu miꞌ jotmodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Baꞌ gio bhaiꞌp ji chu ja aꞌgi gu Jesuus gu jaꞌtkam bhaan ji uaꞌrgidhak maaꞌn gu maaꞌnkam nam tɨɨmoꞌ, jup ja tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Baꞌ na jax jaꞌk ja aꞌm tɨ nɨidhidhaꞌ gu Dios gu jaꞌtkam, jaꞌp ji buusan na jax maaꞌn gu gɇꞌkam noꞌ mu paiꞌ ba xim tɨɨmom gu maraaꞌn, ");
INSERT INTO stpNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","na ba ja jootsaꞌ gu tujuandam tugiꞌñ nam ja baiꞌñpuꞌ gu jaꞌtkam nam tu jugiaꞌ gu koiꞌ. Guꞌ ji na guꞌ ni jɨꞌx kum cham aaꞌ nam paiꞌ dhuuk mu jaꞌp puiꞌ tɨi ba ja tɨtdaim, puiꞌ mɨt giop ba jii gu tujuandam tugiꞌñ gu gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Baꞌ gatuuk jaiꞌ gio muiꞌ tɨip ja joot jup xi ja tɨɨdak: “Ea na pim aapiꞌm muiꞌp jimiaꞌ na pim ja baiꞌñpuꞌ gu jaꞌtkam nam yaꞌni tu jugiaꞌ gu koiꞌ. Jaꞌp japim ja tɨɨdaꞌ na yaꞌ bax chu bhai, na ñich guꞌ tu chia gu tutuur gux dhudua kam nam ja koodai tu jidhooraꞌ gu bakaax.” ");
INSERT INTO stpNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Guꞌ ji na mɨt guꞌ sia cham aa gu jaꞌtkam nam mu tu koiꞌpoꞌ nam paiꞌ dhuuk mu jaꞌp puiꞌ tɨi ba ja tɨtdaim gu tujuandam tugiꞌñ gu gɇꞌkam. Maaꞌn dai nat mu jaꞌk ji dhuu na paiꞌ tu gaꞌmbhar, maaꞌn baꞌ mu jaꞌk jup ji dhuu na paiꞌ tu juandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Gu jaiꞌ baꞌ dai na mɨt bhaiꞌ ji ja daꞌngɨ gu tujuandam tugiꞌñ gu gɇꞌkam, ja gɨbiimɨk jamɨt mi jaꞌp xi ja koodak. ");
INSERT INTO stpNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Baꞌ gu gɇꞌkam giilhim bhaiꞌ ji bhaam na mɨt ja koi gu tujuandam tugiꞌñ. Mu ja joot dho guꞌ gu sandaaruiꞌx chugiꞌñ nam puiꞌp ja koodaꞌ guiꞌ na mɨt jup tu dooda, gio nam pup xi ja mɨmɨidhaꞌ gu ja baꞌbhak. ");
INSERT INTO stpNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Miꞌ dhɨr baꞌ moop ja tɨtda gu jaiꞌ tujuandam tugiꞌñ: “Dho guꞌ yaꞌ tɨi bax chu bhai dho dhi koiꞌ, guꞌ ji na mɨt guꞌ cham aa guiꞌ na ñich muiꞌ tɨi tu ja joochxi nam bha tu koiꞌpoꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ea na pim aapiꞌm muiꞌp jimiaꞌ mu jaꞌp ɨrban gu gɇꞌ kiicham na pim ja baiꞌñpuꞌ gu jaꞌtkam nam yaꞌni tu jugiaꞌ. Bɨɨx japim bha ja baidhikaꞌ na pim jɨꞌk mi jaꞌp ja tɨgiaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Baꞌ muiꞌp ma jii mɨt gu tujuandam tugiꞌñ gu gɇꞌkam mu jaꞌp ɨrban gu gɇꞌ kiicham, baꞌ bɨɨx ja baidhak jamɨt na mɨt jɨꞌk mi jaꞌp ja tɨɨ, sia guiꞌ nam giilhim jix buam tomaat kaꞌ gio guiꞌ nam jir jix bhabhaiꞌkam kaꞌ. Suuꞌn jamɨt mɨjɨ baꞌk chɨr miꞌ na paiꞌr koiꞌcham kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Baꞌ jaꞌxpɨx nat paiꞌ dhuuk miꞌ ba baa gu gɇꞌkam, ba tɨɨ na maaꞌn cham pu chuꞌm tɨ tɨiꞌchuꞌ na jax chuꞌm tɨm tɨtɨꞌ na baꞌx bhaaiꞌn kaꞌ nañ mu bakiaꞌ miꞌ paiꞌ noꞌ puꞌñir koiꞌcham kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Baꞌp tɨtda: “¿Jax japich dhuuk ya baañ jaduuñ? Nap moo cham pu chuꞌm tɨ tɨiꞌchuꞌ na jax chuꞌm tɨm tɨtɨꞌ na baꞌx bhaaiꞌn kaꞌ nañ mu bakiaꞌ miꞌ paiꞌ noꞌ puꞌñir koiꞌcham kaꞌ.” Baꞌ cham ñiok guiꞌ na miꞌ puiꞌ tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Baꞌp ja tɨtda gu gɇꞌkam guiꞌ nam miꞌ tu bhiijim gu koiꞌ: “Ea gor buuprak gu tootnaꞌn gio gu noonbiꞌñ mu buañ dɨɨrap dhi maaꞌnkam miꞌ na paiꞌ giilhim jix chukgam na tɨi suakdaꞌ na giilhim jix buam jum aaꞌndaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Baꞌ puꞌñi tɨip jix aaꞌ gu Dios nam gɨt muiꞌ tɨ jɨɨꞌñdhai gu jaꞌtkam miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ, guꞌ ji na guꞌ jɨꞌk pɨx nam baꞌx aaꞌ nam miꞌ puiꞌ jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Baꞌ bhaakuk miꞌ dhɨr pu jii mɨt guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ. Baꞌ tɨi bɨɨx maap xim jumpadak ma tu aꞌga mɨt nam jax dhui maiꞌchiaꞌ gɨt gu Jesuus na pu tɨꞌyaꞌ gɨt na jax cham puiꞌ jaꞌk tu aagix kaꞌ nam baꞌ puiꞌ ji chɨꞌji iattulhdhai tu chiñiaꞌ nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Baꞌ muiꞌ tɨi ja joot jamɨt jɨꞌkchi gu ja jaꞌtkam tuk ja bɨɨm gu Eroodis gu jaꞌtkam tugiꞌñ nam sap tɨkkapuꞌ gu Jesuus, katti sap iam maakam pɨx tɨꞌyaꞌ gɨt na jax cham puiꞌ jaꞌk tu aagix kaꞌ nam baꞌ puiꞌ ji chɨꞌji iattulhdhai tu chiñiaꞌ nam muꞌaaꞌ. Baꞌp tɨtda am mu ji ɇɇk: ―Jiñ jaduuñ, aach tɨ jɨɨgiꞌñ nap sɨlhkam jup kaiꞌchdhaꞌ nap paiꞌ dhuuk tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam, jir sɨlhkam nap jax ja tɨtdadaꞌ na puiꞌ jaꞌk jix aaꞌ gu Dios, gio na maaꞌn nap jax ja ɨlhiiꞌñ gu jaꞌtkam sia nar jaroiꞌ kaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Baꞌ aach jaꞌp tuꞌm bham tɨkkam jich jaduuñ, ¿jir am aa nach namkiꞌñdhaꞌ gux ioꞌm gɇꞌkam Rooma kam Seesar tɨɨgim na jɨꞌk aagix nach namkiꞌñdhaꞌ, kaꞌ cham aa? ");
INSERT INTO stpNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Guꞌ ji na guꞌx bhaiꞌx maat gu Jesuus nam jax kaiꞌñkam jup tɨtda, baꞌp ja tɨtda: ―¿Jax ku pim baꞌ moo jaꞌp tɨi xiñ maiꞌchim jiñ jaaduñ? ");
INSERT INTO stpNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ea gor maaꞌn bhañ chaiñbuiꞌñ gu tuumiñ guiꞌ na kɨꞌn tum namkiꞌñ na jɨꞌk aagix nam namkiꞌñdhaꞌ gux ioꞌm gɇꞌkam Rooma kam. Baꞌ guiꞌ maaꞌn jup xi bhɨidham jamɨt gu tuumiñ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Baꞌ gu Jesuus xi dhaagɨk miꞌ xi chɨɨgɨk jup ja tɨtda: ―¿Jaroo daꞌ dhiꞌ na yaꞌ jupñix bhaan dhi tuumiñ, gio na jaroiꞌ miꞌ uaꞌñix na jax chɨɨꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Baꞌ guiꞌp kaiꞌch am: ―Dho gux ioꞌm gɇꞌkam Rooma kam dho. Baꞌp ja tɨtda ɨp gio gu Jesuus: ―Dho pim xi maakidhat ku gi gux ioꞌm gɇꞌkam Rooma kam na jɨꞌk bhaan jup bipioꞌdaꞌ, gio gu Dios japim jup xi maakidhat na jɨꞌk bhaan jup bipioꞌdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Baꞌ pu cham ka ñio mɨt guiꞌ nam miꞌ tɨkka, dai nam miꞌ puiꞌ pup tuꞌiiꞌ jɨꞌx juugɨt. Miꞌ dhɨr baꞌ dai na mɨt ba jii cham jax ji chɨꞌɨɨk. ");
INSERT INTO stpNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Baꞌ moo janoꞌ miꞌp ba ai mɨt ɨp guiꞌ nam saduseos jum tɨɨtɨꞌndaꞌ, guiꞌ nam cham tɨ jɨɨgiꞌñdhaꞌ nam gio mu paiꞌp ba oipodaꞌ guiꞌ nam jɨꞌk ba koꞌiix kaꞌ gu ja tutkuꞌ am bhaan. Baꞌ bhaiꞌ ba tɨkka am gu Jesuus, jup tɨtda am: ");
INSERT INTO stpNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Aach bhaiꞌ ma jii jich jaduuñ na chich bham tɨkkam gu puiꞌ nat jax jaꞌk tu uaꞌnak gu Moisees, na sap noꞌt maaꞌn ba muu gu maaꞌnkam, noꞌt dɨɨlh miꞌ ji bii gu bɨngaꞌn, noꞌ cham maaꞌn bhaan tu mar kat, jix bhaiꞌ na bhaiꞌ ji bhɨɨyaꞌ gu sɨpdhiꞌñ guiꞌ na miaꞌn oiꞌñdhaꞌ na baꞌ bhaan ba tu mar kaꞌ, na baꞌ jaꞌp ji buusniaꞌ nar dhiꞌ kaꞌ gu xioꞌgiꞌñ guiꞌ na ba mukiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Guꞌ ji nam guꞌ moo jaꞌpnip tu aꞌgadaꞌ gu jaꞌtkam nam sap mu paiꞌ oiꞌñkat xijum gook gu jaꞌtkam daim sɨspidhim. Sap baꞌ moo tɨi ba tɨ bɨɨnaꞌ kat guiꞌ nar bɨɨpɨꞌ kam, guꞌ ji nat sap guꞌ am xi muu, pu cham sap maaꞌn bhaan tu mar kat gu ubii. Sap baꞌ gu sɨpdhiꞌñ guiꞌ na miaꞌn oiꞌñ guiꞌ nat ba muu, tɨix bhaiꞌ ba tɨɨdak gu nuuchixiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Guꞌ ji nat sap guꞌ puiꞌ am jup xi muu, puiꞌ sap cham maaꞌn jup tɨɨgɨk jamɨt gu alhii. Gio gu tɨꞌɨraab kam sap puiꞌ tɨix bhaiꞌp ba tɨɨdak ɨp, guꞌ ji nat sap guꞌ puiꞌ am jup xi muu. Pu bɨɨx dho sap koi mɨt gu xijum gook tɨi pup bhɨbhɨɨjimɨk, pu cham sap jaroiꞌ maadɨt bhaan tɨɨgɨk gu alhii. ");
INSERT INTO stpNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mɨkkat sap bɨɨx am jup xi muu gu ubii. ");
INSERT INTO stpNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Guꞌ baꞌ gu xijum gook gu jaꞌtkam nam tɨi pup bhɨbhɨɨjimɨk gu ubii, ¿jax chuꞌm baꞌ pɨk gio bhaiꞌp ji bhɨɨyaꞌ janoꞌ nam paiꞌ dhuuk saak gio mu paiꞌp ba oipodaꞌ sia ku mɨt tɨi ba koi gu ja tutkuꞌ am bhaan? ");
INSERT INTO stpNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Baꞌp ja tɨtda gu Jesuus: ―Dho jax dhui na pim guꞌ cham maat gu puiꞌ na jax tu uaꞌñix gu ñioꞌkiꞌñ gu Dios, ni na pim jix maat na jax jir gɇꞌkam na pu tu duñiaꞌ na jax ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Guꞌ matgɨm guiꞌ nam jɨꞌk koꞌiim nam gio mu paiꞌp ba oipodaꞌ, cham tuꞌ bhaan ka tɨtɨɨꞌñchokaꞌ am ji, na guꞌ dai yaꞌ dhi oiꞌñgaꞌn bhaan nam baꞌx aaꞌndaꞌ nam tɨ bɨpnaꞌ kaꞌ. Guꞌ noꞌm maakam jaꞌk ba oipo, jaꞌppɨx ba ji buandaꞌ am ji na jax gu noonbiꞌñ guñ Gɨꞌkoraꞌ guiꞌ nax dhaam jup tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Gio guꞌx bhaiꞌx maatɨꞌ nam bhaiꞌ paiꞌ aajim maaꞌn kap guiꞌ nam jɨꞌk koꞌiim gu ja tutkuꞌ am bhaan, na guꞌ puiꞌm kaiꞌch bo gu ñioꞌkiꞌñ gu Dios miꞌ na paiꞌ tu uaꞌñix bhaan gu uꞌuan. ¿Cham aa pim jɨꞌxkat tu jiñkuiꞌñ? Na jaꞌpnim kaiꞌch bo: ");
INSERT INTO stpNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Aañ jir diꞌ gu Dios tugiꞌñ gu Abraam, gio baꞌ gu Isaak, gio baꞌ gu Jakob.” Cham tuꞌ na jax kaiꞌch: “Aañ jir ja Dios tuk kat”, guꞌ jaꞌpji na puiꞌm kaiꞌch ji na puir ja Dios tuk ji. Dhiꞌ bhaan jix maatɨꞌ nam pui mu paiꞌ oipo dhiꞌ dhi jaꞌtkam, sia ku mɨt ba koi gu ja tutkuꞌ am bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Baꞌ pu cham ka ñio mɨt bɨɨx gu jaꞌtkam, dai nam miꞌ puiꞌ pup tuꞌiiꞌ na mɨt puꞌñi kai gu Jesuus, na guꞌ joidham jix bhaiꞌ xi bua na tu aꞌga. ");
INSERT INTO stpNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Baꞌ gu pariseos maap xim jumpadak giop ma tu aꞌga mɨt na mɨt paiꞌ dhuuk puiꞌ ba tɨ kai nat maaꞌn nat jax ja maꞌiich gu Jesuus gu saduseos. ");
INSERT INTO stpNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Baꞌ maadɨt guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios mu jimɨɨk amuub na paiꞌp tuꞌiiꞌ gu Jesuus, mi jaꞌp ji kɨkbok bhaiꞌ ba tɨkka, guꞌ na miꞌ pɨx tɨix maiꞌchim ku baꞌp kaiꞌch, jup tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―¿Jax chuꞌm pɨk jix ioꞌm jum aaꞌ nañ miꞌ puiꞌ duiñchuꞌndaꞌ na jɨꞌk jax tu uaꞌñix gu ñioꞌkiꞌñ gu Dios? ");
INSERT INTO stpNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Baꞌp tɨtda gu Jesuus: ―Dho miꞌ na paiꞌ jaꞌpnim kaiꞌch: “Bɨɨx jum jur kɨꞌn jap tu daandaꞌ buiñor guch Gɨꞌkoraꞌ, gio nap jɨꞌx jup jum taat.” ");
INSERT INTO stpNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dhiꞌ jɨꞌ ji na bɨɨpɨꞌ kat jix ioꞌm jum aaꞌ nap miꞌ puiꞌ duiñchuꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Gatuuk baꞌ moo miꞌ na paiꞌ jaꞌpnip jum kaiꞌch: “Jix ja joiꞌgɨꞌndaꞌ ap bɨɨx gu jaꞌtkam sia nar jaroiꞌ kaꞌ gɨt, jaꞌp nap jax xim joiꞌgɨꞌndaꞌ aap dɨɨlh.” ");
INSERT INTO stpNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Na guꞌ dhiꞌ bɨɨx na jɨꞌk jax tu uaꞌñix gu ñioꞌkiꞌñ gu Dios, dai dhiꞌ pɨk dhi gok kap nax ioꞌm bhaan tum aꞌgadaꞌ, gio guiꞌ nam bɨjɨk bhaankam jup tu aꞌgimɨk gu Dios, dai dhiꞌ bhaan jup tu ja aꞌgiꞌñdhaꞌ am gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Baꞌ nam pui miꞌ kap tuꞌiiꞌ gu pariseos, ");
INSERT INTO stpNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ba ja tɨkka gu Jesuus na sap jaroiꞌr boxiiꞌñ guch Xoiꞌkam, jup ja tɨtda: ―¿Aapiꞌm jaroo ɨlhiiꞌñ jiñ jaaduñ nar boxiiꞌñ guch Xoiꞌkam? Baꞌ guiꞌp kaiꞌch am: ―Dho saak gu Dabii dho. ");
INSERT INTO stpNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Baꞌp ja tɨtda ɨp gio gu Jesuus: ―¿Guꞌ jax ji na baꞌ guꞌ dɨɨlh gu Dabii nat puiꞌ jaꞌk jurtuda gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ puiꞌ jaꞌk iim guch Xoiꞌkam nar gɇꞌkam tugiꞌñ? Miꞌ paiꞌ na tu uaꞌñix bhaan gu uꞌuan na jaꞌpni kaiꞌch gu Dabii: ");
INSERT INTO stpNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Jup tɨtda gu Dios guñ gɇꞌkam tuk: “Yaꞌni kɨɨꞌn dɨr jiñ xanoop jap ka xi dhaibuꞌ nañ ka xi ja tulhiiñchudaꞌ guiꞌ nam xim bhaamkiꞌñ, nam baꞌ soiꞌ bam ɨlhdhaꞌ aap jum bui.” ");
INSERT INTO stpNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Guꞌ baꞌ jax dhuukat puiꞌ Dabii jir boxiiꞌñ ji guch Xoiꞌkam na baꞌ guꞌ dɨɨlh gu Dabii puiꞌ jaꞌk iim nar gɇꞌkam tugiꞌñ guch Xoiꞌkam? ");
INSERT INTO stpNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Baꞌ pu cham jaroiꞌ ka ñio, dai nam miꞌ pɨx puiꞌ pup tuꞌiiꞌ. Janoꞌ dɨr baꞌ pu cham jaroiꞌ tuꞌ ka tɨkkadaꞌ gu Jesuus, nam guꞌx maat na maaꞌn na jax ja maiꞌchiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Miꞌ dhɨr baꞌ moop ja tɨtda gu Jesuus gu jaꞌtkam gio gu noonbiꞌñ, jup kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Guiꞌ nam sap pɨk baꞌ tɨi xix mat kaꞌ gu ñioꞌkiꞌñ gu Dios gio guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, gammɨjɨ bhaan tu aꞌgadaꞌ am gu puiꞌ na jax jaꞌk tu aagix miꞌ nat paiꞌ tu uaꞌnak gu Moisees. ");
INSERT INTO stpNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Baꞌ aapiꞌm cham jax ji kaiꞌchɨt tuꞌ kaꞌm xi ja nɨidhat nam jax jam tɨtdadaꞌ, dai ji na pim guꞌ cham puiꞌ jaꞌk jup tu jimdaꞌ nam jax jaꞌk tu jim dɨɨlh, na guꞌ jax ñam xi chɨꞌji maakam tu buidhaꞌ am nam dɨɨlh jax ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Giilhim jix xijaim ja chiandaꞌ am gu jaꞌtkam nam miꞌ puiꞌ jimiaꞌ, sia kum guꞌ dɨɨlh pu cham miꞌ puiꞌ jiimdat jup kaiꞌchdhaꞌ, ni palhɨɨp dho moo. ");
INSERT INTO stpNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jaꞌp pɨx baꞌ dai nam bhaan pɨx gɇꞌgɇrkam jum taat kaꞌ nam sap pɨk baꞌ panaas miꞌ puiꞌ xi jiim nam xi ja nɨiꞌñdhaꞌ gu jaꞌtkam, guꞌ pu paa gi miꞌ puiꞌp jiimdaꞌ am gu tuꞌ sɨlhkam. Gio na ja koꞌraardaꞌ ɨp nam bha jaꞌp ja kokobtaiꞌ am xi ja buupratuꞌndaꞌ gu bapket guiꞌ na miꞌ tu uaꞌñix gu ñioꞌkiꞌñ gu Dios, piam bha jaꞌp ja noonob am. Gio nam tɇꞌtɇb tɨm tɨꞌiiꞌñkaꞌ guiꞌ na am tu bhabhaꞌsalh kaꞌ gu jajannulh. ");
INSERT INTO stpNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Gio noꞌ mu paiꞌ tum kuaꞌ, jix aaꞌndaꞌ am ɨp nam jix kɨkɨɨꞌ aꞌtoxkar taꞌm xi dharkaꞌ, gio mu jaꞌp na paiꞌ jax tum daandaꞌ, jix aaꞌndaꞌ am ɨp nam bɨɨpɨꞌ dɨr xi dharkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Gio nam jix aaꞌndaꞌ ɨp nam soiꞌm duukat ja ñioꞌkiꞌñdhaꞌ gu jaꞌtkam mu jaꞌp ɨrban gu gɇꞌ kiicham, gio nam jix aaꞌndaꞌ ɨp nam puiꞌ ja tɨɨtɨꞌndaꞌ nam jir jix chu mamatdagɨm. ");
INSERT INTO stpNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Baꞌ aapiꞌm cham puiꞌ jaꞌk jup tu jimdaꞌ nam jax jaꞌk tu jim guiꞌam. Chaꞌpim jix aaꞌndaꞌ nam puiꞌ jam tɨɨtɨꞌndaꞌ gu jaꞌtkam na pim jir jix chu mamatdagɨm, na pim guꞌ aapiꞌm jaꞌp ba ji buan na pim jir jum jajaaꞌnnim. Baꞌ maaꞌn pɨx jix jaiꞌch guiꞌ nax dhaam jup tuꞌiiꞌ na jam buir jix chu matdagɨm. ");
INSERT INTO stpNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Gio na pim cham jaroiꞌ puiꞌ tɨɨtɨꞌndaꞌ yaꞌ dhi oiꞌñgaꞌn nar jam gɨꞌkoraꞌ, na guꞌ maaꞌn pɨx jix jaiꞌch guiꞌ nax dhaam jup tuꞌiiꞌ nar jam Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni na pim cham puiꞌm aaꞌndaꞌ nam gɨt gɇꞌgɇrkam jam biaꞌkaꞌ gu jaꞌtkam, na guꞌ aañ nat bhañ joot guñ Gɨꞌkoraꞌ nañ baꞌr jam gɇꞌkam tuk. ");
INSERT INTO stpNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Baꞌ noꞌ jaroiꞌ aapiꞌm maadɨt jix aaꞌ nar gɇꞌkam kaꞌ, jum aaꞌ nax bhaiꞌ ja buadaꞌ gu jaꞌtkam sia nar jaroiꞌ kaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na guꞌ gu jaroiꞌ noꞌ dai gɇꞌkam jum taat, pu cham tuꞌ dho tuꞌ kɨꞌn ji biꞌyaꞌ, guꞌ noꞌ gammɨjɨ soiꞌm ɨlhiiꞌñ, dho gi guꞌ gɇꞌkam kɨꞌn ji biꞌyaꞌ ji. ");
INSERT INTO stpNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Guꞌ baꞌ aapiꞌm na pim jɨꞌk sap pɨk baꞌ tɨip xix maat gu ñioꞌkiꞌñ gu Dios gio aapiꞌm na pim pariseos jum tɨɨtɨꞌ, cham bhaiꞌ tu jam jimiaꞌ na pim guꞌ cham sɨlhkam ja aagiꞌñ gu jaꞌtkam nam jax jaꞌk miꞌ puiꞌ jimiaꞌ na baꞌ ja aꞌm ba tɨ nɨidhidhaꞌ gɨt gu Dios, ni aapiꞌm dɨɨlh dho moo ku pim miꞌ puiꞌ jiim, ni na pim cham aaꞌ nam miꞌ puiꞌ jimiaꞌ jaiꞌ dhɨt gu jaꞌtkam guiꞌ nam jɨꞌk miꞌ puiꞌ tɨi xix jimiik. ");
INSERT INTO stpNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Jam aagiꞌñ iñ moo na cham bhaiꞌ tu jam jimiaꞌ aapiꞌm na pim sap pɨk baꞌ tɨi xix maat gu ñioꞌkiꞌñ gu Dios gio aapiꞌm na pim pariseos jum tɨɨtɨꞌ, na pim guꞌ ja ɨɨxiꞌñdhaꞌ gu ja baꞌbhak gu dɨꞌdɨlhdhɨm uꞌuub, baꞌ giilhim mɨk tu daandaꞌ pim puiꞌ xi chu buaꞌt na baꞌ jax dhui cham maatɨꞌ kaꞌ gɨt na pim tuꞌ jax buadaꞌ. Ku baꞌ guꞌ kam aayaꞌ ji na pim paiꞌ dhuuk giilhim jum tulhiiñaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Cham bhaiꞌ tu jam jimiaꞌ moo aapiꞌm na pim sap pɨk baꞌ tɨi xix maat gu ñioꞌkiꞌñ gu Dios gio aapiꞌm na pim pariseos jum tɨɨtɨꞌ, na pim guꞌ mu jaꞌp naiꞌ jiimdat ja chiñiidhaꞌ gu jaꞌtkam nam miꞌ puiꞌ jimiaꞌ na pim jax jaꞌk tu jim aapiꞌm dɨɨlh. Guꞌ baꞌ noꞌt jaroiꞌ maadɨt miꞌ puiꞌ ba jii na pim jax ja aagiꞌñdhaꞌ, aapiꞌm jix ioꞌm maakam xi chiñiaꞌ na miꞌ puiꞌ jimdaꞌ sia ku jax cham puiꞌ aaꞌ gu Dios, guꞌ na baꞌ jax dhui mu jaꞌk bhɨɨyaꞌ na paiꞌ cham tutkɨ gu tai na baꞌ giilhim jum tulhiiñaꞌ, cham tuꞌ puiꞌ na jax aapiꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Cham bhaiꞌ tu jam jimiaꞌ moo aapiꞌm na pim sap pɨk baꞌ tɨi xix maat gu ñioꞌkiꞌñ gu Dios gio aapiꞌm na pim pariseos jum tɨɨtɨꞌ, na pim guꞌ puiꞌ kaiꞌchdhaꞌ na cham jax bua sia kut cham puiꞌ duu gu jaroiꞌ noꞌt puiꞌ xi chɨꞌɨɨk na gu gɇꞌ chiop bhaan jix maatɨꞌ kaꞌ na puiꞌ tu duñiaꞌ jax ña jaꞌk jix chu duñiim kaꞌ buiñor gu Dios. Guꞌ sap baꞌ noꞌ jax kaiꞌch na gu diꞌoor guiꞌ na mɨjɨ jaiꞌch kaꞌ mɨjɨ ɨrban dɨr gu gɇꞌ chiop bhaan jix maatɨꞌ kaꞌ na puiꞌ tu duñiaꞌ, dhiꞌ dho gi guꞌ sap pɨk baꞌx ioꞌm jum aaꞌ ji na puiꞌ tu duñiaꞌ sia nar jax kaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Cham jam jur biaꞌ pim dho jia ku pim baꞌ puiꞌ kaiꞌchdhaꞌ, jaꞌp ji buan japim na pim cham ñiññia. Jax dhui na moox ioꞌm jum aaꞌ gu gɇꞌ chiop, cham tuꞌ pɨx gu diꞌoor na mɨjɨ jaiꞌch kaꞌ ɨrban dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Gio na pim jup kaiꞌchdhaꞌ ɨp na sap pɨk baꞌ cham jax bua noꞌt cham puiꞌ tu duu gu jaroiꞌ jax ña jaꞌk tu daasaꞌ buiñor gu Dios na pu tu duñiaꞌ, sia kut guꞌ puiꞌ xi chɨꞌɨɨk na bhaan jix maatɨꞌ kaꞌ gɨt guiꞌ na bhaan bha tum makgɨrxiꞌñ gu Dios. Guꞌ sap baꞌ noꞌ guꞌ jax kaiꞌch na sap pɨk baꞌ bhaan jix maatɨꞌ kaꞌ guiꞌ na jɨꞌk bhaan bipioꞌdaꞌ gu Dios gu tuꞌ guiꞌ na bhaiꞌ bɨtkaꞌ bhaan guiꞌ na bha tum makgɨrxiꞌñ, na sap pɨk baꞌ dho gi guꞌx ioꞌm jum aaꞌ ji na pu duñiaꞌ sia nar jax kaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Baꞌ aapiꞌm jiñ jaaduñ na pim jaꞌp ji buan na pim cham ñiññia, jax dhui nax ioꞌm jum aaꞌ guiꞌ na bhaan bha tum makgɨrxiꞌñ gu Dios, cham tuꞌ pɨk guiꞌ nam bha makgɨrtaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na guꞌ gu jaroiꞌ noꞌt puiꞌ tɨi na bhaan jix maatɨꞌ kaꞌ guiꞌ na bhaan tum makgɨrxiꞌñ gu Dios na tuꞌ sɨlhkam puiꞌ tu duñiaꞌ jax ña jaꞌk jix chu duñiim kaꞌ, cham tuꞌ dai guiꞌ aagɨt jup kaiꞌchdhaꞌ na bhaan bha tum makgɨrxiꞌñ, guꞌ jaꞌpji bɨɨx ji sia na aagɨt jup kaiꞌchdhaꞌ guiꞌ na jɨꞌk tuꞌ bha tɨ bɨtkaꞌ bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Piam gu jaroiꞌ noꞌ jax kaiꞌch na gu gɇꞌ chiop bhaan jix maatɨꞌ kaꞌ na sɨlhkam puiꞌ tu duñiaꞌ jax ña jaꞌk jix chu duñiim kaꞌ buiñor gu Dios, cham tuꞌ dai gu gɇꞌ chiop aagɨt jup kaiꞌchdhaꞌ, guꞌ jaꞌpji sia bɨɨx ji gu Dios guiꞌ na bhaan miꞌ tɨ nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Piam gu jaroiꞌ noꞌ jax kaiꞌch na gux dhaam bhaan jix maatɨꞌ kaꞌ na puiꞌ tu duñiaꞌ jax ña jaꞌk jix chu duñiim kaꞌ buiñor gu Dios, sia bɨɨx aagɨt jup kaiꞌchdhaꞌ bhammɨ na paiꞌr gɇꞌkam gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Baꞌ cham bhaiꞌ tu jam jimiaꞌ aapiꞌm na pim sap pɨk baꞌ tɨix maat gu ñioꞌkiꞌñ gu Dios gio aapiꞌm na pim pariseos jum tɨɨtɨꞌ, na pim guꞌ cham bɨɨx miꞌ puiꞌ duiñchuꞌ na jɨꞌk jax jum kaiꞌch gu ñioꞌkiꞌñ gu Dios, dai guiꞌ na jɨꞌk bhaan bipioꞌdaꞌ gu tuꞌ gu Dios na pim baꞌ miꞌ aichdhidhaꞌ gɇꞌ chiop. Guꞌ gu jaiꞌ biꞌiix ji na pim pu duñiaꞌ, puiꞌ na jax na pim sɨlhkam tu aꞌgadaꞌ, gio na pim jix chu joiꞌgɨꞌndaꞌ, gio na pim bɨɨx jam jujur kɨꞌn buiñor jix biiñak kaꞌ gu Dios. Dhiꞌ jɨꞌ ji na bɨɨx jum aaꞌ na pim miꞌ puiꞌ duiñchuꞌndaꞌ, gio gu jaiꞌ na jax tu daaxix ba puiꞌ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Baꞌ aapiꞌm na pim cham sɨlhkam tu aꞌgadaꞌ, jix ñɨiꞌñ japim gu jaroiꞌ noꞌ am jum uaꞌtulhiꞌñ, guꞌ aapiꞌm dɨɨlh pu cham jum nɨiꞌñdhaꞌ na pim giilhim jum uaꞌtulhiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Cham bhaiꞌ tu jam jimiaꞌ moo aapiꞌm na pim sap pɨk baꞌ tɨi xix maat gu ñioꞌkiꞌñ gu Dios gio aapiꞌm na pim pariseos jum tɨɨtɨꞌ, na pim guꞌ dai daam dɨr xi ja bopkonat gu jam bapaas gio gu jam jajooxiaꞌ. Aapiꞌm jañ dho jam aagɨt jup kaiꞌch na pim giilhim jix uꞌuaꞌtulhdhix, na pim guꞌ tu ja ɨɨxiꞌñdhaꞌ gu jaꞌtkam gam na pim bɨɨx aixim tu buadaꞌ na jax cham kɨɨꞌ kaꞌm nɨiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Guꞌ dhiꞌm aaꞌ ji na pim sia bɨɨx ɨrban dɨr jaꞌk ja bopkondaꞌ gu jam bapaas na baꞌ puꞌñi jaꞌk jix kɨkɨɨꞌ kaꞌ sia daam dɨr jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Cham bhaiꞌ tu jam jimiaꞌ moo aapiꞌm na pim sap pɨk baꞌ tɨi xix maat gu ñioꞌkiꞌñ gu Dios gio aapiꞌm na pim pariseos jum tɨɨtɨꞌ, na pim guꞌ jaꞌp ji buan na jax mu nam paiꞌm yassap gu jaꞌtkam, na daam dɨr joidham jix chua kɨꞌn xi mamxidhix kaꞌ na baꞌx abhaar kaꞌ, guꞌ ɨrban dɨr jaꞌk jix ioꞌm muiꞌ mi chɨ bɨtkaꞌ ji gu kokkoidhaꞌ ja aꞌoo gam bɨxchuꞌ gu tuꞌ na cham kɨkɨɨꞌ na mix chu jaiꞌch kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Baꞌ aapiꞌm puꞌñi jaꞌk jup tu jim, panaas ku pim joidham jir jix bhabhaiꞌkam kaꞌ ja bui gu jaꞌtkam, guꞌ gu jam jujur am bhaan ni jɨꞌx ji iam kur puiꞌ, gio na pim giilhim jix buam tomaat. ");
INSERT INTO stpNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Cham bhaiꞌ tu jam jimiaꞌ moo aapiꞌm na pim sap pɨk baꞌ tɨi xix maat gu ñioꞌkiꞌñ gu Dios gio aapiꞌm na pim pariseos jum tɨɨtɨꞌ, na guꞌ jam koꞌraar na pim jix bhaiꞌ tu buadaꞌ miꞌ nam paiꞌ yassap guiꞌ nam bɨjɨk bhaankamuꞌn tu aꞌgimɨk gu Dios, am tu yooxmaꞌndaꞌ pim ji guꞌ miꞌ nam paiꞌ jax yassapkaꞌ guiꞌ nam jɨꞌk jir jix bhabhaiꞌkam kat. ");
INSERT INTO stpNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jup kaiꞌchdhaꞌ pim baꞌ moo: “Jir am kat noꞌch gɨt aach janoꞌ bɨɨx miꞌp oipodaꞌ gɨt na mɨt paiꞌ dhuuk gu bɨjɨk dɨr kam ja koi dhiꞌ nam bhaankamuꞌn tu aꞌgimɨk gu Dios. Aach ja aꞌmkam nokiaꞌ gɨt ji nam baꞌ cham ja koodaꞌ gɨt.” ");
INSERT INTO stpNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Guꞌ ji na guꞌ sia ku pim puꞌñi tɨi kaiꞌch, jax dhui na guꞌx bhaiꞌx maatɨꞌ na pim aapiꞌm jir ja bopxi guiꞌ na mɨt ja koi, ");
INSERT INTO stpNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","gio na pim puiꞌ jaꞌk tu kuugalhdhim na mɨt jax jaꞌk bhaiꞌ ji chɨbgai gu jam bopxi kat nam buam pɨx tu buadaꞌ na jax cham puiꞌ aaꞌndaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¿Jax japim dui ɨlhiiꞌñ na pim cham mu jaꞌk bhɨɨyaꞌ na paiꞌ gammɨjɨ cham tutkɨ gu tai na pim miꞌ pup jum tulhiiñdhaꞌ gammɨjɨ? Na pim guꞌ giilhim jix bhaaꞌmnaꞌ jaꞌp na kookoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Baꞌ aañ bhaiꞌ ka jam joochxidhaꞌ guiꞌ nam bhaankam tu aꞌgadaꞌ gu Dios, gio baꞌ jaiꞌ guiꞌ nam jix chu mamatdaꞌ kaꞌ, gio baꞌ jaiꞌ guiꞌ nam bɨɨx aixim jup jix chu mat kaꞌ. Baꞌ aapiꞌm ja daꞌngɨi ja koodaꞌ, jaiꞌ baꞌ na pim kukrus taꞌm ja sissapai ja koodaꞌ ɨp puiꞌ, gio baꞌ jaiꞌ na pim ja gɨɨꞌbiaꞌ mu jaꞌp na paiꞌ jax tum daandaꞌ, jaiꞌ baꞌ na pim mu jaꞌp naiꞌ ba ja gaagidhaꞌ na paiꞌ jax jɨꞌdɨlh ɨꞌlhich jir kikcham kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Baꞌ aapiꞌm jam aꞌm ji jimiaꞌ na ja aꞌmkam gu jam bopxi kat jam tulhiiñchudaꞌ gu Dios, na baꞌ puꞌñi jaꞌk bɨɨx tu namkix kaꞌ na mɨt jɨꞌk ja koi guiꞌ nam jir jix bhabhaiꞌkam kat na bhaiꞌ tɨi ja jootosdaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan nam baꞌ ya jaꞌp bhaankam tu aꞌgaꞌ. Mummɨ dɨr bhaiꞌ ji jam kusbidhaꞌ na mɨt paiꞌ dhuuk mua gu Abeel, miꞌ juugɨt na mɨt paiꞌ dhuuk jup mua gu Sakariiyas maraaꞌn gu Berekiiyas guiꞌ na mɨt miꞌ saaꞌñdhan mua na paiꞌ kɨɨk guiꞌ na bhaan mi chum makgɨrxiꞌñ gu Dios, miꞌ na paiꞌ kɨɨk gu bhiꞌñbak na mi chum daandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jam aagiꞌñ iñ moo na aapiꞌm jam aꞌm ji jimiaꞌ na ja aꞌmkam gu jam bopxi kat jam tulhiiñchudaꞌ gu Dios aapiꞌm na pim xib yaꞌ dudua. ");
INSERT INTO stpNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Baꞌ bhaiꞌ joiꞌmdaraꞌ ji ai gu Jesuus ja aꞌmkam gu Jerusaleen oiꞌñkam, jup kaiꞌch: ―Aapiꞌm Jerusaleen oiꞌñkam na pim ja kooꞌn guiꞌ na bhaiꞌ tɨi jam joochxiꞌñdhaꞌ gu Dios nam baꞌ ya jaꞌp tu jam aꞌgidhaꞌ bhaankamuꞌn, guꞌ ji na pim guꞌ aapiꞌm joodai kɨꞌn maꞌyasimɨi muꞌaaꞌ gu jaroiꞌ noꞌt puꞌñi chuꞌm bhaiꞌ tɨi ba ji buus aapiꞌm jam bui. Baꞌ aañ tɨi pup xi jam aaꞌñdhimɨk na jax jaꞌk jam aꞌm ba tɨ nɨidhidhaꞌ gɨt gu Dios, jaꞌp na jax gu pippilh noꞌ ja baiꞌñ gu ja naan nam mu jaꞌk xi boopoyaꞌ, guꞌ ji na pimɨt guꞌ dɨɨlh cham aa. ");
INSERT INTO stpNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Baꞌ aañ yaꞌ pu jam tɨtda na cham yaꞌ ka tɨ nɨiꞌñdhaꞌ gu Dios yaꞌ na pim paiꞌ oiꞌdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gio nañ guꞌ aañ jup ba jimiaꞌ nañ paiꞌ dhɨr jup jim, baꞌ cham paiꞌ kañ chɨgiaꞌ pim. Dai janoꞌ nañ paiꞌ dhuuk gio bhaiꞌp jimdaꞌ na pim baꞌ giop bañ chɨgiaꞌ, na pim paiꞌ dhuuk jup tɨꞌyaꞌ: “Jaꞌp moo joidham iam na bhaiꞌ ba jim guiꞌ nat bhach joochxi guch Gɨꞌkoraꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Baꞌ gatuuk na miꞌ puꞌñi xi chu aꞌgimɨk gu Jesuus, ba buus miꞌ dhɨr gɇꞌ chiop. Baꞌ nat gamaiꞌ ba ji jii, mi jaꞌp amuub ji ɇɇk jup tɨtda am gu noonbiꞌñ na sap joidham jix abhaar gu gɇꞌ chiop na jax jaꞌk tuꞌt bha bhiꞌñbakchix. ");
INSERT INTO stpNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Baꞌp ja tɨtda gu Jesuus: ―¿Jia na joidham jix abhaar na pim jax ba nɨiꞌñ? Ku baꞌ guꞌ kam aayaꞌ ji na paiꞌ dhuuk am xim iaraꞌ, pu nip paiꞌ maaꞌn kap ku tukdhixim biꞌyaꞌ dhi joodai, aañ moo yaꞌ pu jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Baꞌ nam miꞌ puiꞌ xi chu aꞌgimɨk, moo sɨlh bhɨi mɨt baasɨꞌn dɨr jaꞌk oidhaꞌ taꞌm bhaiꞌ nam paiꞌ Oliibus kɨꞌn jix chu mat kaꞌ gu jaꞌtkam. Baꞌ jimdat bha jaꞌp ji dhaibu gu Jesuus, baꞌ gu noonbiꞌñ muiꞌ ji ai mɨt nam dɨɨlh jix chɨkkam, jup tɨtda am: ―¿Paa baꞌ pɨk duuk puiꞌ ba jim iaraꞌ gu gɇꞌ chiop, gio na jax ba tum buidhaꞌ na paiꞌ dhuuk bar miaꞌn kaꞌ nam tɨɨmoꞌ dhi oiꞌñgaꞌn, gio nap paiꞌ dhuuk aap saak gio bhaiꞌp ba jimdaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Baꞌp ja tɨtda gu Jesuus: ―Dho guꞌ dai nam muiꞌ yaꞌ ba aayaꞌ dho guiꞌ nam puiꞌ kaiꞌchidhaꞌ nam sap aañ jir guiꞌ kaꞌ. Moo pim cham mi ja kɇkɇɇdaꞌ nam cham jam iatgidhaꞌ. Nam guꞌp kaiꞌchidhaꞌ: “Aañ jir diꞌ guch Xoiꞌkam.” Baꞌ muiꞌ jaꞌtkam puiꞌ ja tɨtdaimɨi ja iatgidhaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Gio baꞌ na pim puiꞌ ba tɇ kɇɇkɇꞌ na ba jɨgialhchaꞌ ya jaꞌp gio baꞌ jaiꞌ kap, ku baꞌ guꞌ aapiꞌm cham totdon kaꞌ ji. Na guꞌ dhiꞌ bɨɨpɨꞌm aaꞌ na puiꞌ tum duñiaꞌ na baꞌ pɨk moo bam tɨɨmoꞌ dhi oiꞌñgaꞌn, ku guꞌ chakuir janoꞌ kaꞌ ji na paiꞌ pɨk duuk jum tɨɨmoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Na guꞌ bɨɨpɨꞌ ka xim kuugalhdhaꞌ nam bhaiꞌ ji bhaakuꞌ gu gɇꞌgɇrkam jum aaꞌndam ja bɨɨm gu ja jaꞌtkam tuk nam ja kokdaꞌ gu jaiꞌ gɇꞌgɇrkam guiꞌ nam jumai momkoran jaꞌk jup tuiꞌkaꞌ. Gio baꞌ na muiꞌ kap bhiogiꞌ ba jimiaꞌ, gio baꞌ jaiꞌ kap na ba joñiaꞌ dhi oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ku baꞌ guꞌ dhiꞌ na bhaan pɨx jix maatɨꞌ kaꞌ ji na ba miamlhidhaꞌ na paiꞌ dhuuk pɨk tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Baꞌ aapiꞌm na pim jɨꞌk tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui, jam daꞌngɨi jam uiꞌkaꞌ am nam jam tulhiiñchudaꞌ, gio baꞌ nam jam koodaꞌ noꞌm xi ɨlhiiꞌñ, gio baꞌ nam bɨɨx cham jam kɨɨgalhiꞌñdhaꞌ gu jaꞌtkam noꞌ pim aañ jiñ bui tɨ jɨɨgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Muiꞌ dho guꞌ cham ka tɨ jɨɨgiꞌñdhaꞌ am janoꞌ aañ jiñ bui na paiꞌ dhuuk puiꞌ tum duñiaꞌ, dai nam dɨɨlh bhaiꞌ jim bhabhaakuidhaꞌ, ja koodaꞌ am jaiꞌ dhɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Gio baꞌ nam muiꞌ yaꞌ ba aayaꞌ guiꞌ nam sap pɨk baꞌ Dios bhaankamuꞌn tu aꞌgidhaꞌ, baꞌ muiꞌ jaꞌtkam ja iatgidhaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gio nam bɨɨx pɨx giilhim jix buam ba tomaat kaꞌ gu jaꞌtkam, cham tuꞌ jaroiꞌ kar jix bhaiꞌkam kaꞌ janoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ku baꞌ guꞌ gu jaroiꞌ noꞌ moo cham tuꞌ bhaan jax jim aagɨt pu tɨ jɨɨgiꞌñ aañ jiñ bui, cham tuꞌ kam tulhiiñaꞌ ji gatuuk, na guꞌ pu jimiaꞌ jix dhaam jaꞌk buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Baꞌ dhix bhaiꞌm kaiꞌchdham ñiꞌook na bhaan tu aꞌga na jax jaꞌk bhaan tɨ nɨidhidhaꞌ gu Dios gu jaroiꞌ, dhiꞌ bɨɨx kap na jɨꞌx oiꞌñgaꞌn puiꞌ ba tum aꞌgaꞌ nam baꞌ bɨɨx kaayaꞌ gu jaꞌtkam nam jɨꞌk jix jaiꞌch, na baꞌ miꞌ dhɨr dho gi baꞌ am xim tɨɨmoꞌ ji dhi oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Gio baꞌ moo jaꞌpni jaꞌk jup tum duñiaꞌ nat jax tu uaꞌnak gu Danial guiꞌ na bɨjɨk bhaankamuꞌn tu aꞌgimɨk gu Dios nap jum kaiꞌch na sap janoꞌ na paiꞌ dhuuk pɨk ba jim tɨɨmoꞌ dhi oiꞌñgaꞌn, maaꞌn yaꞌ ba aayaꞌ gu maaꞌnkam giilhim jix bhangɨm, baꞌ mɨjɨ ji baakɨi gɇꞌ chiop pu tu doodaꞌ na jax ɨlhiiꞌñdhaꞌ. ¡Moo pim xi chɨꞌñchokat dhiꞌ puiꞌ na jɨꞌk jax tu uaꞌñix na pim jɨꞌk tu jiñkuiꞌñdhaꞌ! ");
INSERT INTO stpNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Baꞌ guiꞌ nam jɨꞌk ya jaꞌp amuub ka oipodaꞌ na paiꞌ jax jir Judea, jum aaꞌ nam ba ji boiꞌñgiaꞌ mu jaꞌp uꞌxchɨr na baꞌ cham jax ja doodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Puiꞌ na jax gu jaroiꞌ noꞌ bhaiꞌ paiꞌ ka daa baꞌk dhaam, jir am na bhaiꞌ dhɨr tɨmnɨi pu jimiññolhiaꞌ, cham tuꞌ na mɨjɨp ka bapkɨdaꞌ baꞌk chɨr na baꞌ tuꞌ xi bhɨɨji. ");
INSERT INTO stpNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Piam noꞌ jaroiꞌ mu paiꞌ ka oirɨ gampɨx, jir am na miꞌ dhɨr pu jimiññolhiaꞌ, cham tuꞌ na tuꞌ jajannulhiꞌñ jaiꞌp ka xi chu uaꞌrai na baꞌ pɨk ba jimiññolhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jaꞌp moo joiꞌmdam jum duñiaꞌ am gu uꞌuub guiꞌ nam aꞌaalh kɨꞌn cham bhaiꞌm taat kaꞌ janoꞌ, gio guiꞌ nam ɨlhiꞌch xioꞌdam ka tu maamar kaꞌ ba puiꞌ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Baꞌ aañ yaꞌ pu jam tɨtda na pim gammɨjɨ tu daandaꞌ buiñor gu Dios, na baꞌ cham janoꞌ pɨk puiꞌ tum duñiaꞌ na paiꞌ dhuuk jix ioꞌm jix jɨɨpiꞌñ kaꞌ, piam na paiꞌ dhuuk aagix na cham tum juandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Na guꞌ janoꞌ na paiꞌ dhuuk puiꞌ tum duñiaꞌ, giilhim jir tulhiiñaraꞌ kaꞌ jia, cham tuꞌ puiꞌ na mɨt jax jum tulhiiñak ba bubua gu jaiꞌ janoꞌ dɨr nat gu Dios jup duu dhi oiꞌñgaꞌn yaꞌ juugɨt, guꞌ jaꞌp jix ioꞌm ji na puiꞌ tum duñiaꞌ na baꞌ pɨk pu bar daipuꞌ kaꞌ. Miꞌ dhɨr baꞌ cham jɨꞌxkat paiꞌ dhuuk gio puiꞌp ka tum duñiaꞌ gatuuk, na guꞌ pu bɨɨx ba tum kuugalhdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nat guꞌ moo pu puiꞌ tɨi ɨp gu Dios na sap janoꞌ na paiꞌ dhuuk ba ji chum kuugalhdhaꞌ, cham tuꞌ mɨk jir tulhiiñaraꞌ kaꞌ, na guꞌx ja joiꞌgɨꞌn guiꞌ nam jɨꞌk tɨ jɨɨgiꞌñdhaꞌ buiñor, puiꞌ ku baꞌ cham aaꞌ nam mɨk yaꞌ oipot giilhim jum tulhiiñdhaꞌ. Na guꞌ noꞌ cham tu daasaꞌ gɨt na jɨꞌx juugɨt jir tulhiiñaraꞌ kaꞌ, pu bɨɨx jam dho gɨt koꞌyaꞌ, na guꞌ cham jaroiꞌ nakooꞌ na giilhim jum tulhiiñaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Guꞌ baꞌ janoꞌ na paiꞌ dhuuk bar miaꞌn kaꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ, noꞌ jaroiꞌ jax ba jam tɨtda: “Muni ba ai guch Xoiꞌkam. Maik gor jach kaipuꞌ”, piam noꞌ jax kaiꞌch: “Muni dhaa guch Xoiꞌkam”, aapiꞌm cham jɨɨgiꞌñdhaꞌ, na guꞌ cham tuꞌ sɨlhkam aañ jir diꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nam guꞌ kaiꞌñkam muiꞌ ka jaiꞌchdhɨlhiaꞌ jia guiꞌ nam sap pɨk baꞌ Dios bhaankamuꞌn jup xi chu aꞌgidhaꞌ. Baꞌ puiꞌx bhaiꞌp xi chu buidhaꞌ am guiꞌ na tuꞌr jix kɨɨꞌp jum duukam kaꞌ, guꞌ nam jax dhui pɨx ja iatgidhaꞌ ji gu jaꞌtkam, sia ji guꞌ guiꞌ nam jɨꞌk tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui, jaiꞌ dhɨt mu jaꞌk jup ji ja kaayaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mooñ pu ba jam aagiꞌñ xib dɨr na pim baꞌ moox mat kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Piam noꞌ jaroiꞌ jax ba jam tɨtda: “Maik gor jach kaipuꞌ guch Xoiꞌkam. Muni sap paiꞌ oirɨ gampɨx jix chu gak kɨr”, aapiꞌm moo cham mi kɇkɇɇdaꞌ, na guꞌ cham tuꞌ sɨlhkam aañ jir diꞌ kaꞌ jia kaiꞌñkam. Piam noꞌ jax jam tɨtda: “Muni oꞌñchix guch Xoiꞌkam. Maik gor jach kaipuꞌ”, aapiꞌm moo sia cham mu jimmɨdaꞌ, na guꞌ kaiꞌñkam cham tuꞌ aañ jir diꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Na guꞌ aañ nañ paiꞌ dhuuk gio bhaiꞌp jimdaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, aañ nañ xib bhaankam yaꞌ oirɨ guñ Gɨꞌkoraꞌ, jaꞌp jiñ dhuñiaꞌ iñ na jax gu duuk na bɨpgiaꞌ, na bhammɨni dhɨr xiaꞌlhbui bhaiꞌ pu bhɨɨyaꞌ, mummɨni jaꞌk ji aayaꞌ na paiꞌr jurnip. Dhiꞌ bhaan jix maatɨꞌ kaꞌ nañ aañ jir diꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Na guꞌ na pim jax bax maat bo jia na jax gu nunnui noꞌm bhaiꞌ paiꞌ pɨx xikoolh jiim, na guꞌ bhaiꞌ tu muukix kaꞌ. Baꞌ aañ puꞌñi ɨp nañ paiꞌ dhuuk gio bhaiꞌp jimdaꞌ, dhiꞌ bhaan jix mat kaꞌ pim nañ aañ jir diꞌ kaꞌ noꞌt bhaiꞌ ba tɨm bɨpgɨ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Baꞌ gatuuk na paiꞌ dhuuk puꞌñi bɨɨx xi chum tulhiiñaimɨi, naiꞌ ji chukiaꞌ gu tanoolh gio gu masaaꞌn, jix chukgam jup tum duñiaꞌ. Gio gu chiichiaꞌ na bhaiꞌ ji iiꞌñxiaꞌ bhammɨ dɨr jix dhaam, gio nax ioꞌm naiꞌ ji giꞌndukiaꞌ dhix dhaam. ");
INSERT INTO stpNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Baꞌ gu jaꞌtkam giilhim totdonɨi bhaiꞌ ji susuañiaꞌ am. Miꞌ dhɨr baꞌ dai nam bañ chɨgiaꞌ aañ nañ xib bhaankamuꞌn yaꞌ oirɨ guñ Gɨꞌkoraꞌ nañ jix ioꞌm gɇꞌkam kɨꞌn bhaiꞌ ba jimdaꞌ bhammɨ dɨr jix dhaam bhaan gu tɨbaaꞌ, gio na gɇꞌ joidham nammɨ tum tonnichuꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Miꞌ dhɨr baꞌ dai na gɇꞌ kɨꞌn ba tum kuichdhaꞌ, baꞌ aañ jotmodaꞌ naiꞌ ja jootsaꞌ gu noonbiꞌñ guñ Gɨꞌkoraꞌ mu jaꞌp na jɨꞌx jir oiꞌñgaꞌn na jɨꞌx juugɨt juꞌ kam tuꞌiiꞌ dhix dhaam, nam baꞌ bɨɨx maap ja jumpadaꞌ guiꞌ nam jɨꞌk tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Baꞌ dhi jaꞌp ji buusniaꞌ na jax gu ɨꞌɨɨx na paiꞌ dhuuk bhaiꞌ ji iꞌpuñiaꞌ na joidham pɨx tɨɨꞌñgilhidhaꞌ gu jaagaꞌn. Dhiꞌ bhaan jix maatɨꞌ kaꞌ na bar miaꞌn kaꞌ na paiꞌ dhuuk ba ji chɨꞌngiaꞌ. Moo pim xi chɨꞌñchokat dhiꞌ puiꞌ nañ jax jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na guꞌ noꞌ puꞌñi joidham ba tum buim nañ jax ba tu jam aꞌgiꞌñ, dhiꞌ bhaan jix maatɨꞌ kaꞌ na bar miaꞌn kaꞌ janoꞌ nañ paiꞌ dhuuk gio bhaiꞌp jimdaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, aañ nañ xib bhaankam yaꞌ oirɨ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Baꞌ dhiꞌ bɨɨx na puiꞌ ka xi chum kuugalhdhai nam baꞌ miꞌ dhɨr am xi koꞌyaꞌ bɨɨx gu jaꞌtkam nam jɨꞌk ka duduakaꞌ janoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Baꞌ cham jɨꞌxkat jugiaꞌ dhiñ ñiꞌook, dai dhi oiꞌñgaꞌn dho gi guꞌm tɨɨmoꞌ ji gio dhix dhaam. ");
INSERT INTO stpNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Baꞌ dhiꞌ puiꞌ nañ jax ba tu jam aꞌgiꞌñ, cham maatɨꞌ na paiꞌ pɨk duuk puiꞌ tum duñiaꞌ, na guꞌ dai dɨɨlh guñ Gɨꞌkoraꞌ nax maat nat paiꞌ dhuuk tu dai na puiꞌ tu duñiaꞌ. Sia gu noonbiꞌñ guiꞌ nam jix dhaam jup tuꞌiiꞌ pu cham maat am, ni sia aañ nañ jir Maraaꞌn cham maat iñ, dai guiꞌ dɨɨlh ji na baꞌx maat. ");
INSERT INTO stpNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Baꞌ janoꞌ nañ paiꞌ dhuuk gio bhaiꞌp jimdaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, aañ nañ xib yaꞌ oirɨ bhaankam guñ Gɨꞌkoraꞌ, puꞌñi jaꞌk jup tum duñiaꞌ nat jax tum duu janoꞌ na paiꞌ dhuuk gu Noee tɨi pup tu ja aꞌgidhimɨk gu jaꞌtkam na tɨi ja aagiꞌñdhaꞌ na jax ja doodaꞌ gu Dios, guꞌ ji na mɨt guꞌ cham jɨꞌxkat kai. ");
INSERT INTO stpNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Dai nam xi chu kuaꞌdat gɇꞌgɇrkam jum taat kaꞌ, gio nam jix maik kaꞌ, gio nam jum tɨtmodat tu oiꞌñchaidhaꞌ janoꞌ juugɨt nat paiꞌ dhuuk tɨsaaꞌñ gu Dios gu suudaiꞌ, nat paiꞌ dhuuk bha tɨs gu Noee bhaan gu gɇꞌ kanuub guiꞌ nat jup duu. ");
INSERT INTO stpNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ni jɨꞌx kum cham pum aagɨt gu jaꞌtkam na jax jup tum duñiaꞌ, na guꞌ jotmodaꞌ pɨx nat bhaiꞌ ji dhuuꞌn nam cham pum aaꞌ, baꞌ pu bɨɨx koi mɨt bhaiꞌkuk. Baꞌ puꞌñip tum duñiaꞌ janoꞌ nañ paiꞌ dhuuk aañ gio bhaiꞌp jimdaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan, aañ nañ xib bhaankam yaꞌ oirɨ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Baꞌ janoꞌ gook gu jaꞌtkam mu jaꞌp ka oipodaꞌ am gampɨx, baꞌ maaꞌn am xi baidhai iñ, gu jumai baꞌ miꞌ pup oirɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Gio jaꞌp jaꞌk gook gu uꞌuub maap jup ka tu tuaꞌdaꞌ am, maaꞌn am jup xi baidhai iñ, gu jumai baꞌ miꞌ pup biꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Baꞌ aapiꞌm gammɨjɨ cham kooksɨt darkaꞌ, na guꞌ cham maatɨꞌ nañ paiꞌ dhuuk bha jimdaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na guꞌ dhiꞌ jaꞌpni jia na jax gu jaroiꞌ noꞌ moox maat na jax chuꞌm tukaaꞌ mi bakiaꞌ kiaꞌmiꞌñ gu ɨxkum, na guꞌ tɨ nɨiꞌñdhaꞌ bɨx chukaaꞌ na tu nuukaꞌndaꞌ na baꞌ cham miꞌ baakɨi tɨ ɨɨxdhaꞌ gu tuꞌ na miꞌ biaꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Baꞌ puꞌñi ɨp aapiꞌm, jum aaꞌ na pim gammɨjɨ cham kooksɨt darkaꞌ, na guꞌ aañ nañ xib bhaankam yaꞌ oirɨ guñ Gɨꞌkoraꞌ, puꞌñiñ jotmodaꞌ pɨx yaꞌ ba aayaꞌ na pim paiꞌ dhuuk cham ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Baꞌ guiꞌ na jaroiꞌr jix kɨɨꞌ tujuandam kaꞌ gio nax chu matdaꞌ kaꞌ, puiꞌ na jax maaꞌn gu jax chuꞌm gɇꞌkam noꞌ ampɨk mu paiꞌ bar jimdam, na miꞌ ka xi dhoꞌñchoi maaꞌn gu tujuandam tugiꞌñ na bhaankam miꞌ ka tu ja maakdaꞌ guiꞌ nam miꞌ pup biꞌyaꞌ kiaꞌmiꞌñ na jɨꞌx juugɨt gio miꞌp aayaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jaꞌp moo joidham jix bhaiꞌ tu jimiaꞌ gu tujuandam noꞌ miꞌ puiꞌ tu duiñchuꞌ na jax xi chianɨi gu gɇꞌkam tugiꞌñ na paiꞌ dhuuk ba tɨgiaꞌ na gio miꞌp ba aayaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Baꞌ aañ yaꞌ pu jam tɨtda na gu gɇꞌkam tugiꞌñ joidham jix bhaiꞌm ɨlhdhai puiꞌ jaꞌk tuꞌm kɨꞌn ba daasaꞌ na bɨɨx ba tu nuukxiꞌñdhaꞌ gu tuꞌ na jɨꞌk biaꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Guꞌ ji noꞌ guꞌ dhiꞌ dhi tujuandam buam pɨx tomaat na jax cham jir am, noꞌ guꞌ jax jum aaꞌ na cham ob miꞌ aayaꞌ gu gɇꞌkam tugiꞌñ, ");
INSERT INTO stpNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","baꞌ dai na bhaiꞌ ji ja gɨbichpagaꞌ gu jaiꞌ tujuandam, gio baꞌ na bhaiꞌ ji maimuꞌ ja bɨɨm gu jaiꞌ maikkam, gio na xi chu kuaꞌdat na jɨꞌx ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Baꞌ na paiꞌ dhuuk cham pum aaꞌndaꞌ, jotmodaꞌ miꞌ pɨx ba kɨɨkaꞌ gu gɇꞌkam tugiꞌñ, ");
INSERT INTO stpNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","dho guꞌ giilhim tulhiiñchudaꞌ dho, puiꞌ xi chɨɨdai na puiꞌ pɨx jaꞌk jup tu jimiaꞌ na jax guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñ gu jaꞌtkam. Baꞌ giilhim tɨix buam jum aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Baꞌ noꞌ ja aꞌm ba tɨ nɨidhim gu Dios gu jaꞌtkam, jaꞌp ji buusan na jax jɨꞌk mambhɨɨx gu tɨtɨɨya noꞌ mɨt xi chɨ bɨꞌñdhak miꞌ paiꞌ dhɨr gamaiꞌ ji jii, noꞌ mɨt ba namkim maaꞌn gu biapmaꞌ na miꞌ aayaꞌ na miꞌm tɨɨmoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Baꞌ jaiꞌ jɨꞌk jix chamaam guiꞌ jɨꞌ gu tɨtɨɨya ampɨx puiꞌ cham tu mamatdaꞌ kaꞌ am, dai baꞌ gu jaiꞌx chamaam joidham jup jix chu mamatdaꞌ kaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Baꞌ guiꞌ nam cham tu mamatdaꞌ kaꞌ gu tɨtɨɨya, cham jaiꞌ pup xi bhɨɨk jamɨt guiꞌ nam mi ja toiꞌdhaꞌ guiꞌ nam kɨꞌn tɨ bɨꞌñdhatuꞌ noꞌt am xi juum, pu daipuꞌ guiꞌ na jɨꞌx mi jimchuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Guꞌ baꞌ guiꞌ nam jɨꞌk jix chu mamatdaꞌ kaꞌ gu tɨtɨɨya, dhiꞌ dho gi guꞌ jaiꞌp xi chuꞌaak jamɨt ji guiꞌ nam mi ja toiꞌdhaꞌ noꞌt ba ji chutkɨ guiꞌ nam kɨꞌn tɨ bɨꞌñdhatuꞌ, gio baꞌ jaiꞌ na miꞌ pu jimchuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Guꞌ baꞌ nat guꞌ cham ob miꞌp ji ai gu biapmaꞌ guiꞌ na miꞌm tɨɨmoꞌ, miꞌ puiꞌ ma kookoi mɨt gu tɨtɨɨya nam tɨi tɨ nɨɨra. ");
INSERT INTO stpNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nammɨx ioꞌm ɨraab tukaaꞌ nat baꞌ puiꞌ ba tɨm tɨi, jup tum kaiꞌch: “Xib baꞌ bhaiꞌ ba jim gu biapmaꞌ guiꞌ na yaꞌm tɨɨmoꞌ. Muiꞌ gor xi ñamkibop.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Baꞌ gu tɨtɨɨya jotmodaꞌ na mɨt jax baapam jix bhaiꞌ ba ja duu mɨt guiꞌ nam kɨꞌn tɨ bɨꞌñdhatuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Baꞌ gu jaiꞌx chamaam tɨtɨɨya jup ja tɨtda am guiꞌ nam jix chu mamatdaꞌ kaꞌ gu tɨtɨɨya: “Alhiꞌch japim jich choiꞌdhaꞌ dhiꞌ na kɨꞌn mɨmɨimtuꞌ dhiꞌ nach kɨꞌn tɨ bɨꞌñdhatuꞌ. Jaiñ nat guꞌ ba ji chutkɨ dhiꞌ nach aach ja uaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Baꞌp ja tɨtda am guiꞌ nam jix chu mamatdaꞌ kaꞌ gu tɨtɨɨya: “Chaam ji nach jam toiꞌdhaꞌ, na guꞌ jaꞌp moo dɨɨlh jich aꞌm kam aaꞌ. Mu jaꞌp japim xi chu taañpui na paiꞌ jax jum gaꞌra na baꞌ puꞌñi jaꞌk bɨɨx dhɨt cham jich aꞌm jum aaꞌndaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Baꞌ na mɨt mu jaꞌk ka tu taañim na paiꞌ jax jum gaꞌradaꞌ, miꞌ jaꞌk ba ai gu biapmaꞌ guiꞌ na miꞌm tɨɨmoꞌ. Baꞌ guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ gu tɨtɨɨya, guiꞌ nam jix matdaꞌ na mɨt jax jaꞌk duu na baꞌ cham tutkiaꞌ guiꞌ nam kɨꞌn tɨ bɨꞌñdhatuꞌ, bɨɨmaꞌn muiꞌ ji baap jamɨt mu jaꞌk baꞌk chɨr miꞌ na paiꞌr koiꞌcham kaꞌ. Miꞌ dhɨr baꞌ dai nat jix bhaiꞌ bhaiꞌ xim kuu gu kiꞌñgob. ");
INSERT INTO stpNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Baꞌ jaꞌxpɨx miꞌ tɨi ba ai mɨt gu tɨtɨɨya guiꞌ na mɨt tu taañpuk guiꞌ nam mi ja toiꞌdhaꞌ guiꞌ nam kɨꞌn tɨ bɨꞌñdhatuꞌ, guꞌ ji nat guꞌ pux bhaiꞌ bhaiꞌ bam kuu gu kiꞌñgob. ¿Jax gi dhui muiꞌ ka baapkiaꞌ am? Baꞌ tɨi muiꞌ ba tu soon am jup xi kaiꞌchɨt: “¡Xich kupioꞌkiꞌñ jich jaduuñ kuch aach muiꞌp xi baapkiaꞌ!” ");
INSERT INTO stpNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Guꞌ ji na guꞌ guiꞌ mɨjɨ dɨr jup ja tɨtda: “Jax dhui na guꞌ cham jax kax bhaaiꞌ na pim bha baapkiaꞌ, na pimɨt guꞌ mɨk dɨr ba suulh.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Baꞌ aapiꞌm puꞌñi cham kooksɨt darkaꞌ ―jup ja tɨtda gu Jesuus―, na pim guꞌ puꞌñi cham mat kaꞌ nañ paiꞌ dhuuk bha jimdaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan aañ nañ xib bhaankam yaꞌ oirɨ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Miꞌ dhɨr baꞌ jaꞌpni jaꞌk gio bhaiꞌp ji chu ja aꞌgi gu Jesuus gu jaꞌtkam bhaan ji uaꞌrgidhak gu tuumiñ, jup ja tɨtda: ―Gio baꞌ moo jaꞌpni jaꞌk jup ji buusan ɨp noꞌ ja aꞌm tɨ nɨidhim gu Dios gu jaꞌtkam na jax maaꞌn gu maaꞌnkam noꞌ mɨk jaꞌk bar jimdam jumai momkoran, noꞌt ja baidhak gu tujuandam tugiꞌñ xi ja maakak gu tuumiñ puiꞌ ba ja tɨtda nam kɨꞌn tu juanaꞌ na guiꞌ ka jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Maadɨt miꞌ xi maa jix chamaam mambhɨɨx jix chaꞌtmam ooꞌm gu bapaiñum tuumiñ, gu jumai baꞌ gook mambhɨɨx jix chaꞌtmam ooꞌm miꞌp xi maa ɨp, maaꞌn baꞌ maaꞌn mambhɨɨx jix chaꞌtmam ooꞌm pɨx maa, na guꞌ na jax ja nɨiꞌñ nam jax jix chu jujuanaraꞌ bɨɨx jɨꞌmaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Baꞌ guiꞌ na mɨt jix chamaam mambhɨɨx jix chaꞌtmam ooꞌm maa gu bapaiñum tuumiñ kɨꞌn bhaiꞌ ji chu jua, baꞌ jaꞌkbuiꞌ aixim miꞌ pu buusaiꞌ na mɨt jɨꞌk miꞌ xi dhoꞌñchidhak, baꞌx ioꞌm muiꞌ bap jum duu gu tumñigaꞌn guiꞌ nat miꞌ doꞌñchidhak. ");
INSERT INTO stpNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Gio baꞌ guiꞌ na mɨt gook jix chamaam mambhɨɨx jix chaꞌtmam ooꞌm jup maa, puiꞌ kɨꞌn bhaiꞌp ji chu jua ɨp, baꞌ jaꞌkbuiꞌ aixkam miꞌp buusaiꞌ na mɨt jɨꞌk miꞌ xi dhoꞌñchidhak. ");
INSERT INTO stpNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Guꞌ baꞌ guiꞌ na mɨt maaꞌn mambhɨɨx jix chaꞌtmam ooꞌm maa, dai nat xi uꞌuuk mu jaꞌp dɨbɨɨr bɨtaꞌ xi chɨ dɨꞌrak mɨjɨ xi baapai, pu cham dho guꞌ kɨꞌn ji chu jua gu tumñigaꞌn gu gɇꞌkam tugiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Baꞌ mɨkkat jix ioꞌm muiꞌ jurniꞌñ kɨꞌn gio miꞌp ba ai gu ja gɇꞌkam tuk dhiꞌ dhi tujuandam, baꞌ giop ba tu ja joochxi nam sap mu uaꞌtulhiꞌñdhaꞌ gu tumñigaꞌn na baꞌ tu jaꞌkɨlhdhaꞌ na mɨt jɨꞌk miꞌ ba buusaiꞌ nam kɨꞌn tu juan. ");
INSERT INTO stpNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Baꞌ moo bɨɨpɨꞌ miꞌ ba ai guiꞌ nat jix chamaam mambhɨɨx jix chaꞌtmam ooꞌm miꞌ xi dhoꞌñchidhak gu bapaiñum tuumiñ, baꞌ mi jaꞌp ji kɨkbok jup tɨtda gu gɇꞌkam tugiꞌñ: “Pɨn jix chamaam mambhɨɨx jix chaꞌtmam ooꞌm yaꞌ xiñ dhoꞌñchidhak japich jia jiñ jaduuñ. Dho jaña, jaꞌkbuiꞌ aixim jañich pup muiꞌdhalh na pich jɨꞌk yaꞌ xiñ dhoꞌñchidhak.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Baꞌp kaiꞌch gu gɇꞌkam tugiꞌñ: “¡Aa guꞌ moo jaꞌp joidham jir jix kɨɨꞌ tujuandam ap ji jia! Ea nañ moo gɇꞌkam kɨꞌn jum daasaꞌ. Jabaak bha jaꞌk baꞌk chɨr nach baꞌ maap yaꞌ joidham jix bhaiꞌch chaat kaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Miꞌ dhɨr baꞌ moo miꞌp ba ai gu jumai tujuandam tugiꞌñ guiꞌ nat gook mambhɨɨx jix chaꞌtmam ooꞌm miꞌ xi maakak gu bapaiñum tuumiñ, baꞌ mi jaꞌp ji kɨkbok puiꞌp ba tɨtda ɨp gu gɇꞌkam tugiꞌñ, jup kaiꞌch: “Pɨn gook mambhɨɨx jix chaꞌtmam ooꞌm yaꞌ xiñ dhoꞌñchidhak japich jia jiñ jaduuñ dhi bapaiñum tuumiñ. Dho jaña, jaꞌkbuiꞌ aixim jañich pup muiꞌdhalh na pich jɨꞌk ya xiñ dhoꞌñchidhak.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Baꞌp tɨtda gu gɇꞌkam tugiꞌñ: “¡Aa guꞌ moo jaꞌp joidham jir jix kɨɨꞌ tujuandam ap ji jia! Ea nañ moo gɇꞌkam kɨꞌn jum daasaꞌ. Jabaak bha jaꞌk baꞌk chɨr kuch yaꞌni maap joidham jix bhaiꞌch chaat kaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","Baꞌ jaꞌxpɨx miꞌp ba ai gu jumai tujuandam tugiꞌñ guiꞌ nat mambhɨɨx jix chaꞌtmam ooꞌm pɨx miꞌ xi dhoꞌñchidhak gu bapaiñum tuumiñ, baꞌ puiꞌ mi jaꞌp ji kɨkbok puiꞌp ba tɨtda gu gɇꞌkam tugiꞌñ, jup kaiꞌch: “Yaꞌni baꞌ gum tumñiꞌ jiñ jaduuñ. Cham jañich moo kɨꞌn ji chu jua, nañ guꞌ xim ɨɨbhiꞌñ, nañ guꞌx maat nap giilhim jix bhanaaꞌ sia palhɨɨp pɨx tuꞌ, pu duñiaꞌ ap jax noꞌ pich ba ɨlh, sia kum guꞌ tɨi cham pu kaiꞌch gu jaꞌtkam. Puiꞌ ku ñich baꞌ aañ mi jaꞌp xi chɨ dɨꞌrak dɨbɨɨr taꞌm mɨjɨ xi baapai dhim tumñiꞌ na baꞌ cham maiꞌ suulhgiaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Baꞌp tɨtda gu gɇꞌkam tugiꞌñ na miꞌ puiꞌ tɨtda: “Dho bak cham jir kɨɨꞌ tujuandam ap aañ nañ paiꞌ jax kaiꞌch. ¿Moo cham bhaiꞌ aa nap muñ dhoꞌñchidhaꞌ gɨt nam paiꞌ mumuiꞌdhalhiꞌñ gu tuumiñ, na baꞌ miꞌ muiꞌdhidhaꞌ gɨt nap baꞌ miꞌ dhɨr giop xi uaꞌrai yaꞌ bañ doꞌñxidhaꞌ gɨt muiꞌ paꞌ iam? Jaiñ nap guꞌ moo puiꞌ tɨix maat nañ puiꞌ giilhim jix bhanaaꞌ sia palhɨɨp pɨx tuꞌ, gio nañ pu tu duñiaꞌ nañ jax ɨlhiiꞌñdhaꞌ, sia kum tɨi cham pu kaiꞌch gu jaꞌtkam.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Baꞌ puiꞌ xi chɨꞌɨɨk jup ja tɨtda guiꞌ nam mi jaꞌp jup guguuk: “Ea gor bha boosgiꞌñ dhi tuumiñ na miꞌ dhaaꞌ, mu jaꞌk japim makiaꞌ dhiꞌ nat mambhɨɨx jaꞌkbuiꞌ aixkam pup muiꞌdhalh. ");
INSERT INTO stpNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Na guꞌ gu jaroiꞌ na puꞌñi joidham jix bhaiꞌ tu juandaꞌ, nam guꞌ dai dhiꞌ pɨx ba ji umuagiꞌñdhaꞌ gu jaꞌtkam. Guꞌ ji noꞌt guꞌ gu palhɨɨp jup jum duukam cham miꞌ puiꞌ duu noꞌt mɨt tɨi umuaꞌ, dho dhiꞌ bhaan jam dho cham ka nɨnɨiꞌñdhaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Guꞌ baꞌ dhiñ chujuandam tuk nat cham pu dhuu nañ jax tɨi ɨlhdhat, ea gor daagɨk mu buañ dɨɨrap miꞌ na paiꞌ giilhim jix chukgam, miꞌ na paiꞌ tɨi suakdaꞌ na giilhim jix buam jum aaꞌndaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Miꞌ dhɨr baꞌ moo jaꞌpni bhaiꞌp ji chu ja aꞌgi ɨp gio gu Jesuus gu jaꞌtkam, jup ja tɨtda: ―Baꞌ aañ nañ xib bhaankam yaꞌ oirɨ guñ Gɨꞌkoraꞌ, janoꞌ nañ paiꞌ dhuuk gio bhaiꞌp jimdaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan ja bɨɨm gu noonbiꞌñ guñ Gɨꞌkoraꞌ, joidham mɨk jaꞌp tum tonnichuꞌndaꞌ. Miꞌ dhɨr baꞌ dai nañ bhaiꞌ ba daibuꞌ bhaiꞌ nañ paiꞌ dhɨr naiꞌr gɇꞌkam kaꞌ, na paiꞌ joidham jix chu abhaar. ");
INSERT INTO stpNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Baꞌ bɨɨx gu jaꞌtkam nam jɨꞌk jix jaiꞌch kaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan miꞌ bam jumpadaꞌ am aañ jiñ bui, baꞌ aañ xi ja chiñiaꞌ nam jaiꞌ dɨlhkob jaꞌk xi guꞌkuyaꞌ, jaꞌp na jax jaꞌk tu buadaꞌ gu bipiaꞌdam noꞌt dɨlhkob jaꞌk xi ja sai gu dai kakasnir gio jaꞌp jaꞌk ɨp gu dai kakarbax. ");
INSERT INTO stpNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Baꞌ aañ puꞌñip tu duñiaꞌ, xi ja chiñiaꞌ iñ guiꞌ nam jaꞌp ji buandaꞌ na jax gu kakasnir nam miꞌ dhɨr jaꞌk xi guꞌkuyaꞌ kɨɨꞌn dɨr jaꞌk miꞌ nañ paiꞌ daakaꞌ, guꞌ baꞌ guiꞌ nam jɨꞌk jaꞌp jup ji buandaꞌ na jax gu kakarbax, miꞌ dhɨr jaꞌk oꞌnsop dɨr jaꞌk jañ jup xi ja chiñiaꞌ nam guꞌkuyaꞌ miꞌ nañ paiꞌ daakaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Baꞌ guiꞌ nam jɨꞌk kɨɨꞌn dɨr jaꞌk guꞌkuyaꞌ jup ja tɨɨdaꞌ iñ: “Gor ja ɇɇ bha jaꞌk aapiꞌm nat jɨꞌk jam aꞌm tɨ tɨɨ guñ Gɨꞌkoraꞌ. Yaꞌ pim baꞌ oiꞌñkaꞌ na paiꞌ jax jir gɇꞌkam, yaꞌ na pim paiꞌ pu iimchudhix janoꞌ dɨr nat paiꞌ dhuuk jup duu gu Dios dhi oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na pimɨt guꞌ joidham jix bhaiꞌ dhuu na pimɨt tuñ onbaiꞌ janoꞌ nañ paiꞌ dhuuk ba uamaidhat, gio na pimɨt jiñ choiꞌ gu suudaiꞌ janoꞌ nañ paiꞌ dhuuk ba tonmoidhat, gio na pimɨt jiñ chɨbiaptuda nañ mu jaꞌp ka paxiaraim aapiꞌm jam bui, ");
INSERT INTO stpNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","gio baꞌ na pimɨt tuñ onbaiꞌ gu jajannulh janoꞌ nañ paiꞌ dhuuk cham ka biaꞌ nañ tuꞌ tɨꞌyaꞌ, gio na pimɨt muñ chɨɨgim janoꞌ nat paiꞌ dhuuk ma tuñ ai gio na mɨt mañ kuu.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Baꞌ bɨɨx dhiꞌ jɨꞌ nam jɨꞌk puꞌñir jix bhabhaiꞌkam kaꞌ jup jiñ chɨɨdaꞌ am: “¿Paa chi baꞌ duuk puiꞌ mu paiꞌ tum onbaiꞌ chich jich jaduuñ nap puiꞌ ba uamaidhat, nach guꞌ moo cham paiꞌ dhuuk mu paiꞌm nɨidhat, dai xib na chich baꞌ yaꞌ bam tɨɨ, gio na chich puiꞌm toiꞌ gu suudaiꞌ nap puiꞌ ba tonmoidhat, ");
INSERT INTO stpNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","gio baꞌ na chich puiꞌm tɨbiaptuda nap puiꞌ mu jaꞌp ka jim aach jich bui, gio baꞌ na chich puiꞌ tum onbaiꞌ gu jajannulh nap cham ka biaꞌ kat nap tuꞌ tɨꞌyaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","gio na chich puiꞌ mum tɨɨgim mu paiꞌ nat ma tum ai gio na mɨt jum kuu?” ");
INSERT INTO stpNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Baꞌ aañ jup ja tɨɨdaꞌ ɨp gio: “Dho guꞌ aañ guiꞌ ji nañ ja aagɨt jup kaiꞌch nam gampaiꞌm ɨlhiiꞌñdhaꞌ guiꞌ nam jiñ bui tɨ jɨɨgiꞌñdhaꞌ na pimɨt puꞌñix bhaiꞌ ja duu, puiꞌ kuñ baꞌp kaiꞌch na pimɨt aañ jix bhaiꞌñ dhuu. Na guꞌ dhiꞌ puiꞌ na pimɨt jax tu duu, dhiꞌ aañ jiñ aꞌmkam na pimɨt puiꞌ tu duu.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Guꞌ baꞌ guiꞌ nam oꞌnsop dɨr jaꞌk jup guꞌkuyaꞌ jup ja tɨɨdaꞌ iñ ɨp: “Baꞌ aapiꞌm na pim cham tuꞌ kaꞌm tɨ nɨiꞌñ, na pim cham tu joiꞌgɨꞌn, mu pim jimiaꞌ mu na paiꞌ gammɨjɨ cham tutkɨ gu tai, miꞌ na mɨt paiꞌp duiñ gu jaꞌook na baꞌ miꞌm tulhiiñaꞌ ja bɨɨm gu noonbiꞌñ jix ioꞌm, ja bɨɨm baꞌ aapiꞌm na pim cham tuꞌ kaꞌm tɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na pimɨt guꞌ cham tuñ onbaiꞌ janoꞌ nañ paiꞌ dhuuk tɨi ba uamaim, gio na pimɨt cham jiñ choiꞌ gu suudaiꞌ janoꞌ nañ paiꞌ dhuuk tɨi ba tonmoim, ");
INSERT INTO stpNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","gio na pimɨt cham jiñ chɨbiaptuda janoꞌ na ñich paiꞌ dhuuk mu jaꞌp tɨi bhɨi aapiꞌm jam bui, gio na pimɨt cham tuñ onbaiꞌ gu jajannulh janoꞌ nañ paiꞌ dhuuk cham ka biaꞌ nañ tuꞌ tɨꞌyaꞌ, gio na pimɨt cham muñ chɨɨgim janoꞌ nat paiꞌ dhuuk ma tuñ ai gio na mɨt mañ kuu.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Baꞌ guiꞌ mu dɨr bha jaꞌk jup jiñ chɨɨdaꞌ am ɨp: “Dho jax dhuip tum onbaiꞌñdhaꞌ ich, nach guꞌ cham jɨꞌxkat paiꞌ dhuuk mu paiꞌm nɨidhat na jax xib na chich yaꞌ bam tɨɨ. ¿Jax gi dhuip tum onbaiꞌñdhaꞌ ich paiꞌ nap duuk mu paiꞌ tɨi puiꞌ ba uamaim, gio na chich puiꞌ cham jum toiꞌ gu suudaiꞌ nap puiꞌ tɨi ba tonmoim, gio na chich puiꞌ cham jum tɨbiaptuda nap puiꞌ mu jaꞌp paiꞌ tɨi paxiaraim aach jich bui, gio na chich puiꞌ cham jum onbaiꞌ gu jajannulh nap puiꞌ cham ka biaꞌ nap tuꞌ tɨꞌyaꞌ, gio na chich puiꞌ cham mum tɨɨgim nat ma tum ai gio na mɨt jum kuu?” ");
INSERT INTO stpNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Baꞌ aañ jup ja tɨɨdaꞌ ɨp gio: “Dho guꞌ aañ guiꞌ ji nañ ja aagɨt jup kaiꞌch nam gampaiꞌm ɨlhiiꞌñdhaꞌ nam aañ jiñ bui tɨ jɨɨgiꞌñdhaꞌ na pimɨt cham puꞌñix bhaiꞌ ja duu, puiꞌ kuñ baꞌp kaiꞌch na pimɨt cham bhaiꞌñ dhuu aañ. Na guꞌ noꞌ pim puꞌñi jix bhaiꞌ ja duñiaꞌ gɨt, dhiꞌ puiꞌ ji buusniaꞌ gɨt na pim aañ jiñ aꞌmkam jix bhaiꞌ ja duñiaꞌ gɨt.” ");
INSERT INTO stpNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Baꞌ bɨɨx dhiꞌ nam jɨꞌk puꞌñi buam pɨx tomaat kaꞌ, mu jaꞌk bhɨɨyaꞌ am na paiꞌ gammɨjɨ cham tutkɨ gu tai, miꞌ nam paiꞌ pup jum tulhiiñdhaꞌ gammɨjɨ. Guꞌ baꞌ guiꞌ nam jɨꞌk jup jir jix bhabhaiꞌkam, mu jaꞌk jup bɨɨyaꞌ am nam paiꞌ joidham gammɨjɨ jix bhaiꞌ bam taat kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Baꞌ gatuuk na miꞌ puꞌñi xi chu aꞌgimɨk gu Jesuus jup ja tɨtda gu noonbiꞌñ: ");
INSERT INTO stpNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Xib moo gook tanoolh pɨx ba bii na paiꞌ dhuuk jir piasta kaꞌ bhaan Paaskua taꞌm, na pim jax bax maat jiñ jaaduñ. Baꞌ aañ nañ xib bhaankam yaꞌ oirɨ guñ Gɨꞌkoraꞌ, ampɨx jiñ dhagiaꞌ am guiꞌ nam jiñ oꞌbhagiꞌñ, gio baꞌ nam tu chiñiaꞌ nam jiñ xissapaꞌ kuruus taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","4","Baꞌ janoꞌ jɨꞌ na puiꞌ jɨꞌ tu aꞌga gu Jesuus, bɨɨx maap bam jumaap jamɨt guiꞌ nam jɨꞌk oꞌbhagiꞌñdhaꞌ, puiꞌ na jax gu ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam, gio baꞌ gu ja gɇꞌgɇrkam tuk ɨp guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios. Baꞌ ma tu aꞌga mɨt miꞌ na paiꞌ daakaꞌ gu Kaipaas guiꞌ nax ioꞌm jir ja gɇꞌkam tuk kaꞌ, baꞌ puiꞌ jaꞌk maaꞌn ñiꞌook jup duu mɨt nam jax jaꞌk duñiaꞌ nam dagiaꞌ gu Jesuus, gio nam jax jaꞌk iattulhdhai tu chiñiaꞌ nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ku guꞌp kaiꞌch am ɨp ji nam sap chakui juandaꞌ janoꞌ na paiꞌ dhuuk jir piasta kaꞌ, na ka xi buusniaꞌ sap nam baꞌ ba dagiaꞌ, jup kaiꞌch am: ―Dai ji nach guꞌ chakui juandaꞌ janoꞌ na paiꞌ dhuuk jir piasta kaꞌ. Na ka xi buusniaꞌ nach baꞌ ba dagiaꞌ, nam baꞌ cham bhaiꞌ ji bhaakuꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Baꞌ mu jaꞌk Betaania daakat jup ba tu kuaꞌ gu Jesuus buiñor gu Simoon guiꞌ nam puiꞌ jaꞌk jup jix mat kaꞌ gu jaꞌtkam na tootolhidhat bha gakiidhaꞌ gu tukgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Baꞌ cham jɨꞌx mɨɨkim miꞌ ba ai maaꞌn gu ubii ji uaꞌdat maaꞌn gu alhiꞌch jaꞌaa na mi jimchuꞌ guiꞌ na joidham uub nax ioꞌm jix dhaꞌram namɨɨk. Baꞌ na jax jim xi kupioꞌkak bhaiꞌ xi choiꞌ moꞌran gu Jesuus na miꞌ daakat ka tu kuaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Baꞌ gu noonbiꞌñ am bhaak jamɨt na mɨt puiꞌ jɨꞌ tɨɨ, jup kaiꞌch am: ―¿Cham jir tuꞌ kub aa dhiꞌ na joidham uub nat yaꞌ ba nua dhi ubii? ");
INSERT INTO stpNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aixim nat mu gaꞌrak ja maa gu tuumiñ guiꞌ nam cham biaꞌ nam paiꞌ dhɨr uꞌji kɨꞌn tu sabaꞌdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Guꞌ ji nat guꞌ ba ja kai gu Jesuus nam jax kaiꞌch, baꞌp ja tɨtda: ―Chaꞌpim tuꞌ kɨꞌn juandaꞌ dhiñ jaduuñ, nat guꞌ dhiꞌx bhaiꞌ ba duu nat bhaiꞌ bañ choiꞌ dhiꞌ na joidham uub. ");
INSERT INTO stpNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Matgɨm guꞌ dhiꞌ na pim jaroiꞌ ja aaꞌ nam puiꞌ cham biaꞌ gu tuumiñ na paiꞌ dhɨr uꞌji kɨꞌn tu sabaꞌdaꞌ, dhiꞌ gammɨjɨ pɨx yaꞌx jaiꞌch kaꞌ am ji aapiꞌm jam bui. Guꞌ aañ dai xib ji nañ yaꞌ oirɨ aapiꞌm jam bui, nañ guꞌ aañ bar boi chaꞌm kam. ");
INSERT INTO stpNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Puiꞌ kut baꞌ bhaiꞌ bañ choiꞌ dhiñ jaduuñ dhiꞌ na joidham uub, na baꞌ cham xijai kaꞌ nam jiñ yaaspaꞌ nam paiꞌ dhuuk jiñ muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Baꞌ aañ tuꞌ sɨlhkam kɨꞌn yaꞌ pu jam tɨtdañ jaaduñ, na paiꞌ dhuuk tum aꞌgadaꞌ gux bhaiꞌm kaiꞌchdham ñiꞌook mu jaꞌp paiꞌ, bɨɨx jaiꞌ miꞌp xim aꞌgadaꞌ dhiñ jaduuñ nat jax tu duu nat bhañ choiꞌ dhiꞌ na joidham uub. ");
INSERT INTO stpNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Baꞌ maadɨt guiꞌ nam jir mambhɨɨx daman gook noonbiꞌñ gu Jesuus guiꞌ nam Juudas Iskarioti kɨꞌn jix mat kaꞌ gu jaꞌtkam, xi mɨɨ nat ja tɨkkam gu ja gɇꞌgɇrkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, ");
INSERT INTO stpNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","jup ja tɨtda mu ji ɇɇk: ―¿Jɨꞌk japim jiñ ñamkidhaꞌ noꞌ ñich jam aaꞌñ na paiꞌr am kaꞌ na pim dagiaꞌ gu Jesuus? Baꞌ guiꞌ miꞌ xi aagiꞌñ am nam makiaꞌ maaꞌn ooꞌm daman mambhɨɨx gu bapaiñum tuumiñ jix chooto totbikdam. ");
INSERT INTO stpNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Baꞌ janoꞌ dɨr pɨx am nɨidhidhaꞌ gu Juudas gu Jesuus na paiꞌ jaꞌk jax jimdaꞌ na baꞌ giop xi ja aaꞌñdharaꞌ gu gɇꞌgɇrkam jum aaꞌndam noꞌt miꞌ paiꞌ tɨɨ na oirɨ na paiꞌr am kaꞌ nam dagiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Baꞌ nat paiꞌ dhuuk kiaꞌpɨx muiꞌ ba jim bhɨi na paiꞌ dhuuk jir piasta kaꞌ, janoꞌ na paiꞌ dhuuk jum kuaꞌdaꞌ gu paan guiꞌ na cham bɨnkaꞌ guiꞌ na kɨꞌn jappukar, ba tɨkka am gu Jesuus gu noonbiꞌñ na sap pa jaꞌk jix aaꞌ nam tu bhaidhaꞌ gu koiꞌ, jup tɨtda am: ―¿Paap jaꞌk jix aaꞌch jaduuñ nach tu bhaidhaꞌ gu koiꞌ nach baꞌ tu jugiaꞌ xib nat kapbhaiꞌ yaꞌ bam ai gu piasta bhaan Paaskua taꞌm? ");
INSERT INTO stpNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Baꞌ guiꞌp ja tɨtda: ―Dho bhaiꞌ dho gɇꞌ kiicham na paiꞌ kio maaꞌn guiꞌ nañ jix maat. Ka na pim mu jimiaꞌ na pim pu tɨɨꞌnpuꞌ na pim bhaiꞌ tu bhaidhaꞌ gu koiꞌ. Jaꞌp japim tɨɨdaꞌ: “Aach jaꞌp jich chɨɨdak bhach joot gu Gɇꞌkam nap sap yaꞌ paiꞌ maaꞌn kap ka taiñbuidhaꞌ gum baꞌaak paiꞌ nax chu bhaaiꞌñ kaꞌ nach sap baꞌ yaꞌ tu bhaidhaꞌ gu koiꞌ na tu jugiaꞌ na bha jimdaꞌ jaꞌxñi ja bɨɨm gu noonbiꞌñ, nat guꞌ yaꞌ bam ai gu piasta bhaan Paaskua taꞌm.” ");
INSERT INTO stpNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Baꞌ guiꞌ cham jax ji chɨꞌɨɨk muiꞌp ma jii mɨt na jax ja tɨtda gu Jesuus, puiꞌ dho ji chu buus na jax kaiꞌch. Baꞌ guiꞌ dai na mɨt ba tu bhaiꞌñ gu koiꞌ miꞌ na mɨt paiꞌm taiñbui gu baꞌaak. ");
INSERT INTO stpNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Baꞌ jaꞌxpɨx nat paiꞌ dhuuk ba jur, miꞌ ba ai gu Jesuus ja bɨɨm gu noonbiꞌñ, baꞌ mi jaꞌp ji dharaibuk ma tu juu mɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Baꞌ nam miꞌ ka tu kuaꞌ, jup ja tɨtda gu Jesuus gu noonbiꞌñ: ―Xib dhi tukaaꞌ maadɨt aapiꞌm maaxik jiñ kɨɨsaꞌ nam jiñ dhagiaꞌ guiꞌ nam jiñ oꞌbhagiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Baꞌ naiꞌ soiꞌ jim duu mɨt gu noonbiꞌñ nat puiꞌ jɨꞌ xi ja tɨɨꞌn gu Jesuus. Baꞌ gatuuk jix bhaiꞌ bhaiꞌ ba tɨkka am na sap jaroiꞌ pɨk jir diꞌ na maaxik kɨɨsaꞌ, jup tɨtda am: ―¿Jaroo chi baꞌ moo puiꞌ pɨk maaxik jum kɨɨsaꞌñ jaduuñ? ¿Kaꞌ baꞌ moo aañiꞌ aa chi? Gio gu jumai puiꞌp kaiꞌch ɨp: ―¿Kaꞌ moo aañiꞌ aa chi? Gio gu jaiꞌ bɨɨx nam jɨꞌk jir noonbiꞌñ maaꞌn nam jax kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Baꞌ gu Jesuus jup ja tɨtda: ―Dho guꞌ maaꞌn pɨx ji guꞌ na maaxik jiñ kɨɨsaꞌ, maadɨt dhiꞌ nach jɨꞌk maap tɨ sɨssɨ bhaan dhi jooxiaꞌ. Dhiꞌr diꞌ kaꞌ na maaxik jiñ kɨɨsaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ku baꞌ guꞌ dhiꞌ na miꞌ pɨx puiꞌ ba jim ji na jax dhui pɨx puiꞌ jaꞌk tum kuugalhdhaꞌ na mɨt jax tu uaꞌnak guiꞌ nam bɨjɨk ya jaꞌp bhaankam tu aꞌgimɨk gu Dios nam aañ jiñ aagɨt jup kaiꞌchdhaꞌ nam saak puꞌñi bañ dhoodaꞌ aañ nañ xib bhaankam yaꞌ oirɨ guñ Gɨꞌkoraꞌ. Baꞌ guiꞌ na jaroiꞌ maaxik jiñ kɨɨsaꞌ, giilhim jum tulhiiñaꞌ. Jir am kat na moo pu cham jaiꞌch kaꞌ gɨt na baꞌ cham puꞌñim uaꞌtulhdhai bam tulhiiñaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Baꞌ gu Juudas guiꞌ na maaxik kɨɨsaꞌ gu Jesuus, jaiꞌ puiꞌ xi kaiꞌch nam jax kaiꞌch gu jaiꞌ noonbiꞌñ gu Jesuus na sap baꞌ jax dhui bhaan cham xi maatɨꞌ kaꞌ gɨt na tuꞌ jax dhuñiaꞌ, jup tɨtda gu Jesuus: ―¿Kaꞌ moo aañiꞌ aa chi puiꞌ pɨk maaxik jum kɨɨsaꞌñ jaduuñ? Baꞌp tɨtda gu Jesuus: ―Dho aapiꞌ dhor diꞌ nap jax ba kaiꞌch jiñ jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Baꞌ nam pui miꞌ daraat ka tu kuaꞌ, jotmodaꞌ nat jax dhaa gu Jesuus maaꞌn gu paan, xi chu taxchaabgidhak buiñor gu Dios muiꞌ xi ja maa gu noonbiꞌñ taꞌtak jaisak, jup ja tɨtda: ―Dhiꞌñi pim muiꞌp xi jugiaꞌ, na guꞌ dhiꞌr jiñ chuukuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Gio baꞌ moo maaꞌn miꞌ dhɨr jaꞌp bhaiꞌ ji bhɨi ɨp gu alhiꞌch jaꞌaa na mi suuꞌntuꞌ gu biiñ guiꞌ na uubas kɨꞌn jup duñiix, baꞌ puiꞌp xi chu taxchaabgidhak buiñor gu Dios mu jaꞌk xi ja maa nam bha iꞌyaꞌ, jup ja tɨtda: ―Dhiꞌñi pim muiꞌp xi iꞌyaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","na guꞌ dhiꞌr jiñ ɨꞌɨɨr na baꞌ bhaan jix maatɨꞌ kaꞌ na xib dɨr jaꞌp jaꞌk maakam ba tu aagix kaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ, na mɨlhiaꞌ guñ ɨꞌɨɨr na baꞌ puꞌñi jaꞌk tu namkix kaꞌ bɨɨx gu ja uaꞌtulhdharaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Baꞌ cham paiꞌ dhuuk giop ka iꞌyaꞌ iñ dhi jaꞌp tuꞌm gu uubas baraaꞌ, nañ guꞌ aañ bar boi chaꞌm kam. Dai janoꞌ nach paiꞌ dhuuk gio maap bap tuiꞌkaꞌx dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ nañ baꞌ giop ba iꞌyaꞌ, ku baꞌ guꞌ gux uañ ji gu uubas baraaꞌ, cham tuꞌ dhiꞌ jaꞌp tuꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Baꞌ gatuuk nam miꞌ xi chu laalagimɨk buiñor gu Dios, ma jii mɨt bhammɨ jaꞌk oidhaꞌ taꞌm bhaiꞌ nam paiꞌ Oliibus kɨꞌn jix chu mat kaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Guꞌ ji na guꞌ gama jaꞌk nam ba jiimchuꞌ, jup ja tɨtda gu Jesuus gu noonbiꞌñ: ―Jaꞌxñi tukaaꞌ pu bɨɨx ji boiꞌñgiaꞌ pim nam paiꞌ dhuuk jiñ dhagiaꞌ guiꞌ nam jiñ oꞌbhagiꞌñ nam tu chiñiaꞌ nam jiñ muꞌaaꞌ. Na guꞌ puiꞌ jaꞌk jum kaiꞌch gu ñioꞌkiꞌñ gu Dios miꞌ na paiꞌ tu uaꞌñix na jaꞌpni muiꞌ jim kɨksa: “Muꞌaaꞌ iñ gu bipiaꞌdam, baꞌ gu kakasnir naiꞌ pɨx taꞌtak boopoyaꞌ am.” ");
INSERT INTO stpNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ku baꞌ guꞌ aañ nañ paiꞌ dhuuk duadɨi giop ba bamgiaꞌ miꞌ dhɨr koiꞌñgaꞌn tɨr, bɨɨpɨꞌ kat mummɨ ba oirɨdaꞌ iñ ji Galilea na pim baꞌ aapiꞌm gatuuk mup ba aayaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Baꞌp kaiꞌch gu Peegro: ―¿Cham aa guꞌ aañ moo chakui pɨk jup jimiññolhiaꞌñ jaduuñ? ¿Dai chi dhi jaiꞌ jia noꞌm jiboiꞌñgiaꞌ? Aañ dho gi guꞌ cham ji. ");
INSERT INTO stpNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Baꞌp tɨtda gu Jesuus: ―Puiꞌp dho kaiꞌch gu xib, nat guꞌ chakui tuꞌ jax jum duu. Guꞌ jaꞌxñi tukaaꞌ puiꞌ ji na ji chu buusniaꞌ nañ jax jam tɨtda, puiꞌ na jax aap na kiaꞌpɨx maaꞌnnim ba jiiñkiaꞌ gu takaaruiꞌ, aap baikim puiꞌ ba tɨꞌyaꞌ nap cham tuꞌñ kaichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Guꞌ ji na guꞌ xi kɨɨk gu Peegro na puiꞌ kaiꞌch, jup tɨtda gu Jesuus: ―Aañ dho gi guꞌ pu tɨꞌyaꞌ dho gi ji nañ jum kaichuꞌñ jaduuñ. Cham jax bua sia ku mɨt jum bɨndak jiñ mua. Baꞌ bɨɨx sia gu jaiꞌ noonbiꞌñ puiꞌp xi kaiꞌch am. ");
INSERT INTO stpNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Baꞌ miꞌ pɨx ji ai mɨt na paiꞌ Getsemanii tɨ tɨɨꞌ. Baꞌ gu Jesuus jup ja tɨtda gu noonbiꞌñ: ―Aapiꞌm moo yaꞌni pɨx kañ ñɨɨradaꞌñ jaaduñ. Aañ moo bhaꞌñi ka jimiaꞌ nañ tu daanmɨraꞌ buiñor guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Baꞌ gammɨjɨ pɨx chuꞌm duu dai gu Peegro xi baidhak, gio baꞌ gu Jakoobo, gio baꞌ gu Juan. Baꞌ baasɨꞌn na mɨt ba ai, bhaiꞌ gampaiꞌ jim duu gu Jesuus nam bhaiꞌ xi nɨiꞌñ gu noonbiꞌñ guiꞌ na ja baiꞌñchuꞌ, panaas kux buam bam aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Baꞌp ja tɨtda: ―Aañ moo cham puiꞌ ka tu tatdaꞌ ji, bax chaat iñ nam jiñ muꞌaaꞌ. Baꞌ aañ puiꞌ ɨlhiiꞌñ na pim aapiꞌm yaꞌ pɨx jup kañ ñɨɨradaꞌ, aañ moo bhaꞌñi ka tu daanmɨraꞌ buiñor guñ Gɨꞌkoraꞌ. Dai na pim moo jaiꞌ xi chu daandaꞌ jaꞌp na jax aañ, chaꞌpim koksodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Baꞌ palhɨɨp baasɨꞌn iam xi jimɨɨk mi jaꞌp oꞌlhiaꞌn kɨꞌn xi kɨkbok jix ioꞌm xi dhumaartɨk na dɨɨrap xi chu siisap gu maꞌooꞌn bhaiꞌ ji chu daanɨ buiñor guch Gɨꞌkoraꞌ, jup kaiꞌch: ―Aapiꞌñ Gɨꞌkoraꞌ nap jix dhaam jup tuꞌiiꞌ, jiñ palhbuidhaꞌ ap nam baꞌ cham jiñ muꞌaaꞌ guiꞌ nam jiñ oꞌbhagiꞌñ, na guꞌ dhiꞌ jaꞌp ji buusniaꞌ nañ iꞌyaꞌ gu tuꞌ na giilhim jix xibuꞌ. Ku guꞌ cham tuꞌ ji na moo puiꞌ tu tuiꞌkaꞌ nañ jax kaiꞌch aañ, guꞌ jaꞌpji nap jax ɨlhiiꞌñdhaꞌ ji aap jiñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Baꞌ daipuꞌ puꞌñi jaꞌk xi chu daanɨk ba jii ɨp gio gu Jesuus mu jaꞌk nam paiꞌ pup dar gu noonbiꞌñ. Baꞌ nat mu ba ai, kookos am. Baꞌp tɨtda gu Peegro: ―¿Moo cham bhaaiꞌ aa na pim tɨ nɨiꞌñdhaꞌ sia jɨꞌx juugɨt na ñich jam chianɨk na pim jaiꞌ xi chu daandaꞌ jaꞌp na jax aañ? ");
INSERT INTO stpNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Guꞌ pim ji tɨ nɨiꞌñdhaꞌ ji, chaꞌpim koksodaꞌ. Tu daandaꞌ pim na baꞌ cham jam maiꞌchiaꞌ gu jaꞌook. Na pim guꞌ aapiꞌm dɨɨlh tɨix aaꞌ jia na pim miꞌ puiꞌ jiimdaꞌ gɨt na jax jix aaꞌ guñ Gɨꞌkoraꞌ, guꞌ pɨx ji na pim guꞌ giilhim jix xijaim ɨlhiiꞌñ na pim jum tulhiiñaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Baꞌ daipuꞌ xi ja tɨɨdak gio mu jaꞌk jup ji dhuu nat ba tu daañim ɨp gio. Baꞌ maaꞌn na jax kaiꞌch na tu daan na jax bɨɨpɨꞌ dɨr, jup kaiꞌch: ―Aapiꞌñ Gɨꞌkoraꞌ nap jix dhaam jup tuꞌiiꞌ, jiñ palhbuidhaꞌ ap nam baꞌ cham jiñ muꞌaaꞌ guiꞌ nam jiñ oꞌbhagiꞌñ, na guꞌ dhiꞌ jaꞌp ji buusniaꞌ nañ iꞌyaꞌ gu tuꞌ na giilhim jix xibuꞌ. Ku baꞌ guꞌ cham tuꞌ ji na moo puiꞌ tu tuiꞌkaꞌ nañ jax kaiꞌch aañ, guꞌ jaꞌpji nap jax ɨlhiiꞌñdhaꞌ ji aap jiñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Baꞌ daipuꞌ nat puꞌñi jaꞌk xi chu daanɨk giop ba jii mu jaꞌk nam paiꞌ pup daraa gu noonbiꞌñ. Baꞌ maaꞌn nam jax kookos nat gio miꞌp ba ai, na guꞌ giilhim jix buam tu tatdaꞌ nam jix kookxik. ");
INSERT INTO stpNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Baꞌ guiꞌ miꞌ pɨx xi ja tɨɨgɨk giop ba jii nat ba tu daañim ɨp gio buiñor gu Dios, baꞌ maaꞌn na jax kaiꞌch nat jax jaꞌk tu daañmɨrak bɨɨpɨꞌ dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Miꞌ dhɨr baꞌ giop ba jii mu jaꞌk na paiꞌ gu noonbiꞌñ, baꞌp ja tɨtda mu ji ɇɇk: ―¿Jir maaꞌn aa na pim jax kookos? ¿Moo jaꞌp jix momgon japim aa? Aañ nañ xib bhaankam yaꞌ oirɨ guñ Gɨꞌkoraꞌ, yaꞌ bam ai nam paiꞌ dhuuk jiñ muꞌaaꞌ guiꞌ nam cham tuꞌ kaꞌm nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Muni dhɨr bhaiꞌ ba jim muiꞌ ja bɨɨm guiꞌ na maaxik jiñ kɨɨsaꞌ. Xi baapmiꞌ gor jach muiꞌ xi ñamkiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Baꞌ na miꞌ puiꞌ ka ja tɨtda gu Jesuus gu noonbiꞌñ, miꞌ ba ai gu Juudas guiꞌ na maadɨt jir diꞌ gu mambhɨɨx daman gook gu noonbiꞌñ, ji ja baidhat muiꞌ gu jaꞌtkam kukxir ji chu uaꞌkat gam uꞌuux jix kaapak na mɨt muiꞌ ba daagim gu Jesuus, na mɨt mu ja joot gu ja gɇꞌgɇrkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio baꞌ gu jaiꞌ ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Baꞌ bɨɨpɨꞌ dɨr pu xi ja aaꞌñdhak gu Juudas nam baas dɨr bhaiꞌ ka jiim, jup ja tɨtda: ―Guiꞌ nañ jaroiꞌ miꞌ xi ñioꞌkdhaꞌ, dhiꞌ jɨꞌr diꞌ kaꞌ gu Jesuus. Moo pim miꞌ pu dagiaꞌ, jix bhaiꞌ pim buuprai pu bhɨikaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Baꞌ puiꞌm duu ɨp jia, na jax jim gu Juudas pɨx jix bhaiꞌ kaiꞌchim, jup tɨtda gu Jesuus: ―¡Aach bha jaꞌk ɨp jiñ jaduuñ! Gio baꞌ nat miꞌ xi ñioꞌki puiꞌ xi chɨɨdak. ");
INSERT INTO stpNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Baꞌp tɨtda gu Jesuus: ―¿Puꞌñi jaꞌk japich maaxik bañ kɨiñ jaduuñ? Baꞌ guiꞌ na ja baiꞌñchuꞌ gu Juudas miꞌ pu daa mɨt gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Baꞌ maadɨt guiꞌ nam kaichuꞌ gu Jesuus, jotmodaꞌ nat jax baabu gu kuxiir bhaiꞌ pu soñiich naakaran maadɨt guiꞌ na mɨt miꞌ ba daa gu Jesuus, guiꞌ nar tujuandam tugiꞌñ kaꞌ gux ioꞌm ja gɇꞌkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Guꞌ ji nat guꞌ jotmodaꞌ sooꞌmchulh gu Jesuus, jup tɨtda: ―Puiꞌ pɨx ka tuiꞌkaꞌñ jaduuñ. Chaꞌp juandaꞌ. Xi ulhñaꞌ ap dhim kuxiir. Na guꞌ gu jaroiꞌ na pu chuꞌm kɨꞌn tu kokdadaꞌ, pu chuꞌm kɨꞌn jup muꞌaaꞌ am jia. ");
INSERT INTO stpNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Cham maat ap aa na aañ jix bhaiꞌ nañ pu tɨɨdaꞌ gɨt guñ Gɨꞌkoraꞌ na bhañ joochxidhaꞌ muiꞌ gu noonbiꞌñ nam baꞌñ aꞌmkam tu kokdaꞌ gɨt? ");
INSERT INTO stpNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Guꞌ ji na guꞌ dhiꞌ miꞌ pɨx puiꞌ ba jim na jax dhui pɨx jum kuugalhdhaꞌ na mɨt jax jaꞌk tu uaꞌnak guiꞌ nam bɨjɨk bhaankam ya jaꞌp tu aꞌgimɨk gu Dios nam aañ jiñ aagɨt jup kaiꞌchdhaꞌ nam saak puꞌñi bañ dhoodaꞌ. Puiꞌ kuñ baꞌp jum tɨtda nap cham ja juandaꞌ dhiꞌ na mɨt yaꞌ bañ dhaa. ");
INSERT INTO stpNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Miꞌ dhɨr baꞌ moop ja tɨtda guiꞌ na mɨt miꞌ ba daa: ―¿Guꞌ aapiꞌm jax ku pim baꞌ bɨxchuꞌ kukxir ji chu uaꞌkat bha jaꞌk jiim gam uꞌuux jix kaapak? ¿Tuꞌ ɨxkum jiñ ɨlhiiꞌñ japim aa? ¿Moo cham bhaaiꞌ aa na pim bhammɨ puñ dhagiaꞌ gɨt gɇꞌ chiop nañ moo bhaiꞌ pu oirɨt tu jam aꞌgiꞌñdhaꞌ gammɨjɨ nabap tanoolh? ");
INSERT INTO stpNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ku baꞌ guꞌ na guꞌ dhiꞌ miꞌ pɨx puiꞌ ba jim na jax dhuim kuugalhdhaꞌ gu puiꞌ na mɨt jax jaꞌk tu uaꞌnak guiꞌ nam bɨjɨk ya jaꞌp bhaankam tu aꞌgimɨk gu Dios nam aañ jix aagɨt jup kaiꞌchdhaꞌ na pim saak puꞌñiñ dhaagɨi tu chiñiaꞌ nam jiñ muꞌaaꞌ. Baꞌ gu noonbiꞌñ gu Jesuus dɨɨlh miꞌ xi buak pu jiboiꞌññor jamɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Baꞌ mu ba aich jamɨt gu Jesuus miꞌ na paiꞌ daakaꞌ gu Kaipaas guiꞌ nax ioꞌm jir ja gɇꞌkam tuk kaꞌ guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios. Baꞌ bɨɨx miꞌp tuꞌiiꞌ am guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, gio baꞌ gu jaiꞌ ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Baꞌ bɨɨpɨꞌ dɨr na mɨt chakui mu aich gu Jesuus mu na paiꞌ gu Kaipaas, gatuuk dɨr jum aꞌooꞌñchoidhat muiꞌp jimchuꞌ gu Peegro, na guꞌx ja ɨɨbhiꞌñ nam dagiaꞌ. Baꞌ miꞌ pɨx ji ai nam paiꞌ tu naadat juukaꞌ gu oꞌrosiiris tugiꞌñ gu Kaipaas, na guꞌ tɨix chɨɨgim gu Jesuus nam jax baꞌ ba ji dhoodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","60","Baꞌ bɨɨx gu ja gɇꞌgɇrkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio baꞌ gu jaiꞌ gɇꞌgɇrkam jum aaꞌndam nam miꞌp tuꞌiiꞌ, bhaiꞌ ji chu aꞌga mɨt nam jax jaꞌk dui tu chiñiaꞌ nam muꞌaaꞌ gu Jesuus. Guꞌ ji na mɨt guꞌ bɨɨx aixim pɨx bhaiꞌ ji chɨi, jaiꞌ maakam jup kaiꞌch am, gio jaiꞌ maakam ɨp, nam guꞌ cham jɨꞌxkat paiꞌ dhuuk nɨiꞌñ na mu paiꞌ pɨx jix buam jum duukam jup tu bua gu Jesuus. Muiꞌ miꞌ tɨip tuꞌiiꞌ am ɨp jaiꞌ guiꞌ nam puiꞌ tɨip iattulhiꞌñ. Mɨkkat jaiꞌ gook miꞌp ba ai mɨt ɨp gu jaꞌtkam, puiꞌ mi jaꞌp guꞌkɨk bhaiꞌ tɨip ji iattulh jamɨt, ");
INSERT INTO stpNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","jup kaiꞌch am: ―Dho guꞌ aach miꞌ paiꞌ puiꞌ kɇɇ ji dhi maaꞌnkam nap kaiꞌch: “Alh jañ moo iaraꞌ dhi gɇꞌ chiop gaꞌn gu Dios, baik tanoolh kɨꞌn jañ baꞌ moo gio yaꞌp kɨɨsaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Baꞌ gu Kaipaas xi kɨkbok ba tɨkka gu Jesuus, jup tɨtda: ―¿Jax jap ɨlhdhat ja kɇɇ dhi jaꞌtkam? ¿Jir puiꞌ aa nam jax kaiꞌch, kaꞌ cham aa? ");
INSERT INTO stpNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Guꞌ ji na guꞌ cham ñiok gu Jesuus, miꞌ pɨx pu tuꞌiiꞌ. Baꞌp tɨtda ɨp gio gu Kaipaas: ―Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pum tɨtda buiñor gu Dios nap jich aagiꞌñdhaꞌ noꞌp moo sɨlhkam aap jir diꞌ guch Xoiꞌkam gu Dios gu Maraaꞌn guiꞌ na saak bha jootsaꞌ gɨt jix dhaam dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Miꞌ dho gi guꞌ muiꞌ ji ñio ji gu Jesuus, jup kaiꞌch: ―Jir puiꞌ dho nap jax kaiꞌch jiñ jaduuñ. Aañ jir diꞌ. Ka na pim moo bañ chɨgiaꞌ gatuuk aañ nañ xib bhaankamuꞌn yaꞌ oirɨ guñ Gɨꞌkoraꞌ, nañ bhammɨ sonpan kɨɨꞌn dɨr jaꞌk ba daakaꞌ buiñor guiꞌ na jaroiꞌ bɨxchuꞌx chu aichuꞌn na pu tu duñiaꞌ, gio baꞌ na pim bañ chɨgiaꞌ ɨp janoꞌ nañ paiꞌ dhuuk gio bhaiꞌp jimdaꞌ yaꞌ dhi oiꞌñgaꞌn bhaan gu tɨbaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Baꞌ gu Kaipaas xi saassa gu kutuunaꞌn na sap baꞌ bhaan jix maatɨꞌ kaꞌ na giilhim cham jir am gu puiꞌ nat jax jaꞌk tɨi gu Jesuus. Jup ja tɨtda baꞌ gu jaꞌtkam guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ: ―Dho jaña na jax kaiꞌch dhi maaꞌnkam. ¿Jarooch baꞌp ka nɨɨra na tu aaꞌndaꞌ na tuꞌ bhaan kuiñcha biaꞌ, na chich guꞌ dɨɨlh jich ñaanak kɨꞌn ba kai nat yaꞌ bam uaꞌtulh buiñor gu Dios? ¿Cham aa guꞌ giilhim jir uaꞌtulhdharaꞌ gu dhiꞌ puiꞌ nat jax jaꞌk tɨi? ");
INSERT INTO stpNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Kaꞌ cham aar puiꞌñ jaaduñ? Baꞌ guiꞌp kaiꞌch am: ―Jir puiꞌ ji matgɨm, jaꞌpji na pim mu tu chiñiaꞌ nam mu muꞌaaꞌ dhi maaꞌnkam, na guꞌ giilhim bax uaꞌtulhdhix. ");
INSERT INTO stpNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Baꞌ puiꞌ xi chɨꞌɨɨk bhaiꞌ ji dhaa mɨt, jaiꞌ mɨt bhaiꞌ ji xixbuidhimɨ buibsaran, jaiꞌ baꞌ na mɨt bhaiꞌ xi bulhdhak gu jannulh buupuiram bhaiꞌ xeeggɨb, ");
INSERT INTO stpNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","jup tɨtda am baꞌ moo: ―Eap xich aagiꞌñ na jaroiꞌ bham gɨb noꞌp baabuiꞌ sɨlhkam aap jir diꞌ guch Xoiꞌkam guiꞌ na saak Dios bha jootsaꞌ jix dhaam dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Baꞌ gu Peegro miꞌ daakat juukaꞌ miꞌ nam paiꞌ tu naadat juukaꞌ gu oꞌrosiiris. Baꞌ jaꞌxpɨx maaꞌn miꞌ ba ai gu ubii nar tujuandam tugiꞌñ gu Kaipaas, baꞌ bhaiꞌ xi ñɨidhimɨk jup tɨtda: ―Aap dho maadɨt jir diꞌ jia guiꞌ nam kaichuꞌ gu Jesuus Galilea kam. ");
INSERT INTO stpNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Guꞌ ji na guꞌ cham tu aaꞌ gu Peegro, dai nap kaiꞌch pɨx: ―Chaam tuꞌ ji matgɨm jiñ jaduuñ. Pu cham maat iñ gu jaroiꞌ nap aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Baꞌ jotmodaꞌ nat jax kɨkbo gu Peegro mi jaꞌp bhɨi, gama jaꞌk kiꞌñgob ji kɨkbo. Gu baꞌ na guꞌ mi jaꞌp tum oipo jia gu jaꞌtkam, jumai miꞌp ba tɨɨ na miꞌ kɨɨk. Baꞌ bhaiꞌ xi ñɨidhimɨk jup ja tɨtda gu jaiꞌ nam mi jaꞌp jup oipo: ―Guꞌñi dho bak maadɨt jup jir diꞌ guiꞌ nam kaichuꞌ gu Jesuus Nasareet kam. ");
INSERT INTO stpNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Guꞌ ji na guꞌ maaꞌn na jax kaiꞌch gu Peegro, jup kaiꞌch: ―Chaam tuꞌ ji matgɨm jiñ jaduuñ. Aañ dɨɨlh ji nañ jup oilhim. Pu cham maat iñ gu jaroiꞌ nap aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Baꞌ jaꞌxpɨx jup tɨtda am ɨp jaiꞌ gu Peegro guiꞌ nam miꞌp tuꞌiiꞌ, jup kaiꞌch am: ―Aap dho maadɨt jir diꞌ guiꞌ nam kaichuꞌ gu Jesuus. Tɨɨꞌ nap baꞌ moo jaꞌp puiꞌ tu ñiok nam jax tu ñiok gu mu kam nar paiꞌ kam guiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Guꞌ ji na guꞌ xi kɨɨk gu Peegro na puiꞌ kaiꞌch na cham maat gu Jesuus, jup ja tɨtda: ―Chaam tuꞌ ji matgɨm jiñ jaaduñ. Pu cham maat iñ gu jaroiꞌ na pim aaꞌ. Baꞌ na miꞌ puiꞌ ka kaiꞌch gu Peegro, ba kai gu takaaruiꞌ nat maaꞌn ba jiiñ. ");
INSERT INTO stpNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Baꞌ jotmodaꞌ bhaiꞌ pup tɨꞌñcho na bak pɨn bɨɨpɨꞌ dɨr jup tɨtda gu Jesuus: “Kiaꞌpɨx maaꞌn ba jiiñkiaꞌ gu takaaruiꞌ nap aap baikim puiꞌ ba tɨꞌyaꞌ nap cham tuꞌñ kaichuꞌ.” Baꞌ giilhim bhaiꞌx buam ji chu tatdat gu Peegro, baas dɨr jaꞌp xi buusnɨk ma susua. ");
INSERT INTO stpNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Baꞌ buimgidhak nat paiꞌ dhuuk ba xiaꞌ, bɨɨx maap bam jumaap jamɨt gu ja gɇꞌgɇrkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio baꞌ gu jaiꞌ ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam. Baꞌ puiꞌ jaꞌk ma tu aꞌga mɨt nam sap tu chiñiaꞌ nam muꞌaaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Baꞌ ba tu chia mɨt nam buuplhiaꞌ gu Jesuus, miꞌ dhɨr baꞌ dai na mɨt muiꞌ ba baidhak buiñor gux kaiꞌ Pilaato guiꞌ na miꞌr nobiiꞌñ gux ioꞌm gɇꞌkam Rooma kam. ");
INSERT INTO stpNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Baꞌ gu Juudas guiꞌ nat maaxik kɨi gu Jesuus, giilhim jix buam bhaiꞌ jim ɨlh na xi ñɨiꞌñ gu Jesuus na mɨt ba bhɨɨk. Baꞌ giop xi uꞌuuk gu bapaiñum tuumiñ jix chooto totbikdam guiꞌ na mɨt bɨɨpɨꞌ dɨr maa, xi mɨɨ nat ja doꞌñchidham gu ja gɇꞌgɇrkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio baꞌ gu jaiꞌ ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Baꞌp ja tɨtda mu ji ɇɇk: ―Aañ tak gɇꞌkam kɨꞌn mañ uaꞌtulh buiñor gu Dios na ñich maaxik jam kɨɨx gu Jesuus na pim baꞌ tu chiñiaꞌ nam muꞌaaꞌ, sia ku guꞌ tɨi cham tuꞌ jax bua gu tuꞌ nar jix buam jum duukam. Baꞌ guiꞌp tɨtda am: ―¿Cham aa guꞌ dhiꞌ aap dɨɨlh jir jum kuiñcha, cham tuꞌ aach? ");
INSERT INTO stpNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Baꞌ gu Juudas mi jaꞌp xi iabuk gu tuumiñ mɨjɨ gɇꞌ chiop ba jii nat bam saiꞌchdham mu jaꞌp gampɨx, pu muu dho guꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Baꞌ gu gɇꞌgɇrkam jum aaꞌndam maap xi jumpadak giop xi uꞌuuk jamɨt gu tuumiñ, jup kaiꞌch am baꞌ: ―Cham kar am nach gio miꞌp tuꞌaaꞌ dhi tuumiñ miꞌ na paiꞌm tuaꞌba na jɨꞌk bhaan bipioꞌ gu Dios, na guꞌ cham ka kɨɨꞌ, na guꞌ kɨꞌn ba tu namkix guiꞌ nach jaroiꞌ tu chiñiaꞌ nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Baꞌ puiꞌ jaꞌk maaꞌn ñiꞌook jup duu mɨt nam sap dɨbɨɨr kɨꞌn sabaꞌdaꞌ miꞌ na paiꞌ puiꞌ tɨ tɨɨꞌ Bhiꞌñ Kaat, nam sap baꞌ miꞌ ja yassapdaꞌ gu jaiꞌ jaꞌtkam nam cham jir miꞌ kam kaꞌ guiꞌ nam mi jaꞌp koꞌdaꞌ ja bui. ");
INSERT INTO stpNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Baꞌ miꞌ na mɨt paiꞌ sabaꞌlh gu dɨbɨɨr, Jix Ɨꞌrmaꞌ Dɨbɨɨr pup tɨ tɨɨtɨꞌ am gu jaꞌtkam, sia gu xib maaꞌn nam jax tɨ tɨɨtɨꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Baꞌ dhiꞌ miꞌ pɨx puiꞌ ba jim na jax dhuim kuugalhdhaꞌ gu puiꞌ nat jax jaꞌk tu uaꞌnak gu Jeremiiyas guiꞌ na bɨjɨk bhaankam tu aꞌgimɨk gu Dios na jaꞌpnim kaiꞌch: “Baꞌ giop xi uꞌuuk jamɨt gu bapaiñum tuumiñ guiꞌ na mɨt tɨi ja maakak gu Israel kam jaꞌtkam, ");
INSERT INTO stpNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","baꞌ dɨbɨɨr kɨꞌn sabaꞌlh jamɨt miꞌ na paiꞌ puiꞌ tɨ tɨɨꞌ Bhiꞌñ Kaat puiꞌ nat jax jiñ chia guñ Gɨꞌkoraꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Baꞌ mu ba aich jamɨt gu Jesuus buiñor gux kaiꞌ Pilaato guiꞌ na miꞌr gɇꞌkam kaꞌ. Baꞌ bhaiꞌ ba tɨkka gu Jesuus, jup tɨtda: ―¿Aapiꞌ aar diꞌ nap saak jir ja gɇꞌkam tuk gu yaꞌ kam dhi Israel? Baꞌp tɨtda gu Jesuus: ―Jir puiꞌ dho nap jax kaiꞌch jiñ jaduuñ. Aañ jir diꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Baꞌ gu gɇꞌgɇrkam jum aaꞌndam bɨɨx aixim bhaiꞌ ji iattulh jamɨt gu Jesuus, guꞌ ji na guꞌ guiꞌ cham ñiok sia kum jax kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Baꞌp tɨtda gu Pilaato: ―¿Jir puiꞌ aa baꞌ nam jax kaiꞌch dhi jaꞌtkam nap baꞌ moo jaꞌp cham ñiok? ");
INSERT INTO stpNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Guꞌ ji na guꞌ sia cham ñiok gu Jesuus. Baꞌ miꞌ pu cham maat gu Pilaato na jax dhuñiaꞌ na tɨi xim gaꞌnga. ");
INSERT INTO stpNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Baꞌ gu Pilaato jix joiꞌñdhaꞌ ɨp na maaꞌn ba ji dhoꞌñchoꞌ guiꞌ nam mi kuupkaꞌ nabap maaꞌn oidhaꞌ na paiꞌ dhuuk jum aajidhaꞌ gu piasta bhaan Paaskua taꞌm, jax ñam tuꞌm jix aaꞌndaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Baꞌ janoꞌ maaꞌn miꞌp kuupkaꞌ gu maaꞌnkam Jesuus Barrabaas tɨɨgim. ");
INSERT INTO stpNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Baꞌ gu Pilaato bhaiꞌ ba ja tɨkka gu jaꞌtkam guiꞌ nam jɨꞌk miꞌx bhaak, jup ja tɨtda: ―Aañ puiꞌ ɨlhiiꞌñ nañ maaꞌn doꞌñchoꞌ dhiꞌ nam jɨꞌk yaꞌ kuup dhi jaꞌtkam. ¿Jaroo pim jix aaꞌ, guiꞌ aa na Jesuus Barrabaas tɨɨꞌ, kaꞌ guiꞌ aa jumai na puiꞌp tɨɨꞌ Jesuus guiꞌ nam jich Xoiꞌkam jup tɨɨtɨꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Baꞌ gu Pilaato, guch Xoiꞌkam pɨk na tɨix aagɨt jup kaiꞌch na doꞌñchoꞌ gɨt, na guꞌx bhaiꞌx maat na jaꞌp pɨx nam jix bhaamkiꞌñ na mɨt baꞌ mi aichulh, cham tuꞌ na moo gu tuꞌ nat jax dhuu nar jix buam jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Baꞌ moo janoꞌ na pui miꞌ ka daa gu Pilaato miꞌ na paiꞌr gɇꞌkam kaꞌ, muiꞌ ba tu joochxi gu bɨngaꞌn nam sap jup tɨɨdaꞌ na cham juandaꞌ gu Jesuus, nat guꞌ sap puiꞌ tɨ tɨɨtkɨ tukaaꞌ na cham bhaiꞌ tu jimiaꞌ noꞌt tu chia nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Guꞌ ji na guꞌ gu gɇꞌgɇrkam jum aaꞌndam bɨɨx puiꞌ jaꞌk ba ja tɨɨꞌn jamɨt gu jaꞌtkam nam sap gu Jesuus Barrabaas tɨɨgim bhaiꞌ ji aagaꞌ na doꞌñchoꞌ gu Pilaato na paiꞌ dhuuk gio bhaiꞌp ji ja tɨkkaꞌ, dai sap baꞌ gu Jesuus guiꞌ nar jich Xoiꞌkam tu chiñiaꞌ nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Baꞌ puiꞌm duu dho, nat paiꞌ dhuuk gio bhaiꞌp ji ja tɨkka gu Pilaato, jup ja tɨtda: ―¿Guꞌ jaroo pim bax aaꞌ nañ doꞌñchoꞌ? Baꞌ guiꞌp kaiꞌch am: ―Dho gu Barrabaas dho. ");
INSERT INTO stpNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Baꞌp ja tɨtda gu Pilaato: ―¿Guꞌ dhiꞌ gi baꞌ Jesuus nam jich Xoiꞌkam tɨɨtɨꞌ, jax jañ dhuñiaꞌ? Baꞌ guiꞌp kaiꞌch am ɨp gio: ―Dho nap tu chiñiaꞌ dho nam kuruus taꞌm sissapaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Baꞌp kaiꞌch ɨp gio gu Pilaato: ―¿Guꞌ tuꞌ gi moo gɇꞌkam kɨꞌn jix buam jum duukam jax jam duiñ ku pim baꞌ moo jaꞌp jup jix bhaamkiꞌñ? Guꞌ ji nam guꞌ guiꞌ cham tuꞌ kɇkɇɇ, dai nam jup kaiꞌch gɇꞌ kɨꞌn: ―¡Tu chian kum mu sissapaꞌ kuruus taꞌm! ");
INSERT INTO stpNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Baꞌ ba tu joot gu Pilaato nam alhiꞌch bhɨiꞌñpuꞌ gu suudaiꞌ na baꞌ kɨꞌn jum ikoimdhaꞌ na bhaan jix maatɨꞌ kaꞌ na cham tuꞌr kuiñchaꞌn kaꞌ na tu chiñiaꞌ nam muꞌaaꞌ gu Jesuus, jup ja tɨtda baꞌ: ―Aapiꞌm dɨɨlh jir jam kuiñcha kaꞌ nam muꞌaaꞌ dhi Jesuus, cham tuꞌ aañ. ");
INSERT INTO stpNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Baꞌ guiꞌp kaiꞌch am: ―Dho cham jax bua dho sia ku aach jir jich kuiñcha kaꞌ ja bɨɨm guch maamar. ");
INSERT INTO stpNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Baꞌ ba ja chia gu Pilaato gu sandaaruiꞌx chugiꞌñ nam doꞌñchoꞌ gu Barrabaas, dai baꞌ gu Jesuus xi chu chia nam gɨbiipuꞌ gio nam sissappuꞌ kuruus taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Baꞌ puiꞌp tu buim am gu sandaaruiꞌx nat jax ja chia gu Pilaato, ba baidhak jamɨt gu Jesuus maaꞌn kap na paiꞌ gɇꞌx chɨ gɨꞌɨɨr. Baꞌ bɨɨx maap ba ja jumaap jamɨt gu jaiꞌ sandaaruiꞌx guiꞌ nam jɨꞌk mɨjɨ jaꞌp jup tuꞌiiꞌ nam sap baꞌ tɨgiaꞌ nam jax dhoodaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Baꞌ jax ña mɨt pɨx bhaiꞌ ji buimɨ, jumai mɨt ba tɨiꞌ gu jannulh jix ñakaabmaꞌ xi chu kookoxdhak jamɨt gu dɨɨlh jajannulhiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Gio baꞌ gu tuꞌx joꞌiiꞌ xi xikoolhkadak jamɨt bhaiꞌ xi dhaax moꞌran jaꞌp na kuruun, gio baꞌ maaꞌn gu oxia mɨt miꞌp xi dhaaꞌñchuda nobiꞌran. Gio baꞌ na mɨt mi jaꞌp ja oꞌlhia kɨꞌn xi guꞌkɨk jax ñam pɨx tɨtda, jup kaiꞌch am: ―¡Jaꞌp moo joidham jix bhaiꞌch chaat ich na yaꞌp tuꞌiiꞌ dhi ja gɇꞌkam tuk gu yaꞌ kam dhi Israel! ");
INSERT INTO stpNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Gio baꞌ nam bhaiꞌ xi xixbuiꞌñ puiꞌ xi chɨtdat, gio nam bha gɨb moꞌran kɨꞌn gu oxia guiꞌ na mɨt miꞌ xi dhaaꞌñchudak. ");
INSERT INTO stpNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Baꞌ gatuuk nam puꞌñi bɨɨx aixim xi buimɨk giop xi kuañdhak jamɨt gu jannulh gux ñakaabmaꞌ, gu dɨɨlh jajannulhiꞌñ jamɨt baꞌ giop xi chɨ tɨiꞌdhak. Miꞌ dhɨr baꞌ dai na mɨt ba baidhak bhammɨ jaꞌk nam paiꞌ sissapaꞌ kuruus taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Baꞌ nam gama jaꞌk ba baiꞌñchuꞌ gu Jesuus na paiꞌ bar dɨɨrap dɨr miꞌ gu gɇꞌ kiicham, miꞌ ba ja nam maaꞌn gu maaꞌnkam Simoon tɨɨgim nar mu jaꞌk kam kaꞌ Sireene. Baꞌ gu sandaaruiꞌx miꞌ dhɨr jaꞌk buak gamaiꞌ chia mɨt na mootikaꞌ gu kuruus, nat guꞌ ba magoo gu Jesuus na tɨi mootoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Baꞌ na mɨt bhammɨ ba ai oidhaꞌ taꞌm bhaiꞌ na paiꞌ puiꞌ tɨ tɨɨꞌ Golgota, na jaꞌp kaiꞌñkam jup jum kaiꞌch: Kakoiꞌ Moꞌ Daa, ");
INSERT INTO stpNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","baꞌ bhaiꞌ tɨi iꞌchuꞌn am gu Jesuus gu uubas baraaꞌ na sap baꞌ kɨꞌn cham pɨk tu taat kaꞌ gɨt nam sissapaꞌ, guꞌ ji nat guꞌ ba dɨɨ nar tuꞌ daꞌ, baꞌ cham bha ii. ");
INSERT INTO stpNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Baꞌ gatuuk na mɨt paiꞌ dhuuk bhaiꞌ xi sissapak bhaan gu kuruus, xim mamaiꞌchɨk jamɨt gu sandaaruiꞌx aꞌlhiok xi chu uꞌuuk gu jajannulhiꞌñ. Puiꞌ ji chu buus nat jax tum uaꞌnak bɨjɨk, nap jum kaiꞌch: “Aꞌlhiok jamɨt xi chu uꞌuuk guñ jajannulh.” ");
INSERT INTO stpNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Miꞌ dhɨr baꞌ dai nam mi jaꞌp daraat ba tu nuukaꞌn nam baꞌ cham mu aayaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Baꞌ amuub daam dɨr jaꞌp na paiꞌ moꞌtɨk gu Jesuus, maaꞌn bha siis jamɨt gux komaalhik taaꞌmla na gɇꞌgɇr kɨꞌn bha tu uaꞌñix na bhaan jix maatɨꞌ na jax kaiꞌñkam bhaiꞌ sissap gu Jesuus, jup jum kaiꞌch: “Dhiꞌñir diꞌ gu Jesuus guiꞌ nar ja gɇꞌkam tuk gu yaꞌ kam dhi Israel.” ");
INSERT INTO stpNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Baꞌ gook bɨxxik dɨr jup ja sissapa mɨt gu ɨꞌxkum jaiꞌ kukrus taꞌm, maaꞌn kɨɨꞌn dɨr jaꞌk, jumai baꞌ oꞌnsop dɨr jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Baꞌ guiꞌ nam jɨꞌk mi jaꞌp amuub buan gu jaꞌtkam, jax ñam pɨx xi chɨtdaidhat gu Jesuus, ");
INSERT INTO stpNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","jup kaiꞌchdhaꞌ am: ―¡Jaña nap jax chuꞌiiꞌ! Nap saak iaraꞌ gu gɇꞌ chiop, gio nap saak baik tanoolh kɨꞌn gio jumai bhaiꞌp kɨɨsaꞌ. Eap xi chɨmiiñ bhaiꞌ dhɨr bhaan dhi kuruus nach xim nɨiꞌñdhaꞌ noꞌp baabuiꞌ moo sɨlhkam Dios jir Maraaꞌn, kaꞌ baꞌ guꞌ nap puiꞌ pɨx kaiꞌchdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sia ji guꞌ jaiꞌ gu gɇꞌgɇrkam jum aaꞌndam guiꞌ na mɨt tu chia nam sissapaꞌ, jaiꞌ puiꞌp xi chɨtda am gu Jesuus, jup kaiꞌch am: ");
INSERT INTO stpNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―¿Guꞌ baꞌ moo cham jup bhaiꞌ ji jia na dɨɨlh bhaiꞌ dhɨr ji chɨmñiaꞌ bhaan dhi kuruus, nat baꞌ guꞌ gu jaiꞌ jaꞌtkam jix bhaiꞌ ja duu? Noꞌ baabuiꞌ puiꞌ sɨlhkam jir ja gɇꞌkam tuk gu yaꞌ kam dhi Israel. ");
INSERT INTO stpNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Na guꞌp kaiꞌchdhaꞌ na saak Dios jir Maraaꞌn, nat guꞌ sap pɨk baꞌ bhaan tɨ tɨɨ nar jix kɨɨꞌ maaꞌnkam. ¿Cham bhaaiꞌ aa na bha jimɨi bhaiꞌ dhɨr ji chɨbaañdhaꞌ gu Dios noꞌ baabuiꞌ moo sɨlhkam jix ioꞌm jix dhaꞌ na jax ba kaiꞌchdhaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɨɨx ji guꞌ sia jaiꞌ puiꞌp xi chɨtda am gu ɨꞌxkum guiꞌ nam miꞌ dhɨr jaꞌp bɨxxik dɨr jup sissap jaiꞌ kukrus taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Baꞌ nat jix dhaam ba ji dhuu, naiꞌ ji chum tukgamta, pu cham ka tu maax, nammɨ jix ioꞌm mia ji dhunɨɨk nat baꞌ gio bhaiꞌp jix chu maaxir. ");
INSERT INTO stpNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Baꞌ jotmodaꞌ gɇꞌ kɨꞌn ba jiiñ gu Jesuus, jup kaiꞌch: ―Elii, Elii, ¿lama sabaktani? ―na jaꞌp kaiꞌñkam jup jum kaiꞌch: Aapiꞌ Dios jiñ Gɨꞌkoraꞌ, panaas kup cham jiñ aꞌm ka tɨ nɨidhim. ");
INSERT INTO stpNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Baꞌp kaiꞌch am jaiꞌ dhɨt guiꞌ na mɨt kai nam jɨꞌk miꞌp tuꞌiiꞌ: ―Kani na tɨi baiꞌñ gu Eliiyas guiꞌ na bɨjɨk bhaankam tu aꞌgimɨk gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Baꞌ maadɨt jotmodaꞌ xi mɨɨ nat bhɨim maaꞌn gux moik jaꞌp tuꞌm na tok, baꞌ xi baꞌnnidhak kɨꞌn gu uubas baraaꞌ gux jɨꞌɨɨk uux chaꞌm xi buraak kuugaran muiꞌ xi ñamkich chiñiꞌran gu Jesuus na sap baꞌ xioꞌpnaꞌ gɨt na kɨꞌn kapup xi dhuatgɨdaꞌ gɨt jɨꞌx juugɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Guꞌ ji na mɨt guꞌ xi sooꞌmchulh gu jaiꞌ nam miꞌp tuꞌiiꞌ, jup tɨtda am: ―Chaꞌp juandaꞌ. Yaꞌch pɨx ka tɨ nɨɨradaꞌ, ea noꞌt moo yaꞌ ba ji ai gu Eliiyas na tɨbaañdhaꞌ bhaiꞌ dhɨr bhaan dhi kuruus. ");
INSERT INTO stpNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Baꞌ gio gɇꞌ kɨꞌn jup xi jiiñkɨk gu Jesuus dho gi baꞌ naiꞌ ji muu ji. ");
INSERT INTO stpNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Baꞌ gu jannulh guiꞌ na bhaiꞌ gɇꞌ chiop sɇꞌkaꞌ, daam dɨr muiꞌ pu sar sɨlh ɨrban. Gio baꞌ nat jix ioꞌm bhaiꞌ ji giꞌndukɨ gu oiꞌñgaꞌn, jaiꞌ pu jaikɨ gu joodai, taꞌtak mi jaꞌp pup daraa. ");
INSERT INTO stpNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gio baꞌ na mɨt duduadɨk pu baapam gu koiꞌñgaꞌn miꞌ dhɨr nam paiꞌ yassapkat guiꞌ na mɨt jɨꞌk tɨ jɨɨgiꞌñdhak ba koꞌɨɨk buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Baꞌ nat paiꞌ dhuuk duadɨk giop bam gu Jesuus miꞌ dhɨr koiꞌñgaꞌn tɨr, maap muiꞌ ji ai mɨt bhaiꞌ gɇꞌ kiicham na paiꞌr Jerusaleen, baꞌ muiꞌ jaꞌtkam ja tɨɨ mɨt. ");
INSERT INTO stpNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Baꞌ gu ja gɇꞌkam tuk gu sandaaruiꞌx ja bɨɨm guiꞌ nam maap miꞌ tu nuukaꞌn, giilhim bhaiꞌ ji chootoꞌn jamɨt nat paiꞌ dhuuk bhaiꞌ ji giꞌndukɨ gu oiꞌñgaꞌn gio na bɨɨx aixim tum bua nam naiꞌ xi chɨ nɨiꞌñ, baꞌp kaiꞌch am: ―Bak ji guꞌ moo sɨlhkam Dios jir Maraaꞌn ji dhich jaduuñ na chich yaꞌ ba mua. ");
INSERT INTO stpNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Baꞌ muiꞌ gu uꞌuub mɨk paꞌ guꞌkat muiꞌp tɨ nɨiꞌñ am, guiꞌ na mɨt mummɨ dɨr Galilea muiꞌ pu oi nam palhbuiꞌñchuꞌndaꞌ gu Jesuus tuꞌ na pɨx kɨꞌn, ");
INSERT INTO stpNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","na maadɨt jir diꞌ gu Mariiya Magdaleena, gio baꞌ gu jumai Mariiya guiꞌ nar dɨꞌɨɨꞌn gu Jakoobo gio gu Josee, gio baꞌ gu jumai guiꞌ nar ja naan gu Sebedeo gu maamraꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Baꞌ mɨkkat nat paiꞌ dhuuk ba ji chuk, miꞌ ba ai maaꞌn gu maaꞌnkam nar jix chumñigam kaꞌ Josee tɨɨgim, nar mu jaꞌk kam kaꞌ Arimatea, na maadɨt jir diꞌ guiꞌ na puiꞌp kaichuꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Baꞌ dhiꞌ jɨꞌ dhi Josee muiꞌ ma jii buiñor gux kaiꞌ Pilaato nat tɨkkam noꞌ moox bhaaiꞌ nam tɨbaañdhai yaaspaꞌ gu Jesuus. Baꞌ pɨx cham jax jup tɨi gux kaiꞌ Pilaato na paiꞌ dhuuk puiꞌ ba tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Baꞌ gu Josee mu jimɨɨk ba tɨbaañ gu Jesuus bhaiꞌ dhɨr bhaan gu kuruus, miꞌ dhɨr baꞌ dai nat ba bhiib kɨꞌn gu gɇꞌ jannulh jix dhaꞌram namkɨm. ");
INSERT INTO stpNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Miꞌ dhɨr baꞌ dai nat mu ba tɨkaam gai dɨꞌn kɨr miꞌ nat paiꞌ kiaꞌpɨx tu chia nam tɨ dɨꞌraꞌ jix moik aiꞌ chaꞌm, nat chakui jaroiꞌ maadɨt miꞌm jaꞌbsu gu tukgaꞌn. Baꞌ mɨjɨ xi chɨkaak maaꞌn gɇꞌ jodai kɨꞌn bhaiꞌ xi kuupak ba jii. ");
INSERT INTO stpNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Baꞌ bɨɨx jup jiim am gu Mariiya Magdaleena gio gu jumai Mariiya, baꞌ miꞌ pup daraa am miꞌ na paiꞌ dhɨr mu tum bapkɨ miꞌ na mɨt paiꞌ tɨɨ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Baꞌ buimgidhak na paiꞌ dhuuk aagix kaꞌ na cham tum juandaꞌ, gio muiꞌp ma jii mɨt gu gɇꞌgɇrkam jum aaꞌndam ja bɨɨm gu pariseos na mɨt ñioꞌkdham gux kaiꞌ Pilaato, ");
INSERT INTO stpNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","64","jup tɨtda am mu ji ɇɇk: ―Aach moo gio bhaiꞌp ma jii jich jaduuñ na chich bhaiꞌ puiꞌm tɨɨdam nap ja chiñiaꞌ gum sandaaruiꞌx chuk nam miꞌ ka tu nuukaꞌndaꞌ miꞌ nat paiꞌm tɨɨ gu tukgaꞌn gu Jesuus guiꞌ na naiꞌ ja iatgiꞌñdhaꞌ gu jaꞌtkam, na chich guꞌ ba tɨꞌñcho na bak pɨn jup kaiꞌch na sap baik tanoolh kɨꞌn duadɨi giop bamgiaꞌ miꞌ dhɨr koiꞌñgaꞌn tɨr. Puiꞌ kuch baꞌp kaiꞌch nap ka tu chiñiaꞌ nam miꞌ tu nuukaꞌndaꞌ sia gu baik tanoolh pɨx juugɨt nam baꞌ cham tukaaꞌ miꞌ ji ɇɇji gu noonbiꞌñ xi bhɨɨji gu tukgaꞌn puiꞌ ba tɨꞌyaꞌ nat giop dua. Na guꞌx ioꞌm bhaiꞌ jim gɨꞌlhdhaꞌ nam naiꞌ puiꞌ ji ja iatgidhaꞌ gu jaꞌtkam, cham tuꞌ puiꞌ na jax bɨɨpɨꞌ dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Baꞌ gu Pilaato pɨx cham jax jup tɨi, dai nat xi ja chia nam ja baidhai gu sandaaruiꞌx chugiꞌñ ja bɨɨm mu xi chu nuukdapuꞌ mu na paiꞌ yaasap gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Baꞌ guiꞌ dai na mɨt xi ja baidhak mu jii na mɨt tu nuukdam. Baꞌ mu ji ɇɇk jix ioꞌm jix bhaiꞌ bhaiꞌ xi kuu mɨt gu kiꞌñgob, gio baꞌ na mɨt bhaiꞌ pup xi matgilh na bhaan jix maatɨꞌ kaꞌ na cham bhaiꞌ na jaroiꞌ mu jaꞌk bapkɨdaꞌ. Miꞌ dhɨr baꞌ giop ba jii mɨt puiꞌ xi chu duuk, dai baꞌ gu sandaaruiꞌx jamɨt miꞌ xi ja chianɨk nam tu nuukaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Baꞌ na bar jumai buimgidhak nat kiaꞌpɨx ba ji chu maaxir, nat paiꞌ dhuuk ba buus janoꞌ na paiꞌ dhuuk aagix kaꞌ na cham tum juandaꞌ, nat kiaꞌpɨx muiꞌ ba jim bhɨi gu maaꞌn simaan, muiꞌ ma jii gu Mariiya Magdaleena gio gu jumai Mariiya na mɨt ba tɨ tɨɨgim mu na mɨt paiꞌ yaas gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Baꞌ na mɨt chakui mu ai, jotmodaꞌ jix ioꞌm bhaiꞌ ji chum giꞌndukɨ miꞌ na mɨt paiꞌ yaas gu Jesuus. Bak guꞌ gu nobiiꞌñ guch Gɨꞌkoraꞌ nat miꞌ ba ai jix dhaam dɨr, baꞌ muiꞌ ji ai mu jaꞌk na paiꞌr kiꞌñgob, baꞌ daagɨk jaꞌp jaꞌk xi nuꞌya gu gɇꞌ jodai guiꞌ na kɨꞌn bha kuup, baꞌ mi jaꞌp xi chɨkaak daam dɨr bhaan bhaiꞌ ji dhaibu. ");
INSERT INTO stpNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Baꞌ gu buibsaꞌn jix chua totbikdam jum maaxiꞌñ jaꞌp tuꞌm na jax gu duuk na bɨpgiaꞌ, gio baꞌ gu jajannulhiꞌñ puiꞌx chooto ɨp, jaꞌp tuꞌm jum maaxiꞌñ na jax gu jabook kɨb. ");
INSERT INTO stpNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Baꞌ gu sandaaruiꞌx guiꞌ nam miꞌ ka tu nuukaꞌn, giilhim jix chootoꞌn jamɨt na mɨt tɨɨ gu nobiiꞌñ guch Gɨꞌkoraꞌ nat miꞌ bam maax, baꞌ ji giꞌbokɨk mi jaꞌp naiꞌ ji iaꞌrɨ mɨt, mi jaꞌp pup bɨɨt am na mɨt ba tu kaam. ");
INSERT INTO stpNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Baꞌ na mɨt paiꞌ dhuuk mummɨ ba ai gu uꞌuub miꞌ na paiꞌ ka yaasapkat gu Jesuus, jup ja tɨtda gu nobiiꞌñ guch Gɨꞌkoraꞌ: ―Chaꞌpim totdon kaꞌñ jaaduñ. Aañ jix maat jia na pimɨt gu Jesuus bhaiꞌ ba gaagam guiꞌ na mɨt kuruus taꞌm sissapa. ");
INSERT INTO stpNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Xib cham tuꞌ yaꞌ kap tuꞌiiꞌ, nat guꞌ duadɨk giop bam puiꞌ na jax ba jam tɨtda bɨɨpɨꞌ dɨr. Ka gor mɨjɨ tɨi xi chɨ tɨɨꞌ na cham tu jaiꞌch miꞌ na mɨt paiꞌ ka tɨkaak. ");
INSERT INTO stpNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Baꞌ gu xib dai na jam aꞌm jum aaꞌ na pim xi boopoyaꞌ na pim ja aaꞌñdhapuꞌ gu noonbiꞌñ, jaꞌp japim ja tɨɨdaꞌ: “Jup jich chɨtda gu nobiiꞌñ guch Gɨꞌkoraꞌ nat sap duadɨk giop bam gu Jesuus, sap baꞌ bɨɨpɨꞌ kat mummɨ ba oirɨdaꞌ na paiꞌ Galilea dɨbɨɨr bhaan bipioꞌ, mummɨ sap baꞌ tɨgiaꞌ pim.” Baꞌ aañ dhiꞌ pu kaiꞌñkam pɨx bha jii na ñich bha jam tɨꞌñchoixdham gu dhiꞌ puꞌñi. ");
INSERT INTO stpNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Baꞌ gu uꞌuub jotmodaꞌ na mɨt jax bubua mɨjɨ dɨr na paiꞌ ka yaaspich gu Jesuus, xi boop jamɨt na mɨt ja aaꞌñdham gu noonbiꞌñ ji giꞌbokidhat nam guꞌ puiꞌp jix chotdontuꞌ, ku guꞌx bhaiꞌm taattuꞌ am ji. ");
INSERT INTO stpNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Baꞌ gamaiꞌ gu bɨɨx boi nam muiꞌ ka boopoꞌ, mi jaꞌp bɨɨpɨꞌ dɨr jim maaxdhak gu Jesuus muiꞌ xi ja ñioꞌki. Baꞌ guiꞌ amuub xi ɇɇk mi jaꞌp ja oꞌlhia kɨꞌn xi guꞌkɨk miꞌ xi komkɨk jamɨt gu tootnaꞌn bhaiꞌ ji chu daanɨ buiñor. ");
INSERT INTO stpNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Baꞌp ja tɨtda gu Jesuus: ―Chaꞌpim totdon kaꞌñ jaaduñ, nat guꞌ pu cham tuꞌ jax jum duu. Chaꞌpim jax jum aagɨt xi boopoyaꞌ na pim pu ja tɨɨꞌnpuꞌ gu jaiꞌñ jaaduñ guiꞌ nam puiꞌp jiñ kaichuꞌ nam mu jimiaꞌ Galilea nam baꞌ mummɨñ chɨgiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Baꞌ na mɨt chakui ai gu uꞌuub mu na mɨt paiꞌ jaꞌk ba ja aaꞌñdham gu noonbiꞌñ gu Jesuus, jɨꞌkchi gu sandaaruiꞌx kiaꞌpɨx jum tɨtɨɨꞌñchok miꞌ dhɨr baapmigɨk xi boop jamɨt bhammɨ jaꞌk gɇꞌ kiicham na mɨt ja aaꞌñdham gu ja gɇꞌgɇrkam tuk guiꞌ nam bhaiꞌ gɇꞌ chiop ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Baꞌ guiꞌ miꞌ dhɨr jotmodaꞌ xi boop jamɨt ɨp na mɨt ja aaꞌñdhaꞌ gu jaiꞌ ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam. Baꞌ bɨɨx maap xim jumpadak maaꞌn ñiꞌook bap duu mɨt nam sap muiꞌ tuumiñ ja namkidhai ja sooꞌmchulhdhaꞌ gu sandaaruiꞌx nam cham tu aaꞌndaꞌ nat giop dua gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Baꞌ puiꞌ ba ja tɨtda am gatuuk, jup kaiꞌch am: ―Aapiꞌm moo jaꞌp ja tɨɨdaꞌ gu jaꞌtkam na mɨt dɨɨlh gu noonbiꞌñ gu Jesuus jam ɨɨx gu tukgaꞌn tukaaꞌ na pim paiꞌ dhuuk ka kookos. ");
INSERT INTO stpNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Guꞌ baꞌ noꞌt jax dhuukat ma maat gux kaiꞌ Pilaato gu dhiꞌ puiꞌ nach jax jam tɨtda, aach pu tɨɨdaꞌ na cham tuꞌ aapiꞌm jir jam kuiñcha na baꞌ cham jax jam doodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Baꞌ gu sandaaruiꞌx puiꞌp tu duu mɨt nam jax ja tɨtda gu gɇꞌgɇrkam jum aaꞌndam, dai na mɨt xi gaamuk gu tuumiñ guiꞌ na mɨt ja maa. Baꞌ gammɨjɨ miꞌ puiꞌ pup tu daaꞌñchuꞌ am gu Israel kam jaꞌtkam, sia gu xib pui puiꞌ kaiꞌchdhaꞌ am nat sap cham tuꞌ giop dua guch Xoiꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Baꞌ gu noonbiꞌñ gu Jesuus muiꞌ ma jii mɨt ɨp mummɨ Galilea, maaꞌn kap na paiꞌr oidhaꞌ taꞌm miꞌ na paiꞌ tu ja aagiꞌñ nam tɨgiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Baꞌ jotmodaꞌ pɨx mi jaꞌp bam maax ja bui, baꞌ guiꞌ mi jaꞌp ja oꞌlhia kɨꞌn xi guꞌkɨk bhaiꞌ ji chu daanɨ mɨt buiñor, sia kum guꞌ jaiꞌ cham pɨk tɨ jɨɨgiꞌñ noꞌ moo sɨlhkam jir diꞌ gu Jesuus kaꞌ baꞌ guꞌ cham. ");
INSERT INTO stpNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Baꞌ gu Jesuus amuub xi ɇɇk jup ja tɨtda: ―Guñ Gɨꞌkoraꞌ gɇꞌkam kɨꞌn jiñ dhai jix dhaam jaꞌk gio yaꞌ dhi oiꞌñgaꞌn bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Baꞌ xib dai na jam aꞌm jum aaꞌ na pim naiꞌ xi chu ja aꞌgiꞌñpuꞌ gu jaꞌtkam bɨɨx kap na jɨꞌx oiꞌñgaꞌn nam tɨ jɨɨꞌñdhai aañ jiñ bui miꞌ puiꞌ jimiaꞌ nañ jax jix aaꞌ, gio baꞌ na pim xi ja bopkonidhat bhaankam guñ Gɨꞌkoraꞌ, gio baꞌ aañ nañ jir Maraaꞌn, gio baꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Gio baꞌ na pim xi ja aaꞌñdhidhat ɨp nam tuꞌ kaꞌm xi nɨidhat gu puiꞌ na ñich jax jaꞌk jam aaꞌñ aapiꞌm na pim miꞌ puiꞌ jiimdaꞌ. Baꞌ aañ gammɨjɨ nabap tanoolh jam buip tuiꞌñgɨdaꞌ siat baꞌ am xim tɨɨmo dhi oiꞌñgaꞌn.");
INSERT INTO stpNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jaꞌpni jaꞌk bhaiꞌ jim tɨbgai dhix bhaiꞌm kaiꞌchdham ñiꞌook na bhaan tu aꞌga guch Xoiꞌkam, Maraaꞌn gu Dios, ");
INSERT INTO stpNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","nat tu uaꞌnak bɨjɨk gu Isaiiyas janoꞌ nat paiꞌ dhuuk bha ñioꞌkdhak gu Dios, na sap jup tɨtda guch Gɨꞌkoraꞌ gu Maraaꞌn: Jumaiñ bɨɨpɨꞌ mu jootsaꞌ na baꞌ ba ja mattudaꞌ gu jaꞌtkam nap jootom muiꞌ ba jim. ");
INSERT INTO stpNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Na mu jaꞌp pɨx ba tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam gampɨx jix chu gak kɨr nap ja tɨtdadaꞌ: “Gor jix kɨɨꞌ bim duuñ. Jaꞌp pɨk bhaiꞌ bar jimdam gu Gɇꞌkam. Miꞌ pim sap puiꞌ ba jimiaꞌ na jax jix aaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Baꞌ puiꞌp jum duu ɨp, mummu jaꞌp pɨx ba oirɨdaꞌ gu Juan na paiꞌr gampɨx jix chu gak kɨr, ja bopkondaꞌ gu jaꞌtkam puiꞌ xi ja tɨtdat na sap jir am nam xim bopkonai miꞌ puiꞌ ba jimiaꞌ na jax jix aaꞌ guch Gɨꞌkoraꞌ, na sap baꞌx ja joiꞌmdai ba uañchudaꞌ gu ja uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Baꞌ muiꞌ jaꞌtkam miꞌ aajidhaꞌ am gu bhammɨ dɨr kam Jerusaleen na paiꞌr gɇꞌ kiicham, gio baꞌ jaiꞌ muiꞌ kap dɨr na jɨꞌx Judea dɨbɨɨr bhaan bipioꞌ, nam jix kaim kaꞌ, na guꞌ giilhim joidham jix bhaiꞌ xi buadaꞌ na tu aꞌgadaꞌ. Baꞌ guiꞌ nam jɨꞌk tɨ jɨɨgiꞌñdhaꞌ na sɨlhkam jir puiꞌ na jax tu ja aꞌgiꞌñdhaꞌ, puiꞌ ba tɨtdadaꞌ am nam sap cham ka aaꞌ nam jix uaꞌtulhdhix kaꞌ. Baꞌ gu Juan dai na xi ja bopkondaꞌ miꞌ na paiꞌ mɨrdaꞌ gu suudaiꞌ Jordaan Ak. ");
INSERT INTO stpNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Baꞌ gu Juan gu tɨiꞌdhargaꞌn, kameeyo gu bapooꞌn jir jup duiñxim kaꞌ, gio baꞌ gu bhisparuꞌn jir joꞌ kaꞌ ɨp. Baꞌ na paiꞌ dhuuk bax bhioꞌn kaꞌ, dai gu sossoi na tu daꞌngɨt tu kuaꞌdaꞌ gio baꞌ gu mɨɨbat gu gampɨx kam. ");
INSERT INTO stpNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Baꞌ na tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam jup ja tɨtdadaꞌ: ―Gatuuk dɨr bha jim guiꞌ nax ioꞌm jir gɇꞌkam, cham tuꞌ puiꞌ na jax aañ, na ni jɨꞌx kuñ cham jir jupaabkamuꞌn nañ dhumartɨi tuꞌ suskaꞌn jup ba kookoxdhaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Baꞌ aañ xib suudaiꞌ kɨꞌn pɨx ka jam bopkon, guꞌ baꞌ guiꞌ na paiꞌ dhuuk yaꞌ aayaꞌ, puiꞌp ji buusniaꞌ na jam bopkonaꞌ, na guꞌ ba jam tajaañdhaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdagaꞌn gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Baꞌ janoꞌ muiꞌp ma jii gu Jesuus mummu dɨr Nasareet na paiꞌ Galilea dɨbɨɨr bhaan bipioꞌ. Baꞌ mummu ba ji buus Jordaan Ak miꞌ na paiꞌ oirɨt ja bopkon gu Juan gu jaꞌtkam, baꞌ miꞌ puiꞌ ba tɨtda ɨp na sap bakuanaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Baꞌ nat paiꞌ dhuuk muiꞌ ji buus miꞌ dhɨr suudaiꞌ chɨr gu Jesuus na ba bakuañixchuꞌ, ba tɨɨ nat bhaiꞌ jim kupioꞌ gux dhaam, gio baꞌ nat bhaiꞌ ji chɨm gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ jaꞌp tuꞌm na giodaꞌ, baꞌ naiꞌ ji jaa bhaiꞌ bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gio baꞌ nat ba kai nat bhaiꞌ ba tum aꞌga bhammɨ dɨr jix dhaam, jup tum kaiꞌch: ―Aap jir diꞌ nap jir jiñ mar nañ xim kɨɨgalhiꞌñ, gio nañ gɇꞌkam kɨꞌn jix bhaiꞌñ chaat aap jum bui. ");
INSERT INTO stpNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Baꞌ gatuuk miꞌ dhɨr ma jii gu Jesuus mummu jaꞌk maaꞌn kap na paiꞌr gampɨx, nat guꞌ puiꞌ jaꞌk jurtuda gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Baꞌ miꞌ juruuñ maaꞌn masaaꞌn daman mambhɨɨx tanoolh, mɨjɨ jaꞌp pu oirɨdaꞌ dɨɨlh na paiꞌ cham jaroiꞌ oirɨdaꞌ. Dai gu tuꞌ jɨꞌngiarum na mi jaꞌp tum oipodaꞌ, gio baꞌ guch Gɨꞌkoraꞌ gu noonbiꞌñ nam guguuxiꞌñdhaꞌ. Baꞌ miꞌ ba ai gu jaꞌook na ɨlhdhat na moo miꞌ maiꞌchiaꞌ gɨt, guꞌ ji nat guꞌ cham jax dhooda. ");
INSERT INTO stpNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Baꞌ mɨkkat na mɨt paiꞌ dhuuk ba kuu gu Juan, ma jii gu Jesuus bhammɨ jaꞌk Galilea nat ba tu ja aꞌgidham gu jaꞌtkam gux bhaiꞌm kaiꞌchdham ñioꞌkiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Baꞌp ja tɨtdadaꞌ bhammɨ jaꞌp ji oirɨt: ―Yaꞌ mam aiñ jaaduñ na paiꞌ dhuuk tu daaxix na maaxik jum maaxdhaꞌ gu Dios aapiꞌm jam bui, na pim baꞌ bax mat kaꞌ nax chu joiꞌgɨꞌn sia kux ioꞌm jir gɇꞌkam. Baꞌ dai na jam aꞌm bam aaꞌ na pim miꞌ puiꞌ ba jimiaꞌ na jax jix aaꞌ, gio baꞌ na pim tɨ jɨɨꞌñdhaꞌ na bhaiꞌ ji chu jam aꞌgidhaꞌ gux bhaiꞌm kaiꞌchdham ñioꞌkiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Baꞌ ma jii gu Jesuus mummu jaꞌp juꞌñdharan na paiꞌ gɇꞌ suuꞌnkaꞌ gu suudaiꞌ guiꞌ na Galilea dɨbɨɨr bhaan bipioꞌ. Baꞌ miꞌ ba ja tɨɨ gook gu boptop bhibhiadam daim sɨspidhim nam mi jaꞌp buppaim suudaiꞌ chɨr maaꞌn gu gɇꞌ asaak. Maaꞌn Simoon tɨɨgim, jumai baꞌ Anrees. ");
INSERT INTO stpNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Baꞌp ja tɨtda gu Jesuus: ―Aañ puiꞌ ɨlhiiꞌñ jiñ jaaduñ na pim xib dɨr gammɨjɨ bañ kaichgɨdaꞌ, na pim baꞌ jaiꞌñ palhbuidhaꞌ nañ tu ja aꞌgidhaꞌ gu jaꞌtkam. Bar jaꞌtkam bhibhiadam kaꞌ pim pɨx baꞌ, cham tuꞌ boptop bhibhiadam kiaꞌ, na guꞌ guiꞌ nam jɨꞌk ba tɨ jɨɨꞌñdhaꞌ na pim jɨꞌk jax tu ja aꞌgidhaꞌ, dhiꞌ jaꞌp ji buusniaꞌ na pim ba ja bhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Baꞌ guiꞌp ma oi mɨt cham jax ji chɨꞌɨɨk. Miꞌ xi iabok jamɨt gu ja aꞌsak. ");
INSERT INTO stpNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Baꞌ palhɨɨp gama jaꞌk iam xi jii mɨt bɨɨx juꞌñdharan, miꞌp ba ja tɨɨ mɨt gu Jakoobo gio gu Juan, maamraꞌn gu Sebedeo, nam miꞌ daraat kanuub taꞌm ka ja jiisom gu ja aꞌsak guiꞌ nam kɨꞌn tu bhibhia gu boptop. ");
INSERT INTO stpNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Baꞌ puiꞌp ba ja tɨtda nat jax ja tɨɨdak ja baidhak guiꞌ na ja bɨɨm ba jim. Baꞌ guiꞌ puiꞌ cham jax ji chɨꞌɨɨk ma oi mɨt ɨp, miꞌ xi buak jamɨt gu ja taat Sebedeo ja bɨɨm gu tujuandam tugiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Moo mɨt mummu jaꞌk bhɨi Kapernaum na paiꞌr kikcham na baꞌ moo bam aayaꞌ na paiꞌ dhuuk cham ka tum juandaꞌ. Baꞌ janoꞌ nat paiꞌ bam ai, muiꞌ ma jii gu Jesuus mu nam paiꞌ tu chiopiꞌ gu Israel kam jaꞌtkam. Baꞌ miꞌ baakɨk bhaiꞌ ji chu ja aꞌgi. ");
INSERT INTO stpNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Alh ni jaroiꞌ ku ñiok, miꞌ puiꞌ pup tuꞌiiꞌ am na mɨt ba kai, na guꞌx ioꞌm bhaiꞌ xi bua na xi chu aꞌga, cham tuꞌ puiꞌ na jax guiꞌ nam jup kaiꞌchdhaꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Baꞌ maaꞌn miꞌp oirɨdaꞌ gu maaꞌnkam na ampɨx jix ñaanbiꞌ kaꞌ, na bhaan baax kaꞌ gu cham kɨɨꞌ iiꞌmdaꞌ. Baꞌ na miꞌ ka tu ja aꞌgiꞌñ gu Jesuus gu jaꞌtkam, miꞌ baakɨk chiop gɇꞌ kɨꞌn muiꞌ ba ñio gux ñaanbigɨm, na guꞌ puiꞌ jaꞌk jurtuꞌntuꞌ gu cham kɨɨꞌ iiꞌmdaꞌ, jup kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Jax japich bhaiꞌ bach dhoodam Jesuus Nasareet kam? ¿Kaꞌp ti bhaiꞌ bach koodam aa? ¡Aañ jix maat jia nap aap jir diꞌ gu Dios gu maaxik duakam! ");
INSERT INTO stpNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Guꞌ ji na guꞌ maaꞌn nat jax ñiok gu Jesuus, jup tɨtda: ―¡Chaꞌp ñiokdaꞌ cham kɨɨꞌ iiꞌmdaꞌ nap naanbichuꞌn dhiñ jaduuñ! ¡Mup buusniaꞌ bhaiꞌ dhɨr bhaan! ¡Chaꞌp bhaiꞌ pu tuiꞌñgɨdaꞌ! ");
INSERT INTO stpNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Baꞌx ioꞌm xi bhɨi gu maaꞌnkam nat paiꞌ ba ji buus gu cham kɨɨꞌ iiꞌmdaꞌ bhaiꞌ dhɨr bhaan. Gɇꞌ xi jiiñkɨk nat baꞌ pɨk ba buus. ");
INSERT INTO stpNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Baꞌ dappaam miꞌ puiꞌ pup tuꞌiiꞌ am dho gi ji baꞌx ioꞌm gu jaꞌtkam, dai nam naiꞌ tɨim tɨ tɨkkaꞌn dɨɨlh jix dhuꞌnpiꞌñ kɨꞌn, jup kaiꞌch am: ―¿Jax baꞌr jum duukam chi dhiꞌ puiꞌ? Gi nach cham jɨꞌxkat paiꞌ dhuuk puiꞌ chɨ nɨidhat na jax tu buim dhi Jesuus. Tɨɨꞌ na sia gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ tuꞌ pɨx ja ɨlhiiꞌñ, jix jɨɨgiꞌñ am. ");
INSERT INTO stpNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Baꞌ cham mɨɨkim na mɨt bɨɨx puiꞌ ba tɨ kai gu jaꞌtkam na jɨꞌx jir Galilea na jɨꞌk jax tu buim gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Baꞌ jaꞌxpɨx nat ba buus gu Jesuus miꞌ dhɨr chiop, na xi chu ja aꞌgidhimɨk gu jaꞌtkam, sɨlh jii mummu gama jaꞌk nam paiꞌ tu baꞌaak gu Simoon gio gu Anrees. Baꞌ bɨɨx jaiꞌ xi jiim am gu Jakoobo gio gu Juan. ");
INSERT INTO stpNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Baꞌ gu daadaꞌn gu Simoon mɨjɨ ka boꞌ baꞌk chɨr jum bakxidhat na ɇɇ gu toiñdhiꞌ. Baꞌ nat jax mu ai gu Jesuus, ba aagiꞌñ am gu miꞌ oiꞌñkam nax kaꞌook. ");
INSERT INTO stpNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Baꞌ muiꞌ ji ai gu Jesuus miꞌ na paiꞌ boꞌ, baꞌ daagɨk nobiꞌran xi bamiiꞌ. Jix kɨɨꞌ bhaiꞌ ji bam miꞌ jotmodaꞌ pɨx, baꞌ dai nat ba tu ja onbaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Baꞌ nat paiꞌ ba bhiꞌñ gu tanoolh, na puiꞌ bax dhɨdɨmpuꞌ, muiꞌ jaꞌtkam pɨx jaꞌx ji ai mɨt miꞌ baꞌaak kɨɨk na paiꞌ daa gu Jesuus ji ja baidhat gux kakoꞌkkam, jaiꞌ guiꞌ nam ampɨx jix ñanaanbiꞌ kaꞌ na ja aꞌm jup tuiꞌkaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Giilhim muiꞌ mɨt miꞌ mam jumaap kiꞌñgob gu mi jaꞌp oiꞌñkam na jɨꞌx jir kiicham. ");
INSERT INTO stpNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Baꞌ pɨx jaꞌx ji ja duduaꞌñ gu Jesuus gux kakoꞌkkam, na guꞌ mi jaꞌp moo bɨɨx aixim tuꞌm jup tɇ ɇɇkaꞌ gu koꞌkdaiꞌ. Jaiꞌ guiꞌ nam ampɨx jix ñanaanbiꞌ kaꞌ, bɨɨx jaꞌk ja joot gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr. Pu cham ja doꞌñcho nam jax bha tu aꞌga gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ, na guꞌx bhaiꞌx maat na noꞌt jax dhuuk xi ja doꞌñcho nam bha tu aꞌgaꞌ, miꞌ maaxik ba kɨɨsaꞌ am nar tuꞌp tuꞌm daꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Baꞌ bɨjɨk ba bam gu Jesuus na kapup jix chukgam, baꞌ ma jii nammɨ gama jaꞌk na paiꞌr gampɨx. Miꞌ baꞌ bhaiꞌ ji chu aꞌga jix dhaam jaꞌk buiñor guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Baꞌ jaꞌxpɨx nat paiꞌx bhaiꞌ ba xiaꞌ, muiꞌp ma gaagam gu Simoon bamgɨk ja bɨɨm guiꞌ nam takaab dɨr maap jii mɨt gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Baꞌ nammɨ pɨx ji chɨɨ mɨt na paiꞌ ka oirɨ, baꞌp tɨtda am: ―Bhammɨ tɨim gaꞌngaꞌ am muiꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Guꞌ ji na guꞌp ja tɨtda gu Jesuus: ―Gatuuk jach dho gio bhaiꞌp aayaꞌ, na guꞌ ka tum aagim. Maik gor kiaꞌ mɨjɨni jaꞌp na jax jir kikcham, sia dai ya jaꞌp miaꞌn kiaꞌ, nam baꞌ guꞌ bɨɨx jup jix mat kaꞌ gu jaꞌtkam nañ jɨꞌk jax tu aꞌga, na ñich guꞌ pu kaiꞌñkam bha jii. ");
INSERT INTO stpNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bhaiꞌ baꞌ pu oirɨdaꞌ na jɨꞌx jir Galilea na tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam bha jaꞌp nam jax tu chichiopiꞌ. Gio baꞌ na jaꞌk ja jootsaim gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr guiꞌ nam jix ñanaanbiꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Baꞌ maaꞌnnim mu ba ai maaꞌn gux koꞌkkam na paiꞌ oirɨdaꞌ gu Jesuus, na tootolhidhat bha gakiidhaꞌ gu tukgaꞌn. Baꞌ miꞌ oꞌlhiaꞌn kɨꞌn ji kɨkbuk bɨɨpɨꞌ dɨr jup tɨtda: ―Aañ jaꞌpni moo soiꞌ bham tɨɨdam jiñ jaduuñ nañ jaꞌp tɇ kɇɇ nap bɨxchuꞌx aichuꞌn nach chuꞌ cham paiꞌ nɨiꞌñ, nap iam jiñ dhuaꞌñdhaꞌ noꞌp moo puiꞌp ɨlhiiꞌñdhaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Baꞌx joiꞌmdak ba tɨɨ gu Jesuus, baꞌp tɨtda bhaiꞌ xi dhaagɨk: ―Jir am dho, nañ guꞌ pu kaiꞌñkam ya oirɨ. Jaiñ, ba dua pich. Chaꞌp jax kam aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Baꞌ dai nat puiꞌ jɨꞌ xi chɨɨꞌn, jotmodaꞌx bhaiꞌ bhaiꞌ ji chu taatdat. Jix kɨɨꞌp jum duu, pu cham paiꞌ ka tu koꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Baꞌ gu Jesuus tɨi xi sooꞌmchulhdhak ba joot na cham tu aaꞌndaꞌ nat jax dhuuk dua, jup tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Dai nap moo cham jaroiꞌ aagiꞌñdhaꞌ na ñich aañ jum duaꞌñ. Dai nap sɨlh jimiaꞌ bhammɨ na paiꞌ daa guiꞌ na jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, na baꞌm tɨgiaꞌ na pich ba dua. Xi chɨkkadaꞌ ap. Noꞌ jax kaiꞌch nap bax kɨɨꞌ, dai nap tu makgɨrtai tɨtɨkiaꞌ na jax jaꞌk aagix nat tu uaꞌnak gu Moisees, nam baꞌ bax mat kaꞌ gu jaꞌtkam nat ba buus gu koꞌkdaiꞌ dhiꞌ nap kɨꞌn kax kaꞌook kat. ");
INSERT INTO stpNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Guꞌ ji na guꞌ guiꞌ moo janoꞌ nat jax jii, pɨx jaꞌx ja aagiꞌñ gu jaꞌtkam. Giilhim bɨɨx puiꞌ bax chu maat am. Baꞌ puiꞌ miꞌ pup oirɨ gu Jesuus gampɨx, mɨjɨ jaꞌp tɨbiappudaꞌ, na guꞌ cham ka aaꞌ na maaxik bhammɨ jaꞌp oirɨdaꞌ gɇꞌgɇr kikcham. Ku guꞌ puiꞌ pɨx muiꞌ miꞌp aajidhaꞌ am ji na paiꞌ oirɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Baꞌ gatuuk jɨꞌkchi jurniꞌñ kɨꞌn gio miꞌp ba ai gu Jesuus Kapernaum. Miꞌ paiꞌ maaꞌn kiicham pɨx ba kaidhaꞌ na tɨbiap. ");
INSERT INTO stpNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Baꞌ jotmodaꞌ pɨx jaꞌx ji ai mɨt gu jaꞌtkam, giilhim muiꞌ miꞌ mam jumaap jamɨt. Jix kabkam suuꞌn jamɨt mɨjɨ baꞌk chɨr, pu cham jir buusan mi kiꞌñgob, na guꞌ miꞌ dhɨr dɨɨrap dɨr nammɨ jaꞌp jup xi juꞌ am. Gu Jesuus baꞌ dai na tu ja aꞌgiꞌñchuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Baꞌ jaꞌxpɨx maaꞌn miꞌ ba aich jamɨt gux ioꞌm jix maꞌmkulhiꞌ maakob dɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Baꞌ ɨlhdhat am nam jiimɨt mɨjɨ pu baapkiaꞌ gɨt baꞌk chɨr na paiꞌp tuꞌiiꞌ gu Jesuus, guꞌ ji na guꞌ cham bhaaiꞌ, nam guꞌ giilhim jix kabkam suudaꞌ gu jaꞌtkam. Puiꞌ mɨt alhiꞌch ma dɨgaar gu baꞌaak daam dɨr na mɨt baꞌ mu tɨsaaꞌñdhak bhaiꞌ dhɨr mu tɨbaañ bakxidhar taꞌm mɨjɨ na paiꞌp tuꞌiiꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Baꞌ nat ba ja tɨɨ gu Jesuus nam buiñor jix biiñaktuꞌ, jup tɨtda gux maꞌmkulhiꞌ: ―Chaꞌp jax kam aaꞌndaꞌñ jaduuñ. Ba uañchudhix ji matgam gum uaꞌtulhdharaꞌ, na ñich guꞌ aañ puiꞌ ba tɨi. ");
INSERT INTO stpNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Baꞌ jɨꞌkchi miꞌp daraa am guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, baꞌp jum aaꞌ am ja jujur am bhaan: ");
INSERT INTO stpNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Jax baꞌ ɨlhdhat jup kaiꞌch? ¿Jaꞌxbuiꞌ aa sap tɨi gɇꞌkam jup xim ɨlhiiꞌñ na gu Dios? ¿Jaroo gip ba uañchuda gu tuꞌ uaꞌtulhdharaꞌ gu jaroiꞌ yaꞌ kam pu chuꞌm ɨp jix uaꞌtulhdhix kam? Dios dho gi jɨɨꞌ ji.” ");
INSERT INTO stpNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Guꞌ ji na guꞌx bhaiꞌx maat gu Jesuus juraꞌran bhaan nam jax jum aaꞌ, baꞌp ja tɨtda: ―Ni jɨꞌx iam kur puiꞌ na pim jax jum aaꞌ gu jam jujur am bhaan. ");
INSERT INTO stpNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Na guꞌ cham pɨk xijai noꞌñ jax kaiꞌch: “Ba uañchudhix ji matgam gum uaꞌtulhdharaꞌ”, na guꞌ cham maatɨꞌ kaꞌ noꞌ moo puiꞌ ji buusniaꞌ piam ku guꞌ cham. Guꞌ ji noꞌñ jax kaiꞌch: “Xi bamiiꞌ, munip jaꞌp ba oirɨdaꞌ bhɨɨji gum bakxidharaꞌ”, dho gi guꞌx xijai ji, na guꞌx maatɨꞌ kaꞌ noꞌt cham puiꞌ ji buus. ");
INSERT INTO stpNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ku baꞌ guꞌ aañ xib yaꞌ duaꞌñdhaꞌ ji dhiñ jaduuñ nax maꞌmkulhiꞌ na pim bax mat kaꞌ na aañ nat bhañ joot gu Dios, jir gɇꞌkam iñ nañ baꞌ yaꞌ tu uañchudaꞌ gu uaꞌtulhdharaꞌ yaꞌ dhi oiꞌñgaꞌn. Baꞌp tɨtda gux maꞌmkulhiꞌ puiꞌ xi chɨꞌɨɨk: ");
INSERT INTO stpNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Aapiꞌñ jaduuñ nap jix maꞌmkulhiꞌ, xi bamiiꞌ. Ba jimiaꞌ ap jum kiꞌaam, bhɨɨji ap dhim bakxidharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Baꞌx kɨɨꞌ bhaiꞌ ji bam guiꞌ na kax maꞌmkulhiꞌ kat nat jax pu tɨɨꞌn gu Jesuus. Baꞌ dai nat ba jii xi bhɨɨk gu bakxidharuꞌn, muiꞌ ba buus ja saagiꞌñ gu jaꞌtkam gaammɨjɨ ji dhuu. Baꞌ miꞌ puiꞌ pup tuꞌiiꞌ am bɨɨx, miꞌ dhɨr baꞌ ma tu daanɨ mɨt buiñor gu Dios, jup kaiꞌch am: ―¡Mooch pɨk cham jɨꞌxkat puiꞌ tɨ nɨidhat ji jich Gɨꞌkoraꞌ! ");
INSERT INTO stpNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Baꞌ mɨkkat gioꞌp ma jii gu Jesuus mummu jaꞌp juꞌñdharan na paiꞌ gɇꞌ suuꞌnkaꞌ gu suudaiꞌ. Baꞌ muiꞌ jaꞌtkam miꞌ mam jumaap jamɨt na paiꞌ ka oirɨ, baꞌ xi chu ja aꞌgidhimɨk. ");
INSERT INTO stpNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Baꞌ jaꞌxpɨx nat giop ba jii, nat nammɨ ba ji bhɨi jupaaban na paiꞌ tum namkiꞌñ noꞌñ gɇꞌ tu bhiiñor, miꞌ pɨx ji chɨɨ gu Lebii, maraaꞌn gu Alpeo, guiꞌ nar tuumiñ tu taandam tugiꞌñ kaꞌ gux ioꞌm gɇꞌkam Rooma kam, Seesar tɨɨgim, na miꞌ daakat pɨx ji dhaagim gu tuumiñ guiꞌ nam miꞌ tu namkidhim. Baꞌ muiꞌ ji ai gu Jesuus, mi jaꞌp amuub xi kɨkbuk jup tɨtda: ―Aañ puiꞌ ɨlhiiꞌñ jiñ jaduuñ nap xib dɨr gammɨjɨ bañ kaichgɨdaꞌ. Baꞌ guiꞌ nat jax kɨkbuk pɨx chuꞌp jum duu cham jax ji chɨꞌɨɨk, gammɨjɨ pɨx koꞌkmar jiim am. ");
INSERT INTO stpNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Baꞌ gatuuk ma ja baidhak gu Lebii gu jaꞌtkam mummu kiaꞌmiꞌñ nam miꞌ tu jugiaꞌ buiñor. Moo jimchuꞌ gu Jesuus gio gu jaꞌtkam tugiꞌñ, gio jaiꞌ guiꞌ nam jir tuumiñ tutaandam tugiꞌñ kaꞌ gux ioꞌm gɇꞌkam Rooma kam Seesar tɨɨgim, gio guiꞌ nam puiꞌ ja biaꞌkaꞌ gu gɇꞌgɇrkam jum aaꞌndam nam sap cham tuꞌ kaꞌm tɨ nɨiꞌñ. Baꞌ gu Jesuus jix bhaiꞌm taatɨt bhaiꞌ ji chu juu ja bɨɨm, nam guꞌ muiꞌ ba kaichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Baꞌ jɨꞌkchi guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios gio guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, am bhaak jamɨt na mɨt tɨɨ gu Jesuus na ja bɨɨm tu kuaꞌ guiꞌ nam jir tuumiñ tutaandam tugiꞌñ kaꞌ gux ioꞌm gɇꞌkam Rooma kam, Seesar tɨɨgim, gio guiꞌ nam puiꞌ ja biaꞌkaꞌ nam sap cham tuꞌ kaꞌm tɨ nɨiꞌñ. Baꞌ jaꞌp jaꞌk xi ja boosgak jamɨt gu jaꞌtkam tugiꞌñ gu Jesuus, jup ja tɨtda am: ―¿Jax ku baꞌ ja bɨɨm tu kuaꞌ dhi jam gɇꞌkam tuk dhi tuumiñ tutaandam gio dhiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñ? ");
INSERT INTO stpNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Guꞌ ji na guꞌ ja kɇɇ gu Jesuus nam jax kaiꞌch, baꞌp ja tɨtda: ―Dho na guꞌ dhiꞌ jaꞌpni jia na jax gu jaꞌtkam noꞌm jix kɨkɨɨꞌ, na guꞌ cham ja aꞌm jum aaꞌndaꞌ na jaroiꞌ ja duduadhiꞌñdhaꞌ, na guꞌ dai nam gɇꞌgɇrkam jum taat kaꞌ. Guꞌ guiꞌ ji nam jɨꞌk jix kakoꞌk kaꞌ na baꞌ ja aꞌm jum aaꞌndaꞌ, nam guꞌ soiꞌm ɨlhiiꞌñdhaꞌ nam jix dhuduadhim kaꞌ. Baꞌ aañ na ñich bha jii yaꞌ dhi oiꞌñgaꞌn bhaan, cham tuꞌ pu kaiꞌñkam bha jii ñich nañ baꞌ ja baidhikaꞌ guiꞌ nam gɇꞌgɇrkam jum taat, nam puiꞌm aaꞌ nam tuꞌ kaꞌm tɨ nɨiꞌñ, guꞌ jaꞌpji guiꞌ ji nam jɨꞌk bax maat nam jix uꞌuaꞌtulhdhix, nam guꞌ soiꞌm ɨlhiiꞌñ buiñor gu Dios. Dhiꞌ jɨꞌ ji nañ baꞌ ja baidhikaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Baꞌ maaꞌnnim jɨꞌkchi gu jaꞌtkam muiꞌ ma tɨkkam jamɨt gu Jesuus na sap jax kum baꞌ cham jɨꞌxkat paiꞌ dhuuk ja nɨiꞌñ nam jum saab gu jaꞌtkam tugiꞌñ. Na guꞌ guiꞌ nam kaichuꞌ gu Juan gio guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, gammɨjɨ pɨx ja nɨiꞌñdhaꞌ am nam jum saabdaꞌ. Baꞌp tɨtda am mummu ɇɇk: ―¿Jax ku baꞌ aap gum jaꞌtkam tuk cham jɨꞌxkat paiꞌ dhuuk ja nɨiꞌñ ich nam jum saab? ");
INSERT INTO stpNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Baꞌp ja tɨtda gu Jesuus: ―Dho na guꞌ dhiꞌ jaꞌpni ji buusan jia na jax noꞌ jaroiꞌ mu paiꞌ ba xim tɨɨmum, nam guꞌ cham jum saabum jum ɨlhiiꞌñdhaꞌ gu jajaaꞌnniꞌñ, nam guꞌx chu nak kaꞌ gu koiꞌ. Baꞌ puꞌñip ji buusan ja bui dhiñ jaꞌtkam tuk, cham jum saabum jum ɨlhiiꞌñ am gu xib, nam guꞌx bhaiꞌm taat nañ yaꞌ kap tuꞌiiꞌ ja bui. ");
INSERT INTO stpNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ku guꞌ kam aajim ji nam paiꞌ dhuuk jiñ dhagiaꞌ guiꞌ nam boiñ bhɨichdhaꞌ, janoꞌ dho gi baꞌ bam saabuꞌ am ji. ");
INSERT INTO stpNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Na guꞌ dhiꞌ jaꞌpni ji buusan jia na jax gu jaroiꞌ noꞌt alhiꞌch ɨɨkɨk gu xibkam jannulh tɨi xi dhaax gu tɨiꞌdhargaꞌn noꞌr kɨlhiiꞌñgaꞌn. Maaꞌn na jax giop sarniaꞌ bɨɨx xikoolh dhɨr, na guꞌ bhaiꞌ ji soꞌlhkaꞌ gu xibkam jannulh na paiꞌ dhuuk xi bakuanaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Piam jaꞌp na jax gu biiñ, nam guꞌ xixiibkam jajoꞌ bopko bhaan tu aidhaꞌ gu buusaiꞌñdham, na guꞌ noꞌr kɨklhiꞌñgaꞌn, maaꞌn na jax xixiipñiaꞌ, pu bɨɨx jum nuꞌaaꞌ dho guꞌ, na guꞌ giilhim jix oꞌjoꞌ kaꞌ. Puiꞌ kum baꞌ xixiibkam jajoꞌ bopko taꞌm bhaan tu aidhaꞌ gu biiñ guiꞌ na kiaꞌpɨx buusnidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Baꞌ maaꞌnnim na paiꞌ dhuuk cham tum juandaꞌ, ma jii gu Jesuus nammɨ gama jaꞌk maaꞌn kap, moo miꞌ buusnichuꞌ na paiꞌ tɨ ɨx gu tiriik. Baꞌ gu jaꞌtkam tugiꞌñ na ja bɨɨm jimchuꞌ, xi uꞌiidhat gu muraaꞌn gaꞌn xi kaipgaidhat tu koꞌiim am. ");
INSERT INTO stpNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Baꞌ pɨx am bhaak jamɨt jɨꞌkchi guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, na mɨt guꞌ ja tɨɨ nam ka tu uꞌiim gu tiriik muraadaꞌ. Baꞌ mu boopok jup tɨtda am gu Jesuus: ―¿Jax kum baꞌ puiꞌ tu buim dhim jaꞌtkam tuk? ¿Kux cham maat am aa na xib cham tum juan? ");
INSERT INTO stpNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Baꞌp ja tɨtda gu Jesuus: ―¿Kux aapiꞌm cham jɨꞌxkat tu jiñkuiꞌñ aa miꞌ uꞌuan taꞌm nat jax tu duu gu Dabii gio gu jaꞌtkam tugiꞌñ janoꞌ maaꞌnnim nam paiꞌ dhuuk ba uaꞌmaim? ");
INSERT INTO stpNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Na mɨt tu juu bo gu paan guiꞌ na miꞌ tɨkiix kat gɇꞌ chiop, nat ja maa gu Abiatar guiꞌ na miꞌr ja gɇꞌkam tuk kaꞌ janoꞌ guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, na saak dai guiꞌx bhaaiꞌn kaꞌ nam kuaꞌdaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jaꞌpni baꞌ moop ja tɨtda jia: ―Puiꞌ kuñ baꞌ aañ cham paiꞌ jax ja tɨtda dhiñ jaꞌtkam tuk, sia kuñ ja nɨiꞌñ nam jax tu buim. Na guꞌ na paiꞌ dhuuk cham tum juandaꞌ, dai nañ jiñ jɨɨpiꞌñkaꞌ noꞌñ jix aaꞌ cham jax ji kaiꞌchɨt. Piam kuñ guꞌ tuꞌ jax jup jix dhuñiim, ¿jax gip bua? Na guꞌ dhi tanoolh cham tuꞌ jax kaiꞌñkam puiꞌ jaꞌk jum duu nañ bɨxchuꞌ jix chu xidhuutuꞌn kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na guꞌ pur cham tuꞌ gu puiꞌ na pim jax jaꞌk tɨi xi ɨlhiiꞌñ aapiꞌm. Aañiꞌ ji nañ jix maat, nat guꞌ pu kaiꞌñkam bhañ joot guñ Gɨꞌkoraꞌ nañ baꞌ yaꞌ ja aagiꞌñdhaꞌ gu jaꞌtkam bɨɨx nam jɨꞌk tuꞌ jax buadaꞌ, sia na paiꞌ dhuuk cham tum juandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Baꞌ mɨkkat nat giop bam ai na paiꞌ dhuuk cham tum juandaꞌ, gio muiꞌp ma jii gu Jesuus maaꞌn kap nam paiꞌ tu daandaꞌ gu Israel kam jaꞌtkam, baꞌ jimdat mɨjɨ ji baa. Baꞌ maaꞌn mɨjɨp daa gu maaꞌnkam nax muuk kaꞌ gu nobiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Baꞌ pɨx nɨidhim am gu Jesuus guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, ea noꞌt sap moo ba ji dhuaꞌñ guiꞌ nax muuk kaꞌ gu nobiiꞌñ, na sap baꞌ dhiꞌ bhaan jix bhaaiꞌn kaꞌ nam jax tɨꞌyaꞌ nam iattulhdhaꞌ. Na guꞌ janoꞌ aagix kaꞌ na cham tum juandaꞌ, nam cham tuꞌ jax buadaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Baꞌ muiꞌ ba baiꞌñ gu Jesuus guiꞌ nax muuk kaꞌ gu nobiiꞌñ, jup tɨtda: ―Eap bhaiꞌ xi jim jiñ jaduuñ. Yaꞌni jaꞌp jap xi kɨkbuꞌ amuub. ");
INSERT INTO stpNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Baꞌ puiꞌ xi chɨɨdak jup ja tɨtda ɨp gu jaiꞌ guiꞌ nam miꞌx bhaamut nɨiꞌñ: ―¿Jax pɨn jum kaiꞌch gu ñioꞌkiꞌñ gu Dios miꞌ na paiꞌ tu uaꞌñix? ¿Tuꞌ pɨn jix bhaaiꞌ nach jax buadaꞌ na paiꞌ dhuuk cham tum juandaꞌ, nach jix bhaiꞌ tu buadaꞌ aa pɨn, kaꞌ pɨn nach jix buam tu buadaꞌ aa? Puiꞌ na jax gu jaroiꞌ noꞌx ioꞌm jix kaꞌook, ¿jax jaꞌk jum aagidhaꞌ, nañ dhuaꞌñdhaꞌ aa, kaꞌ nañ miꞌ pɨx xi ñɨiꞌñdhaꞌ aa noꞌ mi jaꞌp ba mumkɨ jiñ chaagiob? Alh pu ni jaroiꞌ ku ñiok, miꞌ pɨx pu tuꞌiiꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Baꞌ naiꞌ xi ja nɨiꞌñ gu Jesuus bɨɨx xikoolh gu jaꞌtkam jix buam jum ɨlhdhat, jɨꞌx tɨi am jix bhaamum jum ɨlhiiꞌñ, na guꞌ ni jɨꞌx ku ja jujur am baapak na jax tɨi tu ja aꞌgiꞌñ. Baꞌp tɨtda ɨp gio gu maaꞌnkam guiꞌ nax muuk kaꞌ gu nobiiꞌñ: ―Eap xi sɨlhiiñ dhim nob jiñ jaduuñ. Baꞌ guiꞌ jaꞌp jup xi sɨlh, jix kɨɨꞌp jum duu na jaꞌp xi joiñiꞌñ, panaas ku moo pu cham paiꞌx muuk kat. ");
INSERT INTO stpNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Baꞌ bhaakuk jotmodaꞌ jii mɨt guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ bhammɨ jaꞌk ja bui gu jaꞌtkam tugiꞌñ gu Eroodis guiꞌ na sap jir gɇꞌkam kaꞌ, nam sap baꞌ bhaiꞌ xi chu aꞌgai maap nam jax jaꞌk duuji muꞌaaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Guꞌ ji nat guꞌ ba jii gu Jesuus ja bɨɨm gu jaꞌtkam tugiꞌñ mummu jaꞌk na paiꞌ gɇꞌ suuꞌnkaꞌ gu suudaiꞌ na Galilea bhaan bipioꞌ gu dɨbɨɨr. Baꞌ muiꞌ jaꞌtkam pɨx chuꞌp tuiꞌdhiꞌ am nam mu oiꞌñchuꞌ, moo gu Galilea oiꞌñkam gio gu Judea kam. ");
INSERT INTO stpNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Gio jaiꞌm muiꞌp jimchuꞌ gu bhammɨ dɨr jaꞌk kam Jerusaleen, gio gu Idumea kam, jaiꞌ gu baasɨꞌn dɨr jaꞌk kam xiaꞌlhbui na paiꞌ bhɨix gu Jordaan Ak, gio guiꞌ nam bɨɨx xikoolh oiꞌdhaꞌ mummu na paiꞌ gɇꞌgɇr jir kikcham na paiꞌ Tiiro tɨ tɨɨꞌ gio jaꞌp jaꞌk na paiꞌ Sidoon tɨ tɨɨꞌ, nam guꞌ puiꞌ tɇ kɇɇ na gɇꞌgɇr jup jum duuꞌnkam jix bhaiꞌ tu buim gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Baꞌp ja tɨtda gu Jesuus gu jaꞌtkam tugiꞌñ nam sap maaꞌn jix ioꞌm juꞌñdharan jaꞌk xi buusaichulhdhaꞌ gu kanuub, na sap baꞌ bhaan bha tɨsdiaꞌ nam cham miꞌ kiꞌspaꞌ gu jaꞌtkam noꞌ miꞌ pɨx jaꞌp kɨɨk dɨɨrap. ");
INSERT INTO stpNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nam guꞌ giilhim muiꞌ pɨx ji aajim gux kakoꞌkkam, gio nam guꞌ alh na jɨꞌx kɨꞌn nam amuub jix aik na paiꞌp tuꞌiiꞌ, pɨx am jum tutkiꞌñ am, aaꞌndaꞌ gɨt nam jax pɨk jum duñiaꞌ, nam guꞌ puiꞌ tɇ kɇɇ nat muiꞌ ba ja duduaꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Baꞌ jɨꞌmaꞌn miꞌp oipo am gu jaꞌtkam na ja aꞌm jup tuiꞌñgɨdaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ na ja naanbichuꞌnkaꞌ. Baꞌ nam jax tɨgiaꞌ gu Jesuus, miꞌ ja oꞌlhia kɨꞌn ji guꞌnguk am bɨɨpɨꞌ dɨr, baꞌ gɇꞌ kɨꞌn muiꞌ pu nokiaꞌ gu maaꞌnkam, na guꞌ puiꞌ jaꞌk jurtuꞌndaꞌ gu cham kɨɨꞌ iiꞌmdaꞌ, jup tɨꞌyaꞌ: ―Aap jir diꞌ nap jir Maraaꞌn gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Guꞌ ji na guꞌ pu ja sosbhichulhiꞌñ gu Jesuus nam muiꞌ tɨi ji ñokiaꞌ nam sap cham miꞌ maaxik kɨɨsaꞌ nar tuꞌp tuꞌm daꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Baꞌ gatuuk ma jii gu Jesuus maaꞌn kap na paiꞌr oidhaꞌ taꞌm, xi ja baidhak jɨꞌkchi gu jaꞌtkam tugiꞌñ na jax chuꞌm jix aaꞌ dɨɨlh na ja bɨɨm jimdaꞌ, baꞌ guiꞌ ma oi mɨt ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Baꞌ na mɨt paiꞌ dhuuk bhammɨ tɨɨtɨs oidhaꞌ daam, bhaiꞌ ji ja aa nam jax chuꞌm bar noonbiꞌñ kaꞌ gammɨjɨ, mambhɨɨx daman gook moo aich. Dhiꞌ sap baꞌ bhaankamuꞌn naiꞌ ja jootsaꞌ nam tu ja aꞌgiꞌñpuꞌ gu jaꞌtkam gu ñioꞌkiꞌñ gu Dios, ");
INSERT INTO stpNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","gio nap ja tɨtda nam puiꞌp ba ja duduadhiꞌñdhaꞌ gux kakoꞌkkam, gio nam maiꞌ ja jootosdaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gu jaꞌtkam guiꞌ nam jix ñanaanbiꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Baꞌ gu Simoon maadɨt jir diꞌ na bar nobiiꞌñ, guiꞌ na gook kɨꞌn jix mat kaꞌ gu Jesuus, Simoon Peegro tɨɨtɨꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Miꞌ dhɨr baꞌ moo gu Jakoobo gio gu Juan, daim sɨspidhim, maamraꞌn gu Sebedeo, guiꞌ nax joiꞌñdhaꞌ na Boarnerjes ja tɨɨtɨꞌndaꞌ gu Jesuus, na jaꞌp kaiꞌñkam jup jum kaiꞌch: Jix bhaaꞌmnagɨm. ");
INSERT INTO stpNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Gio baꞌ miꞌ dhɨr moo gu Anrees, Piliip, Bartolomee, Mateo, Tomaas, gio gu jumai Jakoobo, maraaꞌn gu Alpeo, gio gu Tadeo, gio baꞌ gu jumai Simoon, guiꞌ na ja kaichgɨdaꞌ guiꞌ nam kananiistas jum tɨɨtɨꞌndaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","gio baꞌ gu Juudas Iskariote, guiꞌ na gatuuk ja aaꞌñdharaꞌ gu gɇꞌgɇrkam jum aaꞌndam na paiꞌ oirɨdaꞌ gu Jesuus nam baꞌ boi bhɨichdhaꞌ. Baꞌ gatuuk na mɨt jaꞌk suulhgɨk bhammɨ dɨr na mɨt paiꞌ jimɨɨk, gio miꞌp ji ai mɨt nam paiꞌx joiꞌñdhaꞌ nam tɨbiappudaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Baꞌ cham jɨꞌx mɨɨkim gio pɨx jaꞌx jup ji ai mɨt gu jaꞌtkam, giilhim muiꞌ miꞌ mam jumaap jamɨt, pu cham jax jix bhaaiꞌ na tu jugiaꞌ gu Jesuus ni gu noonbiꞌñ, na guꞌ dai nam tɨi ja palhbuiꞌñchuꞌ gux kakoꞌkkam. ");
INSERT INTO stpNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Baꞌ puiꞌ ba tɨ kai mɨt gu jajaaꞌnniꞌñ gu Jesuus na cham bhaaiꞌ na jax tu jugiaꞌ. Baꞌ bhaiꞌ ma jii mɨt mummu dɨr nam paiꞌ oiꞌdhaꞌ na mɨt bhaiꞌ ba baidham, nam guꞌ jaꞌp jum aaꞌ na cham juraaꞌn ka biaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Guꞌ baꞌ gu Jerusaleen kam na mɨt miꞌp ai guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, maakam jup aiꞌchuxiꞌñ am gu Jesuus, jup kaiꞌch am na sap jajoꞌk gu ja gɇꞌkam tuk bhaan jup tuiꞌdhiꞌ, puiꞌ sap kum baꞌx jɨɨgiꞌñ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ na maiꞌ ja jootos ja aꞌm dɨr gu jaꞌtkam jix ñanaanbigɨm. ");
INSERT INTO stpNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Guꞌ ji na guꞌx maat gu Jesuus nam jax kaiꞌch, baꞌ maap ja jumpadak bhaiꞌ ji chu ja aꞌgi bhaan ji chu uaꞌrgidhidhat gu tuꞌ na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch nam sap baꞌx maatɨt kaayaꞌ. Jup ja tɨtda jia: ―Ni jɨꞌx iam kur puiꞌ na pim jax kaiꞌch. Jax dhui na cham jɨꞌxkat maiꞌ ja jootsaꞌ gu jaꞌook gɇꞌkam jum aaꞌndam gu bɨɨmaꞌn tuutuꞌm jajoꞌk, nam guꞌ maaꞌn iiꞌmdaꞌp duuk. Na guꞌ noꞌt maadɨt tɨi maiꞌ xi joot, jaꞌp ji buusniaꞌ na dɨɨlh maiꞌm jootsaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Na guꞌ dhiꞌ jaꞌpni na jax gu dai gɇꞌgɇrkam jix kakaiꞌ noꞌm cham maaꞌn ñiꞌook jup duuk, noꞌm jɨꞌmaꞌn tuꞌ tɨi jax jix dhuñiim na jax jaꞌk jir joidham, noꞌm guꞌ jaiꞌ maakam jup kaiꞌchim, miꞌ pu cham tuꞌ jax ji dhuuji mam pataasaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Piam jaꞌp na jax gu jaꞌtkam noꞌm jir maap jum oiꞌdhagɨm noꞌm daim kokda, nam guꞌ miꞌ puiꞌ xi kaiꞌchimɨi gammɨjɨ pɨx taꞌtak jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Puꞌñip jum duñiaꞌ gɨt gu jaꞌook gɇꞌkam jum aaꞌndam noꞌ jax dhuukat bhaiꞌ ji bhaamuꞌ gɨt ja bui gu bɨɨmaꞌn tuutuꞌm jajoꞌk, na guꞌ miꞌ pɨx jaꞌp ji biꞌyaꞌ gɨt baꞌ, cham ka nɨnɨiꞌñdhaꞌ am gɨt gu noonbiꞌñ, nam guꞌ ba bhaakuꞌ gɨt buiñor. ");
INSERT INTO stpNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Guꞌ matgam gu jaꞌook gɇꞌkam jum aaꞌndam cham aaꞌ ji na jaroiꞌ tuꞌ kɨꞌn ja juandaꞌ gu bɨɨmaꞌn tuutuꞌm jajoꞌk. Na guꞌ dhiꞌ jaꞌpni ji buusan na jax maaꞌn gu maaꞌnkam jix oogɨm jix bhangɨm noꞌ miꞌ paiꞌ kio, nam bɨɨx pɨx jix ɨɨbhiꞌñdhaꞌ gu jaꞌtkam nam amuub aayaꞌ, sia kum tɨix chɨ ɨɨxdham gu bɨxchugaꞌn. Dai gu jaroiꞌ noꞌx maat nax ioꞌm jix ooꞌ na baꞌ mu jimɨi xi buuprai bha jaꞌp xi dhaasai na baꞌ ba tɨ ɨɨxdhaꞌ gu bɨxchugaꞌn. Baꞌ aañ xib puꞌñip ji buusan na jax guiꞌ nax ioꞌm jix ooꞌ, na guꞌ pur cham tuꞌ aañ jiñ bui gu jaꞌook gɇꞌkam jum aaꞌndam, pu ni jɨꞌx dho moo kur jiñ jupaabkam. ");
INSERT INTO stpNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨɨdaꞌ, bɨɨx na jɨꞌk jaꞌtkam jix bhaaiꞌ na jax jaꞌk duuji uañchudhix kaꞌ gu ja uaꞌtulhdharaꞌ, sia kum giilhim jix buam tu ñiok, dai na bɨɨpɨꞌm aaꞌ nam soiꞌm ɨlhdhaꞌ buiñor guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Guꞌ baꞌ guiꞌ nam jɨꞌk jix kɨꞌɨɨꞌn gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ, dai nam pɨx am tɨꞌñchukaꞌ nam gammɨjɨm tulhiiñaꞌ, na guꞌ cham jɨꞌxkat ka oñiaꞌ gu ja uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Baꞌ dhiꞌ na puiꞌ jɨꞌ ja tɨtda, na miꞌ pɨx ja aagiꞌñ na gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ bhaan jup tuiꞌdhiꞌ, cham tuꞌ na tuꞌ jajoꞌk gu ja gɇꞌkam tuk nam jax aiꞌchuxiꞌñ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Baꞌ jaꞌxpɨx miꞌ ba ai mɨt dho gi ji baꞌ gu jajaaꞌnniꞌñ gu Jesuus gio gu dɨꞌɨɨꞌn, mummu jaꞌp ji guguu mɨt gama jaꞌk, na guꞌ cham bhaiꞌ nam jax miaꞌn aayaꞌ, nam guꞌ giilhim muiꞌ mi jumpax gu jaꞌtkam bɨɨx xikoolh dhɨr miꞌ na paiꞌp tuꞌiiꞌ. Baꞌ mɨjɨ xi chu joochxi mɨt na sap mu jimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Baꞌ puiꞌp ba tɨtda am guiꞌ nam mi jaꞌp miaꞌn daraa bɨɨx xikoolh dhɨr: ―Miꞌ sap paiꞌ ba ai mɨt gum jaaduñ gio gum naan, sap jum gaagim am. ");
INSERT INTO stpNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Baꞌp ja tɨtda gu Jesuus: ―¿Jax japim baꞌ ɨlhdhat puiꞌ kaiꞌch? Jax dhui nañ aañ cham tuꞌ puiꞌ ɨlhiiꞌñ nam dai guiꞌr jiñ jaaduñ gio guñ ñaan. ");
INSERT INTO stpNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Baꞌ puiꞌ xi chɨꞌɨɨk naiꞌ xi ja tɨɨgɨk guiꞌ nam mi jaꞌp daraa bɨɨx xikoolh dhɨr, jup ja tɨtda: ―Na guꞌ aapiꞌm jaiꞌ dhɨt na pim yaꞌ daraa, puiꞌp bar jiñ jaaduñ japim. ");
INSERT INTO stpNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Na guꞌ gu jaroiꞌ noꞌ miꞌ puiꞌ ba jimchuꞌ na jax jix aaꞌ gu Dios, dhiꞌ bar jiñ jaduuñ kaꞌ gio nar jiñ ñaan kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Baꞌ mɨkkat jɨꞌkchi jurniꞌñ kɨꞌn gio bhaiꞌp ji chu ja aꞌgi gu Jesuus gu jaꞌtkam, mummu ɇɇk juꞌñdharan na paiꞌ gɇꞌ suuꞌn gu suudaiꞌ na Galilea bhaan bipioꞌ gu dɨbɨɨr. Baꞌ gook alh miꞌ ka jumpax am nat jax bhaiꞌ ji chu aꞌga, guꞌ ji na guꞌ cham jɨꞌx mɨɨkim giilhim muiꞌ miꞌ mam jumaap jamɨt. Puiꞌ bhaiꞌ ma tɨs kanuub taꞌm, na guꞌ mi jaꞌp amuub jup sɇꞌ suudaiꞌ jugiꞌñ. Bhaiꞌ baꞌ ji dhaakat bha tu ja aꞌgiꞌñ gu muiꞌ jaꞌtkam nam miꞌp tuꞌiiꞌ dɨɨrap. ");
INSERT INTO stpNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Bɨxchuꞌ bhaan ji chu uaꞌrgidhat na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch nam sap baꞌx maatɨt kaayaꞌ. Baꞌ maaꞌn jaꞌpni moo muiꞌ ji kɨi nat muiꞌ ji chu aꞌga: ");
INSERT INTO stpNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Ea na pim moo bɨɨx jam jujur kɨꞌn xiñ kaayaꞌ nañ jax jam tɨɨdaꞌ. Maaꞌnnim maaꞌn gu maaꞌnkam xi chu moikdak mummu paiꞌp ka jii, jɨꞌkchi moo xi jur na miꞌ pɨx katkaꞌ gu moikdaꞌn. Guꞌ ji na guꞌ mi jaꞌp tum oipodaꞌ, jotmodaꞌ pɨx am boi ba kaat mi moikaꞌn tɨr. ");
INSERT INTO stpNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Baꞌ gatuuk nat muiꞌ ji chu giiꞌ gu tiriik, maaꞌn na mɨt jax jugio gu uꞌjiꞌ nam mi jaꞌp nɨnɨꞌ guiꞌ nat miꞌ suulh na paiꞌ pɨx am boi ba kaat, na guꞌ maaxik pɨx dharaat, na guꞌ bax chu kabaak. ");
INSERT INTO stpNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Baꞌ jaiꞌ jaꞌp jaꞌk aiꞌ chaꞌm jup suulh ɨp na paiꞌx komaalhim jir dɨbɨɨr. Dhi dho gi guꞌ tɨi jotmodaꞌ bubua ji, nat guꞌ daaman jum yaas. ");
INSERT INTO stpNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Guꞌ ji na guꞌ maaꞌn nat jax mɨiꞌñ gu tanoolh nat bhaan miꞌ ji chotnorimɨ, nat guꞌ cham tuukab takta, dai nat ba gaa pɨx. ");
INSERT INTO stpNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Baꞌ jaiꞌ nat jaꞌp jaꞌk jup suulh na paiꞌx joiꞌñdhaꞌ na tuutkaꞌ gu tuꞌx bii uꞌuux jix joꞌiiꞌ, baꞌ puiꞌ tɨi bhaiꞌp ji bubua. Guꞌ ji na guꞌ jotmodaꞌ bhaiꞌp ji iꞌpu gu uꞌuux jix joꞌiiꞌ, maaꞌn nat jax bhaiꞌbich, jix uꞌuam miꞌ pup tuut gu tiriik, pu cham tuꞌ ka bhaaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Baꞌ gu jaiꞌ nat jaꞌp iam jup suulh na paiꞌx kɨɨꞌ gu dɨbɨɨr, dhiꞌ dho gi guꞌ joidham jix bhaiꞌm duu ji, alh jaꞌp saꞌsbar jum kaip. Jɨꞌmaꞌn moom kaip maaꞌn ooꞌm daman mambhɨɨx, jaiꞌ baik ooꞌm, jaiꞌ jix chamaam ooꞌm, miꞌ pɨx puiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Baꞌ miꞌ dhɨr na puiꞌ jɨꞌ xi chu ja aꞌgidhimɨk, jup ja tɨtda ɨp gio: ―Miꞌ pim puiꞌ ba jimiaꞌ jɨꞌk na pim jix maatɨt jiñ kɇɇ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Baꞌ jaꞌxpɨx na mɨt paiꞌ ba jii gu muiꞌ jaꞌtkam guiꞌ na miꞌ tu ja aꞌgidhimɨk gu Jesuus, ba tɨkkaꞌn am gu mambhɨɨx daman gook gu noonbiꞌñ gio gu jaiꞌ guiꞌ nam puiꞌp kaichuꞌ na sap ja aagiꞌñdhaꞌ na tuꞌ aagɨt jup kaiꞌch gu tuꞌ tiriik giigiꞌñdham. ");
INSERT INTO stpNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Baꞌp ja tɨtda gu Jesuus: ―Matgam aapiꞌm saalh ka maachim ji na jax jaꞌk jix bhaaiꞌ na jam aꞌm tɨ nɨiꞌñdhaꞌ gu Dios, na pim guꞌ bañ kaichuꞌ. Guꞌ baꞌ guiꞌ nam jɨꞌk cham jiñ kaim nañ bhaankam tu aꞌga guñ Gɨꞌkoraꞌ, puꞌñi pɨx jaꞌk jañ tu ja aꞌgiꞌñdhaꞌ bɨxchuꞌ bhaan ji chu uaꞌrgidhat yaꞌ kam dhi oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Na baꞌ sia kum tɨiñ ñɨiꞌñ nañ jax tu buadaꞌ, pu cham maatɨt ji ñɨiꞌñdhaꞌ am, piam noꞌm tɨiñ kɇɇ nañ jax tu ja aꞌgiꞌñdhaꞌ, pu cham maatɨt jiñ kɇɇkaꞌ am. Jaꞌpni dhuuji baꞌ matgilhiaꞌ nam pu cham aaꞌ nam miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ gu Dios, baꞌ dai nam pɨx am tɨꞌñchukaꞌ na ja tulhiiñchudaꞌ gu ja uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Miꞌ dhɨr baꞌp ja tɨtda ɨp gio: ―¿Cham aa pim maatɨt jiñ kɇɇ? ¿Jax japim baꞌ duuji jix maatɨt jup kaayaꞌ gu jaiꞌ nañ paiꞌ dhuuk giop tu ja aꞌgidhaꞌ gu jaꞌtkam bhaan ji chu uaꞌrgidhai gu tuꞌ yaꞌ kam dhi oiꞌñgaꞌn? ");
INSERT INTO stpNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jaꞌpniñ dho kaiꞌñkam jup kaiꞌch: Gu jaroiꞌ na tu ja aꞌgidhaꞌ gu ñioꞌkiꞌñ gu Dios gu jaꞌtkam, jaꞌp ji buusniaꞌ na jax noꞌt ba tu giiꞌ gu tiriik. ");
INSERT INTO stpNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Baꞌ jɨꞌmaꞌn noꞌ mɨt cham bɨɨx ja jujur kɨꞌn kai sia kum jɨꞌx tɨi kapup xi chɨꞌñchutgɨt palhɨɨp, na paiꞌ dhuuk miꞌ ɇɇji gu jaꞌook maakam xi jurtudaꞌ, miꞌ pu cham tuꞌ kap jum buixiꞌñdhaꞌ. Dhi jaꞌp ji buusniaꞌ na jax gu tiriik guiꞌ nat boi chaꞌm suulh. ");
INSERT INTO stpNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Guꞌ baꞌ guiꞌ nam jotmodaꞌ tɨ jɨɨꞌñdhaꞌ jix bhaiꞌm ɨlhdhai, dhiꞌ jaꞌp ji buusniaꞌ na jax guiꞌ nat miꞌ suulh na paiꞌx komaalhim jir dɨbɨɨr nar aiꞌ chaꞌm nat tɨi jotmodaꞌ bubua, dai nat cham tuukab takta. ");
INSERT INTO stpNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Baꞌ maaꞌn nam jax gio mummu puiꞌp suulhgiaꞌ noꞌ tuꞌ ba ja duiñchuꞌ, nam guꞌ palhɨɨp pɨx nɨɨrdaꞌ, na guꞌ miꞌ pɨx tu ja mamaiꞌchɨkdaꞌ noꞌm baabuiꞌ moo tuꞌ sɨlhkam tɨ jɨɨgiꞌñ buiñor guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Gio gu jaiꞌ guiꞌ nam puiꞌ tɨi joidham jup kaayaꞌ, dhiꞌ jaꞌp ji buusniaꞌ na jax guiꞌ nat miꞌ suulh na paiꞌx joiꞌñdhaꞌ na tuutkaꞌ gu tuꞌx bii uꞌux jix joꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Na guꞌ noꞌ mɨt tɨi ba tɨ jɨɨꞌñ, bhaiꞌ ji ja tukgidhaꞌ gu tuꞌ na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch. Tuꞌ nam pɨx bax joiꞌñdhaꞌ nam biaꞌkaꞌ jix dhaꞌram namkɨm, piam ku tuꞌ nam pɨx jax bax dhuñiik kaꞌ na tuꞌ cham jum aagidhaꞌ, nam jax dhui pɨx miꞌ bhaan jim iatat cham miꞌ puiꞌ ka tuiꞌñgɨdaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ. Baꞌ cham tuꞌ puiꞌ kaꞌ kiaꞌ, na guꞌ naiꞌ pɨx ji jugiidhaꞌ gux Uañ Iiꞌmdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Baꞌ guiꞌ nam bɨɨx ja jujur kɨꞌn tɨ jɨɨꞌñdhaꞌ, miꞌ puiꞌ ba jimiaꞌ am na jax jaꞌk jix aaꞌ guñ Gɨꞌkoraꞌ, cham jɨꞌxkat jaꞌk ka suulhgiaꞌ am, nam guꞌ gammɨjɨ buiñor bax biiñak kaꞌ. Dhiꞌ jaꞌp ji buusniaꞌ na guiꞌ nat miꞌ suulh na paiꞌ joidham jix kɨɨꞌ gu dɨbɨɨr, nat jum kaip maaꞌn ooꞌm daman mambhɨɨx, gio jaiꞌ jaꞌp na jax guiꞌ nat baik ooꞌm jum kaip, piam jaꞌp na jax guiꞌ nat jix chamaam ooꞌm jum kaip. ");
INSERT INTO stpNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jaꞌpni baꞌ moop ja tɨtda: ―¿Jaroo pim nɨiꞌñ nat xi mɨichdhak gu kañdhiir mɨjɨ jaꞌp paiꞌ xi kɨi tuꞌ kɨꞌn xi chaaꞌbidhak noꞌx chukgam? ¿Piam aa na cham? Jax dhui na guꞌ cham tu maax kaꞌ noꞌ mɨjɨ paiꞌ taaꞌbidhix, dai noꞌ tɇꞌkob kɨɨk tuꞌ kaꞌm na baꞌx bhaiꞌx chu maax kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Baꞌ xib puꞌñi pɨx ɨlhiiꞌñ am gu muiꞌ jaꞌtkam, nam guꞌ cham maatɨt jiñ kɇɇ nañ jax kaiꞌñkam jup ja tɨtda. Jaꞌp jum aaꞌ am nañ iam pɨx jix ɨxchuixim tu aꞌga, guꞌ tɨi cham ji. Ku baꞌ guꞌ kam aayaꞌ ji nam paiꞌ dhuuk bɨɨx ka machiaꞌ na jax jir jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Miꞌ pim puiꞌ ba jimiaꞌ jɨꞌk na pim jix maatɨt jiñ kɇɇ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Baꞌ miꞌ dhɨr nat puiꞌ jɨꞌ xi chɨꞌɨɨk, jup ja tɨtda ɨp gio: ―Jix bhaiꞌ pim moo xim gaꞌngadaꞌ na pim jax jaꞌk duuji jix maatɨt kaayaꞌ noꞌñ puꞌñi paiꞌ tu aꞌga jaꞌp na xib. Na guꞌ noꞌ pim moo soiꞌm ɨlhdhat jix maachik, dɨɨlh pɨx bhaiꞌ ji machiaꞌ pim, na guꞌ xi jam joiꞌmdai ba jam mattudaꞌ gu Dios na jax jir jum duukam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Guꞌ baꞌ guiꞌ nam jɨꞌk cham soiꞌm ɨlhiiꞌñdhaꞌ, noꞌm cham maachik, miꞌ pɨx ganaiꞌ jix oodaꞌ am, panaas kum jaꞌp jix xijaim ɨlhiiꞌñdhaꞌ, nam guꞌ cham biiñak kaꞌ buiñor guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jaꞌpni baꞌ moop ja tɨtda miꞌ na paiꞌ tu ja aꞌgidhimɨk gu Jesuus gu jaꞌtkam: ―Iam pɨx puiꞌ ji buusan na paiꞌ dhuuk ja aꞌm ba tɨ nɨiꞌñdhaꞌ gu Dios guiꞌ nam jɨꞌk buiñor bax biiñak kaꞌ, jaꞌpni na jax gu jaroiꞌ noꞌt ba tɨ ɨi gu ɨxchukgaꞌn, noꞌ miꞌ paiꞌ biaꞌkat. ");
INSERT INTO stpNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Na miꞌ pɨx xi ɨsai, miꞌ dhɨr dai na ka nɨɨrdaꞌ jɨꞌk tanoolh, dɨɨlh bha bubuakiaꞌ, tukaaꞌñ chaꞌm piam tataab, paiꞌ na pɨx dhuuk cham daaxix kam. Miꞌ pɨx ba tuutkaꞌ na paiꞌ dhuuk ba tɨgiaꞌ gu ɨsdam, pu cham mat kaꞌ na jax jaꞌk bhaiꞌ jim duñiaꞌ na jax kiaꞌpɨx bhaiꞌ ji bubuakiaꞌ, piam na jax buaꞌt gɨꞌlhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na guꞌ miꞌ noꞌt ba bubua dɨbɨɨr taꞌm dɨr, miꞌ dhɨr dai na bhaiꞌ ji saꞌsarkaꞌ gu jaagaꞌn, gio na ba muraaꞌntaꞌ, gio na ba kaichaꞌ, suuduyaꞌ bhaiꞌ na jɨꞌx jir muraaꞌngaꞌn kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Baꞌ na paiꞌ bax kabaak kaꞌ, dai na jiikai xi kaipgai baꞌ ulhñaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Baꞌ miꞌ dhɨr gio muiꞌp ji chu ja aꞌgi gu Jesuus gu jaꞌtkam, jup ja tɨtda: ―¿Tuꞌñ gɨt bhaan ji uaꞌrgidhai jam aaꞌñdhaꞌ na jax jaꞌk duuji ja aꞌm tɨ nɨiꞌñdhaꞌ gu Dios guiꞌ nam buiñor bax biiñak kaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jaꞌpni dho ji buusan na jax gu mostaasa kai nar ɨlhiꞌch alh, pu ni jax chuꞌm kaichuk kur jaꞌxbuiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ku baꞌ guꞌ noꞌ ñich mi jaꞌp xi ɨi, giilhim gɇꞌp jum duñiaꞌ ji na paiꞌ dhuuk bhaiꞌ ji buusniaꞌ, jix ioꞌm tɇꞌkob tu jimmɨ, cham jax chuꞌm jaꞌxbuiꞌ tu jimmɨ gu jaiꞌ na puiꞌp jir jum ɨsdam. Joidham xi boorak jup jum bua, gu uꞌjiꞌ ja koꞌraar nam bha tu kakos kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jaꞌpni jaꞌk baꞌ tu ja aꞌgidhimɨk gu Jesuus gu muiꞌ jaꞌtkam bɨxchuꞌ bhaan ji chu uaꞌrgidhimɨk na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch. Nam paiꞌ cham ka kaim nat baꞌ cham ka tu aꞌga. ");
INSERT INTO stpNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pu cham maaꞌnnim tu ja aꞌgi nat cham tuꞌ bhaan ji chu uaꞌrgidhak, guꞌ jaꞌpji pu bɨɨx nat jɨꞌx juugɨt tu aꞌga na bɨxchuꞌ bhaan ji chu uaꞌrgidhimɨk. Ku baꞌ guꞌx bhaiꞌ ja aagiꞌñ ji dai guiꞌ nam jɨꞌk kaichuꞌ na jax jir jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Baꞌ moo janoꞌ jurnɨk nat paiꞌ ba ji dhɨdɨmpu, jup ja tɨtda gu Jesuus gu noonbiꞌñ: ―Maik gor jach jimiaꞌ bhammɨ baasɨꞌn dɨr jaꞌk dhi gɇꞌ suudaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Baꞌ gamaiꞌ ji jii mɨt bɨɨx suudaiꞌ dhaam pu guiꞌ gu kanuub taꞌm na bhaiꞌ dhɨr bhaan daakat bha tu ja aꞌgidhimɨk gu Jesuus, dai na mɨt jax xi ja tabuimgidhak gu muiꞌ jaꞌtkam. Baꞌ gatuuk dɨr muiꞌp ji jii mɨt gu jaiꞌ guiꞌ nam puiꞌp kaichuꞌ puiꞌ kaknub taꞌm ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Baꞌ na mɨt nammɨ ba ji bhɨi ɨrban, giilhim jix ioꞌm bhaiꞌ ji jɨb, gio nat bhaiꞌ ji guꞌngukɨ gu suudaiꞌ, pɨx bhaiꞌ jim tuꞌaim kanuub taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Baꞌ gu Jesuus miꞌ dhɨr jaꞌp kuuꞌ dɨr gu kanuub kooxchuꞌ jim moꞌxdhat. Baꞌ ma ñiñiich jamɨt gu noonbiꞌñ, jup tɨtda am: ―Aapiꞌñ jaduuñ, ¡bi ñiñia! ¡Tɨɨꞌ na jax jum bua gu suudaiꞌ! ¿Chaꞌch baꞌ yaꞌ bhaiꞌkuꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Baꞌ gu Jesuus bamgɨk ba ñiok gu jɨbɨɨlh, jup tɨtda: ―¡Chaꞌp bha jaꞌk buam jum buadaꞌ! Gio baꞌ gu suudaiꞌ jup tɨtda ɨp: ―¡Chaꞌp joiñat suuꞌnkaꞌ! Baꞌ jotmodaꞌ naiꞌ ampɨx ji chu juu, pu cham paiꞌ ka jɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Baꞌ miꞌ dhɨr jup ja tɨtda gu noonbiꞌñ: ―¿Jax ku pim baꞌ jaꞌp xiꞌ pɨk jup jix chotdon? ¿Moo chakui bɨɨx jam jujur kɨꞌn jix biiñak japim aa aañ jiñ bui? ");
INSERT INTO stpNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Baꞌ miꞌ puiꞌ pup tuiꞌdhiꞌ am, jaꞌx moo xi mɨɨkim paꞌ, na guꞌ cham bhaiꞌ nam jax tɨꞌyaꞌ. Dai nam jup kaiꞌchim jix dhuꞌnpiꞌñ kɨꞌn: ―¡Jaꞌp moor gɇꞌkam ji bak jia dhich jaduuñ na baꞌ gam jɨbɨɨlh gio suudaiꞌ jix jɨɨgiꞌñ! ");
INSERT INTO stpNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Baꞌ bhammɨ dɨr ba ai mɨt na paiꞌ giop bar juꞌñdharan, Gadaara tɨ tɨɨgim. ");
INSERT INTO stpNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Baꞌ nat jax muiꞌ ji chɨm gu Jesuus bhaiꞌ dhɨr kanuub taꞌm, ba tɨɨ na mu jaꞌp ba jim maaꞌn gu maaꞌnkam na cham kɨɨꞌ tu iiꞌmdaꞌ, ampɨx jix ñaanbiꞌ kaꞌ. Mu dɨr jaꞌk jim nam paiꞌm yassap gu koiꞌñgaꞌn, ");
INSERT INTO stpNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","na guꞌ puiꞌ tɨ ɨlhiiꞌñdhaꞌ nar kiaꞌmiꞌñ paiꞌ noꞌm jum yassap gu koiꞌñgaꞌn. Pu cham bhaaiꞌn kaꞌ ɨp moo nam jax dhui buuplhiaꞌ sia tuꞌ baiñum tɨrbiñ kɨꞌn, na guꞌ giilhim jix ooꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Paiꞌjɨ tɨi ma buuplhiaꞌ am baiñum tɨrbiñ kɨꞌn sia tootnaran, guꞌ ji na guꞌ maaꞌn na jax ɨꞌkɨdaꞌ, baꞌ puiꞌ cham ka juandaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Baꞌ nabap tanoolh gio nabap tukaaꞌ mummu jaꞌp oirɨt jiiñakdaꞌ uꞌxchɨr gio nam paiꞌ jax jum yassap gu koiꞌñgaꞌn, gio na dɨɨlh jum koꞌktolhdhidhaꞌ joodai kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Baꞌ nat ba tɨɨ na mu jaꞌp oirɨ gu Jesuus, jotmodaꞌ mu mɨraak miꞌ oꞌlhiaꞌn kɨꞌn ji kɨkbu bɨɨpɨꞌ dɨr, ");
INSERT INTO stpNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","jup tɨtda gɇꞌ kɨꞌn: ―¿Jax japich bhaiꞌ bañ dhoodam Jesuus nap jir Maraaꞌn gu Dios gux ioꞌm Gɇꞌkam? Chaꞌp tuꞌ kɨꞌn jiñ juandaꞌ. Ka tuñ uañiꞌñkaꞌ ap gu xib. ");
INSERT INTO stpNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Guꞌ nax chooꞌnnɨt na baꞌ puiꞌ kaiꞌch, nat guꞌ maaꞌnnim pu ba ñiok gu Jesuus, jup tɨtda: ―Mu buusaiñ cham kɨɨꞌ iiꞌmdaꞌ bhaiꞌ dhɨr bhaan dhiñ jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Baꞌ ba tɨkkaꞌn gu Jesuus gux ñaanbigɨm, jup tɨtda: ―¿Jax jap tɨɨꞌ? ―Lejion jañ dho tɨɨꞌ ―jup kaiꞌch gux ñaanbigɨm―, nach guꞌr muiꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Baꞌ soiꞌm duuk gio bhaiꞌp ji ñio mɨt gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ bhaiꞌ dhɨr bhaan gux ñaanbigɨm nam jup kaiꞌch na sap chakui mu jaꞌk ja jootosdaꞌ mu paiꞌ nam giilhim jum tulhiiñaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Baꞌ ampɨk miaꞌn oipot jup ka tu kob am muiꞌ gu tatooxkolh bha jaꞌp juurap oidhaꞌ taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Baꞌp tɨtda am gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ gu Jesuus: ―Bhammɨni guꞌñi tatooxkolh bhaan jap ka xich jootsaꞌ nach ja aꞌm ka xi baapkipuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Baꞌ siamri puiꞌ ma ja tɨɨꞌn gu Jesuus nax bhaaiꞌ nam bhammɨ jaꞌk ka xi baapkipuꞌ. Baꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ jotmodaꞌ bubuakɨk bhaiꞌ dhɨr bhaan gu maaꞌnkam bhammɨ jaꞌk pu baapkim jamɨt. Baꞌ bhaiꞌ dhɨr ji boop jamɨt gu tatooxkolh na mɨt jax bha baap ja aꞌm, bha jaꞌp bhɨi mɨt gu bɨɨx aꞌnsap, boopok mɨjɨmmɨ pu baap jamɨt na paiꞌ gɇꞌ suuꞌnkaꞌ gu suudaiꞌ, miꞌ mɨt pu koi dappaam bhaiꞌkuk. Gook mambhɨɨx jix chaꞌtmam ooꞌm kat am gu tatooxkolh. ");
INSERT INTO stpNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Baꞌ guiꞌ nam ka ja bipiaꞌdat gu tatooxkolh, totdonɨk pu jiboiꞌññor jamɨt na mɨt ja aaꞌñdham gu jaꞌtkam gu mummu gɇꞌ kiicham oiꞌñkam, gio guiꞌ nam mu jaꞌp oiꞌdhaꞌ jɨꞌdɨlh mɨꞌmɨk. Baꞌ bhaiꞌ ma jii mɨt ɨp na mɨt bha tɨ tɨɨgim noꞌ baabuiꞌ moor sɨlhkam na jax tum kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Baꞌ na mɨt miꞌ ba ai na paiꞌp tuꞌiiꞌ gu Jesuus, miꞌ pɨx ji chɨɨ mɨt nax kɨɨꞌ juraaꞌn biaꞌkam mi jaꞌp daa guiꞌ nam muiꞌ bhaan kap tuiꞌñgɨt gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ, bam tɨꞌiiꞌñ, na guꞌ gammɨjɨ jix dhaapkat mu jaꞌp ka oirɨdaꞌ. Baꞌ giilhim bhaiꞌ ji chootoꞌn jamɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Baꞌ gu jaiꞌ guiꞌ nam jɨꞌk nɨiꞌñ nat jax jaꞌk duaꞌñ gu maaꞌnkam guiꞌ na kax ñaanbiꞌ kat, gio na mɨt jax dhuuk koi gu muiꞌ gu tatooxkolh, miꞌ dhɨr jup ba ja aagiꞌñdhaꞌ am guiꞌ nam jɨꞌk kiaꞌpɨx miꞌ aajidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Miꞌ dhɨr baꞌ bɨɨx na jɨꞌk jaꞌtkam nam miꞌp tuꞌiiꞌ soiꞌm duuk jup tɨtda am gu Jesuus na ba jimiaꞌ miꞌ dhɨr. ");
INSERT INTO stpNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Baꞌ nat jax bha tɨs kanuub taꞌm ba jii ɨp. Baꞌ tɨix oidhamɨt guiꞌ nat duaꞌñ na kax ñaanbiꞌ kat, ");
INSERT INTO stpNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","guꞌ ji na guꞌ cham aaꞌ gu Jesuus, dai nat jup xi chɨɨdak: ―Jaꞌp ji nap ba jimiaꞌñ jaduuñ jum kiꞌaam ja bui gum jaaduñ. Ja aagiꞌñdhaꞌ ap nat maadɨt jix joiꞌmdak jum tɨɨgɨk jum duaꞌñ guiꞌ na bhaankam ya oirɨ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Baꞌ ma jii ɨp gu maaꞌnkam nat tu aagam nat jax dhuuk duaꞌñ gu Jesuus, mu jaꞌp ji bhɨi muiꞌ kap na Dekaapolis bhaan bipioꞌ. Baꞌ bɨɨx nat jɨꞌk kap ai, miꞌ puiꞌ pup tuiꞌkaꞌ am na ba ja aagiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Baꞌ nat gio bhammɨ dɨr jup ba tɨs gu Jesuus baasɨꞌn dɨr jaꞌk miꞌ na paiꞌ gɇꞌ suuꞌnkaꞌ gu suudaiꞌ, giilhim muiꞌ miꞌ mam jumaap jamɨt ɨp gio gu jaꞌtkam, baꞌ miꞌ pup oirɨ juꞌñdharan. ");
INSERT INTO stpNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Baꞌ miꞌ ba ai maaꞌn gu maaꞌnkam Jairo tɨɨgim guiꞌ na miꞌr gɇꞌkam kaꞌ maaꞌn kap nam paiꞌ tu daandaꞌ gu Israel kam jaꞌtkam. Baꞌ miꞌ oꞌlhiaꞌn kɨꞌn ji kɨkbu bɨɨpɨꞌ dɨr gu Jesuus, ");
INSERT INTO stpNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","baꞌp tɨtda soiꞌm ɨlhdhat: ―Aañ jaꞌp tɨi kaiꞌchɨt jiñ jaduuñ nap iam mu jimiaꞌ gɨt jiñ kiꞌaam nap duaꞌñdharaꞌ guñ maraax, umri moo ba muukim. Aañ jix maat na dai noꞌ pich xi dhaa, pu dodhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Baꞌ gu Jesuus cham jax ji chɨꞌɨɨk muiꞌp ma oi. Baꞌ muiꞌ jaꞌtkam pɨx chuꞌp tuiꞌdhiꞌ am, pɨx am kikiꞌspaim am. ");
INSERT INTO stpNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Baꞌ maaꞌn muiꞌp jimchuꞌ gu ubii na mambhɨɨx daman gook oidhaꞌ bax kaꞌook. Nat paiꞌ dhuuk ai gu masaaꞌn, puiꞌ jaꞌk pu bii, cham ka duduardaꞌ, gammɨjɨ pɨx ba mɨrdaꞌ gu ɨꞌraꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Muiꞌ koꞌkdaiꞌ mamtɨm tɨi ba ja umuaꞌ, puiꞌ na jax ba tuꞌiiꞌ. Bɨɨx tɨi ba tu gaꞌra gu tuꞌ na biaꞌkat na tɨix dhuadhim kaꞌ, guꞌ ji na guꞌ jix ioꞌm bhaiꞌ ji bhɨbhɨɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Guꞌ ji na guꞌ puiꞌ ba tɇ kɇɇ gu ubii na tu duduaꞌñdhim gu Jesuus, baꞌ xiꞌ muiꞌ xi jimchuꞌ mɨjɨ jaꞌtkam tɨr na miaꞌn jix bhɨim na paiꞌ jax jimchuꞌ. Baꞌ miaꞌn bhɨɨk bhaiꞌ xi dhaa gu jannulhiꞌñ, ");
INSERT INTO stpNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","na guꞌ puiꞌ pɨx kaiꞌñkam baꞌ xiꞌ muiꞌ xi jii nap jum aaꞌ: “Dai pɨx noꞌ ñich ba daa gu jannulhiꞌñ gu Jesuus, pu dodhiaꞌ iñ.” ");
INSERT INTO stpNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Baꞌ jotmodaꞌ pu kɨkbu gu ɨꞌraꞌn, gio nat jix bhaiꞌ bhaiꞌ ji chu tatdat na kax chu koꞌk kat. ");
INSERT INTO stpNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Guꞌ ji na guꞌx bhaiꞌx maat gu Jesuus nat maadɨt ba duaꞌñ gu jaroiꞌ nat jax bha dhaa jannulhiran, na guꞌx ioꞌm jir gɇꞌkam. Baꞌ jaꞌk gɨɨsɨk jup ja tɨtda gu jaꞌtkam: ―¿Jaroo bhañ dhaa jiñ jannulh am? ");
INSERT INTO stpNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Baꞌp tɨtda am gu noonbiꞌñ: ―¡Jaroo bhañ dhaa jiñ jannulh am sap! ¿Jax jap gi dhuip machiaꞌ? Na guꞌ muiꞌ jaꞌtkam ya tum jiimchuꞌ, pɨx am jum kikiꞌspaim am. ");
INSERT INTO stpNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Guꞌ ji na guꞌ gu Jesuus jix bhaiꞌ gan xi ja nɨiꞌñ, panaas ku cham xi maat nat jaroiꞌ bha dhaa. ");
INSERT INTO stpNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Baꞌ gu ubii jix chooꞌnnɨt giꞌbukidhat miꞌ oꞌlhiaꞌn kɨꞌn ji kɨkbu bɨɨpɨꞌ dɨr gu Jesuus, na guꞌx maat na dhiꞌ aagɨt jup kaiꞌch. Baꞌ bɨɨx ba aagiꞌñ nat jax kaiꞌñkam bha dhaa jannulhiran. ");
INSERT INTO stpNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Baꞌp tɨtda gu Jesuus: ―Pu ba dua pich ji matgam jiñ jaduuñ, nap guꞌ aañ jiñ bui bax biiñak. Ba jimiaꞌ ap, chaꞌp jax kam aaꞌndaꞌ. Cham tuꞌ jaꞌk ka gɨxiaꞌ gu koꞌkdaiꞌ nam ɇɇkat. ");
INSERT INTO stpNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Baꞌ na miꞌ ka tu aꞌgichuꞌ gu Jesuus, miꞌ ba ji bubua mɨt jɨꞌkchi gu jaꞌtkam mummu kam nar paiꞌ kam gu Jairo, baꞌp tɨtda am: ―Ba muu ji matgam gum mar. ¿Jax gip kax bhaaiꞌ sia kup muiꞌ tɨi ba baiꞌñchuꞌ dhi gɇꞌkam? ");
INSERT INTO stpNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Guꞌ ji na guꞌ gu Jesuus ja kɇɇ nam puiꞌ jɨꞌ tɨtda gu Jairo, baꞌp tɨtda: ―Aap moo cham jax jum aaꞌndaꞌ. Dɨɨlh jup kaiꞌch am ji matgam. Aañ jiñ bui pɨx jap jix biiñak kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Baꞌ miꞌ cham ka aaꞌ gu Jesuus na ja bɨɨm ka jimdaꞌ gu muiꞌ jaꞌtkam. Dai gu Peegro, gio gu Jakoobo, gio baꞌ gu Juan sɨpdhiꞌñ gu Jakoobo, xi ja baidhak mu jaꞌk ji dhuu na paiꞌ kio gu Jairo. ");
INSERT INTO stpNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Baꞌ na mɨt mummu ba ai, giilhim tum kaiꞌch, gɇꞌ kɨꞌn tum suan, gio nam giilhim jix buam jum aaꞌ nat ba muu gu tɨɨyax. ");
INSERT INTO stpNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Baꞌ gu Jesuus mu baakɨk baꞌk chɨr jup ja tɨtda: ―¿Tuꞌ ma jam duu jiñ jaaduñ na pim baꞌ moo jaꞌp giilhim kaiꞌch? Gɇꞌgɇr suan japim. Jax dhui na cham tuꞌ muukix gu tɨɨyax, matgam miꞌ pɨx ji na koos. ");
INSERT INTO stpNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Baꞌ dai na mɨt xi aꞌsɨk nat puiꞌ jɨꞌ xi ja tɨɨꞌn, nam guꞌ cham jɨɨgiꞌñ, jaꞌp jum aaꞌ am na pɨx jaꞌp kaiꞌch. Baꞌp ja tɨtda nam sap ka xi bubuakiaꞌ miꞌ dhɨr baꞌk chɨr. Baꞌ guiꞌ pɨx jup ji bubua mɨt, dai baꞌ gu taataꞌn gio gu dɨꞌɨɨꞌn gu tɨɨyax miꞌ ji bii mɨt, gio baꞌ gu noonbiꞌñ guiꞌ na pu ja bɨɨm jimchuꞌ. Baꞌ muiꞌ ji ai mɨt miꞌ na paiꞌ kaat gu mukdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Baꞌ gu Jesuus nobiꞌran xi dhaagɨk jup tɨtda: ―Talita kumi ―na jaꞌp kaiꞌñkam jup jum kaiꞌch: Xi bamiiꞌ tɨɨyax. ");
INSERT INTO stpNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Baꞌ nat jax pu tɨɨꞌn, bhaiꞌ ji bam gu tɨɨyax, mi jaꞌp pɨx gan ba oirɨ na guꞌ bar gɇꞌ, mambhɨɨx daman gook oidhaꞌ biaꞌkam. Baꞌ miꞌ puiꞌ pup tum tuꞌiiꞌ na mɨt puiꞌ tɨ tɨɨ, am cham bhaaiꞌ nam jax jum duñiaꞌ, nam guꞌx ioꞌm jix bhaiꞌm taat. ");
INSERT INTO stpNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Baꞌ xi ja sooꞌmchulhdhak gu Jesuus nam sap cham jaroiꞌ aagiꞌñdhaꞌ nat jax dhuuk duaꞌñ gu tɨɨyax, dai nat xi chianɨk gu dɨɨdɨꞌn na ba tu makiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Baꞌ giop ba jii gu Jesuus ja bɨɨm gu noonbiꞌñ mummu jaꞌk Nasareet nar paiꞌ kam. ");
INSERT INTO stpNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Baꞌ nat bam ai na paiꞌ dhuuk cham tum juandaꞌ, muiꞌ ma jii maaꞌn kap mu nam paiꞌ tu daandaꞌ gu Israel kam jaꞌtkam. Baꞌ miꞌ ɇɇk bhaiꞌ ji chu ja aꞌgi guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ. Bɨɨx miꞌ puiꞌ pup tuꞌiiꞌ am na mɨt kai, na guꞌ giilhim jix bhaiꞌ xi bua na xi chu aꞌga. Baꞌp kaiꞌch am dɨɨlh: ―¿Paa baꞌ ji chum mamtuxdhak puiꞌ pɨk joidham jix bhaiꞌ xi bua? ¿Jax moo duukat jix aix na jax tɨꞌyaꞌ? Tɨɨꞌ na guꞌ bɨxchuꞌ pɨx nar jix bhaiꞌm duukam jup tu buim. ");
INSERT INTO stpNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Cham aar diꞌ guiꞌ na uꞌuux ka tu jibdaꞌ na bɨxchuꞌ kap tu buadaꞌ, na Mariiya jir dɨꞌɨɨꞌn, nam jir jum sɨspidhim gu Jakoobo gio gu Josee gio gu Juudas gio baꞌ gu Simoon? Gio gu uꞌuub sɨspidhiꞌñ, ¿cham aa pɨn yaꞌ tu bɨpnaꞌ am? Miꞌ puiꞌ xi kaiꞌchimɨk gan ji ɨɨ mɨt, nam guꞌ jaꞌppɨx maaꞌnkam ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Guꞌ ji na guꞌp ja tɨtda gu Jesuus: ―Cham dho jɨɨgiꞌñdhaꞌ am gu miaꞌn jum oiꞌdhagɨm gu jaroiꞌ noꞌ tɨi xi chu ja aꞌgiꞌñ bhaankam gu ñioꞌkiꞌñ gu Dios, guꞌ chi baꞌ pɨk noꞌm jir jum jajaꞌnnim. Dai noꞌm jir mɨk kam nam baꞌ siamri jɨɨgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Baꞌ miꞌ xi ja duduaꞌñdhak jɨꞌkchi gux kakoꞌkkam, dai na bhaiꞌ pɨx xi ja daꞌngɨ, pu duduar am. Cham paiꞌ moo maaꞌn jup duu gu tuꞌ nax ioꞌm jix bhaiꞌr jum duukam, na guꞌ ampɨx jix chum bhaak. ");
INSERT INTO stpNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Gampaiꞌ ji dhuu gu Jesuus, na guꞌ ni jɨꞌx kum buiñor jix biiñak gu miꞌ oiꞌñkam. Puiꞌ ma jii miꞌ dhɨr mummu jaꞌp jaiꞌ kap, na jɨꞌx jir miaꞌn paꞌ, na paiꞌ jax jir kikcham, na tu ja aꞌgidhim gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Baꞌ maaꞌnnim maaꞌn kap maap ja jumpadak gu mambhɨɨx daman gook gu noonbiꞌñ gu Jesuus, naiꞌ ja joot goꞌgok nam jaiꞌ naiꞌp xi chu ja aꞌgiꞌñpuꞌ gu jaꞌtkam. Jup ja tɨtda na sap ja palhbuidhaꞌ guch Gɨꞌkoraꞌ, na baꞌx bhaaiꞌn kaꞌ nam bhaankamuꞌn maiꞌ ja jootsaidhaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gu jaꞌtkam guiꞌ nam jɨꞌk jix ñanaanbiꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gio baꞌ nap ja tɨtda na cham bhaaiꞌ nam kusbiodaꞌ tuꞌ asaak, nich chuꞌ koiꞌ kum uaꞌdaꞌ, nich chuꞌ tuumiñ, dai uux tapoorak nam kɨꞌn oxiakkidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Gio gu ja sussak daipuꞌ nam jax aaꞌntuꞌndaꞌ, gio gu ja jajannulh pu daipuꞌ nam jax tɨ tɨichgɨdaꞌ, cham bhaaiꞌ sap nam jaiꞌp tu uaꞌdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jaꞌpni baꞌ moop ja tɨtda: ―Paiꞌ kikcham na pim aayaꞌ, noꞌ ampɨk maadɨt jam tɨbiapputuꞌn gu jaroiꞌ, miꞌ pim xi juruuñdhai, na pim paiꞌ tɨɨmuꞌ tu ja aꞌgidhimɨi gu miꞌ oiꞌñkam na pim baꞌ giop ba jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Piam ku pimɨt guꞌ miꞌ pɨk ai nam paiꞌ cham jam kɨɨgalhiꞌñdhaꞌ, nam cham jɨꞌx jam kaim kaꞌ, pu jimiaꞌ pim maakam jaꞌk, dai na pim xi xiixkai gu dɨbɨɨr mi jam tooton am na pim jax gamaiꞌ ji jimiaꞌ, na baꞌ bhaan jix maatɨꞌ kaꞌ na mɨt cham jam kɨɨgalh. Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ jam aagiꞌñdhaꞌ, chaꞌpim jax jum aaꞌndaꞌ sia kum jaiꞌ cham jam kaim. Na guꞌ janoꞌ na paiꞌ dhuuk jum aayaꞌ na tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn nam baꞌ puiꞌ tɨi bam aaꞌndaꞌ, nam guꞌ giilhim jum tulhiiñaꞌ jix ioꞌm, cham tuꞌ puiꞌ na gu Sodooma kam gio gu Gomorra kam. ");
INSERT INTO stpNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Baꞌ guiꞌ ma jii mɨt ɨp naiꞌ jaꞌp na jax jir kikcham na mɨt tu ja aꞌgidham gu jaꞌtkam, jup ja tɨtdaim am nam sap miꞌ puiꞌ ba jimiaꞌ na jax jix aaꞌ guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Gio baꞌ na mɨt muiꞌ maiꞌ ja joot gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gux ñanaanbigɨm, gam na mɨt muiꞌ ja duduaꞌñ gux kakoꞌkkam, dai nam bhaiꞌ pɨx xi ja julhiiꞌñdhim gu tuꞌ joidham jix xuuꞌngiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Baꞌ gu Eroodis guiꞌ nar gɇꞌkam kaꞌ puiꞌ ba tɨ kai na mu paiꞌ oirɨt jix bhaiꞌ tu bua gu Jesuus, nam guꞌ pɨx jaꞌx puiꞌ tu aꞌga gu jaꞌtkam. Baꞌp kaiꞌchdhaꞌ: ―Dhiꞌ bak gu Juan jaꞌtkam bopkondam gio duadɨk jup ba buus mu dɨr koiꞌñgaꞌn tɨr, puiꞌ ku baꞌx ioꞌm jix bhaiꞌ ba tu buim gu tuꞌ nax bhaiꞌr jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jaiꞌp kaiꞌchdhaꞌ am: ―Jaꞌpji Eliiyas ji chi, guiꞌ nat saak maaxik tɨs jix dhaam jaꞌk. Jaiꞌ maakam jup kaiꞌchdhaꞌ am: ―Jaꞌpji chi maadɨt pɨx jir diꞌ guiꞌ nam bɨjɨk ya jaꞌp bhaankam tu aꞌgimɨk gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Baꞌp kaiꞌch gu Eroodis na puiꞌ ba tɇ kɇɇ nam puiꞌ jɨꞌ kaiꞌchdhaꞌ: ―Jaꞌpji Juan ji nat gio duadɨk jup ba buus mu dɨr koiꞌñgaꞌn tɨr, guiꞌ na ñich tu chia na mɨt ɨɨ gu maꞌooꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Baꞌ giilhim bax choodon puiꞌ xi kaiꞌchɨt, nat guꞌ dhiꞌ tuꞌm daꞌp duu na mɨt paiꞌ dhuuk daa gu Juan janoꞌ nat baiñum tɨrbiñ kɨꞌn buuprak tu chia nam mu kuuppuꞌ nam paiꞌm kukpa gu jaꞌtkam, na mɨt gook dɨt maap jim daagɨk gu bɨngaꞌn Erodiiyas tɨɨgim, guiꞌ na bɨɨpɨꞌ dɨr kar bɨngaꞌn kat gu Piliip nam jir jum sɨspidhim gu Eroodis, guꞌ ji nat guꞌ bhaiꞌ ji ɨɨx, sia kum tɨir jum sɨspidhim. ");
INSERT INTO stpNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Baꞌp tɨtdadaꞌ gu Juan: ―Cham jir am nap bɨɨmaꞌn tu kiokaꞌ dhi ubii jiñ jaduuñ, na guꞌ moo miaꞌn jir jum jaduuñ gaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Baꞌ giilhim bhaiꞌ ji bhaam gu Herodiiyas buiñor gu Juan nat puiꞌ tɨ kai na sap puiꞌ jɨꞌ kaiꞌchdhaꞌ, tɨix chu chiañim kaꞌ nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Guꞌ ji na guꞌ sooꞌmcholhiꞌñkaꞌ gu Eroodis, na guꞌx ɨɨbhiꞌñdhaꞌ, na guꞌx mat kaꞌ na bhaan tɨ nɨiꞌñdhaꞌ guch Gɨꞌkoraꞌ gu Juan, na guꞌ gammɨjɨ tuꞌ kaꞌm tɨ nɨiꞌñdhaꞌ, gio na guꞌx ioꞌm jix bhaiꞌ xi buadaꞌ na xi chu aꞌgiꞌñdhaꞌ. Baꞌ joidham kɇɇkɇꞌ gu Eroodis, sia ku tɨi cham pɨk maatɨt kɇɇkaꞌ na jax kaiꞌñkam jup tɨtdadaꞌ, puiꞌ ku baꞌ cham aaꞌ nam muꞌaaꞌ, puiꞌ pɨx tɨi ka xi kuu. ");
INSERT INTO stpNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Guꞌ ji na guꞌ moo janoꞌ pɨk bhaiꞌp jir koiꞌcham kat nat bhaiꞌ tu chia gu Eroodis nat tum bhaiꞌñ gu koiꞌ nat sap jum ai gu oidhargaꞌn. Baꞌ ma tu juu ja bɨɨm gu oꞌrosiiris tugiꞌñ, gio gu sandaaruiꞌx chugiꞌñ, gio jaiꞌ gu Galilea kam guiꞌ nam puiꞌp jir gɇꞌgɇrkam jum aaꞌndam kaꞌ. Baꞌx bhaiꞌ pɨx jum ɨlh gu Herodiiyas, na guꞌ bax maat nat noonbiran ba gɨi gu kɨꞌdargaꞌn. Baꞌ dai na mɨt xi chu aꞌgak gook dɨt gu tɨyaa maraaꞌn nam jax jaꞌk duuji jix bhaiꞌ bhɨɨyaꞌ gu Eroodis na baꞌ miꞌ bhaan jim tukgidhai aagaꞌ na tu chiñiaꞌ nam boi bhɨichdhaꞌ gu Juan. ");
INSERT INTO stpNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Baꞌ miꞌ dhɨr jaꞌxpɨx nam miꞌ ka tu kuaꞌ, miꞌ ba baa gu tɨyaa, baꞌ mi jaꞌp ma chɨ nɨi ja nɨiꞌñchudat gu jaꞌtkam. Alh iam koꞌraaru gu Eroodis puiꞌ nat jax jaꞌk tɨ nɨi, gio guiꞌ nam miꞌp tuꞌiiꞌ bɨɨmaꞌn ba puiꞌ ɨp. Baꞌp tɨtda gu Eroodis: ―¿Tuꞌm aꞌm jum aaꞌ? Yaꞌñ dhop tuꞌiiꞌ noꞌp tuꞌx aaꞌ nañ jum makiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jix bhaiꞌ moo xi chɨtda na baꞌ jɨɨgiꞌñdhaꞌ, jup tɨtda: ―Jaꞌp ji moox gɨꞌm jañ yaꞌ pum tɨtda. Jum makiaꞌ iñ dho nap tuꞌ ɨlhiiꞌñdhaꞌ, sia dɨbɨɨr jañ dhom makiaꞌ ɨrban juugɨt guiꞌ na jɨꞌx bhaan bipioꞌ yaꞌ nach paiꞌp tuꞌiiꞌ. Cham jax bua, nañ guꞌ bɨɨx ja daaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Baꞌ xi mɨɨ gu tɨyaa nat tɨkkam gu dɨꞌɨɨꞌn, jup tɨtda mu ɇɇk: ―Jup jiñ chɨtda gu yaꞌ kiokam na sap jiñ makiaꞌ nañ tuꞌx aaꞌndaꞌ. ¿Tuꞌñ bha tañiaꞌ? Baꞌp tɨtda gu dɨꞌɨɨꞌn: ―Jaꞌp jap tɨɨdaꞌ na ɨɨkɨi bham makiaꞌ gu maꞌooꞌn gu Juan jaꞌtkam bopkondam. ");
INSERT INTO stpNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Baꞌ jotmodaꞌ gio mɨjɨp xi mɨɨ gu tɨyaa mu na paiꞌ daa gu Eroodis, baꞌ mu ɇɇk jup tɨtda: ―Aañ jix aaꞌ nap jiñ makiaꞌ jooxiaꞌ taꞌm gu maꞌooꞌn gu Juan jaꞌtkam bopkondam, xib ɨp moo. ");
INSERT INTO stpNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Baꞌ naiꞌ soiꞌ jim duu gu Eroodis, giilhim jix buam jum ɨlh. Guꞌ ji nat guꞌ moo puiꞌp ba tɨɨꞌn miꞌ ja kaichdhat guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ na makiaꞌ na tuꞌ ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Baꞌ puiꞌ tɨix buam jim aagɨt muiꞌ ma joot maaꞌn gu sandaaruiꞌx chugiꞌñ na ɨɨkdharaꞌ gu maꞌooꞌn gu Juan. ");
INSERT INTO stpNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Baꞌ muiꞌp ma jii maaꞌn gu sandaaruiꞌx nat ɨɨkim gu maꞌooꞌn. Baꞌ jaꞌxpɨx miꞌ ba aich, miꞌ xi maa gu tɨyaa. Miꞌ dhɨr baꞌ gu tɨyaa mu jaꞌk jup xi bhɨidhak gu dɨꞌɨɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Baꞌ puiꞌ ba tɨ kai mɨt gu noonbiꞌñ gu Juan na mɨt ba mua, baꞌ muiꞌ ma jii mɨt na mɨt bhɨim gu tukgaꞌn nam yaaspaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Baꞌ gio maap jup bam jumaap jamɨt gu noonbiꞌñ gu Jesuus na mɨt jaꞌk suulhgɨk mu jaꞌp paiꞌ nam jax oipimɨk, baꞌ ba aagiꞌñ am na mɨt jɨꞌk tuꞌx bhaiꞌ tu duu, gio nam jax jaꞌk ja tɨtdaim gu jaꞌtkam nam tu ja aꞌgidhim. ");
INSERT INTO stpNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Baꞌp ja tɨtda gu Jesuus: ―Maik gor paiꞌ na cham jaroiꞌ oirɨ na pim baꞌm jɨɨpdhaꞌ. Nam guꞌ giilhim muiꞌ jaꞌtkam miꞌp oipo, jaiꞌ jimiim am, jaiꞌm miꞌp aajim, pu cham bhaiꞌ nam jax tu jugiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Baꞌ dɨɨlh dai na mɨt jax bha tɨɨtɨs kanuub taꞌm na mi jaꞌp jup sɇꞌ suudaiꞌ jugiiꞌñ, pu cham xi chu tabuimgidhak pu jii mɨt jotmodaꞌ baasɨꞌn dɨr jaꞌk na paiꞌr gampɨx. ");
INSERT INTO stpNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Guꞌ ji na mɨt guꞌ sia ja tɨɨ muiꞌ jaiꞌ dhɨt, jix maatɨt tɨɨ mɨt na bɨɨx gu Jesuus bhammɨ pɨx daichuꞌ nam muiꞌ xi chɨ nɨiꞌñ. Baꞌ bhɨjɨ jaꞌp pu boop jamɨt bɨɨx juꞌñdharan gu suudaiꞌ, bɨɨpɨꞌ kat bhammɨ dɨr bap tuꞌiiꞌ am na mɨt baꞌ guiꞌ bhammɨ dɨr jup ba ai. Jaꞌx xikoor jumpax am, nam guꞌ janoꞌ pɨk muiꞌ miꞌp oipo jaiꞌ kap dɨr, sia mɨk dɨr kam. ");
INSERT INTO stpNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Baꞌ nat muiꞌ ji chɨm gu Jesuus bhaiꞌ dhɨr kanuub taꞌm, nammɨ jaꞌp xi juꞌ am gu jaꞌtkam nat ba ja tɨɨ. Baꞌx ja joiꞌmdat ja tɨɨ, nam guꞌ sap jaꞌp ji buusan na jax gu kakasnir noꞌ cham jaroiꞌ ja bipiaꞌ. Baꞌ bhaiꞌ ji chu ja aꞌgi bɨɨx aixim na jax jaꞌk jir am nam tuiꞌñgɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Baꞌ jaꞌxpɨx jurnidhak mu jaꞌp ba baabu mɨt gu noonbiꞌñ gu Jesuus, jup tɨtda am: ―¿Jax jach jich dhuñiaꞌ? Tɨɨꞌ nat yaꞌ pɨx ba ji jur. ¿Cham aach ba jimiaꞌ nach ba tu koiꞌpoꞌ? Na guꞌ yaꞌ cham bhaaiꞌ nach paiꞌ tu jugiaꞌ, na guꞌ yaꞌr gampɨx. ");
INSERT INTO stpNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dai nap xi ja jootsai dhi jaaduñ kum ba tu taañpuꞌ gu koiꞌ mɨjɨ jaꞌp paiꞌ na jax jir kikcham, nam guꞌ cham tuꞌ uaꞌ gu tuꞌ nam jugiaꞌ, gio na guꞌ yaꞌ cham bhaaiꞌ nam paiꞌ tu sabaꞌdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Baꞌp ja tɨtda gu Jesuus: ―Yaaꞌ pim dho ka tu ja makiaꞌ aapiꞌm. ¿Tuꞌ gi pɨk? Baꞌp kaiꞌch am ɨp gio: ―Jax dhui na guꞌ sia kut maadɨt tɨi ma chu jua jɨꞌk xijum baik masaaꞌn, pu cham ja aix nam tu jugiaꞌ siat tɨi ma chu sabaꞌlh bɨɨx kaꞌm na jɨꞌk maiꞌchiaꞌ gu tuumiñ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Baꞌ ba ja chia nam ja tɨkkaꞌ noꞌm sap cham jaiꞌ dhɨt iam uaꞌ gu koiꞌ, jup ja tɨtda: ―Ea gor xi ja tɨkka noꞌm iam jaiꞌ dhɨt uaꞌ gu koiꞌ. Baꞌ guiꞌ mɨjɨ jaꞌp jup xi ja tɨkkapuk jup tɨtda am gu Jesuus: ―Muni tɨi uaꞌ maadɨt, dai nar gook alh, jix chamaam gu paan gio baꞌ gook gu boptop. ");
INSERT INTO stpNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","―Dhiiꞌ dho ba ja kokbaꞌñchuꞌn ―jup kaiꞌch gu Jesuus. Baꞌp ja tɨtda gu noonbiꞌñ nam sap xi ja chiñiaꞌ nam mi jaꞌp xi dharaibuꞌ xiꞌxkor gu jaꞌtkam saiꞌ dhaam na joidham jix chɨ tɨɨduꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Baꞌ puiꞌp xi ja tɨɨꞌn jamɨt, baꞌ mi jaꞌp jup ji dharaibu mɨt xiꞌxkor. Jɨꞌkchi kap moo guiꞌ na mɨt maap daraibu nam aix jix chamaam ooꞌm, jaiꞌ kap baꞌ gook ooꞌm daman mambhɨɨx, miꞌ pɨx puiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Baꞌ gu Jesuus nat jax dhaa gux chamaam gu paan gio gu gook gu boptop, jix dhaam jaꞌk xi chɨ tɨɨgɨk xi chu taxchaabgidhak pɨx muiꞌ ji ja maa gu noonbiꞌñ taꞌtak jaisaidhat, baꞌ guiꞌ miꞌ dhɨr naiꞌp ji ja maa mɨt gu jaꞌtkam. Na mɨt paiꞌ bɨɨx xi ja maakak gu paan, gio gu boptop naiꞌp ji ja maa mɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bɨɨx chu juu mɨt nam jɨꞌk miꞌp tuꞌiiꞌ, tu koiꞌmɨk am nam jɨꞌx ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jaiꞌ mɨt pu cham ka jugio, puiꞌ mɨt ma chu jumaap ɨp gio, mambhɨɨx daman gook bapaalh jamɨt ja susduiꞌ, ku guꞌ bɨnkam ji gu boptop, cham tuꞌ moo dai gu paan. ");
INSERT INTO stpNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Alh moo muiꞌ jaꞌtkam na mɨt miꞌ tu juu, jix chamaam mambhɨɨx jix chaꞌtmam ooꞌm (5000) aixim gu chichioꞌñ, gu uꞌuub guꞌ cham daaxix kam ji gam aꞌalh. ");
INSERT INTO stpNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Miꞌ dhɨr baꞌ nat jax ja chia gu Jesuus nam bha tɨsdiaꞌ kanuub taꞌm gu noonbiꞌñ, mɨjɨ xi ja joot bɨɨpɨꞌ kat nam ba jimiaꞌ Betsaida jaꞌk. Baꞌ guiꞌ miꞌ ji bii, na guꞌ mi jaꞌp ka ja tabuimgiꞌñ gu muiꞌ jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Baꞌ jaꞌxpɨx nat paiꞌ bɨɨx xi ja tabuimgidhak, pu jii bhɨjɨmmɨ paiꞌ oidhaꞌ daam nat tu aꞌgam jix dhaam jaꞌk buiñor guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Baꞌ kiaꞌpɨx ɨrban ba ji bhɨɨk jamɨt gu noonbiꞌñ nat ba tuk, gu Jesuus pui bhammɨp tuꞌiiꞌ oidhaꞌ daam. ");
INSERT INTO stpNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Baꞌ na bhammɨ dɨr muiꞌ xi chɨ nɨiꞌñ, ba ja tɨɨ nam mummu tɨi tɨ bhɨɨ, cham ka jimmɨ gu kanuub, nat guꞌ giilhim jix ioꞌm bhaiꞌ ji jɨb mu dɨr jaꞌk nam paiꞌ jaꞌk tɨi ka jiimɨt. Baꞌ nammɨ na paiꞌ bar katukgab, muiꞌ ma jii gu Jesuus, bhammɨ dɨr pɨx tu tuiꞌdhiꞌ bɨɨx aꞌnsap, miꞌ ba ai ɨp gio na paiꞌ gɇꞌ suuꞌnkaꞌ gu suudaiꞌ. Miꞌ dhɨr baꞌ bɨɨx suudaiꞌ dhaam pɨx chuꞌm duu, jaꞌp gai dhɨr paꞌ moo bhɨichuꞌ nam paiꞌp tuꞌiiꞌ gu noonbiꞌñ kanuub taꞌm. Baꞌ nat mi jaꞌp jupaaban ji bhɨi, ");
INSERT INTO stpNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","gɇꞌgɇr ba jiiñ jamɨt jix xusuañim na mɨt ba tɨɨ na mi jaꞌp ba jimchuꞌ suudaiꞌ dhaam. Jaꞌp jum aaꞌ am na tuꞌ miꞌ bax ja naa. ");
INSERT INTO stpNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Giilhim jix chotdonɨt muiꞌ ba tɨ nɨiꞌñ am, guꞌ ji nat guꞌ jotmodaꞌ bha ñio, jup ja tɨtda: ―¡Chaꞌpim totdon kaꞌ! ¡Aañiꞌ pɨx jup tuiꞌdhiꞌ! ");
INSERT INTO stpNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Baꞌ muiꞌ ji ai. Baꞌ nat jax bha tɨs kanuub taꞌm, naiꞌ ji kɨkbu gu jɨbɨlh. Baꞌ guiꞌ miꞌ puiꞌ pup tuꞌiiꞌ am, nam guꞌ giilhim jix juraapgix, ");
INSERT INTO stpNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","nam guꞌ chakui maat noꞌr gɇꞌkam gu Jesuus, sia kum tɨi nɨiꞌñ nat muiꞌdhalh gux chamaam gu paan, nam guꞌ cham bɨɨx ja jujur kɨꞌn xim gaꞌnga na jax jir jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Baꞌ jaꞌxpɨx bhammɨ dɨr ba tɨɨtɨs jamɨt juꞌñdharan na paiꞌ Genesareet tɨ tɨɨꞌ, miaꞌn Betsaida. Baꞌ bha jaꞌp xi buraak jamɨt gu kanuub ");
INSERT INTO stpNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","muiꞌ ji chɨɨtɨm. Guꞌ ji nam guꞌ ampɨk muiꞌp tɨ nɨiꞌñ gu jaꞌtkam, jix maatɨt tɨɨ mɨt na maadɨt jir diꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jotmodaꞌ mɨt naiꞌ xi chu aagam mɨjɨ jaꞌp na jax jix chum kakoꞌk, gio jaiꞌ na mɨt muiꞌ ji ja uꞌuuk na paiꞌ oirɨ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Baꞌ nat mɨjɨ jaꞌp xi jii na jax jir kikcham, pup xim ja boosoꞌ am gux kakoꞌkkam mɨjɨ dɨr jaꞌp baꞌpki chɨr, baꞌ soiꞌ tɨtdadaꞌ am na sap sia palhɨɨp nam bhaiꞌ xi dhagiaꞌ juꞌñdharan gu jannulhiꞌñ, pu duduadhiaꞌ am. Puiꞌ baꞌp ji buus, pu dudua mɨt bɨɨx guiꞌ na mɨt jɨꞌk daa gu jannulhiꞌñ sia gu palhɨɨp. ");
INSERT INTO stpNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Baꞌ janoꞌ na miꞌ ka oirɨ gu Jesuus, miꞌ ba ai mɨt bhammɨ dɨr jaꞌk Jerusaleen guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Baꞌ moo ampɨk jup ba ji chu juu mɨt gu jaꞌtkam tugiꞌñ gu Jesuus, baꞌ ba ja tɨɨ mɨt na mɨt jaiꞌ dhɨt cham muiꞌkim jum iꞌkoim, na guꞌ sap jix xidhuu kaꞌ noꞌ cham muiꞌkim ikoimdhix gu jaroiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Na guꞌ guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ gio gu jaiꞌ Israel kam jaꞌtkam, pui miꞌ puiꞌ tu daaꞌñchuꞌ am nam jax jaꞌk tu jimdat gu bɨjɨk dɨr kam kat, na sap noꞌm cham muiꞌkim ikoimdhix, cham jir am nam gan tu kuaꞌdaꞌ, nam guꞌ sap jum uaꞌtulhdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Gio jaiꞌ cham daaxix kam, puiꞌ na jax gu jaroiꞌ noꞌt jii paiꞌ na bɨxchuꞌ tum gaꞌra, jum aaꞌndaꞌ sap na muiꞌkim batbiaꞌ jaꞌk gɨɨsɨi, na guꞌ sap jix xidhuu na tu jugiaꞌ noꞌt jax dhuuk cham muiꞌkim batbia. Gio gam gu tuꞌ na bhaan tu ioꞌdaꞌ na muiꞌkim ja bopkondaꞌ, gio gu bhiꞌmkar, gio baꞌ gu tuꞌ na bhaan dadarrɨdaꞌ na paiꞌ dhuuk ba ji chu jugiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Miꞌ dhɨr baꞌ bhaiꞌ ji chɨkka mɨt gu Jesuus guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, jup tɨtda am: ―¿Jax kum baꞌ dhim jaꞌtkam tuk cham miꞌ puiꞌ ka jimchuꞌ nam jax tu jimdat guch bopxikat? Tɨɨꞌ nam cham muiꞌkim jum iꞌkoimdhat tu kuaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Baꞌp ja tɨtda gu Jesuus: ―Dho puiꞌ na jax aapiꞌm na pim guꞌ cham tuꞌ miꞌ puiꞌ jiim na pim jax jaꞌk tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam nam tuiꞌñgɨdaꞌ. Bak guꞌr puiꞌ nat jax tu uaꞌnak miꞌ uꞌuan taꞌm gu Isaiiyas guiꞌ nat muiꞌkim bha ñioꞌkdhak guñ Gɨꞌkoraꞌ, nap jum kaiꞌch: Dhi jaꞌtkam puiꞌ xi kaiꞌch am nam sap tuꞌ kaꞌm jiñ ñɨiꞌñ, guꞌ ji na guꞌ gu ja jujur mɨk jaꞌk jup tuꞌiiꞌ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","¿Tuꞌm gi miꞌp tɨgiaꞌ siam bɨɨx aixim tu daan? Nam guꞌ cham tuꞌ miꞌ puiꞌ jiim nañ jax jix aaꞌ, gio na guꞌ nam jɨꞌk jax tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam, dɨɨlh pɨx nam jax ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","’Jix matgam dho ―jup kaiꞌch gu Jesuus―, na pim guꞌ jaꞌp xi dhuukat na jax jix aaꞌ gu Dios. Dai na pim miꞌ puiꞌ tu daaꞌñchuꞌ nam jax tu jimdat gu bɨjɨk dɨr kam kat nam muiꞌkim ja bopkondat gu tuꞌ nam bhaan tu ioꞌdaꞌ, gio jaiꞌ cham aagix kam ku pim pu tu buim. ");
INSERT INTO stpNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","’Guꞌ baꞌ na jax jix aaꞌ gu Dios, tuꞌ pɨx ɨlhiiꞌñ japim. Dai na pim mu jaꞌk jix chutkagix na pim jax ɨlhiiꞌñ dɨɨlh. ");
INSERT INTO stpNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","¿Moo jaꞌp cham jam aꞌm baapak aa? Gi nat jaꞌpni tu uaꞌnak bo gu Moisees nap jum kaiꞌch miꞌ uꞌuan taꞌm: “Tuꞌ kaꞌm jap nɨidhat gum taat gio gum naan.” Gio baꞌ moo jaꞌpnip jum kaiꞌch ɨp: “Gu jaroiꞌ na cham tuꞌ kaꞌm nɨiꞌñdhaꞌ gu taataꞌn piam gu dɨꞌɨɨꞌn, pɨx am tɨꞌñchokaꞌ na joodai kɨꞌn maꞌyaxix kam muukix kaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Guꞌ ji na guꞌ aapiꞌm jix ioꞌm maakam ba xi buim, jaꞌp jum aaꞌ pim nar am na jaꞌp tɨɨdaꞌ gu jaroiꞌ gu taataꞌn piam gu dɨꞌɨɨꞌn: “Puiꞌ ba tɨɨꞌn jañich gu Dios nañ bɨɨx mu tu tuꞌaaꞌ chiop nañ jɨꞌk tu biaꞌ. Cham ka bhaaiꞌ nañ jax dhuim taiñbuidhaꞌ, sia ku jaꞌp moo tɨim aꞌm jum aaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Dai noꞌt puꞌñi ba tɨɨꞌn gu taataꞌn piam gu dɨꞌɨɨꞌn, aapiꞌm puiꞌ ba tɨꞌyaꞌ na miꞌ puiꞌ ba jimchuꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ, jaꞌp moo sɨlhkam xi kaiꞌchdhaꞌ pim. ");
INSERT INTO stpNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ba xi jii pimɨt na pim bɨɨx aixim tu bua bhaan jim iatat nam jax tu jimdat gu bɨjɨk dɨr kam. Guꞌ baꞌ na jax jix aaꞌ gu Dios, gampaiꞌ pɨx biaꞌ pim, panaas ku pu cham tuꞌ bhaiꞌ, gio jaiꞌ cham aagix kam ku pim pu tu buim. ");
INSERT INTO stpNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Baꞌ gu Jesuus maap ja jumpadak gu muiꞌ jaꞌtkam jup ja tɨtda: ―Ka na pim moox bhaiꞌ xiñ kaayaꞌ bɨɨx na pim jɨꞌk yaꞌp tuꞌiiꞌ nañ jax jam tɨɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jax dhui na guꞌ cham tuꞌ xidhuu noꞌ moo tu kuaꞌ pɨx gu jaroiꞌ, guꞌ ji noꞌx bhaamut naiꞌ tɨtɨɨꞌñcho, piam ku jax ña pɨx jum aaꞌ na jax cham jir am na baꞌx xidhuu, na guꞌr uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Miꞌ pim puiꞌ ba jimiaꞌ jɨꞌk na pim jix maatɨt jiñ kɇɇ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Baꞌ miꞌ puiꞌ xi ja tɨtdaimɨk pu jii mummu na paiꞌ tɨbiapkaꞌ. Baꞌ nat mu ba ai, ba tɨkka am gu noonbiꞌñ na jax kaiꞌñkam jup kaiꞌch gu puiꞌ na jax ja tɨtda gu muiꞌ jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Baꞌp ja tɨtda: ―¿Aapiꞌm aa puiꞌ cham maatɨt jup tɇ kɇɇ? Jaꞌp jañ dho kaiꞌch na cham tuꞌ xidhuu noꞌ moo tu kuaꞌ pɨx gu jaroiꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","na guꞌ sɨlh bookaran jaꞌk bhɨɨyaꞌ gu koiꞌ, miꞌ dhɨr dai na giop ba buusniaꞌ, cham tuꞌ na juraꞌran jaꞌk baapkɨi miꞌx buam ba jurtuꞌnkaꞌ. Baꞌ dhiꞌ na puiꞌ jɨꞌ kaiꞌch gu Jesuus, jaꞌp kaiꞌñkam jup kaiꞌch na sap cham tuꞌ xidhuu gu tuꞌ koiꞌ, pu ni jax chuꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Baꞌ jaꞌpnip ja tɨtda: ―Guꞌ ji noꞌx bhaamut naiꞌ tɨtɨɨꞌñchu gu jaroiꞌ piam ku jax ña pɨx jum aaꞌ nax buam jir jum duukam na baꞌx xidhuu, na guꞌr uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Na guꞌ kaiꞌñkam ja jujur am dɨr gu jaꞌtkam na bhaiꞌ jim gɨgɨꞌlhiꞌñ gux buam jum duukam, jax ñam pɨx bam aaꞌndaꞌ, jaꞌp na jax guiꞌ nam jaiꞌ jix bhaiꞌ ja tɨtdadaꞌ gu uꞌuub sia kum tɨi tɨ bɨpnaꞌ, gio gu uꞌuub ba puiꞌ ɨp. Gio guiꞌ nam cham tɨɨmuiꞌx kaꞌ, siam tɨi maap tu oiꞌdhaꞌ. Gio guiꞌ nam jaꞌtkam ja kooꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Gio guiꞌ nam tɨ ɨɨxiꞌñdhaꞌ. Gio guiꞌ nam jix bhaamut nɨiꞌñdhaꞌ gu jaroiꞌ noꞌ tuꞌ biaꞌ, nam jaiꞌ puiꞌp jix aagɨt. Gio guiꞌ nam jax ñam pɨx tu buadaꞌ na jax cham jir am. Gio guiꞌ nam iatdaꞌ. Gio guiꞌ nam jotmodaꞌ pɨx jix bhaiꞌ tɨɨdaꞌ gu ubii, miꞌ dhɨr jumai ɨp. Gio guiꞌ nam jix chɨ jɨɨgak kaꞌ. Gio guiꞌ nam giilhim tu ñiok. Gio guiꞌ nam jix buam ja aꞌgadaꞌ gu jaꞌtkam. Gio guiꞌ nam gɇꞌgɇrkam jum taat kaꞌ. Gio guiꞌ nam bɨɨx aixim tu buadaꞌ, panaas kum cham ja jujur biaꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bɨɨx dhiꞌñi na jɨꞌk jix buam jir jum duuꞌnkam, ja jujur am dɨr jum gɨgɨꞌlhiꞌñ gu jaꞌtkam. Dhiꞌ ji na baꞌ puiꞌm kaiꞌch nax xidhuu, na guꞌ giilhim jir uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Miꞌ dhɨr baꞌ ma jii gu Jesuus mummu maaꞌn kap, miaꞌn pɨx iam na paiꞌ gɇꞌr kiicham Tiiro tɨ tɨɨgim. Baꞌ miꞌ nat paiꞌ ai, tɨi cham paiꞌ jimmɨdaꞌ na tɨi cham aagɨt na jaroiꞌx mat kaꞌ na pa jaꞌk jax chuiꞌkaꞌ. Guꞌ ji nat guꞌ cham puiꞌ ji chu buus, moo janoꞌ puiꞌ ba tɨm tɨi. ");
INSERT INTO stpNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Miꞌ ba jimchuꞌ maaꞌn gu ubii nat jax puiꞌ tɨ kai, na sap cham kɨɨꞌ tu iiꞌmdaꞌ kaꞌ maaꞌn gu maraaꞌn, ampɨx puiꞌx ñaanbiꞌ kaꞌ, baꞌ miꞌ oꞌlhiaꞌn kɨꞌn ji kɨkbu bɨɨpɨꞌ dɨr gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Guiꞌ gu ubii cham tuꞌr Israel kam kaꞌ, pur miꞌ kam kaꞌ Peniisia, na Siiria bhaan bipioꞌ guiꞌ gu dɨbɨɨr. Baꞌ soiꞌ xi chɨtda, jup tɨtda na sap iam maiꞌ jootsaꞌ gu cham kɨɨꞌ iiꞌmdaꞌ bhaiꞌ dhɨr bhaan gu tɨɨyax. ");
INSERT INTO stpNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Guꞌ ji na guꞌp tɨtda gu Jesuus: ―Ea nañ bɨɨpɨꞌ ka xi ja palhbuidhaꞌ gu Israel kam jaꞌtkam nañ baꞌ aap jup bam palhbuidhaꞌ. Na guꞌ noꞌ ñich aap bɨɨpɨꞌm palhbui, jaꞌp ji buusniaꞌ na jax gu aꞌaalh noꞌm ka tu kuaꞌ gu tuꞌ koiꞌ noꞌ ñich miꞌ dhɨr ja boppoidhak mu xi ja maa gu goꞌngox. ");
INSERT INTO stpNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Baꞌp kaiꞌch gu ubii: ―Dho guꞌ puiꞌ dat do jia tɨi, guꞌ ji nañ guꞌ aañ soiꞌñ ɨlhiiꞌñ. ¿Cham aa guꞌ cham jax jup bua noꞌp moo xich joiꞌmdai jich palhbuidhaꞌ gɨt? Na guꞌ jaꞌp ji buusniaꞌ na jax noꞌm tɨ tɨɨtɨb gu goꞌngox gu biimuñgaꞌn na iigɨsdaꞌ paiꞌ nam tu kuaꞌdaꞌ gu aꞌaalh. ");
INSERT INTO stpNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Baꞌp tɨtda gu Jesuus: ―Jaꞌpji moo sɨlhkam jia nap soiꞌm ɨlhiiꞌñ jiñ jaduuñ. Ba buus ji matgam gu cham kɨɨꞌ iiꞌmdaꞌ bhaiꞌ dhɨr bhaan gum maraax. Chaꞌp jax kam aaꞌndaꞌ, ba jimiaꞌ ap. ");
INSERT INTO stpNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Baꞌ ba jii ɨp gu ubii. Nat paiꞌ dhuuk mu ai kiaꞌmiꞌñ, jix kɨɨꞌ mi jaꞌp boꞌm bakxidhat gu tɨɨyax, pu ba buus gu cham kɨɨꞌ iiꞌmdaꞌ bhaiꞌ dhɨr bhaan na kɨꞌn kax ñaanbiꞌ kat. ");
INSERT INTO stpNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Baꞌ miꞌ na paiꞌ daakat gu Jesuus miaꞌn gɇꞌ kiicham Tiiro tɨ tɨɨgim, miꞌ dhɨr giop ma jii, moo bhaiꞌ buus na paiꞌ Sidoon tɨ tɨɨꞌ, na puiꞌp jir gɇꞌ kiicham. Bhaiꞌ dhɨr jaꞌp gakoolh bhɨɨk mummu ba buus na paiꞌ Dekaapolis bhaan bipioꞌ gu dɨbɨɨr. Mu ji ai miaꞌn na paiꞌ gɇꞌ suuꞌnkaꞌ gu suudaiꞌ, na Galilea bhaan ba bipioꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Baꞌ miꞌ ba baiꞌñchuꞌ am gu jaꞌtkam maaꞌn gux koꞌkkam na cham tɇ kɇɇkɇꞌ gio na cham tu ñiokdaꞌ, baꞌ soiꞌ tɨtda am na sap palhɨɨp bhaiꞌ xi dhagiaꞌ na baꞌ dodhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Baꞌ gu Jesuus jaꞌp jaꞌk xi baidhak dɨɨlhkob palhɨɨp bhɨjɨ xi kɨɨꞌmpi naankaran, gio baꞌ nat xi xixbuidhak gu nobiiꞌñ palhɨɨp bhaiꞌ xi dhaa nɨɨnɨran. ");
INSERT INTO stpNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Gio baꞌ nat jax jix dhaam jaꞌk xi chɨ tɨɨgɨk iiꞌmdagaꞌn xi buak jup kaiꞌch: ―¡Epaata! ―na jaꞌp kaiꞌñkam jup jum kaiꞌch: ¡Xim kukpioꞌk! ");
INSERT INTO stpNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Baꞌ joidham bhaiꞌ jim kukpioꞌ gu naankaꞌn guiꞌ na cham tɇ kɇɇkat, gio gu nɨɨnɨꞌn pu dua ɨp, jix bhaiꞌ ba tu aꞌga. ");
INSERT INTO stpNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Baꞌp ja tɨtda gu Jesuus guiꞌ nam miꞌp tuꞌiiꞌ nam sap cham jaroiꞌ aagiꞌñdhaꞌ nat jax dhuuk duaꞌñ, guꞌ ji nam guꞌ guiꞌ moo janoꞌ naiꞌ pɨx jaꞌx puiꞌ tu ja aꞌgiꞌñ, sia kut tɨi xi ja sooꞌmcholhdhak. ");
INSERT INTO stpNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Baꞌ gu jaꞌtkam guiꞌ nam puiꞌ tu ja aꞌgiꞌñdhaꞌ miꞌ puiꞌ pup tuiꞌkaꞌ am, jaꞌxpɨx dai nam jup kaiꞌchdhaꞌ: ―¡Joidham dho bak jia! Jaiñ na guꞌ puiꞌ ja duduaꞌñdhim guiꞌ nam cham tɇ kɇɇ gio guiꞌ nam cham tu ñiok. ");
INSERT INTO stpNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Baꞌ miꞌ na paiꞌ ka oirɨ gu Jesuus, gio muiꞌ miꞌp ma ai mɨt gu jaꞌtkam. Baꞌ baik jurniꞌñ kɨꞌn ma juu gu koiꞌ nam tu uaꞌdat. Baꞌ maap xi ja jumpadak gu noonbiꞌñ, jup ja tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Jix joiꞌmdat ja nɨiꞌñ iñ dhi jaꞌtkam, na mɨt guꞌ baik tanoolh yaꞌ ba ji juruuñ. Cham ka tu uaꞌ am gu tuꞌ nam jugiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na guꞌ noꞌ ñich puiꞌ cham tu ja maakak ba ja joot ja kiꞌaam jaꞌk, mu paiꞌ uaꞌmaꞌ am boi chaꞌm, nam guꞌ jaiꞌ mɨk dɨr tu jim. ");
INSERT INTO stpNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Baꞌp tɨtda am gu noonbiꞌñ: ―¿Jax gi dhui jaroiꞌp ba tu ja maa, na guꞌ yaꞌr gampɨx? ¿Paach gip tu sabaꞌdaꞌ gu tuꞌ nach ja makiaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Baꞌ ba ja tɨkkaꞌn, jup ja tɨtda: ―¿Guꞌ jɨꞌk japim pɨx uaꞌ gu paan na pim saak uaꞌ? Baꞌ guiꞌp tɨtda am: ―Xijum gook dho pɨx. ");
INSERT INTO stpNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","―Dhiꞌch dho taꞌtak jaisai ja makiaꞌ ―jup kaiꞌch gu Jesuus. Miꞌ dhɨr baꞌp ja tɨtda nam sap xi ja chiñiaꞌ gu jaꞌtkam nam xi dharaibuꞌ. Baꞌ guiꞌ puiꞌp xi ja tɨɨꞌn jamɨt, baꞌ pɨx mi jaꞌp jup ji dharaibu mɨt. Baꞌ gu Jesuus nat jax dhaa gu xijum gook gu paan xi chu taxchaabgidhak pɨx muiꞌ ji ja maa gu noonbiꞌñ taꞌtak jaisaidhat, baꞌ guiꞌ miꞌ dhɨr pɨx naiꞌp ji ja maa mɨt gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Gio baꞌ gu boptop jɨꞌkchip uaꞌdat am. Nat jax jup daa, puiꞌp xi chu taxchaabgidhak pɨx muiꞌp ji ja maa gu noonbiꞌñ, miꞌ dhɨr baꞌ guiꞌ pɨx naiꞌp ji ja maa mɨt ɨp gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dappaam tu juu mɨt, tu koiꞌmɨk am nam jɨꞌx ɨlhiiꞌñ. Jaiꞌ mɨt pu cham ka jugio, puiꞌ mɨt ma chu jumaap, xijum gook bapaalh susda gu taꞌtak gaꞌn nat bii. ");
INSERT INTO stpNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Maakob mambhɨɨx jix chaꞌtmam ooꞌm (4000) aix am gu jaꞌtkam na mɨt miꞌ tu juu. Miꞌ dhɨr baꞌ dai nat jax xi ja tabuimgidhak, ");
INSERT INTO stpNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","nat jax bha tɨs bhaan gu kanuub, pu jii ja bɨɨm gu noonbiꞌñ baasɨꞌn dɨr jaꞌk maaꞌn kap na paiꞌ Dalmanuuta bhaan bipioꞌ guiꞌ gu dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Baꞌ na mɨt bhammɨ dɨr ba tɨɨtɨs, bhaiꞌp ba ai mɨt guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ. Baꞌ pɨx am bhakku am buiñor gu Jesuus, bhax aaꞌ am na sap jup duñiaꞌ gu tuꞌ nar jix bhaiꞌm duukam ja nɨiꞌñchudat, na sap baꞌ bhaan matgilhiaꞌ noꞌt baabuiꞌ sɨlhkam bha joot guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Guꞌ ji na guꞌ gu Jesuus cham aaꞌ, dai nat jix buam jum aagɨt iiꞌmdagaꞌn xi buak jup ja tɨtda: ―¿Jax ku pim baꞌx aaꞌ nañ jup duñiaꞌ maaꞌn gu tuꞌ nar jix bhaiꞌm duukam? Na pim guꞌ gammɨjɨ pu nɨiꞌñdhaꞌ. Aañ pu kaiꞌch tuꞌ sɨlhkam kɨꞌn nañ cham tuꞌp duñiaꞌ dai aapiꞌm jam nɨiꞌñchudat, na pim guꞌ cham jɨꞌxkat tɨ jɨɨꞌñdhaꞌ aañ jiñ bui, sia kuñ jix bhaiꞌ tɨi tu bua. ");
INSERT INTO stpNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Daipuꞌ xi ja tɨɨdak nat jax bha tɨs kanuub taꞌm, pu jii ɨp gio baasɨꞌn dɨr jaꞌk miꞌ na paiꞌ gɇꞌ suuꞌnkaꞌ gu suudaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jaꞌp moo cham jup ka tɨꞌñchuꞌ am nam xi chu gaamui gɨt gu tuꞌ nam tu jugiaꞌ gu noonbiꞌñ gu Jesuus, maaꞌn pɨx bha uaꞌ am gu paan kanuub taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Baꞌ nammɨ gama jaꞌk nam ba jiimchuꞌ, jup ja tɨtda gu Jesuus: ―Moo pim cham ja kɇkɇɇdaꞌ guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ gio guiꞌ nam kaichuꞌ gu Eroodis. Nam guꞌ jaꞌp ji buusan na jax guiꞌ na kɨꞌn jappukar gu paan, giilhim jix chu iaꞌñdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Baꞌ bhaiꞌ jim tɨ tɨkka mɨt dɨɨlh jix dhuꞌnpiꞌñ kɨꞌn, jup kaiꞌch am: ―¿Jax baꞌ ku baꞌp kaiꞌch? Guꞌ bak nach cham ka tɨꞌñchu gu paan nach bha uiꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Guꞌ ji na guꞌx bhaiꞌx maat gu Jesuus nam jax kaiꞌch, jup ja tɨtda ɨp gio: ―¿Jax ku pim baꞌ dai gu tuꞌ paan bhaan tu aꞌgim na pim cham uaꞌ? Nañ guꞌ aañ cham tuꞌ tuꞌ koiꞌ aagɨt jup kaiꞌchim. ¿Moo jaꞌp cham maatɨt tɇ kɇɇ pim aa? ¡Moo jaꞌp jix kaapak ji jia gu jam jujur! ");
INSERT INTO stpNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Kaꞌ pim ji cham tu buupui aa, kaꞌ cham tu naanak japim aa? ¿Kux moo jaꞌp cham tɨtɨꞌñchuraꞌ pim aa? ");
INSERT INTO stpNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Jɨꞌk japimɨt bapaalh ja susduiꞌ gu paan gu taꞌtakgaꞌn nat bii janoꞌ na ñich muiꞌdhalhdhak tu ja maa gux chamaam mambhɨɨx jix chaꞌtmam ooꞌm gu jaꞌtkam? Baꞌ guiꞌp tɨtda am: ―Mambhɨɨx daman gook bapaalh dho. ");
INSERT INTO stpNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Janoꞌ gi na ñich paiꞌ dhuuk muiꞌdhalh gu xijum gook gu paan, na ñich tu ja maa gu maakob mambhɨɨx jix chaꞌtmam ooꞌm, ¿jɨꞌk japimɨt bapaalh ja susduiꞌ? Baꞌ guiꞌp tɨtda am: ―Xijum gook bapaalh dho. ");
INSERT INTO stpNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Baꞌp ja tɨtda: ―¿Guꞌ jax ji ku pim baꞌ moo jaꞌp cham maatɨt tɇ kɇɇ, ni ku pim xim gaꞌnga na jax jir jum duukam? Nañ guꞌ aañ cham tuꞌ tuꞌ koiꞌ aꞌgidhat jup kaiꞌchim, jaꞌpji guiꞌ nam pariseos jum tɨɨtɨꞌ gio guiꞌ nam kaichuꞌ gu Eroodis nañ ja aagɨt jup kaiꞌchim, na cham jir am nam jax jaꞌk tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Baꞌ miꞌ dhɨr muiꞌ ma jii gu Jesuus mummu na paiꞌr gɇꞌ kiicham, Betsaida tɨ tɨɨgim. Baꞌ miꞌ ba baiꞌñchuꞌ am maaꞌn gu maaꞌnkam na cham ñia kaꞌ, baꞌ soiꞌ ba tɨtda am na sap palhɨɨp bhaiꞌ xi dhagiaꞌ na baꞌ dodhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Baꞌ gu Jesuus am xi ñobchɨk gammɨjɨ pɨx chuꞌm duu, nammɨ baas juꞌñdharan xi baabuk palhɨɨp bhaiꞌ xi julh gu chiñbur gaꞌn buupuiran gio nat palhɨɨp bhaiꞌ xi dhaa, baꞌ xi chɨkka noꞌ sap moo bax chu maax na naiꞌ xi chɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Baꞌp kaiꞌch gu cham ñia kam naiꞌ xi chɨ nɨidhat: ―Bax chu maax paꞌ dho. Jaꞌp tuꞌm jum maaxiꞌñ am gu jaꞌtkam na gu tutua. ");
INSERT INTO stpNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Baꞌ gio bhaiꞌp xi dhaa buupuiran, jix bhaiꞌ bhaiꞌ ji ñiata, pu dua, sap joidham jix bhaiꞌx chu maax na naiꞌ xi chɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Miꞌ dhɨr baꞌ dai nat ba joot kiaꞌmiꞌñ jaꞌk, jup tɨtda: ―Ba jimiaꞌ ap jum kiꞌaam jaꞌk. Gakoolh jap moo bhɨɨyaꞌ miꞌ dhi gɇꞌ kiicham nam cham bam tɨkkadaꞌ gu miꞌ oiꞌñkam na pich jax dhuuk dua. ");
INSERT INTO stpNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Baꞌ mɨkkat giop ma jii gu Jesuus ja bɨɨm gu noonbiꞌñ mummu jaꞌk jɨꞌkchi kap na paiꞌr kikcham, miaꞌn gɇꞌ kiicham na Sesarea Piliipo tɨ tɨɨꞌ. Baꞌ nam nammɨ ka jimchuꞌ bɨɨx boi, ba ja tɨkka, jup ja tɨtda: ―¿Jax jam kaiꞌchdhaꞌ gu jaꞌtkam? ¿Jaroo sap daꞌ iñ? ¿Tuꞌñ sap jir jup tuꞌm daꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Baꞌ guiꞌp tɨtda am: ―Dho jɨꞌmaꞌn jup kaiꞌchdhaꞌ am nap sap aap jir diꞌ gu Juan guiꞌ na jaꞌtkam ja bopkondat. Jaiꞌ baꞌp kaiꞌchdhaꞌ am ɨp nap sap aap jir diꞌ gu Eliiyas, guiꞌ nat saak maaxik jii jix dhaam jaꞌk. Gio baꞌ jaiꞌp kaiꞌchdhaꞌ am ɨp nap sap aap maadɨt jir diꞌ guiꞌ nam bɨjɨk ya jaꞌp bhaankam tu aꞌgimɨk guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Baꞌ dɨɨlh jup xi ja tɨkka gu Jesuus, jup ja tɨtda: ―Aapiꞌm gi, ¿xiñ maat japim aa nañ jir tuꞌp tuꞌm daꞌ? Baꞌ muiꞌ ji ñio gu Peegro, jup kaiꞌch: ―Dho aapiꞌ dhor diꞌ guch Xoiꞌkam guiꞌ na saak bha jootsaꞌ gɨt guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Baꞌ xi ja sooꞌmcholhdhak nam sap cham jaroiꞌ aagiꞌñdhaꞌ, dɨɨlh jam sap pɨx puiꞌx chu mat kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Miꞌ dhɨr baꞌ gio bhaiꞌp ji chu ja aꞌgi gu Jesuus gu noonbiꞌñ, jup ja tɨtda: ―Giilhim kañ chulhiiñaꞌ iñ, ku baꞌ guꞌ cham jax bua ji, nat guꞌ pu kaiꞌñkam bhañ joot guñ Gɨꞌkoraꞌ. Cham jiñ kɨɨgalhdhaꞌ am guiꞌ nam jir ja gɇꞌgɇrkam tuk kaꞌ gu Israel kam jaꞌtkam, gio gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, tu chiñiaꞌ am nam jiñ muꞌaaꞌ. Ku baꞌ guꞌ aañ baik tanoolh kɨꞌn yaaꞌ ji nañ jax ba oirɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Dhiꞌ puiꞌ dho gi guꞌx bhaiꞌ ja aagiꞌñ ji, cham tuꞌ paiꞌ tuꞌ bhaan ji uaꞌrgidhat. Baꞌ gu Peegro jaꞌp jaꞌk dɨlhkob xi baabuk jup tɨtda na sap cham jir am gu puiꞌ na jax kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Guꞌ ji na guꞌ gu Jesuus jotmodaꞌ kuuꞌ kɨkbu, mu jaꞌk tɨ nɨidhat nam paiꞌ pup daraa gu jaiꞌ gu noonbiꞌñ, jup tɨtda: ―¡Chaꞌp tuꞌ kɨꞌn jiñ juandaꞌ toobolhik! Nap guꞌ cham puiꞌ ɨlhiiꞌñ na jax jix aaꞌ gu Dios. Puiꞌ pɨx jaꞌk ɨlhiiꞌñ ap nam jax ɨlhiiꞌñ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Baꞌ maap xi ja jumpadak gu noonbiꞌñ gio gu jaꞌtkam, jup ja tɨtda: ―Noꞌ jaroiꞌx aaꞌ na gammɨjɨ bañ kaichgɨdaꞌ, jum aaꞌ na jaꞌp xidhui na dɨɨlh jax ɨlhiiꞌñdhaꞌ, dai na pɨx bhaan ji bamgiaꞌ, cham jax bua sia kum jix muꞌaam. ");
INSERT INTO stpNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Na guꞌ gu jaroiꞌ noꞌ tɨi bañ kaichgɨt, noꞌt dai miꞌ ba ji chooꞌn noꞌm bax muꞌaam, cham bhaiꞌ ka tu jimiaꞌ, na guꞌ cham jɨꞌxdhaꞌ ka tɨsdiaꞌ jix dhaam jaꞌk. Guꞌ cham ji noꞌ guꞌ cham tuꞌ ji kɇkɇɇdat gammɨjɨñ kaichuꞌ, noꞌ miꞌ puiꞌ xi jimchuꞌ na jax jum kaiꞌch gux bhaiꞌm kaiꞌchdham ñioꞌkiꞌñ guñ Gɨꞌkoraꞌ, jix bhaiꞌ dho tu jimiaꞌ, na guꞌ pu jimiaꞌx dhaam jaꞌk, sia ku mɨt ba mua. ");
INSERT INTO stpNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Tuꞌ gix bhaiꞌ sia ku jaroiꞌ bɨxchuꞌ tu biaꞌ gu tuꞌ na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch? Na guꞌ puiꞌ pɨx cham jup palhbuidhaꞌ na jax dhui tɨsdiaꞌ jix dhaam jaꞌk, ");
INSERT INTO stpNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","guꞌ ji na soiꞌm duujim uanaꞌ noꞌx aaꞌ na cham jum tulhiiñaꞌ. Na guꞌ cham jum aaꞌ na mu paiꞌ tu namkiꞌñdhaꞌ, dai na pu tɨɨdaꞌ guñ Gɨꞌkoraꞌ jix dhaam jaꞌk na uanaꞌ gu uaꞌtulhdhar gaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Guꞌ baꞌ gu jaroiꞌ noꞌ jax dhuukat tɨi ba tɨ jɨɨgiꞌñ jiñ bui, aañ nat bhañ joot guñ Gɨꞌkoraꞌ, noꞌ guꞌ daix xiꞌɨr nañ aꞌmkam tu ja aꞌgidhaꞌ gu jaꞌtkam guiꞌ nam chakui tɨ jɨɨgiꞌñdhaꞌ nam jix uaꞌtulhdhix kaꞌ, pɨx am tɨꞌñchukaꞌ nañ cham baidhikaꞌ jix dhaam jaꞌk, janoꞌ nañ paiꞌ dhuuk bhammɨ dɨr gio yaꞌp ba aayaꞌ yaꞌ dhi oiꞌñgaꞌn ja bɨɨm gu noonbiꞌñ guñ Gɨꞌkoraꞌ, nam baꞌ ampɨx machiaꞌ bɨɨx gu jaꞌtkam nañ jir gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jaꞌpni baꞌ moop ja tɨtda: ―Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨɨdaꞌ, jaiꞌ dhɨt na pim jɨꞌk yaꞌp tuꞌiiꞌ xib, ka tɨgiaꞌ pim na pim tuꞌ cham paiꞌ nɨiꞌñ na baꞌ bhaan matgilhiaꞌ nañ aañ jaꞌxbuiꞌp jir gɇꞌkam na jax gu Dios, baꞌ bhaankam bhañ joot nañ ya jaꞌp jup tuiꞌñgɨdaꞌ ja bui guiꞌ nam jɨꞌk jix biiñak kaꞌ buiñor na baꞌ cham tuꞌ ja duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Baꞌ gatuuk xijum maaꞌn jurniꞌñ kɨꞌn ma jii gu Jesuus ja bɨɨm baik gu noonbiꞌñ, moo gu Peegro, gio gu Jakoobo, gio baꞌ gu Juan, bhammɨ mɨt ba tɨɨtɨs maaꞌn gu gɇꞌ oidhaꞌ taꞌm. Baꞌ bhaiꞌ jotmodaꞌ maakam tuꞌm bhaiꞌp jim duu, ");
INSERT INTO stpNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","bhaiꞌ ji chotbikɨ gu jajannulhiꞌñ, jix chuaap jum duu, ni na cham jaꞌp jix chua na jax gu jabook kɨb noꞌ bhaan mi chanoor. Jaꞌp jix ioꞌm jix chua ji, na moo sia ku dɨɨlh pux chua gu jannulh, cham jɨꞌxkat pu chuꞌm oñiaꞌ, siat muiꞌkim tɨim bakua. ");
INSERT INTO stpNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Baꞌ bhaiꞌ bam maax gu Eliiyas gio gu Moisees, bɨxxik dɨr guguukat tu aꞌgiꞌñ am gu Jesuus na mɨt ba tɨɨ gu noonbiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Baꞌ muiꞌ ji ñio gu Peegro, jup kaiꞌch: ―¡Umri moor am na pich bhach baidhak jiñ jaduuñ nach yaꞌp tuiꞌkaꞌ jum bɨɨm! Xib baꞌ tuꞌ na jax chuiꞌkaꞌ, jɨꞌmaꞌn jach jam oꞌnamdhaꞌ, maaꞌn jir aap gaꞌn kaꞌ, jumai baꞌr Moisees gaꞌn kaꞌ, jumai baꞌr Eliiyas gaꞌn kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Cham jum matdaꞌɨr puiꞌ ba tɨi gu Peegro, na guꞌ giilhim jix juraapgix, gio gu jaiꞌ ba puiꞌ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Baꞌ jotmodaꞌ bhaiꞌ ji chɨ ɨɨka dai miꞌ nam paiꞌp tuꞌiiꞌ, sɨlh bhaiꞌ jim gɨꞌɨɨlh gu tɨbaaꞌ na paiꞌ dhɨr bha tanoor. Baꞌ bhɨjɨmmɨ dɨr tɨbaaꞌñ chɨr bhaiꞌ ji chum ñio, jup tum kaiꞌch: ―Dhiꞌr jiñ mar na pim baꞌ moox mat kaꞌ. Miꞌ pim puiꞌ xi chuiꞌñgɨt na jax jam tɨɨdaidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Baꞌ jotmodaꞌ mu tɨ tɨɨ mɨt na paiꞌp tuꞌiiꞌ gu Jesuus, cham paiꞌ ka tu jaiꞌch am guiꞌ nam bɨɨmaꞌn miꞌ ka guꞌkat. Dɨɨlh pɨx miꞌ ba kɨɨk. ");
INSERT INTO stpNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Miꞌ dhɨr baꞌ dai na mɨt giop ba jii. Baꞌ bhammɨ dɨr aꞌnsap nam bhaiꞌ ba juurkim, jup ja tɨtda gu Jesuus: ―Moo pim chakui jaroiꞌ aagiꞌñdhaꞌ gu xib puiꞌ na pimɨt jax tɨ tɨɨ. Janoꞌ baꞌ nañ paiꞌ dhuuk muukɨi yaꞌ nañ jax ba oirɨdaꞌ aañ nat bhañ joot guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Baꞌ guiꞌ cham jaroiꞌp aagiꞌñdhaꞌ am, dɨɨlh pɨx puiꞌx chu mat kaꞌ am. Dai nam tɨim tɨ tɨkkaꞌndaꞌ dɨɨlh na sap jax kaiꞌñkam jup ja tɨtda na puiꞌ muukɨi miꞌ na jax ba oirɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Miꞌ dhɨr baꞌ moop ba tɨkka am, jup tɨtda am: ―¿Jax kum baꞌp kaiꞌchdhaꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios na puiꞌ bɨɨpɨꞌ yaꞌ aayaꞌ gu Eliiyas na baꞌ guch Xoiꞌkam yaꞌp ba aayaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Baꞌp ja tɨtda: ―Jir puiꞌ dho, na guꞌ puiꞌm kaiꞌch mi uꞌuan taꞌm gu ñioꞌkiꞌñ gu Dios. Bɨɨpɨꞌ bha jimiaꞌ gu Eliiyas na baꞌ yaꞌ ba ja mattudaꞌ gu jaꞌtkam na bhaiꞌ ba jim guiꞌ na bha jootsaꞌ guñ Gɨꞌkoraꞌ. Dai ji na guꞌ giilhim jum tulhiiñaꞌ, jaꞌppɨx maaꞌnkam ɨlhdhaꞌ am gu jaꞌtkam, na guꞌ puiꞌ jaꞌk jup jum kaiꞌch mi uꞌuan taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ku baꞌ guꞌ jaꞌp moo gu tuꞌx matgam ba tum kuugalh ji, nat guꞌ yaꞌ tɨi ai gu Eliiyas, guꞌ ji na mɨt guꞌ tuꞌ pɨx ɨlh gu jaꞌtkam puiꞌ na jax jup jum kaiꞌch mi uꞌuan taꞌm gu ñioꞌkiꞌñ gu Dios. Juan jaꞌtkam bopkondam jañ aagɨt jup kaiꞌch na puiꞌ ji buusan na jax gu Eliiyas. ");
INSERT INTO stpNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Baꞌ jaꞌxpɨx nat mummu ba ai gu Jesuus ja bɨɨm gu baik gu noonbiꞌñ, miꞌ na mɨt paiꞌ pup bii gu jaiꞌ noonbiꞌñ, ba ja tɨɨ nam jaꞌx xikoor guguuk gu jaꞌtkam xikoolh dhɨr, miꞌ ñiokbotuꞌ am ja bɨɨm guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, nam guꞌ miꞌp oipo. ");
INSERT INTO stpNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Baꞌ gu jaꞌtkam na mɨt ba tɨɨ gu Jesuus na miꞌ amuub ba aajim, joidham jix bhaiꞌm ɨlh jamɨt. Jotmodaꞌ mɨt mu boop, baas jamɨt namkɨk ba ñioꞌki. ");
INSERT INTO stpNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Baꞌ nat miꞌ ba ai na paiꞌ pɨx tuꞌ tum kaiꞌch, ba ja tɨkka gu noonbiꞌñ nam tuꞌ aꞌgat pɨx tuꞌ kaiꞌch, jup ja tɨtda: ―¿Tuꞌ pim baꞌ kɨꞌn ñiokbo ja bɨɨm dhi jaaduñ? ");
INSERT INTO stpNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Baꞌ miꞌ dhɨr jaꞌp bhaiꞌ ji ñio maadɨt gu jaroiꞌ, jup kaiꞌch: ―Aañiꞌ dhoñ aꞌm jup tu tuꞌiiꞌ jiñ jaduuñ na ñich bhaiꞌ ma baidhak guñ mar nap kapbhaiꞌ yɨjɨ paiꞌ pɨx kaidhaꞌ nap oirɨ, nap gɨt iam maiꞌ jootsaꞌ gu cham kɨɨꞌ iiꞌmdaꞌ bhaiꞌ dhɨr bhaan na kɨꞌn cham tu ñiok. ");
INSERT INTO stpNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Paiꞌjɨ jix ioꞌm ba xi bhɨɨyaꞌ, jotmodaꞌ iarɨi bhaiꞌ jim totbhiopaꞌ, gio na bhaiꞌ ji choksolhiaꞌ gu chiñiiꞌñ, gio baꞌ na kioꞌñchoꞌndaꞌ gu taatmuꞌn. Jaꞌp baꞌ moox gak pɨx baꞌ. Tɨi ñich ba ja umuaꞌ dhiñ jaaduñ dhiꞌ nam jum kaichuꞌ nam maiꞌ jootsaꞌ gɨt, guꞌ ji na guꞌ chix xijai, jax ña jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Baꞌp ja tɨtda gu Jesuus bɨɨx nam jɨꞌk miꞌp tuꞌiiꞌ: ―¿Jax ku pim baꞌ moo jaꞌp cham jɨꞌx buiñor jix biiñak guñ Gɨꞌkoraꞌ? ¿Jɨꞌx jañ baꞌ ya jaꞌp oirɨt jup tu jam aagiꞌñdhaꞌ? Bhaiꞌ gor xiñ baiꞌñxiꞌñbup gux koꞌkkam. ");
INSERT INTO stpNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Baꞌ ma baiꞌñxidham jamɨt. Baꞌ nam amuub ba baiꞌñchuꞌ, bhaiꞌ jim bhaamtuda gu cham kɨɨꞌ iiꞌmdaꞌ nat ba tɨɨ gu Jesuus na miꞌp tuꞌiiꞌ. Ba xi bhɨi gu biapmaꞌ, mi jaꞌp naiꞌ ji ia, giilhim bhaiꞌ jim totbhiopa, gio nat bhaiꞌ ji choksogir gu chiñiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Baꞌ xi chɨkka gu Jesuus gu taataꞌn gu biapmaꞌ, jup tɨtda: ―¿Paa duuk dɨr puiꞌ bam bua? Baꞌ guiꞌp kaiꞌch: ―Alhiꞌch dhɨm dɨr do. ");
INSERT INTO stpNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Paiꞌjɨ puꞌñi bhaiꞌ jim bhammutuꞌndaꞌ gu cham kɨɨꞌ iiꞌmdaꞌ na jax xib, miꞌ ba gɨxiaꞌ tai chɨr dhiñ mar piam paiꞌ suudaiꞌ chɨr. Jaꞌp moo tɨip mumuaꞌdaꞌ dho, kux baꞌ gu joidham aa. Puiꞌ kuñ baꞌ soiꞌm tɨtdañ jaduuñ noꞌp moo puiꞌp ɨlhiiꞌñdhaꞌ gɨt nap xich joiꞌmdai mach palhbuidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Baꞌp tɨtda gu Jesuus: ―Dho guꞌ noꞌp guꞌ bax biiñak kaꞌ buiñor guñ Gɨꞌkoraꞌ, xib dho puiꞌ ji chu buusniaꞌ, na guꞌ guiꞌ cham tuꞌ xijaichuꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Baꞌ gu taataꞌn gu biapmaꞌ xiꞌkam mu ñio ɨp gio, jup kaiꞌch: ―Dho guꞌ aañ chɨix biiñak ji panaas, guꞌ chi moo chakuir puiꞌ ji jia. Aaꞌ nap mañ aaꞌñdhaꞌñ jaduuñ nañ baꞌx bhaiꞌ machiaꞌ nañ jax jaꞌk jix ioꞌm bax biiñak kaꞌ buiñor. ");
INSERT INTO stpNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Baꞌ pɨx ji aajim am gu jaꞌtkam na ja nɨiꞌñ gu Jesuus, baꞌ xim jotmaꞌñ nat maiꞌ joot gu cham kɨɨꞌ iiꞌmdaꞌ, jup tɨtda: ―Aapiꞌ cham kɨɨꞌ iiꞌmdaꞌ nap miꞌ naanbichuꞌn dhiñ jaduuñ na baꞌ cham tu ñiok gio na cham tɇ kɇɇ, mu buusaiñ bhaiꞌ dhɨr bhaan. Chaꞌp baꞌ gio bhaiꞌp ka bapkɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Baꞌ panaas kut jix ioꞌm ba xi bhɨi gu biapmaꞌ nat paiꞌ dhuuk ba ji buus gu cham kɨɨꞌ iiꞌmdaꞌ bhaiꞌ dhɨr bhaan, panaas kut naiꞌ ji muu. Baꞌ xeej jiiñkɨk gu cham kɨɨꞌ iiꞌmdaꞌ nat baꞌ pɨk ba buus. Baꞌ jaiꞌ dhɨt jup kaiꞌch am gu jaꞌtkam: ―Pu muukɨk jup jum duu ji dhiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Guꞌ ji na guꞌ gu Jesuus nat jax nobiꞌran daa, xi bamiiꞌ. Joidham bhaiꞌ ji bam, jix kɨɨꞌp jum duu. ");
INSERT INTO stpNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Baꞌ mɨkkat nat gio mummup ba ai gu Jesuus na paiꞌ tɨbiapkaꞌ, ba tɨkka am gu noonbiꞌñ, jup tɨtda am: ―¿Jax ku chich baꞌ aach cham jax dhooda gu cham kɨɨꞌ iiꞌmdaꞌ nach tɨip tɨtda na buusniaꞌ gɨt bhaiꞌ dhɨr bhaan gu biapmaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Baꞌp ja tɨtda gu Jesuus: ―Dho na guꞌ guiꞌ pu chuꞌm gu cham kɨɨꞌ iiꞌmdaꞌ, saabuix kam jum aaꞌ, gio nañ gammɨjɨ xi chu aꞌgat jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ na baꞌx bhaaiꞌn kaꞌ nañ maiꞌ jootsaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Miꞌ dhɨr baꞌ giop ma jii mɨt, mummu mɨt ba bubua na paiꞌ Galilea bhaan bipioꞌ gu dɨbɨɨr. Baꞌ tɨi cham aagɨt gu Jesuus na jaroiꞌx mat kaꞌ na miꞌ buusnichuꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","na guꞌp ja tɨtdaim gu noonbiꞌñ: ―Aañ nat bhañ joot guñ Gɨꞌkoraꞌ, jum aayaꞌ gu tanoolh nañ miꞌ pɨx ji buusniaꞌ nam paiꞌñ oꞌbhagiꞌñdhaꞌ gu jaꞌtkam gɇꞌgɇrkam jum aaꞌndam. Miꞌ puñ dhaagɨi tu chiñiaꞌ am nam jiñ muꞌaaꞌ, ku baꞌ guꞌ aañ baik tanoolh kɨꞌn yaaꞌ ji nañ jax ba oirɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Guꞌ ji na mɨt guꞌ cham maatɨt kai na jax kaiꞌñkam jup ja tɨtda. Tɨi xix chɨkkam kaꞌ am, guꞌ ji nam guꞌx ɨɨbhiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Baꞌ mummu ba ai mɨt gɇꞌ kiicham na paiꞌ Kapernaum tɨ tɨɨꞌ. Baꞌ nam miꞌ ka daraa nam paiꞌ tɨbiapkaꞌ, ba ja tɨkka gu Jesuus gu jaꞌtkam tugiꞌñ nam tuꞌ aꞌgim bhɨjɨ bɨɨx boi nam paiꞌ dhuuk bha jimchuꞌ, jup ja tɨtda: ―¿Tuꞌ pim baꞌ aꞌgim bhɨjɨ bɨɨx boi nach bha jim na pim baꞌx dhuꞌnpiꞌñ kɨꞌn pɨx chuꞌ kaiꞌchim? ");
INSERT INTO stpNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pu cham jaroiꞌ ñiok, nam guꞌx xiꞌɨr, nam guꞌm tɨ tɨkkaim na jaroiꞌ jix ioꞌm jir gɇꞌkam guiꞌ nam jɨꞌk bha jiimchuꞌ dai guiꞌ nam jɨꞌk kaichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Baꞌ maap ja jumpadak gu mambhɨɨx daman gook gu noonbiꞌñ, mi jaꞌp ji dhaibuk jup ja tɨtda: ―Noꞌ jaroiꞌx aaꞌ nax ioꞌm jir gɇꞌkam kaꞌ, jum aaꞌ na soiꞌm ɨlhiiꞌñdhaꞌ gio na ja palhbuiꞌñdhaꞌ gu jaꞌtkam, sia nar jaroiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Baꞌ maaꞌn gu alhii nat jax nobchɨk mi jaꞌp ba kɨɨs ja saagiꞌñ. Miꞌ dhɨr baꞌ xi dhaagɨk jup ja tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Noꞌt jaroiꞌx bhaiꞌ ba duu maaꞌn gu alhii jiñ aꞌmkam jaꞌp na dhiꞌñi nañ yaꞌ daaꞌ, puiꞌ ji buusniaꞌ nat aañ jix bhaiꞌ bañ dhuu. Ku baꞌ guꞌ cham tuꞌ ji na moo dai aañ nax bhaiꞌñ dhuñiaꞌ, guꞌ jaꞌpji bɨɨx ji sia guñ Gɨꞌkoraꞌ guiꞌ nat bhañ joot. ");
INSERT INTO stpNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Baꞌ bhaiꞌ ji ñio gu Juan, jup kaiꞌch: ―Aañ chɨi xim tɨkkam na chich maaꞌn tɨɨ gu maaꞌnkam nam aꞌmkam maiꞌ ja jootos gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gu jaꞌtkam. Aach baꞌ xi sooꞌmcholhdhak, na guꞌ cham jich bɨɨm oirɨ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Baꞌp kaiꞌch gu Jesuus: ―¿Jax ku pimɨt baꞌp sooꞌmchulh? Na guꞌ cham jɨꞌxkat jiñ aꞌmkam jix bhaiꞌ tu duñiaꞌ gu jaroiꞌ noꞌ cham tɨ jɨɨgiꞌñ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Na guꞌ gu jaroiꞌ noꞌ cham jix buam jich aꞌga, miꞌ puiꞌ tu daꞌñchuꞌndaꞌ na jax aach. ");
INSERT INTO stpNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Baꞌ gu jaroiꞌ noꞌt tu jam maa gu koiꞌ, piam sia dai suudaiꞌ noꞌt jam toiꞌ, noꞌx maat na pim jiñ kaichuꞌ, tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨɨdaꞌ, dhiꞌ bhaan ba tɨ nɨiꞌñdhaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Guꞌ baꞌ gu jaroiꞌ noꞌt maakam iatgidhak jix buam ba tu mamtux maadɨt gu alhii puiꞌ na dhiꞌñi, noꞌ guꞌ tɨi ka tɨ jɨɨgiꞌñdhat aañ jiñ bui, piam sia kur gɇꞌ maaꞌnkam noꞌt kiaꞌpɨx ba ji chɨ jɨɨꞌñdhak, aañ pu jam tɨtda na dhiꞌ baꞌ puiꞌm kaiꞌch na cham jir kɨɨꞌ. Dhiꞌ baꞌ puiꞌ pɨx bax bhaigɨt nam bha bulhdhai gu mattur kuxburan mɨjɨmmɨ paiꞌ buaꞌ suudaiꞌ chɨr, na baꞌ cham gammɨjɨ pup jum uaꞌtulhdhidhaꞌ, gio nam baꞌ cham miꞌ ji kɇɇji gu jaiꞌ miꞌ bhaiꞌp jim uaꞌtulhdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Guꞌ baꞌ noꞌt jax dhuuk mam uaꞌtulh gu jaroiꞌ, noꞌt guꞌ gu nobiiꞌñ chuꞌm daꞌp duu, puiꞌ pɨx bax bhaiꞌ na tu chiñiaꞌ nam ɨɨkdhaꞌ na baꞌ cham pɨx ba jim uaꞌtulhdhidhaꞌ. Na guꞌ cham jax bua sia ku maaꞌn pɨx tu nob, noꞌ tɨ jɨɨgiꞌñ buiñor guñ Gɨꞌkoraꞌ, cham tuꞌm tulhiiñaꞌ noꞌt bam jaꞌbsu gu tukgaꞌn, pu jimiaꞌx dhaam jaꞌk. Guꞌ gi baꞌ noꞌ guꞌ cham tɨ jɨɨgiꞌñ, sia ku tɨi bɨɨx gook jix kɨkɨɨꞌ gu noonbiꞌñ, mu jaꞌk pu bhɨɨyaꞌ dhox chu tukgam kɨr na paiꞌr tulhiiñaraꞌ gammɨjɨ, na paiꞌ cham tutkɨ gu tai, ");
INSERT INTO stpNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","mu na paiꞌ jaꞌp ji buusan na jax paiꞌ juꞌñdharan gu gɇꞌ kiicham na tum nuꞌaidhaꞌ gu tanaaradaꞌ, nam giilhim muiꞌ mi bɨtkaꞌ bo gu botpodaꞌ nam tu kuaꞌdaꞌ gu tuꞌ dɨbaalhgaꞌn na mi chu suulhgidhaꞌ, gio baꞌ na gammɨjɨ tɨ mɨɨjidhaꞌ dai miꞌ, na guꞌ mim kuusdaidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Piam ku guꞌ noꞌt jax dhuuk mam uaꞌtulh gu jaroiꞌ, noꞌt guꞌ gu toonaꞌn tuꞌm daꞌp duu, puiꞌ pɨx bax bhaiꞌ ɨp na tu chiñiaꞌ nam ɨɨkdhaꞌ na baꞌ cham pɨx ba jim uaꞌtulhdhidhaꞌ. Na guꞌ cham jax bua sia ku maaꞌn pɨx chu toon, noꞌ tɨ jɨɨgiꞌñ buiñor guñ Gɨꞌkoraꞌ, cham tuꞌm tulhiiñaꞌ noꞌt bam jaꞌbsu gu tukgaꞌn, pu jimiaꞌx dhaam jaꞌk. Guꞌ gi baꞌ noꞌ guꞌ cham tɨ jɨɨgiꞌñ, sia ku tɨi bɨɨx gook jix kɨkɨɨꞌ gu tootnaꞌn, mu jaꞌk dho pu bhɨɨyaꞌ jix chu tukgam kɨr na paiꞌr tulhiiñaraꞌ gammɨjɨ, na paiꞌ cham tutkɨ gu tai, ");
INSERT INTO stpNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","mu na paiꞌ jaꞌp ji buusan na jax paiꞌ juꞌñdharan gu gɇꞌ kiicham na tum nuꞌaidhaꞌ gu tanaaradaꞌ, nam giilhim muiꞌ mi bɨtkaꞌ bo gu botpodaꞌ nam tu kuaꞌdaꞌ gu dɨbaalhgaꞌn na mi chu suulhgidhaꞌ, gio baꞌ na gammɨjɨ tɨ mɨɨjidhaꞌ dai miꞌ, na guꞌ mim kuusdaidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Piam ku guꞌ noꞌt jax dhuuk mam uaꞌtulh gu jaroiꞌ, noꞌt guꞌ gu buiꞌñ tuꞌm daꞌp duu, puiꞌ pɨx jup bax bhaiꞌ ɨp na tu chiñiaꞌ nam jupñidhaꞌ na baꞌ cham pɨx ba jim uaꞌtulhdhidhaꞌ. Na guꞌ cham jax bua sia ku maaꞌn pɨx tu bui, noꞌ tɨ jɨɨgiꞌñ buiñor guñ Gɨꞌkoraꞌ, cham tuꞌm tulhiiñaꞌ noꞌt bam jaꞌbsu gu tukgaꞌn, pu jimiaꞌx dhaam jaꞌk. Guꞌ gi baꞌ noꞌ guꞌ cham tɨ jɨɨgiꞌñ, sia ku tɨi bɨɨx gook jix kɨkɨɨꞌ gu buupuiꞌñ, mu jaꞌk dho pu bhɨɨyaꞌ jix chu tukgam kɨr na paiꞌr tulhiiñaraꞌ gammɨjɨ, na paiꞌ cham tutkɨ gu tai, ");
INSERT INTO stpNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","mu na paiꞌ jaꞌp ji buusan na jax paiꞌ juꞌñdharan gu gɇꞌ kiicham na tum nuꞌaidhaꞌ gu tanaaradaꞌ, nam giilhim muiꞌ mi bɨtkaꞌ bo gu botpodaꞌ nam tu kuaꞌdaꞌ gu tuꞌ dɨbaalhgaꞌn na mi chu suulhgidhaꞌ, gio baꞌ na gammɨjɨ tɨ mɨɨjidhaꞌ dai miꞌ, na guꞌ mim kuusdaidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Guꞌ baꞌ guiꞌ nam jɨꞌk jiñ kaichgɨdaꞌ, jax ña pɨx ba tu tatdakaꞌ paiꞌjɨ, panaas ku tuꞌ na pɨx jax ba ja duñiaꞌ, jaꞌp ji na jax dhui ja tɨꞌñchuixiꞌñkaꞌ nam baꞌx ioꞌm muiꞌ xim biiñkadaꞌ buiñor guñ Gɨꞌkoraꞌ. Baꞌ dhiꞌ iampɨx jaꞌpniñ jaꞌk uaꞌrgidhat jup kaiꞌch na jax gu bɨjɨk dɨr kam nam tu makgɨrtardaꞌ na baꞌ ja uañdhidhaꞌ gu Dios gu ja uaꞌtulhdharaꞌ, bɨɨpɨꞌm miꞌ xi buidhai gɇꞌ gu on nam baꞌ ba mɨidhaꞌ. Baꞌ gu xib guiꞌ nam jɨꞌk jix aaꞌndaꞌ na oñiaꞌ gu ja uaꞌtulhdharaꞌ, ja aꞌm jum aaꞌ nam jix ioꞌm xim biiñkadaꞌ aañ jiñ bui na baꞌ jaꞌp ji buusniaꞌ na jax gu makgɨr gu bɨjɨk dɨr kam kat, cham tuꞌ kam aaꞌ nam moo puiꞌp tu buidhaꞌ kiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Na guꞌ guiꞌ nam jɨꞌk miꞌ puiꞌ ba jimchuꞌndaꞌ, noꞌm cham tuꞌ bhaan jim banoosat tu oiꞌdhaꞌ, dhiꞌ jaꞌpni jaꞌk ji busaak na jax gu koiꞌ noꞌ ampɨx jix onkak. Guꞌ baꞌ noꞌ mɨt guꞌ dai miꞌ bɨxchuꞌ bhaan ba jim banoosa, noꞌm guꞌ cham puiꞌ ɨlhiiꞌñ gu jaiꞌ, dhiꞌ jaꞌp ji buusniaꞌ na jax gu on guiꞌ nar jaiꞌ paꞌ noꞌt maaꞌnnim ba baꞌn, na cham tuꞌ ka bhaiꞌn kaꞌ, na guꞌ cham puiꞌ ka onkak kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Baꞌ giop ma jii gu Jesuus miꞌ dhɨr Kapernaum mummu jaꞌk maaꞌn kap na paiꞌ Judea bhaan bipioꞌ guiꞌ gu dɨbɨɨr. Mɨkkat baꞌ baasɨꞌn dɨr jaꞌk gu Jordaan Ak xi jii, iampɨx xiaꞌlhbui jaꞌk, na paiꞌ maakam jaꞌk ba bipioꞌ guiꞌ gu dɨbɨɨr. Baꞌ muiꞌ bhaiꞌ mam jumaap jamɨt gu jaꞌtkam, baꞌ bhaiꞌ xi chu ja aꞌgidhimɨk, puiꞌ na jax ba tu ja aꞌgiꞌñdhaꞌ gammɨjɨ na jax jaꞌk jix bhaiꞌ nam tuiꞌñgɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Baꞌ moo bhaiꞌp ba ai mɨt guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, baꞌ ba tɨkkaꞌn am gu Jesuus noꞌ sap jix bhaaiꞌ gu jaroiꞌ noꞌ cham ka joiꞌñ gu bɨngaꞌn na maiꞌ xi buaji jumai xi bhɨɨji. Nam miꞌ pɨx mamtɨ, ee jax pɨk sap tɨꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Baꞌ xi ja tɨkka ɨp gu Jesuus, jup ja tɨtda: ―¿Jax gi jaꞌk jum kaiꞌch mi uꞌuan taꞌm nat tu uaꞌnak gu Moisees? Tɨix maat, guꞌ ji na guꞌ pɨx jap ja tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Baꞌ guiꞌp kaiꞌch am: ―Dho saak dai na palhɨɨp tum uaꞌnaꞌ uꞌuan taꞌm na bhaan jix maatɨꞌ kaꞌ nam cham tuꞌ kar jum bɨpnagɨm kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Baꞌp ja tɨtda ɨp gio gu Jesuus: ―¿Jax japim baꞌ ɨlhdhat kɇɇ gu puiꞌ nat tu uaꞌnak? ¿Panaas kur joidham aa? Jaꞌpni dho kaiꞌñkam puiꞌ jaꞌk tu uaꞌna, na guꞌ giilhim jix kaapak kaꞌ gu ja jujur gu bɨjɨk dɨr kam, cham jɨꞌxkat miꞌ puiꞌ jii mɨt na jax tɨi pɨk tu ja aꞌgidhimɨk. Baꞌ aapiꞌm alh jaꞌp moox ja oiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Guꞌ matgam jaꞌpjani jaꞌk na aagix janoꞌ dɨr nat paiꞌ dhuuk jup duu gu Dios dhi oiꞌñgaꞌn, na guꞌ puiꞌ tu uaꞌñix gu ñioꞌkiꞌñ mi uꞌuan taꞌm nap jum kaiꞌch: “Gook pɨx ya ja doꞌñcho gu jaꞌtkam, maaꞌn chioꞌñ gio maaꞌn ubii.” ");
INSERT INTO stpNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gio baꞌ moo jaꞌpnip jum kaiꞌch ɨp: “Na paiꞌ dhuuk ba tɨ bɨɨnaꞌ kaꞌ gu jaroiꞌ maadɨt, jix bhaiꞌ na maakam jaꞌk ba tu kiichaꞌ bɨɨmaꞌn gu bɨngaꞌn, cham tuꞌ miꞌ ka kiokaꞌ nam paiꞌ oiꞌñkaꞌ gu gɨꞌkorgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Baꞌ maaꞌn iiꞌmdaꞌp duukaꞌ am gook dɨt daim bɨpnagɨm.” Baꞌ dhiꞌ jaꞌpnir jum duukam, na baꞌ jaꞌp ji buusniaꞌ na bar maaꞌn maaꞌnkam kaꞌ, sia kum jir gook. ");
INSERT INTO stpNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na guꞌ gu Dios cham tuꞌ aaꞌ gu puiꞌ jaꞌk nam xim uꞌji gatuuk giop bam jɨꞌdɨlhkadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Baꞌ na mɨt paiꞌ dhuuk gio mummup ba ai nam paiꞌ tɨbiapkaꞌ, ba tɨkka am gu noonbiꞌñ na jax kaiꞌñkam jup ja tɨtda gu pariseos miꞌ na paiꞌ xi chu ja aꞌgidhimɨk. ");
INSERT INTO stpNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Baꞌx bhaiꞌ xi ja aagiꞌñ gu Jesuus, jup ja tɨtda: ―Jaꞌpniñ dho kaiꞌñkam jup kaiꞌch, na gu jaroiꞌ noꞌt maiꞌ xi buak gu bɨngaꞌn jumai bhaiꞌ tɨip ji bhɨi, cham tuꞌ puiꞌ ka ja biaꞌkaꞌ guñ Gɨꞌkoraꞌ nam jir jum bɨpnagɨm kaꞌ, puiꞌ pɨx bar tuutuꞌm kaꞌ am guꞌ buiñor na jax guiꞌ nam jir ganaiꞌ pɨx kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Gio gu ubii noꞌt maiꞌ xi buak gu bɨngaꞌn jumai tɨip xi oi, cham tuꞌ puiꞌp ka ja biaꞌkaꞌ guñ Gɨꞌkoraꞌ nam jir jum bɨpnagɨm kaꞌ, puiꞌ pɨx jaꞌk jup ba ji buusandaꞌ buiñor nañ jax ba kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Miꞌ dhɨr baꞌ mɨkkat miꞌ ba ai mɨt gu jaꞌtkam na paiꞌp tuꞌiiꞌ gu Jesuus, ji ja uaꞌdat am gu ja aꞌaalh chuk na sap baꞌ bɨɨx jɨꞌmaꞌn xi ja daagɨi tu aꞌgaꞌ ja aꞌmkam jix dhaam jaꞌk buiñor guch Gɨꞌkoraꞌ. Guꞌ ji nam guꞌ gu noonbiꞌñ cham aaꞌ, ba ja ñiok jamɨt, jup ja tɨtda am na cham bhaiꞌ nam mu jaꞌk ja uaꞌdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Guꞌ ji nat guꞌ gu Jesuus ba ja kai gu noonbiꞌñ nam ja ñiokiꞌñ gu jaꞌtkam nam pɨx ji aajim, baꞌx buam jum ɨlh, jɨꞌx chɨi pɨx am jix bhaamum jum ɨꞌlhiꞌñ, baꞌp ja tɨtda: ―Chaꞌpim ja ñiokiꞌñdhaꞌ dhi jaaduñ nam bha ja uaꞌ gu ja aꞌaalh chuk, na guꞌ noꞌm soiꞌm ɨlhiiꞌñ gu jaꞌtkam, ja aꞌm tɨ nɨiꞌñdhaꞌ gu Dios. Nam guꞌ jaꞌp ji buusandaꞌ na jax gu aꞌaalh noꞌm chakui tuꞌ bhaan tɨtɨɨꞌñchu nax buam jir jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨɨdaꞌ, gu jaroiꞌ noꞌx aaꞌ na bhaan tɨ nɨidhidhaꞌ gu Dios, jum aaꞌ na soiꞌm duukaꞌ gio na soiꞌm ɨlhiiꞌñdhaꞌ gammɨjɨ. Baꞌ dhiꞌ jaꞌp ji busaak na jax gu alhii noꞌx chɨ kɇɇ nam tuꞌ chiandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Daipuꞌ xi ja tɨɨdak, miꞌ dhɨr baꞌ dai na jax ja daꞌngɨ gu aꞌaalh, muiꞌ xi chu aꞌga ja aꞌmkam jix dhaam jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Baꞌ maaꞌnnim nat ba jii gu Jesuus, nammɨ gama jaꞌk ba ai mɨrdat maaꞌn gu biapmaꞌx chumñigam, baꞌ mi jaꞌp oꞌlhiaꞌn kɨꞌn xi kɨkbuk bɨɨpɨꞌ dɨr jup kaiꞌch: ―Aañ jaꞌp tɇ kɇɇ nap joidham jir jix bhaiꞌkam jiñ jaduuñ. Baꞌ bhaiꞌ ma mɨɨ ñich na ñich bham tɨkkam na jax jaꞌk jix bhaiꞌ nañ duuji miꞌ puiꞌ jimiaꞌ na saak jax jix aaꞌ guch Gɨꞌkoraꞌ nañ baꞌ buiñor bap tuiꞌkaꞌ, na baꞌ gammɨjɨ jiñ aꞌm ba tɨ nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Baꞌp tɨtda gu Jesuus: ―¿Jax jap duukat jix maat nañ jir jix bhaiꞌkam jiñ jaduuñ? Na guꞌ jumaip jix jaiꞌch guiꞌ na jaꞌxbuiꞌ puiꞌp jir jix bhaiꞌkam na jax aañ, guiꞌ dhoñ Gɨꞌkoraꞌ nax dhaam jup tuꞌiiꞌ. Guiꞌ jɨꞌ ji na baꞌm baidhikaꞌ jix dhaam jaꞌk, ");
INSERT INTO stpNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","noꞌp dho ji miꞌ puiꞌ jimiaꞌ na jax tu uaꞌñix mi uꞌuan taꞌm gu ñioꞌkiꞌñ nap jum kaiꞌch: “Chaꞌp jaiꞌx bhaiꞌ ka ja tɨtdadaꞌ gu uꞌuub nap paiꞌ dhuuk ba tɨ bɨɨnaꞌ kaꞌ. Gio nap cham ja kooꞌndaꞌ gu jaꞌtkam. Gio nap cham tɨ ɨɨxiꞌñdhaꞌ. Gio nap cham iatdaꞌ. Gio nap tuꞌ kaꞌm tɨ nɨiꞌñdhaꞌ, puiꞌ na jax gum taat nap moo tuꞌ kaꞌm xi ñɨidhat gio gum naan.” ");
INSERT INTO stpNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Baꞌp kaiꞌch ɨp gio gu biapmaꞌ: ―Dho guꞌ aañ moo tɨi cham paiꞌ dhuuk mu paiꞌ jax tu bua ji na ñich dhɨr bhaiꞌñ jur ji bhɨi. Bɨɨx jañ miꞌ puiꞌ jimchuꞌ nap jax ba kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Baꞌx joiꞌmdat ba tɨɨ gu Jesuus, na guꞌx maat nar puiꞌ na jax kaiꞌch. Baꞌp tɨtda: ―Maaꞌn ka biꞌiix ji matgam nam aꞌm jum aaꞌ nap miꞌ puiꞌ jimiaꞌ, nap bɨɨx tu gaꞌraꞌ guiꞌ nap jɨꞌk tuꞌ biaꞌ, ja makiaꞌ ap baꞌ gu tuumiñ guiꞌ nam alh cham bhaiꞌ nam paiꞌ dhɨr uꞌji tuꞌ kɨꞌn tu sabaꞌdaꞌ. Na guꞌ cham jax bua noꞌp bañ kaichuꞌ sia pich puiꞌ ji bii gu xib, na guꞌx dhaam jaꞌk puiꞌ nap jax bar jix chumñigam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Baꞌ gampaiꞌ jim duu gu biapmaꞌ nat puiꞌ jɨꞌ xi chɨɨꞌn. Giilhim jix buam jum aagɨt ba jii, na guꞌ dai mu jaꞌk bhaan jix chukgix, na guꞌ giilhim jir jix chumñigam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Baꞌ gu Jesuus bhaiꞌ xi ja tɨɨgɨk gu jaꞌtkam tugiꞌñ nam mi jaꞌp guguuk bɨɨx xikoolh dhɨr, jup ja tɨtda: ―¿Jax japim ɨlhdhat tɨ nɨiꞌñ jiñ jaaduñ? Tɨɨꞌ na jax jix xijai na tɨ jɨɨꞌñdhaꞌ buiñor gu Dios gu jaroiꞌ noꞌr jix chumñigam. ");
INSERT INTO stpNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Baꞌ miꞌ puiꞌ pup tuꞌiiꞌ am nat puiꞌ jɨꞌ xi ja tɨɨꞌn. Baꞌx bhaiꞌ xi ja aagiꞌñ, jup ja tɨtda: ―Jaꞌpniñ dho kaiꞌñkam jup kaiꞌch jiñ jaaduñ. Giilhim jix xijaim ɨlhiiꞌñdhaꞌ na bhaan tɨtɨɨꞌñchukaꞌ gu Dios gu jaroiꞌ noꞌr jix chumñigam, na guꞌ dai mu jaꞌk bhaan jix chukgix kaꞌ gu tuꞌ na tu biaꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Na guꞌ jaꞌp ji busaak na jax gu soomkar na alhiꞌch alh tu bui. ¿Jax dhui mu baakɨi jaꞌp dɨr jaꞌk ji buusniaꞌ gu tuꞌ noꞌ giilhim jir gɇꞌ, jaꞌp na jax gu kameeyo? Puꞌñip ji buusan gu jaroiꞌ noꞌr jix chumñigam. ");
INSERT INTO stpNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jix ioꞌm miꞌ puiꞌ pup tuꞌiiꞌ am gu jaꞌtkam tugiꞌñ nat gio puiꞌ jɨꞌp xi ja tɨɨꞌn. Naiꞌ tɨim tɨ tɨkka am dɨɨlh, jup kaiꞌch am: ―Dho bak guꞌ cham jɨꞌxkat jaroiꞌ tɨsdiaꞌ jix dhaam jaꞌk, na guꞌ bak puiꞌ giilhim jix xijai nañ gammɨjɨ bhaan tɨtɨɨꞌñchokaꞌ na jax jaꞌk jix bhaiꞌr jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Baꞌ gu Jesuus bhaiꞌ xi ja tɨɨgɨk jup ja tɨtda ɨp gio: ―Dho guꞌ gu jaꞌtkam giilhim jix xijaim ɨlhiiꞌñ am dho. Guꞌ gu Dios buiñor pur cham tuꞌ, na guꞌ bɨxchuꞌx bhaaiꞌ nap tu duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Baꞌ bhaiꞌ ji ñio gu Peegro, jup kaiꞌch: ―Dho guꞌ aach chɨi bɨɨx jaꞌp xi dhuuk ji gu tuꞌ palhɨɨp nach biaꞌkat na chich paiꞌ dhuuk dɨr bhaiꞌ ji chɨ jɨɨꞌñ aap jum bui. ");
INSERT INTO stpNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Baꞌp kaiꞌch gu Jesuus: ―Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨɨdaꞌ, gu jaroiꞌ noꞌt jaꞌp xi dhuuk gu tuꞌ na tu biaꞌkaꞌ, puiꞌ na jax gu baꞌpkiꞌñ, piam gu xiixioꞌgiꞌñ, piam gu sɨspidhiꞌñ, piam gu taataꞌn, piam gu dɨꞌɨɨꞌn, piam gu bɨngaꞌn, piam gu maamraꞌn, piam gu dɨppɨr paiꞌ nar gaꞌn kaꞌ, noꞌt aañ jiñ bui ba tɨ jɨɨꞌñ na baꞌ miꞌ dhɨr dai nañ aꞌmkam ba tu aꞌgadaꞌ gux bhaiꞌm kaiꞌchdham ñiꞌook, ");
INSERT INTO stpNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","jix ioꞌm muiꞌ tu makiaꞌ guñ Gɨꞌkoraꞌ, jix chamaam ooꞌm pup. Cham tuꞌ jaꞌkbuiꞌ na jɨꞌk jaꞌp xi dhuu ji, guꞌ jaꞌpji muiꞌ ji na jaꞌk iabuidhaꞌ gu baꞌbhak, gio gu xiixioꞌgiꞌñ, gio gu sɨspidhiꞌñ, gio gu dɨɨdɨꞌn, gio gu maamraꞌn, gio gu dɨppɨr, sia ku guꞌx buam tu tatdakaꞌ paiꞌjɨ. Ku baꞌ guꞌ na paiꞌ dhuuk jaꞌbsuñiaꞌ gu tukgaꞌn, pu jimiaꞌ ji jix dhaam jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Gio baꞌ janoꞌ na paiꞌ dhuuk jum aayaꞌ na tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn, guiꞌ nam xib jir gɇꞌgɇrkam jum aaꞌndam, jaꞌppɨx jaꞌtkam ji biꞌyaꞌ am, guꞌ baꞌ guiꞌ nam xib panaas jir jaꞌppɨx jaꞌtkam, bar gɇꞌgɇrkam kaꞌ am janoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Baꞌ nam bhammɨ ba tɨɨsdim nam Jerusaleen jaꞌk ba jiim, bɨɨpɨꞌ jimchuꞌ gu Jesuus, gatuuk dɨr baꞌ muiꞌp jiimchuꞌ am gu jaꞌtkam tugiꞌñ. Miꞌ pɨx pu tuiꞌdhiꞌ am, cham tum ñiokim, jix chotdontuꞌ am, nam guꞌx maat nam bhaiꞌ oꞌbhagiꞌñ. Baꞌx ioꞌm baasɨꞌn jaꞌp xi ja boosgak dɨlhkob dai gu mambhɨɨx daman gook gu noonbiꞌñ ba ja aagiꞌñ nam jax dhoodaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","jup ja tɨtda: ―Ba aajim ich jia Jerusaleen na pim jax ba tɨ nɨiꞌñ. Moo mam ai na paiꞌ dhuuk tu daaxix nam jiñ dhagiaꞌ gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio guiꞌ nam sap jix maat gu ñioꞌkiꞌñ gu Dios, baꞌ ja chiñiaꞌ am nam jiñ muꞌaaꞌ guiꞌ nam cham jir Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Baꞌ guiꞌ jax ñam pɨx jiñ buimɨi, jiñ gɨbiimɨi am, gio nam bhañ xixbuidhimɨi. Jaꞌpnim jiñ buimɨiñ muꞌaaꞌ, ku baꞌ guꞌ aañ baik tanoolh kɨꞌn yaaꞌ ji nañ jax ba oirɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Baꞌ gu Jakoobo gio gu Juan, maamraꞌn gu Sebedeo, moop ba tɨkka am gu Jesuus nam jax ɨlhiiꞌñ, jup tɨtda am: ―Aach tɨi xim tɨkkam jich jaduuñ noꞌp moo cham jax tɨꞌji jich aaꞌñdhaꞌ gɨt nach aach jax jup ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Baꞌ xi ja tɨkka gu Jesuus, jup ja tɨtda: ―¿Jax gi jaꞌk ɨlhiiꞌñ japim jiñ jaaduñ? ¿Tuꞌ pim jix aaꞌ nañ jax dhuñiaꞌ aapiꞌm jam bui? ");
INSERT INTO stpNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Baꞌ guiꞌp kaiꞌch am: ―Dho nach jaꞌp tɨi ɨlhdhat nap bɨxxik dɨr jich dharsaꞌ jum sanoop nap paiꞌ daakaꞌ aap jich jaduuñ, maaꞌn kɨɨꞌn dɨr, jumai baꞌ oꞌnsop dɨr, janoꞌ na paiꞌ dhuuk saak maaxik bax maatɨꞌ kaꞌ nap jix ioꞌm jir gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Baꞌp ja tɨtda gu Jesuus: ―¿Kux ɨlhiiꞌñ japim aa na cham xijaiñ jaaduñ ku pim baꞌ bɨxxik dɨr jix aaꞌ na pim daraibuꞌ jiñ xanop? ¿Katti noꞌ pim guꞌx ñakooꞌ jia na pim tu iꞌyaꞌ gux xibuꞌ nam aañ jax chuꞌm jiñ ichdhaꞌ, gio nam jam bopkonaꞌ kɨꞌn guiꞌ nam aañ jax chuꞌm kɨꞌn jiñ bakuanaꞌ? Jaꞌp jañ kaiꞌñkam jup kaiꞌch nar tulhiiñaraꞌ na pim baꞌ ba maiꞌchiaꞌ na pim jax jix aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Baꞌ guiꞌp kaiꞌch am: ―Jix ñakooꞌ ich dho. Baꞌp ja tɨtda gu Jesuus: ―Dho ea na pim pɨx am tɨ nɨrdaꞌ ku gi nam jam ichdhaꞌ gux xibuꞌ, gio nam jam bopkonaꞌ puiꞌ nam jax jaꞌk jiñ bakuanaꞌ aañ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Guꞌ baꞌ dhiꞌ na pim tuꞌñ chɨkka na pim bɨxxik dɨr jix aaꞌ na pim daraibuꞌ jiñ xanop, maaꞌn kɨɨꞌn dɨr, gio jumai oꞌnsop dɨr, cham maatɨꞌ ji gu xib. Guꞌ janoꞌ ji na paiꞌ dhuuk tum kuugalhdhaꞌ na baꞌ bax maatɨꞌ kaꞌ na jaroiꞌ bhaiꞌ ji ja aagaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Baꞌ gu jaiꞌ gu mambhɨɨx gu noonbiꞌñ gu Jesuus am bhaak jamɨt ja bui gu gook, Jakoobo gio gu Juan, nam ja kɇɇ nam puiꞌ jɨꞌ kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Guꞌ ji nat guꞌ gu Jesuus jotmodaꞌ maap xi ja jumpadak jup ja tɨtda: ―Jax dhui na cham jir am na pim moo kɨꞌn jup bax bhaak na pim jix aagɨt na pim jir gɇꞌgɇrkam kaꞌ. Na guꞌ dhiꞌ jaꞌp pɨx ba ji buusan na jax guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñ, puiꞌ na jax guiꞌ nam jix kakaiꞌ kɨꞌn dadarrɨ, nam dai giilhim gɇꞌgɇrkam jum taat kaꞌ, sia ji guꞌ guiꞌ nam miamdagaꞌn kɨꞌn dadarrɨ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Guꞌ matgam noꞌ pim aapiꞌm jix aaꞌ na pim jir gɇꞌgɇrkam kaꞌ, jum aaꞌ ji na pim soiꞌm duukat ja palhbuiꞌñdhaꞌ gu jaꞌtkam, sia nar jaroiꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","sia pɨk jax kaꞌ gɨt. Noꞌ pɨx maadɨt jix aaꞌ ji gu jaroiꞌ nar gɇꞌkam kaꞌ, jum aaꞌ moo na soiꞌm duukaꞌ gio nar jix bhaiꞌkam kaꞌ, panaas ku moo pu cham jir gɇꞌkam kaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tɨi pɨk aañ nañ jix ioꞌm jir gɇꞌkam, cham paiꞌ iam jax jiñ aaꞌ iñ nañ pɨx am cham ja nɨnɨiꞌñdhaꞌ guiꞌ nam alh gampaiꞌ tuutuꞌm. Na ñich guꞌ cham tuꞌ pu kaiꞌñkam bha jii nañ yaꞌ ɇɇji dai gɇꞌkam bañ chaat kaꞌ, nañ moo pɨx chuꞌ ja tɨtdadaꞌ bɨɨx na jɨꞌk jaꞌtkam nam miꞌ puiꞌ jimiaꞌ nañ jax ɨlhiiꞌñdhaꞌ. Guꞌ jaꞌpji nañ jix ja joiꞌgɨꞌn na ñich baꞌ bhaiꞌ ma jii nañ baꞌ yaꞌ maaxik jiñ kɨɨsaꞌ nam boiñ bhɨichdhaꞌ, na baꞌ tu namkix kaꞌ gu ja uaꞌtulhdharaꞌ buiñor guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Baꞌ bhammɨ ba ai mɨt na paiꞌr kikcham Jerikoo tɨ tɨɨgim, alhiom bhaiꞌ xi oipimɨk. Baꞌ jaꞌxpɨx nat gamaiꞌ ji jii gu Jesuus ja bɨɨm gu noonbiꞌñ gio jaiꞌ muiꞌ gu jaꞌtkam, baasɨꞌn juꞌñdharan nam ba bubuakim, bha jaꞌp daakat tu taan gu tuumiñ maaꞌn gu cham ñia kam Bartimeo tɨɨgim. ");
INSERT INTO stpNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Baꞌ nat ba maat na dhiꞌ gu Jesuus Nasareet kam mu jim, gɇꞌ kɨꞌn ba jiiñak, jup kaiꞌch: ―Aapiꞌ Gɇꞌkam Jesuus nap jir boxiiꞌñ gu Dabii, iam jap xiñ dhuaꞌñdhai noꞌp moo xiñ joiꞌgɨꞌndaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Baꞌ pɨx am bhaak jamɨt gu jaꞌtkam buiñor, jup tɨtda am na sap cham ñiokat daakaꞌ. Guꞌ ji nat guꞌ guiꞌx ioꞌm ba xi jii na gɇꞌ kɨꞌn mu jiiñak, jup kaiꞌch: ―Aapiꞌ nap jir boxiiꞌñ gu Dabii, iam jap xiñ dhuaꞌñdhai noꞌp moo xiñ joiꞌgɨꞌndaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Baꞌ miꞌ pup kɨɨk gu Jesuus nat kai na mu paiꞌ dhɨr bha jiiñkaiꞌñ gu jaroiꞌ, baꞌ mɨjɨ xi chu joot nam baiꞌñxiꞌñpuꞌ. Baꞌ muiꞌp ma boop jamɨt gu jaꞌtkam, jup tɨtda am mu ɇɇk: ―Chaꞌp jax kam aaꞌndaꞌñ jaduuñ. Bha tum joochxi gu Gɇꞌkam nap jaroiꞌ jiiñkaiꞌñ. Xib jach jum nobchɨi mum aichdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Baꞌ guiꞌ jotmodaꞌ nat jax jum tɨiꞌbhioꞌ, mi jaꞌp xi buak gu saꞌuaꞌn kɨkbuk gaꞌm pɨx chuꞌm duu ja bɨɨm guiꞌ nam bha nobchichuꞌ. Bhaiꞌ mɨt ba aich nat paiꞌ dhɨr mu tu joochxi gu Jesuus, ");
INSERT INTO stpNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","baꞌ xi chɨkka gu Jesuus, jup tɨtda: ―¿Tuꞌni aam duuk jiñ jaduuñ nap baꞌ bhañ jiiñkaiꞌñ? Baꞌ guiꞌp kaiꞌch: ―Dho nañ jaꞌp tɨi ɨlhdhat noꞌp moo puiꞌp ɨlhiiꞌñdhaꞌ gɨt nap iam xiñ dhuaꞌñdhai gɨt nañ cham ñia. ");
INSERT INTO stpNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Baꞌp tɨtda gu Jesuus: ―Bax kɨɨꞌ ap ji matgam, nap guꞌ aañ jiñ bui bax biiñak. Chaꞌp jax kam aaꞌndaꞌ. Baꞌ dai nat puiꞌ jɨꞌ xi chɨɨꞌn, bhaiꞌ ji chɨ tɨɨ guiꞌ na cham ñia kat, jix kɨɨꞌ dho guꞌp jum duu. Miꞌ dhɨr baꞌ dai nat ba oi bhammɨ jaꞌk nat paiꞌ ba jii gu Jesuus ja bɨɨm gu jaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Baꞌ bhammɨ ba ai mɨt na paiꞌ Betpajee tɨ tɨɨꞌ, bhaiꞌ na paiꞌ jaꞌp iam Betaania tɨ tɨɨꞌ ɨp, sonpan maaꞌn gu oidhaꞌ nam Oliibus kɨꞌn jix chu mat kaꞌ, nam baꞌ pɨk moo ba aayaꞌ Jerusaleen. Baꞌ bɨɨpɨꞌ mɨjɨ xi ja joot gu Jesuus gook gu noonbiꞌñ, ");
INSERT INTO stpNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","jup ja tɨtda: ―Aañ jaꞌp tɨi kaiꞌchɨt jiñ jaaduñ na pim mu jimiaꞌ muni na paiꞌr kikcham na pim jiñ chɨɨmɨlhdhapuꞌ maaꞌn gu jigiarum bhuruꞌx na chakuir jum ulhisdam. Miꞌ moo bulhkaꞌ na pim jax yaꞌ dɨr mu aajidhaꞌ, dai na pim jax bulhioꞌkai bha tɨɨmɨrikaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Noꞌ moo jaroiꞌ ba jam tɨkka, noꞌ jax jam tɨtda: “¿Jax japim baꞌ duñiaꞌ dhi bhuruꞌx ku pimɨt baꞌ gamaiꞌ ba ji chɨɨmɨrak?”, jaꞌp japim tɨɨdaꞌ: “Bhach joot gu Gɇꞌkam. Tuꞌ chi na mi bhiiñoraꞌ. Ku guꞌ sap gio yaꞌp aichdhaꞌ ji jaꞌxñi.” ");
INSERT INTO stpNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Baꞌ guiꞌ muiꞌ ma jii mɨt, puiꞌ dho ji buus. Nam jax kiaꞌpɨx mu aajim, miꞌ bulh maaꞌn gu bhuruꞌx miaꞌn kiꞌñgob maaꞌn gu baꞌaak. Baꞌ na mɨt jax bulhioꞌ, gaꞌmpɨx chuꞌ dooda mɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Baꞌ jaiꞌ dhɨt nam ja nɨiꞌñ, ba ja tɨkka am, jup ja tɨtda am: ―¿Jax japim baꞌ duñiaꞌ dhi bhuruꞌx ku pimɨt baꞌ gamaiꞌ ba ji chɨɨmɨrak cham ji aaꞌñdhak guiꞌ nar jaroiꞌ gaꞌn? ");
INSERT INTO stpNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Baꞌ guiꞌ dai na mɨt puiꞌ xi ja tɨɨdak nat jax mu ja tɨɨꞌn gu Jesuus nam tɨꞌyaꞌ, baꞌ puiꞌ cham ka ja tɨkka mɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Baꞌ mummu ba aichulh jamɨt. Baꞌ puiꞌ bhaiꞌ bax dhaibum kat gu Jesuus, guꞌ ji na guꞌ gu noonbiꞌñ siamri bhaiꞌ xi bakxi mɨt gu tɇꞌtɇb ja kuktun, guiꞌ nam daam dɨr ja tɨiꞌchuꞌndaꞌ, nat baꞌ bhaiꞌ xi dhaibuk gamaiꞌ ji jii. ");
INSERT INTO stpNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Baꞌ gu jaꞌtkam tugiꞌñ bɨɨpɨꞌ dɨr boopok miꞌ ba tu iabu mɨt gu jaajaꞌ na paiꞌ jax bhɨichuꞌ. Baꞌ gu jaiꞌ muiꞌ jaꞌtkam na mɨt ji ja tɨɨgɨk, pup xiim mi chu iabu mɨt ɨp tu oꞌmsak gu jaajaꞌ, jaiꞌ gu tɇꞌtɇb ja kuktun. ");
INSERT INTO stpNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Baꞌ jaiꞌ bɨɨpɨꞌ jii mɨt jaiꞌ gatuuk dɨr pɨx jiiñak bɨɨt am, jup kaiꞌchim am: ―¡Taxchaab baꞌ guch Gɨꞌkoraꞌ nat bhaiꞌ bach joochxi nach jaroiꞌ nɨɨrat! ");
INSERT INTO stpNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Taxchaab baꞌ guch Gɨꞌkoraꞌ guiꞌ nax dhaam jup tuꞌiiꞌ! Na guꞌ dhiꞌr diꞌ nat yaꞌ ba ai nat bha joot, dhiꞌ yaꞌ bar gɇꞌkam kaꞌ jaꞌp na jax gu Dabii. Iam gɨt baꞌ moo gammɨjɨ bhaan tɨ nɨiꞌñdhaꞌ guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Baꞌ bhaiꞌ ba ai gu Jesuus Jerusaleen. Jimdat mɨjɨmmɨ ji baa gɇꞌ chiop, alhio mɨjɨ jaꞌp xi oilhimɨk bɨɨx xikoolh na tɨ nɨidhim na tuꞌ jax jum bua. Miꞌ dhɨr baꞌ dai nat ba jii Betaania jaꞌk ja bɨɨm gu mambhɨɨx daman gook gu noonbiꞌñ, nat guꞌ pu ba jur. ");
INSERT INTO stpNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Baꞌ buimgidhak na mɨt ba jii miꞌ dhɨr Betaania, Jerusaleen jaꞌk ɨp gio, chi guꞌ am jix bhiogɨm tu tatdaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Baꞌ na naiꞌ gan xi chɨ nɨidhim, ba tɨɨ na mu jaꞌp pɨx kɨɨk maaꞌn gu iigɨx joidham xiboorak jix jaagam, jix iibhaidhaꞌ kam tuꞌiiꞌ. Baꞌ muiꞌ ma jii gu Jesuus nat tɨɨgim, guꞌ ji na guꞌ pu nim maaꞌn ku bha dhaa na bha jaꞌp tɨi xi ñɨnɨiꞌñ, bak guꞌ janoꞌ pɨk cham jup iibhaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Baꞌp tɨtda ja kaixdhat gu noonbiꞌñ: ―¡Alh jap moo cham jɨꞌxkat ka iibhaiꞌñchaꞌ xib dɨr jaꞌp jaꞌk! ");
INSERT INTO stpNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Baꞌ gatuuk na mɨt paiꞌ dhuuk bhammɨ ba ai Jerusaleen, mɨjɨ ji baakɨk gu Jesuus ɨrban dɨr gu gɇꞌ chiop, bɨɨx jaꞌk ja joot mu jaꞌp dɨɨrap guiꞌ nam bhaiꞌ ka tu gaꞌrat gu bɨxchuꞌ, gio guiꞌ nam bhaiꞌ tu sabaꞌn. Gio baꞌ guiꞌ nam bhaiꞌ ja pataaxiꞌñ gu tuumiñ gu jaꞌtkam, ja iaꞌlhxichulh gu ja memees. Gio baꞌ guiꞌ nam bhaiꞌ ka tu gaꞌra gu giokdaꞌ, pu bɨɨx jup ja iaꞌlhxichulh gu ja aꞌtoxkar, mɨjɨ jaꞌp pɨx jaꞌx tu daꞌnsa. ");
INSERT INTO stpNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Gio nat cham ka ja doꞌñcho na jaroiꞌ bɨxchuꞌ tu uaꞌdat mu jaꞌk jimdaꞌ ɨrban dɨr gu gɇꞌ chiop, ");
INSERT INTO stpNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","dai na tu ja aꞌgiꞌñ mi oirɨt, jup ja tɨtda: ―¿Jax ku pim baꞌ yaꞌ pu tu bua? Na pim guꞌx maat gu ñioꞌkiꞌñ gu Dios na miꞌ tu uaꞌñix uꞌuan taꞌm nap jum kaiꞌch: “Dhiꞌ dhi chiop nat miꞌ bam kɨi, miꞌ dhɨr jix bhaaiꞌ nam bha tuñ aꞌgiꞌñdhaꞌ soiꞌm ɨlhdhat bɨɨx na jɨꞌk jaꞌtkam, sia nam jir pa jaꞌk kam.” Jaꞌpni bo nam kaiꞌch, ¿cham maat japim? Aapiꞌm guꞌ ya jaꞌp tu duuk na paiꞌ chiob nam jum jumpaꞌn gu ɨꞌxkum. ");
INSERT INTO stpNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Baꞌ giilhim bhaak jamɨt guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios gio gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios. Maap jim daagɨk ma chu aꞌga mɨt nam jax dhuuji tu chiñiaꞌ nam muꞌaaꞌ, nam guꞌx ɨɨbhidhat jix jɨɨgam, na guꞌ joidham jix bhaiꞌ xi bua na xi chu aꞌga. Miꞌ pɨx puiꞌ ba tuꞌiiꞌ am na jɨꞌk jaꞌtkam, ");
INSERT INTO stpNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","guꞌ ji na guꞌ jaꞌxpɨx nat paiꞌ dhuuk ba tuk, pu jii gu Jesuus miꞌ dhɨr gɇꞌ kiicham. ");
INSERT INTO stpNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Baꞌ buimgidhak jix dhaꞌnpam ji chu maaxirɨk gio muiꞌp ba jiim am Jerusaleen jaꞌk. Ba tɨɨ mɨt nax gak mi kɨɨk gu iigɨx na joidham jix chɨɨduꞌ miꞌ ka kɨɨkat takaab dɨr, bɨɨx chakaaꞌn jix gak. ");
INSERT INTO stpNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Baꞌ ba tɨꞌñchu gu Peegro nat bak pɨn ñiok gu Jesuus, baꞌp tɨtda: ―Kagɨt jiñ jaduuñ nat ba gaa dhi iigɨx na pich ñiok takaab. Attiiru dho moox gak sia gu takaaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Baꞌp ja tɨtda gu Jesuus: ―Dho puꞌñi ku pim jix ioꞌm muiꞌ xim biiñkadaꞌ buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨɨdaꞌ, noꞌ jaroiꞌ jax tɨtda dhi oidhaꞌ: “Jaꞌk jim yaꞌ dɨr, mup jimiaꞌ na paiꞌ gɇꞌ suuꞌn gu suudaiꞌ”, noꞌ moo jaꞌp tuꞌ sɨlhkam jix biiñak bɨɨx juraaꞌn kɨꞌn, noꞌ moo pɨx pum aaꞌ nar puiꞌ kaꞌ na jax tɨꞌyaꞌ, puiꞌ dho ji chu buusniaꞌ, kux baꞌ cham ɨp. ");
INSERT INTO stpNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Aañ moo jam aagiꞌñ noꞌ pim tuꞌ yaꞌ dɨr mu taan guñ Gɨꞌkoraꞌ jix dhaam jaꞌk soiꞌm ɨlhdhat, noꞌ pim moo pɨx pum aaꞌ nar puiꞌ kaꞌ na pim jax tɨɨdaꞌ, puiꞌ dho ji buusniaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Baꞌ na pim paiꞌ dhuuk tu aꞌgadaꞌ jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ, noꞌ pim ampɨk tɨꞌñchu na pim jix bhaamut nɨiꞌñ gu jaroiꞌ, chaꞌpim bhaamut ka tɨꞌñchukaꞌ, tu uañiꞌñkaꞌ pim pɨx na baꞌ guñ Gɨꞌkoraꞌ puiꞌp tu jam uañiꞌñkaꞌ gu jam uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Na guꞌ noꞌ pim aapiꞌm daix bhaamut nɨidhat tɨꞌñchu gu jaroiꞌ, noꞌ pim cham tu uañiꞌñ, guñ Gɨꞌkoraꞌ nax dhaam jup tuꞌiiꞌ puiꞌ cham jup tu jam uañiꞌñkaꞌ gu jam uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Baꞌ gio miꞌp ba ai mɨt Jerusaleen. Baꞌ na mɨjɨ jaꞌp ka oirɨ gu Jesuus gɇꞌ chiop, miꞌ ba ai mɨt gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, gio jaiꞌ guiꞌ nam jir ja gɇꞌgɇrkam tuk kaꞌ gu Israel kam jaꞌtkam. Baꞌ mi jaꞌp sooꞌmdhak ");
INSERT INTO stpNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ba tɨkka am, jup tɨtda am: ―¿Jax jap baꞌ kaiꞌñkam yaꞌ pu tu bua? ¿Jaroom chianɨk bham joot nap yaꞌ pu tu doodaꞌ nap jax ɨlhiiꞌñ? ");
INSERT INTO stpNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Baꞌp ja tɨtda gu Jesuus: ―Dho bak aañ maaꞌn jup jam tɨkkaꞌ gu tuꞌx buadam na jax jir jum duukam, noꞌ pim moox maat na pim jiñ aagiꞌñdhaꞌ nañ baꞌ aañ jup jam aagiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Jaroo bha jootsak gu Juan nat ja bopko gu jaꞌtkam? ¿Dios aa, kaꞌ dɨɨlh aa mɨt chia gu jaꞌtkam? Ea gor xiñ aagiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Baꞌ dai na mɨt ba jim tɨ tɨkka dɨɨlh, jup kaiꞌch am: ―¿Jax jaꞌk jach tɨɨdaꞌ? Na guꞌ noꞌch jax tɨtda nat Dios bha joot, puiꞌ ji chɨꞌyaꞌ: “¿Gi jax ji na pimɨt baꞌ cham tɨ jɨɨꞌñ na jax tɨi tu jam aꞌgidhimɨk?” ");
INSERT INTO stpNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Cham dho bhaiꞌ jia noꞌ chich puiꞌ jaꞌk tɨɨꞌn. Na guꞌ noꞌch jax jup tɨtda na mɨt dɨɨlh chia gu jaꞌtkam, puiꞌ cham jup jir am. Cham aaꞌ am nam tu aagaꞌ, nam guꞌx bhaiꞌx maat nam muiꞌ jaꞌtkam tɨ jɨɨgiꞌñ na gu Juan bhaankam tu aꞌgimɨk gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Miꞌ puiꞌ cham ka bhaiꞌ nam jax tɨꞌyaꞌ, dai na mɨt jup xi chɨɨdak gu Jesuus: ―Cham ji nach maat nat jaroiꞌ bha joot gu Juan. Baꞌp ja tɨtda gu Jesuus: ―Dho bak guꞌ aañ puiꞌ cham jup jam aagiꞌñdhaꞌ nat jaroiꞌ bhañ joot. ");
INSERT INTO stpNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Miꞌ dhɨr baꞌ gio bhaiꞌp ji chu ja aꞌgi gu Jesuus bhaan ji uaꞌrgidhak maaꞌn gu ɨꞌxchadam, jup ja tɨtda: ―Maaꞌn gu maaꞌnkam tu darsak gu uubas, gio baꞌ nat tu kuu miꞌ nat jɨꞌx juugɨt tu darai. Miꞌ dhɨr baꞌ moop tɨ kɨɨꞌmpi na paiꞌx bhaaiꞌn kaꞌ nam ba kɨiꞌñdhaꞌ, gio baꞌ nat mi kɨi maaꞌn gu tɇb bhiꞌñbak na baꞌ bhaiꞌ dhɨr bhaan naiꞌ tɨ nɨiꞌñdhaꞌ na tu nuukaꞌndaꞌ. Guꞌ ji na guꞌ moo ampɨk jup bar jimdam mɨk jaꞌk, baꞌ miꞌ xi ja doꞌñchok jɨꞌkchi gu jaꞌtkam nam miꞌ ka tu juandaꞌ, pu jii baꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","’Baꞌ nat paiꞌ dhuuk ba bhai gu uubas, muiꞌ tɨi joot maaꞌn gu tujuandam tugiꞌñ miꞌ nat paiꞌ ka xi ja doꞌñchok gu jaiꞌ tujuandam tugiꞌñ, na sap mu uaꞌraꞌ guiꞌ na jɨꞌk bhaan bipioꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Guꞌ ji na guꞌ nat jax miꞌ ai, dai na mɨt bhaiꞌ ji dhaa guiꞌ nam miꞌ tu juan, gɨbichpagak puiꞌ mɨjɨ xi joot jamɨt ɨp gio. ");
INSERT INTO stpNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jumai baꞌ muiꞌp joot. Dho gi baꞌ joodai kɨꞌn maꞌyasa mɨt ji, giilhim koꞌktolh jamɨt gu maꞌooꞌn, gio nam bɨɨx aixim tɨtdaimɨk nam jax ɨlhiiꞌñ, puiꞌ mɨt mɨjɨp xi joot. ");
INSERT INTO stpNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Baꞌ jumai muiꞌ tɨip joot. Dho gi baꞌ pu mua mɨt ji. Jaiꞌ baꞌ muiꞌ tɨip ja joot gatuuk. Puiꞌ mɨt jup ja dooda, jaiꞌ mɨt ja koꞌktolh pɨx, jaiꞌ mɨt pu ja koi. ");
INSERT INTO stpNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Baꞌ mɨkkat na cham jaroiꞌ ka jaiꞌch na mu jootsaꞌ, dai gu maraaꞌn pɨx ba bii guiꞌ nax ioꞌm jix dhaꞌdaꞌ, puiꞌ muiꞌp ma joot jup xi chɨꞌɨɨk: “Dhiꞌ dho gi guꞌ jɨɨꞌñdhaꞌ am ji, nam guꞌx maat na aañ jir jiñ mar.” ");
INSERT INTO stpNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Guꞌ ji na guꞌ nat paiꞌ dhuuk tɨi miꞌ ba ai, jup kaiꞌch am dɨɨlh jix dhuꞌnpiꞌñ kɨꞌn gu tujuandam: “Dhiꞌ moo bhaan ji chu biꞌyaꞌ bɨɨx gu tuꞌ na jɨꞌk yaꞌx chu jaiꞌch noꞌt ba muu gu taataꞌn. Jir am nach muꞌaaꞌ, kapbhaiꞌ nat dɨɨlh yaꞌ ka ai na baꞌ aach jich aꞌm ji chu biꞌyaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Baꞌ puiꞌ xi chɨꞌɨɨk bhaiꞌ ji dhaa mɨt, pu mua mɨt dho, baas dɨr jaꞌp koraar bɨɨbhiꞌ mɨt xi buak. ");
INSERT INTO stpNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Baꞌ nat paiꞌ xi chɨɨmuk na puꞌñi xi chu ja aꞌgidhimɨk gu Jesuus, baꞌ moop xi ja tɨkka, jup ja tɨtda: ―¿Jax japim baꞌ ɨlhiiꞌñ na ja doodaꞌ gu kiokam? ¿Cham aa na miꞌ ɇɇji puiꞌp ja koodaꞌ, jaiꞌ baꞌ mi ja iabuꞌ gu tujuandam? ");
INSERT INTO stpNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Kux cham tu jiñkaiꞌñdhaꞌ pim aa gu ñioꞌkiꞌñ gu Dios mi uꞌuan taꞌm? Nap jum kaiꞌch: Gu jodai na mɨt tɨi maiꞌ xi buak gu bhibhiꞌñbakchadam, xib dhiꞌ pɨk bhaan jix ooꞌ bɨɨx gu jaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Baꞌx bhaiꞌch chaat ich nat puiꞌ jɨꞌ tu duu guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Baꞌ tɨix dhaagik am gu Jesuus gu gɇꞌgɇrkam jum aaꞌndam, nam guꞌx maat na dhiꞌ ja aagɨt jup kaiꞌch nat tu aꞌga bhaan ji uaꞌrgidhak gu ɨꞌxchadam. Guꞌ ji nam guꞌx ja ɨɨbhiꞌñ gu muiꞌ jaꞌtkam, puiꞌ cham juan am, dai na mɨt ma jii pɨx. ");
INSERT INTO stpNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Baꞌ mɨkkat gu gɇꞌgɇrkam jum aaꞌndam mu joochxi mɨt gu Jesuus jɨꞌkchi guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ gio jɨꞌkchi ɨp gu Eroodis gu jaꞌtkam tugiꞌñ nam sap tɨkkapuꞌ, sap baꞌ noꞌt moo jax ji chɨi na cham jir am gu tuꞌ nam tɨkkaꞌ, bax bhaaiꞌn kaꞌ nam jax dhuuji iattulhdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Baꞌ mu ɇɇk jup tɨtda am: ―Aach bhaiꞌ ma jiich jaduuñ nap jich aagiꞌñdhaꞌ noꞌr am nach aach jax ɨlhiiꞌñ, nach guꞌx maat nap aap sɨlhkam jup kaiꞌchdhaꞌ nap paiꞌ dhuuk tu aꞌgadaꞌ, gio nap cham jax tɨ ɨlhiiꞌñ sia kum giilhim jum aꞌga, nap guꞌ bhaankam tu aꞌga na jax jix aaꞌ gu Dios, cham tuꞌ nam jax jaꞌk ɨlhiiꞌñ gu jaꞌtkam. Tɨɨꞌ nap guꞌ moo cham jaroiꞌ ɨɨbhiꞌñ, sia ku tɨir gɇꞌkam. Baꞌ jaꞌp tuꞌm jachich bham tɨkkam: ¿Jir am aa nach namkiꞌñdhaꞌ gux ioꞌm gɇꞌkam Rooma kam Seesar tɨɨgim guiꞌ na jɨꞌk aagix nach tu namkiꞌñdhaꞌ, kaꞌ cham aa? Dhiꞌ pɨx kɨꞌn jachich moo bhaiꞌ xi jii, noꞌr am nach namkiꞌñdhaꞌ piam ku guꞌ cham. ");
INSERT INTO stpNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Guꞌ ji na guꞌx bhaiꞌx maat gu Jesuus nam cham miꞌ puiꞌ jiimchuꞌ nam jax tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam. Baꞌp ja tɨtda: ―¿Jax ku baꞌ jaꞌp moo jam koꞌraar aapiꞌm na pim iatdaꞌ? Ea gor maaꞌn bhɨibup gu tuumiñ nañ xi chɨgiaꞌ na jax jir tuꞌm daꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Baꞌ maaꞌn bhɨiꞌñpuk miꞌ xi maa mɨt. Baꞌ miꞌ xi chɨɨgɨk jup ja tɨtda: ―¿Jaroo daꞌ dhiꞌ na yaꞌ jupñix? Baꞌ guiꞌp kaiꞌch am: ―Dho gu Seesar gux ioꞌm gɇꞌkam Rooma kam. Baꞌp ja tɨtda ɨp gio: ―Dhiꞌ gi na yaꞌ tu uaꞌñix, ¿jax jum kaiꞌch? Baꞌ guiꞌp kaiꞌch am ɨp gio: ―Dho dhiꞌ na jax chɨɨꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Baꞌp ja tɨtda: ―Dho pim xi maakidhat ku gi gu Seesar na puiꞌr jam gɇꞌkam tuk na jɨꞌk bhaan bipioꞌdaꞌ, gio gu Dios japim jup xi maakidhat na jɨꞌk bhaan jup bipioꞌdaꞌ. Baꞌ miꞌ puiꞌ pup tuꞌiiꞌ am nat puiꞌ jɨꞌ xi ja tɨɨꞌn, na guꞌ joidham jix bhaiꞌ xi bua na xi chu aꞌga. Cham jaroiꞌ puiꞌ kɇɇkɇt am. ");
INSERT INTO stpNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Baꞌ moo miꞌp ba ai mɨt jɨꞌkchi guiꞌ nam saduseos jum tɨɨtɨꞌndaꞌ, nam cham tɨ jɨɨgiꞌñdhaꞌ noꞌr sɨlhkam nam gio mu paiꞌp ba oipodaꞌ guiꞌ na ba jaꞌbsuñiaꞌ gu ja tutkuꞌ. Baꞌ bhaiꞌ ji chu aꞌgi mɨt gu Jesuus, jup tɨtda am: ");
INSERT INTO stpNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Aach bhaiꞌ ma jiich jaduuñ na chich bham tɨkkam jaꞌp tuꞌm na cham jir jich jujur. Nach guꞌ aach miꞌ puiꞌ tu daaꞌñchuꞌ nat jax tu uaꞌnak gu Moisees na sap noꞌt maaꞌn ba muu gu maaꞌnkam, noꞌt dɨɨlh miꞌ ji bii gu bɨngaꞌn, noꞌ cham maaꞌn bhaan tu mar kat, jix bhaiꞌ na bhaiꞌ ji bhɨɨyaꞌ gu sɨpdhiꞌñ na miaꞌn oiꞌñdhaꞌ na baꞌ bhaan ba tu mar kaꞌ, na baꞌ jaꞌp ji buusniaꞌ nar diꞌ kaꞌ gu xioꞌgiꞌñ na mukiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Guꞌ ji nam guꞌ moo jaꞌpnip tu aꞌgadaꞌ gu jaꞌtkam, sap mu paiꞌ oiꞌñkat am xijum gook gu jaꞌtkam daim sɨspidhim. Sap baꞌ tɨi ba tɨ bɨɨnaꞌ kat guiꞌ nar bɨɨpɨꞌ kam, guꞌ ji nat guꞌ sap am xi muu, pu cham sap maaꞌn bhaan tu mar kat gu ubii. ");
INSERT INTO stpNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sap baꞌ gu sɨpdhiꞌñ na miaꞌn oiꞌñ ɨp guiꞌ nat ba muu, tɨix bhaiꞌ ba tɨɨdak ɨp gu nuuchixiꞌñ, guꞌ ji nat guꞌ sap puiꞌ am jup xi muu, puiꞌ sap cham maaꞌn jup tɨɨgɨk jamɨt gu alhii. Gio gu tɨꞌɨrab kam sap mɨjɨ dɨr tɨip jimɨɨ, bhaiꞌ sap tɨix bhaiꞌp ji chɨɨꞌn, puiꞌ sap pɨx jup jum duu. ");
INSERT INTO stpNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bɨɨx sap pu koi mɨt gu xijum gook tɨi pɨk bhɨbhɨimɨk, pu cham dho sap moo maadɨt bhaan tɨɨgɨk gu alhii. Mɨkkat sap puiꞌ am jup xi muu gu ubii. ");
INSERT INTO stpNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Guꞌ baꞌ jax chuꞌm pɨk gio bhaiꞌp ji bhɨɨyaꞌ janoꞌ nam saak paiꞌ dhuuk gio mu paiꞌp ba oipodaꞌ, sia kut tɨi bam jaꞌbsu gu ja tutkuꞌ? Jaiñ nam guꞌ puiꞌr xijum gook jaꞌtkam kat. ");
INSERT INTO stpNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Baꞌp ja tɨtda gu Jesuus: ―¿Jix maat japim aa na pim paiꞌ jax chuꞌt jup kaiꞌch? ¿Kux guꞌ ɨlhiiꞌñ japim aa na puiꞌ kaiꞌñkam jup jum kaiꞌch gu ñioꞌkiꞌñ gu Dios miꞌ na paiꞌ tu uaꞌñix? Cham tuꞌr puiꞌ ɨp ji siamri. Guꞌ matgam gu Dios tuꞌ na pɨx jix aichuꞌn ji, guꞌ ji na pim guꞌ aapiꞌm cham maat. ");
INSERT INTO stpNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Na guꞌ guiꞌ nat jɨꞌk bam jaꞌbsu gu ja tutkuꞌ, cham tuꞌ bhaan ka tɨtɨɨꞌñchukaꞌ am gu puiꞌ jaꞌk janoꞌ nam paiꞌ dhuuk gio maakam jaꞌk jup ba oipodaꞌ, nam paiꞌ chakui tu mat kaꞌ gu xib. Nam guꞌ jaꞌp ji buusandaꞌ na jax gu noonbiꞌñ gu Dios nam bhammɨp tuꞌiiꞌ jix dhaam, cham tuꞌ nam jup kax aaꞌndaꞌ nam tɨ bɨpnaꞌ kaꞌ na jax yaꞌ maaxik. ");
INSERT INTO stpNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Guꞌ dhiꞌ na pim jax jaꞌk tɨi xi ɨlhiiꞌñ na pim cham tɨ jɨɨgiꞌñ nam maakam jaꞌk ba oipodaꞌ, cham tuꞌr puiꞌ ji, na guꞌ dɨɨlh pɨx na pim puiꞌm aaꞌ, cham paiꞌ puiꞌ tu uaꞌñix. ¿Kux cham jɨꞌxkat tu jiñkaiꞌñ japim aa mi uꞌuan taꞌm nat paiꞌ tu uaꞌna gu Moisees janoꞌ nat paiꞌ dhuuk bha ñioꞌkdhak gu Dios? Nap tɨtda bhaan jim uaꞌrgidhak gux bii uꞌux: “Aañ jir diꞌ pɨx gu Dios nam jax jiñ bui bax biiñak gu jam bopxi kat Abraam, gio gu Isaak, gio baꞌ gu Jakob.” Jaꞌpni bo nam kaiꞌch, ¿moo cham jup tɨꞌñchu pim? ");
INSERT INTO stpNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jaꞌp jum aaꞌ pim na cham tuꞌ bhaan ka tɨ nɨidhidhaꞌ gu Dios gu jaꞌtkam noꞌt bam jaꞌbsu gu ja tutkuꞌ. Matgam jir maaꞌn ji na jax ja aꞌm tɨ nɨidhidhaꞌ, na guꞌ puiꞌ nam jax buiñor bax biiñaktuꞌndaꞌ na jax maaxik nam yaꞌ oipodaꞌ. Jaꞌp dho moo cham maat japim na pim paiꞌ jax chuꞌt jup kaiꞌch, ni palhɨɨp ku iam jir puiꞌ na pim jax tɨi xi ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Baꞌ maaꞌn guiꞌ na sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios mi jaꞌp kɨɨkat jup tɇ kɇɇ nam jax kaiꞌch, baꞌ joidham kai puiꞌ na jax jaꞌk tu aꞌga gu Jesuus. Baꞌx ioꞌm miaꞌn xi kɨkbuk xi chɨkka, jup tɨtda: ―¿Jax baꞌ tuꞌm pɨk jix ioꞌm jum aaꞌ nañ miꞌ puiꞌ jimdaꞌ na jax jix aaꞌ guch Gɨꞌkoraꞌ na jax tu uaꞌñix mi uꞌuan taꞌm? ");
INSERT INTO stpNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Baꞌp tɨtda gu Jesuus: ―¿Na jax chuꞌm jix ioꞌm jum aaꞌ aa na jɨꞌk miꞌ tu uaꞌñix? Guiꞌ dho na jaꞌpnim kaiꞌch: “Gor xi chɨ kai Israel kam jaꞌtkam, maaꞌn pɨx jix jaiꞌch gu Dios nax ioꞌm jir gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tu daandaꞌ pim bɨɨx jam jujur kɨꞌn jix dhaam jaꞌk na paiꞌp tuꞌiiꞌ, gio bɨɨx na jɨꞌx jam iꞌiiꞌmdaꞌ kɨꞌn. Dai guiꞌ pim pɨx tɨꞌñchukaꞌ gammɨjɨ, muiꞌ pim xim biiñkadaꞌ na pim jɨꞌx pup jum taat.” Dhiꞌ jaꞌpni moo bɨɨpɨꞌ kat jum aaꞌ nam tuiꞌñgɨdaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gio baꞌ gu jumai na iampɨx puiꞌ jaꞌk jup tu uaꞌñix nap jum kaiꞌch: “Moo pim xim gaꞌngadaꞌ na tuꞌ ja aꞌm jum aaꞌndaꞌ gu jaiꞌ, panaas ku moo aapiꞌm jam aꞌm jum aaꞌndaꞌ.” Jaꞌpni jaꞌk jum kaiꞌch. Dhiꞌ jɨꞌ dhi gook na jax jum kaiꞌch moox ioꞌm jum aaꞌ, sia pɨk jax kaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Baꞌp kaiꞌch guiꞌ na sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios: ―Umri moor puiꞌ nap jax kaiꞌch jiñ jaduuñ na maaꞌn pɨx jix jaiꞌch gu Dios nax ioꞌm jir gɇꞌkam, cham tuꞌ jumaip jix jaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jir am dho nach tu daandaꞌ bɨɨx jich jujur kɨꞌn na jɨꞌk jaꞌtkam jix dhaam jaꞌk, gio bɨɨx na jɨꞌx jich iꞌiiꞌmdaꞌ kɨꞌn. Dai guiꞌch pɨx tɨꞌñchukaꞌ gammɨjɨ, gio nach muiꞌ xich biiñkadaꞌ nach jɨꞌx pup jich chaat. Gio nach xich gaꞌngadaꞌ na tuꞌ ja aꞌm jum aaꞌndaꞌ gu jaiꞌ, panaas ku moo aach jich aꞌm jum aaꞌndaꞌ. Moo dho guꞌx ioꞌm jix bhaiꞌ ji busaak gu puiꞌ jaꞌk, guiꞌ bak guꞌ cham pɨk tuꞌ bhaiꞌ ji nañ mu paiꞌ tu makgɨrtat tɨ tɨkkadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Baꞌ gu Jesuus na guꞌx maat na iampɨx miꞌ puiꞌ jimchuꞌ na jax tu uaꞌñix, baꞌ muiꞌ xi guguux, jup tɨtda: ―Alhiꞌch pɨx bam aagɨt jiñ jaduuñ nap buiñor bap tuiꞌkaꞌ gu Dios na baꞌ gammɨjɨ jum aꞌm ba tɨ nɨiꞌñdhaꞌ. Miꞌ puiꞌ cham jaroiꞌ tuꞌ ka tɨkkaꞌn, nam guꞌ bax xiꞌɨrgiꞌñ, na guꞌx ioꞌm jix matdaꞌ na jax jaꞌk tɨꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Baꞌ gio bhaiꞌp ji chu ja aꞌgi gu Jesuus gu jaꞌtkam pu miꞌ puiꞌ ɨrban dɨr gu gɇꞌ chiop, xi ja tɨkkaꞌn na sap jax jir jum duukam na baꞌ puiꞌ Dabii jir boxiꞌñ. Jup ja tɨtda: ―¿Jax kum baꞌp kaiꞌchdhaꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios na guch Xoiꞌkam Dabii jir boxiꞌñ? ");
INSERT INTO stpNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","¿Guꞌ jax ku baꞌ gu Dabii puiꞌp kaiꞌch nax ioꞌm jir gɇꞌkam guch Xoiꞌkam? Jaꞌpni bo nat tu uaꞌna janoꞌ nat paiꞌ dhuuk puiꞌ jaꞌk jurtuda gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ, nap jum kaiꞌch: Jup tɨtda gu Dios guñ Gɇꞌkam tuk guiꞌ nar jich Xoiꞌkam: “Yaꞌniñ xanoop jap xi dhaibuꞌ nañ aañ ka xi ja tulhiiñchudaꞌ guiꞌ nam xim bhaamkiꞌñ nam baꞌ soiꞌm ɨlhdhaꞌ aap jum bui.” ");
INSERT INTO stpNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Guꞌ jax jam baꞌ duukat puiꞌ jaꞌk iimchuꞌn na puiꞌr boxiiꞌñ, na baꞌ guꞌ gu Dabii jup kaiꞌch nar Gɇꞌkam tugiꞌñ guch Xoiꞌkam? Alh iam tɨix xiꞌɨr am guiꞌ nam miꞌ gɇꞌgɇrkam jum taat, nam guꞌ janoꞌ muiꞌ jaꞌtkam miꞌp tuꞌiiꞌ nam kɇɇ na joidham tu aꞌga gu Jesuus. Baꞌ pu cham ka bhaaiꞌ nam jax tɨɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Miꞌ dhɨr baꞌ maakam bhaiꞌp ji chu ja aꞌgi gu Jesuus, jup ja tɨtda: ―Moo pim cham ja kɇkɇɇdat guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, na guꞌ jaꞌp moo ja koꞌraardaꞌ bo nam naiꞌ jiimdaꞌ tɇꞌtɇb ji chɨm tɨiꞌdhat nam sap baꞌ gɇꞌgɇrkam ja ɨlhiiꞌñdhaꞌ gu jaꞌtkam. Gio nam jix aaꞌndaꞌ nam tuꞌ kaꞌm ja nɨiꞌñdhaꞌ, jum aaꞌndaꞌ sap na xi kuanai gu bonmaꞌn na ja ñioꞌkdhaꞌ gu jaroiꞌ mu jaꞌp nam jax jiimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Gio nam jix joiꞌñdhaꞌ nam jaꞌxbuiꞌ puiꞌp xim taat kaꞌ na jax gu gɇꞌgɇrkam jum aaꞌndam. Jaiꞌ mɨjɨmmɨp xi dharkaꞌ am nam paiꞌ darkaꞌ mu jaꞌp nam paiꞌ jax tu daandaꞌ gu Israel kam jaꞌtkam, piam paiꞌ nam jax tu piastatdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Gio baꞌ nam jix joiꞌñ nam ja iatgidhat ja boosgiꞌñdhaꞌ gu ja bɨxchuꞌ gu uꞌuub dɨꞌdɨlhdhɨm. Miꞌ dhɨr baꞌ mɨk tu ñiokidhaꞌ am nam paiꞌ dhuuk ba ji chu nokiaꞌ, na baꞌ jax dhui cham maatɨꞌ kaꞌ nam tuꞌ jax buadaꞌ. Ku guꞌ dhiꞌ kam tulhiiñaꞌ am ji jaꞌp jix ioꞌm janoꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ nam baꞌ miꞌ xi aayaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Baꞌ jaꞌxpɨx mɨjɨ daakat gɇꞌ chiop jup ba ja nɨiꞌñ gu Jesuus gu jaꞌtkam nam pɨx miꞌ ji chuꞌaim gu tuumiñ na paiꞌm tuaꞌba. Jaiꞌ moo muiꞌ mi chuꞌaim am, nam guꞌr jix chutumñigam. ");
INSERT INTO stpNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Baꞌ moo miꞌp ba ai maaꞌn gu ubii na cham jir tu biaꞌkam kaꞌ gio nat muu gu bɨngaꞌn, baꞌ miꞌp xi chua gook gu tuumiñ na cham pɨk tuꞌ bhaigɨm tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Baꞌ gu Jesuus maap xi ja jumpadak gu noonbiꞌñ, jup ja tɨtda: ―Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨɨdaꞌ, dhi ubii na cham jir jix chumñigam nat gook pɨx mi chua gu tuumiñ, jaꞌp ji buusan nat jix ioꞌm muiꞌ mi chua, nat guꞌ soiꞌm ɨlhdhak mi chua. Guꞌ baꞌ gu jaiꞌ na mɨt panaas muiꞌ miꞌ tɨi xi chua, pur cham tuꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","na guꞌ guiꞌ na jɨꞌk cham ja aꞌm kam aaꞌ nam baꞌ mi chuꞌaim. Guꞌ gu ubii bɨɨx miꞌ pu tua na jɨꞌk uaꞌdat, sia ku guꞌ daipuꞌ biaꞌkat na kɨꞌn ka tu sabaꞌdaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Baꞌ jaꞌxpɨx nat ba buus gu Jesuus mɨjɨ dɨr gɇꞌ chiop, jup tɨtda maadɨt gu nobiiꞌñ: ―¡Kagɨt na jax joidham tuꞌm dhi bhiꞌñbak jiñ jaduuñ! Jupaaban sobkoñxim gu joodai bha bhiꞌñbakchix. ");
INSERT INTO stpNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Baꞌp tɨtda gu Jesuus: ―Yaꞌ dho puiꞌ ka tuꞌiiꞌ gu xib nap nɨiꞌñ. Ku guꞌ dhiꞌ kam aayaꞌ ji na paiꞌ dhuuk jum iaraꞌ, pu cham paiꞌ maaꞌn kap tukdhixim biꞌyaꞌ gu joodai. ");
INSERT INTO stpNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Miꞌ dhɨr baꞌ pu jii mɨt amuub baasɨꞌn dɨr jaꞌp oidhaꞌ taꞌm nam Oliibus kɨꞌn jix chu mat kaꞌ, na sɨlh jix chu maax bhaiꞌ dhɨr gɇꞌ chiop. Baꞌ gu Jesuus bhammɨ tɨsdɨk mi jaꞌp ji dhaibu. Baꞌ gu Peegro gio gu Jakoobo gio gu Juan gio baꞌ gu Anrees, muiꞌ ji ai mɨt mu na paiꞌ daa, baꞌ ba tɨkka am jix dhuꞌnpiꞌñ kɨꞌn, ");
INSERT INTO stpNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","jup tɨtda am: ―Aach jaꞌp tuꞌm tɨix maachim jich jaduuñ noꞌp moo cham jax ji chɨꞌjich aagiꞌñdhaꞌ gɨt. ¿Paa baꞌ duuk puiꞌm iaraꞌ saak guꞌñi gɇꞌ chiop nap jax ba kaiꞌch bɨɨpɨꞌ? ¿Jax jaꞌk ba tum buidhaꞌ na bhaan jix maatɨꞌ kaꞌ na bar miaꞌn nam iaraꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Baꞌp ja tɨtda gu Jesuus: ―Dho dai na pim tɨ nɨidhat oipodaꞌ na cham jaroiꞌ jam iatgidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nam guꞌ muiꞌ yaꞌ aayaꞌ nam puiꞌ ja tɨtdaidhaꞌ gu jaꞌtkam nam aañ jir guiꞌ kaꞌ, jup kaiꞌchidhaꞌ am: “Aañ jir diꞌ guch Xoiꞌkam.” Baꞌ giilhim muiꞌ ja iatgidhaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Guꞌ noꞌ moo bar miaꞌn, puiꞌ ba tɨ kaayaꞌ pim ji na jɨgialhchaꞌ miꞌ paiꞌ na pim jup tuiꞌkaꞌ piam maakam jaꞌk. Ku baꞌ guꞌ aapiꞌm cham jax jum aaꞌndaꞌ ji, na guꞌ dhiꞌ puiꞌ ji chu buusniaꞌ sia pɨk jax kaꞌ gɨt, giilhim jix buam tum buidhaꞌ, ku guꞌ chakuir dhiꞌ kaꞌ ji na paiꞌ dhuuk pɨk tum kuugalhdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bɨɨx aixim ka xi chum duñiaꞌ ji matgam. Bhaiꞌ ji bhaakuꞌ am gu jaꞌtkam gɇꞌgɇr kikcham dɨr ja bui gu jaiꞌ na puiꞌp jir gɇꞌgɇr kikcham kaꞌ, jum kokdaꞌ am, jum mamaꞌyasaꞌ am. Gio na joñiaꞌ dhi oiꞌñgaꞌn muiꞌ kap, gio baꞌ na bhiogiꞌ jimiaꞌ. Ku guꞌ dhiꞌ na bhaan pɨx ba pup xi chum tulhiiñdhaꞌ ji, na bhaan jix maatɨꞌ kaꞌ na ba tum kuugalhdhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Jaꞌpni baꞌ moop ja tɨtda: ―Moo pim cham jum oꞌjolhdhat tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui. Nam guꞌ jam daꞌngɨi jam uꞌji jam gɨɨꞌbiaꞌ gu tutpilh mu jaꞌp nam paiꞌ jax tu chichiopiꞌ kaꞌ. Gio nam mu jam uiꞌkaꞌ nam paiꞌ darkaꞌ gux kakaiꞌ gio jaiꞌ ja bui gu gɇꞌgɇrkam jum aaꞌndam, miꞌm baꞌ bhaiꞌ ji jam tɨkkaꞌ noꞌr sɨlhkam na pim tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Baꞌ nam paiꞌ bɨɨx ka xi kaayaꞌ na jɨꞌk jaꞌtkam yaꞌ dhi oiꞌñgaꞌn gux bhaiꞌm kaiꞌchdham ñioꞌkiꞌñ gu Dios na baꞌ pɨk moo ba tum kuugalhdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Baꞌ na pim paiꞌ dhuuk mu suulhgiaꞌ nam paiꞌ darkaꞌ gu gɇꞌgɇrkam jum aaꞌndam, chaꞌpim jax jum aaꞌndaꞌ na panaas ku cham ka bhaaiꞌn kaꞌ na pim jax tɨꞌyaꞌ, ni ku pim jax jum aaꞌndaꞌ: “¿Jax jañ baꞌ jaꞌk tɨꞌyaꞌ chi?” Matgam dɨɨlh pɨx yaꞌ dɨr jaꞌp ji buusniaꞌ ji gu ñiꞌook, na guꞌ jam aꞌm jup tuiꞌñgɨdaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ. Guiꞌ pɨx jup tu duiñchuꞌndaꞌ, cham tuꞌ aapiꞌm dɨɨlh, panaas ku guiꞌ pɨk tu aꞌgidhaꞌ, na guꞌ jam maakidhaꞌ gu matdaꞌ na paiꞌ dhuuk ba xi chum aagidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jaꞌp na paiꞌ jigialhiꞌ chɨr jup tum tuiꞌkaꞌ dho guꞌ panaas, na guꞌ bɨɨx pɨx jix chum bhaak kaꞌ guiꞌ nam jɨꞌk cham tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui. Dɨɨlh jum iꞌiattulhdhaꞌ am gu jaꞌtkam siam sɨspidhim, jaiꞌ gu ja maamar nam bhaiꞌ ji ja bhaamkidhai ja iattulhdhaꞌ noꞌm ba tɨ jɨɨgiꞌñ aañ jiñ bui, jaiꞌ gu ja tataat nam ja iattulhdhaꞌ nam baꞌx bhaiꞌ ja bhɨɨyaꞌ gu gɇꞌgɇrkam jum aaꞌndam nam ja koodaꞌ noꞌm xi ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bɨɨx na jɨꞌk jaꞌtkam guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñdhaꞌ, cham ja kaim kaꞌ am gio nam cham ja nɨidham kaꞌ guiꞌ nam jɨꞌk ba tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui. Ku baꞌ guꞌ gu jaroiꞌ na cham jim oꞌjolhdhat gammɨjɨ tɨ jɨɨgiꞌñdhaꞌ, cham jax bua ji sia mɨt ma mua, na guꞌx dhaam jaꞌk bhɨɨyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Jaꞌpni moop tum duñiaꞌ nat jax tu uaꞌnak gu Danial, guiꞌ na bɨjɨk ya jaꞌp bhaankam tu aꞌgimɨk guñ Gɨꞌkoraꞌ, nap jum kaiꞌch na janoꞌ na paiꞌ dhuuk pɨk ba ji chum kuugalhdhaꞌ, yaꞌ ba aayaꞌ maaꞌn gu maaꞌnkam giilhim jix bhangɨm, ɨɨbhidham tu buidhaꞌ nam ba tɨgiaꞌ gu jaꞌtkam. Bhaiꞌ baakɨi gɇꞌ chiop pu tu doodaꞌ na jax ɨlhiiꞌñdhaꞌ. ―Moo pim tɨꞌñchukat dhiꞌñi na jax yaꞌ tu uaꞌñix, aapiꞌm na pim jɨꞌk tu jiñkaiꞌñdhaꞌ―. Baꞌ aañ pu kaiꞌch na guiꞌ nam jɨꞌk ya jaꞌp miaꞌn jup tuiꞌkaꞌ janoꞌ, puiꞌ na jax yaꞌ dhi Judea, jir am nam ba ji boiꞌñgiaꞌ mu jaꞌp paiꞌ oiꞌdhaꞌ taꞌm na baꞌ cham ja tulhiiñchudaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Piam noꞌ jaroiꞌ bhaiꞌ paiꞌ ka daa baꞌk dhaam, jir am na bhaiꞌ dhɨr tɨmnɨi pu jimɨiññolhiaꞌ, cham tuꞌ na mɨjɨp ka bapkɨdaꞌ ɨrban dɨr na baꞌ tuꞌ xi bhɨɨji. ");
INSERT INTO stpNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Piam noꞌ jaroiꞌ mu paiꞌ ka oirɨ gaꞌran, jir am na miꞌ dhɨr pu jimɨiññolhiaꞌ, cham tuꞌ na tuꞌ jajannulhiꞌñ jaiꞌp ka xi chu uaꞌrai kiaꞌmiꞌñ na baꞌ pɨk ba jimɨiñolhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Jaꞌp moo joiꞌmdam tum duñiaꞌ ji janoꞌ, kux baꞌ guꞌ puiꞌ aa! Nam guꞌ giilhim jum tulhiiñaꞌ gu uꞌuub guiꞌ nam aꞌaalh kɨꞌn cham bhaiꞌm taat kaꞌ, gio jaiꞌ nam ɨꞌlhich ka tu maamar kaꞌ xioꞌdam. ");
INSERT INTO stpNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Baꞌ aañ pu kaiꞌch na pim gammɨjɨ tu aꞌgadaꞌx dhaam jaꞌk buiñor gu Dios na baꞌ cham janoꞌ pɨk puiꞌ tum duñiaꞌ na paiꞌ dhuuk jix jɨɨpiꞌñ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Na guꞌ janoꞌ na paiꞌ dhuuk puiꞌ tum duñiaꞌ, giilhim jir tulhiiñaraꞌ kaꞌ jix ioꞌm, cham tuꞌ puiꞌ na mɨt jax jum tulhiiñak gu jaiꞌ bɨjɨk, janoꞌ nat dɨr jup duu gu Dios dhi oiꞌñgaꞌn. Guꞌ jaꞌpji jix ioꞌm ji na baꞌ pɨk bar daipuꞌ kaꞌ, cham jɨꞌxkat puiꞌ ka tum duñiaꞌ gatuuk, na guꞌ ba tum kuugalhdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nat guꞌ puiꞌ pu tɨi ɨp gu Dios na janoꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ, cham mɨk jir tulhiiñaraꞌ kaꞌ, na guꞌx ja joiꞌgɨꞌn guiꞌ nam jɨꞌk ba tɨ jɨɨgiꞌñ buiñor, cham aaꞌ nam mɨk yaꞌ oipot giilhim jum tulhiiñdhaꞌ. Noꞌ guꞌ cham tu daasaꞌ gɨt na jɨꞌx juugɨt jir tulhiiñaraꞌ kaꞌ, bɨɨx jam dho pu koꞌyaꞌ gɨt. ¿Jaroo gip jix ñakooꞌ na giilhim jum tulhiiñdhaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Baꞌ janoꞌ na paiꞌ dhuuk bar miaꞌn kaꞌ na tum kuugalhdhaꞌ, noꞌ jaroiꞌ jax jam tɨtda: “Muni dhaa guch Xoiꞌkam. Maik gor jach kaipuꞌ”, piam noꞌ jax kaiꞌch: “Muni ba ai guch Xoiꞌkam”, chaꞌpim jɨɨgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nam guꞌ muiꞌ jaiꞌchdhɨlhiaꞌ guiꞌ nam puiꞌ xi kaiꞌchidhaꞌ: “Aañ jir diꞌ guch Xoiꞌkam”, gio jaiꞌ nam puiꞌ xi kaiꞌchidhaꞌ na maadɨt jir diꞌ kaꞌ guiꞌ nam bɨjɨk ya jaꞌp bhaankam tu aꞌgimɨk guñ Gɨꞌkoraꞌ. Puiꞌx bhaiꞌp xi chu buidhaꞌ am guiꞌ nax bhaiꞌr jum duukam kaꞌ, nam jax dhui pɨx ja iatgidhaꞌ gu jaꞌtkam, sia guiꞌ nam jɨꞌk tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui. Noꞌm guꞌ cham pɨk bɨɨx ja jujur kɨꞌn jix biiñak, jix bhaiꞌ ja bhɨɨyaꞌ dho guꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Baꞌ aañ pu kaiꞌch na pim cham ja kɇkɇɇdat, nam guꞌ tu iatgidhidhaꞌ pɨx. Mooñ ba jam aagiꞌñ xib dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Miꞌ dhɨr baꞌ na xi chum tulhiiñai, dai na bhaiꞌ ji chum tukgamtaꞌ. Cham jɨꞌxkat ka tonniaꞌ kɨꞌn gu tanoolh, ni na cham jɨꞌxkat ka masbagiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Gio gu chiichiaꞌ nam bhaiꞌ ji iiꞌñxiaꞌ, na guꞌ giilhim jix ioꞌm giꞌndukiaꞌ gux dhaam. ");
INSERT INTO stpNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Baꞌ aañ nat bhañ joot guñ Gɨꞌkoraꞌ, bañ chɨgiaꞌ pim nañ bhɨjɨmmɨni dhɨr bhaiꞌ ji buusniaꞌ tɨbaaꞌñ chɨr, nam baꞌ ba machiaꞌ bɨɨx na jɨꞌk jaꞌtkam nañ aañ puiꞌp jir gɇꞌkam na jax guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Baꞌ naiꞌ ja jootsaꞌ iñ gu noonbiꞌñ guñ Gɨꞌkoraꞌ na jɨꞌx jir oiꞌñgaꞌn, puiꞌ na jax mummɨni jaꞌp na paiꞌ am juꞌkam tuꞌiiꞌ dhix dhaam, nam baꞌ ja jumpadaꞌ gu jaꞌtkam guiꞌ nam jɨꞌk tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’¿Cham jɨꞌxkat nɨiꞌñ japim aa gu iigɨx na paiꞌ dhuuk bhaiꞌ ji iipoñiaꞌ, na joidham pɨx tɨɨꞌngilhidhaꞌ gu jaagaꞌn? Dhiꞌ na bhaan jix maatɨꞌ kaꞌ noꞌt ba ji chaaꞌm, na paiꞌ dhuuk ba ji chu juukaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Baꞌ iam pɨx puꞌñip ji buusniaꞌ dhiꞌ puiꞌ nañ jɨꞌk jax ba kaiꞌch. Pɨx am tɨꞌñchukaꞌ pim noꞌt ba jim tɨɨmu dhi oiꞌñgaꞌn, bax maatɨꞌ kaꞌ na bar miaꞌn kaꞌ nañ bha jimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨɨda, bɨɨpɨꞌ puꞌñi xi chum duuji nam baꞌ pɨk ba koꞌyaꞌ dappaam gu jaꞌtkam guiꞌ nam jɨꞌk ka duduakaꞌ janoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dai dhi oiꞌñgaꞌn nam tɨɨmuꞌ gio gux dhaam, guꞌ guñ ñiꞌook cham jɨꞌxkat jum tɨɨmuꞌ ji. ");
INSERT INTO stpNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ku baꞌ guꞌ dhiꞌ cham maatɨꞌ ji na paiꞌ dhuuk pɨk puiꞌ tum duñiaꞌ, na guꞌ dai dɨɨlh guñ Gɨꞌkoraꞌ nat tu dai na puiꞌ tum duñiaꞌ. Cham maat am gu noonbiꞌñ, sia kum bhammɨp tuꞌiiꞌx dhaam, ni aañ kuñ cham maat nañ jir Maraaꞌn, dai guiꞌ dɨɨlh nax maat. ");
INSERT INTO stpNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Baꞌ gu xib tuꞌ na jax chuiꞌkaꞌ, aañ pu kaiꞌch na pim gammɨjɨ tu aꞌgadaꞌ jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ, chaꞌpim jɨꞌx mɨk buppadaꞌ, na pim guꞌ cham maat na paiꞌ dhuuk tu daaxix. Guꞌ dhiꞌ jotmodaꞌ pɨx puiꞌ tum duñiaꞌ cham jum ɨlhdham. ");
INSERT INTO stpNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na guꞌ dhiꞌ jaꞌp ji buusniaꞌ na jax gu jaroiꞌ noꞌt ka paxiaram mu paiꞌ jaꞌk mɨk, noꞌt miꞌ ka xi ja doꞌñchok jaiꞌ gu jaꞌtkam nam miꞌ ka tu juandaꞌ, dai na xi ja chianɨi nam jax jaꞌk tu juandaꞌ, puiꞌ na jax miꞌ na paiꞌ tuutkaꞌ gu baꞌpkiꞌñ, na guꞌ maaꞌn miꞌp xi chianɨi na ka tu nuukaꞌndaꞌ. Baꞌ guiꞌ dai na pɨx am tɨ nɨɨrkaꞌ na paiꞌ dhuuk gio miꞌp aayaꞌ, na guꞌ bhaiꞌ ji oꞌbhaiꞌñdhaꞌ noꞌ miꞌ pɨx cham tu jaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Baꞌ aapiꞌm puꞌñi ɨp, pɨx am tɨ nɨɨrkaꞌ pim, na pim guꞌ cham maat nañ paiꞌ dhuuk yaꞌ aayaꞌ, noꞌ jaxjɨ ji dhɨdɨmpugidhak, piam ɨrab tukaaꞌ, piam ku guꞌ katukgab na paiꞌ dhuuk ba jiiñkiaꞌ gu takaaruiꞌ, piam ku guꞌx dhaꞌnpam ji chu maaxirɨk. ");
INSERT INTO stpNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mooñ ba jam aagiꞌñ xib dɨr na pim tɨꞌñchukat. Chaꞌpim moo kooksɨt darkaꞌ, nañ guꞌ jotmodaꞌ yaꞌ pɨx ji buusniaꞌ cham jum ɨlhdham. ");
INSERT INTO stpNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Bɨɨx dhiꞌñi puiꞌ nañ jɨꞌk jax jam tɨtda aapiꞌm, dappaam na jɨꞌk jaꞌtkam jañ jup ja tɨtdat jup kaiꞌch: Nam cham kooksɨt darkaꞌ, gammɨjɨ pɨx tɨꞌñchukaꞌ am nañ jax ba kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Baꞌ nat gook tanoolh pɨx ba ji bii na baꞌ moo bam aayaꞌ na bar piasta kaꞌ bhaan Paaskua taꞌm, gio jumai na miaꞌn oiꞌñ nam paiꞌ dhuuk jix basdak tu kuaꞌdaꞌ gu paan gakdhiꞌñchix kam, iampɨx jaꞌp tuꞌm na ariin tɨmkalh. Baꞌ janoꞌ gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, tɨi moom gaꞌngaꞌ am nam jax jaꞌk duuji iatgidhai tu chiñiaꞌ nam muꞌaaꞌ gu Jesuus. Aaꞌndaꞌ gɨt am nam ba dagiaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","guꞌ ji na guꞌ sap cham jax jix bhaaiꞌ, na guꞌ kar piasta kaꞌ. Baꞌ jaꞌpni pɨx ka xi chɨꞌɨɨk jamɨt: ―Mooch chakui juandaꞌ na kar piasta kaꞌ, noꞌt ba buus baꞌ. Na guꞌ noꞌ chich xib daagɨk mi jaꞌp paiꞌ jax ba buim ja nɨiꞌñchudat gu jaꞌtkam, giilhim bhaiꞌ ji bhaakuꞌ am jich bui. ");
INSERT INTO stpNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Baꞌ jaꞌxpɨx gu Jesuus jimɨɨk mummup ba tu kuaꞌ Betaania, na paiꞌ kio gu Simoon guiꞌ na tootolhidhat ka gakiidhat gu tukgaꞌn. Baꞌ moo miꞌp ba ai maaꞌn gu ubii uaꞌdat maaꞌn gu ɨlhiꞌch jix moik gu jodai jaꞌaachix kam, nam alabaastro kɨꞌn jix mat kaꞌ, na mi suuꞌntuꞌ gu osbhagaꞌn guiꞌ nam nardo kɨꞌn jix mat kaꞌ nax dhaꞌram namɨɨk, na joidham uub. Baꞌ nat jax kukpioꞌkak bhaiꞌ xi choiꞌ moꞌran gu Jesuus, pu bɨɨx ɨp moo nat bha toiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Baꞌ jɨꞌkchi gu jaꞌtkam nam miꞌp tuꞌiiꞌ bhaiꞌ ji bhaak jamɨt, jup kaiꞌch am: ―¿Jax baꞌm aagɨt puiꞌ tu bua dhi ubii? Tɨɨꞌ nat bɨɨx xi dhoodak dhiꞌ na tuꞌx dhaꞌram namkɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","¿Cham bhaiꞌ aa na tu chiñiaꞌ gɨt nam gaꞌraꞌ nam baꞌ ja makiaꞌ gɨt guiꞌ nam alh cham jir tu biaꞌ kam, nam attiiru cham biaꞌ nam tuꞌ kɨꞌn tu sabaꞌdaꞌ? Jaiñ na guꞌ jaꞌkbuiꞌ busaakdat gu tuumiñ na jax noꞌ ñich maaꞌn oidhaꞌ ba tu jua. Baꞌ puiꞌ jɨꞌ xi kaiꞌchimɨk am bhaiꞌ ji ñiok jamɨt gu ubii, ");
INSERT INTO stpNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","guꞌ ji nat guꞌ jotmodaꞌ ja sooꞌmcholh gu Jesuus, jup ja tɨtda: ―Chaꞌpim tuꞌ kɨꞌn juandaꞌ dhiñ jaduuñ, na pim guꞌ cham maat nat jax kaiꞌñkam bhañ juulh dhiꞌ na pimɨt tuꞌ bhaan ba ji chu aꞌga. ");
INSERT INTO stpNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Guꞌ matgam gu jaaduñ na pim ja aaꞌ, gammɨjɨ yaꞌ jam buip tuiꞌkaꞌ am ji, xi ja maakat japim dho nam alh kɨꞌn jup xiaꞌñdhidhaꞌ. Guꞌ aañ nañ bar boi chaꞌm kam ");
INSERT INTO stpNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","nat baꞌ bhaiꞌ bañ choiꞌ dhi ubii dhiꞌ na joidham uub, na baꞌ cham xijai kaꞌ, dai nam bañ yaaspaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨɨdaꞌ, na paiꞌ dhuuk bhaiꞌ ji chum aꞌgaꞌ gux bhaiꞌm kaiꞌchdham ñiꞌook yaꞌ dhi oiꞌñgaꞌn, bɨɨx jup jum aꞌgidhaꞌ dhi ubii na baꞌ bhaan jix maatɨꞌ kaꞌ nat jix bhaiꞌ dhuu nat bhañ choiꞌ dhi osbhagaꞌn gu nardo na joidham uub. ");
INSERT INTO stpNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Baꞌ maadɨt gu mambhɨɨx daman gook gu noonbiꞌñ, guiꞌ na Juudas Iskariote tɨɨꞌkaꞌ, xi mɨɨ nat ja aaꞌñdham gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, na baꞌ maaxik kɨɨsaꞌ nam boi bhɨichdhaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Baꞌ joidham jix bhaiꞌm ɨlh jamɨt na ba ja aagiꞌñ, jup tɨtda am nam muiꞌ namkidhaꞌ na mu ja baidhikaꞌ gu ja oꞌrosiiris tuk na paiꞌ sɨlh oirɨdaꞌ gu Jesuus. Baꞌ gu Juudas ba jim gaa na jax jaꞌk jix bhaiꞌ ji buusniaꞌ nam jix bhaiꞌ bhɨɨyaꞌ, nam baꞌ cham xijaichdhaꞌ nam daagɨi boi bhɨichdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Baꞌ buimgidhak bɨɨpɨꞌ dɨr na baꞌ moo muiꞌ jim kɨɨsaꞌ jaꞌxpɨx na paiꞌ dhuuk kasnir bakaax tum jugiaꞌ, gio baꞌ gu jumai na miaꞌn oiꞌñ nam jix basdak tu kuaꞌdaꞌ gu paan gakdhiꞌñchix kam, baꞌ moop ba tɨkka am gu noonbiꞌñ gu Jesuus, jup tɨtda am: ―¿Paap jaꞌk jix aaꞌ nach jimɨi tu bhaidhaꞌ nach tu jugiaꞌ jaꞌxñi nat yaꞌ bam ai gu piasta bhaan Paaskua taꞌm? ");
INSERT INTO stpNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Baꞌ gu Jesuus gook mɨjɨ xi ja joot bhammɨ gɇꞌ kiicham, jup ja tɨtda: ―Aañ jaꞌp tɨi kaiꞌchɨt na pim mu jimiaꞌ aapiꞌm gook bhammɨ gɇꞌ kiicham. Bhaiꞌ pim tɨgiaꞌ maaꞌn gu chioꞌñ nar tujuandam na mi jaꞌp ba tu baiꞌntuꞌndaꞌ maaꞌn gu baiꞌñdhakar taꞌm. Baꞌ aapiꞌm muiꞌ xi oidhaꞌ gatuuk dɨr, pɨx nɨidhidhaꞌ pim na mummu ji aayaꞌ kiicham. ");
INSERT INTO stpNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Baꞌ aapiꞌm cham xiꞌɨrdat muiꞌ xi aayaꞌ, jaꞌp japim tɨɨdaꞌ gu miꞌ kiokam: “Aach jaꞌp jich chɨɨdak bhach joot gu Gɇꞌkam nap sap taiñbuidhaꞌ maaꞌn kap gum baꞌaak paiꞌ na tu bioꞌ, na sap yaꞌ tu jugiaꞌ ja bɨɨm gu noonbiꞌñ nat bam ai gu piasta bhaan Paaskua taꞌm.” ");
INSERT INTO stpNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Baꞌ guiꞌ tu jam tɨɨꞌñchudaꞌ bhɨjɨ jaꞌp tɇꞌkob, na paiꞌ tɨ kɨɨꞌmpigix gio na gɇꞌx chu bhaiꞌ. Bhaiꞌ pim baꞌ tu bhaidhaꞌ nach tu jugiaꞌ jaꞌxñi. ");
INSERT INTO stpNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Baꞌ muiꞌp ma jii mɨt gu gook gu noonbiꞌñ, bhammɨ mɨt ba ai gɇꞌ kiicham. Puiꞌ dho ji chu buus na jɨꞌk jax ja tɨtda gu Jesuus. Cham xijaich jamɨt, dai na mɨt xi chu bhaidhak gu koiꞌ nam tu jugiaꞌ. Jaꞌxpɨx baꞌ giop ka xi jii mɨt mummu nat paiꞌ dhɨr bha ja joot. ");
INSERT INTO stpNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Baꞌ ji chukgɨk miꞌ ba ai gu Jesuus ja bɨɨm gu mambhɨɨx daman gook gu noonbiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Miꞌ baꞌ bhaiꞌ ji chu juu mɨt. Baꞌ nam miꞌ daraat ka tu kuaꞌ, jup ja tɨtda: ―Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨɨdaꞌ, maadɨt aapiꞌm na pim yaꞌp tuꞌiiꞌ, maaxik jiñ kɨɨsaꞌ ja bui gu gɇꞌgɇrkam jum aaꞌndam nam boiñ bhɨichdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Baꞌ guiꞌ gampaiꞌ ji dhuu mɨt, baꞌ pɨx bhaiꞌ ji chɨkka mɨt jɨꞌmaꞌn, jup tɨtda am: ―¿Aañiꞌ aa chi? Gio gu jumai: ―¿Kaꞌ aañiꞌ aa chi? ");
INSERT INTO stpNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Baꞌp ja tɨtda gu Jesuus: ―Maaꞌn pɨx ji guꞌ aapiꞌm mambhɨɨx daman gook na pim yaꞌp tuꞌiiꞌ, nach jɨꞌk maap ya tɨ sɨssɨ dhi jooxiaꞌ taꞌm nañ jax chuꞌm kaꞌm tu kuaꞌ aañ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Jir am kat na pu cham jaiꞌch kaꞌ gɨt gu jaroiꞌ na maaxik jiñ kɨɨsaꞌ nam boiñ bhɨichdhaꞌ. Tɨix joiꞌgɨꞌñ iñ, na guꞌ giilhim jum tulhiiñaꞌ maaxik xiñ kɨɨsai. Ku baꞌ guꞌ dhiꞌ miꞌ pɨx puiꞌ ba jimdaꞌ ji, na bhaan pɨx jum kuugalhdhaꞌ na jax jum kaiꞌch mi uꞌuan taꞌm gu ñioꞌkiꞌñ gu Dios, na puꞌñi jaꞌk jiñ dhoodaꞌ am aañ nat bhañ joot. ");
INSERT INTO stpNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Baꞌ miꞌ puiꞌ nam tu kuaꞌ, nat jax dhaa ɨp gio gu Jesuus jaiꞌ gu paan, xi chu taxchaabgidhak jix dhaam jaꞌk taꞌtak xi jaisaidhat pɨx muiꞌ ji ja maa gu noonbiꞌñ, jup ja tɨtda: ―Dhiꞌñi pim pup muiꞌ xi jugiaꞌ, na guꞌ dhiꞌr jiñ chuukuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Gio baꞌ maaꞌn miꞌ dhɨr jaꞌp bhaiꞌp ji bhɨi gu alhiꞌch jaꞌaa na mi suuꞌntuꞌ gu biiñ guiꞌ na uubas kɨꞌn jup duñiix, baꞌ mu jaꞌk xi ja maakak xi ja chia nam iꞌyaꞌ. Baꞌ guiꞌ bhaiꞌp xi ii mɨt jɨꞌmaꞌn kaam. ");
INSERT INTO stpNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na mɨt xi iꞌchuk baꞌp ja tɨtda: ―Dhiꞌ na pimɨt tu ii, dhiꞌr jiñ ɨꞌɨɨr na kɨꞌn xib dɨr maakam aagix kaꞌ na jax jaꞌk jix aaꞌ guñ Gɨꞌkoraꞌ nam miꞌ puiꞌ jiimdaꞌ gu jaꞌtkam, na guꞌ ka mɨlhiaꞌ guñ ɨꞌɨɨr na baꞌ tu namkix kaꞌ gu ja uaꞌtulhdharaꞌ, na baꞌx bhaiꞌ tu ja jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pu jam tɨɨdaꞌ, daipuꞌ dhi maaꞌn kaam nañ xi ioꞌji dhi uubas baraaꞌ gu xib, nañ guꞌ moo bar boi chaꞌm kam. Janoꞌ baꞌ na paiꞌ dhuuk ba tum kuugalhdhaꞌ nañ baꞌ giop ba iꞌyaꞌ jix dhaam jaꞌk, ku guꞌ gux uañ ji, cham tuꞌ dhiꞌ pu chuꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Miꞌ dhɨr baꞌ maaꞌn xi laalagɨk tɨi ma jii mɨt bhammɨ jaꞌk oidhaꞌ taꞌm, nam paiꞌ Oliibus kɨꞌn jix chu mat kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Guꞌ ji na guꞌ na mɨt baas ba ji bhɨi, jup ja tɨtda gu Jesuus: ―Yaꞌ moo mam ai nam kuugalhdhaꞌ na jax tu uaꞌñix mi uꞌuan taꞌm nap jum kaiꞌch: “Muꞌaaꞌ am gu bipiaꞌdam, baꞌ gu kakasnir jum jɨꞌdɨlhkadai pɨx chaꞌtak boopoyaꞌ am jɨꞌmaꞌn.” Baꞌ dhiꞌ na puiꞌ jɨꞌ tu uaꞌñix, aapiꞌm jam aagɨt puiꞌ jaꞌk jum kaiꞌch, na pim pu jiboiꞌñgiaꞌ xib dhi tukaaꞌ nam bañ dhagiaꞌ guiꞌ nam bha ja jootsaꞌ gu gɇꞌgɇrkam jum aaꞌndam. Na guꞌ cham tuꞌ dai nam jiñ kuupaꞌ pɨx, guꞌ jaꞌpji nam pu tu chiñiaꞌ nam jiñ muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ku baꞌ guꞌ aañ gatuuk yaaꞌ ji nañ jax ba oirɨdaꞌ. Kagɨt nañ bɨɨpɨꞌ mu ba oirɨdaꞌ Galilea na pim baꞌ aapiꞌm mup ba aayaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Baꞌp kaiꞌch gu Peegro: ―Aañ dho gi chakui jimɨiññolhiaꞌ ji, sia mɨt dhi jaiꞌ jiboiꞌññor. Cham jax bua sia ku mɨt jum bɨndak jiñ dhaa. ");
INSERT INTO stpNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Baꞌp tɨtda gu Jesuus: ―Tuꞌ sɨlhkam kɨꞌn jañ yaꞌ pum tɨɨdaꞌ na gookim ka jiiñkiaꞌ gu takaaruiꞌ xib dhi tukaaꞌ, aap baikim puiꞌ ba tɨꞌyaꞌ nap cham jiñ kaichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Guꞌ ji na guꞌ xi kɨɨk gu Peegro, jup kaiꞌch: ―Aañ dho gi pu tɨꞌyaꞌ ji nañ jum kaichuꞌ, cham jax bua sia mɨt jum bɨndak jiñ mua. Baꞌ bɨɨx puiꞌp ji chɨi mɨt gu jaiꞌ noonbiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Baꞌ miꞌ pɨx ji ai mɨt na paiꞌ Getsamanii tɨ tɨɨꞌ, baꞌp ja tɨtda ɨp gio gu Jesuus: ―Yaꞌni pim ka darkaꞌ. Aañ bhaꞌñi ka tu aꞌgaraꞌ jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Baꞌ baasɨꞌn iam xi jimɨɨk baik pɨx xi ja baidhak gu noonbiꞌñ, dai gu Peegro, gio gu Jakoobo, gio baꞌ gu Juan. Baꞌ gampaiꞌ jim duu nam bhaiꞌ xi ñɨiꞌñ, panaas kux buam jum aaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","baꞌp ja tɨtda: ―Aañ moo cham puiꞌ ka tu tatdaꞌ ji, bax chaat iñ nam miaꞌn ba jiim guiꞌ nam boiñ bhɨichdhaꞌ. Aañ jaꞌp ɨlhiiꞌñ na pim yaꞌ pɨx kañ ñɨɨrdaꞌ ɨp aapiꞌm, dai na pim moo cham kooksodaꞌ, tɨ nɨiꞌñdhaꞌ pim. ");
INSERT INTO stpNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Baꞌx ioꞌm baasɨꞌn iam xi jimɨɨk mi jaꞌp oꞌlhiaꞌn kɨꞌn xi kɨkbuk xi dhumartɨk, dɨɨrap na xi chu siisap gu maꞌooꞌn. Baꞌ muiꞌ ji chu aꞌga jix dhaam jaꞌk buiñor guch Gɨꞌkoraꞌ, na tɨkkaꞌn noꞌ sap jix bhaaiꞌ na palhbuidhaꞌ nam baꞌ cham boi bhɨichdhaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","jup kaiꞌch: ―Aapiꞌñ Gɨꞌkoraꞌ nap jix dhaam jup tuꞌiiꞌ, nap bɨxchuꞌx bhaaiꞌ nap pu tu duñiaꞌ, xiñ palhbuiꞌñ nam cham boiñ bhɨichdhaꞌ, na guꞌ dhiꞌ jaꞌp ji buusan na jax gu tuꞌ na giilhim jix xibuꞌ nañ tu iꞌyaꞌ. Piam jap xiñ guguuxdhaꞌ nañ baꞌ cham jax jiñ aaꞌndaꞌ noꞌp guꞌx aaꞌ nam kuugalhdhaꞌ nap aap jax ɨlhiiꞌñ. Ku guꞌ aañ cham tuꞌ ji nañ moo cham aagɨt jup kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Baꞌ jaꞌxpɨx nat jaꞌk gɨi miꞌ nat paiꞌ xi ja chianɨk nam ka darkaꞌ gu baik gu noonbiꞌñ, miꞌ pɨx kookos am nat ba ja tɨɨ. Baꞌp tɨtda gu Jesuus gu Peegro: ―Simoon, ¿moo jaꞌp jix kooxim ap aa? Tɨ nɨiꞌñdhaꞌ ap. Moo pich chi moo janoꞌ koi na ñich jax jii. ¿Kaꞌp ji siamri jɨꞌx xi chɨ nɨidhimɨk aa? ");
INSERT INTO stpNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Guꞌ pim ji tɨ nɨiꞌñdhaꞌ ji, gio na pim tu aꞌgadaꞌ jix dhaam jaꞌk buiñor guñ Gɨꞌkoraꞌ na baꞌ cham jam maiꞌchiaꞌ gu jaꞌook. Puiꞌ dho pɨx tɨi xi chu tatdaꞌ jia na pim nakgaꞌ gɨt na pim jum tulhiiñaꞌ na jax aañ, guꞌ ji na pim guꞌ cham nakooꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Baꞌ dai nat xi ja ñiññichdhak gio mu jaꞌk jup ji dhuu nat tu aꞌgam jix dhaam jaꞌk, jir maaꞌn na jax kaiꞌchim nat jax jaꞌk tu aꞌga bɨɨpɨꞌ dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Baꞌ jaꞌxpɨx nat gio jaꞌk jup gɨi, kookos am nat giop ba ja tɨɨ, pu cham ñiok am na tɨi xi chu ja aꞌgiꞌñ, nam guꞌ giilhim jix kookxik. ");
INSERT INTO stpNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Baꞌ na bar baikim nat xi chu aꞌgarak jix dhaam jaꞌk nat gio miꞌp ba ai, maaꞌn nam jax kookos nat ba ja tɨɨ, baꞌp ja tɨtda: ―¿Kux baꞌ moo jaꞌp jix kookxik japim aa? Gi nañ jup jam tɨtda na pim tɨ nɨiꞌñdhaꞌ nañ jɨꞌx ka tu daan. Xib na guꞌ cham kam aaꞌ na pim tɨ nɨiꞌñdhaꞌ, nat guꞌ bam ai na paiꞌ dhuuk tu daaxix na aañ nat bhañ joot guñ Gɨꞌkoraꞌ boi bañ bhɨichdhaꞌ am guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mummuni dhɨr bhaiꞌ ba jimchuꞌ muiꞌ ja bɨɨm guiꞌ nañ jaroiꞌ jam aagiꞌñ bɨɨpɨꞌ na maaxik jiñ kɨɨsaꞌ. Maik gor jach muiꞌ xi ñamkiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Baꞌ na puiꞌ jɨꞌ ka ja tɨtda gu Jesuus gu noonbiꞌñ, miꞌ ba ai ji guꞌ gu Juudas, guiꞌ na maadɨt jir diꞌ gu mambhɨɨx daman gook gu noonbiꞌñ, ja bɨɨm muiꞌ gu jaꞌtkam kukxir ji chu uaꞌdat am, jaiꞌ gu uꞌuux jix kaapak, na mɨt bha ja joot gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, gio baꞌ guiꞌ nam jir ja gɇꞌgɇrkam tuk kaꞌ gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Baꞌ gu Juudas bɨɨpɨꞌ dɨr xi ja aaꞌñdhak nam baas dɨr ka jiim na jax jaꞌk duñiaꞌ nam baꞌ ba machiaꞌ na jax chuꞌm jir diꞌ kaꞌ, jup ja tɨtda: ―Guiꞌ nañ jaroiꞌ miꞌ xi ñioꞌkdhaꞌ, dhiꞌr diꞌ kaꞌ. Baꞌ aapiꞌm jotmodaꞌ miꞌ pu dagiaꞌ, jix bhaiꞌ pim buuprai pu bhɨikaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Puiꞌ dhom duu. Na mɨt jax miꞌ ai, pɨx jix bhaiꞌ kaiꞌchim gu Juudas, jup tɨtda gu Jesuus: ―Aach bha jaꞌk ɨp jiñ jaduuñ. Gio baꞌ nat miꞌ xi ñioꞌki. ");
INSERT INTO stpNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Baꞌ guiꞌ jotmodaꞌ miꞌ pu daa mɨt, buuprak gamaiꞌ pu bhɨich jamɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Baꞌ maaꞌn gu maaꞌnkam tugiꞌñ gu Jesuus, nat jax baabuk gu kuxiiruꞌn bhaiꞌ tɨi soñiich maadɨt guiꞌ na mɨt mu ja joot gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios. Guꞌ ji nat guꞌ cham ai, nat guꞌ jaꞌp xi ñɨɨra, dai naakaꞌn pɨx ai palhɨɨp. ");
INSERT INTO stpNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Baꞌp ja tɨtda gu Jesuus guiꞌ na mɨt ba daa: ―¿Jax ku pim baꞌ bɨxchuꞌ kukxir tu uaꞌdat bha jaꞌk jiim gam uꞌux jix kaapak? ¿Tuꞌ ɨxkum jiñ ɨlhiiꞌñ japim aa? ");
INSERT INTO stpNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","¿Jax ku pimɨt baꞌ cham mummu puñ dhaa gɇꞌ chiop nañ moo miꞌ pu oirɨt tu jam aꞌgiꞌñdhaꞌ nabap tanoolh? Kaꞌ baꞌ na guꞌ dhiꞌ na bhaan pɨx jum kuugalhdhaꞌ na jax jum kaiꞌch mi uꞌuan taꞌm gu ñioꞌkiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Baꞌ dɨɨlh miꞌ xi buak jamɨt gu Jesuus gu noonbiꞌñ pu jiboiꞌññor. ");
INSERT INTO stpNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Baꞌ nam nammɨ gama jaꞌk ba uaꞌ buuplhixim gu Jesuus, gatuuk dɨr muiꞌ ka jimchuꞌ maaꞌn gu biapmaꞌ dai tɇb kutuun ji chɨiꞌchgɨt. Baꞌ oꞌbhaiꞌñdhak tɨi daa mɨt, ");
INSERT INTO stpNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","guꞌ ji na mɨt guꞌ cham bhaiꞌ daa, kutuunaran pɨx daa mɨt. Jum jupnak pu jimɨiññor jix dhaapkat. ");
INSERT INTO stpNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Baꞌ mummu ba aich jamɨt gu Jesuus na paiꞌ kiokaꞌ guiꞌ nax ioꞌm jir ja gɇꞌkam tuk kaꞌ guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios. Baꞌ bɨɨx maap bam jumaap jamɨt gu jaiꞌ guiꞌ nam cham pɨk jir ja gɇꞌgɇrkam tuk kaꞌ, gio baꞌ guiꞌ nam jir ja gɇꞌgɇrkam tuk kaꞌ gu Israel kam jaꞌtkam, gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Baꞌ gu Peegro gatuuk miꞌp ba ai, na guꞌ gatuuk dɨr pɨx muiꞌ ji jim jix chooꞌnnɨt. Miꞌ dhɨr jaꞌp dɨɨrap pɨx ji dhaibu miꞌ na paiꞌ mɨim gu tai, nam paiꞌ tu naadat juukaꞌ gu oꞌrosiiris. ");
INSERT INTO stpNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Baꞌ gu gɇꞌgɇrkam tɨim tɨ tɨkkaꞌn am nam jax jaꞌk duuji iattulhdhai tu chiñiaꞌ nam muꞌaaꞌ gu Jesuus, guꞌ ji nam guꞌ cham jɨꞌxkat nɨiꞌñ na mu paiꞌ giilhim tu buim, ni nam paiꞌ dhuuk puiꞌ tɇ kɇɇ. Miꞌ dho guꞌ pu cham bhaaiꞌ nam jax tɨꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Baꞌ jaiꞌ dhɨt tɨi xi iattulhiꞌñ am, guꞌ ji nam guꞌ puiꞌ pɨx cham jup ja jɨɨgiꞌñ, na guꞌ maaꞌn maakam jup kaiꞌchdhaꞌ, gio gu jumai maakam ɨp. Miꞌ puiꞌ cham ka nokiaꞌ, miꞌ dhɨr jumai bhaiꞌ tɨip ji chu aꞌgaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jaiꞌ guꞌngukɨt tɨi xi iattulhiꞌñ am, jup kaiꞌch am: ");
INSERT INTO stpNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Dho guꞌ aach miꞌ paiꞌ puiꞌ kai ji nap kaiꞌch: “Alh jañ moo ka iaraꞌ dhi gɇꞌ chiop jaꞌtkam jup ja duiñ, baik tanoolh kɨꞌn jañ baꞌ gio jumai yaꞌp kɨɨsaꞌ, dhiꞌ baꞌ Dios bap jir duñiiꞌñ kaꞌ, cham tuꞌ tuꞌ jaꞌtkam.” ");
INSERT INTO stpNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ni gu puiꞌ kum cham maaꞌn ñiꞌook jup bua, sia kum panaas tɨi sɨlhkam kam xi kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Baꞌ gux ioꞌm ja gɇꞌkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, xi kɨkbuk xi ja sooꞌmchulhdhak nam sap cham ñiokdaꞌ, baꞌ ba tɨkka gu Jesuus, jup tɨtda: ―¿Jax jap ɨlhdhat ja kɇɇ dhi jaaduñ? ¿Jir sɨlhkam aa nam jax kaiꞌch, kaꞌm ji iat aa? Eap xi chu aꞌga nach xim kɇɇkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Guꞌ ji na guꞌ cham ñiok gu Jesuus, miꞌ pɨx pu daa. Baꞌ giop xi chɨkka jix bhaiꞌ pɨx, jup tɨtda: ―¿Jir sɨlhkam aa nap saak aap jir diꞌ guch Xoiꞌkam, nap saak jir Maraaꞌn gu Dios gux ioꞌm Gɇꞌkam? ");
INSERT INTO stpNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Miꞌ dho gi baꞌ bhaiꞌ ji ñio ji gu Jesuus, jup kaiꞌch: ―Aañiꞌ dhor diꞌ. Kani na pim bañ chɨgiaꞌ nañ bhɨjɨmmɨni dhɨr bhaiꞌ ji buusniaꞌ tɨbaaꞌñ chɨr gatuuk nañ bhammɨx dhaam xi dhaakat sonpan gu Dios kɨɨꞌn dɨr. ");
INSERT INTO stpNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Baꞌ gux ioꞌm ja gɇꞌkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, ais saassa gu jannulhiꞌñ na sap baꞌ bhaan jix maatɨꞌ kaꞌ na cham jir am puiꞌ nat jax tɨi gu Jesuus, jup kaiꞌch baꞌ: ―¡Dho jaña! ¿Jarooch baꞌp ka nɨɨra nax bhaiꞌ tu aaꞌndaꞌ? Tɨɨꞌ nat dɨɨlh yaꞌ maaxik bam kɨi. ");
INSERT INTO stpNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¿Jax japimɨt gi ɨlhdhat kai? ¿Cham aa pim ɨlhiiꞌñ na giilhim jir uaꞌtulhdharaꞌ gu puiꞌ nat jax tɨi, na moo jaꞌxbuiꞌ gɇꞌkam jup xim taat na jax gu Dios? Baꞌ bɨɨx bhaiꞌ ji bhaak jamɨt nam jɨꞌk miꞌp tuꞌiiꞌ, puiꞌ ji chɨi mɨt na sap puiꞌ pɨx bax bhaaiꞌ nam tu chiñiaꞌ nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Baꞌ bhaiꞌ ji dhaa mɨt puiꞌ xi chɨꞌɨɨk. Jaiꞌ mɨt bhaiꞌ ji xixbuidhimɨ, jaiꞌ na mɨt bhaiꞌ xi bulhdhak gu jannulh buupuiran bhaiꞌ xi gɨb, gio baꞌ nam xi chɨkka, jup tɨtda am: ―¿Jaroo bham gɨɨꞌ? Eap xich aagiꞌñ. Miꞌ dhɨr baꞌ gu oꞌrosiiris jaiꞌ bhaiꞌp ji gɨbiimɨ mɨt buibsaran. ");
INSERT INTO stpNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Baꞌ gu Peegro na miꞌ ka daa cham joiñat, bhɨjɨ dɨr jaꞌp tɨmnɨk tɇꞌkob miꞌ ba ai maaꞌn gu tɨyaa na miꞌr tujuandam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Baꞌ miꞌ pɨx ji chɨɨ gu Peegro na miꞌ daakat ka juukaꞌ taikob, baꞌ bhaiꞌ xi ñɨidhimɨk jup tɨtda: ―¿Aap aa maadɨt jir diꞌ nap kaichuꞌ gu Jesuus Nasareet kam? ");
INSERT INTO stpNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Guꞌ ji na guꞌ gu Peegro cham tu aaꞌ, dai nap kaiꞌch: ―Cham. Aañ dɨɨlh ji nañ jup oilhim jiñ jaduuñ. Pu ni nañ jix maat gu jaroiꞌ nap aagɨt jup kaiꞌch. Baꞌ miꞌ dhɨr jimɨɨk gama jaꞌk jup ba kɨɨk kiꞌñgob. Baꞌ mi kɨɨkat jix buam jum aaꞌ, baꞌ moo maaꞌnnim ba jiiñ gu takaaruiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Baꞌ gu tɨyaa muiꞌ xi ñɨidhimɨk ɨp gio, jup ja tɨtda guiꞌ nam miꞌp tuꞌiiꞌ: ―Guꞌñi dho bak maadɨt jir diꞌ na kaichuꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Guꞌ ji na guꞌ gu Peegro jir maaꞌn na jax kaiꞌch. Baꞌ jaꞌxpɨx bhaiꞌp ji chɨkka mɨt guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ, jup tɨtda am: ―¿Jaꞌp aa moor sɨlhkam nap cham tuꞌ maadɨt jir diꞌ guiꞌ nam kaichuꞌ gu Jesuus Nasareet kam? Chi moo tɨi kaichuꞌ ap ji, guꞌ ji nap guꞌ cham tu aagam. Jax dhui na pim guꞌr miaꞌn jum oiꞌdhagɨm. ¿Kaꞌ cham aa aap jir Galilea kam? Tɨɨꞌ nap baꞌ moo jaꞌp puiꞌ tu ñiok nam jax tu ñiok gu mu kam. ");
INSERT INTO stpNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Guꞌ ji na guꞌ xi kɨɨk gu Peegro, dai nat bhaiꞌ pɨx ji bhaam nam tɨix bhaiꞌ pɨx xi chɨkka. Bɨɨx aixim ja tɨtda na jax ɨlhiiꞌñ, jup kaiꞌch noꞌ guꞌ sap cham jir puiꞌ na jax kaiꞌch, ku gammɨjɨ pu doodaꞌ ku gi gu Dios na jax ɨlhiiꞌñdhaꞌ. Jaꞌpni moo kaiꞌch: ―Noꞌ guꞌ cham jir puiꞌ ku gi nañ jax jam tɨtda, ku puñ dhoodaꞌ ku gi gu Dios na jax ɨlhiiꞌñdhaꞌ, nañ guꞌ aañ tɨi ba jam aagiꞌñ nañ dɨɨlh jup oilhim. Gio pu cham jup nɨiꞌñ iñ na jax chuꞌm tɨ nɨiꞌñ gu jaroiꞌ na pim mɨjɨ paiꞌ aaꞌ. ¿Jax japim baꞌ duukat puiꞌ jaꞌk ɨlhiiꞌñ nañ aañ kaichuꞌ? ");
INSERT INTO stpNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Baꞌ daipuꞌ xi ja tɨɨdak gio mi jaꞌp gampaiꞌp jim duu. Baꞌ giop ba jiiñ gu takaaruiꞌ, bar gookim nat giop ba jiiñ. Baꞌ bhaiꞌ pup tɨꞌñcho gu Peegro na bak pɨn puꞌñi tɨtda gu Jesuus bɨɨpɨꞌ dɨr: “Gookim ka jiiñkiaꞌ gu takaaruiꞌ nap aap baikim puiꞌ ba tɨꞌyaꞌ nap cham jiñ kaichuꞌ.” Baꞌ bhaiꞌ ji susua, nat guꞌ giilhim bhaiꞌx buam ji chu tatdat na puiꞌ xim aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Baꞌ buimgidhak nat jax pɨx bhaiꞌ ji chu maaxir, gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio baꞌ guiꞌ nam jir ja gɇꞌgɇrkam tuk kaꞌ gu Israel kam jaꞌtkam, gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, xi chu aꞌgak jamɨt nam jax jaꞌk duuji tu chiñiaꞌ nam boi bhɨichdhaꞌ gu Jesuus. Baꞌ jaꞌxpɨx na mɨt paiꞌ maaꞌn ñiꞌook xip duuk, dai na mɨt muiꞌ ba bhɨɨk jix bhaiꞌ buuplhixim mu na paiꞌ daa gux kaiꞌ Pilaato. ");
INSERT INTO stpNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Baꞌ gu Pilaato xi chɨkkaꞌn gu Jesuus na mɨt jax mu aichulh, jup tɨtda: ―¿Aapiꞌ aar diꞌ nap saak jir ja gɇꞌkam tuk yaꞌ dhi Israel kam jaꞌtkam? Baꞌp tɨtda gu Jesuus: ―Jir puiꞌ dho nap jax kaiꞌch jiñ jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Baꞌ gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, bɨɨx aixim tɨi iattulhiꞌñ am gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Baꞌ gio bhaiꞌp ji chɨkka gu Pilaato, jup tɨtda: ―Jir sɨlhkam chi moo puiꞌ nam jax kaiꞌch nam bɨɨx aixim jum iattulhiꞌñ dhi jaꞌtkam. Tɨɨꞌ nap baꞌ cham ñiok. ¿Puiꞌ aap baꞌ cham tuꞌ bhaan jum palhbuidhaꞌ? Tɨɨꞌ nam jax kaiꞌch dhi jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Guꞌ ji nat guꞌ cham ka ñio gu Jesuus nat gio tɨip xi chɨkka. Baꞌ miꞌ pu cham maat gu Pilaato na jax dhuñiaꞌ na tɨi xim gaꞌnga. ");
INSERT INTO stpNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Baꞌ jaꞌpni jaꞌk moop tu jimdaꞌ gux kaiꞌ Pilaato: Nabap oidhaꞌ na paiꞌ dhuuk jum aajidhaꞌ gu piasta bhaan Paaskua taꞌm, maaꞌn dadoꞌñchoꞌ gu maaꞌnkam guiꞌ nam jɨꞌk kuupkaꞌ, dai na guꞌ gu jaroiꞌ na ɨlhiiꞌñdhaꞌ nam cham pɨk bhaamkiꞌñdhaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Baꞌ janoꞌ maadɨt miꞌp kuupkaꞌ gu maaꞌnkam Barrabaas tɨɨgim, guiꞌ na bɨɨx jimdat bɨɨpɨꞌ dɨr na mɨt paiꞌ dhuuk ja koi jɨꞌkchi gu jaꞌtkam na mɨt ja kokda gu gɇꞌgɇrkam. ");
INSERT INTO stpNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Miꞌ dhɨr baꞌ miꞌm jumpadak gu jaꞌtkam jup tɨtda am gux kaiꞌ Pilaato, na sap jix bhaaiꞌ na doꞌñchoꞌ maadɨt guiꞌ nam mɨjɨ kuup nam paiꞌm kukpa gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Baꞌp ja tɨtda gu Pilaato: ―Aañ jaꞌp ɨlhiiꞌñ nañ doꞌñchoꞌ dhi Jesuus, na guꞌp kaiꞌch nar jam gɇꞌkam tuk bɨɨx aapiꞌm yaꞌ dhi Israel. ¿Jir am aa, kaꞌ cham aa? ¿Jax japim ɨlhiiꞌñ aapiꞌm? ");
INSERT INTO stpNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Baꞌ dhiꞌ na puiꞌ jɨꞌ ja tɨtda gu Pilaato na miꞌ pɨx mamtɨ, ee jax pɨk tɨꞌyaꞌ am. Na guꞌx maat na gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, nam jix bhaamkidhat jamɨt baꞌ mu aichulh gu Jesuus na sap baꞌ miꞌ dhɨr ja chiñiaꞌ gu sandaaruiꞌx chugiꞌñ nam muꞌaaꞌ, nam guꞌ giilhim jix jɨɨgam. ");
INSERT INTO stpNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Guꞌ ji na guꞌ guiꞌ pu bɨɨpɨꞌ dɨr ba ja iatgi mɨt gu jaꞌtkam, jup ja tɨtda am nam sap puiꞌ tɨꞌyaꞌ na cham dadoꞌñchodaꞌ gu Jesuus, Barrabaas jamɨt ja chia nam bhaiꞌ ji aagaꞌ na doꞌñchoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Baꞌ xi ja tɨkkaꞌn gu Pilaato nax bhaiꞌx maachim noꞌm sap cham iam jax tɨꞌyaꞌ na doꞌñchoꞌ gu Jesuus, jup ja tɨtda: ―¿Jax japim baꞌ jaꞌk ɨlhiiꞌñ nañ tu chiñiaꞌ nam doodaꞌ dhi Jesuus? Na guꞌ kaiꞌñkam puiꞌ kaiꞌch nar jam gɇꞌkam tuk bɨɨx aapiꞌm yaꞌ dhi Israel. ");
INSERT INTO stpNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Baꞌ gu jaꞌtkam pɨx jiiñak suulh jamɨt, jup tɨtda am gɇꞌ kɨꞌn: ―¡Mu ja chian gum sandaaruiꞌx chuk kum sissappuꞌ kuruus taꞌm! ");
INSERT INTO stpNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Baꞌ gio tɨi muiꞌp ka xi ñio gu Pilaato, jup ja tɨtda: ―¿Tuꞌ gi moo jax dhuu mu paiꞌ ku pim baꞌ moo jaꞌp jix kɨꞌɨɨꞌn? Guꞌ ji nam guꞌ gu jaꞌtkam cham tɇ kɇɇ. Jix ioꞌm gɇꞌ kɨꞌn puiꞌ ba xi chɨtda am: ―¡Mu ja chian gum sandaaruiꞌx chuk kum sissappuꞌ kuruus taꞌm! ");
INSERT INTO stpNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Baꞌ puiꞌ ma doꞌñcho gu Pilaato gu Barrabaas nam baꞌ cham bhaakuꞌ gu jaꞌtkam, nam guꞌ dhiꞌ bhax aaꞌ. Miꞌ dhɨr baꞌ puiꞌ ma ja chia gu sandaaruiꞌx chugiꞌñ nam gɨɨꞌbiaꞌ chipliin kɨꞌn gu Jesuus nam baꞌ miꞌ dhɨr ba sissappuꞌ kuruus taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Baꞌ gu sandaaruiꞌx chugiꞌñ gu Pilaato na mɨt paiꞌ xi gɨbiimɨk gu Jesuus, mu jaꞌk jup bhɨɨk jamɨt gɇꞌ bhiꞌñbak chɨr, miꞌ na paiꞌ gɇꞌx chɨ gɨꞌɨɨr, nax bhaaiꞌ na mi jaꞌp tum oipodaꞌ gu jaꞌtkam bɨɨx xikoolh. Baꞌ gu sandaaruiꞌx guiꞌ na mɨt gɨɨꞌ gu Jesuus, bɨɨx bhaiꞌ ji ja bai mɨt gu jaiꞌ sandaaruiꞌx nam mi jaꞌp jup tuꞌiiꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","baꞌ xi chɨ tɨiꞌdhak jamɨt jix ñakaabmaꞌ, gio na mɨt bhaiꞌ xi dhaaxdhak gu joiꞌ kuruuñchix kam moꞌran. ");
INSERT INTO stpNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Giilhim bhaiꞌ ji chɨtdaimɨ, jup tɨtda am: ―¿Gammɨjɨ aap tɨi ɨlhdhat nap jir ja gɇꞌkam tuk kaꞌ gɨt gu jaꞌtkam yaꞌ dhi Israel? ");
INSERT INTO stpNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Gio na mɨt bhaiꞌ ji gɨbiimɨ moꞌran maaꞌn gu uux tapoorak kɨꞌn, gio nam bha xixbuiꞌñ. Gio baꞌ nam ja oꞌlhia kɨꞌn guꞌngukɨt bɨɨpɨꞌ dɨr pɨx am tum uañiꞌñ, tuꞌ kaꞌm nɨiꞌñ am chi sap panaas, guꞌ jaꞌpji nam miꞌ pɨx xiꞌɨrappu. ");
INSERT INTO stpNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Baꞌ jaꞌxpɨx nam miꞌ puiꞌ xi buimɨk, giop xi chu kookoxchulhdhak jamɨt gux ñakaabmaꞌ na mɨt bɨɨpɨꞌ dɨr tɨ tɨiꞌ, dɨɨlh jajannulhiꞌñ jamɨt baꞌ xi chɨ tɨiꞌdhak ɨp gio, na mɨt baꞌ moo baabuk mɨjɨ dɨr gɇꞌ bhiꞌñbak chɨr ba bhɨɨk na mɨt ba sissapam kuruus taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Baꞌ nam baasɨꞌn ba uaꞌ gu Jesuus na mɨt ba sissapam, maaꞌn bhaiꞌ ka jimchuꞌ gu maaꞌnkam Sireene kam Simoon tɨɨgim, nar taataꞌn gu Alijaanru gio baꞌ gu Ruupu, sap mu paiꞌ dhɨr jaꞌk jimchuꞌ gampɨx. Baꞌ gu sandaaruiꞌx bhaiꞌ dhɨr jaꞌk buak gamaiꞌ chia mɨt na mootikaꞌ gu kuruus, nat guꞌ ba magoo gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Baꞌ bhammɨ ba aich jamɨt gu Jesuus na paiꞌ Golgota tɨ tɨɨꞌ, na jaꞌp kaiꞌñkam jup jum kaiꞌch: Kakoiꞌ Moꞌ Daa. ");
INSERT INTO stpNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Baꞌ jɨꞌkchi gu jaꞌtkam bhammɨ ɇɇk tɨi maak am gu uubas baraaꞌ, bɨnkam gu osbhagaꞌn gu uꞌuux guiꞌ nam mirra kɨꞌn jix mat kaꞌ, na sap baꞌ kɨꞌn cham pɨk tu koꞌk kaꞌ, na guꞌ cham pɨk tu taat kaꞌ gu tukgaꞌn, guꞌ ji na guꞌ cham aaꞌ na iꞌyaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Baꞌ gu sandaaruiꞌx xi chu kookoxchulhdhak jamɨt gu jajannulhiꞌñ, na mɨt baꞌ bhaiꞌ ba sissapa kuruus taꞌm. Miꞌ dhɨr baꞌ dai na mɨt xim mamaiꞌchɨk aꞌlhiok xi chu uꞌuuk. ");
INSERT INTO stpNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bhammɨni jaꞌp moo tɇꞌkob paꞌ ba ji dhuu na mɨt paiꞌ dhuuk bhammɨ sissapa. ");
INSERT INTO stpNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Baꞌ daam dɨr iam na paiꞌ moꞌtɨk gu Jesuus, maaꞌn bhaiꞌp siis jamɨt gu taaꞌmla alhiꞌch komaarak paꞌ, gɇꞌgɇr kɨꞌn bha tu uaꞌñix na sap baꞌ bhaan jix maatɨꞌ kaꞌ na mɨt tuꞌ kɨꞌn jup dooda. Baꞌ jaꞌpnim kaiꞌch guiꞌ na bha tu uaꞌñix: “Dhiꞌñi jir diꞌ guiꞌ nar ja gɇꞌkam tuk bɨɨx gu jaꞌtkam yaꞌ dhi Israel.” ");
INSERT INTO stpNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Baꞌ gook ɨꞌxkum jamɨt bɨɨmaꞌn bhaiꞌ sissapa bɨxxik dɨr jaiꞌ kukrus taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Baꞌ dhiꞌ nat puiꞌ jɨꞌ tum duu, nat jax dhuuk pɨx jum kuugalh gu ñioꞌkiꞌñ gu Dios na jax tu uaꞌñix mi uꞌuan taꞌm nap jum kaiꞌch na guch Xoiꞌkam tuꞌ pɨx ɨlhdhaꞌ am gu jaꞌtkam, puiꞌ na jax gu jaroiꞌ noꞌ cham tuꞌ kaꞌm tɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Baꞌ jaiꞌ dhɨt gu jaꞌtkam mi jaꞌp amuub buanɨt giilhim tɨtdaidhaꞌ am bhaiꞌ xi ñɨidhidhat, am gagai buppaidhaꞌ am gu ja moom. Jaꞌpnim moo tɨtda: ―Jaña nap jax chuꞌiiꞌ aap nap saak iarai gu gɇꞌ chiop baik tanoolh kɨꞌn gio jumai bhaiꞌp kɨɨsaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Eap xi chɨmiiñ bhaiꞌ dhɨr dhi kuruus taꞌm nach xim nɨiꞌñdhaꞌ noꞌp baabuiꞌ moox ioꞌm jir gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Baꞌ gu ja gɇꞌgɇrkam tuk guiꞌ nam jaiꞌ ja palhbuiꞌñdhaꞌ gu Israel kam jaꞌtkam nam tu daandaꞌ buiñor gu Dios, gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, ba xi jii mɨt ɨp nam giilhim aꞌga gu Jesuus, jup kaiꞌch am gɇꞌ kɨꞌn ja kaixdhat: ―Gi jax ji nat baꞌ guꞌ gu jaiꞌ jaꞌtkam ja palhbui, dɨɨlh baꞌ moo jaꞌp cham jup bhaiꞌ ji jia na jax dhuim palhbuidhaꞌ xib na bhaiꞌ sissap. ");
INSERT INTO stpNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Noꞌ gɨt jich ñɨiꞌñchudat bhaiꞌ dhɨr bhaiꞌ ji chɨmñiaꞌ dhiꞌ na saak jir jich Xoiꞌkam, na saak jir jich gɇꞌkam tuk bɨɨx aach yaꞌ dhi Israel, dho gi guꞌ bɨɨx tɨ jɨɨꞌñdhaꞌch gɨt ji buiñor. Baꞌ guiꞌ nam bhaiꞌ bɨɨmaꞌn sissap pɨx am jup bhakkuꞌ am buiñor, jax ñam pɨx chɨtda. ");
INSERT INTO stpNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Baꞌ nat jix dhaam ba ji dhuu, bhaiꞌ ji chum tukgamta, pu cham paiꞌ ka tu maax jaꞌp na jax noꞌr tukaaꞌ, attiiru puiꞌ mia ba ji dhuu nat baꞌ giop ba tu maaxir. ");
INSERT INTO stpNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Baꞌ nat jax kiaꞌpɨx gio bhaiꞌp ji chu maaxir, gɇꞌ kɨꞌn jup kaiꞌch gu Jesuus: ―Eloi, Eloi, ¿lama sabaktani? ―na jaꞌp kaiꞌñkam jup jum kaiꞌch: Dios jiñ Gɨꞌkoraꞌ, ¿jax kup baꞌ cham jiñ aꞌm ka tɨ nɨidhim? Tɨɨꞌ na mɨt jax jiñ dhooda. ");
INSERT INTO stpNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Baꞌp kaiꞌch am guiꞌ nam miꞌp tuꞌiiꞌ nam kɇɇ: ―Ka gɨt na tɨi baiꞌñ gu Eliiyas guiꞌ nat bɨjɨk ya jaꞌp bhaankam tu aꞌgimɨk gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Baꞌ maadɨt guiꞌ nam miꞌp tuꞌiiꞌ jup kaiꞌch: ―Ea nach nɨɨradaꞌ gu Eliiyas noꞌ bha jim na tɨbaañdhaꞌ. Na guꞌ jaꞌp jum aaꞌ na dhiꞌ baiꞌñ gu Jesuus nat gɇꞌ kɨꞌn tu aꞌga. Baꞌ puiꞌ xi chɨꞌɨɨk, jotmodaꞌ xi baꞌnnidhak maaꞌn gux moik jaꞌp na tok kɨꞌn gu uubas bargaꞌn jix jɨꞌɨɨk, uux chaꞌm xi ɨxkunak muiꞌ xi maa chiñiꞌran gu Jesuus na sap baꞌ xioꞌpnaꞌ na kɨꞌn kapup xi dhuatgɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Guꞌ ji nat guꞌ naiꞌ ji muu, dai nat gɇꞌ kɨꞌn xi jiiñkɨk. ");
INSERT INTO stpNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Baꞌ nat jax muu gu Jesuus, gu jannulh gu gɇꞌx kabook na mu sɇꞌkaꞌ ɨrban dɨr gu gɇꞌ chiop, pu ɨrban sar. Daam dɨr dɨr muiꞌ ji sar, mɨjɨmmɨ ji chɨm. ");
INSERT INTO stpNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Baꞌ guiꞌ nar ja moꞌ kaꞌ gu sandaaruiꞌx nɨiꞌñ nat gɇꞌ kɨꞌn xi jiiñkɨk gu Jesuus nat ba muu, baꞌp kaiꞌch: ―Bak ji guꞌ sɨlhkam ji na Dios jir Maraaꞌn kat dhi jaduuñ na baꞌ saak puiꞌ kaiꞌch nar gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Baꞌ jaiꞌ gu uꞌuub mɨk paꞌ guguukat muiꞌp nɨiꞌñ am. Maadɨt moor diꞌ guiꞌ na Mariiya Magdalena tɨɨꞌ, gio gu jumai Mariiya, guiꞌ nar ja naan gu Josee gio gu Jakoobo, guiꞌ nam gatuuk kam kɨꞌn jix mat kaꞌ, gio baꞌ jumai ɨp gu ubii Salomee tɨɨgim. ");
INSERT INTO stpNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Baꞌ dhiꞌ dhi uꞌuub jir diꞌ am guiꞌ nam gammɨjɨ bɨɨx jup xi jiimdaꞌ mu jaꞌp Galilea, na paiꞌ jax tu ja aꞌgidhidhaꞌ gu Jesuus gu jaꞌtkam, nam palhbuidhidhaꞌ nam mu bhɨidhidhaꞌ na tuꞌm aagidhaꞌ. Gio jaiꞌ muiꞌ gu uꞌuub nam miꞌp tuꞌiiꞌ, guiꞌ na mɨt bha oi ɨp janoꞌ nat jax bha ai Jerusaleen. ");
INSERT INTO stpNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Baꞌ mɨkkat nat paiꞌ ba tuk nam baꞌ moox kɨɨꞌ bam duñiaꞌ gu Israel kam jaꞌtkam, na guꞌ buimgidhak cham ka tum juandaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","miꞌ ba ai maaꞌn gu maaꞌnkam Arimatea kam, Josee tɨɨgim. Dhiꞌ maadɨt jir ja gɇꞌkam tuk kaꞌ gu Israel kam jaꞌtkam. Jir jix bhaiꞌkam kaꞌ, na guꞌ puiꞌ tɨip nɨɨradaꞌ guch Xoiꞌkam na paiꞌ dhuuk yaꞌ aayaꞌ dhi oiꞌñgaꞌn. Baꞌ juraaꞌn xi dhaasak muiꞌ ma jii na paiꞌ daa gux kaiꞌ Pilaato, nat tɨkkam noꞌx bhaiꞌ na tɨbaañdhai yaasparaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Baꞌ bhammɨ ɇɇk puiꞌ ba tɨtda. Miꞌ puiꞌ pup tuꞌiiꞌ gu Pilaato, na guꞌ cham ɨlhdhat noꞌ jotmodaꞌ mukiaꞌ gɨt. Baꞌ ba baiꞌñ guiꞌ nar ja moꞌ kaꞌ gu sandaaruiꞌx, nat miꞌ ai baꞌ xi chɨkka noꞌr sɨlhkam nat ba muu gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Baꞌ guiꞌp kaiꞌch nar sɨlhkam. Baꞌp tɨtda gu Pilaato gu Josee nax bhaaiꞌ na tɨbaañdhai ba bhɨikaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Baꞌ gu Josee xi sabaꞌdak maaꞌn gɇꞌ gu jannulh jix dhaꞌram namkɨm, kɨꞌn xi bhiibgak mummu tɨkaam jamɨt gai dɨꞌn kɨr, mu nat paiꞌ tɨm dɨgaar bɨɨpɨꞌ dɨr jix moik aiꞌ chaꞌm, gio baꞌ na mɨt bhaiꞌ xi kuupak maaꞌn gu gɇꞌ jodai kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Baꞌ gu Mariiya Magdalena, gio gu jumai Mariiya guiꞌ nam jax maap ba jiimdaꞌ, nɨiꞌñ am na mɨt paiꞌ tɨɨ gu tukgaꞌn gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Baꞌ mɨkkat nat ba buus gu tanoolh na cham tum juanat, gu Mariiya Magdalena, gio gu jumai Mariiya guiꞌ nar dɨꞌɨɨꞌn gu Jakoobo, gio baꞌ gu jumai gu ubii guiꞌ na Salomee tɨɨꞌ, ba tu sabaꞌlh jamɨt guiꞌ na joidham uub nam sap mu juulhdhapuꞌ gu tukgaꞌn gu Jesuus mu na paiꞌ kaat, na sap baꞌ cham giilhim uub kaꞌ na bhaiꞌ ji dhɨbaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Baꞌ tumiiñku taꞌm jix kɨꞌnkob nat kiaꞌpɨx bhaiꞌ ba ji chon, muiꞌ ma jii mɨt mummu dɨꞌn kɨr, nam guꞌ jaꞌp jum aaꞌ na pui mu kaat gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Baꞌ nam nammɨ gama jaꞌk ba jiimchuꞌ, jup kaiꞌchim am: ―¿Jarooch baꞌ umuaꞌñdhaꞌ na jaꞌk daasaꞌ gu jodai guiꞌ na kɨꞌn bha kuup? Nach guꞌ aach cham nakooꞌ nach jax dhui jaꞌk daasaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Guꞌ ji na guꞌ na mɨt mu ba ai, miꞌ pɨx kupioꞌkix, jaꞌp gai dhɨr pɨx dhaa gu jodai gu gɇꞌ na kɨꞌn bha kuupich. ");
INSERT INTO stpNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Baꞌ guiꞌ dai na mɨt jiimɨt pu baap bhɨjɨ dɨꞌn kɨr, baꞌ mɨjɨ pɨx ji chɨɨ mɨt na daa maaꞌn gu biapmaꞌ tɇb kutuun am jix chua, kɨɨꞌn dɨr daa miꞌ na paiꞌ kaatɨt gu Jesuus. Ku guꞌ cham tuꞌr maaꞌnkam ji, jaꞌpji gu nobiiꞌñ guch Gɨꞌkoraꞌ jix dhaam kam. Baꞌ giilhim jix chootoꞌn jamɨt, ");
INSERT INTO stpNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","guꞌ ji nat guꞌ jotmodaꞌ bha ñio, jup ja tɨtda: ―Chaꞌpim totdon kaꞌ. ¿Jesuus Nasareet kam aa pimɨt tɨi gio bhaiꞌp ba tɨɨgim, guiꞌ na mɨt bas takaab bhammɨ sissapa kuruus taꞌm? Ba jii ji bo, nat guꞌ giop ba dua. Cham tuꞌ ka muukix. Ka gor miꞌ xi chɨ tɨɨꞌ na paiꞌ kaatɨt na cham paiꞌ tu jaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cham tuꞌ ji na pim jix buam jum aagɨt yɨjɨ ka tɨ nɨnɨiꞌñdhaꞌ dɨꞌn kɨr, jaꞌpji dai na pim ja aaꞌñdhapuꞌ gu noonbiꞌñ, puiꞌ na jax gu Peegro. Jaꞌp japim tɨɨdaꞌ nat giop ba dua gu Jesuus, mummu jaꞌk japim ba tɨgiaꞌ Galilea na ba oirɨdaꞌ, puiꞌ na jax ba jam tɨtda bɨɨpɨꞌ dɨr nam baꞌ moo daagɨi ba muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Baꞌ guiꞌ bubuakɨk pu jiboiꞌññor jamɨt giꞌbukidhat, na mɨt guꞌ giilhim jix chootoꞌn. Pu cham jaroiꞌ aagiꞌñ am na mɨt jax tɨ tɨɨ, nam guꞌ daix juraapgixchuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Baꞌ jaꞌxpɨx cham mɨɨkim mu bam maax gu Jesuus buiñor gu Mariiya Magdalena, guiꞌ nat xijum gook maiꞌ joochxi gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ bhaiꞌ dhɨr bhaan na kɨꞌn jix ñaanbiꞌ kat. ");
INSERT INTO stpNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Miꞌ dhɨr baꞌ xi mɨɨ nat ja aaꞌñdham gu jaiꞌ guiꞌ nam puiꞌp tɨ jɨɨgiꞌñ buiñor gu Jesuus mu nam paiꞌ daraat suan nam jix buam jum aaꞌ nat sap muu. ");
INSERT INTO stpNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Baꞌ mu ɇɇk tɨi ba ja aagiꞌñ nat giop ba dua. Tɨip ja tɨtda nat maaxik tɨɨ, pu cham jɨɨgiꞌñ am. ");
INSERT INTO stpNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Baꞌx ioꞌm jaꞌxpɨx mummu jaꞌk jup bam maax gu Jesuus ja bui gook gu jaꞌtkam tugiꞌñ nam mu jaꞌp ka jiimchuꞌ bɨɨx boi. Dai na maakam tuꞌm, cham ob maatɨt tɨɨ mɨt. ");
INSERT INTO stpNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Baꞌ guiꞌ tɨip xi boop jamɨt na mɨt ja aaꞌñdham gu jaiꞌ. Puiꞌ cham jup jɨɨgiꞌñ am. ");
INSERT INTO stpNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Baꞌ mɨkkat mummu bam maax dho gi ji baꞌ gu Jesuus ja bui gu mambhɨɨx daman maaꞌn gu noonbiꞌñ, mu nam paiꞌ daraat ka tu kuaꞌ. Baꞌ pɨx am ja ñiokiꞌñ, tuꞌ sap ku baꞌ moo jaꞌp jix kaapak gu ja jujur nam baꞌ cham ja jɨɨgiꞌñ nam tɨi ja aagiꞌñ guiꞌ na mɨt bɨɨpɨꞌ dɨr tɨɨ nat giop ba dua. ");
INSERT INTO stpNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Miꞌ dhɨr baꞌp ja tɨtda: ―Baꞌ xib dɨr tuꞌ na jax chuiꞌkaꞌ, naiꞌ pim xi jimiaꞌ jiñ jaaduñ na jɨꞌx oiꞌñgaꞌn na pim tu ja aꞌgiꞌñpuꞌ jiñ aꞌmkam dappaam na jɨꞌk jaꞌtkam gux bhaiꞌm kaiꞌchdham ñiꞌook. ");
INSERT INTO stpNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Baꞌ guiꞌ nam jɨꞌk tɨ jɨɨꞌñdhai bam bopkonaꞌ, dai nam ba jimiaꞌ jix dhaam jaꞌk. Guꞌ baꞌ guiꞌ nam jɨꞌk cham tɨ jɨɨgiꞌñdhaꞌ, pɨx am tɨꞌñchukaꞌ am nam gammɨjɨm tulhiiñaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Gam guiꞌ nam tuꞌ sɨlhkam tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui, ja makiaꞌ iñ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ nam baꞌ kɨꞌn maiꞌ ja jootsaꞌ jiñ aꞌmkam gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gu jaꞌtkam, gio baꞌ nam kɨꞌn tu aꞌgadaꞌ jaiꞌ gu ñiꞌook na baꞌ bhaan jix maatɨꞌ kaꞌ nañ aañ ja aꞌm tɨ nɨidhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Gio baꞌ na cham jɨꞌxkat iaꞌñdhaꞌ noꞌt tuꞌ koꞌ ba kɨi maadɨt. Piam noꞌt jax dhuuk juu gu paꞌch, cham tuꞌ maimtudaꞌ. Gio baꞌ nam ja duduadhiꞌñdhaꞌ gux kakoꞌkkam, dai nam bhaiꞌ pɨx xi ja daꞌngɨdaꞌ, pu duduardaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Baꞌ daipuꞌ na jax puiꞌ jɨꞌ xi chu ja aꞌgidhimɨk gu Jesuus, pu jiix dhaam jaꞌk, baꞌ bhammɨ ji dhaibu kɨɨꞌn dɨr sonpan gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Baꞌ gu noonbiꞌñ naiꞌp ji jii mɨt na mɨt tu ja aꞌgidham gu jaꞌtkam gux bhaiꞌm kaiꞌchdham ñiꞌook na jax baꞌ ba tum aꞌgichuꞌ sia gu xib. Jix bhaiꞌ dho tu buimɨk am gu tuꞌ nax bhaiꞌr jum duukam, na guꞌ guch Xoiꞌkam pɨx jup tu duiñchuꞌ na jax ba ja tɨtda bɨɨpɨꞌ dɨr nat baꞌ moo ba jii jix dhaam jaꞌk.");
INSERT INTO stpNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Muiꞌ dhɨt gu jaꞌtkam tu uꞌuantuꞌ am nam tu daasaim na jɨꞌk tuꞌ jax buimɨk guch Xoiꞌkam janoꞌ na yaꞌ xi oilhimɨk aach jich bui. ");
INSERT INTO stpNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Puiꞌ jaꞌk tu daasaim am nam jax ja aagiꞌñ guiꞌ na mɨt maaxik ja buupui kɨꞌn tɨ tɨɨ nammɨ dɨr nat jax bhaiꞌ ji oilhimɨ guch Xoiꞌkam, nat guꞌ dhiꞌ baꞌ ja aꞌm bii nam naiꞌ puiꞌ tu ja aꞌgidhaꞌ gu jaꞌtkam, puiꞌ kuch baꞌ aach puiꞌp bax chu maat jaiꞌ dhɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Guꞌ baꞌ aañ jup mañ guguux nañ tum uaꞌñxidhaꞌ aap jiñ jaduuñ Tiopil nañ kapbhaiꞌ bax maat nat jax tu duuk guch Xoiꞌkam gio nat jax pɨk jaꞌk jum duu dɨɨlh, na ñich guꞌx bhaiꞌ xi chɨ tɨkkaimɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Puꞌñi jaꞌk jap dho gi baꞌ guꞌx ioꞌm jix bhaiꞌ puiꞌ bax chu mat kaꞌ ji nam jax jup tum aꞌgiꞌñ jaiꞌ dhɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Janoꞌ na gu Eroodis bhaiꞌr gɇꞌkam kaꞌ na jɨꞌx Judea bhaan bipioꞌ gu dɨbɨɨr, maaꞌn janoꞌp jix jaiꞌch kaꞌ gu maaꞌnkam Sakariiyas tɨɨgim na ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam bhammɨ gɇꞌ chiop. Jɨꞌk jam maap jim daagɨt dai pu chuutuꞌm Abiiyas jum tɨɨtɨꞌndaꞌ, nam guꞌr bopxiꞌñ kaꞌ gu Abiiyas. Baꞌ Isabeel tɨɨꞌnkaꞌ gu bɨngaꞌn gu Sakariiyas, dhiꞌr boxiiꞌñ kaꞌ ɨp gu Aroon. ");
INSERT INTO stpNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Baꞌ daim bɨpnagɨm miꞌ puiꞌ jiimdaꞌ am na jax jix aaꞌ gu Dios, miꞌ puiꞌ tu duiñchuꞌndaꞌ am na jax tu aagix kaꞌ, nam guꞌ tuꞌ kaꞌm nɨiꞌñdhaꞌ gu Dios. Sia bɨɨx gu jaꞌtkam jaiꞌp jix mat kaꞌ am nam tuꞌ kaꞌm tɨ nɨiꞌñdhaꞌ, cham baꞌ paiꞌ jaroiꞌ tuꞌ kɨꞌn jax ja tɨtdadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Baꞌ cham jup tu maamar kaꞌ am, na guꞌ gu Isabeel cham jir aiꞌñ kaꞌ gu aꞌaalh, ku guꞌ bar jagɨꞌgɨr kaꞌ am ji. ");
INSERT INTO stpNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Baꞌ maaꞌnnim giop mam ai na paiꞌ dhuuk mu jimiaꞌ gu Sakariiyas bhammɨ gɇꞌ chiop nam gio maap jup jum jumpadaꞌ guiꞌ nam jɨꞌk maap jum daaꞌnkaꞌ dai pu chuutuꞌm. ");
INSERT INTO stpNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Baꞌ bhammɨ na mɨt bɨɨx maap xim jumpadak, bɨɨpɨꞌ mɨt xim mamaiꞌchɨk na baꞌ bhaan matgilhiaꞌ nam tuꞌ jax dhuñiaꞌ bɨɨx jɨꞌmaꞌn, nam guꞌ puiꞌ jaꞌk pu buadaꞌ gammɨjɨ nam bɨɨpɨꞌ xim mamaiꞌchɨi. Baꞌ bhaan ji bii gu Sakariiyas na bhɨjɨ tu kubhionaꞌ na paiꞌx chu xidhuu kɨꞌn guiꞌ na joidham uub. ");
INSERT INTO stpNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Baꞌ na paiꞌ bhɨjɨ ba tu kubhion gu Sakariiyas, gu jaꞌtkam miꞌ dhɨr jaꞌk tu daañchuꞌ am nam paiꞌ pum jumpaꞌndaꞌ gammɨjɨ, na guꞌ tuukab jaꞌk bipioꞌ na paiꞌx chu xidhuu. ");
INSERT INTO stpNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Baꞌ jotmodaꞌ maaꞌn miꞌ bam maax gu nobiiꞌñ gu Dios na paiꞌ ka tu kubhion gu Sakariiyas, kɨɨꞌn dɨr jaꞌk jum maax miꞌ na paiꞌ kɨɨk gu gɇꞌ kubhioñkar. ");
INSERT INTO stpNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Baꞌ giilhim jix chooꞌn nat ba tɨɨ, cham ka bhaaiꞌ na jax jum duñiaꞌ, dai na bhaiꞌ pup nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Baꞌp kaiꞌch gu nobiiꞌñ gu Dios: ―Chaꞌp toodon kaꞌ Sakariiyas, na ñich guꞌ aañ bhaiꞌ pɨx jum aaꞌñdham nat gu Dios jum kai na pich jax puiꞌ tɨɨꞌn. Baꞌ tɨgiaꞌ maaꞌn gu alhii gum bɨɨnaꞌ, Juan jap baꞌ tɨɨtgaꞌ na paiꞌ dhuuk maaxilhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Aap gɇꞌkam kɨꞌn jix bhaiꞌm ɨlhdhaꞌ janoꞌ na paiꞌ dhuuk maaxilhiaꞌ, sia muiꞌ gu jaꞌtkam puiꞌx bhaiꞌp jum ɨlhdhaꞌ am jaꞌp na jax aap, ");
INSERT INTO stpNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","na guꞌ gu jam alhii chuk yaꞌr gɇꞌkam kaꞌ bhaankam gu Dios. Gio cham jɨꞌxdhaꞌ iꞌyaꞌ gu jax chuꞌm biiñ, gio na pu bɨɨpɨꞌ dɨr bhaan bam tajaanaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdagaꞌn gu Dios na ɨraab dɨr kap tuiꞌñgɨdaꞌ gu dɨꞌɨɨꞌn na baꞌ miꞌ dhɨr ba maaxilhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dai baꞌ na bhaiꞌ ji chu ja aꞌgidhaꞌ gu Israel kam jaꞌtkam nam miꞌ puiꞌ ba jimiaꞌ na jax jix aaꞌ gu Dios guiꞌ na pur ja Dios tuk bɨjɨk dɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dhiꞌ baꞌ jaꞌp ji buusniaꞌ na bɨɨpɨꞌ ya jaꞌp ba tu boiꞌntaꞌ na baꞌ cham ka xijai kaꞌ na yaꞌ bhɨɨyaꞌ gux ioꞌm Gɇꞌkam na cham xiim bhaiꞌp jim gatuuk dɨr. Na guꞌ ampɨk maaꞌn ñiꞌook bap ja duñiaꞌ gu jaꞌtkam nam ka xim bhabhaakuiꞌñdhaꞌ, puiꞌ na jax noꞌm ja bui kax bhaak gu ja maamar, piam ku guꞌ mu dɨr bha jaꞌk gu ja maamar ja bui kax bhaak am gu ja tataat. Sia bɨɨx guiꞌ nam jix bhaak kaꞌ pɨx nam cham ji aagɨt nam miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ gu Dios na ja jɨjɨkgɨtdai miꞌ ja tuttuꞌ na paiꞌx bhaiꞌ ba tu ja jimdaꞌ. Gu Juan bhaan tajaañixchuꞌndaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdagaꞌn gu Dios, pu chuꞌm ɨp na jax chuꞌm bhaan tajaañixchuꞌndat bɨjɨk gu Eliiyas guiꞌ na bhaankamuꞌn gu Dios ya jaꞌp tu ja aꞌgidhimɨk gu jaꞌtkam. Gam na bɨxchuꞌx bhaaiꞌn kaꞌ gu tuꞌ na jax dhuñiaꞌ, na ni jaroiꞌ ku cham jɨꞌxdhaꞌ pu duñiaꞌ gu dɨɨlh pɨx, na guꞌ sia pu chuꞌm bhaan jup tajaañix kaꞌ na jax chuꞌm Eliiyas bhaan jup tajaañix kat bɨjɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Baꞌp kaiꞌch gu Sakariiyas: ―¿Siamri chi baꞌr sɨlhkam aa na puiꞌ tɨgiaꞌ gu alhii guñ bɨɨnaꞌ? Jax dhui nach guꞌ moo xiꞌ pɨk jup bar jagɨꞌgɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Baꞌ gu nobiiꞌñ gu Dios jup tɨtda: ―Jaꞌpji nañ guꞌ aañ sɨlhkam yaꞌ puiꞌm tɨtda, cham tuꞌp jax jum aaꞌndaꞌ nañ puiꞌ pɨx kaiꞌch. Jir nobiiꞌñ iñ guꞌ aañ gu Dios. Aañ jir diꞌ nañ Gabrial tɨɨꞌ. Guiꞌ pɨx bhañ joot nañ yaꞌm aagiꞌñdhaꞌ na jax jix bhaiꞌ kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Guꞌ xib baꞌ tuꞌ na jax chuiꞌkaꞌ, nap guꞌ cham jiñ jɨɨgiꞌñ, cham ka tu ñiokdaꞌ ap janoꞌ juugɨt na paiꞌ dhuuk maaxilhiaꞌ gu jam alhii chuk. Baꞌ pu jii gu nobiiꞌñ gu Dios puiꞌ xi chɨɨdak gu Sakariiyas. ");
INSERT INTO stpNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Guꞌ baꞌ gu jaꞌtkam guiꞌ nam baas dɨr jaꞌp jup ka tu daanɨt, tɨi pɨx gan bam juan am na cham paiꞌ dhɨr ka buusnim gu Sakariiyas. Tɨi bam tɨ tɨkka am na sap jax kut baꞌ ba mɨɨkim. ");
INSERT INTO stpNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mɨkkat baꞌ siamri bhɨjɨ dɨr ba ji buus. Pu cham bhaaiꞌ na jax dhui tu aꞌgaꞌ, dai gu noonbiꞌñ kɨꞌn pɨx jaꞌp tɨi tu bua na tu ja aꞌgiꞌñ. Baꞌ gu jaꞌtkam jotmodaꞌ puiꞌm aa mɨt ɨp nat jax ji nat tɨ tɨɨ bhɨjɨ na ka baax na paiꞌx ioꞌm jix chu xidhuu kut baꞌ puiꞌm duu, cham tuꞌ gu jaꞌp pɨx. Puiꞌ baꞌ cham tu ñiokdaꞌ gu Sakariiyas, dai noonbiꞌñ kɨꞌn pɨx jaꞌp tu buadaꞌ na paiꞌ dhuuk tu aꞌgadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Baꞌ nat paiꞌ dhuuk jum ai na jɨꞌk tanoolh tu daaxix kaꞌ nam bhaiꞌ juruuñdhaꞌ gɇꞌ chiop nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, ba jii ɨp gio mu kiaꞌmiꞌñ gu Sakariiyas. ");
INSERT INTO stpNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Baꞌ jɨꞌk jurniꞌñ kɨꞌn bar alhiꞌch kɨɨkam gu bɨngaꞌn Isabeel, dai baꞌ nat cham paiꞌ ka paxiarax chamaam masaaꞌn nat dɨr puiꞌ jim duu. Baꞌp jum aaꞌndaꞌ: ");
INSERT INTO stpNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Gu Dios pɨx jup tu duu nañ baꞌ bar alhiꞌch kɨɨkam, na guꞌ dhiꞌ puꞌñi jaꞌk baꞌ cham gampaiꞌ kañ ɨlhiiꞌñdhaꞌ am gu jaꞌtkam noꞌñ maaꞌn ba tu mar.” ");
INSERT INTO stpNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Baꞌ na paiꞌ xijum maaꞌn masaaꞌn ba uaꞌ nar alhiꞌch kɨɨkam gu Isabeel, gu Dios gio mu jaꞌk jup joot gu nobiiꞌñ Gabrial na paiꞌ Nasareet tɨ tɨɨꞌ, na Galilea bhaan bipioꞌ guiꞌ gu dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mu joot na paxiartuꞌnmɨraꞌ maaꞌn gu ubii tɨyaa Mariiya tɨɨgim, guiꞌ nat puiꞌ ba tɨɨꞌn maaꞌn gu biapmaꞌ Josee tɨɨgim na bɨɨmaꞌn jum tɨɨmoꞌ nam maap tu oiꞌñchaꞌ. Gu Josee jir boxiiꞌñ kaꞌ gu Dabii guiꞌ nax ioꞌm jir gɇꞌkam kat bɨjɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Baꞌ mummɨ ba ji buus na paiꞌp tuꞌiiꞌ gu Mariiya, jotmodaꞌ bha jaꞌp bam maax mi baꞌk chɨr. Baꞌp tɨtda: ―Aañ bha jaꞌk ɨp jiñ jaduuñ. Aañ bham aaꞌñdham nat gu Dios gɇꞌkam kɨꞌn jum aꞌm ba tɨ tɨɨ na cham jax chuꞌm ubii jaꞌxbuiꞌ puiꞌ gɇꞌkam bhaan tɨ nɨnɨidhat. ");
INSERT INTO stpNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Baꞌ giilhim jix chooꞌn gu Mariiya nat ba tɨɨ, gio nat gampaiꞌ ji dhuu puiꞌ nat jax jaꞌk tɨɨdak ñioꞌki. Miꞌ jotmodaꞌ tɨi xim gaꞌnga na jax jir jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Baꞌp tɨtda ɨp gio gu nobiiꞌñ gu Dios: ―Chaꞌp jax jum aaꞌndaꞌ Mariiya. Jix bhaiꞌp pɨx bam taat kaꞌ, nat guꞌ gɇꞌkam kɨꞌn jum aꞌm ba tɨ tɨɨ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Baꞌ tɨgiaꞌ ap maaꞌn gu alhii chioꞌñ, xib dɨr jap muiꞌ jir alhiꞌch kɨɨkam kaꞌ. Jesuus jap baꞌ tɨɨtgaꞌ na paiꞌ dhuuk maaxilhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dhiꞌ jix ioꞌm jir gɇꞌkam kaꞌ yaꞌ dhi oiꞌñgaꞌn, na guꞌ gu Dios pɨx dɨɨlh gɇꞌkam kɨꞌn daasaꞌ na jax gu boxiiꞌñ Dabii nat puiꞌ gɇꞌkam kɨꞌn jup daasak bɨjɨk. Baꞌ maraaꞌn gu Gɇꞌkam Dios kɨꞌn jix mat kaꞌ am gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Baꞌ gammɨjɨ pup jir ja gɇꞌkam tuk kaꞌ gu Israel kam jaꞌtkam, cham jɨꞌxkat jum tɨɨmoꞌ nar gɇꞌkam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Baꞌ gu Mariiya xi chɨkka gu nobiiꞌñ gu Dios, jup tɨtda: ―¿Jax jañ baꞌ dui tɨgiaꞌ gu alhii, nañ guꞌ aañ chakui chioꞌñ bɨɨmaꞌn daa? ");
INSERT INTO stpNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Baꞌ gu nobiiꞌñ gu Dios jup tɨtda: ―Dho na guꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ jum aꞌm jum tajaanaꞌ nar ɨkgigaꞌn gu Gɇꞌkam Dios, na guꞌ dhiꞌ jaꞌp ji buusan na jax gu tɨbaaꞌ na tɨ ɨkgiꞌ. Gu Dios pɨx dɨɨlh jup tu duñiaꞌ, na guꞌx ioꞌm jir gɇꞌkam, bɨxchuꞌx bhaaiꞌ na pu tu duñiaꞌ. Puiꞌ kum baꞌ Gɇꞌkam Dios maraaꞌn kɨꞌn machiaꞌ gu jaꞌtkam dhiꞌ dhi alhii chioꞌñ janoꞌ na paiꞌ dhuuk maaxirɨi yaꞌ ba oirɨdaꞌ, na guꞌ gam nax uañ kɨꞌn ya oirɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Gio gu Isabeel na pim iam pɨx jir jum jajaaꞌnnim, puiꞌp bar alhiꞌch kɨɨkam, xijum maaꞌn masaaꞌn ba uaꞌ na dɨr puiꞌ ba tuꞌiiꞌ, sia ku guꞌ panaas tɨi bar jagɨꞌ, gam nam jup aꞌgadaꞌ gu jaꞌtkam na cham jir aiꞌñ gu aꞌaalh. ");
INSERT INTO stpNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Jax dhui na guꞌ gu Dios cham tuꞌ xijai kam ɨlhiiꞌñ gu tuꞌ na jax dhuñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Baꞌp kaiꞌch gu Mariiya: ―Ea na puiꞌ tu duñiaꞌ gu Dios nap jax jiñ chɨtda, nañ guꞌ aañ jir tujuandam tugiꞌñ pɨx. Baꞌ pu jii gu nobiiꞌñ gu Dios nat puiꞌ xi chɨɨdak gu Mariiya. ");
INSERT INTO stpNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Baꞌ janoꞌ xim jotmaꞌñ nat mu jii gu Mariiya maaꞌn kap na paiꞌ muiꞌ daaꞌñxim jir kikcham gam na gɇꞌr jukgam, Judea bhaan bipioꞌ guiꞌ gu dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mu jii nat paxiartudam gu Isabeel nam iam pɨx jir jum jajaaꞌnnim gook dɨt, na guꞌ bhammɨ kiokaꞌ gu Sakariiyas. Baꞌ bhammɨ nat ɇɇk gu Mariiya, mu baakɨk baꞌk chɨr muiꞌ xi ñioꞌki gu Isabeel. ");
INSERT INTO stpNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Baꞌ nat kai gu Isabeel nat mu tu ñioꞌki gu Mariiya, jotmodaꞌ joi gu alhii na ɨraab dɨr uaꞌ. Baꞌ miꞌ jotmodaꞌ joidham jix bhaiꞌ bhaiꞌ jim ɨlh gu Isabeel, nat guꞌ gɇꞌ bhaan bam tajaa gux Dhuuduꞌ kam jix Uañ Iiꞌmdagaꞌn gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Baꞌp kaiꞌch gɇꞌ kɨꞌn: ―¡Aa guꞌ gɇꞌkam kɨꞌn bhaan tɨ nɨidhim ji jia gu Dios gum alhii chuk nap jum ɨraab dɨr uaꞌ! Jaꞌp moox bhaiꞌ tum jii, na guꞌ cham jax chuꞌm ubii jaꞌxbuiꞌ puiꞌ gɇꞌkam kɨꞌn bhaan tɨ nɨnɨidhat na jax aap. ");
INSERT INTO stpNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Aañ baꞌ jax jup jiñ ɨlhiiꞌñ nat baꞌ jaꞌkbuiꞌ kat bhaiꞌp jiñ chɨɨgim gu dɨꞌɨɨꞌn guñ Gɇꞌkam tuk? ");
INSERT INTO stpNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Na guꞌ na ñich jum kai na pich bha tu ñioꞌki, jotmodaꞌ joi guñ alhii chuk nañ jiñ ɨraab dɨr uaꞌ nat jix bhaiꞌm ɨlh. ");
INSERT INTO stpNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Jaꞌp moo joidham jix bhaiꞌm duu na pich bɨɨx jum jur kɨꞌn tɨ jɨɨꞌñ na puiꞌ tum duñiaꞌ na jax jum tɨtda guch Gɇꞌkam tuk! ");
INSERT INTO stpNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Baꞌp kaiꞌch ɨp gu Mariiya: Dho guꞌ aañ jiñ iiꞌmdaꞌ bhaan gɇꞌkamtuꞌn ji gu Dios, ");
INSERT INTO stpNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","nañ guꞌx bhaiꞌñ chaat nat ba uana guñ uaꞌtulhdharaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","gam nat gɇꞌkam kɨꞌn jiñ aꞌm tɨ tɨɨ nañ tɨi gampaiꞌ tuꞌm aañ nañ jir tujuandam tugiꞌñ. Baꞌ xib dɨr gammɨjɨ jaꞌk puiꞌ pup jiñ chɨtdadaꞌ am gu jaꞌtkam nat joidham jix bhaiꞌ tuñ jii. ");
INSERT INTO stpNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bɨxchuꞌ gɇꞌgɇr jup tum duuꞌnkam jiñ bui bap tu duu guꞌ gu Dios na bɨxchuꞌx bhaaiꞌ na pu tu duñiaꞌ, na guꞌ giilhim jir jix uañ guiꞌ na puiꞌ tɨɨꞌ Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Na guꞌx ja joiꞌmdat ja aꞌm tɨ nɨidhidhaꞌ gu Dios guiꞌ nam miꞌ puiꞌ jiimdaꞌ na jax jix aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jix ioꞌm jir gɇꞌkam guꞌ, bɨxchuꞌx bhaaiꞌ na pu tu duñiaꞌ na jax ɨlhiiꞌñdhaꞌ. Tɨɨꞌ nat mɨk ja buiꞌñchulh nam jax kam aaꞌndaꞌ guiꞌ nam jaꞌp pɨx gɇꞌgɇrkam jum taat kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Gam nat bhammɨ dɨr ji ja tɨɨpxi guiꞌ nam gɇꞌgɇrkam kɨꞌn ka daraat, pu cham tuꞌ kɨꞌn ji bii mɨt. Guiꞌ baꞌ nam jir cham tuꞌ dat, gɇꞌgɇrkam kɨꞌn xi ja darsak. ");
INSERT INTO stpNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gio guiꞌ nam giilhim kar jix chutumñigam kat, puiꞌ gammɨjɨ xi ja joot xi chu ja boosgidhak gu ja bɨxchuꞌ, tu ja maa baꞌ guiꞌ nam soiꞌ tuꞌiiꞌ nam cham tuꞌ biaꞌ ni jɨꞌx. ");
INSERT INTO stpNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nat guꞌ ba tɨꞌñcho nat bam ai nat paiꞌ dhuuk tu dai nax ja joiꞌmdaix bhaiꞌ ja duñiaꞌ gu Israel kam jaꞌtkam, na guꞌr jaꞌtkam tugiꞌñ gio nam jir tujuandam tugiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Puiꞌ pu xi ja tɨɨdak ji guꞌ bɨjɨk guch bopxi kat, puiꞌ na jax gu Abraam maadɨt jir diꞌ nat puiꞌ tɨɨdak. ");
INSERT INTO stpNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Puꞌñi jaꞌk baꞌ tɨi ɨp gu Mariiya. Miꞌ juruuñ ji guꞌ jɨꞌk baik masaaꞌn buiñor gu Isabeel nat baꞌ ba jii ɨp gio mu jaꞌk kiaꞌmiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Baꞌ nat paiꞌ dhuuk jum ai gu tanoolh, ba maaxir gu maraaꞌn gu Isabeel. ");
INSERT INTO stpNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Baꞌ gu jajaaꞌnniꞌñ gio guiꞌ nam cham jax iim nam jaꞌp pɨx jix ja mat kaꞌ, ba maat jamɨt nat ba tɨɨ gu alhii, ba maat jamɨt sia nat gu Dios pɨx jix joiꞌmdak tɨɨgɨk maa gu alhii. Baꞌ mi ɇɇk jup tɨtda am nat joidham jix bhaiꞌ tu jii. ");
INSERT INTO stpNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Baꞌ nat paiꞌ aich gu xijum baik tanoolh gu alhii, dai na mɨt ba tɨɨt gio na mɨt matgilh nar Israel kam. Baꞌ jaiꞌ dhɨt tɨix aagɨt am na gɨt puiꞌp tɨɨꞌnkaꞌ na jax gu taataꞌn Sakariiyas. ");
INSERT INTO stpNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Guꞌ ji nat guꞌ cham aa gu dɨꞌɨɨꞌn, jup kaiꞌch pɨx: ―Juan ji nañ jix aaꞌ na tɨɨꞌnkaꞌ dhiñ alhii chuk. ");
INSERT INTO stpNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Baꞌ tɨip tɨtda am guiꞌ: ―Jax dhui na cham jax chuꞌm iam puiꞌ tɨɨꞌ na pim jɨꞌk jir jum jajaaꞌnnim. ");
INSERT INTO stpNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Baꞌ gu taataꞌn ba tɨkka am ɨp na jax jaꞌk jup jix aaꞌ na tɨɨꞌnkaꞌ gu maraaꞌn, ja noonob kɨꞌn jaꞌp ba buixiꞌñ am nam tɨkka. ");
INSERT INTO stpNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Baꞌ xi ja taa nam bha bhɨidhaꞌ maaꞌn gu uux komaarak sobkoñxim alhiꞌch paꞌ na bhaan mi dhaasaꞌ na jax jaꞌk jix aaꞌ na tɨɨꞌnkaꞌ. Baꞌ jaꞌpni miꞌ xi dhai: “Juan jach tɨɨtgaꞌ dhiñ alhii chuk.” Baꞌ guiꞌ gampaiꞌ ji dhuuꞌn jamɨt, nam guꞌ cham ɨlhdhat na jaiꞌ puiꞌ jaꞌk jup ɨlhiiꞌñ na jax gu bɨngaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Baꞌ miꞌ jotmodaꞌ bhaiꞌ ji chu ñiokcha ɨp gio gu Sakariiyas, jix bhaiꞌm taatɨt xi gɇꞌkamtuꞌn gu Dios jix dhaam jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Baꞌ giilhim jix chootoꞌn jamɨt guiꞌ nam miꞌp tuꞌiiꞌ, gio naiꞌ jaꞌp pɨx puiꞌ tɨm tɨi nat jax tum duu na jɨꞌx jir jujukgam na Judea dɨbɨɨr bhaan bipioꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Baꞌp jum aaꞌndaꞌ am guiꞌ nam puiꞌ tɇ kɇɇkɇꞌ: ―¿Tuꞌ chi baꞌr jup tuꞌm daꞌ kaꞌ gu alhii nat mu paiꞌ pu maaxir? Na guꞌ bɨɨx aixim joidham jix bhaiꞌ tu buadaꞌ gu Dios buiñor gu alhii nam xi chɇ kɇɇ, dhiꞌ bhaan baꞌ tɨi xim gaꞌngadaꞌ am na tuꞌr jup tuꞌm daꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Baꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ gɇꞌ bhaan bam tajaa gu Sakariiyas, taataꞌn gu alhii, baꞌ bhaiꞌ ji chu aꞌga na jax jir tuꞌm kam gu Dios, jup kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Jaꞌp moor jix bhaiꞌkam ji tuꞌ sɨlhkam kɨꞌn gu Gɇꞌkam Dios! Tɨɨꞌ nat moo bha jii yaꞌ ja bui gu jaꞌtkam tugiꞌñ Israel kam na baꞌ yaꞌ ja uañdhaꞌ gu ja uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bhach joochxi maaꞌn guiꞌ na bɨxchuꞌx bhaaiꞌ na pu tu duñiaꞌ. Dhiꞌ baꞌch boosgaꞌ miꞌ dhɨr bhaan gu boi nach bhaan mu jaꞌk ka jiim nach paiꞌ gammɨjɨ miꞌ pup jich chulhiiñdhaꞌ. Maadɨt jir diꞌ gu boxiiꞌñ gu Dabii guiꞌ na Dios jir tujuandam tugiꞌñ kat bɨjɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Puiꞌ pu xi ja tɨɨdak ji guꞌ gu Dios guiꞌ nam bɨjɨk bhaankamuꞌn jix uꞌuañ kɨꞌn ya jaꞌp tu ja aꞌgidhimɨk gu jaꞌtkam, ");
INSERT INTO stpNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","na sap puꞌñi ka daasaim na paiꞌ dhuuk jich palhbuidhaꞌ nam cham kach juandaꞌ bɨɨx guiꞌ nam xich bhaamkiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Jum aayaꞌ sap na paiꞌ dhuuk gɇꞌkam kɨꞌn jix joiꞌmdai ja tɨgiaꞌ bɨɨx guch bopxi kat, cham sap baꞌ jɨꞌxkat mɨk buaꞌ puiꞌ na jax ja tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Guch boxii Abraam maadɨt jir diꞌ nat puiꞌ tɨɨdak gu Dios, ");
INSERT INTO stpNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","na sap puꞌñich palhbuidhaꞌ nam cham kach juandaꞌ guiꞌ nam xich bhaamkiꞌñ nach baꞌ miꞌ dhɨr cham tuꞌ bhaan ka totdonɨt dai guiꞌ bar tujuandam tugiꞌñ kaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","nach cham tuꞌ bhaan kach uaꞌtulhdhat miꞌ puiꞌ ba jiimdaꞌ na jax jix aaꞌ gammɨjɨ nach jɨꞌx ya duduakaꞌ dhi tutkuꞌ bhaan, na baꞌ bhammɨ dɨr bha jaꞌk puiꞌch aꞌm jup tɨ nɨidhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Baꞌ aap jiñ chioꞌñ, jup tɨꞌyaꞌ am gu jaꞌtkam nap aap maadɨt jir diꞌ guiꞌ nam bɨjɨk ya jaꞌp tu aꞌgimɨk bhaankam gu Dios guiꞌ nax ioꞌm jir gɇꞌkam, nap guꞌ aap bɨɨpɨꞌ ya jaꞌp ba tu ja aꞌgidhaꞌ gu jaꞌtkam na baꞌ miꞌ dhɨr yaꞌp ba aayaꞌ gux ioꞌm gɇꞌkam, jaꞌp ji buusniaꞌ nap bɨɨpɨꞌ yaꞌ ba tu boiꞌntaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nap guꞌ ba ja mattudaꞌ gu jaꞌtkam tugiꞌñ na jax jaꞌk jix bhaaiꞌ nam dui cham mu jaꞌk ka bhɨɨyaꞌ nam paiꞌ gammɨjɨ miꞌ pup jum tulhiiñdhaꞌ, na guꞌ ba ja uañdhaꞌ gu ja uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nat guꞌ gu Dios jich Gɨꞌkoraꞌ gɇꞌkam kɨꞌn ba xich joiꞌgɨlh, yaꞌ bach aichulh jix dhaam dɨr maaꞌn guiꞌ na gɇꞌ mɨimtuꞌ. Dhiꞌ jaꞌp ji buus jich bui nat kiaꞌpɨx bhaiꞌ ba tu kobxi gu tanoolh xiaꞌlhbui dhɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Baꞌ bɨɨx jich aꞌm tonniaꞌ, sia guiꞌ nam jix ioꞌm jix chu tukgam tɨr jup tuꞌiiꞌ. Joidham bax chu maax kaꞌ nach tɨ nɨidhidhaꞌ nach jax jaꞌk joidham jix bhaiꞌch chaatɨt miꞌ puiꞌ jiimdaꞌ na jax jix aaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Puꞌñi jaꞌk baꞌ tu aꞌga gu Sakariiyas. Baꞌ pɨx ji gɨꞌlhidhaꞌ gu alhii, tɨ bhɨɨjidhaꞌ na jax jir tu tuꞌm kam yaꞌ dhi oiꞌñgaꞌn. Baꞌ nax ioꞌm paꞌ bar gɇꞌ kaꞌ, mu jaꞌp pɨx ba oirɨdaꞌ gampɨx jix chu gak kɨr. Jix ioꞌm mɨkkat nat baꞌ naiꞌ ji chu ja aꞌgi gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Janoꞌ gu Auguusto Seesar bɨɨx kap jir gɇꞌkam kaꞌ na jɨꞌk Rooma bhaan bipioꞌ gu dɨppɨr, baꞌ dhiꞌ ja chia nam jum daasaꞌ bɨɨx gu jaꞌtkam nam jɨꞌk dhiꞌ bhaan tu oiꞌdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Janoꞌ kiaꞌpɨx jir maaꞌnnim kaꞌ nam jum daasaꞌ, nam guꞌ cham paiꞌ dhuuk jum daꞌnsat bɨɨpɨꞌ dɨr. Janoꞌ gu Sireenio jir jix kaiꞌ kaꞌ ɨp miꞌ jaꞌk na paiꞌ Siiria bhaan bipioꞌ gu dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Baꞌ puiꞌ jaꞌk duu gu Auguusto Seesar nam aaꞌndaꞌ na miꞌm daasaꞌ gu jaroiꞌ nar paiꞌ kam kaꞌ gu bɨjɨk dɨr kam boxiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Puꞌñi duuk baꞌ gu Josee ma jii miꞌ dhɨr Nasareet na Galilea bhaan bipioꞌ gu dɨbɨɨr, bhammɨ jaꞌk bhɨi Beleen na paiꞌ Judea bhaan bipioꞌ ɨp guiꞌ gu dɨbɨɨr, nat guꞌ bhaiꞌ maaxir gu boxiiꞌñ Dabii nar gɇꞌkam kat bɨjɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Sia gu Mariiya bɨɨx jup xi baidhak nam gook dɨt jum daasaꞌ, guiꞌ nat puiꞌ ba tɨɨꞌn na bɨɨmaꞌn jum tɨɨmoꞌ nam maap tu oiꞌñchaꞌ. Ku guꞌ pu bar dakoo pɨx tuꞌn daꞌ ji baꞌ gu Mariiya kɨꞌn gu alhii. ");
INSERT INTO stpNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Baꞌ janoꞌ pɨk jup mam ai gu tanoolh na paiꞌ dhuuk maaxilhiaꞌ gu alhii nam bhaiꞌ ka oipo Beleen. ");
INSERT INTO stpNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Cham jup ja ai guꞌ mɨjɨ na paiꞌ tɨm tɨbiappu na gɨt miꞌ dodhiaꞌ gu Mariiya, na mɨt guꞌ suuꞌn gu jaꞌtkam na mɨt muiꞌ bham jumaap. Mu jaꞌk jamɨt baꞌ jii nam paiꞌ kuupkaꞌ bɨɨx aixim tuꞌm gu sasoiꞌ. Miꞌ baꞌ dua gu Mariiya kɨꞌn gu bɨɨpɨꞌ kam maraaꞌn, jajannulh kɨꞌn xi bhiibgak bhaiꞌ xi booꞌn bhaan guiꞌ nam sasoiꞌ mi tu kuaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Baꞌ jɨꞌkchi gu jaꞌtkam bhammɨ baasɨꞌn dɨr jaꞌp jup tɨbiapkaꞌ am gampɨx nam bhaiꞌ darkat tu bipiaꞌdaꞌ gu ja kakasniraꞌ nam ja biaꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Baꞌ cham pum aaꞌ am nat jotmodaꞌ gɇꞌ nammɨ jaꞌp ba tu maaxir miꞌ bɨɨx xikoolh nam paiꞌp tuꞌiiꞌ, guꞌ gu nobiiꞌñ gu Dios nat miꞌ bam maax ja bui nat gɇꞌ ton nam baꞌ bhaan machiaꞌ na dhiꞌr diꞌ guiꞌ na bhaankam oirɨ gu Dios. Guꞌ guiꞌ giilhim jix chootoꞌn jamɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Baꞌ gu nobiiꞌñ gu Dios jup ja tɨtda: ―Chaꞌpim totdon kaꞌ. Aañ jam uaꞌtulhiꞌñ ji maaꞌn gu ñiꞌook na pim bhaan joidham jix bhaiꞌm ɨlhdhaꞌ, sia bɨɨx gu jaꞌtkam puiꞌx bhaiꞌp jum ɨlhdhaꞌ am nam paiꞌ dhuuk machiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Jaꞌpniñ tuꞌm jam uaꞌtulhiꞌñ: Maaꞌn bhaꞌñi dhɨr maaxir gu alhii xib dhi tukaaꞌ na paiꞌ kiokat bɨjɨk gu Dabii. Dhiꞌr diꞌ guiꞌ na pim nɨɨra na saak bha jootsaꞌ gu Dios yaꞌ dhi oiꞌñgaꞌn na jam palhbuidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kani gor tɨ tɨɨꞌmbop na bha jaꞌp boꞌkaꞌ bhaan guiꞌ nam sasoiꞌ mi tu kuaꞌ jajannulh bhiibgixim kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Baꞌ jotmodaꞌx ioꞌm muiꞌ bhaiꞌ bam maax jamɨt gu noonbiꞌñ gu Dios nat jax pɨx miꞌ ji tɨɨmo nat tu aꞌga gu maaꞌn, baꞌp kaiꞌch am bɨɨx dhɨt nam gɇꞌkamtuꞌn gu Dios: ");
INSERT INTO stpNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Aach jix bhaiꞌch chaatɨt gɇꞌkamtuꞌn gu Dios nach jɨꞌk miaꞌn jup tuꞌiiꞌ buiñor! Nat guꞌx joiꞌmdak jix bhaiꞌ ba ja duu gu jaꞌtkam yaꞌ kam dhi oiꞌñgaꞌn, dai baꞌ na ja aꞌm ba tɨ nɨidhidhaꞌ guiꞌ nam jɨꞌk miꞌ puiꞌ jiimdaꞌ na jax jix aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Baꞌ na mɨt paiꞌ jiix dhaam jaꞌk gu noonbiꞌñ gu Dios, gu kakasnir bipiaꞌdam jup jum tɨ tɨtda am: ―Each mu jiim Beleen nach tɨɨꞌmpoꞌ gu alhii nat puiꞌ maaxir na jax jich chɨtda guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Baꞌ na mɨt jax guguu miꞌ bhɨi mɨt na mɨt tɨɨgim. Mummɨ mɨt ba ji bubua na paiꞌp tuꞌiiꞌ gu Mariiya gio gu Josee, gu alhii bha jaꞌp boꞌ bhaan guiꞌ nam sasoiꞌ mi tu kuaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Baꞌ na mɨt paiꞌx bhaiꞌ xi chɨɨgɨk gu alhii gu kakasnir bipiaꞌdam, ba ja aagiꞌñ am guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ nar tuꞌp tuꞌm daꞌ kaꞌ gu alhii, xi ja aagiꞌñ am na maaꞌn gu nobiiꞌñ gu Dios puiꞌ ja tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Baꞌ guiꞌ miꞌ puiꞌ pup tuꞌiiꞌ am nam ba ja aagiꞌñ nar tuꞌp tuꞌm daꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Gu Mariiya baꞌ dai juraꞌram jup xim gaꞌnga tɨi na jax jir jum duukam puiꞌ nam jɨꞌk jax kaiꞌch gu kakasnir bipiaꞌdam. ");
INSERT INTO stpNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Baꞌ ba jii mɨt ɨp gio gu kakasnir bipiaꞌdam xi gɇꞌkamtudidhat gu Dios, xi laalagidhat am jɨꞌx gu alabaaꞌn, jix bhaiꞌm taattuꞌ am guꞌ na mɨt puiꞌ tɨ tɨɨ na jax ja aagiꞌñ gu nobiiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Baꞌ nat paiꞌ aich gu xijum baik tanoolh gu alhii, dai na mɨt ba tɨɨt gio na mɨt matgilh nar Israel kam. Jesuus jamɨt tɨɨt na jax jaꞌk pu aagiꞌñ gu nobiiꞌñ gu Dios gu Mariiya bɨɨpɨꞌ dɨr na baꞌ moo bar alhiꞌch kɨɨkam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Baꞌ puiꞌ jaꞌk jup tu aagix kaꞌ nat tu uaꞌnak gu Moisees bhaankamuꞌn gu Dios, nam cham paiꞌ buandaꞌ jɨꞌk tanoolh gu uꞌuub miꞌ dhɨr ja kiꞌaam noꞌ mɨt puꞌñi kiaꞌpɨx dudua aꞌaalh kɨꞌn. Puiꞌ duu ɨp baꞌ gu Mariiya, cham paiꞌ buus jɨꞌk tanoolh. Nat paiꞌ xi aichdhak na jɨꞌk aagix kaꞌ na mɨt baꞌ ba bhɨɨk gu alhii bhammɨ Jerusaleen, bhaiꞌ na paiꞌ kɨɨkaꞌ gu gɇꞌ chiop nam baꞌ bhaiꞌ dhɨr iimchuxdhaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Na guꞌ sia puiꞌ jaꞌk jup tu aagix kaꞌ nat puiꞌp tu uaꞌnak gu Moisees bhaankamuꞌn gu Dios. Jaꞌpnim kaiꞌch: “Iimchuxdhidhaꞌ pim gu Dios gu aꞌaalh chichioꞌñ guiꞌ nam bɨɨpɨꞌ maaxilhidhaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Puꞌñi baꞌ kaiꞌñkam mu bhɨɨk jamɨt bhammɨ Jerusaleen. Baꞌ sia puiꞌ jaꞌk jup tu aagix kaꞌ nam aaꞌndaꞌ nam tu makgɨrxidhaꞌ gu Dios gu uꞌuub noꞌ mɨt puꞌñi kiaꞌpɨx ja tɨɨ gu aꞌaalh, jup jum kaiꞌch na sap sia tuꞌ gioꞌndaꞌ gook piam gook gu joojoi. ");
INSERT INTO stpNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Baꞌ maaꞌn gu maaꞌnkam bhaiꞌp kiokaꞌ Jerusaleen, Simeon tɨɨgim, na miꞌ puiꞌ jimdaꞌ na jax jix aaꞌ gu Dios, gammɨjɨ tu daandaꞌ. Baꞌ jaiꞌ puiꞌ tɨip tɨ nɨɨradaꞌ na paiꞌ baꞌ duuk puiꞌx ja joiꞌmdai ja palhbuidhaꞌ gu Dios gu Israel kam jaꞌtkam nam ja tulhiiñchuꞌndaꞌ gu jaiꞌ jaꞌtkam maakam dɨr jaꞌk kam. Baꞌ na guꞌ bhaan jup tuiꞌñgɨdaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","guiꞌ pɨx puiꞌ jurtuꞌnkaꞌ na chakui mukiaꞌ na yaꞌ ba aayaꞌ guch Xoiꞌkam na Dios bha jootsaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Baꞌ guiꞌ pɨx jix Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ puiꞌ jurtuda na mu jimiaꞌ gɇꞌ chiop, mummɨ ba ji buus. Maap pɨx miꞌ ji aajim am gu Jesuus gu gɨꞌkorgaꞌn na mɨt miꞌ puiꞌp ba tu duñiim na jax tu aagix. ");
INSERT INTO stpNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Baꞌ xi dhaagɨk gu Simeon gu alhii ma tu aꞌgax dhaam jaꞌk buiñor gu Dios, jup kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Taxchaab dho baꞌch Gɨꞌkoraꞌ na pich bhaiꞌ bach joochxi guiꞌ nap saak puiꞌ bha jootsaꞌ na pich jax ja tɨɨdak guch bopxi bɨjɨk. Baꞌ aañ xib cham tuꞌ bhaan jax kañ aaꞌ sia pich baꞌ bañ dhoꞌñcho nañ ba mukiaꞌ nañ jir jum tujuandam tuk, ");
INSERT INTO stpNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","na ñich guꞌ yaꞌ ba tɨɨñ buupui kɨꞌn guiꞌ na yaꞌ ja uañdhaꞌ gu ja uaꞌtulhdharaꞌ gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Xib japich baꞌ muiꞌ ba ji kɨi nap jax jix aaꞌ dɨɨlh jich Gɨꞌkoraꞌ nap tu duñiaꞌ xi ja nɨiꞌñchudat bɨɨx gu jaꞌtkam nam jɨꞌk jix jaiꞌch yaꞌ dhi oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Na guꞌ dhiꞌ baꞌr diꞌ guiꞌ na joidham gɇꞌ tanoor na ja bɨꞌñxidhaꞌ bɨɨx gu jaꞌtkam nam jɨꞌk jix jaiꞌch, baꞌ miꞌ dhɨr dai nam pɨx jix bhaiꞌ ba ja aaꞌndaꞌ gum jaꞌtkam tuk Israel kam na pich jix bhaiꞌ ba ja duu. ");
INSERT INTO stpNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Baꞌ gu Josee gio gu Mariiya gampaiꞌ ji dhuuꞌn jamɨt nat gu ja mar bhaan tu aꞌga gu Simeon jix dhaam jaꞌk, miꞌ pɨx puiꞌ pup tuꞌiiꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Baꞌ bɨɨx gook xi chu ja daañxidhak gu Simeon na sap baꞌx bhaiꞌ tu ja jimdaꞌ. Miꞌ dhɨr baꞌ moop tɨtda dai gu Mariiya: ―Kani nap xiñ kaayaꞌ nañ jax jum tɨɨdaꞌ. Dhi alhii bhammɨ dɨr bha ja joochxi gu Dios gu Israel kam jaꞌtkam. Jaiꞌ miꞌ puiꞌ jimiaꞌ am na jax ja tɨɨdaꞌ, jaiꞌ baꞌ cham. Jix ioꞌm jir muiꞌ kaꞌ am guiꞌ nam cham miꞌ puiꞌ jimiaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","sia kum guꞌ tɨix maatɨt kaayaꞌ na jax kaiꞌñkam jup ja tɨɨdaꞌ, guꞌ pɨx ji nam guꞌ dɨɨlh jix bhaamut kaayaꞌ, dhiꞌ baꞌ bhaan jix maatɨꞌ kaꞌ nam dɨɨlh cham aaꞌndaꞌ. Aap baꞌ giilhim jix buam jum aaꞌndaꞌ tɨi, jaꞌp tu tatdakaꞌ panaas na jaroiꞌ kuxiir kɨꞌn bham sɨssɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Baꞌ maaꞌn gu ubii jagɨꞌ bhaiꞌp oirɨdaꞌ Aana tɨɨgim na bhaankamuꞌn gu Dios tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam nam jax jaꞌk miꞌ puiꞌ jiimdaꞌ. Gu taataꞌn Panuel tɨɨgich, maadɨt jir diꞌ kat guiꞌ nam Aseer jir bopxiꞌñ. Baꞌ dhi Aana alhii paꞌ oidhak maaꞌn gu chioꞌñ, guꞌ ji na mɨt guꞌ xijum gook oidhaꞌ pɨx maap tu oiꞌñcha, ma muu ɨp gu bɨngaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Dɨɨlh baꞌ pup oirɨ nat dɨr dɨɨlh bii, maakob ooꞌm daman maakob oidhaꞌ bap duu janoꞌ dɨr. Guꞌ baꞌ miꞌ pɨx jaꞌk ji ai chiop na paiꞌ baꞌ pup jir tujuandam tugiꞌñ gu Dios, cham paiꞌ maakam jaꞌk ka buus. Gammɨjɨ tu juandaꞌ miꞌ dhi chiop nabap tanoolh gio nabap tukaaꞌ, gam nam saabdaꞌ, gio na tu daandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Baꞌ guiꞌ jɨꞌ Aana jaiꞌ miꞌp ba ji buus na paiꞌ gu gɨꞌkorgaꞌn gu Jesuus, jaiꞌ baꞌp ma taxchaabgi gu Dios jix dhaam jaꞌk. Miꞌ dhɨr baꞌ naiꞌ puiꞌp ba ja tɨtdaim guiꞌ nam puiꞌp tɨ nɨɨra na paiꞌ baꞌ duuk puiꞌx ja joiꞌmdai ja palhbuidhaꞌ gu Dios gu Israel kam jaꞌtkam, puiꞌ ja tɨtdaim nat yaꞌ ba ai guiꞌ nam jaroiꞌ nɨɨra. ");
INSERT INTO stpNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Baꞌ na mɨt bɨɨx puiꞌ xi chu duuk gu gɨꞌkorgaꞌn gu Jesuus na jax jaꞌk aagix na tu uaꞌñix gu ñiokiꞌñ gu Dios, giop ba jii mɨt mu jaꞌk Nasareet nam paiꞌ oiꞌdhaꞌ, na paiꞌ Galilea bhaan bipioꞌ guiꞌ gu dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Baꞌ gu alhii pɨx ji gɨꞌlhidhaꞌ, jix ioꞌm bax chɨ bhɨiꞌñ kaꞌ gio nax ioꞌm bax ooꞌ kaꞌ, gam nax bhaiꞌm taat kaꞌ, na guꞌ bhaan tɨ nɨidhidhaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Baꞌ gu gɨꞌkorgaꞌn gu Jesuus muiꞌ pu jimmɨdaꞌ am bhammɨ Jerusaleen nabap oidhaꞌ na paiꞌ dhuuk jum aajidhaꞌ bhaan Paaskua taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Baꞌ nammɨ nat giop bam ai, gio mɨt muiꞌp ma jii, bɨɨx jamɨt xi baidhak gu Jesuus, na guꞌ mambhɨɨx daman gook oidhaꞌ ba biaꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Baꞌ nat paiꞌ buus gu bhaan Paaskua taꞌm, gio jaꞌk jup ba suulhgichuꞌ am mu jaꞌk ja kiꞌaam, guꞌ ji nat guꞌ bak gu Jesuus bhammɨ pup bii Jerusaleen. Pu cham maat am gu gɨꞌkorgaꞌn noꞌt bhammɨ paiꞌp bii, ");
INSERT INTO stpNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","jaꞌp jum aaꞌntuꞌ am guꞌ na miꞌ paiꞌ ja saagiꞌñ jim gu jaꞌtkam nam giilhim muiꞌ mu jiim. Maaꞌn tanoolh guꞌ pu ba jii mɨt na mɨt baꞌ naiꞌ tɨi ba ji gaa mi jaꞌp ja bui gu jajaaꞌnniꞌñ gio mi jaꞌp ja bui guiꞌ nam jɨꞌk jix ja maat. ");
INSERT INTO stpNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Cham paiꞌ tɨɨ mɨt. Baꞌ gio miꞌ dhɨr jaꞌk jup ma suulh jamɨt na mɨt gaagam bhammɨ Jerusaleen. ");
INSERT INTO stpNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nammɨ baik tanoolh kɨꞌn baꞌ ka tɨɨ mɨt bhaiꞌ gɇꞌ chiop na ja saagiꞌñ daa guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, ja kɇɇ nam aagiꞌñ gu ñioꞌkiꞌñ gu Dios na bha ja tɨkka. ");
INSERT INTO stpNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Baꞌ jɨꞌx gampaiꞌ ji dhuꞌntɨkdaꞌ am bɨɨx guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ nam sap cham paiꞌ dhuuk jax chuꞌm alhii puiꞌ kɇɇkɇt nax ioꞌm jix chu maat. ");
INSERT INTO stpNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Baꞌ na mɨt ba tɨɨ gu gɨꞌkorgaꞌn na paiꞌ daakat pɨx chuꞌ kaiꞌch, gampaiꞌ ji dhuuꞌn jamɨt ɨp sia, nam guꞌ cham jɨꞌxkat paiꞌ dhuuk puiꞌ nɨidhat gu jax chuꞌm alhii na jax jaꞌk tu jim gu Jesuus. Baꞌp tɨtda gu dɨꞌɨɨꞌn: ―¿Jax baꞌñ chioꞌñ ku pich baꞌch oꞌñxi? Naiꞌch chɨim gaaꞌñchuꞌ gook dɨt dhim taat jix buam jich aaꞌntugɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Baꞌ gu Jesuus jup ja tɨtda: ―¿Jax ku pim baꞌ moop jiñ gaꞌnga? Na guꞌ aañ jiñ aꞌm jum aaꞌ nañ machiaꞌ na jax jir tuꞌm kam guñ Gɨꞌkoraꞌ. Jum aaꞌ nañ yaꞌp tuiꞌkaꞌ na paiꞌ baꞌkchudhix. ");
INSERT INTO stpNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pu cham maatɨt kai mɨt gu gɨꞌkorgaꞌn nat jax kaiꞌñkam jup ja tɨɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ku guꞌ pu ja oi ji baꞌ gu Jesuus mu jaꞌk Nasareet puiꞌ xi ja tɨɨdak, na guꞌx ja kɇɇkɇꞌ tuꞌ nam chiandaꞌ. Baꞌ puiꞌ pɨx jum aaꞌndaꞌ juraꞌram bhaan gu dɨꞌɨɨꞌn na jax baꞌr jum duukam na jax jaꞌk tu jim gu Jesuus, tɨim gaꞌngadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Baꞌx chɨ bhɨiꞌñ kam gɨꞌlhidhaꞌ gu Jesuus, gam nax bhaiꞌm taat kaꞌ, na guꞌ bhaan tɨ nɨidhidhaꞌ gu Dios, gio gu jaꞌtkam joidham pɨx jix bhaiꞌ aaꞌndaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Baꞌ jumaip bar gɇꞌkam kaꞌ bɨɨx kap na jɨꞌk Rooma bhaan bipioꞌ gu dɨppɨr, Tibeerio ba tɨɨꞌnkaꞌ guiꞌ na bar gɇꞌkam kaꞌ. Mambhɨɨx daman jix chamaam oidhaꞌ bhaiꞌ pu bap duu na baꞌ gu Poonsio Pilaato miꞌp bar jix kaiꞌ kaꞌ dai miꞌ na jɨꞌx Judea bhaan bipioꞌ gu dɨbɨɨr. Mu jaꞌk Galilea baꞌ Eroodis tɨɨgim miꞌp jir jix kaiꞌ kaꞌ janoꞌ. Mu jaꞌk Iturea baꞌ gio Trakoniite, maaꞌn Piliip tɨɨgim miꞌp jir jix kaiꞌ kaꞌ dhi gok kap, jir jum jajaaꞌnnim kaꞌ am gook dɨt gu Eroodis. Baꞌ mu jaꞌk na paiꞌ Abiliinia tɨ tɨɨꞌ, maaꞌn Lisaanias tɨɨgim miꞌp jir jix kaiꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Guꞌ baꞌ maaꞌn Anaas tɨɨgim gio jumai Kaipaas, jix ioꞌm jir ja gɇꞌgɇrkam tuk kaꞌ am guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam. Dhiꞌ jɨꞌ baꞌ bɨɨx nam gɇꞌgɇrkam kɨꞌn ka darkaꞌ, gu Dios mummɨ jaꞌk ba tu aꞌgi gu Juan guiꞌ na Sakariiyas jir maraaꞌn. Mummɨ tu aꞌgi gampɨx jix chu gak kɨr na paiꞌx joiꞌñdhaꞌ na oirɨdaꞌ, jup tɨtda na ampɨx bax bhaaiꞌ na paiꞌ dhuuk jir am na ba tu ja aꞌgiꞌñmɨraꞌ gu jaꞌtkam mu jaꞌp nam paiꞌ jax tu oiꞌdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Baꞌ guiꞌ ma jii ɨp nat tu ja aꞌgidham, mu jaꞌp ji bhɨi bɨɨx juꞌñdharam gu Jordaan Ak gɇꞌ na miꞌ bhɨix, jup ja tɨtdaidhaꞌ nam soiꞌm ɨlhdhai bam bopkonaꞌ na baꞌ dhiꞌ bhaan jix maatɨꞌ kaꞌ na mɨt miꞌ puiꞌ ba jii na jax jix aaꞌ gu Dios, baꞌ dai na ba uañchudhix kaꞌ gu ja uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Baꞌ puiꞌ ji chu buus na jax jum kaiꞌch miꞌ nat paiꞌ tu uaꞌnak bɨjɨk gu Isaiiyas guiꞌ nat bhaankamuꞌn gu Dios tu ja aꞌgidhak gu jaꞌtkam. Jup jum kaiꞌch: Maaꞌn gu maaꞌnkam mu jaꞌp gampɨx jix chu gak kɨr ji jimdat jup ja tɨtdaim gɇꞌ kɨꞌn gu jaꞌtkam: “Gor jix kɨɨꞌ bim duuñ, bar miaꞌn na bhaiꞌ ba jim gu Gɇꞌkam. Miꞌ pim sap puiꞌ ba jimiaꞌ na jax jix aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Na pim guꞌ jaꞌp pɨx tuꞌiiꞌ na jax gu boi noꞌ giilhim gɇꞌgɇr jix kakolhbik gam noꞌx ñoonolh na jax jaꞌk cham bhaiꞌ tum oirɨ. Jam aꞌm jum aaꞌ baꞌ na pim miꞌ puiꞌ jimiaꞌ na baꞌ tɨm kɨɨꞌmpigaꞌ jam iꞌiiꞌmdaꞌ ɨr bhaan nax chu buichɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na guꞌ maaxik ya aayaꞌ guiꞌ na Dios bha jootsaꞌ, bɨɨx dhɨt tɨgiaꞌ am gu jaꞌtkam. Dhiꞌ baꞌ yaꞌ ja uañdhaꞌ gu ja uaꞌtulhdharaꞌ nam bɨɨx aixim tuꞌm kɨꞌn jix uꞌuaꞌtulhdhix.” ");
INSERT INTO stpNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Miꞌ baꞌ Jordaan Ak ja bopkondaꞌ gu Juan gu jaꞌtkam. Muiꞌ pɨx miꞌ ji aajidhaꞌ am nam xim bopkonamtuꞌndaꞌ. Baꞌp ja tɨtdadaꞌ gu Juan: ―¿Jaroo baꞌ moox bhaiꞌp ba duu na ba jam aagiꞌñ na pim jax jaꞌk dui cham jum tulhiiñaꞌ, na cham xiim bam aajim na tu tulhiiñchudaꞌ gu Dios ku pim baꞌ gaꞌm ba jiim? Jaꞌp ji buusan guꞌ na pim jir kookoꞌ gux bhaaꞌmnagɨm na pim cham miꞌ puiꞌ jiim na jax jix aaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ku guꞌ noꞌ pim sɨlhkam cham aaꞌ na pim jum tulhiiñaꞌ, jum aaꞌ ji na pim puiꞌ jaꞌk ba tu jimdaꞌ na jax jaꞌk bhaan jix maatɨꞌ kaꞌ na pim soiꞌ bam ɨlhiiꞌñ buiñor gu Dios na baꞌ guiꞌ xi jam joiꞌmdaꞌ ɨp. Chaꞌpim jax jum aaꞌndaꞌ na puiꞌ pɨx jup xi jam joiꞌmdaꞌ na pim chi panaas xir bopxiꞌñ gu Abraam. Jax dhui na guꞌ gu Dios sia joodai bopxichudaꞌ gu Abraam noꞌt xi ɨlh, noꞌ pim aapiꞌm cham miꞌ puiꞌ tu daaꞌñchuꞌ na jax jaꞌk tu daaꞌñchugɨt bɨjɨk gu Abraam. Na guꞌ tuꞌ na pɨx jix bhaaiꞌ na pu duñiaꞌ gu Dios na jax jaꞌk ɨlhiiꞌñdhaꞌ gu tuꞌ, na guꞌr gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Gio guꞌ jaꞌp ji buusan na pim aapiꞌm jir ɨꞌɨɨx guiꞌ nam iꞌbhaiꞌñchardat jix maikak bhɇbhɇɇ. Baꞌ noꞌ maadɨt cham kɨkɨɨꞌ iꞌbhaiꞌñchar, piam ku pu cham tu iꞌbhaiꞌñchar, amuub dho ba kaat gu baiñdhas na kɨꞌn jum iarai xim biimsai maap xim jumpadai miꞌ xim kɨɨxdhaꞌ gu tai ku mu jagiaꞌ, daman pup bɨɨx takaaꞌn xim boosgai bhaiꞌ xim iabuꞌ na baꞌ cham jaiꞌ bhaiꞌp ka iꞌpundaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Baꞌ gu jaꞌtkam nam miꞌp tuꞌiiꞌ bhaiꞌ ba tɨkka am, jup tɨtda am: ―¿Guꞌ jax jach baꞌ jaꞌk xi chu buadaꞌ nach baꞌ cham jich chulhiiñaꞌ jich jaduuñ? ");
INSERT INTO stpNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Baꞌ gu Juan jup ja tɨtda: ―Dho na pim jix ja joiꞌmdai ja tɨgiaꞌ gu jaꞌtkam guiꞌ nam gampaiꞌ tuꞌiiꞌ nam cham tuꞌ biaꞌ. Jɨꞌmaꞌn japim ja makiaꞌ gu jam jajannulh noꞌ pim goꞌgok ja biaꞌ. Gio noꞌ pim jaroiꞌ nɨiꞌñ na uamaim, xi onbaiꞌñdhaꞌ pim gu koiꞌ noꞌ pim aapiꞌm biaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Baꞌ gu tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam jɨꞌk miꞌp ai mɨt nam puiꞌp xim bopkonam. Baꞌ puiꞌ bhaiꞌp ba tɨkka am gu Juan, jup tɨtda am: ―¿Aach gi, jax jaꞌk jup xi chu buadaꞌ jich jaduuñ na baꞌ puiꞌ cham jup jich chulhiiñchudaꞌ gu Dios? ");
INSERT INTO stpNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Baꞌ gu Juan jup ja tɨtda: ―Dho na pim cham jaꞌp pɨx ja chiandaꞌ gu jaꞌtkam nam muiꞌ tu namkiꞌñdhaꞌ na pim jix aagɨt na jaiꞌ jam aꞌm biꞌiidhaꞌ, daipuꞌ ji na jɨꞌk pɨx aagix nam tu namkiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Baꞌ jɨꞌk ɨp gu sandaaruiꞌx miꞌ dhɨr jaꞌp bhaiꞌp ba tɨkka am, jup tɨtda am: ―¿Aach gi, jax jaꞌk jach jup xi chu buadaꞌ na baꞌ puiꞌ cham jup jich chulhiiñchudaꞌ gu Dios? Baꞌ gu Juan jup ja tɨtda: ―Dho na pim cham jaroiꞌ jaꞌp pɨx bha taandaꞌ gu namkiꞌ noꞌ pim jix maat nat cham tuꞌ jax dhuu, ni ku pim cham tuꞌ kɨꞌn ji iattulhdhai mu paiꞌ ba kɨksaidhaꞌ na pim tañiidhaꞌ. Jaꞌkbuiꞌ pim pɨx kɨꞌn jix bhaiꞌm taat kaꞌ na pim jɨꞌk maiꞌchɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Baꞌ gu jaꞌtkam am naiꞌ tɨ nɨiꞌñdhaꞌ am nam jaꞌp jim aagɨt na tuꞌ pɨk jax ba ji dhuñiaꞌ gu Juan nam cham paiꞌ dhuuk pu chuꞌm nɨiꞌñdhaꞌ, xim tɨ tɨkkat am noꞌ sap baꞌr diꞌ guch Xoiꞌkam nat bhaiꞌ ba joot gu Dios guiꞌ na puiꞌ saak bha jootsaꞌ, kaꞌ baꞌ guꞌr jumai. ");
INSERT INTO stpNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Guꞌ ji na guꞌ bɨɨx jup ja tɨtda gu Juan nam jɨꞌk miꞌp tuꞌiiꞌ: ―Aañ xib dai suudaiꞌ kɨꞌn pɨx nañ yaꞌ ka jam bopkon na pim jax jiñ ñɨiꞌñ, matgɨm maaꞌn gatuuk dɨr bhaiꞌp jim ji guiꞌ nax ioꞌm jir gɇꞌkam, cham tuꞌ puiꞌ na aañ. Cham jɨꞌx iam jir jupaabkamuꞌn iñ nañ gɨt tuꞌ suuskaꞌn jup xi kookoxchulhdhaꞌ. Guiꞌ dho gi guꞌ jam bopkonaꞌ ji kɨꞌn gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ gio tai kɨꞌn, na guꞌx ioꞌm bɨxchuꞌx bhaiꞌ na pu tu duñiaꞌ na jax ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Gio guꞌ sia jaꞌp jup ji buusan japim na gu tiriik. Baꞌ pu uaꞌ guiꞌ na kɨꞌn jam jɨlhbidhaꞌ na pim jix chanaaraꞌ, jaꞌp jaꞌk dɨlhkob ji biꞌyaꞌ gux kɨɨꞌ, gio gu tanaaraꞌ jaꞌp jaꞌk ɨp. Baꞌ dai gux kɨɨꞌ ulhñaꞌ maaꞌn kap na paiꞌ dai gu tiriik jum ulhiis, gu tanaaraꞌ baꞌ mɨidhaꞌ na pu cham jɨꞌxkat ka tukiaꞌ gu tai. ");
INSERT INTO stpNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Puꞌñi jaꞌk baꞌ ja tɨtdadaꞌ gu Juan gu jaꞌtkam na tu ja aꞌgiꞌñdhaꞌ gux bhaiꞌm kaiꞌchdham ñioꞌkiꞌñ gu Dios, gam bɨɨx aixim nam jax jaꞌk jum guguuxdhaꞌ nam miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Baꞌ gu Juan jɨꞌkchi kim jup ñiok gux kaiꞌ Eroodis na sap cham jir am nat gan bhɨi gu Erodiiyas, sia ku tɨir bɨngaꞌn gu sɨpdhiꞌñ Piliip. Bɨɨx puiꞌp xi chɨtdadaꞌ na jɨꞌk tuꞌx buam tu buadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Guꞌ ji nat guꞌx bhaamut pɨx kai gu Eroodis, dai nat ba tu chia nam kuupaꞌ na sap gan buam tɨtda, alhiꞌch pup xim uaꞌtulh. ");
INSERT INTO stpNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Baꞌ jaꞌpnip tum duu janoꞌ na mɨt chakui kuupak gu Juan na mummɨ oirɨt Jordaan Ak ka ja bopkondaꞌ gu jaꞌtkam. Bɨɨx gu Jesuus chia ɨp na miꞌ bakuanaꞌ. Miꞌ nat xim bakuanak muiꞌ ji chu daanɨ buiñor gu Dios jix dhaam jaꞌk. Miꞌ dhɨr baꞌ joidham bhaiꞌ jim kupioꞌ gux dhaam miꞌ puiꞌ na ka tu daan. ");
INSERT INTO stpNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Baꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ maaxik bhammɨ dɨr bhaiꞌ ji chɨm jaꞌp tuꞌm na gu giodaꞌ. Gio baꞌ nat bhammɨ dɨr bhaiꞌ ba tum aꞌga, jup tum kaiꞌch: ―Aap jir diꞌ guñ mar nañ joidham jix ioꞌm xim daꞌ, na ñich guꞌ gɇꞌkam kɨꞌn jum aꞌm tɨ tɨɨ dai aap. ");
INSERT INTO stpNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Baꞌ naiꞌ ji chu ja aꞌgi gu Jesuus gu jaꞌtkam na ba biaꞌkaꞌ jɨꞌk maaꞌn ooꞌm daman mambhɨɨx oidhaꞌ. Baꞌ puiꞌ ɨlhiiꞌñdhaꞌ am gu jaꞌtkam nar taataꞌn kaꞌ gu Josee, gio miꞌ dhɨr gu Josee, Elii jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Gio miꞌ dhɨr gu Elii, Matat jup jir taataꞌn kat. Gio miꞌ dhɨr gu Matat, Lebii jup jir taataꞌn kat. Gio miꞌ dhɨr gu Lebii, Melki jup jir taataꞌn kat. Gio miꞌ dhɨr gu Melki, Jana jup jir taataꞌn kat. Gio miꞌ dhɨr gu Jana, Josee jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Gio miꞌ dhɨr gu Josee, Matatiiyas jup jir taataꞌn kat. Gio miꞌ dhɨr gu Matatiiyas, Amoos jup jir taataꞌn kat. Gio miꞌ dhɨr gu Amoos, Naum jup jir taataꞌn kat. Gio miꞌ dhɨr gu Naum, Elsi jup jir taataꞌn kat. Gio miꞌ dhɨr gu Elsi, Nagai jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Gio miꞌ dhɨr gu Nagai, Maat jup jir taataꞌn kat. Gio miꞌ dhɨr gu Maat, Matatiiyas jup jir taataꞌn kat. Gio miꞌ dhɨr gu Matatiiyas, Semei jup jir taataꞌn kat. Gio miꞌ dhɨr gu Semei, Josee jup jir taataꞌn kat. Gio miꞌ dhɨr gu Josee, Judaa jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Gio miꞌ dhɨr gu Judaa, Joanan jup jir taataꞌn kat. Gio miꞌ dhɨr gu Joanan, Reesa jup jir taataꞌn kat. Gio miꞌ dhɨr gu Reesa, Sorobabeel jup jir taataꞌn kat. Gio miꞌ dhɨr gu Sorobabeel, Salatiel jup jir taataꞌn kat. Gio miꞌ dhɨr gu Salatiel, Neeri jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Gio miꞌ dhɨr gu Neeri, Melki jup jir taataꞌn kat. Gio miꞌ dhɨr gu Melki, Aadi jup jir taataꞌn kat. Gio miꞌ dhɨr gu Aadi, Kosam jup jir taataꞌn kat. Gio miꞌ dhɨr gu Kosam, Elmadam jup jir taataꞌn kat. Gio miꞌ dhɨr gu Elmadam, Er jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Gio miꞌ dhɨr gu Er, Josue jup jir taataꞌn kat. Gio miꞌ dhɨr gu Josue, Elieser jup jir taataꞌn kat. Gio miꞌ dhɨr gu Elieser, Jorim jup jir taataꞌn kat. Gio miꞌ dhɨr gu Jorim, Matat jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Gio miꞌ dhɨr gu Matat, Lebii jup jir taataꞌn kat. Gio miꞌ dhɨr gu Lebii, Simeon jup jir taataꞌn kat. Gio miꞌ dhɨr gu Simeon, Judaa jup jir taataꞌn kat. Gio miꞌ dhɨr gu Judaa, Josee jup jir taataꞌn kat. Gio miꞌ dhɨr gu Josee, Jonaan jup jir taataꞌn kat. Gio miꞌ dhɨr gu Jonaan, Eliakiim jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Gio miꞌ dhɨr gu Eliakiim, Melea jup jir taataꞌn kat. Gio miꞌ dhɨr gu Melea, Mainaan jup jir taataꞌn kat. Gio miꞌ dhɨr gu Mainaan, Matata jup jir taataꞌn kat. Gio miꞌ dhɨr gu Matata, Nataan jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Gio miꞌ dhɨr gu Nataan, Dabii jup jir taataꞌn kat. Gio miꞌ dhɨr gu Dabii, Isayii jup jir taataꞌn kat. Gio miꞌ dhɨr gu Isayii, Obed jup jir taataꞌn kat. Gio miꞌ dhɨr gu Obed, Boos jup jir taataꞌn kat. Gio miꞌ dhɨr gu Boos, Salmoon jup jir taataꞌn kat. Gio miꞌ dhɨr gu Salmoon, Nasoon jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Gio miꞌ dhɨr gu Nasoon, Aminadab jup jir taataꞌn kat. Gio miꞌ dhɨr gu Aminadab, Aram jup jir taataꞌn kat. Gio miꞌ dhɨr gu Aram, Arni jup jir taataꞌn kat. Gio miꞌ dhɨr gu Arni, Esrom jup jir taataꞌn kat. Gio miꞌ dhɨr gu Esrom, Paaris jup jir taataꞌn kat. Gio miꞌ dhɨr gu Paaris, Judaa jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Gio miꞌ dhɨr gu Judaa, Jakob jup jir taataꞌn kat. Gio miꞌ dhɨr gu Jakob, Isaak jup jir taataꞌn kat. Gio miꞌ dhɨr gu Isaak, Abraam jup jir taataꞌn kat. Gio miꞌ dhɨr gu Abraam, Taree jup jir taataꞌn kat. Gio miꞌ dhɨr gu Taree, Nakor jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Gio miꞌ dhɨr gu Nakor, Serug jup jir taataꞌn kat. Gio miꞌ dhɨr gu Serug, Ragau jup jir taataꞌn kat. Gio miꞌ dhɨr gu Ragau, Peleg jup jir taataꞌn kat. Gio miꞌ dhɨr gu Peleg, Eber jup jir taataꞌn kat. Gio miꞌ dhɨr gu Eber, Sala jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Gio miꞌ dhɨr gu Sala, Kainaan jup jir taataꞌn kat. Gio miꞌ dhɨr gu Kainaan, Arpajad jup jir taataꞌn kat. Gio miꞌ dhɨr gu Arpajad, Sem jup jir taataꞌn kat. Gio miꞌ dhɨr gu Sem, Noee jup jir taataꞌn kat. Gio miꞌ dhɨr gu Noee, Lamek jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Gio miꞌ dhɨr gu Lamek, Matusaleen jup jir taataꞌn kat. Gio miꞌ dhɨr gu Matusaleen, Enok jup jir taataꞌn kat. Gio miꞌ dhɨr gu Enok, Jared jup jir taataꞌn kat. Gio miꞌ dhɨr gu Jared, Mahalaleel jup jir taataꞌn kat. Gio miꞌ dhɨr gu Mahalaleel, Kainaan jup jir taataꞌn kat. ");
INSERT INTO stpNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Gio miꞌ dhɨr gu Kainaan, Enoos jup jir taataꞌn kat. Gio miꞌ dhɨr gu Enoos, Set jup jir taataꞌn kat. Gio miꞌ dhɨr gu Set, Adaan jup jir taataꞌn kat. Baꞌ miꞌ dhɨr gu Adaan, gu Dios jup bar taataꞌn, nat guꞌ dhiꞌ bɨɨpɨꞌ ya doꞌñcho gu Dios dhi oiꞌñgaꞌn bhaan. ");
INSERT INTO stpNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Baꞌ miꞌ Jordaan Ak nat jum bakua gu Jesuus, gɇꞌ bhaan jum tajaa gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ. Miꞌ dhɨr baꞌ pu sɨlh mu jaꞌk bhɨi maaꞌn kap gampɨx jix chu gak kɨr na paiꞌ pu cham jaroiꞌ oirɨ, na guꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ pɨx nat puiꞌ jurtuda. ");
INSERT INTO stpNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Pu kaiꞌñkam pɨx mu jaꞌk bhɨi nat miꞌm saabum gook ooꞌm tanoolh gam gu bɨx chukaaꞌ, pu cham tuꞌ nat juu. Baꞌ nat paiꞌ pu ba aich gu jaꞌkbuiꞌ tanoolh gio gu bɨx chukaaꞌ nam saab, gu jaꞌook miꞌ ba ai. Tɨi ɨlhdhat na miꞌ maiꞌchiaꞌ gɨt na kapbhaiꞌ miꞌ kax bhioꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","jup tɨtda: ―Noꞌp sɨlhkam aap Dios jir maraaꞌn, eap jaꞌp tɨɨꞌn dhi jodai na paan jup jum duñiaꞌ noꞌt moo puiꞌm duu. ");
INSERT INTO stpNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Baꞌ gu Jesuus jup tɨtda: ―Jax dhui nap jum kaiꞌch miꞌ na mɨt paiꞌ tu uaꞌnak gu bɨjɨk dɨr kam nax ioꞌm jum aaꞌ na miꞌ puiꞌ jimdaꞌ gu maaꞌnkam na jax jix aaꞌ gu Dios na baꞌx bhaiꞌ tu jimdaꞌ, cham tuꞌ gu tuꞌ koiꞌ kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Miꞌ dhɨr baꞌ maaꞌn oidhaꞌ kuuꞌ am xi baidhak xi chu joojoiꞌñchuda bɨɨx kap na jɨꞌx gɇꞌgɇr jir kikcham na jɨꞌx jir oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Baꞌp tɨtda: ―Jiñ aꞌm jup tu tuꞌiiꞌ bɨɨx dhiꞌ nap jɨꞌk tuꞌ nɨiꞌñ, pu bɨjɨk dɨr jiñ aꞌm tu bii nat dɨr yaꞌ ji tum kikchamta dhi oiꞌñgaꞌn bhaan. Baꞌ aañ yaꞌ dɨr jaꞌp jaꞌk puiꞌp jix bhaaiꞌ nañ tu makiaꞌ gu jaroiꞌ nañ ɨlhiiꞌñdhaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","puiꞌ na jax aap tum makiaꞌ iñ noꞌ pich miꞌñi jaꞌp jum oꞌlhia kɨꞌn kɨkbok puiꞌ xi chɨi nañ aañ jir gɇꞌkam. Bɨɨx jum aꞌm ji chu biꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Baꞌ gu Jesuus jup tɨtda: ―Jax dhui na guꞌp jum kaiꞌch ɨp miꞌ na mɨt paiꞌ tu uaꞌnak gu bɨjɨk dɨr kam na dai gu Dios jix bhaiꞌ nach gɇꞌkamtuꞌndaꞌ, cham tuꞌ jumai. Dai guiꞌ pɨx jach jir tujuandam tugiꞌñ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Baꞌ bhammɨ jaꞌk jup baidhak Jerusaleen bhaiꞌ na paiꞌ kɨɨk gu gɇꞌ chiop, kuugaram xi kɨɨsak jup tɨtda: ―Eap yaꞌ dɨr mu tuudaiñ noꞌ sɨlhkam jum aꞌm tɨ nɨidhim gu Dios nap saak puiꞌr maraaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Gio guꞌp jum kaiꞌch miꞌ paiꞌ na mɨt tu uaꞌnak gu bɨjɨk dɨr kam: Gu Dios bha ja jootsaꞌ gu noonbiꞌñ nam jum nuukdaidhaꞌ gammɨjɨ na cham tuꞌm duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tɇꞌkob jum bapmiꞌñdhidhaꞌ am nap baꞌ cham miꞌ paiꞌ jax chuꞌm jodai chaꞌm jutbui ɨlhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Baꞌ gu Jesuus jup tɨtda: ―Jax dhui nap jum kaiꞌch ɨp sia miꞌ na mɨt paiꞌ tu uaꞌnak gu bɨjɨk dɨr kam nax xidhuu noꞌ jaroiꞌ mamaiꞌchɨk gu Dios, na guꞌr gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Baꞌ cham ka bhaaiꞌ gu jaꞌook na jax dhui ka maiꞌchiaꞌ gu Jesuus, puiꞌ ma jii ɨp gio. Ku guꞌ gatuuk gio tɨip maiꞌchiaꞌ ji. ");
INSERT INTO stpNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Baꞌ gu Jesuus giop ba jii mu jaꞌk Galilea, pu maaꞌn na jax gɇꞌ bhaan tajaañixchuꞌndaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ, gam na bɨxchuꞌ bax chu bhaaiꞌ na pu tu duñiaꞌ gu tuꞌ na jax ɨlhiiꞌñdhaꞌ. Baꞌ bɨɨx na jɨꞌx Galilea dɨbɨɨr bhaan bipioꞌ pɨx jaꞌx puiꞌ kaiꞌchdhaꞌ am gu jaꞌtkam na mu paiꞌ joidham jix bhaiꞌ tu bua gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mi jaꞌp baꞌ pu tu ja aꞌgiꞌñdhaꞌ chichiop gu Israel kam jaꞌtkam nam paiꞌ jax jum jumpaꞌndaꞌ nam tu daandaꞌ buiñor gu Dios. Baꞌ joidham kɇɇkɇꞌ am, pɨx jix bhaiꞌ aaꞌndaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Miꞌ dhɨr baꞌ mu jaꞌk ba ai gu Jesuus Nasareet na paiꞌ gɨꞌlhix. Baꞌ nat giop bam ai nam paiꞌ dhuuk cham tu juandaꞌ dai gu Israel kam jaꞌtkam, mu ba ai chiop nam paiꞌm jumpaꞌndaꞌ ɨp nam tu daandaꞌ gu miꞌ kam. Baꞌ xi chia mɨt na kɨkboi xi ja jiñkaixdhaꞌ gu ñioꞌkiꞌñ gu Dios, ");
INSERT INTO stpNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","xi maa mɨt gu uꞌuan guiꞌ nat Isaiiyas tu uaꞌnak, guiꞌ na bɨjɨk bhaankam gu Dios tu ja aꞌgidhimɨk gu jaꞌtkam. Baꞌ nat bhaiꞌ ji sɨlh, ba tɨɨ miꞌ na paiꞌ jaꞌpnim kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Gux Dhuuduꞌ kam jix Uañ Iiꞌmdagaꞌn gu Dios jiñ aꞌm tajaañix, nat guꞌ dɨɨlh gu Dios jiñ aꞌm tɨ tɨɨgɨk jiñ tajaañ nañ baꞌ ya jaꞌp tu ja aꞌgidhaꞌ gux bhaiꞌm kaiꞌchdham ñioꞌkiꞌñ guiꞌ nam soiꞌ tuꞌiiꞌ nam cham tuꞌ biaꞌ ni jɨꞌx, gio guiꞌ nam jɨꞌk kuup jañ xi ja doꞌñchoi xi ja chiñiaꞌ nam jix bhaiꞌm taatɨt mu jaꞌp ba oipodaꞌ, gio guiꞌ nam cham ñiññia kaꞌ nañ tu ja tɨɨꞌñchodaꞌ. Bɨɨx guiꞌ nam jɨꞌk jum tulhiiñ jañ jix bhaiꞌ ja duñiaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","xi ja aagiꞌñdhaꞌ iñ nat ampɨx jum ai oidhaꞌ nat jix joiꞌmdak ja aꞌm ba tɨ tɨɨ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Baꞌ nat tɨɨmok gu Jesuus nat ja jiñkaix, giop xi ñansapak gu uꞌuan mu jaꞌk xi maakak guiꞌ na miꞌr tujuandam chiop mi jaꞌp ji dhaibu ɨp gio. Guꞌ ji nam guꞌ bha tɨ nɨiꞌñ gu jaꞌtkam nam tɨ nɨɨra na ja aagiꞌñdhaꞌ na jax kaiꞌñkam jup jum kaiꞌch miꞌ nat paiꞌ ja jiñkaix. ");
INSERT INTO stpNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Baꞌp ja tɨtda gu Jesuus: ―Dhiꞌ na pimɨt jɨꞌk jax kai na ñich jam jiñkaix gu ñioꞌkiꞌñ gu Dios, xib yaꞌ puiꞌ ba tu tuiꞌdhiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Baꞌ pɨx jix bhaiꞌm taat am bɨɨx gu jaꞌtkam nam miꞌp tuꞌiiꞌ nam joidham kɇɇ na tu aꞌga gu Jesuus, pɨx jup jum tɨ tɨtda am: ―¿Dhiꞌ aa gu Josee gu maraaꞌn? ");
INSERT INTO stpNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Baꞌ gu Jesuus jup ja tɨtda ɨp gio: ―Jaꞌp japim dho chiñ chɨɨdaꞌ nam jax kaiꞌchdhaꞌ yaꞌ gu jaꞌtkam na saak jix bhaaiꞌ na dɨɨlh xim duaꞌñdhai noꞌ bax kaꞌook gu jaroiꞌ nax maatɨt ja duduadhiꞌñdhaꞌ gu jaꞌtkam. Gam chi jaꞌpni: “Puiꞌ na chich jax tɨ kai na pich joidham jix bhaiꞌ tu duu mu Kapernaum, puiꞌp jup xi chu duñiaꞌ yaꞌm dɨrbaꞌ am na pich paiꞌ gɨꞌɨɨr.” ");
INSERT INTO stpNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Muiꞌ xi chu ja aꞌgiꞌñchuꞌ gu Jesuus, jup ja tɨtda: ―Jax dhui nam guꞌ cham jɨɨgiꞌñdhaꞌ gu jaꞌtkam gu jaroiꞌ noꞌ tɨi bhaankam gu Dios tu ja aꞌgiꞌñ gu ñioꞌkiꞌñ noꞌr miꞌ kam, aañ moo yaꞌ pu jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Jax japim gix maat janoꞌ na gu Eliiyas yaꞌ xi oilhimɨk na puiꞌ bhaankam jup tu aꞌgimɨk gu Dios, maaꞌnnim bo nat yaꞌ giilhim bhiogiꞌ ma jii bɨɨx kap na jɨꞌx jir Israel, cham duuꞌn baik oidhaꞌ daman taak. Muiꞌx jaiꞌch kaꞌ am guꞌ tɨi gu dɨꞌdɨlhdhɨm uꞌuub yaꞌ dhi Israel, ");
INSERT INTO stpNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","guꞌ pɨx ji nat guꞌ gu Dios mummɨ jaꞌk joot gu Eliiyas na paiꞌ Sarepta tɨ tɨɨꞌ, na miaꞌn bipioꞌ gama jaꞌk na paiꞌ Sidoon jup tɨ tɨɨꞌ nax ioꞌm muiꞌ paꞌ daaꞌñxim jir kikcham, na guꞌ miꞌx jaiꞌch kaꞌ maaꞌn gu ubii dɨlhdhɨm. Tɨɨꞌ na guꞌr maakam jaꞌk kam gu dɨlhdhɨm ubii nat buiñor joot gu Dios gu Eliiyas, cham tuꞌ iam jir Israel kam. ");
INSERT INTO stpNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Gio janoꞌ na gu Eliseo puiꞌ bhaankamuꞌn gu Dios yaꞌp tu ja aꞌgidhimɨk gu jaꞌtkam, janoꞌ giilhim ma tu ai guiꞌ na tootolhidhat gakiidhaꞌ gu ja tutkuꞌ gu jaꞌtkam bɨɨx kap yaꞌ na jɨꞌx jir Israel. Tɨɨꞌ nat guꞌ gu Namaan pɨx duaꞌñ nar mummɨ jaꞌk kam Siiria, ni kut iam maadɨt gu yaꞌ kam Israel duaꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Baꞌ na mɨt puiꞌ kai, giilhim bhaiꞌ ji bhaak jamɨt bɨɨx guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Daagɨk jamɨt xi buusaidhak dɨɨrap bhaiꞌ bhɨich gu taiꞌ na paiꞌ taiꞌgɨm jir kikcham, nammɨ baas dɨr jaꞌp amuub kookbaꞌn ba aichdhidhat am na paiꞌx babaaꞌ nam sap baꞌ miꞌ dhɨr mɨjɨmmɨ xi ñuiꞌññaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Guꞌ ji nat guꞌ gu Jesuus miꞌ buus ja saagiꞌñ, gaammɨjɨ ji dhuu. ");
INSERT INTO stpNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mu jaꞌk baꞌ pu bhɨi gu Jesuus Kapernaum na paiꞌ Galilea bhaan bipioꞌ gu dɨbɨɨr, baꞌ miꞌ pu tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam chiop janoꞌ nam paiꞌ dhuuk cham tu juandaꞌ dai gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Baꞌ joidham kɇɇkɇꞌ am, na guꞌx gɨꞌm tu ja aꞌgiꞌñdhaꞌ, cham tuꞌ jaaxmadaꞌ kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Baꞌ miꞌ dhi chiop maaꞌn miꞌx jaiꞌch kaꞌ gu maaꞌnkam na bhaan jup tuiꞌñgɨdaꞌ gu cham kɨɨꞌ iiꞌmdaꞌ, ampɨx puiꞌx ñaanbiꞌ kaꞌ. Baꞌ gɇꞌ kɨꞌn bhaiꞌ dhɨr jaꞌp muiꞌ ba jiiñ na ka tu aꞌga gu Jesuus, jup kaiꞌch: ");
INSERT INTO stpNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¿Jax japich bhaiꞌ bach dhoodam Jesuus Nasareet kam? ¿Nap yaꞌch koodaꞌ aa? Cham ji nap puiꞌch buadaꞌ. Jix maat iñ guꞌ nap aap jir jix uañ nap bhaankam ya oirɨ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Guꞌ ji nat guꞌ gu Jesuus pu ñiok, jup tɨtda: ―¡Chaꞌp ñiokdaꞌ cham kɨɨꞌ iiꞌmdaꞌ nap bhaiꞌ bhaan baaxchugɨt naanbichuꞌn dhiñ jaduuñ! Mup buusniaꞌ bhaiꞌ dhɨr, chaꞌp bhaiꞌ pu tuiꞌñgɨdaꞌ. Baꞌ mi jaꞌp ji ia gu maaꞌnkam ja taagiob guiꞌ nam miꞌp tuꞌiiꞌ, nat guꞌ gu cham kɨɨꞌ iiꞌmdaꞌ puiꞌ xi dhoodak nat baꞌ pɨk ba buus bhaiꞌ dhɨr bhaan. Gio baꞌ bhaiꞌp ji bam gu maaꞌnkam, dai na bax kɨɨꞌ, cham tuꞌ ka naanbiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Baꞌ gu jaꞌtkam giilhim bax chotdon am bɨɨx nam jɨꞌk miꞌp tuꞌiiꞌ nam jax tɨ nɨiꞌñ, pɨx jup jum tɨ tɨtda am dɨɨlh: ―¡Aa guꞌx ioꞌm jir gɇꞌkam ji bak jia dhich jaduuñ nam baꞌ gam cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ jix jɨɨgiꞌñ na ja ñiokiꞌñ! ");
INSERT INTO stpNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Baꞌ naiꞌ pɨx jaꞌx puiꞌ tum kaiꞌchdhaꞌ na jɨꞌx jir Galilea na mu paiꞌ joidham tu buadaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Baꞌ miꞌ dhɨr nat buusnɨk chiop gu Jesuus, sɨlh jii gama jaꞌk na paiꞌ tu baꞌaak gu Simoon Peegro. Guꞌ ji na guꞌ janoꞌ pɨk jup jix kaꞌook toiñdhiꞌ kɨꞌn gu daadaꞌn gu Simoon Peegro, mɨjɨ boꞌ baꞌm bakxidhat baꞌk chɨr. Baꞌ bɨɨx dhɨt soiꞌ ba tɨtda am gu Jesuus guiꞌ nam mi oiꞌdhaꞌ na iam duaꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Baꞌ muiꞌ ji ai ɨp gu Jesuus amuub na paiꞌ boꞌ, baꞌ bɨɨpɨꞌ xi mugiaꞌtɨk nat baꞌ miꞌ dhɨr xi ñiok gu koꞌkdaiꞌ na toiñdhichuꞌn. Jix kɨɨꞌp jum duu gu daadaꞌn gu Simoon, miꞌ dhɨr dai nat bamgɨk ba tu ja onbaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Baꞌ nat paiꞌ pu ba jur, nat ampɨx bhɨjɨ ji bhiꞌñ gu tanoolh, muiꞌ gu jaꞌtkam pɨx miꞌ ji ai mɨt na paiꞌ gu Jesuus ji ja baidhat gux kakoꞌkkam bɨɨx aixim tuꞌm na ja ɇɇkaꞌ na baꞌ ja duduaꞌñdhaꞌ. Baꞌ gu Jesuus pɨx jup ji ja duduaꞌñ, dai na bhaiꞌ pɨx xi ja daꞌngim. ");
INSERT INTO stpNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Muiꞌ mɨt miꞌp ja aich guiꞌ nam ampɨx jix ñanaanbiꞌ kaꞌ na ja aꞌm jup tuiꞌñgɨdaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ. Baꞌp tɨtdadaꞌ am gu Jesuus gɇꞌ kɨꞌn: ―Aap jir diꞌ gu maraaꞌn gu Dios. Guꞌ ji na guꞌ maaꞌn na jax ñiokdhai pu maiꞌ jootsaꞌ gu Jesuus bhaiꞌ dhɨr bhaan gu maaꞌnkam, na guꞌ dhiꞌ pɨx na puiꞌ jurtuꞌnkaꞌ na baꞌ miꞌ dhɨr puiꞌp kaiꞌchdhaꞌ. Jix maat am guꞌ nar diꞌ guiꞌ na bhaankam ya oirɨ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Baꞌ cham jaroiꞌ ji aaꞌñdhak gu Jesuus kapbhuimuk ba jii miꞌ dhɨr na paiꞌ muiꞌ daaꞌñxim jir kikcham, nammɨ jaꞌk bhɨi maaꞌn kap na paiꞌ cham jaroiꞌ oirɨ. Guꞌ ji na mɨt guꞌ naiꞌ ji gaꞌngimɨ gu jaꞌtkam na mɨt paiꞌ dhuuk tɨɨ na cham tu jaiꞌch, mummɨ ba ji bubua mɨt na paiꞌ ka oirɨ. Baꞌ tɨix aagɨt am nam gɨt gio jaꞌk jup buaꞌ, guꞌ ji na guꞌ cham aaꞌ gu Jesuus, ");
INSERT INTO stpNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","jup ja tɨtda: ―Jax dhui nat guꞌ aañ pu kaiꞌñkam bhañ joot gu Dios nañ bɨɨx kap ja aaꞌñdhaꞌ gu jaꞌtkam nat jix ja joiꞌmdak ja aꞌm ba tɨ tɨɨ, sia ku guꞌx ioꞌm jir gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Baꞌ naiꞌ jaꞌp pu tu ja aꞌgiꞌñdhaꞌ gu Jesuus gu Israel kam jaꞌtkam bɨɨx kap chichiop nam paiꞌm jumpaꞌndaꞌ nam tu daandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Baꞌ mummɨ jaꞌk Genesareet jup ba tu ja aꞌgiꞌñ gu Jesuus gu jaꞌtkam, juꞌñdharam gu gɇꞌ suudaiꞌ Galilea kam. Giilhim muiꞌ mim jumaap jamɨt gu jaꞌtkam nam jix kaim na jax tu aꞌga gu ñioꞌkiꞌñ gu Dios, ba kiꞌsap pɨx baꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Baꞌ ba ja tɨɨ gook gu kaknub jup tuutuꞌm na mu jaꞌp nangiaꞌ suudaiꞌ jugiiꞌñ, na mɨt guꞌ tɨɨtmigɨk mi jaꞌp jup ka ja bopkon gu gɇꞌgɇr aꞌsak gu boptop bhibhiadam. ");
INSERT INTO stpNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Baꞌ guiꞌ na Simoon Peegro jir kanuub gaꞌn bhaan xi chɨsdɨk jup tɨtda na palhɨɨp kuuꞌ xi jimiichdhaꞌ miꞌ dhɨr juꞌñdharam, bhaiꞌ baꞌ dɨr daakat bha tu ja aꞌgiꞌñ gu jaꞌtkam muiꞌ nam miꞌp tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Baꞌ nat paiꞌ tɨɨmok na tu aꞌgimɨk, jup tɨtda gu Simoon Peegro: ―Ea nap mummɨni jaꞌk xi jimiichdhaꞌ dhi kanuub na paiꞌx ioꞌm jix chuuk gu suudaiꞌ, miꞌ pim baꞌ xi iabuꞌ dhi gɇꞌgɇr jam aꞌsak nam mim iichaꞌ gu boptop. ");
INSERT INTO stpNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Baꞌp kaiꞌch gu Simoon Peegro: ―Jax dhui nam cham jaiꞌch gu boptop ya jaꞌp jiñ jaduuñ. Aach bɨx chukaaꞌ ya jaꞌp tɨi pu ja iabuim dhi gɇꞌgɇr aꞌsak, nim maaꞌn ku chich bhia. Kaꞌ baꞌ nap guꞌ aap puiꞌ ba kaiꞌch jiñ jaduuñ, ea nach mu ja iabupuꞌ dhich aꞌsak. ");
INSERT INTO stpNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Baꞌ muiꞌ xi ja iabuk jamɨt gio bhaiꞌ tɨip ji ja boosolh. Giilhim jix bɨɨpɨt, nam guꞌ muiꞌ mi jiim gu boptop, pɨx am kɨkkrunim gu aꞌsak nam mu ja baissɨnim. ");
INSERT INTO stpNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Baꞌ cham bha aajim gu dai maaꞌn kaꞌm gu kanuub, ma ja bañioꞌra mɨt guiꞌ nam mummɨ juꞌñdharam oipo nam mu bhɨikaꞌ gu ja kanuub nam jaiꞌ tu iichaꞌ. Jupaaban jamɨt xi ja juꞌñ gu boptop bhaan gu gook kaknub taꞌm, pɨx jix baapkimtuꞌ nam mu jaꞌk ba ja uaꞌ juꞌñdharam. ");
INSERT INTO stpNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Baꞌ gu Simoon Peegro mi jaꞌp oꞌlhiaꞌn kɨꞌn xi kɨkbok jup tɨtda gu Jesuus: ―Cham jir am nañ jum bɨɨm oirɨdaꞌñ jaduuñ, nañ guꞌ aañ giilhim jix uaꞌtulhdhix. ");
INSERT INTO stpNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jix chooꞌn guꞌ gu Simoon Peegro ja bɨɨm guiꞌ nam gammɨjɨ maap pu tu bhibhiadaꞌ bhaan gu kanuub gaꞌn, nam guꞌ cham jɨꞌxkat jaꞌkbuiꞌ ja bhiadat gu boptop. ");
INSERT INTO stpNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sia guiꞌ mɨt jup jix chootoꞌn na mɨt ja bai nam jaiꞌ tu iichaꞌ, na Jakoobo tɨɨꞌ gio jumai Juan, jir maamraꞌn maaꞌn Sebedeo tɨɨgim. Gu Jakoobo gio gu Juan maap gu Simoon Peegro naiꞌ pu tu bhibhiijidhaꞌ am bhaan gu dɨɨlh ja kaꞌknubiꞌ. Baꞌ gu Jesuus jup tɨtda: ―Chaꞌp ka toodon kaꞌ, nap guꞌ aap xib dɨr jaꞌp jaꞌk dai gu jaꞌtkam pɨx ba ja bhiadaꞌ jaꞌp na gu boptop. ");
INSERT INTO stpNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Baꞌ bɨɨx guiꞌ nam jɨꞌk maap tu bhiadat gu boptop, mi jaꞌp xi ja tuꞌaak jamɨt gu ja kaknub suudaiꞌ jugiiꞌñ pu oi gu Jesuus. Cham jamɨt tuꞌ kap jum buix nam bhaan ka tu juanat. ");
INSERT INTO stpNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Maaꞌnnim gu Jesuus maaꞌn kap ka oirɨ na paiꞌ muiꞌ paꞌ daaꞌñxim jir kikcham. Mi jaꞌp ba jim maaꞌn gux koꞌkkam na ɇɇkaꞌ guiꞌ na tootolhidhat gakiidhaꞌ gu tukgaꞌn. Baꞌ nat ba tɨɨ na mi jaꞌp ba jim gu Jesuus, mu mɨraak bɨɨpɨꞌ dɨr mi oꞌlhiaꞌn kɨꞌn ba kɨkbo, dɨɨrap xi chu siispich gu kobaaꞌn na soiꞌm ɨlhiiꞌñ na duaꞌñdhaꞌ, jup tɨtda: ―Aapiꞌñ jaduuñ, iam jap jiñ dhuaꞌñdhaꞌ nañ jix kaꞌook noꞌp iam puiꞌp ɨlhiiꞌñdhaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Baꞌ gu Jesuus jix joiꞌmdak tɨɨ, bhaiꞌ xi dhaagɨk jup tɨtda: ―Jum duaꞌñdhaꞌ iñ ji matgɨm, chaꞌp jax jum aaꞌndaꞌ. Jaña, bam duaꞌñ jañich. Baꞌx kɨɨꞌp jum duu miꞌ jotmodaꞌ, daipuꞌ nat xi chɨɨꞌn gu Jesuus, pu cham paiꞌ matgir guiꞌ na kɨꞌn kax kaꞌook kat. ");
INSERT INTO stpNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Baꞌ xi sooꞌmchulhdhak gu Jesuus na cham jaroiꞌ aagiꞌñdhaꞌ nat duaꞌñ, jup tɨtda: ―Chaꞌp jaroiꞌ aagiꞌñdhaꞌ na ñich aañ jum duaꞌñ. Sɨlh jap pɨx jimiaꞌ mu chiop na paiꞌ daa guiꞌ na ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, na baꞌm tɨgiaꞌ na pich ba dua. Baꞌ noꞌ jax kaiꞌch nap bax kɨɨꞌ, tɨ tɨkiaꞌ ap na jax jaꞌk aagix nat tu uaꞌnak gu Moisees nam baꞌ bhaan machiaꞌ gu jaꞌtkam na cham tuꞌ kam ɇɇ gu koꞌkdaiꞌ dhiꞌ na jax chuꞌm jum ɇɇkat. ");
INSERT INTO stpNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Baꞌ sia ku puꞌñi tɨi xi ja sosbhichulhiꞌñdhat gu Jesuus guiꞌ na ja duduadhiꞌñdhaꞌ nam cham jaroiꞌ aagiꞌñdhaꞌ nat jaroiꞌ ja duduaꞌñ, pɨx na jaꞌp ji kaiꞌñchaidhaꞌ cham matgɨm na jɨꞌk jax joidham tu buadaꞌ. Pɨx ji muiꞌdhidhaꞌm baꞌ gu jaꞌtkam nam paiꞌ dhuuk mim jumpaꞌndaꞌ na paiꞌp tuiꞌkaꞌ gu Jesuus nam jix kaim kaꞌ na tu aꞌgadaꞌ, gio jaiꞌ nam jix dhuduadhik kaꞌ nam jix kakoꞌk kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kuꞌ guꞌ ba jimiaꞌ ji gu Jesuus mummɨ jaꞌp gampɨx na paiꞌ cham jaroiꞌ oirɨdaꞌ na ba tu daañmɨraꞌ buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Baꞌ jɨꞌk jurniꞌñ kɨꞌn maakam jaꞌk jup ba tu ja aꞌgiꞌñ gu Jesuus gu jaꞌtkam. Muiꞌ miꞌp tuꞌiiꞌ am guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios gio guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, muiꞌ kap dɨr mi ai mɨt guꞌ gu jaꞌtkam na jɨꞌx jir Galilea gio na jɨꞌx jir Judea dɨr, sia Jerusaleen dɨr jamɨt miꞌp xi ai. Baꞌ gu Jesuus jix maatɨꞌ kaꞌ na bɨɨx aixim jix bhaaiꞌn kaꞌ na pu tu duñiaꞌ na jax ɨlhiiꞌñdhaꞌ, na guꞌ ja duduadhiꞌñdhaꞌ gux kakoꞌkkam. ");
INSERT INTO stpNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Baꞌ jɨꞌkchi gu jaꞌtkam mɨjɨ dɨr jaꞌp ba aich jamɨt maaꞌn gux ioꞌm jix maꞌmkulhiꞌ bakxidhar taꞌm. Tɨim sap jii mɨt bhɨjɨ pu baasaꞌ gɨt baꞌk chɨr na paiꞌp tuꞌiiꞌ gu Jesuus na duaꞌñdhaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","guꞌ ji na guꞌ pu cham jir jim bha kiꞌñgob, nam guꞌ giilhim jix kabkam suudaꞌ gu jaꞌtkam. Baꞌ puiꞌ mɨt alhiꞌch ma dɨgaar gu baꞌaak daam dɨr na mɨt baꞌ mu tɨsaaꞌñdhak bhaiꞌ dhɨr mu tɨbaañ bakxidhar taꞌm mɨjɨ na paiꞌp tuꞌiiꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Baꞌ nat ba ja tɨɨ gu Jesuus nam buiñor jix biiñaktuꞌ, jup tɨtda gux maꞌmkulhiꞌ: ―Ba uañchudhix ji matgɨm gum uaꞌtulhdharaꞌñ jaduuñ, na ñich guꞌ aañ puiꞌ ba tɨi. ");
INSERT INTO stpNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios gio guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, jup jum aaꞌ am ja jujur am bhaan: “¿Jax baꞌm ɨlhdhat puiꞌ kaiꞌch dhi maaꞌnkam? ¿Dios aam ɨlhiiꞌñ? ¿Jax gi dhuip ba uañchudaꞌ gu uaꞌtulhdharaꞌ gu jaroiꞌ yaꞌ kam pu chuꞌm ɨp jix uaꞌtulhdhix kam? Dios dho gi jɨɨꞌ ji.” ");
INSERT INTO stpNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Guꞌ ji na guꞌx maat gu Jesuus nam jax jum aaꞌ, baꞌp ja tɨtda: ―¿Jax ku pim baꞌ puiꞌm aaꞌ jam jujur am bhaan? ");
INSERT INTO stpNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Jax dhui na cham tuꞌ xijai noꞌñ jax kaiꞌch: “Ba uañchudhix ji matgɨm gum uaꞌtulhdharaꞌ”, na guꞌ cham maatɨꞌ kaꞌ noꞌ moo puiꞌ ji buusniaꞌ piam ku guꞌ cham. Guꞌ ji noꞌñ jax kaiꞌch: “Xi bamiiꞌ, munip jaꞌp ba oirɨdaꞌ”, dho gi guꞌx xijai ji, na guꞌx maatɨꞌ kaꞌ noꞌt cham puiꞌ ji buus. ");
INSERT INTO stpNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ku baꞌ guꞌ aañ xib yaꞌ duaꞌñdhaꞌ ji dhiñ jaduuñ nax maꞌmkulhiꞌ na pim baꞌ bhaan machiaꞌ nach gook dɨt maap jich kɇkɇɇ gu Dios, gio na bɨxchuꞌx bhaaiꞌ nañ pu tu duñiaꞌ nañ jax ɨlhiiꞌñdhaꞌ. Jix bhaaiꞌ baꞌ nañ tu uañdhaꞌ gu uaꞌtulhdharaꞌ yaꞌ dhi oiꞌñgaꞌn. Baꞌp tɨtda gux maꞌmkulhiꞌ puiꞌ xi chɨꞌɨɨk: ―Aapiꞌñ jaduuñ nap jix maꞌmkulhiꞌ, xi bamiiꞌ, ba jimiaꞌ ap jum kiꞌaam bhɨɨji dhim bakxidharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Baꞌx kɨɨꞌ bhaiꞌ ji bam guiꞌ na kax maꞌmkulhiꞌ kat nat jax pu tɨɨꞌn gu Jesuus, xi bhɨɨk gu bakxidharuꞌn gamaiꞌ ba buus ja saagiꞌñ gu jaꞌtkam gaammɨjɨ ji dhuu xi taxchaabgidhidhat gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Baꞌ giilhim jix chootoꞌn jamɨt bɨɨx, miꞌ puiꞌ pup tuꞌiiꞌ am. Jup kaiꞌch am soiꞌm ɨlhdhat buiñor gu Dios: ―Xib jachich dho gi baꞌ ma tɨ tɨɨ ji nach tuꞌ cham paiꞌ dhuuk pu chuꞌm tɨ nɨidhat. ");
INSERT INTO stpNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Baꞌ jaꞌxpɨx nat miꞌ dhɨr buusnɨk gu Jesuus, mummɨ gama jaꞌk jaꞌp jup ba jim maaꞌn kap na paiꞌ daakat pɨx ji iichaim gu tuumiñ maaꞌn Lebii tɨɨgim, na guꞌ maadɨt jir diꞌ gu tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam. Baꞌ gu Jesuus mi jaꞌp miaꞌn xi ɇɇk jup tɨtda: ―Jiñ jaduuñ, maik, bañ kaichgɨdaꞌ ap. ");
INSERT INTO stpNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Baꞌ gu Lebii nat jax kɨkbo pɨx miaꞌn bhɨi ɨp gu Jesuus cham tuꞌp jim buixdhak guiꞌ na miꞌ bhaan ka tu juanat, miꞌ puiꞌ pup tu tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mɨkkat baꞌ ma tu piastata mu kiaꞌmiꞌñ gu Lebii nax bhaiꞌm taat na ba kaichuꞌ gu Jesuus. Muiꞌ ja bai guiꞌ nam jir tuumiñ tutaandam tugiꞌñ kaꞌ gux ioꞌm gɇꞌkam Rooma kam, gio jaiꞌ muiꞌ gu jaꞌppɨx jaꞌtkam. Baꞌ nam bɨɨx miꞌ maap daraat ka tu kuaꞌ bɨɨmaꞌn gu Jesuus, ");
INSERT INTO stpNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","bax bhaak am guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios gio guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ na mɨt ba ja tɨɨ, jup ja tɨtda am guiꞌ nam kaichuꞌ gu Jesuus: ―¿Jax ku pim baꞌ gan ja bɨɨm tu kuaꞌ dhi tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam gio dhi jaiꞌ jaꞌtkam nam cham tuꞌ kaꞌm tɨ nɨiꞌñ? Giilhim jix uꞌuaꞌtulhdhix am. ");
INSERT INTO stpNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Baꞌ gu Jesuus jup ja tɨtda: ―Dho na guꞌ dhiꞌ jaꞌpni na jax gu jaꞌtkam noꞌm jix kɨkɨɨꞌ, na guꞌ cham jum aaꞌndaꞌ na jaroiꞌ ja duduadhiꞌñdhaꞌ, guꞌ guiꞌ ji nam jix kakoꞌk kaꞌ na baꞌm aaꞌndaꞌ na jaroiꞌx bhaiꞌ ja dui ja duduaꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Baꞌ aañ puꞌñi ɨp na ñich bha jii yaꞌ dhi oiꞌñgaꞌn, cham tuꞌ pu kaiꞌñkam bha jii ñich nañ ja baidhikaꞌ guiꞌ nam puiꞌm aaꞌ nam panaas cham tuꞌ bhaan uꞌuaꞌtulhdhix, guꞌ guiꞌ ji nam soiꞌm ɨlhdhai machiaꞌ nam jix uaꞌtulhdhix nam baꞌ miꞌ dhɨr puiꞌ ba tɨɨdaꞌ gu Dios na ja uañdhaꞌ. Dhiꞌ jɨꞌ ji pu chuꞌm gu jaꞌtkam nañ ja baidhikaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Baꞌ jaꞌpnip tɨtda am gu Jesuus: ―Jax kum baꞌ cham jɨꞌx jum saabum jum ɨlhiiꞌñdhaꞌ dhim jaꞌtkam tuk. Gammɨjɨ ja nɨiꞌñdhaꞌ ich nabap tanoolh nam tu kuaꞌdaꞌ gam nam tu ichgɨdaꞌ gu tuꞌ nar jum ioꞌdam. Matgɨm guiꞌ nam pariseos jir ja jaꞌtkam tuk gio guiꞌ na Juan jaꞌtkam bopkondam jup jir jaꞌtkam tugiꞌñ, gammɨjɨ ji nam jum saabdaꞌ gio nam gammɨjɨ tu daandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Baꞌ gu Jesuus jup ja tɨtda: ―Dho na guꞌ dhiꞌ jaꞌpni na jax gu jaroiꞌ noꞌ miꞌ paiꞌm tɨtmo nam cham jɨꞌx jum saabum jum ɨlhiiꞌñdhaꞌ gu jaꞌtkam miꞌ jotmodaꞌ, nam guꞌx chu nak kaꞌ gu koiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gio na guꞌ cham tuꞌ gammɨjɨ mi oirɨt jum tɨtmot tu ja maakdaꞌ, daipuꞌ ji maaꞌnnim na bɨɨx maaꞌn jimdam miꞌ pu tu ja makiaꞌ, nam guꞌ ba baidhikaꞌ na xi chu ja maakai. Miꞌ dhɨr dho gi baꞌ guꞌ cham jax ka bua ji sia mɨt baꞌ bam saabu, na guꞌ bar cham tuꞌ kaꞌ. Puꞌñi ɨp baꞌ dhiñ jaꞌtkam tuk, cham jum saabum am gu xib, nam guꞌx bhaiꞌm taat nañ yaꞌ kap tuꞌiiꞌ ja bui. ");
INSERT INTO stpNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Baꞌ bhaan ji uaꞌrgidhak maaꞌn gu jannulh xi ja aagiꞌñ nam sap baꞌx maatɨt kaayaꞌ, jup ja tɨtda: ―¿Paa pim nɨiꞌñ gu maaꞌnkam nat taak ɨɨkɨk gu xibkam kutuunaꞌn mu jaꞌk daax bhaan gu kɨlhiꞌñgaꞌn kutuunaꞌn? Pu nip paiꞌ dho jia. Jax dhui na guꞌ cham abhaar kaꞌ noꞌ taak dɨr jir xibkam gio noꞌ taak dɨr jir kɨlhiiꞌñgaꞌn, tuꞌ kub pɨx baꞌ na xi chuiꞌdhaꞌ gu xibkam kutuunaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ni gu biiñ gux oꞌjoꞌ ku cham jaroiꞌ bhaan tuaꞌba gu kɨklhiꞌñgaꞌn jajooꞌ, pu xixiipñiaꞌ guꞌ noꞌt jax dhuuk bhaan tua, na guꞌ cham ka kaapak kaꞌ, tuꞌ kub baꞌ gu biiñ nam nuꞌaaꞌ gio gu jajooꞌ na ba xixiipñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Puiꞌ kum baꞌ xixiibkam jajooꞌ bhaan tu aidhaꞌ gu biiñ gux oꞌjoꞌ guiꞌ nam biiñ chaꞌm tu juan na baꞌ cham xixiipñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Gio guꞌ gu jaroiꞌ noꞌ pu gammɨjɨ ioꞌ gu biiñ gux oꞌjoꞌ, cham tuꞌ joidham dɨɨkdaꞌ gu kuugaꞌn noꞌ tɨip xi ioꞌ, na guꞌ cham puiꞌ mat kaꞌ. Jup kaiꞌchdhaꞌ guꞌ noꞌ jaroiꞌ tɨi xi maak: “Cham ji na iꞌoob dhi kuugaꞌn, gux oꞌjoꞌ ji nañ joidham dɨɨk.” ");
INSERT INTO stpNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Maaꞌnnim bhaan gu tanoolh chaꞌm nam paiꞌ dhuuk cham tu juandaꞌ dai gu Israel kam jaꞌtkam, maaꞌn kap ka jim gu Jesuus ja bɨɨm guiꞌ nam kaichuꞌ na paiꞌ tɨ ɨx gu tiriik. Guꞌ baꞌ dai guiꞌ nam kaichuꞌ xi uꞌiidhat am gu tiriik xi kaipgaidhat tu koꞌiim. ");
INSERT INTO stpNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Baꞌ jɨꞌk jup jiim am guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, bax bhaak am ja bui na mɨt ja tɨɨ, jup ja tɨtda am: ―¿Jax ku pim baꞌ gan tɨ ɨꞌkidhat tu kaipgaidhat tu koꞌiim dhi tiriik? ¿Kux cham maat japim aa na xib cham tum juan? ");
INSERT INTO stpNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Baꞌ gu Jesuus jup ja tɨtda: ―¿Kux aapiꞌm cham jɨꞌxkat tu jiñkaiꞌñ aa mi uꞌuan taꞌm na mɨt paiꞌ tu uaꞌnak gu bɨjɨk dɨr kam na bhaan tu aꞌga nat jax tu duu gu Dabii ja bɨɨm gu jaꞌtkam tugiꞌñ maaꞌnnim nam paiꞌ dhuuk ba uaꞌmaim? ");
INSERT INTO stpNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Na mɨt saak tu juu bo gu paan jix xidhuu kam guiꞌ na chiop tɨkiix kat. Tɨi daipuꞌx bhaaiꞌ nam kuaꞌdaꞌ guiꞌ nam ja aꞌmkam tu daandaꞌ buiñor gu Dios gu Israel kam jaꞌtkam, cham tuꞌ gu jaꞌppɨx jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Miꞌ dhɨr baꞌp ja tɨtda: ―Gio guꞌ aañ jir gɇꞌkam nañ bhaankam ya oirɨ gu Dios, jix maat iñ baꞌ na tuꞌx bhaaiꞌ nañ pu buadaꞌ gio na tuꞌ cham na paiꞌ dhuuk puꞌñi cham tum juandaꞌ. Puiꞌ kuñ baꞌ cham paiꞌ jax ja tɨtda dhiñ jaꞌtkam tuk sia kuñ ja nɨiꞌñ nam jax tu buim. ");
INSERT INTO stpNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Baꞌ nat giop jum ai gu tanoolh nam paiꞌ dhuuk cham tu juandaꞌ dai gu Israel kam jaꞌtkam, mu ba ai ɨp gio chiop gu Jesuus, miꞌ baꞌ bhaiꞌ ji chu ja aꞌgi gu jaꞌtkam gu ñioꞌkiꞌñ gu Dios. Baꞌ maaꞌn miꞌp jix jaiꞌch kaꞌ gu maaꞌnkam na kɨɨꞌn dɨr jix muuk kaꞌ gu nobiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios gio guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, pɨx am tɨ nɨɨra am noꞌt sap moo ba ji dhuaꞌñ gu Jesuus sia ku tɨi cham tum juan. Sap baꞌ noꞌt duaꞌñ, dai nam ba iattulhdhaꞌ ja bui gu ja gɇꞌgɇrkam tuk. ");
INSERT INTO stpNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Guꞌ ji na guꞌx bhaiꞌx maat gu Jesuus nam jax jum aaꞌ, baꞌp tɨtda guiꞌ nax muuk kaꞌ gu nobiiꞌñ: ―Aapiꞌñ jaduuñ nax muuk gum nob, bhaiꞌ xi jim, yaꞌnip jaꞌp xi kɨkboꞌ bɨɨpɨꞌ dɨr. Baꞌ guiꞌ nat jax jup kɨkbo, mu jimɨɨk miꞌp ba kɨɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Miꞌ dhɨr baꞌp ja tɨtda gu Jesuus dai guiꞌ nam miꞌx maiꞌchim: ―Jiñ aagiꞌñdhaꞌ pim nañ maaꞌn ñiꞌook jam tɨkkaꞌ. ¿Tuꞌ daix bhaaiꞌ nañ jax buadaꞌ na paiꞌ dhuuk puꞌñi cham tum juandaꞌ? ¿Nañ jix bhaiꞌ tu buadaꞌ aa, kaꞌ nañ jix buam tu buadaꞌ aa? ¿Gu jaroiꞌ aañ xi ñɨiꞌñdhaꞌ pɨx sia ku jax jix ioꞌm jix kaꞌook, piam ku mi jaꞌp ba mumkɨñ chaagiob? ¿Cham aa nañ jix bhaiꞌ dui duaꞌñdhaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Cham ñiok am guiꞌ. Baꞌ bɨɨx naiꞌ xi ja tɨɨgɨk gu Jesuus nam jɨꞌk miꞌp tuꞌiiꞌ na baꞌ miꞌ dhɨr jup tɨtda guiꞌ nax muuk kaꞌ gu nobiiꞌñ: ―Eap xi sɨlhiiñ dhim nob. Baꞌ guiꞌ xi sɨlh ɨp, jix kɨɨꞌp jum duu, panaas ku pu cham paiꞌ muuk kat. ");
INSERT INTO stpNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Baꞌ bhaiꞌ ji bhaak jamɨt guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios gio guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ. Tɨi ma tu aꞌga mɨt na jax jaꞌk jix bhaaiꞌ nam doodaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Baꞌ miꞌ dhɨr jɨꞌk jurniꞌñ kɨꞌn maaꞌn kap jup jii oidhaꞌ daam gu Jesuus nat tu daañim buiñor gu Dios jix dhaam jaꞌk. Bɨx chukaaꞌ tu daanɨ, bhaiꞌ pu xiꞌaaꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Baꞌ nat paiꞌ ton, maap xi ja jumpadak bɨɨx guiꞌ nam kaichuꞌ pɨx ji ja aa guiꞌ nam jɨꞌk jir noonbiꞌñ kaꞌ, mambhɨɨx daman gook ja aich. ");
INSERT INTO stpNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Gu Simoon maadɨt jir diꞌ nat aa nar nobiiꞌñ kaꞌ, guiꞌ na gook kɨꞌn jix mat kaꞌ gu Jesuus, Simoon Peegro tɨɨtɨꞌndaꞌ. Miꞌ dhɨr baꞌ gu Anrees jup aa, guiꞌ nam jir jum jajaaꞌnnim gu Simoon Peegro. Miꞌ dhɨr baꞌ gu Jakoobo. Miꞌ dhɨr gu Juan. Miꞌ dhɨr gu Piliip. Miꞌ dhɨr gu Bartolomee. ");
INSERT INTO stpNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Miꞌ dhɨr gu Mateo. Miꞌ dhɨr gu Tomaas. Miꞌ dhɨr gu jumai Jakoobo, maraaꞌn gu Alpeo. Miꞌ dhɨr gu jumai Simoon ɨp, guiꞌ na ja kaichgɨdaꞌ guiꞌ nam kananiistas jum tɨɨtɨꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Miꞌ dhɨr gu Juudas, maraaꞌn gu Jakoobo. Miꞌ dhɨr gu Juudas Iskariote, guiꞌ nat gatuuk iattulh gu Jesuus nat ja aaꞌñ gu gɇꞌgɇrkam na paiꞌ oirɨ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Baꞌ bhaiꞌ dhɨr ja bɨɨm giop ba jii gu Jesuus oidhaꞌ daam guiꞌ nat noonbiꞌñ kɨꞌn xi ja darsak gio gu jaiꞌ nam jaꞌp pɨx kaichuꞌ. Gama jaꞌk baꞌ ji ai bɨtaaꞌn maaꞌn kap na paiꞌx gioꞌ, nam guꞌ miꞌp daraa gu jaiꞌ jaꞌtkam nam puiꞌp kaichuꞌ, gam jaiꞌ kap dɨr na jɨꞌx jir Judea nam miꞌp tuꞌiiꞌ muiꞌ gu jaꞌtkam, puiꞌ na jax gu Jerusaleen kam, gio mu dɨr jaꞌk kam juꞌñdharam gu gɇꞌ suudaiꞌ na paiꞌ Tiiro tɨ tɨɨꞌ, gio jaiꞌ gama jaꞌk kam iam na paiꞌ Sidoon jup tɨ tɨɨꞌ na puiꞌp jir juꞌñdharam gu gɇꞌ suudaiꞌ. Pu kaiꞌñkam pɨx mi ai mɨt nam jix kaim gu Jesuus na tu aꞌga, gam jaiꞌ nam jix aaꞌ na ja duduaꞌñdhaꞌ nam jix kakoꞌktuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Baꞌ gu jaꞌtkam guiꞌ nam ampɨx jix ñanaanbiꞌchuꞌndaꞌ na ja aꞌm jup tuiꞌñgɨdaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ, pu bɨɨx ja duduaꞌñdhidhaꞌ gu Jesuus, pu maiꞌ ja jootsaidhaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Baꞌ nam nɨiꞌñdhaꞌ gux kakoꞌkkam na pɨx ji ja duduaꞌñdhidhaꞌ gu Jesuus gu jaiꞌx kakoꞌkkam, pɨx jum tutkiꞌñdhaꞌ am nam bhax dhaagik kaꞌ, na guꞌ sia kut jaroiꞌ bhaiꞌ pɨx xi dhaa, pu maaꞌn jimdam dodhiaꞌ, na guꞌ jax ña pɨx jaꞌk jix bhaaiꞌ na pu dui duaꞌñdhaꞌ gu jaroiꞌ gu Jesuus, na guꞌr gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Baꞌp ja tɨtda gu Jesuus muiꞌ xi ja tɨɨgɨk dai guiꞌ nam jɨꞌk kaichuꞌ: ―Aapiꞌm na pim cham tuꞌ biaꞌ ni jɨꞌx, joidham jix bhaiꞌ tu jam jim, na guꞌ puꞌñi chuꞌm gu jaꞌtkam nax ja joiꞌmdat jam aꞌm tɨ nɨidhidhaꞌ gu Dios, sia ku jax jix ioꞌm jir gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Chaꞌpim jax jum aaꞌndaꞌ sia ku pim panaas xib uaꞌmaim, na guꞌ bam aajim na pim paiꞌ dhuuk kokbadaꞌ. ’Joidham jix bhaiꞌ tu jam jimiaꞌ gatuuk sia ku pim guꞌ xib suan, na pim guꞌ gatuuk joidham jix bhaiꞌm taatɨt ba jɨɨmdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Joidham jix bhaiꞌ tu jam jimiaꞌ sia noꞌm gu jaꞌtkam xi jam bhaamkiꞌñ, sia mɨt chi miꞌ paiꞌ dhɨr ji jam joot jax chuꞌm chiop piam jax chuꞌm kiicham, piam kum jaꞌp pɨx jix bhaamut jam nɨiꞌñ sia gu mɨk dɨr pu kaiꞌñkam pɨx na pim jiñ bui tɨ jɨɨgiꞌñ aañ nañ bhaankam ya oirɨ gu Dios dhi oiꞌñgaꞌn bhaan. ");
INSERT INTO stpNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aapiꞌm jix bhaiꞌ pɨx jum taat kaꞌ noꞌm puiꞌ jam bua, na guꞌ noꞌ pimɨt nakoo, gɇꞌp jum duukam tu maiꞌchiaꞌ pim jix dhaam. Nam guꞌ puꞌñip ja buimɨk gu bɨjɨk dɨr kam jich bopxi kat nam bhaankam tu aꞌgimɨk gu Dios, dhiꞌ pu chuꞌm gu jaꞌtkam jam puꞌñip ja tulhiiñchudimɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Baꞌ aapiꞌm na pim xib giilhim jir jix chutumñigam, cham bhaiꞌ tu jam jimiaꞌ gatuuk, na pim guꞌ pu yaꞌx bhaiꞌ bam taat kɨꞌn gu tuumiñ na pim ji biaꞌkat. ");
INSERT INTO stpNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Cham bhaiꞌ tu jam jimiaꞌ na pim dai aapiꞌm jix kokbaꞌn, gatuuk uaꞌmaꞌ pim guꞌ. ’Gam na pim jix bhaiꞌm taatɨt jɨɨm xib, cham bhaiꞌ tu jam jimiaꞌ sia, gatuuk jix buam jum aagɨt ba suandaꞌ pim. ");
INSERT INTO stpNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Sia cham bhaiꞌ tu jam jimiaꞌ na pim jix bhaiꞌm taatɨt pɨx gɇꞌgɇrkam jum taat kaꞌ noꞌm tuꞌ kaꞌm jam ɨlhdhat pɨx jix bhaiꞌ kaiꞌch jam bui muiꞌ gu jaꞌtkam. Puꞌñip ja buimɨk am guꞌ bɨjɨk gu jaꞌtkam guiꞌ nam sap pɨk baꞌ bhaankam tu aꞌgadaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Ku guꞌ aañ yaꞌ pu jam tɨtda ji aapiꞌm na pim jɨꞌk yaꞌp tuꞌiiꞌ na pim jiñ kɇɇ, na pim jix bhaiꞌ ja tɨtdat guiꞌ nam xi jam bhaamkiꞌñdhaꞌ, siam chi dɨɨlh tɨi mu dɨr bha jaꞌk xi jam bhaamkiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xi chu ja daañxidhat japim buiñor gu Dios na baꞌx bhaiꞌ tu ja jimdaꞌ, sia kum tɨix bhaakut jam aꞌga piam kum guꞌ maaxik giilhim jam tɨtda miꞌ paiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Noꞌt jaroiꞌ bhaiꞌ mam gɨɨꞌm kaam am, jaꞌp dɨr jap mu jaꞌk jup xi dhaaꞌñdhaꞌ gu jumaim kaam na bham gɨɨꞌbiaꞌ. Piam noꞌt guꞌ jaroiꞌ mam ɨɨxdhak gux kabook jum kutuun nap daam dɨr tɨiꞌchgɨdaꞌ, bɨɨx gux komaalhik jum kutuun nap tuukab tɨiꞌchgɨdaꞌp jotmodaꞌ kuanai mu makiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Chaꞌp taandaꞌ gu jaroiꞌ noꞌt tuꞌm ɨɨxdhak. Gio gu jaroiꞌ noꞌ tuꞌ bam taan, chaꞌp jax ji chɨꞌji makiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Puiꞌ pim jaꞌk jix bhaiꞌ ja buadaꞌ bɨɨx pɨx gu jaꞌtkam na pim jax jaꞌk jix aaꞌndaꞌ aapiꞌm dɨɨlh nam gɨt jix bhaiꞌ jam buadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Na guꞌ noꞌ pim aapiꞌm dai guiꞌx ja joiꞌgɨꞌn nam jaroiꞌ xi jam joiꞌgɨꞌndaꞌ aapiꞌm, ¿jax baꞌ duip jix maatɨꞌ kaꞌ na pim aapiꞌm sɨlhkam tuꞌ kaꞌm nɨiꞌñ gu Dios? Na guꞌ sia guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñ nam puiꞌ jaꞌk tu jim. ");
INSERT INTO stpNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Gio noꞌ pim dai guiꞌx bhaiꞌ ja bua nam jaroiꞌx bhaiꞌ jam buadaꞌ aapiꞌm, sia cham maatɨꞌ kaꞌ na pim aapiꞌm sɨlhkam tuꞌ kaꞌm nɨiꞌñ gu Dios, na guꞌ sia guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñ nam puiꞌ jaꞌk tu jim. ");
INSERT INTO stpNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sia cham maatɨꞌ kaꞌ na pim aapiꞌm sɨlhkam tuꞌ kaꞌm nɨiꞌñ gu Dios noꞌ pim dai guiꞌ ja taiñbuiꞌñ gu tuꞌ nam jaroiꞌ jam taiñbuiꞌñdhaꞌ ɨp aapiꞌm gu tuꞌ, na guꞌ sia guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñ nam puiꞌ jaꞌk tu jim. ");
INSERT INTO stpNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bɨɨx pɨx ji na pim jix ja joiꞌgɨꞌndaꞌ gu jaꞌtkam, jix bhaiꞌ pim ja buadaꞌ sia guiꞌ nam xi jam bhaamkiꞌñdhaꞌ. Ja taiñbuiꞌñdhaꞌ pim gu tuꞌ nam jum taiñbuiꞌñdhaꞌ, chaꞌpim nɨɨrat mu dɨr bha jaꞌk nam puiꞌp duñiaꞌ. Puꞌñi jaꞌk dho gi guꞌ puiꞌ bam kaiꞌchdhaꞌ ji na pim jir maamraꞌn gu Dios guiꞌ nax dhaam jup tuꞌiiꞌ, na siax ja joiꞌgɨꞌn guiꞌ nam cham buiñor tɨtɨɨꞌñcho gam guiꞌ nam cham tuꞌ kaꞌm tɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Puꞌñi pim bɨɨx pɨx jix ja joiꞌgɨꞌndaꞌ gu jaꞌtkam jaꞌp na jax gu Dios na bɨɨx pɨx jix ja joiꞌgɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Chaꞌpim jaꞌk buppiꞌñdhaꞌ gu jaroiꞌ sia kut tuꞌx buam jam duiñ, tu uañiꞌñkaꞌ pim pɨx, na guꞌ cham jɨꞌxkat tu jam uañdhaꞌ gu Dios noꞌ pim aapiꞌm cham tu ja uañiꞌñ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gu jaroiꞌ noꞌ tuꞌ ba jam taan, xi iichulhdhaꞌ pim cham jax ji chɨꞌji na baꞌ gu Dios puiꞌp jam maakidhaꞌ gu tuꞌ nam aaꞌndaꞌ. Jaꞌxbuiꞌp jam iichulhdhaꞌ gu Dios na pim jɨꞌx iichulhdhaꞌ gu jaroiꞌ, dai na joidham xiixkixim jix kabkam jimdam gio jupaaban. ");
INSERT INTO stpNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Baꞌ gu Jesuus bɨɨx aixim bhaan ji chu uaꞌrgidhak gu tuꞌ na yaꞌ dhi oiꞌñgaꞌn jax jum buadaꞌ ba ja aagiꞌñ, jup ja tɨtda: ―¿Paa pim nɨiꞌñ gu maaꞌnkam cham ñia kam na baiꞌñchuꞌ gu jumai na puiꞌ cham jup ñia kaꞌ? Jia na pu cham paiꞌ. Jax dhui nam guꞌ bɨɨx gook miꞌ paiꞌ pu suulhgiaꞌ jax chuꞌm tɨ dɨꞌn kɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Gio jaꞌpni ɨp, gu jaroiꞌ noꞌ tuꞌ bhaan tum mamtuxiꞌñ, jaꞌxbuiꞌ pɨx juugɨt tu machiaꞌ na jɨꞌx jix chu mat kaꞌ gu jaroiꞌ na tu mamtuxdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Giox ñɨiꞌñdhaꞌ pim noꞌt palhɨɨp buupuiram gɨi gu tanaaraꞌ gu jax chuꞌm jam jaduuñ, aapiꞌm dɨɨlh pu cham nɨiꞌñ na gɇꞌgɇr iam bha bɨɨt jam buupui am. ");
INSERT INTO stpNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Noꞌ pim guꞌ aapiꞌm cham nɨiꞌñ na gɇꞌgɇr iam bha bɨɨt gu tanaaraꞌ dɨɨlh jam buupui am, cham jir am na pim jax tɨtdadaꞌ gu jam jaduuñ: “Bha jaꞌk jiñ jaduuñ kuñ xim baabuidhaꞌ dhi tanaaraꞌ na bha kaat jum buupui am.” Bɨɨpɨꞌ pim dɨɨlh xi boosgai gu dɨɨlh jam tanaaraꞌ jam buupui am dɨr na pim baꞌp ba baabuidhaꞌ gu jam jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Cham jax chuꞌm jaiꞌch gu ɨꞌɨɨx guiꞌ nam jix maikak iꞌbhaiꞌñchardat bhɇbhɇɇ na miꞌ dhɨr jix maimdagɨm iibhaiꞌñchaip ba bhaayaꞌ, ni guiꞌ na pux maimdagɨm iꞌbhaiꞌñchardat bhɇbhɇɇ ku miꞌ dhɨr jix maikak iibhaiꞌñchaip ba bhaayaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bɨɨx pɨx jix maatɨꞌ guꞌ gu ɨꞌɨɨx nam jax jir tuꞌm, puiꞌ na gu iigɨx na guꞌ cham uupar taꞌm jup jum bua, ni gu uubas ku cham kokmaꞌ uꞌuux chaꞌm nangiaꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jaꞌpniñ dho kaiꞌñkam jup kaiꞌch, gu maaꞌnkam noꞌr jix kɨɨꞌ, joidham jix bhaiꞌ tu ñiokdaꞌ, na guꞌ puiꞌ jaꞌk juraꞌram dɨr buusnidhaꞌ. Guꞌ baꞌ gu maaꞌnkam noꞌ cham jir kɨɨꞌ, giilhim jix buam tu ñiokdaꞌ, na guꞌ puiꞌ jaꞌk juraꞌram dɨr buusnidhaꞌ ɨp. Na guꞌ gu jaroiꞌ na jax jaꞌk jum aaꞌndaꞌ juraꞌram bhaan, puiꞌ jaꞌk chiñiꞌram dɨr buusnidhaꞌ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Jax ku pimɨt baꞌ cham miꞌ puiꞌ ba ji jii nañ jax jam aagiꞌñ na pim tuiꞌñgɨdaꞌ? Aapiꞌm dai puiꞌ xi kaiꞌchɨt nañ aañ jir gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kani nañ bhaan uaꞌrgidhai gook gu jaꞌtkam jam aaꞌñdhaꞌ na pim baꞌx maatɨt jiñ kaayaꞌ na jax jaꞌk ji buusan gu jaroiꞌ noꞌt miꞌ puiꞌ jii gio gu jaroiꞌ na cham. ");
INSERT INTO stpNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Guiꞌ na miꞌ puiꞌ jimiaꞌ nañ jax tu aꞌga, jaꞌp ji buusniaꞌ na aiꞌ chaꞌm tɨ dɨꞌngarsai mi kɨɨsaꞌ gu baꞌkiꞌñ. Baꞌ cham jax jum duñiaꞌ sia kut giilhim jix ioꞌm bhaiꞌ ji dhuuꞌn jɨbɨɨlh kɨꞌn, siat chi tɇꞌkob xi juu gu suudaiꞌ. Ni ku cham palhɨɨp iam xi joiñdhaꞌ, na guꞌx bhaiꞌ mi kɨɨkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Guꞌ baꞌ gu jaroiꞌ noꞌt cham miꞌ puiꞌ jii nañ jax tu aꞌga, dhiꞌ jaꞌp jup ji buusniaꞌ na tɨi tu baꞌkchaꞌ ɨp, dai na puiꞌ mi jaꞌp oꞌyatam gio puiꞌ kɨiꞌchdhixim. Baꞌ na paiꞌ dhuuk jix ioꞌm bhaiꞌ ji dhuuduꞌ jɨbɨɨlh kɨꞌn, pu maaꞌn jimdam nammɨ jaꞌp xi iabuꞌ gu uꞌuux, pu biꞌññikaꞌ baꞌ gu suudaiꞌ na paiꞌ dhuuk muiꞌ ji dhaiꞌññiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Baꞌ miꞌ dhɨr pu jii gu Jesuus mu jaꞌk Kapernaum nat paiꞌ tɨɨmok nat xi chu ja aꞌgidhimɨk gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Baꞌ miꞌ Kapernaum maaꞌn jix jaiꞌch kaꞌ gu gɇꞌkam sandaaruiꞌx Rooma kam, giilhim jix ioꞌm ma tu ai gu tujuandam tugiꞌñ guiꞌ nax dhaꞌdaꞌ, dakoo pɨx ba duatuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Baꞌ puiꞌ ba tɨ kai gu gɇꞌkam sandaaruiꞌx na miꞌ paiꞌ amuub oirɨ gu Jesuus na tu duduadhiꞌñ, baꞌ mɨjɨ xi ja joot jɨꞌkchi gu Israel kam jaꞌtkam guiꞌ nam jix mamatdaꞌ gu ñioꞌkiꞌñ gu Dios nam sap soiꞌ tɨɨdai mu baidhikaꞌ na duaꞌñdhaꞌ gu tujuandam tugiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mummɨ baꞌp ba ji bubua mɨt na paiꞌ oirɨ gu Jesuus, baꞌ soiꞌm duuk jup tɨtda am: ―Iam jap duaꞌñdharaꞌ gu tujuandam tugiꞌñ gu gɇꞌkam sandaaruiꞌx nax kaꞌook, soiꞌch jum tɨtda nap palhbuidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Na guꞌ dhiꞌ dhi sandaaruiꞌx jix ja joiꞌgɨꞌn gu jaꞌtkam nam ya jaꞌp tu oiꞌdhaꞌ, puiꞌ na jax gu chiop miꞌ nach paiꞌch jumpadat daan guch Gɨꞌkoraꞌ, dhiꞌ nat jich chiañxi nam jich kɨɨxdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Baꞌ ma ja oi gu Jesuus nat ba duaꞌñdham gux koꞌkkam. Baꞌ nat ba maat gu gɇꞌkam sandaaruiꞌx nam amuub ba jiim, guiꞌ nam maap jix bhaiꞌ kaiꞌchdhaꞌ mɨjɨp xi ja joot nam bhaankam jup tɨɨdaꞌ gu Jesuus: ―Amuub pɨx kiaꞌñ jaduuñ, nañ gu cham jir jum jupaabkam nap gɨt iam yɨjɨ bakiaꞌñ baꞌgɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Puiꞌ ku ñich baꞌ cham jiñ guguux nañ dɨɨlh jum gaaꞌmɨrai soiꞌm tɨɨdaꞌ nap duaꞌñdhaꞌ guñ chujuandam tuk. Miꞌ dhɨr jap pɨx puiꞌ xi chɨꞌyaꞌ na ba dodhiaꞌ guñ chujuandam tuk. ");
INSERT INTO stpNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nañ guꞌ aañ cham tuꞌ gɇꞌkam jiñ chaat, jix maat iñ guꞌ nañ bɨtaaꞌn jup tuꞌiiꞌ ja bui guñ gɇꞌgɇrkam tuk, daipuꞌ pɨx jañ baꞌ puiꞌ tu duñiim nam jax jiñ chɨɨdaim. Gio aañ dɨɨlh yaꞌ dɨr jaꞌp jaꞌk jañ jaꞌxbuiꞌ pɨx kɨꞌn jup tu ja chian guñ sandaaruiꞌx chuk nañ jɨꞌx pɨx kɨꞌn gɇꞌkam daa, xiñ kɇɇkɇꞌ am ɨp baꞌ. Jimiaꞌ gu jaroiꞌ maadɨt noꞌñ paiꞌ jootos, piam noꞌñ jaroiꞌ maadɨt mu paiꞌ dhɨr baiꞌñ, mu jimiaꞌ ɨp. Sia guñ chujuandam tuk noꞌñ tuꞌ chian, miꞌ puiꞌ duñiaꞌ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Baꞌ gampaiꞌ ji dhuu gu Jesuus nam puiꞌ ba tɨtda guiꞌ nam maap jix bhaiꞌ kaiꞌchdhaꞌ gu gɇꞌkam sandaaruiꞌx, na guꞌ sap cham paiꞌ jaroiꞌ jumai jaꞌxbuiꞌ puiꞌp jix biiñak na jax dhiꞌ. Baꞌ muiꞌ xi ja tɨɨgɨk gu jaꞌtkam nam oiꞌñchuꞌ jup ja tɨtda: ―Cham jaroiꞌ iam maadɨt gu Israel kam jaꞌxbuiꞌ puiꞌx biiñak buiñor gu Dios na jax dhi sandaaruiꞌx, sia ku guꞌ tɨir Rooma kam, aañ moo yaꞌ pu jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Baꞌ miꞌ dhɨr jaꞌk ba gɨi ɨp gio gu Jesuus. Dai guiꞌ nam maap jix bhaiꞌ kaiꞌchdhaꞌ gu gɇꞌkam sandaaruiꞌx jamɨt mu ba ai ɨp gio, baꞌ ba tɨɨ mɨt nax kɨɨꞌ mi oirɨ gu tujuandam tugiꞌñ na kax kaꞌook kat. ");
INSERT INTO stpNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Baꞌ miꞌ dhɨr mu jaꞌk pu bhɨi gu Jesuus maaꞌn kap na paiꞌ Naiin tɨ tɨɨꞌ, bɨɨx jiim am sia guiꞌ nam kaichuꞌ gio jaiꞌ muiꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nammɨ nam amuub ba aajim na paiꞌr kikcham, gu Jesuus ba tɨɨ maaꞌn gu mukdhaꞌ nam mi jaꞌp ba uaꞌ bakxidhar taꞌm na mɨt ba yaaspam. Daipuꞌ maaꞌn tu mar kat maaꞌn gu dɨlhdhɨm ubii nat muu gu bɨngaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Baꞌx joiꞌmdat tɨɨ gu Jesuus gu ubii nax buam jum aaꞌntugɨt suakim, jup tɨtda muiꞌ xi ɇɇk miaꞌn: ―Chaꞌp ka suakdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Miꞌ dhɨr baꞌ mu jaꞌk xi ɇɇk jup xi dhaa gu bakxidharuꞌn gu maraaꞌn nam bhaan uaꞌ nam baꞌ guꞌkuyaꞌ guiꞌ nam mu uaꞌ. Baꞌ guiꞌ xi guguu mɨt ɨp. Baꞌp tɨtda gu mukxikam: ―Alhii biapmaꞌ, aapiꞌ nap muukix, xi bamiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Baꞌ bhaiꞌ sɨlh ji dhaibu gu alhii biapmaꞌ, ba tu aꞌga mi dhaakat. Baꞌ gu Jesuus xi aagiꞌñ gu dɨꞌɨɨꞌn na mi jaꞌp kɨɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Baꞌx chootoꞌn jamɨt bɨɨx gu jaꞌtkam nam jɨꞌk miꞌp tuꞌiiꞌ nam tɨ nɨiꞌñ, xi gɇꞌkamtuꞌn am gu Dios jup ji kaiꞌchɨt: ―Dhiꞌ bak bhaankam ya oirɨ gu Dios, gɇꞌkam kɨꞌn bhaan tɨ nɨidhim baꞌ. Tɨɨꞌ na jax bɨxchuꞌx bhaaiꞌ na pu tu duñiaꞌ. Gio baꞌ jaꞌpnip kaiꞌch am: ―Yaꞌ ba ai gu Dios nat bha ja palhbuidham gu jaꞌtkam tugiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Baꞌ bɨɨx gu jaꞌtkam nam jɨꞌk Judea dɨbɨɨr bhaan oiꞌdhaꞌ puiꞌ tɨ kai mɨt nat joidham tu duu gu Jesuus, sia mɨt puiꞌ tɨ kai guiꞌ nam jix ioꞌm gama jaꞌk jaꞌp oiꞌdhaꞌ na paiꞌ cham Judea bhaan bipioꞌ gu dɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Baꞌ gu Juan jaꞌtkam bopkondam puiꞌ ba tɨ kai ɨp nat mu paiꞌ joidham tu duu gu Jesuus, nam guꞌ ba aagiꞌñ guiꞌ nam kaiꞌchuꞌ dɨɨlh gu Juan. Baꞌ gook xi ja baidhak ");
INSERT INTO stpNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","jup ja tɨtda nam mu jimiaꞌ na paiꞌ oirɨ gu Jesuus nam tɨkkapuꞌ noꞌ sap sɨlhkam jir diꞌ guiꞌ na saak bha jootsaꞌ gu Dios jix dhaam dɨr, piam ku guꞌ cham sap nam baꞌ nɨɨradaꞌ guiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Baꞌ mɨjɨp ji dhuu mɨt, mummɨ mɨt ba ji bubua na paiꞌ oirɨ gu Jesuus, baꞌp tɨtda am: ―Aach bhach joot gu Juan jaꞌtkam bopkondam nach jum tɨkkaꞌ noꞌp sap sɨlhkam aap jir diꞌ guiꞌ na puiꞌ saak bha jimdaꞌx dhaam dɨr, piam ku guꞌ cham sap kuch nɨɨradaꞌ guiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Baꞌ cham jax ja tɨtda miꞌ jotmodaꞌ gu Jesuus, dai na xi ja duduaꞌñdhim pɨx gu jaꞌtkam na ka ja ɇɇkaꞌ bɨɨx aixim tuꞌm gu koꞌkdaiꞌ, sia guiꞌ nam ampɨx puiꞌ kax ñanaanbiꞌ kaꞌ na ja aꞌm jup tuiꞌñgɨdaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ. Muiꞌ miꞌ tu ja tɨɨꞌñchoda ɨp gu cham ñiññia kam. ");
INSERT INTO stpNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Baꞌ nat paiꞌ bɨɨx xi ja duduaꞌñdhak, jup ja tɨtda guiꞌ nat Juan mu ja joot: ―Ba jimiaꞌ pim ɨp gio bhammɨ na paiꞌ gu Juan, aagiꞌñdhaꞌ pim na pimɨt jiñ chɨɨ na ñich ja duduaꞌñ gu jaꞌtkam nam jix kakoꞌk kat, bɨɨx japim xi aagiꞌñdhaꞌ na pim jɨꞌk jax tɇ kɇɇ na ñich chu duu jaiꞌ kap. Jaꞌp japim tɨɨdaꞌ na mɨt dudua gu cham ñiññia kam, gio guiꞌ na tootolhidhat gakiidhaꞌ gu ja tutkuꞌ, gio guiꞌ nam kax mamaꞌmkulhiꞌ kat, gio guiꞌ nam cham tɇ kɇɇkɇt. Gio jaiꞌ guiꞌ nam tɨi ba koꞌiix kat jañich ja duduaꞌñdhak jup ja baapmiꞌ. Gio guiꞌ nam cham tuꞌ biaꞌ ni jɨꞌx nañ tu ja aꞌgiꞌñ gux bhaiꞌm kaiꞌchdham ñiꞌook na bhaan tu aꞌga nam jax jaꞌk cham kam tulhiiñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jaꞌp moox bhaiꞌ ba tu jimdaꞌ gu jaroiꞌ noꞌ pu gammɨjɨ tɨ jɨɨꞌñdhat bhaan ba tu daaꞌñchuꞌ na dai aañ jix bhaaiꞌ nañ palhbuidhaꞌ sia tuꞌ na pɨx bhaan. ");
INSERT INTO stpNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Baꞌ daipuꞌ nat xi ja tɨɨꞌn gu Jesuus, pu jii mɨt guiꞌ nat Juan mu ja joot. Miꞌ dhɨr baꞌp ja tɨtda gu Jesuus gu jaꞌtkam bhaan ji chu aꞌgat gu Juan jaꞌtkam bopkondam: ―Janoꞌ na pimɨt mu jii mummɨ gampɨx jix chu gak kɨr, ¿tuꞌ pimɨt mu tɨɨgim? ¿Junboꞌ aa miꞌ joidham jum bua na bhaiꞌ xi jɨbɨɨr? ");
INSERT INTO stpNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Kaꞌ maaꞌnkam aa mi oirɨ ji chɨm tɨiꞌdhat gu jajannulh jix aꞌbhar nax dhaꞌram namɨɨk? Moo chi cham. Jax dhui na pim guꞌx maat nam mummɨ jaꞌp jix joiꞌñ nam paiꞌ darkaꞌ gux ioꞌm gɇꞌgɇrkam jum aaꞌndam guiꞌ nam pu chuꞌm tɨm tɨꞌiiꞌñkaꞌ nam sap baꞌ joidham xi chuiꞌkaꞌ nam xi ja nɨiꞌñdhaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Jaroo ji pimɨt baꞌ mu tɨɨgim na pimɨt baꞌ mu jii? ¿Kaꞌ maadɨt aa mi oirɨ guiꞌ na bhaankam tu aꞌga gu Dios? Dhiꞌ jɨꞌ ji na pimɨt mu tɨɨgim na pimɨt baꞌ mu jii, cham tuꞌ gu tuꞌ na miꞌ joidham jum bua. Dhiꞌ gɇꞌkam kɨꞌn bhaan tɨ tɨɨ gu Dios, cham tuꞌ puiꞌ na jax gu bɨjɨk dɨr kam nam puiꞌ bhaankam jup tu aꞌgimɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gu Juan jaꞌtkam bopkondam aagɨt jup kaiꞌch iñ. Pu dhiꞌ aagɨt jup kaiꞌch gu Dios miꞌ paiꞌ na tu uaꞌñix gu ñioꞌkiꞌñ nap jum kaiꞌch: “Maaꞌn jañ bɨɨpɨꞌ mu jootsaꞌ na baꞌ ampɨk ba ja mattudaꞌ gu jaꞌtkam nap jootom muiꞌ ba jim.” ");
INSERT INTO stpNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Baꞌ aañ jix ioꞌm gɇꞌkam biaꞌ dhi Juan jaꞌtkam bopkondam, cham tuꞌ jaꞌxbuiꞌ na jɨꞌx gu jaiꞌ jaꞌtkam. Ku baꞌ guꞌ buiñor gu Dios jix ioꞌm jir gɇꞌkam kaꞌ ji guiꞌ nar cham tuꞌ kaꞌ, dai pɨx noꞌ soiꞌm ɨlhdhat miꞌ puiꞌ jim na jax jix aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Na guꞌ guiꞌ na mɨt jɨꞌk chia janoꞌ gu Juan na ja bopkonaꞌ, soiꞌm ɨlhdhak jamɨt chia bɨɨx, sia guiꞌ nam jir tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam, na mɨt guꞌ ba maat nar miꞌ puiꞌ kaꞌ jax noꞌt ba tɨi gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Dai baꞌ guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, cham kɨɨgalh jamɨt gu Juan, nam guꞌ cham tɨ jɨɨgiꞌñdhaꞌ na tɨi ja aagiꞌñdhaꞌ na jax jaꞌk jix joiꞌmdat ja aꞌm ba tɨ nɨidhidhaꞌ gu Dios, pu cham chia mɨt baꞌ na ja bopkonaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","’¿Tuꞌñ gɨt bhaan ji uaꞌrgidhai jam aaꞌñdhaꞌ nam jax jaꞌk ji buan gu jaꞌtkam guiꞌ nam xib jix jaiꞌch? ");
INSERT INTO stpNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jaꞌpnim dho ji buan na jax gu aꞌaalh noꞌ mɨt muiꞌ maap jim daagɨk ma tɨtbim miꞌ paiꞌ giotɨr. Baꞌ jaiꞌ bha jaꞌp ji daraibui ma tu saasbiaꞌ am titrimiax kɨꞌn, baꞌp ja tɨɨdaꞌ am gu jaiꞌ ja bɨpnaꞌ aꞌaalh xi saasbichui: “Ni jɨꞌx ku pimɨt iam tɨ nɨi na chich ba tu saas, ni ku pimɨt susuanɨ na tɨi joiꞌmdam jum kaiꞌchɨt guch xaasab.” ");
INSERT INTO stpNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Puꞌñi jaꞌk ji buan am gu jaꞌtkam guiꞌ nam xib jix jaiꞌch, nam guꞌ jax ñam pɨx aichuxdhidhaꞌ sia jaroiꞌ. Tɨɨꞌ gu Juan jaꞌtkam bopkondam puiꞌ aichux jamɨt na jaꞌook bhaan jup tuiꞌdhiꞌ, sia ku tɨi cham jɨꞌxkat gɇꞌ tu kuaꞌ ni ku cham jɨꞌxkat ioꞌ gu jax chuꞌm biiñ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Baꞌ aañ na ñich yaꞌp ai, puiꞌp jiñ aichux jamɨt nañ gɇꞌ tu kuaꞌ gio nañ gɇꞌ ioꞌ gu biiñ. Gam sap jir ja bɨɨm tuꞌm iñ gu tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam gio gu jaiꞌ jaꞌtkam nam cham tuꞌ kaꞌm tɨ nɨiꞌñ, nañ guꞌ sap ja bɨɨm oirɨdaꞌ, gio nañ ja bɨɨm tu kuaꞌdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ku guꞌ dhiꞌ matgilhiaꞌ ji gatuuk na jax kaiꞌñkam puiꞌ jaꞌk bua gu Dios, na guꞌ dhiꞌ nam jax pɨx tɨ nɨidhim nam pu kaiꞌchim, cham tuꞌ nam iam xim gaꞌnga noꞌx bhaiꞌ ji chu buusniaꞌ gatuuk piam ku guꞌ cham. ");
INSERT INTO stpNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Baꞌ gu Jesuus ma tu koꞌiim buiñor maaꞌn gu pariseo Simoon tɨɨgim, nat guꞌ baidhak na bɨɨmaꞌn tu koiꞌraꞌ mu kiaꞌmiꞌñ. Baꞌ na miꞌ daakat ba tu kuaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","maaꞌn miꞌ ba baa gu ubii nar ganaiꞌ pɨx kaꞌ ji dhaaꞌñchugɨt maaꞌn gu alhiꞌch jix jaikgam jaꞌaa, na mi jim suuꞌngɨm guiꞌ na joidham uub. Amuub jup kio guꞌ, puiꞌ ku baꞌx maat na miꞌp tuꞌiiꞌ gu Jesuus buiñor gu pariseo. ");
INSERT INTO stpNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Baꞌ suakidhat miꞌ ji tobiiꞌñchɨ na paiꞌ tootnatɨk gu Jesuus, xi bopkoñdhak buupui bargaꞌn kɨꞌn giop xi uañdhak kuupaꞌn kɨꞌn nat baꞌ miꞌ dhɨr miꞌ xi chiñxidhak miꞌ xi choiꞌ guiꞌ na joidham uub. ");
INSERT INTO stpNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Baꞌp jum aaꞌ gu pariseo juraꞌram bhaan: “Noꞌ sɨlhkam baabuiꞌ puiꞌ bhaankam ya oirɨ gu Dios dhi jaduuñ, ¿cham aa moox mat kaꞌ gɨt na jax jir tuꞌm dhi ubii na mi dhaꞌngɨ tootnaram? Giilhim jix uaꞌtulhdhix.” ");
INSERT INTO stpNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Baꞌp tɨtda gu Jesuus na miꞌ puiꞌ kam aaꞌ: ―Simoon, aañ maakam xim tɨɨdam. Baꞌp kaiꞌch guiꞌ: ―Eap xiñ aagiꞌñ jiñ jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Baꞌ xi aagiꞌñ gu Jesuus, jup tɨtda: ―Maaꞌnnim maaꞌn gu maaꞌnkam ja taiñbui gu tuumiñ gook gu jaꞌtkam, maaꞌn taiñbui jix chamaam jix chaꞌtmam ooꞌm, maaꞌn baꞌ gook ooꞌm daman mambhɨɨx. ");
INSERT INTO stpNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Guꞌ ji na guꞌ cham bhaaiꞌ nam jax dhui ka namkidhaꞌ gatuuk, puiꞌ baꞌ max ja joiꞌgɨlh guiꞌ nat ja taiñbui, jup ja tɨtda na puiꞌ ba tuiꞌkaꞌ, cham kam aaꞌ nam namkiꞌñdhaꞌ. ¿Baꞌ jaroop ɨlhiiꞌñ nat jix ioꞌm jix bhaiꞌm ɨlh gu gook jaꞌtkam nam tu uaꞌtdat, guiꞌ aa nax ioꞌm muiꞌ tu uaꞌtdat, kaꞌ guiꞌ aa na gook alh? ");
INSERT INTO stpNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Baꞌp kaiꞌch gu pariseo: ―Aañ ɨlhiiꞌñ na guiꞌ nax ioꞌm muiꞌ tu uaꞌtdat. Baꞌ gu Jesuus jup tɨtda: ―Jir puiꞌ dho nap jax kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Baꞌ miꞌ xi chɨɨgɨk gu Jesuus gu ubii jup tɨtda ɨp gio gu pariseo: ―Dhi ubii nap jax ba nɨiꞌñ, buupui bargaꞌn kɨꞌn jiñ bopkoñ guñ chooton, kuupaꞌn kɨꞌn baꞌ xiñ gakiiꞌñxidhak. Na pich guꞌ aap cham jiñ choiꞌ gum suuꞌngiꞌ na ñich jax ya ai nañ kɨꞌn xi bopkonai gɨt guñ chooton nañ baꞌ yaꞌ ba bakiaꞌm kiꞌaam. ");
INSERT INTO stpNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ni ku pich cham tuꞌ kaꞌm jiñ chɨɨdak jiñ ñioꞌki jaꞌp nap jax nɨiꞌñ dhi ubii nat pu cham jum jɨɨp na miꞌ puñ chiñxiꞌñchuꞌñ chooton am nañ jɨꞌx yaꞌ ba daa. ");
INSERT INTO stpNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni gu asait ku pich cham jiñ choiꞌ yaꞌñ moꞌ am na jax jaꞌk jum bua noꞌ jaroiꞌ paxiaraim, dhi ubii baꞌ dai bañ choiꞌñ chooton am dhiꞌ na joidham uub. ");
INSERT INTO stpNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Baꞌ aañ pum tɨtda na bɨɨx ba uañchudhix gu uaꞌtulhdhar gaꞌn, sia kut jax gɇꞌm uaꞌtulh, na guꞌ puiꞌ nat jax jix bhaiꞌ bañ dhuu, dhiꞌ bhaan jix maatɨꞌ nat soiꞌm ɨlhdhak bha jiiñ bui. Xib dɨr jaꞌp jaꞌk baꞌ dai nax bhaiꞌ bam taat kaꞌ, na guꞌ nañ jax bam tɨtda na gu jaroiꞌ noꞌ muiꞌ tu uaꞌtuꞌn, giilhim jix bhaiꞌm ɨlhdhaꞌ noꞌ jax tɨtda gu uaꞌtdam tugiꞌñ na puiꞌ ba tuiꞌkaꞌ. Gu jaroiꞌ baꞌ na pu gook alh tu uaꞌtuꞌndaꞌ noꞌt puiꞌp tɨɨꞌn gu uaꞌtdam tugiꞌñ na puiꞌ ba tuiꞌkaꞌ, palhɨɨp pɨx jix bhaiꞌ tu tatdachiaꞌ, na guꞌ pu cham paiꞌ pɨk jax jum aaꞌndaꞌ sia ku tu uaꞌtuꞌn, na guꞌr gook alh kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Baꞌp tɨtda gu ubii puiꞌ xi chɨꞌɨɨk: ―Ba uañchudhix ji matgɨm gum uaꞌtulhdharaꞌ, aañ yaꞌ pum tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Baꞌ gu jaiꞌ nam miꞌp tuꞌiiꞌ nat puiꞌp ja bai gu pariseo nam tu jugiaꞌ, jup jum tɨ tɨtda am: ―¿Jax baꞌm ɨlhdhat jup kaiꞌch dhi maaꞌnkam na baꞌ gam uaꞌtulhdharaꞌ xi chu uañchuꞌn? ¿Dios aam ɨlhiiꞌñ? ");
INSERT INTO stpNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Guꞌ ji na guꞌ xi chu aꞌgiꞌñchuꞌ gu Jesuus gu ubii, jup tɨtda: ―Giop jup ba jimiaꞌ cham jax jum aagɨt jiñ jaduuñ. Dɨɨlh jum palhbui pich guꞌ na pich tuꞌ sɨlhkam buiñor tɨ jɨɨꞌñ na dai aañ jix bhaaiꞌ nañ jum palhbuidhaꞌ. Baꞌ cham tuꞌ mu jaꞌk ka jim ap nap paiꞌ gammɨjɨ gɨt miꞌ pup jum tulhiiñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Baꞌ jɨꞌk jurniꞌñ kɨꞌn nat miꞌ puiꞌ xi chu duuk gu Jesuus, ma tu ja aꞌgidham ɨp gu jaꞌtkam. Naiꞌ jaꞌp ji bhɨi na paiꞌ jax muiꞌ daaꞌñxim jir kikcham, gio na paiꞌ jax jɨꞌdɨlh jir kikcham, ja aaꞌñdhim gu jaꞌtkam na jax jaꞌk jix bhaaiꞌ nam duñiaꞌ na baꞌx ja joiꞌmdai ja aꞌm tɨ tɨgiaꞌ gu Dios. Bɨɨx oiꞌñchuꞌ am gu mambhɨɨx daman gook gu noonbiꞌñ, ");
INSERT INTO stpNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","gio jɨꞌkchi gu uꞌuub guiꞌ nat bɨɨpɨꞌ dɨr ja duduaꞌñ, nat ja aꞌm dɨr maiꞌ ja joot gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ nam ja aꞌm jup tuiꞌñgɨt. Maadɨt jir diꞌ guiꞌ na Mariiya tɨɨꞌ, nam Magdalena kɨꞌn jup jix mat kaꞌ. Dhiꞌ jix jum gook gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ bhaan jup tuiꞌñgɨt am. ");
INSERT INTO stpNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Gio baꞌ jumai Juana tɨɨgɨm ɨp, Kuusa gu bɨngaꞌn. Gu Kuusa jir diꞌ na ja aaꞌñdhat gu tujuandam tugiꞌñ gu Eroodis nam jax jaꞌk tu duñiidhaꞌ. Gio baꞌ jumai Susaana tɨɨgim jup jimdaꞌ, gam jaiꞌ muiꞌ gu uꞌuub. Bɨɨx guiꞌ gu uꞌuub tu sabaꞌdaidhat gu koiꞌ dɨɨlh ja tumñiꞌ kɨꞌn tu ja uaꞌtulhiꞌñdhaꞌ am bɨɨx guiꞌ nam jɨꞌk maap jiimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Maaꞌnnim maaꞌn kap ka oirɨ gu Jesuus na mɨt muiꞌ miꞌ mam jumaap gu jaꞌtkam nam jix chɨɨgik, nammɨ jaꞌp mɨk xi juu mɨt miꞌ na paiꞌp tuꞌiiꞌ. Naiꞌ jaꞌp dɨr mi ai mɨt na paiꞌ jax muiꞌ paꞌ daaꞌñxim jir kikcham. Baꞌ gu Jesuus muiꞌ ji chu ja aꞌgi bhaan ji uaꞌrgidhak maaꞌn gu tiriik giigiꞌñdham, jaꞌpni muiꞌ ji kɨi: ");
INSERT INTO stpNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Maaꞌnnim maaꞌn gu maaꞌnkam xi chu moikdak muiꞌ ji chu giiꞌ gu tiriik, baꞌ jaiꞌ mu jaꞌk ma suulh boi chaꞌm na mi jaꞌp amuub bhɨix. Baꞌ naiꞌ ji biimkɨ nam kɨissapdaꞌ gu jaꞌtkam nam mi bhɨbhɨɨdaꞌ, mɨkkat jamɨt mi ɇɇk xi jugiokak gu uꞌjiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Baꞌ jaiꞌ jaꞌp jaꞌk joodai chɨr suulh ɨp na paiꞌx komaalhim kaat gu dɨbɨɨr, baꞌ nat paiꞌ dhuuk bhaiꞌ tɨi ji bubua, gio naiꞌp ji gaa, nat guꞌ cham tuukab takcha. ");
INSERT INTO stpNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Baꞌ jaiꞌ jaꞌp jaꞌk suulh ɨp na paiꞌx joiꞌñdhaꞌ na buandaꞌ gux bii uꞌuux jix joꞌiiꞌ. Baꞌ puiꞌ tɨi bhaiꞌp ji bubua, guꞌ ji nat guꞌ maaꞌn nat jax bhaiꞌbich gux bii uꞌuux jix joꞌiiꞌ nat bhaiꞌp ji bubua, miꞌ pu bhaiꞌku gu tiriik, jix uꞌuam miꞌ pup tuut, pu cham jɨꞌxkat gɨꞌrɨk kaicha. ");
INSERT INTO stpNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Baꞌ guiꞌ nat miꞌ suulh na paiꞌx kɨɨꞌ gu dɨbɨɨr, dhiꞌ dho gi guꞌ giilhim joidham jix bhaiꞌm duu ji, jɨꞌmaꞌn jix chamaam ooꞌm kaichuk xim kaip gu maaꞌn tiriik. Baꞌ miꞌ dhɨr nat puiꞌ xi chu ja aꞌgidhak, jup ja tɨtda gɇꞌ kɨꞌn: ―Jix bhaiꞌ pim xim gaꞌngadaꞌ na pim baꞌx maatɨt kaayaꞌ na jax jir jum duukam dhiꞌ na ñich bhaan tu jam aꞌgi. ");
INSERT INTO stpNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Baꞌ na mɨt paiꞌ jii gu muiꞌ jaꞌtkam, ba tɨkka am gu Jesuus guiꞌ nam kaichuꞌ na jax jir jum duukam gu tiriik giigiꞌñdham nat bhaan tu aꞌga. ");
INSERT INTO stpNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Baꞌp ja tɨtda gu Jesuus: ―Jax dhui na guꞌ aapiꞌm pux bhaiꞌ jam aaꞌñdhim gu Dios na pim jax jaꞌk duiñchuꞌndaꞌ na baꞌ xi jam joiꞌmdat jam aꞌm tɨ nɨidhidhaꞌ, na pim guꞌ bañ kaichuꞌ. Guꞌ guiꞌ ji nam jɨꞌk cham jiñ kaichuꞌ nañ baꞌ bɨxchuꞌ bhaan tu uaꞌrgidhat tu ja aꞌgiꞌñ, nam guꞌ cham tuꞌ bɨɨx ja jujur kɨꞌn jix maachik kaꞌ nañ jax kaiꞌchdhaꞌ. Pu cham baꞌ maatɨt jiñ kɇɇkɇꞌ am sia kum tɨix bhaiꞌñ kɇɇ gu tuꞌ nañ aꞌgadaꞌ, ni kum cham jɨꞌxkat machiaꞌ nañ paiꞌ dhɨr jimdat baꞌ ya oirɨ, sia kum tɨiñ ñɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Baꞌ ba ja aagiꞌñ gu Jesuus guiꞌ nam kaichuꞌ na tuꞌ aagɨt jup kaiꞌch nat bhaan uaꞌrgidhak gu tiriik giigiꞌñdham tu aꞌga. Jup ja tɨtda: ―Jaꞌpniñ dho kaiꞌñkam jup kaiꞌch bɨɨpɨꞌ na ñich bhaan tu aꞌga gu tiriik giigiꞌñdham. Gu jaroiꞌ noꞌt tu ja aꞌgi gu jaꞌtkam gu ñioꞌkiꞌñ gu Dios, dhiꞌ jaꞌp ji buusniaꞌ na tu giiꞌñdhaꞌ gu tiriik. ");
INSERT INTO stpNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Baꞌ guiꞌ nat boi chaꞌm suulh, guiꞌñ ja aagɨt jup kaiꞌch nam tɨi kaayaꞌ gu ñioꞌkiꞌñ gu Dios, dai ji na guꞌ na paiꞌ dhuuk mi ɇɇji gu jaꞌook maakam xi ja jurtudaꞌ nam sap baꞌ cham tɨ jɨɨꞌñdhai cham kam tulhiiñaꞌ, miꞌ baꞌ pu cham ka tɨꞌñchokaꞌ am na pɨn jax jum tɨꞌyaꞌ, gio mummɨ puiꞌp suulhgiaꞌ am baꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Baꞌ guiꞌ nat joodai chɨr suulh, guiꞌñ ja aagɨt jup kaiꞌch ɨp nam tɨi joidham kaayaꞌ gu ñioꞌkiꞌñ gu Dios, guꞌ pɨx ji nam guꞌ cham tuꞌ bɨɨx ja jujur kɨꞌn tɨ jɨɨgiꞌñdhaꞌ puiꞌ na jax jum kaiꞌchdhaꞌ, baꞌ dhiꞌ puiꞌm kaiꞌch na mɨt cham tuukab takcha. Jɨꞌxpɨx jam tɨi xi chɨ jɨɨgiꞌñdhaꞌ, guꞌ pɨx ji na guꞌ na paiꞌ dhuuk ja maiꞌchiaꞌ gu jaꞌook, maaꞌn nam jax gio mummɨ puiꞌp suulhgiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Baꞌ guiꞌ nat miꞌ suulh na paiꞌ buandaꞌ gux bii uꞌuux jix joꞌiiꞌ, guiꞌñ ja aagɨt jup kaiꞌch ɨp nam tɨi joidham kɇɇji tɨ jɨɨꞌñdhaꞌ na jax jum tɨꞌyaꞌ gu ñioꞌkiꞌñ gu Dios, pɨx ji nam guꞌ mɨkkat saalh jum oꞌjolhdhai naiꞌ cham tuꞌp ka jim buixdhaꞌ nam paiꞌ dhuuk bhaiꞌx buam jim ɨlhdhaꞌ, nam jix chu aagɨt nam gɨt bɨɨx aixim tuꞌm xi chu biaꞌkaꞌ gux dhaꞌram namkɨm na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch, baꞌ dhiꞌ puiꞌm kaiꞌch na ja bhaiꞌbchɨi ja bhaiꞌktudaꞌ gux bii uꞌuux jix joꞌiiꞌ. Miꞌ pu cham tuꞌ kap jum buixdhaꞌm baꞌ na jax jum tɨꞌyaꞌ gu ñioꞌkiꞌñ gu Dios, giom mummɨ puiꞌp suulhgiaꞌ na jax bɨɨpɨꞌ dɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Baꞌ guiꞌ nat miꞌ suulh na paiꞌ joidham jix kɨɨꞌ gu dɨbɨɨr, guiꞌ ja aagɨt jup kaiꞌch iñ nam bɨɨx ja jujur kɨꞌn pu gammɨjɨ ba tɨ jɨɨꞌñdhaꞌ na jax jum tɨꞌyaꞌ gu ñioꞌkiꞌñ gu Dios, cham jɨꞌxkat jaꞌk ka suulhgiaꞌ am baꞌ. Baꞌ dhiꞌ puiꞌ bam kaiꞌch ɨp nat giilhim joidham jix bhaiꞌm dunaak muiꞌm oo gu tiriik. ");
INSERT INTO stpNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Baꞌ jaꞌpnip ja tɨtda gu Jesuus: ―Aañ cham jɨꞌxkat jaroiꞌ paiꞌ nɨiꞌñ gu maaꞌnkam na xi mɨichdhai gu kañdhiir mɨjɨ jaꞌp xi ɨxchuꞌ boptoꞌ bɨtaꞌ, piam ku tuꞌ kɨꞌn xi sooꞌmdhai mi jaꞌp xi kɨɨsaꞌ. Guꞌ jaꞌpji bhammɨ jaꞌp na pu xi kɨɨsaꞌ tɇꞌkob na baꞌx chu maax kaꞌ nam mi jaꞌp oipodaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gio guꞌ cham jɨꞌxkat jum ɨxchuꞌ gu tuꞌ sia ku tɨi ɨxchuix panaas, ni ku cham jɨꞌxkat na moo cham jup matgilhiaꞌ sia ku tɨi cham tu aaꞌ gu jaroiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Jix bhaiꞌ pim xim gaꞌngadaꞌ nañ paiꞌ dhuuk puꞌñi bɨxchuꞌ bhaan tu uaꞌrgidhat tu aꞌgadaꞌ na pim baꞌ machiaꞌ. Na guꞌ noꞌ pim tuꞌ sɨlhkam jix maachik kat xim gaꞌnga, jam makiaꞌ gu Dios gu matdaꞌ na pim baꞌx maatɨt kaayaꞌ gu tuꞌ. Guꞌ ji noꞌ pim guꞌ pu cham maachik, sia ku pim palhɨɨp tɨi pɨx am jix maatɨt kɇɇ, sia dho dhiꞌ pu cham ka tɨꞌñchokaꞌ pim gatuuk. ");
INSERT INTO stpNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Baꞌ miꞌ ba ai gu dɨꞌɨɨꞌn gu Jesuus gio gu jajaaꞌnniꞌñ na paiꞌp tuꞌiiꞌ. Miꞌ dhɨr jaꞌp pɨx ji ai mɨt ja bɨɨbhiꞌ gu jaꞌtkam, nam guꞌ giilhim muiꞌ xikoor mi jumpax, pu cham bhaaiꞌ nam jax miaꞌn aayaꞌ nam tɨix chu aꞌgidham. ");
INSERT INTO stpNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Baꞌ maadɨt gu maaꞌnkam mu jimɨɨk na paiꞌ gu Jesuus, jup tɨtda: ―Miꞌñi dhɨr ba ai gum naan ja bɨɨm gum jaaduñ, xi chum aꞌgidham am sap. ");
INSERT INTO stpNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Baꞌp tɨtda gu Jesuus: ―Jax dhui na sia guiꞌ nam miꞌ puiꞌ ba jiim na jax jum kaiꞌch gu ñioꞌkiꞌñ gu Dios nañ puiꞌp ja ɨlhiiꞌñ na jax guñ ñaan gio guñ jaaduñ. Baꞌ puiꞌ xi chɨꞌɨɨk mɨjɨ xi ja kaim. ");
INSERT INTO stpNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Baꞌ maaꞌnnim gu Jesuus maaꞌn kanuub taꞌm xi chɨsdɨk jɨꞌk ja bɨɨm guiꞌ nam kaichuꞌ, jup ja tɨtda: ―Maik gor jach jimiaꞌ bhammɨ baasɨꞌn dɨr dhi gɇꞌ suudaiꞌ. Baꞌ gamaiꞌ ji jii mɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nammɨ ɨrban gu gɇꞌ suudaiꞌ na mɨt ji bhɨi, ba koi gu Jesuus mu dɨr jaꞌk xi jimɨɨk kuuꞌ dɨr gu kanuub. Baꞌ moo janoꞌ bhaiꞌ ji jɨb gam nat tɨbgirɨk bhaiꞌ ji dhuuꞌn tɨrnɨdam, gam nat bhaiꞌ sɨlh ji guꞌngukɨ gu suudaiꞌ, pɨx bhaiꞌ ba jim tu aim kanuub taꞌm. Bax chotdontuꞌ am guiꞌ nam kaichuꞌ nam puiꞌ xim aaꞌ noꞌt jotmodaꞌ am xi baa gu kanuub. ");
INSERT INTO stpNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Baꞌ mu jimɨɨk ba ñiññichuꞌn am gu Jesuus, jup tɨtda am: ―Jich jaduuñ, bi ñiñia. Tɨɨꞌ na jax jum bua gu suudaiꞌ. ¿Chaꞌch baꞌ yaꞌ bhaiꞌkuꞌ? Baꞌ gu Jesuus bamgɨk xi ñiok gu jɨbɨɨlh gio gu suudaiꞌ, jotmodaꞌ baꞌ ampɨx jup ji chu juu, pu cham paiꞌ ka jɨbɨɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Miꞌ dhɨr baꞌp ja tɨtda guiꞌ nam kaichuꞌ: ―¿Gi na pim saak bɨɨx jam jujur kɨꞌn tɨ jɨɨgiꞌñ aañ jiñ bui? ¿Jax jup jum duu? Guiꞌ cham ñiok am, dai nam jix chotdon, jɨꞌx bhaiꞌx bhaiꞌ jim ɨlhiiꞌñ na mɨt jax tɨɨ gu Jesuus nat tu duu, jup jum tɨ tɨtda am jix dhuꞌnpiꞌñ kɨꞌn: ―Jaꞌp moor gɇꞌkam ji bak jia dhich jaduuñ. Tɨɨꞌ na sia jɨbɨɨlh gio suudaiꞌ puiꞌp jix jɨɨgiꞌñ am nat xi ja ñiok. ");
INSERT INTO stpNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Baꞌ siamri ma ai mɨt bhammɨ dɨr jumai juꞌñdharam gu gɇꞌ suudaiꞌ na paiꞌ Geraasa bhaan bipioꞌ gu dɨbɨɨr, na Galilea dɨr sɨlh bhammɨx chu maax. ");
INSERT INTO stpNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Baꞌ nat muiꞌ ji chɨm gu Jesuus bhaiꞌ dhɨr kanuub taꞌm, ba tɨɨ maaꞌn gu maaꞌnkam jix ñaanbigɨm nat mummɨ dɨr jaꞌk bhaiꞌ ji buus na paiꞌ dhɨr muiꞌ paꞌ daaꞌñxim jir kikcham, bhaan jup tuiꞌñgɨdaꞌ am gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ nam baꞌ miꞌ dhɨr naanbichuꞌn kaꞌ. Muiꞌ oidhaꞌ ba uaꞌkaꞌ dhiꞌ dhi maaꞌnkam na naiꞌ pɨx pu oirɨdaꞌ puiꞌx dhaapkat. Miꞌ pɨk jix joiꞌñdhaꞌ nam paiꞌm yassapdaꞌ gu koiꞌñgaꞌn. Baꞌ nat amuub ba bhɨi, ");
INSERT INTO stpNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ba tɨɨ gu Jesuus na miꞌ kɨɨk. Baꞌ jotmodaꞌ mu mɨraak mi oꞌlhiaꞌn kɨꞌn bɨɨpɨꞌ dɨr ba kɨkbo, baꞌp tɨtda gɇꞌ kɨꞌn: ―¿Jax japich bhaiꞌ bañ dhoodam Jesuus maraaꞌn gu Gɇꞌkam Dios? Chaꞌp jiñ chulhiiñchuꞌndaꞌ. Ka tuñ uañiꞌñkaꞌ ap gu xib. ");
INSERT INTO stpNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Na guꞌ chian gu Jesuus gu cham kɨɨꞌ iiꞌmdaꞌ na mu buusniaꞌ bhaiꞌ dhɨr bhaan gu maaꞌnkam na baꞌ puiꞌ tum uañiꞌñ. Muiꞌkim jix ioꞌm ba ji koꞌktulh guꞌ, tɨi buupurdaꞌ am gu jaꞌtkam bapaiñum jix kaapak kɨꞌn na baꞌ cham naiꞌ pɨx mɨrdaꞌ gɨt, guꞌ ji na guꞌ xi ɨꞌkɨi miꞌ dhɨr ji dhaiꞌññiaꞌ ɨp gio, mummɨ jaꞌp baꞌ pɨx mɨmlhidhaꞌ gampɨx jix chu gak kɨr. Guiꞌ pɨx cham kɨɨꞌ iiꞌmdaꞌ na puiꞌ jaꞌk duiñchuꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Baꞌ xi chɨkka gu Jesuus, jup tɨtda: ―¿Jax jap tɨɨꞌ? ―Lejion dho ―jup kaiꞌch gux ñaanbigɨm. Baꞌ jaꞌp kaiꞌñkam jup kaiꞌch nam giilhim jir muiꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ nam bhaiꞌ baapxichuꞌ bhaan gu maaꞌnkam. ");
INSERT INTO stpNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Baꞌ soiꞌ tɨɨꞌn jamɨt bɨɨx dhɨt gu Jesuus na chakui mu jaꞌk ja jootosdaꞌ nam paiꞌ gammɨjɨ miꞌ pup jum tulhiiñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Guꞌ baꞌ na guꞌ ampɨk muiꞌ bha jaꞌp jup tum bipiaꞌ gu tatooxkolh oidhaꞌ taꞌm, jup tɨtda am na bhaiꞌ jaꞌk ka xi ja jootsaꞌ nam ja aꞌm ka xi baapkiaꞌ. Baꞌ gu Jesuus bhaiꞌ jaꞌk xi ja joot. ");
INSERT INTO stpNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jotmodaꞌ mɨt baꞌ bubuakɨk bhaiꞌ dhɨr bhaan gu maaꞌnkam bhammɨ jaꞌk pu baap. Baꞌ bhaiꞌ dhɨr ji boop jamɨt gu tatooxkolh naiꞌ gu aꞌnsap, mɨjɨmmɨ pu suulh jamɨt suudaiꞌ chɨr, pu bɨɨx koi mɨt bhaiꞌkuk. ");
INSERT INTO stpNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Baꞌ totdonɨk bhaiꞌ dhɨr jup ji boop jamɨt guiꞌ nam ka tu bipiaꞌdat gu tatooxkolh, sɨlh boop jamɨt nammɨ gama jaꞌk na paiꞌ muiꞌ paꞌ daaꞌñxim jir kikcham na mɨt ja aaꞌñdham gu jaꞌtkam, sia guiꞌ nam jɨꞌk ja tɨɨgim gu jaꞌtkam pu xi ja aaꞌñdhidhat am na mɨt jax tɨ tɨɨ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Baꞌ guiꞌ bhaiꞌp jii mɨt ɨp na mɨt bha tɨ tɨɨgim noꞌ sap moor sɨlhkam nam jax kaiꞌch, miꞌ ba ji bubua mɨt na paiꞌp tuꞌiiꞌ gu Jesuus. Baꞌx kɨɨꞌ juraaꞌn biaꞌ kam mi jaꞌp daa guiꞌ nam muiꞌ bhaan kap tuiꞌñgɨt gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ na mɨt ba tɨɨ, gio ba tɨ tɨiꞌdhix gu jajannulh, puiꞌx dhaapkat ka oirɨdaꞌ guꞌ. Baꞌ giilhim bhaiꞌ ji chootoꞌn jamɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Baꞌ gu jaiꞌ guiꞌ na mɨt tɨ tɨɨ nat jax tum duu nat baꞌ pɨk ba dua gu maaꞌnkam na kax ñaanbiꞌ kat, miꞌ dhɨr jix bhaiꞌp ba ja aaꞌñdhidhaꞌ am guiꞌ nam kiaꞌpɨx mi aajidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Baꞌ soiꞌ tɨɨdak ba joot jamɨt gu Jesuus bɨɨx guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ nam Geraasa dɨbɨɨr bhaan oiꞌdhaꞌ, nam guꞌ bax ɨɨbhiꞌñ. Baꞌ gu Jesuus nat jax bhaiꞌp tɨs kanuub taꞌm ba jii, gaammɨjɨ ji dhuu. ");
INSERT INTO stpNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Baꞌ tɨix oidhamut gu maaꞌnkam guiꞌ na kax ñaanbiꞌ kat, guꞌ ji na guꞌ cham aaꞌ gu Jesuus. Xi jootsak pɨx na ba jimiaꞌ mu nam paiꞌ oiꞌdhaꞌ gu jajaaꞌnniꞌñ, jup tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Ba jimiaꞌp ji matgɨm mu nam paiꞌ oiꞌdhaꞌ gum jaaduñ. Ja aagiꞌñdhaꞌ ap nat jax jaꞌk jix joiꞌmdak jum tɨɨgɨk jix bhaiꞌm duu gu Dios. Baꞌ ba jii ɨp gu maaꞌnkam nat tu aagam nat jax jaꞌk duuk duaꞌñ gu Jesuus. Bɨɨx kap ai na jɨꞌx jir kikcham miꞌ Geraasa. ");
INSERT INTO stpNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Baꞌ nat paiꞌ dhuuk gio bhammɨ dɨr jup ba ai gu Jesuus jumai juꞌñdharam gu gɇꞌ suudaiꞌ na paiꞌ Galilea bhaan bipioꞌ gu dɨbɨɨr, joidham pɨx jix bhaiꞌm ɨlh jamɨt gu jaꞌtkam guiꞌ nam bhaiꞌ dhɨr oiꞌdhaꞌ, nam guꞌ nɨɨra na gio bhammɨ dɨr jup tɨsdiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Baꞌ moo janoꞌ miꞌp ba ai gu maaꞌnkam Jairo tɨɨgim. Dhiꞌ maaꞌn kap jir gɇꞌkam kaꞌ nam paiꞌ tu chichiopiꞌ dai gu Israel kam jaꞌtkam. Baꞌ oꞌlhiaꞌn kɨꞌn xi kɨkbok bɨɨpɨꞌ dɨr na paiꞌ gu Jesuus soiꞌ ba tɨtda na sap iam mu jimiaꞌ kiaꞌmiꞌñ ");
INSERT INTO stpNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","na duaꞌñdharaꞌ gu maraaꞌn tɨɨyax na dakoo pɨx ba duatuꞌ. Daipuꞌ maaꞌn tu mar guꞌ sap, chi jɨꞌk mambhɨɨx daman gook oidhaꞌ biaꞌkam gu tɨɨyax. Baꞌ ma oi ɨp gu Jesuus, bɨɨx gu jaꞌtkam pɨx chuꞌp jum duu mɨt, pɨx maap sulhikgim am nam gamaiꞌ jiim, giilhim muiꞌ am guꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Maaꞌn bak baꞌ muiꞌp jimchuꞌ gu ubii na mambhɨɨx daman gook oidhaꞌ dɨr bax kaꞌook. Pu cham ka dua maaꞌnnim nat ka xi ai gu masaaꞌn, gammɨjɨ pɨx pup mɨrdaꞌ gu ɨꞌraꞌn. Muiꞌ tɨi ba ja umuaꞌ gu koꞌkdaiꞌ mamtɨm nam jix jaiꞌch, pu cham jaroiꞌ maadɨt iam ba duaꞌñ. Gam gu tuꞌ na biaꞌkat pu bɨɨx tu gaꞌraimɨk na kɨꞌn tɨi tu umuagiꞌñdhaꞌ na jaroiꞌ duaꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Baꞌ gatuuk dɨr muiꞌ xi ai miaꞌn na paiꞌ gu Jesuus na baꞌ cham tɨgiaꞌ, bhaiꞌ xi dhaa baꞌ juꞌñdharam gux kabook jannulhiꞌñ na daam dɨr tɨiꞌchuꞌ. Baꞌ jotmodaꞌ miꞌ pum kɨɨꞌñdha, pu cham paiꞌ ka mɨr gu ɨꞌraꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Baꞌ gu Jesuus naiꞌ ba ja tɨkka gu jaꞌtkam nam mu jiim, jup ja tɨtda: ―¿Jaroo bhañ dhaa? Guiꞌp kaiꞌch am na cham paiꞌ jaroiꞌ daꞌngɨ. Baꞌ miꞌ dhɨr jaꞌp jup kaiꞌch gu Peegro: ―¿Kux baꞌ jaroiꞌ bhaiꞌp jum daꞌngim jiñ jaduuñ? Jaꞌpji nam jum aꞌm sulhikgim gu jaꞌtkam nam jix kobkom ya jiim. ");
INSERT INTO stpNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Guꞌ ji na guꞌ gu Jesuus jix maat nat jaroiꞌ maadɨt jix koꞌkkam bha dhaa, jup kaiꞌch: ―Jaꞌpji guꞌ moo maadɨt jix koꞌkkam nat bhañ dhaa, taat iñ guꞌ nat jiñ aꞌm dɨr buus guiꞌ nañ kɨꞌn bɨxchuꞌx bhaaiꞌ nañ pu tu duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Baꞌ cham ka bhaaiꞌ na jax jum duñiaꞌ gu ubii na tɨi xix ɨxchu nat dhiꞌ bha dhaa, puiꞌ giꞌbokidhat mi oꞌlhiaꞌn kɨꞌn xi kɨkbok bɨɨpɨꞌ dɨr ba aagiꞌñ na tuꞌ kɨꞌn jix kaꞌooktugɨt kut baꞌ bha dhaa, xi aagiꞌñ nat cham paiꞌ ka mɨɨ gu ɨꞌraꞌn, dai nat xi dhaa pɨx gux kabook jannulhiꞌñ. Bɨɨx xi chɇ kɇɇ am gu jaꞌtkam na miꞌ puiꞌ kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Baꞌ gu Jesuus jup tɨtda: ―Pu ba dua pich ji matgɨm jiñ jaduuñ, na pich guꞌ bɨɨx jum jur kɨꞌn ba tɨ jɨɨꞌñ jiñ bui. Jix bhaiꞌp jum taattugɨt ba jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Baꞌ pui ka tu aꞌgichuꞌ gu Jesuus nat maaꞌn miꞌ ba ai gu maaꞌnkam, jup tɨtda gu Jairo: ―Cham ji na jax kax bhaaiꞌ sia kup muiꞌ tɨi ba baiꞌñchuꞌ dhi gɇꞌkam, jax dhui nat ba muu gum mar. ");
INSERT INTO stpNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Guꞌ ji na guꞌ kɇɇ gu Jesuus na jax tɨtda, baꞌp tɨtda gu Jairo: ―Chaam ji nap jax jum aaꞌndaꞌñ jaduuñ, dodhiaꞌ ji matgɨm gum mar. Aap tɨ jɨɨgiꞌñdhaꞌ pɨx na dai aañ jix bhaaiꞌ nañ jum palhbuidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Baꞌ mummɨ ba ai mɨt kiaꞌmiꞌñ gu Jairo. Gu Jesuus xi ja chianɨk gu muiꞌ jaꞌtkam nam miꞌ dhɨr pɨx ka guꞌkaꞌ dɨɨrap. Dai gu Peegro xi baidhak, gio gu Jakoobo, gio gu Juan, gio baꞌ gu gɨꞌkorgaꞌn gu tɨɨyax nat puiꞌ kiaꞌpɨx muu, mɨjɨ ji baap jamɨt baꞌ baꞌk chɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Giilhim tum suan nat muu gu tɨɨyax. Baꞌp ja tɨtda gu Jesuus: ―Chaꞌpim suandaꞌ. Jax dhui na guꞌ dhi tɨɨyax miꞌ pɨx koos, cham tuꞌ na muukix. ");
INSERT INTO stpNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Baꞌ guiꞌ xi aꞌsɨk jamɨt pɨx, nam guꞌ cham tɨ jɨɨgiꞌñ na jax ja tɨtda gu Jesuus, maaxik nɨiꞌñ am guꞌ nat muu gu tɨɨyax. ");
INSERT INTO stpNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Baꞌ xi nobchɨk gu Jesuus jup tɨtda gɇꞌ kɨꞌn: ―Aapiꞌ tɨɨyax, xi bamiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Baꞌ bhaiꞌ ji dhua nat jax pu tɨɨꞌn gu Jesuus, jix kɨɨꞌ bhaiꞌ ji bam. Miꞌ dhɨr dai nat xi ja chia gu Jesuus nam tu makiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Baꞌ cham bhaaiꞌ nam jax xim duñiaꞌ gu gɨꞌkorgaꞌn gu tɨɨyax nam jix bhaiꞌm taat nat ba dua. Xi ja sooꞌmchulhdhak ɨp baꞌ gu Jesuus nam cham jaroiꞌ aagiꞌñdhaꞌ nat duaꞌñ gu ja mar. ");
INSERT INTO stpNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Maaꞌnnim gu Jesuus maap xi ja jumpadak gu mambhɨɨx daman gook gu noonbiꞌñ, xi ja tajaañ baꞌ guiꞌ na kɨꞌn jix bhaaiꞌn kaꞌ nam ja aꞌm dɨr gu jaꞌtkam maiꞌ ja jootsaꞌ bɨɨx aixim tuꞌm gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ, gio baꞌ nam ja duduaꞌñdhaꞌ guiꞌ nam jaꞌp pɨx jix kakoꞌk kaꞌ bɨɨx aixim tuꞌm kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Baꞌ nat xi ja tajaañdhak naiꞌ ba ja jootos nam ja aaꞌñdhapuꞌ gu jaꞌtkam na jax jaꞌk jix bhaaiꞌ nam duñiaꞌ na baꞌx ja joiꞌmdat ja aꞌm tɨ tɨgiaꞌ gu Dios, gio baꞌ gux kakoꞌkkam nam ja duduaꞌñdhapuꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","jup ja tɨtda: ―Cham jum aaꞌ na pim tu uaꞌkat gu koiꞌ mu paiꞌ jiimdaꞌ, nix chuꞌ jaꞌppɨx aꞌsak ku pim tu kusbiodaꞌ, nix chuꞌ jam oꞌxia ku pim ja uaꞌkaꞌ, nix chuꞌ tuumiñ ku pim gaamtuꞌndaꞌ. Gu jam jajannulh pu daipuꞌ pim tɨ tɨichgɨdaꞌ na pim jax ba tɨ tɨiꞌchuꞌ. Cham tuꞌm aaꞌ guꞌ na pim bɨxchuꞌ tu uaꞌkat mu paiꞌ jiimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Baꞌ gu jaroiꞌ noꞌ pimɨt buiñor ai na cham jam bhaamkiꞌñ, pu miꞌ buiñor japim ji dharkat bɨɨx tu ja aꞌgidhaꞌ gu mi jaꞌp oiꞌñkam, cham tuꞌ na pim naiꞌ pɨx tɨbiappuidhaꞌ jaiꞌ kikcham. ");
INSERT INTO stpNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Baꞌ noꞌm cham jam kɨɨgalhiꞌñ mu paiꞌ jax chuꞌm kikcham, moo janoꞌ pim pu jimiaꞌ miꞌ dhɨr, dai na pim ja nɨiꞌñchudat xi xiixkai gu dɨbɨɨr na miꞌ ba gɨxiaꞌ jam tooton am, nam baꞌ dhiꞌ bhaan tɨꞌñchoꞌ ɨp gio gatuuk na dɨɨlh jir ja kuiñcha na mɨt cham jam kɨɨgalh. ");
INSERT INTO stpNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Baꞌ guiꞌ ma jii mɨt ɨp, mu jaꞌp jamɨt ji bhɨi na paiꞌ jax jɨꞌdɨlh jir kikcham, nam ja aaꞌñdhim gu jaꞌtkam nam jax jaꞌk duñiaꞌ nam cham mu jaꞌk bhɨɨyaꞌ nam paiꞌ gammɨjɨ miꞌ pup jum tulhiiñdhaꞌ, gam gux kakoꞌkkam nam xi ja duduaꞌñdhidhat. ");
INSERT INTO stpNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Baꞌ gux kaiꞌ Eroodis puiꞌ tɇ kɇɇkɇꞌ ɨp na mu paiꞌx bhaiꞌ tu buadaꞌ gu Jesuus. Dai pɨx ji na guꞌ cham bhaiꞌ mat kaꞌ nar jaroiꞌ pɨk daꞌ kaꞌ, nam guꞌp kaiꞌchdhaꞌ gu jaꞌtkam na sap pɨk baꞌ panaas jir diꞌ gu Juan jaꞌtkam bopkondam nat giop buus duadɨk mu dɨr na mɨt paiꞌ yaas. ");
INSERT INTO stpNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jaiꞌm baꞌp kaiꞌchdhaꞌ ɨp na sap dhiꞌr diꞌ gu Eliiyas guiꞌ na bɨjɨk bhaankamuꞌn gu Dios ya jaꞌp tu ja aꞌgidhimɨk gu jaꞌtkam gio yaꞌp ba ai. Jaiꞌm baꞌp kaiꞌchdhaꞌ ɨp na sap maadɨt pɨx jir diꞌ guiꞌ nam puiꞌ bhaankamuꞌn gu Dios ya jaꞌp tu ja aꞌgidhimɨk gu jaꞌtkam bɨjɨk, dai nat duadɨk giop ba buus mu dɨr nam paiꞌ yassap kat. ");
INSERT INTO stpNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Baꞌ cham mat kaꞌ gu Eroodis na jaroiꞌ baꞌ pɨk jir diꞌ kaꞌ, jup kaiꞌchdhaꞌ tɨi: ―Aañiꞌ tu chia nam ɨkiaꞌ gu Juan gu kuxboꞌn, ¿guꞌ baꞌ paa dɨr jaꞌk jup jim gu jaroiꞌ na mu paiꞌ pu bɨɨx aixim jix bhaiꞌ tu bua? Tɨi baꞌm gaꞌngadaꞌ dɨɨlh gu Eroodis na jax jaꞌk dui tɨgiaꞌ maaxik gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Baꞌ na mɨt gio jaꞌk jup ba suulh gu noonbiꞌñ gu Jesuus na mɨt tu ja aꞌgiꞌñpuk gu jaꞌtkam, ba aaꞌñdhim am na mɨt jɨꞌk tuꞌx bhaiꞌ dhuu mu jaꞌp na mɨt jax bhɨi. Baꞌ miꞌ dhɨr dai guiꞌ dɨlhkob jaꞌp jaꞌk jix ɨxchuixim xi ja boosgak, miꞌ dhɨr baꞌ mu jaꞌk pu ja baidhak maaꞌn kap gampɨx na paiꞌ Betsaida miaꞌn bipioꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Guꞌ ji na guꞌ na mɨt paiꞌ dhuuk tɨɨ gu jaꞌtkam na cham tu jaiꞌch gu Jesuus, gatuuk dɨr jamɨt muiꞌ pu ardi, mummɨ ba ji bubua mɨt na paiꞌp tuꞌiiꞌ. Baꞌ cham paiꞌ jax ja tɨtda gu Jesuus, dai nat bhaiꞌ ji chu ja aꞌgi na jax jaꞌk jix bhaaiꞌ nam duñiaꞌ na baꞌx ja joiꞌmdat ja aꞌm tɨ tɨgiaꞌ gu Dios, gam gux kakoꞌkkam nat xi ja duduaꞌñdhak. ");
INSERT INTO stpNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Baꞌ jaꞌxpɨx nat paiꞌ ba ji jur, miaꞌn xi ɇɇk jamɨt bɨɨx gu mambhɨɨx daman gook gu noonbiꞌñ na paiꞌp tuꞌiiꞌ gu Jesuus, baꞌp tɨtda am: ―Yaꞌ pɨx ma ji jur jich jaduuñ. ¿Cham jir am nap ba ja jootsaꞌ dhi jaaduñ kum bam jɨɨpdhapuꞌ mu jaꞌp paiꞌ kikcham? Ba tu taañpuꞌ am gu koiꞌ nam cham ya uaꞌmaꞌ gampɨx na paiꞌ cham tuꞌ jaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Baꞌp ja tɨtda gu Jesuus: ―Aapiꞌm dho yaꞌ ka xi chu ja makiaꞌ, ¿tuꞌ gi pɨk? Baꞌ guiꞌp kaiꞌch am: ―Jax dhui nach jix chamaam pɨx uaꞌ gu paan gio gu gook boptop, pu daipuꞌ. Jir muiꞌ am guꞌ dhi jaꞌtkam. Jɨɨꞌ ji noꞌch jaiꞌp tu taañpuꞌ nach baꞌ bɨɨx maaꞌn jimdam tu ja makiaꞌ nam jɨꞌk yaꞌp tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Maaxik giilhim jir muiꞌ am guꞌ gu jaꞌtkam nam jɨꞌk miꞌp tuꞌiiꞌ, aixkam chi jɨꞌk gook ooꞌm daman mambhɨɨx jix chaꞌtmam ooꞌm (5000) dai gu chichioꞌñ, guꞌ cham aagix ji gu uꞌuub gam aꞌaalh. Baꞌp ja tɨtda ɨp gio gu Jesuus gu noonbiꞌñ: ―Ea na pim xi ja chiñiaꞌ nam xiꞌxkor daraibuꞌ, jɨꞌk goꞌgok ooꞌm daman maꞌmambhɨɨx aixim nam jɨꞌdɨlh xiꞌxkor daraibuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Baꞌ guiꞌp xi ja chia mɨt gu jaꞌtkam nam daraibuꞌ nat jax ja chia gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Miꞌ dhɨr baꞌ xi dhaagɨk gu Jesuus gux chamaam gu paan gio gu gook boptop, jix dhaam jaꞌk xi chɨ tɨɨgɨk xi chu taxchaabgidhak pɨx muiꞌ ji ja maa gu noonbiꞌñ taꞌtak jaisaidhat. Baꞌ guiꞌ miꞌ dhɨr pɨx muiꞌp ji ja maa mɨt gu jaꞌtkam nam tu jugiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bɨɨx tu koiꞌmɨk am nam jɨꞌx ɨlhiiꞌñ. Jaiꞌ mɨt pu cham ka jugio na mɨt xiꞌ ba ka koob. Gio baꞌp ma jumaap jamɨt guiꞌ nat bii, mambhɨɨx daman gook bapaalh jamɨt ja susduiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Maaꞌnnim gu Jesuus maaꞌn kap dɨlhkob xi chu dañiimɨk jix dhaam jaꞌk buiñor gu Dios na baꞌ miꞌ dhɨr jup ja tɨtda guiꞌ nam kaichuꞌ nam jup oiꞌñchuꞌ: ―¿Jax jam kaiꞌchdhaꞌ gu jaꞌtkam na pim ja kɇɇkɇꞌ? ¿Jarooñ sap daꞌ? ¿Paañ sap dɨr jaꞌk jim? ");
INSERT INTO stpNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Baꞌ maadɨt jup tɨtda: ―Dho jɨꞌmaꞌn jup kaiꞌchdhaꞌ am nap sap pɨk baꞌ panaas aap jir diꞌ gu Juan jaꞌtkam bopkondam nat giop buus duadɨk mu dɨr na mɨt paiꞌ yaas. Jaiꞌm baꞌp kaiꞌchdhaꞌ ɨp nap sap aap jir diꞌ gu Eliiyas guiꞌ na bɨjɨk bhaankamuꞌn gu Dios ya jaꞌp tu ja aꞌgidhimɨk gu jaꞌtkam gio yaꞌp ba ai. Jaiꞌm baꞌp kaiꞌchdhaꞌ ɨp nap sap maadɨt pɨx jir diꞌ guiꞌ nam puiꞌ bhaankamuꞌn gu Dios ya jaꞌp jup tu ja aꞌgidhimɨk gu jaꞌtkam bɨjɨk, dai nat duadɨk giop ba buus mu dɨr nam paiꞌ yassap. ");
INSERT INTO stpNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Baꞌ dɨɨlh jup xi ja tɨkka gu Jesuus, jup ja tɨtda: ―Aapiꞌm gi, ¿xiñ maat japim aa nañ jir jaroiꞌ dhaꞌ gio nañ paiꞌ dhɨr jaꞌk jim? Baꞌp kaiꞌch gu Peegro: ―Dho aap jir diꞌ guch Xoiꞌkam nach jaroiꞌ nɨɨrat na bhach joochxidhaꞌ gu Dios jix dhaam dɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Baꞌ gu Jesuus xi ja sooꞌmchulhdhak nam sap cham jaroiꞌ aagiꞌñdhaꞌ nar diꞌ guch Xoiꞌkam, dɨɨlh pɨx sap jix mat kaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Baꞌ puiꞌ xi ja tɨɨdak jup ja tɨtda ɨp: ―Aañ matgɨm giilhim kañ chulhiiñaꞌ ji gatuuk. Xiñ bhaamkidhaꞌ am gu ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam, gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, gio guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam. Tu chiñiaꞌ am nam jiñ muꞌaaꞌ, ku guꞌ aañ baik tanoolh kɨꞌn yaaꞌ ji nañ jax ba oirɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Baꞌ jaꞌxpɨx muiꞌ jaꞌtkam jup ba tu ja aꞌgiꞌñ, jup ja tɨtda: ―Noꞌ jaroiꞌx aaꞌ na gammɨjɨ bañ kaichgɨdaꞌ, jum aaꞌ na cham tuꞌ bhaan kap jum buixiꞌñdhaꞌ gu tuꞌ na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch, sia chi moo jax jum tulhiiñaim, na guꞌ dhiꞌ baꞌ jaꞌp ji buusandaꞌ nañ oiꞌñchuꞌndaꞌ ji mootot gu kuruus. ");
INSERT INTO stpNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Na guꞌ gu jaroiꞌ noꞌ dai bhaan tɨtɨɨꞌñcho gu tuꞌ na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch, cham jɨꞌxkat palhbuidhaꞌ na jax jaꞌk jix bhaiꞌ tu jimiaꞌ gatuuk. Guꞌ ji noꞌ guꞌ cham tuꞌp jim buixdhat miꞌ puiꞌ xi chu duñiim nañ jax jix aaꞌ, jix bhaiꞌ ji na tu jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Gio guꞌ tuꞌp jix bhaiꞌ sia ku tɨi jaroiꞌ bɨɨx tu biaꞌ na jɨꞌk tuꞌx chu jaiꞌch yaꞌ dhi oiꞌñgaꞌn bhaan, noꞌ guꞌ jaꞌxpɨx ba mukiaꞌ? Ni ku ji palhbuidhai na jax jaꞌk jix bhaiꞌ tu jimiaꞌ buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Gio gu jaroiꞌ noꞌx xiꞌɨr nañ aꞌmkam tu ja aꞌgidhaꞌ gu jaꞌtkam, aañ puiꞌp jix xiꞌɨrai cham tuꞌp jiñ buixdhaꞌ buiñor janoꞌ nañ paiꞌ dhuuk gio bhaiꞌp jimdaꞌ gɇꞌkam kɨꞌn ja bɨɨm gu noonbiꞌñ guñ Gɨꞌkoraꞌ, janoꞌ nam paiꞌ dhuuk bɨɨx machiaꞌ gu jaꞌtkam nañ jax jir gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Baꞌ aañ pu kaiꞌch na pim aapiꞌm jaiꞌ dhɨt pui duduakaꞌ janoꞌ na paiꞌ dhuuk jix bhaiꞌ matgilhiaꞌ na tuꞌ sɨlhkam jix ja joiꞌmdat ja aꞌm tɨ nɨiꞌñ gu Dios bɨɨx gu jaꞌtkam, chakui pim moo bɨɨx koꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Baꞌ jɨꞌk jix jum baik tanoolh xip duu miꞌ na puiꞌ xi chu ja aꞌgidhimɨk gu Jesuus gu jaꞌtkam nat baꞌ miꞌ dhɨr giop jii maaꞌn kap xi ja baidhak baik gu noonbiꞌñ, moo gu Peegro, gio gu Jakoobo, gio baꞌ gu Juan, maaꞌn kap jamɨt tɨɨtɨs gɇꞌ oidhaꞌ taꞌm. Baꞌ bhammɨ na mɨt ba ai oidhaꞌ daam, jaꞌp jaꞌk dɨlhkob xi jimɨɨk gu Jesuus muiꞌ ji chu daanɨx dhaam jaꞌk buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Baꞌ miꞌ puiꞌ na ka tu daan, jotmodaꞌ maakam tuꞌm bam maax gu buibsaꞌn, jix chua totbikdam ba tɨ nɨiꞌñ. Sia gu tɨiꞌdhar gaꞌn jix chua totbikdam jup jum duu. ");
INSERT INTO stpNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Miꞌ dhɨr baꞌ miꞌ bam maax jamɨt gook gu jaꞌtkam bɨxxik dɨr na paiꞌp tuꞌiiꞌ, puiꞌ joidham jix aꞌbhar jup totnor gu ja tɨiꞌdharaꞌ, joidham jaꞌx xikoolh tum tanoor miꞌ nam jɨꞌx guguuk, jir diꞌ gu Eliiyas gio gu Moisees. ");
INSERT INTO stpNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Aagiꞌñ am baꞌ gu Jesuus nam jax chuꞌt tulhiiñchudai muꞌaaꞌ gu jaꞌtkam bhaiꞌ Jerusaleen. ");
INSERT INTO stpNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Baꞌ gu Peegro gio gu jaiꞌ gook nam maap jiim, xi chɨ nɨiꞌñ am sia kum jax jix kookxik, puiꞌ kum baꞌ nɨiꞌñ na joidham jix abhaar tobiik gu Jesuus gio gu gook na ja bɨɨm jup tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Baꞌ nat ba ji jii gu Moisees gio gu Eliiyas, jup kaiꞌch gu Peegro: ―Umrir am jiñ jaduuñ nach yaꞌ ka xi juruuñdhaꞌ. Aach jam oꞌnamdhaꞌ, maaꞌn jir aap gaꞌn kaꞌ, maaꞌn baꞌr Moisees gaꞌn kaꞌ, maaꞌn baꞌr Eliiyas gaꞌn kaꞌ. Cham jum matdaꞌɨr pɨx puiꞌ tɨi gu Peegro, pu cham maat na jax kaiꞌñkam jup kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Baꞌ jotmodaꞌ maaꞌn gu tɨbaaꞌ miꞌ pu ja ii bɨɨx na puiꞌ ka kaiꞌch gu Peegro. Baꞌ miꞌ giilhim bhaiꞌ ji chootoꞌn jamɨt nam ɨrban dɨr bap tuꞌiiꞌ gu tɨbaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Baꞌ bhaiꞌ ba tum ñio bhɨjɨ dɨr, jup tum kaiꞌch: ―Aañ dhiꞌr jiñ mar. Gɇꞌkam kɨꞌn bhaan tɨ tɨɨ ñich. Miꞌ pim puiꞌ xi jiimɨt na jax jam tɨɨdaidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Baꞌ nat paiꞌ gio ampɨx jup ji chu juu, dɨɨlh mi kɨɨk gu Jesuus na mɨt gio muiꞌp tɨ tɨɨ. Baꞌ cham paiꞌ jaroiꞌ aagiꞌñ am gu moo janoꞌ puiꞌ na mɨt jax tɨ tɨɨ, dɨɨlh pɨx jix mat kaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Baꞌ buimgidhak ba jii mɨt ɨp gio bhaiꞌ dhɨr oidhaꞌ daam. Nammɨ na mɨt jax pɨx ji juur sonpan gu oidhaꞌ, muiꞌ gu jaꞌtkam miꞌ ba nam jamɨt gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Baꞌ maadɨt mɨjɨ dɨr ja saagiꞌñ gu muiꞌ jaꞌtkam bhaiꞌ ba jiiñak, jup kaiꞌch: ―Jiñ jaduuñ, gi noꞌ pich iam duaꞌñ guñ alhii chuk. Tɨɨꞌ na jax jum bua. Daipuꞌ maaꞌn tu mar iñ guꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Bhaan jup tuiꞌdhiꞌ maaꞌn gu cham kɨɨꞌ iiꞌmdaꞌ. Paiꞌjɨx ioꞌm puꞌñi ba xi bhɨɨyaꞌ, bhaiꞌ jim totbhiopaꞌ, gio na bhaiꞌ ji choksolhiaꞌ gu chiñiiꞌñ, gio baꞌ na jiiñakdaꞌ. Giilhim gɇꞌ dho guꞌ ba koꞌktulh. Cham jɨꞌx busaak bhaiꞌ dhɨr bhaan. ");
INSERT INTO stpNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aañ yaꞌ tɨi soiꞌ ja tɨtda dhiꞌ nam jum kaichuꞌ nam iam maiꞌ jootsaꞌ gɨt gu cham kɨɨꞌ iiꞌmdaꞌ na puiꞌ jaꞌk duuk, guꞌ ji na guꞌ chix xijai, ¿jax ña jaꞌk? ");
INSERT INTO stpNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Baꞌp kaiꞌch gu Jesuus: ―¿Moo ni jɨꞌx aa ku pim jum guguuxiꞌñdhaꞌ na pim buiñor jum biiñkadaꞌ guñ Gɨꞌkoraꞌ? ¿Jɨꞌx jañ baꞌ ya jaꞌp oirɨt jup jam aꞌgiꞌñdhaꞌ na pim jax jaꞌk duñiaꞌ? Ea gor bhaiꞌ xiñ baiꞌñxidhak dhix koꞌkkam yaꞌni jaꞌk amuub. ");
INSERT INTO stpNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Baꞌ nam amuub ba baiꞌñchuꞌ gu biapmaꞌ na paiꞌ kɨɨk gu Jesuus, gio mi jaꞌp naiꞌp ji ia, naiꞌ xim totbhiopaim, gu cham kɨɨꞌ iiꞌmdaꞌ guꞌ na puiꞌ jaꞌk duuk. Guꞌ ji nat guꞌ gu Jesuus pu ñiok gu cham kɨɨꞌ iiꞌmdaꞌ, maaꞌn jimdam pu buus baꞌ bhaiꞌ dhɨr bhaan. Baꞌx kɨɨꞌ juraaꞌn biaꞌ kam bhaiꞌ ji bam gu biapmaꞌ. Miꞌ dhɨr baꞌ mu jaꞌk xi joochxi gu taataꞌn na mi jaꞌp kɨɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Baꞌ bɨɨx miꞌ puiꞌ pup tuꞌiiꞌ am gu jaꞌtkam nam cham paiꞌ dhuuk puiꞌ tɨ nɨidhat nat jax jix bhaiꞌm duukam bap tu duu gu Dios nax ioꞌm jir gɇꞌkam. Baꞌ miꞌ puiꞌ nam joidham jix bhaiꞌkam taat gu jaꞌtkam nat jix bhaiꞌm duukam jup tu duu gu Jesuus, miꞌ dhɨr jup ja tɨtda dai guiꞌ nam jɨꞌk kaichuꞌ: ");
INSERT INTO stpNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Aañ jaꞌpni xi jam tɨɨdam jiñ jaaduñ, moo pim cham mɨk buppadaꞌ dhiꞌ nañ jax jam tɨɨdaꞌ. Aañ nañ bhaankam ya oirɨ gu Dios, jum aayaꞌ gu tanoolh nam paiꞌ dhuuk jiñ dhagiaꞌ gu jaꞌtkam guiꞌ nam xiñ bhaamkiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Guꞌ ji na mɨt guꞌ pu cham maatɨt kai na jax kaiꞌñkam jup kaiꞌch gu miꞌ jotmodaꞌ guiꞌ nam kaichuꞌ, na guꞌ gu Dios pɨx dɨɨlh tu soobhiꞌñ nam chakui mamtɨdaꞌ. Panaas kum jix ɨɨbhiꞌñdhaꞌ ɨp guꞌ gu Jesuus nam gɨt jix bhaiꞌ xi chɨkkaꞌ na jax kaiꞌñkam jup kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Baꞌ maaꞌnnim ma ji ñiokbo mɨt ɨp dɨɨlh dai guiꞌ nam jɨꞌk kaichuꞌ gu Jesuus, jup kaiꞌch am na jaroo baꞌ pɨk jix ioꞌm jir gɇꞌkam dai guiꞌ nam jɨꞌk kaichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Guꞌ baꞌ gu Jesuus na guꞌx maat ja jujur am bhaan nam jax xi kaiꞌchimɨk, maaꞌn xi ñobchɨk gu alhii ");
INSERT INTO stpNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","jup ja tɨtda: ―Noꞌ jaroiꞌ maadɨt aapiꞌm jiñ buix biiñak kat jix bhaiꞌ ba duu maaꞌn gu alhii jaꞌp na dhiꞌñi, dhiꞌ aañ nax bhaiꞌñ dhuñiaꞌ. Guꞌ baꞌ gu jaroiꞌ na aañ jix bhaiꞌñ dhuñiaꞌ, guñ Gɨꞌkoraꞌ nax bhaiꞌ duñiaꞌ ɨp nat bhañ joot jix dhaam dɨr. Baꞌ dhiꞌ jaꞌpniñ kaiꞌñkam jup jam tɨtda na gu jaroiꞌ noꞌx aaꞌ nar gɇꞌkam kaꞌ ja bui gu jaiꞌ, jum aaꞌ na cham tuꞌ tuꞌ jim ɨlhdhat jix bhaiꞌ ja buadaꞌ gu jaiꞌ, dhiꞌ baꞌ puiꞌ bam kaiꞌch nar gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Baꞌ gu Juan jup tɨtda gu Jesuus: ―Jiñ jaduuñ, aach maaꞌn tɨɨ gu maaꞌnkam nam aꞌmkam maiꞌ ja jootos gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gu jaꞌtkam. Aach baꞌ xi sooꞌmchulhdhak, na guꞌ cham jich bɨɨm jup tuiꞌdhiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Baꞌ gu Jesuus jup tɨtda: ―¿Jax ku pimɨt baꞌp sooꞌmchulh? Jax dhui nach bɨɨm jup tuiꞌñgɨdaꞌ puiꞌ ji chuꞌt gu jaroiꞌ noꞌ cham bhaamut jich aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Baꞌ na ba miamlhim na paiꞌ dhuuk tu daaxix na giop ji jimiaꞌ gu Jesuus jix dhaam jaꞌk, juraaꞌn ba dai na mu jimiaꞌ Jerusaleen. ");
INSERT INTO stpNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bɨɨpɨꞌ muiꞌ xi ja joot guiꞌ nam kaichuꞌ maaꞌn kap na paiꞌ jɨꞌdɨlh jir kikcham na Samaaria bhaan bipioꞌ guiꞌ gu dɨbɨɨr, nam tɨ tɨkkaꞌ noꞌx bhaaiꞌ nam miꞌ xi chɨbiapuidhat. ");
INSERT INTO stpNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Guꞌ ji nam guꞌ cham aaꞌ gu mi oiꞌñkam, nam guꞌx maat nar Israel kam gu Jesuus ku baꞌ Jerusaleen jaꞌk jim. ");
INSERT INTO stpNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Baꞌ gu Jakoobo gio gu Juan jup tɨtda am gu Jesuus: ―¿Dho gi aap jax kaiꞌch jich jaduuñ noꞌ chich moo puiꞌp tɨi na ja aꞌm tai mi dhuuduꞌ kum bɨɨx mu koꞌyaꞌ gu mi oiꞌñkam? ¿Tuꞌ gi kum baꞌ cham aaꞌ? Tɨɨꞌ nat guꞌ gu Eliiyas puiꞌp tu duu bɨjɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Baꞌ gu Jesuus jaꞌk gɨɨsɨk jup ja tɨtda: ―Aapiꞌm dɨɨlh pu cham maat noꞌx kɨɨꞌ iiꞌmdaꞌ jam aꞌm tajaañix gu puiꞌ na pim jax kaiꞌch, kaꞌ baꞌ guꞌ cham. ");
INSERT INTO stpNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Jax dhui na guꞌ aañ na ñich bhaankam bha jii gu Dios yaꞌ dhi oiꞌñgaꞌn, cham tuꞌ nañ yaꞌ ja tulhiiñchudaꞌ gu jaꞌtkam, guꞌ jaꞌpji nañ jaꞌkbuiꞌ kat ja aagiꞌñdhaꞌ nam jax jaꞌk duñiaꞌ nam baꞌ cham jum tulhiiñaꞌ. Baꞌ miꞌ dhɨr pu maakam jaꞌk bhɨi mɨt na puiꞌ jɨꞌdɨlh jup jir kikcham nam baꞌ miꞌ xi chɨbiapuidhat. ");
INSERT INTO stpNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Baꞌ gamaiꞌ nam jiimchuꞌ bɨɨx boi, maaꞌn miꞌ dhɨr jaꞌp jup tɨtda gu maaꞌnkam gu Jesuus: ―Aañ jaiꞌ tɨip jix aaꞌ nañ gɨt jup jum kaichgɨdaꞌñ jaduuñ nañ baꞌ gɨt jaiꞌp xi jimdaꞌ paiꞌ nap jaꞌk oilhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Baꞌ gu Jesuus jup tɨtda: ―Jax dhui na aañ nañ bhaankam ya oirɨ gu Dios, pu cham paiꞌ bhaaiꞌ nañ joidham xiñ jɨɨpdhaꞌ gɨt, cham puiꞌ na gu kaxio na sɨlh jimiaꞌ mu paiꞌ na chioꞌ na ba kooxmɨraꞌ paiꞌ na duuk jix kooxim kaꞌ, piam puiꞌ na gu uꞌiiꞌ na sɨlh jimiaꞌ paiꞌ na tu kos kaꞌ na paiꞌ dhuuk jup jix kooxim kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Baꞌ dɨɨlh gu Jesuus jaꞌp jaꞌk jup tɨtda jumai: ―Aañ jaꞌp ɨlhiiꞌñ jiñ jaduuñ nap bañ kaichgɨdaꞌ xib dɨr jaꞌp jaꞌk. Baꞌp kaiꞌch guiꞌ: ―Dho ea nañ ka xi yaaspai guñ chaat noꞌt ba muu nañ baꞌ miꞌ dhɨr bam kaichgɨdaꞌ gammɨjɨ. ");
INSERT INTO stpNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Baꞌ gu Jesuus jup tɨtda: ―Jaꞌpji nap naiꞌ xi ja aaꞌñdharaꞌ gu jaꞌtkam na jax jaꞌk jix bhaaiꞌ nam duñiaꞌ na baꞌx joiꞌmdat ja aꞌm tɨ tɨgiaꞌ gu Dios, chaꞌp tuꞌ bhaan jup jim buixdhat gu jaꞌtkam guiꞌ nam jaꞌp ji buan nam koꞌiix. Matgɨm dhiꞌ yaꞌ pum yaaspaidhaꞌm ji dai koiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Baꞌ jumai miꞌ dhɨr jaꞌp jup tɨtda ɨp gu Jesuus: ―Aañ dho gi guꞌx aaꞌ ji nañ tuꞌ sɨlhkam bam kaichgɨdaꞌ, jix aaꞌ iñ nañ jaiꞌp xi jimdaꞌ paiꞌ nap jaꞌk jimdaꞌ. Dai pɨx ji nañ ka xi ja tabuimgiꞌñmɨrai bɨɨx guñ jaaduñ muñ kiꞌaam, miꞌ dhɨr dho gi baꞌ guꞌ bar cham tuꞌ kaꞌ ji. ");
INSERT INTO stpNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Baꞌ gu Jesuus jup tɨtda: ―¿Aap paa duuk nɨiꞌñ gu maaꞌnkam guiꞌ na tu juantuꞌndaꞌ jaraar taꞌm na kuuꞌ jaꞌk tɨ nɨidhim? Puꞌñi dhop ji buusan gu jaroiꞌ noꞌ dai bhaan tɨtɨɨꞌñcho gu tuꞌ na gatuuk dɨr biꞌiidhaꞌ, pu cham tuꞌ baꞌ bhaaiꞌn kaꞌ na jax dhui miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Baꞌ mɨkkat baik ooꞌm daman mambhɨɨx gook maap xi ja jumpadak gu Jesuus guiꞌ nam kaichuꞌ, goꞌgok baꞌ mɨjɨ xi ja joot bɨɨpɨꞌ nam tu ja aꞌgiꞌñpuꞌ gu jaꞌtkam gammɨjɨ na paiꞌ jax muiꞌ paꞌ daaꞌñxim jir kikcham na paiꞌ bhɨɨyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jup xi ja tɨɨdak bɨɨpɨꞌ dɨr nat baꞌ moo ba ja joot: ―Gɇꞌgɇr dhor gaꞌn tɨr ya jaꞌp na pim jax bax maat, guꞌ pɨx ji nam guꞌ gu ordam jir gook alh. Jum aaꞌ baꞌ na pim soiꞌ tɨtdadaꞌ guñ Gɨꞌkoraꞌ na yaꞌ tu gaa na jaiꞌ bhaiꞌp ja jootsaꞌ gu ordam nam baꞌ yaꞌ tu oraaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ku guꞌ ea na pim aapiꞌm ka xi chu ja aꞌgiꞌñpuꞌ gu jaꞌtkam. Xim nuukdat japim na cham tuꞌ jam duñiaꞌ, na pim guꞌ jaꞌp ji bubuakiaꞌ na jax gu kakasnir nam miꞌ pɨk aayaꞌ nam paiꞌx jaiꞌch kaꞌ gu sɨsɨɨꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Cham jum aaꞌ na pim gaamtuꞌndaꞌ tuꞌ tuumiñ, nix chuꞌ asaak ku pim kusbiodaꞌ. Gu jam sussak pu daipuꞌ na pim jax ja aaꞌntuꞌndaꞌ. Gu jaroiꞌ noꞌt ampɨk mu paiꞌ jam nam boi chaꞌm, daipuꞌ na pim xi ñiokdhai maaꞌn na pim jiimdaꞌ, chaꞌpim tu aꞌgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Paiꞌ jax chuꞌm kiicham na pim jix aik kaꞌ, jaꞌp japim tɨꞌyaꞌ na pim ja ñioꞌkdhaꞌ gu mi oiꞌñkam: “Moo gɨt xi jam joiꞌmdat jam aꞌm tɨ nɨidhidhaꞌ gu Dios.” ");
INSERT INTO stpNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Baꞌ noꞌm guꞌ joidham jir jix bhabhaiꞌkam gu mi oiꞌñkam, gammɨjɨ dho puiꞌx joiꞌmdat ja aꞌm tɨ nɨidhidhaꞌ gu Dios, guꞌ ji noꞌ guꞌ cham, cham dho ja aꞌm tɨ nɨidhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chaꞌpim naiꞌ pɨx tɨbiappuidhaꞌ kikcham, miꞌ ji na pim juruuñdhaꞌ paiꞌ nam jam aichdhaꞌx bhaiꞌ jam tɨɨdai. Na pim paiꞌ bɨɨx xi chu ja aꞌgidhai gu jaꞌtkam guiꞌ nam mi jaꞌp jup oiꞌñkaꞌ na pim baꞌ ba jimiaꞌ miꞌ dhɨr. Gio gu koiꞌ, miꞌ puiꞌ tu kuaꞌdaꞌ pim tuꞌ nam jam maakdaꞌ, gio gu suudaiꞌ miꞌ jam toiꞌdhidhaꞌ am, na guꞌ na pim jax bax maat gu jaroiꞌ noꞌ tuꞌ bhaan tu juan, mi buusnidhaꞌ gu maiꞌchɨk gaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Baꞌ mu paiꞌ muiꞌ kam tɨr na pim aayaꞌ, na muiꞌ paꞌ daaꞌñxim jir kikcham kaꞌ, noꞌ mɨt joidham jam tɨɨdak ma tu jam onbaiꞌ gu jaꞌtkam, aapiꞌm xi chu jugai gu tuꞌ nam jam bhiidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Gux kakoꞌkkam japim jup xi ja duduaꞌñdhai noꞌm ampɨk miꞌp jix jaiꞌch. Jaꞌp japim ja tɨɨdaꞌ bɨɨx gu jaꞌtkam: “Yaꞌ ma miamrɨ na pim paiꞌ dhuuk ampɨx machiaꞌ na pim jax jaꞌk duñiaꞌ na baꞌ xi jam joiꞌmdai jam aꞌm ba tɨ nɨidhidhaꞌ gu Dios.” ");
INSERT INTO stpNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Baꞌ noꞌ pimɨt miꞌ pɨk ai kikcham nam paiꞌ cham jam kɨɨgalhiꞌñdhaꞌ gu jaꞌtkam, jaꞌp japim xi ja tɨɨdai pu jimiaꞌ miꞌ dhɨr: ");
INSERT INTO stpNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Jam nɨiꞌñchudat jach yaꞌ xi xiixkai dhi dɨbɨɨr nat jɨꞌx yaꞌ bam bhiꞌiis jich chooton am gu yaꞌ jam kiꞌaam kam, baꞌ dhiꞌ bhaan jix maatɨꞌ kaꞌ na pimɨt cham jɨꞌx jich kɨɨgalh. Dai baꞌ nach jaꞌp pɨx xi jam tɨɨdam nat bak yaꞌ mam ai na pim paiꞌ dhuuk ampɨx machiaꞌ na pim jax jaꞌk duñiaꞌ na baꞌ xi jam joiꞌmdai jam aꞌm ba tɨ nɨidhidhaꞌ gu Dios.” ");
INSERT INTO stpNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Baꞌ aañ yaꞌ pu jam tɨtda nax ioꞌm cham bhaiꞌ tu ja jimiaꞌ dhiꞌ dhi jaꞌtkam janoꞌ na paiꞌ dhuuk jum aayaꞌ na tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn, cham tuꞌ puiꞌ na gu Sodooma kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Baꞌx buam jum aagɨt ba ja aaꞌ gu Jesuus gu Korasiin oiꞌñkam gio gu Betsaida kam, jup kaiꞌch: ―Aañ jix buam jiñ aaꞌ ja bui gu Korasiin oiꞌñkam gio gu Betsaida kam, na mɨt guꞌ cham miꞌ puiꞌ jii na jax jix aaꞌ guñ Gɨꞌkoraꞌ. Tɨi ñich jix bhaiꞌ tu duu ja nɨiꞌñchudat nam jax jaꞌk cham paiꞌ dhuuk puiꞌ tɨ nɨidhat. Noꞌñ gɨt Tiiro gio Sidoon puiꞌx bhaiꞌ tu duñiaꞌ sia kum cham jir Israel kam, moo janoꞌ gɨt soiꞌm ɨlhdhai miꞌ puiꞌ ba jimiaꞌ am. Jajannulh jix xaasak jam gɨt pu tɨm tɨiꞌdhaꞌ, ni kum ka batbiadaꞌ, jaꞌkbuiꞌ kat jam matai bhaiꞌ xim buidhidhaꞌ na bhaan jix maatɨꞌ kaꞌ nam sɨlhkam soiꞌm ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Baꞌ tuꞌ na jax chuiꞌkaꞌ, jix ioꞌm tulhiiñaraꞌ tɨr suulhgiaꞌ am janoꞌ na paiꞌ dhuuk jum aayaꞌ gu tanoolh na ja aagiꞌñdhaꞌ guñ Gɨꞌkoraꞌ bɨɨx gu jaꞌtkam nam jɨꞌk tuꞌ jax xi buimɨi yaꞌ dhi oiꞌñgaꞌn, cham tuꞌ puiꞌ na gu Sidoon oiꞌñkam gio Tiiro. ");
INSERT INTO stpNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Guꞌ baꞌ gu Kapernaum oiꞌñkam, jaꞌp jum aaꞌ am nam jix dhaam jaꞌk jiim buiñor guñ Gɨꞌkoraꞌ. Matgɨm mɨjɨmmɨ jaꞌk ji nam ja iabuꞌx ioꞌm tuukab na paiꞌ gɇꞌ tɨ dɨꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Baꞌ aapiꞌm nañ jam jootos na pim tu ja aꞌgiꞌñpuꞌ gu jaꞌtkam, gu jaroiꞌ noꞌ joidham cham jax ji kaiꞌchɨt jam kɇɇ na pim tu aꞌgiꞌñdhaꞌ, dhiꞌ aañ na joidham jiñ kɇɇkɇꞌ. Guꞌ baꞌ gu jaroiꞌ na cham jam kaim kaꞌ, dhiꞌ aañ na cham jiñ kaim kaꞌ ɨp. Ku guꞌ cham tuꞌ ji na dai aañ na cham jiñ kaim kaꞌ, guꞌ jaꞌpji sia guñ Gɨꞌkoraꞌ nat bhañ joot yaꞌ dhi oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Baꞌ gio pɨx jaꞌx jup ji ai mɨt gu baik ooꞌm daman mambhɨɨx gook guiꞌ nam kaichuꞌ gu Jesuus na mɨt jaꞌk ba suulh na mɨt tu ja aꞌgiꞌñpuk gu jaꞌtkam. Jix bhaiꞌm taattugɨt ba aagiꞌñ am na mɨt tuꞌ joidham tu duu mu jaꞌp, jup tɨtda am: ―¡Jich jaduuñ, giilhim xich jɨɨgiꞌñ am gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ nach jum aꞌmkam maiꞌ ja jootos ja aꞌm dɨr gu jaꞌtkam! ¡Jotmodaꞌ pu buan am! ");
INSERT INTO stpNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Baꞌp ja tɨtda gu Jesuus: ―Dho na guꞌ aañ cham tuꞌr jiñ jupaabkam gu jaꞌook, puiꞌ ku baꞌ xiñ jɨɨgiꞌñ. Tɨɨ ñich guꞌ nat bha ji buax dhaam dɨr guñ Gɨꞌkoraꞌ janoꞌ nat paiꞌ dhuuk giilhim jum uaꞌtulh buiñor, jaꞌp jum duu na jax gu duuk noꞌt bɨpgɨ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Puiꞌ ku ñich baꞌ aañ jam tajaañ guiꞌ na pim kɨꞌn jum palhbuidhidhaꞌ na cham tuꞌ tuꞌ jam duñiaꞌ, siat chi moo tuꞌ naksɨr cham tu jimchuꞌndam jam kɨi, piam jax chuꞌm jumai koꞌx maimdagɨm. ");
INSERT INTO stpNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Dai pɨx ji na pim guꞌ cham dhiꞌ kɨꞌn jix bhaiꞌp bam taat kaꞌ, guꞌ jaꞌpji na pim ba uaꞌñix uꞌuan taꞌm jix dhaam na pim jax chɨɨꞌ na pim kɨꞌn jix bhaiꞌm taat kaꞌ, na guꞌ dai guiꞌ nam ba uaꞌñix kaꞌx dhaam na ja baidhikaꞌ gu Dios na paiꞌp tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Baꞌ miꞌ jotmodaꞌx bhaiꞌ bhaiꞌ jim ɨlh gu Jesuus, nat guꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ pɨx puiꞌ jaꞌk duu na bhaan tajaañix. Baꞌp kaiꞌch: ―Aañ jix bhaiꞌñ chaat jum buiñ Gɨꞌkoraꞌ, aap nap jir gɇꞌkam jix dhaam gio yaꞌ dhi oiꞌñgaꞌn, na pich guꞌ ba ja mattuda gu jaꞌtkam guiꞌ nam gampaiꞌ tuꞌm na pich tuꞌ ja ɨxchuix gux mamatdagɨm jum aaꞌndam. Baꞌ aañ jix bhaiꞌñ chaat jiñ Gɨꞌkoraꞌ, nap guꞌ puiꞌ jaꞌk jix aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Baꞌp ja tɨtda guiꞌ nam miꞌp tuꞌiiꞌ: ―Aañ bɨɨx tuñ maa guñ Gɨꞌkoraꞌ na jɨꞌk tuꞌx chu jaiꞌch, na guꞌ dai aañ jix bhaiꞌ xiñ maat nañ jir tuꞌp tuꞌm daꞌ, nañ guꞌr maraaꞌn. Gio aañ yaꞌ dɨr mu jaꞌk dai aañ dɨɨlh pɨx jup jix maat guñ Gɨꞌkoraꞌ nar tuꞌp tuꞌm daꞌ. Guꞌ baꞌ gu jaroiꞌ noꞌx maachim nach jir tuꞌp tuꞌm daꞌ gook dɨt, aañiꞌ dho aagiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Baꞌ mu jaꞌk xi ja tɨɨgɨk jup ja tɨtda dai guiꞌ nam kaichuꞌ: ―Joidham noꞌm bɨɨx puiꞌp tɨ tɨgiaꞌ gɨt gu jaꞌtkam na pim aapiꞌm jɨꞌk tuꞌ joidham jix bhaiꞌm duukam tɨ nɨiꞌñ nañ jup tu bua. ");
INSERT INTO stpNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na guꞌ guiꞌ nam bhaankamuꞌn gu Dios ya jaꞌp tu ja aꞌgidhimɨk gu jaꞌtkam bɨjɨk, gio gux ioꞌm gɇꞌgɇrkam kat Israel kam, puiꞌ tɨi joidham tuꞌm jup jix chɨ tɨɨgik kat am na pim aapiꞌm jax joidham tuꞌm tɨ nɨiꞌñ xib, guꞌ ji na mɨt guꞌ cham pu chuꞌm tɨ tɨɨ. Sia puiꞌ joidham tuꞌm jup jix chɨ kaik kat am tɨi na pim aapiꞌm jax joidham tuꞌm tɇ kɇɇ xib, guꞌ ji na mɨt guꞌ cham pu chuꞌm tɨ kai. ");
INSERT INTO stpNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Baꞌ maadɨt guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios mu jimɨɨk bhaiꞌ ba tɨkka gu Jesuus, na miꞌ pɨx jix maachim noꞌ sap moo puiꞌ pɨx jup ji bua na jax ɨlhiiꞌñ dɨɨlh. Jup tɨtda: ―Jiñ jaduuñ, aañ jaꞌp tuꞌm bham tɨkkam nap iam jiñ aagiꞌñdhaꞌ gɨt nañ jaꞌp tɇ kɇɇ nap bɨxchuꞌ pɨx jix maat. ¿Tuꞌñ jax dhuñiaꞌ nañ baꞌ gammɨjɨ buiñor bap tuiꞌkaꞌ gu Dios? ");
INSERT INTO stpNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Baꞌ gu Jesuus jup tɨtda: ―¿Dho jax gim kaiꞌch nap tu jiñkaiꞌñdhaꞌ miꞌ na paiꞌ tu uaꞌñix gu ñioꞌkiꞌñ gu Dios na mɨt tu uaꞌnak gu bɨjɨk dɨr kam na tuꞌ pɨk jix ioꞌm jum aaꞌ nach pu duñiaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Baꞌp kaiꞌch: ―Dho sap nach gammɨjɨ tuꞌ kaꞌm nɨiꞌñdhaꞌ gu Dios, gio nach gammɨjɨ tɨꞌñchokaꞌ bɨɨx jich jujur kɨꞌn gio na jɨꞌx jich iꞌiiꞌmdaꞌ kɨꞌn, bɨɨx nach jɨꞌx pup jich chaat. Gio sap baꞌ nach jix joiꞌmdai tɨɨgɨix bhaiꞌ dhuñiaꞌ gu jaroiꞌ noꞌ tuꞌ bhaan jum tulhiiñ, panaas ku sap moo aach pɨx jir guiꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Baꞌ gu Jesuus jup tɨtda: ―Dho puꞌñi pɨx nap duñiaꞌñ jaduuñ nap baꞌ gammɨjɨ buiñor bap tuiꞌkaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Guꞌ ji nat guꞌ gio bhaiꞌp ka xi chɨkka guiꞌ na sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios na sap baꞌ cham jax jum aaꞌndaꞌ gu Jesuus na jaꞌp pɨx bha tɨkka sia kux maat, jup tɨtda: ―Dho jaꞌpji nañ cham maat na jax chuꞌm jaꞌtkam baꞌ ja aagɨt jup kaiꞌch guiꞌ nañ puiꞌx ja joiꞌmdaix bhaiꞌ ja duñiaꞌ noꞌm tuꞌ bhaan jum tulhiiñ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Baꞌ gu Jesuus muiꞌ ji chu aꞌga bhaan ji uaꞌrgidhak maaꞌn gu maaꞌnkam, jup kaiꞌch: ―Maaꞌnnim maaꞌn gu maaꞌnkam Jerusaleen kam tɨi ma paxiaram mu jaꞌk Jerikoo. Guꞌ ji na mɨt guꞌ gama jaꞌk daagɨk gɨbiimɨk gux ɨꞌxkum, tɨi pup mukxikam jamɨt mi jaꞌp xi buak boi chaꞌm, xi chɨ ɨɨxdhak jamɨt baꞌ bɨɨx guiꞌ na jɨꞌk tuꞌ tu uaꞌkat. Daman gu jajannulhiꞌñ pup jamɨt xi chu kookoxchulhdhak xi chu uꞌuuk na ka tɨ tɨiꞌchgɨt, puiꞌx dhaapkat jamɨt miꞌ xi buak. ");
INSERT INTO stpNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Baꞌ ampɨk miꞌp bhɨichuꞌ maadɨt guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam. Baꞌ ba tɨɨ na miꞌ kaat, ni jɨꞌx kut iam jix joiꞌmdat tɨɨ. Miꞌ dhɨr jaꞌp gakoolh xi bhɨɨk maaꞌn na jimchuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Baꞌ jaꞌxpɨx muiꞌp ba jimchuꞌ maadɨt guiꞌ nam jir tujuandam mu jaꞌp chichiop nam paiꞌ tu daandaꞌ dai gu Israel kam jaꞌtkam. Baꞌ puiꞌp ba tɨɨ na miꞌ kaat boi chaꞌm, guꞌ pɨx ji nat guꞌ puiꞌ cham joiꞌmdat jup tɨɨ sia, miꞌ dhɨr jaꞌp gakoolh xi bhɨɨk puiꞌ maaꞌn na jimchuꞌ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Baꞌ siamri maaꞌn gu maaꞌnkam Samaaria kam mi jaꞌp jup ka jim dhiꞌ kaꞌm gu boi. Dhiꞌ dho gi guꞌx joiꞌmdak tɨɨ ji na miꞌ soiꞌ tuꞌiiꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","muiꞌ pu ji ai miaꞌn. Baꞌ xi chu juulh na paiꞌ jax jix koꞌktulhdhix gu tukgaꞌn, gio nat xi chu bhiibgi jajannulh saaskiꞌ kɨꞌn. Baꞌ bhaiꞌ xi dhaasak bhaan gu bhuruꞌx na uaꞌ ba bhɨɨk maaꞌn kap na paiꞌ tɨm tɨbiappu, baꞌ xi chu namkidhak mɨjɨ ba booꞌn. Miꞌ baꞌ pu daakat nuukaꞌn bɨx chukaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Baꞌ buimgidhak gu Samaaria kam maaꞌnkam jup tɨtda guiꞌ nar gaꞌn miꞌ na paiꞌ tɨm tɨbiappu: “Yaꞌp kañ ñɨiꞌñxiꞌñkaꞌ dhiñ jaduuñ na miꞌ boꞌ, jix bhaiꞌp ka buadaꞌ. Yaꞌni gook gu tuumiñ nap kɨꞌn sabaꞌñxidhaꞌ gu tuꞌ noꞌ bam aaꞌ. Noꞌ pich jax dhuuk jaiꞌ dɨɨlh jum tumñiꞌ kɨꞌn tu namki gu tuꞌ, aañ jaꞌk jum iabuidhaꞌ nañ gio yaꞌp buusniaꞌ nañ jaꞌk ba gɨɨxchuꞌndaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dho jaña, ¿jax chuꞌm dhi baik jaꞌtkam na mɨt miꞌ bubuax joiꞌmdak tɨɨgɨk jix bhaiꞌ dhuu gu maaꞌnkam na miꞌ tulhiiñix boi chaꞌm? ");
INSERT INTO stpNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Baꞌ guiꞌ na sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios jup kaiꞌch: ―Dho gu Samaaria kam. Baꞌ gu Jesuus jup tɨtda: ―Dho puꞌjani pɨx jaꞌk jum aaꞌ nap duñiaꞌñ jaduuñ, jix bhaiꞌp ja buadaꞌ bɨɨx pɨx gu jaꞌtkam, sia moo nar paiꞌ kam kaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Baꞌ puiꞌ xi chu aꞌgidhat jimchuꞌ gu Jesuus. Nammɨ gama jaꞌk maaꞌn kap ba ai na paiꞌ jumai jɨꞌdɨlh jup jir kikcham. Baꞌ maaꞌn miꞌ kiokaꞌ gu ubii Maarta tɨɨgim, joidham cham jax ji chɨꞌɨɨk aich na sap miꞌ xi chɨbiapui. ");
INSERT INTO stpNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Baꞌ maaꞌn tɨ sɨɨpiꞌñ kaꞌ gu Maarta, Mariiya tɨɨgim. Dhi Mariiya mi jaꞌp ji dhaibuk amuub kɇɇ na tu aꞌga gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Baꞌ gu Maarta bha jaꞌp jix bhaiꞌ tu bua bɨɨx aixim gu tuꞌ. Baꞌ na guꞌ cham palhbuiꞌñ gu sɨpdhiꞌñ, mu jimɨɨk amuub jup tɨtda gu Jesuus: ―Noꞌ pich miꞌ dhɨr iam jaꞌp tɨɨꞌn dhiñ xikuꞌ na jaiꞌ xiñ palhbuidhaꞌ nañ tuꞌx bua. Miꞌ pɨx pu daa. ¿Kaꞌp ji cham joiꞌmdat jiñ ñɨiꞌñ aañ jaduuñ? ");
INSERT INTO stpNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Baꞌ gu Jesuus jup tɨtda: ―¿Jax kup baꞌ moo bhaan jix buam jup jum aaꞌ Maarta gu tuꞌ nap bɨɨx aixim ji chu buaꞌt? ");
INSERT INTO stpNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Jax dhui na maaꞌn pɨx jix ioꞌm jum aaꞌ nap pu duñiaꞌ, nap yaꞌni jaꞌp daibui xiñ kaayaꞌ na jax dhi Mariiya. Dhiꞌ jɨꞌ ji nax ioꞌm jum aaꞌ. Baꞌ cham jir am nañ muiꞌp bam joochxiꞌñdhaꞌ dhi Mariiya, nat guꞌ dhiꞌ yaꞌ ba ai na paiꞌ pɨk jum aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Maaꞌnnim maaꞌn kap xi jimɨɨk gu Jesuus ma tu daanɨ jix dhaam jaꞌk buiñor gu Dios, bɨɨx jam jup oiꞌñchuꞌ guiꞌ nam kaichuꞌ. Baꞌ nat tɨɨmok na xi chu dañiimɨk, maadɨt miꞌ dhɨr jaꞌp jup tɨtda guiꞌ nam kaichuꞌ: ―Jich aagiꞌñdhaꞌ ap jich jaduuñ nach jax jaꞌk tu daandaꞌx dhaam jaꞌk buiñor gu Dios, jaꞌp nat jax gu Juan jaꞌtkam bopkondam jup ja aaꞌñdhak guiꞌ nam kaichgɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Baꞌp ja tɨtda gu Jesuus: ―Dho jaꞌp japim kaiꞌchdhaꞌ na pim paiꞌ dhuuk tu daandaꞌ buiñor gu Dios: Aapiꞌch Gɨꞌkoraꞌ nap jix dhaam jup tuꞌiiꞌ, aap nap gammɨjɨx uañ kɨꞌn pur jum tɨɨtgɨdam kaꞌ. Iam jap jaꞌxbuiꞌ puiꞌp xi chu buadaꞌ yaꞌ dhi oiꞌñgaꞌn jaꞌp nap jax tu buadaꞌx dhaam jaꞌk. Ku guꞌ aap ji noꞌp dɨɨlh puiꞌp ɨlhiiꞌñdhaꞌ gɨt, aach puiꞌ pɨx soiꞌm kaichuꞌn ji. ");
INSERT INTO stpNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gio dhich chuukuꞌ na tuꞌ kɨꞌn jup dua, gammɨjɨp xi maakidhat nabap tanoolh na baꞌ kɨꞌn jix bhaiꞌ tu tatda kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gio baꞌ nap iam tuch uañiꞌñkaꞌ nach jɨꞌx mach uaꞌtulhdhaꞌ jum bui, puiꞌ nach jax jup tu ja uañiꞌñ aach guiꞌ nam jup jum uaꞌtulhiꞌñ jich bui. Gammɨjɨp iam jich aꞌm tɨ nɨidhidhaꞌ na cham jich maiꞌchɨi gu jaꞌook jumai boi bhaan jich bhɨichdhaꞌ na paiꞌ maiꞌx chɨ gɨɨxiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Baꞌ jaꞌpnip ja tɨtda gu Jesuus: ―Kani nañ jam aagiꞌñdhaꞌ na jax pɨk jaꞌk tu tuꞌiiꞌ dhiꞌ. Noꞌ maadɨt aapiꞌm na pim jɨꞌk yaꞌp tuꞌiiꞌ, ɨraab tukaaꞌ muiꞌ ba tu soon jum kiꞌaam gu jaroiꞌ na miꞌ dhɨr jaꞌp jup kiokaꞌ, noꞌ guꞌ jax jum tɨtda: “Jiñ jaduuñ, iam gook jiñ chaiñbuiꞌñ gu paan ");
INSERT INTO stpNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","nañ onbaiꞌñdhaꞌ maaꞌn guñ jaduuñ nat mɨk dɨr mi ai. Giilhim sap bax bhioꞌntuꞌ, aañ guꞌ pu cham biaꞌ gu tuꞌ nañ iam onbaiꞌñdhaꞌ gɨt.” ");
INSERT INTO stpNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Baꞌ noꞌp guꞌ aap mɨjɨ dɨr jup tɨtda: “Kux cham jir gɇꞌ tukaaꞌ aa ku pich baꞌ moo bhaiꞌp bañ ñiñiichdham. Bha siisap ɨp guꞌ gu kiꞌñgob, gio yaꞌ ja saagiꞌñ boꞌ iñ guñ aꞌaalh chuk. Cham dho baꞌ jax jix bhaaiꞌ nañ bamgiaꞌ, dampan ji baꞌ noꞌ giop ba xi chum aagim.” ");
INSERT INTO stpNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Guꞌ ji noꞌ guꞌ pɨx ji kɨɨsaim na soiꞌ kaiꞌch nam taan, ma ji bamgiaꞌp ji matgɨm nap tu makmɨraꞌ bɨɨx gu tuꞌ na aaꞌndaꞌ. Ku guꞌ aañ yaꞌ pu jam tɨtda ji na cham tuꞌ na moo nap jix mat kaꞌ kup baꞌ tu makiaꞌ, guꞌ jaꞌpji na pɨx ji kɨɨsaidhaꞌ na soiꞌ kaiꞌchdhaꞌ kup baꞌ tu makiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Baꞌ aañ puiꞌp jam tɨtda, gu tuꞌ na pim taandaꞌ guñ Gɨꞌkoraꞌ, jam makiaꞌ dho. Piam gu tuꞌ na pim gaꞌngadaꞌ, jam aagiꞌñdhaꞌ ɨp. Gio noꞌ pim pɨx ji kɨɨsaim na pim bha tu soon kiꞌñgob, jam kupioꞌkdhaꞌ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Na guꞌ na pim jax bax maat gu jaroiꞌ noꞌ pɨx ji kɨɨsaim na tu taan gu tuꞌ, makiaꞌ am. Piam noꞌ tuꞌ gaꞌnga, tɨgiaꞌ ɨp. Gio noꞌ pɨx bhaiꞌ ji chu soon bhaiꞌ paiꞌ kiꞌñgob, kupioꞌkdhaꞌm ɨp. ");
INSERT INTO stpNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Aapiꞌm daas aa na pim jodai makiaꞌ gu jax chuꞌm jam mar noꞌ paan jam taan? ¿Piam ku pim guꞌ koꞌ muiꞌ ba maak noꞌ batoop jam taan? ");
INSERT INTO stpNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Piam ku pim guꞌ naksɨr muiꞌ ba daagiꞌñ noꞌ lankiiyus jam taan? ");
INSERT INTO stpNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","¿Jia na pim guꞌ bɨɨx pɨx jir jix bhabhaiꞌkam ja bui gu jam maamar, sia ku pim jax jir jix uꞌuaꞌtulhdhix kam jaꞌtkam? ¿Guñ Gɨꞌkoraꞌ gi baꞌ na giilhim jir jix bhaiꞌkam nax dhaam jup tuꞌiiꞌ? Tajaañdhaꞌ ji matgɨm gux Dhuuduꞌ kam jix Uañ Iiꞌmdagaꞌn gu jaroiꞌ na taandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Maaꞌnnim gu Jesuus maaꞌn maiꞌ ba jootos gu cham kɨɨꞌ iiꞌmdaꞌ bhaan dɨr maaꞌn gu maaꞌnkam na bhaan jup tuiꞌdhiꞌ. Cham tu ñiokdaꞌ dhiꞌ dhi maaꞌnkam, na guꞌ gu cham kɨɨꞌ iiꞌmdaꞌ pɨx na puiꞌ duukaꞌ. Baꞌ joidham bhaiꞌ ji chu ñiokcha gu maaꞌnkam nat paiꞌ ba buus gu cham kɨɨꞌ iiꞌmdaꞌ bhaan dɨr. Baꞌx bhaiꞌm ɨlh jamɨt jaiꞌ gu jaꞌtkam na mɨt puiꞌ tɨ tɨɨ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Jaiꞌ baꞌp kaiꞌch am: ―Ja gɇꞌkam tuk ji gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ na bhaan jup tuiꞌdhiꞌ dhiꞌ, puiꞌ nam baꞌx jɨɨgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Baꞌ jaiꞌp tɨtda am na sap xip duñiaꞌ gu tuꞌ nam cham paiꞌ dhuuk pu chuꞌm nɨiꞌñ, nam jax dhui miꞌ pɨx jix maiꞌchim noꞌ sap moo bɨxchuꞌx aichuꞌn na pu tu duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Guꞌ ji na guꞌx maat gu Jesuus nam jax jum aagɨt jup tɨtda, siax maat nam jax aiꞌchuxiꞌñ gu jaiꞌ. Baꞌp ja tɨtda bɨɨx: ―Gu jax chuꞌm gɇꞌkam noꞌ cham maaꞌn ñiꞌook jup duuk ja bui bɨɨx guiꞌ nam maap tu juandaꞌ, cham jɨꞌxkat tuꞌ jax dhuñiaꞌ am, nam guꞌ jaiꞌ maakam kaiꞌchdhaꞌ, gio jaiꞌ maakam ɨp. Mɨkkat miꞌ pɨx pu bhaakui mam koodaꞌ am dɨɨlh. ");
INSERT INTO stpNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Puꞌñip jum duñiaꞌ gu ja gɇꞌkam tuk gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ noꞌt jax dhuuk bhaiꞌ ji bhaam ja bui gu tujuandam tugiꞌñ, nam guꞌ cham maaꞌn ñiꞌook kap duukaꞌ. Jaꞌp jañ kaiꞌñkam jup kaiꞌch na ni jɨꞌx kur puiꞌ na pim jax jiñ aiꞌchuxiꞌñ jaiꞌ dhɨt. Jup kaiꞌch japim nañ aꞌm jup tuiꞌdhiꞌ gu ja gɇꞌkam tuk gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ nam baꞌ xiñ jɨɨgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Aapiꞌm baꞌ puiꞌ ja gɇꞌkam tuk gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm jup tuiꞌdhiꞌ aa guiꞌ nam jam kaichuꞌ nam baꞌx ja jɨɨgiꞌñ nam maiꞌ ja jootos ja aꞌm dɨr gu jaꞌtkam? ¿Jia na guꞌ cham? Pu dhiꞌ bhaan jix maatɨꞌ na cham jɨꞌx jir puiꞌ na pim jax jiñ aiꞌchuxiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Matgɨm aañ gu Dios ji nañ bhaankam ya oirɨt maiꞌ ja jootos gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ ja aꞌm dɨr gu jaꞌtkam. Gu Dios pɨx dɨɨlh jiñ aꞌm tɨ nɨidhim, puiꞌ kum baꞌ xiñ jɨɨgiꞌñ. Baꞌ dhiꞌ bhaan jup jix maatɨꞌ nat bam ai na pim paiꞌ dhuuk ampɨx machiaꞌ na pim jax jaꞌk duñiaꞌ na baꞌx joiꞌmdat jam aꞌm ba tɨ nɨidhidhaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Gu jaꞌook jaꞌpni jaꞌk jup ji buusan na jax maaꞌn gu maaꞌnkam jix oogɨm na mu paiꞌ tu biaꞌkaꞌ gu bɨxchugaꞌn jax chuꞌm baꞌk chɨr. Baꞌ miꞌ tu nuukaꞌndaꞌ ji dhaagɨt guiꞌ na kɨꞌn jum palhbuidhaꞌ noꞌ jaroiꞌ bax chɨ ɨɨxdham, sia ku guꞌp jix ooꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Guꞌ ji noꞌt guꞌx dhupiiꞌñ mu ai gu jumai maaꞌnkam nax ioꞌm jix ooꞌ kaꞌ, cham tuꞌ puiꞌ na guiꞌ, miꞌ dho daagɨi xi ɨɨxdhai gu tuꞌ na ka daaꞌnkaꞌ na gɨt kɨꞌn jum palhbuidhaꞌ, puiꞌ baꞌ xi gɨbiimɨi gammɨjɨ xi ardimiaꞌ. Gu bɨxchugaꞌn baꞌ bɨɨx bhaan ji chu biꞌyaꞌ na mɨjɨ ka tu biaꞌkaꞌ baꞌk chɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Na guꞌ gu jaroiꞌ noꞌ cham puiꞌp ɨlhiiꞌñ nañ aañ jax ɨlhiiꞌñdhaꞌ, dhiꞌ bhaan jix maatɨꞌ kaꞌ na xiñ bhaamkiꞌñdhaꞌ. Gio gu jaroiꞌ noꞌ cham jiñ palhbuiꞌñ nañ tu jumpaꞌndaꞌ, dhiꞌ bhaan jix maatɨꞌ kaꞌ ɨp na jaꞌkbuiꞌ kat tɨ jɨꞌdɨlhkaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Gu cham kɨɨꞌ iiꞌmdaꞌ noꞌt bhaan dɨr ba buus gu maaꞌnkam, ba jimiaꞌ mummɨ jaꞌp gampɨx jix chu gak kɨr na tu gaaꞌmɨraꞌ na paiꞌ kiichaꞌ. Baꞌ noꞌt cham paiꞌ tɨ tɨɨ nar joidham, jup jum aaꞌndaꞌ: “Gi noꞌ ñich giop jii bhammɨ nañ paiꞌ kiokat, na guꞌ cham paiꞌr joidham ya jaꞌp.” ");
INSERT INTO stpNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Baꞌ joidham tɨ tɨgiaꞌ na gio bhammɨp ba bakiaꞌ bhaan gu maaꞌnkam, jix chɨ kɨɨꞌ kaꞌ, joidham tu boxkix kaꞌ, na guꞌ puiꞌ ji buusandaꞌ noꞌx kɨɨꞌ gu maaꞌnkam. ");
INSERT INTO stpNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Baꞌ xi dhaiꞌññiaꞌ na ja baiꞌñmɨraꞌ jɨꞌk xijum gook pup gu bɨpnagaꞌn cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ, nam jix ioꞌm xi chu xi buadaꞌ, maap jam baꞌ bhaiꞌ ba baapkiaꞌ. Miꞌ dhɨr dho gi baꞌ guꞌx ioꞌm bam duñiaꞌ ji gu maaꞌnkam, cham tuꞌ puiꞌ na bɨɨpɨꞌ dɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Baꞌ na miꞌ puiꞌ ka tu aꞌga gu Jesuus, maaꞌn gu ubii mɨjɨ dɨr jaꞌp ja saagiꞌñ gu jaꞌtkam jup tɨtda gɇꞌ kɨꞌn: ―Moo gɨt joidham jix bhaiꞌ tu jimdaꞌ gum naan na pich bhaan dɨr maaxir, gio nat magoonɨk bam gɨꞌɨɨlh. ");
INSERT INTO stpNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Baꞌ gu Jesuus jup tɨtda: ―Jaꞌpji sia ji guiꞌ nam kɇɇji miꞌ puiꞌ ba jiimdaꞌ na jax jum kaiꞌchdhaꞌ gu ñioꞌkiꞌñ gu Dios na puiꞌ gammɨjɨx bhaiꞌp ba tu ja jimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Baꞌ giilhim muiꞌ pɨx jaꞌx ji aajim am gu jaꞌtkam miꞌ na paiꞌp tuꞌiiꞌ gu Jesuus, nammɨ jaꞌp ba xi juꞌ am. Baꞌp ja tɨtda: ―Jaiꞌ dhɨt gu jaaduñ nam yaꞌp tuꞌiiꞌ tɨix aaꞌ am nañ sap tuꞌ jax xi dhuñiaꞌ nam cham paiꞌ dhuuk pu chuꞌm nɨiꞌñ, guꞌ ji na guꞌ cham tuꞌ pu chuꞌm ja aꞌm jum aaꞌ, nam guꞌ giilhim jix uꞌuaꞌtulhdhix. Ku guꞌ aañ jir dhiꞌ pu chuꞌm kaꞌ ji nam jax chuꞌm jix aaꞌ nam tɨgiaꞌ, puiꞌñ jup jiñ dhuñiaꞌ nat jax jum duu bɨjɨk gu Jonaas. ");
INSERT INTO stpNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gu jaꞌtkam Niinibe oiꞌñkam bhaan dɨr maat jamɨt gu Jonaas na bax ja tulhiiñchudam gu Dios. Aañ baꞌ puꞌñi ɨp yaꞌ ja bui xib gu jaꞌtkam, aañ pɨx jiñ aꞌm dɨr machiaꞌ am na jax jaꞌk cham ja tulhiiñchudaꞌ gu Dios gatuuk jaꞌp na jax janoꞌ gu Jonaas. ");
INSERT INTO stpNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Janoꞌ na paiꞌ dhuuk jum aayaꞌ na guñ Gɨꞌkoraꞌ ja aagiꞌñdhaꞌ bɨɨx gu jaꞌtkam nam jɨꞌk tuꞌ jax buimɨi yaꞌ dhi oiꞌñgaꞌn, gu ubii guiꞌ na bɨjɨk jix ioꞌm jir gɇꞌkam kat miꞌ dhɨr jaꞌk jurnip, janoꞌ xi kɨkboi puiꞌ tɨꞌyaꞌ na pim cham tuꞌr kɨkɨɨꞌ jaꞌtkam, na pimɨt guꞌ cham miꞌ puiꞌ jii na maadɨt tɨi pu yaꞌ jam aaꞌñdhimɨk na pim paiꞌ oiꞌdhaꞌ na pim jax jaꞌk miꞌ puiꞌ jimiaꞌ. Guꞌ guiꞌ gu ubii mɨk dɨr jum dɨkooꞌñ nat bha jii nat bha kaim gu gɇꞌkam Salomoon na giilhim jix chu matdaꞌ kaꞌ. Ku guꞌ guiꞌ na maadɨt xib ya oirɨ, jix ioꞌm jix chu maat ji gio nax ioꞌm jir gɇꞌkam, cham tuꞌ puiꞌ na jax janoꞌ gu Salomoon. ");
INSERT INTO stpNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Sia gu jaꞌtkam Niinibe oiꞌñkam xi guꞌkɨi puiꞌp tɨꞌyaꞌ am janoꞌ na pim maaxik cham jir kɨkɨɨꞌ jaꞌtkam. Na guꞌ gu jaꞌtkam Niinibe oiꞌñkam moo janoꞌ pu soiꞌm ɨlh jamɨt buiñor gu Dios nat jax puiꞌ tu ja aꞌgi gu Jonaas na cham bhaiꞌ tu ja jim. Baꞌ guiꞌ na maadɨt xib ya oirɨ, jix ioꞌm bhaan tɨ nɨidhim gu Dios, cham tuꞌ puiꞌ na gu Jonaas. ");
INSERT INTO stpNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Aañ cham jɨꞌxkat jaroiꞌ paiꞌ nɨiꞌñ gu maaꞌnkam na xi mɨichdhai gu kañdhiir mɨjɨ jaꞌp xi kɨɨsaꞌ na paiꞌ cham tu maax kaꞌ, piam ku tuꞌ kɨꞌn xi chaaꞌbidhaꞌ. Guꞌ jaꞌpji bhammɨ jaꞌp na pu xi kɨɨsaꞌ tɇꞌkob na baꞌx chu maax kaꞌ nam mi jaꞌp oipodaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Dhich buupui puꞌñip ji buusan na jax gu kañdhiir na joidham gɇꞌ tu maaxiꞌñ kaꞌ tukaaꞌ noꞌ bɨꞌñdhix, nach guꞌ kɨꞌn tɨ nɨiꞌñ. Muiꞌ pɨx pux chum tukgam kaꞌ guꞌ noꞌ cham kɨkɨɨꞌ dhich buupui. ");
INSERT INTO stpNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Baꞌ aapiꞌm jix bhaiꞌ xim duukat na cham tutkiaꞌ dhi jam buupui. ");
INSERT INTO stpNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Na guꞌ noꞌ joidham jix kɨkɨɨꞌ, jix bhaiꞌ nɨiꞌñdhaꞌ pim gu jam tutkuꞌ na jax chuiꞌkaꞌ. Puiꞌ na jax gu kañdhiir noꞌx bhaiꞌ mɨim, na guꞌx bhaiꞌ tu maaxiꞌñ kaꞌ, pu cham paiꞌ maaꞌn kap pɨx am jix chɨ ɨɨkaꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Baꞌ nat paiꞌ tɨɨmo na tu aꞌga gu Jesuus, maaꞌn gu pariseo ba baidhak na tu koiꞌraꞌ kiaꞌmiꞌñ. Baꞌ gu Jesuus ma oi ɨp, jimdat miꞌ ji dhaibuk ba tɨ nɨɨr nam tu bhiidhaꞌ na paiꞌ tum kuaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Baꞌ gu pariseo cham jir juraaꞌn nat tɨɨ nat cham jum ikoim, na guꞌ panaas nax maat dɨɨlh, jum aaꞌ na xim ikoimdhai gu jaroiꞌ noꞌt ba ji chu juu. ");
INSERT INTO stpNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Baꞌ gu Jesuus na guꞌx maat na cham juraaꞌn daa gu pariseo, jup tɨtda: ―Jaꞌp moo tɨix uꞌuañ jum ɨlhiiꞌñ japim aapiꞌm na pim pariseos jum tɨɨtɨꞌ. Guꞌ dai daam dɨr na pim tɨi xi ja bopkon gu jam ja jooxiaꞌ gio jam bapaas, ɨrban dɨr jaꞌk guꞌ giilhim mi bhiꞌsap ji gu jam uaꞌtulhdharaꞌ, na pim tɨ ɨɨxiꞌñdhaꞌ gam bɨɨx aixim na pim tu buadaꞌ na tuꞌ cham jir kɨɨꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Cham jam jur biaꞌ pim dho jia ku pim baꞌ puiꞌ jaꞌk tu jim. ¿Jax jum aaꞌ pim aa na cham tɨ nɨiꞌñ gu Dios juraꞌram gu maaꞌnkam? Jax dhui nat guꞌ bɨɨx jup duu na jɨꞌx jir tuukuꞌ, sia ɨrban dɨr, sia daam dɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Baꞌ tuꞌ na jax chuiꞌkaꞌ yaꞌ dɨr jaꞌp jaꞌk, tuꞌ sɨlhkam japim jix ja joiꞌmdat ja palhbuiꞌñdhaꞌ gu jaꞌtkam guiꞌ nam cham tuꞌ biaꞌ ni jɨꞌx. Puꞌñi jaꞌk dho gi guꞌ ba oñiaꞌ ji sia ɨrban dɨr jaꞌk gu jam uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Tɨiñ jix buam jiñ aaꞌ jam aꞌmkam aapiꞌm na pim pariseos jum tɨɨtɨꞌ, na pim guꞌ cham bhaiꞌ ja bua gu jaꞌtkam guiꞌ nam bɨɨx aixim bhaan jum tulhiiñ. Aapiꞌm dai sap pɨk baꞌ gammɨjɨ mi tu aichdhidhaꞌ chiop na jɨꞌk bhaan jup bipioꞌ gu Dios gu tuꞌ na pim tɨ ɨs, guꞌ baꞌ gu jaꞌtkam cham ja nɨnɨiꞌñ japim sia kum mi jaꞌp soiꞌ tuꞌiiꞌ jam taagiob. Dhiꞌ ji baꞌ pɨk bɨɨpɨꞌm aaꞌ na pim jix ja joiꞌmdaix bhaiꞌ ja duñiaꞌ, gatuuk japim baꞌ puiꞌp ba duñiaꞌ gu tuꞌ nam aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Gio baꞌ na pim gɇꞌgɇrkam jum taat kaꞌ, bɨɨpɨꞌ dɨr japim jix dharaibuktuꞌndaꞌ na paiꞌ tum daandaꞌ, ni jɨꞌx ku pim iam gatuuk dɨr xix dharaibuktuꞌndaꞌ. Gam na pim jix aaꞌndaꞌ nam bɨɨx gu jaꞌtkam tuꞌ kaꞌm jam nɨidhat jam ñioꞌkdhidhaꞌ mu jaꞌp na pim jax jiimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Jaꞌp pɨx ji buan japim na jax gu maaꞌnkam noꞌ bɨjɨk dɨr miꞌ paiꞌ ba yaasap na cham ka tu maatɨꞌ kaꞌ, siam chi daam dɨr mi oipo gu jaꞌtkam. Pu ni kum jix mat kaꞌ noꞌ tuꞌ maaꞌnkam bɨtaꞌn jup dɨbaalhchɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Baꞌ maadɨt guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios miꞌ dhɨr jaꞌp jup kaiꞌch: ―Jiñ jaduuñ, aach bɨɨx jup jich iaꞌñ puiꞌ na pich jax tɨi, panaas jap sia aach jich aagɨt jup kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Baꞌ gu Jesuus jup tɨtda: ―Sia dho tɨix buam jiñ aaꞌ iñ jam aꞌmkam aapiꞌm na pim sap pɨk baꞌx maat gu ñioꞌkiꞌñ gu Dios. Jaꞌp ji buusan guꞌ na pim tu ja bhiiñolhdhatuꞌ gu jaꞌtkam na pim dai guiꞌ ja chiandaꞌ nam miꞌ puiꞌ jiimdaꞌ na jax jum kaiꞌch gu ñioꞌkiꞌñ gu Dios, gam na pim jax ɨlhiiꞌñ dɨɨlh. Aapiꞌm dɨɨlh guꞌ pu cham miꞌ puiꞌ jiim. ");
INSERT INTO stpNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Gio na pim jix bhaiꞌ xi chu buadaꞌ nam paiꞌ yassap gu bɨjɨk dɨr kam guiꞌ nam ya jaꞌp tu aꞌgimɨk bhaankam gu Dios, guꞌ gu jam bopxi kat na mɨt ja koodak miꞌ ja yaas nam jix bhaamut ja kɇɇkɇꞌ nam tɨi tu ja aꞌgiꞌñdhaꞌ na jax jir miꞌ puiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Baꞌ dhiꞌ bhaan jix maatɨꞌ na pim jix bhaiꞌm taatɨt am jix bhaiꞌ tu bua miꞌ na mɨt paiꞌ ja yaas. ");
INSERT INTO stpNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Puiꞌ pu tɨi ji guꞌ guñ Gɨꞌkoraꞌ na giilhim jix chu maat nam sap cham ja kɨɨgalhdhaꞌ guiꞌ nam puꞌñi bhaankamuꞌn ya jaꞌp tu aꞌga, jaiꞌ ja koodaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Baꞌ aapiꞌm pɨk jix ioꞌm jam oꞌbhaiꞌñdhaꞌ gu Dios na pim xib ya oipo na mɨt ba ja koi gu jam bopxi kat guiꞌ nam bɨjɨk bhaankamuꞌn ya jaꞌp tu aꞌgimɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nammɨ dɨr bhaiꞌ ji jam kusbidhaꞌ bhaan gu Abel na mɨt bɨɨpɨꞌ mua, yaꞌ juugɨt na paiꞌ gu Sakariiyas, guiꞌ na mɨt mi ɨrban mua na paiꞌ kɨɨk guiꞌ na bhaan tum makgɨrxiꞌñ gu Dios, gio gu baꞌaak nam paiꞌ dhɨr tu daan guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam. Jam aagiꞌñ iñ moo na aapiꞌm jaiꞌp jam oꞌbhagiꞌñ gu Dios na mɨt tu koi gu jam bopxi kat janoꞌ dɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Gio guꞌ aapiꞌm na pim sap pɨk baꞌx maat gu ñioꞌkiꞌñ gu Dios, jaꞌp ji buusan na pim aapiꞌm uaꞌ guiꞌ na kɨꞌn jum kukpioꞌk miꞌ paiꞌ na tum mamtɨ na jax jaꞌk jir am na pim miꞌ puiꞌ jiimdaꞌ na jax jix aaꞌ gu Dios, guꞌ ji na pim guꞌ cham ja kukpioꞌkiꞌñ gu jaꞌtkam, ni aapiꞌm dɨɨlh ku pim mi baapak. ");
INSERT INTO stpNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Baꞌ giilhim bhaiꞌ ji bhaak jamɨt gu pariseos gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios na puiꞌ ja tɨtda gu Jesuus. Bɨɨx aixim bhaiꞌ ba tɨkka am maap jim daagɨk ");
INSERT INTO stpNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","nam miꞌ pɨx mamaiꞌchɨk noꞌ sap moo puiꞌp ɨlhiiꞌñ nam jax ɨlhiiꞌñ dɨɨlh gu tuꞌ, piam ku guꞌ sap cham, dai nam ba ja aagiꞌñdhaꞌ gu ja gɇꞌgɇrkam tuk. ");
INSERT INTO stpNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Baꞌ giilhim muiꞌ miꞌ mam jumaap jamɨt gu jaꞌtkam na paiꞌp tuꞌiiꞌ gu Jesuus, nammɨ jaꞌp xi juꞌ am. Giox kabkam kiꞌsap am jaiꞌ mɨjɨ jaꞌp, nam guꞌx kobkom mi guguuk. Baꞌ bɨɨpɨꞌ muiꞌ ji chu ja aꞌgi guiꞌ nam kaichuꞌ, jup ja tɨtda: ―Moo pim cham miaꞌn ja aꞌjɨdaꞌ guiꞌ nam pariseos jum tɨɨtɨꞌ. Giilhim jix kaidhaꞌ guꞌ gu ja ñiꞌook, jaꞌp jir tuꞌm am na jax guiꞌ na kɨꞌn jappukar gu paan, pu cham miꞌ puiꞌ jiim am dɨɨlh nam jax ja aagiꞌñdhaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ku guꞌ kam aajim ji na paiꞌ dhuuk matgilhiaꞌ nam jax jir tuꞌm, sia kum guꞌ xib dɨɨlh pɨx puiꞌx chu maat. Na guꞌ cham jɨꞌxkat jum ɨxchuꞌ gu tuꞌ sia ku tɨi ɨxchuix panaas, ni ku cham jɨꞌxkat na moo cham jup matgilhiaꞌ sia ku tɨi cham tu aaꞌ gu jaroiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Baꞌ aapiꞌm puꞌñi ɨp noꞌ pimɨt tɨix ɨxchuixim mu paiꞌ tu aꞌga gu tuꞌ, maaꞌn na jax matgilhiaꞌ gatuuk. Sia pimɨt chi moo tɨix kabkam xim kuupak mu paiꞌ jax chuꞌm baꞌk chɨr, naiꞌ pɨx jaꞌx chum jiiñakdaꞌ na puiꞌ tum kaiꞌchdhaꞌ gatuuk. ");
INSERT INTO stpNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Baꞌ jaꞌp jañ jup xi jam tɨɨdam jiñ jaaduñ na pim cham ja ɨɨbhiꞌñdhaꞌ gu jaꞌtkam guiꞌ nam jir tu kooꞌn kam, chaꞌpim totdon kaꞌ sia kum xi jam koodak. Na guꞌ noꞌ mɨt moop ma jam koi, dai gu jam tutkuꞌ nam ja koodaꞌ, gu jam iꞌiiꞌmdaꞌ pu cham nam jax dhoodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Gu Dios ji na pim jix ɨɨbhidhat oipodaꞌ, na guꞌ guiꞌx bhaaiꞌ na xi jam koodai mu jaꞌk xi chu chiñiaꞌ nam ja iabuꞌ gu jam iꞌiiꞌmdaꞌ nam paiꞌ gammɨjɨ miꞌ pup jum tulhiiñdhaꞌ noꞌ pim cham tuꞌ kaꞌm nɨiꞌñ. Tuꞌ kaꞌm japim moo nɨidhat, aañ moo yaꞌ pu jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Cham daꞌram namɨɨk am dho gux bii uꞌjiꞌ nam mu jaꞌp jum gaꞌra, jix chamaam aix am gu gook tumñix chaꞌm. Guꞌ ji na guꞌ gu Dios jix dhaꞌram ja ɨlhiiꞌñ sia kum cham tuꞌ bhaigɨm tuꞌm panaas. ");
INSERT INTO stpNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aapiꞌm gi baꞌ na pim jir jaꞌtkam jam jur biaꞌ kam, ¿jaꞌp jum aaꞌ pim aa na cham daꞌram jam ɨlhiiꞌñ gu Dios? Matgɨm giilhim ji nax dhaꞌram jam ɨlhiiꞌñ, sia jam kuup jix bhaiꞌ jaꞌkɨlhdhix kam biaꞌ na jɨꞌk bha tuut jam moom am. Baꞌ chaꞌpim jax jum aaꞌndaꞌ, na guꞌx ioꞌm jix dhaꞌram jam ɨlhiiꞌñ gu Dios, cham tuꞌ puiꞌ na gu uꞌjiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Noꞌm ba jam tɨkka gu jaꞌtkam noꞌ pim jiñ kaichuꞌ, xi ja aagiꞌñdhaꞌ pim na pim jiñ kaichuꞌ, aañ baꞌp ja aagiꞌñdhaꞌ gu noonbiꞌñ guñ Gɨꞌkoraꞌ na pim sɨlhkam jiñ kaichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Noꞌ pim cham ja aagiꞌñ, aañ puiꞌ pɨx jup ja tɨɨdaꞌ gu noonbiꞌñ guñ Gɨꞌkoraꞌ na pim pu cham tuꞌ sɨlhkam jiñ kaichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Baꞌ noꞌt jaroiꞌ giilhim jiñ chɨɨꞌn aañ nañ bhaankam ya oirɨ gu Dios, jum uaꞌtulhdhaꞌ, dai pɨx ji na guꞌ giop tu uañdhaꞌ gu Dios noꞌt soiꞌm ɨlhdhak pu tɨi na cham puiꞌ ka kaiꞌchdhaꞌ. Guꞌ cham jɨꞌxkat tu uañdhaꞌ ji kiaꞌ noꞌt gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ giilhim tɨɨꞌn na jax cham jir am, na guꞌ dhiꞌ buiñor jix ioꞌm jir uaꞌtulhdharaꞌ noꞌ jaroiꞌ jaaxmam kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Noꞌ mɨt paiꞌ dhuuk jam daꞌngɨk mu jaꞌp paiꞌ ba jam tuttuim chichiop piam mu jaꞌp paiꞌx kakaiꞌ ja bui, chaꞌpim jax jum aaꞌndaꞌ sia ku panaas cham bhaaiꞌ na pim jax ba ji chɨꞌyaꞌ ja bui. ");
INSERT INTO stpNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Jax dhui na guꞌ dɨɨlh pɨx bhaiꞌ ji bhaigiaꞌ na pim jax tɨꞌyaꞌ noꞌ pim bhaan bap tuiꞌdhiꞌ, na guꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ jam makiaꞌ gu matdaꞌ na jam aꞌm tajaañixchuꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Maadɨt baꞌ mɨjɨ dɨr jaꞌp ja saagiꞌñ gu jaꞌtkam jup tɨtda gu Jesuus: ―Jiñ jaduuñ, miꞌ dhɨr jap iam jaꞌp jiñ chɨɨꞌñxidhaꞌ guñ xiix na tuñ makiaꞌ na jɨꞌk jiñ aꞌm jup tuñ bipioꞌ gu bɨxchugaꞌn guñ chaat kat. Ni jɨꞌx ku xi chuñ maakim. ");
INSERT INTO stpNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Baꞌ gu Jesuus jup tɨtda: ―Jax dhui nañ aañ cham tuꞌ gɇꞌkam kɨꞌn daaxix nañ mu paiꞌ ja maakdaꞌ gu jaꞌtkam na jɨꞌk ja aꞌm tu bipioꞌ gu tuꞌ. ¿Kaꞌ paa pimɨt duuk pu chuꞌm kɨꞌn gɇꞌkam jiñ dhai kup baꞌx maat na pu chuꞌm jir jiñ aꞌmkam? ");
INSERT INTO stpNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Baꞌp ja tɨtda bɨɨx gu jaꞌtkam nam jɨꞌk miꞌp tuꞌiiꞌ: ―Chaꞌpim dai bɨxchuꞌx chu aaꞌndaꞌ na pim gɨt xi chu biaꞌkaꞌ, na guꞌ cham tuꞌ gu bɨɨx aixim na tu biaꞌkaꞌ gu jaroiꞌ na baꞌx bhaiꞌ tu jimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Baꞌ xi ja aaꞌñ bhaan ji uaꞌrgidhak maaꞌn gu maaꞌnkam jix chumñigam nat jax tu jii, jup ja tɨtda: ―Maaꞌnnim maaꞌn gu maaꞌnkam giilhim gɇꞌ ma ɨi gu tiriik. Giilhim jir jix chumñigam kaꞌ guꞌ, gɇꞌgɇr ja biaꞌkaꞌ gu dɨppɨr. Baꞌ nammɨ ji kɨi nat paiꞌ dhuuk tɨ bhɨi gu tiriik. ");
INSERT INTO stpNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Baꞌ cham gɇꞌgɇr jup tu baꞌbhak kaꞌ, ɨꞌlhich miꞌ ja tuttu kaꞌ. Baꞌp jum aaꞌ juraꞌram bhaan: “¿Paañ baꞌ jaꞌk ulhñaꞌ dhi jaiꞌ tiriik na biꞌyaꞌ sia ku ñich jaiꞌ mi ulh dhi ɨꞌlhich baꞌpki chɨr, na guꞌ cham bɨɨx mi aix?” ");
INSERT INTO stpNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Baꞌ jaꞌxpɨx jup jum aaꞌ ɨp gio: “Jaꞌpji nañ ja iaꞌrsai dhi ɨꞌlhich baꞌbhak gɇꞌgɇr miꞌ ja tuttuꞌ na baꞌ maaꞌn jimdam bɨɨx mi aayaꞌ. Guñ bɨxchuꞌñ bhaiꞌ dhɨr jaꞌp gai dhɨr jup xi chu ulhñaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Miꞌ dhɨr baꞌ dai nañ bañ jɨɨpiꞌñkaꞌ, tu kuaꞌdaꞌ iñ jix bhaiꞌñ chaatɨt gio nañ jix maim kaꞌ. Muiꞌ oidhaꞌ mi bɨɨtkaꞌ guꞌ dhi tiriik.” ");
INSERT INTO stpNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Baꞌ na miꞌ puiꞌ kam aaꞌ gu maaꞌnkam, jup tɨtda gu Dios: “Joidham tɨi tɨ ɨlhiiꞌñ ap jia. ¿Jaroo baꞌ bhaan ji chu biꞌyaꞌ dhiꞌ nap tuꞌ bhaan tu aꞌga? Nap guꞌ aap jaꞌxñi tukaaꞌ cham tuꞌ ka duakaꞌ. Cham jum jur biaꞌ ap kup baꞌp kaiꞌch.” ");
INSERT INTO stpNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Puꞌñi pɨx jaꞌk baꞌ tu jimiaꞌ gu jaroiꞌ sia kut tɨi joidham tɨ ɨlhdhak nammɨ ji chɨ kɨi gux dhaꞌram tu namkɨm yaꞌ kam dhi oiꞌñgaꞌn, pɨx ji noꞌ cham jir jix chumñigam ɨp buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Baꞌ mɨkkat gu Jesuus jup ja tɨtda dai guiꞌ nam kaichuꞌ: ―Noꞌ pim paiꞌ dhuuk cham jɨꞌx ka biaꞌ gu koiꞌ piam tuꞌ jannulh na pim tɨꞌyaꞌ, chaꞌpim jax jum aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Na guꞌ cham tuꞌ pɨk jum aaꞌ gu koiꞌ ni gu jannulh, guꞌ guiꞌ ji jam iꞌiiꞌmdaꞌ gio dhi jam tutkuꞌ nax ioꞌm jum aaꞌ, dhiꞌ pɨk japim gaaꞌñchuꞌndaꞌ na jax jaꞌk jix bhaiꞌ tu ja jimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gio guꞌ ja nɨiꞌñ japim gu kokkon. Cham paiꞌ mu paiꞌ or am gu tuꞌ nam kuaꞌ, nam guꞌ pu cham tɨ ɨs. Ni kum paiꞌ tum bipiꞌñ jax chuꞌm baꞌk chɨr, jax dhui nam guꞌ pu cham tu baꞌbhak. Guꞌ ji na guꞌ gu Dios tu ja maak nax joiꞌmdat ja nɨiꞌñ. Dho jaiñ, ¿aapiꞌm baꞌ cham jix ioꞌm jup xi jam joiꞌmdat jix bhaiꞌp jam duñiaꞌ aa gu Dios na pim jir jaꞌtkam? ");
INSERT INTO stpNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Gio guꞌ cham jɨꞌxkat jaꞌkbuiꞌ oidhaꞌ aichdhaꞌ na duakaꞌ gu jaroiꞌ na jɨꞌk tɨi xi ɨlhiiꞌñdhaꞌ, na guꞌ cham jaroiꞌ dɨɨlh jup bua gu iiꞌmdaꞌ, siat chi moo tɨi bɨɨx juraaꞌn kɨꞌn puiꞌm aa na jaꞌkbuiꞌ oidhaꞌ aichdhaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Baꞌ dhiꞌ puꞌñi ɨp, cham jir am na pim jaꞌp pɨx jix chu aaꞌndaꞌ gu tuꞌ na cham jum aaꞌ, na guꞌ cham jɨꞌxkat jaroiꞌ alhiꞌch pup jup duñiaꞌ gu iiꞌmdaꞌ na baꞌ jaꞌx pup xi dhuakaꞌ, sia kut bam ai na paiꞌ dhuuk mukiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ja nɨiꞌñ japim ɨp gu yooxiꞌ nam naiꞌ yoot bɨɨx aixim tuꞌm jix aꞌbhar. Cham tuꞌ dɨɨlh jup tu bua am gu tuꞌ nam kɨꞌn jum aꞌbhartuꞌn, ni kut iam pu chuꞌm jix aꞌbhar tɨm tɨiꞌdhak gu Salomoon guiꞌ nax ioꞌm jir gɇꞌkam kat bɨjɨk, sia ku tɨi joidham jix bhaiꞌ xim duukaꞌ. Gu yooxiꞌ guꞌ gu Dios na pu chuꞌm tu ja tɨꞌiiꞌñkaꞌ, cham tuꞌ dɨɨlh. ");
INSERT INTO stpNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Baꞌ noꞌ gu yooxiꞌ puiꞌx aꞌbhar tu ja tɨꞌiiꞌñ gu Dios sia kur gampɨx kam gio na buimgidhak bax gak kaꞌ, ¿gu Dios aa baꞌ cham jix aꞌbhar jup tu jam tɨiꞌdhaꞌ na xi jam joiꞌgɨꞌn na pim jir jaꞌtkam dudua kam jum jur biaꞌ kam? Tu jam tɨiꞌdhaꞌ ji matgɨm, dai ji na pim bɨɨx jam jujur kɨꞌn buiñor tɨ jɨɨgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Baꞌ chaꞌpim jax jum aaꞌndaꞌ sia ku pim cham ka biaꞌ gu tuꞌ na pim jugiaꞌ, ni gu tuꞌ na pim iꞌyaꞌ noꞌt ma gaa gu suudaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Puiꞌm dho tuꞌiiꞌ ji guiꞌ nam chakui maat gu Dios, bɨɨx dhiꞌ pu chuꞌm jam bhaan jix buam jum aaꞌ. Guꞌ matgɨm aapiꞌm bax maat ji na jaroiꞌr jam Gɨꞌkoraꞌ, gu Dios dho. Gio guꞌ guiꞌx mat kaꞌ na tuꞌ jam aꞌm jum aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Aapiꞌm dai ji na pim miꞌ puiꞌ xi dhuiñchuꞌndaꞌ na jax jix aaꞌ na baꞌx joiꞌmdat jam aꞌm tɨ nɨidhidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Chaꞌpim tuꞌ bhaan totdon kaꞌ aapiꞌm na pim jaꞌp ji buan na pim jir jiñ kakasniraꞌ, na guꞌ sia ku pim jir gook alh, guñ Gɨꞌkoraꞌ xi jam joiꞌmdat jam aꞌm tɨ nɨidhim. ");
INSERT INTO stpNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chaꞌpim jax jim aagɨt xi ja maakat gu tuumiñ gu jaꞌtkam guiꞌ nam cham tuꞌ biaꞌ ni jɨꞌx. Xi chu gaꞌrat japim gu tuꞌ na pim biaꞌ na pim baꞌ miꞌ dhɨr ja maakdaꞌ. Na guꞌ noꞌ pim puꞌñi jaꞌk duiñchuꞌ, aapiꞌm jum tutumñigamtaidhaꞌ jix dhaam jaꞌk buiñor gu Dios na paiꞌ gux ɨxkum cham jɨꞌxkat aayaꞌ, ni gu tuꞌ na tɨ dɨꞌnbalhchuꞌn ku cham jɨꞌxkat aayaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Na guꞌ gu jaroiꞌ mu paiꞌ noꞌ biaꞌ gu tuumiñ, dai mummɨ tɨtɨɨꞌñchokaꞌ. Baꞌ puꞌñi aapiꞌm noꞌ pimɨt bam tutumñigamtax dhaam buiñor gu Dios, dai bhammɨ jaꞌk japim ba tɨtɨɨꞌñchokaꞌ. Dhiꞌ puꞌñi jaꞌk jum aaꞌ na pim duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Gammɨjɨ pim gaaꞌñchuꞌndaꞌ na pim jax jaꞌk miꞌ puiꞌ jiimdaꞌ na jax jix aaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jaꞌp japim tuiꞌkaꞌ na jax gu tujuandam noꞌt gu gɇꞌkam xi ja chianɨk nam miꞌ darkaꞌ kiaꞌmiꞌñ nam kupioꞌkdhaꞌ na paiꞌ dhuuk mi aayaꞌ na jax maaꞌnnim bha tu soosniaꞌ na xim tɨɨmorai mu paiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Jaꞌp moo joidham jix bhaiꞌ tu ja jimiaꞌ gu tujuandam noꞌm tɨ nɨiꞌñ na paiꞌ dhuuk mi aayaꞌ gu ja gɇꞌkam tuk, siat ɨraab tukaaꞌ mi ai, piam katukgab, piam jix dhaꞌnpam ji chu maaxirɨk. Aañ yaꞌ pu jam tɨtda nax bhaiꞌm ɨlhdhai gu ja gɇꞌkam tuk xi ja chiñiaꞌ nam daraibuꞌ na baꞌ tu ja bhiidhaꞌ nam tu jugiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Gio guꞌ jaꞌpnip tu tuꞌiiꞌ, pu cham mat kaꞌ am gu tujuandam na paiꞌ dhuuk mi aayaꞌ gu ja gɇꞌkam tuk, jaꞌp na jax gu jaroiꞌ na guꞌ pu cham mat kaꞌ na paiꞌ dhuuk mi ɇɇji tɨ ɨɨxdhaꞌ gux ɨxkum kiaꞌmiꞌñ, joidham noꞌ guꞌ pu bɨɨpɨꞌ dɨr bax mat kaꞌ gɨt na baꞌ miꞌ pɨx ba tu nuukaꞌndaꞌ nam cham tɨ ɨɨxdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Baꞌ aapiꞌm puꞌñi, jix bhaiꞌ pim jum duukaꞌ, miꞌ pim puiꞌ xi jiimɨt na jax jix aaꞌ guñ Gɨꞌkoraꞌ, na guꞌ cham maatɨꞌ nañ paiꞌ dhuuk gio bhaiꞌp jim yaꞌ dhi oiꞌñgaꞌn nañ jam baidhikaꞌ. Cham jum ɨlhdham pɨx ya aayaꞌ iñ guꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Baꞌ gu Peegro bhaiꞌ ba tɨkka, jup tɨtda: ―Jiñ jaduuñ, ¿dai aa nach jɨꞌk bam kaichuꞌ nap jup jich chɨtdat jup kaiꞌch dhiꞌ na pich tuꞌ bhaan tu aꞌga? ¿Kaꞌ bɨɨx aa dhi jaiꞌ nam yaꞌp tuꞌiiꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Baꞌ gu Jesuus jup tɨtda: ―Dho puiꞌ na maaꞌn gu gɇꞌkam ɨp noꞌt mɨk jaꞌk bhɨi na miꞌ xi dhoꞌñchoi maaꞌn gu tujuandam kiaꞌmiꞌñ, na miꞌ ka tu ja maakdaꞌ gu maamraꞌn ganaiꞌ jajaaꞌnniꞌñ na paiꞌ dhuuk jum aajidhaꞌ nam tu kuaꞌdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jaꞌp moo joidham jix bhaiꞌ tu jimiaꞌ gu tujuandam noꞌt miꞌ puiꞌ duu na jax chiñiaꞌ gu gɇꞌkam tugiꞌñ, ");
INSERT INTO stpNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","na guꞌ gu gɇꞌkam joidham jix bhaiꞌm ɨlhdhai daasaꞌ na tɨ nɨiꞌñxiꞌñkaꞌ bɨɨx na jɨꞌk tuꞌ tu biaꞌkaꞌ, tuꞌ sɨlhkam jañ moo yaꞌ pu jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Guꞌ ji noꞌt guꞌ gu tujuandam jax jim aa nat paiꞌ dhuuk jii gu gɇꞌkam tugiꞌñ: “Kapbhaiꞌ nat mɨk ka jii gu gɇꞌkam, aañ yaꞌ xi chu koiꞌmɨi nañ jɨꞌx ɨlhiiꞌñ, xi maimukimɨi iñ, xi ja gɨbichpagai iñ dhi oiꞌñkam gio dhiñ bɨɨm tuutuꞌm tujuandam nam ya oipo, gammɨjɨ bɨɨx aixim nañ jax ɨlhiiꞌñ jañ puiꞌ xi chu buimɨi.” Baꞌ puiꞌp ji chu duu gammɨjɨ bɨɨx aixim nat jax ɨlh. ");
INSERT INTO stpNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na paiꞌ dhuuk miꞌ pɨx ba kɨɨkaꞌ gu gɇꞌkam tugiꞌñ na cham pum aaꞌndaꞌ, giilhim dhox ioꞌm tulhiiñchudaꞌ bhaamui, jaꞌxbuiꞌ puiꞌp tulhiiñchudaꞌ na jax guiꞌ nam cham jɨꞌx tuꞌ kaꞌm tɨ nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Na guꞌ gu jax chuꞌm tujuandam noꞌt tɨi xi aaꞌñdhak gu gɇꞌkam tugiꞌñ na tuꞌ cham jir am na pu buadaꞌ, guꞌ ji noꞌt guꞌ tuꞌ pɨx ɨlhdhak pu dhuu, na paiꞌ dhuuk mi ɇɇji gu gɇꞌkam tugiꞌñ giilhim gɨbiimɨi chipliiñ kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Baꞌ gu tujuandam noꞌt pu cham aaꞌñdhak gu gɇꞌkam tugiꞌñ na tuꞌ cham jir am na pu buadaꞌ, cham tuꞌ muiꞌ gɨɨꞌbiaꞌ sia kut pu dhuu gu tuꞌ na cham jir am, na guꞌ pu cham mat kaꞌ. Gio gu jaroiꞌ noꞌ mɨt bɨɨx aixim chia gu tuꞌ na jax dhuñiaꞌ, bɨɨx jum aaꞌ na tu aaꞌndaꞌ noꞌt jix bhaiꞌ mi pu tu duu. Guꞌ baꞌ gu jaroiꞌ nam jɨꞌk pɨx tu chiñiaꞌ ɨp, dai jaꞌkbuiꞌ aaꞌndaꞌ ɨp na bhaan tu aaꞌndaꞌ noꞌt jix bhaiꞌ miꞌ puiꞌp duu. ");
INSERT INTO stpNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Aañ na ñich bha jii yaꞌ dhi oiꞌñgaꞌn, jaꞌp ji buus na ñich bha tu kuusdam, tɨiñ bax aaꞌ na gɨt ba tɨ mɨɨjidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Guꞌ ji na guꞌ bɨɨpɨꞌm aaꞌ nañ jiñ chulhiiñaꞌ na baꞌ puiꞌ ba tum duñiaꞌ. Tɨix buam tu tatdaꞌ ɨp baꞌ nañ tɨ nɨɨra nañ jiñ chulhiiñaꞌ, aaꞌndaꞌ gɨt nañ miꞌ dhɨr ba buusniaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Cham tuꞌ ñich pu kaiꞌñkam bha jii nañ puiꞌ ja duñiaꞌ gu jaꞌtkam nam jix ioꞌm jix bhaiꞌ ba kaiꞌchdhaꞌ, guꞌ jaꞌpji nam jix ioꞌm ba xim bhabhaakuiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Na guꞌ puiꞌ na jax noꞌm jix chamaam maap miꞌ paiꞌ ka tu oiꞌdhaꞌ gu jaꞌtkam, noꞌm guꞌ gook ba tɨ jɨɨgiꞌñ jiñ bui, gu baik nam cham tɨ jɨɨgiꞌñdhaꞌ bhaiꞌ ji bhaakuꞌ am ja bui gu gook. Piam kum guꞌ gu baik tɨ jɨɨgiꞌñ jiñ bui, bhaiꞌ ji bhaakuꞌ am ɨp gu gook nam cham jiñ bui tɨ jɨɨgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Piam gu ja maamar bax bhaak kaꞌ am ja bui gu ja tataat gio gu ja nanaan, piam ku guꞌ mu dɨr bha jaꞌk bhaiꞌ bax ja bhaamkiꞌñdhaꞌ am gu ja maamar. Piam gu ja bhaꞌbhar aꞌooꞌ, piam gu ja kakaꞌmdaꞌ, jax ña pɨx jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Miꞌ dhɨr baꞌp ja tɨtda gu Jesuus bɨɨx gu jaꞌtkam nam jɨꞌk miꞌp tuꞌiiꞌ: ―Na pim paiꞌ dhuuk nɨiꞌñdhaꞌ gu tɨbaaꞌ na bhaiꞌ ba tɨɨsdiaꞌ jurnip dɨr, bax mat kaꞌ pim na bax kibaarum kaꞌ, baꞌ puiꞌp ji chu buusniaꞌ na pim jax ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Gio noꞌt jix juuk ba jɨb, bax mat kaꞌ pim ɨp nax chatoiñdhim kaꞌ, baꞌ puiꞌp ji chu buusniaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¿Guꞌ jax baꞌr jum duukam ku pim baꞌ cham maatɨt nɨiꞌñ maadɨt guiꞌ na ya oirɨ jam bɨɨm na paiꞌ dhɨr jaꞌk jim gio na jax kaiꞌñkam ya oirɨ? ¿Kux cham bhaaiꞌ aa na pim puꞌñip jix mat kaꞌ gɨt? Puiꞌ pɨx kaiꞌchdhaꞌ pim dho bak. ");
INSERT INTO stpNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Dɨɨlh japim miꞌ puiꞌ xi jimɨi na jax jix aaꞌ gu Dios, dɨɨlh japim xim gaꞌngidhat na tuꞌr jix kɨɨꞌ gio na tuꞌ cham jir kɨɨꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Na guꞌ dhiꞌ jaꞌpni pɨx tu tuꞌiiꞌ na jax yaꞌ dhi oiꞌñgaꞌn bhaan noꞌ jaroiꞌ muiꞌ tu uaꞌtuꞌn, na buuprai ba bhɨikaꞌ gu uaꞌtdam tugiꞌñ na ba kuupmɨraꞌ noꞌ cham namkiꞌñ. Guꞌ ji noꞌt guꞌ bɨɨpɨꞌ dɨr puiꞌ ba tɨɨꞌn gu uaꞌtdam tugiꞌñ na namkidhaꞌ, nam chakui aayaꞌ na paiꞌ daakaꞌ gu gɇꞌkam, miꞌ dhɨr dho pu jaꞌk suulhgiaꞌ am nam jix bhaiꞌ maaꞌn ñiꞌook xip dui, baꞌ cham tuꞌ mu ka aayaꞌ am na paiꞌ daakaꞌ gu gɇꞌkam. Na guꞌ buiñor gu gɇꞌkam dai nam xi aaꞌñdhaꞌ nam jax kaiꞌñkam uaꞌtulhiꞌñ, pu mɨjɨ jaꞌp xi kuupaꞌ, cham tuꞌ na jax jup ka kaiꞌchdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cham dho jɨꞌxdhaꞌ buusniaꞌ miꞌ dhɨr noꞌt cham tu namki nam jɨꞌk bha taandaꞌ, aañ moo yaꞌ pu jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Baꞌ jɨꞌkchi gu jaꞌtkam miꞌp ba aaꞌñdhim am gu Jesuus, nat sap gu Pilaato tu chia bhaiꞌ Jerusaleen nam ja koodaꞌ jɨꞌkchi gu jaꞌtkam Galilea kam, nam bhaiꞌ oipot gɇꞌ chiop ka tu makgɨrxiꞌñ gu Dios. Sap baꞌ gu ja ɨꞌɨɨr kɨꞌn tum jupsusa bɨɨx xikoolh bhaiꞌ na paiꞌ tum makgɨrxiꞌñ gu Dios, na paiꞌ gu sasoiꞌ gu ja ɨꞌɨɨr kɨꞌn jup tum jupsus. ");
INSERT INTO stpNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Baꞌ gu Jesuus jup ja tɨtda: ―¿Guꞌ baꞌ aapiꞌm jaꞌp jum aaꞌ aa nam dai guiꞌx ioꞌm jix uꞌuaꞌtulhdhix kat na mɨt ba ja koi, guꞌ baꞌ panaas cham pɨk gu jaiꞌ nam puiꞌ mup oiꞌdhaꞌ Galilea? ");
INSERT INTO stpNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Matgɨm bɨɨx ji nam puiꞌx ioꞌm jup jix uꞌuaꞌtulhdhix, puiꞌp ja tulhiiñchudaꞌ gu Dios noꞌ mɨt cham soiꞌm ɨlh buiñor, sia aapiꞌm noꞌ pimɨt cham soiꞌm ɨlh. ");
INSERT INTO stpNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Gio janoꞌ na mɨt mambhɨɨx daman xijum baik gu jaꞌtkam koi, nat ja tɨim gu tɇb bhiꞌñbak nat ia bhaiꞌ Siloe, ¿jaꞌp jum aaꞌ pim aa nam dai guiꞌx ioꞌm jup jix uꞌuaꞌtulhdhix kat kut baꞌp tu ja dooda, guiꞌ baꞌ panaas cham pɨk uꞌuaꞌtulhdhix am nam bhaiꞌp oiꞌdhaꞌ Jerusaleen? ");
INSERT INTO stpNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bɨɨx ji nam puiꞌx ioꞌm jup jix uꞌuaꞌtulhdhix, sia puiꞌp ja tulhiiñchudaꞌ gu Dios noꞌ mɨt cham soiꞌm ɨlh buiñor, sia dho aapiꞌm nañ jax ba kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Baꞌ bhaan ji uaꞌrgidhak gu Jesuus maaꞌn gu iigɨx, jup ja tɨtda: ―Maaꞌnnim maaꞌn gu maaꞌnkam tɨi ɨꞌɨɨx kaꞌ maaꞌn gu iigɨx mu na paiꞌ tɨ ɨꞌɨɨx kaꞌ gu uubas, guꞌ ji na guꞌ cham iꞌbhaiꞌñchardaꞌ. Maaꞌnnim baꞌ giop ma tɨɨgim noꞌ cham iam bax iibhaidhaꞌ nat jumai oidhaꞌp ba aich. Nim maaꞌn ku bha dhaa na bhaiꞌ tɨi ba nɨnɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Baꞌp tɨtda guiꞌ na miꞌx bhaiꞌ buadaꞌ gu uubas: “Iaraꞌ ap dhi iigɨx, na guꞌ cham iꞌbhaiꞌñchar. Sɨlh pɨx na bha jaꞌk cham bhaiꞌ. Bas maakɨꞌn dɨr tɨi bhaiꞌ ba nɨnɨiꞌñ iñ noꞌ cham iam bax iibhaidhaꞌ, pu nim maaꞌn ku bha daakaꞌ, na guꞌ chi bak cham tu iꞌbhaiꞌñchar.” ");
INSERT INTO stpNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Baꞌp kaiꞌch guiꞌ na miꞌx bhaiꞌ buadaꞌ gu uubas: “Ea nach dai xib pɨx dhi oidhaꞌ ba nɨɨraꞌ noꞌt cham iam ba iibhaiꞌch. Aañ ka xi moikxidhaꞌ gio nañ mi tu buidhimɨi gu tuꞌ na kɨꞌn jix bhaiꞌm duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Miꞌ baꞌ noꞌt guꞌ cham ba ji iibhaiꞌch, dai nañ ba iaraꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Maaꞌnnim gu Jesuus ma jii maaꞌn kap nam paiꞌ tu chiopiꞌ kaꞌ gu Israel kam jaꞌtkam, janoꞌ mu jii nam paiꞌ dhuuk cham tu juandaꞌ dai gu Israel kam jaꞌtkam. Baꞌ miꞌ bhaiꞌ ji chu ja aꞌgi guiꞌ nam jɨꞌk miꞌp tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Baꞌ maaꞌn miꞌx jaiꞌch kaꞌ gu ubii jagɨꞌ na gɇꞌx kaboorak kaꞌ komiꞌram dɨr. Ampɨx jix dhumaaram tu oirɨdaꞌ, gio na bhaan pɨx jix kaꞌook kaꞌ, pu cham bhaaiꞌn kaꞌ na jax jum sɨlhñaꞌ. Maaꞌn gu cham kɨɨꞌ iiꞌmdaꞌ puiꞌ jaꞌk duukaꞌ. Mambhɨɨx daman xijum baik oidhaꞌ bap duu na dɨr puiꞌ ba tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nat paiꞌ dhuuk tɨɨ gu Jesuus na mi jaꞌp daa, mu jaꞌk xi baidhak amuub jup tɨtda: ―Xiib yaꞌ dodhiaꞌ ap ji matgɨm jiñ jaduuñ dhiꞌ nap tuꞌ kɨꞌn jix kaꞌook. Chaꞌp jax kam aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Baꞌ palhɨɨp bhaiꞌ xi dhaa komiꞌram. Jotmodaꞌ miꞌ bhaiꞌ jim sɨlh, jix kɨɨꞌp jum duu. Baꞌ gu ubii ma taxchaabgi gu Dios jix dhaam jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Baꞌ bhaiꞌ ji bhaam guiꞌ na miꞌr gɇꞌkam kaꞌ chiop nat ba tu duaꞌñ gu Jesuus na tɨi cham tum juan. Jup ja tɨtda bɨɨx nam jɨꞌk miꞌp tuꞌiiꞌ: ―Janoꞌ pim bha jimmɨdaꞌ na paiꞌ dhuuk tum juandaꞌ noꞌ pim jix dhuduadhik, cham tuꞌ xib na paiꞌ dhuuk aagix nach cham tuꞌ jax buadaꞌ. Tuꞌ kaꞌm japim xi chɨ nɨiꞌñdhat. ");
INSERT INTO stpNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Baꞌ gu Jesuus jup tɨtda: ―Puiꞌ pɨx kaiꞌch ap ji matgɨm. ¿Kux aapiꞌm aa cham jɨꞌxkat iꞌchdhapuꞌ gu jam bhuruꞌxiꞌ piam tuꞌ jam tuuruꞌ noꞌ janoꞌ pɨk giilhim bax chanoom na paiꞌ dhuuk tɨi cham tum juandaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Puꞌñi dhop ji buusan dhiñ jaduuñ nar boxiiꞌñ gu Abraam, gu cham kɨɨꞌ iiꞌmdaꞌ puiꞌ jaꞌk duukaꞌ nax dhumaaram tu oirɨdaꞌ. Mambhɨɨx daman xijum baik oidhaꞌ ba tulhiiñchuda. ¿Cham aa guꞌr am baꞌ na dodhiaꞌ sia na paiꞌ dhuuk cham tum juandaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Baꞌx xiꞌɨraak miꞌ puiꞌ pup tuꞌiiꞌ guiꞌ na miꞌr gɇꞌkam kaꞌ chiop nat puiꞌ tɨɨꞌn gu Jesuus, bɨɨx gu jaiꞌ mɨt jup jix xiꞌɨꞌra nam puiꞌp kax bhaakut buiñor. Gu jaiꞌ jaꞌppɨx jaꞌtkam nam miꞌp tuꞌiiꞌ dho gi guꞌ giilhim joidham jix bhaiꞌm ɨlh jamɨt ji, nam guꞌ cham paiꞌ dhuuk pu chuꞌm tɨ nɨiꞌñ nat gɇꞌp jum duukam bap tu duu gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Baꞌp ja tɨtda ɨp gu Jesuus gu jaꞌtkam: ―¿Tuꞌñ gɨt bhaan ji uaꞌrgidhai jam aaꞌñdhaꞌ na jax jaꞌk ji busaak gu jaroiꞌ noꞌt jix joiꞌmdak bhaan ba tɨ tɨɨ gu Dios? ");
INSERT INTO stpNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Jaꞌpni dho ji busaak na jax gu mostaasa noꞌt jaroiꞌ ɨi, noꞌt giilhim gɇꞌ xiboorak gɨꞌɨɨr sia ku guꞌr ɨlhiꞌch gu kaiꞌñ, uꞌjiꞌm bhaiꞌ xi chu kakoskaꞌ maamragaram. ");
INSERT INTO stpNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Gio baꞌ jaꞌpnip ja tɨtda: ―¿Tuꞌñ gɨt bhaan ji uaꞌrgidhai jam aaꞌñdhaꞌ ɨp na jax jaꞌk jup ji busaak gu jaroiꞌ noꞌt jix joiꞌmdak bhaan ba tɨ tɨɨ gu Dios? ");
INSERT INTO stpNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Jaꞌpni dho ji busaak ɨp na jax guiꞌ na kɨꞌn jappukar gu tuiꞌ noꞌt jaroiꞌ ba jip duu gu paan, joidham gɇꞌ bhaiꞌ ji jabkaꞌ sia kut tɨi palhɨɨp pɨx mi buiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Baꞌ puiꞌ xi chu ja aꞌgidhidhat gu Jesuus gu jaꞌtkam mi jaꞌp na paiꞌ jax jɨꞌdɨlh jir kikcham gio na paiꞌ jax muiꞌ paꞌ daaꞌñxim jup jir kikcham, jimchuꞌ Jerusaleen jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Baꞌ maadɨt gu maaꞌnkam ba tɨkka, jup tɨtda: ―Jiñ jaduuñ, ¿jir gook alh kaꞌ am aa guiꞌ nam buiñor jaꞌk bhɨɨyaꞌ gu Dios, kaꞌ muiꞌ aa? Baꞌ gu Jesuus jup tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Dho daipuꞌ guiꞌ nam jɨꞌk ja jur daasai bhaiꞌ bhaan bubuakiaꞌ gu kiꞌñgob na paiꞌr ɨlhiꞌch. Aañ jix maat guꞌ nam muiꞌ bhaiꞌ tɨix bubuakik kaꞌ bhaan dhi ɨlhiꞌch kiꞌñgob, guꞌ ji nam guꞌx xijaim ɨlhdhaꞌ. Baꞌ aapiꞌm puꞌñi, jam jur japim xi dhaasai xi gaagaꞌ na pim jax jaꞌk dui bhaiꞌ bhaan bubuakiaꞌ dhiꞌ dhi kiꞌñgob. ");
INSERT INTO stpNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Gio guꞌ cham tuꞌ gammɨjɨ bhaiꞌ pu kupioꞌkix kaꞌ dhiꞌ dhi kiꞌñgob. Aayaꞌ ji matgɨm gu tanoolh na paiꞌ dhuuk kuupaꞌ gu kiokam. Cham jɨꞌxkat ka jam kupioꞌkdhaꞌ noꞌ pimɨt dɨɨrap dɨr ba bii, sia pim chi tɨi gatuuk muiꞌp ba tu soon. Guiꞌp jam tɨɨdaꞌ mɨjɨ dɨr: “Jax dhui nañ aañ cham jam maat na pim jir jaroiꞌ dhaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Baꞌ noꞌ pim guꞌ jax kaiꞌch: “Dho aach jir diꞌ nach jum bɨɨm tu koiꞌmɨk gio nach jum bɨɨm tu iꞌmɨk, mi jaꞌp jap oirɨt pu tuch aꞌgiꞌñdhaꞌ nach paiꞌ jax oiꞌñkaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Baꞌp jam tɨɨdaꞌ ɨp gio: “Jax dhui nañ guꞌ ba jam aagiꞌñ nañ cham jam maat na pim jir jaroiꞌ dhaꞌ. Chaꞌpim bha jaꞌk miaꞌn aꞌjɨdaꞌ, na pim guꞌ cham jir kɨkɨɨꞌ jaꞌtkam.” ");
INSERT INTO stpNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Baꞌ giilhim jix buam jum ɨlhdhai bhaiꞌ ji susuañiaꞌ pim aapiꞌm. Ba tɨgiaꞌ pim ɨp guꞌ gu Abraam, gio gu Isaak, gio gu Jakob, gio jaiꞌ muiꞌ guiꞌ nam bhaankam tu aꞌgimɨk gu Dios bɨjɨk nam buiñor jup tuiꞌkaꞌ, aapiꞌm guꞌ pu dɨɨrap dɨr ba biꞌyaꞌ na pim puiꞌ xim aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bɨɨx kap dɨr na jɨꞌx oiꞌñgaꞌn guꞌ gu jaꞌtkam nam buiñor jum jumpadaꞌ gu Dios. Dai ɨp guiꞌ nam jɨꞌk miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ nam buiñor aayaꞌ, maap jam baꞌ tu jugiaꞌ bɨɨx, gɇꞌr koiꞌcham kaꞌ joidham. Gio guꞌ cham tuꞌr Israel kam kaꞌ am dhiꞌ dhi jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Baꞌ dhiꞌ pɨk bɨɨpɨꞌ xi dharkaꞌ am jaiꞌ dhɨt nam xib cham tuꞌ kam jum ɨlhiiꞌñ, baꞌ jaiꞌ dhɨt nam xib tuꞌ kam jum ɨlhiiꞌñ, gatuuk dɨr jaꞌk daraibuꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Baꞌ jɨꞌkchi gu pariseos jum tɨɨtgɨdam miꞌp ba ji bubua mɨt na paiꞌ oirɨ gu Jesuus. Baꞌp tɨtda am: ―Chaꞌp mu jaꞌk jimdaꞌ Jerusaleen, na guꞌ bhaiꞌm oꞌbhagiꞌñ gu Eroodis na sap jum muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Baꞌ gu Jesuus jup ja tɨtda: ―Jaꞌp jum ɨlhiiꞌñ dho gu Eroodis na gu kaxio. Jaꞌp japim tɨɨdaꞌ nañ dai xib gio kabuimuk pɨx ya jaꞌp ba ja duduaꞌñdhaꞌ gu jaꞌtkam nam jix kakoꞌk, gio jaiꞌ nañ ja aꞌm dɨr maiꞌ ka xi ja jootsaꞌ gu cham kɨkɨɨꞌ iꞌiiꞌmdaꞌ na ja aꞌm jup tuiꞌdhiꞌ. Maaxdhiñ baꞌ ba tɨɨmoꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","kuñ ji guꞌ mu jaꞌk jimdaꞌ ji puiꞌ xi chu duduaꞌñdhidhat. Xib jañ jɨꞌx bhɨɨyaꞌ, gio kabuimuk, gio maaxdhi. Bhammɨ jaꞌp jañ ba ji buusniaꞌ, na guꞌ gu jaroiꞌ noꞌ puꞌñi bhaankam tu aꞌga gu Dios, jum aaꞌndaꞌ nam bhaiꞌ muꞌaaꞌ Jerusaleen, cham tuꞌ maakam jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Aapiꞌm jaꞌtkam Jerusaleen oiꞌñkam, jaꞌp pɨx na pim ja kooꞌn guiꞌ nam bhaankam tu aꞌgadaꞌ gu Dios. Tɨi jam aaꞌñdhidhaꞌm pɨx na pim jax jaꞌk duñiaꞌ na baꞌx bhaiꞌ ba tu jam jimdaꞌ. Aapiꞌm ja maꞌyasat ja kooꞌndaꞌ joodai kɨꞌn, guꞌ gu Dios pɨx na bhaiꞌ tɨi ja jootosdaꞌ nam baꞌ yaꞌ tu jam aꞌgidhaꞌ. Jaꞌp na aañ na ñich muiꞌkim tɨi ji jam aaꞌñ na pim miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ gu Dios na baꞌ xi jam joiꞌmdat jam aꞌm ba tɨ nɨidhidhaꞌ gɨt, guꞌ ji na pim guꞌ cham aaꞌ. Dhiꞌ jaꞌp ji buus na jax gu takaaruiꞌ noꞌ tɨi pup bɨɨx xix ja boiꞌspam kat gu maamraꞌn noꞌ bax ja naa gu tuꞌ, guꞌ ji nam guꞌ cham mu jaꞌk aꞌjɨdaꞌ dɨɨlh. ");
INSERT INTO stpNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Baꞌ xib yaꞌ dɨr jaꞌp jaꞌk, cham paiꞌ pim kañ kaayaꞌ nañ pu chuꞌm tu jam aꞌgiꞌñdhaꞌ, ni ku pim cham paiꞌ kañ chɨgiaꞌ maaxik. Janoꞌ pim maaxik kañ chɨgiaꞌ na pim paiꞌ dhuuk jup tɨꞌyaꞌ: “¡Jir gɇꞌkam gio nax uañ kɨꞌn kɨɨk dhiꞌ na bhaankam bhaiꞌ ba jim gu Dios!” ");
INSERT INTO stpNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Maaꞌnnim nam paiꞌ dhuuk cham tu juandaꞌ dai gu Israel kam jaꞌtkam, gu Jesuus tu koꞌiim buiñor maaꞌn gu gɇꞌkam pariseo, nat guꞌ bai na buiñor tu koiꞌraꞌ. Baꞌ sia miꞌp daraa am gu jaiꞌ pariseos nam jix maiꞌchim gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Maaꞌn jup bai mɨt guꞌ gu maaꞌnkam na ɇɇkaꞌ gu baigɨkiꞌ na ja bɨɨm jup tu jugiaꞌ, bhaiꞌ dhɨr jaꞌp jup daa baꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Baꞌ nat ba tɨɨ gu Jesuus, ba ja tɨkka gu pariseos gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios nam miꞌp daraa. Jup ja tɨtda: ―¿Jix bhaaiꞌ aa nañ xib duaꞌñdhaꞌ dhiñ jaduuñ nax kaꞌook sia ku cham tum juan, kaꞌ guꞌ cham aa? ");
INSERT INTO stpNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Guiꞌ cham ñiok am, dai nam miꞌ pɨx pu tuꞌiiꞌ. Baꞌ gu Jesuus mu jimɨɨk xi dhuaꞌñdhak gux koꞌkkam xi joot na ba jimiaꞌ kiaꞌmiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Baꞌp ja tɨtda ɨp gio gu pariseos: ―Noꞌt maadɨt aapiꞌm tuꞌ jam alhii chuk piam tuꞌ jam tuuruꞌ mu paiꞌ ma gɨi jax chuꞌm tɨ dɨꞌn kɨr janoꞌ pɨk na paiꞌ dhuuk cham tum juan, ¿miꞌ pɨx jap xi ñɨiꞌñdhaꞌ? ¿Cham aa nap jotmodaꞌ mu daiꞌññɨi baabuꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Baꞌ guiꞌ bhaiꞌ pɨx xi ñɨiꞌñ am, na guꞌ cham bhaaiꞌ nam jax jaꞌk jup xi chɨɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Baꞌ gu jaꞌtkam guiꞌ nam kiaꞌpɨx mi aajim nat puiꞌp ja bai gu gɇꞌkam pariseo nam jaiꞌ bɨɨmaꞌn jup tu jugiaꞌ, bɨɨpɨꞌ dɨr pɨx ji dharaibuim am amuub na paiꞌ daa na xi ja nɨiꞌñ gu Jesuus. Baꞌ xi ja aagiꞌñ na cham jir am nam puiꞌ jaꞌk tu jimdaꞌ, jup ja tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Noꞌ jaroiꞌ mu paiꞌ bam tɨtmo, baꞌ puꞌñi ma jam bai na pim buiñor tu jugiaꞌ, chaꞌpim amuub dadaarrɨdaꞌ na paiꞌ daakaꞌ guiꞌ na miꞌm tɨtmodaꞌ, na guꞌ cham maatɨꞌ kaꞌ noꞌ aapiꞌm miꞌ jam biꞌiiꞌñkaꞌ gu aꞌtoxkar, kaꞌ baꞌ gu jaiꞌ na palhɨɨp iam jix ioꞌm paꞌx kɨɨꞌ kaꞌm ja nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Miꞌ dhɨr dho ji jam jootsaꞌ noꞌ puꞌñi jaiꞌ miꞌ ja biꞌiiꞌñ noꞌ aapiꞌm cham pɨk kɨɨꞌ kaꞌm jam nɨiꞌñ. Baꞌ puiꞌx xiꞌɨꞌrai jaꞌp jaꞌk ma jimiaꞌ pim na paiꞌ cham pɨk tuꞌ bhaigɨm tu tuiꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Guꞌ jaꞌpji noꞌ mɨt paiꞌ dhuuk puꞌñi jam bai na pim tu jugiaꞌ, nammɨ dɨr juꞌñdharam japim pɨx pu ji dharaibuidhaꞌ na paiꞌ cham pɨk tuꞌ bhaigɨm tu tuiꞌkaꞌ. Miꞌ baꞌ dɨɨlh noꞌ jax kaiꞌch gu jaroiꞌ na jam baidhaꞌ na pim mu jaꞌk daraibuꞌ amuub, mu jaꞌk japim dho baꞌp ba jimiaꞌ. Baꞌx bhaiꞌm taatɨt japim miꞌp ba darkaꞌ bɨɨmaꞌn gio ja bɨɨm gu jaiꞌ na miꞌp ja chiñiaꞌ, baꞌ bɨɨx pɨx jix bhaiꞌ jam aaꞌndaꞌ am gu jaꞌtkam nam mummɨ dɨr jaꞌp darkaꞌ na pim bɨɨmaꞌn xi chu kuaꞌdaꞌ guiꞌ na miꞌm tɨtmodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Na guꞌ gu jaroiꞌ noꞌ gampaiꞌm ɨlhiiꞌñ, joidham jix kɨɨꞌ kaꞌm nɨiꞌñdhaꞌ am gu jaꞌtkam, guꞌ cham tuꞌ kɨɨꞌ kaꞌm nɨiꞌñdhaꞌ am ji noꞌ dai gɇꞌkam jum taat. ");
INSERT INTO stpNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Baꞌ nat puiꞌ xi ja tɨɨdak gu Jesuus gu jaꞌtkam, jup tɨtda ɨp dɨɨlh gu gɇꞌkam pariseo nat bai na bɨɨmaꞌn tu jugiaꞌ: ―Gio aap jiñ jaduuñ nap jir kiokam, nap paiꞌ dhuuk ja baiꞌñdhaꞌ gu jaꞌtkam nam jum bɨɨm tu jugiaꞌ, chaꞌp dai guiꞌ ja baiꞌñdhaꞌ nap jaroiꞌ ɨlhiiꞌñdhaꞌ nam pu chuꞌm kɨꞌn jaꞌk jup jum buidhaꞌ, puiꞌ na jax guiꞌ nam jir jix bhabhaiꞌkam kaꞌ jum bui, piam gum jaaduñ, piam gux chutumñigam nam ya jaꞌp amuub oiꞌdhaꞌ nap paiꞌ kio. ");
INSERT INTO stpNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Guꞌ guiꞌ ji nap ja baidhaꞌ nam cham tuꞌ biaꞌ ni jɨꞌx, gio guiꞌ nam jix mamaꞌmkulhiꞌ, gio guiꞌ nam cham ñiññia. ");
INSERT INTO stpNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Miꞌ dhɨr baꞌ dai nap jix bhaiꞌ pɨx bam taat kaꞌ, na guꞌ jaꞌk jum buidhaꞌ gu Dios janoꞌ nam paiꞌ dhuuk duduadɨi baapmigiaꞌ guiꞌ nam miꞌ puiꞌ jimiaꞌ na jax jix aaꞌndaꞌ, sia kum guꞌ dhiꞌ cham jaꞌk jum buidhaꞌ gu yaꞌ jotmodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Baꞌ maadɨt gu maaꞌnkam nat kai gu Jesuus nat koiꞌ bhaan tu aꞌga gux dhaam kam, jup kaiꞌch: ―¡Jaꞌp moo joidham jix bhaiꞌ tu ja jimiaꞌ guiꞌ nam buiñor aayaꞌ gu Dios nax ioꞌm jir gɇꞌkam! ¡Bɨɨmaꞌn tu jugiaꞌ am guꞌ! ");
INSERT INTO stpNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Baꞌ gu Jesuus jup kaiꞌch: ―Maaꞌnnim maaꞌn gu maaꞌnkam jix aaꞌ na tu jugiaꞌ jurnɨk kam muiꞌ ja bɨɨm gu jaꞌtkam. Gu tujuandam tugiꞌñ mɨjɨ jaꞌp xi joot na pu ja tɨɨꞌnmɨraꞌ gu jaꞌtkam nar koiꞌcham kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Baꞌ nat paiꞌ dhuuk bam ai nam tu jugiaꞌ, gio mɨjɨ jaꞌp jup xi joot gu tujuandam tugiꞌñ na muiꞌ ba ja baidhikaꞌ guiꞌ nat bɨɨpɨꞌ dɨr ba ja aaꞌñ nar koiꞌcham kaꞌ, miꞌ pu ba tu bhiix. ");
INSERT INTO stpNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Guꞌ ji na guꞌ na mu jaꞌp tɨi puiꞌ ba ja tɨtdaim ɨp gio, cham ka aaꞌ am. Jup kaiꞌch guiꞌ nat bɨɨpɨꞌ puiꞌ tɨi xi chɨɨꞌn: “Aañ kiaꞌpɨx alhiꞌch sabaꞌlh maaꞌn kap gu dɨbɨɨr. Mu jaꞌk jañ baꞌ ka tɨɨꞌmɨraꞌ. Ka xi chuñ uañiꞌñkaꞌ ap nañ cham mu jim.” ");
INSERT INTO stpNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Baꞌ jumai jaꞌp jaꞌk puiꞌ tɨip ba tɨtdaim, jup kaiꞌch pɨx ɨp: “Aañ kiaꞌpɨx ja sabaꞌlh gook gu tutuur nañ kɨꞌn tu juanaꞌ. Mu jaꞌk jañ baꞌ ka matmɨraꞌ noꞌm moox oꞌjoꞌ. Cham jañ baꞌ moo mu jim, ka xi chuñ uañiꞌñkaꞌ ap.” ");
INSERT INTO stpNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Baꞌ jumai jaꞌp jaꞌk puiꞌ tɨip ba tɨtdaim, jup kaiꞌch pɨx ɨp: “Jaꞌp moo xib pɨk sap muni paiꞌ kañ chɨɨmoꞌ iñ. Cham jañ baꞌ moo mu jim, nañ guꞌ mu jaꞌk ka bhɨɨyaꞌ. Ka xi chuñ uañdhaꞌ ap.” ");
INSERT INTO stpNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Baꞌ puiꞌ dɨɨlh giop ma jii gu tujuandam tɨi pup xi ja baidhimɨk, bhammɨ ba aaꞌñdhim gu gɇꞌkam tugiꞌñ. Baꞌ guiꞌ tɨi ma bhaam nat cham jaroiꞌ mu jii, baꞌp tɨtda ɨp gio: “Dhop xi dhaiꞌññiaꞌ ku gi nap ja baiꞌñmɨraꞌ guiꞌ nam cham tuꞌ biaꞌ ni jɨꞌx mɨjɨ jaꞌp nam jix jaiꞌch dhi gɇꞌ kiicham, sia guiꞌ nam jix mamaꞌmkulhiꞌ nam mɨjɨ jaꞌp daraa, gio guiꞌ nam cham ñiññia.” Baꞌ xi mɨɨ ɨp gu tujuandam nat ja baidham. ");
INSERT INTO stpNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jaꞌxpɨx baꞌ gio miꞌp ba ai ji ja baidhat, jup tɨtda gu gɇꞌkam tugiꞌñ: “Yaꞌ ñich ba ja aich gu jaꞌtkam na pich jiñ joot, guꞌ ji na guꞌ gɇꞌ ka tu bioꞌ ya baꞌk chɨr.” ");
INSERT INTO stpNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Baꞌp tɨtda gu gɇꞌkam tugiꞌñ: “Dho giop jup xi dhaiꞌññiaꞌ nap ja baiꞌñmɨraꞌ guiꞌ nam mu jaꞌp daraa juꞌñdharam dhi gɇꞌ kiicham. Soiꞌp xi ja tɨtdadaꞌ nam baꞌ bham oidhaꞌ. Bɨɨx jap am pup ja baidhai guiꞌ nam miꞌ paiꞌ darkaꞌ boi jugiiꞌñ. Jix aaꞌ iñ guꞌ nam suuduꞌ yaꞌ dhiñ baꞌkgɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ni maadɨt guꞌ ku ka tu jugiaꞌñ bɨɨm guiꞌ na ñich bɨɨpɨꞌ dɨr tɨi ja bai, aañ nañ paiꞌ jax kaiꞌch.” ");
INSERT INTO stpNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Baꞌ na gamaiꞌ ba jimchuꞌ gu Jesuus, muiꞌ gu jaꞌtkam mu oiꞌñchuꞌ am, pɨx chɨbɨɨp kattuꞌ am. Baꞌ muiꞌ xi ja tɨɨgɨk jup ja tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Noꞌ tuꞌ sɨlhkam jix aaꞌ na jaroiꞌ gammɨjɨ bañ kaichgɨdaꞌ, jum aaꞌ na bɨɨx juraaꞌn kɨꞌn xiñ dhaandaꞌ gammɨjɨ. Na guꞌ noꞌx ioꞌm jix dhaan gu taataꞌn, piam gu dɨꞌɨɨꞌn, piam gu jajaaꞌnniꞌñ, piam gu maamraꞌn, piam ku guꞌ dɨɨlh jix ioꞌm xim joiꞌgɨꞌn, cham tuꞌr am nañ kaichgɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Guꞌ cham ji noꞌ guꞌx ioꞌm xiñ dhaanɨt jiñ kaichuꞌ, na guꞌ cham tuꞌ bhaan jup jum buixiꞌñdhaꞌ gu tuꞌ na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch, sia chi jax jum tulhiiñ bɨɨx aixim tuꞌm kɨꞌn. Dhiꞌ baꞌ jaꞌp ji buusandaꞌ na gammɨjɨñ oiꞌñchuꞌndaꞌ ji mootot gu kuruus. ");
INSERT INTO stpNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Na guꞌ dhiꞌ jaꞌpni na jax noꞌ maadɨt aapiꞌm mu paiꞌx kɨɨsam maaꞌn gu tɇb bhiꞌñbak, ¿cham aa guꞌ bɨɨpɨꞌ xi dhaibui xim gaꞌngadaꞌ ap noꞌ moo aix gu tuumiñ nap kɨꞌn tɨɨmoꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nam guꞌ bhaiꞌ jim aꞌgaꞌ gu jaꞌtkam noꞌ pich xi chu kookbɨk dai joodai miꞌ xi baapsak miꞌ dhɨr miꞌ puiꞌ pup tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Jax kaiꞌchdhaꞌ am dho guꞌ: “Cham ka aich dho chi gu tuumiñ gu jaduuñ na kɨꞌn tɨɨmoꞌ dhi bhiꞌñbak kut baꞌ jaꞌxbuiꞌ pɨx ji bua.” Tɨip baꞌ bax xiꞌɨrdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Piam jaꞌpni ɨp, noꞌm gook gux ioꞌm gɇꞌgɇrkam ba xim koodak, baꞌ noꞌ guꞌ maaꞌn gook alh ja biaꞌ gu sandaaruiꞌx, gu jumai baꞌ muiꞌ, ¿cham aa guꞌ bɨɨpɨꞌ xi dhaibui xim gaꞌngadaꞌ guiꞌ na gook alh ja biaꞌkaꞌ gu sandaaruiꞌx, noꞌ jaꞌkbuiꞌ kɨꞌn mamaiꞌchɨk gu jumai na muiꞌ ja baiꞌñchuꞌndaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Guꞌ baꞌ noꞌ guꞌ jaꞌkbuiꞌ kat mamaiꞌchɨk na puiꞌ xim aaꞌ, mɨjɨ dho xi jootsaꞌ gu tujuandam tugiꞌñ na aaꞌñdharaꞌ gu jumai gɇꞌkam na puiꞌ ba tuiꞌkaꞌ, nam chakui maap jum naankiaꞌ. Baꞌ miꞌ puiꞌ cham tuꞌ kam kokdaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Puꞌñi ɨp baꞌ aapiꞌm, jum aaꞌ na pim cham tuꞌ bhaan jujurtɨkaꞌ gu tuꞌ na pim biaꞌkaꞌ noꞌ pim jix aaꞌ na pim gammɨjɨ bañ kaichgɨdaꞌ, gio na pim tuꞌ sɨlhkam xiñ dhaandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’¿Aapiꞌm jax ɨlhiiꞌñ noꞌ jax dhuukat miꞌ jotmodaꞌ cham ka onkak gu on noꞌ jaroiꞌ gɇꞌ miꞌ paiꞌ ka biaꞌ? ¿Jax dhui giop ka onkalhiaꞌ na baꞌ gio kɨꞌn jup bax chu ioꞌb kaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Aañ jaꞌp kaiꞌch na pu cham tuꞌ ka bhaiꞌn kaꞌ, ni gu ɨꞌɨɨx ku kɨꞌn kax joiꞌñdhaꞌ sia kut tɨi miꞌp xim buiꞌñ. Miꞌ pim puiꞌ ba jimiaꞌ jɨꞌk na pim jix maatɨt jiñ kɇɇ nañ jax kaiꞌñkam jup kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Baꞌ muiꞌ mi aajidhaꞌ am gu tuumiñ tu taandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam na paiꞌ oirɨdaꞌ gu Jesuus, nam jix kaim kaꞌ na tu aꞌgadaꞌ, sia gu jaiꞌ jaꞌppɨx jaꞌtkam nam cham tuꞌ kaꞌm tɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Baꞌ gu pariseos gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios miꞌ dhɨr jaꞌp jix bhaamut aꞌgichuꞌ am gu Jesuus, jup kaiꞌch am: ―Jaiñ dhiꞌ na saak miꞌ puiꞌ jim na jax jix aaꞌ gu Dios, joidham cham jax ji ja ɨlhdhat ja bɨɨm tu kuaꞌ gux uꞌuaꞌtulhdhix kam. ");
INSERT INTO stpNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Baꞌ gu Jesuus xi ja aaꞌñ bhaan ji uaꞌrgidhak maaꞌn gu kasnir bipiaꞌdam, jup ja tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Noꞌ jaroiꞌ maadɨt aapiꞌm ja biaꞌ maaꞌn jix chamaam ooꞌm gu kakasnir, baꞌ ma tu biꞌaam japich mummɨ paiꞌ nax xaꞌiiꞌ, guꞌ ji noꞌ guꞌ cham tu jaiꞌch maaꞌn nap ba ja nɨnɨiꞌñ mi ɇɇk, baꞌ aap jix buam jum ɨlhdhak ma tu gaagam ɨp gio miꞌ xi ja kuupak gu jaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Baꞌ siamri nammɨ paiꞌ ma tɨɨ pich jax chuꞌm bapaikkam, baꞌx bhaiꞌm ɨlhdhak japich xi ioꞌmdak xi mootok ba jii ɨp gio. ");
INSERT INTO stpNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Baꞌ mu na pich ai kiicham, xi dhaiꞌbus japich na pich ja baidham gu jaꞌtkam guiꞌ nap jɨꞌk jix ja maat, baꞌ jax ja tɨtda ap miꞌ maap ji ja jumpadak: “Aañ maaꞌn maiꞌ buak gu kasnir na ñich tu biaꞌrak. Giilhim jañich jix buam jiñ ɨlh na ñich paiꞌ dhuuk maat na maaꞌn cham tu jaiꞌch. Baꞌ ma tu gaagam jañich, siamri ñich giop tɨɨ nammɨni maaꞌn kap bapaikkam. Xib jañ baꞌ giilhim jix bhaiꞌñ chaat. Dhiꞌ pu kaiꞌñkam jach baꞌ yaꞌ maap tu jugiaꞌ, na pim baꞌ aapiꞌm puiꞌx bhaiꞌp jum taat kaꞌñ bɨɨm nat jix bhaiꞌ tuñ jii.” ");
INSERT INTO stpNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Puꞌñi ɨp dhox dhaam jaꞌk, giilhim gɇꞌr koiꞌcham kaꞌ noꞌt jaroiꞌ soiꞌm ɨlhdhak puiꞌ ba tɨɨꞌn gu Dios na uañdhaꞌ gu uaꞌtulhdhar gaꞌn, nam guꞌ bɨɨx jix bhaiꞌm ɨlhdhaꞌ guiꞌ nam jix dhaam jup tuꞌiiꞌ buiñor gu jaroiꞌ na soiꞌm ɨlhdhaꞌ. Jix ioꞌm jix bhaiꞌm ɨlhdhaꞌ am dhiꞌ buiñor, cham tuꞌ puiꞌ na jax guiꞌ nam bɨɨpɨꞌ dɨr pu soiꞌ bam ɨlhdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Piam jaꞌpni ɨp. Noꞌ jɨꞌk mambhɨɨx aixim gu bapaiñum tuumiñ bhaiꞌ paiꞌ ka biaꞌ maaꞌn gu ubii, guꞌ ji noꞌ guꞌ cham tuꞌ jaꞌkbuiꞌ ka aix na paiꞌ dhuuk tɨi ba jaꞌkɨlhiꞌñ, baꞌx buam jum ɨlhdhak naiꞌ ji chu gaa gɇꞌ ji chɨ bɨꞌñdhak, pɨx am tu boxkaidhat tu gaagim mi jaꞌp dɨɨrap gio bhɨjɨ jaꞌp sasoosnaꞌn. Baꞌ noꞌt guꞌ siamri ma tɨɨ na miꞌ paiꞌ kaat, ");
INSERT INTO stpNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","joidham dhox bhaiꞌm ɨlhdhai xi dhaiꞌññiaꞌ ɨp na ja baiꞌñmɨraꞌ gu bɨpnagaꞌn uꞌuub guiꞌ na jɨꞌk jix ja mat kaꞌ, puiꞌ na jax guiꞌ nam miꞌ dhɨr jaꞌp amuub oiꞌñkaꞌ. Baꞌ noꞌ guꞌ jax ja tɨtdaꞌ miꞌ maap ji ja jumpadak: “Aañ maaꞌn maiꞌ buak gu tuumiñ, mambhɨɨx aixim jañ bhaꞌñi ka biaꞌkat dai bapaiñum. Baꞌ tu gaꞌngimɨk jañich ma tɨɨ dakoo. Xib jañ baꞌ joidham jix bhaiꞌñ chaat. Dhiꞌ pu kaiꞌñkam jach baꞌ yaꞌ maap tu jugiaꞌ, na pim baꞌ aapiꞌm puiꞌx bhaiꞌp jum taat kaꞌñ bɨɨm nat jix bhaiꞌ tuñ jii.” ");
INSERT INTO stpNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Puꞌñi ɨp dhox dhaam jaꞌk, giilhim gɇꞌr koiꞌcham kaꞌ noꞌt jaroiꞌ soiꞌm ɨlhdhak puiꞌ ba tɨɨꞌn gu Dios na uañdhaꞌ gu uaꞌtulhdhar gaꞌn. Bɨɨx jix bhaiꞌm ɨlhdhaꞌ am guꞌ gu noonbiꞌñ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Baꞌ jumai bhaan jup ji chu uaꞌrgidhak muiꞌ ji chu ja aꞌgi gu Jesuus gu jaꞌtkam, jup ja tɨtda: ―Maaꞌnnim maaꞌn gu maaꞌnkam gook tu maamar kaꞌ biipibop. ");
INSERT INTO stpNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gu gatuuk kam jup tɨtda gu taataꞌn: “Xi chuñ maakai ap jiñ chaat gum bɨxchuꞌ na jɨꞌk jiñ aꞌm jup tu bipioꞌ.” Baꞌ maaꞌn jimdam bɨɨx gook xi chu ja maakak gu ja taat na jɨꞌk ja aꞌm tu bipioꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Baꞌ jɨꞌk pɨx jur nat bɨɨx xi chu gaꞌrak gu gatuuk kam nat jɨꞌk tuꞌ tu maa gu taataꞌn, mɨk jaꞌk bhɨi baꞌ jumai momkoram xi uꞌuuk gu tuumiñ. Bhammɨ dɨr pu jugio bɨɨx na jɨꞌk uaꞌkat, na guꞌx maim kaꞌ ganaiꞌ bɨɨx aixim na tu buadaꞌ na jax ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Baꞌ janoꞌ pɨk giilhim bhiogiꞌ ma jii bhammɨ dɨr na ka oirɨ, gio guꞌ pu ba juu gu tumñigaꞌn. Cham ka jaiꞌch na tuꞌ jugiaꞌ, dai na ba uamaim pɨx. ");
INSERT INTO stpNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Baꞌ maaꞌn gu maaꞌnkam buiñor ma tu jua na bipiꞌñxiꞌñdhaꞌ gu tatooxkolh na ja biaꞌkaꞌ. Mummɨ jaꞌp chiandaꞌ na bipiꞌñxiꞌñkaꞌ na paiꞌ tu gaꞌmbhar kaꞌ guiꞌ gu maaꞌnkam. ");
INSERT INTO stpNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tɨix ñaakɨt nɨiꞌñdhaꞌ gu tatooxkolh ja koiꞌdharaꞌ nam ja maakdaꞌ mi kiicham, giilhim uamaidhaꞌ guꞌ. Aaꞌndaꞌ gɨt nam jax tɨɨdaꞌ na jaiꞌ palhɨɨp jup xi jugiaꞌ na kɨꞌn jɨꞌx jup bam guguuxdhaꞌ, guꞌ ji nam guꞌ cham paiꞌ jax jup tɨtdadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Baꞌ mɨkkat jup jum aaꞌ: “Bhammɨ chi giilhim gɇꞌ na ja bipioꞌ gu koiꞌ gu tujuandam tugiꞌñ guñ chaat, aañ guꞌ yaꞌ jaꞌk giilhim uamaim sia kuñ puiꞌp jir tujuandam. ");
INSERT INTO stpNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Gi noꞌ ñich gio muiꞌp jii bhammɨ, jaꞌp jañ chɨɨdaꞌ guñ chaat na ñich mañ uaꞌtulh buiñor Dios gio buiñor dɨɨlh. ");
INSERT INTO stpNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jaꞌp jañ chɨɨdaꞌ na cham puiꞌ kañ iimdaꞌ nañ jir maraaꞌn, na ñich guꞌ buam pɨx alhio. Jaꞌp jañ chɨɨdaꞌ na jaꞌp pɨx bañ biaꞌkaꞌ na jax maadɨt gu tujuandam tugiꞌñ.” ");
INSERT INTO stpNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Baꞌ puiꞌm aagɨk pɨx kɨkbo bɨɨx boi nat ba jii bhammɨ buiñor gu taataꞌn. ’Baꞌ yammɨ dɨr jaꞌp muiꞌ ba jim nat ba tɨɨ gu taataꞌn, mu daiꞌbus nat namkim. Ioꞌmdak xi koom gio nat chiñxi, nat guꞌx joiꞌmdak tɨɨ na yammɨ dɨr jaꞌp muiꞌ soiꞌ ba tuiꞌdhiꞌ na muiꞌ ba jim. ");
INSERT INTO stpNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Baꞌp kaiꞌch gu maraaꞌn: “Jiñ chaat, aañ gɇꞌkam kɨꞌn mañ uaꞌtulh buiñor gu Dios gio aap jum bui. Chaꞌp puiꞌ kañ iimdaꞌ nañ jir jum mar, na ñich guꞌ buam pɨx jum alhio.” ");
INSERT INTO stpNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Guꞌ ji na guꞌ gu taataꞌn cham puiꞌ ɨlhiiꞌñ, jup ja tɨtda gu tujuandam tugiꞌñ: “Gor xi chɨ tɨꞌiiꞌñ dhiñ chioꞌñ gu jajannulh gux kɨkɨɨꞌ, xi chu uaꞌpui pim mɨjɨ na naangiaꞌ baꞌk chɨr. Suusak japim jup xi aaꞌñdhaꞌ, gio maaꞌn aniiyu pim jup xi dhaaxdhaꞌ nobiꞌram. ");
INSERT INTO stpNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Xi boopoyaꞌ pim ɨp baꞌ na pim saaꞌnpuꞌ gu tuur jax chuꞌm nax dhua. Miꞌ pim baꞌ xi muꞌaaꞌ kuch yaꞌ tu jugiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Giilhim jix bhaiꞌñ chaat iñ guꞌ na ñich giop ba tɨɨ dhiñ chioꞌñ nat muiꞌ tanoolh maiꞌ gɨɨsɨk, panaas ku muukix kat gio duadɨk yaꞌp ba oirɨ.” Baꞌ jaꞌxpɨx giilhim miꞌ bar koiꞌcham. ");
INSERT INTO stpNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Baꞌ gu bɨɨpɨꞌ kam maraaꞌn mummɨ jaꞌk jup ka oirɨ gaꞌmbhar tɨr nat gu sɨpdhiꞌñ miꞌ jaꞌk ba ai. Mɨjɨ pɨx gɇꞌ kɨꞌn tum sab na muiꞌ ba jimchuꞌ, pu cham maat na jax kaiꞌñkam mɨjɨ tum sab, tɨm nɨiꞌchuꞌ kam tum kaiꞌch. Baꞌ nax ioꞌm amuub ba jimchuꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","maaꞌn gu tujuandam xi baidhak xi chɨkka na tuꞌ jax jum bua. ");
INSERT INTO stpNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Baꞌp tɨtda: “Dho sap nat giilhim jix bhaiꞌm ɨlh gum taat nat gio yaꞌp ba ai gum xikuꞌ nat maiꞌ gɨɨsɨk, nat guꞌ sap jix kɨɨꞌ ya ai. Tu chia baꞌ nam muꞌaaꞌ maaꞌn gu tuur jix dhuakam nach tu jugiaꞌ. Miꞌ dho baꞌ bhaajim xib.” ");
INSERT INTO stpNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Baꞌ guiꞌ dai nat bhaiꞌ ji bhaam. Mummɨ jaꞌp mɨk pɨx pup kɨɨk. Cham muiꞌ ka ai. Baꞌ mu jimɨɨk gu taataꞌn tɨi soiꞌ ba tɨtda na mu aayaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jup kaiꞌch gu maraaꞌn: “¿Nap baꞌ aañ cham puiꞌx bhaiꞌñ buañ chaat nañ gammɨjɨ yaꞌm palhbuiꞌñ gu tuꞌ nap jax bua? Tɨɨꞌ nañ tɨi pɨx bhaan ji bamgidhaꞌ nañ tu juantuꞌndaꞌ, pɨx cham jiñ jɨɨpdhidhaꞌ iñ. Jumai oidhaꞌ bap duñiaꞌ, yaꞌ puiꞌ nañ jax jum bɨɨm bap tuiꞌñgɨdaꞌ. Chakui ñich moo paiꞌ dhuuk maaꞌnnim cham jum kai. Miꞌ puiꞌ tu duñiidhaꞌ iñ gu tuꞌ nap jiñ chiandaꞌ. Ni kup cham paiꞌ dhuuk jax kaiꞌch nap iam tuꞌ karbax xiñ makiaꞌ nañ ja bɨɨm jup tu jugiaꞌ guiꞌ nañ jɨꞌk jup jix ja maat. ");
INSERT INTO stpNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Guꞌ dhiꞌ gi baꞌ gum tumñiꞌ nat xi ja onbaiꞌñdharak gu oipodam uꞌuub bhaiꞌ gaꞌm ba jim, miꞌ xi muiꞌ pich ji guꞌ gu tuur jix dhuakam sia kup tɨix maat nat jax jum alhio.” ");
INSERT INTO stpNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Baꞌp kaiꞌch gu taataꞌn: “Ba tum iimchudhix ji matgɨm jiñ chioꞌñ nañ jɨꞌk tuꞌ tu biaꞌ, bɨɨx bar tu aap gaꞌn, nap guꞌ maaxik gammɨjɨ yaꞌp tuiꞌñgɨt jiñ palhbuiꞌñ gu tuꞌ nañ jax bua. ");
INSERT INTO stpNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dai pɨx ji na guꞌ xib jich aꞌm jum aaꞌ nach bɨɨx maap jix bhaiꞌch chaatɨt tu jugiaꞌ nat yaꞌ ba ai gum xikuꞌ nat muiꞌ tanoolh maiꞌ gɨɨsɨk, panaas ku muukix kat gio duadɨk yaꞌp ba oirɨ.” ");
INSERT INTO stpNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Baꞌ gu Jesuus dɨɨlh jup xi chu ja aꞌgi dai guiꞌ nam jɨꞌk kaichuꞌ puiꞌ bhaan jup xi chu uaꞌrgidhak, jup ja tɨtda: ―Maaꞌnnim maaꞌn gu maaꞌnkam jix chumñigam maaꞌn biaꞌkaꞌ gu tujuandam na miꞌ dhɨr jup tu ja chiandaꞌ gu jaiꞌ tujuandam tugiꞌñ. Baꞌ cham miꞌ puiꞌ tu duiñchuꞌndaꞌ dhiꞌ dhi tujuandam na jax chiandaꞌ gux chumñigam. Baꞌ gu jaiꞌ tujuandam ba aagiꞌñ am gux chumñigam na cham miꞌ puiꞌ tu duiꞌñchuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Baꞌ gux chumñigam xi chu joochxi na mu jimdaꞌ na tɨkkaꞌ noꞌr sɨlhkam. Baꞌ mummɨp ba ji buus, jup tɨtda: “¿Jir sɨlhkam aa nap cham miꞌ puiꞌ duiñchuꞌ nañ jax jum aagiꞌñ? Eap tu uaꞌmɨr gu uꞌuan guiꞌ nap bhaan tu daasaim nañ xi chɨgiaꞌ noꞌp miꞌ puiꞌ tu duiñchuꞌ, piam ku guꞌ cham kuñ aañ yaꞌ dɨr jum buusaidhaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Baꞌ nat miꞌ dhɨr buusnɨk gamaiꞌ ba jimchuꞌ gu tujuandam, jup jum aaꞌntuꞌ: “¿Tuꞌñ baꞌ bhaan ka tu juanaꞌ, na guꞌ bañ buusaidhaꞌ gu kiokam na ba tɨgiaꞌ guñ uꞌuan? Cham tuꞌ bhaiꞌ iñ guꞌ nañ tu juanaꞌ jaraar taꞌm nañ gɨt jup ba tɨ ɨxiaꞌ. Jix xiꞌɨr iñ ɨp nañ puiꞌ naiꞌ ja tañiidhaꞌ gu jaꞌtkam gu tuumiñ. ");
INSERT INTO stpNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Aa, bax maat iñ nañ jax jaꞌk duñiaꞌ! Jaꞌp jañ ja tɨɨdaꞌ guiꞌ nam uaꞌtuꞌn gu kiokam nam jɨꞌk pɨx namkidhaꞌ nam baꞌ dhiꞌx bhaiꞌñ dhuñiaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Baꞌ jɨꞌmaꞌn pɨx bhaiꞌ ji ja bai guiꞌ nam uaꞌtuꞌn gux chumñigam. Jup tɨtda guiꞌ nat bɨɨpɨꞌ mi ai: “¿Jɨꞌk jap moo uaꞌtuꞌn gu kiokam?” ");
INSERT INTO stpNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Baꞌp kaiꞌch guiꞌ: “Maaꞌn jix chamaam ooꞌm kastaañ dho gu oliibus baraaꞌ.” Baꞌp tɨtda: “Dhop miꞌñi jaꞌp xi dhaibui atoxkor taꞌm jumaip duñiaꞌ guiꞌ na bhaan jix maatɨꞌ. Yaꞌni gu uꞌuan. Gook ooꞌm daman mambhɨɨx kastaañ jap pɨx mi dhaasaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Baꞌ jumai mɨjɨp xi chu joochxi na mu jimdaꞌ, jup tɨtda ɨp nat miꞌ ba ai: “¿Aap jɨꞌk jup uaꞌtuꞌn gu kiokam?” Baꞌp kaiꞌch guiꞌ: “Maaꞌn jix chamaam ooꞌm janeeꞌ dho gu tiriik.” Baꞌp tɨtda ɨp: “Dhop miꞌñi jaꞌp xi dhaibui jumaip duñiaꞌ guiꞌ na bhaan jix maatɨꞌ. Yaꞌni gu uꞌuan. Maakob ooꞌm janeeꞌ pɨx jap mi dhaasaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Baꞌ gux chumñigam gatuuk ba maat nat jix aich nat jax jaꞌk duu gu tujuandam tugiꞌñ kat na baꞌ cham mu jaꞌp pɨx maiꞌ gɨɨxix kaꞌ. Maaxik puiꞌ jaꞌk tu jim am guꞌ guiꞌ nam cham miꞌ puiꞌ jiim na jax jix aaꞌ gu Dios, jix ioꞌm jix aichuꞌn am nam jax jaꞌk duñiaꞌ gu tuꞌ na dɨɨlh jir jup ja duiñ kaꞌ, cham tuꞌ puiꞌ na guiꞌ nam miꞌ puiꞌ jiimdaꞌ na jax jix aaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Jir am ɨp dho na pim muiꞌ maiꞌchiaꞌ gu tuumiñ yaꞌ kam dhi oiꞌñgaꞌn nax chu uaꞌtulhdhix, na pim guꞌ dhiꞌ kɨꞌn baꞌ ja maiꞌchiaꞌ jaiꞌ gu jaꞌtkam, nam jaroiꞌx bhaiꞌ jam tɨɨdai jam aichdhaꞌ maaꞌn kap nam paiꞌ gammɨjɨ bhaiꞌ pu ba oiꞌñkaꞌ, janoꞌ na gu tuumiñ yaꞌ kam dhi oiꞌñgaꞌn cham paiꞌ ka matgilhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Na guꞌ na pim jax bax maat gu jaroiꞌ noꞌt miꞌ pu tu duu gu tuꞌ palhɨɨp jup jum duukam noꞌ mɨt chia, dhiꞌ bhaan jix maatɨꞌ kaꞌ ɨp na sia gu gɇꞌp jum duukam miꞌ puiꞌp duñiaꞌ noꞌ mɨt chia. Guꞌ ji noꞌt guꞌ gu palhɨɨp jup jum duukam cham miꞌ pu duu, pu dhiꞌ bhaan jup jix maatɨꞌ kaꞌ na cham miꞌ puiꞌp duñiaꞌ gu gɇꞌp jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Baꞌ puꞌñi ɨp aapiꞌm noꞌ pim cham miꞌ puiꞌ duñiim gu tuumiñ na jax jaꞌk jum aaꞌ na pim duñiidhaꞌ, dhiꞌ bhaan jix maatɨꞌ kaꞌ na pim sia cham tuꞌ miꞌ puiꞌp duñiaꞌ na paiꞌ dhuuk tu jam makiaꞌ gu Dios guiꞌ nax dhaam jaꞌk jix chu jaiꞌch na cham jɨꞌxkat tu juꞌngɨ. ");
INSERT INTO stpNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Piam puiꞌ na jax sia gu jaroiꞌ noꞌ pim cham miꞌ puiꞌ tu duñiim gu tuꞌ na tɨi jam chiñiaꞌ, ¿tuꞌ pim baꞌp nɨɨrdaꞌ nar jam namkiꞌ kaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Gio guꞌ na pim jax bax maat na cham jir am na gu jax chuꞌm tujuandam gok kap tu juandaꞌ maaꞌn jimdam, na guꞌ cham tuꞌ bɨɨx gook jix bhaiꞌ tu ja juañdhaꞌ, jumai dho pɨx jup bhaamkidhaꞌ gu jaroiꞌ na buiñor tu juandaꞌ, mɨkkat jumai ɨp, miꞌ pum buadaꞌ. Dhiꞌ jaꞌp jañ kaiꞌñkam jup kaiꞌch na cham bhaiꞌ miꞌ puiꞌ jimdaꞌ gu jaroiꞌ na jax jix aaꞌ gu Dios, noꞌ daix chu aaꞌ na gɨt xi chu biaꞌkaꞌ gux dhaꞌram namkɨm na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Baꞌ gu pariseos dai na mɨt xi aꞌsɨk gu Jesuus na puiꞌ kaiꞌch, nam guꞌ dai tuumiñ jix joojoiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Baꞌp ja tɨtda gu Jesuus: ―Aapiꞌm na pim pariseos jum tɨɨtɨꞌ sap pɨk baꞌ panaas joidham miꞌ puiꞌ xi jiim japim na jax jix aaꞌ Dios, guꞌ ji na guꞌ dai nam xi jam nɨiꞌñdhaꞌ pɨx gu jaꞌtkam, nam sap baꞌ pɨx jix bhaiꞌ jam aaꞌndaꞌ. Guꞌ ji na guꞌx bhaiꞌx maat gu Dios jam jujur am na pim jax pɨk jaꞌk jir tuꞌm, sia ku pim guꞌ yaꞌ ja bui gu jaꞌtkam tɨi puiꞌ xi chuꞌiiꞌ na pim jir kɨkɨɨꞌ. Na guꞌ yaꞌ ja bui gu jaꞌtkam, sia kum moox kɨɨꞌ nɨiꞌñ panaas gu tuꞌ, gu Dios cham kɨɨꞌ nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Guiꞌ nat jɨꞌk Moisees tu uaꞌnak na jax jaꞌk tu aagix kaꞌ, miꞌ pɨx juugɨt dhiꞌ bhaan tu aꞌga mɨt guiꞌ nam bhaankam ya oipimɨk gu Dios na paiꞌ gu Juan jaꞌtkam bopkondam. Miꞌ dhɨr bha jaꞌk maakam tuꞌm bhaiꞌ ji chum aꞌga na jax jaꞌk tuꞌt jix joiꞌmdat ja aꞌm ba tɨ nɨidhidhaꞌ gu Dios. Baꞌ dhiꞌ na jax chuꞌm tum aꞌga, bɨɨx tɨix maachik kat miꞌ puiꞌx jimiik am gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ku guꞌ bɨɨx miꞌ puiꞌm duiñchuꞌndaꞌ ji na jɨꞌk jax tu aagix nat tu uaꞌnak gu Moisees bɨjɨk, na guꞌ bɨɨx jum aaꞌ, cham tuꞌ puiꞌ na dhi dɨbɨɨr gio dhix dhaam na cham pɨk jum aaꞌ siat chi cham paiꞌ matgir jax chuꞌm tanoolh. ");
INSERT INTO stpNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Noꞌt jaroiꞌ maiꞌ xi buak gu bɨɨpɨꞌ kam bɨngaꞌn jumai bhaiꞌp ji bhɨi, cham tuꞌ puiꞌ ka ja ɨlhiiꞌñdhaꞌ gu Dios nam jir jum bɨpnagɨm kaꞌ. Gio gu ubii na maiꞌ buix kaꞌ noꞌt jaroiꞌ bhaiꞌp ji bhɨi, puiꞌ cham tuꞌ puiꞌp ja ɨlhiiꞌñdhaꞌ gu Dios nam jir jum bɨpnagɨm kaꞌ. Jaꞌp pɨx ba ja ɨlhiiꞌñdhaꞌ na jax guiꞌ nam jir ganaiꞌ pɨx. ");
INSERT INTO stpNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Maaꞌnnim maaꞌn gu maaꞌnkam jix jaiꞌch kaꞌ giilhim jix chumñigam. Gammɨjɨ joidham jix bhaiꞌ xim duukaꞌ kɨꞌn gux dhaꞌram namkɨm gu jajannulh, gio gammɨjɨ nabap tanoolh jix bhaiꞌ tu kuaꞌdaꞌ. Nammɨ ji chɨ kɨɨskaꞌ gu koiꞌ gam na joidham xi chu yooxmadhix kaꞌ bha jaꞌp. ");
INSERT INTO stpNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Baꞌ maaꞌn jup jix jaiꞌch kaꞌ gu maaꞌnkam Laasar tɨɨgim na gammɨjɨx kaꞌook kaꞌ kɨꞌn gu bipprɨꞌx na ɇɇkaꞌx kobkom bɨɨx na jɨꞌx tukgaꞌn. Pu cham jir tuꞌ biaꞌ kam kaꞌ ɨp. Dhiꞌ baꞌ gammɨjɨ miꞌ daakaꞌ kiꞌñgob na paiꞌ kiokaꞌ gux chumñigam, ");
INSERT INTO stpNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","na tɨi nɨɨrdaꞌ na iam ba makiaꞌ gɨt sia guiꞌ na bhaiꞌ dhɨr iigɨsdaꞌ na paiꞌ tu kuaꞌdaꞌ. Baꞌ gu goꞌngox mi aꞌjɨt jup tuspuniꞌñdhaꞌ am gu Laasar na paiꞌ jax jix bipprɨꞌxiꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Baꞌ maaꞌnnim ampɨx muu gu Laasar puiꞌ xim tulhiiñaimɨk, baidhak jamɨt baꞌx dhaam jaꞌk gu noonbiꞌñ gu Dios na buiñor bap tuiꞌkaꞌ gu Abraam na paiꞌ joidham jix chu abhaar. Baꞌ jɨꞌk jurniꞌñ kɨꞌn jup ma muu gux chumñigam, dhiꞌ dho gi guꞌ joidham jix bhaiꞌ duiñxim yaas jamɨt ji, guꞌ ji nat guꞌ pu jii mu jaꞌk na paiꞌm tulhiiñaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Baꞌ giilhim jix buam tu tatdaꞌ gux chumñigam na bam tulhiiñ ja bɨɨm guiꞌ na mɨt puiꞌ koi cham miꞌ puiꞌ ji jimɨɨk na jax jix aaꞌ gu Dios. Baꞌ mɨjɨmmɨ dɨr ba tɨɨ gu Laasar na bɨɨmaꞌn jup tuꞌiiꞌ gu Abraam. ");
INSERT INTO stpNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Baꞌp kaiꞌch gɇꞌ kɨꞌn: “Jiñ boxii Abraam, iam xiñ palhbuiꞌñ nañ yaꞌñ chulhiiñ tai chɨr. Xi chiñiaꞌ ap dhi Laasar na iam xi bargidhai gu deeꞌn gaꞌn bhañ juulhdharaꞌñ ñɨɨn am. Giilhim jix buam tu tatdaꞌ nañ jix chanoom.” ");
INSERT INTO stpNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Baꞌp kaiꞌch gu Abraam: “Jax dhui nat jix bhaiꞌ tum jii aap jiñ boxii nap duakat jum tuukuꞌ bhaan, guꞌ dhi Laasar jum tulhiiñaimɨk. Puiꞌ ku baꞌ xib ya oirɨñ bɨɨm na paiꞌx bhaiꞌ tu tatdaꞌ gammɨjɨ, na guꞌ puꞌñi jaꞌk jir maiꞌchɨk gaꞌn. Aap baꞌ miꞌ jaꞌk jum aꞌm bipioꞌ nap paiꞌ baꞌ bam tulhiiñ. ");
INSERT INTO stpNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gio guꞌ cham bhaaiꞌ na jaroiꞌ yaꞌ dɨr mu jaꞌk buusniaꞌ, ni mu dɨr bha jaꞌk, na guꞌ giilhim gɇꞌ ɨrban jix chɨꞌɨɨk. Jumai momkoram jup tuꞌiiꞌ ap aap, gio aach jumai kaꞌm ɨp.” ");
INSERT INTO stpNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Baꞌp kaiꞌch gux chumñigam: “Dho piam jap mu jaꞌk jootsaꞌ na paiꞌ kio guñ chaat. ");
INSERT INTO stpNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Miꞌ dharaa am jix chamaam guñ jaaduñ na ja aagiꞌñdhaꞌ na jax jaꞌk jix bhaaiꞌ nam dui cham bha jaꞌk bhɨɨyaꞌ ya tai chɨr nañ paiꞌ bañ chulhiiñ aañ. Giilhim jix buam tu tatdaꞌ guꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Baꞌ gu Abraam jup tɨtda: “Jax dhui nam biaꞌ guiꞌ nat Moisees tu uaꞌnak, gio gu jaiꞌ nam puiꞌ bhaankamuꞌn jup tu aꞌgimɨk gu Dios. Guiꞌ kaꞌm tu daa bɨɨx na tuꞌm aaꞌ nam pu duñiaꞌ nam baꞌ cham miꞌ jaꞌk bhɨɨyaꞌ. Dai ji nam tɨ jɨɨꞌñdhai miꞌ puiꞌ jimiaꞌ na jax jum kaiꞌch.” ");
INSERT INTO stpNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Baꞌp kaiꞌch gux chumñigam: “Puiꞌ dho tɨi nap jax kaiꞌch jiñ boxii, dai pɨx ji nam guꞌ cham tuꞌ jax ji chɨꞌji tɨ jɨɨꞌñdhaꞌ noꞌt jaroiꞌ muukɨk gio duadɨk jup ba tu ja aꞌgidhim.” ");
INSERT INTO stpNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Baꞌ gu Abraam jup tɨtda: “Puiꞌ pɨx ɨp ji matgɨm sia kut tuꞌ maaꞌnkam muukɨk gio duadɨk mi jaꞌp jup ba kɨɨk, pɨx ji noꞌm cham tɨ jɨɨgiꞌñ nat jax tu uaꞌnak gu Moisees, gio gu jaiꞌ nam bhaankamuꞌn gu Dios tu ja aꞌgidhimɨk gu jaꞌtkam, nam guꞌ dɨɨlh cham miꞌ puiꞌ jimiik kaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Baꞌp ja tɨtda ɨp gio gu Jesuus guiꞌ nam kaichuꞌ: ―Gammɨjɨ pɨx jix jaiꞌch kaꞌ am gu jaꞌtkam nam tu baidhidhaꞌ mu jaꞌk na paiꞌx chu uaꞌtulhdhix. Tɨiñ jix buam jiñ aaꞌndaꞌ bhaankam gu jaroiꞌ noꞌt jax dhuukat maadɨt aapiꞌm mu jaꞌk jam bhɨich na pim kiaꞌpɨx jiñ bui ba tɨ jɨɨgiꞌñ, na guꞌ miꞌ dhɨr cham bhaiꞌ ka tu jimiaꞌ na puiꞌ xi jam doodai. ");
INSERT INTO stpNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Iam chix bhaiꞌp tu jimiaꞌ ji nam bɨɨpɨꞌ dɨr mu pu ba buaꞌ suudaiꞌ chɨr, bha bulhdhai gu gɇꞌ mattur na chakui maadɨt jam iatgidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Baꞌ aapiꞌm xim nuukdat na cham jaroiꞌ jam iatgidhaꞌ. ’Noꞌt jax chuꞌm jam jaduuñ mam uaꞌtulh jam bui, xi aagiꞌñdhaꞌ pim na cham puiꞌ jaꞌk tu jimdaꞌ. Guꞌ baꞌ noꞌ guꞌ jax kaiꞌch na cham puiꞌ ka tuiꞌkaꞌ, aapiꞌm jup tu uañiꞌñkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sia chi moo xijum gookim gu tanoolh jum uaꞌtulh jum bui, tu uañiꞌñ kaꞌ ap noꞌt jaꞌkbuiꞌ kim puiꞌp jum tɨɨꞌn na cham puiꞌ ka tuiꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Baꞌ gu noonbiꞌñ gu Jesuus jup tɨtda am: ―Jich jaduuñ, jich aagiꞌñdhaꞌ ap nach jax jaꞌk jix ioꞌm buiñor jix biiñak kaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Baꞌ gu Jesuus jup ja tɨtda: ―Jax dhui na pu ni palhɨɨp ku pim iam jix biiñak buiñor gu Dios. Kani noꞌ pim sia jaꞌxbuiꞌ buiñor jix biiñak kaꞌ gɨt na jɨꞌx gu kaiꞌñ gu mostaasa, baꞌ noꞌ pim jax tɨtda dhi tua na miꞌñi kɨɨk na dɨɨlh jum takbunai mummɨm daasaꞌ na paiꞌ gɇꞌ suuꞌn gu suudaiꞌ, puiꞌ dhop ji buusniaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Noꞌ jaroiꞌ maadɨt aapiꞌm biaꞌ gu tujuandam, baꞌ noꞌt guꞌ tu biaꞌrak gu baak piam kut tu moikdarak, ni kup iam jax tɨɨdaꞌ na paiꞌ dhuuk miꞌ ba aayaꞌ kiicham: “Bi chu juꞌ. Bhaꞌñi bax chu bhai.” ");
INSERT INTO stpNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Guꞌ jaꞌpji jaꞌkbuiꞌ kat nap mi chiñiaꞌ na tu bhaidhai tum makiaꞌ. Nap paiꞌx bhaiꞌ xi koiꞌchoi nap baꞌp ba chiñiaꞌ na tu jugiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ni kup jup xi taxchaabgiꞌñdhaꞌ nax bhaiꞌ tum buixiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Baꞌ aapiꞌm puꞌñi na pim jir tujuandam buiñor gu Dios. Na pim paiꞌ dhuuk tɨɨmoidhaꞌ gu tuꞌ na jam chiandaꞌ, jaꞌp japim kaiꞌchdhaꞌ: “Ni jɨꞌx kuch cham jir kɨkɨɨꞌ tujuandam buiñor gu Dios, nach guꞌ cham tuꞌ dɨɨlh jaiꞌ tuꞌ pup jax xi bua, daipuꞌ na jax pɨx jich chian.” ");
INSERT INTO stpNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Baꞌ gu Jesuus na Jerusaleen jaꞌk jim, mi jaꞌp aꞌjim na paiꞌ jax Galilea bhaan bipioꞌ gu dɨbɨɨr gio na paiꞌ jax Samaaria bhaan jup bipioꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Baꞌ na maaꞌn kap ba aajim na paiꞌ jɨꞌdɨlh jir kikcham, yammɨ dɨr jaꞌp muiꞌ ba tɨ nɨiꞌñ am mambhɨɨx gux kakoꞌkkam na ja ɇɇkaꞌ guiꞌ na tootolhidhat gakiidhaꞌ gu ja tutkuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Baꞌ muiꞌ ba jiiñkaiꞌñ am gu Jesuus, jup kaiꞌch am: ―¡Xich dhuduaꞌñdhak jich jaduuñ! ¡Iam jap xich joiꞌmdat xich chɨgiaꞌ! ");
INSERT INTO stpNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Baꞌ nat ba ja tɨɨ gu Jesuus, jup ja tɨtda: ―Ja bui pim xi jimiaꞌ guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam bhaiꞌ gɇꞌ chiop, nam jam tɨgiaꞌ na pim bax kɨkɨɨꞌ. Baꞌ nam gamaiꞌ ka jiimchuꞌ, joidham jix bhaiꞌ bhaiꞌ ji chu tatdat, bax kɨkɨɨꞌ gu ja tutkuꞌ nam xim nɨnɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Baꞌ maadɨt miꞌ dhɨr pu jaꞌk gɨi nat bam tɨɨ na bax kɨɨꞌ xi taxchaabgidhidhat gu Dios gɇꞌ kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Sɨlh jii ɨp gio mu na paiꞌ gu Jesuus, baꞌ miꞌ oꞌlhiaꞌn kɨꞌn xi kɨkbok ba taxchaabgiꞌñ nat ba duaꞌñ. Jir Samaaria kam gu maaꞌnkam. ");
INSERT INTO stpNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Baꞌp kaiꞌch gu Jesuus: ―¿Kux cham tuꞌr mambhɨɨxiꞌñ am aa gux kakoꞌkkam na ñich ja duduaꞌñ? ¿Pu jii mɨt aa baꞌ gu xijum maakob? ");
INSERT INTO stpNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dai bak baꞌ dhiꞌ na cham jir Israel kam bhaiꞌ xi jii nat bha taxchaabgidham gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Baꞌp tɨtda gu maaꞌnkam puiꞌ xi chɨꞌɨɨk: ―Pu ba dua pich ji matgɨm jiñ jaduuñ, chaꞌp jax kam aaꞌndaꞌ, na pich guꞌ bɨɨx jum jur kɨꞌn tɨ jɨɨꞌñ buiñor gu Dios. Ba jimiaꞌ ap xi kɨkboi. ");
INSERT INTO stpNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Baꞌ gu pariseos bhaiꞌ ba tɨkkaꞌ am gu Jesuus na paiꞌ baꞌ duuk jum aayaꞌ gu tanoolh na gu Dios jix ja joiꞌmdat ja aꞌm tɨ tɨgiaꞌ gu jaꞌtkam. Baꞌp ja tɨtda: ―Jax dhui na pim cham tuꞌ maaxik tɨgiaꞌ na paiꞌ dhuuk gu Dios jix joiꞌmdat ja aꞌm tɨ tɨgiaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Cham tuꞌ pim jax tɨꞌyaꞌ: “Jaña, miꞌñi ba ai.” Piam jaꞌpni: “Bhaiꞌ sap paiꞌ ba ai.” Guꞌ gu Dios pu xib na yaꞌx joiꞌmdat ja aꞌm ba tɨ nɨidhim gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Baꞌp ja tɨtda dai guiꞌ nam jɨꞌk kaichuꞌ: ―Aapiꞌm jax chuꞌm tanoolh gio tɨip ba xiñ chɨɨgik kaꞌ maaxik jaꞌp na jax xib, guꞌ ji na pim guꞌ cham paiꞌ kañ chɨgiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Jaiꞌ dhɨt bhaiꞌ ji jam iatgiꞌñdhaꞌ am gu jaꞌtkam, jup kaiꞌchdhaꞌ am: “Miꞌñi ba ai guch Xoiꞌkam.” Piam moo jax kaiꞌchdhaꞌ am: “Muni sap paiꞌ ba ai guch Xoiꞌkam.” Chaꞌpim miꞌ ja jɨɨgiꞌñdhaꞌ, na guꞌ cham jir sɨlhkam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Na guꞌ nañ paiꞌ dhuuk gio bhaiꞌp jimdaꞌ, jaꞌp tuꞌt ya aayaꞌ iñ na jax gu duuk noꞌt bɨpgɨ na jotmodaꞌ muiꞌ kap tum tonniaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ku guꞌ bɨɨpɨꞌm aaꞌ ji nam jiñ chulhiiñchudaꞌ gu jaꞌtkam nam xib yaꞌx jaiꞌch, nam guꞌ cham jiñ kɨɨgalhdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Baꞌ janoꞌ na ba miamlhidhaꞌ nañ gio bhaiꞌp jimdaꞌ, cham tuꞌp jum buixiꞌñdhaꞌ am gu jaꞌtkam, pu cham jɨɨgiꞌñdhaꞌ am gu jaroiꞌ sia ku tɨi ja aagiꞌñ. Puiꞌ ɨp na jax janoꞌ nat tɨs gu suudaiꞌ, na tɨi pup ja aaꞌñdhimɨk gu Noee gu jaꞌtkam na jax tum duñiaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","guꞌ ji nam guꞌ pu cham jɨɨgiꞌñdhaꞌ. Cham tuꞌp jum buixdhat tu kuaꞌdaꞌ am, jix maik kaꞌ am, gio nam jum tɨtmodaꞌ. Janoꞌ baꞌ tɨi pɨx gan tɨ tɨɨ mɨt nat paiꞌ dhuuk giilhim jix ioꞌm bhaiꞌ ji dhuuꞌn, guꞌ ji na guꞌ gu Noee pu ɨrban dɨr jix bhaiꞌ baꞌ kuupchuꞌ bhaan gu kanuub. Pu koi mɨt dho guꞌ bɨɨx bhaiꞌkuk. ");
INSERT INTO stpNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Gio janoꞌ ɨp na gu Lot, dai guiꞌ miꞌ puiꞌ jimdaꞌ na jax jix aaꞌ gu Dios. Gu jaiꞌ jaꞌtkam cham tuꞌp jum buixdhat tɨ ɨsdat tu kuaꞌdaꞌ am, sia ku puiꞌ tɨip ja aagiꞌñdhaꞌ. Jix maik kaꞌ am, jaiꞌ tu sabaꞌndaꞌ am, jaiꞌ tu gaꞌradaꞌ am, jaiꞌ tu baꞌpkichaidhaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Baꞌ dai tai pɨx miꞌ ba duuꞌn nam cham pum aaꞌ, miꞌ pɨx pu tum totpok dɨbɨɨr taꞌm. Gu Lot guꞌ pu bɨɨpɨꞌ dɨr ba jimiññor miꞌ dhɨr Sodooma nat chakui tai duuꞌn. Baꞌ pu bɨɨx koi mɨt guiꞌ nam mi oiꞌñkat, nim maaꞌn kut bii. ");
INSERT INTO stpNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aañ baꞌ puꞌñi ɨp janoꞌ nañ gio bhaiꞌp jimdaꞌ yaꞌ dhi oiꞌñgaꞌn, cham tuꞌp jum buixiꞌñdhaꞌ am gu jaꞌtkam sia kum jaiꞌ dhɨt tɨi ja aagiꞌñ. Yaꞌ pɨx pu bañ maaxdhaꞌ iñ nam cham pum aaꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Baꞌ janoꞌ na paiꞌ dhuuk jum aayaꞌ guiꞌ gu tanoolh, noꞌ jaroiꞌ maadɨt aapiꞌm bhaiꞌ paiꞌ ka daa baꞌk dhaam, bhaiꞌ dhɨr jap tɨmnɨi pu jimiññolhiaꞌ. Chaꞌp mɨjɨ ka bapkɨdaꞌ baꞌk chɨr nap tuꞌ xi bhɨɨji. Piam noꞌ jaroiꞌ mu ka oirɨ gaꞌram, miꞌ dhir gammɨjɨ jaꞌk pu jimiññolhiaꞌ. Cham tuꞌ na jax jum aaꞌndaꞌ na mummɨ ka xi ñorgɨraꞌ kiaꞌmiꞌñ na baꞌ pɨk ba jimiññolhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Jax japim gix maat nat tu dooda bɨjɨk gu Lot gu bɨngaꞌn, puꞌñi dhop tu jam doodaꞌ noꞌ pim dai bhaan tɨtɨɨꞌñcho gu jam bɨxchuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Na guꞌ gu jaroiꞌ noꞌ dai bhaan tɨtɨɨꞌñcho gu tuꞌ na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch, cham jɨꞌxkat palhbuidhaꞌ na jax jaꞌk jix bhaiꞌ tu jimiaꞌ gatuuk. Guꞌ ji noꞌt guꞌ cham tuꞌp jim buixdhak miꞌ puiꞌ xi chu duu na jax jix aaꞌ gu Dios, jix bhaiꞌ ji na tu jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Baꞌ noꞌ janoꞌ pɨk jir tukaaꞌ nañ paiꞌ dhuuk gio bhaiꞌp jimdaꞌ, noꞌm gook maap miꞌ paiꞌ ka boobok gu jaꞌtkam, maaꞌn pɨx jañ baidhikaꞌ, gu jumai baꞌ miꞌ pup biꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Piam noꞌ ñich guꞌ tataab jaꞌk yaꞌ ai, noꞌm gook maap miꞌ paiꞌ ka tu tuaꞌ gu uꞌuub, maaꞌn pɨx jañ jup baidhikaꞌ, maaꞌn miꞌ pup biꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Piam noꞌm gook gu jaꞌtkam mu paiꞌ ka oipo gaa tɨr, puiꞌ maaꞌn pɨx jañ jup baidhikaꞌ, gu jumai miꞌ pup biꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Baꞌ bhaiꞌ ba tɨkka am guiꞌ nam kaichuꞌ, jup tɨtda am: ―¿Jich jaduuñ, yaꞌ aa baꞌ puiꞌ tum duñiaꞌ, kaꞌ maakam jaꞌk aa? Baꞌ gu Jesuus jup ja tɨtda: ―Dho na pim jax bax maat noꞌm paiꞌ pɨx xikoolh jiim gu nunnui na guꞌ bhaiꞌ tu muukix kaꞌ, puꞌñip jix maatɨꞌ kaꞌ janoꞌ na paiꞌ dhuuk puiꞌ ba tum duñiidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Baꞌ gu Jesuus bhaan ji chu uaꞌrgidhak maaꞌn gu ubii gio maaꞌn gu gɇꞌkam, ba ja aagiꞌñ guiꞌ nam kaichuꞌ na bhaan ja guguuxiꞌñ nam cham jim oꞌjolhdhat gammɨjɨ tu daandaꞌ buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jup ja tɨtda: ―Maaꞌnnim maaꞌn gu maaꞌnkam maaꞌn kap jir gɇꞌkam kaꞌ, na paiꞌ muiꞌ paꞌ daaꞌñxim jir kikcham kaꞌ. Cham tuꞌ kaꞌm ja nɨiꞌñdhaꞌ gu jaꞌtkam dhiꞌ dhi gɇꞌkam, ni gu Dios ku tuꞌ kaꞌm nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Baꞌ miꞌp jix jaiꞌch kaꞌ maaꞌn gu dɨɨlhdhɨm ubii nat muu gu bɨngaꞌn. Dhiꞌ miꞌ tɨi aꞌjɨdaꞌ na paiꞌ daakaꞌ guiꞌ gu gɇꞌkam na pu tɨtdadaꞌ na bhaankam nokiaꞌ nam kokdadaꞌ gu jaꞌtkam mu na paiꞌ kio, ");
INSERT INTO stpNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","guꞌ ji na guꞌ cham tuꞌp jum buixiꞌñdhaꞌ. Muiꞌ tanoolh jup duu na cham tuꞌp jum buixiꞌñdhaꞌ gu gɇꞌkam buiñor gu dɨɨlhdhɨm ubii. Baꞌ maaꞌnnim jup jum aaꞌ: “Gi noꞌ ñich aꞌmkamuꞌn jup ñio dhi ubii ku cham kañ juandaꞌ, sia kuñ tɨi cham tuꞌ kaꞌm ja nɨiꞌñ gu jaꞌtkam, ni gu Dios kuñ tuꞌ kaꞌm nɨiꞌñ. Jir maaꞌn na bha jaꞌk jiñ chooñiꞌñ.” ");
INSERT INTO stpNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Baꞌ puiꞌ xi chɨꞌɨɨk jup ja tɨtda ɨp gio guiꞌ nam kaichuꞌ: ―Dho jaña nat siamri dakoo aꞌmkam ma ñio gu gɇꞌkam gu dɨɨlhdhɨm ubii na cham jum jɨɨpiꞌñkaꞌ na pu tɨtdadaꞌ, sia ku guꞌ tɨi cham tuꞌ kaꞌm tɨ nɨiꞌñ guiꞌ gu gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Aapiꞌm baꞌ cham puꞌñip jam kaayaꞌ aa jax noꞌ pim tɨtda gu Dios nat jam aꞌm tɨ tɨɨ na pim jir jaꞌtkam tugiꞌñ kaꞌ, noꞌ pim gammɨjɨ puiꞌ tɨtda nabap tanoolh gio nabap tukaaꞌ? ¿Kaꞌ guꞌ ka ji mɨɨkidhaꞌ aa panaas na baꞌ pɨk jix joiꞌmdat ba jam tɨgiaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Matgɨm moo janoꞌ ji na jam palhbuidhaꞌ, cham tuꞌ na guꞌ mɨɨkidhaꞌ, aañ moo yaꞌ pu jam tɨtda. ¿Siamriñ chi baꞌ gio yaꞌp ja tɨgiaꞌ aa gu jaꞌtkam dhi oiꞌñgaꞌn bhaan nam jiñ bui tɨ jɨɨgiꞌñdhaꞌ janoꞌ nañ gio bhaiꞌp jimdaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Baꞌ jaiꞌ dhɨt gu jaꞌtkam gɇꞌgɇrkam jum taat kaꞌ am nam chi sap panaas miꞌ puiꞌ jiim na jax jix aaꞌ gu Dios, guꞌ baꞌ gampaiꞌ ja ɨlhiiꞌñdhaꞌ am gu jaiꞌ jaꞌtkam. Baꞌ gu Jesuus jumai bhaan jup xi chu uaꞌrgidhak ba ja aagiꞌñ nam baꞌx maatɨt kaayaꞌ, jup ja tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Maaꞌnnim gook gu jaꞌtkam ma jii mɨt maaꞌn kap chiop na mɨt tu daañim jix dhaam jaꞌk buiñor gu Dios. Maaꞌn jir pariseo, jumai baꞌ maadɨt jir diꞌ guiꞌ nam jir tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam. ");
INSERT INTO stpNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Baꞌ gu pariseo puiꞌ kɨɨkat jix dhaam jaꞌk xi chɨ tɨɨgɨk muiꞌ ji chu daanɨ buiñor gu Dios, jup kaiꞌch: “Moo taxchaab baꞌ Gɇꞌkam Dios nap jiñ palhbuiꞌñchuꞌ nañ miꞌ puiꞌ jim nap jax jix aaꞌ. Cham jañ tuꞌr jix ɨxkum na jax jaiꞌ gu jaꞌtkam nam giilhim jix ɨꞌxbiꞌ, ni kuñ jir pu chuꞌm na jax jaiꞌ nam maiꞌ xi ja iabut gu ja bɨpnaꞌ jaiꞌ bhaiꞌ ji ja uꞌ. Cham jañ paiꞌ dhuuk jix buam jum duukam jup tu bua. Jum taxchaabgiꞌñ iñ ɨp sia na pich cham tuꞌ pu chuꞌm yaꞌñ dhoꞌñcho dhi oiꞌñgaꞌn bhaan nañ jir tuumiñ tutaandam tugiꞌñ kaꞌ gux ioꞌm gɇꞌkam Rooma kam, jaꞌp na dhiꞌ na bhaiꞌ dhɨr kɨɨk. Giilhim jix uꞌuaꞌtulhdhix am guꞌ gu pu chuutuꞌm. ");
INSERT INTO stpNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aañ gookim jiñ xaabdaꞌ na giop bam aayaꞌ na paiꞌ dhuuk cham tum juandaꞌ. Gio gu tuꞌ nañ maiꞌchidhaꞌ nañ tu juandaꞌ, gammɨjɨm maakidhaꞌ iñ na jɨꞌk jum aꞌm jup bipioꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Baꞌ gu tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam jaꞌx mɨk paꞌ ji kɨkbo, ni ku iam xim guguuxiꞌñ nax dhaam jaꞌk xi chɨ tɨgiaꞌ, dai na bhaiꞌ xim gɨbdat bhaastuꞌn jup kaiꞌch: “Aapiꞌ Gɇꞌkam Dios, xiñ joiꞌmdaip iam jiñ uañdhaꞌ guñ uaꞌtulhdharaꞌ nañ giilhim jix uaꞌtulhdhix.” ");
INSERT INTO stpNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Baꞌ aañ yaꞌ pu jam tɨtda nat gu tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam ba jii kiaꞌmiꞌñ uañchudhix kam gu uaꞌtulhdhar gaꞌn, guꞌ baꞌ gu pariseo cham. Na guꞌ cham tuꞌ joiꞌmdat nɨiꞌñdhaꞌ gu Dios gu jaroiꞌ noꞌ dai gɇꞌkam jum taat, guꞌ guiꞌ ji na soiꞌm ɨlhiiꞌñdhaꞌ na baꞌx joiꞌmdat nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Baꞌ jaiꞌ dhɨt gu jaꞌtkam muiꞌp ba aichulhdhim am gu Jesuus gu ja aꞌaalh chuk nam jix aaꞌ na ja aꞌmkam tu ja daañxidhaꞌ. Guꞌ ji na guꞌ na mɨt paiꞌ dhuuk ja tɨɨ gu noonbiꞌñ gu Jesuus, ba ja ñiok jamɨt pɨx gu jaiꞌ nam muiꞌ tɨip ba ja uaꞌkat gu ja maamar. ");
INSERT INTO stpNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Baꞌ dɨɨlh gu Jesuus xi ja baidhak gu noonbiꞌñ jup ja tɨtda: ―Chaꞌpim ja sosbhichulhiꞌñdhaꞌ dhi jaꞌtkam nam bha ja uaꞌ gu ja maamar, na guꞌ puꞌñi chuꞌm ja aꞌm jum aaꞌ gu jaꞌtkam nam jir tuꞌm kaꞌ na baꞌx joiꞌmdat ja aꞌm tɨ nɨidhidhaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cham jɨꞌxkat jaroiꞌ aayaꞌ buiñor gu Dios noꞌt cham puiꞌm ɨlh na jax gu alhii, aañ moo yaꞌ pu jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Baꞌ maadɨt guiꞌ nam jir ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam jup tɨtda gu Jesuus: ―Aañ jaꞌp tuꞌm xim tɨkkam jiñ jaduuñ, aap nap jir jix bhaiꞌkam. ¿Jax jaꞌk jix bhaaiꞌ nañ xi chu duñiaꞌ nañ baꞌ maiꞌchiaꞌ nañ jimiaꞌ buiñor gu Dios nañ gammɨjɨ buiñor bap tuiꞌkaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Baꞌp tɨtda gu Jesuus: ―¿Jaꞌp kaiꞌñkam jup kaiꞌch ap aañ jaduuñ nañ aañ jaꞌxbuiꞌp jir jix bhaiꞌkam na gu Dios? Na guꞌ dai guiꞌ nar jix bhaiꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gio guꞌ guiꞌ nap tuꞌñ chɨkka, jix maat ap na jax tu aagix na tu uaꞌñix gu ñioꞌkiꞌñ gu Dios nap tuꞌ jax dhuñiaꞌ. Jaꞌpni bom kaiꞌch: “Chaꞌp naiꞌ pɨx ja bɨɨm boppodaꞌ gu uꞌuub, daipuꞌ gu jax chuꞌm nar jum bɨɨnaꞌ kaꞌp pu bɨɨmaꞌn tu kiokaꞌ gammɨjɨ nap jɨꞌx duakaꞌ. Gio nap cham ja kooꞌndaꞌ gum bɨpnaꞌ jaꞌtkam. Ni kup cham tɨ ɨɨxiꞌñdhaꞌ. Ni kup cham iatbiꞌ kaꞌ. Gum taat jap tuꞌ kaꞌm jup nɨiꞌñdhaꞌ gio gum naan.” ");
INSERT INTO stpNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Baꞌp kaiꞌch gu gɇꞌkam: ―Dho bɨɨx jañ puiꞌ tɨi pu tu duiñchuꞌ na ñich dhɨr bhaiꞌñ jur ji bhɨi. ");
INSERT INTO stpNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Baꞌp tɨtda gu Jesuus nat puiꞌ tɨi: ―Ka biꞌiix ji guꞌ maaꞌn nap pu duñiaꞌ. Bɨɨx jap tu gaꞌrai nap jɨꞌk tuꞌ tu biaꞌ ja makiaꞌ gu tuumiñ guiꞌ nam cham tuꞌ biaꞌ ni jɨꞌx, bhaiꞌp baꞌ xi jimiaꞌ nap bañ kaichgɨdaꞌ. Puꞌñi jaꞌk jap baꞌ bar jix chumñigam kaꞌx dhaam buiñor gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Baꞌ gampaiꞌ ji dhuu gu gɇꞌkam nat puiꞌ xi chɨɨꞌn gu Jesuus, jix buam jum ɨlh, na guꞌ giilhim jir jix chumñigam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Baꞌ na bhaiꞌ xi ñɨiꞌñ gu Jesuus nat jix buam jum ɨlh, jup kaiꞌch: ―¡Jaꞌp moox xijaim ɨlhiiꞌñ am gux chutumñigam nam miꞌ puiꞌ jimiaꞌ na jax jaꞌk jix joiꞌmdat ja aꞌm ba tɨ nɨidhidhaꞌ gɨt gu Dios! ");
INSERT INTO stpNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gu kameeyo chi iam cham xijaim jup ɨlhiiꞌñ ji na bhaiꞌ baakɨi buiꞌram gu soomkar jaꞌp dɨr jaꞌk buusniaꞌ, cham tuꞌ puiꞌ na gux chutumñigam nam jix xijaim ɨlhiiꞌñ nam miꞌ puiꞌ jimiaꞌ na jax jaꞌk jix joiꞌmdat ja aꞌm ba tɨ nɨidhidhaꞌ gɨt gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Baꞌ jaiꞌ dhɨt guiꞌ nam tɇ kɇɇ, jup tɨtda am gu Jesuus: ―¡Dho bak guꞌ cham jɨꞌxkat jaroiꞌ buiñor aayaꞌ gu Dios, na guꞌ puiꞌx xijai nach miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ! ");
INSERT INTO stpNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Baꞌp ja tɨtda gu Jesuus: ―Jax dhui na cham tuꞌ xijaim ɨlhiiꞌñdhaꞌ gu Dios gu tuꞌ nam gu jaꞌtkam jix xijaim ɨlhiiꞌñdhaꞌ, na guꞌ bɨxchuꞌx bhaaiꞌ na pu tu duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Baꞌ gu Peegro miꞌ dhɨr jaꞌp jup tɨtda: ―Dho puiꞌ na jax aach na chich cham tuꞌ kap jich buix gu tuꞌ nach ka biaꞌkat janoꞌ na chich paiꞌ dhuuk tɨ jɨɨꞌñdhak jum bɨɨm ba jiiñ jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Baꞌp ja tɨtda bɨɨx gu Jesuus: ―Noꞌt jaroiꞌ cham tuꞌ bhaan kap jum buix gu taataꞌn gio gu dɨꞌɨɨꞌn, piam gu xiixiogiꞌñ, piam gu sɨspidhiꞌñ, piam gu bɨngaꞌn, piam gu maamraꞌn, piam gu tuꞌ na biaꞌkaꞌ, puiꞌ na gu baꞌkiꞌñ, ganaiꞌ bɨɨx aixim, baꞌ dai nat pɨx bhaan ji bam na puiꞌ ba tu duñiim na jax jaꞌk jix joiꞌmdat bhaan ba tɨ nɨidhidhaꞌ gu Dios, aañ yaꞌ pu jam tɨtda na cham jax bua. ");
INSERT INTO stpNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Na guꞌx ioꞌm muiꞌ ba tu iimchuxdhaꞌ gu Dios pu yaꞌ na ka duakaꞌ dhi oiꞌñgaꞌn bhaan, cham tuꞌ jaꞌkbuiꞌ na jɨꞌk cham tuꞌ bhaan jup jum buixdhaꞌ bɨɨpɨꞌ dɨr. Gio daman pup na xi baidhikaꞌ jix dhaam na buiñor bap tuiꞌkaꞌ gammɨjɨ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Baꞌ jaꞌp jaꞌk dɨlhkob xi ja boosgak gu Jesuus dai gu mambhɨɨx daman gook gu noonbiꞌñ jup ja tɨtda: ―Xib jach baꞌ sɨlh muiꞌ pu ba jimiaꞌ Jerusaleen, bhaiꞌ na paiꞌ puiꞌ ba tum duñiaꞌ baꞌ na mɨt jɨꞌk jax tu uaꞌnak nam aañ jiñ aagɨt jup kaiꞌch guiꞌ nam bɨjɨk bhaankam ya jaꞌp tu aꞌgimɨk gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gu Israel kam jaꞌtkam jam maaxik jiñ kɨɨsaꞌ ja bui guiꞌ nam cham jir Israel kam, guiꞌm baꞌ bɨɨx aixim jiñ buimɨi nam jax ɨlhiiꞌñ, bhañ xixbuidhaꞌ am, jiñ asdam baꞌ puiꞌ xiñ buaꞌt. ");
INSERT INTO stpNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Gio nam jiñ gɨbiimɨi, miꞌ dhɨr jam ampɨx jiñ muꞌaaꞌ. Ku baꞌ guꞌ aañ baik tanoolh kɨꞌn yaaꞌ ji nañ jax ba oirɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Baꞌ gu noonbiꞌñ pu ni jɨꞌx ku mɨt jix maatɨt kai na jax kaiꞌñkam jup kaiꞌch, pu cham maatɨt kai mɨt na jax kaiꞌñkam jup ja tɨtda. Na guꞌ puiꞌ na jax ja tɨtda gu Jesuus, jix xijai na jaroiꞌx maatɨt kaayaꞌ gu miꞌ jotmodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Baꞌ nammɨ na miaꞌn ba aajim gu Jesuus na paiꞌ Jerikoo tɨ tɨɨꞌ, maaꞌn gu maaꞌnkam cham ñia kam mi jaꞌp daakat boi jugiiꞌñ tu taan gu tuumiñ nam onbaiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Baꞌ nat ba ja kai nam muiꞌ mi jaꞌp pɨx kaiꞌch gu jaꞌtkam nam buan, ba tɨ tɨkka na tuꞌ jax jum bua. ");
INSERT INTO stpNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Baꞌp tɨtda am na Jesuus Nasareet kam mi jaꞌp jim muiꞌ ja bɨɨm gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Baꞌ ba jiiñak gɇꞌ kɨꞌn gu cham ñia kam, jup kaiꞌch: ―¡Jesuus, boxiiꞌñ gu Dabii! ¡Iam jap xiñ joiꞌmdai xiñ chɨɨgɨi xiñ dhuaꞌñdhai! ");
INSERT INTO stpNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Baꞌ gu jaꞌtkam guiꞌ nam bɨɨpɨꞌ dɨr jiim, jup tɨtda am tɨi na cham ñiokat daakaꞌ, guꞌ ji na guꞌ guiꞌx ioꞌm gɇꞌ kɨꞌn muiꞌ ba xi jiiñak, jup kaiꞌch: ―¡Boxiiꞌñ gu Dabii! ¡Iam jap xiñ joiꞌmdai xiñ chɨɨgɨi xiñ dhuaꞌñdhai! ");
INSERT INTO stpNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Baꞌ miꞌ pup kɨɨk gu Jesuus nat kai, mɨjɨ xi chu joot baꞌ nam mu baiꞌñxidhikaꞌ. Baꞌp tɨtda na mɨt miꞌ ba aich: ");
INSERT INTO stpNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Tuꞌni aañ kɨꞌn jum palhbuidhaꞌñ jaduuñ? Baꞌ guiꞌp kaiꞌch: ―Dho nañ tɨix aaꞌñ jaduuñ nap jiñ dhuduaꞌñxidhaꞌ dhiñ buupui nañ cham ñia. Tɨix chɨ tɨɨgim iñ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Baꞌp tɨtda gu Jesuus: ―Pu bax kɨkɨɨꞌ ji matgɨm jiñ jaduuñ, na pich guꞌ bɨɨx jum jur kɨꞌn jiñ bui ba tɨ jɨɨꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Baꞌ bhaiꞌ ji chɨ tɨɨ gu cham ñia kam nat puiꞌ xi chɨɨꞌn gu Jesuus, jix kɨɨꞌp jum duu. Baꞌ dai nat ba oi gu Jesuus xi taxchaabgidhidhat gu Dios jix dhaam jaꞌk. Sia puiꞌp xi taxchaabgidhim am gu Dios guiꞌ na mɨt jɨꞌk tɨɨ nat duaꞌñ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Baꞌ miꞌ ba ai gu Jesuus na paiꞌ Jerikoo tɨ tɨɨꞌ, muiꞌ ji bhɨi ɨrban na paiꞌr kikcham. ");
INSERT INTO stpNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Baꞌ maaꞌn miꞌp kiokaꞌ gux chumñigam Sakeo tɨɨgim, dhiꞌ maadɨt jir diꞌ kaꞌ guiꞌ nam jir ja gɇꞌgɇrkam tuk gu tuumiñ tutaandam tugiꞌñ gux ioꞌm gɇꞌkam Rooma kam. ");
INSERT INTO stpNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Baꞌ tɨix chɨɨgim gu Jesuus na mi jaꞌp jim, guꞌ ji nam guꞌ giilhim jix kobkom mu jiim gu jaꞌtkam. Gio na guꞌ cham jir tɇb kaꞌ gu Sakeo, ja juraab pɨx juꞌnkaꞌ gu jaꞌtkam. Mɨjɨ dɨr jaꞌp baꞌ tɨi mɨmlhim ja bɨɨbhiꞌ, guꞌ ji na guꞌ cham paiꞌ dhɨr jir joidham na tɨgiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Puiꞌ baꞌ bɨɨpɨꞌ dɨr daiꞌññɨk maaꞌn tua taꞌm tɨs na sap baꞌ bhaiꞌ dhɨr tɨgiaꞌ na mi jaꞌp ji buusniaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Baꞌ am pup tɨɨ gu Jesuus gu Sakeo na bhaiꞌ dhaa tua taꞌm nat mi jaꞌp ji buus, baꞌp tɨtda: ―Sakeo, xi chɨmnɨk bhaiꞌ dhɨr tua taꞌm maiꞌ xiñ baidhak mum kiꞌaam kuñ miꞌ xi chɨbiapui. ");
INSERT INTO stpNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Baꞌ jotmodaꞌ xi chɨmnɨk bhaiꞌ dhɨr tua taꞌm gu Sakeo ba baidhak gu Jesuus mu na paiꞌ kio cham jax ji chɨꞌɨɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Baꞌ bhaiꞌ ji bhaak jamɨt bɨɨx gu jaꞌtkam nam jɨꞌk jiim, sap nat gan mi ai gu Jesuus buiñor gux uaꞌtulhdhix kam. ");
INSERT INTO stpNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Baꞌ gu Sakeo xi kɨkbok jup tɨtda gu Jesuus: ―Aañ jaꞌpni ɨlhiiꞌñ jiñ jaduuñ. Bɨɨx nañ jɨꞌk tuꞌ tu biaꞌ, ɨrban juugɨt jañ ja makiaꞌ guiꞌ nam cham tuꞌ biaꞌ ni jɨꞌx. Guꞌ baꞌ noꞌ ñich jaroiꞌ tuꞌ ɨɨx, maakobim jaꞌkbuiꞌñ jaꞌk buidhaꞌ jɨꞌk nañ tɨ ɨɨxdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Baꞌ gu Jesuus jup tɨtda: ―Puꞌjani jaꞌk jir tuꞌm kaꞌ am guiꞌ nam tuꞌ sɨlhkam jir bopxiꞌñ kaꞌ gu Abraam. Aap baꞌ xib yaꞌ dɨr jaꞌp jaꞌk cham tuꞌ mu jaꞌk ka jim nap paiꞌ gammɨjɨ gɨt miꞌ pup jum tulhiiñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Dhiꞌ jɨꞌ ji na ñich bha ja gaagam na mɨt jumai boi bhaan bhɨi na paiꞌ maiꞌx chɨ gɨɨxiꞌ, aañ na ñich bhaankam bha jii gu Dios. Baꞌ guiꞌ nañ jɨꞌk ja tɨɨgim, gio miꞌp ja tuttuim iñ bhaan gu boi na paiꞌ cham maiꞌ ka tɨ gɨɨxiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Baꞌ gu jaꞌtkam tɇ kɇɇ am na miꞌ puiꞌ tu aꞌga gu Jesuus. Baꞌ xi chu uaꞌrgidhak bhaiꞌ ji chu ja aꞌgi, nam guꞌ jaꞌp jum aaꞌ na dai pɨx noꞌt bhammɨ ba ai gu Jesuus Jerusaleen, dai na gɇꞌkam kɨꞌn ba daasaꞌ gu Dios na baꞌ gɇꞌkam kɨꞌn bhaiꞌ ji chɨ sɨlhkadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jup ja tɨtda: ―Maaꞌnnim maaꞌn jix jaiꞌch kaꞌ gu maaꞌnkam na giilhim jir jix chumñigam kaꞌ. Baꞌ dhiꞌ dhix chumñigam jumai momkoram dɨr baiꞌñ am nam gɇꞌkam kɨꞌn daasaꞌ, gio baꞌ bhaiꞌp jimiaꞌ dai nam gɇꞌkam kɨꞌn xi dhaasaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Baꞌ maap xi ja jumpadak mambhɨɨx gu tujuandam tugiꞌñ, xi ja maakak baꞌ muiꞌ gu tuumiñ bɨɨx jɨꞌmaꞌn, jup xi ja tɨɨdak: “Aapiꞌm yaꞌ kɨꞌn ka tu juandaꞌ dhi tuumiñ. Jix ioꞌm muiꞌ pim ba muiꞌdhalhdhaꞌ nañ gio jaꞌk jup gɨxiaꞌ.” Baꞌ ba jii puiꞌ xi ja tɨɨdak. ");
INSERT INTO stpNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Baꞌ gu miꞌ kam jaꞌtkam cham jup kɨɨgalhiꞌñdhaꞌ am, bɨɨpɨꞌ mɨt baꞌ mɨjɨ xi ja joot jaiꞌ nam bhammɨ pu tɨꞌyaꞌ nam cham aaꞌ na dhiꞌr ja gɇꞌkam tuk kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Guꞌ ji na mɨt guꞌ sia puiꞌ gɇꞌkam kɨꞌn dai, gio baꞌ bhɨjɨp ji dhuu. Baꞌ miꞌ ɇɇk naiꞌ ji chu ja joochxi bɨɨx jɨꞌmaꞌn gu tujuandam tugiꞌñ na bax maachim na mɨt jɨꞌk muiꞌdhalh gu tumñigaꞌn nat miꞌ ja doꞌñchidhak. ");
INSERT INTO stpNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Baꞌp kaiꞌchim guiꞌ nat bɨɨpɨꞌ miꞌ ai: “Yaꞌni baꞌ gum tumñiꞌ. Mambhɨɨx jaꞌkbuiꞌ pup jañich muiꞌdhalh na pich jɨꞌk yaꞌñ dhoꞌñchidhak.” ");
INSERT INTO stpNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Baꞌ gu gɇꞌkam jup tɨtda: “¡Aa guꞌ joidham ji jia! Jir jix kɨɨꞌ tujuandam ap dho bak. Ea nañ jum daasaꞌ nap jir jix kaiꞌ kaꞌ mambhɨɨx kap na paiꞌ jax muiꞌ paꞌ daaꞌñxim jir kikcham, na pich guꞌ miꞌ pu dhuu gu palhɨɨp jup jum duukam.” ");
INSERT INTO stpNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Baꞌ jumai nat miꞌp ai, jup kaiꞌchim ɨp: “Yaꞌni baꞌ gum tumñiꞌ. Jix chamaamim jaꞌkbuiꞌ ñich pup muiꞌdhalh na pich jɨꞌk yaꞌñ dhoꞌñchidhak.” ");
INSERT INTO stpNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Baꞌp tɨtda gu gɇꞌkam: “¡Aa guꞌ joidham ji jia! Jir jix kɨɨꞌ tujuandam ap dho bak. Ea nañ jix chamaam kap jum daasaꞌ nap jir jix kaiꞌ kaꞌ na paiꞌ jax muiꞌ paꞌ daaꞌñxim jir kikcham.” ");
INSERT INTO stpNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Baꞌ gu jumai nat miꞌp ai, jup tɨtda pɨx gu gɇꞌkam tugiꞌñ: “Yaꞌni baꞌ gum tumñiꞌ na pich yaꞌñ dhoꞌñchidhak. Aañ cham tuꞌ kɨꞌn tu jua. Jannulh chaꞌm jañich pɨx xi bhiibgak bha jaꞌp xi gaamuk nañ puꞌñiñ aaꞌ nañ giop bam makiaꞌ noꞌ pich yaꞌ ba ai. ");
INSERT INTO stpNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nañ guꞌ xim ɨɨbhiꞌñ nap jiñ ñiokdhaꞌ noꞌ mɨt mañ ɨɨx, piam ku ñich dɨɨlh maiꞌ ma iabu. Nañ guꞌx maat nap giilhim jix bhanaaꞌ tuꞌ na pɨx bhaan sia palhɨɨp jup jum duukam, pu duñiaꞌ ap jax noꞌ pich ba ɨlh, sia kum cham pu kaiꞌch gu jaꞌtkam.” ");
INSERT INTO stpNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Baꞌ gu gɇꞌkam jup tɨtda: “Dho cham tuꞌr jix kɨɨꞌ tujuandam ap aañ nañ paiꞌ jax kaiꞌch. ¿Cham bhaaiꞌ aa nap muñ dhoꞌñchidhaꞌ gɨt nam paiꞌ muiꞌdhalhiꞌñ jaiꞌ dhɨt gu ja tumñiꞌ nap puiꞌ xiñ ɨɨbhiꞌñ, nap guꞌ puiꞌx maat nañ pu tu duñiaꞌ pɨx jax noꞌ ñich ba ɨlh sia kum cham pu kaiꞌch gu jaꞌtkam? Siamri guꞌ jɨꞌk jup ba muiꞌdhaꞌ gɨt na ñich jɨꞌk juruuñ.” ");
INSERT INTO stpNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Baꞌ puiꞌ xi chɨɨdak jup ja tɨtda gu jaiꞌ nam mi jaꞌp guguuk: “Boosgidhai pim gu tuumiñ mu jaꞌk makiaꞌ guiꞌ nat mambhɨɨx jaꞌkbuiꞌ pup muiꞌdhalh.” ");
INSERT INTO stpNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Baꞌp kaiꞌch am tɨi guiꞌ: “¿Jax dhui na dhiꞌ muiꞌ ba biaꞌ, mambhɨɨx jaꞌkbuiꞌ pup na pich jɨꞌk yaꞌ doꞌñchidhak?” ");
INSERT INTO stpNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Baꞌp ja tɨtda gu gɇꞌkam: “Dho na guꞌ gu jaroiꞌ noꞌt puꞌñi muiꞌdhalh gu tuꞌ nam chiñiaꞌ, jix ioꞌm muiꞌ bhaan ji chu biꞌyaꞌ gu tuꞌ. Guꞌ ji noꞌt guꞌ puꞌñi cham jɨꞌx iam xim guguux na muiꞌdhalhdhaꞌ sia gu palhɨɨp, boosgidhaim dho gu jɨꞌk nam tɨi makiaꞌ na gɨt kɨꞌn tu juanaꞌ mu jaꞌk makiaꞌ gu jaroiꞌ nax ioꞌm jix chu juanar kaꞌ, aañ moo yaꞌ pu jam tɨtda.” ");
INSERT INTO stpNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Bhaiꞌ pim jup ja uaꞌpui miꞌñi jaꞌp xi ja koodaꞌ guiꞌ nam jɨꞌk cham aagɨt nañ jir gɇꞌkam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Baꞌ nat tɨɨmok gu Jesuus na miꞌ puiꞌ xi chu aꞌgimɨk, ba jii ɨp gio Jerusaleen jaꞌk na paiꞌ jaꞌk jim. ");
INSERT INTO stpNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Baꞌ maaꞌn kap soosnaꞌn ba ai na paiꞌ daa gu oidhaꞌ Oliibostam, na paiꞌ miaꞌn bipioꞌ na paiꞌ Betpajee tɨ tɨɨꞌ, gio na paiꞌ palhɨɨp jaꞌp jaꞌk Betaania tɨ tɨɨꞌ ɨp. Baꞌ gook guiꞌ nam kaichuꞌ maaꞌn kap ba ja jootos, ");
INSERT INTO stpNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","jup ja tɨtda: ―Jiñ chɨɨmɨlhdhapuꞌ pim maaꞌn gu jigiarum bhuruꞌx bhammɨni dhɨr na paiꞌ pɨx jɨꞌdɨlh jir kikcham nach paiꞌ jaꞌk jiim, chakui jaroiꞌ maaꞌnnim ulh guiꞌ gu bhuruꞌx. Bhaiꞌ bulhkaꞌ na pim jax yaꞌ dɨr mu aajidhaꞌ. Dai na pim jax bulhioꞌkai bhañ chɨɨmɨlhdhikaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Noꞌ jax dhuukat jaroiꞌ ba jam tɨkka na jax ku pimɨt baꞌ bulhioꞌkak ba ji chɨɨmɨrak, jaꞌp japim tɨɨdaꞌ nat gu Gɇꞌkam mu jam joot. ");
INSERT INTO stpNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Baꞌ mɨjɨ ji dhuuꞌn jamɨt, puiꞌ ji chu buus nat jax ja tɨɨꞌn gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ba ja tɨɨ mɨt guiꞌ nar ja bhuruꞌxiꞌ nam miꞌ ka buplhioꞌk, jup ja tɨtda am: ―¿Jax ku pimɨt baꞌ gamaiꞌ ba ji chɨɨmɨrak dhich bhuruꞌxiꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Baꞌ guiꞌp kaiꞌch am: ―Dho gu Gɇꞌkam nat bhach joot nach mu tɨɨmɨlhdhikaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Baꞌ bhaiꞌ xi bakxidhak jamɨt gu tɇꞌtɇb ja kuktun nam daam dɨr ja tɨiꞌchuꞌ ba tɨɨmɨrak mu na paiꞌ gu Jesuus, dai baꞌ na mɨt xi chia na bha daibuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Baꞌ na gamaiꞌ tu jimchudim, bɨɨpɨꞌ dɨr ji bapoiꞌdhat miꞌ ja iabuim am gu jaꞌtkam boi chaꞌm gu tɇꞌtɇb ja kuktun nam daam dɨr ja tɨiꞌchuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Baꞌ nammɨ baas dɨr nam baꞌ moo gammɨjɨ jaꞌk aꞌnsap ba juurkiaꞌ bhaan gu oidhaꞌ Oliibostam, jix bhaiꞌm taattugɨt pɨx jiiñak ba kattuꞌ am bɨɨx guiꞌ nam jɨꞌk kaichuꞌ gu Jesuus, taxchaabgidhim am gu Dios jix bhaiꞌm taattugɨt nam tɨ nɨiꞌñdhaꞌ na bɨɨx aixim joidham tuꞌm jup tu buadaꞌ gu Jesuus, nam tuꞌ cham paiꞌ dhuuk pu chuꞌm tɨ nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jup kaiꞌchim am: ―¡Jix oiꞌm jir gɇꞌkam dhiꞌ na bhaankam ya oirɨ gu Dios, gam na joidham jix uañ kɨꞌn kɨɨk! ¡Jix bhaiꞌch chaatɨt jach gɇꞌkamtuꞌndaꞌ gu Dios jix dhaam nat xich joiꞌmdak bach chɨɨ! ");
INSERT INTO stpNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Baꞌ jɨꞌkchi gu pariseos nam jup jiim, mɨjɨ dɨr jaꞌp ja saagiꞌñ gu jaꞌtkam jup tɨtda am gu Jesuus: ―Jich jaduuñ, ja ñiokdhaiñ dhim jaꞌtkam tuk. Jax ñam pɨx kaiꞌchim. ");
INSERT INTO stpNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Baꞌp ja tɨtda gu Jesuus: ―Jax gi dhui nam guꞌ dhi joodai pɨx jiiñak jup suulhgiaꞌ na miꞌñi jaꞌp daraa noꞌ ñich tɨip xi ja ñiok nam cham ñiokdaꞌ dhiñ jaꞌtkam tuk, aañ moo yaꞌ pu jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Baꞌ nat bhammɨ dɨr ba tu maaxir Jerusaleen na paiꞌ gɇꞌ daaꞌñxim jir kikcham, bhaiꞌ ji susua gu Jesuus, ");
INSERT INTO stpNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","jup xi kaiꞌchɨt: ―¡Joidham gɨt noꞌm pu xib dhi tanoolh jix maatɨt jiñ chɨgiaꞌ nañ jir jaroiꞌ dhaꞌ bɨɨx gu Israel kam jaꞌtkam nam bhaiꞌ oiꞌdhaꞌ Jerusaleen, baꞌñ kɇɇji gɨt miꞌ puiꞌ ba jimiaꞌ am na jax jaꞌk jix bhaiꞌ tu ja jimiaꞌ gatuuk! Guꞌ ji nam guꞌ cham maatɨt tɇ kɇɇ, ni nam jix maatɨt tɨ nɨiꞌñ, jaꞌp ji buusan nam tuꞌ kɨꞌn taaꞌbidhix. ");
INSERT INTO stpNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Jum aajim guꞌ gu tanoolh na paiꞌ dhuuk cham bhaiꞌ tu ja jimiaꞌ, gu ja sandaaruiꞌx chuk guiꞌ nam jix ja bhaamkiꞌñ bhaiꞌ ji ja xikoolhmadaꞌ am, maap jam ji ja sooꞌmdhai pu bɨɨx maaꞌn jimdam ja koodaꞌ nam jɨꞌk bhaiꞌ oiꞌñkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Dhi ja baꞌbhak pu cham jɨꞌk tuukdhixim biꞌyaꞌ gu joodai, na guꞌ gu ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam nar ja kuiñcha kaꞌ nam cham aagaꞌ nam miꞌ puiꞌ jimiaꞌ na jax jaꞌk gɨt jix joiꞌmdai ja palhbuidhaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Baꞌ mɨkkat mu ba baa gu Jesuus gɇꞌ chiop. Miꞌ dhɨr ji ja aadi guiꞌ nam bɨxchuꞌ miꞌ ka tu gaꞌra ɨrban dɨr, ");
INSERT INTO stpNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","jup xi ja tɨɨdak: ―¿Jax ku pim baꞌ yaꞌ pu tu duuk? ¿Kux cham maat japim aa gu ñioꞌkiꞌñ gu Dios na tu uaꞌñix nap jum kaiꞌch: “Dhiñ baꞌaak nat miꞌm kɨi, miꞌ dhɨr jix bhaiꞌ nam jiñ dhaandaꞌ gu jaꞌtkam soiꞌm ɨlhdhat”? Aapiꞌm guꞌ ya jaꞌp tu duuk na mu paiꞌ chiob nam paiꞌm jumpaꞌn gux ɨꞌxkum. ");
INSERT INTO stpNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Baꞌ miꞌ pu tu ja aꞌgiꞌñdhaꞌ gu Jesuus gu jaꞌtkam gɇꞌ chiop gammɨjɨ nabap tanoolh. Guꞌ baꞌ gu ja gɇꞌgɇrkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, gio gu jaꞌppɨx ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam, tɨi maap tu aꞌgadaꞌ am nam tuꞌ bhaan gɨt xi iattulhdhai tu chiñiaꞌ nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Joidham kɇɇkɇꞌ am guꞌ gu jaꞌtkam na jax tu aꞌgadaꞌ gu Jesuus, sia kum guꞌ guiꞌ tɨix bhaamut kɇɇkɇꞌ. Jix ja ɨɨbhidhat gu jaꞌtkam baꞌ cham juandaꞌ am gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Maaꞌnnim na miꞌ ka tu ja aꞌgiꞌñ gu Jesuus gu jaꞌtkam gɇꞌ chiop, na ja aagiꞌñ nam jax jaꞌk duñiaꞌ na baꞌx joiꞌmdat ja aꞌm tɨ tɨgiaꞌ gu Dios, miꞌ ba ji bubua mɨt gu ja gɇꞌgɇrkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, gio baꞌ gu jaꞌppɨx ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Baꞌp tɨtda am: ―¿Jax chuꞌm gɇꞌkam jap bhaankam yaꞌ bɨɨx aixim tu bua? ¿Jir pa jaꞌk kam guiꞌ nat puiꞌ jaꞌk jum chia? ");
INSERT INTO stpNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Baꞌp ja tɨtda gu Jesuus: ―Dho aañ jup jam tɨkkaꞌ noꞌ pim jiñ aagiꞌñdhaꞌ nañ baꞌ aañ jup jam aagiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Jaroo bha joot gu Juan na ja bopkonaꞌ gu jaꞌtkam? ¿Dios aa, kaꞌ yaꞌ paiꞌ dhɨr aa gu jaꞌtkam chia mɨt? Ea gor xiñ aagiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Baꞌ bhaiꞌ jim tɨ tɨkka mɨt dɨɨlh, jup kaiꞌch am: ―¿Jax jach tɨꞌyaꞌ? Na guꞌ noꞌch jax kaiꞌch nat Dios bha joot, puiꞌ ji chɨꞌyaꞌ: “¿Guꞌ jax ji na pimɨt baꞌ cham miꞌ puiꞌ jii na jax tɨi jam tɨtdaimɨk?” ");
INSERT INTO stpNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Gio guꞌ noꞌch jax kaiꞌch na mɨt yaꞌ paiꞌ dhɨr chia gu jaꞌtkam, bhaiꞌ ji bhaakuꞌ am ɨp jich bui bɨɨx gu jaꞌtkam, nam guꞌ bɨɨx jix bhaiꞌx maat na gu Juan bhaankam tu aꞌgimɨk gu Dios. Jich koodaꞌm dho guꞌ joodai kɨꞌn jich maꞌyasimɨi. ");
INSERT INTO stpNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Baꞌ puiꞌ ma tɨɨꞌn jamɨt nam cham maat nat jaroiꞌ bha joot gu Juan na ja bopkonaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Baꞌp ja tɨtda gu Jesuus: ―Dho aañ puiꞌ cham jup jam aagiꞌñdhaꞌ nat jaroiꞌ bhañ joot, na pim guꞌ cham jiñ aagiꞌñ aapiꞌm. ");
INSERT INTO stpNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Baꞌ gu Jesuus muiꞌ ji chu ja aꞌgi bɨɨx gu jaꞌtkam bhaan xi chu uaꞌrgidhak na tuꞌ jax jum buadaꞌ yaꞌ dhi oiꞌñgaꞌn nam sap baꞌx maatɨt kaayaꞌ. Jup ja tɨtda: ―Maaꞌnnim maaꞌn gu maaꞌnkam xi chu darsak gu uubas mɨk jaꞌk pu bhɨi, dai gu tujuandam jɨꞌk miꞌ xi ja doꞌñchok nam miꞌx bhaiꞌ buixiꞌñdhaꞌ gu ɨꞌxiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Baꞌ nammɨ na paiꞌ dhuuk jix maat na bhɇbhɇɇ gu uubas, bhammɨ dɨr bhaiꞌ tɨi ba joot jumai gu tujuandam tugiꞌñ miꞌ nat paiꞌ ja doꞌñchok gu jaiꞌ tujuandam tugiꞌñ, nam gɨt mu makiaꞌ na jɨꞌk bhaan jup bipioꞌ. Guꞌ ji na guꞌ na miꞌ puiꞌ tɨi ba ja tɨtdaim, dai na mɨt bhaiꞌ ji dhaa, gɨbiimɨk jamɨt puiꞌ mɨjɨ xi joot ɨp gio. ");
INSERT INTO stpNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Baꞌ jumai bhammɨ dɨr bhaiꞌ tɨip joot. Puiꞌ mɨt giilhim jup xi chɨtdaimɨk xi gɨbiimɨk puiꞌ mɨjɨ xi joot ɨp sia. ");
INSERT INTO stpNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jumai baꞌ bhammɨ dɨr bhaiꞌ tɨip joot. Maaꞌn na mɨt jax dhooda, xi gɨbiimɨk jamɨt jix ɨꞌrsuꞌ miꞌ dhɨr jup ji aadi, pu cham tuꞌ mɨt maa. ");
INSERT INTO stpNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Baꞌp jum aaꞌ guiꞌ nat tu darai gu uubas: “¿Gi jarooñ baꞌ mu jootsaꞌ nam baꞌ cham jax ji chɨꞌji bha makiaꞌ gu uubas na jɨꞌk jiñ aꞌm jup bipioꞌ? Gi noꞌ ñich mu joot dhi dɨɨlh jiñ mar, kat jam chi iam tuꞌ kaꞌm tɨɨgɨi makiaꞌ, nam guꞌx maat nañ giilhim jix dhaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Guꞌ ji na guꞌ nat paiꞌ dhuuk tɨi mu ba ai gu maraaꞌn, jup jum tɨ tɨtda am dɨɨlh gu tujuandam: “Dhiꞌ dho baꞌr diꞌ guiꞌ na bhaan ji chu biꞌyaꞌ bɨɨx na jɨꞌk yaꞌx chu jaiꞌch na paiꞌ dhuuk mukiaꞌ gu taataꞌn. Jaꞌpji nach yaꞌ muꞌaaꞌ, kapbhaiꞌ nat yaꞌ ba ai. Aach baꞌch aꞌm ji chu biꞌyaꞌ na jɨꞌk yaꞌx chu jaiꞌch.” ");
INSERT INTO stpNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Baꞌ puiꞌ xi chɨꞌɨɨk bhaiꞌ ji dhaa mɨt. Nammɨ gama jaꞌk jaꞌp jamɨt xi bhɨɨk xi muꞌaak na paiꞌ cham tɨ ɨx gu uubas. ¿Aapiꞌm baꞌ jax ɨlhiiꞌñ na ja doodaꞌ guiꞌ gu tujuandam na mɨt ba mua gu maraaꞌn guiꞌ nat miꞌ tu darsak gu uubas? ");
INSERT INTO stpNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mu jimɨi dho ja koodai jaiꞌp miꞌ ja iabuꞌ gu tujuandam. Baꞌp kaiꞌch am gu jaꞌtkam na puiꞌ kaiꞌch gu Jesuus: ―¡Iam gɨt moo cham jɨꞌxkat puiꞌ tuch dhoodaꞌ! ");
INSERT INTO stpNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Guꞌ ji nat guꞌ gu Jesuus jix bhaiꞌ muiꞌ xi ja tɨɨgɨk jup ja tɨtda: ―¿Guꞌ jax japim baꞌ ɨlhdhat kɇɇ ji gu ñioꞌkiꞌñ gu Dios miꞌ na paiꞌ jaꞌpnim kaiꞌch?: Gu jodai guiꞌ na mɨt tɨi maiꞌ xi buak gu bhibhiꞌñbakchadam nam jup jum aaꞌ na cham tuꞌ bhaiꞌ, xib dhiꞌ pɨk bhaan jix oꞌjoꞌ gu jaiꞌ joodai. ");
INSERT INTO stpNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jix ɨɨbhidharaꞌ dho dhi jodai. Nɨidhat japim na pim cham dhiꞌ pɨk bhaan iaꞌlhiaꞌ. Na guꞌ noꞌ pimɨt jax dhuuk bhaan iaꞌrɨ, taꞌtak mi jaꞌp pup darkaꞌ pim. Piam noꞌt jax dhuuk jam tɨim, mataip jam doodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Baꞌ miꞌ jotmodaꞌ tɨix dhaagɨk am gu Jesuus gu ja gɇꞌgɇrkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, guꞌ ji nam guꞌx ja ɨɨbhiꞌñ gu jaꞌtkam, cham juan am baꞌ. Jix maatɨt kai mɨt guꞌ gu Jesuus na guiꞌ pɨx ja aagɨt jup kaiꞌch, nat bhaan tu aꞌga gu tujuandam nat miꞌ xi ja doꞌñchok guiꞌ nat xi chu darsak gu uubas, guꞌ ji nam guꞌ cham tuꞌr kɨkɨɨꞌ tujuandam. ");
INSERT INTO stpNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Baꞌ guiꞌ nam jix bhaamkiꞌñ gu Jesuus, jix xɨꞌlhim jamɨt muiꞌ xi ja joot jaiꞌ gu jaꞌtkam nam xir jix bhabhaiꞌkamtuꞌndaꞌ buiñor, nam tɨkkaꞌ noꞌ puiꞌp ɨlhiiꞌñ nam jax ɨlhiiꞌñ dɨɨlh. Guꞌ sap baꞌ noꞌ cham puiꞌ jaꞌk kaiꞌch, dai nam daagɨi ba bhɨikaꞌ buiñor gux kaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jup tɨtda am guiꞌ na mɨt mu ja joot: ―Aapiꞌch jaduuñ, aach tɨ jɨɨgiꞌñ na maaxik jir sɨlhkam puiꞌ nap jɨꞌk jax ja tɨtda gu jaꞌtkam. Jir miꞌ puiꞌ na jax jich chian gu Dios nach chuiꞌñgɨdaꞌ, cham paiꞌ puiꞌ jaꞌk ja aagiꞌñ ap panaas nap dɨɨlh jax ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Baꞌ jaꞌp jach tuꞌm jup xim tɨkkam: ¿Jir am aa nach namkiꞌñdhaꞌ gux ioꞌm gɇꞌkam Seesar Rooma kam na jɨꞌk aagix nach namkiꞌñdhaꞌ, kaꞌ cham aa? ");
INSERT INTO stpNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Guꞌ ji na guꞌx bhaiꞌx maat gu Jesuus nam miꞌ pɨx mamaiꞌchɨk, baꞌp ja tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Ea gor maaꞌn xiñ chaiñbuiꞌñ gu tuumiñ. ¿Jax jum kaiꞌch yaꞌni na paiꞌ tu uaꞌñix, gio dhiꞌ na yaꞌ jupñix, jir jaroo daꞌ? Baꞌ guiꞌp kaiꞌch am: ―Dho dhiꞌ gux ioꞌm gɇꞌkam Seesar na miꞌ jupñix, baꞌ dhiꞌ na miꞌ tu uaꞌñix miꞌ dhaa na jax chɨɨꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Baꞌp ja tɨtda gu Jesuus: ―Dho pim xi namkidhat gu Seesar na jɨꞌk aagix na pim namkiꞌñdhaꞌ, gio gu Dios japim jup xi maakidhat na jɨꞌk bhaan jup bipioꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Baꞌ cham paiꞌ jax kai mɨt gu Jesuus nam tɨi mamaiꞌchɨk nam baꞌ gɨt dagiaꞌ, na guꞌ sɨlhkam jir puiꞌ na jax kaiꞌch. Guiꞌ dai nam miꞌ puiꞌ pup tuꞌiiꞌ nat am ja buiꞌñ, puiꞌ baꞌ cham ka juan am. ");
INSERT INTO stpNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Baꞌ jaꞌxpɨx jɨꞌkchi miꞌp ba ai mɨt gu saduseos, nam cham tɨ jɨɨgiꞌñdhaꞌ nam gatuuk gio duduadɨi maakam jaꞌk jup aayaꞌ guiꞌ nam jɨꞌk koꞌyaꞌ ja tutkuꞌ bhaan. Jup tɨtda am gu Jesuus mi ɇɇk: ");
INSERT INTO stpNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Jich jaduuñ, aach bha jii na chich bham tɨkkam noꞌp iam jich aagiꞌñdhaꞌ gɨt jaꞌp tuꞌm na cham jir jich jur. Guiꞌ nat Moisees tu uaꞌnak jup jum kaiꞌch na sap noꞌt maadɨt muu gu maaꞌnkam cham maaꞌn ji chɨɨgɨk gu alhii bhaan gu bɨngaꞌn, miꞌ dhɨr jix bhaaiꞌ na bhɨɨji gu sɨpdhiꞌñ na miaꞌn oiꞌñdhaꞌ bhaankam tɨgiaꞌ gu alhii, baꞌ jaꞌp ji buusniaꞌ na gu xioꞌgiꞌñ pɨx jir maraaꞌn kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Baꞌ jaꞌp jach jup jix chu maat aach. Maaꞌnnim maaꞌn kap oiꞌñkat am xijum gook gu jaꞌtkam daim sɨspidhim. Baꞌ gu bɨɨpɨꞌ kam tɨi ba bhɨɨk maaꞌn gu ubii, guꞌ ji nat guꞌ am xi muu cham maaꞌn ji chɨɨgɨk gu alhii bhaan guiꞌ gu ubii. ");
INSERT INTO stpNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Baꞌ gu sɨpdhiꞌñ na miaꞌn oiꞌñ tɨi bhaiꞌp ji bhɨi guiꞌ gu ubii, guꞌ ji nat guꞌ puiꞌ jotmodaꞌ am jup xi muu, pu cham maaꞌn jup tɨɨ ɨp sia gu alhii bhaan guiꞌ gu ubii. Baꞌ gu tɨꞌɨraab kam tɨi bhaiꞌp ji bhɨi, puiꞌ pɨx jup jum duu. Bɨɨx koi mɨt gu xijum gook tɨi pup bhɨbhɨimɨk guiꞌ gu ubii, pu cham jaroiꞌ iam tɨɨ gu alhii bhaan guiꞌ gu ubii. ");
INSERT INTO stpNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mɨkkat sap puiꞌ am jup xi muu dɨɨlh gu ubii. ");
INSERT INTO stpNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Jaroo baꞌ pɨk jir bɨngaꞌn kaꞌ janoꞌ nam saak duduadɨi gio mu paiꞌp ba oipodaꞌ? Jaiñ nam guꞌ puiꞌr xijum gook jaꞌtkam kat. ");
INSERT INTO stpNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Baꞌ gu Jesuus jup ja tɨtda: ―Jax dhui na dai yaꞌ dhi oiꞌñgaꞌn bhaan nam tɨ bɨpnaꞌ kaꞌ gu chichioꞌñ gio gu uꞌuub, dai nam ka duduakaꞌ ja tutkuꞌ bhaan. ");
INSERT INTO stpNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Guꞌ matgɨm guiꞌ nam miꞌ puiꞌ jimɨi koꞌyaꞌ ja tutkuꞌ bhaan na jax jix aaꞌ gu Dios, cham tuꞌ bhaan jup ka tɨtɨɨꞌñchokaꞌm ji janoꞌ nam paiꞌ dhuuk maakam jaꞌk aayaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","nam guꞌ jaꞌp pɨx bar tuꞌm kaꞌ na jax gu noonbiꞌñ gu Dios. Ni kum cham tuꞌ kar tu koꞌdam kaꞌ, na guꞌ gu Dios pɨx dɨɨlh na giop ja duduaꞌñdhai ja baidhikaꞌ nam buiñor bap tuiꞌkaꞌ, baꞌ gammɨjɨ pu bar maamraꞌn kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Gio guꞌx bhaiꞌx maatɨꞌ nam maaꞌn kap aajim guiꞌ nam koꞌiim ja tutkuꞌ bhaan nam miꞌ puiꞌ jimɨi na jax jix aaꞌ gu Dios. Puiꞌm kaiꞌch mi uꞌuan taꞌm nat paiꞌ tu uaꞌnak gu Moisees, na bhaan tu aꞌga janoꞌ nat tu aꞌgidhak gu Dios taip jim duuk bhaan dɨr gux bii uꞌuux. Gu Dios jup tɨtda dɨɨlh gu Moisees na dhiꞌ pɨx jir diꞌ gu Dios na jax gammɨjɨ pu buiñor bax biiñak gu Abraam gio gu Isaak gio baꞌ gu Jakob, cham paiꞌ jax kaiꞌch nam jix biiñak kat pɨx buiñor. ");
INSERT INTO stpNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na guꞌ maaxik gu Dios cham tuꞌ koiꞌñgaꞌn na ja aꞌm tɨ nɨidhidhaꞌ, guꞌ guiꞌ ji nam duduakaꞌ. Na guꞌ guiꞌ cham tuꞌ puiꞌ ɨlhiiꞌñ nam jup koꞌyaꞌ guiꞌ nam miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ, guꞌ matgɨm guiꞌ buiñor bɨɨx ji nam dudua. ");
INSERT INTO stpNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Baꞌ jɨꞌkchi guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios miꞌ dhɨr jaꞌp jup tɨtda am gu Jesuus: ―Jir puiꞌ dho nap jax kaiꞌch jich jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Baꞌ guiꞌ cham ka juan am, daipuꞌ na mɨt xi chɨɨdak. ");
INSERT INTO stpNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Baꞌ bhaiꞌ ji ja tɨkka ɨp gu Jesuus gu jaꞌtkam, jup ja tɨtda: ―¿Jax ku pim baꞌp kaiꞌchdhaꞌ na guch Xoiꞌkam jir boxiiꞌñ gu Dabii? ");
INSERT INTO stpNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Na baꞌ guꞌ gu Dabii dɨɨlh puiꞌp kaiꞌch nar gɇꞌkam tugiꞌñ guch Xoiꞌkam. Jaꞌpnim kaiꞌch mi Salmos taꞌm nat paiꞌ tu uaꞌnak dɨɨlh gu Dabii: Jup tɨtda gu Dios guñ gɇꞌkam tuk: “Yaꞌni kɨɨꞌn dɨr jiñ xanoop jap ka xi dhaibuꞌ ");
INSERT INTO stpNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nañ aañ ka xi ja mattudaꞌ guiꞌ nam xim bhaamkiꞌñ nap aap jir gɇꞌkam nam baꞌm bui soiꞌm ɨlhdhaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Guꞌ jax ji pim chi baꞌ duukat puiꞌ iimchuꞌn na puiꞌr boxiiꞌñ, na baꞌ guꞌ gu Dabii puiꞌp kaiꞌch nar gɇꞌkam tugiꞌñ guch Xoiꞌkam? ");
INSERT INTO stpNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Baꞌ bɨɨx tɇ kɇɇ am gu jaꞌtkam nam miꞌp tuꞌiiꞌ. Baꞌp ja tɨtda gu Jesuus dai guiꞌ nam kaichuꞌ: ");
INSERT INTO stpNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Chaꞌpim ja jɨɨgiꞌñdhaꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, nam guꞌ dhiꞌ jaꞌppɨx gɇꞌgɇrkam jum taat kaꞌ. Jix joojoiꞌñdhaꞌ am nam tɇꞌtɇb ji chɨm tɨiꞌdhat naiꞌ jiimdaꞌ, jix aaꞌndaꞌ am nam tuꞌ kaꞌm ja nɨidhat ja ñioꞌkdhidhaꞌ bɨɨx gu jaꞌtkam mu jaꞌp nam jax jiimdaꞌ. Gio bɨɨpɨꞌ dɨr jam jix dharaibuktuꞌndaꞌ na paiꞌ tum daandaꞌ gio nam paiꞌ jax tu kuaꞌdaꞌ, ni jɨꞌx kum iam gatuuk dɨr xix dharaibuktuꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Gam nam tuꞌ bhaan xi ja iatgidhat ja boosgiꞌñdhaꞌ gu ja baꞌbhak gu dɨꞌdɨlhdhɨm uꞌuub nam ba koꞌiix gu ja bɨpnaꞌ, sap baꞌ mɨk xi chu daandaꞌ am buiñor gu Dios nam xi ja nɨiꞌñdhaꞌ gu jaꞌtkam, na sap baꞌ panaas bhaan jix maatɨꞌ kaꞌ nam cham tuꞌ bhaan uꞌuaꞌtulhdhix. Guꞌ dhiꞌ ji baꞌ pɨk jix ioꞌm ja tulhiiñchudaꞌ gu Dios, na guꞌ cham kɨɨꞌ kaꞌm nɨiꞌñ gu puiꞌ nam jax jaꞌk tu jim. ");
INSERT INTO stpNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Baꞌ jaꞌxpɨx miꞌ jaꞌk jup ba ja nɨiꞌñ gu Jesuus gu jaꞌtkam guiꞌ nam jir jix chutumñigam, nam pɨx miꞌ ji chuꞌaim gu tuumiñ miꞌ na paiꞌm tuaꞌba nam maakim gu Dios na jɨꞌk bhaan jup bipioꞌ. Muiꞌ miꞌ xi chuꞌaim am. ");
INSERT INTO stpNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Baꞌ maaꞌn jup ba tɨɨ gu ubii dɨɨlhdhɨm na ba muukix gu bɨngaꞌn, pu cham tuꞌ biaꞌ ni jɨꞌx gu tuꞌ na jax gu jaiꞌ. Baꞌ miꞌp xi chua gook gu tuumiñ na cham pɨk tuꞌ bhaigim tuutuꞌm. ");
INSERT INTO stpNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Baꞌp ja tɨtda gu Jesuus bɨɨx guiꞌ nam miꞌp tuꞌiiꞌ: ―Aañ yaꞌ pu jam tɨtda tuꞌ sɨlhkam kɨꞌn nat dhi ubii jix ioꞌm muiꞌ mi tua gu tuumiñ, sia ku panaas cham tuꞌ bhaigim tuꞌiiꞌ dhiꞌ nat mi tua. ");
INSERT INTO stpNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Na guꞌ guiꞌ na mɨt panaas muiꞌ mi tua, daipuꞌ guiꞌ na jɨꞌk cham kam aaꞌ na mɨt mi tua. Guꞌ dhi ubii pu bɨɨx mi tua na jɨꞌk biaꞌkat, ni kut iam jax xim aa na paiꞌ baꞌ dɨr uꞌji kɨꞌn sabaꞌdaꞌ gu tuꞌ na jugiaꞌ, na guꞌ cham jir jix chumñigam. ");
INSERT INTO stpNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Baꞌ jɨꞌkchi guiꞌ nam kaichuꞌ gu Jesuus mi jaꞌp bhaan ba ji chu aꞌga mɨt gu gɇꞌ chiop, jup kaiꞌch am na joidham tuꞌiiꞌ na joidham tuꞌt sobkoñxim bha bhiꞌñbakchix gu joodai. Baꞌp ja tɨtda gu Jesuus na ja kɇɇ: ");
INSERT INTO stpNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Yaꞌ dho puiꞌ ka tu tuꞌiiꞌ xib. Matgɨm jum aayaꞌ ji gu tanoolh na pu cham paiꞌ maaꞌn kap tuukdhixim biꞌyaꞌ dhi joodai. ");
INSERT INTO stpNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Baꞌ guiꞌ bhaiꞌp ba tɨkka am na puiꞌ ja tɨtda gu Jesuus, jup tɨtda am: ―Jich jaduuñ, ¿paa baꞌ duuk pɨk puiꞌ tum duñiaꞌ? ¿Tuꞌ jax bam buidhaꞌ na bhaan bax maatɨꞌ kaꞌ na bar miaꞌn? ");
INSERT INTO stpNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Baꞌp ja tɨtda gu Jesuus: ―Na paiꞌ dhuuk bar miaꞌn kaꞌ na puiꞌ ba ji chum duñiaꞌ, muiꞌ pɨx yaꞌ ba ji ɇɇdaꞌ am guiꞌ nam puiꞌ kaiꞌchdhaꞌ na sap panaas aañ jir guiꞌ kaꞌ am. Jup kaiꞌchdhaꞌ am: “Aañ jir diꞌ guch Xoiꞌkam. Bam ai nañ paiꞌ dhuuk ya aayaꞌ.” Aapiꞌm cham ja jɨɨgiꞌñdhaꞌ, nam guꞌ jam iatgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Gio puiꞌ ba tɨ kaayaꞌ pim na ba jɨgialhchaꞌ. Aapiꞌm cham totdon kaꞌ, na guꞌm aaꞌ na bɨɨpɨꞌ jɨgialhchaꞌ na baꞌ pɨk bam tɨɨmoꞌ dhi oiꞌñgaꞌn. Ku guꞌ chakui pɨk jir diꞌ kaꞌ ji sia kut ba jɨgialhich. ");
INSERT INTO stpNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Muiꞌ xi chu ja aꞌgiꞌñchuꞌ gu Jesuus, jup ja tɨtda: ―Maap jam jim daagɨi dai gɇꞌgɇrkam ja bɨɨm bɨɨx gu ja jaꞌtkamiꞌ muiꞌ ji chu kokdaꞌ ja bui gu jaiꞌ gɇꞌgɇrkam nam jaiꞌ momkoram jup tuiꞌkaꞌ. Giilhim baꞌ bar jɨgialhiꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Gio baꞌ na muiꞌ kap dɨɨlh pɨx ba joiñdhaꞌ dhi oiꞌñgaꞌn. Gam na bhiogiꞌ bhaiꞌ ji jimiaꞌ. Gio gu koꞌkdaiꞌ na bhaiꞌ ji chu aayaꞌ. Gio bha jaꞌp jix dhaam bɨɨx aixim jix ɨɨbhidham jax ña pim pɨx ba tɨ nɨiꞌñdhaꞌ na pim tuꞌ cham paiꞌ dhuuk pu chuꞌm tɨ nɨiꞌñdhaꞌ. Gam jaiꞌ bɨɨx aixim ku pim puiꞌ tɨ tɨgiaꞌ. Baꞌ dhiꞌ bhaan jix maatɨꞌ kaꞌ na ba miamlhidhaꞌ na bam tɨɨmoꞌ dhi oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Baꞌ bɨɨpɨꞌ na baꞌ moo bhaiꞌ ji jɨgialhchaꞌ, aapiꞌm na pim jɨꞌk tɨ jɨɨgiꞌñdhaꞌñ bui, jam daꞌngɨi jam uiꞌkaꞌ am gu jaꞌtkam mu jaꞌp nam paiꞌ jax tu chichiopiꞌ kaꞌ, miꞌ baꞌ bhaiꞌ ji jam tɨkkaꞌ am na pim jax kaiꞌñkam miꞌ puiꞌ tu daaꞌñchugɨt miꞌ puiꞌ jiim na jax aañ. Miꞌ dhɨr baꞌ mu jaꞌp ba jam uꞌaidhaꞌ am nam paiꞌ jax darkaꞌ gux kakaiꞌ gio jaiꞌ ja bui gu gɇꞌgɇrkam. ");
INSERT INTO stpNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Baꞌ kapbhaiꞌ nam bhaiꞌ ba jam tɨkkadaꞌ, aapiꞌm xi ja aagiꞌñdhaꞌ na pim jax kaiꞌñkam jiñ kaichuꞌ, xi ja aagiꞌñdhaꞌ pim sia nañ jir tuꞌp tuꞌm daꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Baꞌ noꞌ pim cham maat na pim jax jaꞌk tɨꞌyaꞌ ja bui gu gɇꞌgɇrkam, chaꞌpim jax jum aaꞌntuꞌndaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","nañ guꞌ aañ jam makiaꞌ gu matdaꞌ na pim jax jaꞌk ja tɨɨdaꞌ noꞌ pim bhaan bap tuiꞌdhiꞌ. Dɨɨlh pɨx yaꞌ dɨr jaꞌp ji bubuakiaꞌ gu ñiꞌook na pim jax jaꞌk ja tɨɨdaꞌ, guiꞌ pu cham ka bhaaiꞌn kaꞌ nam jax jam tɨɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ku guꞌ bɨɨx pɨx bhaiꞌ ji jam bhaamkidhaꞌm ji guiꞌ nam cham jiñ bui tɨ jɨɨgiꞌñdhaꞌ, sia gu jam tataat noꞌm cham jiñ bui tɨ jɨɨgiꞌñ, sia gu miaꞌn jam jaaduñ, sia gu mɨk dɨr kam jam jaaduñ, sia gu jaroiꞌ na pim tɨi gook dɨt jix bhaiꞌ ka kaiꞌchdhaꞌ. Dhiꞌ baꞌ maaxik jam tuttuꞌ am ja bui gu gɇꞌgɇrkam, baꞌ jaiꞌ dhɨt jam koodaꞌ am noꞌm xi ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bɨɨx jam xi jam bhaamkiꞌñdhaꞌ gu jaꞌtkam guiꞌ nam cham tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui. ");
INSERT INTO stpNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ku baꞌ guꞌ cham jax bua ji, na guꞌ gammɨjɨ jam aꞌm tɨ nɨidhidhaꞌ gu Dios, nim maaꞌn jam kuup ku maiꞌ gɨɨxix kaꞌ jam moꞌ am dɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Baꞌ chaꞌpim jax jum aaꞌntugɨt miꞌ puiꞌ xi chu duñiidhaꞌ na jax jix aaꞌ gu Dios sia puiꞌ jim tulhiiñaidhat, na baꞌ jam baidhikaꞌ na paiꞌp tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Baꞌ noꞌ pimɨt ba ja tɨɨ nam bɨɨx xikoolh dhɨr ba daraa gu sandaaruiꞌx yaꞌ Jerusaleen, am tɨꞌñchokaꞌ pim na cham xiim cham paiꞌ matgilhiaꞌ dhi baꞌbhak ja bɨɨm guiꞌ nam yaꞌ oiꞌdhaꞌ, sia ku guꞌ jax gɇꞌr kiicham. ");
INSERT INTO stpNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Guꞌ baꞌ noꞌm gu yaꞌ kam mu jaꞌp ka paxiar jaiꞌ kap na puiꞌ Judea bhaan jup bipioꞌ gu dɨbɨɨr, miꞌ dhɨr jam ba jiboiꞌñgiaꞌ bhɨjɨ jaꞌp oiꞌdhaꞌ taꞌm na jax jix uꞌxiꞌ, cham tuꞌ nam bha jaꞌk boopodaꞌ. Gio jaiꞌ noꞌm yaꞌ ka oipo Jerusaleen, yaꞌ dɨr jam bubuakɨi ba jiboiꞌñgiaꞌ mu jaꞌp gampɨx. Gio jaiꞌ noꞌm mu jaꞌp ka oipo ja gagaa am, miꞌ dhɨr jam gammɨjɨ jaꞌk pu ba jiboiꞌñgiaꞌ, cham tuꞌ nam yammɨp ka xi ñoongɨi nam baꞌ pɨk ba jiboiꞌñgiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bam aayaꞌ guꞌ gu tanoolh na paiꞌ dhuuk giilhim jix ioꞌm tulhiiñaraꞌ ja daam jimiaꞌ bɨɨx gu jaꞌtkam guiꞌ nam cham tuꞌ kaꞌm tɨ tɨgiaꞌ, baꞌ puiꞌ ba tum duñiaꞌ na jax tu uaꞌñix gu ñioꞌkiꞌñ gu Dios na mɨt tu uaꞌnak gu bɨjɨk dɨr kam. ");
INSERT INTO stpNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tɨi joiꞌmdam jum buadaꞌ am janoꞌ gu uꞌuub guiꞌ nam aꞌaalh kɨꞌn cham bhaiꞌm taat kaꞌ, gio guiꞌ nam kiaꞌpɨx ja tɨgiaꞌ gu aꞌaalh. Giilhim jix koꞌkom jum buadaꞌ am bɨɨx pɨx gu Israel kam jaꞌtkam guiꞌ nam cham miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ gu Dios, ja daam ba jimiaꞌ guꞌ gu tulhiiñaraꞌ dhiꞌ dhi jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Baꞌ jaiꞌm yaꞌ pu xi ja sɨssɨi kukxir kɨꞌn, jaiꞌm baꞌ ja buuprai naiꞌ ba ja uꞌaidhaꞌ jaiꞌ momkoram nam paiꞌ jax dar gux ioꞌm gɇꞌgɇrkam. Baꞌ yaꞌ dhi Jerusaleen gampaiꞌ tu doodaꞌ am guiꞌ nam cham jir Israel kam jaꞌtkam, ku guꞌ tu ja daaxdhaꞌ ɨp ji gu Dios dhiꞌ dhi jaꞌtkam nam paiꞌ dhuuk jup ja koodaꞌ, cham tuꞌ nam puiꞌ biꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Muiꞌ xi chu ja aꞌgiꞌñchuꞌ gu Jesuus, jup ja tɨtda: ―Baꞌ miꞌ dhɨr bɨɨx aixim bhaiꞌ ji chum duñiaꞌ bha jaꞌp jix dhaam. Gu tanoolh naiꞌ ji chukiaꞌ, gio gu masaaꞌn cham ka tu masbagiꞌñdhaꞌ, gio gu chiichiaꞌ cham paiꞌ bhaiꞌ paiꞌ ka darkaꞌ, gio gu gɇꞌgɇr suudaiꞌ na mu jaꞌp suusuꞌn juꞌñdharam dhi gɇꞌgɇr dɨppɨr, gɇꞌgɇr ba tɨroondaꞌ. Cham ka bhaaiꞌn kaꞌ nam jax jum duñiaꞌ bɨɨx gu jaꞌtkam, giilhim bax chotdon kaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tu kaamui naiꞌ ji iaꞌlhiaꞌ am nam puiꞌ xim aaꞌndaꞌ na bam tɨɨmo dhi oiꞌñgaꞌn. Bɨɨx tu iiꞌñxiaꞌ guꞌ dhiꞌ na tuꞌ xib bha jaꞌp jix maax jix dhaam, panaas ku jaroiꞌ bha tu xiixkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Baꞌ miꞌ dhɨr aañ nañ bhaankam ya oirɨ gu Dios, bañ chɨgiaꞌ pim nañ bhammɨ dɨr bhaiꞌ ba jimdaꞌ bhaan maaꞌn jix chua tɨbaaꞌñ chaꞌm giilhim gɇꞌkam kɨꞌn, joidham am nammɨ jaꞌp jix chu maaxchuꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Baꞌ na paiꞌ dhuuk puꞌñi ba ji chum duñiaꞌ, chaꞌpim jix buam jum aaꞌndaꞌ. Am gan ba tɨ nɨiꞌñdhaꞌ pim ji, na guꞌ gu Dios cham xiim yaꞌ dɨr ba jam baapmiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Baꞌ bhaan xi chu uaꞌrgidhak xi ja aagiꞌñ, jup ja tɨtda: ―Na guꞌ na pim jax bax maat maaꞌn gu iigɨx piam jax chuꞌm jumai ɨꞌɨɨx, ");
INSERT INTO stpNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","noꞌt iiꞌnsɨk gu jaagaꞌn jaiꞌ ba iꞌpo, dhiꞌ bhaan jix maatɨꞌ kaꞌ na cham xiim ba tɨꞌngiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Baꞌ puꞌñi ɨp noꞌ pim bɨɨx aixim ba tɨ nɨiꞌñ na ba tum bua, dhiꞌ bhaan bax mat kaꞌ pim na cham xiim xi jam joiꞌmdaix bhaiꞌ ba jam duñiaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Puix jaiꞌch kaꞌ am gu jaꞌtkam Israel kam janoꞌ na paiꞌ dhuuk puiꞌ tum duñiaꞌ, aañ moo yaꞌ pu jam tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Na guꞌ aañ nañ paiꞌ jax kaiꞌchdhaꞌ, puiꞌ ji chu buusnichgɨdaꞌ, cham tuꞌ puiꞌ na dhi dɨbɨɨr gio dhix dhaam na jax chuꞌm tanoolh cham paiꞌ matgilhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Baꞌ aapiꞌm cham tuꞌ bhaan jum tukgiꞌñkaꞌ gu tuꞌ na yaꞌ dhi oiꞌñgaꞌn jix chu jaiꞌch na cham tuꞌ mim nɨnɨiꞌñ. Chaꞌpim maik kaꞌ, dai ji na pim miꞌ puiꞌ xi jiimdaꞌ na jax jix aaꞌ gu Dios na baꞌ cham yaꞌ pɨx ");
INSERT INTO stpNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","pu ba jam tulhiiñchudaꞌ na pim jum jur bhɨɨyaꞌ, jaꞌp na jax gu tuꞌ na jotmodaꞌ pɨx tɨɨgiꞌñ chɨr ba gɨxiaꞌ na cham pum aaꞌndaꞌ. Na guꞌ puꞌñi jaꞌk jum duñiaꞌ am guiꞌ nam cham tuꞌ kaꞌm tɨgiaꞌ gu Dios, nam guꞌ dai gam ɨrdaꞌ kiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Guꞌ aapiꞌm gammɨjɨ tu daandaꞌ ji buiñor gu Dios jix dhaam jaꞌk na pim baꞌ cham jum tulhiiñaꞌ na jax gu jaꞌtkam guiꞌ nam cham tuꞌ kaꞌm tɨgiaꞌ gu Dios, gam na pim baꞌx bhaiꞌm taatɨt baasɨꞌn bañ ñamkiaꞌ nañ bhaiꞌ ba jimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Baꞌ gu Jesuus dai tataab jaꞌk miꞌ tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam gɇꞌ chiop, jurnɨk jaꞌk baꞌ ba jimiaꞌ na ba tɨbiapmɨraꞌ baasɨꞌn jaꞌp oidhaꞌ taꞌm Oliibostam. ");
INSERT INTO stpNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na jax pɨx ji chonnidhaꞌm miꞌ ba aayaꞌ gu jaꞌtkam gɇꞌ chiop nam jix kaim kaꞌ gu Jesuus na tu ja aꞌgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Baꞌ bam aajim gu piasta na paiꞌ dhuuk jum kuaꞌdaꞌ gu paan jix basdak gakdhiꞌñchix kam, gio na paiꞌ dhuuk jup jum kuaꞌ gu kasnir bakaax. ");
INSERT INTO stpNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Gu ja gɇꞌgɇrkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, tɨi maap tu aꞌgadaꞌ am nam jax dhui gɨt tu chiñiaꞌ nam muꞌaaꞌ gu Jesuus, nam guꞌx ja ɨɨbhiꞌñdhaꞌ gu jaꞌtkam nam baꞌ tɨi cham juandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Guꞌ ji na guꞌ maadɨt gu mambhɨɨx daman gook gu noonbiꞌñ gu Jesuus bhaan baa gu jaꞌook, guiꞌ na Juudas tɨɨꞌ, nam Iskarioti kɨꞌn jup jix mat kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xi mɨɨ mu nam paiꞌ darkaꞌ gu ja gɇꞌgɇrkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, gio guiꞌ nam jir oꞌrosiiris bhaiꞌ gɇꞌ chiop, ba ja aagiꞌñ na sap guiꞌ ja aagiꞌñdhaꞌ na paiꞌ dhuuk jir am kaꞌ nam daagɨi tu chiñiaꞌ nam muꞌaaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Baꞌ guiꞌ giilhim jix bhaiꞌm ɨlh jamɨt na puiꞌ ja tɨtda, jup tɨtda am nam namkidhaꞌ noꞌt ja aaꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Baꞌ gu Juudas pɨx jix bhaiꞌp jum ɨlh nam aagiꞌñ gu tuumiñ, ba gaagidhaꞌ baꞌ na paiꞌ dhuuk jir am kaꞌ na ja aaꞌñdhaꞌ nam dagiaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Baꞌ nat bam ai na paiꞌ dhuuk jum kuaꞌ gu paan jix basdak gakdhiꞌñchix kam gio gu kasnir bakaax, ");
INSERT INTO stpNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","gu Jesuus ba ja jootos gu Peegro gio gu Juan nam tu bhaiꞌñpuꞌ nam maap tu jugiaꞌ jurnɨk kam, jup ja tɨtda: ―Mu jimiaꞌ pim aapiꞌm gook na pim tu bhaiꞌñpuꞌ bhaiꞌ dhɨr gɇꞌ kiicham nach tu jugiaꞌ jaꞌxñi jurnɨk nat bam ai dhi piasta bhaan Paaskua taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Baꞌ guiꞌ bhaiꞌp ba tɨkka am, jup tɨtda am: ―¿Jax chuꞌm baꞌk chɨr jap jix aaꞌ nach tu bhaidhaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Baꞌp ja tɨtda gu Jesuus: ―Dho bhaiꞌ na paiꞌ ji aayaꞌ maaꞌn gu maaꞌnkam tu baiꞌntugɨt baiꞌñdhakar taꞌm, ba tɨgiaꞌ pim na yaꞌ dɨr muiꞌ ba tu baiꞌntuꞌndaꞌ na pim jax mu aajidhaꞌ bha kikcham. Muiꞌ pim pu oidhaꞌ bhammɨ juugɨt maaꞌn kap kiicham na ji aayaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jaꞌp japim baꞌ tɨɨdaꞌ gu kiokam: “Jup kaiꞌch guch gɇꞌkam tuk nap sap paiꞌ taiñbuiꞌñ taak dɨr dhim baꞌaak, na miꞌ tu jugiaꞌ ja bɨɨm gu noonbiꞌñ jaꞌxñi jurnɨk dhi bhaan Paaskua taꞌm nat bam ai.” ");
INSERT INTO stpNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tu jam tɨɨꞌñchodaꞌ baꞌ bhɨjɨ jaꞌp daam dɨr na paiꞌ joidham jix chɨ kɨɨꞌ gio gɇꞌx chɨ gɨꞌɨɨr. Bhaiꞌ pim baꞌ ba tu bhaidhaꞌ nach tu jugiaꞌ jaꞌxñi jurnɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Baꞌ gamaiꞌ bhɨi mɨt na mɨt tu bhaidham. Puiꞌ ji chu buus na jax ja tɨtda gu Jesuus, baꞌ dai na mɨt bhaiꞌ ji chu bhaiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Baꞌ jaꞌxpɨx jurnɨk nat bam ai na paiꞌ dhuuk tum kuaꞌ gu bhaan Paaskua taꞌm, miꞌ ba ai gu Jesuus ja bɨɨm gu jaiꞌ noonbiꞌñ nam paiꞌ tu jugiaꞌ, pɨx mi jaꞌp ji dharaibu mɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Miꞌ dhɨr baꞌp ja tɨtda gu Jesuus bɨɨx gu noonbiꞌñ: ―¡Jaꞌp jañ tɨi bax aagɨt na gɨt puꞌñi bam aayaꞌ dhi piasta bhaan Paaskua taꞌm nañ baꞌx bhaiꞌñ chaatɨt jam bɨɨm xi chu jugai daipuꞌ maaꞌnnim pɨx baꞌ, nam guꞌ aañ bañ muꞌaaꞌ! ");
INSERT INTO stpNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cham jañ paiꞌ dhuuk ob ka tu jugiaꞌ joidham jix bhaiꞌñ chaatɨt na jax xib. Na paiꞌm aayaꞌ janoꞌ na pim paiꞌ dhuuk buiñor aayaꞌ guñ Gɨꞌkoraꞌ nañ baꞌ giox bhaiꞌñ chaatɨt jam bɨɨm jup ba tu jugiaꞌ, nach guꞌ janoꞌ bɨɨx maap tu jugiaꞌ bɨɨmaꞌn guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Baꞌ xi dhaagɨk gu alhiꞌch jaꞌaa na mi jim gu biiñ guiꞌ na uubas kɨꞌn jup duñiix, xi chu taxchaabgi buiñor gu Dios jix dhaam jaꞌk. Miꞌ dhɨr baꞌ mu jaꞌk xi ja bhɨiꞌñ gu noonbiꞌñ jup xi ja tɨɨdak: ―Dhiꞌñi pim jɨꞌmaꞌn kaam xi iꞌyaꞌ bɨɨx. ");
INSERT INTO stpNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aañ daipuꞌ xib pɨx jix bhaiꞌñ chaatɨt jam bɨɨm ba iꞌyaꞌ dhi biiñ. Na paiꞌm aayaꞌ janoꞌ na pim paiꞌ dhuuk buiñor aayaꞌ guñ Gɨꞌkoraꞌ nañ baꞌ giox bhaiꞌñ chaatɨt jam bɨɨm jup ba iꞌyaꞌ, nach guꞌ janoꞌ bɨɨx maap tu iꞌyaꞌ bɨɨmaꞌn guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Miꞌ dhɨr baꞌ gu paan jix basdak gakdhiꞌñchix kam jup xi dhaagɨk puiꞌp xi chu taxchaabgi buiñor gu Dios jix dhaam jaꞌk. Miꞌ dhɨr baꞌ taꞌtak jaisak muiꞌ xi ja maa, jup xi ja tɨɨdak: ―Dhiꞌñi pim muiꞌp xi jugiaꞌ. Dhiꞌr jiñ chuukuꞌ guiꞌ nam muꞌaaꞌ gu jaꞌtkam na baꞌ jam aꞌmkam kɨꞌn tu namkix kaꞌ gu jam uaꞌtulhdharaꞌ. Puiꞌ pim buadaꞌ na pim bhaan jiñ chɨꞌñchokaꞌ na ñich jam aꞌmkam tu namki. ");
INSERT INTO stpNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Baꞌ na mɨt xi jugaak gu paan jix basdak gakdhiꞌñchix kam, jumai bhaiꞌp ji bhɨi gu Jesuus gu alhiꞌch jaꞌaa na mi jim gu biiñ guiꞌ na uubas kɨꞌn jup duñiix. Baꞌ muiꞌ xi ja maa jup xi ja tɨɨdak: ―Dhi biiñ jup jir jiñ ɨꞌɨɨr guiꞌ na mɨlhiaꞌ na kɨꞌn jam aꞌmkam tu namkix kaꞌ gu jam uaꞌtulhdharaꞌ. Gam na dhiꞌ bhaan pup jix maatɨꞌ kaꞌ na xib dɨr maakam pup tu aagix nam jax jaꞌk buiñor bax biiñak kaꞌ gu Dios gu jaꞌtkam, cham tuꞌ puiꞌ na jax bɨjɨk dɨr. ");
INSERT INTO stpNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Baꞌ guiꞌ na maaxik jiñ kɨɨsaꞌ nam jiñ dhaagɨiñ muꞌaaꞌ, yaꞌñ bɨɨm tu kuaꞌ xib, ");
INSERT INTO stpNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","na guꞌm aaꞌ nañ miꞌ puiꞌ bhɨɨyaꞌ nat jax kaiꞌñkam bhañ joot guñ Gɨꞌkoraꞌ. Tɨix joiꞌgɨꞌn iñ guiꞌ na maaxik jiñ kɨɨsaꞌ, na guꞌ cham bhaiꞌ tu jimiaꞌ na puiꞌñ dhoodaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Baꞌ tɨi bhaiꞌ jim tɨ tɨkka mɨt bɨɨx gu noonbiꞌñ na jaroiꞌ baꞌr diꞌ guiꞌ na maaxik kɨɨsaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Baꞌ dɨɨlh miꞌ pɨx chuꞌ ba ji chɨi mɨt ɨp gu noonbiꞌñ gu Jesuus na sap jaroiꞌ baꞌ pɨk jix ioꞌm jir gɇꞌkam dai guiꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Baꞌp ja tɨtda gu Jesuus: ―Chaꞌpim puiꞌ tu jimdaꞌ na jax gu yaꞌ dhi oiꞌñgaꞌn kam gu gɇꞌgɇrkam nam maaꞌn kap pɨx ji dharaat tu ja chiandaꞌ nam tuꞌ jax buadaꞌ gu ja jaꞌtkamiꞌ, baꞌ cham tuꞌ iam jax jum kaiꞌchdhaꞌ na mɨt dɨɨlh gu jaꞌtkam tuꞌ jax dhuu. Guꞌ jaꞌpji gu ja gɇꞌgɇrkam tuk nam pɨx jix bhaiꞌ kaiꞌchdhaꞌ ja bui, nam guꞌ sap guiꞌx maatɨt puiꞌ ja chiandaꞌ gu tuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Guꞌ matgɨm noꞌ jaroiꞌ maadɨt aapiꞌm jix aaꞌ nar tuꞌ kaꞌ ja bui dhi jaiꞌ, jum aaꞌ ji na gampaiꞌm ɨlhiiꞌñdhaꞌ jaꞌp na gu alhii na kiaꞌpɨx gɨꞌlhidhaꞌ, piam na tujuandam pɨx jum ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nam guꞌ yaꞌ gu jaꞌtkam puiꞌ ɨlhiiꞌñ na gu jaroiꞌ na daibui ba tɨ nɨɨradaꞌ nam tu bhiidhaꞌ, dhiꞌ sap baꞌr gɇꞌkam kaꞌ panaas, guꞌ sap baꞌ gu jaroiꞌ na mu tu bhiidhaꞌ, jir tujuandam kaꞌ pɨx. Guꞌ matgɨm aañ cham tuꞌ ji nañ puiꞌ ɨlhiiꞌñ, jaꞌkbuiꞌ kat tujuandam kɨꞌn pɨx ya oirɨ iñ aañ nañ jax baꞌ yaꞌ ba jam palhbuiꞌñ bɨɨx aixim tuꞌm kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Guꞌ baꞌ na pim guꞌ aapiꞌm gammɨjɨ puñ bɨɨm jup tuiꞌdhiꞌ sia puiꞌ xich chulhiiñaidhat bɨɨx aixim bhaan, ");
INSERT INTO stpNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","aañ gɇꞌgɇrkam kɨꞌn jam darsaꞌ bɨɨx jɨꞌmaꞌn janoꞌ na paiꞌ dhuuk jum tɨɨmoꞌ dhi oiꞌñgaꞌn. Puiꞌñ gɇꞌgɇrkam kɨꞌn jup jam darsaꞌ jaꞌp na jax aañ guñ Gɨꞌkoraꞌ nat gɇꞌkam kɨꞌn jiñ dhai. ");
INSERT INTO stpNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Maaꞌn kap jañ baꞌ jam darsaꞌ na pim paiꞌ dhɨr ja tɨkkaꞌ bɨɨx gu Israel kam jaꞌtkam noꞌ mɨt miꞌ puiꞌ jii na jax jix aaꞌ guñ Gɨꞌkoraꞌ piam ku guꞌ cham. Gio baꞌ na pim jiñ bɨɨm tu kuaꞌdaꞌ gammɨjɨ gio na pim jiñ bɨɨm tu ioꞌdaꞌ tuꞌ na pim ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Baꞌ gu Jesuus jup tɨtda ɨp gu Simoon Peegro: ―Simoon, aañ jaꞌpni xim tɨɨdam. Gu jaꞌook jup tɨtda guñ Gɨꞌkoraꞌ na sap aapiꞌm bɨɨx jɨꞌmaꞌn jam maiꞌchiaꞌ tuꞌ bhaan na pim baꞌ gai suulhgiaꞌ. Guñ Gɨꞌkoraꞌ baꞌ puiꞌp tɨɨꞌn nar am na sap baꞌ bhaan machiaꞌ noꞌ pim bax ñakooꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Guꞌ ji na guꞌ aañ soiꞌ tɨtdatuꞌ ɨp guñ Gɨꞌkoraꞌ na aap jix ioꞌm jum palhbuidhaꞌ nap baꞌ gatuuk gioñ buip ba tɨ jɨɨgiꞌñdhaꞌ, sia kup guꞌ jɨꞌx tɨi cham xi chɨ jɨɨꞌñdhat jiñ bui. Baꞌ nap paiꞌ dhuuk gioñ buip ba tɨ jɨɨgiꞌñdhaꞌ, ja aagiꞌñdhaꞌ ap dhi jaiꞌ nam gammɨjɨ bɨɨx ja jujur kɨꞌn jiñ bui tɨ jɨɨgiꞌñdhaꞌ, cham tuꞌ nam ampɨx jum oꞌjolhiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Baꞌp kaiꞌch gu Simoon Peegro: ―Jax dhui nañ bɨɨx jiñ jur kɨꞌn jum bui tɨ jɨɨgiꞌñ. Pu cham jax jiñ aaꞌ iñ sia ku mɨt jum bɨndak jiñ kuu, piam ku mɨt jum bɨndak jiñ mua. ");
INSERT INTO stpNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Baꞌp tɨtda gu Jesuus: ―Jax dhui nap moo jaꞌxñi baikim puiꞌ pu ba tɨꞌyaꞌ nap cham jiñ maat na kiaꞌpɨx maaꞌnnim ba jiiñkiaꞌ gu takaaruiꞌ. Pum tɨtdañ moo Peegro. ");
INSERT INTO stpNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Miꞌ dhɨr baꞌp ja tɨtda gu Jesuus bɨɨx gu noonbiꞌñ: ―Janoꞌ na ñich puiꞌ jam joot na pim naiꞌ tu ja aꞌgiꞌñpuꞌ gu jaꞌtkam, janoꞌ bo nañ jup jam tɨtda na cham jum aaꞌ na pim uaꞌdaꞌ tuꞌ tuumiñ, nich chuꞌ aꞌsak, nich chuꞌ jam sussak ku pim jaiꞌ ja gaamtuꞌndaꞌ, ¿jia nat guꞌx bhaiꞌ tu jam jii sia ku pim puiꞌ jiimɨt? Baꞌ guiꞌp kaiꞌch am: ―Matgɨm jix bhaiꞌ ji nat tuch jii. ");
INSERT INTO stpNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Baꞌp ja tɨtda ɨp gio: ―Dho xib jañ baꞌ jaꞌp jup jam tɨtda na pim ba ja kusbioꞌ gu aꞌsak noꞌ pim ja biaꞌ, gio gu tuumiñ japim jup ba gaamuꞌ noꞌ pim biaꞌ. Noꞌ jaroiꞌ maadɨt cham biaꞌ gu kuxiir, xi gaꞌrai dho gux kabook kutuunaꞌn maaꞌn kɨꞌn sabaꞌdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nat guꞌ xib baꞌ bam ai na puiꞌ ba tum duñiaꞌ na jax jum kaiꞌch miꞌ na mɨt paiꞌ tu uaꞌnak gu bɨjɨk dɨr kam nap jum kaiꞌch: “Jaꞌp pɨx jamɨt puiꞌ jaꞌk xi aichuxdhak mua na sap cham jɨꞌx tuꞌ kaꞌm tɨ nɨiꞌñ, panaas ku puiꞌp jir tuꞌm kat na jax guiꞌ nam tuꞌ sɨlhkam cham tuꞌ kaꞌm tɨ nɨiꞌñ.” Na guꞌ bɨɨx na mɨt jɨꞌk jax tu uaꞌnak gu bɨjɨk dɨr kam nam aañ jiñ aagɨt jup kaiꞌch, bɨɨx puiꞌ ji chu buusniaꞌ sia pɨk nar jax kaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Baꞌ guiꞌp kaiꞌch am: ―Yaꞌni bɨɨt gook gu kukxir jich jaduuñ. Baꞌp ja tɨtda gu Jesuus: ―Cham tuꞌ ji na pim maatɨt jiñ kɇɇ. Chaꞌpim jax ka kaiꞌchdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Baꞌ miꞌ dhɨr buusnɨk ba jii ɨp gio gu Jesuus ja bɨɨm gu noonbiꞌñ mu jaꞌk sonpan gu oidhaꞌ Oliibostam, na paiꞌ pux joiꞌñ na aꞌjɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Baꞌ na jax pɨx miꞌ ji aajim, jup ja tɨtda bɨɨx gu noonbiꞌñ: ―Xi chu dañiaꞌ pim jix dhaam jaꞌk buiñor gu Dios na cham tu jam maiꞌchiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Baꞌ dɨɨlh jaꞌx xi jimɨɨk oꞌlhiaꞌn kɨꞌn xi kɨkbok muiꞌp ji chu daanɨx dhaam jaꞌk buiñor gu Dios, ");
INSERT INTO stpNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","jup kaiꞌch: ―Aapiꞌñ Gɨꞌkoraꞌ, xiñ palhbuiꞌñ nam cham jiñ muꞌaaꞌ, na guꞌ dhiꞌ jaꞌp ji buusan nañ iꞌyaꞌ gu tuꞌ na giilhim jix xibuꞌ. Ku guꞌ noꞌp aap jix aaꞌ ji, aañ puiꞌ pɨx tɨi soiꞌm tɨtda ji. ");
INSERT INTO stpNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Baꞌ jotmodaꞌ maaꞌn miꞌ bam maax gu nobiiꞌñ gu Dios nat bha tajaañdham guiꞌ na kɨꞌn nakgaꞌ gu tulhiiñaraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Baꞌ giilhim jix buam tu tatdaꞌ gu Jesuus na bhaan bam tajaanaim guiꞌ na kɨꞌn tu nakgaꞌ, guꞌ ji na guꞌ cham jum oꞌjolhdhat xi chu daañchuꞌ buiñor gu Dios. Gio ɨꞌɨɨr bhaiꞌ ji boorat, gɇꞌgɇr mi jaꞌp ba iigɨs dɨɨrap. ");
INSERT INTO stpNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Baꞌ mɨkkat kɨkbok ba jii ɨp gio mu nam paiꞌp tuꞌiiꞌ gu noonbiꞌñ nat jɨꞌx xi chɨɨmok na xi chu dañiimɨk. Baꞌ miꞌ pɨx kookos am nat mu ba ai ɨp gio, ja kookxich guꞌ nam bhaan jix buam jum aaꞌ nam puiꞌ muꞌaaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Baꞌp ja tɨtda: ―¡Gor xi ñiññia! ¿Jax ku pim baꞌ dai kookos? Xi baapmigɨi pim xi chu dañiaꞌ buiñor gu Dios na cham tu jam maiꞌchiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Baꞌ na miꞌ puiꞌ ka ja tɨtda gu Jesuus gu noonbiꞌñ, miꞌ dhɨr jaꞌp muiꞌ ji bubua mɨt muiꞌ gu jaꞌtkam. Gu Juudas pɨk bɨɨpɨꞌ xi jim, guiꞌ na tɨi maadɨt jir diꞌ gu mambhɨɨx daman gook gu noonbiꞌñ. Baꞌx ioꞌm amuub xi ɇɇk na paiꞌ gu Jesuus bhaiꞌ xi chiñxi kaamaram. ");
INSERT INTO stpNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Baꞌp tɨtda gu Jesuus: ―Juudas, ¿pu kaiꞌñkam aa pich bhañ chiñxi nap maaxik jiñ kɨksa nam jiñ dhagiaꞌ dhi jaꞌtkam nam yaꞌ jiim aañ nañ bhaankam ya oirɨ gu Dios? ");
INSERT INTO stpNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Baꞌ gu noonbiꞌñ gu Jesuus, na guꞌ cham kar am nam jax tɨ nɨiꞌñ, jup tɨtda am: ―¿Jich jaduuñ, cham jach guꞌ tu kokdaꞌ dhich kukxir kɨꞌn nach ja uaꞌ, kaꞌch ji guꞌ cham joiñat guꞌkaꞌ aa? ");
INSERT INTO stpNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Baꞌ maadɨt nat jax dhaa gu kuxiir bhaiꞌ tɨi soñiich gu tujuandam tugiꞌñ gux ioꞌm ja gɇꞌkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, guꞌ ji nat guꞌ dai naakaꞌn pɨx ai, mu jaꞌp ji sai. ");
INSERT INTO stpNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Baꞌp ja tɨtda gu Jesuus: ―Chaꞌpim ja juandaꞌ. Bax bhaiꞌ. Baꞌ puiꞌ xi ja tɨɨdak giop xi dhuaꞌñdhak gu naakaꞌn guiꞌ na mɨt soñiich. ");
INSERT INTO stpNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Miꞌ dhɨr baꞌ gu ja gɇꞌgɇrkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, gio guiꞌ nam jir oꞌrosiiris bhaiꞌ gɇꞌ chiop, gio baꞌ gu ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam, jup ja tɨtda: ―¿Jax ku pim baꞌ kukxir ji chu uaꞌdat bha jaꞌk jiim gam uꞌuux jix kaapak? ¿Jir jix ɨxkum iñ aa panaas? ");
INSERT INTO stpNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","¿Gio guꞌ cham bhaaiꞌ aa na pim gɨt bhaiꞌ puñ dhagiaꞌ gɇꞌ chiop nañ moo bhaiꞌ oirɨt pu tu jam aꞌgiꞌñdhaꞌ nabap tanoolh na pim gɨt baꞌ cham puꞌñi yammɨ jaꞌp bañ gaagidhaꞌ? Ku guꞌ dhiꞌ na jax dhui miꞌ pɨx puiꞌ ba jim ji, nat guꞌ xib baꞌ kam ai na paiꞌ dhuuk jam daam jimiaꞌ gux chukgam. ");
INSERT INTO stpNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Baꞌ daagɨk jamɨt pu bhɨɨk gu Jesuus bhammɨ na paiꞌ kio gux ioꞌm ja gɇꞌkam tuk bɨɨx guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam. Baꞌ gu Peegro mɨk dɨr mu ja oiꞌñchuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Baꞌ mɨjɨ ɨrban dɨr ba tu nai mɨt gu oꞌrosiiris, mi jaꞌp na paiꞌ gɇꞌx chɨ gɨꞌɨɨr, miꞌm baꞌ daraat bɨɨx xikoolh ba juukaꞌ, bɨɨx gu Peegro miꞌp ji dhaibu ja sanoop. ");
INSERT INTO stpNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Baꞌ na miꞌ ka juukaꞌ gu Peegro, maaꞌn gu ubii guiꞌ na miꞌr tujuandam kaꞌ miꞌ dhɨr jaꞌp bhaiꞌ ba nɨiꞌñ na mamtɨ, baꞌp ja tɨtda guiꞌ nam miꞌp daraa: ―Dhiꞌñi dho bɨɨx jup kaichuꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Guꞌ ji na guꞌ gu Peegro cham tu aaꞌ, jup kaiꞌch: ―¿Jax jap baꞌ kaiꞌch? Jax dhui nañ pu cham maat gu jaroiꞌ nap aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Baꞌ jaꞌxpɨx jumai gu maaꞌnkam puiꞌ bhaiꞌp xi ñɨidhimɨk jup tɨtda: ―Moo chi aap puiꞌp kaichuꞌ gu Jesuus, ¿kaꞌ cham? Baꞌp kaiꞌch gu Peegro: ―Cham tuꞌ ji matgɨm jiñ jaduuñ. Dɨɨlh ji nañ jup oilhim. ");
INSERT INTO stpNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Baꞌ jaꞌx xi mɨɨkim paꞌ nat jumai gu maaꞌnkam miꞌp ba ai na paiꞌ kɨɨk gu Peegro, baꞌ puiꞌ bhaiꞌp xi ñɨidhimɨk jup ja tɨtda gu jaiꞌ nam miꞌp tuꞌiiꞌ: ―Jaiꞌp kaichgɨt moo dhiꞌ gu Jesuus, jix maatɨꞌ na jax chuꞌiiꞌ, gio guꞌr mu kam Galilea. ");
INSERT INTO stpNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Baꞌp kaiꞌch gu Peegro: ―¿Jax jap baꞌ kaiꞌch jiñ jaduuñ? Jax dhui nañ moo pu cham maat gu jaroiꞌ nap aaꞌ. Baꞌ na puiꞌ ka kaiꞌch gu Peegro, ba jiiñ gu kɨlhii takaaruiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Baꞌ gu Jesuus jotmodaꞌ mu tɨɨ gu Peegro. Gu Peegro bhaiꞌ pup tɨꞌñcho na pɨn bɨɨpɨꞌ dɨr jup tɨtda gu Jesuus: “Jax dhui nap moo jaꞌxñi baikim puiꞌ pu ba tɨꞌyaꞌ nap cham jiñ maat na kiaꞌpɨx maaꞌnnim ba jiiñkiaꞌ gu takaaruiꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Baꞌx buam jum ɨlh gu Peegro. Buusnɨk baas dɨr jaꞌp dɨɨrap ma susua. ");
INSERT INTO stpNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Baꞌ gu oꞌrosiiris guiꞌ nam miꞌ daraat nuukaꞌn gu Jesuus, jax ñam pɨx bua. Bha gɨb am, as am baꞌ puiꞌ xi buaꞌt. ");
INSERT INTO stpNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Xi bupprat am jannulh kɨꞌn gu buupuiꞌñ nam bha gɨb, jup tɨtdadaꞌ am baꞌ: ―¿Jaroo bham gɨb? ");
INSERT INTO stpNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bɨɨx aixim na jax aaꞌ kum pu tɨtda gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Baꞌ buimgidhak nat ba tu maaxir, maap jamɨt bam jumaap gu ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam, gio gu ja gɇꞌgɇrkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, gio baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios. Ba bhɨɨk jamɨt baꞌ gu Jesuus mu na paiꞌ tum aꞌga, baꞌ mu aichdhak bhaiꞌ ba tɨkka am, jup tɨtda am: ");
INSERT INTO stpNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Ea nap jich aagiꞌñdhaꞌ nach jaꞌp tuꞌm xim tɨkkam. ¿Jaꞌp aa sɨlhkam aap jir diꞌ guch Xoiꞌkam? Baꞌp ja tɨtda gu Jesuus: ―Jax dhui na pim cham tuꞌñ jɨɨgiꞌñdhaꞌ sia kuñ tɨip jam aagiꞌñ nañ aañ jir diꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Gio noꞌñ tuꞌ tɨip xi jam tɨkka, sia cham jiñ aagiꞌñdhaꞌ pim. ");
INSERT INTO stpNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ku guꞌ aañ xib dɨr sonpan ba daakaꞌ ji kɨɨꞌn dɨr guñ Gɨꞌkoraꞌ na giilhim bɨxchuꞌx bhaaiꞌ na pu tu duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Baꞌp tɨtda am bɨɨx dhɨt nam jɨꞌk miꞌp tuꞌiiꞌ: ―¿Jaꞌp kaiꞌñkam jup kaiꞌch ap aa baꞌ nap Dios jir Maraaꞌn? Baꞌp ja tɨtda gu Jesuus: ―Dho aañ jir Maraaꞌn maaxik, gio guꞌ aapiꞌm dɨɨlh puiꞌp kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Baꞌp kaiꞌch am dɨɨlh guiꞌ: ―¡Dho jaiñ! ¿Jaroiꞌ aach pup ka nɨɨraꞌ nach aagiꞌñdhaꞌ noꞌx buam kaiꞌch piam ku guꞌ cham? Dɨɨlh chiñiiꞌñ kɨꞌn ba kai chich guꞌ na jax kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Baꞌ miꞌ dhɨr na mɨt jax guguu ɨp gio, ba bhɨɨk jamɨt gu Jesuus mummɨ na paiꞌ gu Pilaato. ");
INSERT INTO stpNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mu buiñor ba iattulhiꞌñ am baꞌ, jup tɨtda am: ―Aach jaꞌp tuꞌm kɨꞌn yaꞌm uaꞌtulhiꞌñ dhi maaꞌnkam. Mu jaꞌp oirɨt ja kokdhichuꞌn guch jaꞌtkamiꞌ, jup ja tɨtda nam sap cham namkiꞌñdhaꞌ gux ioꞌm gɇꞌkam Rooma kam. Gio na puiꞌ ja tɨtda na sap jir diꞌ guch Xoiꞌkam, na jaꞌp kaiꞌñkam jup ji kaiꞌchɨt na dhiꞌr diꞌ gux ioꞌm jich gɇꞌkam tuk. ");
INSERT INTO stpNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Baꞌ gu Pilaato xi chɨkka dɨɨlh gu Jesuus, jup tɨtda: ―¿Aapiꞌ aax ioꞌm jir ja gɇꞌkam tuk gu Israel kam jaꞌtkam? ―Aañiꞌ dho ―jup kaiꞌch gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Baꞌp ja tɨtda gu Pilaato gu ja gɇꞌgɇrkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, gio gu jaꞌtkam nam jɨꞌk miꞌp tuꞌiiꞌ: ―Aañ cham tuꞌ buam kɇɇ dhi maaꞌnkam puiꞌ na jax kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Baꞌx ioꞌm gɇꞌ kɨꞌn jup kaiꞌch am guiꞌ: ―Jaꞌpji aach na cham jich koꞌraar na maakam ja mamtuxdhim guch jaꞌtkamiꞌ. Mummɨ dɨr bhaiꞌ ji kɨi Galilea, saalh puiꞌ yammɨ jaꞌp ba ja iatgidhim Judea. ");
INSERT INTO stpNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Baꞌ nat ja kai gu Pilaato na mɨt Galilea dɨr bhaiꞌ ji chu aa, ba ja tɨkka noꞌr Galilea kam gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Guiꞌp xi aagiꞌñ am nar Galilea kam. Baꞌ mu jaꞌk xi joochxi gu Eroodis, guiꞌ na mur gɇꞌkam kaꞌ Galilea. Janoꞌ pɨk bhaiꞌp oirɨ Jerusaleen. ");
INSERT INTO stpNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Baꞌ giilhim jix bhaiꞌm ɨlh gu Eroodis nat ba tɨɨ gu Jesuus, na guꞌ puiꞌm aaꞌndaꞌ na chiñiaꞌ na tuꞌ jax xi dhuiñdhaꞌx bhaiꞌm duukam na tuꞌ cham paiꞌ dhuuk pu chuꞌm nɨiꞌñ na paiꞌ dhuuk puꞌñi tɨgiaꞌ. Puiꞌ tɇ kɇɇkɇꞌ guꞌ gu Eroodis na gu Jesuus mu jaꞌp paiꞌ joidham jix bhaiꞌm duukam jup tu buadaꞌ, nam tuꞌ cham paiꞌ dhuuk pu chuꞌm tɨ nɨiꞌñ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Bɨɨx aixim baꞌ bhaiꞌ tɨi ji tɨkka, guꞌ ji nat guꞌ pu cham ñio gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Baꞌ bɨɨx miꞌp tuiꞌdhiꞌ am gu ja gɇꞌgɇrkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, gio guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios. Dhiꞌ pɨk pup xim taattuꞌ am guꞌ nam iattulhdhim gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Baꞌ jax ña pɨx xi buaꞌt as gu Eroodis gu Jesuus, tuꞌ pɨx ɨlhiiꞌñ. Sia gu sandaaruiꞌx chugiꞌñ jam jaiꞌ puiꞌp xi bua. Xi chɨiꞌ mɨt ɨp baꞌ gu jannulh gux dhaꞌram namkɨm nam jax chuꞌm ja tɨ tɨꞌ gux ioꞌm gɇꞌgɇrkam, ma aꞌsɨ mɨt baꞌ xi chɨiꞌdhak. Miꞌ dhɨr baꞌ gio mu jaꞌk jup xi joochxi gu Pilaato. ");
INSERT INTO stpNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Baꞌ janoꞌ guiꞌ gu tanoolh chaꞌm dɨr bhaiꞌx bhaiꞌ ji chɨi mɨt gu Pilaato gio gu Eroodis, nam guꞌ bɨɨpɨꞌ dɨr ka xim bhabhaakuiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Baꞌ gu Pilaato maap xi ja jumpadak gu ja gɇꞌgɇrkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, gio guiꞌ nam jir ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam, ");
INSERT INTO stpNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","baꞌp ja tɨtda: ―Aañ cham tuꞌ tuꞌ bhaan buam kɇɇ dhi maaꞌnkam na pimɨt gio yaꞌp bañ aichulh na puiꞌ mu jaꞌp paiꞌ oirɨt ja kokdhichuꞌn gu jam jaꞌtkamiꞌ. Tɨi ñich bɨɨx aixim ba tɨkka na pim jax jiñ kɇɇ, cham tuꞌr jix buam panaas aañ jiñ bui na jɨꞌk jax kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Sia chi gu Eroodis puiꞌ cham paiꞌ buam jup kai na jax kaiꞌch, tɨɨꞌ nat gio bhaiꞌp xiñ joochxi. Cham tuꞌ ji matgɨm na tuꞌ bhaan kuiñcha biaꞌ nach moo bhaan jup ba ji muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Xi chu chiñiaꞌ iñ nam gɨɨꞌbiaꞌ chipliiñ kɨꞌn, miꞌ dhɨr jañ xi chu chiñiaꞌ nam doꞌñchoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Baꞌ nabap oidhaꞌ na paiꞌ dhuuk puꞌñi aajidhaꞌ gu piasta bhaan Paaskua taꞌm, maaꞌn jup dadoꞌñchodaꞌ gu Pilaato guiꞌ nam kuupkaꞌ nam baꞌ bhaan jix bhaiꞌm taat kaꞌ gu jaꞌtkam. Guꞌ baꞌ gu Pilaato tɨix aaꞌ na gu Jesuus doꞌñchoꞌ, ");
INSERT INTO stpNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","guꞌ ji na mɨt guꞌ bɨɨx dhɨt pɨx jiiñak gɨi gu jaꞌtkam, jup kaiꞌch am: ―Tu chiañiñ nam muꞌaaꞌ dhi Jesuus, gu Barrabaas jap baꞌ doꞌñchoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Gu Barrabaas bhaiꞌ kuupkaꞌ muaꞌdaꞌ kɨꞌn, gio na ja bɨntatgɨt guiꞌ na mɨt buiñor bhaakuk tu kokda gux ioꞌm gɇꞌkam Rooma kam bhaiꞌ Jerusaleen. ");
INSERT INTO stpNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Guꞌ baꞌ na guꞌ gu Pilaato tɨix dhoꞌñchom gu Jesuus, tɨi gio puiꞌp xi ja tɨɨꞌn na cham tuꞌ bhaan kuiñcha biaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Guꞌ ji nam guꞌ guiꞌx ioꞌm gɇꞌ kɨꞌn ba xi jiiñak, jup kaiꞌch am: ―¡Tu chiñiaꞌ ap nam sissapaꞌ kuruus taꞌm dhi Jesuus! Gookim miꞌmiaꞌn jamɨt pu tɨɨꞌn na sap tu chiñiaꞌ nam kuruus taꞌm sissapaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Baꞌ gio puiꞌ tɨip xi ja tɨɨꞌn gu Pilaato, jup ja tɨtda: ―Jax dhui nat cham tuꞌx buam duu gu tuꞌ gɇꞌkam kɨꞌn kuch moop ba tu chian nam muꞌaaꞌ. Xi chu chiñiaꞌ iñ nam gɨɨꞌbiaꞌ chipliiñ kɨꞌn, miꞌ dhɨr jañ xi chu chiñiaꞌ nam doꞌñchoꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Guꞌ ji nam guꞌ guiꞌ pɨx ji kɨɨsaim nam chian na tu chiñiaꞌ nam sissapaꞌ kuruus taꞌm. Nat paiꞌ pu tɨi gu Pilaato na puiꞌ tu duñiaꞌ nam jax kaiꞌch na mɨt baꞌ cham ka ñio, ");
INSERT INTO stpNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","sia ku guꞌ tɨi pup cham xi aagimɨk nam muꞌaaꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Baꞌ xi chu chia nam doꞌñchoꞌ gu Barrabaas na muaꞌdaꞌ kɨꞌn bhaiꞌ kuup, gio na ja bɨntatgɨt guiꞌ na mɨt buiñor bhaakuk tu kokda gux ioꞌm gɇꞌkam Rooma kam bhaiꞌ Jerusaleen, dai baꞌ nat xi chu chia nam dɨɨlh pu doodaꞌ gu Jesuus nam jax puiꞌx aaꞌ gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Baꞌ nam gamaiꞌ ba uaꞌ gu Jesuus na mɨt ba sissapam, maaꞌn gu maaꞌnkam Simoon tɨɨgim jamɨt gamaiꞌ chia na mootikaꞌ gu kuruus oidhat dɨr gu Jesuus. Jir Sireene kam guiꞌ gu maaꞌnkam, kiaꞌpɨx mu paiꞌ dhɨr jimdat gampɨx muiꞌ ka aajim. ");
INSERT INTO stpNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Baꞌ muiꞌ mu jiimchuꞌ am gu jaꞌtkam nam oiꞌñchuꞌ gu Jesuus, suañim am gu uꞌuub nam jix koꞌkom nɨidhim. ");
INSERT INTO stpNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Baꞌp ja tɨtda gu Jesuus bhaiꞌ xi ja tɨɨgɨk: ―Aapiꞌm uꞌuub Israel kam, chaꞌpim jiñ xuañdhidhaꞌ aañ, na guꞌ aañ jix bhaiꞌ tuñ jim. Aapiꞌm ji dɨɨlh na pim jum suañiꞌñdhaꞌ gio gu jam maamar. ");
INSERT INTO stpNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Na guꞌm aajim gu tanoolh na pim paiꞌ dhuuk jup kaiꞌchdhaꞌ tɨi: “Joidham jix bhaiꞌ tu ja jii guiꞌ na cham jir ja ai gu aꞌaalh, na mɨt cham jɨꞌxkat tu xiꞌiich, ni ku mɨt cham jɨꞌxkat jum aꞌlhich chuutkamta.” ");
INSERT INTO stpNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Baꞌ miꞌ dhɨr bɨɨx gu Israel kam jaꞌtkam tɨix aaꞌndaꞌ am nam gɨt maaꞌn jimdam koꞌyaꞌ. Jup ja tɨtdadaꞌ am tɨi gu oiꞌdhaꞌ: “Gor iam bhaiꞌch aꞌm xi iaꞌlh.” ");
INSERT INTO stpNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Na guꞌ nam jax jiñ chulhiiñchuꞌn aañ xib, jaꞌp pɨx ji buusan na jax gux baaꞌ kuꞌaaꞌ na cham mɨidhaꞌ sia ku tɨi mɨɨjim, nañ guꞌ aañ cham tuꞌ kuiñcha biaꞌ. Guꞌ gi baꞌ guiꞌ nam jix uꞌuaꞌtulhdhix kaꞌ, ¿jax japim ɨlhiiꞌñ na tu ja doodaꞌ janoꞌ nam paiꞌ dhuuk jup jum tulhiiñaꞌ? Na guꞌ jaꞌp ji buusniaꞌ na jax gux gak kuꞌaaꞌ na maaꞌn jimdam mɨɨyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Baꞌ gook pup muiꞌp ja uaꞌ am gu jaꞌtkam nam puiꞌp ja sissapaꞌ maap gu Jesuus kukrus taꞌm. Dhi gook jaꞌtkam ɨɨxdharaꞌ kɨꞌn ja koodaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Baꞌ bhammɨ na paiꞌ Kakoiꞌ Moꞌ Daa tɨ tɨɨꞌ, bhaiꞌ mɨt ba sissapa kuruus taꞌm gu Jesuus. Baꞌ gu jaiꞌ gook jaꞌtkam nam jup ja uaꞌ, bɨxxik dɨr jamɨt ja sissapa, ɨrban baꞌ ji bii gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Baꞌp kaiꞌch gu Jesuus: ―Jiñ Gɨꞌkoraꞌ, chakuip tuꞌp jum buixiꞌñdhaꞌ ja bui dhi jaꞌtkam, nam guꞌ cham maat noꞌm jup jum uaꞌtulhiꞌñ jum bui. Baꞌ gu sandaaruiꞌx mi jaꞌp ma tɨtbia mɨt mi jaꞌp ji chu darsak amuub gu jajannulhiꞌñ gu Jesuus na sap baꞌ gu jaroiꞌ na tu maiꞌchiaꞌ, bhaan ji chu biꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Gu jaꞌtkam baꞌ mu jaꞌp guꞌkat bha ja nɨiꞌñ am guiꞌ nam bhaiꞌ sissap. Baꞌ jaiꞌ gu ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam jax ñam pɨx aꞌga gu Jesuus, jup kaiꞌch am: ―Dɨɨlh dho jia xim palhbuidhaꞌ. Tɨɨꞌ nat baꞌ jaiꞌ gu jaꞌtkam bɨxchuꞌ pɨx bhaan ja palhbui. ¿Guꞌ dɨɨlh aa baꞌ cham jup bhaaiꞌ? Gio guꞌ saak jir diꞌ guch Xoiꞌkam nat bhaan tɨ tɨɨgɨk bha joot gu Dios bhammɨ dɨr jix dhaam. Bhaiꞌ dhɨr dho ji chɨmñiaꞌ noꞌ baabuiꞌr sɨlhkam. ");
INSERT INTO stpNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sia gu sandaaruiꞌx puiꞌ jax ñam pɨx jup xi buaꞌt as gu Jesuus, bha iꞌchuꞌn am gu biiñ jix jɨꞌɨɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Gam nam jup xi chɨtdat: ―¿Gi nap saak aap jix ioꞌm jir ja gɇꞌkam tuk gu Israel kam jaꞌtkam? ¿Kux cham bhaaiꞌ aa nap dɨɨlh bhaiꞌ dhɨr ji chɨmñiaꞌ na puiꞌ bɨxchuꞌx bhaaiꞌ nap pu tu duñiaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Baꞌ bhaiꞌ moꞌbon gu Jesuus maaꞌn bha siis jamɨt gu taaꞌmla alhiꞌch komaarak na gɇꞌgɇr kɨꞌn bha tu uaꞌñix, jup jum kaiꞌch: “Dhiꞌñir diꞌ gux ioꞌm ja gɇꞌkam tuk bɨɨx gu Israel kam jaꞌtkam.” ");
INSERT INTO stpNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Baꞌ maadɨt guiꞌ nam bɨxxik dɨr jup sissap kukrus taꞌm, jaiꞌ puiꞌp xi chɨtda gu Jesuus, jup kaiꞌch: ―Noꞌp baabuiꞌ sɨlhkam aap jir diꞌ guch Xoiꞌkam nat Dios bham joot, dɨɨlh jap dho bhaiꞌ dhɨr ji chɨmñiaꞌ, sia aach jap jaiꞌp xich palhbuidhaꞌ nach yaꞌch chulhiiñ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Baꞌ gu jumai na jaꞌp dɨr jaꞌk jup sissap jup tɨtda gu bɨɨmaꞌn tuꞌm: ―¿Kux aap moo cham jax jum aaꞌ aa na tɨim tulhiiñchuꞌn gu Dios jaꞌp na jax aañ? Aach maaxik yaꞌ puiꞌ ba tuꞌiiꞌ guꞌ na jax jaꞌk jich aꞌm jum aaꞌ, na chich guꞌ maaxik jich uaꞌtulh na chich puiꞌ ji chu dunaak na tuꞌ cham jir kɨɨꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Guꞌ dhiñ jaduuñ tɨi cham tuꞌ jax dhuu na yaꞌ puiꞌ tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Miꞌ dhɨr baꞌp tɨtda gu Jesuus: ―Aapiꞌ Jesuus, siamrip xiñ chɨꞌñchoi xiñ baidhai nañ jum bui bap tuiꞌkaꞌ nap paiꞌ dhuuk jix ioꞌm gɇꞌkam kɨꞌn ba daibuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Baꞌp tɨtda gu Jesuus: ―Xib jap bhammɨp tuiꞌkaꞌñ bɨɨm na paiꞌ joidham jix chu abhaar. Aañ yaꞌ pum tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Baꞌ jotmodaꞌ bhaiꞌ ji chum tukgamta. Kiaꞌpɨx jix dhaam ba ji dhunaak nat puiꞌ tum duu, nammɨ jaꞌp mia ba duu nat paiꞌ dhuuk gio bhaiꞌp ji chu maaxir. ");
INSERT INTO stpNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Dɨɨlh pɨx naiꞌ ji chuu gu tanoolh. Baꞌ gu gɇꞌx kabook jannulh na mu sɇꞌkaꞌ ɨrban dɨr gu gɇꞌ chiop, pu ɨrban sar. ");
INSERT INTO stpNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Baꞌp kaiꞌch gu Jesuus gɇꞌ kɨꞌn: ―Jiñ Gɨꞌkoraꞌ, ba bhɨikaꞌ ap dhiñ iiꞌmdaꞌ kum bui bap tuiꞌkaꞌ. Baꞌ puiꞌ xi chɨꞌɨɨk naiꞌ ji muu. ");
INSERT INTO stpNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Baꞌ guiꞌ nar ja gɇꞌkam tuk kaꞌ bɨɨx gu sandaaruiꞌx, nɨiꞌñ nat gɇꞌ kɨꞌn puiꞌ xi chɨꞌɨɨk ba muu gu Jesuus. Baꞌ joiꞌmdaraꞌ bhaiꞌ ji chum suulh nat puiꞌ kai, baꞌp kaiꞌch soiꞌm ɨlhdhat buiñor gu Dios: ―Maaxik cham tuꞌ ji na tɨi kuiñcha biaꞌkat dhi jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Baꞌ gu muiꞌ jaꞌtkam na mɨt miꞌp jum duu, jix buam jum ɨlhdhak ba jii mɨt bhaiꞌ xi gɨbiidhat gu ja bhaasut. ");
INSERT INTO stpNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dai baꞌ guiꞌ nam jɨꞌk jix ioꞌm jix kɨɨgalhdhat gu Jesuus mummɨ jaꞌp guꞌkat bhaiꞌ pup nɨiꞌñ am, gio jaiꞌ gu uꞌuub na mɨt mummɨ dɨr bhaiꞌ pu oi Galilea. ");
INSERT INTO stpNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Baꞌ maaꞌn jix jaiꞌch kaꞌ gu maaꞌnkam Josee tɨɨgim, jir Arimatea kam na paiꞌ bhaan bipioꞌ gu Judea kam dɨbɨɨr. Joidham jir jix bhaiꞌkam kaꞌ, na guꞌ jaiꞌ puiꞌ tɨip tɨ nɨɨradaꞌ na gɨt bam aayaꞌ na gu Dios ja sɨlhkadaꞌ bɨɨx gu jaꞌtkam yaꞌ dhi oiꞌñgaꞌn, nam baꞌ miꞌ puiꞌ ba jiimdaꞌ na jax jix aaꞌ. Baꞌ dhiꞌ jaiꞌ maadɨt jup jir dhiꞌ kaꞌ nar ja gɇꞌgɇrkam tuk kaꞌ bɨɨx gu Israel kam jaꞌtkam, guꞌ ji nat guꞌ cham tuꞌ maaꞌn ñiꞌook jup duu ja bui janoꞌ na mɨt paiꞌ dhuuk tu aꞌga nam bax muꞌaak gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dhiꞌ jɨꞌ baꞌ Josee mu jimɨɨk pu tɨɨꞌn gu Pilaato noꞌx bhaaiꞌ na tɨbaañdhai ulhñaraꞌ gu tukgaꞌn gu Jesuus. Baꞌ gu Pilaato cham jax tɨꞌɨɨk jup xi chia. ");
INSERT INTO stpNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Baꞌ xi chɨbaañdhak bhaiꞌ dhɨr kuruus taꞌm ba ulhñam, dai nat xi bhiibgak jannulh kɨꞌn xibkam jix dhaꞌram namkɨm. Maaꞌn kap baꞌ ulh na paiꞌx chiobim jaꞌk tɨ dɨꞌ, miꞌ nam paiꞌ pu puiꞌ jaꞌk tɨ dɨꞌngaras aiꞌ chaꞌm nam baꞌ puꞌñi miꞌ ja ulhñaidhaꞌ gu koiꞌñgaꞌn. Dai nat miꞌ chakui jaroiꞌ maaꞌnnim mim ulhñak nat paiꞌ bam ulh gu tukgaꞌn gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Baꞌ janoꞌ bam ai ɨp gu tanoolh nam jix bhaiꞌ tu duñiaꞌ bɨɨx gu Israel kam jaꞌtkam, na guꞌ buimgidhak cham tum juandaꞌ guiꞌ ja bui. ");
INSERT INTO stpNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Baꞌ gu uꞌuub guiꞌ na mɨt mummɨ dɨr bhaiꞌ pu oi gu Jesuus Galilea, bɨɨx jup jiim am na mɨt ulhñam gu tukgaꞌn. Nɨiꞌñ am baꞌ na mɨt jax jaꞌk mi tɨɨ gio na mɨt jax chuꞌm chiob tɨɨ. ");
INSERT INTO stpNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Baꞌ mu dɨr na mɨt jaꞌk suulhgɨk, jix bhaiꞌ mɨt pu xi dhuuk guiꞌ na joidham uub, nam baꞌ mu juulhdhapuꞌ tukgaram gu Jesuus na jax pɨx xi buusniaꞌ gu tanoolh na paiꞌ dhuuk cham tum juandaꞌ, na jax tu aagix nat tu uaꞌnak gu Moisees bhaankamuꞌn gu Dios. Dai baꞌ nam jum jɨɨpiꞌñ buimgidhak gu bɨx chanoolh. ");
INSERT INTO stpNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Baꞌ kapbhuimuk na paiꞌ dhuuk giop ba tum juan, mu jii mɨt ɨp gio gu uꞌuub mummɨ nat paiꞌm tɨɨ gu tukgaꞌn gu Jesuus. Ka pup jix ɨɨkaꞌ na mɨt mu jii, dai na mɨt xi ja uꞌuuk gu ɨꞌlhich jajaꞌ na mi jim guiꞌ na joidham uub, na mɨt pu bas takaab dɨr jix bhaiꞌ ba ja duu. ");
INSERT INTO stpNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Baꞌ na mɨt mummɨ ba ai, bhaiꞌ pɨx pu tɨ dɨꞌ bhɨjɨ na mɨt paiꞌ tɨɨ gu tukgaꞌn gu Jesuus, jaꞌp jaꞌk dɨlhkob pɨx kɨɨk gu gɇꞌ jodai guiꞌ na kɨꞌn bha kuupich. ");
INSERT INTO stpNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Baꞌ muiꞌ ji baap jamɨt mɨjɨ ɨrban dɨr. Cham paiꞌ tu jaiꞌch gu tukgaꞌn gu Jesuus na mɨt ba tɨɨ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Baꞌ miꞌ bhaiꞌ ji chootoꞌn jamɨt, cham ka bhaaiꞌ nam jax jum duñiaꞌ. Gan jam tɨi xi chɨ nɨiꞌñ nat paiꞌ baꞌ jax jum duu. Baꞌ miꞌ pɨx jaꞌp ji ja tɨɨ mɨt nam guguuk gook gu jaꞌtkam jix chooto tɨ tɨꞌ kam tobiikdam. ");
INSERT INTO stpNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Baꞌ giilhim jix chotdonɨt naiꞌ ji mumgia mɨt guiꞌ. Baꞌp ja tɨtda am gu gook jaꞌtkam: ―Jax dhui na cham tuꞌ yaꞌ kap tuꞌiiꞌ koiꞌñgaꞌn tɨr guiꞌ na pim jaroiꞌ gaꞌnga. ");
INSERT INTO stpNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Duadɨk buus ɨp gio na jax jam tɨtda janoꞌ na mummɨ kapup oirɨ Galilea jam bɨɨm. ¿Cham aa guꞌ tɨꞌñcho pim? ");
INSERT INTO stpNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Jup jam tɨtda bo na saak guiꞌ na bhaankam ya oirɨ gu Dios dhi oiꞌñgaꞌn, jum aayaꞌ gu tanoolh nam paiꞌ dhuuk daagɨi muꞌaaꞌ maaꞌn kuruus taꞌm gu jaꞌtkam jix uꞌuaꞌtulhdhix kam, saak baꞌ gio baik tanoolh kɨꞌn yaꞌ na jax ba oirɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Baꞌ guiꞌ bhaiꞌ pup tɨꞌñcho mɨt na bak pɨn puꞌñi ja tɨtda janoꞌ gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Baꞌ miꞌ dhɨr bubuakɨk pu jii mɨt bhammɨ nam paiꞌ daraa gu mambhɨɨx daman maaꞌn gu noonbiꞌñ gu Jesuus, gio gu jaiꞌ nam jaꞌp pɨx kaichuꞌ, bhammɨ ba ja aaꞌñdhim am na mɨt jax tɨ tɨɨ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Baꞌ guiꞌ gu uꞌuub maadɨt jir diꞌ gu Mariiya Magdalena, jumai baꞌr Juana, gio baꞌ gu jumai Mariiya nar dɨꞌɨɨꞌn gu Jakoobo, gio jɨꞌkchi pup gu uꞌuub jam maap jiim. ");
INSERT INTO stpNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Guꞌ ji nam guꞌ gu noonbiꞌñ gu Jesuus cham ja jɨɨgiꞌñ nam tɨi ba ja aagiꞌñ na mɨt jax tɨ tɨɨ, jaꞌp jum aaꞌ am nam dɨɨlh jax ñam pɨx ba tɨ nɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Guꞌ ji nat guꞌ gu Peegro muiꞌ ma daiꞌbus nat tɨ tɨɨgim mummɨ na mɨt paiꞌ tɨɨ gu tukgaꞌn gu Jesuus noꞌ sap moor sɨlhkam nam jax kaiꞌch gu uꞌuub piam ku guꞌ cham. Puiꞌ dho ji chu buus nat mummɨ ba baa, cham paiꞌ tu jaiꞌch gu tukgaꞌn gu Jesuus, dai jajannulh pɨx mi bɨɨt na kɨꞌn bhiibgich. Baꞌ giop ba jii jix buam jum aaꞌntugɨt bhammɨ nam paiꞌm jɨɨpiꞌñ, tɨi xim gaꞌngim nat paiꞌ baꞌ jaꞌk jax jum duu gu tukgaꞌn gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Baꞌ pu guiꞌ gu tanoolh chaꞌm mu jaꞌk jup ka jiim am Emauus gook guiꞌ nam kaichuꞌ gu Jesuus, tɨi pup chix dhaam ji dhuñiidhak jum aꞌjɨ bhaiꞌ dhɨr Jerusaleen. ");
INSERT INTO stpNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Gammɨjɨ jii mɨt tu aꞌgim am na tuꞌ baꞌ ku mɨt baꞌ mua gu jaꞌtkam gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Baꞌ miꞌ puiꞌ nam xi ñiokbuidhat ka tu aꞌgim, gatuuk dɨr muiꞌ ji ai gu Jesuus, saalh puiꞌ gammɨjɨ koꞌkmar ba jiim am. ");
INSERT INTO stpNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Baꞌ sia ku mɨt tɨi ba tɨɨ na gamaiꞌ ba jim ja bɨɨm, pu cham maatɨt nɨiꞌñ am noꞌp jir diꞌ, panaas ku tuꞌ ja soobhiꞌñ nam baꞌ cham maatɨt tɨgiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Baꞌp ja tɨtda gu Jesuus: ―¿Tuꞌ pim baꞌ aꞌgidhat pɨx nammɨm kɇɇjim jiñ jaaduñ? Baꞌ guiꞌ gan ji guguu mɨt pux buam jim aaꞌntugɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Miꞌ dhɨr baꞌp kaiꞌch guiꞌ na Kleopas tɨɨꞌ: ―Dai aap dho bak chakui maat jiñ jaduuñ nat tuꞌ jax jum duu bhaiꞌ Jerusaleen sia kup bhaiꞌp xi paxiaraimɨk. ");
INSERT INTO stpNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Baꞌp tɨtda gu Jesuus: ―¿Tuꞌ gi jax jum duu? Baꞌp tɨtda am: ―Dho gu Jesuus Nasareet kam kat na bhaankam gu Dios tu ja aꞌgidhat gu jaꞌtkam. Bɨxchuꞌx bhaaigɨt na pu tu duñiaꞌ na ni jaroiꞌ ku cham jɨꞌxkat pu tu duñiaꞌ sia chi pɨk jax chuꞌm gɇꞌkam kaꞌ gɨt, na guꞌ guiꞌ bhaan tɨ nɨidhidhat guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Guꞌ ji na mɨt guꞌ cham bhaiꞌ dhuu gu ja gɇꞌgɇrkam tuk guiꞌ nam ja aꞌmkam tu daandaꞌ dai gu Israel kam jaꞌtkam, gio guiꞌ nam aach jir jich gɇꞌgɇrkam tuk, daagɨk tu chia mɨt nam muꞌaaꞌ maaꞌn kuruus taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aach jup jich aagɨt ji na guiꞌ baꞌ puiꞌ saak jir diꞌ ji na yaꞌr ja gɇꞌkam tuk kaꞌ bɨɨx gu Israel kam jaꞌtkam, na baꞌch palhbuidhaꞌ nam cham kach chulhiiñchuꞌndaꞌ guiꞌ nam cham jir yaꞌ kam. Ku guꞌ baik tanoolh bap duu ji na mɨt dɨr jup dooda. ");
INSERT INTO stpNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jaiꞌ dhɨt gu uꞌuub nach bhammɨ maap jich jɨɨpiꞌñ maakam jup jich ɨꞌnkia mɨt. Bɨɨpɨꞌ kapbhuimuk na kapup jix ɨɨkaꞌ mɨt mɨjɨ xi boop na mɨt tɨ tɨɨgim mummɨ nat paiꞌm tɨɨ gu tukgaꞌn gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jup jich chɨtda am na mɨt mu dɨr jaꞌk suulhgɨk na sap cham tu jaiꞌch gu tukgaꞌn mu nat paiꞌm tɨɨ. Sap baꞌ miꞌ pɨx ba guguuk am gook gu noonbiꞌñ gu Dios, jaꞌp sap kaiꞌch am na cham tuꞌ muukix gu Jesuus, dua ji sap. ");
INSERT INTO stpNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Gio jaiꞌ dhɨt gu chichioꞌñ nach puiꞌ maap jup tuꞌiiꞌ mɨjɨp xi chɨ tɨɨgim jamɨt noꞌ sap baabuiꞌr sɨlhkam nam jax kaiꞌch gu uꞌuub. Puiꞌ ji sap na tu tuꞌiiꞌ na mɨt mummɨ ji bubua nam jax kaiꞌch gu uꞌuub. Cham paiꞌ sap tu jaiꞌch gu tukgaꞌn gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Baꞌ gu Jesuus jup ja tɨtda: ―Jam aꞌm jum aaꞌ dho na pim jix bhaiꞌ xim gaꞌngadaꞌ na jax kaiꞌñkam jup jum kaiꞌch mi uꞌuan taꞌm na mɨt tu uaꞌnak gu bɨjɨk dɨr kam. ");
INSERT INTO stpNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Na guꞌ pu puiꞌ jaꞌk tu uaꞌñix bɨjɨk dɨr na sap puꞌñi bɨɨpɨꞌm tulhiiñaꞌ guiꞌ na Dios bha jootsaꞌ na baꞌ miꞌ dhɨr giilhim jix ioꞌm gɇꞌkam kɨꞌn ba daibuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Baꞌ xi ja aagiꞌñ gu Jesuus puiꞌ moꞌram dɨr xi boosgaidhat na paiꞌ jaꞌp puiꞌm kaiꞌch nam dhiꞌ aagɨt jup kaiꞌch na mɨt tu uaꞌnak gu bɨjɨk dɨr kam. Mummɨ dɨr bhaiꞌ ji kɨi nat paiꞌ gu Moisees tu uaꞌnak, miꞌ dhɨr baꞌ gu jaiꞌ na mɨt puiꞌp tu uaꞌnak nam sia dhiꞌ pɨx aagɨt jup kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Baꞌ na mɨt mummɨ ba ai Emauus, gu Jesuus am bɨɨpɨꞌ muiꞌ xi jii, panaas ku guiꞌ maaꞌn na jimdaꞌ kam xim duu. ");
INSERT INTO stpNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Guꞌ ji na mɨt guꞌ guiꞌ gio jaꞌk jup bua, nat guꞌp ba jur, jup tɨtda am: ―Jich jaduuñ, yaꞌch ka xi chɨbiapui maap jix gɨꞌgɨram. Jix chukgam ji matgɨm gammɨjɨ boi chaꞌm. Kabuimuk jap baꞌ giop ba jimiaꞌ. Baꞌ gu Jesuus cham jax ji chɨꞌɨɨk ba ja oi ɨp mu nam paiꞌ tɨbiapuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Baꞌ nam miꞌ ba daraa na paiꞌ tum kuaꞌ na mɨt ba ji chu juu gu jurnɨk kam, gu Jesuus maaꞌn xi dhaagɨt gu paan xi chu taxchaabgidhak buiñor gu Dios ɨrban jaiñak muiꞌ xi ja maa. ");
INSERT INTO stpNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Baꞌ bhaiꞌ pup maat jamɨt na dhiꞌr diꞌ gu Jesuus, panaas kut jaroiꞌ jaꞌk bhɨi guiꞌ na kɨꞌn ja soobhiꞌñkat nam baꞌ cham maatɨt tɨgiaꞌ. Guꞌ ji nat guꞌ jotmodaꞌ cham paiꞌ matgir gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Baꞌ bhaiꞌ ji chu aꞌga mɨt dai gook, jup kaiꞌch am: ―Guꞌ bak ji pur diꞌ ji gu Jesuus. Puiꞌ ku baꞌ giilhim joidham jix bhaiꞌ tu tatdatuꞌ bɨɨpɨꞌ na mu dɨr bhach aaꞌñdhim na mɨt jax kaiꞌñkam puiꞌ tu uaꞌnak gu bɨjɨk dɨr kam. Jix bhaiꞌx maatɨt kɇɇjim ich na jax jich aaꞌñdhim. ");
INSERT INTO stpNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Baꞌ na mɨt jax guguu miꞌ bhɨi mɨt ɨp gio nam paiꞌ dhɨr jiim, pu cham ka tɨbia mɨt. Bhammɨ mɨt ba ji bubua Jerusaleen nam paiꞌ daraa gu mambhɨɨx daman maaꞌn gu noonbiꞌñ gu Jesuus, gio gu jaiꞌ nam jaꞌp pɨx kaichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Baꞌ guiꞌ chakui tu aaꞌ am nam jax jix chu mattuꞌ, dai guiꞌ nam bhaiꞌ pu daraa jup ja tɨtda am: ―Jir sɨlhkam dho bak nat giop dua guch gɇꞌkam tuk. Mu sap paiꞌm maax buiñor dhi Simoon. ");
INSERT INTO stpNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Baꞌ miꞌ dhɨr dɨɨlh jup ba tu aaꞌ am nam jax jup jix chu maat, xi ja aagiꞌñ am na jax ja tɨtdaim gamaiꞌ bɨɨx boi nam jiim, gio baꞌ na mɨt mummɨx maatɨt ka tɨɨ Emauus na dhiꞌr diꞌ gu Jesuus nat xi ja jaix gu paan. ");
INSERT INTO stpNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Baꞌ nam miꞌ pu chuꞌm ka tu aꞌga, miꞌ pɨx bam maax gu Jesuus ja saagiꞌñ. Baꞌp ja tɨtda: ―Aañ bha jaꞌk ɨp gor jiñ jaaduñ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Guiꞌ pu cham ñiok am, dai nam giilhim bax chotdon. Jaꞌp jum aaꞌ am na dai iiꞌmdagaꞌn mi jaꞌp oirɨt ja ɨꞌnkiat. ");
INSERT INTO stpNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Baꞌp ja tɨtda gu Jesuus: ―¿Jax ku pim baꞌ giilhim bax chotdon? ¿Cham aa pim jɨꞌx tɨ jɨɨgiꞌñ na ñich maaxik giop dua? ");
INSERT INTO stpNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jax dhui nañ aañ pɨx jir diꞌ maaꞌn na jax. Kani gor jix bhaiꞌ xiñ chɨɨꞌ. Yaꞌ puiꞌx maatɨꞌñ ñoonob am gioñ chooton am nañ paiꞌ sissapich. Xiñ dhaꞌngɨdaꞌ pim ɨp, kani nam daꞌngɨ dhiñ chuukuꞌ. Matgɨm pu cham ji nañ jiñ dhaꞌngɨdaꞌ noꞌñ jir iiꞌmdaꞌ pɨx kaꞌ gɨt, pu cham tatdaꞌkaꞌñ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Xi ja nɨnɨiꞌñchuꞌn baꞌ noonbiram gio tootnoram na paiꞌ sissapich na puiꞌ xi ja tɨtdat. ");
INSERT INTO stpNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Guꞌ ji nam guꞌ chakui bhaiꞌ tɨ jɨɨgiꞌñ noꞌ maaxik jir sɨlhkam na jax ja tɨtda piam ku guꞌ cham. Ku guꞌ jɨꞌx bhaiꞌx bhaiꞌ jim ɨꞌlhiꞌñ am ji. Baꞌ xi ja tɨkka gu koiꞌ noꞌm cham biaꞌ na sap baꞌ ja nɨiꞌñchudat tu jugiaꞌ nam baꞌx ioꞌm ba jɨɨgiꞌñdhaꞌ nar diꞌ pɨx, jup ja tɨtda: ―¿Chaꞌpim iam biaꞌ tuꞌ koiꞌ nañ xi chu jugiaꞌ? Am jix bhioꞌ iñ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Baꞌ maaꞌn xi maa mɨt gu batoop gaiꞌxim, panaalhiꞌx mɨbtaꞌ mɨt jup xi maa. ");
INSERT INTO stpNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Baꞌ ma tu juu gu Jesuus ja nɨiꞌñchudat bɨɨx nam jɨꞌk miꞌp tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Baꞌp ja tɨtda ɨp gio nat xi koiꞌchok: ―Puꞌjani na tuñ dhoodaꞌ kuñ baꞌp jam tɨtdadaꞌ nañ mu jaꞌp jam bɨɨm oirɨdaꞌ, nam aayaꞌ gu tanoolh na paiꞌ dhuuk puiꞌ ji chu buusniaꞌ na jax tu aagix nat tu uaꞌnak gu Moisees na aañ jiñ aagɨt jup kaiꞌch, gio gu jaiꞌ na mɨt puiꞌ bhaankamuꞌn gu Dios jup tu uaꞌnak nam sia aañ jiñ aagɨt jup kaiꞌch, puiꞌ na miꞌ Salmos taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Baꞌ dɨɨlh gu Jesuus puiꞌ xi chu duu nam jix maatɨt kaayaꞌ mi jaꞌp na paiꞌ jax ja aagiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Baꞌp ja tɨtda ɨp gio: ―Bɨɨx nam jɨꞌk aañ jiñ aagɨt jup kaiꞌch na mɨt tu uaꞌnak gu bɨjɨk dɨr kam, pu puiꞌ jaꞌk tu dai mɨt na aañ nañ bhaankam ya oirɨdaꞌ gu Dios dhi oiꞌñgaꞌn bhaan, jum aaꞌ nañ puꞌñi muukɨi giop dodhiaꞌ baik tanoolh kɨꞌn na ñich jax bañ dhuu baꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Baꞌ aapiꞌm jiñ aꞌmkam naiꞌ xi chu ja aꞌgidhaꞌ bɨɨx gu jaꞌtkam nam jɨꞌk jix jaiꞌch. Yaꞌ dɨr japim muiꞌ ji kɨɨsaꞌ Jerusaleen. Jaꞌp japim ja tɨtdaidhaꞌ nam miꞌ puiꞌ ba jimiaꞌ na jax jix aaꞌ gu Dios na baꞌ ja uañdhaꞌ gu ja uaꞌtulhdharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Puiꞌ pim xi ja tɨtdaidhaꞌ na pim jɨꞌk jax jix chu maat na pimɨt jiñ chɨɨ na ñich jiñ dhuu. ");
INSERT INTO stpNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ku baꞌ guꞌ yaꞌ pɨx ka xi darkaꞌ pim ji xib Jerusaleen, nañ guꞌ bhaiꞌ ka jam joochxidhaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ guiꞌ nat jiñ Gɨꞌkoraꞌ jam iimchuda na jam tajaañdhaꞌ. Dhiꞌ baꞌ kɨꞌn bɨxchuꞌ bax bhaaiꞌn kaꞌ na pim pu tu duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Baꞌ puiꞌ xi ja tɨɨdak ba ja baidhak nammɨ gama jaꞌk na paiꞌ Betaania tɨ tɨɨꞌ. Baꞌ miꞌ bhaiꞌ ji tu ja daañxi buiñor jaꞌk gu Dios xi baapmiꞌñdhak gu noonbiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Baꞌ puiꞌ ja aꞌmkam ji chu dañiidhat gamaiꞌ ji bam jix dhaam jaꞌk, bhɨjɨmmɨ ji bhiꞌñ, guiꞌ baꞌ miꞌ pup bii mɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Baꞌ guiꞌp xi dhañiimɨk am na mɨt baꞌp ba jii ɨp gio bhammɨ jaꞌk Jerusaleen joidham jix bhaiꞌm taattugɨt. ");
INSERT INTO stpNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Baꞌ gammɨjɨ nabap tanoolh mi aajidhaꞌ am gɇꞌ chiop nam daandaꞌ gu Dios.");
INSERT INTO stpNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bɨjɨk dɨr jumai pux jaiꞌch na jaꞌxbuiꞌp jir gɇꞌkam na gu Dios, nam gook dɨt maap pum kɇkɇɇ. Baꞌ guiꞌ miꞌ dhɨr bha jaꞌk jup jich mattuꞌn na jax jir tuꞌm kam gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Guiꞌ mɨt baꞌ gook dɨt bap duu gu Dios dhi oiꞌñgaꞌn, ");
INSERT INTO stpNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","gam bɨɨx na jɨꞌk tuꞌ yaꞌx chu jaiꞌch. Nix chuꞌ kux jaiꞌch yaꞌ dhi oiꞌñgaꞌn bhaan nat cham guiꞌp duu, na mɨt guꞌ pu gook dɨt maaꞌn ñiꞌook xip duuk jup tu duu bɨɨx. ");
INSERT INTO stpNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Gu jumai jir diꞌ pɨx guiꞌ na ja maak gu iiꞌmdaꞌ nam kɨꞌn dudua bɨɨx gu jaꞌtkam. Jir diꞌ pɨx ɨp nam kɨꞌn jix chu maax kɨr ji biꞌyaꞌ, na guꞌ guiꞌ na iiꞌmdaꞌ tu maak joidham gɇꞌ tanoor. ");
INSERT INTO stpNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Sia tu tonniꞌñ mu jaꞌp ja bui gu jaꞌtkam nam jix chu tukgam kɨr jup tuꞌiiꞌ, baꞌ cham jɨꞌxdhaꞌ tu saaꞌ gux chukgam dhiꞌ na joidham gɇꞌ tanoor. ");
INSERT INTO stpNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Baꞌ pu kaiꞌñkam pɨx bha joot gu Dios maaꞌn gu maaꞌnkam Juan tɨɨgim, ");
INSERT INTO stpNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","na sap baꞌ ya jaꞌp ba ja mattudaꞌ gu jaꞌtkam na jax jir tuꞌm kam guiꞌ na joidham gɇꞌ tanoor, nam sap baꞌ cham xijaichdhaꞌ noꞌt yaꞌ ba ai, dai nam ba tɨ jɨɨꞌñdhaꞌ buiñor bɨɨx ja jujur kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ku guꞌ gu Juan cham tuꞌr jupaabkamuꞌn ji, guꞌ jaꞌpji nat jax dhuuk pɨx bhaan matgɨr ji nat bam ai na paiꞌ dhuuk naiꞌ ji chu aꞌagaꞌ guiꞌ na joidham gɇꞌ tanoor. ");
INSERT INTO stpNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nat baꞌ bɨɨpɨꞌ xi chu mattuda gu Juan nat baꞌ moo miꞌ dhɨr dɨɨlh naiꞌp ji chu aꞌgaꞌ guiꞌ na joidham gɇꞌ tanoor, nam baꞌx chu maax kɨr ji biꞌyaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Guꞌ ji na mɨt guꞌ cham kɨɨgalh gu jaꞌtkam nat yaꞌ tɨi ba ai maaxik maaꞌnkam jup jum duuk, na mɨt guꞌ cham xim gaa ja jujur am bhaan nam iam ba machiaꞌ gɨt na dhiꞌ pɨx jir diꞌ guiꞌ nat jup duu dhi oiꞌñgaꞌn gio na jɨꞌk tuꞌx chu jaiꞌch bhaan. ");
INSERT INTO stpNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yaꞌ tɨi ai ja bui gu Israel kam jaꞌtkam nam paiꞌ saak tɨ jɨɨgiꞌñdhaꞌ buiñor guch Gɨꞌkoraꞌ. Pu cham kɨɨgalh jamɨt, tuꞌ pɨx ɨlh jamɨt ja jaaxmakar. ");
INSERT INTO stpNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Jɨꞌmaꞌn siamri tɨ jɨɨꞌñ jamɨt buiñor nam jɨꞌk joidham kɇɇ na jax tu aꞌga. Daipuiꞌ baꞌx joiꞌndak xi ja aagiꞌñ nam cham tuꞌ maiꞌ ka suulhgix, nam guꞌ sap bar maamraꞌn gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ku guꞌ na puiꞌ jɨꞌ ja tɨtda nam bar maamraꞌn, cham tuꞌ jax kaiꞌñkam jup ja tɨtda ji na jax gu jaroiꞌ noꞌ mɨt ba xim ja joojoi gook dɨt maaꞌn gu tɨyaa nam maap oiꞌñchai mɨkkat ba ja tɨgiaꞌ gu aꞌaalh nam ja maamar jum tɨɨtɨꞌndaꞌ, guꞌ jaꞌpji noꞌt jaroiꞌ ba tɨ jɨɨꞌñ buiñor guiꞌ na joidham gɇꞌ tanoor na baꞌr maraaꞌn kaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na guꞌ maaxik yaꞌ xi oilhimɨk guiꞌ na joidham gɇꞌ tanoor maaꞌnkam jup jum duuk. Jir diꞌ pɨx gu jumai na jaꞌxbuiꞌp jir gɇꞌkam na guch Gɨꞌkoraꞌ. Aach jaiꞌ dhɨt jix bhaiꞌx maat, nach guꞌ bɨɨmaꞌn oipimɨk na jɨꞌx juugɨt yaꞌ oilhimɨk. Jix bhaiꞌ tɨɨgɨk jachich na cham tuꞌr jaꞌppɨx maaꞌnkam, nat guꞌ cham jɨꞌxkat iatdaꞌ tu aꞌgimɨk, dai na joidham jix chu joiꞌgɨꞌndaꞌ pɨx. ");
INSERT INTO stpNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pu dhiꞌ pɨx nɨidhat jup kaiꞌch gu Juan janoꞌ nap ja tɨtda gu jaꞌtkam: ―Guꞌjani nañ aagɨt jup kaiꞌch nat muni ba ai, nañ jup jam tɨtda bo na jumai bha jim gatuuk dɨr na giilhim jir gɇꞌkam, na pu ni jɨꞌx kuñ jir jupaabkamuꞌn. Na guꞌ guiꞌ bɨjɨk dɨr pux jaiꞌch, sia kuñ guꞌ aañ tɨir bɨɨpɨꞌ kam paꞌ gu yaꞌ maaxik. Jaꞌpni bo na ja tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jir sɨlhkam dho na giilhim jir gɇꞌkam, puiꞌ ku baꞌ giilhim jir jix bhaiꞌkam gio nax chu joiꞌgɨꞌn. Jaiñ na guꞌ aach nach jɨꞌk ba tɨ jɨɨgiꞌñ buiñor, gammɨjɨ pɨx jix bhaiꞌ ba tu tatdaꞌ na guꞌch aꞌm tɨ nɨidhim. ");
INSERT INTO stpNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Noꞌ chakui yaꞌ aayaꞌ gɨt, chakui machiaꞌ ich gɨt na jax jaꞌk jix bhaaiꞌ nach dhuuji jir jix bhabhaiꞌkam kaꞌ gam nach jix chu joiꞌgɨꞌndaꞌ. Nach guꞌ cham maatɨt kɇɇkɇt na jax kaiꞌñkam jup jum kaiꞌchdhaꞌ mi uꞌuan taꞌm nat paiꞌ tu uaꞌnak gu Moisees, daipuꞌ na jax jaꞌk jix aaꞌ guch Gɨꞌkoraꞌ nach chuiꞌñgɨdaꞌ nach baꞌ siamri pux maatɨt paꞌ kɇɇkɇꞌ. Janoꞌ ji na paiꞌ dhuuk maaxik yaꞌ xi oilhimɨk guch Xoiꞌkam na chich baꞌ bhaiꞌ ji maat na bach aagiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Noꞌ chakui jich aagiꞌñdhaꞌ gɨt, pu chakui machiaꞌ ich gɨt. Guꞌ ji nat guꞌ siamri xich joiꞌndak bhaiꞌ xich guguuxdharak, sia ku jaꞌxbuiꞌp jir gɇꞌkam na guch Gɨꞌkoraꞌ, na guꞌ dɨɨlh gu Dios cham jɨꞌxkat yaꞌ paiꞌm maaxdhaꞌ maaxik nach gɨt iam jup ba machiaꞌ na jax jir tuꞌm kam. ");
INSERT INTO stpNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Baꞌ gu Judea kam jaꞌtkam nam bhammɨ oiꞌñkaꞌ Jerusaleen, mu ja joot jamɨt jɨꞌkchi guiꞌ nam mu jaꞌp jir gɇꞌgɇrkam kaꞌ chichiop nam paiꞌ tu daandaꞌ, gio jaiꞌ guiꞌ nam jir bopxiꞌñ gu Lebii nam jir tutpilh kaꞌ, nam sap tɨkkapuꞌ gu Juan jaꞌtkam bopkondam nar tuꞌp tuꞌm daꞌ. Baꞌ guiꞌ mu ɇɇk jup ba tɨkka am, jup tɨtda am: ―Aach jaꞌpnich chɨɨdak bhach joot jamɨt gu gɇꞌgɇrkam nap sap jich aagiꞌñdhaꞌ nap jir tuꞌp tuꞌm daꞌ na pich baꞌ yaꞌ pɨx ba ji kaiꞌñcha nap ja bopkon gu jaꞌtkam cham jum ɨlhdham. ");
INSERT INTO stpNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Baꞌ guiꞌ cham jax ji chɨꞌɨɨk jup xi ja aagiꞌñ, jup ja tɨtda: ―Dho guꞌ aañ pur cham tuꞌ ji moo gux matgam. Cham tuꞌ na pim jax jum aaꞌndaꞌ nañ aañ jir diꞌ guch Xoiꞌkam guiꞌ na saak bha jootsaꞌ guch Gɨꞌkoraꞌ jix dhaam dɨr. ");
INSERT INTO stpNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Baꞌ giop xi chɨkka am jix bhaiꞌ pɨx na sap baꞌ ja aagiꞌñdhaꞌ, jup tɨtda am: ―¿Jaꞌp moo gux gɨꞌm jir tuꞌp tuꞌm daꞌ ap jiñ jaduuñ? ¿Kaꞌ aap aar diꞌ gu Eliiyas guiꞌ na saak bɨjɨk ya jaꞌp bhaankamuꞌn tu aꞌgimɨk guch Gɨꞌkoraꞌ nat saak bɨɨx tukgaꞌn bɨnkam baidhak jix dhaam jaꞌk? Baꞌ gu Juan jup ja tɨtda: ―Cham tuꞌr diꞌ iñ, jir jumai iñ ji aañ. Baꞌ gio bhaiꞌp ji chɨkka mɨt, jup tɨtda am: ―¿Kaꞌ aap aar diꞌ guiꞌ na saak jaiꞌchdhɨlhiaꞌ gatuuk na bhaankamuꞌn jup tu aꞌgaꞌ guch Gɨꞌkoraꞌ jaꞌp na jax gu bɨjɨk dɨr kam? Baꞌp ja tɨtda: ―Chaam. Jir jumai iñ ji matgam. ");
INSERT INTO stpNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Gio mɨt moop ka xi chɨkka, jup tɨtda am: ―Gi noꞌp moop xich aagiꞌñ jiñ jaduuñ nap jir tuꞌp tuꞌm daꞌ, nach baꞌ ja aagiꞌñdhaꞌ guiꞌ na mɨt bhach joot nap cham tuꞌ jaꞌp pɨx yaꞌ puiꞌ tu bua. ");
INSERT INTO stpNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Baꞌ guiꞌp ja tɨtda: ―Aañiꞌ dhor diꞌ guiꞌ na saak mu jaꞌp gampɨx jix chu gak kɨr ba tu ja aꞌgiꞌñdhaꞌ gu jaꞌtkam nat jax tu uaꞌnak gu Isaiiyas guiꞌ na bɨjɨk ya jaꞌp bhaankamuꞌn tu aꞌgimɨk guch Gɨꞌkoraꞌ, nap ja tɨtdaidhaꞌ bo saak: “Gor jix kɨɨꞌ bim duuñ na pim miꞌ puiꞌ ba jimiaꞌ na jax jix aaꞌ guch Gɨꞌkoraꞌ. Bam aajim na paiꞌ dhuuk bha jim. Jaꞌp ji buusniaꞌ na pim jix bhaiꞌ ba tɨ kɨɨꞌmpigaꞌ miꞌ na paiꞌ bhɨɨyaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Baꞌ guiꞌ na mɨt mu ja joot gu gɇꞌgɇrkam nam pariseos jum tɨɨtɨꞌndaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","jup tɨtda am ɨp gio gu Juan: ―Jaꞌpnich baꞌ tɨip kaiꞌchɨt jiñ jaduuñ nap jich aagiꞌñdhaꞌ na jax jir jum duukam nap baꞌ ja bopkon suudaiꞌ kɨꞌn dhi jaꞌtkam, nap puiꞌ saak cham jir diꞌ guch Xoiꞌkam, ni gu Eliiyas, nix chuꞌ gu jumai na saak jaiꞌchdhɨlhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Baꞌp ja tɨtda gu Juan: ―Dho guꞌ dhiꞌ cham pɨk tuꞌm aꞌga ji nañ yaꞌ tu bopkon dhi suudaiꞌ kɨꞌn, matgam jumai yaꞌ oirɨ ji na pim aapiꞌm chakui maat nar gɇꞌkam. Guꞌ dhiꞌ nañ yaꞌ puiꞌ tu bua na pim bhaan pɨx machiaꞌ ji. ");
INSERT INTO stpNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Pu kani gɨt na guꞌ bhaiꞌ ka jim gatuuk dɨr, sia ku guꞌ gu xib cham paiꞌm mamxiꞌñ. Ku guꞌ aañ cham tuꞌr jupaabkamuꞌn ji nañ iam tuꞌ suuskaꞌn jup ba kookoxdhaꞌ gɨt, sia kuñ guꞌ tɨir bɨɨpɨꞌ kam paꞌ gu yaꞌ maaxik. ");
INSERT INTO stpNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jaꞌpni tum duu mummu miaꞌn Betaania jaꞌpni dhɨr jaꞌk xiaꞌlhbui na paiꞌ bhɨix gu Jordaan Ak, na paiꞌ oirɨt ka ja bopkon gu jaꞌtkam gu Juan. ");
INSERT INTO stpNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Baꞌ buimgidhak miꞌ ba ai gu Jesuus na paiꞌ ja bopkon suudaiꞌ kɨꞌn gu jaꞌtkam gu Juan. Baꞌ nat ba tɨɨ gu Juan na muiꞌ ba jim gu Jesuus, jup ja tɨtda gu jaꞌtkam: ―Dhiꞌñir diꞌ na muni dhɨr bhaiꞌ ba jim guiꞌ nat Dios bha joot nach aꞌmkam mukiaꞌ bɨɨx na jɨꞌk jaꞌtkam yaꞌ dhi oiꞌñgaꞌn, na baꞌ puꞌñi dhuuji tu namkix kaꞌ guch uaꞌtulhdharaꞌ. Dhiꞌ puiꞌ ji buusan na jax maaꞌn gux kɨɨꞌ kasnir, na guꞌm makgartaꞌ gatuuk. ");
INSERT INTO stpNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Dhiꞌ pɨx aagɨt jup kaiꞌch iñ takaab nañ jup jam tɨtda bo: “Jumai bha jim ji matgam gatuuk dɨr na giilhim jix ioꞌm jir gɇꞌkam, cham tuꞌ puiꞌ na aañ, na pu ni jɨꞌx kuñ jir jupaabkamuꞌn, na guꞌ guiꞌ bɨjɨk dɨr pux jaiꞌch, sia kuñ guꞌ aañ tɨir bɨɨpɨꞌ kam paꞌ gu yaꞌ maaxik.” ");
INSERT INTO stpNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aañ puiꞌ chakuip maatɨt jia na jax baꞌ moo tuꞌm jir diꞌ, puiꞌ ku ñich baꞌ moo xiñ jotmaꞌn na ñich bha ja bopkonam gu Israel kam jaꞌtkam, na baꞌ miꞌ dhɨr puꞌñi ba matgilhiaꞌ na jax chuꞌm jir diꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jix bhaiꞌ moo xi ja aagiꞌñ, jup ja tɨtda: ―Jix maatɨt jañ moop jam tɨtda, na ñich guꞌ tɨɨ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ nat bhammɨni dhɨr bhaiꞌ ji chɨm jix dhaam jaꞌp tuꞌm na giodaꞌ, bhaiꞌ baꞌ naiꞌ jim tajaa bhaan. ");
INSERT INTO stpNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dhiꞌ ñich baꞌ bhaan ba maat na dhiꞌr diꞌ, na guꞌp jiñ chɨtda guiꞌ nat bhañ joot nañ yaꞌ ja bopkonaꞌ gu jaꞌtkam: “Gu jaroiꞌ na bhaan tɨmnɨi gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ bhaiꞌ jim tajaanaꞌ, dhiꞌr diꞌ kaꞌ guiꞌ na ja tajaañdhaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ gu jaꞌtkam. Baꞌ jaꞌp ji buusniaꞌ na ja bopkonaꞌ suudaiꞌ kɨꞌn.” ");
INSERT INTO stpNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Xib jañ dho gi baꞌ moo bax maat ji na dhiꞌr diꞌ, baꞌ aañ yaꞌ pu jam tɨtda, na dhiꞌ Dios jir Maraaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Baꞌ buimgidhak na gio mup ba oirɨ gu Juan ja bɨɨm gook guiꞌ nam kaichuꞌ, ");
INSERT INTO stpNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ba tɨɨ gu Jesuus na gama jaꞌk jaꞌp ba jimchuꞌ. Baꞌp ja tɨtda guiꞌ nam kaichuꞌ: ―Dhiꞌr diꞌ na muni jaꞌp ba jim guiꞌ nañ jam aagiꞌñ takaab na jaꞌp ji buusan na maaꞌn gux kɨɨꞌ kasnir nat Dios bha joot nam matgartaꞌ gatuuk jich aꞌmkam. ");
INSERT INTO stpNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Baꞌ gu gook jaꞌtkam nam kaichuꞌ gu Juan, pu mɨjɨ xi oi mɨt gatuuk dɨr gu Jesuus na mɨt jax kai na puꞌñi jɨꞌ kaiꞌch gu Juan. ");
INSERT INTO stpNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Baꞌ nammɨ gama jaꞌk na ba jimchuꞌ gu Jesuus, ba ja tɨɨ nam gatuuk dɨr mu oiꞌñ gook gu jaꞌtkam, baꞌp ja tɨtda: ―¿Tuꞌ pim gaagim jiñ jaaduñ? Baꞌ guiꞌp kaiꞌch am: ―Chaam tuꞌ. Yaꞌ chich pɨx bham tɨkkam nap paiꞌ kioñ jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Baꞌ gu Jesuus jup ja tɨtda: ―Dho mummuni. Pu kani gor maik na pim baꞌ tɨ tɨgiaꞌ. Baꞌ guiꞌp ma oi mɨt mu kiaꞌmiꞌñ gu Jesuus. Miꞌm baꞌ xi dharaat alhio, na guꞌ pu puiꞌ ba jurnim, dumaalh pɨx ba duu na mɨt mu ai. ");
INSERT INTO stpNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Guiꞌ jɨꞌ gook jaꞌtkam nam kaichgɨt gu Juan na mɨt oi gu Jesuus, Anrees tɨɨꞌ maaꞌn nar jaꞌnniꞌñ gu Simoon Peegro. ");
INSERT INTO stpNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Baꞌ xim jotmaꞌn gu Anrees nat gaagam gu jaꞌnniꞌñ Simoon. Baꞌ nammɨ gama jaꞌk tɨɨgɨk ba aagiꞌñ, jup tɨtda: ―Ampɨx maat jachich dho gi ji baꞌ guch Xoiꞌkam guiꞌ na saak Dios bha jootsaꞌ. Kani maik jach tɨɨꞌmpuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Baꞌ muiꞌ ba baiꞌñchuꞌ gu Anrees gu jaꞌnniꞌñ Simoon mu na paiꞌ kio gu Jesuus na baꞌ tɨgiaꞌ. Baꞌ nam jax kiaꞌpɨx mu ji aajim, jup tɨtda gu Jesuus gu Simoon: ―¡Aa guꞌ aapiꞌ jip tuiꞌdhiꞌ jia Simoon nap jir maraaꞌn gu Juan! Xib dɨr jaꞌp moo Peegro jup ba tɨɨꞌkaꞌ. ―Peegro jaꞌp kaiꞌñkam jup jum kaiꞌch: Jodai. ");
INSERT INTO stpNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Baꞌ buimgidhak ma jii gu Jesuus maaꞌn kap na paiꞌ Galilea bhaan bipioꞌ. Bhammɨ pɨx ji chɨɨ gu Piliip na oirɨ. Baꞌp tɨtda: ―Bañ kaichgɨdaꞌ ap jiñ jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Gu Piliip jir Betsaida kam nar paiꞌ kam gu Anrees gio gu Peegro. ");
INSERT INTO stpNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Gu Piliip jup ma gaagam gu Natanail, jummɨ gama jaꞌk nat ba tɨɨ jup tɨtda: ―Ampɨx maat jachich dho gi ji baꞌ xib guiꞌ na saak bha jimdaꞌ jix dhaam dɨr nat jax tu uaꞌnak gu Moisees gio gu jaiꞌ nam bɨjɨk ya jaꞌp bhaankamuꞌn tu aꞌgimɨk guch Gɨꞌkoraꞌ nam dhiꞌ aagɨt jup kaiꞌch. Gu Jesuus bak jir diꞌ, maraaꞌn gu Josee Nasareet kam. ");
INSERT INTO stpNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Baꞌ bhaiꞌ ji ñio gu Natanail, jup kaiꞌch: ―¿Siamri aa chi moo bhaiꞌ dhɨr jup ba ji buusniaꞌ ja bui gu Nasareet kam jaꞌtkam gu tuꞌ nar jix kɨɨꞌp jum duukam? Baꞌp tɨtda gu Piliip: ―Dho na baꞌ. Kani gɨt maik jach tɨɨꞌmpuꞌ nap baꞌñ jɨɨgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Baꞌ nam kiaꞌpɨx mummu ji aajim, jup ja tɨtda gu Jesuus guiꞌ na miꞌ ja bɨɨm jup tuꞌiiꞌ kaixdhat gu Natanail: ―Dhiꞌjani nat yaꞌni ba ai na tuꞌ sɨlhkam jir Israel kam, na jax chuꞌm jix kɨɨgalhiꞌñ guñ Gɨꞌkoraꞌ, na cham paiꞌ dhuuk iatdaꞌ tu aꞌga. ");
INSERT INTO stpNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Baꞌ gu Natanail jup kaiꞌch: ―¿Jax jap baꞌ duukat moop jix maat jiñ jaduuñ nañ jax jir tuꞌm kam, nach guꞌ chakuich mamaat? Baꞌ gu Jesuus jup tɨtda: ―Dho nañ guꞌ aañ pu bɨɨpɨꞌ dɨr jum nɨiꞌñ jia nap jax mu daa iigɨx bɨtaꞌ nat baꞌ dhi Piliip mu ɇɇk bhaiꞌp bam baidhak. ");
INSERT INTO stpNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Baꞌp kaiꞌch ɨp gio gu Natanail: ―Xib jañ dho gi bax maat ji nap aap jir diꞌ gu Maraaꞌn gu Dios jiñ jaduuñ. Tɨɨꞌ nap guꞌ jax bɨxchuꞌx chu matdaꞌ. Aap bak baꞌ yaꞌ bar gɇꞌkam kaꞌ ja bui gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Baꞌ gu Jesuus jup tɨtda: ―Ku guꞌ cham tuꞌr daipuꞌ ji gu xib nañ jax jum tɨtda. Bɨxchuꞌ ka tɨgiaꞌ ap ji matgam jix bhaiꞌm duukam noꞌp moo cham oodat xiñ kaichuꞌ. Tɨɨꞌ nap guꞌ bɨɨx jum jur kɨꞌn ba tɨ jɨɨgiꞌñ jiñ bui na ñich puiꞌ xim tɨɨꞌn nañ pu bɨɨpɨꞌ dɨr jum nɨiꞌñ nap mu daa iigɨx bɨtaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Baꞌ miꞌ dhɨr jup ja tɨtda gu Jesuus bɨɨx nam jɨꞌk miꞌp tuꞌiiꞌ: ―Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌ, na kam aajim na pim paiꞌ dhuuk ja tɨgiaꞌ gu noonbiꞌñ guñ Gɨꞌkoraꞌ nam bhɨjɨmmɨni dhɨr bhaiꞌ ji chɨɨtmiꞌndaꞌ, sɨlh jiimdaꞌ am paiꞌ nañ jup tuiꞌkaꞌ aañ nat bhañ joot, na guꞌ cham xiim ka kupioꞌkaꞌ dhix dhaam. ");
INSERT INTO stpNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Baꞌ miꞌ dhɨr baik jurniꞌñ kɨꞌn dhiꞌ puiꞌ, mam tɨɨmo maaꞌn gu maaꞌnkam bɨɨmaꞌn gu tɨyaa mu Kanaa, na paiꞌ Galilea bhaan bipioꞌ guiꞌ gu dɨbɨɨr. Baꞌ bɨɨx mup oirɨ gu dɨꞌɨɨꞌn gu Jesuus ");
INSERT INTO stpNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","gio dɨɨlh gu Jesuus ja bɨɨm guiꞌ nam kaichuꞌ, na mɨt guꞌ ja bai nam sap jaiꞌ muiꞌ xi jiimdaꞌ nam jaiꞌ tu jugiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Baꞌ jaꞌxpɨx nam ka tu kuaꞌ, mi jaꞌp jix buam bam aaꞌ am jaiꞌ dhɨt gu jaꞌtkam nat ba juum gu biiñ. Baꞌ gu dɨꞌɨɨꞌn gu Jesuus jup tɨtda palhɨɨp jaꞌp xi baabuk: ―Cham ka biaꞌ am gu biiñ dhich jaaduñ. ");
INSERT INTO stpNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Baꞌ gu Jesuus jup tɨtda gu dɨꞌɨɨꞌn: ―Dho jax jach gi pup duuñ jiñ ñaan, nat guꞌ chakuim ai na paiꞌ dhuuk daaxix nam machiaꞌ dhi jaaduñ nañ jir tuꞌp tuꞌm daꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Baꞌ gu dɨꞌɨɨꞌn gu Jesuus daipuꞌ xi chɨɨdak mu jaꞌk jup ba ja aaꞌñdhim gu koiꞌ bhiadam, jup ja tɨtda: ―Moo pim alh miꞌ puiꞌ xi chu duñiidhaꞌ na jɨꞌk jax jam tɨɨdaidhaꞌ guꞌñiñ chioꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Baꞌ mi jaꞌp jup ja biaꞌkaꞌ am gu oiꞌñkam xijum maaꞌn gu gɇꞌgɇr jajaꞌ nar jix mamoik joodai sobkoñxim, na chi gook kaꞌ baꞌ baik bapaiꞌñdhakar bhɨɨ gu suudaiꞌ bɨɨx jɨꞌmaꞌn, guiꞌ nam bhaan tuaꞌkaꞌ gu suudaiꞌ nam kɨꞌn jum ikoimiꞌñdhaꞌ gammɨjɨ nam paiꞌ dhuuk ba ji chu jugiaꞌ, nam guꞌ puiꞌ jaꞌk tu jimdaꞌ gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Baꞌp ja tɨtda gu Jesuus gu koiꞌ bhiadam: ―Ea gor miꞌ xi chuaꞌ gu suudaiꞌ dhi gɇꞌgɇr jajaꞌ taꞌm na muni daraa, susdagɨm moo. Baꞌ guiꞌ miꞌp xi ja susduiꞌ mɨt jupaaban. ");
INSERT INTO stpNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Baꞌp ja tɨtda ɨp gio: ―Xib japim baꞌ alhiꞌch baxbhai muiꞌ xi choiꞌdhikaꞌ guiꞌ na yaꞌ umuaꞌñdhix na tu ja makiaꞌ dhi jaꞌtkam. Baꞌ guiꞌ alhiꞌch baxbhak muiꞌp xi bhɨidhak jamɨt. ");
INSERT INTO stpNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Baꞌ na bhaiꞌ xi dhɨꞌnka, jir jix kɨɨꞌ biiñ jix oꞌjoꞌ. Ku guꞌ pu cham maat ji noꞌp jir suudaiꞌ kat nat biiñ jup jum duu, dai gu bhiadam nam miꞌ palhbuiꞌñ nam baꞌx maat nar suudaiꞌ kat pɨx, na mɨt guꞌ dhiꞌ tu tua gu suudaiꞌ, pɨx ji nam guꞌ am cham jax kaiꞌch. Baꞌ nat xi dhɨɨkak nar biiñ, jaꞌp xi baabuk ");
INSERT INTO stpNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","jup tɨtda guiꞌ na miꞌm tɨtmu: ―¿Kux cham aar am kat nach dhiꞌñix kɨɨꞌ biiñ bɨɨpɨꞌ ja toiꞌdhaꞌ gɨt dhi jaꞌtkam? Gi na guꞌ puiꞌ jaꞌk jum bua. Noꞌm jix ioꞌm bax bɨɨnaꞌ nach baꞌ gu kuugaꞌn muiꞌp ba ja toiꞌdhaꞌ gɨt. Jaiñ nap guꞌ tɨi pu biaꞌ bak, xib na pich baꞌ bhaiꞌ ba ji bax. ");
INSERT INTO stpNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Baꞌ dhiꞌ nat puꞌñix bhaiꞌm duukam jup tu duu gu Jesuus, bhaan bhaiꞌ ji matgir na jaꞌxbuiꞌp jir gɇꞌkam na guch Gɨꞌkoraꞌ. Baꞌ pu bɨɨx ja jujur kɨꞌn tɨ jɨɨꞌñ jamɨt guiꞌ nam kaichuꞌ na mɨt tɨɨ nat jax tu duu. ");
INSERT INTO stpNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Baꞌ miꞌ dhɨr ba jii gu Jesuus mu jaꞌk Kapernaum ja bɨɨm guiꞌ nam kaichuꞌ gam gu jajaaꞌnniꞌñ gio baꞌ gu dɨꞌɨɨꞌn, miꞌ mɨt xi juruuñdhak jɨꞌk tanoolh. ");
INSERT INTO stpNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Baꞌ na guꞌ bam aajim nam paiꞌ dhuuk tu piastatdaꞌ gu Israel kam jaꞌtkam bhaan paaskua taꞌm nam bhaan tɨꞌñchokaꞌ janoꞌ nat paiꞌ dhuuk ja palhbui gu Dios na mɨt bha bubua mu dɨr Ejipto, muiꞌ ma jii gu Jesuus bhammɨ Jerusaleen na bhammɨ jaꞌk buusaidhaꞌ gu bhaan Paaskua taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Baꞌ nat bhammɨ ɇɇk muiꞌ ji baa bhɨjɨ gɇꞌ chiop, mɨjɨ jaꞌp pɨx jiiñak bɨɨt am gu bhuiꞌmyax gaꞌradam, gio gu kakasnir gaꞌradam, gio baꞌ gu giokdaꞌ gaꞌradam. Gio guiꞌ nam tuumiñ pataasdaꞌ mi jaꞌp pɨx jax jup daraa am. ");
INSERT INTO stpNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Baꞌ gu Jesuus nat jax tɨrbi maaꞌn guiꞌ na kɨꞌn tɨm gɨb na jaꞌp tuꞌm na chipliiñ, kɨꞌn pɨx chaꞌtak ja jimchuꞌn gu bhuiꞌmyax gaꞌradam gio guiꞌ nam kakasnir tu gaꞌra. Gio gu tuumiñ pataasdam pu ja iaꞌlhxichulh guiꞌ nam bhaan ka tuaꞌkat gu ja tuumñiꞌ. Bɨɨx ja bubuax mɨjɨ jaꞌk dɨɨrap. ");
INSERT INTO stpNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Gio gu giokdaꞌ gaꞌradam jup ja tɨtda: ―¡Mu pim ja bubuaxdhaꞌ dɨɨrap dhi giokdaꞌ! ¿Jax gi ku pim baꞌ yɨjɨ pu tu duuk na cham tuꞌ pu kaiꞌñkam yaꞌ tu baꞌaak guñ Gɨꞌkoraꞌ na bɨxchuꞌ yɨjɨ tum gaꞌradaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Baꞌ guiꞌ nam kaichuꞌ gu Jesuus ba tɨꞌñcho mɨt na bak pɨn puꞌñi tu uaꞌñix gu ñioꞌkiꞌñ gu Dios miꞌ nat paiꞌ tum uaꞌnak nap jum kaiꞌch: “Aañ tɨix aagat na dai nam yaꞌ dɨr jum daandaꞌ gɨt pɨx nap paiꞌ tu chiopiꞌñ Gɨꞌkoraꞌ, cham tuꞌ na bɨɨx aixim yaꞌ tum buadaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Baꞌ gu gɇꞌgɇrkam Israel kam bɨɨx maap jim daagɨt jup tɨtda am gu Jesuus: ―Eap jix bhaiꞌm duukam xip tu duuñ jich ñɨiꞌñchudat nach baꞌ moom jɨɨgiꞌñdhaꞌ nap sɨlhkam gɇꞌkam kat yaꞌ pu tu bua. ");
INSERT INTO stpNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Baꞌ gu Jesuus jup ja tɨtda: ―Dho kani gor iaraiñ dhi chiop nañ aañ baik tanoolh kɨꞌn giop kɨɨsaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Baꞌ guiꞌp kaiꞌch am: ―¡Jɨɨ chi guꞌ moo baik tanoolh kɨꞌn jup ba kɨi pich dho gi ji! Muiꞌ jaꞌtkam jam saak yaꞌ tu juanaimɨk na mɨt paiꞌ dhuuk kɨi dhi chiop ku mɨt gook ooꞌm daman xijum maaꞌn oidhaꞌ kɨꞌn ka tɨɨmo. Guꞌ aap dɨɨlh gi baꞌ, ¿paa duuk japich jup ba tɨɨmo? ");
INSERT INTO stpNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Guꞌ na mɨt guꞌ pu cham maatɨt kai kum baꞌp tɨtda. Jaꞌp jum aaꞌ am na sɨlhkam dhiꞌ aaꞌ gu chiop miꞌ nam paiꞌ dhɨr tu daan. Guꞌ gu chiop na aaꞌ gu Jesuus, gu tukgaꞌn ji na aagat jup kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Sia guiꞌ nam kaichuꞌ pu cham maatɨt kai mɨt gu miꞌ jotmodaꞌ. Mɨkkat ji nat paiꞌ dhuuk muukɨk gio duadɨk jup ba bam na mɨt ba tɨꞌñcho na pɨn puꞌñi ja tɨtda nam duñiaꞌ. Miꞌ dhɨr baꞌ ba tɨ jɨɨꞌñ jamɨt na jɨꞌk jax ja tɨtda, na mɨt guꞌ ba maat nar puiꞌ nat jax tum uaꞌnak bɨjɨk gu ñioꞌkiꞌñ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Baꞌ janoꞌ na bhammɨ oirɨ Jerusaleen gu Jesuus bhaan Paaskua taꞌm na bhaiꞌr piasta, muiꞌ jaꞌtkam tɨi xi chɨ jɨɨꞌñ jamɨt buiñor gu bhaiꞌ jotmodaꞌ nam nɨiꞌñ nat jix bhaiꞌ tu duu na tuꞌr jix bhaiꞌm duukam. ");
INSERT INTO stpNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Guꞌ ji na guꞌ cham ja jɨɨgiꞌñ gu Jesuus, na guꞌx bhaiꞌx maat nam pɨx jap jum bua. ");
INSERT INTO stpNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Na guꞌ giilhim jix bhaiꞌx mat kaꞌ nam jax jum aaꞌndaꞌ gu jaꞌtkam ja jujur am bhaan, cham jaroiꞌm aaꞌ na miꞌ dhɨr jup aagiꞌñdhaꞌ nam jax jir tuꞌm kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Maaꞌn gu maaꞌnkam Nikodeemo tɨɨgim bhaiꞌ kiokaꞌ Jerusaleen, na maadɨt jir diꞌ kaꞌ gu ja gɇꞌgɇrkam tuk gu Israel kam jaꞌtkam nam pariseos jum tɨɨtɨꞌndaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Baꞌ maaꞌnnim muiꞌ mam dɨkoo gu Nikodeemo nat muiꞌ ma jii tukaaꞌñ chaꞌm mu na paiꞌ tɨbiap gu Jesuus. Mummu ba ji buus, baꞌp tɨtda: ―Bax maat ich jiñ jaduuñ nat aap Dios bham joot nap yaꞌ tuch aꞌgidhaꞌ nach jax jaꞌk miꞌ puiꞌ jiimdaꞌ na jax jix aaꞌ, nach guꞌ cham paiꞌ jaroiꞌ puiꞌ nɨidhat nax bhaiꞌ tu bua na tuꞌr jix bhaiꞌm duukam noꞌ cham bhaan tɨ nɨidhim gu Dios jaꞌp na jax aap nap bɨxchuꞌx aichuꞌn nap pu tu duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Baꞌ gu Jesuus jup tɨtda: ―Tuꞌ sɨlhkam jañ yaꞌ pum tɨɨdaꞌ, na gu jaroiꞌ noꞌ cham xim gaꞌnga na jax jaꞌk duuji giop maaxilhiaꞌ, cham tuꞌ bhaan tɨ nɨidhidhaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Baꞌp kaiꞌch gu Nikodeemo: ―¿Jax gi dhuip kax bhaaiꞌ nañ giop maaxilhiaꞌ noꞌñ puiꞌ bar gɇꞌ maaꞌnkam? Na guꞌ cham ka bhaaiꞌ nañ jax dhui ɨlhiꞌch jup jiñ dhui mɨjɨ baakɨi ɨrban guñ ñaan giop maaxilhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Baꞌp tɨtda gu Jesuus: ―Tuꞌ sɨlhkam jañ yaꞌ pum tɨɨdaꞌ, na gu jaroiꞌ noꞌx aaꞌ na gammɨjɨ bhaan tɨ nɨidhidhaꞌ gu Dios, bɨɨpɨꞌm aaꞌ na xim gaꞌngadaꞌ na jax jaꞌk duuji tajaañdhix kaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ, na baꞌ miꞌ dhɨr jaꞌp ji buusniaꞌ na ba bakuañix kaꞌ suudaiꞌ kɨꞌn. ");
INSERT INTO stpNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Guꞌ dhi tuukuꞌ na yaꞌ maaxilhiaꞌ, yaꞌ pur tuukuꞌ kaꞌ ji. Guꞌ aañ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ ji nañ aagɨt jup kaiꞌch, noꞌt bhaan bam tajaa gu jaroiꞌ noꞌ ba tɨ jɨɨgiꞌñ aañ jiñ bui na jaꞌp ji buusniaꞌ na giop ba maaxilhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","¿Giilhim jix xijaim kaiꞌch iñ aa panaas kup baꞌ miꞌ puiꞌ pup tuꞌiiꞌ? Matgam bɨɨx ja aꞌm jum aaꞌ ji gu jaꞌtkam nam giop maaxilhiaꞌ noꞌm moo puiꞌp ɨlhiiꞌñdhaꞌ gɨt nam miꞌ puiꞌ ba jimiaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Dhiꞌ jaꞌp ji buusan jia na jax gu jɨbɨɨlh nap pu cham mat kaꞌ na paiꞌ dhɨr bha jɨbɨɨrdaꞌ sia ku yaꞌni jaꞌp pɨx kuu, ni nap jix mat kaꞌ na pa jaꞌk jax jum duñiidhaꞌ. Puꞌñip ji buusan gu jaroiꞌ noꞌ ba tajaañdhix gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ, panaas ku giop ba maaxilhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Baꞌ gio bhaiꞌp ji ñio gu Nikodeemo, jup kaiꞌch: ―Chaam ji nañ maatɨt jum kɇɇ ni jɨꞌx na jax jir jum duukam nap jax kaiꞌch jiñ jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Baꞌ gu Jesuus jup tɨtda: ―¿Gi jax jum duu pich jiñ jaduuñ? Nap saak aap maadɨt jir diꞌ gu ja gɇꞌgɇrkam tuk gu jaꞌtkam yaꞌ dhi Israel, na baꞌ puiꞌ ni jɨꞌx kup jix maatɨt jiñ kɇɇ nañ jax kaiꞌñkam jup jum tɨtda. ");
INSERT INTO stpNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tuꞌ sɨlhkam jañ yaꞌ pum tɨɨdaꞌ, na aañ bɨɨx nañ jɨꞌk jax tu aꞌga, nɨidhix kam jup kaiꞌch iñ, cham tuꞌ nañ jax aajim pɨx nañ puiꞌ tu aꞌgim. Muiꞌ dhɨt jam dhox chu maat nañ aañ cham tuꞌ iatdaꞌ tu aꞌga, guꞌ ji na guꞌ aapiꞌm na pim jɨꞌk jir gɇꞌgɇrkam jaꞌp xi dhuukat, ni jɨꞌx ku pim cham jiñ jɨɨgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tɨɨꞌ na pim guꞌp kaiꞌchdhaꞌ na pim cham maatɨt jiñ kɇɇ nañ paiꞌ dhuuk tɨi tu jam aꞌgiꞌñdhaꞌ bhaan ji uaꞌrgidhat gu tuꞌ nar yaꞌ kam dhi oiꞌñgaꞌn. ¿Jax japim baꞌ duujix maatɨt jup kaayaꞌ gɨt noꞌñ dai gu tuꞌ nar jix dhaam kam bhaan ji uaꞌrgidhai bhaiꞌ ji chu jam aꞌgidhaꞌ gɨt? ");
INSERT INTO stpNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Na guꞌ aañ jix dhaam dɨr jimdat jup kaiꞌch na paiꞌ cham jaroiꞌ tɨ nɨiꞌñ, dai aañ nañ jir bhammɨ kam nat baꞌ bhañ joot guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jiñ xissapaꞌ am baꞌ kuruus taꞌm jaꞌp na jax gu koꞌ gup duñiixim nat uux chaꞌm sissapak bɨjɨk gu Moisees mummu na paiꞌ oilhimɨk gampɨx ja bɨɨm gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Na baꞌ guiꞌ nam jɨꞌk tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui gammɨjɨ ja aꞌm ba tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ, nam baꞌ cham kam tulhiiñaꞌ, dai nam ba jimiaꞌ jix dhaam jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Na guꞌ giilhim tɨix ja joiꞌgɨꞌn gu Dios bɨɨx na jɨꞌk gu jaꞌtkam, puiꞌ kut baꞌ bha joot gu dai maaꞌn maraaꞌn yaꞌ dhi oiꞌñgaꞌn, na sap baꞌ bɨɨx guiꞌ nam jɨꞌk tɨ jɨɨꞌñdhaꞌ buiñor, cham tuꞌ kam tulhiiñaꞌ am, dai nam ba jimiaꞌ jix dhaam jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Cham tuꞌ nat jax kaiꞌñkam bha joot gu Dios gu maraaꞌn na yaꞌ ɇɇji ja tulhiiñchudaꞌ gu jaꞌtkam, guꞌ jaꞌpji na yaꞌ tu ja uañdhaꞌ ji gu ja uaꞌtulhdharaꞌ nam baꞌ puꞌñi duuji cham kam tulhiiñaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Na baꞌ gu jaroiꞌ noꞌt ba tɨ jɨɨꞌn puꞌñi buiñor gu Maraaꞌn, cham tuꞌ ka tulhiiñchudaꞌ guch Gɨꞌkoraꞌ. Guꞌ ji noꞌt guꞌ jax dhuuk cham tɨ jɨɨꞌñ buiñor, dho gi guꞌ pɨx am tɨꞌñchokaꞌ ji na tulhiiñchudaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na guꞌ giilhim jix ioꞌm jum tulhiiñaꞌ gu jaroiꞌ noꞌ cham tɨ jɨɨgiꞌñ buiñor guiꞌ na joidham gɇꞌ tanoor na yaꞌ tɨi oirɨ. Baꞌ xib guiꞌ nam pu cham tɨ jɨɨgiꞌñ buiñor, giilhim jamɨt dho gɇꞌ bam uaꞌtulh, na guꞌ dai nam jix joiꞌñ nam bɨɨx aixim tu bua na tuꞌr jix buam jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Baꞌ cham kɨɨgalhiꞌñ am guiꞌ na joidham gɇꞌ tanoor puiꞌ xi chu buaꞌt. Pu cham paiꞌ miꞌ paiꞌ guꞌnguk am baꞌ taaꞌban nam jix xiꞌɨrdat, na guꞌ pu ja tɨɨdaꞌ na cham jir am gu puiꞌ nam jɨꞌk jax tu bua. ");
INSERT INTO stpNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dai guiꞌ nam jɨꞌk tuꞌ kaꞌm nɨiꞌñ nam baꞌ buiñor xip tuiꞌdhiꞌ guiꞌ na joidham gɇꞌ tanoor. Dhiꞌ baꞌ bhaan jix maatɨꞌ nam miꞌ puiꞌ jiimchuꞌ na jax jix aaꞌ gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Baꞌ miꞌ dhɨr na puiꞌ jɨꞌ xi chu aꞌgidhimɨk gu Nikodeemo, ba jii gu Jesuus ja bɨɨm gu noonbiꞌñ mummu jaꞌk maaꞌn kap na paiꞌx jaiꞌch gu suudaiꞌ na Judea bhaan bipioꞌ guiꞌ gu dɨbɨɨr. Miꞌ mɨt baꞌ juruuñ jɨꞌk tanoolh nam ja bopkondaꞌ gu jaꞌtkam guiꞌ nam jɨꞌk tɨ jɨɨꞌñdhidhaꞌ na jɨꞌk jax tu ja aꞌgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Gu Juan mummu jaꞌk Enoon jup ja bopkondaꞌ miaꞌn na paiꞌ Salim tɨ tɨɨꞌ, na guꞌ jaꞌp moo joidham sabaar jup mɨrdaꞌ mummu gu suudaiꞌ. Dɨɨlh pɨx ji aajidhaꞌ am ji guꞌ gu jaꞌtkam nam xim bopkonak kaꞌ, nam guꞌ tɨ jɨɨgiꞌñdhaꞌ na jɨꞌk jax tu ja aꞌgiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Janoꞌ chakui kuu mɨt gu Juan. ");
INSERT INTO stpNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Baꞌ jɨꞌkchi guiꞌ nam cham kaichuꞌ gu Juan ma ja ñiokbuix jamɨt guiꞌ nam kaichuꞌ gu Juan nam puiꞌ ji kaiꞌchɨt na puiꞌ jaꞌk tu daaxix nam muiꞌkim jum ikoimiꞌñ nam paiꞌ dhuuk ba ji chu jugiaꞌ. Cham jum aaꞌ nam moop jum bopkonaꞌ, nam guꞌ sap maakam tu jim. ");
INSERT INTO stpNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Miꞌ puiꞌ xi kaiꞌchimɨk mummu jaꞌk maakam jup ba tu aꞌgidhim am gu Juan guiꞌ nam kaichuꞌ, jup tɨtda am: ―Guiꞌ nap aaꞌ janoꞌ na bhammɨ dɨr oirɨ baasɨꞌn dɨr gu Jordaan Ak, guiꞌ bo na pich saak bha ja mattudam gu jaꞌtkam nar tuꞌp tuꞌm daꞌ, xib puiꞌp ba ja bopkon gu jaꞌtkam. Puiꞌ muiꞌp ba kaichuꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Baꞌp ja tɨtda gu Juan: ―Dho guꞌ bhaan tɨ nɨidhim ji guch Gɨꞌkoraꞌ ku baꞌp tu bua, cham tuꞌ na moo jaꞌp pɨx na mu paiꞌ puiꞌp ba tu bua dɨɨlh pɨx na jax ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","¿Kux cham tɨꞌñcho pim aa nañ jup kaiꞌch janoꞌ: Aañ cham tuꞌr diꞌ guch Xoiꞌkam? Matgam aañ bhaiꞌ pɨx jiñ joot ji guch Gɨꞌkoraꞌ nañ bɨɨpɨꞌ kat ya jaꞌp ba ja mattudaꞌ gu jaꞌtkam na cham xiim bha jim. Dhiꞌ dhor diꞌ na pim mu paiꞌ aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Baꞌ aañ xib giilhim jix bhaiꞌñ chaat nat yaꞌ ba ai. Jaꞌpniñ jix bhaiꞌñ chaat na jax gu jaroiꞌ na umuaꞌñdhix kaꞌ na bhaankamuꞌn tu ja maakdaꞌ gu jaꞌtkam na paiꞌ dhuuk bar bhaan kaꞌ na bam tɨɨmoꞌ gu biapmaꞌ bɨɨmaꞌn gu tɨyaa. ");
INSERT INTO stpNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Guꞌ baꞌ gu xib aañ pur cham tuꞌ dho kiaꞌ, nat guꞌ bam kuugalh na jax tu daaxix kat nañ jax tu ja aꞌgidhimɨk gu jaꞌtkam. Dai ji nam muiꞌ xim dɨkooꞌñdhaꞌ nam muiꞌ xi kaayaꞌ guiꞌ nar gɇꞌkam nat yaꞌ ba ai. Cham jax bua sia ñich aañ yaꞌ pɨx jaꞌp ji bii, nañ guꞌ aañ cham tuꞌr jupaabkamuꞌn. ");
INSERT INTO stpNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Guiꞌ nat jix dhaam dɨr bha jii na giilhim jir gɇꞌkam, bɨɨx jix chu maat na jax tu tuꞌiiꞌ bhammɨ. Cham tuꞌ puiꞌ na jax gu jaꞌtkam nam dai gu tuꞌ ya jaꞌp kam dhi oiꞌñgaꞌn bhaan jim iatat gɇꞌgɇrkam jum ɨlhiiꞌñdhaꞌ, guꞌ guiꞌ ji nat jix dhaam dɨr bha jii na baꞌ puiꞌm tɨɨtɨꞌ nar gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Na guꞌ bɨɨx jix chu maat na jɨꞌk tuꞌ bhammɨx chu jaiꞌch jix dhaam nach aach tuꞌ cham maat. Guꞌ ji nam guꞌ muiꞌ jaꞌtkam cham tɨ jɨɨgiꞌñ, nam guꞌ jaꞌp jum aaꞌ na pɨx jap kaiꞌch, ");
INSERT INTO stpNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","nam guꞌ cham tɨ jɨɨgiꞌñ na jax kaiꞌch gu Dios bhaan gu uꞌuan taꞌm na tu uaꞌñix. Noꞌm guꞌ moo tɨ jɨɨgiꞌñdhaꞌ gɨt na jax jum kaiꞌch, matgam ba tɨ jɨɨꞌñdhaꞌm gɨt ji buiñor guiꞌ nat jix dhaam dɨr bha jii. ");
INSERT INTO stpNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nat guꞌ pu kaiꞌñkam bha joot gu Dios maakak gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ gɇꞌ cham daaxix kam, na baꞌ yaꞌ bhaankamuꞌn tu aꞌgaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baꞌ na guꞌx dhaꞌdat jix kɨɨgalhiꞌñ guch Gɨꞌkoraꞌ gu Maraaꞌn, bɨɨx chu maa na tuꞌ ɨlhiiꞌñ. Dai guiꞌ bhaan jup tu tuꞌiiꞌ gu xib bɨɨx nach jɨꞌk tuꞌ cham ɨlhiiꞌñ aach. ");
INSERT INTO stpNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Baꞌ gu jaroiꞌ na tɨ jɨɨꞌñdhaꞌ buiñor gu Maraaꞌn gu Dios, pu baidhikaꞌ jix dhaam jaꞌk na paiꞌp tuꞌiiꞌ. Dai gu jaroiꞌ noꞌ cham tɨ jɨɨgiꞌñ buiñor dho gi guꞌ cham tuꞌ baidhikaꞌ ji, dai na pɨx am tɨꞌñchokaꞌ na tulhiiñchudaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Baꞌ ba maat gu Jesuus nam puiꞌ ba tɇ kɇɇ guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ na amuub oirɨ, sap jup kaiꞌchdhaꞌ am gu jaꞌtkam: “Puiꞌp ba ja bopkon gu Jesuus gu jaꞌtkam, dai guiꞌ pɨx jam baꞌ mu jaꞌk ba kaichuꞌ bɨɨx, gu Juan miꞌ pɨx jaꞌp ji biꞌiim.” ");
INSERT INTO stpNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ku guꞌ puiꞌ pɨx ɨlhiiꞌñ am ji na gu Jesuus ja bopkon gu jaꞌtkam, sia ku guꞌ tɨi gu noonbiꞌñ pɨx na ja chian. ");
INSERT INTO stpNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Baꞌ puiꞌ ma jii gu Jesuus miꞌ dhɨr Judea, sɨlh mummu jaꞌk bhɨi Galilea. ");
INSERT INTO stpNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Miꞌ baꞌ moo buusnichuꞌ na paiꞌ Samaaria tɨ tɨɨꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Baꞌ mummu ba ai na paiꞌr kikcham, Sikaar tɨ tɨɨgim, na Samaaria dɨbɨɨr bhaan bipioꞌ, miaꞌn nat paiꞌ iimchudak gu dɨbɨɨr gu Jakob gu maraaꞌn Josee, ");
INSERT INTO stpNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","nat paiꞌ kolhbixdhak gu suudaiꞌ. Baꞌ gu Jesuus jimdat mi jaꞌp jim jɨɨp na paiꞌ kolhbixdhix gu suudaiꞌ na bax magoontuꞌ nat guꞌ mɨk ba jii, nat guꞌ puiꞌx dhaam ba ji dhuu nat baꞌ miꞌ ka bhɨi. ");
INSERT INTO stpNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Baꞌ miꞌ puiꞌ na kam jɨɨpiꞌñ gu Jesuus, miꞌ ba ji buus maaꞌn gu ubii nat muiꞌ ba baiꞌgam nar miꞌ kam Samaaria. Baꞌ gu Jesuus jup tɨtda: ―Noꞌ pich miꞌ dhɨr iam alhiꞌch bhañ baxbhi gu suudaiꞌñ jaduuñ na pich kapbhaiꞌ yaꞌ ba ai. Mooñ pɨk jaꞌp ba tonmoim ji kux baꞌ puiꞌ aa. ");
INSERT INTO stpNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Guꞌ na guꞌ dɨɨlh miꞌp ka daa gu Jesuus na mɨt ka tu taanim gu koiꞌ guiꞌ nam kaichuꞌ mu gɇꞌ kiicham. ");
INSERT INTO stpNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Baꞌ nam guꞌ iam pɨx cham jum kɨkɨɨgalhiꞌñdhaꞌ gu Israel kam jaꞌtkam gio gu Samaaria kam, puiꞌ ku baꞌp kaiꞌch pɨx gu ubii na tɨi taan gu suudaiꞌ gu Jesuus: ―¿Jax jap baꞌm aagɨt bhaiꞌp bañ chaan gu suudaiꞌ nañ jum baxbhidhaꞌ? Nap guꞌ aap jir Israel kam, cham tuꞌr yaꞌ kam ap Samaaria. Nap guꞌx maat nam cham jum kɨkɨɨgalhiꞌñ bo gu Israel kam gio gu yaꞌ oiꞌñkam. ");
INSERT INTO stpNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Baꞌ gu Jesuus jup tɨtda: ―Aap guꞌ moo cham jax ji kaiꞌchɨt alhiꞌch xiñ baxbhidhaꞌ jiñ jaduuñ, nap guꞌ cham maat nañ jir tuꞌp tuꞌm daꞌ aañ nañ yaꞌm taan gu suudaiꞌ, ni kup jix maat na tuꞌm makiaꞌ gu Dios noꞌp moo soiꞌm ɨlhdhai ba taandaꞌ gɨt. Pu kani noꞌ pich aap soiꞌm ɨlhdhak jiñ chaa gu suudaiꞌ, jix kɨɨꞌ ji nañ jum makiaꞌ na jax chuꞌm kɨꞌn jix bhaiꞌ ba tum jimdaꞌ noꞌ pich ba ii. ");
INSERT INTO stpNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Baꞌ gio bhaiꞌ ji chu aꞌga gu ubii, jup kaiꞌch: ―¿Tuꞌp baꞌ kɨꞌn ɨlhiiꞌñ nap baxbhaꞌ, na guꞌr tuukab mɨjɨmmɨ na paiꞌ suuꞌn dhi suudaiꞌ? Tɇb jum aaꞌ gu tuꞌ nañ kɨꞌn giaꞌrgidhai mu baasaꞌ gu baiꞌñdhakar nañ baꞌ ba tu baiꞌgiaꞌ. Aap gi baꞌ nap cham uaꞌ na tuꞌ kɨꞌn, ni nap tuꞌ kaꞌm baxbhaꞌ. ¿Kaꞌ paap gi nɨidhat jup kaiꞌch ji gux kɨɨꞌ gu suudaiꞌ na puiꞌ kɨꞌn jix bhaiꞌ ba tuñ jimdaꞌ noꞌ ñich ba ii? ");
INSERT INTO stpNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jaꞌp moo nap pɨx jap kaiꞌch dho jia nap gɇꞌkam tɨi xim ɨlhiiꞌñ nap ɨlhdhat nañ moop bam kaayaꞌ, jaꞌp na jax guch boxii kat Jakob nach kaichgɨt, guiꞌ nat yaꞌch iimchudak dhi suudaiꞌ kolhbixdhak. Na guꞌ guiꞌ yaꞌ tu baꞌiiꞌndat ja bɨɨm gu maamraꞌn, gam gu sasoigaꞌn na yaꞌ tu iꞌchdat. ¿Kaꞌ giilhim gɇꞌkam tu tatdaꞌ aa panaas? ");
INSERT INTO stpNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Baꞌp tɨtda gu Jesuus: ―Aa guꞌ matgam dhi suudaiꞌ nap aaꞌ aap, cham tuꞌm aꞌga ji, na guꞌ dhiꞌ cham tuꞌ am tu juꞌngiꞌñ, na guꞌ jaꞌxpɨx giop bax chanoom kaꞌ gu jaroiꞌ sia kut tɨi xi ii. ");
INSERT INTO stpNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Guꞌ gu suudaiꞌ nañ aañ jax chuꞌm tu maak, cham tuꞌ ka tanoom kaꞌ ji gu jaroiꞌ noꞌt ba ii, na guꞌ gammɨjɨ pu bhaan ba baꞌpundaꞌ, na guꞌ bhaan ba tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ na baꞌ cham tuꞌ ka tulhiiñchudaꞌ, dai na ba baidhikaꞌx dhaam jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Baꞌp kaiꞌch gu ubii: ―Eap alhiꞌch jiñ maak ku gi gu suudaiꞌ gu pu chuꞌm nap puiꞌ tu maak nañ kɨꞌn cham jɨꞌxdhaꞌ ka tanoom kaꞌ, kat jañ chi iam cham bhaiꞌ ka jimmɨdaꞌ nañ bha tu baꞌiiꞌndaꞌ yaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Baꞌp tɨtda ɨp gio gu Jesuus: ―Dho eap baiꞌñmɨr guiꞌ nap bɨɨmaꞌn daañ jaduuñ. Xib jañ yaꞌ jam nɨɨra bɨɨx gook. ");
INSERT INTO stpNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Baꞌp kaiꞌch gu ubii: ―Jax dhui nañ aañ cham tɨ bɨɨnaꞌ. ¿Paañ gi dhɨr bhaiꞌp baidhaꞌ? Baꞌ gu Jesuus jup tɨtda: ―Jir puiꞌ dho nap jax kaiꞌch jiñ jaduuñ nap puiꞌ cham tɨ bɨɨnaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Na pich guꞌx chamaamim maiꞌ ba ja iabu, jumaip pɨx jix bhaiꞌp ba tɨɨdaꞌ gu maaꞌnkam gio jumai. Guꞌ baꞌ dhiꞌ nap xib oiꞌñ, cham tuꞌ dhor jum bɨɨnaꞌ. Jir sɨlhkam dho nap jax kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Baꞌp kaiꞌch ɨp gio gu ubii: ―¿Jax jap duukat jix bhaiꞌx maat jiñ jaduuñ? Aap ji bak bhaankamuꞌn jup ba tu aꞌga jia guch Gɨꞌkoraꞌ jaꞌp na jax saak gu bɨjɨk dɨr kam nam bhaankamuꞌn tu aꞌgimɨk. ");
INSERT INTO stpNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Guꞌp bak bax aaꞌ nach bhammɨ jaꞌk tu daandaꞌ Jerusaleen na paiꞌ saak aagix na pim jax ba kaiꞌchdhaꞌ aapiꞌm na pim jɨꞌk jir Israel kam. Guꞌ ji na guꞌ aach miꞌ puiꞌ tu daaꞌñchuꞌ nam jax tu jimdat guch bopxikat nam bhaꞌñi dhɨr tu daandaꞌ guꞌñi oidhaꞌ daam nach paiꞌ dhɨr tu daan aach xib. ");
INSERT INTO stpNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Baꞌp tɨtda gu Jesuus: ―Ea nap jix bhaiꞌ xiñ kaayaꞌ bɨɨx jum jur kɨꞌn jiñ jaduuñ nañ jɨꞌk jax jum tɨɨdaꞌ. Kam aajim na paiꞌ dhuuk cham kam aaꞌndaꞌ na pim dai bhaiꞌ dhɨr dhi oidhaꞌ daam mu daandaꞌ guñ Gɨꞌkoraꞌ, ni bhammɨ dɨr jaꞌk Jerusaleen. ");
INSERT INTO stpNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Aapiꞌm guꞌ jaꞌp jum aaꞌ nar am na pim jax tu daan. Chaam tuꞌr puiꞌ ji matgam, na pim guꞌ cham maat noꞌ moop jir diꞌ guñ Gɨꞌkoraꞌ na pim daan. Guꞌ aach matgam jix maat ji, gam na puꞌñi bhaiꞌ dhɨr buusniaꞌ ja bui gu Israel kam jaꞌtkam guiꞌ na uanaꞌ gu ja uaꞌtulhdharaꞌ bɨɨx na jɨꞌk jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Baꞌ xib yaꞌ bam ai nam paiꞌ dhuuk ampɨx machiaꞌ gu jaꞌtkam nam jax jaꞌk bɨɨx ja jujur kɨꞌn ba tu daandaꞌ buiñor guñ Gɨꞌkoraꞌ, na guꞌ ka ja tajaañdhaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ na ja guguuxdhatgɨdaꞌ nam gammɨjɨ tu daandaꞌ jix dhaam na paiꞌp tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gu Dios pu cham maax jia, na guꞌ giilhim jir jix uañ. Baꞌ bɨɨpɨꞌm aaꞌ nam buiñor tɨ jɨɨꞌñdhaꞌ gu jaꞌtkam bɨɨx ja jujur kɨꞌn na baꞌ bhaiꞌ ji ja mattudaꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ nam jax jaꞌk tu daandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Baꞌ gio bhaiꞌp ji ñio gu ubii, jup kaiꞌch: ―Dho guꞌ aach yaꞌ pɨx tɨi nɨɨra ji guch Xoiꞌkam na saak bha jimdaꞌ na baꞌ yaꞌ tuch aꞌgidhaꞌ na jax jaꞌk jix bhaiꞌ nach tuiꞌñgɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Baꞌ gu Jesuus jup tɨtda: ―Aañiꞌ dhor diꞌ nañ yaꞌ tum aꞌgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Baꞌ moo miꞌp ba ai mɨt guiꞌ nam kaichuꞌ na mɨt jaꞌk ba suulh mu dɨr jaꞌk na mɨt tu taanpuk gu koiꞌ. Baꞌ miꞌ puiꞌ pup tuꞌiiꞌ am na mɨt ba tɨɨ gu Jesuus na gu ubii bɨɨmaꞌn tu aꞌgichuꞌ, ku guꞌ cham maadɨt jum guguux ji na moo xi chɨkkaꞌ gɨt nam tuꞌ tu aꞌga, na jax tɨɨdaꞌ gɨt: “¿Tuꞌp baꞌ tɨkkaꞌn dhi ubii?” Piam na jax tɨɨdaꞌ gɨt: “¿Tuꞌ pim baꞌ tu aꞌga?” ");
INSERT INTO stpNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Baꞌ pu cham ji chu baiꞌgɨk gu ubii puiꞌ mi jaꞌp xi dhaasak gu baiꞌñdhakaruꞌn pu jii mummu na paiꞌr kikcham nat ja aaꞌñdham gu jaꞌtkam na jɨꞌk jax tɨtda gu Jesuus, jup ja tɨtdaim: ");
INSERT INTO stpNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Muni dhaa maaꞌn gu maaꞌnkam na paiꞌ tum baꞌiiꞌ na giilhim bɨɨx jix bhaiꞌx maat nañ jax jiñ buaꞌt oirɨdaꞌ. ¿Cham aa chir diꞌ guch Xoiꞌkam guiꞌ na saak bha jimdaꞌ? Pu ka gor maik jach tɨɨꞌmpuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Baꞌ gu jaꞌtkam miꞌ oiꞌñkam pɨx chuꞌp jum duu mɨt na mɨt ba tɨɨgim noꞌ moor sɨlhkam na jax ja tɨtda gu ubii. ");
INSERT INTO stpNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Guꞌ baꞌ guiꞌ nam kaichuꞌ gu Jesuus, mu jaꞌk tɨi tu aagiꞌñ am gu koiꞌ soiꞌ tɨtdat jup tɨtda am: ―Yaꞌ jaiꞌ bi chu juꞌñ jaduuñ. ¿Cham bax bhioꞌ ap? ");
INSERT INTO stpNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Guꞌ ji na guꞌ gu Jesuus jup ja tɨtda pɨx: ―Aañ matgam biaꞌ ji nañ tuꞌ jugiaꞌ na pim aapiꞌm cham maat jiñ jaaduñ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Baꞌ miꞌ pu cham bhaaiꞌ nam jax ka tɨɨdaꞌ guiꞌ nam kaichuꞌ. Tɨim tɨ tɨkkaꞌ am dɨɨlh, jup kaiꞌch am: ―¿Jaroo baꞌ yaꞌ tu aichulh chi gu koiꞌ dhich jaduuñ ku baꞌ puiꞌ biaꞌ na tuꞌ jugiaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Guꞌ ji na guꞌx bhaiꞌ xi ja aagiꞌñ gu Jesuus, jup ja tɨtda: ―Matgam cham ji na tu bhioꞌmodaꞌ noꞌñ moo tuꞌ sɨlhkam soiꞌñ ɨlhiiꞌñ jaꞌp na jax aañ xib, nañ guꞌ cham paiꞌ iam pɨx am jix bhioꞌ, na guꞌ dai nañ tɨix jotma nañ ba tɨɨmoꞌ gɨt nat jax jiñ chɨɨdak bhañ joot guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Guꞌp kaiꞌchdhaꞌ am gu jaꞌtkam na maakob masaaꞌn kɨꞌn jir oꞌrabhak kaꞌ, guꞌ jaꞌpji pu xiib ji na yaꞌ bar bhaan, nat guꞌ dhiꞌx bhaiꞌ ba kabka. Gu jaꞌtkam jañ dho ja aagat jup kaiꞌch na bɨɨx ja aꞌm bam aaꞌ nam kaayaꞌ gu ñioꞌkiꞌñ gu Dios, cham tuꞌ gu tuꞌ na ya jaꞌp tɨm ɨs. ");
INSERT INTO stpNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na baꞌ guꞌ nam paiꞌ dhuuk ba tɨ jɨɨꞌñdhaꞌ aañ jiñ bui, noꞌ jaroiꞌ mu jaꞌp paiꞌ ba tu ja aꞌgidhim gu ñioꞌkiꞌñ guñ Gɨꞌkoraꞌ jiñ aꞌmkam, jix bhaiꞌ bhaiꞌ jim ɨlhdhaꞌ am, nam guꞌ bhaiꞌ ji machiaꞌ na ja aꞌm ba tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ na baꞌ miꞌ dhɨr cham tuꞌ ka ja tulhiiñchudaꞌ, dai na ba ja baidhikaꞌx dhaam jaꞌk. Gio gu jaroiꞌ na tu ja aꞌgiꞌñdhaꞌ, puiꞌx bhaiꞌp jum taat kaꞌ ja bɨɨm. Baꞌ dhiꞌ iam pɨx jaꞌp ji buusan na jax gu jaroiꞌ noꞌt gɇꞌ tɨ ɨi nax bhaiꞌm taat kaꞌ, gio jaiꞌ dhɨt noꞌm nɨiꞌñ nax bhaiꞌ tu kaibhaim, puiꞌx bhaiꞌp jum taat kaꞌ am, nam guꞌ jaiꞌ miꞌ ba tu bagiataꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Puiꞌ nam jax ba kaiꞌchdhaꞌ ɨp yaꞌ gu jaꞌtkam, na saak sia kut dɨɨlh miꞌ paiꞌ tɨ ɨi maadɨt, jaꞌp ji buusniaꞌ nam muiꞌ jaꞌtkam jup jum duñiaꞌ na paiꞌ dhuuk bhaiꞌ ji chu oraaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Baꞌ aañ xib jam guguuxiꞌñ jiñ jaaduñ na pim naiꞌ xi jimiaꞌ na pim tu ja aꞌgiꞌñpuꞌ gu jaꞌtkam mu jaꞌp nam paiꞌ tu ja aꞌgidhimɨk gu jaiꞌ bɨjɨk. Na guꞌm aaꞌ nam jaiꞌ naiꞌp xi jimiaꞌ nam ja guguuxdhaꞌ nam baꞌ pɨk moo ba tɨ jɨɨꞌñdhaꞌ aañ jiñ bui jɨꞌk nam jix aaꞌndaꞌ, na pim baꞌ puiꞌ ji bubuakiaꞌ na gu bagiatdam. ");
INSERT INTO stpNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Baꞌ jaiꞌ dhɨt gu jaꞌtkam mummu pu tɨ jɨɨꞌñ jamɨt buiñor gu Jesuus gu miꞌ oiꞌñkam Samaaria na ba ja aagiꞌñ gu ubii, nap ja tɨtda: “Giilhim bɨɨx jix bhaiꞌx maat nañ jɨꞌk jax jiñ buaꞌt oirɨdaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Baꞌ jaꞌxpɨx miꞌ ba ai mɨt na paiꞌp tuꞌiiꞌ gu Jesuus guiꞌ na mɨt mu tɨɨgim, baꞌp tɨtda am na sap miꞌ xi juruuñdhai ja bui. Gu Jesuus baꞌ miꞌp xi juruuñdhak gook tanoolh. ");
INSERT INTO stpNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jix ioꞌm muiꞌ ba tɨ jɨɨꞌñ jamɨt dho gi ji baꞌ buiñor nat bhaiꞌ ji chu ja aꞌgi, sia gu jaiꞌ bɨɨx ba tɨ jɨɨꞌñ jamɨt guiꞌ nam cham jɨɨgiꞌñdhat gu ubii na tɨi ja aagiꞌñ bɨɨpɨꞌ dɨr na jax tɨtda gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Baꞌp tɨtda am gu ubii: ―Xib jach dho gi ba tɨ jɨɨgiꞌñ ji nar dhiꞌ guch Xoiꞌkam na yaꞌ uañchudaꞌ guch uaꞌtulhdharaꞌ. Ku guꞌ cham tuꞌ ji na moo dai aap nap jup jich chɨtda na puiꞌx bhaiꞌx maat nap jax jum buadaꞌ, jaꞌpji na chich dɨɨlh ba kai na giilhim joidham xi bua na xi chu aꞌga. ");
INSERT INTO stpNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Miꞌ dhɨr baꞌ nat miꞌ xi juruuñdhak Samaaria gu Jesuus gook tanoolh, giop ba jii mu jaꞌk Galilea nat pa jaꞌk ba jii, ");
INSERT INTO stpNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","sia ku tɨix maat nam cham pɨk kɨɨgalhiꞌñ na jax ba kaiꞌch, nam saak cham jɨɨgiꞌñdhaꞌ gu jaroiꞌ noꞌm jir maap jum oiꞌdhagɨm, sia kux ja joiꞌndat tɨi ja aagiꞌñ gu ñioꞌkiꞌñ guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ku baꞌ guꞌ nat paiꞌ dhuuk mu ai Galilea, siamri pɨx jaꞌx jup ji chɨ jɨɨꞌn jamɨt ji gu miꞌ oiꞌñkam, cham tuꞌ na moo pu ni jɨꞌx, nam guꞌ bɨɨpɨꞌ dɨr pu ba nɨiꞌñ nam bhammɨ oipimɨk Jerusaleen nat jix bhaiꞌm duukam jup tu duu, na guꞌ ampɨk bɨɨx bhammɨp oilhimɨk gu Jesuus na bhaiꞌr piasta kat gu bhaan Paaskua taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Miꞌ dhɨr baꞌ moo naiꞌ jaꞌp bhɨi nammɨ jaꞌk Kanaa tɨ tɨɨgim na paiꞌ maaꞌn na jax Galilea bhaan bipioꞌ, nat paiꞌ bɨɨpɨꞌ dɨr biiñ jup duu gu suudaiꞌ. Baꞌx ioꞌm jaꞌpni jaꞌk mɨk na paiꞌ Kapernaum tɨ tɨɨꞌ, miꞌx kaꞌook gu maraaꞌn gu nobiiꞌñ gu gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Baꞌ puiꞌ ba tɨ kai gu nobiiꞌñ gu gɇꞌkam na gio miꞌp ba oirɨ gu Jesuus Galilea jaꞌk gɨɨsɨk mu dɨr jaꞌk Judea na xi oilhimɨk. Baꞌ muiꞌ ma jii nat gaagam miꞌ na paiꞌ oirɨ, miꞌ ji buusnɨk soiꞌ ba tɨtdaim na sap iam duaꞌñdharaꞌ gu maraaꞌn na ba muukim nax ioꞌm jix kaꞌook. ");
INSERT INTO stpNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Baꞌp tɨtda gu Jesuus: ―Jax dhui na pim cham jɨꞌxkat tɨ jɨɨꞌñdhaꞌ aañ jiñ bui noꞌñ cham jam nɨiꞌñchudat jup tu bua gu tuꞌ nar jix bhaiꞌm duukam. ");
INSERT INTO stpNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Baꞌ gu nobiiꞌñ gu gɇꞌkam jup tɨtda gu Jesuus na puiꞌ ka kaiꞌch: ―Gi noꞌ pich moom guguux jiñ jaduuñ nach muiꞌ xi jimɨi muñ kiꞌaam na cham ba mukiaꞌ guñ alhii chuk, na guꞌx ioꞌm ba xi bhɨichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Baꞌ gu Jesuus jup tɨtda: ―Bax kɨɨꞌ ji matgam gum alhii chuk jiñ jaduuñ. Jaꞌk jap ba gɨxiaꞌ cham jax jim aagɨt. Baꞌ guiꞌ pu jii ɨp nat jax pu tɨɨꞌn gu Jesuus, na guꞌx maat na sɨlhkam jup tɨtda, cham tuꞌ na pɨx jap kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Baꞌ buimgidhak na nammɨ ba jimchuꞌ na iam pɨx ba aajim mu kiaꞌmiꞌñ, miꞌ ba nam jamɨt gu dɨɨlh tujuandam tugiꞌñ, baꞌ miꞌ ba aagiꞌñ am nat ba dua gu maraaꞌn, jup tɨtda am: ―Bax kɨɨꞌ gum alhii chuk jiñ jaduuñ. ");
INSERT INTO stpNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Baꞌ guiꞌ xi ja tɨkka na paiꞌ dhuuk dɨr bax kɨɨꞌ, jup ja tɨtda: ―¿Paa duuk dɨr bax kɨɨꞌ? Baꞌ guiꞌp tɨtda am: ―Takaab dho mia duuk dɨr cham ka jɨbaamuk. ");
INSERT INTO stpNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Baꞌ xi chɨ tɨꞌñcho gu taataꞌn gu alhii, jir bhaiꞌ jaꞌp duuk na paiꞌ dhuuk jup tɨtda gu Jesuus: “Bax kɨɨꞌ ji matgam gum alhii chuk jiñ jaduuñ.” Baꞌ dai nat ba tɨ jɨɨꞌñ bɨɨx juraaꞌn kɨꞌn buiñor, gio gu jajaaꞌnniꞌñ dappaam jamɨt pu tɨ jɨɨꞌñ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Baꞌ dhiꞌ nat puiꞌ jɨꞌ tu duu gu Jesuus nat jaꞌk gɨɨsɨk miꞌ ba ai Galilea mu dɨr jaꞌk Judea na xi oilhimɨk, dhiꞌ kɨꞌn baꞌ bar gookim nat jix bhaiꞌm duukam jup tu duu. ");
INSERT INTO stpNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Baꞌ mɨkkat giop ma jii gu Jesuus bhammɨ jaꞌk Jerusaleen, nat guꞌ bam ai nam paiꞌ dhuuk tu piastat gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Baꞌ nat bhammɨ ba ai juꞌñdharan gu gɇꞌ kiicham na paiꞌ xikoolh tu kuup, moo bhaiꞌ dhɨr mu baakim nam paiꞌ Kakasnir tu Kiꞌñgobiꞌ kɨꞌn jix chu mat kaꞌ gu bhaiꞌ oiꞌñkam, miꞌ na paiꞌ dhɨr bar miaꞌn gama jaꞌk na paiꞌ suuꞌnkaꞌ gu suudaiꞌ nam ebreo ñiꞌook kɨꞌn Betesda tɨ tɨɨtɨꞌndaꞌ, mu na paiꞌ joidham bɨɨx xikoolh dhɨr tɨ ɨkgidhix kaꞌ nax bhaaiꞌ nam miꞌm jɨppiꞌñdhaꞌ gu jaꞌtkam noꞌm mi jaꞌp oipo. ");
INSERT INTO stpNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Baꞌ gu Jesuus jimdat miꞌ pɨx ji ja tɨɨ muiꞌ gu cham ñiññia kam, jaiꞌx mamaꞌmkulhiꞌ gam jaiꞌ guiꞌ nam jix xosoꞌsolhik kaꞌ nam dɨkoo pɨx tu oipodaꞌ. Bɨɨx aixim tuꞌm kɨꞌn jix kakoꞌk kat mi jaꞌp pɨx jaꞌx boobok am nam sap miꞌ nɨɨra na guꞌngukiaꞌ gu suudaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Na guꞌ paiꞌ jɨꞌ guꞌngukdaꞌ na sap miꞌ tɨmiikdaꞌ gu nobiiꞌñ guch Gɨꞌkoraꞌ, na sap baꞌ gu jaroiꞌ na bɨɨpɨꞌ mi bakiaꞌ na ka guꞌngukdaꞌ, pu dodhiaꞌ gu jax chuꞌm koꞌkdaiꞌ na kɨꞌn kax kaꞌook kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Baꞌ maaꞌn mi jaꞌp jup boꞌ gu maaꞌnkam na iam pɨx gook ooꞌm oidhaꞌ ba aichdhim na dɨr bax kaꞌook, gook oidhaꞌ pɨx bam aagɨt na ba aichdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Baꞌx joiꞌndak tɨɨ gu Jesuus na miꞌ soiꞌ tuꞌiiꞌ, na guꞌx maat nat muiꞌ oidhaꞌ bap duu na dɨr bax kaꞌook. Baꞌp tɨtda: ―¿Tɨi aap jix dhuadhim jiñ jaduuñ? ");
INSERT INTO stpNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Baꞌ gux koꞌkkam bhaiꞌ ji ñio, jup kaiꞌch: ―Tɨi dho, guꞌ ji na guꞌ cham jaroiꞌ jaiꞌch kaꞌ nañ gɨt iam ba umuaꞌñdhaꞌ na muñ baasaꞌ suudaiꞌ chɨr na paiꞌ dhuuk bhaiꞌ ji guꞌngukiaꞌ, na guꞌ jumai bɨɨpɨꞌ miꞌ ba bakiaꞌ nañ aañ kiaꞌpɨx yaꞌ dɨr mu ji jimiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Baꞌ gu Jesuus jup tɨtda: ―Dho xib baꞌ bi bamiiꞌñ jaduuñ. Muni paꞌp ba oirɨdaꞌ tu uꞌji dhim bapakxidharaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Baꞌx kɨɨꞌ bhaiꞌ ji bam gux koꞌkkam nat jax pu tɨɨꞌn gu Jesuus, tu baapmiꞌñdhak gu bapakxidharuꞌn mu jaꞌp xi oirɨ. Guꞌ ji na guꞌ moo janoꞌ pɨk cham jup tum juandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Baꞌ pu ñiok jamɨt gu gɇꞌgɇrkam Israel kam guiꞌ nat duaꞌñ gu Jesuus na mɨt ba tɨɨ na mi jaꞌp ba jimchuꞌ tu uaꞌdat gu bapakxidharuꞌn, jup tɨtda am: ―¿Jax kup baꞌ yaꞌ pu tu duiñchuꞌ dhim bapakxidharaꞌ? ¿Kup jix cham maat aa na xib cham tum juan? Jix maat ap na puiꞌ tu daaxix na saak cham jaroiꞌ tu baapmigiꞌñdhaꞌ sia gu tuꞌ palhɨɨp jup jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Baꞌ gu maaꞌnkam jup ja tɨtda: ―Jax dhui na cham paiꞌ jax jiñ chɨtda guiꞌ nat jiñ dhuaꞌñ noꞌ tuꞌp jix xidhuu xib na saak cham tum juan. Dai nap jiñ chɨtda: “Munip jaꞌp ba oirɨdaꞌ tu uꞌji dhim bapakxidharaꞌñ jaduuñ.” ");
INSERT INTO stpNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Baꞌ bhaakuk jix bhaiꞌ bhaiꞌ ji chɨkka mɨt, jup tɨtda am: ―¿Jaroo baꞌ daꞌ gu jaroiꞌ na puiꞌm tɨtda nap puiꞌ mu jaꞌp ba oirɨdaꞌ tu uꞌji gum bapakxidharaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Guꞌ ji na guꞌ cham maat gu maaꞌnkam noꞌp jir diꞌ gu Jesuus nat duaꞌñ. Miꞌ pu cham bhaaiꞌ na jax dhuuji ja aagiꞌñdhaꞌ nam tɨix bhaiꞌ bhaiꞌ ba tɨkka, nat guꞌ mɨjɨ jaꞌp paiꞌ ji dhuu gu Jesuus nat jax xi dhuaꞌñdhak. Pu cham maatɨꞌ guꞌ na pa jaꞌk oirɨ, na guꞌ muiꞌ mi jaꞌp tum oipo. ");
INSERT INTO stpNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mɨkkat ji na mɨt baꞌ giop bam tɨtgɨ bhammɨ jaꞌk gɇꞌ chiop na baꞌp tɨtda gu Jesuus: ―Xib jap moo tuꞌ kaꞌm xi chɨ nɨidhat jiñ jaduuñ na pich kapbhaiꞌ ba dua, na baꞌ cham gio tuꞌp bam duñiaꞌ jix ioꞌm jix buam jum duukam noꞌr maaꞌn nap jax jum uaꞌtulhiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Miꞌ ji nat baꞌ ampɨx maat gu maaꞌnkam nar diꞌ gu Jesuus guiꞌ nat duaꞌñ, miꞌ dhɨr dho guꞌ dai nat ba ja aaꞌñdham gu gɇꞌgɇrkam Israel kam. ");
INSERT INTO stpNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Baꞌ guiꞌx bhaiꞌ pɨx jup jum ɨlh jamɨt na ba ja aagiꞌñ, dai dho guꞌ nam bax chu chianik nam muꞌaaꞌ. Jotmodaꞌ naiꞌ xi jii mɨt mɨjɨ jaꞌp na mɨt gaagam na pa jaꞌk oirɨ. Baꞌ nammɨ gama jaꞌk ji chɨɨgɨk ba tɨkka am na sap jax kut baꞌ duaꞌñ gu maaꞌnkam, na guꞌx maat na janoꞌ cham tum juan. ");
INSERT INTO stpNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Baꞌ gu Jesuus jup tɨtda: ―Dho na guꞌ guñ Gɨꞌkoraꞌ cham paiꞌ dhuuk daaxix na cham tuꞌ jax bua noꞌ moo jaꞌp xi chum aagaim jaꞌp na jax xib. Baꞌ aañ puꞌñi ɨp, cham jiñ jɨɨpiꞌñ iñ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Baꞌ giilhim jix ioꞌm bhaak jamɨt nat puiꞌ xi ja tɨɨꞌn, aaꞌndaꞌ gɨt nam ba tu chiñiaꞌ nam muꞌaaꞌ. Nam guꞌ jaꞌp jum aaꞌ na dɨɨlh pɨx gɇꞌkam jum taatɨt cham tuꞌ kaꞌm nɨiꞌñ na paiꞌ dhuuk cham tum juandaꞌ, nam guꞌ cham tɨ jɨɨgiꞌñ na jaꞌxbuiꞌp jir gɇꞌkam na gu Dios ku baꞌ puiꞌ iim nar Gɨꞌkorgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Baꞌp ja tɨtda gu Jesuus: ―Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌñ jaaduñ, ni jɨꞌx kur puiꞌ iam na pim jax jum aaꞌ. Na guꞌ aañ cham tuꞌp tu bua gu tuꞌ nar jix bhaiꞌm duukam gu aañ dɨɨlh pɨx, sia kuñ jir maraaꞌn gu Dios, guꞌ ji noꞌt puiꞌ ba tɨi guñ Gɨꞌkoraꞌ nañ tuꞌ jax duñiaꞌ nañ baꞌ aañ miꞌ dhɨr puiꞌp tu duñiaꞌ bhaankamuꞌn. Na guꞌ bɨɨx na jɨꞌk tuꞌ jax buadaꞌ guñ Gɨꞌkoraꞌ, aañ miꞌ dhɨr bhaankamuꞌn puiꞌp tu duñiidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ka gɨt na pim guꞌ ka tɨgiaꞌ palhɨɨp gama jaꞌk iam na pim tuꞌ cham paiꞌ nɨiꞌñ, na guꞌ kap tu duñiaꞌ guñ Gɨꞌkoraꞌ bhaan jim uaꞌrgidhai aañ jiñ bui, na guꞌ giilhim xiñ kɨɨgalhiꞌñ. Miꞌ pim dho puiꞌ pup tuiꞌkaꞌ noꞌ pimɨt ba tɨɨ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jaꞌp na jax gu koiꞌñgaꞌn na guꞌ ja duduaꞌñdhat ja baapmigiꞌñ guñ Gɨꞌkoraꞌ na baꞌ miꞌ dhɨr ba ja baidhikaꞌx dhaam, baꞌ aañ xib puꞌñi ɨp, ja duduaꞌñdhat jañ dho ja baapmigiꞌñ gu koiꞌñgaꞌn nañ baꞌ miꞌ dhɨr ba ja baidhikaꞌ ɨp. ");
INSERT INTO stpNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na guꞌ aañ pɨx bhaankamuꞌn yaꞌ ja mattudaꞌ gu jaꞌtkam nam jɨꞌk miꞌ puiꞌ jiimdaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ, gio nam jɨꞌk cham miꞌ puiꞌ jiimdaꞌ, cham tuꞌ guiꞌ dɨɨlh. ");
INSERT INTO stpNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Dhiꞌ baꞌ bhaan jix maatɨꞌ kaꞌ nañ jaꞌxbuiꞌp jir gɇꞌkam na guñ Gɨꞌkoraꞌ nam baꞌ puꞌñi dhuuji tuꞌ kaꞌm jiñ ñɨiꞌñdhaꞌ gu jaꞌtkam. Baꞌ gu jaroiꞌ noꞌ cham tuꞌ kaꞌm jiñ ñɨiꞌñ, bɨɨx guñ Gɨꞌkoraꞌ nat bhañ joot cham tuꞌ kaꞌm nɨiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌ, gu jaroiꞌ nax maatɨt jiñ kɇɇ nañ jax kaiꞌñkam jup kaiꞌch, jir am na miꞌ puiꞌ ba jimiaꞌ gio na ba tɨ jɨɨꞌñdhaꞌ buiñor guiꞌ nat bhañ joot, na baꞌ gammɨjɨ bhaan ba tɨ nɨidhidhaꞌ, na baꞌ miꞌ dhɨr cham ka tulhiiñchudaꞌ, dai na ba baidhikaꞌ jix dhaam jaꞌk. Na guꞌ noꞌt puꞌñi ba tɨ jɨɨꞌñ gu jaroiꞌ, cham jɨꞌxdhaꞌ ka mukiaꞌ gu iiꞌmdagaram bhaan, na guꞌx chu maax kɨr bap tuiꞌñgɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌ aañ nañ jir maraaꞌn gu Dios, kam aayaꞌ nam paiꞌ dhuuk maaxik jiñ chɨɨgɨi kañ kaayaꞌ gu jaꞌtkam, guiꞌ nam jaꞌp ji buusan nam koꞌiix, nam jix chukgam kɨr jup tuꞌiiꞌ. Pu xib dho guꞌ yaꞌ bam ai, cham tuꞌ na paiꞌ dhuuk. Tɨɨꞌ nat guꞌ pɨx ya jaꞌp jim tɨi. Baꞌ guiꞌ nam jiñ kɇɇji miꞌ puiꞌ ba jimiaꞌ, gammɨjɨ pu ba duduakaꞌ am gu ja iꞌiiꞌmdaꞌ am bhaan, ");
INSERT INTO stpNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","na guꞌ guñ Gɨꞌkoraꞌ ja tajaañiꞌñ gu iiꞌmdaꞌ na jax chuꞌm ɨlhiiꞌñdhaꞌ nam baꞌ kɨꞌn duduakaꞌ. Aañ baꞌ bhaankamuꞌn jix chu maax kɨr jaꞌk ja boosoꞌ nam baꞌ gammɨjɨ miꞌ bap tuiꞌñgɨdaꞌ na paiꞌ cham ka tu muukiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na guꞌ bɨɨx jiñ aꞌm jup tu tuꞌiiꞌ na pim tuꞌ cham ɨlhiiꞌñ, pu kaiꞌñkam bhañ joot guñ Gɨꞌkoraꞌ nañ bhaankamuꞌn yaꞌ ja mattudaꞌ gu jaꞌtkam na jɨꞌk cham ka ja tulhiiñchudaꞌ, dai na ba ja baidhikaꞌx dhaam jaꞌk, gio guiꞌ na jɨꞌk pu gammɨjɨ ba ja tulhiiñchudaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","¿Jax ku pim baꞌ miꞌ puiꞌ pup tuꞌiiꞌ? ¿Giilhim jix xijai aa panaas gu puiꞌ nañ jax kaiꞌch? Matgam kam aajim ji nam paiꞌ dhuuk bɨɨx jiñ chɨɨgɨi kañ kaayaꞌ gu koiꞌñgaꞌn mu jaꞌp nam jax yassap nat jɨꞌk bam jaꞌbsu gu ja tutkuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nañ guꞌ ka ja baapmiꞌñdhaꞌ nañ baꞌ moo ba ja aagiꞌñdhaꞌ na mɨt jɨꞌk miꞌ puiꞌ jii na jax jix aaꞌ guñ Gɨꞌkoraꞌ nañ baꞌ cham ka ja tulhiiñchudaꞌ, dai nañ ba ja baidhikaꞌ na paiꞌ cham ka tu muukiꞌ. Guꞌ baꞌ guiꞌ na mɨt jɨꞌk cham tuꞌ kaꞌm tɨɨ guñ Gɨꞌkoraꞌ, pɨx am tɨꞌñchokaꞌ am nañ ja jootsaꞌ mu nam paiꞌ miꞌ pup jum tulhiiñdhaꞌ gammɨjɨ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jaꞌpni baꞌ moop ja tɨtda gu Jesuus: ―Aañ pɨx bhaankamuꞌn guñ Gɨꞌkoraꞌ yaꞌ ja mattudaꞌ gu jaꞌtkam nam jɨꞌk miꞌ puiꞌ jiim na jax jix aaꞌ, gio nam jɨꞌk cham miꞌ puiꞌ jiim. Ku guꞌ cham tuꞌ aañ dɨɨlh ji nañ jax ɨlhiiꞌñdhaꞌ, guꞌ jaꞌpji dai na jax jiñ chɨɨdaidhaꞌ pɨx guiꞌ nat bhañ joot. Dhiꞌ baꞌ bhaan jix maatɨꞌ kaꞌ nar sɨlhkam nañ jax tu aꞌga, ");
INSERT INTO stpNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","na guꞌ tuꞌ gi kuñ bap tu aꞌgadaꞌ gɨt noꞌñ cham bhaankamuꞌn tu aꞌgadaꞌ gɨt guñ Gɨꞌkoraꞌ, na guꞌr iatdaꞌ kaꞌ gɨt pɨx jia. ");
INSERT INTO stpNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Jaꞌpji na guꞌx maatɨꞌ nar sɨlhkam nañ jax tu aꞌga, na guꞌ guiꞌ nat bhañ joot puiꞌp jam mattuꞌn. ¿Cham aa dhiꞌ kat bap jum kaiꞌch? ");
INSERT INTO stpNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Na guꞌ janoꞌ na pimɨt mu tu joot nam tɨkkapuꞌ gu Juan nar tuꞌp tuꞌm daꞌ, jir sɨlhkam nap kaiꞌch na bar miaꞌn nañ bha jim bhaankamuꞌn guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ku guꞌ aañ cham tuꞌñ aꞌm jum aaꞌ ji nañ aꞌmkamuꞌn ñiokdaꞌ gu jaroiꞌ yaꞌ kam dhi oiꞌñgaꞌn. Guꞌ ji na pim guꞌ aapiꞌm cham maat nañ jir gɇꞌkam, guꞌ baꞌm aaꞌ na jaroiꞌ jam mattudaꞌ na pim baꞌx chu maax kɨr bap tuiꞌñgɨdaꞌ, na guꞌ ba uañchudhix kaꞌ gu jam uaꞌtulhdharaꞌ noꞌ pim jix aaꞌndaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jaꞌp na gu Juan nax chu maax kɨr jup tuiꞌñgɨt janoꞌ nat paiꞌ dhuuk ya jaꞌp tu mattudak nañ jir gɇꞌkam, na guꞌ jaꞌp ji buusandaꞌ na gammɨjɨ tɨ bɨꞌñdhatgɨdaꞌ, puiꞌ nam baꞌ bɨɨx pɨx joidham kɇɇkɇt na jax tu aꞌgimɨk. ");
INSERT INTO stpNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ku guꞌ cham tuꞌ ji na dai dhiꞌ bhaan jix maatɨꞌ na jax tu aꞌgimɨk gu Juan, matgam japim ji ba nɨiꞌñ ji nañ jup tu bua na tuꞌr jix bhaiꞌm duukam nat jax jiñ chɨɨdak bhañ joot guñ Gɨꞌkoraꞌ. ¿Cham aa dhiꞌ sɨlhkam kat bap jum kaiꞌch? ");
INSERT INTO stpNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Gio na guꞌ guñ Gɨꞌkoraꞌ nat bhañ joot, tɨi pu jam mattuꞌnkaꞌ ɨp nañ aañ jaꞌxbuiꞌp jir gɇꞌkam, sia ku guꞌ cham tuꞌ moo gu maaxik na yaꞌ paiꞌ jimdat ba tu jam aꞌgidhim, na guꞌ giilhim jir jix uañ, pu cham maax guꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Dai gu uꞌuan taꞌm na bhaan jim uaꞌrgidhat tɨi jam aagiꞌñ na pim jax jaꞌk tuiꞌñgɨdaꞌ. Guꞌ ji na pim guꞌ aapiꞌm jaꞌp xi dhuukat gu ñioꞌkiꞌñ na pim guꞌ cham bɨɨx jam jujur kɨꞌn tɨ jɨɨgiꞌñ buiñor. Jaꞌpni dhuukat japim baꞌ puiꞌ cham jup tɨ jɨɨgiꞌñ nat guiꞌ bhañ joot, ");
INSERT INTO stpNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","sia ku tɨir maaꞌn na pim tu jiñkuiꞌñdhaꞌ gu ñioꞌkiꞌñ guñ Gɨꞌkoraꞌ na pim sap pɨk baꞌ tɨix maachik na jax jaꞌk gammɨjɨ jam aꞌm tɨ nɨidhidhaꞌ. Matgam gɇɇꞌ jam aꞌm kam aaꞌ ji na pim baꞌx bhaiꞌ ba machiaꞌ. Tɨɨꞌ na pim guꞌ chakui maatɨt kɇɇ na aañ jiñ aagɨt jup kaiꞌch mi uꞌuan taꞌm na tu uaꞌñix, ");
INSERT INTO stpNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","puiꞌ ku pim baꞌ cham aaꞌ na pim jɨɨꞌñdhaꞌ aañ jiñ bui. Guꞌ noꞌ pim tɨ jɨɨgiꞌñdhaꞌ gɨt, aañ dho jam aagiꞌñdhaꞌ gɨt na jax jaꞌk jix bhaaiꞌ na pim duñiaꞌ na baꞌ gammɨjɨ jam aꞌm ba tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Ku guꞌ aañ cham tuꞌ ji nañ jix aagɨt puiꞌ jam tɨtda na pim puiꞌñ chɨɨtɨꞌn nañ jir gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nañ guꞌx maat na pim jax jir tuutuꞌm, pu cham tuꞌ kaꞌm nɨiꞌñ japim gu Dios. ");
INSERT INTO stpNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Guꞌ aapiꞌm guꞌ iatdaꞌ ji na pim joidham ɨlhiiꞌñ noꞌ jaroiꞌ ya jaꞌp paiꞌ ba tu aꞌgim dɨɨlh pɨx na jax ɨlhiiꞌñdhaꞌ, guꞌ baꞌ gu jaroiꞌ noꞌ tɨi sɨlhkam xi chu aꞌga, gampaiꞌ pɨx biaꞌkaꞌ pim. Jaꞌp na jax aañ xib nañ bhaankamuꞌn ya jaꞌp tɨi ba tu aꞌga guñ Gɨꞌkoraꞌ, tuꞌ pɨx jiñ ɨlhiiꞌñ japim jam jaaxmakar. ");
INSERT INTO stpNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jaꞌp jum aaꞌ pim na pim tuꞌ pɨk mi chɨgiaꞌ na pim dɨɨlh xi chu aꞌgat na pim jax ɨlhiiꞌñdhaꞌ, guꞌ baꞌ na jax jix aaꞌ gu Dios jaꞌp xi dhuukat japim, panaas ku pu cham tuꞌ bhaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ku baꞌ guꞌ kam aayaꞌ ji na paiꞌ dhuuk jam tulhiiñchudaꞌ guñ Gɨꞌkoraꞌ, na guꞌ ka matgilhiaꞌ na pim cham tuꞌ kaꞌm nɨiꞌñ, na guꞌ ka aagiꞌñdhaꞌ gu Moisees na pim cham tuꞌ miꞌ puiꞌ jiimchuꞌ nat jax tu uaꞌnak. Sia kuñ guꞌ aañ tɨi cham aagiꞌñ, guiꞌ dho gi guꞌx bhaiꞌ aagiꞌñdhaꞌ ji. Gu xib puiꞌm aaꞌ pim na pim panaas miꞌ puiꞌ tu daaꞌñchuꞌ nat jax tu uaꞌnak. Chaam tuꞌr puiꞌ ji matgam. ");
INSERT INTO stpNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Guꞌ noꞌ pim miꞌ puiꞌ jiimdaꞌ gɨt nat jax tu uaꞌnak, ba tɨ jɨɨꞌñdhaꞌ pim gɨt ji aañ jiñ bui cham jax ji chɨꞌji. Na guꞌ gu Moisees aañ jiñ aagɨt jup kaiꞌch mi uꞌuan taꞌm nat tu uaꞌnak na saak puꞌñi jumai bha jimdaꞌ nax ioꞌm jir gɇꞌkam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Guꞌ ji na pim guꞌ jaꞌp xi dhuukat nat jax tu uaꞌnak, puiꞌ ku pim baꞌ cham tɨ jɨɨgiꞌñ nañ jax tɨi tu jam aꞌgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Baꞌ gatuuk na puiꞌ jɨꞌ xi chu aꞌgimɨk gu Jesuus, ma jii baasɨꞌn dɨr jaꞌk nam paiꞌ gook kɨꞌn jix chu mat kaꞌ, suudaiꞌ gɇꞌ suuꞌn na Galilea bhaan bipioꞌ, gio baꞌ suudaiꞌ gɇꞌ suuꞌn na Tibeeriyas bhaan bipioꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Baꞌ muiꞌ jaꞌtkam mu oiꞌñchuꞌ am, nam guꞌ bɨɨpɨꞌ dɨr ba nɨiꞌñ nax bhaiꞌ tu bua na tuꞌr jix bhaiꞌm duukam, puiꞌ na jax gux kakoꞌkkam na ja duduadhiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Baꞌ gu Jesuus jimɨɨk bhammɨ jim jɨɨp oidhaꞌ juraab na paiꞌx kotboraꞌ ja bɨɨm guiꞌ nam kaichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Baꞌ moo janoꞌ pɨk jup bar miaꞌn bhaan Paaskua taꞌm nam paiꞌ dhuuk tu piastat gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Baꞌ muiꞌ pɨx jax ji ai mɨt gu jaꞌtkam nat ba ja tɨɨ gu Jesuus guiꞌ nam gatuuk dɨr mu jiimchuꞌ. Baꞌ gu Jesuus xi chɨkka gu Piliip, jup tɨtda: ―¿Jax jach baꞌ dui tu ja makiaꞌ dhi jaꞌtkam? ¿Tuꞌch kɨꞌn tu sabaꞌdaꞌ gu koiꞌ nach ja makiaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ku guꞌ pɨx jap tɨtda ji, ea jax pɨk sap tɨꞌyaꞌ, na guꞌ pux maat gu Jesuus na jax dhui tu ja makiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Baꞌp kaiꞌch gu Piliip: ―Dho pu ni jax dhui dho, nach guꞌ cham muiꞌ uaꞌ gu tuumiñ. ¿Tuꞌch gi kɨꞌn jup tu sabaꞌdaꞌ gu koiꞌ? Sia ku chich chi moo tɨi ma chu jua jɨꞌk xijum baik masaaꞌn, pu cham dho ja aix gu koiꞌ, sia ñich chi bɨɨx kaꞌm tu sabaꞌlh nañ jɨꞌk maiꞌchiaꞌ gu tuumiñ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Baꞌ gu jumai miꞌ dhɨr jaꞌp bhaiꞌp ji ñio Anrees tɨɨgim, na puiꞌp jir nobiiꞌñ gu Jesuus, nar sɨpdhiꞌñ gu Simoon Peegro, jup kaiꞌch ɨp: ");
INSERT INTO stpNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Muni tɨi uaꞌ ji maaꞌn gu alhii jix chamaam gu paan gio gook gu boptop. ¿Tuꞌ gip ja aix, nam guꞌ giilhim jir muiꞌ dhi jaaduñ? ");
INSERT INTO stpNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Baꞌ gu Jesuus jup ja tɨtda: ―Ea na pim xi ja chiñiaꞌ nam bɨɨx xi dharaibuꞌ. Baꞌ guiꞌ xi ja chia mɨt ɨp. Baꞌ pɨx mi jaꞌp jup ji dharaibu mɨt saiꞌ dhaam gu jaꞌtkam, na guꞌ jaꞌp moo joidham jup jix xaꞌiiꞌ kaꞌ bhaiꞌ. Alh moo siamrir muiꞌ am dho baꞌ ji gu jaꞌtkam, jix chamaam mambhɨɨx jix chaꞌtman ooꞌm (5000) aix am dai gu chichioꞌñ, gu uꞌuub guꞌ cham daaxix kam ji gam aꞌaalh. ");
INSERT INTO stpNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Baꞌ gu Jesuus nat jax daa gu paan xi chu taxchaabgidhak jix dhaam jaꞌk pɨx muiꞌ ji ja maa gu noonbiꞌñ. Baꞌ guiꞌ miꞌ dhɨr pɨx naiꞌp ji ja maa mɨt gu jaꞌtkam nam mi jaꞌp pɨx jaꞌx dharaa. Gio miꞌ dhɨr gu boptop bɨɨx pɨx muiꞌp ji ja maa mɨt. Bɨɨx jam tu koiꞌmɨk nam jɨꞌx ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Baꞌ jaꞌxpɨx na xi ja nɨiꞌñ gu Jesuus nam jaiꞌ mi jaꞌp cham ka jugiokkar na mɨt xiꞌ ba kakoob, jup ja tɨtda gu noonbiꞌñ: ―Jumpadaꞌ pim gu taꞌtak na mɨt cham jugio jaiꞌ dhɨt mɨjɨ jaꞌp, na cham tuꞌ kub miꞌ maiꞌ gɨxiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Baꞌ guiꞌp ma chu jumaap jamɨt, mambhɨɨx daman gook bapaalh jamɨt ja susduiꞌ gu taꞌtak. Giilhim muiꞌp jum duu gux chamaan gu paan gio gu gook gu boptop. ");
INSERT INTO stpNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Baꞌ gu jaꞌtkam na mɨt tɨɨ nat puiꞌ jɨꞌ tu duu gu Jesuus, jup kaiꞌch am: ―Dhiꞌ ji bak jir diꞌ guiꞌ na saak bha jimdaꞌ na yaꞌ bhaankamuꞌn tu aꞌgaꞌ guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bɨɨx aixim ba ji chɨi mɨt, jup kaiꞌch am na sap jir am nam gɇꞌkam kɨꞌn daasaꞌ sia ku cham aaꞌ. Guꞌ ji na guꞌx maat gu Jesuus nam jax kaiꞌch, baꞌ pu jii cham ji ja aaꞌñdhak baasɨꞌn jaꞌk jix ioꞌm oidhaꞌ daam na paiꞌ cham jaroiꞌ oirɨ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Baꞌ jaꞌxpɨx nat paiꞌ ba ji dhɨdɨmpu, ba jii mɨt gu noonbiꞌñ gu Jesuus bhaiꞌ dhɨr oidhaꞌ juraab na paiꞌx kotboraꞌ. Mummu mɨt ba juur na paiꞌ gɇꞌ suuꞌn gu suudaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Miꞌ dhɨr na mɨt jax bha tɨɨtɨs kanuub taꞌm, gamaiꞌ pu bhɨi mɨt bɨɨx suudaiꞌ dhaam sɨlh baasɨꞌn dɨr jaꞌk Kapernaum. Jix ioꞌm bax chukgam ji guꞌ. Gu Jesuus pui bhammɨ paiꞌ pɨx maiꞌch, cham paiꞌ joiñ baꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Baꞌ na mɨt nammɨ gama jaꞌk ba ji bhɨi, giilhim jix ioꞌm bhaiꞌ ji jɨb, bhaiꞌ ji guꞌngukɨ gu suudaiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jix ioꞌm gama jaꞌk ɨrban pɨx iam na mɨt ba ji bhɨi nam paiꞌ cham pum aaꞌ, ba tɨɨ mɨt gu Jesuus na joidham bɨɨx suudaiꞌ dhaam pɨx tuꞌ tuiꞌdhiꞌ na muiꞌ ba jim, amuub ba ji bhɨi miꞌ nam paiꞌ jiimchuꞌ. Guiꞌ giilhim bhaiꞌ ji chootoꞌn jamɨt, ");
INSERT INTO stpNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","guꞌ ji nat guꞌ jotmodaꞌ mu ñio gu Jesuus, jup ja tɨtda: ―¡Chaꞌpim totdon kaꞌ! Aañiꞌ pɨx jup tuiꞌdhiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Baꞌ gu noonbiꞌñ jix bhaiꞌm ɨlhdhak jup tɨtda am na bhaiꞌ xi chɨsdiaꞌ kanuub taꞌm. Baꞌ gu Jesuus bhaiꞌp xi chɨs, jotmodaꞌ mɨt pu baasɨꞌn dɨr ai cham jum ɨlhdham. ");
INSERT INTO stpNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Baꞌ buimgidhak bhammɨ dɨr tɨi nɨɨra am gu Jesuus gu jaꞌtkam guiꞌ na mɨt bhammɨ dɨr pup bii baasɨꞌn dɨr, nam guꞌ ja nɨiꞌñ na mɨt dɨɨlh bhɨjɨ jaꞌk ji dhuu gu noonbiꞌñ, cham tuꞌ bɨɨx bha tɨs kanuub taꞌm gu Jesuus guiꞌ na mɨt bhaan bha jii. Baꞌ cham ɨlhiiꞌñ am noꞌt gatuuk dɨr dɨɨlh bha jii, nam guꞌ daipuꞌ maaꞌn miꞌ ka nɨidhat na sɇꞌ suudaiꞌ dhaam gu kanuub. ");
INSERT INTO stpNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Baꞌ moo ampɨk jaiꞌ gama jaꞌk jup ba ai mɨt gu jaꞌtkam kaknub taꞌm nam mu dɨr jaꞌk jiim Tibeeriyas, nar miaꞌn bhaiꞌ dhɨr oidhaꞌ juraab na paiꞌx kotboraꞌ, nat paiꞌ xi chu taxchaabgidhak gu Jesuus nat tu ja maa gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Guꞌ baꞌ na guꞌ cham paiꞌ aajim gu Jesuus nam tɨi nɨɨra, ni gu noonbiꞌñ kum cham paiꞌ joiñ nam mu namkipuꞌ, baꞌ na mɨt jax bha tɨɨtɨs kaknub taꞌm, pu jii mɨt bhammɨ dɨr jaꞌk Kapernaum na mɨt ba gaagam. ");
INSERT INTO stpNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Baꞌ na mɨt jax bhammɨ dɨr tɨɨtɨs baasɨꞌn dɨr gu jaꞌtkam, bhaiꞌ pɨx jaꞌp ji chɨɨ mɨt gu Jesuus, baꞌp tɨtda am: ―¿Paa pich dhuuk yammɨ dɨr jaꞌk tɨs jiñ jaduuñ? Aach bhammɨ dɨr tɨim nɨɨraimɨk. ");
INSERT INTO stpNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Baꞌp ja tɨtda gu Jesuus: ―Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌ na pim jax kaiꞌñkam jiñ gaagim jiñ jaaduñ, na pim giop bax bhioꞌ dho. Guꞌ ni jɨꞌx ji ku pim xim gaꞌnga na jax jir jum duukam nañ baꞌ bɨxchuꞌx aichuꞌn nañ pu tu duñiaꞌ na tuꞌr jix bhaiꞌm duukam, noꞌñ jaxjɨ gɇꞌkam kat baꞌ puiꞌ tu bua, kaꞌ baꞌ guꞌ cham. ");
INSERT INTO stpNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Moo pim cham gam ɨrdat oipodaꞌñ jaaduñ. Xim gaꞌngadaꞌ pim na pim jax jaꞌk duuji biaꞌkaꞌ gu koiꞌ na cham tu juꞌngɨ, cham tuꞌ na pim dai bhaan tɨtɨɨꞌñchokaꞌ gu koiꞌ na ampɨx tu juꞌngɨ na kɨꞌn jum guguuxiꞌñ dhi jam tutkuꞌ. Guꞌ jaꞌpji na pim xim gaꞌngadaꞌ ji na jax jaꞌk gammɨjɨ jam aꞌm ba tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ na pim baꞌ ba biaꞌkaꞌ gu koiꞌ guiꞌ na cham tu juꞌngɨ. Aañiꞌ dho tu maak noꞌ jaroiꞌ soiꞌm ɨlhdhat jiñ chaan, nat guꞌ puiꞌñ chɨɨdak bhañ joot guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Baꞌ bhaiꞌ ji chɨkka mɨt, jup tɨtda am: ―¿Jax gi jaꞌk jix bhaaiꞌ nach dhuuji miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ gu Dios? ");
INSERT INTO stpNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Baꞌp ja tɨtda gu Jesuus: ―Dho dai na pim bɨɨx jam jujur kɨꞌn tɨ jɨɨgiꞌñdhaꞌ aañ jiñ bui nar sɨlhkam nat guiꞌ bhañ joot. ");
INSERT INTO stpNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Baꞌp tɨtda am ɨp gio: ―Dho ea nap maaꞌn jup duñiaꞌ gu tuꞌ nar jix bhaiꞌm duukam jich ñɨiꞌñchudat nach tuꞌ cham paiꞌ nɨiꞌñ, nach baꞌ tɨ jɨɨgiꞌñdhaꞌ aap jum bui noꞌ baabuiꞌr sɨlhkam nap jax kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jaꞌp na jax jum kaiꞌch mi uꞌuan taꞌm nat tu uaꞌnak gu Moisees na saak mu paiꞌ oirɨt gampɨx ja bɨɨm gu jaiꞌch bopxikat nabap tanoolh ja maakdaꞌ gux dhaam kam gu koiꞌ guiꞌ na saak manaa tɨɨꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Baꞌp ja tɨtda gu Jesuus: ―Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌ, matgam dhiꞌ alh jaꞌp moo pu cham jum aꞌga ji na pim aapiꞌm tuꞌ aaꞌ. Na guꞌ cham tuꞌ dɨɨlh gu Moisees na ja maakdaꞌ gux dhaam kam gu koiꞌ, guñ Gɨꞌkoraꞌ ji na ja maakdaꞌ, ku guꞌr maaꞌn ji na jax juꞌngɨdaꞌ. Guꞌ matgam dhiꞌ nañ aañ xib yaꞌ aaꞌ nañ jax chuꞌm tu maak bhaankamuꞌn guñ Gɨꞌkoraꞌ, jir jix kɨɨꞌ koiꞌ ji na pu cham tu juꞌngɨ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Baꞌ gu koiꞌ na Dios tu maak, jir bhammɨ kam jix dhaam. Aañ baꞌ yaꞌ ja mattudaꞌ gu jaꞌtkam na jax jaꞌk jix bhaaiꞌ nam duñiaꞌ na baꞌ ja makiaꞌ gu Dios gux dhaam kam gu koiꞌ guiꞌ nam kɨꞌn gammɨjɨ pu ba duduakaꞌ gu ja iꞌiiꞌmdaꞌ bhaan. ");
INSERT INTO stpNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Baꞌp tɨtda am: ―Ea nap jich makiaꞌ gu tuꞌ pux kɨɨꞌ koiꞌ nap aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Baꞌp ja tɨtda gu Jesuus: ―Aañiꞌ dhor diꞌ gux kɨɨꞌ koiꞌ nar jix dhaam kam. Baꞌ gu jaroiꞌ noꞌt ba tɨ jɨɨꞌñ aañ jiñ bui, jaꞌp ji buusniaꞌ na cham ka bhioꞌm kaꞌ, ni ku cham ka tanoom kaꞌ, na guꞌ gammɨjɨ bhaan ba tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ku guꞌ jaiꞌ dhɨt cham tɨ jɨɨgiꞌñ japim ji noꞌt guiꞌ bhañ joot, sia kuñ guꞌ tɨi jam nɨiꞌñchudat jup tu bua na tuꞌr jix bhaiꞌm duukam. ");
INSERT INTO stpNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Dai guiꞌ nat jɨꞌk puiꞌ jaꞌk ja jujurtuda guñ Gɨꞌkoraꞌ nam baꞌ siamrim guguuxiꞌñ nam tɨ jɨɨꞌñdhaꞌ aañ jiñ bui, baꞌ aañ miꞌ dhɨr ja guguuxdhaꞌ cham jax ji chɨꞌji. ");
INSERT INTO stpNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na ñich guꞌ aañ cham tuꞌ jax kaiꞌñkam bha jii bhammɨ dɨr jix dhaam nañ yaꞌ ɇɇji bɨɨx aixim ba ji chu buimiaꞌ nañ jax ɨlhiiꞌñ dɨɨlh, guꞌ jaꞌpji nat jax pɨx jiñ chɨɨꞌn ji guiꞌ nat bhañ joot. ");
INSERT INTO stpNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na guꞌ guñ Gɨꞌkoraꞌ jaꞌpni jaꞌk jix aaꞌ, na guiꞌ nat jɨꞌk puiꞌ jaꞌk ba ja jujurtuda nam ba tɨ jɨɨꞌñdhaꞌ aañ jiñ bui, jix aaꞌ nam gammɨjɨ bañ kaichgɨdaꞌ, na baꞌ janoꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn, cham ja tulhiiñchudaꞌ iñ, dai nañ pu ja baidhikaꞌx dhaam jaꞌk. ");
INSERT INTO stpNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gio baꞌ jaꞌpni jaꞌk moop jix aaꞌ guñ Gɨꞌkoraꞌ nat bhañ joot, na bɨɨx guiꞌ nam jɨꞌk jix maatɨt jiñ kɇɇ, noꞌ mɨt ba tɨ jɨɨꞌñ nar sɨlhkam nañ jax tu aꞌgadaꞌ, gammɨjɨ ja aꞌm ba tɨ nɨidhidhaꞌ. Aañ baꞌ ja baidhikaꞌx dhaam jaꞌk na paiꞌ dhuuk tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Baꞌ pɨx am bhaak jamɨt gu gɇꞌgɇrkam Israel kam nap ja tɨtda gu Jesuus: “Aañ jir diꞌ gux kɨɨꞌ koiꞌ, nañ guꞌ bhammɨ dɨr jim jix dhaam.” ");
INSERT INTO stpNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bhaiꞌ ji ñiokbo mɨt, jup kaiꞌch am: ―¿Jax ku baꞌ puiꞌ kaiꞌch dhi jaduuñ? ¿Cham aar diꞌ gu Jesuus tɨɨgim, maraaꞌn gu Josee, gio gu dɨꞌɨɨꞌn jach jup jix maat ɨp? ¿Jax gi ji ku baꞌp jich chɨtda: “Aañ bhammɨ dɨr jim jix dhaam”? ");
INSERT INTO stpNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Guꞌ ji na guꞌ ja kɇɇ gu Jesuus nam jax kaiꞌch, baꞌp ja tɨtda: ―Moo pim cham tuꞌ bhaan ñiokbodaꞌñ jaaduñ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Na guꞌ cham jɨꞌxkat tɨ jɨɨꞌñdhaꞌ gu jaroiꞌ aañ jiñ bui noꞌ cham puiꞌ jaꞌk jurtuꞌn guñ Gɨꞌkoraꞌ nat bhañ joot, nañ baꞌ aañ miꞌ dhɨr baidhikaꞌ gɨt jix dhaam jaꞌk janoꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na guꞌ puiꞌ jaꞌk tu uaꞌñix mi uꞌuan taꞌm nat paiꞌ tu uaꞌnak maadɨt guiꞌ nam bhaankamuꞌn ya jaꞌp tu aꞌgimɨk guñ Gɨꞌkoraꞌ bɨjɨk, nap jum kaiꞌch: “Gu Dios bɨɨx ka ja mattudaꞌ na jɨꞌk jaꞌtkam gu ñioꞌkiꞌñ.” Baꞌ dhiꞌ jaꞌpni kaiꞌñkam jup jum kaiꞌch, na guiꞌ nam jɨꞌk bɨɨx ja jujur kɨꞌn jix biiñak kaꞌ buiñor guñ Gɨꞌkoraꞌ, dɨɨlh pɨx bhaiꞌx maatɨt ji kaayaꞌ am nañ jax tu ja aꞌgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ku guꞌ guñ Gɨꞌkoraꞌ cham jaroiꞌ nɨiꞌñ ji gu maaxik, na guꞌ giilhim jir jix uañ. Dai aañ ji nañ baꞌ nɨiꞌñ, nañ guꞌ bhammɨ dɨr jim jix dhaam na paiꞌp tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌ, gu jaroiꞌ noꞌt ba tɨ jɨɨꞌñ aañ jiñ bui, gammɨjɨ bhaan ba tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ, ");
INSERT INTO stpNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","na guꞌ aañ jir diꞌ gux kɨɨꞌ koiꞌ gux dhaam kam. ");
INSERT INTO stpNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jir sɨlhkam dho nam tu koiꞌmɨk gu manaa gu bɨjɨk dɨr kam janoꞌ nam mummu oipimɨk gampɨx, ku guꞌ puiꞌ pɨx jup koi mɨt ji. ");
INSERT INTO stpNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Guꞌ aañ gux dhaam kam gu koiꞌ nañ aagɨt jup kaiꞌch, pu cham tu juꞌngɨ ji. Baꞌ gu jaroiꞌ na tu jugiaꞌ, cham ka tu mumkɨdaꞌ gu iiꞌmdagaram bhaan. ");
INSERT INTO stpNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na guꞌ kaiꞌñkam aañ pɨx jir diꞌ gux kɨɨꞌ gu koiꞌ nar jix dhaam kam, na baꞌ gu jaroiꞌ noꞌt puꞌñi ba tu juu, gammɨjɨ ba duakaꞌ gu iiꞌmdagaram bhaan. Na guꞌ dhiꞌñi dhi koiꞌ nañ aañ tu maak, jir jiñ chuukuꞌ na ñich bha ja maakim nam tu jugiaꞌ bɨɨx na jɨꞌk gu jaꞌtkam, nam baꞌ kɨꞌn gammɨjɨ pu ba duduakaꞌ gu ja iꞌiiꞌmdaꞌ bhaan. ");
INSERT INTO stpNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Baꞌ gio bhaiꞌp ji ñio mɨt gu gɇꞌgɇrkam Israel kam, jup kaiꞌch am: ―¿Jax baꞌm aagɨt jup kaiꞌch dhi jaduuñ? ¿Jax gi dhuip jich makiaꞌ gu tukgaꞌn nach tu jugiaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Guꞌ ji na guꞌ ja kɇɇ gu Jesuus na mɨt giop ba ji ñiokbo, baꞌp ja tɨtda: ―Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌ, gu jaroiꞌ noꞌt cham tu juu dhiñ chuukuꞌ gio noꞌt cham tu ii guñ ɨꞌɨɨr, aañ na ñich jix dhaam dɨr bha jii, cham tuꞌ bhaan tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Na guꞌ gu jaroiꞌ noꞌt ba tu juu dhiñ chuukuꞌ gio noꞌt ba tu ii guñ ɨꞌɨɨr, gammɨjɨ bhaan ba tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ, nañ baꞌ aañ miꞌ dhɨr cham tuꞌ ka tulhiiñchudaꞌ, dai nañ pu baidhikaꞌx dhaam janoꞌ na paiꞌ dhuuk tum kuugalhdhaꞌ yaꞌ dhi oiꞌñgaꞌn. ");
INSERT INTO stpNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Na guꞌ dhiñ chuukuꞌ gio dhiñ ɨꞌɨɨr, jir diꞌ pɨx gux kɨɨꞌ koiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Baꞌ gu jaroiꞌ noꞌt ba tu juu dhiñ chuukuꞌ gio noꞌt ba tu ii guñ ɨꞌɨɨr, maap bach kɇkɇɇkɇꞌ ich gook dɨt. ");
INSERT INTO stpNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Baꞌ puiꞌ na jax guñ Gɨꞌkoraꞌ na cham tu mumkɨ, aañ puiꞌ cham jup tu mumkɨ, nañ guꞌ bhammɨ dɨr jim jia. Baꞌ gu jaroiꞌ noꞌt ba tu juu dhiñ chuukuꞌ gio noꞌt ba tu ii guñ ɨꞌɨɨr nañ jax ba kaiꞌch, cham ka tu mumkɨdaꞌ ɨp gu iiꞌmdagaram bhaan. ");
INSERT INTO stpNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aañiꞌ ji nañ baꞌr diꞌ gux kɨɨꞌ koiꞌ nañ bhammɨ dɨr jim jix dhaam, cham tuꞌ pu chuꞌm na gu manaa nam jax chuꞌm koiꞌmɨk gu bɨjɨk dɨr kam gu jam bopxikat na mɨt puiꞌ pɨx jup koi. Guꞌ matgam noꞌt jaroiꞌ ba tu juu gu koiꞌ nañ aañ jax chuꞌm tu maak, gammɨjɨ ba duakaꞌ ji gu iiꞌmdagaram bhaan. ");
INSERT INTO stpNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jaꞌpni tu ja aꞌgi gu Jesuus guiꞌ nam miꞌp tuꞌiiꞌ Kapernaum nam paiꞌ tu chiopiꞌ gu Israel kam jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Baꞌ muiꞌ jaiꞌ dhɨt guiꞌ nam kaichuꞌ gu Jesuus giilhim jix xijaim ɨlhiiꞌñ am gu puiꞌ nat jax tu aꞌga, jup kaiꞌch am: ―¿Jaroo gix maatɨt jup ba kai, na guꞌ giilhim jix xijaim kaiꞌch? ");
INSERT INTO stpNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Guꞌ ji na guꞌx bhaiꞌx maat gu Jesuus nam giilhim jix xijaim ɨlhiiꞌñ na jax tu ja aꞌgidhimɨk, baꞌp ja tɨtda: ―¿Giilhim jix xijaim kaiꞌch iñ aa panaas na pim xiñ kɇɇ? ");
INSERT INTO stpNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Jax japim baꞌm duñiaꞌ noꞌ guꞌ aañ nat bhañ joot guñ Gɨꞌkoraꞌ nañ yaꞌ ka tu aꞌga, jotmodaꞌ bhaꞌñi pu tɨs jañich bhɨjɨmmɨni jaꞌk jix dhaam na ñich paiꞌ dhɨr bha jii? ");
INSERT INTO stpNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dhiꞌ moo jam aꞌm jum aaꞌ ji na pim tɨ jɨɨꞌñdhaꞌ bɨɨx jam jujur kɨꞌn nañ jax jam tɨtda na baꞌ jam tajaañdhaꞌ guñ Gɨꞌkoraꞌ gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ na pim baꞌx mat kaꞌ na jax jaꞌk jam aꞌm tɨ nɨidhidhaꞌ. Na guꞌ gu dɨɨlh pɨx cham jɨꞌxkat machiaꞌ pim, na guꞌ dai gu tuꞌ yaꞌ kam dhi oiꞌñgaꞌn na pim bhaan tɨtɨɨꞌñcho. ");
INSERT INTO stpNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Puiꞌ na jax aapiꞌm jaiꞌ dhɨt na pim guꞌ cham tuꞌ bɨɨx jam jujur kɨꞌn tɨ jɨɨgiꞌñ aañ jiñ bui. Baꞌ dhiꞌ na puiꞌ jɨꞌ kaiꞌch gu Jesuus, na guꞌ bɨɨpɨꞌ pux bhaiꞌx mat kaꞌ nam jax chuꞌm cham bɨɨx ja jujur kɨꞌn tɨ jɨɨgiꞌñdhaꞌ, jaꞌp na jax guiꞌ na jaroiꞌ maaxik kɨɨsaꞌ nam boi bhɨichdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Miꞌ dhɨr baꞌ giop xi ja tɨꞌñchoix na jax ba ja tɨtda, jup kaiꞌch: ―Kaiꞌñkam cham jɨꞌxkat tɨ jɨɨꞌñdhaꞌ aañ jiñ bui gu jaroiꞌ noꞌ cham puiꞌ jaꞌk jurtuꞌn guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Baꞌ janoꞌ dɨr muiꞌ cham ka kaichgɨdaꞌ am gu Jesuus guiꞌ nam ka kaichgɨt, cham paiꞌ ka aꞌjɨdaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Miꞌ dhɨr baꞌ jaꞌxpɨx na mɨt dɨɨlh miꞌ ji bii gu mambhɨɨx daman gook gu noonbiꞌñ gu Jesuus, xi ja tɨkka noꞌm puiꞌp bax ooꞌn nam kaichgɨdaꞌ, jup ja tɨtda: ―¿Aapiꞌm aa puiꞌ cham jup kam guguuxiꞌñ na pim jiñ kaichgɨdaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Baꞌ bhaiꞌ ji ñio gu Simoon Peegro, jup kaiꞌch: ―¿Paach gi chi baꞌ jaꞌk jup bhɨɨyaꞌ? Na guꞌ cham jaroiꞌ jaꞌxbuiꞌr gɇꞌkam na jax aap jich jaduuñ nach aagiꞌñdhaꞌ na jax jaꞌk gammɨjɨch aꞌm tɨ nɨidhidhaꞌ guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Guꞌ aach dai aap pɨx bhaiꞌ bam nɨidhim ji, na chich guꞌ bɨɨx jich jujur kɨꞌn ba tɨ jɨɨꞌñ aap jum bui, nach guꞌ bax maat nap aap jir diꞌ guch Xoiꞌkam nap jir Maraaꞌn gu Dios nat bham joot. ");
INSERT INTO stpNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Baꞌp ja tɨtda gu Jesuus: ―Dho pu kaiꞌñkam jañich dho jam guguux aapiꞌm mambhɨɨx daman gook na pim jir jiñ ñoonob kaꞌ. Guꞌ ji na guꞌ maadɨt cham puiꞌ ɨlhiiꞌñ, na guꞌ dai mu jaꞌk tukgiꞌñ gu jaꞌook. ");
INSERT INTO stpNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Baꞌ dhiꞌ na puiꞌ jɨꞌ kaiꞌch gu Jesuus, gu Juudas Iskariote maraaꞌn gu Simoon Iskariote na aagɨt jup kaiꞌch, na guꞌ dhiꞌr diꞌ maadɨt gu mambhɨɨx daman gook gu noonbiꞌñ na maaxik kɨɨsaꞌ gatuuk nam boi bhɨichdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bhaiꞌ baꞌ pu oirɨdaꞌ gu Jesuus Galilea, cham jimmɨdaꞌ bhammɨ jaꞌk Judea, na guꞌx maat nam bhaiꞌ gaꞌngadaꞌ gu gɇꞌgɇrkam Israel kam nam jix chu chiañik nam muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Baꞌ moo janoꞌ pɨk jup bam aajim nam paiꞌ dhuuk tu oꞌnamtardaꞌ gu Israel kam jaꞌtkam, nam soiꞌm ɨlhdhat tu piastatdaꞌ xijum baik tanoolh. ");
INSERT INTO stpNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Baꞌp tɨtda am gu jajaaꞌnniꞌñ gu Jesuus: ―¿Guꞌ aap jax kup baꞌ yaꞌ oirɨ? ¿Cham bhaiꞌ aa nap muiꞌ xi jimiaꞌ bhammɨ Judea nam baꞌ guꞌp jum nɨiꞌñdhaꞌ gu jaꞌtkam nap jɨꞌk tuꞌ jax bua guiꞌ nam kiaꞌpɨx bam guguuxiꞌñ nam jum kaichgɨdaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Na guꞌ cham tuꞌ ɨxchuixim tu aꞌgadaꞌ gu jaroiꞌ noꞌx aaꞌ nam kaichgɨdaꞌ. Aap dho pɨk saak jir gɇꞌkam ji, dho guꞌ dhiꞌm aaꞌ ji nap mu jimɨi bɨɨx aixim tu duñiaꞌ ja nɨiꞌñchudat gu muiꞌ jaꞌtkam nam baꞌ tɨ jɨɨꞌñdhaꞌ aap jum bui. ");
INSERT INTO stpNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Baꞌ dhiꞌ nam puiꞌ jɨꞌ tɨtda, nam cham tɨ jɨɨgiꞌñ buiñor sia kum tɨi miaꞌn jir jum jajaaꞌnnim. ");
INSERT INTO stpNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Baꞌ bhaiꞌ ji ñio gu Jesuus, jup ja tɨtda: ―Chakuim ai ji matgam na paiꞌ dhuuk tu daaxix nam machiaꞌ gu jaꞌtkam nañ jir gɇꞌkam. Guꞌ puiꞌñ ɨlhiiꞌñ japim na jax aapiꞌm na pim mu jaꞌp paiꞌ xi jimiaꞌ paiꞌ na pim duuk ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Aañ matgam giilhim xiñ bhaamkiꞌñ am ji gu jaꞌtkam nañ xi ja aagiꞌñdhaꞌ nam jix buam pɨx tu buadaꞌ na jax cham jir am. Guꞌ noꞌ cham tuꞌ bhaan tu aꞌga jaroiꞌ jaꞌp na jax aapiꞌm, ¿tuꞌm gi kɨꞌn biaꞌ nam bhaiꞌ ji jam bhaamkidhaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Aapiꞌm dɨɨlh muiꞌ xi jimiaꞌ bhammɨ na paiꞌ tum oꞌnamtaꞌ noꞌ pim mur jiimdam kat jup kaiꞌch. Aañ yaꞌ pɨx ka oirɨ sia bhɨjɨ paiꞌ jax tum bua, nat guꞌ kaiꞌñkam chakuim ai na paiꞌ dhuuk tu daaxix na matgilhiaꞌ nañ jir gɇꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Dai puꞌñi pɨx xi ja tɨɨdak miꞌ ji bii Galilea. ");
INSERT INTO stpNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Baꞌ dɨɨlh bhammɨ jaꞌk ji dhuu mɨt gu jajaaꞌnniꞌñ, gu Jesuus baꞌ gatuuk muiꞌp ma jii jix ɨxchuixim na baꞌ cham jaroiꞌ mat kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Baꞌ gu gɇꞌgɇrkam Israel kam bhammɨ jaꞌk tɨi gaꞌnga am, jup kaiꞌch am bha jaꞌp oipot: ―¿Paa jaꞌk jax chuꞌiiꞌ guiꞌ na jaꞌp moo gɇꞌkam jum taat kaꞌ? ¿Cham aa yaꞌ paiꞌ oirɨ? ");
INSERT INTO stpNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Gam gu jaꞌppɨx jaꞌtkam bha jaꞌp oipot jum ñiñiokboixiꞌñ am. Jɨꞌmaꞌn jup kaiꞌch am: “Joidham jir jix bhaiꞌkam.” Jaiꞌm maakam jup ɨlhiiꞌñ, jup kaiꞌch am: “Chaam tuꞌ, jaꞌpji na jax dhui ja iatgiꞌñ gu jaꞌtkam.” ");
INSERT INTO stpNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ku guꞌ gu jaꞌtkam nam aꞌga gu Jesuus, cham tuꞌ ji nam ji ja kaixdhat gu gɇꞌgɇrkam, nam guꞌx ja ɨɨbhiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Baꞌ na paiꞌ bar ɨrban na bhaiꞌ tum dar oꞌnam tɨr, bhammɨ ba ai gu Jesuus gɇꞌ chiop, mɨjɨ baakɨk bhaiꞌ ji chu ja aꞌgi gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Baꞌ miꞌ puiꞌ pup tuꞌiiꞌ am gu gɇꞌgɇrkam na mɨt kai na giilhim jix bhaiꞌ xi bua na xi chu aꞌga, baꞌp kaiꞌch am: ―¿Jax baꞌ duukat bɨxchuꞌx chu maat dhi jaduuñ nach moo cham jɨꞌxkat yaꞌ paiꞌ nɨiꞌñ na tum mamtuxiꞌñ? ");
INSERT INTO stpNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Guꞌ ji na guꞌ ja kɇɇ gu Jesuus nam jax kaiꞌch, baꞌp ja tɨtda: ―Dho guꞌ cham tuꞌ aañ dɨɨlh ji nañ jax ɨlhiiꞌñ nañ yaꞌ tu jam aꞌgiꞌñ, guꞌ matgam guiꞌ ji nat bhañ joot nar ñioꞌkiꞌñ dhiꞌ nañ jɨꞌk jax tu aꞌga. ");
INSERT INTO stpNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Noꞌ jaroiꞌx maachim na miꞌ puiꞌ jimiaꞌ na jax jix aaꞌ gu Dios na tuiꞌñgɨdaꞌ, ba mattudaꞌ na Dios jir ñioꞌkiꞌñ nañ jax tu aꞌga, cham tuꞌ aañ dɨɨlh pɨx nañ jax ɨlhiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Na guꞌ gu jaroiꞌ noꞌ dɨɨlh pɨx naiꞌ tu aꞌgim na jax ɨlhiiꞌñ, cham tuꞌr puiꞌ kaꞌ, na guꞌ dai nax aaꞌndaꞌ nam pɨx bha nɨidhidhaꞌ gu jaꞌtkam. Guꞌ ji noꞌt jumai mu joot, noꞌ miꞌ puiꞌ tu daaꞌñchuꞌ na baꞌr sɨlhkam kaꞌ na jax kaiꞌchdhaꞌ, na guꞌ bhaankamuꞌn pɨx tu aꞌgidhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Jaꞌp na jax gu Moisees nat bhaankamuꞌn tu uaꞌnak guñ Gɨꞌkoraꞌ na pim jax jaꞌk tuiꞌñgɨdaꞌ, guꞌ ji na pim guꞌ sia guiꞌ jaꞌp xi dhuukat, cham tuꞌ miꞌ puiꞌ jiim japim nat jax tu uaꞌnak. Guꞌ baꞌ aañ puꞌñi ɨp xib, tuꞌ pɨx jam jaaxmakar jiñ ɨlhiiꞌñ japim, dai na pim bax chu chiañik nam jiñ muꞌaaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Baꞌ bhaiꞌ ji ñio mɨt gu jaꞌtkam, jup kaiꞌch am: ―Iat ap dho. ¿Jaroo gi paiꞌp jix chu chiañim nam jum muꞌaaꞌ? Jaꞌpji nam aꞌm jup tuiꞌdhiꞌ gu jaꞌook na baꞌ jax ña pɨx ba tu tatdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Baꞌp ja tɨtda gu Jesuus: ―¿Guꞌ jax ji na baꞌ janoꞌ na paiꞌ dhuuk cham tum juandaꞌ na ñich xi dhuaꞌñ maaꞌn gu jaduuñ miꞌ puiꞌ pup tuꞌiiꞌ pim? ");
INSERT INTO stpNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","¿Na baꞌ guꞌ aapiꞌm sia ja matgilhiꞌñdhaꞌ gu aꞌaalh puiꞌ xi kaiꞌchɨt na cham tum juandaꞌ? Na guꞌ dai na pim miꞌ puiꞌ tu daaꞌñchuꞌ nam jax tu buaꞌt gu bɨjɨk dɨr kam gu jam bopxikat nat baꞌ moo gu Moisees jup ba tu uaꞌna. ");
INSERT INTO stpNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","¿Guꞌ aapiꞌm baꞌ cham jum nɨiꞌñ ji jia gu puiꞌ na pim tu buadaꞌ? ¿Ɨlhiiꞌñ japim aa na cham xidhuu, kaꞌ dai aa guiꞌ nañ tuꞌ jax buadaꞌ aañ na baꞌx xidhuu na pimɨt baꞌ giilhim bhaak janoꞌ na ñich xi dhuaꞌñ gu jaduuñ nax kaꞌook kat? ");
INSERT INTO stpNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nɨidhix kam ji na pim aꞌgadaꞌ gu tuꞌ noꞌ pim ɨlhiiꞌñ na cham jir am, cham tuꞌ na pim kuupɨt tu aꞌgadaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Baꞌ jaiꞌ dhɨt gu bhaiꞌ kam Jerusaleen jup kaiꞌch am: ―¿Cham aar diꞌ nam saak tɨi gaaꞌñchuꞌ nam jix chu chiañik nam muꞌaaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tɨɨꞌ nam baꞌ cham juan na miꞌ tu aꞌgichuꞌ. Moo chi ba tɨ jɨɨgiꞌñ am gu gɇꞌgɇrkam nar diꞌ guch Xoiꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","¿Gi jax dhuukat baꞌp jix maatɨꞌ nar paiꞌ kam? ¿Cham aa guꞌ cham maatɨꞌ kaꞌ gɨt na paiꞌ dhɨr buusniaꞌ noꞌr diꞌ kaꞌ gɨt guch Xoiꞌkam? ");
INSERT INTO stpNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Baꞌ na miꞌ ka tu aꞌgichuꞌ gɇꞌ chiop gu Jesuus, ba ja kai nam jax kaiꞌch, baꞌp ja tɨtda gɇꞌ kɨꞌn nam baꞌ bɨɨx kaayaꞌ: ―Cham tuꞌ ji na pim jiñ maat matgam nañ jir paiꞌ kam, na pim guꞌ cham maat na ñich jumai bhaankamuꞌn bha jii, na pim aapiꞌm cham maat nax bhaiꞌ nam buiñor jix biiñak kaꞌ bɨɨx na jɨꞌk jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Dai aañ na ñich bhammɨ dɨr bha jii na paiꞌp tuꞌiiꞌ nat bhañ joot nañ baꞌx maat. ");
INSERT INTO stpNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Baꞌ jaiꞌ dhɨt cham ja koꞌraaru nat puiꞌ jɨꞌ xi chɨi gu Jesuus, aaꞌndaꞌ gɨt nam miꞌ pu buuplhiaꞌ, guꞌ jaꞌpji na guꞌ panaas ku alh jaꞌp cham jax jix bhaaiꞌ nam doodaꞌ, guꞌ jaꞌpji nat chakuim ai na paiꞌ dhuuk daaxix nam dagiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kum ti guꞌ puiꞌ pɨx muiꞌ jaꞌtkam jup tɨ jɨɨꞌñ ji buiñor, jup kaiꞌch am: ―¿Jax gi chi jaꞌk tu buidhaꞌ guch Xoiꞌkam na paiꞌ dhuuk ya aayaꞌ? ¿Cham aa puꞌñi pɨx na jax ba tu bua dhi jaduuñ na jɨꞌk tuꞌr jix bhaiꞌm duukam? ");
INSERT INTO stpNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Baꞌ ampɨx ja kai mɨt guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ nam miꞌ ka tu aꞌga guiꞌ nam kiaꞌpɨx am ba tɨ jɨɨgiꞌñ buiñor gu Jesuus. Baꞌ guiꞌ nam jir ja gɇꞌgɇrkam tuk guiꞌ nam mu jaꞌp tu juan chichiop gio gu pariseos, maap jum daagɨk mu ja joot jamɨt gu tutpilh nam sap buuprapuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Guꞌ ji na guꞌp ja tɨtda gu Jesuus na mɨt mu ba ai nam tɨi bax buuprak: ―¿Jax japim baꞌp jiñ dhuñiaꞌ, nañ guꞌ yaꞌ pɨx buusnichuꞌ? Jaꞌp pɨk ba ji jiiñ chi matgam bhammɨ jaꞌk buiñor guiꞌ nat bhañ joot, ");
INSERT INTO stpNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","na pim paiꞌ cham kañ chɨgiaꞌ sia pim tɨi bañ gaꞌnga. Na guꞌ giilhim jix xijai na pim jax dhuuji aayaꞌ nañ paiꞌ bap tuiꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Baꞌ ni jɨꞌx ku mɨt jix maatɨt kai gu gɇꞌgɇrkam Israel kam na jax kaiꞌñkam jup ja tɨtda. Mi jaꞌp jam tɨim tɨ tɨkka dɨɨlh, jup kaiꞌch am: ―¿Paa baꞌ jaꞌk tu aagat jup kaiꞌch na jimiaꞌ kuch baꞌ puiꞌ cham ka tɨgiaꞌ sia kuch tɨi ba gaꞌnga? ¿Kaꞌ moo bhammɨ dɨr jaꞌk aa bhɨɨyaꞌ momkoran nam paiꞌ jaꞌk oiꞌdhaꞌ guiꞌ nam puiꞌp tu jim na jax aach yaꞌ kam Israel, guiꞌ nam griago ñiꞌook kɨꞌn jup tu aꞌga, na baꞌ jaiꞌ bhammɨ dɨr ji kiichai bha jaꞌp naiꞌ ji chu ja aꞌgidhaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Kaꞌ jax gi kaiꞌñkam jup kaiꞌch ji na baꞌp jich chɨtda: “Na pim paiꞌ cham kañ chɨgiaꞌ sia pim tɨi bañ gaꞌnga, na guꞌ giilhim jix xijai na pim jax dhui aayaꞌ nañ paiꞌ bap tuiꞌkaꞌ”? ");
INSERT INTO stpNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Baꞌ janoꞌ nam baꞌ moo ba tɨɨmuꞌ nam tu piastat gu Israel kam jaꞌtkam, mi jaꞌp kɨkbuk jup ja tɨtda gu Jesuus gɇꞌ kɨꞌn nam baꞌ bɨɨx kaayaꞌ: ―Noꞌ jaroiꞌx chanoom, jum aaꞌ na soiꞌm ɨlhdhaiñ chañiaꞌ gu suudaiꞌ na baꞌ tu iꞌyaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Na guꞌ gu jaroiꞌ noꞌt ba tɨ jɨɨꞌñ aañ jiñ bui, gammɨjɨ bhaan ba baꞌpundaꞌ gux kɨɨꞌ gu suudaiꞌ na cham tu gaꞌkɨ, na kɨꞌn cham ka tu mumkɨdaꞌ gu iiꞌmdagaram bhaan, na jax bam kaiꞌch mi uꞌuan taꞌm nat paiꞌ tum uaꞌnak bɨjɨk. ");
INSERT INTO stpNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Baꞌ dhiꞌ na puiꞌ jɨꞌ ja tɨtda gu Jesuus, gux Dhuuduꞌ kam jix Uañ Iiꞌmdaꞌ na aagat jup kaiꞌch na bhaan bam tajaanaꞌ gu jaroiꞌ noꞌt ba tɨ jɨɨꞌñ buiñor. Na guꞌ chakui ja aꞌm tajaañix kaꞌ janoꞌ, nat guꞌ chakui muukɨk giop bam mu dɨr koiꞌñgaꞌn tɨr gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Baꞌ jaiꞌ dhɨt mɨjɨ jaꞌp sasgidhan jup kaiꞌch am na mɨt kai na puiꞌ jɨꞌ ja tɨtda gu Jesuus: ―Dhiꞌ dho bak jir diꞌ na saak jaiꞌchdhɨlhiaꞌ na bhaankamuꞌn jup ba tu aꞌga guch Gɨꞌkoraꞌ jaꞌp na jax saak gu bɨjɨk dɨr kam. ");
INSERT INTO stpNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jɨꞌmaꞌn maakam jup ɨlhiiꞌñ am, jup kaiꞌch am: ―Jaꞌpji na pur dhiꞌ guch Xoiꞌkam. Guꞌ ji nam guꞌ jaiꞌ cham tɨ jɨɨgiꞌñ, jup kaiꞌch am: ―¿Jax dhui miꞌ paiꞌ dhɨr jup ba ji buusniaꞌ Galilea guch Xoiꞌkam? ");
INSERT INTO stpNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na guꞌ pum kaiꞌch mi uꞌuan taꞌm gu ñioꞌkiꞌñ guch Gɨꞌkoraꞌ na saak guch Xoiꞌkam Beleen maaxilhiaꞌ nar paiꞌ kam gu Dabii guiꞌ nar gɇꞌkam kat bɨjɨk, gio na saak maadɨt jax chuꞌm nar boxiiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Baꞌ cham maaꞌn ñiꞌook jup bua am nam tɨi xi chu aꞌga, nam guꞌ jaiꞌ tɨ jɨɨgiꞌñ nar sɨlhkam na gu Jesuus jir diꞌ guch Xoiꞌkam, jaiꞌ guꞌx bhaamut pɨx kɇɇ am ji, ");
INSERT INTO stpNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","dai nam pɨx am jix buuprak nam guꞌ cham kaim gu puiꞌ na jax jaꞌk tu aꞌga. Ku guꞌ cham jum guguux jamɨt ji nam buuplhiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Baꞌ puiꞌ gio miꞌp ba ai mɨt gu tutpilh na mɨt muiꞌ tɨi ja joot guiꞌ nam jir ja gɇꞌgɇrkam tuk guiꞌ nam mu jaꞌp tu juan chichiop gio guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, nam sap buuprai mu bhɨikaꞌ gɨt gu Jesuus. Baꞌp ja tɨtda am: ―¿Jax ku pim baꞌ puiꞌ bha jaꞌk jiim? ¿Gi nach jup jam tɨtda na pim buuprai bha bhɨikaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Baꞌp kaiꞌch am gu tutpilh: ―Jax dhui na giilhim jix bhaiꞌ xi bua na xi chu aꞌga. Cham jɨꞌxkat jaroiꞌ puiꞌ kɇɇkɇt ich. ");
INSERT INTO stpNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Baꞌx bhaakut bhaiꞌ ji ñio mɨt gu pariseos, jup kaiꞌch am: ―¿Aapiꞌm aap ba jam iatgi? ");
INSERT INTO stpNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Jaroo pim gi nɨiꞌñ na ba tɨ jɨɨgiꞌñ buiñor guiꞌ nam jɨꞌk jir gɇꞌgɇrkam piam gu pariseos? ");
INSERT INTO stpNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Dai guiꞌ nam jɨꞌk cham maatɨt kɇɇ gu ñioꞌkiꞌñ guch Gɨꞌkoraꞌ nat jax tu uaꞌnak gu Moisees mi uꞌuan taꞌm nam baꞌ alh jaꞌp jix kaim gu ja bɨɨm tuꞌm. Ku guꞌ dhiꞌ cham maatɨꞌ ji na tuꞌ jax ja duñiaꞌ, na guꞌ ka ja tulhiiñchudaꞌ guch Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Baꞌ miꞌ dhɨr jaꞌp bhaiꞌ ji ñio gu Nikodeemo na puiꞌp ja kaichgɨdaꞌ gu pariseos, guiꞌ nat maaꞌnnim tukaaꞌñ chaꞌm mu jimɨɨk nat tɨɨꞌmɨrak gu Jesuus mu na paiꞌ tɨbiaput, jup ja tɨtda: ");
INSERT INTO stpNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―¿Guꞌ jax japim baꞌ tɨi xi ɨlhiiꞌñ na pim doodaꞌ gɨt? Na guꞌ maakam jaꞌk tu daaxix mi uꞌuan taꞌm na saak cham bhaiꞌ nach pu tɨꞌyaꞌ na cham jir am nat tuꞌ jax dhuu gu jaroiꞌ noꞌ cham dɨɨlh tu aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Baꞌ giilhim bhaak jamɨt nat puiꞌ xi ja tɨɨꞌn, jup tɨtda am: ―¿Aap jup jix ja oiꞌñ aa gu Galilea kam jaꞌtkam? Jix bhaiꞌp tu jiñkaiꞌñdhaꞌ gu ñioꞌkiꞌñ guch Gɨꞌkoraꞌ nap baꞌx mat kaꞌ nat chakui jaroiꞌ miꞌ dhɨr buus na bhaankamuꞌn tu aꞌgimɨk guch Gɨꞌkoraꞌ. ¿Kaꞌ xib baꞌ moop bax bhaaiꞌ aa nat miꞌ dhɨr ba ji buus? ");
INSERT INTO stpNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Miꞌ baꞌ puiꞌ xi kaiꞌchimɨk ma tu kookxim jamɨt mu jaꞌp ja kiikiaꞌam. ");
INSERT INTO stpNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Guꞌ baꞌ gu Jesuus jup ba tɨbiapum baasɨꞌn jaꞌk oidhaꞌ taꞌm nam paiꞌ Oliibus kɨꞌn jix chu mat kaꞌ, na paiꞌm jɨɨpiꞌñkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Baꞌ buimgidhak jix dhaꞌnpam jix chu maaxirɨk giop miꞌp ba ai gɇꞌ chiop. Jaꞌxpɨx baꞌ na mɨt jix ioꞌm muiꞌ miꞌ xi ai gu jaꞌtkam buiñor, mi jaꞌp ji dhaibuk bhaiꞌ ji chu ja aꞌgi. ");
INSERT INTO stpNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Guꞌ baꞌ guiꞌ nam sap jix mat kaꞌ gu ñioꞌkiꞌñ gu Dios, gio guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, mu paiꞌ ji chɨɨgɨk jamɨt maaꞌn gu ubii na jumai pɨx ba oiꞌñchuꞌ gu maaꞌnkam, cham tuꞌ guiꞌ nat jaroiꞌ oi bɨɨpɨꞌ dɨr. Mi jaꞌp ba kɨɨs am ja saagiꞌñ, ");
INSERT INTO stpNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","baꞌp tɨtda am gu Jesuus: ―Aach bha baidhak dhiꞌñi ubii nach ñɨiꞌñ na cham jir am na puiꞌm buaꞌt oirɨdaꞌ. Na guꞌ dhiꞌ tɨ bɨɨnaꞌ, dai nat maiꞌ xi buak jumai ba oiꞌñchuꞌ gu maaꞌnkam. ");
INSERT INTO stpNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na guꞌ gu Moisees nat tu uaꞌnak puiꞌm kaiꞌch nach sap ja kooꞌndaꞌ ja maꞌyasat joodai kɨꞌn gu pu chuꞌm gu uꞌuub. ¿Aap jax kaiꞌch, muꞌaaꞌch aa? ");
INSERT INTO stpNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Baꞌ dhiꞌ nam puiꞌ jɨꞌ tɨtda gu Jesuus nam miꞌ pɨx mamtɨ noꞌt sap moo bhaiꞌ bhaankamuꞌn ji ñio, nam baꞌ ba iattulhdhaꞌ ja bui gu gɇꞌgɇrkam Israel kam noꞌt jax dhuuk cham puiꞌ jaꞌk tɨi na jax tu daaxix. Guꞌ ji na guꞌ cham ñiok gu Jesuus, dai nat gan ji mugia, miꞌ pɨx jaꞌp xi chu uꞌuan nobiiꞌñ kɨꞌn dɨbɨɨr taꞌm. ");
INSERT INTO stpNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Guꞌ ji nam guꞌ kɨɨsaim nam tɨkkatuꞌ. Baꞌ bhaiꞌ xi ja tɨɨgɨk jup ja tɨtda: ―Aa dho bhaiꞌ xi maiꞌññaꞌ ku gi bɨɨpɨꞌ gu jaroiꞌ maadɨt na cham jɨꞌx uaꞌtulhdhix. ");
INSERT INTO stpNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Miꞌ dhɨr baꞌ puiꞌ xi chɨꞌɨɨk gio naiꞌp ji mugia, maaꞌn na jax tu uꞌuantuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Guꞌ baꞌ na mɨt kai nat puiꞌ jɨꞌ tɨi gu Jesuus, gampaiꞌ ji dhuu mɨt, nam guꞌx maat nam giilhim jix uꞌuaꞌtulhdhix. Cham jamɨt baꞌ paiꞌ ka tɨkka, dai na mɨt pɨx ji bubuax xɨꞌlhim bɨɨpɨꞌ kat guiꞌ nam jir jagɨꞌgɨr. Bɨɨx jamɨt pu bubua, dɨɨlh dai gook jamɨt miꞌ ji bii gu Jesuus gio gu ubii. ");
INSERT INTO stpNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Baꞌ nat gio bhaiꞌp ji chɨ tɨɨ gu Jesuus, ampɨx tu juꞌ, nim maaꞌn maaꞌnkam ku paiꞌ tu jaiꞌch gu muiꞌ nam miꞌ kap tuꞌt, dai dɨɨlh gu ubii pɨx miꞌ kɨɨk. Baꞌp tɨtda: ―¿Paa mɨt jaꞌk bhɨi guiꞌ nam yaꞌ pɨx jix baabuiꞌm ka kaiꞌch nam saak xim bhaamkiꞌñ? Cham dho bak jax ka xim doodam am jia. ");
INSERT INTO stpNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Baꞌp kaiꞌch gu ubii: ―Cham dho chi jia. Baꞌp tɨtda gu Jesuus: ―Dho aañ ba puiꞌ ɨp, cham biaꞌ iñ nañ jax jum tɨɨdaꞌ. Ba jimiaꞌ ap, dai nap cham kam uaꞌtulhiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Baꞌ gio bhaiꞌp ji chu ja aꞌgi gu Jesuus gu jaꞌtkam, jup ja tɨtda: ―Aañ jir diꞌ guiꞌ na joidham gɇꞌ tanoor yaꞌ dhi oiꞌñgaꞌn. Gu jaroiꞌ na bañ kaichgɨdaꞌ, cham tuꞌx chukgam kɨr kap tuiꞌñgɨdaꞌ. Joidham jix chu maax kɨr ba oirɨdaꞌ, na guꞌ ba machiaꞌ na jax jaꞌk miꞌ puiꞌ jimdaꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Baꞌp tɨtda am guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ: ―Jax dhui na guꞌ aap dɨɨlh nap jum aꞌmkam ñiok. Dhiꞌ cham tuꞌr puiꞌ ji matgam, na guꞌr iatdaꞌ kaꞌ noꞌñ dɨɨlh jiñ aꞌmkam tu aꞌgim. ");
INSERT INTO stpNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Guꞌ ji na guꞌp ja tɨtda gu Jesuus: ―Dho guꞌ cham jax bua ji sia kuñ dɨɨlh jiñ aꞌmkam ñiok, na guꞌr puiꞌ nañ jɨꞌk jax kaiꞌch, nañ guꞌx maat na ñich paiꞌ dhɨr bha jii gio nañ pa jaꞌk jim. Aapiꞌm na pim guꞌ cham maat nañ paiꞌ dhɨr jaꞌk jim gio nañ pa jaꞌk bhɨichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Guꞌ jaꞌp jum aaꞌ pim na puiꞌ na jax aapiꞌm na pim pu tu buadaꞌ na pim dɨɨlh jax ɨlhiiꞌñdhaꞌ, cham tuꞌ na jax jix aaꞌ guñ Gɨꞌkoraꞌ. Guꞌ aañ matgam cham tuꞌ puiꞌ ji, ");
INSERT INTO stpNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","na guꞌ nañ jɨꞌk jax ɨlhiiꞌñ nañ tɨꞌiidhaꞌ sia nar paiꞌ dhuuk, jir puiꞌ kaꞌ, na guꞌ cham tuꞌ aañ dɨɨlh jup kaiꞌchidhaꞌ, guꞌ matgam guñ Gɨꞌkoraꞌ ji nat bhañ joot. ");
INSERT INTO stpNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Dho na pim jax bax maat mi uꞌuan taꞌm na tu uaꞌñix na saak gu jaroiꞌ noꞌt tuꞌ jax dhuu jix buam jum duukam, cham tɨ jɨɨgiꞌñdhaꞌ am gu gɇꞌgɇrkam noꞌ maaꞌn dɨɨlh tɨi xi iattulhiꞌñ, dai noꞌm gook jaꞌtkam puiꞌ ba kaiꞌch na baꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jaꞌp na jax xib nañ dɨɨlh jiñ aꞌmkam ñiok gio guñ Gɨꞌkoraꞌ nat bhañ joot, gook jach dho bap jich bua. ");
INSERT INTO stpNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Baꞌp kaiꞌch am gu pariseos: ―¿Paa baꞌ jax chuꞌiiꞌ gum Gɨꞌkoraꞌ? Baꞌp ja tɨtda gu Jesuus: ―Jax dhui na guꞌ ni aañ ku pim xiñ maat nañ jir tuꞌp tuꞌm daꞌ, chi baꞌ pɨk jup bax maat japim guñ Gɨꞌkoraꞌ. Noꞌ pim guꞌ xiñ maat kaꞌ gɨt aañ, puiꞌ pim dhop jix maat kaꞌ gɨt guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jaꞌpni tu ja aꞌgi gu Jesuus mɨjɨ gɇꞌ chiop mi sonpan ji kɨkbuk na paiꞌm tuaꞌbaꞌ gu tuumiñ. Ku guꞌ cham jaroiꞌ juan ji, nat guꞌ chakuim ai na paiꞌ dhuuk tu daaxix nam dagiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Baꞌp ja tɨtda ɨp gio gu Jesuus: ―Aañ matgam yaꞌ puiꞌ xi kaiꞌchimɨi ba jimiaꞌ ji. Sia ku pim aapiꞌm tɨi bañ gaꞌnga gatuuk, cham paiꞌ kañ chɨgiaꞌ pim. Yaꞌ pim pɨx pu koꞌyaꞌ jix uꞌuaꞌtulhdhix kam, na guꞌ giilhim jix xijai na pim jax dhui aayaꞌ bhammɨ nañ paiꞌ bap tuiꞌkaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Baꞌp kaiꞌch am dɨɨlh gu gɇꞌgɇrkam Israel kam: ―¿Paa baꞌ jaꞌk tɨi xi ɨlhiiꞌñ na bhɨɨyaꞌ gɨt? ¿Kaꞌ baꞌ moo xim muꞌaam aa chi dɨɨlh ku baꞌ puiꞌx xijai nach jax dhuuji aayaꞌ na paiꞌ bap tuiꞌkaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Guꞌ ji na guꞌ ja kɇɇ gu Jesuus nam jax kaiꞌch, baꞌp ja tɨtda: ―Na pim guꞌ aapiꞌm jir yaꞌ kam dhi dumaalh kɨisap bhaan, guꞌ aañ matgam jir tɇꞌkob kam ji. Aapiꞌm jir yaꞌ kam jia dhi oiꞌñgaꞌn bhaan, aañ guꞌ matgam cham tuꞌr yaꞌ kam ji. ");
INSERT INTO stpNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Puiꞌ kuñ baꞌp jam tɨtda na pim yaꞌ pu koꞌyaꞌ jix uꞌuaꞌtulhdhix kam noꞌ pimɨt cham tɨ jɨɨꞌñ nañ aañ jir diꞌ nañ bɨjɨk dɨr pux jaiꞌch bɨɨmaꞌn guñ Gɨꞌkoraꞌ. Yaꞌ pup jir biꞌxim kaꞌ pim jix uꞌuaꞌtulhdhix kam. ");
INSERT INTO stpNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Baꞌp tɨtda am: ―¿Jir tuꞌp tuꞌm daꞌ ap gi nap baꞌ puiꞌ kaiꞌch nap bɨjɨk dɨr pux jaiꞌch? Baꞌp ja tɨtda gu Jesuus: ―Dho nañ jax ba kaiꞌch na ñich jax dhɨr yaꞌ ai. ");
INSERT INTO stpNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Muiꞌx jaiꞌch nañ tuꞌ tu jam aꞌgidhaꞌ, na pim guꞌ cham miꞌ puiꞌ jiimchuꞌ na jax jir am. Ku guꞌ cham tuꞌ ji na aañ dɨɨlh nañ jax ɨlhiiꞌñ, gu jaꞌpji na jax jix aaꞌ guiꞌ nat bhañ joot. Jaꞌpniñ baꞌ pɨx tu jam aꞌgiꞌñ, nañ guꞌ aañ jix maat nar sɨlhkam nat jax jiñ chɨɨꞌn guiꞌ nat bhañ joot. ");
INSERT INTO stpNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Guꞌ ji na mɨt guꞌ cham maatɨt kai na guch Gɨꞌkoraꞌ aagɨt jup kaiꞌch gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Baꞌp ja tɨtda ɨp gio: ―Janoꞌ ji na pim paiꞌ dhuuk bañ xissapaꞌ kuruus taꞌm na pim baꞌ ba machiaꞌ nañ aañ jir diꞌ nañ bɨjɨk dɨr pux jaiꞌch bɨɨmaꞌn guñ Gɨꞌkoraꞌ, nañ cham tuꞌ aañ dɨɨlh pɨx puiꞌ tu bua nañ jax ɨlhiiꞌñ, guꞌ jaꞌpji na jax pɨx jiñ chɨɨdaim ji guñ Gɨꞌkoraꞌ nañ tu jam aꞌgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na guꞌ yaꞌni jaꞌp jiñ xanoop jup tuiꞌdhiꞌ guñ Gɨꞌkoraꞌ guiꞌ nat bhañ joot. Cham jɨꞌxkat paiꞌñ dhoꞌñchoꞌ dɨɨlh, nañ guꞌ aañ miꞌ puiꞌ xi chu buim na jax jaꞌk jix aaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Baꞌ muiꞌ jaꞌtkam tɨ jɨɨꞌñ jamɨt buiñor nat paiꞌ dhuuk puiꞌ jɨꞌ tu ja aꞌgi gu Jesuus. ");
INSERT INTO stpNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Baꞌp ja tɨtda gu Jesuus guiꞌ nam jɨꞌk ba tɨ jɨɨgiꞌñ buiñor: ―Noꞌ pim miꞌ puiꞌ jiimchuꞌ nañ jɨꞌk jax tu jam aꞌgiꞌñ, bhaan bax maatɨꞌ kaꞌ na pim bañ kaichuꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Baꞌ cham jaroiꞌ jam aꞌmkam aaꞌndaꞌ na pim bha nɨidhidhaꞌ na jax jam tɨɨdaidhaꞌ, na pim guꞌ bax mat kaꞌ na jax jaꞌk jir am na pim tuiꞌñgɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Baꞌp kaiꞌch am: ―¿Jax jap baꞌ duukat puiꞌch chɨtda na puiꞌ cham jaroiꞌ jich aꞌmkam aaꞌndaꞌ nach bha nɨidhidhaꞌ na jax jich chɨɨdaidhaꞌ? Nach guꞌ aach pui miꞌ puiꞌ tu daaꞌñchuꞌ na jax tu jimdat guch boxii kat Abraam, cham tuꞌ jaroiꞌ bha nɨidhim ich. ");
INSERT INTO stpNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Baꞌp ja tɨtda gu Jesuus: ―Tuꞌ sɨlhkam jañ yaꞌ jam aagiꞌñdhaꞌ, bɨɨx guiꞌ nam jɨꞌk jum uaꞌtulhiꞌñ, dhiꞌ kat puiꞌ bam kaiꞌch nam dai pɨx bha nɨidhim gu uaꞌtulhdharaꞌ na mu jaꞌk ja tukgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jaꞌp na jax gu jaroiꞌ noꞌ miꞌ paiꞌ pɨx tu juan buiñor maaꞌn gux chumñigam, na pɨx bha nɨidhidhaꞌ noꞌ pui mamka na tuꞌ kaꞌm tu juanaꞌ. Noꞌ guꞌ cham ka mamka, dho guꞌ dai dho na ba jimiaꞌ kiaꞌmiꞌñ. Piam noꞌ guꞌr maraaꞌn, cham paiꞌ jimiaꞌ dho, sia ku cham ka jaiꞌch na tuꞌm kaꞌm tu juanaꞌ, na guꞌr miꞌ kam kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Guꞌ baꞌ gu xib noꞌ pim moox aaꞌndaꞌ gɨt na pim cham bhaan kam tutkagiꞌñkaꞌ gu jam uaꞌtulhdharaꞌ, piam na pim baꞌ cham mu jaꞌk ka nɨidhidhaꞌ, jam aꞌm jum aaꞌ na pim soiꞌñ chɨɨdaꞌ aañ nañ jir Maraaꞌn gu Dios nañ baꞌ jam boosgaꞌ miꞌ dhɨr jix chu tukgam kɨr na pim paiꞌp tuꞌiiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jix maat iñ dho nar jam boxii kat gu Abraam, ku pim ji guꞌx chu chiañik ji nam jiñ muꞌaaꞌ, na pim guꞌ cham kaim nañ jɨꞌk jax tu jam aꞌgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Sia ku tɨi dai nañ jɨꞌk jax nɨiꞌñ gio na jax jiñ chɨɨdaim guñ Gɨꞌkoraꞌ nañ tu jam aꞌgiꞌñ, jaꞌp xi dhuukat japim pɨx ji guꞌ, na guꞌ aapiꞌm dai mu jaꞌk kaichuꞌ gu jam taat. ");
INSERT INTO stpNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Baꞌ bhaiꞌ ji ñio mɨt, jup kaiꞌch am: ―¿Jaroo gi baꞌp jir jich chaat? Abraam dho. Baꞌp ja tɨtda gu Jesuus: ―Noꞌ baabuiꞌ Abraam jir jam taat kaꞌ gɨt, miꞌ puiꞌ jiimdaꞌ pim gɨt ji na jax tu jimdat. ");
INSERT INTO stpNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tɨɨꞌ na pim baꞌ guꞌx chu chiañik nam jiñ muꞌaaꞌ sia kuñ tɨi tu aꞌgim na jax pɨx jiñ chɨɨdaim gu Dios. Jax dhui na guꞌ Abraam cham tuꞌ puiꞌ tomaatɨt na jax aapiꞌm. ");
INSERT INTO stpNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Na guꞌ kaiꞌñkam aapiꞌm dai na pim mu jaꞌk kaichgɨt miꞌ puiꞌ tu daaꞌñchuꞌ jia na jax tu jim gu jam taat. Baꞌp tɨtda am: ―Jix maat ich dho ɨp na jaroiꞌr jich chaat, cham tuꞌ nach moor saiꞌ chɨr kam. Dios dhor jich chaat. ");
INSERT INTO stpNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Baꞌp ja tɨtda gu Jesuus: ―Matgam noꞌ Dios jir jam taat kaꞌ gɨt, xiñ kɨɨgalhiꞌñdhaꞌ pim gɨt ji, na ñich guꞌ aañ bhammɨ dɨr bha jii na paiꞌp tuꞌiiꞌ. Cham tuꞌ nañ dɨɨlh pɨx ya jaꞌp jimdat puiꞌ ba tu jam aꞌgidhim, guꞌ jaꞌpji gu Dios nat bhañ joot. ");
INSERT INTO stpNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Guꞌ aapiꞌm jaꞌp jum aaꞌ nañ pɨx jap kaiꞌchim, puiꞌ ku pim baꞌ cham maatɨt jiñ kɇɇ nañ jax tu jam aꞌgiꞌñ, na pim guꞌ cham xim gaꞌnga na jax jir jum duukam. ");
INSERT INTO stpNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Na guꞌ aapiꞌm jaꞌook jir jam taat, jaꞌp moo gu tuꞌx matgam, puiꞌ ku pim baꞌ mu jaꞌk kaichgɨt puiꞌp tu buim na jax jam tɨɨdaim. Na guꞌ gu jaꞌook bɨjɨk dɨr pur tu muaꞌkam nat dɨr maaxir, cham paiꞌ dhuuk miꞌ puiꞌ jim na jax jir am, gam na giilhim jix iatbiꞌ tuꞌ na pɨx bhaan. Cham paiꞌ dhuuk sɨlhkam tu aꞌga, dhiꞌr maꞌooꞌn gu iatdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Guꞌ baꞌ aañ nañ tɨi sɨlhkam tu aꞌga, cham jiñ jɨɨgiꞌñ japim. ");
INSERT INTO stpNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Aañ japim paa duuk jiñ ñɨiꞌñ na ñich tuꞌ jax ba duu na cham jir am, nar uaꞌtulhdharaꞌ? ¿Piam aa na guꞌ cham? Nañ guꞌ aañ sɨlhkam tu aꞌga, guꞌ ji na pim guꞌ cham tɨ jɨɨgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Na guꞌ cham tuꞌ Dios jir jam Gɨꞌkoraꞌ, puiꞌ ku pim baꞌ cham kaim. Guꞌ matgam gu jaroiꞌ noꞌ moo sɨlhkam Dios jir Gɨꞌkorgaꞌn, jix kaim kaꞌ ji gu ñioꞌkiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Baꞌ bhaiꞌ ji ñio mɨt gu gɇꞌgɇrkam Israel kam, jup tɨtda am gu Jesuus: ―Xib jachich dho gi baꞌ ampɨx jix bhaiꞌ maat ji nap jir Samaaria kam gio nam aꞌm tɨ nɨidhim gu jaꞌook. Tɨɨꞌ nap jax kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Baꞌp ja tɨtda gu Jesuus: ―Jaꞌpji dai nañ gammɨjɨ daan guñ Gɨꞌkoraꞌ, cham tuꞌ ji na tuꞌ jaꞌook jiñ aꞌm tɨ nɨidhim. Guꞌ ji na pim guꞌ aapiꞌm cham tuꞌ kaꞌm jiñ ñɨiꞌñ, giilhim pɨx kaiꞌchdhaꞌ pim. ");
INSERT INTO stpNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ku guꞌ aañ cham tuꞌ ji nañ jix aagɨt jup kaiꞌch na pim jiñ dhaandaꞌ, guꞌ jaꞌpji guñ Gɨꞌkoraꞌ nax aaꞌ na pim jiñ bui tu daandaꞌ, na guꞌ guiꞌ noꞌt jax ba tɨi, jir puiꞌ kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌ, gu jaroiꞌ noꞌ miꞌ puiꞌ ba jimchuꞌ nañ jɨꞌk jax tu aꞌga, cham ka tu mumkɨdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Baꞌ gio bhaiꞌp ji ñio mɨt gu gɇꞌgɇrkam Israel kam, jup kaiꞌch am: ―¡Jaiñ dho pɨk tuꞌ aaꞌch ji na jaꞌook jum aꞌm jup tuiꞌdhiꞌ! Tɨɨꞌ nat baꞌ gu Abraam muu noꞌ baabuiꞌ, gio gu jaiꞌ nam bhaankamuꞌn jup tu aꞌgimɨk guch Gɨꞌkoraꞌ. Puiꞌ pɨx jup koi mɨt, guꞌ aap jax ɨlhdhat puiꞌch chɨtda nap baꞌp kaiꞌch: “Gu jaroiꞌ noꞌ miꞌ puiꞌ ba jimchuꞌ nañ jɨꞌk jax tu aꞌga, cham ka tu mumkɨdaꞌ.” ");
INSERT INTO stpNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Giilhim gɇꞌkam tu tatdaꞌ aa panaas? Cham tuꞌ puiꞌ na jax guch boxii kat Abraam nat puiꞌ pɨx jup muu, gam gu jaiꞌ nam bhaankamuꞌn tɨip tu aꞌgimɨk guch Gɨꞌkoraꞌ na mɨt puiꞌ pɨx jup koi. Guꞌ aap chi baꞌ pɨk, jɨɨꞌx jup tɨɨꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Baꞌp ja tɨtda gu Jesuus: ―Kux baꞌ noꞌ guꞌ aañ dɨɨlh pɨx ya jaꞌp tu aꞌgadaꞌ gɨt nañ puiꞌ kaiꞌchdhaꞌ nañ jir gɇꞌkam, ¿tuꞌ gi miꞌp jum nɨnɨiꞌñ? Guꞌ jaꞌpji gu Dios na pim aapiꞌm jaroiꞌ aaꞌ na puiꞌ tɨip jir jam Gɨꞌkoraꞌ na puiꞌ ja mattuꞌn gu jaꞌtkam nañ jaꞌxbuiꞌp jir gɇꞌkam na dɨɨlh. ");
INSERT INTO stpNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ku guꞌ aapiꞌm cham maat ji nañ jir tuꞌp tuꞌm daꞌ, na pim guꞌ cham xim gaꞌnga na jax jaꞌk jix aaꞌ. Aañ dho gi guꞌx bhaiꞌx maat ji, nañ guꞌ miꞌ puiꞌ tu buim na jax pɨx jiñ chɨɨdaim. Noꞌñ guꞌ jax kaiꞌchdhaꞌ gɨt nañ cham maat, jaꞌp dho pɨx ba ji buusandaꞌ iñ gɨt na jax aapiꞌm na pim giilhim jix iatbiꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Matgam noꞌ pim miꞌ puiꞌ jiimdaꞌ gɨt na jax jir am, jix bhaiꞌm ɨlhdhaꞌ pim gɨt ji na ñich yaꞌ ba ai, jaꞌp na gu Abraam nat jix bhaiꞌm ɨlh nat paiꞌ dhuuk maat nañ puꞌñi gatuuk bha jim. ");
INSERT INTO stpNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Baꞌp tɨtda am gu gɇꞌgɇrkam Israel kam: ―¡Jɨɨ, saak jap baꞌ pɨn cham iatdaꞌ tu aꞌga! ¿Jax jap baꞌ duukat jup nɨiꞌñ gu Abraam? Nap guꞌ chakui jɨꞌk gook ooꞌm daman mambhɨɨx oidhaꞌ biaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Baꞌp ja tɨtda gu Jesuus: ―Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌ, bɨɨpɨꞌ dɨr pux jaiꞌch iñ aañ nat baꞌ gu Abraam yaꞌ maaxirɨk gio cham jup ka jaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Baꞌ giilhim bhaak jamɨt nat puiꞌ xi ja tɨɨꞌn. Jotmodaꞌ tɨi uꞌaam jamɨt gu joodai nam sap kɨꞌn maꞌyasai muꞌaaꞌ gɨt. Guꞌ ji nat guꞌ mɨjɨ jaꞌp xi baa jaꞌtkam tɨr gu Jesuus, pu jii miꞌ dhɨr gɇꞌ chiop. Mi jaꞌp ba buus ja saagiꞌñ, gammɨjɨ ji dhuu. ");
INSERT INTO stpNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Baꞌ nammɨ gama jaꞌk na ba jimchuꞌ gu Jesuus, ba tɨɨ maaꞌn gu maaꞌnkam cham ñia kam na mi jaꞌp daa, na dɨɨlh pur pu chuꞌm nat dɨr maaxir. ");
INSERT INTO stpNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Baꞌ xi chɨkka am gu noonbiꞌñ, jup tɨtda am: ―Jiñ jaduuñ, ¿dɨɨlh aam uaꞌtulh dhi jaduuñ nat baꞌ cham ñia kam maaxir, kaꞌ gu gɨꞌkorgaꞌn aa? ");
INSERT INTO stpNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Baꞌ gu Jesuus jup ja tɨtda: ―Cham tuꞌ ji na tuꞌ ja uaꞌtulhdharaꞌ gu gɨꞌkorgaꞌn puiꞌ dhuuk am dhiꞌ, nix chuꞌ gu dɨɨlh uaꞌtulhdhargaꞌn. Jaꞌpji nat puiꞌ jaꞌk pu duu gu Dios na baꞌ gatuuk duaꞌñdhaꞌ na bhaan matgilhiaꞌ na cham tuꞌ xijaichuꞌn na pu tu duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Baꞌñ aꞌm jum aaꞌ nañ xip tu buimɨi nat jɨꞌk jax jiñ chɨɨꞌn guiꞌ nat bhañ joot, kapbhaiꞌ na kax chu maax, na guꞌ noꞌ bax chukgam, cham jax kax bhaaiꞌn kaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na guꞌ xib nañ maaxik yaꞌ ka oirɨ dhi oiꞌñgaꞌn bhaan, joidham gɇꞌ tanoor iñ na kɨꞌn jix chu maax kɨr bap tuiꞌñgɨdaꞌ gu jaroiꞌ noꞌ moox aaꞌndaꞌ gɨt. ");
INSERT INTO stpNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Baꞌ puiꞌ xi chɨꞌɨɨk mi jaꞌp xi xixbuk dɨbɨɨr taꞌm palhɨɨp xi dhaꞌmunak bhaiꞌ xi juulh buupuiram gu cham ñia kam. ");
INSERT INTO stpNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Miꞌ dhɨr baꞌp tɨtda: ―Xib jap baꞌ xim ikoimdharaꞌ gum buibas muni Siloe, na paiꞌ kolhbixdhix gu suudaiꞌ. ―Siloe jaꞌp kaiꞌñkam jup jum kaiꞌch nat jumai mu jootsak. Baꞌ mam ikoimdham gu cham ñia kam mu na paiꞌ tu aagiꞌñ gu Jesuus. Joidham bhaiꞌ ji ñiata nat jax jum ikoim, jix kɨɨꞌ mummu jaꞌk ba ai kiaꞌmiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Baꞌp kaiꞌch am gu mi jaꞌp oiꞌñkam gio guiꞌ nam mu jaꞌp ka nɨiꞌñdhaꞌ na cham ñia kam mi jaꞌp daakat ka tu taandaꞌ gu tuumiñ nam onbaiꞌñdhaꞌ: ―¿Cham aar diꞌ gu yaꞌni kiokam nax joiꞌñdhaꞌ na mi jaꞌp daakat ka ja taandaꞌ gu jaꞌtkam gu tuumiñ? ");
INSERT INTO stpNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Baꞌ jɨꞌmaꞌn jup kaiꞌch am: ―Dhiiꞌ dhor diꞌ. Guꞌ ji nam guꞌ jaiꞌ cham tɨ jɨɨgiꞌñ nar diꞌ, jup kaiꞌch am: ―Jir jumai ji dhiꞌ, guꞌ ji na guꞌ pu chuꞌm jup tɨ nɨiꞌñ. Baꞌ dɨɨlh jup ba tu aaꞌ guiꞌ na cham ñia kat, jup kaiꞌch: ―Aañiꞌ dhor diꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Baꞌx bhaiꞌ bhaiꞌ ji chɨkka mɨt, jup tɨtda am: ―¿Guꞌ jax baꞌ moo duuk joidham jup ba ji dhudua dhim buupui nap cham ñia kat? ");
INSERT INTO stpNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Baꞌ guiꞌp ja tɨtda: ―Dho maaꞌn gu jaduuñ guiꞌ na saak Jesuus tɨɨꞌ nat jaꞌp jix bhaiꞌ dhuu nat jiñ dhuaꞌñ. Mi jaꞌp pɨx xi xixbuk dɨbɨɨr taꞌm palhɨɨp xi dhaꞌmunak yaꞌ xiñ juulhdhak jiñ buupui am jup jiñ chɨtda: “Xim ikoimdhamɨr baꞌ xib muni Siloe.” Aañ baꞌ mu jimɨɨk jup xiñ ikoim, pu joidham bhaiꞌ ji ñiata ñich. ");
INSERT INTO stpNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Baꞌ giop xi chɨkka am, jup tɨtda am: ―¿Paa baꞌ jaꞌk bhɨi nach machiaꞌ nar jaroiꞌ dhaꞌ? Baꞌ guiꞌ na cham ñia kat jup ja tɨtda: ―Dho cham maat iñ nat pa jaꞌk bhɨi. ");
INSERT INTO stpNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Miꞌ dhɨr baꞌ nam miꞌ puiꞌ xi kaiꞌchimɨk, ba baidhak jamɨt guiꞌ na cham ñia kat bhammɨ nam paiꞌp tuꞌiiꞌ guiꞌ nam pariseos jum tɨɨtɨꞌndaꞌ, ");
INSERT INTO stpNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","nam guꞌx maat na janoꞌ cham tum juandaꞌ nat paiꞌ dhuuk duaꞌñ gu Jesuus, nat palhɨɨp xi dhaꞌmunak gu dɨbɨɨr chiñborgaꞌn kɨꞌn bhaiꞌ xi juulh buupuiram. ");
INSERT INTO stpNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Baꞌ na mɨt bhammɨ ba aich ja bui gu pariseos, bhaiꞌ ji chɨkka mɨt ɨp nat jax dhuuk dua na cham ñia kat. Baꞌ guiꞌp ja tɨtda: ―Dho dai nat palhɨɨp xi dhaꞌmunak gu dɨbɨɨr yaꞌ xiñ juulh jiñ buupui am guiꞌ nañ jaroiꞌ ba aaꞌ, gio baꞌ na ñich xiñ ikoimdham, pu joidham bhaiꞌ ji ñiata ñich na pim jax bañ ñɨiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Baꞌ miꞌ ba ji ñiokbo mɨt dɨɨlh gu pariseos, jɨꞌmaꞌn jup kaiꞌch am: ―Cham ji nach ɨlhiiꞌñ nat Dios bha joot gu jaroiꞌ nat puiꞌ duaꞌñ dhich jaduuñ, na baꞌ cham tuꞌ kaꞌm nɨiꞌñ na paiꞌ dhuuk cham tum juan. Jaiꞌ maakam bhaiꞌp ji chɨi mɨt, jup kaiꞌch am: ―¿Guꞌ baꞌ ɨlhiiꞌñ japim aa na gu jax chuꞌm jaꞌppɨx maaꞌnkam jix uaꞌtulhdhix kam puiꞌp ba tu buadaꞌ na tuꞌr jix bhaiꞌm duukam? Baꞌ miꞌ puiꞌ xi kaiꞌchimɨk cham maaꞌn ñiꞌook kap duuk am. ");
INSERT INTO stpNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Baꞌ xi chɨkka am ɨp gio guiꞌ na cham ñia kat, jup tɨtda am: ―¿Aap gi jax ɨlhiiꞌñ jiñ jaduuñ? ¿Tuꞌ chir jup tuꞌm daꞌ gu jaroiꞌ nat puiꞌm duaꞌñ nap cham ñiakat? Baꞌ guiꞌp ja tɨtda: ―Aañ ɨlhiiꞌñ na dhiꞌ bhaankamuꞌn jup ba tu aꞌga guch Gɨꞌkoraꞌ jaꞌp na jax saak gu bɨjɨk dɨr kam nam bhaankamuꞌn tu aꞌgimɨk. ");
INSERT INTO stpNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Guꞌ ji na guꞌ gu gɇꞌgɇrkam Israel kam cham tɨ jɨɨgiꞌñ am na dhiꞌr diꞌ guiꞌ na cham ñia kat, na guꞌx kɨkɨɨꞌ gu buupuiꞌñ nam bhaiꞌ xi nɨiꞌñ. Puiꞌ mɨt ma tu ja joochxi gu gɨꞌkorgaꞌn nam mu jiimdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Baꞌ guiꞌ muiꞌp ma jii mɨt. Baꞌ na mɨt bhammɨ ba ai, ba ja tɨkka am, jup ja tɨtda am: ―¿Dhiꞌñi aar diꞌ gu jam mar nat saak cham ñia kam maaxir na pim jup kaiꞌchdhaꞌ? ¿Jax dhuuk dua? ");
INSERT INTO stpNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Baꞌ bhaiꞌ ji ñio mɨt gu gɨꞌkorgaꞌn, jup kaiꞌch am: ―Dho guꞌ jax gip biaꞌ ich nach tɨꞌyaꞌ, nach guꞌx maat na dhiꞌr jich mar nat cham ñia kam maaxir. ");
INSERT INTO stpNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Guꞌ nat jax dhuuk jum kɨɨꞌñdha, cham bhaaiꞌ ji nach jax dhui jax aagiꞌñdhaꞌch jaaduñ, noꞌt jaxjɨ jaroiꞌ duaꞌñ nat baꞌ bhaiꞌ jim kɨkgidha gu buupuiꞌñ, cham jach dho baꞌ maat. Jix maat ji dɨɨlh na pim xi chɨkkaꞌ na jam aagiꞌñdhaꞌ, na guꞌ bar gɇꞌ maaꞌnkam juraaꞌn biaꞌ kam. ");
INSERT INTO stpNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Baꞌ dhiꞌ nam puiꞌ jɨꞌ kaiꞌch gu gɨꞌkorgaꞌn, nam jix ja ɨɨbhiꞌñ gu gɇꞌgɇrkam Israel kam, nam guꞌ bɨɨpɨꞌ dɨr pu puiꞌ ba tɇ kɇɇ nam sap jup kaiꞌchdhaꞌ nam cham ka doꞌñchoꞌ gu jaroiꞌ na mu bakiaꞌ nam paiꞌ jax tu daandaꞌ noꞌ jax kaiꞌch na gu Jesuus jir diꞌ guch Xoiꞌkam. ");
INSERT INTO stpNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Puiꞌ kum baꞌp kaiꞌch pɨx: “Jix maat ji dɨɨlh na pim xi chɨkkaꞌ, na guꞌ bar gɇꞌ maaꞌnkam juraaꞌn biaꞌ kam.” ");
INSERT INTO stpNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Baꞌ xi baidhak jup tɨtda am ɨp gio guiꞌ na cham ñia kat: ―Xi chum uañdhaꞌ ap buiñor gu Dios na pich ba dua, cham tuꞌ gu jaroiꞌ buiñor nat puiꞌ panaas jum duaꞌñ. Nach guꞌ aach jix maat nat giilhim bam uaꞌtulh guiꞌ gu maaꞌnkam. ");
INSERT INTO stpNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Baꞌ bhaiꞌ ji ñio guiꞌ na cham ñia kat, jup ja tɨtda: ―Aañ cham jup maat ji noꞌx uaꞌtulhdhix, daipuꞌ ji nañ jix maat nañ aañ cham ñia kat. Xib jix kɨkɨɨꞌ guñ buupui nat jiñ dhuaꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Baꞌ gio bhaiꞌp ji chɨkka mɨt, jup tɨtda am: ―¿Jax moo duuk jum duaꞌñ? ¿Jax bhaiꞌ ji chu duu na baꞌ bax kɨkɨɨꞌ dhim buupui? ");
INSERT INTO stpNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Baꞌ guiꞌp ja tɨtda ɨp gio: ―Dho gi nañ guꞌ tɨi ba jam aagiꞌñ, guꞌ ji na pim guꞌ cham jiñ jɨɨgiꞌñ. ¿Kaꞌ na pim jix aaꞌ aa na pim tɨ jɨɨꞌñdhaꞌ buiñor ku pim baꞌx aaꞌ nañ pɨx mu dɨr bhaiꞌ ji kɨksadaꞌ nañ jam aagiꞌñdhaꞌ? ");
INSERT INTO stpNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Baꞌ pɨx am bhaak jamɨt nat puiꞌ xi ja tɨɨꞌn, giilhim tɨtda am na jax cham jir am kat nam tɨɨdaꞌ, jup kaiꞌch am: ―Aap chi noꞌp jix aaꞌ jia nap mu jaꞌk kaichgɨdaꞌ gum bɨɨm tuꞌm. ¿Jaroo gip jum daaꞌ siap mu kaichuꞌ? Aach nach guꞌ miꞌ puiꞌ tu daaꞌñchuꞌ nat jax tu uaꞌnak gu Moisees, ");
INSERT INTO stpNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","nach guꞌx maat nat Dios bha ñioꞌkdhak na baꞌ bhaankamuꞌn tu aꞌgimɨk. Guꞌ guiꞌ gu maaꞌnkam, pu cham maat ich ji na paiꞌ dhɨr jaꞌk jimdat ya jaꞌp pu tu buim. ");
INSERT INTO stpNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Baꞌp ja tɨtda: ―Jaꞌp moo joidham cham jum ɨlhdham jup bañ dhuaꞌñ jia gu jaduuñ, sia ku pim cham maat na paiꞌ dhɨr jaꞌk jim. Tɨɨꞌ nax kɨkɨɨꞌ xib guñ buupui. ");
INSERT INTO stpNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","¿Jax japim baꞌ duukat maakam ɨlhiiꞌñ? ¿Jax dhui moo joidham jup ba ji palhbuidhaꞌ gu Dios gu jaroiꞌ noꞌx uaꞌtulhdhix, sia ku tɨi xi ɨlhiiꞌñ nap tu duñiaꞌ gu tuꞌ nar jix bhaiꞌm duukam? Dai noꞌ tuꞌ kaꞌm nɨiꞌñ gu Dios gio noꞌ miꞌ puiꞌ jimchuꞌ na jax jix aaꞌ na baꞌ puiꞌ ji chu buusnichgɨdaꞌ na jax ɨlhiiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","¿Paa gi dhuuk jaroiꞌ mu paiꞌ pɨx ba kaidhaꞌ nat ba duaꞌñ gu jax chuꞌm cham ñia kam? ");
INSERT INTO stpNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Guꞌ dhiꞌx maatɨꞌ ji nat Dios bha joot. ¿Jax dhui puiꞌp ba tu buidhaꞌ gɨt noꞌ dɨɨlh pɨx? ");
INSERT INTO stpNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Baꞌ bhaiꞌ ji ñio mɨt gu gɇꞌgɇrkam, jup tɨtda am: ―¿Guꞌ aap ba ɨlhiiꞌñ aa nap yaꞌ bach aagiꞌñdhaꞌ nach jax jaꞌk tuiꞌñgɨdaꞌ na pich pux uaꞌtulhdhix kam maaxir? Puiꞌ xi chɨɨdak gammɨjɨ xi joot jamɨt. ");
INSERT INTO stpNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Baꞌ nat puiꞌ ba tɨ kai gu Jesuus na mɨt maiꞌ joot guiꞌ nat duaꞌñ na cham ñia kat, ma gaagam. Nammɨ gama jaꞌk tɨɨgɨk jup tɨtda: ―¿Tɨ jɨɨgiꞌñ ap aa buiñor gu Maraaꞌn gu Dios? ");
INSERT INTO stpNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Baꞌp kaiꞌch guiꞌ na cham ñia kat: ―¿Jaroo gi dhaꞌ? Noꞌ pich iam jiñ aaꞌñ jiñ jaduuñ nañ baꞌ tɨ jɨɨꞌñdhaꞌ buiñor. ");
INSERT INTO stpNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Baꞌ gu Jesuus jup tɨtda: ―Aañiꞌ dhor diꞌ nañ yaꞌ tum aꞌgiꞌñ. Xib japich baꞌ bañ maat. ");
INSERT INTO stpNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Baꞌ guiꞌ na cham ñia kat nat jax oꞌlhiaꞌn kɨꞌn kɨkbuk jup tɨtda: ―Tɨ jɨɨgiꞌñ iñ dho bɨɨx jiñ jur kɨꞌn aap jum bui. ");
INSERT INTO stpNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Baꞌ miꞌ dhɨr jup tɨtda gu Jesuus: ―Dho guꞌ aañ bhaiꞌ pɨx ja mattudam ji gu jaꞌtkam yaꞌ dhi oiꞌñgaꞌn nam jax chuꞌm miꞌ puiꞌ jiim na jax jix aaꞌ guñ Gɨꞌkoraꞌ gio guiꞌ nam jax chuꞌm cham miꞌ puiꞌ jiim, nam baꞌ bhaiꞌ ji chɨ tɨgiaꞌ guiꞌ nam cham ñiññia. Guꞌ baꞌ guiꞌ nam puiꞌm aaꞌ nam jix ñiññia, naiꞌ ji chutkiaꞌ gu ja buupui. ");
INSERT INTO stpNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Baꞌ jɨꞌmaꞌn gu pariseos nam mi jaꞌp guꞌkat kɇɇ nat puiꞌ jɨꞌ tɨi gu Jesuus, jup tɨtda am: ―¿Aach jap bɨɨx jich aagɨt jup kaiꞌch nach cham ñiññia? ");
INSERT INTO stpNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Baꞌ gu Jesuus jup ja tɨtda: ―Noꞌ pim aapiꞌm cham ñiññia kaꞌ gɨt, cham tuꞌ kuiñcha biaꞌkaꞌ pim gɨt ji kɨꞌn gu jam uaꞌtulhdharaꞌ. Guꞌ ji na pim guꞌp kaiꞌch na pim jix ñiññia, giilhim jix uꞌuaꞌtulhdhix japim. ");
INSERT INTO stpNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Baꞌp ja tɨtda gu Jesuus: ―Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌñ jaaduñ, gu jaroiꞌ noꞌt cham miꞌ dhɨr mu baa na paiꞌ kiidhaꞌ gu ja chikiir gu kakasnir, noꞌt guꞌ jaꞌp dɨr jaꞌk mu baa, dhiꞌr diꞌ kaꞌ gux ɨxkum na miꞌx chɨ ɨɨxdham kaꞌ gu kakasnir nam mi kuup. ");
INSERT INTO stpNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Guꞌ noꞌt miꞌ dhɨr jaꞌk mu baa na paiꞌ kiidhaꞌ gu ja chikiir, dho gi guꞌr diꞌ kaꞌ ji gu bipiaꞌdam guiꞌ na jaroiꞌ ja nuukaꞌn, ");
INSERT INTO stpNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","na guꞌx maatɨt nɨiꞌñdhaꞌ guiꞌ na miꞌ tu nuukaꞌndaꞌ na paiꞌ kiidhaꞌ gu chikiir noꞌr diꞌ gu bipiaꞌdam, piam ku guꞌr jumai. Baꞌ dai na ba ja kupioꞌkdhaꞌ gu kakasnir noꞌ guꞌr dhiꞌ, guiꞌ baꞌ dai na pɨx ji ja baidhaꞌ nam jax chɨɨꞌ bɨɨx jɨꞌmaꞌn gu kakasnir tugiꞌñ. Baꞌ pɨx muiꞌp ji bubuakiaꞌ am, nam guꞌx maatɨt kaayaꞌ na dhiꞌr diꞌ guiꞌ na gammɨjɨ ja bipiaꞌdaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Miꞌ dhɨr baꞌ nam paiꞌ dhuuk bɨɨx mu bubuakiaꞌ, dai na bɨɨpɨꞌ muiꞌ xi jimiaꞌ gu bipiaꞌdam paiꞌ na jaꞌk jix ja biaꞌram kaꞌ na joidham jix xaꞌiiꞌ, gu kakasnir tugiꞌñ baꞌ dai nam gatuuk dɨr pɨx miaꞌn bhɨɨyaꞌ nam mu oidhaꞌ, nam guꞌx dhaandaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Dai noꞌr jumai gu bipiaꞌdam dho gi guꞌ cham jɨꞌxdhaꞌ mu oidhaꞌ am dho gi ji sia kut mi ɇɇk tɨi ja baidhim, piam ku gamaiꞌ tɨi ja sasdaꞌ. Pu jiboiꞌññiaꞌ am dho totdonɨi nam guꞌx ɨɨbhiꞌñdhaꞌ na cham jir diꞌ kaꞌ guiꞌ na gammɨjɨ ja bipiaꞌdaꞌ, nam guꞌx maatɨt kɇɇkɇꞌ nar jumai kaꞌ na paiꞌ dhuuk tɨi xi ja baiꞌñdhaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jaꞌpni tu ja aꞌgi gu Jesuus gu jaꞌtkam bhaan ji uaꞌrgidhak gu kakasnir, guꞌ ji na mɨt guꞌ pu cham maatɨt kai na gu jaꞌtkam ja aagɨt jup kaiꞌch, nam puiꞌ ji buan na gu kakasnir. ");
INSERT INTO stpNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Baꞌp ja tɨtda ɨp gio gu Jesuus: ―Tuꞌ sɨlhkam jañ yaꞌ pu jam tɨɨdaꞌ, aañ jir diꞌ gu kiꞌñgob bhaiꞌ nam paiꞌ dhɨr mu baapak gu kakasnir mɨjɨ jaꞌk ja chikiir am. ");
INSERT INTO stpNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Dai guiꞌ na mɨt bɨɨpɨꞌ yaꞌ tɨi ai dho gi guꞌr diꞌ am ji gux ɨꞌxkum nam ɨlhdat nam tɨ ɨɨxdhaꞌ gɨt gu kakasnir, guꞌ ji na mɨt guꞌ cham jax ja dooda. ");
INSERT INTO stpNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Guꞌ xib aañ jir diꞌ ji gu kiꞌñgob bhaiꞌ na paiꞌ dhɨr mu tum bapkɨ mɨjɨ jaꞌk ɨrban dɨr, na baꞌ gu jaroiꞌ noꞌt jum guguuxdhak bhaiꞌ dhɨr mu baa dhiꞌ bhaan gu kiꞌñgob, joidham jix bhaiꞌ ba tu jimiaꞌ, na guꞌ bhaan ba tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ. Jaꞌp ji buusniaꞌ na jax maaꞌn gu kasnir na buusaidhai mɨjɨ dɨr chikiir tɨr gu bipiaꞌdam ba biaꞌraꞌ paiꞌ na joidham jix xaꞌiiꞌ kaꞌ, na baꞌx kɨɨꞌ kaꞌ jix dhuakam. ");
INSERT INTO stpNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Guꞌ matgam guiꞌ nañ ja aaꞌ nam jaꞌp ji buan na gux ɨꞌxkum na mɨt bɨɨpɨꞌ yaꞌ tɨi ai, jaꞌp ji buus ji na mɨt bha ja koodam gu jaꞌtkam gam na mɨt bha tu ja ɨɨxdham. Guꞌ aañ matgam bha jii ji yaꞌ dhi oiꞌñgaꞌn bhaan nañ yaꞌ ja palhbuidhaꞌ gu jaꞌtkam, nañ ja aagiꞌñdhaꞌ nam jax jaꞌk duñiaꞌ nam baꞌ xib dɨr gammɨjɨ pu ba duduakaꞌ gu ja iꞌiiꞌmdaꞌ bhaan, na guꞌ ja aꞌm tɨ nɨidhidhaꞌ guñ Gɨꞌkoraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Aañ jir diꞌ pɨx ɨp gux kɨɨꞌ bipiaꞌdam nañ gammɨjɨ ba ja nuukaꞌndaꞌ guñ kakasniraꞌ, cham jax bua sia ñich puiꞌ ma muu nañ tɨi pup xi ja palhbuidhimɨi noꞌt tuꞌ ba ji ja oi. ");
INSERT INTO stpNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Cham tuꞌ puiꞌ na jax gu jaroiꞌ noꞌ umuaꞌñdhix pɨx na tu bipiaꞌdaꞌ, siam tɨix bhaiꞌ namkidhat chian na ja nuukaꞌndaꞌ gu kakasnir. Bɨɨpɨꞌ kat dho miꞌ dhɨr ji dhaiꞌññiaꞌ noꞌ muiꞌ ba jim gu bhan piam gu sɨɨꞌ. Cham ja joiꞌndai miꞌ xi ja iabui gu kakasnir, na guꞌ cham jir dɨɨlh gaꞌn kaꞌ. Gu bhan baꞌ dai na ba ja daꞌngiaꞌ jɨꞌk na ɨlhiiꞌñdhaꞌ, jaiꞌm pu paiꞌ nam jaꞌk boopoyaꞌ totdonɨi. ");
INSERT INTO stpNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na guꞌ guiꞌ na puꞌñi umuaꞌñdhix kaꞌ pɨx, cham tuꞌ jaꞌxbuiꞌ puiꞌ ja daꞌdaꞌ gu kakasnir na jax guiꞌ na dɨɨlh jir kakasnir tugiꞌñ kaꞌ. Puꞌñi dho baꞌ na bɨɨpɨꞌ kat ba jimiññolhiaꞌ noꞌt miꞌ ba ai gu sɨɨꞌ piam gu bhan. Tuꞌ gi na guꞌ bhaan pɨx maiꞌchɨkdaꞌ gu tuumiñ. ");
INSERT INTO stpNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Guꞌ aañ matgam tuꞌ sɨlhkam ji nañ jir jix kɨɨꞌ bipiaꞌdam, cham jum aaꞌ na jaroiꞌñ ñamkiꞌñdhaꞌ. Jix bhaiꞌx ja mat kaꞌ iñ ɨp guiꞌ nam jɨꞌk jir jiñ kakasniraꞌ kaꞌ, gio guiꞌ mu dɨr bha jaꞌk puiꞌx bhaiꞌp xiñ mat kaꞌ am. ");
INSERT INTO stpNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jaꞌp na guñ Gɨꞌkoraꞌ nat bhañ joot na guꞌx bhaiꞌ xiñ maat aañ, gio aañ yaꞌ dɨr mu jaꞌk puiꞌx bhaiꞌp jix maat. Aañ baꞌ puꞌñix bhaiꞌp jix ja mat kaꞌ guiꞌ nam jɨꞌk bañ kaichuꞌ nam jaꞌp ji buan nam jir jiñ kakasniraꞌ, gam nañ jix ja joiꞌndat jix ja daꞌdaꞌ. Puiꞌ kuñ baꞌñ guguuxiꞌñ nañ mukiaꞌ ja aꞌmkam. ");
INSERT INTO stpNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ku guꞌ cham tuꞌ daipuꞌ jaꞌkbuiꞌñi pɨx am ji guiꞌ nam jaꞌp ji buan nam jir jiñ kakasniraꞌ nañ jɨꞌk ja biaꞌ xib, jaiꞌ pup ka jaiꞌch am ji matgam gu jaꞌtkam nam puiꞌp ji buan nam jir jiñ kakasniraꞌ, nam guꞌ puiꞌp ba tɨ jɨɨꞌñdhaꞌ aañ jiñ bui. Dai ji na ñich chakui yaꞌ ja aich jiñ chikiir am, kuñ ji guꞌ ka ja saaꞌnmɨraꞌ ji nañ maap ja bɨɨndaꞌ dhi jaiꞌñ kakasniraꞌ. Maaꞌn kap jañ baꞌ pɨx ba ja kukpadaꞌ, nañ guꞌ aañ dɨɨlh bar bipiaꞌdam kaꞌ xib dɨr. ");
INSERT INTO stpNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Baꞌ guñ Gɨꞌkoraꞌ gɇꞌkam kɨꞌn xiñ dhaꞌdat xiñ kɨɨgalhiꞌñ nax bhaiꞌm taat nañ aañ dɨɨlh boiñ bhɨichdhaꞌ ja aꞌmkam gu jaꞌtkam, gio nax maat nañ muukɨi duadɨi giop bamgiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ku guꞌ aañ chakui jaroiꞌñ muꞌaaꞌ ji gu dɨɨlh pɨx noꞌñ aañ cham aaꞌ, guꞌ jaꞌpji aañ dɨɨlh nañ ba xi chuñ maakim nam boiñ bhɨichdhaꞌ. Mukiaꞌ iñ ja aꞌmkam gu jaꞌtkam, miꞌ dhɨr jañ giop bamgiaꞌ duadɨi, nat guꞌ puꞌñi jaꞌk jiñ chɨɨdak bhañ joot guñ Gɨꞌkoraꞌ nañ tu duñiaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Baꞌ gu gɇꞌgɇrkam Israel kam cham maaꞌn ñiꞌook kap duuk am na mɨt puiꞌ jɨꞌ kai na kaiꞌch gu Jesuus, nam guꞌ jaiꞌ dhɨt tɨi pɨx am tɨ jɨɨgiꞌñ. ");
INSERT INTO stpNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Jaiꞌ guꞌx bhaamut pɨx kɇɇ am ji, jup kaiꞌch am: ―Chaꞌpim mi kɇɇkɇꞌ dhi maaꞌnkam. Naas ku tuꞌr jix kɨɨꞌ. Bhaan baax ji dhiꞌ gu cham kɨɨꞌ iiꞌmdaꞌ. Tɨɨꞌ na jax pɨk jix ñaanbim kaiꞌch. ");
INSERT INTO stpNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Guꞌ ji nam guꞌ jaiꞌp kaiꞌch: ―¿Kux baꞌ puiꞌ jaꞌk jup tu aꞌgadaꞌ aa gu jaroiꞌ noꞌ cham kɨɨꞌ iiꞌmdaꞌ bhaan jup tuiꞌdhiꞌ? ¿Cham aa guꞌ maakam tu aꞌgadaꞌ gɨt noꞌ puiꞌ? ¿Jax ji na baꞌ guꞌ dhiꞌ daix bhaiꞌm duukam bhaan tu aꞌga, gio na ja duduadhiꞌñ gu cham ñiññia kam? ");
INSERT INTO stpNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Baꞌ janoꞌ na paiꞌ dhuuk bax jɨɨpdhardaꞌ, ma tu piastatat jamɨt gu Israel kam jaꞌtkam bhammɨ Jerusaleen, nat guꞌ giop bam ai nam paiꞌ dhuuk piastatuꞌn gu gɇꞌ chiop bhaiꞌ nam paiꞌ dhɨr tu daan, nam bhaan tɨꞌñchokaꞌ janoꞌ na mɨt paiꞌ dhuuk tɨɨmu na mɨt kɨi. ");
INSERT INTO stpNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Baꞌ gu Jesuus am pɨk bhɨjɨp ka oirɨ bhaiꞌ na paiꞌ ɨrdiꞌchim tu kuup bɨɨx xikoolh dhɨr gu gɇꞌ chiop na paiꞌ tɨm jɨppiꞌñ, nam Salomoon gaꞌn jix mat kaꞌ gu jaꞌtkam. ");
INSERT INTO stpNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Baꞌ gu gɇꞌgɇrkam Israel kam miꞌ ji sooꞌmdhak bhaiꞌ ba tɨkka am gu Jesuus, jup tɨtda am: ―Gi noꞌp jup bach aagiꞌñ noꞌp aap jir diꞌ guch Xoiꞌkam na saak bha jimdaꞌ. ¿Jɨꞌx jach baꞌ mɨk jup ka tɨ nɨɨraꞌ nach baꞌ pɨk ba machiaꞌ? Kuch cham tuꞌ bhaan ka tɨtɨɨꞌñchokaꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Baꞌ gu Jesuus jup ja tɨtda: ―Dho gi nañ guꞌ tɨi bɨjɨk dɨr pu chuꞌm ba tu aꞌga, jaꞌpji na pim guꞌ aapiꞌm cham jiñ jɨɨgiꞌñ. Nɨiꞌñ japim ɨp nañ jix bhaiꞌm duukam jup tu bua bhaankamuꞌn guñ Gɨꞌkoraꞌ. ¿Kux cham aa dhiꞌ puiꞌ kaiꞌñkam bap jum kaiꞌch? ");
INSERT INTO stpNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Guꞌ ji na pim guꞌ aapiꞌm cham tɨ jɨɨgiꞌñ sia kuñ tɨi jam nɨiꞌñchudat jup tu bua na tuꞌr jix bhaiꞌm duukam, na pim guꞌ cham tuꞌr dhiꞌ guiꞌ nam jaꞌp ji buan nam jir jiñ kakasniraꞌ. ");
INSERT INTO stpNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Guꞌ matgam guiꞌ ji nam jɨꞌk tɨ jɨɨꞌñdhaꞌ aañ jiñ bui nam baꞌ puiꞌ ba ji bubuakiaꞌ nam bar jiñ kakasniraꞌ, pux maatɨt jiñ kaayaꞌ am ɨp noꞌñ ba ja baiꞌñ, nam guꞌx bhaiꞌ xiñ mat kaꞌ, gio aañ yaꞌ dɨr mu jaꞌk puiꞌx bhaiꞌp jix ja mat kaꞌ, baꞌ dai nam gammɨjɨ bañ kaichgɨdaꞌ miꞌ puiꞌ jiimɨt. ");
INSERT INTO stpNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aañ baꞌ miꞌ dhɨr xi ja aaꞌñdha