﻿USE sofia;
DROP TABLE IF EXISTS sofia.stb_vpl;
CREATE TABLE stb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES stb_vpl WRITE;
INSERT INTO stb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Giin nini su dlistaan nu nga gepu'an ni Jesus Christ, neg Bata' dlai ni David; bu' si David gasal ni Abraham. ");
INSERT INTO stb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6a","Buwat ni Abraham tampan ni Gari' David, giin nini su nga dlistaan nu nga gepu'an: Si Abraham, giin su gama' ni Isaac; bu' si Isaac, giin su gama' ni Jacob; bu' si Jacob, giin su gama' ni Judah bu' nu ngak pateren; bu' si Judah mikepengesawa riin ni Tamar bu' duuni ngag bata' nilan ne gilan si Perez bu' si Zera; bu' si Perez, giin su gama' ni Hezron; bu' si Hezron, giin su gama' ni Ram; bu' si Ram, giin su gama' ni Aminadab; bu' si Aminadab, giin su gama' ni Nahason; bu' si Nahason, giin su gama' ni Salmon; bu' si Salmon mikepengesawa riin ni Rahab bu' sug bata' nilan si Boaz; si Boaz, giin su gama' ni Obed bu' su gina'en si Ruth; si Obed, giin su gama' ni Jesse; bu' si Jesse, giin su gama' ni Gari' David. ");
INSERT INTO stb_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","Buwat ni David tampan sek pekpe'awa' se nga getaw Israel tu se dlugar nilan pagaw tu seng nasud neg Babilonia, giin nini su nga dlistaan nu nga gepu'an: Si David, giin su gama' ni Solomon bu' su gina'en sawa nud diin ni Urias; bu' si Solomon, giin su gama' ni Rehoboam; bu' si Rehoboam, giin su gama' ni Abias; bu' si Abias, giin su gama' ni Asa; bu' si Asa, giin su gama' ni Jehosafat; bu' si Jehosafat, giin su gama' ni Joram; bu' si Joram, giin su gama' ni Usias; bu' si Usias, giin su gama' ni Jotam; bu' si Jotam, giin su gama' ni Ahas; bu' si Ahas, giin su gama' ni Hesekias; bu' si Hesekias, giin su gama' ni Manases; bu' si Manases, giin su gama' ni Amos; bu' si Amos, giin su gama' ni Josias; bu' si Josias giin su gama' ni Jeconias bu' nu ngak pateren. ");
INSERT INTO stb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Dluwat sek pekpepe'awa' se nga getaw Israel tu seg Babilonia tampan migegetaw si Jesus, giin nini su nga dlistaan nu nga gepu'an: si Jeconias, giin su gama' ni Salatiel; bu' si Salatiel, giin su gama' ni Zorobabel; bu' si Zorobabel, giin su gama' ni Abiud; bu' si Abiud, giin su gama' ni Eliakim; bu' si Eliakim, giin su gama' ni Asor; bu' si Asor, giin su gama' ni Zadok; bu' si Zadok, giin su gama' ni Akim; bu' si Akim, giin su gama' ni Eliud; bu' si Eliud, giin su gama' ni Eleazar; bu' si Eleazar, giin su gama' ni Matan; bu' si Matan, giin su gama' ni Jacob; bu' si Jacob, giin su gama' ni Jose neg bana ni Maria. Si Maria giin su gina' ni Jesus ne giningelanan neng Misiyas. ");
INSERT INTO stb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aas duunik sepulu' bu' paat ne nga gesalan buwat riin ni Abraham tampan ni David. Bu' duun remaik sepulu' bu' paat ne nga gesalan buwat riin ni David tampan sek panahun ne su nga getaw Israel pipe'awa' tu se dlugar nilan pagaw tu seg Babilonia bu' duunik sepulu' bu' paat ne nga gesalan buwat sek pekpe'awa' se dlugar nilan pagaw tu seg Babilonia tampan migegetaw sung Misiyas. ");
INSERT INTO stb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na, maa' nini suk pebiyan sek pegegetaw ni Jesus Christ. Si Maria ne gina'en pengesuwaan na ni Jose. Se genda' ilan pa pektipung, mitindawan ni Maria neng migberes giin pebiyan se Gispiritu Santu. ");
INSERT INTO stb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mbuus, si Jose keni suk pemenaan ni Maria, metareng ini ne getaw bu' ndi'en liyagan ne mpiiran si Maria ri se dlaun ne getaw. Aas migena'ena' giin neg belengen si Maria ne ndi' mekpesuun. ");
INSERT INTO stb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Saanay pigena'ena' pa ini ni Jose, enlengay niyu, sug anghel ne Ginu'u pebiyan sek teginepen mikpe'ita' ri seniin, laungen, “Jose, gasal ni David, ndi'a mendek sek pekpengesawa riin ni Maria ay sug bineresen buwat se Gispiritu Santu. ");
INSERT INTO stb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bu' megbata' giin ne dlai bu' ingelanay mu sug bata' neg Jesus, tendeng ay luwasenen su nga getawaan buwat ri se ngak sala' nilan.” ");
INSERT INTO stb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na, mihitabu' ini arun metuman suk tinalu' ne Ginu'u pebiyan sek propeta, neng miktalu', ");
INSERT INTO stb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Enlengay niyu, sud delaga ne genda' pa mayan me'ilebetay megberes, bu' megbata' giin ne dlai. Bu' bata' keni ingelanan neg Emmanuel” ne su guluganen, “Sud Diwata duma senita.” ");
INSERT INTO stb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Rayun sek peketanud ni Jose, pingesawaan si Maria sumala' sek tinalu' nug anghel ne Ginu'u ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ma'ad nda'en ilebetay si Maria tampan nda' ini pegbata' ne dlai. Bu' iningelanan ini ni Jose neg Jesus. ");
INSERT INTO stb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na, migegetaw si Jesus tu se dlunsud neg Bethlehem sakup nek probinsiya seg Judea, sek panahun ketu si Herodes giin su gari'. Enlengay niyu, se nda' mpayat, duuni ngang me'alam neg buwat sek Sebangan neng minateng tu seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Miksaaksaak ilan, “Ta' ma sug bata' neng mi'etaw ne gari' ne ngag Judeo? Mi'ita' nami sug bituunen ritu sek sebangan bu' mirini ami arun sek peksimba ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na, sek pekerengeg run nini ni Gari' Herodes, migulesan giin bu' su dlaun ne nga getaw sek tibuuk neg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Bu' tinipungen su dlaun ne nga geseg nu ngak pari' bu' su ngang mentetendu' se Kesugu'an; bu' sinakaan ilan bu' ta' rapit mi'etaw sung Misiyas. ");
INSERT INTO stb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Miksembag ilan, “Ditu se dlunsud seg Bethlehem, sakup seg Judea, ay giin nini suk sinulat nek propeta: ");
INSERT INTO stb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Gamu ne nga getaw seg Bethlehem, riin se dlugar neg Judah, suk siyudad niyu gena' neng miika' kampuun se nga gembagel ne ngak siyudad seg Judah; ay buwat riin seniyu duunik tumuwa' ne geseg neng medlegeseg ri se nga getawan'u, sek tribu neg Israel.’” ");
INSERT INTO stb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aas pitawag ni Herodes su ngang me'alam neg buwat sek Sebangan, ma'ad inilem ni Herodes suk pekpetawag senilan. Bu' ritu misuunaan su ginsaktu nek panahun sek peksebang nug bituun. ");
INSERT INTO stb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Rayun piperituun ilan seg Bethlehem, miktalu' giin, “Penlaang amu bu' tumbayay niyu penengaway sug bata'. Bu' seng me'ita' na niyu giin, pesuun niyau rema arun merituu sek peksimba ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Aas sek pekerengeg nilan run suk tinalu' ne gari', minlaang ilan. Saanay nilan menlaang, enlengay niyu, mi'ita' nilan sug bituun neng mi'ita' nilan ritu sek Sebangan. Pidleliyag ilan gupiya. Miguna senilan sug bituun tampan mikeneng tu sed ditaas neng mi'imetangan nug bata'. ");
INSERT INTO stb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sek pekseled nilan tu seg balay, mi'ita' nilan sug bata' duma su gina'en ne si Maria, bu' middempug ilan sek peksimba ri seg bata'. Rayun, pinuka nilan su ngag begay nilan bu' binegay nilan tu seg bata' sug bulawan, ginsinsu, bu' mira. ");
INSERT INTO stb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Minuli' ilan rayun tu seng nasud nilan pebiyan tu se dlain ned dalan tendeng ay pinegulan ilan ned Diwata pebiyan sek teginepen ne ndi' ilan na mpuli' tu ni Herodes. ");
INSERT INTO stb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na, seng mikedlaang ilan na, enlengay niyu, sug anghel ne Ginu'u mikpe'ita' tu ni Jose pebiyan sek teginepen, laungen, “Pipenengaw na ni Herodes sug bata' arun petain. Aas pegbuwat'a, uwit mu sug bata' bu' su gina'en, bu' pedlaguy amu tu seg Ehipto, bu' pekpebilin amu ritu tampan telu'an'u dya'a neng megawa'.” ");
INSERT INTO stb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aas migbuwat si Jose bu' inuwiten sug bata' bu' su gina'en bu' migawa' ilan sek panahun ne gebii pagaw tu seg Ehipto. ");
INSERT INTO stb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bu' mikengel ilan ritu tampan minatay si Herodes. Giin nitu su ketumanan sumala' sek tinalu' nu Ginu'u pebiyan ri sek propeta, neng miktalu', “Tinawag'u sug Bata'u buwat seg Ehipto.” ");
INSERT INTO stb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Rayun si Herodes, seng misuunaan nek pigbelusan giin nu ngag bisita buwat sek Sebangan, linengetan gupiya giin. Bu' miksugu' giin nek pemetain su dlaun ne nga gembata' ne dlai tu seg Bethlehem bu' sek silingan ne nga dlugar. Su giddad ne nga gembata' nek pemetain buwat sed duwa' taun pebaba' sumala' seng misuunaan buwat tu se ngang me'alam metendeng sek panahun neng mituwa' sug bituun. ");
INSERT INTO stb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Seng maa' nini nek pebiyan, mituman suk tinalu' ni propeta Jeremias neng miktalu', ");
INSERT INTO stb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ritu seg Rama, duuning mirengeg nek peksegaw bu' gembagel ne kegu'ul. Miksegaw si Rachel tendeng ri se nga gembata'en. Ndi' gaid giin meliyag pengemu'en tendeng ay su nga gembata'en mimatay na.” ");
INSERT INTO stb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na, seng minatay na si Herodes, sug anghel nu Ginu'u mikpe'ita' ri ni Jose ritu seg Ehipto pebiyan sek teginepen, ");
INSERT INTO stb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","bu' miktalu' sug anghel, “Buwat'a, uwit mu sug bata' bu' su gina'en, bu' puli' amu tu se dlupa' seg Israel, ay sung miktinguha' sek pekpatay ri seg bata' minatay na.” ");
INSERT INTO stb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aas migbuwat si Jose, bu' inuwiten sug bata' bu' su gina'en, bu' mipuli' ilan tu seg Israel. ");
INSERT INTO stb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma'ad sek pekerengeg run ni Jose ne si Arkilaw sung midlegari' seg Judea teles ri ni Herodes ne gama'en, minendek si Jose neng mekengel ritu. Bu' sek pinegulan giin puli' pebiyan sek teginepen, miritu na ma'ad si Jose sek probinsiya ne Galilea, ");
INSERT INTO stb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","bu' sek pekerepet nilan ritu, mikengel ilan tu se dlunsud ne giningelanan neng Nazaret. Aas, mituman na suk tinalu' nu ngak propeta nud diin, “Tuwagen giin nek taga Nazaret.” ");
INSERT INTO stb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na, se nga gendaw ketu, minateng si Juan neng Membebendyag ritu se kemingawan seg Judea bu migatad sek pekpenintulu', ");
INSERT INTO stb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","miktalu' giin, “Peddiksu' amu bu' teliyuray niyu su ngak sala' niyu tendeng ay megaud na suk pedlegeseg ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan su ginasuy ni propeta Isaias sek pektalu'en, “Duuning migbeksay tu se kemingawan, ‘Andam niyu sud dalan para se Ginu'u; Baal niyu neng meleddeng sug biyanan para seniin.’” ");
INSERT INTO stb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Suk suub ni Juan binaal buwat seg bembul ne kamelyo; bu' duunik panit neg binaling riin se gawaken bu' su gaanen ngad dulun bu' teneb. ");
INSERT INTO stb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Rayun minditu seniin su dlaun ne nga getaw neg buwat seg Jerusalem bu' sek tibuuk probinsiya neg Judea, bu' nga getaw neg buwat se nga dlugar nek pelibut seg Bagel tubig neg Jordan. ");
INSERT INTO stb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Middiksu' ilan ri se ngak sala' nilan, bu' binendyagan ilan ni Juan tu seg Bagel tubig neg Jordan. ");
INSERT INTO stb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sek pekiita' ni Juan run neng melaun se ngak Pariseo bu' se ngak Saduceo neng miritu arun mekpebendyag, miktalu' giin tu senilan, “Gamu maa' ne ngang mekelala ne ngang mamak! Ta' maing minegul ri seniyu neng mekedlaguy amu sek silut ned Diwata nek pawiten riin seniyu? ");
INSERT INTO stb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Aas megbaal amu neng melengas arun me'ita' neng middiksu' amu bu' tineliyuran niyu su ngak sala' niyu. ");
INSERT INTO stb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bu' ndi' amu pegena'ena' ne ndi' amu silutan ned Diwata tendeng ay gasal amu ni Abraham. Ay telu'an'u amu ne sud Diwata mekegbaal isan se ngag batu keni ne mbaal ne nga gasal ni Abraham. ");
INSERT INTO stb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sug wasay andam na para petel ri se nga ganget ne nga gayu. Aas su kada gayu ne ndi' mekepemunga seng mekelengas neg bunga petelen bu' pidlaken tu se gapuy. ");
INSERT INTO stb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Bendyagan'u amu riin sek tubig sek pekpe'ita' neng middiksu' amu bu' tineliyuran niyu su ngak sala' niyu. Ma'ad suk sala tawan neng mateng neng meksunud ri senaan ge'eman pa kampuun ri senaan. Ndi'u mbaya' isan sek pekpitang ri se ngak sandalyasen. Megbendyag giin ri seniyu se Gispiritu Santu bu' gapuy. ");
INSERT INTO stb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Migawid giin neg betang sek pempalis arun painen su nga dlegas buwat se nga gepis ri se giniikan. Bu' tigumenen su ngang melinggas nek trigu ritu sek tibengaan, ma'ad su nga gepis serengenen tu se gapuy ne ndi' na mpaleng!” ");
INSERT INTO stb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Rayun, si Jesus migbuwat se Galilea bu' miritu ni Juan tu seg Bagel tubig neg Jordan arun mekpebendyag. ");
INSERT INTO stb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma'ad si Juan migbelibad sek pektalu', “Gaku' ma ngani' su gembaya' neng mekpebendyag riin seni'a. Tumu' mirinia ma senaan.” ");
INSERT INTO stb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma'ad si Jesus miksembag, “Pesaddan mu na ma'ad, tendeng ay giin nini su gembaya' ta baalen arun metuman su dlaun nek sinugu' ned Diwata.” Rayun miliyag si Juan. ");
INSERT INTO stb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tubus mbendyagay si Jesus, kinumawas rayun giin tu sek tubig. Bu' mipuka rayun su dlangit para seniin, bu' mi'ita'en su Gispiritu ned Diwata neng mikpebaba' neng maa' nek selepati bu' minapun ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Rayun, duunik talu' neg buwat se dlangit laung, “Giin nini suk pinetail'u neg Bata'. Pidleliyagu gupiya ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mbuus inuwit si Jesus ne Gispiritu Santu tu se kemingawan arun tintalen nek Penulay. ");
INSERT INTO stb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sek peketubus mekpu'asa ni Jesus seled se gepaat pulu' endaw bu' gebii, miperii' giin. ");
INSERT INTO stb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bu' suk Penulay mikpegaud ri seniin bu' miktalu', “Bu' dya'a sug Bata' nud Diwata, sugu' mu ngag batu keni ne mbaal nek pan.” ");
INSERT INTO stb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma'ad miksembag si Jesus, “Misulat ini se Kesulatan, ‘Su getaw ndi' metubu' ri sek pan na run, bu' ndi' se kada nek talu' nek tinalu' ned Diwata.’” ");
INSERT INTO stb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mbuus inuwit giin nek Penulay tu seg Jerusalem, sug Bala'an nek Siyudad, bu' pi'indeg ni Satanas si Jesus tu se kinetaasan neg bahin sek Templo. ");
INSERT INTO stb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Bu' tinelu'aan si Jesus, “Bu' dya'a sug Bata' nud Diwata, sampak'a tu sek silung, ay misulat ini ri se Kesulatan neng miktalu': ‘Sugu'en nud Diwata su ngag anghelen sek pegingat seni'a, bu' sampenain'a nilan isan su geksud mu, ndi' tanan mesugat ri se ngag batu.’” ");
INSERT INTO stb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Miksembag si Jesus, “Misulat rema ini se Kesulatan, ‘Ndi' mu tintalay su Ginu'u ned Diwata mu.’” ");
INSERT INTO stb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mbuus inuwit na pelun nek Penulay si Jesus tu seng metaas gupiya neg bentud, bu' pi'ita' seniin su dlaun ne ngak pedlegeri'an ri sek tibuuk benwa bu' su nga kega'em nilan. ");
INSERT INTO stb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Bu' si Satanas miktalu' tu seniin, “Begay'u ri seni'ai dlaunen keni bu' meddempug'a bu' sumimbaa ri senaan.” ");
INSERT INTO stb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Miksembag si Jesus, “Pelayu'a ri senaan Satanas! Ay misulat ini ri se Kesulatan, ‘Simba mu su Ginu'u ned Diwata mu bu' Giin da gairik penibeliyan mu!’” ");
INSERT INTO stb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Rayun suk Penulay migawa' ri seniin, bu' rayun minateng su ngag anghel bu' inatiman nilan giin. ");
INSERT INTO stb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na, sek pekerengeg run ni Jesus neng miperisu si Juan, migawa' giin se Galilea. ");
INSERT INTO stb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nda' giin pekengel tu seng Nazaret ma'ad ritu giin mikengel se Capernaum. Dlunsud keni riin se geksid sed Danaw ne Galilea, neng misakup ri se nga dlugar sek Zabulon bu' Neptali. ");
INSERT INTO stb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mihitabu' ini arun metuman suk tinalu' ni propeta Isaias: ");
INSERT INTO stb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Penginengeg amu, nga getaw ri se nga dlugar nek Zabulon bu' Neptali, ned diin se geksid sed danaw bu' dipag seg Bagel tubig neg Jordan! Penginengeg amu nga getaw nek sakup se Galilea, ne ritu mikengel su nga getaw ne gena' Judeo. ");
INSERT INTO stb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Isan su nga getawan niyu mikengel riin se kereleman, mikiita' ilan seng mesanag gupiya ne kerelaag. Isan mikengel ilan ri seng merelem ne dlupa' se kemetain, su kerelaag sumanag riin senilan.” ");
INSERT INTO stb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Gatad rayun sek panahun ketu, si Jesus migatad sek pekpenintulu' neng miktalu', “Peddiksu' amu bu' teliyuray niyu su ngak sala' niyu tendeng ay megaud na mateng sud Diwata neng medlegari' riin senita.” ");
INSERT INTO stb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na, saanay medlaang ni Jesus tu se geksid ned Danaw ne Galilea, mi'ita'en ritu sud duwa' tawan neng mekpated ne si Simon ne iningelanan rema nek Pedro bu' si Andres nek pateren. Minlaya ilan ritu sed danaw ay mengenginsera' ilan ma. ");
INSERT INTO stb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Miktalu' si Jesus tu senilan, “Dunut amu ri senaan. Tendu'an'u amu sek peguwit ne nga getaw sinangkali' sek pedlaam ne ngak sera'.” ");
INSERT INTO stb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Rayun se nda'i dlangan, bineleng nilan su nga dlaya nilan bu' middunut ilan ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bu' buwat ritu, mikpeddayun si Jesus sek pedlaang, bu' se gunaan mi'ita'en sung mekpated ne si Santiago bu' si Juan, ne nga gembata' ni Zebedeo. Ritu ilan sek sekayan nilan duma nu gama' nilan, neng migandam ne nga dlaya nilan. Tinawag ni Jesus sung mekpated, ");
INSERT INTO stb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","bu' nda'i dlangan, bineleng nilan suk sekayan bu' su gama' nilan, bu' middunut ilan riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Aas linaup rayun ni Jesus suk tibuuk Galilea sek pekpenendu' ri se ngak pektipungan ne nga getaw Judeo, sek pekpenintulu' se Gempiya ne Gesuyen metendeng sek pedlegari' ned Diwata, bu' sek pekpetelen se dlaun ne nga dleruun ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Seng maa' nini, midlelaup sud dengegaan ri seng nasud nek Syria. Aas inuwit nu nga getaw tu seniin su dlaun ne ngang minlaru, su dlaun neng midlainlain ne ngang megeel bu' migantus seng melebiyan ne kegeel: su ngak pige'eman seng melaaten ne gispiritu, su ngak pegbauyen, bu' su ngak paralitiku—bu' pitelen ni Jesus su dlaun nilan. ");
INSERT INTO stb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bu' melauni nga getaw neng midlendug ri seniin buwat se Galilea, buwat sek Sepulu' ne nga Dlunsud, buwat seg Jerusalem, buwat seg Judea, bu' sed duma pa ne nga dlugar buwat sed dipag neg bagel tubig seg Jordan. ");
INSERT INTO stb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na, sek pekiita' run ni Jesus sek panen ne nga getaw, tinumuwad giin tu seg bentud, ne ritu giin migingkud. Miktipung su ngak tinu'unaan ri sek timala'en, ");
INSERT INTO stb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","bu' migatad giin sek pektendu' senilan: ");
INSERT INTO stb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Pedleliyagen su ngak pupus ri se ngag betang ne gispirituhanen, tendeng ay me'angken nilan suk pedlegeseg ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Pedleliyagen su nga getaw ned diin se kegu'ul, tendeng ay pengemu'en ilan ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Pedleliyagen su nga getaw neng mekpebaba', tendeng ay mekerawat ilan sek pengumpiya nek sinaad ned Diwata riin senilan. ");
INSERT INTO stb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Pedleliyagen su nga getaw neng miktinguha' sek pektuman ri sed Diwata, tendeng ay petekenen ilan ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Pedleliyagen su nga getaw neng melilelaaten tendeng ay lelaatan ilan rema ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Pedleliyagen su nga getaw ne dlimpiyu suk pengena'ena' nilan, tendeng ay mekiita' ilan ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Pedleliyagen su nga getaw neng megbaal nek pema'agi para se kelinaw tendeng ay tuwagen ilan ne nga gembata' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pedleliyagen su nga getaw nek pinlutus sek pegbaal neng metareng, tendeng ay misakup ilan ri sek pedlegeseg ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Pedleliyagen amu gupiya bu' mektalu' ilan neng melaat riin seniyu bu' lutusen amu bu' pengumbaalan amu ne gena' metuud tendeng ay miksunud amu ri senaan. ");
INSERT INTO stb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pedleliyag amu tendeng ay gembagel su ganti niyu ritu se dlangit. Ay seng maa' run nek pebiyan, linutus rema ne nga getaw su ngak propeta nud diin.” ");
INSERT INTO stb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gamu maa' neng maasin para riin se nga getawan. Ma'ad bu' sung maasin merala' sung nanamen, ndi' na mpuli' su kepaiten. Nda' na gairik paluun, aas pidlaken na ma'ad ini bu' pegindegindegan ne nga getaw.” ");
INSERT INTO stb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Gamu maa' rema ned delaag ri seg benwa. Suk siyudad neng mi'imetang riin sed dibabaw neg bentud ndi' gaid me'edlud. ");
INSERT INTO stb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nda'iruni getaw neng mektutud nek sulu' bu' tekepan nini ri se gamang. Tumu' betangenen nini riin sek pengenturan arun mekegbegay ini ne kerelaag ri se kada sala ri seg balay. ");
INSERT INTO stb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Seng maa' run rema nek pebiyan, pegbegay amu ne kerelaag ri se dlaun ne getaw arun me'ita' nilan su ngang mekelengas ne ngak pimbaal niyu bu' siya'en nilan su Gama' niyu tu se dlangit.” ");
INSERT INTO stb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ndi' niyu pegena'ena'ay neng miriniu arun dela'en'u su Kesugu'an ni Moses bu' su ngak tinendu' nu ngak propeta. Nda'u perini arun dela'en ini ma'ad sek pektuman riin senilan ne nga ketendu'an. ");
INSERT INTO stb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pegena'ena' niyu gupiya, isan me'alep ma su dlangit bu' su dlupa', mekpebilin gaid isan sung miika' gupiya ne dlitra awas kudlit riin se Kesugu'an. Su dlaun neng misulat ri se Kesugu'an keni kina'enlan metuman. ");
INSERT INTO stb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Aas isan ta' ne getaw neng medlapas isan se dlabi neng miika' se nga kesugu'an bu' mektendu' run nini tu se nga getaw sek pedlapas, giin suk tinawag ne dlabi ne gembaba' tu sek pedlegeseg ned Diwata. Ma'ad su isan ta' neng miktuman bu' miktendu' tu se nga getaw sek pektuman rema run nini, giin suk tinawag ne gembagel tu sek pedlegeseg ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Telu'an'u amu, mekeseled amu ri sek pedlegeseg ned Diwata bu' metinumanen amu pa kampuun ri se ngang Mentetendu' se Kesugu'an bu' ngak Pariseo sek pegbaal se ngak sugu' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Middugang pa gaid si Jesus sek pektalu', “Mirengeg na niyu suk tinalu' nu nga getaw nud diin, ‘Ndi'a mekpatay, ay isan ta' sung mekepatay ukuman giin.’ ");
INSERT INTO stb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma'ad nandaw telu'an'u amu, bu' lengetan amu ri se ngak sementaun niyu, ukuman amu. Bu' telu'an niyu su ngak sementaun niyu ne ‘Kulang suk peme'et mu!’ uwiten amu tu seng metaas ne gukuman nu nga getaw Judeo. Bu' telu'an niyu su ngak sementaun niyu neg, ‘Bural'a!’ mesilutan amu tu se gapuy se gimpirnu. ");
INSERT INTO stb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Aas bu' meghalad'a ritu seg halaran, bu' mbuus me'ena'ena' mu ne sud duma mu ned duuni dlangeten riin seni'a, ");
INSERT INTO stb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bilin mu reli' sug halad mu tu seng metungenga'an neg halaran bu' laway mu reli' giin bu' pegeguli'ay amu. Bu' rayun puli'a arun sek peghalad seg halad mu riin sed Diwata.” ");
INSERT INTO stb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Bu' duuni getaw ne kumiha ri seni'a, meneguli'a reli' tu seniin saanay ndi' amu ruwa' pa merepet tu se gukuman. Ay bu' ritu amu na se gukuman, tudyan'a nu kinumiha ri seni'a tu seng mengengukum, bu' sung mengengukum mektudyan ri seni'a tu sek pulis, rayun perisuun'a. ");
INSERT INTO stb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sek pekemetuud telu'an'u dya'a ne ndi'a gaid mekegawas buwat ritu tampan mekebayad'a sek tampusan nek sala sintabus gisip pesala' seni'a.” ");
INSERT INTO stb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mirengeg na niyu suk tinalu', ‘Ndi' amu menapaw.’ ");
INSERT INTO stb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma'ad nandaw esuyan'u amu, isan ta' neng megenleng tu se dlibun bu' migena'ena' neng melaat, mikepenapaw na giin tu se dlibun riin se gena'ena'en. ");
INSERT INTO stb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na, bu' su dlintu neng mata mu giin sung mekegbaal neng mekesala'a run, esuk mu ini bu' pidlak mu. Maneg pa bu' merala' suk sala neg bahin ne dlawas mu sinangkali' nek pidlaken suk tibuuk ne dlawas mu tu se gapuy se gimpirnu. ");
INSERT INTO stb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bu' su dlintu ne gemeg mu giin sung mekegbaal seni'a sek pekpekesala', petel mu bu' pidlak mu ini. Maneg pa bu' mpetel suk sala ne gemeg mu sinangkali' nek pidlaken suk tibuuk ne dlawas mu tu se gapuy se gimpirnu.” ");
INSERT INTO stb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bu' tinalu' rema, ‘Su dlai neng meleng ri sek sawaan, kina'enlan megbegay giin ri seniin nek sulat nek pesuun sek pegbeleng.’ ");
INSERT INTO stb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma'ad mektalu'u riin seniyu isan ta' neng meleng ri sek sawaan, isan nda' pegbaal neg imural nek pekpekighilawas, giin su getaran neng mekepenapaw suk sawaan bu' mengesawa suk sawaan puli'. Bu' su isan ta' neng mengesawa ri se dlibun neg bineleng, mekepenapaw rema.” ");
INSERT INTO stb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mirengeg rema niyu nek tinelu'an su nga getaw nud diin, ‘Ndi'a menumpa' bu' gena' metuud. Bu' tuman mu gaid bu' menumpa'a tu se Ginu'u.’ ");
INSERT INTO stb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma'ad nemuun telu'an'u amu: ndi' amu na gaid menumpa' bu' meksaad. Ndi' niyu gemitay su dlangit neng menintigus ri seniyu sek pekpenumpa' tendeng ay su dlangit, giin suk trunu ned Diwata; ");
INSERT INTO stb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","awas su dlupa' tendeng ay giin nini suk pigindegan ned Diwata. Bu' sug Jerusalem tendeng ay suk Siyudad neg Jerusalem giinik pidlegesegan nu dlabi Ge'eman ne Gari'. ");
INSERT INTO stb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bu' ndi' niyu rema telu'ay ‘isan matayu pa’ tendeng ay ndi' amu mekepeputi' awas mekepe'item isan sek sala ne dlegas na run ri seg buuk niyu. ");
INSERT INTO stb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Talu' na ma'ad niyu, ‘Wa'a’ bu' wa'a rayun ‘Gena'’ bu' gena'; ay bu' duun pai kapin run nini, ketu buwat na ri seng Menulay.” ");
INSERT INTO stb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mirengeg niyu suk tinalu', ‘Sung mekepedlaat ri seng mata nek sementaunen, pedlaatan rema sung mataan; bu' sung mekepelupu' ri se ngisi nek sementaunen, lupu'en rema su ngisiin.’ ");
INSERT INTO stb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma'ad nemuun telu'an'u amu, ndi' niyu suli'ay su getaw neng mikesala' ri seniyu. Bu' duunik tumampaling ri se dlintu nek sepingi mu, petampaling mu rema seniin sug bibang nek sepingi mu. ");
INSERT INTO stb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bu' duuni kumiha ri seni'a arun me'uwanen suk suub mu, begay mu run asta pa su dlambung mu. ");
INSERT INTO stb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bu' suk sundalu menleges ri seni'a sek pegbaba ri se guwitenen sek sala kilumitru, baba mu itu sed duwa' kilumitru. ");
INSERT INTO stb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Isan ta' neng menengi ri seni'a, begayay mu giin, bu' isan ta' neng meram ri seni'a, peram mu giin.” ");
INSERT INTO stb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mirengeg niyu suk tinalu', ‘Petail niyu su ngak sambat niyu, bu' gemetay niyu su nga kuntra niyu.’ ");
INSERT INTO stb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma'ad nemuun telu'an'u amu, petail niyu su nga kuntra niyu bu' pegempu'ay niyu su ngang midlutus ri seniyu, ");
INSERT INTO stb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","arun mbaal amu ne nga gembata' ne Gama' niyu tu se dlangit. Ay giin sung mikpesebang se gendaun tu se ngang mekelaat ne getaw bu' tu se ngang mekelengas. Bu' giin sung mikpawit ned dupi' tu se ngang megbaal neng metareng bu' tu se gena' metareng. ");
INSERT INTO stb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Gentiyan ba ned Diwata bu' sung mikpetail ri seni'a giin da rema suk petailen mu? Isan su ngang meneningil neg buwis migbaal rema run nini. ");
INSERT INTO stb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Bu' giin rai galimba'en niyu su ngak sambat niyu, mikegbaal amu ba ne dlabaw pa seng mibaal ned duma? Isan su nga getaw ne genda' mekilala ri sed Diwata migbaal rema run nini! ");
INSERT INTO stb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Aas, kina'enlan ne nda'iruni gempemura riin seniyu, maa' ne Gama' niyu tu se dlangit ne genda'iruni gempemura ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pedlekilaaw amu sek pegbaal niyu neng melengas riin seng metungenga'an ne nga getaw para ma'aray sek pekpe'ita' ri senilan seg binaal niyu. Tendeng ay bu' baalen niyu ini, nda'iruning merawat niyu ne ganti buwat se Gama' niyu tu se dlangit.” ");
INSERT INTO stb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Aas bu' megbegay amu ne gabang tu se ngak pupus, ndi' niyu ini pesigarbu maa' nu ngang mikpelaunglaung neng megbaal run nini riin sek seled nek pektipungan ne nga getaw bu' ri se ngag bebiyanan, arun siya'en ilan ne nga getaw. Sek pekemetuud, telu'an'u amu, mirawat na nilan su ganti nilan. ");
INSERT INTO stb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma'ad bu' megbegay amu ne gabang tu se ngak pupus, ndi' niyu ini pesuun isan pa tu sek sambat niyu, ");
INSERT INTO stb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","arun nda'iruning mekesuun ri sek pegbegay mu bu' su Gama' niyu ritu se dlangit neng migenleng ri se dlaun neg binaal niyu, meganti riin seniyu.” ");
INSERT INTO stb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Bu' seng megampu' amu, ndi' niyu baalay sug binaal nu ngang mikpelaunglaung ay liyagan nilan neng megampu' riin se ngak pektipungan nu nga getaw bu' ri se ngak selengayan ne ngad dalan arun me'ita' ilan ne nga getaw. Sek pekemetuud telu'an'u amu, mirawat na nilan su ganti nilan. ");
INSERT INTO stb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma'ad seng megampu'a, sumeled'a ri sed dugu, siraay mu sud dungawan bu' megampu'a tu se Gama' mu ne ndi' me'ita'. Bu' rayun su Gama' mu, neng mikiita' se dlaun neg binaal mu, meganti riin seni'a.” ");
INSERT INTO stb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Bu' seng megampu' amu, ndi' amu pedlegamit seng melaun ne ngak talu' ne nda'irunik paluun, maa' seg binaal nu nga getaw ne nda' mekilala ri sed Diwata. Ay migena'ena' ilan nek sembagen ilan ne ngad diwatadiwata nilan tendeng ay metaas gupiya su ngak pegampu' nilan. ");
INSERT INTO stb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ndi' niyu sunuray sug binaal nilan, ay su Gama' niyu mikesuun na daan se kina'enlanen niyu isan nda' amu pa penengi ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Aas, pegampu' amu seng maa' nini: ‘Gama' nami riin se dlangit, pegbesaan siya sug bala'an ne ngalan mu, ");
INSERT INTO stb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mateng'a siya bu' medlegari'a ri senami, arun mektuman seni'a su kada sala rini seg benwa, maa' rema sek pektuman seni'a ritu se dlangit. ");
INSERT INTO stb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Begay mu senami nandaw sung me'aan nami se gendawendaw. ");
INSERT INTO stb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bu' pasaylu' mu ami ri se ngak sala' nami maa' rema sek pekpasaylu nami tu se ngak sala' nu ngak sementaun nami. ");
INSERT INTO stb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bu' ndi' mu tugut neng metintal ami, ma'ad peneliperay mu ami buwat ri seng Menulay.’ ");
INSERT INTO stb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ay bu' pasayluun niyu su nga getaw neng mikesala' riin seniyu, pasayluun amu rema nu Gama' niyu ned ditu se dlangit. ");
INSERT INTO stb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma'ad bu' ndi' niyu pasayluun su nga getaw riin se ngak sala' nilan, su Gama' niyu ndi' rema mekepasaylu ri se ngak sala' niyu.” ");
INSERT INTO stb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Na, bu' seng mekpu'asaa, ndi'a pegu'ul maa' seg binaal nu ngang mikpelaunglaung, ay pisaddan nilan su gawi' nilan sek pekpe'ita' ri se nga getaw neng mikpu'asa ilan. Telu'an'u amu seng metuud, mirawat na nilan su ganti nilan. ");
INSERT INTO stb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ma'ad seng mekpu'asaa, mengulamus'a bu' menunday'a, ");
INSERT INTO stb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","arun suk pekpu'asa mu ndi' mesuunan ne nga getaw, ma'ad su Gama' ra niyu ne ndi' me'ita'. Giin ra sung mekiita' ri se dlaun neg binaal mu, bu' giin sung megbegay seni'a ne ganti.” ");
INSERT INTO stb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ndi' amu pektigum ne ketigeyunan para se gegulingen niyu rini seg benwa, ay su ganay bu' su ga'ang giin sung mekepedlaat run nini, bu' sumeled ri seg balay su ngang meddaaw, bu' peddaawen nini. ");
INSERT INTO stb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tumu', pektigum amu ne ketigeyunan tu se dlangit, ay ritu nda'iruni ganay bu' ga'ang neng mekepedlaat, bu' nda'iruning meddaaw nek sumeled ri seg balay arun sek peddaaw. ");
INSERT INTO stb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ay ta' ngani' su ketigeyunan niyu, ditu remai gena'ena' niyu.” ");
INSERT INTO stb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Sung mata mu giin suk sulu' ri se dlawas mu. Bu' melengas sung mata mu, merelaagan suk tibuuk ne dlawas mu. ");
INSERT INTO stb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma'ad bu' midlambeng sung mata mu, mereleman suk tibuuk ne dlawas mu. Aas bu' su kerelaag mu merelem, dya'a gaid diin se kereleman.” ");
INSERT INTO stb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nda'iruni getaw neng menibeli ri sed duwa' ne gegalen, ay kuntraanen suk sala bu' petailenen suk sala, awas lebanaan suk sala bu' pemuraanen suk sala. Seng maa' run nek pebiyan, ndi'a mekepenibeli ri sed Diwata bu' sek selapi'.” ");
INSERT INTO stb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Telu'an'u amu, ndi' amu megules metendeng ri se ketubu' niyu, bu' landuni aanen awas inumen niyu; awas landunik suuben niyu. Gena' ba su ketubu' labaw pa kampuun ri se gaan, bu' su dlawas labaw pa kampuun ri sek suub? ");
INSERT INTO stb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Enlengay niyu su ngang manuktalun; nda' ilan pegerek awas pedlegani, awas pektibeng, bu' su Gama' niyu tu se dlangit mikpaan ri senilan. Gena' ba mbagel pa kampuun su dlaga' niyu sinangkali' se ngang manuktalun? ");
INSERT INTO stb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ta' ma ri seniyu nek pebiyan sek pedlegules mekerugang isan sek sala uras na run ri se ketubu'en? ");
INSERT INTO stb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Bu' metendeng ma'ad sek suub, lama medlegules amu run? Enlengay niyu su ngag bulak ri seg binaal bu' pigendun nilan run sek pekpentubu'; nda' ilan pekterbahu awas megabel. ");
INSERT INTO stb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma'ad telu'an'u amu, isan ngani' si Gari' Solomon, sung meratu' gupiya ne gari' nud diin, nda' ngani' giin mekepenuub neng maa' kelengas sek sala se ngag bulak keni. ");
INSERT INTO stb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bu' binegayan ma ngani' ned Diwata ne kelengas su ngak sigbet isan miktetubu' pa numuun bu' pekemanlema' pidlaken tu se gapuy. Na, gamu, ndi' amuun ba mpesuuban? Miika' ra gaid suk pektu'u niyu! ");
INSERT INTO stb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Aas ndi' amu medlegules sek peksaak, ‘Duun baing me'aan ta awas me'inum ta awas suub neng meseluk ta?’ ");
INSERT INTO stb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ay su nga getaw ne nda' mekilala ri sed Diwata midlegules se dlaun ne ngag betang keni; ma'ad su Gama' niyu tu se dlangit mikesuun ne kina'enlanen niyu su dlaun ne ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ma'ad una niyu penengaway suk pedlegari' ned Diwata bu' suk pekemetarengen, bu' dlaun ne ngag betang keni begay ra ri seniyu. ");
INSERT INTO stb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aas ndi' amu medlegules metendeng se dlema', ay su dlema' duuni gegulingenen ne kegulesan. Ndi' na kina'enlan nek penu'an pa niyu su kegulesan neng mateng se kada gendaw.” ");
INSERT INTO stb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ndi' amu pegukum se ngad duma, arun ndi' amu ukuman ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ay ukuman amu ned Diwata neng maa' sek pegukum niyu tu sed duma bu' sukuren amu niin seng maa' sek sukuran ne ginamit niyu tu sed duma. ");
INSERT INTO stb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Na, tuma ma enlengan mu ma sung miika' nek puling ri seng mata nek sementaun mu, ma'ad nda' mu penemba'ay su gembagel ne gayu ned diin seng mata mu? ");
INSERT INTO stb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pegendunen mu run sek pektalu' tu sek sementaun mu, ‘Sambat, uwa'en'u sung mitut nek puling ri seng mata mu,’ bu' duuni gembagel ne gayu ned diin seng mata mu? ");
INSERT INTO stb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Dya'a neng mikpelaunglaung, awa' mu reli' su gembagel ne gayu ri seng mata mu, arun mekelaru mu gupiya sung mitut nek puling ned diin seng mata nek sementaun mu.” ");
INSERT INTO stb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ndi' niyu begay tu se nga gitu' su isan landun neg bala'an neg betang para sed Diwata. Puli'an amu nilan bu' ebuten. Ndi' niyu pidlakay su ngak perlas tu se ngag babuy ay indegindegan ma'ad nilan nini.” ");
INSERT INTO stb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Penengi amu bu' begayaan amu; penengaw amu bu' mbangan niyu; tuwagen niyu sud Diwata bu' pukaanen sud dungawan para seniyu. ");
INSERT INTO stb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ay su kada sala neng menengi, mekerawat; bu' sung mekpenengaw, mekebaang; bu' sung mektawag ri sed Diwata, pukaanen sud dungawan para seniin. ");
INSERT INTO stb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Gamu ne ngang megulang, bu' menengi sug bata' niyu nek pan, begayan ba niyu neg batu? ");
INSERT INTO stb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Awas bu' menengi sug bata' niyu nek sera', begayan ba niyu neng mamak? ");
INSERT INTO stb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Isan sek pekemelaat niyu, metau amu megbegay se ngang mekelengas neg betang tu se ngag bata' niyu. Gendun pa sakan su Gama' niyu tu se dlangit? Megbegay gaid giin se ngang mekelengas ne ngag betang tu se ngang mekpenengi ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Aas, baal niyu tu sed duma su dliyagan niyu neg baalen nilan para riin seniyu. Ay giin nini su gulugan se Kesugu'an ni Moses bu' su nga ketendu'an ne ngak propeta.” ");
INSERT INTO stb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Seled amu riin seng mesikut ne genga'an. Tendeng ay su genga'an pagaw tu se kelaatan meliwag bu' sud dalan pagaw ritu mesayun, bu' melauni nga getaw neng mekuunut tu sed dalan ketu. ");
INSERT INTO stb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma'ad su genga'an pagaw tu se ketubu' mesikut bu' sud dalan pagaw ritu melised, bu' miika' ra su nga getaw neng mekebaang run nini.” ");
INSERT INTO stb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pegbantay amu ri se gena' metuud ne ngak propeta; riin se gawas ne gawi' nilan maa' ne nga karniru ma'ad ri sed diyalem ne gena'ena' nilan, maa' ilan neng mekebelu' ne ngang menanap. ");
INSERT INTO stb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Me'ilelaan niyu ilan pebiyan ri se ngak pimbaal nilan maa' ne gayu neng me'ilelaan pebiyan ri se ngag bungaan. Ay su ngak sebinit ndi' mekepemunga ne nga gubas awas su nga geksam ndi' mekepemunga ne ngag igira. ");
INSERT INTO stb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Su gayu neng melengas, memunga rema ne ngang mekelengas ne ngag bunga, ma'ad su gayu neng melaat mekelaat rema su ngag bungaan. ");
INSERT INTO stb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Sung melengas ne gayu ndi' ini mekepemunga neng melaat ne ngag bunga, bu' sung melaat ne gayu ndi' ini mekepemunga neng mekelengas ne ngag bunga. ");
INSERT INTO stb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Su kada gayu ne ndi' mekepemunga neng mekelengas ne ngag bunga petelen nini bu' pidlaken tu se gapuy. ");
INSERT INTO stb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aas, seng maa' run nek pebiyan, me'ilelaan niyu su nga gena' metuud nek propeta pebiyan ri se ngak pimbaal nilan.” ");
INSERT INTO stb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Gena' su kada sala neng meksabi ri senaan, ‘Ginu'u, Ginu'u’ mesakup tu sek pedlegari' ned Diwata, ma'ad mekeseled su ngang mektuman riin se dliyagan ne Gama'u ned ditu se dlangit. ");
INSERT INTO stb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Seng mateng su Gendaw sek Pegukum, melauning meksabi ri senaan, ‘Ginu'u, Ginu'u’ tendeng ay ri se ga'em ne ngalan mu, pinintulu' nami su ngak talu' ned Diwata, bu' pebiyan ri se ga'em ne ngalan mu, pipe'awa' nami su ngang menulay, bu' migbaal ami seng melaun ne ngang milagru.” ");
INSERT INTO stb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bu' rayun mektalu'u ri senilan, “Nda'u amu me'ilala. Pegawa' amu ri senaan, gamu ne ngang mimbaal neng melaat!” ");
INSERT INTO stb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Aas su isan ta' neng menginengeg bu' mektuman ri se ngak talu'u keni maa' giin nu getaw neng metau gupiya megbaal neg balay ne ginentud ri sek penligen neg batu. ");
INSERT INTO stb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Rayun middupi', bu' migbaa' su nga gembagel nek tinubigan, bu' migenus neng merendes, bu' linumanlag seg balay ketu, ma'ad nda' ini meluwad, tendeng ay mipesekad ini ri seng meligen nek penligen neg batu. ");
INSERT INTO stb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ma'ad suk sala neng menginengeg ri se ngak talu'u keni bu' rayun ndi' mektuman run nini, maa' giin nu getaw neg buralburalen neng migbaal neg balain ri se gelisan. ");
INSERT INTO stb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Seng middupi', bu' rayun migbaa' su ngag bagel tubig, bu' migenus neng merendes, bu' linumanlag ri seg balay ketu, bu' miluwad rayun sug balay bu' nda'iruning mibilin run.” ");
INSERT INTO stb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sek peketubus ini esuyay ni Jesus, mitingala gaid su nga getaw ri sek pekpenintulu'en, ");
INSERT INTO stb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tendeng ay minendu' giin tu senilan ned duuni ketenged gena' maa' nu ngang minendu' ri se Kesugu'an. ");
INSERT INTO stb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Na, seng middiksun si Jesus buwat seg bentud, gembagel nek panen ne nga getaw miksunud ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Enlengay niyu, duuni getaw neng midlaru ri seng mekeendekendek ne dleruun ri sek panit mikpegaud tu seniin bu' middempug sek peksimba ri seng metungenga'an ni Jesus neng miktalu', “Ginu'u, bu' keliyag mu, pe'uli'ay mau.” ");
INSERT INTO stb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Bu' inetat ni Jesus su gemegen bu' inikapen giin, “Liyagan'u,” dayun miktalu', “Me'uli'an'a!” Bu' sek tikmal, mi'uli'an giin ri se dleruunen. ");
INSERT INTO stb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Rayun miktalu' si Jesus tu seniin, “Ndi' mu gaid ini penuntul tu se ngad duma. Peritua sek pari' bu' pe'ita' mu su gegulingen mu, bu' pengilak'a tu sek Templo se gilak nek sinugu' ni Moses, sek pekpemetuud tu se nga getaw neng mi'uli'an'a na.” ");
INSERT INTO stb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Na, sek pekseled ni Jesus tu se dlunsud se Capernaum, miritu seniin suk sala ne geseg sek sundalu ne getaw Roma sek pekpenengi ne gabang. ");
INSERT INTO stb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Miktalu' giin, “Sir, duunik sesugu'en'u neng midlaru tu seg balay, ndi' mekekuleg, bu' migantus gupiya se kegeel ne dleruunen.” ");
INSERT INTO stb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Miktalu' si Jesus tu seniin, “Ala, merituu bu' pe'uli'an'u giin.” ");
INSERT INTO stb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma'ad miksembag seniin su geseg nek sundalu, “Sir, ndi'u mbaya' mekpeperitu seni'a seg balay'u. Talu' mu na run bu' suk sesugu'en'u me'uli'an. ");
INSERT INTO stb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gaku' miriyalem rema sek peddlegeseg se dlabaw'u ne geseg, bu' duun remai ngak sundalu nek pidlegesegan'u. Bu' meksugu'u tu sek sala, ‘Pedlaang'a,’ medlaang rayun ini. Bu' mektalu'u tu sek sala, ‘Perinia,’ bu' merini giin. Bu' mektalu'u tu se gulipen'u, ‘Baal mu ini,’ bu' baalenen ini.” ");
INSERT INTO stb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Na, sek pekerengeg run nini ni Jesus, mitingala giin, bu' miktalu' giin tu se nga getaw neng miksunud ri seniin, “Telu'an'u amu seng metuud, nda'u pa mekiita' isan sala ne getaw Israel neng maa' nini kebagel suk pektu'uun. ");
INSERT INTO stb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Bu' mektalu'u riin seniyu, ne dlema' renlag melaun ne nga getaw neng mateng buwat ri sek sebangan bu' sindepan neng megingkud duma ri ni Abraham, ni Isaac bu' ni Jacob sek pekpengaan ri se kumbira tu sek pedlegari' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma'ad melaun se nga getaw Israel neng misakup ri sek pedlegeri'an ned Diwata ma'ad ndi' ilan mekeritu. Pidlaken ilan tu se kereleman ne ritu ilan mensegaw bu' mengkiget se nga ngisi nilan.” ");
INSERT INTO stb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Rayun miktalu' si Jesus tu se geseg ne ngak sundalu, “Uli'a na bu' baalen'u ini sumala' sek pektu'u mu.” Bu' suk sesugu'enen ritu seg balain mi'uli'an rayun se guras ketu. ");
INSERT INTO stb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Mbuus miritu si Jesus seg balay ni Pedro. Sek peddatengen ditu, mi'ita'en suk penugangan ni Pedro ne dlibun migbelilid neng mipanas. ");
INSERT INTO stb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bu' inuwiran ni Jesus su gemeg nu dlibun bu' mi'uli'an giin ri sek panasen. Migbuwat rayun giin bu' inilakaan neng me'aan si Jesus. ");
INSERT INTO stb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bu' sek pekerelem na, inuwit nilan tu seniin sung melaun ne ngak sineleran neng menulay. Bu' pimbugaun su ngang melaat ne gispiritu pebiyan ri sek pekpemandu'en bu' pi'uli'aan su dlaun neng minlaru. ");
INSERT INTO stb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Binaalen ini arun metuman suk tinalu' ni propeta Isaias, “Giin gaid sung mekpetelen se ngang mekegeel bu' pe'uli'aan su nga dleruun ta.” ");
INSERT INTO stb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na, sek pekiita' ni Jesus seng melaun gupiya ne nga getaw neng midlibut ri seniin, tinelu'aan su ngak tinu'unaan ned dumipag ilan tu sed dipag ne geksid ned danaw. ");
INSERT INTO stb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Se nda' ilan pa mekeripag, duunik sala neng mentetendu' se Kesugu'an neng mikpegaud ri seniin bu' miktalu', “Sir, andamu meddunut ri seni'a isan ta'a pagaw.” ");
INSERT INTO stb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Si Jesus miksembag ri seniin, “Su ngak tinggalung duuni ngak pekengelan nilan bu' su ngang manuktalun duuni ngak salag nilan, ma'ad sug Bata' ne Getaw nda'iruni dlugar ne kepenguleliyaan.” ");
INSERT INTO stb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Suk sala nek tinu'unan miktalu' rema ri ni Jesus, “Ginu'u, muli'u reli' bu' lebengen'u pa su gama'u.” ");
INSERT INTO stb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Miksembag si Jesus, “Dunut'a senaan, bu' pesaddan mu su ngak patay neng medlebeng ri se ngang minatay nilan.” ");
INSERT INTO stb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sinumakay si Jesus tu sek sekayan, bu' middunut ri seniin su ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bu' sek tikmal sung merendes ne genus minateng ritu sed danaw, giin itu ne suk sekayan linambes neg baled bu' manla' na milened. Ma'ad si Jesus miktulug ra. ");
INSERT INTO stb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Linawan nilan si Jesus bu' tinanud nilan giin, neng miktalu', “Ginu'u, luwas mu ami! Mematay ita na!” ");
INSERT INTO stb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Miksembag si Jesus, “Lama mendek amu run? Miika' ra suk pektu'u niyu ri senaan.” Rayun migbuwat giin bu' pimendu'aan su nga genus bu' su ngag baled neng mekeneng, bu' linumengen rayun. ");
INSERT INTO stb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mitingala gaid su ngak tinu'unaan bu' miktalu' ilan, “Lama kelesiyay runi getaw keni, isan su nga genus bu' su ngag baled miktuman ma ri seniin?” ");
INSERT INTO stb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sek peddateng nilan ni Jesus tu sed dipag ned danaw, tu se geksid neng megaud tu se dlunsud ne Gadara, sinungkak ilan ned duwa' tawan neng minggawas buwat se nga dlangeb ne dlebengan. Sineleran ne ngang menulay su nga getaw keni bu' gembelu' ilan gupiya, aas nda'iruni nga getaw neng mayan sed dalan ketu. ");
INSERT INTO stb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sek pekiita' nilan ri ni Jesus, migbeksay ilan, laung nilan, “Landun maig baalen mu ri senami, dya'a neg Bata' ned Diwata? Mirinia ba arun sek peksilut ri senami isan nda' pa mateng su ginsaktu nek panahun?” ");
INSERT INTO stb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na, gena' melayu' buwat senilan, duuni gembagel nek panen ne ngag babuy ritu nek pimpaan. ");
INSERT INTO stb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mikpe'ilelaat su ngang menulay ri ni Jesus neng miktalu', “Bu' peguwasen mu ami, peseled mu ami na ma'ad riin sek panen ne ngag babuy iin.” ");
INSERT INTO stb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Miktalu' si Jesus, “Ala, peneled amu ritu.” Aas ginumawas su ngang menulay tu sed duwa' tawan bu' sinumeled ilan tu se ngag babuy. Bu' su dlaun ne ngag babuy minlegurus menggebek pagaw tu seg biliran ned dinumiritsu tu sed danaw bu' milemes ilan gela'. ");
INSERT INTO stb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Su ngang midlekata ri se ngag babuy minggebek pagaw tu se dlunsud, bu' pingasuy su dlaun nek penghitabu' labi na tu sed duwa' tawan nek sineleran se ngak penulay. ");
INSERT INTO stb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aas su dlaun ne nga getaw tu se dlunsud miritu ni Jesus; sek pekiita' nilan ri seniin, migandyu' ilan sek pegawa' tu se dlugar nilan. ");
INSERT INTO stb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sinumakay ilan ni Jesus tu sek sekayan bu' dinumipag ilan tu sed danaw bu' minuli' tu se dlunsuren. ");
INSERT INTO stb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bu' enlengay niyu, migbulig su nga getaw ne getaw neng minatay sug bahin ne dlawasen bu' migbelilid ri sek puyuwan. Seng mi'ita' ni Jesus neng metuud suk pektu'u nilan ri seniin, miktalu' giin tu se getaw neng minatay sug bahin ne dlawasen, “Sambat'u, ndi'a megu'ul. Su ngak sala' mu pinasaylu na.” ");
INSERT INTO stb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bu' enlengay niyu, sud duma neng mentetendu' ri se Kesugu'an miktalu' ri se gegulingen nilan, “Mikpesipala ri sed Diwata su getaw keni.” ");
INSERT INTO stb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Misuunan ni Jesus landunik pigena'ena' nilan, bu' miktalu' giin tu senilan, “Tuma ma megena'ena' amu neng melaat ne ngag betang? ");
INSERT INTO stb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ta' maing mesayun sek pektalu', ‘Pinasaylu na su ngak sala' mu,’ awas sek pektalu', ‘Pegbuwat'a bu' pedlaang'a?’ ");
INSERT INTO stb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na, pe'ita'u riin seniyu ne sug Bata' ne Getaw duuni ketengeren rini seg benwa sek pekpasaylu ri se ngak sala'.” Aas miktalu' rayun giin tu se getaw neng minatay sug bahin ne dlawasen, “Buwat'a, inat mu suk puyuwan mu, bu' uli'a!” ");
INSERT INTO stb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Bu' migbuwat rayun su getaw ketu bu' minuli' tu senilan. ");
INSERT INTO stb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sek pekiita' run nini ne nga getaw, minendek ilan, bu' sinaya' nilan sud Diwata tendeng sek pegbegain seng maa' nini ne ketenged tu se nga getaw. ");
INSERT INTO stb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Migawa' si Jesus se dlugar ketu, bu' seng mikedlaang na giin, mi'ita'en sung meneningil neg buwis ne giningelanan neng Mateo neng migingkud se dlugar nek pegbiyaran neg buwis. Miktalu' si Jesus ri seniin, “Dunut'a ri senaan.” Migindeg si Mateo bu' middunut ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Saanay mekaan ni Jesus tu seg balay ni Mateo, enlengay niyu, melaun neng meneningil seg buwis bu' ngang mekesesala' mikpegaud bu' sinumalu ri seniin bu' ri se ngak tinu'unanen. ");
INSERT INTO stb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mikiita' run nini su ngak santa' tawan ne ngak Pariseo bu' miktalu' tu se ngak tinu'unanen, “Tuma ma sumalu ma sung menintulu' niyu tu se ngang meneningil neg buwis bu' tu se ngang mekesesala'?” ");
INSERT INTO stb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mikerengeg si Jesus senilan bu' miksembag, “Su nga getaw ne nda'ing megeelen nda' pedlekina'enlan ned duktur, bu' ndi' su ngang mikegeelan ra. ");
INSERT INTO stb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dlaang amu bu' sayud niyu bu' landuni gulugaan riin se kesulatan neng miktalu', ‘Nda'u pedlekina'enlan ne ngad dulang ne ngang menanap, bu' ndi' melilelaaten amu tu se ngad duma.’ Ay nda'u perini arun sek pektawag se ngang meketareng, bu' ndi' se ngang mekesesala'.” ");
INSERT INTO stb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mbuus su ngak tinu'unan ni Juan neng Membebendyag miritu ni Jesus bu' miksaak, “Tuma ma gami bu' su ngak Pariseo kanunay ma mikpu'asa, ma'ad su ngak tinu'unan mu nda' ma pekpu'asa?” ");
INSERT INTO stb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Miksembag si Jesus, “Migena'ena' amu ba rekay neng megu'ul su ngak pindapit neg bisita tu se kumbira se kasal saanay suk pemenaan kiin pa duma senilan? Ndi' gaid! Ma'ad matengik panahun ne suk pemenaan uwa'en na riin senilan, bu' mbuus mekpu'asa ilan na. ");
INSERT INTO stb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nda'iruning mektapak neg begu nek penepeten tu seng meranul ne gilisan, ay mengele' sug begu nek penepeten, bu' megbagel na ma'ad tumu' sug beriten. ");
INSERT INTO stb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bu' nda'iruni getaw neng mekseled neg begu neg binu tu sed daan ne ngag betangan neg binaal buwat se ngak panit neng menanap. Ay bu' baalenen nini, megbetu su ngag betangan, mekula' sug binu, bu' medlaat su ngag betangan. Tumu', sug begu neg binu seleren riin seg begu ne ngag betangan neg binaal buwat se ngak panit neng menanap arun duwa' keni ndi' medlaat.” ");
INSERT INTO stb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Saanay ni Jesus megasuy run nini, enlengay niyu, sala geseg se ngag Judeo mikpeguud ri seniin, middempug ri seng metungenga'aan, bu' miktalu', “Minatay sug bata'u ne dlibun; ma'ad bu' meritua bu' depen mu su nga gemeg mu tu seniin, metubu' gaid giin puli'.” ");
INSERT INTO stb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aas migindeg si Jesus bu' miksunud tu se geseg se ngag Judeo, bu' midlendug rema su ngak tinu'unaan ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Enlengay niyu, duunik sala ne dlibun neng middugu'rugu' sek sepulu' bu' ruwa' taun mikpegaud ri se dliyu ni Jesus bu' inikapen su kumiling ne dlambungen. ");
INSERT INTO stb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ay miktalu' giin ri se gegulingenen, “Bu' mekiikapu ma'ad se dlambungen, me'uli'anu gaid.” ");
INSERT INTO stb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Linumingay si Jesus bu' seng mi'ita'en su dlibun, miktalu' giin, “Ndi'a megules, bata'u. Suk peksalig mu giining mekepetelen ri seni'a.” Bu' se gaktu gaid ketu, mi'uli'an su dlibun. ");
INSERT INTO stb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Miritu rayun si Jesus seg balay nu geseg. Seng mi'ita'en su ngang menlelekanta para sek pedlebeng bu' su nga getaw neng minsegaw, ");
INSERT INTO stb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","miktalu' giin, “Gawas amu reli' dlaun niyu, ay bata' keni, nda' patay—miktulug na run!” Tendeng run nitu, piketuwanan nilan si Jesus. ");
INSERT INTO stb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Seng mikegawas na su nga getaw, sinumeled si Jesus tu sed dugu neg bata' bu' inuwiraan su gemegen, bu' migbuwat sug bata'. ");
INSERT INTO stb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Bu' suk tuntulan metendeng run nini midlelaup sek tibuuk ne dlugar ketu. ");
INSERT INTO stb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mbuus migawa' si Jesus se dlugar ketu, bu' saanain mekpedlaang, duwa' dlai ne ngag buta midlendug ri seniin. “Bata' ne dlai ni David, lelaatay mu ami!” migbeksay ilan. ");
INSERT INTO stb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sek pekseled na ni Jesus tu seg balay nek pinaikaan, mikpegaud tu seniin sud duwa' buta bu' miksaak giin tu senilan, “Miktu'u amu ba ne mpe'uli'an'u amu?” “Wa'a, Ginu'u,” miksembag ilan. ");
INSERT INTO stb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mbuus inikap ni Jesus su ngang mata nilan bu' miktalu' giin, “Metuman ini sumala' sek pektu'u niyu!” ");
INSERT INTO stb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bu' mi'uli'an suk pengenleng nilan. Mbuus pininaan ilan ni Jesus ne ndi' nilan nini pengasuy se isan ta'. ");
INSERT INTO stb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma'ad midlaang ilan bu' pingasuy tumu' nilan su gesuyen metendeng ri ni Jesus tu se dlaun ne dlugar ketu. ");
INSERT INTO stb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sek pedlaang na ne nga getaw ketu, duuni dlain ne nga getaw neng minateng bu' miguwit ilan ne getaw ne gugel, tendeng ay sineleran nini nek penulay. ");
INSERT INTO stb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma'ad peketubus pe'ewa'ay ni Jesus sung menulay, miketuntul rayun su gugel bu' mitingala gaid gupiya su nga getaw. Miktalu' ilan, “Nda' ita pa gaid mayan mekiita' neng maa' nini rini sek tibuuk neg Israel.” ");
INSERT INTO stb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma'ad miktalu' su ngak Pariseo, “Su geseg nu ngak penulay, giin sung migbegay ri seniin ne ga'em sek pekpe'awa' se ngak penulay.” ");
INSERT INTO stb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Mbuus binentaw ni Jesus su dlaun ne nga dlunsud bu' ngag baryu. Minintulu' giin tu se ngak pektipungan ne nga getaw Judeo, bu' pinintulu'en sung Melengas ne Gesuyen metendeng sek pedlegari' ned Diwata bu' pi'uli'aan rema su nga getaw ned duuning mikeleseles ne ngang mekegeel. ");
INSERT INTO stb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sek pekiita'en run seng melaun ne nga getaw, milelaat giin senilan tendeng ay melegeti keliseran bu' nda'iruning migabang tu senilan. Maa' ilan ne nga karniru ne nda'iruning migingat run. ");
INSERT INTO stb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aas miktalu' giin tu se ngak tinu'unaan, “Melauni geniin, ma'ad miika' ra su ngang menlelegani. ");
INSERT INTO stb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aas pegampu' amu tu se gapu' ne nga geniin arun mekpawit giin ne ngang menlelegani sek pedlegani tu se nga geniin.” ");
INSERT INTO stb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tinawag rayun ni Jesus suk sepulu' bu' ruwa' ne nga gapustulisen bu' binegayaan ilan ne ketenged sek pekpe'awa' se ngang melaat ne gispiritu bu' pekpetelen se dlaun neng mekeseleseles ne nga dleruun. ");
INSERT INTO stb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Giin nini su nga ngalan nu ngak sepulu' bu' ruwa' ne nga gapustulisen: guna si Simon ne giningelanan nek Pedro bu' suk pateren ne si Andres, rayun sud duwa' ne nga gembata' ni Zebedeo ne si Santiago bu' si Juan; ");
INSERT INTO stb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Si Felipe bu' si Bartolome, si Tomas bu' si Mateo, sung meneningil neg buwis; si Santiago neg bata' ni Alfeo, si Tadeo; ");
INSERT INTO stb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Si Simon ne giningelanan ne getaw neng midlaban ri seng nasuren, bu' si Judas ne Iscariote sung midlu'ib riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Keni nek sepulu' bu' ruwa', pilaang ilan ni Jesus duma se ngak pemandu'en, “Ndi' amu meritu se ngak tribu ne gena' Judeo awas sumeled se isan ta' se nga dlunsud nek Samaria. ");
INSERT INTO stb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tumu' laway niyu suk tribu neg Israel tendeng ay maa' ilan ne nga karniru neng mibalag. ");
INSERT INTO stb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Asuy niyu sung Melengas ne Gesuyen, ‘Suk pedlegari' ned Diwata megaud na!’ ");
INSERT INTO stb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pe'uli'ay niyu su ngang mikegeelan, petubu' niyu puli' su ngang mimatay, petelen niyu su ngang midlaru ri seng mekeendekendek ne dleruun ri sek panit, pe'awa' niyu su ngak penulay. Mikerawat amu ne nda'ig bayad, aas pegbegay amu ne ndi' mekpebayad. ");
INSERT INTO stb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ndi' amu meguwit nek selapi'—selapi' neg bulawan, pelata, awas brunsi ri seg baling niyu. ");
INSERT INTO stb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ndi' amu meguwit ne gambag awas gilisan awas sandalyas awas gages. Sung menteterbahu mbaya' gaid begayan neng me'aanen.” ");
INSERT INTO stb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Seng mateng amu ri se dlunsud awas baryu, seled amu bu' penengaw amu getaw neng megalimba' riin seniyu bu' pekengel amu ri seniin tampan seng megawa' amu tu se dlugar ketu. ");
INSERT INTO stb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Seng meritu amu seg balay, talu' niyu, ‘Su kepiya mperiin seniyu.’ ");
INSERT INTO stb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bu' alimba'en amu nu nga getaw ri seg balay ketu, pengumpiyanan ilan rema. Ma'ad bu' ndi' amu alimba'en nilan, ndi' ilan rema pengumpiyanan. ");
INSERT INTO stb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bu' isan ta' ne getaw ri seg balay awas dlunsud ne ndi' menemba' riin seniyu awas menginengeg riin seniyu, pegawa' amu ritu seg balay awas se dlunsud ketu bu' tektak niyu su nga dlubek ri se nga geksud niyu. ");
INSERT INTO stb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Esuyan'u amu seng metuud ne se Gendaw nek Pegukum, lelaatan pa kampuun ned Diwata su nga getaw riin sek Sodoma bu' Gomora sinangkali' se nga getaw ri se dlunsud ketu.” ");
INSERT INTO stb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Penginengeg amu! Pawit'u amu ritu neng maa' ne nga karniru neng miritu se ngang mekebelu' ne ngang menanap. Aas megintau amu neng maa' seg betasan ne ngang mamak bu' mengmekemaya' amu neng maa' seg betasan ne ngak selepati. ");
INSERT INTO stb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pegbantay amu se nga getaw ay daapen amu nilan bu' uwiten amu ritu se ngang metaas ne gukuman nu nga getaw Judeo bu' lekpesen amu ritu sek pektiguman nilan. ");
INSERT INTO stb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tendeng senaan, sumbung amu nilan ritu se gobernador bu' se nga gari' tendeng sek peksunud niyu ri senaan, arun mekegasuy amu seng Melengas ne Gesuyen tu senilan bu' tu se nga gena' Judeo. ");
INSERT INTO stb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Se guwiten amu na nilan tu se gukuman, ndi' amu megules bu' landunik telu'en niyu awas pegendunen niyu run sek pektalu'; seng mateng suk penahun ketu, begayan amu bu' landunik telu'en niyu. ");
INSERT INTO stb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ay suk talu' ne gesuyen niyu gena' na neg buwat seniyu; ma'ad su Gispiritu ne Gama' giin na sung mektalu' pebiyan riin seniyu.” ");
INSERT INTO stb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mateng mbuus suk panahun ne su nga getaw peraap nilan su ngak pated nilan bu' pepatay, bu' giin rema inig baalen nu nga gama' tu se ngag bata' nilan; bu' su nga gembata' sumukul tu se ngang megulang nilan bu' pepatay ilan nu nga gembata' nilan. ");
INSERT INTO stb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bu' gemetan amu se dlaun ne nga getaw tendeng senaan. Ma'ad sung mekaantus tampan se ketapusan meluwas. ");
INSERT INTO stb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Se dlutusen amu nilan ri sek sala ne dlunsud, pedlaguy amu ritu se dlain ne dlunsud. Ay seng metuud, esuyan'u amu ndi' niyu metubus liberay sek pegwali su dlaun ne nga dlunsud seg Israel tampan mpuli' sug Bata' ne Getaw.” ");
INSERT INTO stb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Nda'ik tinu'unan ne dlabaw pa ri seng mentetendu'en awas su gulipen lumabaw ri se gegalenen. ");
INSERT INTO stb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Aas gigu' na suk tinendu'an neng maa' seng mentetendu'en bu' su gulipen maa' ri se gegalenen. Bu' su geseg ri seg balay iningelanan ma nilan neg Beelsebul, gendun pa ba sakan kelaaten suk pegingalan nilan riin seng misakup ri seg balay nu geseg nilan?” ");
INSERT INTO stb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Aas ndi' amu mendek se nga getaw. Nda'irunik tinebunan ne ndi' mbuwasan, bu' su kada ginedlud mesuunan gaid. ");
INSERT INTO stb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Landunik tinalu'u ri seniyu ri seng merelem, asuy niyu ini ri seng merelaag. Landuni ginilem'u ri seniyu, pesuun niyu ini ri se dlaun ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ndi' amu mendek ri se nga getaw neng mekepatay ri se dlawas ma'ad ndi' mekepatay riin se kalag. Tumu' pegendekay niyu sud Diwata neng mekepedlaat ri se dlawas bu' kalag niyu ritu se gimpirnu. ");
INSERT INTO stb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ay sek sala sintabus na run mekesaluy'a ned duwa' buuk neng miika' neng manuktalun, ma'ad nda'irun isan sala neng miika' neng manuktalun neng meladdu' ri se dlupa' ne gendi' mesuunan ne Gama'. ");
INSERT INTO stb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Isan ngani' gamu, isan su ngag buuk ri se gulu niyu mi'isipen. ");
INSERT INTO stb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Aas ndi' amu mendek! Ay labaw pa kampuun su dlaga' niyu sinangkali' ri se ngang mekiika' ne ngang manuktalun.” ");
INSERT INTO stb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Bu' telu'an niyu su dlaun ne nga getaw ne gamu misakup na ri senaan, telu'an'u su Gama'u ritu se dlangit ne gamu misakup na ri senaan. ");
INSERT INTO stb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma'ad bu' bibain niyau ri se dlaun ne nga getaw, telu'an'u su Gama'u tu se dlangit ne gena' amu misakup ri senaan.” ");
INSERT INTO stb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ndi' amu pegena'ena' neng miriniu arun meguwit ne kelinaw ri sek tibuuk neg benwa. Nda'u perini neng meguwit ne kelinaw bu' ndi' kalis. ");
INSERT INTO stb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ay miriniu arun sug bata' ne dlai sumukul ri se gama'en, sug bata' ne dlibun sumukul ri se gina'en, bu' sung minugangan ne dlibun sumukul ri sek penugangan ne dlibun. ");
INSERT INTO stb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bu' su dlabaw ne nga kuntra niyu giin su ngak sakup ri se gegulingen niyu nek pamilya.” ");
INSERT INTO stb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Su ngang mekpetail ri se gama'en awas se gina'en ne dlabaw pa ri senaan ndi' mbaya' ne mbaal ne ngak tinu'unan'u. Bu' su ngang mekpetail ri seg bata' nilan ne dlai awas dlibun ne dlabaw pa ri senaan ndi' mbaya' ne mbaal ne ngak tinu'unan'u. ");
INSERT INTO stb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bu' suk sala ne ndi' mekpisaan se krusen bu' meksunud ri senaan ndi' mbaya' ne mbaal ne ngak tinu'unan'u. ");
INSERT INTO stb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sung meniguru riin se ketubu'en, merela'an tumu' run nini. Ma'ad sung merala'an se ketubu'en tendeng sek peksunud ri senaan mekaangken tumu' run nini.” ");
INSERT INTO stb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Suk sala ned dumawat ri seniyu, dumawat ri senaan; suk sala ned dumawat ri senaan, dumawat seng miksugu' ri senaan. ");
INSERT INTO stb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Suk sala ned dumawat ri sek propeta, tendeng sek pekepropetaan, mekerawat giin ne ganti maa' seng merawat se ganti para sek propeta. Bu' suk sala ned dumawat seng metareng ne getaw, tendeng sek pekemetarengen, mekerawat giin ne ganti maa' seng merawat neng metareng ne getaw. ");
INSERT INTO stb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Bu' isan ta'ing migbegay ne isan sala neg basu neng meteddaw nek tubig ritu se dlabi ne gembaba' ne ngang miksunud ri senaan, tendeng ay miksunud giin ri senaan, sek pekemetuud esuyan'u amu neng mekerawat giin ne ganti. ");
INSERT INTO stb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sek peketubus ni Jesus pemendu'ay suk sepulu' bu' ruwa' ne ngak tinu'unaan, migawa' giin se dlugar ketu bu' minendu' bu' migwali tu se nga dlinunsuran neng megaud ritu. ");
INSERT INTO stb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na, saanay mirengeg ni Juan neng Membebendyag ritu sek perisuwan sung metendeng se ngag betang nek pimbaal ni Christ, sinugu'en sud duma ne ngak tinu'unaan tu seniin. ");
INSERT INTO stb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Tebalay mu ami,” miksaak ilan ri ni Jesus, “Dya'a ba suk sala nek tinalu' ni Juan neng Membebendyag neng merini, awas gami ne ngag Judeo mekperateng pa ba ne dlain?” ");
INSERT INTO stb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Miksembag si Jesus, “Puli' amu bu' talu' niyu tu ni Juan landuning mirengeg bu' mi'ita' niyu: ");
INSERT INTO stb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","su ngag buta mikiita' na, su ngag bekul mikedlaang na, su ngang minlaru neng mekeendekendek ne dleruun ri sek panit mi'uli'an na, su ngag bengel mikerengeg na, su ngang mimatay mitubu' na puli', bu' su ngak pupus mi'esuyan na seng Melengas ne Gesuyen. ");
INSERT INTO stb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bu' pedleliyagen su genda' penduwa'ruwa' metendeng ri senaan!” ");
INSERT INTO stb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bu' saanay minlaang na su ngak tinu'unan ni Juan, migatad si Jesus sek pektalu' tu se ngak panen ne nga getaw: “Seng miritu amu ni Juan ritu se kemingawan landun maik pidderama niyu neng me'ita'? Liyagan ba niyu me'ita' si Juan neng maa' nek tigbaw neng melemu ra mpilay ne genus? Gena'. ");
INSERT INTO stb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma'ad, lama run mai dlinawan niyu ritu arun enlengan? Liyagan ba niyu me'ita' su getaw neng mikseluk seng melengas nek suub? Su getaw neng mikseluk seng melengas ne ngak suub ritu ra mikengel se ngak palasyu! ");
INSERT INTO stb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Telu'ay niyau, lama run mai dlinawan niyu ritu arun enlengan? Suk propeta ba? Wa'a gaid, ma'ad telu'an'u amu, mi'ita' na niyu su dlabaw pa sinangkali' sek pikperateng niyu. ");
INSERT INTO stb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ay si Juan giin suk sala nek tinalu' ri se kesulatan, ‘Miktalu' sud Diwata, sugu'en'u sung minsahiruu neng meguna seni'a arun endamenen sug biyanan para seni'a.’ ");
INSERT INTO stb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Telu'an'u amu seng metuud, nda'irun pa gaid isan sala neng mektetubu' ne dlabaw pa ri ni Juan neng Membebendyag. Ma'ad isan ta' ne dlabi ne gembaba' se nga getawan ned Diwata giin su dlabaw sinangkali' ri ni Juan. ");
INSERT INTO stb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Gatad sek panahun sek pegwali ni Juan tampan nemuun, su nga getawan ned Diwata sinupak nu nga getaw ne dliyagan neng medlegeseg ri senilan pebiyan se genda'i dlelaat nek peksulung. ");
INSERT INTO stb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tampan sek panahun ni Juan su dlaun ne ngak propeta bu' su Kesugu'an ni Moses mingatuk metendeng se ngag betang neng mehitabu'. ");
INSERT INTO stb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Bu' keliyag niyu neng mektu'u sumala' seng minsahi nilan, si Juan giin si Elias, ne suk peddatengen inatuk na. ");
INSERT INTO stb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Penginengeg amu rayun bu' duuni ngak telinga niyu. ");
INSERT INTO stb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Na, landun maik petenggi'an'u run su nga getaw se gendaw keni? Maa' ilan ne nga gembata' neng minggingkud ri seng mirikadu. Suk sala ne dlumpuk migbeksay tu se dlain ne dlumpuk, ");
INSERT INTO stb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mikpuung ami ne gagung ma'ad nda' amu pentalek! Kinentaan amu nami ne nga kanta para ri seng minatay ma'ad nda' amu peksegaw!’ ");
INSERT INTO stb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ay seng mirini si Juan mikpu'asa giin bu' nda' inum neng mekebeleng; bu' suk salasala miktalu', ‘Pinulayan giin.’ ");
INSERT INTO stb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Seng mirini sug Bata' ne Getaw, minaan giin bu' miginum, bu' suk salasala miktalu', ‘Enlengay niyu getaw keni! Merelaw giin bu' mesekeg minum, sambat giin ne ngang meneningil neg buwis bu' ne ngang mekesesala'!’ Tumu' suk tinawan ned Diwata mpe'ita' neng metuud pebiyan se nga kelebu'aan.” ");
INSERT INTO stb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mbuus pimura ni Jesus su nga getaw ritu se nga dlunsud ne rituun binaal su ngang melaun ne ngang milagruun tendeng ay nda' ilan peddiksu' buwat se ngak sala' nilan. ");
INSERT INTO stb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Gamu ne nga getaw se Corazin! Mekelelaatlelaat amu. Gamu rema ne nga getaw seg Betsaida! Mekelelaatlelaat amu. Ay bu' su ngang milagru neng mibaal riin seniyu ritu pa mibaal sek Tiro bu' sek Sidon, mpayat ilan ra siya meddiksu' neng mekseluk nek saku bu' megbetang ne nga gabu ri se nga gulu nilan sek pekpe'ita' neng middiksu' ilan ri se ngak sala' nilan. ");
INSERT INTO stb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ma'ad telu'an'u amu ne se Gendaw sek Pegukum, sud Diwata mekpe'ita' ne dlelaat tu se nga getaw sek Tiro bu' sek Sidon sinangkali' ri seniyu. ");
INSERT INTO stb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bu' gamu ne ngak taga Capernaum, migena'ena' amu ba nek pesiddengegan amu tampan tu se dlangit? Ndi' gaid. Pidlaken amu tumu' ritu se gimpirnu. Bu' su ngang milagru neng mibaal riin seniyu mibaal pa ritu sek Sodoma, mekpebilin pa siya tampan nemuun. ");
INSERT INTO stb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aas peddelendem niyu ini se Gendaw sek Pegukum, mekpe'ita' pa kampuun ne dlelaat sud Diwata tu se nga getaw sek Sodoma sinangkali' ri seniyu.” ");
INSERT INTO stb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sek panahun ketu migampu' si Jesus, “Gama', Ginu'u se dlangit bu' se dlupa', mikpesalamatu ri seni'a tendeng ay pi'ita' mu su ngag betang keni tu se nga genda'ik sinuunaan su ginedlud mu tu se ngad duunik tinawaan bu' tu seng metaasik sinuunaan. ");
INSERT INTO stb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wa'a, Gama' ay giin nini sung mekepedleliyag ri seni'a nek penghitabu'.” ");
INSERT INTO stb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mbuus miktalu' si Jesus, “Dlaun ne ngag betang binegay ri senaan ne Gama'u. Bu' nda'iruning mekesuun ri seg Bata' gawas se Gama', awas ri se Gama' gawas seg Bata' bu' su dlaun ne dliyagaan nek pe'ilala ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Perini amu senaan, dlaun niyu ne ngak pinlubay sek pegbaba ne nga gembegat bu' pepenguleliin'u amu. ");
INSERT INTO stb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Peksunud amu ri se ngak sugu'u bu' pektu'un amu buwat senaan, tendeng ay mekemaya'u bu' melipebeba'en; bu' mekebaang amu ne kepenguleliyan. ");
INSERT INTO stb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tendeng ay su ngak sugu'u mesayun sunuren bu' suk pepisaan'u ri seniyu megaan.” ");
INSERT INTO stb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nda' santa' midlaang si Jesus bu' su ngak tinu'unaan se Gendaw nek Pengulali minetas tu sed duma ne ngag binaal nek pimulanan ne ngak trigu. Miperii'an su ngak tinu'unaan, aas migatad ilan sek pekpengati' ne nga ginuwayan bu' inaan nilan su dlegasen. ");
INSERT INTO stb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sek pekiita' run nini nu ngak Pariseo, miktalu' ilan tu ni Jesus, “Su ngak tinu'unan mu miksupak se Kesugu'an ta tendeng ay migbaal ilan se genda' pebaal se Gendaw nek Pengulali!” ");
INSERT INTO stb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma'ad miksembag giin tu senilan, “Nda' ba niyu mbasa se Kesulatan sug binaal ni David, seng miperii'an na giin duma se ngak sementaunen? ");
INSERT INTO stb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sinumeled giin tu seg balay ned Diwata, bu' minaan giin duma se ngak sementaunen sek pan ne ginilak tu sed Diwata, isan supak ini se Kesugu'an suk pekaan nilan run itu, ay su ngak pari' ra suk tinugutan sek pekaan runik pan ketu. ");
INSERT INTO stb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Awas nda' ba niyu mbasa ri se Kesugu'an ni Moses ne se kada Gendaw nek Pengulali su ngak pari' tu sek Templo miksupak ma se kesugu'an se Gendaw nek Pengulali tumu' nda' ilan mekesala'? ");
INSERT INTO stb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Esuyan'u amu ned duuni dlabaw pa kampuun rini sinangkali' sek Templo. ");
INSERT INTO stb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Su Kesulatan miktalu', ‘Su kepiya giini dliyagan'u, gena' su ngang menanap ned dulang.’ Bu' misabut pa gupiya niyu landuni gulugaan nini, ndi' siya niyu ukuman su nga getaw ne genda' mekesala'; ");
INSERT INTO stb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ay sug Bata' ne Getaw, Ginu'u giin se Gendaw nek Pengulali.” ");
INSERT INTO stb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Migawa' si Jesus se dlugar ketu bu' miritu sek pektiguman nu nga getaw Judeo, ");
INSERT INTO stb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","bu' enlengay niyu, duuni getaw neng mingupes suk sala gemegen. Duma getaw ritu liyagan nilan neng mesumbung si Jesus neng migbaal nek sayep, aas miksaak ilan ri seniin, “Supak ba se Kesugu'an ta neng mekpetelen se Gendaw nek Pengulali?” ");
INSERT INTO stb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma'ad miksembag si Jesus, “Lama run ba bu' suk sala riin seniyu ned duuni karniruun neng meladdu' ri seng meralem ne dlalud se Gendaw nek Pengulali? Ndi' rekay niyu ini betunen arun pegewasen? ");
INSERT INTO stb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Gembagel pa kampuun su dlaga' nu getaw sinangkali' se karniru! Aas su Kesugu'an ta miktugut senita sek pegabang se isan ta' se Gendaw nek Pengulali.” ");
INSERT INTO stb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Rayun miktalu' giin tu se getaw neng mingupes suk sala ne gemegen, “Etat mu su gemeg mu.” Inetat nu getaw su gemegen bu' mi'uli'an nini, maa' na rayun nud dibaluy ne gemegen. ");
INSERT INTO stb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Rayun su ngak Pariseo ginumawas bu' mikpelanu nek pegendunen nilan run sek pekpatay si Jesus. ");
INSERT INTO stb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Seng misuunan ni Jesus suk pelanu kuntra seniin, migawa' giin buwat se dlugar ketu. Bu' meluuni nga getaw neng midlendug ri seniin bu' pitelenen su dlaun neng minlaru, ");
INSERT INTO stb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","tumu' pimendu'aan ilan ne ndi' mengasuy tu se ngad duma metendeng ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Binaalen itu arun metuman suk tinalu' ned Diwata pebiyan sek propeta ne si Isaias: ");
INSERT INTO stb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Giin nini suk sesugu'en'u nek pinili'u, suk sala nek pinetail'u, bu' pidleliyagu run; begay'u su Gispirituu ri seniin, bu' pesuun'u suk pegukum'u tu se nga getaw ri se ngang nasud. ");
INSERT INTO stb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ndi' giin menlalis awas megbeksay, awas mektalu' seng mesekeg ri se ngad dalan. ");
INSERT INTO stb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ndi'en beli'en sung mibaug nek tigbaw awas pelengen sung mikpalengpaleng na nek sulu'. Mekpeddayun giin tampan sug hustisya mpetuman, ");
INSERT INTO stb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","bu' ri seniin megbetang su nga getaw sek pedderama nilan.” ");
INSERT INTO stb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Rayun sud duma ne nga getaw miguwit tu ni Jesus ne getaw neng mibuta bu' mi'ugel tendeng ay pinulayan ma giin. Pitelen ni Jesus su getaw, bu' rayun mikegabit na giin bu' mikiita'. ");
INSERT INTO stb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bu' mitingala sung melaun ne nga getaw seg binaal ni Jesus, miksaak ilan, “Giin na ba sakan nini sug Bata' ne dlai ni David?” ");
INSERT INTO stb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma'ad sek pekerengeg run nini nu ngak Pariseo, miktalu' ilan, “Pigawasen su ngak penulay tendeng ay binegayan giin ne ga'em ni Beelsebul, su geseg ne ngang menulay.” ");
INSERT INTO stb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Si Jesus mikesuun landunik pigena'ena' nilan aas miktalu' giin tu senilan, “Bu' su ngak sakup sek pedlegeri'an mbahinbahin bu' megunay megbunu', suk pedlegeri'an ketu metulag. Bu' suk sala nek siyudad awas penimalay mbahin se nga dlumpuk, bu' megunay ilan megbunu', mbengkag ini. ");
INSERT INTO stb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aas bu' suk sala ne dlumpuk kumuntra tu se dlain ne dlumpuk riin sek pedlegeri'an ni Satanas, migulugan nini neng mibahin na se nga dlumpuk bu' ndi' santa', mbengkag ini. ");
INSERT INTO stb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Miktalu' amu nek pigawas'u su ngang menulay tendeng ay si Beelsebul migbegay senaan ne ga'em sek pegbaal run nini. Ta' ma rayun sung migbegay ri se nga getawan niyu se ga'em sek pekpegawas ri senilan? Aas su nga getawan niyu giin mismu sung mekepemetuud neng misayep amu! ");
INSERT INTO stb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Gena'. Gena' ni Beelsebul, ma'ad su Gispiritu ned Diwata sung migbegay ri senaan ne ga'em sek pekpegawas ne ngang menulay, neng mekpemetuud ne sud Diwata migatad na sek pedlegari' riin seniyu. ");
INSERT INTO stb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nda'iruni getaw neng mekeseled ri seg balay ne getaw neng mesekeg arun sek peddaaw se ngag betangen, gawas bu' gepusenen reli' su getaw neng mesekeg, arun mpeddaawan sug balain. ");
INSERT INTO stb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Isan ta' su gendi' lumamig ri senaan supak ri senaan, bu' ta' su gendi' megabang ri senaan sek pektipung se nga ginani mikpebelag ma'aray ri se nga ginani. ");
INSERT INTO stb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Aas telu'an'u amu: mpasaylu su nga getaw isan laa sela'ay run bu' isan landun neng melaat nek pimentalu' nilan; ma'ad isan ta' neng mimentalu' neng melaat kuntra se Gispiritu Santu ndi' mpasaylu. ");
INSERT INTO stb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Isan ta' neng miktalu' neng melaat ri seg Bata' ne Getaw mpasaylu, ma'ad isan ta' neng mimentalu' neng melaat ri se Gispiritu Santu ndi' na gaid mpasaylu nemuun awas isan nanu. ");
INSERT INTO stb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Sung melengas ne gayu memunga neng melengas neg bunga, bu' sung melaat ne gayu memunga neng melaat neg bunga. Su gayu me'ilala pebiyan ri seg bungaan. ");
INSERT INTO stb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gamu neng maa' mamak! Pegendunen niyu run sek pektuntul neng melengas bu' gena' amu gaid melengas? Ay bu' landunid diin sek pusung, tuntulen neg baba'. ");
INSERT INTO stb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sung melengas ne getaw mektuntul neng melengas, ay melengas ma giin. Ma'ad su getaw neng melaat, mektuntul rema neng melaat, ay melaat ma giin. ");
INSERT INTO stb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Aas telu'an'u amu ne se Gendaw nek Pegukum, menembag amu se kada nek talu' ne nda'ik paluun nek pimentalu' niyu. ");
INSERT INTO stb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ay su ngak talu' mu giinik pesingkalan sek pegukum seni'a—mikesala'a ba awas nda'.” ");
INSERT INTO stb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Rayun sud duma ne ngang mentetendu' se Kesugu'an bu' su ngak Pariseo miktalu' tu seniin, “Sir, liyagan nami neng mekiita' neng megbaal'a ne ketingelaan.” ");
INSERT INTO stb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ma'ad miksembag si Jesus, “Gendun kelaat su nga getaw sek panahun keni. Ndi' ilan mektu'u ri sed Diwata! Minengi amu ri senaan ne ketingelaan? Genda'i gempe'ita'u ne ketingelaan gawas se ketingelaan neng mihitabu' ri ni propeta Jonas. ");
INSERT INTO stb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ay maa' ni Jonas ned ditu sek seled nek tiyan ne gembagel nek sera' seled sek telu endaw bu' telu gebii, telu endaw bu' telu gebii rema sug Bata' ne Getaw riin sed diyalem ne dlupa'. ");
INSERT INTO stb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Se Gendaw sek Pegukum, su nga getaw seng Ninive metubu' puli' buwat se kemetain bu' memasul se nga getaw sek panahun keni ay middiksu' ilan ri se ngak sala' nilan sek pekerengeg nilan seg wali ni Jonas; bu' enlengay niyu, duunik sala ned dini ne dlabaw pa kampuun ri ni Jonas! ");
INSERT INTO stb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Se Gendaw nek Pegukum, sug Bai sek Siba metubu' puli' buwat se kemetain bu' memasul seniyu ay mirini giin buwat seng melayu' gupiya neng nasuren sek pekpenginengeg ma'ad sek tinawan ni Solomon; bu' enlengay niyu, duunik sala rini ne dlabaw pa kampuun ri ni Solomon.” ");
INSERT INTO stb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Na, bu' sung melaat ne gispiritu gumawas na buwat ri se getaw, medlaanglaang giin tu seng memelaan ne nga dlugar sek pekpenengaw ne gempenguleliyaan, ma'ad bu' ndi' giin mekebaang run nini, ");
INSERT INTO stb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","mektalu' rayun giin ri se gegulingenen, ‘Aa, mpuli'u tu seg balay nek pikengelan'u nud diin.’ Aas mipuli' giin bu' mi'ita'en ne sug balay nda' pa pekengelay, dlimpiyu, bu' su dlaun ne nga gamit mi'imetang neng melengas. ");
INSERT INTO stb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Gumawas rayun giin bu' mpuli' neng meguwit ne dlain pa nek pitu ne nga gispiritu neng melaat pa kampuun ri seniin, bu' sumeled ilan tu se getaw bu' mekengel ritu; bu' sek tambinai', su getaw ketu melaat pa kampuun sinangkali' nud diin. Aas giin rema sung mehitabu' ri seng melaat ne nga getaw sek panahun keni.” ");
INSERT INTO stb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Saanay pa megasuy ni Jesus tu se ngak panen ne nga getaw, enlengay niyu, su gina'en bu' su ngak pateren ne nga dlai minateng, mikpegindeg ilan tu se gawas, ay liyagan nilan neng meketuntul ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bu' sala se nga getaw ritu miktalu' ri seniin, “Enlengay mu, su gina' mu bu' su ngak pated mu ne nga dlai ditu se gawas migindeg ay liyagan nilan neng meketuntul seni'a.” ");
INSERT INTO stb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Miksembag si Jesus tu seniin, “Ta' mai gina'u bu' ta' mai ngak pated'u ne nga dlai?” ");
INSERT INTO stb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bu' tinendu'en su ngak tinu'unaan bu' miktalu', “Enlengay niyu, gilan keni giin su gina'u bu' su ngak pated'u ne nga dlai. ");
INSERT INTO stb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ay isan ta' neng megbaal ne dliyagan ne Gama'u tu se dlangit, giin suk pated'u ne dlai bu' ne dlibun, bu' gina'u.” ");
INSERT INTO stb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sek sama ne gendaw ketu, ginumawas si Jesus tu seg balay bu' midlaang tu se geksid ned danaw bu' migingkud arun sek pekpenintulu'. ");
INSERT INTO stb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mbuus tendeng ay su gembagel nek panen ne nga getaw midlibut ri seniin, sinumakay giin tu sek sekayan bu' migingkud ritu saanay su gembagel nek panen ne nga getaw mingindeg tu se geksid neg baaybaay. ");
INSERT INTO stb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bu' ginumamit giin ne galing sek pektalu' seng meleget ne ngag betang. “Duuning mentetaun neng miritu seg binaalen arun sek peksigwag ne ngag beni'. ");
INSERT INTO stb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sek peksigwagen run su ngag beni', sud duma mitena' ri sed dalan, bu' minateng su ngang manukanuk bu' pingektuk nilan nini. ");
INSERT INTO stb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sud duma ne ngag beni' mitena' ri se dlupa' neg betuwan bu' mintubu' rayun ay miika' bu' mbabaw ra su dlupa' run nini. ");
INSERT INTO stb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma'ad sek peksebang ne gendaw, milawes ini, bu' tendeng ay nda' pa gupiya mekengganget, migangu su ngak pimula. ");
INSERT INTO stb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Sud duma ne ngag beni' mitena' tu se ngad dugiyan ne ngak sigbet. Sek tinumulin su ngad dugiyan ne ngak sigbet, linemesen su ngak pimula. ");
INSERT INTO stb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Sud duma ne ngag beni' mitena' tu seng melengas ne dlupa', bu' su ngak pimula mikepemunga: su ngad duma megatus, su nga dlain genem pulu', bu' su nga dlain pa run telu pulu'.” ");
INSERT INTO stb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bu' tinapus ni Jesus suk tinalu'en, “Bu' duuni ngak telinga niyu, penginengeg amu.” ");
INSERT INTO stb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mbuus mimpegaud su ngak tinu'unan tu ni Jesus bu' miksaak ri seniin, “Tuma ma medlegamit'a ma ne nga galing seng megasuy'a tu se nga getaw?” ");
INSERT INTO stb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Miksembag si Jesus tu senilan, “Suk pekesuun se ngang mi'edlud metendeng sek pedlegari' ned Diwata binegay na riin seniyu ma'ad nda' begay tu senilan. ");
INSERT INTO stb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ay su getaw ned duuning niin begayan pa parun arun melaun kampuun sung niin, ma'ad su getaw ne nda'iruning niin isan miika' ned diin seniin uwanen buwat seniin. ");
INSERT INTO stb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Su keterengan neng midlegamitu ne nga galing sek pegasuy'u senilan tendeng ay seng megenleng ilan, ndi' ilan mekiita', bu' seng menginengeg ilan, ndi' ilan mekerengeg awas mekesabut. ");
INSERT INTO stb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aas, mituman ri senilan su ngak talu' ned Diwata ne ginatuk ni Isaias: ‘Nga getaw keni kanunay mikpenginengeg, ma'ad nda' mekesabut; kanunay ilan mikpegenleng, ma'ad nda' mekiita', ");
INSERT INTO stb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","tendeng ay su nga gena'ena' nilan ndi' ma mekesabut, bu' tinempengan su ngak telinga nilan bu' pinereng su ngang mata nilan. Gena' ne gendi' nilan liyagan, ma'ad isan pesi' liyagan nilan mekerengeg bu' mekiita', ndi' nilan mbaal ini, bu' mpuli' ilan ri senaan, miktalu' sud Diwata, bu' pe'uli'an'u ilan.’ ");
INSERT INTO stb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ma'ad pedleliyag amu! Ay mikiita' su ngang mata niyu bu' mikerengeg su ngak telinga niyu. ");
INSERT INTO stb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sek pekemetuud esuyan'u amu, ay melauni ngak propeta bu' nga getawan ned Diwata ne dliyagan gupiya nilan me'ita' landun sung mi'ita' niyu ma'ad ndi' nilan me'ita', bu' merengeg landun sung mirengeg niyu, ma'ad ndi' nilan merengeg.” ");
INSERT INTO stb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Aas, penginengegay niyu rayun, bu' tu'unay niyu bu' landuni gulugaan su galing metendeng seng mensesigwag ne ngag beni'. ");
INSERT INTO stb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Su ngang mekerengeg seng minsahi metendeng sek pedlegari' ma'ad ndi' mekesabut run nini, maa' nu ngag beni' neng mitena' ri sed dalan. Minateng sung Menulay bu' sinakmiten su ngang misigwag ri sek pusung nilan. ");
INSERT INTO stb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bu' su ngag beni' neng mitena' ri se dlupa' neg betuwan, gilan su nga getaw nek pidleliyag ned dumawat seng minsahi sek pekerengeg nilan run nini. ");
INSERT INTO stb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma'ad nda' ini mekengganget neng meralem ri senilan bu' nda' ilan pekpayat. Aas sek peddateng se keliseran awas ngak pekpenlutus tendeng seng minsahi, mineleng ilan rayun. ");
INSERT INTO stb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bu' su ngag beni' neng mitena' ri se ngak sigbet ned dugiyan, gilan su nga getaw neng minginengeg seng minsahi; ma'ad su kegules metendeng se ketubu' keni bu' su gayak se keratu', linumemes tu seng minsahi bu' nda' ini mekepemunga. ");
INSERT INTO stb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma'ad su ngag beni' neng mitena' tu seng melengas ne dlupa', giin su nga getaw neng minginengeg seng minsahi bu' mikesabut run nini: mikemunga ilan, su ngad duma pingmegatus, su dlain genem pulu', bu' su dlain rema telu pulu'.” ");
INSERT INTO stb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Migasuy pa gaid si Jesus ne dlain ne galing tu senilan, “Suk pedlegari' ned Diwata maa' ini neng mentetaun neng miksigwag neng melengas ne ngag beni' ri seg binaalen. ");
INSERT INTO stb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma'ad sek pekegebii, saanay mintulug su nga getaw, su kuntra minateng bu' miksigwag rema ne ngag beni' ne ngak sigbet ri sek triguwan, bu' rayun migawa' ritu. ");
INSERT INTO stb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sek pekpentubu' na nu ngak pimula bu' migatad sek pekpemunga, dekag pa rayun mi'ilala su ngak sigbet.” ");
INSERT INTO stb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Rayun su ngak sesugu'en miritu se gapu' nug binaal bu' miktalu' ilan, “Sir, gena' ba neng melengas ma siya su ngag beni' nek sinigwag tu seg binaal mu? Ta' ma migbuwati ngak sigbet keni?” ");
INSERT INTO stb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Miksembag giin, “Su kuntra giin sung migbaal run nini.” Su ngak sesugu'en miktalu' ri seniin, “Liyagan mu ba ne dlawan nami ritu bu' pembekuten nami su ngak sigbet ketu?” ");
INSERT INTO stb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ndi',” miksembag giin, “ay ali' bu' sek pekpemakut niyu ri se ngak sigbet mesabag niyu mbakut su ngak trigu. ");
INSERT INTO stb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pesaddan niyu suk trigu bu' su ngak sigbet neng meddengan ini tumulin tampan sek pekpenlegani. Rayun esuyan'u su ngang mengengani, ne unaan nilan bekutay su ngak sigbet bu' beteken nilan arun serengen; rayun dekag pa geniyay su ngak trigu bu' tipungen tu sek tibengan'u.” ");
INSERT INTO stb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Migasuy pa gaid si Jesus ne dlain ne galing tu senilan, “Suk pedlegari' nud Diwata maa' ne dlisu neng muntasa ne inerek nek sala tawan ri seg binaalen. ");
INSERT INTO stb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Su dlisu neng muntasa giin su dlabi neng mitut se dlaun ne nga dlisu. Ma'ad seng mentubu' na ini, giin nini su dlabi ne gembagel nek pimula. Mbaal ne gayu, bu' meritu su ngang manuktalun bu' mekegbaal ilan ne ngak salag ri se ngak pangaan.” ");
INSERT INTO stb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Bu' si Jesus migasuy pa gusay ne dlain ne galing tu senilan, “Suk pedlegari' nud Diwata maa' nek pempetulin ne inuwan nek sala ne dlibun bu' linamug ri sed duwa' pulu' bu' telu kilu ne garina arun tumulin su dlaun neng minasa.” ");
INSERT INTO stb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Midlegamit si Jesus ne nga galing sek pegasuy se ngag betang tu seng melaun gupiya ne nga getaw; ndi' giin megasuy neg betang tu senilan ne ndi' medlegamit ne galing. ");
INSERT INTO stb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Binaalen nini arun metuman suk tinalu' nek propeta: “Medlegamitu ne nga galing seng megasuyu senilan; asuy'u senilan sung mi'edlud ne ngag betang gatad pa sek pegbaal runig benwa.” ");
INSERT INTO stb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mbuus, migawa' si Jesus tu se nga getaw bu' sinumeled giin tu seg balay. Su ngak tinu'unaan miritu seniin bu' miktalu', “Telu'ay mu ami landuni gulugan se galing metendeng se ngak sigbet riin seg binaal.” ");
INSERT INTO stb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Miksembag si Jesus, “Su getaw neng miksigwag seng mekelengas neg beni' giin sug Bata' ne Getaw; ");
INSERT INTO stb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","sug binaal giin sug benwa; bu' sung melengas neg beni' gilan su nga getaw neng misakup sek Pedlegeri'an ned Diwata; ma'ad su ngak sigbet gilan su nga getaw neng misakup riin seng Menulay; ");
INSERT INTO stb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","bu' su kuntra neng miksigwag se ngag beni' ne ngak sigbet giin suk Penulay. Suk penlegani giin nini su ketapusan nek panahun, bu' su ngang mengengani gilan su ngag anghel. ");
INSERT INTO stb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Aas maa' run rema su ngak sigbet ne uwanen bu' serengen tu se gapuy, giin rema sung mehitabu' se ketapusan nek panahun: ");
INSERT INTO stb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","sug Bata' ne Getaw sugu'enen su ngag anghelen arun tipungen tu se gawas sek Pedlegeri'aan su dlaun neng migbaal ne getaran sek pekpekesala' bu' sud duma neng migbaal neng melaat ne ngag betang, ");
INSERT INTO stb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","bu' pidlaken ilan tu seng midliga' ne gapuy, ned ditu mensegaw bu' mekpengkiget se nga ngisi nilan. ");
INSERT INTO stb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Rayun su nga getaw neng migbaal se keliyag ned Diwata meddelaag maa' ne gendaw tu sek Pedlegeri'an ne Gama' nilan. Penginengeg amu rayun, bu' duuni ngak telinga niyu!” ");
INSERT INTO stb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Suk pedlegari' ned Diwata maa' neng mi'edlud ne ketigeyunan neng milebeng ri sek sala neg binaal. Mibaangan ini nek sala tawan bu' tinebunaan nini puli'. Pidleliyag giin gupiya bu' tendeng run nini, midlaang giin bu' bineledya'en su dlaun ne ngag betangen, bu' rayun mipuli' giin bu' sinaluyen sug binaal ketu.” ");
INSERT INTO stb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Suk pedlegari' ned Diwata maa' rema neng memeledya'ay neng minengaw seng melengas ne ngak perlas. ");
INSERT INTO stb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bu' seng mibaangaan na suk perlas neng melaga' bu' melengas gupiya, midlaang giin bu' bineledya'en su dlaun ne ngag betangen bu' sinaluyen suk perlas ketu.” ");
INSERT INTO stb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Suk pedlegari' ned Diwata maa' rema ne dlaya nek tinikpu' nu ngang minginsera' tu sed dagat bu' mitebanan ne ngang mikeleseles ne ngak sera'. ");
INSERT INTO stb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Seng mipenu' na ini, bininteng nilan nini tu seg baaybaay bu' minggingkud ilan sek pekpain se ngak sera'. Su ngang mekelengas binetang riin se ngag belanan, ma'ad su ngang mekelaaten pimidlak. ");
INSERT INTO stb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Maa' nini rema sung mehitabu' se ketapusan nek panahun: mateng su ngag anghel arun painen su nga getaw neng mekelaaten buwat ri se ngang metareng ");
INSERT INTO stb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","bu' pidlaken ilan tu seng midliga' ne gapuy, ditu mensegaw bu' mengkiget se nga ngisi nilan. ");
INSERT INTO stb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Misabut ba niyui dlaun ne ngag betang keni?” miksaak si Jesus tu senilan. “Wa'a,” miksembag ilan. ");
INSERT INTO stb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aas miktalu' giin tu senilan, “Migulugan nini, rayun, ne su kada neng mentetendu' se Kesugu'an neng mibaal nek sumusunud riin se ngak pedlegeseg ned Diwata, maa' giin nu gapu' neg balay neng mikepegawas neg begu bu' daan ne nga ketigeyunan buwat ri sek pengimetangaan tendeng ay metau giin mektendu' sed daan bu' seg begu nek penendu'an.” ");
INSERT INTO stb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sek peketubus ni Jesus sek pegasuy ne nga galing, migawa' giin ritu se dlugar ketu, ");
INSERT INTO stb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","bu' mipuli' tu se gegulingenen ne dlunsud. Minintulu' giin ri sek pektiguman nu nga getaw Judeo, bu' mitingala su ngang mikerengeg seniin. “Ta' ma giin mikuuwan seng maa' niya nek tinawan?” miksaak ilan. “Ta' ma niin inuwan su ga'em sek pegbaal ne nga ketingelaan? ");
INSERT INTO stb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Gena' ba bata' ma giin nuk panday? Gena' ba si Maria ma su gina'en? Bu' gena' ba gilan ma si Santiago, si Jose, si Simon bu' si Judas su ngak pateren? ");
INSERT INTO stb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Gena' ba su dlaun ne ngak pateren ne dlibun dini ma mikengel se dlunsud ta? Ta'en ma inuwani dlaunen keni?” ");
INSERT INTO stb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aas binibay nilan giin. Ma'ad miktalu' si Jesus tu senilan, “Suk propeta pigbesaan isan ta' gawas riin se gegulingenen ne dlunsud bu' ri sek penimalain.” ");
INSERT INTO stb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tendeng ay nda'irunik pektu'u nilan, nda' giin pegbaal neng melaun ne nga ketingelaan ritu. ");
INSERT INTO stb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sek panahun ketu si Herodes, su geseg se Galilea, mikerengeg metendeng ri ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“Giin gaid si Juan neng Membebendyag neng mitubu' puli',” tinelu'aan su nga gupisyalen. “Giin nini, tuma ma ned duuni ga'emen run sek pegbaal ne nga ketingelaan.” ");
INSERT INTO stb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Si Herodes giin sung miksugu' nud diin ned daapen si Juan bu' gepusen bu' perisuun. Binaalen nini tendeng ri ni Herodias, nek sawa nuk pateren ne si Felipe. ");
INSERT INTO stb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ay miktalu' ma ugud nud diin si Juan neng Membebendyag tu ni Herodes, “Gena' metareng neng mengesawaa riin ni Herodias.” ");
INSERT INTO stb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bu' miktinguha' si Herodes nek petain giin, ma'ad minendek giin ri se nga getaw Judeo, tendeng ay si Juan inilala ma nilan nek propeta. ");
INSERT INTO stb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na, sek pekse'ulug se gendawan ni Herodes, sud delaga neg bata' ni Herodias tinumalek riin seng metungenga'an nilan neng mikepedleliyag gupiya riin ni Herodes, ");
INSERT INTO stb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","aas duma sek pekpenumpa', miksaad giin tu seniin, “Begay'u ri seni'a isan landunik penengiin mu!” ");
INSERT INTO stb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sumala' sek sugu' nu gina'en, miktalu' giin tu seniin, “Begay mu rini senaan nemuun rayun, su gulu ni Juan neng Membebendyag neg betangen ri sek sendukan.” ");
INSERT INTO stb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Migu'ul su gari', ma'ad tendeng sek sinaaren riin seng metungenga'an nu ngak pingenggaten, miksugu' giin neg begay ri seniin su dliyagaan. ");
INSERT INTO stb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Aas pipetelaan ne gulu si Juan ritu sek perisuwan. ");
INSERT INTO stb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bu' inuwit su guluun neg binetang riin sek sendukan bu' binegay tu sed delaga, bu' rayun binegain nini tu se gina'en. ");
INSERT INTO stb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bu' su ngak tinu'unan ni Juan minateng, bu' inuwit nilan sug bangkain, bu' linebeng nilan nini; rayun, midlaang ilan bu' tinelu'an nilan si Jesus. ");
INSERT INTO stb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sek pekerengeg ni Jesus seg balita' metendeng riin ni Juan, migawa' giin ritu sakay sek sekayan. Miritu giin seng mingaw ne dlugar nek salaan ra. Mirengegan ini nu nga getaw, aas migawa' ilan buwat se nga dlunsud nilan, bu' minlaang arun sek pedlendug ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Se kinumawas na si Jesus tu sek sekayan, mi'ita'en su gembagel nek panen ne nga getaw, bu' milelaat gupiya giin senilan, bu' pi'uli'aan su ngang minlaru senilan. ");
INSERT INTO stb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Seng meksindep na su gendaw, su ngak tinu'unaan miritu seniin bu' miktalu', “Medlegebii na bu' mingaw su dlugar keni. Pepe'uli' mu na nga getaw keni bu' pelaang mu ritu se ngag baryu arun mekepenaluy se ngang me'aan para ri se gegulingen nilan.” ");
INSERT INTO stb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","“Ndi' ilan na menlaang,” miksembag si Jesus. “Gamu mismu sung megbegay ri senilan neng me'aan!” ");
INSERT INTO stb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Duuni dlima buuk nek pan rini bu' duwa' buuk nek sera',” miksembag ilan. ");
INSERT INTO stb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Rayun uwit niyu iin rini senaan,” miktalu' si Jesus. ");
INSERT INTO stb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mbuus sinugu'en su nga getaw sek pekpengingkud ri sek sigbetan; rayun inuwanen su dlima buuk nek pan bu' sud duwa' buuk nek sera', migangag giin tu se dlangit sek pekpesalamat tu sed Diwata. Pinetapetaan su ngak pan, bu' binegain tu se ngak tinu'unaan; bu' pimegay rayun nilan ini duma su ngak sera' tu se nga getaw. ");
INSERT INTO stb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mikekaan rayun suk salasala bu' mibesug. Bu' su ngak tinu'unan ni Jesus miketimud pa gaid nek sepulu' bu ruwa' bebaan neng mikepenu' ne ngak sawad. ");
INSERT INTO stb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Su dlaun neng mingaan ritu binalabena' ne dlima libu tawan ne nga dlai, nda' isipay su nga dlibun bu' su nga gembata'. ");
INSERT INTO stb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pisakay rayun ni Jesus su ngak tinu'unaan ritu sek sekayan bu' miguna ri seniin sek peddipag tu sed dipag geksid ned danaw, saanay pipe'uli'en pa su nga getaw. ");
INSERT INTO stb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sek peketubusen na pepe'uli'ay su nga getaw, tinumuwad giin nek salaan ra tu seg bentud arun sek pegampu'. Seng midlegebii na sala ra ni Jesus ritu. ");
INSERT INTO stb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na, sek panahun ketu suk sekayan melayu' na riin seng memelaan bu' pidlambeslambes ini ne ngag baled, tendeng ay su genus misensung ma nilan. ");
INSERT INTO stb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bu' rayun sek pekeddali' endaw na, si Jesus miritu se ngak tinu'unan, neng midlaang ri sed dibabaw nek tubig. ");
INSERT INTO stb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sek pekiita' nilan ri seniin neng midlaang ri sed dibabaw nek tubig, minendek ilan gupiya. “Kiin nai kalag,” miktalu' ilan, bu' mimbeksay ilan se keendek. ");
INSERT INTO stb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Miktalu' rayun si Jesus ri senilan, “Ndi' amu mendek!” miktalu' giin, “Gaku' ini.” ");
INSERT INTO stb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bu' sinumembag si Pedro ri seniin, “Ginu'u bu' dya'a iin, sugu' mau neng meriin seni'a neng medlaang ri sed dibabaw nek tubig.” ");
INSERT INTO stb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Ala, perinia,” miksembag si Jesus. Aas minaug si Pedro tu sek sekayan, bu' migatad medlaang ri sed dibabaw nek tubig pagaw tu ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma'ad seng mi'ita'en sung merendes ne genus, minendek giin bu' migatad giin meleddang, “Luwas mau, Ginu'u!” migbeksay giin. ");
INSERT INTO stb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sek tikmal, inuwiran giin ni Jesus, bu' miktalu', “Pekiika' sek pektu'u mu! Tuma ma medduwa'ruwa'a ma?” ");
INSERT INTO stb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bu' seng mikesakay ilan na tu sek sekayan, su genus linumengen. ");
INSERT INTO stb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Rayun su ngak tinu'unan ned ditu sek sekayan miksimba ri ni Jesus, “Sek pekemetuud dya'a gaid sug Bata' ned Diwata!” miktalu' ilan. ");
INSERT INTO stb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dinumipag ilan tu sed danaw bu' dinumenggu' tu se Genesaret, ");
INSERT INTO stb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ne ritu mi'ilelaan ne nga getaw si Jesus. Aas su nga getaw ritu mikpesuun sek peddatengen tu se ngak timala' ne dlugar bu' inuwit nilan ritu su ngang minlaru tu ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bu' mikpe'ilelaat ilan ri seniin nek tugutaan siya su ngang minlaru neng mekiikap isan na run riin se kumiling ne dlambungen; bu' su dlaun neng mikiikap run nini mi'uli'an. ");
INSERT INTO stb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tubus itu, duunid duma ne ngak Pariseo bu' ngang mentetendu' ri se Kesugu'an neg buwat pa seg Jerusalem miritu ni Jesus, bu' miksaak ri seniin, ");
INSERT INTO stb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tuma ma su ngak tinu'unan mu sinumupak ri sek penendu'an neg binilin nu nga gepu'an ta? Nda' ilan pengunaw ri se nga gemeg nilan se ginsaktu nek pebiyan se nda' ilan pa aan!” ");
INSERT INTO stb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Miksembag si Jesus, “Bu' tuma ma supaken ma rema niyu suk sugu' ned Diwata tendeng ma'ad sek peksunud se gegulingen niyu nek penendu'an neg binilin nu nga gepu'an ta? ");
INSERT INTO stb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ay sud Diwata miktalu', ‘Tamed mu su gama' mu bu' su gina' mu; bu' su isan ta' neng mektuklad se gama'en awas se gina'en, kina'enlan petain giin.’ ");
INSERT INTO stb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma'ad miktendu' amu ne bu' su getaw duuning megamit sek pegabang ri se nga gama'en awas gina'en, ma'ad mektalu', ‘Keni para sed Diwata,’ ");
INSERT INTO stb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ndi' na niin kina'enlan temeren sung megulangen. Seng maa' niin nek pebiyan, sinupak niyu suk sugu' ned Diwata, arun sek peksunud se gegulingen niyu nek penendu'an neg binilin nu nga gepu'an ta. ");
INSERT INTO stb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Gamu neng mikpelaunglaung! Ginsaktu si Isaias seng mingatuk giin metendeng riin seniyu! ");
INSERT INTO stb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nga getaw keni,’ miktalu' sud Diwata, ‘miktamed senaan sek talu' na run nilan, ma'ad su nga gena'ena' nilan melayu' ri senaan. ");
INSERT INTO stb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Genda'ik paluun suk peksimba nilan ri senaan, tendeng ay tinendu' nilan su ngak pemala'ud ne getaw neng maa' ne ngag bala'ud'u.’” ");
INSERT INTO stb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tinawag rayun ni Jesus su ngak panen ne nga getaw tu seniin, bu' miktalu' tu senilan, “Penginengeg amu bu' sabut niyu ini! ");
INSERT INTO stb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gena' suk sumeled riin seg baba' niyu giin sung mekepelemu' ri seniyu; ma'ad isan landun ne gumawas ri seg baba' niyu giin sung mekepelemu' riin seniyu.” ");
INSERT INTO stb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Rayun su ngak tinu'unan miritu seniin bu' miktalu', “Misuunan mu ba ne su ngak Pariseo miremeng tendeng sek tinalu' mu?” ");
INSERT INTO stb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Miksembag si Jesus, “Kada nek pigimula ne nda' pemulaanay nu Gama'u tu se dlangit pembekuten.” ");
INSERT INTO stb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Ndi' amu megules metendeng ri senilan! Gilan sug buta neng migagak ri se ngag buta; bu' suk sala neg buta migagak ri se dlain neg buta, meladdu' ilan duwa' ri se dlalud.” ");
INSERT INTO stb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bu' miktalu' si Pedro, “Sir, pesabut mu ri senami su galing keni.” ");
INSERT INTO stb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Miktalu' si Jesus tu senilan, “Gamu rema, nda' amu ba gusay mekesabut? ");
INSERT INTO stb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nda' niyu ba mesabut ne isan laa betangay run neng meseled ri seg baba' niyu pagaw ini ri sek tiyan bu' rayun gumawas ini ri se dlawas niyu? ");
INSERT INTO stb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma'ad su ngag betang ne gumawas ri seg baba' migbuwat ini ri se gena'ena', bu' giin nini su ngag betang neng mekepelemu' ri seniyu. ");
INSERT INTO stb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ay buwat riin se gena'ena' niyu gumawas sung melaat ne nga ketuyu'an neng mekegbaal ri seniyu sek pekpatay, pekpenapaw, imural nek pekpekighilawas, peddaaw, pegbalus, bu' pektalu' neng melaaten tu se ngad duma. ");
INSERT INTO stb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Giin nini su ngang mekegbaal ri seniyu neng melemu'. Ma'ad suk pekpengaan ne genda'ik pekpengunaw se nga gemeg sumala' sek tinalu' nilan gena' ini mekepelemu' ri seniyu.” ");
INSERT INTO stb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Migawa' si Jesus se dlugar ketu bu' miritu giin se nga dlugar neng megaud se dlunsud nek Tiro bu' Sidon. ");
INSERT INTO stb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Bu' enlengay niyu, duunik sala ne dlibun ritu nek taga Canaan ned ditu na mikengel se dlugar ketu, miritu seniin neng migbeksay, “Sir, Bata' dlai ni David lelaatay mau! Sug bata'u ne dlibun pinulayan bu' migantus gupiya.” ");
INSERT INTO stb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ma'ad nda' peksembag si Jesus ri seniin isan sek sala talu' na run. Bu' su ngak tinu'unaan miritu seniin bu' migandyu', “Pepe'awa' mu dlibun kiin! Miksunudsunud giin ri senita neng mikpegbeksay.” ");
INSERT INTO stb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Miksembag si Jesus, “Sinugu'u na run tu se nga getaw Israel neng maa' ilan ne ngang mibalag ne karniru.” ");
INSERT INTO stb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma'ad mikpegaud su dlibun ri ni Jesus bu' middempug sek peksimba ri seniin, neng miktalu', “Sir, ebangay mau.” ");
INSERT INTO stb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Miksembag si Jesus, “Ndi' mpiya ne uwanen su gaan ne nga gembata' bu' tikpu'en tu se nga gitu'.” ");
INSERT INTO stb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Miksembag su dlibun, “Metuud ma iin, Sir, ma'ad isan ngani' su nga gitu' mekekaan ma se ngak sawad buwat ri se dlemisaan ne nga gegalen nilan.” ");
INSERT INTO stb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Miksembag rayun si Jesus ri seniin, “Dya'a su dlibun ned duuni gembagel nek pektu'uun! Landuni dliyagan mu baalen para seni'a.” Bu' sug bata'en ned delaga mi'uli'an se guras ketu. ");
INSERT INTO stb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Migawa' si Jesus ritu bu' miritu giin se geksid ned danaw se Galilea. Bu' tinumuwad giin tu se gembentud, bu' migingkud ritu. ");
INSERT INTO stb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bu' su gembagel nek panen ne nga getaw miritu seniin, neng mingguwit neg bekul, buta, pingkaw, gugel, bu' melaun paid duma ne nga getaw neng minlaru. Pi'imetang nilan su ngang minlaru ri seng metungenga'an ni Jesus; bu' pi'uli'aan ilan gela'. ");
INSERT INTO stb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mitingala gaid su nga getaw sek pekiita' nilan se nga gugel neng mikegabit na, su ngak pingkaw neng mi'uli'an na, su ngag bekul neng mikedlaang na, bu' su ngag buta neng mikiita' na; bu' sinaya' nilan sud Diwata seg Israel. ");
INSERT INTO stb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Mbuus, tinawag ni Jesus su ngak tinu'unaan tu seniin bu' miktalu', “Milelaatu ri se nga getaw keni, tendeng ay telu endaw ilan na neng middunutdunut ri senaan bu' nda' naing me'aan nilan. Ndi'u liyagan nek pelaangen'u ilan ne ndi' ilan mpe'aan ay ali' bu' punaun ilan mbuus ri sed dalan sek peguli' nilan.” ");
INSERT INTO stb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Miksaak ri seniin su ngak tinu'unan, “Ta' ita ma penguwan ne gaan rini se kemingawan ne mpe'igu' pe'aan ri seng melaun ne nga getaw keni.” ");
INSERT INTO stb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Miksaak si Jesus tu senilan, “Santa' buuk ma suk pan riin seniyu?” Miksembag ilan, “Pitu laad bu' duunik santa' buuk neng mekiitut ne ngak sera'.” ");
INSERT INTO stb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aas sinugu' ni Jesus su nga getaw sek pekpengingkud ri se dlupa'an. ");
INSERT INTO stb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Inuwan rayun ni Jesus suk pitu buuk nek pan bu' su ngak sera', bu' mikpesalamat tu sed Diwata, pimpetapetaan su ngak pan, bu' binegain tu se ngak tinu'unan; bu' pimbegay rema ini nu ngak tinu'unan duma se ngak sera' tu se nga getaw. ");
INSERT INTO stb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dlaun nilan mikekaan bu' mibesug, bu' su ngak tinu'unan miketimud pa gaid nek pitu bebaan neng mipenu' nek sawad. ");
INSERT INTO stb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Su dlaun neng mingaan ritu, duuni gepaat libu tawan ne nga dlai ma'aray, nda' isipay su nga dlibun bu' su nga gembata'. ");
INSERT INTO stb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Rayun, pipe'uli' ni Jesus su nga getaw, bu' sinumakay giin sek sekayan bu' miritu se dlugar neng Magadan. ");
INSERT INTO stb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sud duma ne ngak Pariseo bu' ngak Saduceo miritu ni Jesus ay liyagan nilan ne indanan giin, aas migandyu' ilan neng mekpe'ita' giin ne ketingelaan ne sud Diwata sung miksugu' ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma'ad miksembag si Jesus, “Seng meksindep nai gendaw mektalu' amu, ‘Mekpiyaig benwa ay su dlangit minlepula.’ ");
INSERT INTO stb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sek sikanselem, mektalu' amu, ‘Meddupi' nandaw ay minlepula bu' dinumelem su dlangit.’ Metau amu gupiya megulug sek panahun sek pegenleng se dlangit, ma'ad ndi' niyu me'ulug su nga gilelaan se ngak panahun keni! ");
INSERT INTO stb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gendun kelaat su nga getaw sek panahun keni. Ndi' ilan mektu'u ri sed Diwata! Minengi amu ri senaan ne ketingelaan? Genda'i gempe'ita'u ne ketingelaan gawas se ketingelaan neng mihitabu' ri ni propeta Jonas.” Aas binelengen ilan bu' midlaang. ");
INSERT INTO stb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sed dinumipag na su ngak tinu'unan ni Jesus tu sed dipag geksid ned danaw, milingawan nilan meguwit nek pan. ");
INSERT INTO stb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Miktalu' si Jesus tu senilan, “Pegingat amu bu' bentayay gaid niyu suk pempetulin nu ngak Pariseo bu' nu ngak Saduceo.” ");
INSERT INTO stb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma'ad migatad ilan megaddat sek salasala senilan, “Mitalu'en nini tendeng ay nda' ita mekeguwit nek pan.” ");
INSERT INTO stb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma'ad seng misuunan ni Jesus bu' landunik pigeddatan nilan, aas miksaak giin tu senilan, “Tuma ma megaddat amu ma metendeng ri se genda'irunik pan? Pekiika' gaid sek pektu'u niyu! ");
INSERT INTO stb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nda' amu pa ba gusay mekesabut? Nda' ba niyu me'ena'ena' su dlima laad nek pan nek pikilasilas para tu se dlima libu ne nga dlai? Bu' santa' bebaan ma neng mipenu' niyu? ");
INSERT INTO stb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Awas nda' ba niyu me'ena'ena' suk pitu buuk pan para tu se gepaat libu ne nga dlai? Bu' santa' bebaan ma neng mipenu' niyu? ");
INSERT INTO stb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pikunta' ma niyu ne ndi' ma niyu mesabut ne gena' maik pan suk tinalu'u? Ma'ad pegbantay amu sek pempetulin ne ngak Pariseo bu' ne ngak Saduceo.” ");
INSERT INTO stb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Rayun su ngak tinu'unan mikesabut ne nda' giin penegul senilan sek pegbantay se gegulingen nilan buwat sek pempetulin ne gemiten riin sek pan, ma'ad buwat sek penendu'an nu ngak Pariseo bu' ngak Saduceo. ");
INSERT INTO stb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Minateng ilan ni Jesus tu se dlugar neng megaud sek Cesarea Filipos, bu' ritu, miksaak giin tu se ngak tinu'unaan, “Sumala' se nga getaw, ta' ma etaway run sug Bata' ne Getaw?” ");
INSERT INTO stb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Sud duma miktalu', giin raw si Juan neng Membebendyag,” miksembag ilan. “Su ngad duma miktalu' giin raw si Elias, saanay su ngad duma miktalu', giin raw si Jeremias, awas dlain nek propeta.” ");
INSERT INTO stb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Ma'ad metendeng ri seniyu?” miksaak giin tu senilan. “Ta'u ma riin seniyu?” ");
INSERT INTO stb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Miksembag si Simon Pedro, “Dya'a sung Misiyas, sug Bata', neng miktetubu' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Pedleliyag'a, Simon bata' ni Juan,” miksembag si Jesus. “Ay kemetuuran keni nda' mateng ri seni'a buwat ri se getaw, ma'ad binegay ini rayun ne Gama'u ned ditu se dlangit. ");
INSERT INTO stb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Bu' aas telu'an'u dya'a, Pedro: dya'a sug batu, bu' seg batu nek penligen keni, bekuren'u suk simbaan'u, bu' isan su ga'em se kemetain ndi' gaid mekelupig run nini. ");
INSERT INTO stb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Begayan'u dya'a ne nga dyabi ri sek Pedlegeri'an ned Diwata; landuni ndi' mu tugut rini seg benwa ndi' ini tugut nud Diwata tu se dlangit, bu' landunik tugut mu rini seg benwa tugut ini nud Diwata tu se dlangit.” ");
INSERT INTO stb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Rayun pimendu'an ni Jesus su ngak tinu'unaan ne ndi' nilan nini pengasuy se isan ta' ne giin sung Misiyas. ");
INSERT INTO stb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dluwat sek panahun ketu, si Jesus migatad na sek pegasuy se kelaru tu se ngak tinu'unaan, “Kina'enlan gaid neng merituu seg Jerusalem bu' megantusu gaid gupiya sek pe'antus se nga geseg ne ngag Judeo, se geseg ne ngak pari', bu' se ngang mentetendu' ri se Kesugu'an. Pepatayu nilan, ma'ad se ketelu endaw metubu'u ra puli'.” ");
INSERT INTO stb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma'ad inuwit ni Pedro si Jesus tu seng me'eksid bu' pimaagen giin. “Ndi' siya ini tugut ned Diwata, Ginu'u!” miktalu' giin. “Ndi' gaid ini mehitabu' riin seni'a!” ");
INSERT INTO stb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma'ad inatubang ni Jesus si Pedro bu' miktalu', “Pelayu'a riin senaan Satanas! Dya'a sung memelabag ri seg biyanan'u, tendeng ay pengena'ena' mu kiin gena' buwat ri sed Diwata, ma'ad migbuwat ri sek pengena'ena' ne nga getaw.” ");
INSERT INTO stb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Rayun miktalu' si Jesus tu se ngak tinu'unaan, “Bu' su isan ta' seniyu neng meliyag sumunud ri senaan, kina'enlan ndi'en pelebunen su gegulingenen, inatenen bu' pisanenen su gegulingenen ne krus, bu' meksunud ri senaan. ");
INSERT INTO stb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ay bu' liyaganen luwasen su gegulingenen ne ketubu', merala' tumu' ini riin seniin; ma'ad bu' merela'an giin ne ketubu' para senaan, me'angkenen tumu' ini. ");
INSERT INTO stb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Duun baing me'uwanen, bu' me'angkenen suk tibuuk neg benwa ma'ad merela'an giin se ketubu'en? Nda'irun gaid! Nda'irun isan landun ne mbegain arun me'awi'en puli' su ketubu'en. ");
INSERT INTO stb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ay sug Bata' ne Getaw megeed na mateng duma se ngag anghelen bu' ga'em neg buwat se Gama'en, bu' rayun begayan ne ganti su kada sala sumala' ri se ngang mibaalen. ");
INSERT INTO stb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sek pekemetuud esuyan'u amu ned duunid duma rini seniyu ne ndi' pa matay tampan me'ita' nilan sug Bata' ne Getaw neng mateng gisip Gari'.” ");
INSERT INTO stb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dluwat se genem endaw, inuwit ni Jesus si Pedro, bu' su ngang mekpated ne si Santiago bu' si Juan ritu seng metaas neg bentud ne gilan ra ritu. ");
INSERT INTO stb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Saanay migenleng ilan, mi'eseb su gawi' ni Jesus: sung mulu'en middelaag maa' ne gendaw, bu' suk suuben mingelinggatan se keputi'. ");
INSERT INTO stb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Rayun suk telu ne ngak tinu'unan mikiita' riin ni Moses bu' ni Elias neng miktuntul duma ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aas si Pedro miktalu' tu ni Jesus, “Ginu'u melengas ne rini ami. Bu' liyagan mu, megbaalu nek telu buuk ne dlekaw rini, suk sala para seni'a, suk sala para se ni Moses bu' suk sala para ri ni Elias.” ");
INSERT INTO stb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Saanain pa megabit, sung merelaag ne ginanud tinumikup ri senilan, bu' duunik talu' neng migbuwat ri se ginanud, “Giin nini sug Bata'u nek pinetail'u, pidleliyagu gupiya ri seniin. Penginengegay niyu giin.” ");
INSERT INTO stb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sek pekerengeg run nini nu ngak tinu'unan minendek ilan gupiya bu' mindempug ilan ri se dlupa'. ");
INSERT INTO stb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bu' si Jesus mikpegaud tu senilan bu' inikapen ilan, “Pengindeg amu,” miktalu' giin. “Ndi' amu mendek.” ");
INSERT INTO stb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sek pegangag nilan nda'irun nai dlain neng mi'ita' nilan gawas ri ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bu' sek peddiksun na nilan buwat seg bentud, si Jesus minegul ri senilan, “Ndi' niyu tabal se isan ta' metendeng sek pi'ita' neng mi'ita' niyu, tampan sug Bata' ne Getaw metubu' na puli' buwat se kemetain.” ");
INSERT INTO stb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Rayun su ngak tinu'unaan miksaak ri seniin, “Tuma ma su ngang mentetendu' se Kesugu'an miktalu' ma ne kina'enlan meguna merini si Elias?” ");
INSERT INTO stb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","“Si Elias miguna gaid merini,” miksembag si Jesus, “bu' endamenen su dlaunen. ");
INSERT INTO stb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma'ad esuyan'u amu, si Elias mikerini na, bu' nda' giin ilelaay nu nga getaw, ma'ad binaal tumu' nilan su dliyagan nilan baalen ri seniin. Maa' ra run rema, pe'entusen nilan sug Bata' ne Getaw.” ");
INSERT INTO stb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mikesabut rayun su ngak tinu'unan ne suk tinalu'en ri senilan metendeng riin ni Juan neng Membebendyag. ");
INSERT INTO stb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sek pekpuli' nilan tu sek panen ne nga getaw, duunik sala tawan neng miritu ni Jesus neng miginlulud ri seng metungenga'aan, ");
INSERT INTO stb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","bu' miktalu', “Ginu'u, lelaatay mu sug bata'u ne dlai, ay pegbauyen giin. Bu' melebiyan na gaid suk pegantusen ay mibuksak giin ri se gapuy bu' nakit giin mbuksak ri sek tubig. ");
INSERT INTO stb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inuwit'u na giin tu se ngak tinu'unan mu ma'ad nda' ilan mekepetelen ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Bu' miksembag si Jesus, “Gamu nga getaw! Nda'ik pektu'u niyu bu' migunut amu ri sek sayep. Gendun pa ba kepayat neng meddunutdunutu riin seniyu? Gendun pa ba kepayat neng mekpelugbaku riin seniyu? Uwit niyu rini senaan bata' kiin.” ");
INSERT INTO stb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Pimaag rayun ni Jesus suk penulay, bu' ginumawas ini tu seg bata' ne dlai. Bu' mi'uli'an giin se guras ketu. ");
INSERT INTO stb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Rayun su ngak tinu'unan miritu ni Jesus ne gilanilan ra, bu' miksaak tu seniin, “Tuma ma ndi' ami ma mekepegawas sek penulay?” ");
INSERT INTO stb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Tendeng ay kulang suk pektu'u niyu,” miksembag si Jesus. “Sek pekemetuud esuyan'u amu, bu' duunik pektu'u niyu isan maa' kiitut ne dlisu neng muntasa, mesugu' niyuig bentud keni, ‘Gawa'a buwat se dlugar keni bu' galin'a tu se dlain ne dlugar bu' megawa' ini.’ Nda'irunig betang ne ndi' niyu mbaal!” ");
INSERT INTO stb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Seng miktipung su ngak tinu'unan tu se Galilea, miktalu' si Jesus tu senilan, “Sug Bata' ne Getaw piyal na tu ");
INSERT INTO stb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","se nga getaw neng mekpatay ri seniin; ma'ad se ketelu endaw, metubu' ra giin puli'.” Bu' su ngak tinu'unaan migu'ul gaid gupiya. ");
INSERT INTO stb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sek peddateng ni Jesus bu' se ngak tinu'unaan tu se Capernaum, su ngang meneningil neg buwis tu sek Templo mikpegaud ri ni Pedro bu' miksaak ri seniin, “Migbayad ba sung mentetendu' niyu seg buwis sek Templo?” ");
INSERT INTO stb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Wa'a, migbayad giin,” miksembag si Pedro. Sek pekseled ni Pedro tu seg balay, miguna mektalu' si Jesus, “Simon, lama run ri seni'a? Ta' ma getaway sung megbayad neg buwis bu' biyaranan tu se nga gari' ri seg benwa? Su nga getaw ba rini se dlunsud awas su ngak tuwa'? ");
INSERT INTO stb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Su ngak tuwa',” miksembag si Pedro. “Bu' maa' niin, migulugan ne gena' su nga getaw ri se dlunsud sung megbayad,” miksembag si Jesus. ");
INSERT INTO stb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“Ma'ad ndi' ta liyagan nek pedlengetan ita nu nga getaw keni. Aas peritua sed danaw bu' pemenggwit'a ritu. Uwan mu su guna neng melaaman mu nek sera', bu' riin seg baba'en me'ita' mu suk selapi' ne gigu' para seg buwis'u bu' para seni'a. Uwan mu ini bu' biyaray mu ilan se ngag buwis ta.” ");
INSERT INTO stb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sek timpu ketu, su ngak tinu'unan miritu ni Jesus bu' miksaak, “Ta' ma su dlabi ne gimpurtanti tu se nga getawan ned Diwata?” ");
INSERT INTO stb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Bu' miktawag si Jesus sek sala neg bata' bu' pi'indegen nini riin seng metungenga'an nilan, ");
INSERT INTO stb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","bu' miktalu', “Sek pekemetuud esuyan'u amu, gawas bu' me'eseb sug betasan niyu bu' mbaal amu seng maa' ne nga gembata', ndi' amu gaid mekeruma ri se nga getawan nek pidlegesegan ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aas su dlabi ne gimpurtanti tu se nga getawan nek pidlegesegan ned Diwata giin sung mekpebaba' ri se gegulingenen bu' mbaal neng maa' neg bata' keni. ");
INSERT INTO stb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Bu' su isan ta' ned dumawat ri seg bata' keni ri se ngalan'u, dumawat ri senaan.” ");
INSERT INTO stb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Bu' su isan ta' ne mbaal ne getaran neng merela'an suk sala se ngang mekiika' keni sek pektu'u ri senaan, maneg pa para se getaw ketu ne iketan ne gembagel neg batu ne dligisan su dliigen bu' leddu'en giin tu se dlaud. ");
INSERT INTO stb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mekelelaatlelaat para seg benwa ned duuni ngag betang neng mekegbaal se nga getaw neng merela'an sek pektu'u nilan! Ay ngag betang keni kanunay gaid mehitabu', ma'ad mekelelaatlelaat suk sala ne mbaal ne getaran run nini.” ");
INSERT INTO stb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Bu' su gemeg mu awas su geksud mu giin sung mekeperala' seni'a nek pektu'u, ekped mu ini bu' pidlak mu. Ay maneg pa nek sumeled'a tu se ketubu' nek pungkel su gemeg awas su geksud mu sinangkali' sed duwa'i nga gemeg bu' nga geksud mu ma'ad pidlaken'a ritu se gapuy ne ndi' mpaleng. ");
INSERT INTO stb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Bu' suk sala neng mata mu giin sung mekeperala' seni'a nek pektu'u, esuk mu ini bu' pidlak mu. Ay maneg pa para seni'a nek sumeled'a tu se ketubu' nek sinaad ned Diwata nek salabuuk raing mata mu, sinangkali' sed duwa' buuk su ngang mata mu ma'ad pidlaken'a ritu se gapuy se gimpirnu.” ");
INSERT INTO stb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Pegingatay niyu ne ndi' niyu pekpemuraan su isan sala se ngang mekiika' keni. Su ngag anghel nilan se dlangit, esuyan'u amu, migingat senilan kanunay ri seng metungenga'an ne Gama'u tu se dlangit.” ");
INSERT INTO stb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Laa pelaa' ri sek pengena'ena' niyu? Bu' su getaw ned duuning megatus ne karniruun bu' mbalag suk sala run nini, ndi' ba penawaan reli' suk siyam pulu' bu' siyam neng mengaksab tu se ngag binenturan bu' penengaunen suk salabuuk neng mibalag? ");
INSERT INTO stb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bu' se gembangaan na ini, esuyan'u amu seng metuud, nek pedleliyagen gaid giin kampuun tu sek sala ne karniru ketu sinangkali' tu sek siyam pulu' bu' siyam ne nda' mbalag. ");
INSERT INTO stb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Maa' ra run rema, su Gama' niyu tu se dlangit gena'en liyagan ned duuni gembalag isan sala na run ri se ngang mekiika' keni.” ");
INSERT INTO stb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Bu' suk pated mu sek pektu'u mekesala' ri seni'a, laway mu bu' esuyay mu giin ri sek sayepen. Ma'ad baal mu ini ne gamu ruwa' ra. Bu' menginengeg giin ri seni'a, meksambat amu puli'. ");
INSERT INTO stb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma'ad bu' ndi' giin menginengeg seni'a, peguwit'a nek sala awas duwa' tawan ned duma mu arun ‘su kada nek pentelu'en niyu mpeligen pebiyan sek pekpemetuud sed duwa' awas telu tawan,’ sumala' sek tinalu' se kesulatan. ");
INSERT INTO stb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma'ad bu' ndi' pa gaid giin menginengeg tu senilan, talu' mu ini tu se ngak sakup riin sek simbaan. Sek tambinai', bu' ndi' pa gaid giin menginengeg tu senilan, isip mu giin ne gena' duma se nga getawan ned Diwata, awas maa' neng meneningil neg buwis.” ");
INSERT INTO stb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Esuyan'u amu seng metuud: isan landuni ne ndi' niyu tugut rini seg benwa keni, ndi' rema tugut tu se dlangit, bu' landunik tugut niyu rini seg benwa keni, tugut rema ini tu se dlangit.” ");
INSERT INTO stb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Bu' esuyan'u amu pa run: se isan duwa' ri seniyu rini seg benwa neng meguyun metendeng se isan landun nek pigampu' niyu, begay ini ri seniyu ne Gama'u tu se dlangit. ");
INSERT INTO stb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ay bu' duunid duwa' awas telu neng mektipung tendeng riin se ngalan'u, diinu duma senilan.” ");
INSERT INTO stb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mbuus mikpegaud si Pedro tu ni Jesus bu' miksaak, “Ginu'u, bu' suk pated'u kanunay mekesala' ri senaan, santa'u ma giin pasayluway? Kepituu ba pasayluway giin?” ");
INSERT INTO stb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Miksembag si Jesus, “Gena' se kepitu na run, bu' ndi' se kepitu pulu' pilu'en pa se kepitu, ");
INSERT INTO stb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","tendeng ay seng medlegeseg sud Diwata maa' nini. Nud diin, duunik sala gari' neng migusay ri se nga gutang ne ngak sesugu'enen. ");
INSERT INTO stb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Seng migatad na giin sek pegusay, inuwit tu seniin suk sala nek sesugu'en neng mikuutang ri seniin se gembagel gupiya ne dlaga'. ");
INSERT INTO stb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma'ad' tendeng ay ndi' ma giin mekebayad, miksugu' su gari' neg beledya' giin gisip gulipen, duma suk sawaan, bu' su nga gembata'en, bu' su dlaun ned diin seniin, arun mbiyaraan su gutangen. ");
INSERT INTO stb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aas suk sesugu'enen middempug ri seng metungenga'an nu gari', ‘Pelugaray mau reli',’ migandyu' giin, ‘bu' biyaran'u ra su dlaun ne gutang'u seni'a!’ ");
INSERT INTO stb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bu' milelaat su gari' ri seniin, bu' pinasaylu giin, bu' nda' na pebayad ri seniin su dlaun ne gutangen, bu' pipegawasen giin.” ");
INSERT INTO stb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Rayun seng mikegawas na giin, milabeten suk sala nek sama sesugu'en neng mikuutang seniin neng miika' ra ne dlaga'. Binudluten bu' linengeken giin, ‘Biyaray mau se gutang mu!’ miktalu' giin. ");
INSERT INTO stb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Suk sama sesugu'en middempug bu' mikpe'ilelaat ri seniin, ‘Pelugaray mau reli' bu' biyaran'u ra dya'a!’ ");
INSERT INTO stb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ma'ad nda' gaid giin peliyag, tumu' piperisuun suk sama sesugu'en tampan mikebayad ri se gutangen. ");
INSERT INTO stb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sek pekiita' run nu ngad duma nek sesugu'en ne gari' seng mihitabu', linengetan ilan gaid gupiya bu' miritu ilan se gari' bu' inasuy nilan tu seniin su dlaunan. ");
INSERT INTO stb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aas pitawag rayun nu gari' suk sesugu'en ketu, ‘Melaat'a gupiya nek sesugu'en!’ miktalu' giin. ‘Nda'u dya'a ngani' pebiyaray se dlaun ne gutang mu tendeng ay mikpe'ilelaat'a ri senaan. ");
INSERT INTO stb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kina'enlan melelaat'a rema siya tu sek sama sesugu'en mu maa' sek pedlelaat'u ri seni'a?’ ");
INSERT INTO stb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Linengetan gaid gupiya su gari' bu' piperisuun suk sesugu'en arun silutan tampan mekebayad giin puli' sek tibuuk ne gutangen.” ");
INSERT INTO stb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Aas tinapus ni Jesus, “Maa' niin rema sug baalen nu Gama'u tu se dlangit ri sek salasala seniyu bu' ndi' amu mekepasaylu sek sama pated niyu neng megbuwat ri se ngak pusung niyu.” ");
INSERT INTO stb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sek peketubus na esuyay ni Jesus su ngag betang keni, migawa' giin tu se Galilea bu' miritu se dlugar seg Judea tu sed dipag geksid seg Bagel tubig neg Jordan. ");
INSERT INTO stb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bu' midlendug ri seniin su gembagel nek panen ne nga getaw bu' ritu binulungen ilan. ");
INSERT INTO stb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bu' sud duma ne ngak Pariseo miritu seniin sek pegindan ri seniin pebiyan sek peksaak. “Tinugut ba se Kesugu'an ta ne sug bana meleng ri sek sawaan se isan landun ne keterengan?” ");
INSERT INTO stb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ma'ad miksembag si Jesus, “Nda' ba niyu mbesaay ri se kesulatan neng miktalu' ne se getaran binaal ned Diwata su getaw ne dlai bu' dlibun? ");
INSERT INTO stb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Bu' miktalu' rayun sud Diwata, ‘Tendeng run nini ne keterengan, belengen nu dlai su gama'en bu' su gina'en bu' tumipung ri sek sawaan, bu' gilan duwa' mbaal nek sala,’ ");
INSERT INTO stb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","arun gena' ilan na duwa', ma'ad sala na. Aas nda'iruni getaw neng mekepegbuwag sek sinalabuuk ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Miksaak su ngak Pariseo ri seniin, “Tuma ma miktugut ma si Moses neng mekegbeleng sug bana ri sek sawaan tubus giin mekegbegay nek sulat ri sek pegbeleng ri sek sawaan?” ");
INSERT INTO stb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Miksembag si Jesus, “Tinugutan amu ni Moses neng mekepegbuwag amu tu se ngak sawa niyu tendeng ay melised amu tendu'an. Ma'ad gena' gaid ining maa' run se getaran. ");
INSERT INTO stb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Esuyan'u amu: isan ta' neg bana neng meleng ri sek sawaan, ne gena' tendeng seg imural nek pekpekighilawas, mikepenapaw giin bu' sumuway tu sed duma ne dlibun.” ");
INSERT INTO stb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bu' miktalu' su ngak tinu'unaan tu seniin, “Bu' maa' niin ma su kebetang nug bana bu' nek sawaan, maneg na ma'ad ne ndi' sumuway.” ");
INSERT INTO stb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Miksembag si Jesus, “Penendu'an keni gena' para se dlaunan, ma'ad tu se nga getaw neg binegayan nud Diwata run nini. ");
INSERT INTO stb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ay duuning midlainlain ne nga keterengan tuma ma su nga dlai ndi' sumuway: sud duma migegetaw ne ndi' ilan gaid sumuway; sud duma kinapun nek sama getaw; bu' sud duma ndi' sumuway ay pilabun nilan gupiya suk pekpenibeli sek pedlegeri'an ned Diwata. Su getaw ne dliyagaan dumawat runik penendu'an keni, baalenen nini.” ");
INSERT INTO stb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sud duma ne nga getaw miguwit ne nga gembata' tu ni Jesus arun merepenaan ilan bu' mekegampu' para senilan. Ma'ad su ngak tinu'unan mimaag tu se nga getaw. ");
INSERT INTO stb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Miktalu' si Jesus, “Tugutay niyu su ngang mekiika' ne nga gembata' neng merini senaan, bu' ndi' niyu ilan pegengay, tendeng ay maa' ne nga getaw keni misakup ri se ngak pedlegeseg ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bu' dinepenen su nga gemegen tu senilan bu' migawa' rayun giin ritu. ");
INSERT INTO stb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Duunik sala ne getaw neng miritu ni Jesus bu' miksaak, “Sir, landun ma sung melengas baalen'u arun me'angken'u su ketubu' ne genda'i gekteben?” ");
INSERT INTO stb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","“Tuma ma meksaak'a ma senaan metendeng se landuning melengas?” Miksembag si Jesus. “Duunik sala ra neng melengas. Tuman mu su nga Kesugu'an bu' liyagan mu ned duuni ketubu' mu nek sinaad ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Landun ma su nga kesugu'an?” miksaak giin. Miksembag si Jesus, “Ndi'a mekpatay; ndi'a menapaw; ndi'a meddaaw; ndi'a mekpemetuud neg balus; ");
INSERT INTO stb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tamed mu su gama' mu bu' gina' mu; bu' petail mu su ngak sumbalay mu maa' sek pekpetail mu ri se gegulingen mu.” ");
INSERT INTO stb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Tinuman'u na su dlaun ne kesugu'an keni,” miksembag sug begumbata' ne dlai. “Landun pai kina'enlan'u baalen?” ");
INSERT INTO stb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Miksembag si Jesus tu seniin, “Bu' liyagan mu ne mbaal neng metileng pebiyan se dliyagan ned Diwata ri seni'a, dlaang'a bu' beledya' mu su dlaun ne ketigeyunan mu bu' su nga galinen pembegay mu tu se ngak pupus, bu' mekaangken'a ne nga ketigeyunan tu se dlangit, bu' rayun puli'a rini bu' sunud'a senaan.” ");
INSERT INTO stb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sek pekerengeg run nini nug begumbata' ne dlai, migawa' giin neng migu'ul, tendeng ay meratu' ma ugud giin gupiya. ");
INSERT INTO stb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Miktalu' rayun si Jesus tu se ngak tinu'unaan, “Esuyan'u amu seng metuud, melised gaid sek sala ned datu' sek pegilala sed Diwata gisip Gari'. ");
INSERT INTO stb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Puli'an'u: melemu pa kampuun se kamelyo sek pedlesut ri se dluwang nek tai' sinangkali' sed datu' sek pekseled tu sek Pedlegeri'an ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sek pekerengeg run nini nu ngak tinu'unan, gembagel gaid su ketingala nilan, “Bu' maa' niin, ta' ma rayuning meluwas?” miksaak ilan. ");
INSERT INTO stb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tinenteng ilan ni Jesus bu' miksembag, “Para ri se nga getaw, ndi' gaid ini mbaal; ma'ad ri sed Diwata su dlaun ne ngag betang mbaalen.” ");
INSERT INTO stb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Rayun miktuntul si Pedro. “Enlengay mu,” miktalu' giin, “Bineleng baya' nami su dlaunen arun sumunud seni'a, lama run rayuning me'uwan nami run nini?” ");
INSERT INTO stb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Miktalu' si Jesus tu senilan, “Sek pekemetuud, telu'an'u amu, ne seng megingkud na sug Bata' ne Getaw ri sek trunuun riin seg begu neg benwa ned Diwata, gamu ne ngak sepulu' bu' ruwa' nek sumusunud'u menggingkud rema sek sepulu' bu' ruwa' ne ngak trunu arun medlegeseg sek sepulu' bu' ruwa' ne ngak tribu seg Israel. ");
INSERT INTO stb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bu' su isan ta' neng megbeleng ri se ngag balain, awas se ngak pateren, awas se gama'en, awas se gina'en, awas se ngag bata'en awas se ngag binaalen tendeng ri senaan, mekerawat giin ne dlabaw pa seng megatus pilu' bu' merawaten su ketubu' ne genda'i gekteben. ");
INSERT INTO stb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma'ad melauning mi'una numuun ne mbinai', bu' melaun remaing mibinai' numuun neng me'una. ");
INSERT INTO stb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ay su ngak pedlegeseg ned Diwata maa' sek sala tawan neng midlaang lapus sek pekpenengaw ne ngang menteterbahu ri se gubasaan. ");
INSERT INTO stb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Miliyag giin sek peksu'ul senilan seng mi'enaran nek su'ul sek sendaw nek su'ulan. Aas piperituun ilan arun mekterbahu tu se gubasaan. ");
INSERT INTO stb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Bu' midlaang giin puli' tu sek pemeledya'an seng meginenga' menaik nai gendaw bu' mi'ita'en sud duma ne nga getaw neng mingindeg ne genda'ik pigbaal nilan, ");
INSERT INTO stb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","aas miktalu' giin tu senilan, ‘Peritu amu rema bu' pekterbahu amu tu se gubasan, bu' su'ulan'u amu se ginsaktu nek su'ul.’ ");
INSERT INTO stb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aas miritu ilan. Sek peketaasendaw bu' seng miginenga' menaugi gendaw maa' ra run gusay sug binaalen. ");
INSERT INTO stb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Seng meksindep na su gendaw mipuli' giin ritu sek pemeledya'an bu' mikiita' gusay giin ne getaw neng mingindeg ritu. ‘Tuma ma pekula'an ma niyui gendaw ne genda'ik pigbaal?’ miksaak giin. ");
INSERT INTO stb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Nda'irun maing mikpeterbahu ri senami,’ miksembag ilan. ‘Na, Peritu amu se gubasan bu' pekterbahu amu ritu,’ miktalu' giin senilan.” ");
INSERT INTO stb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Bu' sek pekegebii na, su gapu' ne gubasan miktalu' tu sek sineligaan, ‘Tawag mu na su ngang minterbahu bu' su'ulay mu ilan, una mu su'ulay su ngang mibinai' mekterbahu bu' binai' mu su'ulay su ngang mi'una.’ ");
INSERT INTO stb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bu' su nga getaw neng migatad mekterbahu seng meksindep nai gendaw, binegayan su kada sala senilan nek selapi' su'ul sek sendaw nek pekterbahu. ");
INSERT INTO stb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Su nga getaw ne guna neng mikterbahu miritu arun su'ulan nek selapi', migena'ena' ilan neng mekerawat ne dlabaw kampuun; ma'ad binegayan ilan nek selapi', su'ul sek sendaw nek pekterbahu su kada sala senilan. ");
INSERT INTO stb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sek pekerawat nilan run nini, migatad ilan sek peddikelamu tu se gapu'en. ");
INSERT INTO stb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Su nga getaw neng mibinai' tumerbahu sala uras ra sung miterbehuan nilan,’ miktalu' ilan, ‘saanay gami mibegatan kampuun sek pekterbahu neng migantus se kiinit seled sek sendaw. Ma'ad sinu'ulan mu ilan maa' sek sinu'ul mu senami!’ ");
INSERT INTO stb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","‘Sambat penginengeg'a,’ miksembag su gapu'en tu sek sala se ngang minterbahu, ‘nda'u dya'a limbungay. Gena' ba miliyag'a ma nek su'ulan'u dya'a nek su'ul sek sendaw nek pekterbahu? ");
INSERT INTO stb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dawat mu suk su'ul mu bu' uli'a. Ay keliyag'u suk pegbegay tu seng mibinai' mekterbahu se dlaga' neng maa' seg binegay'u ri seni'a. ");
INSERT INTO stb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Gena' ba duun mai ketenged'u bu' landunig baalen'u se gegulingen'u nek selapi'? Awas misinakua ba tendeng ay melibegainu?’” ");
INSERT INTO stb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bu' tinapus ni Jesus, “Aas su ngang mibinai' gilan sung me'una, bu' su ngang mi'una gilan su gembinai'.” ");
INSERT INTO stb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sek tinumuwad na si Jesus tu seg Jerusalem, pinainen suk sepulu' bu' ruwa' ne ngak tinu'unaan bu' miktalu' giin tu senilan saanay nilan medlaang, ");
INSERT INTO stb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Penginengeg amu,” miktalu' giin tu senilan, “miktuwad ita na pagaw seg Jerusalem, ne ritu sug Bata' ne Getaw tudyan tu se nga geseg ne ngak pari' bu' tu se ngang mentetendu' se Kesugu'an. Ukuman nilan giin se kemetain ");
INSERT INTO stb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","bu' rayun tudyan giin tu se nga gena' Judeo, arun peddega'rega'an giin, lekpesen, bu' lensangen tu se krus. Ma'ad se ketelu endaw metubu' ra giin puli'.” ");
INSERT INTO stb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Rayun suk sawa ni Zebedeo miritu ni Jesus duma se nga gembata'en ne nga dlai. Bu' middempug giin ri seng metungenga'an ni Jesus bu' migandyu' ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Lama runi dliyagan mu?” miksaak si Jesus tu seniin. Miksembag giin, “Siguru mu senaan ne keni duwa' ne nga gembata'u ne dlai gilan sung mekegingkud ri sed dapit dlintu mu bu' ri sed dapit bibang mu se Gari'a na.” ");
INSERT INTO stb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Nda' niyu mesuunay bu' landunik pinengi niyu,” miksembag si Jesus tu se ngag bata' ne dlai. “Me'agwanta ba niyu suk pegantus nek pegentusen'u?” Miksembag ilan, “Wa'a me'antus nami.” ");
INSERT INTO stb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Mbaal lai raan niyu suk pegantus,” miktalu' si Jesus senilan, “ma'ad nda'iruni ketenged'u sek pekpili' bu' ta' sung megingkud ri se dlintuu bu' ri seg bibang'u. Nga dlugar keni para tu se ngak tinegenaan run nini nu Gama'u.” ");
INSERT INTO stb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bu' sek pekerengeg run nini nuk sepulu' tawan nek tinu'unan, linengetan ilan tu sed duwa' ne ngang mekpated. ");
INSERT INTO stb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aas tinawag ni Jesus su dlaun ne ngak tinu'unaan bu' miktalu', “Misuunan niyu ne su nga geseg nu nga gena' Judeo pedlegesegan nilan su ngak sakup nilan bu' su nga geseg duuni gembagel ne ketendanan nilan ri se ngak sakup nilan. ");
INSERT INTO stb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Keni tumu' gena' mbaya' sunuren niyu. Bu' liyagan sek sala riin seniyu ne mbaal ne dlabaw, kina'enlan giin mbaal nek sesugu'en ned duma; ");
INSERT INTO stb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","bu' liyagan sek sala riin seniyu neng me'una, kina'enlan mbaal'a ne gulipen ned duma. ");
INSERT INTO stb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Maa' neg Bata' ne Getaw, nda' perini arun penibeliyan, ma'ad arun sek pekpenibeli bu' pegbegay se ketubu'en arun sek pedlekat seng melaun ne nga getaw.” ");
INSERT INTO stb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Se gumawas na si Jesus bu' su ngak tinu'unaan tu seg Jerico, su gembagel nek panen ne nga getaw sinumunud ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bu' enlengay niyu, duunid duwa' tawan ne ngag buta neng mikpegingkud ri se geksid ned dalan. Sek pekerengeg nilan run ne si Jesus mayan, migatad ilan sek pegbeksay, “Ginu'u, Bata' dlai ni David, melelaat'a senami!” ");
INSERT INTO stb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pimaag ilan nu nga getaw bu' tinelu'an ne ndi' meksasak. Ma'ad pilebiyanan na tumu' nilan suk pegbeksay, “Ginu'u, Bata' dlai ni David, melelaat'a senami!” ");
INSERT INTO stb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mikeneng si Jesus bu' tinawag ilan, “Landun mai dliyagan niyu neg baalen'u ri seniyu?” ");
INSERT INTO stb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Miksembag ilan, “Ginu'u, liyagan nami neng mekiita'!” ");
INSERT INTO stb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Milelaat si Jesus tu senilan bu' inikapen su ngang mata nilan, bu' nda' santa' mikiita' ilan rayun, bu' midlendug ilan ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Seng megaud na si Jesus bu' su ngak tinu'unaan mateng tu seg Jerusalem, miritu ilan seg Betfage ned ditu seg bentud ne ngag Olibo. Sinugu'en rayun meguna sud duwa' ne ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Miktalu' giin tu senilan, “Peritu amu seg baryu ned ditu se gunaan, bu' me'ita' niyu rayun ritu su gasnu ne giniketan ned duuning natiin ri sek teparen. Ekasay niyu itu bu' uwit niyu rini senaan. ");
INSERT INTO stb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bu' duuning meksaak riin seniyu, sembag niyu giin, ‘Su Ginu'u midlekina'enlan run nini;’ bu' pawiten rayun ini ri seniyu.” ");
INSERT INTO stb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Keni mihitabu' arun metuman suk tinalu' nek propeta: ");
INSERT INTO stb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Esuyay niyu su nga getaw ri sek siyudad nek Zion, enlengay niyu, su Gari' niyu mikpagaw riin seniyu! Melipebeba'en giin bu' meksakay giin se gasnu, bu' seng nati ne gasnu!” ");
INSERT INTO stb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aas midlaang su ngak tinu'unan bu' tinuman nilan suk sinugu' ni Jesus senilan neg baalen. ");
INSERT INTO stb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inuwit nilan su gasnu bu' sung natiin bu' inenigan nilan su dlekuud ne gasnu bu' sung natiin se nga dlambung nilan bu' sinumakay si Jesus. ");
INSERT INTO stb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bu' su gembagel nek panen ne nga getaw mimbeklat rema se nga dlambung nilan ri sed dalan bu' sud duma mimetel ne ngak panga ne nga gayu bu' pinsiya'siya' nilan nini ri sed dalan. ");
INSERT INTO stb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bu' su ngak panen ne nga getaw neng minlaang ri se gunaan ni Jesus bu' sung midlendug ri seg binai' mimbeksay, “Siya'en sug Bata' dlai ni David! Pengumpiyanan giin ned Diwata sung mirini ri se ngalan ne Ginu'u! Siya'en sud Diwata se dlangit!” ");
INSERT INTO stb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sek sinumeled na si Jesus tu seg Jerusalem, minggelangal su dlaun ne nga getaw ritu sek siyudad, “Ta' getaw iin?” miksaak ilan. ");
INSERT INTO stb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Miksembag su nga getaw, “Giin si Jesus! Giin suk propeta neg buwat seng Nazaret nek sakup se Galilea.” ");
INSERT INTO stb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sinumeled si Jesus tu sek Templo bu' inalegen pagaw tu se gawas su dlaun neng mimenaluy bu' ngang mimeledya' ritu. Bu' pinlintuwaren su nga dlemisaan nu ngang mentelesay ne ngak selapi' bu' su nga gingkuran nu ngang memeledya'ay ne ngak selepati. ");
INSERT INTO stb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Bu' miktalu' giin tu senilan, “Misulat ini se Kesulatan ne sud Diwata miktalu', ‘Sug balay'u ingelanan ne dlugar ne ritu megampu' su nga getaw, ma'ad binaal niyu ini ne gedluran ne ngang meddaaw.’” ");
INSERT INTO stb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bu' duuni ngag buta bu' nga kawit neng mikpegaud seniin tu sek Templo, bu' pi'uli'aan ilan. ");
INSERT INTO stb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma'ad su nga geseg ne ngak pari' bu' su ngang mentetendu' se Kesugu'an pinlengetan ilan sek pekiita' nilan run su nga ketingelaan ne ngag betang neg binaal ni Jesus. Bu' pinlengetan ilan rema tu se nga gembata' neng mimbeksay tu sek Templo, “Siya'en sug Bata' dlai ni David!” ");
INSERT INTO stb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Aas sinaakan nilan si Jesus, “Mirengeg mu ba bu' landunik tinalu' nilan?” Miksembag si Jesus, “Wa'a, mirengeg'u. Nda' amu ba mekebasa run nini riin se Kesulatan, ‘Tinendu'an mu su nga gembata' bu' su ngang mekemu' pa, sek peghalad seng metileng nek peksaya' riin seni'a.’” ");
INSERT INTO stb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bu' binelengen ilan ritu bu' migawa' giin sek siyudad bu' miritu seg Betania, bu' ritu giin miktulug sek pekegebii. ");
INSERT INTO stb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na, sek pekpuli' ni Jesus tu sek siyudad sek pekesikanselem, miperii'an giin. ");
INSERT INTO stb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bu' mi'ita'en su gayu neg igira ri se geksid ned dalan. Linawaan nini, ma'ad nda' giin mekiita' neg bungaan gawas se ngad daunen. Aas miktalu' si Jesus tu se gayu, “Ndi'a na gaid mekegbunga geseb!” Sek tikmal, milawes su gayu. ");
INSERT INTO stb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sek pekiita' run nini nu ngak tinu'unaan, mitingala ilan gaid gupiya. “Pikendun run pekelawes sempun se gayu neg igira?” miksaak ilan. ");
INSERT INTO stb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Miksembag si Jesus, “Sek pekemetuud, esuyan'u amu, bu' duunik pektu'u niyu bu' ndi' menduwa'ruwa', mbaal niyu landunig binaal'u ri se gayu neg igira keni. Bu' gena' daal na run nini, ma'ad mekebaal amu sek pektalu' seg bentud keni, ‘Pegawa'a rini bu' sampak'a tu sed dagat,’ bu' metuman ini. ");
INSERT INTO stb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Bu' mektu'u amu, merawat niyu isan landunik penengiin niyu pebiyan ri sek pegampu'.” ");
INSERT INTO stb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sinumeled puli' si Jesus tu sek Templo; bu' saanain mektendu', su nga geseg ne ngak pari' bu' su nga geseg ne ngag Judeo mikpegaud bu' miksaak seniin, “Landun mai ketenged mu sek pegbaal runi ngag betang keni? Ta' maing migbegay seni'a ne ketenged?” ");
INSERT INTO stb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Miksembag si Jesus tu senilan, “Meksaaku rema riin seniyu, bu' mekesembag amu run nini, tebalan'u amu rema landuni ketenged'u sek pegbaal runi ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ta' ma migbuwat su ketenged ni Juan sek pekpemendyag: buwat ba ini sed Diwata awas se nga getaw?” Migatad ilan reli' sek pegaddat ri se gegulingen nilan, “Landun maik telu'en ta? Bu' meksembag ita, ‘Buwat sed Diwata,’ mektalu' giin senita, ‘Tuma ma nda' amu rayun pektu'u ri ni Juan?’ ");
INSERT INTO stb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma'ad bu' mektalu' ita, ‘Buwat se nga getaw,’ mendek ita landunig baalen ne nga getaw, tendeng ay miktu'u ilan gaid ne si Juan propeta.” ");
INSERT INTO stb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aas miksembag ilan tu ni Jesus, “Nda' nami mesuunay.” Miksembag si Jesus tu senilan. “Bu' maa' niin, ndi'u rema tabal seniyu bu' ta' migbuwat su ketenged'u sek pegbaal runi ngag betang keni.” ");
INSERT INTO stb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Na, laa sakan ri se gena'ena' niyu? Duunik sala getaw ned duunid duwa' buuk gembata'en ne nga dlai. Linawaan su gulangbata' bu' miktalu', ‘Eddung, peritua se gubasan nandaw bu' pekterbahua ritu.’ ");
INSERT INTO stb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Ndi'u,’ miksembag giin, ma'ad nda' santa' mi'eseb su gena'ena'en bu' miritu giin. ");
INSERT INTO stb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Miritu rayun su gama' tu se dlain neg bata'en bu' maa' ra run gusay suk tinalu'en. ‘Wa'a, ama',’ miksembag giin, ma'ad nda' giin peritu. ");
INSERT INTO stb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ta' ma sed duwa' ketu sung miktuman ri sek sugu' nu gama' nilan?” “Su gulangbata',” miksembag ilan. Aas miktalu' si Jesus tu senilan, “Esuyan'u amu: su ngang meneningil se ngag buwis bu' su nga dlibun neng mikpemeledya' ri sed dengeg nilan, meguna ilan pa seniyu sek pekseled ri se ngak pedlegesegan ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ay si Juan neng Membebendyag mirini sek pektendu' ri seniyu sed dalan se ketubu' ne dliyagan ned Diwata, ma'ad nda' amu pektu'u ri seniin; ma'ad su ngang meneningil neg buwis bu' su nga dlibun neng mikpemeledya' se ngad dengeg nilan, gilan tumu' sung miktu'u ri seniin. Bu' isan mi'ita' na niyu ini, nda' amu gusay pegeseb se nga gena'ena' niyu bu' mektu'u ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Penginengegay niyu su dlain ne galing,” miktalu' si Jesus. “Duuni getaw ned duuni dlupa'en, pimulanaan nini ne gubas. Bu' pilibutaan nini nek paril. Bu' mikpelalud giin para gintesan ne nga gubas, bu' mikpebaal rema giin neng metaas nek pegelungan. Peketubus itu, pise'upaan su gubasan bu' midlaang giin tu se dlain ne dlugar. ");
INSERT INTO stb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sek pekpengupu' na se ngag bunga nu nga gubas, piperituun su nga gulipenen tu se ngak sa'up arun uwanen sug bahinen. ");
INSERT INTO stb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Sek peddateng nu nga gulipen ritu, pindaap ilan nu ngak sa'up. Suk sala tawan ne gulipen, binentul nilan. Suk sala tawan pelun, pinatay nilan. Bu' suk sala tawan pa gaid, binatu nilan. ");
INSERT INTO stb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ma'ad su gapu' ne gubasan miksugu' puli' ne dlain ne nga gulipen tu se ngak sa'up neng melaun pa parun tu se guna. Ma'ad maa' ra run gusay sug binaal nu ngak sa'up. ");
INSERT INTO stb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Se ketapusan, sinugu'en tu senilan sug bata'en ne dlai. ‘Siguru gaid nek pegbesaan nilan sug bata'u,’ miktalu' giin. ");
INSERT INTO stb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ma'ad sek pekiita' run nu ngak sa'up ri seg bata'en, miktalu' ilan ri se gegulingen nilan, ‘Keni na sug bata' nu gapu' gubasan. Perini amu, petain ta giin arun me'angken ta su gempenunuren!’ ");
INSERT INTO stb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aas dinaap nilan giin, bu' binidlas tu se gawas ne gubasan, bu' pinatay.” ");
INSERT INTO stb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Na, sek peddateng nu gapu' ne gubasan, lama rayun sug baalenen tu se ngak sa'up ketu?” miksaak si Jesus. ");
INSERT INTO stb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“Siguru gaid nek pemetainen su ngang melaat ne ngak sa'up,” miksembag ilan, “bu' pese'upaan ri se dlain ne ngak sa'up neng metau megbegay neg bahin ri seniin se ginsaktu nek panahun.” ");
INSERT INTO stb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Miktalu' si Jesus tu senilan, “Nda' ba niyu mbasa landunik tinalu' ri se nga Kesulatan? ‘Sug batu neg binibay nu ngak panday ay genda' inik paluun mibaal na ma'ad tumu' ne dlabi ne gimpurtanti neg batu. Binaal ini ne Ginu'u; bu' ketingelaan gaid ini sek pekpengenleng!’” ");
INSERT INTO stb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Tendeng run nini, esuyan'u amu,” middugang si Jesus, “suk pedlegeseg ned Diwata uwanen na buwat riin seniyu bu' begay tu se nga getaw neng mekegbaal se landuni dliyagan ned Diwata nek pebaal tu senilan.” ");
INSERT INTO stb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sek pekerengeg run nini nu nga geseg ne ngak pari' bu' nu ngak Pariseo se nga galing ni Jesus bu' misabut nilan ne gilan suk pigelingan run nini, ");
INSERT INTO stb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","aas miktinguha' ilan sek peddaap ri seniin. Ma'ad minendek ilan seng meleget ne nga getaw, neng migilala ri ni Jesus nek propeta. ");
INSERT INTO stb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Midlegamit puli' si Jesus ne nga galing sek pegasuy tu se nga getaw. ");
INSERT INTO stb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Seng medlegeseg sud Diwata maa' nini: Duunik sala ne gari' neng mingandam se kumbira se kasal para seg bata'en ne dlai. ");
INSERT INTO stb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bu' sinugu'en su ngak sesugu'enen nek pesuunen su ngak pingenggat, ma'ad ndi' nilan liyagan meritu. ");
INSERT INTO stb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Aas miksugu' giin ne dlain ne ngak sesugu'en, duma seng minsahi para tu se ngak pingenggat: ‘Enlengay niyu, mi'andam na su kumbirau nemuun; mititi'u na su ngag baka bu' sud duma pa ne ngak pilembu'u bu' mi'andam na su dlaunan. Aas perini amu na se kumbira!’ ");
INSERT INTO stb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ma'ad su ngak pingenggat nda' pegebet bu' miritu ilan se ngang nigusyu nilan: suk sala miritu seg binaalen, su dlain miritu sek tindanen, ");
INSERT INTO stb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","saanay su ngad duma, pindaap nilan su ngak sesugu'en, pimbentul, bu' pimatay nilan. ");
INSERT INTO stb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Su gari' linengetan gupiya; aas sinugu'en su ngak sundaluun, nek pemetain su ngang mikpatay ri se ngak sesugu'enen bu' sinerengen suk siyudad nilan. ");
INSERT INTO stb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Rayun tinawagen su ngak sesugu'enen bu' miktalu' tu senilan, ‘Su kumbira se kasal mi'andam na, ma'ad su ngak pingenggat'u ndi' mbaya' run nini. ");
INSERT INTO stb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aas peritu amu se ngad dalan bu' enggat niyu su dlaun ne nga getaw neng me'ita' niyu.’ ");
INSERT INTO stb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aas su ngak sesugu'en minditu se ngad dalan bu' tinipung nilan su dlaun ne nga getaw neng me'ita' nilan, melengas bu' mekelaaten; bu' mipenu' ne nga getaw su dlugar nek pidlekumbiraan.” ");
INSERT INTO stb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Mbuus sinumeled su gari' arun sek pegenleng se ngak pingenggat, bu' mi'ita'en suk sala tawan ne nda' pekseluk nek suub para se kasal. ");
INSERT INTO stb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Sambat, pigendun mu run sek pekseled rini ne nda'a ma pekseluk sek suub para se kasal?’ Su gari' miksaak ri seniin. Ma'ad su getaw nda' mekesembag. ");
INSERT INTO stb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Rayun miktalu' su gari' tu se ngak sesugu'en, ‘Gapus niyu su nga gemeg bu' nga geksuren, bu' pidlak niyu giin tu se gawas, seng mereleman; ditu meksegaw giin bu' mekpengkiget se nga ngisiin.’” ");
INSERT INTO stb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bu' tinapus ni Jesus su galing, “Melaun su ngak pingenggat, ma'ad miika' ra su gempili'.” ");
INSERT INTO stb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Rayun su ngak Pariseo miktipung bu' mikpelanu sek pedlekwit ri ni Jesus pebiyan ri se ngak saak. ");
INSERT INTO stb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bu' sinugu' nu ngak Pariseo sud duma ne ngak tinu'unan nilan bu' duma se ngak sakup se dlumpuk ni Herodes. “Sir,” miktalu' ilan, “misuunan nami ne dya'a migasuy se kemetuuran. Tinendu' mu su kemetuuran metendeng se keliyag ned Diwata tu se nga getaw, ne se genda'ik pegules tu sek pigena'ena' nud duma, tendeng ay nda' mu begayay ne gimpurtanti isan ta' ilan pa ne getaw. ");
INSERT INTO stb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Esuyay mu ami rayun, landun ma ri se gena'ena' mu? Supak ba se Kesugu'an ta suk pegbayad neg buwis tu se Gari' seg Roma, awas gena'?” ");
INSERT INTO stb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma'ad si Jesus mikesuun ri seng mekelaat nek pelanu nilan, bu' aas miktalu' giin, “Gamu ne ngang mikpelaunglaung! Tuma ma menantu amu sek pedlekwit ri senaan? ");
INSERT INTO stb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pe'ita'ay niyau nek pelata nek selapi' nek pembayad seg buwis!” Bu' inuwitan nilan giin nek pelata nek selapi', ");
INSERT INTO stb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","bu' miksaak giin tu senilan, “Ta' ma neng mulu' bu' ngalan runid diin sek pelata nek selapi' keni?” ");
INSERT INTO stb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Se Gari',” miksembag ilan. Aas miktalu' si Jesus tu senilan, “Begay niyu tu se Gari' suk para riin se Gari', bu' tu sed Diwata suk para ri sed Diwata.” ");
INSERT INTO stb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sek pekerengeg nilan run nini, mitingala ilan gupiya. Aas bineleng nilan giin bu' migawa' buwat ritu. ");
INSERT INTO stb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Se gendaw gusay ketu, miritu sud duma ne ngak Saduceo tu ni Jesus. Gilan su ngang miktalu' ne nda'irunik peketubu' puli' nu ngang mimatay. ");
INSERT INTO stb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Sir,” miktalu' ilan, “Si Moses miktalu', ‘Ne bu' su dlai matay ne genda'i ngag bata'en, suk pateren ne dlai kina'enlan mengesawa tu seg balu ne dlibun ketu, arun mengembata' ilan ne ilelaan ne gembata' nuk pateren neng minatay.’ ");
INSERT INTO stb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na, duunik pitu tawan neng mekpated nek puru dlai neng mikengel rini. Su gulangbata' mingesawa ma'ad nda' tagad mekebata' minatay. Aas sung mibalu pingesawa nu keruwa' nek pateren. ");
INSERT INTO stb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Maa' ra run gusay sung mihitabu' tu se keruwa' nek pateren, se ketelu, bu' tampan tu se kepitu. ");
INSERT INTO stb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sek tambinai' minatay rema su dlibun. ");
INSERT INTO stb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na, se gendaw nek petubu'en puli' su ngang mimatay, ta' ma rayun sek pitu ketu sung mekepengesawa tu se dlibun ay su dlaun nilan mikepengesawa ma ri seniin?” ");
INSERT INTO stb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Miksembag si Jesus tu senilan, “Misayep amu! Mihitabu' ini tendeng ay nda' niyu mesuunay su nga Kesulatan bu' su ga'em ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ay sek petubu'en na puli' su ngang mimatay, maa' ilan ne ngag anghel tu se dlangit bu' ndi' na sumuway. ");
INSERT INTO stb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na, metendeng se ngang mimatay neng metubu' puli': nda' ba niyu mbasa suk tinalu' ned Diwata riin seniyu? Miktalu' giin, ");
INSERT INTO stb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Gaku' sud Diwata ni Abraham, Diwata ni Isaac, bu' Diwata ni Jacob.’ Giin sud Diwata se ngak tetubu', bu' gena' Diwata se ngang mimatay.” ");
INSERT INTO stb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sek pekerengeg run nini nu nga getaw mitingala ilan gaid gupiya sek pekpenendu'en. ");
INSERT INTO stb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sek pekerengeg run nini nu ngak Pariseo neng milupig ni Jesus su ngak Saduceo se keterengan, miktipung ilan, ");
INSERT INTO stb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","bu' sala senilan, mentetendu' se Kesugu'an, migindan sek peksaak ri ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Sir,” miksaak giin, “Landun ba gaid su dlabi ne gimpurtanti nek sugu' riin se Kesugu'an?” ");
INSERT INTO stb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Miksembag si Jesus, “Petail mu su Ginu'u ned Diwata mu sek tibuuk nek pusung mu, sek tibuuk ne kalag mu, bu' sek tibuuk ne gena'ena' mu. ");
INSERT INTO stb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Giin nini su dlabi ne gimpurtanti nek sugu' se dlaunan. ");
INSERT INTO stb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bu' su keruwa' maa' ra run rema se guna: ‘Petail mu suk samaataw mu maa' sek pekpetail mu ri se gegulingen mu.’ ");
INSERT INTO stb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bu' suk tibuuk ne Kesugu'an ni Moses bu' su ngak penendu'an ne ngak propeta migatad sed duwa' ne ngak sugu' keni.” ");
INSERT INTO stb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Seng miktigum na su ngak Pariseo, miksaak si Jesus tu senilan, ");
INSERT INTO stb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Landun ma ri se gena'ena' niyu metendeng ri seng Misiyas? Ta' ma ne gasal run giin?” “Gasal giin ni David,” miksembag ilan. ");
INSERT INTO stb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Bu' maa' niin,” miktalu' si Jesus tu senilan, “pebiyan se ga'em ne Gispiritu ned Diwata, tinawag giin ni David ne ‘Ginu'u?’ Ay miktalu' si David, ");
INSERT INTO stb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Miktalu' su Ginu'u tu se Ginu'uu: Gingkud'a rini sed dapit ne dlintuu tampan daagen'u su nga kuntra mu bu' mpedlegesegan mu ilan.’ ");
INSERT INTO stb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Aas bu' tinawag ma giin ni David ne ‘Ginu'u,’ pekendun ma rayun ne sung Misiyas mbaal ne gasal ni David?” ");
INSERT INTO stb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nda'irun gaid sung mikesembag ri sek saak ni Jesus. Gatad se gendaw ketu, nda'irun naing minantu sek peksaak ri ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Miktalu' rayun si Jesus tu se nga getaw bu' tu se ngak tinu'unaan, ");
INSERT INTO stb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Su ngang mentetendu' se Kesugu'an bu' su ngak Pariseo sud duuni ketengeren sek pegubad ri se Kesugu'an ni Moses. ");
INSERT INTO stb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Aas kina'enlan tumanen niyu bu' sunuren su ngak tinalu' nilan neg baalen niyu; ma'ad ndi' niyu sunuray su ngag binaal nilan tendeng ay nda' nilan baalay landunig winali nilan. ");
INSERT INTO stb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Migegbed ilan ne gembegat bu' melised ne nga guwiten nek pipisaan nilan tu se nga getaw ma'ad gilan mismu ndi' ngani' gumamit isan sek sala nek tendu' nilan arun pegabang sek pekpisaan se nga guwiten ketu. ");
INSERT INTO stb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bu' binaal nilan su dlaun ne ngag betang arun ma'aray me'ita' ilan ne nga getaw. Pilambeg nilan su ngang melektin ne ngak seleran ne ngak sinulat ne ngag birsikulu buwat se Kesulatan ne inegbed nilan riin se nga gangas nilan bu' riin se ngag biingken nilan. Bu' piyaba' pa gaid nilan su ngak pingulimpay ri se kumiling ne nga dlambung nilan. ");
INSERT INTO stb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Liyagan nilan ned diin ilan pe'ingkuray se dlabi neng melengas ne dlugar ri se nga kumbira bu' ri se nga gingkuran ne ngak tinamed sek pektiguman ne nga getaw Judeo; ");
INSERT INTO stb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","bu' liyagan nilan nek pegbesaan ilan riin se ngak tebu'an bu' tuwagen ne nga getaw neng ‘Mentetendu'.’ ");
INSERT INTO stb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ma'ad kina'enlan ndi' amu mekpetawag neng ‘Mentetendu'’ ay meksama amu dlaun niyu bu' sala raing Mentetendu' niyu. ");
INSERT INTO stb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ndi' amu rema mekpetawag ne ‘Gama'’ rini seg benwa se isan ta', ay sala ra gaid su mbaya' tuwagen ne Gama', su Gama' tu se dlangit. ");
INSERT INTO stb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bu' ndi' amu rema mekpetawag ne ‘Gegalen,’ ay sala rai gegalen niyu ne giin sung Misiyas. ");
INSERT INTO stb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bu' ta' su dlabaw riin seniyu kina'enlan mbaal niyu giin nek sesugu'en. ");
INSERT INTO stb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma'ad su isan ta' neng mekpelabaw se gegulingenen pebeba'en giin, ma'ad sung mekpebaba' se gegulingenen pelebaun giin.” ");
INSERT INTO stb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ma'ad mekelelaatlelaat amu, ngang mentetendu' se Kesugu'an bu' ngak Pariseo, ay mikpelaunglaung amu! Tinerengkaan niyu sud dungawan tu se ngak pedlegesegan ned Diwata riin seng metungenga'an ne nga getaw, ma'ad gamu mismu ndi' ma sumeled, bu' ndi' mekpeseled se nga getaw ne dliyagan nilan sumeled! ");
INSERT INTO stb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mekelelaatlelaat amu, ngang mentetendu' se Kesugu'an bu' ngak Pariseo, ay mikpelaunglaung amu! Dinipag niyu su ngad dagat bu' linawan niyu su dlaun ne ngang nasud arun merunggatan suk sala ne getaw. Bu' seng merunggatan na niyu su getaw, binaal na ma'ad tumu' niyu giin ne dlabaw pa ne mbaya' me'impirnu sinangkali' seniyu! ");
INSERT INTO stb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mekelelaatlelaat amu ne ngag buta ne gunut! Miktendu' amu, ‘Bu' menumpa' suk sala ne getaw ri sek Templo, ndi' na kina'enlan nek tumanenen suk pinumpa'en; ma'ad bu' menumpa' giin tendeng seg bulawan ned ditu sek Templo, kina'enlan gaid nek tumanenen suk pinumpa'en.’ ");
INSERT INTO stb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ngag buralburalen amu bu' ngag buta! Ta' mai dlabi ne gimpurtanti sug bulawan awas suk Templo neng mikepebala'an seg bulawan? ");
INSERT INTO stb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Miktendu' amu rema, ‘Bu' menumpa' su getaw ri sek pengilakan, ndi' na kina'enlan nek tumanenen pa suk pinumpa'en, ma'ad bu' su getaw menumpa' ri se gilak riin sek pengilakan, kina'enlan gaid nek tumanenen suk pinumpa'en.’ ");
INSERT INTO stb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ngag buta amu gaid! Ta' mai dlabi ne gimpurtanti, su gilak awas suk pengilakan ne giin sung mikepebala'an se ginilak? ");
INSERT INTO stb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aas su getaw neng menumpa' ri sek pengilakan, minumpa' giin run nini bu' se dlaun ne ginilak ri sek pengilakan; ");
INSERT INTO stb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","bu' menumpa' su getaw ri sek Templo, minumpa' giin run nini bu' tu sed Diwata, neng mikengel ritu; ");
INSERT INTO stb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","bu' menumpa' su getaw tu se dlangit, minumpa' giin ri sek trunu ned Diwata, bu' tu sed Diwata neng migingkud ritu. ");
INSERT INTO stb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mekelelaatlelaat amu ne ngang mentetendu' se Kesugu'an bu' ngak Pariseo, ay mikpelaunglaung amu! Migbegay amu se nga kesepulu' niyu tu sed Diwata bu' isan sek sengku' ne ngak peddaut niyu maa' ne ngag herbabuena, anis, bu' gelingag, ma'ad bineleng niyu su dlabi ne gimpurtanti ne ngak penendu'an ri se Kesugu'an, maa' seg hustisya, sek pekemelilelaaten, bu' sek pekemetinuuren. Mbaya' siya neg baalen niyu ini se genda'ik pegbeleng tu se ngad duma. ");
INSERT INTO stb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ngag buta amu ne gunut! Sinala' niyu suk piit buwat se ginumen niyu, ma'ad inerul niyu su kamelyo! ");
INSERT INTO stb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mekelelaatlelaat amu ne ngang mentetendu' se Kesugu'an bu' ngak Pariseo, ay mikpelaunglaung amu! Inugasan niyu su gawas nek tasa bu' pinggan niyu, ma'ad pipenu' niyu ini ne gaan bu' ginumen pebiyan sek pekpenlupig bu' kerelaw. ");
INSERT INTO stb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ngag buta amu ne ngak Pariseo! Una reli' niyu ugasay suk seled nek tasa bu' pinggan bu' melimpiyu rema su gawasen nini. ");
INSERT INTO stb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mekelelaatlelaat amu ne ngang mentetendu' se Kesugu'an bu' ngak Pariseo, ay mikpelaunglaung amu! Maa' amu ne nga dlebeng nek pinintalan ne gemputi' bu' melengas enlengan ri se gawas, ma'ad ri sed diyalem mipenu' ne ngag bekeg ne ngang minatay bu' se dlaun ne kelasi ne ngang milasak. ");
INSERT INTO stb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Seng maa' run nek pebiyan, ri se gawas mekpe'ita' amu neng melengas tu se dlaunan, ma'ad riin sek seled, mipenu' amu sek pekpelaunglaung bu' se ngak sala'. ");
INSERT INTO stb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mekelelaatlelaat amu ne ngang mentetendu' se Kesugu'an bu' ngak Pariseo, ay mikpelaunglaung amu! Ay binaalan niyu ne nga dlebengan su ngak propeta bu' pimbulakbulakan pa gaid niyu su ngang munyumintu nu nga getaw neng midleketubu' neng metareng. ");
INSERT INTO stb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bu' miktalu' amu, ‘Bu' tetubu' ami na sek panahun nu nga gepu'an nami, ndi' gaid nami baalen sug binaal nilan bu' suk pekpatay se ngak propeta.’ ");
INSERT INTO stb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aas, inangken niyu ne gamu gasal nu nga getaw neng mikpatay se ngak propeta. ");
INSERT INTO stb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ala, peddayun amu, tubus niyu gaid su ginetaran nu nga gepu'an niyu. ");
INSERT INTO stb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Gamu maa' ne ngang mamak neng menlu'ib! Pekendunen niyu pedlaguy arun ndi' amu mesilutan ritu se gimpirnu? ");
INSERT INTO stb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Aas telu'an'u amu: puwitan'u amu ne ngak propeta, bu' nga getaw neng metau gupiya, bu' ngang mentetendu'. Petain niyu sud duma senilan, bu' lensangen niyu ri se krus sud duma, bu' bentulen niyu sud duma riin sek seled se ngak pektiguman niyu, bu' geteren niyu sud duma senilan buwat ri sek sala ne dlunsud pagaw tu se dlain ne dlunsud. ");
INSERT INTO stb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tendeng run nini, suk silut sek pekpatay se dlaun ne nga getaw ne genda'i ngak sala'en pe'angken riin seniyu, gatad pa sek pekpatay se genda'ik sala'en ne si Abel tampan sek pekpatay riin ni Zacarias neg bata' ni Barakias nek pinatay niyu ri sek titenga' nek Templo bu' pengilakan. ");
INSERT INTO stb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sek pekemetuud esuyan'u amu, suk silut para se dlaun ne ngak pekpatay ketu penembagen ne nga getaw sek panahun keni. ");
INSERT INTO stb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Gamu nek taga Jerusalem! Pinatay niyu su ngak propeta bu' binatu niyu su ngak sinugu' ned Diwata riin seniyu! Seng melaun nek panahun, liyagan'u ne ekepen su dlaun ne nga getaw niyu, maa' ned deluwan nek tinipungen su ngak pesuyen ri sed diyalem ne gekpaken, ma'ad ndi' niyu ini liyagan! ");
INSERT INTO stb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bu' aas sud Diwata ndi' na medduma riin seniyu. ");
INSERT INTO stb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gatad nemuun, esuyan'u amu, ndi' niyau na pelun me'ita' puli' tampan mektalu' amu, ‘Pengumpiyanan giin ned Diwata, sung mirini ri se ngalan ne Ginu'u.’” ");
INSERT INTO stb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Migawa' si Jesus buwat sek Templo bu' saanay midlaang giin, mikpegaud seniin su ngak tinu'unaan bu' tinendu' nilan ri ni Jesus su ngag balay neng misakup ri sek tibuuk nek Templo. ");
INSERT INTO stb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“Wa'a,” miktalu' si Jesus, “mi'ita' niyu nemuun su dlaunan keni. Sek pekemetuud, telu'an'u amu run nini: nda'irun isan sala se ngag batu rini neng mekpebilin riin seng mibetangaan; megela' gaid ini megeba'.” ");
INSERT INTO stb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Seng migingkud si Jesus tu seg bentud ne ngag Olibo, su ngak tinu'unan miritu seniin ne gilanilan ra, “Esuyay mu ami, nanu ma ini mehitabu'?” miksaak ilan, “bu' landun maing mehitabu' neng mekpe'ita' ne suk panahun para sek pekpuli' mu bu' su ketapusan neg benwa.” ");
INSERT INTO stb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Miksembag si Jesus: “Mekpetigaam amu bu' ndi' niyu tugutay ned duuning medlimbung riin seniyu. ");
INSERT INTO stb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ay melauni nga getaw neng mentuwa' neng medlegamit se ngalan'u, ‘Gaku' sung Misiyas,’ bu' melauning melimbungan nilan. ");
INSERT INTO stb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mekerengeg amu ne nga gubat ri seng megaud bu' ngag balita' ne nga gubat ri seng melayu'; ma'ad ndi' amu megules, ay su ngag betang keni kina'enlan gaid neng mehitabu', ma'ad gena' pa ini su ketapusan. ");
INSERT INTO stb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ay gumubat sung nasud tu se dlain neng nasud, bu' sumulung suk sala nek pedlegeri'an tu se dlain nek pedlegeri'an. Bu' duuni nga gutem bu' nga dlinug ri se dlainlain ne nga dlugar. ");
INSERT INTO stb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aas dlaunan ne ngag betang keni getaran na run, maa' se guna ne nga kegeel sek pekpengembata'.” ");
INSERT INTO stb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Rayun daapen amu bu' piyal amu tu se nga getaw arun silutan bu' sud duma seniyu pemetain. Bu' kada sala seniyu gemetan ne nga getaw tendeng ay ne ngak tinu'unan'u amu. ");
INSERT INTO stb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bu' melaun naing megawa' ri sek pektu'u nilan sek panahun ketu; medlelu'ibay ilan bu' medlegemetay su kada sala. ");
INSERT INTO stb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Rayun melauning mentuwa' ne gena' metuud ne ngak propeta bu' melimbungan nilan sung melaun ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bu' tendeng sek pedlelaup se kelaatan, melauni nga getaw ne ndi' na mekpepetailay. ");
INSERT INTO stb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma'ad su isan ta' sung mekpeddayun tampan se ketapusan meluwas. ");
INSERT INTO stb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bu' su Gempiya ne Gesuyen metendeng sek Pedlegeseg ned Diwata waliin tu sek tibuuk neg benwa gisip pekpemetuud tu se dlaun ne nga getaw; bu' dekag pa rayun mateng su ketapusan. ");
INSERT INTO stb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Me'ita' niyu ‘Sung Mekeendek Gupiya’ ne ginasuy ni propeta Daniel neng megindeg tu seg bala'an ne dlugar.” (Para seng membebasa: sabut niyu landuni gulugaan nini.) ");
INSERT INTO stb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Rayun su nga getaw ned ditu seg Judea gumebek tu se ngag binenturan. ");
INSERT INTO stb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Su getaw ned diin sed dibabaw ne gatep neg balain kina'enlan ne gumebek pelayu' pagaw tu se ngag binenturan ndi' na melangan muwan se ngag betangen seled seg balain. ");
INSERT INTO stb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Su getaw ned diin seg binaal ndi' na muli' arun maangay ne dlambungen, ma'ad kina'enlan gumebek pelayu' tu se ngag binenturan. ");
INSERT INTO stb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mekeendekendek su nga gendaw ketu para ri se ngag beres bu' para se nga gina' ned duuning miika' neg bata'en! ");
INSERT INTO stb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pegampu' amu tu sed Diwata ne ndi' amu mekedlaguy sek panahun nek penteddaw awas se Gendaw nek Pengulali! ");
INSERT INTO stb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ay sek panahun ketu, su nga getaw mekesagad se dlabi pa ne nga keliseran ne genda' pa mayan mesegaray gatad pa se getaran neg benwa tampan nemuun. Bu' nda'irun naing mehitabu' pa neng maa' nini. ");
INSERT INTO stb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bu' pibeba'an na nud Diwata su nga gendaw ketu; ay bu' nda'en itu baalay, nda'irun isan sala neng metubu'. Ma'ad para se ngak pinili'en ne nga getaw, pibeba'aan su nga gendaw ketu.” ");
INSERT INTO stb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Rayun bu' duuning mektalu' seniyu, ‘Enlengay niyu, keni na sung Misiyas!’ awas ‘Ditu giin!’ ndi' amu pektu'u run nini. ");
INSERT INTO stb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ay su gena' metuud ne ngang Misiyas bu' gena' metuud ne ngak propeta mentuwa'; megbaal ilan ne gembagel ne ketingelaan bu' nga gilelaan arun melimbungan nilan su nga getaw, isan pa su ngak pimili' ne nga getawan ned Diwata, bu' mbaal nilan nini. ");
INSERT INTO stb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Penginengeg amu! Inesuyan'u amu na daan metendeng run nini.” ");
INSERT INTO stb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Bu' duuni getaw neng mektalu' ri seniyu, ‘Enlengay niyu, ditu giin se kemingawan,’ ndi' amu peritu; awas mektalu' ilan seniyu, ‘Enlengay niyu, dini giin sek seled migedlud,’ ndi' niyu tu'uway. ");
INSERT INTO stb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ay sug Bata' ne Getaw mpuli' rini, maa' ne gilat ne kuminlap buwat sek sebangan pagaw tu sek sindepan.” ");
INSERT INTO stb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Bu' ta'i ngag bangkay, ritu rema mektipempen su ngang manuktalun neng maan ne ngag bangkay.” ");
INSERT INTO stb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Se gendi' mpayat, metapus na suk pegantus se nga gendaw ketu, su gendaw ndi' na meddelaag, sug bulan ndi' na sumanag, su ngag bituun medladdu' buwat se dlangit, bu' su nga kega'em ritu se gawanawanan pebalagen buwat seng mi'enaran neg biyanan nilan. ");
INSERT INTO stb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Bu' rayun su gilelaan seg Bata' ne Getaw me'ita' riin se dlangit; bu' su dlaun ne nga getaw ri seg benwa mensegaw ned duuni gendek saanay me'ita' nilan sug Bata' ne Getaw neng mateng riin se nga ginanud ri se dlangit duma se ga'em bu' se gembagel ne kesanag buwat sed Diwata. ");
INSERT INTO stb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bu' seng melanug nek talu' nek trumpita, sugu'enen su ngag anghelen arun tipungen nilan su ngak pimili'en ne nga getawan buwat se dlaun ne nga dlugar seg benwa gatad sek sala ne ginekteban tampan sed duma ne ginekteban.” ");
INSERT INTO stb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Uwanay niyu nek penendu'an su gayu neg Igira. Seng menlunaw bu' mengumuk na su ngak pangaan bu' mengintubil na ini, mesuunan niyu neng megaud na memeres. ");
INSERT INTO stb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Seng maa' run rema nek pebiyan, seng me'ita' niyu su dlaunan keni, mesuunan niyu ne suk panahun megaud na, bu' andam na sek pegatad. ");
INSERT INTO stb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tima'anay niyu ne dlaunan keni mehitabu' se ndi' pa matay su dlaun ne nga getaw neng miktetubu' pa nemuun. ");
INSERT INTO stb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Merala' ma su dlangit bu' su dlupa', ma'ad su ngak talu'u mekpebilin se genda'i gekteben.” ");
INSERT INTO stb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ma'ad metendeng se gendaw bu' se guras, nda'iruning mikesuun run, isan pa su ngag anghel tu se dlangit awas gaku' neg Bata' ne Getaw, su Gama' ra giin sung mikesuun. ");
INSERT INTO stb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Suk peddateng seg Bata' ne Getaw maa' seng mihitabu' sek panahun ni Noe. ");
INSERT INTO stb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ay se nga gendaw ketu, se nda' pa mateng su dlunup, su nga getaw minaan bu' miginum, su nga dlai bu' nga dlibun migesawa, tampan se gendaw nek sinumeled si Noe tu seg arka; ");
INSERT INTO stb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","nda' nilan mesuunay landuning mehitabu' tampan minateng su dlunup bu' milemes ilan. Maa' niin rema sung mehitabu' se gendaw ne sug Bata' ne Getaw mpuli' na rini. ");
INSERT INTO stb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sek panahun ketu duunid duwa' dlai neng mekterbahu ri seg binaal: suk sala me'uwit bu' suk sala mbilin. ");
INSERT INTO stb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Duun remaid duwa' dlibun saanay mekpedligis nek para pekaan, suk sala me'uwit bu' suk sala mbilin. ");
INSERT INTO stb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Aas, pegbantay amu kanunay, ay nda' niyu mesuunay bu' laa endaway run suk pekpuli' ne Ginu'u niyu. ");
INSERT INTO stb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bu' su gapu' neg balay mekesuun pa ma'ad bu' laa urasay run mateng sung meddaaw, megbantay gaid giin bu' ndi'en gaid tugut ne sung meddaaw mekeseled ri seg balain. ");
INSERT INTO stb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aas mengandam amu gaid kanunay, tendeng ay sug Bata' ne Getaw mpuli' se guras ne nda' niyu giin peretengay.” ");
INSERT INTO stb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ta' ma rayun sung meseligan bu' me'alam nek sesugu'en? Giin suk sala nek piniyalan nu gegalenen sek peddumala se ngak sama sesugu'enen sek pegbegay ri senilan ne gaan se ginsaktu ne guras. ");
INSERT INTO stb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pedleliyagen gaid suk sesugu'en ketu; bu' sek pekpuli' nu gegalenen neng meretengan giin neng mikpegbaal se ngak pibaal ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sek pekemetuud esuyan'u amu, siguru gaid nek piyal nu gegalenen ri seniin suk pedlegeseg ri se dlaun ne nga ketigeyunaan. ");
INSERT INTO stb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ma'ad bu' melaat giin nek sesugu'en, mektalu' giin ri se gegulingenen ne mpayat pa mpuli' su gegalenen, ");
INSERT INTO stb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","bu' etaraan rayun pemunalay su ngak sama sesugu'enen, bu' medduma giin maan bu' meginum tu se ngang megbinabeleng. ");
INSERT INTO stb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Rayun su gegalen nuk sesugu'en ketu minateng se gendaw ne nda'en pedderemaay bu' sek panahun ne nda'en mesuunay, ");
INSERT INTO stb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","bu' mbagel gaid suk silut ri seniin nu gegalenen bu' lempu'en giin tu se ngang mimpelaunglaung. Ritu giin meksegaw bu' mekpengkiget se nga ngisiin. ");
INSERT INTO stb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Sek panahun ketu suk pedlegari' ned Diwata mpetanggi' seng maa' nini: Duunik sepulu' ne ngad delaga neng mingguwit ne ngak sulu' bu' minlaang arun sumungkak ri sek pemenaan. ");
INSERT INTO stb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Su dlima senilan buralburalen bu' su dlain ned dlima me'alam. ");
INSERT INTO stb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Su dlima neg buralburalen miguwit ne ngak sulu' ma'ad nda' ilan peguwit ne dlana para pendugang, ");
INSERT INTO stb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","saanay su ngang me'alam miguwit ne dlana para pendugang ri se ngak sulu' nilan. ");
INSERT INTO stb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na, mipayat ma mateng suk pemenaan, aas pinundyeng ilan bu' tinulug.” ");
INSERT INTO stb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Sek peketitenga' gebii na, duuning migbeksay: ‘Kiin na suk pemenaan! Penggawas amu bu' sungkak niyu giin!’ ");
INSERT INTO stb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aas suk sepulu' ne ngad delaga migbuwat bu' inandam nilan su ngak sulu' nilan. ");
INSERT INTO stb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bu' su ngad delaga neg buralburalen miktalu' tu se ngad delaga neng me'alam, ‘Ilasay niyu ami ne dlana ay mpaleng na su ngak sulu' nami.’ ");
INSERT INTO stb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sinumembag su ngad delaga neng me'alam, ‘Ndi', ay ndi' ini metektub para seniyu bu' senami. Peritu amu se ngak tindaan bu' pemenaluy amu para ri se gegulingen niyu.’ ");
INSERT INTO stb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Aas midlaang su ngag buralburalen ne ngad delaga sek pekpenaluy ne dlana; saanay minlaang ilan, minateng suk pemenaan. Su dlima ne ngad delaga neng mi'andam na, mikedduut tu sek pemenaan sek pekseled tu se kumbira se kasal, bu' siniraan sud dungawan.” ");
INSERT INTO stb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Nda' santa', minateng sud duma ne dlima ne dlibun bu' miksabi, ‘Sir, sir! peseled mu ami!’ ");
INSERT INTO stb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma'ad miksembag suk pemenaan, ‘Nda'u mekilala ri seniyu.’” ");
INSERT INTO stb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bu' tinubus ni Jesus su galing, “Pegbantay amu, tendeng ay nda' niyu mesuunay su gendaw awas su guras.” ");
INSERT INTO stb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sek panahun ketu suk pedlegari' ned Diwata mpetanggi' seng maa' nini: “Duunik sala ne getaw nek sungu' na medlaang tu se dlain ne dlugar. Tinawagen su ngak sesugu'enen bu' piddumala ri senilan su ketigeyunaan. ");
INSERT INTO stb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Binegayaan suk salasala senilan sumala' seng megaga nilan. Suk sala senilan binegayaan ne dlima libu ne ngag bulawan nek selapi', suk sala binegayaan ned duwa' libu bu' suk sala binegayaan nek sala libu. Bu' rayun midlaang giin. ");
INSERT INTO stb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Suk sesugu'en neng mikerawat ne dlima libu ne ngag bulawan nek selapi' midlaang rayun bu' pinigusiyuun suk selapi' ketu, bu' mikeginansiya giin ne dlima libu. ");
INSERT INTO stb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Maa' ra run rema sung mikerawat ned duwa' libu midlaang rayun bu' pinigusiyuun suk selapi' ketu bu' mikeginansiya rema giin ned duwa' libu. ");
INSERT INTO stb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma'ad sung mikerawat nek sala libu midlaang rayun, midluwak ri se dlupa', bu' inedluren suk selapi' nu gegalenen.” ");
INSERT INTO stb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Dluwat se gempayat nek panahun, su gegalen nilan mipuli' arun balansiin suk selapi'en duma senilan. ");
INSERT INTO stb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Suk sesugu'en neg binegayan ne dlima libu nek selapi' miritu se gegalenen neng miguwit se dlain ne dlima libu ne ginansiyaan. ‘Binegayan mau ne dlima libu nek selapi',’ miktalu' giin. ‘Sir, enlengay mu! Keni ra su ginansiyaan ne dlima libu rema.’ ");
INSERT INTO stb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Binaal mu sung melengas, melengas'a bu' keseligan'a nek sesuguen!’ miktalu' su gegalenen. ‘Tendeng ay keseligan'a ri seng miika' ne nga dlaga', aas piyalan'u dya'a se gembagel ne nga dlaga'. Perinia, peddumaa ri sek pedleliyag'u!’ ");
INSERT INTO stb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mbuus suk sesugu'en neng mikerawat ned duwa' libu, miritu rema se gegalen bu' miktalu', ‘Sir, binegayan mau ned duwa' libu nek selapi'. Enlengay mu! Keni ra su ginansiyaan ned duwa' libu rema.’ ");
INSERT INTO stb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Melengas bu' keseligan'a nek sesugu'en!’ miktalu' su gegalenen. ‘Tendeng ay keseligan'a ri seng miika' ne nga dlaga', piyalan'u dya'a se gembagel ne nga dlaga'. Perinia, peddumaa ri senaan sek pedleliyag'u!’ ");
INSERT INTO stb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Bu' rayun suk sesugu'en neng mikerawat nek sala libu, miritu rema se gegalen bu' miktalu', ‘Sir, misuunan'u ne dya'a su getaw ne nda'i dlelaaten. Minguwan'a se nga ginansiya ne gena' dya'a sung mighagu' run, bu' midlegania ne gena' dya'a sung migerek run. ");
INSERT INTO stb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Aas minendeku, aas midlaangu bu' linebeng'u suk selapi' mu ri se dlupa'. Enlengay mu! Kini ra suk selapi' mu.’ ");
INSERT INTO stb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Melaat'a bu' metapul nek sesugu'en!’ miktalu' su gegalenen. ‘Misuunan mu ma siya neng midleganiu ne gena' gaku' sung mimula run, bu' migipes ne gena' gaku' sung migerek run, ");
INSERT INTO stb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","kina'enlan dinipusitu mu siya suk selapi'u tu seg bangku, arun sek pekpuli'u, me'uwan'u puli' su dlaun nek selapi'u duma sek tubu'en.’ ");
INSERT INTO stb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Aas miksugu' rayun su gegalen tu se dlain ne ngak sesugu'en, ‘Ala, uwan niyu ri seniinik selapi' kiin bu' begay niyu tu sek sesugu'en ned duunik sepulu' libu nek selapi'en. ");
INSERT INTO stb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ay su getaw ned duuning niin dugangan pa, bu' mekaangken giin ne dlabaw pa seng niin nek pengina'enlan. Ma'ad su getaw ne genda'iruning niin, isan pa sung mitut ned diin seniin uwanen pa buwat ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Para sek sesugu'en ne genda'ik paluun; pidlaken giin tu se gawas tu se kereleman, bu' ritu giin meksegaw bu' mekpengkiget se ngang ngisiin.’” ");
INSERT INTO stb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Sek panahun ne sug Bata' ne Getaw mpuli' gisip gari' bu' sumanag sek pekedDiwataan duma se dlaun ne ngag anghel, megingkud giin ri sek trunuun neng megari', ");
INSERT INTO stb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","su nga getaw ri se dlaun ne ngang nasud mektipung ri seng metungenga'an. Bu' behinenen ilan sed duwa' ne ngag bahin, maa' seng menggegingat, neng mekpain se nga karniru buwat ri se nga kanding. ");
INSERT INTO stb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Bu' su nga getaw neng migbaal se dliyagan ned Diwata, betangenen ri sed dapit dlintuun, bu' sud duma ne nga getaw ri sed dapit bibangen. ");
INSERT INTO stb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Rayun su Gari' mektalu' tu se nga getaw ri sed dapit dlintuun, ‘Perini amu, gamu ngak pingumpiyanan ne Gama'u, dawat niyu suk pedlegeri'an ne ginandam na ri seniyu buwat pa se getaran. ");
INSERT INTO stb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ay seng miperii'anu pinaan niyau, bu' se kininumu pininum niyau, bu' seng mituwa'u dinawat niyau ri se ngag balay niyu. ");
INSERT INTO stb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Se genda' naik suub'u pisuuban niyau; seng midlaruu kinetaan niyau, bu' seng miperisuu sinundaw niyau.’ ");
INSERT INTO stb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Rayun su nga getaw neng meketareng meksembag, ‘Ginu'u, nanu ami ma mikiita' seni'a neng miperii'an bu' pinaan'a nami? awas kininum bu' pininum'a nami? ");
INSERT INTO stb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nanu ami ma mikiita' seni'a neng mibaal nek tuwa' bu' dinawat'a nami ri seg balay nami? awas genda'ik suub mu bu' pisuuban'a nami? ");
INSERT INTO stb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nanu ami ma mikiita' seni'a neng midlaru awas miperisu bu' kinetaan'a nami?’ ");
INSERT INTO stb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Bu' su Gari' meksembag, ‘Sek pekemetuud, esuyan'u amu, sek pegbaal niyu runi ngag betang keni tu se dlabi ne gembaba' ne nga kepeteran'u, maa' ra rema neg binaal niyu ini ri senaan.’” ");
INSERT INTO stb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Rayun mektalu' giin tu se nga getaw ri sed dapit bibangen, ‘Pegawa' amu ri senaan, gamu ne ngak pintuklad ned Diwata! Peritu amu se genda'i gekteben ne gapuy ne ginandam para ri ni Satanas bu' ri se ngag anghelen! ");
INSERT INTO stb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ay seng miperii'u ma'ad nda' niyau pe'aanay, bu' se kininumu ma'ad nda' niyau piinumay, ");
INSERT INTO stb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","seng mibaalu nek tuwa' nda' niyau duwatay ri se ngag balay niyu, se nda' naik suub'u nda' niyau pesuubay, bu' seng midlaruu bu' seng miperisuu nda' niyau ketaay.’ ");
INSERT INTO stb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mbuus meksembag ilan, ‘Ginu'u, nanu ami ma mikiita' seni'a neng miperii'an'a, awas kininum'a, awas mibaal'a nek tuwa', awas genda'ik suub mu, awas midlarua, awas miperisua ne nda'a nami ebangay?’ ");
INSERT INTO stb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Su Gari' meksembag, ‘Sek pekemetuud esuyan'u amu, se kada nek panahun ne nda' niyu ebangay suk sala ne dlabi ne gembaba' ne nga kepeteran'u, maa' ra rema ne nda' niyau ebangay.’ ");
INSERT INTO stb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mbuus gilan keni mesilutan ri se genda'i gekteben ma'ad su ngang migbaal ri se dliyagan ned Diwata mekaangken ne ketubu' ne genda'i gekteben.” ");
INSERT INTO stb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sek peketubus ni Jesus sek pektendu' se dlaunan keni, miktalu' giin tu se ngak tinu'unaan, ");
INSERT INTO stb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Misuunan na niyu ned duwa' endaw ra run su Kese'ulugan sek Paska mateng na, bu' se gendaw ketu sug Bata' ne Getaw piyal na tu se nga getaw arun lensangen tu se krus.” ");
INSERT INTO stb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mbuus, su nga geseg ne ngak pari' bu' su nga geseg ri se ngag Judeo miktipung tu sek palasyu ni Caipas, su Dlabaw Geseg ne ngak pari', ");
INSERT INTO stb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","bu' ritu pinelanu nilan se gedlud suk peddaap ri ni Jesus bu' suk pekpatay ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Ndi' ta reli' ini baalen sek panahun se kese'ulugan,” miktalu' ilan, “ay ali' bu' megubet mbuus su nga getaw.” ");
INSERT INTO stb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Saanay ditu pa si Jesus seg Betania tu seg balay ni Simon neng midlaru ri seng mekeendekendek ne dleruun ri sek panit, ");
INSERT INTO stb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","duunik sala ne dlibun neng mikpegaud ri ni Jesus neng mikpitang neng miika' ne gamang neng mipenu' neng melaga' nek pegemut. Saanay mikpekaan si Jesus, binunagen suk pegemut ri se gulu ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bu' sek pekiita' run nini nu ngak tinu'unan, misepek ilan. “Tuma ma pekula'ula'an ma ma'arayik pegemut kiin?” miktalu' ilan. ");
INSERT INTO stb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Pegemut kiin mbeledya' siya se gembagel ne dlaga' bu' su galinen pembegay tu se ngak pupus!” ");
INSERT INTO stb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Misuunan ni Jesus bu' landunik tinalu' nilan, aas miktalu' giin tu senilan, “Tuma ma semuken ma niyui dlibun keni? Melengas sug binaalen ri senaan. ");
INSERT INTO stb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Su ngak pupus kanunay ra nek sementaun niyu, ma'ad gaku' gena'. ");
INSERT INTO stb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Sek pegbunagen runik pegemut keni riin se dlawas'u, binaalen nini sek pekpengandam sek pedlebeng ri senaan. ");
INSERT INTO stb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sek pekemetuud, esuyan'u amu, isan ta' su Gempiya ne Gesuyen mewali ri sek tibuuk neg benwa, landunig binaalen me'asuy ri sek peddelendem ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Rayun suk sala sek sepulu' bu' ruwa' ne ngak tinu'unan ne giningelanan si Judas Iscariote miritu se nga geseg ne ngak pari', ");
INSERT INTO stb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","bu' miksaak, “Landun maig begay niyu ri senaan bu' piyal'u ri seniyu si Jesus?” Aas migisip ilan nek telu pulu' ne ngak selapi' nek pelata bu' binegay nilan tu seniin. ");
INSERT INTO stb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bu' dluwat itu, minengaw rayun si Judas ne ginsaktu neg higayun ne mpiyalen si Jesus tu senilan. ");
INSERT INTO stb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Se guna ne gendaw se Kese'ulugan nek Pan ne Genda'ik Pempetulin run, su ngak tinu'unan mikpegaud tu ni Jesus bu' miksaak, “Ta' mai dlugar ne dliyagan mu arun ritu ami megandam sek penihapun para seni'a se Kese'ulugan sek Paska?” ");
INSERT INTO stb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","“Laway niyu suk sala ne getaw ritu sek siyudad,” miktalu' giin tu senilan, “bu' telu'ay niyu giin: ‘Sung mentetendu' miktalu', minateng na suk panahun'u ne gaku' bu' su ngak tinu'unan'u mekse'ulug sek Paska ritu seg balay mu.’” ");
INSERT INTO stb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bu' tinuman nu ngak tinu'unan suk sinugu' ni Jesus tu senilan bu' inandam nilan suk penihapun para sek Paska. ");
INSERT INTO stb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sek pekegebii na, migingkud si Jesus duma sek sepulu' bu' ruwa' ne ngak tinu'unan arun maan. ");
INSERT INTO stb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bu' saanay nilan mekpekaan, miktalu' si Jesus, “Esuyan'u amu seng metuud, sala seniyu megbudhi' ri senaan.” ");
INSERT INTO stb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sek pekerengeg run nini nu ngak tinu'unan migu'ul ilan gupiya bu' salasala senilan miksaak tu seniin, “Ginu'u, gena' siya gaku' suk pisebutan mu run niin, ndi' ba?” ");
INSERT INTO stb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Miksembag si Jesus, “Suk sala neng medlebul nek pan ri se dya'ung duma senaan megbudhi' ri senaan. ");
INSERT INTO stb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ri se dlain neg bahin, sug Bata' ne Getaw matay gaid sumala' seng misulat ri se Kesulatan metendeng ri seniin, ma'ad mekelelaatlelaat su getaw neng megbudhi' ri seg Bata' ne Getaw. Maneg pa ma'ad siya para se getaw ketu ne nda' na giin me'etaw.” ");
INSERT INTO stb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Rayun si Judas, ne giin sung megbudhi' ri ni Jesus, miktalu', “Sir, siguru gaid ne gena' tumu' gaku' suk pisabut mu?” Miksembag si Jesus, “Dya'a sung miktalu' run niin.” ");
INSERT INTO stb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Saanay nilan mekaan, si Jesus minuwan nek pan, mikpesalamat tu sed Diwata, pinetapetaan nini, bu' binegain tu se ngak tinu'unaan. “Tabuk niyu ini bu' aan niyu,” miktalu' giin. “Giin nini su dlawas'u.” ");
INSERT INTO stb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dluwat itu, minuwan rema si Jesus ne kupa, bu' mikpesalamat tu sed Diwata, binegain nini tu senilan bu' miktalu', “Dlaun niyu, minum run nini, ");
INSERT INTO stb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","giin nini sud dugu'u nek peniyagal se keligenan ned Diwata, sud dugu'u nek pikigis para seng melaun ne nga getaw, para se kepasayluwan se ngak sala' nilan. ");
INSERT INTO stb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Esuyan'u amu, gatad nandaw ndi'u na minum geseb se ginumen keni tampan se gendaw neng minumu seg begu ne ginumen duma seniyu tu sek Pedlegeri'an ne Gama'u.” ");
INSERT INTO stb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Rayun midlekanta ilan sek peksaya' sed Diwata, bu' miritu ilan seg bentud ne ngag Olibo. ");
INSERT INTO stb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mbuus miktalu' si Jesus tu senilan, “Se gebii keni dlaun niyu menggebek bu' meleng ri senaan, ay misulat ini ri se kesulatan neng miktalu', ‘Petain'u sung menggegingat ri se nga karniru, bu' suk panen ne nga karniru metipelak.’ ");
INSERT INTO stb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma'ad dluwatu metubu' puli', megunau seniyu tu se Galilea.” ");
INSERT INTO stb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Miksembag si Pedro tu ni Jesus, “Isan pa su dlaun nilan meleng ri seni'a, ma'ad gaku' ndi' gaid tumu'.” ");
INSERT INTO stb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Miktalu' si Jesus tu ni Pedro, “Sek pekemetuud esuyan'u dya'a, se gebii keni se ndi' pa meguni su dlimensad, limeren mau seng metelu.” ");
INSERT INTO stb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Miksembag si Pedro, “Isan pa petainu duma seni'a, ndi'u dya'a gaid tumu' limeren.” Bu' su dlaun ned duma ne ngak tinu'unan maa' run rema itu suk tinalu' nilan. ");
INSERT INTO stb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mbuus si Jesus duma se ngak tinu'unaan miritu se dlugar ne giningelanan ne Getsemane, bu' miktalu' giin tu senilan, “Penggingkud amu rini saanay merituu se gunaan sek pegampu'.” ");
INSERT INTO stb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Inuwit ni Jesus si Pedro bu' sud duwa' ne nga gembata' ni Zebedeo, bu' migatad giin megu'ul gupiya. ");
INSERT INTO stb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Bu' miktalu' giin tu senilan, “Migu'ulu gupiya bu' binatik'u neng manla'u matay run. Dini amu ra run bu' ndi' amu pentulug duma ri senaan.” ");
INSERT INTO stb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bu' miritu giin seng melayu'layu', middempug ri se dlupa' bu' migampu', “Gama'u, bu' mehimu siya, awa' mu buwat ri senaan suk pegantus keni. Tumu', gena' su keliyag'u sung metuman bu' ndi' su keliyag mu.” ");
INSERT INTO stb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Rayun mipuli' giin tu sek telu ne ngak tinu'unan bu' mi'ita'en ilan neng mintulug; bu' miktalu' giin tu ni Pedro, “Tuma ma ne gamu telu ndi' ma mekehimu ne ndi' mektulug duma senaan isan sala uras na run? ");
INSERT INTO stb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ndi' amu pentulug bu' pegampu' amu arun ndi' amu daagen nek pektintal. Su gispiritu meliya', ma'ad su dlawas meluya.” ");
INSERT INTO stb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Se keruwa', mipuli' si Jesus tu seng melayu'layu' sek pegampu', “Gama'u, bu' ndi' ma ngani' mehimu ne uwa'en mu ri senaan suk pegantus keni gawas ne entusen'u ini, su keliyag mu giining metuman.” ");
INSERT INTO stb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mipuli' na pelun si Jesus tu se ngak tinu'unaan bu' miretengaan ilan gusay neng mintulug ay tulugen ilan gupiya. ");
INSERT INTO stb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bu' pinenawan ilan ni Jesus puli', bu' se ketelu neg higayun migampu' giin seng maa'entu ra gusay ne ngak talu'. ");
INSERT INTO stb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Rayun mipuli' na pelun giin tu se ngak tinu'unaan bu' miktalu', “Mintulug amu pa ba gusay bu' mingulali? Enlengay niyu! Guras na ne sug Bata' ne Getaw piyal na tu se ngang mekesesala'. ");
INSERT INTO stb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pegbuwat amu, menlaang ita. Enlengay niyu, kiin na sung megbudhi' ri senaan!” ");
INSERT INTO stb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bu' saanay pa mektuntul ni Jesus, enlengay niyu, minateng si Judas nek sala sek sepulu' bu ruwa' ne ngak tinu'unan. Duma seniin su gembagel nek panen ne nga getaw neng mingguwit ne nga kalis bu' ngag bentul. Sinugu' ilan nu nga geseg ne ngak pari' bu' nu nga geseg ne nga getaw Judeo. ");
INSERT INTO stb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Sung migbudhi' migbegay na daan ne gilelaan tu se ngang mendeddaap: “Su getaw ne gelekan'u, giin su getaw nek pinengaw niyu. Daap niyu giin!” ");
INSERT INTO stb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aas tinumentel medlaang si Judas pagaw tu ni Jesus bu' miktalu', “Sir, su kelinaw mperiin seni'a,” bu' inelekaan giin. ");
INSERT INTO stb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Miksembag si Jesus seniin, “Sambat, baal mu rayun su dliyagan mu neg baalen.” Mikpegaud ilan rayun, dinaap si Jesus bu' inuwiran nilan giin neng meletek. ");
INSERT INTO stb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sala sek sementaun ni Jesus minakut ne kalis, bu' tinigbasen suk sesugu'en nu Dlabaw Geseg nek Pari', bu' mipetel suk sala se ngak telingaan. ");
INSERT INTO stb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","“Sulek mu puli' ri se guma'aani kalis mu kiin,” miktalu' si Jesus tu seniin. “Su dlaun neng medlegamit ne kalis matay pebiyan ri se kalis. ");
INSERT INTO stb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nda' mu ba mesuunay neng meketawagu tu se Gama'u arun menengi ne gabang, bu' sek tikmal, sugu'enen rayun suk sepulu' bu' ruwa' ne ngag batalyun ne ngag anghel? ");
INSERT INTO stb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma'ad bu' baalen'u ini, pekendunen ma rayun sek peketuman se Kesulatan neng miktalu' ne kina'enlan gaid mehitabu' ini?” ");
INSERT INTO stb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Miktalu' rayun si Jesus tu se nga getaw, “Tulisanu ba neng mirini amu ma neng mingguwit ne nga kalis bu' ngag bentul sek peddaap ri senaan? Kada gendaw dituu ra mikpegingkud sek Templo sek pekpenendu' bu' nda' niyau ma daapay? ");
INSERT INTO stb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma'ad dlaunan keni mehitabu' arun metuman suk sinulat nu ngak propeta riin se Kesulatan.” Rayun bineleng nu ngak tinu'unan si Jesus bu' minlaguy ilan. ");
INSERT INTO stb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Inuwit si Jesus nu ngang middaap ri seniin tu se Dlabaw Geseg ne ngak Pari' ne si Caipas, ditu miktigum su ngang mentetendu' se nga kesugu'an bu' su nga geseg se nga getaw Judeo. ");
INSERT INTO stb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bu' midlendug si Pedro ma'ad seng melayu'layu' ra ri ni Jesus tampan tu se dlenu'an nug balay ne Dlabaw ne Geseg nek Pari'. Sinumeled giin bu' migingkud duma se nga guwardiya arun me'ita'en su dlaun neng mehitabu'. ");
INSERT INTO stb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bu' su nga geseg nu ngak pari' bu' su dlaun ne ngak sakup se Dlabaw Gukuman ne nga getaw Judeo minengaw ne nga mpengaleg kuntra riin ni Jesus arun mpepatay nilan giin. ");
INSERT INTO stb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ma'ad isan melaun sung mimpegaud arun sek pegasuy neg balus nek pengaleg ri seniin, nda'irun gairing mi'ita' nilan ne keterengan arun mpepatay nilan giin. Sek tambinai', duunid duwa' tawan neng mikpegaud, ");
INSERT INTO stb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bu' miktalu' ilan, “Miktalu'i getaw keni, ‘Geba'en'u suk Templo ned Diwata, bu' bekuren'u ini puli' seled sek telu endaw.’” ");
INSERT INTO stb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Rayun migindeg su Dlabaw ne Geseg nek Pari' bu' miktalu' tu ni Jesus, “Nda'irun baing mesembag mu run sek pingaleg ne nga getaw keni kuntra seni'a?” ");
INSERT INTO stb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma'ad nda' gaid peksembag si Jesus. Bu' su Dlabaw ne Geseg nek Pari' miktalu' geseb tu seniin, “Se ngalan neng miktetubu' ned Diwata, pepenumpa'en'u dya'a: esuyay mu ami, dya'a ba sung Misiyas, sug Bata' ned Diwata?” ");
INSERT INTO stb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Miksembag si Jesus tu seniin, “Tinalu' mu na. Ma'ad asuy'u ri se dlaun niyu: gatad sek panahun keni sug Bata' ne Getaw me'ita' niyu neng megingkud sed dapit dlintu neng Mekegega'em se dlaunan bu' mateng riin se nga ginanud ri se dlangit!” ");
INSERT INTO stb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sek pekerengeg run nini nu Dlabaw ne Geseg nek Pari', bineriten suk suuben bu' miktalu', “Gembagel ini nek pekpesipala! Ndi' ita na medlekina'enlan ned dugang ne ngak sintigus! Rini nandaw mirengeg niyu suk pekpesipalaan! ");
INSERT INTO stb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Lama run mai gena'ena' niyu run nini?” Minsembag ilan, “Mbaya' giin matay.” ");
INSERT INTO stb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bu' rayun dinula'an nilan sung mulu'en bu' binentul giin bu' suk tinumampaling ri seniin ketu, ");
INSERT INTO stb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","miktalu', “Bu' dya'a sung Misiyas, atuk mu raw, bu' ta' sung miktampaling ri seni'a?” ");
INSERT INTO stb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na, mikpegingkud si Pedro tu se gawas ne dlenu'an. Duuni dlibun nek sesugu'en nu Dlabaw ne Geseg nek Pari' mikpegaud ri seniin bu' miktalu', “Dya'a, rema, sementaun ni Jesus nek taga Galilea.” ");
INSERT INTO stb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma'ad linimed ni Pedro ini ri seng mitungenga'an se dlaunan nilan. “Nda'u mesuunay bu' landunik tinalu' mu kiin,” miksembag giin, ");
INSERT INTO stb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","rayun ginumawas si Pedro tu se genga'an ne dlenu'an. Bu' duuni dlain nek sesugu'en ne dlibun neng mikiita' ri seniin bu' miktalu' tu se nga getaw ritu, “Getaw keni sementaun gaid ni Jesus nek taga Nazaret.” ");
INSERT INTO stb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bu' linimed puli' ni Pedro ini, bu' miksembag, “Penumpa'u, nda'u gaid tumu' mekilala se getaw iin!” ");
INSERT INTO stb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nda' santa', sud duma ne ngang migindeg ritu mikpegaud tu ni Pedro, “Sementaun'a gaid tumu' ni Jesus,” miktalu' ilan, “ay me'ilala gupiya ri sek tinuntulan mu.” ");
INSERT INTO stb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mbuus miktalu' si Pedro, “Penumpa'u neng metuud suk tinalu'u! Silutanu siya ned Diwata bu' gena' ini neng metuud! Nda'u mekilala ri se getaw iin!” Mbuus miguni rayun su dlimensad, ");
INSERT INTO stb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","bu' mi'ena'ena' rayun ni Pedro suk tinalu' ni Jesus ri seniin: “Se ndi' pa meguni su dlimensad, limeren mau se ketelu.” Bu' ginumawas giin bu' miksegaw giin seng melebiyan ne kegu'ul. ");
INSERT INTO stb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sek pekeputi' relaagan na, su dlaun ne nga geseg ne ngak pari' bu' ne nga geseg ne ngag Judeo mikpelanu sek pekpatay ri ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ginapus nilan giin, bu' inuwit, bu' piniyal giin tu ni Pilato, ne gobernador seg Roma. ");
INSERT INTO stb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sek pekiita' run ni Judas, sung migbudhi' ne inukuman si Jesus nek petain, middiksu' giin bu' miritu giin se nga geseg ne ngak pari' bu' se nga geseg ne ngag Judeo arun uli' suk telu pulu' ne ngak selapi' nek pelata. ");
INSERT INTO stb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Mikesala'u tendeng ay binudhi'an'u su getaw ne genda'ik sala'en arun matay!” miktalu' giin. “Genda' nai dlabet nami run niin,” miksembag ilan. “Dya'a na sung menembag run niin!” ");
INSERT INTO stb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aas tinikpu' ni Judas su ngak selapi' nek pelata tu sek seled nek Templo bu' ginumawas giin bu' mineget. ");
INSERT INTO stb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma'ad pingimud rayun nu nga geseg ne ngak pari' su ngak selapi', bu' miktalu', “Selapi' keni bayad se ketubu' bu' supak ini se Kesugu'an neg betangen ta ri sek pemetangan ne ngak selapi' ri sek Templo.” ");
INSERT INTO stb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dluwat nilan peguyunay, ginamit nilan suk selapi' ketu para saluy tu se dlupa' neng Membaal ne Gulen arun baalen ne dlebengan para se nga getaw nek tuwa'. ");
INSERT INTO stb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aas dlupa' ketu tampan nemuun iningelanan ned “Dlupa' neng Mirugu'an.” ");
INSERT INTO stb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mbuus giin nini su ketumanan se ginasuy ni propeta Jeremias, “Inuwan nilan suk telu pulu' ne ngak selapi' nek pelata, su dlaga' nek piksebutan ne nga getaw Israel neg bayad para seniin, ");
INSERT INTO stb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bu' suk selapi' sinaluy nilan ri se dlupa' nung membebaal ne gulen, sumala' sek sinugu' senaan nu Ginu'u.” ");
INSERT INTO stb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na, migindeg si Jesus seng metungenga'an se gobernador seg Roma neng miksaak ri seniin, “Dya'a ba su gari' ne ngag Judeo?” “Tinalu' mu na,” miksembag si Jesus. ");
INSERT INTO stb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ma'ad nda' giin sembag se ngak sumbung ne nga geseg ne ngak pari' bu' nga geseg ne ngag Judeo. ");
INSERT INTO stb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Rayun miktalu' si Pilato tu ni Jesus, “Nda' mu ba merengeg su dlaun ne ngag betang nek pingaleg nilan seni'a?” ");
INSERT INTO stb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma'ad nda' gusay peksembag si Jesus, isan sek sala nek talu' na run, aas mitingala gaid gupiya su gobernador. ");
INSERT INTO stb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Se kada Kese'ulugan sek Paska mibetasan ne gobernador seg Roma neng mekpegawas nek salabuuk nek pinerisu ne gendyu'en ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sek panahun ketu duuning mibantug nek pinerisu ne giningelanan si Jesus Barabas. ");
INSERT INTO stb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aas seng miktipung na su nga getaw, miksaak si Pilato tu senilan, “Ta' ma senilan duwa' su dliyagan niyu neg beluyan'u para seniyu? Si Jesus Barabas ba awas si Jesus ba nek tinawag neng Misiyas?” ");
INSERT INTO stb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Miksaak si Pilato run nini tendeng ay misuunaan ma ugud ne su nga geseg se ngag Judeo, piniyal nilan si Jesus tu seniin ay misinaku ilan riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Saanay migingkud si Pilato ri sek seled ne gukuman, suk sawaan mikpawit neng minsahi ri seniin: “Ndi' mu ilebetayi getaw iin ne genda'ik sala'en ay misamuku gupiya tendeng ri sek teginepen'u metendeng ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma'ad rinunggatan nu nga geseg nu ngak pari' bu' nu nga geseg nu nga getaw Judeo su nga getaw ne si Barabas su gendyu'en nilan ri ni Pilato nek pebeluyan bu' petain si Jesus. ");
INSERT INTO stb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bu' miksaak geseb si Pilato, “Ta' ma sed duwa' keni su dliyagan niyu neg beluyan para ri seniyu?” “Si Barabas,” miksembag su nga getaw. ");
INSERT INTO stb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Na, lama run rayunig baalen'u ri ni Jesus keni ne giningelanan neng Misiyas?” miktalu' si Pilato tu senilan. “Lensangen giin tu se krus!” miksembag su dlaun nilan. ");
INSERT INTO stb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma'ad miksaak si Pilato tu senilan, “Lama run maik sala' neng mibaalen?” Mbuus pisekegan pa gaid tumu' nilan suk pegbeksay, “Lensangen giin tu se krus!” ");
INSERT INTO stb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Sek pekiita' run ni Pilato ne nda' nai mbaalen bu' mehitabu' na su gembagel ne kesamuk, minuwan giin nek tubig, mingunaw se nga gemegen riin seng metungenga'an ne nga getaw, bu' miktalu', “Nda'i dlabet'u run se kemetain ne getaw iin! Penembag niyu iin!” ");
INSERT INTO stb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Miksembag su dlaun ne nga getaw, “Wa'a, gami bu' su nga gembata' nami giin sung menembag runi kemetainen!” ");
INSERT INTO stb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Rayun bineluyan ni Pilato si Barabas para tu senilan; ma'ad pilekpesen si Jesus bu' piniyal tu se nga getaw arun lensangen tu se krus. ");
INSERT INTO stb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mbuus inuwit nu ngak sundalu si Jesus tu sek seled nek palasyu ni Pilato, bu' linibutan giin seng melaun ne ngak sundalu. ");
INSERT INTO stb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Linuwas nilan suk suuben bu' pisuuban nilan giin nek suub neng meragem, ");
INSERT INTO stb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","bu' miktelaad ilan ned dugiyan nek sigbet, bu' binetang nilan nini riin se gulu ni Jesus. Bu' pi'uwiran nilan su dlintu ne gemegen ne gages. Rayun mikpelaunglaung ilan neng minginlulud ri seng metungenga'aan bu' middega'rega' ri seniin neng miktalu' “Metubu' su Gari' ne ngag Judeo!” ");
INSERT INTO stb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bu' dinula'an rayun nilan giin, bu' inuwan nilan su gagesen bu' binentul ri se guluun. ");
INSERT INTO stb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Peketubus nilan giin peddega'rega'ay, linuwas nilan sung meragem nek suub nek piseluk nilan ri seniin bu' piseluk nilan puli' suk suuben. Rayun inuwit nilan giin tu se gawas arun lensangen tu se krus. ");
INSERT INTO stb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Se ginumawas ilan na tu sek siyudad, milabet nilan su getaw nek taga Cirene, ne iningelanan nek Simon, bu' lineges giin nu ngak sundalu sek pekpisaan se krus ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Rayun minateng ilan tu se dlugar ne iningelanan ne Golgota, ne su gulugaan, “Dlugar nek Tulaan Gulu.” ");
INSERT INTO stb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Binegayan rayun nilan giin ne ginumen ne dlinemugan ne gempait. Ma'ad seng mi'inamaan na ini, nda'en nini inumay. ");
INSERT INTO stb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mbuus linansang nilan giin tu se krus bu' pikilasilas nilan suk suuben pebiyan sek pegripa. ");
INSERT INTO stb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dluwat itu minggingkud ilan ritu sek pegbantay ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ri seng meritaasen binetangan nilan ne karatula ne giin suk sumbung kuntra ri seniin, “Giin nini si Jesus, su Gari' nu ngag Judeo.” ");
INSERT INTO stb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bu' midlansang ilan ned duwa' tawan ne ngak tulisan duma ni Jesus, sala riin sed dapit dlintuun bu' sala riin sed dapit bibangen. ");
INSERT INTO stb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Su nga getaw neng mimbiyan ritu mikisingngising se nga gulu nilan bu' piddega'rega'an nilan si Jesus: ");
INSERT INTO stb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Geba'en mu raw suk Templo bu' bekuren mu ini puli' seled sek telu endaw! Luwas mu su gegulingen mu bu' dya'a sug Bata' ned Diwata! Penaug'a riin se krus iin!” ");
INSERT INTO stb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Seng maa' run nek pebiyan, su nga geseg nu ngak pari', bu' su ngang mentetendu' se kesugu'an, bu' su nga geseg se nga getaw Judeo middega'rega' ri seniin: ");
INSERT INTO stb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Linuwasen sud duma, ma'ad ndi' giin mekeluwas ri se gegulingenen! Gena' ba giin ma su gari' seg Israel? Bu' mekenaug giin ri se krus nandaw, mektu'u ita ri seniin! ");
INSERT INTO stb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Miksalig giin tu sed Diwata bu' miktalu' pa gaid giin, ne giin sug Bata' ned Diwata. Na, enlengan ta raw bu' luwasen ba giin nud Diwata nandaw!” ");
INSERT INTO stb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bu' isan su ngak tulisan ne dlinansang tu se krus duma seniin middega'rega' rema ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na buwat sek teras taasendaw, dinumelem suk tibuuk neg benwa, neng mirepet sek telu uras. ");
INSERT INTO stb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bu' sek pekeginenga' menaug nai gendaw, migbeksay si Jesus, “Eli, Eli, lema sabachthani?” Bu' ri senita pa, “Diwatau, Diwatau, tuma ma pesaddan mau?” ");
INSERT INTO stb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bu' sud duma ne nga getaw neng mingindeg ritu mikerengeg seniin bu' miktalu', “Tinawagen si Elias!” ");
INSERT INTO stb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nda' santa', sala se nga getaw ritu, ginumebek bu' minuwan neg ispungha bu' linebulen ri seng mesem ne ginumen, bu' tinangen nini ri sek patal ne gayu, bu' minantu giin neng me'inum ni Jesus itu. ");
INSERT INTO stb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma'ad sud duma miktalu', “Pesaddan niyu giin. Enlengan ta bu' mateng ba si Elias sek pedluwas ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bu' migbeksay geseb si Jesus, bu' binektusan giin. ");
INSERT INTO stb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mbuus su kurtina tu sek seled nek Templo miberit buwat sed ditaas pagaw sek silung; bu' midlinug sug benwa, bu' minggeli' su ngang mekebagel ne ngag batu; ");
INSERT INTO stb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","su nga kelebengan mipuka, bu' melaun ne nga getaw ned Diwata neng mimatay neng mitubu' puli', ");
INSERT INTO stb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","bu' ginumawas ilan ri se kelebengan. Tubus metubu' puli' si Jesus buwat se kemetain, miritu ilan seg Bala'an nek Siyudad, neng melaun ne nga getaw neng mikiita' ri senilan. ");
INSERT INTO stb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Seng migbantay su geseg nek sundalu bu' su ngak sundaluun ri ni Jesus, mibetikan nilan su dlinug bu' mi'ita' nilan su dlaun neng mihitabu'. Minendek ilan gupiya bu' miktalu', “Sek pekemetuud giin gaid sug Bata' ned Diwata!” ");
INSERT INTO stb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Melaun remai nga dlibun ritu neng mikpegenleng ri seng melayu'layu'. Nga dlibun keni, tinumendug ri ni Jesus gatad pa se Galilea arun sek pedlekata ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Duma senilan, gilan si Maria Magdalena, si Maria ne gina' ni Santiago bu' ni Jose, bu' su gina' se nga gembata' ni Zebedeo. ");
INSERT INTO stb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Seng meddelabung na, minateng ritu sung meratu' ne getaw neg buwat seg Arimatea; su ngalanen si Jose bu' tinu'unan rema ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Miritu giin ni Pilato arun ubugen sug bangkay ni Jesus, bu' miksugu' si Pilato sek pegbegay tu seniin. ");
INSERT INTO stb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aas inuwan nini ni Jose, bu' pinutusen nini seg begu nek penepeten ne dlinu, ");
INSERT INTO stb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","bu' binetangen nini tu se gegulingenen ne dlebengan, neg begu pa luwakay ri se gilid nek telektapan. Rayun linuliren su gembagel neg batu nek pentampeng tu se dlebengan bu' rayun midlaang giin. ");
INSERT INTO stb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Si Maria Magdalena bu' sud duma neng Maria, minggingkud ritu, neng migatubang tu se dlebengan. ");
INSERT INTO stb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sek pekesunud ne gendaw ne giin su Gendaw nek Pengulali, su nga geseg ne ngak pari' bu' su ngak Pariseo kinumita' ri ni Pilato. ");
INSERT INTO stb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Miktalu' ilan, “Sir, mi'ena'ena' nami ne saanay miktetubu' pa sug belusen ketu, miktalu' giin, ‘Dluwat sek telu endaw metubu'u puli'.’ ");
INSERT INTO stb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Aas peksugu'a nek pebentayan su dlebengaan seled sek telu endaw, arun ndi' mekeritu su ngak tinu'unaan bu' peddaawen sug bangkain, bu' rayun telu'an nilan su nga getaw neng mitubu' giin puli' buwat se kemetain. Su ketapusan neg balus mbaal mbuus neng melaat gupiya sinangkali' tu se guna.” ");
INSERT INTO stb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Peguwit amu ne guwardiya niyu,” miktalu' si Pilato tu senilan; “dlaang amu bu' bentayay niyu gupiya sumala' seng misuunan niyu.” ");
INSERT INTO stb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aas minlaang ilan bu' arun nda'iruning mekepengilabet se dlebeng, binetangan nilan ne gilelaan sug batu nek tinakep tu se dlebeng bu' pibentayan nilan. ");
INSERT INTO stb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na, sek peketubus se Gendaw nek Pengulali, dali' endaw se gendaw ned Duminggu, si Maria Magdalena bu' su dlain pa neng Maria miritu arun sek pegenleng se dlebengan. ");
INSERT INTO stb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sek tikmal duuning mesekeg gupiya ne dlinug; minaug sug anghel nu Ginu'u buwat se dlangit, linuliren sug batu, bu' iningkuraan nini. ");
INSERT INTO stb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bu' su gawi'en maa' ne gilat, bu' su ngak suuben gemputi' gupiya. ");
INSERT INTO stb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bu' mingereg su nga guwardiya baal seng melebiyan ne keendek bu' mitelingnanan ilan. ");
INSERT INTO stb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma'ad sug anghel miktalu' tu se nga dlibun, “Ndi' amu mendek, ay misuunan'u nek pinengaw niyu si Jesus, su dlinansang tu se krus. ");
INSERT INTO stb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nda' na giin rini; ay mitubu' giin puli', sumala' sek tinalu'en seniyu. Perini amu bu' enlengay niyu su dlugar nek pibeliliran ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Peksempun amu peritu, bu' telu'ay niyu su ngak tinu'unaan, ‘Mitubu' giin puli' buwat se kemetain bu' meguna giin seniyu tu se Galilea; bu' ritu me'ita' niyu giin!’ Ndi' niyu pedlingaway suk tinalu'u seniyu.” ");
INSERT INTO stb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aas mimagas ilan megawa' tu se dlebengan ned duuni keendek duma se gembagel ne dleliyag, bu' minggebek ilan arun esuyan su ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sek tikmal linabet ilan ni Jesus bu' miktalu', “Su kelinaw mperiin seniyu.” Mikpegaud ilan rayun ri ni Jesus, inuwiran nilan su geksuren, bu' miksimba ilan ri seniin. ");
INSERT INTO stb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Ndi' amu mendek,” miktalu' si Jesus tu senilan, “penlaang amu bu' tebalay niyu su nga kepeteran'u neng meritu se Galilea, bu' ritu me'ita'u nilan.” ");
INSERT INTO stb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Saanay nu nga dlibun medlaang, sud duma ne ngak sundalu neng migbantay tu se kelebengan miritu puli' sek siyudad bu' inasuy nilan tu se geseg ne ngak pari' su dlaun neng mihitabu' ritu. ");
INSERT INTO stb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bu' miktipung su nga geseg nu ngak pari' duma se nga geseg nu ngag Judeo bu' miksabutsabut ilan; binegayan nilan su ngak sundalu neng melaun ne ngak selapi' ");
INSERT INTO stb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bu' miktalu', “Asuy niyu tu se nga getaw neng mirini su ngak tinu'unaan saanay gebii neng miktulug amu bu' piddaaw nilan sug bangkay ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bu' merengeg ini nu gobernador, gami raing metau mekpesabut ri seniin ne nda'ik suun niyu run bu' peneliperan nami amu arun nda'irun nai mbaya' megules amu run.” ");
INSERT INTO stb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aas dinawat nu nga guwardiya su ngak selapi' bu' binaal nilan su ginasuy senilan. Bu' gesuyan keni midlelaup pebiyan se ngag Judeo tampan sek panahun numuun keni. ");
INSERT INTO stb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Suk sepulu' bu' sala ne ngak tinu'unan miritu seg bentud ne Galilea nek tinalu' ni Jesus ned ditu ilan pegita'. ");
INSERT INTO stb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sek pekiita' nilan ri ni Jesus, sinimba nilan giin, isan sud duma senilan midduwa'ruwa'. ");
INSERT INTO stb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mikpegaud rayun si Jesus tu senilan bu' miktalu', “Binegay senaan su dlaun ne kega'em ri se dlangit bu' ri seg benwa. ");
INSERT INTO stb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aas laway niyu su dlaun ne nga getaw ri se dlaun ne ngang nasud bu' baal niyu ilan ne ngak tinu'unan'u. Bendyagay niyu ilan ri se ngalan ne Gama', seg Bata', bu' se Gispiritu Santu, ");
INSERT INTO stb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","bu' tendu'ay niyu ilan sek pektuman se dlaun nek sinugu'u riin seniyu. Bu' enlengay niyu, Gaku' megunut riin seniyu kanunay tampan se ketapusan neg benwa.”");
INSERT INTO stb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Giin nini sung Melengas ne Gesuyen metendeng riin ni Jesus Christ, sug Bata' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Migatad ini sumala' sek sinulat ni propeta Isaias: “Miktalu' sud Diwata, ‘Enlengay mu, meksugu'u neng mempepesuun neng meguna ri seni'a arun megandam neg biyanan mu.’ ");
INSERT INTO stb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Duuning megbeksay ritu se kemingawan, ‘Andam niyu sud dalan para se Ginu'u; baal niyu neng meleddeng sug biyanaan para sek pedlaangen.’” ");
INSERT INTO stb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Minateng si Juan ritu se kemingawan, mimendyag bu' migwali. “Peddiksu' amu ri se ngak sala' niyu bu' pekpebendyag amu,” tinalu'en nini tu se nga getaw, “bu' sud Diwata mekpasaylu se ngak sala' niyu.” ");
INSERT INTO stb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bu' melauni nga getaw neg buwat sek probinsiya seg Judea bu' sek siyudad seg Jerusalem neng miritu ni Juan arun menginengeg. Inasuy nilan su ngak sala' nilan bu' binendyagaan ilan ritu seg bagel tubig neg Jordan. ");
INSERT INTO stb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Minuub si Juan neg binaal buwat seg bembul ne kamelyo bu' duunik panit neg baling neg binaling riin se gawaken bu' su gaanen ne ngad dulun bu' ne ngak teneb. ");
INSERT INTO stb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Bu' pisuunen su nga getaw, “Su getaw neng mateng sunud ri senaan ge'eman pa kampuun sinangkali' ri senaan. Ndi'u ngani' mbaya' isan sek peddungkuk bu' pegugbad se gegbed ri se ngak sandalyasen. ");
INSERT INTO stb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Bendyagan'u amu sek tubig, ma'ad giin megbendyag ri seniyu se Gispiritu Santu.” ");
INSERT INTO stb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nda' mpayat, minateng si Jesus buwat se dlunsud seng Nazaret, sakup sek probinsiya ne Galilea. Bu' binendyagan giin ni Juan ritu seg bagel tubig neg Jordan. ");
INSERT INTO stb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Se kinumawas na si Jesus buwat sek tubig, mi'ita'en su dlangit neng mipuka bu' su Gispiritu Santu tinumena' ri seniin maa' gawi' nek selepati. ");
INSERT INTO stb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bu' duunik talu' neng migbuwat se dlangit, neng miktalu', “Dya'a suk pinetail'u neg Bata'. Pidleliyagu gaid gupiya ri seni'a.” ");
INSERT INTO stb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Bu' sek tikmal piperitu rayun nu Gispiritu si Jesus se kemingawan, ");
INSERT INTO stb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","bu' mikpebilin giin ritu seled se gepaat pulu' endaw nek piktintal ni Satanas. Bu' su ngak talun ne ngang menanap ritu rema, ma'ad duuni ngag anghel neng midlekata ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Seng miperisu na si Juan, miritu si Jesus se Galilea bu' migwali seng Melengas ne Gesuyen neg buwat ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Minateng na su ginsaktu nek panahun,” miktalu' giin, “bu' megaud na suk pedlegari' ned Diwata! Peddiksu' amu ri se ngak sala' niyu bu' tu'uway niyu sung Melengas ne Gesuyen.” ");
INSERT INTO stb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Bu' saanay midlaang si Jesus ritu se geksid ned danaw se Galilea, mi'ita'en sud duwa' tawan neng mengenginsera', gilan si Simon bu' suk pateren ne si Andres neng minlaya. ");
INSERT INTO stb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Miktalu' si Jesus tu senilan, “Dunut amu ri senaan, tendu'an'u amu pekendun dun pekpenlaam ne nga getaw.” ");
INSERT INTO stb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bu' bineleng rayun nilan sempun su nga dlaya nilan bu' middunut ilan tu ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bu' seng mikedlaang na giin tu se gunaan, mi'ita'en sud duwa' tawan ne ngang mekpated, gilan ni Santiago bu' Juan, nga gembata' ni Zebedeo. Ritu ilan sek sekayan nilan neng migandam ne dlaya nilan. ");
INSERT INTO stb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sek pekiita' ni Jesus ri senilan, tinawagen ilan rayun; aas bineleng nilan su gama' nilan ne si Zebedeo ritu sek sekayan duma se nga getaw nek sinu'ulan bu' middunut ilan riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Si Jesus bu' su ngak tinu'unaan miritu se dlunsud ne Capernaum. Bu' sek pekesunud ne Gendaw nek Pengulali, miritu giin sek pektipungan ne nga getaw ne ritu ilan sek pektu'un sek talu' ned Diwata bu' migatad giin sek pektendu'. ");
INSERT INTO stb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Su nga getaw neng mikerengeg ri seniin mitingala ilan ri sek pekpenendu'en, ay giin gena' maa' ne ngang mentetendu' ri se Kesugu'an; ay miktendu' giin ned duuni kega'em. ");
INSERT INTO stb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bu' rayun duuni getaw nek pige'eman neng melaat ne gispiritu neng miritu sek pektipungan neng mikpegbeksay, ");
INSERT INTO stb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Landun mai dliyagan mu ri senami, Jesus nek taga Nazaret? Mirinia ba arun sek pedlaat ri senami? Mi'ilalau bu' ta'a getaw. Dya'a sug bala'an nek sinugu' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bu' pimaag ni Jesus sung melaat ne gispiritu, “Ndi'a peksasak, bu' gawas'a riin se getaw iin!” ");
INSERT INTO stb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bu' pipengeyeg nung melaat ne gispiritu su getaw, migbeksay, bu' ginumawas giin tu seniin. ");
INSERT INTO stb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Su dlaun ne nga getaw mitingala bu' miksesakay suk salasala senilan, “Landun ma ini? Begu ba ini ne ketendu'an? Getaw keni duuni kega'emen sek pekpemandu' seng melaat ne nga gispiritu, bu' tumuman ri seniin!” ");
INSERT INTO stb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aas suk tuntulan metendeng riin ni Jesus midlelaup se dlaun ne nga dlugar sek probinsiya ne Galilea. ");
INSERT INTO stb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Dluwat itu, si Jesus bu' su ngak tinu'unaan, duma si Santiago bu' si Juan migawa' tu sek pektipungan bu' miritu ilan rayun seg balay ni Simon bu' ni Andres. ");
INSERT INTO stb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Suk penugangan ni Simon ne dlibun migbelilid neng mipanas, bu' sek peddateng ni Jesus, tinelu'an giin metendeng ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mikpegaud si Jesus tu seniin, inuwiraan giin ri se gemeg, bu' binuwaten giin. Sek tikmal mi'uli'an giin ri sek panasen, bu' inilakaan ilan nek pekaan. ");
INSERT INTO stb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Seng misindep na su gendaw bu' medlegebii na, inuwit nu nga getaw tu ni Jesus su dlaun ne ngang minlaru bu' su ngak sineleran neng melaat ne gispiritu. ");
INSERT INTO stb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Su dlaun ne nga getaw tu se dlunsud miktipung tu seng metungenga'an neg balay. ");
INSERT INTO stb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mbuus pi'uli'an ni Jesus sung melaun ne ngang minlaru seng midlainlain ne nga dleruun bu' pigawasen su ngang melaat ne gispiritu. Nda'en tugutay su ngang melaat ne gispiritu sek pektalu', tendeng ay misuunan nilan ta' ne getaw si Jesus. ");
INSERT INTO stb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sek pekeddali'endaw, se genda' pa peddelaag, migbuwat si Jesus bu' migawa' giin tu seg balay. Miritu giin se kemingawan bu' ritu giin migampu'. ");
INSERT INTO stb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma'ad si Simon bu' su ngak sementaunen midlaang sek pekpenengaw ri seniin, ");
INSERT INTO stb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","bu' sek pekiita' nilan ri seniin, miktalu' ilan, “Suk salasala mikpenengaw ri seni'a.” ");
INSERT INTO stb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma'ad miksembag si Jesus, “Kina'enlan neng meritu ita seng megaud ne nga dlunsud. Kina'enlan welian'u ilan rema, tendeng ay giin nini su ketuyu'an neng miriniu.” ");
INSERT INTO stb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aas midlibed giin tu se dlaun ne dlugar sek tibuuk probinsiya ne Galilea, sek pegwali tu se ngak pektipungan ne nga getaw, bu' mikpegawas se ngang melaat ne gispiritu. ");
INSERT INTO stb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Duuni getaw neng migantus seng mekeendekendek ne dleruun ri sek panit neng mikpegaud tu ni Jesus, miginlulud, bu' mikpe'ilelaat ne ebangan. “Bu' liyagan mu,” miktalu' giin, “baal mau ne dlimpiyu.” ");
INSERT INTO stb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bu' milelaat gaid si Jesus, bu' inetaten su gemegen bu' inikapen giin, laungen, “Liyagen'u, melimpiyua!” ");
INSERT INTO stb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bu' sek tikmal mitelen rayun sung megeelen bu' milimpiyu giin. ");
INSERT INTO stb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mbuus pilaang giin ni Jesus, dluwaten penegulay, ");
INSERT INTO stb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","neng miktalu', “Penginengeg'a, ndi' mu la'a pentabal tu se isan ta' metendeng run nini. Ma'ad peritua rayun sek pari' bu' pe'enleng mu su gegulingen mu ri seniin, arun suk salasala mekepemetuud neng mi'uli'an'a na, bu' peddulang'a sumala' sek sinugu' ni Moses.” ");
INSERT INTO stb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma'ad su getaw midlaang bu' migatad sek pegasuy sek tuntulan se isan ta' ne dlugar. Pilebiyanaan gaid sek pekpengasuy tendeng run nini ndi' na gaid mekeritu si Jesus se dlunsud ned duuning meleget ne nga getaw run, tumu' ritu ra giin mikengel se nga kemingawan. Bu' su nga getaw miritu seniin buwat se isan ta' ne dlugar. ");
INSERT INTO stb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Minayan suk santa' endaw, mipuli' si Jesus tu se Capernaum, bu' midlelaup suk tuntulan ne ritu giin seg balain. ");
INSERT INTO stb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Aas melaun ne nga getaw neng miritu, miktisek ilan bu' mipenu' nilan sug balay tampan tu se gawas ned dungawan. Winali ni Jesus sung minsahi tu senilan. ");
INSERT INTO stb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bu' duuni gepaat tawan neng minateng neng miguwit ne getaw paralitiku tu ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tendeng se kelaun ne nga getaw, ndi' nilan mpepegaud su getaw tu seniin. Aas tinerutan nilan su gatep riin sek tendeng ni Jesus. Seng miterutan na nilan ini, tinentun rayun nilan su getaw neng mikpegbelilid ri sek puyuwan. ");
INSERT INTO stb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bu' sek pekiita' ni Jesus ne gembagel gaid suk pektu'u nilan, miktalu' giin tu se getaw nek paralitiku, “Bata'u pinasaylu na su ngak sala' mu”. ");
INSERT INTO stb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sud duma ne ngang mentetendu' se Kesugu'an neng mingingkud ritu migena'ena' ilan ri se gegulingen nilan, ");
INSERT INTO stb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Tuma ma meketalu' ma giin neng maa' niin? Pekpesipala ini! Sud Diwata ra sung mekepasaylu ri se ngak sala'.” ");
INSERT INTO stb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Misuunan rayun ni Jesus suk pigena'ena' nilan, aas miktalu' giin tu senilan, “Tuma ma megena'ena' amu ma neng maa' niin ne ngag betang? ");
INSERT INTO stb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ta' maing melemu suk pektalu' se getaw nek paralitiku keni, ‘Pinasaylu na su ngak sala' mu,’ awas suk pektalu', ‘Buwat'a, inat mu sud dendam mu, bu' dlaang'a?’ ");
INSERT INTO stb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ma'ad arun mpemetuuran'u ri seniyu ne sug Bata' ne Getaw duuni ketengeren rini seg benwa sek pekpasaylu se ngak sala'.” Aas miktalu' giin tu se getaw nek paralitiku, ");
INSERT INTO stb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Telu'an'u dya'a, pegbuwat'a, inat mu sud dendam mu, bu' uli'a!” ");
INSERT INTO stb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Saanay su dlaun nilan mikpegenleng, migbuwat su getaw, ininaten sud dendamen, bu' minikad gumawas. Dlaun nilan mitingala gupiya bu' sinaya' nilan sud Diwata, neng miktalu', “Nda' ita pa gaid mekiita' ne ngag betang neng maa' nini.” ");
INSERT INTO stb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mipuli' na pelum si Jesus tu se geksid ned danaw se Galilea. Bu' su gembagel nek panen ne nga getaw miritu seniin, bu' migatad giin menintulu' ri senilan. ");
INSERT INTO stb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sinegay mikpedlaang giin, mi'ita'en sung meneningil neg buwis ne si Levi neg bata' ni Alfeo, mikpegingkud ri se gupisinaan, miktalu' giin tu seniin, “Tala, dunut'a ri senaan.” Migbuwat rayun si Levi bu' middunut ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dluwat itu, si Jesus minaan tu seg balay ni Levi. Melauning meneningil neg buwis bu' duma pa ne ngang mekesesala' neng middunut riin ni Jesus, bu' melaun senilan neng minaan duma seniin bu' se ngak tinu'unaan tu sek pengaanan. ");
INSERT INTO stb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sud duma ne ngak Pariseo, neng mentetendu' se Kesugu'an, mikiita' ri ni Jesus neng minaan duma se ngang mekesesala' bu' se ngang meneningil neg buwis, aas miksaak ilan tu se ngak tinu'unaan, “Tuma ma minaan ma giin duma se nga getaw iin?” ");
INSERT INTO stb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mirengeg ilan ni Jesus bu' miksembag tu senilan, “Su nga getaw ne gena' melaru ndi' medlekina'enlan neng mememulung, ma'ad su ngang melaru ra. Nda'u perini arun pektawag se nga getaw neng metareng ma'ad para se ngang mekesesala'.” ");
INSERT INTO stb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Duunik panahun ne su ngak tinu'unan ni Juan neng Membebendyag bu' su ngak Pariseo mimpu'asa. Sud duma ne nga getaw miritu ni Jesus bu' miksaak tu seniin, “Tuma ma su ngak tinu'unan ni Juan neng Membebendyag bu' su ngak tinu'unan ne ngak Pariseo mikpu'asa ma, ma'ad su ngak tinu'unan mu nda' ma?” ");
INSERT INTO stb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Miksembag si Jesus, “Migena'ena' amu ba rekay ne su ngak pingenggat sek pektambung se kasal, menambung ne nda'irunik pekaan? Ndi' gaid! Saanay suk pemenaan duma pa senilan, ndi' ilan gaid mekpu'asa. ");
INSERT INTO stb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma'ad mateng su gendaw ne suk pemenaan uwanen na buwat ri senilan, bu' rayun mekpu'asa ilan na. ");
INSERT INTO stb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nda'iruni getaw neng mektapak neg begu nek penepeten ri sed daan nek suub, tendeng ay sug begu nek tapak mengele' bu' megbagel na ma'aray tumu' sug berit nud daan nek suub. ");
INSERT INTO stb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bu' nda'irun isan ta' neng mekseled neg begu neg binu tu sed daan ne ngak panit neg betangan neg binu tendeng ay pebetuun nug binu sud daan ne ngag betangan, bu' sug binu bu' su ngak panit neg betangan medlaat. Tumu', sug begu neg binu seleren ri seg begu ne ngak panit neg betangan.” ");
INSERT INTO stb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Si Jesus duma se ngak tinu'unaan se Gendaw nek Pengulali minayan se ngak pigimulanan ne ngak trigu. Saanay minayan ilan ritu, su ngak tinu'unaan mikpengati' ne nga ginuwayan nek trigu. ");
INSERT INTO stb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aas su ngak Pariseo miktalu' ri ni Jesus, “Enlengay mu, supak ini ri se Kesugu'an ta sug binaal ne ngak tinu'unan mu se Gendaw nek Pengulali!” ");
INSERT INTO stb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Miksembag si Jesus, “Nda' amu ba mekebasa landunig binaal ni David sek panahun neng midlekina'enlan giin neng me'aan, seng miperii' giin bu' su ngak sementaunen? ");
INSERT INTO stb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sinumeled giin tu seg balay ned Diwata bu' minaan sek pan ne ginilak tu sed Diwata. Mihitabu' ini ne si Abiatar pa su Dlabaw ne Geseg nek Pari'. Sumala' se Kesugu'an ta, su ngak pari' ra sung mekekaan runik pan ketu. Ma'ad si David minaan run nini bu' binegayaan pa ngani' su ngak sementaunen.” ");
INSERT INTO stb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bu' tinapus ni Jesus sek pektalu', “Binaal su Gendaw nek Pengulali para se kepiyanan ne nga getaw; nda' baalay su getaw para se Gendaw nek Pengulali. ");
INSERT INTO stb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aas sug Bata' ne Getaw, Ginu'u isan se Gendaw nek Pengulali.” ");
INSERT INTO stb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Rayun mipuli' si Jesus tu sek pektipungan ne nga getaw Judeo. Bu' duuni getaw ritu neng mingupesi gemegen. ");
INSERT INTO stb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sud duma ne nga getaw ritu liyagan nilan mesumbung si Jesus pebiyan se gembaalen nek sayep; aas pini'iran nilan gupiya giin bu' pe'uli'aan ba su getaw ketu se Gendaw nek Pengulali. ");
INSERT INTO stb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Bu' miktalu' si Jesus tu se getaw, “Perinia seng metungenga'an.” ");
INSERT INTO stb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Rayun miksaak giin tu se nga getaw, “Landun maik tinugut se Kesugu'an ta neg baalen se Gendaw nek Pengulali? Suk pegabang ba awas pedlaat? Suk pedluwas ba se ketubu' ne getaw awas suk pekpatay?” Ma'ad nda'iruning mitalu' nilan. ");
INSERT INTO stb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Linengetan si Jesus seng migenleng ri senilan, ma'ad sek sama nek panahun, migu'ul rema giin para senilan tendeng ay metegas gupiyai gulu nilan. Rayun miktalu' giin tu se getaw, “Etat mui gemeg mu.” Inetat nu getaw su gemegen, bu' mi'uli'an ini. ");
INSERT INTO stb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aas su ngak Pariseo migawa' tu sek pektipungan, bu' miksempun kumita' tu sed duma ne ngak sakup ni Herodes bu' mikpelanu ilan sek pekpatay ri ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Si Jesus bu' su ngak tinu'unaan miritu se geksid ned danaw ne Galilea, bu' su gembagel nek panen ne nga getaw middunut ri seniin. Buwat ilan se Galilea, buwat seg Judea, ");
INSERT INTO stb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","buwat seg Jerusalem, buwat se dlugar nek sakup seg Idumea, buwat se dlugar nek sakup sed dapit sebangan neg Jordan, bu' buwat seg rihiyun sek timala' se ngak siyudad sek Tiro bu' sek Sidon. Dlaun ne nga getaw keni miritu ni Jesus tendeng ay mirengegan nilan su ngag betang nek pimbaalen. ");
INSERT INTO stb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Gembagel gupiya suk panen ne nga getaw aas sinugu'en su ngak tinu'unaan neng megandam nek sekayan para seniin, arun ndi' giin me'isel nilan. ");
INSERT INTO stb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pi'uli'aan sung melaun ne nga getaw, bu' su dlaun ne ngang minlaru miktisek sek pekpegaud arun mekiikap seniin. ");
INSERT INTO stb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bu' seng mi'ita' giin nu ngak pinulayan ne nga getaw, middempug ilan ri seng metungenga'aan, bu' migbeksay, “Dya'a sug Bata' ned Diwata!” ");
INSERT INTO stb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma'ad pimendu'an gupiya ni Jesus su ngak penulay ne ndi' nilan tabal tu se isan ta' bu' ta' getaw giin. ");
INSERT INTO stb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tubus itu tinumuwad si Jesus tu seg bentud, bu' tinawagen tu seniin su nga getaw ne dliyagaan bu' mikpegaud ilan tu seniin, ");
INSERT INTO stb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","bu' pimili'en suk sepulu' bu' ruwa', ne iningelanaan ne nga gapustulis. “Pimili'u amu arun meddunut ri senaan,” tinelu'aan ilan. “Sugu'en'u amu rema arun sek pekpenintulu', ");
INSERT INTO stb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","bu' mekaangken amu ne kega'em sek pekpegawas se ngak penulay.” ");
INSERT INTO stb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Giin nini suk sepulu' bu' ruwa' nek pimili'en: si Simon (ne iningelanaan nek Pedro); ");
INSERT INTO stb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Santiago bu' suk pateren ne si Juan, nga gembata' ni Zebedeo (bu' iningelanaan ilan neg Boanerges ne su gulugaan nga gembata' dlai ne Dlugung); ");
INSERT INTO stb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","si Andres, si Felipe, si Bartolome, si Mateo, si Tomas, si Santiago neg bata' ni Alfeo, si Tadeo, bu' si Simon, (ne kinumuntra se goberno seg Roma.) ");
INSERT INTO stb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Bu' si Judas Iscariote, neng migbudhi' ri ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Rayun minuli' si Jesus. Miktipung puli' su gembagel nek panen ne nga getaw. Tendeng run nini si Jesus bu' su ngak tinu'unaan nda'irun naik panahun nilan sek pekpengaan. ");
INSERT INTO stb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sek pekerengeg run itu nuk pamilyaan, linawan nilan giin arun uwanen, tendeng ay miktalu' ma su nga getaw, “Mitaleg giin!” ");
INSERT INTO stb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sud duma ne ngang mentetendu' se Kesugu'an neng minateng buwat seg Jerusalem miktalu', “Si Beelsebul diin seniin! Su geseg ne ngang menulay neng migbegay ri seniin ne ga'em sek pekpegawas run nini.” ");
INSERT INTO stb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aas sinabi ilan ni Jesus tu seniin bu' migasuy tu senilan pebiyan se nga galing, “Pekendunen ma ni Satanas sek pekpegawas ri ni Satanas? ");
INSERT INTO stb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bu' sung nasud mbahin bu' megunay megbunu' sung nasud ketu ndi' mekpayat mbengkag ini. ");
INSERT INTO stb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bu' suk pamilya mbahin bu' megunay megbunu', pamilya ketu mbengkag. ");
INSERT INTO stb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aas bu' suk pedlegeri'an ni Satanas mbahin se nga dlumpuk, ndi' mekpayat, mbengkag bu' mekpagaw sek peketapus.” ");
INSERT INTO stb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Nda'iruni getaw neng mekeseled ri seg balay ne getaw nek sekegan bu' uwanen su ngag betangen gawas bu' unanen gepusay su getaw nek sekegan; dekag pa rayun niin mpeddaawan sug balay ketu.” ");
INSERT INTO stb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Sek pekemetuud esuyan'u amu, mpasaylu su nga getaw se dlaun ne ngak sala' nilan bu' su dlaun neng melaat neng metalu' nilan. ");
INSERT INTO stb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma'ad su isan ta' neng mementalu' neng melaat ri se Gispiritu Santu ndi' na gaid mpasaylu, tendeng ay suk sala' neng mibaalen genda'i gekteben.” ( ");
INSERT INTO stb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Miktalu' si Jesus run nini tendeng ay sud duma ne nga getaw miktalu' ma, “Duuning melaat ne gispiritu ri seniin.”) ");
INSERT INTO stb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Rayun minateng su gina' bu' su ngak pated ni Jesus ne nga dlai. Mingindeg ilan tu se gawas neg balay bu' mikpawit ilan neng minsahi ne dliyagan nilan kumita' ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mingingkud ri sek timala' ni Jesus suk panen ne nga getaw bu' miktalu' ilan ri seniin, “Enlengay mu, su gina' mu bu' su ngak pated mu ne nga dlai bu' nga dlibun ritu se gawas, bu' liyagan nilan kumita' ri seni'a.” ");
INSERT INTO stb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Miksembag si Jesus, “Ta' mai gina'u? Ta' mai ngak pated'u?” ");
INSERT INTO stb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bu' inenlengaan su nga getaw neng mingingkud riin sek timala'en, “Enlengay niyu, giin nini su gina'u bu' su ngak pated'u! ");
INSERT INTO stb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ay su isan ta' neng megbaal se keliyag ned Diwata giin suk pated'u ne dlai, bu' dlibun, bu' gina'u.” ");
INSERT INTO stb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Migatad na pelum si Jesus sek pekpenendu' tu se geksid ned Danaw se Galilea. Gembagel gupiya suk panen ne nga getaw neng miktipung ri sek timala'en bu' tendeng run nini sinumakay si Jesus ri sek sekayan bu' migingkud sinegay suk panen ne nga getaw mingindeg tu se geksid ned danaw. ");
INSERT INTO stb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ginumamit giin ne nga galing sek pekpenendu' tu senilan seng melaun ne ngag betang, laungen tu senilan: ");
INSERT INTO stb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Penginengeg amu! Duunik sala tawan neng miritu seg binaal arun sek peksigwag se ngag beni'. ");
INSERT INTO stb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sek peksigwagen se ngag beni' tu seg binaal sud duma mitena' ri seg bebiyanan, bu' su ngang manukanuk mindateng bu' pingektuk nilan nini. ");
INSERT INTO stb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Sud duma ne ngag beni' mitena' tu se ngag betuwan ned duuning miika' ra ne dlupa' run. Sug beni' misempun ra mentubu' tendeng ay gembabaw ra su dlupa' run. ");
INSERT INTO stb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma'ad sek peksebang ne gendaw, minlawes ini; bu' tendeng ay nda' gupiya mekepengganget, migangu rayun su ngak pimula. ");
INSERT INTO stb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Sud duma ne ngag beni' mitena' tu se ngad dugiyan ne ngak sigbet, bu' se dlinumabung su ngak sigbet, linumemes tu se ngak pigimula, bu' nda' ini mekepemunga. ");
INSERT INTO stb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma'ad sud duma ne ngag beni' mitena' tu seng melengas ne dlupa', bu' mintubu' su ngag beni', miksilabung, bu' mikepemunga: sud duma telu pulu', su ngad duma genem pulu', bu' su ngad duma pa megatus.” ");
INSERT INTO stb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mbuus tinapus ni Jesus sek pektalu', “Bu' duuni ngak telinga niyu, penginengeg amu.” ");
INSERT INTO stb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sek sala ra run ni Jesus, sud duma neng mikerengeg ri sek pekpenendu'en mikpegaud tu seniin duma sek sepulu' bu' ruwa' ne ngak tinu'unaan bu' migandyu' ri seniin sek pekpesabut se gulugan se nga galing. ");
INSERT INTO stb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","“Binegay na riin seniyu sung mi'edlud ri sek Pedlegeri'an ned Diwata,” miksembag si Jesus. “Ma'ad tu se ngad duma ned diin se gawas, mekerengeg ilan se dlaun ne ngag betang pebiyan se nga galing, ");
INSERT INTO stb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","arun, ‘Isan kanunay ilan megenleng, ma'ad ndi' ilan mekiita'; bu' isan kanunay ilan menginengeg, ma'ad ndi' ilan mekesabut. Ay bu' mekesabut ilan, mekeddiksu' ilan, bu' pasayluun ilan ned Diwata.’” ");
INSERT INTO stb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Rayun miksaak si Jesus tu senilan. Nda' amu ba mekesabut se galing ketu? Bu' maa' niin, pegendunen niyu peksabut sed duma ne nga galing? ");
INSERT INTO stb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Su ngag beni' nek sinigwag neng mensesigwag giin sung minsahi ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sud duma ne nga getaw maa' nu ngag beni' ne ritu mitena' seg bebiyanan; sek pekerengeg nilan run sung minsahi, minateng si Satanas bu' inawi'en sung minsahi neng misigwag riin senilan. ");
INSERT INTO stb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Sud duma ne nga getaw maa' nu ngag beni' neng mitena' ri seg betuwan. Sek pekerengeg nilan seng minsahi ned Diwata, dinawat nilan nini duma se dleliyag. ");
INSERT INTO stb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma'ad nda' ini mekepengganget ri senilan, bu' nda' ilan mekepebilin se gempayat nek panahun. Aas sek peddateng se nga keliseran awas se ngak pedlutus tendeng seng minsahi, migawa' ilan rayun. ");
INSERT INTO stb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Sud duma ne nga getaw maa' nu ngag beni' neng mitena' riin se ngak sigbet ned dugiyan. Gilan su nga getaw neng mikerengeg seng minsahi, ");
INSERT INTO stb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma'ad su nga kegules metendeng se ketubu' keni, su gayak para se keratu', bu' su dlaun ne nga kelasi ne nga gangut linumabung bu' linumemes tu seng minsahi, bu' nda' ilan mekepemunga. ");
INSERT INTO stb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma'ad sud duma ne nga getaw maa' nu ngag beni' neng mitena' ri seng melengas ne dlupa'. Mikerengeg ilan seng minsahi, dinawat nilan nini, bu' mikepemunga: sud duma telu pulu', sud duma genem pulu', bu' sud duma megatus. ");
INSERT INTO stb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mikpeddayun si Jesus sek pektalu', “Duun bai getaw neng mektutud nek sulu' bu' betangenen nini riin sed diyalem ne gamang awas betangen ri sed diyalem ne dlantay? Ndi' ba betangen ma ini ri sek pengenturan? ");
INSERT INTO stb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ay isan landuning mi'edlud mesuunan ra, bu' isan landuning mitebunan, mbuwasan ra. ");
INSERT INTO stb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Penginengeg amu bu' duuni ngak telinga niyu!” ");
INSERT INTO stb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Miktalu' rema giin tu senilan, “Pegektemektemay gaid niyu gupiya landuning mirengeg niyu! Suk sukuran ne gemiten niyu sek pegukum tu sed duma giin rema su gemiten ned Diwata sek pegukum seniyu, ma'ad labaw pa gaid run nini. ");
INSERT INTO stb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ay su ngad duuning nilan begayan pa gaid, bu' su nga genda'iruning nilan, isan sung mitut ned diin senilan, uwanen pa riin senilan.” ");
INSERT INTO stb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Miktalu' pa gaid si Jesus, “Suk Pedlegeri'an ned Diwata maa' nini. Maa' sek sala tawan neng miksigwag ne ngag beni' ri seg binaalen. ");
INSERT INTO stb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sinegay minayan su nga gendaw bu' su nga gebii, su ngag beni' mimunsengit bu' mintubu', tumu' nda'en mesuunay bu' mikendun run nini pekehitabu'. ");
INSERT INTO stb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Su dlupa' ri se gegulingenen mekpetubu' se ngak pigimula bu' mekepemunga; se guna metuwa' sung melubed ne gupasen, rayun su ginuwayan, bu' su ketapusan, su ngang melinggas ne nga dlegas. ");
INSERT INTO stb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Seng mengginug na su nga dlegas, megatad medlegani su getaw duma ri sek seklaren, tendeng ay suk panahun sek penlegani minateng na. ");
INSERT INTO stb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“Lama run mai gempetenggi'an ta run metendeng sek Pedlegeri'an ned Diwata?” miksaak si Jesus. “Lama run mai galing ne gemiten ta sek pekpesabut run nini? ");
INSERT INTO stb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Maa' nini. Minuwan su getaw ne dlisu neng muntasa, su dlabi neng mitut ne dlisu rini seg benwa, bu' pimulaan nini ri se dlupa'. ");
INSERT INTO stb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Dluwat itu, tinumulin bu' mibaal ne dlabi gembagel se dlaun ne ngak pigimula. Miksibagel su ngak pangaan bu' ritu mekpesilung bu' meksalag su ngang manukanuk.” ");
INSERT INTO stb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Migwali si Jesus seng minsahiin tu se nga getaw, sek pegamit neng melaun ne nga galing neng maa' nini; inesuyaan ilan gekteb seng mesabut nilan. ");
INSERT INTO stb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ndi' giin megasuy tu senilan ne gena' pebiyan ri se nga galing, ma'ad bu' giin ra run duma se ngak tinu'unaan, pesabuten tu senilan su dlaun ne ngag betang. ");
INSERT INTO stb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Seng mekpeksindep nai gendaw itu, miktalu' si Jesus tu se ngak tinu'unaan, “Dumipag ita tu sed dipag geksid ned danaw.” ");
INSERT INTO stb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aas pinenawan nilan suk panen ne nga getaw; su ngak tinu'unaan sinumakay tu sek sekayan ne ritu na daan si Jesus mikpegingkud, bu' dinumipag ilan duma seniin. Sud duma ne ngak sekayan ritu rema. ");
INSERT INTO stb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Sek tikmal midlegurus sung merendes ne genus, bu' sug baled migatad lumambes tu sek sekayan, aas suk sekayan megaud na mpenu' nek tubig. ");
INSERT INTO stb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Si Jesus ritu se gulin nek sekayan, miktulug neng mikpegulun. Tinanud giin nu ngak tinu'unaan bu' miktalu', “Sir, nda'a ba megules neng megaud ita na mematay?” ");
INSERT INTO stb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Migbuwat si Jesus bu' pimendu'aan su genus bu' su ngag baled, laungen, “Keneng'a! Lengen'a!” Rayun mikeneng su genus bu' linumengen gupiya sud danaw. ");
INSERT INTO stb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Rayun miktalu' si Jesus tu se ngak tinu'unaan, “Lama mendek amu run? Tuma ma nda'irunik pektu'u niyu?” ");
INSERT INTO stb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma'ad minendek ilan gupiya bu' migatad meksesaakay suk salasala riin senilan, “Ta' mai getaw keni? Isan su genus bu' su ngag baled mektuman ma ri seniin!” ");
INSERT INTO stb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Si Jesus bu' su ngak tinu'unaan minateng tu sed dipag geksid ned Danaw ne Galilea, nek sakup se dlugar ne Gerasa. ");
INSERT INTO stb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Se kinumawas si Jesus buwat sek sekayan, sinungkak giin ne getaw buwat ritu se nga dlangeb nek pedlebengan. Getaw keni duuning melaat ne gispiritu riin seniin ");
INSERT INTO stb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","bu' mikengel ri se nga kelebengan. Nda'iruning mekegapus ri seniin, isan kadina pa su gemiten; ");
INSERT INTO stb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","melaunik panahun ne gepusen su nga geksuren bu' su nga gemegen ma'ad pembektusenen ra su nga kadina bu' geba'enen su ngak pusas ri se nga geksuren. Sekegan gaid giin gupiya bu' nda'irun isan sala neng mekepegeng ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gendaw bu' gebii midlaanglaang giin tu se nga kelebengan bu' se ngag binenturan, neng mekpegbeksay bu' pensemadsemaraan neg batu su gegulingenen. ");
INSERT INTO stb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mi'ita'en si Jesus tu seng melayu'layu'; ginumebek giin pagaw tu seniin rayun miginlulud riin seng metungenga'aan, ");
INSERT INTO stb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","bu' migbeksay neng mesekeg, “Jesus, Bata' ne Dlabaw ned Diwata! Lama run mai dliyagan mu ri senaan? Se ngalan ned Diwata, mekpe'ilelaatu seni'a, ndi' mau silutay!” ( ");
INSERT INTO stb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Miketalu' giin run nini tendeng ay miktalu' ma si Jesus, “Melaat ne gispiritu, gawas'a ri se getaw iin!”) ");
INSERT INTO stb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aas sinaakan giin ni Jesus, “Ta' mai ngalan mu?” Miksembag su getaw, “Su ngalan'u si ‘Linibulibu’ tendeng ay melaun ami gupiya!” ");
INSERT INTO stb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bu' mikpeddayun giin sek pekpe'ilelaat ri ni Jesus ne ndi'en pe'uwa'en su ngang melaat ne gispiritu sek probinsiya ketu. ");
INSERT INTO stb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ritu seng megaud duuni gembagel nek panen ne ngag babuy, mikpenlungad ritu seg biliran. ");
INSERT INTO stb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aas su ngang melaat ne gispiritu mikpe'ilelaat ri ni Jesus, “Peperitu mu ami se ngag babuy, tugutay mu ami sek pekseled tu senilan.” ");
INSERT INTO stb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Bu' tinugutaan su ngang melaat ne gispiritu neng menggawas buwat se getaw bu' sumeled tu se ngag babuy. Suk tibuuk nek panen ketu duuni ngad duwa' libu ne ngag babuy neng minikad mendiksun tu sed danaw bu' milemes ilan. ");
INSERT INTO stb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bu' su ngang midlekata se ngag babuy, minggebek bu' pidlelaup nilan suk tuntulan tu se dlunsud bu' tu se ngag binaal. Su nga getaw miritu arun sek pegenleng seng mihitabu'. ");
INSERT INTO stb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bu' seng minateng ilan tu ni Jesus, mi'ita' nilan su getaw ne gine'eman nud diin ne dlinibulibu ne ngang melaat ne gispiritu. Mikpegingkud giin ritu ned duun naik suuben bu' melengas na suk pengena'ena'en; bu' dlaun nilan minendek. ");
INSERT INTO stb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bu' su dlaun neng mikiita' run nini, mingasuy tu se nga getaw seng mihitabu' tu se getaw ne gine'eman ne ngang melaat ne gispiritu bu' metendeng se ngag babuy. ");
INSERT INTO stb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aas inandyu' nilan si Jesus neng megawa' giin tu se dlugar nilan. ");
INSERT INTO stb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sek sumakay na si Jesus tu sek sekayan, su getaw neng mi'uli'an mikpe'ilelaat ri seniin, “Tugutay mau neng mekeddunut seni'a!” ");
INSERT INTO stb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma'ad si Jesus nda' peliyag. Tumu', miktalu' giin, “Uli'a tu sek pamilya mu bu' asuy mu tu senilan landunig binaal ne Ginu'u riin seni'a bu' gendun giin kepiya ri seni'a.” ");
INSERT INTO stb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aas su getaw midlaang bu' miritu giin sed Decapolis bu' inasuyen sug binaal ni Jesus ri seniin, bu' su dlaun ne nga getaw neng mikerengeg run nini mitingala. ");
INSERT INTO stb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mbuus dinumipag puli' si Jesus tu sed dipag geksid ned danaw. Ritu su gembagel nek panen ne nga getaw miktipung pelibut ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Si Jairus, su geseg sek pektipungan minateng ritu, bu' sek pekiita'en riin ni Jesus, middempug giin ri seng metungenga'aan, ");
INSERT INTO stb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","bu' mikpe'ilelaat gupiya giin ri seniin neng miktalu', “Sug bata'u ne dlibun miktinga' na bu' mehimu, peritua seg balay'u bu' depen mu su nga gemeg mu tu seniin arun me'uli'an giin bu' metubu'.” ");
INSERT INTO stb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bu' middunut si Jesus ri seniin. Melaun rema ne nga getaw neng middunut riin ni Jesus bu' mikisel ilan pelibut ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Duuni dlibun ritu neng migantus sek peddugu'rugu' seled na sek sepulu' bu' ruwa' taun, ");
INSERT INTO stb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","isan binulung na giin neng melaun ne ngad duktur. Ginastuun su dlaun nek selapi'en, imbis me'uli'an siya, miksamet na ma'ad tumu'. ");
INSERT INTO stb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mikerengeg giin metendeng ri ni Jesus, aas minigel giin arun meketipung tu sek panen ne nga getaw ned diin sek teliyuran ni Jesus, ");
INSERT INTO stb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","miktalu' giin ri se gegulingenen, “Bu' me'ikap'u ma'ad suk suuben, me'uli'anu gaid.” ");
INSERT INTO stb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aas inikapen suk suub ni Jesus bu' milali rayun suk peddugu'rugu'en; bu' binatiken riin se dlawasen neng mi'uli'an na sung megeelen. ");
INSERT INTO stb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Binatik rayun ni Jesus ned duuni ga'em ne ginumawas ri seniin. Aas tinumeliyud giin tu se ngak panen ne nga getaw bu' miksaak, “Ta' maing migikap ri sek suub'u?” ");
INSERT INTO stb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Miksembag su ngak tinu'unaan, “Mi'ita' mu ma su nga getaw neng minisel ri seni'a; tuma ma meksaak'a ma ta' getaw sung minikap seni'a?” ");
INSERT INTO stb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma'ad migenleng si Jesus ri sek timala'en arun me'ita'en bu' ta' sung migbaal run nini. ");
INSERT INTO stb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na, misuunan nu dlibun bu' landun sung mihitabu' ri seniin, aas mikpegaud giin neng mikpengereg duma se gendek, middempug riin se geksud ni Jesus bu' mikpegasuy tu seniin seng metuud neng mihitabu'. ");
INSERT INTO stb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Miktalu' si Jesus tu seniin, “Bata'u ne dlibun, suk pektu'u mu giin sung mikepetelen seng megeel mu. Dlaang'a ned duuni kelinaw bu' mi'uli'an na sung megeel mu.” ");
INSERT INTO stb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bu' saanay pa ni Jesus mektuntul run nini, duunik santa' tawan neng minateng buwat tu seg balay ni Jairus bu' mikpesuun tu seniin, “Sug bata' mu ne dlibun minatay na. Tuma ma semuken mu pema sung mektetendu' kiin?” ");
INSERT INTO stb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma'ad nda' pengebetay ni Jesus bu' landunik tinalu' nilan, laungen tu ni Jairus, “Ndi'a mendek, mektu'ua ma'aray.” ");
INSERT INTO stb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Rayun nda'irunik tinugutaan neng meddunut ri seniin gawas ri senilan ni Pedro, Santiago, bu' suk pateren ne si Juan. ");
INSERT INTO stb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bu' sek peddateng nilan tu seg balay ni Jairus, mi'ita' ni Jesus neng migubet su nga getaw, sud duma minsegaw bu' minggulawal. ");
INSERT INTO stb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Rayun, sinumeled giin bu' miktalu' tu senilan. “Lama megubet amu run bu' mensegaw? Bata' keni nda' patay ma'ad miktulug na run.” ");
INSERT INTO stb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma'ad piketuwanan nilan giin, aas pigawasen su dlaun ne nga getaw; inuwiten su gama' bu' su gina' nug bata' bu' suk telu tawan nek tinu'unaan bu' miritu ilan sed dugu ne ritu migbelilid sug bata'. ");
INSERT INTO stb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bu' inuwiran ni Jesus su gemeg nug bata' bu' miktalu' tu seniin, “Talitha koum,” neng migulugan, “Enu', buwat'a!” ");
INSERT INTO stb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Migindeg rayun sug bata' ne dlibun bu' midlaanglaang. (Sepulu' bu' ruwa' taun su giddaren.) Seng mihitabu' ini, mitingala ilan gupiya. ");
INSERT INTO stb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma'ad pinegulan ilan gupiya ni Jesus ne kina'enlan ndi' ini nilan pengasuy se isan ta', bu' miktalu' giin tu senilan, “Begayay niyu giin neng me'aan.” ");
INSERT INTO stb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Migawa' si Jesus tu se dlugar ketu bu' mipuli' tu se gegulingenen ne dlunsud bu' middunut seniin su ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Se Gendaw nek Pengulali, migatad giin menendu' tu sek pektipungan ne nga getaw Judeo. Melaun ne nga getaw ritu; bu' sek pekerengeg nilan ri seniin, dlaun nilan mitingala, “Ta' ma niin pinguwani dlaunan keni?” miksaak ilan. “Lama tinaway runig binegay ri seniin? Pikendunen run sek pegbaal su ngang milagru? ");
INSERT INTO stb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Gena' ba giin suk panday, sug bata' ni Maria, bu' suk pated ni Santiago, ni Jose, ni Judas, bu' ni Simon? Gena' ba su ngak pateren ne nga dlibun dini ma mikengel?” Aas binibay nilan giin. ");
INSERT INTO stb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Miktalu' si Jesus tu senilan, “Su ngak propeta tinamed isan ta' gawas ma'aray ri se gegulingenen ne dlunsud bu' se nga gepenaan bu' sek pamilyaan.” ");
INSERT INTO stb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nda' giin mekegbaal ritu ne ngang milagru, gawas tu se ngak santa' tawan neng minlaru ned dinepenen su nga gemegen tu senilan bu' pi'uli'aan ilan. ");
INSERT INTO stb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aas mitingala gupiya giin tendeng ay su nga getaw nda'irunik pektu'u nilan. Rayun midlibed si Jesus se ngag baryu ritu, sek pekpenendu' se nga getaw. ");
INSERT INTO stb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Bu' tinawagen suk sepulu' bu' ruwa' ne ngak tinu'unaan, bu' pilaangen ilan nek pidduwa' tawan bu' binegayaan ilan se kega'em sek pekpe'awa' kuntra se ngang melaat ne nga gispiritu, ");
INSERT INTO stb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","bu' pimendu'aan ilan, “Ndi' amu meguwit isan landun sek pedlaang niyu gawas se gages. Ndi' amu meguwit nek pan, gambag, awas selapi' riin se ngag baling niyu. ");
INSERT INTO stb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mekseluk amu ne ngak sandalyas, ma'ad ndi' amu meguwit ned dugang ne gilisan.” ");
INSERT INTO stb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Miktalu' rema giin tu senilan, “Sek peddateng niyu se dlunsud ritu amu penaik seg balay neng megenggat riin seniyu bu' ndi' amu gumalin tampan megawa' amu tu se dlunsud ketu. ");
INSERT INTO stb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bu' mekeritu amu se dlunsud ne su nga getaw ndi' dumawat awas menginengeg seniyu, beleng niyu ini bu' tektak niyu su dlubek ri se nga geksud niyu gisip pekpenegul kuntra riin senilan.” ");
INSERT INTO stb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Aas minlaang ilan bu' migwali arun su nga getaw meddiksu' ri se ngak sala' nilan. ");
INSERT INTO stb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pigawas nilan sung melaun ne ngang melaat ne gispiritu bu' pinlunasan ne dlana su ngang minlaru bu' mi'uli'an ilan. ");
INSERT INTO stb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na si Ari' Herodes mikerengeg metendeng run nini, tendeng ay su kebantug ni Jesus midlelaup isan ta'. Sud duma ne nga getaw miktalu', “Si Juan neng Membebendyag mitubu' puli'! Giin itu su keterengan ned duuni ga'emen sek pegbaal ne ngang milagru.” ");
INSERT INTO stb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma'ad su ngad duma miktalu', “Giin si Elias.” Su ngad duma miktalu', “Propeta giin, maa' giin sek sala se ngak propeta nud diin.” ");
INSERT INTO stb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bu' sek pekerengeg run nini ni Herodes, miktalu' giin, “Giin si Juan neng Membebendyag nek pipetelan'u ne gulu, ma'ad mitubu' giin puli'!” ");
INSERT INTO stb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ay si Herodes ma ugud mismu sung miksugu' ned daapen si Juan, bu' pigapusen giin bu' piperisuun. Binaalen nini tendeng ri ni Herodias nek pingesawaan isan bu' sawa sek pateren ne si Felipe. ");
INSERT INTO stb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ay si Juan neng Membebendyag kanunay miktalu' tu ni Herodes, “Gena' metareng para seni'a suk pekpengesawa mu sek sawa nek pated mu.” ");
INSERT INTO stb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Aas si Herodias midlegemet ri ni Juan bu' liyagaan nek petain giin. Ma'ad ndi' giin mekebaal run nini tendeng ri ni Herodes. ");
INSERT INTO stb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Si Herodes minendek riin ni Juan tendeng ay misuunaan ne si Juan metareng bu' bala'an ne getaw, bu' pineliperaan giin. Liyagen giin menginengeg ri seniin isan metuud neng mesemukan gupiya giin se kada menginengeg ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Se ketambinai' minateng ra gaid suk panahun nek pikperateng ni Herodias. Mihitabu' ini se pedlegendawan ni Herodes. Mikpebibu giin para tu se nga dlabaw ne ngang mingetendanan ri se goberno, tu se nga geseg ne ngak sundaluun, bu' tu se ngag bentugan ne nga getaw tu se Galilea. ");
INSERT INTO stb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bu' sinumeled sug bata' ni Herodias ned delaga bu' tinumalek ini neng mikepedleliyag gupiya riin ni Herodes bu' tu se ngak pingenggaten. Aas su gari' miktalu' tu sed delaga, “Penengia ri senaan isan landun neg betang ne dliyagan mu, ay begay'u ini seni'a.” ");
INSERT INTO stb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Bu' seng melaun ne ngak pekpenumpa' miktalu' giin seniin, “Penumpa'u neg begay'u isan landun neg betang suk penengiin mu, isan pa ketenga' sek pidlegeri'an'u!” ");
INSERT INTO stb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aas ginumawas sud delaga bu' miksaak tu se gina'en, “Lama runik penengiin'u?” “Su gulu ni Juan neng Membebendyag,” miksembag su gina'en. ");
INSERT INTO stb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bu' sud delaga mimagas rayun sumeled puli' bu' miktalu' tu se gari', “Liyagan'u neg begay mu riin senaan rayun nemuun su gulu ni Juan neng Membebendyag neg betangen riin sek sendukan.” ");
INSERT INTO stb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mikepegu'ul ini gupiya ri se gari', ma'ad ndi' giin mekegbelibad tendeng se ngak penumpa'en riin seng metungenga'an nu ngak pingenggaten. ");
INSERT INTO stb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aas miksugu' giin rayun ne guwardiya duma sek pemandu' ne uwiten tu seniin su gulu ni Juan. Bu' midlaang su guwardiya, miritu sek perisuwan, bu' pinetelen su gulu ni Juan; ");
INSERT INTO stb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","rayun inuwiten nini neg binetang ri sek sendukan bu' binegain tu sed delaga, bu' binegay rema ini nud delaga tu se gina'en. ");
INSERT INTO stb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bu' sek pekerengeg run nini nu ngak tinu'unan ni Juan, miritu ilan bu' inuwan sug bangkain bu' linebeng nilan ini. ");
INSERT INTO stb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mipuli' su nga gapustulis tu ni Jesus bu' inasuy nilan su dlaun nek pimbaal bu' pinendu' nilan. ");
INSERT INTO stb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Duuning melaun ne nga getaw neng migeleseles sek peddateng bu' pekpenlaang, bu' su ngak tinu'unaan nda' naik panahun nilan isan sek pekaan. Aas miktalu' si Jesus tu senilan, “Meritu ita se dlugar ne nda'iruni getaw run bu' ritu, mekepengulali amu sek sereluk.” ");
INSERT INTO stb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aas sinumakay ilan ri sek sekayan ne gilanilan ra pagaw tu se dlugar ne nda'iruni getaw run. ");
INSERT INTO stb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma'ad melauni nga getaw neng mikiita' ri sek pekpanaw nilan bu' mi'ilala ilan rayun; aas minditu su nga getaw buwat se dlaun ne dlinunsuran neng minggebek pagaw tu se dlugar nek pa'agawan ni Jesus bu' ngak tinu'unaan bu' mi'una ilan pa mateng ritu. ");
INSERT INTO stb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bu' se kinumawas na si Jesus tu sek sekayan, mi'ita'en su gembagel nek panen ne nga getaw, bu' milelaat giin senilan, tendeng ay maa' ilan ne nga karniru ne genda'iruning menggegingat run. Aas migatad giin sek pekpenendu' ri senilan seng melaun ne ngag betang. ");
INSERT INTO stb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bu' sek pekerelabung na, miritu seniin su ngak tinu'unaan neng miktalu', “Dlelabung na gupiya bu' keni ita seng mingaw ne dlugar. ");
INSERT INTO stb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Peperitu mu nga getaw iin seng mekegaud ne ngag binaal bu' binaryuan arun mekepenaluy ilan neng me'aan.” ");
INSERT INTO stb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“Gamu mismu sung megbegay senilan neng me'aan,” miksembag si Jesus. Miksaak ilan, “Liyagan mu ba neng menlaang ami bu' gumastu ned duwa' gatus ne ngak selapi' nek pelata arun sumaluy ne ngak pan arun pe'aan ri senilan?” ");
INSERT INTO stb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Bu' miksaak si Jesus tu senilan, “Santa' buuk maik pan niyu riin? Dlaang amu bu' enlengay niyu.” Seng mi'ita' na nilan, miksembag ilan, “Dlima buuk pan bu' duwa' buuk sera'.” ");
INSERT INTO stb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bu' rayun tinelu'an ni Jesus su ngak tinu'unaan sek pekpelumpuklumpuk se nga getaw bu' pekpe'ingkud ri seng mekelunaw nek sigbet. ");
INSERT INTO stb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aas mingingkud su nga getaw neng midlumpuklumpuk nek pingmegatus bu' pidlima pulu'. ");
INSERT INTO stb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Rayun inuwan ni Jesus su dlima buuk nek pan bu' duwa' buuk sera', migangag tu se dlangit, bu' mikpesalamat tu sed Diwata. Pinetapetaan su ngak pan bu' binegain tu se ngak tinu'unaan arun pengaperaped tu se nga getaw. Pikilasilasen rema sud duwa' buuk sera' para tu se dlaun nilan. ");
INSERT INTO stb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bu' su dlaun nilan mikekaan bu' mibesug. ");
INSERT INTO stb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Rayun su ngak tinu'unaan miketimud pa nek sepulu' bu' ruwa' bebaan neng mikepenu' nek sawad buwat sek pan bu' sek sera'. ");
INSERT INTO stb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Su dlaun ne nga dlai neng minaan dlima libu tawan. ");
INSERT INTO stb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pisakay rayun ni Jesus su ngak tinu'unaan tu sek sekayan sek peguna ri seniin tu seg Betsaida, tu sed dipag geksid ned danaw, saanay pipe'uli'en pa suk panen ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Seng mikenangid na giin tu se nga getaw, tinumuwad giin tu seg bentud arun sek pegampu'. ");
INSERT INTO stb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bu' sek pekegebii na, suk sekayan ritu na sek titenga' ned danaw, saanay si Jesus salaan ra ritu sek taasan. ");
INSERT INTO stb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Bu' mi'ita'en su ngak tinu'unaan neng midlised sek pekpemelula tendeng ay misensung nilan su genus. Sek pekeddali'endaw, miritu giin senilan neng midlaang riin sed dibabaw nek tubig. Miyan na run siya giin tu senilan, ");
INSERT INTO stb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ma'ad mi'ita' nilan giin neng mikpedlaang riin sed dibabaw nek tubig. “Kiin nai kalag!” migena'ena' ilan, bu' mimbeksay. ");
INSERT INTO stb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Dlaun nilan minendek gupiya sek pekiita' nilan ri seniin. Ma'ad miktalu' rayun si Jesus tu senilan, “Ligen niyu su gena'ena' niyu,” miktalu' giin. “Gaku' ini. Ndi' amu mendek!” ");
INSERT INTO stb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Rayun sinumakay giin tu sek sekayan duma senilan bu' su genus linumengen. Su ngak tinu'unaan mitingala gaid gupiya, ");
INSERT INTO stb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tendeng ay nda' nilan mesabut sung metuud ne gulugan sek pekpe'aan se dlima libu; medlised su nga gena'ena' nilan sek peksabut. ");
INSERT INTO stb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dinumipag ilan tu sed danaw, bu' dinumenggu' ilan tu se Genesaret, bu' ritu nilan iniket suk sekayan. ");
INSERT INTO stb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bu' se kinumawas ilan na tu sek sekayan, mi'ilala rayun nu nga getaw si Jesus. ");
INSERT INTO stb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Aas su nga getaw sek timala' ne dlugar minggebek ritu; bu' isan ta' nilan giin mirengegan, inuwit nilan tu seniin su ngang minlaru neg binelilid ri se ngad dendam nilan. ");
INSERT INTO stb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bu' isan ta' pagaw si Jesus, tu se ngag binaryuan, tu se nga dlunsud, awas tu se ngag binaal, su nga getaw meguwit seng minlaru nilan tu se nga dlugar nek tipunganan nilan bu' migandyu' nek pe'ikapen su ngang minlaru isan na run riin se kumiling ne dlambungen. Bu' su dlaun neng mikiikap run nini mi'uli'an. ");
INSERT INTO stb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sud duma ne ngak Pariseo bu' su ngang mentetendu' se Kesugu'an neng minateng buwat seg Jerusalem miktipung pelibut riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mi'ita' nilan ne sud duma ne ngak tinu'unan ni Jesus minaan neng melemu' su nga gemeg nilan—bu' senita pa, nda' ilan mekepengunaw sumala' sek pebiyan nek tinendu' ne ngak Pariseo neg baalen ne nga getaw. ( ");
INSERT INTO stb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Su ngak Pariseo bu' su dlaun ne nga getaw Judeo miksunud se nga ketendu'an neng mirawat buwat se nga gepu'an nilan. Ndi' ilan maan bu' ndi' nilan me'unawan se ginsaktu su nga gemeg nilan; ");
INSERT INTO stb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","awas ndi' ilan maan isan landun neg buwat ri sek pemeledya'an gawas neng me'ugasan nilan nini guna. Bu' sinunud nilan sung melaun ne ngak sugu', neng mirawat nilan, maa' se ginsaktu nek pegugas se ngak tasa, ngak pitsil, nga kaldiru, bu' ngag beliliran.) ");
INSERT INTO stb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aas su ngak Pariseo bu' su ngang mentetendu' se nga Kesugu'an miksaak ri ni Jesus, “Tuma ma su ngak tinu'unan mu nda' ma peksunud se nga ketendu'an neg binilin nu nga gepu'an ta, tumu' minaan ilan isan melemu' su nga gemeg nilan?” ");
INSERT INTO stb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Miksembag si Jesus tu senilan, “Ginsaktu gaid suk pekpengatuk ni propeta Isaias metendeng seniyu! Gamu sung mikpelaunglaung, sumala' sek sinulaten: ‘Nga getaw keni, miktalu' sud Diwata, mikpesiddengeg ilan ri senaan sek talu' na run, ma'ad su nga gena'ena nilan melayu' ri senaan. ");
INSERT INTO stb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nda'irunik paluun suk peksimba nilan ri senaan, ay su ngak sugu' neg binaal ne nga getaw tinendu' nilan ne ngak sugu'u raw.’” ");
INSERT INTO stb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Binibay niyu suk sugu' ned Diwata bu' tinuman niyu su nga ketendu'an ne nga getaw.” ");
INSERT INTO stb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Bu' middugang pa gaid mektalu' si Jesus, “Metau amu gaid megbibay sek sugu' ned Diwata arun mpetuman niyu su gegulingen niyu ne ketendu'an. ");
INSERT INTO stb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ay si Moses miksugu', ‘Pegbesaay mu su gama' mu bu' su gina' mu,’ bu' ‘sung mementalu' neng melaat kuntra tu se gama' awas gina'en kina'enlan gaid nek petain.’ ");
INSERT INTO stb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma'ad miktendu' amu, ne bu' su nga getaw duuning me'abang nilan tu se gama' awas gina' nilan, ma'ad mektalu' ilan, ‘Korban ini’ (neng migulugan nek sinaad para begay tu sed Diwata), ");
INSERT INTO stb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ndi' ilan na mbaya' megabang ri se gama' awas gina' nilan. ");
INSERT INTO stb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Seng maa' nini nek pebiyan, nda' niyu tendu' suk talu' ned Diwata riin se ngak penendu'an nek pisunud niyu ri sed duma. Bu' melaun pa ne ngag betang neng maa' nini neg binaal niyu.” ");
INSERT INTO stb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Rayun tinawag puli' ni Jesus suk panen ne nga getaw tu seniin, bu' miktalu' tu senilan, “Penginengeg amu ri senaan, dlaunan niyu, bu' sabut niyu ini: ");
INSERT INTO stb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","nda'irunig betang nek sumeled riin seg baba' niyu neg buwat ri se gawas neng mekepelemu' ri seniyu. Tumu', landun sung menggawas riin seg baba' niyu, giin sung mekepelemu' ri seniyu.” ");
INSERT INTO stb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Seng migawa' si Jesus tu se nga getaw bu' sinumeled tu seg balay, su ngak tinu'unaan miksaak ri seniin metendeng se galing ketu. ");
INSERT INTO stb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Miktalu' si Jesus tu senilan, “Nda' amu ba rekay mekesabut? Nda' ba niyu mesabut ne su dlaun neg buwat se gawas nek sumeled riin seg baba' niyu, ndi' mekepelemu' ri seniyu, ");
INSERT INTO stb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tendeng ay ndi' ini meseled ri sek pengena'ena' niyu ma'ad riin sek tiyan niyu, bu' rayun gumawas ra ini ri se dlawas?” (Sek pektalu' ni Jesus run nini, mikpemetuud ne su dlaun ne ngak pekaan mbaya' aanen.) ");
INSERT INTO stb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Bu' mikpeddayun giin sek pektalu', “Landuni gumawas riin se gena'ena' niyu, giin nini sung mekepelemu' ri seniyu. ");
INSERT INTO stb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ay buwat ri se gena'ena' niyu, gumawas sung melaat nek pengena'ena' ne giining megunut ri seniyu seg imural nek pekpekighilawas, sek peddaaw, sek pekpatay, ");
INSERT INTO stb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sek pekpenapaw, se kerelaw, sek pegbaal se dlaun nek pekemelaat, sek pekpenlimbung, sek pekpetuyang seg imural nek pekpekighilawas, se kesina, sek pedlaat ri sed duma, sek pekemelipetaasen, bu' seg binural— ");
INSERT INTO stb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","dlaun ne ngang mekelaat ne ngag betang keni megbuwat ri se gena'ena' niyu bu' mekegbaal neng mekepelemu' ri seniyu.” ");
INSERT INTO stb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mbuus migawa' si Jesus se dlugar ketu bu' miritu giin se nga dlugar neng megaud sek siyudad sek Tiro. Sinumeled giin tu seg balay bu' ndi'en liyagan ned duuning mekesuun ned ditu giin. Ma'ad ndi' gaid giin mekegedlud. ");
INSERT INTO stb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sala gina', ne sug bata'en ne dlibun duuning melaat ne gispiritu riin seniin, mikerengeg metendeng ri ni Jesus bu' miritu rayun seniin bu' middempug riin se geksuren. ");
INSERT INTO stb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dlibun keni gena' Judeo, mi'etaw ritu se dlugar sek Fenicia nek sakup sek Syria. Migandyu' giin ri ni Jesus nek peguwasenen sung menulay buwat riin seg bata'en. ");
INSERT INTO stb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma'ad miktalu' si Jesus, “Paanen ta reli' guna su nga gembata'. Ay ndi' mpiya ne uwanen su gaan ne nga gembata' bu' tikpu'en tu se nga gitu'.” ");
INSERT INTO stb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Sir,” miksembag giin, “Isan su nga gitu' ri sed diyalem ne dlemisaan mekekaan se ngang mumu se nga gaan ne nga gembata'!” ");
INSERT INTO stb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aas miksembag si Jesus tu seniin, “Tendeng seng maa' niin nek sembag, uli'a na; bu' me'ita' mu ne suk penulay ginumawas na tu seg bata' mu ne dlibun!” ");
INSERT INTO stb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Minuli' giin bu' mi'ita'en sug bata'en neng mikpegbelilid; bu' suk penulay ginumawas na ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Rayun migawa' si Jesus tu se dlugar nek Tiro bu' minetas tu sek Sidon pagaw tu sed danaw Galilea, dluwaten, biyanay su dlugar nek sakup sed Decapolis. ");
INSERT INTO stb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Sud duma ne nga getaw miguwit tu seniin nek sala ne getaw neg bengel bu' ndi' gupiya meketuntul, bu' mikpe'ilelaat ilan ri ni Jesus ned depenaan giin. ");
INSERT INTO stb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aas inuwit giin ni Jesus pelayu' tu se ngak panen ne nga getaw, ineksuken su ngak tendu'en tu se ngak telinga nu getaw, middula' giin, bu' inikapen sud dila' nu getaw. ");
INSERT INTO stb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Rayun migangag si Jesus tu se dlangit, middegu, bu' miktalu' tu se getaw, “Efata!” ne su gulugan, “Mpukaa!” ");
INSERT INTO stb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bu' mikerengeg rayun su getaw, suk pekegugelen mitelen, bu' mpalas na suk pegabiten. ");
INSERT INTO stb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Rayun si Jesus mimandu' tu se nga getaw ne ndi' ilan mengasuy tu se isan ta'; ma'ad seng middugang pa la' na giin sek pekpemandu', miksamet ilan na ma'ad tumu' mengasuy. ");
INSERT INTO stb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Su dlaun neng mikerengeg mitingala gupiya bu' miktalu', “Su dlaun ne ngag betang neg binaalen melengas! Isan sug bengel miperengegen bu' su gugel mipetuntulen.” ");
INSERT INTO stb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nda' mpayat, dlain na pelum ne gembagel nek panen ne nga getaw neng miktipung. Se genda'irun naing me'aan nilan, tinawag ni Jesus su ngak tinu'unaan tu seniin bu' miktalu', ");
INSERT INTO stb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Milelaatu ri se nga getaw keni, tendeng ay middunut ilan ri senaan seled sek telu endaw bu' nemuun nda'irun naing me'aan nilan. ");
INSERT INTO stb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bu' pepe'uli'en'u ilan ne ndi' mpe'aan, ali' bu' punaun ilan ri se dlaangan, tendeng ay sud duma senilan buwat pa seng melayu'.” ");
INSERT INTO stb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Miksaak su ngak tinu'unaan ri seniin, “Ta' ita ma penguwan neng me'aan rini se kemingawan arun mpe'aan ri se dlaun ne nga getaw keni?” ");
INSERT INTO stb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Santa' buuk maik pan niyu riin?” miksaak si Jesus. “Pitu buuk,” miksembag ilan. ");
INSERT INTO stb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mbuus mimandu' giin tu se nga getaw neng megingkud ilan ri se dlupa'an. Rayun inuwanen suk pitu buuk pan, mikpesalamat giin tu sed Diwata, bu' pinetapetaan, bu' binegain tu se ngak tinu'unaan sek pekpengaperaped tu se nga getaw; bu' binaal ini nu ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Duun remaik santa' buuk neng mekiika' ne ngak sera' nilan. Mikpesalamat si Jesus para run nini, bu' tinelu'aan su ngak tinu'unaan sek pegaperaped rema tu se nga getaw. ");
INSERT INTO stb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Mingaan su nga getaw bu' mibesug ilan. Binalabena' ned duuni gepaat libu tawan sung minaan. Rayun su ngak tinu'unaan miketimud pa gaid nek pitu bebaan neng mipenu' nek sawad. Bu' pipe'uli' rayun ni Jesus su nga getaw ");
INSERT INTO stb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","bu' sinumakay rayun giin tu sek sekayan duma nu ngak tinu'unaan bu' miritu ilan se dlugar ned Dalmanuta. ");
INSERT INTO stb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Duunik santa' tawan ne ngak Pariseo neng miritu ni Jesus bu' migatad megaddat ri seniin. Liyagan nilan ne indanan giin, aas migandyu' ilan ri seniin neng mekpe'ita' neng milagru neng mekpemetuud nek sinugu' giin ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ma'ad mingagu si Jesus bu' miktalu', “Tuma ma su nga getaw sek panahun keni menengi ma neng milagru? Ndi', esuyan'u amu! Nda'irunik pemetuud neg begay tu se nga getaw!” ");
INSERT INTO stb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bu' pinenawaan ilan rayun, bu' mipuli' tu sek sekayan, bu' migatad dumipag tu sed dipag geksid ned danaw. ");
INSERT INTO stb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Su ngak tinu'unaan mikelingaw sek peguwit se gigu' nek pan bu' duunik salabuuk raik pan nilan tu sek sekayan. ");
INSERT INTO stb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","“Pegingat amu,” minegul si Jesus tu senilan, “pegbantay amu sek pempetulin ne ngak Pariseo bu' pempetulin ni Herodes.” ");
INSERT INTO stb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Migatad ilan sek pekpegaddat ri sek salasala senilan: “Miketalu' giin run nini tendeng ay nda'irunik pan ta.” ");
INSERT INTO stb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Misuunan ni Jesus bu' landunik tinalu' nilan, aas miksaak giin tu senilan, “Tuma ma megaddat amu ma metendeng se genda'irunik pan? Nda' ba niyu mesuunay awas mesabut? Tinumegas na ba su nga gena'ena' niyu? ");
INSERT INTO stb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Duun mai ngang mata niyu, ndi' amu ba mekiita'? Duun mai ngak telinga niyu, ndi' amu ba mekerengeg? Nda' ba niyu me'ena'ena' ");
INSERT INTO stb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","suk pekpetapetau se dlima buuk pan para tu se dlima libu ne nga getaw? Santa' bebaan ma sung mipenu' ne ngak sawad ne ngak pan neng mitimud niyu?” “Sepulu' bu' ruwa',” miksembag ilan. ");
INSERT INTO stb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Bu' sek pekpetapetau sek pitu buuk pan para tu se gepaat libu ne nga getaw,” miksaak si Jesus, “santa' bebaan maing mipenu' nek sawad sek pinetapeta ne ngak pan neng mitimud niyu?” “Pitu bebaan” miksembag ilan. ");
INSERT INTO stb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Bu' nda' amu pa ba gusay mekesabut?” Miksaak giin tu senilan. ");
INSERT INTO stb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Minateng ilan tu seg Betsaida bu' duunid duma getaw ritu neng miguwit neg buta tu ni Jesus bu' mikpe'ilelaat ilan ri seniin ne ikapen giin. ");
INSERT INTO stb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Inuwiran ni Jesus su getaw buta bu' inagaken giin pegawas tu seg baryu. Dluwaten dula'ay su ngang mata nu getaw, bu' dinepenaan giin bu' miksaak ri seniin “Duun baing mi'ita' mu?” ");
INSERT INTO stb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Migangag su getaw bu' miktalu', “Wa'a, mi'ita'u su nga getaw, ma'ad maa' ilan ne nga gayu neng minlaanglaang.” ");
INSERT INTO stb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dinepenan puli' ni Jesus sung mata nu getaw. Sek panahun ketu, tinumenteng su getaw, bu' mi'uli'an su ngang mataan, bu' mekelaruun na su dlaun ne ngag betang. ");
INSERT INTO stb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pipe'uli' rayun giin ni Jesus bu' pimendu'aan, “Ndi'a na puli' ritu seg baryu.” ");
INSERT INTO stb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Si Jesus bu' su ngak tinu'unaan miritu se ngag binaryuwan neng megaud se Cesarea Filipos. Sed diin ilan pa se dlaangan, miksaak giin tu senilan, “Telu'ay niyau, ta' getawu ma laung nu nga getaw?” ");
INSERT INTO stb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“Sud duma miktalu' dya'a raw si Juan neng Membebendyag,” miksembag ilan; “sud duma miktalu' dya'a raw si Elias, saanay sud duma rema miktalu' ne dya'a raw sala se ngak Propeta.” ");
INSERT INTO stb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Ma'ad gamu?” miksaak giin tu senilan, “ta' getawu ma?” Miksembag si Pedro, “Dya'a sung Misiyas.” ");
INSERT INTO stb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mbuus mimandu' si Jesus tu senilan, “Ndi' niyu tabal tu se isan ta' sung metendeng ri senaan.” ");
INSERT INTO stb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Rayun migatad si Jesus sek pektendu' tu se ngak tinu'unaan: “Sug Bata' ne Getaw kina'enlan megantus seng melaun ne ngak pegantus bu' bibain ne nga geseg ne ngag Judeo, se nga geseg ne ngak pari', bu' se ngang mentetendu' ri se Kesuguan. Bu' petain gaid giin, ma'ad dluwat sek telu endaw metubu' giin puli'.” ");
INSERT INTO stb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Inasuy ini ni Jesus tu se ngak tinu'unan se genda'i dlepedleped. Aas inuwit giin ni Pedro tu se geksid bu' migatad sek pekpemaag ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma'ad tinumeliyud si Jesus bu' migenleng giin tu se ngak tinu'unaan, bu' pimaagen si Pedro. “Pelayu'a ri senaan Satanas,” miktalu' giin. “Su gena'ena' mu gena' buwat ri sed Diwata ma'ad buwat ri se getaw.” ");
INSERT INTO stb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mbuus tinawag ni Jesus su nga getaw bu' su ngak tinu'unaan tu seniin. “Bu' isan ta' ri seniyu ne dliyagaan meksunud ri senaan,” miktalu' giin tu senilan, “Kina'enlan teliyuran niyu su gegulingen niyu, pisaanen niyu su krus niyu, bu' sunud amu ri senaan. ");
INSERT INTO stb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ay bu' liyagan mu luwasen su gegulingen mu ne ketubu' merela'an'a run nini; ma'ad bu' merela'an'a se ketubu' mu tendeng ri senaan bu' seng Melengas ne Gesuyen, medluwas'a run nini. ");
INSERT INTO stb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Duun baing me'uwan mu bu' me'angken mu su dlaun ne ngag betang rini seg benwa, ma'ad merala' seni'a su ketubu' mu? Nda'irun gaid! ");
INSERT INTO stb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nda'iruni mbegay mu arun me'uwan mu puli' su ketubu' mu. ");
INSERT INTO stb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bu' mpiid amu run ri senaan bu' ri se ngak penendu'an'u ri se gena' diyusnun bu' mekesesala' ne nga getaw se gendaw keni, rayun sug Bata' ne Getaw mpiid rema metendeng seniyu sek pekpuli'en mbuus neng meddelaag se ga'em buwat se Gama'en duma se ngag bala'an ne ngag anghel.” ");
INSERT INTO stb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mbuus miktalu' giin tu senilan, “Esuyan'u amu, duunik santa' tawan rini ne ndi' matay tampan me'ita' nilan suk pedlegari' nud Diwata neng mateng duma se kega'em.” ");
INSERT INTO stb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Dluwat se genem endaw, inuwit ni Jesus, gilan si Pedro, Santiago, bu' si Juan, bu' tinumuwad ilan tu seng metaas neg bentud ne gilanilan ra. Bu' saanay migenleng ilan ri ni Jesus mi'eseb su gawi'en, ");
INSERT INTO stb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","bu' suk suuben sinumanag seng melebiyan ne keputi' ne nda'iruni isan ta' rini seg benwa ne gemputi' kampun sinangkali' itu. ");
INSERT INTO stb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Rayun suk telu ne ngak tinu'unan mikiita' ri ni Elias bu' ni Moses, neng miktuntul duma ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Miktalu' si Pedro tu ni Jesus, “Sir, melengas gaid ne rini ami. Megbaal ami nek telu buuk ne nga dlekaw, sala para seni'a, sala para se ni Moses, bu' sala para se ni Elias.” ");
INSERT INTO stb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Giin bu' su ngad duma mi'endekan gupiya ne nda' mekesuun bu' landunik telu'enen. ");
INSERT INTO stb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mbuus duuning mituwa' ne ginanud bu' tinumeklem ini ri senilan, bu' duunik talu' buwat tu se ginanud neng miktalu', “Giin nini sug Bata'u nek pinetail'u! Penginengegay niyu giin.” ");
INSERT INTO stb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sek tikmal, ali' ilan pegenleng tu sek timala', nda' irun naing mi'ita' nilan gawas ri ni Jesus duma senilan. ");
INSERT INTO stb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sek peddiksun nilan buwat seg bentud, si Jesus mimandu' senilan, “Ndi' niyu pengasuy tu se isan ta' sung mi'ita' niyu, tampan sug Bata' ne Getaw metubu' na puli' buwat se kemetain.” ");
INSERT INTO stb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tinuman nilan sung mandu'en, ma'ad ri se gegulingen nilan mismu migatad ilan sek pegaddat sek tinalu'en, “Landun mai gulugaaning ‘metubu' puli'’ buwat se kemetain?” ");
INSERT INTO stb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bu' miksaak ilan tu ni Jesus, “Tuma ma su ngang mentetendu' se Kesugu'an miktalu' ma ne si Elias giin sung meguna merini?” ");
INSERT INTO stb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Miksembag giin, “Si Elias sung meguna merini arun sek pegandam se dlaun ne ngag betang. Ma'ad tuma ma misulat ma ri se Kesulatan ne sug Bata' ne Getaw kina'enlan gaid megantus gupiya bu' bibain? ");
INSERT INTO stb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Esuyan'u amu ne si Elias minateng na, bu' binaal na ne nga getaw tu seniin sung mekepedleliyag ri senilan, sek tinalu' se Kesulatan metendeng ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sek pekpuli' na nilan tu sed duma ne ngak tinu'unan, mi'ita' nilan su gembagel nek panen ne nga getaw midlibut tu senilan bu' sud duma ne ngang mentetendu' se Kesugu'an neng mikpegaddat duma senilan. ");
INSERT INTO stb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sek pekiita' ne nga getaw riin ni Jesus, mitingala ilan gupiya bu' minggebek ilan pagaw tu seniin arun alimba'en giin. ");
INSERT INTO stb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Miksaak si Jesus tu se ngak tinu'unaan, “Landun ma suk pigaddat niyu duma senilan?” ");
INSERT INTO stb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Miksembag suk sala se nga getaw ritu, “Sir, inuwit'u sug bata'u riin seni'a, tendeng ay sineleran giin neng melaat ne gispiritu neng mikepebaal seniin ne ndi' mekegabit. ");
INSERT INTO stb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sek panahun nek sineleran giin seng melaat ne gispiritu, limbagenen giin riin se dlupa'an, mbuus megbula'bula' sug baba'en, mengkiget su ngang ngisiin, bu' menekeg giin. Inandyu'u su ngak tinu'unan mu nek peguwasen nilan sung melaat ne gispiritu ma'ad ndi' nilan mbaal.” ");
INSERT INTO stb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Miktalu' si Jesus tu senilan, “Gamu ne nga getaw ne nda'irunik pektu'uun! Gendun pa ba ketaas suk panahun ne gaku' kina'enlan mekengel duma seniyu? Gendun pa ba ketaas suk panahun suk pekpelugbak'u ri seniyu? Uwit niyu rini senaanig bata' dlai kiin.” ");
INSERT INTO stb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Inuwit nilan sug bata' tu ni Jesus. Sek pekiita' run nung melaat ne gispiritu riin ni Jesus, pipengeyegen rayun sug bata', bu' mibuksak ini tu se dlupa'an, bu' midlulidlulid neng mikpegbula' sug baba'en. ");
INSERT INTO stb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Gendun na kepayat giin neng maa' nini?” miksaak si Jesus tu se gama'. “Buwat seg bata' pa giin,” miksembag giin. ");
INSERT INTO stb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Melaun na nek panahun ne sung melaat ne gispiritu neng migindan mekpatay ri seniin pebiyan sek pektikpu' ri seniin ri se gapuy bu' riin sek tubig. Melelaat'a senami bu' ebangay mu ami, bu' mbaal mu!” ");
INSERT INTO stb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Wa'a,” miktalu' si Jesus, “bu' dya'a se gegulingen mu mismu mbaal! Su dlaun neg betang mbaal para tu se getaw ned duunik pektu'uun.” ");
INSERT INTO stb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Rayun, su gama' nug bata' dlai migbeksay, “Duunik pektu'uu ma'ad kulang. Ebangay mau neng meddugang suk peksalig'u.” ");
INSERT INTO stb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Bu' sek pekiita' run ni Jesus ne suk panen ne nga getaw miisel na tu senilan, pimaagen sung melaat ne gispiritu. “Bengel bu' gugel ne gispiritu,” miktalu' giin, “miksugu'u seni'a sek pegawas ri seg bata' dlai kiin bu' ndi'a na sumeled puli' ri seniin!” ");
INSERT INTO stb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Migbeksay sung melaat ne gispiritu, bu' pipengeyegen gupiya sug bata', bu' ginumawas ini. Sug bata' dlai bu' enlengan maa' na neng minatay, bu' suk salasala miktalu', “Minatay na giin!” ");
INSERT INTO stb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma'ad inuwiran ni Jesus su gemegen bu' binuwaten nini, bu' migindeg giin. ");
INSERT INTO stb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bu' seng mikeseled na si Jesus tu seg balay, su ngak tinu'unaan miksaak ri seniin ne gilanilan ra, “Tuma ma ndi' ami ma mekepegawas seng melaat ne gispiritu?” ");
INSERT INTO stb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","“Suk pegampu' ra giin sung mekepegawas seng maa' nini ne kelasi neng melaat ne gispiritu,” miksembag si Jesus; “nda'iruni dlain.” ");
INSERT INTO stb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Si Jesus bu' su ngak tinu'unaan migawa' tu se dlugar ketu bu' minetas ilan tu se Galilea. Si Jesus ndi'en liyagan ned duuning mekesuun bu' ta' giin, ");
INSERT INTO stb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tendeng ay tinendu'aan su ngak tinu'unaan: “Sug Bata' ne Getaw piyal na tu se ngang mekpatay ri seniin. Ma'ad dluwat sek telu endaw metubu' giin puli'.” ");
INSERT INTO stb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma'ad nda' ilan mekesabut bu' landuni gulugan sek tinendu'en, bu' minendek ilan sek peksaak ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bu' minateng ilan tu se Capernaum. Bu' seng mikeseled ilan na tu seg balay, miksaak si Jesus tu se ngak tinu'unaan, “Lama run maik pigeddatan niyu tu sed dalan?” ");
INSERT INTO stb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma'ad nda' ilan peksembag ri seniin, tendeng ay se dlaangan ilan pa, migaddat ilan ma bu' ta' su dlabaw gupiya ri senilan. ");
INSERT INTO stb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mbuus migingkud si Jesus, bu' pipegauren suk sepulu' bu' ruwa' ne ngak tinu'unaan, bu' tinelu'aan ilan, “Isan ta' seniyu ne dliyagaan ne mbaal ne dlabaw, kina'enlan mekpebaba' giin bu' mbaal nek sesugu'en ne dlaunan.” ");
INSERT INTO stb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Rayun minuwan giin neg bata' bu' pi'indegen nini riin seng metungenga'an nilan. Dinilangen sug bata' bu' miktalu' giin tu senilan, ");
INSERT INTO stb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Isan ta' sud dumawat pebiyan ri se ngalan'u sek sala se nga gembata' keni, dinumawat ri senaan; bu' isan ta' sud dumawat ri senaan, dinumawat gena' na run ri senaan ma'ad riin rema sek sala neng miksugu' ri senaan.” ");
INSERT INTO stb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Miktalu' seniin si Juan, “Sir, mikiita' ami ne getaw neng mikpegawas ne ngak penulay ginamiten sung ngalan mu, bu' inesuyan nami nek peleliyaan tendeng ay gena' giin sakup se dlumpuk ta.” ");
INSERT INTO stb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“Ndi' niyu giin belebagay,” miktalu' si Jesus tu senilan, “tendeng ay nda'iruning mekegbaal neng milagru pebiyan se ngalan'u, peketubus mektalu' rayun neng melaat metendeng ri senaan. ");
INSERT INTO stb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ay su isan ta' ne gendi' kumuntra senita giin sud dumapig senita. ");
INSERT INTO stb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ay telu'an'u amu seng metuud, isan ta' neng mekpe'inum seniyu nek tubig, tendeng ay misakup amu riin senaan, mekerawat gaid giin ne ganti.” ");
INSERT INTO stb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Bu' isan ta' seniyu ne mbaal ne getaran sek pekpekesala' sek sala ne ngang mekiika' ne nga gembata' keni neng mektu'u ri senaan, melengas pa para se getaw ketu neg bitinan ne gembagel neg batu ne dligisan su dliigen bu' tikpu'en giin tu sed dagat. ");
INSERT INTO stb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Aas bu' su gemeg mu mbaal neng mekeperala' ri sek pektu'u mu, petel mu ini! Ay melengas pa kampuun nek sumeled'a ri se ketubu' ne nda'iruni gemeg mu sinangkali' ned duwa' su gemeg mu ma'ad tikpu'en'a se gimpirnu, su gapuy ne ndi' gaid mpaleng. ");
INSERT INTO stb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Bu' suk sala ne geksud mu mbaal neng mekeperala' sek pektu'u mu, petel mu ini! Ay melengas pa para seni'a nek sumeled'a se ketubu' nek sala rai geksud mu sinangkali' se kumplitu su nga geksud mu ma'ad tikpu'en'a tu se gimpirnu. ");
INSERT INTO stb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bu' suk sala neng mata mu mbaal neng mekeperala' sek pektu'u mu, esuk mu ini! Ay melengas pa para seni'a nek sumeled sek pedlegeri'an ned Diwata nek sala raing mata mu sinangkali' se kumplitu su ngang mata mu, ma'ad pidlaken'a tu se gimpirnu. ");
INSERT INTO stb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ritu ‘su nga guled neng maan senilan ndi' matay, bu' su gapuy neng meksereng senilan ndi' mpaleng.’” ");
INSERT INTO stb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tendeng ay suk salasala tilengen pebiyan se gapuy maa' ned dulang nek tilengen pebiyan seng maasin.” ");
INSERT INTO stb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sung maasin melengas, ma'ad bu' merela'an na ini se kepaiten pegendunen mu pa run sek pekpepuli' su kepaiten?” “Pegangken amu neng maasin neng mekegbegay neng melengas nek pekpensambat bu' pedleketubu' amu riin se kelinaw duma sek salasala seniyu.” ");
INSERT INTO stb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mbuus migawa' si Jesus se dlugar ketu, miritu giin sek probinsiya seg Judea, bu' dinumipag tu seg Bagel tubig Jordan. Su gembagel nek panen ne nga getaw midlumpuk tu seniin puli', bu' tinendu'aan ilan sumala' seng mi'enaraan neg baalen. ");
INSERT INTO stb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bu' sud duma ne ngak Pariseo miritu arun sek pegindan ri ni Jesus, “Telu'ay mu ami,” miksaak ilan, “miktugut ba su Kesugu'an ta tu se isan ta' neng megbeleng ri sek sawaan?” ");
INSERT INTO stb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Miksembag si Jesus duma sek saak, “Lama run maik sinugu' ni Moses riin seniyu?” ");
INSERT INTO stb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Miksembag ilan, “Si Moses miktugut ri seg bana sek peksulat para sek pegbeleng bu' rayun belengenen suk sawaan.” ");
INSERT INTO stb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Miktalu' si Jesus tu senilan, “Sinulat ni Moses sugu' keni para riin seniyu tendeng ay melised amu gupiya tendu'an. ");
INSERT INTO stb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma'ad se getaran, sek panahun sek pegbaal runig benwa, ‘Sud Diwata migbaal senilan ne dlai bu' dlibun,’ sumala' sek tinalu' ri se kesulatan. ");
INSERT INTO stb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Bu' tendeng run nini ne keterengan megawa' su dlai tu se gama'en bu' gina'en bu' sumalabuuk ri sek sawaan, ");
INSERT INTO stb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","bu' sud duwa' mbaal na nek sala.’ Aas gena' ilan na duwa', ma'ad sala na. ");
INSERT INTO stb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aas landun suk sinalabuuk ned Diwata, kina'enlan ndi' pegbelengen ne getaw.” ");
INSERT INTO stb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Seng mipuli' ilan tu seg balay, su ngak tinu'unaan miksaak tu ni Jesus metendeng se ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Miktalu' giin tu senilan, “Sug bana neng meleng tu sek sawaan bu' mengesawa se dlain ne dlibun mekepenapaw tu sek sawaan. ");
INSERT INTO stb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Seng maa' run rema nek pebiyan, su dlibun neng meleng ri seg banaan bu' memana se dlain ne dlai mekepenapaw rema.” ");
INSERT INTO stb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bu' sud duma ne nga getaw miguwit ne nga gembata' tu ni Jesus arun depenaan ilan, ma'ad pimaag nu ngak tinu'unaan su nga getaw. ");
INSERT INTO stb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sek pekiita' run nini ni Jesus, linengetan giin bu' miktalu' tu se ngak tinu'unaan, “Tugutay niyu su nga gembata' neng mekepegaud ri senaan, bu' ndi' niyu ilan pegengay, tendeng ay sung maa' senilan misakup sek pedlegeri'an ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sek pekemetuud esuyan'u amu, isan ta' ne ndi' dumawat sek Pedlegeri'an ned Diwata maa' sek peddawat neng miika' neg bata' keni, ndi' gaid mekeseled tu sek Pedlegeri'an ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mbuus pinsipiten su nga gembata' bu' dinepenaan suk salasala senilan, bu' pingumpiyanaan ilan. ");
INSERT INTO stb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bu' seng medlaang na puli' si Jesus, duunik sala tawan ne ginumebek tu seniin, minginlulud ri seng metungenga'aan, bu' miksaak seniin, “Melengas neng Mentetendu', lama run mai kina'enlan'u baalen arun mekaangkenu se ketubu' ne genda'i gekteben?” ");
INSERT INTO stb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Tuma ma tuwagen mau ma neng melengas?” miksaak si Jesus ri seniin. “Nda'iruni isan sala neng melengas gawas sed Diwata ra. ");
INSERT INTO stb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Misuunan mu su nga kesugu'an: ‘Ndi'a mekpatay; ndi'a menapaw, ndi'a meddaaw, ndi'a mekpemetuud tu se isan ta' neg balus, ndi'a menlimbung, pegbesaan mu su gama' mu bu' gina' mu.’” ");
INSERT INTO stb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Sir,” miktalu' su getaw, “Gatad pa sek pekebegumbata'u tinuman'u na su dlaun ne nga kesugu'an keni.” ");
INSERT INTO stb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tinenteng giin ni Jesus duma sek pekpetail bu' miktalu', “Duun paik sala neg betang ne kina'enlan mu baalen. Dlaang'a bu' beledya' mu su dlaun ne nga ketigeyunan mu bu' su galinen pembegay mu tu se ngak pupus, bu' duuni ketigeyunan mu tu se dlangit; rayun puli'a rini bu' sunud'a ri senaan.” ");
INSERT INTO stb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sek pekerengeg run nini nu getaw migu'ul gaid giin, bu' midlaang tendeng ay meratu' ma giin gupiya. ");
INSERT INTO stb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bu' migenleng si Jesus tu sek timala' bu' miktalu' tu se ngak tinu'unaan, “Pekelised gaid para se ngang meratu' ne nga getaw sek pekseled tu sek Pedlegeri'an ned Diwata!” ");
INSERT INTO stb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mitingkangan gupiya su ngak tinu'unan ri sek tinalu'en, ma'ad mikpeddayun si Jesus sek pektalu', “Nga gembata'u, melised gaid suk pekseled tu sek Pedlegeri'an ned Diwata! ");
INSERT INTO stb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mesayun pa kampuun suk pekseled ne kamelyo riin se dluwang nek tai' sinangkali' sek pekseled seng meratu' tu sek Pedlegeri'an ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mitingala gupiya su ngak tinu'unan bu' miksesaakay ri sek salasala senilan, “Bu' maa' niin, ta' ma rayuning meluwas?” ");
INSERT INTO stb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tinenteng ilan ni Jesus bu' miksembag, “Ndi' ini mbaal ne getaw ma'ad mbaal ini ned Diwata; tendeng ay mbaalen su dlaun ne ngag betang.” ");
INSERT INTO stb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Rayun miktalu' si Pedro, “Enlengay mu, bineleng nami su dlaun ne ngag betang bu' sinumunud ri seni'a.” ");
INSERT INTO stb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Wa'a,” miktalu' si Jesus tu senilan, “bu' esuyan'u amu, su nga getaw ketu neng megbeleng ri seg balain awas ngak pateren ne nga dlai awas sek pateren ne nga dlibun awas se gina'en awas se gama'en awas se nga gembata'en awas se ngag binaalen para senaan bu' para seng Melengas ne Gesuyen, ");
INSERT INTO stb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mekerawat neng melaun gupiya sek panahun keni. Mekerawat neng megatus pilu' dugang ne ngag balay, ngak pated ne dlai, ngak pated ne dlibun, nga gina', nga gembata', bu' ngag binaal, bu' duma na su ngak pedlutus; bu' seng mateng nek panahun mekerawat ilan ne ketubu' ne genda'i gekteben. ");
INSERT INTO stb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma'ad melaun nemuun sung miguna ne mbinai' bu' melaun nemuun sung mibinai' neng meguna.” ");
INSERT INTO stb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Si Jesus bu' su ngak tinu'unaan tinumuwad pagaw tu seg Jerusalem. Miguna si Jesus ri se ngak tinu'unan neng mitingala ilan gupiya; bu' minendek sud duma ne nga getaw neng miksunud ri seniin. Pinainen puli' su ngak tinu'unaan bu' tinelu'aan se ngag betang neng mehitabu' ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Penginengeg amu,” miktalu' giin tu senilan, “mikpektuwad ita na pagaw tu seg Jerusalem, ne ritu piyal sug Bata' ne Getaw tu se nga geseg ne ngak pari' bu' se ngang mentetendu' se nga Kesugu'an. Ukuman nilan giin nek petain bu' rayun piyal nilan giin tu se nga gena' Judeo, ");
INSERT INTO stb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","neng meddega'rega' riin seniin, dula'an giin, latiguun giin, bu' petain giin; ma'ad se ketelu endaw, metubu' giin puli'.” ");
INSERT INTO stb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Rayun si Santiago bu' si Juan, nga gembata' ni Zebedeo, miritu ni Jesus. “Sir,” miktalu' ilan, “duunig betang ne dliyagan nami neg baalen mu para senami.” ");
INSERT INTO stb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Landun main?” miksaak si Jesus tu senilan. ");
INSERT INTO stb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Miksembag ilan, “Seng mekegingkud'a na tu sek trunu mu ne ritua medlegari' sek pedlegeri'an mu, tugutay mu ami sek pegingkud duma seni'a, suk sala diin rapit se dlintu mu bu' suk sala diin rapit seg bibang mu.” ");
INSERT INTO stb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Miktalu' si Jesus tu senilan, “Nda' niyu mesuunay bu' landunik pinengi niyu. Megenep ba niyu su ngak pegantus ne kina'enlan'u entusen? Bu' megenep ba niyu su nga keliseran ne mbiyanan'u?” ");
INSERT INTO stb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Wa'a” miksembag ilan. Miktalu' si Jesus tu senilan, “Mekegenep amu gaid se ngak pegantus bu' se nga keliseran ne mbiyanan'u. ");
INSERT INTO stb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma'ad nda'iruni ketenged'u sek pekpili' bu' ta' sung megingkud ri sed dapit dlintuu bu' sed dapit bibang'u. Sud Diwata raing megbegay se nga dlugar keni tu se nga getaw ne ginendamaan run nini.” ");
INSERT INTO stb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bu' seng mirengeg nuk sepulu' tawan ne ngak tinu'unaan, misepek ilan tu ni Santiago bu' ni Juan. ");
INSERT INTO stb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Aas tinawag ni Jesus su dlaun ne ngak tinu'unaan tu seniin bu' miktalu', “Misuunan niyu ne su nga geseg ne nga gena' Judeo, duuni kega'em nilan sek pedlegeseg tu se ngak sakup nilan, bu' gilan sung megbe'et bu' landunig baalen nilan. ");
INSERT INTO stb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tumu', gena' maa' nini su gembaya' seniyu. Ma'ad isan ta' ne dliyagaan ne mbaal ne dlabaw ri seniyu, mbaal giin nek sesugu'en niyu; ");
INSERT INTO stb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Bu' isan ta' seniyu ne dliyagaan ne mbaal ne geseg, kina'enlan ne mbaal giin ne gulipen se dlaunan. ");
INSERT INTO stb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ay isan sug Bata' ne Getaw, nda' perini arun ketaan; mirini giin sek pedlekata bu' sek pegbegay se ketubu'en sek pedlekat seng melaun ne nga getaw.” ");
INSERT INTO stb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Minateng ilan tu seg Jerico, bu' seng medlaang na si Jesus duma se ngak tinu'unaan bu' su gembagel nek panen ne nga getaw, duunig buta neng mekelelimus ne su ngalanen si Bartimeo, bata' ni Timeo neng mikpegingkud riin se geksid ned dalan. ");
INSERT INTO stb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sek pekerengegen run ne giin itu si Jesus nek taga Nazaret, migbeksay giin, “Jesus, Bata' ni David! lelaatay mau!” ");
INSERT INTO stb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Melaun ne nga getaw sung mimaag ri seniin bu' miktalu' tu seniin ne ndi' meksasak, ma'ad miksamet na tumu' giin megbeksay, “Bata' ni David, lelaatay mau!” ");
INSERT INTO stb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mikeneng si Jesus bu' miktalu', “Tawag niyu giin.” Aas tinawag nilan su getaw neg buta. “Pedleliyag'a!” miktalu' ilan. “Pegbuwat'a, miktawag giin seni'a.” ");
INSERT INTO stb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aas pinidlaken su dlambungen, linumeksu giin bu' miritu ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Landun mai dliyagan mu neg baalen'u ri seni'a?” miksaak si Jesus ri seniin. “Sir,” miksembag su getaw neg buta, “Liyagan'u neng mekiita'u puli'.” ");
INSERT INTO stb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Dlaang'a,” miktalu' si Jesus tu seniin. “Suk pektu'u mu giin sung mikepetelen seni'a.” Rayun mikiita' na giin bu' sinumunud ri ni Jesus ri sed dalan. ");
INSERT INTO stb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Megaud ilan na ni Jesus mateng tu seg Jerusalem. Minateng ilan tu se nga dlunsud neg Betfage bu' Betania neng megaud seg Bentud se ngag Olibo. Mbuus sinugu' ni Jesus sud duwa' tawan ne ngak tinu'unaan neng meguna ritu ");
INSERT INTO stb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","duma se ngak pemandu': “Peritu amu sek sunud neg baryu. Sek pekseled niyu ritu, me'ita' niyu suk salabuuk neng nati ne gasnu ne giniketan ne nda' pa mayan mesekayay. Ekasay niyu bu' uwit niyu rini. ");
INSERT INTO stb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bu' duuning meksaak ri seniyu, ‘Tuma ma ekasen niyu sung nati ne gasnu?’ telu'ay niyu giin, ‘Midlekina'enlan run nini su Gegalen bu' uli' ra ini sempun.’” ");
INSERT INTO stb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aas miritu ilan bu' mi'ita' nilan sung nati ne gasnu ned diin se geksid ned dalan ne giniketan riin sed dungawan neg balay. Saanay inekasan nilan nini, ");
INSERT INTO stb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","sud duma ne nga getaw neng mikpegindeg ritu miksaak senilan, “Lama run maig binaal niyu kiin, inekasan ma niyu nati ne gasnu kiin?” ");
INSERT INTO stb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Miksembag ilan sumala' se ginasuy ni Jesus ri senilan, bu' pilaang ilan nu nga getaw. ");
INSERT INTO stb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bu' inuwit nilan sung nati ne gasnu tu ni Jesus, bu' inenigan nilan nini ne nga dlambung nilan bu' sinekayan ini ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Melaun ne nga getaw neng migbeklat se nga dlambung nilan ri sed dalan, saanay sud duma mikpemetel ne ngak panga tu seg binaal bu' binetang nilan tu sed dalan. ");
INSERT INTO stb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Su nga getaw ned ditu se gunaan ni Jesus bu' sung miksunud ri seniin migatad megbeksay, “Siya'en ta sud Diwata! Pengumpiyanan giin ned Diwata neng mirini se ngalan ne Ginu'u. ");
INSERT INTO stb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pengumpiyanan ned Diwata sung mateng nek Pedlegeri'an nu gama' ta, ne si Gari' David! Siya'en ta sud Diwata!” ");
INSERT INTO stb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sek peddateng ni Jesus tu seg Jerusalem, sinumeled giin tu sek Templo, bu' inenlengaan su dlaun ne ngag betang riin sek timala'. Ma'ad tendeng ay delabung na, miritu giin seg Betania duma sek sepulu' bu' ruwa' ne ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sek pekesunud gendaw, seng mipuli' ilan buwat seg Betania, miperii' si Jesus. ");
INSERT INTO stb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Seng melayu'layu', mi'ita'en su gayu neg igira neng melabungid daunen, aas miritu giin arun enlengaan bu' duun baig bungaan nini. Ma'ad sek pekerepeten ritu, nda'iruning mi'ita'en neg bungaan gawas seng melabung ned daunen, tendeng ay gena' pa nek panahun sek pekpemunga. ");
INSERT INTO stb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Miktalu' si Jesus se gayu neg igira, “Nda'irun na isan sala neng mekekaan puli' seg bunga neg buwat ri seni'a!” Bu' su ngak tinu'unaan mikerengeg ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sek peddateng nilan tu seg Jerusalem, sinumeled si Jesus tu sek Templo bu' migatad sek pegaleg se ngang mimenaluy bu' se ngang mimeledya'. Pinlintuwaren su nga dlemisan nu ngang menteteles ne ngak selapi' bu' su ngak pimetangan ne ngang mimeledya' ne ngak selepati. ");
INSERT INTO stb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Bu' nda'en tugutay su nga getaw sek peguwit isan landun neng miyan tu se dlenu'an nek Templo. ");
INSERT INTO stb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tinendu'aan rayun su nga getaw: “Misulat ini ri se Kesulatan neng miktalu' sud Diwata, ‘Suk Templo naku' ingelanan neg balay sek pegampu' para se nga getaw se dlaun ne ngang nasud.’ Ma'ad binaal niyu ini ne nga gedluran ne ngak tulisan!” ");
INSERT INTO stb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Su nga geseg ne ngak pari' bu' su ngang mentetendu' se Kesugu'an mikerengeg run nini, aas migatad ilan sek pekpenengaw nek pebiyan sek pekpatay ri ni Jesus. Ma'ad minendek ilan ri seniin, tendeng ay su dlaun ne nga getaw mitingala sek pekpenendu'en. ");
INSERT INTO stb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sek pekegebii na, si Jesus bu' su ngak tinu'unaan migawa' tu sek siyudad. ");
INSERT INTO stb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sek pekesikanselem, sed diin ilan pa se dlaangan, mi'ita' nilan su gayu neg igira. Minatay ini tampan se gangeten. ");
INSERT INTO stb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mirelendeman ni Pedro bu' landun sung mihitabu' bu' miktalu' giin riin ni Jesus, “Sir, enlengay mu! Su gayu nek pinuyuran mu minatay na.” ");
INSERT INTO stb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Miksembag si Jesus tu senilan, “Tu'uway niyu sud Diwata. ");
INSERT INTO stb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sek pekemetuud esuyan'u amu, isan ta' sung mektalu' ri seg bentud keni nek pegawa'a rini bu' sampak'a tu sed dagat bu' nda' penduwa'ruwa' ri se gena'ena'en, ma'ad miktu'u ne suk tinalu'en mehitabu', metuman ini sumala' sek tinalu'en. ");
INSERT INTO stb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tendeng run nini, telu'an'u amu: Seng megampu' amu bu' menengi isan landun neg betang, tu'uway niyu neng mirawat na niyu, bu' begay seniyu landunik pinengi niyu. ");
INSERT INTO stb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Bu' seng megindeg amu bu' megampu', pasaylu niyu reli' sung mikesala' riin seniyu arun su ngak sala' niyu pasayluun rema se Gama' niyu tu se dlangit.” ");
INSERT INTO stb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Minateng ilan puli' tu seg Jerusalem. Seng midlaang si Jesus tu sek Templo, su geseg ne ngak pari', su ngang mentetendu' ri se Kesugu'an, bu' su nga geseg ne ngag Judeo mikpegaud ri seniin ");
INSERT INTO stb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bu' miksaak ilan ri seniin, “Landun mai ketenged mu sek pegbaal run ni ngag betang keni? Ta' maing migbegay ri seni'a ne ketenged?” ");
INSERT INTO stb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Miksembag si Jesus tu senilan, “Saakan'u amu nek sala na run nek saak, bu' mesembag niyu ini ri senaan, esuyan'u amu bu' landuni ketenged'u sek pegbaal runi ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Telu'ay niyau, ta' ma migbuwat su ketenged ni Juan sek pekpemendyag: buwat ba ini tu sed Diwata awas buwat se nga getaw?” ");
INSERT INTO stb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Migatad ilan megaddat sek salasala senilan: “Landun maik telu'en ta? Bu' meksembag ita, ‘Buwat sed Diwata’, mektalu' rayun giin, ‘Tuma ma nda' amu pektu'u riin ni Juan?’ ");
INSERT INTO stb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma'ad bu' mektalu' ita, ‘buwat ini se nga getaw...’ ” (Minendek ilan se nga getaw, tendeng ay suk salasala miktu'u ne si Juan metuud nek propeta.) ");
INSERT INTO stb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aas miksembag ilan tu ni Jesus, “Nda' nami mesuunay.” Miktalu' si Jesus tu senilan, “Bu' maa' niin, ndi'u amu rema esuyan bu' ta' migbuwat su ketenged'u sek pegbaal run nini.” ");
INSERT INTO stb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Rayun migasuy si Jesus tu senilan ne nga galing: “Duunik sala tawan neng mimula ne nga gubas, inalaren ini, midluwak giin para pega'an ne gubas bu' migbakud giin neng metaas nek pegelungan. Rayun pise'upaan su gubasan tu se ngak mensesa'up bu' migbiyahi giin. ");
INSERT INTO stb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sek panahun na sek pekpengupu' se nga gubas miksugu' giin ne gulipen tu se ngak sa'up sek peguwan se ngag bahinen buwat se ngag bunga ne gubas. ");
INSERT INTO stb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sek peddateng nu gulipen ritu, bininteng nu ngak sa'up, binentul nilan nini, bu' pipe'uli' giin ne genda'iruning mi'uwiten. ");
INSERT INTO stb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Rayun su gapu' ne gubasan miksugu' na pelun ne dlain ne gulipen ma'ad binentul nilan nini ri se gulu bu' pikpiid nilan. ");
INSERT INTO stb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Su gapu' ne gubasan miksugu' pa gaid ne dlain ne gulipen bu' pinatay nilan nini; bu' melaun pa ne nga gulipen nek sinugu' nu gapu' ne gubasan ma'ad sud duma binentul nilan bu' sud duma pimatay nilan. ");
INSERT INTO stb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sala ra run sung mibilin neng mesugu'en, suk pinetailen neg bata' ne dlai. Se ketapusan sinugu'en sug bata'en ne dlai tu se ngak sa'up. ‘Ay mikesiguruu nek pegbesaan ra gaid nilan sug bata'u,’ miktalu' giin. ");
INSERT INTO stb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ma'ad miktalu' suk salasala ne ngak sa'up, ‘Giin nini sug bata' ne gapu' ne gubasan. Dini amu, petain ta giin, bu' su gempenunuren nita na!’ ");
INSERT INTO stb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aas bininteng nilan sug bata'en ne dlai bu' pinatay nilan giin bu' pinidlak su dlawasen tu se gawas ne gubasan. ");
INSERT INTO stb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Landun rayun sakanig baalen nu gapu' ne gubasan?” miksaak si Jesus. “Meritu giin bu' pemetainen su ngak sa'up bu' begain su gubasan tu se dlain. ");
INSERT INTO stb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nda' amu ba mekebasa run nini riin se kesulatan? ‘Sug batu neg binibay nu ngak panday ne genda'ik paluun mibaal na tumu' ne dlabi ne gimpurtanti neg batu. ");
INSERT INTO stb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Su Ginu'u giin sung migbaal run nini; bu' ketingelaan gaid ini enlengan!’” ");
INSERT INTO stb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Su nga geseg ne ngag Judeo miktinguha' sek peddaap ri ni Jesus, tendeng ay misuunan nilan neng migasuy giin ne galing kuntra ri senilan. Ma'ad minendek ilan tu se nga getaw, aas pinenawan nilan giin bu' midlaang ilan. ");
INSERT INTO stb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Sud duma ne ngak Pariseo bu' duma ne ngak sakup se dlumpuk ni Herodes sinugu' nilan tu ni Jesus arun sek pegindan ri seniin pebiyan se ngak saak. ");
INSERT INTO stb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bu' miritu ilan seniin bu' miktalu', “Sir, misuunan nami neng mektabal'a seng metuud, nda' sepayan ri seni'a sung metendeng se ngak pengena'ena' nu nga getaw. Nda' mu pengebetay bu' landuni kebetang ne nga getaw, ma'ad miktendu'a se kemetuuran metendeng se keliyag ned Diwata para se nga getaw. Telu'ay mu ami supak ba se Kesugu'an neng megbayad neg buwis tu se goberno seg Roma? Megbayad ami ba tu senilan awas ndi'?” ");
INSERT INTO stb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma'ad misuunan ni Jesus ne inindanan nilan giin, bu' miksembag, “Tuma ma miktinguha' amu ma sek pegindan ri senaan? Uwitay niyau nek selapi' nek pelata bu' pe'ita' niyu ini ri senaan.” ");
INSERT INTO stb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Inuwitan nilan giin nek salabuuk nek selapi' nek pelata, bu' miksaak giin, “Ta' mulu' bu' ngalan run nini?” “Se Gari',” miksembag ilan. ");
INSERT INTO stb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Miktalu' si Jesus tu senilan, “Begay niyu tu se Gari' bu' landunik para se Gari' bu' begay niyu tu sed Diwata bu' landunik para sed Diwata.” Bu' mitingala ilan ri ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Rayun sud duma ne ngak Saduceo, ne gilan sung miktalu' ne su getaw ndi' metubu' puli' buwat se kemetain, miritu ni Jesus bu' miktalu', ");
INSERT INTO stb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Sir, si Moses miksulat sek sugu' keni para senita: ‘Bu' sug bana matay bu' mbilin suk sawaan ma'ad nda'irunig bata' nilan, kina'enlan suk pateren ne dlai mengesawa tu seg balu arun mekegbata' ilan ne ilelaan neg bata' nung minatay nek pateren.’ ");
INSERT INTO stb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Duunik pitu tawan ne nga dlai neng mekpated; su gulangbata' mingesawa bu' minatay ne genda'irunig bata' nilan. ");
INSERT INTO stb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Rayun su keruwa' nek pated mingesawa tu seg balu ne dlibun bu' minatay rema giin ne nda'irunig bata' nilan. Maa' ra run rema sung mihitabu' tu se ketelu nek pateren ne dlai, ");
INSERT INTO stb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","bu' rayun sud duma pa ne ngak pateren: su dlaun nek pitu tawan neng mekpated mikepengesawa tu se dlibun bu' mimatay ne nda'iruni gembata' nilan. Se ketapusan minatay sug balu ne dlibun. ");
INSERT INTO stb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na, bu' mateng na su gendaw sek pekpetubu' puli' se ngang mimatay, ta' ma nek sawa run giin? Ay suk pitu tawan mikepengesawa ma ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Miksembag si Jesus tu senilan, “Misayep amu gaid! Bu' misuunan ba niyu bu' tuma ma? Tendeng ay nda' niyu mesabut su Kesulatan awas su ga'em ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ay seng metubu' na puli' su ngang mimatay, maa' ilan na mbuus ne ngag anghel tu se dlangit bu' ndi' na sumuway. ");
INSERT INTO stb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na, metendeng sek peketubu' puli' nu ngang mimatay: nda' ba niyu ini mbesaay riin se Dlibru ni Moses neng miktalu' metendeng seng midliga' nek sebinit? Duuning misulat ne sud Diwata miktalu' tu ni Moses, ‘Gaku' sud Diwata ni Abraham, sud Diwata ni Isaac, bu' sud Diwata ni Jacob.’ ");
INSERT INTO stb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Giin sud Diwata ne ngang miktetubu', gena' se ngang mimatay. Misayep amu gaid gupiya!” ");
INSERT INTO stb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sala neng mentetendu' se Kesugu'an ned ditu neng mikerengeg sek pegaddat. Mi'ita'en neng melengas suk pekesembag ni Jesus sek saak nu ngak Saduceo, aas miritu giin seniin bu' miksaak, “Landun mai dlabi ne gimpurtanti se dlaun ne nga Kesugu'an?” ");
INSERT INTO stb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Miksembag si Jesus, “Suk sala ne dlabi ne gimpurtanti giin nini: ‘Penginengeg amu, ngak taga Israel, su Ginu'u ned Diwata ta, giin ra su Ginu'u. ");
INSERT INTO stb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Petail mu su Ginu'u ned Diwata mu, sek tibuuk nek pusung mu, sek tibuuk ne kalag mu, sek tibuuk ne gena'ena' mu, bu' sek tibuuk nek sekeg mu.’ ");
INSERT INTO stb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Su keruwa' ne dlabi ne gimpurtanti ne kesugu'an giin nini: ‘Petail mu suk sumbalay mu maa' sek pekpetail mu ri se gegulingen mu.’ Nda'irun nai dlain ne dlabi ne gimpurtanti ne kesugu'an gawas sed duwa' keni.” ");
INSERT INTO stb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sung mentetendu' se Kesugu'an miktalu' tu ni Jesus, “Gempiya pekebaal, Sir! Metuud gaid suk tinalu' mu, sala ra su Ginu'u ned Diwata bu' nda'irun nai dlain gawas seniin. ");
INSERT INTO stb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bu' kina'enlan petailen mu giin sek tibuuk nek pusung mu, sek tibuuk ne gena'ena' mu, bu' sek tibuuk nek sekeg mu; bu' suk pekpetail ri sek sumbalay maa' sek pekpetail ri se gegulingen mu. Labaw ne gimpurtanti suk pektuman sed duwa' ne nga kesugu'an keni sinangkali' sek peddulang neng menanap ri sek pengilakan bu' sed duma pa ne nga gilak tu sed Diwata.” ");
INSERT INTO stb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Bu' sek pekerengeg ni Jesus run neng melengas suk pekpenembagen, aas miktalu' giin tu seniin, “Gena'a neng melayu' buwat sek Pedlegeri'an ned Diwata.” Dluwat itu nda'irun naing mingatu sek peksaak ri ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sinegay ni Jesus mekpenendu' ritu sek seled nek Templo, miksaak giin, “Pigendun ne ngang mentetendu' se Kesugu'an sek pektalu' ne sung Misiyas gesalan ni David? ");
INSERT INTO stb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Si David mismu miktalu' pebiyan se Gispiritu Santu: ‘Su Ginu'u miktalu' tu se Ginu'uu: Gingkud'a riin sed dapit dlintuu tampan mbetang'u su nga kuntra mu riin sed diyalem ne ngak pelapa mu.’ ");
INSERT INTO stb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Si David mismu miktawag ri seniin ne ‘Ginu'u’; aas pegendunen run ne sung Misiyas mbaal ne gesalan ni David?” Su gembagel nek panen ne nga getaw pidleliyag menginengeg riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sek pekpenendu'en tu senilan, miktalu' giin, “Pekpetigaam amu ri se ngang mentetendu' se Kesugu'an. Liyagan nilan neng mekpedlaang neng mekseluk neng meketaas ne ngak suub bu' pegbesaan riin se nga dlugar nek tipunganan. ");
INSERT INTO stb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pemili'en nilan su nga gingkuran para se ngak tinamed riin se ngak pektipungan ne nga getaw Judeo bu' ri se ngang melengas ne dlugar riin se nga kumbira. ");
INSERT INTO stb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Linupigan nilan su ngag balu ne dlibun bu' piddaaw nilan su nga ketigeyunan nilan riin se ngag balay nilan, bu' mekpe'ita'ita' ilan rayun seng metaas ne ngak pegampu'. Gilan keni mekerawat se gembagel nek silut!” ");
INSERT INTO stb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mbuus migingkud si Jesus tu seng megaud nek seleran ne ngak selapi' tu sek Templo, pini'iraan su nga getaw neng megbetang ne ngak selapi' nilan. Melauning meratu' ne nga getaw neng migbetang ne gembagel ne dlaga' nek selapi'. ");
INSERT INTO stb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bu' duunik pupus neg balu ne dlibun neng miritu bu' migbetang ned duwa' sinsilyu nek tumbaga, ne dlaga' sek sala sintabus. ");
INSERT INTO stb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tinawagen su ngak tinu'unaan tu seniin, bu' miktalu' giin tu senilan, “Telu'an'u amu balu ne dlibun kiin mikebetang ne dlabaw pa ne dlaga' nek selapi' sinangkali' tu se dlaun neng mimbetang. ");
INSERT INTO stb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tendeng ay sud duma neng mimbetang sawad na ne ngak petigayun nilan, ma'ad balu ne dlibun keni, isan se keliseren, binegain su dlaun neng niin nek pengetubu'aan.” ");
INSERT INTO stb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sek pegawas ni Jesus tu sek templo, sala se ngak tinu'unaan miktalu' tu seniin, “Sir, enlengay mu! Pekelengas gupiya se ngag batu bu' se ngag balay kiin!” ");
INSERT INTO stb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Miksembag si Jesus, “Mi'ita' mu ba ngang mekebagel ne ngag balay keni? Nda'irun isan sala se ngag batu keni ne mbilin ri seng mi'imetangaan iin; dlaunan keni megela' megeba'.” ");
INSERT INTO stb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Si Jesus mikpegingkud tu seg bentud ne ngag Olibo dipag nek Templo, saanay mikpegaud si Pedro, si Santiago, si Juan, bu' si Andres ri seniin ne gilanilan ra. ");
INSERT INTO stb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Miksaak ilan, “Esuyay mu ami, nanu ma ini mehitabu' bu' lama run mai gilelaan ne ngag betang keni neng megaud na gaid metuman?” ");
INSERT INTO stb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Miktalu' si Jesus tu senilan, “Pekpetigaam amu bu' ndi' niyu tugutay ned duuning medlimbung riin seniyu, ");
INSERT INTO stb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Melauning mateng ne gumamit ri se ngalan'u bu' mektalu' ilan, ‘Gaku' Giin!’ bu' melauni nga getaw neng melimbungan nilan. ");
INSERT INTO stb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma'ad bu' mekerengeg amu ned duuni nga gubat ri seng megaud bu' tu seng mekelayu' ne nga dlugar, ndi' amu mendek. Kina'enlan mehitabu'i ngag betang keni ma'ad gena' pa ini su ketapusan. ");
INSERT INTO stb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sung nasud gumubat tu se dlain neng nasud; bu' suk pedlegeri'an gumubat tu se dlain nek pedlegeri'an. Duuni nga dlinug se dlainlain ne nga dlugar bu' duuni nga gutem. Ngag betang keni getaran pa ma'ad maa' se nga guna ne kegeel sek pegbata'.” ");
INSERT INTO stb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Pegbantay amu ri se gegulingen niyu. Daapen amu bu' uwiten tu se gukuman. Bentulen amu tu sek pektipungan ne nga getaw Judeo; megindeg amu riin seng metungenga'an ne nga geseg bu' nga gari' tendeng ri senaan arun megasuy amu tu senilan se Gempiya ne Gesuyen. ");
INSERT INTO stb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma'ad se gendi' pa mateng su ketapusan, kina'enlan su Gempiya ne Gesuyen mpenintulu' tu se dlaun ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bu' sed daapen amu bu' uwiten tu se gukuman, ndi' amu megules mbuus metendeng se landunik telu'en niyu; seng mateng su guras, talu' niyu landunig binegay seniyu. Ay suk talu' nek tuntulen niyu gena' niyu; buwat ini se Gispiritu Santu. ");
INSERT INTO stb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Su nga dlai mekpiyal ri se ngak pated nilan arun petain, bu' su nga gama' maa' run rema sug baalen nilan tu se nga gembata' nilan. Su nga gembata' kumuntra riin se ngang megulang nilan bu' pepatay nilan nini. ");
INSERT INTO stb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bu' su kada getaw medlegemet ri seniyu tendeng ri senaan. Ma'ad su isan ta' sung mekepeddayun tampan se ketapusan meluwas. ");
INSERT INTO stb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Me'ita' niyu ‘Sung Mekeendekendek neng Meguwit ne Kelaatan’ neng megindeg ri sek Templo ne ndi' mbaya' run nini.” (Para tu se ngang membebasa: sebuten niyu bu' landuni gulugaan nini!) “Rayun su nga getaw ned diin seg Judea kina'enlan medlaguy tu se ngag binenturan. ");
INSERT INTO stb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bu' su ngad ditu sed dibabaw gatep neg balay ndi' na kina'enlan medlangan menaug arun sek peguwan isan landun ne ngag betang ritu seg balain. ");
INSERT INTO stb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bu' su ngad ditu seg binaal kina'enlan ndi' na muli' tu seg balain arun sek peguwan se dlambung. ");
INSERT INTO stb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Gendun gaid kelised su nga gendaw ketu para se nga dlibun neng megberes bu' para se nga gina' ned duuni ngang mekiika' ne nga gembata' nilan! ");
INSERT INTO stb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pegampu' amu tu sed Diwata ne su ngag betang keni ndi' mehitabu' sek timpu nek penteddaw. ");
INSERT INTO stb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ay su keliseran se gendaw ketu labi pa neng mekeendekendek sinangkali' se isan landun neng misegaran rini seg benwa gatad binaal ini ned Diwata tampan nemuun bu' ndi' na gaid melepengan isan nanu. ");
INSERT INTO stb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bu' nda' pa pebeba'ay ned Diwata su nga gendaw ketu, nda'iruning meluwas. Ma'ad para se ngak pimili'en ne nga getawan, pibaba'en su nga gendaw ketu.” ");
INSERT INTO stb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Rayun bu' isan ta' sung mektalu' seniyu, ‘Enlengay niyu, keni na sung Misiyas!’ awas, ‘Enlengay niyu, ritu giin!’ ndi' amu pektu'u run nini. ");
INSERT INTO stb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ay su gena' metuud ne ngang Misiyas bu' gena' metuud ne ngak propeta mekpe'ita'. Megbaal ilan ne nga ketingelaan bu' nga gilelaan arun sek pedlimbung se nga getaw nek pimili' ned Diwata, bu' mehimu. ");
INSERT INTO stb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aas pegbantay amu! Tinelu'an'u amu guna runi ngag betang keni se gendi' pa ini mehitabu'.” ");
INSERT INTO stb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Sek panahun ne dluwat su nga keliseran ketu, su gendaw meksirelem bu' sug bulan ndi' na meddelaag. ");
INSERT INTO stb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Su ngag bituun medladdu' buwat tu se dlangit bu' su nga kega'em tu se dlangit mbalag buwat seng mi'enaran nilan neg biyanan. ");
INSERT INTO stb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Rayun me'ita' niyu sug Bata' ne Getaw mateng riin se ginanud duma se gembagel ne kega'em nek sumanag. ");
INSERT INTO stb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sugu'enen su ngag anghel tu se nga gepaat ne ngak sinurungan neg benwa arun tipungen su nga getaw nek pimili' nud Diwata buwat se dlaun ne nga dlugar sek tibuuk neg benwa.” ");
INSERT INTO stb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Uwanay niyu nek penendu'an su gayu neg Igira. Seng mengumuk na su ngak pangaan nini bu' mengintubil na ini, mesuunan niyu neng megaud na memeres. ");
INSERT INTO stb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Maa' rema run nini, seng mi'ita' na niyu su ngag betang keni neng mekpenghitabu' na, mesuunan na niyu ne suk panahun megaud na, bu' andam na sek pegatad. ");
INSERT INTO stb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tima'anay niyu ini: dlaunan keni mehitabu' se ndi' pa matay su dlaun ne nga getaw neng miktetubu' pa nemuun. ");
INSERT INTO stb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Su dlangit bu' su dlupa' me'alep, ma'ad su ngak talu'u mekpebilin se genda'i gekteben.” ");
INSERT INTO stb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ma'ad ndi'iruni isan sala neng mikesuun se gendaw ketu awas se guras neng mateng, isan su ngag anghel tu se dlangit, awas sug Bata'; su Gama' ra giin sung mikesuun dun. ");
INSERT INTO stb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pegbantay amu, pengandam, ay nda' niyu mesunay suk panahun neng mateng. ");
INSERT INTO stb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Maa' ini nek sala tawan neng migbiyahi bu' binilinen tu se ngak sesugu'en suk pedlekata, tubusen begayay suk salasala senilan neg baalen nilan bu' tubusen telu'ay sug bantay ri sed dungawan neng megbantay. ");
INSERT INTO stb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Aas pegbantay amu tendeng ay nda' niyu mesuunay nanu mateng su gapu' neg balay ali' bu' ri se gebii awas sek titenga' ne gebii awas seng meguni su dlimensad, awas sed dali'endaw. ");
INSERT INTO stb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ali' bu' metikmal giin mateng, kina'enlan ndi' amu metaangan neng miktulug. ");
INSERT INTO stb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Landunik tinalu'u seniyu, tinalu'u ini rema tu se dlaunan neng megbantay amu.” ");
INSERT INTO stb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Duwa' endaw ra run se gendi' pa mateng su Kese'ulugan sek Paska bu' su Kese'ulugan sek Pan ne genda'ik Pempetulinen. Su nga geseg ne ngak pari' bu' su ngang mentetendu' se Kesugu'an minengaw ne ngak pema'agi sek peddaap riin ni Jesus ne genda'iruning mekesuun run arun petain giin. ");
INSERT INTO stb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Kina'enlan ndi' ta ini baalen sek panahun se Kese'ulugan,” miktalu' ilan, “ali' bu' megubet su nga getaw.” ");
INSERT INTO stb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na, si Jesus ritu seg Betania tu seg balay ni Simon, su getaw neng migantus buwat seng mekeendekendek ne dleruun ri sek panit. Saanay ni Jesus maan, duuni dlibun neng minateng, miguwit neng miika' ne gamang neg alabastro neng mipenu' neng melaga' gupiya nek pegemut binaal sek tantu neng nardo. Binuungen su gamang ketu bu' binunagen suk pegemut tu se gulu ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sud duma ne nga getaw ritu pinlengetan bu' miktalu' ri sek salasala senilan, “Tuma ma pikula'ula'an maik pegemut kiin? ");
INSERT INTO stb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mbeledya' ma iin se kapin sek telu gatus ne ngak selapi' nek pelata bu' suk selapi' begay tu se ngak pupus!” Bu' pimura gupiya nilan su dlibun. ");
INSERT INTO stb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma'ad miktalu' si Jesus, “Pesaddan niyu giin! Tuma ma semuken ma niyu giin? Migbaal giin neng melengas neg betang para ri senaan. ");
INSERT INTO stb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Su ngak pupus ne nga getaw kanunay ra nek sementaun niyu, bu' isan laa urasay run ne dliyagan niyu, mekegabang amu senilan. Ma'ad gena'u kanunay sementaun niyu. ");
INSERT INTO stb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Migbaal giin gekteb se gembaalen; migbunag giin nek pegemut riin se dlawas'u arun sek pengandam na daan para sek pedlebeng. ");
INSERT INTO stb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na, sek pekemetuud esuyan'u amu, se isan ta' penintulu' su Gempiya ne Gesuyen sek tibuuk neg benwa, sung mibaalen me'asuy gisip peddelendem ri seniin.” ");
INSERT INTO stb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Rayun si Judas Iscariote, sala sek sepulu' bu' ruwa' ne ngak tinu'unaan, miritu se geseg ne ngak pari' arun piyal si Jesus tu senilan. ");
INSERT INTO stb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pidleliyag ilan gupiya sek pekerengeg nilan runik tinalu'en bu' miksaad ilan sek pegbegay ri seniin nek selapi'. Aas si Judas migatad sek pekpenengaw ne ginsaktu nek panahun ne mpiyalen si Jesus tu senilan. ");
INSERT INTO stb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Se guna ne gendaw se Kese'ulugan sek Pan ne genda'ik Pempetulinen, giin su gendaw sek pekpatay se ngang nati ne karniru para dulang se Kese'ulugan sek Paska, miksaak su ngak tinu'unan ni Jesus ri seniin, “Ta' mai dlugar ne dliyagan mu lawan nami bu' mekegandam nek pekaan para se Kese'ulugan nek Paska?” ");
INSERT INTO stb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bu' sinugu' ni Jesus sud duwa' se ngak tinu'unaan bu' pimendu'aan ilan: “Peritu amu sek siyudad, bu' melabet niyu su getaw neng mikpisaan ne gamang nek sineleran nek tubig. Lendug niyu giin ");
INSERT INTO stb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","tu seg balay nek seleraan bu' telu'ay niyu su gapu' neg balay: ‘Sung Mentetendu' miktalu', Ta' maid dugu ne ritu maan su ngak tinu'unan'u bu' gaku' sek Pekse'ulug sek Paska?’ ");
INSERT INTO stb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Rayun pe'ita'en seniyu sung meliwag ned dugu tu sed ditaas, ned duun nai kegemitan run bu' pi'imetang na daan, bu' ritu amu mengandam para senita.” ");
INSERT INTO stb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Su ngak tinu'unan midlaang, miritu sek siyudad, bu' mi'ita' nilani ngag betang keni sumala' se ginasuy ni Jesus tu senilan; bu' inandam nilan suk penihapun para sek Paska. ");
INSERT INTO stb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Seng meksindep nai gendaw, minateng si Jesus duma sek sepulu' bu' ruwa' ne ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bu' saanay nilan mekaan riin se dlemisaan miktalu' si Jesus, “Esuyan'u amu nek sala seniyu megbudhi' ri senaan—sala ned dumengan maan ri senaan.” ");
INSERT INTO stb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tendeng run nini, migu'ul su ngak tinu'unaan bu' migatad meksaak ri seniin su kada sala ri senilan, “Gaku' ba suk pirengegan mu?” ");
INSERT INTO stb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Miksembag si Jesus, “Sala ri seniyu nek sepulu' bu' ruwa', suk sala neng medlebul sek panen ri se dya'ung duma senaan. ");
INSERT INTO stb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sug Bata' ne Getaw matay sumala' sek tinalu' se Kesulatan; ma'ad mekelelaatlelaat su getaw neng megbudhi' ri seg Bata' ne Getaw! Maneg pa na ma'ad para se getaw ketu ne nda' giin me'etaw!” ");
INSERT INTO stb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bu' saanay nilan mengaan, minuwan si Jesus nek pan, migampu' sek pekpesalamat, pinetapetaan nini, bu' binegain tu se ngak tinu'unaan, “Tabuk niyu ini, giin nini su dlawas'u.” ");
INSERT INTO stb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Rayun inuwanen su kupa bu' pisalamataan tu sed Diwata. Binegain nini tu se ngak tinu'unaan bu' dlaun nilan mininum buwat run nini. ");
INSERT INTO stb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Miktalu' si Jesus, “Giin nini sud dugu'u nek pikigis para se dlaunan, sud dugu'u giin sung miksilyu se keligenan ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Telu'an'u amu, “Ndi'u na minum puli' seg binu keni tampan se gendaw ne inumen'u sug begu neg binu riin sek Pedlegeri'an ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Rayun midlekanta ilan sek peksaya' ri sed Diwata bu' miritu ilan seg Bentud ne ngag Olibo. ");
INSERT INTO stb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Miktalu' si Jesus tu senilan, “Dlaunan niyu megela' menlaguy, bu' meleng ri senaan, ay su kesulatan miktalu', ‘Petain ned Diwata sung menggegingat ne nga karniru bu' su nga karniru metipelak.’ ");
INSERT INTO stb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma'ad dluwatu metubu' puli', megunau seniyu tu se Galilea.” ");
INSERT INTO stb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Si Pedro miktalu', “Ndi'u gaid meleng seni'a, isan belengen'a se dlaunan!” ");
INSERT INTO stb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Miksembag si Jesus, “Sek pekemetuud, telu'an'u dya'a, se ndi' pa meguni seng meruwa' su dlimensad se gebii keni, limeren mau seng metelu ne nda' mau me'ilala.” ");
INSERT INTO stb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma'ad minamal pa gaid si Pedro sek pektalu', “Ndi'u gaid mektalu' run niin, isan pa bu' petainu duma seni'a!” Bu' su dlaun ne ngak tinu'unan miktalu' rema neng maa'entu. ");
INSERT INTO stb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Miritu ilan se dlugar ne giningelanan ne Getsemane, bu' miktalu' si Jesus tu se ngak tinu'unaan, “Pengingkud amu rini saanay'u megampu'.” ");
INSERT INTO stb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pirunuten si Pedro, Santiago, bu' Juan ri seniin. Binatiken suk taud ne kegu'ul bu' kegules. ");
INSERT INTO stb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Bu' miktalu' giin tu senilan, “Su kegu'ul ri se gena'ena'u gembagel gaid gupiya neng manla'u matay run. Pebilin amu rini bu' pegbantay amu.” ");
INSERT INTO stb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Miritu giin seng melayu'layu', middempug giin ri se dlupa', bu' migampu' ne bu' mehimu, ndi' giin mayan se ngak pegantus. ");
INSERT INTO stb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Migampu' giin, “Gama'u! Su dlaun ne ngag betang mbaal mu. Awa' mu buwat ri senaan su kupa sek pegantus. Tumu' gena' su keliyag'u giining metuman ma'ad su keliyag mu.” ");
INSERT INTO stb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Rayun mipuli' giin tu se ngak tinu'unaan bu' mi'ita'en ilan telu neng mintulug. Miktalu' giin tu ni Pedro, “Simon, miktulug'a masi'? Ndi'a ba mekegantus ne ndi'a pundyengen isan sala uras na run?” ");
INSERT INTO stb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bu' miktalu' giin tu senilan, “Pegbantay bu' pegampu' amu arun ndi' amu daagen sek pektintal. Meliya' su gispiritu, ma'ad meluya su dlawas.” ");
INSERT INTO stb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mbuus mikpelayu' na pelun giin bu' migampu' seng maa'entu ra gusay nek pegampu'. ");
INSERT INTO stb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Rayun mipuli' giin tu se ngak tinu'unaan bu' mi'ita'en ilan neng mintulug pa gusay; tendeng ay tulugen ilan na gupiya. Bu' nda' na nilan mesuunay bu' landunik telu'en nilan ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Se ketelu nek pekpuli'en, miktalu' giin tu senilan, “Mikpebilin amu pa masi' sek pektulug bu' sek pekpengulali? Gigu' nain! Su guras minateng na! Enlengay niyu, sug Bata' ne Getaw nemuun tudyan na tu se ga'em ne ngang mekesesala'. ");
INSERT INTO stb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pembuwat amu, menlaang ita. Enlengay niyu, kiin na su getaw neng megbudhi' ri senaan!” ");
INSERT INTO stb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bu' rayun, saanay migasuy pa si Jesus, si Judas sala se ngak sepulu' bu' ruwa' ne ngak tinu'unan, minateng. Duma seniin suk panen ne nga getaw neng mingguwit ne nga kalis bu' ngag bentul bu' sinugu' ne geseg ne ngak pari', ne ngang mentetendu' se Kesugu'an bu' ne nga geseg ne ngag Judeo. ");
INSERT INTO stb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sung megbudhi' migbegay tu se ngak panen ne gilelaan: “Su getaw ne gelekan'u giin suk pinengaw niyu. Daap niyu giin bu' uwit niyu nek pebentayan gupiya.” ");
INSERT INTO stb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sek peddateng ni Judas, mikpegaud giin tu ni Jesus bu' miktalu', “Rabi!” bu' inelekaan giin. ");
INSERT INTO stb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aas dinaap nilan si Jesus bu' inuwiran gupiya. ");
INSERT INTO stb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma'ad suk sala se ngang mikpegindeg ritu minakut ne kalis bu' tinigbasen su gulipen nu dlabaw ne Geseg nek Pari', bu' mipetel suk telingaan. ");
INSERT INTO stb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Rayun miktalu' si Jesus tu senilan, “Mirini amu ba neng mingguwit ne nga kalis bu' ngag bentul sek peddaap ri senaan maa' nek tulisan? ");
INSERT INTO stb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kada gendaw minendu'u ritu sek Templo duma seniyu, bu' nda' niyau daapay. Ma'ad kina'enlan metuman su Kesulatan.” ");
INSERT INTO stb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Rayun su dlaun ne ngak tinu'unan mineleng ri seniin bu' minlaguy ilan. ");
INSERT INTO stb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Duunik sala neg begumbata' ne dlai, neng mikseluk ma'ad nek penepeten ne dlinu, neng midlendug ri ni Jesus. Dinaap nilan giin, ");
INSERT INTO stb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ma'ad ginumubek giin neng midlebas, mibilin suk sineluken. ");
INSERT INTO stb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Rayun inuwit nilan si Jesus tu seg balay ne Dlabaw ne Geseg nek Pari', su dlaun ne nga geseg ne ngak Pari', su nga geseg ne ngag Judeo bu' su ngang mentetendu' se Kesugu'an miktipung ritu. ");
INSERT INTO stb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Si Pedro midlendug ri seng melayu'layu' bu' miritu se dlenu'an neg balay ne Dlabaw ne Geseg nek Pari'. Migingkud giin ritu duma se nga guwardiya, mikpenalang tu se gapuy. ");
INSERT INTO stb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Su nga geseg ne ngak Pari', bu' suk tibuuk ne gukuman minengaw ne mpengaleg kuntra ri ni Jesus arun mpepatay nilan giin, ma'ad nda'iruning mi'ita' nilan. ");
INSERT INTO stb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Melauni ngang minintigus neg balus kuntra ri ni Jesus, ma'ad suk pimentalu' nilan nda' peksama. ");
INSERT INTO stb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Rayun duma se nga dlai migindeg bu' migasuy seg balus keni kuntra ri ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mirengeg nami giin neng miktalu', ‘Geba'en'u Templo keni neg binaal ne nga getaw bu' dluwat sek telu endaw bekuren'u su dlain nek Templo ne gena' baalen ne nga getaw.’ ” ");
INSERT INTO stb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aas, isan ngani' su ngak pimentalu' nilan nda' peksama. ");
INSERT INTO stb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Su Dlabaw ne Geseg nek Pari' migindeg ri seng metungenga'an nilan bu' miksaak ri ni Jesus, “Nda'irun baing mesembag mu run nini sek sumbung nek pirangat nilan kuntra seni'a?” ");
INSERT INTO stb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma'ad si Jesus nda' peksasak bu' nda' pegbegay nek sembag. Migeseb su Dlabaw ne Geseg nek Pari' se peksaak ri seniin, “Dya'a ba sung Misiyas, sug Bata' ne mbaya' Siya'en?” ");
INSERT INTO stb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Gaku',” miksembag si Jesus, “bu' me'ita' niyu sug Bata' ne Getaw neng megingkud ri sed dapit dlintu ne dlabi Ge'eman bu' mateng duma se nga ginanud se dlangit!” ");
INSERT INTO stb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Su Dlabaw ne Geseg nek Pari', bineriten suk suuben bu' miktalu', “Ndi' ita na medlekina'enlan ned dugang ne ngak sintigus! ");
INSERT INTO stb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mirengeg na niyu suk pekpesipalaan. Lama ri se gena'ena' niyu?” Su dlaun nilan minukum kuntra ri seniin: metuuran giin bu' kina'enlan petain. ");
INSERT INTO stb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sud duma senilan migatad sek peddula' ri ni Jesus bu' tinempengan nilan sung mataan bu' piksumbag nilan giin. “Atuk mu bu' ta' getaw sung miksumbag seni'a!” miktalu' ilan. Inuwan giin nu nga guwardiya bu' tinampaling giin. ");
INSERT INTO stb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Saanay ni Pedro ritu se dlenu'an, sed datag, minayan suk sala ne nga dlibun nek sesugu'en ne Dlabaw ne Geseg nek Pari'. ");
INSERT INTO stb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Sek pekiita'en ri ni Pedro neng mikpenalang, tinentengen giin bu' miktalu', “Dya'a rema sementaun ni Jesus nek taga Nazaret.” ");
INSERT INTO stb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma'ad pimalaun nini. “Nda'u mesuunay... nda'u mekesabut bu' landunik pimentalu' mu,” miksembag giin, bu' ginumawas giin pagaw tu seg biyanan. Bu' se guras ketu, miguni su dlimensad. ");
INSERT INTO stb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ritu mi'ita' giin puli' nuk sesugu'en ne dlibun bu' miktalu' su dlibun tu se nga getaw neng mingindeg ritu, “Getaw keni sala ri senilan!” ");
INSERT INTO stb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma'ad maa' ra run gusay, pimalaun nini puli'. Nda' santa', sud duma miktalu' tu ni Pedro, “Ndi'a mekepemalaw ne dya'a sementaun nilan, ay dya'a taga Galilea rema.” ");
INSERT INTO stb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Miktalu' rayun si Pedro, “Penumpa'u migasuyu neng metuud! Silutanu ned Diwata bu' gena' metuud! Nda'u gaid mekesuun se getaw iin nek tinalu' niyu!” ");
INSERT INTO stb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nda' santa', miguni rayun seng mekeruwa' su dlimensad. Rayun mirelendeman ni Pedro suk tinalu' ni Jesus ri seniin, “Se gendi' pa meguni su dlimensad se keruwa' neg higayun, limeren mau seng metelu ne nda' mau me'ilala.” Bu' dinaag giin se kegu'ul bu' miksegaw giin. ");
INSERT INTO stb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sek pekesikanselem, su nga geseg ne ngak Pari' midderali' meksabutsabut se nga geseg ne ngag Judeo, se ngang mentetendu' se Kesugu'an, duma se dlaun ne ngak sakup se Gukuman ne ngag Judeo. Ginapus nilan si Jesus bu' inuwit bu' piniyal nilan tu ni Pilato. ");
INSERT INTO stb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Miksaak si Pilato ri seniin, “Dya'a ba su gari' ne ngag Judeo?” Miksembag si Jesus, “Tinalu' mu na.” ");
INSERT INTO stb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pingelegan nu nga geseg ne ngak Pari' si Jesus seng melaun ne ngag betang, ");
INSERT INTO stb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","aas miksaak puli' si Pilato ri seniin, “Ndi'a ba meksembag? Penginengeg'a tu se dlaun ne ngak pingaleg nilan!” ");
INSERT INTO stb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma'ad nda' peksembag si Jesus, bu' mitingala si Pilato. ");
INSERT INTO stb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Se kada Kese'ulugan nek Paska, mibetasan ni Pilato neng mekpegawas nek salabuuk pinerisu ne gendyu'en ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sek panahun ketu su getaw ne giningelanan neg Barabas neng miperisu duma se ngag ribildi tendeng ay mikepatay giin sek panahun se kegubet. ");
INSERT INTO stb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Seng miktipung su ngak panen ne nga getaw, migatad ilan sek pegandyu' tu ni Pilato seng mi'enaran neg baalen ri senilan. ");
INSERT INTO stb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bu' miksaak si Pilato tu senilan, “Liyagan ba niyu neg beluyan'u para ri seniyu su gari' ne ngag Judeo?” ");
INSERT INTO stb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Misuunaan ma ugud nek piniyal si Jesus nu nga geseg ne ngak pari' tu seniin tendeng ay misinaku ilan. ");
INSERT INTO stb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma'ad su geseg se ngak pari' inubug nilan su nga getaw nek peguwasenen si Barabas para senilan. ");
INSERT INTO stb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Miksaak puli' si Pilato tu se ngak panen ne nga getaw, “Lama run rayunig baalen'u se getaw keni nek tinawag niyu ne gari' ne ngag Judeo?” ");
INSERT INTO stb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Migbeksay ilan, “Lensangen giin se krus!” ");
INSERT INTO stb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Ma'ad landun maik sala' neng mibaalen?” miksaak si Pilato. Ma'ad pisekegan pa tumu' nilan pegbeksay, “Lensangen giin se krus!” ");
INSERT INTO stb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Liyagan ni Pilato neng mekepedleliyag tu sek panen ne nga getaw, aas bineluyaan si Barabas para senilan. Rayun pilekpesen si Jesus bu' piniyalen arun lensangen giin. ");
INSERT INTO stb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Inuwit nu ngak sundalu si Jesus tu sek seled ne dlenu'an tu sek palasyu ne gobernador bu' tinawag nilan su dlaun ne ngak sundalu. ");
INSERT INTO stb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Piselukan nilan si Jesus nek suub neng melagemlagem, bu' migbaal ilan ne kuruna ned dugiyan ne ngak panga, bu' binetang nilan nini riin se guluun. ");
INSERT INTO stb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Rayun migatad ilan sek peddega'rega' neng miktalu': “Tetubu' su gari' ne ngag Judeo!” ");
INSERT INTO stb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Binentul nilan giin ne gages ri se gulu, piddula'an nilan giin, miginlulud ilan, bu' middungkukrungkuk ilan. ");
INSERT INTO stb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Seng mitubus na su ngak sundalu sek peddega'rega' ri ni Jesus, linuwas nilan suk suuben neng melagemlagem bu' piseluk nilan puli' ri seniin su gegulingenen nek suub. Rayun inuwit nilan giin tu se gawas arun lensangen. ");
INSERT INTO stb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Riin se dlaangan, milabet nilan su getaw ne su ngalanen si Simon, neng miniyan tu sek siyudad buwat seg binaal, bu' pineges nu ngak sundalu sek pekpisaan se krus ni Jesus. (Simon neg buwat se Cirene bu' giin su gama' ni Alejandro bu' Rufus). ");
INSERT INTO stb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bu' inuwit nilan si Jesus tu se dlugar ne giningelanan ne Golgota, neng migulugan, “Dlugar nek Tulaan Gulu.” ");
INSERT INTO stb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ritu binegayan nilan giin neg binu ne dlinemugan neg bulung iningelanan neng mira, ma'ad nda' inum si Jesus run nini. ");
INSERT INTO stb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Rayun linansang nilan giin tu se krus bu' pikilasilas nilan suk suuben pebiyan seg ripa, sek pegilala bu' ta'ing mekuwan run nini. ");
INSERT INTO stb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Miginenga' menaik nai gendaw itu sek pedlansang nilan ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Suk sumbung kuntra ri seniin laung; “Su Gari' nu ngag Judeo.” ");
INSERT INTO stb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Linansang rema nilan tu se krus duma seniin sud duwa' tawan ne ngak tulisan, suk sala riin rapit se dlintuun bu' suk sala diin rapit seg bibangen. ");
INSERT INTO stb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Su nga getaw neng mimbiyan mikisingising se nga gulu nilan bu' middega'rega' ri ni Jesus: “Aa! Dya'a su gumeba' sek Templo bu' bekuren mu ini puli' seled sek telu endaw! ");
INSERT INTO stb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na, Penaug'a buwat ri se krus iin bu' luwas mu su gegulingen mu!” ");
INSERT INTO stb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Seng maa' run nek pebiyan, su geseg ne ngak pari' bu' su ngang mentetendu' se Kesugu'an middega'rega' rema seniin, miktalu' suk salasala senilan, “Linuwasen su ngad duma, ma'ad ndi'en meluwas su gegulingenen! ");
INSERT INTO stb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nandaw, enlengan ta sung Misiyas, su gari' seg Israel, mekenaug ba buwat se krus iin, bu' mektu'u ita ri seniin!” Bu' sud duwa' tawan ne dlinansang duma seniin middega'rega' rema ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sek peketaasendaw na, tinumabun su kerelem sek tibuuk nasud, neng mirepet sek telu uras. ");
INSERT INTO stb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Seng miginenga' menaug nai gendaw, migbeksay si Jesus seng mesekeg, “Eloi, Eloi, lema sabachthani?” neng migulugan, “Diwatau, Diwatau, lama pegbelengan mau run?” ");
INSERT INTO stb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sud duma ne nga getaw ritu mikerengeg ri seniin bu' miktalu', “Penginengeg amu, tinawagen si Elias.” ");
INSERT INTO stb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Bu' suk sala tawan ginumebek neng miguwit neg ispungha, linebulen riin seng mesem ne ginumen, bu' binetangen riin sek patal ne gayu. Rayun pitaasen nini tu seg baba' ni Jesus bu' miktalu', “Gelatan ta! Enlengan ta bu' mateng ba si Elias sek pekpenaug ri seniin buwat se krus!” ");
INSERT INTO stb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Migbeksay neng mesekeg si Jesus bu' rayun minatay. ");
INSERT INTO stb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Su kurtina tu sek Templo miberit neng mibahin sed duwa', buwat se ditaas pagaw sek silung. ");
INSERT INTO stb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Su geseg ne ngak sundalu neng migindeg ritu seng metungenga'an ne krus mikiita' pikendun ni Jesus sek pekematay. “Getaw kini metuud gaid neg Bata' ned Diwata!” miktalu' giin. ");
INSERT INTO stb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sud duma ne nga dlibun ned ditu seng melayu'layu' neng mikpegenleng. Gilan si Maria Magdalena, si Maria ne gina' seg begumbata' nek Santiago bu' ni Jose, bu' si Salome. ");
INSERT INTO stb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Midlendug ilan ri ni Jesus saanay ritu pa giin se Galilea bu' migabang ri seniin. Melaun ne nga dlibun neng miritu seg Jerusalem duma seniin ne ritu rema. ");
INSERT INTO stb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Seng mikpeksindep na su gendaw minateng si Jose nek taga Arimatea. Tinamed giin nek sakup se Gukuman ne ngag Judeo, neng mikperateng sek peddateng nek Pedlegeri'an ned Diwata. Gendaw itu sek Pekpengandam (ne giin su gendaw se genda' pai Gendaw nek Pengulali), aas si Jose se genda'i gendek miritu seng metungenga'an ni Pilato bu' inubugen sug bangkay ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mitingala si Pilato sek pekerengegen run ne si Jesus minatay na. Tinawagen su geseg ne ngak sundalu bu' sinakaan bu' mpayat na ba matay si Jesus. ");
INSERT INTO stb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Dluwaten mesuunay tu se geseg ne ngak sundalu, tinelu'an ni Pilato si Jose ne uwanenen sug bangkay ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Si Jose sinumaluy ne dlinu nek penepeten, inuwanen sug bangkay ni Jesus, pinutusen nini, bu' pi'imetangen tu se dlebengan ne dlineluran nek telektap. Rayun linuliren sug batu arun tampeng ri sed dungawan ne dlebengan. ");
INSERT INTO stb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Si Maria Magdalena bu' si Maria ne gina' ni Jose migbantay bu' mikiita' bu' ta' pi'imetang sug bangkay ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dluwat se Gendaw nek Pengulali, si Maria Magdalena, si Maria ne gina' ni Santiago, bu' si Salome mimenaluy ne ngak pegemut para penlunas seg bangkay ni Jesus. ");
INSERT INTO stb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bu' sek pekesikanselem se gendaw ned Duminggu, seng mekpeksebang na su gendaw, miritu ilan se dlebengan. ");
INSERT INTO stb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Diin ilan pa se dlaangan, miksesaakay ilan ri sek salasala senilan, “Ta' maing medlulid run sug batu para senita buwat sed dungawan ne dlebengan?” ");
INSERT INTO stb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","(Gembagel gupiya sug batu ketu.) Maad sek pegenleng nilan run mi'ita' nilan neng milulid na sug batu. ");
INSERT INTO stb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aas simumeled ilan tu se dlebeng, bu' mi'ita' nilan sug begumbata' ne dlai neng miksuub ne gemputi' neng mikpegingkud ri sed dapit dlintu, bu' mitingkangan ilan gaid. ");
INSERT INTO stb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“Ndi' amu metingkang,” miktalu' giin. “Misuunan'u neng minengaw amu ri ni Jesus nek taga Nazaret, ne dlinansang tu se krus. Nda' na giin rini, mitubu' giin puli'! Enlengay niyu, keni ra su dlugar nek pi'imetangan ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, penlaang amu bu' asuy niyu sung minsahi tu se ngak tinu'unaan, asta si Pedro: ‘Meguna si Jesus ri seniyu tu se Galilea; ritu me'ita' niyu giin, sumala' se ginasuyen ri seniyu.’” ");
INSERT INTO stb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aas ginumawas ilan bu' ginumebek buwat se dlebengan, neng minendek bu' mitingkangan. Nda'irunik tinelu'an nilan, tendeng ay mi'endekan ilan gupiya. ");
INSERT INTO stb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Dluwat metubu' puli' si Jesus, sek sikanselem se gendaw ned Duminggu, mikpe'ita' giin guna tu ni Maria Magdalena, suk piguwasaan nek pitu ne ngak penulay. ");
INSERT INTO stb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Midlaang si Maria bu' inesuyaan su ngak sementaunen neng minsegaw bu' migu'ul; ");
INSERT INTO stb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","bu' sek pekerengeg nilan run sek tinalu'en neng mitubu' puli' si Jesus bu' mikpe'ita' giin ri seniin, nda' ilan pektu'u ri seniin. ");
INSERT INTO stb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dluwat itu, mikpe'ita' si Jesus tu sed duwa' ne ngak tinu'unan se dlain nek pebiyan saanay nilan mekpedlaang pagaw tu seg buwid. ");
INSERT INTO stb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mipuli' ilan bu' tinelu'an nilan sud duma, ma'ad nda' ilan pektu'u run nini. ");
INSERT INTO stb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Se ketapusan, si Jesus mikpe'ita' tu sek sepulu' bu' sala ne ngak tinu'unan saanay nilan mengaan. Pimaagen ilan, tendeng ay nda'irunik pektu'u nilan bu' tendeng ay metegasi gulu nilan sek petu'u tu se ngang mikiita' ri seniin dluwat giin metubu' puli'. ");
INSERT INTO stb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Miktalu' giin tu senilan, “Penlaang amu tu sek tibuuk neg benwa bu' penintulu' niyu su Gempiya ne Gesuyen tu se dlaun ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Su isan ta' neng mektu'u bu' mekpebendyag meluwas; su isan ta' ne gendi' mektu'u ukuman. ");
INSERT INTO stb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Su ngang mektetu'u begayan ne ga'em sek pegbaal ne ngang milagru: mekepegawas ilan ne ngang melaat ne gispiritu pebiyan se ngalan'u; meketuntul ilan se nga dlainlain ne ngak tinuntulan; ");
INSERT INTO stb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bu' mekegawid ilan ne ngang mamak awas mekiinum ilan se isan landun neg bulit, ndi' ilan medlaat; bu' depenan nilan su ngang menlaru, bu' me'uli'an ilan.” ");
INSERT INTO stb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Dluwat itu telu'ay ni Jesus tu senilan, pilentu giin tu se dlangit bu' migingkud giin sed dapit dlintu ned Diwata. ");
INSERT INTO stb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bu' su ngak tinu'unan minlaang bu' minintulu' isan ta' ne dlugar, bu' inebangan ilan ne Ginu'u bu' suk pekpenintulu' nilan mipemetuuran neng metuud pebiyan se ngang milagru neng mibaal nilan. (v 9) Miritu rayun su nga dlibun tu ni Pedro bu' tu se ngak sambaten bu' migbegay senilan se gempelek ne gesuyan se dlaun nek tinalu' senilan. (v 10) Dluwat ini, pinawit ni Jesus pebiyan se ngak tinu'unaan buwat sek sebangan pagaw sek sindepan sug bala'an bu' nda'iruni kemetain neng minsahi se keluwasan ne genda'i gekteben.");
INSERT INTO stb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Seni'a Teofilo: Meleget na sung miksulat ri seng miksumpatsumpat ne ngag betang neng mihitabu' ri sek titenga' ta metendeng riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bu' suk sinulat nilan maa' ra run rema suk tinalu' nu nga getaw neng mikiita' rema mismu se ngak penghitabu' gatad pa se getaran bu' minintulu' seng minsahi ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aas sek pektipet'u run gaid, Uu, tinamed nek Teofilo, dlaun nek penghitabu' keni gatad pa se getaran pigena'ena'u nek sulaten'u seni'a ri seng melengas nek pekimetang, ");
INSERT INTO stb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","arun mesiguru neng mesuunan mu suk tibuuk ne kemetuuran metendeng se kada neg betang nek tinendu' riin seni'a. ");
INSERT INTO stb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sek panahun ne si Herodes pa su gari' ritu sek probinsiya neg Judea, duunik sala nek pari' ne su ngalanen si Zacarias neng migbuwat se gesalan ni Abias ne ngak pari'. Suk sawa ni Zacarias giin si Elisabet neng migbuwat se gesalan sek pamilya ni Aaron ne ngak pari'. ");
INSERT INTO stb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bu' gilan duwa' midleketubu' neng metareng ri sek pengenleng ned Diwata. Bu' tinuman nilan gaid su dlaun ne nga Kesugu'an bu' ngak sugu' ne Ginu'u. ");
INSERT INTO stb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nda' ilan pegbata' ay ndi' mengembata' si Elisabet ay dlegulang ilan duwa' na. ");
INSERT INTO stb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Na, sek timpu na nu ngak sakup ni Abias sung mekepengalagad ri sed Diwata ditu sek Templo, migripa su ngak pari' sumala' seng mibetasan nilan. Bu' si Zacarias, giining miripaan nilan neng meksereng sek pelinaan. Tendeng run itu, sinumeled si Zacarias tu sek Templo ne Ginu'u, ");
INSERT INTO stb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","saanay migampu' su ngang meleget ne nga getaw ritu se gawas se guras nek serengen ni Zacarias suk pelinaan ritu. ");
INSERT INTO stb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Rayun duunig anghel ne Ginu'u neng migindeg riin sed dapit dlintu neg halaran ne ritu pekserengay suk pelinaan. ");
INSERT INTO stb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Seng mi'ita' giin ni Zacarias, migikmat dun bu' minendek. ");
INSERT INTO stb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma'ad miktalu' sug anghel ri seniin, “Ndi'a mendek, Zacarias, ay mirengeg nud Diwata suk pegampu' mu. Si Elisabet, nek sawa mu mengembata' neg bata' dlai. Bata' keni, ingelanay mu ne si Juan. ");
INSERT INTO stb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Leliyagen'a run gupiya bu' leliyagen rema gupiya sung meleget ne nga getaw seng me'etaw na giin. ");
INSERT INTO stb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ay meselaag giin gupiya sek pengenleng ne Ginu'u ri seniin. Ndi' giin mpiya minum neg binu bu' duma pa neng mekebeleng. Seng megegetaw giin, su Gispiritu Santu duma ri seniin buwat sek panahun nek pegegetawen, ");
INSERT INTO stb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","bu' pepuli'enen sung melaun ne gesalan ni Israel riin se Ginu'u ned Diwata nilan. ");
INSERT INTO stb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Meguna giin ri se Ginu'u seng meksama ne ga'em bu' gispiritu neng mi'angken ni propeta Elias. Bu' tendeng ri seniin, peguli'enen puli' su nga gama' bu' gembata'. Bu' su nga getaw ne gendi' mektuman ri sed Diwata megatad sek pegena'ena' ri sek pekemetareng; endamenen su nga getawan ned Diwata ri sek peddatengen.” ");
INSERT INTO stb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tinelu'an ni Zacarias sug anghel, “Laa kesuun'u run neng metuud suk tinalu' mu? Dlegulangu na bu' suk sawau, dlegulang na rema.” ");
INSERT INTO stb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Miksembag sug anghel, “Gaku' si Gabriel neng migindeg ri seng metungenga'an ned Diwata. Bu' sinugu' naun arun tebalan'a ri se gempiya ne gesuyen. ");
INSERT INTO stb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma'ad nda' mu petuuray suk tinalu'u neng metuman se ginsaktu nek panahun. Tendeng ay nda'a pektu'u, megugel'a; ndi'a mekegabit tampan metuman suk pisuun'u seni'a.” ");
INSERT INTO stb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ri se dlain neg bahin, migelat su nga getaw riin ni Zacarias bu' mitingala ilan gaid ri se kepayaten ri sek Templo. ");
INSERT INTO stb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sek pegawas na ni Zacarias, ndi' na giin mekegabit tu senilan, aas misuunan nilan ned duunik pi'ita' nud Diwata ri seniin tu sek Templo. Tendeng ay mi'ugel na giin, miksinyas ra run tu se nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Peketubus sek pengalagad ni Zacarias ri sek Templo, minuli' giin tu seg balay nilan. ");
INSERT INTO stb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Minayan suk santa' endaw, migberes si Elisabet, nek sawaan. Sek seled se dlima bulan nda' gawas si Elisabet ri seg balay nilan. ");
INSERT INTO stb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Nandawu pa linelaatan nud Diwata,” laungen, “Inawa'en senaan su kepiiran'u tu se dlaun ne nga getaw tendeng ay ndi'u mengembata'.” ");
INSERT INTO stb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sek pekegenem bulan nek pegberes ni Elisabet, sinugu' nud Diwata sug anghel ne si Gabriel neng meritu se dlunsud ne giningelanan neng Nazaret nek sakup se Galilea. ");
INSERT INTO stb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Duuning minsahiin tu sed delaga nek pengesuwaan na ni Jose, ne gasal ni Gari' David. Su ngalanen si Maria. ");
INSERT INTO stb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Seng minateng sug anghel ritu, miktalu' giin, “Mpiya gendaw riin seni'a. Diin seni'a sud Diwata, Maria, bu' pengumpiyanan'a gupiya niin!” ");
INSERT INTO stb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Sek pekerengeg ni Maria run itu, midlibeg run gupiya ri sek tinalu' nug anghel bu' pigena'ena'en landun sakani gulugaan nini. ");
INSERT INTO stb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Miktalu' sug anghel ri seniin, “Ndi'a mendek, Maria. Pipiyanan'a nud Diwata. ");
INSERT INTO stb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Enlengay mu, megberes'a bu' megbata'a ne dlai, bu' ingelanay mu giin ne si Jesus. ");
INSERT INTO stb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Meselaag giin bu' tuwagen neg Bata' nu Dlabi neng Mekegega'em ned Diwata. Su Ginu'u ned Diwata megbaal seniin ne gari' maa' ne gepu'aan ne si David. ");
INSERT INTO stb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Medlegari' giin se gasal ni Jacob ne genda'ik tamanen; suk pedlegeri'aan mekpeddayun se genda'i gekteben.” ");
INSERT INTO stb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Miksaak si Maria tu seg anghel, “Pekendun'u ma pegbata'? Genda'irun pai dlai neng mikepengilabet senaan.” ");
INSERT INTO stb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Miksembag sug anghel, “Lumusad su Gispiritu Santu seni'a bu' su ga'em ne Dlabi neng Metaas ned Diwata diin rema seni'a. Seng maa' niin ne keterengan, sug bata' neng me'etaw tuwagen neg Bata' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Pegena'ena' mu, su gapen mu ne si Elisabet, dlegulang na ma'ad genem bulan naig beresaan. ");
INSERT INTO stb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tendeng ay genda'iruni ndi' mbaal ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","“Sesugu'enu ma'ad nu Ginu'u,” miktalu' si Maria; “Metuman sa'wan senaan suk tinalu' mu.” Bu' migawa' sug anghel riin seniin. ");
INSERT INTO stb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Minayan suk santa' endaw, si Maria miritu sek sala ne dlunsud ditu seg binenturan neg Judea. ");
INSERT INTO stb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Miritu giin seg balay nilan ni Zacarias bu' mingumusta ri ni Elisabet. ");
INSERT INTO stb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pekerengeg ni Elisabet sek pengumusta ni Maria, mikuleg sug bata' ri sek tiyanen bu' gine'eman si Elisabet se Gispiritu Santu, ");
INSERT INTO stb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","bu' seng mesekeg nek talu', laungen, “Pingumpiyanan'a gupiya ned Diwata sinangkali' sed duma ne dlibun! Pingumpiyanan rema nud Diwata sug bata' nek pe'etaun mu. ");
INSERT INTO stb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tuma ma su gembagel neg betang mihitabu' riin senaan, neng migbentaw ma ri senaan su gina' ne Ginu'uu? ");
INSERT INTO stb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ay sek pekerengeg'u sek pengumusta mu, sug bata' sinumindak ri sek tiyan'u se dleliyag. ");
INSERT INTO stb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pedleliyagen'a gupiya neng mikpetu'ua ri seng minsahi ne Ginu'u neng metuman riin seni'a!” ");
INSERT INTO stb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Miktalu' si Maria, “Siya'en'u su Ginu'u ri sek pusung'u! ");
INSERT INTO stb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Bu' pidleliyag su gispirituu tendeng ay sud Diwata sung Menleluwas'u, ");
INSERT INTO stb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ay nda' naun pedlingaway, isan gaku' gembaba' ra nek sesugu'enen. Gatad numuun, mektalu' su dlaun ne getaw nek pingumpiyananu ned Diwata, ");
INSERT INTO stb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tendeng se ketingelaan ne ngag betang neg binaal nu Ge'eman ned Diwata ri senaan. Bala'an su ngalanen; ");
INSERT INTO stb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","gatad se guna ne gesalan tampan tu sek sunud ne gesalan mikpe'ita' giin ne dlelaat tu se dlaun ne nga getaw neng megbasa ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pi'ita'en suk pekege'emaan bu' pibelagbelagen su ngang mekpesaya'saya' duma se ngak pelanu nilan. ");
INSERT INTO stb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pibaba'en su ngang melipetaasen neng midlegari' bu' pitaasen su nga getaw neng melipebaba'en. ");
INSERT INTO stb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pibesug ned Diwata su ngang miperii'an, bu' pipe'awa'en su ngang mekeratu', ne nda'iruning me'uwiten. ");
INSERT INTO stb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Inebangaan suk sesugu'enen ne si Israel bu' linelaataan gusay su nga getawaan. ");
INSERT INTO stb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tinumanen suk saad nek sinaaren tu se nga gepu'an ta, Nda'en pedlingaway suk pekpe'ita' se dlelaat riin ni Abraham bu' tu se dlaun ne gesalaan se genda'i gekteben!” ");
INSERT INTO stb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mikengel si Maria ri seg balay nilan ni Elisabet seled sek telu bulan pulu' giin minuli' tu seg balain. ");
INSERT INTO stb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Minateng na suk panahun neng me'etawan na si Elisabet, bu' migbata' giin ne dlai. ");
INSERT INTO stb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sek pekerengeg nu ngak sumbalain bu' nga gapenen nek pipiyanan giin gupiya nu Ginu'u, pidleliyag ilan gupiya duma ni Elisabet. ");
INSERT INTO stb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Se kewalu gendaw na sug bata', miritu ilan seg balay nilan ni Zacarias sek pektuli' seg bata'. Bu' liyagan nilan siya nek peksangain ilan nu gama'en ne si Zacarias. ");
INSERT INTO stb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma'ad si Elisabet miktalu' tu senilan, “Ndi' mehimu! Kina'enlan su ngalan neg bata' si Juan.” ");
INSERT INTO stb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Miktalu' ilan tu ni Elisabet, “Nda'irun ma gapen mu neng mesangay di ngalan keni!” ");
INSERT INTO stb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bu' piksinyasan nilan si Zacarias landun mai dliyagaan ne ngalan para seg bata'en. ");
INSERT INTO stb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Miksinyas si Zacarias neg begayan giin neng mesulatan. Dayun sinulaten, “Su ngalan nug bata' si Juan.” Dlaun nilan mitingala! ");
INSERT INTO stb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sek panahun ketu, si Zacarias mikegabit puli' bu' migatad giin sek peksaya' ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Minendek su ngak sumbalay nilan, bu' su gesuyan metendeng se ngag betang keni mirepet tu se nga getaw ditu seg binenturan neg Judea. ");
INSERT INTO stb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Su dlaun ne getaw neng mikerengeg run, migektemektem bu' miksaak, “Megendun ma sakanig bata' keni bu' mbagel? Ay kelaru ma gupiya su Ginu'u diin seniin.” ");
INSERT INTO stb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Su Gispiritu Santu midlega'em riin ni Zacarias, su gama' ni Juan bu' migasuy giin seng minsahi ned Diwata: ");
INSERT INTO stb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Siya'en ta su Ginu'u, sud Diwata neg Israel! Mirini giin arun sek pegabang tu se nga getawaan bu' pekpegawas senilan. ");
INSERT INTO stb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Binegayaan ita seng Mekegega'em neng Menleluwas, su gasal nek sesugu'enen ne si David. ");
INSERT INTO stb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sinaaren pebiyan seg bala'an ne ngak propetaan nud diin ");
INSERT INTO stb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ne dluwasenen ita buwat ri se nga kuntra ta, buwat se ga'em se dlaun neng minggemet senita. ");
INSERT INTO stb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Miktalu' giin neng mekpe'ita' giin ne dlelaat tu se nga gepu'an ta bu' nda'en pedlingaway sug bala'an ne keligenan. ");
INSERT INTO stb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Duma sek pekpenumpa' tu se gepu'an ta ne si Abraham sinaaren ne dluwasen ita buwat ri se nga kuntra ta bu' mektugut senita sek pekpenibeli ne nda'iruni gendek, ");
INSERT INTO stb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","arun mbaal ita neg bala'an bu' metareng ri seng metungenga'aan ri se dlaun ne gendaw se ketubu' ta.” ");
INSERT INTO stb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Bu' miktalu' rayun si Zacarias tu seg bata'en, “Dya'a, bata'u, tuwagen'a nek propeta se Dlabi neng Metaas ned Diwata. Megunaa ri se Ginu'u sek pegandam ne ngad dalan neg biyanaan, ");
INSERT INTO stb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","sek pegasuy tu se nga getawaan neng meluwas ilan pebiyan sek pekpasaylu riin se ngak sala' nilan. ");
INSERT INTO stb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sud Diwata ta melilelaaten bu' mpiya. Sinugu'en ri senita sung Menleluwas maa' nek peksebang ne gendaw. ");
INSERT INTO stb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Para senita neng midleketubu' riin se kereleman se kemetain, kerelaag keni meddelaag sek pegunut senita riin sed dalan ned duuni kelinaw.” ");
INSERT INTO stb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Miksibagel sug bata' ne si Juan bu' su Gispiritu ned Diwata migbegay seniin ne gembagel ne ga'em. Mikengel giin tu se kemingawan tampan se gendaw neng migatad giin menendu' tu se nga getaw Israel. ");
INSERT INTO stb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na sek panahun ketu, su Gari' nu nga getaw Roma ne si Augustos miksugu' nek penlistaan su dlaun ne nga getaw ri sek tibuuk nek Pedlegeri'aan. ");
INSERT INTO stb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Se guna nek pekpenlista se nga getaw ketu, si Cirenio su gobernador tu sek Syria. ");
INSERT INTO stb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bu' su kada sala miritu rayun arun mekpelista ritu se gegulingen nilan ne dlunsud. ");
INSERT INTO stb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na miritu si Jose buwat se dlunsud seng Nazaret nek sakup se Galilea pagaw tu se dlunsud seg Bethlehem nek sakup seg Judea, su dlugar nek pigegetawan ni Gari' David. Miritu si Jose tendeng ay sakup ma giin se gesalan ni David. ");
INSERT INTO stb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mikpelista giin duma ni Maria, nek sinaad nek pengesuwanen. Migberes na si Maria, ");
INSERT INTO stb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","bu' saanay ditu ilan seg Bethlehem, giin suk timpu sek pegbata'en. ");
INSERT INTO stb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Bu' ritu, migbata' giin se guna neg bata'en ne dlai, inemesaan sug bata'en, rayun bineliliren ditu sek palungan tendeng ay nda'irunid dugu ritu ne mpenaikan nilan. ");
INSERT INTO stb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Se gebii ketu, duuni ngang midlekata se nga karniru ritu se ngak pe'eksaban megaud se dlunsud seg Bethlehem bu' pigelungan nilan su nga karniru. ");
INSERT INTO stb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Saanay nilan megalung se nga karniru, duuning mituwa' tu senilan neg anghel nu Ginu'u bu' middelaag ri sek timala' nilan su kesanag nu Ginu'u. Bu' mi'endekan ilan gupiya, ");
INSERT INTO stb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ma'ad miktalu' sug anghel senilan, “Ndi' amu mendek! Miriniu duma se gempiya ne gesuyen para seniyu, neng mekegbegay ne dleliyag tu se dlaun ne getaw. ");
INSERT INTO stb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Se gebii keni, migegetaw na ritu se dlunsud ni David sung Menleluwas. Giin si Christ ne Ginu'u. ");
INSERT INTO stb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Bu' giin nini su gilelaan niyu run. Me'ita' niyu sug bata' ne inemesan bu' binelilid diin sek palungan, giin na.” ");
INSERT INTO stb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sek tikmal, mintuwa' sung meleget gupiya ne ngag anghel bu' mikpeddayun sek peksaya' riin sed Diwata, ");
INSERT INTO stb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Siya'en sud Diwata ritu se kinetaasan ne dlangit, bu' kelinaw ri seg benwa para se nga getaw neng mikepedleliyag ri seniin!” ");
INSERT INTO stb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Seng minggawa' na su ngag anghel ritu se ngang menggegingat ne karniru, mipuli' ilan rayun ditu se dlangit. Laung rayun nu kada neng menggegingat ne karniru, “Tala, meritu ita seg Bethlehem bu' enlengan ta sug betang keni neng mihitabu', nek pisuun senita nu Ginu'u.” ");
INSERT INTO stb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aas minikad medlaang su ngang menggegingat ne karniru. Rayun sek peddateng nilan ritu, mi'ita' nilan si Maria bu' si Jose duma sug bata' neg binelilid sek palungan. ");
INSERT INTO stb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Seng mi'ita' nu ngang menggegingat ne karniru sug bata', inasuy rema nilan riin seng megulangen suk tinalu' senilan nug anghel metendeng ri seg bata'. ");
INSERT INTO stb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Su dlaun neng minginengeg mitingala sek tinalu' ne ngang menggegingat ne karniru. ");
INSERT INTO stb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma'ad si Maria, pigena'ena'en su dlaun nek penghitabu' ketu bu' pigektemektemaan gupiya. ");
INSERT INTO stb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Minuli' su ngang menggegingat ne karniru neng miksaya' riin sed Diwata bu' migasuy tu se ngang mekelengas ne ngag betang metendeng ri seniin. Su dlaun neng mirengeg bu' mi'ita' nilan metendeng sek tinalu' ri senilan nug anghel. ");
INSERT INTO stb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Se kewalu endaw dluwat mi'etaw sug bata', pituli' bu' iningelanan giin ne si Jesus, su ngalan neg binegay nug anghel se genda' pa pegberes su gina'en. ");
INSERT INTO stb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na, minateng su gendaw ne si Jose bu' si Maria meguwit neg halad sek templo ritu seg Jerusalem arun tumanen su Kesugu'an tendeng se dlibun neg begu pa mingembata' arun melimpiyu giin. Bu' inuwit rema nilan sug bata' bu' hinalad ri se Ginu'u. ");
INSERT INTO stb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ay misulat ri se Kesugu'an ne Ginu'u, “Su dlaun ne nga gulangbata' ne dlai su Ginu'u su gapu'en.” ");
INSERT INTO stb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Middulang ilan rema ned duwa' buuk dlimuun awas duwa' buuk gekpis nek selepati ne kina'enlanen se kesugu'an ne Ginu'u. ");
INSERT INTO stb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sek panahun ketu duuni getaw ne giningelanan ne si Simeon neng mikengel seg Jerusalem. Metareng giin ne getaw, melindeken riin sed Diwata bu' migelat giin sek pedluwas seg Israel. Bu' su Gispiritu Santu diin seniin bu' gine'eman giin, ");
INSERT INTO stb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","bu' mikpesuun ne ndi' giin matay se ndi'en pa me'ita' suk sinaad nu Ginu'u neng Misiyas. ");
INSERT INTO stb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gine'eman ne Gispiritu, miritu si Simeon sek Templo. Bu' mihitabu' rema ritu ne inuwit sug bata' ne si Jesus nu ngang megulangen arun baalen ri seniin suk tinalu' se Kesugu'an. ");
INSERT INTO stb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sek pekiita' ni Simeon seg bata', sinipiten bu' sinaya'en sud Diwata: ");
INSERT INTO stb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Na, Ginu'u, tinuman mu na suk sinaad mu, bu' tugutay mu na, suk sesugu'en mu neng matay ned duun nai kelinaw. ");
INSERT INTO stb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Se gegulingen'u ne ngang mata, mi'ita'u na sung mibaal mu sek pedluwas riin se nga getaw mu, ");
INSERT INTO stb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ne inandam mu riin sek titenga' ne nga getaw sek tibuuk ne ngang nasud, ");
INSERT INTO stb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","sud delaag neng mekpe'ita' se keliyag mu tu se nga gena' Judeo bu' megbegay ned dengeg tu se nga getawan mu nek sakup ni Israel.” ");
INSERT INTO stb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Pekerengeg nu gama' bu' gina' ni Jesus bahin ri sek tinalu' ni Simeon, mitingala ilan. ");
INSERT INTO stb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pingumpiyanan ilan ni Simeon, bu' miktalu' giin riin ni Maria ne gina' nug bata', “Enlengay niyu, bata' keni, pinili' ned Diwata para mesilutan sud duma ne getaw nek sakup ni Israel bu' luwasen rema sud duma. Gilelaan ne giin buwat sed Diwata ma'ad meleget su kumuntra ri se gilelaan tendeng run nini, ");
INSERT INTO stb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","mpe'ita' sung mi'edlud nilan ne ngak pengena'ena'. Bu' dya'a ne gina'en, betiken mu neng maa' ne kinemetemet suk pusung mu seng melebiyan ne kegu'ul.” ");
INSERT INTO stb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ritu rema sek templo, duunik sala ne dlibun nek propeta ne su ngalanen si Ana, bata' ni Panuel, buwat sek tribu ni Aser. Dlegulang na gupiya giin. Seg begumbata' pa giin, pitu taun giin neng misuway ma'ad minatay sug banaan. ");
INSERT INTO stb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bu' numuun, walu pulu' bu' paat taun nai giddaren, nda' giin pegawa' riin sek Templo; gendaw bu' gebii miksimba riin sed Diwata neng mikpu'asa bu' migampu'. ");
INSERT INTO stb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sek sama ne guras ketu, mikpesalamat ri sed Diwata bu' migasuy giin metendeng riin seg bata' ne si Jesus tu se nga getaw neng mikperateng riin sed Diwata sek pegbegay ne kegewasan seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Seng mituman na ni Jose bu' ni Maria su dlaun nek tinalu' se Kesugu'an ne Ginu'u, minuli' ilan se dlunsud neng Nazaret nek sakup ne Galilea. ");
INSERT INTO stb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bu' miksibagel sug bata', miksisekeg; bu' middugang suk sinuunaan bu' suk pengumpiya nud Diwata riin seniin. ");
INSERT INTO stb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Se kada nek taun, meritu su ngang megulang ni Jesus seg Jerusalem sek Pekse'ulug sek Paska. ");
INSERT INTO stb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Se kesepulu' bu' ruwa' taun ni Jesus, tinumuwad ilan tu seg Jerusalem sek pekse'ulug sumala' ri seng mibetasan nilan. ");
INSERT INTO stb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Peketubus nilan mekse'ulug, migatad ilan muli'. Ma'ad sug bata' ne si Jesus mikpebilin seg Jerusalem. Nda' ini mesuunay nu ngang megulangen. ");
INSERT INTO stb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Diin se gena'ena' nilan neng miketendug ra si Jesus ri sek panen ne nga getaw neng minguli' na rema. Ngani' seng mikedlaang ilan na seled sek sendaw, pinengaw nilan si Jesus tu nga gepenan bu' se ngak sambat nilan. ");
INSERT INTO stb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma'ad nda' nilan giin mbaangay. Aas mipuli' su ngang megulangen tu seg Jerusalem arun pekpenengaw seniin. ");
INSERT INTO stb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Se ketelu endaw, mi'ita' nilan si Jesus ritu sek Templo neng migingkud duma nu ngang Mentetendu' neg Judeo bu' minginengeg giin bu' miksaak senilan. ");
INSERT INTO stb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Su dlaun neng mikerengeg seniin mitingala sek sinuunaan bu' sek pekpenembagen. ");
INSERT INTO stb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Sek pekiita' ne ngang megulangen seniin, mitingala ilan. Miktalu' su gina'en, “Enung, lama pegbaalan mu run nini ri senami? Migules ami sek pekpenengaw seni'a.” ");
INSERT INTO stb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Miksembag si Jesus senilan, “Lama pa pekpenengawan niyau run? Nda' ba niyu mesuunay ne kina'enlan riniu seg balay ne Gama'u?” ");
INSERT INTO stb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma'ad nda' mekesabut su ngang megulangen sek sembagen. ");
INSERT INTO stb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Middunut giin muli' ri se ngang megulangen seng Nazaret bu' miktuman riin senilan. Ma'ad dlaunen keni, inedlud ni Maria ri sek pusungen. ");
INSERT INTO stb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tinumulin si Jesus bu' middugang suk sinuunaan; bu' pidleliyag gupiya seniin sud Diwata bu' su nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Se kesepulu' bu' lima taun na itu sek pedlegari' nu Gari' ne si Tiberio; Si Poncio Pilato, giini gobernador seg Judea. Si Herodes, giini geseg se Galilea. Si Felipe ne nguran ni Herodes, giini geseg seg Iturea bu' Trakonite. Si Lisanias, giini geseg seg Abilinia. ");
INSERT INTO stb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Giin remaik panahun ne si Anas bu' si Caipas su nga Dlabaw ne Geseg ne ngak Pari'. Sek panahun ketu, sud Diwata miktalu' tu ni Juan neg bata' ni Zacarias, neng mikengel ritu se kemingawan. ");
INSERT INTO stb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aas linaup ni Juan sek pegwali su dlaun ne dlugar sek pelibut seg Bagel tubig neg Jordan, “Peddiksu' bu' beleng niyu suk sala' niyu bu' mekpebendyag amu bu' pasayluun nud Diwata su ngak sala' niyu.” ");
INSERT INTO stb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sumala' seng misulat riin se dlibru ni propeta Isaias: “Duuni getaw neng migbeksay ri se kemingawan: ‘Andam niyu sud dalan para se Ginu'u; Baal niyu neng meleddeng sug biyanan para sek pedlaangen! ");
INSERT INTO stb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Su kada nek seluub kina'enlan tembakan, su kada neg bentud mitut bu' gembagel lumbangen. Su ngang minliku'liku' ne ngad dalan kina'enlan leddengen, bu' su ngad dengkalen lenu'en. ");
INSERT INTO stb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bu' me'ita' ne dlaun ne nga getawan suk pedluwas nud Diwata riin se nga getaw!’” ");
INSERT INTO stb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na, meleget ne nga getaw neng miritu ni Juan arun mekpebendyag ri seniin. “Gamu neng maa' ne ngang mekelala ne ngang mamak!” miktalu' si Juan senilan. “Ta' maing minegul seniyu neng mekedlaguy amu sek silut ned Diwata neng megaud na mateng? ");
INSERT INTO stb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Baal niyu su ngag betang neng mikpe'ita' neng middiksu' amu buwat ri se ngak sala' niyu. Bu' ndi' amu pektalu' ri se gegulingen niyu ne gasal amu ni Apu' Abraham. Telu'an'u amu ne isan ngani' ngag batu keni, mbaluy nud Diwata ne ngag bata' ni Abraham. ");
INSERT INTO stb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aas nandaw, sug wasay inandam na sek pekpenaga' ne gayu riin rapit se nga ganget. Su kada gayu ne nda' pemunga neng melengas neg bunga penaga'en bu' pidlaken tu se gapuy.” ");
INSERT INTO stb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Su nga getaw miksaak ri seniin, “Bu' maa' niin, landun ma rekayig baalen nami?” ");
INSERT INTO stb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Miksembag si Juan, “Na, bu' ta' riin seniyu duunid duwa' buuk nek suuben begayan niyu su genda'irun neng niin. Ta' riin seniyu duuni gaanen, memegay rema.” ");
INSERT INTO stb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Duuni ngang meneningil neg buwis neng miritu rema ni Juan arun mekpebendyag, miktalu' ilan riin ni Juan, “Sir, landun maig baalen nami?” ");
INSERT INTO stb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Bu' meningil amu neg buwis, ndi' amu meningil neng menubra ri sek pipeningil seniyu ne goberno,” miksembag si Juan. ");
INSERT INTO stb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Duuni ngak sundalu rema neng miksaak, laung nilan, “Mbuus gami, landun maig baalen nami?” Miksembag si Juan senilan, “Ndi' amu pengilkil bu' ndi' amu pengaleg ne genda'iruni ketuuren. Kina'enlan neng mekuntintu amu na run sek su'ul niyu.” ");
INSERT INTO stb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Sek pekerengeg ne nga getaw se ngak pekpenintulu' ni Juan, migena'ena' ilan ne ali' bu' si Juan, giin na sung Misiyas. ");
INSERT INTO stb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aas miktalu' si Juan senilan, “Gaku' megbendyag seniyu ri sek tubig ma'ad duuni ge'eman pa kampuun ri senaan. Ndi'u ngani' mbaya' ne mbaal ne gulipenen. Bendyagaan amu se Gispiritu Santu bu' gapuy. ");
INSERT INTO stb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Maa' giin ne getaw neng mikpalis ri giniiken nek trigu. Lainenen su ngang melengas ne dlegas buwat ri se gepis. Sung melengas ne dlegas, betangenen ri sek tibengan; ma'ad su gepis serengenen tu se gapuy ne gendi' na gaid mpaleng.” ");
INSERT INTO stb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na, ri seng meleget pa ne ngak pebiyan, minintulu' si Juan seng Melengas ne Gesuyen ri se nga getaw arun me'eseb ilan. ");
INSERT INTO stb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pimaag rema ni Juan si Herodes, su gobernador ri se Galilea, tendeng ay tinipungaan si Herodias, suk sawa nek pateren bu' meleget pa gaid sug binaal ni Herodes neng melaaten. ");
INSERT INTO stb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Rayun miksamet pa gaid suk sala' ni Herodes tendeng ay piperisuun si Juan. ");
INSERT INTO stb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na, peketubus mbendyagay ni Juan su nga getaw, si Jesus binendyagan rema. Saanay migampu' giin, mipuka su dlangit, ");
INSERT INTO stb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","rayun tinumena' seniin su Gispiritu Santu maa' ne gawi' nek selepati. Rayun duunik talu' neng mirengeg buwat se dlangit, laungen, “Dya'a suk pinetail'u neg Bata'. Pidleliyagu seni'a.” ");
INSERT INTO stb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sek pegatad ni Jesus ri sek terbahuun, mektelupulu' nai giddaren. Suk salasala migena'ena' ne si Jesus bata' ni Jose. Si Jose pelum, bata' ni Heli. ");
INSERT INTO stb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Heli bata' ni Matat. Si Matat bata' ni Levi. Si Levi bata' ni Melchi. Si Melchi bata' ni Jannai. Si Jannai bata' ni Jose. ");
INSERT INTO stb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Jose bata' ni Matatias. Si Matatias bata' ni Amos. Si Amos bata' ni Nahum. Si Nahum bata' ni Esli. Si Esli bata' ni Nagai. ");
INSERT INTO stb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagai bata' ni Maat. Si Maat bata' ni Matatias. Si Matatias bata' ni Semein. Si Semein bata' ni Josek. Si Josek bata' ni Joda. ");
INSERT INTO stb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Joda bata' ni Joanan. Si Joanan bata' ni Resa. Si Resa bata' ni Serobabel. Si Serobabel bata' ni Salatiel. Si Salatiel bata' ni Neri. ");
INSERT INTO stb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri bata' ni Melchi. Si Melchi bata' ni Adi. Si Adi bata' ni Cosam. Si Cosam bata' ni Elmadam. Si Elmadam bata' ni Er. ");
INSERT INTO stb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er bata' ni Joshua. Si Joshua bata' ni Eliezer. Si Eliezer bata' ni Jorim. Si Jorim bata' ni Matat. Si Matat bata' ni Levi. ");
INSERT INTO stb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Levi bata' ni Simon. Si Simon bata' ni Judah. Si Judah bata' ni Jose. Si Jose bata' ni Jonam. Si Jonam bata' ni Eliakim. ");
INSERT INTO stb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliakim bata' ni Melea. Si Melea bata' ni Mena. Si Mena bata' ni Matata. Si Matata bata' ni Nathan. Si Nathan bata' ni David. ");
INSERT INTO stb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David bata' ni Jesse. Si Jesse bata' ni Obed. Si Obed bata' ni Boaz. Si Boaz bata' ni Salmon. Si Salmon bata' ni Naason. ");
INSERT INTO stb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Naason bata' ni Aminadab. Si Aminadab bata' ni Admin. Si Admin bata' ni Arni. Si Arni bata' ni Hezron. Si Hezron bata' ni Perez. Si Perez bata' ni Judah. ");
INSERT INTO stb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Judah bata' ni Jacob. Si Jacob bata' ni Isaac. Si Isaac bata' ni Abraham. Si Abraham bata' ni Tera. Si Tera bata' ni Nahor. ");
INSERT INTO stb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor bata' ni Serug. Si Serug bata' ni Reu. Si Reu bata' ni Peleg. Si Peleg bata' ni Eber. Si Eber bata' ni Shela. ");
INSERT INTO stb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Shela bata' ni Cainan. Si Cainan bata' ni Arfacsad. Si Arfacsad bata' ni Sem. Si Sem bata' ni Noe. Si Noe bata' ni Lamek. ");
INSERT INTO stb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamek bata' ni Metusela. Si Metusela bata' ni Enoc. Si Enoc bata' ni Jared, Si Jared bata' ni Mahalaleel. Si Mahalaleel bata' ni Cainan. ");
INSERT INTO stb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Cainan bata' ni Enos. Si Enos bata' ni Set. Si Set kiin, giin na pelumig bata' ni Adan. Bu' si Adan keni, bata' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na, seng migawa' si Jesus buwat sek tubig Jordan, su ga'em nu Gispiritu Santu diin seniin, bu' inebayan rayun giin ne Gispiritu tu se kemingawan, ");
INSERT INTO stb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ne ritu tinintal giin ni Satanas se gepaat pulu' endaw. Se dlaun nek panahun ketu, nda' gaid giin aan, aas miperii'an giin seng mitektak su gepaat pulu' endaw. ");
INSERT INTO stb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Rayun miktalu' si Satanas riin ni Jesus, “Bu' dya'a sug Bata' ned Diwata, baal muig batu keni nek pan.” ");
INSERT INTO stb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma'ad miktalu' si Jesus, “Na, misulat ri se Kesulatan, ‘Gena' na run ri sek pekaan metubu' su getaw.’” ");
INSERT INTO stb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pituwad rayun ni Satanas si Jesus ditu seng metaas ne dlugar, sek sekemat pi'ita'en rayun riin ni Jesus su dlaun ne ngak pidlegeri'an rini sek tibuuk neg benwa. ");
INSERT INTO stb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Rayun miktalu' na pelum giin riin ni Jesus, “Begay'u seni'a su dlaun ne ga'em bu' keratu' rini seg benwa. Ay dlaunen keni binegay na senaan bu' mbegay'u ini isan ta' ne getaway run ne dliyagan'u begayan. ");
INSERT INTO stb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ni'a nai dlaunen keni, bu' sumimbaa ri senaan.” ");
INSERT INTO stb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma'ad miktalu' si Jesus, “Giin nini sung misulat ri se Kesulatan, ‘Simba mu su Ginu'u ned Diwata mu bu' giin ra suk penibeliyan mu!’” ");
INSERT INTO stb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dluwat itu, inuwit ni Satanas si Jesus ritu seg Jerusalem, pi'indegen rayun ritu se kinetaasan ne dlugar nek Templo. Miktalu' rayun giin riin ni Jesus, “Bu' dya'a sug Bata' ned Diwata, sampak'a tu se dlupa'. ");
INSERT INTO stb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ay misulat ri se Kesulatan, laung, ‘Sugu'en ned Diwata su ngag anghelen sek pegingat ri seni'a.’ ");
INSERT INTO stb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bu' laung rema ri se Kesulatan, ‘Sampenain'a nilan arun ndi' mesugat su nga geksud mu ri se ngag batu.’” ");
INSERT INTO stb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma'ad sinembag giin ni Jesus, “Laung ri se Kesulatan, ‘Ndi' mu pektintalay su Ginu'u ned Diwata mu.’” ");
INSERT INTO stb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sek peketubus tintalay ni Satanas si Jesus se dlaun nek pebiyan, binelengen reli' si Jesus. ");
INSERT INTO stb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Rayun mipuli' si Jesus se Galilea bu' diin seniin su ga'em nu Gispiritu Santu. Midlelaup su gesuyan metendeng ri seniin sek tibuuk ne nga dlugar. ");
INSERT INTO stb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Miktendu' giin riin se ngak pektiguman nu nga getaw Judeo bu' sinaya' giin se kada getaw. ");
INSERT INTO stb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Si Jesus minateng seng Nazaret, su dlunsud ned ditu giin miksibagel. Se Gendaw nek Pengulali, miritu giin sek pektiguman nu nga getaw Judeo sumala' seng mi'enaraan. Dayun migindeg giin arun sek pegbasa se Kesulatan. ");
INSERT INTO stb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tinulun seniin su dlinukut neg besaan ni propeta Isaias. Rayun bineklaten su dlinukut neg besaan bu' binasaan nini, ");
INSERT INTO stb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Su Gispiritu nu Ginu'u rini senaan, tendeng ay pinili' naun sek pegasuy se gempiya ne gesuyen tu se ngak pupus. Sinugu' naun arun sek pegasuy se kegewasan nu ngad dinaap bu' pe'uli'an su ngang mata ne ngag buta, mpegawas sud dinaagdaag ");
INSERT INTO stb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","bu' pesuun'u neng minateng na suk panahun ne dluwasen nu Ginu'u su nga getawaan.” ");
INSERT INTO stb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tubusen besaay, linukut puli' ni Jesus sug besaan bu' tinulunen puli' tu sek sineligan ri sek pektiguman nu nga getaw Judeo. Rayun migingkud puli' si Jesus. Tinenteng giin se dlaun ne nga getaw ri sek pektiguman, ");
INSERT INTO stb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","saanay miktalu' si Jesus senilan, “Keni neg bahin se Kesulatan mituman na ri se gendaw keni saanay minginengeg amu seg binasau seniyu.” ");
INSERT INTO stb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bu' tendeng run nitu, sinaya' giin ne dlaun ne nga getaw bu' mbageli ketingala nilan se kelengas gupiya ne ngak talu'en. Bu' laung nilan, “Ba, getaw keni, gena' ba giin sug bata' ra ni Jose?” ");
INSERT INTO stb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Bu' miktalu' giin, “Ali' bu' telu'en pa niyu senaan su galing: ‘Membebulung, una mu reli' bulungay su gegulingen mu!’ Migulugan ini ne su ngag betang neng mirengeg niyu nek pimbaal'u ritu se dlunsud ne Capernaum, baalen'u rema rini se dlugar ta. ");
INSERT INTO stb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma'ad telu'an'u amu seng metuud,” dugang nek talu' ni Jesus, “Nda'irunik propeta ned duwaten ri se gegulingenen ne dlunsud. ");
INSERT INTO stb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Penginengeg amu ri senaan: metuud neng meleget pai dlibun neg balu rini seng nasud neg Israel sek panahun ne si Elias giin pa suk propeta, bu' nda'irunid dupi' seled sek telu taun bu' tenga' bu' misegaran ne nga getaw su gembagel ne gutem ri sek tibuuk neng nasud. ");
INSERT INTO stb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma'ad nda' gaid sugu'ay ned Diwata si Elias tu isan ta' riin seg Israel. Ma'ad sinugu' giin ritu sek sala neg balu ne dlibun ne gena' Judeo neng mikengel se dlunsud ne iningelanan nek Sarepta nek sakup sek Sidon. ");
INSERT INTO stb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Giin da rema sung mihitabu' sek panahun ni Eliseo nek propeta, meleget ne nga getaw ritu seg Israel neng minlaru neng mekeendekendek ne dleruun ri sek panit ma'ad nda'iruni isan sala senilan nek pitelen. Si Naaman ra ne gena' Judeo nek taga Syria suk pitelen.” ");
INSERT INTO stb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Sek pekerengeg nu nga getaw run nini, dlaun nilan ned diin sek seled nek pektiguman nu nga getaw Judeo linengetan gupiya. ");
INSERT INTO stb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mingindeg ilan bu' binidlas nilan si Jesus pagaw tu se gawas ne dlunsud. Inagak nilan giin pagaw tu sed dibabaw neg bentud ne ritu mibetang su dlunsud nilan. Bu' mirepet ilan tu sek pampang, leddu'en nilan siya si Jesus. ");
INSERT INTO stb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma'ad linumesut si Jesus ri sek titenga' nilan bu' binelengen ilan. ");
INSERT INTO stb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Rayun miritu si Jesus se Capernaum, sala se dlunsud ri se Galilea neng mimandu' se nga getaw se Gendaw nek Pengulali. ");
INSERT INTO stb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sek pemandu' ni Jesus, mitingala gupiya su nga getaw tendeng ay miktalu' giin ned duuni kega'em. ");
INSERT INTO stb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ritu sek pektiguman nu nga getaw Judeo, duuni getaw nek sineleran neng melaat ne gispiritu; migbeksay giin neng mesekeg, ");
INSERT INTO stb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ii! Jesus nek taga Nazaret, landun bai dlabet mu senami? Mirinia ba arun pedlaatan ami? Mi'ilalau dya'a. Dya'a sug Bala'an nek sinugu' rini nud Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ma'ad pimaag ni Jesus sung menulay, “Ndi'a peksasak! Pegawa'a ri se getaw iin!” Diin sek titenga' nilan, linimbag nung melaat ne gispiritu su getaw rayun ginumuwa'. Ma'ad nda'en ra pegeelay su getaw. ");
INSERT INTO stb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mitingala gupiya su dlaun ne getaw ritu bu' miktalu' suk salasala ri senilan, laung nilan, “Landun maik pekpemandu' keni? Duuni ketenged bu' kega'em ne getaw keni sek pekpe'awa' se ngang menulay bu' megawa' ilan rayun.” ");
INSERT INTO stb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bu' su gesuyan metendeng riin ni Jesus midlelaup sek tibuuk ne dlugar. ");
INSERT INTO stb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na, migawa' ilan ni Jesus buwat ritu sek pektiguman bu' miritu ilan seg balay ni Simon. Seng minateng ilan ni Jesus ritu, tinelu'an giin, ne suk penugangan ni Simon ne dlibun mipanas gupiya. Aas inandyu' nilan si Jesus nek petelenen su dlibun. ");
INSERT INTO stb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ineklungan ni Jesus su dlibun bu' sinugu'en megawa' suk panasen, rayun mitelen. Migbuwat giin bu' migilak rayun ri senilan ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Seng misindep nai gendaw, inuwit ritu ni Jesus su nga getaw ne ngang minlaru ne dlainlain ne dleruun. Rayun dinepenen su gemegen tu sek salasala senilan bu' mitelen ilan. ");
INSERT INTO stb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Isan su ngang melaat ne gispiritu minggawas bu' migbeksay, “Dya'a sug Bata' ned Diwata!” Ma'ad pimaag bu' pigbe'eran ilan ni Jesus ne ndi' ilan mektalu' tendeng ay misuunan nilan ne giin sung metuud neng Misiyas. ");
INSERT INTO stb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sek pekeddali'endaw, migawa' si Jesus ritu se dlunsud bu' miritu giin se kemingawan. Ma'ad pinengaw giin ne nga getaw ritu. Ali' nilan mbaangay giin, inandyu' nilan ne ndi' reli' giin megawa' se dlugar nilan. ");
INSERT INTO stb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma'ad miktalu' si Jesus senilan, “Kina'enlan megwaliu pa rema se Gempiya ne Gesuyen tendeng sek pedlegari' ned Diwata tu se dlain ne nga dlunsud ay sinugu'u ned Diwata neg baalen nini.” ");
INSERT INTO stb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bu' rayun mikpeddayun si Jesus sek pegwali tu se ngak pektiguman se nga getaw Judeo tu seg Judea. ");
INSERT INTO stb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Duunik sala gendaw migindeg si Jesus tu se geksid ned danaw ne Genesaret arun sek pektendu'. Miktisek ritu seniin sung melaun ne nga getaw ay liyagan nilan neng menginengeg ri sek talu' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Saanay ni Jesus mektendu', mi'ita'en sud duwa' buuk nek sekayan ned dinumenggu' na ritu se geksid ned danaw bu' su ngang mengenginsera' mimenaug na sek pegugas ri se ngak pukut nilan. ");
INSERT INTO stb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bu' sinumakay si Jesus tu sek sala nek sekayan ne su gapu'en, si Simon, rayun inandyu'en si Simon nek tulurenen nini neng miika' tu sek tubig. Bu' seng mi'igin na suk sekayan, migingkud si Jesus tu sek sekayan bu' mimandu' tu se nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Peketubusen memandu' ritu, laung ni Jesus tu ni Simon, “Mekpelaud ita bu' ektak niyu su ngak pukut niyu arun mekelaam amu ne ngak sera'.” ");
INSERT INTO stb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Ma'ad Ginu'u,” miktalu' si Simon riin ni Jesus, “Se gebii ami na minginsera', ma'ad nda' ami gaid mekelaam. Ma'ad tendeng ay miktalu'a ne ektaken su ngak pukut, ektaken'u ini.” ");
INSERT INTO stb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bu' inektak nilan su ngak pukut nilan bu' meleget gupiya ne ngak sera' neng milaaman nilan bu' megaud na mpurut su ngak pukut nilan. ");
INSERT INTO stb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Rayun kinipayan nilan su ngak sementaun nilan tu se dlain nek sekayan arun ebangan ilan. Minateng ilan bu' pinenu' nilan ne ngak sera' sud duwa' buuk ne ngak sekayan neng megaud na meleddang su ngak sekayan nilan tendeng se keleget ne ngak sera'. ");
INSERT INTO stb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sek pekiita' run nini ni Simon Pedro, miginlulud giin ri seng metungenga'an ni Jesus, laungen, “Pelayu'a ri senaan, Ginu'u! Mekesesala'u ne getaw!” ");
INSERT INTO stb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Si Pedro bu' su ngak sementaunen mitingala ri se keleget ne ngak sera' neng milaaman nilan. ");
INSERT INTO stb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mitingala rema su ngad duma ni Simon ne si Santiago bu' si Juan ne ngag bata' ni Zebedeo. Dayun miktalu' si Jesus riin ni Simon, “Ndi'a mendek senaan. Gatad nandaw gena' na sera'ik penengaun mu, getaw na arun mekpesakup ilan ri senaan.” ");
INSERT INTO stb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Seng mirenggu' na su ngak sekayan nilan ri se geksid, bineleng nilan su dlaunen bu' tinumendug ilan rayun riin ni Jesus arun mekpesakup ilan ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sed ditu si Jesus sek sala ne dlunsud, bu' enlengay niyu, duuni getaw ritu neng midlaru seng mekeendekendek ne dleruun ri sek panit. Sek pekiita' nu getaw riin ni Jesus, middempug rayun giin bu' mikpe'ilelaat, “Ginu'u, bu' liyagan mu, petelen mau!” ");
INSERT INTO stb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Rayun tinenggal ni Jesus sug biingkenen arun depenaan su getaw bu' rayun miktalu', “Liyagan'u gaid neng me'uli'an'a nemuun!” Mirala' rayun seniin su dleruunen. ");
INSERT INTO stb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Peketubus itu, miktalu' si Jesus tu se getaw, “Isan ta' etaway run, nda'irunik telu'an mu metendeng run nini. Ma'ad dumiritsua tu sek pari' bu' mekpe'enleng'a tu seniin. Rayun meguwit'a neg halad tu sek pari' maa' sek sinugu' ni Moses, bu' suk salasala mekesuun neng mitelen'a na.” ");
INSERT INTO stb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma'ad su gesuyan metendeng riin ni Jesus midlelaup gupiya bu' meleget pai getaw neng miritu sek pekpenginengeg bu' pekpebulung ri se nga dleruun nilan. ");
INSERT INTO stb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma'ad miritu si Jesus se kemingawan arun sek pegampu'. ");
INSERT INTO stb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sala gendaw itu, seng mimandu' si Jesus, duuni ngak Pariseo, bu' ngang Menintulu' se Kesugu'an neng migingkud ritu neg buwat pa se kada ne dlunsud se Galilea, bu' Judea, bu' Jerusalem. Su ga'em ne Ginu'u diin ni Jesus sek pekpetelen ri se ngang minlaru. ");
INSERT INTO stb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mbuus, duuni nga getaw neng minateng neng migbulig ne getaw nek paralitiku ned diin sek puyuwan. Ali' ilan merepet tu seg balay, pinentuwan nilan neng me'uwit giin seng metungenga'an ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tendeng se kelaun ne getaw, nda'iruni gembiyanan nilan pagaw tu sek seled. Aas minaik ilan tu seng melantang ne gatep nek tisa' bu' inawa' nilan suk tisa'. Peketubus nilan uwa'ay, tinentun nilan suk paralitiku ned diin sek puyuwan tu seng metungenga'an ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sek pekiita' ni Jesus runik pektu'u nilan, miktalu' giin tu sek paralitiku, “Sambat, su ngak sala' mu pinasaylu na.” ");
INSERT INTO stb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Su ngang Menintulu' se Kesugu'an bu' su ngak Pariseo miksaak riin se nga gegulingen nilan, “Ta' getaw ma ini neng mikpesipala ri sed Diwata? Sud Diwata ra sung mekepasaylu ri se ngak sala'.” ");
INSERT INTO stb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Misuunan ni Jesus suk pigena'ena' nilan. Aas miktalu' giin senilan, “Tuma ma megena'ena' amu run neng maa' niin? ");
INSERT INTO stb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Landun maing melemu baalen suk pektalu', ‘Pinasaylu na su ngak sala' mu’ awas suk pektalu', ‘Gindeg'a rayun dlaang'a?’ ");
INSERT INTO stb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pi'ita'u seniyu ne sug Bata' ne Getaw duuni ga'emen sek pekpasaylu ri se ngak sala' rini seg benwa.” Rayun miktalu' si Jesus tu sek paralitiku, “Gindeg'a, inat mu suk puyuwan mu bu' uli'a.” ");
INSERT INTO stb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Migbuwat rayun ri seng metungenga'an nilan suk paralitiku ketu, ininaten sug bineliliraan, rayun minuli' neng miksaya' ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Rayun su nga getaw ritu mitingala! Sinaya' nilan sud Diwata bu' mi'endekan gupiya, laung, “Ketingelaan gupiya su ngang mi'ita' ta nandaw.” ");
INSERT INTO stb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Peketubus itu, ginumawas si Jesus bu' mi'ita'en si Levi neng meneningil neg buwis neng migingkud ritu rapit sek pegbiyaran neg buwis. Miktalu' si Jesus ri seniin, “Tala, dunut'a ri senaan.” ");
INSERT INTO stb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Bu' migindeg rayun si Levi, binelengen su dlaunen bu' midlendug riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mbuus duuni gembagel ne kebibu ritu seg balay ni Levi para riin ni Jesus. Bu' su ngag bisita ni Levi meleget ne ngang meneningil neg buwis bu' duma pa ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Sud duma ne ngak Pariseo bu' sud duma ne ngang Menintulu' ri se Kesugu'an neng misakup riin se dlumpuk nilan middiklamu tu se ngak tinu'unan ni Jesus, “Tuma ma maan bu' minum amu duma ri se ngang meneningil neg buwis bu' ri se ngang mekesesala' ne getaw?” miksaak ilan. ");
INSERT INTO stb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Miksembag si Jesus tu senilan, “Su getaw ne gempiya rai dlawasen nda' pedlekina'enlan neng membebulung, bu' ndi' su ngang minlaru ra. ");
INSERT INTO stb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nda'u perini arun sek pektawag ri se ngang metareng ma'ad ri se ngang mekesesala' arun meddiksu' ilan.” ");
INSERT INTO stb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sud duma ne getaw miktalu' riin ni Jesus, “Su ngak tinu'unan ni Juan bu' su ngak sakup nu ngak Pariseo kanunay mekpu'asa bu' megampu'; ma'ad suk tinu'unan mu minaan bu' miginum ma'aray.” ");
INSERT INTO stb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Bu' miksembag si Jesus senilan, “Kina'enlan ba su ngag bisita mekpu'asa saanay suk pemenaan midduma pa senilan? ");
INSERT INTO stb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma'ad matengik panahun ne suk pemenaan uwa'en na senilan, bu' dekag ilan pa mekpu'asa.” ");
INSERT INTO stb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Bu' migasuy na pelum si Jesus ne galing, “Nda'iruning mektabas sek sala neg bahin buwat seg begu nek penepeten arun tapak ri sed daan nek suub. Bu' baalenen ini, mberit sug begu nek penepeten; bu' suk tinapak gena' mbantang ri sed daan nek suub. ");
INSERT INTO stb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Bu' nda'iruning megurud neg begu neg binu ri sed daan ne ngak pemetangan neg binaal buwat ri sek panit. Sug begu neg binu medliguwak bu' mekepegbetu se ngak pemetangan. Rayun megula' sug binu bu' medlaat rema su ngak pemetangan. ");
INSERT INTO stb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ma'ad kina'enlan gaid ne sug begu neg binu riin betangay seg begu ne ngak pemetangan neg binaal buwat sek panit. ");
INSERT INTO stb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Bu' su getaw neng mi'anad na minum ri sed daan neg binu ndi' na menengaw ri seg begu neg binu, laung, ‘Melengas lai sud daan.’” ");
INSERT INTO stb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na, se Gendaw nek Pengulali, minayan ilan ni Jesus ri se ngak pigimulanan nek trigu. Saanay nilan ritu, mingati' nek trigu su ngak tinu'unan ni Jesus, binelisan nilan, rayun inaan. ");
INSERT INTO stb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma'ad sud duma ne ngak Pariseo miksaak, “Tuma ma baalen niyu su genda' tugut nek pebaal se Gendaw nek Pengulali?” ");
INSERT INTO stb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Miksembag si Jesus ri senilan, “Nda' amu ba mekebasa seg binaal ni David seng miperii'an giin bu' su ngak sementaunen? ");
INSERT INTO stb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Sinumeled giin seg balay nud Diwata bu' inuwanen suk pan neg hinalad tu sed Diwata, rayun inaanen. Binegayaan rema su ngak sementaunen isan nda' tugut ri se Kesugu'an ne aanen nilan, bu' ndi' su ngak pari' ra sung mekaan run.” ");
INSERT INTO stb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Miktalu' si Jesus tu senilan, “Sug Bata' ne Getaw giin sung megbe'et isan se Gendaw nek Pengulali.” ");
INSERT INTO stb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Se dlain na pelum ne Gendaw nek Pengulali, miritu si Jesus sek pektiguman ne nga getaw Judeo bu' mimandu' ritu. Bu' duuni dlai neng mingupes su dlintu ne gemegen. ");
INSERT INTO stb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sud duma ne ngang menintulu' ri se Kesugu'an bu' sud duma ne ngak Pariseo mini'id bu' bulungen ba su dlai se Gendaw nek Pengulali arun mesumbung nilan si Jesus. ");
INSERT INTO stb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma'ad misuunan ni Jesus su gena'ena' nilan. Aas tinelu'an ni Jesus su getaw neng mingupes su gemegen, “Gindeg'a, perinia se gunaan.” Migbuwat rayun su getaw bu' migindeg ritu se gunaan. ");
INSERT INTO stb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Rayun miktalu' si Jesus tu senilan, “Saakan'u amu: ‘Mektugut ba sug Bala'ud ta sek pegbaal neng melengas awas melaaten se Gendaw nek Pengulali? Luwasen ta bai ketubu' ne nga getaw se Gendaw nek Pengulali awas pesaddan ta ma'ad matay?’ ” ");
INSERT INTO stb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Dluwat enlengay ni Jesus su dlaun ne nga getaw riin sek timala', miktalu' rayun giin tu se getaw, “Etat mui gemeg mu.” Bu' binaalen rayun bu' mi'uli'an giin. ");
INSERT INTO stb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ma'ad linengetan gupiya su ngak Pariseo bu' ngang Menintulu' ri seg Bala'ud. Aas miksabut ilan bu' landunik sunud neg baalen nilan riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sek panahun ketu, tinumuwad si Jesus tu seg bentud arun megampu', bu' ritu, migampu' giin tu sed Diwata seled se gebii. ");
INSERT INTO stb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bena' pekegendaw, tinawagen su ngak tinu'unaan bu' pimili'en su ngak sepulu' bu' ruwa' senilan ne giningelanan rema ne gapustulis. ");
INSERT INTO stb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Pimili' ni Jesus si Simon ne giningelanan rema nek Pedro. Rayun si Andres, suk pated ni Simon, si Santiago, si Juan, si Felipe, bu' si Bartolome. ");
INSERT INTO stb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Rayun si Mateo, si Tomas, si Santiago ne su gama'en si Alfeo, rayun si Simon ne giningelanan ne getaw neng midlaban ri seng nasuren. ");
INSERT INTO stb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Rayun si Judas ne su gama'en si Santiago. Bu' si Judas Iscariote sung megbudhi' riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tubus itu, mindiksun ilan ni Jesus bu' su nga gapustulisen. Rayun migindeg si Jesus ritu se dlumbang. Midlumpuk ri seniin su ngang meleget gupiya nek sakup nu ngak tinu'unaan bu' su ngang meleget ne getaw neg buwat pa se nga dlunsud nek sakup seg Judea, seg Jerusalem, bu' se ngak siyudad nek Tiro bu' Sidon neng megaud sed dagat. ");
INSERT INTO stb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Minditu ilan arun menginengeg sek penintulu' bu' mekpebulung ri se ngang megeel nilan. Miritu rema su ngak pi'antus ne ngang mekelaat ne gispiritu bu' mi'uli'an ilan. ");
INSERT INTO stb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Minantu su dlaunen neng mekiikap riin ni Jesus ay duuni ga'em neg buwat seniin neng mikepetelen tu se dlaunan. ");
INSERT INTO stb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Inenlengan ni Jesus su ngak tinu'unaan bu' miktalu', “Pedleliyag amu ne ngak pupus, ay misakup amu sek pedlegeseg ned Diwata! ");
INSERT INTO stb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Pedleliyag amu ne ngang miperii'an numuun, ay pebesugen amu! Pedleliyag amu ne ngang minsegaw numuun; ay mentawa amu ra! ");
INSERT INTO stb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Pedleliyag amu gupiya bu' gemetan amu, bibain amu, tampela'en amu, bu' pementelu'an amu neng melaat ne nga getaw, dlaunen keni tendeng seg Bata' ne Getaw. ");
INSERT INTO stb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pedleliyag amu seng mehitabu' itu bu' pentalek sek pedleliyag, tendeng ay tinegana seniyu su gembagel ne ganti tu se dlangit. Ay giin remaig binaal ne nga gepu'an nilan tu se ngak propeta nud diin.” ");
INSERT INTO stb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ma'ad mekelelaatlelaat amu, gamu ne ngang meratu'; ay su gempiya nek pedleketubu' niyu, migela' na niyu me'uwan! ");
INSERT INTO stb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mekelelaatlelaat amu, gamu ne ngang mibesug numuun, ay mperii'an amu ra! Mekelelaatlelaat amu, gamu ne ngang mintawa numuun, ay megu'ul amu ra bu' mensegaw! ");
INSERT INTO stb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Bu' mekelelaatlelaat amu bu' siya'en amu nu dlaunan ne getaw, ay su nga gepu'an nilan miktalu' seng maa' ne ngag betang metendeng se gena' metuud ne ngak propeta.” ");
INSERT INTO stb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ma'ad gamu neng minginengeg ri senaan: Petail niyu su nga kuntra niyu bu' baal niyu sung melengas tu seng minggemet ri seniyu. ");
INSERT INTO stb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pengumpiyanay niyu su ngang mektuyud riin seniyu bu' pegempu'ay niyu su ngang mekpelaat riin seniyu. ");
INSERT INTO stb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bu' duunik tumampaling ri sek sepingi mu, petampaling mu rema ri seniin sud dibaluy. Bu' duuning mawi' run su dlambung mu, begay mu rema seniin suk suub mu. ");
INSERT INTO stb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Begayay mu sung menengi ri seni'a. Bu' duuning muwan runi ngag betang mu, ndi' mu na uwi'ay. ");
INSERT INTO stb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Baal niyu tu se nga getaw su dliyagan niyu neg baalen nilan seniyu. ");
INSERT INTO stb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Bu' giin raik petailen niyu su nga getaw neng mikpetail ri seniyu, mbaya' ba neng mekerawat amu nek pengumpiya? Isan ngani' su ngang mekesesala' ne getaw, pinetail ma nilan sung mikpetail ri senilan! ");
INSERT INTO stb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bu' giin daig baalan niyu neng melengas sung mikegbaal neng melengas ri seniyu, mbaya' ba neng mekerawat amu nek pengumpiya? Ay isan ngani' su ngang mekesesala' migbaal run nini! ");
INSERT INTO stb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bu' giin raik peramen niyu suk tinu'uwan niyu neng mekebayad, na, mbaya' ba neng mekerawat amu nek pengumpiya? Isan ngani' su ngang mekesesala' mikeperam ritu se ngad duma nilan bu' mesuunan nilan neng mekebayad ilan. ");
INSERT INTO stb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ma'ad petail tumu' niyu su nga kuntra niyu. Baalay niyu neng melengas suk samaataw niyu. Bu' mekperam amu ndi' amu na mekperateng ne gembiyaran amu pa. Bu' maa' niya sug baalen niyu, na gembagel gupiya suk pengumpiya niyu bu' mbaal amu ne ngag bata' nu Dlabi neng Metaas ned Diwata. Ay mpiya gaid giin isan se gendi' metau sumuli' bu' seng melaat ne getaw. ");
INSERT INTO stb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Aas, mengmelilelaaten amu rema maa' se Gama' niyu neng melilelaaten.” ");
INSERT INTO stb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ndi' niyu ukumay su ngak samaataw niyu bu' ndi' amu rema ukuman ned Diwata. Ndi' niyu pesela'ay su ngak samaataw niyu bu' ndi' amu rema pesela'en ned Diwata. Pasaylu niyu su ngak samaataw niyu bu' pasayluun amu rema ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Begayay niyu suk samaataw niyu bu' begayan amu rema ned Diwata. Bu' megbegay sud Diwata seng meleget gaid, maa' ne inengkug nek tekesan, tinisek, bu' tampan medlapay se gendi' pa bunagen ri sek tegu'an niyu. Ay bu' gendun kelaun suk pegbegay niyu ri sed duma, giin da remaik pegbegay ned Diwata riin seniyu.” ");
INSERT INTO stb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Rayun miktalu' si Jesus tu se nga getaw ne galing: “Suk sala neg buta ndi' mekegagak ri se dlain neg buta. Bu' baalenen ini, gilan duwa' meladdu' ri se kanal. ");
INSERT INTO stb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nda'irunik tinu'unan neng melengas kampun ri seng menintulu'en. Ma'ad suk tinu'unan, bu' meketubus giin ri sek pektu'unen, maa' na giin seng menintulu'en.” ");
INSERT INTO stb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Lama me'ita' mu run sung miika' nek puling ri seng mata nek samaataw mu, ma'ad pisaddan mui gembagel ne gayu ri seng mata mu? ");
INSERT INTO stb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pegendun mu ma sek pektalu' ri sek samaataw mu, ‘Ated, perinia, uwa'en'u pa reli' suk puling mu ri seng mata mu kiin,’ ne nda' mu ma ngani' me'ita' su gembagel gayu ned diin seng mata mu? Ba, mikpelaunglaung'a! Una mu reli' uwa'ay su gembagel ne gayu ned diin seng mata mu. Rayun seng mekiita'a na, pulu' mu pa me'awa' sung miika' nek puling ri seng mata nek semaataw mu.” ");
INSERT INTO stb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Rayun miktalu' si Jesus, “Su gayu neng melengas ndi' memunga neng melaaten, bu' su gayu neng melaaten ndi' rema memunga neng melengas. ");
INSERT INTO stb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kada gayu me'ilala ri seg bungaan. Ndi'a mekuupu' neg igira buwat ri sek sebinit awas gubas buwat ri se geksam. ");
INSERT INTO stb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sung melengas ne getaw megasuy neng mekelengas ne ngag betang ay melengas ma su gena'ena'en. Ma'ad sung melaat ne getaw megasuy rema seng mekelaat ne ngag betang ay melaat ma su gena'ena'en. Ay landunid diin se gena'ena' ne getaw, giin rema sung me'asuyen.” ");
INSERT INTO stb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Tuma ma mektawag amu ma ri senaan, ‘Ginu'u, Ginu'u,’ ma'ad ndi' amu ma megbaal ri sek sinugu'u seniyu? ");
INSERT INTO stb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Isan ta' etaway run neng mekpegaud ri senaan bu' menginengeg se ngak talu'u bu' tumanenen nini, pe'ita'u seniyu bu' ta' giin mpetanggi'. ");
INSERT INTO stb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Maa' giin nu getaw neng migbakud neg balay. Midlalud giin neng meralem tampan mirepet sug batu. Dayun pinindegen su ngak pasek nug balain ri sek penligen neg batu. Sek peketubus na nug balain, migbaa' suk tubig bu' linumanlag sug buntal ri seg balay ma'ad nda' ngani' mekedyug ay meligen ma suk pekebakud run. ");
INSERT INTO stb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Na, bu' su getaw neng menginengeg ri sek talu'u bu' ndi' mektuman run nini, maa' giin nu getaw neng migbakud neg balay ne nda'en perelemay su dlaluren para ri se ngak pasek bu' nda'en bekuray ri sek penligen neg batu. Sek pedlanlag neg baa' ri seg balain, mibuksak rayun nini bu' mibengkag gaid sug balay.” ");
INSERT INTO stb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sek peketubus ni Jesus sek pektalu' se dlaun neg betang keni tu se dlaun ne getaw, miritu giin se dlunsud ne giningelanan ne Capernaum. ");
INSERT INTO stb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Bu' ritu, duuni geseg nek sundalu ne getaw Roma ned duunik sesugu'enen nek pinetailen gupiya; midlaru ini bu' megaud na matay. ");
INSERT INTO stb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bu' sek pekerengeg run nu geseg metendeng riin ni Jesus, miksugu' giin ned duma ne nga geseg nu nga getaw Judeo sek pegandyu' ri seniin neng meritu giin arun petelenen suk sesugu'enen. ");
INSERT INTO stb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bu' miritu ilan rayun ni Jesus bu' migandyu' gaid seniin, “Su geseg, mbaya' mu gaid ebangan, ");
INSERT INTO stb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tendeng ay pinetailen su nga getaw ta bu' giining mikpebakud dun suk pektiguman nami.” ");
INSERT INTO stb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aas middunut si Jesus senilan. Bu' seng megaud ilan na tu seg balay nu geseg nek sundalu, miksugu' na peluman su geseg ri se ngak sambaten sek peksungkak riin ni Jesus arun petendayan, “Sir, ndi' mu na lubayay su gegulingen mu. Ay gena'u mbaya' ne dlawan mau pa seg balay'u. ");
INSERT INTO stb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Bu' nda'u ilelaay su gegulingen'u ne mbaya' megatubang seni'a. Ma'ad talu' mu na run bu' me'uli'an suk sesugu'en'u. ");
INSERT INTO stb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ay gaku' rema pidlegesegan ne nga dlabaw geseg, bu' duun remai ngak sundalu nek pidlegesegan'u. Bu' sugu'en'u suk sala tawan, ‘Pedlaang'a,’ medlaang rayun giin. Bu' sugu'en'u suk sala ketu, ‘Perinia,’ merini giin. Bu' sugu'en'u su gulipen'u, ‘Baal mu ini,’ baalenen rayun.” ");
INSERT INTO stb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sek pekerengeg run ni Jesus sek tinalu'en, mitingala run gaid gupiya. Bu' inatubangen rayun su nga getaw neng mindunut seniin bu' miktalu', “Talu'u gaid seniyu, nda'u pa gaid mekiita' isan sala tawan rini seg Israel neng maa' sek peksalig ne geseg keni.” ");
INSERT INTO stb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bu' sek pekpuli' nilan tu seg balay ne geseg, mi'ita' nu ngak sinugu' neng mitelen na suk sesugu'enen. ");
INSERT INTO stb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bu' dluwat itu, miritu si Jesus se dlunsud ne giningelanan neng Nain, duma nu ngak tinu'unaan bu' melaun gupiya ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na, sek peddateng nilan ni Jesus tu seng megaud ne genga'an nu dlunsud, mi'ita' nilan su nga getaw neng migbulig neng minatay. Minatay keni buntung bata' dlai nug balu ne dlibun. Bu' meleget getaw neg buwat se dlunsud neng middunut ri seniin arun sek pedlebeng seng minatay neg bata'en. ");
INSERT INTO stb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bu' sek pekiita' nu Ginu'u se gina' nung minatay, milelaat gupiya giin, laungen, “Ndi'a na peksegaw.” ");
INSERT INTO stb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mbuus mikpegaud rayun si Jesus bu' inuwiraan sug binetangan neng minatay. Bu' su nga getaw neng migbulig seng minatay mikeneng rayun. Miktalu' si Jesus tu seng minatay, “Eddung, talu'u seni'a, pegbuwat'a.” ");
INSERT INTO stb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Bu' sug bata' migingkud bu' migabit. Binegay rayun giin ni Jesus tu se gina'en. ");
INSERT INTO stb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bu' su dlaun ne nga getaw neng mikiita', mi'endekan gupiya bu' sinaya' nilan rayun sud Diwata. “Su ge'eman nek propeta keni na senita!” laung nilan, “Minateng na sud Diwata sek pedluwas senita.” ");
INSERT INTO stb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bu' gesuyan keni metendeng riin ni Jesus midderengeg sek tibuuk neg Judea bu' ri sed duma nek timala' ne nga dlugar. ");
INSERT INTO stb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tinelu'an si Juan nu ngak tinu'unaan metendeng se dlaun ne ngag betang keni, pitawag rayun ni Juan sud duwa' ne ngak tinu'unaan, ");
INSERT INTO stb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","bu' sinugu'en ilan neng meritu se Ginu'u arun sek peksaak ri seniin, “Sir, dya'a ba suk sala nek pikperateng nami neng mateng? Awas mekperateng ami pa ba ri se dlain?” ");
INSERT INTO stb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bu' sek peddateng nu ngak sinugu' ni Juan tu ni Jesus, laung nilan, “Sir, sinugu' ami ni Juan neng Membebendyag. Pimuunan ami nek saakan'a raw bu' dya'a ba sung Menleluwas nek pikperateng nami neng mateng? Awas mekperateng ami pa ba ri se dlain?” ");
INSERT INTO stb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sek panahun ketu, pitelen ni Jesus sung meleget ne nga getaw neg buwat ri se nga dleruun nilan bu' se ngang megeel; bu' pi'awa' sung melaat ne nga gispiritu tu se ngak pinseleran; bu' pipe'ita'en sung meleget ne ngag buta. ");
INSERT INTO stb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bu' sinembag ni Jesus su ngak sinugu' ni Juan, “Puli' amu ritu ni Juan, esuyay niyu giin se dlaun neng mi'ita' bu' mirengeg niyu. Su ngag buta, mikiita' na. Su ngag bekul, mikedlaang na. Su ngang minlaru ri seng mekeendekendek ne dleruun ri sek panit, mitelen na. Bu' su ngag bengel mikerengeg na. Isan ngani' su ngang minatay, mitubu' na puli'. Bu' su ngak pupus ne nga getaw tinintulu'an na ne Gempiya ne Gesuyen. ");
INSERT INTO stb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pedleliyagen su nga getaw ne genda' penduwa'ruwa' ri senaan!” ");
INSERT INTO stb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bu' seng mikedlaang na su ngak sinugu' ni Juan, migasuy si Jesus tu seng meleget ne nga getaw metendeng riin ni Juan: “Sek pedditu niyu ni Juan se kemingawan, landun maik pikperateng niyu neng me'ita'? Laung ba niyu run ne si Juan keni maa' sek sala puun nek tigbaw neng melemu ra mpilay ne genus? Ba, gena'. ");
INSERT INTO stb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Landun ma gaid su dlinawan niyu enlengay ritu? Laung ba niyu run maa' nek sala tawan neng melengasik sineluken? Ba, gena'. Su getaw neng melengasik sineluken bu' melengasi kebetangen ritu ra mbaangay se ngak palasyu ne gari'. ");
INSERT INTO stb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Landun ma rayuni dlinawan niyu ritu? Miritu amu ba sek pegenleng nek propeta? Wa'a metuud lai, ma'ad si Juan gena' na run nek propeta, ");
INSERT INTO stb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","tendeng ay si Juan, giining misakup ri se ginatuk neng misulat ri se Kesulatan: ‘Miktalu' sud Diwata, sinugu'u suk sesugu'en'u neng meguna riin seniyu arun endamenen sug biyanan para seniyu.’ ");
INSERT INTO stb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Esuyan'u amu rema,” middugang sek pektalu' si Jesus, “Si Juan, giini dlabaw tu se dlaun ne getaw neng mi'etaw ri seg benwa keni. Ma'ad ta' ma suk tampusan ne gembaba' ne getaw ri sek pedlegari' nud Diwata, giini dlabaw pa riin ni Juan.” ");
INSERT INTO stb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Na, mikerengeg seniin su dlaun ne getaw bu' isan su ngang meneningil neg buwis. Tinuman nilan sung metareng nek sugu' ned Diwata bu' mikpebendyag ilan riin ni Juan. ");
INSERT INTO stb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma'ad su ngak Pariseo bu' su ngang Menintulu' ri se Kesugu'an, binibay nilan su ketuyu'an ned Diwata para ri senilan, bu' nda' ilan pekpebendyag riin ni Juan.) ");
INSERT INTO stb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Bu' mikpeddayun sek pektalu' si Jesus, “Nemuun, landun maik petenggi'an'u run su nga getaw se gendaw keni? Landun ma kelasiyay ilan run ne getaw? ");
INSERT INTO stb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Maa' ilan ne nga gembata' neng migingkud ri sek tebu'an neng migbebeksayay, ‘Mikpuung ami ne gagung ma'ad nda' amu pentalek! Kinentaan amu nami ne kanta para ri seng minatay ma'ad nda' amu pensegaw!’ ");
INSERT INTO stb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Si Juan neng Membebendyag minateng, bu' mikpu'asa giin, bu' nda' inum neng mekebeleng, bu' miktalu' amu, ‘Duuning menulay ri seniin!’ ");
INSERT INTO stb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Minateng sug Bata' ne Getaw, minaan giin bu' miginum, bu' miktalu' amu, ‘Enlengay niyu getaw keni! Mesekeg giin maan bu' mesekeg megbinabeleng, sambat ne ngang meneningil neg buwis bu' ngang mekesesala' ne getaw!’ ");
INSERT INTO stb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ma'ad, isan bu' giin itu suk tinalu' niyu, su ginsaktu nek tinawan ned Diwata me'ita' ri se nga ketubu' nu nga getaw neng middawat run nini.” ");
INSERT INTO stb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Duunik sala tawan se ngak Pariseo neng migenggat riin ni Jesus sek pekaan ri seg balain. Bu' sek peddateng ni Jesus ritu, migingkud giin arun maan. ");
INSERT INTO stb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Bu' enlengay niyu, duuni dlibun neng mi'elelaan neng mekesesala' se dlunsud ketu. Seng mirengegaan ne si Jesus minaan ritu seg balay nek Pariseo, miritu giin bu' miguwit neng mitut ne gemputi' ne gamang neng mipenu' nek pegemut ");
INSERT INTO stb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","bu' migindeg giin ri se dliyu ni Jesus. Megaud ri se geksuren, miksegaw giin bu' mibasa' su nga geksud ni Jesus ri se dluwa'en. Pinunasaan rayun neg buuken su nga dluwa', pigelekaan su nga geksuren ne gilelaan sek pegbasaan ri seniin, bu' binunagaan rema nek pegemut su nga geksuren. ");
INSERT INTO stb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Bu' sek pekiita' run nuk Pariseo neng migenggat riin ni Jesus, miktalu' giin ri se gegulingenen, “Bu' getaw keni metuud pa nek propeta, mesuunaan siya bu' laa libunay run nini neng migikap ri seniin bu' gendun kelaat su ketubu'en.” ");
INSERT INTO stb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Bu' miktalu' rayun si Jesus seniin, “Simon, duunik talu'u seni'a.” “Ala, Sir, esuyay mau,” Si Simon miksembag. ");
INSERT INTO stb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Duunid duwa' tawan neng mingutang ne kuwarta ri seng mempepe'utang,” migatad si Jesus. “Suk sala tawan inutangan giin ne dlima gatus nek pelata. Suk sala, dlima pulu' ra. ");
INSERT INTO stb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mbuus sud duwa' ketu neng mingutang ndi' na mekebayad, aas nda' ilan na ma'ad pebiyaray seng mikpe'utang ri senilan.” Bu' middugang sek pektalu' si Jesus, “Ta' ma sakan ri senilan duwa' sung mekpetail kampuun seng mikpe'utang ri senilan?” ");
INSERT INTO stb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Bu' laung ni Simon, “Ali' bu' su getaw neng mikeram neng melaun ne kuwarta bu' nda' pebiyaray.” “Metuud gaid!” miksembag si Jesus. ");
INSERT INTO stb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bu' liningay ni Jesus su dlibun bu' miktalu' riin ni Simon, “Mi'ita' mu bai dlibun keni? Miriniu seg balay mu, bu' nda' mau begayay nek tubig arun me'ugasan'u siya su nga geksud'u. Ma'ad inugasan nu dlibun keni su nga geksud'u se dluwa'en bu' pinunasaan rema seg buuken. ");
INSERT INTO stb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Dya'a, nda' mau elekay ri se ngak sepingi sek pekpe'ita' ned dinawat mau. Ma'ad giin, gatad pa sek peddateng'u, nda'en peleliyay pegelekay su nga geksud'u. ");
INSERT INTO stb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Dya'a, nda' mu bunagay ne dlana su guluu. Ma'ad dlibun keni, pi'emutaan su nga geksud'u. ");
INSERT INTO stb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aas esuyan'u dya'a, ne su gembagel nek pekpetailen neng mipe'ita'en ri senaan mikpemetuud ne sung meleget ne ngak sala'en, pinasaylu na. Ma'ad ri se getaw neng miika' ra suk sala' nek pinasaylu run, miika' ra remaik pekpetail ne gempe'ita'en.” ");
INSERT INTO stb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bu' miktalu' rayun si Jesus tu se dlibun, “Pinasayluu na su ngak sala' mu.” ");
INSERT INTO stb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bu' su ngak sementaun ni Jesus neng minaan ritu, ali' nilan merengeg suk tinalu'en, miktalu' ilan ri se gegulingen nilan, “Ta' mai getaw keni ne isan suk pekpasaylu ne ngak sala' mbaalen?” ");
INSERT INTO stb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Bu' miktalu' puli' si Jesus tu se dlibun, “Suk pektu'u mu, giin sung midluwas seni'a; uli'a ned duuni kelinaw.” ");
INSERT INTO stb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Se genda' mpayat, miritu si Jesus se nga dlinunsuran bu' se ngag binaryuan ne ritu migwali giin se Gempiya ne Gesuyen metendeng ri sek pedlegari' ned Diwata. Duma ni Jesus suk sepulu' bu' ruwa' ne ngak tinu'unaan, ");
INSERT INTO stb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","bu' sek santa' tawan ne dlibun neng mi'uli'an buwat seleray seng melaat ne nga gispiritu bu' nga dleruun. Suk sala senilan si Maria (ne giningelanan neng Magdalena), suk piguwa'an sek pitu buuk ne ngang menulay. ");
INSERT INTO stb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Bu' si Juana, suk sawa ni Cusa nek sineligan ni Herodes sek palasyu. Ditu rema si Susana bu' duma pa ne nga dlibun neng migabang ri senilan ni Jesus pebiyan ri se nga ketigeyunan nilan. ");
INSERT INTO stb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bu' sek panahun ketu, duuni nga getaw ne kanunay mektipung duma ni Jesus, buwat ilan se dlaun ne nga dlinunsuran. Bu' ali' ilan na pektipung, inesuyaan ilan rayun ne galing: ");
INSERT INTO stb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Duunik sala tawan neng miritu seg binaal arun meksigwag ne ngag beni'. Bu' ali' giin peksigwag, duuni ngag beni' neng mitena' ri sed dalan neng me'indegan ma'ad bu' pingektuk ne ngang manuktalun. ");
INSERT INTO stb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Duun rema ne ngag beni' neng mitena' se nga dlupa' neg betuwan. Bu' ali' pentubu', milawes ay mimala ma su dlupa'an. ");
INSERT INTO stb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Duun pai ngag beni' neng mitena' ri se nga dlupa' ned duuni ngak sigbet ned dugiyan run. Bu' ali' pentubu' su ngak sinigwag, mintubu' rema su ngak sigbet ned dugiyan bu' linemesen su ngak pigimula. ");
INSERT INTO stb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Duun pa gairi ngag beni' neng mitena' ri seng melengas ne dlupa', mintubu' ini bu' su kada sala mimunga nek pingmegatus.” Bu' tinubus ni Jesus su galing, “Gamu ne ngang mikerengeg run nini, penginengeg amu!” ");
INSERT INTO stb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na, miksaak su ngak tinu'unan ni Jesus bu' landuni gulugani galing ketu. ");
INSERT INTO stb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Bu' sinumembag si Jesus, “Su nga ginedlud metendeng sek pedlegari' ned Diwata binegay na riin seniyu, ma'ad ri sed duma tinalu' ini pebiyan ri se nga galing arun isan megenleng ilan, ndi' nilan mekelaru bu' isan merengeg nilan, ndi' nilan mesabut.” ");
INSERT INTO stb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Na, pesabut'u ri seniyu su gulugan ne galing: Sug beni' giin suk talu' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bu' su ngag beni' neng mitena' ri sed dalan, giin su nga getaw neng mikerengeg sek talu' ned Diwata; rayun mituwa' sung Menulay bu' inawa'en sung minsahi ri se ngak pusung nilan, arun ndi' ilan mekpetuud bu' ndi' ilan meluwas. ");
INSERT INTO stb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na, su ngag beni' neng mitena' ri se dlupa neg betuwan, gilan su ngang mikerengeg ri seng minsahi. Bu' dinawat nilan ini ned duunik pedleliyag run. Ma'ad sung minsahi nda' mekepengganget neng meralem ri senilan tendeng ay miktu'u ilan ma'aray sek sereluk. Ali' mateng suk peksulay, tineliyuran nilan suk pektu'u nilan. ");
INSERT INTO stb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bu' su ngag beni' neng mitena' ri se ngak sigbet ned dugiyan, gilan sung minginengeg ri sek talu' ned Diwata, ma'ad su nga kegules, su nga keratu', bu' su nga dleliyag rini seg benwa linumemes ri sek pektu'u nilan, bu' su ngag bunga nilan nda' pengginug. ");
INSERT INTO stb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na, su ngag beni' neng mitena' ri se gempiya ne dlupa', gilan sung minginengeg ri seng minsahi neng mikengganget ri seng melengas bu' metinuuren nek pekeetaw nilan. Bu' mikpeddayun ilan ri sek pektu'u nilan tampan mimunga ilan.” ");
INSERT INTO stb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Bu' miktalu' pa gaid si Jesus, “Nda'iruni getaw neng mektutud nek sulu' bu' edluren riin sed diyalem ne gamang awas betangenen ri sed diyalem ne dlantay. Bu' ndi', riin gaid betangay sek pengenturan arun merelaagan su ngak sumeled tu seg balay. ");
INSERT INTO stb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Landuni ginedlud nemuun mbaangan ra. Bu' landuni dlinimed nemuun, mperayag ra. ");
INSERT INTO stb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Aas pekpetigaam amu sek pekpenginengeg niyu, ay sud duunik pektu'uun, begayan ned dugang, ma'ad su genda'iruning niin, uwanen pa ngani' buwat seniin isan sung miika' nek pektu'u nek pigena'ena'en ned diin seniin.” ");
INSERT INTO stb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mbuus miritu ni Jesus su gina'en bu' su ngak pateren. Ma'ad nda' ilan mekepegaud ri seniin tendeng se keleget ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bu' duuni getaw neng miktalu' riin ni Jesus, “Su gina' mu bu' su ngak pated mu mingindeg ditu se gawas bu' liyagan nilan ne kumita' ri seni'a.” ");
INSERT INTO stb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ma'ad miktalu' si Jesus tu se dlaun nilan, “Su gina'u bu' su ngak pated'u, gilan su ngang menginengeg tu sek talu' ned Diwata bu' miktuman run nini.” ");
INSERT INTO stb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sala gendaw itu, si Jesus sinumakay ri sek sekayan duma ri se ngak tinu'unaan, bu' laungen ri senilan, “Dumipag ita tu sed danaw.” Bu' dinumipag ilan rayun. ");
INSERT INTO stb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bu' saanay nilan meddipag, miketulug si Jesus. Bu' se genda' mpayat, mitikmal sung metikteg ne genus. Bu' suk sekayan miseleran nek tubig. Bu' megaud ilan na meleddang. ");
INSERT INTO stb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bu' linawan rayun nu ngak tinu'unan si Jesus bu' tinanud nilan, “Ginu'u! Ginu'u! megaud ita na meleddang!” Bu' migbuwat si Jesus, pimendu'aan su genus bu' su ngang melandes neg baled. Bu' sinumikpa' sung metikteg ne genus bu' su ngang melandes ne ngag baled, bu' linumengen rayun sud danaw. ");
INSERT INTO stb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bu' miksaak giin tu se ngak tinu'unanen, “Ta' nema su ngak pektu'u niyu?” Bu' mitingala ilan bu' mi'endekan, “Ta' ma getaw keni? Ali'en pemaagay su nga genus bu' su ngag baled, mikpetuud ma riin seniin!” ");
INSERT INTO stb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bu' mikpeddayun ilan menekayan tampan si Jesus bu' su ngak tinu'unaan mirenggu' ditu se dlugar ne gingelanan ne Gerasa ned dipag danaw buwat sek probinsiya ne Galilea. ");
INSERT INTO stb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bu' ali' kawas si Jesus ri sek sekayan, linabet giin ne getaw nek pinulayan buwat se dlunsud ketu. Getaw keni nda' na pekpenuub se gempayat na nek panahun bu' genda' na pekengel ri seg balay ay ritu na giin mikengel se nga dlangeb neg binaal ne kelebengan. ");
INSERT INTO stb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ali'en me'ita' si Jesus, migbakal giin, middempug seng metungenga'aan bu' migbeksay, “Jesus, Bata' nu Dlabi neng Mekegega'em ned Diwata landun maik tuyu' mu riin senaan? Mekpe'ilelaatu ri seni'a ne ndi' mau silutay.” ");
INSERT INTO stb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tinalu'en nini tendeng ay sinugu' ma ni Jesus sung melaat ne gispiritu ne gumawas ri seniin. (Se keleget ne ngak panahun, getaw keni pidlege'eman neng melaat ne gispiritu. Kinadinaan su nga gemegen bu' su nga geksuren bu' pibentayan pa gaid giin, ma'ad bektusenen su nga kadina bu' uwiten giin nung menulay ritu se kemingawan.) ");
INSERT INTO stb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Bu' sinaakan giin ni Jesus, “Ta' mai ngalan mu?” Bu' miksembag giin, “Si Linibulibu.” Sug rasun nek tinalu'en nini tendeng ay meleget gupiyai ngak penulay neng midlega'em ri se getaw keni. ");
INSERT INTO stb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bu' su ngak penulay migubug riin ni Jesus ne gendi' ilan pa reli' peperituun se kinariyaleman arun ritu ilan silutay. ");
INSERT INTO stb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bu' gena' melayu' buwat ritu, duunik panen ne ngag babuy neng mikpenlungad ri seg biliran. Bu' migandyu' su ngang menulay riin ni Jesus nek tugutan ilan sumeled tu se ngag babuy bu' tinugutan ilan. ");
INSERT INTO stb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mbuus minggawas rayun su ngang menulay buwat ritu se getaw bu' sinumeled ilan ritu se ngag babuy. Bu' suk sala nek panen ne ngag babuy minikad mendiksun ritu sek pempangan pagaw sed danaw. Bu' migela' ilan melemes. ");
INSERT INTO stb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bu' seng mi'ita' nu ngang migingat run su ngag babuy, minggebek ilan rayun bu' pingasuy nilan su ngang mihitabu' ritu se nga dlunsud bu' ritu se ngag binaal. ");
INSERT INTO stb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mbuus minditu su nga getaw arun megenleng tu se ngang mihitabu'. Ali' ilan mateng tu ni Jesus, mitaangan nilan su getaw ne dluwat piguwa'an ne ngang menulay, mikpegingkud giin ri seng megaud ne geksud ni Jesus. Minuub na bu' melengas naik pengena'ena'en. Bu' tendeng run nitu, minendek ilan gupiya. ");
INSERT INTO stb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bu' su nga getaw neng mikiita' riin ni Jesus neng mikpetelen ri se getaw ketu, inesuyan nilan su nga getaw bu' pikunta' run sek pekpetelen su getaw nek pinulayan. ");
INSERT INTO stb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bu' su dlaun ne nga getaw neng mikengel se nga dlugar nek sakup ne Gerasa, migandyu' riin ni Jesus neng megawa' giin ritu tendeng ay minendek ilan gupiya. Aas sinumakay si Jesus sek sekayan bu' migawa' ritu. ");
INSERT INTO stb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bu' su getaw nek piguwa'an nu ngang menulay migandyu' riin ni Jesus nek perunuten giin. Ma'ad pi'uli' giin ni Jesus, ");
INSERT INTO stb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uli'a bu' pengasuy mu sug binaal ned Diwata ri seni'a.” Bu' tendeng run itu, midlaang su getaw ketu, bu' linaupen pengasuy tu se dlunsud su dlaun neg binaal ni Jesus ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bu' seng mipuli' si Jesus ditu sed dipag danaw, su nga getaw midderiyal ri seniin tendeng ay su dlaun nilan mikperateng ma seniin. ");
INSERT INTO stb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Bu' ritu, minateng su getaw ne giningelanan ne si Jairus, geseg ri sek pektiguman nu getaw Judeo. Middempug giin ri seng metungenga'an ni Jesus neng mikpe'ilelaat neng meritu giin seg balain ");
INSERT INTO stb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ay megaud na matay sug buntung bata'en ne dlibun nek sepulu' bu' ruwa' taun nai giddaren. Bu' si Jesus middunut ri seniin bu' saanay nilan medlaang, meleget gupiya ne nga getaw sung mindunut ri seniin bu' mi'isel na giin nu nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bu' ritu, duuni dlibun neng midlaru seled sek sepulu' bu' ruwa' taun na sek peddugu'rugu' bu' genda' gaid pelali. Migela' na megastu su dlaun ne ngak selapi'en sek pekpebulung ri se ngang membebulung, ma'ad nda'irun gairing mikepetelen ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bu' minigel giin ri se geletelet ne nga getaw tampan mikepegaud giin ri sek teliyuran ni Jesus bu' inikapen su kumiling nek suuben. Bu' milali rayun suk peddugu'rugu'en. ");
INSERT INTO stb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Bu' miksaak si Jesus, “Ta' ma getaw sung minikap ri senaan?” Mimalaw su dlaun ne nga getaw ma'ad miktalu' si Pedro, “Ginu'u, linibutan'a neng meleget ne nga getaw bu' minisel seni'a.” ");
INSERT INTO stb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma'ad si Jesus miktalu', “Duun gairing minikap ri senaan tendeng ay binatik'u ned duuni ga'em ne ginumawas ri senaan.” ");
INSERT INTO stb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Bu' seng mibetikan nu dlibun neng misuunan ni Jesus sung minikap ri seniin, mikpegaud giin neng mikpengereg bu' middempug ri seng metungenga'an ni Jesus. Sek titenga' nu nga getaw, tinabalen tuma ma inikapen si Jesus bu' pikunta' run neng mitelen rayun giin. ");
INSERT INTO stb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Bu' miktalu' si Jesus seniin, “Eddang, suk peksalig mu mikepetelen ri seni'a. Uli'a na ned duuni kelinaw mu.” ");
INSERT INTO stb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Saanay migegabit pa si Jesus tu se dlibun, duuning minateng nek sinugu' buwat seg balay ni Jairus. Bu' tinelu'an nilan si Jairus, “Sug bata' mu miguna na tu se dlain neg benwa. Ndi' mu na peperituay sung Menintulu' kiin.” ");
INSERT INTO stb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bu' ali' itu merengeg ni Jesus, miktalu' giin tu ni Jairus, “Ndi'a mendek. Mektu'ua, sug bata' mu me'uli'an ra.” ");
INSERT INTO stb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sek peddateng ni Jesus tu seg balay ni Jairus, nda'irunik tinugutaan nek sumeled gawas riin ni Pedro, Juan, Santiago bu' su ngang megulang nug bata'. ");
INSERT INTO stb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bu' su dlaun ne getaw ri seg balay mimbakal, piksegawan nilan sug bata'. Bu' miktalu' si Jesus ri senilan, “Na, ndi' amu mensegaw, bata' kiin, nda' matay tendeng ay miktulug na run.” ");
INSERT INTO stb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bu' ali' nilan merengeg suk tinalu' ni Jesus, piketuwanan nilan giin tendeng ay misuunan nilan neng minatay na gaid sug bata'. ");
INSERT INTO stb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ma'ad mikpegaud si Jesus tu seg bata', inuwiraan ri se gemeg, bu' miktalu' seng mesekeg, “Eddang, pegbuwat'a.” ");
INSERT INTO stb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bu' mipuli' su ketubu' nug bata' bu' migbuwat rayun. Bu' tinelu'an ilan rayun ni Jesus nek paanen nilan giin. ");
INSERT INTO stb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bu' su ngang megulang nug bata' mitingala gupiya. Bu' sinugu' ilan ni Jesus ne gendi' pektabal isan ta' getaway run bu' landuning mihitabu'. ");
INSERT INTO stb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tinawag ni Jesus suk sepulu' bu' ruwa' ne ngak tinu'unan bu' binegayaan ne ga'em bu' ketenged sek pekpe'awa' se dlaun ne ngak penulay bu' pegbulung se nga dleruun. ");
INSERT INTO stb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bu' sinugu'en ilan rayun sek pegwali metendeng sek pedlegari' nud Diwata bu' sek pekpetelen se ngang minlaru. ");
INSERT INTO stb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bu' se genda' ilan pa pedlaang, giin nini suk tinalu' ni Jesus neg baalen nilan, “Sek pedlaang niyu, ndi' amu mengguwit isan landun. Ndi' amu mengguwit ne gages, gambag, balun, selapi', bu' isan ngani' gilisan. ");
INSERT INTO stb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bu' ta' neg balay neng menemba' seniyu, ritu amu pekengel tampan megawa' amu se dlunsud ketu. ");
INSERT INTO stb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bu' ndi' menemba' su nga getaw seniyu, pegawa' amu rayun se dlunsud ketu bu' tektak niyu su dlubek ri se geksud niyu gisip pekpenegul ri senilan.” ");
INSERT INTO stb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bu' migawa' su ngak tinu'unaan bu' minlaang, linaup nilan su ngag binaryuwan. Migwali ilan se Gempiya ne Gesuyen bu' mimulung ilan tu se nga getaw se gaap ne dlugar neng milawan nilan. ");
INSERT INTO stb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na, ali' merengegay ni Herodes, su geseg tu se Galilea ne su dlaun ne ngak penghitabu' metendeng riin ni Jesus, midlibeg gupiya giin. Ay duuni nga getaw neng miktalu' ne si Jesus keni, giin si Juan neng Membebendyag neng mitubu' puli'. ");
INSERT INTO stb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bu' duun remaing miktalu' ne si Jesus, giin raw si Elias. Bu' duun pa gairing miktalu' ne si Jesus, giin suk sala se ngak propeta nud diin neng mitubu' raw puli'. ");
INSERT INTO stb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Bu' miktalu' si Herodes, “Si Juan, pipetelan'u na ne gulu. Ta' getaway run nini neng meleget ma ne ngag betang neng mirengegan'u metendeng ri seniin?” Bu' tendeng run itu, liyagan gupiya ni Herodes ne gempekiita'en sa'wan si Jesus. ");
INSERT INTO stb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sek pekpuli' nu nga gapustulis, tinebalan nilan si Jesus se dlaun neng mibaal nilan. Bu' inuwit ilan rayun ni Jesus arun mekpain ilan reli' tu sek sala ne dlunsud ne giningelanan neg Betsaida. ");
INSERT INTO stb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Seng misuunan nu nga getaw neng mikedlaang ilan na ni Jesus, midlendug ilan ri seniin. Bu' pidderiyalan ilan rayun ni Jesus. Bu' inesuyaan ilan rayun metendeng ri sek pedlegari' ned Diwata bu' pitelenen su ngang minlaru. ");
INSERT INTO stb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Seng meksindep na su gendaw, suk sepulu' bu' ruwa' ne ngak tinu'unan mikpegaud riin ni Jesus bu' miktalu' ilan, “Sir, melengas bu' pepe'uli'en mu na su nga getaw arun meritu ilan se ngag baryu bu' se ngag binaal arun mekepenengaw ilan nek pekaan bu' pektulugan ay meliyaw ma uguri dlugar keni.” ");
INSERT INTO stb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ma'ad miktalu' si Jesus ri senilan, “Begayay niyu ilan nek pekaan.” Bu' miktalu' ilan, “Sir, dlima buuk ra suk pan ta bu' duwa' buuk ra suk sera' ta. Menlaang ami pa ba arun sumaluy gaan para se dlaun ne getaw keni?” ");
INSERT INTO stb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ay su nga getaw ritu, duuni dlima libu tawan puru dlai ma'aray.) Bu' miktalu' si Jesus tu se ngak tinu'unaan, laungen, “Penlumpuklumpuk niyu pe'ingkuray su nga getaw nek pidlima pulu' kada dlumpuk.” ");
INSERT INTO stb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tinuman nini nu ngak tunu'unan bu' pi'ingkud nilan su dlaun ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bu' inuwan rayun ni Jesus su dlima buuk nek pan bu' duwa' buuk nek sera' bu' migangag tu se dlangit bu' mikpesalamat tu sed Diwata. Pinetapetaan rayun, bu' binegain ini tu se ngak tinu'unaan arun pengaperaped tu se nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bu' mingaan rayun su dlaun ne nga getaw bu' mibesug ilan gupiya. Bu' ali' ilan metubus mengaan, pingipes nu ngak tinu'unaan su ngak sawad nilan bu' duunik sepulu' bu' ruwa' bebaan paing mipenu'. ");
INSERT INTO stb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sala gendaw itu, migampu' si Jesus nek salaan ra, bu' su ngak tinu'unan miritu seniin. Bu' miksaak rayun si Jesus ri senilan, “Ta'u ma ne getaw sumala' sek tinuntul ne nga getaw?” ");
INSERT INTO stb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bu' miksembag su ngak tinu'unanen, “Sud duma ne nga getaw miktalu', dya'a raw si Juan neng Membebendyag. Sud duma miktalu', dya'a raw si propeta Elias. Bu' sud duma pa gaid miktalu', salaa raw se ngak propeta nud diin neng mitubu' puli'.” ");
INSERT INTO stb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Bu' gamu,” dugang saak ni Jesus, “Ta'u ma ne getaw?” Bu' miksembag si Pedro, “Dya'a sung Misiyas, suk sinaad ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Rayun pimendu'an ilan ni Jesus ne ndi' gaid mektuntul ri isan ta' metendeng run nini. ");
INSERT INTO stb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Middugang sek pektalu' si Jesus ri senilan, “Sug Bata' ne Getaw kina'enlan ned duuning meleget ne ngak pegantusen. Bibain giin nu nga geseg nu nga getaw Judeo, nu nga geseg nu ngak pari', bu' nu ngang menintulu' ri se Kesugu'an. Petain rema giin. Ma'ad se ketelu endaw, metubu' ra giin puli'.” ");
INSERT INTO stb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Bu' miktalu' rayun si Jesus tu se dlaun nilan, “Bu' meliyag'a meddunut ri senaan, teliyuran mu su gegulingen mu nek pigena'ena', pisaan mu su krus mu kada gendaw, bu' peddunut'a ri senaan. ");
INSERT INTO stb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tendeng ay bu' liyagan mu luwasen su ketubu' mu, merala' na ma'ad tumu' ini riin seni'a. Ma'ad bu' merala' seni'a su ketubu' mu tendeng ri senaan, merawat mu tumu' ini. ");
INSERT INTO stb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Landun maing me'uwan mu bu' me'angken mu suk tibuuk neg benwa ma'ad merala' ri seni'a su ketubu' mu awas silutan'a? Nda' gaid! ");
INSERT INTO stb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bu' mpiid'a ri senaan bu' ri sek tinintulu'u, mpiid rema ri seni'a sug Bata' ne Getaw seng metuwa' riin se kerelaagen bu' se kerelaag se Gama' bu' seg bala'an ne ngag anghel. ");
INSERT INTO stb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pegena'ena' niyu ini,” miktalu' si Jesus, “Duuni ngak sementaun ta rini ne ndi' matay tampan sek panahun ne sud Diwata mekpe'ita' ri senilan sek pedlegari'en.” ");
INSERT INTO stb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Megwalu endaw dluwat telu'ay ni Jesus su ngag betang ketu, inuwiten rayun si Pedro, si Juan bu' si Santiago nek tumuwad tu seg bentud arun megampu'. ");
INSERT INTO stb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Saanay migampu' si Jesus, mi'eseb su gawi'en bu' suk suuben miputi' nek sinumanag. ");
INSERT INTO stb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bu' mitikmal rayun metuwa' sud duwa' tawan neng migegabit ri seniin. Gilan si Moses bu' si Elias ");
INSERT INTO stb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","nek sinumanag bu' miktuntul riin ni Jesus metendeng ri se kemetainen neng megaud na metuman seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Se dlain neg bahin, si Pedro bu' su ngak sementaunen, tinenangan ilan gupiya. Bu' ali' ilan mekemata, mi'ita' nilan nek sinumanag sung mulu' ni Jesus duma sed duwa' tawan neng migindeg riin se gupiren. ");
INSERT INTO stb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Seng migawa' na sud duwa' tawan ri ni Jesus, miktalu' rayun si Pedro ri seniin, “Ginu'u, melengas ned dini ita! Megbaal ita nek telu buuk ne dlekaw, salabuuk para ri seni'a, salabuuk para ri ni Moses, bu' salabuuk para rema ri ni Elias.” (Ma'ad nda' mesuunay ni Pedro bu' landunik pimentalu'en.) ");
INSERT INTO stb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Saanay miktalu' si Pedro, duuni ginanud neng mituwa' bu' mitekleman ilan; bu' minendek gupiya su ngak telu tawan nek tinu'unanen saanay mitekleman ilan ne ginanud. ");
INSERT INTO stb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bu' rayun duunik talu' neg buwat se ginanud, “Keni sug Bata'u nek pinili'u. Penginengegay niyu giin!” ");
INSERT INTO stb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bu' ali' pelali suk talu', mi'ita' nilan nek sala ra run ni Jesus ritu. Bu' sek panahun ketu su ngak tinu'unan nda' nilan pentabal isan ta' getaw metendeng seng mi'ita' nilan. ");
INSERT INTO stb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sek pekesunud ne gendaw dinumiksun ilan ni Jesus buwat seg bentud bu' linabet ilan neng meleget gupiya ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mbuus, duunik sala tawan neg buwat se dlumpuk ketu neng migbeksay, “Sir, enlengay mu reli' sug buntung bata'u ne dlai! ");
INSERT INTO stb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Enlengay mu, pekseleran giin neng melaat ne gispiritu. Mektikmal megbakal bu' mengeyeg tampan megbula' sug baba'en. Pegeelan giin nung menulay bu' ndi' gaid giin megawa' tampan melages gupiya giin bu' mekpagis su dlawasen. ");
INSERT INTO stb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mikpe'ilelaatu ri se ngak tinu'unan mu nek peguwasen nilan sung melaat ne gispiritu, ma'ad nda'iruning mibaal nilan.” ");
INSERT INTO stb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Rayun miksembag si Jesus, “Gamu ne nga getaw, nda'irunik pektu'u niyu bu' metegasi gulu niyu! Gendun kepayat neng mekpebilinu riin seniyu? Gendun kepayat neng megantusu ri se ngag betasan niyu tampan mektu'u amu?” Laung rayun ni Jesus tu se gama' ketu, “Uwit mu rini sug bata' mu!” ");
INSERT INTO stb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pulu' mirepet riin ni Jesus sug bata', linimbag giin nung menulay bu' pipengeyegen giin. Ma'ad pimaag rayun ni Jesus sung melaat ne gispiritu, bu' pitelenen sug bata', rayun inuli'en tu se gama'en. ");
INSERT INTO stb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mitingala gaid su dlaun ne nga getaw se kebagel ne ga'em ned Diwata. Seng mitingala pa su nga getaw ri se dlaun nek pimbaal ni Jesus, miktalu' giin tu se ngak tinu'unaan, ");
INSERT INTO stb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ndi' niyu pedlingaway bu' landunik tinalu'u ri seniyu. Sug Bata' ne Getaw tudyan tu se ga'em ne kuntraan.” ");
INSERT INTO stb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma'ad nda' mesabut nu ngak tinu'unaan bu' landuni gulugan sek tinalu'en. Linilung ini ri senilan arun ndi' ilan mekesabut run, bu' minendek ilan rema meksaak ri seniin bu' landuni gulugan ne ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na, duuni gendaw neng midlalis su ngak tinu'unan ni Jesus, ta' ma sakan su dlabi ne gimpurtanti riin senilan. ");
INSERT INTO stb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Misuunan ni Jesus landunik pigena'ena' nilan. Aas minuwan rayun giin neg bata', bu' pi'indegen ri seng me'iliraan, ");
INSERT INTO stb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","bu' miktalu' senilan, “Ta' ma getaw ned dumawat ri seg bata' keni se ngalan'u, dinumawat senaan; bu' ta' maid dumawat ri senaan, dinumawat rema seng miksugu' ri senaan. Aas ta' ma sung mekpebaba' ri seniyu, giin rema su dlabi ne gimpurtanti ri se dlaun niyu.” ");
INSERT INTO stb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","“Ginu'u,” miktalu' si Juan riin ni Jesus, “Mikiita' ami ne getaw neng mikpe'awa' neng menulay ginamiten su ngalan mu. Ma'ad pimaag nami ay gena' ma giin sakup senita.” ");
INSERT INTO stb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma'ad miktalu' si Jesus tu seniin, “Ndi' niyu pemaagay. Ay ta' ne getaw ne gena' niyu kuntra, giinik seked niyu.” ");
INSERT INTO stb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sek sungu' na mateng su gendaw ne gempuli' na si Jesus ditu se dlangit, mikegukum giin neng meritu reli' seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aas sinugu' ni Jesus su ngad duma nek sesugu'en arun meguna ri seniin ritu sek sala ne dlugar sek Samaria arun endamen su dlaunan para seniin. ");
INSERT INTO stb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma'ad nda' duwatay nu ngak taga Samaria gilan ni Jesus ay misuunan nilan neng mekpagaw ilan tu seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Seng mi'ita' ini se ngak tinu'unan ne si Santiago bu' si Juan, miktalu' ilan, “Ginu'u, meliyag'a ba neng menengi ami ri sed Diwata neng mekpawit giin ne gapuy arun mesereng ilan?” ");
INSERT INTO stb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ma'ad liningay ni Jesus su ngak tinu'unaan bu' pimaagen ilan. ");
INSERT INTO stb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bu' peketubus itu, linumegbas ilan ni Jesus ritu se dlain ne dlugar. ");
INSERT INTO stb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Saanay mikpedlaang ilan, duunik sala ne getaw neng miktalu' riin ni Jesus, “Meddunutu ri seni'a isan ta'a pagaw.” ");
INSERT INTO stb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Bu' sinumembag si Jesus ri seniin, “Su ngak tinggalung duuni ngak pekengelan nilan bu' su ngang manuktalun duuni ngak salag nilan, ma'ad sug Bata' ne Getaw nda'iruni dlugar ne kepenguleliyan.” ");
INSERT INTO stb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bu' miktalu' si Jesus tu se dlain ne getaw, “Dunut'a senaan.” Ma'ad miktalu' su getaw, “Ginu'u, muli'u reli' bu' lebengen'u su gama'u.” ");
INSERT INTO stb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Bu' miktalu' si Jesus tu se getaw, “Pesaddan mu na su ngak patay neng medlebeng ri se ngang minatay nilan. Ma'ad dlaang'a bu' asuy mu suk pedlegari' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Duuni dlain na pelum ne getaw neng miktalu' tu ni Jesus, “Ginu'u, meddunutu ri seni'a ma'ad muli'u reli' arun sumangid tu sek pamilyau neng medlaangu.” ");
INSERT INTO stb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Bu' miktalu' si Jesus ri seniin, “Su getaw neng middaru neng midlingaylingay, ndi' mbaya' ri sek Pedlegari' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Na, dluwat ini, mikpili' su Ginu'u ne dlain pa nek pitu pulu' bu' ruwa' ne nga getaw bu' sinugu'en ilan nek pidduwa' tawan bu' pi'unaan tu se kada ne dlunsud bu' se dlugar nek pa'agawaan. ");
INSERT INTO stb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Miktalu' giin ri senilan, “Meleget gupiya su geniin ma'ad miika' ra sung menggeniyan. Aas megampu' amu ri se gapu' ne geniin arun mekpawit pa giin ned dugang neng menggeniyan ri sek pedlegeniyaan. ");
INSERT INTO stb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na, pedlaang amu! Gaku' miksugu' seniyu maa' ne ngang nati ne karniru ritu se ngang mekebelu' ne ngang menanap. ");
INSERT INTO stb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ndi' amu meguwit nek pitaka awas gambag awas ngak sandalyas. Bu' ndi' amu melangan mektuntul ri sed dalan. ");
INSERT INTO stb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bu' isan ta' neg balay ne gempenaikan niyu, pepiyanay niyu reli' su getaw ketu bu' telu'ay niyu, ‘Pengumpiyanan nud Diwata suk pamilya mu duma se kelinaw.’ ");
INSERT INTO stb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bu' mbaya' ilan ned dumawat nek pengumpiya ri sek tinalu' mu, pengumpiyanan ilan gaid, bu' ndi' ilan mbaya', suk pekpengumpiya niyu ri senilan mpuli' ra ri seniyu. ");
INSERT INTO stb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Penaik amu ri se guna neg balay ne su gapu'en dumawat ri seniyu. Bu' landuni ilaken ri seniyu, aan niyu, tendeng ay su ngang minerbahu mbaya' gaid su'ulan. Ndi' amu pedlelegalin nek penaikan. ");
INSERT INTO stb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Na, bu' meritu amu sek sala ne dlunsud, bu' duwaten amu ne nga getaw ritu, aan amu isan landun ne gilak ri seniyu. ");
INSERT INTO stb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Petelen niyu su ngang minlaru ritu bu' esuyay niyu ilan, ‘megaud na riin senilan suk pedlegari' ned Diwata.’ ");
INSERT INTO stb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma'ad isan ta' ne dlunsud ne gempa'agawan niyu bu' ndi' amu temba'en nu nga getaw ritu, gawas amu ri se ngad dalan bu' talu' niyu, ");
INSERT INTO stb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Isan su dlubek rini se dlunsud niyu neng mineket ri se nga geksud nami, tektaken nami arun mesuunan niyu ne sud Diwata meksilut ri seniyu. Ma'ad pegena'ena' niyu ne suk Pedlegari' ned Diwata megaud na.’ ");
INSERT INTO stb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Telu'an'u amu ne suk silut ri se nga getaw ri se dlunsud ketu ne genda' peddawat riin seniyu gembagel pa kampuun sinangkali' sek taga Sodoma se Gendaw nek Pegukum.” ");
INSERT INTO stb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Bu' miktalu' puli' si Jesus, “Mekelelaatlelaat amu ne ngak taga Corazin bu' gamu ne ngak taga Betsaida! Bu' su ngang milagru riin seniyu, mibaal pa ritu sek Tiro bu' sek Sidon, mpayat ilan na siya mekseluk nek saku bu' megbetang ne gabu ri se gulu nilan sek pegilala neng middiksu' ilan ri se ngak sala' nilan. ");
INSERT INTO stb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ngani' se Gendaw nek Pegukum, suk silut nek para seniyu gembagel pa kampuun sinangkali' sek silut nek para se ngak taga Tiro bu' ngak taga Sidon. ");
INSERT INTO stb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bu' gamu, ngak taga Capernaum, migena'ena' amu ba nek siya'en amu nu dlaunan tu se dlangit? Leddu'en amu ritu se gapuy se gimpirnu!” ");
INSERT INTO stb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Bu' rayun miktalu' si Jesus ri se ngak tinu'unaan, “Su nga getaw neng menginengeg ri seniyu, menginengeg rema ri senaan; su nga getaw neng memilas ri seniyu, memilas rema ri senaan; rayun ta' sung memilas ri senaan, pemilasenen rema sung miksugu' ri senaan.” ");
INSERT INTO stb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sek pekpuli' nu ngak pitu pulu' bu' ruwa', pidleliyag ilan gaid gupiya bu' laung nilan, “Ginu'u, isan su ngak penulay mikpetu'u riin senami pebiyan ri se ngalan mu!” ");
INSERT INTO stb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Bu' miktalu' rayun si Jesus, “Mi'ita'u suk pekeladdu' ni Satanas buwat se dlangit maa' se kinlap ne gilat. ");
INSERT INTO stb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Penginengeg amu, binegayan'u amu ne ga'em, arun me'indegindegan niyu su ngang mamak bu' gulangulang bu' daagen niyu su ga'em ni Satanas. Bu' nda'irun gairing mekepedlaat ri seniyu. ");
INSERT INTO stb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ma'ad ndi' amu pedleliyag tendeng ay su ngang melaat ne gispiritu mikpetu'u na ri seniyu, bu' ndi', pedleliyag amu tumu' ay su nga ngalan niyu misulat na ritu se dlangit.” ");
INSERT INTO stb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sek panahun ketu, binatik ni Jesus su dleliyag neng migbuwat se Gispiritu Santu, bu' miktalu' giin, “Ama', gapu' nu dlangit bu' dlupa', siya'en'u dya'a tendeng ay su kemetuuran ne inedlud mu ri se ngang metau bu' duuni ngak sinuunaan, pisuun mu tumu' tu se ngad yanu ne getaw. Ama', salamat gaid tendeng ay giin nini su dliyagan mu neng mehitabu'.” ");
INSERT INTO stb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Su dlaun ne ngag betang nek tinudyan na ri senaan nu Gama'u. Su Gama' raing mikilala ri senaan neg Bata'en. Bu' Gaku' ra sung mikilala ri se Gama'u bu' su dlaun ne getaw ne dliyagan'u pe'ilala tu se Gama'u.” ");
INSERT INTO stb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mbuus inatubang ni Jesus su ngak tinu'unaan bu' miktalu' senilan ne gilan ra, “Pedleliyag amu gaid ay mi'ita' gaid niyu ngag betang keni! ");
INSERT INTO stb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ay meleget ne ngak propeta bu' nga gari' nud diin ne dliyagan nilan megenleng bu' menginengeg se dlaunan neng mi'ita' bu' mirengeg niyu. Ma'ad nda' ini mehitabu' ri sek timpu nilan.” ");
INSERT INTO stb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bu' duunik sala tawan neng menintulu' ri se Kesugu'an neng migindeg bu' miksaak arun indanan si Jesus, “Sir, lama run mai gembaya'u baalen arun mekerawatu se ketubu' ne genda'i gekteben?” ");
INSERT INTO stb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Bu' miksembag si Jesus ri seniin, “Landun maing misulat ri se Kesugu'an? Landun mai gulugaan nini?” ");
INSERT INTO stb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bu' miktalu' su getaw, “Petail mu su Ginu'u ned Diwata mu sek tibuuk nek pusung mu, sek tibuuk ne kalag mu, sek tibuuk nek sekeg mu, bu' sek tibuuk nek pengena'ena' mu. Bu' petail mu suk sumbalay mu maa' sek pekpetail mu ri se gegulingen mu.” ");
INSERT INTO stb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Ginsaktu gupiya suk sembag mu,” miktalu' si Jesus; “Baal mu ini bu' merawat mu su ketubu' ne genda'i gekteben.” ");
INSERT INTO stb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma'ad getaw ketu liyagaan mpe'ita' ne ginsaktu giin ri sek tinalu'en. Aas miksaak pa gaid giin, “Ta' ma rekay suk sumbalay'u?” ");
INSERT INTO stb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bu' sinembag giin ni Jesus pebiyan ri se galing, “Duunik sala tawan ned dinumiksun pagaw seg Jerico buwat seg Jerusalem. Bu' saanain meddiksun, inapa' giin nu ngak tulisan. Inuwan nilan su dlaun neg betangen asta na suk suuben, binentul nilan giin rayun bineleng nilan seng megaud na giin matay. ");
INSERT INTO stb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bu' peketubus itu, duunik sala nek pari' neng minayan. Bu' ali'en me'ita' su getaw, linumiyaw giin tu sed dipag ne geksid ned dalan bu' biniyanaan ma'aray. ");
INSERT INTO stb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mbuus tubus itu, duun na pelumik sala ne getaw neng minayan ne suk terbahuun megabang ritu se ngak pari' sek templo. Sek pekiita'en run su getaw ketu, linumiyaw gusay giin bu' minayan ma'aray. ");
INSERT INTO stb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sek tambinai', duuning minayan ne getaw nek taga Samaria. Bu' sek pekiita'en run su getaw neg binentul, milelaat run giin. ");
INSERT INTO stb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Aas, mikpegaud giin, rayun binulungen ne dlana bu' neg binu suk samaren bu' pingegberaan. Tubus itu, binetangen giin ri se dlekud nek sinekayaan nek petubu'en; bu' dinelung giin nu getaw nek taga Samaria ritu seg balay nek pektulugan bu' kinetaan giin. ");
INSERT INTO stb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sek pekemanlema' migbegay giin nek selapi' tu se gapu' neg balay, laungen, ‘Ketaay mu giin bu' kulang pa suk selapi' neg binegay'u seni'a, dugangan'u ra sek pekpuli'u rini.’” ");
INSERT INTO stb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Bu' tinubus ni Jesus su galing ketu sek peksaak, “Seni'a nek pengena'ena', ta' ma sek telu ketu sung mikpi'ita' ne giinik sumbalay ne getaw keni nek tinulis?” ");
INSERT INTO stb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Bu' miksembag sung menintulu' ri se Kesugu'an, “Sung milelaat ri seniin.” Bu' si Jesus miksembag, “Aas pedlaang'a bu' baal mu rema sung maa' seg binaalen.” ");
INSERT INTO stb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na, mikpeddayun medlaang si Jesus bu' su ngak tinu'unaan, bu' mirepet ilan sek sala neg baryu. Seg baryu ketu, duuni dlibun ritu ne giningelanan si Marta neng mingalimba' ri senilan tu seg balain. ");
INSERT INTO stb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Bu' duunik pateren ne giningelanan ne si Maria. Si Maria keni, migingkud ri seng megaud ne geksud ni Jesus ay liyagaan menginengeg sek penintulu' ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma'ad si Marta miribuleng gupiya sek pegandam se gaan nilan ni Jesus. Bu' mikpegaud giin riin ni Jesus bu' miktalu', “Ginu'u, nda' ba ma'ad ri seni'a nek pisaddanu nek pated'u sek pegandam ne gaan? Tabal mu seniin neng merini arun ebangan naun.” ");
INSERT INTO stb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Miksembag su Ginu'u ri seniin, “Uu, Enang Marta, migu'ul bu' migules'a se dlaun ne ngag betang, ");
INSERT INTO stb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ma'ad sala ra su kina'enlan. Bu' pinili' ni Maria sung melengas run gupiya, bu' nda'irun gairing mekuuwan run buwat ri seniin.” ");
INSERT INTO stb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Duunik sala ne gendaw neng migampu' si Jesus tu sek sala ne dlugar. Bu' ali' giin metubus megampu', sala ri se ngak tinu'unaan miktalu', “Ginu'u, si Juan neng Membebendyag miktendu' ri se ngak tinu'unaan sek pegampu'. Aas tendu'ay mu ami rema sek pegampu'.” ");
INSERT INTO stb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Bu' miktalu' si Jesus ri senilan, “Seng megampu' amu, maa' nini: ‘Gama', Pesiddengegan siya su ngalan mu neg bala'an; Mateng siya suk pedlegari' mu rini. ");
INSERT INTO stb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Begayay mu ami nek pekaan ne kina'enlan nami se gendawendaw. ");
INSERT INTO stb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pasaylu mu ami se ngak sala' nami, ay pinasaylu rema nami su kada sala neng mikesala' ri senami, bu' ndi' mu ami uwitay ri seng melised nek pengindan.’” ");
INSERT INTO stb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mbuus miktalu' si Jesus ri senilan, “Penenggi' duunik sambat mu bu' sek titenga' ne gebii meritu seg balay mu bu' mektalu', ‘Ated, pebaylu mau nek telu buuk nek pan, ");
INSERT INTO stb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ay duunik sambat'u neg begu ra mateng bu' nda'irun gairing me'ilak'u ri seniin.’ ");
INSERT INTO stb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bu' rayun sembagen'a ma'ad nuk sambat mu tu sek seled, ‘Ndi' mau na semukay. Tinerengkaan na nami sud dungawan bu' mimbelilid ami na. Bu' melised naik pegbuwat'u arun begayan'a.’” ");
INSERT INTO stb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Laung ni Jesus, “Ma'ad sung metuud, isan ndi' giin meliyag megbuwat bu' megbegay ri seni'a isan metuud nek sambat amu, bu' tendeng ay nda'a ma mpiid mekpeddayun sek pegandyu' ri seniin, megbuwat na ma'aray giin bu' megbegay ri se kina'enlan mu. ");
INSERT INTO stb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Aas, telu'an'u amu: Penengi amu tu sed Diwata bu' begayan amu. Penengaw niyu sud Diwata bu' mbangan niyu giin. Tuwagen niyu sud Diwata bu' pukaan sud dungawan para seniyu. ");
INSERT INTO stb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ay su kada nek sala neng menengi tu sed Diwata, mekerawat; sung mekpenengaw, mekebaang; bu' sung mektawag, pukaan sud dungawan para ri seniin.” ");
INSERT INTO stb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Miktalu' rema si Jesus, “Gamu ne nga gama', bu' sug bata' niyu menengi nek sera', begayan ba niyu giin neng mamak? ");
INSERT INTO stb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Awas, bu' menengi giin ne gumanuk, begayan niyu ba giin ne gulangulang? ");
INSERT INTO stb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aas, gamu ne nga getaw neng melaat, bu' metau amu megbegay neng melengas neg betang para ri se nga gembata' niyu, gendun pa sakan su Gama' niyu tu se dlangit ne dliyagaan ma gaid megbegay se Gispiritu Santu tu seng minengi ri seniin?” ");
INSERT INTO stb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Duun itu gendaw, pipe'awa' ni Jesus sung menulay nek sinumeled ri se getaw bu' giin rema su getaran sek pegugelen. Seng mipe'awa' na ni Jesus sung menulay, mikegabit na rayun sung mi'ugel bu' mitingala gaid gupiya su nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma'ad duuni ngad duma ne getaw ritu neng miktalu', “Si Beelsebul ne geseg ne ngang menulay, giin sung migbegay ne ga'em sek pekpe'awa' ri senilan.” ");
INSERT INTO stb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Sud duma ne getaw liyagan nilan ne indanan si Jesus, aas migandyu' ilan ri seniin neng megbaal neng milagru sek pekpemetuud nek sinugu' giin ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma'ad misuunan ni Jesus su nga gena'ena' nilan, aas miktalu' giin, “Bu' su ngak sakup nuk sala nek pedlegeri'an mbahinbahin bu' megunay megbunu', suk pedlegeri'an ketu mbengkag. Giin remaing mehitabu' ri sek sala nek pamilya ne gembahinbahin bu' megunay medlalis. ");
INSERT INTO stb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ngani' bu' si Satanas bu' su ngak sakupen mbahinbahin bu' megunay megbunu', pekendun dun sek pekpayat sek pedlegeri'aan? Tumu' miktalu' amu nek pipe'awa'u su ngang menulay tendeng ay binegayanu ne ga'em ni Beelsebul. ");
INSERT INTO stb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bu' giin nini su ginamit'u arun sek pekpe'awa' se ngang menulay, pigendun nu ngak sakup niyu sek pekpe'awa' rema se ngang menulay? Su ngak sakup niyu sung mikpemetuud neng misayep amu gaid! ");
INSERT INTO stb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tendeng ay pipe'awa'u su ngak penulay pebiyan ri se ga'em ned Diwata, mikpemetuud ini ne suk pedlegari' nud Diwata minateng na riin seniyu.” ");
INSERT INTO stb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Bu' sung mesekeg ne getaw neng migandam se dlaun neg besiin, migbantay ri seg balain, ndi' gaid mpegilebetan su ngag betangen. ");
INSERT INTO stb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma'ad bu' sulungen giin neng mesekeg kampuun ne getaw, daagen giin. Su ngag besi nek sineligaan uwanen ri seniin bu' behinbehinen rema su dlaun nek petigayunen.” ");
INSERT INTO stb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Su gena' medduma ri senaan, giini kuntrau. Bu' su gendi' megabang ri senaan sek pekpungun ri se getaw arun sek pektu'u sed Diwata, giining mekpetipelak riin senilan.” ");
INSERT INTO stb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Sung melaat ne gispiritu se gumawas na ri se getaw nek sineleraan, medlaanglaang ini ri se nga dlugar neng memelaan tendeng ay menengaw ne dlugar nek pekengelaan. Ma'ad bu' ndi' ini mekiita' nek pekengelan, megena'ena' ini sek pekpuli' tu sek pigbuwataan. ");
INSERT INTO stb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bu' sek pekpuli'en bu' me'ita'en suk pigbuwataan ne dlimpiyu bu' melengasik pekpe'imetang se dlaunen, ");
INSERT INTO stb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","medlaang rayun ini bu' mengenggat nek pitu neng melaat ne gispiritu neng melaaten pa kampuun ri seniin. Bu' rayun, sumeled ilan se getaw ketu bu' mekengel. Bu' su kebetang nu getaw ketu meksamet pa kampuun su kelaaten sinangkali' nu guna.” ");
INSERT INTO stb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Peketubus itu telu'ay ni Jesus, duuni dlibun ritu se dlumpuk neng miktalu' ri seniin, “Pidleliyag su dlibun neng migberes bu' mikperuru' ri seni'a!” ");
INSERT INTO stb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ma'ad miksembag si Jesus, “Pedleliyagen su nga getaw neng menginengeg bu' mektuman ri sek talu' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Saanay middugang su dleget nu nga getaw neng megaud riin ni Jesus, miktalu' giin, “Pekelaaten gaid se nga getaw numuun. Minengi ilan neng milagru, ma'ad nda'iruning milagru ne gempe'ita' ri senilan gawas seng milagru neng mihitabu' riin ni Jonas. ");
INSERT INTO stb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Maa' ni propeta Jonas nud diin, mibaal ne gilelaan tu se nga getaw seng Ninive, aas sung mehitabu' ri seg Bata' ne Getaw mbaal rema ne gilelaan ri se nga getaw numuun. ");
INSERT INTO stb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Se Gendaw nek Pegukum, sug Bai ri sek pedlegeri'an nek Sheba sumintigus kuntra ri se nga getaw sek panahun keni, tendeng ay migbuwat pa giin seng melayu' ne dlugar arun menginengeg ri sek tinawan ni Ari' Solomon. Bu' enlengay niyu, duuni getaw rini bu' labaw pa suk sinuunaan riin ni Ari' Solomon. ");
INSERT INTO stb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Se Gendaw nek Pegukum, su nga getaw seng Ninive sumintigus kuntra se nga getaw numuun. Ay sek pekerengeg nu nga getaw seng Ninive seg wali ni Jonas, middiksu' ilan. Bu' enlengay niyu, duuni getaw rini bu' labaw pa ri ni Jonas.” ");
INSERT INTO stb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Bu' miktalu' pa gaid si Jesus, “Nda'iruni getaw nek tubus mektutud nek sulu' edluren awas betangen ri sek seled ne gamang, bu' ndi' betangenen ri se genturan dun arun me'ita' nu nga getaw su kerelaag sek pekseled nilan. ");
INSERT INTO stb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sung mata niyu maa' nek sulu' neng mekegbegay ned delaag para se dlawas. Bu' nda'iruning megeelen su ngang mata niyu, maa' ini neng mirelaagan su dlawas niyu. Ma'ad bu' duuning megeelen su ngang mata niyu, maa' ini neng mireleman su dlawas niyu. ");
INSERT INTO stb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aas siguru niyu neng merelaagan amu gaid, bu' ndi' mereleman. ");
INSERT INTO stb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bu' suk tibuuk ne dlawas niyu merelaagan gupiya, bu' nda'irunig bahin neng mereleman, maa' ini rayun sek tinuturan nek sulu' neng megbegay ne kerelaag.” ");
INSERT INTO stb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Na, ali' metubus si Jesus megasuy, duunik Pariseo neng migenggat ri seniin sek pengaan ritu seg balain. Aas miritu si Jesus bu' migingkud arun maan. ");
INSERT INTO stb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mitingala suk Pariseo sek pekiita'en ne genda' pengunaw si Jesus pulu' minaan. ");
INSERT INTO stb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aas miktalu' su Ginu'u ri seniin, “Na, gamu ne ngak Pariseo, pingugasan niyu sung melemu' neng me'ita' niyu ri se gawas nek tingkap bu' pinggan niyu, ma'ad sek seled niyu, merelaw bu' melaaten amu gupiya. ");
INSERT INTO stb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ngag buralburalen! Nda' amu ba mekesuun ne sud Diwata migbaal ri se gawas awas seled niyu? ");
INSERT INTO stb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aas, begay niyu ritu se ngak pupus bu' landuni riin se ngak tingkap bu' ngak pinggan niyu bu' melimpiyu amu gaid rayun. ");
INSERT INTO stb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ma'ad mekelelaat amu ne ngak Pariseo! Binegay niyu tu sed Diwata su nga kesepulu' niyu buwat ri se ngak peddaut nek pimula niyu. Ma'ad nda' niyu baalay suk pekemetareng bu' nda' niyu petailay sud Diwata. Ngag betang keni, giin nini su ngag betang ne kina'enlan mbaal niyu saanay niyu mekpeddayun sek pegbegay se kesepulu' niyu. ");
INSERT INTO stb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mekelelaat amu ne ngak Pariseo! Liyagan niyu su dlabi neng melengas ne nga gingkuran ri se ngak pektipungan niyu bu' liyagan niyu neng megbasa ilan ri seniyu ri se ngak tebu'an. ");
INSERT INTO stb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mekelelaat amu! Maa' amu ne nga dlebeng ne nda'iruni nga gilelaan run, ne nda' mesuunay ne nga getaw neng mi'indegan na masi' nilan.” ");
INSERT INTO stb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mbuus miktalu' suk sala ne ngang menintulu' ri se Kesugu'an, “Sir, sek tinalu' mu ini, tinampela' mu ami rema.” ");
INSERT INTO stb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma'ad miksembag si Jesus, “Mekelelaat amu rema ne ngang minintulu' ri se Kesugu'an! Pipisaan niyu ri se nga getaw su nga gembegat ne ngak pempisaanen ma'ad gamu mismu ndi' ma ngani' niyu merelu' sek sala nek tendu' niyu arun ebangan ilan. ");
INSERT INTO stb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mekelelaat amu! Migbaal amu neng melengas ne nga dlebengan para se ngak propeta nek pimatay nu nga gepu'an niyu. ");
INSERT INTO stb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Seng maa' nini, gamu mismu minangken ne gamu minuyun seg binaal nu nga gepu'an niyu ay gilan sung mikpatay se ngak propeta bu' gamu sung migbaal se nga dlebengan nilan. ");
INSERT INTO stb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tendeng run nini, sud Diwata ned duunik sinuunan miktalu', ‘Puwitan'u ilan ne ngak propeta bu' nga gapustulis; ma'ad petain nilan sud duma bu' lutusen sud duma.’ ");
INSERT INTO stb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Aas su nga getaw numuun silutan nud Diwata sek pekpatay tu se ngak propeta gatad sek pegbaal ri seg benwa, ");
INSERT INTO stb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","gatad sek pekpatay riin ni Abel tampan sek pekpatay ri ni Zacarias ritu se gelet neg halaran bu' bala'an ne dlugar. Wa'a esuyan'u amu, silutan gaid su nga getaw sek panahun keni tendeng run nini. ");
INSERT INTO stb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mekelelaat amu ne ngang menintulu' ri se Kesugu'an! Ay inedlud niyu su dyabi ne giin sung mekepuka sed dungawan nek sinuunan, ma'ad gamu mismu nda' seled bu' binelebagan niyu sung meliyag sumeled run nini.” ");
INSERT INTO stb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sek pegawa' na ni Jesus se dlugar ketu, pimura gupiya giin nu ngang menintulu' ri se Kesugu'an bu' ngak Pariseo bu' miksaak ilan ri seniin metendeng seng melaun ne ngag betang. ");
INSERT INTO stb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Inindanan nilan giin arun mesekupan giin neng misayep se dlaun ne ngak tinalu'en. ");
INSERT INTO stb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sek panahun ketu seng mimpegaud su nga dlinibu ne nga getaw ritu ni Jesus bu' migegindegay ilan na, migasuy reli' si Jesus tu se ngak tinu'unaan, “Megbantay amu ri se ngak pempetulin ne ngak Pariseo, neng migulugan, su ngak pekpelaunglaung nilan. ");
INSERT INTO stb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Su dlaun ne ginedlud mbaangan, bu' su kada gendi' pesuun mesuunan. ");
INSERT INTO stb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Aas isan landunik tinalu' niyu riin seng merelem merengeg riin seng merelaag, bu' su ginilem niyu ri sek seled ne ngak siradu ned dugu mbeksay ra buwat ri se ngad dibabaw neg balay.” ");
INSERT INTO stb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Na, miktalu' si Jesus tu se ngak sambaten, “Ndi' amu mendek ri senilan neng mekepatay ri se dlawas niyu, bu' peketubusen itu, nda'irun nai dlain ne gembaal nilan. ");
INSERT INTO stb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma'ad esuyan'u amu bu' ta' su gembaya' pegendekan niyu: pegendekay niyu sud Diwata, nek tubus mekpatay, duuni ketengeren sek pektikpu' se isan ta' ritu se gimpirnu. Tu'uway niyau, pegendekay niyu gaid giin!” ");
INSERT INTO stb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Gena' ba su dlima buuk neng miika' ne ngang manuktalun bineledya' ma'aray sed duwa' sintabus? Ma'ad nda'irunik salabuuk ri senilan nek pidlingawan ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Isan ngani' sug buuk niyu mi'isipen su dlaunen. Aas ndi' amu mendek! Tendeng ay melaga' amu pa kampuun ri seng miika' ne ngang manuktalun.” ");
INSERT INTO stb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Telu'an'u amu su isan ta' neng megasuy ri seng metungenga'an ne nga getaw ne giin naku', giin rema sug baalen tu seniin seg Bata' ne Getaw ri seng metungenga'an ne ngag anghel ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma'ad su ngang megbibay ri senaan ri seng melaun ne nga getaw, bibain ilan rema neg Bata' ne Getaw ri seng metungenga'an ne ngag anghel nud Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Bu' isan ta' sung megasuy neng melaat kuntra ri seg Bata' ne Getaw mpasaylu; ma'ad su getaw neng mekpesipala ri se Gispiritu Santu ndi' gaid mpasaylu.” ");
INSERT INTO stb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Bu' uwiten amu riin se ngak pektiguman awas ri se nga gobernador awas ri se nga geseg, ndi' amu meremeng bu' pekendun run niyu pekpengeterengan awas landunik sembag niyu. ");
INSERT INTO stb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ay tendu'an amu ne Gispiritu Santu se guras ketu bu' landuni gembaya' niyu sembag.” ");
INSERT INTO stb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mbuus duunik sala ne getaw ritu se dlumpuk neng miktalu', “Sir, esuyay mu suk pated'u ne dlai neg behinan naun ritu se ketigeyunan neg binilin ri senami.” ");
INSERT INTO stb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma'ad miksembag si Jesus, “Agi lai, ta' maing migbegay ri senaan ne ketenged sek pegukum awas sek pegbahin se ketigeyunan niyu?” ");
INSERT INTO stb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bu' mikpeddayun giin sek pektalu' tu se dlaun nilan, “Pekpetigaam amu bu' bentayay niyu su gegulingen niyu se isan landun ne kerelaw, ay sung metuud ne ketubu' ne getaw gena' se kelaun ne nga ketigeyunan neng me'angkenen.” ");
INSERT INTO stb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bu' migasuy rayun si Jesus ri se galing, “Duunik sala tawan ned datu' ned duuni dlupa'en neng melaun nek sengku' run. ");
INSERT INTO stb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bu' miktalu' giin ri se gegulingenen, ‘Nda'irunig betangan'u runik sengku'u keni! Landunig baalen'u?’ ");
INSERT INTO stb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Bu' miktalu' giin ri se gegulingenen, ‘Aa, giin nini sug baalen'u, geba'en'u su nga kemalig'u bu' megbaalu ne gembagel pa kampuun ne rituu ipesay su ngak sengku'u bu' sud duma ne ngag betang'u. ");
INSERT INTO stb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bu' mbuus mektalu'u ri se gegulingen'u: Sinuwirtia! Diin na seni'a su dlaun ne ngag betang ne kina'enlan mu se dlaun ne ngak taun. Mendelaya'a ra run, maan, minum, bu' medleliyag!’ ");
INSERT INTO stb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ma'ad miktalu' sud Diwata ri seniin, ‘Uy, buralburalen'a! Ri se gebii keni, matay'a, mbuus, ta' maing mekaangken se dlaun ne ngag betang nek tinigum mu para ri se gegulingen mu?’” ");
INSERT INTO stb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Bu' tinubus ni Jesus suk tinalu'en, “Giin remaing mehitabu' ri se getaw neng mektigum ne nga ketigeyunan para ri se gegulingenen, ma'ad pupus giin ri sek pengenleng ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na, miktalu' si Jesus tu se ngak tinu'unaan, “Bu' esuyan'u amu ne ndi' amu megules metendeng se gaan ne kina'enlan niyu arun metubu' awas metendeng sek suub ne kina'enlanen niyu para ri se dlawas niyu. ");
INSERT INTO stb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tendeng ay su ketubu' nu getaw, gimpurtanti pa kampuun ay sek pekaan, bu' su dlawas nu getaw, gimpurtanti pa kampuun ri sek suub. ");
INSERT INTO stb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Enlengay niyu su nga guwak: nda' ilan pegimula awas pedlegani; nda'iruni nga gipesan awas tibengan ma'ad pinaan ilan nud Diwata. Gena' ba ne dlabaw amu pa ri se ngang manuktalun? ");
INSERT INTO stb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Bu' ta' ba seniyu sung mekeddugang se ketaas ri se ketubu'en pebiyan sek pekegules? ");
INSERT INTO stb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bu' ndi' amu mekeguwit isan seng miika' neg betang keni, tuma ma megules amu pa ri sed duma ne ngag betang? ");
INSERT INTO stb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Enlengay niyu pigendun dun pektubu' nu ngag bulak: nda' ilan pekterbahu awas pegabel para ri se gegulingen nilan. Ma'ad telu'an'u amu ne isan si Ari' Solomon neng meratu' gupiya nda'irunik suuben neng maa' kelengas ri sek sala ne ngag bulak keni. ");
INSERT INTO stb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bu' pilengas nud Diwata su ngak sigbet nek tetubu' numuun, bu' melawes ra bu' serengen ma'aray pekemanlema', gendun pa sakan gamu? Siguru gaid nek pesuuban amu ned Diwata! Pekiika' sek pektu'u niyu!” ");
INSERT INTO stb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Aas ndi' amu gaid megules bu' landun mbuusi aanen bu' inumen niyu. ");
INSERT INTO stb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ay su nga gena' mektetu'u ri sed Diwata kanunay migules ri se dlaunan. Ma'ad mikesuun su Gama' niyu tu se dlangit neng midlekina'enlan amu se ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tumu', una niyu penengaway suk pedlegeri'an ned Diwata ri se ketubu' niyu bu' megbegay gaid giin ri seniyu se ngag betang keni.” ");
INSERT INTO stb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ngang miika' ne dlumpuk nek tinu'unan'u, ndi' amu mendek ay pidleliyag su Gama' niyu sek pegbegay seniyu sek Pedlegeri'an. ");
INSERT INTO stb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Beledya' niyu su dlaun ne nga ketigeyunan niyu bu' begay niyu su galinen tu se ngak pupus. Pegbaal amu ne ngak pitaka ri se gegulingen niyu ne ndi' meranul bu' pektigum amu ri se gegulingen niyu ne ketigeyunan ritu se dlangit ne ndi' me'engkanan, tendeng ay nda'iruning meddaaw neng menguwan bu' nda'iruni ganay neng mekekaan run. ");
INSERT INTO stb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aas ta' ngani' su ketigeyunan niyu, ditu rema su gena'ena' niyu.” ");
INSERT INTO stb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mengandam amu se dlaun nek panahun bu' kanunay niyu peliga'en su ngak sulu' niyu, ");
INSERT INTO stb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","maa' nu ngak sesugu'en neng migelat sek pekpuli' ne gegalen nilan nek tinumambung ri se kumbira ri se kasal. Aas isan laa urasay run mateng su gegalen nilan bu' mektawag, mpuka nilan rayun sud dungawan. ");
INSERT INTO stb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pedleliyagen su ngak sesugu'en neng me'ita' nu gegalen nilan ne genda' pektulug bu' mingandam sek peddatengen! Telu'an'u amu, megilis giin, pe'ingkuren ilan, bu' megilak giin senilan. ");
INSERT INTO stb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bu' pedleliyagen ilan gaid bu' meretengan ilan nu gegalen bu' me'ita'en neng migelat ilan sek peddatengen isan sek titenga' gebii awas se gendi' pa meddali' endaw. ");
INSERT INTO stb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Bu' tima'anay niyu ini: Bu' mekesuun pa su gapu' neg balay nanu mateng sung meddaaw, ndi'en gaid tugut neng mekeseled sung meddaaw ri seg balain. ");
INSERT INTO stb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aas gamu rema kina'enlan mengandam ay sug Bata' ne Getaw mateng se guras ne nda' niyu giin peretengay.” ");
INSERT INTO stb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Miksaak si Pedro, “Ginu'u, galing mu kiin para ba ri senami awas para ri sek salasala?” ");
INSERT INTO stb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bu' sinembag giin ni Jesus, “Ta' getaw sung meseligan bu' metau gupiya nek sesugu'en? Giinik pili'en ne gegalen neng meseligan, neng meguwit ri sek penimalain, bu' megbegay sed duma ne ngak sesugu'en seg bahin nilan nek pekaan se ginsaktu ne guras. ");
INSERT INTO stb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pedleliyagen suk sesugu'en ketu ne sek pekpuli' ne gegalenen meretengan neng migbaal ri sek terbahuun. ");
INSERT INTO stb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Siguru gaid nek pe'uwit ri seniin su dlaun ne nga ketigeyunan nu gegalenen. ");
INSERT INTO stb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma'ad bu' suk sesugu'en mektalu' ri se gegulingenen ne gembuwad pa mpuli' su gegalenen, bu' megatad giin memunal ri se ngak sama sesugu'enen, dlai ma awas dlibun, bu' maan, meginum, bu' megbinabeleng giin, ");
INSERT INTO stb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","bu' mbuus mipuli' su gegalen sek sala ne gendaw ne nda' peretengay nek sesugu'en bu' sek panahun ne nda'en mesuunay. Silutan giin nu gegalenen bu' lempu'en giin duma se ngak sesugu'en ne ndi' meseligan.” ");
INSERT INTO stb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Na, suk sesugu'en neng mikesuun landunik pebaal ne gegalenen, ma'ad nda' giin pegatad sek pegandam bu' nda' ini baalay, silutan giin seng melaun nek pedlatigu. ");
INSERT INTO stb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma'ad suk sesugu'en ne nda' mekesuun landuni dliyagan ne gegalenen neg baalen, bu' mekegbaal nek sayep mbaya' gaid silutan, latiguun giin ma'ad miika' ra. Tendeng ay su getaw neg binegayan neng melaun, melaun rema suk peretengen buwat ri seniin, bu' suk sala neg binegayan neng melaun pa kampuun, melaun rema kampuun suk peretengen buwat ri seniin.” ");
INSERT INTO stb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Miriniu sek peksereng ri seg benwa, bu' liyagan'u siya neng mesereng na! ");
INSERT INTO stb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mibetangu ri seng melised nek peksulay. Bu' megantusu seng melaun ne kegeel tampan metuman ini. ");
INSERT INTO stb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Migena'ena' amu ba neng miriniu arun sek peguwit ne kelinaw ri seg benwa? Gena'. Gena' kelinaw su ginuwit'u bu' ndi' pegbahinbahin. ");
INSERT INTO stb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bu' gatad nandaw, duuni dlima tawan ri sek sala nek pamilya ne mbahinbahin, suk telu kuntra sed duwa' awas sud duwa' kuntra sek telu. ");
INSERT INTO stb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Su nga gama' kumuntra ri se nga gembata' nilan ne dlai, bu' su nga gembata' ne dlai kumuntra ri se nga gama' nilan; su nga gina' kumuntra ri se nga gembata' nilan ne dlibun, bu' su nga gembata' ne dlibun kumuntra ri se nga gina' nilan; su ngak penugangan ne dlibun kumuntra ri se ngang minugangan ne dlibun, bu' sung minugangan ne dlibun kumuntra ri se ngak penugangan ne dlibun.” ");
INSERT INTO stb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mbuus miktalu' si Jesus tu seng meleget ne getaw, “Seng me'ita' niyu su ginanud neng mekpagaw riin seniyu neg buwat ri sek sindepan bu' mektalu' amu neng meddupi', bu' meddupi' gaid. ");
INSERT INTO stb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Bu' mbetikan niyu neng mekpes su genus buwat ri seg habagatan, mektalu' amu neng mekperes, bu' mekperes gaid. ");
INSERT INTO stb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ngang mikpelaungpelaung! Metau amu menabut se gawi' neg benwa bu' se dlangit ma'ad tuma ma ndi' niyu ma mesabut su gulugan sek panahun keni?” ");
INSERT INTO stb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Tuma ma ndi' niyu ma me'ukuman ri se gegulingen niyu su ginsaktu neg baalen? ");
INSERT INTO stb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bu' duunik sumumbung ri seni'a, penentuway mu gaid ne mpeneguli'an mu giin se gendi' amu pa megusay ri se gukuman. Ay ali' bu' legesen'a gaid ne uwiten ritu seng mengengukum; bu' sung mengengukum, giining mekpiyal seni'a tu se ngak pulis arun perisuun'a. ");
INSERT INTO stb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Bu' ndi'a mekegawas tampan ndi' mu mbiyaran su dlaun neng multa mu.” ");
INSERT INTO stb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sek panahun ketu, duuni nga getaw ritu neng migasuy riin ni Jesus metendeng se nga getaw nek taga Galilea nek pipatay ni Pilato saanay nilan meddulang ne ngak pitubu' ritu sed Diwata. ");
INSERT INTO stb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Miktalu' si Jesus ri senilan, “Migena'ena' amu ba neng mihitabu' itu ri senilan tendeng ay mekesesala' ilan kampuun sinangkali' se ngad duma ne ngak taga Galilea? ");
INSERT INTO stb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Gena' gaid! Tumu' esuyan'u amu, bu' ndi' amu meddiksu' ri se ngak sala' niyu, dlaun niyu mematay rema maa' senilan. ");
INSERT INTO stb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Metendeng se ngak sepulu' bu' walu ne ngang minatay ritu sek Siloam ay mibuksakan neng metaas neg balay, migena'ena' amu ba ne gilan ketu sung melaat kampuun sinangkali' se dlaun ne ngak taga Jerusalem? ");
INSERT INTO stb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Gena'. Ma'ad esuyan'u amu, bu' ndi' amu meddiksu' ri se ngak sala' niyu, dlaunan niyu mematay rema neng maa' senilan.” ");
INSERT INTO stb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Peketubus, inesuyan ilan ni Jesus se galing keni, “Duunik sala tawan ned duuni gayu neg Igira riin seg binaalen. Inenlengaani gayu keni bu' duun na baig bungaan, ma'ad nda'irun gairing mi'ita'en. ");
INSERT INTO stb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aas, inesuyaan sung midlekata ri seg binaalen, ‘Enlengay mu, telu taunu na pekpuli'puli' rini arun enlengan bu' duun na baig bungaan, ma'ad nda' gaid mekepemunga. Penaga' mu na ma'aray. Ay inaanen ma'ad su dlembu' ne dlupa'.’ ");
INSERT INTO stb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ma'ad miksembag sung midlekata, ‘Sir, peseddanen ta reli'ay seled sek sala taun tendeng ay libuten'u reli' keliyay bu' rayun abunuwan. ");
INSERT INTO stb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bu' memunga ini sek sunud taun, melengas. Ma'ad bu' ndi' pa gaid, penega'en ta na ini.’ ” ");
INSERT INTO stb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Gendaw itu nek pengulali, minintulu' si Jesus ri sek pektipungan nu ngag Judeo. ");
INSERT INTO stb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Bu' enlengay niyu, duuni dlibun neng mibekug ritu seled sek sepulu' bu' walu taun na tendeng seng melaat ne gispiritu. Ndi' na giin mekegetat. ");
INSERT INTO stb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sek pekiita' ni Jesus ri seniin, sinabiin giin bu' tinelu'an, “Manay, me'uli'an'a na ri se dleruun mu.” ");
INSERT INTO stb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Bu' dinepenaan su dlibun, bu' sek tikmal, mi'uli'an rayun bu' migatad giin sek peksaya' tu sed Diwata. ");
INSERT INTO stb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma'ad pinlengetan su geseg ri sek pektipungan tendeng ay mimulung si Jesus se Gendaw nek Pengulali. Aas miktalu' giin tu se nga getaw, “Duuni genem endaw ne gita meketerbahu. Aas merini amu se nga gendaw iin bu' liyagan niyu me'uli'an, ma'ad gena' se Gendaw nek Pengulali!” ");
INSERT INTO stb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bu' miksembag su Ginu'u ri seniin, “Gamu ne ngang mekpelaunglaung! Bu' duunig baka awas gasnu niyu, ugbaran niyu ini buwat ri se dlugar ne giniketan run bu' uwiten pagaw tu sek pe'inuman isan pa bu' Gendaw nek Pengulali. ");
INSERT INTO stb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nemuun, keni su gasal ni Abraham nek pi'antus ni Satanas seled na sek sepulu' bu' walu taun. Ndi' ba mehimu nek pe'uli'an giin ri se dleruun se Gendaw nek Pengulali?” ");
INSERT INTO stb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mipiiran su dlaun ne nga kuntraan sek pekerengeg nilan sek sembagen, saanay su dlaun ne nga getaw pidleliyag se nga ketingelaan neg binaal ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Miksaak si Jesus, “Landun ma sakan sung megamit'u nek petenggi'an ri sek pedlegari' ned Diwata? Bu' ta' ma ini mpetanggi'? ");
INSERT INTO stb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Maa' ini neng miika' ne dlisu neng muntasa ne ginerek nek sala getaw ri seg binaalen. Mintubu' suk pimula bu' mibaal ne gayu bu' pikselagan ne ngang manuktalun su ngak pangaan.” ");
INSERT INTO stb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Miksaak puli' si Jesus, “Ta'u ma petanggi' suk pedlegari' nud Diwata? ");
INSERT INTO stb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Maa' ini ri sek pempetulin ne ginuwan nek sala ne dlibun bu' linemug ri sek sepulu' bu' ruwa' gantang ne garina tampan tumulin suk tibuuk neng minasa.” ");
INSERT INTO stb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mikpeddayun si Jesus ritu seg Jerusalem bu' minendu' giin se nga dlunsud bu' se ngag baryu neng mibiyanaan. ");
INSERT INTO stb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mbuus duunik sala ne getaw neng miksaak ri seniin, “Ginu'u, miika' ra baing meluwas?” Sinembag ilan ni Jesus, ");
INSERT INTO stb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Aas, penamal amu gaid sek pekseled seng mesikut ned dungawan tendeng ay melauning menantu sek pekseled ma'ad ndi' ilan mekeseled. ");
INSERT INTO stb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bu' megbuwat su gapu' neg balay bu' tekepaan na sud dungawan, megindeg amu ra run mbuus tu se gawas bu' mektawag, ‘Sir, pukaay mu ami!’ Ma'ad sembageen amu, ‘Nda'u mesuunay bu' ta' amu migbuwat.’ ");
INSERT INTO stb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mbuus meksembag amu, ‘Minaan bu' miginum ami duma ri seni'a; minintulu'a ritu se dlunsud nami!’ ");
INSERT INTO stb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ma'ad meksembag giin puli', ‘Nda'u gaid mekilala seniyu. Pelayu' amu ri senaan, gamu neng membebaal neng mekelaat!’ ");
INSERT INTO stb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ritu mensegaw amu bu' mengkiget su nga ngisi niyu seng me'ita' niyu si Abraham, Isaac, Jacob, bu' su dlaun ne ngak propeta ritu sek pedlegeri'an ned Diwata saanay gamu pidlaken ritu se gawas. ");
INSERT INTO stb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bu' mateng su nga getaw buwat se dlaun neg bahin seg benwa neng megingkud bu' maan ritu se kumbira sek pedlegeri'an nud Diwata. ");
INSERT INTO stb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Duuni nga gena' tinamed numuun ne mbaal nek tinamed, bu' duuni ngak tinamed numuun ne gena' na nek tinamed.” ");
INSERT INTO stb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sek timpu ketu duuni ngak Pariseo neng miritu ni Jesus bu' miktalu', “Kina'enlan neng megawa'a na rini bu' peritua se dlain ne dlugar tendeng ay liyagan ni Herodes nek petain'a.” ");
INSERT INTO stb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Bu' sinembag ilan ni Jesus, “Dlaang amu bu' esuyay niyu su dlimbungan ne si Herodes: ‘Enlengay niyu, mekpeddayunu sek pekpe'awa' ne ngang menulay bu' mekpetelen ne ngang minlaru nandaw bu' lema', bu' se ketelu endaw metubus'u suk terbahuu.’ ");
INSERT INTO stb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tumu' kina'enlan gaid neng mekpeddayunu sek pedlaang nandaw, lema', bu' lenlag; ay ndi' mehimu ne suk propeta petain isan ta' bu' ndi' seg Jerusalem ra.” ");
INSERT INTO stb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Gamu nek taga Jerusalem! Pinatay niyu su ngak propeta bu' binatu niyu su ngak sinugu' ned Diwata riin seniyu! Se dlaun nek panahun, liyagan'u ne ekepen su dlaun ne nga getaw niyu, maa' ned deluwan nek tinipungen su ngak pesuyen ri sed diyalem ne gekpaken, ma'ad ndi' niyu ini liyagan! ");
INSERT INTO stb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Enlengay niyu, bineleng niyu suk Templo niyu. Ndi' na niyau me'ita' puli' tampan sek penahun neng mektalu' amu, ‘Pengumpiyanan ned Diwata sung mateng ri se ngalan ne Ginu'u.’” ");
INSERT INTO stb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Duun itui Gendaw nek Pengulali, minaan si Jesus ritu seg balay sek sala ne geseg nu ngak Pariseo. Rayun ritu, pini'iran gupiya giin nu nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mbuus, enlengay niyu, duuni getaw ritu neng mimaga' su nga geksuren bu' ngag biingkenen bu' mikpegaud giin riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Bu' miktalu' si Jesus bu' miksaak giin ri se ngang menintulu' ri se Kesugu'an bu' ri se ngak Pariseo, “Tinugut ba ri se Kesugu'an ta neng mekpetelen se ngang minlaru se Gendaw nek Pengulali awas nda'?” ");
INSERT INTO stb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma'ad nda' ilan pensembag. Mbuus inuwiran rayun ni Jesus su getaw, pitelenen, bu' peketubus, pilaangen. ");
INSERT INTO stb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Peketubus itu, miksaak giin tu se nga getaw ritu, “Penenggi' bu' duunig bata' awas baka niyu neng meladdu' ri sed delungan se Gendaw nek Pengulali, ndi' ba niyu rayun betunen isan se Gendaw nek Pengulali?” ");
INSERT INTO stb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma'ad nda' ilan gaid mekesembag ri sek sinaaken. ");
INSERT INTO stb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mitelipenan ni Jesus ne suk pingenggat, mimili' ne nga gingkuran nek para ri se ngang mekeselaag ne getaw. Aas, tinelu'aan ilan ne galing: ");
INSERT INTO stb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bu' enggaten'a ri se kumbira ri se kasal, ndi' mu pemili'ay su gingkuran nek para ri se ngang mekeselaag ne getaw ay ali' bu' duuni ginenggat neng meselaag pa kampuun ri seni'a ");
INSERT INTO stb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","bu' sung migenggat ri seniyu ruwa' mekpegaud bu' mektalu' seni'a, ‘Giinik pe'ingkud mu riin.’ Mpiiran'a mbuus bu' mekegingkud'a ritu seg binai'. ");
INSERT INTO stb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ma'ad, bu' enggaten'a, ritu'a tumu' pegingkud seg binai' arun sung migenggat ri seni'a mekpegaud bu' mektalu': ‘Ated, galin'a rini se gingkuran seng mekeselaag.’ Seng maa' nini mpesiddengegan'a ri seng metungenga'an se dlaun ne ngak pingenggat. ");
INSERT INTO stb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ay isan ta'ing mekpetaastaas ri se gegulingenen, pebeba'en, isan bu' ta'ing mekpebaba' ri se gegulingenen petaasen.” ");
INSERT INTO stb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mbuus miktalu' si Jesus ri se getaw neng migenggat ri seniin, “Bu' mengenggat'a ne nga getaw arun meni'udtu awas menihapun, ndi' mu enggatay su ngak sambat mu, awas ngak pated mu, awas nga gepenan mu, awas su ngang meratu' ne ngak sumbalay mu ay gilan sumuli' megenggat ri seni'a bu' seng maa' niin nek pebiyan, mesuli'an'a seg binaal mu. ");
INSERT INTO stb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ma'ad bu' medlekumbiraa, enggat mu su ngak pupus, ngak pingkaw, ngak pi'ang, bu' ngag buta; ");
INSERT INTO stb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","bu' pengumpiyanan'a tendeng ay ndi' ilan mekesuli' ri seni'a. Sud Diwata ra suk sumuli' ri seni'a sek peddateng sek panahun nek petubu'en puli' su ngang metareng buwat ri se kemetain.” ");
INSERT INTO stb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sek pekerengeg run nitu nek sala tawan neng mikeddunut riin ni Jesus sek pekpengaan, miktalu' giin riin ni Jesus, “Pedleliyagen gupiya su getaw neng mekedduma ri se kumbira tu sek pedlegari' nud Diwata!” ");
INSERT INTO stb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mbuus inesuyan giin ni Jesus, “Duunik sala tawan neng mingandam ne gembagel ne kumbira, bu' melaunik pingenggaten. ");
INSERT INTO stb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Peddateng se guras neng menihapun na, sinugu'en suk sesugu'enen ne dlawan su ngak pingenggat bu' esuyan ilan, ‘Perini amu na, mi'andam na su dlaunen.’ ");
INSERT INTO stb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ma'ad salasala ri senilan mimbelibad ne ndi' mekeritu. Miktalu' suk sala, ‘Beguu ra mekesaluy ne dlupa' bu' kina'enlan lawan'u enlengay. Aas pasaylu mau na ma'aray.’ ");
INSERT INTO stb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Miktalu' pa gaid suk sala, ‘Ndi'u mekeritu ay beguu ra mekesaluy ne dlima perisan ne ngag baka bu' indanan'u bu' mpiya ba peddaru. Aas pasaylu mau na ma'aray.’ ");
INSERT INTO stb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Miktalu' pa gaid suk sala, ‘Beguu ra kesalay, aas ndi'u gaid mekeritu.’ ");
INSERT INTO stb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Peketubus, mipuli' suk sesugu'en bu' inasuyeni dlaunen keni ritu se gegalenen. Linengetan su gegalenen bu' miktalu' giin tu sek sesugu'enen, ‘Sempun'a peritu se ngad dalan neng meliwag bu' mesikut rini se dlunsud bu' uwit mu rini su ngak pupus, ngak pingkaw, ngag buta, bu' ngag bekul.’ ");
INSERT INTO stb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Seng mibaal na nuk sesugu'en, miktalu' giin tu se gegalenen, ‘Sir, mituman'u na suk sinugu' mu ri senaan, ma'ad duun pai gingkuran ritu sek pengaanan.’ ");
INSERT INTO stb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Aas miktalu' su gegalenen ri seniin, ‘Peritua se ngad dalan bu' ngang meliyaw ned dalan gawas se dlunsud bu' peperini mu su nga getaw neng me'enggat mu, arun mpenu' sug balay'u. ");
INSERT INTO stb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Esuyan'u amu ne nda'iruni isan sala ri senilan ne guna ne ginenggat'u neng mekiinam ri sek penihapun ne ginandam'u!’ ” ");
INSERT INTO stb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Duuni gembagel nek panen ne nga getaw neng middunut riin ni Jesus, bu' midlingay giin bu' miktalu' ri senilan, ");
INSERT INTO stb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bu' duuni nga getaw neng meriin senaan, ndi' ilan mbaal ne ngak tinu'unan'u bu' pinetail nilan kampuun su ngang megulang nilan, su ngak sawa nilan, su ngag bata' nilan, su ngak pated nilan, bu' su nga gegulingen nilan ne ketubu' sinangkali' ri senaan. ");
INSERT INTO stb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Isan ta' ne genda' pekpisaan ri se gegulingen nilan ne krus bu' meksunud ri senaan, ndi' mbaal nek tinu'unan'u. ");
INSERT INTO stb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bu' sala riin seniyu neng mikpelanu sek pegbakud neng metaas neg balay, megingkud reli' giin bu' megbelabena' bu' santa' sung megastuun arun enlengan bu' duun bai gigu' nek selapi'en arun metubus suk terbahu. ");
INSERT INTO stb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bu' ndi'en pelanuun, ndi'en megenep sek pektubus, tubusen baalay suk penligen; bu' su dlaun neng mikiita' seng mihitabu' peketuwanan ra giin. ");
INSERT INTO stb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Mektalu' ilan, ‘Getaw keni mingatuwatu megbaal neg balay ma'ad ndi'en masi'ay metubus.’ ");
INSERT INTO stb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Bu' suk sala ne gari' ned duunik sepulu' libu nek sundaluun gumubat kuntra tu se dlain ne gari' ned duunid duwa' pulu' libu nek sundaluun, ndi' ba giin megingkud reli' bu' megukum bu' mekesukul ba giin se gari' ketu? ");
INSERT INTO stb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bu' ndi' giin mekesukul, meksugu' giin ne getaw tu se gari' ketu sek peksungkak sinegay melayu' pa giin, arun meksabutsabut para se kelinaw. ");
INSERT INTO stb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Seng maa' ra run nek pebiyan,” tinapus ni Jesus, “nda'irun riin seniyu ne gembaal ne ngak tinu'unan'u bu' ndi' niyu belengen su dlaun ned diin seniyu.” ");
INSERT INTO stb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sung maasin melengas, ma'ad bu' merala' na su kepaiten, ndi' na mehimu pa mpuli' su kepaiten. ");
INSERT INTO stb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ndi' na ini megamit isan ri se dlupa' awas para baalen ne gabunu. Belengen na ma'aray ini. Gamu ne ngang mikerengeg run nini, penginengeg amu.” ");
INSERT INTO stb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na, sala ne gendaw itu duuning melaun ne ngang meneningil neg buwis bu' ngang mekesesala' neng miritu ni Jesus arun menginengeg ri seniin, ");
INSERT INTO stb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","mbuus migburuburu su ngak Pariseo bu' ngang menintulu' ri se Kesugu'an. “Getaw keni mindawat ne nga getaw neng mekesesala' bu' midduma pa ri senilan sek pekpengaan!” ");
INSERT INTO stb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aas, inesuyan ilan ni Jesus ne galing: ");
INSERT INTO stb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Penenggi', sala ri seniyu duuning megatus ne nga karniruun bu' mirala' suk sala senilan. Landun maig baalen mu? Belengen mu suk siyam pulu' bu' siyam ne nga karniru ritu sek pengeksaban bu' penengaun mu sung mirala' ne karniru tampan me'ita' mu ini. ");
INSERT INTO stb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Seng me'ita' mu na ini, pedleliyagen'a nek pisaanen mu ");
INSERT INTO stb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","bu' uwiten puli' tu seg balay. Rayun tuwagen mu su ngak sambat mu bu' ngak sumbalay mu bu' mektalu'a ritu senilan, ‘Pidleliyagu ay mibaangan'u na su karniruu neng mirala'. Pedleliyag amu duma ri senaan!’ ");
INSERT INTO stb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Seng maa' ra run nek pebiyan, telu'an'u amu, ne gembagel kampuuni dleliyag ritu se dlangit sek sala tawan neng mekesesala' neng meddiksu' lungkan sek siyam pulu' bu' siyam ne ngang metareng ne ndi' meddiksu'.” ");
INSERT INTO stb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Penenggi', duunik sala ne dlibun ned duunik sepulu' ne ngak sinsilyuun bu' mirala' suk sala run nini. Landun maig baalenen? Tuturaan gaid suk sulu' rayun siligaan gupiya sug balain bu' tumbayaan gupiya penengaway suk sinsilyu tampan mbaangaan nini. ");
INSERT INTO stb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Seng me'ita'en na ini, pensebiinen rayun su ngak sambaten bu' su ngak sumbalain bu' mektalu' ri senilan, ‘Pidleliyagu gupiya, ay mi'ita'u suk sinsilyu neng mirala'. Pedleliyag amu rema duma ri senaan!’ ");
INSERT INTO stb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Seng maa' ra run nek pebiyan, telu'an'u amu, su ngag anghel nud Diwata pedleliyagen ri sek sala tawan neng mekesesala' neng meddiksu'.” ");
INSERT INTO stb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Bu' mikpeddayun si Jesus sek pektalu', “Duunik sala tawan ned duunid duwa' buuk neg bata'en ne dlai. ");
INSERT INTO stb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Miktalu' su nguran ri se gama'en, ‘Itay, begay mu na ri senaan sug bahin'u ri se ketigeyunan numuun.’ Aas binahin nu gama'en su nga ketigeyunaan ritu senilan duwa' ne ngag bata'en. ");
INSERT INTO stb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Peksagad sek santa' endaw, pimeledya' nu nguran sug bahinen ne ketigeyunan bu' midlaang tu seng melayu' neng nasud ne ritu pigula'ula'aan ma'ad suk selapi'en ri sek pedleketubu' ne genda'irunik paluun, ");
INSERT INTO stb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","tampan migela' su dlaunan. Mbuus minateng su gembagel ne gutem seng nasud ketu bu' midlised gupiya giin. ");
INSERT INTO stb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aas minerbahu na ma'aray giin tu se getaw ri seng nasud ketu bu' sinugu' giin meritu seg binaalen arun mekpaan ne ngag babuy. ");
INSERT INTO stb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tendeng se keperii'en, mayak na siya giin maan tu se ngag bunga ne gayu nek pempaan se ngag babuy; nda'iruning mikegbegay ne gaan ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Se ketambinai', mikegena'ena' giin ri se gembagel nek sayepen bu' miktalu', ‘Minubra su gaan nu ngak sinu'ulan ne gama'u, saanay gaku' rini, matayu se gunus! ");
INSERT INTO stb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Aas muli'u na ma'aray ritu se gama'u bu' telu'an'u: “Itay, mikesala'u ri sed Diwata bu' ri seni'a. ");
INSERT INTO stb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ndi'u na mbaya' tuwagen neg bata' mu; gisip mau na ma'aray nek sala se ngak sinu'ulan mu.”’ ");
INSERT INTO stb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aas migindeg giin bu' minuli' ritu se gama'en. Saanay melayu'layu' pa giin tu seg balay nilan, mirayag giin nu gama'en. Milelaat giin tu seg bata'en bu' ginumebek bu' rayun inekepen giin bu' inelekaan. ");
INSERT INTO stb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mbuus miktalu' sug bata'en, ‘Itay, mikesala'u ri sed Diwata bu' ri seni'a. Ndi'u na mbaya' nek tuwagen neg bata' mu.’ ");
INSERT INTO stb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ma'ad tinawag nu gama' su ngak sesugu'en bu' miktalu', ‘Rini amu, sempun niyu uwitay rini sung melengas gupiya nek suub bu' peseluk niyu ri seniin. Pesisingay bu' pesandalyasay niyu giin. ");
INSERT INTO stb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Peketubus uwan niyu sung nati neg baka nek pilembu' bu' titi' niyu ay mekpebibu bu' medleliyag ita! ");
INSERT INTO stb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tendeng ay laung'u run minatay naig bata'u keni ma'ad nandaw tetubu' pa. Mirala' giin ma'ad nandaw mi'ita' na.’ Aas migatad suk pekpebibu.” ");
INSERT INTO stb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Se guras ketu, ritu pa seg binaal su gulangbata' bata'en. Seng mikpeguli' na giin bu' megaud na giin tu seg balay, mirengegen suk talu' ne ngak petenugen bu' tinelekan. ");
INSERT INTO stb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aas tinawagen suk sala se ngak sesugu'en bu' miksaak, ‘Migendun amu ma run?’ ");
INSERT INTO stb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Inesuyan giin nuk sesugu'en, ‘Minateng na su nguran mu. Pititi' nu gama' niyu suk pilembu' neng nati neg baka ay mipuli' na suk pated mu ne genda'iruning melaat neng mihitabu' ri seniin.’ ");
INSERT INTO stb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Linengetan gupiya su gulangbata' bu' ndi'en na liyagan sumeled tu seg balay. Aas ginumawas su gama'en bu' pingamu' giin arun sumeled. ");
INSERT INTO stb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma'ad miktalu' giin tu se gama'en, ‘Pegena'ena' mu ra ugud, itay, bu' santa' taunu na sek pekterbahu seni'a maa' ne gulipen. Nda'u gaid peksupak ri seni'a. Landun maig binegay mu ri senaan? Isan neng nati ne kanding na run, nda' mau gaid begayay arun medleliyagu duma se ngak sambat'u. ");
INSERT INTO stb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma'ad sek peddateng neg bata' mu kiin neng migula'ula' ri se nga ketigeyunan mu duma ri se ngang mekelaat ne nga dlibun, pititi'an mu pa giin nek pilembu' neng nati neg baka!’ ");
INSERT INTO stb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ma'ad miksembag su gama'en, ‘Enung, dya'a kanunay rini senaan bu' dlaun neng naan ni'a rema. ");
INSERT INTO stb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mbaya' gaid neng mekpebibu bu' medleliyag ita ay laung ta run minatay na su nguran mu, ma'ad nandaw tetubu' pa. Mirala' giin ma'ad nandaw mibaangan na.’” ");
INSERT INTO stb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na, migasuy si Jesus ri se ngak tinu'unaan, “Duunik sala tawan ned datu' ned duunik sineligaan ri se ngak petigayunen. Tinelu'an sud datu' ne suk selapi'en pigula'ula'an nuk sineligaan. ");
INSERT INTO stb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aas pitawagen giin bu' miktalu', ‘Landun maing mirengeg'u keni metendeng ri seni'a? Megbalansiyay ita sek petigayun'u, tendeng ay ndi'u na dya'a meseligan.’ ");
INSERT INTO stb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Miktalu' suk sesugu'en ri se gegulingenen, ‘Pepe'uwa'enu na ne gegalen'u buwat ri se ketendanan'u. Laa sakanig baalen'u? Ndi'u megaga memungkal ne dlupa' bu' mpiiru rema mekpelimus. ");
INSERT INTO stb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa, nandaw misuunan'u bu' landunig baalen'u! Rayun seng me'awa'u na ri sek terbahuu, duuni ngak sambat'u ned dumawat ri senaan tu seg balay nilan.’ ");
INSERT INTO stb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Aas pitawagen su dlaun neng mingutang ri se gegalenen. Miksaak giin ritu seng mi'una, ‘Santa' mai gutang mu ri se gegalen'u?’ ");
INSERT INTO stb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Sinembag giin, ‘Megatus galun ne dlana neg olibo.’ Miktalu' suk sineligan ri seniin, ‘Ala, keni ra su dlistaan mu, gingkud'a reli' bu' sulat mu rayun ne dlima pulu' ra.’ ");
INSERT INTO stb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Peketubus, miksaak giin tu se keruwa', ‘Bu' dya'a, santa'i gutang mu ri se gegalen'u?’ Miksembag giin, ‘Sala libu gantang nek trigu.’ Suk sineligan miktalu', ‘Ala, keni ra su dlistaan mu, sulat mu neg walu gatus gantang ra.’ ");
INSERT INTO stb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Su gegalen nu dlimbungan nek sineligan keni miksaya' ri seniin tendeng se ketelapaan; ay su nga getaw rini seg benwa metelapan pa kampuun sek peguwit se ngag baalen nilan sinangkali' se nga getaw neng misakup riin se kerelaag.” ");
INSERT INTO stb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Bu' mikpeddayun sek pektalu' si Jesus, “Aas telu'an'u amu: Isan metuud ne su ketigeyunan ginamit sek pekpenlimbung, gamit niyu ini sek pekpensambat, arun sek peddateng ne gendaw, ne genda' nai ketigeyunan niyu, duwaten amu nilan ritu sek pekengelan ne nda' nai gekteben. ");
INSERT INTO stb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Su getaw ne keseligan ri seng mekiika' ne ngag betang, keseligan rema se gembagel ne ngag betang. Bu' su getaw ne dlimbungan seng mekiika' ne ngag betang, limbungan rema se gembagel ne ngag betang. ");
INSERT INTO stb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Aas, bu' ndi' amu keseligan sek pegamit ri se ketigeyunan rini seg benwa, ta' maing mekpiyal seniyu ri seng metuud ne ketigeyunan? ");
INSERT INTO stb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bu' ndi' amu keseligan ri se ngag betang ned duma, ta' maing megbegay seniyu se gegulingen niyu neg betang?” ");
INSERT INTO stb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Nda'irunik sesugu'en ne mbaal ne gulipen sed duwa' ne nga gegalen ay gemetaan suk sala bu' suk sala petailenen; unungaan suk sala bu' suk sala pemuraanen. Ndi'a mehimu mekpe'ulipen ri sed Diwata bu' sek selapi'.” ");
INSERT INTO stb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sek pekerengeg run nitu ne ngak Pariseo, piddega'rega'an nilan si Jesus, tendeng ay merelaw ilan ri sek selapi'. ");
INSERT INTO stb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Miktalu' si Jesus ri senilan, “Mikpekemetareng amu ri sek pengenleng ne nga getaw, ma'ad misuunan ned Diwata su nga gena'ena' niyu. Ay suk pigena'ena' ne nga getaw ne gembagel ne dlaga'en nda'iruni dlaga'en ri sek pengenleng ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mikpalu su Kesugu'an ni Moses bu' su ngak sinulat nu ngak propeta tampan ra sek panahun ni Juan neng Membebendyag. Buwat itu inasuy sung Melengas ne Gesuyen metendeng sek Pedlegari' ned Diwata bu' suk sala ne getaw linumeges sek pekseled run nini. ");
INSERT INTO stb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ma'ad melemu pa me'alep su dlangit bu' dlupa' sinangkali' seng mitut gupiya neg bahin ri se Kesugu'an.” ");
INSERT INTO stb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Bu' ta' ne dlai neng meleng ri sek sawaan bu' mengesawa ne dlain ne dlibun mikepenapaw; bu' sung mengesawa tu se dlibun neg bineleng mikepenapaw rema.” ");
INSERT INTO stb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Nud diin duunik sala tawan ned datu' neng minuub neng melaga' nek suub bu' gendawendaw mikpetuyang mekaan seng nenaman ne gaan. ");
INSERT INTO stb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bu' duun remaik sala nek pupus ne su ngalanen si Lazaro ne su dlawasen milaup neng nuka. Kanunay giin uwiten ritu se genga'an neg balay nud datu', ");
INSERT INTO stb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","midderama sa'wan neng mekekaan isan ne ngang mumu na run neng meladdu' buwat ri se dlemisaan nud datu'. Isan su nga gitu' mikpegaud rema bu' dinila'an su ngang nukaan. ");
INSERT INTO stb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nda' santa', minatay suk pupus ne si Lazaro bu' inuwit giin nu ngag anghel pi'ingkud tepad ni Abraham tu se kumbira tu se dlangit. “Sud datu' minatay rema bu' linebeng ");
INSERT INTO stb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","bu' ritu se dlugar ne ngang mimatay, migantus gupiya giin. Migangag giin bu' mi'ita'en tu seng melayu' si Abraham bu' ritu sek teparen si Lazaro. ");
INSERT INTO stb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Aas miktawag sud datu' riin ni Abraham, ‘Uu! Apu' Abraham, lelaatay mau! Pawit mu si Lazaro rini arun duliten ri sek tubig suk tendu'en bu' peteddawaan sud dila'u ay migantusu se kiinit ne gapuy keni!’ ");
INSERT INTO stb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ma'ad sinembag giin ni Abraham, ‘Apung, pegena'ena' mu ne sed ditua pa seg benwa, mirawat mu na sung melengas ne ngag betang, saanay misegaran ni Lazaro su nga keliseran. Ma'ad numuun, pedleliyagen giin rini saanay dya'a riin migantus. ");
INSERT INTO stb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gawas pa se dlaunan, duuning meralem ne gawang neng migelet senita arun nda'ing mekeripag buwat rini pagaw riin seni'a awas buwat riin pagaw rini senami.’ ");
INSERT INTO stb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Miktalu' sud datu', ‘Apu' Abraham, bu' maa'entu, endyu'en'u dya'a ne bu' mehimu sugu' mu si Lazaro ritu se gepenan'u, ");
INSERT INTO stb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ay duun pai dlima tawan nek pated'u ne nga dlai. Peperitu mu giin bu' penegulaan ilan arun ndi' ilan mekerini se dlugar keni nek puru ra nek pegantus.’ ");
INSERT INTO stb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma'ad miksembag si Abraham, ‘Su ngak pated mu mikebasa sek sinulat ni Moses bu' se ngak sinulat ne ngak propeta. Kina'enlan pengimbaanen nilan itu.’ ");
INSERT INTO stb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Miksembag sud datu', ‘Ma'ad Apu' Abraham, gena' pa gigu'! Ma'ad bu' duuning mitubu' puli' buwat seng mimatay bu' meritu senilan, meddiksu' ilan ri se ngak sala' nilan.’ ");
INSERT INTO stb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma'ad miktalu' si Abraham, ‘Bu' ndi' ilan ngani' mengimbaan se ngak sinulat ni Moses bu' se ngak propeta, na, ndi' ilan na gaid mektu'u isan duuning metubu' puli' buwat se ngang mimatay!’” ");
INSERT INTO stb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Miktalu' si Jesus tu se ngak tinu'unaan, “Su ngag betang neng mekegbaal se nga getaw sek pekpekesala' mehitabu' gaid; ma'ad mekelelaat su getaw ne tendeng ri seniin, mehitabu' ne ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Melengas pa ri seniin ne iketani dliigen se gembagel neg batu ne dligisan bu' leddu'en giin tu sed dagat ay se mbaal giin ne getaran sek pekpekesala' sek sala seng miika' ne ngag bata' keni. ");
INSERT INTO stb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Aas pekpetigaam amu ri se ngag baalen niyu!” “Bu' mekesala'ik sementaun mu, pemaag mu giin. Bu' meddiksu' giin, pasaylu mu rema. ");
INSERT INTO stb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bu' mekesala' giin seni'a se kepitu puli' sek sendaw, bu' se kada nek panahun meritu seni'a neng mektalu' ‘Pasaylu mau,’ kina'enlan nek pasayluun mu giin.” ");
INSERT INTO stb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Miktalu' su nga gapustulis ri se Ginu'u, “Dugangay mu suk pektu'u nami.” ");
INSERT INTO stb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Miksembag su Ginu'u senilan, “Bu' duunik pektu'u niyu isan maa' kitut ne dlisu neng muntasa, mbaal niyu suk pektalu' se gayu keni, ‘Mbakut'a bu' mpemulaa sed dagat!’ Bu' keni mekpetuud ri seniyu.” ");
INSERT INTO stb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Penenggi', duunik sala seniyu ned duunik sesugu'enen neng middaru awas migbantay ri se nga karniru. Bu' mateng giin buwat seg binaal, telu'an mu ba giin, ‘Peksempun'a bu' aan'a?’ ");
INSERT INTO stb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ndi' gaid. Ngani' mektalu'a, ‘Ala, andam mu reli' suk penihapun'u, bu' ilakay mau tampan metubusu maan. Rayun peketubus'u maan, maan'a rema.’ ");
INSERT INTO stb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Suk sala nek sesugu'en ndi' mbaya' pesalamatan tendeng sek pektumanen se ngak sugu', ndi' ba? ");
INSERT INTO stb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Maa' run rema gamu. Bu' mibaal na niyu su dlaun nek sinugu' riin seniyu, talu' niyu, ‘Ngak sesugu'en ami bu' migbaal ma'aray se ketendanan nami.’” ");
INSERT INTO stb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Seng mikpagaw giin tu seg Jerusalem, minayan si Jesus ri sed dulunan nek Samaria bu' Galilea. ");
INSERT INTO stb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bu' sek pekseleren ri sek sala neg baryu, sinungkak giin nek sepulu' tawan neng midlaru seng mekeendekendek ne dleruun ri sek panit. Mingindeg ilan ra ri seng melayu'layu', ");
INSERT INTO stb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bu' mimbeksay, “Jesus, Ginu'u! Melelaat'a ri senami!” ");
INSERT INTO stb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pekiita' ni Jesus senilan, miktalu' giin, “Ritu amu se ngak pari' bu' pekpe'enleng amu.” Saanay midlaang ilan pa, mitelen ilan na. ");
INSERT INTO stb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sek pekiita' nuk sala ri senilan neng mitelen na giin, mipuli' giin tu ni Jesus. Seng mesekeg nek talu', miksaya' giin sed Diwata. ");
INSERT INTO stb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Middempug giin ri se geksud ni Jesus bu' mikpesalamat ri seniin. Getaw ketu taga Samaria. ");
INSERT INTO stb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mbuus miktalu' si Jesus, “Gena' ba sepulu' tawan maing mitelen? Ta' nema suk siyam? ");
INSERT INTO stb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Lama sakan nda'irun isan sala ri senilan neng mipuli' arun mekpesalamat ri sed Diwata gawas ri se getaw keni neg buwat se dlain neng nasud?” ");
INSERT INTO stb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bu' miktalu' si Jesus ri seniin, “Gindeg'a bu' uli'a na. Suk pektu'u mu giin sung mikepetelen seni'a.” ");
INSERT INTO stb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Duma ne ngak Pariseo miksaak riin ni Jesus bu' nanu suk pedlegari' ned Diwata. Miksembag si Jesus ri senilan, “Suk pedlegari' ned Diwata gena' betang neng me'ita'. ");
INSERT INTO stb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aas nda'iruning meketalu', ‘Enlengay niyu, keni ra!’ awas, ‘Ritu!’ Ay suk pedlegari' ned Diwata riin na seniyu.” ");
INSERT INTO stb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mbuus miktalu' si Jesus ri se ngak tinu'unaan, “Matengik panahun neng mengangut amu sa'wan neng me'ita' niyu isan sala se nga gendaw sug Bata' ne Getaw ma'ad ndi' niyu ini me'ita'. ");
INSERT INTO stb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Duuni nga getaw neng mektalu' ri seniyu, ‘Enlengay niyu, ritu giin!’ awas, ‘Rini giin!’ Ma'ad ndi' amu peritu sek pekpenengaw run nini. ");
INSERT INTO stb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ay maa' ne gilat ne kuminlap ri se dlangit bu' meddelaag buwat ri se dlain neg bahin pagaw sed dibaluy, maa' run rema su gendaw sek peddateng neg Bata' ne Getaw. ");
INSERT INTO stb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma'ad kina'enlan neng meleget reli' ne ngak pegantusi gembiyanaan. Bibain giin ne nga getaw sek panahun keni. ");
INSERT INTO stb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Bu' landunig binaal nu nga getaw sek panahun ni Noe, giin remaig baalen ne nga getaw se gendaw nek peddateng neg Bata' ne Getaw. ");
INSERT INTO stb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Salasala ri senilan miksigi ma'aray maan, minum, bu' minsuway tampan minateng su gendaw nek sinumeled ilan ni Noe tu seg arka. Mbuus minateng sug baa' bu' dlaun nilan milemes. ");
INSERT INTO stb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Maa' rema sek panahun ni Lot, su nga getaw miksigi ra maan, minum, memenaluy, memeledya', menggimula, bu' membaal neg balay nilan. ");
INSERT INTO stb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma'ad se gendaw ketu ne ginumawas si Lot sek Sodoma, middupi' ritu ne gapuy bu' asupri buwat se dlangit bu' mimatay ilan gela'. ");
INSERT INTO stb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Giin rema ini sung mehitabu' se gendaw neng mekpe'ita' sug Bata' ne Getaw. ");
INSERT INTO stb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Se gendaw ketu, su getaw, ned diin seng melantang ne gatep neg balain, ndi' na kina'enlan menaug pa arun uwanenen su ngag betangen. Bu' sud ditu seg binaal, ndi' na kina'enlan muli' pa tu seg balain. ");
INSERT INTO stb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pegena'ena' niyu sung mihitabu' ri sek sawa ni Lot. ");
INSERT INTO stb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Su ngang menugaling sek pedluwas ri se ketubu' nilan, merela'an tumu' run nini. Ma'ad su ngang merela'an ne ketubu' nilan, meluwas run nini. ");
INSERT INTO stb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Telu'an'u amu, se gebii ketu, bu' duunid duwa' tawan neng mektepad sek pektulug sek sala nek pektulugan, suk sala uwanen bu' suk sala bilinen. ");
INSERT INTO stb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Bu' duunid duwa' ne dlibun neng medligis, suk sala uwanen bu' suk sala bilinen.” ");
INSERT INTO stb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mbuus miksaak su ngak tinu'unan, “Ta' ma, Ginu'u?” Sinembagen ilan pibiyan ri sek penuntulen, “Bu' ta' su ngag bangkay, ritu rema mektipempen su ngang manuktalun neng maan ne ngag bangkay.” ");
INSERT INTO stb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mbuus inesuyan na peluman ni Jesus su ngak tinu'unaan ne galing arun tendu'an ilan ne kina'enlan neng megampu' kanunay bu' ndi' merela'an sek pedderama. ");
INSERT INTO stb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Miktalu' giin, “Duunik sala neng mengengukum ri sek sala ne dlunsud ne genda'iruni gendeken ri sed Diwata bu' ndi' megbasa ri se getaw. ");
INSERT INTO stb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na, duunig balu ne dlibun se dlunsud ketu neng mikpuli'puli' tu seng mengengukum arun megandyu' nek peneliperan su ketengeren, laungen, ‘Ebangay mau kuntra ri se kuntrau.’ ");
INSERT INTO stb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Se gempayat nek panahun, ndi' megabang sung mengengukum. Ma'ad sek tambinai', migena'ena' giin ri se gegulingenen, ‘Isan metuud ne ndi'u mendek ri sed Diwata bu' ndi'u megbasa ri se getaw, ");
INSERT INTO stb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ma'ad tendeng ay miksamuksamuk ri senaanig balu ne dlibun keni, penentuwan'u neng me'uwanen su nga ketengeren. Bu' ndi', kanunay giin mekpuli'puli' tampan merela'anu nek pekpelugbak.’” ");
INSERT INTO stb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na, mikpeddayun sek pektalu' su Ginu'u, “Penginengegay niyu landunik tinalu' neng mengengukum ne gena' metareng. ");
INSERT INTO stb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Na, gena' ba mengukum sud Diwata dapig ri se nga getawan neng miktawag neng miksegaw ri seniin se gendaw bu' gebii para me'ebangan? Linanganlangan ilan ba? ");
INSERT INTO stb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Telu'an'u amu, mengukum giin dapig senilan bu' sempunenen ini sek pegbaal. Ma'ad sug Bata' ne Getaw mekebaang ba sakan ne getaw ned duunik pektu'uun rini seg benwa sek peddatengen?” ");
INSERT INTO stb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na, inesuyan rema ni Jesus ne galing su nga getaw neng miktu'u ne gilan ra gaid sung metareng bu' pimura nilan sud duma. ");
INSERT INTO stb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Duunid duwa' ne dlai nek tinumuwad ritu sek Templo arun sek pegampu'. Suk sala Pariseo bu' suk sala meneningil neg buwis. ");
INSERT INTO stb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Migindeg suk Pariseo neng mikpelayu' tu sed duma bu' migampu', ‘Mikpesalamatu ri seni'a, Diwata ne gena'u neng merelaw, gena' ne dlimbungan, gena' neng menlibun maa' ned duma. Mikpesalamatu ri seni'a ne gena'u maa' neng meneningil neg buwis kiin. ");
INSERT INTO stb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Meruwa'u mekpu'asa se kada simana, bu' migbegayu se kesepulu' neg bahin se dlaun nek pinengawan'u.’ ");
INSERT INTO stb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ri se dlain neg bahin, sung meneningil neg buwis migindeg ri seng melayu'layu' bu' nda' tanan pegangag tu se dlangit, ma'ad dinanegen su geddeben sek peddiksu' bu' miktalu', ‘Diwata, lelaatay mau, mekesesala'u!’” ");
INSERT INTO stb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Rayun miktalu' si Jesus, “Telu'an'u amu, sung meneningil neg buwis bu' gena' suk Pariseo, giin suk pimetareng ned Diwata. Ay isan ta' sung mekpetaastaas ri se gegulingenen pebeba'en, ma'ad sung mekpebaba' ri se gegulingenen petaasen.” ");
INSERT INTO stb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na, miguwit sud duma ne nga getaw se ngang mekiika' ne nga gembata' ritu ni Jesus arun depenaan ilan. Sek pekiita' ne ngak tinu'unaan dun, binelebagan nilan ilan. ");
INSERT INTO stb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma'ad tinawag ni Jesus su nga gembata' neng mekpegaud ri seniin, bu' miktalu', “Pesaddan na ma'ad niyu su nga gembata' neng mekpegaud ri senaan. Ndi' niyu ilan pegengay ay suk pedlegari' ned Diwata para tu se nga getaw neng maa' ne ngang mekiika' ne gembata' keni. ");
INSERT INTO stb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sek pekemetuud, telu'an'u amu, isan ta' ne getaw ne gendi' dumawat sek pedlegari' ned Diwata, maa' neg bata' keni, ndi' gaid mperuma run nini.” ");
INSERT INTO stb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Miksaak su geseg neg Judeo riin ni Jesus, “Gempiya neng Menintulu', landun maig baalen'u arun mekaangkenu ne ketubu' ne genda'iruni gekteben?” ");
INSERT INTO stb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Miksembag si Jesus ri seniin, “Lama mektalu'a run ne gaku' gempiya? Nda'irun isan ta' ne gempiya bu' gena' sud Diwata ra. ");
INSERT INTO stb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Misuunan mu nema su Kesugu'an: ‘Ndi'a menapaw, ndi'a mekpatay, ndi'a meddaaw, ndi'a menintigus neg balus, pegbesaay mu su gama' mu bu' su gina' mu.’” ");
INSERT INTO stb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Miksembag su getaw, “Dlaunan keni tinuman'u na gatad pa sek pekebegumbata'u.” ");
INSERT INTO stb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sek pekerengeg ni Jesus ri sek sembagen, miktalu' giin, “Sala pa gaid neg betang ne mbaya' mu baalen. Beledya' mu su dlaun nek petigayun mu, bu' su galinen pengaperaped mu tu se ngak pupus. Bu' duunig bahandi' mu ritu se dlangit. Peketubus, puli'a rini bu' peddunut'a senaan.” ");
INSERT INTO stb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ma'ad sek pekerengegen run, miremeng giin tendeng ay datu' ma gupiya giin. ");
INSERT INTO stb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sek pekiita' ni Jesus neng miremeng sud datu', miktalu' giin, “Melised gaid para ri se ngad datu' neng mekpesakup sek pedlegari' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ay melemu pa kampuun sek pedlesut ne kamelyo ri se dluwang nek tai' sinangkali' sed datu' sek pekpesakup ri sek pedlegari' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mbuus miksaak su ngang mikerengeg se ginasuy ni Jesus, “Bu' maa' niin, ta' ma ma'aray sung meluwas?” ");
INSERT INTO stb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sinembag ilan ni Jesus, “Duuni ngag betang ne ndi' mbaal ne getaw ma'ad mbaal ned Diwata su dlaun ne ngag betang.” ");
INSERT INTO stb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mbuus miktalu' si Pedro, “Enlengay mu, bineleng na nami su dlaunan arun sek peddunut ri seni'a.” ");
INSERT INTO stb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Miktalu' si Jesus ri senilan, “Telu'an'u amu, nda'irun isan ta' neng megbeleng ri sek pekengelaan, sawaan, ngak pateren, ngang megulangen, awas nga gembata'en tendeng sek pekpesakupen sek pedlegari' ned Diwata, ");
INSERT INTO stb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ne gendi' mekerawat sek panahun keni ne dlabaw pa kampuun ri seg binelengen. Bu' seng mateng ne gendaw, mekerawat giin ne ketubu' ne genda'iruni gekteben.” ");
INSERT INTO stb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pinain ni Jesus suk sepulu' bu' ruwa' ne nga gapustulis bu' tinelu'aan, “Penginengeg amu! Tinumuwad ita na pagaw seg Jerusalem bu' ritu metuman su ngak sinulat ne ngak propeta metendeng ri seg Bata' ne Getaw. ");
INSERT INTO stb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tudyan giin nilan ritu se nga getaw ne gena' Judeo neng meddega'rega' ri seniin, mektampela' ri seniin bu' meddula' ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Latiguun nilan giin bu' petain giin, ma'ad se ketelu endaw metubu' giin puli'.” ");
INSERT INTO stb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ma'ad nda' gaid mekesabut su nga gapustulis se ngag betang keni; su gulugan ne ngak talu' linilung buwat ri senilan, bu' nda' nilan mesabut landunik tinalu' ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Seng megaud ilan na ni Jesus seg Jerico, duunik sala tawan neg buta neng migingkud ri se geksid ned dalan bu' mikpelimus. ");
INSERT INTO stb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Seng mirengegen neng melauni getaw neng minayan, miksaak giin, “Landun maing mihitabu'?” ");
INSERT INTO stb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Inesuyan nilan giin, “Minayan si Jesus nek taga Nazaret.” ");
INSERT INTO stb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aas migbeksay giin, “Jesus, Bata' ni David, lelaatay mau!” ");
INSERT INTO stb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pimaag giin nu nga getaw bu' tinelu'an ne ndi' meksasak. Ma'ad pisekegaan pa gaid tumu' suk pegbeksay, “Bata' ni David, melelaat'a ri senaan!” ");
INSERT INTO stb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aas mikeneng si Jesus bu' miksugu' ne uwiten sug buta ri seniin. Seng megaud na sug buta, sinaakan giin ni Jesus, ");
INSERT INTO stb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Landun mai dliyagan mu neg baalen'u ri seni'a?” Miksembag sug buta, “Ginu'u, liyagan'u neng mekiita' puli'.” ");
INSERT INTO stb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","“Mekiita'a na,” miktalu' si Jesus ri seniin, “Suk pektu'u mu giin sung mikepetelen ri seni'a.” ");
INSERT INTO stb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bu' rayun, mikiita' na giin. Middunut giin riin ni Jesus bu' miksaya' giin tu sed Diwata. Sek pekiita' nu nga getaw run nini, miksaya' ilan rema ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mirepet ilan ni Jesus tu seg Jerico, bu' saanay minayan ilan ritu, ");
INSERT INTO stb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","bu' enlengay niyu, duuni geseg neng meneningil neg buwis ritu ne iningelanan ne si Zakius neng meratu'. ");
INSERT INTO stb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Liyagaan me'ita' si Jesus ma'ad ndi'en me'ita' giin tendeng ay gembaba' giin ne getaw bu' melaun ne nga getaw riin sek timala' ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aas ginumebek giin tu se gunaan bu' minaik ri se gayu nek sikomoro arun me'ita'en si Jesus ne ritu biyan. ");
INSERT INTO stb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bu' sek peddateng ni Jesus ri se dlugar ketu, migangag giin bu' miktalu', “Uy, Zakius! sempun'a penaug rini, tendeng ay kina'enlan rituu peddayun seg balay mu nandaw.” ");
INSERT INTO stb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Bu' miksempun menaug si Zakius, bu' inalimba'en si Jesus se gembagel ne dleliyag. ");
INSERT INTO stb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bu' sek pekiita' nu nga getaw run nini, migburuburu ilan, “Uu! mimisita ma giin tu seg balay ne getaw neng mekesesala'!” ");
INSERT INTO stb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na, migindeg si Zakius bu' miktalu' ri se Ginu'u, “Penginengeg'a, Ginu'u! Begay'u su ketenga' se dlaun ne ketigeyunan'u ri se ngak pupus. Bu' ta' getaw sung milimbungan'u, biyaran'u giin se gepaat pilu'.” ");
INSERT INTO stb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Bu' si Jesus miktalu', “Nandaw, getaw keni miluwas bu' suk pamilyaan tendeng ay gasal ilan rema ni Abraham. ");
INSERT INTO stb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ay sug Bata' ne Getaw mirini arun sek pekpenengaw bu' pedluwas se dlaun neng mibalag.” ");
INSERT INTO stb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sinegay minginengeg su nga getaw, inesuyan ilan ni Jesus ne galing. Sek panahun ketu megaud ilan na mateng seg Jerusalem bu' migena'ena' su nga getaw neng megaud na mperayag suk pedlegari' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aas miktalu' si Jesus ri senilan, “Duuni getaw neg buwat se gasal ne ngang meselaag ne getaw. Getaw keni midlaang ri seng melayu' neng nasud arun mbaal ne gari', bu' peketubus itu, mikpelanu giin neng muli'. ");
INSERT INTO stb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ma'ad se genda' pa giin pedlaang, tinawagen suk sepulu' ne ngak sesugu'en bu' binegayaan suk salasala senilan ne ngag bulawan nek selapi', bu' miktalu' ri senilan, ‘Penigusyu niyu ini sinegay nda'u rini.’ ");
INSERT INTO stb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Se dlain neg bahin, su nga getawaan linengetan ri seniin. Aas seng mikedlaang na giin, mikpawit ilan ne nga getaw ritu sek pina'agawaan sek peksupak, ‘Ndi' nami liyagan ne getaw keni medlegari' ri senami.’” ");
INSERT INTO stb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Dluwat giin baalay ne gari', mipuli' giin bu' pitawagen rayun su ngak sesugu'enen arun mesuunan santa' su nga ginansiya nilan. ");
INSERT INTO stb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sung mi'una minateng bu' miktalu' ri seniin, ‘Sir, mikeginansiyau nek sepulu' pilu' ri seg binegay mu neg bulawan nek selapi' ri senaan.’ ");
INSERT INTO stb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Miktalu' su gari', ‘Melengas gupiya! Gempiyaa nek sesugu'en. Tendeng ay keseligan'a seng miika' ne ngag betang, piyalan'u dya'a nek sepulu' ne ngak siyudad.’ ");
INSERT INTO stb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Su keruwa' nek sesugu'en minateng rema bu' miktalu', ‘Sir, mikeginansiyau ne dlima pilu' ri seg binegay mu ne ngag bulawan nek selapi' ri senaan.’ ");
INSERT INTO stb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Miksembag su gari' ri seniin, ‘Piyalan'u dya'a ne dlima ne ngak siyudad.’ ");
INSERT INTO stb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Bu' rayun su ketelu nek sesugu'en miritu seniin bu' miktalu', ‘Sir, enlengay mu, keni ra sug bulawan nek selapi' mu. Pinutus'u gaid ini ri sek panuwilu, ");
INSERT INTO stb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ay minendeku ri seni'a, ay istriktua ma gupiya. Menguwan'a ne gena' ni'a, bu' menguwan'a rema nek sengku' isan gena' dya'a sung migimula run.’ ");
INSERT INTO stb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Miktalu' su gari' ri seniin, ‘Nda'ik palu mu nek sesugu'en! Suk tinalu' mu, giin remai gemiten'u sek pegukum ri seni'a. Misuunan mu ma ne gistriktuu. Rayun menguwanu ne gena' naan, bu' menguwanu rema nek sengku' isan gena' gaku' sung migimula run. ");
INSERT INTO stb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mbuus lama nda' mu betangay run ri seg bangku suk selapi'u? Rayun sek pekpuli'u, me'uwan'u suk selapi'u ned duun paik tubu'en!’ ");
INSERT INTO stb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Bu' rayun miktalu' su gari' tu se nga getaw neng mingindeg ritu, ‘Awi' niyu sug bulawan nek selapi' ri seniin bu' begay niyu tu se getaw neng mikeginansiya nek sepulu' pilu'!’ ");
INSERT INTO stb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bu' miktalu' ilan ritu se gari', ‘Sir, duun naik sepulu'en pilu'.’ ");
INSERT INTO stb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Bu' su gari' ketu sinumembag, ‘Telu'an'u amu, isan ta' ne getaw ned duuning niin, begayan pa. Ma'ad su genda'iruning niin, isan sung miika' ned diin seniin, uwi'en pa ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Bu' metendeng se nga getaw ne kumuntra ri senaan bu' ndi' nilan liyagan neng medlegari'u ri senilan, uwit niyu ilan rini bu' pematay niyu ilan ri seng metungenga'an'u!’” ");
INSERT INTO stb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sek peketubus ni Jesus megasuy se galing ketu, mikpeddayun giin pagaw tu seg Jerusalem neng miguna riin senilan. ");
INSERT INTO stb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bu' seng megaud ilan na se ngag baryu neg Betfage bu' Betania ritu seg Bentud ne ngag Olibo, pi'una ni Jesus sud duwa' tawan nek tinu'unanen, ");
INSERT INTO stb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","duma se ngak pemandu' keni: “Meritu amu sek sunud neg baryu; sek pekseled niyu, me'ita' niyu sung nati ne gasnu ne iniketan ne nda' pa gaid ini mayan sekayay. Ugbaray niyu bu' uwit niyu rini. ");
INSERT INTO stb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bu' duuning meksaak ri seniyu bu' lama ugbaran niyu run sung nati ne gasnu, sembagen niyu ne kina'enlanen ini ne Ginu'u.” ");
INSERT INTO stb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bu' sek pedlaang nilan duwa', mi'ita' nilan su dlaun nek tinalu' ni Jesus ri senilan. ");
INSERT INTO stb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bu' sanaay nilan pegugbaray sung nati ne gasnu, miksaak su nga gapu'en ri senilan, “Lama pegugbaran niyu run niin?” ");
INSERT INTO stb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Miksembag ilan, “Kina'enlanen ini ne Ginu'u.” ");
INSERT INTO stb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bu' rayun inuwit nilan su gasnu ritu ni Jesus bu' inenigan nilan ne dlambung nilan su dlekuren bu' pisakay nilan si Jesus. ");
INSERT INTO stb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bu' sek peksakain, pimbeklat nu nga getaw su nga dlambung nilan ri sed dalan. ");
INSERT INTO stb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Seng megaud ilan na tu seg Jerusalem, ri se dlugar ned diksunan neg bentud ne ngag Olibo, su gembagel nek panen ne ngak tinu'unanen mikpesalamat bu' miksaya' ri sed Diwata seng mesekeg nek talu' tendeng se dlaun ne ngang milagru neng mi'ita' nilan: ");
INSERT INTO stb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Pengumpiyanan ned Diwata su gari' neng mirini se ngalan ne Ginu'u! Duuni kelinaw riin se dlangit! Bu' pesiddengeg ritu sed Diwata!” ");
INSERT INTO stb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Rayun sud duma ne ngak Pariseo ned diin sek panen miktalu' riin ni Jesus, “Sir, pemendu'ay mu su ngak tinu'unan mu ne ndi' meksasak.” ");
INSERT INTO stb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Bu' sinembag ilan rayun ni Jesus, laungen, “Telu'an'u amu, bu' ndi' ilan meksasak, dlaun ne ngag batu keni megatad membeksay.” ");
INSERT INTO stb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Seng megaud ilan na ni Jesus ritu sek siyudad neg Jerusalem bu' sek pekiita'en run nini, miksegaw giin, ");
INSERT INTO stb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","laungen, “Bu' mikesuun'a pa siya nandaw bu' landuning mekegbegay ri senilan ne kelinaw! Ma'ad numuun ndi'a mekiita' run nini. ");
INSERT INTO stb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mateng suk panahun neng merendingan amu ne nga kuntra niyu, bu' epa'en amu, bu' mpikutan amu. ");
INSERT INTO stb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pepasen bu' pemetain su nga getaw neng mikengel riin se dlugar niyu. Bu' nda'irun isan sala neg batu neg bilinen nilan seng mibetangan run nini, ay nda' niyu ilelaay suk panahun neng mirini sud Diwata arun sek pedluwas ri seniyu.” ");
INSERT INTO stb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sinumeled rayun si Jesus tu sek Templo bu' pipe'awa'en su ngang mimeledya', ");
INSERT INTO stb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","bu' tinelu'anen ilan, “Misulat ini ri se Kesulatan neng miktalu' sud Diwata, ‘Sug balay'u giin su dlugar nek pegempu'an.’ Ma'ad binaal niyu ini ne gedluran ne ngang meddaaw.” ");
INSERT INTO stb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Gendawendaw minintulu' si Jesus tu sek Templo. Su nga geseg nu ngak pari', su ngang menintulu' ri se Kesugu'an, bu' su nga geseg ne nga getaw liyagan nilan nek petain giin, ");
INSERT INTO stb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ma'ad ndi' ilan mekiita' neg higayun sek pegbaal run nini, tendeng ay su dlaun ne nga getaw minginengeg gupiya ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Duun itui gendaw, minendu' si Jesus se nga getaw ritu sek Templo bu' migwali se Gempiya ne Gesuyen. Su nga geseg nu ngak pari', bu' su ngang menintulu' ri se Kesugu'an, bu' su nga geseg ri se nga getaw Judeo miritu ni Jesus ");
INSERT INTO stb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","bu' sinaakan nilan giin, “Esuyay mu ami bu' landun mai ketenged mu sek pegbaal run nini? Ta' maing migbegay ri seni'a ne ketenged?” ");
INSERT INTO stb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Miksembag si Jesus senilan, “Duun remaik saaken'u ri seniyu. Telu'ay niyau, ");
INSERT INTO stb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ta' ma migbuwat su ketenged ni Juan sek pegbendyag, sed Diwata ba awas se nga getaw?” ");
INSERT INTO stb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Miksabutsabut ilan bu' landunik sembag nilan, “Landun maing mesembag ta? Bu' mektalu' ita, ‘Buwat ri sed Diwata,’ meksaak giin senita, ‘Lama nda' amu pektu'u run riin ni Juan?’ ");
INSERT INTO stb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma'ad bu' meksembag ita, ‘Buwat ri se nga getaw,’ betuun ita ne nga getaw, tendeng ay miktu'u ilan ne si Juan propeta.” ");
INSERT INTO stb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aas miksembag ilan, “Nda' ami mekesuun bu' ta' migbuwat su ketenged ni Juan.” ");
INSERT INTO stb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mbuus miktalu' si Jesus ri senilan, “Bu' maa' niin, ndi'u amu rema tebalan bu' landuni ketenged'u sek pegbaal runi ngag betang keni.” ");
INSERT INTO stb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na, si Jesus migasuy ri se nga getaw ne galing, “Duuni getaw neng minggimula neng melaun ne gubas. Peketubus, pise'upaan tu sed duma neng mentetaun, bu' rayun midlaang seng melayu' ne dlugar se gempayat nek panahun. ");
INSERT INTO stb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sek panahun nek pempengupu' na ne gubas, sinugu'en suk sala tawan nek sesugu'enen ritu se ngak sa'up arun sek peguwan ri seg bahinen. Ma'ad binentul nilan suk sesugu'en bu' pipe'uli' ne genda'iruning mi'uwiten. ");
INSERT INTO stb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mbuus miksugu' puli' su gapu'en sek sala pa nek sesugu'en. Ma'ad peddateng sek sesugu'en ritu se ngak sa'up, binentul rema giin. Pikpiid gupiya bu' pipuli' rema nilan ne genda'iruning mi'uwiten. ");
INSERT INTO stb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Miksugu' pa gaid su gapu'en se ketelu nek sesugu'enen; pinegeelan giin nu ngak sa'up bu' inaleg. ");
INSERT INTO stb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Bu' su gapu' ne gubasan miktalu' ri se gegulingenen, ‘Landun sakanig baalen'u? Aa, pawit'u suk pinetail'u neg bata', ali' bu', pegbesaan ra nilan giin!’ ");
INSERT INTO stb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ma'ad ali' me'ita' nu ngak sa'up suk peddateng neg bata'en, miktalu' suk salasala ri senilan, ‘Na, keni na sung menenunud. Rini amu, bu' petain ta giin arun me'angken ta su gempenunuren.’ ");
INSERT INTO stb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aas binidlas nilan giin ritu se gawas ne gubasan bu' pinatay.” Mbuus miktalu' si Jesus tu se nga getaw, “Nandaw landun ma sakanig baalen nu gapu' ne gubasan ri senilan? ");
INSERT INTO stb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Siguru gaid ne dlawaan su ngak sa'up bu' pemetain. Mbuus pese'upaan ri se dlain su gubasaan.” Sek pekerengeg run nini nu nga getaw, miktalu' ilan, “Ndi' gaid!” ");
INSERT INTO stb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ma'ad tinenteng ilan gupiya ni Jesus bu' miksaak, “Landun ma rekay su gulugan sek tinalu' ri se Kesulatan? ‘Sug batu neg binibay ne ngak panday ne genda'ik paluun giin na ma'ad tumu' sung mibaal ne gimpurtanti nek penligen.’ ");
INSERT INTO stb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Su isan ta' sung meladdu' ri seg batu ketu mbeli'beli'an gaid; bu' ta' ma sung meleddu'an neg batu ketu, melukpeg gaid.” ");
INSERT INTO stb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Minantu ned daapen nu ngang menintulu' ri se Kesugu'an bu' nga geseg ne ngak pari' si Jesus sek panahun ketu ay misuunan nilan ne gilan gaid suk pigelingan ri se galingen. Ma'ad minendek ilan ri se nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Aas migelat ilan na ma'aray ne dlain neg higayun. Miksugu' ilan ne ngang meneni'id neng mekpelaunglaung ne mpiya suk tuyu' nilan arun bu' mekiita' ilan nek sayep ri sek pementelu'enen, rayun me'intrigu nilan tu se gobernador seg Roma ned duuni ketengeren bu' ga'emen sek pegbe'et. ");
INSERT INTO stb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ngang meneni'id keni miktalu' riin ni Jesus. “Sir, misuunan nami ne ginsaktu suk pingasuy bu' pimandu' mu. Misuunan nami ne nda'irunik pilabun mu isan ta', bu' ndi' miktendu'a metendeng se kemetuuran ned Diwata para ri se nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kina'enlan ba neng megbayad neg buwis tu se Gari' nu getaw Roma awas ndi'?” ");
INSERT INTO stb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma'ad misuunan ni Jesus ne suk tuyu' nilan giin suk pekseklut na run ri seniin, aas miktalu' giin ri senilan, ");
INSERT INTO stb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pe'ita'ay niyau nek selapi'. Ta' ma neng mulu' bu' ngalan runing mibetang riin?” Bu' miksembag ilan, “Se Gari'.” ");
INSERT INTO stb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aas miktalu' si Jesus ri senilan, “Bu' maa' niin, begay niyu ri se Gari' suk para ri se Gari' bu' ri sed Diwata suk para ri sed Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ri seng metungenga'an ne dlaunan, nda' gaid nilan giin meseklut ri sek pementelu'enen. Bu' tendeng ay mitingala ilan ri sek sembag ni Jesus, nda' ilan na peksasak. ");
INSERT INTO stb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na duuni ngak Saduceo, neng miktalu' ne su nga getaw ndi' metubu' puli' buwat se kemetain, mikpegaud riin ni Jesus bu' miktalu', ");
INSERT INTO stb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Sir, si Moses miksulat neg bala'ud para ri senita: ‘Bu' matay su dlai bu' nda'irunig bata' nilan nuk sawaan, kina'enlan ne suk pateren giining mengesawa run sung mibalu arun mekegbata' ilan para tu sek pateren neng minatay.’ ");
INSERT INTO stb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na, duunik pitu ne nga dlai neng mekpated; su gulangbata' mingesawa ma'ad minatay giin ne nda'irunig bata'en. ");
INSERT INTO stb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Rayun su keruwa' pingesawaan sung mibalu bu' minatay rema, ");
INSERT INTO stb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","bu' rayun su ketelu, mingesawa rema ri seniin. Ma'ad maa' run rema sung mihitabu' se ketelu tampan se kepitu. Mimatay ilan gela' ne nda'iruni ngag bata' nilan tu se dlibun ketu. ");
INSERT INTO stb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Se ketambinai', minatay rema su dlibun. ");
INSERT INTO stb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na, bu' mateng na suk peketubu' puli', sek pitu keni, ta' maig banaan ay mikengesawa ilan ma gela' ri seniin?” ");
INSERT INTO stb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Miksembag si Jesus ri senilan, “Su nga getaw sek panahun keni, medderumaay; ");
INSERT INTO stb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ma'ad su nga getaw ne mbaya' metubu' puli' buwat se kemetain bu' metubu' ri seng mateng nek panahun, ndi' ilan na medderuma. ");
INSERT INTO stb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ndi' ilan na gaid matay tendeng ay maa' ilan na ne ngag anghel bu' ngag bata' ilan na ned Diwata tendeng ay pitubu' ilan puli' buwat se kemetain. ");
INSERT INTO stb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bu' kinelaru ni Moses sek pekpemetuud sung mimatay metubu' puli'. Ri se gesuyan metendeng ri seng midliga' neng miika' ne gayu, miktalu' giin ne su Ginu'u, giin sud ‘Diwata ni Abraham, Diwata ni Isaac, bu' Diwata ni Jacob.’ ");
INSERT INTO stb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Giin sud Diwata ri seng miktetubu', gena' se ngang mimatay, ay para ri seniin, tetubu' su dlaunan.” ");
INSERT INTO stb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sud duma ne ngang menintulu' se Kesugu'an miktalu', “Sir, melengas suk pekesembag mu.” ");
INSERT INTO stb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bu' nda' naing mingulikseg sek peksaak ri seniin puli'. ");
INSERT INTO stb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mbuus miksaak si Jesus ri se nga getaw, “Pekendun ma sek pektalu' ne sung Misiyas gasal ni David? ");
INSERT INTO stb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ay si David mismu miktalu' ri se dlibru ne ngak Salmo: ‘Su Ginu'u miktalu' ri se Ginu'uu: Gingkud'a rini sed dapit dlintuu, ");
INSERT INTO stb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tampan ned daagen'u su nga kuntra mu bu' mpedlegesegan mu ilan.’ ");
INSERT INTO stb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Tinawag giin ni David ne ‘Ginu'u’; pekendun run rayun sek pekebaal ne sung Misiyas mbaal ne gasal ni David?” ");
INSERT INTO stb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Seng minginengeg su dlaun ne nga getaw riin ni Jesus, miktalu' giin tu se ngak tinu'unaan, ");
INSERT INTO stb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Megbantay amu se ngang menintulu' ri se Kesugu'an. Liyagan nilan meksuruysuruy neng menuub ne ngang metaas bu' liyagan nilan nek pegbesaan ilan riin se ngak tebu'an. Ri se ngak pektiguman nu nga getaw Judeo awas ri se nga kumbira, pemili'en gaid nilan su nga gingkuran para se ngak pingenggat ne ngag bisita; ");
INSERT INTO stb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","pedlimbungan nilan su ngag balu ne dlibun ay penguwanen nilan su ngag betang nilan ri se ngag balay nilan, bu' rayun pe'ita' nilan neng megampu' ilan ne ngang metaas! Suk silut nilan gembagel gupiya.” ");
INSERT INTO stb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na, sek pektingkag ni Jesus, mi'ita'en su ngang mekeratu' ne nga getaw neng mimbetang ne ngag halad nilan ritu sek pembetangan ne ngag halad tu sek Templo. ");
INSERT INTO stb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bu' mi'ita'en rema suk pupus gupiya neg balu ne dlibun neng migbetang rema ned duwa' sintabus nek pelata. ");
INSERT INTO stb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Miktalu' si Jesus, “Telu'an'u amu seng metuud, balu ne dlibun keni mikegbegay ne dlabaw pa kampuun sinangkali' sed duma. ");
INSERT INTO stb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tendeng ay nga getaw keni neng mimbegay se ngag halad nilan, mimbegay ilan se genda' na nilan kina'enlanay. Ma'ad sug balu ne dlibun, isan metuud pupus giin, binegain su dlaun nek pengetubu'anen.” ");
INSERT INTO stb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sud duma ne ngak tinu'unan ni Jesus miktalu' metendeng sek Templo, gendun kelengas gupiya enlengan duma se ngag batu neng mekelengas bu' ngag hinalad para tu sed Diwata. Aas, miktalu' si Jesus, ");
INSERT INTO stb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ngag betang keni neng mi'ita' niyu, megeba' ra. Seng mateng nek panahun, nda'irun isan sala ne ngag batu ne gembilin ri seng mi'imetangan, tendeng ay dlaunen keni metumpag.” ");
INSERT INTO stb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na miksaak ilan riin ni Jesus, “Sir, nanu ba mehitabu' ngag betang keni? Bu' lama run mai nga gindanan ne keni megaud na mehitabu'?” ");
INSERT INTO stb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Miksembag si Jesus, “Pekpetigaam amu ne nda'iruning mekepebalag riin seniyu. Ay melaun ne nga getaw, neng mektalu' para ri senaan, mateng bu' mektalu' ‘Gaku' sung Misiyas!’ bu' ‘Minateng na suk panahun!’ Ma'ad ndi' amu peksunud ri senilan. ");
INSERT INTO stb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma'ad bu' mekerengeg amu ned duuni nga gubat bu' nga kegubet, ndi' amu mendek run; ay kina'enlan me'una mehitabu' itu. Ma'ad gena' pa ini ketapusan neg benwa.” ");
INSERT INTO stb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bu' miktalu' puli' si Jesus, “Gumubat suk sala neng nasud tu se dlain neng nasud bu' gumubat rema suk sala nek pedlegeri'an tu se dlain nek pedlegeri'an. ");
INSERT INTO stb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Duuning mateng neng mesekeg ne nga dlinug bu' duuni gutem bu' dlainlain ne ngang melages ne dleruun isan ta' ne dlugar. Bu' mekiita' amu rema ne ketingelaan bu' mekeendekendek ne gilelaan buwat ri se dlangit. ");
INSERT INTO stb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ma'ad se ndi' pa ini mehitabu', daapen amu bu' lutusen ne nga getaw; uwiten amu nilan tu se ngak pektiguman arun ukuman bu' perisuun rayun. Bu' uwiten amu rema nilan ri seng metungenga'an ne nga gari' bu' nga gobernador tendeng ri senaan. ");
INSERT INTO stb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Giin nini sug higayun neng me'asuy niyu ri senilan su Gempiya ne Gesuyen. ");
INSERT INTO stb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aas, betang niyu ri se gena'ena' niyu ne bu' mehitabu' ini, ndi' amu megules bu' pekendunen niyu pekpenaliped ri se gegulingen niyu, ");
INSERT INTO stb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ay begayan'u amu nek sinuunan sek peksembag, arun ndi' mekesupak ri seniyu su nga kuntra niyu awas meketalu' ne gamu misayep. ");
INSERT INTO stb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Isan ngani' su ngang megulang, ngak pated, nga gepenan, bu' ngak sambat megbudhi' ri seniyu. Bu' petain nilan sud duma riin seniyu. ");
INSERT INTO stb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Gemetan amu ne dlaunen tendeng ri senaan. ");
INSERT INTO stb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ma'ad isan sala dlegas neg buuk ri se nga gulu niyu ndi' merala'. ");
INSERT INTO stb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mekpeddayun amu sek pegantus bu' meluwas niyu su gegulingen niyu.” ");
INSERT INTO stb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Na, bu' ali' me'ita' niyu suk siyudad neg Jerusalem ne dlinibutan na nek sundalu, mesuunan niyu rayun neng megaud na suk pekegeba'en. ");
INSERT INTO stb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Rayun su nga getaw ne ritu sek probinsiya neg Judea, medlaguy ilan tu se ngag binenturan. Bu' su nga getaw rini sek siyudad medlaguy pegawas. Bu' su nga getaw ne ritu seg binaal, ndi' ilan na muli' tu sek siyudad. ");
INSERT INTO stb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ay ketu ‘Su nga Gendaw sek Peksilut,’ arun metuman su dlaun neng misulat ri se Kesulatan. ");
INSERT INTO stb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mekelelaatlelaat su ngag beres bu' su ngang mikperuru' se nga gendaw ketu! Ay mateng suk panahun se keliseran rini se dlupa' bu' suk silut ned Diwata mesegaran ne nga getaw keni. ");
INSERT INTO stb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sud duma ri senilan pemetain pebiyan se kalis bu' duma ri senilan pendaapen bu' penguwiten ritu seng melayu' ne ngang nasud. Bu' sug Jerusalem geba'en bu' pedlegeri'an ne nga getaw ne gena' Judeo tampan metektak suk panahun nilan.” ");
INSERT INTO stb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Duun rayuni nga gilelaan neng me'ita' niyu ri se gendaw, seg bulan, bu' se ngag bituun. Bu' rini seg benwa, me'endekan gupiya su ngang nasud tendeng ay merengeg nilan sung middega' ned dagat bu' ngang mekebagel neg baled. ");
INSERT INTO stb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Duuni nga getaw neng me'elapan tendeng se keendek saanay megelat ilan seng mehitabu' rini seg benwa, tendeng ay su ngag betang ritu se gawanawanan pebalagen buwat seng mi'enaran neg biyanan nilan. ");
INSERT INTO stb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mbuus me'ita' sug Bata' ne Getaw ri se ginanud ne ge'eman gupiya bu' meddelaag gupiya ri sek pekedDiwataan. ");
INSERT INTO stb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Seng megatad naik penghitabu' keni, gindeg amu bu' pegangag amu tu se dlangit ay megaud na suk pedluwas ri seniyu.” ");
INSERT INTO stb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Rayun inesuyan ilan ni Jesus ne galing: “Enlengay niyu su gayu neg Igira bu' sud duma ne nga gayu. ");
INSERT INTO stb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bu' me'ita' ta neng mengintubil na, mektalu' ita neng megaud na memeres. ");
INSERT INTO stb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Seng maa' rema nek pebiyan, bu' me'ita' niyu neng mehitabu' na ini, mesuunan niyu neng megaud na suk pedlegari' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Sek pekemetuud, telu'an'u amu, se gendi' pa mematay gela' su nga getaw sek panahun keni, metuman na su dlaun ne ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Merala' ma su dlangit bu' su dlupa', ma'ad su ngak talu'u mekpebilin se genda'i gekteben. ");
INSERT INTO stb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Na, bentayay niyu su gegulingen niyu ne ndi' melalam sek pedleketubu' neng mekpetuyang sek pekaan awas pegbinabeleng awas se kegules metendeng se pedleketubu' ay ali' bu' metikmal mateng su gendaw ketu ne ndi' amu mekengandam ");
INSERT INTO stb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","bu' maa' amu neng mitaban ri se giman, tendeng ay mateng ini se dlaun neng mikengel rini seg benwa. ");
INSERT INTO stb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ma'ad mengandam amu se dlaun nek panahun bu' megampu' amu arun mekelingkawas amu se dlaun nek penghitabu' keni neng mateng bu' mekaatubang amu ri seng metungenga'an seg Bata' ne Getaw.” ");
INSERT INTO stb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na, se nga gendaw ketu, minendu' si Jesus ri sek Templo. Bu' mateng su gebii, gumawas giin bu' mengintulugan ritu seg bentud ne ngag Olibo. ");
INSERT INTO stb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Se kada nek sikansilem dlaun ne getaw meritu sek Templo sek pekpenginengeg riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na, megaud na suk Pekse'ulug sek Pan ne genda'ik Pempetulinen, ne iningelanan suk pekse'ulug nek Paska. ");
INSERT INTO stb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bu' su nga geseg ne ngak pari' bu' su ngang menintulu' ri se Kesugu'an minengaw neg higayun bu' pekendunen nilan sek pekpatay si Jesus tendeng ay minendek ilan ri se nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na, sinumeled si Satanas riin ni Judas nek tinawag neg Iscariote nek sala sek sepulu' bu ruwa' ne nga gapustulis. ");
INSERT INTO stb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aas midlaang giin bu' kinumita' ri se nga geseg ne ngak pari' bu' nga geseg se nga guwardiya sek Templo. Miktuntul ilan bu' pekendunen sek pegintrigu si Jesus tu senilan. ");
INSERT INTO stb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pidleliyag ilan gaid bu' miguyun neg biyaran giin. ");
INSERT INTO stb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sinangu' rema ni Judas suk sabut nilan. Aas dluwat itu, minengaw giin ne ginsaktu neg higayun bu' pegendunen run sek pegintrigu si Jesus ri senilan ne ndi' mesuunan nu nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na, minateng na su gendaw sek pekse'ulug sek Pan ne genda'irunik Pempetulinen, nek titi'en su ngang nati ne karniru para dulang nilan sek Paska. ");
INSERT INTO stb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Bu' sinugu' ni Jesus si Pedro bu' si Juan: “Peguna amu bu' pegandam nek pekaan para sek Paska.” ");
INSERT INTO stb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Miksaak ilan ri seniin, “Ta' mai dlugar ne ritu ami megandam run nini?” ");
INSERT INTO stb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Miksembag si Jesus senilan, “Penginengeg amu, sek peddateng niyu sek siyudad, duuning melabet niyu ne dlai neng mikpisaan ne gamang neg binetangan nek tubig. Lendug niyu giin tu seg balay nek seleraan. ");
INSERT INTO stb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Sek peddateng niyu ri seg balay, mektalu' amu tu se gapu' neg balay: ‘Sung Menintulu' nami liyagaan mesuunan bu' ta' giin mekekaan para sek Paska duma se ngak tinu'unaan.’ ");
INSERT INTO stb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pe'ita'en ri seniyu su gembagel nek seled tu sed ditaas neng mi'andam na para gemiten niyu. Andam niyu ritu suk pekaan.” ");
INSERT INTO stb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Midlaang si Pedro bu' si Juan bu' mi'ita' nilan su dlaun nek tinalu' ni Jesus senilan bu' inandam nilan suk pekaan para sek Paska. ");
INSERT INTO stb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Seng minateng na su guras, migingkud si Jesus arun maan duma se nga gapustulisen. ");
INSERT INTO stb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Bu' miktalu' si Jesus ri senilan, “Liyagan'u gupiya neng maan se gaan keni para sek Paska duma ri seniyu se gendi'u pa megantus. ");
INSERT INTO stb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ay telu'an'u amu, ndi'u na maan run nini tampan metuman sung metuud ne gulugaan nini ri sek pedlegari' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mbuus minuwan giin ne kupa, mikpesalamat ri sed Diwata, bu' miktalu', “Tabuk niyu ini bu' sigelesay niyu inumay. ");
INSERT INTO stb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Telu'an'u amu, gatad nandaw, ndi'u na minum ne ginumen keni tampan mateng suk pedlegari' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mbuus inuwanen suk pan bu' mikpesalamat ri sed Diwata. Bu' pinetapetaan ini bu' pimbegain ri senilan, laungen, “Giin nini su dlawas'u neg binegay para seniyu. Baal niyu ini sek peddelendem ri senaan.” ");
INSERT INTO stb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Seng maa' run nek pebiyan, binegain ri senilan su kupa sek peketubus nilan menihapun, laungen, “Kupa keni giin nini sug begu ne keligenan ned Diwata nek piligen pebiyan ri sed dugu'u, nek pitulu' para seniyu.” ");
INSERT INTO stb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ma'ad, enlengay niyu, su getaw neng megbudhi' ri senaan dinumengan senaan maan rini se dlemisaan! ");
INSERT INTO stb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ay sug Bata' ne Getaw matay sek pebiyan neng mitendu' para ri seniin ma'ad mekelelaatlelaat su getaw neng megbudhi' ri seniin.” ");
INSERT INTO stb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sek pekerengeg run nilan nini miksesaakay ilan bu' ta' ma sakan ri senilan sung megbaal run nini. ");
INSERT INTO stb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na, midlalis rema su nga gapustulis bu' ta' gaid ri senilan su dlabaw. ");
INSERT INTO stb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aas miktalu' si Jesus ri senilan, “Su nga gari' se nga gena' Judeo duuni nga ga'em nilan tu se nga getaw, bu' su nga geseg nilan, liyagan nilan nek tuwagen ri sek titulu: ‘Menggegabang nu nga Getaw.’ ");
INSERT INTO stb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ma'ad gena' amu maa' senilan; ay bu' ta' sud duuning metaas ne ketendanaan, kina'enlan mekpebaba' giin maa' nek tampusan ne nguran, bu' ta' sung midlegeseg, kina'enlan maa' giin nek sesugu'en. ");
INSERT INTO stb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ta' ma su dlabaw kampuun, su ginilakan ba awas sung migilak? Gena' ba su ginilakan? Ma'ad keniu neng migilak ri seniyu maa' nek sesugu'en.” ");
INSERT INTO stb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ma'ad gamu sung migunung ri senaan se ngak peksulay neng mibiyanan'u. ");
INSERT INTO stb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Aas begayan'u amu se ketenged sek pedlegeseg, maa' ne Gama'u neng megbegay ri senaan ne ketenged sek pedlegeseg. ");
INSERT INTO stb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Maan amu bu' minum ri se dlemisaan'u ritu sek pedlegeri'an'u, bu' megingkud amu ri se nga gingkuran ne gari' sek pedlegeseg sek sepulu' bu' ruwa' ne ngak tribu neg Israel.” ");
INSERT INTO stb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Miktalu' si Jesus, “Simon, pekpetigaam'a! Migubug si Satanas sek pegindan ri seniyu gela' arun mpain sung melengas bu' melaat, maa' neng mentetaun neng mekpain se gepis buwat se dlinggas. ");
INSERT INTO stb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma'ad migampu'u para ri seni'a, Simon, arun ndi' meluya suk pektu'u mu. Bu' mpuli'a na ri sek pektu'u mu ri senaan, ligenen mu suk pektu'u ne ngak sementaun mu.” ");
INSERT INTO stb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Miksembag si Pedro, “Ginu'u, andamu gaid megunung ri seni'a isan sek perisuwan awas se kemetain.” ");
INSERT INTO stb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Miktalu' si Jesus ri seniin, “Pedro, telu'an'u dya'a, se gendi' pa meguni su dlimensad ri se gebii keni, limeren mau seng metelu puli' ne nda'a mekilala ri senaan.” ");
INSERT INTO stb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mbuus miktalu' si Jesus tu se ngak tinu'unaan, “Sek sinugu'u amu nud diin ne nda' peguwit nek pitaka, awas gambag, awas sapatus, mikulangan amu ba?” Miksembag ilan, “Nda' gaid.” ");
INSERT INTO stb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Miktalu' si Jesus, “Ma'ad numuun, su isan ta' ned duunik pitakaan awas gambagen, kina'enlan uwitenen na. Bu' isan ta' ri seniyu ne nda'iruni kalisen, beledya' niyu suk suub niyu arun saluy niyu ne kalis. ");
INSERT INTO stb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ay telu'an'u amu ne sug bahin se Kesulatan neng miktalu', ‘Gelalen giin nek sala se ngang mememunu',’ kina'enlan metuman gaid, tendeng ay landuning misulat metendeng ri senaan metuman gaid.” ");
INSERT INTO stb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bu' miktalu' su ngak tinu'unan, “Enlengay mu, Ginu'u, duunid duwa' buuk ne nga kalis rini!” Miksembag si Jesus, “Gigu' na iin.” ");
INSERT INTO stb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Midlaang si Jesus bu' miritu giin seg Bentud ne ngag Olibo sumala' ri seng mibetasaan. Middunut ri seniin su ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Peddateng nilan ritu miktalu' giin, “Megampu' amu ne gendi' amu daagen nek peksulay.” ");
INSERT INTO stb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mikpelayu' reli' si Jesus buwat ri senilan, maa' kelayu' sek pekpidlak neg batu, bu' minginlulud giin sek pegampu'. ");
INSERT INTO stb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Miktalu' giin, “Gama', bu' keliyag mu, ndi' mau pe'entusay sek pekpe'inum mu ri senaan se kupa keni. Ma'ad baal mu su keliyag mu, bu' gena' su keliyag'u.” ");
INSERT INTO stb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mbuus mikpe'ita' seniin sug anghel buwat tu se dlangit bu' mikpeligen ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tendeng se kebegat gupiya neg binatiken, migampu' gusay giin, bu' su nga gulasen maa' ne ngak tulu' ned dugu' neng miktulu' ri se dlupa'an. ");
INSERT INTO stb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Migindeg giin buwat megampu' bu' mipuli' tu se ngak tinu'unaan. Miretengaan ilan neng miktulug tendeng ay miluya ilan gupiya se kegu'ul. ");
INSERT INTO stb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Miktalu' si Jesus ri senilan, “Tuma ma mentulug amu? Buwat amu bu' pegampu' ne gendi' amu daagen nek pegindan.” ");
INSERT INTO stb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Saanay miktuntul pa si Jesus, enlengay niyu, minateng sung meleget ne nga getaw. Si Judas nek sala sek sepulu' bu' ruwa' ne nga gapustulisen mingulu ri senilan. Mikpegaud giin riin ni Jesus arun maalek ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Miktalu' si Jesus, “Judas, budhi'an mu ba sug Bata' ne Getaw pebiyan sek sala ne galek?” ");
INSERT INTO stb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sek pekiita' ne ngak sementaun ni Jesus neng maa' duuning mehitabu', miktalu' ilan, “Ginu'u, penigbasen ba nami gilan?” ");
INSERT INTO stb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bu' tinigbas nuk sala suk sesugu'en nu Dlabaw Geseg nu ngak Pari' bu' mipetel su dlintu nek telingaan. ");
INSERT INTO stb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma'ad miktalu' si Jesus, “Sukalay na niyu run!” Dayun dinepenaan suk telinga nu getaw bu' pi'uli'aan ini. ");
INSERT INTO stb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mbuus miktalu' si Jesus tu se nga geseg ne ngak pari', se nga geseg ne nga guwardiya sek Templo, bu' se nga geseg ne ngag Judeo neng miritu sek peddaap ri seniin, “Mememunu'u ba ne kina'enlan neng meguwit amu gaid ne nga kalis bu' ngag bentul sek peddaap ri senaan? ");
INSERT INTO stb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gendawendaw rituu ra sek Templo bu' nda' niyau ma raapay ritu. Ma'ad giin na inik panahun niyu bu' se ga'em se kerelem.” ");
INSERT INTO stb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dinaap nilan si Jesus bu' inuwit ritu seg balay ne Dlabaw Geseg nek Pari', saanay midlendug si Pedro, ri seng melayu'. ");
INSERT INTO stb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ri sek titenga' ne dlenu'an nu gukuman duuni ginuklak ne gapuy bu' tinumipung si Pedro se ngang minggingkud sek timala' ne gapuy. ");
INSERT INTO stb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Seng mi'ita' giin sek sesugu'en ne dlibun neng migingkud seng megaud ne gapuy, tinentengen si Pedro bu' miktalu', “Getaw keni, sementaun rema ni Jesus.” ");
INSERT INTO stb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ma'ad midlimed si Pedro, “Eddang, nda'u ngani' mekilala ri seniin!” ");
INSERT INTO stb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nda' mpayat, duun na peluming mikiita' ri seniin ne dlai bu' miktalu', “Dya'a sala rema se ngak sementaunen.” Ma'ad miksembag si Pedro, “Aa! Gena' baya' gaku'.” ");
INSERT INTO stb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Dluwat sek sala uras, duuni getaw neng mikpemetuud neng miktalu', “Metuud gaid ne getaw keni sementaun ni Jesus ay giin taga Galilea rema!” ");
INSERT INTO stb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ma'ad miksembag si Pedro, “Gena', lai! Nda'u mekesuun ri sek pimentalu' mu kiin.” Bu' rayun saanay migasuy pa giin, miguni su dlimensad. ");
INSERT INTO stb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Midlingay su Ginu'u bu' tinentengen si Pedro. Mbuus mi'ena'ena' ni Pedro suk tinalu' ne Ginu'u ne se gendi' pa meguni su dlimensad se gebii keni, limerenen giin seng metelu. ");
INSERT INTO stb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Rayun ginumawas si Pedro bu' miksegaw ned duuni kegeel. ");
INSERT INTO stb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Su nga getaw neng migbantay riin ni Jesus, middega'rega' ri seniin bu' binentul giin. ");
INSERT INTO stb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tinampeng nilan sung mataan bu' tinelu'an, “Ala, atuk mu raw bu' ta'ing migbentul ri seni'a?” ");
INSERT INTO stb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bu' melaun pa gairik pimentalu' nilan sek pektampela' ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sek pekegendaw, miktipung su nga geseg nu ngag Judeo, su nga geseg ne ngak pari', bu' su ngang menintulu' ri se Kesugu'an. Bu' inuwit nilan si Jesus tu se Dlabaw ne Gukuman. ");
INSERT INTO stb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Miktalu' ilan riin ni Jesus, “Tebalay mu ami bu' dya'a ba sung Misiyas.” Miksembag giin, “Isan esuyan'u amu ndi' amu ma gusay mekpetuud. ");
INSERT INTO stb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Bu' saakan'u amu ndi' amu ma meksembag. ");
INSERT INTO stb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma'ad dluwat nandaw, sug Bata' ne Getaw megingkud na sed dapit dlintu neng Mekegega'em ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Miktalu' ilan gela', “Bu' maa' niin, dya'a masi' sug Bata' ned Diwata?” Miksembag si Jesus, “Gamu na gaid sung miktalu' run.” ");
INSERT INTO stb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aas miktalu' ilan, “Landun pa gaid su ngak pekpemetuud ne kina'enlanen ta? Gita na gaid sung mikerengeg run suk tinalu'en.” ");
INSERT INTO stb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Migindeg su dlaun ne nga getaw, inuwit si Jesus bu' pi'atubang nilan ritu ni Pilato, ");
INSERT INTO stb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","bu' sinumbung nilan giin: “Miraapan nami getaw keni neng mikpebelagbelag ri se nga getawan ta. Inesuyaan ilan ne gendi' megbayad neg buwis ritu se Gari' seg Roma, bu' miktalu' pa gaid giin ne giin sung Misiyas, su gari'.” ");
INSERT INTO stb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aas sinaakan giin ni Pilato, “Dya'a ba su gari' ne ngag Judeo?” “Dya'a na sung miktalu' run,” sembag ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mbuus miktalu' si Pilato se nga geseg nu ngak pari' bu' se nga getaw, “Nda'iruning mi'ita'u nek sala' ne getaw keni arun silutan giin.” ");
INSERT INTO stb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma'ad minleges ilan gaid, “Miguwit giin ne kesamuk se nga getawan sek tibuuk neg Judea pebiyan se ngak pekpenendu'en. Migatad giin ri sek probinsiya se Galilea bu' nandaw mirepet rema rini.” ");
INSERT INTO stb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Na, sek pekerengeg run nini ni Pilato, miksaak giin, “Getaw keni taga Galilea ba?” ");
INSERT INTO stb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sek pekesuunen dun ne si Jesus buwat se dlugar nek sakup sek pidlegesegan ni Herodes, pinawiten si Jesus ritu ni Herodes ned ditu rema giin seg Jerusalem se gendaw ketu. ");
INSERT INTO stb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bu' pidleliyag gupiya si Herodes sek pekiita'en riin ni Jesus, tendeng ay mikerengeg na giin metendeng ri seniin bu' liyagaan me'ita' giin se gempayat na nek panahun. Midderama giin neng mekiita' ri ni Jesus neng megbaal neng milagru. ");
INSERT INTO stb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aas meleget su ngak saak ni Herodes riin ni Jesus, ma'ad nda' gaid giin peksembag. ");
INSERT INTO stb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bu' su nga geseg nu ngak pari' bu' su ngang menintulu' ri se Kesugu'an migindeg ritu bu' pingelegan nilan se gembegat nek sumbung kuntra ri ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bu' rayun pimura bu' piddega'rega'an giin ni Herodes bu' se ngak sundaluun. Rayun, piselukan nilan neng melengas bu' metaas nek suub arun enlengan giin neng maa' ne gari'. Rayun pinawit nilan puli' ritu ni Pilato. ");
INSERT INTO stb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bu' se gendaw rema ketu, giin suk pekesambat ni Herodes bu' ni Pilato, tendeng ay migbunu' ilan nud diin. ");
INSERT INTO stb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pitawag ni Pilato su nga geseg ne ngak pari', su nga geseg, bu' sud duma pa ne nga getaw, ");
INSERT INTO stb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","bu' miktalu' giin ri senilan, “Inuwit niyu rini senaan getaw keni nek tinalu' niyu neng mikpebelagbelag ri se nga getaw. Ma'ad enlengay niyu, sek pektipet'u ri seniin rini seng metungenga'an niyu, nda'irun gairing mi'ita'u neng mikepemetuud ri sek sumbung niyu. ");
INSERT INTO stb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Isan ngani' si Herodes nda'irun remaing mi'ita'en neng melaat se getaw keni. Giin run ngani' nek pipuli'en giin rini. Nda'irun maing mibaal ne getaw keni ne mbaya' giin silutan se kemetain. ");
INSERT INTO stb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Aas pelatiguu na ma'aray giin rayun beluyan.” ");
INSERT INTO stb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ma'ad migbeksay su nga getaw, “Patay niyu getaw kiin. Beluyay niyu si Barabas para ri senami.” ");
INSERT INTO stb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Miperisu si Barabas tendeng ay duma giin se ngang migribildi seg Jerusalem bu' mikepatay pa giin. ");
INSERT INTO stb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Liyagan siya ni Pilato neg beluyan si Jesus, aas tinalu'aan puli' su nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ma'ad mikpeddayun sek pegbeksay su nga getaw, “Lensangen giin ri se krus! Lensangen giin ri se krus!” ");
INSERT INTO stb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Miktalu' pa gaid si Pilato ri senilan se ketelu, “Landun ba gairing melaat neng mibaalen? Nda'iruning mi'ita'u neng mibaalen ne mbaya' giin silutan se kemetain! Pelatiguu giin bu' mbuus beluyan rayun.” ");
INSERT INTO stb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma'ad pilebiyanan pa gaid nilan sek pegbeksay bu' minamal ilan neng melansang giin tu se krus. Bu' se ketambinai', middaag ilan gaid. ");
INSERT INTO stb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aas miliyag na ma'aray si Pilato tu se gandyu' nu nga getaw. ");
INSERT INTO stb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bineluyaan si Barabas nek pinengi nu nga getaw, neng miperisu tendeng sek pegribildiin ri se goberno bu' pekpatay. Ma'ad inintriguun si Jesus tu se nga getaw arun mbaal nilan su dliyagan nilan baalen ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Saanay inuwit nilan si Jesus tu se dlugar ne dlensangan ri seniin, milabet nilan su getaw ne giningelanan ne si Simon nek taga Cirene neng mikpeguli' ritu sek siyudad buwat ri seg binaalen. Bininteng nilan giin bu' pipisaan ne krus, bu' pisunud riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Melauni nga getaw neng midlendug riin ni Jesus. Duuni nga dlibun ritu neng minsegaw bu' mimbakal para ri seniin. ");
INSERT INTO stb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ma'ad liningay ilan ni Jesus bu' tinelu'an, “Gamu, nga dlibun nek taga Jerusalem, ndi' amu pensegaw tendeng ri senaan. Segaway niyui gegulingen niyu bu' su nga gembata' niyu. ");
INSERT INTO stb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tendeng ay mateng su nga gendaw neng mektalu' su nga getaw, ‘Mpiya kampuun su nga dlibun ne gendi' mekegbata', bu' su genda' pegberes, bu' genda' pekperuru' ne ngag bata'.’ ");
INSERT INTO stb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sek panahun kiin, mektalu' su nga getaw tu se ngag bentud, ‘Tugbanay niyu ami!’ bu' seng mekiika' ne ngag bentud, ‘Tebunay niyu ami!’ ");
INSERT INTO stb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ay bu' ngag betang keni binaal nilan ri se getaw ne genda'irunik sala'en, gendun pa sakan tu se nga getaw neng mekesesala'?” ");
INSERT INTO stb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mbuus duuni dlain ned duwa' tawan, ne ngang mememunu' rema, ne inuwit arun mpeddengan petayay riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Peddateng nilan se dlugar ne giningelanan nek ‘Tulaan Gulu!’, linansang nilan si Jesus tu se krus bu' sud duwa' tawan ne ngang mememunu'. Suk sala ri se dlintu ni Jesus bu' suk sala ri seg bibangen. ");
INSERT INTO stb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Miktalu' si Jesus, “Ama', pasaylu mu ilan ay nda' ilan mekesuun ri seg binaal nilan.” Bu' pikilasilas nilan su ngak suub ni Jesus pebiyan sek pegripa. ");
INSERT INTO stb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Su nga getaw neng migindeg ritu bu' migenleng saanay piddega'rega'an giin nu ngang midlegeseg ri se dlunsud: “Linuwasen sud duma; peluwas rema seniin su gegulingenen bu' giin ma sung Misiyas, suk pinili' ned Diwata!” ");
INSERT INTO stb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Middega'rega' rema ri seniin su ngak sundalu saanay mikpegaud ilan arun pe'inumen giin neng mesem ne ginumen. ");
INSERT INTO stb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Miktalu' ilan, “Bu' dya'a su Gari' ne ngag Judeo, luwas mui gegulingen mu!” ");
INSERT INTO stb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bu' duunig binetang nilan ne karatula ritu sed dibabaw ne guluun: “Giin nini su Gari' ne ngag Judeo.” ");
INSERT INTO stb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Suk sala se ngang mememunu' ne dlinansang tu se krus mingimusung rema riin ni Jesus; “Gena' ba dya'a sung Misiyas? Luwas mui gegulingen mu bu' gami rema.” ");
INSERT INTO stb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma'ad pimaag giin nuk sala se ngang mememunu', laungen, “Nda'a ba endek ri sed Diwata? Sinilutan'a rema maa' ne getaw keni. ");
INSERT INTO stb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ma'ad mbaya' gaid ri senita suk silut nek sinilut ri senita ay mbaya' ma ini ri seg binaal ta; ma'ad giin, nda'irunik sala'en.” ");
INSERT INTO stb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mbuus miktalu' giin riin ni Jesus, “Jesus, pegena'ena' mau ra la'a bu' medlegari'a na!” ");
INSERT INTO stb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Miktalu' si Jesus ri seniin, “Telu'an'u dya'a, gendaw keni ritua sek Para'isu duma ri senaan.” ");
INSERT INTO stb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sek peketaasendaw, nda' na peddelaag su gendaw tampan miginenga' menaugi gendaw. ");
INSERT INTO stb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nda' tiyagi gendaw bu' miribaluy su kurtina ri sek Templo. ");
INSERT INTO stb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mbuus migbeksay si Jesus, “Ama', piyal'u ri seni'a su gispirituu!” Dluwaten telu'ay ini, mibektusi ginawaan. ");
INSERT INTO stb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sek pekiita' ne geseg se ngak sundalu seng mihitabu', miksaya' giin ri sed Diwata neng miktalu', “Metuud gaid neng metarengi getaw keni!” ");
INSERT INTO stb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Su dlaun ne nga getaw neng miktipung arun megenleng, mi'ita' nilan sung mihitabu'. Minuli' ilan neng mindaneg ri se nga geddeb nilan tendeng seng melebiyan ne kegu'ul. ");
INSERT INTO stb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Su ngang mikilala riin ni Jesus asta na su nga dlibun neng middunut ri seniin buwat pa se Galilea, migindeg ritu seng melayu'layu' bu' mi'ita' rema nilan su ngang mihitabu'. ");
INSERT INTO stb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Bu' enlengay niyu, duun ritui getaw neg buwat se dlunsud neg Arimatea, sakup sek probinsiya neg Judea, ngalanen si Jose. Sakup rema giin se Dlabaw ne Gukuman, ma'ad nda' giin peliyag se gukum bu' seg binaal nilan. Mpiya bu' metareng giin ne getaw, bu' migelat giin sek pedlegari' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Miritu giin ni Pilato bu' inubugen ri seniin sug bangkay ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mbuus inuwanen sug bangkay ni Jesus ritu se krus bu' pinutus nek penepeten ne dlinu. Bu' binetang ini ritu se dlinuwakan ne gilid nek telektapan ne dlebengan bu' genda' pa mayan melebengay. ");
INSERT INTO stb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Gendaw itu neg Birnis, bu' mikpegatad na su Gendaw nek Pengulali. ");
INSERT INTO stb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Su nga dlibun neng midlendug riin ni Jesus buwat Galilea neng middunut rema riin ni Jose, mi'ita' nilan su dlebengan bu' suk pekpe'imetang seg bangkay ni Jesus. ");
INSERT INTO stb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mbuus minuli' ilan bu' mingandam ne ngang memut nek tagek bu' ne ngak pegemut nek penlunas ri seg bangkay ni Jesus. Ma'ad se Gendaw nek Pengulali, mingulali ilan sumala' ri se Kesugu'an. ");
INSERT INTO stb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na, sek pekeddali' endaw ri sed Duminggu, miritu su nga dlibun ri se dlinebengan ne inuwit su nga ginandam nilan nek pegemut. ");
INSERT INTO stb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bu' rayun mi'ita' nilan su gembagel neg batu ne ginapa' tu seg biyanan ne dlinebengan milulid na. ");
INSERT INTO stb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Aas sinumeled ilan; ma'ad nda' nilan me'ita' sug bangkay ne Ginu'u ne si Jesus. ");
INSERT INTO stb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Migindeg ilan ritu neng midlibeg seng mihitabu'; bu' enlengay niyu, sek tikmal duunid duwa' tawan ne dlai neng migindeg megaud ri senilan. Su ngak suub nilan mekesulaw gaid gupiya. ");
INSERT INTO stb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Minendek gaid su nga dlibun, aas middungkuk ilan na ma'aray. Ma'ad miktalu' sud duwa' tawan ne dlai, “Tuma ma pinengaw ma niyu sung miktetubu' rini se ngang mimatay? ");
INSERT INTO stb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nda' giin rini; mitubu' na giin puli'! Pegena'ena' niyu bu' landunik tinalu'en riin seniyu saanay ritu pa giin se Galilea: ");
INSERT INTO stb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Sug Bata' ne Getaw kina'enlan piyal tu se ngang mekesesala', lensangen tu se krus, bu' se ketelu endaw metubu' giin puli'.’” ");
INSERT INTO stb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mirelendeman rayun nu nga dlibun su ngak tinalu'en, ");
INSERT INTO stb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","sek peguli' nilan, inasuy nilan su dlaunen keni tu sek sepulu' bu' sala ne nga gapustulis bu' sed duma pa. ");
INSERT INTO stb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Su nga dlibun ketu, gilan si Maria Magdalena, si Juana, si Maria ne gina' ni Santiago, bu' sud duma pa ne nga dlibun ned duma nilan. Tinelu'an nilan su nga gapustulis se dlaun ne ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ma'ad su nga gapustulis migena'ena' ne suk tinalu' ne nga dlibun nda'ik paluun, bu' nda' ilan pektu'u ri senilan. ");
INSERT INTO stb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma'ad si Pedro migindeg, bu' ginumebek ritu se dlinebengan; middungkuk giin bu' mi'ita'en su ngak penepeten nek pinutus ri seg bangkay ni Jesus ned daal da runing mibilin. Minuli' rayun giin neng mitingala seng mihitabu'. ");
INSERT INTO stb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dengan se gendaw ketu, enlengay niyu, duunid duwa' tawan nek tinu'unan ni Jesus neng mikpagaw seg Emmaus ne ngak sepulu' bu' sala kilumitru buwat seg Jerusalem, ");
INSERT INTO stb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","bu' miktuntul ilan duwa' metendeng ri se dlaun ne ngak penghitabu'. ");
INSERT INTO stb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Saanay nilan mektuntul, mikpegaud si Jesus bu' tinumendug ri senilan. ");
INSERT INTO stb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mi'ita' nilan giin ma'ad nda' nilan me'ilala giin. ");
INSERT INTO stb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mbuus miksaak si Jesus ri senilan, “Landun maik piktuntul niyu?” Mikeneng ilan sek pedlaang, neng miremeng. ");
INSERT INTO stb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Suk sala senilan ne giningelanan ne si Cleopas miksaak, “Dya'a ra ba sug bisita ri seg Jerusalem ne genda' mekesuun se ngag betang neng mihitabu' ritu seng minayan ne nga gendaw keni?” ");
INSERT INTO stb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Miksaak si Jesus ri senilan, “Landun ma ne ngak penghitabu'ay run?” “Su ngag betang metendeng riin ni Jesus nek taga Nazaret,” miksembag ilan. “Getaw keni propeta bu' ge'eman giin ri sek pengenleng ned Diwata bu' ri se nga getaw ri se dlaun neg betang neg binaalen bu' sek tinalu'en. ");
INSERT INTO stb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Su nga geseg ne ngak pari' bu' sud duma pa ne nga geseg inintrigu nilan giin arun ukuman se kemetain bu' linansang nilan giin tu se krus. ");
INSERT INTO stb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Midderama ami siya ne giin sung megbegay ne kegewasan ri seng nasud neg Israel! Ma'ad telu endaw na sung minayan buwat seng mihitabu' ini. ");
INSERT INTO stb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Sud duma ne nga dlibun mikepetingala senami; miritu ilan lapus se kelebengan, ");
INSERT INTO stb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ma'ad nda' nilan me'ita' sug bangkain. Mipuli' ilan bu' miktalu' ned duuning mi'ita' raw nilan ne ngag anghel neng miktalu' ri senilan neng mitubu' giin puli'. ");
INSERT INTO stb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Peketubus, sud duma ne nga dlai nek sementaun nami miritu rema se dlinebengan, bu' suk tinalu' nu nga dlibun giin remaing mi'ita' nilan. Ma'ad nda' gaid nilan giin me'ita' ritu.” ");
INSERT INTO stb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mbuus miktalu' si Jesus ri senilan, “Pekeburalbural gaid niyu! Pekepayat niyu mektu'u se dlaun nek tinalu' nu ngak propeta! ");
INSERT INTO stb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Gena' ba kina'enlan ma neng megantus reli' sung Misiyas ri se ngag betang keni se gendi' pa giin begayan nek pesiddengeg?” ");
INSERT INTO stb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bu' pisabut ri senilan ni Jesus su dlaun ne Kesulatan metendeng ri seniin, buwat se ngag bala'ud ni Moses bu' se ngak sinulat ne ngak propeta. ");
INSERT INTO stb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Peddateng nilan seg baryu nek pa'agawan nilan, maa' mendas si Jesus sek pedlaang; ");
INSERT INTO stb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ma'ad inandyu' nilan giin, “Rinia na reli' senami ay megaud na medlelabung. Ndi' na santa', medlegebii na.” Aas sinumeled giin tu seg balay bu' mikpebilin duma ri senilan. ");
INSERT INTO stb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bu' seng mihitabu' itu, saanay minggingkud ilan na sek pekpengaan, minuwan si Jesus nek pan bu' mikpesalamat tu sed Diwata. Mbuus pinetapetaan ini bu' binegay ri senilan. ");
INSERT INTO stb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sek tikmal mi'ilala nilan giin, ma'ad mi'alep ra pelum giin. ");
INSERT INTO stb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Salasala ri senilan miktalu', “Gena' ba gempiya gupiyaig binatik ta neng midlaang ita ri sed dalan bu' sek pekpesabuten ri senita se Kesulatan?” ");
INSERT INTO stb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mbuus mipuli' ilan rayun seg Jerusalem bu' miretengan nilan suk sepulu' bu' sala ne gapustulis neng miktipung ritu bu' sud duma pa nek sementaun nilan. ");
INSERT INTO stb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Miktalu' ilan, “Metuud neng mitubu' puli' su Ginu'u! Mikpe'ita' giin riin ni Simon.” ");
INSERT INTO stb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bu' miktalu' rema sud duwa' tawan ne dlai bu' landuning mihitabu' sed dalan bu' pekendun nilan sek pegilala su Ginu'u sek pinetapetaan suk pan. ");
INSERT INTO stb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Saanay pa mektuntul nu ngak tinu'unaan, mitikmal na ma'ad mekpe'ita' su Ginu'u neng migindeg ri sek titenga' nilan bu' migbasa ri senilan. ");
INSERT INTO stb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Migikmatan bu' mi'endekan ilan gaid ay laung nilan run ne kalag sung mi'ita' nilan. ");
INSERT INTO stb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma'ad miktalu' si Jesus ri senilan, “Lama mesamuk amu run? Lama menduwa'ruwa' amu ri se nga gena'ena' niyu? ");
INSERT INTO stb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Enlengay niyu su nga gemeg'u bu' nga geksud'u, gaku' gaid ini. Ikap niyau bu' mesuunan niyu. Su kalag nda'iruni dlawasen ma'ad gaku', duuni dlawas'u bu' me'ita'u gaid niyu.” ");
INSERT INTO stb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Peketubusen megasuy run nini, pi'ita'en ri senilan su nga gemegen bu' su nga geksuren. ");
INSERT INTO stb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Se kebagel ne dleliyag bu' ketingala nilan maa' ndi' ilan meketu'u seng mi'ita' nilan. Bu' miksaak rayun si Jesus ri senilan, “Duun bai gaan niyu rini?” ");
INSERT INTO stb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Binegayan nilan giin nek salabuuk nek tiniti' nek sera', ");
INSERT INTO stb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","bu' inuwanen ini bu' inaanen ri seng metungenga'an nilan. ");
INSERT INTO stb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Rayun miktalu' giin senilan, “Giin nini suk tinalu'u seniyu saanay sementaunu pa niyu, ne su dlaun neng misulat metendeng ri senaan ri se Kesugu'an ni Moses, sinulat nu ngak Propeta, bu' se ngak Salmo kina'enlan gaid neng metuman.” ");
INSERT INTO stb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Rayun inebangaan ilan sek peksabut ri se Kesulatan. ");
INSERT INTO stb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Miktalu' giin ri senilan, “Misulat ri se Kesulatan ne sung Misiyas kina'enlan gaid megantus, ma'ad metubu' giin puli' buwat ri se kemetain ri se ketelu endaw, ");
INSERT INTO stb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","bu' ri se ngalanen sung minsahi metendeng ri sek pekpeddiksu' bu' pekpasaylu ri se ngak sala' me'asuy tu se dlaun ne ngang nasud buwat seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gamu su ngang mekepemetuud se ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bu' enlengay niyu, pawit'u ri seniyu su Gispiritu Santu nek sinaad ne Gama'u. Ma'ad ndi' amu reli' megawa' rini sek siyudad tampan merawat niyu su ga'em neg buwat se dlangit.” ");
INSERT INTO stb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mbuus inuwit ilan ni Jesus tu seg Betania. Peddateng nilan ritu, pitaaseni nga gemegen bu' pingumpiyanaan ilan. ");
INSERT INTO stb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Saanay pingumpiyanaan ilan, mikpelayu'layu' giin buwat senilan bu' rayun pilentu giin tu se dlangit. ");
INSERT INTO stb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sinimba nilan giin bu' mipuli' ilan seg Jerusalem ned duuni gembagel ne dleliyag, ");
INSERT INTO stb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","bu' kanunay ilan ritu sek Templo sek peksaya' ri sed Diwata.");
INSERT INTO stb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Se genda' pa mbaal sug benwa, suk Talu' diin na. Talu' keni duma ned Diwata bu' suk Talu' Giin sud Diwata. ");
INSERT INTO stb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Giin sud duma ned Diwata se genda' pa mbaal sug benwa. ");
INSERT INTO stb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pebiyan ri seniin, binaal ned Diwata su dlaun ne ngag betang; bu' nda' giin, nda'iruni isan landun ne ngag betang ne gembaal. ");
INSERT INTO stb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Suk Talu' giin suk pigbuwatan ne ketubu', bu' ketubu' keni migbegay ned delaag ri se nga getaw. ");
INSERT INTO stb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Bu' delaag keni dinumelaag ri se kerelem bu' su kerelem, genda' mekeddaag ri sed delaag keni. ");
INSERT INTO stb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na, duuning minateng ne getaw nek sinugu' ned Diwata, su ngalanen si Juan. ");
INSERT INTO stb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Sinugu' giin ned Diwata sek pekpemetuud metendeng ri sed delaag keni, arun pebiyan ri seniin meketu'u su dlaun ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Gena' giin sud delaag, ma'ad mirini giin sek pekpemetuud metendeng ri sed delaag. ");
INSERT INTO stb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sung metuud ned delaag merini seg benwa arun su dlaun ne nga getaw merelaagan. ");
INSERT INTO stb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Rini giin seg benwa, bu' isan su nga dlangit bu' dlupa' binaal pebiyan ri seniin, ma'ad su nga getaw ri seg benwa genda' mekilala ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mirini giin se gegulingenen ne nga getawan, ma'ad nda' nilan giin duwatay. ");
INSERT INTO stb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma'ad su ngad dinumawat bu' miktu'u ri seniin, binegayaan ne ketenged ne gembaal ne ngag bata' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nda' ilan mbaal ne nga gembata' ned Diwata seng mi'enaran nek pebiyan ne getaw, ri senita pa mi'etaw gisip nga gembata' se kinilawan ne gama'; tumu', sud Diwata mismu giin su gegulingen nilan ne Gama'. ");
INSERT INTO stb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bu' Talu' keni mibaluy ne getaw bu' mipenu' ne dlelaat bu' kemetuuran neng mikengel ri senita. Rayun mi'ita' nami suk pekege'emaan, pekege'eman keni mirawaten gisip buntung Bata' ne Gama'. ");
INSERT INTO stb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","(Mikpemetuud si Juan metendeng riin seniin. Migbeksay giin, “Giin nini suk tinalu'u ri seniyu seng miktalu'u, ‘Sumunud giin ri senaan, ma'ad labaw pa giin ri senaan, ay se genda'u pa me'etaw diin na giin.’”) ");
INSERT INTO stb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tendeng ay buwat se gembagel ne dlelaaten, dlaunan ta mikerawat seng miksunudsunud ne kepiyaan. ");
INSERT INTO stb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tendeng ay su Kesugu'an binegay pebiyan riin ni Moses; ma'ad su dlelaat bu' su kemetuuran binegay pebiyan riin ni Jesus Christ. ");
INSERT INTO stb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nda'iruning mikiita' riin sed Diwata; ma'ad sug buntung Bata'en nek sementaun kanunay ne Gama'en, giin sung mikpe'ilala ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Giin nini suk pekpemetuud ni Juan seng miksugu' su ngag Judeo ne ngak pari' bu' ngang mekpegabang ri se ngak pari' tu sek templo neg buwat seg Jerusalem arun sek peksaak riin ni Juan, “Ta'a ma ne getaw?” ");
INSERT INTO stb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bu' nda'iruni ginedlud ni Juan, tumu' miktalu' giin seng metuud, laungen, “Gena' gaku' sung Misiyas.” ");
INSERT INTO stb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bu' miksaak ilan puli', “Lama run rayun? Dya'a ba si Elias?” Bu' miksembag si Juan, “Gena'u si Elias.” Miktalu' ilan puli', “Propetaa ba?” Bu' miksembag giin, “Gena'.” ");
INSERT INTO stb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Rayun miktalu' ilan, “Ta'a ba ne getaw? Esuyay mu ami arun duuning mesembag nami ri seng miksugu' senami. Landun maing metalu' mu metendeng ri se gegulingen mu?” ");
INSERT INTO stb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Miksembag si Juan pebiyan se ngak tinalu' ni propeta Isaias, “Gaku' su getaw nek tinalu' ni propeta Isaias: ‘neng megbeksay ri se kemingawan. Leddeng niyu sud dalan neg biyanan ne Ginu'u.’” ");
INSERT INTO stb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bu' su ngak sinugu' ketu, sinugu' ilan buwat se dlumpuk ne ngak Pariseo, ");
INSERT INTO stb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","bu' sinaakan nilan rayun si Juan, “Lama membendyag'a run se nga getaw bu' gena' dya'a sung Misiyas awas si Elias awas suk propeta?” ");
INSERT INTO stb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Miksembag si Juan, “Gaku' migbendyag pebiyan ri sek tubig; ma'ad riin seniyu duuning migindeg ne genda' pa niyu me'ilala, ");
INSERT INTO stb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","suk sala neng mateng neng meksunud ri senaan; ndi'u mbaya' ne mbaal nek sesugu'enen isan sek pegugbad se giket nek sandalyasen.” ");
INSERT INTO stb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ngag betang keni mihitabu' ritu se dlugar neg Betania dipag neg Jordan ned ditu si Juan mimbendyag. ");
INSERT INTO stb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sek sunud ne gendaw, mi'ita' ni Juan si Jesus neng mikpagaw ri seniin, miktalu' rayun si Juan ri se nga getaw, “Enlengay niyu, giin sung Nati ne Karniru ned Diwata, sung mekpasaylu sek sala' se dlaun ne nga getaw ri seg benwa. ");
INSERT INTO stb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Keni na gaid giin suk tinalu'u ri seniyu, ‘Neng mateng sunud ri senaan, su getaw ne dlabaw pa ri senaan, tendeng ay se genda'u pa me'etaw diin na giin.’ ");
INSERT INTO stb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Bu' gaku' nud diin nda' mekilala ri seniin; ma'ad arun mpesuun giin tu se nga getaw Israel, aas miriniu sek pegbendyag nek tubig.” ");
INSERT INTO stb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Bu' mikpemetuud si Juan, “Mi'ita'u su Gispiritu nek tinumena' ri seniin maa' se gawi' nek selepati neng migbuwat se dlangit bu' mikpebilin ini ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Bu' isan gaku' nda' mekilala ri seniin, ma'ad suk sala neng miksugu' ri senaan sek pekpemendyag ri sek tubig, miktalu' ri senaan, ‘sung mi'ita'an mu run nek tena'an ne Gispiritu bu' mekpebilin ri seniin, giin itu sung megbendyag tu se nga getaw seg Bala'an ne Gispiritu.’ ");
INSERT INTO stb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Bu' mi'ita'u giin bu' pimetuuran'u ne Giin sug Bata' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sek sunud ne gendaw, ditu na pelum si Juan migindeg duma sed duwa' tawan nek tinu'unanen, ");
INSERT INTO stb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","bu' seng mi'ita'en si Jesus neng minayan, miktalu' giin, “Enlengay niyu, kiin na sung Nati ne Karniru ned Diwata!” ");
INSERT INTO stb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bu' sek pekerengeg run rayun itu nud duwa' tawan nek tinu'unanen, midlendug ilan rayun riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bu' sek pedlingay ni Jesus, mi'ita'en ilan neng midlendug. Rayun miksaak giin, “Landunik pinengaw niyu?” Bu' miksembag ilan, “Rabi (sug be'et pesabut Menintulu'), ta'a ma mikengel?” ");
INSERT INTO stb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Miktalu' giin ri senilan, “Rini amu arun me'ita' niyu.” Aas miritu ilan bu' mi'ita' nilan suk pikengelaan; bu' mikpebilin ilan na ma'ad ritu se gendaw ketu tendeng ay meg'alas kuwatru na itu se dlelabung. ");
INSERT INTO stb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Si Andres nek pated ni Simon Pedro, giin suk sala sed duwa' neng mikerengeg sek tinalu' ni Juan bu' sung midlendug riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Su guna neg betang neg binaal ni Andres, pinengaun suk pateren ne si Simon bu' inesuyaan, “Mi'ita' nami sung Misiyas (su gulugaan Christ).” ");
INSERT INTO stb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Inuwiten si Simon ritu ni Jesus. Migenleng rayun si Jesus tu ni Simon bu' miktalu', “Dya'a masi' si Simon sug bata' ni Juan. Ingelanan'u dya'a nek Cepas (maa' ra nek Pedro ne su gulugaan batu).” ");
INSERT INTO stb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sek sunud ne gendaw, liyagan ni Jesus neng meritu sek probinsiya ne Galilea. Bu' ritu mi'ita'en si Felipe bu' miktalu' giin, “Sunud'a ri senaan.” ");
INSERT INTO stb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Na, si Felipe keni taga siyudad neg Betsaida ne dlugar rema ni Andres bu' ni Pedro. ");
INSERT INTO stb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pinengaw ni Felipe si Natanael, bu' miktalu' giin ri seniin, “Mi'ita' na nami su getaw nek sinulat ni Moses ri se Kesugu'an, bu' sinulat rema ne ngak propeta. Giin masi' si Jesus neg bata' ni Jose nek taga Nazaret.” ");
INSERT INTO stb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Miktalu' rayun si Natanael ri seniin, “Duun baing me'uwan neng melengas buwat seng Nazaret?” Miksembag si Felipe, “Rini'a arun me'ita' mu.” ");
INSERT INTO stb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sek pekiita' ni Jesus riin ni Natanael neng mikpagaw riin seniin, bu' miktalu' giin metendeng riin seniin, “Enlengay niyu, keni na sung metuud ne getaw Israel ne genda' gaid penlimbung.” ");
INSERT INTO stb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Miksaak si Natanael riin seniin, “Lama me'ilala mau run?” Sinembag giin ni Jesus, “Se genda'a pa tuwagay ni Felipe, saanay mu pa ritu sek silung ne gayu neg Igira, mi'ita'u dya'a.” ");
INSERT INTO stb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Miksimbag si Natanael “Rabi, dya'a sug Bata' ned Diwata! Dya'a su Gari' seg Israel!” ");
INSERT INTO stb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Miksembag si Jesus bu' miktalu' tu seniin, “Miktu'ua ba ri senaan, tendeng ay miktalu'u ri seni'a neng mi'ita'u dya'a ri sek silung ne gayu neg Igira? Mekiita'a pa ne ngag betang ne dlabaw pa kampuun run nini.” ");
INSERT INTO stb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Bu' miktalu' pa gaid si Jesus ri senilan, “Sek pekemetuud, asuy'u ini ri seniyu neng matengi gendaw neng me'ita' niyu ne mpuka su dlangit maa' sek pekpuka niyu ri sed dungawan niyu bu' me'ita' rema niyu su ngag anghel ned Diwata neng mekperitaas tu se dlangit bu' mekpebaba' rema ri seg Bata' ne Getaw.” ");
INSERT INTO stb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sek peksagad sed duwa' endaw, duuni kasal tu se dlunsud ne Cana sek probinsiya ne Galilea. Bu' ritu su gina' ni Jesus, ");
INSERT INTO stb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","bu' inenggat rema si Jesus duma se ngak tinu'unaan tu se kasal. ");
INSERT INTO stb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bu' seng migela' na sug binu, miktalu' su gina' ni Jesus ri seniin, “Migela'an ilan na neg binu.” ");
INSERT INTO stb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Bu' miksembag si Jesus tu seniin, “Ina', ndi' mau telu'ay se gembaya'u baalen. Nda' pa mateng suk panahun'u.” ");
INSERT INTO stb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Miktalu' su gina'en ritu se ngang migilak, “Su isan landun nek sugu'en riin seniyu, baal niyu.” ");
INSERT INTO stb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na, su ngag Judeo duuning mi'enaran nilan sek pedlimpiyu bu' tendeng run nini duunig binetang ritu ne genem buuk ne gamang ne gunsu' neg binetangan nek tubig para pengugas. Kada gamang ne gunsu' meseleran ned duwa' pulu' tampan telu pulu' ne nga galun nek tubig. ");
INSERT INTO stb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Miktalu' si Jesus tu se ngang migilak, “Penu' niyu nek tubig su nga gamang ne gunsu'.” Bu' binetangan rayun nilan nek tubig pilepeng tampan ri seg baba'en. ");
INSERT INTO stb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Laung rayun ni Jesus ri senilan, “Na, saguk amu riin bu' uwit niyu rayun tu seng midlegeseg ri se kumbira.” Aas sinumaguk ilan bu' inuwit ritu seng midlegeseg. ");
INSERT INTO stb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Rayun ininamaan suk tubig neng mibaluy neg binu. Bu' nda'en mesuunay bu' ta' migbuwat sug binu ketu (ma'ad su ngang minggilak, nek sinumaguk, mikesuun run nitu.) Rayun pitawagen suk pemenaan, ");
INSERT INTO stb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","bu' miktalu' giin tu seniin, “Mibetasan ta neg begay guna su dlabi neng melengas neg binu bu' melaun na gani'ing me'inum nilan, dekag pa begay su gena' melengas neg binu. Ma'ad dya'a peddayun mu pa sek pegilak su dlabi neng melengas neg binu tampan numuun.” ");
INSERT INTO stb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Giin itu su guna ne nga ketingelaan neg binaal ni Jesus ritu se dlunsud ne Cana se Galilea; pi'ita'en ritu suk pekege'emaan, bu' miktu'u ri seniin su ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Dluwat se kasal keni, tinumegbeng rayun si Jesus duma se gina'en, se ngak pateren ne nga dlai, bu' se ngak tinu'unaan pagaw tu se Capernaum. Bu' mikengel ilan ritu nek santa' endaw. ");
INSERT INTO stb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Megaud na suk pekse'ulug sek Paska. Aas tinumuwad si Jesus tu seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mi'ita'en rayun ritu sek templo su nga getaw neng mimeledya' ne ngag baka, nga karniru bu' ngak selepati. Bu' duun remai nga getaw ritu neng minggingkud ne ngang mentelesay nek selapi'. ");
INSERT INTO stb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aas migbaal giin ne dlekpes buwat se nga dlupis bu' rayun inalegen ilan duma su nga karniru bu' ngag baka tu se gawas nek Templo. Bu' pindingkalangen rema su nga dlemisan ne ngang mentelesay nek selapi' bu' pinsigwagen su ngak selapi' nilan. ");
INSERT INTO stb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Bu' miktalu' giin tu se ngang mimeledya' ne ngak selepati, “Pengawa' niyu ngag betang keni rini! Ndi' niyu baalay sug balay ne Gama'u nek tebu'an!” ");
INSERT INTO stb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bu' rayun mi'ena'ena' nu ngak tinu'unaan suk sinulat ned diin se Kesulatan, laung pa, “Su gembagel ne kegules'u para seg balay mu maa' neng midliga' ne gapuy ri se gena'ena'u.” ");
INSERT INTO stb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Rayun miksaak su ngag Judeo, “Landun mai ketingelaan ne gempe'ita' mu senami ned duuni ketenged mu sek pegbaal run nini?” ");
INSERT INTO stb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sinembag ilan ni Jesus, “Geba' niyuik Templo keni, bu' sek seled nek telu endaw, bekuren'u ini puli'.” ");
INSERT INTO stb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Miksembag ilan rayun, “Templo keni binaal sek seled se gepaat pulu' bu' enem taun, bu' bekuren mu ma'ad puli' seled sek telu endaw?” ");
INSERT INTO stb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ma'ad suk templo nek sinambay ni Jesus giin su dlawasen. ");
INSERT INTO stb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Aas sek peketubu'en puli' buwat se kemetain, mi'ena'ena' nu ngak tinu'unaan su ngak pintalu'en ketu; bu' miktu'u ilan se kesulatan bu' sek talu' nek tinalu' ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na, saanay ditu si Jesus seg Jerusalem sek panahun se kese'ulugan nek Paska, melaun senilan sung miktu'u ri se ngalanen seng mi'ita' nilan su nga ketingelaan nek pimbaalen. ");
INSERT INTO stb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma'ad si Jesus nda'en salig su gegulingenen tu senilan tendeng ay misuunaan ma su dlaun ne nga getaw, ");
INSERT INTO stb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","bu' ndi' na kina'enlan ned duun paing mektalu' ri seniin bu' landun diin se gena'ena' ne nga getaw tendeng ay misuunaan na daan. ");
INSERT INTO stb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na, duunik sala tawan nek sakup se dlumpuk nek Pariseo. Su ngalanen si Nicodemo. Geseg giin se ngag Judeo. ");
INSERT INTO stb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Getaw keni miritu ni Jesus sek panahun ne gebii bu' miktalu' ri seniin, “Rabi, misuunan nami ned dya'a menintulu' neng minateng buwat pa sed Diwata; tendeng ay genda'iruning mikegbaal ne nga ketingelaan neng maa' neg binaal mu' keni, bu' sud Diwata nda' ri seniin.” ");
INSERT INTO stb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Miksembag si Jesus riin seniin, “Sek pekemetuud, esuyan'u dya'a: nda'iruning mekiita' sek Pedlegeri'an ned Diwata gawas seng me'etaw giin puli'.” ");
INSERT INTO stb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Miksaak si Nicodemo, “Pegendunen ma run pekpe'etaw puli' bu' dlegulang na giin? Ndi' na giin mekehimu sek pekseled puli' ri sek telibetanan ne gina'en bu' mekpe'etaw se keruwa'.” ");
INSERT INTO stb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Miksembag si Jesus, “Sek pekemetuud esuyan'u dya'a, nda'iruni getaw neng mesakup sek Pedlegeri'an ned Diwata bu' ndi' giin me'etaw ri sek tubig bu' Gispiritu. ");
INSERT INTO stb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Su getaw neng migegetaw buwat se ngang megulangen, getaw giin. Ma'ad su Gispiritu ned Diwata migbegay ne gispiritu ri senita. ");
INSERT INTO stb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aas ndi'a metingala sek tinalu'u riin seni'a ne kina'enlan me'etaw amu puli'. ");
INSERT INTO stb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Su genus medlegurus isan ta'. Merengeg mu suk pedlegurusen ma'ad ndi' mu mesuunan bu' ta' ini migbuwat bu' ta' ini pagaw. Maa' rema run sung mi'etaw ri se Gispiritu.” ");
INSERT INTO stb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Miksaak puli' si Nicodemo, “Pekunta'en run nini?” ");
INSERT INTO stb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Miksembag si Jesus, “Mi'ilelaan'a neng mentetendu' seg Israel, bu' mbuus nda' mu mesuunay ngag betang keni? ");
INSERT INTO stb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sek pekemetuud esuyan'u dya'a, ne sung misuunan nami, giini ginasuy nami; bu' sung mi'ita' nami, giinik pemetuuran nami; ma'ad nda' niyu duwatay suk pekpemetuud nami. ");
INSERT INTO stb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Bu' asuy'u seniyu su ngag betang dini seg benwa, bu' ndi' amu mektu'u run nini, gendun pa sakan bu' esuyan'u amu metendeng se ngag betang ritu se dlangit? ");
INSERT INTO stb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Bu' nda'irun isan ta' ne getaw neng minaik tu se dlangit gawas ma'ad sug Bata' ne Getaw neng minaug buwat se dlangit.” ");
INSERT INTO stb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Middugang sek pektalu' si Jesus, “Bu' maa' sek pekpetaas ni Moses seng mamak neg brunsi tu se kemingawan, sug Bata' ne Getaw kina'enlan petaasen rema, ");
INSERT INTO stb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","arun su kada sala neng mektu'u riin seniin mekaangken ne ketubu' ne genda'iruni gekteben. ");
INSERT INTO stb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ay pinetail gaid ned Diwata su nga getaw rini seg benwa, aas binegain sug buntung bata'en, arun isan ta' neng mektu'u ri seniin ndi' matay bu' ndi' mekaangken tumu' se ketubu' ne genda'i gekteben. ");
INSERT INTO stb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ay nda' sugu'ay ned Diwata sug Bata'en rini seg benwa arun mbaal neng Mengengukum, bu' ndi' Menleluwas. ");
INSERT INTO stb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Suk sala neng mektu'u ri seg Bata'en ndi' me'ukuman. Ma'ad suk sala ne genda' pektu'u ri seg Bata'en mi'ukuman na tendeng ay nda' pektu'u ri se ngalan seg buntung Bata' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bu' giin nini suk pegukum: tendeng ay minateng na sud delaag rini seg benwa ma'ad su nga getaw ndi' nilan liyagan su kerelaag tendeng ay melaaten su ngak pimbaal nilan. ");
INSERT INTO stb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tendeng ay su dlaun neng megbaal neng melaat, ginemetan nilan su kerelaag. Bu' ndi' ilan mekepegaud riin se kerelaag tendeng ay mendek ilan neng mesuunan sung mekelaat ne ngak pimbaal nilan. ");
INSERT INTO stb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma'ad su getaw neng migbaal sumala' riin se kemetuuran mekepegaud riin seng merelaag arun me'ita' ne sug binaal nilan giin suk pektuman riin sed Diwata.” ");
INSERT INTO stb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Peketubus itu, miritu si Jesus bu' su ngak tinu'unanen sek probinsiya neg Judea, bu' mikpebilin giin duma senilan ritu nek santa' endaw bu' mimbendyag. ");
INSERT INTO stb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Se dlain neg bahin, mimbendyag rema si Juan ritu seg Enon megaud tu sek Salim tendeng ay melaunik tubig ritu; bu' minditu seniin su nga getaw bu' binendyagaan ilan, ( ");
INSERT INTO stb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ay nda' pa itu mperisu si Juan.) ");
INSERT INTO stb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Rayun duuni ngak tinu'unan ni Juan neng migaddat ri sek sala Judeo metendeng ri seg betasan sek pekpenlimpiyu. ");
INSERT INTO stb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bu' minditu ilan ni Juan bu' miktalu' tu seniin, “Rabi, mi'ena'ena' mu pa ba su getaw nud diin nek sementaun mu ritu sed dipag neg Jordan nek pi'ilala mu tu se nga getaw? Enlengay mu, mimbendyag na giin numuun bu' su dlaunlaun ne nga getaw miritu na seniin!” ");
INSERT INTO stb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Miksembag si Juan senilan, “Nda'iruni gembaal ne getaw bu' gena' ini binegay ned Diwata. ");
INSERT INTO stb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gamu tumu' mekepemetuud neng miktalu'u ne gena' gaku' sung Misiyas, bu' ndi', sinugu'u na run neng meguna riin seniin. ");
INSERT INTO stb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Suk pengesuwaan para ra sek pemenaan; ma'ad pidleliyag suk sambat, neng migindeg bu' minginengeg ri sek tapad nek pemenaan seng merengegen suk talu' nek pemenaan. Seng maa' nek pebiyan, gembagel na rema suk pedleliyag'u. ");
INSERT INTO stb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kina'enlan gaid neng meddaik pa suk pegilala riin ni Jesus, bu' gaku' medlekus.” ");
INSERT INTO stb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Giin neg buwat tu se dlangit ge'eman ri se dlaunan. Giin neg buwat rini seg benwa taga benwa bu' miktalu' metendeng se ngag betang rini seg benwa. Giin neg buwat tu se dlangit ge'eman ri se dlaunan. ");
INSERT INTO stb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Landun sung mi'ita'en bu' mirengegen, pimetuuraan ma'ad nda'irunid dinumawat ri sek pekpemetuuren. ");
INSERT INTO stb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Suk sala, neng mikerawat sek pekpemetuuren, mekpemetuud ne sud Diwata metinuuren. ");
INSERT INTO stb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ay suk sinugu' ned Diwata migasuy seng minsahi ned Diwata; bu' se genda'i gekteben, binegayan giin ne ga'em se Gispiritu. ");
INSERT INTO stb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Su Gama' mikpetail seg Bata'en bu' piniyalen seniin su dlaun ne kega'emen. ");
INSERT INTO stb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Su isan ta' neng miktu'u ri seg Bata', duuni ketubu'en ne genda'iruni gekteben; su isan ta' ne gena' meksunud ri seg Bata', ndi' gaid mekaangken ne ketubu' ma'ad silutan giin ned Diwata. ");
INSERT INTO stb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mirengeg nu ngak Pariseo ne si Jesus mikuuwan neng melaun ne ngak tinu'unan bu' mikebendyag neng melaun sinangkali' ri ni Juan, ( ");
INSERT INTO stb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","isan tumu' gena' si Jesus sung migbendyag ma'ad su ngak tinu'unaan.) ");
INSERT INTO stb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Aas sek pekerengeg ni Jesus run nini, migawa' giin tu seg Judea bu' mipuli' tu se Galilea. ");
INSERT INTO stb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ri sek pedlaangen, kina'enlan neng mayan giin sek Samaria. ");
INSERT INTO stb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ri sek Samaria, miritu giin se dlunsud ne giningelanan nek Sikar. Dlunsud ketu, megaud se dlupa' neg binegay ni Jacob ri seg bata'en ne si Jose. ");
INSERT INTO stb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na, ditu duunid delungan ni Jacob, bu' si Jesus nek pinlubay na ri se dlaangan, migingkud giin tu se geksid ned delungan. Teras taasendaw na itu. ");
INSERT INTO stb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Nda' ritu su ngak tinu'unaan tendeng ay miritu ilan se dlunsud arun menaluy neng me'aan nilan. Nda' santa', minateng su dlibun nek taga Samaria sek peksaguk nek tubig. Miktalu' si Jesus riin seniin, “Menengiu siya nek tubig neng me'inum.” ");
INSERT INTO stb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Miksembag rayun su dlibun ri seniin, “Dya'a neg Judeo. Tuma ma menengia nek tubig buwat senaan bu' labi pa, gaku' ne dlibun neg buwat pa sek tribu nek Samaria?” (Su ngag Judeo ndi' meketipung tu se ngak taga Samaria.) ");
INSERT INTO stb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Miksembag si Jesus ri seniin, “Bu' misuunan mu pa sug begay neg binegay ned Diwata bu' ta' sung minengi seni'a nek tubig neng me'inum, dya'a pa siya sung menengi ri seniin arun mbegayaan'a nek tubig neng mekegbegay ne ketubu'.” ");
INSERT INTO stb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Sir,” miktalu' su dlibun ri seniin, “Nda'irunik pensaguk mu bu' meralem sud delungan. Ta' mu ma uwanayik tubig ketu neng mekegbegay ne ketubu' ne nda'iruni gekteben? ");
INSERT INTO stb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Labaw'a pa ba tu se gapu' ta ne si Jacob, neng migbegay senami ned delungan bu' miginum giin buwat rini, asta rema su nga gembata'en bu' su ngak petubu'enen?” ");
INSERT INTO stb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Miksembag si Jesus, “Isan ta' neng minum ri sek tubig keni, kinumen giin puli', ");
INSERT INTO stb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ma'ad isan ta' neng minum ri sek tubig neg begay'u, ndi' na gaid kinumen. Bu' suk tubig neg begay'u ri senilan mbaal neng maa' nek tebud ne ndi' metiyan ne giining megbegay ri senilan nek tubig se ketubu' ne genda'i gekteben.” ");
INSERT INTO stb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dayun miktalu' su dlibun tu ni Jesus, “Sir, begayay mau run sek tubig iin arun ndi'u na pedlekinumen bu' ndi'u na rema mekpuli'puli' rini sek peksigeb.” ");
INSERT INTO stb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Miktalu' si Jesus seniin, “Puli'a bu' uwit mu rini sug bana mu.” ");
INSERT INTO stb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Miksembag su dlibun, “Nda'irunig banau.” Miktalu' si Jesus riin seniin, “Ginsaktu tinalu' mu kiin ne nda'irunig bana mu. ");
INSERT INTO stb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ay lima tawan su ngag bana mu nud diin, bu' su dlai nek tinipungtipung mu numuun gena' metuud neg bana mu. Suk tinalu' mu metuud.” ");
INSERT INTO stb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Sir,” miktalu' su dlibun, “Misabut'u ne dya'a propeta. ");
INSERT INTO stb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Su nga gepu'an nami nek taga Samaria miksimba ri sed Diwata rini seg bentud keni ma'ad gamu ngag Judeo miktalu' ne kina'enlan ditu seg Jerusalem gaid simbaan ta sud Diwata.” ");
INSERT INTO stb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Miktalu' si Jesus tu se dlibun, “Tu'uway mau, mateng suk panahun ne ndi' amu na kambat meksimba riin se Gama' rini seg bentud keni awas ditu seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gamu nek taga Samaria miksimba se nda' gaid niyu me'ilala; gami ne ngag Judeo miksimba seng mi'ilala nami tendeng ay suk sala neng medluwas ri se getawan buwat ri sek tribu neg Judeo. ");
INSERT INTO stb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ma'ad mateng suk panahun bu' nemuun minateng na, nek pebiyan se ga'em ne Gispiritu ned Diwata, su nga getaw meksimba ri se Gama' sek pekedDiwataan, megbegay ri seniin seng metuud nek peksimba ne dliyagaan. ");
INSERT INTO stb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Sud Diwata Gispiritu, bu' pebiyan na run se ga'em ne Gispirituun mekesimba su nga getaw ri sek pekedDiwataan.” ");
INSERT INTO stb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Miktalu' su dlibun tu seniin, “Misuunan'u ne sung Misiyas ne giningelanan ne Christ mateng; bu' seng mateng na giin, talu'en senita su dlaun ne ngag betang.” ");
INSERT INTO stb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Rayun si Jesus miktalu' seniin, “Gaku' Giin, sung miktuntul seni'a.” ");
INSERT INTO stb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bu' sek panahun ketu, minateng su ngak tinu'unanen bu' mitingala ilan gaid sek pekiita' nilan nek tinumuntul giin tu sek sala dlibun. Tumu' nda'irun isan sala ri senilan neng miksaak bu' landuni dliyagaan, awas miksaak lama tinumuntul run giin tu se dlibun. ");
INSERT INTO stb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dayun binilin nu dlibun su gamang nek peksigebaan, bu' mipuli' giin ditu sek siyudad bu' miktalu' giin tu se nga getaw, ");
INSERT INTO stb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Pedduut amu senaan bu' pe'ita'u riin seniyu su getaw neng mikesuun se dlaun neg binaal'u. Gena' ba sakan giin na ini sung Misiyas?” ");
INSERT INTO stb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ginumawas ilan ri sek siyudad bu' miritu ilan seniin. ");
INSERT INTO stb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sek panahun ketu, inenggat ne ngak tinu'unan si Jesus, “Rabi, aan'a reli'.” ");
INSERT INTO stb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma'ad miktalu' si Jesus tu senilan. “Duuni gaan'u ne genda' niyu mesuunay.” ");
INSERT INTO stb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aas miksesaakay su ngak tinu'unaan, “Duun baing miguwit seniin ne gaan?” ");
INSERT INTO stb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Miktalu' si Jesus senilan, “Suk pekaan'u giin suk pektuman se keliyag neng miksugu' ri senaan bu' tubusen'u sug baalen nek pibaalen ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Duunik pentelu'en niyu, ‘Duuni gepaat bulan dekag penlegani.’ Enlengay niyu, mektalu'u seniyu, dayag niyu su ngag binaal. Mingginug na bu' mbaya' na geniin. ");
INSERT INTO stb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sung medlegani mekerawat nek su'ul bu' tipungen sug bunga para ri se ketubu' ne genda'iruni gekteben; aas sung migerek meksama nek pedleliyagen duma seng medlegani. ");
INSERT INTO stb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ay suk pentelu'en metuud gaid, ‘Sala sung megerek bu' dlain rema sung medlegani.’ ");
INSERT INTO stb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Sinugu'u amu arun medlegani se nga geniin ne gena' gamuing migbaal run; dlaining migbaal run nini, bu' gamuing mikegani ri se ngak pitugesan nilan.” ");
INSERT INTO stb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na, se dlugar ketu, melaun ne ngak taga Samaria sung miktu'u riin ni Jesus tendeng sek pekpemetuud nu dlibun, “Tinalu'en ri senaan su dlaun nek pimbaal'u.” ");
INSERT INTO stb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Rayun sek peddateng ne ngak taga Samaria ritu ni Jesus, inandyu' gaid nilan giin neng mekengel reli' giin ritu senilan. Bu' mikpebilin giin ritu sed duwa' endaw. ");
INSERT INTO stb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bu' melaun paid dugang neng miktu'u riin seniin tendeng ri seng minsahiin. ");
INSERT INTO stb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tinelu'an rayun nu nga getaw su dlibun ketu, “Gena' na run tendeng sek tinalu' mu senami neng miktu'u ami riin ni Jesus, tendeng ay gami na gaid tumu' sung mikerengeg seniin, bu' misuunan nami ne giin gaid sung Menleluwas se nga getaw seg benwa.” ");
INSERT INTO stb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na, tubus mikengel giin ritu sed duwa' endaw, miritu si Jesus se Galilea. ");
INSERT INTO stb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ay si Jesus tumu' sung miktalu', “Suk propeta ndi' pegbesaan ri se gegulingenen neng nasud.” ");
INSERT INTO stb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sek peddatengen se Galilea, inalimba' giin ne nga getaw Galilea tendeng ay mi'ita' nilan su dlaun nek pimbaalen ritu seg Jerusalem sek Pista nek Paska, ay ritu ilan rema sek Pista. ");
INSERT INTO stb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mipuli' na pelum si Jesus se Cana nek sakup ne Galilea ne ritu binaalen sug binu neg buwat sek tubig. Bu' duunik sala ne gupisyal ri sek siyudad ne sug bata'en ne dlai midlaru ritu se Capernaum. ");
INSERT INTO stb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Getaw keni, sek pekerengegen run ne si Jesus minateng se Galilea buwat seg Judea, miritu giin ni Jesus bu' inandyu'en giin neng meritu se Capernaum bu' petelenen sug bata'en tendeng ay mikpinal na. ");
INSERT INTO stb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Miktalu' rayun si Jesus riin seniin, “Bu' nda' amu pa mekiita' ne nga ketingelaan ne ngag betang, ndi' amu mektu'u senaan.” ");
INSERT INTO stb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Miktalu' su gupisyal, “Sir, bu' mehimu diksun'a duma senaan se gendi' pa tagad matay sug bata'u.” ");
INSERT INTO stb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Miksembag si Jesus, “Uli'a na; tetubu' ra sug bata' mu.” Miktu'u su gupisyal sek tinalu' ni Jesus ri seniin bu' minuli' rayun giin. ");
INSERT INTO stb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Bu' rayun seng middiksun pa giin ri sed dalan, linabet na giin nu ngak sesugu'enen bu' inesuyan giin ne sug bata'en tetubu' ra. ");
INSERT INTO stb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Aas miksaak giin senilan, “La urasay run mitelen giin?” “Labung seng meg'ala'una ri se dlelabung, mirala' suk panasen,” sembag ne ngak sesugu'en. ");
INSERT INTO stb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Misuunan rayun nu gama' ne giin gaid itu su guras neng miktalu' si Jesus ri seniin ne sug bata'en tetubu' ra. Bu' miktu'u giin riin ni Jesus bu' suk tibuuk nek pamilyaan. ");
INSERT INTO stb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na, keni su keruwa' ne ketingelaan neg binaal ni Jesus sek pekpuli'en se Galilea buwat seg Judea. ");
INSERT INTO stb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Dluwat ngag betang keni, duunik pista nu ngag Judeo bu' tumuwad si Jesus seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na, ritu seg Jerusalem, duuni dlinaw ne iningelanan ri sek tinuntulan ne ngag Hebreo neg Betsata. Su dlinaw, ned duuni nga dlima buuk penilungan, megaud ri se Genga'an ne nga Karniru, ");
INSERT INTO stb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ned ditu membelilid sung melaun ne ngang midlaru—ngag buta, ngag bekul bu' ngak paralitiku. ");
INSERT INTO stb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bu' duunik sala tawan ritu nek telu pulu' bu' walu taun na neng midlaru. ");
INSERT INTO stb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Getaw keni, tubus mi'ita' giin ni Jesus neng migbelilid ritu bu' misuunanen ne sung megeelen maa'entu na kepayat, miksaak si Jesus ri seniin, “Liyagan mu ba neng me'uli'an?” ");
INSERT INTO stb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Miksembag sung midlaru, “Sir, nda'iruni getawing mekeguwit ri senaan ditu se dlinaw seng mekuleg na suk tubig; ma'ad saanay'u pa mekpagaw ritu, me'unaanu kanunay ned duma.” ");
INSERT INTO stb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Miktalu' si Jesus ri seniin, “Gindeg'a, inat muik pegbeliliran mu kiin bu' dlaang'a.” ");
INSERT INTO stb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Bu' rayun mi'uli'an su getaw, bu' ininaten suk pigbeliliraan bu' midlaang ri sek timala'. Na, mihitabu' itu se gendaw nek pengulali. ");
INSERT INTO stb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Aas miktalu' su ngag Judeo tu se getaw nek pitelen, “Uy, gena' ba gendaw ini nek pengulali? Bu' supak ri se Kesugu'an ta suk peguwit ri sek pigbeliliran mu.” ");
INSERT INTO stb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ma'ad miksembag su getaw, “Su getaw neng mikpetelen ri senaan, giining miktalu' senaan ne inaten'u suk pigbeliliran'u bu' pilaang naun.” ");
INSERT INTO stb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Sinaakan nilan giin bu' ta'i getaw neng miksugu' ri seniin sek peginat ri sek pigbeliliraan bu' pilaang giin. ");
INSERT INTO stb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma'ad su getaw neng mi'uli'an nda' mekilala bu' ta' getaw giin, ay mi'edlud ma rayun si Jesus tendeng se kelaun ne getaw ritu. ");
INSERT INTO stb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Peketubus se dlaunan keni, mi'ita' ni Jesus su getaw ritu sek templo bu' miktalu', “Penginengeg'a, mi'uli'an'a na nandaw! Lalia na pekpekesala' ali' bu' duun paing melaat gupiya neng mehitabu' seni'a.” ");
INSERT INTO stb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Midlaang rayun su getaw bu' inesuyaan su ngag Judeo ne si Jesus sung mikpetelen ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bu' tendeng run nini, su ngag Judeo migatad sek pedlutus riin ni Jesus tendeng ay mikpetelen giin se Gendaw nek Pengulali. ");
INSERT INTO stb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma'ad miktalu' si Jesus senilan, “Su Gama'u kanunay mekterbahu tampan nemuun. Bu' maa' run rema, mekterbahuu rema.” ");
INSERT INTO stb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aas, tendeng run nini, miksamet ne dliyagan gaid nu ngag Judeo nek petain giin, tendeng ay gena' na run nek sinupaken su Kesugu'an metendeng ri se Gendaw nek Pengulali, bu' ndi' miktalu' pa gaid giin ne sud Diwata gaid su gegulingenen ne Gama'. Bu' maa'entu, migulugan nini ne mbaalen su gegulingenen maa' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Aas miktalu' si Jesus senilan, “Sek pekemetuud esuyan'u amu, ne sug Bata' nda'irun gairi gembaal ri se gegulingenen, bu' ndi' su landuning mi'ita' ri seg binaal ne Gama', giin remaig baalenen; ay landunig binaal ne Gama', giin remaig baalen nug Bata'. ");
INSERT INTO stb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ay pinetail ne Gama' sug Bata'en bu' pi'ita'en ri seg Bata'en su dlaun neg binaalen; bu' mpe'ita' pa nu Gama' ri seniin su ngag betang ne dlabaw pa nek terbahu sinangkali' run nini, arun dlaunan niyu metingala gaid. ");
INSERT INTO stb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ay maa' ne Gama' neng mekpetubu' puli' tu se ngang minatay bu' megbegay senilan ne ketubu', aas maa' run rema sug Bata'en neng megbegay ne ketubu' tu se isan ta' ne dliyaganen begayan. ");
INSERT INTO stb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bu' su Gama' ndi' megukum ri se isan ta', bu' ndi', binegain su dlaun ne ketenged sek pegukum tu seg Bata'en, ");
INSERT INTO stb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","arun su dlaunen mekpesiddengeg ri seg Bata' maa' sek pekpesiddengeg nilan ri se Gama'! Su genda' pekpesiddengeg tu seg Bata', nda' remaik pekpesiddengeg riin se Gama' neng miksugu' riin seniin. ");
INSERT INTO stb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Sek pekemetuud esuyan'u amu, ne su nga getaw neng minginengeg ri se ngak talu'u bu' miktu'u seng miksugu' ri senaan, duuni ketubu' nilan ne genda'iruni gekteben. Ndi' ilan na ukuman ay mikebiyan ilan na buwat se kemetain pagaw tu se ketubu'. ");
INSERT INTO stb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Sek pekemetuud esuyan'u amu, neng matengik panahun, bu' minateng na gani', ne su ngang minatay mekerengeg sek talu' neg Bata' ned Diwata, bu' sung menginengeg sek talu'en metubu'. ");
INSERT INTO stb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ay maa' ne Gama' ne giin suk pegbuwatan ne ketubu', seng maa' run rema, binaalen sug Bata'en nek pegbuwatan ne ketubu'. ");
INSERT INTO stb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Bu' binegain tu seg Bata'en su ketenged sek pegukum, tendeng ay Bata' giin ne Getaw. ");
INSERT INTO stb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ndi' amu metingala run nini, ay mateng suk panahun ne su dlaun ne ngang minatay mekerengeg ri sek talu'en. ");
INSERT INTO stb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Bu' menggawas ilan ri se nga dlebeng nilan. Su nga gempiya sung miterbahuun, petubu'en puli' bu' metubu' se genda'iruni gekteben; bu' su ngang mekelaaten sung miterbahuun, petubu'en rema puli' bu' silutan.” ");
INSERT INTO stb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Middugang si Jesus sek pektalu', “Nda' gairi gembaal'u bu' gaku' ra. Migukumu sumala' sek tinalu' ne Gama'u ri senaan. Aas suk pegukum'u metareng, tendeng ay nda'u baalay su dliyagan'u, bu' ndi' seng miksugu' ri senaan.” ");
INSERT INTO stb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Bu' menintigusu para ri se gegulingen'u, landunik tinalu'u ndi' itu metu'uwan. ");
INSERT INTO stb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma'ad duunik sala tawan neng minintigus para senaan, bu' misuunan'u neng metuud suk pekpemetuuren ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Miksugu' amu ne ngang minsahiru tu ni Juan, bu' si Juan keni mikpemetuud metendeng ri se kemetuuran. ");
INSERT INTO stb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ma'ad nda'u pedlekina'enlan ned duuni getaw neng mekpemetuud metendeng ri senaan. Tinalu'u ngag betang keni arun meluwas amu. ");
INSERT INTO stb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan maa' nek sulu' neng midliga' bu' middelaag, bu' pidleliyag amu sek peddelaagen isan gempelek ra nek panahun.” ");
INSERT INTO stb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ma'ad duuning mikpemetuud para ri senaan ne gembagel pa kampuun sinangkali' sek pekpemetuud ni Juan. Ay su ngak terbahu neg binegay ne Gama' ri senaan arun tubusen'u, giin su ngak terbahu neng mikpemetuud bu' mikpe'ita' ne su Gama' miksugu' ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bu' su Gama' neng miksugu' ri senaan, giin tumu' sung mikpemetuud metendeng ri senaan. Nda' gaid niyu giin merengeg neng mektalu' awas me'ita' su gawi'en, ");
INSERT INTO stb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","bu' suk talu'en nda' rema niyu petinuuray, tendeng ay nda' amu pektu'u ri seniin nek sinugu'en. ");
INSERT INTO stb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Piktu'unan niyu su Kesulatan tendeng ay migena'ena' amu ned diin se Kesulatan me'angken niyui ketubu' ne genda'iruni gekteben; bu' keni ne Kesulatan migasuy metendeng ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ma'ad migbelibad amu neng meriin senaan arun duuni ketubu' niyu ne genda'iruni gekteben.” ");
INSERT INTO stb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nda'u kina'enlanay suk peksaya' ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ma'ad misuunan'u amu ne suk pekpetail ri sed Diwata nda' riin seniyu. ");
INSERT INTO stb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Miriniu duma se ketenged neg buwat riin se Gama'u, ma'ad nda' niyau duwatay. Tumu' bu' duuni getaw neng merini duma se gegulingenen ne ketenged, duwaten niyu giin. ");
INSERT INTO stb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Liyagan niyu neng mekerawat nek peksaya' buwat ri sek salasala seniyu, ma'ad nda' niyu penentuway suk peddawat nek peksaya' neg buwat ri sek sala ra ned Diwata. Pegendunen niyu sek pektu'u ri senaan? ");
INSERT INTO stb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ndi' niyu pegena'ena'ay ne gaku', sung miksumbung seniyu tu se Gama'u. Si Moses, ned diin mibetang suk pedderama niyu, giin gaid sung meksumbung seniyu. ");
INSERT INTO stb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bu' miktu'u amu gaid riin ni Moses, mektu'u amu rema siya ri senaan, tendeng ay miksulat giin metendeng ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma'ad ay nda' niyu tu'uway landunik sinulaten, pegendunen rayun niyu sek pektu'u sek tinalu'u?” ");
INSERT INTO stb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Sek pegbiyan nek santa' endaw, dinumipag puli' si Jesus sed danaw ne Galilea ne giningelanan rema ned danaw nek Tiberias. ");
INSERT INTO stb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bu' melaun gupiya getaw sung midlendug ri seniin, tendeng ay mi'ita' nilan su nga ketingelaan nek pimbaalen ri se ngang minlaru. ");
INSERT INTO stb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tinumuwad rayun si Jesus tu se gembentud bu' ritu migingkud giin duma se ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na, megaud na su kese'ulugan nek Paska ne ngag Judeo. ");
INSERT INTO stb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Seng migenleng si Jesus bu' mi'ita'en sung melaun ne nga getaw neng mikpagaw ri seniin, miktalu' giin riin ni Felipe, “Ta' ita ma mekesaluy ne gaan arun mekekaan nga getaw keni?” ( ");
INSERT INTO stb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ma'ad miktalu' giin run nini sek pegindan riin seniin, ay misuunaan na bu' landuni gembaya' baalenen.) ");
INSERT INTO stb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Miksembag si Felipe ri seniin, “Isan se dlaga' ned duwa' gatus nek selapi' nek pelata suk seluyen nek pan, ndi' pa metektub para mekekaan isan miika' su nga getaw.” ");
INSERT INTO stb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sala se ngak tinu'unanen ne si Andres, pated ni Simon Pedro, miktalu' ri seniin, ");
INSERT INTO stb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Duunig bata' ne dlai rini ned duuni dlima buuk pan nek sibada bu' duwa' buuk sera'. Ma'ad megendun ma'aray ini se kelaun ne getaw keni?” ");
INSERT INTO stb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Miktalu' si Jesus, “Ala, pe'ingkud niyu su nga getaw.” (Na ritu, duuning meliwag gupiya ne ngak sigbetan.) Aas, minggingkud ilan tu sek sigbetan—bu' binalabena' ned duuni dlima libu tawan ne dlai ma'aray. ");
INSERT INTO stb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mbuus, inuwan ni Jesus su ngak pan bu' pisalamataan nini tu sed Diwata, bu' pingaperaped ritu se nga getaw neng migingkud; maa' ra run rema sug binaalen ri sek sera' bu' minaan ilan rayun gekteb se dliyagan nilan. ");
INSERT INTO stb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na, seng mibesug ilan na, miktalu' si Jesus tu se ngak tinu'unaan, “Timud niyu su ngak sawad arun nda'iruning megula'.” ");
INSERT INTO stb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mbuus, tinimud nu ngak tinu'unaan su dlaun neng misawad. Bu' mipenu' nilan suk sepulu' bu' ruwa' neg bebaan buwat se dlima buuk pan nek sibada nek sawad nu nga getaw neng mingaan. ");
INSERT INTO stb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Rayun sek pekiita' ne nga getaw se ketingelaan neg binaalen, miktalu' ilan, “Giin na gaid ini sung metuud nek propeta nek pirateng ta neng merini seg benwa.” ");
INSERT INTO stb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mbuus si Jesus, mikesuun na neng mateng ilan bu' legesen nilan giin ne mbaal ne gari', migawa' giin ritu bu' tinumuwad puli' tu seg binenturan nek salaan ra. ");
INSERT INTO stb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na, sek pekesilemsilem na, mindiksun su ngak tinu'unaan ritu sed danaw, ");
INSERT INTO stb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","bu' minsakay sek sekayan. Merelem ra run, nda' pa gusay pedlendug si Jesus riin senilan. Aas migatad ilan na ma'aray sek peddipag puli' tu se Capernaum. ");
INSERT INTO stb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Saanay dinumipag ilan, sug baled miksibagel tendeng ay duuning mesekeg ne genus. ");
INSERT INTO stb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Seng mikemelula ilan na se dlima awas genem kilumitru, mi'ita' nilan si Jesus neng midlaang ri sed dibabaw nek tubig bu' mikpegaud ri sek sekayan, bu' minendek ilan gupiya. ");
INSERT INTO stb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bu' si Jesus miktalu' senilan, “Gaku' ini! Ndi' amu endek!” ");
INSERT INTO stb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Rayun pidleliyag ilan gaid nek pesekain giin tu sek sekayan; bu' sek sempun, suk sekayan minateng tu se dlugar nek pa'agawan nilan. ");
INSERT INTO stb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Sek sunud ne gendaw, su nga getaw neng mikpebilin tu sed dipag danaw, mi'ita' nilan nek sala ra suk sekayan ritu. Misuunan rema nilan ne si Jesus nda' peritu sek sekayan duma se ngak tinu'unanen, ma'ad su ngak tinu'unanen miksakay ne gilan ra. ");
INSERT INTO stb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sud duma ne ngak sekayan buwat sek Tiberias dinumenggu' megaud sed dapit ned ditu su nga getaw mikaan se ngak pan ne dluwat pesalamatay nu Ginu'u. ");
INSERT INTO stb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Aas seng mi'ita' nu nga getaw ne genda' na ritu si Jesus bu' su ngak tinu'unanen, sinumakay ilan tu se ngak sekayan bu' miritu se Capernaum arun penengaun si Jesus. ");
INSERT INTO stb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Seng mi'ita' na nilan si Jesus ritu sed dipag ned danaw, sinaakan nilan giin, “Rabi, nanua miperini?” ");
INSERT INTO stb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Miksembag si Jesus senilan, “Sek pekemetuud esuyan'u amu, pinengaw niyau, gena' tendeng se nga ketingelaan neng mi'ita' niyu, bu' ndi' tendeng ay pinaan'u amu ne ngak pan bu' mibesug amu. ");
INSERT INTO stb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ndi' amu pekpetuges para ri se gaan neng menles, bu' ndi' para se gaan ne gendi' menles bu' megbegay ne ketubu' ne genda'iruni gekteben. Keni nek pekaan begay seniyu seg Bata' ne Getaw, tendeng ay sud Diwata ne Gama' megbegay ri seniin ne ketenged sek pegbaal run nini.” ");
INSERT INTO stb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Aas miksaak ilan ri seniin, “Na, landun mai gembaya' baalen nami arun mbaal nami su ngak terbahu ne dliyagan ned Diwata?” ");
INSERT INTO stb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Miksembag si Jesus, “Giin nini su dliyagan ned Diwata neg baalen niyu, kina'enlan mektu'u amu tu sek sala nek sinugu'en.” ");
INSERT INTO stb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aas miktalu' ilan ri seniin, “Landun ma rayun su ketingelaan ne gempe'ita' mu senami arun mektu'u ami seni'a? Landun maig baalen mu? ");
INSERT INTO stb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Su nga gepu'an ta minaan seng mana sed ditu ilan pa se kemingawan; maa' seng misulat, ‘Binegayaan ilan nek pan buwat se dlangit arun mekekaan.’” ");
INSERT INTO stb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Miktalu' rayun si Jesus senilan, “Sek pekemetuud esuyan'u amu, ne gena' si Moses sung migbegay nek pan neg buwat ri se dlangit bu' ndi' su Gama'u neng migbegay seniyu seng metuud nek pan neg buwat se dlangit. ");
INSERT INTO stb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ay suk pan neg binegay ned Diwata giin suk sala neng migbuwat ri se dlangit bu' migbegay ne ketubu' ri se nga getaw rini seg benwa.” ");
INSERT INTO stb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Miktalu' rayun su nga getaw, “Sir, begay mu kanunay senami suk pan keni.” ");
INSERT INTO stb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Miksembag si Jesus, “Gaku' suk pan neng megbegay ne ketubu'. Sung meriin senaan ndi' na gaid mperii'an; bu' sung mektu'u senaan ndi' na gaid kinumen. ");
INSERT INTO stb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ma'ad tinalu'u ini seniyu seng mikiita' amu na ri senaan bu' nda' amu pektu'u. ");
INSERT INTO stb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Su kada sala neg binegay ne Gama' ri senaan meriin senaan. Bu' su kada sala neng miriin senaan, ndi'u ilan gaid bibain, ");
INSERT INTO stb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","tendeng ay miriniu buwat se dlangit gena' sek pegbaal se gegulingen'u ne keliyag, ma'ad sek pegbaal se keliyag ned Diwata, neng miksugu' ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na, keni su keliyag seng miksugu' ri senaan ne ndi'u dela'en su isan sala senilan neg binegain ri senaan, ma'ad petubu'en'u ilan puli' se ketapusan ne gendaw. ");
INSERT INTO stb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ay giin nini gaid su keliyag ne Gama'u, ne su dlaun neng mekiita' bu' mektu'u ri seg Bata'en mekaangken se ketubu' ne genda'iruni gekteben. Bu' petubu'en'u ilan se ketapusan ne gendaw.” ");
INSERT INTO stb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Aas migburuburu su nga getaw metendeng ri seniin, tendeng ay miktalu' giin, “Gaku' suk pan neg buwat pa se dlangit.” ");
INSERT INTO stb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bu' miktalu' ilan, “Gena' ba giin si Jesus, sug bata' ra ni Jose? Mi'ilala ta ma gani' su gama'en bu' gina'en. Lama sakan neng mitalu'en run neg buwat giin ritu se dlangit?” ");
INSERT INTO stb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Miksembag si Jesus riin senilan, “Ndi' amu pegburuburu riin se gegulingen niyu. ");
INSERT INTO stb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Su nga getaw ndi' mekeriin senaan gawas bu' su Gama' neng miksugu' ri senaan mekpeperiin senilan riin senaan; bu' petubu'en'u ilan ri se ketapusan ne gendaw. ");
INSERT INTO stb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Miksulat su ngak propeta, ‘Dlaunan nilan tinendu'an ned Diwata.’ Aas su ngang menginengeg ri se Gama' bu' miketu'un riin seniin meriin senaan. ");
INSERT INTO stb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nda' ini pekpesabut ned duuning mikiita' ri se Gama'. Giin neng migbuwat ri sed Diwata, giin ra gaid sung mikiita' ri se Gama'. ");
INSERT INTO stb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sek pekemetuud esuyan'u amu, ne giin neng miktu'u duuni ketubu'en ne genda'iruni gekteben.” ");
INSERT INTO stb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Gaku' suk pan neng migbegay ne ketubu'. ");
INSERT INTO stb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Su nga gepu'an niyu minaan neng mana sed ditu ilan pa se kemingawan, ma'ad minatay ilan gusay. ");
INSERT INTO stb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ma'ad suk pan neg buwat se dlangit mirini, arun su isan ta' neng maan run nini ndi' na matay. ");
INSERT INTO stb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Gaku' suk pan neng migbegay ne ketubu' neng mirini buwat se dlangit. Bu' aanen niyuik pan keni, metubu' amu se genda'iruni gekteben. Suk pan neg begay'u seniyu, giin su guned'u, arun su dlaun ne nga getaw metubu'.” ");
INSERT INTO stb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Migatad ilan rayun megaddat ri sek salasala senilan, “Pegendunen run se getaw keni sek pegbegay senita se guneren arun aanen?” miksaak ilan. ");
INSERT INTO stb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Aas miktalu' si Jesus senilan, “Sek pekemetuud, esuyan'u amu ne bu' ndi' amu maan se guned neg Bata' ne Getaw bu' ndi' minum ri sed dugu'en, nda'iruni ketubu' niyu ri se gegulingen niyu. ");
INSERT INTO stb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma'ad sung maan ri se guned'u bu' minum ri sed dugu'u, duuni ketubu'en ne genda'iruni gekteben, bu' petubu'en'u giin puli' se ketapusan ne gendaw. ");
INSERT INTO stb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tendeng ay su guned'u giin nini sung metuud ne gaan bu' sud dugu'u giin nini sung metuud ne ginumen. ");
INSERT INTO stb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sung maan ri se guned'u bu' minum ri sed dugu'u, mekpebilin giin ned diin senaan bu' gaku' diin seniin. ");
INSERT INTO stb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Suk tetubu' ne Gama', giining miksugu' ri senaan, bu' tetubu'u rema tendeng ri seniin. Maa' ra run rema nek pebiyan, sung maan ri senaan metubu' tendeng ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Giin nini suk pan neng mirini buwat se dlangit. Gena' ining maa' nek pan ne ginaan ne nga gepu'an niyu, ma'ad minatay ilan gusay. Sung maan runik pan keni metubu' se genda'iruni gekteben.” ");
INSERT INTO stb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tinalu'en nini saanain minendu' ritu sek pektipungan ritu se Capernaum. ");
INSERT INTO stb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aas, melaun ri se ngak tinu'unanen sung mikerengeg run nini, miktalu' ilan, “Tinendu' keni melised gupiya. Ta' maing menginengeg run nini?” ");
INSERT INTO stb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bu' seng misuunan ni Jesus ri se gegulingenen neng migburuburu su ngak tinu'unaan tendeng run nini, miktalu' giin ri senilan, “Mikepeluya ba ini ri sek pektu'u niyu ri senaan? ");
INSERT INTO stb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Lama run sakan bu' me'ita' niyu ne mperitaas puli' sug Bata' ne Getaw ritu sek pigbuwataan? ");
INSERT INTO stb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Su Gispiritu ned Diwata giin sung megbegay ne ketubu'; su ga'em ne getaw nda'ik paluun. Su ngak talu' nek tinalu'u seniyu buwat se Gispiritu ned Diwata neng megbegay ne ketubu'. ");
INSERT INTO stb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ma'ad sud duma riin seniyu genda' pektu'u ri senaan.” (Tendeng ay misuunan ni Jesus gatad pa se getaran bu' ta' su nga gendi' mektu'u riin seniin bu' sung megbudhi' ri seniin.) ");
INSERT INTO stb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Bu' middugang giin sek pektalu', “Giin nini su keterengan neng miktalu'u run riin seniyu ne nda'iruni getaw neng mekeriin senaan gawas bu' tugut ini ne Gama'.” ");
INSERT INTO stb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tendeng run nini, melaun se ngak tinu'unan ni Jesus neng migawa' bu' nda' na peddunut ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aas sinaakan ni Jesus suk sepulu' bu' ruwa' ne nga gapustulisen, “Bu' gamu, liyagan ba rema niyu neng menggawa'?” ");
INSERT INTO stb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Miksembag si Simon Pedro ri seniin, “Ginu'u, ta' ami ma pagaw? Diin seni'a su ngak talu' neng migbegay se ketubu' ne genda'i gekteben. ");
INSERT INTO stb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Bu' nemuun miktu'u ami seni'a bu' misuunan nami ne dya'a gaid sug Bala'an neg buwat sed Diwata.” ");
INSERT INTO stb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Miktalu' si Jesus tu senilan, “Pimili'u amu nek sepulu' bu' ruwa' ma'ad suk sala riin seniyu menulay.” ");
INSERT INTO stb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Na, miktuntul giin metendeng riin ni Judas neg bata' ni Simon Iscariote. Ay si Judas, isan giin suk sala sek sepulu' bu' ruwa' ne nga gapustulisen, giin sung megbudhi' ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bu' peketubus run nini, midlibed si Jesus tu se dlugar sek probinsiya ne Galilea. Liniyawaan neng medlibed ritu seg Judea tendeng ay su nga geseg ne ngag Judeo liyagan nilan nek petain giin. ");
INSERT INTO stb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na, suk panahun sek pista ne ngag Judeo, ne iningelanan nek Pista se ngak tulda, megaud na. ");
INSERT INTO stb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bu' miktalu' rayun su ngak pated ni Jesus ri seniin, “Pegawa'a rini, bu' peritua seg Judea arun me'ita' ne ngak tinu'unan mu su ngag binaal mu. ");
INSERT INTO stb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ndi' megedlud su nga getaw bu' liyagan nilan neng me'ilelaan gupiya. Ay migbaal'a ne ngag betang keni, aas pesuun mu tu se dlaunan ne nga getaw landunig binaal mu.” ");
INSERT INTO stb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Isan ngani' su ngak pateren nda' pektu'u ri seniin.) ");
INSERT INTO stb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aas miktalu' rayun si Jesus ri senilan, “Su ginsaktu nek panahun para senaan nda' pa mateng. Ma'ad isan landun panahunay run ginsaktu para ri seniyu. ");
INSERT INTO stb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ndi' amu gemetan ne nga getaw rini seg benwa, ma'ad gemetanu nilan tendeng ay tinelu'an'u ilan neng migbaal ilan neng melaat. ");
INSERT INTO stb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tuwad amu ritu sek pista. Ndi'u pa reli' tumuwad ritu sek pista keni tendeng ay su ginsaktu nek panahun nda' pa mateng para senaan.” ");
INSERT INTO stb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tinalu'en ini bu' mikpebilin rayun giin se Galilea. ");
INSERT INTO stb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Na, seng miketuwad na su ngak pateren arun tumambung sek pista, midlendug rema giin senilan ma'ad ndi'en liyagan neng mesuunan ne nga getaw ne ritu giin. ");
INSERT INTO stb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pinengaw rayun giin ne nga geseg ne ngag Judeo ritu sek pista, “Ta' nema giin?” miksaak ilan. ");
INSERT INTO stb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bu' diin sek tebenan ne nga getaw, duuning melaun ne nga getaw neng migegilemay metendeng ri seniin. Sud duma miktalu', “Mpiya giin ne getaw.” Bu' sud duma, miktalu', “Gena', ma'ad pidlimbungaan ma'arayi nga getaw.” ");
INSERT INTO stb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tumu' migegilemay na run su nga getaw sek pektalu' metendeng ri seniin tendeng ay minendek ilan ri se nga geseg ne ngag Judeo. ");
INSERT INTO stb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bu' seng minenga'tenga' na suk pista, minaik si Jesus ritu sek Templo bu' migatad giin sek pekpenendu'. ");
INSERT INTO stb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mitingala gaid rayun su nga geseg ne ngag Judeo neng miktalu', “Pigendunen dun sek peguwan sek tinawan ne nda' ma ngani' giin mekegusekila?” ");
INSERT INTO stb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Miksembag rayun si Jesus tu senilan, “Suk tinendu'u gena' se gegulingen'u nek pekpenendu', ma'ad migbuwat ri sed Diwata neng miksugu' ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Su isan ta' neng meliyag sek pegbaal se keliyag ned Diwata, mesuunaan bu' suk tinendu'u keni buwat ri sed Diwata awas gaku' ra sung miktalu' run nini. ");
INSERT INTO stb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sung miktalu' ri se gegulingenen ne keliyag minugaling ri se gegulingenen ned dengeg. Ma'ad sung minugaling sek pekpesiddengeg seng miksugu' ri seniin, metinuuren bu' gena' belusen. ");
INSERT INTO stb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Gena' ba binegay na ni Moses ri seniyu su Kesugu'an? Ma'ad nda'irun gairi isan sala ri seniyu neng miketuman run nini. Lama menengaw amu run neg higayun sek pekpatay ri senaan?” ");
INSERT INTO stb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","“Sineleran'a neng menulay!” Miktalu' su nga getaw, “Ta' ma rekaying mekpatay ri seni'a?” ");
INSERT INTO stb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Miksembag si Jesus tu senilan, “Migbaalu nek sala neg betang ne ketingelaan bu' dlaunan niyu mitingala. ");
INSERT INTO stb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Miksugu' si Moses nek tuli'en niyu su ngag bata' niyu ne dlai (isan gena' si Moses sung migatad run nini, bu' ndi', su nga gepu'an niyu,) bu' tinuli' niyu sug bata' niyu ne dlai isan pa se Gendaw nek Pengulali. ");
INSERT INTO stb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bu' sug bata' ne dlai tuli'en ri se Gendaw nek Pengulali arun ndi' melapas su Kesugu'an ni Moses, tuma ma linengetan amu ri senaan tendeng ay pi'uli'an'u suk sala getaw ri se Gendaw nek Pengulali? ");
INSERT INTO stb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ndi' amu pegukum seng mi'ita' niyu ri se getaw, bu' ndi' seng metareng nek pegukum.” ");
INSERT INTO stb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na, duuni ngak taga Jerusalem neng miktalu', “Gena' ba giin nini su getaw nek pinengaw nu nga geseg arun petain? ");
INSERT INTO stb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bu' enlengay niyu! Migasuy na giin ri se dlaun ne nga getaw. Bu' nda'iruning mitalu' nilan metendeng ri seniin! Misuunan ba sakan ne nga geseg keni ne giin sung Misiyas? ");
INSERT INTO stb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tumu' suk peddateng neng Misiyas, nda'iruning mekesuun bu' ta' giin buwat; bu' misuunan ta gaid bu' ta' migbuwati getaw keni.” ");
INSERT INTO stb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Sek pektendu' ni Jesus ritu sek Templo, pisekegaan suk talu'en, “Mi'ilelaan niyau ba bu' ta'u migbuwat? Nda'u perini se gegulingen'u ne keliyag. Metinuuren sung miksugu' ri senaan, bu' nda' niyu giin me'ilala. ");
INSERT INTO stb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ma'ad mi'ilalau giin tendeng ay gaku' migbuwat ma ri seniin, bu' giining miksugu' ri senaan.” ");
INSERT INTO stb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pinentuwan rayun nu ngad duma ne nga getaw ned daapen giin, bu' nda'irunid dinumaap ri seniin, tendeng ay nda' pa mateng suk panahunen. ");
INSERT INTO stb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ma'ad melaun pa gusay tumu' ne nga getaw neng miktu'u ri seniin, laung nilan, “Seng mateng na sung Misiyas, megbaal ba giin ne nga ketingelaan ne dlabaw pa kampuun sek pimbaal se getaw keni?” ");
INSERT INTO stb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mirengeg ne ngak Pariseo su ngak pegegilemay ne nga getaw metendeng riin ni Jesus. Aas gilan bu' su nga geseg ne ngak pari' mikpawit ne ngag bantay arun daapen si Jesus. ");
INSERT INTO stb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Miktalu' rayun si Jesus, “Gaku' meddunut seniyu se gempelek ra run nek panahun, bu' mpuli'u na rayun tu seng miksugu' ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Menengaw amu ri senaan, ma'ad ndi' niyau mbaangan tendeng ay ndi' amu mekeritu sek pa'agawan'u.” ");
INSERT INTO stb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Miksesaakay su nga geseg ne ngag Judeo, “Ta' ba giin pagaw ne ndi' ta na giin me'ita'? Meritu ba sakan giin se ngak siyudad se nga Griego ned ditu su nga getawan ta mikengel, bu' menendu' ri se nga Griego? ");
INSERT INTO stb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Miktalu' giin, ‘Menengaw amu ri senaan bu' ndi' niyau mbaangan bu' ndi' amu mekeritu sek pa'agawan'u. Landun maig be'et pesabuten run nini?’” ");
INSERT INTO stb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Se ketapusan bu' su dlabi gimpurtanti ne gendaw sek pista, migindeg si Jesus ritu bu' miktalu' neng mesekeg, “Su isan ta' ne kinumen mekpegaud ri senaan, bu' ");
INSERT INTO stb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","su isan ta' neng mektu'u ri senaan mekiinum, sumala' sek tinalu' ri se kesulatan, ‘Mektebud buwat se gena'ena'en, maa' ne ngak sapa', suk tubig neng megbegay ne ketubu'.’” ");
INSERT INTO stb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tinalu' ini ni Jesus metendeng se Gispiritu, ne su ngang mektetu'u riin ni Jesus mekerawat se Gispiritu. Ay sek panahun ketu, nda' pa mbegay su Gispiritu, tendeng ay nda' pa begayay si Jesus sek tibuuk nek pekpesiddengeg. ");
INSERT INTO stb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ritu sek tebenan ne nga getaw sud duma mikerengeg sek tinalu' ni Jesus, bu' miktalu' ilan, “Getaw keni, giin gaid suk propeta.” ");
INSERT INTO stb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Miktalu' rema sud duma, “Giin sung Misiyas.” Ma'ad sud duma miktalu', “Sung Misiyas ndi' gaid megbuwat ri se Galilea! ");
INSERT INTO stb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Miktalu' su kesulatan ne sung Misiyas megbuwat se gasal ni Gari' David, bu' me'etaw ri seg Bethlehem, su dlugar nek pekengelan ni Gari' David.” ");
INSERT INTO stb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aas duunik pekebahinbahin se nga getaw metendeng riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sud duma senilan liyagan dumaap ri seniin, ma'ad nda'iruning mikehimu sek pegbaal run nini. ");
INSERT INTO stb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Seng mipuli' su ngag bantay, miksaak su nga geseg ne ngak pari' bu' ngak Pariseo, “Lama nda' niyu giin uwitay rini?” ");
INSERT INTO stb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Miksembag su ngag bantay, “Nda'irun gairing miketalu' se isan ta' maa' ne getaw ketu!” ");
INSERT INTO stb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Isan ba gamu milimbungaan rema?” miktalu' su ngak Pariseo tu senilan. ");
INSERT INTO stb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Misuunan ba niyu ned duun baik sala ri se nga geseg awas ngak Pariseo sung miktu'u riin seniin? ");
INSERT INTO stb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nga getaw keni nda' mekesuun ri se Kesugu'an ni Moses, aas penuyuran ilan gaid ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Sala se ngak sakup ne ngak Pariseo ritu si Nicodemo, su getaw neng miritu ni Jesus nud diin. Miktalu' giin tu se ngak sementaunen, ");
INSERT INTO stb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Sumala' se Kesugu'an ta ne ndi' ita mekegukum ri senilan se ndi' pa merengegan bu' mesuunan landunig binaal nilan?” ");
INSERT INTO stb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Miksembag ilan riin ni Nicodemo, “Taga Galilea ba rema? Tu'unay mu su Kesulatan bu' mesuunan mu ne nda'irun gairik propeta neng megbuwat ri se Galilea.” ");
INSERT INTO stb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Minuli' rayun su kada sala tu seg balain, ma'ad si Jesus miritu seg Bentud se ngag Olibo. ");
INSERT INTO stb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Bu' sek pekeputi' relaagan sek sunud ne gendaw, miritu puli' giin sek Templo. Melaun gupiya ne nga getaw neng miritu seniin, bu' sek pegingkuren, minendu' giin tu senilan. ");
INSERT INTO stb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mbuus, su ngang menintulu' ri se Kesugu'an bu' su ngak Pariseo miguwit ritu ni Jesus nek sala dlibun neng misekupan neng minlai. Bu' pi'indeg nilan giin ri seng metungenga'an se dlaun ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Miktalu' ilan riin ni Jesus, “Sir, misekupan nami gaid dlibun keni sek pekpenlai. ");
INSERT INTO stb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na, ri se Kesugu'an ni Moses, miksugu' senita neg betuun su nga dlibun neng maa' nini. Aas dya'a, landun maing metalu' mu run nini?” ");
INSERT INTO stb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tumu' ginamit nilanik saak keni sek pedlaam ri seniin arun duunik pesingkalan nilan sek peksumbung ri seniin. Ma'ad middungkuk si Jesus bu' miksulat ri se dlupa' ginamit suk tendu'en. ");
INSERT INTO stb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sek sigi na nilan giin peksaakay, tinumingkag giin bu' miktalu' senilan, “Bu' ta' ri seniyu ne genda'irunik sala'en, giining meguna megbatu ri seniin.” ");
INSERT INTO stb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Bu' middungkuk giin puli' bu' miksulat ri se dlupa'. ");
INSERT INTO stb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bu' rayun, suk salasala senilan, su ngang mikerengeg run nini miksunudsunud sek pekpenggawa'. Migatad sek pekpenggawa' su ngang meketandeng tampan ne si Jesus ra run sung mibilin duma se dlibun neng mikpebilin sek pegindeg ritu. ");
INSERT INTO stb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Bu' miktingkag si Jesus bu' miktalu' ri seniin, “Eddang, ta' ilan nema? Nda'irun baing migukum seni'a?” ");
INSERT INTO stb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Bu' miksembag su dlibun, “Nda'irun, sir.” Miktalu' rayun si Jesus ri seniin. “Ndi'u mekegukum seni'a. Ala, uli'a na bu' ndi'a na mekpekesala'.” ");
INSERT INTO stb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Rayun, migasuy puli' si Jesus tu se ngak Pariseo, “Gaku' sud delaag neng megbegay ne kerelaag ri se nga getaw ri seg benwa. Suk sala nek sumunud ri senaan, ndi' gaid medlaang ri seng mereleman ma'ad duuni kerelaag ri se ketubu'en.” ");
INSERT INTO stb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Rayun sek pekerengeg run nini ne ngak Pariseo, miktalu' ilan, “Dya'a ra sung mikpemetuud ri se gegulingen mu. Suk pekpemetuud mu gena' metuud.” ");
INSERT INTO stb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Miksembag si Jesus laungen, “Isan gaku' ra sung mikpemetuud ri se gegulingen'u, suk pekpemetuud'u metuud gaid tendeng ay misuunan'u bu' ta'u migbuwat bu' ta'u pagaw. Ma'ad nda' amu mekesuun bu' ta'u migbuwat bu' ta'u pagaw. ");
INSERT INTO stb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gamu mikpengukum sumala' sek pegukum ne getaw; ndi'u megukum se isan ta'. ");
INSERT INTO stb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bu' isan pa mengukumu, suk pegukum'u metuud tendeng ay gena' ra gaku' sung megukum bu' ndi', gaku' bu' su Gama'u neng miksugu' ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Misulat ma ri se Kesugu'an niyu ne bu' duwa' tawaning mekpemetuud run, suk tinalu' nilan metuud. ");
INSERT INTO stb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Gaku' mikpemetuud metendeng ri se gegulingen'u bu' su Gama'u neng miksugu' ri senaan mikpemetuud rema metendeng ri senaan.” ");
INSERT INTO stb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Miksaak ilan rayun ri seniin, “Ta' mai Gama' mu?” Miksembag si Jesus, “Ndi' niyau me'ilala awas su Gama'u. Bu' mi'ilala niyau, me'ilala rema niyu su Gama'u.” ");
INSERT INTO stb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Inasuyeni ngak talu' keni sinegain mekpenendu' ritu rapit seg betangan ne ngak selapi' sek Templo. Bu' nda'irunid dinumaap ri seniin tendeng ay suk panahunen nda' pa mateng. ");
INSERT INTO stb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Miktalu' puli' si Jesus tu senilan, “Medlaangu, bu' penengaun niyau bu' mematay amu ri sek sala' niyu. Ndi' amu mekeritu sek pa'agawan'u.” ");
INSERT INTO stb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Miksesaakay rayun su ngag Judeo, “Meget ba giin? Giin ba sakan nini sug be'et pesabuten neng miktalu', ‘Ta'u pagaw, ndi' amu mekeritu?’” ");
INSERT INTO stb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Miktalu' si Jesus senilan, “Gamu nek taga rini seg benwa, ma'ad gaku' taga langit. Gamu nek sakup seg benwa ma'ad gaku' gena'. ");
INSERT INTO stb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Miktalu'u gaid riin seniyu neng matay amu ri se ngak sala' niyu. Ay bu' ndi' amu mektu'u ri senaan bu' ta'u, matay amu gaid bu' ndi' mpasaylu su ngak sala' niyu.” ");
INSERT INTO stb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Miksaak ilan, “Ta'a ba ne getaw?” Miksembag si Jesus senilan, “Ndi' ba inesuyan'u amu na gatad pa nud diin bu' ta'u ne getaw? ");
INSERT INTO stb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Melauning me'asuy'u bu' me'ukum metendeng ri seniyu; ma'ad suk sala neng miksugu' ri senaan metinuuren, bu' landuning mirengeg'u buwat ri seniin, asuy'u ini ri se nga getaw seg benwa.” ");
INSERT INTO stb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nda' nilan mesabut neng migasuy giin senilan metendeng riin se Gama'. ");
INSERT INTO stb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Aas miktalu' si Jesus senilan, “Se gempetaas niyu sug Bata' ne Getaw, mesuunan rayun niyu bu' ta'u. Bu' nda'iruni gembaal'u ri se gegulingen'u, ma'ad miktalu'u ne ngag betang nek pimandu' ne Gama' ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bu' suk sala neng miksugu' riin senaan diin senaan; nda' naun pesaddan ne gaku' ra, tendeng ay binaal'u kanunay sung mekepedleliyag ri seniin.” ");
INSERT INTO stb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Sek pektalu'en run se ngag betang keni, melauning miktu'u ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Aas miktalu' si Jesus tu se ngag Judeo neng miktu'u ri seniin, “Bu' mekpebilin amu ri sek tinendu'u, gamu gaid sung metuud ne ngak tinu'unan'u; ");
INSERT INTO stb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","bu' mesuunan niyu su kemetuuran, bu' kemetuuran keni, giin sung megbegay seniyu ne keguwasan.” ");
INSERT INTO stb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Miksembag ilan ri seniin, “Gesalan ami ni Abraham bu' nda' ami gaid mayan me'ulipen tu se isan ta'. Lamai gulugaan neng miktalu'a ned duuni keguwasan niyu?” ");
INSERT INTO stb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Miksembag si Jesus riin senilan, “Sek pekemetuud telu'an'u amu ne su isan ta' neng mekesala', mi'ulipen ri sek sala'. ");
INSERT INTO stb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Su gulipen nda'iruni kanunay ne dlugaren riin sek pamilya; tumu' sug bata' duuni dlugaren ritu se genda'iruni gekteben. ");
INSERT INTO stb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Aas bu' sug Bata' megbegay ri seni'a ne keguwasan, mekegawas'a gaid. ");
INSERT INTO stb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Misuunan'u ne gasal amu ni Abraham. Ma'ad, minengaw amu neg higayun sek pekpatay ri senaan, tendeng ay ndi' amu mekerawat ri se ngak pimandu'u. ");
INSERT INTO stb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Inesuyan'u amu se ngang mi'ita'u ri se Gama'u; bu' aas gamu, megbaal amu bu' landunik tinalu' ne gama' niyu riin seniyu.” ");
INSERT INTO stb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Miksembag ilan riin ni Jesus, “Si Abraham, giin su gama' nami.” Miktalu' si Jesus senilan, “Bu' gamu su ngag bata' ni Abraham, baalen niyu sug binaal ni Abraham, ");
INSERT INTO stb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ma'ad nemuun, pelenuwan niyau petayay, su getaw neng miktabal ri seniyu se kemetuuran neng mirengeg'u buwat ri sed Diwata. Gena' maa' niin sug binaal ni Abraham. ");
INSERT INTO stb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Megbaal amu gaid se ngag binaal ne gama' niyu.” Miktalu' ilan tu seniin, “Gena' ami ngag bata' ri se gawas; sala rai gama' nami ne giin sud Diwata.” ");
INSERT INTO stb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Miktalu' si Jesus tu senilan, “Bu' sud Diwata giin su Gama' niyu, petailen niyau ay gaku' buwat ritu sed Diwata bu' keniu na. Nda'u perini se gegulingen'u ne keliyag, bu' ndi' sinugu'u niin. ");
INSERT INTO stb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Tuma ma ndi' ma niyu mesabut suk tinalu'u? Tendeng ay ndi' niyu megenep sek pekpenginengeg sung minsahiu? ");
INSERT INTO stb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gamu su ngag bata' nu gama' niyu, neng Menulay, bu' liyagan niyu meksunud se nga keliyag nu gama' niyu. Mememunu' giin gatad pa se getaran. Bu' ndi' giin dumapig ri se kemetuuran, ay nda' ri seniin su kemetuuran. Seng megbalus giin, melemu ra ri seniin suk pegbalus ay betasaan ma bu' giin su gama' ne ngag balus. ");
INSERT INTO stb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ma'ad gaku', tendeng ay miktalu'u se kemetuuran, ndi' amu gaid mektu'u ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ta' ma' seniyu sung mekepemetuud neng mikesala'u? Bu' megasuyu se kemetuuran, tuma ma ndi' amu ma mektu'u ri senaan? ");
INSERT INTO stb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Su nga getaw nek sakup ned Diwata, gilan sung menginengeg ri se ngak talu' ned Diwata. Ma'ad gamu, gena' amu neng niin, aas ndi' amu menginengeg ri seniin.” ");
INSERT INTO stb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Miksembag su ngag Judeo ri seniin, “Gena' ami ba ginsaktu sek pektalu' nami ne dya'a taga Samaria bu' sineleran'a neng menulay?” ");
INSERT INTO stb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Miksembag si Jesus, “Nda'iruning menulay nek sinumeled ri senaan. Pisiddengegan'u su Gama'u, ma'ad nda' niyau pesiddengegay. ");
INSERT INTO stb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Bu' nda'u penantu sed dengeg para ri se gegulingen'u. Ma'ad duunik sala neng minantu para senaan bu' giin sung megukum. ");
INSERT INTO stb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sek pekemetuud esuyan'u amu, ne su isan ta' neng mektuman sek tinendu'u ndi' gaid matay.” ");
INSERT INTO stb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Miktalu' rayun su ngag Judeo ri seniin, “Nemuun, misuunan gaid nami nek sineleran'a neng menulay. Si Abraham minatay bu' maa' run rema su ngak propeta; ma'ad miktalu'a gusay ne su isan ta' neng mektuman ri sek tinendu' mu ndi' gaid matay. ");
INSERT INTO stb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Labaw'a pa ba se gama' nami ne si Abraham neng minatay? Labaw'a pa ba se ngak propeta neng minatay rema? Ta'a ba se gena'ena' mu?” ");
INSERT INTO stb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Miksembag si Jesus, “Bu' pesiddengegan'u su gegulingen'u, suk pekpesiddengeg ketu genda'ik paluun. Suk sala neng mekpesiddengeg ri senaan giin su Gama'u nek tinalu' mu giin sud Diwata mu. ");
INSERT INTO stb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nda' niyu giin me'ilala ma'ad mi'ilalau giin. Bu' miktalu'u ne nda'u mekilala ri seniin, mbaalu neg belusen maa' seniyu. Ma'ad mi'ilelaan'u gaid giin bu' tinuman'u suk talu'en. ");
INSERT INTO stb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Si Abraham, su gepu'an niyu pidleliyag giin neng mi'ita'en su gendaw sek peddateng'u; mi'ita'en nini bu' pidleliyag.” ");
INSERT INTO stb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Miktalu' rayun su ngag Judeo ri seniin, “Nda' pa gani' pedlima pulu' su giddad mu, mbuus mi'ita' mu na si Abraham?” ");
INSERT INTO stb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Miktalu' si Jesus senilan, “Sek pekemetuud esuyan'u amu, ne se genda' pa me'etaw si Abraham, diinu na daan.” ");
INSERT INTO stb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aas minguwan ilan ne ngag batu arun betuun giin, ma'ad si Jesus migedlud bu' migawa' tu sek Templo. ");
INSERT INTO stb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Saanay midlaang si Jesus, mi'ita'en su getaw neg buta ne gatad pa sek pegegetaun. ");
INSERT INTO stb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bu' miksaak su ngak tinu'unaan ri seniin, “Rabi, ta' maing mikesala' getaw ba keni awas su ngang megulangen neng mi'etaw giin neg buta?” ");
INSERT INTO stb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Miksembag si Jesus, “Suk pekebutaan gena' tendeng se ngak sala'en awas ngak sala' ne ngang megulangen. Mi'etaw giin neg buta arun su ga'em ned Diwata mpe'ita' ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Gita, kina'enlan terbahuun ta su ngag baalen neng miksugu' ri senaan saanay gendaw pa; mateng su gebii ne nda'irun na isan ta' neng mekegbaal. ");
INSERT INTO stb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sed diniu pa seg benwa, gaku' sud delaag para ri se nga getawan rini seg benwa.” ");
INSERT INTO stb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sek peketubusen mektalu' run nini, middula' giin ri se dlupa' bu' binasaken su dlupa' pebiyan tu sed dula'en bu' linugiren ini tu se ngang mata nug buta. ");
INSERT INTO stb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Miktalu' giin tu seg buta, “Peritua bu' pengulamus'a tu se dlinaw nek Siloam.” (Su ngalan ne Dlinaw keni migulugan nek “Sinugu'.”) Aas miritu sug buta bu' mingulamus bu' mipuli' neng mekiita' na. ");
INSERT INTO stb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mbuus su ngak sumbalain bu' su nga getaw neng mikiita' ri seniin nud diin neng mekelelimus miksaak, “Gena' ba giin nini su getaw neng mikpegingkud bu' mikpelimus?” ");
INSERT INTO stb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sud duma miktalu', “Giin ma iin.” Ma'ad sud duma miktalu', “Gena' lai, ma'ad maa' melangaylangay ma'ad ri seniin.” Bu' sung mekelilimus ketu miktalu', “Gaku' gaid su getaw.” ");
INSERT INTO stb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma'ad mikpeddayun ilan sek peksaak ri seniin, “Pikendun dun sek pekehitabu' neng mikiita'a na?” ");
INSERT INTO stb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Miksembag giin, “Su getaw ne giningelanan nilan ne Jesus, giin sung migbaal neg basak ne dlinugiren ri se ngang matau bu' miktalu' ri senaan neng merituu sek Siloam bu' mengulamus. Mirituu rayun bu' mingulamus bu' mikiita'u na.” ");
INSERT INTO stb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Miksaak ilan ri seniin, “Ta' nema su getaw?” Miksembag giin, “Ta' run.” ");
INSERT INTO stb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Inuwit nilan tu se ngak Pariseo su getaw buta nud diin. ");
INSERT INTO stb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na, sek pekehitabu' ketu, Gendaw itu nek Pengulali sek pegbaal ni Jesus ri seg basak bu' sek pekpetelen ri seg buta. ");
INSERT INTO stb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Miksaak rema rayun puli' su ngak Pariseo tu se getaw metendeng run nini. Aas miktalu' giin tu senilan, “Linugiraan neg basak su ngang matau. Rayun inulemusan'u, bu' mikiita'u na.” ");
INSERT INTO stb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Duma ne ngak Pariseo miktalu', “Su getaw neng migbaal run nini gena' buwat ri sed Diwata, tendeng ay genda' giin pektuman ri se kesugu'an metendeng se Gendaw nek Pengulali.” Ma'ad sud duma ne ngak Pariseo miktalu', “Pegendunen run se getaw neng mekesesala' sek pegbaal ri se nga ketingelaan keni?” Bu' mibahinbahin ilan. ");
INSERT INTO stb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Rayun, miksaak ilan puli' tu se getaw neg buta nud diin, “Lama run maing metalu' mu metendeng ri seniin tendeng ay pitelenen ma su ngang mata mu?” Miksembag giin, “Propeta giin.” ");
INSERT INTO stb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Su ngag Judeo ndi' meketu'u neg buta giin nud diin, bu' numuun mekiita' na, tampan pitawag nilan su ngang megulangen. ");
INSERT INTO stb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bu' sinaakan nilan su ngang megulangen, “Bata' ba niyu ini, nek tinalu' niyu neng migegetaw giin neg buta? Pigendunen dun sek pekiita' nandaw?” ");
INSERT INTO stb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Miksembag su ngang megulangen, “Misuunan nami ne giin sug bata' nami, bu' migegetaw giin neg buta na daan; ");
INSERT INTO stb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ma'ad nemuun nda' nami mesuunay bu' pigendunen dun sek pekiita' awas nda' rema nami mesuunay bu' ta' sung mikpetelen run se ngang mataan. Saakay niyu giin ay metandeng na giin. Mekesembag na giin metendeng ri se gegulingenen.” ");
INSERT INTO stb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Giin ituik sinembag ne ngang megulangen tendeng ay minendek ilan se ngag Judeo; ay su ngag Judeo miguyun na ne su isan ta' neng megangken ne si Jesus Misiyas, pepe'uwa'en riin sek pektipungan. ");
INSERT INTO stb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Giin nini su keterengan neng miktalu' su ngang megulangen, “Metandeng na giin; saakay niyu giin.” ");
INSERT INTO stb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aas tinawag nilan puli' se keruwa' neg higayun su getaw neg buta nud diin, bu' miktalu' ilan ri seniin, “Saad mu riin seng metungenga'an ned Diwata suk pektalu' seng metuud. Misuunan nami ne su getaw nek tinalu' mu neng mikpetelen seni'a mekesesala'.” ");
INSERT INTO stb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Miksembag su getaw, “Nda'u mesuunay neng mekesesala' ba giin. Basta misuunan'u neg butau nud diin, nandaw mekiita'u na.” ");
INSERT INTO stb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Miksaak ilan puli', “Lamaig binaalen seni'a? Pigendun'aan dun sek pekpetelen seng mata mu?” ");
INSERT INTO stb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Miksembag giin, “Tinalu'u na seniyu bu' ndi' amu menginengeg. Tuma ma liyagan ma niyu neng merengeg puli'? Liyagan ba rema niyu ne mbaal ne ngak tinu'unaan?” ");
INSERT INTO stb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tinampela' rayun nilan giin neng miktalu', “Dya'a suk tinu'unaan ma'ad gami ngak tinu'unan ni Moses. ");
INSERT INTO stb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Misuunan nami ne sud Diwata migasuy tu ni Moses nud diin, ma'ad metendeng se getaw ketu, nda' nami mesuunay bu' ta' giin migbuwat.” ");
INSERT INTO stb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Miksembag su getaw, “Ketingalaanig betang keni. Nda' niyu mesuunay bu' ta' giin migbuwat, bu' tumu' pi'uli'aan sung matau. ");
INSERT INTO stb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Misuunan ta ne sud Diwata ndi' menginengeg tu se ngang mekesesala', ma'ad penginengegaan suk sala neng miktamed ri seniin bu' miktuman sek sinugu'en riin senilan. ");
INSERT INTO stb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nda' gaid mayan gatad pa se getaran seg benwa neng mirengeg ned duunik sala neng mikpetelen ri seng mata se getaw neng mibuta gatad pa sek pegegetaun. ");
INSERT INTO stb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bu' getaw keni gena' pa buwat tu sed Diwata, nda'iruni gembaalen isan landun.” ");
INSERT INTO stb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Miksembag ilan tu seniin, “Mi'etaw'a ri se ngak sala' bu' menendu'a riin senami?” Bu' pi'awa' nilan giin tu sek pektiguman. ");
INSERT INTO stb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mirengeg ni Jesus nek pi'awa' nilan giin tu sek pektiguman. Bu' seng mi'ita' giin ni Jesus, miktalu' giin, “Miktu'ua ba ri seg Bata' ne Getaw?” ");
INSERT INTO stb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Miksembag giin, “Ta' getaw giin, sir, arun meketu'uu ri seniin?” ");
INSERT INTO stb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Miktalu' si Jesus tu seniin, “Mi'ita' mu na giin, bu' giin sung mikpegisturya ri seni'a nandaw.” ");
INSERT INTO stb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Miktalu' rayun su getaw, “Ginu'u, miktu'uu seni'a!” Bu' middempug giin sek peksimba ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Miktalu' si Jesus, “Miriniu seg benwa arun mengukum arun su ngag buta mekiita' bu' su ngang mekiita' mbaal neg buta.” ");
INSERT INTO stb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Santa' tawan ne ngak Pariseo ned ditu neng midduut ri seniin mikerengeg sek pektalu'en run nini, bu' miksaak tu seniin, “Buta ami ba rekay rema?” ");
INSERT INTO stb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Sinembag ilan ni Jesus, “Bu' buta amu pa, migulugan ini ne nda' amu mekesala'; ma'ad nemuun inangken niyu neng mekiita' amu, migulugan ini neng mekpebilin suk sala' niyu.” ");
INSERT INTO stb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Miktalu' si Jesus, “Sek pekemetuud esuyan'u amu, isan ta' nek sumeled ri sek padir nek turil para se nga karniru ne gendi' mayan ri seg biyanan ma'ad menaik ri se dlain neg biyanan meddaaw bu' tulisan giin. ");
INSERT INTO stb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma'ad suk sala nek sumeled neng mayan ri seg biyanan, giin nini sung menggegingat ri se nga karniru. ");
INSERT INTO stb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Peseleren giin nug bantay ri seg biyanan bu' su nga karniru menginengeg ri sek talu'en. Tuwagenen su nga karniruun ri se nga ngalan nilan bu' meguna giin senilan ri sek pegawas. ");
INSERT INTO stb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Seng me'uwiten na gumawas su dlaun ne nga karniruun, meguna giin ri senilan, bu' su nga karniru medlendug ri seniin tendeng ay me'ilala nilan suk talu'en. ");
INSERT INTO stb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma'ad ri se dlain ne getaw, ndi' ilan gaid medlendug; tumu' menggebek ilan pelayu' buwat seniin tendeng ay nda' nilan me'ilala suk talu' ne dlain ne getaw.” ");
INSERT INTO stb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Inasuy senilan ni Jesus su galing keni. Ma'ad nda' gaid nilan mesabut su gulugaan nini. ");
INSERT INTO stb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Na, miktalu' puli' si Jesus ritu senilan, “Sek pekemetuud esuyan'u amu, ne Gaku' sug biyanan se nga karniru. ");
INSERT INTO stb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Su dlaun neng minateng se nda'u pa mateng ngang meddaaw bu' ngak tulisan, bu' su nga karniru ndi' menginengeg se isan ta' senilan. ");
INSERT INTO stb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Gaku' sug biyanan. Pebiyan ri senaan, su dlaun nek sumeled meluwas; mekeseled bu' mekegawas ilan bu' mekepenengaw seng melengas nek pengeksaban. ");
INSERT INTO stb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ay sung meddaaw mirini sek peddaaw, sek pekpatay, bu' sek pedlaat. Miriniu arun su nga getaw mbegayan se ketubu'—ketubu' se genda'i gekteben ne kelengas.” ");
INSERT INTO stb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Gaku' su gempiya neng menggegingat ne andam meksipatay para se nga karniru. ");
INSERT INTO stb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Suk sinu'ulan gena' giin sung metuud neng menggegingat bu' gena' rema giin su gapu' ne nga karniru. Seng me'ita'en sung menanap neng mendapa' neng mateng, belengenen su nga karniru bu' gumebek giin pelayu'. Bu' sung mendapa' neng menanap depa'enen bu' petipelakenen su ngad duma ne karniru. ");
INSERT INTO stb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Suk sinu'ulan gumebek pelayu' tendeng ay sinu'ulan na run giin bu' nda'ik pembaalan run se nga karniru. ");
INSERT INTO stb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Gaku' su gempiya neng menggegingat ne nga karniru. Mi'ilalau su nga karniruu bu' su nga karniruu mikilala rema ri senaan, ");
INSERT INTO stb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","maa' run rema su Gama' neng mikilala ri senaan bu' Gaku' mikilala rema ri seniin. Aas andamu meksipatay para ri se nga karniruu. ");
INSERT INTO stb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Duun paid duma ne nga karniru neng misakup ri senaan ne genda' ri sek turil keni. Kina'enlan uwiten'u ilan rema rini bu' menginengeg ilan ri sek talu'u bu' mbaal ilan nek sala panen duma ri sek salabuuk neng menggegingat.” ");
INSERT INTO stb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Pinetailu ne Gama' tendeng ay keliyag'u suk pegbegay se ketubu'u arun me'uwan'u ini puli'. ");
INSERT INTO stb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nda'iruning mekehimu sek pekpatay ri senaan. Ma'ad begay'u su ketubu'u duma se gegulingen'u ne keliyag. Duuni ketenged'u sek pegbegay se ketubu'u bu' sek peguwan run nini. Giin nini suk sugu' neng mirawat'u buwat se Gama'u.” ");
INSERT INTO stb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mibahinbahin su nga getaw Judeo tendeng se ngak talu' ni Jesus ketu. ");
INSERT INTO stb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Melaun senilan neng miktalu', “Getaw keni sineleran neng menulay bu' mibu'ang giin. Tuma ma menginengeg amu ma ri seniin?” ");
INSERT INTO stb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sud duma miktalu', “Gena' ini su ngak talu' ne getaw nek sineleran neng menulay. Mekepetelen ba sung menulay ri seng mata nek sala getaw neg buta?” ");
INSERT INTO stb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Rayun, minateng suk panahun nek pista sek peddidikar sek Templo seg Jerusalem. Penteddaw itu, ");
INSERT INTO stb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","bu' midlaanglaang si Jesus ritu sek Templo ne giningelanan neg Balkun nek Penilungan ni Solomon ");
INSERT INTO stb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Miktipung rayun pelibut ri seniin su ngag Judeo bu' miksaak ilan, “Nanu mu ami pa telu'ay se kelaru? Telu'ay mu ami bu' dya'a ba gaid sung Misiyas.” ");
INSERT INTO stb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Miksembag si Jesus senilan, “Inesuyan'u amu na, bu' nda' amu pektu'u. Su ngak terbahu nek pimbaal'u ri se ngalan ne Gama'u, giin nini sung mikpemetuud ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ma'ad ndi' amu mektu'u tendeng ay gena' amu nga karniruu. ");
INSERT INTO stb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Su nga karniruu menginengeg ri sek talu'u. Mi'ilalau ilan bu' sumunud ilan ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Binegayan'u ilan ne ketubu' se genda'iruni gekteben, bu' ndi' ilan na gaid mbalag se genda'i gekteben. Nda'iruning mekesaklaw senilan buwat senaan. ");
INSERT INTO stb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Landunig binegay ne Gama' ri senaan giin su dlabaw ri se dlaunan. Nda'iruning mekesaklaw run nini buwat ri sek pegingat ne Gama'. ");
INSERT INTO stb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Su Gama' bu' Gaku' sala ra.” ");
INSERT INTO stb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Sek pekerengeg run itu ne ngag Judeo, mingimud ilan puli' ne ngag batu arun betuun giin. ");
INSERT INTO stb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Miksembag si Jesus tu senilan, “Mikpe'ita'u seniyu neng melaun ne gempiya nek terbahu neg buwat se Gama'. Ta' ma se ngag binaal'u keni su getaran neg betuun niyau?” ");
INSERT INTO stb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Sinembag giin ne ngag Judeo, “Ndi' ami megbatu seni'a tendeng se nga gempiya nek terbahu mu, ma'ad sek pekpesipala mu, tendeng ay dya'a, getaw'a ra, ma'ad binaal mu su gegulingen mu ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Miksembag si Jesus tu senilan, “Misulat ini ri se Kesugu'an niyu neng miktalu' sud Diwata: ‘Ngad diwata amu.’ ");
INSERT INTO stb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Bu' tinawag ned Diwata ne ngad diwata gilan neg binegayan ned Diwata seng minsahiin, bu' su Kesulatan ndi' gaid me'eseb, ");
INSERT INTO stb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","tuma ma mektalu' amu ma ne gaku', nek pinili' ne Gama' bu' sinugu' rini seg benwa, mikpesipala tu sed Diwata sek pektalu'u ne gaku' Bata' ned Diwata? ");
INSERT INTO stb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bu' nda'u baalay suk pibaal nu Gama' ri senaan, ndi' amu mektu'u ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ma'ad bu' baalen'u ini, isan ndi' amu mektu'u ri senaan, mbaya' niyu tu'uwan su ngak pimbaal'u, arun mesuunan niyu ne su Gama' diin senaan bu' Gaku' diin seniin.” ");
INSERT INTO stb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mbuus sinulayan siya nilan daapay giin puli', ma'ad mikedlaguy giin buwat senilan. ");
INSERT INTO stb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Bu' dinumipag puli' si Jesus tu se Gembagel Tubig neg Jordan tu se dlugar nek pigbendyagan ni Juan nud diin, bu' mikengel giin ritu. ");
INSERT INTO stb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Melaun ne nga getawing miritu seniin bu' miktalu' ilan, “Si Juan nda' pegbaal ne ketingelaan, ma'ad su dlaun nek tinalu'en metendeng ri se getaw keni metuud.” ");
INSERT INTO stb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bu' melauni ngang miktu'u ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Na, duunik sala tawan neng midlaru ne su ngalanen si Lazaro. Mikengel giin tu seg Betania. Bu' su ngak pateren ne si Maria bu' si Marta mikengel rema ritu. ");
INSERT INTO stb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Bu' si Maria keni, giin su dlibun neng migbunag nek pegemut ri se nga geksud ne Ginu'u nek pinunasaan rema neg buuken. Tendeng ay suk pated nilan ne si Lazaro midlaru, ");
INSERT INTO stb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","aas pisuun nilan nini ri ni Jesus. Laung nilan, “Ginu'u, suk pinetail mu midlaru.” ");
INSERT INTO stb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sek pekerengeg run nini ni Jesus, miktalu' giin, “Ndi' giin matay run seng megeel keni. Mihitabu' ini arun mpesiddengegan sud Diwata bu' pebiyan run nini, mpesiddengegan sug Bata' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na, pinetail ni Jesus sung mekpated ketu ne si Marta, si Maria, bu' si Lazaro. ");
INSERT INTO stb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ma'ad seng misuunan ni Jesus ne si Lazaro midlaru, migelat pa giin ned duwa' endaw ritu se dlugar nek pikengelaan. ");
INSERT INTO stb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mbuus, miktalu' giin tu se ngak tinu'unaan, “Mpuli' ita na pelun tu seg Judea.” ");
INSERT INTO stb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Miktalu' su ngak tinu'unaan ri seniin, “Rabi, gena' ba santa' endaw pa neg betuun'a siya ritu ne ngag Judeo? Bu' liyagan mu ba ne mpuli' pelun ritu?” ");
INSERT INTO stb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Miksembag si Jesus tu senilan pebiyan ri se galing, “Ndi' ba duunik sepulu' bu' ruwa' guras sek sendaw? Aas su getaw neng medlaang se gendaw ndi' meterukpa' ay me'ita'en ma su kerelaag rini seg benwa. ");
INSERT INTO stb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma'ad bu' isan ta' neng medlaang se gebii, meterukpa' giin, ay nda'irun ma kerelaagen.” ");
INSERT INTO stb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Dluwat ini, miktalu' pa gaid si Jesus tu senilan, “Suk sambat ta ne si Lazaro miktulug. Ma'ad lawan'u giin arun tenuren.” ");
INSERT INTO stb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Miksembag su ngak tinu'unaan, “Ginu'u, bu' miktulug giin, me'uli'an pa giin.” ");
INSERT INTO stb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Su gulugan sek tinalu' ni Jesus neng minatay na si Lazaro ma'ad laung run nu ngak tinu'unaan miktulug na run si Lazaro. ");
INSERT INTO stb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Aas inesuyan ilan ni Jesus se kelaru: “Minatay na si Lazaro. ");
INSERT INTO stb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma'ad pidleliyagu,” miktalu' si Jesus, “ne nda'u ritu. Para ini ri se kelengasan niyu arun mektu'u amu. Ala, meritu ita seniin.” ");
INSERT INTO stb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Aas si Tomas, ne giningelanan rema ne Gapid, miktalu' tu se ngak sementaunen, “Meddunut ita isan bu' matay ita tendeng sek peksunud ri seniin.” ");
INSERT INTO stb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sek peddateng ni Jesus seg Betania, mirengegaan ne gepaat endaw na linebeng si Lazaro. ");
INSERT INTO stb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na, sug Betania megaud ri seg Jerusalem, mektelu kilumitru ra. ");
INSERT INTO stb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bu' melaun ne ngag Judeo neng miritu arun sek pedduma ri se kegu'ul ni Marta bu' ni Maria tendeng ay minatay suk pated nilan. ");
INSERT INTO stb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Sek pekerengeg ni Marta neng megaud na mateng si Jesus, ginumawas giin arun sek peksungkak ri seniin, ma'ad si Maria mikpebilin tu seg balay. ");
INSERT INTO stb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Sek pegita' ni Marta bu' ni Jesus, miktalu' giin, “Ginu'u, bu' dinia pa, ndi' siya matay suk pated'u. ");
INSERT INTO stb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma'ad misuunan'u ne isan nandaw megbegay sud Diwata seni'a isan landun nek penengiin mu ri seniin.” ");
INSERT INTO stb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Miktalu' si Jesus ri seniin, “Metubu' puli' suk pated mu.” ");
INSERT INTO stb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Miksembag si Marta, “Misuunan'u neng metubu' giin puli' sek peketubu' puli' ri se ketapusan ne gendaw.” ");
INSERT INTO stb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Miktalu' si Jesus seniin, “Gaku' sung mekpetubu' puli' ri se ngang minatay, bu' gaku' su getaran ri se ketubu'. Isan ta' sung mektu'u ri senaan, isan matay pa giin, metubu' puli'. ");
INSERT INTO stb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Bu' su dlaun neng medleketubu' bu' miktu'u ri senaan ndi' matay. Miktu'ua ba run nini?” ");
INSERT INTO stb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Wa'a, Ginu'u,” miksembag si Marta, “Miktu'uu gaid ne dya'a sung Misiyas, sug Bata' ned Diwata, suk pirateng nami neng mateng rini seg benwa.” ");
INSERT INTO stb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Dluwat ini telu'ay ni Marta, mipuli' giin tu seg balay nilan bu' tinawagen suk pateren ne si Maria bu' inilemaan giin, “Keni na sung Menintulu' bu' pinengaw'a niin.” ");
INSERT INTO stb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sek pekerengeg run itu ni Maria, migindeg giin bu' miksempun gumawas arun sek peksungkak ri ni Jesus. ( ");
INSERT INTO stb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Nda' pa mekeseled si Jesus se dlunsud seg Betania. Ditu pa giin sed dapit nek sinungkakan ni Marta ri seniin.) ");
INSERT INTO stb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sek pekiita' ne ngag Judeo neng midduma ri se kegu'ul ni Maria tu seg balay, neng miksempun megindeg bu' ginumawas, sinunud nilan giin. Ay laung nilan run neng meritu giin se dlinebengan nek pateren arun meksegaw ritu. ");
INSERT INTO stb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Miritu si Maria sed dapit ned ditu si Jesus. Sek pekiita'en riin ni Jesus, middempug giin ri se geksud ni Jesus neng miktalu', “Ginu'u, bu' rinia pa, ndi' siya matay suk pated'u.” ");
INSERT INTO stb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sek pekiita'en run neng miksegaw si Maria bu' asta na su ngak sementaunen ne ngag Judeo, binatiken gupiya su keliseran nilan bu' migu'ul gupiya giin. ");
INSERT INTO stb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Miksaak rayun giin senilan, “Ta' ma niyu giin linebeng?” Miksembag ilan, “Rinia Ginu'u, arun me'ita' mu.” ");
INSERT INTO stb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Aas miksegaw rayun si Jesus. ");
INSERT INTO stb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Aas miktalu' su ngag Judeo, “Mi'ita' niyu bu' gendun kebagel suk pekpetailen riin ni Lazaro!” ");
INSERT INTO stb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma'ad sud duma miktalu', “Gena' ba pitelenen su ngang mata ne ngag buta? Na, lama nda'en me'ebengay run si Lazaro arun ndi' matay?” ");
INSERT INTO stb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mibatik na pelun ni Jesus su keliseran nilan saanay mikpagaw giin tu se dlebeng. Su dlinebengan run nini sala buuk ne dlangeb nek tinempengan sug bengawaan neg batu. ");
INSERT INTO stb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Peddateng nilan ritu, miktalu' si Jesus, “Awa' niyuig batu kiin.” Ma'ad miktalu' si Marta suk pated neng minatay, “Ginu'u, mineru' na giin numuun, ay gepaat endaw na ne dlinebeng giin!” ");
INSERT INTO stb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Miktalu' si Jesus ri seniin, “Gena' ba neng miktalu'u seni'a ne bu' miktu'ua, me'ita' mu su kesanag ned Diwata?” ");
INSERT INTO stb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aas inawa' nilan sug batu nek tinampeng ri se dlebeng. Migangag rayun si Jesus bu' miktalu', “Gama', mikpesalamatu seni'a tendeng ay pinginengegan mau. ");
INSERT INTO stb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Misuunan'u ne kenunay'a minginengeg ri senaan, ma'ad inasuy'u ini para se nga getaw keni nandaw neng midlibut ri senaan, arun mektu'u ilan ne dya'a sung miksugu' ri senaan.” ");
INSERT INTO stb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Dluwaten nini telu'ay, migbeksay giin, “Lazaro, gawas'a riin!” ");
INSERT INTO stb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Bu' ginumawas rayun sung minatay ne su gemegen bu' geksuren miputus pa nek penepeten, bu' sung mulu'en miputus rema nek penepeten. Miktalu' rayun si Jesus senilan, “Ugbaray niyu giin arun mekedlaang.” ");
INSERT INTO stb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Melaun ne ngag Judeo, neng migbentaw ri ni Maria bu' mikiita' seg binaal ni Jesus, miktu'u ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma'ad sud duma senilan miritu se ngak Pariseo bu' miktabal ri seg binaal ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aas su ngak Pariseo bu' su nga geseg ne ngak pari' miktawag nek pektipung se dlaun nek sakup ri se Dlabaw ne Gukuman. Bu' miktalu' ilan, “Landun maig baalen ta? Melaun ne nga ketingelaan neng mibaal ne getaw keni. ");
INSERT INTO stb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bu' peseddanen ta na ma'aray giin,” miktalu' ilan, “Su dlaun ne nga getaw mektu'u ri seniin. Bu' mateng su nga geseg nek taga Roma bu' geba'en nilan suk Templo ta bu' suk tibuuk neng nasud ta.” ");
INSERT INTO stb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma'ad suk sala nek sementaun nilan ne si Caipas ne Dlabi Geseg nek Pari' sek taun ketu, miktalu', “Nda'irun gairing misuunan niyu! ");
INSERT INTO stb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nda' amu ba mekegena'ena' ne mpiya kampuun nek sala tawan raing matay lungkan sek tibuuk nasud sung megeba'?” ");
INSERT INTO stb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tinalu' ni Caipas ini gena' buwat ri se gegulingenen nek pengena'ena' tendeng ay giin su Dlabi Geseg nek Pari' ri sek taun ketu. Inatuken ne kina'enlan neng matay si Jesus gisip teles para se nga getaw Judeo. ");
INSERT INTO stb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Bu' gena' na run para se nga getaw Judeo, bu' ndi' para rema se dlaun neg bata' ned Diwata neng mibelagbelag ri sed duma ne dlugar arun metipung bu' mesalabuuk ilan. ");
INSERT INTO stb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gatad rayun se gendaw ketu, mikpelanu su geseg ne ngag Judeo sek pekpatay riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Aas nda' na giin pedlaang ritu seg Judea. Ma'ad miritu giin se dlugar megaud se kemingawan, sek sala ne dlunsud ne giningelanan neg Efraim, ne ritu mikengel giin duma su ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nandaw, megaud na su kese'ulugan ne ngag Judeo, ne giningelanan ne kese'ulugan sek Paska. Aas melaun ne nga getaw neng miritu seg Jerusalem neg buwat ri se dlain ne nga dlunsud arun se gendi' pa mateng su kese'ulugan, mekepenlimpiyu ilan pa ri se gegulingen nilan sumala' seng mibetasan nilan. ");
INSERT INTO stb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Aas pinengaw nilan si Jesus bu' saanay mingindeg ilan ritu sek Templo, miksesaakay ilan, “Landun ma ri se gena'ena' niyu? Tumambung ba sakan giin ri se kese'ulugan?” ");
INSERT INTO stb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sek panahun ketu, miksugu' na daan su nga geseg ne ngak pari' bu' ngak Pariseo tu se nga getaw ne isan ta' neng mekesuun bu' ta' si Jesus, kina'enlan megasuy senilan arun meraap nilan giin. ");
INSERT INTO stb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Se genem endaw ra run dekag mateng su kese'ulugan sek Paska, miritu si Jesus seg Betania, se dlugar ni Lazaro nek pitubu'en puli' buwat se kemetain. ");
INSERT INTO stb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Rayun mingandam ilan ritu nek penihapun para riin ni Jesus. Si Marta giining migilak. Si Lazaro sala seng minaan duma ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mbuus si Maria minuwan nek tenga' litru nek pegemut iningelanan neng nardo. Keni nek pegemut melaga' gupiya bu' genda'i dlemugen. Binunag ini ni Maria ri se geksud ni Jesus. Peketubus pinunasaan seg buuken bu' milaup sug balay se keemut nek pegemut ketu. ");
INSERT INTO stb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bu' si Judas Iscariote, sala se ngak tinu'unan ni Jesus sung medlu'ib ri seniin, miktalu', ");
INSERT INTO stb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Tuma ma nda' tumu' beledya' suk pegemut keni sek telu gatus nek pelata arun su galinen pembegay tu se ngak pupus?” ");
INSERT INTO stb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ma'ad inasuyen ini gena' tendeng ay milelaat giin riin se ngak pupus, bu' ndi', tendeng ay meddaaw giin. Giining migawid run sek pengimetangan nek selapi' nilan bu' kanunay menguwan giin. ");
INSERT INTO stb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Aas miktalu' si Jesus, “Pesaddan mu giin! Tineganaan ini para se gendaw sek pedlebeng ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ay su ngak pupus kanunay riin seniyu, ma'ad gena'u kanunay medduut ri seniyu.” ");
INSERT INTO stb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Melaun ne ngag Judeo mikesuun ned ditu si Jesus seg Betania. Aas minditu ilan gena' na run tendeng riin ni Jesus, bu' ndi' liyagan rema nilan me'ita' si Lazaro nek pitubu' puli' ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Aas pinelanu ne nga geseg ne ngak pari' nek petain nilan rema si Lazaro ");
INSERT INTO stb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tendeng ri seniin melaun se ngag Judeo ne nda' na pektu'u senilan bu' miktu'u riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sek sunud gendaw, mirengegan seng melaun ne nga getaw nek tinumambung se kese'ulugan sek Paska, ne si Jesus mikpagaw na tu seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Aas minguwan ilan ne ngak paka nek tepisa, bu' minggawas arun sek peksungkak ri seniin bu' mimbeksay, “Siya'en ta sud Diwata! Pengumpiyanan ned Diwata giin neng mirini ri se ngalan ne Ginu'u! Pengumpiyanan ned Diwata su Gari' seg Israel.” ");
INSERT INTO stb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mikiita' si Jesus nek salabuuk neng nati ne gasnu bu' sinekayaan ini, sumala' sek tinalu' se kesulatan, ");
INSERT INTO stb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ndi' amu endek, nga getaw sek Zion! Enlengay niyu, minateng su Gari' niyu neng meksakay ri seng nati ne gasnu.” ");
INSERT INTO stb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Su ngak tinu'unan ni Jesus nda' pa mekesabut run nini sek panahun ketu. Ma'ad seng mipuli' na si Jesus tu se dlangit, mi'ena'ena' nilan ne su kesulatan miksambay run nini metendeng ri seniin bu' binaal ini para ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ay su nga getaw, ned duma ni Jesus sek pigawasen si Lazaro buwat se dlebeng bu' pitubu' puli' buwat se kemetain, sung mikpesuun seng mihitabu'. ");
INSERT INTO stb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Aas tinumagbu' riin ni Jesus su nga getaw tendeng ay mirengeg nilan su ketingelaan neg binaalen. ");
INSERT INTO stb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Aas miktuntulay su dlaun ne ngak Pariseo, “Mi'ita' na niyu. Nda'irun na gairing mihimu ta. Enlengay niyu, su dlaun ne nga getaw middunut na ri seniin.” ");
INSERT INTO stb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na duuni nga Griego nek tinumuwad tu seg Jerusalem arun sumimba sek panahun se kese'ulugan. ");
INSERT INTO stb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Miritu ilan ni Felipe. (Keni si Felipe taga Betsaida nek sakup sek probinsiya se Galilea.) Miktalu' su nga Griego ri seniin, “Sir, liyagan siya nami kumita' riin ni Jesus.” ");
INSERT INTO stb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Midlaang si Felipe bu' inesuyaan si Andres, bu' gilan duwa' sung miritu ni Jesus arun esuyan giin. ");
INSERT INTO stb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Miktalu' rayun si Jesus senilan, “Nandaw minateng naik panahun ne mpesiddengegan gupiya sug Bata' ne Getaw. ");
INSERT INTO stb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Esuyan'u amu ri seng metuud: suk sala dlegas nek trigu mekpebilin nek sala dlegas ra gaid gawas bu' metena' ini se dlupa' bu' matay. Bu' matay ini, mekepemunga ini neng melaun. ");
INSERT INTO stb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Su getaw neng mekpetail ri se ketubu'en, merela'an run nini; ma'ad su getaw ne genda' pekpetail ri se ketubu'en rini seg benwa, mekaangken tumu' se ketubu' ne genda'iruni gekteben. ");
INSERT INTO stb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Isan ta' sung mekpenibeli ri senaan, kina'enlan medduut ri senaan. Bu' isan ta'u, ditu rema suk sesugu'en'u. Isan ta' neng mekpenibeli ri senaan, mpesiddengegan giin ne Gama'u.” ");
INSERT INTO stb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Miktalu' pa gaid si Jesus, “Nandaw midlibegu. Bu' landun baing metalu'u? Metalu'u ba se Gama'u ne ndi' naun pe'entusen sek panahun keni? Ma'ad giin nini su ketuyu'an sek peddiniu arun megantus sek panahun keni. ");
INSERT INTO stb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Gama', pesiddengegay mu su ngalan mu.” Bu' rayun duunik talu' neng migbuwat se dlangit, “Mpesiddengegan'u na su ngalan'u bu' pesiddengegan'u ini puli'.” ");
INSERT INTO stb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Su nga getaw neng minambung ritu mikerengeg sek talu' ketu. Miktalu' ilan, “Uy, dlugung ma itu.” Ma'ad sud duma miktalu', “Anghel itu sung miktuntul ri seniin.” ");
INSERT INTO stb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Miksembag si Jesus, “Talu' keni pirengeg gena' para senaan bu' ndi' para seniyu. ");
INSERT INTO stb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Na, minateng na suk panahun ne su nga getaw ri seg benwa ukuman; na, minateng na suk panahun ne sung midlegeseg ri seg benwa daagen na. ");
INSERT INTO stb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bu' gaku', bu' petubu'enu na puli' buwat seg benwa, pepegauren'u su dlaun ne nga getaw ri senaan.” ( ");
INSERT INTO stb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sek pegasuyen run nitu, tinalu'en laa kelesiay run sung niin ne kemetain.) ");
INSERT INTO stb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Miksembag rayun su nga getaw, “Su Kesugu'an ta miktalu' ne ndi' matay sung Misiyas, aas tuma ma mektalu'a ma ne sug Bata' ne Getaw kina'enlan lensangen tu se krus? Ta' ma rekay sug Bata' ne Getaw?” ");
INSERT INTO stb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Miksembag si Jesus, “Su kerelaag riin seniyu se gempelek nek panahun. Dlaang amu saanay riin pa seniyu su kerelaag, arun ndi' amu merepetan seng merelem ay sung medlaang riin seng merelem nda' mekesuun bu' ta' giin pekpagaw. ");
INSERT INTO stb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Saanay riin pa seniyu su kerelaag, tu'uay niyu su kerelaag arun mbaal amu ne getawan ri se kerelaag.” Dluwat itu telu'ay ni Jesus, migawa' giin ritu bu' migedlud buwat senilan. ");
INSERT INTO stb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Isan metuud mibaalen su dlaun ne nga ketingelaan riin seng metungenga'an nilan, nda' ilan pektu'u ri seniin, ");
INSERT INTO stb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","arun metuman suk tinalu' ni propeta Isaias: “Ginu'u, ta' maing mektu'u ri seng minsahi ne ginasuy nami? Bu' ta' maik pi'ita'an ne Ginu'u riin se ga'emen?” ");
INSERT INTO stb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Aas, nda' ilan meketu'u, tendeng ay laung rema ni Isaias, ");
INSERT INTO stb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Binutaan ilan ned Diwata bu' binaalen su nga gena'ena' nilan ne ndi' mekesabut, arun su ngang mata nilan ndi' mekiita', bu' su nga gena'ena' nilan ndi' mekesabut, ay ali' bu' mpuli' ilan ri senaan, bu' pe'uli'an'u ilan, miktalu' sud Diwata.” ");
INSERT INTO stb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Inasuy itu ni Isaias tendeng ay mi'ita'en su kesanag ni Jesus bu' miktuntul giin metendeng ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Isan pa run nini, melaun ne nga geseg ne ngag Judeo sung miktu'u riin ni Jesus, ma'ad tendeng se ngak Pariseo, nda' ilan pekpe'ilala run nini arun ndi' ilan pepe'uwa'en riin se ngak pektiguman; ");
INSERT INTO stb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ay pilabaw nilan nek siya'en ilan ne nga getaw sinangkali' nek siya'en ilan ned Diwata. ");
INSERT INTO stb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na, migasuy si Jesus seng mesekeg, “Suk sala neng miktu'u ri senaan, gena' na run ne gaku'ik tinu'uaan, bu' ndi' miktu'u rema giin seng miksugu' senaan. ");
INSERT INTO stb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Sung mikiita' senaan, mikiita' rema seng miksugu' senaan. ");
INSERT INTO stb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Miriniu seg benwa maa' ned delaag, arun isan ta' neng mektu'u ri senaan ndi' mekpebilin ri seng merelem. ");
INSERT INTO stb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Bu' isan ta' sung menginengeg ri seng minsahiu ma'ad ndi' mektuman run nini, ndi'u megukum ri seniin ay nda'u perini seg benwa arun ukuman su nga getaw bu' ndi' arun luwasen ilan. ");
INSERT INTO stb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Duuning meksilut tu seng megbibay ri senaan bu' ndi' dumawat ri seng minsahiu. Suk talu' nek tinalu'u giin mbuus sung megukum ri seniin se ketapusan ne gendaw. ");
INSERT INTO stb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tendeng ay gena'u miktalu' ri se gegulingen'u ne keliyag ma'ad su Gama' neng miksugu' ri senaan, giin sung miksugu' ri senaan bu' landunik telu'en'u. ");
INSERT INTO stb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Bu' misuunan'u ne suk sugu'en migbegay se ketubu' ne genda'iruni gekteben. Aas suk tinalu'u giin suk pitalu' senaan ne Gama'u.” ");
INSERT INTO stb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Na, se genda' pa mateng su gendaw se kese'ulugan sek Paska, misuunan ni Jesus neng minateng na suk panahun neng megawa' giin rini seg benwa bu' mpuli' tu' se Gama'. Pinetailen sung niin rini seg benwa, bu' pinetailen ilan tampan se ketapusan. ");
INSERT INTO stb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Seng minihapun si Jesus bu' su ngak tinu'unaan, pi'ena'ena' ni Satanas riin ni Judas neg bata' ni Simon Iscariote ne lu'ibaan si Jesus. ");
INSERT INTO stb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Misuunan ni Jesus ne su dlaun ne ga'em binegay na ne Gama' ri seniin. Misuunaan rema ne sed Diwata giin migbuwat bu' sed Diwata giin pagaw. ");
INSERT INTO stb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Migindeg giin buwat se dlemisaan, linuwasen suk suuben dapit dibabaw, bu' kiniberaan nek tuwalya su gawaken. ");
INSERT INTO stb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Binunagaan dayun nek tubig suk pelenggana, bu' pingugasaan su nga geksud ne ngak tinu'unaan, bu' pinerepuwaan nek tuwalya ne kinibed ri se gawaken. ");
INSERT INTO stb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Rayun se giin nai ugasaan su geksud ni Simon Pedro, miktalu' si Simon ri seniin, “Ginu'u, ugasan mu bai nga geksud'u?” ");
INSERT INTO stb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Sinembag giin ni Jesus, “Ndi' mu pa mesabut ini nemuun bu' landunig binaal'u keni, ma'ad mesabut mu ra peketubus ini.” ");
INSERT INTO stb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Miktalu' si Pedro, “Ndi' gaid mehimu ne dya'a megugas runi nga geksud'u isan laa panahunay run.” Ma'ad miktalu' si Jesus ri seniin, “Bu' ndi'a mekpe'ugas ri se nga geksud mu senaan, ndi'a na mbaal nek tinu'unan'u.” ");
INSERT INTO stb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Miktalu' si Simon Pedro, “Ginu'u, gena' na run nga geksud'u ugasan mu, bu' ndi' peruma mu remai nga gemeg'u bu' guluu.” ");
INSERT INTO stb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ma'ad miktalu' si Jesus, “Sung miligu' na, dlimpiyu naik tibuuk dlawasen bu' gena' na kina'enlan ugasan pa gawas ma'ad su nga geksuren. Dlimpiyu amu na, gawas suk sala riin seniyu.” ( ");
INSERT INTO stb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ay misuunaan bu' ta'ing medlu'ib ri seniin; aas miktalu' giin, “Dlimpiyu amu na, gawas suk sala riin seniyu.”) ");
INSERT INTO stb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aas seng mi'ugasan na ni Jesus su nga geksud nilan, sineluken puli' suk suuben dapit dibabaw bu' mipuli' tu se dlemisaan. Miksaak giin senilan, “Misabut ba niyu bu' landunig binaal'u riin seniyu?” ");
INSERT INTO stb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tinawag niyau neng Menintulu' bu' Ginu'u. Metuud ma iin, tinalu' niyu bu' ta'u. ");
INSERT INTO stb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Aas bu' gaku' ma gani' su Ginu'u bu' Menintulu' niyu neng migugas ri se nga geksud niyu, meginugasay amu rema ri se nga geksud niyu. ");
INSERT INTO stb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Binaal'u ini gisip dlendasan para seniyu, arun baalen niyu ini maa' sek pegbaal'u run nini riin seniyu. ");
INSERT INTO stb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sek pekemetuud esuyan'u amu, ne nda'iruni gulipen ne dlumabaw pa ri se gegalenen. Bu' suk sinugu' gena' lumabaw ri seng meksugu'. ");
INSERT INTO stb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bu' misuunan niyu ngag betang keni, pedleliyagen amu bu' baalen niyu ini. ");
INSERT INTO stb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nda'u ini telu'ay para ri se dlaunan niyu ay mi'ilalau su ngak pimili'u; ma'ad kina'enlan neng metuman suk tinalu' ri se Kesulatan, ‘Su getaw nek sumalu senaan sek pekaan, giin paing medlu'ib ri senaan.’ ");
INSERT INTO stb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Inasuy'u ini nemuun ri seniyu, saanay nda' pa mehitabu' arun bu' mehitabu' na mektu'u amu ne Gaku' ini. ");
INSERT INTO stb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sek pekemetuud esuyan'u amu, ne sud dumawat se isan ta' nek sinugu'u dinumawat ri senaan; bu' sud dinumawat senaan dinumawat ri seniin neng miksugu' senaan.” ");
INSERT INTO stb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Dluwat itu me'asuy ni Jesus, migu'ul gaid giin neng mikpemetuud senilan, “Sek pekemetuud esuyan'u amu, nek sala seniyu sung medlu'ib ri senaan.” ");
INSERT INTO stb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Migegenlengay su ngak tinu'unaan neng midlibeg bu' ta' etaway runik pigelingaan run nini. ");
INSERT INTO stb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Suk sala se ngak tinu'unan nek pinetail gaid ni Jesus migingkud ritu sek taparen. ");
INSERT INTO stb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sininyasan giin ni Simon Pedro nek saakan si Jesus bu' ta' suk pi'elingan run. ");
INSERT INTO stb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aas minigin rayun giin riin ni Jesus bu' miksaak, “Ta' ma ne getaw, Ginu'u?” ");
INSERT INTO stb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Miksembag si Jesus, “Su getaw neg begayan'u sek pan, tubus'u lebulay ini, giin su getaw.” Rayun linebul ni Jesus suk pan bu' binegain ini riin ni Judas, sug bata' ni Simon Iscariote. ");
INSERT INTO stb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sek pekerawat ni Judas run suk pan ketu, sinumeled si Satanas ri seniin. Miktalu' rayun si Jesus ri seniin, “Ala, baal mu na rayun sug baalen mu.” ");
INSERT INTO stb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","(Nda'irunik sala se ngang minihapun ketu neng mikesabut bu' tuma ma tinalu' itu ni Jesus riin ni Judas. ");
INSERT INTO stb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ay si Judas, giin maing migawid ri sek selapi' nilan. Migena'ena' sud duma ne ngak tinu'unan nek sinugu' ni Jesus si Judas nek sumaluy se nga kina'enlanen nilan para se kese'ulugan awas megbegay tu se ngak pupus.) ");
INSERT INTO stb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Seng mirawat na ni Judas suk pan, ginumawas rayun giin tendeng ay gebii itu. ");
INSERT INTO stb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Seng mikedlaang na si Judas, miktalu' si Jesus, “Nandaw, pesiddengegan sug Bata' ne Getaw. Bu' sud Diwata pesiddengegan pebiyan ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bu' sud Diwata pesiddengegan pebiyan ri seg Bata' ne Getaw, Sug Bata' ne Getaw pesiddengegan ned Diwata ri se gegulingenen nek pesiddengeg, bu' baalenen ini rayun. ");
INSERT INTO stb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nga gembata', ndi'u na mekpayat duma seniyu. Menengaw amu ri senaan; ma'ad telu'an'u amu nemuun maa' sek tinalu'u se nga geseg ne ngag Judeo, ‘Ndi' amu mekeritu sek pa'agawan'u.’ ");
INSERT INTO stb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Bu' nandaw, begay'u seniyu sug begu nek sugu': pekpinetailay amu. Maa' sek pekpetail'u ri seniyu, aas mekpinetailay amu rema. ");
INSERT INTO stb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bu' mekpinetailay amu, mesuunan rayun se dlaunan ne gamuik tinu'unan'u.” ");
INSERT INTO stb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sinaakan giin ni Simon Pedro, “Ginu'u, ta'a ma pagaw?” Miksembag si Jesus, “Ndi'a mekedlendug senaan nandaw bu' ta'u pagaw, ma'ad se ketambinai', mekedlendug'a ra ritu.” ");
INSERT INTO stb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ma'ad miksaak si Pedro, “Ginu'u, lama ndi'u mekedlendug riin seni'a nandaw? Andamu ma rema meksipatay para seni'a.” ");
INSERT INTO stb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Sinembag giin ni Jesus, “Andam'a ba gaid meksipatay para senaan? Telu'an'u dya'a seng metuud, se gendi' pa meguni su dlimensad, limeren mau seng metelu.” ");
INSERT INTO stb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Miktalu' si Jesus ritu sek tinu'unaan, “Ndi' amu megu'ul. Salig amu ri sed Diwata bu' salig amu rema senaan. ");
INSERT INTO stb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ritu seg balay ne Gama'u, duuning melaun ne ngak pekengelan, bu' endamen'u su dlugar para seniyu. Bu' gena' metuud ini, ndi'u na tabal riin seniyu. ");
INSERT INTO stb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Bu' mekerituu na bu' mekaandam na ne dlugar para seniyu, mpuli'u bu' engain'u amu arun isan ta'u, ritu amu rema. ");
INSERT INTO stb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bu' mesuunan niyu sud dalan pagaw se dlugar nek pa'agawan'u.” ");
INSERT INTO stb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Miktalu' si Tomas ri seniin, “Ginu'u, nda' ami mekesuun bu' ta'a pagaw, aas pegendunen nami run sek pekesuun sed dalan pagaw ritu?” ");
INSERT INTO stb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Miksembag si Jesus seniin, “Gaku' sud dalan, su kemetuuran, bu' su ketubu'; nda'iruning mekeritu se Gama' bu' gena' pebiyan ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bu' mi'ilala niyau, me'ilala niyu rema su Gama'u. Bu' gatad nandaw, mi'ilala niyu su Gama'u, bu' mi'ita' niyu giin.” ");
INSERT INTO stb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Miktalu' si Felipe ri seniin, “Ginu'u, pe'ita' mu senami su Gama' bu' gigu na itu para senami.” ");
INSERT INTO stb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Miksembag si Jesus, “Mpayat naik pedduut'u riin seniyu, ma'ad nda'a pa gaid mekilala ri senaan, Felipe? Sung mikiita' senaan, mikiita' rema giin ri se Gama'. Lama mektalu'a pa run nek pe'ita'u seniyu su Gama'? ");
INSERT INTO stb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nda'a ba pektu'u, Felipe, ne gaku' riin se Gama' bu' su Gama' riin senaan? Su ngak talu' ne ginasuy'u riin seniyu gena' buwat ri senaan ma'ad buwat se Gama' neng mikpebilin ri senaan. Giin sung migbaal se ngak terbahu keni. ");
INSERT INTO stb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tu'uway niyu ne gaku' riin se Gama' bu' su Gama' riin senaan. Bu' ndi', tu'uway niyau tendeng se ngak terbahu neg binaal'u. ");
INSERT INTO stb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sek pekemetuud esuyan'u amu, ne sung miktu'u ri senaan, baalenen su ngag binaal'u; bu' baalenen su dlabaw pa kampuun, tendeng ay merituu na se Gama'. ");
INSERT INTO stb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bu' isan landunik penengiin niyu ri se ngalan'u, baalen'u arun mpesiddengegan su Gama' pebiyan seg Bata'. ");
INSERT INTO stb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bu' isan landunik penengiin niyu ri se ngalan'u, baalen'u ini.” ");
INSERT INTO stb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Miktalu' si Jesus, “Bu' pinetail niyau, tuman niyui ngak sugu'u. ");
INSERT INTO stb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Penengiin'u ri se Gama' bu' begayan amu ne dlain neng mekegabang, neng medduma riin seniyu se genda'iruni gekteben. ");
INSERT INTO stb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Giin su Gispiritu neng mektendu' ri seniyu se kemetuuran. Su nga getaw rini seg benwa ndi' mekerawat ri seniin tendeng ay ndi' nilan giin me'ita' bu' me'ilala. Ma'ad mi'ilala niyu giin tendeng ay midduma giin bu' mikengel riin seniyu. ");
INSERT INTO stb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ndi'u amu belengen neng maa' ne giru. Mpuli'u riin seniyu. ");
INSERT INTO stb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sek sereluk, su nga getaw rini seg benwa ndi' na mekiita' ri senaan, ma'ad me'ita' niyau; bu' tendeng ay mitubu'u, metubu' amu rema. ");
INSERT INTO stb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sek peddateng ne gendaw, mesuunan niyu ne gaku' riin se Gama'u bu' gamu riin senaan maa' ne gaku' riin rema seniyu. ");
INSERT INTO stb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Sung middawat ri se ngak sugu'u bu' miktuman run nini, giining mikpetail ri senaan. Bu' sung mikpetail ri senaan, petailen rema ne Gama'u. Petailen'u rema giin bu' pe'ilalau seniin bu' ta'u gaid ne getaw.” ");
INSERT INTO stb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Miksaak si Judas (gena' si Judas Iscariote), “Ginu'u, landun mai keterengan ne rinia senami mekpe'ilala bu' gena' ri se nga getaw?” ");
INSERT INTO stb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Miksembag si Jesus ri seniin, “Sung mikpetail ri senaan, miktuman ri se ngak tinendu'u. Petailen giin ne Gama'u bu' su Gama'u bu' gaku' meriin seniin bu' mekengel ri seniin. ");
INSERT INTO stb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Su genda' pekpetail ri senaan, nda' pektuman ri se ngak tinendu'u. Suk tinendu'u neng mirengeg niyu, gena' buwat ri senaan, bu' ndi', buwat se Gama'u neng miksugu' ri senaan.” ");
INSERT INTO stb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tinalu'u ini riin seniyu saanay sementaun niyau pa. ");
INSERT INTO stb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma'ad sung menggegabang, sug Bala'an ne Gispiritu Santu, nek sinugu' ne Gama'u ri se ngalan'u, mektendu' ri seniyu se dlaunen bu' mekperelendem riin seniyu se dlaunen nek tinalu'u riin seniyu.” ");
INSERT INTO stb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Su kelinaw bilin'u ri seniyu. Su kelinaw'u begay'u riin seniyu; gena' ini maa' ne kelinaw neg binegay neg benwa. Ndi' amu megu'ul bu' ndi' amu mendek. ");
INSERT INTO stb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mirengeg niyu neng miktalu'u seniyu neng megawa'u bu' mpuli'u ra. Bu' pinetail niyau, pedleliyagen amu neng mekerituu se Gama'u; ay labaw pa giin gupiya sinangkali' ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Inasuy'u na ini daan seniyu, se gendi' pa mehitabu', ne bu' mehitabu' ini, mektu'u amu gaid senaan. ");
INSERT INTO stb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ndi'u na mekpayat sek pektuntul seniyu, tendeng ay mateng na sung midlegeseg ri seg benwa. Ndi' giin mekega'em ri senaan, ");
INSERT INTO stb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ma'ad se dlaun ne nga getaw rini seg benwa kina'enlan mekesuun nek pinetail'u su Gama'; sumala' sek sinugu' nu Gama'u, aas binaal'u su dlaunan. “Ala, gindeg amu, menlaang ita na buwat rini,” miktalu' si Jesus. ");
INSERT INTO stb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Mikpeddayun si Jesus sek pegasuy, Gaku' sung metuud nek puun ne gubas, bu' su Gama'u giin sung migatiman run nini. ");
INSERT INTO stb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Su kada nek pangau ne gendi' memunga petelenen, bu' su kada nek panga neng memunga simpulungaan arun memunga neng melaun. ");
INSERT INTO stb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gamu milimpiyuwan na tendeng sek talu' nek tinalu'u riin seniyu. ");
INSERT INTO stb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pekpebilin amu ri senaan bu' mekpebilinu riin seniyu. Maa' nek panga ne ndi' mekepemunga ri se gegulingenen bu' suway ri sek puun. Maa'entu amu rema, ndi' amu mekepemunga bu' sumuway amu ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Gaku' suk puun ne gubas, bu' gamu su ngak pangau. Suk sala neng mekpebilin ri senaan bu' gaku' riin seniin, mekepemunga giin neng melaun tendeng ay suk sumuway ri senaan, nda'iruni gembaalen. ");
INSERT INTO stb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Su gendi' mekpebilin ri senaan maa' nek panga nek pinidlak bu' milawes. Rayun timuren su ngak panga bu' pidlaken tu se gapuy arun serengen. ");
INSERT INTO stb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bu' mekpebilin amu senaan, bu' su ngak talu'u mekpebilin riin seniyu, isan landun ne dliyagan niyu, mekepenengi amu bu' merawat niyu ini. ");
INSERT INTO stb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Pebiyan run nini, mpesiddengan niyu su Gama'u neng mekepemunga amu neng melaun bu' mbaal amu ne ngak tinu'unan'u. ");
INSERT INTO stb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Pinetail'u amu maa' sek pekpetail ne Gama'u ri senaan. Pebilin amu ri sek pekpetail'u. ");
INSERT INTO stb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bu' tumanen niyu su ngak sugu'u, mekpebilin amu ri sek pekpetail'u, maa' sek pektuman'u se ngak sugu' ne Gama'u, bu' mekpebilinu ri sek pekpetailen.” ");
INSERT INTO stb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Tinalu'u ngag betang keni riin seniyu arun me'angken niyu suk pedleliyag'u, bu' metileng suk pedleliyag niyu. ");
INSERT INTO stb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Giin nini suk sinugu'u seniyu, pekpinetailay amu maa' sek pekpetail'u seniyu. ");
INSERT INTO stb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Su dlabi gembagel nek pekpetail ne mbegay sek sala ne getaw tu se ngak sambaten giin suk pegbegay ri se gegulingenen ne ketubu' para senilan. ");
INSERT INTO stb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ngak sambat'u amu, bu' tumanen niyu su ngak sugu'u riin seniyu. ");
INSERT INTO stb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ndi'u amu na tuwagen ne nga gulipen, tendeng ay su nga gulipen ndi' mekesuun landunig baalen nu gegalenen; ma'ad tuwagen'u amu ne ngak sambat, tendeng ay pisuun'u seniyu su dlaun neng mirengeg'u buwat se Gama'u. ");
INSERT INTO stb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gena' gamu sung mikpili' ri senaan, ma'ad gaku' sung mikpili' bu' miktendu' ri seniyu arun menlaang bu' mekpeddayun amu sek pekpemunga, arun isan landunik penengiin niyu ri se Gama'u pebiyan ri se ngalan'u, begain nini riin seniyu. ");
INSERT INTO stb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Giin nini suk sugu'u seniyu: pekpinetailay amu.” ");
INSERT INTO stb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Miktalu' si Jesus tu se ngak tinu'unaan, “Bu' gemetan amu ne nga getaw, pegena'ena' niyu ne gunau nilan ginemetan. ");
INSERT INTO stb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bu' duma amu ri se nga getaw seg benwa, petailen amu nilan. Ma'ad tendeng ay gena' amu duma nilan bu' pimili'u amu buwat senilan, aas ginemetan amu nilan. ");
INSERT INTO stb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pegena'ena' niyu suk tinalu'u seniyu: ‘Su gulipen gena' labaw pa ri se gegalenen.’ Bu' linutusu nilan, lutusen amu rema nilan. Bu' mektuman ilan ri sek tinendu'u, mektuman ilan rema ri sek tinendu' niyu. ");
INSERT INTO stb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ma'ad baalen nilani dlaunan keni riin seniyu tendeng senaan ay nda' ilan mekilala ri seniin neng miksugu' ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bu' nda'u perini bu' pektalu' senilan, ndi' ilan siya mekesala'. Ma'ad nemuun ndi' ilan meketalu' ne nda'irunik sala' nilan. ");
INSERT INTO stb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ta' ma su gumemet senaan, gumemet rema ri se Gama'u. ");
INSERT INTO stb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ndi' ilan siya mekesala' bu' nda'u baalay riin senilan su ngak pimbaal'u ne nda'iruni getaw neng mekegbaal run. Ma'ad nemuun mi'ita' nilan su ngak pimbaal'u bu' ginemetanu bu' su Gama'u rema. ");
INSERT INTO stb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ma'ad kina'enlan metuman suk talu' neng misulat ri seg bala'ud nilan: ‘Ginemetanu nilan se genda'iruni keterengan.’ ");
INSERT INTO stb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Merini sung Menggegabang ne giin su Gispiritu neng mekpe'ita' se kemetuuran metendeng sed Diwata bu' migbuwat ri se Gama'. Sinugu'u giin riin seniyu buwat ri se Gama' bu' mekpemetuud giin metendeng ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Bu' mekpemetuud amu rema, ay gamu duma ma senaan gatad se getaran.” ");
INSERT INTO stb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Miktalu' si Jesus tu se ngak tinu'unaan, “Asuy'u daan ri seniyu ngag betang keni arun ndi' amu merela'an sek pektu'u niyu. ");
INSERT INTO stb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pepe'uwa'en amu ne nga geseg se ngak pektipungan, bu' mateng suk panahun ne isan ta' getaw neng mekpatay seniyu, megena'ena' giin neg binaalen itu para sek pekpenibeliin tu sed Diwata. ");
INSERT INTO stb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Baalen nilan nini riin seniyu tendeng ay nda' ilan mekilala ri se Gama' awas senaku'. ");
INSERT INTO stb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ma'ad tinalu'u ini riin seniyu arun bu' baalen nilan nini, me'ena'ena' niyu suk tinalu'u riin seniyu.” “Na, ngag betang keni nda'u asuy ri seniyu nud diin, ay sementaunu pa niyu. ");
INSERT INTO stb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ma'ad nemuun mpuli'u na tu seng miksugu' senaan bu' nda'irun gaid isan sala neng miksaak bu' ta'u pagaw. ");
INSERT INTO stb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Bu' nemuun tendeng ay inesuyan'u amu na, migu'ul amu gaid. ");
INSERT INTO stb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ma'ad telu'an'u amu ri seng metuud, melengas pa kampuun para seniyu neng megawa'u rini, ay bu' ndi'u megawa' rini, sung Menggegabang ndi' mateng ri seniyu. Ma'ad bu' megawa'u, pawit'u giin seniyu. ");
INSERT INTO stb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mbuus sek peddatengen, pe'ilelaan tu se nga getaw rini seg benwa metendeng ri sek sala' nilan bu' sek pekemetareng, bu' sek pegukum ned Diwata. ");
INSERT INTO stb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pe'ilelaan ri senilan suk sala' nilan tendeng ay nda' ilan pektu'u ri senaan; ");
INSERT INTO stb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","bu' pe'ilelaan ri senilan suk pekemetareng tendeng ay merituu se Gama'u bu' ndi' amu na mekiita' ri senaan; ");
INSERT INTO stb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","bu' pe'ilelaan ri senilan neng misayep ilan metendeng ri sek pegukum sed Diwata tendeng ay su geseg ri seg benwa inukuman na.” ");
INSERT INTO stb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Melaun pa sa'wani asuy'u seniyu, ma'ad ndi' pa niyu mesabut numuun. ");
INSERT INTO stb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ma'ad bu' mateng na su Gispiritu Santu ne giin sung mektendu' seniyu se kemetuuran, tendu'aan amu se dlaun ne kemetuuran; su ngag betang nek tendu'en riin seniyu gena' buwat ri seniin, bu' ndi', landuning mirengegen, asuyen rema riin seniyu bu' landuning mehitabu' seng mateng ne gendaw. ");
INSERT INTO stb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pesiddengegan naun tendeng ay duwatenen sung minsahiu bu' asuyen riin seniyu. ");
INSERT INTO stb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Su dlaun ned diin se Gama' diin senaan. Giin nini su keterengan nek tinalu'u ne su Gispiritu duwatenen sung minsahiu bu' asuy riin seniyu.” ");
INSERT INTO stb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Miktalu' si Jesus, “Se gendi' mpayat ndi' niyau na me'ita' ma'ad tubus itu, ndi' rema mpayat me'ita' ra niyau.” ");
INSERT INTO stb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aas miksesaakay sud duma ne ngak tinu'unaan, “Landun baig be'et pesabuten ri sek tinalu'en, ‘Se gendi' mpayat ndi' niyau na me'ita' ma'ad tubus itu, ndi' rema mpayat me'ita' ra niyau pelun?’ Bu' miktalu' rema giin, ‘Tendeng ay mpuli'u na tu se Gama'u.’ ");
INSERT INTO stb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Landun baig be'et pesabuten ri sek tinalu'en, ‘Se gendi' mpayat?’ Ndi' ta mesabut bu' landuni gulugan ri sek tinalu'en.” ");
INSERT INTO stb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Misuunan ni Jesus ne dliyagan sa'wan ne ngak tinu'unaan meksaak ri seniin bu' landuni gulugan ri sek tinalu'en. Aas, miktalu' si Jesus senilan, “Tinalu'u muun, ‘Se gendi' mpayat ndi' na niyau me'ita'. Ma'ad tubus itu, se gendi' rema mpayat me'ita' niyau ra pelun.’ Miksesaakay amu ba bu' landuni gulugan ri sek tinalu'u? ");
INSERT INTO stb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sek pekemetuud esuyan'u amu, neng mensegaw amu bu' megu'ul amu ma'ad su nga getaw pedleliyagen. Megu'ul amu ma'ad su nga kegu'ul niyu metelesan ra se dleliyag. ");
INSERT INTO stb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Su dlibun, seng megaud na megbata', megu'ul giin tendeng ay minateng na suk panahun neng megbata' giin. Ma'ad bu' me'etaw na gani' sug bata', melingawaan na su kegeel tendeng se dleliyagen neng mi'etaw na sug bata'en rini seg benwa. ");
INSERT INTO stb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Bu' gamu maa' rema run, nandaw migu'ul amu. Ma'ad megita' ita pa puli'. Rayun melebiyan pa gaid mbuus su dleliyag niyu, bu' nda'irun gairing mekaawi' run nini isan ta'. ");
INSERT INTO stb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Bu' mateng na gani' su gendaw ketu, ndi' amu na meksaak isan landun ri senaan. Sek pekemetuud esuyan'u amu, isan landun nek penengiin niyu ri se Gama'u ri se ngalan'u, begain riin seniyu. ");
INSERT INTO stb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tampan numuun, nda' amu pa penengi ri se ngalan'u; penengi amu bu' begayan amu, arun metileng su dleliyag niyu.” ");
INSERT INTO stb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Miktalu' si Jesus ri senilan, “Inasuy'u ini seniyu pebiyan ri se nga galing. Ma'ad mateng suk panahun ne ndi'u na medlegamit ne nga galing, bu' ndi', megasuyu riin seniyu pebiyan seng melemu nek peketalu'. ");
INSERT INTO stb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Sek peddateng se gendaw ketu, menengi amu ri seniin pebiyan ri se ngalan'u bu' gaku' ndi' mektalu' ne gaku' giin sung menengi para seniyu, ");
INSERT INTO stb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ay su Gama' mikpetail ma seniyu. Pinetail amu niin tendeng ay pinetail niyau bu' miktu'u amu ne gaku' buwat ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Wa'a, gaku' buwat ri sed Diwata ne Gama' bu' miriniu seg benwa. Bu' numuun, megawa'u na ri seg benwa keni bu' mpuli'u tu se Gama'.” ");
INSERT INTO stb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Miktalu' rayun su ngak tinu'unaan, “Nandaw kelaru na gaid suk peketalu' mu tendeng ay nda'a na pedlegamit ne nga galing. ");
INSERT INTO stb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nandaw, misuunan na nami neng misuunan mu su dlaun ne ngag betang bu' nda'a pedlekina'enlan ned duun paing meksaak seni'a. Aas miktu'u ami ne dya'a buwat gaid sed Diwata.” ");
INSERT INTO stb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Miktalu' si Jesus ri senilan, “Nandaw, miktu'u amu na ba? ");
INSERT INTO stb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Enlengay niyu, mateng suk panahun bu' nandaw keni na, neng megbelagbelag amu dlaunan niyu. Menguli' amu tu seniyu bu' belengen niyau. Ma'ad gena' nek salau na run ay dumau su Gama'. ");
INSERT INTO stb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Inasuy'u ngag betang keni seniyu arun mekaangken amu ne kelinaw pebiyan sek pekesalabuuk niyu ri senaan. Pe'entusen amu rini seg benwa ma'ad ndi' amu mendek tendeng ay dinaag'u sung melaat rini seg benwa.” ");
INSERT INTO stb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Peketubus ni Jesus mektalu' run nitu, migangag giin tu se dlangit, laungen, “Gama', minateng na suk panahun. Pesiddengegay mu sug Bata' mu arun sug Bata' mekepesiddengeg ri seni'a. ");
INSERT INTO stb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ay binegayan mu giin ne ketenged sek pedlegeseg se dlaun ne nga getaw arun mbegayaan se ketubu' ne genda'iruni gekteben su dlaun nek piniyal mu seniin. ");
INSERT INTO stb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Bu' keni giin su ketubu' ne genda'i gekteben: ne su nga getaw megilala seni'a ne giin sung metuud ned Diwata bu' megilala riin ni Jesus Christ, nek sinugu' mu. ");
INSERT INTO stb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Pisiddengegan'u dya'a rini seg benwa; Tinubus'u suk terbahu nek pibaal mu senaan. ");
INSERT INTO stb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bu' nemuun, Gama', pesiddengegay mau riin seng metungenga'an mu maa' sed dengeg ned diin senaan duma seni'a se genda' pa mbaal sug benwa.” ");
INSERT INTO stb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Pi'ilalau dya'a se nga getaw neg binegay mu senaan buwat seg benwa. Misakup ilan seni'a bu' binegay mu ilan ri senaan. Bu' tinuman nilan suk talu' mu. ");
INSERT INTO stb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nandaw, misuunan na nilan ne su dlaun neg binegay mu ri senaan migbuwat seni'a. ");
INSERT INTO stb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ay binegay'u senilan sung minsahi neg binegay mu senaan, bu' dinawat ini nilan. Bu' misuunan nilan ne gaku' metuud gaid neng migbuwat seni'a bu' miktu'u ilan na gaid ne dya'a sung miksugu' senaan.” ");
INSERT INTO stb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Migampu'u para senilan. Nda'u pegampu' para ri se nga getaw seg benwa, bu' ndi' para se nga getaw nek piniyal mu senaan tendeng ay sakup mu ilan. ");
INSERT INTO stb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Su dlaun ne nga getaw neng naan, ni'a; bu' su dlaun nilan neng ni'a, naan. Bu' sud dengeg'u pi'ita' pebiyan senilan. ");
INSERT INTO stb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nemuun mpuli'u na riin seni'a. Gendi'u na mekpayat rini seg benwa ma'ad su ngak tinu'unan mekpebilin rini seg benwa. Bala'an ne Gama', bentayay mu ilan ri se ga'em ne ngalan mu—su ngalan neg binegay mu senaan arun mesalabuuk ilan maa' ne dya'a bu' gaku' sala ra. ");
INSERT INTO stb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Saanay dumau pa nilan, binentayan'u ilan pebiyan se ga'em ne ngalan mu, su ngalan neg binegay mu senaan. Binentayan'u ilan, bu' nda' gairing mirala' senilan, gawas ma'aray se getaw nek tinegana neng merala' arun metuman suk tinalu' se Kesulatan. ");
INSERT INTO stb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Bu' numuun, mpuli'u na riin seni'a bu' ngag betang keni inasuy'u saanay diniu pa seg benwa arun metileng su dleliyag nilan maa' se dleliyag'u. ");
INSERT INTO stb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Binegay'u senilan sung minsahi mu, bu' ginemetan ilan nu nga getaw seg benwa, tendeng ay gena' ilan na sakup seg benwa maa' senaan ne gena'u sakup seg benwa. ");
INSERT INTO stb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nda'u pegampu' ne uwa'en mu su ngak tinu'unan rini seg benwa bu' ndi' peneliperan mu ilan buwat sek Penulay. ");
INSERT INTO stb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Gena' ilan sakup seg benwa maa' senaan ne gena' sakup seg benwa. ");
INSERT INTO stb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Baal mu ilan neg bala'an pebiyan se kemetuuran; suk talu' mu kemetuuran. ");
INSERT INTO stb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Maa' sek peksugu' mu senaan rini seg benwa, aas sinugu'u ilan rini seg benwa. ");
INSERT INTO stb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Bu' tendeng senilan, piyal'u su gegulingen'u riin seni'a arun piyal rema nilan su gegulingen nilan ri seni'a.” ");
INSERT INTO stb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Na, sung naku' nek pegampu' gena' na run para senilan ma'ad para tu se dlaun neng miktu'u ri senaan tendeng ri seng minsahi nilan. ");
INSERT INTO stb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Migampu'u arun mesalabuuk ilan siya. Gama', mesalabuuk ilan siya rini senita maa' ne dya'a diin senaan bu' gaku' diin seni'a. Mesalabuuk ilan siya arun mektu'u su nga getaw rini seg benwa ne dya'a sung miksugu' senaan. ");
INSERT INTO stb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Binegayan'u ilan ned dengeg neng maa' sed dengeg neg binegay mu ri senaan arun mesalabuuk ilan maa' rema senita neng miksalabuuk, ");
INSERT INTO stb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","gaku' riin senilan bu' dya'a riin senaan arun mesalabuuk ilan gaid, arun mesuunan ne nga getaw ri seg benwa ne dya'a sung miksugu' ri senaan bu' pinetail mu ilan maa' sek pekpetail mu ri senaan.” ");
INSERT INTO stb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Gama', binegay mu ilan ri senaan bu' liyagan'u ne isan ta'u, ritu ilan rema arun me'ita' nilan suk pekege'eman'u. Giin nini su ga'em neg binegay mu senaan tendeng ay pinetail mau se genda' pa mbaalig benwa. ");
INSERT INTO stb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Metareng ne Gama', metuud ne su nga getaw rini seg benwa nda' mekilala ri seni'a. Ma'ad mi'ilalau dya'a bu' ngak tinu'unan keni mikesuun ne dya'a sung miksugu' ri senaan. ");
INSERT INTO stb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Bu' pi'ilalau dya'a senilan bu' pe'ilalau pa gaid dya'a, arun suk petail mu para senaan mperiin siya senilan, bu' arun gaku' mperiin siya senilan.” ");
INSERT INTO stb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Sek peketubus megampu' ni Jesus, midlaang rayun giin duma se ngak tinu'unaan bu' dinumipag ilan tu sek sapa' ne Kidron, ned ditu duunik pigimulanan, bu' miritu rayun si Jesus bu' su ngak tinu'unaan. ");
INSERT INTO stb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na, si Judas, neng midlu'ib ri seniin, mikesuun se dlugar ketu tendeng ay kanunay mektipung si Jesus bu' su ngak tinu'unaan ritu. ");
INSERT INTO stb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Aas miritu si Judas sek pigimulanan duma se ngak sundalu nek taga Roma asta na su nga guwardiya sek Templo nek sinugu' ne nga geseg ne ngak pari' bu' se ngak Pariseo. Duuni ginuwit nilan ne ngak tingkarul, bu' ngak sulu', bu' ngag besi. ");
INSERT INTO stb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Misuunan ni Jesus su dlaun neng mehitabu' seniin. Aas sinungkaken ilan bu' miksaak, “Ta' baik pinengaw niyu?” ");
INSERT INTO stb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Miksembag ilan, “Si Jesus nek taga Nazaret.” Miktalu' si Jesus senilan, “Gaku' si Jesus.” Na, si Judas, neng midlu'ib seniin, ditu rema migindeg duma senilan. ");
INSERT INTO stb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pektalu' ni Jesus ne giin suk pinengaw nilan, mingeddud ilan bu' mibuksak ilan ri se dlupa'an. ");
INSERT INTO stb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sinaakan ilan puli' ni Jesus bu' ta'ik pinengaw nilan. Miktalu' ilan puli', “Si Jesus nek taga Nazaret.” ");
INSERT INTO stb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Miktalu' si Jesus senilan, “Inesuyan'u amu ne Gaku' si Jesus. Aas bu' gaku' gairik pinengaw niyu, ndi' niyu ilebetayid duma.” ( ");
INSERT INTO stb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tinalu'en ini arun landun suk tinalu'en metuman: “Gama', nda'irun gairing merala' isan sala tawan se nga getawan neg binegay mu senaan.”) ");
INSERT INTO stb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Rayun si Simon Pedro ned duuni kalisen, binakuten nini bu' tinigbasen su gulipen ne Dlabaw Geseg nek Pari' bu' mi'eksip suk telingaan ned dapit dlintu. Bu' su ngalan ne gulipen ketu si Malcus. ");
INSERT INTO stb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Aas miktalu' si Jesus riin ni Pedro, “Sulek mu ri se guma'aani kalis mu. Migena'ena'a ba ne ndi'u entusen su ngak pi'antus se Gama' ri senaan?” ");
INSERT INTO stb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Dinaap rayun si Jesus nu ngak sundalu nek taga Roma, bu' se kapitan nilan, bu' se nga guwardiya ne ngag Judeo bu' ginapus giin. ");
INSERT INTO stb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bu' inuwit reli' nilan giin tu ni Anas suk penugangan ne dlai ni Caipas. Si Caipas giin su Dlabaw Geseg nek Pari' sek taun ketu. ");
INSERT INTO stb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na, si Caipas giin sung migbegay nek sambag ri se nga geseg nu ngag Judeo neng melengas kampuun nek sala tawan raing matay para se dlaun ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na si Simon Pedro bu' suk sala pa nek tinu'unan midlendug riin ni Jesus. Bu' suk sala nek tinu'unan ni Jesus ketu mi'ilala nu Dlabaw Geseg nek Pari', aas mikedlendug giin riin ni Jesus tu se dlenu'an nug balay nu Dlabaw Geseg nek Pari', ");
INSERT INTO stb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","saanay mibilin si Pedro ritu se gawas megaud se genga'an. Mbuus, suk tinu'unan neng mi'ilala ne Dlabaw Geseg nek Pari' ginumawas puli' bu' migandyu' tu sed delaga neng migbantay ritu se genga'an nek peseleren si Pedro bu' mikeseled si Pedro. ");
INSERT INTO stb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aas miktalu' sud delaga riin ni Pedro, “Gena' ba salaa ma rema se ngak tinu'unan ne getaw kiin?” Miksembag si Pedro, “Gena' lai tumu'!” ");
INSERT INTO stb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Meteddaw suk panahun ketu, aas miguklak ne gapuy su nga gulipen bu' su ngang migbantay ginamit su guling; bu' migindeg ilan tu seng megaud ne gapuy arun merendangrendang ilan. Si Pedro migindeg ritu bu' mikperendangrendang duma senilan. ");
INSERT INTO stb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Rayun sinaakan si Jesus nu Dlabaw Geseg nek Pari' metendeng se ngak tinu'unaan bu' metendeng se ngak pimandu'en. ");
INSERT INTO stb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Miksembag si Jesus, “Migasuyu tu se dlaun ne getaw. Su dlaun nek pimandu'u kanunay'u binaal ri sek seled se ngak pektipungan bu' sek Templo ne ritu mektipung su dlaun ne nga getaw. Nda'u pemandu' ri seng me'edlud. ");
INSERT INTO stb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tuma ma gaku' maik saakan mu? Saakay niyui nga getaw neng mikerengeg ri senaan. Enlengay niyu, mikesuun ilan bu' landunik tinalu'u senilan.” ");
INSERT INTO stb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sek pektalu' ni Jesus run itu, tinampaling giin nuk sala ne ngang migbantay ritu bu' miktalu' giin tu ni Jesus, “Tuma ma metalu' mu maing maa' niin se Dlabaw Geseg nek Pari'.” ");
INSERT INTO stb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Miksembag si Jesus tu seng migbantay, “Bu' duunik sayep se ngak tinalu'u, pemetuuray mu neng misayepu. Ma'ad bu' ginsaktu su ngak tinalu'u, lama tampalingan mau run?” ");
INSERT INTO stb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mbuus, binalud pa gusay si Jesus bu' pinawit giin ni Anas ritu ni Caipas, su Dlabaw Geseg nek Pari'. ");
INSERT INTO stb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saanay migindeg pa si Pedro neng mikperendangrendang tu seng megaud ne gapuy, sinaakan giin ne nga getaw, “Gena' ba salaa ma rema se ngak tinu'unan ne getaw kiin?” Midlimed na pelum si Pedro bu' miktalu', “Gena' lai tumu'!” ");
INSERT INTO stb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Rayun sala se nga gulipen nu Dlabaw Geseg nek Pari', gepenan nu getaw nek tinigbas ni Pedro suk telingaan, miksaak, “Gena' ba dya'a ma sung mi'ita'u nek tendug ne getaw kiin tu sek pigimulanan?” ");
INSERT INTO stb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ma'ad midlimed na pelum si Pedro bu' sek tikmal miguni rayun su dlimensad. ");
INSERT INTO stb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Aas inuwit nilan si Jesus buwat ritu seg balay ni Caipas pagaw ritu sek palasyu ne gobernador nu ngak taga Roma. Na, dali' endaw pa itu bu' nda' seled su nga geseg ne ngag Judeo tu sek palasyu tendeng ay sumala' ri seng mibetasan nilan, bu' sumeled ilan ri seg balay ne gena' Judeo, gena' ilan na dlimpiyu bu' ndi' ilan mekekaan ri sek penihapun para se kese'ulugan sek Paska. ");
INSERT INTO stb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Aas ginumawas si Gobernador Pilato ritu senilan, bu' miksaak, laungen, “Landunik sumbung niyu kuntra se getaw keni?” ");
INSERT INTO stb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Miksembag ilan, “Bu' nda' paing melaat neng mibaalen, ndi' siya nami giin uwiten ri seni'a.” ");
INSERT INTO stb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Miktalu' si Pilato senilan, “Uwit niyu giin bu' gamuing megukum ri seniin sumala' ri se kesugu'an niyu.” “Ma'ad nda' ami tugutay sek pekpatay ne getaw,” miksembag su ngag Judeo. ( ");
INSERT INTO stb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mihitabu' ini arun metuman suk tinalu' ni Jesus bu' laa kelesiyay run su kemetainen.) ");
INSERT INTO stb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Aas sinumeled puli' si Pilato tu sek palasyu bu' tinawagen si Jesus bu' miksaak, “Dya'a ba su gari' ne ngag Judeo?” ");
INSERT INTO stb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Miksembag si Jesus, “Saak keni buwat ba se gegulingen mu awas inesuyan'a na run ned duma metendeng ri senaan?” ");
INSERT INTO stb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Miksembag si Pilato, “Migena'ena'a ba ne gaku' Judeo? Su gegulingen mu ne nga getawan bu' su nga geseg ne ngak pari' gilaning miguwit seni'a rini senaan. Landun ba gairing mibaal mu?” ");
INSERT INTO stb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Sinembag giin ni Jesus, “Suk pedlegeri'an'u nda' rini seg benwa keni. Bu' suk pedlegeri'an'u rini pa seg benwa, sumukul siya su ngak sumusunud'u arun ndi'u meraapan ne ngag Judeo. Bu' numuun, suk pidlegeri'an'u nda' rini seg benwa keni.” ");
INSERT INTO stb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Aas miktalu' si Pilato ri seniin, “Gari'a ba, rekay?” Sinembag giin ni Jesus, “Miktalu'a ne gaku' gari'. Seng maa' nini, mi'etawu bu' miriniu seg benwa arun mekpemetuud ri se kemetuuran. Su kada sala ned diin se kemetuuran minginengeg ri senaan.” ");
INSERT INTO stb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Miksaak rayun si Pilato, “Landun bai kemetuuran?” Bu' peketubus mektalu' ni Pilato run itu, ginumawas giin puli' tu se ngag Judeo bu' miktalu' giin tu senilan, “Nda'iruning mi'ita'u nek sayep se getaw keni. ");
INSERT INTO stb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ma'ad duuning mibetasan para seniyu ne bu' mateng su kese'ulugan nek Paska, mekpegawasu nek sala nek pinerisu. Liyagan ba niyu nek pegewasen'u su gari' ne ngag Judeo?” ");
INSERT INTO stb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Miksembag ilan duma sek pegbeksay, “Gena' getaw iin ma'ad si Barabas.” (Si Barabas keni ribildi.) ");
INSERT INTO stb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Aas inuwan rayun ni Pilato si Jesus bu' pilatiguun giin. ");
INSERT INTO stb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bu' su ngak sundalu mikselapid nek sigbet ned dugiyan, binaal ne kuruna, bu' binetang nilan riin se gulu ni Jesus. Bu' piselukan nilan giin nek suub neng melagemlagem. ");
INSERT INTO stb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bu' mikpegaud ilan ri seniin neng middega'rega', “Tetubu' su Gari' ne ngag Judeo.” Rayun tinampaling nilan giin. ");
INSERT INTO stb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bu' ginumawas puli' si Pilato bu' miktalu' tu senilan, “Enlengay niyu, pigawas'u giin puli' rini seniyu arun pe'ita'u seniyu ne nda'irun gairing mi'ita'u neng mibaalen nek sayep.” ");
INSERT INTO stb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Aas ginumawas si Jesus neng mikseluk ne kuruna ned dugiyan ri se guluun bu' mikesuub neng melagemlagem. Miktalu' rayun si Pilato senilan, “Enlengay niyu getaw keni.” ");
INSERT INTO stb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sek pekiita' seniin ne nga geseg ne ngak pari' bu' se nga guwardiya sek Templo, mimbeksay ilan, “Lensangen giin tu se krus! Lensangen giin tu se krus!” Miktalu' rayun si Pilato senilan, “Uwan niyu giin bu' gamu naing medlansang ri seniin tu se krus ay para senaan, nda'iruning mi'ita'u ne keterengan nek silutan'u giin.” ");
INSERT INTO stb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Miksembag ri seniin su ngag Judeo, “Duuni kesugu'an nami bu' sumala' ri se kesugu'an ne mbaya' giin nek petain tendeng ay migangken giin neg Bata' raw giin ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Sek pekerengeg run nini ni Pilato, miksamet su gendeken. ");
INSERT INTO stb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bu' mipuli' giin ritu sek palasyu bu' sinaakaan si Jesus, “Ta'a ma gaid migbuwat.” Ma'ad nda' peksembag si Jesus. ");
INSERT INTO stb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Aas miktalu' si Pilato seniin, “Lama ndi'a mektalu' run senaan? Nda'a ba mekesuun ned duuni ketenged'u sek pegbeluy bu' pekpelansang seni'a ri se krus?” ");
INSERT INTO stb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Sinembag giin ni Jesus, “Nda' siya kega'em mu ri senaan bu' nda' pa ini begay ri seni'a ned Diwata. Aas su getaw neng mikpiyal senaan riin seni'a gembagel pa kampuun suk sala'en lungkan seni'a.” ");
INSERT INTO stb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sek pekerengeg run itu ni Pilato minengaw pa gaid giin nek pa'agi ne mbeluyaan si Jesus. Ma'ad mimbeksay su ngag Judeo, “Bu' beluyan mu giin, gena'a sambat ne Dlabaw Gari' ay isan ta' neng megari'ari' kuntra ne Dlabaw Gari'.” ");
INSERT INTO stb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sek pekerengeg run itu ni Pilato, inuwiten si Jesus tu se gawas bu' migingkud giin tu se gingkuran se gukuman ne iningelanan nek “Platapurma neg Batu.” Ri seg Hebreo nek tinuntulan tinawag ini ne Gabata. ");
INSERT INTO stb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na, taran taasendaw na itu se gendaw nek pekpengandam sek pekse'ulug sek Paska. Miktalu' rayun si Pilato tu se ngag Judeo, “Enlengay niyu, keni na su gari' niyu.” ");
INSERT INTO stb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aas mimbeksay ilan rayun, “Petain giin! Petain giin! Lensangen giin tu se krus.” Miksaak si Pilato senilan, “Liyagan ba niyu nek pelansang'u tu se krus su gari' niyu?” Miksembag su nga geseg ne ngak pari', “Nda'irun nai dlain pa ne gari' nami gawas su Dlabaw Gari'.” ");
INSERT INTO stb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aas piniyal rayun ni Pilato senilan si Jesus arun lensangen nilan giin tu se krus. Aas inuwan nilan si Jesus. ");
INSERT INTO stb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ginumawas giin neng mikpisaan ne krus bu' minateng tu “Se dlugar ne iningelanan nek Tulaan Gulu.” (Seg Hebreo nek tinuntulan, iningelanan ini ne “Golgota,”) ");
INSERT INTO stb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ne ritu nilan linansang si Jesus se krus. Duun remaid duwa' dlai ne dlinansang nilan tu se krus, diin se kada gilid ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bu' miksulat si Pilato nek pesuun bu' pibetangen ini tu se krus ni Jesus. Giin nini suk sinulaten: “Si Jesus nek taga Nazaret, su Gari' ne ngag Judeo.” ");
INSERT INTO stb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Aas keni nek pesuun, melaun ne ngag Judeo, sung mikebasa run nini tendeng ay su dlugar ne dlinensangan riin ni Jesus megaud ra ri sek siyudad; bu' sinulat itu sek tinuntulan neg Hebreo, Latin, bu' Griego. ");
INSERT INTO stb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Aas su nga geseg ne ngak pari' miktalu' riin ni Pilato, “Ndi' mu sulatay, ‘Gari' ne ngag Judeo,’ bu' ndi', ‘Miktalu' giin, Gaku' su Gari' ne ngag Judeo.’” ");
INSERT INTO stb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Miksembag si Pilato, “Bu' landunik pisulat'u ndi' na me'eseb.” ");
INSERT INTO stb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Aas su ngak sundalu, seng milansang na nilan si Jesus tu se krus, inuwan nilan suk suuben bu' binahinbahin se gepaat neg bahin, sala bahin se kada sundalu. Inuwan rema nilan sung metaas nek suuben. Na, sung metaas nek suuben nda'ik tinai'aan bu' tinibuuk suk pegabel run. ");
INSERT INTO stb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aas su ngak sundalu miktalu' tu se ngak sementaun nilan, “Ndi' ta ini bedditen; ma'ad ripaan ta ini arun mesuunan ta'ing mekaangken run nini.” Mihitabu' ini arun metuman suk tinalu' ri se kesulatan: “Binahinbahin nilan suk suub'u bu' rinipaan nilan sung metaas nek suub'u.” Aas giin nini sug binaal nu ngak sundalu. ");
INSERT INTO stb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na, ritu seng megaud ne krus ni Jesus migindeg su gina'en, suk pated ne gina'en, si Maria nek sawa ni Clopas, bu' si Maria Magdalena. ");
INSERT INTO stb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sek pekiita' ni Jesus se gina'en bu' sek pinetailen nek tinu'unan neng migindeg ritu, miktalu' giin tu se gina'en, “Ina', enlengay mu, giin sug bata' mu.” ");
INSERT INTO stb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Miktalu' rayun giin tu sek tinu'unaan, “Enlengay mu, giin su gina' mu.” Bu' dluwat itu, inuwan giin nuk tinu'unan arun mekengel tu seg balain. ");
INSERT INTO stb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Peketubus ini, seng misuunan ni Jesus ne su dlaunen mitapus na bu' mituman na sung misulat ri se kesulatan, miktalu' giin, “Kinumenu.” ");
INSERT INTO stb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ritu duuni dya'ung neng mipenu' neng mesem ne ginumen. Linebul nilan dayun sug ispungha ri se ginumen, tinangen ri sek patal ne gayu ne giningelanan neg isupu, bu' tinenggal ri sed demumug ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Aas seng mi'eksep na ni Jesus su ginumen, miktalu' giin, “Mitubus na!” Mbuus middungkuk giin bu' binektusan. ");
INSERT INTO stb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mbuus su nga geseg nu ngag Judeo migandyu' riin ni Pilato nek pembeli'en nilan su nga geksud nu nga getaw ne dlinansang tu se nga krus, bu' uwa'en ilan ritu. Inandyu' nilan ini tendeng ay gendaw itu neg Birnis, bu' ndi' nilan liyagan neng mekpebilin su ngag bangkay ritu se nga krus se Gendaw nek Pengulali, tendeng ay bala'an gaid ini ne gendaw. ");
INSERT INTO stb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aas, miritu su ngak sundalu bu' pimbali' nilan su nga geksud nud duwa' dlai ne dlinansang nek sementaun ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma'ad sek peddateng nilan riin ni Jesus, mi'ita' nilan neng minatay na giin. Aas nda' na ma'aray nilan beli'ay su nga geksuren. ");
INSERT INTO stb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma'ad suk sala se ngak sundalu, siniyuken nek teliyaman su gilid ni Jesus bu' sek tikmal mikigis sud dugu' neng milemugan nek tubig. ( ");
INSERT INTO stb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Bu' su getaw neng mikiita' landuning mihitabu' riin ni Jesus mikpemetuud, bu' suk pekpemetuuren metuud. Bu' su getaw, neng mikesuun seng metuud, migasuy arun mektu'u amu rema.) ");
INSERT INTO stb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mihitabu' ini arun metuman sung misulat ri se Kesulatan, “Nda'iruni ngag bekegen ne mbali'.” ");
INSERT INTO stb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bu' duun pa gairing misulat ri se Kesulatan, “Enlengan nilan su getaw nek siniyuk nilan.” ");
INSERT INTO stb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Na dluwat itu, si Jose nek taga Arimatea nek tinu'unan ni Jesus ma'ad mi'edlurik peketinu'unaan tendeng ay minendek giin se nga geseg ne ngag Judeo, inubugen si Pilato ne uwanenen sug bangkay ni Jesus tu se krus. Tinugutan giin ni Pilato. Aas inuwanen sug bangkay ni Jesus buwat tu se krus. ");
INSERT INTO stb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Bu' middunut rema riin ni Jose si Nicodemo. Si Nicodemo giin su guna neng miritu ni Jesus saanay gebii. Miguwit giin nek pidlamug nek pegemut neng mira bu' aloe, medlima pulu' kiluig begaten. ");
INSERT INTO stb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inuwan nilan sug bangkay ni Jesus bu' pinutus nilan ini nek penepeten ne dlinu duma sek pegemut. Ay giin nini sung mibetasan ne ngag Judeo bu' medlebeng neng minatay. ");
INSERT INTO stb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na, ditu se dlugar ne dlinensangan riin ni Jesus, duunik pigimulanan, bu' ritu, duunik salabuuk neg begu ne dlangeb nek pedlebengan, ne nda' pa gaid melebengay. ");
INSERT INTO stb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Aas tendeng ay gendaw itu sek pekpengandam ne ngag Judeo para se Gendaw nek Pengulali, bu' tendeng ay megaud rema tu se kelebengan, ritu nilan binetang sug bangkay ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na, se guna gendaw nek simana, puti' relaagan pa, miritu si Maria Magdalena se kelebengan. Peddatengen ritu, mi'ita'en ne suk tinampeng tu sed dungawan nek pedlebengan mi'awa' na. ");
INSERT INTO stb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aas ginumebek giin arun esuyan si Simon Pedro bu' sud duma pa nek tinu'unan nek pinetail ni Jesus. Peddatengen ritu, miktalu' giin senilan, “Inuwan nilan tu se dlebeng su Ginu'u, bu' nda' ami mekesuun bu' ta' nilan giin binetang.” ");
INSERT INTO stb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Aas miritu si Pedro bu' su dlain nek tinu'unan ritu se dlebeng. ");
INSERT INTO stb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Minggebek ilan duwa' ma'ad mesekeg kampuun gumebek suk sala sinangkali' ni Pedro. Aas guna giin minateng tu se dlebeng. ");
INSERT INTO stb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Peddatengen ritu, middungkuk giin bu' mi'ita'en suk penepeten ne nga dlinu. Ma'ad nda' giin seled. ");
INSERT INTO stb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Rayun, minateng rema si Simon Pedro neng miksunud ri seniin, bu' sinumeled rayun tu se dlebeng. Mi'ita'en suk penepeten ne dlinu neng mi'imetang ritu, ");
INSERT INTO stb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","bu' suk penepeten nek pinutus ri se gulu ni Jesus, nda' meruma sek penepeten ne dlinu neng mi'imetang ritu ma'ad mipain na neng mipilu' ri sek sala dlugar. ");
INSERT INTO stb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Rayun suk sala nek tinu'unan, su guna neng minateng ritu se dlebeng, sinumeled rema. Seng mi'ita'en, miktu'u giin. ( ");
INSERT INTO stb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ay nda' ilan pa mekesabut ri se kesulatan neng miktalu' kina'enlan metubu' giin puli' buwat se kemetain.) ");
INSERT INTO stb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Aas minuli' rayun su ngak tinu'unan. ");
INSERT INTO stb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Na, si Maria mikpegindeg pa ritu se gawas ne dlebeng neng miksegaw. Saanain meksegaw, middungkuk giin bu' migenleng tu se dlebeng, ");
INSERT INTO stb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","bu' mi'ita'en ned duunid duwa' tawan neg anghel ritu sek seled neng minuub ne gemputi'. Ritu ilan migingkud seng mi'imetangan neg bangkay ni Jesus. Suk sala migingkud diin rapit se guluwan bu' suk sala diin rapit sek sikwayan. ");
INSERT INTO stb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Sinaakan nu ngag anghel si Maria, “Eddang, lama meksegaw'a run?” Miksembag si Maria, “Duuning minuwan seg bangkay ne Ginu'uu bu' nda'u mekesuun bu' ta' nilan binetang.” ");
INSERT INTO stb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Seng mitalu'en itu, midlingay rayun giin bu' mi'ita'en si Jesus neng migindeg ritu, ma'ad nda'en me'ilala ne si Jesus masi' itu. ");
INSERT INTO stb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Miksaak si Jesus ri seniin, “Eddang, lama meksegaw'a run? Ta' baik pinengaw mu?” Miktu'u si Maria ne giin sung migatiman ri sek pigimulanan ritu, aas miktalu' giin seniin, “Bu' dya'a sung minuwan seniin, sir, esuyay mau bu' ta' mu giin binetang ay uwanen'u giin.” ");
INSERT INTO stb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Miktalu' si Jesus ri seniin, “Maria!” Bu' migatubang si Maria riin ni Jesus, bu' miktalu' seg Hebreo nek tinuntulan, “Rabboni!” (neg be'et pesabut, Menintulu'). ");
INSERT INTO stb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Miktalu' si Jesus ri seniin, “Ndi'a pegawid senaan ay nda'u pa mekepuli' ritu se Gama'u. Ma'ad laway mu su ngak pated'u bu' esuyay mu ilan ne mpuli'u na tu se Gama'u bu' Gama' rema niyu, ritu sed Diwatau bu' Diwata rema niyu.” ");
INSERT INTO stb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Aas linawan ni Maria Magdalena su ngak tinu'unan ni Jesus, bu' inesuyaan ilan rayun neng mi'ita'en su Ginu'u bu' landunik tinalu' ni Jesus riin seniin. ");
INSERT INTO stb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Aas seng mesilemsilem na sed Duminggu ketu, miktipung su ngak tinu'unan bu' tinerangkaan nilan su ngad dungawan tendeng se gendek se nga geseg ne ngag Judeo. Minateng rayun si Jesus bu' migindeg ritu sek titenga' nilan. Miktalu' giin, “Su kelinaw mperiin seniyu.” ");
INSERT INTO stb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Peketubusen nini esuyay, pi'ita'en senilan su nga gemegen bu' su giliren. Bu' pidleliyag gaid su ngak tinu'unaan sek pekiita' nilan ri se Ginu'u. ");
INSERT INTO stb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Bu' miktalu' puli' si Jesus senilan, “Su kelinaw mperiin seniyu, maa' ne Gama' neng miksugu' senaan, aas sugu'en'u amu rema.” ");
INSERT INTO stb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Peketubusen mektalu' run itu, iniyupaan ilan rayun bu' miktalu', “Dawat niyu su Gispiritu Santu. ");
INSERT INTO stb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bu' pasayluun niyu su ngak sala' ne nga getaw, pasayluun ilan. Bu' ndi' niyu ilan pasayluun, ndi' ilan mpasaylu.” ");
INSERT INTO stb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Si Tomas, suk sala se ngak sepulu' bu' ruwa' ne ngak tinu'unan ni Jesus bu' iningelanan rema ne Gapid, nda' meruma senilan sek peddateng ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Aas inesuyan giin nud duma ne ngak tinu'unan, “Mi'ita' nami su Ginu'u ta.” Ma'ad miktalu' si Tomas senilan, “Bu' ndi'u me'ita' bu' mbetang suk tendu'u ri se ngak pali' neg biniyanan ne dlansang ri se ngak palaren, bu' mbetang su gemeg'u ri se giliren, ndi'u gaid mektu'u.” ");
INSERT INTO stb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sek peketubus nek sala simana, miktipung puli' su ngak tinu'unan ni Jesus, bu' duma na nilan si Tomas. Tinerengkaan nilan su ngad dungawan neg balay, ma'ad minateng bu' migindeg si Jesus riin sek titenga' nilan. Miktalu' giin senilan, “Su kelinaw mperiin seniyu.” ");
INSERT INTO stb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Rayun miktalu' giin riin ni Tomas, “Betang mu suk tendu' mu rini bu' enlengay mu su nga gemeg'u. Bu' etat mu su gemeg mu bu' betang mu ri se gilid'u. Ndi'a na pedduwa'ruwa' tumu' pektu'ua.” ");
INSERT INTO stb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Miktalu' si Tomas ri seniin, “Ginu'uu bu' Diwatau!” ");
INSERT INTO stb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Miktalu' rayun si Jesus ri seniin, “Miktu'ua ba tendeng ay mi'ita' mau na? Pedleliyagen gupiya su nga getaw neng miktu'u ri senaan isan nda'u nilan me'ita'.” ");
INSERT INTO stb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Aas ri se dlain neg bahin, melaun pa gaid ne nga ketingelaan nek pimbaal ni Jesus ri seng metungenga'an ne ngak tinu'unaan ne nda' mesulat ri se dlibru keni. ");
INSERT INTO stb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma'ad sinulat ini arun gamu mektu'u ne si Jesus giin sung Misiyas, sug Bata' ned Diwata. Bu' pebiyan sek pektu'u niyu ri seniin, duuni ketubu' niyu. ");
INSERT INTO stb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tubus ini, mikpe'ita' puli' si Jesus tu se ngak tinu'unaan ritu se geksid ned danaw nek Tiberias. Na, giin nini sung mihitabu': ");
INSERT INTO stb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Midlumpuk ilan ritu, gilan si Simon Pedro, si Tomas ne giningelanan rema ne Gapid, si Natanael nek taga Cana nek sakup se Galilea, su nga gembata' ni Zebedeo, bu' duun pa gairid duwa' nek tinu'unan ni Jesus. ");
INSERT INTO stb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mbuus, miktalu' si Simon Pedro tu se ngak sementaunen, “Menginsera'u.” Miktalu' ilan rema, “Meddunut ami seni'a.” Aas sinumakay ilan tu sek sekayan. Ma'ad se gebii ketu nda'irun gairi dlaam nilan. ");
INSERT INTO stb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na, seng meksebang nai gendaw, duuning mi'ita' nilan neng migindeg ritu se geksid ned danaw. Ma'ad nda' ilan mekesuun ne si Jesus itu. ");
INSERT INTO stb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Miktalu' si Jesus ri senilan, “Ngak sambat, duun baing milaaman niyu?” Miksembag ilan, “Nda'irun gaid.” ");
INSERT INTO stb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Miktalu' giin senilan, “Tikpu' niyui dlaya niyu ri sed dapit dlintu nek sekayan, bu' duuning melaaman niyu.” Aas tinikpu' nilan su dlaya nilan. Pegbinteng nilan, ndi' na nilan meraag pagaw ritu sek sekayan tendeng se kelaun nek sera' neng milaaman nilan. ");
INSERT INTO stb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Miktalu' riin ni Pedro suk tinu'unan nek pinetail ni Jesus, “Su Ginu'u masi' itu!” Aas sek pekerengeg run ni Pedro, sineluken puli' suk suuben tendeng ay midluwas suub giin bu' linumeksu ri sek tubig. ");
INSERT INTO stb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma'ad sud duma ne ngak tinu'unan ned ditu sek sekayan mimelula pagaw tu se geksid ned danaw saanay migbinteng se dlaya neng mipenu' ne ngak sera'. Ay gena' ilan melayu' ri se geksid ned danaw—medlima pulu' repa ra run. ");
INSERT INTO stb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Aas seng mikekawas ilan na tu seng mimelaan, duuning mi'ita' nilan nek tiniti' nek sera' ned diin sed dibabaw neg baga ne gapuy, bu' duun remaik pan. ");
INSERT INTO stb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Miktalu' rayun si Jesus senilan, “Peguwit amu rini nek santa' buuk nek sera' neng milaaman niyu.” ");
INSERT INTO stb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Aas minaik si Simon Pedro tu sek sekayan bu' binintengen pe'eksid su dlaya neng mipenu' neng mekebagel ne ngak sera' neng megatus bu' lima pulu' bu' telu su dlaunen. Bu' isan se kelaun neng milaaman nilan, nda' gaid mpurut su dlaya. ");
INSERT INTO stb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Miktalu' si Jesus senilan, “Rini amu arun memahaw.” Nda'irun gaid isan sala neng miksaak bu' ta' gaid giin, ay mikesuun ilan ne giin su Ginu'u nilan. ");
INSERT INTO stb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Miritu rayun si Jesus bu' inuwanen suk pan bu' binegain senilan. Giin remaig binaalen tu sek sera'. ");
INSERT INTO stb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na, ketelu bisis na ini neng mikpe'ita' si Jesus tu se ngak tinu'unan dluwat giin mitubu' puli' buwat se kemetain. ");
INSERT INTO stb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Peketubus rayun nilan memahaw, miktalu' si Jesus riin ni Simon Pedro, “Simon bata' ni Juan, pinetail mau ba labaw pa ri se ngak sementaun mu keni?” “Wa'a, Ginu'u,” miktalu' giin, “mikesuun'a nek pinetail'u dya'a.” Miktalu' si Jesus ri seniin, “Na, ingat mu su nga getaw neng mikpesakup senaan maa' sek pegingat mu ri se ngang nati ne karniru.” ");
INSERT INTO stb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Miktalu' se keruwa' si Jesus ri seniin, “Simon neg bata' ni Juan, pinetail mau ba?” “Wa'a, Ginu'u,” miktalu' giin, “misuunan mu nek pinetail'u dya'a.” Miktalu' si Jesus ri seniin, “Na, ketaay mu su nga getaw neng mikpesakup senaan maa' sek pedlekata mu se nga karniru.” ");
INSERT INTO stb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Miksaak se ketelu neg higayun si Jesus, “Simon neg bata' ni Juan, pinetail mau ba?” Migu'ul si Pedro tendeng ay miksaak si Jesus ri seniin se ketelu, “Pinetail mau ba?” Miksembag si Pedro, “Ginu'u, misuunan mu su dlaun ne ngag betang. Misuunan mu nek pinetail'u dya'a.” Miktalu' si Jesus seniin, “Na, ingat mu su nga getaw neng mikpesakup senaan maa' sek pegingat mu ri se nga karniruu. ");
INSERT INTO stb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sek pekemetuud telu'an'u dya'a, seg begumbata'a pa, dya'a sung mekseluk sek suub mu bu' miritu se isan ta' ne dliyagan mu. Ma'ad bu' dlegulang'a na, perepaan'a na run bu' dlain naing mekpeseluk seni'a nek suub, bu' uwiten'a se dlugar ne gendi' mu liyagan lawan.” ");
INSERT INTO stb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Inasuy ini ni Jesus arun pesuun bu' laa kelesiyay run ne kemetain su gembiyanan ni Pedro, bu' megbegay nek pesiddengeg tu sed Diwata.) Rayun miktalu' si Jesus riin ni Pedro, “Sunud'a ri senaan.” ");
INSERT INTO stb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedlingay ni Pedro mi'ita'en neng miksunud senilan suk tinu'unan nek pinetail ni Jesus. Giin sung miksulalig riin se geddeb ni Jesus sek pekpenihapun nilan bu' miksaak, “Ginu'u, ta' maing medlu'ib ri seni'a?” ");
INSERT INTO stb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Sek pekiita' ni Pedro ri seniin, miktalu' giin riin ni Jesus, “Ginu'u, landun maing mehitabu' ri seniin?” ");
INSERT INTO stb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Miksembag si Jesus ri seniin, “Bu' liyagan'u ne ndi' giin matay tampan sek pekpuli'u, landun mai dlabet mu run? Dya'a, sunud'a ma'aray” ");
INSERT INTO stb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Aas midlelaup su gesuyan tu se ngak sumusunud ri se Ginu'u nek tinu'unan ketu ndi' matay. Ma'ad nda' pektalu' si Jesus ne ndi' giin matay bu' ndi' miktalu' giin, “Bu' liyagan'u ne ndi' giin matay tampan sek pekpuli'u, landun mai dlabet mu run?” ");
INSERT INTO stb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Giin suk tinu'unan neng mikpemetuud ne sung misulat rini metuud, bu' giin rema sung miksulat run nini. Bu' misuunan ta ne suk pekpemetuuren metuud. ");
INSERT INTO stb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Bu' melaun pa ne ngag betang nek pimbaal ni Jesus. Bu' sinulat pa su kada sala, miktu'uu ne suk tibuuk neg benwa ndi' mpe'igu' nek seleran para se nga dlibru nek sinulat.");
INSERT INTO stb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1"," Pinetail'u nek Teofilo, Se guna ne dlibruu, sinulat'u ri seni'a su dlaun neg binaal bu' pimandu' ni Jesus buwat sek pedlegataren runik terbahuun ");
INSERT INTO stb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tampan se gendaw ne inuwit giin tu se dlangit. Se genda' pa giin uwitay tu se dlangit, migbegay giin ne ngang mandu' pibiyan se ga'em ne Gispiritu Santu tu se nga gapustulis nek pimili'en. ");
INSERT INTO stb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Se gepaat pulu' endaw dluwat giin matay, mikpe'ita' giin tu senilan seng melaun nek panahun sek pekpemetuud ne nda'irunik penduwa'ruwa' neng mitubu' giin puli'. Mi'ita' nilan giin, bu' miktuntul giin ri senilan metendeng sek Pedlegari' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bu' saanay mikaan pa si Jesus duma nu nga gapustulisen, migbegay giin neng mandu': “Ndi' amu reli' megawa' rini seg Jerusalem, ma'ad gelatay niyu suk sinaad ne Gama' neng mirengeg niyu buwat ri senaan. ");
INSERT INTO stb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Mimbendyag si Juan ri sek tubig, ma'ad sek santa' endaw bendyagan amu ri se Gispiritu Santu.” ");
INSERT INTO stb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Seng miktipung su nga gapustulis duma si Jesus, sinaakan nilan giin, “Ginu'u, giin na ba ini suk panahun nek pepuli'en mu suk Pidlegeri'an tu seg Israel?” ");
INSERT INTO stb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Miksembag si Jesus ri senilan, “Su ngak panahun bu' nga gendaw inimetang na daan se keliyag ne Gama'u. Ndi' amu mbaya' mekesuun bu' nanu ini mehitabu'. ");
INSERT INTO stb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ma'ad sek peddateng ne Gispiritu Santu riin seniyu, begayan amu ne ga'em. Bu' gamu sung mekpemetuud para ri senaan rini seg Jerusalem, bu' ri sek tibuuk nek probinsiya seg Judea bu' sek Samaria, bu' ri sek tibuuk neg benwa.” ");
INSERT INTO stb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Peketubusen nini telu'ay, pilentu giin tu se dlangit. Bu' saanay nilan megenleng ri seniin, milimeng giin ne ginanud bu' nda' na nilan giin me'ita'. ");
INSERT INTO stb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bu' saanay migenleng ilan pa tu se dlangit, enlengay niyu, duunid duwa' tawan ne dlai neng migindeg ri seng megaud nilan ne gemputi'i ngak suub nilan, ");
INSERT INTO stb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","miktalu' ilan, “Gamu nek taga Galilea, lama megindeg amu pa run rini neng minggangag tu se dlangit? Ay sug Jesus neng mi'ita' niyu neng mikperitaas ritu se dlangit, mpuli' rini seng maa' run nek pebiyan neng mi'ita' niyu sek pekperitaas ri seniin tu se dlangit.” ");
INSERT INTO stb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Rayun mipuli' su nga gapustulis seg Jerusalem buwat seg bentud ne ngag Olibo. Bentud keni meksala kilumitru su dlayu'en buwat sek siyudad. ");
INSERT INTO stb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Peddateng nilan ritu sek siyudad, minaik ilan ritu se kuwartu sed ditaas balay nek pinaikan nilan: Gilan ni Pedro, Juan, Santiago bu' Andres, si Felipe bu' si Tomas, si Bartolome bu' si Mateo, si Santiago neg bata' ni Alfeo, si Simon neng mikpetail ri seng nasuren, bu' si Judas neg bata' ni Santiago. ");
INSERT INTO stb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kanunay ilan mektipung arun sek pegampu'. Duma rema nilan su nga dlibun dlabet na si Maria ne gina' ni Jesus bu' duma su ngak pateren ne dlai. ");
INSERT INTO stb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Bu' minayan suk santa' endaw, saanay miktipung su ngang megatus bu' ruwa' pulu' ne ngang mektetu'u, migindeg si Pedro bu' miktalu', ");
INSERT INTO stb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nga kepeteran, kina'enlan metuman suk tinalu' ri se Kesulatan ne su Gispiritu Santu mingatuk pebiyan riin ni David, bu' landunik tinalu'en metendeng riin ni Judas. Si Judas keni, giin sung migunut sek peddaap riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sementaun giin nami tendeng ay pinili' giin ni Jesus sek pekpenibeli gisip gapustulis.” ( ");
INSERT INTO stb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na, si Judas ketu sinumaluy ne dlupa' ginamiten su kuwarta neg binayad seniin tendeng seng melaat neg binaalen. Miladdu' giin neng miguna su guluun bu' migbetu suk tiyanen bu' ginumawas suk tinainen. ");
INSERT INTO stb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Mirengegan ini ne dlaunan ne nga getaw seg Jerusalem, aas iningelanan nilani dlugar ketu, ri sek tinuntulan nilan, neg Akeldama, neg be'et pesabut “Dlupa' neng Mirugu'an.”) ");
INSERT INTO stb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ay misulat ini ri se dlibru ne ngak Salmo, ‘Mbaal siya ne genda'iruni getaw ri seg balain; bu' nda'irun siyaik pepekengelen ritu.’ “Bu' misulat rema, ‘Duun siyaik sumukli ri seniin ri se ketendanaan.’ ");
INSERT INTO stb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Aas kina'enlan ned duunik sala tawan neng medduma ri senami arun mekpemetuud neng mitubu' puli' si Jesus ne Ginu'u. Kina'enlan kanunay giin mikeddunut ri senami seled sek panahun ne si Jesus ne Ginu'u midduma pa ri senita buwat sek panahun sek pegbendyag ni Juan riin ni Jesus tampan sek panahun neng mikperitaas si Jesus tu se dlangit.” ");
INSERT INTO stb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aas duwa' tawan ne dlai suk pimili'an nilan: si Jose ne giningelanan neg Barsabas (neng mi'ilelaan rema neg Justus), bu' si Matias. ");
INSERT INTO stb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mbuus migampu' ilan, “Ginu'u, dya'a sung mikesuun ri se gena'ena' ne kada sala, aas pe'ita' mu ri senami bu' ta' ri senilan duwa' suk pinili' mu ");
INSERT INTO stb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","neng menibeli bu' sumukli ri ni Judas sek pekegapustulis tendeng ay si Judas miritu se dlugar ne gembaya' ri seniin.” ");
INSERT INTO stb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Rayun migripa ilan sek pekpili' ri senilan duwa', bu' si Matias sung miripaan nilan, ne giining mirugang tu sek sepulu' bu' sala ne gapustulis. ");
INSERT INTO stb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Sek peddateng na ne gendaw sek pekse'ulug sek tinawag nek Pentecostes, miktipung su dlaun ne ngang mektetu'u ri sek sala ne dlugar. ");
INSERT INTO stb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sek tikmal duuning middegene' neg buwat ri se dlangit neng maa' neng meseleg ne genus, bu' isan ta' tu seg balay ne ritu ilan migingkud mikerengeg ri sed degene'. ");
INSERT INTO stb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mbuus duuning mi'ita' nilan ne ngang midliga' maa' ne ngad dila' ne ritu se dlaun ned dapit bu' miksi'entud ri sek salasala senilan. ");
INSERT INTO stb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dlaun nilan pige'eman se Gispiritu Santu bu' migatad ilan mektuntul se dlainlain nek tinuntulan sumala' sek pituntul ri senilan se Gispiritu. ");
INSERT INTO stb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na, duuni ngag Judeo neng mikengel ri seg Jerusalem, neng melituuren ri sed Diwata neg buwat se kada ne ngang nasud ri sek tibuuk neg benwa. ");
INSERT INTO stb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pekerengeg nilan ned duuning middegene', miksempun ilan meritu sek piktipungan ne ngang mektetu'u. Mitingala ilan gupiya tendeng ay suk salasala ri senilan mikerengeg ri se gegulingen nilan ne ngak tinuntulan ne ginasuy ne ngang mektetu'u. ");
INSERT INTO stb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Se kebagel ne ketingala, miktalu' ilan, “Nga getaw keni neng miktuntul neng maa' nini, nga getaw Galilea! ");
INSERT INTO stb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mikendun ma neng mirengeg ta ma neng meketuntul ilan ri se gegulingen ta ne ngak tinuntulan? ");
INSERT INTO stb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Gita buwat sek Partia, Media, bu' Elam; sud duma taga Mesopotamia, Judea bu' Capadocia; sud duma taga Puntus bu' Asia; ");
INSERT INTO stb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","sud duma taga Frigia, ngak taga Pamfilia, ngak taga Ehipto bu' su ngad duma buwat se nga dlugar nek sakup sed Libya neng megaud sek Cirene. Duun remaik taga Roma, ");
INSERT INTO stb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ngag Judeo bu' dlain ne nga getaw neng mi'uwit seg rilihiyun ne ngag Judeo. Bu' sud duma buwat se Crete bu' Arabia. Ma'ad dlaun ta mikerengeg ri senilan neng miktuntul ri se nga gegulingen ta nek tinuntulan metendeng ri se nga ketingelaan ne ngag betang neg binaal ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mitingala bu' midlibeg gaid su dlaun ne nga getaw ritu. Bu' miksesaakay ilan ra run sek salasala ri senilan, “Landun maig be'et pesabut run nini?” ");
INSERT INTO stb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ma'ad sud duma middega'rega' tu se ngang mektetu'u neng miktalu', “Nga getaw keni mibeleng.” ");
INSERT INTO stb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mbuus migindeg si Pedro duma nu ngak sepulu' bu' sala ne nga gapustulis bu' seng mesekeg nek talu' migasuy giin tu se nga getaw, “Nga kepeteran'u ne ngag Judeo, bu' dlaun niyu neng mikengel seg Jerusalem, penginengeg amu bu' asuy'u ri seniyu bu' landuni gulugaan nini. ");
INSERT INTO stb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nga getaw keni gena' mibeleng tendeng ay miginenga' menaik pai gendaw. ");
INSERT INTO stb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ma'ad giin nini su ngag betang nek tinalu' ni propeta Joel: ");
INSERT INTO stb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Giin nini sug baalen'u se katapusan ne nga gendaw, miktalu' sud Diwata: begay'u su Gispirituu se kada getaw. Megasuy seng minsahiu su ngag bata' niyu ne dlai bu' dlibun; mekiita' su nga gembata' niyu nga dlai se ngak pe'ita', bu' mekteginep su nga dlegulang niyu ne nga dlai. ");
INSERT INTO stb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Bu' isan su ngak sesugu'en'u, ne nga dlai bu' nga dlibun, begay'u su Gispirituu se ngak panahun ketu, bu' megasuy ilan seng minsahiu. ");
INSERT INTO stb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Megbaalu ne ngang milagru riin se dlangit bu' nga ketingelaan rini se dlupa'. Duun mbuusid dugu', gapuy, bu' merikpel ne gebel; ");
INSERT INTO stb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","dumelemi gendaw, bu' sug bulan meksipula neng maa' ned dugu', se gendi' pa mateng su gimpurtanti gupiya ne Gendaw ne Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Bu' rayun, isan ta' ne getaw neng mektawag ri se ngalan ne Ginu'u para mekpe'abang meluwas.’” ");
INSERT INTO stb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Nga kepeteran'u ne nga getaw Israel, penginengegay niyau! Si Jesus ne getaw Nazaret pi'ilala ri seniyu ay binegayan giin nek pedlegeseg pibiyan se ngang milagru bu' nga ketingelaan ne ngag betang neg binaal ned Diwata pibiyan riin ni Jesus. Gamu mismu mikesuun run nini tendeng ay dlaunen keni mihitabu' ri sek titenga' niyu. ");
INSERT INTO stb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Sud Diwata, sumala' ri se gegulingenen nek pelanu bu' keliyag, mikpiyal ri ni Jesus riin seniyu. Pipatay niyu giin pibiyan sek pekpiyal niyu ri seniin tu se ngang mekesesala' ne gilan sung midlansang ri seniin tu se krus. ");
INSERT INTO stb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ma'ad pitubu' giin puli' ned Diwata bu' linuwasen buwat se ga'em se kemetain tendeng ay ndi' giin mpegengan run nini. ");
INSERT INTO stb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ay si David miktalu' metendeng ri seniin, ‘Mi'ita'u su Ginu'u ri seng metungenga'an'u se dlaun nek panahun; megaud giin ri senaan bu' ndi'u megules. ");
INSERT INTO stb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Aas, pidleliyagu gupiya, bu' miktuntulu neng mipenu' ri se dleliyag. Bu' gaku', isan metuud matay, duun paik pedderemau, ");
INSERT INTO stb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tendeng ay ndi' mau peseddanen tu se dlebengan; ndi' mu tugut neng melasak sung metinuuren nek sesugu'en mu tu se dlebeng. ");
INSERT INTO stb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pi'ita' mu ri senaan su ngag biyanan neng megunut tu se ketubu', bu' tendeng sek peddunut mu ri senaan, pedleliyagenu gaid.’” ");
INSERT INTO stb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nga kepeteran, kina'enlan neng mektalu'u ri seniyu se kelaru metendeng ri se gepu'an ta ne si Gari' David. Minatay giin bu' linebeng, bu' su dlebengen rini pa senita tampan numuun. ");
INSERT INTO stb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Propeta si David bu' misuunaan landunik sinaad ned Diwata ri seniin. Minumpa' sud Diwata ned duunik sala neg buwat ri se gasalen nek sumukli ri sek pedlegari'. ");
INSERT INTO stb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Mi'ita' ni David landunig baalen ned Diwata lema' lenlag, aas migasuy giin metendeng ri sek peketubu' puli' seng Misiyas seng miktalu' giin, ‘Nda' giin peseddanay ritu se dlebengan; bu' su dlawasen nda' melasak ritu.’ ");
INSERT INTO stb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Si Jesus keni, giin suk pitubu' puli' ned Diwata bu' gami sung mikepemetuud run nini. ");
INSERT INTO stb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pitaas giin tu sed dapit dlintu ned Diwata, su Gama'en, bu' mirawat buwat ri seniin su Gispiritu Santu nek sinaad ne Gama' ne giin su genda' pedlekulang neg begay para ri senita maa' seng mi'ita' bu' mirengeg niyu nemuun. ");
INSERT INTO stb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ay gena' si David sung minaik tu se dlangit. Tumu' miktalu' giin mismu: ‘Su Ginu'u miktalu' ri se Ginu'uu: Gingkud'a rini se dlintuu, ");
INSERT INTO stb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tampan daagen'u su nga kuntra mu bu' mpedlegesegan mu ilan.’ ");
INSERT INTO stb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Aas kina'enlan neng mesuunan niyu, nga getaw Israel, ne si Jesus ne dlinansang niyu tu se krus, giinig binaal ned Diwata ne Ginu'u bu' Misiyas.” ");
INSERT INTO stb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sek pekerengeg run nu nga getaw, misemukan ilan gupiya. Aas miksaak ilan riin ni Pedro bu' tu se ngak sementaunen ne nga gapustulis, “Nga kepeteran, landun mai kina'enlan nami baalen?” ");
INSERT INTO stb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Miksembag si Pedro senilan, “Salasala ri seniyu meddiksu' ri se ngak sala' niyu bu' mekpebendyag amu ri se ngalan ni Jesus Christ arun mpasaylu su ngak sala' niyu bu' merawat niyu rema sug begay ned Diwata ne giin su Gispiritu Santu. ");
INSERT INTO stb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ay suk saad ned Diwata para ri seniyu bu' se nga gembata' niyu bu' se dlaun ned ditu seng melayu'—tu se dlaun nek tuwagen ne Ginu'u ned Diwata ta mekpegaud ri seniin.” ");
INSERT INTO stb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mikpeddayun si Pedro sek pekpemetuud ri senilan bu' seng melaun ne ginasuyen, inandyu'en ilan, laungen, “Luwas niyui gegulingen niyu buwat ri sek silut neng mateng ri seng mekelaat ne getaw keni.” ");
INSERT INTO stb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Melauning mikpetuud ri seng minsahiin bu' mikpebendyag ilan rayun. Ngak telu libu nga getaw sung mirugang ri se ngang mektetu'u se gendaw ketu. ");
INSERT INTO stb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bu' mikpeddayun ilan sek pektu'un buwat se ngak pimandu' ne nga gapustulis, sek peksalabuuk duma senilan, sek pekpetapeta nek pan duma se senilan, bu' se ngak pegampu'. ");
INSERT INTO stb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Melaun ne ngang milagru bu' nga ketingelaan ne ngag betang sug binaal ned Diwata pibiyan ri se nga gapustulis. Bu' tendeng run nini mitingala su dlaun ne nga getaw duma se gendek ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Su dlaun neng mektetu'u mikpeddayun ilan ri sek peksalabuuk bu' tiningeb nilan su ngag betang nilan arun megamit se dlaun nilan, ");
INSERT INTO stb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","neg be'et pesabut nek pimeledya' nilan su nga dlupa' bu' ngag betang nilan bu' pingaperaped nilan su galin tu se dlaunan sumala' sek pengina'enlan nek salasala. ");
INSERT INTO stb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mikpeddayun ilan sek pektipung ritu sek Templo bu' miksalabuuk ilan sek pekpengaan ritu se ngag balay nilan ned duuni dleliyag bu' pekemelituuren. ");
INSERT INTO stb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Sinaya' nilan sud Diwata bu' pidleliyag ri senilan su dlaun ne nga getaw. Bu' kada gendaw dinugang ne Ginu'u ri senilan su nga getaw neng miluwas. ");
INSERT INTO stb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na, minaik si Pedro bu' si Juan sek Templo seng meginenga' menaugi gendaw, guras itu sek pegampu'. ");
INSERT INTO stb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bu' duuni getaw neg bekul buwat pa ri sek pegegetaun, bu' kada ne gendaw pegewiten giin ditu se “Genga'an ne giningelanan neng Melengas” arun mekpelimus tu se nga getaw nek sumeled tu sek Templo. ");
INSERT INTO stb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sek pekiita'en run si Pedro bu' si Juan nek sinumeled tu sek Templo, minengi giin ne dlimus. ");
INSERT INTO stb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tinenteng giin ni Pedro bu' ni Juan. Mbuus miktalu' si Pedro ri seniin, “Genleng'a ri senami.” ");
INSERT INTO stb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Migenleng su getaw ri senilan neng migelat ne dlimusan giin. ");
INSERT INTO stb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ma'ad miktalu' si Pedro ri seniin, “Nda'irun gairik selapi'u. Ma'ad landunid diin senaan, begay'u ri seni'a. Ri se ngalan ni Jesus Christ nek taga Nazaret, gindeg'a bu' dlaang'a.” ");
INSERT INTO stb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Mbuus inewiran ni Pedro su dlintu ne gemeg nu getaw bu' pi'indegen giin. Sek tikmal miksisekeg na rayun su nga geksuren bu' nga dlelengu'aan. ");
INSERT INTO stb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Rayun linumeksu, migindeg giin bu' midlaanglaang. Peketubus middunut giin ri senilan sek pekseled tu sek Templo. Mikpeddayun giin sek pedlaanglaang, bu' midleksuleksu, bu' miksaya' ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mi'ita' giin nu dlaunen neng midlaanglaang bu' miksaya' ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mi'ilala nilan ne giin su getaw neng mikpegingkud bu' mikpelimus ritu seng “Melengas ne Genga'an” nek Templo. Aas mitingala ilan gaid gupiya bu' ndi' ilan meketu'u seng mihitabu' ri seniin. ");
INSERT INTO stb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na, saanay mingawid riin ni Pedro bu' ni Juan sug bekul neng mitelen, su dlaun ne nga getaw mitingala bu' minggebek tu senilan se dlugar ne giningelanan neg Balkun nek Penilungan ni Solomon. ");
INSERT INTO stb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Sek pekiita' ni Pedro se nga getaw miktalu' giin ri senilan, “Ngak sementaun'u nek taga Israel, tuma ma metingala amu run nini? Lama mektenteng amu run ri senami? Migena'ena' amu ba neng mipelaang nami getaw keni tendeng se ga'em bu' pekelengas nami ri seng metungenga'an ned Diwata? ");
INSERT INTO stb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Sud Diwata nek sinimba ni Abraham, ni Isaac, ni Jacob, bu' ne nga gepu'an ta neng mikpesiddengeg sek Sesugu'enen ne si Jesus. Ma'ad tinudyan niyu giin tu se nga getaw ned diin sek pengetendanan bu' binibay niyu giin ri seng metungenga'an ni Pilato, isan mi'ukumaan na neg beluyan giin. ");
INSERT INTO stb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Bala'an bu' metareng giin ma'ad binibay niyu giin, bu' inandyu' pa gaid niyu riin ni Pilato neg beluyan suk sala tawan neng mematay ne getaw. ");
INSERT INTO stb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pinatay niyu suk sala neng mikegbegay ne ketubu', ma'ad pitubu' giin puli' ned Diwata buwat se kemetain. Bu' mekepemetuud ami run nini. ");
INSERT INTO stb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Su ga'em ri se ngalanen neng migbegay nek sekeg ri se getaw keni neg bekul. Landuning mi'ita' bu' misuunan niyu mibaal pibiyan ri sek pektu'u ri se ngalanen; pebiyan ra ri sek pektu'u riin ni Jesus neng mikepetelen ri seniin, maa' ri seng mi'ita' niyu.” ");
INSERT INTO stb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Bu' nemuun, nga kepeteran'u, mikesuunu ne gamu bu' su ngak pengulu niyu migbaal run nini riin ni Jesus tendeng ay nda' amu mekesuun bu' ta' gaid giin. ");
INSERT INTO stb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pisuun na ned Diwata nud diin nek panahun pebiyan se ngak propeta ne sung Misiyas kina'enlan gaid neng megantus, bu' binaalen neng metuman seng maa' niin nek pebiyan. ");
INSERT INTO stb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Aas meddiksu' amu bu' puli' amu ri sed Diwata arun mpasayluun amu ri se ngak sala' niyu. Bu' baalen niyu ini, begayan amu ne Ginu'u ne ngag begu nek sekeg bu' sugu'en rayun riin seniyu sung Misiyas, si Jesus nek pinili'en na para riin seniyu. ");
INSERT INTO stb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kina'enlan ne ritu reli'ay si Jesus se dlangit tampan mateng suk panahun neg beguun ned Diwata su dlaun ne ngag betang. Giin rema suk pisuun ned Diwata nud diin pebiyan ri seg bala'an ne ngak propeta. ");
INSERT INTO stb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ay si Moses miktalu', ‘Su Ginu'u ned Diwata niyu meksugu' neng meriin seniyu suk salabuuk nek propeta, neng maa' sek peksugu'en ri senaan, bu' migbuwat giin ri se getawan niyu. Kina'enlan tumanen niyu su dlaun nek talu'en ri seniyu neg baalen niyu. ");
INSERT INTO stb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Su gendi' mektuman ri sek propeta ketu gena' na dlabet ri se nga getawan ned Diwata bu' petain gela'.’ ");
INSERT INTO stb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bu' su dlaun ne ngak propeta ned duuning minsahi nilan labet na si Samuel bu' sung miksunud ri seniin mikpesuun rema landuning mihitabu' ri se ngak panahun keni. ");
INSERT INTO stb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Su ngak sinaad ned Diwata pibiyan ri se ngak propetaan para gaid ri seniyu ay mikaambit amu ri se keligenan neg binaal ned Diwata se nga gepu'an ta tendeng ay miktalu' giin riin ni Abraham, ‘Pengumpiyanan'u su dlaun ne nga getaw ri seg benwa pebiyan ri nga gesalan mu.’ ");
INSERT INTO stb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Aas pimili' ned Diwata suk Sesugu'enen bu' pinawiten giin guna riin seniyu arun sek pekpengumpiya ri se kada sala seniyu pebiyan sek pekpebeleng ri seniyu buwat riin sek pekelaat niyu.” ");
INSERT INTO stb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na, seng migasuy pa si Pedro bu' si Juan ri se nga getaw, minateng tu senilan su ngak pari', su kapitan nu nga guwardiya ri sek Templo, bu' su ngak Saduceo. ");
INSERT INTO stb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pinlengetan ilan ay mimandu' ilan duwa' ne si Jesus mitubu' puli' buwat ri se kemetain, neng mikepemetuud ne su ngang mimatay petubu'en puli'. ");
INSERT INTO stb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aas dinaap ilan nilan bu' pinerisu ilan tampan miksikanselem tendeng ay midlegebii na. ");
INSERT INTO stb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma'ad melauning mikerengeg ri seng minsahi miktu'u bu' su dlaun ne nga dlai neng miktu'u mirepet ne dlima libu. ");
INSERT INTO stb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pekemanlema', miktipung su nga gupisyal bu' nga geseg ri se dlunsud, bu' ngang menintulu' ri se Kesugu'an ri seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kinumita' ilan se Dlabaw ne Geseg nek Pari' ne si Anas, bu' si Caipas, si Juan, si Alejandro, bu' sed duma pa neng misakup tu sek pamilya se Dlabaw ne Geseg nek Pari'. ");
INSERT INTO stb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pi'indeg nilan si Pedro bu' si Juan ri seng metungenga'an nilan bu' sinaakan ilan, “Ta' ga'emay run awas ngalan ne ginamit niyu?” ");
INSERT INTO stb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Si Pedro nek pidlegesegan ne Gispiritu Santu miksembag, “Gamu ne nga gupisyal bu' nga geseg ri se dlunsud keni: ");
INSERT INTO stb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","bu' saakan niyu ami nandaw metendeng ri seng melengas neg binaal ditu se getaw neg bekul bu' kendun giin mi'uli'an, ");
INSERT INTO stb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kina'enlan dlaun niyu mekesuun, bu' su dlaun nek taga Israel mekesuun, ne getaw keni neng migindeg rini seng metungenga'an niyu, pitelen giin pibiyan ri se ga'em se ngalan ni Jesus Christ nek taga Nazaret. Giin su dlinansang niyu tu se krus ma'ad pitubu' giin puli' ned Diwata buwat se kemetain. ");
INSERT INTO stb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Jesus, giin suk sala nek tinalu' ri se kesulatan, ‘Sug batu neg binibay ne ngak panday, giini gimpurtanti gupiya se dlaun neg batu.’ ");
INSERT INTO stb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Mbaangan ra riin seniin su keluwasan ay rini seg benwa nda'irun nai dlain ne ngalan neg binegay ned Diwata neng mekeluwas se nga getaw.” ");
INSERT INTO stb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na, seng mi'ita' nilan si Pedro bu' si Juan ne nda' ilan endek sek pegasuy, mitingala ilan ay misuunan nilan ne gilan duwa' yanu ne nga getaw ne genda'iruning metaas nek sinuunaan. Mbuus mi'ilala nilan ne gilan duwa' sementaun ni Jesus. ");
INSERT INTO stb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma'ad nda'irun gairing metalu' nilan, tendeng ay mi'ita' nilan su getaw neng mi'uli'an neng migindeg ritu duma ni Pedro bu' ni Juan. ");
INSERT INTO stb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aas pigawas reli' nilan si Pedro bu' si Juan buwat sek seled seng Metaas ne Gukuman bu' miksabutsabut ilan. ");
INSERT INTO stb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Landun maig baalen ta ri se nga getaw keni?” saak nilan. “Suk salasala rini seg Jerusalem mikesuun neng mikegbaal ilan ne ketingelaan nek penghitabu', bu' ndi' ita meketalu' neg balus ini. ");
INSERT INTO stb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ma'ad arun ndi' na medlelaup suk penghitabu' keni ritu se nga getawan, penegulan ta ilan ne gendi' na mektalu' metendeng ri se ngalan ni Jesus tu se isan ta'.” ");
INSERT INTO stb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bu' pitawag nilan puli' si Pedro bu' si Juan bu' inesuyan ne gendi' ilan na gaid megeseb megasuy awas menendu' ri seng ngalan ni Jesus. ");
INSERT INTO stb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ma'ad miksembag si Pedro bu' si Juan tu senilan, “Pegena'ena' raw niyu gupiya bu' ta' maing metareng ri sek pengenleng ned Diwata: suk pektuman ri seniyu bu' suk pektuman ri sed Diwata? Gamu sung megukum. ");
INSERT INTO stb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ay ndi' mehimu neng melali ami sek pegasuy metendeng ri seng mi'ita' nami bu' mirengeg.” ");
INSERT INTO stb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tendeng run nini, pinegulan ilan gupiya bu' mbuus bineluyan. Nda'iruni keterengan nilan arun silutan ilan ay su nga getaw miksaya' ri sed Diwata tendeng seng mihitabu'. ");
INSERT INTO stb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ay su getaw nek pitelen pebiyan ri seng milagru kapin na gepaat pulu' taun nai giddaren. ");
INSERT INTO stb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Seg bineluyan na si Pedro bu' si Juan, mipuli' ilan tu se ngak sementaun nilan bu' inasuy nilan ri senilan bu' landunik tinalu' ne nga geseg ne ngak pari' bu' nga geseg se dlunsud. ");
INSERT INTO stb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sek pekerengeg nilan run nini, miksalabuuk ilan sek pegampu' ri sed Diwata: “Ginu'u ned Diwata, dya'a sung migbaal ri se dlangit, ri se dlupa', ri sed dagat bu' ri se dlaun neg betang ned diin senilan. ");
INSERT INTO stb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Pebiyan ri se Gispiritu Santu, miktalu'a pebiyan ri se gepu'an nami ne si David, suk sesugu'en mu, seng miktalu' giin, ‘Tuma ma midlanget su nga gena' Judeo? Bu' tuma ma mikpelanu ma su nga getaw se ngag betang ne genda'ik paluun? ");
INSERT INTO stb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Su nga gari' ri seg benwa mingandam ri se gegulingen nilan, bu' su ngak pengulu miktipung arun sumukul ri se Ginu'u bu' ri seng Misiyasen.’ ");
INSERT INTO stb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ay sek pekemetuud, sek siyudad keni, si Herodes bu' si Pilato sinumalabuuk ri se nga gena' Judeo bu' ri se ngak taga Israel kuntra riin ni Jesus, sug Bala'an mu nek Sesugu'en, neg binaal mu neng Misiyas. ");
INSERT INTO stb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Seg binaal nilan ketu, mituman na suk pelanu mu nud diin. Bu' mihitabu' ini sumala' ri se ga'em bu' keliyag mu. ");
INSERT INTO stb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bu' nandaw, Ginu'u, enlengay mu su ngak pekpengulega' neg binaal nilan bu' begayay mu ne kebelu', gami ne ngak sesugu'en sek pektalu' seng minsahi mu. ");
INSERT INTO stb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Etat mu su gemeg mu sek pekpetelen bu' tugut mu ne mbaal siya su ngag betang ne ketingelaan bu' milagru pebiyan ri se ngalan neg bala'an nek Sesugu'en mu ne si Jesus.” ");
INSERT INTO stb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tubus ilan megampu', mikedyug su dlugar nek piktipungan nilan. Pige'eman ilan gela' ne Gispiritu Santu bu' migatad ilan ri sek pegwali ri seng minsahi ned Diwata se genda'i gendek. ");
INSERT INTO stb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Su dlumpuk ne ngang mektetu'u miksalabuuk ri sek pengena'ena' bu' ri sek pegbatik. Bu' kada sala ri senilan nda' pegangken ne su ngag betangen niin ra, bu' ndi' para ri se dlaunan. ");
INSERT INTO stb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Duma se gembagel ne ga'em, su nga gapustulis mikpemetuud sek peketubu' puli' ni Jesus ne Ginu'u, bu' sud Diwata mingumpiya gupiya tu se dlaun nilan. ");
INSERT INTO stb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nda'irunik sala ri senilan neng mikulangan. Su nga getaw ned duuni ngag binaal nilan awas ngag balay nilan pimeledya'. Bu' su kuwarta neg buwat se galin, ");
INSERT INTO stb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","binegay nilan tu se nga gapustulis; bu' pikilasilas ini se kada sala tawan ri senilan sumala' ri se kina'enlan nilan. ");
INSERT INTO stb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mbuus duuni gesalan ni Levi ne iningelanan neg Jose nek taga Cyprus. Su nga gapustulis migingalan ri seniin neg Barnabas (neg be'et pesabut “suk sala neng Mengengulikseg.”) ");
INSERT INTO stb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Migbeledya' giin seg binaalen bu' inuwit su galin bu' piniyal tu se nga gapustulis. ");
INSERT INTO stb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na, duuning medderuma ne si Ananias bu' si Safira neng migbeledya' ne ketigeyunan nilan. ");
INSERT INTO stb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ma'ad inengkanan ni Ananias su galin bu' minuyun rema suk sawaan. Sung misawad, piniyalen ritu se nga gapustulis. ");
INSERT INTO stb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Miksaak si Pedro, “Ananias, lama mikpetintal'a run riin ni Satanas bu' pibalus'a tu se Gispiritu Santu pebiyan sek pegedlud sed duma ne kuwarta ne galin ne dlupa' mu? ");
INSERT INTO stb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Se genda' mu pa mbeledya' su dlupa' mu, dya'a rai gapu'en; bu' seng mibeledya' mu na, su galin ni'a gusay. Na, tuma ma megbalus'a ma? Gena' ne nga getaw suk pigbelusan mu bu' ndi' sud Diwata.” ");
INSERT INTO stb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Sek pekerengeg run ni Ananias, mibuksak giin bu' minatay; bu' su dlaun neng mikerengeg run nini minendek gaid. ");
INSERT INTO stb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mbuus minateng su ngag begunetaw, bu' pinutus nilan su dlawasen. Peketubus inuwit nilan giin tu se gawas bu' linebeng nilan giin. ");
INSERT INTO stb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pekesagad nek telu uras, sinumeled suk sawa ni Ananias. Nda' giin mekesuun bu' landuning mihitabu' ri seg banaan. ");
INSERT INTO stb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Sinaakan giin ni Pedro, “Esuyay mau, giin ra ba ini suk tibuuk ne galin ne dlupa' neg bineledya' niyu?” Laung ni Safira, “Wa'a daal da iin.” ");
INSERT INTO stb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Aas miktalu' si Pedro ri seniin, “Tuma ma miguyun amu ma neng medderuma nek sulayan su Gispiritu ne Ginu'u? Enlengay mu, kiin na sek tulanan su ngag begunetaw neng midlebeng ri seg bana mu bu' dya'a nandaw buligan'a rema nilan.” ");
INSERT INTO stb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sek tikmal mibuksak si Safira ri seng metungenga'an ni Pedro bu' minatay. Pekseled nu ngag begunetaw, mi'ita' nilan neng minatay na si Safira. Aas binuligan na pelum nilan giin pagaw tu se gawas bu' linebeng tu se gupid neg banaan. ");
INSERT INTO stb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Minendek gaid gupiya su dlaun ne ngang mektetu'u ri sek simbaan bu' su dlaun neng mikerengeg run nini. ");
INSERT INTO stb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na, migbaal neng milagru bu' ketingelaan ne ngag betang su nga gapustulis tu se dlaun ne nga getaw. Bu' miktipung kanunay su dlaun ne ngang mektetu'u ditu seg Balkun nek Penilungan ni Solomon. ");
INSERT INTO stb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nda'iruni dlain ne dlumpuk nek tinumipung riin senilan, isan pigbesaan ilan gupiya ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ma'ad mirugangan pa gaid su nga getaw ri se dlumpuk nilan—nga dlumpuk ne nga dlai bu' ne nga dlibun neng miktu'u riin se Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tendeng se ngag binaal ne nga gapustulis, su ngang minlaru pinguwit nilan ri se ngad dalan bu' binelilid nilan ri se ngag beliliran bu' dendam ali' bu' me'eleman ne dlingaw ni Pedro saanay miyan giin. ");
INSERT INTO stb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Melaun pa ne nga getaw neng migbuwat sek timala' ne nga dlunsud seg Jerusalem neng miguwit ne ngang minlaru awas nga getaw nek pinulayan; bu' dlaun nilan mitelen. ");
INSERT INTO stb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Rayun su Dlabaw ne Geseg nek Pari' bu' su ngak sementaunen ne ngak sakup ri sek sikta ne ngak Saduceo misinaku gupiya ri se nga gapustulis. ");
INSERT INTO stb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Aas dinaap nilan su nga gapustulis bu' sineled tu sek perisuwan. ");
INSERT INTO stb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ma'ad sek pekegebii, pinuka neg anghel ne Ginu'u su nga genga'an nek perisuwan bu' pigawasen ilan. Miktalu' sug anghel ri senilan, ");
INSERT INTO stb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ritu amu bu' gindeg amu tu sek Templo, bu' esuyay niyu su nga getaw ri seng minsahi metendeng seg begu ne ketubu' keni.” ");
INSERT INTO stb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pituud nilan suk tinalu' neg anghel, aas sek peddelaag ne gendaw, sinumeled ilan tu sek Templo bu' migatad menintulu'. Sek panahun keni pitawag ne Dlabaw ne Geseg nek Pari' bu' ngak sementaunen su dlaun ne geseg ne ngag Judeo arun mengmiting suk tibuuk Metaas ne Gukuman. Duun remaik sinugu' nilan neng meritu sek perisuwan arun engain su nga gapustulis bu' uwiten tu senilan. ");
INSERT INTO stb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ma'ad sek peddateng nilan tu sek perisuwan, nda' na ritu su nga gapustulis. Aas, mipuli' ilan tu seng Metaas ne Gukuman bu' pisuun nilan, ");
INSERT INTO stb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Peddateng nami tu sek perisuwan, mi'ita' nami nek tinerengkaan su nga genga'an bu' su nga guwardiya ritu ra rema se nga genga'an. Ma'ad sek pekpuka pa nami run, nda'irun nai getaw neng mi'ita' nami tu sek seled.” ");
INSERT INTO stb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pekerengeg run itu ne geseg ne nga guwardiya ritu sek Templo bu' ne nga geseg nek pari', midlibeg ilan bu' landuning mihitabu' ri se nga gapustulis. ");
INSERT INTO stb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nda' mpayat, duunik sala tawan neng minateng bu' miktalu' tu senilan, “Penginengeg amu, su nga dlai nek sineled niyu ritu sek perisuwan ritu ilan na sek Templo bu' mimandu' ri se nga getaw.” ");
INSERT INTO stb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mbuus miritu sek Templo su geseg ne nga guwardiya bu' su ngak sakupen bu' dinaap nilan puli' su nga gapustulis. Ma'ad nda' ilan legesay tendeng ay mendek ilan betuun ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Inuwit nilan rayun su nga gapustulis ritu seng Metaas ne Gukuman. Miksaak su Dlabaw ne Geseg nek Pari' ri senilan, ");
INSERT INTO stb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Gena' ba tinelu'an amu na nami ne gendi' amu na menintulu' metendeng ri se ngalan ne getaw ketu? Ma'ad enlengay niyu sug binaal niyu, midlelaup naik pekpemandu' niyu sek tibuuk neg Jerusalem, bu' gami paik pingelegan niyu neng mikpatay ri seniin!” ");
INSERT INTO stb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Miksembag si Pedro bu' sud duma ne nga gapustulis, “Kina'enlan tumanen nami sud Diwata bu' gena' su nga getaw. ");
INSERT INTO stb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Sud Diwata nu nga gepu'an ta pitubu'en puli' si Jesus buwat se kemetain dluwat niyu petayay giin pebiyan ri sek pedlansang ri seniin tu se krus. ");
INSERT INTO stb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Piperitaas ned Diwata si Jesus tu sed dapit dlintuun gisip Geseg bu' Menleluwas arun sek pegbegay nek panahun se nga getaw Israel sek peddiksu' bu' arun mpasaylu su ngak sala' nilan. ");
INSERT INTO stb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Pimetuuran nami ngag betang keni bu' su Gispiritu Santu rema, ne giin sug begay ned Diwata tu se ngang miktuman ri seniin.” ");
INSERT INTO stb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sek pekerengeg run nini nu ngak sakup ri se Gukuman, pinlengetan ilan gaid bu' liyagan nilan pemetayay su nga gapustulis. ");
INSERT INTO stb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ma'ad migindeg suk sala nek sementaun nilan ne si Gamaliel. Getaw keni Pariseo bu' menintulu' ri se Kesugu'an. Tinamed giin ne dlaunen. Miksugu' giin nek pegewasen reli' su nga gapustulis. ");
INSERT INTO stb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bu' seng mikegawas na su nga gapustulis, migasuy si Gamaliel tu senilan, “Nga kepeteran'u nek taga Israel, pegena'ena' niyu gupiya bu' landunig baalen niyu ri se nga getaw keni. ");
INSERT INTO stb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ay nud diin, duuni getaw ne su ngalanen si Teudas neng mikpetaastaas neng maa' giin nek ta' getaw, bu' duuni gepaat gatus ne nga getaw neng mikpetuud ri seniin, ma'ad nda' mpayat, pinatay giin bu' su ngak sakupen mitipelak bu' mirala' nai dlumpuk ketu. ");
INSERT INTO stb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Dluwat ini, sek panahun sek pekpenlista ne nga getaw, si Judas na pelum nek taga Galilea sung mikesakup se nga getaw neng middunut ri seniin. Ma'ad pinatay rema giin bu' mitipelak rema su ngak sakupen. ");
INSERT INTO stb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Bu' aas se kasu keni, telu'an'u amu, ndi' niyu ilan ilebetay. Pesaddan niyu ilan ay bu' suk pelanu nilan buwat ma'ad ri se nga getaw, merala' gaid ini. ");
INSERT INTO stb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma'ad bu' buwat ini ri sed Diwata, ndi' amu gaid mekeddaag ri senilan. Seng maa' niin, mi'ita' amu ne kinumuntra pa tumu' ri sed Diwata.” Aas tinuman ne nga geseg ri se Gukuman suk sambag ni Gamaliel. ");
INSERT INTO stb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pitawag nilan puli' su nga gapustulis bu' pilekpes. Peketubus, pinegulan ilan ne ndi' na gaid menendu' metendeng ri se ngalan ni Jesus; bu' rayun bineluy ilan nilan. ");
INSERT INTO stb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Mbuus ginumawas su nga gapustulis ritu seng Metaas ne Gukuman nek pidleliyag gupiya tendeng ay inilala ilan ned Diwata ne mbaya' ilan megantus se kepiiran para riin se ngalan ni Jesus. ");
INSERT INTO stb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kada gendaw ritu ilan sek Templo bu' ri se nga ginumbelayan bu' mikpeddayun ilan sek pekpemandu' bu' sek pegwali ri seng Melengas ne Gesuyen metendeng riin ni Jesus ne Giin sung Misiyas. ");
INSERT INTO stb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Se genda' santa', saanay miksilaun su ngang mektetu'u, middiklamu su ngag Judeo ne suk tinuntulan nilan Griego kuntra se ngag Judeo ne suk tinuntulan nilan Hebreo tendeng ay nda' mbegayay su ngag balu ne dlibun nilan ri se gendawendaw nek pengina'enlan nek selapi'. ");
INSERT INTO stb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aas pitawag nu ngak sepulu' bu' ruwa' ne nga gapustulis su dlaun ne ngang mektetu'u bu' miktalu', “Ndi' mpiya nek peseddanen nami suk pegwali ri sek talu' ned Diwata arun ma'aray sek peddumala sek pekpemegay nek pengetubu'an. ");
INSERT INTO stb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Aas nga kepeteran, pekpili' amu nek pitu tawan ne nga dlai nek sementaun niyu neng mekelengasid dengegen, pige'eman ne Gispiritu Santu, bu' metau gupiya. Gilan suk pe'esegen ta run sek pegabang ri sek pekpemegay. ");
INSERT INTO stb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Bu' gami, gemiten nami suk panahun sek pegampu' bu' sek pegwali.” ");
INSERT INTO stb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Su dlaun neng mektetu'u pidleliyag tu sek tinalu' ne nga gapustulis. Aas pimili' nilan si Esteban, su getaw neng meligen suk pektu'uun bu' pige'eman ne Gispiritu Santu. Pimili' rema nilan si Felipe, si Procoro, si Nicanor, si Timon, si Parmenas, bu' si Nicolas, su getaw nek taga Antiyuk neng mi'uwit nud diin seg rilihiyun ne ngag Judeo. ");
INSERT INTO stb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Inuwit nilan su ngang mipili' nilan ritu se nga gapustulis. Bu' su nga gapustulis migampu' ri senilan bu' dinepenan ilan. ");
INSERT INTO stb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Aas mikpeddayun sek pedlelaup suk Talu' ned Diwata. Melaun pa gaid nek taga Jerusalem neng mibaal neng mektetu'u ni Jesus bu' melaun remaik pari' ned dinumawat sek pektu'u. ");
INSERT INTO stb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na, pingumpiyanan ned Diwata si Esteban ne gembagel ne ga'em. Aas melaun ne ngang milagru bu' nga ketingelaan nek pimbaalen ri se nga getaw. ");
INSERT INTO stb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma'ad duuni nga getaw ne kinumuntra riin ni Esteban bu' inaddat nilan giin. Nga getaw keni ngag Judeo buwat sek Cirene, seg Alejandria, sek Cilicia bu' seg Asia. Gilan keni sakup sek pektiguman ne nga getaw ne iningelanan ned duuni Keguwasan buwat ri sek Pekegulipen. ");
INSERT INTO stb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ma'ad su Gispiritu Santu migbegay nek tinawan riin ni Esteban ne bu' mektalu' giin, ndi' gaid nilan giin melupigan. ");
INSERT INTO stb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aas minu'ul ilan nek santa' tawan neng mektalu', “Mirengeg nami si Esteban neng miktalu' neng melaaten ri se ni Moses bu' ri sed Diwata!” ");
INSERT INTO stb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bu' sek pebiyan neng maa' nini, pig'ulug'ulugan nilan su nga getaw, su nga geseg, bu' su ngang menintulu' ri se Kesugu'an. Dinaap nilan si Esteban bu' inuwit ritu seng Metaas ne Gukuman. ");
INSERT INTO stb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Rayun miguwit ilan ne nga getaw neng menintigus neg balus metendeng riin ni Esteban. Miktalu' ilan, “Getaw keni kanunay gaid ne kumuntra ri seg bala'an nek Templo bu' se Kesugu'an ni Moses. ");
INSERT INTO stb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mirengeg nami giin neng miktalu' ne suk Templo ta geba'en ni Jesus nek taga Nazaret bu' telesanen raw su dlaun nek pemetasan ta neg binilin riin senita ni Moses.” ");
INSERT INTO stb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Su dlaun nek sakup neng Metaas ne Gukuman minenteng gupiya riin ni Esteban bu' mi'ita' nilan ne sung mulu'en maa' mulu' neg anghel. ");
INSERT INTO stb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na, miksaak su Dlabaw Geseg nek Pari' riin ni Esteban, “Metuud ba ini?” ");
INSERT INTO stb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Miksembag si Esteban, “Nga kepeteran bu' nga gama', penginengegay niyau. Sud Diwata ne ge'eman gupiya mikpe'ita' ri se gepu'an ta ne si Abraham sed ditu pa giin seng Mesopotamia se genda' pa giin galin sek pekengel tu seg Haran. ");
INSERT INTO stb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Miktalu' sud Diwata riin ni Abraham, ‘Beleng muing nasud mu bu' nga gepenan mu kiin bu' peritua se dlugar nek pe'ita'u ri seni'a.’ ");
INSERT INTO stb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Aas migawa' si Abraham ritu se dlugar nek pikengelan ne nga getaw Caldea bu' ritu giin mikengel seg Haran. “Sek pekepatay ne gama'en, pigalin giin ned Diwata se dlugar nek pikengelan niyu nemuun. ");
INSERT INTO stb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sek panahun ketu, nda' pa begayay ned Diwata si Abraham ne kebilin isan miika' ne dlupa'. Ma'ad mikpasad sud Diwata ri seniin ne dlupa' keni begain tu seniin bu' tu se nga gesalaan isan nda' paig bata'en. ");
INSERT INTO stb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Giin nini suk tinalu' ned Diwata ri seniin: ‘Su nga gasal mu mekekengel pa reli' ri se dlain neng nasud, bu' ritu, baalen ilan ne nga gulipen bu' peddaagdaagen ilan seled se gepaat gatus taun. ");
INSERT INTO stb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ma'ad silutan'u sung nasud neng megulipen ri senilan. Peketubus run nini, su nga gesalan mu megawa' ri seng nasud ketu bu' meksimba ri senaan ri se dlugar keni.’ ");
INSERT INTO stb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bu' sinugu' ned Diwata si Abraham sek pektuli' se kada neg bata' ne dlai ri sek pamilyaan gisip gilelaan se keligenan. Bu' tinuli' ni Abraham si Isaac se kewalu endaw buwat sek pegegetaun. Bu' giin rema sug binaal ni Isaac riin ni Jacob neg bata'en, bu' si Jacob ritu sek sepulu' bu' ruwa' neg bata'en ne gilan su nga gepu'an ta.” ");
INSERT INTO stb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Si Jose, suk sala sek sepulu' bu' ruwa' neg bata' ni Jacob, pingimbegu'an ne ngak pateren, aas bineledya' giin nilan tu se ngang memeledya'ay arun uwiten ritu seg Ehipto bu' mibaal giin ne gulipen. Ma'ad sud Diwata middunut riin ni Jose, ");
INSERT INTO stb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","bu' midluwas ri seniin buwat se dlaun ne nga keliseran. Binegayan giin ned Diwata seng mekepedleliyag nek pemetasan bu' sinuunan; bu' binaal nu gari' si Jose ne gobernador sek tibuuk neng nasud bu' sinalig ri seniin su dlaun ne ketigeyunaan. ");
INSERT INTO stb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nda' mpayat, duuni gutem sek tibuuk Ehipto bu' Cana'an neng migbegay se gembagel ne keliseran. Nda'irun naik sukatan nek pekaan su nga gepu'an ta. ");
INSERT INTO stb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Bu' sek pekerengeg ni Jacob ned duuni gaan ritu seg Ehipto, piperituun su nga gepu'an ta, ne guna pa ini nilan sek pedditu. ");
INSERT INTO stb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Se keruwa' na nilan nek pedditu, mikpe'ilala si Jose tu se ngak pateren, bu' su gari' seg Ehipto mikesuun metendeng ri sek pamilya ni Jose. ");
INSERT INTO stb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Bu' mimuun si Jose nek peperituun seg Ehipto si Jacob ne gama'en bu' suk tibuuk nek pamilyaan. Ngak pitu pulu' bu' lima dlaun nilan sung miritu seg Ehipto. ");
INSERT INTO stb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Rayun si Jacob miritu seg Ehipto, ne ritu giin bu' su nga gepu'an ta mimatay. ");
INSERT INTO stb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Su ngag bangkay nilan pinguwit tu sek Sikim bu' ritu linebeng se kelebengan nek sinaluy ni Abraham buwat ri sek tribu ni Hamor.” ");
INSERT INTO stb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Seng megaud na suk panahun nek tumanen ned Diwata suk sinaaren riin ni Abraham, miksilaun gupiya su nga getawan ta ritu seg Ehipto. ");
INSERT INTO stb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Se ketambinai' su gari' ne genda' mekilala riin ni Jose migatad medlegari' ritu seg Ehipto. ");
INSERT INTO stb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Linimbungaan su nga gepu'an ta bu' piddaagdaag ilan sek pedleges ri senilan neg belengen su nga gembata' nilan ritu se gawas neg balay arun mematay. ");
INSERT INTO stb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Giin nini suk panahun sek pegegetaw ni Moses, melelai gupiya giin neg bata' ri sek pengenleng ned Diwata. Pidlumu giin ne ngang megulangen tu seg balay nilan seled sek telu bulan. ");
INSERT INTO stb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Seg binilin giin tu se gawas neg balay, inampun giin neg bata' ne dlibun nu Gari' bu' linumuun maa' neg bata'en. ");
INSERT INTO stb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tinendu'an si Moses se dlaun nek sinuunan ne nga getaw Ehipto bu' mibantug giin tendeng sek pegasuyen bu' se ngak terbahuun.” ");
INSERT INTO stb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Se gepaat pulu' taun na ni Moses mikegena'ena' giin neng memisita tu se ngak samaan getaw Israel. ");
INSERT INTO stb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ritu, mi'ita'en nek sala ri senilan piddaagdaag ne getaw Ehipto. Linebanaan su getaw Israel, bu' arun mekesuli', pinatain su getaw Ehipto. ");
INSERT INTO stb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Migena'ena' si Moses neng mesabut ne nga getaw Israel ne giini gemiten ned Diwata sek pedluwas ri senilan. Ma'ad, nda' ilan mekesabut. ");
INSERT INTO stb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Sek sunud ne gendaw, mi'ita'en sud duwa' tawan ne getaw Israel neng migbunu'. Liyaganen usayay su duwa' keni, aas miktalu' giin ri senilan, ‘Ngak sambat, puru amu ruwa' getaw Israel, lama megbunu' amu run?’ ");
INSERT INTO stb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ma'ad pinilik giin nung mindaagdaag bu' miksaak giin, ‘Ta' maing migbaal ri seni'a nek pengulu bu' megukum ri senami? ");
INSERT INTO stb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Landun, petain mau ba maa' ri sek pekpatay mu se getaw Ehipto labung?’ ");
INSERT INTO stb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Sek pekerengeg ni Moses run nini, linumayas giin buwat seg Ehipto bu' mikengel ritu se dlupa' neng Midian. Ditu mi'etaw sud duwa' tawan neg bata'en ne dlai.” ");
INSERT INTO stb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Peksagad se gepaat pulu' taun, duunik sala neg anghel neng mikpe'ita' riin ni Moses pebiyan ri seng midliga' neng miika' ne gayu saanay ritu giin se kemingawan megaud seg bentud nek Sinai. ");
INSERT INTO stb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mitingala gaid si Moses ri seng mi'ita'en, aas mikpegaud giin arun pegipusaan. Bu' rayun sek pekpegauren mirengegen suk talu' ne Ginu'u: ");
INSERT INTO stb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Gaku' sud Diwata nu nga gepu'an mu, sud Diwata ni Abraham, ni Isaac, bu' ni Jacob.’ Ma'ad mingereg si Moses se gendek bu' nda'en maaku enlengay. ");
INSERT INTO stb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bu' miktalu' su Ginu'u ri seniin, ‘Esu' mu suk sandalyas mu ay bala'ani dlugar keni nek pigindegan mu. ");
INSERT INTO stb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi'ita'u gaid su nga kelised ne ginantus ne nga getawan'u ritu seg Ehipto. Mirengeg'u rema su ngad degu nilan, bu' keniu sek pedluwas ri senilan. Aas nandaw, pegaud'a rini; bu' sugu'en'u dya'a ritu seg Ehipto.’” ");
INSERT INTO stb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Giin nini sung Moses neg binibay ne nga getaw Israel. ‘Ta' maing migbaal ri seni'a nek pengulu bu' megukum ri senami?’ miksaak ilan. Giin rema sung Moses nek sinugu' ned Diwata ne gembaal ne geseg bu' medluwas se nga getaw Israel, inebangan nug anghel neng mi'ita'en ritu seng midliga' neng miika' ne gayu. ");
INSERT INTO stb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Giin sung midlegeseg sek pegawas nilan buwat seg Ehipto bu' migbaal giin ne ngang milagru bu' nga ketingelaan ritu seg Ehipto, sed Dagat ne Gempula, bu' ritu se kemingawan seled se gepaat pulu' taun. ");
INSERT INTO stb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Giin rema sung Moses neng miktalu' se nga getaw Israel, ‘Sud Diwata meksugu' riin seniyu nek propeta, maa' sek peksugu'en ri senaan, bu' giin suk sala ned diin pegbuwat seniyu.’ ");
INSERT INTO stb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Giin sung middunut se nga getaw Israel neng miktipung ri se kemingawan. Ritu giin duma se nga gepu'an ta bu' seg anghel neng miktuntul ri seniin ritu seg Bentud nek Sinai bu' mirawaten sung minsahi neng mikegbegay ne ketubu' nek pinasa riin senita.” ");
INSERT INTO stb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ma'ad nda' pekpetuud su nga gepu'an ta riin ni Moses. Binibay nilan giin bu' mingangut ilan neng mekepuli' tu seg Ehipto. ");
INSERT INTO stb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Miktalu' ilan riin ni Aaron, ‘Baalay mu ami ne ngad diwatadiwata neng meguna ri senami, tendeng ay nda' ami na mekesuun bu' landuning mihitabu' riin ni Moses neng miguwit ri senami sek pedlegawas seg Ehipto.’ ");
INSERT INTO stb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Bu' migbaal rayun si Aaron ned diwatadiwata maa' ne gawi' neng nati neg baka para ri se nga getaw. Pingilakan nilan sud diwatadiwata ketu bu' mikse'ulug ilan para tu seg binaal nilan. ");
INSERT INTO stb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Aas tineliyuran ilan ned Diwata bu' pisaddan ilan neng meksimba se ngag bituun ri se dlangit, maa' seng misulat se dlibru ne ngak propeta: ‘Gamu ne nga getaw Israel, gena' gaku' suk tiniti'an niyu, bu' dinulangan ne ngang menanap, sek seled gepaat pulu' taun ritu se kemingawan. ");
INSERT INTO stb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Su ginuwit niyu giin suk tulda ned diwata niyu ne si Molok, bu' su dlerawan ni Repan, sud diwata niyu neg bituun; Gilan su ngad diwata neg binaal niyu arun simbaan. Aas pawit'u amu maa' ne ngak pinerisu legbas pa seg Babilonia.’” ");
INSERT INTO stb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Su nga gepu'an ta duunik Tulda nilan ne ritu sud Diwata duma senilan ritu se kemingawan. Tulda keni binaal sek tinelu'an ned Diwata si Moses, sumala' ri se dlendasan nek pi'ita' ned Diwata ri seniin. ");
INSERT INTO stb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mbuus, buwat tu se nga gepu'an nilan, mirawat ini se nga gepu'an ta bu' inuwit nilan nini sek peddunut nilan riin ni Joshua sek pegileg nilan ri se nga dlupa' tu se nga getaw nek pipe'awa' ned Diwata ri seng metungenga'an nilan. Bu' mikpebilin suk tulda tampan sek panahun ni David. ");
INSERT INTO stb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Pidleliyag sud Diwata riin ni David bu' migandyu' si David riin sed Diwata nek tugutan giin sek pegbaal neg balay para ri sed Diwata ni Jacob. ");
INSERT INTO stb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ma'ad si Solomon sung migbaal neg balay para sed Diwata.” ");
INSERT INTO stb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ma'ad sud Diwata ne Dlabaw ri se Dlaunan ndi' mekengel ri se ngag balay neg binaal ne nga getaw. Sumala' seng mi'asuy nek propeta: ");
INSERT INTO stb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Su dlangit giinik trunuu, miktalu' su Ginu'u bu' su dlupa' giini gindegan'u. Aas lama pa belayay runig baalen niyu ri senaan? Ta' mai dlugar ne gempenguleliyan'u? ");
INSERT INTO stb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Gena' ba ne gaku' maing migbaal ri se dlaun ne ngag betang keni?’” ");
INSERT INTO stb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Bu' mikpeddayun pa gaid si Esteban sek pektalu' tu se nga getaw tu se Gukuman, “Peketegas gaid ne nga gulu bu' ngak pusung niyu! Tuma ma mikpebengelbengel amu ma'aray ri seng minsahi ned Diwata? Maa' amu gaid ne nga gepu'an niyu. Kanunay niyu sinupak su Gispiritu Santu. ");
INSERT INTO stb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Duun baik propeta ne nda' niyu lutusay? Isan su ngang megasuy metendeng ri sek peddateng neng metareng nek Sesugu'en, pimatay rema niyu. Bu' nemuun, gamu sung migbudhi' bu' mikpatay ri seniin. ");
INSERT INTO stb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Gamu sung mikerawat se kesugu'an neg binegay ned Diwata pebiyan ri seg anghel, ma'ad nda' niyu ini tumanay.” ");
INSERT INTO stb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pekerengeg run nini nu ngak sakup ri se Gukuman, pinlengetan ilan gupiya riin ni Esteban. Pingkiget su nga ngisi nilan se kelebiyan ne dlanget. ");
INSERT INTO stb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ma'ad si Esteban, nek pige'eman ne Gispiritu Santu, migangag tu se dlangit bu' mi'ita'en su kesanag ned Diwata bu' si Jesus migindeg ri sed dapit dlintuun. ");
INSERT INTO stb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Enlengay niyu!” laungen, “Mi'ita'u neng mipuka su dlangit, bu' sug Bata' ne Getaw migindeg ri sed dapit dlintu ned Diwata!” ");
INSERT INTO stb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mimbeksay su ngak sakup ne Gukuman bu' tinampeng nilan su ngak telinga nilan se nga gemeg nilan bu' middengan ilan lumanlag ri seniin. ");
INSERT INTO stb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Inuwit nilan si Esteban tu se gawas nek siyudad bu' ritu nilan binatu. Linuwas nu ngak sintigus su nga dlambung nilan bu' binilin riin seg begunetaw ne su ngalanen si Saulo. ");
INSERT INTO stb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Saanay nilan megbatu riin ni Esteban, migampu' giin ri sed Diwata neng miktalu', “Jesus ne Ginu'u dawat mu su gispirituu!” ");
INSERT INTO stb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bu' minginlulud giin bu' migbeksay seng mesekeg nek talu', “Ginu'u, ndi' mu ilan pesela'ay ri seg binaal nilan.” Bu' rayun minatay giin. ");
INSERT INTO stb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Na, ritu si Saulo neng minuyun sek pekpatay riin ni Esteban. Bu' se gendaw ketu, migatad rayun su gembagel nek pedlutus se ngang mektetu'u ri sek simbaan seg Jerusalem. Aas miktipelak ilan se ngak probinsiya neg Judea, bu' Samaria gawas se nga gapustulis. ");
INSERT INTO stb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Si Esteban linebeng nu nga getaw neng melituuren ri sed Diwata bu' mimbakal ilan bu' minsegaw tendeng ri seniin. ");
INSERT INTO stb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ma'ad minantu si Saulo ne gubeten su ngang mektetu'u ri sek simbaan bu' miritu giin se nga ginumbelayan, bu' pimbidlasen su ngang mektetu'u, su nga dlai awas dlibun bu' pinerisu ilan. ");
INSERT INTO stb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Su ngang mektetu'u neng miktetipelak miritu seng midlainlain ne dlugar bu' migwali seng minsahi. ");
INSERT INTO stb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Na se dlain neg bahin, si Felipe miritu sek siyudad nek Samaria bu' migwali metendeng seng Misiyas tu se nga getaw ritu. ");
INSERT INTO stb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Minginengeg su nga getaw riin ni Felipe saanay mirengeg nilan su ginasuyen bu' sek pekiita' nilan se ngang milagru neg binaalen. ");
INSERT INTO stb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Su ngang melaat ne gispiritu minggawas buwat ri se ngang melaun ne getaw neng mimbeksay neng mesekeg bu' melaun remaik paralitiku bu' ne ngak pi'ang neng mi'uli'an. ");
INSERT INTO stb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Aas pidleliyag gupiya su dlaun ne nga getaw tu sek siyudad ketu. ");
INSERT INTO stb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na, duuni getaw ritu ne giningelanan si Simon. Se gempayat nek panahun migbaal nek pegbineliyan ri sek siyudad ketu bu' mikepetingala tu se ngak taga Samaria. Mikpetu'u giin ne ge'eman, ");
INSERT INTO stb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","bu' su dlaun ne nga getaw ri sek siyudad, buwat sek pupus tampan seng meratu' minginengeg gaid ri seniin. “Getaw keni, giini ga'em ned Diwata ne giningelanan ne ‘Gembagel ne Ga'em.’” ");
INSERT INTO stb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Minginengeg gaid su nga getaw ri seniin tendeng se gempayat na nek panahun neng mikepetingala tu senilan suk pegbineliyanen. ");
INSERT INTO stb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ma'ad sek pektu'u nilan seng minsahi ni Felipe metendeng seng Melengas ne Gesuyen ri sek pedlegari' ned Diwata bu' metendeng ri se ngalan ni Jesus Christ, mikpebendyag ilan, nga dlai bu' nga dlibun. ");
INSERT INTO stb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Isan si Simon miktu'u; bu' peketubus mbendyagay giin, middunutdunut giin riin ni Felipe. Mitingala gaid giin se ngang mekebagel ne ketingelaan bu' milagru neg binaal ni Felipe. ");
INSERT INTO stb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mirengeg nu nga gapustulis tu seg Jerusalem ne su ngak taga Samaria mikerawat rema sek talu' ned Diwata, aas sinugu' nilan ritu si Pedro bu' si Juan. ");
INSERT INTO stb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Peddateng nilan sek Samaria migampu' ilan para ri se ngang mektetu'u neng merawat siya nilan su Gispiritu Santu. ");
INSERT INTO stb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ay su Gispiritu Santu nda' pa lusad tu se isan sala senilan. Mibendyagan ilan na run ri se ngalan ne Ginu'u ne si Jesus. ");
INSERT INTO stb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Aas dinepen ni Pedro bu' ni Juan su nga gemeg nilan ri senilan bu' mirawat nilan su Gispiritu Santu. ");
INSERT INTO stb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Mi'ita' ni Simon neng mirawat nu nga getaw su Gispiritu sek peddepen nu nga gapustulis se nga gemeg nilan ri se nga getaw. Aas tinulunaan si Pedro bu' si Juan ne kuwarta, ");
INSERT INTO stb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","laungen, “Begayay niyau rema runi ga'em kiin arun isan ta' ned depenan'u ne gemeg'u mekerawat rema ne Gispiritu Santu.” ");
INSERT INTO stb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ma'ad miksembag si Pedro seniin, “Ukuman'a siya ned Diwata, duma ne kuwarta mu kiin tendeng ay migena'ena'a neng mesaluy mu ne kuwarta sug begay ned Diwata! ");
INSERT INTO stb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nda'i dlabet mu awas bahin mu ri sek pimbaal nami tendeng ay su gena'ena' mu gena' metareng ri sek pengenleng ned Diwata. ");
INSERT INTO stb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Aas, diksu'ay mu sung melaat nek pelanu mu, bu' pegampu'a ri se Ginu'u nek pasayluun'a ri se gena'ena' mu neng melaaten. ");
INSERT INTO stb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tendeng ay mi'ita'u neng mesinaa gupiya bu' ginapus'a sek sala' mu.” ");
INSERT INTO stb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Miktalu' si Simon riin ni Pedro bu' ni Juan, “Bu' mehimu, pegempu'ay niyau rema ri se Ginu'u arun ndi' mehitabu' ri senaan su ngag betang nek tinalu' niyu.” ");
INSERT INTO stb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Dluwat ilan mekpemetuud bu' menintulu' ri seng minsahi ne Ginu'u, mipuli' si Pedro bu' si Juan seg Jerusalem. Ri sek pedlaang nilan, migwali ilan seng Melengas ne Gesuyen tu se ngag baryu tu sek Samaria. ");
INSERT INTO stb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bu' duunig anghel ne Ginu'u neng miktalu' riin ni Felipe, “Pengandam'a bu' dlaang'a pagaw tu seg habagatan, ritu sed dalan neg buwat seg Jerusalem pagaw se Gaza.” (Dalan keni nda' na biyanay nemuun.) ");
INSERT INTO stb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Aas midlaang si Felipe. Bu' enlengay niyu, duuni getaw nek taga Etiopia neng mikpeguli' na buwat seg Jerusalem dluwat sumimba ri sed Diwata. Getaw keni kinapun bu' metaasi ketendanaan tendeng ay giinik piniyalan se ketigeyunan ni Candace awas sug Bai seg Etiopia. ");
INSERT INTO stb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Miksakay giin ri se karwahiin bu' mikpegbasa ri se dlibru ni propeta Isaias. ");
INSERT INTO stb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Miktalu' su Gispiritu riin ni Felipe, “Pekpegaud'a ri se karwahiin bu' teparay mu su karwahiin.” ");
INSERT INTO stb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Aas, ginumebek si Felipe tu seniin bu' mirengegen neng migbasa su gupisyal se dlibru ni propeta Isaias. Mbuus sinaakan giin ni Felipe, “Misabut mu ba sug binasa mu?” ");
INSERT INTO stb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Miksembag su gupisyal, “Pegendun'u ma peksabut run bu' nda'iruning mektendu' run ri senaan?” Bu' inenggaten si Felipe nek sumakay tu se karwahiin bu' megingkud ri se gupiren. ");
INSERT INTO stb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Giin nini sung misulat tu se Kesulatan neg binasaan, “Maa' giin ne karniru ne ginuwit arun titi'en, bu' maa' ne karniru ne genda' pektalu' se guntingan sug bembulen. Nda' gaid giin pektalu'. ");
INSERT INTO stb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pikpiid giin bu' gena' metarengik pegukum ri seniin. Nda'irun naing megasuy run metendeng ri se gesalaan, tendeng ay su ketubu'en rini seg benwa mitapus na.” ");
INSERT INTO stb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Miksaak su gupisyal riin ni Felipe, “Telu'ay mau su gegulingen ba nek propeta suk pisabut run nini awas dlain ne getaw?” ");
INSERT INTO stb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Aas buwat ritu se Kesulatan, pisabut ni Felipe ri seniin sung Melengas ne Gesuyen metendeng riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Saanay mikpeddayun ilan sek pekpanaw, mirepet ilan ri se dlugar ned duunik tubig run. Miktalu' su gupisyal riin ni Felipe, “Ala, duunik tubig rini. Duun baing mekepengelet sek pekpebendyag'u?” ");
INSERT INTO stb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Aas pikeneng nu gupisyal su karwahi bu' linumebul ilan duwa' tu sek tubig bu' binendyagan giin ni Felipe. ");
INSERT INTO stb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pedlekawas nilan buwat tu sek tubig, sek tikmal inuwan nu Gispiritu ne Ginu'u si Felipe. Nda' na giin me'ita' nu gupisyal, tumu' pidleliyag gaid giin gupiya sek pekpanaun. ");
INSERT INTO stb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Se dlain neg bahin mibetikan ni Felipe ned ditu na giin seg Azutus bu' migwali giin seng Melengas ne Gesuyen saanay minayan giin ritu se nga dlunsud tampan minateng giin tu sek Cesarea. ");
INSERT INTO stb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na, mikpeddayun si Saulo sek pekpengulega' sek pekpatay se ngak tinu'unan ne Ginu'u. Miritu pa giin se Dlabaw Geseg nek Pari' ");
INSERT INTO stb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","bu' minengi giin ne ngak sulat neng mekpe'ilala ri seniin tu se ngak pektiguman nu nga getaw Judeo sed Damascus nek tinugutan giin sek peddaap seng me'ita'en su ngak sakup seg Biyanan ne Ginu'u, dlai awas dlibun bu' uwiten ilan puli' ritu seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Seng megaud na ni Saulo tu sek siyudad ned Damascus, se kinlap duuning merelaag neg buwat ri se dlangit neng middelaag ri sek timala'en. ");
INSERT INTO stb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mbuus mibuksak giin ri se dlupa' bu' duunik talu' neng mirengegen: “Saulo, Saulo! Lama pedlutusan mau run?” ");
INSERT INTO stb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Miksembag si Saulo, “Ginu'u, ta'a ma ne getaw?” Miksembag suk talu', “Gaku' si Jesus, su dlinutus mu. ");
INSERT INTO stb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ma'ad gindeg'a bu' peritua sek siyudad, tendeng ay ritu duuning megasuy ri seni'a bu' landuni gembaya' mu baalen.” ");
INSERT INTO stb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bu' su nga getaw nek sementaun ni Saulo mikeneng bu' nda' mekesasak; mirengeg nilan suk talu', ma'ad nda'iruning mi'ita' nilan. ");
INSERT INTO stb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Migindeg si Saulo buwat ri se dlupa', bu' pinukaan sung mataan ma'ad ndi' na giin mekiita'. Aas inagak giin nu ngak sementaunen tampan tu sed Damascus. ");
INSERT INTO stb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Seled sek telu endaw ndi' giin mekiita', bu' sek panahun ketu, nda' giin aan bu' nda' rema inum. ");
INSERT INTO stb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ritu sed Damascus, duunik sala tawan nek sakup ni Jesus ne giningelanan si Ananias. Pebiyan ri seng mi'ita'en, mikpe'ita' ri seniin su Ginu'u, “Ananias!” Miksembag si Ananias, “Keniu ra, Ginu'u.” ");
INSERT INTO stb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Miktalu' su Ginu'u ri seniin, “Dlaang'a ritu sed dalan ne ginengilanan neng Meleddeng neg Biyanan, bu' ritu seg balay ni Judas, penengaw mu su getaw nek taga Tarsus ne giningelanan si Saulo. Sek panahun keni, mikpegampu' giin, ");
INSERT INTO stb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","bu' pebiyan ri sek pegita'en, mikiita' giin ne getaw ne su ngalanen si Ananias nek sumeled bu' dumepen ri seniin arun mekiita' giin puli'.” ");
INSERT INTO stb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ma'ad miksembag si Ananias, “Ginu'u, mirengeg'u buwat ri se nga getaw metendeng ri se getaw kiin bu' gendun giin kebelu' se ngang mektetu'u ri seni'a seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Mirini ngani' giin nemuun sed Damascus ned duunik pektugut buwat ri nga geseg ne ngak pari' arun pendaapenen su dlaun neng miksimba ri seni'a.” ");
INSERT INTO stb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ma'ad miksembag su Ginu'u riin ni Ananias, “Dlaang'a, laway mu giin tendeng ay pinili'u giin nek sesugu'en arun pe'ilelaani ngalan'u ri se nga gena' Judeo, bu' ri se nga gari', bu' ri se nga getaw Israel. ");
INSERT INTO stb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Bu' pe'ita'u rema ri seniin su ngak pegantus ne kina'enlan mbiyanaan para ri se ngalan'u.” ");
INSERT INTO stb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Aas linawan ni Ananias si Saulo tu seg balay nek pinaikaan, bu' sek pekseleren ritu, dinepenaan si Saulo. Laungen, “Saulo, pated'u ri se Ginu'u, sinugu'u ne Ginu'u ne si Jesus sek peddini seni'a. Giining mikpe'ita' ri seni'a ri sed dalan saanay mu mekpagaw rini. Sinugu' naun rini arun mekiita'a puli' bu' arun pege'eman'a ne Gispiritu Santu.” ");
INSERT INTO stb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Rayun midladdu' buwat ri seng mata ni Saulo sung maa' ne nga gunap nek sera' bu' mikiita' giin puli'. Mbuus migindeg giin bu' mikpebendyag. ");
INSERT INTO stb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Minaan giin bu' mipuli' suk sekegen. Na, mikpebilin si Saulo sed Damascus seled sek santa' endaw duma se ngak tinu'unan. ");
INSERT INTO stb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Miritu rayun giin se ngak pektiguman bu' minintulu' giin metendeng riin ni Jesus ne giin sug Bata' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mitingala gaid su dlaun neng mikerengeg ri seniin bu' miksaak ilan, “Gena' ba giin ma sung mikpatay seng miksimba ri se getaw ne si Jesus ritu seg Jerusalem? Gena' ba mirini ma giin arun pendaapen su nga getaw bu' uwitenen ritu se nga geseg ne ngak pari'?” ");
INSERT INTO stb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ma'ad miksamet pa gaid su ga'em ni Saulo sek pegwali. Pimetuuraan ne si Jesus giin sung Misiyas bu' su ngag Judeo sed Damascus ndi' mekesembag ri seniin. ");
INSERT INTO stb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Peksagad nek santa' endaw, miktipung su ngag Judeo bu' migena'ena' ilan nek petain si Saulo, ");
INSERT INTO stb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ma'ad duuning migasuy riin ni Saulo metendeng ri sek pelanu nilan. Gendaw bu' gebii pigbentayan nilan su nga genga'an nek siyudad arun petain giin. ");
INSERT INTO stb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ma'ad duuni gebii, piseled giin nu ngak tinu'unan ni Jesus ri seg bebaan bu' tinentun nilan ri se gawas nek paril nek siyudad. ");
INSERT INTO stb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sek peddateng ni Saulo seg Jerusalem, liyagaan siya neng maampu' tu se ngak tinu'unan ni Jesus. Ma'ad minendek ilan ri seniin. Ndi' ilan meketu'u nek sakup na giin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ma'ad inebangan giin ni Barnabas. Inuwiten giin ritu se nga gapustulis bu' pi'ilelaan ri senilan. Inasuyen ri senilan bu' gendun pekehitabu' neng mi'ita' ni Saulo su Ginu'u ri seg biyanan bu' landunik tinalu' ri seniin. Bu' inasuyen rema su kebelu' ni Saulo ri sek pegwali metendeng se ngalan ni Jesus ritu sed Damascus. ");
INSERT INTO stb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Aas tinumipung si Saulo ri senilan bu' midlibed ri sek tibuuk neg Jerusalem neng mikinabelu' sek pegwali metendeng se ngalan se Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Miketuntul bu' mikegaddat giin ne ngag Judeo ne suk tinuntulan nilan Griego, ma'ad mikpelanu ilan sek pekpatay ri seniin. ");
INSERT INTO stb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pekesuun ne ngang mektetu'u run, dinelung nilan si Saulo se dlunsud nek Cesarea bu' pipe'uli' tu sek Tarsus. ");
INSERT INTO stb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Peketubus itu, duuni kelinaw tu se ngak simbaan ri seg Judea, se Galilea, bu' sek Samaria. Pebiyan se gabang se Gispiritu Santu, miksiligen bu' midleget ilan, neng midleketubu' ri sek pektamed ri se Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na, binisitaan ni Pedro su ngang mektetu'u ri se dlainlain ne dlugar. Miritu rema giin se ngang mektetu'u sed Lida. ");
INSERT INTO stb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ritu, mi'ita' ni Pedro su getaw ne giningelanan neg Eneas. Paralitiku giin bu' nda' na gaid mekegbuwat ri seg beliliraan sek seled neg walu taun. ");
INSERT INTO stb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Miktalu' si Pedro ri seniin, “Eneas pi'uli'an'a na ni Jesus Christ. Aas buwat'a bu' ipes muig beliliran mu.” Bu' migbuwat rayun si Eneas. ");
INSERT INTO stb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mi'ita' ne dlaun neng mikengel sed Lida bu' sek Sharon neng mi'uli'an na si Eneas bu' miktu'u ilan rema ri se Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Bu' ritu seg Jope, duuning mektetu'u ne giningelanan nek Tabita. (Su ngalanen ri se Griego Dorcas neng migulugan ne “gusa.”) Dlibun keni melauning mibaalen neng melengas labi na tu se ngak pupus. ");
INSERT INTO stb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Sek panahun ketu midlaru giin bu' minatay. Linimpiyu nilan sug bangkain bu' binetang tu se kuwartu sed ditaas. ");
INSERT INTO stb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Sug Jope gena' melayu' sed Lida, aas sek pekerengeg nu ngang miktetu'u ne si Pedro ritu sed Lida, sinugu' nilan sud duwa' tawan tu seniin duma seng minsahi: “Peksempun'a run perinia senami.” ");
INSERT INTO stb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Aas mingandam rayun si Pedro bu' middunut ri senilan. Peddateng nilan, inuwit nilan giin tu se kuwartu tu sed ditaas ne linibutan giin ne ngag balu ne dlibun neng minsegaw, bu' pimpe'ita' nilan riin ni Pedro su ngak suub bu' su nga dlambung nek pimenai' ni Dorcas seng miktetubu' pa giin. ");
INSERT INTO stb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mbuus pigawas ni Pedro su dlaun nilan tu se kuwartu. Minginlulud giin bu' migampu' tu sed Diwata. Peketubus, migatubang giin tu seg bangkay bu' miktalu', “Tabita, buwat'a!” Mipuka su ngang mata ni Tabita bu' sek pekita'en riin ni Pedro migingkud giin. ");
INSERT INTO stb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Inuwiran giin ni Pedro ri se gemeg bu' inebangan neng mekegindeg. Peketubus, sinabiin su ngang mektetu'u dlabet na su ngag balu ne dlibun ritu se gawas bu' pi'ita'en ri senilan si Tabita neng mitubu' na. ");
INSERT INTO stb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Penghitabu' keni midderengeg ritu sek tibuuk neg Jope bu' melauning miktu'u riin se Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Mikpebilin si Pedro seng melaun pa ne gendaw seg Jope, seg balay ni Simon, getaw neng menina' nek panit. ");
INSERT INTO stb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na, ditu sek Cesarea, duuni getaw ne giningelanan si Cornelio. Getaw keni kapitan ne nga kustabli seg Roma. Misakup su grupunen ritu seg Batalyun buwat seg Italy. ");
INSERT INTO stb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Rilihiyusu giin ne getaw; giin bu' duma suk pamilyaan miksimba riin sed Diwata. Melauning mi'abangen ri se ngak pupus ne getaw bu' kanunay giin megampu' ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Seng miginenga' menaugi gendaw, mi'ita'en se kelaru sek sala nek pegita'en, ne sug anghel ned Diwata mikpegaud ri seniin bu' miktalu', “Cornelio!” ");
INSERT INTO stb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Miktenteng giin ri seg anghel neng minendek bu' miktalu', “Sir, landun ma?” Miktalu' sug anghel, “Mirengeg ned Diwata su ngak pegampu' mu bu' misuunan su ngak pegabang mu tu se ngak pupus. ");
INSERT INTO stb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bu' nandaw, peksugu'a ne nga getaw neng meritu seg Jope para ri se getaw ne su ngalanen si Simon Pedro. ");
INSERT INTO stb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ritu giin mikpenaikan ni Simon, su getaw neng menina' nek panit. Sug balain riin se geksid ned dagat.” ");
INSERT INTO stb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mbuus migawa' sug anghel bu' tinawag ni Cornelio sud duwa' tawan ne ngak sesugu'enen bu' suk sala ne kustabli neg rilihiyusu nek sala se ngak sineligaan. ");
INSERT INTO stb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Inesuyan ilan ni Cornelio se dlaun neng mihitabu', bu' sinugu'en ilan sek pedditu seg Jope. ");
INSERT INTO stb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na, sek pekemanlema' saanay megaud ilan na tu se dlunsud neg Jope, minaik si Pedro tu seng melantang ne gatep neg balay arun megampu'. Taasendaw itu. ");
INSERT INTO stb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Miperii'an giin bu' liyagaan maan. Ma'ad saanay pa nilan megandam runi gaan, duunik pi'ita' ned Diwata ri seniin. ");
INSERT INTO stb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Mi'ita'eni dlangit neng mipuka bu' duuning mikpebaba' pagaw ri se dlupa' maa' seng melambeg nek penepeten ne iniketan su gepaat nek sinurungaan. ");
INSERT INTO stb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Bu' ri sek seled nek penepeten ketu mi'ita'en su dlaun neng mikeleseles neng mektetubu'—su ngang menlaang bu' su ngang mengkagang ri se dlupa', bu' su ngang menlayug ri se gawanawanan. ");
INSERT INTO stb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Bu' duunik talu' neng mirengegen neng miktalu', “Gindeg'a, Pedro; Pektiti'a bu' aan'a run nini!” ");
INSERT INTO stb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Miksembag si Pedro, “Ndi' mehimu, Ginu'u, tendeng ay nda'u gaid mekekaan neng melemu' bu' nda' tugut aanen.” ");
INSERT INTO stb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Miktalu' puli' suk talu' riin ni Pedro, “Ndi' mu telu'ay neng melemu' su isan landun ne dlinimpiyu na ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Metelu ini mehitabu' bu' suk penepeten ketu, nek pibaba', sek tikmal binatun puli' tu se dlangit. ");
INSERT INTO stb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Na, saanay pa megena'ena' ni Pedro bu' landuni gulugan seng mi'ita'en ketu, minateng rema su nga getaw nek sinugu' ni Cornelio. Enlengay niyu, sek pekesuun nilan run bu' ta' sug balay ni Simon, miritu ilan rayun bu' migindeg ri se genga'an, ");
INSERT INTO stb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","miksabi ilan bu' miksaak, “Duun baing mikpenaikan rini ne giningelanan nek Simon Pedro?” ");
INSERT INTO stb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Saanay midlibeg pa si Pedro bu' landuni gulugan seng mi'ita'en ketu, miktalu' su Gispiritu ri seniin, “Duunik telu tawan neng minengaw ri seni'a. ");
INSERT INTO stb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Penaug'a bu' dunut'a ri senilan. Ndi'a medduwa'ruwa' tendeng ay sinugu'u ilan.” ");
INSERT INTO stb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Aas minaug si Pedro bu' miktalu' tu se nga getaw, “Gaku'ik pinengaw niyu. Landun maik tuyu' niyu neng mirini amu?” ");
INSERT INTO stb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Miktalu' ilan, “Sinugu' ami rini ni Kapitan Cornelio. Mpiya giin ne getaw bu' miksimba ri sed Diwata bu' pigbesaan giin gupiya se dlaun ne ngag Judeo. Tinelu'an giin sek sala neg anghel ned Diwata sek pegenggat ri seni'a sek pedditu seg balain arun mekepenginengeg giin ri sek talu' mu.” ");
INSERT INTO stb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pipenaik ilan ni Pedro bu' ritu ilan miktulug nu gebii ketu. Pekesunud gendaw, middunut si Pedro ri senilan. Duunik santa' tawan neng mektetu'u neg buwat seg Jope neng middunut ri seniin. ");
INSERT INTO stb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pekemanlema', minateng ilan sek Cesarea. Migelat si Cornelio ri senilan duma su nga gepenaan bu' su ngak silingaan nek pingenggaten. ");
INSERT INTO stb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Na, sek peddateng ni Pedro, sinungkak giin ni Cornelio bu' sinimba si Pedro. ");
INSERT INTO stb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ma'ad pi'indeg giin ni Pedro, laungen, “Gindeg'a. Gaku' getaw ra.” ");
INSERT INTO stb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mikpeddayun suk pektuntul nilan saanay nilan mineled tu seg balay, bu' ritu, mi'ita' ni Pedro neng melauni nga getaw neng miktipung. ");
INSERT INTO stb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Miktalu' si Pedro ri senilan, “Gamu mikesuun ne su ngag Judeo nda' tugutay ri seg rilihiyunen neng mengumbalay awas tumipung ri se nga gena' Judeo. Ma'ad pi'ita' ned Diwata ri senaan ne ndi'u pegena'ena'en neng melemu' su isan ta' ne getaw bu' ndi' mbaya' tipungan. ");
INSERT INTO stb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Aas sek pi'angay niyau neng merini, nda'u pegbelibad. Nandaw liyagan'u mesuunan bu' lama pe'angay niyau run.” ");
INSERT INTO stb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Miksembag si Cornelio, “Telu endaw na nandaw sung misagad dluwatu megampu' rini seg balay'u bu' maa' rema se guras keni, neng miginenga' menaugi gendaw. Saanay'u megampu', enlengay niyu, sek tikmal duuni getaw neng migindeg ri seng metungenga'an'u neng mesinawik suuben. ");
INSERT INTO stb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Bu' tinelu'an naun, ‘Cornelio, dinengeg ned Diwata suk pegampu' mu bu' mi'ena'ena'en suk pegabang mu ri se ngak pupus. ");
INSERT INTO stb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Na, peksugu'a ne nga getaw sek pedditu seg Jope bu' pe'angay mu si Simon ne giningelanan nek Pedro. Ritu giin mikpenaikan seg balay ni Simon ne sug baalenen menina' nek panit. Sug balain ri se geksid ned dagat.’ ");
INSERT INTO stb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aas pi'angay'u rayun dya'a bu' salamat neng minateng'a. Nemuun, keni ami na seng metungenga'an ned Diwata migelat arun menginengeg bu' landunik sinugu' ne Ginu'u ri seni'a ne esuyen mu ri senami.” ");
INSERT INTO stb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Aas miktalu' si Pedro, “Nandaw misuunan'u na ne sud Diwata nda'irunik pilebunen. ");
INSERT INTO stb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Bu' su getaw duuni gendeken ri sed Diwata bu' megbaal neng metareng, isan laa tribuway run duwaten giin ned Diwata. ");
INSERT INTO stb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Misuunan niyu sung minsahi nek pinawiten tu se nga getaw Israel, sek pegasuy seng Melengas ne Gesuyen se kelinaw pebiyan riin ni Jesus Christ, ne Ginu'u se dlaunan. ");
INSERT INTO stb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Misuunan niyu su gembagel nek penghitabu' ri sek tibuuk nasud seg Israel, migatad se Galilea dluwat sek pekpengwali ni Juan ri seng minsahi sek pekpebendyag. ");
INSERT INTO stb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Misuunan rema niyu sung metendeng riin ni Jesus nek taga Nazaret bu' pigendun ned Diwata pegbegay su Gispiritu Santu ri seniin bu' ga'em. Miritu giin se dlainlain ne dlugar sek pegbaal neng melengas bu' pi'uli'aan rema su dlaun neng miriyalem ri se ga'em neng Menulay, ay sud Diwata duma seniin. ");
INSERT INTO stb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Gami mekepemetuud gaid se dlaun nek pimbaalen riin seng nasud neg Israel bu' seg Jerusalem. Rayun pinatay giin pebiyan sek pedlansang ri seniin tu se krus. ");
INSERT INTO stb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ma'ad pitubu' giin puli' ned Diwata buwat se kemetain se ketelu endaw bu' mikpi'ita' giin, ");
INSERT INTO stb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","gena' tu se dlaunen, ma'ad ritu ra se ngang mikpemetuud ne ngak pimili' ned Diwata, ne gami itu, neng minaan bu' mininum duma seniin peketubusen mitubu' puli' buwat se kemetain. ");
INSERT INTO stb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Sinugu'en ami sek pegwali ri seng Melengas ne Gesuyen tu se nga getaw bu' sek pekpemetuud ne giin gaid suk pinili' ned Diwata neng mengengukum se ngang miktetubu' bu' se ngang mimatay. ");
INSERT INTO stb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Su dlaun ne ngak propeta migasuy metendeng ri seniin, neng miktalu' ne su dlaun neng mektu'u ri seniin pasayluun ri ngak sala' nilan pebiyan se ga'em ri se ngalanen.” ");
INSERT INTO stb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Saanay pa menintulu' ni Pedro, linumusad su Gispiritu Santu tu se dlaun ne ngang minginengeg tu seng minsahiin. ");
INSERT INTO stb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Su ngang mektetu'u ne ngag Judeo neng middunut riin ni Pedro buwat seg Jope mitingala ne su Gispiritu Santu binegay isan tu se nga gena' Judeo. ");
INSERT INTO stb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tendeng ay mirengeg nilan ne su nga gena' Judeo miktuntul ri se dlainlain ne ngak tinuntulan bu' miksaya' ri sek pekege'eman ned Diwata. Aas miktalu' si Pedro, ");
INSERT INTO stb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Mirawat na nilani Gispiritu Santu maa' seng mirawat nami. Duun baing mekepegeng ri senilan bu' bendyagan ilan ri sek tubig.” ");
INSERT INTO stb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Aas sinugu'en ilan sek pekpebendyag ri se ngalan ni Jesus Christ. Mbuus inandyu' nilan si Pedro neng mekpebilin reli' seled sek santa' endaw. ");
INSERT INTO stb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mbuus mirengegan nu nga gapustulis bu' nu ngang mektetu'u seg Judea ne su nga gena' Judeo dinumawat rema ri sek talu' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ma'ad sek pekpuli' ni Pedro seg Jerusalem, pimura giin ne ngag Judeo neng miktu'u ne su nga gena' Judeo kina'enlan mekpetuli' reli'ay se gendi' pa lumampu' ri senilan, laung, ");
INSERT INTO stb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Dya'a neg Judeo, lama meritua run seg balay ne nga getaw ne gena' nek tinuli' bu' middumaa maan ri senilan?” ");
INSERT INTO stb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Aas pisabut ni Pedro ri senilan su dlaun neng mihitabu' ri seniin buwat gaid ri se getaran: ");
INSERT INTO stb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Saanay'u megampu' ritu sek siyudad neg Jope, duunik pigita'u. Mi'ita'u sung maa' melambeg nek penepeten neng mitentun buwat ri se dlangit ne iniketan su gepaat nek sinurungaan bu' mikeneng ini ri seng megaud'u. ");
INSERT INTO stb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tinenteng'u ini bu' mi'ita'u su ngang mektetubu' ne ngang menanap—gayep bu' ngang malig, ngang menlekagang ri se dlupa', bu' ngang menlayug ri se gawanawanan. ");
INSERT INTO stb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mbuus mirengeg'u suk talu' neng miktalu' ri senaan, ‘Gindeg'a Pedro; pektiti'a bu' aan'a run nini!’ ");
INSERT INTO stb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ma'ad miksembagu, ‘Ndi' ini mehimu, Ginu'u, tendeng ay nda'u gaid mekekaan neng melemu' bu' nda' tugut aanen.’ ");
INSERT INTO stb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mbuus migeseb mektalu' suk talu' buwat se dlangit, ‘Ndi' mu telu'ay neng melemu' su isan landun ne dlinimpiyu na ned Diwata.’ ");
INSERT INTO stb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mitelu ini mehitabu' bu' peketubus binatun itu puli' tu se dlangit. ");
INSERT INTO stb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Bu' enlengay niyu, se guras ketu, duun remaik telu ne dlai buwat sek Cesarea neng minateng ritu seg balay nek pinaikan'u. ");
INSERT INTO stb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Su Gispiritu miktalu' ri senaan ne gendi'u medlegala' sek peddunut ri senilan. Keni ne genem tawan nek pated ta riin ni Christ ngak taga Jope middunut ri senaan tu sek Cesarea bu' miritu ami seg balay ni Cornelio. ");
INSERT INTO stb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Inesuyan ami ni Cornelio ned duuning mi'ita'en neg anghel ritu sek seled neg balain bu' miktalu' sug anghel ri seniin, ‘Peksugu'a ne nga getaw neng meritu seg Jope arun sek pegangay riin ni Simon Pedro. ");
INSERT INTO stb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Telu'aan'a bu' landunik pebiyan neng meluwas'a bu' suk pamilya mu.’ ");
INSERT INTO stb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Bu' seng migataru na sek pegasuy, linumusad su Gispiritu Santu ri senilan maa' rema sek pedlusaren ri senita nu guna ketu. ");
INSERT INTO stb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Bu' mi'ena'ena'u suk tinalu' ne Ginu'u, ‘Migbendyag si Juan ri sek tubig ma'ad gamu bendyagan ri se Gispiritu Santu.’” ");
INSERT INTO stb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Laung pa gaid ni Pedro, “Kelaru gupiya neg binegayan su nga gena' Judeo seng maa' run neg begay neg binegain ri senita seng miktu'u ita riin ni Jesus Christ ne Ginu'u; rayun ta'u ma sek pekpegeng ri sed Diwata?” ");
INSERT INTO stb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Sek pekerengeg run nitu ne ngang mektetu'u ne ngag Judeo, nda' na nilan pemuraay si Pedro. Tumu' sinaya' nilan sud Diwata, “Rayun, binegay rema ned Diwata se nga gena' Judeo sug higayun neng mekeddiksu' bu' metubu'.” ");
INSERT INTO stb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sud duma ne ngang mektetu'u neng mitipelak pebiyan sek pedlutus neng mihitabu' sek pekpatay riin ni Esteban mirepet sek Fenicia, sek Cyprus, bu' seg Antiyuk. Inasuy nilan sung minsahi ma'ad ritu ra se ngag Judeo. ");
INSERT INTO stb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ma'ad sud duma ne ngang mektetu'u nek taga Cyprus bu' taga Cirene miritu rema seg Antiyuk, bu' isan su nga Griego inesuyan rema nilan seng Melengas ne Gesuyen metendeng riin se Ginu'u ne si Jesus Christ. ");
INSERT INTO stb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Su ga'em ne Ginu'u riin senilan bu' melaun gairing miktu'u bu' migbegu riin se Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Penghitabu' keni mirengegan ne ngang mektetu'u seg Jerusalem, aas sinugu' nilan si Barnabas ritu seg Antiyuk. ");
INSERT INTO stb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Sek peddatengen ritu, pidleliyag giin tendeng ay mi'ita'en su kelengas ned Diwata tu se nga getaw ritu bu' inuliksegen ilan neng mengmelituuren riin se Ginu'u duma sek tibuuk nek pusung nilan. ");
INSERT INTO stb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Si Barnabas keni melengas gaid ne getaw. Pige'eman giin ne Gispiritu Santu bu' miktu'u gupiya ri sed Diwata. Tendeng ay migwali giin ri sek Talu' ned Diwata, melaun ritu sung miktu'u ri se Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mbuus miritu si Barnabas sek Tarsus arun sek pekpenengaw riin ni Saulo. ");
INSERT INTO stb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Sek pekiita'en ri seniin, inuwiten giin puli' tu seg Antiyuk. Sek tibuuk taun gaid ilan miktipung duma se ngang mektetu'u ritu sek simbaan bu' miktendu' ilan seng melaun ne nga getaw. Su ngak tinu'unan ri seg Antiyuk, gilan su guna giningelanan ne nga Christian. ");
INSERT INTO stb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sek panahun ketu, duuni ngak propeta seg Jerusalem neng miritu seg Antiyuk. ");
INSERT INTO stb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Suk sala ri senilan si Agabus. Migindeg giin bu' pebiyan ri se ga'em ne Gispiritu Santu, mingatuk giin ned duuni gembagel ne gutem neng mateng ri sek tibuuk neg benwa. (Keni mihitabu' sek panahun ni Claudio ne giini gari' seg Roma.) ");
INSERT INTO stb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aas su ngak tinu'unan miguyun ne suk salasala ri senilan mekpawit ne gabang para se nga kepeteran nilan seg Judea. ");
INSERT INTO stb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bu' binaal nilan rayun, bu' pinawit nilan suk selapi' tu se nga geseg ri sek simbaan pebiyan riin ni Barnabas bu' ni Saulo. ");
INSERT INTO stb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na sek panahun ketu, migatad si Ari' Herodes sek pedlutus sed duma ne ngak sakup sek simbaan. ");
INSERT INTO stb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pipatain si Santiago nek pated ni Juan pebiyan se kalis. ");
INSERT INTO stb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Sek pekiita'en dun nek pidleliyag su ngag Judeo, piperaapen rema si Pedro. (Mihitabu' ini sek panahun se Kese'ulugan sek Pan ne genda'irunik Pempetulinen.) ");
INSERT INTO stb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Dluwaten peraap si Pedro, piperisuun bu' pipeguwardiyaan ne gepaat lumpukan ne nga kustabli. Se kada sala ne dlumpukan, duunik pikpaat tawan. Pinelanu ni Herodes ne ukuman si Pedro ri seng metungenga'an ne nga getaw peketubus sek Paska. ");
INSERT INTO stb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Aas mikpebilin neng miperisu giin. Ma'ad mikpeddayun su ngang mektetu'u ri sek simbaan sek pegampu' ri sed Diwata seng melituuren gaid para seniin. ");
INSERT INTO stb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Se gebii se genda' pa uwitay ni Herodes tu se nga getaw si Pedro, miktulug si Pedro ri sek titenga' ned duwa' tawan nek sundalu. Binalud giin sed duwa' buuk ne nga kadina, bu' duun pai nga guwardiya neng migingat ritu se genga'an nek perisuwan. ");
INSERT INTO stb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bu' enlengay niyu, sek tikmal duunig anghel ne Ginu'u neng migindeg ritu, bu' mirelaagan suk seled nek perisuwan. Mbuus kinedyug nug anghel sug baga ni Pedro, tinanud giin bu' tinelu'an, “Peksempun'a, pegbuwat!” Bu' sek tikmal, midlekat su nga kadina neg binalud ri se nga gemegen. ");
INSERT INTO stb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Laung nug anghel, “Letekay muig baling mu bu' peksandalyas'a.” Binaal ini ni Pedro, bu' miktalu' pa gaid sug anghel, “Seluk mui dlambung mu bu' dlendug'a ri senaan.” ");
INSERT INTO stb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bu' midlendug giin tu seg anghel pegawas tu sek perisuwan. Nda' meketu'u si Pedro ne sug binaal neg anghel metuud ba; sek pektu'uun run mikteginep ma'ad giin. ");
INSERT INTO stb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mibiyanan ma'ad nilan su guna bu' su keruwa' ne nga guwardiya. Pekerepet nilan tu sek putaw ne genga'an neng mikpagaw tu sek siyudad, su genga'an mipuka ra bu' ginumawas ilan rayun. Pekesagad nilan sek sala ne kalsara, sek tikmal bineleng giin nug anghel. ");
INSERT INTO stb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Rituun pa misuunan ne gena' masi' nek teginepen na run sung mihitabu' ri seniin, laungen, “Metuud gaid nek pinawit ne Ginu'u sug anghelen arun luwasen naun ri se ga'em ni Herodes bu' se dlaun nek pirateng ne ngag Judeo neng mehitabu'.” ");
INSERT INTO stb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Sek pekesuun ni Pedro run seng metuud nek penghitabu', miritu giin seg balay ni Maria ne gina' ni Juan ne iningelanan rema neng Marcos. Melauni nga getaw ritu neng miktipung bu' migampu'. ");
INSERT INTO stb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Miksabi si Pedro ri se genga'an tu se gawas, aas ginumawas suk sesugu'en ne si Roda arun enlengan bu' ta' getaw sung minateng. ");
INSERT INTO stb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mi'ilelaan ni Roda suk talu' ni Pedro bu' se dleliyagen imbis pukaanen su genga'an, ginumebek na ma'ad tumu' giin puli' tu sek seled arun telu'an su ngak sementaunen ne si Pedro ritu se gawas. ");
INSERT INTO stb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Miktalu' ilan riin ni Roda, “Mibural'a na tingali!” Ma'ad minleges si Roda ned diin gaid si Pedro. Aas miktalu' ilan, “Ali' bu' anghel itu ni Pedro.” ");
INSERT INTO stb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ma'ad mikpeddayun gaid si Pedro sek peksabi. Aas pinuka nilan su genga'an bu' mi'ita' nilan giin, bu' mitingala ilan. ");
INSERT INTO stb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Sininyasan ilan ni Pedro ne gendi' meksasak bu' inasuyen ri senilan bu' pigendun giin sek pekpegawas ne Ginu'u buwat tu sek perisuwan. “Talu' niyu ini tu ni Santiago bu' sed duma pa ne ngang mektetu'u,” miktalu' giin. Mbuus midlaang giin bu' miritu se dlain ne dlugar. ");
INSERT INTO stb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na, sek pekesikanselem, migubet gupiya su nga kustabli tendeng seng mihitabu' riin ni Pedro. ");
INSERT INTO stb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Miksugu' si Herodes nek penengaun giin ma'ad nda' gaid nilan me'ita'. Aas pi'imbistigaren su nga guwardiya bu' pipatain ilan. Dluwat itu, migawa' si Herodes seg Judea. Miritu giin sek Cesarea bu' ritu na giin mikengel. ");
INSERT INTO stb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Linengetan gupiya si Ari' Herodes se nga getaw sek Tiro bu' sek Sidon. Aas, miguyun su nga getaw ne kumita' ilan se gari'. Se getaran sinambat reli' nilan si Blastus nek sineligan ne gari' ritu sek palasyu arun ebangan ilan. Rayun miritu ilan ni Herodes bu' liyagan nilan mekepeneguli' ilan ri seniin tendeng ay sung nasud nilan ritu ma pegengayan ne gaan seng nasud ne gari'. ");
INSERT INTO stb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Sek peddateng se gendaw ne kumita' ilan ri se gari', mikseluk si Ari' Herodes nek suub ne gari' bu' migingkud ri sek trunuun bu' middiskursu ri se nga getaw. ");
INSERT INTO stb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mimbeksay su nga getaw, “Gena' getaw sung migasuy keni bu' ndi' sud diwata.” ");
INSERT INTO stb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Bu' sinilutan rayun giin nug anghel ne Ginu'u tendeng ay nda'en pesiddengegay sud Diwata. Inuled giin bu' minatay. ");
INSERT INTO stb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ma'ad suk talu' ned Diwata mikpeddayun sek pedlelaup bu' melaun pa gairing mibaal neng mektetu'u. ");
INSERT INTO stb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Peketubus seng misyun nilan, minuli' si Barnabas bu' si Saulo buwat seg Jerusalem ne inuwit si Juan ne iningelanan rema neng Marcos duma senilan. ");
INSERT INTO stb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ri sek simbaan seg Antiyuk, duuni ngak propeta bu' ngang menintulu'. Gilan si Barnabas, si Simeon ne giningelanan ne si Miitem, si Lucio nek taga Cirene, si Manaen neng miksibagel riin sek penimalay ni Herodes bu' si Saulo. ");
INSERT INTO stb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Saanay miksimba ilan ri se Ginu'u bu' mikpu'asa, miktalu' su Gispiritu Santu ri senilan, “Pain niyu para senaan si Barnabas bu' si Saulo tendeng ay duunik pebaal'u ri senilan.” ");
INSERT INTO stb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Aas mikpu'asa ilan bu' migampu' bu' dinepenan nilan si Barnabas bu' si Saulo bu' rayun pilaang ilan. ");
INSERT INTO stb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Sek peksugu' ne Gispiritu Santu ri ni Barnabas bu' ni Saulo, tinumegbeng ilan pagaw sek Siliyusiya. Buwat ritu, sinumakay ilan pagaw tu sek timuwalag nek Cyprus. ");
INSERT INTO stb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Sek peddateng nilan se dlunsud nek Salamis, minintulu' ilan sek talu' ned Diwata ritu se ngak pektiguman nu nga getaw Judeo. Si Juan sementaun rema nilan arun sek pegabang ri sek terbahu nilan. ");
INSERT INTO stb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Se dlinaang nilan suk tibuuk nek timuwalag, mirepet ilan tu sek Pafos. Ritu, duuning mi'ita' nilan neng madyikiru ne giningelanan neg Bar-Jesus. Judeo giin bu' inangkenen nek propeta giin. ");
INSERT INTO stb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Sambat giin ni Sergio Paulo ne gobernador sek timuwalag ketu. Si Sergio Paulo metau ne getaw. Pitawagen si Barnabas bu' si Saulo tendeng ay liyagaan menginengeg ri sek talu' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ma'ad binelebagan ilan nung madyikiru ne si Elimas (giin nini su ngalanen ri se Griego). Pinemalaan gaid ne liyaun su gobernador buwat sek pektu'u ri se Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ma'ad si Saulo, ne giningelanan rema nek Pablo pige'eman ne Gispiritu Santu, tinentengen sung madyikiru ");
INSERT INTO stb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","bu' miktalu', “Bata'a neng Menulay! Kuntraa se dlaun neng melengas! Mipenu'a se dlaun neng mikeleseles ne kelaatan bu' nek penlimbung. Iniles mu su kemetuuran metendeng ri se Ginu'u arun mbaal neg balus. ");
INSERT INTO stb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nandaw silutan'a ne Ginu'u. Mpayatpayat suk pekebuta mu bu' ndi'a mekiita' sed delaag ne gendaw.” Bu' rayun binatik ni Elimas ned duuning maa' ne gabun neng mitampeng ri seng mataan, bu' mikpengekap ra run giin sek pekpenengaw neng megagak ri seniin. ");
INSERT INTO stb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Sek pekiita' ne gobernador run sung mihitabu' riin ni Elimas, miktu'u giin bu' mitingala gaid giin sek tintulu'an metendeng ri se Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pegawa' nilan ni Pablo sek Pafos, sinumakay ilan pagaw sek Perga, suk siyudad ri sek probinsiya nek Pamfilia. Peddateng nilan ritu, bineleng ilan ni Juan Marcos bu' mipuli' giin seg Jerusalem. ");
INSERT INTO stb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Buwat sek Perga, gilan ni Pablo linumegbas tu seg Antiyuk nek sakup sek probinsiya nek Pisidia. Peddateng se Gendaw nek Pengulali, sinumeled ilan tu sek pektiguman bu' migingkud ritu. ");
INSERT INTO stb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bu' peketubus sek pegbasa se Kesugu'an ni Moses bu' se ngak sinulat ne ngak propeta, miksugu' su nga gupisyal ne getaw sek pektalu' ri senilan ni Pablo, “Nga kepeteran, bu' duuning metalu' niyu neng mekepeddasig ri se nga getaw, asuy niyu.” ");
INSERT INTO stb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Aas migindeg si Pablo bu' sininyasanen su nga getaw, bu' migatad giin sek pektalu: “Nga kepeteran'u ne nga getaw Israel bu' gamu neng miksimba ri sed Diwata, penginengegay niyau. ");
INSERT INTO stb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Sud Diwata ne nga getaw Israel, giining mimili' ri se nga gepu'an ta bu' pidlaunen ilan saanay sek panahun neng mikengel ilan tu seg Ehipto gisip tuwa'. Bu' pebiyan ri se ga'emen, pigawas ilan ned Diwata ritu seg Ehipto. ");
INSERT INTO stb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Seled se gepaat pulu' taun, saanay ritu ilan se kemingawan, migagwanta sud Diwata riin senilan. ");
INSERT INTO stb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Peketubus daagay nud Diwata suk pitu buuk neng nasud se dlupa' se Cana'an bu' binegain su dlupa' ketu se nga gepu'an ta gisip gempenunud nilan. ");
INSERT INTO stb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Dlaunen keni mihitabu' seled se gepaat gatus bu' lima pulu' taun.” “Peketubus ini binegayaan ilan ne ngang mengengukum arun medlegeseg ri senilan tampan sek timpu ni Samuel, nek propeta. ");
INSERT INTO stb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bu' seng minengi ilan ne gari', binegay ned Diwata si Saulo neg bata' ni Kis buwat sek tribu ni Benjamin arun medlegari' ri senilan seled se gepaat pulu' taun. ");
INSERT INTO stb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sek pipe'awa' na ned Diwata si Saulo ne gari', si David na pelunik pinili'en neng medlegari' ri senilan. Giin nini suk tinalu' ned Diwata, ‘Mi'ita'u ne si David neg bata' ni Jesse sala neng mekepedleliyag ri senaan bu' megbaal se dlaun nek pebaal'u ri seniin.’” ");
INSERT INTO stb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Sud Diwata miksaad ned duunik sala neg buwat se gesalan ni David neng mateng sek pedluwas se nga getaw Israel, bu' su getaw ketu si Jesus. ");
INSERT INTO stb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Se genda' pa pegatad si Jesus sek terbahuun, migwali na si Juan tu se nga getaw Israel arun meddiksu' ilan buwat ri se ngak sala' nilan bu' mekpebendyag. ");
INSERT INTO stb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Na, seng megaud na metubus ni Juan suk terbahuun, miktalu' giin tu se nga getaw, ‘Ta'u ma ne getaw sek pegena'ena' niyu? Gena' gaku' suk pirateng niyu. Ma'ad duuning meksunud ri senaan neng merini, bu' ndi'u mbaya' isan sek pegesu' sek sandalyas ri se geksuren.’” ");
INSERT INTO stb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Nga kepeteran, gamu nga gesalan ni Abraham bu' gamu ngang minsimba rema ri sed Diwata, gita suk pinewitan ned Diwata seng minsahi se keluwasan. ");
INSERT INTO stb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ma'ad su ngag Judeo neng mikengel seg Jerusalem bu' su ngak pengulu nilan nda' pegilala riin ni Jesus ne giining Menleluwas. Nda' ilan rema mekesabut se ginasuy ne ngak propeta metendeng ri seniin nek pigbasa nilan kada Gendaw nek Pengulali. Tumu' pituman nilan suk pingatuk ne ngak propeta ri sek pegukum nilan riin ni Jesus. ");
INSERT INTO stb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Isan genda'iruning meligen ne keterengan nilan arun petain si Jesus, pinengi gaid nilan riin ni Pilato nek petain giin. ");
INSERT INTO stb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Rayun su dlaun neng misulat riin se Kesulatan metendeng riin seniin mituman na. Bu' seng minatay na si Jesus, inawa' giin ritu se krus bu' binetang riin se dlebengan. ");
INSERT INTO stb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ma'ad pitubu' giin puli' ned Diwata buwat ri se kemetain. ");
INSERT INTO stb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Bu' seled seng melaun ne nga gendaw, mikpe'ita' giin ri se nga getaw neng middunut ri seniin buwat se Galilea tampan seg Jerusalem. Nga getaw ketu, gilan nemuun sung mikpemetuud para seniin ritu se nga getaw Israel. ");
INSERT INTO stb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Bu' keni ami nandaw arun esuyan amu ri seng Melengas ne Gesuyen nek sinaad ned Diwata ri se nga gepu'an ta, ");
INSERT INTO stb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nek tinuman nemuun ri senita nu nga gesalan nilan. Binaalen nini pebiyan ri sek pekpetubu' riin ni Jesus. Giin nini sung misulat ri se keruwa' nek Salmo, ‘Dya'a sug Bata'u; Nandaw gaku' mibaal ne Gama' mu.’ ");
INSERT INTO stb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Bu' giin nini suk tinalu' ned Diwata metendeng sek pekpetubu'en ri seniin buwat se kemetain, su dlawasen ndi' melasak riin se dlebeng, ‘Begay'u ri seni'a sug bala'an ne ngak pengumpiya nek sinaad'u riin ni David.’ ");
INSERT INTO stb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Aas tinalu'en pa gaid ri se dlain nek Salmo, ‘Ndi' mu tugut ne sung melituuren mu nek sesugu'en melasak ri se dlebeng.’ ");
INSERT INTO stb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Ay ri se dlain neg bahin, minibeli si David se ketuyu'an ned Diwata ri sek panahunen, bu' rayun minatay giin, bu' linebeng ritu se dlinebengan nu nga gepu'aan, bu' su dlawasen milasak ri se dlebengan. ");
INSERT INTO stb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ma'ad ri se dlain neg bahin, suk pitubu' puli' ned Diwata buwat ri se kemetain nda' gaid melasak tu se dlebengan. ");
INSERT INTO stb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Aas kina'enlan mesuunan niyu ne nga kepeteran, neng mekepasaylu se ngak sala' si Jesus. Su Kesugu'an ni Moses ndi' mekepegawas ri seniyu buwat ri se ngak sala' niyu. Ma'ad suk salasala neng mektu'u riin ni Jesus duuni keguwasan buwat ri sek sala'. ");
INSERT INTO stb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Aas pengandam amu arun ndi' mehitabu' ri seniyu suk tinalu' ne ngak propeta: ");
INSERT INTO stb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Enlengay niyu, gamu ngang meddega'rega', metingala amu bu' mematay amu! Ay duunig baalen'u ri sek panahun niyu, ngag betang ne ndi' amu gaid meketu'u, isan duun paing mekpesabut run seniyu.’” ");
INSERT INTO stb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Sek pedlegawas na ni Pablo bu' ni Barnabas sek pektiguman, tinelu'an ilan nu nga getaw ne mpuli' sek sunud ne Gendaw nek Pengulali arun me'esuyan ilan pa parun metendeng ri se ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Dluwat sek tipung ketu, melaun ne ngag Judeo bu' gena' Judeo suk sinumakup ri seg rilihiyun se nga getaw Judeo neng middunut riin ni Pablo bu' ni Barnabas. Tinelu'an nilan su nga getaw keni bu' inulikseg ilan neng mekpeddayun sek pedleketubu' ri se kepiya ned Diwata. ");
INSERT INTO stb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na, sek pekesunud ne Gendaw nek Pengulali, migela'gela' mektipung su dlaun ne nga getaw ri se dlunsud arun menginengeg ri sek talu' ne Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Sek pekiita' ne ngag Judeo neng melauni nga getaw neng minditu, misinaku ilan gaid; bu' sinupak nilan su nga ginasuy ni Pablo bu' pingumpiid nilan giin. ");
INSERT INTO stb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ma'ad miksamet pa su kebelu' ni Pablo bu' ni Barnabas. Laung nilan, “Kina'enlan gaid neng metintulu' reli' rini seniyu suk talu' ned Diwata. Ma'ad tendeng ay bineleng niyu giin bu' migukum amu ri se gegulingen niyu ne gena' gembaya' ri se ketubu' ne genda'ik tamanen, belengen amu nami bu' meritu ami se nga gena' Judeo. ");
INSERT INTO stb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tendeng ay giin nini suk sinugu' ri senami ne Ginu'u: ‘Binaal'u dya'a ned delaag ri se nga gena' Judeo, arun pebiyan ri seni'a su keluwasan medlelaup ri sek tibuuk neg benwa.’” ");
INSERT INTO stb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Sek pekerengeg run nini ne nga gena' Judeo, pidleliyag ilan bu' sinaya' nilan sung minsahi ne Ginu'u. Bu' su dlaun ne ngang mipili' para se ketubu' ne genda'i gekteben mibaal neng mektetu'u. ");
INSERT INTO stb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Bu' midlelaup suk talu' ne Ginu'u sek tibuuk ne dlugar ketu. ");
INSERT INTO stb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ma'ad pig'ulug'ulugan nu ngag Judeo su nga dlibun neg rilihiyusu bu' inila, bu' su nga geseg sek siyudad. Aas linutus nilan si Pablo bu' si Barnabas bu' pipe'awa' nilan se dlugar ketu. ");
INSERT INTO stb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tinektak ni Pablo bu' ni Barnabas sug bembun ri se nga geksud nilan gisip gilelaan kuntra ri senilan bu' miritu ilan seg Ikonio. ");
INSERT INTO stb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ritu seg Antiyuk, pidleliyag gaid su ngak tinu'unan ni Jesus bu' pige'eman ilan ne Gispiritu Santu. ");
INSERT INTO stb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Na, maa' run rema sung mihitabu' ritu seg Ikonio, miritu si Pablo bu' si Barnabas sek pektiguman nu nga getaw Judeo bu' tendeng sek pegwali nilan, melaun ne ngag Judeo bu' gena' Judeo sung mibaal ne ngang mektetu'u. ");
INSERT INTO stb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ma'ad su ngag Judeo ne genda' pektu'u pig'ulug'ulugan nilan su nga gena' Judeo arun megena'ena' ilan neng melaaten ri se ngang mektetu'u. ");
INSERT INTO stb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mikengel ritu si Pablo bu' si Barnabas se gempayat nek panahun. Se genda'i gendek migwali ilan metendeng ri se Ginu'u neng mikpemetuud ne sung minsahi metendeng ri se kelengasen metuud gaid pebiyan sek pegbegay ri senilan ne ga'em sek pegbaal ne ngang milagru bu' ketingelaan. ");
INSERT INTO stb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mibahin su nga getaw ritu sek siyudad ketu; sud duma linumamig ri se ngag Judeo bu' sud duma linumamig ri se nga gapustulis. ");
INSERT INTO stb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Duuni nga gena' Judeo bu' Judeo duma se ngak pengulu nilan neng mikpelanu nek pegeelan su nga gapustulis bu' betuun ilan. ");
INSERT INTO stb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Sek pekesuun ne nga gapustulis metendeng run itu, minlaguy ilan tu sed Listra bu' sed Derbe, ngak siyudad nek sakup sed Licaonia, bu' ritu sek timala' ne nga dlugar. ");
INSERT INTO stb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Bu' mikpeddayun suk pekpenintulu' nilan seng Melengas ne Gesuyen ritu. ");
INSERT INTO stb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Sed Listra, duunik sala ne getaw ne gendi' mekedlaang tendeng ay bekul giin buwat pa sek pegegetaun. ");
INSERT INTO stb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Migingkud giin ritu bu' minginengeg giin se nga ginasuy ni Pablo. Tinenteng giin ni Pablo ay mibatiken ned duunik pektu'uun neng me'uli'an giin. ");
INSERT INTO stb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Aas seng mesekeg nek talu', migasuy si Pablo ri seniin, “Pegbuwat'a, peleddeng mui gindeg mu!” Linumeksu su getaw bu' migatad medlaanglaang. ");
INSERT INTO stb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Sek pekiita' nu nga getaw run sug binaal ni Pablo, migbeksay ilan sek tinuntulan ned Licaonia, “Su ngad diwata mibaal neng maa' ne nga getaw bu' mimenaug riin senita!” ");
INSERT INTO stb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Iningelanan nilan si Barnabas ne si Zeus bu' si Pablo iningelanan si Hermes tendeng ay giining mengangasuy. ");
INSERT INTO stb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Suk templo ned diwata nilan ne si Zeus megaud ra ri seg biyanan pagaw ritu sek siyudad. Aas suk pari' ni Zeus miguwit ne ngak turu neg baka bu' ne ngag bulak ri se nga genga'an nek siyudad, tendeng ay liyagaan bu' su nga getaw neng mengilak tu se nga gapustulis. ");
INSERT INTO stb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Sek pekerengeg ni Barnabas bu' ni Pablo seg binaal nilan, pimbeddit nilan su ngak suub nilan bu' ginumebek ilan ri sek titenga' ne nga getaw bu' migbeksay, ");
INSERT INTO stb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ngak sambat, tuma ma mengilak amu ri senami? Gami nga getaw ra neng maa' ri seniyu. Tinintulu' nami ri seniyu sung Melengas ne Gesuyen arun teliyuran niyui ngag betang keni ne genda'irunik paluun bu' mpuli' amu ri sed Diwata neng miktetubu' neng migbaal se dlangit, se dlupa', sed dagat, bu' se dlaun ne ngag betang ned diin senilan. ");
INSERT INTO stb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nud diin, pisaddan ma'ad ned Diwata su nga getaw sek peksunud ri se gegulingen nilan ne nga keliyag. ");
INSERT INTO stb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ma'ad kanunay giin mekpemetuud ri se gegulingenen pebiyan ri seng melengas ne ngag betang nek pimbaalen. Binegayan amu ned dupi' buwat se dlangit bu' ne ngak timpu neng melaun ne ngak sengku'; bu' binegayan amu nek pekaan bu' pidleliyag amu gupiya.” ");
INSERT INTO stb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Isan su nga gapustulis sung miktalu' run nini, ndi' gaid nilan mpegengan su nga getaw nek pengilakan ilan. ");
INSERT INTO stb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Na, minateng sud duma ne ngag Judeo neng migbuwat pa seg Antiyuk nek sakup sek Pisidia bu' su ngad duma buwat seg Ikonio. Inenggat nilan su nga getaw neng medduma ri senilan neg betuun si Pablo bu' binidlas nilan tu se gawas ne dlunsud ay migena'ena' ilan neng minatay na giin. ");
INSERT INTO stb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ma'ad saanay linibutan giin nu ngak tinu'unan, migbuwat giin bu' mipuli' ilan tu se dlunsud. Sek pekemanlema' miritu ilan duwa' ni Barnabas sed Derbe. ");
INSERT INTO stb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Migwali si Pablo bu' si Barnabas seng Melengas ne Gesuyen ritu sed Derbe bu' melauning mibaal ne ngak tinu'unan. Peketubus ini, mipuli' ilan sed Listra, seg Ikonio, bu' seg Antiyuk nek sakup sek Pisidia. ");
INSERT INTO stb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pimpeligen nilan su ngang mektetu'u bu' inulikseg neng mekpebilin gaid ri sek pektu'u. “Kina'enlan mbiyanan ta sung melaun ne nga keliseran sek pekseled ri sek pedlegari' ned Diwata.” ");
INSERT INTO stb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Se kada nek simbaan, mikpili' ilan ne nga geseg; migampu' bu' mikpu'asa ilan para tu se ngak pinili' nilan bu' piniyal nilan ilan ri se Ginu'u nek sineligan nilan. ");
INSERT INTO stb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Rayun minayan ilan tu sek Pisidia bu' mirepet ilan sek Pamfilia. ");
INSERT INTO stb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Migwali ilan ritu sek Perga bu' mbuus dinumiksun ilan tu seg Atalia. ");
INSERT INTO stb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Buwat ritu, sinumakay ilan puli' pagaw seg Antiyuk, nek sakup sek Syria ned ditu ilan piniyal tu sed Diwata neng migbegay ri senilan ne kepiya para seg baalen neng mitubus na nilan nemuun. ");
INSERT INTO stb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sek peddateng ni Pablo bu' ni Barnabas seg Antiyuk, tinipung rayun nilan su dlaun ne ngak sakup ri sek simbaan bu' inasuy nilan rayun su dlaun neg binaal ned Diwata pebiyan ri senilan, bu' sek pegbegay nek panahun arun mektu'u rema su nga gena' Judeo. ");
INSERT INTO stb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bu' mikengel ilan ritu ne gempayat duma se ngang mektetu'u. ");
INSERT INTO stb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Duunik santa' tawan neng mindateng seg Antiyuk buwat seg Judea bu' mimandu' se ngang mektetu'u, “Bu' ndi' amu mekpetuli' sumala' ri sek tinendu' se Kesugu'an ni Moses, ndi' amu meluwas.” ");
INSERT INTO stb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Na, gembagel gupiya suk peksupak ni Pablo bu' ni Barnabas se ketendu'an keni. Aas piguyunan ne si Pablo bu' si Barnabas bu' santa' tawan seg Antiyuk neng meritu seg Jerusalem arun kumita' se nga gapustulis bu' ri se nga geseg metendeng ri seg betang keni. ");
INSERT INTO stb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mbuus sinugu' ne ngang mektetu'u ri sek simbaan ilan ni Pablo. Sek pegbiyan nilan sek Fenicia bu' sek Samaria, pisuun nilan ne su nga gena' Judeo miktu'u na riin sed Diwata. Gesuyan keni migbegay nek pedleliyag gupiya tu se dlaun neng mektetu'u. ");
INSERT INTO stb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Sek peddateng nilan ni Pablo seg Jerusalem, dinawat ilan ne ngang mektetu'u ri sek simbaan, ne nga gapustulis bu' ne nga geseg. Inasuy nilan su dlaun neg binaal ned Diwata pebiyan ri senilan. ");
INSERT INTO stb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ma'ad duuni ngang mektetu'u ritu nek sakup ne ngak Pariseo. Migindeg ilan bu' miktalu', “Kina'enlan nek tuli'en su nga gena' Judeo bu' esuyan ilan neng mekpetuud ri se Kesugu'an ni Moses.” ");
INSERT INTO stb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Aas miktipung su nga gapustulis bu' su nga geseg arun peksebutan nilani ngag betang keni. ");
INSERT INTO stb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Dluwati gempayat nek pegaddat, migindeg si Pedro bu' miktalu', “Nga kepeteran, misuunan na niyu nek pinili'u ned Diwata buwat ri seniyu nud diin arun tintulu'u sung Melengas ne Gesuyen tu se nga gena' Judeo arun mekerengeg ilan rema bu' mektu'u. ");
INSERT INTO stb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Bu' sud Diwata, neng mikesuun ri se gena'ena' se kada sala, pi'ita' ned dinawaten rema su nga gena' Judeo ay binegain ma rema su Gispiritu Santu ri senilan maa' seg binaalen ri senita nud diin. ");
INSERT INTO stb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nda'i kelainan metendeng ri senita bu' ri senilan; Pinasayluun su ngak sala' nilan tendeng ri sek pektu'u nilan. ");
INSERT INTO stb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Lama pegindanan niyu run sud Diwata pebiyan sek pekpepisaan se nga kebegat para ri se ngang mektetu'u ne isan su nga gepu'an ta bu' gita mismu ndi' mekepisaan run? ");
INSERT INTO stb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ma'ad miktu'u ita nek pebiyan se kepiya ne Ginu'u ne si Jesus, meluwas ita maa' rema se nga gena' Judeo.” ");
INSERT INTO stb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bu' su dlaun ne nga getaw neng miktipung nda' rayun peksasak. Pinginengegan nilan su ginasuy ni Barnabas bu' ni Pablo metendeng se nga ketingelaan bu' ngang milagru neg binaal ned Diwata pebiyan ri senilan tu se nga gena' Judeo. ");
INSERT INTO stb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Peketubus nilan mektalu', laung ni Santiago, “Nga kepeteran penginengegay niyau. ");
INSERT INTO stb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Inasuy ri senita ni Simeon su guna nek pekpe'ita' sek pedlekata ned Diwata ri se gena' Judeo sek peguwan buwat ri senilan ne nga getaw neng mesakup para seniin. ");
INSERT INTO stb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Su ngak tinalu' nu ngak propeta minuyun run nini sumala' sek tinalu' se kesulatan, ");
INSERT INTO stb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Dluwat ini mpuli'u, miktalu' su Ginu'u, bu' pe'indegen'u puli' suk pidlegeri'an ni David neng mipuwan. Pe'indegen'u puli' sung migeba' bu' baalen nini neng meligen puli' ");
INSERT INTO stb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","arun sud duma ne nga getaw menengaw ri se Ginu'u, su dlaun ne nga gena' Judeo nek pintawag'u mbaal ne getawan'u. ");
INSERT INTO stb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Giin nini suk tinalu' ne Ginu'u, nek pisuun se gempayat na nek panahun.’” ");
INSERT INTO stb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Aas ri se gena'ena'u,” mikpeddayun sek pektalu' si Santiago, “ndi' ta lisedliseren su nga gena' Judeo neng miktu'u ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ma'ad kina'enlan nek sulatan ta ilan ne ndi' maan se nga gaan ne ginilak tu se ngad diwatadiwata. Liyawan nilan sug imural nek pekighilawas; bu' ndi' ilan maan se karni ne ngang mektetubu' neng milengek awas dugu'. ");
INSERT INTO stb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ay su Kesugu'an ni Moses binasa se gempayat nek panahun ri se ngak pektiguman nilan se kada Gendaw nek Pengulali, bu' su ngak talu'en winali ri se kada dlunsud.” ");
INSERT INTO stb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Bu' ritu miguyun su nga gapustulis, bu' su nga geseg, bu' sud duma ne ngang mektetu'u ri sek simbaan neng memili' ilan ne nga dlai buwat ri sek sakup nilan arun perunuten ilan riin ni Pablo bu' ni Barnabas seg Antiyuk. Pinili' nilan si Judas ne giningelanan neg Barsabas bu' si Silas nek pigbesaan ne ngang mektetu'u. ");
INSERT INTO stb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tinalu' tu sek sulat nek pinawit ri senilan: “Gami, nga gapustulis bu' nga geseg ri sek simbaan keni, mingumusta ri se nga kepeteran ne gena' Judeo riin seg Antiyuk, Syria, bu' Cilicia. ");
INSERT INTO stb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mirengeg nami ned duuni nga getaw buwat rini senami bu' linibeg amu nilan pebiyan ri sek tinalu' nilan. Ma'ad nda' nami gilan sugu'ay neng menintulu' neng maa' niin. ");
INSERT INTO stb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Aas seng miktipung ami, miguyun ami neng memili' ne nga getaw nek sugu'en nami riin seniyu. Meddunut ilan ri ni Barnabas bu' ni Pablo, suk pinetail ta ne nga kepeteran. ");
INSERT INTO stb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Binegay nilan su ketubu' nilan para sek pegbaal ri seg baalen ne Ginu'u ta ne si Jesus Christ. ");
INSERT INTO stb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Aas sinugu' nami ri seniyu si Judas bu' si Silas arun megasuy rema metendeng se ngag betang nek tinalu' riin sek sulat nami kiin. ");
INSERT INTO stb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Melengas para se Gispiritu Santu bu' ri senami ne gendi' dugangan su nga kebegat nek pepisaan ri seniyu gawas ri se kina'enlan nek sunuren niyu ne ngag bala'ud: ");
INSERT INTO stb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ndi' amu maan se nga gaan ne ginilak tu se ngad diwatadiwata; ndi' amu maan ned dugu' bu' karni ne ngang mektetubu' neng milengek; bu' liyaway niyu sug imural nek pekighilawas. Bu' liyawan niyui ngag betang keni, mekegbegay ini ri seniyu ne kepiyanan. Gekteb na ma'aray rini.” ");
INSERT INTO stb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mbuus midlaang su nga getaw nek sinugu' nilan bu' miritu seg Antiyuk. Tinipung nilan su dlaun ne ngang mektetu'u bu' binegay rayun nilan suk sulat. ");
INSERT INTO stb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pekebasa run nini nu ngang mektetu'u, pidleliyag ilan gupiya bu' mi'uliksegan ilan ri seng minsahi. ");
INSERT INTO stb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Si Judas bu' si Silas ne ngak propeta rema neng mimandu' seng melaun ne ngag betang tu se ngang mektetu'u arun sek pegulikseg ri senilan. ");
INSERT INTO stb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Gempayatpayat suk pekengel nilan ritu bu' dluwat itu, pilaang ilan nu ngang mektetu'u duma sek pekpengumpiya bu' mipuli' ilan tu seng miksugu' ri senilan. ");
INSERT INTO stb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ma'ad si Pablo bu' si Barnabas duma se dlaunan mikpebilin ritu seg Antiyuk neng mimandu' bu' migwali sek talu' ne Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Dluwat suk santa' endaw, miktalu' si Pablo riin ni Barnabas, “Puli'an ta bu' bentaun ta su ngang mektetu'u ri se kada ne dlunsud ned ditu ita migwali sek talu' ne Ginu'u, bu' enlengan ta bu' landuni kebetang nilan.” ");
INSERT INTO stb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Miliyag si Barnabas ma'ad liyagaan ne uwiten si Juan Marcos. ");
INSERT INTO stb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ma'ad ndi' liyagan ni Pablo nek perunuten si Juan Marcos tendeng ay se guna nek peddunuten ri senilan, binelengen ilan ritu sek Pamfilia bu' nda' giin pekpeddayun sek pedduma ri senilan ri sek terbahu. ");
INSERT INTO stb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mibaal nilan ne dlalis, aas miksuway ilan. Inuwit ni Barnabas si Marcos bu' sinumakay ilan pagaw sek Cyprus, ");
INSERT INTO stb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","saanay si Pablo pinili' si Silas bu' midlaang, tubus ilan piniyal nu ngang mektetu'u ri se kepiya ne Ginu'u. ");
INSERT INTO stb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Miritu ilan ni Pablo sek probinsiya nek Syria bu' Cilicia sek pedligen se ngang mektetu'u riin se ngak simbaan. ");
INSERT INTO stb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Mirepet ilan ni Pablo tu sed Derbe bu' sed Listra. Bu' enlengay niyu, duunik tinu'unan ne iningelanan ne si Timoteo. Su gina'en Judeo bu' mektetu'u rema, ma'ad su gama'en Griego. ");
INSERT INTO stb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Su ngang mektetu'u ritu sed Listra bu' seg Ikonio mikesaya' riin ni Timoteo. ");
INSERT INTO stb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Liyagan ni Pablo ne uwiten si Timoteo duma ri senilan, aas tinuli'en nini tendeng ay su dlaun ne ngag Judeo neng mikengel se nga dlugar ketu mikesuun ne Griego su gama' ni Timoteo. ");
INSERT INTO stb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sek pedditu nilan se nga dlunsud, pisabut nilan tu se ngang mektetu'u su ngag bala'ud ne mbaya' baalen nek piguyunan ne nga gapustulis bu' ne nga geseg ritu seg Jerusalem. Inesuyan nilan su ngang mektetu'u nek tumanen nilan ini. ");
INSERT INTO stb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Aas linumigen pa gaid suk pektu'u ne ngang mektetu'u ri se ngak simbaan bu' su ngang mektetu'u miksilaun pa gaid se kada gendaw. ");
INSERT INTO stb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Miritu ilan se nga dlugar sek Frigia bu' Galacia, tendeng ay nda' ilan tugutay ne Gispiritu Santu neng megasuy seng Melengas ne Gesuyen ritu sek probinsiya neg Asia. ");
INSERT INTO stb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Sek peddateng nilan se gelet neng Misia, sinulayan siya nilan meritu sek probinsiya neg Bitinia, ma'ad su Gispiritu ni Jesus nda' pektugut ri senilan. ");
INSERT INTO stb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Aas minayan ilan na ma'aray sek probinsiya neg Misia bu' dinumiksun tu sek Troas. ");
INSERT INTO stb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Se gebii ketu, duunik pegita'en ni Pablo neng mi'ita'en suk sala tawan nek taga Macedonia neng migindeg bu' mikpe'ilelaat ri seniin, “Dipag'a rini seng Macedonia bu' ebangay mu ami!” ");
INSERT INTO stb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Sek pekiita' ni Pablo run sek pegita'en ketu, miksempun ami rayun mengandam sek pedditu seng Macedonia, tendeng ay miktu'u ami nek tinawag ami ned Diwata sek pegwali seng Melengas ne Gesuyen se nga getaw ritu. ");
INSERT INTO stb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Sinumakay ami gatad sek Troas bu' linumegbas sek timuwalag nek Samotracia, bu' sek sunud ne gendaw, miritu ami seng Neapolis. ");
INSERT INTO stb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Buwat ritu miritu ami sek Filipos ne giini gembagel nek siyudad sed distritu neng Macedonia bu' sakup seg Roma. Mikengel ami ritu sek santa' endaw. ");
INSERT INTO stb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Se Gendaw nek Pengulali, ginumawas ami tu sek siyudad bu' miritu se geksid nek tubig tendeng ay migena'ena' ami ned duuni dlugar ritu nek pektiguman ne nga getaw Judeo arun megampu'. Migingkud ami bu' miktuntul ri se nga dlibun neng miktigum ritu. ");
INSERT INTO stb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Sala se ngang minginengeg ri senami si Lydia nek taga Tiyatira. Mimeledya' giin ne ngang melaga' nek penepeten nek tinina' neng melagemlagem bu' miksimba rema ri sed Diwata. Na, pi'ena'ena' gupiya nu Ginu'u ri seniin su ngak tinalu' ni Pablo. ");
INSERT INTO stb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Bu' rayun mikpebendyag giin bu' su dlaun neng mikengel tu seg balain. Peketubus, inenggaten ami neng meritu seg balain, laungen, “Ritu amu bu' pekengel amu seg balay'u bu' miktu'u amu ne gaku' metuud neng mektetu'u ne Ginu'u.” Bu' dinawat nami suk pegenggaten. ");
INSERT INTO stb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sala ne gendaw ketu, saanay mikpagaw ami se dlugar nek pektiguman sek pegampu', linabet ami neg bata' relaga ne gulipen nek pige'eman neng melaat ne gispiritu neng megbegay ri seniin nek sinuunan sek pekpengatuk se ngak penghitabu'. Gembagel sung miselapi' nu nga gegalenen pebiyan ri sek sinuunaan sek pekpengatuk. ");
INSERT INTO stb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mbuus dlibun keni meddendugdendug ri senami ni Pablo bu' migbeksay, “Nga getaw keni ngak sesugu'en ne Dlabi neng Mekegega'em ned Diwata. Pisuun nilan ri seniyu bu' pegendunen run niyu arun meluwas amu!” ");
INSERT INTO stb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Na, kada gendaw giin itu sug binaalen tampan misemukan na si Pablo. Aas inatubangen su dlibun bu' tinelu'an sung melaat ne gispiritu, “Se ngalan ni Jesus Christ, sinugu'u dya'a sek pegawas ri seniin!” Bu' migawa' rayun ri seniin sung melaat ne gispiritu sek panahun ketu. ");
INSERT INTO stb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Sek pekiita' ne nga gegalenen ne gendi' na giin mpenelepi'an nilan, dinaap nilan si Pablo bu' si Silas bu' binidlas nilan tu se gukuman arun mengatubang tu se nga geseg tu se dlugar ketu. ");
INSERT INTO stb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Miktalu' ilan tu se nga geseg nek taga Roma, “Nga getaw keni ngag Judeo bu' miguwit ilan ne kesamuk rini sek siyudad ta. ");
INSERT INTO stb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Mimandu' ilan ne ngak pemetasan nek supak ri se kesugu'an ta. Ngak taga Roma ita, aas ndi' ita mekerawat se ngak pemetasan keni awas ndi' ta ini mbaal.” ");
INSERT INTO stb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Bu' inabang pegeelay nu nga getaw gilan ni Pablo. Pimbeddit rayun nu nga geseg su ngak suub ni Pablo bu' ni Silas bu' miksugu' ne lekpesen ilan rayun. ");
INSERT INTO stb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tubus seng melebiyan nek pedlekpes ri senilan, piperisu ilan. Sinugu' nilan su guwardiya neg bentayan ilan gaid gupiya. ");
INSERT INTO stb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Peketubusen merawat suk sugu' ketu, sineled ilan ne guwardiya ritu sek seled na gupiya nuk perisuwan bu' sinipu su nga geksud nilan. ");
INSERT INTO stb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Sek peketitenga' ne gebii na, migampu' si Pablo bu' si Silas bu' midlekanta se ngak peksaya' ri sed Diwata. Minginengeg ri senilan sud duma ne ngak pinerisu. ");
INSERT INTO stb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mbuus sek tikmal midlinug neng mesekeg gupiya bu' mikedyug suk perisuwan mirepet tampan tu sek pi'indegan ne ngak pasek. Mipuka rayun su ngak sira ne ngak perisuwan bu' midlekat su nga kadina se dlaun ne ngak perisu. ");
INSERT INTO stb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mitanud su guwardiya. Bu' sek pekita'en dun neng mipuka na su ngak sira nek perisuwan, se gena'ena'en mibeluy na su ngak perisu. Aas binadduten su kalisen bu' liyagaan siya nek petain su gegulingenen. ");
INSERT INTO stb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ma'ad migbeksay seng mesekeg si Pablo, “Ndi'a eget! Keni ami ra gela'!” ");
INSERT INTO stb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mikpe'angay nek sulu' su guwardiya bu' minikad giin sumeled ritu bu' middempug neng mikpengereg ri seng metungenga'an nilan ni Pablo bu' ni Silas. ");
INSERT INTO stb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Mbuus inuwiten ilan ni Pablo tu se gawas bu' sinaakan, “Sir, lamaig baalen'u arun meluwas?” ");
INSERT INTO stb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Miksembag ilan ni Pablo, “Pektu'ua riin ni Jesus ne Ginu'u bu' meluwas'a bu' suk pamilya mu.” ");
INSERT INTO stb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mbuus winali nilan ni Pablo suk talu' ne Ginu'u ri seniin bu' se dlaun nek sakup sek pamilyaan. ");
INSERT INTO stb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Se guras ne gebii ketu, inuwit ilan nu guwardiya bu' inugasaan su ngak samad nilan; bu' mikpebendyag rayun giin asta suk tibuuk nek pamilyaan. ");
INSERT INTO stb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Peketubus inuwiten ilan ni Pablo ritu seg balain bu' pinaanen ilan. Su guwardiya bu' suk pamilyaan pidleliyag gaid gupiya neng miktu'u ilan numuun ri sed Diwata. ");
INSERT INTO stb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Sek pekesikanselem, sinugu' nu nga geseg nek taga Roma su ngak pulis, “Beluyan ilan na ni Pablo.” ");
INSERT INTO stb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Bu' pisuun ini ne guwardiya riin ni Pablo, laungen, “Su nga geseg miksugu' neng mekegawas amu na. Aas gawas amu na bu' melengas siyaik pedlaang niyu.” ");
INSERT INTO stb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ma'ad miktalu' si Pablo tu se ngak pulis, “Taga Roma ami, bu' pilekpes ami nilan seng meleget ne getaw ne nda' reli' bistigaray. Rayun piperisu ami nilan. Na, mikegena'ena' ilan pa ba ne edluren ami nilan sek pekpegawas? Ndi' gaid! Kina'enlan ne su nga geseg, gilan mismu sung merini arun gilan sung mekpegawas riin senami.” ");
INSERT INTO stb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Inasuy ne ngak pulis tu se nga geseg seg Roma ngak tinalu' keni; bu' seng mirengeg nilan nek taga Roma ilan ni Pablo bu' ni Silas, minendek ilan. ");
INSERT INTO stb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Aas miritu ilan bu' minengi nek pasaylu ri senilan ni Pablo. Mbuus inunutan nilan rayun sek pegawas bu' inandyu' neng megawa' ilan na tu sek siyudad. ");
INSERT INTO stb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Seng mikegawas na si Pablo bu' si Silas tu sek perisuwan, miritu ilan seg balay ni Lydia. Kinita' nilan su ngang mektetu'u ritu bu' inulikseg ilan nilan arun ligenen suk pektu'u nilan; peketubus, minlaang ilan rayun. ");
INSERT INTO stb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Na, peketubus nilan mayan tu seg Ampipolis bu' seg Apolonia, minateng ilan tu sek Tesalonica, ned ditu, duunik pektiguman ne ngag Judeo. ");
INSERT INTO stb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bu' sumala' ri seng mibetasaan, sinumeled si Pablo tu sek pektiguman nilan. Seled sek telu ne nga Gendaw nek Pengulali, inaddat giin ne nga getaw ritu ginamiten su Kesulatan. ");
INSERT INTO stb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Bu' pisabuten su Kesulatan bu' pimetuuran ri senilan ne sung Misiyas kina'enlan gaid neng megantus bu' metubu' puli' buwat ri se kemetain, laungen, “Jesus keni ne ginasuy'u ri seniyu, giin sung Misiyas.” ");
INSERT INTO stb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Sud duma senilan mi'uwit bu' middunut ilan riin ni Pablo bu' ni Silas. Melaun rema ne ngag rilihiyusu ne nga Griego asta su ngak tinamed ne nga dlibun miktu'u rema. ");
INSERT INTO stb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ma'ad misinaku su ngag Judeo. Aas tinipung nilan su ngang melengka' ne getaw neng migindegindeg ra ri sek tebu'an bu' inetaran nilan semukay suk tibuuk nek siyudad. Sinulung nilan sug balay ni Jason, bu' pinengaw ilan nilan ni Pablo arun pe'atubang ri se nga getaw. ");
INSERT INTO stb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ma'ad nda' nilan me'ita' si Pablo bu' si Silas. Aas binidlas nilan si Jason bu' sud duma pa ne ngang mektetu'u bu' pi'atubang tu se nga geseg sek siyudad bu' mimbeksay ilan, “Nga getaw keni miguwit ne kesamuk isan ta' ilan pagaw. Bu' numuun keni ilan na sek siyudad ta, ");
INSERT INTO stb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","bu' pipenaik ilan pa ni Jason ri seg balain. Dlaun nilan keni sinumupak ri se nga kesugu'an ne Gari' seg Roma, tendeng ay miktalu' ilan ned duun pai dlain ne gari' ne giningelanan neg Jesus.” ");
INSERT INTO stb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Sek pekerengeg nilan run nini, migubet su nga getaw bu' sung midlegeseg ri sek siyudad. ");
INSERT INTO stb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bu' pipiyansa reli' nilan si Jason bu' su ngak sementaunen, bu' bineluyan ilan rayun. ");
INSERT INTO stb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Sek pekegebii, pilaang nu ngang mektetu'u si Pablo bu' si Silas ritu seg Berea. Peddateng nilan ritu, miritu ilan sek pektiguman nu nga getaw Judeo. ");
INSERT INTO stb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Andam kampuun su nga getaw ritu seg Berea sek peddawat seng minsahi ni Pablo sinangkali' se nga getaw ritu sek Tesalonica. Pidleliyag ilan gupiya sek pekpenginengeg ri se ngak pimandu' nilan ni Pablo. Bu' kada gendaw, tinu'unan nilan gupiya su Kesulatan arun mpelengpeleng nilan bu' metuud ba gaid suk tinalu' nilan ni Pablo. ");
INSERT INTO stb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Melaun senilan sung miktu'u, asta na su ngak tinamed ne nga dlibun ne nga Griego bu' duun rema ne nga dlai sung miktu'u. ");
INSERT INTO stb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ma'ad seng misuunan ne ngag Judeo sek Tesalonica ne si Pablo migwali rema sek talu' ned Diwata ritu seg Berea, miritu ilan bu' inulug'ulugan nilan su nga getaw neng megbaal ne kesamuk. ");
INSERT INTO stb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bu' piperitu rayun ne ngang mektetu'u si Pablo seg baaybaay. Ma'ad mikpebilin ditu seg Berea gilan ni Silas bu' ni Timoteo. ");
INSERT INTO stb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Su nga getaw middelung riin ni Pablo middunut ri seniin tampan seg Athens. Mbuus mipuli' ilan seg Berea ned duunik pemuun buwat riin ni Pablo ne si Silas bu' si Timoteo meddendug rayun ri seniin tu seg Athens. ");
INSERT INTO stb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Saanay migelat si Pablo riin ni Silas bu' ni Timoteo ritu seg Athens, linengetan gupiya giin seng mi'ita'en ne suk siyudad milaup ne nga dlerawan. ");
INSERT INTO stb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Aas migaddat giin ri senilan tu sek pektiguman duma se nga getaw Judeo bu' su ngag rilihiyusu ne nga getaw; bu' kada gendaw ritu sek tebu'an, inaddaten su nga getaw neng minditu. ");
INSERT INTO stb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bu' duunik santa' tawan ne ngang menintulu' neng miksunud buwat se ngak penendu'an se ngag Epikuru bu' ngag Estoik neng minaddat ri ni Pablo. Sud duma miksaak, “Landun maik pinghambug?” Miktalu' sud duma, “Maa' dlain ma ne ngad diwata suk tinuntulen.” Giin nini suk tinalu' nilan tendeng ay winali ni Pablo sung metendeng riin ni Jesus bu' sek peketubu' puli'. ");
INSERT INTO stb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Aas inuwit nilan si Pablo se kunsihu sek siyudad ne iningelanan neg Areopagus. Miktalu' ilan ri seniin, “Liyagan nami mesuunan sug begu nek pektu'unan nek tinuntul mu. ");
INSERT INTO stb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ay duuni dlain ne ngag betang nek pimandu' mu neg begu ri senami. Aas liyagan nami neng mesuunan bu' landun ma su nga gulugaan itu.” ( ");
INSERT INTO stb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Giin nini suk tinalu' nilan tendeng ay su ngak taga Athens bu' sud duma nek taga dlain ne dlugar ne ritu na mikengel liyagan nilan kanunay mektuntultuntul awas menginengeg metendeng ri seg begu ne ngak sinuunan.) ");
INSERT INTO stb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Aas migindeg si Pablo ri seng metungenga'an ne kunsihu sek siyudad bu' miktalu', “Nga getaw Athens, mi'ita'u neg rilihiyusu amu gupiya se dlaun ne ngag betang. ");
INSERT INTO stb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Saanay sek pedlibed'u rini sek siyudad niyu, mi'ita'u su nga dlugar nek piksimbaan niyu bu' mi'ita'u rema suk pengilakan ned duuning misulat run, ‘Para sed Diwata ne genda' pa me'ilala.’ Suk sinimba niyu ketu, isan nda' pa niyu me'ilala, giini asuy'u nemuun riin seniyu. ");
INSERT INTO stb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Sud Diwata neng migbaal ri seg benwa bu' se dlaun ned dini, giin su Ginu'u se dlangit bu' se dlupa' bu' nda' pekengel riin se ngak templo neg binaal ne nga getaw. ");
INSERT INTO stb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nda' rema giin pedlekina'enlan isan landun buwat ri se getaw tendeng ay giin sung mekegbegay ne ketubu', pedleginawa, bu' se dlaun ne ngag betang para se nga getaw. ");
INSERT INTO stb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Buwat ri sek sala ne getaw, binaalen su dlaun ne gesalan se nga getaw bu' mikengel ilan ri sek tibuuk neg benwa. Inimetangen na nud diin su ngak panahun bu' su ngad dulunan se nga dlugar nek pikengelan nilan. ");
INSERT INTO stb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Binaalen itu arun su nga getaw menengaw ri seniin neng menegumalad neng me'ita' bu' mekiikap ri seniin. Tumu' sud Diwata gena' melayu' ri se kada sala senita; ");
INSERT INTO stb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","maa' sek tinalu' ned duma, ‘Ri seniin, duuni ketubu' ta, bu' mikekuleg ita, bu' duuni ginawa ta.’ “Maa' sek tinalu' sek santa' seniyu ne ngang membebaat, ‘Gita ngag bata'en rema.’ ");
INSERT INTO stb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Aas, tendeng ay gita ngag bata' ned Diwata, ndi' ita megena'ena' ne suk pekedDiwata maa' gawi' se nga dlerawan neg bulawan awas pelata awas batu neg binaal sek tinawan bu' gena'ena' ne getaw. ");
INSERT INTO stb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nda' na ebetay ned Diwata su ngak panahun ne su nga getaw nda' mekiilala ri seniin, ma'ad nemuun, sinugu'en su dlaun ne nga getaw sek pekpeddiksu'. ");
INSERT INTO stb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ay miktagal giin ne gendaw ne ukumaan su dlaun ne nga getaw rini seg benwa duma se gustisya pebiyan ri se getaw nek pinili'en. Pimetuuraan nini se dlaunan nek pebiyan sek pekpetubu'en puli' ri se getaw keni buwat ri se kemetain.” ");
INSERT INTO stb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Sek pekerengeg nilan ne si Pablo migasuy metendeng sek pekpetubu' puli', sud duma middega'rega' ri seniin. Ma'ad sud duma miktalu', “Puli'a rini ay liyagan nami menginengeg pa gaid ri seni'a metendeng se ngag betang keni.” ");
INSERT INTO stb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Bu' aas migawa' si Pablo ritu sek pektiguman nilan. ");
INSERT INTO stb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Sud duma ne nga getaw linumamig ri seniin bu' miktu'u. Sala senilan giin si Dionisio nek sakup se kunsihu; bu' duuni dlibun rema ne giningelanan ne si Damaris, bu' duun pa gaid duma. ");
INSERT INTO stb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Dluwat ini, migawa' si Pablo seg Athens bu' miritu se Corinto. ");
INSERT INTO stb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ritu mipekita'en si Akila neg Judeo nek taga Pontus, neng migbuwat seg Italy duma suk sawaan ne si Priscila tendeng ay sinugu' ne Gari' ne si Claudio, ne su dlaun ne ngag Judeo kina'enlan megawa' seg Roma. Binentaw ilan ni Pablo, ");
INSERT INTO stb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","bu' tendeng ay meksama suk terbahu nilan neng membebaalay nek tulda, ritu giin mikpenaikan senilan bu' midduma senilan sek pekterbahu. ");
INSERT INTO stb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kada Gendaw nek Pengulali mikepengaddat si Pablo ri sek pektiguman arun merunggatan su ngag Judeo bu' su nga Griego. ");
INSERT INTO stb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Na, sek peddateng ni Silas bu' ni Timoteo buwat seng Macedonia, ginamit ni Pablo suk tibuuk panahun sek pegwali seng minsahi. Pimetuuraan se ngag Judeo ne si Jesus giin gaid sung Misiyas. ");
INSERT INTO stb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ma'ad sek sinupak nilan si Pablo bu' mimentalu' neng melaat metendeng ri seniin, inekpagen su dlubek ri sek suuben gisip penegul ri senilan bu' miktalu', “Bu' ndi' amu mekpetuud, nda' nai dlabet'u riin seniyu. Gatad nandaw, merituu na se nga gena' Judeo.” ");
INSERT INTO stb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Aas binelengen ilan bu' ritu giin mikpenaikan seg balay ni Titius Justus ne gena' Judeo, rilihiyusu giin neng miksimba ri sed Diwata; bu' sug balain riin se dlantad ra nek pektiguman. ");
INSERT INTO stb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Si Crispus ne giini geseg sek pektiguman nu nga getaw Judeo miktu'u rema riin se Ginu'u duma suk tibuuk nek pamilyaan; bu' melaun pa gaid ne ngak taga Corinto neng mikerengeg seng minsahi, miktu'u, bu' mikpebendyag. ");
INSERT INTO stb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Na, sala gebii itu, pebiyan ri sek pegita'en, su Ginu'u miktalu' riin ni Pablo, “Ndi'a mendek, ma'ad peddayun'a sek pegwali bu' ndi'a penuga', ");
INSERT INTO stb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","tendeng ay sementaun mau. Nda'iruning mekepegeel ri seni'a, tendeng ay duuning melaun ne ngang mektetu'u sek siyudad keni.” ");
INSERT INTO stb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Aas seled sek setaun bu' tenga', mikengel si Pablo ritu bu' pimandu'en se nga getaw suk talu' ned Diwata. ");
INSERT INTO stb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Na, sek panahun ne si Galio nai gobernador seg Acaya, miktipung su ngag Judeo bu' dinaap nilan si Pablo, bu' inuwit ritu se gukuman. ");
INSERT INTO stb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Mik