﻿USE sofia;
DROP TABLE IF EXISTS sofia.ssx_vpl;
CREATE TABLE ssx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ssx_vpl WRITE;
INSERT INTO ssx_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","2","Titi panake pa꞉ta꞉ Koda꞉ma꞉ kenke ya yaapo wepieke dina꞉ do kenketa꞉ homeke hau honda꞉ lupa pua aleta꞉ ma꞉nda꞉ ota꞉ na wiekeme. Kutupa mo dawalata꞉ timba꞉ kiti la꞉pa peeke alena꞉ Koda꞉na꞉ Sipitidita꞉ manda hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kutupa Koda꞉ma꞉ alota꞉ Pa̱a̱ pa꞉la꞉eki wina꞉e leeke handaata꞉ pa̱a̱ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Koda꞉ma꞉ kutu piekeeki handolo hata꞉ ta꞉na꞉ma꞉ homolo mo timba꞉ ala꞉eki pita꞉ pa̱a̱ pa꞉la꞉eki yaapo putupaalu pina꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ipikana꞉ma꞉ mo pa̱a̱ pa꞉la꞉ ekina꞉ bikita꞉ Natee laata꞉ timba꞉ ala꞉ ekina꞉ bikita꞉ Timbae leekeme. Kota꞉ timba꞉ laa da kelepeeketa꞉ titina꞉ nate yeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Kutupa Koda꞉ma꞉ alota꞉ Mo ikalita꞉ putupaalu pina꞉ yeke dopu miaasa꞉ ekima꞉ handeke ale wina꞉e leeke handaata꞉ kutu piekeme. Koda꞉ma꞉ do wieke alema꞉ta꞉ mo ikalita꞉ putupa꞉alu pea manda make oto nane make wina꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Koda꞉ma꞉ koto dopu miaasa꞉ ekima꞉ handeke alena꞉ bikita꞉ Yae leekeme. Kota꞉ timba꞉ laa da kelepeeketa꞉ yaapo peao nate yeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kutupa Koda꞉ma꞉ alota꞉ mo ya oto nane ula꞉ ikali pa꞉ta꞉ yu peneme yao opa꞉liao wina꞉ yeke mo ikalita꞉ homeke alena꞉ mombelena꞉e laa leeke handaata꞉ kutu piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kutupa mo yuna꞉ bikita꞉ Kenkee laa mo homeke alena꞉ mombeleeke ikalina꞉ bikita꞉ Dawalae leekeme. Koto ekina꞉ moeki hando haota꞉ Koda꞉ma꞉ ta꞉na꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kutupa Koda꞉ma꞉ alota꞉ Do kenkema꞉ta꞉ mo kenkena꞉ opa꞉la꞉ ta꞉ta꞉ ta꞉ta꞉ piki ti potekemanu make kiliki a꞉eta꞉la꞉ alemanu make opaena꞉e laa leeke handaata꞉ kutu piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kenkema꞉ kutu piekeeki hando haota꞉ Koda꞉ma꞉ ta꞉na꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Timba꞉ laa da kelepeeketa꞉ tepo peao nate yeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kutupa Koda꞉ma꞉ alota꞉ Mo nate pita꞉ timba꞉ ala꞉eki yaapo putupa꞉alu pina꞉ yeke oli ya nane pa̱a̱ pa꞉la꞉ ekimanu wina꞉e laata꞉ koto pa̱a̱ pa꞉la꞉eki manuma꞉ta꞉ mo natemanu make bapimanu make ne pamba꞉la꞉eki manuna꞉ dimanu kini peaena꞉ yeke wina꞉e laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ikana꞉ma꞉ta꞉ mo kenke pa̱a̱ pealuekema꞉ oli ya nanema꞉ hata꞉ pa̱a̱ pilieke laa leeke handaa kutu piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Koto ekina꞉ Koda꞉ma꞉ta꞉ pa̱a̱ tieke yaapo wepiekeme. Mo natema꞉ta꞉ natepa handeteke haena꞉ make mo kaisepoma꞉ta꞉ timba handeteke haena꞉ piekeme. Kutupa hombulanka꞉manu make wepiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ipikana꞉ma꞉ta꞉ mo pa̱a̱ pa꞉la꞉eki manuma꞉ta꞉ mo kenkena꞉ pa̱a̱ peaena꞉ yeke oli ya nane haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ikana꞉ma꞉ta꞉ mo natepa pita꞉ timba yaapo handeteke haena꞉ make pa̱a̱ pa꞉la꞉eki pita꞉ timba꞉ ala꞉eki yaapo putupa꞉alu pina꞉ yeke piekeme. Kutupa Koda꞉ma꞉ kotoeki hando haota꞉ ta꞉na꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Timba꞉ laa da kelepeeketa꞉ tonko peao nate yeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kutupa Koda꞉ma꞉ alota꞉ Mo ikali pa꞉ta꞉ta꞉ ta꞉ta꞉ ta꞉ta꞉ pa pitiki ale manuma꞉ tumbina꞉e laata꞉ yana꞉ta꞉ ba titima꞉ tumbina꞉e laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Koto ekina꞉ Koda꞉ma꞉ta꞉ mo dawalana꞉ pila꞉ si tieke hombelekemanu make oni ikali pa꞉ta꞉ pila꞉ ta꞉ta꞉ ta꞉ta꞉ piki pa pitiki alemanu make ta꞉ta꞉ ta꞉ta꞉ piki bamanu make wepiekeme. Koto ekina꞉ Koda꞉ma꞉ mo alemanu hando haota꞉ ta꞉na꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ipikana꞉ma꞉ta꞉ ta꞉na꞉ma꞉ homa꞉ tiaasa꞉ pima꞉ mo ikali pa꞉ta꞉ pilimi pa pitiki alemanu pa꞉ta꞉ alota꞉ Mo dawala pa꞉ta꞉ sembelomena꞉ pa mendiolo ombu hapa꞉peke laata꞉ mo bamanu pa꞉ta꞉ make alota꞉ Wopu yomena꞉ pa mendiolo ombu hapa꞉peke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Timba꞉ laa da kelepeeketa꞉ yunki peao nate yeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kutupa Koda꞉ma꞉ alota꞉ Mo kenke pa꞉ta꞉ yama꞉ta꞉ ta꞉ta꞉ ta꞉ta꞉ piki pona꞉la꞉ hotekemanu make tikene hala꞉ hotekemanu make tieke make hosikale sunu make haena꞉e laa leeke handaa kutu piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Koto ekina꞉ta꞉ Koda꞉ma꞉ koto alemanu paeyao wepiaka꞉na꞉ mo alemanu hando haota꞉ ta꞉na꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kutupa Koda꞉ma꞉ alota꞉ Kota꞉ ameta꞉ wanda꞉halimanu wepumana꞉e laa leekeme. Ikita꞉ nikima꞉ handaa nika꞉ hau hondena꞉e laa leekeme. Ikana꞉ma꞉ta꞉ mo ta꞉pelimanu make bamanu make pona꞉la꞉ hotekemanu make tikene hala꞉ hotekemanu make tieke make hosikale sunu make paeya tapaota꞉ kilu tombuao haena꞉e laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Koto ekina꞉ta꞉ Koda꞉ma꞉ wanda꞉hali ipikima꞉ kone handena꞉ wepiekeme. Ipikana꞉ma꞉ta꞉ hali tapake pita꞉ wanda꞉ tapake yaapo wepiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ipikana꞉ma꞉ ipiliki ta꞉na꞉ma꞉ homa꞉ tiaasa꞉ pima꞉ alota꞉ Ipilika꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ do kenke honiki paeyao pa꞉ta꞉ hata꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao kilu tombuao haena꞉ yeke wekiwandiki wopu mendia꞉pa꞉peke laa leekeme. I̱ma꞉ ipilikita꞉ mo ta꞉pelimanu make bamanu make tikene hala꞉ hotekemanu make handeteke hapena꞉ yeke alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kutupa ipilikana꞉ma꞉ nopena꞉ yeketa꞉ mo ta꞉ta꞉ ta꞉ta꞉ piki konima꞉ handeke kilikimanu make ta꞉ta꞉ ta꞉ta꞉ piki ti potekemanu make amu pea wepia wina꞉ lolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Pate mo tikene hala꞉ hoteke manuma꞉ make ba manuma꞉ make nena꞉ta꞉ mo ambumanu make katake hake timanu wepia wina꞉ laalome leeke handaata꞉ kutu piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kutupa Koda꞉ma꞉ mo ipika꞉ wepia wina꞉ leeke ala꞉ta꞉ ala꞉ta꞉ paeyao handolo hata꞉ta꞉ ta꞉na꞉ tiekema꞉ wopu homeekeme. Kota꞉ timba꞉ laa da kelepeeketa꞉ yunki mindiki peao nate yeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kutupa kota꞉ mo kenke nane ula꞉ alemanu make oli ya nane hala꞉ alemanu make paeyao wepu paeyaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Koda꞉ma꞉ mo ipika꞉ poka꞉tia epeeke eta꞉ poko paeyao mo wataake natena꞉ta꞉ e na pokeke hoto pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Koto ekina꞉ ipikana꞉ma꞉ mo wataake peao nateta꞉ ta꞉na꞉ma꞉ homa꞉ tiaasa꞉ pima꞉ Ta꞉ta꞉ ma꞉nda꞉ piki natee laa tombo wina꞉ leekeme. Pa ekipeke koto natena꞉ta꞉ mo ala꞉ta꞉ ala꞉ta꞉ paeyao weputia a꞉pa e poka꞉la꞉eki mina꞉pa꞉laeyeke natee. ");
INSERT INTO ssx_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Mo kenke ya yaapo make mo ala꞉ta꞉ ala꞉ta꞉ paeyao wepieke tupa꞉ta꞉ kotoe. ");
INSERT INTO ssx_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Tekehali Koda꞉ma꞉ mo kenke ya yaapo wepia dina꞉ta꞉ do kenkena꞉ lako na tapaeyekeeki yalo make yu lu wia꞉peke wanda꞉hali ma꞉nda꞉ dia꞉yeke ekima꞉ do kenkema꞉ta꞉ wae alemanu ma꞉nda꞉ na hao make kilikimanu ma꞉nda꞉ na opeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Pate mo kenke oto nane wieke ikalima꞉ta꞉ opa꞉liao mo kenke tenke latiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kutupa mo Tekehali Koda꞉ma꞉ta꞉ kenkena꞉ dokolo mea hali au laa wepiata꞉ ipika꞉ mineke pa꞉ta꞉ta꞉ mo da꞉ta꞉la꞉eki hala꞉la꞉ pomo po lo pambeeke handaata꞉ mo halita꞉ tiao da꞉taa hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kutupa mo Tekehali Koda꞉ma꞉ta꞉ mo nate opa꞉la꞉ nane wieke Ideni kenke pa꞉ta꞉ e pokaata꞉ mo hande wepieke hali koto e pa꞉ta꞉ haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Koda꞉ma꞉ koto e pa꞉ta꞉ta꞉ mo ta꞉ta꞉ ta꞉ta꞉ piki epeke au leke timanu opaota꞉ epeke ti potekemanu eiyaeyekeme. Koto e tukikina꞉ta꞉ mo da꞉ta꞉la꞉eki kita꞉la꞉ ti make mo epeke hau pita꞉la꞉eki pita꞉ hoke hau pita꞉la꞉eki yaapona꞉ hone u tiaasa꞉ ti make hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Mo Ideni e pa꞉ta꞉ta꞉ yopulu hala꞉ ikali ma꞉nda꞉ma꞉ mo e ikali halo hayekeme. Mo ikalita꞉ Ideni mo pate leketa꞉ ata꞉ka꞉ tonkopu piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mo titina꞉ ikalita꞉ Pisoni ikalie. Ipikita꞉ mo Ha꞉pila kenke popei yao yapeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Mo ala꞉ta꞉ ma꞉nda꞉ na ta̱leke kolo make totopo piki weta꞉ make seliapo piki toopimanu make koto pa꞉ta꞉ handa꞉peke ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Mo yaapo peao ikalita꞉ Kioni ikalie. Ipikita꞉ mo Kusu kenke popei yao yapeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Mo tepo peao ikalita꞉ Taikitisi ikalie. Ipikita꞉ mo A꞉sitia kenkena꞉ nate opa꞉la꞉ nanema꞉ yapeekeme. Kutupa mo tonko peao ikalita꞉ Yupoteitisi ikalie. ");
INSERT INTO ssx_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Kutupa Tekehali Koda꞉ma꞉ mo hande halita꞉ Ideni e pa꞉ta꞉ yu lia handeteke haena꞉yeke hawayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Koda꞉ma꞉ ipiki pa꞉ta꞉ alota꞉ Mo ena꞉ hala꞉ ti poteke paeyaota꞉ napeke ya꞉la꞉pateta꞉ ");
INSERT INTO ssx_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","mo epeke hau pita꞉ hoke hau pita꞉la꞉eki yaapona꞉ hone u tiaasa꞉ ti poteke homeke homeke dia꞉me. Mo koto tina꞉ poteketa꞉ ota꞉ na napeke laata꞉ Neka꞉na꞉ta꞉ kota꞉ mo nelipi natena꞉ kone homilipikie laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kutupa mo Tekehali Koda꞉ma꞉ alota꞉ Mo hali ipika꞉ siki hata꞉ta꞉ hoela꞉me. I̱ma꞉ta꞉ ipiki tamba꞉ mina꞉ ota꞉ epeke ta꞉ma꞉ni ma꞉nda꞉ wepulueke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Koto ekina꞉ta꞉ Koda꞉ma꞉ mandane dokolomanu mea hoteke paeyao make ba paeyao make wepiekeme. Kutupa ipikana꞉ma꞉ mo alemanu mo halima꞉ handaa biki loma꞉ loma꞉ pina꞉ yeke hatuku epeekeme. Kotota꞉ ika꞉ hande biki mimiki tupa꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Koto ekina꞉ mo halima꞉ta꞉ mo bamanu paeyao make hotekemanu paeyao make biki hale hale piekeme. Pate koto ale manuta꞉ ota꞉ ma꞉nda꞉ hondo ipiki tamba꞉ mea꞉peke ta꞉ma꞉ni ma꞉nda꞉ na hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Koto ekina꞉ mo Tekehali Koda꞉ma꞉ta꞉ mo hali u̱ yoka꞉lupa pena꞉ leekeme. Kutupa u pelia haena꞉ta꞉ Koda꞉ma꞉ mo halina꞉ pa꞉ta꞉liki homeke ma꞉nda꞉ ipila꞉ mea mo loke a꞉mbaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Koda꞉ma꞉ta꞉ koto pa꞉ta꞉likima꞉ta꞉ wanda꞉ wepia mo hali pa꞉ta꞉ hatuku epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kutu pieke mo halima꞉ alota꞉ Ameta꞉ wetepe siki nane I̱ma꞉ handeke yankeke ma꞉nda꞉ doe. Ipika꞉ holikita꞉ yaka holiki pa꞉ta꞉ yama꞉ kone mea ipika꞉ loketa꞉ yaka loke pa꞉ta꞉ yama꞉ kone ma꞉la꞉me. Ipikita꞉ mo hali pa꞉ta꞉ yama꞉ kone miekeeki yalo hata꞉ta꞉ ipika꞉ bikita꞉ wanda꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Koto ekina꞉ta꞉ halima꞉ ipika꞉ apa꞉ ama꞉ mina꞉pa꞉lao ipika꞉ wanda꞉ yaapo ta꞉ma꞉ni peaata꞉ ipilikita꞉ homeke kone halepeme. ");
INSERT INTO ssx_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mo hali pita꞉ wanda꞉ yaapota꞉ pa tia haepekepate kone ipilikita꞉ yaala꞉ma꞉ na homepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mo Koda꞉ma꞉ wepieke hotekemanu paeyao tukiki pa꞉ta꞉ keto homeketa꞉ ota꞉ hone wopu u lenkene piki hoteke wepiekeme. Koto ketoma꞉ mo wanda꞉ lota꞉ pitolo alota꞉ Koda꞉ma꞉ ipiliki pa꞉ta꞉ta꞉ do e pa꞉ta꞉ hala꞉ ti ma꞉nda꞉na꞉ poteke na napa꞉peke laa ota꞉ lea꞉pe laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mo wanda꞉ma꞉ hombo peaaso alota꞉ Dikana꞉ma꞉ta꞉ do e pa꞉ta꞉ hala꞉ ti poteke paeyao nolo polopa꞉pateta꞉ ");
INSERT INTO ssx_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","mo e tukikina꞉ hala꞉eki homeke homeke dia꞉me laata꞉ Koda꞉ma꞉ diki pa꞉ta꞉ alota꞉ Koto ti poteke homeke ota꞉ na napa꞉peke make ota꞉ na wataapa꞉peke. Kutu pipika꞉na꞉ta꞉ homilipipikie laa lea꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mo ketoma꞉ pi lu moneaaso alota꞉ Kotota꞉ ota꞉ pi dia꞉me. Ipiliki na homilipipikie. ");
INSERT INTO ssx_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Koda꞉ma꞉ koto leke hauta꞉ ipilikana꞉ma꞉ koto ti poteke nepekena꞉ta꞉ ipikima꞉ kone handaa mo epeke hau pita꞉ hoke hau pita꞉la꞉ ekina꞉ hone u tiaasa꞉ ekita꞉ hone wilipipiki yeke handa lea꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mo wanda꞉ma꞉ mo ti handeeketa꞉ au epeke laa mo ti poteke nalota꞉ ota꞉ a꞉pa꞉la꞉me laa handeekeme. Kutupa ipika꞉ honema꞉ ipikita꞉ hone wopu u lenkene pitolota꞉ ota꞉ a꞉pa꞉la꞉me hone wiekeme. Koto ekina꞉ta꞉ ipikana꞉ma꞉ mo mandane ti potekemanu mea neekeme. Kutupa ipikana꞉ma꞉ mandane ekita꞉ ipika꞉ haliki haleeketa꞉ halikima꞉ make neekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ipilikana꞉ma꞉ mo ti poteke nepe ale pa꞉ta꞉ koneta꞉ hone u tiaasa꞉eki halaa ipilikita꞉ pa tia hata꞉ pupa꞉ka꞉ta꞉me hone wipikime. Koto ekina꞉ta꞉ ipilikana꞉ma꞉ nose katake tombula ipiliki loke a꞉mbaepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Koto nate pambolo haena꞉ta꞉ mo Tekehali Koda꞉ta꞉ e pa꞉ta꞉ pomia꞉eki opitolo hata꞉ ipiki a꞉mbao oni ti polu pa꞉ta꞉manu panko pitipikime. ");
INSERT INTO ssx_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Pate Tekehali Koda꞉ma꞉ mo hali pa꞉ta꞉ wi la꞉moneaaso alota꞉ Neketa꞉ hando pa꞉ta꞉ halepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Mo halima꞉ hombo peaaso alota꞉ I̱ma꞉ neke oni e pa꞉ta꞉ pomieki opu hao I̱ pa tia haowa꞉ ekima꞉ paala꞉ pieke neke a꞉mbao panko pilume leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Koto leeke Koda꞉ma꞉ alota꞉ Neketa꞉ pa tia haleme laata꞉ Epima꞉ la kia꞉pe. Nakana꞉ma꞉ta꞉ mo I̱ma꞉ na napeke loa꞉ ti poteketa꞉ nepee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mo halima꞉ hombo peaaso alota꞉ Do hande I̱ yaapo hapono lele wanda꞉ma꞉ mo ti poteke mea kieke handa noa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mo Tekehali Koda꞉ma꞉ mo wanda꞉ pa꞉ta꞉ alota꞉ Do ekita꞉ ekipeke pea pelepe leekeme. Mo wanda꞉ma꞉ hombo peaaso alota꞉ I̱ma꞉ nono yeke handa mo ketoma꞉ I̱ makeaya꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kutupa mo Tekehali Koda꞉ma꞉ mo keto pa꞉ta꞉ alota꞉ Do hau pele ekina꞉ hoke yenki kitolome. Mo hoteke manuma꞉ dia꞉ya꞉la꞉pate pa neke homeke homekema꞉ta꞉ dupiki esihou pi mie. Neketa꞉ ame do kini pea puluta꞉ naka꞉ weleketa꞉ yola꞉ tia pominolo hata꞉ neke pa ha pelia haeka꞉na꞉ta꞉ kota꞉ dokolo no halipikie. ");
INSERT INTO ssx_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kutupa I̱ma꞉ neketa꞉ mo wanda꞉ yaapo a꞉nda꞉ tunkula꞉ alu peao ipika꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikima꞉ make naka꞉ ekima꞉ make a꞉nda꞉ tunkula꞉ alu alu pu haena꞉ lolueke. Ipikana꞉ma꞉ naka꞉ you da꞉ka꞉pa꞉ tombuaeya꞉ka꞉na꞉ta꞉ nakana꞉ma꞉ ipika꞉ anke kinuku handulu nelipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kutupa Koda꞉ma꞉ mo wanda꞉ pa꞉ta꞉ alota꞉ I̱ma꞉ neketa꞉ naka꞉ weki loke lombilipi ale pa꞉ta꞉ta꞉ ka꞉nda꞉ pa꞉la꞉eki haka꞉ta꞉peao make weki milipi ale pa꞉ta꞉ta꞉ tanda pa꞉la꞉eki make haka꞉ta꞉palueke. Dupina꞉ kone nakana꞉ma꞉ta꞉ naka꞉ haliki hone wopu wia ipiki oto pa꞉ta꞉ halipikie. ");
INSERT INTO ssx_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kutupa Koda꞉ma꞉ A꞉da꞉ma꞉ pa꞉ta꞉ alota꞉ Nakana꞉ma꞉ta꞉ naka꞉ wanda꞉na꞉ pi opua mo I̱ma꞉ na napeke loa꞉ ti poteke neleme. Koto hau pele ekina꞉ do kenketa꞉ mo esihou pi oto pa꞉ta꞉ wilieke. Kutupa nakana꞉ma꞉ta꞉ do kenkena꞉ pa hapa꞉lia haeka꞉na꞉ta꞉ mo kenkema꞉ naka꞉ ne ana꞉na꞉ opaena꞉ e honkopu hao poko halipikie. ");
INSERT INTO ssx_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Mo kenkena꞉ta꞉ ambumanu make tekeke hake alemanu make opa꞉tiki pilieke. Kutupa nakana꞉ma꞉ta꞉ mo hapekena꞉ hala꞉ wae alemanu no halipikie. ");
INSERT INTO ssx_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kutupa mo kenkema꞉ anemone ale opena꞉ yeketa꞉ a꞉ka꞉li mendia honkopu hao e poka꞉tiki pilipikie. Dupiki hau putia pua mo neke wa꞉pa꞉la꞉ kenke pa꞉ta꞉ pulu hata꞉ta꞉ mina꞉pa꞉lalipikie. Neketa꞉ dokoloma꞉ wepiekeeki yalo hata꞉ dokolo au kone lelipikie. ");
INSERT INTO ssx_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","A꞉da꞉ma꞉ma꞉ ipika꞉ wanda꞉na꞉ bikita꞉ Ipa꞉ leekeme. Pa ekipeke ipikita꞉ wanda꞉hali paeyaona꞉ inkikie. ");
INSERT INTO ssx_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kutupa mo Tekehali Koda꞉ma꞉ hoteke manuna꞉ yonkeleke mea aka꞉ wepiaoka꞉na꞉ mo toolina꞉ yamaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kutupa mo Tekehali Koda꞉ma꞉ alota꞉ Ameta꞉ mo halita꞉ niki ma꞉nda꞉ hondoma꞉ handaata꞉ mo epeke hau pita꞉ hoke hau pita꞉la꞉eki yaapo hone ula꞉me. Koto ekina꞉ ipikana꞉ma꞉ta꞉ pa hatia puaama꞉na꞉ mo deto hala꞉ tina꞉ poteke naama꞉na꞉ waleke na halomana꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Koto ekina꞉ta꞉ mo Tekehali Koda꞉ma꞉ta꞉ mo halita꞉ Ideni e pa꞉ta꞉ tolu lia ipiki wepia꞉ kenke kone yu lina꞉ haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kutupa Koda꞉ma꞉ mo ena꞉ nate opa꞉la꞉ naneta꞉ mandane honkopu hake enisolomanu haena꞉ laa make kutupa ti talo talo hake bainasi homeke mandane mandane lekeleke alo hakeeki haena꞉ leekeme. Do hau piki hauta꞉ mo deto hala꞉ ti teke pa꞉ta꞉ ma꞉nda꞉ a꞉paama꞉na꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Kutupa A꞉da꞉ma꞉ma꞉ ipika꞉ weteke yaapo loke apa꞉tao mo wanda꞉ta꞉ weki loke lombeekeme. Ipikana꞉ma꞉ weki mendia alota꞉ Mo Tekehalima꞉ tamba꞉ mina꞉la꞉ ekima꞉ do weki mondoloma꞉ laa mo wekina꞉ bikita꞉ Keinie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Pa hoki naneta꞉ weki ma꞉nda꞉ Eipolo mondu wiekeme. Eipolota꞉ sipisipi handeteke hayekepate Keinita꞉ e hali hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Nate ma꞉nda꞉na꞉ta꞉ Keini ipika꞉ mandane ne napeke mea a꞉pa Tekehali pa꞉ta꞉ pa hameke haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Kutupa Eipoloma꞉ ipika꞉ sipisipima꞉ titina꞉ mendieke ikikita꞉ lia mo epeke mindiki manuta꞉ Koda꞉ pa꞉ta꞉ pa hameke haleekeme. Mo Tekehalima꞉ta꞉ Eipoloma꞉ pa hameke haleeke ekina꞉ make ipiki yaapo ta꞉na꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kutu piekepate Keinina꞉ pa hameke haleeke ekita꞉ kiayekeme. Koto ekina꞉ Keinita꞉ wenoko homa꞉niao mineke wopu pankeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kutu pieke mo Tekehali Koda꞉ma꞉ Keini lota꞉ pitolo alota꞉ Neketa꞉ ekipeke mineke pankelepe laa Naka꞉ leke popeleketa꞉ ekipeke homa꞉nialepe. ");
INSERT INTO ssx_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nakana꞉ma꞉ ota꞉ hau pika꞉na꞉ yoluta꞉ naka꞉ leke popeleke kipa baalo pia꞉pate nakana꞉ma꞉ hoke hau pele ekima꞉ta꞉ hoke ekima꞉ta꞉ naka꞉ pota꞉ kake pa꞉ta꞉ yu pamba hala꞉me. Ipikana꞉ma꞉ neke dipula muluekema꞉ pita꞉la꞉pate nakana꞉ma꞉ta꞉ ota꞉ bepolapeke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kutupa Keinima꞉ ipika꞉ kame Eipolo pa꞉ta꞉ alota꞉ Oni e pa꞉ta꞉ pana꞉ epoe leekeme. Kutupa mo hama̱la̱꞉ oni ena꞉ pua haepe dina꞉ta꞉ Keinima꞉ la꞉ka꞉la꞉ moneao ipika꞉ hameke siki kone homena꞉ liekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mo Tekehalima꞉ Keini lota꞉ pitolo alota꞉ Naka꞉ kame Eipolota꞉ hando pa꞉ta꞉ hala꞉pe leekeme. Koto leeke Keinima꞉ hombo peaaso alota꞉ I̱ mata꞉la꞉me. Yaka kameta꞉ I̱ma꞉ handeteke hapeke ya꞉la꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Koto leeke mo Tekehalima꞉ alota꞉ Ekipeke nakana꞉ma꞉ do hoke hau pea pelepe laata꞉ Mo hoke hauta꞉ Koda꞉ nakana꞉ma꞉ panisi peae laa naka꞉ kamena꞉ wema꞉ta꞉ pi ho̱la̱꞉makema꞉ leke oni kenkena꞉ hata꞉ I̱ wi ala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Neketa꞉ mo esihou pi oto pa꞉ta꞉ haleeki yalota꞉ do kenkena꞉ e ota꞉ pa na pokilipikie laata꞉ Pa ekipeke nakana꞉ma꞉ mo naka꞉ kame lilipi natena꞉ kone mo kenkema꞉ta꞉ ipika꞉ we dodopo lo noluekema꞉ kake ala꞉pelia hake nono pia꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kutupa nakana꞉ma꞉ e waemanu nokepeka꞉na꞉ta꞉ ne napeke ma꞉nda꞉ na halieke. Kutupa neketa꞉ do kenkena꞉ da teke dia꞉ yalo hata꞉ pomu lopa꞉la꞉ hali halipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Koto leeke Keinima꞉ mo Tekehali pa꞉ta꞉ alota꞉ Do ka꞉nda꞉ta꞉ I̱ma꞉ mea tia꞉peketa꞉ ana꞉ na pa꞉la꞉me laata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","kutupa nakana꞉ma꞉ta꞉ I̱ do kenke mina꞉pa꞉lao pono make naka꞉ leke tonona꞉ na hake hano leke tolu liteleme. Koto ekina꞉ I̱ta꞉ do kenkena꞉ da teke dia꞉yeke some hata꞉ ma꞉nda꞉ epima꞉ I̱ handa꞉ wia꞉ka꞉na꞉ta꞉ kota꞉ I̱ lilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Koto leekepate mo Tekehalima꞉ hombo peaaso alota꞉ Dia꞉me. Ma꞉nda꞉ epima꞉ neke lia꞉ka꞉na꞉ta꞉ kota꞉ koto somena꞉ hoke yenkita꞉ wataake hata꞉ peao haka꞉ta꞉pao homena꞉ lilieke leekeme. Koto leeke ekina꞉ ma꞉nda꞉ epima꞉ mo Keini manda꞉hande pia꞉ka꞉na꞉ta꞉ na lina꞉e alo hata꞉ Tekehalima꞉ mo somena꞉ lokena꞉ patehau ma꞉nda꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kutu pieke handaa Keinita꞉ mo Tekehalina꞉ leke popelekena꞉ tonona꞉ na hake pao mo Ideni ena꞉ nate opa꞉la꞉ nane mo Pomina꞉la꞉eki leeke kenke ma꞉nda꞉ pa꞉ta꞉ pua hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Keini pita꞉ ipika꞉ wanda꞉ yaapoma꞉ weki mondu wia bikita꞉ Inoko lepekeme. Kutupa Keinima꞉ daoni ma꞉nda꞉ a꞉eyaata꞉ eiyekena꞉ biki taapa꞉ tiao biki leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Wetepena꞉ Inokoma꞉ta꞉ biki Itado leke weki homeke mondu wiekeme. Itadota꞉ Mehudieilina꞉ ateke yekeme. Kutupa Mehudieilima꞉ta꞉ biki Meduseili leke weki mondu wiekeme. Meduseilita꞉ La꞉mekena꞉ ateke yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","La꞉mekema꞉ta꞉ wanda꞉ yaapo Ada pita꞉ Sila yaapo miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adama꞉ta꞉ Dieibolo mondu wiekeme. Ipikita꞉ mo palai da pa꞉ta꞉manu hata꞉ hotekemanu punieke ekina꞉ peayeke apa꞉meina꞉ kini pieke hali hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ipika꞉ hameketa꞉ Diubolo yekeme. Koto someta꞉ mo hande kidama꞉ handeke ale pita꞉ puo̱lo̱ yaapo limiki tapakena꞉ kini peayeke hali hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silama꞉ta꞉ weki Tubali Keini mondu wiekeme. Mo wekima꞉ta꞉ kopama꞉ handeke ale botonisi pita꞉ aeya꞉ni yaapoma꞉ mo ta꞉ta꞉ ta꞉ta꞉ piki kaiya sipeidimanu kini pea wepiekeme. Ipika꞉ belikita꞉ Nahama yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","La꞉mekema꞉ ipika꞉ weteke yaapo pa꞉ta꞉ alota꞉ Ada pita꞉ Sila yaapoo. Yaka pi opua꞉pe. Mo panake hali ma꞉nda꞉ma꞉ta꞉ I̱ yombieke handaa I̱ma꞉ ipiki lua꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Koto ekina꞉ta꞉ mo hande Keini lita꞉la꞉ ekina꞉ yenkita꞉ watake hata꞉ haliweki homolo pia꞉ka꞉na꞉ta꞉ kota꞉ ma꞉nda꞉ epima꞉ I̱ lia꞉ka꞉na꞉ tombota꞉ mo 77 haliwekita꞉ I̱ lila꞉eki yenkina꞉ homilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","A꞉da꞉ma꞉ pita꞉ weteke yaapoma꞉ta꞉ weki ma꞉nda꞉ mondu wipikime. Kutupa mo wanda꞉ma꞉ alota꞉ Keinima꞉ lia꞉ weki Eipolona꞉ anketeke mina꞉ yeke Koda꞉ma꞉ weki ma꞉nda꞉ ka꞉la꞉me laata꞉ ipika꞉ bikita꞉ Sedie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kutupa Sedima꞉ta꞉ biki Inosi leeke weki mondu wiekeme. Koto natena꞉ kini peaata꞉ mo wanda꞉halima꞉ Tekehalina꞉ yakopiki biki alo hata꞉ yeiya꞉ lao haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Dota꞉ mo hande A꞉da꞉ma꞉na꞉ tapakena꞉ biki ula꞉ ekie. Koda꞉ma꞉ hande wanda꞉hali wepieke dina꞉ta꞉ ipikima꞉ kone handeke wanda꞉hali wepitolota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","hali pita꞉ wanda꞉ yaapo wepiekeme. Ipikana꞉ma꞉ta꞉ mo tooli ta꞉na꞉ma꞉ homaasa꞉ pi laaka꞉na꞉ ipilika꞉ bikita꞉ Wanda꞉halie laa wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","A꞉da꞉ma꞉ ipika꞉ bapi 130 mieketa꞉ ipikima꞉ handeke weki ma꞉nda꞉ mondu wiaata꞉ ipika꞉ bikita꞉ Sedi leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Koto hoki naneta꞉ A꞉da꞉ma꞉ta꞉ bapi 800 hayekeme. Koto bapi tukiki pa꞉ta꞉ta꞉ mandane wekiwandiki make mendiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Kutupa ipikita꞉ 930 bapina꞉ta꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Mo Sedi ipika꞉ bapi 105 yeketa꞉ biki Inosi leeke weki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Kutupa bapi 807 tukiki pa꞉ta꞉ta꞉ mandane wekiwandiki make mondu wiaata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ipika꞉ 912 bapina꞉ta꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Mo Inosi ipika꞉ bapi 90 yeketa꞉ biki Kenana leeke weki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kutupa bapi 815 tukiki pa꞉ta꞉ta꞉ mandane wekiwandiki make mondu wiaata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","mo 905 bapina꞉ta꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Mo Kenana ipika꞉ bapi 70 yeketa꞉ Mahalale biki leeke weki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kutupa bapi 840 tukiki pa꞉ta꞉ta꞉ mandane wekiwandiki make wopu mondu wiaata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","mo 910 bapina꞉ta꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mo Mahalale bapi 65 yeketa꞉ Dia꞉tedi biki leeke weki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Kutupa bapi 830 tukiki pa꞉ta꞉ta꞉ mandane wekiwandiki make mondu wiaata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","mo 895 bapina꞉ta꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Mo Dia꞉tedi ipika꞉ bapi 162 yeketa꞉ biki Onoko leeke weki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Kutupa bapi 800 tukiki pa꞉ta꞉ta꞉ mandane wekiwandiki make mondu wiaata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","mo 962 bapina꞉ta꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Mo Inoko ipika꞉ bapi 65 yeketa꞉ biki Medusela leeke weki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Koto hoki naneta꞉ Inokota꞉ 300 bapi tukiki pa꞉ta꞉ta꞉ Koda꞉ yaapo ta꞉ma꞉ni pea hata꞉ mandane wekiwandiki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ipikita꞉ do kenkena꞉ 365 bapi hata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Koda꞉ yaapo ta꞉ma꞉ni pipikime. Kutupa ipikita꞉ Koda꞉ma꞉ miekeeki yalo hata꞉ pa alu paeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mo Medusela ipikita꞉ bapi 187 yeketa꞉ biki La꞉meke leeke weki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Kutupa bapi 782 tukiki pa꞉ta꞉ta꞉ mandane wekiwandiki make mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Kutupa 965 bapina꞉ta꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Mo La꞉meke ipikita꞉ bapi 182 yeketa꞉ weki mondu wia hata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","alota꞉ Mo Tekehalima꞉ esihou pi wieke kenkena꞉ kone do wekima꞉ta꞉ do nika꞉ ka꞉nda꞉ paeyao mea baalo pa꞉la꞉ wekie alo hata꞉ ipika꞉ bikita꞉ Noa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Kutupa bapi 595 pa꞉ta꞉ta꞉ mandane wekiwandiki make mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Kutupa 777 bapina꞉ta꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Kutupa Noa ipiki bapi 500 mieketa꞉ weki tepo mondu wiekeme. Ika꞉ bikita꞉ Seme make Ha꞉me make Dieipedi yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Mo hande wanda꞉hali paeyao kenke honiki honiki paeyaona꞉ putupieke handaata꞉ wandiki titi make mendimikime. ");
INSERT INTO ssx_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Kutupa mo wandiki tonuta꞉ seliapo pimiki handaa mo Koda꞉na꞉ eiyeke tonuma꞉ ika꞉ hone pia꞉ tupa꞉ muma꞉ muma꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kutupa Tekehalima꞉ alota꞉ I̱ma꞉ mo wanda꞉halita꞉ pa na hao haena꞉ lolueke laata꞉ Pa ekipeke ikita꞉ homa꞉peke ya꞉la꞉ loke halemeke handa loa꞉me. Koto ekina꞉ ame do siki kini pea puata꞉ ma꞉nda꞉ 120 bapi haka꞉ta꞉pao na haena꞉ lolueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Koto nate nina꞉ make wetepe nina꞉ make do kenkena꞉ta꞉ mo hande kenke wanda꞉ pita꞉ Koda꞉na꞉ eiyeke yaapona꞉ monduma꞉ monduma꞉ pieke weki titita꞉ ankolomeke haliweki titima꞉ handemekeme. Ikita꞉ you hali tieke tieke hata꞉ ikita꞉ mo amba꞉ kiake haemeke wanda꞉halina꞉ biki kende tupaa wieke haliweki yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mo Tekehalima꞉ do kenkena꞉ haemeke wanda꞉hali paeyaoma꞉ hoto paeyao ika꞉ putia peme hoke haumanu make ika꞉ temokona꞉ honemanu u tia peme ekimanu make hando haota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ipikana꞉ma꞉ alota꞉ oni wanda꞉halita꞉ pa ekipeke do kenkena꞉ haena꞉ wepia polope hone wiekeme. Koto ekina꞉ koto hone wotu witolo hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","I̱ma꞉ do wepolo wanda꞉hali make hotekemanu make bamanu make paeyaota꞉ I̱ma꞉ kone homena꞉ lia baalueke laa I̱ma꞉ta꞉ pa ekipeke wepia polope leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pate mo Tekehalima꞉ta꞉ Noa yaapota꞉ ta꞉na꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Dota꞉ Noa tapakena꞉ pie. Ipikita꞉ weki tepo mondu wiekeme. Seme make Ha꞉me make Dieipedi make yekeme. Noa hayeke natena꞉ ipikita꞉ pu ata꞉ka꞉ peaya꞉eki ma꞉nda꞉ dia꞉yalo hata꞉ ipiki homeke homeke epeke some hayekeme. Ipikita꞉ Koda꞉ yaapo ta꞉ma꞉ni pea hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Pate Koda꞉na꞉ leke popelekena꞉ wanda꞉hali paeyaota꞉ hoke hauma꞉ tumbulu bao make haku na piki hau pita꞉la꞉eki manuma꞉ta꞉ kenke honiki paeyao pa꞉ta꞉ putu piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kutupa Koda꞉ma꞉ handeekepate do kenketa꞉ hoeya꞉pa wia wanda꞉hali paeyaota꞉ hokeeki pa꞉ta꞉ haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Koda꞉ma꞉ Noa pa꞉ta꞉ alota꞉ I̱ma꞉ wanda꞉hali paeyao ota꞉ hoeyaalueke hone witolome laata꞉ Do kenkena꞉ta꞉ ika꞉ haku na piki hau manuma꞉ tumba꞉la꞉ ekina꞉ iki paeyao siki hoeyaalueke. ");
INSERT INTO ssx_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kutu pulu pa꞉la꞉ ekina꞉ nakana꞉ma꞉ epeke tima꞉ naka꞉ sisima a꞉eyaa tukiki naneta꞉ da panda꞉manu wepiaata꞉ oni tukiki nane make hama꞉ nane make ota꞉ paeyao koloda lia꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kutupa hokulu pulu pa꞉la꞉ ekina꞉ tombota꞉ 133 mida wepiaata꞉ mo petipeke ya꞉la꞉ ekina꞉ tombota꞉ 22 mida wepia haliao halo pa꞉la꞉ ekina꞉ tombota꞉ 13 mida wepia꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kutupa mo sisimana꞉ta꞉ holu wepia mo holu tukikina꞉ make pa꞉ta꞉liki yaapona꞉ make waleke 44 sendimida wina꞉ lapeke. Kutupa mo sisimana꞉ tukiki pa꞉ta꞉ta꞉ puku tepo wiaata꞉ tea꞉na꞉ta꞉ pota꞉ kake lombapeke. ");
INSERT INTO ssx_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Pa ekipeke I̱ma꞉ta꞉ do kenkena꞉ haleme pa pitiki ale paeyao siki hoeyaaluekema꞉ yeke ikali tieke a꞉meina꞉ tapaaluekema꞉ loa꞉me. Kutupa do kenkena꞉ haleme aleta꞉ ota꞉ paeyao homilimikie. ");
INSERT INTO ssx_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Pate I̱ma꞉ta꞉ neke pa꞉ta꞉ ya pi la꞉ ulueke. Koto ekina꞉ naka꞉ wanda꞉ ipiliki make naka꞉ weki tonu make ika꞉ wanda꞉weki make oni sisima pa꞉ta꞉ pupe. ");
INSERT INTO ssx_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Kutupa ta꞉ta꞉ ta꞉ta꞉ piki hotekemanu make bamanu make homaama꞉na꞉ wanda꞉eki mea꞉tiki halieki mea꞉tiki pea oni sisima pa꞉ta꞉ mea pupe. ");
INSERT INTO ssx_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kutupa ika꞉ ne make mo hoteke ba manuna꞉ make nolo peleme nemanu make mea pua꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Koto leeke handaa Noama꞉ta꞉ Koda꞉ma꞉ pea꞉peke leeke hau sunu paeya꞉ tapao ana꞉na꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mo Tekehalima꞉ Noa pa꞉ta꞉ alota꞉ Do kenke honiki paeyao pa꞉ta꞉ta꞉ I̱ma꞉ta꞉ neke homeke homeketa꞉ mo tikitiki hau pu haleeki handa꞉ ulu ekina꞉ naka꞉ wekiwandiki iki paeyao oni sisima pa꞉ta꞉ pupe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kutupa neke ame̱le̱ta꞉ mo ota꞉ ha̱i̱ na ta̱leke ta꞉ta꞉ ta꞉ta꞉ piki hoteketa꞉ wataake hata꞉ tooli tooli lo mea polo pelepateta꞉ mo ha̱i̱ ta̱leke ta꞉ta꞉ ta꞉ta꞉ piki hoteke manuta꞉ tooli homeke lo mea꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kutupa mo ta꞉ta꞉ ta꞉ta꞉ piki bamanu make wataake hata꞉ tooli tooli lo mea꞉peke. Pa ekipeke kutupiki hau pika꞉na꞉ta꞉ kota꞉ mo ta꞉ta꞉ ta꞉ta꞉ piki hotekemanu make bamanu make na alupiki pa do kenkena꞉ mondu sembelaena꞉ lelipikie. ");
INSERT INTO ssx_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kutupa ame do natena꞉ kini pea yata꞉polo mo wataake hata꞉ peao nate paeya꞉ka꞉na꞉ta꞉ mo I̱ma꞉ wepolo pa pitiki alemanu paeyao hoeyaena꞉ yeketa꞉ hali tieke yaapo natena꞉ta꞉ na to lena꞉ leke lako lopena꞉ lolueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Koto leeke Noama꞉ta꞉ mo Tekehalima꞉ ota꞉ pea꞉peke leeke ekimanu paeya꞉ tapao piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noata꞉ bapi 600 mieke dina꞉ta꞉ do kenkena꞉ mo ikali tieke a꞉meiyekeeki epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ipiliki tooli make ipilika꞉ weki tooli tooli make mo ikali tieke a꞉meiyolo piekeeki wendiao oni sisima pa꞉ta꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Kutupa mo ta꞉ta꞉ ta꞉ta꞉ piki ha̱i̱ ta̱leke make ha̱i̱ na ta̱leke hotekemanu make bamanu make paeyao siki tooli tooli lo ");
INSERT INTO ssx_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","mo Koda꞉ma꞉ pia꞉peke leeke tupa꞉ Noa ame̱le̱ oni sisima pa꞉ta꞉ honda꞉ pambemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Kutupa wataake hata꞉ nate paeyeketa꞉ mo ikali tieke kini pea teekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa ipika꞉ bapi 600 mieketa꞉ mo hande yaapo peao opeeke kaisepona꞉ pula yaapona꞉ pa nate tepo mieketa꞉ mo kenke tekilipulu bao oni kenke oto nane ula꞉ ikali paeyao opolu bao make oli ya nane wieke lakota꞉ pota꞉ lombieke pita꞉ta꞉ lombolu baeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Kutupa mo lako pa ipulu ipulu haena꞉ta꞉ hali tieke yaapo nate pa mulu yapeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Koto kone Koda꞉ma꞉ pua꞉peke leeke natena꞉ta꞉ Noa tooli make ipilika꞉ eiyeke tonu Seme make Ha꞉me make Dieipedi make ika꞉ weteke tonu make paeyao oni sisima pa꞉ta꞉ honda꞉ pambemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Mo hosiki hosiki ale make aneke alemanu make pona꞉la꞉eki pita꞉ tikene hala꞉ ta꞉ta꞉ ta꞉ta꞉ piki hoteke make bamanu make mo Noa tapake ame̱le̱ mandakena꞉ pitulu pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Mo ta꞉ta꞉ ta꞉ta꞉ piki pa pitiki alemanu tooli tooli lo mo Tekehalima꞉ leeke tupa꞉ Noa ame̱le̱ oni sisima tukiki pa꞉ta꞉ pemekeme. Kutupa mo Tekehalima꞉ Noana꞉ hoki teli teli pu kone pota꞉ poka꞉moneayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kutupa mo ikali tieketa꞉ hali tieke yaapo natena꞉ epeeketa꞉ mo sisima tia halo pieke tupa꞉ ikali kendo ana꞉na꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Kutupa mo ikalita꞉ noka꞉ tieke wiekeeki yalo hata꞉ mo sisimata꞉ manda tia pomiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mo ikalita꞉ ota꞉ noka꞉ tieke wiekeeki yalo hata꞉ mo hokulupeke pote tumiki manuta꞉ ota꞉ tote peao alu paeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Kutupa mo ikali tieketa꞉ mi̱li mi̱li a꞉meiyolo hata꞉ mo ota꞉ lombeipiki hokulupeke pote tumiki manuta꞉ ikalima꞉ta꞉ pa 7 mida tupa꞉ anekema꞉ tote piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kutu pieke handaa do kenkena꞉ pa pitiki alemanu paeyao homeekeme. Mo bamanu paeyao make hotekemanu paeyao make wanda꞉hali paeyao make ota꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Do kenkena꞉ pomo mea pitimiki alemanu paeyao homemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mo Tekehalima꞉ta꞉ do kenkena꞉ pa pitiki alemanu paeyao hoeyaeyekeme. Wanda꞉hali make hotekemanu make bamanu make paeya꞉ tapao hoeyaeyekeme. Pate Noa ame̱le̱ oni sisima pa꞉ta꞉ pitimikieki homeke pa pambo haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mo ikali tieketa꞉ 150 natena꞉ kone pa taa hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Koda꞉ma꞉ta꞉ Noa pita꞉ mo sisima pa꞉ta꞉ pitimiki tapake paeyaota꞉ hone na yonka꞉laeyekeme. Ipikana꞉ma꞉ po epena꞉ leeketa꞉ mo ikali kini pea o̱ loma꞉ loma꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Mo hande kenke oto nane a꞉liaeyeke ikali pita꞉ oli ya nane lombolu baeyeke ikali yaapo telipina꞉ a꞉mbeeketa꞉ mo lako paeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Kutupa mo ikalita꞉ pa 150 nate ma꞉nda꞉na꞉ta꞉ o̱ loma꞉ loma꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Kutupa mo wataake peao kaisepona꞉ pula yaapona꞉ nate tepona꞉ mo sisimata꞉ mo A꞉ta꞉ta꞉de tokona꞉ a꞉pa wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Kutupa mo ikalita꞉ o̱ la꞉niatia pua kiki yaapo peao kaisepo opeeke titina꞉ natena꞉ta꞉ mo pote tumikimanu peneme yao waleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kutupa nate hali tieke yaapo paeyeketa꞉ Noama꞉ da ka꞉ka꞉na꞉ ma꞉nda꞉ lomba ");
INSERT INTO ssx_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","mo (da꞉e̱i̱nkima꞉ handeke) ba homeke ipika꞉ biki leibeni tapaeyekeme. Mo hande ba paa na la꞉ka꞉la epeeketa꞉ mo ikali o̱ la hala꞉pa꞉ wina꞉yeke pa a̱ya̱ pomu lopo hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kutu pieketa꞉ Noama꞉ mo ikali o̱ la꞉niala꞉pe la handena꞉ yeke paa ba ma꞉nda꞉ melipu tapaeyekepate ");
INSERT INTO ssx_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","mo kenketa꞉ ikalima꞉ pa tote pea wiekeeki yalo mo melipu ipiki pita꞉peke alena꞉ dia꞉yeke handaa paa mo sisima wieke alena꞉ pa la꞉ka꞉la peekeme. Kutu pieke handaa Noama꞉ kiki hama꞉ nane pena꞉ laa mo ba handa꞉ miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Kutupa mo hoto wataake hata꞉ nate pa yu wia haota꞉ mo hande melipu paa pena꞉ tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kutu pieketa꞉ mo melipuma꞉ta꞉ nate oni pambolo pulu haena꞉ ipika꞉ kake pa꞉ta꞉ mo panake olipi katake hapula Noa pa꞉ta꞉ paa epeekeme. Kutu piekeeki handaa Noama꞉ta꞉ mo ikalita꞉ o̱ la꞉niaya꞉ka꞉ta꞉me hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Kutupa Noama꞉ wataake hata꞉ natena꞉ pa hao mo melipu paa tapaeyekepate koto natena꞉ta꞉ mo hande bata꞉ paa na la꞉ka꞉la epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Mo Noata꞉ 601 bapi mieketa꞉ mo titina꞉ kaisepona꞉ titina꞉ natena꞉ta꞉ mo ikalita꞉ ota꞉ o̱ la꞉niayekeme. Kutu pieke handaa Noama꞉ta꞉ mo sisima a꞉mbaeyeke ale mea bao lekema꞉ lekema꞉ piekepate mo kenketa꞉ hapuma꞉ hapuma꞉ pia꞉eki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mo yaapo peao kaisepona꞉ pula tepo paeya yunki mindiki hata꞉ peao natena꞉ta꞉ mo kenketa꞉ ota꞉ hapupa peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Koda꞉ma꞉ Noa pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Naka꞉ wanda꞉ make naka꞉ weki tooli tooli make hama opolu bao yopupe laata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mo ba manuma꞉ make hoteke manuma꞉ make mendiolo mendiolo ombu haya꞉ka꞉na꞉ do kenke honiki paeyao pa꞉ta꞉ sembelena꞉ mea opolu bapee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Koto leeke Noa tooli make ipilika꞉ weki tooli tooli make mo sisima mina꞉pa꞉lao hama opolu bao pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Kutupa mo hotekemanu make bamanu make ika꞉ homeke tapake sunu lo mandakena꞉ opolu baemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noama꞉ta꞉ Koda꞉ pa꞉ta꞉ oloda wepiata꞉ mo ha̱i̱ na ta̱leke hotekemanu make bamanu make tapake tapakena꞉ homeke homeke lo mea tieke tonka꞉na꞉ mo olodana꞉ lu yanka haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kutu pieke handaa mo lia haleeke hotekena꞉ totopo seliapoma꞉ta꞉ mo Tekehali ta꞉na꞉ homa꞉ tiayeke handaa ipika꞉ kone alota꞉ Do wanda꞉halima꞉ pu haleme ekina꞉ I̱ma꞉ do kenketa꞉ esihou pi oto pa꞉ta꞉ ota꞉ paa na wina꞉ lolueke. Pa ekipeke ika꞉ mo panake daeta꞉la꞉me ale pa꞉ta꞉ koneta꞉ hoke honemanu wilimi ekita꞉ I̱ma꞉ hone ulu ekina꞉ loa꞉me. Koto ekina꞉ I̱ma꞉ ame do pua꞉ tupa꞉ mo do kenkena꞉ pa pitiki alemanu paeyao ota꞉ paa a꞉nda꞉ na hoeyaalueke. ");
INSERT INTO ssx_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Kutupa do kenke pa wina꞉ta꞉ noka꞉pa꞉la꞉ nate make ne napeke mina꞉la꞉ nate make wilieke. Kutupa make hoto paeyao kosa꞉ make titipu make nate ki make lako ki make nate make timba꞉ make ota꞉ pa u̱ pelia halieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Koda꞉ma꞉ Noa a꞉tala꞉ a꞉tala꞉ pa꞉ta꞉ epeaasa꞉ pima꞉ alota꞉ Ika꞉ monduma꞉ monduma꞉ pilimi wekiwandikita꞉ do kenke honiki paeyao pa꞉ta꞉ haena꞉ma꞉ wekiwandiki wopu mendia꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","laata꞉ mo hotekemanu paeyao make bamanu paeyao make ta꞉peli paeyao make ika꞉ honkopu oto pa꞉ta꞉ haleme ekina꞉ iki paala꞉ halimikie. ");
INSERT INTO ssx_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kutupa ameta꞉ mo tanimanu no haleme tupa꞉ do hotekemanu paeyao make lia nomena꞉ yeke kitolopate ");
INSERT INTO ssx_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","pa mo we pa pitiki hoteke homeke na napa꞉peke. Pa ekipeke mo da꞉ta꞉la꞉ ekita꞉ koto we pa꞉ta꞉ pileke loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kutupa ma꞉nda꞉ epima꞉ hali ma꞉nda꞉na꞉ da꞉ta꞉la꞉eki mia꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ hoke yenki halueke. Kutupa hoteke ma꞉nda꞉ma꞉ hali ma꞉nda꞉na꞉ da꞉ta꞉la꞉eki mia꞉ka꞉na꞉ta꞉ I̱ma꞉ta꞉ ipika꞉ hoke yenkita꞉ homa꞉la꞉eki halueke. ");
INSERT INTO ssx_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Halita꞉ Koda꞉ leke wepieke ekina꞉ta꞉ ma꞉nda꞉ma꞉ hali ma꞉nda꞉ homena꞉ lia꞉ka꞉na꞉ta꞉ kota꞉ koto someta꞉ hali tonuma꞉ kone lilimikie. ");
INSERT INTO ssx_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ika꞉ monduma꞉ monduma꞉ pilimi wekiwandikina꞉ wekiwandikita꞉ do kenke honiki paeyao pa꞉ta꞉ haena꞉ma꞉ wekiwandiki wopu mendia꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Koda꞉ma꞉ Noa a꞉tala꞉ a꞉tala꞉ pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Iki make ika꞉ monduma꞉ monduma꞉ pilimi wekiwandikina꞉ wekiwandiki pa꞉ta꞉ tonka꞉na꞉ I̱ma꞉ dupiki pi la꞉ witolome. ");
INSERT INTO ssx_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Koto pita꞉ mo hande sisima pa꞉ta꞉ iki ame̱le̱ epemeke pa pitiki alemanu paeyaota꞉ mo bamanu make hotekemanu make iki paeyao pa꞉ta꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Dupiki pi manuma꞉ta꞉ iki ame̱le̱ pi la꞉ witolome. Mo kenkena꞉ pa pitiki alemanu paeyaota꞉ mo ikali tieke tiekema꞉ ota꞉ paa na hoeyaena꞉ laata꞉ mo ikali tieke tiekema꞉ do kenke paeyao paa na hoeyaena꞉e laa I̱ma꞉ la꞉ witolome. ");
INSERT INTO ssx_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Kutupa do iki ame̱le̱ make mo pa pitiki alemanu ame̱le̱ make do ota꞉ na paeyeke pa u halo pa꞉la꞉ la꞉ witolo patehau witolo ekita꞉ ");
INSERT INTO ssx_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","oli koana꞉ yaka ka꞉la꞉da꞉peiya witolo ekita꞉ I̱ma꞉ do kenke yaapo pi la꞉ ulu ekina꞉ patehau ulueki yelieke. ");
INSERT INTO ssx_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","I̱ma꞉ oli yata꞉ koa manuma꞉ a꞉mbatiki pitolo hata꞉ mo ka꞉la꞉da꞉peiya a꞉pa꞉tiki pia꞉ka꞉na꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","kota꞉ I̱ma꞉ mo hande iki ame̱le̱ make mo hotekemanu ame̱le̱ make ikali tieke tiekema꞉ mo pa pitiki alemanu paeyao paa na hoeyaalueke laa pi la꞉ ua꞉eki niminaalueke. ");
INSERT INTO ssx_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mo ka꞉la꞉da꞉peiya oli koa manuna꞉ peneme yatiki pia꞉ka꞉na꞉ta꞉ kota꞉ I̱ma꞉ do kenkena꞉ haleme pa pitiki alemanu nika꞉ mo na paeya꞉peke pi la꞉ uma꞉eki paa niminatiki pulueke. ");
INSERT INTO ssx_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Mo ka꞉la꞉da꞉peiyata꞉ I̱ma꞉ mo pa pitiki alemanu paeyao pa꞉ta꞉ pi la꞉ witolo ekina꞉ patehaue leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Mo sisima pa꞉ta꞉ pita pemeke Noana꞉ eiyeke tonuta꞉ Seme make Ha꞉me make Dieipedi makee. Ha꞉meta꞉ Keinanina꞉ atekee ");
INSERT INTO ssx_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Mo Noana꞉ eiyeke tepota꞉ do kenke wanda꞉hali paeyaona꞉ apa꞉meie. ");
INSERT INTO ssx_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noata꞉ e hali yalo ipikita꞉ titina꞉ waini pu noko peeke halie. ");
INSERT INTO ssx_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ipikana꞉ma꞉ mo waini ikali naa keaaso hata꞉ta꞉ ipika꞉ aka꞉manu holo bao pa tu mea hata꞉ ipika꞉ palai da pa꞉ta꞉ pumbuniao wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kutupa mo Keinanina꞉ ateke Ha꞉mema꞉ ipika꞉ ateke pa tia peliekeeki hando haota꞉ hameke yaapo lolo hama꞉ nane peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kutu pieke handaa Seme pita꞉ Dieipedi yaapoma꞉ta꞉ ateke pa tia peliekeeki handa꞉peke yeketa꞉ dau homeke ipilika꞉ peiyokona꞉ pulumbao tia hoki la꞉ka꞉la oni palai da pa꞉ta꞉ pua pa ale handa hata꞉ atekena꞉ loke manda lopamoneao a꞉mbaepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kutupa Noa ipika꞉ hone paa epeeketa꞉ mo ipika꞉ wetepe wekima꞉ ipiki pa꞉ta꞉ piekeeki handa꞉ u hao ");
INSERT INTO ssx_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Noama꞉ alota꞉ Keinani pa꞉ta꞉ esihou pi witoloma꞉ ipikita꞉ ipika꞉ kame yaapona꞉ pa hameke e pokaasa꞉ hali halieke. ");
INSERT INTO ssx_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mo Semena꞉ Tekehali Koda꞉na꞉ biki mina꞉liape. Keinanita꞉ Semena꞉ pa hameke e pokaasa꞉ hali halieke. ");
INSERT INTO ssx_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mo Koda꞉ma꞉ta꞉ Dieipedina꞉ tapake daetolota꞉ ipika꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandikita꞉ mo Semena꞉ wanda꞉hali ame̱le̱ haena꞉e. Keinanita꞉ Dieipedina꞉ pa hameke e pokaasa꞉ hali halieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Mo ikali tieke tieke a꞉pa hoki nane Noata꞉ 350 bapi pa ha pelia hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Kutupa 950 bapi mieketa꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Mo hande Noana꞉ eiyeke tonu Seme make Ha꞉me make Dieipedi make ika꞉ monduma꞉ monduma꞉ pimiki wekiwandikina꞉ wekiwandikina꞉ bikimanu doe. Mo hande ikali tieke tieke a꞉pa hoki naneta꞉ do weki tepoma꞉ta꞉ weki titi mondu wimikime. ");
INSERT INTO ssx_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Mo Dieipedina꞉ eiyeke tonuta꞉ Koma make Meikoko make Madai make Diapani make Diubolo make Meseke make Taitasi makee. Ikita꞉ mo ika꞉ biki kone yano loma꞉ loma꞉ pimiki da wanda꞉halina꞉ apa꞉mei tonue. ");
INSERT INTO ssx_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Mo Komama꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikita꞉ mo A꞉sekena꞉se make Tipa꞉di make Tokama make koto damanu pa꞉ta꞉ haemeke wanda꞉halie. ");
INSERT INTO ssx_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Mo Diapanima꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikita꞉ mo A꞉lisia make Sepeini make Saipotasi make Loa꞉disi make koto da kenkemanu haemeke wanda꞉halie. ");
INSERT INTO ssx_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ikita꞉ mo dawala tea꞉na꞉ make mo dawala u dupala꞉ kenke sunu pa꞉ta꞉ make pelia haemeke wanda꞉halina꞉ apa꞉meie. Do koto wanda꞉halita꞉ mo Dieipedima꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikie. Ikita꞉ ika꞉ kenke ma꞉nda꞉ ma꞉nda꞉ pa꞉ta꞉manu hao tutu ta꞉ta꞉ ta꞉ta꞉ hao tapake homeke homekema꞉ ika꞉ da pi ta꞉ta꞉ ta꞉ta꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ha꞉mena꞉ eiyeke tonuta꞉ Kusu make Idiepi make Libia make Keinani makee. Ikita꞉ mo ika꞉ biki yano loma꞉ loma꞉ pimiki da wanda꞉halina꞉ apa꞉mei tonue. ");
INSERT INTO ssx_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Mo Kusuma꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikita꞉ mo Siba make Ha꞉pila make Sabita make Lama make Sabeteka make koto da kenkemanu pa꞉ta꞉ haemeke wanda꞉halie. Mo Lamama꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikita꞉ mo Seba pita꞉ Dedani da wanda꞉halie. ");
INSERT INTO ssx_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusuma꞉ mo weki biki Nimolodo mondu wiekeme. Koto wekita꞉ do kenkena꞉ titina꞉ a꞉nda꞉ wotu bepolatiki pieke hali hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Mo Tekehalima꞉ tamba꞉ mina꞉la꞉ ekima꞉ ipikita꞉ mo yapa꞉ eiya꞉ wotu no hayeke hali hayekeme. Koto ekina꞉ yeketa꞉ wanda꞉halima꞉ alota꞉ Tekehalima꞉ neketa꞉ Nimolodo pieke tupa꞉ yapa꞉ eiya꞉ wotu no pele hali hawaena꞉e lo halememe. ");
INSERT INTO ssx_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimolodo ipika꞉ titina꞉ kilu tombuao hayeke daoni manuta꞉ Ba꞉biloni make Eleke make Aka꞉de makee. Koto daoni tepota꞉ mo Ba꞉biloni kenke pa꞉ta꞉ haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Koto kenkena꞉ haota꞉ ipikita꞉ mo A꞉sitia kenke pa꞉ta꞉ pua Ninipa daoni pita꞉ Lihobodi Ia daoni make Kala daoni make ");
INSERT INTO ssx_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","kutupa mo Ninipa daoni pita꞉ Kala daoni aneke yaapo tukikina꞉ hala꞉ Leseni daoni make paeyao a꞉eyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mo Idiepima꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikita꞉ mo Lidia make A꞉namo make Leha꞉be make Na꞉pidu make ");
INSERT INTO ssx_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pa꞉dutusi make Ka꞉solu make mo Pilisidaini wanda꞉hali kini pa꞉la꞉ da Ka꞉podo make koto da wanda꞉hali yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Mo hande Keinanina꞉ eiyeke tonuta꞉ mupeke weki Saidoni make Hedi makee. Ipilikita꞉ mo ipilika꞉ biki yano loma꞉ loma꞉ pimiki da wanda꞉halina꞉ apa꞉meie. ");
INSERT INTO ssx_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Keinani ombuta꞉ mo Diebasi wanda꞉hali make A꞉mo wanda꞉hali make Keakasi wanda꞉hali make ");
INSERT INTO ssx_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hipai wanda꞉hali make Aki wanda꞉hali make Sini wanda꞉hali make ");
INSERT INTO ssx_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Apa꞉de wanda꞉hali make Sema wanda꞉hali make Ha꞉mode wanda꞉hali make koto wanda꞉hali paeya tapao sikina꞉ apa꞉mei hayekeme. Mo Keinani wanda꞉hali tutu ta꞉ta꞉ ta꞉ta꞉ putupulu bao puata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ikana꞉ma꞉ yu tombo kini piki hauta꞉ mo Saidoni da nepoko nane kini pea pua mo Kasa da nanema꞉ tilao Kita da puata꞉ mo Laasa nanema꞉ tilao Sodomo make Komota make A꞉dema make Seboimi da manuna꞉ nate opa꞉la꞉ nanema꞉ tilao pua u naemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Mo Ha꞉mema꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikita꞉ ika꞉ tutu ta꞉ta꞉ ta꞉ta꞉ pa꞉ta꞉ make kenke ta꞉ta꞉ ta꞉ta꞉ pa꞉ta꞉ make hata꞉ta꞉ tapake homeke homekena꞉ ika꞉ pita꞉ ta꞉ta꞉ ta꞉ta꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Mo hande Dieipedina꞉ hameke titina꞉ weki Semeta꞉ mo Hibulu wanda꞉hali paeyaona꞉ apa꞉mei yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semena꞉ eiyeke titita꞉ Ila꞉me make A꞉sia make Apa꞉kesade make Ludu make Atamo makee. Ikita꞉ mo ika꞉ biki kone yano loma꞉ loma꞉ pimiki da wanda꞉halina꞉ apa꞉mei tonue. ");
INSERT INTO ssx_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Mo Atamoma꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikita꞉ mo Usu make Hulu make Keta make Meseke make koto damanu pa꞉ta꞉ haemeke wanda꞉halie. ");
INSERT INTO ssx_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apa꞉kesadeta꞉ Silana꞉ ateke yekeme. Kutupa Silata꞉ Ebena꞉ ateke yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebeta꞉ weki yaapo mondu wiekeme. Weki ma꞉nda꞉na꞉ bikita꞉ Peleke leeke ekita꞉ mo weki ipika꞉ hayeke natena꞉ta꞉ do kenkena꞉ haemeke wanda꞉halita꞉ putupa꞉ alualu pieke handa leekeme. Kutupa weki ma꞉nda꞉na꞉ bikita꞉ Diokotani leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Mo Diokotanima꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikita꞉ mo Amoda꞉di make Selepe make Ha꞉samapede make Dieta make ");
INSERT INTO ssx_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Ha꞉dotamo make Usalo make Dikila make ");
INSERT INTO ssx_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obalo make Abima꞉elo make Siba make ");
INSERT INTO ssx_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opa make Ha꞉pila make Dioba꞉be make koto damanu pa꞉ta꞉ haemeke wanda꞉halie. Iki paeyaota꞉ Diokotanima꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikie. ");
INSERT INTO ssx_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Mo tapake pelieke kenketa꞉ mo Mesa kenkena꞉ hao pua ota꞉ mo Sepa kenkena꞉ nate opa꞉la꞉ nane tumiki eli wieke kenke pa꞉ta꞉manu haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Do alo tapaketa꞉ Semema꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikie. Ikita꞉ tutu ta꞉ta꞉ ta꞉ta꞉ pa꞉ta꞉ make kenke ta꞉ta꞉ ta꞉ta꞉ pa꞉ta꞉ hata꞉ta꞉ tapake homeke homekema꞉ta꞉ ika꞉ pita꞉ ta꞉ta꞉ ta꞉ta꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Koto wanda꞉hali paeyao sikita꞉ Noama꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikie. Kutupa ika꞉ kenke ma꞉nda꞉ ma꞉nda꞉na꞉ hatia epelemeeki maketa꞉ ika꞉ ta꞉ta꞉ ta꞉ta꞉ lo monduma꞉ monduma꞉ pieke tupa꞉ kone hatia epelememe. Mo ikali tieke tieke paeyeke hoki naneta꞉ do kenke ma꞉nda꞉ ma꞉nda꞉na꞉ hala꞉ wanda꞉halita꞉ mo Noana꞉ eiyeketonu pa꞉ta꞉ kini pea epemeke wanda꞉halie. ");
INSERT INTO ssx_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Amba꞉ titina꞉ do kenke honiki honiki paeyaona꞉ haemeke wanda꞉hali paeyaoma꞉ta꞉ da pi homeke la make homeke pi kone lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ikita꞉ mo nate opa꞉la꞉ nanema꞉ pomu lopaata꞉ oni homeke hau honda꞉ lia wieke Ba꞉biloni kenkena꞉ a꞉paata꞉ koto pate pitimikime. ");
INSERT INTO ssx_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Kutupa ika꞉ ika꞉ kone alota꞉ A꞉e. Ameta꞉ mo ma꞉na꞉ kenkema꞉ la꞉ka꞉la toopima꞉ handeke hankola꞉papeke alemanu wepumana꞉e lemekeme. Kutu pimikita꞉ mo wepimiki toopimanu make mo toopimanu tuna tuna pea miniki halo pieke koloda make wimikime. ");
INSERT INTO ssx_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Koto ekina꞉ ikana꞉ma꞉ alota꞉ Nika꞉ biki mina꞉liaena꞉ yeke make niki mo kenke honiki honiki pa꞉ta꞉ na putupa꞉ alualu pulu poloma꞉ tupa꞉ maketa꞉ daoni ma꞉nda꞉ a꞉etolo hata꞉ mo haliao hokulupeke da tieke ma꞉nda꞉ oli ya pa꞉ta꞉ lia a꞉emana꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kutu pimiki handaa Tekehalita꞉ mo hande haliwekima꞉ a꞉emeke daoni make mo ya pa꞉ta꞉ peeke hokulupeke da tieke make handuluekema꞉ holopeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Kutupa a꞉pa ipikana꞉ma꞉ alota꞉ Ameta꞉ do wanda꞉halita꞉ homeke wanda꞉hali halemeke yalo homeke pi kone alememe laata꞉ Dota꞉ ika꞉ pua꞉tiki polo peleme ekina꞉ kini piteleme ekie. Kutupa ikana꞉ma꞉ta꞉ teke pa꞉ta꞉ ika꞉ hone pa꞉la꞉ anemone hau paeyao pa pilimikie. ");
INSERT INTO ssx_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Koto ekina꞉ niki pua ika꞉ ika꞉ kone hone na u alualu pulu peleme tupa꞉ ika꞉ pi topo topo pealo bape leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Koto ekina꞉ Tekehalima꞉ mo wanda꞉hali paeyao kenke honiki honiki paeyao pa꞉ta꞉ putupa putupa pieketa꞉ mo daonita꞉ pao na a꞉emekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Mo Tekehalima꞉ mo wanda꞉hali paeyaona꞉ pi koto pate topo topo peao kenke honiki honiki paeyao pa꞉ta꞉ putupa yeke handaa mo daonina꞉ bikita꞉ Beibolo lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Semema꞉ monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikina꞉ bikimanu doe. Mo hande ikali tieke tieke yopua bapi yaapo yapeeke hoki naneta꞉ Seme ipiki bapi 100 mieketa꞉ weki Apa꞉kesade mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Kotoeki hoki naneta꞉ bapi 500 pa haota꞉ mandane wekiwandiki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Mo Apa꞉kesadeta꞉ bapi 35 mieketa꞉ weki Sila mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Kotoeki hoki naneta꞉ bapi 403 pa haota꞉ mandane wekiwandiki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Mo Silata꞉ bapi 30 mieketa꞉ weki Ebe mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Kotoeki hoki naneta꞉ bapi 403 pa haota꞉ mandane wekiwandiki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Mo Ebeta꞉ bapi 34 mieketa꞉ weki Peleke mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Kotoeki hoki naneta꞉ bapi 430 pa haota꞉ mandane wekiwandiki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Mo Peleketa꞉ bapi 30 mieketa꞉ weki Teu mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Kotoeki hoki naneta꞉ bapi 209 pa haota꞉ mandane wekiwandiki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Mo Teu bapi 32 mieketa꞉ weki Setuku mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Kotoeki hoki naneta꞉ bapi 207 pa haota꞉ mandane wekiwandiki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Mo Setuku bapi 30 mieketa꞉ weki Neiho mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Kotoeki hoki naneta꞉ bapi 200 pa haota꞉ mandane wekiwandiki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Mo Neihota꞉ bapi 29 mieketa꞉ weki Dita mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Kotoeki hoki naneta꞉ bapi 119 pa haota꞉ mandane wekiwandiki mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Mo Ditata꞉ bapi 70 mieketa꞉ Eipola꞉ma꞉ make Neiho make Hatani ika꞉ ateke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Dota꞉ mo Eipola꞉ma꞉ make Neiho make Hatani ika꞉ ateke Ditama꞉ kini pea monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikie. Hatanita꞉ Lodana꞉ ateke yeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Hatanita꞉ ipika꞉ apa꞉ pa haena꞉ kone ipikita꞉ mo Ba꞉biloni kenke pa꞉ta꞉ hala꞉ ipika꞉ daoni teke A꞉e pa꞉ta꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Eipola꞉ma꞉ma꞉ta꞉ Sa꞉tai miekeme. Kutupa Neihota꞉ Hatanina꞉ waneke Milika miekeme. Hatani Isikana꞉ ateke yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sa꞉taita꞉ wekiwandiki mendia꞉peke na yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ditama꞉ta꞉ mo Ba꞉biloni kenke pa꞉ta꞉ hayeke daoni A꞉e mina꞉pa꞉lao ipika꞉ weki Eipola꞉ma꞉ make Hatanina꞉ eiyeke Loda make Eipola꞉ma꞉na꞉ weteke Sa꞉tai make hatuku mo Keinani kenke pa꞉ta꞉ polueke alo pemekepate ikita꞉ pa mo Hatani kenke pa꞉ta꞉ pua pitimikime. ");
INSERT INTO ssx_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Kutupa koto pa꞉ta꞉ haena꞉ta꞉ Ditata꞉ 205 bapi mieketa꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Mo Tekehalima꞉ Eipola꞉ma꞉ pa꞉ta꞉ alota꞉ Naka꞉ da kenke make naka꞉ tapake make naka꞉ apa꞉na꞉ da kenke make mina꞉pa꞉lao mo I̱ma꞉ walo polo kenke pa꞉ta꞉ pua꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","I̱ma꞉ta꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ wopu kiaata꞉ ikita꞉ tutu tieke halimikie. Neketa꞉ wamo peaasa꞉ hali halena꞉ yeke I̱ma꞉ neke epealueke laata꞉ naka꞉ biki kende tupa꞉ wina꞉ lolueke. ");
INSERT INTO ssx_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mo neke epealimi wanda꞉halita꞉ I̱ma꞉ epealo polopate. Mo neke pa꞉ta꞉ esihou pi lelimi wanda꞉halita꞉ kota꞉ I̱ma꞉ iki pa꞉ta꞉ esihou pi laalueke. Kutupa neke pa꞉ta꞉ yama꞉ta꞉ mo tutu ta꞉ta꞉ ta꞉ta꞉ paeyao epealueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Mo Eipola꞉ma꞉ ipiki bapi 75 mieketa꞉ mo hande Koda꞉ma꞉ leeke tupa꞉ Hatani da mina꞉pa꞉laeyekeme. Hande Loda make ipika꞉ yaapo peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Eipola꞉ma꞉ta꞉ weteke Sa꞉tai make hamekena꞉ eiyeke Loda꞉ make mo Hatani hata꞉ mimiki pa hameke e pokaasa꞉ wanda꞉hali make ala꞉ta꞉ ala꞉ta꞉ paeyao make mea mo Keinani kenke nane poluekema꞉ kini pea pemekeme. Kutupa mo Keinani kenke nane opolo pemeketa꞉ ");
INSERT INTO ssx_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Eipola꞉ma꞉ta꞉ ipika꞉ tapake ame̱le̱ mo kenke pa꞉ta꞉ pomu lopa mo yakopiki daoni bikita꞉ Sekeme opolo pemekeme. Koto pateta꞉ mo Motena꞉ biki wiki ti tieke hayekeme. Koto nate nina꞉ta꞉ mo Keinani wanda꞉halita꞉ koto kenke pa꞉ta꞉ pa haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mo Tekehalima꞉ Eipola꞉ma꞉ pa꞉ta꞉ opolo a꞉pa alota꞉ Do kenke tieke paeyaota꞉ I̱ma꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki pa꞉ta꞉ halo polo kenkee leekeme. Kutu piekena꞉ Eipola꞉ma꞉ma꞉ta꞉ mo ipiki pa꞉ta꞉ opolo peeke Tekehali Koda꞉ pa꞉ta꞉ koto pate oloda a꞉eyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kotoeki pea hoki naneta꞉ mo ka꞉wa꞉ nane pote eli wieke kenke mo Bedele daonina꞉ nate opa꞉la꞉ nanema꞉ tilao peekeme. Kutupa ipika꞉ palai data꞉ mo Bedelena꞉ nate pamba꞉la꞉ nane tilao mo Ai dana꞉ nate opa꞉la꞉ nanema꞉ tilao koto tukikina꞉ a꞉eyekeme. Koto pateta꞉ oloda ombu a꞉eyaata꞉ Tekehali pa꞉ta꞉ panda꞉ puniao yeiya꞉ layekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kutupa ipikita꞉ mo Keinani kenkena꞉ ka꞉wa꞉ nanema꞉ tilao da ma꞉nda꞉ ma꞉nda꞉ pa꞉ta꞉ pomu lopeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Pate koto Keinani kenke pa꞉ta꞉ta꞉ tea꞉ ki tieke epeeke handaa Eipola꞉ma꞉ma꞉ta꞉ ka꞉wa꞉ nanema꞉ papate leke puo pu hao mo Idiepi kenke pa꞉ta꞉ pa ta꞉ka꞉li halo peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kutupa ipiki mo Idiepi poluekema꞉ yu tombona꞉ pua hata꞉ ipika꞉ weteke Sa꞉tai pa꞉ta꞉ alota꞉ Neketa꞉ wanda꞉ seliapoe. ");
INSERT INTO ssx_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Koto ekina꞉ mo Idiepi haliwekima꞉ neke handolota꞉ neketa꞉ yaka wanda꞉ ya꞉ka꞉ta꞉me laa I̱ litolo hata꞉ neketa꞉ pa halena꞉ lelimikie. ");
INSERT INTO ssx_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kutu paama꞉na꞉ nakana꞉ma꞉ I̱ta꞉ yaka ana꞉e leka꞉na꞉ta꞉ kota꞉ I̱ta꞉ na liki pa epeke tupa꞉ hatuku halimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Koto eki laa mo yu tombo mina꞉pa꞉lao oni Idiepi kenke pa꞉ta꞉ pepeketa꞉ ota꞉ leeke tupa꞉ kone mo Idiepi haliwekima꞉ mo wanda꞉ta꞉ wanda꞉ seliapoe laa handemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kutupa mo kinina꞉ e pokaasa꞉ mandane kapomani haliwekima꞉ mo wanda꞉ handaata꞉ ipika꞉ seliapo piekeeki mo ika꞉ kini pa꞉ta꞉ pua lemekeme. Kutu pimiki mo wanda꞉ta꞉ ika꞉ kinina꞉ da pa꞉ta꞉ hatuku pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kutupa mo kinima꞉ta꞉ mo wanda꞉ mieke ekina꞉ Eipola꞉ma꞉ pa꞉ta꞉ta꞉ epeke hau pitolo hata꞉ sipisipi wopu make nanikosi wopu make kaomanu make donkimanu make pa hameke e pokaasa꞉ wanda꞉hali make kemelomanu make haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pate mo kinima꞉ Sa꞉tai mieke ekina꞉ta꞉ Tekehalima꞉ mo ipiki pa꞉ta꞉ make ipika꞉ da pa꞉ta꞉ haemeke wanda꞉hali pa꞉ta꞉ make ota꞉ hoke yeni kimanu yapena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kutu pieke mo kinima꞉ Eipola꞉ma꞉ epoe laa lota꞉ pitolo alota꞉ I̱ pa꞉ta꞉ dota꞉ ekipiki hau pelepe laata꞉ Do wanda꞉ta꞉ naka꞉ wanda꞉e laa I̱ta꞉ ekipeke na lakipe. ");
INSERT INTO ssx_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nakana꞉ma꞉ ekipeke ipikita꞉ naka꞉ ana꞉e le ekina꞉ I̱ma꞉ yaka wanda꞉ au lano laa pelepe. Naka꞉ wanda꞉ doma꞉ a̱i̱ hatuku pao pue leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Mo kinima꞉ ipika꞉ haliweki pa꞉ta꞉ Hatuku pupe leeke handaa mo haliwekima꞉ Eipola꞉ma꞉ make ipika꞉ wanda꞉ make ipika꞉ wia hayeke ala꞉ta꞉ ala꞉ta꞉ paeyao mea mo kenke mina꞉pa꞉lao pena꞉ hatuku pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Eipola꞉ma꞉ma꞉ ipika꞉ wanda꞉ make ipika꞉ wia hayeke ala꞉ta꞉ ala꞉ta꞉ paeyao make mea Idiepi mina꞉pa꞉lao Keinani kenkena꞉ ka꞉wa꞉ nanema꞉ tilao peekeme. Loda make mandakena꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Eipola꞉ma꞉ma꞉ta꞉ sipisipimanu make nanikosimanu make kaomanu make silipa make kolo make koto ale paeyaoma꞉ta꞉ hamoko hali tieke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kutupa koto pate mina꞉pa꞉laota꞉ kenke ma꞉nda꞉ ma꞉nda꞉ pa꞉ta꞉ pua mo Bedele nanema꞉ peekeme. Ipikita꞉ mo amba꞉ hande ipika꞉ palai da a꞉eyeke alena꞉ mo Bedele pita꞉ Ai yaapo tukikina꞉ ");
INSERT INTO ssx_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","mo hande oloda a꞉eyeke alena꞉ opolo peekeme. Koto pateta꞉ mo Tekehali pa꞉ta꞉ panda꞉puniao yeiya꞉ layekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lodata꞉ ipika꞉ wekiwanda꞉ make sipisipimanu make nanikosimanu make pa hameke e pokaasa꞉ wanda꞉hali make hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kutupa ipilikita꞉ ma꞉na꞉ hoteke wopu punupikieki yalo hata꞉ mo ipilika꞉ hoteke manuma꞉ napeke ambu opeeke kenketa꞉ wopu dia꞉ yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kutu piekeeki yalo hata꞉ mo Eipola꞉ma꞉na꞉ ma꞉na꞉ hotekemanu handeteke haemeke haliweki pita꞉ mo Lodana꞉ ma꞉na꞉ hotekemanu handeteke haemeke haliweki ika꞉ ika꞉ kone ape ape la꞉tiki pimikime. Koto nate nina꞉ta꞉ mo Keinani wanda꞉hali make Petese wanda꞉hali make pa haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kutu pieke handaata꞉ Eipola꞉ma꞉ma꞉ Loda pa꞉ta꞉ alota꞉ Dikita꞉ homeke tapake ya꞉la꞉ ekina꞉ naka꞉ haliweki pita꞉ yaka haliweki yaapoma꞉ta꞉ ape ape na lapeke alee. ");
INSERT INTO ssx_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Koto ekina꞉ta꞉ kota꞉ ka꞉ta꞉alu pupana꞉ma꞉ naka꞉ hone pa꞉la꞉ kenke ma̱leke lia neke mandanema꞉ pekena꞉ kota꞉ I̱ta꞉ mandanema꞉ poluekema꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Koto leeke Lodama꞉ mo Diodani hawete handoma꞉ handoma꞉ putia pua mo Soa pua hando naeyekepate oni kenketa꞉ mo hande Tekehalina꞉ e o mo Idiepi kenkema꞉ handaa ikali wopu yapeekeeki handeekeme. Dota꞉ mo Tekehalima꞉ mo Sodomo pita꞉ Komoto daoni yaapo a̱i̱ na hoeyake haena꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Koto ekina꞉ Lodama꞉ta꞉ mo Diodani hawete tieke ipika꞉ekie laa ma̱leke liaata꞉ mo nate opa꞉la꞉ nanema꞉ tilao peekeme. Kotota꞉ mo hande hali yaapona꞉ ka꞉ta꞉alu pipiki tupa꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Eipola꞉ma꞉ta꞉ Keinani kenke pa꞉ta꞉ haena꞉ta꞉ Lodata꞉ mo hawetena꞉ hayeke daonimanu pa꞉ta꞉ pita꞉tia pominolota꞉ mo Sodomo nanema꞉ ipika꞉ palai da a꞉eya pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Koto pa꞉ta꞉ haemeke wanda꞉halita꞉ hoke wanda꞉hali hata꞉ make mo Tekehali pa꞉ta꞉ hoke hau pu haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Mo Loda pea꞉ hoki nane Tekehalima꞉ Eipola꞉ma꞉ pa꞉ta꞉ alota꞉ Koto neke hale alena꞉ hata꞉ta꞉ mo tea꞉ paeyao siki epeke tupa꞉ handa꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Koto handeleeki paeyaota꞉ neke pa꞉ta꞉ make naka꞉ monduma꞉ monduma꞉ pilipi wanda꞉wekina꞉ wanda꞉weki pa꞉ta꞉ make I̱ma꞉ kulu polo kenkee. Kutupa koto kenketa꞉ hoto paeyao naka꞉eki utia pu halieke. ");
INSERT INTO ssx_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","I̱ma꞉ta꞉ ma꞉nda꞉ma꞉ na yata꞉pa꞉ ta꞉palo pa꞉la꞉ tupa꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ wopu kulueke. Ma꞉nda꞉ma꞉ do kenkena꞉ ula꞉ dokolo yata꞉pa꞉ ta꞉paya꞉ka꞉na꞉ta꞉ kota꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki make yata꞉pa꞉ ta꞉paena꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Koto pa꞉la꞉ma꞉ I̱ma꞉ do kenke neke kulu polo ekina꞉ mo kenke paeyao pua hando wie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Koto leeke Eipola꞉ma꞉ma꞉ ipika꞉ palai da yoka꞉moneaota꞉ mo Hebotoni hali Ma꞉motena꞉ timanu tekepa꞉ta꞉ leke pua pita꞉ koto pateta꞉ Tekehali pa꞉ta꞉ oloda a꞉eyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kini haliweki tonkoputa꞉ mo Ba꞉bilonina꞉ kini A꞉motapele make A꞉lasana꞉ kini A꞉tioko make Ila꞉mena꞉ kini Siedolaoma make Koimina꞉ kini Taedolo make mo ");
INSERT INTO ssx_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","mandane yunki hata꞉ kinita꞉ mo Sodomona꞉ kini Bita make mo Komotona꞉ kini Biesa make mo A꞉demana꞉ kini Sina꞉be make mo Seboimina꞉ kini Semebe make mo Bela biki ma꞉nda꞉ Soana꞉ kini ame̱le̱ a꞉nda꞉ pulu pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Do yunki hata꞉ kini manuma꞉ta꞉ mo Sidimi hawetena꞉ ameta꞉ mo ikali leke ma꞉nda꞉ biki Homa꞉la꞉ dawala leleme alena꞉ ika꞉ ami haliweki momba꞉laemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ikita꞉ 12 bapina꞉ta꞉ hande kini Siedolaoma oto pa꞉ta꞉ haemekepate pa mo bapi 13 pa꞉ta꞉ta꞉ ipiki oto pa꞉ta꞉ na halumeke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kutupa mo bapi 14 pa꞉ta꞉ta꞉ Siedolaoma ipika꞉ tamba꞉ mina꞉la꞉ kinimanu tonka꞉na꞉ ika꞉ ami haliweki ame̱le̱ mo A꞉sa꞉detodi Kanaimi kenke pa꞉ta꞉ haleme Tepa꞉imi wanda꞉hali make mo Ha꞉mi kenke pa꞉ta꞉ haleme Susimi tapake make mo homeke hau honda꞉ lupa peeke Kitia꞉tieimi kenke pa꞉ta꞉ haleme Emimi tapake make ");
INSERT INTO ssx_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","mo Idomo pote pa꞉ta꞉manu haleme Ho tapake make ota꞉ lu yombitolo hata꞉ mo Elepa꞉tani kenkena꞉ mo hapu papeke ale honikina꞉ pua tolu naemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kutupa paa mo Keidese kenke amba꞉ta꞉ Enemisipade leeke alena꞉ la꞉ka꞉la epemekeme. Ikana꞉ma꞉ta꞉ mo A꞉ma꞉leke wanda꞉hali bepolaota꞉ mo Hasasono Teima kenke pa꞉ta꞉ haemeke A꞉mo wanda꞉hali make bepolaemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kutu pieke mo Sodomo make Komoto make A꞉dema make Seboimi make Bela make koto da kini manuma꞉ta꞉ a꞉nda꞉ puluekema꞉ ika꞉ ami haliwekimanu mo Sidimi hawetena꞉ momba꞉laota꞉ mo ");
INSERT INTO ssx_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ila꞉me make Koimi make Ba꞉biloni make Elasa make koto tonkopu dana꞉ kinimanu ame̱le̱ mo yunki hata꞉ dana꞉ kini manuma꞉ a꞉nda꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Koto hawetena꞉ta꞉ kolodama꞉ wepiki naku manuma꞉ tumbieke ekiyalo mo Sodomo Komoto da yaapona꞉ kini yaapota꞉ mo a꞉nda꞉na꞉ pindipa polueke alo pepekepate koto naku pa꞉ta꞉ pua lopepekeme. Pate mo pa haemeke kini tepota꞉ mo pote pa꞉ta꞉manu pindipa pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kota꞉ mo kini tonkopuma꞉ta꞉ mo Sodomo Komoto daoni yaapo pa꞉ta꞉ wieke ale paeyao make nemanu tonka꞉na꞉ mea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Kutupa make Eipola꞉ma꞉na꞉ hamekena꞉ eiyeke Lodata꞉ koto Sodomo daoni pa꞉ta꞉ hayeke ekiyalo ipiki make ipika꞉ ala꞉ta꞉ ala꞉ta꞉ tonka꞉na꞉ mea hatuku pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Pate hali homeke ma꞉nda꞉ta꞉ pindipa pua mo A꞉mo tapake hali Ma꞉motena꞉ timanu hayeke ale nanema꞉ hayeke Hibulu hali Eipola꞉ma꞉ pa꞉ta꞉ a꞉pa mo koto haumanu la haleekeme. Ma꞉mote make ipika꞉ kame yaapo Esikolo pita꞉ A꞉na꞉ maketa꞉ Eipola꞉ma꞉na꞉ tamba꞉ mina꞉la꞉ haliweki haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kutupa Eipola꞉ma꞉ ipika꞉ kamena꞉ eiyeke hatuku pemekeeki opu haota꞉ ipika꞉ a꞉nda꞉na꞉ moka꞉la hando haemeke 318 haliweki momba꞉lao mo hande kini tonkopu telia꞉ mea pua ota꞉ mo Da꞉ni kenke pa꞉ta꞉ tolu lopalo pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Koto pateta꞉ ipika꞉ haliweki putupa꞉ putupa꞉ pea momba꞉lao haena꞉ loma loma peaata꞉ koto timba hata꞉ mo a꞉nda꞉ tunkuliki tapake lia bepolaemekeme. Ipikana꞉ma꞉ta꞉ mo haliwekita꞉ mo Damasikasina꞉ okane nanema꞉ tilao ota꞉ mo Hoba pua tolu lutia pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kutupa mo mea pemeke ala꞉ta꞉ ala꞉ta꞉ paeyao pa petolo mimikime. Kutupa make mo ipika꞉ kamena꞉ eiyeke Loda make ipika꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao make wanda꞉weki make mo mandane dipula mea pemeke wanda꞉hali make paa hatuku epemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Eipola꞉ma꞉ta꞉ mo Siedolaoma make mo mandane kinimanu ame̱le̱ a꞉nda꞉ pea bepolao epeeketa꞉ mo Sodomona꞉ kinima꞉ta꞉ mo Sape hawetena꞉ biki ma꞉nda꞉ Kinina꞉ hawete la꞉la꞉ alena꞉ manda꞉hande pulu peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kutupa mo Seilimina꞉ kini pita꞉ mo Manda Hala꞉ Koda꞉na꞉ yeni peao hala꞉ hali Melekisedekema꞉ta꞉ Eipola꞉ma꞉ pa꞉ta꞉ betedi make waini ikali make mea a꞉paeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Kutupa epeaasa꞉ pi alo alota꞉ Mo kenke ya yaapo wa꞉pa꞉la꞉ Manda Hala꞉ Koda꞉ma꞉ Eipola꞉ma꞉ epeaena꞉e laata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Mo naka꞉ a꞉nda꞉ tunkuliki haliweki bepolaena꞉ lea꞉ Manda Hala꞉ Koda꞉na꞉ biki mina꞉liamana꞉e leekeme. Kutupa Eipola꞉ma꞉ma꞉ta꞉ mo mia꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao telipa kiki yaapo yeketa꞉ homeke ma꞉nda꞉ta꞉ Melekisedeke pa꞉ta꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Kutu pieke hoki nane mo hande Sodomo kinima꞉ Eipola꞉ma꞉ pa꞉ta꞉ alota꞉ Mo mi ala꞉ta꞉ ala꞉ta꞉ paeyaota꞉ wia halo pelepate yaka wanda꞉hali homeke kie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Eipola꞉ma꞉ma꞉ hombo peaaso alota꞉ Do kenke ya yaapo wa꞉pa꞉la꞉ Tekehali oli Manda Hala꞉ Koda꞉na꞉ biki aloma꞉ ");
INSERT INTO ssx_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","I̱ma꞉ta꞉ neke pepeleke ala꞉ta꞉ ma꞉nda꞉ siki make ota꞉ na wia halueke laata꞉ Ota꞉ mo kodoni pu kone o anke dake pu tunkuliki kone loa꞉me. Kota꞉ mo nakana꞉ma꞉ alota꞉ I̱ma꞉ Eipola꞉ma꞉ mea hamoko yawa꞉ma꞉ pi na loelena꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Koto ekina꞉ I̱ma꞉ta꞉ ala꞉ta꞉ ma꞉nda꞉ na mulu polopate mo yaka haliwekima꞉ amba꞉ nemeke alemanu homeke mulueke. Kutupa make do I̱ tamba꞉ ma꞉la꞉ hali tepo A꞉na꞉ make Esikolo make Ma꞉mote ika꞉ putupiliki homeke mina꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Do haumanu hoki naneta꞉ Eipola꞉ma꞉ma꞉ upa piki nono pea Koda꞉ma꞉ ipiki pa꞉ta꞉ dupa leekeeki opiekeme. Eipola꞉ma꞉o. Paala꞉ma꞉ na homa꞉pee. I̱ma꞉ta꞉ mo ekia꞉nda꞉ pilia꞉ pa꞉ta꞉ta꞉ I̱ta꞉ ota꞉ naka꞉ hanka꞉ tupa꞉ hata꞉ neke pa꞉ta꞉ta꞉ yenki tieke kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Pate Eipola꞉ma꞉ma꞉ alota꞉ Tekehali Koda꞉o. Mo I̱ta꞉ wekiwandiki make dia꞉me. Kota꞉ pa ekipa epeke yenki kilipikipe. Yaka anke teke mulu pa꞉la꞉ halita꞉ mo Damasikasi hali Eliesa homeke hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Nakana꞉ma꞉ I̱ta꞉ wekiwandiki ma꞉nda꞉ na kele ekina꞉ mo yaka pa hameke e pokaasa꞉ some ma꞉nda꞉ma꞉ yaka anke teke milieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kutupa Tekehalima꞉ ipiki pa꞉ta꞉ pi paa leekeeki dupa opiekeme. Do pa hameke e pokaasa꞉ some Eliesama꞉ naka꞉ anketeke na mulu pa꞉la꞉pate ota꞉ naka꞉ wekima꞉ milieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kutupa mo Tekehalima꞉ ipiki hama hatuku pua alota꞉ Oli ya nane handa꞉liao oli hombulanka꞉manu yata꞉pa꞉ handa꞉e. Nakana꞉ma꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ oli hombulanka꞉ manuma꞉ handilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Koto ekina꞉ Eipola꞉ma꞉ma꞉ Tekehali pa꞉ta꞉ hone tulaeyeke ekiyalo mo Tekehalima꞉ta꞉ ipikita꞉ tikitiki piki halie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kutu pa mo Tekehalima꞉ ipiki pa꞉ta꞉ alota꞉ I̱ma꞉ta꞉ do kenke neke muelena꞉yeke neke mo Ba꞉biloni kenke pa꞉ta꞉ hala꞉ daoni A꞉e mina꞉pa꞉lao hatuku epoa꞉ Tekehalie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Pate Eipola꞉ma꞉ma꞉ lota꞉ pitolo alota꞉ Tekehali Koda꞉o. I̱ma꞉ ota꞉ yaka kenke laata꞉ Ekipa hone wionope leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Tekehalima꞉ hombo peaaso alota꞉ Mo bapi tepo paeke kao make nanikosi make sipisipi halieki make mea kutupa melipu make dokolo make mea epoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Koto leeke Eipola꞉ma꞉ma꞉ta꞉ mo hotekemanu Koda꞉ pa꞉ta꞉ mea a꞉pa tukikina꞉ hala꞉pa꞉la꞉tiki pea mandaneta꞉ tombo ma꞉nda꞉na꞉ wiatiki mandaneta꞉ tombo ma꞉nda꞉na꞉ wiatiki pea hoki tuna tuna pea wina꞉ leekepate mo ba yaapota꞉ na halepeleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Mo hoteke manuta꞉ mo Idama꞉ handeke ba manuma꞉ noluekema꞉ epemekepate Eipola꞉ma꞉ma꞉ tolu lia꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Nate oni pambolo pulu haena꞉ta꞉ Eipola꞉ma꞉ta꞉ u̱ yoka꞉lupa puaata꞉ paala꞉ pita꞉la꞉eki pita꞉ pututu pita꞉la꞉eki yaapo ipiki pa꞉ta꞉ epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kutupa mo Tekehalima꞉ ipiki pa꞉ta꞉ alota꞉ Naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ mo ma꞉nda꞉na꞉ kenkena꞉ pua hata꞉ta꞉ leke popeleke na handeke tapake leke halimikie. Ikita꞉ koto pa꞉ta꞉ta꞉ pa pa hameke e pokaasa꞉ tapake hata꞉ 400 bapina꞉ta꞉ ota꞉ hoke tupa꞉ handeteke halimikie. ");
INSERT INTO ssx_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Pate kutu pilia꞉ tapaketa꞉ I̱ma꞉ ka꞉nda꞉ halo polopate mo naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikita꞉ koto kenke mina꞉pa꞉lao pemeka꞉na꞉ta꞉ ala꞉ta꞉ ala꞉ta꞉ tieke mea pelimikie. ");
INSERT INTO ssx_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Neketa꞉ koke yaa pita yopu homupea homeka꞉na꞉ta꞉ kota꞉ mea hoilimikie. ");
INSERT INTO ssx_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","I̱ma꞉ta꞉ do kenkena꞉ haleme A꞉mo tapake wanda꞉hali a̱i̱ na tolu liki pa haota꞉ ika꞉ hoke hau tieke piteleme ekina꞉ ka꞉nda꞉ halua꞉ dina꞉ta꞉ mo naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ mei tonkopu mia꞉ka꞉na꞉ta꞉ do pate paa la꞉ka꞉la ipilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Mo nate oni pambolo pua timba꞉ leeketa꞉ mo lumu opolo hake itika꞉pei pita꞉ talo talo hake ola꞉pake yaapoma꞉ a꞉pa mo hotekemanu wieke ale tukiki pa꞉ta꞉ yama꞉ yapeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Kutupa koto pate koneta꞉ Tekehalima꞉ Eipola꞉ma꞉ yaapo pi la꞉ witolo alota꞉ I̱ma꞉ do yata꞉polo kenke paeyaota꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki pa꞉ta꞉ halueke laa pi la꞉ witolome. Oni Idiepi yu tombona꞉ kini pea pua mo Yupoteitisi ikali puata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","mo Keni wanda꞉halina꞉ kenke make Kenisi wanda꞉halina꞉ kenke make Kadomono wanda꞉halina꞉ kenke make mo ");
INSERT INTO ssx_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hidi wanda꞉halina꞉ kenke make Petese wanda꞉halina꞉ kenke make mo Tepa꞉imi wanda꞉halina꞉ kenke make ");
INSERT INTO ssx_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","mo A꞉mo wanda꞉halina꞉ kenke make Keinani wanda꞉halina꞉ kenke make Keakasi wanda꞉halina꞉ kenke make mo Diebusi wanda꞉halina꞉ kenke make paeyao halueke laa loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Eipola꞉ma꞉na꞉ weteke Sa꞉taima꞉ta꞉ weki ma꞉nda꞉ na mendiaeyekeme. Pate ipikana꞉ma꞉ta꞉ pa hameke e pokaasa꞉ Idiepi wandiki biki Heika hatuku hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Koto ekina꞉ Sa꞉taima꞉ Eipola꞉ma꞉ pa꞉ta꞉ alota꞉ Mo Tekehalima꞉ I̱ weki na mendiono ala꞉ ekina꞉ mo yaka pa hameke e pokaasa꞉ wandiki yaapo pelia꞉peke na ya꞉la꞉pe. Kutu pika꞉na꞉ta꞉ ipikana꞉ma꞉ yaka weki mendiaena꞉ loa꞉me leekeme. Koto leeke Eipola꞉ma꞉ma꞉ta꞉ Sa꞉taima꞉ leeke pina꞉ta꞉ a꞉pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Koto ekina꞉ Heikata꞉ ipika꞉ yaapo peao wanda꞉ haena꞉ Sa꞉taima꞉ haliki haleekeme. Do hau piki hauta꞉ Eipola꞉ma꞉ta꞉ Keinani kenke pa꞉ta꞉ kiki yaapo bapi haena꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Kutupa Eipola꞉ma꞉ma꞉ Heika yaapo pelia mo wandikita꞉ weki pitiekeme. Mo wandikima꞉ ipiki weki weleke hayekeeki handolota꞉ hakoko yamo baaso hata꞉ Sa꞉tai lu pambaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kutu pieke Sa꞉taima꞉ Eipola꞉ma꞉ pa꞉ta꞉ alota꞉ Heikama꞉ I̱ lu pambaasa꞉ ekita꞉ naka꞉ ka꞉ta꞉ta꞉e. I̱ma꞉ kone ipiki neke pa꞉ta꞉ ku hao ipiki weki weleke haya꞉eki hando haota꞉ I̱ lu pambaasa꞉me. Koto ekina꞉ diki ma꞉nda꞉ hondo tikitiki polopa꞉me laata꞉ Koda꞉ ipika꞉ lena꞉e laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Eipola꞉ma꞉ma꞉ hombo peaaso alota꞉ Kota꞉ a꞉pa꞉la꞉ma꞉ mo wandikita꞉ naka꞉ pa hameke e pokaasa꞉ wandiki yalo neke oto pa꞉ta꞉ hala꞉me. Naka꞉ hone pa꞉la꞉eki pie leekeme. Koto ekina꞉ Sa꞉taima꞉ta꞉ Heika hoke tupa꞉ handeteke hayeke handaa pao pindipa peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mo Tekehalina꞉ enisoloma꞉ta꞉ Heika oni Sia꞉e nane pula꞉ pota꞉na꞉ hapupapeke alena꞉ tunkulu pa pitieke ikali tea꞉na꞉ manda꞉hande piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kutupa alota꞉ Sa꞉taina꞉ pa hameke e pokaaso wanda꞉ Heikao. Neketa꞉ hanema꞉ a꞉pa pelepe laata꞉ hane pulipe leekeme. Heikama꞉ hombo peaaso alota꞉ Ya handeteke hala꞉ wanda꞉ kiao pindipa pulume leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mo enisoloma꞉ alota꞉ Pao la꞉ka꞉la pua ipika꞉ pa hameke e pokaasa꞉ wanda꞉ hapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kutupa paa alota꞉ I̱ma꞉ta꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ ma꞉nda꞉ma꞉ na yata꞉polo pa꞉la꞉ tupa꞉ wopu kulueke. ");
INSERT INTO ssx_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Neketa꞉ hali weki mendilipikima꞉ ipika꞉ bikita꞉ Isima꞉elo lapeke. Pa ekipeke mo Tekehalima꞉ta꞉ naka꞉ ka꞉nda꞉ma꞉ homolo e̱ leleeki opa꞉la꞉ ekina꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Pate naka꞉ wekita꞉ mo sayale au la꞉la꞉ donkima꞉ handaa ipikita꞉ paeyao pa꞉ta꞉ a꞉nda꞉ tunkulaa hata꞉ paeyaoma꞉ta꞉ ipiki pa꞉ta꞉ a꞉nda꞉ tunkulimikie. Kutupa ipikita꞉ yankeke paeyao ame̱le̱ na hao peliki ta꞉ta꞉ halieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Heikama꞉ ipika꞉ kone lota꞉ pitolo alota꞉ I̱ma꞉ta꞉ Koda꞉ ota꞉ handolo hata꞉ doeki la haluekema꞉ pa hao polope laa leekeme. Koto ekina꞉ mo ipiki pa꞉ta꞉ pi la halea꞉ Tekehalita꞉ Hando Hala꞉ Koda꞉e laa ipika꞉ biki kini pea taapa꞉ wiayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Koto ekina꞉ wanda꞉halima꞉ mo Keidese hao mo Betede tukikina꞉ ula꞉ naku ikalita꞉ Mo I̱ Handa꞉la꞉ Pa Hao Hala꞉ Halina꞉ Naku Ikalie lelememe. ");
INSERT INTO ssx_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Heikama꞉ta꞉ Eipola꞉ma꞉na꞉ weki mendiaeyeketa꞉ Isima꞉elo leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Koto dina꞉ta꞉ Eipola꞉ma꞉ta꞉ bapi 86 yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Eipola꞉ma꞉ 99 bapi mieketa꞉ mo Tekehali opolo pua alota꞉ I̱ta꞉ Aneke Wele wopupiki Koda꞉ halome. I̱ma꞉ alo pi opua hoto paeyao tikitiki hau homeke pea꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","I̱ma꞉ta꞉ neke yaapo yaka pi la꞉ wiaata꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ wopu kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Koto leeke Eipola꞉ma꞉ta꞉ you panda꞉puniao ipika꞉ popeleketa꞉ oni yu wataeyeke handaa Koda꞉ma꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","I̱ma꞉ neke yaapo do pi la꞉ witolome. I̱ma꞉ pi la꞉ witolota꞉ neketa꞉ tutu paeyao sikina꞉ apa꞉mei halipikie. ");
INSERT INTO ssx_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Naka꞉ bikita꞉ Eipola꞉ma꞉ dia꞉yalo ameta꞉ Eipoloha꞉ma꞉e. Pa ekipeke neketa꞉ tutu paeyaona꞉ apa꞉mei hawaasome. ");
INSERT INTO ssx_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","I̱ma꞉ta꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki tieke kua꞉ka꞉na꞉ta꞉ kota꞉ mandaneta꞉ kinimanu pitilimikie. Nakana꞉ma꞉ta꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ tieke kua꞉ka꞉na꞉ta꞉ kota꞉ tutu ta꞉ta꞉ ta꞉ta꞉ halimikie. ");
INSERT INTO ssx_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","I̱ma꞉ta꞉ neke pa꞉ta꞉ make naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikina꞉ tapake pa꞉ta꞉ maketa꞉ do la꞉ witolo pita꞉ ota꞉ na paeke pa u halo pa꞉la꞉ pi la꞉ witolome. I̱ta꞉ naka꞉ Koda꞉ make naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikina꞉ Koda꞉ make halueke. ");
INSERT INTO ssx_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ame do neketa꞉ da ma꞉nda꞉ hali leke hale kenketa꞉ neke pa꞉ta꞉ make kia naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki pa꞉ta꞉ make halueke. Do Keinani kenke paeyaota꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki pa꞉ta꞉ ota꞉ hoto paeyao ika꞉ ekie la halaata꞉ I̱ta꞉ ika꞉ Koda꞉ halueke. ");
INSERT INTO ssx_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Koda꞉ma꞉ Eipoloha꞉ma꞉ pa꞉ta꞉ alota꞉ Nakana꞉ma꞉ make naka꞉ wetepe nina꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikima꞉ maketa꞉ I̱ ame̱le̱ do pi la꞉ witolo ekita꞉ ota꞉ wia halumeke laa lapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nakana꞉ma꞉ make naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikima꞉ make ika꞉ hali weki paeyaota꞉ sekemesaisi hau ota꞉ pulumeke laa lapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Ame do kini pea puluta꞉ ika꞉ hali weki mondu wia pitina꞉ hoto ketepo hata꞉ paeya꞉ka꞉na꞉ta꞉ kota꞉ sekemesaisi hau peapa꞉peke. Kutupa mo iki haleme da pa꞉ta꞉ mendilimi pa hameke e pokaasa꞉ wanda꞉halina꞉ hali weki make mo kenke ma꞉nda꞉na꞉ hamba꞉la꞉ pa hameke e pokaasa꞉ haliweki make sekemesaisi hau peapa꞉peke. Do hauma꞉ta꞉ neke I̱ dika꞉ pi la꞉ witolopa꞉eki peneme yao walieke. ");
INSERT INTO ssx_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Hali paeyao sikita꞉ sekemesaisi hau peapeke ya꞉la꞉me. Kutupa do manda lokena꞉ pitoloma꞉ ekita꞉ mo na paeke pa u halo pa꞉la꞉ pi la꞉ witolo ekina꞉ patehau pitoloeki walieke. ");
INSERT INTO ssx_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Koto pa꞉la꞉pate iki ma꞉nda꞉ epi sekemesaisi hau na pia꞉ka꞉na꞉ta꞉ kota꞉ Ya tapakee pi na lolueke. Pa ekipeke ipikana꞉ma꞉ta꞉ yaka pi la꞉ ulueki na wia haleke loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Koda꞉ma꞉ Eipoloha꞉ma꞉ pa꞉ta꞉ alota꞉ Naka꞉ wanda꞉ta꞉ Sa꞉tai pi paa na lapeke. Ame do kini peata꞉ Seta lapeke. ");
INSERT INTO ssx_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","I̱ma꞉ta꞉ ipiki epeao make ipiki pa꞉ta꞉ yama꞉ naka꞉ weki kulueke. I̱ma꞉ta꞉ ipiki epeao make ipikita꞉ mandane tutuna꞉ inkiki halieke. Kutupa ipika꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandiki tukiki pa꞉ta꞉ta꞉ kinimanu halimikie. ");
INSERT INTO ssx_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Koto leeke Eipoloha꞉ma꞉ta꞉ you panda꞉puniao ipika꞉ leke popeleketa꞉ oni yu wataena꞉ leekepate ipika꞉ honema꞉ta꞉ halima꞉ ipikita꞉ 100 bapi ya꞉na꞉ kone weki mendia꞉peke ya꞉la꞉pe laa kutupa Setata꞉ 90 bapina꞉ weki mendia꞉peke ya꞉la꞉pe laa ipika꞉ honema꞉ kone ki teekeme. ");
INSERT INTO ssx_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kutupa ipikana꞉ma꞉ Koda꞉ pa꞉ta꞉ lota꞉ pitolo alota꞉ Pa ekipeke Isima꞉eloma꞉ yaka anketeke na mina꞉ alepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Pate Koda꞉ma꞉ alota꞉ Dia꞉me. Naka꞉ wanda꞉ Setama꞉ naka꞉ weki mendiaeya꞉ka꞉na꞉ta꞉ ipika꞉ bikita꞉ Aisa꞉ke lelipikie. I̱ma꞉ta꞉ ipiki make ipika꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandiki ame̱le̱ make hoto paeyao yaka pi la꞉ witoloeki pa wia halumeke. Koto pi la꞉ witolo ekita꞉ ota꞉ na paeke pa u halo pa꞉la꞉ekie. ");
INSERT INTO ssx_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","I̱ma꞉ta꞉ mo nakana꞉ma꞉ Isima꞉elona꞉ honke leeki opua꞉me. Koto ekina꞉ I̱ma꞉ta꞉ ipiki epeaota꞉ wekiwandiki wopu halaa ipika꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandiki make wopu halueke. Ipikita꞉ 12 you haliweki tonuna꞉ ateke haota꞉ kutupa ipika꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandikita꞉ tutu tieke hawalueke. ");
INSERT INTO ssx_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pate I̱ma꞉ta꞉ naka꞉ weki Aisa꞉ke yaapo yaka pi la꞉ witoloeki miniki halueke. Ipikita꞉ do homeke natena꞉ kone mo bapina꞉ Setama꞉ mendilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kutupa Koda꞉ ipiki Eipoloha꞉ma꞉ yaapo pi lo paeyaota꞉ ipiki mina꞉pa꞉lao peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Koto homeke natena꞉ kone Eipoloha꞉ma꞉ma꞉ Koda꞉na꞉ pi opuata꞉ ipika꞉ weki Isima꞉elo make mo ipika꞉ da pa꞉ta꞉ haemeke haliwekimanu make apa꞉tao mo ipika꞉ da kenke pa꞉ta꞉ haemeke pa hameke e pokaemeke wanda꞉halina꞉ eiyeke tonu make mo hambeeke haliweki paeyao siki make sekemesaisi hau peayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Eipoloha꞉ma꞉ ipikita꞉ 99 bapina꞉ sekemesaisi hau piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Kutupa ipika꞉ weki Isima꞉elota꞉ 13 bapina꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ipilikita꞉ mo homeke natena꞉ sekemesaisi hau pipikime. ");
INSERT INTO ssx_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Kutupa ipika꞉ pa hameke e pokaemeke haliweki make mandakena꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Tekehalita꞉ mo Ma꞉motena꞉ timanu tekena꞉ Eipoloha꞉ma꞉ pa꞉ta꞉ opolo peekeme. Eipoloha꞉ma꞉ta꞉ nate ota꞉ titipu tieke pieke dina꞉ ipika꞉ palai da pota꞉ kake pa꞉ta꞉ pita꞉ ");
INSERT INTO ssx_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","handa꞉ liaeyekepate tepo hali haemekeeki handeekeme. Mo handea꞉ dina꞉ kone pototo la pua mo haliweki manda꞉hande piekeme. Kutupa ipika꞉ leke popeleketa꞉ oni yu wataena꞉ alo hata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","alota꞉ Haliwekio. Yaka da pa꞉ta꞉ hoto na pitiki pa na lombei pea꞉pa꞉peke. I̱ta꞉ iki tamba꞉ muluekema꞉ halome. ");
INSERT INTO ssx_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Koto ekina꞉ ika꞉ ankemanu tanda꞉pa do ti teke pa꞉ta꞉ hoto pitomena꞉ ikali mealo ponoe. ");
INSERT INTO ssx_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Kutupa make mo ika꞉ pota꞉ pelimi ale pa꞉ta꞉manu honkopu hamina꞉ ne siki make mea a꞉palueke. Ikana꞉ma꞉ta꞉ yaka da pa꞉ta꞉ epeleme ekita꞉ I̱ ta꞉na꞉ homa꞉tiaasa꞉ hau pelememe. Koto ekina꞉ta꞉ I̱ma꞉ iki tamba꞉ mionoe leekeme. Kutupa ikana꞉ma꞉ hombo peaaso alota꞉ Ota꞉ a꞉pa꞉la꞉me laa keiyae lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Koto ekina꞉ Eipoloha꞉ma꞉ta꞉ ipupula mo palai da pa꞉ta꞉ pua Seta pa꞉ta꞉ alota꞉ Naka꞉ ta꞉ta꞉ ma꞉nda꞉ wili palaowa tepo a꞉nda꞉ mea a̱i̱ betedi wepie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Koto laa ipikita꞉ oni kao banisi pa꞉ta꞉ pua loke panka wiki panake kao ikiki mea ipika꞉ e pokaasa꞉ hali ma꞉nda꞉ pa꞉ta꞉ haleekeme. Kutupa mo halima꞉ta꞉ ipupula pua yankeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kutupa yankeketa꞉ Eipoloha꞉ma꞉ mo kao andu pankeke manda wita꞉la꞉ epeke imekema꞉ handeke ale make ota꞉ kao andu pankeke make mo hande hoteke make mea pua mo haliweki pitieke alena꞉ pua wiekeme. Koto ti teke pa꞉ta꞉ta꞉ ipikana꞉ma꞉ mo haliweki ne pana꞉ peaota꞉ nena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Kutupa mo haliwekima꞉ lota꞉ pitolo alota꞉ Naka꞉ wanda꞉ Setata꞉ hande pa꞉la꞉pe lemekeme. Eipoloha꞉ma꞉ma꞉ hombo peaaso alota꞉ Oni palai da pa꞉ta꞉ pila꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Hali homeke ma꞉nda꞉ma꞉ alota꞉ Ame do kini pea kaisepo kiki homekena꞉ mandane ekina꞉ tonkopuna꞉ta꞉ I̱ paa epoa꞉ka꞉na꞉ta꞉ kota꞉ naka꞉ wanda꞉ Setata꞉ weki mendilieke leekeme. Setata꞉ mo halikina꞉ hoki nane mo palai da pota꞉ kake pa꞉ta꞉ hata꞉ opiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Eipoloha꞉ma꞉ pita꞉ Seta yaapota꞉ ota꞉ koke yepekeme. Kutupa Setata꞉ ipika꞉ kaisepo da handeekeeki make paeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Koto ekina꞉ Setama꞉ta꞉ ipika꞉ onina꞉ toluma꞉ ki talo hata꞉ alota꞉ Ameta꞉ I̱ make yaka haliki make koke yalo hata꞉ honkopu paela꞉me. Ekipa ta꞉na꞉ma꞉ homolo hata꞉ loke paa apa꞉talupa꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Koto ekina꞉ mo Tekehalima꞉ Eipoloha꞉ma꞉ pa꞉ta꞉ lota꞉ pitolo alota꞉ Ekipeke Setama꞉ ki talo hata꞉ ipikita꞉ ota꞉ koke yolome ekipa weki mondulua꞉pe ala꞉pe. ");
INSERT INTO ssx_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Koto mo Tekehalima꞉ na pea꞉peke ya꞉la꞉ hau ma꞉nda꞉ ula꞉pe. Amba꞉ mo loa꞉ handa꞉e. Ame do kini pea kaisepo kiki homekena꞉ mandane ekina꞉ tonkopuna꞉ta꞉ I̱ paa epoa꞉ka꞉na꞉ta꞉ Setama꞉ weki mendilieke laa loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Kotoeki leeke Seta ipikita꞉ paala꞉ pieke handa honiolo hata꞉ alota꞉ Ki na toa꞉me leekepate Tekehalima꞉ hombo peaaso alota꞉ Dia꞉me. Nakana꞉ma꞉ ki temee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kutupa mo hali wekita꞉ mina꞉pa꞉lao mo Sodomo da handa꞉nialo pimiki alena꞉ pemeke handaa Eipoloha꞉ma꞉ta꞉ mo pota꞉na꞉ a꞉talo lo tapaaluekema꞉ mandakena꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Kutupa mo Tekehalima꞉ ipika꞉ onina꞉ toluma꞉ alota꞉ I̱ma꞉ pulu polo ekita꞉ Eipoloha꞉ma꞉ pa꞉ta꞉ na a꞉mbalueke. ");
INSERT INTO ssx_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ipika꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandikita꞉ honkopu wopu hake tutu tieke halieke. Kutupa make ipiki pa꞉ta꞉ yama꞉ta꞉ mo tutu paeyao epealueke. ");
INSERT INTO ssx_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","I̱ma꞉ta꞉ ipikana꞉ma꞉ ipika꞉ weki titi make ipika꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandiki pa꞉ta꞉ make I̱ pa꞉ta꞉ homu pea tikitiki hau make ota꞉ hau make ota꞉ pia꞉pa꞉peke laa la halena꞉yeke ipiki ma̱leke lulume. Ikana꞉ma꞉ kutu pimika꞉na꞉ta꞉ kota꞉ I̱ma꞉ mo ipiki pa꞉ta꞉ pi la꞉ ua꞉ tupa꞉ hau paeyao peawalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Koto hone wia mo Tekehalima꞉ Eipoloha꞉ma꞉ pa꞉ta꞉ alota꞉ Mo Sodomo Komoto da yaapona꞉ pi laasa꞉eki manuta꞉ ota꞉ hokeeki laaloendi pita꞉la꞉me. Kutupa ipilika꞉ hoke hauta꞉ ota꞉ tiekee. ");
INSERT INTO ssx_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Koto ekina꞉ mo loloendi piteleme laasa꞉eki opolo ekita꞉ ota꞉pe laa handolo holopulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kutupa mo hali yaapota꞉ Sodomo nane pepekepate mo Tekehalita꞉ Eipoloha꞉ma꞉ yaapo pa hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kutupa Eipoloha꞉ma꞉ma꞉ Tekehali handolo hata꞉ alota꞉ Nakana꞉ma꞉ta꞉ mo hoke hau pa꞉la꞉ tapake hoeyaaso hata꞉ta꞉ mo tikitiki piki tapake make ota꞉ mandakena꞉ hoeyalo pele ekina꞉ alepe. ");
INSERT INTO ssx_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Oni daoni pa꞉ta꞉ hoke hau na pu haleme wanda꞉hali 50 haya꞉ka꞉na꞉ta꞉ kota꞉ pa hoeyalipikipe. Nakana꞉ma꞉ta꞉ koto 50 wanda꞉hali homaama꞉na꞉ ya honema꞉ta꞉ na hoeyalena꞉e hone witolome. ");
INSERT INTO ssx_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ota꞉ mo tikitiki piki tapaketa꞉ mo hoke hau pa꞉la꞉ wanda꞉hali ame̱le̱ na lu homalipikipema. Kotota꞉ ota꞉ pea꞉peke na ya꞉la꞉ haue. Nakana꞉ma꞉ta꞉ kutupiki hau pea꞉peke na ya꞉la꞉me. Nakana꞉ma꞉ mo da hoeyaeka꞉na꞉ta꞉ kota꞉ mo tikitiki piki tapaketa꞉ mo hoke hau pa꞉la꞉ tapake ame̱le̱ ka꞉nda꞉ pealipikie. Koto ekina꞉ kotota꞉ ota꞉ ana꞉ na pa꞉la꞉ haue. Do kenke paeyaona꞉ pi yokaalu pitele halima꞉ta꞉ ota꞉ tikitiki yao kone pea꞉peke ya꞉la꞉me laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Koto leeke mo Tekehalima꞉ hombo peaaso alota꞉ I̱ma꞉ mo Sodomo daoni pa꞉ta꞉ tikitiki pea hala꞉ tapake 50 handoa꞉ka꞉na꞉ta꞉ kota꞉ koto wanda꞉halina꞉ hauna꞉ kone mo daoni na hoeyalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Eipoloha꞉ma꞉ma꞉ pi paa alo alota꞉ Tekehalio. Pilisi I̱ma꞉ paala꞉ma꞉ na homeke pi paa alo ekina꞉ hone na wia꞉peke. I̱ta꞉ pa kenke hali yalo pi ma꞉nda꞉ lapeketa꞉ na ya꞉la꞉pate pa ");
INSERT INTO ssx_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","mo daoni pa꞉ta꞉ 50 dia꞉ ya꞉lia꞉pate pa 45 tikitiki piki tapake homeke haya꞉ka꞉na꞉ta꞉ kota꞉ 5 ma꞉nda꞉ dia꞉ya꞉la꞉ ekina꞉ mo daoni paeyao hoeyalipikipe leekeme. Mo Tekehalima꞉ paa hombo peaaso alota꞉ I̱ma꞉ mo daoni pa꞉ta꞉ hoke hau na pu hala꞉ wanda꞉hali 45 handa꞉ ua꞉ka꞉na꞉ta꞉ na hoeyalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Eipoloha꞉ma꞉ma꞉ paa ombu alota꞉ Pa 40 tapake homeke haya꞉ka꞉na꞉ta꞉ eki pilipikipe leekeme. Ipikana꞉ma꞉ hombo peaaso alota꞉ Kota꞉ 40 tapake haya꞉ka꞉na꞉ make ota꞉ na hoeyalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Eipoloha꞉ma꞉ma꞉ alota꞉ Pilisi Tekehalio. I̱ma꞉ pi paa lapeke ya꞉la꞉ma꞉ mineke na panka꞉peke. Mo tapake 30 homeke haya꞉ka꞉na꞉ta꞉ eki pilipikipe leekeme. Tekehalima꞉ hombo peaaso alota꞉ 30 tapake handa꞉ ua꞉ka꞉na꞉ maketa꞉ na hoeyalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Eipoloha꞉ma꞉ma꞉ alota꞉ Tekehalio. Pilisi I̱ma꞉ paala꞉ma꞉ na homeke neke pa꞉ta꞉ pi pa la꞉tia pulu ekina꞉ hone na wia꞉peke. Mo pa꞉ta꞉ pa 20 homeke handa꞉ wika꞉na꞉ta꞉ eki pilipipe leekeme. Ipikana꞉ma꞉ alota꞉ 20 handa꞉ ua꞉ka꞉na꞉ make na hoeyalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Eipoloha꞉ma꞉ma꞉ alota꞉ Tekehalio. Pilisi ota꞉ hoto homeke lota꞉ puluekema꞉ mineke na panka꞉peke. Kiki yaapo homeke handa꞉ wika꞉na꞉ta꞉ eki pilipikipe leekeme. Ipikana꞉ma꞉ alota꞉ Kiki yaapo handa꞉ ua꞉ka꞉na꞉ make na hoeyalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kutupa Eipoloha꞉ma꞉ yaapo pi lo paeyao mo Tekehali pu moneayeketa꞉ Eipoloha꞉ma꞉ta꞉ da la꞉ka꞉la peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Mo hande enisolo yaapo Sodomo opolo epepeketa꞉ Lodata꞉ mo daonina꞉ pota꞉ kake pa꞉ta꞉ pitiekeme. Lodama꞉ mo hali yaapo hando haota꞉ koto kone tiao handolo peekeme. Ipikana꞉ma꞉ mo hali yaapo haepeke alena꞉ pua panda꞉puniaaso ");
INSERT INTO ssx_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","alota꞉ Hali yaapoo. I̱ta꞉ ipiliki tamba꞉ muluekema꞉ haloma꞉ pilisi ya da nane pomana꞉ ipupe. Ipilika꞉ anke tandepo peliaata꞉ da ka꞉la꞉paasota꞉ timba tiao ipilika꞉ polo pelepe nane poepena꞉ loa꞉me leekeme. Pate ipilikana꞉ma꞉ hombo peaaso alota꞉ Dia꞉me. Dikita꞉ ame do timbata꞉ do daoni wanda꞉halina꞉ mombolo haleme alena꞉ polupekee lepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Pate Lodama꞉ta꞉ mo hali yaapo honke paa la꞉tiki pu haota꞉ wetepe nane ipika꞉ da pa꞉ta꞉ hatuku peekeme. Lodama꞉ta꞉ ipika꞉ e pokaasa꞉ haliweki pa꞉ta꞉ alota꞉ Do kimisu tapakena꞉ mandane betedimanu wepiao make epeke ne ma꞉nda꞉ wamo peape leekeme. Kutupa mo ne amu pea wieketa꞉ nemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mo kimisu hali yaapo polu poluekema꞉ haena꞉ta꞉ mo Sodomo haliwekima꞉ mo da a꞉pa popei yaemekeme. Mo daoni pa꞉ta꞉ haemeke koke haliweki paeyao make pa꞉pa꞉na꞉ weki paeyao make a꞉pa haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ikana꞉ma꞉ mo Loda pa꞉ta꞉ wi alo alota꞉ Mo neke ame̱le̱ ame timba polu epeme haliwekita꞉ hando ya꞉ka꞉ta꞉pe. Niki pa꞉ta꞉ hatuku epoe lemekeme. Mo Sodomo haliwekima꞉ta꞉ mo hali yaapo ame̱le̱ loke apa꞉taasa꞉ hau puluekema꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Koto lemeke Lodata꞉ hama opolu bao pota꞉ poka꞉neayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Kutupa ipikana꞉ma꞉ mo haliweki pa꞉ta꞉ alota꞉ Yankeke tonuo. Dupiki temokona꞉ hau na pia꞉pa꞉pee laa iki honke alome. ");
INSERT INTO ssx_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Handa꞉pe yaka moputali wandiki yaapo hala꞉ma꞉ ika꞉ hone pa꞉la꞉eki puemena꞉ hama hatuku eponoe. Pate do hali yaapo pa꞉ta꞉ta꞉ hau ma꞉nda꞉ na pia꞉pa꞉pee. Ipilikita꞉ yaka kimisu hali yaapo ya꞉la꞉ ekina꞉ I̱ma꞉ handeteke hapeke ya꞉la꞉ma꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Koto leekepate mo tapakema꞉ alota꞉ Neketa꞉ kenke ma꞉nda꞉ hali ya꞉la꞉ma꞉ nika꞉ pota꞉na꞉ na hake wopu hae. Niki dupi dupi laa leeke hauta꞉ neketa꞉ epi ya꞉ka꞉ta꞉pe. Nikana꞉ma꞉ mo hali yaapo pa꞉ta꞉ pulu pololoma꞉ tupa꞉ neke pa꞉ta꞉ ota꞉ haka꞉ta꞉pake tupa꞉ puluma꞉ma꞉ wotu hae lemekeme. Mo haliwekima꞉ta꞉ Loda wato lopao oni pota꞉ kake yambuluekema꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Pate mo da tukiki pa꞉ta꞉ pitipiki kimisu hali yaapoma꞉ta꞉ kiki hokulu peao Loda yola꞉ mea oni da tukiki pa꞉ta꞉ lopao pota꞉ poka꞉peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Kutupa mo hama꞉ nane haemeke haliwekima꞉ pota꞉ na lombolo pimiki tupa꞉ ipilikana꞉ma꞉ta꞉ ika꞉ leke holu peaepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mo hali yaapoma꞉ Loda pa꞉ta꞉ alota꞉ Ma꞉nda꞉ epi naka꞉ wekiwandiki tonu o naka꞉ mei tonu o naka꞉ yankeke do daoni pa꞉ta꞉ haemeka꞉na꞉ta꞉ kota꞉ do pa꞉ta꞉ na haena꞉ leke panane hatuku pue. ");
INSERT INTO ssx_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Pa ekipeke do daonita꞉ dikana꞉ma꞉ hoeyalo polopa꞉ ekina꞉ lopa꞉me. Mo Tekehalima꞉ta꞉ do Sodomo wanda꞉halina꞉ pi laasa꞉ ekita꞉ ota꞉ hoke tupa꞉ opua do Sodomo hoeya ponoyeke diki tapaala꞉me lepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Koto lepeke Lodata꞉ ipika꞉ wandiki yaapo mulu pimiki haliweki pa꞉ta꞉ pua alota꞉ Mo Tekehalima꞉ do da hoeyaliekema꞉ mina꞉pa꞉lao ota꞉ a̱i̱ yopupe leekepate mo haliwekina꞉ honema꞉ta꞉ Lodama꞉ pa telepo alo ala꞉ma꞉ hone wimikime. ");
INSERT INTO ssx_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Da kelepolo haena꞉ mo enisolo yaapoma꞉ Loda ipupulaaso alota꞉ A̱i̱ a̱i̱ pie. Naka꞉ wandiki ankula꞉ ankula꞉ ota꞉ a̱i̱ hatuku pue. Pa ekipeke mo daoni hoeyaeya꞉ka꞉na꞉ta꞉ iki na homolo peleme tupa꞉ lopa꞉me lepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Pate Lodama꞉ta꞉ kiao tapeke nono pieketa꞉ mo Tekehalima꞉ta꞉ Loda a꞉ta꞉ma꞉ homolo hata꞉ mo hali yaapoma꞉ Loda make ipika꞉ waneke ankula ankula paeyao kikima꞉ mea hatuku mo daoni mina꞉pa꞉lao pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kutupa mo enisolo ma꞉nda꞉ma꞉ alota꞉ Ota꞉ homa꞉la꞉eki weiya honkopu hao pototo laa pupe. Na handa꞉neake make mo hawetena꞉ na pua hando hapa꞉peke. Iki na lulu pa꞉la꞉ tupa꞉ oli pote pa꞉ta꞉manu pindipa pupe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Pate Lodama꞉ hombo peaaso alota꞉ Someo. Pilisi ota꞉ dia꞉me. Nikana꞉ma꞉ dupiki hau na piomono lapee. ");
INSERT INTO ssx_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","I̱ a꞉ta꞉ma꞉ homolo hata꞉ ipilikana꞉ma꞉ I̱ homaama꞉na꞉ yeke ota꞉ tamba꞉ mipipate pa mo pote manuta꞉ papate yalo hata꞉ koto pate a̱i̱ na opolo peke hano mo hoeyalo pa꞉la꞉ ekima꞉ I̱ a꞉pa teliminia꞉ka꞉na꞉ta꞉ kota꞉ homulueke. ");
INSERT INTO ssx_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Koto ekina꞉ mo koto hosiki daoni sikita꞉ handelepe laa mo daonita꞉ pa hosiki da siki ya꞉la꞉ ekina꞉ I̱ na homolo polo tupa꞉ koto pa꞉ta꞉ pono lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mo enisoloma꞉ hombo peaaso alota꞉ A꞉pa꞉la꞉me. I̱ma꞉ aowe aloma꞉ koto daoni na hoeyalueke. ");
INSERT INTO ssx_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ota꞉ a̱i̱ a̱i̱ la a̱i̱ya pupema. I̱ma꞉ta꞉ iki mopate a̱i̱ na opolo peke hamina꞉ta꞉ hau ma꞉nda꞉ a̱i̱ na pulueke leekeme. Lodama꞉ koto daonita꞉ hosiki alesiki leeke handaa mo daonina꞉ bikita꞉ Soa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Mo nate opolo haena꞉ta꞉ Loda mo Soa da opolo peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kutupa koto kone Tekehalima꞉ talo talo hake lanka꞉ biki solopama꞉ mo Sodomo pita꞉ Komoto daoni yaapo pa꞉ta꞉ lako leke lopena꞉ alo hata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","hoeyao mo hawete tieke make wanda꞉hali paeyao make koto kenkena꞉ opeeke ala꞉ta꞉ ala꞉ta꞉ paeyao make hoeyaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pate Lodana꞉ weteketa꞉ paa la꞉ka꞉la꞉ handa꞉moneao hao ipikita꞉ epi punka au laa hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Da ka꞉la꞉paaso sikita꞉ Eipoloha꞉ma꞉ta꞉ ipupula pua mo hande Tekehalina꞉ leke popelekena꞉ pua hayeke alena꞉ paa peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Kutupa mo Sodomo pita꞉ Komoto yaapo mo hawete tieke make handa꞉niayekepate mo kenke pa꞉ta꞉ta꞉ po moya̱la꞉ alena꞉ piki nono pea lumu tieke opeekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Pate Koda꞉ma꞉ hande Loda hayeke daoni yaapo hoeyaeyeke dina꞉ta꞉ ipika꞉ hone pa꞉ta꞉ Eipoloha꞉ma꞉ hone pa wia hata꞉ Loda pindipa pena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loda ipikita꞉ Soa hapeke paala꞉ pieketa꞉ ipika꞉ wandiki yaapo ame̱le̱ pote eli pa꞉ta꞉manu pua tikene da pa꞉ta꞉ pelia haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kutupa mo mupeke wandikima꞉ hakepiki pa꞉ta꞉ alota꞉ Diki mea wekiwandiki mendialo pa꞉la꞉ hali ma꞉nda꞉ do kenke paeyao pa꞉ta꞉ na hala꞉me. Kutupa make dika꞉ apa꞉ta꞉ koke yala꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Koto ekina꞉ dika꞉ apa꞉ hoke ikali na keaena꞉ laa ipiki ame̱le̱ polupa꞉ka꞉na꞉ta꞉ kota꞉ ipiki pa꞉ta꞉ yama꞉ wekiwandiki mondupana꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Koto timbata꞉ ipiki waini ikali nena꞉ halaata꞉ mo mupeke wandiki ateke yaapo peliekepate mo ateketa꞉ ikali tieke neekeeki yalo ipikita꞉ hone na wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mo da ma꞉nda꞉ kelepeeketa꞉ mo mupeke wandikima꞉ hakepiki pa꞉ta꞉ alota꞉ Ambaneke timbata꞉ ipiki yaapo I̱ polua꞉ma꞉ ame timbata꞉ neke poluepena꞉ ikali paa nena꞉ lopana꞉e. Kutu pupa꞉ka꞉na꞉ta꞉ kota꞉ diki telipuna꞉ma꞉ dika꞉ apa꞉ pa꞉ta꞉ yama꞉ weki mondupana꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Koto ekina꞉ koto timbata꞉ ipilika꞉ ateke ikali nena꞉ laa mo wetepe nane wandiki ateke yaapo pelipipikime. Kutupa ateketa꞉ ikali tieke ombu neekeeki yalo hone na wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Koto hau pipiki ekima꞉ta꞉ Lodana꞉ waneke yaapota꞉ weki loke lomba꞉alu pipikime. ");
INSERT INTO ssx_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mo titina꞉ wandikima꞉ weki mendieketa꞉ ipiki bikita꞉ Moa꞉be leekeme. Ipikita꞉ ame do Moa꞉be wanda꞉halina꞉ apa꞉meie. ");
INSERT INTO ssx_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mo wetepena꞉ wandikima꞉ make weki ombu mendieketa꞉ ipiki bikita꞉ Benami leekeme. Ipikita꞉ ame do A꞉mono wanda꞉halina꞉ apa꞉meie. ");
INSERT INTO ssx_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Eipoloha꞉ma꞉ma꞉ta꞉ Ma꞉mote mina꞉pa꞉lao Keinanina꞉ ka꞉wa꞉ nanema꞉ tilao mo Keidese make Sia꞉e kenke yaapo tukikina꞉ pua pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Kutupa ipikana꞉ma꞉ Kita kenke pa꞉ta꞉ pua hata꞉ Setata꞉ ipika꞉ beliki leekeme. Koto leeke handa mo Kita kenkena꞉ kini Abimelekema꞉ Setata꞉ hatuku ipiki pa꞉ta꞉ epena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Timba ma꞉nda꞉ta꞉ mo some pa꞉ta꞉ Koda꞉ma꞉ upama꞉ a꞉pa alota꞉ Nakana꞉ma꞉ do amba꞉ ma꞉nda꞉ma꞉ ma꞉la꞉ wanda꞉ mele ekina꞉ neke homilipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Pate Abimeleketa꞉ mo wanda꞉ teke pa꞉ta꞉ na epeeke ekina꞉ alota꞉ Tekehalio. I̱ta꞉ hokeeki ma꞉nda꞉ na poloma꞉ I̱ make yaka wanda꞉hali make hoeyalipikipe. ");
INSERT INTO ssx_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Eipoloha꞉ma꞉ma꞉ta꞉ ipika꞉ ana꞉e leeke handa mo wanda꞉ma꞉ make homeke pi kone lea꞉me. Koto ekina꞉ I̱ma꞉ do hauta꞉ yaka honema꞉ tikitiki pieke handa dupiki hau pua꞉me. Kutupa I̱ma꞉ta꞉ hoke hau ma꞉nda꞉ na polome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Koda꞉ma꞉ upama꞉ hombo peaaso alota꞉ Ota꞉e. Nakana꞉ma꞉ tikitiki pieke handaa pi ekina꞉ nakana꞉ma꞉ I̱ pa꞉ta꞉ hoke hau pilipiki yeke nakana꞉ma꞉ mo wanda꞉ na wataalena꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Koto ekina꞉ ameta꞉ mo wanda꞉ ipika꞉ haliki pa꞉ta꞉ paa hala꞉peke. Mo halita꞉ potopede hali halekena꞉ ipikana꞉ma꞉ nekena꞉ yeni peaya꞉ka꞉na꞉ta꞉ kota꞉ neke na homilipikie. Pate mo wanda꞉ pa na haleka꞉na꞉ta꞉ kota꞉ neke kinki pitoloma꞉ laa neke make naka꞉ wanda꞉hali make homilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Da kelepeeketa꞉ Abimeleke ipika꞉ you haliweki wi la꞉ mepi pea mo piekeeki la haleeke handaa mo haliwekita꞉ paala꞉ma꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kutupa Abimelekema꞉ Eipoloha꞉ma꞉ wi la꞉ mea alota꞉ Nakana꞉ma꞉ niki pa꞉ta꞉ dota꞉ ekipiki hau pea pelepe. Nakana꞉ma꞉ I̱ pa꞉ta꞉ make yaka kilu tombuao halo pa꞉ta꞉ do hoeyaapekeeki epena꞉ leke hauta꞉ I̱ma꞉ neke pa꞉ta꞉ ekipiki ata꞉ka꞉ poleke pelepe. Nakana꞉ma꞉ do I̱ pa꞉ta꞉ pele ekita꞉ ota꞉ ma꞉nda꞉ma꞉ na pea꞉peke hau peleme. ");
INSERT INTO ssx_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Koto ekina꞉ ekipeke do hau pea pelepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Eipoloha꞉ma꞉ma꞉ hombo peaaso alota꞉ Yaka honema꞉ta꞉ do pate Koda꞉ paala꞉piki some ma꞉nda꞉ na halieke hone wia yaka wanda꞉ muluekema꞉ I̱ limikie hone ua꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Pate mo wanda꞉ta꞉ ota꞉ yaka ana꞉e. Ipikita꞉ yaka apa꞉na꞉ waneke ya꞉la꞉pate ama꞉ homeke ta꞉ta꞉e. Kota꞉ I̱ma꞉ mea polome. ");
INSERT INTO ssx_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Koto ekina꞉ Koda꞉ma꞉ I̱ yaka apa꞉na꞉ da mina꞉pa꞉lao ma꞉nda꞉na꞉ kenke pa꞉ta꞉ pu leeke puluta꞉ I̱ma꞉ mo wanda꞉ pa꞉ta꞉ alota꞉ Nakana꞉ma꞉ I̱ oto pa꞉ta꞉ haleeki walolo hata꞉ paeyao pa꞉ta꞉ I̱ta꞉ naka꞉ ana꞉e lapeke laa loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kutupa Abimelekema꞉ Setata꞉ Eipoloha꞉ma꞉ paa halolo hata꞉ make homeke dina꞉ koneta꞉ sipisipimanu make kaomanu make pa hameke e pokaasa꞉ wanda꞉hali make apa꞉tao haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ipikana꞉ma꞉ Eipoloha꞉ma꞉ pa꞉ta꞉ alota꞉ Dota꞉ yaka kenkema꞉ naka꞉ hone pa꞉la꞉ alena꞉ hae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Kutupa Seta pa꞉ta꞉ alota꞉ Mo neke ame̱le̱ haleme wanda꞉halima꞉ neketa꞉ hokeeki na ula꞉me laa waloelena꞉ make hokeeki ma꞉nda꞉ na peleme hone wina꞉ I̱ma꞉ naka꞉ ana꞉ pa꞉ta꞉ mo silipa manimanu 1 daoseni do halolo handa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Kutupa mo Eipoloha꞉ma꞉na꞉ weteke Seta pa꞉ta꞉ pieke ekina꞉ Tekehalima꞉ta꞉ mo Abimelekena꞉ kini da pa꞉ta꞉ haemeke wanda꞉manu paeyaota꞉ weki mendia꞉la꞉ hauta꞉ sa꞉sa꞉ piekeme. Koto ekina꞉ Eipoloha꞉ma꞉ma꞉ Koda꞉ pa꞉ta꞉ Abimelekena꞉ yeni peayeke handa epeayekeme. Kutupa make mo ipika꞉ wanda꞉ make mo ipika꞉ pa hameke e pokaemeke wandiki titi make weki mendina꞉ yeke epeayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mo Tekehalima꞉ ipika꞉ pi la꞉ wieke tupa꞉ kone Seta epeayeketa꞉ ");
INSERT INTO ssx_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Eipoloha꞉ma꞉ta꞉ koke ya꞉na꞉ kone Setama꞉ weki loke lomba Eipoloha꞉ma꞉na꞉ hali weki mendiaeyekeme. Mo wekita꞉ hande Koda꞉ma꞉ mendiliekee laa la꞉ wieke natena꞉ kone mendiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Eipoloha꞉ma꞉ma꞉ta꞉ mo wekina꞉ bikita꞉ Aisa꞉ke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kutupa mo weki nate ketepo hata꞉ mieketa꞉ mo hande Koda꞉ma꞉ pia꞉peke laa leeke tupa꞉ sekemesaisi hau peayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Eipoloha꞉ma꞉ta꞉ 100 bapi mieketa꞉ Aisa꞉ke mendiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Setama꞉ alota꞉ Koda꞉ma꞉ I̱ pa꞉ta꞉ta꞉ ta꞉na꞉ pa꞉la꞉eki make ki tala꞉eki make mea a꞉pa꞉la꞉mee. Epi amedama꞉ doeki opia꞉ka꞉na꞉ta꞉ kota꞉ I̱ ame̱le̱ mandakena꞉ ki talimikie. ");
INSERT INTO ssx_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kutupa pa pi ma꞉nda꞉ ombu alo alota꞉ Eipoloha꞉ma꞉ pa꞉ta꞉ta꞉ Setama꞉ wekiwandiki andu halia꞉pe pita꞉ epima꞉ lolo pia꞉pe. Kutu pina꞉ kone ipikita꞉ koke halina꞉ I̱ma꞉ weki mendiawalome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kutupa mo weki daeyaata꞉ andu nala꞉eki mina꞉pa꞉laeyeke dina꞉ta꞉ Eipoloha꞉ma꞉ma꞉ta꞉ ne tieke pambaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Nate ma꞉nda꞉na꞉ mo Idiepi wanda꞉ Heikama꞉ Eipoloha꞉ma꞉na꞉ mendiaeyeke weki Isima꞉elota꞉ Setana꞉ eiyeke Aisa꞉ke yaapo telepo lo pitipikime. ");
INSERT INTO ssx_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kutu pieke Setama꞉ moeki hando hao Eipoloha꞉ma꞉ pa꞉ta꞉ alota꞉ Do pa hameke e pokaasa꞉ wanda꞉ ipika꞉ eiyeke yaapo tapae. Do wanda꞉na꞉ eiyekema꞉ta꞉ mo yaka weki Aisa꞉kema꞉ naka꞉ anketeke mulu pa꞉la꞉ ale ma꞉nda꞉ na mina꞉ lapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Doeki leeke ekima꞉ta꞉ Eipoloha꞉ma꞉ma꞉ ka꞉nda꞉ma꞉ homeekeme. Pa ekipeke Isima꞉elo make ipika꞉ wekie hone wieke ekima꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Pate Koda꞉ma꞉ Eipoloha꞉ma꞉ pa꞉ta꞉ alota꞉ Mo naka꞉ pa hameke e pokaasa꞉ wanda꞉ Heika make mo weki Isima꞉elo yaapona꞉ pomoma꞉ na homa꞉peke. Mo Setama꞉ pia꞉ ala꞉ ekita꞉ ota꞉ pea꞉peke. Pa ekipeke mo I̱ma꞉ pi la꞉ ua꞉ tupa꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ Aisa꞉ke pa꞉ta꞉ yama꞉ ipilieke. ");
INSERT INTO ssx_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kutupa make mo pa hameke e pokaasa꞉ wanda꞉na꞉ eiyeke pa꞉ta꞉ make wekiwandiki wopu halaa tutu tieke halieke. Pa ekipeke mo weki make naka꞉ weki ya꞉la꞉ ekina꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Da ka꞉la꞉paaso sikita꞉ Eipoloha꞉ma꞉ma꞉ Heika pa꞉ta꞉ ne make mo kao yonkelekema꞉ wepiki ikali kanakena꞉ ikali no tumbao haleekeme. Kutupa mo wekita꞉ Heikana꞉ hokina꞉ tu lao pena꞉ tapaeyekeme. Kutu pieke mo wanda꞉ta꞉ pua mo Biasiba hapekena꞉ pomu lopeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Kutupa mo ikali paeyeketa꞉ mo wekita꞉ hosiki ti teke ma꞉nda꞉ pa꞉ta꞉ wina꞉ laa ");
INSERT INTO ssx_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Heikata꞉ mo pate leke pua pitiekeme. Kutupa mo wanda꞉ ipika꞉ kone alota꞉ Yaka weki homa꞉la꞉eki handa꞉peketa꞉ I̱ ana꞉ na pa꞉la꞉me leekeme. Kutupa koto pate pitina꞉ta꞉ ipikana꞉ma꞉ e̱ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Koda꞉ma꞉ mo wekina꞉ e̱ leekeeki opua hepeni nanema꞉ Koda꞉na꞉ enisoloma꞉ Heika pa꞉ta꞉ alota꞉ Heikao. Neketa꞉ alekena꞉ ka꞉nda꞉ma꞉ homelepe. Koda꞉ma꞉ mo wekina꞉ e̱ opia꞉ma꞉ paala꞉ma꞉ na homa꞉pee. ");
INSERT INTO ssx_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tiao. Pua mo weki pua hopulu mea homupeae. I̱ma꞉ta꞉ do weki pa꞉ta꞉ yama꞉ta꞉ ipika꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandikita꞉ tutu tieke hawalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kutupa Koda꞉ma꞉ mo wanda꞉na꞉ leke ki layeketa꞉ ipikana꞉ma꞉ naku ikali handeekeme. Kutupa mo wanda꞉ma꞉ mo kao yonkelekema꞉ wepiki ikali kanake pua mea ikali tumbao mandaneta꞉ mo weki haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Kutupa mo weki daeya꞉liayeke ale pa꞉ta꞉ kone Koda꞉ma꞉ta꞉ mo weki handeteke hayekeme. Mo wekita꞉ mo Pa꞉tani hapekena꞉ hata꞉ eiya꞉nala꞉ ekina꞉ handa wiki some hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Kutupa ipika꞉ inkikima꞉ mo wekina꞉ wanda꞉ta꞉ mo Idiepi wanda꞉ meayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Koto natena꞉ta꞉ Abimeleketa꞉ ipika꞉ amina꞉ you hali Pikolo yaapo pua Eipoloha꞉ma꞉ pa꞉ta꞉ alota꞉ Naka꞉ pitele hau paeyao pa꞉ta꞉ta꞉ Koda꞉ta꞉ neke yaapo hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Koto ekina꞉ mo Koda꞉na꞉ leke popelekena꞉ pi la꞉ witolota꞉ I̱ make yaka wekiwandiki make yaka monduma꞉ monduma꞉ pulua꞉ wekiwandikina꞉ wekiwandiki make na makealueke laa la꞉ wie. I̱ma꞉ta꞉ neke pa꞉ta꞉ hone tulapelia haloma꞉ nakana꞉ma꞉ I̱ pa꞉ta꞉ make hone tulapelia halueke laa la꞉ wie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Eipoloha꞉ma꞉ma꞉ alota꞉ I̱ma꞉ pi la꞉ witolome laa leekepate ");
INSERT INTO ssx_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","pa mo Abimelekena꞉ e pokaeyeke haliwekima꞉ pendilayeke naku ikalina꞉ Abimeleke pa꞉ta꞉ pi yokaalu piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelekema꞉ hombo peaaso alota꞉ Do hau pa꞉la꞉ someta꞉ epipe. Nakana꞉ma꞉ I̱ na laa keleme. Kutupa ame do siki opitolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kutupa Eipoloha꞉ma꞉ma꞉ mandane sipisipi make kaomanu make Abimeleke haleekeme. Kutupa hali yaapoma꞉ pi tonkao wipikime. ");
INSERT INTO ssx_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Eipoloha꞉ma꞉ma꞉ mo wataake hata꞉ sipisipi ikiki manuta꞉ mo ipika꞉ sipisipi ame̱le̱ na haena꞉ leke ta꞉ta꞉ putupa haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Kotoeki handaata꞉ Abimelekema꞉ lota꞉ pitolo alota꞉ Nakana꞉ma꞉ koto hauta꞉ ekipeke pipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Koto leeke Eipoloha꞉ma꞉ma꞉ hombo peaaso alota꞉ Do wataake hata꞉ sipisipi ikikimanu mie. Do hau pitolopa꞉ ekima꞉ta꞉ nakana꞉ma꞉ do naku ikalita꞉ I̱ma꞉ awa polome loelena꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Koto pa꞉ta꞉ta꞉ mo hali yaapoma꞉ pi la꞉ wipiki pa꞉ta꞉ yalo bikita꞉ Biasiba lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Koto pi lo tonkao wiata꞉ Abimeleke pita꞉ Pikolo yaapota꞉ mo Pilisidia kenke nane paa pepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Kutupa Eipoloha꞉ma꞉ma꞉ta꞉ mo Biasiba pa꞉ta꞉ta꞉ mo napu ti homeke ma꞉nda꞉ noka꞉paata꞉ mo Pa Hao Hala꞉ Tekehali Koda꞉ pa꞉ta꞉ panda꞉puniao yeiya꞉ layekeme. ");
INSERT INTO ssx_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Kutupa Eipoloha꞉ma꞉ma꞉ta꞉ nate hokuluna꞉ Pilisidia kenke pa꞉ta꞉ hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nate ma꞉nda꞉na꞉ Koda꞉ma꞉ Eipoloha꞉ma꞉ la handuluekema꞉ wi alota꞉ Eipoloha꞉ma꞉o leeke Eipoloha꞉ma꞉ma꞉ hombo peaasota꞉ Wae laa alota꞉ I̱ do handa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Koda꞉ma꞉ alota꞉ Mo ota꞉ naka꞉ pukima꞉ homele homeke weki Aisa꞉keta꞉ hatuku mo Motaeya kenke pa꞉ta꞉ pue. Kutupa koto pate I̱ma꞉ walua꞉ potena꞉ naka꞉ weki lia I̱ pa꞉ta꞉ kuelena꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Da ka꞉la꞉paaso sikita꞉ Eipoloha꞉ma꞉ma꞉ta꞉ mo weki lia halopieke timanu poka ipika꞉ donkina꞉ hokina꞉ mendiao Aisa꞉ke make ipika꞉ e pokaepeke hali yaapo make hatuku peekeme. Ikita꞉ mo hande Koda꞉ma꞉ la haleeke alena꞉ poluekema꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Nate tepo peaona꞉ta꞉ Eipoloha꞉ma꞉ma꞉ mo hande leeke alena꞉ handa꞉ moneayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Kutupa ipikana꞉ma꞉ mo e pokaepeke hali yaapo pa꞉ta꞉ alota꞉ Do donki ame̱le̱ do pate hape. Mo weki dikita꞉ mo pa pate leke pua panda꞉puniao yeiya꞉ lao ipiliki halipi alena꞉ paa ipulupekema꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Eipoloha꞉ma꞉ma꞉ta꞉ mo hau pitolo yankolo pipiki tita꞉ Aisa꞉ke mea tiao ipikita꞉ kaiya make mo ti noya꞉ pia꞉peke ti epeleke make miniekeme. Ipiliki mandakena꞉ pulu hata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisa꞉kema꞉ alota꞉ Apa꞉o leekeme. Ipikana꞉ma꞉ alota꞉ Alekeka꞉ta꞉pe leekeme. Aisa꞉kema꞉ lota꞉ pitolo alota꞉ I̱ma꞉ mo ti noya꞉ pulu pele ale ti epeleke pita꞉ ti yaapota꞉ handolopate mo lia halo polopa꞉ sipisipi ikikita꞉ handoka꞉ta꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Koto leeke Eipoloha꞉ma꞉ma꞉ hombo peaaso alota꞉ Koda꞉ma꞉ kone kilieke leekeme. Kutupa telipuna꞉ mandakena꞉ pepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kutupa mo hande Koda꞉ma꞉ la haleeke alena꞉ opolo a꞉pa Eipoloha꞉ma꞉ma꞉ oloda a꞉eyaata꞉ ti manda ana꞉ layekeme. Kutupa ipikana꞉ma꞉ ipika꞉ weki tonkao mo olodana꞉ ti manda wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kutupa mo weki luekema꞉ kaiya mea mina꞉ liaeyekepate ");
INSERT INTO ssx_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","mo Tekehalina꞉ enisoloma꞉ ya pa꞉ta꞉ yama꞉ ipiki pa꞉ta꞉ wi alo alota꞉ Eipoloha꞉ma꞉o. Eipoloha꞉ma꞉o leekeme. Ipikana꞉ma꞉ hombo peaaso alota꞉ Wae. I̱ do handa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Koto leeke mo enisoloma꞉ alota꞉ Mo weki na liki ipiki pa꞉ta꞉ hau ma꞉nda꞉ na pia꞉pee. Nakana꞉ma꞉ naka꞉ homeke weki homeketa꞉ na sa꞉sa꞉ pele ekina꞉ ameta꞉ nakana꞉ma꞉ Koda꞉ paala꞉ma꞉ homeka꞉ta꞉me laa hone ulume leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Kutupa Eipoloha꞉ma꞉ma꞉ lekema꞉ lekema꞉ piekepate sipisipi halieki mo ipika꞉ ekeketa꞉ ti ma꞉nda꞉na꞉ mea hopa꞉liayekeeki handeekeme. Ipikana꞉ma꞉ta꞉ ipika꞉ weki yanka halo pieke tupa꞉ta꞉ mo hande sipisipi ma꞉na꞉ pua mea yanka haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kutupa Eipoloha꞉ma꞉ma꞉ koto pate bikita꞉ Koda꞉ma꞉ Ana꞉ Lao Hala꞉me leekeme. Kutupa ame do make wanda꞉halima꞉ta꞉ Mo Koda꞉na꞉ potena꞉ ipikana꞉ma꞉ ana꞉ lao hala꞉me lo halememe. ");
INSERT INTO ssx_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kutupa mo Tekehalina꞉ enisoloma꞉ ya pa꞉ta꞉ yama꞉ Eipoloha꞉ma꞉ paa yaapo peao wi alo alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","I̱ta꞉ Tekehalima꞉ ota꞉ yaka bikina꞉ pi la꞉ witolota꞉ I̱ma꞉ta꞉ neke wopu epealueke. Pa ekipeke. Nakana꞉ma꞉ta꞉ naka꞉ homeke weki kone na sa꞉sa꞉piki I̱ pa꞉ta꞉ kuluekema꞉ taape ekina꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","I̱ma꞉ pi la꞉ witolota꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ oli yana꞉ hala꞉ hombulanka꞉ manuma꞉ o mo ikali tiekena꞉ tea꞉na꞉ ula꞉ hou manuma꞉ handena꞉ lolueke leekeme. Kutupa ikana꞉ma꞉ta꞉ ika꞉ a꞉nda꞉ tunkuliki wanda꞉halita꞉ lu bepolalimikie. ");
INSERT INTO ssx_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Mo nakana꞉ma꞉ yaka pi opele ekina꞉ I̱ma꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki pa꞉ta꞉ yama꞉ta꞉ mo tutu paeyao sikita꞉ epeaasa꞉eki mina꞉ lolueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kutupa Eipoloha꞉ma꞉ta꞉ mo ipika꞉ e pokaasa꞉ hali yaapo haepeke alena꞉ pua mandakena꞉ mo ipiki hayeke ale Biasiba nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Hao hao nate ma꞉nda꞉ nina꞉ta꞉ Eipoloha꞉ma꞉ma꞉ mo hameke Neihona꞉ weteke Milikama꞉ wekiwandiki ketepo hata꞉ mendiaeyekeeki leeketa꞉ opiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Mupeke weki bikita꞉ Usu make hameke Busu kutupa mo A꞉tamona꞉ ateke Kemuele make ");
INSERT INTO ssx_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Diesede make Heiso make Pilida꞉se make Didila꞉pe make ");
INSERT INTO ssx_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","kutupa Lepekana꞉ ateke Beduelo make koto weki tonu paeyaota꞉ Milikama꞉ Neihona꞉ mendiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Kutupa Neihona꞉ yaapo peao mieke wanda꞉ Teumama꞉ta꞉ Diba make Kaha꞉me make Daha꞉se make Maaka make mendiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Setata꞉ bapi 127 miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Kutupa ipikita꞉ mo Keinani da kenke pa꞉ta꞉ hayeke kenke ma꞉nda꞉ Hebotoni pa꞉ta꞉ homeekeme. Kutu pieketa꞉ Eipoloha꞉ma꞉ma꞉ homa꞉ wia pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ipikana꞉ma꞉ta꞉ mo wetekena꞉ toko wieke alena꞉ mina꞉pa꞉lao mo Hidi wanda꞉hali pa꞉ta꞉ pua alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","I̱ta꞉ da ma꞉nda꞉ hali kone iki ame̱le̱ mandakena꞉ do haloma꞉ma꞉ yaka wanda꞉ hoilu polo kenke ma꞉nda꞉ hambono tapapee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Mo tapakema꞉ hombo peaaso alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Someo. Niki pa꞉ta꞉ opie. Nikana꞉ma꞉ neketa꞉ nika꞉ aneke halie laa handa꞉ lialoma꞉me. Koto ekina꞉ naka꞉ wanda꞉ta꞉ do nika꞉ ota꞉ epeke lapa꞉ ma꞉nda꞉ handa hoie. Niki ma꞉nda꞉ hondoma꞉ naka꞉ wanda꞉ hoiyuelena꞉ lapa꞉ ma꞉nda꞉ pa kuluekema꞉ hone pa꞉la꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Kutupa Eipoloha꞉ma꞉ma꞉ mo tapake pa꞉ta꞉ panda꞉puniao hata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","alota꞉ Ikana꞉ma꞉ yaka wanda꞉ do pate hoiyonoe lemeka꞉na꞉ta꞉ kota꞉ pilisi mo Sohana꞉ eiyeke Epotonima꞉ ");
INSERT INTO ssx_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","mo Ma꞉ka꞉pilana꞉ tikene da mo ipika꞉ e nepoko nane ula꞉eki lota꞉ peapee. I̱ma꞉ yaka hali hoiyu halo polo hali lapa꞉ wialuekema꞉ do ika꞉ leke popelekena꞉ I̱ pa꞉ta꞉ ipika꞉ tapao yenki mulu pa꞉la꞉ tupa꞉ kone tapaena꞉ loa꞉me laa honke lapee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Epotonita꞉ mo daoni pota꞉ kake pa꞉ta꞉ pi hotu haemeke ale pa꞉ta꞉ mo mandane Hidi tapake pitieke ale paeyaoma꞉ opitolo haena꞉ hombo peaaso alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Someo. Opie. I̱ma꞉ta꞉ koto hama꞉ make koto pa꞉ta꞉ ula꞉ tikene da make paeyao neke kulueke. Do yaka da wanda꞉halina꞉ leke popelekena꞉ mo naka꞉ wanda꞉ hoiyuelena꞉ neke kulueke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Pate Eipoloha꞉ma꞉ma꞉ mo Hidi wanda꞉hali pa꞉ta꞉ panda꞉puniao paeyaoma꞉ opitolo haena꞉ ");
INSERT INTO ssx_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","mo Epotoni pa꞉ta꞉ alota꞉ Pilisi yaka pi opie. I̱ma꞉ta꞉ mo hama paeyao hamboloma꞉ mo kitolo yenkita꞉ na kiake mie. Kutupa yaka wanda꞉ koto pate hoilueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Koto leeke Epotonima꞉ hombo peaaso alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Someo. Mo kenketa꞉ pa 400 silipa manima꞉ homeke hamba꞉peke ya꞉la꞉ma꞉ dikita꞉ ala꞉ta꞉ ma꞉nda꞉ dia꞉me. Pa pina꞉ma꞉ naka꞉ wanda꞉ koto pa꞉ta꞉ hoie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Koto leekeeki Eipoloha꞉ma꞉ma꞉ A꞉pa꞉la꞉me laa mo manita꞉ mo bisinisi haliwekima꞉ tombo mu haemeke tupa꞉ tombo mea mo Epotonima꞉ mo ipika꞉ da wanda꞉hali opu haena꞉ leeke tupa꞉ 400 silipa mani haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Kotota꞉ mo hande Ma꞉motena꞉ nate ipula꞉ nanema꞉ Epotonina꞉ Ma꞉ka꞉pila kenke Eipoloha꞉ma꞉na꞉eki au leeke ekie. Kota꞉ mo hama꞉ make mo hama꞉ pa꞉ta꞉ wieke tikene da make mo hama꞉na꞉ pu hao naeyeke timanu make ala꞉ta꞉ ala꞉ta꞉ paeyao miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Koto pi hotimiki ale pa꞉ta꞉ a꞉pa pitimiki Hidi wanda꞉hali paeyaoma꞉ta꞉ ota꞉ Eipoloha꞉ma꞉na꞉ ekie laa hone wimikime. ");
INSERT INTO ssx_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kutupa Eipoloha꞉ma꞉ma꞉ta꞉ ipika꞉ weteke Seta mo Keinani da kenke pa꞉ta꞉ wieke tikene da pa꞉ta꞉ lapa꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Koto ekina꞉ koto Hidi wanda꞉halina꞉ hama꞉ kenke make tikene da make Eipoloha꞉ma꞉na꞉ hali hoita꞉la꞉ kenke au leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Eipoloha꞉ma꞉ta꞉ ameta꞉ ota꞉ koke yeekeme. Kutupa mo Tekehalima꞉ta꞉ ipika꞉ piekeeki paeyao epeayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Eipoloha꞉ma꞉ma꞉ mo ipika꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao handeteke hayeke titina꞉ e pokaasa꞉ hali pa꞉ta꞉ alota꞉ Naka꞉ kiki yaka paleke yaapo pa꞉ta꞉ wia hata꞉ pi ma꞉nda꞉ la꞉ wie laa alota꞉. ");
INSERT INTO ssx_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Yaka hone pa꞉la꞉ ekima꞉ta꞉ nakana꞉ma꞉ mo Tekehali do kenke ya wa꞉pa꞉la꞉ Koda꞉na꞉ bikina꞉ pi la꞉ witolota꞉ yaka wekina꞉ wanda꞉ta꞉ do Keinani wanda꞉ na mealueke laa la꞉ wie. ");
INSERT INTO ssx_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Nakana꞉ma꞉ta꞉ mo I̱ mendia꞉ alena꞉ pua yaka tapake pa꞉ta꞉ kone mo yaka weki Aisa꞉kena꞉ wanda꞉ meapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Pate mo e pokaasa꞉ halima꞉ lota꞉ pitolo alota꞉ Mo wandikima꞉ ipika꞉ da mina꞉pa꞉lao I̱ yaapo do kenke nane a꞉pa꞉peke kiaya꞉ka꞉na꞉ta꞉ pa eki puluepe laata꞉ I̱ma꞉ naka꞉ wekita꞉ mo neke epele kenke nane pena꞉ tapaaluepe laa lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Kutupa Eipoloha꞉ma꞉ hombo peaaso alota꞉ Nakana꞉ma꞉ yaka weki koto nane ota꞉ paa na pena꞉ lapeke. ");
INSERT INTO ssx_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mo Tekehali oli hepenina꞉ Koda꞉ma꞉ mo yaka apa꞉na꞉ da kenke make mo yaka tapake manuna꞉ kenke make mina꞉pa꞉lao I̱ hatuku epea꞉me. Kutupa ipikana꞉ma꞉ I̱ pa꞉ta꞉ ota꞉ pi la꞉ witolo hata꞉ta꞉ Do kenketa꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki pa꞉ta꞉ halueke laa lea꞉me. Koto ekina꞉ ipikana꞉ma꞉ta꞉ mo nakana꞉ma꞉ yaka wekina꞉ wanda꞉ mealena꞉ta꞉ ipika꞉ enisolo amba꞉la tapaalieke. ");
INSERT INTO ssx_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Pate mo wandiki neke yaapo a꞉pa꞉peke kiaya꞉ka꞉na꞉ta꞉ kota꞉ neketa꞉ do pi la꞉ witele ekita꞉ paka꞉lalipikie. Pate hau ma꞉nda꞉ pia꞉ka꞉na꞉ kone yaka wekita꞉ koto nane ota꞉ na hatuku pua꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Koto ekina꞉ mo e pokaeyeke halima꞉ ipika꞉ you hali Eipoloha꞉ma꞉na꞉ paleke yaapo pa꞉ta꞉ kiki witolo hata꞉ Ota꞉ pulueke laa pi la꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Koto laata꞉ mo Eipoloha꞉ma꞉na꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao handeteke hayeke halima꞉ ipika꞉ you somena꞉ kiki yaapo kemelomanu mea mo Neiho hayeke daoni mo Mesopoteimiana꞉ okane nanema꞉ tilao mea peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kutupa ipiki mo daoni hama nane opolo puata꞉ mo kemelo manuta꞉ mo daonina꞉ naku ikali tea꞉na꞉ tumiki yotuao pitina꞉ leekeme. Kotota꞉ nate pambolo pulu haena꞉ta꞉ wanda꞉wekima꞉ ikali nolo a꞉pa꞉tiki pimiki nate yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kutupa ipikana꞉ma꞉ yeni pitolo alota꞉ Tekehalio. Yaka you some Eipoloha꞉ma꞉na꞉ Koda꞉o. Yaka you some pa꞉ta꞉ la꞉ wili pi peneme yaaso hata꞉ ame I̱ma꞉ weitolo ale kie. ");
INSERT INTO ssx_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ameta꞉ I̱ta꞉ mo hande daoni pa꞉ta꞉ haleme moputali wandiki tonuma꞉ ikali nolo epolo peleme naku ikali pa꞉ta꞉ do halo handa꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","I̱ma꞉ mo wandiki homeke ma꞉nda꞉ pa꞉ta꞉ dupa lolueke. Pilisio. Naka꞉ ikali kanake mina꞉niao I̱ ikali nono lae lolueke. Ipikana꞉ma꞉ alo hata꞉ Ikali nae laa Naka꞉ kemelo manuna꞉ ikali make mea a꞉ponoe lea꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ mo naka꞉ e pokaasa꞉ hali Aisa꞉kena꞉ ma̱leke lili wanda꞉ ya꞉na꞉e. Dupiki hau peaeka꞉na꞉ta꞉ kota꞉ nakana꞉ma꞉ mo yaka you some pa꞉ta꞉ la꞉ wili pita꞉ ota꞉ ya꞉ka꞉ta꞉me laa I̱ma꞉ hone ulueke laa yeni koto tupa꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Mo hali yeni pu paeyaaso haena꞉ta꞉ Lepekata꞉ ipika꞉ peiyokona꞉ ikali kanake tia opolo epeekeme. Mo wandikita꞉ Beduelona꞉ waneke yekeme. Beduelota꞉ Eipoloha꞉ma꞉na꞉ hameke Neiho pita꞉ weteke Milika yaapona꞉ eiyeke yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mo wandikita꞉ moputali pa pita꞉ ota꞉ seliapo piki wandiki yeekeme. Ipikita꞉ oni naku ikali pa꞉ta꞉ pua ipika꞉ ikali kanakena꞉ ikali no tumbao paa epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kutupa mo hande e pokaasa꞉ hali ankeao pua mo wandiki manda꞉hande pitolo hata꞉ alota꞉ Pilisi naka꞉ kanake pa꞉ta꞉ pila꞉ ikali ma꞉nda꞉ nono lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Koto leeke mo wandikima꞉ alota꞉ Apa꞉o. Nae laa Koto kone mo ipika꞉ peiyokona꞉ tieke ikali kanake mina꞉niao ikali nena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mo halima꞉ ikali no paeyaeyeketa꞉ mo wandikima꞉ paa alota꞉ Mo naka꞉ kemelomanu make ika꞉ hone pa꞉la꞉ tupa꞉ nena꞉ ikali mea a꞉ponope leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kutupa koto kone mo wandikima꞉ mo ma꞉na꞉na꞉ ikali no haleme kawaso pa꞉ta꞉ ikali paeyao hoelao pototo la oni ikali pa꞉ta꞉ ikali wopu nalo pua꞉tiki piekeme. Kutupa mo kemelo paeyao siki ikali ana꞉na꞉ nena꞉ lo paeyaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kutu pieke handaa mo halima꞉ta꞉ Tekehalima꞉ ipiki epeala꞉pe laa handuluekema꞉ yeke yopu siki hata꞉ mo wandiki handaake wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kutupa mo wandikima꞉ hande kemelo manuna꞉ ikali na halo paeyaeyeketa꞉ mo halima꞉ yenki tieke wiki koloma꞉ wepiki mineke kanake mea mo wandikina꞉ minekena꞉ pankao kutupa koloma꞉ ombu wepiki topa꞉ tieke aneke yaapo mea mo wandikina꞉ kiki yaapona꞉ pitaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kutupa alota꞉ Pilisi naka꞉ apa꞉ta꞉ epika꞉ta꞉pe laata꞉ I̱ la kie. Kutupa ipika꞉ da pa꞉ta꞉ta꞉ I̱ make do yaka haliweki make polu polome da panda꞉ta꞉ ana꞉na꞉ ula꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Koto leeke mo wandikima꞉ alota꞉ Yaka apa꞉ta꞉ Neiho pita꞉ weteke Milika yaapona꞉ eiyeke Bedueloe. ");
INSERT INTO ssx_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kutupa nika꞉ da pa꞉ta꞉ta꞉ taa ma꞉na꞉ma꞉ napeke ambumanu make yama꞉peke ambu sa̱ make ula꞉me. Kutupa make iki pelia꞉peke da panda꞉ ula꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Koto ekina꞉ mo halima꞉ta꞉ Tekehali pa꞉ta꞉ panda꞉ puniao yeni pitolo alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Mo yaka you some Eipoloha꞉ma꞉na꞉ Tekehali Koda꞉na꞉ biki mea mina꞉lianoe. Ipikana꞉ma꞉ta꞉ yaka you some pa꞉ta꞉ ipika꞉ pi la꞉ ula꞉ ekita꞉ ota꞉ peneme yala꞉me. Mo Tekehalima꞉ta꞉ yaka you somena꞉ tapake pa꞉ta꞉ kone mea hatuku mea a꞉pa꞉la꞉me laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mo wandikima꞉ta꞉ ipika꞉ ama꞉na꞉ da pa꞉ta꞉ pototo la puata꞉ mo hande pia꞉ haumanu paeyao pua leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Lepekana꞉ belikita꞉ Leibeni hayekeme. Mo somema꞉ belikina꞉ minekena꞉ pankeeke mineke kanake make kiki yaapona꞉ pitaeyeke topa꞉ make handolo hata꞉ mo leeke pi a꞉pa moka꞉laeyekeeki make opiekeme. Koto ekina꞉ ipikana꞉ma꞉ hande Eipoloha꞉ma꞉na꞉ e pokaeyeke halita꞉ mo naku ikali wieke alena꞉ hayeke handaa poluekema꞉ hama opolu bao pototo laa peekeme. Kutupa opolo poluta꞉ mo hande some ipika꞉ kemelo tonu ame̱le̱ mo naku ikali pitieke alena꞉ haemekeeki pua handolo hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Nika꞉ pomana꞉ a̱i̱ ipupee. Neketa꞉ mo Tekehalima꞉ epeala꞉ halie. Ekipeke do pa꞉ta꞉ hata꞉ pitelepe. I̱ma꞉ta꞉ yaka da pa꞉ta꞉ iki pelia꞉pa꞉peke da panda꞉ amba꞉ amu peala꞉me. Kutupa make ika꞉ kemelomanu hapeke da panda꞉ make ula꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Koto leeke mo halita꞉ oni da pa꞉ta꞉ peekeme. Kutupa Leibenima꞉ta꞉ mo kemelona꞉ hokina꞉ wieke alemanu mu wia napeke ambumanu make halaa ambu sa̱manu make wiaeyekeme. Kutupa mo Eipoloha꞉ma꞉na꞉ e pokaasa꞉ hali make ipika꞉ haliweki make ika꞉ anke tandepena꞉yeke ikali honke pea haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kutupa mo ne mea a꞉paeyeke dina꞉ta꞉ mo halima꞉ alota꞉ I̱ma꞉ lolueke hone witolo pi amba꞉la laata꞉ ne wetepena꞉ nolueke leekeme. Koto leeke Leibenima꞉ alota꞉ A꞉pa꞉la꞉me. Naka꞉ pi lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Koto leeke ipikana꞉ma꞉ pi kini pu mea alo alota꞉ I̱ta꞉ Eipoloha꞉ma꞉na꞉ e pokaaso halie. ");
INSERT INTO ssx_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mo Tekehalima꞉ta꞉ yaka you some ota꞉ anekema꞉ epeao hamoko hali haena꞉ la꞉la꞉me. Kutupa make ipiki pa꞉ta꞉ mo sipisipi wopu make nanikosimanu make kaomanu make silipa make kolo make pa hameke e pokaasa꞉ wanda꞉weki make haliweki make kemelomanu make donkimanu make hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Yaka you somena꞉ weteke Setata꞉ koke ya pita꞉ kone hali weki mondu wialeke handaa yaka you somema꞉ta꞉ ipika꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao mo weki hala꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Koto ekina꞉ yaka you somema꞉ta꞉ I̱ma꞉ Naka꞉ le pi ota꞉ pulueke laa la꞉ witolo hano loluekema꞉ ipika꞉ pi la꞉ witoloeki pia꞉peke laa dupa lea꞉me. Yaka wekina꞉ wanda꞉ta꞉ mo Keinani kenkena꞉ hala꞉ wandiki tonu na mea꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kotoeki na pikita꞉ mo yaka apa꞉na꞉ wanda꞉hali yaka tapake pa꞉ta꞉ pua mo wekina꞉ wanda꞉ meapeke lea꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Koto leeke I̱ma꞉ yaka you some lota꞉ pitolo alota꞉ Mo wandikima꞉ I̱ yaapo a꞉pa꞉peke kiaya꞉ka꞉na꞉ta꞉ kota꞉ eki pulua꞉pe laa loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Koto loa꞉eki ipikana꞉ma꞉ hombo peaaso alota꞉ Mo I̱ma꞉ hoto paeyao siki ipika꞉ pi opua pu halo Tekehalima꞉ta꞉ ipika꞉ enisolo neke yaapo tapaaso hata꞉ nakana꞉ma꞉ pu epealena꞉ lelieke. Kutupa nakana꞉ma꞉ yaka wekina꞉ wanda꞉ta꞉ mo yaka tapake yaka apa꞉na꞉ wanda꞉hali pa꞉ta꞉ kone mealipikie laa lea꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kutupa alota꞉ Do naka꞉ pi la꞉ wita꞉la꞉eki pa꞉ta꞉ ka꞉la꞉pa꞉ ta꞉pao halo peleeki homeketa꞉ neke mo yaka tapake pa꞉ta꞉ pelipipate neke kiaemeka꞉na꞉ta꞉ kota꞉ neketa꞉ ka꞉la꞉pa꞉ ta꞉pao halipikie laa lea꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Koto ekina꞉ I̱ ame mo naku ikali pa꞉ta꞉ a꞉pa hata꞉ yeni dupa pua꞉me. Yaka you hali Eipoloha꞉ma꞉na꞉ Tekehali Koda꞉o. Pilisi I̱ma꞉ do pitolo ekita꞉ pu epeano lae. ");
INSERT INTO ssx_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ameta꞉ I̱ta꞉ do naku ikali pa꞉ta꞉ do halo handa꞉e. Kutupa mo moputali wandiki ma꞉nda꞉ ikali noluekema꞉ epea꞉ka꞉na꞉ta꞉ I̱ma꞉ ipika꞉ ikali kanake pa꞉ta꞉ pila꞉ ikali ma꞉nda꞉ kie laa honke lolueke. ");
INSERT INTO ssx_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Kutupa mo wandikima꞉ a꞉pa꞉la꞉me laa make mo yaka kemelo manuna꞉ ikali mea a꞉paeya꞉ka꞉na꞉ta꞉ kota꞉ koto wandikita꞉ Koda꞉ nakana꞉ma꞉ mo yaka you halina꞉ eiyekena꞉ ma̱leke lili wanda꞉ ya꞉na꞉e laa yeni pua꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Koto yaka onina꞉ honema꞉ yeni pa pitolo hano kone Lepekata꞉ ikali kanake ipika꞉ peiyokona꞉ tia oni naku ikali pa꞉ta꞉ ikali nolo yapea꞉me. Kutu pieke I̱ma꞉ ipiki pa꞉ta꞉ alota꞉ Pilisio. I̱ ikali kie loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Kutupa ipikana꞉ma꞉ koto kone mo ikali kanake mina꞉niao hata꞉ alota꞉ Nae laata꞉ Naka꞉ kemelo manuna꞉ ikali make mea a꞉palueke lea꞉me. Koto leeke I̱ma꞉ta꞉ ikali noa꞉me. Kutupa yaka kemelomanu make ikali hale hale pia꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kutupa I̱ma꞉ ipiki lota꞉ pitolo alota꞉ Naka꞉ apa꞉ta꞉ epipe loeke handaa ipikana꞉ma꞉ alota꞉ Yaka apa꞉ta꞉ Neiho pita꞉ weteke Milika yaapona꞉ eiyeke Bedueloe lea꞉me. Koto leeke kota꞉ I̱ma꞉ ipika꞉ minekena꞉ mo mineke kanake pankao make ipika꞉ kiki yaapona꞉ mo topa꞉ pitaowa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kutupa I̱ta꞉ tumiki yotuao Tekehali pa꞉ta꞉ panda꞉puniao yeiya꞉ lawa꞉me. Pa ekipeke mo Tekehali yaka you some Eipoloha꞉ma꞉na꞉ Koda꞉ ipikana꞉ma꞉ I̱ta꞉ mo yaka you somena꞉ tapake pa꞉ta꞉ kone hatuku epea꞉me. Kutupa ika꞉ wandiki yaka you somena꞉ eiyekena꞉ handa꞉ wiano la꞉la꞉ ekina꞉ ipika꞉ biki mina꞉liawa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Koto ekina꞉ ameta꞉ ikana꞉ma꞉ yaka you some pa꞉ta꞉ pea꞉peke ya꞉la꞉ haumanu ana꞉na꞉ kone pulumeke hone wimika꞉na꞉ta꞉ kota꞉ pilisi I̱ la kipe. Dia꞉ya꞉ka꞉na꞉ make I̱ma꞉ pulu polo hau hone wiono a̱i̱ la kipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Koto leeke Leibeni pita꞉ Beduelo yaapoma꞉ hombo peaaso alota꞉ Do hauta꞉ mo Tekehali pa꞉ta꞉ yama꞉ a꞉pa꞉la꞉ ekina꞉ta꞉ kota꞉ dikana꞉ma꞉ dupumana꞉e laa pi ma꞉nda꞉ lapeke na ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Koto ekina꞉ Lepeka do handa꞉e. Ipikita꞉ mo Tekehalima꞉ la꞉la꞉ tupa꞉ naka꞉ you somena꞉ eiyekena꞉ wanda꞉ haena꞉e lepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Koto lepekeeki mo Eipoloha꞉ma꞉na꞉ e pokaasa꞉ halima꞉ opu haota꞉ panda꞉puniao Koda꞉ yeiya꞉ layekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kutupa ipikana꞉ma꞉ daumanu make loke au laasa꞉ silipa make koloma꞉ wepiki alemanu make mea a꞉paata꞉ Lepeka haleekeme. Kutupa make mo yenki tieke peke pa hameke hala꞉la꞉ alemanu mo wandikina꞉ beliki inkiki yaapo haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kutupa mo Eipoloha꞉ma꞉na꞉ e pokaasa꞉ hali make ipiki ame̱le̱ pemeke haliweki make ne ikali no pelimikime. Kutupa da ka꞉la꞉paaso tiao alota꞉ Yaka you some pa꞉ta꞉ paa la꞉ka꞉la pono lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Pate Lepekana꞉ beliki pita꞉ inkiki yaapoma꞉ alota꞉ Mo wandikita꞉ niki ame̱le̱ pula homeke o nate kiki yaapomanu pa hao epena꞉ lolumeke lepekepate ");
INSERT INTO ssx_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","mo halima꞉ alota꞉ Niki pa꞉ta꞉ hosiki hao pomana꞉e pi na lapee. Mo Tekehalima꞉ta꞉ yaka pota꞉ kimisu epoa꞉ ekita꞉ epeaala꞉me. Koto ekina꞉ yaka you some pa꞉ta꞉ paa la꞉ka꞉la pono lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Koto leeke hombo peaaso alota꞉ Kota꞉ mo wandikima꞉ lelia꞉eki opumana꞉ wi lomana꞉ pipee lepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Koto ekina꞉ Lepeka wi la꞉ mea lota꞉ pitolo alota꞉ Neketa꞉ do hali yaapo ame̱le̱ mandakena꞉ pelimikipe lepekeme. Mo wandikima꞉ hombo peaaso alota꞉ Aowe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Koto leeke kota꞉ Lepeka pita꞉ ipika꞉ apa꞉ ama꞉na꞉ amba꞉ kone e pokao hayeke wanda꞉ yaapo mo Eipoloha꞉ma꞉na꞉ e pokaasa꞉ hali make ipika꞉ haliweki ame̱le̱ pena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Kutupa ikana꞉ma꞉ mo Lepeka epeaasa꞉ pi dupa la haleekeme. Ana꞉o. Neketa꞉ wanda꞉hali tapake tiekena꞉ ama꞉ hapekee. Kutupa naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikima꞉ta꞉ ika꞉ a꞉nda꞉ tunkiliki tapakena꞉ daonimanu bepolaena꞉e laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kutupa Lepeka make ipika꞉ moputali wandiki titi tonka꞉na꞉ mo Eipoloha꞉ma꞉na꞉ e pokaasa꞉ hali ame̱le̱ poluekema꞉ yeke tikitiki yaaso hata꞉ mo kemelo manuna꞉ hokina꞉ pitulu puata꞉ kini pea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Kutupa Aisa꞉keta꞉ hapu hala꞉ alena꞉ mo hande Handa꞉la꞉ Pa Hao Hala꞉ Halina꞉ Naku Ikali ula꞉ alena꞉ mo Keinani kenkena꞉ ka꞉wa꞉ nanema꞉ a꞉pa hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ipikita꞉ welealo nanema꞉ oni pate nina꞉ leke pota꞉ pomuluekema꞉ peekepate kemelomanu epemekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Kutupa Lepekama꞉ Aisa꞉ke epeekeeki hando haota꞉ mo ipika꞉ kemelo mina꞉pa꞉lao hola꞉pa꞉niaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Kutupa mo Eipoloha꞉ma꞉na꞉ e pokaasa꞉ hali lota꞉ pitolo alota꞉ Mo niki handa꞉ paleke ipula꞉ halita꞉ epi yaka꞉ta꞉pe leekeme. Koto leeke mo e pokaasa꞉ halima꞉ hombo peaaso alota꞉ Ipikita꞉ yaka you somee leekeme. Koto ekina꞉ mo wandikima꞉ ipika꞉ you aka꞉ mea ipika꞉ leke popeleke a꞉mbaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kutupa mo e pokaasa꞉ halima꞉ ipika꞉ pieke hau paeyao Aisa꞉ke la haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Kota꞉ Aisa꞉kema꞉ta꞉ ipika꞉ inkiki Seta hao hayeke palai da pa꞉ta꞉ Lepeka hatuku peekeme. Kutupa mo wandikita꞉ ipika꞉ wanda꞉ hayekeme. Aisa꞉kema꞉ta꞉ Lepeka pukima꞉ homeekeme. Koto ekina꞉ mo ipika꞉ ama꞉ homeeke ekina꞉ ka꞉nda꞉ mieke ekita꞉ Lepekama꞉ ipika꞉ puki ke̱i̱ layekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Eipoloha꞉ma꞉ma꞉ta꞉ wanda꞉ ma꞉nda꞉ biki Ketuta leeke wanda꞉ miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Mo wanda꞉ma꞉ta꞉ weki tonu biki Simitani make Diokosani make Medani make Midiani make Isibake make Sua make mondu wiayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Diokosanita꞉ Siba pita꞉ Didani yaapona꞉ ateke yekeme. Kutupa mo Didanima꞉ monduma꞉ monduma꞉ pieke tapaketa꞉ A꞉sutimu make Letusimi make Leumimi make yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Mo Midianina꞉ eiyeke tonuta꞉ Epa make Epe make Ha꞉noke make Abida make Eledaha make yekeme. Do tapake paeyaota꞉ Ketutana꞉ monduma꞉ monduma꞉ piki wekiwandikina꞉ wekiwandikie. ");
INSERT INTO ssx_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Eipoloha꞉ma꞉ma꞉ ipika꞉ wia hayeke alemanu paeyaota꞉ Aisa꞉ke haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Pate ipiki a̱i̱ na homeke pita꞉ta꞉ mo ipika꞉ mandane wanda꞉wekima꞉ mendiaeyeke weki tonu pa꞉ta꞉ta꞉ pa hameke hala꞉la꞉ alemanu haleekeme. Kutupa koto weki tonuta꞉ mo nate ipula꞉ nane Aisa꞉ke mina꞉pa꞉lao pena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Eipoloha꞉ma꞉ta꞉ koke ya 175 bapina꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Kutu pieke mo ipika꞉ weki yaapo Aisa꞉ke pita꞉ Isima꞉elo yaapoma꞉ mo hande Hidi hali Sohana꞉ eiyeke Epotonina꞉ Ma꞉motena꞉ nate opa꞉la꞉ nanema꞉ wieke Ma꞉ka꞉pila tikene da pa꞉ta꞉ lapa꞉ pipikime. ");
INSERT INTO ssx_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Koto hama꞉ta꞉ Eipoloha꞉ma꞉ma꞉ mo Hidi tapake pa꞉ta꞉ hambeeke hama꞉e. Eipoloha꞉ma꞉ pita꞉ ipika꞉ wanda꞉ Seta yaapota꞉ koto pa꞉ta꞉ lapa꞉ pipikime. ");
INSERT INTO ssx_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Kutupa Eipoloha꞉ma꞉ homeke hoki naneta꞉ ipika꞉ weki Aisa꞉keta꞉ Koda꞉ma꞉ epeayekeme. Aisa꞉keta꞉ mo Handa꞉la꞉ Pa Hao Hala꞉ Halina꞉ Naku Ikali teke pa꞉ta꞉ hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Mo Setana꞉ pa hameke e pokaeyeke Idiepi wanda꞉ Heikama꞉ Eipoloha꞉ma꞉na꞉ mendiaeyeke weki Isima꞉elona꞉ ");
INSERT INTO ssx_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","weki tonu dupa mondu wiekeme. Do ipika꞉ weki tonu ika꞉ ma꞉nda꞉la꞉ tupa꞉ biki laala꞉me. Nebeioto make Keda make A꞉debielo make Mibisa꞉mo make ");
INSERT INTO ssx_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima make Duma make Ma꞉sa make ");
INSERT INTO ssx_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hada꞉de make Tema꞉ make Diede make Napisi make Kedema makee. ");
INSERT INTO ssx_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ikita꞉ mo 12 tapakena꞉ apa꞉meie. Kutupa ika꞉ biki manuta꞉ mo ika꞉ hosiki da sunu make ika꞉ poluma꞉ poluma꞉ pimiki da pa꞉ta꞉manu make tapa꞉ wiama꞉ wiama꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isima꞉elota꞉ 137 bapi hao homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isima꞉eloma꞉ monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikita꞉ mo Ha꞉pila kenke pita꞉ Sia꞉e kenke yaapo tukikina꞉ pitiekeme. Koto kenketa꞉ Idiepi nate opa꞉la꞉ nanema꞉ mo A꞉sitia poluekema꞉ pota꞉na꞉ hayekeme. Ikita꞉ mo Eipoloha꞉ma꞉na꞉ mandane monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandiki ame̱le̱ na hake papate haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Do tamenita꞉ Eipoloha꞉ma꞉na꞉ eiyeke Aisa꞉kena꞉ ekie. ");
INSERT INTO ssx_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisa꞉keta꞉ 40 bapina꞉ta꞉ Beduelona꞉ waneke Lepeka miekeme. Beduelota꞉ mo Mesopoteimia kenke nanema꞉ A꞉ta꞉mia hali hayekeme. Lepekata꞉ Leibenina꞉ beliki yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Kota꞉ Lepekata꞉ weki a̱i̱ na mendieke handaa Aisa꞉kema꞉ Tekehali pa꞉ta꞉ yeni peayekeme. Kutupa mo Tekehalima꞉ ipika꞉ yeni hombo peaasota꞉ Lepeka weki loke lombeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Mo wanda꞉ma꞉ta꞉ hone yaapo wiki weki monduluekema꞉ piekeme. Kutupa a̱i̱ na mendiki hata꞉ pa weleke pa꞉ta꞉ pita꞉ kone tonka꞉neli pipikime. Kutu pieke mo wanda꞉ma꞉ alota꞉ I̱ pa꞉ta꞉ta꞉ dupiki haumanu ekipeke pita꞉la꞉pe laa Tekehalima꞉ hombo peaena꞉ yeke lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Koto leeke mo Tekehalima꞉ alota꞉ Tutu yaapota꞉ neke pa꞉ta꞉ pila꞉me. Nakana꞉ma꞉ta꞉ ta꞉ta꞉ hone u alu pulu pa꞉la꞉ tapake yaapo mondu wilipikie. Ma꞉nda꞉ta꞉ honkopu wopu halieke. Mo mupeke halima꞉ta꞉ mo wetepe hali oto pa꞉ta꞉ halieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Mo weki mulupieke nate opolo epeeketa꞉ hone yaapo wiki weki yaapo mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mo titina꞉ wekita꞉ we pea make ipika꞉ yonkeleketa꞉ po̱ hapeleke dauma꞉ handeke itiki pelipa peekeme. Koto ekina꞉ ipika꞉ bikita꞉ Iso leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Mo wetepe wekita꞉ Isona꞉ anke kinuku mina꞉paleke mendieke ekiyalo ipika꞉ bikita꞉ Dieikope leekeme. Aisa꞉keta꞉ 60 bapina꞉ mo weki yaapo mendiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Mo weki yaapo daeyaata꞉ Isota꞉ eiya꞉nala꞉ ekina꞉ handa wiki some hata꞉ mo hama꞉ nane pita꞉la꞉ ekina꞉ puki wieke some hayekeme. Pate Dieikopeta꞉ kesema꞉ hata꞉ da hao hayeke some yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisa꞉kema꞉ta꞉ Iso pa꞉ta꞉ta꞉ pukima꞉ homeekeme. Pa ekipeke ipikana꞉ma꞉ta꞉ mo Isoma꞉ lia꞉tiki pieke hotekemanu tendema꞉ homa na꞉tiki piekeme. Pate Lepekama꞉ta꞉ Dieikope pa꞉ta꞉ pukima꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Nate ma꞉nda꞉na꞉ Dieikopeta꞉ pota꞉ka꞉ supu yankolo pitina꞉ Isota꞉ eiya꞉na꞉ hao tea꞉ma꞉ homa opolo epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Kutupa Isoma꞉ Dieikope pa꞉ta꞉ alota꞉ I̱ta꞉ tea꞉ma꞉ amba꞉ homoloma꞉ mo wepiki ale ma꞉nda꞉ kie leekeme. Koto ekina꞉ ipikita꞉ Idomo lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Dieikopema꞉ hombo peaaso alota꞉ Nakana꞉ma꞉ I̱ mupeke wekina꞉ anke teke mulu polo ekina꞉ a꞉pa꞉la꞉me leka꞉na꞉ta꞉ kota꞉ neke pa꞉ta꞉ kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Koto leeke Isoma꞉ alota꞉ I̱ta꞉ tea꞉ma꞉ teke pa꞉ta꞉ homoloma꞉ koto mupeke wekina꞉ mulu polo anke tekema꞉ I̱ eki a꞉nda꞉ na piliekema꞉ pa a꞉pa꞉la꞉ma꞉ alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kutupa Dieikopema꞉ hombo peaaso alota꞉ Titina꞉ amba꞉la꞉ naka꞉ mupeke wekina꞉ mulu pele anke teketa꞉ I̱ kulueke laa pi amba꞉la la꞉ wie leekeme. Kota꞉ Isoma꞉ pi la꞉ witolo hata꞉ mo mupeke wekina꞉ mulu pieke anke teketa꞉ Dieikope pa꞉ta꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kutupa Dieikopema꞉ta꞉ hameke pa꞉ta꞉ betedi make mandane supu make haleekeme. Kutupa Isoma꞉ mo ne ikali naa mina꞉pa꞉lao tiao peekeme. Kotota꞉ Isoma꞉ ipika꞉ mupeke wekina꞉ anketeke mulu pieke ekina꞉ hone wieke ekita꞉ pa koto yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Koto kenke pa꞉ta꞉ta꞉ mo hande amba꞉ titina꞉ Eipoloha꞉ma꞉ hayeke dina꞉ epeeke tea꞉ kima꞉ handekeeki paa epeekeme. Kota꞉ Aisa꞉keta꞉ mo Kita daoni nane mo Pilisidaini wanda꞉halina꞉ kini Abimeleke hayeke nane peekeme. A̱i̱ na peeke haena꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","mo Tekehalima꞉ Aisa꞉ke pa꞉ta꞉ peneme yao hata꞉ alota꞉ Idiepi kenke nane na peke do I̱ma꞉ hae alo kenkena꞉ kone hapeke. ");
INSERT INTO ssx_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","I̱ma꞉ neke yaapo hata꞉ neke epealuekema꞉ do pate hapeke. I̱ma꞉ta꞉ do kenke paeyaota꞉ neke pa꞉ta꞉ make kia naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki pa꞉ta꞉ make halueke. Kutupa I̱ma꞉ta꞉ naka꞉ apa꞉ Eipoloha꞉ma꞉ yaapo la꞉ upa꞉ pita꞉ paa wilieke. ");
INSERT INTO ssx_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I̱ma꞉ta꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ oli yana꞉ hala꞉ hombulanka꞉manu hala꞉ tupa꞉ haena꞉ kulueke. Kutupa iki pa꞉ta꞉ta꞉ do kenke paeyao halueke. I̱ma꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki pa꞉ta꞉ yama꞉ta꞉ mo tutu paeyao sikita꞉ epeaasa꞉eki mina꞉ lolueke. ");
INSERT INTO ssx_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kota꞉ Eipoloha꞉ma꞉ma꞉ta꞉ yaka pi make yaka lo pimanu make opua miniki haya꞉ ekina꞉ta꞉ I̱ma꞉ta꞉ neke epealueke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Koto ekina꞉ Aisa꞉keta꞉ Kita daoni pa꞉ta꞉ hao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kutupa koto pa꞉ta꞉ haemeke haliwekima꞉ alota꞉ Mo wanda꞉ta꞉ epi yaka꞉ta꞉pe lemeke handaata꞉ ipika꞉ ana꞉e leekeme. Ipikana꞉ma꞉ ipika꞉ wanda꞉e pi na leeke ekita꞉ Lepekata꞉ wanda꞉ seliapo yalo hata꞉ koto pate haemeke haliwekima꞉ Lepeka muluekema꞉ ipiki liaama꞉na꞉ laa paala꞉ma꞉ homolo hata꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Kutupa Aisa꞉ke koto kenke pa꞉ta꞉ natemanu hosiki haena꞉ laa mo kini hali Abimeleketa꞉ ipika꞉ winido pa꞉ta꞉ handa꞉niayekepate Aisa꞉kema꞉ta꞉ Lepeka telepo la꞉tiaaso pitipekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kutupa Abimelekema꞉ Aisa꞉ke handa꞉ mulu pena꞉ la alota꞉ Kota꞉ naka꞉ wanda꞉ ya꞉ka꞉ta꞉me. Pa ekipeke naka꞉ ana꞉e la pelepe leekeme. Aisa꞉kema꞉ hombo peaaso alota꞉ Yaka honema꞉ta꞉ Yaka wanda꞉e loa꞉ka꞉na꞉ta꞉ kota꞉ I̱ limikie hone ua꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelekema꞉ alota꞉ Nakana꞉ma꞉ niki pa꞉ta꞉ eki hau pea pelepe. Mo yaka hali ma꞉nda꞉ma꞉ naka꞉ wanda꞉ yaapo ana꞉na꞉ polu pia꞉me. Nikana꞉ma꞉ koto hoke hau puma꞉ka꞉na꞉ yoluta꞉ kota꞉ teketa꞉ neke kone yolo pia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kutupa Abimelekema꞉ ipika꞉ wanda꞉hali paeyao pa꞉ta꞉ pi la꞉ witolo alota꞉ Ma꞉nda꞉ epima꞉ do hali o ipika꞉ wanda꞉ hoke tupa꞉ handeteke haya꞉ka꞉na꞉ta꞉ kota꞉ koto someta꞉ lu homaena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Kutupa Koda꞉ma꞉ Aisa꞉ke epeayeke ekiyalo hata꞉ ipikana꞉ma꞉ koto kenke pa꞉ta꞉ wae alemanu nokopeeketa꞉ mo nokopeeke bapina꞉ta꞉ ota꞉ anekema꞉ haka꞉ta꞉pake napeke tieke mia꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Kutupa ala꞉ta꞉ ala꞉ta꞉ wopu mutia pea꞉eki yalo hata꞉ ota꞉ hamoko hali hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Aisa꞉keta꞉ sipisipi wopu make kaomanu wopu make e pokaasa꞉ haliweki wopu make yalo hata꞉ mo Pilisidaini tapakema꞉ta꞉ we pambemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Koto ekina꞉ Ikana꞉ma꞉ta꞉ mo hande ipika꞉ ateke Eipoloha꞉ma꞉ pa hata꞉ ipika꞉ e pokaemeke haliwekima꞉ awemeke naku ikalimanu pa kenke ao tumbaemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kutupa Abimelekema꞉ Aisa꞉ke pa꞉ta꞉ alota꞉ Neketa꞉ niki ankulake wele ula꞉ma꞉ nika꞉ kenke mina꞉pa꞉lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Koto ekina꞉ Aisa꞉kema꞉ta꞉ mina꞉pa꞉lao mo Kita hadipina꞉ palai da pua a꞉eyekeme. Koto pa꞉ta꞉ta꞉ nate mandane ekina꞉ ");
INSERT INTO ssx_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Koto pateta꞉ mo hande Eipoloha꞉ma꞉ hayeke natena꞉ naku ikalimanu aweekepate Eipoloha꞉ma꞉ homeeke dina꞉ta꞉ mo Pilisidaini tapakema꞉ta꞉ ao tumbaemekeme. Koto naku ikali manuta꞉ Aisa꞉kema꞉ pa aweekeme. Ipikana꞉ma꞉ mo naku ikali biki manuta꞉ atekema꞉ leekeeki kone paa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Aisa꞉kena꞉ e pokaemeke haliwekima꞉ta꞉ mo hadipina꞉ panake naku ikali awa ikali handa꞉ wimikime. ");
INSERT INTO ssx_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Kutupa mo Kita kenke pa꞉ta꞉ sipisipi handeteke haemeke haliwekima꞉ mo Aisa꞉kena꞉ sipisipi handeteke haemeke haliweki ame̱le̱ hankiliki yololo hata꞉ alota꞉ Do ikalita꞉ nika꞉ ekie lemeke handaa Aisa꞉kema꞉ mo naku ikalina꞉ bikita꞉ Hankilikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kutupa Aisa꞉kena꞉ e pokaemeke haliwekima꞉ naku ikali ma꞉nda꞉ awemekepate koto ekina꞉ make ape hankiliki ombu yolemeke handaa mo naku ikalina꞉ bikita꞉ A꞉nda꞉ Pita꞉la꞉ekie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Kutupa Aisa꞉kema꞉ta꞉ koto pate mina꞉pa꞉lao pua naku ikali ma꞉nda꞉ aweekeme. Koto ekina꞉ta꞉ hankiliki na yolemeke handaa ipika꞉ bikita꞉ Lihobodi (nika꞉ da pita꞉ Ka꞉la꞉pa꞉ Tapaala꞉me) leekeme. Kutupa ipikana꞉ma꞉ alota꞉ Niki do kenkena꞉ hamono Tekehalima꞉ niki ka꞉la꞉pa꞉ tapaala꞉me. Koto ekina꞉ ameta꞉ do pateta꞉ ala꞉ta꞉ ala꞉ta꞉manu ana꞉na꞉ kone wia halumeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kotoeki hoki naneta꞉ Aisa꞉keta꞉ pao mo Biasiba nane peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Koto timba Tekehalima꞉ ipiki pa꞉ta꞉ peneme yao alota꞉ I̱ta꞉ naka꞉ apa꞉ Eipoloha꞉ma꞉na꞉ Koda꞉e. Koto ekina꞉ paala꞉ma꞉ na homa꞉pee. I̱ta꞉ neke yaapo halome. Kutupa I̱ma꞉ mo yaka e pokaeya꞉ hali Eipoloha꞉ma꞉ pa꞉ta꞉ pi la꞉ ua꞉ ekina꞉ta꞉ neke epeaaso hata꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ tieke kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Koto pateta꞉ Aisa꞉kema꞉ oloda wepia Tekehali pa꞉ta꞉ yeni hau piekeme. Kutupa ipikana꞉ma꞉ ipika꞉ palai da koto pate a꞉eyeketa꞉ ipika꞉ e pokaemeke haliwekima꞉ta꞉ koto pate naku ikali ma꞉nda꞉ awemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleketa꞉ ipika꞉ hone u tiao hayeke hali Ahusa꞉de make ipika꞉ amina꞉ you hali Pikolo ame̱le̱ Aisa꞉ke handulueke alo Kita nanema꞉ epemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Koto ekina꞉ Aisa꞉kema꞉ lota꞉ pitolo alota꞉ Amba꞉ta꞉ I̱ pa꞉ta꞉ a꞉nda꞉ lia naka꞉ kenke mina꞉pa꞉lao pue le ale pa ameta꞉ ekipeke I̱ handolo a꞉pa pelemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ikana꞉ma꞉ hombo peaaso alota꞉ Ameta꞉ Tekehalita꞉ neke ame̱le̱ hala꞉eki handolo hata꞉ nika꞉ honema꞉ta꞉ neke niki ame̱le̱ pi tonkao umana꞉e. Nika꞉ honema꞉ta꞉ niki pa꞉ta꞉ pi dupa la꞉ uelena꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Mo nikana꞉ma꞉ neke na hoeyaoma꞉ tupa꞉ nakana꞉ma꞉ niki make na hoeyalena꞉ pi la꞉ uelena꞉ loa꞉me. Nikana꞉ma꞉ta꞉ neke pa꞉ta꞉ a꞉ta꞉ma꞉ homolo hata꞉ yopu kone mina꞉pa꞉lao poelena꞉ loma꞉me. Koto ekina꞉ ameta꞉ mo Koda꞉ma꞉ neke epeala꞉ ekita꞉ peneme yala꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kutupa Aisa꞉kema꞉ta꞉ ika꞉ ne pambaeyeke handaa ne ikali nemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Da kelepeeketa꞉ hali homeke homekema꞉ ika꞉ la wimiki pita꞉ keke pima꞉ tonkao wimikime. Kutupa Aisa꞉kema꞉ mo haliweki pa꞉ta꞉ a꞉taloe leeketa꞉ yankeke tonu au laa pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Koto natena꞉ kone Aisa꞉kena꞉ e pokaemeke haliwekima꞉ naku ikali ma꞉nda꞉ awemekeeki a꞉pa la halolo hata꞉ alota꞉ Ikali handa꞉ uluma꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ipikana꞉ma꞉ koto naku ikalina꞉ bikita꞉ Pi La꞉ Wita꞉la꞉ Ekie leekeme. Kotota꞉ mo hande Biasiba daoni ipika꞉ biki mieke tupa꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iso ipiki 40 bapi mieketa꞉ Hidi wanda꞉ yaapo miekeme. Ipilikita꞉ Bitina꞉ waneke Diudi make Elonina꞉ waneke Basema꞉de yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Mo wanda꞉ yaapoma꞉ta꞉ Aisa꞉ke pita꞉ Lepeka yaapo ka꞉nda꞉ma꞉ homaepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisa꞉keta꞉ ameta꞉ koke yaa leke holu piekeme. Ipikana꞉ma꞉ ipika꞉ mupeke weki Iso wi la꞉ mea alota꞉ Yaka wekio leekeme. Mo wekima꞉ hombo peaaso alota꞉ Wae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Koto leeke Aisa꞉kema꞉ alota꞉ Ameta꞉ I̱ koke ya homolo poloeki teke pa꞉ta꞉ ya꞉la꞉ ekita꞉ do handele handa꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Koto ekina꞉ naka꞉ semoko a꞉ndeli mea oni hapekena꞉ pua hoteke ma꞉nda꞉ lia a꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kutupa mo yaka hone pa꞉la꞉ tendepiki ne yankao I̱ pa꞉ta꞉ mea a꞉pa꞉peke. Kutupa naa pita꞉ta꞉ mo I̱ homuluekema꞉ pita꞉ yaka paeyaaso epeaasa꞉eki neke kuluekema꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Kutupa Aisa꞉kema꞉ Iso pa꞉ta꞉ pi la haleeketa꞉ Lepekama꞉ opu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Kutupa ipikana꞉ma꞉ Dieikope pa꞉ta꞉ alota꞉ Naka꞉ apa꞉ma꞉ Iso pa꞉ta꞉ lea꞉eki I̱ma꞉ dupa opolome. ");
INSERT INTO ssx_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Hoteke ma꞉nda꞉ mea a꞉pa yaka hone pa꞉la꞉ tendepiki ne yankapeke. Kutupa naa pita꞉ta꞉ I̱ homuluekema꞉ pita꞉ Tekehalina꞉ leke popelekena꞉ neke pa꞉ta꞉ yaka epeaasa꞉eki kuluekema꞉ loa꞉me lea꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kutupa Lepekama꞉ ombu alota꞉ Yaka wekio. Ameta꞉ I̱ma꞉ alo pi opua pie. ");
INSERT INTO ssx_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Oni ma꞉na꞉manu hala꞉ pa꞉ta꞉ pua panka wiki nanikosi ikiki yaapo mea epoe. Koto ekima꞉ta꞉ mo naka꞉ apa꞉na꞉ ta꞉na꞉ma꞉ homo hala꞉ ne yankaluekema꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kutupa ipikana꞉ma꞉ nena꞉ nakana꞉ma꞉ mea pekena꞉ta꞉ kota꞉ ipiki homuluekema꞉ pita꞉ ipika꞉ epeaasa꞉ ekita꞉ neke kina꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Pate Dieikopema꞉ ipika꞉ ama꞉ pa꞉ta꞉ alota꞉ Isota꞉ itiki pelipa pa꞉la꞉pate yaka loketa꞉ homu pa꞉la꞉me laa hone wilime. ");
INSERT INTO ssx_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ma꞉nda꞉ta꞉ yaka apa꞉ma꞉ I̱ watao I̱ma꞉ ipiki makeaasoma꞉ laa I̱ handa꞉ wiaapa꞉na꞉e. Dupua꞉ka꞉na꞉ta꞉ kota꞉ mo epeaasa꞉eki mina꞉la꞉ tupa꞉ paa yaka kone I̱ pa꞉ta꞉ esihou pi mea epena꞉ lapeke yeke loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Koto leeke ipika꞉ ama꞉ma꞉ hombo peaaso alota꞉ Yaka wekio. Koto ipilia꞉ esihou pi manuta꞉ I̱ pa꞉ta꞉ epena꞉ma꞉ pa mo I̱ma꞉ aloeki pua pie. Mo nanikosi yaapo pua meawae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Koto leeke Dieikopema꞉ mo nanikosi yaapo mulu pua inkiki pa꞉ta꞉ mea epeekeme. Kutupa mo wanda꞉ma꞉ta꞉ mo wekina꞉ atekema꞉ ta꞉na꞉ma꞉ homeeke nema꞉ handekeeki yankaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kutupa mo wanda꞉ma꞉ oni da pa꞉ta꞉ Isona꞉ amu pea wiayeke dau manuta꞉ mea Dieikopena꞉ pambawaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Mo nanikosi yaapona꞉ yonkeleke manuta꞉ mo wekina꞉ kiki yaapona꞉ pambawaeyeke make kutupa ipika꞉ itiki na pelieke alena꞉ tonka꞉na꞉ pambawaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Mo wanda꞉ma꞉ta꞉ mo weki pa꞉ta꞉ mo tendepiki ne make mo yankeeke betedi make haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kutupa Dieikope ipika꞉ apa꞉ pa꞉ta꞉ pua alota꞉ Apa꞉o leekeme. Atekema꞉ hombo peaaso alota꞉ Wae. Neketa꞉ weki epi yaka꞉ta꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Dieikopema꞉ hombo peaaso alota꞉ I̱ta꞉ naka꞉ mupeke weki Isoe. I̱ma꞉ta꞉ naka꞉ hande pea꞉pekee le hau pealome. Koto ekina꞉ mo epeaasa꞉ ekimanu I̱ pa꞉ta꞉ kuelena꞉ma꞉ pilisi tiao pita꞉ mo I̱ma꞉ mea a꞉palo hoteke nae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Koto leeke Aisa꞉kema꞉ alota꞉ Yaka wekio. Ekipa a̱i̱ handa꞉ wia pelepe leekeme. Dieikopema꞉ hombo peaaso alota꞉ Mo Tekehali naka꞉ Koda꞉ma꞉ handa꞉ wiono I̱ tamba꞉ mia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Aisa꞉kema꞉ Dieikope pa꞉ta꞉ alota꞉ Pilisio. I̱ma꞉ neke wataalo polo tupa꞉ teke pa꞉ta꞉ epoe. Neketa꞉ ota꞉ Iso ka꞉ta꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Dieikopeta꞉ ipika꞉ apa꞉ pitia꞉ alena꞉ paa teke pa꞉ta꞉ pua pitiekeme. Kutu pieke atekema꞉ watao alota꞉ Naka꞉ pi ho̱la̱꞉maketa꞉ Dieikopena꞉ ekima꞉ handa꞉la꞉pate pa naka꞉ kikita꞉ Isona꞉ kiki wataake nono pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ipikana꞉ma꞉ Dieikopee laa na handa꞉ wieke ekita꞉ mo ipika꞉ kiki manuta꞉ Isona꞉ ekima꞉ handa itiki pelipa peeke ekima꞉ piekeme. Ipikana꞉ma꞉ ipika꞉ epeaasa꞉ ekimanu teke pa꞉ta꞉ haluekema꞉ pitiekepate kone ");
INSERT INTO ssx_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","paa lota꞉ pitolo alota꞉ Neketa꞉ ota꞉ Iso ka꞉ta꞉pe leekeme. Mo wekima꞉ hombo peaaso alota꞉ Aowe I̱e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kota꞉ Aisa꞉kema꞉ alota꞉ Mo mandane hoteke mea a꞉pae. Naa pita꞉ta꞉ yaka epeaasa꞉eki neke pa꞉ta꞉ kulueke leekeme. Koto leeke Dieikopema꞉ta꞉ ne mea a꞉pao make nolo pieke waini ikali make mea a꞉paeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kutupa mo weki pa꞉ta꞉ ipika꞉ apa꞉ma꞉ alota꞉ Yaka wekio. I̱ teke pa꞉ta꞉ a꞉pa I̱ nunu pie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ipikana꞉ma꞉ ateke nunu pulueke alo hata꞉ teke pa꞉ta꞉ epea꞉ dina꞉ta꞉ Aisa꞉kema꞉ mo yameeke aka꞉manu totopo mu hao ipika꞉ epeaasa꞉ ekimanu haleekeme. Ipikana꞉ma꞉ alota꞉ Do yaka wekina꞉ totopo epeke pita꞉la꞉ ekita꞉ mo hande Tekehalima꞉ epeala꞉ hama꞉na꞉ totopoma꞉ handa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Koda꞉ma꞉ oli ya nanema꞉ ekepipida꞉ kitolo naka꞉ hama꞉manu ne tieke wina꞉e. Kutupa widi make waini ikali make wopu kina꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Tutu manuta꞉ naka꞉ e pokaasa꞉ tapake haena꞉e. Kutupa wanda꞉hali neke pa꞉ta꞉ panda꞉puniaena꞉e. Naka꞉ tapake paeyao handeteke halena꞉e. Naka꞉ ama꞉na꞉ monduma꞉ monduma꞉ pa꞉la꞉ wekiwandikina꞉ wekiwandikima꞉ neke pa꞉ta꞉ panda꞉puniaena꞉e. Mo neke pa꞉ta꞉ esihou tunkilimi tapaketa꞉ esihou pa꞉ta꞉ haena꞉e. Kutupa neke epealimi wanda꞉halita꞉ iki make epeaasa꞉eki mina꞉e laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisa꞉kema꞉ ipika꞉ epeaasa꞉eki halaa Dieikope pulu haena꞉ta꞉ ipika꞉ hameke eiya꞉na꞉ hao honda꞉ pambolo epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ipikana꞉ma꞉ make tendepiki ne yankao ateke pa꞉ta꞉ mea pua alota꞉ Pilisi apa꞉o. Mo naka꞉ epeaasa꞉eki I̱ pa꞉ta꞉ kuelena꞉yeke I̱ma꞉ do mea a꞉palo hoteke ma꞉nda꞉ noelena꞉ tiao pitie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aisa꞉kema꞉ hombo peaaso alota꞉ Neketa꞉ epi ya꞉ka꞉ta꞉pe leekeme. Ipikana꞉ma꞉ hombo peaaso alota꞉ Naka꞉ mupeke weki Isoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aisa꞉keta꞉ tola꞉tia pominolo hata꞉ pututu liaaso alota꞉ Mo hoteke lia I̱ pa꞉ta꞉ mea epea꞉ta꞉ epi ya꞉ka꞉ta꞉pe. Neke amba꞉ do honda꞉ pambolo ipuluekema꞉ halena꞉ kone noa꞉me. Yaka paeyaaso epeaaso ekita꞉ ipiki pa꞉ta꞉ haloa꞉ma꞉ ameta꞉ ota꞉ ipika꞉eki homeke u halieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Isoma꞉ doeki opu haota꞉ ka꞉pa꞉puki yoka anekema꞉ e̱ wi tieke alo hata꞉ alota꞉ Apa꞉o. I̱ make naka꞉ epeaasa꞉eki kie laa honke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Aisa꞉kema꞉ hombo peaaso alota꞉ Naka꞉ kamema꞉ I̱ a꞉pa makeaaso naka꞉ epeaasa꞉eki mea pu moneala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Isoma꞉ alota꞉ Dota꞉ ipika꞉ hoto yaapo peao I̱ makeala꞉me. Koto ekina꞉ ipika꞉ biki Dieikopeta꞉ ota꞉ ana꞉piki tupa꞉ laa pimika꞉ta꞉me. Ipikana꞉ma꞉ta꞉ yaka mupeke wekina꞉ anke teke mulu poloeki make mea ameta꞉ yaka epeaasa꞉eki make mea pua pika꞉ta꞉me. Koto ekina꞉ I̱ta꞉ epeaasa꞉eki ma꞉nda꞉ na panka꞉ wialepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aisa꞉kema꞉ hombo peaaso alota꞉ I̱ma꞉ta꞉ ipikana꞉ma꞉ neke ankulao you haena꞉ laa ipika꞉ tapakemanu maketa꞉ ipika꞉ pa hameke e pokaasa꞉ tapake haena꞉ loa꞉me. I̱ma꞉ta꞉ widi make waini ikali make haloa꞉me. Ota꞉ yaka wekio. Neke pa꞉ta꞉ pulu polo ekita꞉ ma꞉nda꞉ dia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Koto leekepate kone Isoma꞉ta꞉ ateke pa꞉ta꞉ honke ombu alo hata꞉ alota꞉ Apa꞉o. Mo epeaasa꞉eki homeke siki make ota꞉ ma꞉nda꞉ na wilipe. Apa꞉o. I̱ make epeae alo hata꞉ e̱ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Kota꞉ Aisa꞉kema꞉ ipiki pa꞉ta꞉ alota꞉ Oli ya nanema꞉ ekepipida꞉ neke ma꞉nda꞉ na kina꞉e. Kenke epeke wiki hama꞉ ma꞉nda꞉ dia꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Neketa꞉ naka꞉ bainasi yaapo hao pelipikie. Pate neketa꞉ naka꞉ kamena꞉ pa hameke e pokaasa꞉ hali halipikie. Kutu pulu pa꞉la꞉pate wetepena꞉ a꞉nda꞉ liata꞉ mo ipika꞉ handeteke halia꞉eki pendulu bao pelipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Atekema꞉ mo hande epeaasa꞉eki hameke pa꞉ta꞉ haleeke handaa Isoma꞉ta꞉ Dieikope honditi piekeme. Ipika꞉ honema꞉ alota꞉ Yaka apa꞉ta꞉ teke pa꞉ta꞉ homolo pa꞉la꞉ ekina꞉ ipika꞉ homa꞉ da pitulu polo ekita꞉ teke pa꞉ta꞉ ya꞉la꞉ma꞉ Dieikope homena꞉ lulueke hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Pate Lepekama꞉ Isona꞉ pulueke leeke ekimanu amba꞉ opu hao Dieikope epoa꞉ la alota꞉ Opie. Naka꞉ kame Isoma꞉ta꞉ hombo peaaso hata꞉ neke lu homalueke ala꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Koto ala꞉ma꞉ yaka wekio. I̱ma꞉ pie aloeki pia꞉peke. Mo yaka ana꞉ Leibeni hala꞉ alena꞉ Hatani nane ame do kone pue. ");
INSERT INTO ssx_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Kutupa ipiki yaapo hosiki haota꞉ mo naka꞉ kamena꞉ mineke panka꞉la꞉eki uniao ");
INSERT INTO ssx_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ipiki pa꞉ta꞉ peleeki hone yonka꞉laena꞉ loa꞉me. Kutupa neke handa꞉ mulu epena꞉ta꞉ ma꞉nda꞉ tapaalueke. I̱ma꞉ta꞉ pa ekipeke yaka weki yaapo homeke natena꞉ alupalua꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Lepekama꞉ Aisa꞉ke pa꞉ta꞉ alota꞉ Do Isona꞉ da ma꞉nda꞉ wanda꞉ yaapo handa꞉peketa꞉ I̱ta꞉ ota꞉ ki tieke pea soka꞉la꞉ pita꞉la꞉me. Dieikopema꞉ make do Hidi wandiki tonu ma꞉nda꞉ mia꞉ka꞉na꞉ta꞉ kota꞉ I̱ta꞉ homa꞉peke make ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Aisa꞉kema꞉ Dieikope wi la ta꞉na꞉ma꞉ homa alota꞉ Keinani wanda꞉ ma꞉nda꞉ na mia꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kotoeki na pikita꞉ mo naka꞉ mei Beduelona꞉ da kenke Mesopoteimia nane pua mo naka꞉ awa꞉ Leibenina꞉ waneke tonu ma꞉nda꞉ hondo mea꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kutupa neketa꞉ tutu eleke elekena꞉ apa꞉ halena꞉ yeke mo Aneke Wele Wopupiki Koda꞉ma꞉ naka꞉ wanda꞉ milipi pa꞉ta꞉ neke epeaaso hata꞉ wekiwandiki wopu kina꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kutupa ipikana꞉ma꞉ta꞉ Eipoloha꞉ma꞉ epeaaso pia꞉ tupa꞉ neke make naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki paeyao epeaena꞉e. Kutupa make do neke hae kenketa꞉ mo Koda꞉ma꞉ mo Eipoloha꞉ma꞉ halea꞉ kenke ya꞉la꞉ ekina꞉ nakana꞉ma꞉ muelena꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kutupa Aisa꞉kema꞉ Dieikopeta꞉ mo Iso pita꞉ Dieikope yaapona꞉ inkiki Lepekana꞉ beliki A꞉ta꞉mia hali Bedueloma꞉ mondu wieke hali Leibeni hayeke alena꞉ mo Mesopoteimia nane pena꞉ tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Aisa꞉kema꞉ta꞉ Dieikope epeao mo Mesopoteimia nane wanda꞉ weilu pena꞉ tapaeyekeeki Isoma꞉ opiekeme. Kutupa make Aisa꞉kema꞉ mo weki epeaaso hata꞉ Keinani wanda꞉ ma꞉nda꞉ ota꞉ na mea꞉peke leekeeki opiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Kutupa make Dieikopema꞉ta꞉ ipika꞉ apa꞉ ama꞉ yaapona꞉ pi opua Mesopoteimia nane amba꞉ peekeeki opiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Koto opiekeeki manuma꞉ta꞉ ipika꞉ atekema꞉ mo Keinani wanda꞉weki ota꞉ kiayekeeki hando hao ");
INSERT INTO ssx_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Isoma꞉ta꞉ mo Eipoloha꞉ma꞉na꞉ eiyeke Isima꞉elona꞉ waneke Mahala꞉di mulu peekeme. Mahala꞉dita꞉ Nebeiotona꞉ beliki yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Dieikopeta꞉ Biasiba mina꞉pa꞉lao Hatani poluekema꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nate pambolo pulu haena꞉ta꞉ ale ma꞉nda꞉na꞉ opolo a꞉paata꞉ koto pa꞉ta꞉ peliekeme. Ipikita꞉ mo toopina꞉ ka꞉nda꞉ lia polueke alo polu holepeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Kutupa upa pitolota꞉ pota꞉ lapa꞉ ma꞉nda꞉ kenkena꞉ wia a꞉pa yotuao oli ya nane pekeeki handeekeme. Mo pota꞉ lapa꞉na꞉ta꞉ enisolomanu olina꞉ pua꞉tiki onina꞉ hola꞉pa꞉tiki pimikieki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kutupa mo Tekehalita꞉ ipiki teke pa꞉ta꞉ a꞉pa hata꞉ alota꞉ I̱ta꞉ mo Eipoloha꞉ma꞉ pita꞉ Aisa꞉ke yaapona꞉ Tekehali Koda꞉e. I̱ma꞉ta꞉ do neke pelipa꞉lia hale kenketa꞉ neke pa꞉ta꞉ make kia naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki pa꞉ta꞉ make halueke. ");
INSERT INTO ssx_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ikita꞉ do kenkena꞉ ula꞉ na yata꞉pea꞉peke ya꞉la꞉ dokolo paeyaoma꞉ handilimikie. Ikita꞉ ika꞉ da kenketa꞉ do kenke nepoko paeyao pa꞉ta꞉ putupolo baalieke. I̱ma꞉ta꞉ neke pa꞉ta꞉ yama꞉ make naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki pa꞉ta꞉ yama꞉ make tutu paeyao epealueke. ");
INSERT INTO ssx_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Niminalo pele ekita꞉ dupae. I̱ta꞉ neke yaapo mandakena꞉ hata꞉ hane pekena꞉ make neke handeteke halueke. Kutupa neketa꞉ do kenke pa꞉ta꞉ paa hatuku ipulueke. I̱ma꞉ta꞉ mo pi la꞉ ulueki paeyaaluekema꞉ta꞉ neketa꞉ na mina꞉pa꞉lalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Dieikopema꞉ u tiao alota꞉ Mo Tekehalita꞉ do haya꞉ka꞉ta꞉me. Ipikita꞉ do pate haena꞉ kone hone na wia pua꞉ka꞉ta꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Kutupa ipikita꞉ pala꞉ haaso hata꞉ alota꞉ Dota꞉ ota꞉ paala꞉piki alena꞉e laata꞉ Koda꞉na꞉ da yalo pa꞉la꞉me. Oli hepeni nane pula꞉ pota꞉ kake lomba꞉la꞉ alena꞉ yalo pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kutupa ota꞉ da ka꞉la꞉paaso siki Dieikope tiao mo ipika꞉ hande ka꞉nda꞉ lia pelieke toopita꞉ hone u tialo piekeeki mea nokopeekeme. Kutupa mo toopi mandata꞉ olipi oeta holaa alota꞉ Dota꞉ Koda꞉na꞉ ekie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Kutupa koto pateta꞉ Bedele leekeme. Koto pateta꞉ amba꞉ta꞉ Lusu lemeke alena꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kutupa Dieikopema꞉ Tekehali pa꞉ta꞉ pi la꞉ witolo alota꞉ Kota꞉ neketa꞉ I̱ yaapo haeka꞉na꞉ta꞉ kota꞉ mo I̱ pulu pota꞉ kimisuta꞉ nakana꞉ma꞉ handeteke hao ne make aka꞉ make kika꞉na꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","kutupa I̱ paa yaka apa꞉na꞉ da nane epeke tupa꞉ la꞉ka꞉la yapono leka꞉na꞉ta꞉ kota꞉ neketa꞉ yaka Koda꞉ yelieke. ");
INSERT INTO ssx_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kutupa do paa hone ua꞉tiki poluekema꞉ nokopolo toopita꞉ mo neke pa꞉ta꞉ panda꞉puniao yeiya꞉ lalo polo alena꞉e. Kutupa I̱ma꞉ta꞉ mo I̱ kilipi ale paeyaota꞉ putupa kiki homekena꞉ mandane tonkoputa꞉ yaka minolo homeketa꞉ neke kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Dieikope ipika꞉ pota꞉ kini pea pua mo nate opa꞉la꞉ nanema꞉ kenke nane pulu ombu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Kutupa paa peekepate nate ma꞉nda꞉na꞉ kenke ma꞉nda꞉ pa꞉ta꞉ pa mone wieke naku ikali ma꞉nda꞉ pua handa꞉ wiekeme. Kutupa sipisipi tapake tepo mo naku ikali hopa꞉liao pelia yapemekeeki handeekeme. Mo naku ikali kakena꞉ta꞉ toopi tiekema꞉ mea a꞉mbaemekeme. Mo koto ikalita꞉ mo sipisipi ma꞉na꞉manu ikali no halo haemekeekie. ");
INSERT INTO ssx_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kutupa mo tapake tapake paeyaona꞉ sipisipimanu paeyao koto homeke alena꞉ a꞉pa꞉tiki pimikita꞉ kota꞉ mo sipisipi handeteke haemeke haliwekima꞉ta꞉ mo toopi aneke mea petepete yao ikali no hala꞉tiki pimikime. Kutupa paeyeketa꞉ mo hande toopi paa mea wia꞉tiki pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Dieikopema꞉ mo sipisipi handeteke haemeke haliweki lota꞉ pitolo alota꞉ Yaka yankeke tonuo. Ikita꞉ hane tapake ya꞉ka꞉ta꞉pe leekeme. Ikana꞉ma꞉ hombo peaaso alota꞉ Hatani nanee lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ipikana꞉ma꞉ lota꞉ pitolo alota꞉ Neihona꞉ eiyeke Leibenita꞉ handelemepe leeke mo tapakema꞉ alota꞉ Aowe. Handoloma꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Koto leeke alota꞉ Ipikita꞉ epeke tupa꞉ hala꞉pe leekeme. Ikana꞉ma꞉ hombo peaaso alota꞉ Ipikita꞉ epeke tupa꞉ hala꞉me. Handa꞉taa. Ipika꞉ waneke Leisolota꞉ atekena꞉ sipisipimanu mea koto ipula꞉ handa꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Koto lemeke Dieikopema꞉ alota꞉ Nate pa hala꞉ ekina꞉ mo sipisipimanu mea a꞉pa꞉peke nate a̱i̱ dia꞉ma꞉ ikali hala ambumanu nena꞉ paa na hatuku pulimipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Mo tapakema꞉ hombo peaaso alota꞉ Nikana꞉ma꞉ta꞉ kotoeki a̱i̱ na pikita꞉ mo sipisipi paeyao ana꞉na꞉ a꞉pa haena꞉ laa mo toopi petepete yaota꞉ kota꞉ ikali no halumeke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Dieikopeta꞉ mo haliweki ame̱le̱ pi pa alo haena꞉ Leisolota꞉ mo sipisipimanu ame̱le̱ opolo epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kutu pieke Dieikopema꞉ta꞉ mo aweke Leibenina꞉ sipisipimanu pita꞉ Leisolo epea꞉eki hata꞉ta꞉ oni naku ikali pa꞉ta꞉ pua mo toopi mea petepete yao mo sipisipimanu ikali no hale hale piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kutupa ipikana꞉ma꞉ta꞉ mo wandiki nunu pitolo hata꞉ ta꞉na꞉ pitolo kone e̱ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Kutupa mo wandiki pa꞉ta꞉ alota꞉ I̱ta꞉ Lepekana꞉ eiyeke naka꞉ apa꞉na꞉ tapakee leekeme. Koto leeke mo wandikita꞉ ipika꞉ apa꞉ lolueke alo a̱i̱ya peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kutupa atekema꞉ mo belikina꞉ eiyeke Dieikope epeekeeki opu haota꞉ a̱i̱ya manda꞉hande pulu pua hopula nunu piekeme. Kutupa mo da pa꞉ta꞉ hatuku epeekeme. Kota꞉ Dieikopema꞉ Leibeni pa꞉ta꞉ mo piekeeki paeyao la haleeke handa ");
INSERT INTO ssx_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Leibenima꞉ alota꞉ Aowe. Ota꞉e. Neketa꞉ yaka loke homeke make we homekee leekeme. Kutupa Dieikopeta꞉ sumba꞉ homeke koto pa꞉ta꞉ hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Leibenima꞉ Dieikope pa꞉ta꞉ alota꞉ Neketa꞉ ya wanda꞉ma꞉ mendiki ya꞉la꞉ ekina꞉ yaka e pahameke pokaalueke hone na wikita꞉ yenki dupa mulueke laa lakie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Leibenina꞉ wandiki yaapo hayekeme. Mupeke wandikita꞉ Lia yekeme. Wetepe wandikita꞉ Leisolo yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liana꞉ leketa꞉ u homeekepate Leisolota꞉ epeke tupa꞉ lombeke wandiki seliapo yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Dieikopema꞉ta꞉ Leisolo hone wopu pieke handa alota꞉ Yaka hone pa꞉la꞉ yenkita꞉ nakana꞉ma꞉ I̱ Leisolo miono leka꞉na꞉ta꞉ kota꞉ I̱ma꞉ naka꞉ e bapi wataake hata꞉na꞉ pokaalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Leibenima꞉ hombo peaaso alota꞉ I̱ma꞉ta꞉ ma꞉nda꞉ pa꞉ta꞉ halo polo tupa꞉ta꞉ epeke ekita꞉ neke pa꞉ta꞉ homeke kuluekema꞉ I̱ yaapo do pate hapana꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Dieikopema꞉ta꞉ Leisolo mulueke alo hata꞉ta꞉ bapi wataake hata꞉na꞉ e pokeekeme. Ipikana꞉ma꞉ta꞉ Leisolo pukima꞉ homeekeeki yalo ipiki pa꞉ta꞉ta꞉ mo bapi manuta꞉ pa nate tepo a꞉nda꞉ hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kutupa Dieikopema꞉ Leibeni pa꞉ta꞉ alota꞉ Hande nateta꞉ do ma꞉la꞉ma꞉ naka꞉ wandiki miono lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Koto ekina꞉ Leibenima꞉ta꞉ wanda꞉ mina꞉la꞉ natena꞉ ne pambolo hata꞉ paeyaosiki wi leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pate koto timbata꞉ Dieikope pa꞉ta꞉ Leisolo na hatuku peketa꞉ Lia hatuku peekeme. Kutupa Dieikopema꞉ta꞉ mo wandiki yaapo loke apa꞉taeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Kutupa Leibenima꞉ta꞉ ipika꞉ wandiki Liana꞉ tamba꞉ mina꞉la꞉ wandiki ipika꞉ pa hameke e pokaasa꞉ wandiki Silipata꞉ Lia pa꞉ta꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Dieikopema꞉ta꞉ timba ipika꞉ wanda꞉ yaapo peliolome hone wiekepate da ka꞉la꞉paasota꞉ mo wanda꞉ta꞉ Lia ya꞉ka꞉ta꞉me laa hande wiekeme. Kutupa ipiki Leibeni pa꞉ta꞉ pua alota꞉ Nakana꞉ma꞉ I̱ pa꞉ta꞉ta꞉ do hauta꞉ ekipeke pea pipe. I̱ma꞉ta꞉ Leisolo muluekema꞉ e poka pua꞉ma꞉ nakana꞉ma꞉ I̱ta꞉ ekipeke makeao pipee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Leibenima꞉ hombo peaaso alota꞉ Mo mupeke wandiki pa haena꞉ wetepena꞉ wandiki amba꞉la halina꞉ da pena꞉ ala꞉ ekita꞉ do da hau dia꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Koto ekina꞉ nakana꞉ma꞉ paa bapi wataake hata꞉ ma꞉nda꞉na꞉ yaka e paa pokaalena꞉ kota꞉ do pula homeke mo ne pamba꞉la꞉eki paena꞉ laa Leisolo make neke kuluekema꞉ hando hae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Dieikopema꞉ a꞉pa꞉la꞉me laata꞉ mo ne pambeeke pula homeke paeyeketa꞉ Leibenima꞉ waneke Leisolo make Dieikopena꞉ wanda꞉ haena꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Leibenima꞉ ipika꞉ pa hameke e pokaasa꞉ wandiki Bilihata꞉ ipika꞉ wandiki Leisolona꞉ tamba꞉ mina꞉la꞉ wandiki haena꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Dieikopema꞉ta꞉ Leisolo yaapo make loke apa꞉taeyekeme. Kutupa telipuna꞉ pukima꞉ homeekepate Leisolota꞉ pukima꞉ wopu homeekeme. Kutupa ipikana꞉ma꞉ta꞉ paa bapi wataake hata꞉ Leibenina꞉ e paa pokaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Dieikopema꞉ Liata꞉ Leisolo pieke tupa꞉ pukima꞉ wopu na homeeke handaa mo Tekehalima꞉ta꞉ Liata꞉ wekiwandiki mendina꞉ leekepate Leisolota꞉ weki kenohali hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liata꞉ weki loke lomba hali weki mondu wiekeme. Ipikana꞉ma꞉ alota꞉ Mo Tekehalima꞉ta꞉ yaka ka꞉nda꞉ handa I̱ tamba꞉ ma꞉la꞉ ekina꞉ yaka halikima꞉ta꞉ ameta꞉ I̱ pukima꞉ homilieke leekeme. Koto ekina꞉ mo wekina꞉ bikita꞉ Lubeni leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Weki loke paa lomba hali weki ma꞉nda꞉ mondu wiekeme. Ipikana꞉ma꞉ alota꞉ Ya halikima꞉ I̱ta꞉ pukima꞉ na homa꞉la꞉eki Tekehalima꞉ opu hao do weki ka꞉la꞉ ekina꞉ ipika꞉ bikita꞉ Simiono leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Mo wanda꞉ta꞉ weki loke paa lomba hali weki ma꞉nda꞉ ombu mondu wiekeme. Kutupa mo wanda꞉ma꞉ alota꞉ I̱ma꞉ yaka halikina꞉ weki tepo mondu wialo ekina꞉ yaka halikima꞉ta꞉ I̱ pa꞉ta꞉ hone witolo I̱ yaapo ta꞉ma꞉ni pilieke laa mo wekina꞉ bikita꞉ Lipai leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Kutupa weki loke paa lomba hali weki ma꞉nda꞉ ombu mondu wiekeme. Ipikana꞉ma꞉ alota꞉ Ameta꞉ Tekehalina꞉ biki mea mina꞉lialueke laa mo wekina꞉ bikita꞉ Diuda leekeme. Kutupa weki mondu tunkuliekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Pate Leisoloma꞉ta꞉ Dieikope weki ma꞉nda꞉ na mendiaaso hata꞉ta꞉ hakepiki pa꞉ta꞉ a꞉nda꞉ tunkulolo hata꞉ Dieikope pa꞉ta꞉ alota꞉ I̱ homuluekema꞉ wekiwandiki kie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Koto leeke Dieikopeta꞉ Leisolo yaapo mineke pankolo hata꞉ alota꞉ I̱ma꞉ta꞉ Koda꞉ topo pea꞉peke na ya꞉la꞉pate pa neke weki mendiaapa꞉na꞉ yeke ipikana꞉ma꞉ sa꞉sa꞉ pitolo pia꞉ka꞉ta꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Koto ekina꞉ mo wanda꞉ma꞉ alota꞉ Yaka weki mendialo pa꞉la꞉ tupa꞉ yaka pa hameke e pokaasa꞉ wandiki doma꞉ pelia꞉peke. Kutu pilia꞉ ekima꞉ta꞉ ipiki pa꞉ta꞉ yama꞉ ama꞉ au loluekema꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Koto ekina꞉ ipika꞉ haliki pa꞉ta꞉ Biliha haleeke handa loke apa꞉taepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Kutupa Bilihata꞉ weki loke lomba Dieikopena꞉ hali weki mendiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Leisoloma꞉ alota꞉ Koda꞉ma꞉ telipolo hata꞉ta꞉ I̱ ma̱leke lila꞉me. Ipikana꞉ma꞉ta꞉ yaka pua꞉ yeni opua weki ka꞉la꞉me leekeme. Koto ekina꞉ta꞉ mo wekina꞉ bikita꞉ Da꞉ni leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Kutupa Bilihata꞉ weki loke paa lomba ipikana꞉ma꞉ Dieikopena꞉ yaapo peao weki mondu wiayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Kutu pieke handaa Leisoloma꞉ alota꞉ I̱ma꞉ yaka asi yaapo a꞉nda꞉ tieke pua꞉pate I̱ma꞉ bepolalo ekina꞉ta꞉ kota꞉ mo wekina꞉ bikita꞉ Na꞉petali leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Kutupa Liama꞉ta꞉ ipiki weki mondulu piekeeki tunkuliekeeki hando haota꞉ ipika꞉ pa hameke e pokaasa꞉ wandiki Silipata꞉ Dieikopema꞉ weteke au laena꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Kutupa Silipama꞉ta꞉ Dieikopena꞉ hali weki mendiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Kota꞉ Liama꞉ alota꞉ Epekeeki ma꞉nda꞉ I̱ pa꞉ta꞉ a꞉pa꞉la꞉me laa mo wekina꞉ bikita꞉ Ka꞉de leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Kutupa Silipama꞉ Dieikopena꞉ hali weki ma꞉nda꞉ mendiaeyeke ekina꞉ ");
INSERT INTO ssx_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Liama꞉ alota꞉ I̱ta꞉ ta꞉na꞉ tieke wopu pa꞉la꞉me. Ameta꞉ wanda꞉wekima꞉ I̱ta꞉ ta꞉na꞉ma꞉ homa꞉la꞉ wanda꞉e lelimikie laa ipika꞉ bikita꞉ A꞉sia leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Mo hande widi kina꞉ta꞉ Lubenita꞉ oni e pa꞉ta꞉manu pua mo ma꞉nda꞉teiki leke ti kiliki handa꞉ wia ipika꞉ inkiki Lia pa꞉ta꞉ a꞉pa haleekeme. Kutu pieke Leisoloma꞉ Lia pa꞉ta꞉ alota꞉ Pilisi naka꞉ wekina꞉ ti kiliki I̱ ma꞉nda꞉ kie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Koto leeke Liama꞉ hombo peaaso alota꞉ Nakana꞉ma꞉ yaka haliki pake nele ekita꞉ ana꞉ na pa꞉la꞉pe. Ameta꞉ pa yaka wekina꞉ ti kiliki tonka꞉na꞉ muluekema꞉ alepe leekeme. Kota꞉ Leisoloma꞉ alota꞉ Naka꞉ wekina꞉ ti kiliki I̱ ma꞉nda꞉ kika꞉na꞉ta꞉ kota꞉ ame timbata꞉ Dieikope yaapo poluelena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kutupa welealo nane Dieikopeta꞉ oni e pa꞉ta꞉manu hao epeeke handaa Lia hama opolu bao manda꞉hande pulu pua alota꞉ I̱ma꞉ yaka wekina꞉ ti kilikima꞉ nekena꞉ amba꞉ hamboa꞉ma꞉ ame timbata꞉ I̱ yaapo pelipikie leekeme. Koto ekina꞉ koto timbata꞉ Dieikopema꞉ mo wanda꞉ yaapo peliekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Koda꞉ma꞉ Liana꞉ pieke yeni hombo peaasota꞉ weki loke lomba ipikana꞉ma꞉ Dieikopena꞉ yunki pao weki mendiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Liama꞉ alota꞉ Yaka pa hameke e pokaasa꞉ wanda꞉ yaka haliki pa꞉ta꞉ haloeke handaa Koda꞉ma꞉ yaka yenki ka꞉la꞉mee laa mo wekina꞉ bikita꞉ Isaka leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Kutupa Lia weki loke paa lomba ipikana꞉ma꞉ Dieikopena꞉ yunki mindiki hata꞉ peao weki mendiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Kutupa Liama꞉ alota꞉ Koda꞉ma꞉ I̱ pa꞉ta꞉ ota꞉ epeke pa kita꞉la꞉ ale ka꞉la꞉me. Koto ekina꞉ ameta꞉ yaka halikina꞉ yunki mindiki hata꞉ weki mendiaaso ekina꞉ I̱ pukima꞉ homa handa꞉ milieke laa mo wekina꞉ bikita꞉ Sebuloni leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Wetepena꞉ta꞉ Liama꞉ wandiki mondu wia bikita꞉ Daena leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kutupa Koda꞉ma꞉ Leisolo hone u haota꞉ ipika꞉ pieke yeni opua weki mendina꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Mo wanda꞉ta꞉ weki loke lomba hali weki mondu wiekeme. Kutupa alota꞉ Koda꞉ma꞉ yaka yala꞉ pa꞉la꞉ ekita꞉ weki kitolo hata꞉ mea baala꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Koto ekina꞉ mo Tekehalima꞉ I̱ weki ma꞉nda꞉ paa kina꞉e alo hata꞉ koto wekina꞉ bikita꞉ Diosepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Mo Diosepe mendia hoki naneta꞉ Dieikopema꞉ Leibeni pa꞉ta꞉ alota꞉ I̱ yaka da ponoma꞉ I̱ tapae laa alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mo I̱ma꞉ naka꞉ e pokao molo wekiwanda꞉ mea hatuku mina꞉pa꞉lao pono lae. Pa ekipeke I̱ma꞉ naka꞉ e epeke tupa꞉ pokalo ekita꞉ naka꞉ hone wilimee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Koto leeke Leibenima꞉ ipiki pa꞉ta꞉ alota꞉ I̱ma꞉ doeki lono lae. Mo ale paeyao molo ekita꞉ I̱ma꞉ handeau opao handa꞉ witolo Koda꞉ma꞉ I̱ epeala꞉ ekita꞉ neke pa꞉ta꞉ yama꞉ pa꞉la꞉me laa hone ulume. ");
INSERT INTO ssx_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Koto ekina꞉ I̱ma꞉ neke hambuluekema꞉ naka꞉ yenki dupae laa lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Dieikopema꞉ hombo peaaso alota꞉ I̱ma꞉ naka꞉ e pokaaloeki make yaka kiki tukiki pa꞉ta꞉ naka꞉ sipisipi ma꞉na꞉manu sa꞉mba꞉lala꞉eki make naka꞉ handeleme. ");
INSERT INTO ssx_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Mo I̱ a̱i̱ na epeke hano hosiki siki wia hae ekita꞉ ameta꞉ tieke kiake sa꞉mba꞉la꞉pa ula꞉me. Kutupa mo Tekehalima꞉ta꞉ I̱na꞉ yeke neke epeaala꞉me. Koto ekina꞉ ameta꞉ I̱ma꞉ yaka ekimanu handeteke halo polo natee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Koto leeke Leibenima꞉ alota꞉ I̱ma꞉ta꞉ neketa꞉ ekipuma꞉ hambonope leekeme. Dieikopema꞉ hombo peaaso alota꞉ I̱ta꞉ yenki kipa꞉la꞉me. Nakana꞉ma꞉ I̱ma꞉ do alo ekina꞉ a꞉pa꞉la꞉me leka꞉na꞉ta꞉ kota꞉ naka꞉ sipisipi ma꞉na꞉manu paa handeteke hawalueke. ");
INSERT INTO ssx_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Koto ekina꞉ ameta꞉ naka꞉ sipisipi polu pa꞉ta꞉ puata꞉ mo punu pa꞉la꞉ sipisipi ikikimanu make wape wape piki o au au la꞉la꞉ nanikosi ikikimanu make yata꞉pa meono lae. Kotoeki homeketa꞉ mo yaka hone pa꞉la꞉ yenkie. ");
INSERT INTO ssx_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Koto ekina꞉ta꞉ wetepe nina꞉ta꞉ I̱ma꞉ neke na makealomee laa ana꞉na꞉ handilipikie. Pa ekipeke nakana꞉ma꞉ yaka molo yenki handulueke alo epeka꞉na꞉ta꞉ mo I̱ma꞉ au au na la꞉la꞉ o wape wape na piki nanikosi o punu na piki sipisipi ma꞉nda꞉ wia haowa꞉ka꞉na꞉ta꞉ kota꞉ pake na꞉la꞉me laa handa꞉ wilipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Leibenima꞉ hombo peaaso alota꞉ A꞉pa꞉la꞉me. Mo nakana꞉ma꞉ aleeki ota꞉ pupana꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Pate koto natena꞉ kone Leibenima꞉ta꞉ mo wape da꞉peda꞉pe piki o au au leke nanikosi hali ekimanu make mo au au leke wanda꞉ ma꞉na꞉ paeyao siki make kutupa mo punu piki sipisipi paeyao make yata꞉po miekeme. Kutupa ipika꞉ weki tonu paeyaoma꞉ handeteke haena꞉ laata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Dieikope mina꞉pa꞉lao koto au au leke ma꞉na꞉manu mea nate tepona꞉ polo pieke tupa꞉ papate mea pemekeme. Kutupa Dieikopema꞉ta꞉ mo hande mina꞉pa꞉laeyeke au au na leke ma꞉na꞉manu handeteke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Dieikopema꞉ta꞉ mo ta꞉ta꞉ ta꞉ta꞉ piki ti palekemanu mea hake pu lopa lopa pina꞉ta꞉ mandane yonkelekemanu loka꞉la꞉ mepi piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Kutupa ipikana꞉ma꞉ta꞉ do ti paleke manuta꞉ mo ma꞉na꞉ manuna꞉ ikali no haemeke kawaso wieke alena꞉ pua nokopeekeme. Ipikana꞉ma꞉ koto pate wieke ekita꞉ mo ma꞉na꞉ manuma꞉ta꞉ ikali nolo a꞉pa koto pate tia꞉tiki pieke piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kutupa mo nanikosi manuma꞉ mo ti palekemanu nokopeeke alena꞉ tia꞉tiki pimikita꞉ kota꞉ mo panake mendia꞉tiki pimiki ikiki sunuta꞉ au au la make wape wape piki ekimanu mondu wia꞉tiki pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Koto ekina꞉ Dieikopema꞉ta꞉ mo sipisipita꞉ nanikosi yaapo na apa꞉take ta꞉ta꞉ haena꞉ laata꞉ mo koto sipisipi paeyaota꞉ mo Leibenina꞉ au au leke make punu piki sipisipimanu haya꞉ nanema꞉ leke popeleke yao haena꞉ leekeme. Dupieke ekima꞉ta꞉ ipika꞉ ma꞉na꞉manu aneke hapu sa꞉mba꞉la꞉pa witolo hata꞉ mo Leibenina꞉ ma꞉na꞉manu ta꞉ta꞉ putupa haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kutupa mo hande panka wiki wanda꞉ ma꞉na꞉ manuna꞉ puteke pambiekeeki handolota꞉ Dieikopema꞉ta꞉ mo ma꞉na꞉ manuma꞉ ikali no haemeke kawaso wieke alena꞉ tia꞉tiki pina꞉ yeketa꞉ mo ti paleke manuta꞉ koto pate noka꞉pa꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Pate mo honkopu na hake ma꞉na꞉manu haemeke alena꞉ta꞉ mo ti palekemanu na wia꞉tiki piekeme. Kutu pieketa꞉ Leibenita꞉ mo honkopu na hake ma꞉na꞉manu minolo hata꞉ Dieikopeta꞉ mo panka wiki ma꞉na꞉manu wia hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Kutu pieke ekima꞉ta꞉ Dieikopeta꞉ hamoko tieke hayekeme. Ipikita꞉ sipisipi pita꞉ nanikosimanu make pa hameke e pokaasa꞉ tapake make kemelomanu make donkimanu make ota꞉ wopu wia hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Dieikopema꞉ta꞉ mo Leibenina꞉ eiyeke tonuma꞉ lemekeeki opieke ekita꞉ dupae. Dieikopema꞉ta꞉ mo nika꞉ apa꞉ma꞉ wia haya꞉ ale paeyao ma꞉la꞉me laa Ipika꞉ hamoko hala꞉ ekita꞉ mo nika꞉ apa꞉na꞉eki ma꞉la꞉ ekima꞉ pa꞉la꞉mee lemekeeki opiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Kutupa make ipikana꞉ma꞉ mo Leibenita꞉ amba꞉ta꞉ homu piekepate ameta꞉ leke tankema꞉ handeekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Koto ekina꞉ mo Tekehalima꞉ ipiki pa꞉ta꞉ alota꞉ Mo naka꞉ apa꞉na꞉ kenke nane make naka꞉ tapake pa꞉ta꞉ make paa pue. Kutupa I̱ta꞉ neke yaapo halueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Koto leeke Dieikopema꞉ta꞉ Leisolo pita꞉ Lia yaapo pa꞉ta꞉ mo ipika꞉ ma꞉na꞉manu hayeke alena꞉ ipiki a꞉pa manda꞉hande pia꞉pa꞉peke laa pi tapaeyekeme ");
INSERT INTO ssx_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Kutupa ipikana꞉ma꞉ mo wanda꞉ yaapo pa꞉ta꞉ alota꞉ Ipilika꞉ apa꞉ma꞉ta꞉ I̱ pa꞉ta꞉ amba꞉ pia꞉ tupa꞉ homu na piki pa leke tankema꞉ handa꞉la꞉eki I̱ma꞉ handolome. Kutu pa꞉la꞉pate yaka apa꞉na꞉ Koda꞉ma꞉ta꞉ I̱ yaapo hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Yaka welema꞉ ipilika꞉ apa꞉na꞉ e pokalo ekita꞉ hone wilipime. ");
INSERT INTO ssx_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Kutu pua꞉pate ipikana꞉ma꞉ta꞉ I̱ makeao make yaka yenki manuta꞉ hoto kiki yaapo natena꞉ honditi pa꞉la꞉mee. Koto pina꞉ kone Koda꞉ma꞉ta꞉ ipikana꞉ma꞉ I̱ na hoeyaena꞉ lea꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Pa mo ipilika꞉ apa꞉ma꞉ alota꞉ Mo au au lelie nanikosi manuta꞉ naka꞉ yenkie laa la꞉tiki pieketa꞉ kota꞉ mo ma꞉na꞉ paeyaoma꞉ta꞉ au au lekeeki mondu pamba꞉tiki piekeme. Kutupa paa alota꞉ mo wape wape pilia꞉ nanikosita꞉ naka꞉ yenkie pa la꞉tiki pia꞉ dina꞉ta꞉ kota꞉ mo ma꞉na꞉ paeyaoma꞉ta꞉ wape wape pikieki homeke mondu pamba꞉tiki pia꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kota꞉ Koda꞉ma꞉ta꞉ mo naka꞉ apa꞉na꞉ ma꞉na꞉ manuta꞉ pao mea I̱ pa꞉ta꞉ ka꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Mo ma꞉na꞉manu tita꞉la꞉ kina꞉ta꞉ I̱ma꞉ dupiki upa pua꞉me. Mo tia꞉tiki pimi nanikosi halieki manuta꞉ au au laa make wape wape pikieki homeke handoa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kutupa mo Koda꞉na꞉ enisoloma꞉ upama꞉ I̱ pa꞉ta꞉ alota꞉ Dieikopeo leeke I̱ma꞉ Wae loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Koto loeke alota꞉ Handa꞉e. Mo tita꞉la꞉ nanikosi halieki manuta꞉ mo au au leke make wape wape piki ekimanu homekee. Dupita꞉la꞉ ekita꞉ mo Leibenima꞉ neke pa꞉ta꞉ pita꞉la꞉eki handolo hata꞉ I̱ma꞉ dupiki hau pina꞉ alome. ");
INSERT INTO ssx_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I̱ta꞉ nakana꞉ma꞉ mo hande toopita꞉ hone u tiaasa꞉ ale wina꞉ la olipi oeta hola keke pi la꞉ wi ale Bedele hama pa꞉ta꞉ peneme yao epoa꞉ Koda꞉e. Koto ekina꞉ ameta꞉ mo neke mendia꞉ kenke nane polena꞉ tikitiki yae laa lea꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Koto leeke Leisolo pita꞉ Lia yaapoma꞉ Dieikopena꞉ pi hombo peaaso alota꞉ Mo dikana꞉ma꞉ dika꞉ apa꞉ pa꞉ta꞉ mea꞉peke ale ma꞉nda꞉ dia꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ipikana꞉ma꞉ dikita꞉ da ma꞉nda꞉ wanda꞉ma꞉ handaala꞉me. Ipikana꞉ma꞉ta꞉ diki tapao mia꞉ manita꞉ na꞉ta꞉ pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mo Koda꞉ma꞉ dika꞉ apa꞉na꞉ alemanu paeyao ma꞉la꞉ ekita꞉ dika꞉eki make diki wekiwandikina꞉eki konee. Koto ekina꞉ mo Koda꞉ma꞉ neke la ka꞉la꞉eki kone pie lepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Koto ekina꞉ Dieikopeta꞉ mo ateke hayeke alena꞉ Keinani nane poluekema꞉ tikitiki yaeyekeme. Ipika꞉ wekiwandiki make weteke tonu make mo kemelomanu manda pitaeyekeme. Kutupa ipika꞉ ma꞉na꞉manu paeyao make mo ipika꞉ Mesopoteimia hata꞉ mieke alemanu paeyao mea pulu haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Leibenita꞉ ipika꞉ sipisipi manuna꞉ itiki tunkulu pu moneayeke hoki nane haena꞉ Leisoloma꞉ta꞉ atekena꞉ da pa꞉ta꞉ pa wepia wieke koda꞉manu pake miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Dieikopema꞉ta꞉ ipiki mina꞉pa꞉laasome laa Leibeni na opuaeyeke ekima꞉ta꞉ Leibeni makeaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ipikana꞉ma꞉ta꞉ ipika꞉ alemanu paeyao mea ipupulo mina꞉pa꞉laeyekeme. Kutupa mo Yupoteitisi ikali yuma pua mo yu elimanu wiki Kilia꞉de kenke nane polueke alo pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Nate tepo paeyeketa꞉ Dieikopeta꞉ pindipa pa꞉la꞉me laa ma꞉nda꞉ma꞉ Leibeni la haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kutu pieke handaa ipika꞉ haliweki hatuku hoto wataake hata꞉ natena꞉ Dieikope telia꞉ mea pua mo yu eli hapeleke Kilia꞉de kenke pa꞉ta꞉ pua teliminimikime. ");
INSERT INTO ssx_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Koto timbata꞉ Koda꞉ma꞉ Leibeni pa꞉ta꞉ upama꞉ alota꞉ Nakana꞉ma꞉ Dieikopena꞉ ala꞉ta꞉ ma꞉nda꞉ mulueke alo hata꞉ paala꞉ tiaapeke hau ma꞉nda꞉ ota꞉ na pea꞉peke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Dieikopema꞉ta꞉ ipika꞉ palai da manuta꞉ mo pote pa꞉ta꞉ a꞉eyekeme. Kutupa make Leibeni ipika꞉ palai data꞉ ipika꞉ da haliweki ame̱le̱ mo pote eli wiki Kilia꞉de kenke pa꞉ta꞉ a꞉eyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Leibenima꞉ Dieikope pa꞉ta꞉ alota꞉ Nakana꞉ma꞉ I̱ta꞉ ekipeke makeao mo yaka wandiki yaapota꞉ mo a꞉nda꞉ pa꞉ta꞉ dipula mina꞉la꞉ wanda꞉wekima꞉ handeke tupa꞉ hatuku mea a꞉pa pelepe. ");
INSERT INTO ssx_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","I̱ta꞉ ekipeke makeao I̱ na opuake yopusiki doda꞉pikima꞉ a꞉pa pelepe. Nakana꞉ma꞉ I̱ lekena꞉ yoluta꞉ mo neke tapaaso hata꞉ pota꞉na꞉ ta꞉na꞉ma꞉ homolo kida make tapekema꞉ handeke ale make litolo hata꞉ emelimanu lo tapaalo pua꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nakana꞉ma꞉ta꞉ yaka wandiki yaapona꞉ wekiwandiki make yaka wandiki yaapo make a꞉taloe pi alo hata꞉ nunu na piono lemee. Koto hauta꞉ ota꞉ ti na piki hau peleme. ");
INSERT INTO ssx_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","I̱ma꞉ta꞉ neke hoeyalo polo honkoputa꞉ ula꞉pate naka꞉ apa꞉na꞉ Koda꞉ma꞉ta꞉ ambaneke timba I̱ kinki pitolo alota꞉ Neke paala꞉ tiaapeke hau ma꞉nda꞉ ota꞉ na pea꞉peke lea꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","I̱ma꞉ hone witolota꞉ neketa꞉ da a̱i̱ a꞉pawema꞉ ta꞉na꞉ma꞉ homolo hata꞉ pelepate ekipeke ya da pa꞉ta꞉ ua꞉ koda꞉ alemanu pake naa a꞉pa pelepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Koto leeke Dieikopema꞉ hombo peaaso alota꞉ Yaka honema꞉ta꞉ nakana꞉ma꞉ naka꞉ wandiki yaapo pao milipipatema꞉ I̱ma꞉ paala꞉ma꞉ homoa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Pate ma꞉nda꞉ epima꞉ naka꞉ wepia wiki koda꞉manu wia haemeka꞉na꞉ta꞉ kota꞉ koto someta꞉ lu homaena꞉e. Do dika꞉ haliwekima꞉ wekitisi haaso haena꞉ta꞉ pa naka꞉ alemanu weiya naka꞉ ekita꞉ mia꞉peke laa leekeme. Koto leekeeki Dieikopema꞉ta꞉ mo Leisoloma꞉ Leibenina꞉ wepia wieke koda꞉manu pake neekeeki na handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Koto leeke Leibenima꞉ta꞉ Dieikopena꞉ palai da pa꞉ta꞉ pua weiya kutupa Liana꞉ palai da pa꞉ta꞉ make mo pa hameke e pokaasa꞉ wanda꞉ yaapona꞉ palai da pa꞉ta꞉ make pua weiyekepate ipika꞉ wepia wieke koda꞉manu na handa꞉ wiekeme. Kutupa Leisolona꞉ palai da pa꞉ta꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Leisoloma꞉ta꞉ mo hande da pa꞉ta꞉ wieke wepia wieke koda꞉ manuta꞉ mo kemelo ma꞉na꞉na꞉ hoki manda yama pita꞉la꞉ seama꞉ handeke alena꞉ u hayeke nu pa꞉ta꞉ mendia ipikita꞉ manda pua pitiekeme. Leibenima꞉ta꞉ mo palai da pa꞉ta꞉ weiyekepate na handa꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Leisoloma꞉ ateke pa꞉ta꞉ alota꞉ Apa꞉o. I̱ yaapo mineke na panka꞉peke. Mo naka꞉ leke popelekena꞉ I̱ na tiao halo ekita꞉ I̱ta꞉ kaisepo da handolome laa leekeme. Kota꞉ Leibenima꞉ta꞉ weiyekepate ipika꞉ wepia wieke koda꞉manu ota꞉ na handa꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kutu pieke handaa Dieikopeta꞉ mineke tunkulu mea nalo hata꞉ alota꞉ I̱ma꞉ta꞉ ekipiki ata꞉ka꞉ peaasa꞉eki polope laa mineke pankolo hata꞉ lota꞉ pitolo alota꞉ Mo I̱ telia꞉ mea epele ekita꞉ I̱ma꞉ hando tombo ula꞉ pi yambololo ekima꞉ pie leeke pelepe. ");
INSERT INTO ssx_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ameta꞉ nakana꞉ma꞉ yaka ala꞉ta꞉ ala꞉ta꞉ paeyao koto talo pelema꞉ mo naka꞉ da pa꞉ta꞉ ula꞉ ale manuta꞉ hando ekimanu handa꞉ wilipe. Naka꞉ haliwekima꞉ make yaka haliwekima꞉ make handolota꞉ epima꞉ta꞉ ota꞉ hau pa꞉la꞉mee lena꞉ma꞉ do hamekena꞉ mea wie. ");
INSERT INTO ssx_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","I̱ma꞉ta꞉ 20 bapina꞉ neke yaapo haowa꞉me. Naka꞉ sipisipi manuma꞉ make nanikosi manuma꞉ make ikiki pa epeke ombu mendiolo haememe. Kutupa make I̱ma꞉ta꞉ naka꞉ sipisipi hali ekimanu homeke ma꞉nda꞉ ota꞉ na lu noa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mo tikene ma꞉na꞉ yeti sayalema꞉ naka꞉ sipisipi ma꞉nda꞉ lu neeketa꞉ kota꞉ I̱ma꞉ta꞉ ota꞉ yaka kone epeatiki pua꞉me. I̱ma꞉ta꞉ yaka pu hoeyaasoeki dia꞉me laa loluekema꞉ta꞉ neke na a꞉pa wala꞉tiki pua꞉me. Kutupa nakana꞉ma꞉ta꞉ mo timba o natena꞉ pake na꞉tiki pia꞉ ekita꞉ I̱ pa꞉ta꞉ ota꞉ a̱i̱ koto kone epeae laa la꞉tiki pime. ");
INSERT INTO ssx_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Hoto anekema꞉ mo natena꞉ta꞉ nate titipuma꞉ homa꞉la꞉eki mea꞉tiki pea timbata꞉ kosa꞉ma꞉ homa꞉tiki pitolo u pelia꞉peke na ya꞉tiki pia꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Koto hauta꞉ mo hande neke yaapo hatia pu haowa꞉ 20 bapi tukiki pa꞉ta꞉ pia꞉ekie. I̱ma꞉ta꞉ 14 bapita꞉ naka꞉ wandiki yaapo muluekema꞉ naka꞉ e pokaoka꞉na꞉ mo yunki mindiki hata꞉ bapina꞉ta꞉ naka꞉ ma꞉na꞉manu ma꞉nda꞉ muluekema꞉ handeteke haowa꞉me. Kutu piono kone nakana꞉ma꞉ta꞉ yaka yenkita꞉ hoto kiki yaapona꞉ topo pime. ");
INSERT INTO ssx_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Mo yaka apa꞉tonu Eipoloha꞉ma꞉ Aisa꞉ke yaapona꞉ Koda꞉ I̱ yaapo na hata꞉ yoluta꞉ nakana꞉ma꞉ I̱ta꞉ amba꞉ kone kiki hameke pono tapaalo pime. Pate Koda꞉ma꞉ta꞉ yaka ka꞉nda꞉ make I̱ma꞉ pokoa꞉ e make hando haota꞉ ambaneke timbata꞉ ipiki paeyaaso hata꞉ I̱ ma̱leke lia pia꞉me leekeme ");
INSERT INTO ssx_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Leibenima꞉ Dieikope pa꞉ta꞉ hombo peaaso alota꞉ Do wandiki yaapota꞉ yaka wandiki yaapoe. Ipilika꞉ wekiwandikita꞉ yaka ekie. Kutupa do ma꞉na꞉manu paeyaota꞉ yaka ekie. Handa꞉taa. Do ale paeyaota꞉ yakaeki ya꞉la꞉me. Pate I̱ma꞉ta꞉ do yaka wandiki yaapo make ipilika꞉ wekiwandiki make pao muluekema꞉ta꞉ hau ma꞉nda꞉ pea꞉peke na ya꞉la꞉ ekina꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","kota꞉ neke yaapo a꞉pa꞉la꞉me laa pi tonkaluekema꞉ta꞉ I̱ta꞉ tikitiki yao halome. Ameta꞉ mo dika꞉ pi tonkao witolopa꞉eki niminao haluekema꞉ta꞉ toopimanu mu momba꞉la hombuta꞉ hapana꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Koto leeke Dieikopema꞉ta꞉ niminao halo pieke toopi mea haena꞉ laata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ipika꞉ haliweki pa꞉ta꞉ alota꞉ Mandane toopimanu mu hombuta꞉ hape leekeme. Kutupa koto toopimanu mea hombuta꞉ hayeke ale tea꞉ naneta꞉ iki paeyao pita꞉ ne nemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Koto pateta꞉ Leibenima꞉ta꞉ Dieka Sahaduda leekeme. Kutupa Dieikopema꞉ta꞉ Ka꞉lidi leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Leibenima꞉ Dieikope pa꞉ta꞉ alota꞉ Do mu mombololopa꞉ toopi manuma꞉ta꞉ diki telipuna꞉ hone u tialieke leekeme. Koto ekina꞉ yeke koto pateta꞉ Ka꞉lidi leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Leibenima꞉ ombu alota꞉ Diki ta꞉ta꞉ pualu pupa꞉ka꞉na꞉ maketa꞉ Tekehalima꞉ diki handeteke haena꞉e laa mo alena꞉ta꞉ biki ma꞉nda꞉ Misipa make leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Leibenima꞉ pi paa alo alota꞉ Nakana꞉ma꞉ yaka wandiki yaapo epeke tupa꞉ na handeteke hake o wanda꞉ ma꞉nda꞉ mu pika꞉na꞉ta꞉ I̱ma꞉ta꞉ na opulu polopate Koda꞉ma꞉ta꞉ diki handa꞉la꞉me laa hone wia꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Dota꞉ neke diki tukikina꞉ I̱ma꞉ mu mombololo toopi manue. Kutupa do toopita꞉ niminapeke toopie. ");
INSERT INTO ssx_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Do mombololopa꞉ toopimanu make do niminapeke ekina꞉ toopi maketa꞉ diki hone u tialo pa꞉la꞉ekie. Koto ekina꞉ I̱ma꞉ta꞉ neke hoeyaluekema꞉ta꞉ do mombololopa꞉ toopimanu ankulao na ipulueke. Kutupa nakana꞉ma꞉ I̱ hoeyaluekema꞉ta꞉ do toopimanu o do niminapeke toopi ula꞉eki ankulao na a꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Mo Eipoloha꞉ma꞉ pita꞉ Neiho yaapona꞉ Koda꞉ma꞉ dika꞉ haumanu telipaena꞉e leekeme. Koto leeke ekina꞉ Dieikopema꞉ta꞉ mo ipika꞉ apa꞉ Aisa꞉kema꞉ yeiya꞉ lao yeni pu hayeke Koda꞉na꞉ bikina꞉ mo pi la꞉ wipikieki opulueke laa keke pi la꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Kutupa ipikana꞉ma꞉ ma꞉na꞉ ma꞉nda꞉ liata꞉ mo potena꞉ Koda꞉ pa꞉ta꞉ yeni hau pea ipika꞉ haliweki wi la꞉ meata꞉ ne nemekeme. Ne no paeyaota꞉ koto timbata꞉ mo pote pa꞉ta꞉ pelimikime. ");
INSERT INTO ssx_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Da kelepeeketa꞉ Leibenima꞉ ipika꞉ wandiki yaapona꞉ wekiwandiki make waneke yaapo make nunu peata꞉ paa da poluekema꞉ la꞉ka꞉la peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Dieikope pota꞉na꞉ pulu haena꞉ta꞉ mandane enisolomanu manda꞉hande piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kutaa ipikana꞉ma꞉ mo enisolomanu hando hao alota꞉ Dota꞉ Koda꞉na꞉ ta꞉ka꞉li dae laa Koto pateta꞉ Mahaneimi leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Dieikopema꞉ta꞉ mo Idomo kenke nane hameke Iso pa꞉ta꞉ pi mea polo pieke haliweki amba꞉la pulu haena꞉ tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ipikana꞉ma꞉ mo haliweki pa꞉ta꞉ dupa pua lapa꞉peke laa la halolo alota꞉ I̱ta꞉ naka꞉ pi opua e pokaasa꞉ some Dieikopema꞉ yaka you hali Iso neke pa꞉ta꞉ do pi lo tapaasome. I̱ta꞉ a̱i̱ na epoa꞉ ekita꞉ Leibeni yaapo hao ameta꞉ paa la꞉ka꞉la ipulume. ");
INSERT INTO ssx_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I̱ma꞉ta꞉ kaomanu make donkimanu make sipisipimanu make nanikosimanu make pa hameke e pokaasa꞉ wanda꞉hali make miniki ipulume. Ya tiekeo. I̱ta꞉ ta꞉na꞉ma꞉ homa handa꞉ mina꞉lepe laa do pi tapaasome laa lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kutupa mo pi mea pemeke haliweki Dieikope pa꞉ta꞉ paa la꞉ka꞉la ipulu alota꞉ Nikita꞉ naka꞉ kame Iso pa꞉ta꞉ pua lomeke handaa ipikita꞉ neke manda꞉hande pulueke alo hata꞉ amba꞉ pota꞉na꞉ ipula꞉me. Kutupa ipikita꞉ 400 haliweki ame̱le̱ ipula꞉me laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Koto ekina꞉ Dieikopeta꞉ paala꞉ma꞉ homolo hata꞉ hone ti yokeekeme. Kutupa ipikana꞉ma꞉ta꞉ mo ipiki ame̱le̱ haemeke wanda꞉hali make ipika꞉ sipisipimanu make nanikosimanu make kaomanu make kemelomanu make tapake yaapo putupa꞉ alu piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ipika꞉ honema꞉ta꞉ Isoma꞉ mo titina꞉ tapake a꞉pa hoeyaeya꞉ka꞉na꞉ta꞉ kota꞉ mo wetepena꞉ ekita꞉ pindipina꞉e hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kutupa Dieikopema꞉ yeni pitolo alota꞉ Yaka mei Eipoloha꞉ma꞉ pita꞉ yaka apa꞉ Aisa꞉ke yaapona꞉ Koda꞉o. Yaka pi opie. Tekehalio. Nakana꞉ma꞉ I̱ pa꞉ta꞉ta꞉ mo yaka kenke pa꞉ta꞉ make yaka tapake pa꞉ta꞉ make paa la꞉ka꞉la pue laata꞉ Nakana꞉ma꞉ta꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao epealueke laa I̱ la kimee. ");
INSERT INTO ssx_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","I̱ta꞉ naka꞉ e pokaaso hali hata꞉ nakana꞉ma꞉ I̱ pa꞉ta꞉ a꞉ta꞉ma꞉ homa tamba꞉ mina꞉la꞉eki make kima꞉ na homa꞉la꞉eki make ki ekita꞉ I̱ta꞉ ana꞉ na pa꞉la꞉me. I̱ma꞉ta꞉ mone yopuluta꞉ mo hande Diodani ikalita꞉ ala꞉ta꞉ ma꞉nda꞉ na miniki pa tumapu piti homeke yumua꞉pate pa ame ipuluta꞉ do tapake yaapo ame̱le̱ ipulume. ");
INSERT INTO ssx_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Koto ekina꞉ ya Tekehalio I̱ta꞉ yaka kame Isoma꞉ pulu pa꞉la꞉ ekina꞉ I̱ pa꞉ta꞉la꞉e. Ipikita꞉ niki ame̱le̱ a꞉nda꞉ pea niki paeyao make mo wekiwanda꞉ make hoeyaaluekema꞉ ipula꞉ ekina꞉ I̱ paala꞉ pita꞉la꞉mee. ");
INSERT INTO ssx_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nakana꞉ma꞉ta꞉ I̱ pa꞉ta꞉ pi la꞉ witolo mo ala꞉ta꞉ ala꞉ta꞉ paeyao epeao make kutupa I̱ma꞉ monduma꞉ monduma꞉ pulua꞉ wekiwandikina꞉ wekiwandikita꞉ ma꞉nda꞉ma꞉ na yata꞉polo pa꞉la꞉ tupa꞉ mo dawala tea꞉na꞉ ula꞉ ikali houma꞉ handekeeki kulueke laa la꞉ wi pita꞉ hone wie laa Koda꞉ pa꞉ta꞉ yeni piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","Koto timbata꞉ koto pate peliolo hata꞉ta꞉ Dieikopema꞉ta꞉ hameke Iso pa halo pieke ma꞉na꞉manu dupa yata꞉po miekeme. Nanikosita꞉ 200 wanda꞉eki pita꞉ 20 halieki make sipisipita꞉ 200 wanda꞉eki pita꞉ 20 halieki make kemelota꞉ 30 ikiki andu haleekeeki pita꞉ ika꞉ ikiki tonu make 40 kaomanu make kiki yaapo kao halieki make donkita꞉ 20 wanda꞉ ekimanu pita꞉ kiki yaapo donki halieki make paeyao yata꞉po miekeme ");
INSERT INTO ssx_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Kutupa ipikana꞉ma꞉ta꞉ ika꞉ homeke tapake tapake sununa꞉ haena꞉ loma꞉ loma꞉ peata꞉ homeke homekena꞉ta꞉ hali homekema꞉ handeteke haena꞉ loma꞉ loma꞉ pina꞉ leekeme. Kutupa mo haliweki pa꞉ta꞉ alota꞉ Iki amba꞉la pulu hata꞉ta꞉ mo homeke homeke ma꞉na꞉ tapakena꞉ tukikina꞉ta꞉ waleke uma꞉ uma꞉ pina꞉ lapa꞉peke laa mana꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kutupa mo titina꞉ ma꞉na꞉ mea peeke some pa꞉ta꞉ alota꞉ Mo yaka kame Isoma꞉ neke manda꞉hande pea neke lota꞉ pitolo Naka꞉ you someta꞉ epi ya꞉ka꞉ta꞉pe o Hane pulipe o Do ipulimi ma꞉na꞉ manuta꞉ epina꞉ ekipe laa lota꞉ pia꞉ka꞉na꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","kota꞉ nakana꞉ma꞉ dupa hombo peaapeke. Ikita꞉ mo naka꞉ e pokaasa꞉ hali Dieikopena꞉ ekie. Ipikana꞉ma꞉ta꞉ mo ipika꞉ you some Iso pa꞉ta꞉ pa hameke hala꞉la꞉eki tapaala꞉me. Kutupa Dieikope ipikita꞉ nika꞉ hoki nane ipula꞉me laa lapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Kutupa mo hoki pa꞉ta꞉ hali make tepo peao hali pa꞉ta꞉ make mo paeyao pa꞉ta꞉ make homeke pi kone loma꞉ loma꞉ pitolo hata꞉ alota꞉ Iso manda꞉hande pimika꞉na꞉ta꞉ dupa lapa꞉peke laa la halolota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","dupa make lapa꞉peke. Aowe. Naka꞉ e pokaasa꞉ hali Dieikopeta꞉ nika꞉ hoki nane kone ipula꞉me lapa꞉peke leekeme. Dieikopena꞉ honema꞉ta꞉ mo pa hameke hala꞉la꞉ ale manuma꞉ hamekena꞉ puki epeao kutupa ipiki pua manda꞉hande pua꞉ka꞉na꞉ta꞉ I̱ma꞉ pua꞉ hauta꞉ pa paeyawalieke laa honema꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Koto ekina꞉ mo pa hala꞉la꞉ ale manuta꞉ titina꞉ pulu haena꞉ta꞉ koto timba ipikita꞉ mo ipika꞉ palai da pa꞉ta꞉ peliekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Koto homeke timba koneta꞉ Dieikope tiao ipika꞉ wanda꞉ yaapo make mo e pokaepeke wanda꞉ yaapo make ipika꞉ kiki yaapona꞉ ankena꞉ homeke wekiwandiki make mo Dia꞉boko ikali yuma꞉ pa pena꞉ tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kutupa mo tapake tapaota꞉ ipika꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao siki make tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Pate ipikita꞉ ipika꞉ siki pao hayekeme. Kutupa koto timbata꞉ hali ma꞉nda꞉ a꞉pa ipiki yaapo tonka꞉neli pitolo haena꞉ta꞉ da kelepeekeeki teke pa꞉ta꞉ mieke mina꞉pa꞉laluekema꞉ ");
INSERT INTO ssx_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","mo somema꞉ mo tonka꞉neli pita꞉la꞉ ekita꞉ ipikana꞉ma꞉ na bepolapeke ya꞉ka꞉ta꞉me laa handolo hata꞉ kota꞉ mo Dieikopena꞉ pelimokona꞉ lieke handaata꞉ pelimoko yoka꞉ endiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kutupa mo halima꞉ alota꞉ Da ka꞉la꞉pa꞉la꞉me. I̱ pono lae leeke handaa Dieikopema꞉ hombo peaaso alota꞉ Neke a̱i̱ na tapake. I̱ a꞉nda꞉ epeaeka꞉na꞉ta꞉ kota꞉ neke tapaalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Koto leeke mo halima꞉ lota꞉ pitolo alota꞉ Naka꞉ bikita꞉ epipe leekeme. I̱ta꞉ Dieikopee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kota꞉ mo halima꞉ alota꞉ Ameta꞉ naka꞉ bikita꞉ Dieikope dia꞉ya꞉lieke. Pa ekipeke nakana꞉ma꞉ta꞉ Koda꞉ yaapo make hali yaapo make tonka꞉neli pea bepolae ekina꞉ naka꞉ bikita꞉ Isulaie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Koto leeke Dieikopema꞉ alota꞉ Ameta꞉ kota꞉ naka꞉ biki la kie leekepate ipikana꞉ma꞉ hombo peaaso alota꞉ Ekipeke nakana꞉ma꞉ yaka biki opuluekema꞉ alepe laa leekeme. Koto laata꞉ ipikana꞉ma꞉ Dieikope epeayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kota꞉ Dieikopema꞉ alota꞉ I̱ma꞉ta꞉ Koda꞉ta꞉ ota꞉ leke popeleke pa꞉ta꞉ handa꞉ alu pua꞉pate I̱ta꞉ na homeke pa halomee leekeme. Koto ekina꞉ koto alena꞉ta꞉ Penielo leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Dieikopeta꞉ Penielo mina꞉pa꞉laaso haena꞉ta꞉ nate opeekeme. Ipikita꞉ ipika꞉ pelimokoma꞉ yoka꞉ endiatiki peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ame do maketa꞉ mo Isulaina꞉ monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikima꞉ maketa꞉ mo pelimoko tunala꞉ pa꞉ta꞉ hala꞉ honkoputa꞉ na no halememe. Pa ekipeke Dieikopeta꞉ mo koto honkopuna꞉ lieke ekina꞉ pitelememe. ");
INSERT INTO ssx_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Dieikopema꞉ta꞉ Iso ipika꞉ 400 haliweki ame̱le̱ epemeeki hando haota꞉ ipika꞉ wekiwandikita꞉ mo Lia make Leisolo make mo e pokaepeke wanda꞉ yaapo make teli pea haoma꞉ haoma꞉ pina꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ipikana꞉ma꞉ta꞉ mo e pokaeyeke wanda꞉ yaapo ipilika꞉ wekiwandiki ame̱le̱ titina꞉ haena꞉ laa koto hoki pa꞉ta꞉ta꞉ Lia ipika꞉ wekiwandiki ame̱le̱ haena꞉ laata꞉ mo Leisolo pita꞉ Diosepe yaapota꞉ sale nane haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Kutupa Dieikopema꞉ta꞉ ipiki amba꞉la titina꞉ pua mo ipika꞉ hameke handa꞉tia pulu hata꞉ hoto wataake hata꞉na꞉ oni kenkena꞉ panda꞉ puniaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Pate Isoma꞉ta꞉ a̱i̱ya ipiki manda꞉hande pulu pulu hata꞉ ipika꞉ kiki yaapo bao hameke hopulolo hata꞉ nunu piekeme. Ipiliki telipuna꞉ e̱ lepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kutupa Isoma꞉ lekema꞉ lekema꞉ pitolo hata꞉ mo wanda꞉weki make wekiwandiki make handolo hata꞉ alota꞉ Do neke ame̱le̱ hala꞉ wanda꞉halita꞉ epi ameda ya꞉ka꞉ta꞉pe laa lota꞉ piekeme. Dieikopema꞉ hombo peaaso alota꞉ Kameo. Dota꞉ Koda꞉ma꞉ apetolo hata꞉ I̱ ka꞉la꞉ wekiwandikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kutupa mo e pokaepeke wanda꞉ yaapo ipilika꞉ wekiwandiki ame̱le̱ a꞉pa panda꞉ puniaemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kutupa Lia pita꞉ ipika꞉ wekiwandiki ame̱le̱ a꞉pa panda꞉ puniaemekeme. Kuta ota꞉ wetepe naneta꞉ Diosepe pita꞉ Leisolo yaapoma꞉ a꞉pa panda꞉ puniaepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Isoma꞉ lota꞉ pitolo alota꞉ Pa mo titina꞉ manda꞉hande pua꞉ tapaketa꞉ kotota꞉ eki laa pipe leekeme. Dieikopema꞉ hombo peaaso alota꞉ Kotota꞉ nakana꞉ma꞉ I̱ pa꞉ta꞉ ta꞉na꞉ma꞉ homoelena꞉ yeke tapao pua꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Pate Isoma꞉ alota꞉ Kameo. I̱ta꞉ ana꞉na꞉ wia haloma꞉ naka꞉ wia hale ekita꞉ naka꞉ kone wia hae laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Dieikopema꞉ alota꞉ Pilisi ota꞉ dia꞉me. Nakana꞉ma꞉ I̱ pa꞉ta꞉ ta꞉na꞉ma꞉ homeka꞉na꞉ta꞉ kota꞉ yaka pa hameke kitolo alemanu mie. Ameta꞉ nakana꞉ma꞉ I̱ pa꞉ta꞉ homu wopu pitele ekita꞉ kota꞉ mo naka꞉ leke popeleke handolo ekita꞉ mo Koda꞉na꞉ leke popeleke handeke nono pita꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Koto ekina꞉ pilisio. Do I̱ma꞉ mea a꞉palo pa hameke kitolo ale manuta꞉ a꞉pa꞉la꞉me laa mie laata꞉ Koda꞉ma꞉ta꞉ I̱ pa꞉ta꞉ a꞉ta꞉ma꞉ homolo hata꞉ mo I̱ma꞉ weiyua꞉ alemanu paeyao ana꞉na꞉ kia꞉me leekeme. Dieikopema꞉ta꞉ hameke honke la꞉tia puoopu haota꞉ Isoma꞉ wetepena꞉ miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Isoma꞉ alota꞉ Ameta꞉ kota꞉ pana꞉ tikitiki yae. I̱ amba꞉la polueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Koto leeke Dieikopema꞉ hombo peaaso alota꞉ Yaka hosiki wekiwandikita꞉ soka꞉la꞉ma꞉ homa꞉la꞉ ekita꞉ naka꞉ handeleme. Kutupa mo sipisipi pita꞉ kao kemboko ankula꞉ ankula꞉ make hone wia꞉peke ya꞉la꞉me. Ikita꞉ pa mo nate homeke sikina꞉ kone mo ma꞉na꞉manu lu yombutia poma꞉ka꞉na꞉ta꞉ kota꞉ paeyao siki homilimikie. ");
INSERT INTO ssx_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Koto ekina꞉ pilisi neke amba꞉la pue. I̱ta꞉ neke telia꞉ mea yopusiki mo yaka ma꞉na꞉manu make mo wekiwandiki ame̱le̱ honkopu hao kone a꞉pa mo Idomo da a꞉pa tolu minuluekee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Koto leeke Isoma꞉ alota꞉ Kota꞉ a꞉pa꞉la꞉ma꞉ neke tamba꞉ mina꞉ mo yaka mandane haliweki mina꞉pa꞉lanoe leekepate Dieikopema꞉ hombo peaaso alota꞉ I̱ma꞉ta꞉ kotoeki hone pieke na loa꞉pate pa mo naka꞉ ta꞉na꞉ pa꞉la꞉eki homekena꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Koto ekina꞉ koto natena꞉ta꞉ Isota꞉ Idomo poluekema꞉ peekepate ");
INSERT INTO ssx_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Dieikopeta꞉ Sakodo nane peekeme. Koto pateta꞉ ipika꞉ da a꞉eya make ipika꞉ ma꞉na꞉ manuna꞉ kalale da sunu make a꞉eyaeyekeme. Koto ekina꞉ yeketa꞉ koto pateta꞉ Sakodo leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Dieikope mo Mesopoteimia haota꞉ mo Keinani kenke pa꞉ta꞉ Sekeme daoni pa꞉ta꞉ epeke tupa꞉ opolo epeekeme. Kutupa ipika꞉ palai da manuta꞉ mo daonina꞉ hama꞉ ma꞉nda꞉ pa꞉ta꞉ a꞉eyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Kutupa ipikana꞉ma꞉ta꞉ koto hama꞉ta꞉ Sekemena꞉ ateke Hamona꞉ tapakena꞉eki 100 silipa manima꞉ hambeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Koto pateta꞉ oloda ma꞉nda꞉ a꞉eya bikita꞉ mo Isulaina꞉ Koda꞉na꞉ biki ma꞉nda꞉ Elo wina꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Nate ma꞉nda꞉na꞉ta꞉ mo Lia Dieikope yaapona꞉ waneke Daenata꞉ mo Keinani wanda꞉weki handolo peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kutu piekepate mo da kenke pa꞉ta꞉ you hali hayeke Hipi hali Hamona꞉ eiyeke Sekemema꞉ hando haota꞉ Daena꞉ pake lumea peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Pate ipikana꞉ma꞉ mo wandikita꞉ ota꞉ wandiki seliapo yeke handaa mo wandiki pa꞉ta꞉ pukima꞉ homeekeme. Koto ekina꞉ ipikana꞉ma꞉ mo wandikina꞉ puki epealuekema꞉ taapeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Kutupa ipika꞉ ateke pa꞉ta꞉ alota꞉ Apa꞉o. Koto wandikita꞉ yaka wanda꞉ haena꞉ yeke mealena꞉ hone witolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Dieikopema꞉ta꞉ waneke pa꞉ta꞉ yaala꞉piki hau piekeeki handeekepate ipika꞉ weki tonuta꞉ oni hama꞉manu pa꞉ta꞉ ipika꞉ ma꞉na꞉manu handeteke halo pemeke ekiyalo pa hando hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","7","Kutupa mo Dieikopena꞉ eiyeke tonuta꞉ oni hama꞉manu pa꞉ta꞉ hao honda꞉ pambolo ipulu haena꞉ kone mo Sekemena꞉ ateke Hamota꞉ Dieikope yaapo pi lolueke alo hata꞉ opolo peekeme. Kutu piekepate mo weki tonuma꞉ta꞉ Sekemema꞉ Dieikopena꞉ waneke lumea pa꞉la꞉ ekita꞉ ota꞉ dupiki hau pa꞉la꞉ ekita꞉ mo Isulai wanda꞉hali pa꞉ta꞉ yala꞉ peake hau pa꞉la꞉me laa tola꞉tia pominolo hata꞉ tetoma꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamoma꞉ Dieikope pa꞉ta꞉ alota꞉ Yaka weki Sekemema꞉ta꞉ naka꞉ wandikina꞉ da ota꞉ homa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Pilisio. Mina꞉ lae. Kutupa naka꞉ wanda꞉hali make yaka wanda꞉hali make mu alu alu pu hala꞉ pa꞉la꞉ tupa꞉ dikana꞉ma꞉ pi lo tonkao u pana꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kutupa neketa꞉ do yaka kenke pa꞉ta꞉ hata꞉ka꞉na꞉ naka꞉ hone pa꞉la꞉ alena꞉ hata꞉ mo ala꞉ta꞉ ala꞉ta꞉ pa topo topo pea naka꞉ kenkemanu hamba wia halena꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kutupa Sekemema꞉ Daenana꞉ ateke make beliki tonu pa꞉ta꞉ alota꞉ I̱ pa꞉ta꞉ a꞉ta꞉ma꞉ homa yaka honke aloeki peaemeka꞉na꞉ta꞉ kota꞉ I̱ma꞉ta꞉ mo ika꞉ hone pa꞉la꞉ alemanu kulueke. ");
INSERT INTO ssx_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ika꞉ ana꞉ta꞉ ota꞉ muluekema꞉ ika꞉ hone pa꞉la꞉ tupa꞉ pa kitolo alemanu muemena꞉ kota꞉ mo wandikina꞉ yenkita꞉ ika꞉ hone pa꞉la꞉ tupa꞉ make pa mina꞉liaemeka꞉na꞉ kota꞉ pa pina꞉ma꞉ mo wandiki homeke ota꞉ muluekema꞉ hone witolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Pate Sekemema꞉ta꞉ ika꞉ ana꞉ Daena yala꞉ peake hau pieke handaa mo Dieikopena꞉ eiyeke tonuma꞉ mo Sekeme pita꞉ ipika꞉ ateke Hamo yaapo pa꞉ta꞉ yayapiki tupa꞉ hombo peaemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ikana꞉ma꞉ ipiki pa꞉ta꞉ alota꞉ Nika꞉ ana꞉ta꞉ mo sekemesaisi hau na pa꞉la꞉ halima꞉ mia꞉peke na ya꞉la꞉me. Kotota꞉ niki yala꞉ tieke piki haue. ");
INSERT INTO ssx_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nikana꞉ma꞉ta꞉ niki poloma꞉ tupa꞉ naka꞉ haliweki paeyao sekemesaisi hau pimika꞉na꞉ homeke a꞉pa꞉la꞉me lolumeke. ");
INSERT INTO ssx_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kutu pimika꞉na꞉ta꞉ nikana꞉ma꞉ta꞉ wanda꞉ mu alu alu pita꞉la꞉ ekita꞉ a꞉pa꞉la꞉me lolumeke. Kutupa nikita꞉ iki ame̱le̱ homeke wanda꞉hali hao polumeke. ");
INSERT INTO ssx_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pate do nikana꞉ma꞉ aloma꞉ tupa꞉ sekemesaisi hau na pimika꞉na꞉ta꞉ kota꞉ mo wandiki pao mea mina꞉pa꞉lao polumeke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Dupiki pima꞉ta꞉ Hamo pita꞉ eiyeke Sekeme yaapoma꞉ta꞉ a꞉pa꞉la꞉me hone wipikime. ");
INSERT INTO ssx_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Koto ekina꞉ mo pa꞉pa꞉na꞉ wekima꞉ta꞉ Dieikopena꞉ waneke pukima꞉ homeekeeki yalo mo pia꞉peke lemeke ekita꞉ nateleke ma꞉nda꞉ na paeyaeyekeme. Ipikita꞉ mo ipika꞉ tapake tukiki pa꞉ta꞉ta꞉ you some hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kota꞉ Hamo pita꞉ ipika꞉ eiyeke Sekeme yaapota꞉ mo ika꞉ pi hotu haemeke alena꞉ mo daoni pota꞉ kake pa꞉ta꞉ pua mo ipilika꞉ daoni haliweki pa꞉ta꞉ dupiki pimanu lepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Do haliwekita꞉ homu pelememe. Do niki haloma꞉ kenke pa꞉ta꞉ niki ame̱le̱ hata꞉ pa pomina꞉ lomana꞉e. Do nika꞉ kenketa꞉ iki make ana꞉na꞉ halimikie. Kutupa nikana꞉ma꞉ ika꞉ wandiki tonu hapua meata꞉ ikana꞉ma꞉ nika꞉ wandiki tonu make hapua mea꞉tiki pina꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kutu pulu poloma꞉pate do haliwekima꞉ta꞉ niki ame̱le̱ hata꞉ homeke wanda꞉hali hamana꞉e alemepate ekia꞉nda꞉ homeketa꞉ iki peleme tupa꞉ nika꞉ haliweki paeyao make sekemesaisi hau puma꞉ka꞉na꞉ homeke a꞉pa꞉la꞉me alememe. ");
INSERT INTO ssx_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kutu puma꞉ka꞉na꞉ta꞉ kota꞉ ika꞉ ma꞉na꞉manu paeyao make ika꞉ wia haleme alemanu paeyao make nika꞉eki dia꞉ya꞉liepe. Koto ekina꞉ niki ame̱le̱ haena꞉ lomana꞉e lepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Kutupa mo daoni pa꞉ta꞉ haemeke haliwekima꞉ta꞉ Hamo pita꞉ Sekeme yaapoma꞉ lepeke ekita꞉ a꞉pa꞉la꞉me laa iki paeyao siki sekemesaisi hau pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Hoto tepo hao mo haliweki koto sekemesaisi hau pimiki ekima꞉ tanda pa pitolo haena꞉ta꞉ Dieikopena꞉ eiyeke yaapo mo Daenana꞉ beliki Simiono pita꞉ Lipai yaapoma꞉ ipilika꞉ bainasi yaapo mina oni daoni pa꞉ta꞉ pepekeme. Mo weki yaapoma꞉ta꞉ mo wanda꞉halima꞉ ata꞉ka꞉ piki hone ma꞉nda꞉ wiaama꞉na꞉ yeke pa ota꞉ hone wia peke nono pea pua mo haliweki paeyao lia ");
INSERT INTO ssx_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","make mo Hamo pita꞉ Sekeme yaapo make lipikime. Kutupa Daena mo Sekemena꞉ da pa꞉ta꞉ pitieke alena꞉ pao hatuku pepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Mo haliweki lu paeyaepeke hoki naneta꞉ Dieikopena꞉ eiyeke titi mandane weki tonuma꞉ta꞉ ika꞉ ana꞉na꞉ yala꞉ mieke ekina꞉ hombo peaaso hata꞉ mo daoni teke puleke laemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ikana꞉ma꞉ta꞉ mo ma꞉na꞉manu make kaomanu make donkimanu make oni daoni pa꞉ta꞉ wieke alemanu paeyao make oni hama꞉ nina꞉ hayeke alemanu paeyao mea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ikana꞉ma꞉ta꞉ mo yenki tieke peke alemanu paeyao mea wanda꞉weki make mina kota꞉ ika꞉ da pa꞉ta꞉manu wieke alemanu paeyaosiki make mea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Dieikopema꞉ Simiono pita꞉ Lipai yaapo pa꞉ta꞉ alota꞉ Ipilikana꞉ma꞉ta꞉ I̱ pa꞉ta꞉ ka꞉nda꞉ mea kelepeme. Ameta꞉ mo Keinani wanda꞉halima꞉ make Petese wanda꞉halima꞉ make do kenke pa꞉ta꞉ haleme wanda꞉hali paeyao sikima꞉ta꞉ I̱ pa꞉ta꞉ honditi pilimikie. Koto wanda꞉hali paeyaoma꞉ apa꞉tao I̱ ame̱le̱ a꞉nda꞉ puluekema꞉ pimika꞉na꞉ta꞉ kota꞉ I̱ta꞉ hali wopu dia꞉yalo hata꞉ do yaka tapake paeyaota꞉ hoeyaalimikie. ");
INSERT INTO ssx_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Pate mo hama̱la̱꞉ma꞉ hombo peaaso alota꞉ Dikana꞉ma꞉ta꞉ dika꞉ ana꞉ta꞉ pa koto hali yola꞉la꞉ wanda꞉ tupa꞉ haena꞉ lena꞉ lapeke na ya꞉la꞉me lepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Koda꞉ma꞉ Dieikope pa꞉ta꞉ alota꞉ Koto kone Bedele nane pua hapeke. Koto pa꞉ta꞉ta꞉ neke mo hande naka꞉ kame Iso paala꞉ hao pindipa yapeke handa neke pa꞉ta꞉ peneme yaowa꞉ Koda꞉ I̱ pa꞉ta꞉ oloda a꞉eya꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Koto leeke Dieikopema꞉ ipika꞉ tapake make mo ipiki ame̱le̱ apa꞉tao haemeke tapake pa꞉ta꞉ make alota꞉ Mo ika꞉ wia haleme da ma꞉nda꞉ wanda꞉halina꞉ wepia ula꞉ koda꞉manu mea baapee. Kutupa make ikana꞉ma꞉ta꞉ iki tikitiki yao mo ha̱i̱ na ta̱leke aka꞉manu yama꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Nikita꞉ do pate mina꞉pa꞉lao mo Bedele nane puluma꞉me. Koto pateta꞉ mo I̱ma꞉ ka꞉nda꞉ tua꞉ natena꞉ I̱ tamba꞉ mea make mo I̱ pomua꞉ ale pa꞉ta꞉manu I̱ yaapo hao haya꞉ Koda꞉ pa꞉ta꞉ oloda a꞉eluekema꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Koto leeke mo wanda꞉halima꞉ta꞉ ika꞉ wia haemeke da ma꞉nda꞉ wanda꞉halina꞉ wepia ula꞉ koda꞉manu paeyao make mo ika꞉ pankemeke haleke halimanu make paeyao Dieikope pa꞉ta꞉ halemekeme. Kutupa ipikana꞉ma꞉ koto alemanu paeyao mo Sekeme hayeke pei teke pa꞉ta꞉ hoiyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mo Dieikope ipika꞉ weki tonu ame̱le̱ mina꞉pa꞉laaso haena꞉ta꞉ mo teke pa꞉ta꞉manu hao yapeeke daonimanu pa꞉ta꞉ haemeke wanda꞉halima꞉ta꞉ pa paala꞉ tieke pieke handaa mo tapake na telia꞉ mea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Kutupa Dieikopema꞉ta꞉ ipika꞉ wanda꞉hali paeyao ame̱le̱ Lusu opolo epemekeme. Ameta꞉ oni Keinani kenke pa꞉ta꞉ Bedele leleme alena꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ipikana꞉ma꞉ta꞉ koto pate oloda a꞉eyaata꞉ mo koto pateta꞉ Bedelena꞉ Koda꞉na꞉ biki tapu wiao leekeme. Pa ekipeke koto pateta꞉ mo hande ipiki ipika꞉ hameke paala꞉ hao pindipa peeke handa Koda꞉ ipiki kone peneme yaeyeke alena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Amba꞉ koto pateta꞉ mo hande hosiki ya꞉na꞉ kone mo Lepekana꞉ pa hameke e pokao hayeke wanda꞉ Debota homeeke handaa mo Bedele ka꞉wa꞉ nanema꞉ tilao mo pei teke ma꞉nda꞉ pa꞉ta꞉ hoimiki yeke handa bikita꞉ E̱ Ala꞉ Peie lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kutupa Dieikope mo Mesopoteimia mina꞉pa꞉lao epeeketa꞉ Koda꞉ma꞉ ipiki pa꞉ta꞉ paa peneme yao pua ipiki epeayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Koda꞉ma꞉ ipiki pa꞉ta꞉ alota꞉ Naka꞉ bikita꞉ Dieikope ya꞉la꞉pate ame do kini peata꞉ Isulai lena꞉e leekeme. Koto ekina꞉ Koda꞉ma꞉ta꞉ ipika꞉ bikita꞉ Isulai leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Kutupa Koda꞉ma꞉ ipiki pa꞉ta꞉ alota꞉ I̱ta꞉ Aneke Wele Wopupiki Koda꞉e. Wekiwandiki wopu mendia꞉peke. Tutu manuta꞉ neke pa꞉ta꞉ yama꞉ monduma꞉ monduma꞉ pilieke. Kutupa neketa꞉ kini hali manuna꞉ apa꞉mei halipikie. ");
INSERT INTO ssx_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","I̱ma꞉ta꞉ mo Eipoloha꞉ma꞉ pita꞉ Aisa꞉ke yaapo pa꞉ta꞉ haloa꞉ kenketa꞉ neke pa꞉ta꞉ kulueke. Kutupa make naka꞉ hoki nane monduma꞉ monduma꞉ pilimi wekiwandiki pa꞉ta꞉ make halueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kutupa Koda꞉ma꞉ ipiki mina꞉pa꞉laeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Koto pate mo hande Koda꞉ma꞉ ipiki pa꞉ta꞉ pi la haleeke alena꞉ta꞉ Dieikopema꞉ niminapeke toopi noka꞉pa olipi oeta make waini ikali make hola dota꞉ yakopiki alena꞉e laa pi wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Koto pateta꞉ biki Bedele leekeme ");
INSERT INTO ssx_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Dieikope ipika꞉ tapake ame̱le̱ Bedele mina꞉pa꞉lao mo Epa꞉ta꞉ poluekema꞉ pa hosiki papate leke wina꞉ta꞉ Leisolo ipika꞉ weki mulu pieke nate minolo hata꞉ta꞉ weki hoki nalo hata꞉ make ka꞉nda꞉ tieke miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Mo weki hoki ota꞉ hoke tupa꞉ neeke dina꞉ mo weki meao hayeke wanda꞉ma꞉ alota꞉ Leisoloo. Hali weki ma꞉nda꞉ ya꞉ka꞉ta꞉ma꞉ paala꞉ma꞉ na homa꞉pee leekepate ");
INSERT INTO ssx_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","mo Leisolota꞉ homolo pulu hata꞉ ipika꞉ paeyaaso pomo minolo hata꞉ta꞉ ipika꞉ wekina꞉ bikita꞉ Benomi leekeme. Pate pa atekema꞉ta꞉ biki Benisamini leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Leisolo homea꞉ dina꞉ta꞉ mo Epa꞉ta꞉ nane pula꞉ pota꞉ tea꞉na꞉ hoimikime. Ameta꞉ Beteleha꞉ma꞉ la꞉leme alena꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Dieikopema꞉ta꞉ niminaasa꞉ toopi ma꞉nda꞉ koto alena꞉ nokopeekeme. Kutupa ame do make Leisolona꞉ lapa꞉ pa꞉la꞉ alena꞉e laa walo hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Kutupa Dieikopema꞉ta꞉ mo Edana꞉ oli ya pa꞉ta꞉ haliao peke hokulupeke da tea꞉ nane ipika꞉ palai damanu a꞉elo peekeme ");
INSERT INTO ssx_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Dieikope koto kenke pa꞉ta꞉ haena꞉ Lubenima꞉ta꞉ ipika꞉ apa꞉na꞉ e pokaeyeke wanda꞉ Biliha yaapo loke apa꞉taeyekeme. Koto ekita꞉ Dieikopema꞉ opuata꞉ mineke tieke wopu pankeekeme. Dieikopeta꞉ weki kiki yaapona꞉ ankena꞉ yaapo pea mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Liana꞉ weki tonuta꞉ Lubeni hande Dieikopena꞉ mupeke weki make Simiono make Lipai make Diuda make Isaka make Sebuloni make yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Leisolona꞉ eiyeke yaapota꞉ Diosepe pita꞉ Benisamini yaapoe. ");
INSERT INTO ssx_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Mo Leisolona꞉ pa hameke e pokaeyeke wanda꞉ Bilihana꞉ eiyeke yaapota꞉ Da꞉ni pita꞉ Na꞉petali yaapoe. ");
INSERT INTO ssx_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Mo Liana꞉ pa hameke e pokaasa꞉ wanda꞉na꞉ eiyeke yaapota꞉ Ka꞉de pita꞉ A꞉sia yaapo yekeme. Do wekitonu paeyaota꞉ mo Mesopoteimia nane hata꞉ mendieke weki tonue. ");
INSERT INTO ssx_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Dieikopeta꞉ ateke Aisa꞉ke haya꞉ nane peekeme. Kotota꞉ mo Ma꞉mote da Hebotoni nanema꞉ ateke Aisa꞉ke pita꞉ Eipoloha꞉ma꞉ yaapo hao hayeke alena꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisa꞉keta꞉ 180 bapi hao ");
INSERT INTO ssx_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ota꞉ koke yaa homeekeme. Kutupa ipika꞉ weki Iso pita꞉ Dieikope yaapoma꞉ hoipikime. ");
INSERT INTO ssx_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dota꞉ mo hande Iso o biki ma꞉nda꞉ Idomo la꞉la꞉ somena꞉ monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikina꞉ bikie. ");
INSERT INTO ssx_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isoma꞉ta꞉ Keinani wanda꞉weki miekeme. Ma꞉nda꞉ta꞉ Hidi hali Ilonona꞉ waneke Ada miekeme. Kutupa mo Hipi hali Sibionona꞉ eiyeke Anana꞉ waneke Oholibama make ");
INSERT INTO ssx_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Nebeiotona꞉ beliki Ba꞉sema꞉deta꞉ Isima꞉elona꞉ waneke make miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Titina꞉ wanda꞉ Adama꞉ta꞉ Elipa꞉se mendiaeyekeme. Ba꞉sema꞉dema꞉ta꞉ Leuelo mendiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Kutupa Oholibamama꞉ta꞉ Dieusi make Dialamo make Kota make mendiaeyekeme. Do weki paeyaota꞉ mo Keinani kenke pa꞉ta꞉ hata꞉ Isona꞉ mendiaemeke weki tonue. ");
INSERT INTO ssx_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Kutupa Isoma꞉ta꞉ ipika꞉ wanda꞉weki make eiyeke tonu make waneke tonu make ipika꞉ da pa꞉ta꞉ haemeke wanda꞉hali paeyao make ipika꞉ ma꞉na꞉manu make mo Keinani kenke pa꞉ta꞉ hata꞉ mieke alemanu paeyao tonka꞉na꞉ mea hameke Dieikope mina꞉pa꞉lao mo kenke ma꞉nda꞉ pa꞉ta꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ipiki mina꞉pa꞉laeyeke ekita꞉ mo Dieikope ipiliki haepeke kenketa꞉ ne doka꞉tiki yeke piekeme. Ipilika꞉ ma꞉na꞉ manuta꞉ wotu ta̱la̱o̱ handolo hata꞉ homeke pa꞉ta꞉ hapeke na yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Koto ekina꞉ Isota꞉ mo Idomona꞉ pote eli pa꞉ta꞉ pu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dota꞉ mo hande Idomo wanda꞉halina꞉ apa꞉mei Isona꞉ monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikie. ");
INSERT INTO ssx_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Isona꞉ weteke Adama꞉ta꞉ weki homeke Elipa꞉se mendiaeyekeme. Kutupa weteke ma꞉nda꞉ Ba꞉sema꞉dema꞉ta꞉ weki homeke Leuelo mendiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Isona꞉ eiyeke Elipa꞉sema꞉ta꞉ weki yunki hata꞉ mendiekeme. Ika꞉ biki manuta꞉ Temani make Oma make Sepo make Ka꞉tamo make Kena꞉se makee. ");
INSERT INTO ssx_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Kutupa Elipa꞉sena꞉ pa hameke e pokaeyeke wanda꞉ ma꞉nda꞉ Timinama꞉ta꞉ ipiki pa꞉ta꞉ weki homeke A꞉ma꞉leke mendiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Kutupa Isona꞉ eiyeke Leueloma꞉ta꞉ weki tonkopu mendiekeme. Ika꞉ biki manuta꞉ Nahati make Sita make Siama make Misa makee. Ikita꞉ mo Ba꞉sema꞉dena꞉ wekina꞉ eiyeke tonue. ");
INSERT INTO ssx_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isona꞉ weteke ma꞉nda꞉ Oholibamama꞉ta꞉ weki tepo mendiaeyekeme. Ika꞉ biki manuta꞉ Dieusi make Dialamo make Kota makee. Oholibamama꞉ta꞉ mo hande Sibionona꞉ eiyeke Anana꞉ wanekee. ");
INSERT INTO ssx_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dota꞉ mo Iso pa꞉ta꞉ yama꞉ epemeke tapake you hali manue. Mo Isona꞉ mupeke weki Elipa꞉seta꞉ do tapake manuna꞉ apa꞉meie. Temani make Oma make Sepo make Kena꞉se make ");
INSERT INTO ssx_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kota make Ka꞉tamo make A꞉ma꞉leke makee. Do tapake manuta꞉ mo Isona꞉ weteke Ada pa꞉ta꞉ yama꞉ epemeke tapake manue. ");
INSERT INTO ssx_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Isona꞉ eiyeke Leuelo pa꞉ta꞉ yama꞉ epeeke tapaketa꞉ Nahati make Sita make Siama make Misa makee. Do tapake manuta꞉ Isona꞉ weteke Ba꞉sema꞉de mendiaeyeke ekie. ");
INSERT INTO ssx_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Dota꞉ mo hande Anana꞉ waneke Oholibamama꞉ Isona꞉ mendiaeyeke weki tonuna꞉ tapakemanue. Dieusi make Dialamo make Kota make mendiaeyekeme ");
INSERT INTO ssx_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Koto tapake paeyaota꞉ Iso pa꞉ta꞉ yama꞉ epemeke tapakemanue ");
INSERT INTO ssx_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Mo Idomo kenke kini pea haemeke tapakemanu ika꞉ apa꞉meita꞉ mo Ho hali Seiyana꞉ monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandikie. Koto tapake manuna꞉ apa꞉meina꞉ biki manuta꞉ doe. Loutani make Soubalo make Sibiono make Ana make ");
INSERT INTO ssx_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disiono make Esa make Disiana꞉ makee. ");
INSERT INTO ssx_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Loutanita꞉ mo Hoti pita꞉ Hemane yaapona꞉ apa꞉meie. Kutupa Loutanina꞉ belikita꞉ Timinae. ");
INSERT INTO ssx_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Soubalota꞉ mo Elipani make Manahati make Ebalo make Siepo make Onamo make paeyaona꞉ apa꞉meie. ");
INSERT INTO ssx_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibionota꞉ weki yaapo Aiyali pita꞉ Ana yaapo mendiekeme. Anata꞉ mo hande atekena꞉ donkimanu mo hande hapu hayeke alema꞉ handeteke hata꞉ mo titipu piki ikali opeekeeki handa꞉ wieke somee. ");
INSERT INTO ssx_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anata꞉ mo Disionona꞉ atekee. Anama꞉ta꞉ wandiki ma꞉nda꞉ Oholibama make mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disionota꞉ do tapake manuna꞉ apa꞉meie. Hemedani make Esibani make Itidani make Dietani makee. ");
INSERT INTO ssx_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esata꞉ mo Bilihane make Sapani make Akane make koto tapake manuna꞉ apa꞉meie. ");
INSERT INTO ssx_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disiana꞉ta꞉ mo Usu pita꞉ Atani tapake yaapona꞉ apa꞉meie. ");
INSERT INTO ssx_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Koto mo hande Idomo kenke pa꞉ta꞉ haemeke Ho tapake manuna꞉ bikie. Loutani make Soubalo make Sibiono make Ana make Disiono make Esa make Disiana꞉ makee. ");
INSERT INTO ssx_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Amba꞉ta꞉ mo Isulai wanda꞉halita꞉ kinimanu ma꞉nda꞉ma꞉ na handeteke haena꞉ta꞉ mo Idomo kenke pa꞉ta꞉ kini pieke kini manuna꞉ bikimanu doe. ");
INSERT INTO ssx_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beona꞉ eiyeke Belata꞉ mo Idomona꞉ kini hali hayekeme. Ipika꞉ daonina꞉ bikita꞉ Dinihabae. ");
INSERT INTO ssx_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela homeeke dina꞉ta꞉ Sitana꞉ eiyeke Diobabema꞉ anketeke mea kini hali hayekeme. Ipika꞉ daonita꞉ Bositae. ");
INSERT INTO ssx_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Diobabe homeeke dina꞉ta꞉ Husamima꞉ ipika꞉ anketeke mea kini hali hayekeme. Ipikita꞉ mo Temani kenke pa꞉ta꞉ epeeke somee. ");
INSERT INTO ssx_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husami homeeke dina꞉ta꞉ Bedadena꞉ eiyeke Hadadema꞉ ipika꞉ anketeke mea kini hali hayekeme. Ipika꞉ daonina꞉ bikita꞉ Apitie. Ipikana꞉ma꞉ta꞉ mo Moa꞉be kenke pa꞉ta꞉ mo Midiani tapake ame̱le̱ a꞉nda꞉ pea bepolayeke somee. ");
INSERT INTO ssx_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadade homeeke dina꞉ta꞉ mo Maseteka hali Samelama꞉ ipika꞉ anketeke mea kini hali hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kutupa Samela homeeke dina꞉ta꞉ mo ikali tea꞉na꞉ hayeke Teihobodi daoni pa꞉ta꞉ hayeke some Siauluma꞉ ipika꞉ anketeke mea kini hali hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Siaulu homeeke dina꞉ta꞉ Akebona꞉ eiyeke Baele Hananema꞉ anketeke mea kini hali hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akebona꞉ eiyeke Baele Hanane homeeke dina꞉ta꞉ Hadadema꞉ anketeke miekeme. Ipika꞉ daonina꞉ bikita꞉ Paue. Ipika꞉ weteketa꞉ mo Mesahabena꞉ waneke Matededena꞉ waneke Mehetabelee. ");
INSERT INTO ssx_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Dota꞉ mo hande Iso pa꞉ta꞉ yama꞉ epeeke tapake manuna꞉ you haliwekina꞉ biki manue. Timina make Alapa make Dietede make ");
INSERT INTO ssx_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama make Ela make Pinono make ");
INSERT INTO ssx_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kena꞉se make Temani make Mibisa make ");
INSERT INTO ssx_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Makediele make Itame makee. Koto you haliwekimanu haemeke kenke manuta꞉ ika꞉ bikimanu yalao haemeke tapake manue. ");
INSERT INTO ssx_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Dieikopeta꞉ mo ipika꞉ ateke hayeke Keinani kenke pa꞉ta꞉ paa hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Kutupa dota꞉ mo ipika꞉ tapakena꞉ tamenie. Diosepeta꞉ 17 bapina꞉ pa꞉pa꞉na꞉ weki hata꞉ mo ipika꞉ atekena꞉ e pokaeyeke wanda꞉ yaapo Biliha pita꞉ Silipa yaapona꞉ eiyeke tonu ame̱le̱ mo sipisipimanu make nanikosimanu make handeteke haemekeme. Ipikana꞉ma꞉ta꞉ ateke pa꞉ta꞉ mo ipika꞉ hameke tonuma꞉ hoke tupa꞉ pia꞉tiki pimiki ekina꞉ pi mea a꞉pa꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Dieikopema꞉ta꞉ mo wekitonu anka꞉lopuna꞉ta꞉ Diosepe pa꞉ta꞉ homeke puki tieke wopuma꞉ homeekeme. Pa ekipe mo wekita꞉ ipiki koke nanema꞉ mendiaeyeke weki yeke handa piekeme. Ipikana꞉ma꞉ta꞉ mo wekina꞉ ta꞉ta꞉ ma꞉nda꞉ piki au leke kosa꞉ dau hokulupeke wepia haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kutupa mo ipika꞉ hameke tonuma꞉ ika꞉ atekema꞉ Diosepe pa꞉ta꞉ homeke puki tiekema꞉ wopu homeekeeki hando haota꞉ kota꞉ ika꞉ kame pa꞉ta꞉ta꞉ honditi pitolo hata꞉ homu piki pi manuma꞉ na la halemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Timba ma꞉nda꞉ta꞉ Diosepema꞉ upa pea mo ipika꞉ hameke tonu laa haleeketa꞉ kota꞉ ikana꞉ma꞉ ota꞉ mineke leke ale panka a꞉nda꞉ lia haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ipikana꞉ma꞉ alota꞉ Mo I̱ma꞉ pua꞉ upa kelepono opua꞉pe. ");
INSERT INTO ssx_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Niki paeyaota꞉ oni e pa꞉ta꞉ hata꞉ widimanu tonkaaso haoma꞉me. Kutupa yaka widi tonkaaketa꞉ tikitikina꞉ tialiao haya꞉me. Kutupa ika꞉eki manuma꞉ta꞉ yakaeki popei yao hata꞉ yaka widi tonkaake pa꞉ta꞉ panda꞉ puniaememe laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Koto leeke mo hameke tonuma꞉ lota꞉ pitolo alota꞉ Naka꞉ honema꞉ta꞉ neketa꞉ kini hali hata꞉ niki handeteke halipikie hone witelepe lemekeme. Koto ekina꞉ mo ipika꞉ upamanu tonka꞉na꞉ mo ipikana꞉ma꞉ a꞉pa la꞉tiki pieke pimanu tonka꞉na꞉ opia꞉tiki pitolo hata꞉ ikana꞉ma꞉ ota꞉ hoke mineke panka꞉tiki pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kutupa Diosepema꞉ upa ma꞉nda꞉ pea ipika꞉ hameke tonu pa꞉ta꞉ alota꞉ I̱ma꞉ upa ma꞉nda꞉ dupa pua꞉me. I̱ma꞉ta꞉ nate make kaisepo make kiki yaapona꞉ ankena꞉ homeke hombulanka꞉manu make handoa꞉me Kutupa moeki manuma꞉ta꞉ I̱ pa꞉ta꞉ panda꞉puniaememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ipikana꞉ma꞉ mo koto upata꞉ ipika꞉ ateke pa꞉ta꞉ make la haleeke handaata꞉ atekema꞉ ipiki hando alo hata꞉ alota꞉ Kotota꞉ ekipiki upa pea pelepe. Naka꞉ honema꞉ta꞉ naka꞉ ama꞉ma꞉ make naka꞉ kame tonuma꞉ make I̱ma꞉ make neke pa꞉ta꞉ a꞉pa panda꞉ punialumekee laa alepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Diosepena꞉ hameke tonuma꞉ta꞉ ipiki pa꞉ta꞉ wamili pimikipate atekema꞉ta꞉ mo ekina꞉ hone pa wia꞉tiki pu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Nate ma꞉nda꞉na꞉ Diosepena꞉ hameke tonuta꞉ mo atekena꞉ ma꞉na꞉manu handeteke halo oni Sekeme nane pua haena꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Dieikopema꞉ Diosepe pa꞉ta꞉ alota꞉ Yaka ta꞉na꞉ pa꞉la꞉ ekita꞉ neketa꞉ oni naka꞉ kame tonuma꞉ mo ma꞉na꞉manu handeteke haleme alena꞉ Sekeme nane poelena꞉e leekeme. Koto leeke Diosepema꞉ alota꞉ I̱ta꞉ poluekema꞉ tikitiki yalome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ipika꞉ atekema꞉ alota꞉ Mo naka꞉ kame tonuta꞉ epeke halemepe laa handolo puata꞉ mo ma꞉na꞉manu epeke tupa꞉ haemeka꞉na꞉ta꞉ kota꞉ paa la꞉ka꞉la I̱ lolo a꞉pa꞉peke leekeme. Koto ekina꞉ atekema꞉ mo wekita꞉ ika꞉ haemeke Hebotoni hadipi mina꞉pa꞉lao peneyeke tapaalo peekeme. Diosepeta꞉ mo Sekeme opolo pua ");
INSERT INTO ssx_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","mo pate pomu lopolo haena꞉ hali ma꞉nda꞉ma꞉ handa꞉ u hao lota꞉ pitolo hata꞉ alota꞉ Neketa꞉ aleke weitolo pipe laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Mo wekima꞉ hombo peaaso alota꞉ Mo yaka kame tonu ika꞉ ma꞉na꞉manu handeteke haleme pa꞉ta꞉ weitolome. Koto ekina꞉ mo iki haleme pa꞉ta꞉ handeka꞉na꞉ta꞉ I̱ la kie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mo halima꞉ alota꞉ Ikita꞉ amba꞉ pelememe. Ikita꞉ mo Dodani nane puluma꞉me lemeeki opua꞉me leekeme. Koto leeke Diosepeta꞉ hameke tonu telimea pua Dodani pua handa꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Mo hama̱la̱꞉ hama̱la̱꞉ma꞉ta꞉ Diosepe papate leke epeekeeki hando haota꞉ a̱i̱ na opolo epeke haena꞉ kone pi lo tonkaasota꞉ lu homaamana꞉e laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ika꞉ ika꞉ kone la alu alu pitolo hata꞉ alota꞉ Hande upa pu hala꞉ some ipula꞉mee. ");
INSERT INTO ssx_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ameta꞉ a̱i̱ lu homao ipika꞉ loketa꞉ oni naku ikali hapupapeke ekimanu ma꞉nda꞉ pa꞉ta꞉ lu baamana꞉e. Ipikita꞉ tikene ma꞉na꞉yeti sayale ma꞉nda꞉ma꞉ lia pa꞉la꞉me lomana꞉e. Kutupa ipika꞉ upama꞉ walea꞉eki manuta꞉ pilia꞉eki handomana꞉ loa꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Lubenima꞉ mo lemekeeki opu hao Diosepe tamba꞉ muluekema꞉ yeke alota꞉ Na lumana꞉ pipe. ");
INSERT INTO ssx_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tanda ma꞉nda꞉ na haleketa꞉ pa do hapekena꞉ ula꞉ naku pa꞉ta꞉manu lopamana꞉ pipe leekeme. Lubenima꞉ koto leeke ekita꞉ mo weki pa꞉ta꞉la꞉ mea ateke hala꞉ nane paa tapaalueke hone witolo hata꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Diosepe mo hameke tonu haemeke alena꞉ opolo epeeketa꞉ mo wekina꞉ ta꞉ta꞉ ma꞉nda꞉ piki au leke kosa꞉ dau hokulupeke titipula꞉ mea baemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kutupa mo weki meata꞉ mo ikali na pitieke naku pa꞉ta꞉ mea baemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Koto hoki nane ikita꞉ ne nalo pitina꞉ta꞉ koto kone mo Isima꞉elo tapake haliweki Kilia꞉de hao Idiepi nane yapemeeki handemekeme. Ika꞉ kemelo manuta꞉ mo ne tende peaasa꞉ alemanu make totopo piki ti pankekemanu make mu wia yapemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Diudama꞉ ipika꞉ hameke tonu pa꞉ta꞉ alota꞉ Mo nika꞉ kame lia a꞉mbaoma꞉ka꞉na꞉ta꞉ aleke ota꞉ handa꞉ uluma꞉pe. ");
INSERT INTO ssx_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Pao. Do Isima꞉elo tapakema꞉ hambena꞉ tapaamana꞉e. Kutu puma꞉ka꞉na꞉ta꞉ kota꞉ ipiki na hoeyaalumeke. Pa ekipeke ipikita꞉ nika꞉ kame make homeke loke we konee leekeme. Koto leeke ipika꞉ hameke tonuma꞉ta꞉ a꞉pa꞉la꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Kutupa mo Midianina꞉ ala꞉ta꞉ ala꞉ta꞉ tapao hala꞉ haliweki epemeketa꞉ mo hama̱la̱꞉ hama̱la̱꞉ma꞉ Diosepe oni naku pa꞉ta꞉ yola꞉ mea mo Isima꞉elo tapake pa꞉ta꞉ 20 silipa manima꞉ mea tapaemeke handaa mo haliwekima꞉ta꞉ hatuku Idiepi nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kutupa Lubenita꞉ oni naku pa꞉ta꞉ a꞉pa handeeke pate Diosepe na pitiekeeki hando haota꞉ a꞉ta꞉ pitolo hata꞉ ipika꞉ aka꞉manu sinki piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ipikita꞉ ipika꞉ hameke tonu pa꞉ta꞉ pua alota꞉ Mo wekita꞉ hande naku pa꞉ta꞉ na pila꞉ma꞉ I̱ma꞉ta꞉ eki pulua꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Koto ekina꞉ mo hameke tonuma꞉ nanikosi ma꞉nda꞉ lia Diosepena꞉ hokulupeke kosa꞉ dauta꞉ oni ma꞉na꞉ we kita kita pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kutupa mo dauta꞉ ateke pa꞉ta꞉ mea pua alota꞉ Do dauta꞉ handa꞉ uma꞉mee. Naka꞉ wekina꞉ eki ya꞉ka꞉ta꞉pe laa lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Mo atekema꞉ eiyekena꞉ eki ya꞉ka꞉ta꞉me laa handa꞉ u hao alota꞉ Aowe. Ipika꞉ ekie. Mandane tikene ma꞉na꞉yeti sayalema꞉ lia pia꞉ka꞉ta꞉me. Yaka weki Diosepeta꞉ sinki sinki pea wia pia꞉ka꞉ta꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Koto ekina꞉ Dieikopema꞉ta꞉ a꞉ta꞉ma꞉ homolo hata꞉ ipika꞉ aka꞉manu sinkipa busa꞉ pitikimanu yameekeme. Ipikana꞉ma꞉ta꞉ nate hokuluna꞉ eiyeke homa꞉ wia pitu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Kutu pieke ipika꞉ eiyeke tonuma꞉ make waneke tonuma꞉ make atekena꞉ puki epealo epemekepate pa mo ipiki epeaasa꞉ ekita꞉ kiaaso hata꞉ alota꞉ Oni homo hala꞉ kenke pa꞉ta꞉ pulu maketa꞉ yaka wekina꞉ homa꞉ pa upaleke polueke leekeme. Koto ekina꞉ eiyeke Diosepena꞉ homa꞉ pa utia peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kutu pitolo haena꞉ta꞉ mo Midiani tapakema꞉ta꞉ oni Idiepi pua Diosepeta꞉ mo kinina꞉ da handeteke haena꞉ leeke you some ma꞉nda꞉ Podipama꞉ hambena꞉ tapaemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Koto nate nina꞉ta꞉ Diudata꞉ hameke tonu mina꞉pa꞉lao mo Adalamo daoni hali Hita yaapo halo pu moneayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Koto pateta꞉ Diudama꞉ta꞉ Keinani hali ma꞉nda꞉ Suana꞉ waneke handeekeme. Kutupa mo wandiki meata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","hali weki mondu wiaota꞉ bikita꞉ Ea leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Weki loke paa lombaata꞉ hali weki ma꞉nda꞉ mondu wiata꞉ ipika꞉ bikita꞉ Onane leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Kutupa weki ma꞉nda꞉ mendiata꞉ bikita꞉ Sela leekeme. Diudata꞉ Kesibi haena꞉ do weki Sela mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Diudama꞉ta꞉ ipika꞉ mupeke weki Eana꞉ta꞉ biki Teima leke wanda꞉ meayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Eana꞉ hau manuta꞉ ota꞉ hoeyeke ekina꞉ Koda꞉ma꞉ ta꞉na꞉ma꞉ na homolo hata꞉ lu homaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Koto ekina꞉ Diudama꞉ Eana꞉ hameke Onane pa꞉ta꞉ alota꞉ Naka꞉ kamena꞉ weteke kineke yaapo polu pue la alota꞉ Mo hande nika꞉ pi la꞉ uluma꞉ tupa꞉ ipika꞉ halikina꞉ hameke hata꞉ mo naka꞉ kamena꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandiki haena꞉ yeke loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Pate Onanema꞉ta꞉ mo wekiwandikita꞉ ipika꞉eki dia꞉ya꞉lieke hone witolo hata꞉ta꞉ mo hamekena꞉ wanda꞉ kineke yaapo polu puluta꞉ hamekena꞉ wekiwandiki ma꞉nda꞉ na mendiaena꞉ yeketa꞉ ipika꞉ hali hapeketa꞉ kenkena꞉ pao yapena꞉ la꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ipikana꞉ma꞉ kutupiki hau pieke ekima꞉ta꞉ Koda꞉ ta꞉na꞉ma꞉ na homaeyeke handa Koda꞉ma꞉ta꞉ ipiki make lu homaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Koto ekina꞉ Diudama꞉ meiyeke wanda꞉ Teima pa꞉ta꞉ alota꞉ Mo yaka weki Sela daena꞉ hombota꞉ naka꞉ apa꞉na꞉ da pa꞉ta꞉ pa la꞉ka꞉la puata꞉ kineke wanda꞉ hapeke leekeme. Ipikana꞉ma꞉ doeki leeke ekita꞉ mo hande hameke yaapo pia꞉ tupa꞉ Sela make Koda꞉ma꞉ liliekee laa paala꞉ma꞉ homolo hata꞉ leekeme. Koto ekina꞉ Teimata꞉ ipika꞉ atekena꞉ da paa la꞉ka꞉la peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Natemanu hosiki haota꞉ Diudana꞉ weteke homeekeme. Kutupa mo homa꞉ wia pita paeyeketa꞉ ipiki pita꞉ ipika꞉ yankeke some mo Adalamo hali Hita yaapo Timina nane mo ipika꞉ sipisipimanu itiki ponda꞉laeyeke nane pepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kutupa ma꞉nda꞉ma꞉ Teima pa꞉ta꞉ alota꞉ Naka꞉ meita꞉ mo Timina nane ipika꞉ sipisipi manuna꞉ itiki pondololo yopula꞉me laa leekeeki opiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Koto ekina꞉ mo wanda꞉ma꞉ta꞉ mo ipika꞉ yamo hayeke kineke wanda꞉na꞉ aka꞉manu topo pea ipika꞉ leke popeleketa꞉ dau sinkipikima꞉ a꞉mbaota꞉ mo Timina pula꞉ pota꞉na꞉ hayeke daoni Eneimina꞉ pota꞉ kake pa꞉ta꞉ pua pitiekeme. Mo wanda꞉ma꞉ta꞉ Diudana꞉ wetepe weki Selata꞉ amba꞉ daela꞉pate kone I̱ na mina꞉ ala꞉me hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kutupa Diudama꞉ mo wanda꞉ hando haota꞉ ipika꞉ leke popeleke a꞉mbaeyeke ekima꞉ta꞉ pa yola꞉la꞉ wanda꞉ ma꞉nda꞉ hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ipikana꞉ma꞉ mo pota꞉ tea꞉na꞉ pua mo wanda꞉ pa꞉ta꞉ alota꞉ A꞉pa꞉la꞉ma꞉ naka꞉ yenkita꞉ ekipa kulua꞉pe leekeme. Ipikana꞉ma꞉ta꞉ mo wanda꞉ ipika꞉ meiwanda꞉ ya꞉ka꞉ta꞉me hone na wiekeme. Mo wanda꞉ma꞉ hombo peaaso alota꞉ I̱ta꞉ aleke kilipikipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Mo halima꞉ hombo peaaso alota꞉ I̱ma꞉ta꞉ mo yaka panake nanikosi ma꞉nda꞉ tapanealueke laa leekeme. Koto leeke mo wanda꞉ma꞉ alota꞉ A꞉pa꞉la꞉me. Kota꞉ mo ma꞉na꞉ a̱i̱ na kiki halena꞉ta꞉ aleta꞉ ma꞉nda꞉ amba꞉la꞉ ta꞉ka꞉li wia hawano kilipikipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Mo halima꞉ alota꞉ Kota꞉ mo ta꞉ka꞉li wia hawalo pele aleta꞉ aleke kionope leekeme. Mo wanda꞉ma꞉ hombo peaaso alota꞉ Mo ta꞉ka꞉li wia hawalo polo aleta꞉ mo naka꞉ pi lo tonkaaso hata꞉ ta̱la̱o̱ hale tombota꞉ ipika꞉ endu lopala꞉ pu make mo naka꞉ miniki hale tumapu tonka꞉na꞉ make kie leekeme. Koto leeke mo ale manuta꞉ mo wanda꞉ pa꞉ta꞉ haleekeme. Kutupa loke apa꞉tao mo wanda꞉ta꞉ weki loke lombeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kutupa Teimata꞉ da pua mo dau sinkipiki mea bao mo kineke wanda꞉na꞉ aka꞉manu paa pua mu pambaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Diudama꞉ta꞉ mo ipika꞉ yankeke Hita pa꞉ta꞉ alota꞉ Mo hande I̱ma꞉ diminaowa꞉ nanikosi mea pua mo hande wanda꞉ pa꞉ta꞉ halolo hata꞉ ya amba꞉ hande ta꞉ka꞉li wia hawaloa꞉ alemanu mea a꞉papeke laa leekeme. Hitata꞉ koto leeke peekepate mo hande wanda꞉ na handa꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ipikana꞉ma꞉ta꞉ mo Eneimi haemeke haliweki pa꞉ta꞉ alota꞉ Do hande pota꞉na꞉ pitia꞉ yola꞉la꞉ wanda꞉ta꞉ handoka꞉ta꞉pe laa lota꞉ piekeme. Mo haliwekima꞉ hombo peaaso alota꞉ Do pateta꞉ yola꞉la꞉ wanda꞉ ma꞉nda꞉ ota꞉ na hala꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Mo hande halita꞉ Diuda pa꞉ta꞉ paa la꞉ka꞉la pua alota꞉ Mo wanda꞉ta꞉ handa꞉ wia꞉peke na ya꞉me. Kutupa make mo koto da haliwekima꞉ make alota꞉ Do pateta꞉ yola꞉la꞉ wanda꞉ ma꞉nda꞉ na hala꞉me laa lememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Koto leeke Diudama꞉ alota꞉ Mo wanda꞉ma꞉ mo ale manuta꞉ pa wia haena꞉e. Wanda꞉halima꞉ diki kitaama꞉na꞉ loa꞉me. I̱ma꞉ta꞉ mo wanda꞉na꞉ yenki haluekema꞉ pua꞉pate mo wanda꞉ taa na handa꞉ wika꞉ta꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kutupa kaisepo tepomanu paena꞉ta꞉ Diuda pa꞉ta꞉ ma꞉nda꞉ma꞉ alota꞉ Naka꞉ mei wanda꞉ Teimama꞉ta꞉ hali yola꞉la꞉ wanda꞉ma꞉ handaaka꞉na꞉ ameta꞉ weki loke lomba꞉la꞉me leekeme. Koto leeke Diudama꞉ pi taka꞉lakema꞉ alota꞉ Koto wanda꞉ mea pua tima꞉ yankaa homena꞉ lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kota꞉ mo wanda꞉ta꞉ tima꞉ yanka homaluekema꞉ hama mea pulu haena꞉ta꞉ mo wanda꞉ma꞉ ipika꞉ meiyeke pa꞉ta꞉ pi tapaaso hata꞉ alota꞉ I̱ta꞉ do ale manuna꞉ teke somema꞉ weki mendiao pa꞉la꞉me. Koto ekina꞉ do pi lo tonkaaso hata꞉ ta̱la̱o̱ hala꞉ tombota꞉ ipika꞉ endu lopala꞉ pu make do tumapu tonka꞉na꞉ epina꞉ ekipe laa handa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Diudama꞉ mo hande alemanu handolo hata꞉ alota꞉ Mo wanda꞉ma꞉ta꞉ ota꞉ tikitikina꞉ pa꞉la꞉me. I̱ma꞉ta꞉ mo yaka weki Selama꞉ mina꞉ lapeke ale kone pa I̱ma꞉ pi la꞉ ua꞉eki ata꞉ka꞉ pealome leekeme. Koto ekina꞉ Diudama꞉ta꞉ mo wanda꞉ yaapo loke paa na apa꞉taeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Mo wanda꞉ ipika꞉ weki mulu pieke nate opolo epeeketa꞉ hone yaapo wiki weki mendilieke laa handa꞉ wimikime. ");
INSERT INTO ssx_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Kutupa mo wanda꞉ weki hoki nalo pitina꞉ta꞉ mo weki ma꞉nda꞉ma꞉ta꞉ kiki epena꞉ leeke handa mo weki meao hayeke wanda꞉ma꞉ kiki yola꞉ mea wepiki pu tunkilikima꞉ tonkao alota꞉ Doeki amba꞉la titina꞉ ma꞉nda꞉la꞉me leekepate ");
INSERT INTO ssx_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","pa mo wekima꞉ta꞉ ipika꞉ kiki paa yola꞉ mea mo hameke ma꞉nda꞉ amba꞉la mendiekeme. Kota꞉ mo weki meao hayeke wanda꞉ma꞉ alota꞉ Dupiki hauma꞉ta꞉ naka꞉ pota꞉ ponda꞉pa ipulu pika꞉ta꞉me leekeme. Kota꞉ ekina꞉ mo wekina꞉ bikita꞉ Petese leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kutupa mo ipika꞉ hameke mo wepiki pu kikina꞉ tonkaeyeke wekita꞉ wetepena꞉ mendia ipika꞉ bikita꞉ Sita lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Mo hande Isima꞉elo tapakema꞉ta꞉ Idiepi nane Diosepe hatuku pua mo kinina꞉ da handeteke haena꞉ leeke amina꞉ you some ma꞉nda꞉ Podipa pa꞉ta꞉ tapaemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mo Tekehalita꞉ Diosepe yaapo hayeke ekima꞉ ipika꞉ pieke hau paeyao epeayekeme. Ipikita꞉ mo ipika꞉ pahameke e pokao hayeke Idiepi halina꞉ da pa꞉ta꞉ pelia hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kutupa koto somema꞉ta꞉ mo Tekehalita꞉ Diosepe yaapo hayekeeki yalo ipika꞉ pieke hau paeya tapaoma꞉ ota꞉ epeke tupa꞉ piekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Koto ekina꞉ Podipama꞉ta꞉ mo wekima꞉ pieke hau manuna꞉ ta꞉na꞉ma꞉ homolo hata꞉ta꞉ ipika꞉ puki pi e pokaasa꞉ some haena꞉ alo hata꞉ta꞉ ipika꞉ da make ipika꞉ wia hayeke ala꞉ta꞉ ala꞉ta꞉ paeyaona꞉ handeteke hala꞉ you hali haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Koto natena꞉ kini peaata꞉ mo Diosepe hayeke ekina꞉ Tekehalima꞉ta꞉ mo Idiepi halina꞉ da pa꞉ta꞉ wieke alemanu paeyao make oni e nina꞉ haemeke alemanu make paeyao epeayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Podipama꞉ta꞉ mo ipika꞉ wia hayeke alemanu paeyao sikita꞉ Diosepena꞉ kiki pa꞉ta꞉ u moneaaso hata꞉ ipikita꞉ ala꞉ta꞉ ma꞉nda꞉na꞉ hone na wikita꞉ pa nolo pieke nena꞉ homeke hone wiekeme. Diosepeta꞉ loke panka hali seliapo hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kutupa hao hao peaata꞉ ipika꞉ you somena꞉ wetekema꞉ta꞉ mo wekina꞉ da tunkulolo hata꞉ da panda꞉ nane polupana꞉ pana꞉e laa honke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Koto leeke mo wekima꞉ kiaaso hata꞉ mo wanda꞉ pa꞉ta꞉ alota꞉ Handa꞉e. Yaka you halima꞉ta꞉ do I̱ halo ekina꞉ ipika꞉ da pa꞉ta꞉ ula꞉ alemanu paeyaota꞉ hone bao hala꞉me. Ipikana꞉ma꞉ta꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao I̱ma꞉ handeteke hano la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ipikana꞉ma꞉ta꞉ mo ipiki pa꞉ta꞉ ula꞉ honkopu kone I̱ pa꞉ta꞉ make ala꞉ta꞉ ala꞉ta꞉ paeyao handeteke hano la꞉la꞉pate neke homeke dia꞉me. Koto ekina꞉ pa I̱ma꞉ta꞉ Koda꞉ pa꞉ta꞉ hoke hau pitolo hata꞉ do nakana꞉ma꞉ ale hoke hauta꞉ ekipa peonope laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Mo wanda꞉ma꞉ta꞉ hoto paeyao Diosepe honke la꞉tia pulu hayekepate mo wanda꞉ yaapo ota꞉ na polu peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Kutu piekepate nate ma꞉nda꞉na꞉ta꞉ Diosepeta꞉ oni da pa꞉ta꞉ e pokulueke alo peekepate mo da pa꞉ta꞉ e pokao haemeke tapake ma꞉nda꞉ make ota꞉ na haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Koto ekina꞉ mo wanda꞉ma꞉ mo wekina꞉ dau hokulupeke mineke hata꞉ alota꞉ Oni da panda꞉ pa꞉ta꞉ dika꞉ polupana꞉ pana꞉ epoma leekepate mo wekita꞉ ipika꞉ dauta꞉ mo wanda꞉na꞉ kiki pa꞉ta꞉ hola꞉mea wia haena꞉ hama pindipa opolu baeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Mo wanda꞉ma꞉ta꞉ mo wekima꞉ ipika꞉ dau mina꞉pa꞉lao hama opolu baeya꞉ eki hando haota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kota꞉ mo wanda꞉ma꞉ ipika꞉ da pa꞉ta꞉ e pokaemeke mandane wanda꞉hali pa꞉ta꞉ e̱ wi alo alota꞉ Do ale handa꞉pee. Do hande yaka halikima꞉ hatuku epea꞉ Hibulu wekima꞉ta꞉ niki yala꞉ peake hau pa꞉la꞉mee. Ipikana꞉ma꞉ta꞉ yaka da panda꞉ pa꞉ta꞉ a꞉pa I̱ minuluekema꞉ pia꞉pate I̱ma꞉ ota꞉ anekema꞉ e̱ wi tieke loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Mo ipikana꞉ma꞉ta꞉ I̱ma꞉ e̱ wi loa꞉eki opu haota꞉ kota꞉ ipika꞉ dau wina꞉ wina꞉ pea hama opolu bao pa꞉la꞉mee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mo wanda꞉ma꞉ta꞉ Diosepena꞉ dauta꞉ pa wia pita mo wekina꞉ you some epeeke handaa waleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kutupa mo hande amba꞉ leekeeki kone paa laa halolo alota꞉ Mo nakana꞉ma꞉ hande hatuku epe pa hameke e pokaasa꞉ Hibulu wekima꞉ta꞉ yala꞉ peake hau puluekema꞉ yaka da panda꞉ pa꞉ta꞉ epea꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kutu piekepate pa mo I̱ma꞉ e̱ wi loa꞉ dina꞉ta꞉ do ipika꞉ dau wina꞉ wina꞉ pu hama opolu baeya꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kota꞉ Diosepena꞉ you somema꞉ kotoeki opu haota꞉ tetoma꞉ homolo hata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Diosepe minina꞉ laata꞉ mo kinina꞉ dipula haliweki pitaeyeke ale pa꞉ta꞉ dipula pitina꞉ leekeme. Kutupa Diosepeta꞉ koto pa꞉ta꞉ hao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Pate mo Tekehalita꞉ Diosepe yaapo hata꞉ ipiki epeayekeeki yalo mo dipula handeteke hayeke halima꞉ make Diosepe yaapo ta꞉na꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Koto ekina꞉ mo somema꞉ta꞉ Diosepeta꞉ mo mandane dipula haliweki paeyao handeteke haena꞉ laa make mo dipula da pa꞉ta꞉ pieke haumanu paeyaota꞉ ipikana꞉ma꞉ handeteke haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mo Tekehalita꞉ Diosepe yaapo hata꞉ ipika꞉ pieke haumanu paeyaota꞉ pu epeayeke handaa mo dipula handeteke hayeke somema꞉ta꞉ Diosepema꞉ handeteke haena꞉ leeke ale manuta꞉ ipikana꞉ma꞉ pa na handeteke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Hao hao pea nate ma꞉nda꞉na꞉ta꞉ mo Idiepi kinina꞉ waini ikali handeteke hayeke some pita꞉ betedi yanko hayeke some yaapoma꞉ta꞉ mo Kini somena꞉ puki ka꞉nda꞉ peaepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Koto ekina꞉ mo kinita꞉ mo ipika꞉ e pokaepeke you hali yaapo ame̱le̱ mineke pankolo hata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","mo hande Diosepe pitieke ale pa꞉ta꞉ oni dipula handeteke hayeke somena꞉ da pa꞉ta꞉ dipula mea pitaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Hali yaapota꞉ nate wotuna꞉ dipula pita꞉ta꞉ mo dipula handeteke hayeke somema꞉ta꞉ Diosepeta꞉ mo hali yaapona꞉ handeteke hala꞉ hali haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Timba ma꞉nda꞉na꞉ta꞉ mo dipula da pa꞉ta꞉ mo kinina꞉ waini ikali handeteke hayeke somema꞉ make mo betedi yanko hayeke somema꞉ make telipuna꞉ma꞉ upa teketa꞉ ta꞉ta꞉ pikieki pu alu pipikime. ");
INSERT INTO ssx_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Diosepeta꞉ da ka꞉la꞉paaso mo hali yaapo pa꞉ta꞉ epeekepate ipilikita꞉ wenoko homa꞉niao pitipipikieki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ipikana꞉ma꞉ mo hali yaapo lota꞉ pitolo hata꞉ alota꞉ Ameta꞉ ipilikita꞉ ekipeke wenoko homa꞉niao pitipipipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Koto leeke mo hali yaapoma꞉ hombo peaaso alota꞉ Diki telipuna꞉ma꞉ upa polopa꞉pate mo upa tekemanu la kulu pa꞉la꞉ some do pate ma꞉nda꞉ na hala꞉me lepekeme. Koto lepeke Diosepema꞉ alota꞉ Mo upa la꞉ka꞉la hala꞉peke ekina꞉ honkoputa꞉ Koda꞉ma꞉ kone kitolo pita꞉la꞉me. Ipilika꞉ upa yaapo la kipee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","Koto ekina꞉ mo kinina꞉ waini ikali handeteke hayeke somema꞉ alota꞉ Ya upama꞉ta꞉ mo yaka puki nanema꞉ta꞉ hopiki tepo hake waini pu hayekeme. Mo katakemanu duta꞉pa lopa꞉ lopa꞉ pia꞉ dina꞉ koneta꞉ mo momamanu liaata꞉ mo waini kilikimanu make koto kone potea꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","I̱ma꞉ta꞉ mo kinina꞉ kapo miniki hata꞉ pueke ale mo waini kilikimanu mea oni kapo pa꞉ta꞉ dekepo pamba mo kini pa꞉ta꞉ haloa꞉me laa la haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Diosepema꞉ alota꞉ Mo upana꞉ teketa꞉ do ekina꞉ peleme. Mo hopiki tepota꞉ nate tepoe. ");
INSERT INTO ssx_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mo tepo natena꞉ta꞉ kinima꞉ neketa꞉ dipula mina꞉pa꞉lalena꞉ laa naka꞉ hande poko hae e paa pokoelena꞉ la꞉lieke. Kutupa nakana꞉ma꞉ta꞉ mo hande amba꞉ waini ikali handeteke hae tupa꞉ mo kinina꞉ kapo paa halo halipikie. ");
INSERT INTO ssx_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Koto pa꞉la꞉pate mo neke epeke tupa꞉ pua hao pelika꞉na꞉ta꞉ I̱ hone wia꞉peke. Kutupa make pilisi I̱ do dipula mina꞉pa꞉lano a꞉ta꞉ma꞉ homa tamba꞉ minolo hata꞉ta꞉ mo kini pa꞉ta꞉ pua opuapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Pa ekipeke I̱ta꞉ mo Hibulu tapakena꞉ kenke pa꞉ta꞉ta꞉ pake mea a꞉pa ame do Idiepi kenke pa꞉ta꞉ maketa꞉ I̱ma꞉ dipula pula꞉ hau ma꞉nda꞉ na pua꞉pate kone pelememe laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kota꞉ mo hande betedi yanko hayeke you somema꞉ta꞉ mo kinina꞉ waini ikali handeteke hayeke you halina꞉ upa tekemanu la haleeke ekita꞉ epeke tupa꞉ la haleeke handa ipikana꞉ma꞉ make Diosepe pa꞉ta꞉ alota꞉ I̱ma꞉ make upa dupa pua꞉me. I̱ta꞉ betedi wiki kawaso paeyao tepo yaka youna꞉ tuekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kutupa mo ota꞉ manda tepo peao tueke ekina꞉ta꞉ mo kinina꞉ anemone ta꞉ta꞉ ta꞉ta꞉ piki palaowa kitikimanu yekeme. Kutupa mo ba manuma꞉ mu nememe. ");
INSERT INTO ssx_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Diosepema꞉ hombo peaaso alota꞉ Teketa꞉ dupae. Mo kawaso tepota꞉ nate tepo la pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nate tepona꞉ta꞉ kinima꞉ neketa꞉ dipula mina꞉pa꞉lalena꞉ laata꞉ naka꞉ make tunkilieke. Kutupa naka꞉ loketa꞉ ti hokuluna꞉ endialimi alena꞉ mo ba titima꞉ naka꞉ loke nelimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Kota꞉ nate tepo paeyeketa꞉ mo kinima꞉ ipika꞉ mendieke nate mieke handa ipika꞉ you haliweki manuna꞉ ne pambaaso hata꞉ mo hande ipika꞉ waini ikali handeteke hatiki pieke you some make mo betedi yanko hatiki pieke you some make telipuna꞉ dipula da mina꞉pa꞉lao mo ipika꞉ you haliweki pitimiki alena꞉ hatuku epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ipikana꞉ma꞉ta꞉ mo waini ikali handeteke hayeke you someta꞉ ipika꞉ amba꞉ hande ena꞉ paa haena꞉ alo hata꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","mo palaowa yanko hatiki pieke you someta꞉ lia endiayekeme. Do hau paeyaota꞉ mo hande Diosepema꞉ leeke tupa꞉ siki kone piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Pate mo kinina꞉ waini ikali handeteke hawayeke somema꞉ta꞉ Diosepe ota꞉ hone na wiki hone yonka꞉la kilipayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Koto hao pea bapi yaapo paeyeketa꞉ mo Idiepi kini ipika꞉ upama꞉ta꞉ ipikita꞉ mo Naili ikali tea꞉na꞉ hayekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kutupa mo ikali pa꞉ta꞉ yama꞉ta꞉ loke panka wiki yonkeleke homu piki wataake hata꞉ kaomanu opa꞉liaota꞉ mo ambumanu nalo haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kutupata꞉ pa mandane wataake hata꞉ kaomanu make opa꞉liaememe. Koto kao manuta꞉ loke dia꞉ya make pa꞉ta꞉liki holiki yapeekeme. Ikita꞉ mo titina꞉ kaomanu haemeke alena꞉ mo ikali tea꞉na꞉ mandakena꞉ pua haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kutupa mo loke dia꞉yeke kao manuma꞉ta꞉ mo loke panka wiki kaomanu na꞉ta꞉ paemekeme. Kotoeki handolo hata꞉ mo kinita꞉ paa tiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kutupa ipiki paa polu hola꞉pa upa ma꞉nda꞉ dupa piekeme. Kunima꞉ handeke ale widi opeekeeki liki homekena꞉ta꞉ napeke paeyao wataake hata꞉ wiekeme. Mo napeke manuta꞉ panka wia napea wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kutupa pa wataake hata꞉ widi napekemanu homeke ekina꞉ ombu opa꞉liaeyekepate mo napeketa꞉ na pankeekeme. Kota꞉ mo hapupa pa꞉la꞉ alena꞉ yama꞉ epeeke titipu piki poma꞉ta꞉ mo napeke pou taeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kutupa mo na pankeke widi napeke manuma꞉ta꞉ mo panka wiki napekemanu mea na꞉ta꞉ paemekeme. Kota꞉ mo kini tiaota꞉ upama꞉ pua꞉ka꞉ta꞉me laa handa꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Da ka꞉la꞉paasota꞉ mo kinima꞉ta꞉ hone ka꞉nda꞉ma꞉ homolo hata꞉ mo Idiepi kenke pa꞉ta꞉ haemeke ti̱o̱ haliweki make mo hone u lenkene pimiki tapake make wi la꞉ mipi piekeme. Kutupa koto haliweki paeyao pa꞉ta꞉ta꞉ ipika꞉ upa yaapo kelepeekepate homeke a꞉nda꞉ma꞉ teke ota꞉ la hala꞉peke na yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Koto ekina꞉ mo waini ikali handeteke hayeke you somema꞉ mo kini pa꞉ta꞉ alota꞉ I̱ma꞉ta꞉ hoke hau poloma꞉ ame neke pa꞉ta꞉ keleponoe. ");
INSERT INTO ssx_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Nakana꞉ma꞉ta꞉ mo amba꞉ palaowa yanko haya꞉ some diki pa꞉ta꞉ mineke pankolo hata꞉ mo dipula handeteke hala꞉ somena꞉ da pa꞉ta꞉ dipula mea lopaeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kota꞉ timba ma꞉nda꞉na꞉ diki telipuna꞉ma꞉ teke ta꞉ta꞉ wiki upa pu alu pupa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Koto pa꞉ta꞉ta꞉ diki ame̱le̱ mo Hibulu weki ma꞉nda꞉ haya꞉me. Ipikita꞉ mo naka꞉ da handeteke haena꞉ lele amina꞉ you somena꞉ pa hameke e pokaasa꞉ weki yekeme. Dikana꞉ma꞉ta꞉ ipiki pa꞉ta꞉ dika꞉ upa kelepopeke handaata꞉ mo upa yaapona꞉ teketa꞉ ipikana꞉ma꞉ diki la kia꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Koto mo somema꞉ lea꞉ tupa꞉ koneta꞉ nakana꞉ma꞉ I̱ta꞉ yaka e paa kipate mo betedi yanko haya꞉ you someta꞉ lu endiaeme laa la haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Koto leeke ekina꞉ mo kinima꞉ Diosepe handa꞉ mealo pupa꞉ leeke handaa koto kone mo dipula da pa꞉ta꞉ handa꞉ mea epeekeme. Mo weki ipika꞉ yankake itiki mea aka꞉ topo pea paeyeketa꞉ mo kinina꞉ leke popelekena꞉ epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kutupa mo kinima꞉ ipiki pa꞉ta꞉ alota꞉ I̱ma꞉ta꞉ upa pua꞉pate ma꞉nda꞉ma꞉ koto upana꞉ teke la kia꞉peke na ya꞉la꞉me. Ma꞉nda꞉ma꞉ I̱ pa꞉ta꞉ alota꞉ Nakana꞉ma꞉ta꞉ mo upa tekemanu lapeke ya꞉la꞉me laa lea꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Koto leeke Diosepema꞉ hombo peaaso alota꞉ Aneke halio. I̱ma꞉ta꞉ pea꞉peke na ya꞉la꞉pate pa Koda꞉ma꞉ homeke epeke tupa꞉ teke la kilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Mo kinima꞉ alota꞉ Yaka upama꞉ta꞉ I̱ta꞉ mo Naili ikali tea꞉na꞉ hata꞉ puekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Kutupa mo ikali pa꞉ta꞉ yama꞉ta꞉ loke panka wiki yonkeleke homu piki wataake hata꞉ kaomanu opa꞉liaota꞉ mo ambumanu nalo haememe. ");
INSERT INTO ssx_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kutupata꞉ pa wataake hata꞉ kaomanu opa꞉liaememe. Mo koto kao manuta꞉ loke dia꞉ya pa꞉ta꞉liki holiki yapeekeme. Koto kao manuta꞉ do Idiepi kenke pa꞉ta꞉manu I̱ ota꞉ ma꞉nda꞉ na hando alo ota꞉ hoke kaomanu yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Mo loke na pankeke kao manuma꞉ta꞉ mo loke panka wiki kaomanu na꞉ta꞉ paememe. ");
INSERT INTO ssx_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kutu pimipate mo kaomanu nemekeeki ma꞉nda꞉ma꞉ handa꞉ wia꞉peke na ya꞉me. Pa ekipeke mo kao manuta꞉ mo hande amba꞉ haeme tupa꞉ kone paa haemekeme. Kutupata꞉ I̱ tiaowa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Koto timba kone pa upa ma꞉nda꞉ pua꞉ ekita꞉ mo kunima꞉ handeke ale widi opeekeeki homeke likina꞉ta꞉ napeke paeyao wataake hata꞉ wiekeme. Mo napeke manuta꞉ panka wia napea wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kutupa pa wataake hata꞉ widi napekemanu homeke ekina꞉ ombu opa꞉liaeyekepate mo napeketa꞉ na pankeekeme. Kota꞉ mo hapupa pa꞉la꞉ alena꞉ yama꞉ epeeke titipu piki poma꞉ta꞉ mo napekemanu pou taeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kutupa mo na pankeke widi napeke manuma꞉ta꞉ mo panka wiki napekemanu na꞉ta꞉ paememe. I̱ma꞉ta꞉ do upa yaapota꞉ mo ti̱o̱ haliweki pa꞉ta꞉ kelepoa꞉pate pa homeke a꞉nda꞉ma꞉ teke ota꞉ la kia꞉peke na ya꞉me laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Diosepema꞉ mo kini pa꞉ta꞉ alota꞉ Mo upa yaapona꞉ teketa꞉ homeke konee. Koda꞉ma꞉ta꞉ mo ipikana꞉ma꞉ pulu pa꞉la꞉eki neke pa꞉ta꞉ la ka꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Mo panka wiki wataake hata꞉ kao manuta꞉ wataake hata꞉ bapi manue. Kutupa mo panka ula꞉ wataake hata꞉ kunima꞉ handeke widi napeke make homeke tupa꞉ wataake hata꞉ bapi manue. Mo upa yaapona꞉ teketa꞉ homeke konee. ");
INSERT INTO ssx_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Kutupa mo wetepena꞉ opa꞉liaeyeke loke na pankeke wataake hata꞉ kaomanu pita꞉ mo na pankeke kunima꞉ handeke widi napeke mo hapupa pa꞉la꞉ alena꞉ yama꞉ epeeke titipu piki poma꞉ pou taeya꞉ ekina꞉ teketa꞉ bapi wataake hata꞉na꞉ tea꞉ ki tieke epolo pa꞉la꞉ekie. ");
INSERT INTO ssx_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kotota꞉ mo amba꞉ hande la kua꞉ tupa꞉e. Koda꞉ma꞉ta꞉ mo ipikana꞉ma꞉ pulu pa꞉la꞉eki neke pa꞉ta꞉ wala꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kota꞉ mo bapi wataake hata꞉na꞉ta꞉ do Idiepi kenke paeyao pa꞉ta꞉ta꞉ ne wotu tande pilieke. ");
INSERT INTO ssx_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kotoeki hoki naneta꞉ bapi wataake hata꞉na꞉ tea꞉ ki ipilieke. Koto hoke tea꞉ ki ipulu do kenke hoeyaeya꞉ka꞉na꞉ta꞉ kota꞉ ikana꞉ma꞉ mo hande epeke bapi manuta꞉ hone yonka꞉lalimikie. ");
INSERT INTO ssx_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Mo ne tande pea꞉ bapi manuta꞉ ota꞉ hone yonka꞉lalimikie. Pa ekipeke mo ipilia꞉ tea꞉ kita꞉ ota꞉ teto pikieki ipilieke. ");
INSERT INTO ssx_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Mo hoto yaapo peao pele upana꞉ teketa꞉ mo Koda꞉ma꞉ ota꞉ pulueke laa wia kutupa teke pa꞉ta꞉ kone pina꞉ lelieke. ");
INSERT INTO ssx_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Koto ekina꞉ nakana꞉ma꞉ mo hone u lenkene pa꞉la꞉ hali ma꞉nda꞉ma꞉ do kenke handeteke haena꞉ ma̱leke luelena꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kutupa make mandane handeteke halo pimiki you halimanu meata꞉ mo ne wopu wita꞉la꞉ bapi wataake hata꞉na꞉ta꞉ koto haliwekima꞉ta꞉ mo wanda꞉hali paeyaona꞉ amu pimi ne manuta꞉ yunki hata꞉ lo wina꞉ laata꞉ homeke lo meata꞉ mu mombelena꞉ lapeke. ");
INSERT INTO ssx_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Mo tapakema꞉ta꞉ mo ipula꞉ epeke bapimanu pa꞉ta꞉ta꞉ koto ne paeyaomanu mu mombelena꞉ laata꞉ Kutupa oni daoni pa꞉ta꞉manu koto kunima꞉ handeke widi kilikimanu wia꞉peke damanu a꞉ena꞉ biki halaata꞉ handeteke haena꞉ lena꞉ lapekee. ");
INSERT INTO ssx_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Mo koto Idiepi kenke pa꞉ta꞉ epolo pa꞉la꞉ tea꞉ kita꞉ mo amu pea wilimi nema꞉ do Idiepi wanda꞉hali paeyao epealieke. Do hau pika꞉na꞉ta꞉ wanda꞉hali paeyao tea꞉ma꞉ na homilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Mo kini hali pita꞉ ipika꞉ you haliwekima꞉ make do Diosepema꞉ leeke pina꞉ a꞉pa꞉la꞉me laa ");
INSERT INTO ssx_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","mo kini halima꞉ ipika꞉ haliweki pa꞉ta꞉ alota꞉ Nikana꞉ma꞉ta꞉ mo Diosepe ankulake Koda꞉na꞉ Sipitidi pila꞉ hali ma꞉nda꞉ ota꞉ na handa꞉ ulumeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kutupa mo kinima꞉ Diosepe pa꞉ta꞉ alota꞉ Koda꞉ma꞉ do hau paeyao neke pa꞉ta꞉ wala꞉la꞉ma꞉ mo nakana꞉ma꞉ aneke tupa꞉ hone u lenkene pitele ekita꞉ paeyao ota꞉ ankulaleeki handoloma꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","I̱ma꞉ neketa꞉ yaka kenke paeyao handeteke halena꞉ laata꞉ mo yaka wanda꞉hali paeyaoma꞉ta꞉ nakana꞉ma꞉ pipa꞉ lelipieki opua pina꞉ lolueke. Naka꞉ handeteke hale ekita꞉ ya handeteke halo ekina꞉ yaapo peao wina꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Koto ekina꞉ I̱ma꞉ neketa꞉ do Idiepi kenke paeyaona꞉ kapomanina꞉ handeteke hala꞉ you hali pituelena꞉ ame ma̱leke litolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Mo kinima꞉ta꞉ mo kapomanina꞉ handeteke pila꞉ ekina꞉ pi tonkao u hala꞉ linita꞉ ipika꞉ kikina꞉ hola꞉ mea Diosepena꞉ kikina꞉ pitaeyekeme. Kutupa ipika꞉ lokena꞉ mo epeke dau seliapo ma꞉nda꞉ pambawaota꞉ koloma꞉ wepiki senipu ipika꞉ make pa꞉ta꞉ mokaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kutupa pomu lopena꞉ta꞉ mo kinima꞉ ipika꞉ yaapo peao hosima꞉ yola pula꞉ ale mo Diosepe pa꞉ta꞉ halaata꞉ mo ipika꞉ handeteke haemeke haliwekita꞉ Diosepe titina꞉ amba꞉la pulu hata꞉ e̱ wi la꞉ moneaaso alota꞉ Pota꞉ pilae. Pota꞉ pilae laa lena꞉ leekeme. Koto ekina꞉ta꞉ Diosepeta꞉ Idiepi kenke paeyao pa꞉ta꞉ kapomanina꞉ handeteke hala꞉ hali pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Mo kinima꞉ ipiki pa꞉ta꞉ alota꞉ I̱ta꞉ kini ya꞉la꞉ ekina꞉ do Idiepi kenke paeyao pa꞉ta꞉ hala꞉ some homeke ma꞉nda꞉ sikima꞉ nakana꞉ma꞉ a꞉pa꞉la꞉ma꞉ aleeki na miki hata꞉ta꞉ kiki anke kone na mea mina꞉liaena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Kutupa Diosepeta꞉ mo Idiepi biki ma꞉nda꞉ Sa꞉pena꞉de Pania halaata꞉ mo Heliopolisi daoni pa꞉ta꞉ hayeke yeni peao hayeke hali Podipitana꞉ waneke A꞉sena꞉de mina꞉ haleekeme. Diosepeta꞉ 30 bapina꞉ mo Idiepina꞉ kinina꞉ e kini pea pokaeyekeme. Ipikita꞉ mo kinina꞉ da mina꞉pa꞉lao mo Idiepi kenke honiki paeyao pa꞉ta꞉ pomu lopeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mo ne tandepeeke bapi wataake hata꞉ pa꞉ta꞉ta꞉ ota꞉ ne tieke opeeketa꞉ ");
INSERT INTO ssx_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Diosepema꞉ meata꞉ mo daoni pa꞉ta꞉manu da a꞉eya mu mombeleekeme. Daoni homeke homeke pa꞉ta꞉ta꞉ koto daoni tea꞉na꞉ hao yapeeke e pa꞉ta꞉manu ne meata꞉ da a꞉eya mu momba꞉la wia꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Kunima꞉ handeke widita꞉ ota꞉ tieke wieke ekiyalo Diosepema꞉ta꞉ tombo mieke ekita꞉ mina꞉pa꞉laeyekeme. Mo widita꞉ dawalana꞉ houma꞉ handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Mo tea꞉ ki epolo pia꞉ bapimanu a̱i̱ na epeke haena꞉ta꞉ A꞉sena꞉dema꞉ Diosepena꞉ weki yaapo mendiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Diosepema꞉ alota꞉ Mo Tekehalima꞉ta꞉ mo I̱ma꞉ mua꞉ ka꞉nda꞉manu make yaka tapake make hone yonka꞉lano la꞉la꞉me laata꞉ Mo mupeke wekina꞉ bikita꞉ Ma꞉na꞉sa꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Kutupa make alota꞉ Koda꞉ma꞉ta꞉ mo yaka ka꞉nda꞉ molo kenke pa꞉ta꞉ wekiwandiki ka꞉la꞉me laa mo yaapo peao mendieke wekina꞉ bikita꞉ Ipoteimi leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Kutupa mo hande Idiepi tapakena꞉ ne tande peeke ta꞉na꞉ma꞉ homemeke wataake hata꞉ bapita꞉ paelo epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kutupa mo hande Diosepema꞉ leeke tupa꞉ kone mo tea꞉ kina꞉ wataake hata꞉ bapi kini piekeme. Kenke ma꞉nda꞉ ma꞉nda꞉ pa꞉ta꞉ta꞉ tea꞉ ki tieke epeekepate Idiepi kenke pa꞉ta꞉ homeketa꞉ ne pa wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Mo Idiepi wanda꞉ hali tea꞉ma꞉ homolota꞉ mo kini pa꞉ta꞉ nena꞉ honke loloendi pimikime. Koto ekina꞉ mo kinima꞉ ikita꞉ Diosepe pa꞉ta꞉ pena꞉ laata꞉ mo ipikana꞉ma꞉ pipe lelia꞉eki pia꞉pa꞉peke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Mo tea꞉ kita꞉ mo Idiepi kenke paeyao pa꞉ta꞉ putupolo hata꞉ ota꞉ hoeya꞉tia peeke handa Diosepema꞉ta꞉ mo ne damanu lumba mo Idiepi wanda꞉hali pa꞉ta꞉ widimanu tapatiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mo tea꞉ kita꞉ kenke ta꞉ta꞉ ta꞉ta꞉ paeyao pa꞉ta꞉ ota꞉ hoke tupa꞉ putupieke handaa mo kenke ta꞉ta꞉ ta꞉ta꞉ pa꞉ta꞉ haemeke wanda꞉halita꞉ oni Idiepi da pa꞉ta꞉ widi hambuluekema꞉ Diosepe pa꞉ta꞉ epemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Dieikopema꞉ta꞉ mo Idiepi nane widi ula꞉me leekeeki opu hao ipika꞉ eiyeke tonu pa꞉ta꞉ alota꞉ Ikana꞉ma꞉ta꞉ ekipeke hau ma꞉nda꞉ na pitelemepe. ");
INSERT INTO ssx_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Oni Idiepi kenke pa꞉ta꞉ widi ula꞉ma꞉ aleke opitolo loa꞉ma꞉ do niki tea꞉ma꞉ homaama꞉na꞉ma꞉ koto nane pua hamba꞉pee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Koto ekina꞉ta꞉ Diosepena꞉ hameke tonu paeyao kiki yaapo weki tonuta꞉ Idiepi nane widi hambolo pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Pate Dieikopema꞉ta꞉ mo Diosepena꞉ hameke wetepe nane weki Benisaminita꞉ mo hameke tonu ame̱le̱ na tapaeyekeme. Pa ekipeke ipika꞉ honema꞉ta꞉ mo weki pa꞉ta꞉ hau ma꞉nda꞉ peaama꞉na꞉e hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Mo Keinani kenke paeyao pa꞉ta꞉ta꞉ tea꞉ ki tieke pambeke handaata꞉ mo Dieikopena꞉ eiyeke tonu ame̱le̱ mandane wanda꞉hali make apa꞉tao widi hambolo pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Mo Idiepi kenkena꞉ kapomani handeteke hayeke some Diosepema꞉ta꞉ mo kenke honiki wanda꞉hali paeyao pa꞉ta꞉ widi tapatiki piekeme. Koto ekina꞉ mo ipika꞉ hameke tonuma꞉ta꞉ Diosepe pa꞉ta꞉ leke popeleke oni kenkena꞉ wataaso haena꞉ a꞉pa panda꞉ puniaemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Diosepema꞉ mo ipika꞉ hameke tonuta꞉ handeekepate kone ipikana꞉ma꞉ pa na handeke nono pea hayekeme. Ipikana꞉ma꞉ mo tapake pa꞉ta꞉ pi taka꞉lakema꞉ lota꞉ pitolo alota꞉ Ikita꞉ hanema꞉ epelemepe leekeme. Koto leeke mo tapakema꞉ hombo peaaso alota꞉ Nikita꞉ mo Keinani hao ne hambuluekema꞉ a꞉pa puma꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Mo Diosepema꞉ta꞉ ipika꞉ hameke tonue laa handa꞉ wiekepate mo hama̱la̱꞉ hama̱la̱꞉ma꞉ta꞉ ika꞉ kamee laa na handa꞉ wimikime. ");
INSERT INTO ssx_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ipikana꞉ma꞉ mo amba꞉ handa꞉ ikina꞉ pieke upamanu niminaaso hata꞉ alota꞉ Ikita꞉ kika ikiki haliwekie. Ikita꞉ mo nika꞉ kenke hando pa꞉ta꞉ damako pa꞉la꞉pe laa handolo a꞉pa pelememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Koto leeke mo tapakema꞉ alota꞉ Tiekeo. Dia꞉me. Nikita꞉ naka꞉ e pa hameke e pokaasa꞉ tapake au laa ne hambolo epoma꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tiekeo. Nikita꞉ hama̱la̱꞉ hama̱la̱꞉e. Nikita꞉ kika ikiki haliweki dia꞉me. Nikita꞉ ota꞉ hau pu haloma꞉ haliwekie lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Pate Diosepema꞉ mo tapake pa꞉ta꞉ alota꞉ Dia꞉me. Ikita꞉ mo nika꞉ kenke hando pa꞉ta꞉ damako pa꞉la꞉pe laa handolo epelememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Mo tapakema꞉ alota꞉ Tiekeo. Nikita꞉ paeyao kiki yaapo paeya ankena꞉ yaapo hama̱la̱꞉ hama̱la̱꞉ ya꞉me. Mo Keinani kenke pa꞉ta꞉ hala꞉ some homekena꞉ wekitonue. Pate weki homeketa꞉ homea꞉me. Kutupa mo wetepe nane wekita꞉ nika꞉ apa꞉ yaapo hala꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Diosepema꞉ hombo peaaso alota꞉ Pa mo hande I̱ma꞉ loa꞉ handa꞉e. Ikita꞉ kika ikiki haliwekie. ");
INSERT INTO ssx_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ameta꞉ dota꞉ iki yokaalo polo tupa꞉e. I̱ma꞉ta꞉ mo kinina꞉ bikina꞉ keke pi alo alota꞉ Ikita꞉ a̱i̱ na peke pa haota꞉ ika꞉ wetepe nane weki epea꞉ka꞉na꞉ta꞉ pelimikie. ");
INSERT INTO ssx_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Iki homeke ma꞉nda꞉ma꞉ mo weki handa꞉ mulu pua꞉pa꞉peke. Paeyaota꞉ dipula pitaota꞉ mo ika꞉ aleme ekita꞉ ota꞉pe laa amba꞉la꞉ yokaalumeke. Dia꞉ ya꞉ka꞉na꞉ta꞉ kota꞉ mo nika꞉ kini ota꞉ hala꞉ ekina꞉ta꞉ ikita꞉ kika ikiki haliwekie laa peneme ya꞉lieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kutupata꞉ mo tapaketa꞉ hoto tepo dipula pitaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mo tepo natena꞉ Diosepema꞉ mo tapake pa꞉ta꞉ alota꞉ I̱ta꞉ Koda꞉ paala꞉ haso hali ya꞉la꞉ ekina꞉ hau homeke homeketa꞉ iki homaama꞉na꞉ I̱ma꞉ tamba꞉ mulueke. ");
INSERT INTO ssx_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ikana꞉ma꞉ta꞉ ota꞉ pi lelemepe laa handa꞉ uluekema꞉ta꞉ iki homeke ma꞉nda꞉ta꞉ dipula pa pitina꞉e. Kutupa iki paeyaota꞉ pa la꞉ka꞉la pua mo hande hambeme widi manuta꞉ ika꞉ tea꞉ma꞉ homa꞉la꞉ tapake pa꞉ta꞉ mea poemena꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Kutupa ika꞉ kame wetepe wekita꞉ I̱ pa꞉ta꞉ hatuku a꞉pa꞉pa꞉peke. Koto hau pilimi ekima꞉ta꞉ ikana꞉ma꞉ ota꞉ pi lelememe laa iki na lu homalueke leekeme. Ikana꞉ma꞉ta꞉ do pina꞉ a꞉pa꞉la꞉me laa ");
INSERT INTO ssx_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ika꞉ ika꞉ kone alota꞉ Aowe. Ameta꞉ mo hande nika꞉ kame pa꞉ta꞉ puma꞉ hauna꞉ kiliki kone taloloma꞉me. Nikana꞉ma꞉ta꞉ mo ipiki ka꞉nda꞉ tieke minolo hata꞉ ipiki tamba꞉ mipee laa honke lea꞉ ekita꞉ handolo hata꞉ kone na opuma꞉me. Kutu puma꞉ ekina꞉ta꞉ ame nikita꞉ do ka꞉nda꞉ pa꞉ta꞉ haloma꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Lubenima꞉ alota꞉ Kota꞉ I̱ma꞉ iki pa꞉ta꞉ta꞉ mo weki na lia꞉pa꞉pee loa꞉pate ikana꞉ma꞉ta꞉ yaka pi na opimime. Koto ekina꞉ ameta꞉ ipika꞉ homa꞉la꞉ ekina꞉ yenkita꞉ niki pa꞉ta꞉ a꞉pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Diosepema꞉ta꞉ mo tapakema꞉ lemeke ekita꞉ opiekepate mo tapakema꞉ta꞉ kotoeki hone na wimikime. Pa ekipeke ikana꞉ma꞉ta꞉ mo pi la꞉ka꞉laeya꞉ some pa꞉ta꞉ laa ipikana꞉ma꞉ la꞉ mea hala꞉tiki pia꞉ ekima꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Diosepema꞉ta꞉ mo tapake mina꞉pa꞉lao pua e̱ leekeme. Kutupa ipikita꞉ pi ana꞉na꞉ lapeke yeketa꞉ paa la꞉ka꞉la a꞉pa mo ika꞉ leke popelekena꞉ Simiono ma̱leke lia mina mea tonkaena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Diosepema꞉ta꞉ mo e pokaemeke haliweki pa꞉ta꞉ta꞉ mo ipika꞉ hameke tonuna꞉ nu manuta꞉ mo widi napeke manuma꞉ tumbao mo homeke homekena꞉ widi hambemeke manita꞉ mo nu kakena꞉ paa mendiama꞉ mendiama꞉ peaata꞉ mo ika꞉ pota꞉na꞉ nolo pimiki ne make hala꞉pa꞉peke leeke handa ota꞉ kutu pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kutupa mo hama̱la̱꞉ hama̱la̱꞉ma꞉ta꞉ mo widi nu manuta꞉ ika꞉ donki manuna꞉ hokina꞉ atula atula pea mea wia pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mo pota꞉na꞉ timba꞉ leeke pua pelimiki alena꞉ mo hameke ma꞉nda꞉ma꞉ ipika꞉ donkina꞉ ne halueke alo hata꞉ mo ipika꞉ nu ma꞉nda꞉ tokiekepate mo nu kakena꞉ta꞉ ipika꞉ mani paa mendipelia hayekeeki handolo hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","A꞉pa꞉e. Yaka manita꞉ I̱ pa꞉ta꞉ paa la꞉ka꞉la a꞉pa pia꞉ka꞉ta꞉me laa penkilipa꞉tia pominolo hata꞉ ipika꞉ hameketonu pa꞉ta꞉ wi alo alota꞉ Do handa꞉pe. Yaka nu pa꞉ta꞉ menda꞉la꞉me leekeme. Kutupa mo hama̱la̱꞉ hama̱la̱꞉na꞉ puki keapa olina꞉ onina꞉ pitolo pututuma꞉ homolo hata꞉ ika꞉ ika꞉ kone lota꞉ pu alualu pitolo alota꞉ Koda꞉ma꞉ niki pa꞉ta꞉ eki hau pea pa꞉la꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Iki mo Keinani nane paa opolo a꞉paata꞉ ika꞉ apa꞉ Dieikope pa꞉ta꞉ mo hande iki pa꞉ta꞉ piekeeki paeyaosiki a꞉pa la halolo hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Mo Idiepina꞉ kapomanina꞉ you somema꞉ta꞉ niki pa꞉ta꞉ pi taka꞉lake alo hata꞉ nikita꞉ ipika꞉ kenke handuluekema꞉ kika ikiki haliweki poma꞉me lea꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Koto leeke nikana꞉ma꞉ hombo peaaso alota꞉ Nikita꞉ kika ikiki haliweki dia꞉me. Nikita꞉ ota꞉ hau pitoloma꞉ tapakee laa ");
INSERT INTO ssx_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nikita꞉ hali homekena꞉ wekitonu paeyao kiki yaapona꞉ ankena꞉ yaapo ya꞉mee. Weki homeketa꞉ homa꞉la꞉me. Kutupa wetepe nane wekita꞉ nika꞉ apa꞉ yaapo oni Keinani pa hala꞉me loma꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Kutupa mo you halima꞉ hombo peaaso alota꞉ Ikita꞉ ota꞉ pi lo haleme haliwekie laa handuluekema꞉ta꞉ dupulueke. Iki ma꞉nda꞉ hondota꞉ I̱ ame̱le̱ pa hapelia hata꞉ta꞉ mo iki paeyaota꞉ mo ika꞉ tea꞉ma꞉ homa꞉la꞉ tapakena꞉ widi napekemanu mea pupee laata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ika꞉ wetepe nane wekita꞉ I̱ pa꞉ta꞉ hatuku a꞉pa꞉pa꞉peke. Kutu pimika꞉na꞉ta꞉ kota꞉ ikita꞉ kika ikiki haliweki dia꞉ma꞉ ota꞉ pi aleme haliwekie hone ulueke. Kutupa do ika꞉ kame iki pa꞉ta꞉ paa kiaka꞉na꞉ ikita꞉ dopate hata꞉ ala꞉ta꞉ ala꞉ta꞉ pa tapamena꞉e laa lea꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Kutupa ikana꞉ma꞉ ika꞉ numanu tokimi dina꞉ta꞉ homeke homekema꞉ ika꞉ mani nu handa꞉ wimikime. Kutupa mo mani hando haota꞉ ikana꞉ma꞉ make ika꞉ apa꞉ Dieikopema꞉ make paala꞉ma꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ika꞉ apa꞉ma꞉ mo wekitonu pa꞉ta꞉ alota꞉ Ika꞉ honema꞉ta꞉ yaka wekiwandiki paeyao alu pano pitelemepe. Diosepe pa꞉la꞉me. Simiono make pa꞉la꞉me. Ameta꞉ Benisamini mea polukuma꞉ alemepe. I̱ta꞉ mo teto minolo somee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Koto leeke Lubenima꞉ ipika꞉ ateke pa꞉ta꞉ alota꞉ I̱ma꞉ Benisamini a꞉nda꞉ paa na hatuku epoa꞉ka꞉na꞉ta꞉ kota꞉ nakana꞉ma꞉ yaka weki yaapo luelena꞉e. Mo wekita꞉ yaka kiki pa꞉ta꞉ wie. Kutupa I̱ma꞉ paa hatuku ipulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Pate Dieikopema꞉ alota꞉ Yaka wekita꞉ neke yaapo na pena꞉ lolueke. Ipika꞉ hameketa꞉ homolo hata꞉ ipiki homeke hapelia hala꞉me. Mo pota꞉na꞉ hau ma꞉nda꞉ peaapa꞉na꞉ loa꞉me. I̱ta꞉ koke hali yaalo hata꞉ mo ikana꞉ma꞉ mea ipilimi puki tandama꞉ta꞉ I̱ lu homaliekee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Oni Keinani naneta꞉ mo tea꞉ kita꞉ ota꞉ hoeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kutupa mo Dieikopena꞉ tapakema꞉ mo hande Idiepi nane hambolo pua mea epemeke widita꞉ na꞉ta꞉ paota꞉ Dieikopema꞉ eiyeketonu pa꞉ta꞉ alota꞉ Paa pua nika꞉ ne tepo a꞉nda꞉ ma꞉nda꞉ pua hamba꞉pee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Diudama꞉ ateke pa꞉ta꞉ alota꞉ Mo hande you halima꞉ niki pa꞉ta꞉ pi taka꞉lakema꞉ alota꞉ Ikana꞉ma꞉ ika꞉ kame na hatuku epemeka꞉na꞉ta꞉ kota꞉ ika꞉ leke popeleke na handulueke laa lea꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Koto ekina꞉ nakana꞉ma꞉ nika꞉ kame niki ame̱le̱ tapaalueke hone wika꞉na꞉ta꞉ kota꞉ naka꞉ ne hambalo polumeke. ");
INSERT INTO ssx_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pate nakana꞉ma꞉ na tapaalueke lekena꞉ta꞉ kota꞉ mo halima꞉ta꞉ mo nika꞉ kame niki ame̱le̱ ipika꞉ leke popelekena꞉ poma꞉ka꞉na꞉ homeketa꞉ ana꞉ pa꞉la꞉me lea꞉ ekina꞉ta꞉ na polumeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Dieikopema꞉ alota꞉ I̱ pa꞉ta꞉ do ka꞉nda꞉ tieke epena꞉yeke ikana꞉ma꞉ta꞉ ekipeke ika꞉ kame ma꞉nda꞉ hala꞉me laa la halaa pelemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ikana꞉ma꞉ hombo peaaso alota꞉ Mo halima꞉ta꞉ niki make nika꞉ tapake make lota꞉ lota꞉ ombu pia꞉me. Ika꞉ apa꞉ta꞉ pa hala꞉pe o Ika꞉ kame ma꞉nda꞉ hala꞉pe laa lota꞉ ombu pia꞉me. Koto ekina꞉ nikana꞉ma꞉ta꞉ ipika꞉ pi hombo peapeke yeke loma꞉me. Ipikana꞉ma꞉ nika꞉ kame hatuku a꞉pa꞉pa꞉peke laa lolo pia꞉ ekita꞉ pa ekipa hone wiomono alepe. ");
INSERT INTO ssx_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Diudama꞉ ipika꞉ ateke pa꞉ta꞉ alota꞉ Niki koto kone polumekema꞉ mo weki I̱ yaapo tapae. Kutu puma꞉ka꞉na꞉ta꞉ kota꞉ niki ma꞉nda꞉ tea꞉ma꞉ ota꞉ na homulumeke. ");
INSERT INTO ssx_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mo weki pa꞉ta꞉ hau ma꞉nda꞉ pia꞉ka꞉na꞉ maketa꞉ kota꞉ I̱ pa꞉ta꞉ wina꞉e. I̱ma꞉ mo weki hau ma꞉nda꞉ peao epeke tupa꞉ neke pa꞉ta꞉ na hatuku epoa꞉ka꞉na꞉ta꞉ kota꞉ koto pu hoeyalua꞉ hauna꞉ yenkita꞉ I̱ pa꞉ta꞉ wina꞉ loelena꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nikana꞉ma꞉ nateleke hokuluna꞉ na yuwia haoma꞉ka꞉na꞉ yoluta꞉ ameta꞉ amba꞉ hoto yaapo pua epolo puma꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ika꞉ apa꞉ma꞉ iki pa꞉ta꞉ alota꞉ Kota꞉ kutu pulu pia꞉ka꞉na꞉ta꞉ kota꞉ do kenkena꞉ opa꞉la꞉ epeke nemanu ika꞉ nu pa꞉ta꞉manu mendiao mo kapomani handeteke hala꞉ you halina꞉ pa hameke hala꞉la꞉ ale mea puapee. Mo ale manuta꞉ pa totopo piki ti yonkeleke sikima꞉ make hosiki boi hapeke make mo ne totopo peaasa꞉ alemanu make mo (pei kilikima꞉ handeke) pisidasio kiliki make (mo sa꞉tikima꞉ handeke) amono kiliki make mea puapee. ");
INSERT INTO ssx_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kutupa make mo hande ika꞉ nu kake nina꞉ mendiaeyeke manita꞉ ata꞉ka꞉ peaopate pimima꞉ pao mea puaaso hata꞉ta꞉ moeki haka꞉ta꞉pao yaapo peao mea pua꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kutupa ika꞉ kame make hatuku puaata꞉ a̱i̱ koto kone paa la꞉ka꞉la a꞉pa꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mo you halima꞉ta꞉ Benisamini make mo ika꞉ kame ma꞉nda꞉ make iki pa꞉ta꞉ a꞉ta꞉ma꞉ homolo kina꞉ yeketa꞉ mo Aneke Wele wopupiki Koda꞉ma꞉ mo some pa꞉ta꞉ a꞉ta꞉ma꞉ homa꞉la꞉eki halena꞉e. Kota꞉ I̱ta꞉ yaka wekiwandiki alupawa꞉ka꞉na꞉ta꞉ kota꞉ ota꞉ alupaapeke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Koto ekina꞉ mo hama̱la̱꞉ hama̱la̱꞉ma꞉ta꞉ mo hande pa hameke hala꞉la꞉ alemanu make mo mani haka꞉ta꞉pao yaapo peao mea Benisamini ame̱le̱ Idiepi nane pemekeme. Koto pate ikita꞉ Diosepe pa꞉ta꞉ pua walemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kutupa Diosepema꞉ mo tapake ame̱le̱ Benisamini hayekeeki hando haota꞉ kota꞉ ipikana꞉ma꞉ mo ipika꞉ da handeteke hawayeke e pokaeyeke some pa꞉ta꞉ alota꞉ Do haliweki yaka da pa꞉ta꞉ hatuku pue. Ikita꞉ natepa nane I̱ ame̱le̱ ne nelimikima꞉ mo koa ma꞉na꞉ ma꞉nda꞉ lia amu peapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mo e pokaeyeke halima꞉ta꞉ mo pia꞉peke leeke tupa꞉ mo hama̱la̱꞉ hama̱la̱꞉ hatuku Diosepena꞉ da pa꞉ta꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Mo hama̱la̱꞉ hama̱la̱꞉ mo da pa꞉ta꞉ hatuku epeeketa꞉ ikita꞉ paala꞉ma꞉ homolo hata꞉ dupiki hone wimikime. Niki do pa꞉ta꞉ hatuku ipula꞉ ekita꞉ mo hande titina꞉ hande nika꞉ nu pa꞉ta꞉manu mendieke manina꞉ pate pita꞉la꞉me. Ameta꞉ ikana꞉ma꞉ niki hoeyao make nika꞉ donkimanu make mea nikita꞉ ipika꞉ pa hameke e pokaasoma꞉ tapake hamono lelimikie laa hone wimikime. ");
INSERT INTO ssx_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Koto ekina꞉ mo da pota꞉ pa꞉ta꞉ pua hata꞉ mo e pokao haya꞉ handeteke hayeke some pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Tiekeo. Pilisi nakana꞉ma꞉ opie. Nikita꞉ amba꞉ hoto homeke do pa꞉ta꞉ ne hambolo epoma꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Kutupa paa pua timba꞉ leeke palai da pua a꞉eyaata꞉ nika꞉ numanu pua tokua handoma꞉pate hali homeke homekema꞉ nika꞉ mani ota꞉ ana꞉ sikina꞉ mendieke handaa pao mea epoloma꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kutupa make ne ma꞉nda꞉ hambulumekema꞉ yeke mandane mani make mea epoloma꞉me. Mo nika꞉ nu pa꞉ta꞉manu mo mani paa mendiaeyeke someta꞉ epima꞉ pa꞉la꞉ o niki mata꞉la꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mo e pokaeyeke somema꞉ alota꞉ Hone ti yokolo hata꞉ paala꞉ma꞉ na homa꞉pa꞉peke. Ika꞉ Koda꞉ mo ika꞉ apa꞉na꞉ Koda꞉ma꞉ kone ika꞉ numanu pa꞉ta꞉ mo mani paa mendiao pa꞉la꞉mee. Ika꞉ yenki manuta꞉ ana꞉na꞉ mua꞉me leekeme. Kutupa ipikana꞉ma꞉ Simiono iki pa꞉ta꞉ hatuku epeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mo e pokaeyeke somema꞉ta꞉ mo hama̱la̱꞉ hama̱la̱꞉ da tukiki pa꞉ta꞉ hatuku mea epeekeme. Ipikana꞉ma꞉ta꞉ mo ika꞉ ankemanu tandepolo pimiki tupa꞉ ikali halaata꞉ ika꞉ donkimanu make ne haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Mo tapakema꞉ta꞉ natepa nane Diosepe ame̱le̱ mandakena꞉ ne nelimikie laa la haleeke handa mo hande pa hameke hala꞉la꞉ alemanu tikitiki yao pitimikime. ");
INSERT INTO ssx_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kutupa Diosepe da pa꞉ta꞉ opolo epeeketa꞉ ikana꞉ma꞉ mo pa hameke hala꞉la꞉ alemanu oni da pa꞉ta꞉ mea pua ipiki pa꞉ta꞉ pua panda꞉ puniaemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ipikana꞉ma꞉ ikita꞉ epeke tupa꞉ halemepe laa alota꞉ Ikana꞉ma꞉ta꞉ mo ika꞉ apa꞉ kokena꞉ pi manuta꞉ I̱ la kimima꞉ ipikita꞉ eki pa꞉la꞉pe. Ipikita꞉ pa hala꞉pe o epeke hala꞉pe laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ikana꞉ma꞉ hombo peaaso alota꞉ Naka꞉ epeke homupiki e pokaasa꞉ hali mo nika꞉ apa꞉ta꞉ pa epeke tupa꞉ hala꞉mee lemekeme. Koto laata꞉ tumiki yotuao ipiki pa꞉ta꞉ panda꞉ puniaemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kutupa Diosepema꞉ ipika꞉ hameke Benisamini hando hao alota꞉ Dota꞉ hande I̱ pa꞉ta꞉ la kimi ika꞉ wetepe nane weki ya꞉ka꞉ta꞉me. Yaka wekio. Koda꞉ma꞉ neke epeaena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Koto laata꞉ Diosepe ipika꞉ kamena꞉ ipika꞉ pukima꞉ tanda tieke pieke handaa koto kone iki mina꞉pa꞉lao peekeme. Ipikita꞉ teke pa꞉ta꞉ e̱ podela꞉ mia꞉peke nono pieke handa ipika꞉ da panda꞉ pa꞉ta꞉ pua e̱ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kutupa ipika꞉ leke popeleke tanda꞉pata꞉ hama opolu bao a꞉pa ipika꞉ kone lu mina꞉niao pita꞉ta꞉ mo ne pana꞉ pie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Diosepeta꞉ teipolo ma꞉nda꞉na꞉ pana꞉ peao ipika꞉ hameke tonuta꞉ ma꞉nda꞉na꞉ pana꞉ peayekeme. Kutupa koto pa꞉ta꞉ ne nemeke Idiepi tapake manuma꞉ta꞉ mo Hibulu tapake ame̱le̱ mandake pa꞉ta꞉ pita ne napeke ana꞉ na pa꞉la꞉me laata꞉ teipolo ma꞉nda꞉na꞉ pita꞉ ne nemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Mo hama̱la̱꞉ hama̱la̱꞉ta꞉ Diosepe handa꞉ moneao pita꞉ ika꞉ mendieke tupa꞉ mupeke hali amba꞉la pita pua mo wetepe wekina꞉ pua pitu naena꞉ leekeme. Mo tapakema꞉ iki pitaeyeke tupa꞉ hando haota꞉ penkilipa꞉tia pominolo hata꞉ta꞉ ika꞉ ika꞉ kone handa꞉ alu alu pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Mo neta꞉ Diosepena꞉ teipolona꞉ pana꞉ piekeme. Kutupa Benisaminita꞉ mo hameke tonuna꞉eki make ankulao haka꞉ta꞉pao mo ipika꞉ ne yunki peao mulu pieke tupa꞉ haleekeme. Koto ekina꞉ mo tapaketa꞉ Diosepe ame̱le̱ ne ikali no opu hao keaemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Diosepema꞉ mo ipika꞉ da handeteke hayeke e pokaeyeke some pa꞉ta꞉ alota꞉ Mo haliwekina꞉ numanu pa꞉ta꞉ta꞉ mo ne ika꞉ mondulu peleme tupa꞉ kone mendiaota꞉ pa mo homeke homekena꞉ manita꞉ ika꞉ nu kakena꞉ mendia mendia pea꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kutupa mo yaka silipama꞉ wepieke kapota꞉ mo wetepe wekina꞉ nu pa꞉ta꞉ ipika꞉ widi hambea꞉ mani pita꞉ mandakena꞉ mendiapeke leekeme. Koto leeke mo halima꞉ta꞉ Diosepema꞉ leeke tupa꞉ siki kone piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Da ka꞉la꞉paaso sikita꞉ mo hama̱la̱꞉ hama̱la̱꞉ta꞉ ika꞉ donkimanu pita꞉ pena꞉ tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Mo tapaketa꞉ mo daoni mina꞉pa꞉lao pa hosiki siki papate leke pulu haena꞉ta꞉ Diosepema꞉ ipika꞉ da handeteke haya꞉ some pa꞉ta꞉ alota꞉ Mo haliweki telia꞉ mea a̱i̱ pue. Kuta teliminikina꞉ta꞉ dupa lota꞉ pia꞉peke. Ikana꞉ma꞉ta꞉ mo epeke hauna꞉ pa hoke ekima꞉ yenki kia pelemepe. ");
INSERT INTO ssx_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Pa ekipeke yaka you somena꞉ silipa kapo pake naa pelemepe. Koto ekita꞉ ota꞉ ipika꞉ ikali no hala꞉eki homeke make ipika꞉ handehau pulukuma꞉ mea꞉tiki pu hala꞉ kapoe. Ikana꞉ma꞉ta꞉ ota꞉ hoke hau pelememe laa lapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mo e pokaeyeke somema꞉ mo tapake pua teliminata꞉ homeke pi kone pua leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Mo tapakema꞉ hombo peaaso alota꞉ Tiekeo. Dupiki pi ale ekita꞉ eki la alepe. Nikana꞉ma꞉ta꞉ kutupiki hau na poloma꞉me laa keke aloma꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nikana꞉ma꞉ta꞉ mo Keinani kenke pa꞉ta꞉ hao ipulu hata꞉ta꞉ mo hande nika꞉ nu kakena꞉ mendia꞉ mani manuta꞉ paa mea epoma꞉ ekita꞉ naka꞉ hone wilime. Koto ekina꞉ nikana꞉ma꞉ta꞉ naka꞉ you halina꞉ da pa꞉ta꞉ mo silipa o kolota꞉ pa ekipeke pake noluma꞉pe. ");
INSERT INTO ssx_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tiekeo. Niki ma꞉nda꞉ epima꞉ mo ale muluma꞉eki a꞉nda꞉ handa꞉ wika꞉na꞉ta꞉ kota꞉ koto someta꞉ lu homaena꞉ laata꞉ niki paeyaota꞉ naka꞉ pa hameke e pokaasoma꞉ tapake halumeke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mo halima꞉ alota꞉ A꞉pa꞉la꞉pate pa mo kapo ma꞉la꞉ some homeketa꞉ yaka pa hameke e pokaasa꞉ hali haena꞉ iki paeyaota꞉ pao pomena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Koto ekina꞉ paeyaoma꞉ koto kone ika꞉ numanu oni kenkena꞉ mea wia homeke homekema꞉ ipika꞉ nu toku wia pitimikime. ");
INSERT INTO ssx_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kutupa Diosepena꞉ e pokaeyeke somema꞉ta꞉ sembepelasiki mo mupeke halina꞉ ekina꞉ kini pea weiya꞉tia pua mo wetepe halina꞉ ekina꞉ pua paeyaeyekepate mo kapota꞉ Benisaminina꞉ nu pa꞉ta꞉ mendieke handa꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Koto ekina꞉ mo hama̱la̱꞉ hama̱la̱꞉ma꞉ta꞉ ota꞉ a꞉ta꞉ma꞉ homolo hata꞉ ika꞉ aka꞉manu sinkipa ika꞉ numanu mo donki hokina꞉ paa mu wia mo daoni nane paa la꞉ka꞉la pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Mo Diuda hama̱la̱꞉ hama̱la̱꞉ mo Diosepena꞉ da pa꞉ta꞉ epemeketa꞉ ipikita꞉ pa pitiekeme. Kutupa ikita꞉ ipiki pa꞉ta꞉ panda꞉ puniaemeke handaa ");
INSERT INTO ssx_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Diosepema꞉ alota꞉ Ikana꞉ma꞉ta꞉ ekipiki hau pea pelemepe. Ikana꞉ma꞉ta꞉ dupiki e pokolo hali I̱ma꞉ta꞉ ika꞉ peleme hauta꞉ mo handehau pea na handa꞉ ulueke hone wimipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Koto leeke Diudama꞉ hombo peaaso alota꞉ Tiekeo. Nikana꞉ma꞉ neke pa꞉ta꞉ta꞉ eki lomonope. Ekipa pi yokaalu piomonope. Ekipa nikana꞉ma꞉ dia꞉me lomonope. Koda꞉ma꞉ta꞉ nika꞉ poloma꞉ hoke hau peneme yala꞉me. Mo hande kapo mia꞉ some homeke dia꞉ya꞉la꞉pate ameta꞉ niki paeyaota꞉ naka꞉ pa hameke e pokaasoma꞉ haliweki haloma꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Diosepema꞉ alota꞉ O dia꞉me. I̱ma꞉ta꞉ kutupiki hau ota꞉ na pulueke. Mo yaka kapo ma꞉la꞉ some homeketa꞉ yaka pa hameke e pokaasa꞉ some halieke. Iki paeyaota꞉ epeke tupa꞉ siki hau ma꞉nda꞉ na piki ika꞉ apa꞉ pa꞉ta꞉ paa la꞉ka꞉la pelimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Diudama꞉ Diosepe pa꞉ta꞉ pua alota꞉ Pilisi Tiekeo. Neketa꞉ pa mo kinima꞉ handele ekina꞉ I̱ma꞉ neke pa꞉ta꞉ pi la kiono mineke na panka꞉pekee. ");
INSERT INTO ssx_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tiekeo. Nakana꞉ma꞉ niki pa꞉ta꞉ lota꞉ pitolo hata꞉ alota꞉ Ika꞉ apa꞉ta꞉ hala꞉pe o ika꞉ kame ma꞉nda꞉ hala꞉pe laa lemee. ");
INSERT INTO ssx_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Koto leke nikana꞉ma꞉ hombo peaasota꞉ nika꞉ apa꞉ta꞉ koke halisiki hala꞉ make nika꞉ wetepe wekita꞉ mo koke nane ma꞉nda꞉la꞉ weki make hala꞉me. Mo wekina꞉ hameketa꞉ homa inkikina꞉ wekiwandikita꞉ ipiki homeke pa hala꞉me. Kutupa ipika꞉ apa꞉ma꞉ mo wekita꞉ pukima꞉ wopu homa꞉la꞉me loma꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tiekeo. Nakana꞉ma꞉ta꞉ handuluekema꞉ hatuku a꞉pa꞉pekee leke handa ");
INSERT INTO ssx_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","nikana꞉ma꞉ hombo peaasota꞉ mo wekima꞉ta꞉ ipika꞉ apa꞉ na mina꞉pa꞉lalieke loma꞉me. Mina꞉pa꞉laeya꞉ka꞉na꞉ta꞉ kota꞉ ipika꞉ ateketa꞉ homilieke laa loma꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Koto lomeke nakana꞉ma꞉ alota꞉ Ika꞉ wetepe weki iki ame̱le̱ epea꞉ka꞉na꞉ homeke naka꞉ leke popelekena꞉ niki handulumeke lemee. ");
INSERT INTO ssx_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kutupa niki nika꞉ apa꞉ pa꞉ta꞉ puata꞉ mo naka꞉ le pimanu paeyao pua la haloma꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Koto hoki naneta꞉ ipikana꞉ma꞉ niki pa꞉ta꞉ Paa la꞉ka꞉la pua ne hosikima꞉ pua hamba꞉pee lea꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Koto leeke nikana꞉ma꞉ hombo peaaso alota꞉ Nikita꞉ pua꞉peke na ya꞉la꞉me. Mo nika꞉ kame wetepe nane wekita꞉ nika꞉ ame̱le̱ poma꞉ka꞉na꞉ homeke mo halina꞉ leke popelekena꞉ pua hapeke ya꞉la꞉me. Mo nika꞉ kame Benisamini niki ame̱le̱ pea꞉ka꞉na꞉ homeke pua꞉peke ya꞉la꞉me loma꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Koto lomeke nika꞉ apa꞉ma꞉ niki pa꞉ta꞉ alota꞉ Mo yaka wanda꞉ Leisoloma꞉ta꞉ yaka weki yaapo homeke mendiaeya꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Homeketa꞉ I̱ amba꞉ mina꞉pa꞉lala꞉me. Ipikita꞉ hoki pea꞉ nane make ota꞉ na handolo ekima꞉ta꞉ mo tikene ma꞉na꞉yeti sayale manuma꞉ sinki sinki pea witolo pa꞉la꞉mee. ");
INSERT INTO ssx_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ikana꞉ma꞉ ame do weki hatuku pua hau ma꞉nda꞉ peaemeka꞉na꞉ta꞉ kota꞉ I̱ta꞉ koke yalo hata꞉ ikana꞉ma꞉ mea ipilimi a꞉ta꞉ma꞉ta꞉ I̱ lu homaalieke laa lea꞉me laa la haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Diudama꞉ ombu pa alo hata꞉ alota꞉ Tiekeo. Pa ameta꞉ I̱ a꞉nda꞉ mo weki yaapo yaka apa꞉ pa꞉ta꞉ na poa꞉ka꞉na꞉ta꞉ kota꞉ mo weki I̱ yaapo na handolo kone ipiki homilieke. Ipika꞉ hone puki paeyaota꞉ koto weki pa꞉ta꞉ ula꞉me. Kutupa ipikita꞉ ota꞉ koke ya꞉la꞉ ekima꞉ta꞉ mo nikana꞉ma꞉ puluma꞉ hauma꞉ kone ipiki lu homaalumeke. ");
INSERT INTO ssx_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Hau ma꞉nda꞉ make dupae. I̱ma꞉ alota꞉ Mo weki pa꞉ta꞉ hau ma꞉nda꞉ pia꞉ka꞉na꞉ maketa꞉ kota꞉ I̱ pa꞉ta꞉ wina꞉e laa yaka apa꞉ pa꞉ta꞉ta꞉ I̱ma꞉ mo weki a꞉nda꞉ pa na hatuku epoa꞉ka꞉na꞉ta꞉ kota꞉ koto pu hoeyalua꞉ hauna꞉ yenkita꞉ I̱ pa꞉ta꞉ wina꞉ loelena꞉e loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Koto ekina꞉ tiekeo. Ameta꞉ mo wekina꞉ anketeke minolo hata꞉ I̱ta꞉ naka꞉ pa hameke e pokaaso hali haluekema꞉ ipikita꞉ ipika꞉ hameke tonu ame̱le̱ paa pena꞉ lae. ");
INSERT INTO ssx_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","I̱ma꞉ta꞉ eki ekipa mo wekita꞉ I̱ yaapo na peke haena꞉ yaka apa꞉ pa꞉ta꞉ polua꞉pe. I̱ma꞉ta꞉ yaka apa꞉ pa꞉ta꞉ dupiki ke tieke ipula꞉eki handa꞉peketa꞉ I̱ ana꞉ na pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Diosepema꞉ta꞉ ipika꞉ wieke hone manuna꞉ta꞉ mo ipika꞉ e pokaemeke tapakena꞉ leke popelekena꞉ lu mina꞉niapeke na yalo hata꞉ paeyaosiki mo da panda꞉ mina꞉pa꞉lao pupe laa leekeme. Kota꞉ Diosepema꞉ta꞉ ipiki ame̱le̱ ma꞉nda꞉ siki ota꞉ na haena꞉ mo hameke tonu pa꞉ta꞉ta꞉ I̱ lataa laa la haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ipikana꞉ma꞉ta꞉ e̱ alo hata꞉ anekema꞉ ka꞉pa꞉puki yokeke handa mo Idiepi tapakema꞉ make opuaata꞉ kota꞉ mo ekina꞉ pita꞉ mo kinina꞉ da pa꞉ta꞉ make mea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Diosepema꞉ ipika꞉ hameketonu pa꞉ta꞉ alota꞉ I̱ta꞉ Diosepee. Yaka apa꞉ta꞉ pa hala꞉pe leekeme. Koto leekepate mo hama̱la̱꞉ hama̱la̱꞉ma꞉ta꞉ doeki opu hao paala꞉ma꞉ hone mamatalo hata꞉ hombo peapeke na yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kota꞉ Diosepema꞉ iki pa꞉ta꞉ alota꞉ Pilisi I̱ teke pa꞉ta꞉ ipupe leekeme. Kota꞉ mo tapake teke pa꞉ta꞉ epemeke handa alota꞉ I̱ta꞉ ikana꞉ma꞉ mo hande Idiepi nane mani mea tapaeme some ika꞉ kame Diosepee. ");
INSERT INTO ssx_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Koto ekina꞉ mo ikana꞉ma꞉ do pa꞉ta꞉ I̱ tapaaleme ekina꞉ ka꞉nda꞉ma꞉ na homa make nikana꞉ma꞉ pu hoeyaloma꞉me pi na lapa꞉peke. Ota꞉ Koda꞉ma꞉ kone mo wanda꞉hali homaapa꞉na꞉yeke. I̱ma꞉ pa꞉ta꞉lono I̱ amba꞉la tapao pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Do kenke pa꞉ta꞉ mo tea꞉ ki a꞉pa꞉la꞉ ekita꞉ bapi yaapo homeke do handa꞉e. Mo yu lita꞉la꞉eki kone o ne napeke mina꞉la꞉eki kone ota꞉ na pulu pa꞉la꞉ bapi yunki hata꞉ta꞉ pa ula꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Koda꞉ma꞉ I̱ amba꞉la tapaala꞉ ekita꞉ dupiki ta꞉ta꞉ ma꞉nda꞉ piki hauma꞉ iki pa꞉ta꞉lono laa kutupa mo ika꞉ monduma꞉ monduma꞉ pilimi wekiwandikina꞉ wekiwandiki ana꞉na꞉ hao pelina꞉yeke pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Koto ekina꞉ta꞉ ikana꞉ma꞉ I̱ do Idiepi kenke nane na tapaemepate pa Koda꞉ma꞉ kone pa꞉la꞉me. Ipikana꞉ma꞉ I̱ta꞉ mo kinina꞉ kapomani manda you hali pitono la꞉la꞉me. I̱ta꞉ do kenke paeyao handeteke halome. I̱ta꞉ do Idiepi wanda꞉halina꞉ you hali halome. ");
INSERT INTO ssx_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Koto ekina꞉ yaka apa꞉ pa꞉ta꞉ a̱i̱ la꞉ka꞉la puata꞉ dota꞉ naka꞉ weki Diosepema꞉ ala꞉ pie laa pua lapa꞉peke. Koda꞉ma꞉ta꞉ I̱ta꞉ Idiepina꞉ handeteke hala꞉ hali hano la꞉la꞉me. Nate leke hokulu na peake I̱ pa꞉ta꞉ a̱i̱ epoe. ");
INSERT INTO ssx_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Neke make naka꞉ wekiwandiki make naka꞉ wekiwandikina꞉ wekiwandiki make naka꞉ sipisipimanu make naka꞉ nanikosimanu make naka꞉ kaomanu make mo naka꞉ wia hale alemanu paeyao make I̱ teke pa꞉ta꞉ wia halo pele tupa꞉ mo Kosene kenke pa꞉ta꞉ halena꞉e laata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Neke mo Kosene kenke pa꞉ta꞉ haeka꞉na꞉ta꞉ kota꞉ I̱ma꞉ neke handeteke halo polo tupa꞉ loa꞉me. Mo tea꞉ kita꞉ bapi yunki hata꞉ pa ula꞉ ekina꞉ta꞉ neke make naka꞉ tapake make naka꞉ ma꞉na꞉manu make tea꞉ma꞉ homilimikiyeke loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Diosepema꞉ ombu alota꞉ Ameta꞉ iki paeyaoma꞉ make Benisamini nakana꞉ma꞉ make I̱ta꞉ ota꞉ Diosepee laa handelememe. ");
INSERT INTO ssx_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kutaa I̱ do Idiepi kenke pa꞉ta꞉ ota꞉ honkopu tieke ula꞉eki make mo ikana꞉ma꞉ handeleme alemanu paeyao make yaka apa꞉ pa꞉ta꞉ pua lapa꞉peke. Kutupa a̱i̱ a̱i̱ pu kone ipiki do pate hatuku a꞉pa꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Koto laata꞉ ipikana꞉ma꞉ ipika꞉ hameke Benisaminita꞉ hopula꞉ mea e̱ leekeme. Benisaminima꞉ make e̱ alo hata꞉ hameke hopula꞉ miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","E̱ pa alo alo hata꞉ta꞉ hameke titi homeke homeke lo hopulolo hata꞉ nunu piekeme. Kota꞉ kutu pieke hoki naneta꞉ ipika꞉ hameke tonuma꞉ ipiki ame̱le̱ pi kini pea lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mo hande Diosepena꞉ hameke tonuta꞉ epelememe le ekita꞉ mo kinina꞉ da pa꞉ta꞉ haemeke tapakema꞉ opitolo hata꞉ mo kinima꞉ make mo ipika꞉ e pokaeyeke you haliwekima꞉ make ta꞉na꞉ma꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Mo kinima꞉ Diosepe pa꞉ta꞉ alota꞉ Naka꞉ kametonu ika꞉ nemanu mo donki manuna꞉ hokina꞉ atula atula pea wia mo Keinani nane la꞉ka꞉la pupa꞉e lae laata꞉ ");
INSERT INTO ssx_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ika꞉ apa꞉ make ika꞉ tapake make hatuku do ane la꞉ka꞉la a꞉pa꞉pa꞉peke lae. I̱ma꞉ta꞉ iki pa꞉ta꞉ mo kenke paeyao ankulake ota꞉ epeke kenke halaata꞉ ota꞉ haka꞉ta꞉pake tupa꞉ ne no hao pelina꞉ loa꞉me lae. ");
INSERT INTO ssx_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Kutupa make mo ika꞉ weteke tonu make ika꞉ hosiki wekiwandiki sunu make ika꞉ ateke make hatuku epolo peleme mo Idiepina꞉ ma꞉na꞉ma꞉ yola꞉la꞉ pota꞉ alemanu mea pena꞉ lae. ");
INSERT INTO ssx_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kuta ikana꞉ma꞉ta꞉ mo ika꞉ wia haleme alemanu mina꞉pa꞉laasoma꞉me laa hone ka꞉nda꞉ma꞉ na homa꞉pa꞉peke. Pa ekipeke do Idiepi kenke paeyao siki pa꞉ta꞉ ula꞉ epeke ale manuta꞉ ika꞉eki ya꞉lieke loa꞉me lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Koto leeke mo Dieikopena꞉ eiyeke tonuma꞉ta꞉ mo leeke tupa꞉ siki kone pimikime. Kutupa Diosepema꞉ta꞉ mo kinima꞉ leeke tupa꞉ kone mo ma꞉na꞉ma꞉ yola꞉la꞉ pota꞉ alemanu halaata꞉ pota꞉na꞉ nolo pimiki ne make haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kutupa Diosepema꞉ hameke tonu pa꞉ta꞉ mo topo aka꞉manu make haleekepate pa Benisaminita꞉ 300 silipa mani make topo aka꞉ paeyao yunki hata꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Kuta ipika꞉ atekena꞉ta꞉ mo Idiepina꞉ ota꞉ epeke nemanu mo kiki yaapo donkina꞉ mu wia kutupa pa kiki yaapo donkimanu ma꞉nda꞉na꞉ta꞉ mo pota꞉na꞉ nolo pieke widimanu make betedimanu make mandane nemanu make mu wiao tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kutupa mo ipika꞉ hameketonu pena꞉ tapaaso hata꞉ alota꞉ Mo pota꞉na꞉ hankiliki na yola꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kota꞉ mo tapaketa꞉ Idiepi mina꞉pa꞉lao ika꞉ da nane ateke hayeke alena꞉ Keinani nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ikana꞉ma꞉ ateke pa꞉ta꞉ pua alota꞉ Diosepeta꞉ pa hala꞉mee. Ipikita꞉ mo Idiepi kenke paeyaona꞉ handeteke hala꞉ hali hala꞉me lemekeme. Koto lemeke handa Dieikopeta꞉ hone mata꞉pa pulu no la꞉mea pita꞉ mo weki tonuma꞉ lemeke ekina꞉ hone na tulaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Pate mo eiyeke tonuma꞉ hande Diosepema꞉ iki pa꞉ta꞉ leekeeki paeyao ika꞉ apa꞉ pa꞉ta꞉ la halemekeme. Dieikopema꞉ koto lemekeeki opuolo pita꞉ pa mo Diosepema꞉ ipiki mulu epena꞉ tapaeyeke ma꞉na꞉ma꞉ yola꞉la꞉ pota꞉ alemanu hando haota꞉ kota꞉ ipikita꞉ paa epeke hone wia pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Kutu pitolo hata꞉ Dieikopema꞉ alota꞉ Keiyae. Doeki homeketa꞉ ota꞉ yaka hone pa꞉la꞉ ekina꞉ yaka weki Diosepeta꞉ paa haya꞉ka꞉ta꞉me. Kota꞉ I̱ a̱i̱ na homeke hata꞉ kone ipiki handolo polueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Dieikopema꞉ta꞉ ipika꞉ wia hayeke alemanu paeyao talo peaata꞉ Biasiba nane peekeme. Koto pateta꞉ ipika꞉ ateke Aisa꞉kena꞉ Koda꞉ pa꞉ta꞉ yeni hau piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Koto timbata꞉ upama꞉ leke ale Koda꞉ma꞉ ipiki pa꞉ta꞉ pi alo alota꞉ Dieikopeo Dieikopeo leeke ipikana꞉ma꞉ hombo peaaso alota꞉ Wao. I̱ do handa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Tekehalima꞉ alota꞉ I̱ta꞉ Koda꞉ naka꞉ apa꞉na꞉ Koda꞉e. Idiepi poluekema꞉ta꞉ paala꞉ma꞉ na homa꞉peke. I̱ma꞉ta꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ koto pate tapake tieke haena꞉ lolueke. ");
INSERT INTO ssx_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I̱ma꞉ta꞉ neke yaapo oni Idiepi nane mandakena꞉ puaata꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ do kenke nane paa hatuku ipulueke. Koto pateta꞉ mo Diosepe neke yaapo mandakena꞉ haena꞉ neke homilipikie laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kota꞉ Dieikopeta꞉ Biasiba mina꞉pa꞉laeyekeme. Ipika꞉ weki tonuma꞉ta꞉ mo hande Idiepi kinima꞉ tapaeyeke ma꞉na꞉ma꞉ yola꞉la꞉ pota꞉ ale manuna꞉ta꞉ ika꞉ ateke make ika꞉ hosiki wekiwandiki sunu make ika꞉ weteke tonu make pitaemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ika꞉ mo Keinani hata꞉ mimiki alemanu paeyao make ma꞉na꞉manu make mea Idiepi nane pemekeme. Dieikopema꞉ta꞉ ipika꞉ monduma꞉ monduma꞉ pieke wekiwandikina꞉ wekiwandiki paeyao hatuku peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ipika꞉ wekitonu make ipika꞉ weki tonuna꞉ wekitonu make ipika꞉ wandikitonu make ipika꞉ waneke tonuna꞉ wandikitonu make paeyao hatuku peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Mo Dieikope ame̱le̱ oni Idiepi nane pemeke ipika꞉ tapaketa꞉ mupeke weki Lubeni ");
INSERT INTO ssx_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","make Lubenina꞉ eiyeke tonu Ha꞉noko make Palu make Hesetoni make Kami makee. ");
INSERT INTO ssx_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Kutupa Simiono make ipika꞉ wekitonu Diemuelo make Diamini make Ohadi make Diakini make Soha make Siolo makee. Do weki Siolota꞉ mo Keinani wanda꞉na꞉ wekie. ");
INSERT INTO ssx_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lipai make ipika꞉ weki tonuta꞉ Kiesoni make Koha꞉di make Metati makee. ");
INSERT INTO ssx_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Diuda make ipika꞉ weki tonuta꞉ Sela make Petese make Sita makee. Diudana꞉ eiyeke yaapo Ea pita꞉ Onane yaapota꞉ Keinani haemeke toma꞉na꞉ kone amba꞉ homepekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka make ipika꞉ weki tonuta꞉ Tola make Pua make Yope make Simitoni makee. ");
INSERT INTO ssx_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebuloni make ipika꞉ weki tonuta꞉ Setede make Elono make Dialieli makee. ");
INSERT INTO ssx_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Do weki tonuta꞉ oni Mesopoteimia hata꞉ Liama꞉ Dieikopena꞉ mendiaeyeke weki tonue. Liama꞉ wandiki Daena make mendiaeyekeme. Koto paeyao siki yata꞉polota꞉ Lia pa꞉ta꞉ yama꞉ Dieikope ipika꞉ monduma꞉ monduma꞉ pieke wekiwandiki paeyaota꞉ 33 yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ka꞉de make ipika꞉ wekitonu Sepedoni make Haki make Siuni make Eseboni make Eti make Atodi make Ateli makee. ");
INSERT INTO ssx_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","A꞉sia make ipika꞉ weki tonuta꞉ Imina make Isipa make Isipi make Betia make ika꞉ ana꞉ Seta makee. Betiana꞉ eiyeke yaapota꞉ Heba pita꞉ Malakiele yaapoe. ");
INSERT INTO ssx_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Do 16 wekiwandikita꞉ mo hande Leibenima꞉ ipika꞉ waneke Lia pa꞉ta꞉ haleeke pa hameke e pokaasa꞉ wandiki Silipama꞉ Dieikopena꞉ mendiaeyeke wekiwandikie. ");
INSERT INTO ssx_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Dieikopena꞉ weteke Leisoloma꞉ta꞉ Dieikope ipika꞉ weki Diosepe pita꞉ Benisamini yaapo mendiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Oni Idiepi kenketa꞉ mo Heliopolisi da pa꞉ta꞉ yeni peao hayeke hali Podipitana꞉ waneke A꞉sena꞉dema꞉ta꞉ Diosepena꞉ weki Ma꞉na꞉sa꞉ pita꞉ Ipoteimi yaapo mondu wiayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benisaminina꞉ eiyeke tonuta꞉ Bela make Bekea make A꞉sa꞉bele make Keta make Naamani make Ehi make Otosi make Mupimi make Hupimi make Ada makee. ");
INSERT INTO ssx_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Koto 14 weki tonuta꞉ mo Leisoloma꞉ pa꞉ta꞉ yama꞉ Dieikopena꞉ mendiaeyeke wekiwandikie. ");
INSERT INTO ssx_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Da꞉ni make ipika꞉ weki Husimi makee. ");
INSERT INTO ssx_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Na꞉petali make ipika꞉ wekitonu Diasiele make Kuni make Diesa make Silemo makee. ");
INSERT INTO ssx_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Do watake hata꞉ tapaketa꞉ mo hande Leibenima꞉ waneke Leisolo haleeke pa hameke e pokaasa꞉ wandiki Bilihama꞉ pa꞉ta꞉ yama꞉ Dieikopena꞉ monduma꞉ monduma꞉ pieke wekiwandikie. ");
INSERT INTO ssx_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Kota꞉ mo Dieikopena꞉ eiyeke tonuna꞉ weteke tonu na yata꞉peke pa mo ota꞉ Dieikopena꞉ monduma꞉ monduma꞉ pieke wekitonu homeketa꞉ paeyao 66 oni Idiepi nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kutupa Diosepena꞉ oni Idiepi mendiaeyeke weki yaapo apa꞉taasota꞉ mo Dieikopena꞉ oni Idiepi nane pu haemeke tapake paeyaota꞉ 70 yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Dieikopema꞉ta꞉ Diosepema꞉ mo Kosene kenke pa꞉ta꞉ iki a꞉pa manda꞉hande pina꞉ honke lena꞉yeke Diuda amba꞉la tapaeyekeme. Kutupa mo tapake opolo pemeketa꞉ ");
INSERT INTO ssx_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Diosepema꞉ ipika꞉ hosima꞉ yola꞉la꞉ pota꞉ ale pitulu pua Kosene kenke pa꞉ta꞉ ateke manda꞉hande pulu peekeme. Kutupa mo pate pua ateke manda꞉hande pitolo hata꞉ta꞉ Diosepema꞉ ipika꞉ kiki bao mo atekena꞉ make yola꞉ mea hopulolo hata꞉ e̱ tieke lo hokulu peayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Dieikopema꞉ Diosepe pa꞉ta꞉ alota꞉ I̱ma꞉ neke paa haeka꞉ta꞉ma꞉ laa handolo hata꞉ta꞉ kota꞉ ameta꞉ I̱ta꞉ homuluekema꞉ tikitiki yao halome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kutupa Diosepema꞉ ipika꞉ hameke tonu pa꞉ta꞉ make mo atekena꞉ tapake paeyao pa꞉ta꞉ make alota꞉ I̱ma꞉ta꞉ mo kini pa꞉ta꞉ta꞉ oli Keinani haeme yaka kametonu make yaka apa꞉na꞉ tapake paeyao I̱ pa꞉ta꞉ epelememe laa amba꞉la lolo polueke. ");
INSERT INTO ssx_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Kutupa I̱ma꞉ ipiki pa꞉ta꞉ dupa lolueke. Ikita꞉ sipisipimanu handeteke hao haleme haliweki make ma꞉na꞉manu punu haleme haliweki make yalo hata꞉ ika꞉ ma꞉na꞉manu make e wae alemanu make ika꞉ wia haleme alemanu paeyao make mea epelememe laa pua lolueke. ");
INSERT INTO ssx_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Koto ekina꞉ mo kinima꞉ iki wi la꞉ mea ika꞉ pu haleme ekita꞉ aleke ka꞉ta꞉pa꞉ laa lota꞉ pia꞉ka꞉na꞉ta꞉ kota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","mo hande ika꞉ apa꞉meima꞉ pu haemeke tupa꞉ koto ika꞉ haleme andusa꞉ta꞉ ma꞉na꞉manu handeteke hao haloma꞉me laa lapa꞉peke. Dupa lemeka꞉na꞉ta꞉ kota꞉ mo Kosene kenke paeyao pa꞉ta꞉ hape laa la꞉lieke leekeme. Diosepema꞉ dupiki pi leeke ekita꞉ mo Idiepi tapake paeyaoma꞉ta꞉ mo sipisipi handeteke haleme wanda꞉hali iki ame̱le̱ hama꞉na꞉ ota꞉ kiaemeke ekina꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Kutupa Diosepema꞉ta꞉ mo ipika꞉ hameketonu paeyao yunki hata꞉ hatuku mo kini pa꞉ta꞉ peekeme. Pua mo kini pa꞉ta꞉ alota꞉ Yaka apa꞉ make yaka kametonu make mo Keinani hao ika꞉ ma꞉na꞉manu make e wae alemanu make ika꞉ wia haleme alemanu paeyaosiki make mea epelememe. Ikita꞉ ameta꞉ mo Kosene kenke pa꞉ta꞉ a꞉pa halememe. ");
INSERT INTO ssx_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Kutupa Diosepe ipikana꞉ma꞉ ipika꞉ hatuku epeeke hameke tonuta꞉ mo kini hali pa꞉ta꞉ waleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Mo kinima꞉ iki lota꞉ pitolo hata꞉ alota꞉ Ikita꞉ eki e poko halemepe leekeme. Ikana꞉ma꞉ hombo peaaso alota꞉ Nikita꞉ mo nika꞉ apa꞉meima꞉ pia꞉ tupa꞉ kone sipisipi handeteke hao haloma꞉ haliwekie. ");
INSERT INTO ssx_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Kutupa mo Keinani kenke pa꞉ta꞉ta꞉ do tea꞉ kita꞉ ota꞉ hoela꞉ ekima꞉ nika꞉ sipisipi manuna꞉ ambu ma꞉nda꞉ dia꞉ya꞉la꞉ ekina꞉ nikita꞉ do kenke pa꞉ta꞉ haluekema꞉yeke epoloma꞉me. Koto ekina꞉ pilisio. Niki mo Kosene kenke pa꞉ta꞉ hamono waleke kie laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Koto lemeke mo kinima꞉ Diosepe pa꞉ta꞉ alota꞉ Ameta꞉ naka꞉ apa꞉ make naka꞉ kametonu make opolo epeleme ekina꞉ta꞉ kota꞉ ");
INSERT INTO ssx_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","do Idiepi kenketa꞉ ika꞉ ekie. Ikita꞉ mo Kosene kenke pa꞉ta꞉ ota꞉ a꞉pa꞉la꞉ alena꞉ handa pitina꞉e. Kutupa mo iki tukiki pa꞉ta꞉ handa wiki haliweki ma꞉nda꞉ haemeka꞉na꞉ta꞉ kota꞉ yaka ma꞉na꞉manu make handeteke hawaena꞉ lapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kutupa Diosepema꞉ta꞉ ipika꞉ apa꞉ Dieikope hatuku mo kini pa꞉ta꞉ pua waleeketa꞉ Dieikopema꞉ mo kinita꞉ Koda꞉na꞉ bikina꞉ epeayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kutupa mo kinima꞉ lota꞉ pitolo alota꞉ Neketa꞉ bapi ekipa ka꞉ta꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Dieikopema꞉ hombo peaaso alota꞉ I̱ pa pomu lopolo hanota꞉ bapi paeyao 130 paela꞉me. Koto bapi manuta꞉ mo yaka apa꞉meima꞉ ika꞉ bapi eleke eleke pomu lopemeke tupa꞉ make na handeke pa ta꞉ta꞉ doka꞉tikipiki taka꞉lake bapimanu ya꞉mee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Koto laa Dieikopema꞉ mo kini hali pa꞉ta꞉ paeyaaso epeaasa꞉eki halaa mina꞉pa꞉laeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kutupa Diosepema꞉ta꞉ mo kinima꞉ pia꞉peke leeke tupa꞉ kone ipika꞉ ateke make hameketonu make mo Idiepi kenke pa꞉ta꞉ pitina꞉ laa mo Lamesese daoni nepoko nanema꞉ mo Idiepi kenkemanu paeyao lombeipiki ota꞉ epeke kenkemanu haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Diosepema꞉ta꞉ ipika꞉ apa꞉ make ipika꞉ hameke tonu make mo ipika꞉ apa꞉na꞉ tapake paeyaosiki mo hosiki wekiwandikisunu make apa꞉tao paeyaosiki ne ana꞉na꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Mo hande tea꞉ kita꞉ ota꞉ hoeya꞉pa wieke yalo hata꞉ da paeyao pa꞉ta꞉ ne dia꞉yekeme. Kutupa mo Idiepi wanda꞉hali make Keinani wanda꞉hali make paeyaosiki tea꞉ma꞉ honkopu dia꞉ yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Kuta mo wanda꞉halima꞉ widi hamba꞉tiki pimikita꞉ Diosepema꞉ mani paeyao meata꞉ mo kinina꞉ da pa꞉ta꞉ mea pua꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kutupa mo Idiepi pita꞉ Keinani kenke yaapo pa꞉ta꞉ wieke mani paeyaosiki paeyeketa꞉ mo Idiepi haliwekima꞉ Diosepe pa꞉ta꞉ a꞉pa alota꞉ Niki ne kie. Niki na homaama꞉na꞉ma꞉ hau ma꞉nda꞉ ma꞉nda꞉ make a̱i̱ pie. Nika꞉ mani paeyaota꞉ ota꞉ paela꞉me laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Koto lemeke Diosepema꞉ hombo peaaso alota꞉ Ika꞉ ma꞉na꞉manu mea ipupee. Ika꞉ mani paeyao paeya꞉ka꞉na꞉ta꞉ kota꞉ koto ale topo pitolo hata꞉ta꞉ I̱ma꞉ iki ne kuluekema꞉ loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Koto leeke mo tapakema꞉ ika꞉ ma꞉na꞉manu mea Diosepe pa꞉ta꞉ epemekeme. Kutupa ipikana꞉ma꞉ mo wanda꞉halina꞉ hosi ma꞉na꞉manu make sipisipimanu make nanikosimanu make kaomanu make donkimanu make mea epemeke topo peata꞉ ne haleekeme. Koto bapina꞉ta꞉ mo ika꞉ ma꞉na꞉ manuna꞉ topo pea ne hala꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mo panake bapi ma꞉nda꞉na꞉ta꞉ mo wanda꞉halima꞉ ipiki pa꞉ta꞉ a꞉pa alota꞉ Tiekeo. Nikana꞉ma꞉ta꞉ mo ota꞉ ekita꞉ neke pa꞉ta꞉ na a꞉mbalumeke. Mo nika꞉ mani paeyaota꞉ paela꞉ make mo nika꞉ ma꞉na꞉ manuta꞉ amba꞉ naka꞉ mime. Koto ekina꞉ ameta꞉ mo neke kia꞉peke alemanu ma꞉nda꞉ta꞉ na ula꞉pate pa mo nika꞉ loke pita꞉ nika꞉ kenkemanu homeke neke pa꞉ta꞉ kia꞉peke ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Niki homaama꞉na꞉ma꞉ hau ma꞉nda꞉ ma꞉nda꞉ make a̱i̱ pie. Nika꞉ e manuta꞉ na mopu yamono lae. Niki make nika꞉ kenke make nema꞉ topo pitolo hata꞉ hamba꞉e. Nikita꞉ mo kinina꞉ pa hameke e pokaasa꞉ tapake homono nika꞉ kenke make ipiki milieke. Niki paa da꞉ta halo poloma꞉ tupa꞉ kone widimanu kie. Kutupa make nika꞉ e pa꞉ta꞉manu nokopomono wae alemanu ma꞉nda꞉ kie laa honke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kota꞉ Diosepema꞉ta꞉ mo Idiepi kenke paeyaota꞉ kinina꞉ eki wina꞉ hambaeyekeme. Mo tea꞉ kita꞉ ota꞉ hoeya꞉pa wieke handa mo Idiepi tapake paeyaona꞉ kenketa꞉ ota꞉ paeyaoma꞉ tapaena꞉ leeke ekima꞉ mo kenketa꞉ kinina꞉ eki homeke wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Diosepema꞉ta꞉ mo Idiepi kenke mandane nepokona꞉ kini pea pua mandane nepokona꞉ puata꞉ wanda꞉hali paeyao pa hameke e pokaasa꞉ wanda꞉hali haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kuta mo na hambeeke kenke homeketa꞉ mo hande yeni peao hayeke tapakena꞉ eki yekeme. Pa ekipeke ika꞉ eki na tapaemeke ekita꞉ kinima꞉ mo ika꞉ nolo pimiki nemanu ana꞉na꞉ hala꞉tiki pieke pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Diosepema꞉ mo wanda꞉hali pa꞉ta꞉ alota꞉ Ameta꞉ I̱ma꞉ iki make ika꞉ kenke make mo kinina꞉ hambalo ekita꞉ handelememe. Koto ekina꞉ ika꞉ e nina꞉ nokopolo peleme wae alemanu do handa꞉pe. ");
INSERT INTO ssx_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kutu pulu pelemepate mo ne napeke mendiolota꞉ yunki hata꞉na꞉ homeke homeke lo hondo mo kini pa꞉ta꞉ halimikie. Mo paa wilia꞉ ekita꞉ wae wia make ika꞉ tapake ika꞉ nolo peleme eki mia꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Koto leeke mo tapakema꞉ hombo peaaso hata꞉ alota꞉ Niki nakana꞉ma꞉ tea꞉ma꞉ amba꞉ homolo puma꞉pate niki tamba꞉ meleme. Tiekeo. Nakana꞉ma꞉ta꞉ niki pa꞉ta꞉ ota꞉ epeke hau pime. Koto ekina꞉ nikita꞉ mo kinina꞉ pa hameke e pokaasa꞉ tapakee. ");
INSERT INTO ssx_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Koto ekina꞉ Diosepema꞉ mo Idiepi kenkena꞉ lo pi witolota꞉ mo ne napeke mendiolo yunki hata꞉ ya꞉ka꞉na꞉ta꞉ homeke ma꞉nda꞉ hondo meata꞉ mo kinina꞉ eki ya꞉na꞉e laa lo pi wiekeme. Ame do make koto pi la꞉ ula꞉ ekita꞉ ota꞉ pa pa꞉la꞉me. Pate mo yeni peao haemeke haliwekina꞉ kenkemanu homeketa꞉ mo kinina꞉ eki na wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Mo Isulai tapaketa꞉ oni Idiepi kenke pa꞉ta꞉ mo Kosene da yu pa꞉ta꞉ hata꞉ta꞉ hamoko haota꞉ wekiwandiki wopu mondu wimikime. ");
INSERT INTO ssx_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Dieikopeta꞉ mo Idiepi haena꞉ta꞉ bapi 17 paeyekeme. Kutupa ota꞉ ipika꞉ bapita꞉ 147 miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Mo ipika꞉ homolo pieke nate teke pa꞉ta꞉ opolo epeeketa꞉ ipika꞉ eiyeke Diosepe wi la꞉ mea alota꞉ Naka꞉ kiki yaka paleke ankolopuna꞉ wia hata꞉ I̱ do Idiepi kenke pa꞉ta꞉ na hoilueke laa keke pi la꞉ wie. ");
INSERT INTO ssx_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Pa ekipeke yaka hone pa꞉la꞉ ekita꞉ mo yaka apa꞉ ameda hoila꞉ alena꞉ hoilu poelena꞉ loa꞉me. Koto ekina꞉ I̱ do Idiepi mina꞉pa꞉lao mo tapake hoila꞉ alena꞉ tia pua hoiya꞉peke leekeme. Diosepema꞉ hombo peaaso alota꞉ I̱ma꞉ta꞉ nakana꞉ma꞉ ale tupa꞉ ota꞉ pulueke laa la꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Dieikopema꞉ alota꞉ Nakana꞉ma꞉ pulueke laa keke pi la꞉ wie leeketa꞉ Diosepema꞉ keke pi la꞉ wieke handa Dieikopema꞉ koto pate ipika꞉ da panda꞉ pa꞉ta꞉ yeni pitolo hata꞉ keiyae leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Hao hao pa nate ma꞉nda꞉na꞉ta꞉ Diosepe pa꞉ta꞉ta꞉ ateke yeni hapa ula꞉me laa lemekeeki opu haota꞉ ipika꞉ weki yaapo Ma꞉na꞉sa꞉ pita꞉ Ipoteimi yaapo hatuku Dieikope handolo peekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kutupa Dieikope pa꞉ta꞉ naka꞉ weki Diosepeta꞉ neke handolo a꞉pa꞉la꞉me lemeke opu haota꞉ ipikita꞉ honkopu hao tia liao pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Dieikopema꞉ Diosepe pa꞉ta꞉ alota꞉ Mo Aneke Wele wopupiki Koda꞉ma꞉ta꞉ oli Keinani ula꞉ Lusu kenke pa꞉ta꞉ opolo a꞉pa I̱ epeaeya꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","I̱ pa꞉ta꞉ dupa lea꞉me. Naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandikita꞉ tutu paeyao siki haena꞉ yeke handa wekiwandiki wopu kulueke lea꞉me. Kutupa do kenketa꞉ ika꞉eki u tia pu haena꞉ I̱ma꞉ naka꞉ monduma꞉ monduma꞉ pilipi wekiwandikina꞉ wekiwandiki halueke lea꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Dieikopema꞉ ombu alota꞉ Diosepeo. Mo I̱ a̱i̱ na epeke hano do Idiepi mendiala꞉ naka꞉ weki yaapota꞉ yaka ekie. Ipoteimi pita꞉ Ma꞉na꞉sa꞉ yaapota꞉ pa mo yaka weki Lubeni pita꞉ Simiono yaapo konema꞉ handa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Pate mo naka꞉ wetepena꞉ mendilipi weki tonuta꞉ kota꞉ yaka weki dia꞉ ya꞉lieke. Koto weki tonuma꞉ta꞉ mo Ipoteimi pita꞉ Ma꞉na꞉sa꞉ yaapo pa꞉ta꞉ yama꞉ ipilia꞉ alemanu milimikie. ");
INSERT INTO ssx_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","I̱ma꞉ dupitolo ekita꞉ mo naka꞉ ama꞉ Leisolona꞉ yeke pitolome. I̱ mo Mesopoteimia hao epoa꞉ dina꞉ta꞉ mo Keinani kenke pa꞉ta꞉ Epa꞉ta꞉ teke pa꞉ta꞉ I̱ a꞉ta꞉ tieke peao homea꞉me. I̱ma꞉ mo wanda꞉ta꞉ Epa꞉ta꞉ pula꞉ pota꞉ tea꞉na꞉ hoiyua꞉me leekeme. Koto Epa꞉ta꞉ta꞉ ameta꞉ Beteleha꞉ma꞉ lelememe. ");
INSERT INTO ssx_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Dieikopema꞉ mo Diosepena꞉ weki yaapo hando hao alota꞉ Do weki yaapota꞉ epi yaapo ya꞉ka꞉ta꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Diosepema꞉ hombo peaaso alota꞉ Do weki yaapota꞉ mo hande Koda꞉ma꞉ do Idiepi kenke pa꞉ta꞉ hano ka꞉la꞉ weki yaapoe leekeme. Koto leeke Dieikopema꞉ alota꞉ I̱ma꞉ ipiliki epealuekema꞉ dopate hatuku epoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Dieikopeta꞉ bapi tieke lieke ekiyalo hata꞉ ipika꞉ leke anku pieke ekima꞉ wopu handa꞉peke na yekeme. Kutupa Diosepema꞉ mo weki yaapo ipiki pa꞉ta꞉ hatuku a꞉pa haena꞉ laa mo weki yaapo hopula nunu piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Dieikopema꞉ Diosepe pa꞉ta꞉ alota꞉ I̱ma꞉ta꞉ neke paa handulueke hone na ua꞉pate ameta꞉ Koda꞉ma꞉ naka꞉ weki yaapo kone pa handono la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kutupa Diosepema꞉ mo weki yaapo Dieikopena꞉ palekena꞉ pitipi alena꞉ mea Dieikope pitia꞉ alena꞉ panda꞉ puniaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Diosepema꞉ta꞉ Ipoteimita꞉ Dieikopena꞉ hoeya꞉ nanema꞉ pitao Ma꞉na꞉sa꞉ta꞉ popeke nanema꞉ pitaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Pate Dieikopema꞉ta꞉ ipika꞉ kiki yaapo pala꞉sa꞉ pu alu pea mo Ipoteimita꞉ wetepe weki kone ipika꞉ popeke nane kikita꞉ mo wekina꞉ ambokena꞉ wia kutupa mo ipika꞉ hoeya꞉ nane kikita꞉ mo mupeke wekina꞉ youna꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kutupa Diosepe epeaaso dupa leekeme. Mo hande yaka apa꞉mei yaapo Eipoloha꞉ma꞉ pita꞉ Aisa꞉ke yaapoma꞉ yeni pu haepeke Koda꞉ma꞉ do weki yaapo epeaena꞉e. Ame do di sikina꞉ kone I̱ hatuku a꞉pa꞉la꞉ Koda꞉ma꞉ ipiliki epeaena꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mo hande tanda eleke eleke epea꞉ ale pa꞉ta꞉ I̱ pa꞉ta꞉la꞉ mea꞉tiki pia enisoloma꞉ ipiliki epeaena꞉e. Yaka biki make mo yaka apa꞉mei yaapo Eipoloha꞉ma꞉ pita꞉ Aisa꞉ke yaapona꞉ biki make do weki yaapo pa꞉ta꞉ yama꞉ pa u tia pu haena꞉e. Ipilikana꞉ma꞉ wekiwandiki wopu make mendia ipilika꞉ wekiwandikina꞉ wekiwandiki wopu haena꞉e laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Diosepema꞉ta꞉ atekema꞉ ipika꞉ popeke nane kikita꞉ mo Ipoteimina꞉ youna꞉ wia꞉eki hando haota꞉ puki tandama꞉ homolo hata꞉ pao mea mo Ma꞉na꞉sa꞉na꞉ youna꞉ wina꞉yeke atekena꞉ kiki pao miekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ipikana꞉ma꞉ ateke pa꞉ta꞉ alota꞉ Apa꞉o. Kutupa dia꞉me. Dota꞉ mupeke weki ya꞉la꞉ma꞉ mo naka꞉ popeke nane kikita꞉ ipika꞉ ambokena꞉ wie laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Koto leekepate atekema꞉ ipika꞉ pi na opitolo hata꞉ alota꞉ Yaka wekio. I̱ma꞉ hone ulume. Ma꞉na꞉sa꞉na꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandiki make tapake tieke halo pa꞉la꞉pate pa ipika꞉ wetepe nane hamekema꞉ta꞉ ota꞉ ankulaota꞉ ipika꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandikita꞉ tutu tiekemanu halieke. ");
INSERT INTO ssx_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Koto ekina꞉ koto natena꞉ta꞉ Dieikopema꞉ mo weki yaapo epeaaso hata꞉ alota꞉ Mo Isulai tapakema꞉ta꞉ Ipilika꞉ biki alo hata꞉ta꞉ epeaasa꞉ pi dupa lelimikie. Koda꞉ma꞉ neketa꞉ Ipoteimi pita꞉ Ma꞉na꞉sa꞉ yaapoma꞉ handaena꞉e laa lelimikie leekeme. Kutu pieke ekima꞉ Dieikopema꞉ta꞉ Ipoteimita꞉ Ma꞉na꞉sa꞉na꞉ puki pa꞉ta꞉ haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kutupa Dieikopema꞉ Diosepe pa꞉ta꞉ alota꞉ I̱ homolo poloeki teke pa꞉ta꞉ ya꞉la꞉ ekita꞉ do handelepate Koda꞉ta꞉ neke yaapo hata꞉ neketa꞉ naka꞉ apa꞉meina꞉ kenke nane paa hatuku pelieke. ");
INSERT INTO ssx_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mo I̱ma꞉ yaka bainasi pita꞉ a꞉ndeli yaapoma꞉ mua꞉ hande Amo tapakena꞉ Sekeme kenke epeketa꞉ naka꞉ kametonu pa꞉ta꞉ dia꞉ya꞉la꞉pate pa I̱ma꞉ neke kitolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Dieikopema꞉ ipika꞉ wekitonu wi la꞉ mea alota꞉ I̱ hopa꞉lia pita꞉pe laa alota꞉ mo iki pa꞉ta꞉ wetepena꞉ pulu pa꞉la꞉ ekimanu I̱ma꞉ iki la kulukuma꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Dieikopena꞉ eiyeke tonuo. Homeke pa꞉ta꞉ a꞉pa taeyao pita꞉ opua꞉pe. Ika꞉ apa꞉ Isulaina꞉ pi opua꞉pe. ");
INSERT INTO ssx_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Lubeni neketa꞉ yaka mupeke weki make yaka honkopue. Kutupa I̱ wekihali hata꞉ mondolo mupeke wekie. Yaka weki paeyao ankulake neketa꞉ ta꞉na꞉ ta꞉na꞉ma꞉ homa honkopu wopu haleme. ");
INSERT INTO ssx_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Neketa꞉ mo hande ta꞉tiki ipula꞉ ikalima꞉ handeleme. Pate neketa꞉ mo titina꞉ halina꞉ biki na wilieke. Pa ekipeke neketa꞉ yaka wetepe wanda꞉ yaapo pelia naka꞉ apa꞉na꞉ da panda꞉ hoeyaeme. ");
INSERT INTO ssx_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiono pita꞉ Lipai yaapota꞉ hama̱la̱꞉e. Ipilikana꞉ma꞉ta꞉ ipilika꞉ a꞉nda꞉ pita꞉la꞉ ale manuma꞉ hali lu homaepeme. ");
INSERT INTO ssx_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ipilika꞉ a꞉mbaaso hata꞉ pi pi lo halepeke I̱ma꞉ta꞉ na apa꞉taalueke. Kutupa ipilika꞉ pi hotilipi ale pa꞉ta꞉ make I̱ na apa꞉tiki pulueke. Pa ekipeke ipilikana꞉ma꞉ta꞉ mineke pankolo hata꞉ haliweki lipime. Kutupa telepo alo hata꞉ta꞉ mo hali kao manuta꞉ pa dola꞉pake peaepeme. ");
INSERT INTO ssx_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ipilika꞉ mineke pankepe ekita꞉ ota꞉ paala꞉ pikieki ya꞉la꞉ ekina꞉ta꞉ kota꞉ esihou pi wina꞉e. Kutupa make ipilika꞉ lombeipiki mineke pankepe ekita꞉ ota꞉ a꞉ta꞉ma꞉ homa꞉peke na ya꞉la꞉ ekina꞉ loa꞉me. I̱ma꞉ ipilikita꞉ mo Isulai kenke paeyao pa꞉ta꞉ putupa꞉ alu pina꞉ lolueke. I̱ma꞉ta꞉ ipilika꞉ mo Isulai wanda꞉hali ame̱le̱ kone ta꞉ta꞉ ta꞉ta꞉ pea halu pilipikie. ");
INSERT INTO ssx_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Diuda neketa꞉ naka꞉ kame tonuma꞉ naka꞉ biki yeiya꞉ lalimikie. Nakana꞉ma꞉ta꞉ naka꞉ a꞉nda꞉ tunkiliki tapake manuta꞉ make yola꞉ mea wia haleme. Naka꞉ kame tonuma꞉ta꞉ neke pa꞉ta꞉ panda꞉punialimikie. ");
INSERT INTO ssx_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Diudata꞉ Laeonoma꞉ handa꞉la꞉me. Ipika꞉ napeke ale liata꞉ oni ipika꞉ da pa꞉ta꞉ la꞉ka꞉la pula꞉me. Kiki anke tindipa tindipa pea polu pila꞉me. Paeyaoma꞉ paala꞉ma꞉ homolo hata꞉ ipiki penkilipa꞉ tiatiki pea꞉peke na ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Diudama꞉ta꞉ mo kinina꞉ minu hala꞉ dolo miniki halieke. Kutupa ipika꞉ monduma꞉ monduma꞉ pilia꞉ wekiwandikina꞉ wekiwandiki pa꞉ta꞉ yama꞉ kini halimanu hoto paeyao handeteke hao hatiki pilimikie. Tutu manuma꞉ta꞉ ipika꞉ dakisi hambuluekema꞉ ala꞉ta꞉ ala꞉ta꞉ mea a꞉palimikie. Kutupa ipiki pa꞉ta꞉ homu pitolo hata꞉ panda꞉punialimikie. ");
INSERT INTO ssx_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ipikana꞉ma꞉ ipika꞉ panake donkita꞉ mo waini puna꞉ endi baasa꞉me. Pa pina꞉ma꞉ mo ota꞉ epeke paeyao ankulake piki waini puna꞉ loa꞉me. Kutupa ipika꞉ aka꞉ manuta꞉ mo we au leke wepiki waini ikali pa꞉ta꞉ tandepo hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mo waini ikali no haleke yalota꞉ ipika꞉ leke we pupa pa꞉la꞉mee. Ipika꞉ kaketa꞉ andu no haleke yalota꞉ hake pa꞉la꞉mee. ");
INSERT INTO ssx_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulonita꞉ dawala tea꞉na꞉ pelia haliekee. Ipika꞉ dawala tea꞉na꞉ta꞉ mo kawasomanu epeke tupa꞉ a꞉pa pitina꞉ epeke alena꞉ yelieke. Ipika꞉ kilu tumbuao halo pa꞉la꞉ ekita꞉ ota꞉ mo Saidoni da kenkena꞉ pua tombo pilieke. ");
INSERT INTO ssx_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakata꞉ mo hone na wiki donkima꞉ handa꞉la꞉ halie. Mo donki ipikita꞉ oni ipika꞉ hokina꞉ mendiaasa꞉ numanu tukikina꞉ pala꞉mba꞉ pelia꞉la꞉ ma꞉na꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Pate ipika꞉ handolota꞉ do hoto pila꞉ alena꞉ta꞉ a꞉pa꞉la꞉me laata꞉ do kenketa꞉ ota꞉ yole pa꞉la꞉me ala꞉me. Koto ekina꞉ mo ala꞉ta꞉ ala꞉ta꞉ tuluekema꞉ yeke ipika꞉ hoki panda꞉puniaasa꞉me. Kutupa ipikita꞉ pa hameke e pokaasa꞉ some tupa꞉ e pokena꞉ la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Da꞉nita꞉ ipika꞉ wanda꞉halina꞉ handeteke hala꞉ some halieke. Ikita꞉ mo hande mandane Isulai tapakema꞉ handilimikie. ");
INSERT INTO ssx_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Da꞉nita꞉ mo pota꞉ tea꞉na꞉ pila꞉ keto wilieke. Mo pota꞉ tea꞉na꞉ hali lita꞉la꞉ ketona꞉ loa꞉me. Mo hosi hokina꞉ pita pula꞉ some ya handa꞉liao lopena꞉yeke mo hosina꞉ kilolikina꞉ awa꞉la꞉ keto wilieke. ");
INSERT INTO ssx_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Tekehalio naka꞉ ka꞉la꞉pa꞉ tapaase eki yu wia halome. ");
INSERT INTO ssx_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ka꞉da꞉ta꞉ mo pake no haleme tapake ma꞉nda꞉ma꞉ lulu pelia꞉pate paa ipikana꞉ma꞉ la꞉ka꞉la mo tapake telipilieke. ");
INSERT INTO ssx_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","A꞉seana꞉ kenkena꞉ta꞉ epeke epeke nemanu opilieke. Ipikana꞉ma꞉ta꞉ mo kinima꞉ napeke ya꞉la꞉ epeke nemanu opalieke. ");
INSERT INTO ssx_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Na꞉petalita꞉ mo walekena꞉ pototo la pomina꞉la꞉ dia ma꞉na꞉ma꞉ handa꞉la꞉me. Ipikita꞉ ota꞉ epeke ikikimanu mondu hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Diosepeta꞉ mo tunkulupa ula꞉ ikali tea꞉na꞉ hala꞉ tikene donkima꞉ handa꞉la꞉me. Ipikita꞉ mo yueli pa꞉ta꞉ hala꞉ panake hosi hali ma꞉na꞉ma꞉ handa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ipika꞉ a꞉nda꞉ tunkiliki tapakema꞉ta꞉ ipikita꞉ paala꞉piki tupa꞉ a꞉pa a꞉nda꞉ pilimikie. Kutupa ika꞉ semoko a꞉ndeli manuma꞉ ipiki tolutia pomilimikie. ");
INSERT INTO ssx_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pate ipika꞉ a꞉ndelita꞉ la꞉ma꞉ na pa꞉la꞉me. Kutupa ipika꞉ kiki yaapo honkopu haowala꞉me. Koto hauta꞉ mo Dieikopena꞉ Wele wopupiki Koda꞉na꞉ honkopuma꞉ pia꞉me. Mo hande Sipisipi Handeteke Hala꞉ some Isulaina꞉ handeteke hao hala꞉ Koda꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mo neke tamba꞉ mina꞉la꞉ta꞉ naka꞉ apa꞉na꞉ Koda꞉ma꞉ pita꞉la꞉me. Mo Aneke Wele wopupiki Koda꞉ma꞉ neke epeaasa꞉me. Oli ya nane lakoma꞉ neke epeaasa꞉me. Kutupa oni kenke oto nane opa꞉laasa꞉ ikali manuma꞉ makee. Kaomanu wopu make wekiwandiki wopu make neke epeaasa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Widina꞉ kiliki pita꞉ palawasi yaapoma꞉ make neke epeaasa꞉me. Mo amba꞉ hao haemeke pote manuma꞉ make neke epeaasa꞉me. Kutupa mo pa u tia pu hala꞉ elimanu pa꞉ta꞉ yama꞉ mo ta꞉ta꞉ ta꞉ta꞉ piki epeke alemanu make neke pa꞉ta꞉ ipula꞉me. Do epeaasa꞉ ekimanu paeyaota꞉ Diosepena꞉ ambokena꞉ wina꞉e. Mo ipika꞉ hamekema꞉ handa꞉la꞉ hali dia꞉me laa ma̱leke lila꞉ somena꞉ wenokona꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benisaminita꞉ mo hoke paala꞉ wopupiki tikene kikama꞉ handa꞉la꞉me. Peliolo da kelepolota꞉ pa pitiki alemanu lia ombu na꞉tiki pu hala꞉me laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Koto mo hande Isulaina꞉ 12 tapakee. Kutupa koto pi manuta꞉ mo hande ateke Dieikopema꞉ ipika꞉ paeyaaso pi alo hata꞉ ipika꞉ weki homeke homeke paeyao pa꞉ta꞉ manda꞉ meaaso hata꞉ leeke pie. ");
INSERT INTO ssx_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Kutupa Dieikopema꞉ eiyeketonu taka꞉lakema꞉ pi alo alota꞉ I̱ta꞉ ameta꞉ mo yaka wanda꞉hali ame̱le̱ apa꞉tao homolo pulume. Koto ekina꞉ dupa꞉peke. I̱ta꞉ yaka apa꞉ ame̱le̱ mandakena꞉ mo Keinani kenke pa꞉ta꞉ Ma꞉motena꞉ nate ipula꞉ nanema꞉ tilao Hidi hali Epotonina꞉ Ma꞉ka꞉pila e pa꞉ta꞉ ula꞉ tikene da pa꞉ta꞉ hoiya꞉peke. Eipoloha꞉ma꞉ma꞉ koto apa꞉nda꞉ta꞉ hali hoita꞉la꞉ lapa꞉ wina꞉ mo Epotoni pa꞉ta꞉ hambeeke ekima꞉ pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Koto pa꞉ta꞉ta꞉ Eipoloha꞉ma꞉ pita꞉ weteke Seta yaapo hoila꞉me. Kutupa koto pa꞉ta꞉ ombuta꞉ Aisa꞉ke pita꞉ weteke Lepeka yaapo make hoila꞉me. Kutupa I̱ma꞉ maketa꞉ koto pa꞉ta꞉ Lia hoiyua꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mo e make mo tikene da make mo Hidi tapake pa꞉ta꞉ hambeeke ekie. Koto pa꞉la꞉ma꞉ I̱ koto pa꞉ta꞉ hoiya꞉pa꞉peke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Dieikopema꞉ ipika꞉ eiyeketonu pa꞉ta꞉ mana꞉manu halo paeyaota꞉ paa polu hola꞉paka꞉na꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Diosepema꞉ta꞉ mo ateke toko manda lopa e̱ alo hata꞉ atekena꞉ leke popeleke nunu piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Kutupa ipikana꞉ma꞉ atekena꞉ loke tanda꞉ paama꞉na꞉ mulamula yankape laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Koto mulamula yankaota꞉ mo Idiepi tapakema꞉ pu haemeke tupa꞉ 40 natemanu pu paeyaemekeme. Kutupa mo Idiepi wanda꞉halima꞉ta꞉ 70 natena꞉ Dieikopena꞉ homa꞉ wia pitimikime. ");
INSERT INTO ssx_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Mo homa꞉ wia pitimiki nate paeyeke handaata꞉ Diosepema꞉ mo kinina꞉ mandane e pokaemeke haliweki pa꞉ta꞉ alota꞉ Pilisio. Do pi mo kini pa꞉ta꞉ mea pupa꞉e. ");
INSERT INTO ssx_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Yaka apa꞉ homuluekema꞉ pita꞉ta꞉ mo Keinani kenke pa꞉ta꞉ ipika꞉ amu pea ula꞉ tikene da pa꞉ta꞉ pua hoiya꞉peke laata꞉ I̱ma꞉ pi la꞉ wiono lea꞉me. Koto ekina꞉ pilisio. Yaka apa꞉ hoilu pono lae. Kutupata꞉ I̱ paa la꞉ka꞉la ipulueke laa lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Koto pi opua mo kinima꞉ hombo peaaso alota꞉ Mo naka꞉ pulueke laa la꞉ wi tupa꞉ naka꞉ apa꞉ pua hoiya꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Koto leeke Diosepeta꞉ ipika꞉ apa꞉ hoilu peekeme. Mo kinina꞉ handeteke haemeke haliweki paeyao make kinina꞉ handeteke pila꞉ pa꞉ta꞉ haleme tondiki haliweki make mo Idiepina꞉ biki ula꞉ haliweki paeyao make Diosepe ame̱le̱ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Kutupa ipika꞉ wekiwanda꞉ make ipika꞉ hameketonu make mo ipika꞉ apa꞉na꞉ tapake paeyaosiki make ipiki ame̱le̱ pemekeme. Pate ika꞉ hosiki wekiwandikisunu make ika꞉ sipisipimanu make nanikosimanu make kaomanu make homeke oni Kosene kenke pa꞉ta꞉ pa haemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Mo hosima꞉ yola꞉la꞉ pota꞉ alena꞉ pila꞉ haliweki make mo hosi hokina꞉ pila꞉ haliweki make Diosepe ame̱le̱ mandakena꞉ pemekeme. Mota꞉ tapaketa꞉ ota꞉ tieke kiake yekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Mo tapake hande hoilu pimiki ale teke pa꞉ta꞉ a꞉pa mo Diodanina꞉ nate ipula꞉ nanema꞉ tilao mo widi kilikina꞉ ambuku napeke yaapo putupa alu pa꞉la꞉ hama꞉ ma꞉nda꞉ biki Atade opolo a꞉paata꞉ nate hokuluna꞉ anekema꞉ homa꞉ wia e̱ lemekeme. Kutupa nate wataake hata꞉na꞉ Diosepema꞉ ika꞉ homa꞉ wia pita꞉ pu haemeke tupa꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kutu pimikieki mo Keinani wanda꞉halima꞉ mo Atade da homa꞉ wimikieki handolo hata꞉ alota꞉ Mo Idiepi tapakema꞉ a꞉ta꞉ tiekema꞉ homa꞉ wia pita꞉la꞉ a꞉ta꞉piki hau tieke kiake pitelememe laa lemekeme. Koto ekina꞉ koto pateta꞉ bikita꞉ Abele Miseteimi lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Koto ekina꞉ mo Dieikopena꞉ eiyeke tonuma꞉ta꞉ atekema꞉ pia꞉pa꞉peke leekeeki kone pimikime. ");
INSERT INTO ssx_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ipika꞉ toko tia puata꞉ mo hande Eipoloha꞉ma꞉ma꞉ hali lapa꞉ wina꞉yeke mo Keinani kenke pa꞉ta꞉ hande Hidi hali Epotonina꞉ e pa꞉ta꞉ wieke tikene da pa꞉ta꞉ mea pua lapa꞉ pimikime. Koto tikene data꞉ mo Ma꞉motena꞉ nate ipula꞉ nanema꞉ Ma꞉ka꞉pila da kenke pa꞉ta꞉ ula꞉ ekina꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Diosepema꞉ ateke lapa꞉ pea paeyeketa꞉ hameke tonu make mo ipiki ame̱le̱ homa꞉ da pemeke tapake paeyao Idiepi nane la꞉ka꞉la paa pemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Mo ika꞉ ateke homea꞉ hoki naneta꞉ Diosepena꞉ hameke tonuma꞉ alota꞉ Mo Diosepema꞉ hande nikana꞉ma꞉ ipiki pa꞉ta꞉ puma꞉ hoke hauna꞉ niki pa honditi pea mo nikana꞉ma꞉ puma꞉ ekina꞉ yenki mulueke laa pota꞉manu wepia꞉ka꞉na꞉ta꞉ kota꞉ eki pumana꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Koto ekina꞉ Diosepe pa꞉ta꞉ pi tapaaso alota꞉ Nika꞉ apa꞉ homuluekema꞉ pita꞉ta꞉ ipikana꞉ma꞉ta꞉ nikana꞉ma꞉ ");
INSERT INTO ssx_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","neke pa꞉ta꞉ dupa lota꞉ piomono lea꞉me. Pilisio. Naka꞉ kame tonuma꞉ neke luekema꞉ pimi ata꞉ka꞉ peake hauta꞉ pa paeyaapeke lea꞉me. Koto ekina꞉ta꞉ pilisio. Ameta꞉ mo nikana꞉ma꞉ ata꞉ka꞉ peake hau puma꞉eki pa paeyawapeke. Mo hande naka꞉ apa꞉na꞉ Koda꞉na꞉ e pokaasoma꞉ tapakema꞉ poloma꞉ ekina꞉ loa꞉me lemekeme. Diosepema꞉ koto pi mu haota꞉ e̱ leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kutupa ipika꞉ hameke tonu a꞉pa ipiki pa꞉ta꞉ panda꞉ puniaaso hata꞉ alota꞉ Nikita꞉ ameta꞉ naka꞉ leke popelekena꞉ naka꞉ pa hameke e pokaasoma꞉ tapake do handa꞉e laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Pate Diosepema꞉ mo hameke tonu pa꞉ta꞉ alota꞉ I̱ma꞉ta꞉ yaka kone mo Koda꞉ topo peaka꞉na꞉ I̱ hapeke na ya꞉la꞉me. Paala꞉ma꞉ na homa꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ikana꞉ma꞉ta꞉ I̱ pa꞉ta꞉ hoke hau pimipate Koda꞉ma꞉ta꞉ koto paa topo pea epekeeki au lala꞉me. Kutupa mo koto hau pimi ekita꞉ mo ame pa do haleme wanda꞉hali paeyaona꞉ hao polu pelemeeki epeanoyeke pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ikana꞉ma꞉ paala꞉ma꞉ homa꞉pekeeki ma꞉nda꞉ dia꞉me. I̱ma꞉ta꞉ iki make ika꞉ wekiwandiki make handeteke hao halueke leekeme. Koto ekina꞉ mo tapakema꞉ ta꞉na꞉ma꞉ homena꞉ loluekema꞉ ipikana꞉ma꞉ta꞉ mo tapakena꞉ puki liake koto homupiki pi manuma꞉ epeayekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Diosepeta꞉ atekena꞉ tapake ame̱le̱ Idiepi kenke pa꞉ta꞉ hao hayekeme. Kutupa bapi 110 haota꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ipikana꞉ma꞉ta꞉ Ipoteimina꞉ wekiwandiki make ipika꞉ wekiwandikina꞉ wekiwandiki make handaa homeekeme. Kutupa make mo ipika꞉ weki ma꞉nda꞉ Ma꞉na꞉sa꞉na꞉ eiyeke Meikana꞉ wekiwandiki mo ipika꞉ tapake pa꞉ta꞉ honda꞉ pambemekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ipikana꞉ma꞉ ipika꞉ hameketonu pa꞉ta꞉ alota꞉ I̱ta꞉ homolo poloeki teke pa꞉ta꞉ do ya꞉la꞉me. Pate Koda꞉ma꞉ta꞉ iki ota꞉ epeke tupa꞉ handeteke hao halieke. Kutupata꞉ mo hande ipikana꞉ma꞉ Eipoloha꞉ma꞉ make Aisa꞉ke make Dieikope ameda pa꞉ta꞉ Do kenke kulueke laa la꞉ wieke kenke pa꞉ta꞉ta꞉ ota꞉ iki hatuku pelieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kutupa Diosepema꞉ ipika꞉ wanda꞉hali pa꞉ta꞉ta꞉ keke pi dupa lape laata꞉ honke leekeme. Ipikana꞉ma꞉ alota꞉ I̱ pa꞉ta꞉ pi la꞉ wipe laata꞉ Koda꞉ma꞉ iki koto kenke pa꞉ta꞉ hatuku pea꞉ka꞉na꞉ta꞉ kota꞉ yaka toko iki ame̱le̱ mandakena꞉ mea polumekee laa la꞉ wipee leekeme. ");
INSERT INTO ssx_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kota꞉ Diosepeta꞉ 110 bapina꞉ Idiepi kenke pa꞉ta꞉ homeekeme. Mo tapakema꞉ta꞉ ipika꞉ lokena꞉ na tanda꞉pa꞉la꞉ mulamula ana꞉na꞉ yankao hali toko pamba꞉la꞉ bokisi pa꞉ta꞉ wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dota꞉ mo hande Yesu Ketisona꞉ apa꞉meina꞉ bikimanu wape pa꞉la꞉ekie. Deipidita꞉ Yesuna꞉ meiyeke hayekeme. Kutupa Eipoloha꞉ma꞉ta꞉ Deipidina꞉ meiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eipoloha꞉ma꞉ma꞉ta꞉ Aisa꞉ke mondu wiekeme. Aisa꞉kema꞉ta꞉ Dieikope mondu wiekeme. Dieikopema꞉ta꞉ Diuda hama̱la̱꞉ hama̱la̱꞉ mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Diudama꞉ta꞉ Petese pita꞉ Seta yaapo mondu wiekeme. Ipilika꞉ ama꞉na꞉ bikita꞉ Tama. Petesema꞉ta꞉ Hesotono mondu wiekeme. Hesotonoma꞉ta꞉ La꞉mi mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","La꞉mima꞉ta꞉ Amina꞉da꞉be mondu wiekeme. Amina꞉da꞉bema꞉ta꞉ Na꞉sioni mondu wiekeme. Na꞉sionima꞉ta꞉ Sa꞉limoni mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sa꞉limonima꞉ta꞉ Boa꞉si mondu wiekeme. Boa꞉sina꞉ ama꞉ta꞉ Leiha꞉pe hayekeme. Boa꞉sima꞉ta꞉ Obedi mondu wiekeme. Ipika꞉ ama꞉ta꞉ Luti hayekeme. Obedima꞉ta꞉ Diesi mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Diesima꞉ta꞉ mo hande kini halo pieke hali Deipidi mondu wiekeme. Deipidima꞉ta꞉ Solomono mondu wiekeme. Koto Solomono ipika꞉ ama꞉ta꞉ titina꞉ Yutaeyama꞉ miekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonoma꞉ta꞉ Leoboeme mondu wiekeme. Leoboemema꞉ta꞉ Abidia mondu wiekeme. Abidiama꞉ta꞉ Asa mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asama꞉ta꞉ Dia꞉hosapa꞉ti mondu wiekeme. Dia꞉hosapa꞉tima꞉ta꞉ Diehotami mondu wiekeme. Diehotamima꞉ta꞉ Asaiya mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaiyama꞉ta꞉ Diota꞉mi mondu wiekeme. Diota꞉mima꞉ta꞉ Eiha꞉si mondu wiekeme. Eiha꞉sima꞉ta꞉ Hesikaiya꞉ mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesikaiya꞉ma꞉ta꞉ Ma꞉na꞉se mondu wiekeme. Ma꞉na꞉sema꞉ta꞉ A꞉mono mondu wiekeme. A꞉monoma꞉ta꞉ Diosaiya mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Diosaiyama꞉ta꞉ mo hande Isulai wanda꞉hali Ba꞉biloni dipula hatuku peme natena꞉ta꞉ Dia꞉hoya꞉kini hama̱la̱꞉ hama̱la̱꞉ mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ba꞉biloni nane hata꞉ta꞉ Dia꞉hoya꞉kinima꞉ta꞉ Sieletieli mondu wiekeme. Sieletielima꞉ta꞉ Setubabele mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Setubabelema꞉ta꞉ Abiudi mondu wiekeme. Abiudima꞉ta꞉ Eliakimi mondu wiekeme. Eliakimima꞉ta꞉ Aso mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoma꞉ta꞉ Sa꞉doki mondu wiekeme. Sa꞉dokima꞉ta꞉ Akimi mondu wiekeme. Akimima꞉ta꞉ Eliudi mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudima꞉ta꞉ Eliasa mondu wiekeme. Eliasama꞉ta꞉ Ma꞉tani mondu wiekeme. Ma꞉tanima꞉ta꞉ Dieikope mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Dieikopema꞉ta꞉ mo hande Meti mieke hali Diosepe mondu wiekeme. Metima꞉ta꞉ mo hande Yesu biki ma꞉nda꞉ Ketiso lo pieke hali mondu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Koto ekina꞉ Eipoloha꞉ma꞉ma꞉ kini pu mea pua Deipidima꞉ tombo wia koto pa꞉ta꞉ haemeke apa꞉meita꞉ kiki yaapona꞉ tonkopu haemekeme. Deipidima꞉ kini pu mea pua Ba꞉biloni pemeke ekima꞉ tombo wia koto pa꞉ta꞉ haemeke apa꞉meita꞉ kiki yaapona꞉ tonkopu haemekeme. Kutaa make mo Ba꞉biloni pemeke ekima꞉ kini pu mea pua Ketisoma꞉ tombo wia koto pa꞉ta꞉ haemeke apa꞉meita꞉ kiki yaapona꞉ tonkopu ombu haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Ketisona꞉ ma꞉nda꞉la꞉ ekita꞉ dupa. Ipika꞉ ama꞉ Metita꞉ Diosepena꞉ tome wandiki hayekepate ipika꞉ da a̱i̱ na peke hata꞉ mo Holi Sipitidima꞉ pitayeke weki mendia꞉peke yekeeki hando wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Diosepe epeke hali yaalo mo Meti yaala꞉ma꞉ homaaluekema꞉ hone na wieke handaa ipilika꞉ tome haepekeeki a꞉mbao mina꞉pa꞉lalueke hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Diosepema꞉ koto piki honemanu witolo haena꞉ta꞉ timba ma꞉nda꞉na꞉ ipika꞉ upa pa꞉ta꞉ yama꞉ Koda꞉na꞉ enisolo homeke opolo a꞉pa alota꞉ Deipidina꞉ weki Diosepeo. Meti naka꞉ wanda꞉ haena꞉ muluekema꞉ta꞉ paala꞉ma꞉ na homa꞉peke. Pa ekipeke mo weki pita꞉la꞉ ekita꞉ mo Holi Sipitidima꞉ kone peawala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mo wekita꞉ hali weki mendilieke. Kutu pia꞉ka꞉na꞉ ipika꞉ wanda꞉hali mea da꞉taalo pa꞉la꞉ ekina꞉ yeketa꞉ ipika꞉ biki Yesue lelipipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Meti pa꞉ta꞉ do haumanu peayeke ekita꞉ mo Tekehalima꞉ amba꞉ titina꞉ ipika꞉ potopede hali pa꞉ta꞉ yama꞉ la꞉ wieke pimanu paeyao peneme yaaluekema꞉ yeke piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Mo potopede halima꞉ta꞉ dupa leekeme. Mo halima꞉ na watake wandikina꞉ weleke pa꞉ta꞉ta꞉ weki weleke lombaata꞉ hali weki mendilieke. Koto wekina꞉ bikita꞉ Imanua꞉le lelieke leekeme. Koto bikina꞉ teketa꞉ Koda꞉ niki ame̱le̱ a꞉pa hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Diosepe tiaota꞉ mo hande enisoloma꞉ leeke tupa꞉ Metima꞉ ipika꞉ wanda꞉ haena꞉ miekeme. ");
INSERT INTO ssx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kutu piekepate mo weki pa pita꞉ paleke haena꞉ta꞉ loke na apa꞉taepekeme. Mo weki hamba꞉ mieketa꞉ Diosepema꞉ ipika꞉ bikita꞉ Yesue leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mo hande Hetodi kini hayeke dina꞉ta꞉ Yesu Diudia kenke pa꞉ta꞉ hayeke da Beteleha꞉ma꞉ nane mendiekeme. Hosiki hao hoki naneta꞉ hombulanka꞉ yata꞉pu haemeke mandane haliwekima꞉ nate opa꞉la꞉ nanema꞉ yama꞉ Diutuseleme da nane a꞉pa ");
INSERT INTO ssx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","lota꞉ pitolo alota꞉ Mo hande Diu wanda꞉halina꞉ kini halo pa꞉la꞉ panake weki ma꞉nda꞉la꞉ wekita꞉ hando pa꞉ta꞉ hala꞉pe. Ipika꞉ hombulanka꞉ nate opa꞉la꞉ nanema꞉ opeeke nikana꞉ma꞉ handaa ipiki pa꞉ta꞉ panda꞉ puluekema꞉ epoma꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kini Hetodima꞉ koto lemekeeki opuaata꞉ ipiki make mo Diutuseleme wanda꞉hali paeyaoma꞉ make penkilipa꞉tia pomimikime. ");
INSERT INTO ssx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hetodima꞉ mo yeni peao haemeke you haliweki make mandane pi ula꞉eki walo hala꞉ haliweki tonka꞉na꞉ wi la꞉ mea momba꞉laa iki pa꞉ta꞉ lota꞉ pitolo alota꞉ Mo Ketisota꞉ hando pa꞉ta꞉ yama꞉ mendilia꞉pe laa iki pa꞉ta꞉ lota꞉ piekeme. Ikana꞉ma꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mo hande Diudia kenke pa꞉ta꞉ ula꞉ daoni Beteleha꞉ma꞉ pa꞉ta꞉ mendilieke laa hombo peaaso alota꞉ Mo amba꞉ haemeke potopede haliwekima꞉ta꞉ dupa wape pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Diudia kenke pa꞉ta꞉ ula꞉ daoni Beteleha꞉ma꞉o. Neketa꞉ mo Diudiana꞉ biki ula꞉ daoni manuna꞉ hoki nane na haleme. Pa ekipeke. Neke pa꞉ta꞉ta꞉ mo You hali homeke ya Isulai wanda꞉hali handeteke hawaluekema꞉ ipilieke laa wape pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Koto ekina꞉ta꞉ Hetodima꞉ mo hombulanka꞉ ota꞉ kini pea opeeke nate weiluekema꞉ mo hande nate opa꞉la꞉ nanema꞉ epemeke kimisu haliweki a꞉mbao wi la꞉ mea pi hotimikime. ");
INSERT INTO ssx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ika꞉ pimanu opuaata꞉ ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Mo hande weki yopu siki weilu pupe la alota꞉ Mo weki handa꞉ wimika꞉na꞉ta꞉ kota꞉ I̱ make ipiki pa꞉ta꞉ panda꞉ pulu puluekema꞉ a꞉pa la kia꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ikana꞉ma꞉ ipika꞉ pi opuaa Diutuseleme mina꞉pa꞉lao pulu hata꞉ mo amba꞉ hande handemeke hombulanka꞉ kone paa handemekeme. Koto hande hombulanka꞉ paa handolo hata꞉ta꞉ ika꞉ pukima꞉ta꞉ ta꞉na꞉ wopu homemekeme. Mo hombulanka꞉ta꞉ ika꞉ leke popeleke nanema꞉ a̱i̱ puaata꞉ mo weki wia pitieke da holu manda handa꞉niao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kutu pieke handa ikana꞉ma꞉ mo da tukiki pa꞉ta꞉ honda꞉ pamba pua mo wekita꞉ ipika꞉ inkiki Metima꞉ wia pitiekeeki handaata꞉ ika꞉ tumiki yotuao panda꞉ puniao pita꞉ ipika꞉ biki yeiya꞉ laemekeme. Kutu polo hata꞉ta꞉ ika꞉ nu pa꞉ta꞉ mendimiki yenki tieke alemanu kolo make mo lanka꞉ yankea꞉ka꞉na꞉ totopopiki lumu opa꞉la꞉ lanka꞉ siki make mo totopo yolepiki ti pankeke ale make toku mea ipiki pa꞉ta꞉ halemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kutaata꞉ Koda꞉ma꞉ iki pa꞉ta꞉ alota꞉ Hetodi pa꞉ta꞉ paa na pua꞉pa꞉peke laa leeke handata꞉ pota꞉ ma꞉nda꞉ nanema꞉ paka꞉lao ika꞉ da yu nane la꞉ka꞉la pemeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mo hande kimisu haliweki pemeke hoki naneta꞉ mo Tekehalina꞉ enisoloma꞉ Diosepe pa꞉ta꞉ upana꞉ walolo alota꞉ Hetodima꞉ mo wekisiki luluekema꞉ weilieke. Koto ekina꞉ta꞉ tiao mo weki ankula꞉ hatuku mea Idiepi nane pindipa pua I̱ma꞉ paa la꞉ka꞉la pua꞉pa꞉peke lolo poloeki handeteke hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Koto leekeeki opuaata꞉ Diosepema꞉ tiao ipika꞉ weki ankula꞉ hatuku mea koto timba kone mo da mina꞉pa꞉lao Idiepi nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Koto pa꞉ta꞉ puaata꞉ Hetodi homena꞉ yeke yu wia haemekeme. Kutu pimiki ekima꞉ta꞉ mo hande Tekehalima꞉ ipika꞉ potopede hali pa꞉ta꞉ yama꞉ pi la꞉ witolo alota꞉ Ya wekio. Idiepi kenke mina꞉pa꞉lao epoe laa la꞉ ua꞉ pi yaaluekema꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hetodima꞉ta꞉ mo hande nate opa꞉la꞉ nane hao epemeke kimisu hali wekima꞉ta꞉ ipiki makeao pemekeeki handaata꞉ ipikana꞉ma꞉ mineke tieke pankeekeme. Koto ekina꞉ta꞉ ipikana꞉ma꞉ mo Beteleha꞉ma꞉ da teke pa꞉ta꞉ make nepoko nepoko haemeke damanu pa꞉ta꞉ make ika꞉ bapi yaapo lombei na piki wekitonu paeyao homena꞉ lu paeyaapa꞉peke laa la꞉ wiekeme. Mo hande kimisu haliwekima꞉ hande titina꞉ hombulanka꞉ opeeke nate ipiki pa꞉ta꞉ la halemekeeki Hetodima꞉ hone puaata꞉ dupiki wekitonu homeke lia꞉peke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Do hau paeyao pieke ekita꞉ mo hande amba꞉ potopede Dietemaiyama꞉ la꞉ wiekeeki yaeyekeme. Koto ipikana꞉ma꞉ leeke pita꞉ dupa ");
INSERT INTO ssx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Mo Lama kenke naneta꞉ pi ho̱la̱꞉make ma꞉nda꞉ opitelememe. Wanda꞉ homeke ma꞉nda꞉ma꞉ ka꞉nda꞉ tiekema꞉ homolo hata꞉ e̱ tieke ala꞉me. Leisoloma꞉ ipika꞉ wekiwandikina꞉ e̱ tieke ala꞉me. Ipika꞉ wekiwandiki paeyao homemeke handaa wanda꞉weki ma꞉nda꞉ma꞉ ipiki ta꞉na꞉ma꞉ homa꞉tiao tamba꞉ mina꞉ lapeketa꞉ kiaasa꞉me laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mo hande Kini Hetodi homeekeeki hoki naneta꞉ Diosepeta꞉ Idiepi kenke pa꞉ta꞉ pa haena꞉ mo enisolo homekema꞉ ipika꞉ upa pa꞉ta꞉ opolo a꞉pa alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Mo hande weki luluekema꞉ taapeme haliwekita꞉ homememe. Koto ekina꞉ neketa꞉ tiao mo weki ankula꞉ hatuku Idiepi mina꞉pa꞉lao Isulai kenke nane paa pua꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Koto leeke Diosepema꞉ tiao mo weki ankula꞉ hatuku mea mina꞉ Isulai kenke nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pate Akelosima꞉ ipika꞉ ateke Hetodi mo Diudia kenke Kini halina꞉ anketeke ma꞉la꞉me pi Diosepema꞉ opuaata꞉ koto kenke nane pua꞉peke paala꞉ma꞉ homeekeme. Kutu pieketa꞉ Koda꞉ma꞉ Diosepena꞉ upa pa꞉ta꞉ pea꞉pekeeki mandaneeki ma꞉nda꞉ paa waleekeme. Koto ekina꞉ta꞉ Diosepema꞉ Ka꞉lili kenke nane hayeke da ma꞉nda꞉ ");
INSERT INTO ssx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na꞉sa꞉tete halo pemekeme. Koto halo pemeke ekita꞉ mo potopede haliwekima꞉ la꞉ wiekeeki yaeyekeme. Koto ikana꞉ma꞉ la꞉ wiekeeki dupa Ipikita꞉ Na꞉sa꞉tete hali hala꞉me lelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Koto natena꞉ta꞉ mo hande bapitaisi peao hayeke hali Dionima꞉ mo Diudiana꞉ hapiki kenke pa꞉ta꞉ a꞉pa hata꞉ pi kini pea walolo alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mo hande hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ teke pa꞉ta꞉ ya꞉la꞉ma꞉ ika꞉ hoke haumanu paeyao mina꞉pa꞉lao hoki wala꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Do Dioni pa꞉ta꞉ta꞉ mo hande potopede hali Aisayama꞉ pi ma꞉nda꞉ la꞉ wiekeme. Koto la꞉ wieke pita꞉ dupa. Ma꞉nda꞉ halima꞉ mo hapiki kenke pa꞉ta꞉ hata꞉ pi taka꞉lake lo hala꞉me. Ipikana꞉ma꞉ alota꞉ Mo Tekehalina꞉ pota꞉ pilaowapa꞉peke. Ipiki epeke alena꞉ yapena꞉ ipika꞉ pota꞉ wopu tikitiki yawapa꞉peke ala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Dioni ipika꞉ yameeke dauta꞉ mo kemolo itikima꞉ wepiki dau yameekeme. Ipika꞉ hakota꞉ kao yonkeleke wepiki hako yameekeme. Ipika꞉ ne manuta꞉ odouwamanu make mo pole pukini hapeke hanimanu make no hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mo Diutuseleme da wanda꞉hali make Diudia kenke wanda꞉hali make mo Diodani ikali tea꞉na꞉ pelia peeke wanda꞉hali make ota꞉ paeyao ipiki pa꞉ta꞉ tayaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kutupata꞉ mo wanda꞉halima꞉ ika꞉ hoke haumanu ka꞉la꞉polo liaena꞉ ikita꞉ Dionima꞉ mo Diodani ikali pa꞉ta꞉ bapitaisi peayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mo hande Pa꞉tisi tapake make Sa꞉dusi tapake make koto tapake yaapona꞉ haliweki wopu Dionima꞉ bapitaisi peaena꞉ epemekeeki handaa ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Ketoma꞉ handeke some hombo iki pa꞉ta꞉ mo Koda꞉ma꞉ a̱i̱ taapolo pa꞉la꞉ panisi tieke wendia꞉pekee pita꞉ epima꞉ lakia꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mo ika꞉ hoke haumanu hoki walaa ota꞉ mina꞉pa꞉laaseme hau peneme yaasa꞉ ekimanu homeke pu hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Eipoloha꞉ma꞉ta꞉ nika꞉ meie lomeka꞉na꞉ta꞉ mo Koda꞉ma꞉ kulu pa꞉la꞉ hoke yenkita꞉ wendulumekee hone na wia꞉pa꞉peke. Lono opie. Koda꞉ma꞉ta꞉ do ula꞉ toopimanu mea Eipoloha꞉ma꞉na꞉ wekiwandiki au lapeke ya꞉la꞉me alome. ");
INSERT INTO ssx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mo timanu ika꞉ teke yoka꞉ poka꞉ bepe peaapeke teita꞉ do tikitiki yao ula꞉ handa꞉e. Ti homeke homekema꞉ ipika꞉ epeke kiliki na eiyo haya꞉ka꞉na꞉ta꞉ kota꞉ pokaa tina꞉ yankilieke. ");
INSERT INTO ssx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","I̱ma꞉ta꞉ ika꞉ hoke haumanu mina꞉pa꞉laemekeeki peneme yaaluekema꞉ ikalima꞉ bapitaisi peaowalopate mo ya hoki nane ipilia꞉ halima꞉ta꞉ mo Holi Sipitidi pita꞉ ti tala꞉eki yaapoma꞉ iki bapitaisi pealieke. Mo someta꞉ I̱ ota꞉ lombeipiki some halekena꞉ ipika꞉ anke dake kone I̱ma꞉ mea tiaapeke ana꞉ na pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ipikana꞉ma꞉ mo hande widi kilikina꞉ ambuku napeke yaapo putupa alu puluekema꞉ pana꞉pulu pa꞉la꞉ sa꞉sata꞉ ipika꞉ kikina꞉ miniki hala꞉me. Ipika꞉ widi kiliki epekeeki paeyaota꞉ ipika꞉ widi napeke u hala꞉ da pa꞉ta꞉ momba꞉la wilieke. Pate mo ambuku paeyaota꞉ tina꞉ pana꞉pu yankilieke. Koto tita꞉ na paeyeke pa to halieke. Koto pi manuta꞉ Dionima꞉ iki pa꞉ta꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Koto pita꞉ma꞉ta꞉ Yesu mo Ka꞉lili kenke mina꞉pa꞉lao Dionima꞉ ipiki bapitaisi peaena꞉ mo Diodani ikali pa꞉ta꞉ epeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kutu piekepate Yesuna꞉ hone topo pina꞉yeke Dionima꞉ ipiki pa꞉ta꞉ dupa leekeme. Nakana꞉ma꞉ I̱ bapitaisi peapekealeo. Pa neketa꞉ I̱ma꞉ bapitaisi peano I̱ pa꞉ta꞉ epeka꞉ta꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Koto leekepate Yesuma꞉ ipika꞉ pi hombo peaaso hata꞉ alota꞉ Pina꞉ma꞉ hone ma꞉nda꞉ na wiki. Do pulu polopa꞉ hauta꞉ Koda꞉na꞉ hone pa꞉la꞉ hauna꞉ pitolo pitolopa꞉me. Koto leekeeki Dionima꞉ opuaata꞉ A꞉pa꞉la꞉me bapitaisi peanoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu bapitaisi peao paeyeketa꞉ koto kone mo ikali mina꞉pa꞉lao tea꞉ nane yapeekeme. Kutu pitolo haena꞉ta꞉ koto kone oli ya akolopa wiaata꞉ mo hande Koda꞉na꞉ Sipitidi melipu tupa꞉ hola꞉pa꞉niao ipika꞉ loke manda tapepeekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kutaa oli ya nanema꞉ pi ho̱la̱꞉make homekema꞉ pi alo alota꞉ Dota꞉ ya pukipiki wekie. I̱ma꞉ ipiki pa꞉ta꞉ ta꞉na꞉ma꞉ wopu homolome laa pi la꞉niaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Koto pieke hoki naneta꞉ Sadanima꞉ Yesu la handena꞉ Koda꞉na꞉ Sipitidima꞉ Yesu mo hapu hayeke ale ma꞉nda꞉ pa꞉ta꞉ hatuku peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Koto pa꞉ta꞉ hata꞉ta꞉ Yesuma꞉ hali tieke yaapo natena꞉ timba꞉ nate yaapona꞉ ne ma꞉nda꞉ na neke hayeke ekima꞉ tea꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Koto tea꞉ma꞉ homolo haena꞉ta꞉ Sadanima꞉ ipiki pa꞉ta꞉ a꞉pa alota꞉ Neketa꞉ ota꞉ Koda꞉na꞉ Eiyeke ya꞉ka꞉na꞉ta꞉ kota꞉ do toopimanu kone palaowa au lapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Koto leekepate Yesuma꞉ hombo peaaso alota꞉ Mo Baiboloma꞉ta꞉ Halima꞉ palaowa homeke naa na hapeke ya꞉la꞉pate Koda꞉na꞉ pi paeyao miniki halie ekima꞉ homeke epeke tupa꞉ halieke la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kutaata꞉ Sadanima꞉ Yesu mo yako piki daoni Diutuseleme nane hatuku peekeme. Ipikana꞉ma꞉ Yesuta꞉ mo tembolo da holu manda mea hao hata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ipiki pa꞉ta꞉ alota꞉ Neketa꞉ Koda꞉na꞉ Eiyeke ya꞉ka꞉na꞉ta꞉ kota꞉ do pa꞉ta꞉ hao oni kenkena꞉ naka꞉ kone lopa꞉niae. Pa ekipeke. Mo Baiboloma꞉ alota꞉ Mo enisolo tonuma꞉ neke handeteke haena꞉ Koda꞉ma꞉ iki pa꞉ta꞉ pi lelieke. Kutu pia꞉ka꞉na꞉ta꞉ mo toopi manuma꞉ naka꞉ anke naapa꞉na꞉ta꞉ mo enisolotonu ika꞉ kikima꞉ neke miniliao handeteke halimikie la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Koto leeke Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Ota꞉ alepate mo Baiboloma꞉ pi ma꞉nda꞉ta꞉ dupa la꞉la꞉me. Mo Tekehali naka꞉ Koda꞉ta꞉ la handa꞉la꞉eki na pia꞉peke la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Koto leeketa꞉ mo Sadanima꞉ Yesu pa hatuku pote tieke ma꞉nda꞉ manda hatuku puaata꞉ koto pa꞉ta꞉ hata꞉ta꞉ mo kenke paeyaona꞉ ta꞉ta꞉ ta꞉ta꞉ piki kilu tombuao hala꞉eki make ika꞉ ta꞉ta꞉ ta꞉ta꞉ piki au epeke epeke make waleekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nakana꞉ma꞉ I̱ pa꞉ta꞉ tumiki yotuao panda꞉puniao pita꞉ yeni pika꞉na꞉ta꞉ kota꞉ koto handele ale paeyaota꞉ I̱ma꞉ neke pa꞉ta꞉ kulueke Sadanima꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Koto leeke Yesuma꞉ hombo peaaso alota꞉ Sadani neke puma. Mo Baiboloma꞉ alota꞉ Koda꞉ pa꞉ta꞉ homeke panda꞉puniao yeiya꞉ laaso hata꞉ ipika꞉ kakena꞉ homeke homo hapa꞉peke la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Koto pi leeketa꞉ mo Sadanima꞉ Yesu mina꞉pa꞉lao pulu haena꞉ta꞉ enisolo tonuma꞉ ipiki tamba꞉ muluekema꞉ epemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dioni dipula mea pitaeyekeeki opuaata꞉ Yesuma꞉ koto pa꞉ta꞉ mina꞉pa꞉lao Ka꞉lili nane peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ipikana꞉ma꞉ Na꞉sa꞉tete da na hao hake mo ikali leke Ka꞉lili tea꞉ nane hayeke da homeke bikita꞉ Kapeneami halo peekeme. Koto data꞉ mo Sebuloni kenke pita꞉ Na꞉petali kenke yaapo pa꞉ta꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kutu pieke ekima꞉ta꞉ mo hande potopede hali Aisayama꞉ amba꞉ la꞉ wiekeeki yaaluekema꞉ piekeme. Koto la꞉ wieke pita꞉ dupa ");
INSERT INTO ssx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Mo Diodani ikali mone tea꞉na꞉ mo ikali leke pa꞉ta꞉ opolo pula꞉ pota꞉ ula꞉ Sebuloni kenkeo o Na꞉petali kenkeo mo Diendaili wanda꞉halina꞉ kenke Ka꞉lilio ");
INSERT INTO ssx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","mo timba꞉ leke pa꞉ta꞉ hao haleme wanda꞉hali paeyaoma꞉ pa̱a̱ tieke handilimikie. Mo homo hala꞉ timba꞉ leke kenke pa꞉ta꞉ haleme wanda꞉hali iki pa꞉ta꞉ mo pa̱a̱ma꞉ pa̱a̱ peaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Koto tomona꞉ta꞉ Yesuma꞉ ipika꞉ pi walolota꞉ dupa Koda꞉na꞉ Kilu Tombuao Hala꞉ ekita꞉ teke pa꞉ta꞉ ya꞉la꞉ma꞉ ika꞉ hoke haumanu hoki walaa la꞉ka꞉la꞉pa꞉peke lo hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesuma꞉ mo hande Ka꞉lili ikali leke houna꞉ pulu hata꞉ta꞉ ta꞉peli mu haepeke hama̱la̱꞉ yaapo Saimono biki ma꞉nda꞉ta꞉ Pida make hameke A꞉ndutu yaapoma꞉ mo hande ikali leke pa꞉ta꞉ tenki nuna꞉ ta꞉peli minolo haepekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesuma꞉ ipiliki pa꞉ta꞉ alota꞉ Ipilikana꞉ma꞉ta꞉ wanda꞉hali mu hapena꞉ I̱ma꞉ wala꞉tialuekema꞉ ya hoki nane teli mea ipupe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Koto leeketa꞉ koto kone ipilika꞉ tenki numanu mina꞉pa꞉lao ipiki teli mea pepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mo pate leke pulu hata꞉ hama̱la̱꞉ ma꞉nda꞉ Dia꞉mesi Dioni yaapo handeekeme. Ipilika꞉ apa꞉ta꞉ Sepedie. Ipilikita꞉ ipilika꞉ apa꞉ ame̱le̱ kawaso manda pita꞉ ika꞉ tenki numanu epeaaso pitimikime. Kutu polo pitina꞉ta꞉ Yesuma꞉ ipiliki wi leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kutu pieketa꞉ koto kone ipilika꞉ apa꞉ make mo kawaso make mina꞉pa꞉lao Yesu teli mea pepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuma꞉ mo Ka꞉lili kenke paeyao pa꞉ta꞉ pominolo hata꞉ ika꞉ pi hotu haemeke damanu pa꞉ta꞉ pi waleekeme. Ipikana꞉ma꞉ mo Koda꞉na꞉ Kilu Tombuao Hala꞉ ekina꞉ Pi Seliapomanu walolo hata꞉ mo wanda꞉halina꞉ ta꞉ta꞉ ta꞉ta꞉ piki yeni ki paeyao wamo peayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Koto ipika꞉ pieke hau manuna꞉ta꞉ Sitia kenke paeyao pa꞉ta꞉ kende tupa꞉ wiekeme. Koto pi opuaata꞉ wanda꞉halima꞉ yeni ta꞉ta꞉ ta꞉ta꞉ hake tanda mu haemeke wanda꞉hali make hoke temokomanu pitu make lu keaaso hata꞉ lopo haemeke wanda꞉hali make kiki anke lupa wiki wanda꞉hali make ota꞉ paeyao ipiki pa꞉ta꞉ mea epemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wanda꞉hali wopu Yesu pa꞉ta꞉ teli mea pemekeme. Koto wanda꞉halita꞉ Ka꞉lili kenke nanema꞉ wanda꞉hali make Diudia kenke nanema꞉ wanda꞉hali make mo Diodani mone tea꞉ nanema꞉ wanda꞉hali make iki paeyaoma꞉ ipiki teli mea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesuma꞉ mo mombelemeke wanda꞉hali handaata꞉ oli peiyene a꞉meiya pua pitiekeme. Kutu pina꞉ ipika꞉ hoki nane tolu haemeke haliweki a꞉pa ipiki hopa꞉liao haemeketa꞉ ");
INSERT INTO ssx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ipikana꞉ma꞉ iki pa꞉ta꞉ pi kini pu mea walolo alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Mandane wanda꞉hali epi ikana꞉ma꞉ ika꞉ pukima꞉ Ya temoko teketa꞉ natehali halome hone u haemeka꞉na꞉ta꞉ kota꞉ koto wanda꞉halita꞉ ta꞉na꞉ma꞉ homo halememe. Mo hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ ika꞉ ekie. ");
INSERT INTO ssx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mo e̱ tapu tapu hata꞉ pukima꞉ homo haleme wanda꞉halima꞉ta꞉ ta꞉na꞉ma꞉ homo halememe. Ika꞉ pukita꞉ Koda꞉ma꞉ epeaalieke. ");
INSERT INTO ssx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Homu pea hao haleme wanda꞉halima꞉ta꞉ ta꞉na꞉ma꞉ homo halememe. Koda꞉ma꞉ pi la꞉ ula꞉ ekita꞉ ikana꞉ma꞉ milimikie. ");
INSERT INTO ssx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Koda꞉na꞉ hone pa꞉la꞉eki puluekema꞉ na꞉na꞉ na꞉na꞉ma꞉ homa pu haleme wanda꞉halima꞉ta꞉ ta꞉na꞉ma꞉ homo halememe. Iki pa꞉ta꞉ Koda꞉ma꞉ ota꞉ ana꞉na꞉ ana꞉ lawaalieke. ");
INSERT INTO ssx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mandane wanda꞉hali pa꞉ta꞉ a꞉ta꞉ma꞉ homo haleme wanda꞉halima꞉ta꞉ ta꞉na꞉ma꞉ homo halememe. Koda꞉ma꞉ iki pa꞉ta꞉ make a꞉ta꞉ma꞉ homilieke. ");
INSERT INTO ssx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ika꞉ puki pa꞉ta꞉ ala꞉ta꞉ ma꞉nda꞉ na talena꞉ leke wamo pea haleme wanda꞉halima꞉ta꞉ ta꞉na꞉ma꞉ homo halememe. Koto wanda꞉halima꞉ta꞉ Koda꞉ handilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","A꞉nda꞉ ape kakeneli homao hala꞉ wanda꞉halima꞉ta꞉ ta꞉na꞉ma꞉ homo halememe. Koto wanda꞉halita꞉ Koda꞉ma꞉ Ya wekiwandikie lelieke. ");
INSERT INTO ssx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ika꞉ Koda꞉na꞉ hone pa꞉la꞉eki peaaseme ekina꞉ kone mandane wanda꞉halima꞉ iki pa꞉ta꞉ tandamanu halemeka꞉na꞉ta꞉ kota꞉ ikana꞉ma꞉ta꞉ ta꞉na꞉ma꞉ homo halememe. Mo hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ ika꞉ ekie. ");
INSERT INTO ssx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ikita꞉ ya hoki nane tolu haleme ekina꞉ mandane wanda꞉hali ika꞉ pima꞉ iki yaala꞉ma꞉ homao make iki pa꞉ta꞉ tanda ku make ika꞉ biki hoeyaaluekema꞉ hoke ba꞉sa꞉ pitolo yayapiki pimanu sa꞉mba꞉lao pitolo haena꞉ kone kota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","pa pina꞉ma꞉ ikana꞉ma꞉ta꞉ pa epeke puki haaso hata꞉ ta꞉na꞉ma꞉ homo hapa꞉peke. Pa ekipeke. Ika꞉ mulu peleme yenki tieketa꞉ oli hepeni nane wiawala꞉me. Do iki pa꞉ta꞉ kita꞉la꞉ tanda tupa꞉ kone mo hande amba꞉ haemeke potopede haliweki pa꞉ta꞉ make tanda halo haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ikita꞉ do kenke wanda꞉halina꞉ epi halememe. Koto pelemepate mo epina꞉ tende pa꞉la꞉eki a꞉nda꞉ alu pia꞉ka꞉na꞉ta꞉ kota꞉ ikana꞉ma꞉ mo epina꞉ tende paa peaapeke na ya꞉la꞉me. Mo tende alu pa꞉la꞉ epita꞉ pa alema꞉ handa꞉la꞉me. Kutu pia꞉ka꞉na꞉ta꞉ bao wanda꞉hali ankema꞉ tumba tumba pea pomu halimikie. ");
INSERT INTO ssx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ikita꞉ do kenke wanda꞉halina꞉ pa̱a̱ halememe. Mo peiyene elinina꞉ hala꞉ daonita꞉ a꞉mbao hapeke na ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ma꞉nda꞉ma꞉ ipika꞉ ola꞉pake ka꞉wata꞉ mo disi kawaso tiekema꞉ a꞉mbao na wilieke. Kotoeki na pikita꞉ mo da pa꞉ta꞉ pila꞉ wanda꞉hali paeyao pa꞉ta꞉ pa̱a̱ peaena꞉ mo teipolo manda wilieke. ");
INSERT INTO ssx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Koto tupa꞉ kone wanda꞉halima꞉ ika꞉ epeke haumanu handolo hata꞉ ika꞉ hepeni hala꞉ Apa꞉ pa꞉ta꞉ yeiya꞉ lawaena꞉ma꞉ paeyaoma꞉ handena꞉ ika꞉ pa̱a̱ peapeke haumanu pu hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mo hande Mosesina꞉ Pi Ula꞉ ekimanu make o Potopede haliwekima꞉ walemeke pimanu make paeyaluekema꞉ a꞉pa꞉la꞉me hone na wia꞉pa꞉peke. Koto ika꞉ walemeke mana꞉ pimanu paeyaaluekema꞉ dia꞉ ya꞉pate pa yawaluekema꞉ epolome. ");
INSERT INTO ssx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ota꞉ pi alome. Oli hepeni do kenke yaapo a̱i̱ na paeke pa ula꞉ tomona꞉ta꞉ mo Mosesima꞉ la꞉ wieke pi ula꞉eki wape pea ula꞉ pi homeke siki make o tombo hodikali siki make ma꞉nda꞉ amba꞉la ota꞉ na alu pilieke. Kotoeki na pikita꞉ do kenke ya yaapo paelia꞉ natena꞉ mandake paeyaena꞉ pa wilieke. ");
INSERT INTO ssx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kutu piliepate pa hali homeke ma꞉nda꞉ma꞉ mo Lo Pi Ula꞉ ekina꞉ hosiki pi siki kone yoka꞉ mea bao make o mandane wanda꞉halima꞉ make kutu pina꞉ wala꞉ tiaeya꞉ka꞉na꞉ta꞉ kota꞉ ipika꞉ bikita꞉ oli hepenina꞉ Kilu Tombuao Hala꞉eki pa꞉ta꞉ta꞉ ota꞉ hosiki siki ya꞉lieke. Pate pa hali homeke ma꞉nda꞉ma꞉ mo Lo Pi Ula꞉eki miniki hata꞉ mandane wanda꞉halima꞉ make kutu pina꞉ wala꞉ tiaeya꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ oli hepenina꞉ Kilu Tombuao Hala꞉ ekina꞉ biki tieke milieke. ");
INSERT INTO ssx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Ika꞉ hauna꞉ tikitiki pa꞉la꞉ ekima꞉ta꞉ mo hande Pa꞉tisi haliwekina꞉ hau pita꞉ mo Lo Pi Ula꞉eki wala꞉la꞉ haliwekina꞉eki make ota꞉ lombei na pia꞉ka꞉na꞉ta꞉ kota꞉ ikita꞉ mo hepenina꞉ Kilu Tombuao Hala꞉eki pa꞉ta꞉ ota꞉ pua꞉peke na yelimikie. ");
INSERT INTO ssx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Amba꞉ hande ika꞉ mei tonu pa꞉ta꞉ la haleeke yeke opu haleme pita꞉ dupa. Hali ma꞉nda꞉ ota꞉ na lu homaapeke. Lu homaekena꞉ta꞉ kota꞉ neketa꞉ pi yokaaluna꞉ mea halieke leekepate ");
INSERT INTO ssx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pa ameta꞉ I̱ma꞉ iki pa꞉ta꞉ alota꞉ Epima꞉ ipika꞉ yankeke pa꞉ta꞉ mineke pankea꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ pi yokaaluna꞉ mea haena꞉ lelieke. Kutupa hali ma꞉nda꞉ epima꞉ ipika꞉ yankeke pa꞉ta꞉ alota꞉ Neketa꞉ I̱ma꞉ dopi taapeke ekie lea꞉ka꞉na꞉ta꞉ kota꞉ koto someta꞉ Ka̱le̱sete tieke pa꞉ta꞉ mea haena꞉ lelieke. Kutaa make ma꞉nda꞉ epima꞉ ipika꞉ yankeke pa꞉ta꞉ alota꞉ Neketa꞉ you hoke hone wopu na wiki someo lea꞉ka꞉na꞉ta꞉ kota꞉ koto someta꞉ ti to hala꞉ pa꞉ta꞉ pua꞉peke ya꞉la꞉eki teke pa꞉ta꞉ hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Koto ekina꞉ta꞉ nakana꞉ma꞉ naka꞉ pa hameke hala꞉pekeeki Koda꞉na꞉ oloda pa꞉ta꞉ mea ipulu hata꞉ naka꞉ honema꞉ Ya kamema꞉ta꞉ I̱ pa꞉ta꞉ ka꞉nda꞉ piki pi ma꞉nda꞉ ala꞉me hone wika꞉na꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kota꞉ naka꞉ mo pa hameke hala꞉pekeeki koto pa꞉ta꞉ kone mina꞉pa꞉laota꞉ koto kone a̱i̱ la꞉ka꞉la pua naka꞉ kame yaapo a꞉nda꞉ pelia꞉pa꞉peke. Kutupa paeya꞉ka꞉na꞉ta꞉ la꞉ka꞉la a꞉pa mo naka꞉ pa hameke hala꞉pekeeki Koda꞉ pa꞉ta꞉ hala꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Hali ma꞉nda꞉ma꞉ neke yaapo pi yokaalu puluekema꞉ hatuku pea꞉ka꞉na꞉ta꞉ kota꞉ koto pota꞉na꞉ pulu hata꞉ kone ipiki yaapo koto kone tikitiki yao epeapa꞉peke. Kotoeki na pika꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ neketa꞉ mo pi yokaalu pita꞉la꞉ ekina꞉ you hali pa꞉ta꞉ halieke. Kutaa mo you halima꞉ta꞉ mo polisi haliweki pa꞉ta꞉ neke halieke. Kutu pia꞉ka꞉na꞉ta꞉ mo polisi haliwekima꞉ neke dipula mea pitalieke. ");
INSERT INTO ssx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Koto pa꞉ta꞉ta꞉ naka꞉ pu hauna꞉ yenki paeyao ota꞉ a̱i̱ na haleka꞉na꞉ta꞉ pa pitu halipikie. ");
INSERT INTO ssx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Amba꞉ la꞉ wimiki pi opu haleme pita꞉ dupa. Tooli ka꞉taasa꞉ hau na pea꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pate ame I̱ma꞉ iki pa꞉ta꞉ la kitolo ekita꞉ dupa. Hali epima꞉ wanda꞉ homeke ma꞉nda꞉ handolo ipika꞉ta꞉ ya meawee la honema꞉ we pambea꞉ka꞉na꞉ta꞉ kota꞉ koto some ipika꞉ honema꞉ta꞉ mo wanda꞉ hakopu amba꞉ tunkulula꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Koto ekina꞉ta꞉ naka꞉ popeke nane lekema꞉ neke hoke hau puelena꞉ yeke neke yolea꞉ka꞉na꞉ta꞉ kota꞉ koto leke yokaa baapeke. Pa ekipeke. Naka꞉ loke tieke tonka꞉na꞉ ti to hala꞉ alena꞉ puaama꞉na꞉ mo naka꞉ lokesiki homeke ma꞉nda꞉ alupao haeka꞉na꞉ta꞉ ota꞉ epilieke. ");
INSERT INTO ssx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kutaa make naka꞉ popeke kikima꞉ neke hoke hau puelena꞉ lea꞉ka꞉na꞉ kota꞉ koto kikita꞉ tunkulu baapeke. Pa ekipeke. Naka꞉ loke tieke tonka꞉na꞉ ti to hala꞉ alena꞉ puaama꞉na꞉ naka꞉ paleke homeke alupao haeka꞉na꞉ta꞉ ota꞉ epilieke. ");
INSERT INTO ssx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mo amba꞉ pi wieke ma꞉nda꞉ma꞉ make leeke pita꞉ dupa. Hali ma꞉nda꞉ epima꞉ ipika꞉ wanda꞉ kiao ota꞉ baalueke hone wia꞉ka꞉na꞉ta꞉ kota꞉ mo wanda꞉ pa꞉ta꞉ Neketa꞉ ota꞉ baasome pi wape pa꞉la꞉ wape miniki haena꞉ hala꞉peke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pate ame I̱ma꞉ iki pa꞉ta꞉ la kitolo ekita꞉ dupa. Hali homeke ma꞉nda꞉ma꞉ a꞉nda꞉ ipika꞉ wanda꞉ta꞉ hali na yolo halia꞉pate pa hameke kone kiaeya꞉ka꞉na꞉ta꞉ kota꞉ koto wanda꞉ma꞉ wetepe hali ma꞉nda꞉na꞉ da pea꞉ka꞉na꞉ta꞉ kota꞉ mo kiao baeya꞉ halima꞉ta꞉ mo wanda꞉ma꞉ hali yola꞉la꞉ hau pina꞉ la꞉la꞉ hali hala꞉me. Kutaa mo koto wanda꞉ mina꞉la꞉ hali make yola꞉la꞉ hau kone pita꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Amba꞉ hande ika꞉ meitonu pa꞉ta꞉ la haleeke yeke opu haleme pi ma꞉nda꞉ make dupa. Naka꞉ la꞉ wili pi na yambeleketa꞉ mo Tekehali pa꞉ta꞉ hali keke witolo la꞉ wilieki paeyao ota꞉ pea꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pate ame I̱ma꞉ iki pa꞉ta꞉ la kitolo ekita꞉ dupa. Ikana꞉ma꞉ la꞉ wita꞉la꞉ pi la꞉ wimika꞉na꞉ta꞉ kota꞉ mo hali keke witolo pimanu apa꞉tao na la꞉ wia꞉pa꞉peke. Kutupa mo Hepenina꞉ biki laa hali keke wita꞉la꞉ pi na lapa꞉peke. Pa ekipeke. Hepenita꞉ Koda꞉na꞉ pitu hala꞉ ale yeleke loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Do kekena꞉ biki lo make na lapa꞉peke. Pa ekipeke. Do kenketa꞉ Koda꞉na꞉ anke ula꞉ ale yeleke loa꞉me. Mo hande Diutuseleme lo make na lapa꞉peke. Pa ekipeke. Mo data꞉ mo Kini tiekena꞉ daoni yeleke loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ika꞉ you lo kone ota꞉ na lapa꞉peke. Pa ekipeke. Ikana꞉ma꞉ ika꞉ itiki homeke siki kone topo pea hake o punu na peapeke ya꞉la꞉ ekina꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ikana꞉ma꞉ta꞉ pa Aowe o Dia꞉me homeke lapa꞉peke. Mandane pi apa꞉taemeka꞉na꞉ta꞉ kota꞉ kotota꞉ hoke Sadanima꞉ wala꞉la꞉ pie. ");
INSERT INTO ssx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Amba꞉ la꞉ wimiki pi opu haleme pita꞉ dupa. Leke hoeyaeya꞉ka꞉na꞉ta꞉ paa leke hoeyapa꞉peke. Kake hoeyaeya꞉ka꞉na꞉ta꞉ paa kake hoeyapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pate ame I̱ma꞉ iki pa꞉ta꞉ la kitolo ekita꞉ dupa. Ma꞉nda꞉ma꞉ neke tekipuleke laeya꞉ka꞉na꞉ta꞉ nakana꞉ma꞉ hombo na peapeke. Hali ma꞉nda꞉ma꞉ naka꞉ popeke nanema꞉ pakena꞉ dakapoma꞉ lia꞉ka꞉na꞉ta꞉ kota꞉ mo hoe nane pakena꞉ make lina꞉ la꞉ka꞉lapeke. ");
INSERT INTO ssx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hali ma꞉nda꞉ma꞉ naka꞉ sedi muluekema꞉ neke pi yokaaluna꞉ mea haena꞉ lea꞉ka꞉na꞉ta꞉ kota꞉ naka꞉ kosa꞉ aka꞉ make mina꞉ hala꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Handeteke hala꞉ hali tieke homeke ma꞉nda꞉ma꞉ hakoto mea tia polena꞉e alo hata꞉ pota꞉ tombo dupana꞉ tia pua꞉peke lea꞉ka꞉na꞉ta꞉ nakana꞉ma꞉ta꞉ kotoeki haka꞉ta꞉pao tia pua꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma꞉nda꞉ma꞉ neke pa꞉ta꞉ ala꞉ta꞉ ma꞉nda꞉ honke lea꞉ka꞉na꞉ta꞉ hala꞉peke. Kutupa make naka꞉ ala꞉ta꞉ ma꞉nda꞉ ta꞉ka꞉li kie lea꞉ka꞉na꞉ta꞉ kota꞉ pa ta꞉ka꞉li hala꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Amba꞉ la꞉ wimiki pi opu haleme pita꞉ dupa. Tapake pa꞉ta꞉ pukima꞉ homolota꞉ tunkuliki halita꞉ honditi pia꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pate ame I̱ma꞉ iki pa꞉ta꞉ la kitolo ekita꞉ dupa. Ika꞉ a꞉nda꞉ tunkuliki haliweki pa꞉ta꞉ pukima꞉ homo make mo iki tanda kiteme wanda꞉hali epeaena꞉ Koda꞉ pa꞉ta꞉ yeni peao hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kutu pimika꞉na꞉ta꞉ kota꞉ ikita꞉ ika꞉ hepeni hala꞉ Apa꞉na꞉ eiyeke tonu halimikie. Pa ekipeke. Ipikana꞉ma꞉ ipika꞉ natena꞉ pa̱a̱ta꞉ mo hoke wanda꞉hali epeke wanda꞉hali paeyao pa꞉ta꞉ mandake piki nate pa̱a̱ kone peaasa꞉me. Koto tupa꞉ kone mo epeke hau pu haleme wanda꞉hali hoke hau pu haleme wanda꞉hali pa꞉ta꞉ ipikana꞉ma꞉ lako iki paeyao mandake tupa꞉ kone ana꞉na꞉ halo hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ikana꞉ma꞉ mo iki pa꞉ta꞉ pukima꞉ homeleme wanda꞉hali homeke pa꞉ta꞉ a꞉nda꞉ pukima꞉ homemeka꞉na꞉ta꞉ pa ekipeke Koda꞉ma꞉ iki pa꞉ta꞉ epeke yenki kina꞉pe. Mo hande dakisi mu hala꞉ haliwekima꞉ kone kutu piki hau pu halememe. ");
INSERT INTO ssx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ika꞉ ta꞉ma꞉ni pa꞉ta꞉manu homeke mo ta꞉na꞉ma꞉ homa꞉la꞉ pimanu lo haemeka꞉na꞉ta꞉ kota꞉ ikana꞉ma꞉ kotota꞉ ota꞉ hau pitoloma꞉me laa hone witelemepe. Dia꞉me. Mo pi na miki wanda꞉halima꞉ make ika꞉ ika꞉ kone kutu piki hau pu halememe. ");
INSERT INTO ssx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ikana꞉ma꞉ ika꞉ hepeni hala꞉ Apa꞉ta꞉ ota꞉ tondepe wopu pea hala꞉ tupa꞉ iki make tondepe pea hao hapa꞉peke ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Koda꞉na꞉ pi miniki haleme wanda꞉halima꞉ ika꞉ tamba꞉ mina꞉la꞉ haumanu pea꞉pekeeki wanda꞉halima꞉ handena꞉ handaena꞉ tupa꞉ puluekema꞉ hone ota꞉ na wiki yopu kone pea꞉pa꞉peke. Pa ekipeke. Wanda꞉halima꞉ handena꞉yeke handaena꞉ hau pimika꞉na꞉ta꞉ kota꞉ mo naka꞉ hepeni hala꞉ Apa꞉ma꞉ kia꞉ka꞉na꞉ mulu peleme epeke yenkita꞉ homeke siki a꞉nda꞉ make ota꞉ na milimikie. ");
INSERT INTO ssx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Koto ekina꞉ta꞉ mo hande natehali wanda꞉hali tamba꞉ muluekema꞉ ala꞉ta꞉ ma꞉nda꞉ halemeka꞉na꞉ta꞉ kota꞉ wala꞉ wala꞉ pea na hala꞉pa꞉peke. Mo hande yayapiki hau pu haleme haliwekima꞉ oni hande pota꞉ hopiki nina꞉ make yeni da pa꞉ta꞉manu make kutu piki wala꞉ wala꞉ piki haumanu pu halememe. Koto hau pimiki ekita꞉ mo wanda꞉halima꞉ ika꞉ biki daeyaena꞉ yeke pu halememe. I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Koto tapakema꞉ ika꞉ pimi hauna꞉ yenki manuta꞉ ame do hata꞉ mu paeyaasememe. ");
INSERT INTO ssx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mo natehali wanda꞉hali tamba꞉ mimika꞉na꞉ta꞉ kota꞉ mo ika꞉ ota꞉ teke pa꞉ta꞉ eki sikima꞉ kone ota꞉ na handena꞉ leke hala꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kutu pimika꞉na꞉ta꞉ ika꞉ mone honema꞉ a꞉mbao hata꞉ hala꞉pa꞉peke alee. Kutaa make mo ika꞉ mone honema꞉ piteme hau handa꞉la꞉ Apa꞉ma꞉ta꞉ ika꞉ epeke yenki kilieke. ");
INSERT INTO ssx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yeni pimika꞉na꞉ta꞉ mo hande yayapiki hau pu haleme haliwekina꞉ hau na honda꞉pa꞉peke. Wanda꞉halima꞉ iki handena꞉ hone hone witolo hata꞉ mandane pota꞉ hopiki nina꞉ make yeni da pa꞉ta꞉manu make tialiao hata꞉ Koda꞉ pa꞉ta꞉ yeni pu halememe. I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Ikana꞉ma꞉ ika꞉ pimi hauna꞉ yenki manuta꞉ ame do hata꞉ mu paeyaasememe. ");
INSERT INTO ssx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ikana꞉ma꞉ yeni pimika꞉na꞉ta꞉ kota꞉ ika꞉ da panda꞉ pa꞉ta꞉ pota꞉ poka꞉neao pua pita꞉ ika꞉ lekema꞉ handa꞉peke na yeke Apa꞉ pa꞉ta꞉ yeni pea꞉pa꞉peke. Kutu pimika꞉na꞉ta꞉ kota꞉ mo ika꞉ mone honema꞉ piteme hau handa꞉la꞉ Apa꞉ma꞉ta꞉ ika꞉ epeke yenki kilieke. ");
INSERT INTO ssx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ikana꞉ma꞉ yeni a꞉nda꞉ pimika꞉na꞉ta꞉ kota꞉ mo hande yayapiki koda꞉manu pa꞉ta꞉ yeni pu haleme wanda꞉halima꞉ napeke na pitiki pi eleke eleke wopu lo haleme tupa꞉ yeni na pea꞉pa꞉peke. Ika꞉ honema꞉ta꞉ nika꞉ yeni hokulu peaoma꞉ka꞉na꞉ta꞉ kota꞉ Koda꞉ma꞉ opilieke hone witelememe. ");
INSERT INTO ssx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ikita꞉ koto wanda꞉hali leke na hapa꞉peke. Ika꞉ hone pa꞉la꞉eki manuta꞉ ikana꞉ma꞉ honke a̱i̱ na leke hamena꞉ kone ika꞉ Apa꞉ma꞉ amba꞉ handa hone ula꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yeni pimika꞉na꞉ta꞉ kota꞉ do tupa꞉ pea꞉pa꞉peke. Nika꞉ hepeni hala꞉ Apa꞉o. Naka꞉ yako piki bikita꞉ ota꞉ manda wia haena꞉e. ");
INSERT INTO ssx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Naka꞉ Kilu Tombuao Haleeki do ane opolo epena꞉e. Naka꞉ hone pa꞉la꞉eki oli hepeni nane peao haleme tupa꞉ do kenkena꞉ make peawaenae. ");
INSERT INTO ssx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Do ame nolo poloma꞉ ne ana꞉na꞉ kia꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mandane wanda꞉halima꞉ niki pa꞉ta꞉ hoke hau pimi ekimanu nikana꞉ma꞉ pa paeyaaso hamono nika꞉ hoke hau puma꞉ ekimanu make nakana꞉ma꞉ koto tupa꞉ pa paeyawapeke. ");
INSERT INTO ssx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ka꞉nda꞉piki ekima꞉ niki na la handa꞉peke. Kotoeki na pikita꞉ hoke Sadanima꞉ niki hoeyaama꞉na꞉ma꞉ nakana꞉ma꞉ niki epeke tupa꞉ handeteke hapeke laa yeni pea꞉pa꞉peke ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kutupa ikana꞉ma꞉ mo iki pa꞉ta꞉ hoke hau pimiki wanda꞉hali ika꞉ hoke haumanu pa paeyaemeka꞉na꞉ta꞉ kota꞉ ika꞉ hepeni hala꞉ Apa꞉ma꞉ ika꞉ pimi hoke haumanu make pa paeyawalieke. ");
INSERT INTO ssx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pate ikana꞉ma꞉ mo iki pa꞉ta꞉ hoke hau pimiki wanda꞉hali ika꞉ hoke hau pa na paeyaemeka꞉na꞉ta꞉ kota꞉ ika꞉ Apa꞉ma꞉ make mo ika꞉ pimi hoke haumanu tonka꞉na꞉ pa na paeyawalieke. ");
INSERT INTO ssx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ikana꞉ma꞉ nee pi a꞉nda꞉ wimika꞉na꞉ta꞉ kota꞉ mo ika꞉ puki pa꞉ta꞉ ula꞉ haumanu a꞉mbaaso hata꞉ mo makeaaso hau piteme haliweki ika꞉ hoke wenoko haseme tupa꞉ na hapa꞉peke. Mo haliwekima꞉ta꞉ wanda꞉halima꞉ handolo hata꞉ ikita꞉ nee pi ula꞉ some ya꞉ka꞉ta꞉me hone wina꞉ ika꞉ loke handeteke hala꞉ hau mina꞉pa꞉latiki pu halememe. I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Koto haliwekima꞉ ika꞉ mulumeke hone wilimi aleta꞉ ame do hata꞉ mu paeyaasememe. ");
INSERT INTO ssx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pate ikana꞉ma꞉ nee pi a꞉nda꞉ wimika꞉na꞉ta꞉ kota꞉ wanda꞉halima꞉ handa꞉ wiaama꞉na꞉ma꞉ ");
INSERT INTO ssx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ika꞉ leke popeleke tanda꞉pa itiki yola hapa꞉peke. Kutu pimika꞉na꞉ta꞉ kota꞉ mo naka꞉ handa꞉peke na ya꞉la꞉ Apa꞉ma꞉ handaa hone wilieke. Kutaa mo naka꞉ honumake siki pitele hau handa꞉la꞉ Apa꞉ma꞉ta꞉ naka꞉ yenki wialieke. ");
INSERT INTO ssx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mo maka꞉ta꞉ ikiki pu o bisapu inkikima꞉ no o haliwekima꞉ pake no kutu pulu peleme kenke pa꞉ta꞉ ika꞉ alemanu na amu pikita꞉ ");
INSERT INTO ssx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","pa mo maka꞉ta꞉ ikiki na pu bisapu inkikima꞉ na no make haliwekima꞉ pake na mulu peleme Hepeni nane ika꞉ alemanu amu pia꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pa ekipeke. Ika꞉ alemanu amu peleme pa꞉ta꞉ta꞉ ika꞉ honemanu make mandake wina꞉ lo halimikie. ");
INSERT INTO ssx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mo leketa꞉ lokena꞉ ola꞉pakee. Naka꞉ leke yaapo telipina꞉ epea꞉ka꞉na꞉ta꞉ kota꞉ naka꞉ loke paeyaota꞉ pa̱a̱ma꞉ tumbilieke. ");
INSERT INTO ssx_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pate naka꞉ leke yaapo a꞉nda꞉ hoeya꞉ka꞉na꞉ta꞉ kota꞉ mo naka꞉ loke paeyaota꞉ timba꞉ la꞉ pambilieke. Koto mo naka꞉ lokena꞉ pa̱a̱ a꞉nda꞉ timba꞉ lea꞉ka꞉na꞉ta꞉ a꞉pee kota꞉ kotota꞉ ota꞉ timba꞉ tiekee. ");
INSERT INTO ssx_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Homeke ma꞉nda꞉ma꞉ mo you hali yaapona꞉ e pokaasa꞉ hali hapeke na ya꞉la꞉me. Puluekema꞉ taapo haya꞉ka꞉na꞉ta꞉ kota꞉ ma꞉nda꞉ pa꞉ta꞉ pukima꞉ homolota꞉ ma꞉nda꞉ta꞉ honditi pilieke o ma꞉nda꞉ pa꞉ta꞉ta꞉ hone wopu pitolo hata꞉ta꞉ ma꞉nda꞉ta꞉ kiaalieke. Kutaa ikana꞉ma꞉ make mo mani pita꞉ Koda꞉ yaapoma꞉ ika꞉ you hali yaapo haena꞉ laa ipilika꞉ e homeke dina꞉ pokaapa꞉peke na ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Do ekina꞉ yeke iki pa꞉ta꞉ dupa la kitolome. I̱ homaama꞉na꞉ ikali ne aleke nolua꞉pe laa make ya yama꞉peke ale tonka꞉na꞉ ekipa mulua꞉pe laa ka꞉nda꞉ma꞉ na homo hapa꞉peke. Do ekina꞉yeke loa꞉me. Mo ika꞉ da꞉ta꞉la꞉ ekima꞉ta꞉ mo ne na lombei pu make o ika꞉ lokema꞉ta꞉ mo aka꞉manu ota꞉ na lombei pa꞉lekeyeke yekea. ");
INSERT INTO ssx_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mo bitutu laa pomineleme bamanu handa꞉pe. Ikana꞉ma꞉ta꞉ ika꞉ nolo peleme ne waemanu nokopa kilikimanu talaata꞉ mo ne amu pu hala꞉ da pa꞉ta꞉manu na amu pu halememe. Koto hau na pu halemepate pa mo hepeni hala꞉ Apa꞉ma꞉ ika꞉ nemanu ana꞉na꞉ halo hala꞉ka꞉ta꞉me hone umana꞉e. Kota꞉ iki make mo bamanu ota꞉ lombei na pelemekeyeke yekea. ");
INSERT INTO ssx_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ika꞉ ka꞉nda꞉ma꞉ homo halemeeki manuma꞉ta꞉ ika꞉ halo peleme nate leke hokulu peaapeke ya꞉la꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ika꞉ aka꞉manu ekipa muluepe laa pa ekipeke ka꞉nda꞉ma꞉ homo halemepe. Mo si ale manuna꞉ momamanu opa꞉la꞉eki hone wipee. Koto moma manuma꞉ta꞉ ika꞉ yama꞉peke aka꞉manu muluekema꞉ e na poko halememe. Koto hau na pu halemepate ");
INSERT INTO ssx_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","I̱ma꞉ iki pa꞉ta꞉ alota꞉ Mo hande Kini Solomonoma꞉ kone ipika꞉ mani tieke tiekema꞉ mo moma manuna꞉ au la꞉la꞉ ekima꞉ handeke aka꞉manu na hambo yameekeme alome. ");
INSERT INTO ssx_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mo ame homeke opa haena꞉ laa tunkula hapuao beliata꞉ tina꞉ yanka꞉peke yeke moma manuna꞉ auta꞉ Koda꞉ma꞉ lawao haya꞉ka꞉na꞉ta꞉ a꞉pee kota꞉ ika꞉ hone tulaaseme ekita꞉ ota꞉ hodikale siki ya꞉ka꞉ta꞉me. Koto alemanu pa꞉ta꞉ kone Koda꞉ma꞉ kutu pu haya꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ iki make ota꞉ ana꞉na꞉ kone handeteke halieke. ");
INSERT INTO ssx_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kutu piliekema꞉ ikana꞉ma꞉ta꞉ Ya nolo polo ne ikali make aka꞉ peaata꞉ hanema꞉ epea꞉ka꞉na꞉ mulua꞉pe laa ka꞉nda꞉ma꞉ na homo hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mo Koda꞉na꞉ biki na opimiki wanda꞉halima꞉ta꞉ hoto paeyao koto ale manuna꞉ anke wopu tolu haleme. Pate mo ika꞉ hepeni hala꞉ Apa꞉ma꞉ta꞉ koto alemanu nate paeyao ikana꞉ma꞉ make mu hapa꞉peke ekita꞉ hone ula꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Koto pa꞉la꞉ ekina꞉ta꞉ ikana꞉ma꞉ mo Koda꞉na꞉ Kilu Tombuao Hala꞉eki make ipika꞉ tikitiki piki hau make epena꞉ loluekema꞉ yeke titina꞉ amba꞉la weiyu haemeka꞉na꞉ta꞉ kota꞉ Koda꞉ma꞉ mo koto ika꞉ hone peleme ale manuta꞉ iki ana꞉lao ku halieke. ");
INSERT INTO ssx_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Koto ekina꞉ta꞉ beliana꞉ ka꞉nda꞉ manuta꞉ ame kone na mia꞉pa꞉peke. Beliana꞉ ka꞉nda꞉na꞉ ka꞉nda꞉ta꞉ beliaeki ipika꞉ ale homekee. Mandane nate manuna꞉ ka꞉nda꞉ manuta꞉ ame do natena꞉ ka꞉nda꞉ taapuna꞉ apa꞉taapeke na ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Koda꞉ma꞉ iki pa꞉ta꞉ pi yokaalu kiaapa꞉na꞉ ikana꞉ma꞉ make ma꞉nda꞉ pa꞉ta꞉ pi yokaalu na hala꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pa ekipeke ikana꞉ma꞉ mo mandane wanda꞉hali pa꞉ta꞉ pi yokaalu pimika꞉na꞉ta꞉ kota꞉ ika꞉ pi yokaalu pimi tupa꞉ta꞉ Koda꞉ma꞉ make iki pa꞉ta꞉ mandake piki pi yokaalu kone kilieke. Kutupa ikana꞉ma꞉ ma꞉nda꞉ pa꞉ta꞉ manda꞉ mineme manda꞉ma꞉ kone Koda꞉ma꞉ iki make homeke manda꞉ma꞉ kone milieke. ");
INSERT INTO ssx_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ekipeke naka꞉ kamena꞉ leke pa꞉ta꞉ ula꞉ dokolo siki hone wopu witolo hata꞉ta꞉ mo naka꞉ leke pa꞉ta꞉ ula꞉ ti taka꞉la꞉pake tieketa꞉ hone na u halepe. ");
INSERT INTO ssx_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mo ti taka꞉la꞉pake tieke naka꞉ leke pa꞉ta꞉ pa wina꞉ alo hata꞉ta꞉ ekipa naka꞉ kame pa꞉ta꞉ Naka꞉ leke ula꞉ dokolo siki meanoe lelipikipe. ");
INSERT INTO ssx_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Aa yapi pi miki some. Titina꞉ mo naka꞉ leke ula꞉ ti taka꞉la꞉pake kiake amba꞉la mea baeka꞉na꞉ta꞉ kota꞉ mo naka꞉ kamena꞉ leke pa꞉ta꞉ ula꞉ dokolo siki mea waluekema꞉ta꞉ epeke handilipikie. ");
INSERT INTO ssx_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ika꞉ Koda꞉ pa꞉ta꞉ haluekema꞉ wia꞉ haleme alemanu kika pa꞉ta꞉ na hala꞉pa꞉peke. Pa ekipeke ikana꞉ma꞉ paa la꞉ka꞉la iki lu naama꞉na꞉ loa꞉me. Kutupa ika꞉ yenki tiekema꞉ hambeeke munduku teke manuta꞉ mo ma꞉na꞉na꞉ leke pa꞉ta꞉ na lopa moneaapa꞉peke. Kutu pimika꞉na꞉ta꞉ kota꞉ koto munduku manuta꞉ mo ma꞉na꞉manu ika꞉ ankema꞉ pa tombua tombua piliekee. ");
INSERT INTO ssx_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Honke leka꞉na꞉ta꞉ kilieke. Weika꞉na꞉ta꞉ handa꞉ wilipikie. Kilikili laeka꞉na꞉ta꞉ mo neke pa꞉ta꞉ lombawalieke. ");
INSERT INTO ssx_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Homeke epima꞉ honke la꞉tiki pu haya꞉ka꞉na꞉ta꞉ kota꞉ koto somema꞉ milieke. Kutaa make ma꞉nda꞉ epima꞉ weiya꞉tiki pu haya꞉ka꞉na꞉ta꞉ ipikana꞉ma꞉ handa꞉ wilieke. Epima꞉ pota꞉ lia꞉tiki pu haya꞉ka꞉na꞉ta꞉ kota꞉ mo pota꞉ta꞉ koto some pa꞉ta꞉ lombawalieke. ");
INSERT INTO ssx_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wekina꞉ ateke tonuma꞉ta꞉ ika꞉ wekima꞉ tia honke lea꞉ka꞉na꞉ta꞉ iki epi amedama꞉ toopi mea halimikipe ");
INSERT INTO ssx_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","o ta꞉peli honke lea꞉ka꞉na꞉ta꞉ hoke keto mea halimikipe. ");
INSERT INTO ssx_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ikana꞉ma꞉ hoke wanda꞉hali hata꞉ kone ika꞉ wekiwandiki pa꞉ta꞉ epeke epeke alemanu hala꞉pekeeki hone wimika꞉na꞉ta꞉ kota꞉ mo ika꞉ hepeni hala꞉ Apa꞉ma꞉ta꞉ ikana꞉ma꞉ piteme hau ota꞉ lombei peao koto honke lo haleme wanda꞉hali pa꞉ta꞉ ota꞉ epeke epeke alemanu halieke. ");
INSERT INTO ssx_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Wanda꞉halima꞉ mandane haumanu iki pa꞉ta꞉ pina꞉e laa hone peleme tupa꞉ ikana꞉ma꞉ koto haumanu kone iki pa꞉ta꞉ pu hapa꞉peke. Kota꞉ Mosesima꞉ mo Lo Pi wiekeeki make potopede haliwekima꞉ wimiki mana꞉ pi make do koto hau peomono loluekema꞉ wieke pie. ");
INSERT INTO ssx_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mo dekepeke pota꞉ kake pa꞉ta꞉ honda꞉ pamba pua꞉pa꞉peke. Pa ekipeke. Mo ti to hala꞉ alena꞉ pua꞉peke pota꞉ kaketa꞉ peo tieke la make ipika꞉ polo pa꞉la꞉ pota꞉ make aleta꞉ ma꞉nda꞉ na wieke handaa wanda꞉hali wopuma꞉ pua꞉tiki pua꞉tiki pu halememe. ");
INSERT INTO ssx_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kutu pu halemepate mo wanda꞉halima꞉ deto hala꞉eki mia꞉peke ya꞉la꞉ pota꞉ kaketa꞉ ota꞉ dekepeke pota꞉ kakee. Kutupa ipika꞉ pota꞉ make ka꞉nda꞉ pa꞉leke handaa wanda꞉hali hosikima꞉ homeke handa꞉ u halememe. ");
INSERT INTO ssx_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mo yayapiki potopede haliwekima꞉ iki makeaama꞉na꞉ leke leke lo hapa꞉peke. Ikana꞉ma꞉ iki makealuekema꞉ta꞉ ika꞉ lokena꞉ manda hau manuma꞉ta꞉ sipisipi nono pilimipate ika꞉ puki tukiki naneta꞉ hali lu no hala꞉ tikene kikamanu leke kone halememe. ");
INSERT INTO ssx_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ika꞉ ota꞉ hau pu halemeeki handuluekema꞉ta꞉ kota꞉ ikana꞉ma꞉ ika꞉ kiliki manuma꞉ peneme yaemeka꞉na꞉ handa꞉ wilimikie. Wanda꞉halima꞉ta꞉ waini kiliki taluekema꞉ta꞉ mo taola꞉ puna꞉ eiyo haleke talo hala꞉pe o nose kiliki taluekema꞉ta꞉ ka̱꞉la̱꞉ta꞉na꞉ talo hala꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kutaa make mandane ipi saosao liki tima꞉ta꞉ epeke kilikimanu a꞉ilia꞉pate pa haka꞉teke tima꞉ta꞉ hoke kilikimanu a꞉ilieke. ");
INSERT INTO ssx_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kutu pulu pa꞉la꞉pate ipi saosao liki tima꞉ta꞉ hoke kiliki a꞉eya꞉peke na yelieke. Kutaa make haka꞉teke tima꞉ epeke kiliki a꞉eyo pea꞉peke na ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Hande ti ma꞉nda꞉ma꞉ ipika꞉ epeke kiliki na a꞉eya꞉ka꞉na꞉ta꞉ kota꞉ mo tita꞉ yankuluekema꞉ pokilieke. ");
INSERT INTO ssx_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kutaata꞉ kota꞉ ikana꞉ma꞉ mo hande yayapiki potopede haliwekima꞉ ika꞉ kilikimanu peneme yaemeka꞉na꞉ta꞉ handa꞉ wilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mo I̱ pa꞉ta꞉ Tekehali Tekehali lo haleme wanda꞉hali paeyaoma꞉ oli hepenina꞉ Kilu Tombuao Hala꞉ pa꞉ta꞉ na pelimikie. Kotoeki na pulu pelemepate mo ya hepeni hala꞉ Apa꞉na꞉ hone pa꞉la꞉ hau pu haleme wanda꞉hali homeke homeke honda꞉ pambaa pelimikie. ");
INSERT INTO ssx_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mo hande wanda꞉hali paeyao momba꞉lalo pa꞉la꞉ Koda꞉na꞉ nate opolo epea꞉ka꞉na꞉ta꞉ wanda꞉hali wopuma꞉ dupiki pimanu I̱ pa꞉ta꞉ lelimikie. Tekehalio. Tekehalio. Naka꞉ biki alo hata꞉ Koda꞉na꞉ pimanu walao haloma꞉me. O Naka꞉ biki loma꞉ ekima꞉ hoke temokomanu wopu tolu lu make ta꞉ta꞉ piki na handeke haumanu tonka꞉na꞉ wopu puma꞉me lelimikie. ");
INSERT INTO ssx_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","I̱ pa꞉ta꞉ kutu piki pimanu lelimipate I̱ma꞉ ika꞉ pimanu hombo peaaso hata꞉ alota꞉ I̱ma꞉ ikita꞉ hosiki make ota꞉ na handoa꞉ma꞉ iki hoke wanda꞉hali I̱ teke pa꞉ta꞉ na hake pupama laa tolu lueke. ");
INSERT INTO ssx_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kutaata꞉ wanda꞉hali epima꞉ do ya pimanu opuaata꞉ koto alo ekimanu ota꞉ pu haya꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ mo hande hone wopu wia toopi manda da a꞉eyeke hali tupa꞉ hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nate ma꞉nda꞉na꞉ lako tieke lopeeke ekima꞉ ikalimanu paeyao too make po tilipu tiekema꞉ mo dana꞉ ambula ambula piekepate mo data꞉ toopi manda a꞉eyeke ekima꞉ na lombiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pate wanda꞉hali epima꞉ do ya pimanu opuaata꞉ koto alo ekimanu na pu haya꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ mo hande hone wopu na wiki hou manda da a꞉eyeke hali tupa꞉ hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nate ma꞉nda꞉na꞉ lako tieke lopeeke ekima꞉ ikalimanu paeyao too make po tilipu tiekema꞉ mo dana꞉ ambula ambula pieke ekima꞉ mo data꞉ mea lombayekeme. Ota꞉ hoeya꞉hapu mea lombao hoeyaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuma꞉ do koto pimanu walo paeyaeyeketa꞉ mo hande mombelemeke wanda꞉hali paeyaoma꞉ta꞉ leke opo handaake wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pa ekipeke ipikita꞉ mo ika꞉ hande Lo Pimanu walo haemeke haliwekima꞉ walo haemeke tupa꞉ na waleekeme. Pate ipikita꞉ biki ula꞉ halima꞉ waleke nono pieke handaa pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuma꞉ oli hande pote pa꞉ta꞉ hao hola꞉pa꞉niao epeeke handaata꞉ wanda꞉hali tieke ipika꞉ hoki nane teli mea epemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kutupa Yesu opolo ipulu haena꞉ta꞉ kindi yeni hake hali homeke ipiki pa꞉ta꞉ a꞉pa panda꞉ puniaaso hata꞉ alota꞉ Tekehalio. Neke hone pia꞉ka꞉na꞉ta꞉ kota꞉ nakana꞉ma꞉ ya yeni epeawalena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Koto leeke Yesuma꞉ ipika꞉ kiki tindipao wataaso hata꞉ alota꞉ Aowe. I̱ hone pa꞉la꞉me. Naka꞉ kindi yenita꞉ epeao epeke loke halena꞉ alome leekeme. Koto leeke tomona꞉ kota꞉ mo somena꞉ kindi yenita꞉ hapua mateekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kutu pieketa꞉ Yesuma꞉ mo some pa꞉ta꞉ Opie la alota꞉ Doeki ma꞉nda꞉ pa꞉ta꞉ amba꞉la na leketa꞉ pa mo yeni peao hala꞉ halima꞉ titina꞉ amba꞉la naka꞉ yeni ota꞉ paela꞉pe laa handena꞉ a̱i̱ ipiki pa꞉ta꞉ pua꞉peke. Kutaata꞉ wanda꞉halima꞉ naka꞉ yenita꞉ ota꞉ paela꞉me hone wina꞉ mo hande Mosesima꞉ la꞉ wieke tupa꞉ Koda꞉ pa꞉ta꞉ lia hala꞉la꞉ ale lia hala꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu mo hande Kapeneami daoni pa꞉ta꞉ opolo pua haena꞉ mo hande Loma꞉ wanda꞉halina꞉ ami haliwekina꞉ you halima꞉ Yesu manda꞉ hande pitolo honke alo alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tekehalio. Ya e pokaasa꞉ halita꞉ kiki anke lupa wiki yeni mea pota꞉ pomua꞉peke na yaalo tanda tieke mea ya da pa꞉ta꞉ u peli pelia hala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Epeaalo pulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Koto leeke handaata꞉ mo somema꞉ alota꞉ O dia꞉me. Neke ya da pa꞉ta꞉ epo alota꞉ I̱ta꞉ epeke hali dia꞉ ya꞉la꞉ ekina꞉ nakana꞉ma꞉ ipika꞉ yeni pa paena꞉e pi homeke leka꞉na꞉ta꞉ kota꞉ ya e pokaasa꞉ hali tialieke. ");
INSERT INTO ssx_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pa ekipeke. I̱ta꞉ mandane ami you haliweki oto pa꞉ta꞉ halome. Kutaa I̱ oto pa꞉ta꞉ make mandane ami haliweki halememe. Kutupa I̱ma꞉ ma꞉nda꞉ pa꞉ta꞉ Pue loa꞉ka꞉na꞉ta꞉ pelieke. Ma꞉nda꞉ pa꞉ta꞉ make Epoe loa꞉ka꞉na꞉ta꞉ ipilieke. Kutupa ya pa hameke e pokaasa꞉ some pa꞉ta꞉ Do e pokae loa꞉ka꞉na꞉ta꞉ kota꞉ ota꞉ pealieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Koto leekeeki Yesuma꞉ opuolota꞉ penkilipa꞉tia pominolo hata꞉ mo hande ipika꞉ hoki nane telimiki wanda꞉hali pa꞉ta꞉ alota꞉ I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Mo Isulai tapake tukiki pa꞉ta꞉ dupiki hone tulaake some homeke ma꞉nda꞉ a꞉nda꞉ I̱ na handolome. ");
INSERT INTO ssx_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Koto ekina꞉ I̱ma꞉ iki pa꞉ta꞉ pi ma꞉nda꞉ make dupa alome. Mo nate opa꞉la꞉ nanema꞉ make pamba꞉la꞉ nanema꞉ make wanda꞉hali wopuma꞉ mo hepenina꞉ Kilu Tombuao Hala꞉ ekina꞉ yawe lulu pa꞉la꞉ pa꞉ta꞉ a꞉pa Eipoloha꞉ma꞉ Aisa꞉ke make Dieikope ame̱le̱ mandakena꞉ apa꞉tao pita꞉ nelimikie. ");
INSERT INTO ssx_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pate mo hande Kilu Tombuao Hala꞉eki tukiki pa꞉ta꞉ ota꞉ pua hapa꞉peke yolo peleme wanda꞉hali kone pa mo timba꞉ la꞉papeke pa꞉ta꞉ yolo baalieke. Koto pa꞉ta꞉ta꞉ mo wanda꞉halima꞉ e̱ tieke alo hata꞉ ika꞉ kake nokopa hata꞉ kake lenkena꞉ tieke lo halimikie laa ");
INSERT INTO ssx_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesuma꞉ mo ami you hali pa꞉ta꞉ alota꞉ Naka꞉ hone tulale ekima꞉ kone pealiekema꞉ da pue leekeme. Mo ami you halina꞉ e pokaeyeke halita꞉ koto kone tiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuma꞉ Pidana꞉ da pa꞉ta꞉ peekeme. Koto pa꞉ta꞉ta꞉ Pidana꞉ meiyeke wanda꞉ hoputiti yeni hao ipika꞉ da panda꞉ pa꞉ta꞉ polu pitiekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kutu pieketa꞉ Yesuma꞉ mo wanda꞉na꞉ kiki wataaso haena꞉ mo yeni tandeleekeme. Kutu pieke handaa ipiki tiao hata꞉ta꞉ Yesu pa꞉ta꞉ nemanu haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nate pambolo haena꞉ta꞉ mandane wanda꞉halima꞉ mo hoke temokomanu pitiki wanda꞉hali wopu Yesu pa꞉ta꞉ mea epemekeme. Mo hoke temoko manuta꞉ Yesu ipika꞉ pima꞉ tolu liaata꞉ yeni haemeke wanda꞉hali ika꞉ yenimanu make tandelaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesuma꞉ koto wanda꞉hali epeaeyeke hau manuta꞉ amba꞉ hande potopede hali Aisayama꞉ la꞉ witolo hata꞉ alota꞉ Ipikana꞉ma꞉ ipika꞉ kone nika꞉ ki yenimanu meao make mo biki ula꞉ yeni tekemanu make yoka꞉ mea baeyekeme laa la꞉ wieke pi yaaluekema꞉ yeke piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesuma꞉ mo hande ipiki a꞉pa ambulaemeke wanda꞉hali handaa hone wiaata꞉ ipika꞉ hoki nane telimiki haliweki pa꞉ta꞉ alota꞉ Mo ikali leke mone tea꞉na꞉ baape leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mo hande wape pea wala꞉tiki pu hayeke hali homekema꞉ ipiki pa꞉ta꞉ a꞉pa alota꞉ Wala꞉la꞉ halio. I̱ta꞉ neke hando pa꞉ta꞉ peka꞉na꞉ make ota꞉ teli mea pomuluekema꞉ yeke I̱ma꞉ tikitiki yao halome. ");
INSERT INTO ssx_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Keao hala꞉ kika manuma꞉ kone ika꞉ polu peleme ale ula꞉me. Kutaa ba manuma꞉ make ika꞉ pelia꞉pa꞉peke dakemanu hao hala꞉me. Pate mo Wanda꞉halina꞉ Eiyekema꞉ ipika꞉ you wia pelia꞉peke da panda꞉ ma꞉nda꞉ na ula꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Hali ma꞉nda꞉ Yesuna꞉ hoki nane telia꞉la꞉ hali hata꞉ kone Yesu pa꞉ta꞉ alota꞉ I̱ta꞉ ya apa꞉ mea hoiluekema꞉ paa la꞉ka꞉la ponoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pate Yesuma꞉ hombo peaaso alota꞉ Ika꞉ toko manuma꞉ ika꞉ kone hoina꞉ma꞉ neketa꞉ I̱ teli mea epoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesuma꞉ kawaso homeke pa꞉ta꞉ honda꞉ pamba pitulu peeketa꞉ ipika꞉ disaipolo haliweki make telimea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mo kawaso pua ikali leke tukiki tukikina꞉ haena꞉ penkilipake po tilipu tiekema꞉ mo ikali lekena꞉ ambulaeyekeme. Kutu pieke ekima꞉ mo kawasota꞉ teke pa꞉ta꞉ honki lapeke yekepate Yesuta꞉ u peliekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mo disaipolo haliwekima꞉ Yesu teke pa꞉ta꞉ pua ipiki mea tiaaso alota꞉ Tekehalio. Nikita꞉ ikali naa homa꞉pekeeki teke pa꞉ta꞉ ta ya꞉la꞉ma꞉ niki pa꞉ta꞉la꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesuma꞉ hombo peaaso alota꞉ Ekipeke handa paala꞉ tiekema꞉ homelemepe. Ikita꞉ hone wotu na tulake some hombo ya꞉ka꞉ta꞉me laata꞉ Ipikana꞉ma꞉ tia liao hata꞉ mo hande po tilipu pita꞉ ikali ho yaapo tunkulina꞉ pi leekeme. Koto leeketa꞉ mo hande po ikali yaapo tunkula la꞉ma꞉ na piki e pondo na leke wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kutu piekeeki handolo hata꞉ paeyaoma꞉ penkilipa꞉tia pomimikime. Mo ikali pita꞉ po tilipu yaapoma꞉ ipika꞉ pi ota꞉ opita꞉la꞉ ekita꞉ do someta꞉ eki piki some yekea lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesuma꞉ mo hande ikali leke mone tea꞉na꞉ wieke kenke Kedata nane opolo ipulu haena꞉ta꞉ hali hoiyu hayeke tikene da pa꞉ta꞉ haepeke hali yaapoma꞉ Yesu a꞉pa manda꞉ hande pipikime. Mo hali yaapo pa꞉ta꞉ta꞉ hoke temokomanu pitieke ekima꞉ ipilikita꞉ ota꞉ ka꞉la꞉ta꞉ wopu piki some yaapo haepekeme. Koto ekima꞉ta꞉ wanda꞉halima꞉ mo hali yaapo haepeke ale teke pa꞉ta꞉ wieke pota꞉na꞉ pua꞉peke na yekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Koto hali yaapoma꞉ Yesu handolo hata꞉ koto kone wi la alota꞉ Koda꞉na꞉ Eiyekeo. Niki pa꞉ta꞉ eki hau puluekema꞉ ipulipe laa Mo hande niki hoeyaalo pa꞉la꞉ nate a̱i̱ na epeke haena꞉ niki hoeyaaluekema꞉ a꞉pa pipe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Iki haemeke ale mo pate leketa꞉ ma꞉na꞉ titima꞉ ne nalo haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kutaata꞉ mo hande hoke temoko manuma꞉ Yesu pa꞉ta꞉ alota꞉ Nakana꞉ma꞉ niki tolueke hone wika꞉na꞉ta꞉ kota꞉ mo ma꞉na꞉ titi pa꞉ta꞉ pitulu pomono tapaapeke laa honke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesuma꞉ koto hoke temokomanu pa꞉ta꞉ pupee leeke pita꞉ta꞉ kota꞉ ikana꞉ma꞉ mo hali yaapo mina꞉pa꞉lao mo ma꞉na꞉ titi pa꞉ta꞉ pua honda꞉ pambemekeme. Koto ekina꞉ mo ma꞉na꞉ titi paeyaota꞉ mo lombeeke alena꞉ a̱i̱ya hola꞉pa꞉niao ikali leke pa꞉ta꞉ lopaata꞉ ikali naa homa꞉ pitaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kutupa mo ma꞉na꞉ titi handeteke haemeke hali manuma꞉ ika꞉ teke da nane pindipa puaata꞉ mo hande pieke hau paeyao make hande hoke temoko pitiki hali yaapo pa꞉ta꞉ pieke haumanu tonka꞉na꞉ paeyao wanda꞉hali pa꞉ta꞉ moka꞉laemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Koto ekina꞉ta꞉ mo daoni pa꞉ta꞉ haemeke wanda꞉hali ota꞉ paeya tapaoma꞉ Yesu manda꞉ hande pulu pemekeme. Kutupa ikana꞉ma꞉ Yesu handaa ipiki pa꞉ta꞉ honke alo alota꞉ Nika꞉ da yu mina꞉pa꞉lao pue lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesuma꞉ mo kawaso pa꞉ta꞉ pitulu pua mo ikali leke tunkula paa la꞉ka꞉la mone tea꞉na꞉ ipika꞉ teke da pa꞉ta꞉ opolo peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kutu pieketa꞉ mandane wanda꞉halima꞉ dola꞉pake piki hali homeke ipiki pa꞉ta꞉ tilina꞉ mea tia epemekeme. Yesuma꞉ ika꞉ hone tulaemekeeki handaa mo dola꞉pake piki hali handolo alota꞉ Apa꞉ma꞉ta꞉ epolo pila꞉taa. Naka꞉ hoke hauta꞉ pa paeyaasome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mandane wape pea walo haemeke haliwekima꞉ koto leekeeki opua ika꞉ honema꞉ alota꞉ Do somema꞉ Koda꞉na꞉ biki hoeyake pi ala꞉me hone wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","5","Mo haliwekima꞉ hone wimikieki handaa Yesuma꞉ amba꞉ kokele pea hata꞉ iki pa꞉ta꞉ alota꞉ Ekipeke handa ika꞉ puki manuma꞉ koto hoke honemanu miniki halemepe laa lota꞉ pitolo alota꞉ Ikana꞉ma꞉ eki hone witemepe. I̱ma꞉ Naka꞉ hoke hauta꞉ paeyaasome alo pi yapa꞉ pa꞉la꞉pe o Neke tiao pue alo pi yapa꞉ pa꞉la꞉pe laa ");
INSERT INTO ssx_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","iki pa꞉ta꞉ alota꞉ Wanda꞉halina꞉ Eiyekema꞉ do kenkena꞉ hata꞉ hoke haumanu paeyaapeke wele wia halo ekita꞉ ame pene yanoma꞉ handa꞉pa꞉peke. Koto laata꞉ mo hande dola꞉pake some pa꞉ta꞉ alota꞉ Tiao. Naka꞉ yapa꞉ta꞉ yoka꞉ mea mina da pue leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mo halima꞉ koto pi opuaata꞉ tiao ipika꞉ da peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wanda꞉halima꞉ koto hau handolota꞉ paala꞉ma꞉ homemekeme. Do epeaasa꞉ weleta꞉ Koda꞉ma꞉ haliweki pa꞉ta꞉ halaa pia꞉ka꞉ta꞉me laa ipika꞉ biki yeiya꞉ laemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuma꞉ koto pa꞉ta꞉ mina꞉pa꞉lao pulu hata꞉ta꞉ dakisi mu hayeke hali bikita꞉ Ma꞉tiu ipika꞉ mani yata꞉po hayeke da pa꞉ta꞉ pitiekeeki handeekeme. Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ I̱ teli mea epoe leekeme. Koto leeke Ma꞉tiu tiao ipiki telimea peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kutupa Yesuma꞉ Ma꞉tiuna꞉ da pa꞉ta꞉ ne nalo pitina꞉ dakisi mani mu haemeke haliweki wopu make hoke haliweki wopu make Yesu ipika꞉ hoki nane telimiki haliweki ame̱le̱ mandake pa꞉ta꞉ pitimikime. ");
INSERT INTO ssx_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kutu pimikieki mandane Pa꞉tisi haliwekima꞉ handolo hata꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ Ekipeke mo ika꞉ disama꞉ mo dakisi mani mu haleme haliweki mo hoke haliweki ame̱le̱ ne no pilimipe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesuma꞉ koto lemeke pi opua iki pa꞉ta꞉ alota꞉ Yeni na hasa꞉ wanda꞉halima꞉ dokeda hali pa꞉ta꞉ na polo pelemepate pa yeni hasa꞉ wanda꞉halita꞉ dokeda pa꞉ta꞉ pelimikie. ");
INSERT INTO ssx_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hande Baiboloma꞉ alota꞉ Mo hoteke lia hala꞉la꞉ ekita꞉ I̱ma꞉ hone na pa꞉la꞉pate a꞉ta꞉ma꞉ homo hasa꞉ hau homeke hone pa꞉la꞉me la꞉la꞉ pina꞉ tekemanu amba꞉la hone uemena꞉ ikana꞉ma꞉ pua weiya꞉pe. I̱ma꞉ta꞉ epeke hau pu hala꞉ wanda꞉hali hone ma꞉nda꞉ la꞉ka꞉la wina꞉yeke wi loluekema꞉ na epoa꞉pate pa hoke hau pu hala꞉ wanda꞉halima꞉ hone ma꞉nda꞉ la꞉ka꞉la wina꞉yeke wi loluekema꞉ epoa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kutupa nate ma꞉nda꞉na꞉ mo hande bapitaisi peao hayeke hali Dionina꞉ hoki nane telimiki haliweki ikana꞉ma꞉ Yesu pa꞉ta꞉ a꞉pa alota꞉ Pa ekipeke nikana꞉ma꞉ make mo Pa꞉tisi haliwekima꞉ make tana꞉ eleke elekena꞉ nee pi u moneao haloma꞉pate naka꞉ disaipolo haliwekima꞉ta꞉ nee pi ota꞉ na wilimime leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Koto lemeke Yesuma꞉ iki pa꞉ta꞉ alota꞉ Wanda꞉ panake ta꞉ma꞉ni pita꞉la꞉ natena꞉ wanda꞉ tekehalima꞉ mo ipika꞉ wi leeke epemeke wanda꞉hali ame̱le̱ mandake hao haya꞉ka꞉na꞉ta꞉ ikana꞉ma꞉ ka꞉nda꞉ma꞉ homo halimikie hone witemepe. Dia꞉me. Koto pea꞉peke na ya꞉la꞉me. Pate ipiki mea polo pa꞉la꞉ nate ipilia꞉ natena꞉ta꞉ mo wanda꞉ teke halita꞉ iki ame̱le̱ na halieke. Koto natena꞉ta꞉ ikana꞉ma꞉ nee pi wilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ma꞉nda꞉ma꞉ amba꞉ dau tombulu epeaaluekema꞉ mo panake dau sinkipikieki mea talao na tombulu hala꞉me. Kutu pia꞉ka꞉na꞉ta꞉ panake dau sinkipiki talaasa꞉ ekima꞉ amba꞉ dau paa sinkipa ka꞉ka꞉na꞉ tieke wilieke. ");
INSERT INTO ssx_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Koto tupa꞉ kone ma꞉nda꞉ma꞉ panake waini ikalita꞉ amba꞉ ma꞉na꞉ yonkelekema꞉ wa꞉pa꞉la꞉ ipi kanake manuna꞉ na holo pambo hala꞉me. Kutu pia꞉ka꞉na꞉ta꞉ mo waini ikali hoelolu baalieke. Kutu pilia꞉ ekima꞉ta꞉ mo ma꞉na꞉ yonkeleke make ota꞉ hoeya pa wilieke. Kutu piliepate panake ma꞉na꞉ yonkelekema꞉ wa꞉pa꞉la꞉ kanakemanu mea panake waini ikali holo pambea꞉ka꞉na꞉ta꞉ kota꞉ mo ikali kanake yaapota꞉ ota꞉ epeke tupa꞉ endialipipikie laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuma꞉ mo hande haliweki pa꞉ta꞉ do koto pimanu alo haena꞉ Diu wanda꞉halina꞉ yeni dana꞉ you hali Yesu pa꞉ta꞉ opolo a꞉pa tumiki yotuao pita꞉ alota꞉ Ya wandikita꞉ homa꞉la꞉pate pa ipika꞉ lokena꞉ naka꞉ kiki a꞉pa wika꞉na꞉ta꞉ tiaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Koto leeke Yesu tiao ipiki telimea peeke ipika꞉ disaipolo haliweki make mandake pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ikana꞉ma꞉ koto pulu haena꞉ta꞉ wanda꞉ homeke Yesuna꞉ hoki nanema꞉ a꞉pa ipika꞉ dopieke dau nepoko wataeyekeme. Mo wanda꞉ta꞉ bapi 12 tukiki pa꞉ta꞉ hayeke andusa꞉ we wopu yopu lombei peao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Koto wanda꞉na꞉ honema꞉ta꞉ I̱ma꞉ ipika꞉ dau watawa꞉ka꞉na꞉ta꞉ ya yeni paelieke hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesuma꞉ la꞉ka꞉la꞉moneao ipiki handolo alota꞉ Naka꞉ hone tulaale ekima꞉ neke epeleme leekeme. Koto leeke pa꞉ta꞉ koto kone mo wanda꞉na꞉ yeni paeyao epea hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Koto hoki naneta꞉ Yesu mo hande you halina꞉ da pa꞉ta꞉ honda꞉ pambeekeme. Koto homa꞉ da tukiki pa꞉ta꞉ mombelemeke pe kanake lita꞉la꞉ tapake make homa꞉ witolo e̱ ala꞉ tapake wopu make pitimikieki handaata꞉ Yesuma꞉ iki pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Koto wandiki sikita꞉ ota꞉ na homa꞉la꞉pate pa u pa꞉ela꞉me. Koto pa꞉la꞉ma꞉ iki paeyao hama pupe leekeme. Koto leeketa꞉ iki paeyaoma꞉ ipiki kitaemekemepate ");
INSERT INTO ssx_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yesuma꞉ koto wanda꞉hali tolu lia hama nane haena꞉ laata꞉ mo wandikina꞉ da panda꞉ pa꞉ta꞉ pua ipika꞉ kiki mieketa꞉ mo wandiki koto kone tiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Koto wandiki mea tiaeyeke ekina꞉ pita꞉ koto kenke paeyao pa꞉ta꞉ kende tupa꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuma꞉ koto pa꞉ta꞉ mina꞉pa꞉lao pulu haena꞉ leke holu piki hali yaapoma꞉ ipika꞉ hoki nane wi tieke la꞉ paleke teli mea pulu alota꞉ Deipidina꞉ eiyekeo. Diki pa꞉ta꞉ a꞉ta꞉ma꞉ homa꞉peke la꞉tia pepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu da pa꞉ta꞉ honda꞉ pambolo haena꞉ koto leke holu piki hali yaapota꞉ ipiki pa꞉ta꞉ epepekeme. Kutu pipiki Yesuma꞉ ipiliki pa꞉ta꞉ lota꞉ pitolo alota꞉ Ipilika꞉ honema꞉ta꞉ I̱ pa꞉ta꞉ ipiliki epeapeke wele ula꞉me hone witolo hone ti lalepepe leekeme. Ipilikana꞉ma꞉ koto pi hombo peaaso alota꞉ Aowe lepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Koto lepeke pi Yesuma꞉ opua ipilika꞉ leke wataaso alota꞉ Koto ipilika꞉ hone ti lalepe tupa꞉ kone pina꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Koto pi alo haena꞉ kone ipilika꞉ leke ki leekeme. Kutu pieke Yesuma꞉ ipiliki hando alo hata꞉ alota꞉ Ma꞉nda꞉ pa꞉ta꞉ na pua lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Koto leekepate ipilikana꞉ma꞉ mo da mina꞉pa꞉lao pulu hata꞉ mo Yesuma꞉ pieke hauta꞉ koto haepeke kenke pa꞉ta꞉ kende tupa꞉ wina꞉ lepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mo hande leke holu piki hali yaapo mo da mina꞉pa꞉lao pulu haena꞉ta꞉ pa mandane wanda꞉halima꞉ pi na leke hali homeke Yesu pa꞉ta꞉ hatuku epemekeme. Mo halina꞉ pi na leeke ekita꞉ hoke temoko pita꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesuma꞉ mo hande hoke temoko tolu lieketa꞉ koto kone mo hande pi na leke halima꞉ pi paa leekeme. Koto piekeeki wanda꞉hali paeyaoma꞉ handolo tola꞉tia pominolo alota꞉ Dupiki hau homeke ma꞉nda꞉ Isulai kenke pa꞉ta꞉ ota꞉ na handoma꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Koto lemekepate mo hande Pa꞉tisi haliwekima꞉ alota꞉ Do somema꞉ta꞉ mo hande hoke you temokona꞉ wele mea koto hande hoke temokomanu tolu lia pia꞉ka꞉ta꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesuma꞉ta꞉ koto pa꞉ta꞉ haemeke da paeyao pa꞉ta꞉manu pomu lopeekeme. Ika꞉ teke da tieke pa꞉ta꞉ make ika꞉ da teke pa꞉ta꞉manu make pomu lopo piekeme. Kutaata꞉ ika꞉ yeni pu haemeke damanu pa꞉ta꞉ make pi walo hayekeme. Ipikana꞉ma꞉ mo Koda꞉na꞉ Kilu Tombuao Hala꞉ ekina꞉ Pi Seliapomanu walolo hata꞉ make mo ta꞉ta꞉ ta꞉ta꞉ piki yeni haemeke wanda꞉halina꞉ yeni tekemanu tonka꞉na꞉ wamo peatiki pomu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Koto pomieke ale pa꞉ta꞉manu mombelemeke wanda꞉hali tieke handaata꞉ iki pa꞉ta꞉ ipika꞉ pukima꞉ a꞉ta꞉ tieke ota꞉ wopu homeekeme. Pa ekiepina꞉ ikita꞉ mo handeteke hala꞉ hali na hake sipisipimanu hata꞉ pita꞉la꞉ tupa꞉ ika꞉ kone tamba꞉ mia꞉peke na yo make hone mataalo hone ti yoko haemeke haumanu handolo kutu piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Koto ekina꞉ ipika꞉ hoki nane telimiki haliweki handolo alota꞉ Ne napeke tieke wopu pota꞉la꞉pate mo mea momba꞉laapeke wanda꞉halita꞉ aneke dia꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Koto ekina꞉ta꞉ mo e teke halima꞉ ipika꞉ ena꞉ ne napeke mea momba꞉laalo peleme haliweki ana꞉na꞉ tapaena꞉ ikana꞉ma꞉ ipiki pa꞉ta꞉ yeni pu hapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuma꞉ ipika꞉ hoki nane telimiki 12 haliweki wi la꞉ mea momba꞉lao hata꞉ mo hoke temokomanu tolu lia꞉peke welemanu make hoke yeni tekemanu make wamo pea꞉peke welemanu make iki pa꞉ta꞉ ana꞉na꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Koto 12 Aposolo haliwekina꞉ biki manuta꞉ doe. Titina꞉ta꞉ Saimono biki ma꞉nda꞉ta꞉ Pida kutupata꞉ Pida ipika꞉ hameke A꞉ndutu make Sepedina꞉ eiyeke Dia꞉mesi Dioni hama̱la̱꞉ make ");
INSERT INTO ssx_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipi make Badolomiu make Tomasi make mo hande dakisi mu hayeke some Ma꞉tiu make A꞉lopia꞉sina꞉ eiyeke Dia꞉mesi make Ta꞉dia꞉si make ");
INSERT INTO ssx_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimono Seloti make mo hande Yesu lina꞉ a꞉nda꞉ lombea꞉ hali Diudasi Isekatioti make ika꞉ biki paeyaota꞉ koto wape pea ula꞉ handa꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Koto 12 haliweki tapaaluekema꞉ hata꞉ta꞉ Yesuma꞉ iki pa꞉ta꞉ dupiki pi leekeme. Mo Diendaili tapakena꞉ da yu pa꞉ta꞉manu o Sametia tapakena꞉ da teke pa꞉ta꞉manu make na pua꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pate kutu piteleme tupa꞉ta꞉ mo Isulaina꞉ alu peleme sipisipima꞉ handeleme wanda꞉hali pa꞉ta꞉ pua꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kutupa iki puaata꞉ dupiki pi lapa꞉peke Mo hande Hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ iki teke pa꞉ta꞉ ta a꞉pa hala꞉ handa꞉pe lapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Koto alo hata꞉ta꞉ mo yeni haleme wanda꞉halina꞉ yeni wamo peao make mo homemeke tokomanu mea da꞉tao make wanda꞉halina꞉ lokena꞉ hala꞉ kindi yenimanu epeaaso hata꞉ mo hoke temokomanu tolu lu pia꞉pa꞉peke. Do koto pea꞉pa꞉peke alo ekita꞉ pa hameke mimi ekina꞉ ikana꞉ma꞉ make pa hameke hala꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ika꞉ pausa pa꞉ta꞉ kolo mani o silipa mani o wepiki toeamanu make na mendia꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ta pota꞉na꞉ poluekema꞉ta꞉ nu o topo dau o topo ankedake o tumapu make na mea pu pea꞉pa꞉peke. Pa ekipeke. Mo e pokaasa꞉ halima꞉ta꞉ ipika꞉ e pokaasa꞉ alemanu kone hala꞉peke ya꞉lieke. ");
INSERT INTO ssx_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ikana꞉ma꞉ mo daoni pa꞉ta꞉manu o da teke pa꞉ta꞉manu opolo pemeka꞉na꞉ta꞉ kota꞉ koto pa꞉ta꞉ mo epeke tikitiki piki hali ma꞉nda꞉ weiya handaata꞉ koto somena꞉ da topo na piki pa pelia haota꞉ kenke ma꞉nda꞉ pa꞉ta꞉ puluekema꞉ mina꞉pa꞉lao pua꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Da homeke a꞉nda꞉ pa꞉ta꞉ honda꞉ pambolo hata꞉ta꞉ dupiki pi lapa꞉peke Do da pa꞉ta꞉ haleme wanda꞉hali paeyaota꞉ Koda꞉ma꞉ epeaena꞉e lapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Koto da pa꞉ta꞉ halimi wanda꞉halima꞉ a꞉nda꞉ iki pa꞉ta꞉ ta꞉na꞉ma꞉ homolo hata꞉ A꞉pa꞉la꞉ma꞉ epoe lemeka꞉na꞉ta꞉ kota꞉ koto epeaasa꞉ pita꞉ mo da pa꞉ta꞉ ota꞉ u pelia haena꞉ lapa꞉peke. Pate iki ta꞉na꞉ na homemeka꞉na꞉ta꞉ kota꞉ koto epeaasa꞉ pita꞉ paa yoka꞉ mea꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kutaa make mandane daoni o da teke manuma꞉ a꞉nda꞉ iki pa꞉ta꞉ Epeke a꞉pa꞉la꞉me laa na handa꞉ mu make o ika꞉ pi na opu pimika꞉na꞉ta꞉ kota꞉ koto da yu mina꞉pa꞉lao ika꞉ ankena꞉ pa꞉la꞉ dokolo tande laa mina꞉pa꞉lao pua꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","I̱ma꞉ iki pa꞉ta꞉ ota꞉ ota꞉ pi alome. Mo Koda꞉na꞉ pi yokaalu pulu pa꞉la꞉ nate tieke ipilia꞉ dina꞉ta꞉ mo hande Sodomo da pita꞉ Komoto da yaapo pa꞉ta꞉ halo pa꞉la꞉ hoke yenkita꞉ ota꞉ tieke mulu pelepepate pa koto ikana꞉ma꞉ walimi pi kiaalimi wanda꞉hali ikana꞉ma꞉ mulu peleme yenkita꞉ Koda꞉ma꞉ ota꞉ haka꞉ta꞉pao halieke alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Opua꞉pe. Ikita꞉ mo honkopu wopu na hake sipisipimanu tupa꞉ ya꞉la꞉pate I̱ma꞉ iki mo tikene iyamanu tukiki pa꞉ta꞉ hamena꞉ tapaasome. Koto ekina꞉ mo hande ketoma꞉ kimelema꞉ pomua꞉la꞉ tupa꞉ iki make kimelema꞉ pomua꞉pa꞉peke. Kutaa make mo hande dokolo ba manuma꞉ epeke tupa꞉ momba꞉la pitu haleme tupa꞉ iki make sembepela hao hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mo haliwekima꞉ iki pa꞉ta꞉ pulu peleme ekimanu wopu handeteke hao hapa꞉peke. Ikana꞉ma꞉ iki da꞉ka꞉pa꞉ mina pi yokaaluna꞉ mea pua make mo ika꞉ pi hotu haleme da pa꞉ta꞉manu iki yombilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Paa yanaaso ya biki hoeyaaluekema꞉ ikana꞉ma꞉ ikita꞉ mo kapomani tumiki haliwekimanu pa꞉ta꞉ make mo kinimanu pa꞉ta꞉ make hatuku pelimikie. Kutu pilimi toma꞉na꞉ta꞉ ikana꞉ma꞉ mo Pi Seliapota꞉ koto kapomani tumiki haliweki pa꞉ta꞉ make mo Diendaili wanda꞉hali pa꞉ta꞉ make waloemena꞉ waleke wilieke. ");
INSERT INTO ssx_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Iki da꞉ka꞉pa꞉ minilimi pita꞉ma꞉ta꞉ Do pi yokaalu pa꞉ta꞉ta꞉ eki pi lolua꞉pe o eki pa hombo pealua꞉pe laa hone ti na yoko hapa꞉peke. Pa ekipeke. Mo pi yokaalu tukiki pa꞉ta꞉ ika꞉ pi kini pilimi toma꞉na꞉ta꞉ mo ika꞉ lolo peleme pita꞉ pa peneme yaeya꞉ka꞉na꞉ta꞉ ana꞉na꞉ mea lelimikie. ");
INSERT INTO ssx_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Koto mo ikana꞉ma꞉ lolo peleme pi manuta꞉ ika꞉ pimanu dia꞉ ya꞉la꞉pate mo ika꞉ Apa꞉na꞉ Sipitidima꞉ ika꞉ lelimi pi pa꞉ta꞉ yama꞉ la꞉na꞉ yeke epena꞉ ala꞉ekie. ");
INSERT INTO ssx_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Haliwekima꞉ ika꞉ hamekemanu kone lia homaena꞉ mea halimikie. Ateke tonuma꞉ ika꞉ weki wandiki pa꞉ta꞉ make homeke hau kone pina꞉ lelimikie. Mo wekiwandikima꞉ make paa ateke inkiki pa꞉ta꞉ la꞉ka꞉la꞉ moneao a꞉nda꞉ litolo hata꞉ mo ateke inkiki ma꞉nda꞉ma꞉ lia homaena꞉ halimikie. ");
INSERT INTO ssx_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ikana꞉ma꞉ ya e pokaaseme haliweki hata꞉ ya biki miniki haleme ekina꞉ta꞉ wanda꞉hali paeyaoma꞉ iki hoki wala kialimikie. Kutu pilimipate kone mo haumanu ipulu haena꞉ kone mo paelo pa꞉la꞉ nate opolo epena꞉ yu wia hata꞉ honkopu hao bepolatiki pu halia꞉ someta꞉ da꞉taa haena꞉ lelieke. ");
INSERT INTO ssx_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ikana꞉ma꞉ daoni homeke a꞉nda꞉ pa꞉ta꞉ halimipate wanda꞉halima꞉ iki pa꞉ta꞉ tanda kimika꞉na꞉ta꞉ kota꞉ daoni ma꞉nda꞉ pa꞉ta꞉ pindipa pua꞉pa꞉peke. I̱ma꞉ iki pa꞉ta꞉ ota꞉ ota꞉ pi alome. Mo Wanda꞉halina꞉ Eiyeke opolo epea꞉ka꞉na꞉ta꞉ ikana꞉ma꞉ mo Isulaina꞉ daoni paeyao pa꞉ta꞉ pokolo peleme emanu paeyao titina꞉ amba꞉la na mina꞉pa꞉lalimikie alome. ");
INSERT INTO ssx_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mo sukulu pita꞉la꞉ weki o wandikita꞉ ipika꞉ wala꞉la꞉ disa some lombei peao na hala꞉me. Koto tupa꞉ kone mo pa hameke e pokaasa꞉ some make ipika꞉ e teke hali lombei peao na hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Koto ekina꞉ta꞉ mo sukulu pita꞉la꞉ wekima꞉ta꞉ ipika꞉ hone pa꞉ta꞉ta꞉ Yaka disa some tupa꞉ halueke laa hone pia꞉ka꞉na꞉ta꞉ kota꞉ ana꞉ pilieke. Koto tupa꞉ kone mo e pokaasa꞉ somema꞉ make Ya e teke hali tupa꞉ kone halueke laa hone pia꞉ka꞉na꞉ta꞉ kota꞉ koto make ana꞉ pilieke. Wanda꞉halima꞉ mo da homeke pa꞉ta꞉ pambo haleme tapakena꞉ Ateke pa꞉ta꞉ mo hande hoke biki Bielisibulu la꞉ wiaemeka꞉na꞉ta꞉ kota꞉ ipika꞉ wekiwandiki pa꞉ta꞉ make koto biki ota꞉ lombei piki ota꞉ hoke bikimanu kone la꞉tiki pilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kutu pu halimipate ikana꞉ma꞉ mo wanda꞉hali pa꞉ta꞉ paala꞉ma꞉ na homa꞉pa꞉peke. Mo ame do a꞉mbao ula꞉ alemanu paeyao wetepena꞉ta꞉ paa lumba꞉pa wilieke. Kutupa mo a꞉mbaaso hata꞉ aleme pi paeyao make wetepena꞉ta꞉ paeyaoma꞉ opina꞉ paa peneme yaalieke. ");
INSERT INTO ssx_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","I̱ma꞉ iki pa꞉ta꞉ timba nane la kitolo pimanu paeyao natepa nane ikana꞉ma꞉ peneme yao wilimikie. Kutupa ika꞉ honumake siki pita꞉ opimi pimanu paeyaota꞉ mo da holu manda nina꞉ tiao hata꞉ paeyaoma꞉ opina꞉ peneme yao la halimikie. ");
INSERT INTO ssx_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mo ika꞉ loke lia homalo pa꞉lemepate ika꞉ temoko lia homaaluekema꞉ wataapeke na ya꞉la꞉ wanda꞉hali pa꞉ta꞉ paala꞉ma꞉ na homo hapa꞉peke. Pate mo ika꞉ loke pita꞉ temoko yaapo ti to hala꞉ ale pa꞉ta꞉ tapao hoeyaapeke Koda꞉ pa꞉ta꞉ homeke ota꞉ paala꞉ma꞉ homo hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Hosiki ba siki yaapota꞉ makedina꞉ yenki 10 toea sikima꞉ hamba꞉peke ba siki yaapo yolo pa꞉la꞉pate mo Apa꞉ Koda꞉ma꞉ mo basunu homeke ma꞉nda꞉ honda꞉pa pene waleke na wina꞉ lea꞉ka꞉na꞉ta꞉ kota꞉ homeke a꞉nda꞉ kenkena꞉ honda꞉pa na lopilieke. ");
INSERT INTO ssx_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kutaa ameta꞉ ika꞉ ekina꞉ make dupa alome Ika꞉ you itiki paeyaota꞉ amba꞉ kone yata꞉pa ana꞉ lao ula꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Koto ekina꞉ta꞉ ikana꞉ma꞉ paala꞉ma꞉ na homo hapa꞉peke. Pa ekipeke. Ika꞉ tombota꞉ koto hosiki basunu wopuna꞉ yenki ota꞉ lombei pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ma꞉nda꞉ epima꞉ wanda꞉halina꞉ leke popelekena꞉ peneme yaaso hata꞉ I̱ta꞉ Ketisona꞉ halie lea꞉ka꞉na꞉ta꞉ kota꞉ I̱ma꞉ make mo ya hepeni hala꞉ Apa꞉na꞉ leke poto poto hata꞉ ipiki pa꞉ta꞉ make homeke hau kone pulueke. ");
INSERT INTO ssx_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pate ma꞉nda꞉hali epima꞉ wanda꞉halina꞉ leke poto poto hata꞉ yaka biki na leke I̱ hoki wala haya꞉ka꞉na꞉ta꞉ kota꞉ I̱ma꞉ make mo ya hepeni hala꞉ Apa꞉na꞉ leke poto poto hata꞉ ipiki pa꞉ta꞉ make kutu pulueke. ");
INSERT INTO ssx_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ika꞉ honema꞉ I̱ma꞉ta꞉ do kenkena꞉ a꞉nda꞉ peliaasa꞉eki mea epea꞉me hone na wia꞉pa꞉peke. Dia꞉me. A꞉nda꞉ peliaasa꞉eki na mea epoa꞉pate pa a꞉nda꞉ pita꞉la꞉ kepete mea epoa꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","I̱ epolo hauma꞉ta꞉ hali homekema꞉ ipika꞉ apa꞉na꞉ a꞉nda꞉ tunkuliki hali haena꞉ lo make wandikima꞉ ipika꞉ inkikina꞉ a꞉nda꞉ tunkuliki wandiki haena꞉ lo make aeyekema꞉ ipika꞉ halikina꞉ inkikina꞉ a꞉nda꞉ tunkuliki wanda꞉ haena꞉ lo make ");
INSERT INTO ssx_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","kutupa hali homekena꞉ titina꞉ a꞉nda꞉ tunkuliki wanda꞉hali manuta꞉ ipika꞉ da pa꞉ta꞉ haleme tapake kone ya꞉lieke. ");
INSERT INTO ssx_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ma꞉nda꞉ hali epima꞉ I̱ pa꞉ta꞉ puki wilia꞉pate pa ipika꞉ pukima꞉ homa꞉la꞉ ekita꞉ ipika꞉ apa꞉ ama꞉ pa꞉ta꞉ titina꞉ amba꞉la wia꞉ka꞉na꞉ta꞉ kota꞉ koto someta꞉ ya disaipolo hali haena꞉ lapeketa꞉ ana꞉ na pa꞉la꞉me. Hali epima꞉ I̱ pa꞉ta꞉ puki wilia꞉pate kone pa ipika꞉ pukima꞉ homa꞉la꞉ ekita꞉ titina꞉ amba꞉la ipika꞉ wekiwandiki pa꞉ta꞉ u haya꞉ka꞉na꞉ta꞉ kota꞉ koto someta꞉ ya disaipolo hali haena꞉ lapeketa꞉ ana꞉ na pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma꞉nda꞉ hali epima꞉ ipika꞉ a꞉ka꞉tei wape piki ti mea tia ya hau honda꞉ mea na telia pia꞉ka꞉na꞉ta꞉ kota꞉ koto someta꞉ ya disaipolo hali haena꞉ lapeketa꞉ ana꞉ na pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma꞉nda꞉ hali epima꞉ ipika꞉ honkopuma꞉ kone ipika꞉ da꞉ta꞉la꞉eki muluekema꞉ taapo haya꞉ka꞉na꞉ta꞉ kota꞉ ipika꞉ da꞉ta꞉la꞉eki alupalieke. Pate ya e amba꞉la pokaaluekema꞉ ipika꞉ da꞉ta꞉la꞉eki amba꞉la hone na wia꞉ka꞉na꞉ta꞉ kota꞉ koto somena꞉ da꞉ta꞉la꞉ ekita꞉ pa u halieke. ");
INSERT INTO ssx_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Wanda꞉hali epima꞉ ta꞉na꞉ma꞉ homolo hata꞉ iki ya disaipolo haliweki handa꞉ mimika꞉na꞉ta꞉ kota꞉ kotota꞉ I̱ kone handa꞉ minelememe. Koto tupa꞉ kone epima꞉ I̱ pa꞉ta꞉ ta꞉na꞉ma꞉ homolo hata꞉ handa꞉ mimika꞉na꞉ta꞉ kota꞉ kotota꞉ mo I̱ tapaala꞉ Apa꞉ pa꞉ta꞉ kone pitememe. ");
INSERT INTO ssx_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wanda꞉hali epima꞉ Koda꞉na꞉ e pokaasa꞉ hali homeke handaata꞉ Do someta꞉ Koda꞉na꞉ e pokaasa꞉ somee hone witolo hata꞉ ta꞉na꞉ma꞉ homaa handa꞉ mimika꞉na꞉ta꞉ kota꞉ koto somema꞉ mulu pa꞉la꞉ yenki putu piliki kone milimikie. Wanda꞉hali epima꞉ mo epeke hali ma꞉nda꞉na꞉ epeke hau handaa Ipikita꞉ epeke halie laa ta꞉na꞉ma꞉ homaa handa꞉ mimika꞉na꞉ta꞉ kota꞉ koto epeke somema꞉ mulu pa꞉la꞉ yenki putu piliki kone milimikie. ");
INSERT INTO ssx_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Epima꞉ do ya hoki nane tolu hala꞉ you hali dia꞉ ya꞉la꞉pate kone pa ya hoki nane tolu hala꞉ hali ya꞉leke handaa mo hande ipi kanake homeke ma꞉nda꞉ halo haeya꞉ka꞉na꞉ta꞉ kota꞉ koto ikali halia꞉ somema꞉ ipika꞉ yenki putu piliki ota꞉ ana꞉na꞉ milieke hone wia꞉pa꞉peke alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuma꞉ ipika꞉ 12 disaipolo haliweki pa꞉ta꞉ koto mana꞉ pimanu la hala paeyeke hoki naneta꞉ koto kenke mina꞉pa꞉lao pa mo teke pa꞉ta꞉manu haemeke daonimanu pa꞉ta꞉ pua mo Koda꞉na꞉ mana꞉ pimanu walo moka꞉la꞉ tiao make mo Pi Seliapo walo hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kutu pitolo haena꞉ mo hande bapitaisi peao hayeke some Dionima꞉ mo dipula pita꞉ mo Ketisoma꞉ kutupiki haumanu pita꞉la꞉me leekeeki opuata꞉ ipika꞉ disaipolo haliwekimanu Yesu pa꞉ta꞉ tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mo haliwekima꞉ Yesu pa꞉ta꞉ a꞉pa alota꞉ Do nika꞉ lota꞉ pita꞉la꞉eki ota꞉ la kuelena꞉e. Dionima꞉ hali ma꞉nda꞉ ipilieke lea꞉ halita꞉ nekepe o ma꞉nda꞉ epena꞉ yu wia hamonope leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesuma꞉ iki pa꞉ta꞉ hombo peaaso alota꞉ Ikita꞉ paa la꞉ka꞉la pua do ika꞉ lekema꞉ handeleme ekimanu make katakema꞉ opiteleme ekimanu make Dioni pa꞉ta꞉ dupa pua la hala꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Hande leke holu piki wanda꞉hali ameta꞉ ki lelememe. Dola꞉pake wanda꞉hali make tiao pominelememe. Kindi yeni haeme wanda꞉hali make ameta꞉ epea halememe. Katake pokeme wanda꞉halina꞉ katake make lumbula꞉me. Homea꞉ wanda꞉hali make paa da꞉taa tiao haena꞉ la꞉la꞉me. Kutupa mo Pi Seliapota꞉ natehali wanda꞉hali pa꞉ta꞉ wala꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Koto ekina꞉ do I̱ma꞉ pitolo haumanu handaa ka꞉nda꞉ma꞉ na homa꞉la꞉ halima꞉ta꞉ ta꞉na꞉ma꞉ homo hala꞉me laa pua lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kutupa mo Dionina꞉ hoki nane telimiki haliweki la꞉ka꞉la paa pulu haena꞉ta꞉ Yesuma꞉ mo wanda꞉hali pa꞉ta꞉ Dionina꞉ pi dupa lawaeyekeme. Ikana꞉ma꞉ mo hapu hala꞉ alena꞉ puluta꞉ aleke handulumeke hone wimipe. Poma꞉ hambe make mea aneya moneya pu tonkua꞉la꞉eki handulumeke hone wimipe. Dia꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Koto alena꞉ puluta꞉ aleke handulumeke hone wimipe. Ika꞉ honema꞉ta꞉ epeke aka꞉ seliapo yameke hali halia꞉eki handulumeke hone wimipe. Dia꞉me. Aka꞉ seliapo yameke haliwekita꞉ mo kini haliwekina꞉ pitu hala꞉ alenina꞉ homeke handa꞉peke ya꞉la꞉pate ");
INSERT INTO ssx_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","I̱ opuono a̱i̱ la kipa꞉e. Koto pemeke dina꞉ta꞉ aleke handulumeke hone wimipe. Koda꞉na꞉ pi la꞉ mea halaasa꞉ potopede hali yekepe. Aowe. Ipikita꞉ potopede hali ya꞉la꞉pate pa potopede halina꞉ hauta꞉ ota꞉ lombei piki some hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Koto some Dionita꞉ mo hande Baibolona꞉ wape pa꞉la꞉ pina꞉ Koda꞉ma꞉ alota꞉ Ya pi lawalo pula꞉ hali amba꞉la mo naka꞉ pota꞉ tiki tiki yawaena꞉e tapaalueke leeke pita꞉ kota꞉ ipikina꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","I̱ma꞉ ota꞉ pi alome. Mo hande bapitaisi peao haya꞉ hali Dionita꞉ mo amba꞉ haemeke hali paeyao ota꞉ lombei piki some hala꞉me. Pate mo hepenina꞉ Kilu Tombuao Hala꞉ ekina꞉ ota꞉ biki na ula꞉ some a꞉nda꞉ma꞉ta꞉ Dioni lombei pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dionima꞉ mo hande pimanu walea꞉ natena꞉ kini pu mea a꞉pa ame do natena꞉ kone mo hepenina꞉ Kilu Tombuao Hala꞉ ekima꞉ lombei lombei pua꞉tiki ipu hala꞉me. Kutupa mo honkopu hao haleme haliwekima꞉ koto hepenina꞉ Kilu Tombuao Hala꞉eki miniki halememe. ");
INSERT INTO ssx_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Amba꞉ haemeke potopede haliweki paeyaoma꞉ make mo hande Mosesina꞉ la꞉ wieke Lo pi manuma꞉ make Koda꞉na꞉ pi wala꞉tiki a꞉paata꞉ Dionina꞉ nate opolo a꞉pa haena꞉ta꞉ lo naeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kutupa ikana꞉ma꞉ mo hande haliwekima꞉ la꞉ wimiki pimanu opuluekema꞉ hone pimika꞉na꞉ta꞉ kota꞉ mo hande haliwekima꞉ ipilieke laa la꞉ wimi Elaidiata꞉ Dionina꞉ lemeke yekeme. ");
INSERT INTO ssx_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ika꞉ katakema꞉ opua꞉peke yemeka꞉na꞉ta꞉ kota꞉ opua꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Amedo do haleme wanda꞉halita꞉ alekema꞉ handelememe lonope. Ikita꞉ mo makedi hama putupa alu pea pilimi wekiwandiki leke halememe. Ane kalale pitimi tapakema꞉ mone kalale pitimi tapake wi la꞉ moneao alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ikana꞉ma꞉ sama꞉ puemena꞉yeke tapeke luma꞉pate ikana꞉ma꞉ sama꞉ na piki kiaememe. Kutu pimikita꞉ a꞉ta꞉ piki emelimanu loma꞉pate e̱ na leke kiaememe alememe. ");
INSERT INTO ssx_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Dioni a꞉pa ikali ne na neeke ekita꞉ hande wanda꞉halima꞉ alota꞉ Ipiki pa꞉ta꞉ta꞉ hoke temoko pila꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pate Wanda꞉halina꞉ Eiyeke a꞉pa ikali ne yaapo no hayeke ekita꞉ koto wanda꞉halima꞉ kone handolo alota꞉ Do hali handa꞉pe. Ipikita꞉ ikali ne wopu no hake some ya꞉ka꞉ta꞉me. Kutupa ipikita꞉ mo hande dakisi mu make hoke hau pu haleme haliweki ame̱le̱ apa꞉taala꞉me lemekeme. Kota꞉ mo hone wiki hauma꞉ta꞉ ipika꞉ pu hala꞉eki manuma꞉ ipika꞉ honeta꞉ ota꞉ epeke hone o hoke hone laa pa peneme yaasa꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mo hande Yesuma꞉ ipika꞉ na handeke haumanu pu hayeke daoni pa꞉ta꞉manu haemeke wanda꞉halima꞉ta꞉ mo haumanu handaa kone ika꞉ hoke haumanu mina꞉pa꞉lao na la꞉ka꞉la꞉lemeke yeke handaa ");
INSERT INTO ssx_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ipikana꞉ma꞉ koto da teke pa꞉ta꞉manu haemeke wanda꞉hali hando alo alota꞉ A꞉ta꞉e. Kotaasini daoni neke pa꞉ta꞉ ka꞉nda꞉ tieke ma꞉nda꞉ ipuluekema꞉ pila꞉me. Betesaidao. Neke pa꞉ta꞉ make kutu piki hau kone ipuluekema꞉ pila꞉me. I̱ma꞉ mo ipiliki pa꞉ta꞉ pua꞉ na handeke haumanu a꞉nda꞉ mo hande daoni yaapo Taiya Saidoni pa꞉ta꞉ pua꞉ka꞉na꞉ yoluta꞉ kota꞉ koto da yaapo pa꞉ta꞉ haleme wanda꞉hali ika꞉ puki la꞉ka꞉la꞉meka꞉ta꞉me laa Koda꞉ma꞉ handena꞉ta꞉ busa꞉ pitikimanu wepia yamaata꞉ lanka꞉ apolo kitulu pimime. ");
INSERT INTO ssx_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","I̱ma꞉ ipiliki pa꞉ta꞉ta꞉ ota꞉ ota꞉ pi alome. Mo pi yokaalu pulu pa꞉la꞉ nate opolo epea꞉ka꞉na꞉ta꞉ kota꞉ Koda꞉ma꞉ mo Taiya Saidoni yaapo pa꞉ta꞉ halo pa꞉la꞉ a꞉ta꞉ma꞉ homa꞉la꞉ ekita꞉ mo ipiliki Kotaasini Betesaida yaapo pa꞉ta꞉ kulu pa꞉la꞉eki ota꞉ haka꞉ta꞉ pao halieke. ");
INSERT INTO ssx_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A꞉pei Kapeneamio. Naka꞉ honema꞉ neketa꞉ oli hepeni nane naka꞉ kone mea a꞉meiyalueke hone wilipe. O dia꞉me. Neketa꞉ ti to hala꞉ ale pa꞉ta꞉ mea tapaalieke. I̱ma꞉ neke pa꞉ta꞉ pua꞉ na handeke haumanu a꞉nda꞉ mo hande Sodomo daoni pa꞉ta꞉ pua꞉ka꞉na꞉ yoluta꞉ kota꞉ koto data꞉ ame pa hao halo pia꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","I̱ma꞉ neke pa꞉ta꞉ ota꞉ ota꞉ pi alome. Mo pi yokaalu pulu pa꞉la꞉ nate opolo epea꞉ka꞉na꞉ta꞉ kota꞉ Koda꞉ma꞉ mo Sodomo halo pa꞉la꞉ a꞉ta꞉ma꞉ homa꞉la꞉ ekita꞉ mo neke Kapeneami pa꞉ta꞉ kulu pa꞉la꞉eki ota꞉ haka꞉ta꞉ pao halieke. ");
INSERT INTO ssx_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Koto toma꞉na꞉ Yesuma꞉ Koda꞉ pa꞉ta꞉ alota꞉ Apa꞉o. Neketa꞉ do kenke oli hepeni yaapona꞉ Tekehalio. Keiyae tieke aloe. Pa ekipeke. Nakana꞉ma꞉ mo hande handa꞉wiki wanda꞉hali pa꞉ta꞉ a꞉mbao wina꞉ le hau manuta꞉ pa mo hone wopu na wiki wanda꞉hali pa꞉ta꞉ peneme yaaleme. ");
INSERT INTO ssx_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aowe Apa꞉o. Koto ekita꞉ naka꞉ hone piekeyeke eki yaena꞉yeke pina꞉ aleme laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ala꞉ta꞉ ala꞉ta꞉ paeyaota꞉ ya Apa꞉ma꞉ I̱ pa꞉ta꞉ amba꞉ ka꞉la꞉me. Eiyeketa꞉ hali ma꞉nda꞉ma꞉ ota꞉ na handa꞉la꞉pate Apa꞉ma꞉ homeke handa꞉la꞉me. Koto mandake tupa꞉ kone Apa꞉ta꞉ hali ma꞉nda꞉ma꞉ ota꞉ na handa꞉la꞉pate Eiyekema꞉ homeke handa꞉la꞉me. Koto pa꞉la꞉ ekina꞉ mandane wanda꞉halima꞉ make Ateke handena꞉ Eiyekema꞉ iki ma̱leke lia peneme yaeya꞉ka꞉na꞉ta꞉ handilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mo ka꞉nda꞉piki alemanu tia pominolo hata꞉ soka꞉la꞉ma꞉ homa haleme wanda꞉hali paeyao iki pa꞉ta꞉ ya kulu polo hoto pita꞉la꞉ pa꞉ta꞉ ula꞉ma꞉ muemena꞉ I̱ pa꞉ta꞉ a꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","I̱ma꞉ iki pa꞉ta꞉ kitolo tita꞉ mea ika꞉ peiyokona꞉ tia hata꞉ta꞉ ya hau honda꞉ mea pia꞉pa꞉peke. Pa ekipeke. I̱ta꞉ kimelema꞉ hata꞉ ya pukima꞉ homu pea halome. Koto ekima꞉ta꞉ ikana꞉ma꞉ ika꞉ pukina꞉ lopaasa꞉ ekita꞉ ana꞉na꞉ milimikie. ");
INSERT INTO ssx_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Do I̱ma꞉ ika꞉ peiyokona꞉ tuemena꞉ mea tiaaso tima꞉ta꞉ ika꞉ peiyoko na hoeyaalieke. Kutaa mo I̱ma꞉ mea tipe alo ka꞉nda꞉ta꞉ ka꞉nda꞉ wopu na piki yapa꞉ pilieke alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hosikima꞉ hao hao pea hoki naneta꞉ Yesu ipika꞉ hoki nane telimiki haliweki ame̱le̱ Diu wanda꞉halina꞉ hoto pila꞉ nate homekena꞉ mo widi e manuna꞉ pulu hata꞉ta꞉ mo disaipolo haliwekima꞉ iki tea꞉ pieke handaa widina꞉ kilikimanu honda꞉mipi pea nemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kutu pimikieki mo Pa꞉tisi haliwekima꞉ handaa Yesu pa꞉ta꞉ alota꞉ Handa꞉e. Mo naka꞉ disaipolo haliwekima꞉ piteleme ekita꞉ do Hoto Pila꞉ natena꞉ pia꞉peke na ya꞉la꞉ hau pitolo pitelememe lemekepate ");
INSERT INTO ssx_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Mo hande Deipidi ipika꞉ haliweki ame̱le̱ iki tea꞉ma꞉ homemeke natena꞉ta꞉ Deipidima꞉ pieke ekita꞉ hoto homeke a꞉nda꞉na꞉ na yata꞉pa handemepe. ");
INSERT INTO ssx_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ipikana꞉ma꞉ Koda꞉na꞉ da tukiki pa꞉ta꞉ honda꞉ pambaata꞉ mo Koda꞉ pa꞉ta꞉ wieke palaowa meata꞉ ipika꞉ haliweki ame̱le̱ nemekeme. Koto wanda꞉halima꞉ naama꞉na꞉ pi wieke palaowata꞉ mo yeni peao haemeke da handeteke haemeke haliwekima꞉ homeke napeke yeekeeki kone ikana꞉ma꞉ mea nemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kutupa pi ma꞉nda꞉ mo hande Mosesina꞉ wape pa꞉la꞉ Lo Pi ula꞉ tameiya꞉ pa꞉ta꞉ta꞉ mo hande yeni peao haleme haliwekima꞉ mo Hoto Pila꞉ nate paeyao nina꞉ koto natena꞉ pi ula꞉eki yamba꞉la꞉tiki pu halemepate ikana꞉ma꞉ ata꞉ka꞉ na pea꞉tiki pu halememe. Kutu piki wape ma꞉nda꞉ a꞉nda꞉ na yata꞉pemepe. ");
INSERT INTO ssx_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pate mo koto tembolo da ota꞉ lombei piki ala꞉ta꞉ ma꞉nda꞉ homeke do a꞉pa ula꞉me laa iki pa꞉ta꞉ alome. ");
INSERT INTO ssx_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mo Baiboloma꞉ alota꞉ I̱ta꞉ mo lia kita꞉la꞉ hoteke manuta꞉ hone na pa꞉la꞉pate pa mo a꞉ta꞉ma꞉ homaa tamba꞉ mina꞉la꞉ hau homeke hone pa꞉la꞉mee la꞉la꞉ pina꞉ tekemanu a꞉nda꞉ hone wopu wimika꞉na꞉ yoluta꞉ kota꞉ ikana꞉ma꞉ mo ata꞉ka꞉ na peao haleme wanda꞉hali pa꞉ta꞉ hoke hau peleme pi na lolo pimime. ");
INSERT INTO ssx_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pa ekipeke mo Wanda꞉halina꞉ Eiyeketa꞉ mo Hoto Pila꞉ natena꞉ handeteke hala꞉ tekehali kone hala꞉me alome laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuma꞉ koto pa꞉ta꞉ mina꞉pa꞉lao pulu hata꞉ mo Diu haliwekina꞉ yeni peao haemeke da ma꞉nda꞉ tukiki pa꞉ta꞉ honda꞉ pambaata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","kiki hapueke endiki hali homeke koto da pa꞉ta꞉ hayekeme. Mandane halima꞉ta꞉ Yesuta꞉ pi ula꞉ ekina꞉ yamba꞉la꞉la꞉ somee loluekema꞉ yeke ipiki handa꞉ pelia haemekeme. Ikana꞉ma꞉ ipiki lota꞉ pitolo alota꞉ Nika꞉ pi ula꞉eki manuma꞉ta꞉ do Hoto Pila꞉ natena꞉ mo yenimanu epeaapeke hau pia꞉peke ekina꞉ waleke ula꞉pe o dia꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Iki ma꞉nda꞉ hondo naka꞉ sipisipi homeke a꞉nda꞉ mo Hoto Pila꞉ natena꞉ keona꞉ lopea꞉ka꞉na꞉ta꞉ nakana꞉ma꞉ kutaa kone hopula꞉ mea a꞉meiyapeke na yelia꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kutu pieke ekina꞉ halina꞉ tombota꞉ mo sipisipina꞉ yenki ota꞉ lombei pa꞉la꞉me. Koto ekina꞉ta꞉ mo Hoto Pila꞉ natena꞉ kone wanda꞉hali ma꞉nda꞉ tamba꞉ miomono nika꞉ Lo Pi ula꞉eki manuma꞉ waleke wiawala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Koto pi la paeyeke Yesuma꞉ mo kiki hapueke endiki some pa꞉ta꞉ alota꞉ Naka꞉ kiki tindipae leekeme. Koto leeke ipika꞉ kiki tindipaeyekeme. Tindipata꞉ mo kiki epeata꞉ ipika꞉ epeke kiki ma꞉nda꞉ leke kone hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kutu pieketa꞉ kota꞉ mo Pa꞉tisi haliwekima꞉ koto da mina꞉pa꞉lao hama puaata꞉ Yesu luekema꞉ a꞉nda꞉ lomba꞉ wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ipiki luekema꞉ a꞉nda꞉ lomba꞉ wimikieki Yesuma꞉ opuaata꞉ koto pa꞉ta꞉ mina꞉pa꞉lao peekeme. Kutu pieketa꞉ wanda꞉hali wopuma꞉ ipiki telimea pemekeme. Yesuma꞉ ika꞉ homa꞉pa wimiki wanda꞉hali paeyao epeao haena꞉ laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ikana꞉ma꞉ ipika꞉ biki mandane wanda꞉hali pa꞉ta꞉ la halaama꞉na꞉ yeke na lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ipikana꞉ma꞉ kutu piki hauta꞉ Koda꞉ma꞉ mo hande potopede hali Aisaya pa꞉ta꞉ yama꞉ la꞉ wieke yekeeki peneme yaaluekema꞉ pate piekeme. Aisayama꞉ wape pieke pi manuta꞉ dupa la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Do ya e pokaasa꞉ halita꞉ I̱ma꞉ ma̱leke lia do haena꞉ lolome. I̱ma꞉ ipikita꞉ pukima꞉ wopu homo hata꞉ ya pukima꞉ ta꞉na꞉ wopu pa꞉la꞉me. Ya temokota꞉ ipiki tukiki pa꞉ta꞉ pitina꞉ tapaalueke. Kutu poa꞉ka꞉na꞉ta꞉ ipikana꞉ma꞉ mo kenke paeyaona꞉ haleme tapake paeyao pa꞉ta꞉ ya tiki tiki peaasa꞉ pimanu la hawalieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ipikana꞉ma꞉ ma꞉nda꞉ lu tombualuekema꞉ mineke pi make o lu tombuake pi na lelieke. Kutupa mo pota꞉ ka꞉pa nina꞉ hata꞉ make pi tiekemanu na lelieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Hambe homeke ma꞉nda꞉ hosiki tonda꞉pa꞉ hata꞉ pou tea꞉ka꞉na꞉ta꞉ ipikana꞉ma꞉ ota꞉ na tonda꞉pa꞉ mea baalieke. Kutupa mo ola꞉pake homekena꞉ lankake siki make na lu honialieke. Ipikana꞉ma꞉ mo tiki tiki piki hau manuma꞉ bepolaena꞉ loluekema꞉ yeketa꞉ mo ipika꞉ e poka꞉la꞉eki na mina꞉pa꞉lake pa poka꞉tiki pu halieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kutupa kenke paeyaona꞉ haleme tapake wanda꞉hali ipiki pa꞉ta꞉ hone tulao yu wia hao halieke la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Koto pita꞉ma꞉ta꞉ mandane wanda꞉halima꞉ hali homeke Yesu pa꞉ta꞉ hatuku mea epemekeme. Koto some ipika꞉ puki pa꞉ta꞉ hoke temoko pitieke ekima꞉ leke holu peao pi na lao piekeme. Yesuma꞉ mo some wamo pieketa꞉ ipika꞉ leke kila handolo hata꞉ pi epeke tupa꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kutupa mo hande mombelemeke wanda꞉halima꞉ kutu pia꞉eki handolo ikana꞉ma꞉ tola꞉tia pominolo alota꞉ Do someta꞉ Deipidina꞉ eiyeke yaalo pa꞉la꞉me laa lota꞉ lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Do lota꞉ lota꞉ pimiki pimanu opua mo Pa꞉tisi haliwekima꞉ hombo peaaso alota꞉ Do somema꞉ hoke temokomanu tolu hala꞉ ekita꞉ mo hoke temoko paeyaona꞉ you temoko Bielisibuluna꞉ welema꞉ kone pia꞉ka꞉ta꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mo haliwekina꞉ wimiki hoke honemanu Yesuma꞉ handolo iki pa꞉ta꞉ alota꞉ Homeke kenke wanda꞉halima꞉ ika꞉ kone putupa꞉ alualu pea a꞉nda꞉ lia꞉ka꞉na꞉ta꞉ kota꞉ koto kenke wanda꞉hali homeke pa꞉ta꞉ momba꞉la haleme ekita꞉ a̱i̱ koto kone paelieke. Kutupa homeke da wanda꞉hali make o homeke tapake sunuma꞉ ika꞉ kone putupa꞉ alualu pea a꞉nda꞉ pimika꞉na꞉ta꞉ kota꞉ koto tapaketa꞉ epeke tupa꞉ hapeke na yelieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Koto tupa꞉ kone mo Sadanina꞉ kilu tombuao hala꞉eki pa꞉ta꞉ta꞉ kalale ya alu pea a꞉nda꞉ pu alu pipika꞉na꞉ta꞉ kota꞉ ipika꞉ kilu tombuao hala꞉ ekita꞉ amba꞉ tekilipa꞉ alu pea a̱i̱ paelieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ikana꞉ma꞉ I̱ hotiolo hata꞉ Do somema꞉ hoke temokomanu tolu hala꞉ ekita꞉ Bielisibuluna꞉ welema꞉ pia꞉ka꞉ta꞉me aleme ekina꞉ teke a꞉nda꞉ ota꞉eki ya꞉ka꞉na꞉ta꞉ kota꞉ mo ika꞉ disaipolo haliwekima꞉ mo hoke temokomanu teliaena꞉ yeke wele peake hauta꞉ epina꞉ welema꞉ peaasemepe. Mo ika꞉ disaipolo haliwekima꞉ pu haleme hauma꞉ walolota꞉ mo ika꞉ aleme pita꞉ ota꞉ pi na alememe. ");
INSERT INTO ssx_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dia꞉me. I̱ma꞉ mo hoke temokomanu teliolo weleta꞉ Bielisibuluna꞉ welema꞉ na pitolopate Koda꞉na꞉ Sipitidina꞉ welema꞉ peaaso haena꞉ pitolome. Koto ekina꞉ta꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekita꞉ iki teke pa꞉ta꞉ a꞉pa hala꞉pate na handelememe. ");
INSERT INTO ssx_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Honkopu hake somena꞉ data꞉ ma꞉nda꞉ma꞉ pa yamba꞉la honda꞉ pamba pua ipika꞉ alemanu mia꞉peke na ya꞉la꞉me. Pate ipikana꞉ma꞉ mo da tekehali amba꞉la mina tonkao wina꞉ laata꞉ kota꞉ ipika꞉ ula꞉ alemanu hone pa꞉la꞉ tupa꞉ talo pea mea pelieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mandali epi a꞉nda꞉ yaeki na haya꞉ka꞉na꞉ta꞉ kota꞉ koto somema꞉ta꞉ I̱ pa꞉ta꞉ a꞉nda꞉ lita꞉la꞉me. Kutaa make mandali epima꞉ I̱ tapu na mombelea꞉ka꞉na꞉ta꞉ kota꞉ koto somema꞉ta꞉ hoela꞉ lita꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Koto ekina꞉ta꞉ I̱ma꞉ iki pa꞉ta꞉ dupa alome Wanda꞉halima꞉ pimiki hoke haumanu make hoke hoke pimanu lo haleme ekimanu make kotoeki paeyao Koda꞉ma꞉ pa paeyaapeke ya꞉la꞉pate pa hali epima꞉ mo Holi Sipitidina꞉ biki hoeyaeya꞉ka꞉na꞉ta꞉ kota꞉ Koda꞉ma꞉ ipika꞉eki ota꞉ na paeyaalieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mandali epita꞉ mo Wanda꞉halina꞉ Eiyekena꞉ biki pa꞉ta꞉ pi lea꞉ka꞉na꞉ta꞉ kota꞉ koto hoke pi aleme ekita꞉ Koda꞉ma꞉ ana꞉na꞉ paeyaapeke ya꞉la꞉pate pa mo Holi Sipitidi hoeyaaluekema꞉ pi ma꞉nda꞉ lea꞉ka꞉na꞉ta꞉ kota꞉ ipika꞉ ekita꞉ Koda꞉ma꞉ ame do make wetepe make ota꞉ na paeyawalieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Epeke kilikimanu ta la꞉la꞉ ekima꞉ta꞉ epeke ti hala꞉eki peneme yaasa꞉me. Pate hoke ti haya꞉ka꞉na꞉ta꞉ kota꞉ hoke kiliki kone talipikie. Ti paeyaona꞉ hala꞉ hauta꞉ ika꞉ kiliki a꞉ilia꞉ ekima꞉ peneme yaalieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ketoma꞉ handeke some hombo ikita꞉ hoke some hombo haemeka꞉na꞉ta꞉ ekipa epeke pimanu lo hapa꞉peke yelemepe. Pa ekipeke. Mo hone pa꞉ta꞉ tumba ula꞉eki kone kake pa꞉ta꞉ a꞉pa꞉tiki pu hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Epeke halima꞉ta꞉ ipika꞉ puki pa꞉ta꞉ wilia꞉ hone epeke manuta꞉ ipika꞉ pilia꞉ hauma꞉ peneme yao walieke. Koto tupa꞉ kone hoke halima꞉ ipika꞉ puki pa꞉ta꞉ wilia꞉ hoke hone manuta꞉ ipika꞉ pilia꞉ hauma꞉ peneme yao walieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Mo pi yokaalu pulu pa꞉la꞉ nate tieke opolo epea꞉ka꞉na꞉ta꞉ mo wanda꞉hali ika꞉ leme handiki na piki pimanu paeyao Koda꞉ma꞉ ana꞉ piki tupa꞉ kone telipalieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Neketa꞉ hoke halie o epeke halie pita꞉ ika꞉ leme pi kone Koda꞉ma꞉ mea telipeao la kilieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mandane Pi Ula꞉eki wala꞉la꞉ haliweki pita꞉ Pa꞉tisi halimanu tonka꞉na꞉ ikana꞉ma꞉ Yesu pa꞉ta꞉ alota꞉ Disao. Mo na handeke hau homeke handa꞉mono nakana꞉ma꞉ pie lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesuma꞉ koto lemeke pi opuolo alota꞉ A꞉pei do hoke hau pu haluekema꞉ Koda꞉ kiao haleme wanda꞉halio pa ekipeke handaa mo na handeke hau ma꞉nda꞉ handuluekema꞉ alemepe. Dia꞉me. Mo amba꞉ hande Diona pa꞉ta꞉ pieke yeke na handeke pate hau homeke waloa꞉ka꞉na꞉ta꞉ handilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Hande Dionata꞉ ta꞉peli tiekena꞉ weleke pa꞉ta꞉ timba꞉ tepo nate tepo pea pitiekeme. Kota꞉ mo Wanda꞉halina꞉ Eiyeke make mandake tupa꞉ kone timba꞉ tepo nate tepo pea kenke tukiki pa꞉ta꞉ wilieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mo Koda꞉na꞉ pi yokaalu pulu pa꞉la꞉ nate opolo epea꞉ka꞉na꞉ta꞉ mo hande Ninipa wanda꞉halima꞉ Dionana꞉ waleeke pi opua ika꞉ hoke hau mina꞉pa꞉lao puki la꞉ka꞉la haemeke handaata꞉ ikana꞉ma꞉ tiao hata꞉ iki la꞉ mea lopaalieke alome. Pa ekipeke. Ameta꞉ iki pa꞉ta꞉ta꞉ mo hande Diona ota꞉ lombei piki hali ma꞉nda꞉ ta a꞉pa hala꞉ handepe. ");
INSERT INTO ssx_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mo Koda꞉na꞉ pi yokaalu pulu pa꞉la꞉ nate opolo epea꞉ka꞉na꞉ta꞉ mo hande Siba kenkena꞉ kuini wanda꞉ta꞉ mo hande hone wopu wieke kini hali Solomonoma꞉ leeke epeke mana꞉ pimanu opuluekema꞉ papate hao epeeke handaata꞉ ipikana꞉ma꞉ tiao hata꞉ iki la꞉ mea lopaalieke. Pa ekipeke. Ameta꞉ iki pa꞉ta꞉ta꞉ mo hande Solomono ota꞉ lombei piki hali ma꞉nda꞉ ta a꞉pa hala꞉ handa꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Hoke temoko ma꞉nda꞉ hali ma꞉nda꞉na꞉ puki mina꞉pa꞉lao ala꞉ta꞉ ala꞉ta꞉ na opeke kenke tukiki pa꞉ta꞉ pominolo hata꞉ ipiki pita꞉peke epeke da panda꞉ ma꞉nda꞉ weiliepate pa na handa꞉ wia꞉ka꞉na꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ipikana꞉ma꞉ Ya da nane paa la꞉ka꞉la polueke laa paa la꞉ka꞉la pua mo hande mina꞉pa꞉layeke data꞉ ma꞉nda꞉ na hake wamo pea bao epeke hau pea wilia꞉eki handilieke. ");
INSERT INTO ssx_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kutupa ipika꞉ pu hala꞉ hoke haumanu ota꞉ lombei peao pu hake hoke mandane watake hata꞉ temokomanu ma꞉nda꞉ hatuku mea a꞉paata꞉ ipiki ame̱le̱ mo hande da pa꞉ta꞉ honda꞉ pamba hao halimikie. Kutu pimika꞉na꞉ta꞉ mo hande halima꞉ hande amba꞉ pieke hoke hau ota꞉ lombei peake hoke hau pilieke. Kutu piki hauta꞉ ame do haleme hoke wanda꞉hali pa꞉ta꞉ make opolo ipilieke alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuma꞉ koto wanda꞉hali pa꞉ta꞉ pimanu panake alo haena꞉ta꞉ ipika꞉ inkiki hameketonu opolo epemekeme. Ikana꞉ma꞉ da hama꞉ nane a꞉pa hata꞉ Yesu pa꞉ta꞉ pi lomono epena꞉e laa honke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kotoeki opuaata꞉ hali ma꞉nda꞉ma꞉ Yesu pa꞉ta꞉ alota꞉ Yesuo. Naka꞉ ama꞉ kame tonuma꞉ neke ame̱le̱ pi loluekema꞉ hama꞉ nane a꞉pa yu wia halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Epita꞉ ya ama꞉pe o epita꞉ ya kame tonupe. ");
INSERT INTO ssx_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Koto pi alo hata꞉ta꞉ ipikana꞉ma꞉ ipika꞉ hoki nane telimiki wanda꞉hali ma̱leke litolo hata꞉ alota꞉ Ya ama꞉ kame tonuta꞉ do handa꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mo ya hepeni nane hala꞉ Apa꞉na꞉ hone pa꞉la꞉ haumanu peao haleme wanda꞉halita꞉ ikita꞉ ya ana꞉ ama꞉ kametonue leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Koto natena꞉ kone Yesuma꞉ mo da mina꞉pa꞉lao mo hande ikali leke mone tea꞉na꞉ pua wanda꞉hali pa꞉ta꞉ pi walo pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wanda꞉hali wopu ipiki pa꞉ta꞉ a꞉pa mombelemeke handaata꞉ Yesuma꞉ mo wanda꞉hali ikali tea꞉na꞉ haena꞉ ipikita꞉ palai kawaso pa꞉ta꞉ pua pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kutupa ipikana꞉ma꞉ iki pa꞉ta꞉ onkoluma꞉ laa pimanu wopu waleekeme. Dupa leekeme. Nate ma꞉nda꞉na꞉ hali ma꞉nda꞉ma꞉ wae alemanu tande loluekema꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kutupa ipikana꞉ma꞉ tande lea꞉tiki pulu haena꞉ mandane wae manuta꞉ pota꞉na꞉ lopa꞉ lopa꞉ pieke ekita꞉ ba titima꞉ a꞉pa talopu nemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kutaata꞉ mandane wae manuta꞉ toopimanu manda taleeke kenke sikina꞉ lopeekeme. Mo kenketa꞉ aneke na wiekeeki yaalo mo wae sunuta꞉ koto kone opeekepate ika꞉ piki onina꞉ toluma꞉ wopu na puayeke ekina꞉ ");
INSERT INTO ssx_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","nate talo hata꞉ta꞉ pou ta hapiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kutaata꞉ mandane wae manuta꞉ tekeke hake ale polu pa꞉ta꞉manu lopeekeme. Kutupa tekeke hake alemanu opa꞉liaaso hata꞉ hande wae alemanu opolo pieke ekita꞉ tombuaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kutu piekepate mandane wae ale manuta꞉ epeeke kenkena꞉ lopeeke handaa napeke epeke tupa꞉ wiekeeki manuta꞉ dupae. Mandaneeki 100 tupa꞉ mandaneeki 60 tupa꞉ mandaneeki 30 tupa꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kutupa Yesuma꞉ koto ipika꞉ onkoluma꞉ pi paeyaaso alota꞉ Katake lomba꞉la꞉ halima꞉ wotu opina꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Koto hoki naneta꞉ mo disaipolo haliwekima꞉ Yesu pa꞉ta꞉ a꞉pa lota꞉ pitolo alota꞉ Nakana꞉ma꞉ do wanda꞉hali pa꞉ta꞉ pi alo hata꞉ta꞉ ekipeke onkoluma꞉ pima꞉ la halepe. ");
INSERT INTO ssx_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Mo hepenina꞉ Kilu Tombuao Hala꞉ ekina꞉ a꞉mbao ula꞉ hone manuta꞉ ikita꞉ opua hone wilimipate mo wanda꞉halita꞉ hone na wina꞉yeke onkoluma꞉ pi alome. ");
INSERT INTO ssx_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pa ekipeke. Ala꞉ta꞉manu amba꞉ wia hala꞉ somema꞉ta꞉ ipika꞉eki lombei pina꞉ loluekema꞉ haka꞉ta꞉ pao halia꞉ka꞉na꞉ milieke. Pate ala꞉ta꞉manu wopu na wiki natehali someta꞉ ipika꞉ wia hala꞉ alesiki kone ma꞉nda꞉ma꞉ yoka꞉ mea pelieke. ");
INSERT INTO ssx_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","I̱ma꞉ do onkoluma꞉ pimanu laa iki pa꞉ta꞉ pi alo ekina꞉ teketa꞉ do ekina꞉yeke alome. Ika꞉ lekema꞉ta꞉ handa꞉peke ya꞉la꞉pate na handelememe. Ikana꞉ma꞉ opuluekema꞉ katake wia pelimipate pa na opu make hone na wilimiki handaa alo alome. ");
INSERT INTO ssx_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mo hande potopede hali Aisayama꞉ wape pieke wapena꞉ la꞉ ula꞉ pita꞉ ame do wanda꞉halima꞉ yaalememe. Koto yaaleme ekita꞉ dupa Do wanda꞉halima꞉ opitolo opitolo halo pelemepate ika꞉ hone pa꞉ta꞉ na wilimikie. Kutaa make handolo handolo halo pelemepate ika꞉ honema꞉ta꞉ na handilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Pa ekipeke. Ika꞉ hone manuta꞉ timba꞉ lo make ika꞉ katakemanu poko make ika꞉ lekemanu handupu pelememe. Koda꞉ma꞉ alota꞉ Kutu piki haumanu na pia꞉ka꞉na꞉ yoluta꞉ ika꞉ lekema꞉ epeke hando make ika꞉ katakema꞉ epeke opu make ika꞉ honema꞉ epeke hone wia hata꞉ ikana꞉ma꞉ I̱ pa꞉ta꞉ la꞉ka꞉la epolo pimika꞉na꞉ yoluta꞉ kota꞉ I̱ma꞉ iki wamo pulu pua꞉me la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amba꞉ta꞉ Aisayama꞉ kutu piki pi leekepate ameta꞉ I̱ma꞉ iki pa꞉ta꞉ dupa alome. Ikana꞉ma꞉ ta꞉na꞉ma꞉ homo hapa꞉peke. Pa ekipeke. Ika꞉ lekema꞉ta꞉ ala꞉ta꞉ ala꞉ta꞉ handa꞉pa꞉peke yo make ika꞉ katakema꞉ pi epeke opu pia꞉peke ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Amba꞉ haemeke potopede haliweki wopuma꞉ make mandane tikitiki piki haliweki wopuma꞉ make ikana꞉ma꞉ ame do handeleme haumanu handuluekema꞉ hone wopu pieke taapo haemekepate na handemekeme. Koto haliwekima꞉ta꞉ do opueleme pimanu make opuluekema꞉ hone wopu pieke taapo haemekepate na opimikime. ");
INSERT INTO ssx_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Mo wae ale nokopa꞉la꞉ onkoluma꞉ pi alo ekina꞉ teketa꞉ hone wopu uemena꞉ma꞉ ikana꞉ma꞉ wopu opua꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mo hande Koda꞉na꞉ Kilu Tombuao Hala꞉ ekina꞉ pi wala꞉la꞉ ekina꞉ pi opitelemepate hone wopu wia na mea mendieleme wanda꞉hali ikita꞉ mo hande pota꞉na꞉ lopeeke wae manuma꞉ handelememe. Ika꞉ puki pa꞉ta꞉ nokopeeke pi manuta꞉ Sadanima꞉ a̱i̱ a꞉pa yoka꞉ mea pula꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kutupa mo waleme pi opuolo hata꞉ ta꞉na꞉ma꞉ homaa a̱i̱ mea miniki haleme wanda꞉hali ikita꞉ mo hande toopi manda wieke kenkesiki pa꞉ta꞉ lopeeke wae manuma꞉ handelememe. ");
INSERT INTO ssx_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mo opiteleme pita꞉ ika꞉ puki tukiki nane wopu na wina꞉ alemeke handaa hosiki hao hao peaata꞉ koto kone paelieke. Pa ekipeke. Mo Pi Seliapo wala꞉la꞉ ekina꞉ kiaasa꞉ halima꞉ta꞉ iki pa꞉ta꞉ tanda o ka꞉nda꞉manu hala꞉leketa꞉ kota꞉ koto kone lopo halememe. ");
INSERT INTO ssx_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kutupa mo hande tekeke hake pu polu pa꞉ta꞉ lopeeke wae alemanu tupa꞉ta꞉ mandane wanda꞉halima꞉ pi epeke tupa꞉ opua miniki halemepate do kenkena꞉ haumanu pa꞉ta꞉ hone tieke eleke eleke wopu witelemeeki pita꞉ mani tieke wopu amu pulueke hone witelemeeki yaapoma꞉ Koda꞉na꞉ pi tombuatiki pina꞉ lea꞉ka꞉na꞉ta꞉ epeke kilikimanu na a꞉ilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kutu pu halemepate mo waleme pi opuolo epeke mea miniki haleme wanda꞉hali ikita꞉ mo epeke kenkena꞉ lopeeke wae manuma꞉ handelememe. Ika꞉ kiliki a꞉elo peleme tupa꞉ta꞉ dupa. Mandane wanda꞉hali ika꞉ kilikita꞉ 100manu tupa꞉ mandane ekita꞉ 60manu tupa꞉ mandane ekita꞉ 30manu a꞉eyeke tupa꞉ halimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Koto la paeyeketa꞉ Yesuma꞉ iki pa꞉ta꞉ onkoluma꞉ pi ma꞉nda꞉ta꞉ dupa leekeme. Mo hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ dupiki hone wia꞉pa꞉peke. Hali homekema꞉ ipika꞉ e pa꞉ta꞉ epeke waemanu tande laa peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kutupa peeke hoki naneta꞉ timba ma꞉nda꞉na꞉ mo wanda꞉hali u pelia pemeke naneta꞉ ipika꞉ a꞉nda꞉ tunkuliki hali homeke a꞉pa mo hande epeke wae taapuna꞉ hoke wae tande la꞉ pamba peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mo hande epeke wae alemanu opa napeke honke pankeeke pita꞉ma꞉ta꞉ kota꞉ mo hande hoke ambu apa꞉tao opekeeki manuta꞉ peneme yeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Koto ekina꞉ mo hande e teke halina꞉ e pokaeyeke haliwekima꞉ ipiki pa꞉ta꞉ a꞉pa alota꞉ Tekehalio. Naka꞉ ena꞉ epeke kiliki homeke tande lepate do hoke ambu manuta꞉ ekipa a꞉pa hao pa꞉la꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ipikana꞉ma꞉ ika꞉ pi hombo peaaso alota꞉ Ya a꞉nda꞉ tunkuliki hali ma꞉nda꞉ma꞉ do hoke wae tande alo pia꞉me leekeme. Koto leeke ikana꞉ma꞉ alota꞉ Mo hoke ambu manuta꞉ nikana꞉ma꞉ talo baalo pomonope laa lota꞉ pimiki handaa ipikana꞉ma꞉ ");
INSERT INTO ssx_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ika꞉ pi hombo peaaso alota꞉ Dia꞉me. Mo hoke ambu talemeka꞉na꞉ta꞉ mo epeke kilikimanu tonka꞉na꞉ talo baama꞉na꞉ma꞉ ");
INSERT INTO ssx_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","mo napeke naa pilia꞉ nate epena꞉ yu wia hata꞉ hokeeki epekeeki pa apa꞉tao opena꞉e. Koto nate opolo epea꞉ka꞉na꞉ta꞉ I̱ma꞉ mo napeke momba꞉la꞉la꞉ haliweki pa꞉ta꞉ mo hoke ambu amba꞉la talo tonka tonka pea tia pua panane yanka꞉pa꞉peke lolueke. Kutaata꞉ mo epeke napekemanu talaata꞉ ya amu pitolo da pa꞉ta꞉ wia꞉pa꞉peke lolueke lea꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuma꞉ta꞉ iki pa꞉ta꞉ onkoluma꞉ pi ma꞉nda꞉ la halolo hata꞉ alota꞉ Mo hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ dupiki hone wia꞉pa꞉peke. Hali homekema꞉ ipika꞉ e pa꞉ta꞉ mo ki̱mi̱le̱ma꞉ handeke ale masidadi kiliki nokopa peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mo kilikita꞉ ota꞉ hodikale siki yeke kiliki yekepate ipika꞉ opolo hata꞉ta꞉ mandane wae manuna꞉ opa꞉la꞉ tombo lombei peao opaa ti tupa꞉ halieke. Kutu pia꞉ka꞉na꞉ta꞉ kota꞉ bamanu a꞉pa ipika꞉ paleke pa꞉ta꞉manu ika꞉ dakemanu halimikie. ");
INSERT INTO ssx_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesuma꞉ iki pa꞉ta꞉ onkoluma꞉ pi ma꞉nda꞉ paa la haleekeme dupa. Mo hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ yisitima꞉ handa꞉la꞉me. Wanda꞉ homekema꞉ mo yisitimanu mea sini tieke tumbiki palaowa tapu dakole pealieke. Kutu pilia꞉ hoki naneta꞉ koto palaowa paeyao pombei ya halieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuma꞉ mo hande mombelemeke wanda꞉hali pa꞉ta꞉ waleeke pi paeyaota꞉ onkoluma꞉ma꞉ homeke waleekeme. Ipikana꞉ma꞉ pi homeke siki ma꞉nda꞉ onkoluma꞉ pima꞉ na leke pa na la haleekeme. Dia꞉me. Pi paeyaota꞉ ota꞉ onkoluma꞉ pima꞉ homeke waleekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Koto pieke ekita꞉ amba꞉ hande potopede halima꞉ la꞉ wieke pimanu yaena꞉ yeke piekeme. Koto hande potopede halima꞉ la꞉ wieke pita꞉ dupa Wanda꞉hali pa꞉ta꞉ pi loluekema꞉ta꞉ onkoluma꞉ manuma꞉ homeke lolueke. Do kenke wepia wieke ane kini pu mea a꞉pa ame do halome anema꞉ a꞉mbao ula꞉ pi manuta꞉ iki pa꞉ta꞉ I̱ma꞉ peneme yao la halueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuma꞉ koto mombelemeke wanda꞉hali mina꞉pa꞉lao da tukiki pa꞉ta꞉ honda꞉ pambolo haena꞉ ipika꞉ disaipolo haliwekima꞉ ipiki pa꞉ta꞉ a꞉pa alota꞉ Mo hande ena꞉ nokopeeke wae alena꞉ onkoluma꞉ pina꞉ teke niki la kuelena꞉e laa lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesuma꞉ kota꞉ pi hombo peaaso alota꞉ Mo hande epeke wae alemanu tande leeke hali tupa꞉ta꞉ mo Wanda꞉halina꞉ Eiyekee. ");
INSERT INTO ssx_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kutupa mo e tupa꞉ta꞉ do kenkee. Mo epeke waemanu tupa꞉ta꞉ mo Koda꞉na꞉ Kilu Tombuao Hala꞉ pa꞉ta꞉ haleme wanda꞉halie. Mo hande hoke ambumanu tupa꞉ta꞉ mo hoke Sadanina꞉ wanda꞉halie. ");
INSERT INTO ssx_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kutupa mo hande hoke wae tande leeke a꞉nda꞉ tunkuliki some tupa꞉ta꞉ Sadanie. Mo napeke momba꞉lapeke nate tupa꞉ta꞉ do kenke paelo pa꞉la꞉ekie. Kutupa napeke mombeleeke haliweki tupa꞉ta꞉ mo hande enisolo haliwekie. ");
INSERT INTO ssx_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pa mo hande hoke ambumanu yoka mea tonkao pua tina꞉ momba꞉la yankolo pieke tupa꞉ta꞉ kota꞉ do kenke ya paelia꞉ dina꞉ make mandake hau kone pilieke. ");
INSERT INTO ssx_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Koto dina꞉ta꞉ mo Wanda꞉halina꞉ Eiyekema꞉ ipika꞉ enisolomanu tapaalieke. Ikana꞉ma꞉ ipika꞉ Kilu Tombuao Hala꞉ ekina꞉ tukiki pa꞉ta꞉ hala꞉ hoke hau pu haleme wanda꞉hali pita꞉ mo hoke haumanu pu tiaasa꞉ wanda꞉halimanu paeyao tonka꞉na꞉ paeyao yokilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kutaata꞉ mo hoke wanda꞉hali paeyaota꞉ mo enisolo manuma꞉ tonuma꞉ ti tieke to hala꞉ alena꞉ mea lopaalimikie. Koto pa꞉ta꞉ta꞉ ika꞉ kake lenkene laaso hata꞉ e̱ wi lo halimikie. ");
INSERT INTO ssx_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Koto natena꞉ta꞉ mo ika꞉ Apa꞉na꞉ Kilu Tombuao Hala꞉ tukiki pa꞉ta꞉ epeke hau peleme wanda꞉hali ikita꞉ mo natena꞉ pa̱a̱ tupa꞉ pu halimikie. Hali epima꞉ ipika꞉ katake lombea꞉ka꞉na꞉ta꞉ kota꞉ do pi ota꞉ opina꞉e. ");
INSERT INTO ssx_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mo hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ do tupa꞉e. Hali homekema꞉ ma꞉nda꞉na꞉ e mopuna꞉ pa peekepate kone amba꞉ haliwekima꞉ ti teke pimikieki handa꞉ wiekeme. Kutupata꞉ ipikana꞉ma꞉ ta꞉na꞉ tiekema꞉ homolo hata꞉ paa a꞉nka꞉la꞉ pambaata꞉ mo ti teke wieke e hamba꞉peke mani mandaneeki wopu muluekema꞉ ipika꞉ wia hayeke alemanu paeyao mandane wanda꞉halima꞉ hambena꞉ tapao mani meaata꞉ koto kone mo ti teke piekeeki handeeke e hambuluekema꞉ paa la꞉ka꞉la peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ do tupa꞉ make ya꞉la꞉me. Hali homekema꞉ mo mani tieke mia꞉peke sekete hapeke beleke seliapo weita꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kutupa ipikana꞉ma꞉ nate homeke a꞉nda꞉ koto beleke teke ota꞉ ta꞉ta꞉ pupapeke seliapo pikieki handa꞉ wia꞉ka꞉na꞉ta꞉ kota꞉ koto beleke teke hambuluekema꞉ ipika꞉ wia hala꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao ma꞉nda꞉ma꞉ hambena꞉ tapaa tapaa pilieke. ");
INSERT INTO ssx_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ do tupa꞉ make ya꞉la꞉me. Mandane ta꞉peli mu haleme haliwekima꞉ ika꞉ tenki nu tieke mea ikali lekena꞉ lopao ta꞉ta꞉ ta꞉ta꞉ piki ta꞉pelimanu paeyao wopu mondu haleme. ");
INSERT INTO ssx_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kutupa mo tenki nu a꞉nda꞉ tumbia꞉ka꞉na꞉ta꞉ kota꞉ ikali tea꞉ nane yola꞉ mea wia hata꞉ hokeeki epekeeki telipa u halememe. Mo epekeeki manuta꞉ ika꞉ kawasomanu pa꞉ta꞉ lopaota꞉ hokeeki manuta꞉ bao halememe. ");
INSERT INTO ssx_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kutupa mo paelo pa꞉la꞉ nate opolo epea꞉ka꞉na꞉ta꞉ koto tupa꞉ kone pilieke. Mo hande enisolo manuma꞉ opolo a꞉paata꞉ mo epeke wanda꞉hali taapu halimi hoke wanda꞉hali talopu mea momba꞉lao ");
INSERT INTO ssx_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mo ti tieke to hala꞉ ale pa꞉ta꞉ mea lopa꞉nialimikie. Koto pa꞉ta꞉ta꞉ ika꞉ kake lenkene laaso hata꞉ e̱ wi lo halimikie. ");
INSERT INTO ssx_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesuma꞉ iki lota꞉ pitolo alota꞉ Do alo pina꞉ tekemanu iki hone wilimipe laa leekeeki ikana꞉ma꞉ hombo peaaso alota꞉ Aowe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Koto lemeke opitolo Yesuma꞉ alota꞉ Hali ma꞉nda꞉ epi a꞉nda꞉ma꞉ta꞉ mo amba꞉ la꞉ wieke Lo Pimanu walo hala꞉ hali hata꞉ta꞉ pa mo hepenina꞉ Kilu Tombuao Hala꞉ ekina꞉ hau paeyao miniki hala꞉ hali make haya꞉ka꞉na꞉ta꞉ kota꞉ koto someta꞉ mo da tiekena꞉ tekehali tupa꞉ hata꞉ ipika꞉ momba꞉la nu pindu hao u hala꞉ da panda꞉ pa꞉ta꞉ pua amba꞉ epeke alemanu make panake epeke alemanu make apa꞉tao mea a꞉pa peneme yaasa꞉ somema꞉ handilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Koto onkoluma꞉ pimanu paeyao la paeyeketa꞉ Yesuma꞉ koto pa꞉ta꞉ mina꞉pa꞉lao ");
INSERT INTO ssx_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ipika꞉ teke da nane paa peekeme. Ipikana꞉ma꞉ ika꞉ pi hotu haemeke da pa꞉ta꞉ pi waleekeeki opitolota꞉ wanda꞉hali wopuma꞉ penkili pimikime. Do somema꞉ dupiki mana꞉ pi manuta꞉ hando pa꞉ta꞉ opia꞉pe laa lota꞉ pualu alu pitolo alota꞉ Mo hande ipika꞉ pieke na handeke hau manuna꞉ teketa꞉ ekipape laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ipikita꞉ mo hande da a꞉eta꞉la꞉ halina꞉ eiyeke kutupa ipika꞉ inkikita꞉ Meti dia꞉yeke yekea. Ipikita꞉ mo hande Dia꞉mesi Diosepe Saimono Diudasi do hama̱la̱꞉ hama̱la̱꞉na꞉ hameke dia꞉yeke yekea. ");
INSERT INTO ssx_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kutupa ipika꞉ beliki tonu make niki ame̱le̱ mandakena꞉ na halemeke yekea laata꞉ Do somema꞉ do ala꞉ pi paeyaota꞉ hando pa꞉ta꞉ mea pa꞉la꞉pe laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ikana꞉ma꞉ ipiki kiaemekeme. Kutu pimiki ekina꞉ Yesuma꞉ iki pa꞉ta꞉ alota꞉ Potopede hali ma꞉nda꞉ta꞉ da ma꞉nda꞉ wanda꞉halina꞉ leke popelekena꞉ta꞉ biki wilia꞉pate pa ipika꞉ teke da nane o ipika꞉ wanda꞉halina꞉ leke popelekena꞉ta꞉ biki na wilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Koto ekina꞉ ikana꞉ma꞉ ipiki pa꞉ta꞉ hone wopu na tulaemeke handaa kota꞉ ipikana꞉ma꞉ make mo na handeke haumanu iki tukiki pa꞉ta꞉ wopu na piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mo hande Ka꞉lili kenke handeteke hayeke hali Hetodima꞉ta꞉ Yesuma꞉ pieke ekina꞉ pi laemeke ekimanu opuaata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ipikana꞉ma꞉ ipika꞉ e pokaemeke haliweki pa꞉ta꞉ alota꞉ Hande lua꞉ hali Dioni paa da꞉taa a꞉pa hala꞉ ekima꞉ wele tieke wopu pitolo hata꞉ mo na handeke haumanu pitolo pila꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Do pi leeke ekina꞉ teketa꞉ hosiki amba꞉ leke Hetodima꞉ Dioni da꞉ka꞉pa꞉ minina꞉ laata꞉ senipuma꞉ tonkao dipula mea pitaena꞉ leekeme. Koto ka꞉nda꞉ epeeke ekina꞉ teketa꞉ mo hande Hetodima꞉ ipika꞉ hameke Pilipina꞉ weteke Hetodiasi mieke ekima꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nate mandaneeki nina꞉ Dionima꞉ Hetodi pa꞉ta꞉ Do wanda꞉ta꞉ naka꞉ wanda꞉ ale ekita꞉ hoke hau piteleme laa pi wopu la꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Koto leeke pita꞉ma꞉ kone Hetodima꞉ Dioni luekema꞉ piekepate mo Diu wanda꞉hali pa꞉ta꞉ paala꞉ma꞉ homeekeme. Pa ekipeke. Mo Diu wanda꞉halina꞉ honema꞉ Dionita꞉ ota꞉ potopede halie hone wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hetodina꞉ mendieke natena꞉ ne tieke pambeekeme. Kutu pieke dina꞉ta꞉ mo hande Hetodiasina꞉ wanekema꞉ mo wanda꞉halina꞉ leke popelekena꞉ ma꞉nda꞉ liekeme. Kutu pieke handaa Hetodima꞉ ta꞉na꞉ wotu pieke handaa ");
INSERT INTO ssx_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","mo wandiki pa꞉ta꞉ ipika꞉ pi tieke la꞉ witolo alota꞉ Nakana꞉ma꞉ I̱ pa꞉ta꞉ aleke ma꞉nda꞉ kie laa honke leka꞉na꞉ta꞉ kota꞉ I̱ma꞉ ota꞉ kulueke laa la꞉ witolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Koto leeke pita꞉ta꞉ inkikima꞉ doeki lapeke laa hone u tiaeyekeeki opuaata꞉ mo wandikima꞉ Hetodi pa꞉ta꞉ honke alota꞉ Ame do siki kone mo hande bapitaisi peao hayeke some Dionina꞉ you tunkula kawasona꞉ wia I̱ pa꞉ta꞉ kie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Koto pi opitolo Hetodima꞉ ta꞉na꞉ma꞉ na homekepate ipika꞉ la꞉ wita꞉la꞉ pita꞉ ipika꞉ kimisu wanda꞉hali paeyaona꞉ leke popelekena꞉ la꞉ wieke ekina꞉ ipiki ya꞉la꞉ mea꞉peke yeke handaa ipika꞉ a꞉ndeli miniki haliweki pa꞉ta꞉ alota꞉ Do wandikina꞉ hone pa꞉la꞉ hau pua peape leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Koto leeke pi opuaata꞉ mo haliwekima꞉ dipula da pa꞉ta꞉ pua Dionina꞉ make tunkulaata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ipika꞉ youta꞉ kawaso manda wia mea a꞉pa mo wandiki pa꞉ta꞉ halemekeme. Mo wandikima꞉ ipika꞉ ama꞉ pa꞉ta꞉ mea pua haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Dionina꞉ disaipolo haliwekima꞉ ipika꞉ toko a꞉pa mea tia ma꞉nda꞉ pa꞉ta꞉ pua hoiyaata꞉ Yesu pa꞉ta꞉ la haluekema꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Dioni lia꞉me lemekeeki opuaata꞉ Yesuma꞉ koto kenke mina꞉pa꞉lao kawasona꞉ pita꞉ mea keneme pa꞉ta꞉ peekeme. Ipiki peekeeki wanda꞉halima꞉ opitolota꞉ ika꞉ teke damanu mina꞉pa꞉lao mo ikali tea꞉ lopa꞉la꞉ ankema꞉ Yesu telimea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesuma꞉ mo kawaso mina꞉pa꞉lao kenke nane opolo pulu hata꞉ wanda꞉hali wopu handaata꞉ ipika꞉ pukima꞉ e̱ alo hata꞉ iki pa꞉ta꞉ a꞉ta꞉ma꞉ homeekeme. Kutupieke ekina꞉ta꞉ mo homa꞉ pa wieke wanda꞉hali mea tiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Koto welealota꞉ ipika꞉ disaipolo haliwekima꞉ ipiki pa꞉ta꞉ a꞉pa alota꞉ Do aneta꞉ keneme nanee. Ameta꞉ nate paeta꞉la꞉me. Da pa꞉ta꞉manu wanda꞉halima꞉ ika꞉ ne hamba꞉tiki pena꞉ tapaa tapaa pie lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Dia꞉me. Na pena꞉ leke ikana꞉ma꞉ nemanu ma꞉nda꞉ mea hala꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ikana꞉ma꞉ paa Yesuna꞉ pi hombo peaaso alota꞉ Nikana꞉ma꞉ do pa꞉ta꞉ta꞉ palaowa wala꞉ yunki hata꞉na꞉ ta꞉peli yaapo pea homeke ula꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesuma꞉ alota꞉ A꞉pa꞉la꞉me. I̱ pa꞉ta꞉ mea ipupe laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","mo wanda꞉hali paeyao ambuna꞉ pitina꞉ lape leekeme. Kutaata꞉ ipikana꞉ma꞉ hande palaowa wala꞉ yunki hata꞉ make hande ta꞉peli yaapo make miniki hata꞉ oli ya nane handa꞉liao Koda꞉ pa꞉ta꞉ keiyae laata꞉ palaowa wala꞉ pindi pindi pea ipika꞉ disaipolo haliwekima꞉ mea wanda꞉hali mina꞉yeke hale hale piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kutupa paeyaoma꞉ ana꞉na꞉ naaka꞉na꞉ alota꞉ weleke tala꞉me lemekeme. Mo wanda꞉hali pa꞉ta꞉ pa wieke putupilikimanu meaata꞉ ala꞉ta 12 tumbaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kutupa mo hande palaowa wala꞉sunu nemeke haliwekita꞉ mo wekiwanda꞉ na apa꞉take pa haliweki homeketa꞉ 5 daoseni halima꞉ nemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kutaata꞉ mo hande wanda꞉hali tapaaluekema꞉ hata꞉ta꞉ Yesuma꞉ ipika꞉ hoke nane telimiki haliweki pa꞉ta꞉ alo hata꞉ alota꞉ Mo kawasona꞉ pita iki amba꞉la mone tea꞉na꞉ pulu hape laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ipikana꞉ma꞉ mo wanda꞉hali tapao hoki naneta꞉ oli pote elina꞉ ipika꞉ siki yeni puluekema꞉ a꞉meiyekeme. Kutupa nate pambolo haena꞉ta꞉ Yesu ipika꞉ siki oli pa꞉ta꞉ hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Koto nate lekena꞉ta꞉ mo hande kawasota꞉ mo ikali leke tukikina꞉ pulu haena꞉ po tiekema꞉ ika꞉ wenoko nanema꞉ a꞉pa ambulaaso hata꞉ ika꞉ kawaso wopu mea a꞉meiyaaso lopaaso piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Koto ekina꞉ da ka꞉la꞉puluekema꞉ okona꞉ Yesuta꞉ mo disaipolo haliweki haemeke alena꞉ poluekema꞉ ikali manda ankena꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mo haliwekima꞉ ipiki ikali manda ankena꞉ epeekeeki handolo iki paeyaoma꞉ paala꞉ma꞉ wotu homolo hata꞉ Temokoe laa e̱ wi lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kutu pimikipate koto kone Yesuma꞉ iki pa꞉ta꞉ pi alo hata꞉ alota꞉ Honkopu hapee. Dota꞉ I̱e. Paala꞉ma꞉ na homa꞉pepee leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Koto leeke Pidama꞉ Yesu pa꞉ta꞉ alota꞉ Tekehalio. Neketa꞉ ota꞉ neke ya꞉ka꞉na꞉ta꞉ kota꞉ I̱ tiao do ikali manda a꞉pa neke pa꞉ta꞉ a꞉pono nakana꞉ma꞉ I̱ epo laa lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesuma꞉ alota꞉ A꞉pa꞉la꞉me. Epoe leeketa꞉ Pidama꞉ tiao mo ikali manda kini pu mea Yesu pa꞉ta꞉ peekepate ");
INSERT INTO ssx_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ipikana꞉ma꞉ mo hande po tilipuma꞉ piekeeki handolo hata꞉ paala꞉ma꞉ homeekeme. Kutupa mo ikali pa꞉ta꞉ ipiki kini pea honki alo hata꞉ alota꞉ Tekehalio. I̱ tamba꞉ minie laa wi leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kota꞉ koto kone Yesu ipika꞉ kiki tindipa moneao ta꞉nka꞉pa꞉ minolo alota꞉ Neketa꞉ hosiki hone tulaake someo. Pa ekipeke hone yaapo yaapo wipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Koto laata꞉ ipiliki telipina꞉ mo kawasona꞉ pitulu pepeketa꞉ mo po tieke u pa lopeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mo kawasona꞉ pitimiki disaipolo haliwekima꞉ koto pieke hau handolo hata꞉ta꞉ ikana꞉ma꞉ Yesuna꞉ biki a꞉meiyaaso alota꞉ Ota꞉e. Neketa꞉ ota꞉ Koda꞉na꞉ Eiyekee laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mo ikali leke tunkula꞉ moneao mone tea꞉na꞉ hayeke Kenesatete da pa꞉ta꞉ opolo pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mo pa꞉ta꞉ haemeke wanda꞉halima꞉ ipika꞉ leke popeleke handolo hata꞉ hone wimiki ekina꞉ta꞉ mo da teke nepoko nepoko haemeke da pa꞉ta꞉manu haemeke yeni hapa wimiki wanda꞉hali paeyao Yesu pa꞉ta꞉ mea ipupa꞉e laa pi tapaa tapaa pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kutupa mo pa haemeke wanda꞉halima꞉ Yesu pa꞉ta꞉ ika꞉ yeni haemeke wanda꞉halina꞉eki honke laaso alota꞉ Ikana꞉ma꞉ naka꞉ dau honiki wataena꞉ lapeke lemekeme. Koto leeke handaa mo wataemeke wanda꞉halina꞉ yeni manuta꞉ tande lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mandane Pa꞉tisi haliweki make mandane wape pea wala꞉tiki pu haemeke haliweki make Diutuseleme da mina꞉pa꞉lao a꞉pa Yesu lota꞉ pitolo alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Pa ekipeke mo naka꞉ hoki nane telieleme haliweki nika꞉ ateke meiyekena꞉ mana꞉ pimanu ekipeke na opitolo pitelemepe. Ika꞉ ne noluekema꞉ta꞉ titina꞉ amba꞉la mo nika꞉ pimanu ula꞉ tupa꞉ ika꞉ kiki na tandepo halememe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesuma꞉ mo pi hombo peaaso iki pa꞉ta꞉ alota꞉ Kutaa make pa ekipeke handa ikana꞉ma꞉ make mo Koda꞉na꞉ pi ula꞉eki kiao pa ika꞉ waleme pimanu kone tolu halemepe. ");
INSERT INTO ssx_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Do ekina꞉ yeke loa꞉me. Hande Koda꞉ma꞉ la꞉ ula꞉ pima꞉ alota꞉ Naka꞉ ama꞉ apa꞉ yaapona꞉ oto pa꞉ta꞉ hapeke la꞉la꞉me. Kutupa pi ma꞉nda꞉ta꞉ Ipika꞉ apa꞉ ama꞉ pa꞉ta꞉ hoke pi lea꞉ka꞉na꞉ta꞉ ota꞉ homena꞉ lia꞉pa꞉peke laa la꞉ ula꞉pate ");
INSERT INTO ssx_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","pa ikana꞉ma꞉ alota꞉ Hali ma꞉nda꞉ma꞉ ipika꞉ apa꞉ ama꞉ tamba꞉ mia꞉peke alemanu miniki hala꞉pate ipikana꞉ma꞉ ipiliki pa꞉ta꞉ alota꞉ Ipiliki kulu pua꞉ ale manuta꞉ amba꞉ Koda꞉ pa꞉ta꞉ haluekema꞉ la꞉ wia halome lea꞉ka꞉na꞉ kota꞉ koto pi opitolo hata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ikana꞉ma꞉ta꞉ koto halima꞉ ipika꞉ apa꞉ ama꞉ta꞉ tamba꞉ mia꞉peke laa la꞉ ula꞉ pi pea꞉peke ekita꞉ Pina꞉ma꞉ pea꞉peke na ya꞉ka꞉ta꞉me laa lo halememe. Kutupa koto piteme hau manuta꞉ kota꞉ ikana꞉ma꞉ ika꞉ waleme pimanu kone teli mea pu haluekema꞉ yeke Koda꞉na꞉ pi ula꞉ ekimanu hoki walo halememe. ");
INSERT INTO ssx_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ikita꞉ ota꞉ makeaaso hau pu haleme some hombo ya꞉ka꞉ta꞉me. Hande Aisayama꞉ ikina꞉ la꞉ witolo hata꞉ leekeeki ota꞉ pi la꞉ wia꞉ka꞉ta꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ipikana꞉ma꞉ leeke pita꞉ dupa Do wanda꞉halima꞉ pulu pimiki ekina꞉ Koda꞉ma꞉ alota꞉ Ika꞉ pima꞉ homeke ya biki mea a꞉meiyalo pelemepate ika꞉ puki manuma꞉ta꞉ I̱ mina꞉pa꞉lao ota꞉ panane wina꞉ lelememe. ");
INSERT INTO ssx_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mo ya biki mea a꞉meiyao yeni piteme ekita꞉ pa pahameke pitelememe. Pa ekipeke. Ika꞉ honema꞉ wepia wimiki mana꞉ pimanu kone yaka la꞉ ula꞉ pi tupa꞉ walo halememe la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuma꞉ mo wanda꞉hali ipiki pa꞉ta꞉ epena꞉yeke wi la꞉mipi pea iki pa꞉ta꞉ alota꞉ Ya pi opua hone wia꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wanda꞉halita꞉ hama nane ula꞉ alemanu mea naloma꞉eki manuma꞉ iki na hoeyaalo pa꞉la꞉pate tukiki nane wia kake pa꞉ta꞉ opolu baasa꞉ ale manuma꞉ kone wanda꞉hali hoeyaapeke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Koto leeke hoki naneta꞉ ipika꞉ hoki nane telimiki haliwekima꞉ ipiki pa꞉ta꞉ a꞉pa alota꞉ Mo hande Pa꞉tisi haliwekima꞉ pimi ekita꞉ neke na handepe. Nakana꞉ma꞉ le pi manuma꞉ ika꞉ puki tandama꞉ homaya꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ya hepeni hala꞉ Apa꞉ma꞉ na nokopeke pa opa꞉la꞉ waemanu paeyao yokilieke laa Yesuma꞉ hombo peaaso hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pina꞉ma꞉ hone ma꞉nda꞉ na wia꞉pa꞉pe. Ikita꞉ mo leke holu piki wanda꞉halina꞉ leke holu piki you haliweki halememe. Koto ekina꞉ta꞉ leke holu piki somema꞉ mo leke holupiki some ma꞉nda꞉ hatuku mea pea꞉ka꞉na꞉ta꞉ kota꞉ ipiliki telipuna꞉ hombo pa꞉ta꞉ hopulu paleke mandake lopilipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pidama꞉ alota꞉ Koto ale pina꞉ teketa꞉ niki wopu la kia꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kutupa Yesuma꞉ iki pa꞉ta꞉ alota꞉ Kota꞉ iki make pi teke hone na witelemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nala꞉ ale manuma꞉ hali homekena꞉ weleke pa꞉ta꞉ pua pita꞉ta꞉ hoke ale yapilieke hone na witelemepe. ");
INSERT INTO ssx_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pate ipika꞉ kake pa꞉ta꞉ yama꞉ opolo ipu hala꞉ ale manuta꞉ ota꞉ ipika꞉ puki tukiki nanema꞉ opolu baalo ipula꞉me. Kotoeki manuma꞉ kone ipiki ha̱i̱ peaasa꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kota꞉ koto some ipika꞉ puki pa꞉ta꞉ pita ipula꞉ hoke hone manuma꞉ta꞉ dupiki haumanu pu tialieke. Hali ma꞉nda꞉ lina꞉ lo o wanda꞉ pake na꞉na꞉ lo o hali yankeke pa꞉ta꞉ kone hoke hau pina꞉ lo o pake na꞉na꞉ lo o yapiki hau pina꞉ lo o wanda꞉halina꞉ biki hoeyaena꞉ lo ");
INSERT INTO ssx_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","do hau manuma꞉ ipikita꞉ hoke hali haena꞉ lolo pa꞉la꞉pate pa mo na tandepeke kikima꞉ ne mea nala꞉ ekima꞉ta꞉ ipiki na hoeyaasa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesuma꞉ koto alena꞉ mina꞉pa꞉lao Taiya Saidoni daoni yaapo nane peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Koto kenke nane hayeke Keinani wanda꞉ homeke Yesu pa꞉ta꞉ e̱ wi laa a꞉pa alota꞉ Deipidina꞉ eiyekeo. Ya wandiki pa꞉ta꞉ hoke temoko pila꞉ ekima꞉ ipiki ota꞉ epeke tupa꞉ na ula꞉me. Koto ekina꞉ I̱ pa꞉ta꞉ a꞉ta꞉ma꞉ homa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Koto leekepate Yesuma꞉ ipiki pa꞉ta꞉ pi homeke siki ma꞉nda꞉ ota꞉ na leekeme. Kutu pieketa꞉ mo disaipolo haliwekima꞉ ipiki pa꞉ta꞉ a꞉pa honke alo alota꞉ Ipikana꞉ma꞉ niki teliolo hata꞉ wi wopu la꞉ paleke ipula꞉ma꞉ ipika꞉ da pa꞉na꞉ tapae lemekepate ");
INSERT INTO ssx_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ I̱ta꞉ mo hande Isulai tapake alu pula꞉ sipisipimanu leke haleme wanda꞉hali pa꞉ta꞉ tapaaleke handaa epolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Do pi opitolota꞉ koto kone mo wanda꞉ Yesuna꞉ anke teke pa꞉ta꞉ panda꞉ puniao lopolo alota꞉ Tekehalio. I̱ tamba꞉ mie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesuma꞉ hombo peaasota꞉ dupa leekeme. Weki wandikina꞉ ne pa꞉ta꞉la꞉ mea kika pa꞉ta꞉ lopa moneaasa꞉ hauta꞉ epeke hau dia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mo wanda꞉ma꞉ alota꞉ Tekehalio. Koto pita꞉ ota꞉ alepate wanda꞉halima꞉ ne naa pelimi hoki nanema꞉ta꞉ popumanu mina꞉pelete pilimi ekimanu kika manuma꞉ talopu nemeka꞉na꞉ta꞉ a꞉pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Koto leeke Yesuma꞉ hombo peaaso alota꞉ Neketa꞉ hone wopu tulaasa꞉ wanda꞉ ya꞉ka꞉ta꞉me. Koto ekina꞉ta꞉ naka꞉ hone pa꞉la꞉ hauta꞉ ota꞉ pealueke leekeme. Yesuma꞉ koto alo haena꞉ kone mo wanda꞉na꞉ waneketa꞉ paa epeke tupa꞉ tiao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuma꞉ koto pa꞉ta꞉ mina꞉pa꞉lao mo Ka꞉lili ikali leke nepoko lopa꞉la꞉ pua mo peiyene pa꞉ta꞉ a꞉meiya pua pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Koto pua pitina꞉ta꞉ wanda꞉hali tieke wopu Yesu pa꞉ta꞉ a꞉pa mombelemekeme. Iki ipulu hata꞉ta꞉ dola꞉pake piki leke holupiki anke lupa wiki pi na leke make kutupa mandane yenimanu haemeke wanda꞉hali wopu make Yesuna꞉ anke pa꞉ta꞉ a꞉pa wimiki handaa ipikana꞉ma꞉ epeao paeyaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kutupa mo wanda꞉halima꞉ mo pi na leke wanda꞉halima꞉ pi lemekeeki hando make kiki anke lupa wiki wanda꞉halima꞉ paa epeke tupa꞉ haemekeeki hando make dola꞉pake piki wanda꞉halima꞉ paa epea pomimikieki hando make leke holu piki wanda꞉halina꞉ leke ki la epeke tupa꞉ hando pu pimiki eki paeyao handolo hata꞉ ikana꞉ma꞉ leke opo handa꞉ hake wiata꞉ Isulai wanda꞉halina꞉ Koda꞉na꞉ biki yeiya꞉ laemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuma꞉ ipika꞉ hoki nane tolu haemeke haliweki ipiki pa꞉ta꞉ epena꞉ wi la꞉mipi pea iki pa꞉ta꞉ alota꞉ Do wanda꞉hali pa꞉ta꞉ ya pukima꞉ e̱ ala꞉me leekeme. Hoto tepona꞉ I̱ ame̱le̱ haememe. Kutupa ameta꞉ napeke ne ma꞉nda꞉ dia꞉me. I̱ma꞉ ika꞉ da nina꞉ tea꞉ma꞉ homa꞉ paleke tapaa tapaa pua꞉ka꞉na꞉ kota꞉ pota꞉ hopikina꞉ tea꞉ma꞉ pua homilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ipika꞉ disaipolo haliwekima꞉ ipiki pa꞉ta꞉ alota꞉ Do hapu hala꞉ alena꞉ hata꞉ta꞉ do wanda꞉hali pa꞉ta꞉ neta꞉ hando pate mea halomana꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesuma꞉ iki pa꞉ta꞉ dupa lota꞉ pitolo alota꞉ Palaowa wala꞉ ekipu wia halemepe lota꞉ piekeme. Koto haliwekima꞉ alota꞉ Palaowa wala꞉ watake hata꞉ make ta꞉peli siki yaapo homeke pea wia haloma꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Koto ekina꞉ Yesuma꞉ mo wanda꞉hali wopu pa꞉ta꞉ alota꞉ Kenkena꞉ pita꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kutupa Yesuma꞉ mo palaowa wala꞉ watake hata꞉ make mo ta꞉peli siki mu peata꞉ Koda꞉ pa꞉ta꞉ keiyae pi amba꞉la laata꞉ pindi pindi peaata꞉ ipika꞉ disaipolo haliwekima꞉ wanda꞉hali pa꞉ta꞉ hale hale pina꞉ yeke ipikana꞉ma꞉ iki pa꞉ta꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kutu pieketa꞉ wanda꞉hali paeyaoma꞉ ana꞉na꞉ naa weleke haemekeme. Kutaata꞉ mo wanda꞉halima꞉ naa putu piliki wiekeeki mo disaipolo haliwekima꞉ meaata꞉ ala꞉ta watake hata꞉ tumbaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mo hande palaowa wala꞉ sunu nemeke haliwekita꞉ wekiwanda꞉ na apa꞉take haliweki homeketa꞉ 4 daoseni halima꞉ nemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuma꞉ iki paeyao tapaa tapaa peaata꞉ koto kone ipika꞉ disaipolo haliweki ame̱le̱ kawaso pa꞉ta꞉ pita Ma꞉ka꞉dani kenke nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mo Pa꞉tisi haliweki make Sa꞉dusi haliweki tonka꞉na꞉ Yesu pa꞉ta꞉ a꞉pa ipika꞉ anke yololo alota꞉ Koda꞉ma꞉ neke pa꞉ta꞉ do wele a꞉nda꞉ ku haya꞉ka꞉na꞉ta꞉ kota꞉ nikana꞉ma꞉ handomono mo welema꞉ na handeke hau ma꞉nda꞉ pie lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesuma꞉ ika꞉ pi hombo peaasota꞉ dupa leekeme. Nate pambolo pulu hata꞉ we pia꞉ka꞉na꞉ta꞉ kota꞉ ikana꞉ma꞉ alota꞉ Beliata꞉ epeke nate telieke lo halememe. ");
INSERT INTO ssx_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kutaa koto tupa꞉ kone da ka꞉la꞉paaso make ikana꞉ma꞉ta꞉ nate we pita꞉la꞉ ekita꞉ Lako ipuluekema꞉ taa pita꞉la꞉ handa꞉e lo halememe. Ikana꞉ma꞉ oli yana꞉ pita꞉la꞉ haumanu handolo hata꞉ dupiki nate telieke laa la꞉ u hapa꞉peke ya꞉la꞉pate pa ame do iki pa꞉ta꞉ pitolo haumanu handaa ikana꞉ma꞉ hone wia꞉pa꞉peke na ya꞉la꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A꞉pa꞉e. Do you hoke wanda꞉halima꞉ta꞉ ekipeke handaa mo na handeke hau ma꞉nda꞉ handuluekema꞉ alemepe. Dia꞉me. Mo amba꞉ hande Diona pa꞉ta꞉ pieke yeke na handeke hau homeke waloa꞉ka꞉na꞉ta꞉ handilimikie. Koto laata꞉ iki mina꞉pa꞉lao peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesuna꞉ disaipolo haliweki mo ikali leke tunkula mone tea꞉na꞉ pulu hata꞉ta꞉ palaowamanu hone yonka꞉lao na mea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesuma꞉ mana꞉ alo hata꞉ iki pa꞉ta꞉ alota꞉ Wotu hapa꞉peke. Pa꞉tisi Sa꞉dusi tapake yaapona꞉ palaowa pombei yaasa꞉eki wotu handa꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Koto leekeeki opuolo hata꞉ ika꞉ ika꞉ kone hone wia pi pi lemeke ekita꞉ dupa. Nikita꞉ palaowa na mea epoma꞉ ekina꞉ ala꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kutupa Yesuma꞉ ika꞉ hone wimikieki handolo hata꞉ iki pa꞉ta꞉ alota꞉ Ne dia꞉ ya꞉leke ekipeke pi pi alemepe. Ika꞉ hone tulaaseme ekita꞉ ota꞉ hosiki siki ya꞉ka꞉ta꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ikana꞉ma꞉ hone wia a̱i̱ na handelemepe. Na niminaasemepe. Mo hande palaowa wala꞉ yunki hata꞉ 5 daoseni haliweki pindi pindi peaowa꞉ pita꞉ma꞉ta꞉ putu pilikima꞉ta꞉ ala꞉ta ekipu tumbaemepe. ");
INSERT INTO ssx_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kutupa mo hande palaowa wala꞉ watake hata꞉ hande 4 daoseni haliweki haloma꞉ pita꞉ma꞉ta꞉ putu pilikima꞉ta꞉ ala꞉ta ekipu tumbaemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ekieki pea ikana꞉ma꞉ hone na witemepe. I̱ma꞉ta꞉ mo ota꞉ palaowana꞉ na loa꞉pate pa mo Pa꞉tisitonu pita꞉ Sa꞉dusi haliweki yaapona꞉ palaowa pombei yaasa꞉ yisitima꞉ handeke pimanu alemeeki handeteke hapa꞉ laa alome. ");
INSERT INTO ssx_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Koto pi opitolota꞉ mo disaipolo haliwekima꞉ Yesuma꞉ leeke kinki pita꞉la꞉ pita꞉ mo palaowa pa꞉ta꞉ ula꞉ yisitina꞉ na leekepate ota꞉ mo Pa꞉tisi Sa꞉dusi tapake yaapona꞉ waleme mana꞉ pimanu pa꞉ta꞉ lea꞉ka꞉ta꞉me hone wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kutupa Yesuma꞉ ipika꞉ hoki nane tolu haemeke haliweki ame̱le̱ mo Sesatia Pilipai da kenke nane pemekeme. Koto pa꞉ta꞉ta꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ dupa lota꞉ piekeme. Wanda꞉halima꞉ mo Wanda꞉halina꞉ Eiyeketa꞉ epi alemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mo disaipolo haliwekima꞉ ipiki pa꞉ta꞉ alota꞉ Mandane wanda꞉halima꞉ alota꞉ Bapitaisi peao hayeke hali Dionie alememe. Mandane wanda꞉halima꞉ta꞉ Elaidiae alememe. Mandane wanda꞉halima꞉ Dietemaiya o mandane potopede halie alememe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Pa ikana꞉ma꞉ta꞉ I̱ta꞉ epi alemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimono Pidama꞉ hombo peaaso alota꞉ Neketa꞉ mo da꞉taa hao hala꞉ Koda꞉na꞉ Eiyeke Ketisoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Saimono Dionina꞉ eiyekeo. Nakana꞉ma꞉ta꞉ epeke tupa꞉ hombo peaeme. Pa ekipeke do ota꞉ tikitikina꞉ hombo peae ekita꞉ hali ma꞉nda꞉ma꞉ na la kia꞉pate ya hepeni hala꞉ Apa꞉ma꞉ neke pa꞉ta꞉ tiki tiki kia꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Koto ekina꞉ dupa alome. Neketa꞉ Pidae. (nika꞉ pima꞉ta꞉ Toopie) Koto toopi mandaata꞉ ya siosi a꞉elueke. Kutupa mo homo hala꞉ ekina꞉ honkopuma꞉ kone koto siosi ota꞉ na bepolao halieke. ");
INSERT INTO ssx_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","I̱ma꞉ neke pa꞉ta꞉ mo hepenina꞉ Kilu Tombuao Hala꞉ ekina꞉ pota꞉ kakena꞉ kimanu kulueke. Koto ekina꞉ do kenke nane hata꞉ nakana꞉ma꞉ hau ma꞉nda꞉ a꞉nda꞉ pa꞉ta꞉ pi wika꞉na꞉ta꞉ kota꞉ koto hauna꞉ pi wita꞉la꞉eki kone oli hepeni nane make pi wilieke. Kutupa do kenke nane hata꞉ nakana꞉ma꞉ mandane haumanu pa mone pina꞉ paeka꞉na꞉ta꞉ kota꞉ koto pina꞉ pasa꞉ hau kone oli hepeni nane make pa pina꞉ palieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Koto leeke Yesuma꞉ iki hando alo alota꞉ I̱ta꞉ Ketiso yekeme laa wanda꞉hali ma꞉nda꞉ pa꞉ta꞉ na lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Koto natena꞉ kini pu meata꞉ Yesuma꞉ ipika꞉ disaipolo tonu peneme yao alo hata꞉ dupa leekeme. I̱ta꞉ ota꞉ Diutuseleme da nane polueke. Kutu pua꞉ka꞉na꞉ta꞉ koto pa꞉ta꞉ mo you haliwekima꞉ make yeni peao haleme you haliwekima꞉ make wape pea wala꞉tiki pu haleme haliwekima꞉ make I̱ tanda tieke ota꞉ wotu kilimikie leekeme. I̱ kiao limika꞉na꞉ta꞉ homuluepate hoto tepo naku pa꞉ta꞉ wia paa da꞉taa tiao halueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Koto pi opuaata꞉ Pidama꞉ Yesu hosiki mo pate leke hatuku mea pua hata꞉ ipiki pa꞉ta꞉ alota꞉ Dia꞉me Tekehalio. Neke pa꞉ta꞉ kutu piki hau ota꞉ na epena꞉ hone witolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesuma꞉ la꞉ka꞉la mina Pida handolo hata꞉ alota꞉ Sadani. Neke puma. Neketa꞉ ya pota꞉ a꞉mbaluekema꞉ taapeleme. Pa ekipeke. Do naka꞉ wili hone manuta꞉ Koda꞉ pa꞉ta꞉ yama꞉ na ipula꞉pate pa hali pa꞉ta꞉ yama꞉ ipula꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Koto la paeyeketa꞉ Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ Hali ma꞉nda꞉ epima꞉ ya hoki nane toluekema꞉ hone pia꞉ka꞉na꞉ta꞉ kota꞉ ipiki pa꞉ta꞉ kone hone ula꞉ ekimanu tunkulaata꞉ ipika꞉ a꞉ka꞉tei wape piki ti mea tia ya hoki nane telina꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kutu pa꞉la꞉ ekima꞉ hali epima꞉ ipika꞉ da꞉ta꞉la꞉eki homeke miniki hao haluekema꞉ hone wia꞉ka꞉na꞉ta꞉ kota꞉ ipika꞉ da꞉ta꞉la꞉eki kone alupalieke. Kutu pilia꞉pate I̱ pa꞉ta꞉ hone witolo ipika꞉ da꞉ta꞉la꞉eki alupina꞉ lea꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ ota꞉ da꞉taa hao halieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hali epima꞉ do kenke ala꞉ta꞉ ala꞉ta꞉ paeyao ipika꞉eki wina꞉ la halia꞉pate kone ipika꞉ da꞉ta꞉la꞉eki alupaeya꞉ka꞉na꞉ta꞉ kota꞉ epekeeki ma꞉nda꞉ta꞉ aleke milia꞉pe. Dia꞉ma꞉ ala꞉ta꞉ ma꞉nda꞉ ota꞉ na milieke. Ipika꞉ da꞉ta꞉la꞉eki paa muluekema꞉ topo peapeke ala꞉ta꞉ ma꞉nda꞉ a꞉nda꞉ ota꞉ na ula꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wanda꞉halina꞉ Eiyeke ipika꞉ Atekena꞉ pa̱a̱ taapuna꞉ ipika꞉ enisolo hatuku a̱i̱ kutaa kone ipilieke. Kutaata꞉ wanda꞉hali homeke homekema꞉ ika꞉ pu haeme hau manuna꞉ ana꞉ piki yenki kone iki pa꞉ta꞉ hale hale pilieke. ");
INSERT INTO ssx_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi la kitolo alome. Wanda꞉halina꞉ Eiyeketa꞉ Kini hali hata꞉ epolo pa꞉la꞉eki handuluekema꞉ do haleme mandane wanda꞉hali ikita꞉ ambi na homeke pa halimikie alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hoto yunki mindiki hata꞉ hao Yesuma꞉ Pida pita꞉ Dia꞉mesi Dioni hama̱la̱꞉ handa꞉ meata꞉ pote tumiki pa꞉ta꞉ pua ika꞉siki haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kutupa ikana꞉ma꞉ handa꞉ pelia haena꞉ Yesuna꞉ loke wonu piliekeme. Ipika꞉ leke popeleketa꞉ nate pa̱a̱ pita꞉la꞉ tupa꞉ pa̱a̱ piekeme. Kutupa ipika꞉ daumanu make pa̱a̱ peaata꞉ hake wopu piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kutupa Elaidia Mosesi yaapo opolo a꞉paata꞉ Yesu ame̱le̱ pi pi alo haemekeme. Kutu pitolo haena꞉ koto hoki nane tolu haemeke hali tepoma꞉ handemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Koto ekina꞉ta꞉ Pidama꞉ Yesu pa꞉ta꞉ alota꞉ Tekehalio. Do pa꞉ta꞉ haloma꞉ ekita꞉ a꞉pa꞉la꞉me. Koto ekina꞉ naka꞉ hone pia꞉ka꞉na꞉ta꞉ I̱ma꞉ sale da tepo a꞉eyono lae laata꞉ Homeke naka꞉eki ma꞉nda꞉ Mosesina꞉eki ma꞉nda꞉ Elaidiana꞉eki pea a꞉eyono lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kutu piki pi alo haena꞉ta꞉ mo pa̱a̱ piki koa ma꞉nda꞉ma꞉ iki a꞉pa tu peaaso haena꞉ mo koa tukiki pa꞉ta꞉ pi ho̱la̱꞉makema꞉ alota꞉ I̱ma꞉ koto yaka puki piki weki pa꞉ta꞉ ta꞉na꞉ wopu homolome. Ipika꞉ pi opua꞉pa꞉pekee la꞉niaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Koto pi ho̱la̱꞉make epeekeeki opu haota꞉ mo disaipolo hali tepoma꞉ paala꞉ tiekema꞉ wopu homolo hata꞉ kenkena꞉ puki yama lopemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesuma꞉ iki pa꞉ta꞉ a꞉pa iki wataaso hata꞉ alota꞉ Paala꞉ma꞉ na homeke tiaapee leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Koto leeke mo hali tepoma꞉ la꞉ka꞉la꞉ liao handemekepate ma꞉nda꞉ na hake Yesu homeke hayeke handemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Potena꞉ hola꞉pa꞉niaaso haena꞉ Yesuma꞉ iki hando alo hata꞉ alota꞉ Oli hande upama꞉ handeke nono pimi hauta꞉ ma꞉nda꞉ pa꞉ta꞉ na lapa꞉peke laata꞉ Wanda꞉halina꞉ Eiyeketa꞉ ota꞉ homaa paa tiao haowa꞉ka꞉na꞉ alota꞉ ana꞉ pilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Koto leeke pi opitolo ikana꞉ma꞉ Yesu pa꞉ta꞉ lota꞉ pitolo alota꞉ Pa ekipeke mo wape pea wala꞉tiki pu haleme haliwekima꞉ titina꞉ amba꞉la Elaidia ipilieke lo halemepe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kutupa Yesuma꞉ iki pa꞉ta꞉ hombo peaaso alota꞉ Titina꞉ amba꞉la Elaidia ota꞉ ipilieke. Kutu pia꞉ka꞉na꞉ta꞉ ipikana꞉ma꞉ hau paeyao tikitiki yao wina꞉ loluekema꞉ ipilieke. ");
INSERT INTO ssx_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kutu piliepate I̱ma꞉ iki pa꞉ta꞉ alome. Elaidiata꞉ amba꞉ epea꞉pate wanda꞉halima꞉ ipikita꞉ ota꞉ Elaidiae hone wopu na witolo hata꞉ ikana꞉ma꞉ pa ika꞉ hone pieke ekimanu ipiki pa꞉ta꞉ pimikime. Mo Wanda꞉halina꞉ Eiyeke pa꞉ta꞉ make ikana꞉ma꞉ koto mandake piki hoke haumanu kone pilimikie alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mo disaipolo haliwekima꞉ koto leeke pi opitolota꞉ mo ala꞉ pita꞉ mo hande Dioni Bapitaisi pa꞉ta꞉ ala꞉me hone wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iki tonkopuma꞉ mo wanda꞉hali pa꞉ta꞉ la꞉ka꞉la ipulu haena꞉ta꞉ hali homeke Yesu pa꞉ta꞉ a꞉pa panda꞉ pitolo hata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","alota꞉ Tekehalio. Ya weki pa꞉ta꞉ a꞉ta꞉ma꞉ homa꞉peke laata꞉ Ipikita꞉ lu lopao mea keao weki yaalo tana꞉ eleke eleke ti tala꞉ pa꞉ta꞉ make ikali pa꞉ta꞉ make lu lopatiki pu hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kutupa I̱ma꞉ naka꞉ disaipolo haliweki pa꞉ta꞉ hatuku epoa꞉pate ikana꞉ma꞉ ipiki epeapeke na yea꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Koto wanda꞉halita꞉ hone wopu na tulaake ota꞉ puki taka꞉lake wanda꞉halie. I̱ta꞉ iki pa꞉ta꞉ hao pua hando natena꞉ hao na lua꞉pe. I̱ma꞉ iki pa꞉ta꞉ a꞉ta꞉ma꞉ homolo hata꞉ pa pu hamena꞉ kiaota꞉ hando natena꞉ tunkulua꞉pe laata꞉ Mo wekita꞉ I̱ pa꞉ta꞉ mea epoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kutupa Yesuma꞉ Mo hoke temoko hando alo hata꞉ mo weki mina꞉pa꞉lae leeke handaata꞉ mo hoke temokoma꞉ mo weki mina꞉pa꞉layekeme. Kutu pieketa꞉ pa koto toma꞉na꞉ kone mo weki epea tiao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yesu ipika꞉ siki haena꞉ ipika꞉ hoki nane tolu haemeke haliwekima꞉ ipiki pa꞉ta꞉ pua lota꞉ pitolo hata꞉ alota꞉ Pa ekipeke handa nikana꞉ma꞉ koto hoke temoko tolu lia꞉peke na ya꞉la꞉ ekita꞉ ekipa pia꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesuma꞉ hombo peaaso alota꞉ Ika꞉ hone tulaleme ekita꞉ aneke hapu na tulaemeke handa pia꞉me. I̱ma꞉ iki pa꞉ta꞉ ota꞉ ota꞉ pi alome. Ika꞉ hone tulaleme ekita꞉ mo ki̱mi̱le̱ma꞉ handeke ale masidadi waema꞉ handekeeki wimika꞉na꞉ta꞉ kota꞉ ikana꞉ma꞉ do pote pa꞉ta꞉ alo hata꞉ Mo pate leke pue laa la halemeka꞉na꞉ta꞉ kota꞉ koto pa꞉ta꞉ yola꞉ monealieke. Kutu piki hone tulalimi ekima꞉ta꞉ hau paeyao pea꞉pa꞉peke yelimikie. ");
INSERT INTO ssx_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pate dupiki hoke temoko toluekema꞉ta꞉ pota꞉ ma꞉nda꞉ dia꞉ ya꞉la꞉pate pa mo nee pi wia hata꞉ yeni pita꞉la꞉eki homekema꞉ ana꞉ pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ipika꞉ disaipolo haliweki paeyao Ka꞉lili nane a꞉pa mombelemeke pita꞉ma꞉ta꞉ Yesuma꞉ iki pa꞉ta꞉ alota꞉ Hosiki wetepena꞉ta꞉ mo Wanda꞉halina꞉ Eiyeketa꞉ haliweki oto pa꞉ta꞉ haena꞉ lelieke. ");
INSERT INTO ssx_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kutu pia꞉ka꞉na꞉ta꞉ mo haliwekima꞉ ipiki limikie. Kota꞉ ota꞉ homa꞉liepate pa hoto tepo wia paa da꞉taalieke leekeme. Koto ekima꞉ta꞉ mo disaipolo haliweki ika꞉ pukima꞉ ka꞉nda꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu ipika꞉ disaipolo haliweki hatuku Kapeneami da opolo epemeketa꞉ mo tembolo dakisi mani mu haemeke haliweki a꞉pa Pida pa꞉ta꞉ lota꞉ pitolo alota꞉ Naka꞉ walaasa꞉ halima꞉ta꞉ tembolo dakisi mani lopao halepe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pidama꞉ hombo peaaso alota꞉ Aowe. Lopao hala꞉me leekeme. Koto hoki naneta꞉ Pidama꞉ da pa꞉ta꞉ honda꞉ pambolo haena꞉ Yesuma꞉ ipiki pa꞉ta꞉ pi amba꞉la alo alota꞉ Saimonoo naka꞉ honema꞉ta꞉ eki hone wilipe laata꞉ Do kenkena꞉ handeteke haleme Kini haliwekima꞉ epi ameda pa꞉ta꞉ dakisi mani mea꞉tiki pu halimipe. Ika꞉ tapake pa꞉ta꞉ kone mea꞉tiki pilimikipe o tapake ma꞉nda꞉ ma꞉nda꞉ pa꞉ta꞉ mea꞉tiki pilimikipe. ");
INSERT INTO ssx_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pidama꞉ hombo peaaso alota꞉ Mo tapake ma꞉nda꞉ pa꞉ta꞉ homeke mea꞉tiki pilimikie leekeme. Koto leeke Yesuma꞉ alota꞉ Kota꞉ koto ekina꞉ta꞉ mo Kini halina꞉ tapake wanda꞉halima꞉ta꞉ dakisi na wilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pateta꞉ do wanda꞉halima꞉ niki pa꞉ta꞉ hoke hone wiaama꞉na꞉ mo ikali leke pa꞉ta꞉ pua naka꞉ kimai lopaapeke. Kutaata꞉ ota꞉ titina꞉ endilipi ta꞉pelita꞉ yola꞉ mea ipika꞉ kake ankoto peaata꞉ koto kake pa꞉ta꞉ta꞉ silipa mani homeke handa꞉ wilimikie. Koto manima꞉ta꞉ mo ya tembolo dakisi make naka꞉eki make ana꞉ pilieke. Kotoeki mea pua dika꞉ dakisi hala꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Koto toma꞉na꞉ta꞉ mo disaipolo haliwekima꞉ Yesu pa꞉ta꞉ a꞉pa lota꞉ pitolo alota꞉ Mo hepenina꞉ Kilu Tombuao Hala꞉eki pa꞉ta꞉ epita꞉ ota꞉ tieke hala꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Koto lemeketa꞉ Yesuma꞉ weki siki homeke wila꞉ meaata꞉ ika꞉ puki nanema꞉ mea haena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kutaa ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Ikana꞉ma꞉ ika꞉ hone topo pina꞉ lena꞉ laata꞉ mo weki siki leke na haemeka꞉na꞉ta꞉ kota꞉ ikana꞉ma꞉ hepenina꞉ Kilu Tombuao Hala꞉ pa꞉ta꞉ ota꞉ na honda꞉ pambilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Epima꞉ ipika꞉ kone panda꞉ puniaaso hata꞉ homu pea do weki siki leke hala꞉ halita꞉ mo hepenina꞉ Kilu Tombuao Hala꞉ ekina꞉ tumiki hali hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma꞉nda꞉ epima꞉ dupiki weki siki ya bikina꞉ ta꞉na꞉ma꞉ homolo hata꞉ handa꞉ mia꞉ka꞉na꞉ta꞉ kota꞉ I̱ make ta꞉na꞉ma꞉ homaa handa꞉ milieke. ");
INSERT INTO ssx_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Hali epima꞉ do I̱ pa꞉ta꞉ hone tulaaseme wekiwandiki sunu homeke ma꞉nda꞉ma꞉ hoke hau pina꞉yeke pu tiaena꞉ lea꞉ka꞉na꞉ta꞉ kota꞉ koto halina꞉ make pa꞉ta꞉ toopi hombeleke mea endiata꞉ homena꞉ mo dawala noka꞉ pa꞉ta꞉ mea lopaena꞉ lea꞉ka꞉na꞉ yoluta꞉ epolo pia꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","A꞉pei. Do kenke pa꞉ta꞉ I̱ paala꞉e. Wanda꞉halima꞉ hoke hau pina꞉yeke ula꞉ hoke haumanu ula꞉me. Dupiki haumanu a꞉pa꞉peke yolo pa꞉la꞉pate a꞉pa꞉e mo hau epena꞉ ala꞉ halita꞉ ota꞉ hoke yenki milieke. ");
INSERT INTO ssx_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Koto ekina꞉ta꞉ naka꞉ kikima꞉ o naka꞉ ankema꞉ hoke hau puelena꞉ lea꞉ka꞉na꞉ta꞉ kota꞉ koto kiki o koto anke tunkulu baapeke. Kiki homeke o anke homeke homeke hata꞉ deto hala꞉eki mika꞉na꞉ta꞉ kota꞉ ota꞉ epelieke. Pate neketa꞉ naka꞉ kiki yaapo pa haena꞉ lo o anke yaapo pa haena꞉ lo pea haeka꞉na꞉ta꞉ ikana꞉ma꞉ neke mo na paeke ti to hala꞉ ale pa꞉ta꞉ mea lopaemeka꞉na꞉ta꞉ kota꞉ ota꞉ hoelieke. ");
INSERT INTO ssx_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Naka꞉ lekema꞉ hoke hau puelena꞉ lea꞉ka꞉na꞉ta꞉ kota꞉ koto leke yoka꞉ mea baapeke. Leke homeke homeke hata꞉ deto hala꞉eki mika꞉na꞉ta꞉ kota꞉ ota꞉ epelieke. Leke yaapo pa haena꞉ lo pea haeka꞉na꞉ta꞉ ikana꞉ma꞉ neke mo ti to hala꞉ ale pa꞉ta꞉ mea lopaemeka꞉na꞉ta꞉ kota꞉ ota꞉ hoelieke. ");
INSERT INTO ssx_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ikana꞉ma꞉ dupiki wekiwandiki sunu pa꞉ta꞉ pa alema꞉ handali mina꞉ma꞉ wopu handeteke hapa꞉peke alome. Pa ekipeke. Mo wekiwandiki ika꞉ hepeni hala꞉ enisolo tonuma꞉ mo ya hepeni hala꞉ Apa꞉na꞉ leke popelekena꞉ teke pa꞉ta꞉ hata꞉ handeteke hao halememe alome. ");
INSERT INTO ssx_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Wanda꞉halina꞉ Eiyekema꞉ mo alu peleme wanda꞉hali weiya handa꞉ wia da꞉taaluekema꞉ a꞉pa hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ika꞉ honema꞉ta꞉ hali epima꞉ ipika꞉ 100 sipisipi ma꞉na꞉ handeteke halia꞉pate homeke hondo alupia꞉ka꞉na꞉ta꞉ eki pilieke hone witemepe. Ipikana꞉ma꞉ pa halia꞉ 99 sipisipimanu mo peiyene tea꞉na꞉ mea haena꞉ laata꞉ mo alupia꞉eki weilu pelieke. ");
INSERT INTO ssx_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Mo alupia꞉ sipisipi ma꞉na꞉ handa꞉ wia꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ mo na alu piki pa haleme ekimanu pa꞉ta꞉ ta꞉na꞉ma꞉ homiliepate pa mo handa꞉ wiekeeki pa꞉ta꞉ta꞉ ta꞉na꞉ ota꞉ wopu homilieke. ");
INSERT INTO ssx_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pa do mandake tupa꞉ kone mo naka꞉ hepeni hala꞉ Apa꞉ma꞉ make do wekiwandiki sunu homeke ma꞉nda꞉ alu pina꞉ hone na pa꞉la꞉me alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Naka꞉ kamema꞉ neke hoeyaasa꞉ hoke hau pia꞉ka꞉na꞉ta꞉ kota꞉ ipiki teke pa꞉ta꞉ puaata꞉ ipika꞉ pia꞉ hokeeki wala꞉peke. Pate peneme na piki ipilika꞉ honema꞉ pea꞉pa꞉peke. Ipikana꞉ma꞉ naka꞉ pi opua telia pia꞉ka꞉na꞉ta꞉ kota꞉ mo kameta꞉ neke nane epena꞉ lelipikie. ");
INSERT INTO ssx_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pate naka꞉ pi na opia꞉ka꞉na꞉ta꞉ kota꞉ pa pua hali homeke o yaapo ma꞉nda꞉ hatuku ipiki pa꞉ta꞉ paa pua꞉pa꞉peke. Kutu pika꞉na꞉ta꞉ mo nakana꞉ma꞉ titina꞉ ipiki pa꞉ta꞉ le pi alupaama꞉na꞉ handa꞉ ula꞉ hali yaapo o tepona꞉ pima꞉ hone u tiatiki pina꞉ lelieke. ");
INSERT INTO ssx_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kutu pilimipate iki paeyaona꞉ pi na opia꞉ka꞉na꞉ta꞉ kota꞉ mo ipika꞉ pia꞉ hau paeyao siosi wanda꞉hali mombilimi ale pa꞉ta꞉ la hala꞉peke. Kutaa ipikana꞉ma꞉ mo siosi wanda꞉hali paeyaona꞉ pi na opia꞉ka꞉na꞉ta꞉ kota꞉ nakana꞉ma꞉ koto someta꞉ mo Koda꞉ mataasa꞉ hali o a꞉nda꞉ tunkuliki wanda꞉halina꞉ tamba꞉ mina꞉la꞉ hali tupa꞉ haena꞉ lapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","I̱ma꞉ iki pa꞉ta꞉ dupa alome. Ikana꞉ma꞉ do kenke nane ala꞉ta꞉ o hau ma꞉nda꞉ pi wimika꞉na꞉ta꞉ kota꞉ koto pi wita꞉la꞉ ekita꞉ oli hepeni nane make pi wilieke. Koto tupa꞉ kone ikana꞉ma꞉ do kenke nane ala꞉ta꞉ o hau ma꞉nda꞉ pi na wimika꞉na꞉ta꞉ kota꞉ hepeni nane make pi na wilieke. ");
INSERT INTO ssx_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Pa ameta꞉ do pi make apa꞉taaso iki pa꞉ta꞉ alome. Iki paeyao tukiki pa꞉ta꞉ epi yaapo a꞉nda꞉ma꞉ mo pea꞉peke hau homeke a꞉nda꞉ do pate puluekema꞉ epena꞉e laa homeke hone wia hata꞉ yeni pipika꞉na꞉ta꞉ kota꞉ oli ya hepeni hala꞉ Apa꞉ma꞉ opua ipilika꞉ hone pa꞉la꞉ ekita꞉ ota꞉ peawalieke. ");
INSERT INTO ssx_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pa ekipeke wanda꞉hali yaapo o tepoma꞉ ale ma꞉nda꞉ pa꞉ta꞉ yaka bikina꞉ mombelemeka꞉na꞉ta꞉ kota꞉ I̱ma꞉ koto pa꞉ta꞉ iki ame̱le̱ mandake halueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Koto toma꞉na꞉ta꞉ Pidama꞉ Yesu pa꞉ta꞉ a꞉pa lota꞉ pitolo alota꞉ Tekehalio. Yaka kamema꞉ I̱ pa꞉ta꞉ hoke hau pea꞉tiki pu haya꞉ka꞉na꞉ta꞉ kota꞉ I̱ma꞉ tana꞉ ekipu paeyaaluepe. Tana꞉ wataake hata꞉ ana꞉ pa꞉la꞉pe laa lota꞉ piekepate ");
INSERT INTO ssx_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesuma꞉ hombo peaaso alota꞉ Dia꞉me. Hoto wataake hata꞉ ana꞉ na pa꞉la꞉me. Pa hoto paeyao ota꞉ pa paeyaaso paeyaaso pu hapeke. ");
INSERT INTO ssx_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Pa ekipeke. Mo hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ do tupa꞉ ya꞉la꞉me. Kini hali homekema꞉ ipika꞉ e poka꞉la꞉ haliwekina꞉ tondiki manuta꞉ tikitiki yaalueke hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kotoeki kini pu mea pokuluekema꞉ haena꞉ ipika꞉ e pokaeyeke hali homeke hatuku epemekeme. Koto halima꞉ta꞉ mo Kini halina꞉ 10 milioni kina tondiki mea hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kutupa koto ipika꞉ tondiki paeyaapeke mani na wieke handaata꞉ mo Kini halima꞉ iki pa꞉ta꞉ alota꞉ Do hali ipika꞉ wekiwanda꞉ make ipika꞉ wia hayeke alemanu paeyao make mo tondiki paeyaena꞉yeke mani muluekema꞉ iki paeyao ma꞉nda꞉na꞉ pahameke e pokaasa꞉ tapake haena꞉ hambena꞉ tapaapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Koto leekeeki opuaata꞉ mo e pokaeyeke halima꞉ ipika꞉ Kinina꞉ leke popelekena꞉ tumiki yotuao panda꞉ puniaaso honke alo alota꞉ Tekehalio. I̱ pa꞉ta꞉ a꞉ta꞉ma꞉ homolo hata꞉ waleke kika꞉na꞉ta꞉ mo tondiki paeyao ana꞉na꞉ epeao kulueke laa honke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Koto leekeeki opitolo hata꞉ mo Kini halima꞉ ipiki pa꞉ta꞉ a꞉ta꞉ma꞉ homolo hata꞉ pa pina꞉e laa Paota꞉ pa mo hande tondiki tieke make pina꞉ laa kiao hone yonka꞉lao ipiki paa tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kutu pieke mo hande somema꞉ mo ipika꞉ Kini hali mina꞉pa꞉lao hama peekeme. Kutu pitolo hata꞉ta꞉ ipika꞉ 100 kina tondiki miono leeke haleeke mo Kini halina꞉ e mandake pokaepeke hali ma꞉nda꞉ manda꞉hande piekeme. Ipikana꞉ma꞉ koto e mandake pokaepeke somena꞉ make da꞉ka꞉pa꞉ mina ipika꞉ pendoko teke yoka꞉ minolo hata꞉ alota꞉ Mo ya neke pa꞉ta꞉ kolo tondikita꞉ ma꞉nda꞉ pa na mina꞉pa꞉lake ota꞉ paeyao kima leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mo e mandake pokaepeke some ipika꞉ leke popelekena꞉ panda꞉ puniaaso honke alo alota꞉ Kameo. I̱ pa꞉ta꞉ a꞉ta꞉ma꞉ homolo hata꞉ waleke kika꞉na꞉ta꞉ mo tondiki paeyao ana꞉na꞉ kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Koto leekepate ipikana꞉ma꞉ta꞉ koto pi tombuao a꞉ta꞉ma꞉ na homeke mo somema꞉ ipika꞉ tondiki paeyao ana꞉na꞉ kone pa kina꞉ alo hata꞉ pa dipula mea lopaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kutu pieke hauta꞉ mo hande Kini halina꞉ e pokaemeke mandane haliwekima꞉ handaata꞉ ikana꞉ma꞉ ka꞉nda꞉ma꞉ homolo hata꞉ ika꞉ Kini hali pa꞉ta꞉ mo hau paeyao pua la haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mo Kini halima꞉ koto pi opuaata꞉ mo hande hali epena꞉ wi leekeme. Kutupa ipiki pa꞉ta꞉ alota꞉ Neketa꞉ ota꞉ hoke hau piki e pokaasa꞉ halie. Nakana꞉ma꞉ I̱ pa꞉ta꞉ A꞉ta꞉ma꞉ homee laa honke leeki homeke homekena꞉ta꞉ mo hande naka꞉ tondiki tieke paeyao I̱ma꞉ pa paeyaowa꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kota꞉ I̱ma꞉ neke pa꞉ta꞉ pa a꞉ta꞉ma꞉ homoa꞉ tupa꞉ nakana꞉ma꞉ naka꞉ e mandake pokaepe some pa꞉ta꞉ make koto tupa꞉ kone a꞉ta꞉ma꞉ homa꞉peke alee laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","mo Kini halima꞉ mineke tieke pankolo hata꞉ mo hande somema꞉ ipika꞉ mieke tondiki ota꞉ paeyao ana꞉na꞉ kone epeao paeyaena꞉ handeteke hata꞉ panisi pina꞉ dipula mea lopaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesuma꞉ do onkoluma꞉ pi lo a꞉mbolo hata꞉ alota꞉ Ikana꞉ma꞉ ika꞉ yankekena꞉ hoke hau pimiki ekimanu ika꞉ pukima꞉ ota꞉ hone na yonka꞉laemeka꞉na꞉ta꞉ kota꞉ yaka hepeni hala꞉ Apa꞉ma꞉ mo hande Kini halima꞉ pieke tupa꞉ kone iki paeyao pa꞉ta꞉ make koto mandake tupa꞉ kone pilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Koto piekeeki manuna꞉ pimanu la paeyeketa꞉ Yesuma꞉ mo Ka꞉lili kenke mina꞉pa꞉laota꞉ mo Diodani ikali mone tea꞉na꞉ wieke Diudia kenke nane peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wanda꞉hali wopuma꞉ ipika꞉ hoki nane teli mea pemekeme. Kutu pimikita꞉ Yesuma꞉ koto pa꞉ta꞉ ika꞉ hoke yenimanu paeyao epeawayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mandane Pa꞉tisi haliwekima꞉ ipiki tamuluekema꞉ yeke ipiki pa꞉ta꞉ lota꞉ pita꞉la꞉ pi ma꞉nda꞉ dupa lemekeme. Hali ma꞉nda꞉ma꞉ ota꞉ pa ipika꞉ hone pa꞉la꞉ tupa꞉ ipika꞉ wanda꞉ kiaaso yoka꞉la꞉ ekita꞉ mo nika꞉ Lo Pi Ula꞉ ekima꞉ta꞉ waleke ma꞉nda꞉ wiala꞉pe laa lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Mo hande wanda꞉hali kini peao Wepieke Tekehalima꞉ta꞉ hali pita꞉ wanda꞉ yaapo wepiekeme la꞉la꞉ Baibolona꞉ wape pea ula꞉ pita꞉ ikana꞉ma꞉ na yata꞉pa alemepe. ");
INSERT INTO ssx_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kota꞉ koto hali wanda꞉ yaapo wepieke pita꞉ma꞉ Koda꞉ma꞉ alota꞉ I̱ma꞉ hali pita꞉ wanda꞉ yaapo wepueke handaata꞉ mo halima꞉ ipika꞉ apa꞉ ama꞉ mina꞉pa꞉lao ipika꞉ wanda꞉ yaapo ta꞉ma꞉ni peaata꞉ tooli homeke halipipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Koto leeke ekina꞉ta꞉ ipilikita꞉ yaapo na halo pelepepate ota꞉ homeke halipipikie. Koto pa꞉leke handaata꞉ koto hauta꞉ ota꞉ Koda꞉ma꞉ ta꞉ma꞉ni peawaasa꞉ hau yeleketa꞉ wanda꞉hali ma꞉nda꞉ma꞉ ota꞉ na ka꞉taapeke alee leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mo Pa꞉tisi haliwekima꞉ koto Yesuna꞉ pi opuolo hombo peaaso alota꞉ Kotota꞉ ota꞉ ya꞉ka꞉na꞉ta꞉ kota꞉ mo Mosesi ipika꞉ wape pea ula꞉ pima꞉ alota꞉ Hali homeke ipika꞉ wanda꞉ kiaya꞉ka꞉na꞉ta꞉ ipikana꞉ma꞉ mo kiaasa꞉ wanda꞉ pa꞉ta꞉ Neke ota꞉ kiao tapaasome la꞉la꞉ pi wape pea halaa pena꞉ tapaapeke la꞉la꞉ ekita꞉ pa ekipeke wape pea wia pa꞉la꞉pe laa lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Mosesima꞉ koto piki wanda꞉ kiao tapaasa꞉ pi uleke wiki hauta꞉ kota꞉ ika꞉ puki ota꞉ taka꞉la pa pa꞉leke handolo hata꞉ wia pa꞉la꞉me. Koto piekepate mo hande Koda꞉ma꞉ wanda꞉hali kini peayeke toma꞉na꞉ta꞉ kutu piki hau na piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kota꞉ ameta꞉ I̱ma꞉ iki pa꞉ta꞉ dupa alome. Hali ma꞉nda꞉na꞉ wanda꞉ma꞉ta꞉ ipilika꞉ tooli halepeeki na hoeyaasa꞉pate pa mo halima꞉ ipika꞉ kone kiao tapao wanda꞉ ma꞉nda꞉ mia꞉ka꞉na꞉ta꞉ kota꞉ koto halima꞉ ipika꞉ kone mo ipilika꞉ tooli halepeeke ka꞉tao hoeyaasa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Koto leekeeki opua ipika꞉ disaipolo haliwekima꞉ Yesu pa꞉ta꞉ alota꞉ Tooli pa꞉ta꞉ kutu piki hau wia꞉peke ya꞉ka꞉na꞉ta꞉ kota꞉ wanda꞉ na miki pa hata꞉ta꞉ epilieke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesuma꞉ mo pi hombo peaaso alota꞉ Do walolo pita꞉ pa paeyaoma꞉ opua miniki hapeke na ya꞉la꞉pate pa mandaali epi Koda꞉ma꞉ kutu pina꞉ la꞉la꞉ haliwekima꞉ homeke opua miniki halimikie. ");
INSERT INTO ssx_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yesuma꞉ iki pa꞉ta꞉ opua꞉pe laata꞉ Ta꞉ta꞉ ta꞉ta꞉ piki haliweki halememe. Mandane haliwekita꞉ ika꞉ ama꞉na꞉ weleke pa꞉ta꞉ kone hali atua ma꞉nda꞉la꞉ ekima꞉ pu make mandane haliwekita꞉ wanda꞉halima꞉ ki̱a̱yeke ekima꞉ pu make kutupa mandane haliwekima꞉ta꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki pa꞉ta꞉ hone u pitolo hata꞉ wanda꞉ mina꞉la꞉ hauta꞉ kiao halememe. Do pi opua miniki hapeke ya꞉la꞉ somema꞉ miniki haena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mandane wanda꞉halima꞉ weki wandiki sunu Yesu ipika꞉ kikima꞉ wataaso hata꞉ yeni pina꞉yeke hatuku epemekeme. Kutu pimieki handolo mo ipika꞉ disaipolo haliwekima꞉ iki hando alo hata꞉ tolu limikime. ");
INSERT INTO ssx_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kutu pimikipate Yesuma꞉ alota꞉ Weki wandikisunu make I̱ pa꞉ta꞉ epena꞉ma꞉ sa꞉sa꞉ na pea꞉pa꞉peke. Pa ekipeke do weki wandikima꞉ handeke wanda꞉halita꞉ mo hepenina꞉ Kilu Tombuao Hala꞉eki ana꞉na꞉ handilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Koto laata꞉ ipikana꞉ma꞉ mo weki wandiki manda ipika꞉ kiki wiaata꞉ koto pa꞉ta꞉ mina꞉pa꞉lao peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nate homeke ma꞉nda꞉na꞉ta꞉ hali homeke Yesu pa꞉ta꞉ a꞉pa alota꞉ Disao. I̱ma꞉ deto hala꞉eki muluekema꞉ta꞉ epeke hau ma꞉nda꞉ handoeki peonope laa lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Mo epeke hau pea꞉peke ekita꞉ I̱ pa꞉ta꞉ pa ekipeke lota꞉ pitelepe. Mo ota꞉ a꞉pa꞉la꞉ halita꞉ homeke homeke hala꞉me. Koto ekina꞉ nakana꞉ma꞉ mo deto hala꞉eki muluekema꞉ hone pia꞉ka꞉na꞉ta꞉ kota꞉ mo hande Lo Pi Ula꞉eki paeyao wopu telia pu hapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mo halima꞉ta꞉ Handoeki pionope leeketa꞉ Yesuma꞉ alota꞉ Hali ma꞉nda꞉ ota꞉ homena꞉ na lia꞉peke. Kutupa hali ma꞉nda꞉na꞉ wanda꞉na꞉ hakopu na tunkula꞉peke. Pake na napeke. Yayapiki pi na lapeke. Makeaaso kone ma꞉nda꞉ ma̱leke na lia꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Naka꞉ ama꞉ apa꞉ yaapona꞉ pi opua꞉peke. Nakana꞉ma꞉ neke naka꞉ kone pukima꞉ homa꞉ handeteke hale tupa꞉ mo mandane mandane wanda꞉hali pa꞉ta꞉ make koto tupa꞉ kone pea꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mo panake halima꞉ hombo peaaso alota꞉ Koto ale pi ula꞉eki paeyaota꞉ telia pu halome. Handoeki ma꞉nda꞉ make peonope leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Naka꞉ honema꞉ I̱ta꞉ ota꞉ epeke haupiki some halueke hone wika꞉na꞉ta꞉ kota꞉ mo naka꞉ wia hale ala꞉ta꞉ ala꞉ta꞉ paeyao mandane wanda꞉halima꞉ hambena꞉ laata꞉ mo milipi manita꞉ mandane natehali wanda꞉hali pa꞉ta꞉ halehale pea꞉peke. Kutu pika꞉na꞉ta꞉ kota꞉ nakana꞉ma꞉ mo hepeni tukiki pa꞉ta꞉ta꞉ ale epeke epeke wopu mu halipikie. Koto ekina꞉ta꞉ ya hoki telia꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mo panake halima꞉ koto pi opitolota꞉ ipikita꞉ hamoko hali tieke hayeke ekima꞉ pukima꞉ ka꞉nda꞉ma꞉ homa꞉ paleke peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kutu pieke Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Hamoko wanda꞉halima꞉ mo hepenina꞉ Kilu Tombuao Hala꞉ pa꞉ta꞉ pua꞉peketa꞉ ota꞉ ana꞉ siki na pilieke. ");
INSERT INTO ssx_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iki pa꞉ta꞉ paa taa alo handa꞉e. Mo kemolo ma꞉na꞉ma꞉ mo no̱i̱ ka꞉ka꞉na꞉ pa꞉ta꞉ ana꞉na꞉ honda꞉ pamba yopua꞉peke ekina꞉ ka꞉nda꞉ta꞉ pa mo hamoko halima꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ tukiki pa꞉ta꞉ pua꞉peke ekina꞉ mia꞉peke ka꞉nda꞉ tupa꞉ na milieke alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ipika꞉ disaipolo haliwekima꞉ koto pi opitolo iki ota꞉ wopu tola꞉tia pominolo hata꞉ alota꞉ Koto pa꞉la꞉ ekina꞉ta꞉ kota꞉ epima꞉ ota꞉ da꞉ta꞉la꞉eki mia꞉peke ya꞉la꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesuma꞉ iki handa꞉ hake witolo alota꞉ Koto hauta꞉ wanda꞉halima꞉ ika꞉ kone koto pea꞉peke na ya꞉la꞉pate Koda꞉ma꞉ homeke ana꞉ pa꞉la꞉me. Koda꞉ma꞉ta꞉ hau paeyao pea꞉peke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pidama꞉ Yesu pa꞉ta꞉ pi alo alota꞉ Opi. Nikana꞉ma꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao mina꞉pa꞉lao naka꞉ hoki nane telioloma꞉me. Koto ekina꞉ta꞉ nikana꞉ma꞉ta꞉ aleke muluma꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesuma꞉ hombo peaaso alota꞉ I̱ma꞉ ota꞉ pi alome. Mo paa kini pilia꞉ panake di kini pia꞉ka꞉na꞉ta꞉ kota꞉ mo wanda꞉halina꞉ Eiyekema꞉ ipika꞉ ota꞉ seliapo piki pa̱a̱ tiekema꞉ hopiliaasa꞉ you halina꞉ sea manda pitia꞉ka꞉na꞉ta꞉ kota꞉ koto toma꞉na꞉ta꞉ iki yaka 12 disaipolo haliweki make mo Isulaina꞉ 12 tapake handeteke haluekema꞉ ikana꞉ma꞉ mo iki handeteke hala꞉ sea manda pitilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kutaa make mo mandaali epi a꞉nda꞉ma꞉ I̱ teliolo hata꞉ ika꞉ da o ika꞉ hameketiti o ana꞉titi o apa꞉ ama꞉ o weki wandiki sunu o kenkemanu make mina꞉pa꞉laemeka꞉na꞉ta꞉ kota꞉ do kenkena꞉ hata꞉ kone mo ika꞉ mina꞉pa꞉laleme ale manuta꞉ paa 100 tupa꞉ lombei peao meata꞉ deto hala꞉eki make milimikie. ");
INSERT INTO ssx_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Koto pa꞉la꞉pate ame do biki tieke ula꞉ mandane wanda꞉hali woputa꞉ wetepe haena꞉ laata꞉ mo ame do biki na ula꞉ mandane wanda꞉hali woputa꞉ titina꞉ halo yapilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Mo hepenina꞉ Kilu Tombuao Hala꞉ ekita꞉ do tupa꞉e. Nate homeke ma꞉nda꞉na꞉ hali homeke ma꞉nda꞉ma꞉ mandane haliweki yenki haluekema꞉ ipikana꞉ma꞉ ipika꞉ waini pu e pokaena꞉yeke da ka꞉la꞉paaso siki weilu peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mandane haliweki handa꞉ wia ipikana꞉ma꞉ alota꞉ Ikana꞉ma꞉ mulupeleme manita꞉ nate homekena꞉ 1 kina kulueke leekeeki opitolo haena꞉ iki paeyaoma꞉ homeke hone wimiki handaata꞉ mo e pa꞉ta꞉ tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kutupa mo somema꞉ paa 9 koloka꞉ tupa꞉ paa la꞉ka꞉la mo makedi hama pua koto pa꞉ta꞉ mo mandane e na pokaemeke haliwekimanu handa꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kota꞉ ipikana꞉ma꞉ koto haliweki pa꞉ta꞉ alota꞉ Ikana꞉ma꞉ ya e pua pokaemeka꞉na꞉ta꞉ I̱ma꞉ iki pa꞉ta꞉ yenki ota꞉ ana꞉na꞉ kone kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kota꞉ mo haliwekima꞉ ipika꞉ pi opua e pokolo pemekeme. Mo somema꞉ kutu piki hauta꞉ paa natepa pita꞉ tepo nate leke yaapona꞉ make paa piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Welealo nate leke yunki hata꞉ teke pa꞉ta꞉ ipikana꞉ma꞉ mo makedi hama paa pua mandane haliweki handeekeme. Iki pa꞉ta꞉ pua alota꞉ Pa ekipeke do natena꞉ nate lekemanu paeyaota꞉ pa paeyaaso pimipe laa iki pa꞉ta꞉ lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ikana꞉ma꞉ hombo peaaso alota꞉ Yenki e pokomono ma꞉nda꞉ma꞉ niki na mia꞉me. Koto lemeke ipikana꞉ma꞉ alota꞉ Kota꞉ a꞉pa꞉la꞉me mo ya waini pu e pua pokaape leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nate pambolo pulu haena꞉ta꞉ mo hande e teke halima꞉ mo e haliweki handeteke haena꞉ leeke hali pa꞉ta꞉ alota꞉ Mo haliweki wi laa mombelao ika꞉ yenkimanu hala꞉peke. Yenki halolo hata꞉ mo ota꞉ wetepe siki kini pea e pokeme haliwekina꞉eki amba꞉la kini pea hala꞉tiki puaata꞉ ota꞉ titina꞉ kini pimi haliwekina꞉ ekita꞉ paeyaaso hata꞉ hala꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Koto leeke opuaata꞉ ipikana꞉ma꞉ mo welealo nane nate leke yunki hata꞉ kini pea e pokeme haliweki homeke homeke pa꞉ta꞉ 1 kina hale hale piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kutu piekeeki handaata꞉ mo ota꞉ da panake ka꞉la꞉paaso siki kini pu mea pokolo pemeke haliweki ika꞉ yenki muluekema꞉ ipuluta꞉ Nika꞉ yenkita꞉ ota꞉ haka꞉ta꞉pao kilieke hone wimikipate pa iki pa꞉ta꞉ make homeke tupa꞉ 1 kina ombu haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kutu mo wetepena꞉ yenki mimi haliwekima꞉ ika꞉ yenki meaata꞉ mo e pokaemeke teke hali pa꞉ta꞉ tulu tulu pi wopu alo hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Do ota꞉ wetepena꞉ mi haliwekita꞉ pa 1 aowa homekena꞉ e pokaemepate nikita꞉ da ka꞉la꞉paaso kini pea nate holiki tiekena꞉ poka pua welealo naneta꞉ naoma꞉pate pa nakana꞉ma꞉ iki pa꞉ta꞉ hale mandake piki yenki niki pa꞉ta꞉ make kiteleme lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mo e teke halima꞉ iki homeke ma꞉nda꞉ pa꞉ta꞉ Someo laa alota꞉ Opie. I̱ma꞉ neke na makealome. Nakana꞉ma꞉ nate homekena꞉ e pokaala꞉ ekita꞉ 1 kina ana꞉ pa꞉la꞉me laa homeke hone wiki handaata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","naka꞉ yenki mea da pue leekeme. I̱ma꞉ mo hande ota꞉ wetepe sale nane mua꞉ hali pa꞉ta꞉ make do neke pa꞉ta꞉ kua꞉ tupa꞉ kone haluekema꞉ hone pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ya manima꞉ta꞉ ya hone pa꞉la꞉ tupa꞉ kone pea꞉peke dia꞉ ya꞉la꞉pe o I̱ma꞉ ta꞉na꞉ma꞉ homolo hata꞉ mandane wanda꞉hali pa꞉ta꞉ ale mandaneeki pa halo halo ekina꞉ neketa꞉ I̱ yaapo ta꞉na꞉ma꞉ na homelepe laa lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Koto pi Yesuma꞉ lo a꞉mbolo hata꞉ alota꞉ Koto ekina꞉ mo ame biki na ula꞉ mandane wanda꞉hali woputa꞉ titina꞉ haena꞉ laata꞉ mo ame biki tieke ula꞉ mandane wanda꞉hali woputa꞉ wetepe halo yapilimikie laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuma꞉ Diutuseleme pota꞉na꞉ ipika꞉ disaipolo haliweki homeke talo pu mea pulu hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Opua꞉pe. Nikita꞉ ame Diutuseleme da teke nane ta opa꞉liaasoma꞉ handepe. Koto pa꞉ta꞉ta꞉ mo yeni peao haleme teke haliwekima꞉ make mo Lo Pi wape pea wala꞉tiki pu haleme haliwekima꞉ make Wanda꞉halina꞉ Eiyeke mea puata꞉ homena꞉e laa ma̱leke lilimikie. Kutaata꞉ ikana꞉ma꞉ ipiki mo Diendaili haliweki pa꞉ta꞉ mea pua halimikie. ");
INSERT INTO ssx_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Koto haliwekima꞉ ipiki kitaaso hata꞉ ipika꞉ lokena꞉ dopi tao yumbua baota꞉ homena꞉ lilimikie. Kutupa ipikita꞉ nate tepo wiaata꞉ paa tiao da꞉taa halieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kutaata꞉ Sepedina꞉ wetekema꞉ ipika꞉ eiyeke yaapo ame̱le̱ Yesu pa꞉ta꞉ a꞉pa tumiki yotuao panda꞉ pitolo hata꞉ ala꞉ta꞉ ma꞉nda꞉ honke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesuma꞉ alota꞉ Neketa꞉ aleke hone peleke pitelepe leekeme. Koto leeke mo wanda꞉ma꞉ hombo peaaso alota꞉ Nakana꞉ma꞉ Kini hali pitilipi natena꞉ do ya weki yaapo naka꞉ popeke nanema꞉ weki ma꞉nda꞉ pitu make hoeya꞉ nanema꞉ weki ma꞉nda꞉ pitu pina꞉ pi la꞉ witolo I̱ pa꞉ta꞉ la꞉ wie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Koto leekepate Yesuma꞉ mo wanda꞉na꞉ eiyeke yaapo pa꞉ta꞉ alota꞉ Ipilika꞉ honke alepe ekita꞉ hone wotu na wiki hata꞉ alepeme. I̱ma꞉ mo ka꞉nda꞉ pa꞉la꞉ ekina꞉ kapona꞉ nolua꞉ ekita꞉ ipilikana꞉ma꞉ make napa꞉peke yelepe leekeme. Ipilikana꞉ma꞉ ipika꞉ pi hombo peaaso alota꞉ Diki ana꞉ pa꞉la꞉me lepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesuma꞉ ipiliki pa꞉ta꞉ alota꞉ I̱ma꞉ nolua꞉ kapona꞉ta꞉ ipilikana꞉ma꞉ ota꞉ nelipipikie. Pate ya popeke nane kiki pita꞉ hoeya꞉ nane kiki yaapo pa꞉ta꞉ ma꞉nda꞉ epi pitulu pa꞉la꞉ ekita꞉ laata꞉ I̱ma꞉ lapeke na ya꞉la꞉me. Koto ya Apa꞉ma꞉ wamo pea tikitiki yao ula꞉ pila꞉ ale yaapota꞉ mo ipika꞉ mulu pa꞉la꞉ hali yaapona꞉ ekie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Koto honke laeyekeeki mo hande mandane kiki yaapo disaipolo tonuma꞉ opuaata꞉ kota꞉ koto hama̱la̱꞉ pa꞉ta꞉ mineke pankemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kutu pieketa꞉ Yesuma꞉ iki mea momba꞉lao alota꞉ Ikana꞉ma꞉ handelememe. Kenke ma꞉nda꞉ nane wanda꞉hali handeteke hao hala꞉ haliwekima꞉ ika꞉ wanda꞉hali ana꞉na꞉ kilu tombuao halememe. Kutupa ika꞉ hali tieke tiekema꞉ mo wanda꞉hali pa꞉ta꞉ Dupa꞉pe laa pi wotu hapolo halemepate ");
INSERT INTO ssx_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","pa ikana꞉ma꞉ta꞉ iki tukiki pa꞉ta꞉ ma꞉nda꞉ma꞉ mo koto hau pina꞉ na lelimikie. Dia꞉me. Iki pa꞉ta꞉ hali epima꞉ I̱ tieke halueke hone wia꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ iki paeyaona꞉ e pokaasa꞉ hali halieke. ");
INSERT INTO ssx_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kutupa hali epima꞉ I̱ titina꞉ hali halueke hone wia꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ mo hande Wanda꞉halina꞉ Eiyekema꞉ pita꞉la꞉ tupa꞉ iki paeyaona꞉ pahameke e pokaasa꞉ hali halieke ");
INSERT INTO ssx_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Pa ekipeke Wanda꞉halina꞉ Eiyeketa꞉ mo wanda꞉halima꞉ ipika꞉ e pokaena꞉ loluekema꞉ yeke na epeeke yekepate ipikana꞉ma꞉ pa ika꞉ e pokaaluekema꞉ make ipika꞉ da꞉ta꞉la꞉ ekima꞉ta꞉ iki wopuna꞉ hoke hauna꞉ yenki haluekema꞉ yeke epea꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu ipika꞉ disaipolo tonu ame̱le̱ mo Dietiko mina꞉pa꞉lao pemekeme. Kutupa wanda꞉hali wopuma꞉ iki teli mea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Koto pulu haena꞉ta꞉ mo pota꞉ nepokona꞉ pitipiki leke holupiki hali yaapoma꞉ Yesu yopula꞉me pi opipikime. Koto ekina꞉ta꞉ ipilikana꞉ma꞉ wi alo alota꞉ Deipidina꞉ eiyekeo. Diki pa꞉ta꞉ a꞉ta꞉ma꞉ homa꞉e lepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Koto lepeke handa wanda꞉hali wopuma꞉ta꞉ ipiliki pa꞉ta꞉ alota꞉ Pi na lapepema laa sa꞉sa꞉ pimikipate ipilikana꞉ma꞉ ota꞉ wi aneke hapu paa alo alota꞉ Deipidina꞉ eiyekeo. Diki pa꞉ta꞉ a꞉ta꞉ma꞉ homa꞉e lepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kutupa Yesuma꞉ pota꞉na꞉ hando hata꞉ wi laa alota꞉ I̱ma꞉ ipiliki pa꞉ta꞉ eki peaano alepepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mo leke holupiki hali yaapoma꞉ ipiki pa꞉ta꞉ alota꞉ Tekehalio. Dika꞉ leke ki laae lepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesuma꞉ ipiliki pa꞉ta꞉ a꞉ta꞉ma꞉ homolo hata꞉ ipilika꞉ leke wataeyekeme. Kutu pieke pita꞉ma꞉ta꞉ ipilika꞉ leke ki laata꞉ epeke tupa꞉ handepekeme. Koto ekina꞉ta꞉ ipilikana꞉ma꞉ ipika꞉ hoki nane telimea pepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesuma꞉ ipika꞉ disaipolo haliweki tonka꞉na꞉ mo Diutuseleme da teke pa꞉ta꞉ pulu hata꞉ ikana꞉ma꞉ mo olipi teke hala꞉ peiyene tea꞉na꞉ hayeke Betepeisi da opolo epemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Koto pa꞉ta꞉ hata꞉ta꞉ Yesuma꞉ ipika꞉ disaipolo hali yaapo tapaaluekema꞉ hata꞉ta꞉ dupa leekeme. Oli hala꞉ da nane opolo pua꞉pa꞉peke. Kutu polo hata꞉ koto kone donki hali ma꞉na꞉ ikiki ankula꞉ endi baala꞉eki handilipipikie. Kutu pia꞉ka꞉na꞉ta꞉ kota꞉ hola꞉ tapao mea a꞉pa꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kutupa ma꞉nda꞉ma꞉ ipiliki pa꞉ta꞉ pi ma꞉nda꞉ lea꞉ka꞉na꞉ta꞉ dupa lapa꞉peke. Tekehalima꞉ muluekema꞉ hone pa꞉la꞉me lapa꞉peke. Koto lepeka꞉na꞉ta꞉ kota꞉ kutaa kone mea epoepena꞉ lelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Koto pieke hauta꞉ mo hande potopede hali homekema꞉ la꞉ wiekeeki yaaluekema꞉ piekeme. Koto la꞉ wieke ekita꞉ dupa. ");
INSERT INTO ssx_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Mo Saioni da teke tieke pa꞉ta꞉ haleme wanda꞉hali pa꞉ta꞉ta꞉ dupa lapeke. Ika꞉ kini tieketa꞉ iki pa꞉ta꞉ taa ipula꞉ handa꞉pe. Ipikita꞉ homu piki hali hata꞉ mo donki ma꞉na꞉na꞉ hoki manda pila꞉me. kutupa mo donki hali ma꞉na꞉ ikiki manda pila꞉me lapa꞉peke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mo hande hali yaapoma꞉ta꞉ Yesuma꞉ leeke tupa꞉ puaata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","mo donki ikiki ankula꞉ hola꞉ mea Yesu pa꞉ta꞉ a꞉paata꞉ ika꞉ daumanu mo donkina꞉ hoki manda yamaemekeme. Kutu pimikita꞉ Yesu pitulu a꞉meiyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wanda꞉hali wopuma꞉ ika꞉ daumanu lepolona꞉ peolao yamoma꞉ yamoma꞉ pimikime. Mandane wanda꞉halima꞉ta꞉ ti palekemanu yanda peolao yamoma꞉ yamoma꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kutupa mo Yesu hatuku pulu hata꞉ titina꞉ hao wetepe hao pimiki wanda꞉hali paeyaoma꞉ wi aneke hapu kini pea la꞉ alu alu pitolo hata꞉ alota꞉ Hosa꞉na꞉e. Deipidina꞉ eiyeke pa꞉ta꞉ ta꞉na꞉e laata꞉ Mo Tekehalina꞉ bikina꞉ ipula꞉ halita꞉ Koda꞉ma꞉ ta꞉na꞉ma꞉ homena꞉e. Koda꞉na꞉ biki mea a꞉meiyamana꞉e laa la꞉tia pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesuma꞉ Diutuseleme da teke nane hondo pamba peeketa꞉ mo daoni wanda꞉hali paeyaoma꞉ Koto ipula꞉ someta꞉ epiya꞉ka꞉ta꞉pe la꞉ paleke paleke pu hando mombelemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kutu pieketa꞉ mo ipiki hatuku epemeke wanda꞉halima꞉ iki pa꞉ta꞉ alota꞉ Do halita꞉ mo Ka꞉lili kenke nane hala꞉ da Na꞉sa꞉tetena꞉ potopede hali Yesue lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuma꞉ mo hande Tembolo da pa꞉ta꞉ hondo pambaata꞉ koto pa꞉ta꞉ mo ala꞉ta꞉ ala꞉ta꞉ hambemeke haliweki make tapaatiki pimiki haliweki iki paeyao tolu tankulupe miniekeme. Kutupata꞉ mo mani topo pu hala꞉ haliwekina꞉ teipolomanu make mo melipu bamanu hambo haemeke haliwekina꞉ pitieke alemanu make hoela꞉ mipi baeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Mo Baibolo bukana꞉ do pita꞉ wape pea ula꞉me laata꞉ Yaka data꞉ wanda꞉halima꞉ yeni pea꞉tiki pulu pa꞉la꞉ dae lolo pelemepate ikana꞉ma꞉ta꞉ do data꞉ mo pake no hala꞉ haliwekina꞉ a꞉mbalo peleme da haena꞉ alememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ipikita꞉ koto Tembolo da tukiki pa꞉ta꞉ haena꞉ kone ipiki pa꞉ta꞉ epemeke mandane leke holupiki wanda꞉hali make dola꞉pake pieke wanda꞉hali make ipikana꞉ma꞉ iki paeyao wamo peayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yesuna꞉ epeke epeke haumanu piekeeki make mo wekiwandiki sunuma꞉ Tembolo da tukiki pa꞉ta꞉ hata꞉ Yesuna꞉ biki daeyaluekema꞉ mo Deipidina꞉ eiyekena꞉ biki yeiya꞉ lamana꞉e lemekeeki opu pitolo hata꞉ta꞉ mo hande yeni peao haemeke haliwekina꞉ you haliwekima꞉ make hande pi ula꞉eki wape pea walo hala꞉ haliwekima꞉ make mineke tieke kini pea pankolo hata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ikana꞉ma꞉ Yesu lota꞉ pitolo alota꞉ Nakana꞉ma꞉ koto wekiwandikima꞉ aleme pita꞉ na opitelepe lemekeme. Koto lemeke Yesuma꞉ alota꞉ Aowe. Opitolome. Mo Baiboloma꞉ alota꞉ Nakana꞉ma꞉ mo pota꞉ pula꞉ o andu nala꞉ wekiwandiki sunu paeyaoma꞉ ala꞉ta꞉ ma꞉nda꞉ na taleke yeiya꞉ laasa꞉ haumanu pina꞉yeke wala꞉tiaeme laa wape pea ula꞉ pita꞉ ikana꞉ma꞉ na yata꞉pemepe laa hombo peayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Koto laata꞉ Yesuma꞉ iki make Diutuseleme da teke make mina꞉pa꞉lao Bedani da nane polu peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Koto da pa꞉ta꞉ pelia da ka꞉la꞉peeketa꞉ Yesuma꞉ Diutuseleme da teke nane pa la꞉ka꞉la peekepate pota꞉na꞉ tea꞉ma꞉ homa꞉paleke peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kutu pieke pulu hata꞉ mo pota꞉ nepokona꞉ hayeke nose homeke handaata꞉ mo ti teke pa꞉ta꞉ peekepate kiliki na a꞉etolo hata꞉ pa katake homeke hayekeeki handeekeme. Kutu pieke handaa ipikana꞉ma꞉ mo nose pa꞉ta꞉ alota꞉ Wetepena꞉ nakana꞉ma꞉ kilikimanu ota꞉ pa na a꞉elipikie leekeme. Koto leeketa꞉ mo nose kutaa kone hapiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hapieke ekita꞉ mo disaipolo haliwekima꞉ handaata꞉ penkilipa꞉tia pominolo hata꞉ Yesu pa꞉ta꞉ alota꞉ Mo noseta꞉ ekipa a̱i̱ koto kone hapua pa꞉la꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesuma꞉ hombo peaaso alota꞉ I̱ma꞉ iki pa꞉ta꞉ ota꞉ ota꞉ pi alome. Ikana꞉ma꞉ hone tulaaso hata꞉ hone ma꞉nda꞉ na wimika꞉na꞉ta꞉ kota꞉ I̱ma꞉ mo nose ti pa꞉ta꞉ pua꞉ tupa꞉ kone ikana꞉ma꞉ make ana꞉na꞉ pea꞉peke yelieke. Kota꞉ koto hau homeke dia꞉ ya꞉la꞉pate ikana꞉ma꞉ ika꞉ kone do pote pa꞉ta꞉ alo hata꞉ Oni ikali pa꞉ta꞉ pua lopee lemeka꞉na꞉ta꞉ kota꞉ mo potema꞉ ota꞉ pilieke. ");
INSERT INTO ssx_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ikana꞉ma꞉ ota꞉ hone tulaemeka꞉na꞉ta꞉ kota꞉ mo ika꞉ yeni pitolo honke alo alemeeki kone ota꞉ milimikie. ");
INSERT INTO ssx_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuma꞉ mo Tembolo da pa꞉ta꞉ paa la꞉ka꞉la a꞉pa pita꞉ wanda꞉hali pa꞉ta꞉ pi walolo haena꞉ mo yeni peao haemeke haliwekina꞉ you haliweki make mandane da handeteke haemeke you haliweki make ipiki pa꞉ta꞉ a꞉pa alota꞉ Hande pu haleeki manuta꞉ ekieki pea pu hata꞉ pipe kutupa make neketa꞉ epima꞉ wele peaeya꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ I̱ma꞉ iki pa꞉ta꞉ lota꞉ pitoloeki homeke kone opua la kimika꞉na꞉ta꞉ kota꞉ iki pa꞉ta꞉ make mo I̱ma꞉ pu halo hau manuna꞉ wele peao hala꞉ halina꞉ biki la kulueke. ");
INSERT INTO ssx_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Dionima꞉ bapitaisi peao haya꞉ hauta꞉ hepeni nane ekipe o kenke wanda꞉halina꞉ ekipe iki pa꞉ta꞉ lota꞉ pitolome leekeme. Koto pi opuata꞉ mo haliwekima꞉ ika꞉ ika꞉ kone pi dupa lemekeme. Hepeni nane ekie loma꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ niki pa꞉ta꞉ alota꞉ Dionima꞉ lo haya꞉ pi manuta꞉ pa ekipeke na miniki haemepe lelieke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kutaa make ikana꞉ma꞉ alo hata꞉ta꞉ Pa kenke wanda꞉halina꞉ ekie lolo poloma꞉eki make do wanda꞉hali paala꞉ pa꞉la꞉me. Pa ekipeke iki paeyaoma꞉ Dionita꞉ Koda꞉na꞉ pi la꞉ mea halo haya꞉ halie lo halememe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Koto ekina꞉ ikana꞉ma꞉ Yesu pa꞉ta꞉ alota꞉ Niki na handoloma꞉me lemekeme. Koto lemeke Yesuma꞉ hombo peaaso alota꞉ Kota꞉ I̱ma꞉ make yaka pu halo hau manuna꞉ wele peao hala꞉ halina꞉ bikita꞉ iki pa꞉ta꞉ na la kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Do ekina꞉ta꞉ ikana꞉ma꞉ eki hone witemepe. Hali homekema꞉ weki yaapo mondu wiekeme. Kutupata꞉ nate ma꞉nda꞉na꞉ ipika꞉ mupeke weki pa꞉ta꞉ puaata꞉ dupa leekeme. Ya wekio. Neketa꞉ ame mo ya hande waini pu ena꞉ e pokolo poelena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Titina꞉ta꞉ mo wekima꞉ kipieke na pokolo polueke leekepate kone pa wetepena꞉ ipika꞉ hone topo pea wiaata꞉ paa pokolo peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kutupa mo halima꞉ ipika꞉ wetepe weki pa꞉ta꞉ make homeke tupa꞉ kone pua leekeme. Koto leekeeki opuaata꞉ ipika꞉ wetepe wekima꞉ alota꞉ A꞉pa꞉la꞉ma꞉ pulueke leekepate pa na pulupeke kiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kutupa koto weki yaapo ma꞉nda꞉ hondoma꞉ta꞉ mo hande atekema꞉ hone piekeeki peayekepe leekeme. Ikana꞉ma꞉ hombo peaaso alota꞉ Ipika꞉ mupeke wekima꞉ homekee. Koto laata꞉ Yesuma꞉ alota꞉ I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Hande dakisi mu hala꞉ haliweki pita꞉ yolo haleme tapakema꞉ iki mina꞉pa꞉lao ikana꞉ma꞉ amba꞉la oli Koda꞉na꞉ Kilu Tombuao Hala꞉ pa꞉ta꞉ pu halememe. ");
INSERT INTO ssx_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Hande Dioni bapitaisi peao haya꞉ somema꞉ta꞉ iki teke pa꞉ta꞉ a꞉pa hata꞉ mo lea꞉ pi opua ota꞉ na miniki haememe. Pate mo hande dakisi mu haleme tapake pita꞉ yolo haleme tapakema꞉ta꞉ ipika꞉ pi opua ota꞉ pimikime. Kota꞉ koto hoke wanda꞉halima꞉ pimi ekita꞉ ikana꞉ma꞉ mo handolo hata꞉ kone wetepe ika꞉ hone topo pea hone na tulaememe. ");
INSERT INTO ssx_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesuma꞉ alota꞉ Onkoluma꞉ pi ma꞉nda꞉ doma꞉ ikana꞉ma꞉ opua꞉pe. Hali homeke ma꞉nda꞉ ipika꞉ kenke tieke wiekeme. Koto kenke pa꞉ta꞉ta꞉ waini pu e pokeekeme. Kutaata꞉ mo eta꞉ pape piekeme. Kutupa mo waini kiliki yombu tombua bepi pia꞉peke naku awaata꞉ mo ena꞉ pake nala꞉ hali handeteke pitepeke da hokulupeke a꞉eliayekeme. Kutaata꞉ mo hande eta꞉ mandane haliwekima꞉ handeteke haena꞉ yenki tieketa꞉ ika꞉ minolo hata꞉ hosikima꞉ta꞉ ipiki pa꞉ta꞉ hala꞉tiki pina꞉yeke iki pa꞉ta꞉ halaa ipikita꞉ papate peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wetepena꞉ mo waini kiliki talemeke nate opolo epeeketa꞉ mo hande haliwekima꞉ wialimi ipika꞉ putu piliki meaena꞉ta꞉ ipika꞉ e pokaemeke haliweki iki pa꞉ta꞉ tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kutu piekepate mo e handeteke haemeke haliwekima꞉ iki handaa da꞉ka꞉pa꞉ minolo hata꞉ ma꞉nda꞉ta꞉ yombua bao kutupa ma꞉nda꞉ta꞉ ota꞉ homena꞉ lu make ma꞉nda꞉ta꞉ toopima꞉ limikime. ");
INSERT INTO ssx_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kutu pieketa꞉ mo hande e poko halaa peeke somema꞉ mo hande ipika꞉ amba꞉ tapaeyeke haliweki haka꞉ta꞉pake e pokaemeke mandane haliweki tapaeyekeme. Kutu piekepate mo e handeteke haemeke haliwekima꞉ iki pa꞉ta꞉ mandake hau ombu pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Paeyaaso naneta꞉ mo hande e teke halima꞉ mo hande haliweki pa꞉ta꞉ ota꞉ ipika꞉ weki iki pa꞉ta꞉ pena꞉ tapaeyekeme. Ipika꞉ honema꞉ kone alota꞉ Ya wekina꞉ pita꞉ ota꞉ opua pilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kutu piekepate mo hande e handeteke haemeke haliwekima꞉ mo hande teke halima꞉ tapaeyeke weki epeekeeki handaata꞉ kota꞉ ikana꞉ma꞉ ika꞉ hone lombolo hata꞉ alota꞉ Hande e tekehali ipika꞉ anketeke mulu pa꞉la꞉ wekita꞉ koto ipula꞉ma꞉ ota꞉ lumana꞉e la alota꞉ Luma꞉ka꞉na꞉ta꞉ mo eta꞉ kota꞉ ota꞉ nika꞉ e wilieke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Koto laata꞉ ikana꞉ma꞉ mo some da꞉ka꞉pa꞉ minimikime. Ta꞉nka꞉pa꞉ minaata꞉ mo e tikene yola꞉ mea miniki puaata꞉ lia homaemekeme leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Koto pimanu la paeyeketa꞉ Yesuma꞉ iki lota꞉ pitolo alota꞉ Do ena꞉ tekehali opolo epea꞉ka꞉na꞉ta꞉ kota꞉ mo e handeteke haleme haliweki iki pa꞉ta꞉ta꞉ ipikana꞉ma꞉ eki haumanu pealia꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ikana꞉ma꞉ ipika꞉ pi hombo peaaso alota꞉ Ipikana꞉ma꞉ mo hoke haliweki homena꞉ liaata꞉ mo waini kiliki talimi natena꞉ ika꞉ eki minolo hata꞉ putu piliki ipiki pa꞉ta꞉ epeke tupa꞉ hala꞉tiki pulu pa꞉la꞉ mandane haliwekima꞉ handeteke haena꞉ haliekee lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Mo Baibolo bukana꞉ wape pea ula꞉ pima꞉ta꞉ dupa la꞉la꞉ma꞉ na yata꞉pelemepe. Mo da a꞉eyo haemeke haliwekima꞉ Hoela꞉me laa kiaemeke toopi kone ameta꞉ keneme pa꞉ta꞉ mo dana꞉ teke toopi ula꞉me. Kutu pieke ekita꞉ Tekehalima꞉ kone pia꞉me. Koto ekina꞉ koto hau nikana꞉ma꞉ handolo hata꞉ Ba꞉sa꞉sa꞉e. Tekehalima꞉ peaasa꞉ haue aloma꞉me laa la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Koto ekina꞉ta꞉ iki pa꞉ta꞉ I̱ma꞉ dupa alome. Mo iki pa꞉ta꞉ kieke Koda꞉na꞉ Kilu Tombuao Hala꞉ ekita꞉ paa yoka꞉ mea mo epeke kiliki a꞉elo pa꞉la꞉ wanda꞉hali pa꞉ta꞉ halieke alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mo koto toopi manda lopilia꞉ hali ma꞉nda꞉ a꞉nda꞉ta꞉ ota꞉ pindi pilieke. Kutupa make mo toopima꞉ hali ma꞉nda꞉ a꞉nda꞉ manda lopea꞉ka꞉na꞉ta꞉ kota꞉ mo someta꞉ yombua bao dokolo au lalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mo hande Pa꞉tisi haliwekima꞉ make yeni peao haemeke you haliwekima꞉ make mo hande Yesuma꞉ leeke onkoluma꞉ pi opitolota꞉ ika꞉ hone pa꞉ta꞉ta꞉ Nikina꞉ kone ala꞉me hone witolo hata꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ikana꞉ma꞉ Yesu da꞉ka꞉pa꞉ minuluekema꞉ taapemekepate wanda꞉halima꞉ Yesuta꞉ potopede hali hala꞉me hone wimiki handaa ikana꞉ma꞉ mo wanda꞉hali pa꞉ta꞉ paala꞉ma꞉ homolo hata꞉ paemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuma꞉ wanda꞉hali pa꞉ta꞉ pi loluekema꞉ta꞉ onkoluma꞉ pi manuma꞉ paa la halolo alota꞉ dupa ");
INSERT INTO ssx_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Mo hepenina꞉ Kilu Tombuao Hala꞉ ekina꞉ hau pa꞉la꞉ ekita꞉ do tupa꞉ pa꞉la꞉me. Nate homeke ma꞉nda꞉na꞉ mo kini hali homekema꞉ ipika꞉ eiyekena꞉ wanda꞉ hapita꞉la꞉ ne pambaluekema꞉ tikitiki yayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kutupata꞉ koto ne nolo epena꞉ta꞉ mo ika꞉ bikimanu ula꞉ wanda꞉hali handa꞉ mulu pa꞉na꞉ ipika꞉ e pokaemeke haliweki tapaeyekepate mo hande biki wia꞉ wanda꞉hali paeyaoma꞉ta꞉ a꞉pa꞉pa꞉peke kiaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kutu pimikita꞉ mo hande kini halima꞉ pa ipika꞉ mandane e pokaemeke haliweki iki pa꞉ta꞉ do pi paa pua lawape laa tapaaso alota꞉ Ya neta꞉ amba꞉ tikitiki yaasome. Ya hali kao ma꞉na꞉manu make imeke piki kao mandane ekimanu make lu kepa ala꞉ta꞉ ala꞉ta꞉ paeyao tikitiki yao witoloma꞉ a̱i̱ ipupa꞉ lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mo biki amba꞉ wia꞉ wanda꞉halima꞉ koto leeke pi opemekepate pa kiao ika꞉ hone piekeeki ta꞉ta꞉ ta꞉ta꞉ pulu pemekeme. Hali ma꞉nda꞉ta꞉ ipika꞉ e pokolo peekeme. Hali ma꞉nda꞉ta꞉ ipika꞉ sidowa pa꞉ta꞉ e pokolo peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kutaa make mandane haliwekima꞉ta꞉ mo hande tapaeyeke haliweki da꞉ka꞉pa꞉ minaata꞉ luma꞉ luma꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kutu pimikieki mo kini halima꞉ opitolo hata꞉ mineke tieke wopu pankeke handaa mo hande haliweki lu make ika꞉ da tekemanu yanko pina꞉ ipika꞉ ami haliweki tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kutu pieketa꞉ mo kini halima꞉ ipika꞉ e pokaemeke haliweki pa꞉ta꞉ alota꞉ Ya wekina꞉ wanda꞉ mina꞉la꞉ ne pamba꞉la꞉ ekita꞉ tikitiki yao ula꞉pate mo hande biki amba꞉ wia꞉ wanda꞉halita꞉ ana꞉ na piki wanda꞉hali ya꞉la꞉ ekina꞉ ");
INSERT INTO ssx_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ikana꞉ma꞉ mo toko pota꞉ tieke tieke pa꞉ta꞉manu pua handilimi wanda꞉hali paeya tapaota꞉ pa mo ne nolo ipupe lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Koto leeke opuaata꞉ mo e pokaemeke haliwekima꞉ mo toko pota꞉ tieke tiekemanu paeyao pa꞉ta꞉ wanda꞉hali weiya momba꞉laluekema꞉ pemekeme. Puaata꞉ ikana꞉ma꞉ hoke wanda꞉hali epeke wanda꞉hali paeyao momba꞉laota꞉ mo hande ne mombelemeke da pa꞉ta꞉ hatuku mea pemekeme. Kutu pieketa꞉ koto wanda꞉halima꞉ mo hande Kini halina꞉ da ota꞉ tumbaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Koto a꞉pa pitimiki wanda꞉hali handuluekema꞉ta꞉ mo hande kini halima꞉ da pa꞉ta꞉ hondo pambeekeme. Kutu pitolo hata꞉ handeekepate hali homekema꞉ mo hande wanda꞉ mina꞉la꞉ natena꞉ pambaasa꞉ aka꞉ na pambao pitiekeeki handa꞉ wiekeme. Kutu pieke mo kini halima꞉ mo hali pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Someo. Mo hande aka꞉ na pambaaketa꞉ do pa꞉ta꞉ ekipa epepe laa lota꞉ piekepate mo somema꞉ pi ma꞉nda꞉ na leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kutu pieke mo kini halima꞉ ipika꞉ e pokaemeke haliweki pa꞉ta꞉ alota꞉ Koto halina꞉ kiki anke yaapo tonkao lepe peaata꞉ mo timba꞉ la pambeke pa꞉ta꞉ hama yolo lopaapa꞉peke. Koto pa꞉ta꞉ta꞉ ipika꞉ kake lenkene laaso hata꞉ e̱ wi lo haena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesuma꞉ koto pi lo paeyaaso hata꞉ alota꞉ Wanda꞉hali woputa꞉ wi ala꞉pate homeke homeketa꞉ ma̱leke lila꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mo hande Pa꞉tisi haliwekima꞉ta꞉ mo Yesuma꞉ leeke pi opuaata꞉ hama nane a꞉nda꞉ pua lombolo hata꞉ta꞉ ipikana꞉ma꞉ pi lo hoeyaasa꞉eki handuluekema꞉ lota꞉ pita꞉la꞉ pimanu hone pambao wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mo hone pambao wimiki lota꞉ pita꞉la꞉ pi manuma꞉ ipiki tamuluekema꞉ ika꞉ disaipolo haliweki make Hetodi ame̱le̱ ta꞉ma꞉ni pieke haliweki make Yesu pa꞉ta꞉ tapaemekeme. Koto haliweki a꞉pa ipiki pa꞉ta꞉ alota꞉ Wala꞉la꞉ Halio. Neketa꞉ ota꞉ pimanu lo hala꞉ halie. Kutaa nakana꞉ma꞉ wanda꞉hali pa꞉ta꞉ hone ma꞉nda꞉ ma꞉nda꞉ na u hake iki paeyao pa꞉ta꞉ mandake hau piki wanda꞉halie laaka꞉na꞉ Koda꞉na꞉ ota꞉ hau pita꞉la꞉ pi homeke walo haleme la alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Naka꞉ wili honeta꞉ eki hone wilipe. Niki opuomono lakia꞉peke. Mo kapomani tieke Sisa pa꞉ta꞉ dakisi mani hala꞉la꞉ ekita꞉ a꞉pa꞉la꞉pe o hoela꞉pe. Halomana꞉pe o na halomana꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Koto lemeketa꞉ Yesuma꞉ ika꞉ kekeke hake hone pambao wimikieki handolo hata꞉ alota꞉ Ikita꞉ hoke makeaasa꞉ haliwekie. Ya anketa꞉ ekipeke yola꞉ lemepe laa la alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mo dakisi hamba꞉la꞉ toopi homeke I̱ pa꞉ta꞉ wala꞉pe leekeme. Koto leeke ikana꞉ma꞉ toopi homeke ipiki pa꞉ta꞉ mea a꞉pa halemekeme. Kutu pimiki handa iki pa꞉ta꞉ mea walolo alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Do a̱o̱ a̱o̱ pita꞉ biki yaapota꞉ epina꞉eki ka꞉ta꞉pe laa lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sisana꞉ ekie lemekeme. Koto lemeke Yesuma꞉ iki pa꞉ta꞉ alota꞉ Sisana꞉ alemanu meata꞉ kota꞉ Sisa pa꞉ta꞉ kone pa mea hala꞉pa꞉peke. Kutupa Koda꞉na꞉ alemanu ya꞉ka꞉na꞉ta꞉ kota꞉ Koda꞉ pa꞉ta꞉ kone pa mea hala꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mo haliwekima꞉ koto pi opuaata꞉ penkili polo hata꞉ Yesu haena꞉ mina꞉pa꞉lao pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Koto homeke natena꞉ kone pa mandane Sa꞉dusi haliwekima꞉ Yesu ombu lota꞉ puluekema꞉ epemekeme. Mo Sa꞉dusi haliwekita꞉ mo hande ota꞉ homemeke wanda꞉hali paa na tialieke lo haemeke haliwekie. ");
INSERT INTO ssx_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ikana꞉ma꞉ Yesu pa꞉ta꞉ a꞉pa lota꞉ pitolo alota꞉ Wala꞉la꞉ Halio. Mosesima꞉ alota꞉ Hali ma꞉nda꞉ma꞉ ipika꞉ hameke mupeke halita꞉ wanda꞉ pa haena꞉ wekiwandiki na mendiki homea꞉ka꞉na꞉ta꞉ kota꞉ mo ipika꞉ hameke wetepe nane halima꞉ wanda꞉ kosa꞉ piki meata꞉ ipika꞉ homeeke hamekena꞉ wekiwandiki sunu mendiaena꞉ lena꞉e la꞉la꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Koto ekina꞉ hama̱la̱꞉ hama̱la̱꞉ watake hata꞉ do pa꞉ta꞉ haemekeme. Kutupa mo mupeke halita꞉ wanda꞉ mea hao homeekeme. Kutu piekepate ipikana꞉ma꞉ weki ma꞉nda꞉ na mondu wiki homeeke handaata꞉ mo wanda꞉ kosa꞉ pikita꞉ ipika꞉ hoki pa꞉ta꞉ halima꞉ miekepate pa ipikana꞉ma꞉ make ");
INSERT INTO ssx_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","wekiwandiki na mondu wiki homeekeme. Koto some homeeketa꞉ paa tepo peao halima꞉ miekepate make koto homeke hau kone piekeme. Hameke hama̱la̱꞉ hama̱la̱꞉ watake hata꞉ hali paeya tapao pa꞉ta꞉ koto homeke hau kone piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kutu pea꞉tiki pua paelo pulu hata꞉ta꞉ mo hande wanda꞉ make homeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kutu piepate mo wanda꞉hali paa tialimi natena꞉ta꞉ mo hande wanda꞉ta꞉ ota꞉ epina꞉ wanda꞉ halia꞉pe. Pa ekipeke mo hande watake hata꞉ hali paeyaoma꞉ mo homeke wanda꞉ kone mimiki ekina꞉ alome lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Ikana꞉ma꞉ pi tieke lo hoeyaasememe. Pa ekipeke. Ikana꞉ma꞉ mo Baibolo bukana꞉ wape pea ula꞉ ekimanu pita꞉ Koda꞉na꞉ wele pu hala꞉ ekimanu yaapo na handelememe. ");
INSERT INTO ssx_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Amba꞉ homemeke wanda꞉halima꞉ paa tiaemeka꞉na꞉ta꞉ wanda꞉ na miki hali na peke oli hepeni nane enisolo tapake haleme tupa꞉ pa hao halimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kutupa Yesuma꞉ pi ma꞉nda꞉ alota꞉ Mo hande homemeke wanda꞉hali paa tiaalo pelemeeki pa꞉ta꞉ Koda꞉ma꞉ ipika꞉ wape pea ula꞉ pina꞉ iki pa꞉ta꞉ lea꞉ pita꞉ na yata꞉pemepe. Ipikana꞉ma꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","I̱ta꞉ Eipoloha꞉ma꞉na꞉ Koda꞉ make Aisa꞉kena꞉ Koda꞉ make Dieikopena꞉ Koda꞉ make halome la꞉la꞉me. Kota꞉ koto Koda꞉ ipikita꞉ deto halo peleme wanda꞉halina꞉ Koda꞉ hala꞉ ekina꞉ta꞉ ipikita꞉ homolo peleme wanda꞉halina꞉ Koda꞉ dia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mo mombelemeke wanda꞉halima꞉ koto leeke pi opitolota꞉ mo pina꞉ paala꞉ pieke penkili polo hata꞉ leke opo handa꞉ hake wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesuma꞉ leeke pi opimiki handaa mo hande Sa꞉dusi tonuma꞉ lapeke pi mateeke e pondo na lemekeeki handolo hata꞉ta꞉ mo Pa꞉tisi tonu make Yesu pa꞉ta꞉ pua mombelemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kutupata꞉ mo Lo Pi walo hayeke hali homekema꞉ Yesu tamuluekema꞉ta꞉ pi dupa lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Wala꞉la꞉ Halio. Mo Lo Pi ula꞉ ekimanu paeya tapaota꞉ hando ekita꞉ ota꞉ tieke anekepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesuma꞉ mo pi hombo peaaso alota꞉ Dihopa naka꞉ Koda꞉ pa꞉ta꞉ naka꞉ puki paeyaoma꞉ make naka꞉ temoko paeyaoma꞉ make naka꞉ hone witeleeki paeyaoma꞉ make pukima꞉ homo hapa꞉peke la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Do alo pi ula꞉ ekita꞉ mandane pi ula꞉eki paeyao ota꞉ lombei piki titina꞉ pi ula꞉ ekie. ");
INSERT INTO ssx_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kutaata꞉ mo namba 2 pi ula꞉eki make mandake tupa꞉ kone dupa ula꞉me. Neke pa꞉ta꞉ naka꞉ kone a꞉ta꞉ma꞉ homele tupa꞉ kota꞉ da wanda꞉hali pa꞉ta꞉ make a꞉ta꞉ma꞉ homo hapa꞉peke la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Do pi ula꞉eki yaapona꞉ tukiki pa꞉ta꞉ mo hande Mosesima꞉ pi wiekeeki paeya tapao make potopede haliwekima꞉ walemeke ekimanu make paeyao do titina꞉ pi ula꞉eki yaapoma꞉ handeteke hala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nate ma꞉nda꞉ a꞉nda꞉ Yesuma꞉ mo mombelemeke mandane Pa꞉tisi haliweki pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ketiso pa꞉ta꞉ta꞉ ikana꞉ma꞉ta꞉ eki hone witemepe. Ipika꞉ apa꞉mei hali tieketa꞉ epipe leekeme. Ikana꞉ma꞉ hombo peaaso alota꞉ Ketisota꞉ Deipidina꞉ tapake wekie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Koto leeke Yesuma꞉ alota꞉ Kota꞉ kotota꞉ ota꞉ ya꞉ka꞉na꞉ta꞉ pa ekipeke handaa mo Holi Sipitidima꞉ Deipidina꞉ hone u tiaaso haena꞉ Deipidima꞉ Ketisota꞉ Tekehalie laa leekepe. ");
INSERT INTO ssx_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Kota꞉ Deipidima꞉ta꞉ dupa leekeme. Mo Dihopama꞉ yaka Tekehali pa꞉ta꞉ dupa leekeme. Naka꞉ a꞉nda꞉ tunkuliki haliwekita꞉ naka꞉ anke oto pa꞉ta꞉ mea pitaaluekema꞉ neketa꞉ yaka popeke nane kiki nanema꞉ pita꞉peke laa la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Deipidima꞉ ipika꞉ kone Ketiso pa꞉ta꞉ta꞉ Yaka Tekehalie la꞉la꞉ ekina꞉ta꞉ kota꞉ Ketisota꞉ pa ekipa ipika꞉ tapake weki haliepe laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mo koto Yesuma꞉ iki pa꞉ta꞉ lota꞉ pieke pina꞉ta꞉ homeke ma꞉nda꞉ a꞉nda꞉ma꞉ hombo peapeke na yeekeme. Kutupa koto pi la hayeke aneta꞉ hali ma꞉nda꞉ma꞉ ipiki la handuluekema꞉ mo lota꞉ pita꞉la꞉ pi mandane ekimanu lapeke paala꞉ma꞉ homolo hata꞉ ota꞉ na leke paekeme. ");
INSERT INTO ssx_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Koto pi wala paeyeke hoki naneta꞉ Yesuma꞉ wanda꞉hali pa꞉ta꞉ make ipika꞉ disaipolo haliweki pa꞉ta꞉ make pi ma꞉nda꞉ dupa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mo hande pi ula꞉ ekimanu walo haleme haliwekima꞉ make mo Pa꞉tisi tonuma꞉ make iki paeyaoma꞉ta꞉ mo hande Mosesima꞉ waleeke tupa꞉ kone iki pa꞉ta꞉ moka꞉la꞉ tiao walo halememe. ");
INSERT INTO ssx_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Koto ekina꞉ta꞉ kota꞉ mo ikana꞉ma꞉ waleleme mana꞉ pimanu paeyao ota꞉ telimea pu hapa꞉peke. Kutu pulu pelemepate mo ika꞉ lokema꞉ pu haleme haumanu homeketa꞉ ota꞉ na honda꞉ mea pea꞉pa꞉peke. Pa ekipeke ikana꞉ma꞉ta꞉ mo ika꞉ waleme pimanu kone ikana꞉ma꞉ta꞉ ota꞉ na pu halemeke handa loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ikana꞉ma꞉ta꞉ wanda꞉halina꞉ peiyoko manda ka꞉nda꞉ piki alemanu tonkao tiao halemepate pa ikana꞉ma꞉ kiao ika꞉ kiki ma̱lekesiki tindipao ma꞉nda꞉ a꞉nda꞉ ota꞉ na tamba꞉ mea tialimikie. ");
INSERT INTO ssx_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ika꞉ pu haleme hau paeyaota꞉ pa wanda꞉halima꞉ handaena꞉ pu halememe. Ika꞉ you taado manda pokede nu dake petipekemanu wepu make kutupa mo kiki maketopa꞉ yaapona꞉ make homeke tupa꞉ kone pokede nu dakemanu wepiaata꞉ Koda꞉na꞉ pi tunkula ula꞉ ekimanu wape pea panko hopa꞉liao yamaata꞉ ta pomua꞉tiki piteme handa꞉e. Kutupa make ika꞉ dau tumiki kake nina꞉ta꞉ ota꞉ haka꞉ta꞉pao au laaseme pu honiki honiki make taa piteme handa꞉e. ");
INSERT INTO ssx_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kutaa make mo haliwekina꞉ honema꞉ta꞉ ne pamba꞉tiki pimiki nate nina꞉ make yeni da pa꞉ta꞉manu pita꞉tiki pimiki nate nina꞉ make wanda꞉halima꞉ mo you haliwekina꞉ pita꞉peke sea manuna꞉ iki ombu mea pitatiki pina꞉yeke ta꞉na꞉ wopu homo halememe. ");
INSERT INTO ssx_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Makedi hama mombili ale nina꞉ wanda꞉halima꞉ iki manda꞉hande pitolo ika꞉ bikimanu mea a꞉meiyaluekema꞉ Disao. Epeke da ka꞉la꞉paasoe la꞉tiki pina꞉ ta꞉na꞉ma꞉ wopu homelememe. ");
INSERT INTO ssx_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mo haliwekima꞉ta꞉ kutu pu halemepate pa ikana꞉ma꞉ta꞉ wanda꞉halima꞉ iki pa꞉ta꞉ Disao pi na lena꞉ lapa꞉peke. Pa ekipeke. Ika꞉ Disata꞉ homeke haena꞉ iki paeyaota꞉ hama̱la̱꞉ hama̱la̱꞉ halememe loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kutupa make ikana꞉ma꞉ do kenkena꞉ ma꞉nda꞉ pa꞉ta꞉ Apa꞉o pi na lapa꞉peke. Pa ekipeke. Ika꞉ Apa꞉ homeke homeketa꞉ hepeni hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kutaa make wanda꞉halima꞉ iki pa꞉ta꞉ You halie pi na lena꞉ lapa꞉peke. Pa ekipeke. Ketiso homeketa꞉ ika꞉ you hali hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mandali epita꞉ iki tukiki pa꞉ta꞉ ika꞉ aneke hali halo pia꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ iki paeyaona꞉ hone pa꞉la꞉ hau peao hala꞉ hali yelieke. ");
INSERT INTO ssx_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pa ekipeke hali epima꞉ ipika꞉ kone I̱ta꞉ tumiki hali hanoe lo halia꞉ halita꞉ kota꞉ ipikita꞉ ota꞉ hosiki siki haena꞉ lelieke. Koto pa꞉la꞉pate epima꞉ ipika꞉ honema꞉ kone dekepo haya꞉ka꞉na꞉ta꞉ kota꞉ koto someta꞉ you hali haena꞉ mea a꞉meiyalieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Koto pi laa paeyeketa꞉ Yesuma꞉ alota꞉ Iki Lo Pi ula꞉eki walo haleme haliweki make Pa꞉tisi haliweki make iki paeyaona꞉ hoke yenki tieke ipuleke handolo ekina꞉ I̱ paala꞉e. Ikita꞉ hoke makeaaso yayapiki hau pu haleme haliwekie. Ikana꞉ma꞉ta꞉ mo hepenina꞉ Kilu Tombuao Hala꞉ eki pa꞉ta꞉ honda꞉ pamba꞉la꞉eki kiaaso hata꞉ta꞉ mo poluekema꞉ hone pa꞉la꞉ wanda꞉hali puaama꞉na꞉ ika꞉ leke popelekena꞉ kone mo honda꞉ pambolo peleme pota꞉ pa꞉ta꞉ pota꞉ kake katolao halememe. ");
INSERT INTO ssx_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Iki mo Lo Pi ula꞉eki walo haleme haliweki make Pa꞉tisi haliweki make iki paeyaona꞉ hoke yenki tieke ipuleke handolo ekina꞉ I̱ paala꞉e. Ikita꞉ hoke makeaaso yayapiki hau pu haleme haliwekie. Ikana꞉ma꞉ta꞉ pa mo hande homeke hali mea ika꞉ tapakena꞉ tunao haena꞉e laa lapeke ekina꞉ kone mo da yu paeyao lia lopao pomu haleme haliwekie. Kutaa mo some handa꞉ wia꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ iki mo ti to hala꞉ ekina꞉ eiyeke tonu halemeeki ota꞉ lombei peao haena꞉ lelimikie. ");
INSERT INTO ssx_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Iki pa꞉ta꞉ hoke yenki tieke ipuleke handolo ekina꞉ I̱ paala꞉e. Ikita꞉ leke holupa pota꞉ na handeke hata꞉ kone Do pota꞉na꞉ ipupe laa lo haleme haliwekie. Ika꞉ waleme pi manuta꞉ dupa Mandali epima꞉ mo tembolo dana꞉ biki la alo hata꞉ hali keke pi la꞉ wia kone paa topo pia꞉ka꞉na꞉ta꞉ pa aleta꞉ ma꞉nda꞉ dia꞉ ya꞉la꞉pate pa mo somema꞉ tembolo da tukiki pa꞉ta꞉ ula꞉ kolona꞉ biki la alo hata꞉ hali keke pi wia꞉ka꞉na꞉ta꞉ kota꞉ koto pita꞉ ota꞉ topo pia꞉peke na ya꞉la꞉me laa walo halememe. ");
INSERT INTO ssx_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ikita꞉ leke holu piki you hoke haliwekie. Hando ekita꞉ ota꞉ ekipe. Mo tembolo da pa꞉ta꞉ pa u pelia hala꞉ kolope o mo kolo yako peao hala꞉ tembolo dape laa I̱ma꞉ iki pa꞉ta꞉ lota꞉ pitolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ika꞉ waleme pi ma꞉nda꞉ta꞉ dupa Mandali epima꞉ mo olodana꞉ biki la alo hata꞉ hali keke pi la꞉ wia kone paa topo pia꞉ka꞉na꞉ta꞉ kota꞉ pa aleta꞉ ma꞉nda꞉ dia꞉ ya꞉la꞉pate pa mo somema꞉ mo oloda manda ula꞉ hotekena꞉ biki la alo hata꞉ hali keke pi wia꞉ka꞉na꞉ta꞉ kota꞉ koto pita꞉ ota꞉ topo pia꞉peke na ya꞉la꞉me laa walo halememe. ");
INSERT INTO ssx_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ikita꞉ leke holu piki haliwekie. Hando ekita꞉ ota꞉ ekipe. Mo oloda manda ula꞉ pa hala꞉la꞉ hotekepe o mo hoteke yako peaasa꞉ olodape laa I̱ma꞉ iki pa꞉ta꞉ lota꞉ pitolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Koto ekina꞉ta꞉ mandali epima꞉ mo olodana꞉ biki laa hali keke pi wia꞉ka꞉na꞉ta꞉ kota꞉ koto somema꞉ mo oloda make mo oloda manda ula꞉ ale paeyao make hali keke pi wita꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Koto tupa꞉ kone hali epima꞉ mo tembolo dana꞉ biki laa hali keke pi wia꞉ka꞉na꞉ta꞉ kota꞉ mo tembolo da make koto tembolo da pa꞉ta꞉ hala꞉ Koda꞉ pa꞉ta꞉ make hali keke pi ombu wita꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kutupa make hali epima꞉ hepenina꞉ biki laa hali keke pi wia꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ Koda꞉na꞉ kilu tumbuao hala꞉ sea make koto seana꞉ pila꞉ Hali pa꞉ta꞉ make hali keke pi ombu wita꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Iki mo Lo Pi ula꞉eki walo haleme haliweki make Pa꞉tisi haliweki make iki paeyaona꞉ hoke yenki tieke ipuleke handolo ekina꞉ I̱ paala꞉e. Ikita꞉ hoke makeaaso yayapiki hau pu haleme haliwekie. Ikana꞉ma꞉ ika꞉ ne tende peaasa꞉ tekia꞉ o pa꞉sa꞉ta꞉ma꞉ handeke ale sunu kiki yaapo telipata꞉ putupa homeke Koda꞉ pa꞉ta꞉ taiti haluekema꞉ yeke epeke telipuluekema꞉ hone wopu u halememe. Kutu pu halemepate kone pa mo wanda꞉halina꞉ ka꞉nda꞉manu epeao epeke tupa꞉ telipeao make a꞉ta꞉ma꞉ homo make ota꞉ tikitiki hau pita꞉la꞉ ekimanu make koto mo hande Lo Pi ula꞉ ekina꞉ ota꞉ titina꞉ pimanu paeyao ota꞉ hone yonka꞉lalememe. Dia꞉me. Kotoeki manuta꞉ ota꞉ pea꞉tiki pitolo hata꞉ mo mandanekeeki make na mina꞉pa꞉lapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ikita꞉ leke holupa pota꞉ na handeke hata꞉ kone do pota꞉na꞉ ipupe laa lo haleme haliwekie. Ika꞉ supumanu pa꞉ta꞉ pila꞉ amumu sikita꞉ epeke tupa꞉ siki talopu mea bao halemepate kone mo kemolo ma꞉na꞉ tieke aneke kone ika꞉ supu tapu pa mea yola꞉niao halememe. ");
INSERT INTO ssx_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Iki mo Lo Pi ula꞉eki walo haleme haliweki make Pa꞉tisi haliweki make iki paeyaona꞉ hoke yenki tieke ipuleke handolo ekina꞉ I̱ paala꞉e. Ikita꞉ hoke makeaaso yayapiki hau pu haleme haliwekie. Ikana꞉ma꞉ ika꞉ kawasomanu pita꞉ kapomanu yaapona꞉ hama꞉ naneta꞉ epeke tupa꞉ tandepa witolo kone tukiki yaapo pa꞉ta꞉ta꞉ lokena꞉ hone pa꞉la꞉ haumanu pita꞉ pasa꞉tei pita꞉la꞉ haumanu paeyaoma꞉ tumbulu bao ula꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Iki leke holupiki Pa꞉tisi haliwekio. Titina꞉ mo ika꞉ kapo tukiki pa꞉ta꞉ tala꞉la꞉ hoke ale amba꞉la tanda꞉pa꞉peke. Kutu pimika꞉na꞉ta꞉ mo kapona꞉ manda make ana꞉na꞉ tanda꞉pa wilieke. ");
INSERT INTO ssx_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Iki mo Lo Pi ula꞉eki walo haleme haliweki make Pa꞉tisi haliweki make iki paeyaona꞉ hoke yenki tieke ipuleke handolo ekina꞉ I̱ paala꞉e. Ikita꞉ hoke makeaaso yayapiki hau pu haleme haliwekie. Ikita꞉ mo hama nane ota꞉ hakepiki ma꞉na꞉ kenke liala꞉ hali lapa꞉da tupa꞉ halememe. Koto hali lapa꞉da manuta꞉ hama꞉ naneta꞉ epeke hau pea hake pea ula꞉pate tukiki pa꞉ta꞉ta꞉ hali toko tandepeke holiki manuma꞉ tumbao u hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Koto hali lapa꞉da tupa꞉ta꞉ wanda꞉halina꞉ leke popelekena꞉ ika꞉ lokema꞉ piteme hau manuta꞉ ota꞉ epeke hau pu hala꞉ haliweki leke halemepate oni tukiki pa꞉ta꞉ta꞉ makea makea hau make hoke hoke hau manuma꞉ make tumbulu baalememe. ");
INSERT INTO ssx_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Iki mo Lo Pi ula꞉eki walo haleme haliweki make Pa꞉tisi haliweki make iki paeyaona꞉ hoke yenki tieke ipuleke handolo ekina꞉ I̱ paala꞉e. Ikita꞉ hoke makeaaso yayapiki hau pu haleme haliwekie. Ikana꞉ma꞉ mo amba꞉ homemeke potopede hali manuna꞉ lapa꞉ mandata꞉ epeke toopi da siki a꞉eyo make mo amba꞉ ota꞉ epeke hau pu hao homemeke wanda꞉halina꞉ nimina tiaasa꞉ a꞉emeke pa hala꞉ ale manuna꞉ au laaso ombu hao halememe. ");
INSERT INTO ssx_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kutu pitolo hata꞉ ikana꞉ma꞉ ika꞉ honema꞉ta꞉ Mo hande ika꞉ apa꞉mei tonu haemeke toma꞉na꞉ haoma꞉ka꞉na꞉ yoluta꞉ kota꞉ nikana꞉ma꞉ mo hande potopede haliweki lia homaema꞉ tupa꞉ na lia꞉tiki pulu puma꞉me laa lo halememe. ");
INSERT INTO ssx_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Koto pi aleme ekima꞉ta꞉ ikana꞉ma꞉ ika꞉ kone mo potopede tonu limiki haliwekina꞉ tapake weki wandiki halemeeki peneme yaasememe. ");
INSERT INTO ssx_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kota꞉ a꞉pa꞉la꞉me. Kotota꞉ mo ika꞉ apa꞉mei tonuma꞉ kini pimiki hoke hau manuma꞉ pa꞉la꞉ma꞉ ikana꞉ma꞉ paa paeyaapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ikita꞉ keto manuna꞉ eiyeke tonu kone keto halememe. Ikana꞉ma꞉ta꞉ iki mo ti to hala꞉ ale pa꞉ta꞉ pomena꞉ tapaalo pa꞉la꞉ ekita꞉ ekieki pa wendulumeke hone wilimipe. ");
INSERT INTO ssx_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Koto ekina꞉ta꞉ I̱ma꞉ iki pa꞉ta꞉ dupiki pi alome. I̱ma꞉ta꞉ mo mandane potopede haliweki make mandane hone wotu ula꞉ haliweki make mo yaka pi wala꞉la꞉ haliwekimanu make iki ame̱le̱ haena꞉ tapaalo polopate mandane haliwekita꞉ ikana꞉ma꞉ lu bao make mandane haliwekita꞉ a꞉ka꞉tei wapepiki tina꞉ lu endialimikie. Kutaata꞉ mandane haliwekita꞉ mo ika꞉ yeni pu haleme da tukiki pa꞉ta꞉ hata꞉ yombua baalimikie. Kutupa mandane haliwekita꞉ da teke homeke pa꞉ta꞉ yokaata꞉ da teke ma꞉nda꞉ pa꞉ta꞉ yoka pa꞉na꞉ tolu lia꞉tiki pilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kutu pilimi ekina꞉ pulu pa꞉la꞉ ekita꞉ dupa alome. Mo hande hoke hau na pimiki epeke wanda꞉hali paeya tapao pa pahameke limiki ekina꞉ yenkita꞉ iki nane la꞉ mea lopaalieke. Koto alo ekita꞉ mo hande hoke hau na pieke Eipolo pa꞉ta꞉ kini pu mea lu tiki puaata꞉ mo hande ikana꞉ma꞉ tembolo da oloda yaapo tukiki pa꞉ta꞉ limiki Beta꞉kia꞉na꞉ eiyeke Sekataiya litolo lunaimeke ekina꞉ alome. ");
INSERT INTO ssx_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","I̱ma꞉ ota꞉ ota꞉ pi alome. Mo hande pa hameke limikieki paeyaona꞉ hoke yenki paeyaota꞉ do ame haleme wanda꞉hali pa꞉ta꞉ ipilieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesuma꞉ alota꞉ Diutuseleme Diutuselemeo. A꞉ta꞉ tiekee. Nakana꞉ma꞉ hoto paeyao mo potopede haliweki lia꞉tiki lia꞉tiki pu make Koda꞉ma꞉ neke pa꞉ta꞉ ipika꞉ pi mea epena꞉ tapaeyeke haliweki make toopima꞉ lu haleme. Hoto paeyao mo hande koka꞉la꞉ inkiki ipika꞉ popakema꞉ ikikimanu panka꞉ mina꞉la꞉ tupa꞉ I̱ma꞉ make naka꞉ wekiwandiki ya kikima꞉ hapisa꞉ pu halopate nakana꞉ma꞉ kiao haleme. ");
INSERT INTO ssx_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Koto ekina꞉ta꞉ naka꞉ data꞉ hankoko taa pa꞉la꞉ handa꞉e. ");
INSERT INTO ssx_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","I̱ma꞉ neke pa꞉ta꞉ alota꞉ Ame do aneta꞉ I̱ a̱i̱ na handolo pelepate pa nakana꞉ma꞉ I̱ pa꞉ta꞉ alota꞉ Tekehalina꞉ biki mea ipula꞉ hali pa꞉ta꞉ ta꞉na꞉e lelipi toma꞉na꞉ta꞉ kota꞉ I̱ pa handilipikie alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuma꞉ mo tembolo da mina꞉pa꞉lao pulu haena꞉ ipika꞉ disaipolo haliweki a꞉pa ipiki pa꞉ta꞉ alota꞉ Do tembolo da a꞉eleme tupa꞉ a꞉pa handa꞉e lemekepate ");
INSERT INTO ssx_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Ikana꞉ma꞉ do da a꞉ela꞉ alemanu paeyao handelemepe. I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Do toopi epeke tupa꞉ atula atula pea uleke handoloma꞉ tupa꞉ta꞉ homeke ma꞉nda꞉ ota꞉ na wilieke. Koto toopi ota꞉ paeya tapaota꞉ mea holao tankulupu bao aneya moneya pea wilieke alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Koto hoki naneta꞉ Yesuma꞉ mo Olipi pote manda pitina꞉ta꞉ ipika꞉ disaipolo haliwekima꞉ a꞉mbao lota꞉ pitolo alota꞉ Nakana꞉ma꞉ mo hande le pita꞉ handima꞉ opolo ipilia꞉pe. Kutaa mo naka꞉ paa la꞉ka꞉la epolo peleeki pita꞉ do yu ya paelo pa꞉la꞉eki yaapo telipina꞉ teke pa꞉ta꞉ ya꞉lia꞉ ekita꞉ eki patehau pilia꞉ ekima꞉ niki walia꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesuma꞉ ika꞉ pi hombo peaaso hata꞉ alota꞉ Ma꞉nda꞉ma꞉ iki pa tupa꞉ hatuku puaama꞉na꞉ma꞉ wopu handeteke hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Hali wopuma꞉ ya biki la꞉ paleke ipulu alota꞉ I̱ta꞉ ota꞉ Ketisoe lelimikie. Koto lelimi ekima꞉ta꞉ wanda꞉hali wopu makealimikie alome. ");
INSERT INTO ssx_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ikana꞉ma꞉ a꞉nda꞉ tiekemanu pita꞉la꞉me lelimi ota꞉ pimanu make pa hameke pi lelimi ekimanu make wopu opulu pelemepate ikana꞉ma꞉ pa pomoma꞉ na homa꞉pa꞉peke. Kutupiki hau manuta꞉ ota꞉ epolo pa꞉la꞉pate pa mo yu ya paelo pa꞉la꞉ ekina꞉ patehau dia꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kenke homekena꞉ ami tiao pua kenke ma꞉nda꞉na꞉ ami tapu a꞉nda꞉ pilimikie. Mo kini hali homekena꞉ ami tiao kini hali ma꞉nda꞉na꞉ ami tapu a꞉nda꞉ pilimikie. Kutu pilia꞉ toma꞉na꞉ta꞉ kenke yu paeyao pa꞉ta꞉ tea꞉ki pambo make yu momeni tiekemanu make opolo ipilieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kutu piki patehau manuta꞉ mo hande wanda꞉na꞉ weki hoki kini pea nala꞉eki manda꞉ pilieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Koto haumanu pilia꞉ toma꞉na꞉ta꞉ mandane haliwekima꞉ iki pa꞉ta꞉ ka꞉nda꞉manu ku make lu puluekema꞉ iki da꞉ka꞉pa꞉ mina꞉ bepi pilimikie. Ikita꞉ yaeki haleme ekina꞉ wanda꞉hali wopuma꞉ iki honditi wopu pilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Koto mandake pita꞉ma꞉ koneta꞉ mandane Koda꞉ pa꞉ta꞉ hone tulaleme wanda꞉hali ika꞉ hone tulalemeeki mina꞉pa꞉lao kialimikie. Kutu pilimi wanda꞉hali pua hata꞉ta꞉ ika꞉ yankekemanu ame̱le̱ honditi pu alualu pitolo ika꞉ ika꞉ kone lina꞉ walo a꞉nda꞉ lomba꞉tiki pu alualu pilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Koto mandake dina꞉ koneta꞉ yayapiki pi walaasa꞉ potopede haliweki wopu tiaaso hata꞉ wanda꞉hali wopu makealieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kenke paeyao pa꞉ta꞉ hoke hoke haumanu opa daeyatiki pea꞉ka꞉na꞉ta꞉ kota꞉ wanda꞉halina꞉ a꞉ta꞉ma꞉ homa꞉la꞉ hau manuta꞉ alupilieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kutu polo haena꞉ kone pa mo hone tulaasa꞉ some epima꞉ ota꞉ hone tulaatiki pu haya꞉ka꞉na꞉ta꞉ kota꞉ koto someta꞉ da꞉ta haena꞉ tamba꞉ milieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kutaata꞉ do Koda꞉na꞉ Kilu Tombuao Hala꞉ ekina꞉ Pi Seliapota꞉ kenke honiki honiki paeyao pa꞉ta꞉ haleme wanda꞉halima꞉ opina꞉ walo pelimikie. Ana꞉na꞉ walo paeyaalimi toma꞉na꞉ta꞉ kota꞉ mo paelo pa꞉la꞉ nate opolo ipilieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Amba꞉ potopede hali Da꞉nielema꞉ ipilieke laa la꞉ wieke yeke hoke hoeyaapeke yeke ale ma꞉nda꞉ handilimikie. Koto aleta꞉ mo hande hoke ale ma꞉nda꞉ wia꞉peke na yeke yako piki da panda꞉ tiao halia꞉eki handilimikie. Do wape yata꞉pa꞉la꞉ halima꞉ hone ota꞉ wopu wina꞉e. ");
INSERT INTO ssx_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Koto dina꞉ta꞉ mo Diudia nane halo peleme wanda꞉halita꞉ mo potemanu pa꞉ta꞉ pindipa pena꞉e. ");
INSERT INTO ssx_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kutupa da holuna꞉ halia꞉ halima꞉ hola꞉pa꞉niao ala꞉ta꞉ ala꞉ta꞉ mea poluekema꞉ da tukiki pa꞉ta꞉ na honda꞉ pambena꞉e. ");
INSERT INTO ssx_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ena꞉ halia꞉ halima꞉ make ipika꞉ dau mea poluekema꞉ hoki la꞉ka꞉la꞉ neao na pa꞉na꞉e. ");
INSERT INTO ssx_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","A꞉ta꞉e. Koto nate tukiki pa꞉ta꞉ manuta꞉ weki pitiki wanda꞉wekima꞉ make andu halimi wanda꞉wekima꞉ make ka꞉nda꞉ tieke milimikie. ");
INSERT INTO ssx_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Koto pilia꞉ dina꞉ta꞉ mo kosa꞉ki make hoto pila꞉ nate make na ipu pina꞉ma꞉ yeni wopu pea꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Koto nate manuna꞉ ka꞉nda꞉ma꞉ homa꞉la꞉eki manuta꞉ ota꞉ hone matekeeki ipilieke. Amba꞉ hande Koda꞉ma꞉ ala꞉ta꞉ ala꞉ta꞉ kini pea wepia wina꞉ leeke dina꞉ kini pu mea a꞉pa ame do haloma꞉ dina꞉ make wanda꞉halima꞉ kutupiki ka꞉nda꞉ ma꞉nda꞉ ota꞉ na handemekeme. Wetepe koto hoki nane make kutu piki ka꞉nda꞉ma꞉ homa꞉la꞉eki ma꞉nda꞉ na ipilieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Koto natena꞉ wanda꞉hali paeyao homolo poloma꞉pate Koda꞉ma꞉ koto nate mandane ekimanu tunkulina꞉ la꞉la꞉me. Pa ekipeke ipika꞉ talopu ma꞉la꞉ wanda꞉hali pa꞉ta꞉ hone wiaata꞉ koto natemanu tunkulina꞉ la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Koto natena꞉ iki pa꞉ta꞉ ma꞉nda꞉ma꞉ alo alota꞉ Handa꞉pe. Ketiso do ane do hala꞉ o mo nane mo hala꞉ lemeka꞉na꞉ta꞉ na opua꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yayapiki Ketisomanu make yayapiki pi la꞉ mea halo hala꞉ haliweki make a꞉pa mo hande Koda꞉na꞉ ma̱leke lila꞉ wanda꞉hali pa nane hatuku mea puluekema꞉ yeke iki makeaapeke ya꞉la꞉o laa makea handuluekema꞉ na handeke hau tieke tiekemanu make wele pita꞉la꞉ ekimanu make walimikie. ");
INSERT INTO ssx_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Iki paeyao opua꞉pe. Koto haumanu paeyao a̱i̱ na epeke haena꞉ I̱ma꞉ iki pa꞉ta꞉ amba꞉ la kolome. ");
INSERT INTO ssx_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pa mandane wanda꞉halima꞉ make iki pa꞉ta꞉ alo hata꞉ Ei. Ipikita꞉ oli hapu hala꞉ alena꞉ hala꞉me lemeka꞉na꞉ make koto pa꞉ta꞉ na pua꞉peke. O pa ma꞉nda꞉ma꞉ alota꞉ Ipikita꞉ do pa꞉ta꞉ panka꞉ pila꞉me lemeka꞉na꞉ make ika꞉ pi ota꞉ na opua꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mo Wanda꞉halina꞉ Eiyekena꞉ epolo pa꞉la꞉ ekita꞉ mo hande ti tekele pita꞉la꞉ ekima꞉ mo ya paeyao olina꞉ onina꞉ pa̱a̱ tieke pita꞉la꞉ tupa꞉ opolo ipilieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ma꞉nda꞉ handopa꞉ta꞉ ma꞉na꞉ hoteke lupa ula꞉ ale nina꞉ta꞉ wapukini mombolo hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Koto ka꞉nda꞉manu milimi natemanu paelia꞉ hoki naneta꞉ oli natema꞉ timba꞉ lo pamba hao make sumba꞉na꞉ pa̱a̱ make na pilieke. Kutaa oli yana꞉ hombulanka꞉manu make ya nane hao honda꞉ papa pu lopa꞉tiki pilieke. Kutaa oli ya nane wele peaasa꞉ ekimanu make la꞉ma꞉ la꞉ma꞉ pupa wilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kutu pilia꞉ natena꞉ta꞉ mo Wanda꞉halina꞉ Eiyekena꞉ epolo pa꞉la꞉ patehauta꞉ oli yana꞉ peneme yaalieke. Kutu pilia꞉eki wanda꞉hali paeyaoma꞉ handolo hata꞉ e̱ tieke lelimikie. Ikana꞉ma꞉ mo Wanda꞉halina꞉ Eiyekema꞉ koa manda ha mea ipulu hata꞉ ipika꞉ wele wotu pita꞉la꞉eki make pa̱a̱ tieke pita꞉la꞉eki make mea opolo ipilia꞉eki handilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kutu pilia꞉ dina꞉ta꞉ bu kanake tieke homekema꞉ e̱ tieke alo haena꞉ta꞉ ipikana꞉ma꞉ oli nate pamba꞉la꞉ opa꞉la꞉ yaapo nane make olina꞉ onina꞉ yaapo paeyaona꞉ haleme ipika꞉ ma̱leke lila꞉ wanda꞉hali momba꞉lawaena꞉ ipika꞉ enisolo tonu tapaa tapaa pilieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Nose tima꞉ pu hala꞉eki hone wia꞉pa꞉peke leekeme. Ipika꞉ paleke ada꞉ pea katake tindiki lia kelepea꞉ka꞉na꞉ta꞉ kota꞉ bapi ipuluekema꞉ pita꞉la꞉me hone u halememe. ");
INSERT INTO ssx_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kutupa make hande loa꞉ alemanu ipula꞉eki handemeka꞉na꞉ta꞉ tekepa꞉ta꞉ ya꞉la꞉me laa pota꞉ kake pa꞉ta꞉ a꞉pa hala꞉me hone wia꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iki pa꞉ta꞉ ota꞉ pi alome. Do haleme wanda꞉hali paeyao na homeke halimi pita꞉ I̱ma꞉ loa꞉ alemanu paeyao amba꞉ ipilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Oli ya do kenke yaapota꞉ paelo pa꞉la꞉pate yaka pi lo haloeki manuta꞉ na paelieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kutu piliepate hande loa꞉ nate epolo pa꞉la꞉ ekita꞉ ma꞉nda꞉ma꞉ na handa꞉la꞉me. Nate handopa꞉ta꞉ haena꞉ epolo pa꞉la꞉ ekita꞉ make ma꞉nda꞉ma꞉ na handa꞉la꞉me. Oli ya nane haleme enisolomanu make Eiyekema꞉ make na handoloma꞉pate Atekema꞉ homeke handa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hande Noana꞉ natena꞉ pimiki tupa꞉ta꞉ hande Wanda꞉halina꞉ Eiyeke epea꞉ka꞉na꞉ make mandake hau kone pilimikie. ");
INSERT INTO ssx_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ikali tala꞉eki tieke a̱i̱ na epeeke toma꞉na꞉ta꞉ wanda꞉halima꞉ ne ikalimanu na꞉moneatiki pu wanda꞉ hapu moneatiki pu pua꞉tiki puaata꞉ mo Noa kawaso pa꞉ta꞉ honda꞉ pambeeke dina꞉ naemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Koto wanda꞉halima꞉ta꞉ wetepe epolo pieke hau manuta꞉ hone na wiki pa ika꞉ hone pieke haumanu pua꞉tiki pulu haena꞉ hande ikali tieke taa ipulu iki paeyao handa꞉pa꞉la꞉ mea peekeme. Mo hande Wanda꞉halina꞉ Eiyeke opolo ipuluta꞉ koto piekeeki kone pilieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Koto toma꞉na꞉ta꞉ yaapo halima꞉ homeke e pokolo halipipi alena꞉ta꞉ homeke hali minolota꞉ ma꞉nda꞉ta꞉ mina꞉pa꞉lalieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kutupa yaapo wanda꞉ma꞉ palaowa dakole peaaso halipipi alena꞉ta꞉ homeke wanda꞉ honda꞉ minolota꞉ ma꞉nda꞉ta꞉ mina꞉pa꞉lalieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Koto ekina꞉ta꞉ ikana꞉ma꞉ta꞉ u na polu pitiki yu wia hapa꞉peke. Pa ekipeke mo ika꞉ Tekehalina꞉ epolo pa꞉la꞉ dita꞉ iki matelememe. ");
INSERT INTO ssx_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Da tekehali homekema꞉ pake nala꞉ halima꞉ pake noluekema꞉ do natena꞉ opolo ipilieke hone wia꞉ka꞉na꞉ yoluta꞉ kota꞉ ipika꞉ da yamba꞉laama꞉na꞉ alo u na piliki paa tiao yu wia halo pia꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ikana꞉ma꞉ make koto pieke tupa꞉ kone hoto paeyao tikitiki yao hapa꞉peke. Pa ekipeke. Mo Wanda꞉halina꞉ Eiyeketa꞉ ikana꞉ma꞉ dupita꞉ma꞉ ipilieke hone na wilimi natena꞉ opolo ipilieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Hande hone wopu wia pi wopu opua epeke e poko hala꞉ someta꞉ epiyekea. Kutu piki halita꞉ mo e teke halima꞉ ipika꞉ e pokaaseme mandane haliweki handeteke hawaaso hata꞉ ika꞉ nemanu ota꞉ epeke tupa꞉ hala꞉tiki pina꞉ mea halieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kutupa hoki nane nate ma꞉nda꞉na꞉ hande you hali paa la꞉ka꞉la a꞉pa mo hande e pokaena꞉ mea hao pea꞉ halima꞉ ipika꞉ lea꞉ pi paeyao opua ota꞉ epeke tupa꞉ pea꞉tiki pilia꞉eki a꞉pa handea꞉ka꞉na꞉ta꞉ kota꞉ koto e pokaasa꞉ somema꞉ta꞉ ta꞉na꞉ma꞉ homa hapeke yelieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Koto you halima꞉ kutu piki someta꞉ ipika꞉ e ala꞉ta꞉ ala꞉ta꞉ paeya tapao handeteke haena꞉ mea halieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kutu pilia꞉pate mo e pokaasa꞉ somema꞉ hone witolota꞉ Hande ya teke halita꞉ a̱i̱ na a꞉pa꞉peke ya꞉lieke hone witolo hata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ipika꞉ e mandake pokaaseme haliweki lu yombua꞉tiki pu make hoke ikali nemeke tapake ame̱le̱ apa꞉tao ne ikali naa kea꞉tiki pu haya꞉ka꞉na꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kota꞉ koto somena꞉ you halita꞉ ipilieke hone na wilia꞉ nate o tikitiki na yao halia꞉ dina꞉ ipilieke. ");
INSERT INTO ssx_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Epia꞉ka꞉na꞉ta꞉ kota꞉ mo you halima꞉ koto some mea ota꞉ hoeyaaso hata꞉ mo hande makeaasa꞉ haliweki mea tapaaleke pua haleme pa꞉ta꞉ ipiki make mea lopaalieke. Koto pa꞉ta꞉ hata꞉ta꞉ ikana꞉ma꞉ e̱ tieke laa kake lenkene latiki pu halimikie. ");
INSERT INTO ssx_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesuma꞉ alota꞉ Koto nate a꞉nda꞉ opolo epea꞉ka꞉na꞉ta꞉ mo hande hepenina꞉ Kilu Tombuao Hala꞉ ekina꞉ hauta꞉ do tupa꞉ pia꞉ka꞉na꞉ handilimikie. Nate ma꞉nda꞉na꞉ kiki yaapo wandiki tonu a꞉nda꞉ma꞉ wanda꞉ mulu pieke hali epeeke manda꞉hande pea handa꞉ mea ipuluekema꞉ ika꞉ ka꞉ta꞉sini ola꞉pake mea mina pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kutupa kiki homeke wandiki tonuma꞉ta꞉ hone wopu na wimikipate pa kiki homeke ma꞉nda꞉ haemeke wandiki tonuma꞉ta꞉ hone wopu wimiki wandiki yekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Hande hone wopu na wimiki wandiki tonuma꞉ta꞉ ika꞉ ola꞉pake epeke keo mina pemekepate pa wetepena꞉ hola꞉ pamba꞉peke ekita꞉ ma꞉nda꞉ na yupu miniki pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pate hande hone wopu wimiki wandiki tonu ika꞉ ola꞉pake ta꞉pao paeyaama꞉na꞉ iki homeke homekema꞉ ika꞉ ola꞉pake tonka꞉na꞉ ka꞉ta꞉sini kanake mea miniki miniki pea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hande wanda꞉ mulu pieke some a̱i̱ na opolo epeeketa꞉ mo hande wandiki paeyao u tonda꞉pao u polu pitimikime. ");
INSERT INTO ssx_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kutaa buta꞉hoki nane yopua paeyeketa꞉ ma꞉nda꞉ma꞉ wi tieke la alota꞉ Hande wanda꞉ mulu pa꞉la꞉ halita꞉ do ipula꞉ma꞉ a꞉pa manda꞉hande pipee leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Koto leeketa꞉ mo wandiki tonu paeyao tiao ika꞉ ola꞉pake lankake honda꞉pa꞉ bepe pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Koto pitolo hata꞉ mo hande hone wopu na wimiki wandiki tonuma꞉ mo ika꞉ hone wopu wimiki asi tonu nane alota꞉ Asi tonuo. Nika꞉ ola꞉pakemanu pa꞉ta꞉ ka꞉ta꞉sini paetolo hata꞉ honia꞉la꞉me. Ika꞉ ka꞉ta꞉sini ma꞉nda꞉ hoela꞉ pambaapee laa honke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Koto lemekepate mo hone wopu wimiki wandiki tonuma꞉ hombo peaaso alota꞉ Dia꞉me. Do ka꞉ta꞉sinita꞉ ika꞉eki nika꞉eki yaapona꞉ta꞉ ana꞉ na pilieke yeke na kulumekee laata꞉ Ika꞉ ekita꞉ ika꞉ kone mo sidowa pa꞉ta꞉manu hambolo pua꞉pa꞉peke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Koto lemeketa꞉ hande hone wopu na wimiki wandiki tonuma꞉ iki mina꞉pa꞉lao mo ika꞉eki ta꞉ta꞉ hambuluekema꞉ pemekeme. Koto pemeke hoki naneta꞉ mo hande wanda꞉ mulu pieke some opolo epeekeme. Kutu pieke toma꞉na꞉ta꞉ mo hande hone wopu wia tikitiki yao haemeke yunki hata꞉ wandiki tonuta꞉ ipiki ame̱le̱ mo hande wanda꞉ mina꞉la꞉ ne noluekema꞉ mombelemeke pa꞉ta꞉ pua pota꞉ poka ne no pitulu pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kutupa wetepena꞉ mo hande ka꞉ta꞉sini mulu peme wandiki tonu la꞉ka꞉la a꞉pa pota꞉ kilikili laaso alota꞉ Tekehalio. Tekehalio. Niki a꞉pomono pota꞉ lomba꞉e laa e̱ wi lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Koto lemekepate mo wanda꞉ mulu pieke halima꞉ hombo peaaso alota꞉ Dia꞉me. I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi aloma꞉ ikita꞉ I̱ wopu na handoloma꞉ ekita꞉ epi amedapee laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesuma꞉ koto pi lo a꞉mbolo hata꞉ alota꞉ Mo ika꞉ Tekehalina꞉ epolo pa꞉la꞉ nate di yaapo iki mateleke handaa loa꞉ma꞉ wopu handeteke hao hapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesuma꞉ alota꞉ Mo nate a꞉nda꞉ opolo epea꞉ka꞉na꞉ta꞉ mo hande hepenina꞉ Kilu Tombuao Hala꞉ ekina꞉ hauta꞉ do tupa꞉ pia꞉ka꞉na꞉ handilimikie. Mo hamoko hali homekema꞉ kenke ma꞉nda꞉ pa꞉ta꞉ puluekema꞉ tikitiki yaaso hata꞉ta꞉ ipika꞉ e pokaemeke haliwekima꞉ ipika꞉ ala꞉ta꞉ ala꞉ta꞉ handeteke hawaena꞉ wi leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ikana꞉ma꞉ peaapeke ane pieke tupa꞉ kone teli peaaso hata꞉ homeke hali pa꞉ta꞉ 5 daoseni kina꞉ halo. Hali ma꞉nda꞉ pa꞉ta꞉ta꞉ 2 daoseni kina꞉ halo. Kutupa hali ma꞉nda꞉ pa꞉ta꞉ta꞉ 1 daoseni kina꞉ halo piekeme. Kutaata꞉ ipikana꞉ma꞉ iki mina꞉pa꞉lao peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mo 5 daoseni kina mieke e pokaasa꞉ halima꞉ kuta kone mo manima꞉ e honkopu hao pokaata꞉ 5 daoseni ma꞉nda꞉ apa꞉tao wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Koto mandake tupa꞉ kone mo 2 daoseni mieke e pokaasa꞉ halima꞉ koto manima꞉ e pokaata꞉ 2 daoseni ma꞉nda꞉ apa꞉tao wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kutupate mo hande 1 daoseni mieke e pokaasa꞉ halima꞉ta꞉ ipika꞉ you halina꞉ manita꞉ mea pua naku awa ti tieke pa꞉ta꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bapi mandaneeki hao hoki naneta꞉ mo e pokaemeke haliweki ika꞉ you halima꞉ ika꞉ pokaemeke emanu handoma꞉ tialuekema꞉ paa epeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kutu pieke toma꞉na꞉ta꞉ mo hande 5 daoseni kina mieke halima꞉ a꞉pa koto 5 daosenima꞉ e poka meayeke 5 daoseni ma꞉nda꞉ halolo hata꞉ alota꞉ You halio. Nakana꞉ma꞉ I̱ pa꞉ta꞉ 5 daoseni kipateta꞉ pa I̱ma꞉ e pokaaso hata꞉ mealo 5 daoseni ma꞉nda꞉ doma꞉ mie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Koto leeke mo you halima꞉ alota꞉ O neketa꞉ ota꞉ epeke somee. Nakana꞉ma꞉ ota꞉ epeke e tieke pokeka꞉ta꞉me. Do hosiki kua꞉eki kone epeke tupa꞉ handeteke haleketa꞉ ameta꞉ nakana꞉ma꞉ ya e tieke handeteke hawalena꞉ mea halueke la alota꞉ I̱ yaapo mandake pa꞉ta꞉ hata꞉ ta꞉na꞉ma꞉ homopana꞉ epoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Koto somena꞉ hoki naneta꞉ mo hande 2 daoseni kina mieke halima꞉ a꞉pa koto 2 daosenima꞉ e poka meayeke 2 daoseni ma꞉nda꞉ halolo hata꞉ alota꞉ You halio. Nakana꞉ma꞉ I̱ pa꞉ta꞉ 2 daoseni kipateta꞉ pa I̱ma꞉ e pokaaso hata꞉ mealo 2 daoseni ma꞉nda꞉ doma꞉ mie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Koto leeke mo you halima꞉ alota꞉ O neketa꞉ ota꞉ epeke somee. Nakana꞉ma꞉ ota꞉ epeke e tieke pokeka꞉ta꞉me. Do hosiki kua꞉eki kone epeke tupa꞉ handeteke haleketa꞉ ameta꞉ nakana꞉ma꞉ ya e tieke handeteke hawalena꞉ mea halueke la alota꞉ I̱ yaapo mandake pa꞉ta꞉ hata꞉ ta꞉na꞉ma꞉ homopana꞉ epoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kutupa koto somena꞉ hoki naneta꞉ mo hande 1 daoseni kina mieke hali a꞉pa make ipika꞉ you hali pa꞉ta꞉ alota꞉ You halio. Neketa꞉ na nokopele ale napeke no make na tande ale alena꞉ kilikimanu talopu hale somee. Koto hauma꞉ta꞉ neketa꞉ taka꞉la papeke hali haleme hone witolo ");
INSERT INTO ssx_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","I̱ma꞉ neke paala꞉ma꞉ homoa꞉me. Koto ekina꞉ mo naka꞉ 1 daoseni kina꞉ kenke awa panka꞉ hoilu poa꞉me. Koto ekina꞉ mo hande naka꞉ ki eki kone doma꞉ paa mie. ");
INSERT INTO ssx_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Koto leeke mo you halima꞉ ipika꞉ pi hombo peaaso alota꞉ Neketa꞉ soka꞉la꞉ pambeke e pokaasa꞉ hoke some ya꞉ka꞉ta꞉me. I̱ta꞉ na noko polo ale manuna꞉ napeke no make na tande alo ale manuna꞉ kiliki talo halo somee hone witolo pita꞉ ota꞉ alome. ");
INSERT INTO ssx_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kota꞉ koto ekina꞉ta꞉ I̱ paa la꞉ka꞉la ipulu hano pa hameke kitoloeki make haka꞉ta꞉pao kita꞉la꞉eki make kimika꞉na꞉ miono ya mani mo ba꞉nka꞉na꞉ wiaapeke alee leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Koto alo hata꞉ iki pa꞉ta꞉ alota꞉ Mo somena꞉ mani pa꞉ta꞉la꞉ meata꞉ mo 10 daoseni meala꞉ some pa꞉ta꞉ hala꞉e. ");
INSERT INTO ssx_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pa ekipeke. Ala꞉ta꞉ ala꞉ta꞉manu amba꞉ wia hala꞉ somema꞉ta꞉ ipika꞉eki lombei pina꞉ loluekema꞉ haka꞉ta꞉pao halea꞉ka꞉na꞉ milieke. Koto pa꞉la꞉pate mo ala꞉ta꞉ ala꞉ta꞉manu wopu na wiki natehali someta꞉ ipika꞉ wia hala꞉ alesiki kone ma꞉nda꞉ma꞉ yoka꞉ mea pelieke. ");
INSERT INTO ssx_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Koto pa꞉la꞉ ekina꞉ta꞉ do ala꞉ta꞉ ma꞉nda꞉ pia꞉peke na yeke epe na piki e pokaasa꞉ halita꞉ hama mo timba꞉ la꞉papeke ala꞉ pa꞉ta꞉ yolo lopapa꞉peke. Koto pa꞉ta꞉ta꞉ ipika꞉ kake lenkene laaso e̱ tieke lo halieke laa leekeme leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kutu piki onkoluma꞉ pi lo paeyaaso hata꞉ Yesuma꞉ alota꞉ Mo Kenke Wanda꞉halina꞉ Eiyeketa꞉ pa Kini Hali hata꞉ ipika꞉ enisolomanu tonka꞉na꞉ do kenkena꞉ epea꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ ipika꞉ pa̱a̱ tieke piki handeteke hala꞉ biki wiki sea tieke manda pitilieke. ");
INSERT INTO ssx_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Koto pa꞉ta꞉ta꞉ do kenkena꞉ hala꞉ tapake tapake paeyao ipika꞉ leke popelekena꞉ mombelena꞉ lelimikie. Kutaa ipikana꞉ma꞉ta꞉ mo hande ma꞉na꞉ handeteke hala꞉ halima꞉ ipika꞉ sipisipi pita꞉ meme yaapo putupa꞉ alu peao peliaasa꞉ tupa꞉ do kenke wanda꞉hali make mandake tupa꞉ tapake yaapo putupa꞉ alu pilieke. ");
INSERT INTO ssx_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kutaata꞉ mo tikitiki wopu piki wanda꞉halita꞉ ipika꞉ popeke nanema꞉ kalale haena꞉ laata꞉ pa mandane wanda꞉halita꞉ ipika꞉ hoe nanema꞉ kalale mea haena꞉ lelieke. ");
INSERT INTO ssx_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kutu pu paeya꞉ka꞉na꞉ta꞉ mo Kini Halima꞉ ipika꞉ popeke nanema꞉ halimi wanda꞉hali pa꞉ta꞉ alota꞉ Ikita꞉ Koda꞉na꞉ wamo pa꞉la꞉eki mimiki wanda꞉hali yeleme ekina꞉ ika꞉ Apa꞉ Koda꞉ma꞉ do kenke kini pea wepieke toma꞉na꞉ kone tikitiki yao wina꞉ la꞉la꞉ kilu tumbuao hala꞉ kenke a꞉pa mipee lelieke. ");
INSERT INTO ssx_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pa ekipeke I̱ tea꞉ma꞉ homoa꞉ nate nina꞉ta꞉ ikana꞉ma꞉ I̱ epeke tupa꞉ punimime. I̱ma꞉ ikali na꞉na꞉ma꞉ homoa꞉ ekita꞉ ikali kia꞉tiki pimime. I̱ma꞉ da ma꞉nda꞉ hali haowa꞉ ekita꞉ ika꞉ da pa꞉ta꞉manu hatuku pua꞉tiki pimime. ");
INSERT INTO ssx_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","I̱ aka꞉ dia꞉yeketa꞉ ikana꞉ma꞉ yamatiki pimikime. I̱ma꞉ yeni haowa꞉ ekita꞉ ikana꞉ma꞉ epeke tupa꞉ handeteke hatiki pimime. Kutupa mo dipula pitua꞉ ekita꞉ handoloendi pimime. ");
INSERT INTO ssx_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kutupa mo tikitiki piki wanda꞉hali ikana꞉ma꞉ ipika꞉ pi hombo peaasota꞉ dupa lelimikie. Tekehalio. Hando natena꞉ neke tea꞉ma꞉ homeke ne kuma꞉pe o ikali na꞉na꞉ma꞉ homeke ikali kuma꞉pe ");
INSERT INTO ssx_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","o hando natena꞉ neke da ma꞉nda꞉ hali leke nika꞉ da pa꞉ta꞉manu hatuku muma꞉pe o aka꞉manu yamama꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kutaa make mo neke yeni hao o dipula pitu piki handaata꞉ hando natena꞉ handolo epoma꞉pe laa lelimikie. ");
INSERT INTO ssx_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Koto lemeka꞉na꞉ta꞉ mo hande Kini Halima꞉ ika꞉ pita꞉ do tupa꞉ hombo pealieke. I̱ma꞉ iki pa꞉ta꞉ ota꞉ ota꞉ pi alome. Ikana꞉ma꞉ mo hande ya biki na wiki kame homeke ma꞉nda꞉ siki pa꞉ta꞉ pimiki epeke hau paeyaota꞉ kota꞉ ota꞉ paeyao pa I̱ pa꞉ta꞉ kone pimime laa lelieke. ");
INSERT INTO ssx_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kota꞉ mo ipika꞉ hoe nanema꞉ halimi wanda꞉hali iki pa꞉ta꞉ta꞉ dupa lelieke. Ikita꞉ Koda꞉na꞉ hoeyaalo pa꞉la꞉ wanda꞉hali yeleme ekina꞉ I̱ ame̱le̱ na hake mina꞉pa꞉lao pupe laa Ikita꞉ mo Sadani ipika꞉ enisolo tonka꞉na꞉ mina꞉yeke Koda꞉ma꞉ wepia ula꞉ na paelo pa꞉la꞉ ti to hala꞉ ale pa꞉ta꞉ pupe laa lelieke. ");
INSERT INTO ssx_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pa ekipeke I̱ tea꞉ma꞉ homoa꞉ nate nina꞉ta꞉ ikana꞉ma꞉ I̱ na punimime. I̱ma꞉ ikali na꞉na꞉ma꞉ homoa꞉ ekita꞉ ikali na kimime. ");
INSERT INTO ssx_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","I̱ma꞉ da ma꞉nda꞉ hali hao ekita꞉ ika꞉ da pa꞉ta꞉manu na hatuku mimime. I̱ aka꞉ dia꞉yeketa꞉ aka꞉ ma꞉nda꞉ na yamaemekeme. I̱ma꞉ yeni hao make dipula pitu pueketa꞉ I̱ na handeteke haememe laa lelieke. ");
INSERT INTO ssx_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kota꞉ mo tapakema꞉ ipika꞉ pi hombo peaasota꞉ dupa lelimikie. Tekehalio. Hando natena꞉ neke tea꞉ma꞉ homo o ikali na꞉na꞉ma꞉ homo o da ma꞉nda꞉ hali hao o aka꞉ dia꞉ yo o yeni hao o dipula pitu koto haumanu piki handaata꞉ nikana꞉ma꞉ neke na tamba꞉ muma꞉me laa lota꞉ pimika꞉na꞉ ");
INSERT INTO ssx_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","kota꞉ ika꞉ pita꞉ mo Kini Halima꞉ do tupa꞉ hombo pealieke. I̱ma꞉ iki pa꞉ta꞉ ota꞉ ota꞉ pi alome. Ikana꞉ma꞉ do biki na wiki kame homeke ma꞉nda꞉ siki tamba꞉ muluekema꞉ kiaemeketa꞉ kota꞉ I̱ kone tamba꞉ na miki kiaememe laa lelieke. ");
INSERT INTO ssx_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Koto wanda꞉halita꞉ honiki na paeyo hala꞉ hoke yenki mu hala꞉ pa꞉ta꞉ tapaalieke. Pate mo tikitiki wopu piki wanda꞉hali ikita꞉ honiki na paeyo deto hala꞉ pa꞉ta꞉ pelimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Koto waleeke mana꞉ pimanu paeyaaso hata꞉ Yesuma꞉ ipika꞉ disaipolo tonu pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ika꞉ hone wilimi tupa꞉ nate homeke hao ma꞉nda꞉na꞉ta꞉ mo hande Lombei Pupa Yapeeke Nate ipilieke. Koto natena꞉ta꞉ haliwekima꞉ mo Wanda꞉halina꞉ Eiyeketa꞉ a꞉ka꞉tei wape piki tina꞉ endiao lina꞉ halimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Koto pita꞉ kone mo Pa꞉tisi haliweki pita꞉ mo you haliweki paeyaoma꞉ mo yeni peao hayeke you hali Kaiya꞉pasina꞉ da tieke pa꞉ta꞉ a꞉pa momba꞉la pitaa ");
INSERT INTO ssx_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ikana꞉ma꞉ a꞉mbao Yesu da꞉ka꞉pa꞉ mina homena꞉ luluekema꞉ hone amba꞉ pambao wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Koto pea ikana꞉ma꞉ alota꞉ Mo ne pambaaso haena꞉ta꞉ dia꞉me. Wanda꞉halima꞉ niki pa꞉ta꞉ mineke pankaapa꞉na꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesuma꞉ Bedani da puaata꞉ kindi yeni hayeke hali Saimonona꞉ da pa꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ne nalo pitina꞉ wanda꞉ ma꞉nda꞉ma꞉ mo homima꞉ handeke a꞉la꞉ba꞉seta꞉ toopi kanake homeke mea epeekeme. Mo kanake pa꞉ta꞉ta꞉ senisi totopo pikieki seliapo pambeekeme. Koto senisita꞉ yenki tieke alee. Ipikana꞉ma꞉ mo senisita꞉ Yesuna꞉ youna꞉ holaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kutu piekeeki mo hande disaipolo tonuma꞉ handolo hata꞉ ika꞉ ika꞉ kone alota꞉ Ekipeke do yenki tieke aleta꞉ pa hoeyaaso pila꞉pe laa mineke pankemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Koto ekina꞉ ikana꞉ma꞉ alota꞉ Do senisita꞉ wanda꞉halima꞉ hambena꞉ tapaeya꞉ka꞉na꞉ yoluta꞉ kota꞉ mani tieke mea mo natehali wanda꞉hali wopu tamba꞉ mulu puma꞉me laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Koto leme pi Yesuma꞉ amba꞉ handaa iki pa꞉ta꞉ alota꞉ Koto wanda꞉ pa꞉ta꞉ pi na leke mina꞉pa꞉lape. Pa ekipeke ipiki ka꞉nda꞉ma꞉ homaasemepe. Ipikana꞉ma꞉ I̱ pa꞉ta꞉ epeke hau seliapo pia꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Natehali wanda꞉halita꞉ nate paeyao iki ame̱le̱ hao halimikie. I̱ta꞉ iki ame̱le̱ hoto paeyao na hao halueke. ");
INSERT INTO ssx_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hande senisi ya lokena꞉ holaeya꞉ ekita꞉ I̱ hoilu pia꞉ ekina꞉ pota꞉ amba꞉la epeaeya꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kutupa I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Kenke paeyao pa꞉ta꞉ Pi Seliapo wala꞉tiki pimika꞉na꞉ta꞉ kota꞉ do wanda꞉ma꞉ I̱ pa꞉ta꞉ pia꞉ ekita꞉ ipiki pa꞉ta꞉ hone wina꞉yeke wala꞉tiki pilimikie alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Isekatioti hali Diudasima꞉ mo hande 12 disaipolo hayeke halima꞉ kone mo yeni peao hayeke you haliweki pa꞉ta꞉ pua ");
INSERT INTO ssx_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","honke alo alota꞉ Ikana꞉ma꞉ Yesu minuemena꞉yeke pota꞉ walowa꞉ka꞉na꞉ta꞉ I̱ pa꞉ta꞉ aleke kilimikipe laa leekeme. Koto leeke ikana꞉ma꞉ toopi yata꞉pa silipa mani 30 ipiki pa꞉ta꞉ halemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ipikana꞉ma꞉ koto hoki naneta꞉ Yesu a̱i̱ minina꞉yeke lapeke waleke epekemanu ma꞉nda꞉ weiyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mo Na Pombeiyaake Palaowa Ne Pambaeya꞉ pita꞉ titina꞉ natena꞉ Yesuna꞉ hoki nane tolu haemeke haliwekima꞉ ipiki pa꞉ta꞉ alota꞉ Mo Lombei Pupa Yapeeke Nate hone uelena꞉yeke ne pambaluma꞉eki noelena꞉yeke da hando pa꞉ta꞉ pua wamo peamonope lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ipikana꞉ma꞉ ika꞉ pi hombo peaaso hata꞉ alota꞉ Ikana꞉ma꞉ handeleme daoni tukiki pa꞉ta꞉ hala꞉ some ma꞉nda꞉ pa꞉ta꞉ pua dupa lapa꞉peke Hande Wala꞉la꞉ halima꞉ alota꞉ Ya nateta꞉ teke pa꞉ta꞉ opolo a꞉pa꞉la꞉me. Ya disaipolo haliweki nikana꞉ma꞉ naka꞉ da pa꞉ta꞉ mo Lombei Pupa Yapeeke ne pambulumeke lea꞉ma꞉ lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mo disaipolo haliwekima꞉ Yesuma꞉ leeke tupa꞉ mo ne pamba꞉pekeeki tikitiki yao ana꞉lao wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nate pambolo peeke handaata꞉ Yesu make ipika꞉ hoki nane telimiki 12 haliweki make mo ne noluekema꞉ pua momba꞉la pitimikime. ");
INSERT INTO ssx_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Koto ne nalo pita꞉ Yesuma꞉ iki pa꞉ta꞉ do tupa꞉ leekeme. I̱ma꞉ ota꞉ pi alome. Do I̱ ame̱le̱ mandake piluma꞉ some homeke ma꞉nda꞉ ipikana꞉ma꞉ I̱ lina꞉yeke a꞉nda꞉ lombilieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Koto leeke handaa ikana꞉ma꞉ ka꞉nda꞉ma꞉ homolo hata꞉ ma꞉nda꞉ ma꞉nda꞉ma꞉ ipiki pa꞉ta꞉ alota꞉ Tekehalio. Nakana꞉ma꞉ koto le pita꞉ I̱ pa꞉ta꞉ na alo pima꞉e ota꞉ alome laa paeyaoma꞉ lota꞉ puma꞉ puma꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Mo palaowa tenke laasopa꞉ disi pa꞉ta꞉ dika꞉ kiki mandake witolopa꞉ somema꞉ I̱ lina꞉ a꞉nda꞉ lombilieke. ");
INSERT INTO ssx_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Koto pa꞉la꞉pate mo Wanda꞉halina꞉ Eiyeke pa꞉ta꞉ Baibolona꞉ wape pa꞉la꞉ tupa꞉ homilia꞉pate pa Wanda꞉halina꞉ Eiyeke mina꞉yeke a꞉nda꞉ lomba꞉la꞉ halita꞉ ota꞉ a꞉ta꞉ tiekee. Koto halita꞉ na mendia꞉ka꞉na꞉ yoluta꞉ epolo pia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kutupa mo a꞉nda꞉ lombeke hali Diudasima꞉ Yesu pa꞉ta꞉ alota꞉ Wala꞉la꞉ halio. Nakana꞉ma꞉ le pita꞉ I̱ pa꞉ta꞉ lepe leeke Yesuma꞉ hombo peaaso alota꞉ Koto aletaa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ne nalo pitina꞉ Yesuma꞉ Palaowa mea Koda꞉ pa꞉ta꞉ Keiyae laa pindi pindi pea iki pa꞉ta꞉ hale hale pitolo alota꞉ Mea nape. Dota꞉ ya loke mindikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kutupa kapo homeke mea Keiyae laaka꞉na꞉ iki pa꞉ta꞉ hale hale piekeme. Iki paeyaoma꞉ do kapona꞉ napee laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Panake pi la꞉ uluekema꞉ yaka we doe. Wanda꞉halina꞉ hoke hau paeyaena꞉ loluekema꞉ yaka we lopilieke laa ");
INSERT INTO ssx_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","iki pa꞉ta꞉ ota꞉ pi alome. Do naloma꞉ waini ikali I̱ta꞉ paata꞉ na neke hao wetepena꞉ ya Apa꞉na꞉ Kilu Tombuao Hala꞉eki pa꞉ta꞉ iki ame̱le̱ hata꞉ panakeeki nolumeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kutaata꞉ ikana꞉ma꞉ emeli ma꞉nda꞉ laata꞉ mo Olipi Pote pa꞉ta꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kutupa Yesuma꞉ iki pa꞉ta꞉ alota꞉ Ame do timba kone iki paeyaoma꞉ I̱ mina꞉pa꞉lao pindipa pelimikie. Pa ekipeke mo Baibolo bukana꞉ wape pa꞉la꞉ pita꞉ do tupa꞉ la꞉la꞉me. I̱ma꞉ mo sipisipi handeteke hao hala꞉ halita꞉ lulueke. Kutu pua꞉ka꞉na꞉ta꞉ mo sipisipi paeyaota꞉ mandane mandane pindipa pomo keaalimikie laa wape pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kutu pilimipate I̱ paa mea tiaowa꞉ka꞉na꞉ta꞉ I̱ amba꞉la mo Ka꞉lili nane polueke. Ikita꞉ wetepena꞉ a꞉pa꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Koto leeke Pidama꞉ Yesu pa꞉ta꞉ alota꞉ Wanda꞉hali paeyaoma꞉ neke mina꞉pa꞉laena꞉ kone I̱ma꞉ta꞉ neke ota꞉ na mina꞉pa꞉lalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ I̱ma꞉ neke pa꞉ta꞉ ota꞉ pi alome. Ame timba kone koka꞉la꞉ e̱ a̱i̱ na leke haena꞉ nakana꞉ma꞉ hoto tepo yaka biki amba꞉la hoeyaalipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Koto leekepate Pidama꞉ alota꞉ Diki mandakena꞉ homopono lea꞉ka꞉na꞉ kone naka꞉ biki I̱ma꞉ na hoeyaalueke leekeme. Kutupa mo haliweki paeyaoma꞉ make koto tupa꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesuma꞉ ipika꞉ hoki nane tolu haemeke haliweki ame̱le̱ e ma꞉nda꞉ pa꞉ta꞉ opolo pemekeme. Mo ena꞉ bikita꞉ Kesema꞉nie. Koto pa꞉ta꞉ hata꞉ iki pa꞉ta꞉ alota꞉ I̱ta꞉ yeni puluekema꞉ mo pate leke puluma꞉ ikita꞉ do pa꞉ta꞉ hando pita꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Koto laata꞉ ipikana꞉ma꞉ Pida make Sepedina꞉ eiyeke yaapo iki tepo hoeya꞉ nane hatuku peekeme. Kutu polo hata꞉ta꞉ ipika꞉ pukima꞉ tanda tieke minolo hata꞉ ka꞉nda꞉ tiekema꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kutupa ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ I̱ta꞉ yaka pukima꞉ ka꞉nda꞉ma꞉ wopu homolo ekima꞉ homeke nonopea halome. Koto ekina꞉ ikita꞉ do pa꞉ta꞉ I̱ ame̱le̱ mandakena꞉ hata꞉ yu wia handeteke hapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hosiki mo pate leke puaata꞉ kenkena꞉ puki yama peliniaaso dupiki yeni piekeme. Ya Apa꞉o. Nakana꞉ma꞉ pea꞉peke ya꞉ka꞉na꞉ta꞉ kota꞉ do ipula꞉ ka꞉nda꞉ tieke wopu tumbiki kapota꞉ I̱ pa꞉ta꞉ na epena꞉ leke yoka꞉ muelena꞉e laa hone pa꞉la꞉pate ya hone pa꞉la꞉eki dia꞉me. Pa naka꞉ hone pa꞉la꞉eki homekee leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kutupata꞉ Yesuma꞉ paa la꞉ka꞉la ipulu handeekepate mo hali tepoma꞉ u pelimikieki handolo hata꞉ mo Saimono pa꞉ta꞉ alota꞉ Pa ekipeke handaa iki tepoma꞉ do nate leke homeke pa꞉ta꞉ I̱ ame̱le̱ mandakena꞉ yu wia handeteke hapa꞉peke na yea꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Handeteke hata꞉ yeni pu hapa꞉peke. La handa꞉la꞉eki a꞉paama꞉na꞉ loa꞉me. Ika꞉ pukima꞉ hone pa꞉la꞉pate ika꞉ loke mindikima꞉ta꞉ soka꞉la꞉ma꞉ homaa ada꞉ ada꞉ pea witelememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Koto laata꞉ Yesuma꞉ hoto yaapo peao paa pua yeni pitolo hata꞉ alota꞉ Ya Apa꞉o. Do ka꞉nda꞉ma꞉ tumbiki kapo ipula꞉eki a꞉nda꞉ na yoka꞉ mea baeka꞉na꞉ ota꞉ nono lea꞉ka꞉na꞉ta꞉ kota꞉ a꞉pa꞉la꞉ma꞉ naka꞉ hone peleeki pea꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Koto yeni pu paeyeke paa la꞉ka꞉la ipulu hata꞉ mo haliweki handeekepate pa u̱ pelimikieki handeekeme. Kutu piki hauta꞉ ota꞉ ika꞉ leke pa꞉ta꞉ u̱ pambolo hata꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kutupa Yesuma꞉ paa pua hoto tepo peao yeni pua pitolo hata꞉ta꞉ mo hande amba꞉ yeni pitolo leeke pimanu kone leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kutupiki yeni pea paeyeke ipika꞉ disaipolo haliweki pa꞉ta꞉ paa la꞉ka꞉la a꞉pa alota꞉ Ikita꞉ hoto pita꞉ u̱ polu pita꞉ pimipe. A꞉e handepe. A꞉nda꞉ lomba꞉la꞉ halima꞉ Wanda꞉halina꞉ Eiyeketa꞉ mo hoke hau pu haleme haliwekima꞉ minina꞉ ala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pomana꞉ tiaape. Hande I̱ minina꞉ a꞉nda꞉ lomba꞉la꞉ halita꞉ koto ipula꞉ handa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuma꞉ koto pimanu alo haena꞉ kone mo hande 12 haliweki ame̱le̱ hayeke hali Diudasita꞉ ipiki pa꞉ta꞉ epeekeme. Mo yeni peao haemeke you haliweki pita꞉ tondiki haliweki yaapoma꞉ tapaemeke haliweki wopuma꞉ Diudasi ame̱le̱ kepete tieke make dolo tieke make mea miniki epemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mo Yesu minina꞉ a꞉nda꞉ lombeeke halima꞉ mo haliweki pa꞉ta꞉ lomba꞉ witolo alota꞉ I̱ma꞉ pua nunu pulua꞉ someta꞉ kota꞉ koto some mina꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Amba꞉ koto laa wieke tupa꞉ ipikana꞉ma꞉ tikitiki a̱i̱ koto kone Yesu teke pa꞉ta꞉ opolo ipulu alota꞉ Wala꞉la꞉ halio. Neketa꞉ epeke timba nane laata꞉ ipiki hopula꞉ mea nunu piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kutupa Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Someo. Mo naka꞉ puluekema꞉ epele hauta꞉ a̱i̱ koto kone pie leekeme. Koto leeketa꞉ mo Yesu minuluekema꞉ epemeke haliwekima꞉ a꞉pa ipiki da̱o̱la miniki haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kutu pimiki handaata꞉ mo Yesu ame̱le̱ haemeke hali homekema꞉ ipika꞉ a꞉nda꞉ kepete poneke hokulu yola꞉ mea mo yeni peao hayeke you halina꞉ pa hameke e pokao hayeke hali pokeekepate pa ipika꞉ katake homeke tunkula꞉ poka lopaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kutu pieke ekina꞉ Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Mo naka꞉ a꞉nda꞉ kepete hokuluta꞉ pao mea dake pa꞉ta꞉ panka꞉niae. Pa ekipeke. Kepetema꞉ iki tamba꞉ mina꞉e laa wia hao haleme wanda꞉halita꞉ ika꞉ kone mo kepetema꞉ lia homaalieke. ");
INSERT INTO ssx_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ya Apa꞉ma꞉ tamba꞉ mina꞉ wi lolo polo ekita꞉ hone na witelepe. Koto hau a꞉nda꞉ pua꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ I̱ tamba꞉ muluekema꞉ ipika꞉ a꞉nda꞉ peaasa꞉ enisolo ami tapake 12 haka꞉ta꞉pao koto kone tapalo pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wi lolo pua꞉peke ya꞉la꞉pate kutu pua꞉ka꞉na꞉ta꞉ kota꞉ pa mo amba꞉ Baiboloma꞉ pilieke laa la꞉ ula꞉ haumanu ekipa yaaliepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kutaata꞉ Yesuma꞉ mo ipiki minuluekema꞉ epemeke haliweki pa꞉ta꞉ alota꞉ Ika꞉ honema꞉ I̱ta꞉ pi ula꞉eki na opiki nono pea a꞉nda꞉ lita꞉la꞉ hali patema꞉ do kepete tieke dolo make miniki a꞉pa pimipe. Nate wopu I̱ma꞉ta꞉ tembolo da tukiki pa꞉ta꞉ iki ame̱le̱ pi walo haowa꞉pate ikana꞉ma꞉ I̱ na da꞉ka꞉pa꞉ minimime. ");
INSERT INTO ssx_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pate do ikana꞉ma꞉ piteme hau manuta꞉ mo hande amba꞉ potopede haliweki ikana꞉ma꞉ mo Baibolo tukiki pa꞉ta꞉ wape pea ula꞉ pimanu peneme yaaluekema꞉ pitememe leekeme. Koto toma꞉na꞉ta꞉ ipika꞉ disaipolo haliweki paeyaoma꞉ Yesu mina꞉pa꞉lao kilipa pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mo Yesu da꞉ka꞉pa꞉ miniki haemeke haliwekima꞉ hande yeni peao hayeke you hali Kaiya꞉pasina꞉ da nane hatuku pemekeme. Koto pa꞉ta꞉ta꞉ mo hande pi ula꞉eki walolo haemeke haliweki pita꞉ tondiki haliweki peaata꞉ mo da pa꞉ta꞉ amba꞉ mombela pitimikime. ");
INSERT INTO ssx_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pidama꞉ Yesu telimea peekepateta꞉ ipika꞉ teke pa꞉ta꞉ na peketa꞉ pa mo hande yeni peao hayeke you halina꞉ da hankepe nane honda꞉pa꞉ lopa Yesu pa꞉ta꞉ta꞉ eki haumanu pilimipe laa handuluekema꞉ mo hande pota꞉ kake handeteke haemeke haliweki ame̱le̱ pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mo hande yeni peao hayeke you hali make tondiki haliweki paeyaoma꞉ make Yesu lu homaaluekema꞉ ipika꞉ pa꞉la꞉ hau doe laa makeaaso hata꞉ ma̱leke lulu peleme haliweki weimikime. ");
INSERT INTO ssx_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kutu pitolo hata꞉ mandane haliwekima꞉ makeaasa꞉ pimanu wopu a꞉pa lemekepate ipiki lia꞉peke pota꞉ ma꞉nda꞉ na handemekeme. Pate wetepena꞉ yaapo hali ma꞉nda꞉ tiaaso ");
INSERT INTO ssx_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","hata꞉ alota꞉ Do somema꞉ta꞉ I̱ma꞉ Koda꞉na꞉ Tembolo da londa꞉la꞉ mina wiaata꞉ nate tepona꞉ paa a꞉eya꞉peke ya꞉la꞉me lea꞉ somee lepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kutupa mo hande yeni peao hayeke you halima꞉ tiao Yesu pa꞉ta꞉ lota꞉ pitolo hata꞉ alota꞉ Do haliwekima꞉ koto neke laaseme ekina꞉ta꞉ nakana꞉ma꞉ pi ma꞉nda꞉ na lelipikipe laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Koto leekepate Yesuma꞉ pi na honda꞉ mea leke pa hayekeme. Koto ekina꞉ta꞉ mo yeni peao hayeke you halima꞉ ipiki pa꞉ta꞉ alota꞉ Mo deto hala꞉ Koda꞉na꞉ bikina꞉ hali keke pi alo hata꞉ nakana꞉ma꞉ niki pa꞉ta꞉ ota꞉ pi lapeke la alota꞉ Neketa꞉ mo hande Koda꞉na꞉ Eiyeke Ketisope a̱i̱ lakie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesuma꞉ hombo peaaso alota꞉ Koto aletaa leekeme. I̱ma꞉ iki paeyao pa꞉ta꞉ alome. Wetepena꞉ta꞉ mo Wanda꞉halina꞉ Eiyeketa꞉ mo wele pita꞉la꞉ Koda꞉na꞉ popeke nane kikina꞉ pitilia꞉eki make hando ya nane koa tukiki pa꞉ta꞉ hola꞉pa꞉niao ipilia꞉eki make ikana꞉ma꞉ hando pilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Koto pi opitolo hata꞉ta꞉ mo yeni peao hayeke you halima꞉ ipika꞉ dau sinkipolo hata꞉ alota꞉ Koda꞉ laasa꞉ pi ala꞉me. Ekipeke mo la kita꞉la꞉ haliweki ma꞉nda꞉ paa muluma꞉pe. Koda꞉ laasa꞉ pimanu opuma꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Koto ekina꞉ta꞉ eki hau pulumeke hone witelemepe leekeme. Mo haliweki paeyaoma꞉ alota꞉ Ota꞉ hau tieke pu hoeyaala꞉ma꞉ lu homaena꞉ lape lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Koto laata꞉ ikana꞉ma꞉ ipika꞉ leke popeleke pa꞉ta꞉ dopi talo hata꞉ ipiki yombimikime. Mo ipiki yombimiki haliwekima꞉ ");
INSERT INTO ssx_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","alota꞉ Neke Ketiso ya꞉leke handaa do neke lita꞉la꞉ some hombona꞉ bikimanu lae lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pida mo hande da hankepe pa꞉ta꞉ pa pitolo haena꞉ mo yeni peao hayeke you halina꞉ e pokao hayeke wandiki homekema꞉ ipiki pa꞉ta꞉ a꞉pa alota꞉ Neke make koto Ka꞉lili hali Yesu ame̱le̱ pomu haeme hali ya꞉ka꞉ta꞉taa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Koto leeke Pidama꞉ iki paeyaona꞉ leke popelekena꞉ alota꞉ Naka꞉ ale pita꞉ I̱ mata꞉la꞉me. Alekena꞉ alepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Koto laata꞉ ipikana꞉ma꞉ mo pota꞉ kake pa꞉ta꞉ peekepate wandiki ma꞉nda꞉ma꞉ ipiki handaa mo haemeke haliweki pa꞉ta꞉ alota꞉ Do halita꞉ mo hande Na꞉sa꞉tete halina꞉ ta꞉ma꞉ni halie laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pidama꞉ a꞉mbaaso hata꞉ ipika꞉ pima꞉ Ota꞉ dia꞉me la alota꞉ I̱ta꞉ koto some ota꞉ na handolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hosiki hao hoki nanema꞉ mo pa꞉ta꞉ haemeke haliwekima꞉ Pida pa꞉ta꞉ alota꞉ Neketa꞉ ota꞉ ipika꞉ tapake halie. Ota꞉ alome. Mo naka꞉ ale pi makema꞉ kone niki pa꞉ta꞉ peneme yaasa꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Koto lemekepate Pidama꞉ alota꞉ Do alo pita꞉ Koda꞉ma꞉ opitolo haena꞉ alome. Ya pi loa꞉ka꞉na꞉ta꞉ ipikana꞉ma꞉ I̱ hoeyaena꞉e. Koto aleme halita꞉ I̱ ota꞉ na handolome leekeme. Koto pi alo haena꞉ta꞉ koto kone koka꞉la꞉ tiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kutu pieke toma꞉na꞉ta꞉ Pidama꞉ta꞉ Yesuma꞉ amba꞉ ipiki pa꞉ta꞉ la꞉ witolo Koka꞉la꞉ a̱i̱ na tiake haena꞉ nakana꞉ma꞉ hoto tepo ya biki a꞉mbao lo hoeyaalipikie leekeeki Pidama꞉ niminaeyekeme. Koto ekima꞉ta꞉ ipiki hama opolu bao tikene pua hata꞉ ipika꞉ pukima꞉ ka꞉nda꞉ tieke minolo hata꞉ e̱ tieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Da ka꞉la꞉paaso siki hande yeni peao haemeke you haliweki pita꞉ tondiki haliweki ikana꞉ma꞉ Yesu homena꞉ loluekema꞉ pi hoti wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kutaata꞉ mo haliwekima꞉ Yesu mea senima꞉ tonkaota꞉ mo hande Loma꞉ Kapomani You hali tieke Pailedi pa꞉ta꞉ hatuku pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yesuta꞉ lina꞉e laa la꞉ wimiki pita꞉ mo hande a꞉nda꞉ lombeeke hali Diudasima꞉ opitolo hata꞉ta꞉ Ekipeke pua꞉pe laa ka꞉nda꞉ma꞉ homolo hata꞉ hande mieke silipa mani 30 meata꞉ mo hande yeni peao haemeke you haliweki pita꞉ tondiki haliweki ika꞉ haemeke ale pa꞉ta꞉ pua alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","I̱ma꞉ mo hande hoke hau na piki some homena꞉ yeke a꞉nda꞉ lomboa꞉ ekita꞉ hoke hau poloma꞉ leekeme. Koto leeke mo haliwekima꞉ ipika꞉ pi hombo peaaso alota꞉ Kota꞉ koto pele ekita꞉ nika꞉eki dia꞉ ya꞉la꞉pate pa naka꞉eki homekee lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Koto lemekeeki Diudasima꞉ opu haota꞉ hande 30 silipa mani mo tembolo da pukuna꞉ hoelo baota꞉ opolu bao ipika꞉ kone pu naa homeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kutu pieketa꞉ mo yeni peao haemeke you haliwekima꞉ mo mani paa pua meata꞉ Do manita꞉ pa halina꞉ we hake mani ya꞉leke handaa nika꞉ tembolo manina꞉ apa꞉taapeke ekina꞉ta꞉ pi ula꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Koto ekina꞉ta꞉ ika꞉ kakena꞉ homolo hata꞉ koto manima꞉ta꞉ mo hande toopi kawasomanu wepita꞉la꞉ halina꞉ kenketa꞉ mo da ma꞉nda꞉na꞉ wanda꞉hali tokomanu hoiya꞉peke kenke wina꞉ lomana꞉e laa hambemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Koto hau pimiki ekina꞉ kini pu mea a꞉pa ame make koto kenketa꞉ We Kenkee laa biki wiekeeki pa ula꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Koto pimiki hauta꞉ mo amba꞉ hayeke potopede hali Dietemaiyama꞉ la꞉ wieke pimanu peneme yayekeme. Ipikana꞉ma꞉ la꞉ wieke pita꞉ dupa Ikana꞉ma꞉ mo silipa mani 30 mimikime. Koto manita꞉ mo Isulai wanda꞉halima꞉ hali homeke hambolo peleme yenki ana꞉ pa꞉la꞉me laa ana꞉ lao wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Koto manima꞉ta꞉ mo hande toopi kawasomanu wepita꞉la꞉ halina꞉ kenke hambemekeme. Do alo pita꞉ Tekehalima꞉ I̱ pa꞉ta꞉ walea꞉eki alome laa leekeme laa wape pa ula꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pailedima꞉ Yesu lota꞉ pitolo alota꞉ Neketa꞉ mo Diu wanda꞉halina꞉ Kini hali halepe leekeme. Kutupa Yesuma꞉ hombo peaaso alota꞉ Koto aletaa leekepate ");
INSERT INTO ssx_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","pa mo mandane yeni peao haemeke haliweki pita꞉ tondiki haliweki wopuna꞉ lota꞉ pita꞉la꞉ pimanu pa꞉ta꞉ta꞉ ipikana꞉ma꞉ pi siki homeke ma꞉nda꞉ ota꞉ na hombo peayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kutu pieke handaa Pailedima꞉ Yesu paa lota꞉ pitolo alota꞉ Pi ma꞉nda꞉ na lelipikipe. Naka꞉ hau pu haleeki paeyao do koto aleme handa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pate Yesuma꞉ pi ma꞉nda꞉ ota꞉ na leekeme. Koto ekina꞉ Pailedima꞉ penkili piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lombei Pupa Yapeeke Natena꞉ ne pambao haemeke pita꞉ mo Pailedi ipika꞉ pu hayeke tupa꞉ dipula pitieke hali homeke hondo da tapatiki pu hayekeme. Mo wanda꞉halima꞉ ika꞉ hone pieke honke lemeke tupa꞉ mo Loma꞉ Kapomani tumiki halima꞉ koto some tapatiki pu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Koto dina꞉ta꞉ mo biki kende wiki hali homeke ma꞉nda꞉ ipika꞉ bikita꞉ Yesu Batabasi pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Koto ekina꞉ wanda꞉hali paeyao wopuma꞉ momba꞉la haena꞉ Pailedima꞉ iki pa꞉ta꞉ alota꞉ Ika꞉ honema꞉ta꞉ hande Yesu Batabasi tapanope o mo Ketiso aleme hali Yesu tapaanope leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pa ekipeke Pailedi ipika꞉ honema꞉ta꞉ mo Diu tumiki haliwekima꞉ Yesu honditi pitolo hata꞉ ipiki pa꞉ta꞉ mea halemeke ekita꞉ ipika꞉ honema꞉ amba꞉ handa꞉ witolo hata꞉ koto leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailedima꞉ ipika꞉ pi yokaalu pulu pa꞉la꞉ alena꞉ ula꞉ handeteke hala꞉ seana꞉ pa pita꞉ pelia haena꞉ ipika꞉ wetekema꞉ ipiki pa꞉ta꞉ dupiki pi tapaeyekeme. Koto hoke hau ma꞉nda꞉ na piki hali pa꞉ta꞉ta꞉ nakana꞉ma꞉ hau ma꞉nda꞉ na pea꞉peke. Pa ekipeke ame timba upama꞉ handaata꞉ I̱ma꞉ ka꞉nda꞉ tieke mua꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mo yeni peao haemeke you haliweki pita꞉ tondiki haliweki ikana꞉ma꞉ wanda꞉halima꞉ Pailedi pa꞉ta꞉ honke alo hata꞉ Batabasita꞉ tapaaso hata꞉ Yesuta꞉ lina꞉e lena꞉ ika꞉ hone u tiao haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kutu pimikipate Pailedima꞉ mo wanda꞉hali pa꞉ta꞉ alota꞉ Do hali yaapota꞉ iki naneta꞉ hando hali ka꞉la꞉pa꞉ ta꞉pao epena꞉ lonope leekeme. Koto leeke iki paeyaoma꞉ alota꞉ Batabasi tapae lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Koto pi opitolo hata꞉ Pailedima꞉ iki pa꞉ta꞉ alota꞉ Kota꞉ do Ketiso aleme hali Yesu pa꞉ta꞉ta꞉ eki peonope leekeme. Koto leeke iki paeyaoma꞉ alota꞉ A꞉ka꞉tei wape piki tina꞉ tamendiae lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kutupa Pailedima꞉ iki pa꞉ta꞉ alota꞉ Pa ekipeke. Eki hau pa꞉la꞉pe leekepate ikana꞉ma꞉ pi pa daeyao tanda pitolo hata꞉ alota꞉ A꞉ka꞉tei wape piki tina꞉ tamendiae laa wi alo alo haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailedima꞉ ika꞉ hone topo pea꞉peke pota꞉ ma꞉nda꞉ na hande wieke ekima꞉ta꞉ pa a꞉nda꞉ pu lu alualu pia꞉pekeeki teke pa꞉ta꞉ yekeeki handaata꞉ ipikana꞉ma꞉ ikali meata꞉ ika꞉ leke popelekena꞉ ipika꞉ kiki tanda꞉pa bao hata꞉ alota꞉ Do somena꞉ homolo pa꞉la꞉ ekita꞉ I̱ma꞉ na handeteke haloma꞉ ika꞉ pitelememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Iki paeyaoma꞉ ipika꞉ pi hombo peaaso doeki lemekeme. Koto halina꞉ weta꞉ nika꞉ biki manda make nika꞉ wekiwandiki paeyao manda make lopa wina꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Koto laata꞉ kota꞉ Pailedima꞉ Batabasi ka꞉la꞉pa꞉ ta꞉pao pa꞉na꞉ tapa tapaeyekepate Yesuta꞉ yombua baena꞉ laa a꞉ka꞉tei wape piki tina꞉ tamendiao homaena꞉ yeke ipiki iki pa꞉ta꞉ mea haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kutu pieketa꞉ mo dolo a꞉ndeli miniki haliwekima꞉ Yesuta꞉ mo Kapomani tiekena꞉ da tukiki pa꞉ta꞉ panda꞉ tieke ma꞉nda꞉ pa꞉ta꞉ hatuku peeketa꞉ ika꞉ ami tapake mandaneeki paeyaoma꞉ ipiki a꞉pa ambulao haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mo haliwekima꞉ ipika꞉ aka꞉manu holo titipili mea baota꞉ mo we dipiti piki nono piki dau ma꞉nda꞉ meata꞉ Yesuna꞉ lokena꞉ pambaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kutupa mo tekeke hake pumanu mea panka pea you aka꞉ tupa꞉ wepia ipika꞉ youna꞉ pambao hata꞉ mo tumapu homeke make ipika꞉ popeke kiki nane mea minao pimikime. Kutaata꞉ ipika꞉ leke popelekena꞉ ika꞉ tumiki yotuao kitaaso hata꞉ alota꞉ Diu wanda꞉halina꞉ Kini halio. Neke pa hao hapekee laa la꞉tiki pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Koto laa paeyeketa꞉ ipiki dopi to kitao make hande tumapu pa꞉ta꞉la꞉ minolo hata꞉ kone ipika꞉ youna꞉ limikime. ");
INSERT INTO ssx_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Koto kitaasa꞉ haumanu pu paeyaaso hata꞉ ikana꞉ma꞉ mo hande we dipiti piki nono piki dau londa꞉la꞉ meata꞉ ipika꞉ dau pa pambaena꞉ laata꞉ ipiki a꞉ka꞉tei wape piki tina꞉ homena꞉ endialuekema꞉ hatuku mea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pota꞉na꞉ pulu hata꞉ Saitini hali bikita꞉ Saimono manda꞉hande pimikime. Hande dolo a꞉ndeli miniki haemeke haliwekima꞉ mo hali meata꞉ Yesuna꞉ a꞉ka꞉tei wape piki ti mea tiawaena꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kutaata꞉ yu eli biki ma꞉nda꞉ Kolokoda alena꞉ opolo epemekeme. Kolokoda ala꞉ bikina꞉ teketa꞉ Hali youma꞉ handeke elie laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Koto alena꞉ ikana꞉ma꞉ waini ikali teto piki ale ma꞉nda꞉ta꞉ taapuna꞉ apa꞉tao Yesu pa꞉ta꞉ halemekepate ipikana꞉ma꞉ pende naa handaata꞉ kiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kutupa ikana꞉ma꞉ mo a꞉ka꞉tei wape piki tina꞉ Yesu tamendiaota꞉ ipika꞉ daumanu telipaaluekema꞉ daisi telepo laemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Koto telepo laa paeyeketa꞉ ikana꞉ma꞉ pa Yesu handeteke pitimikime. ");
INSERT INTO ssx_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mo a꞉ka꞉tei wape piki ti mandaata꞉ ipika꞉ pi yokaalu pimiki ekina꞉ teke pita꞉ dupa Dota꞉ Yesue. Diu wanda꞉halina꞉ Kini halie laa wape pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kutaata꞉ mo hande pake nepeke hali yaapo make Yesu ame̱le̱ a꞉ka꞉tei wape piki tina꞉ tamendiaemekeme. Ma꞉nda꞉ta꞉ Yesuna꞉ popeke nane kiki nanema꞉ ma꞉nda꞉ta꞉ ipika꞉ hoeya꞉ nane kiki nanema꞉ tamendialu pimikime. ");
INSERT INTO ssx_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pota꞉na꞉ lombei pu pa pa pu yapemeke wanda꞉halima꞉ Yesu ki ta ta pu amboke wankeatiki pitolo hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Aha. Neketa꞉ mo hande tembolo da hoeyao hoto tepona꞉ pa a꞉elo pi halie. Neketa꞉ Koda꞉na꞉ eiyeke ya꞉ka꞉na꞉ta꞉ kota꞉ naka꞉ kone pa꞉ta꞉la꞉pekee. Koto a꞉ka꞉tei wape piki ti mina꞉pa꞉lao naka꞉ kone hola꞉pa꞉niao epoe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Koto mandake tupa꞉ kone mo yeni peao hayeke you haliwekima꞉ make pi ula꞉eki walo haemeke haliwekima꞉ make tondiki haliwekima꞉ make Yesu ki ta ta pitolo hata꞉ ikana꞉ma꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ipikita꞉ mandane wanda꞉halita꞉ mea da꞉tatiki piekepate ipikana꞉ma꞉ta꞉ ipika꞉ kone da꞉taapeke na ya꞉leke pila꞉pe laa alota꞉ Ipikita꞉ mo hande Isulai tapakena꞉ Kini hali dia꞉ yekea. Ipikana꞉ma꞉ mo a꞉ka꞉tei wape piki ti mina꞉pa꞉lao hola꞉pa꞉niao epea꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ ota꞉ Koda꞉na꞉ Eiyekee laa hone tulaalumeke. ");
INSERT INTO ssx_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ipikana꞉ma꞉ Koda꞉ pa꞉ta꞉ hone tulao hata꞉ I̱ta꞉ Koda꞉na꞉ Eiyeke lo haya꞉pate kota꞉ a꞉pa꞉la꞉me Koda꞉ma꞉ ipiki da꞉taaluekema꞉ hone pa꞉la꞉pe pa ame pita꞉la꞉eki hando hamana꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mo hande ipiki ame̱le̱ mandake tamendiaemeke pake nepeke hali yaapoma꞉ make homeke tupa꞉ kone Yesu ki ta ta pipikime. ");
INSERT INTO ssx_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nate you tikekena꞉ haena꞉ mo kenke paeyao timba꞉ la꞉ pambaa puaata꞉ nate leke tepo minolo hata꞉ nate lekelo yopula꞉ dina꞉ta꞉ nateta꞉ paa pa̱a̱ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Koto nate leka꞉na꞉ta꞉ Yesuma꞉ wi aneke hapu alo alota꞉ Ilai Ilai lema sa꞉ba꞉kadani leekeme. Koto pita꞉ do la leekeme Ya Koda꞉o. Ya Koda꞉o. Pa ekipeke nakana꞉ma꞉ I̱ mina꞉pa꞉laasepe laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ipiki teke pa꞉ta꞉ haemeke mandane wanda꞉halima꞉ koto leekeeki opua alota꞉ Opua꞉pee. Elaidia wi ala꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kutupa hali ma꞉nda꞉ma꞉ anke hao pua wa꞉la꞉mbima꞉ handeke ale ma꞉nda꞉ meata꞉ kake liki neke waini ikali tenke lao tumba pitina꞉ laa tumapuna꞉ hapulao Yesuma꞉ dodopo lena꞉ hala꞉liayekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kutu piekepate mandane wanda꞉halima꞉ alota꞉ Hando hapa꞉e. Elaidiama꞉ ipiki a꞉pa pa꞉ta꞉lia꞉pe handomana꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesuma꞉ paa yaapo peao wi anekehapu laata꞉ ipika꞉ temoko tapaaliao homeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ipiki homeeketa꞉ mo hande tembolo da tukiki pa꞉ta꞉ tupele pieke dauta꞉ oli holu nanema꞉ sinkipa꞉alu puniaota꞉ ta꞉ta꞉ ualu piekeme. Kutaa make yu momeni tiekema꞉ mo yu la꞉ma꞉ peayeke la꞉ma꞉ pitolota꞉ toopi tiekemanu make peila꞉ alualu piekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kutu pieketa꞉ mandane hali lapa꞉ nakumanu make lumba꞉ pa pa pu yapeeketa꞉ amba꞉ homemeke mandane Koda꞉na꞉ wanda꞉hali paa da꞉taa tiaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Koto wanda꞉halima꞉ ika꞉ lapa꞉ nakumanu mina꞉pa꞉lao pa haota꞉ Yesu tiaeyeke hoki naneta꞉ iki paeyao mo hande yako piki daoni pa꞉ta꞉ pemekeme. Koto pa꞉ta꞉ta꞉ ikita꞉ wanda꞉hali wopuma꞉ handemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mo hande Yesuma꞉ pita꞉la꞉eki handuluekema꞉ handeteke hayeke ami you hali make ipiki ame̱le̱ haemeke ami haliwekima꞉ make mo hande yumomeni make mo pieke mandane hau tonka꞉na꞉ handaata꞉ ikana꞉ma꞉ paala꞉ tiekema꞉ homolo hata꞉ alota꞉ Ipikita꞉ ota꞉ Koda꞉na꞉ Eiyeke ya꞉ka꞉ta꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kutupa mandane wanda꞉wekima꞉ make hosiki yola꞉ ta꞉pao hata꞉ handeteke haemekeme. Koto wanda꞉wekita꞉ Yesu Ka꞉lili nane hayeke pita꞉ma꞉ta꞉ ipiki teli mea pominolo hata꞉ tamba꞉ mua꞉tiki pomu haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Koto wanda꞉weki ame̱le̱ta꞉ hande Ma꞉kadala wanda꞉ Meti make Dia꞉mesi Diosepe yaapona꞉ inkiki Meti make Sepedina꞉ weteke make haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wele wele alo haena꞉ta꞉ A꞉ta꞉matia hali homeke hamoko hali ipika꞉ bikita꞉ Diosepe opolo epeekeme. Ipikita꞉ Yesuna꞉ disaipolo hayeke some yekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kutupa ipikana꞉ma꞉ Yesuna꞉ toko honke laa muluekema꞉ mo hande Pailedi pitieke pa꞉ta꞉ pua honke leekeme. Kutu pieketa꞉ Pailedima꞉ ipika꞉ ami haliweki pa꞉ta꞉ Yesuna꞉ toko koto some mina꞉ lapee leeke handaa ");
INSERT INTO ssx_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ipikana꞉ma꞉ mo hali toko honda꞉ meata꞉ panake dauma꞉ hopa꞉liao tonkao ");
INSERT INTO ssx_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ipika꞉ panake awa wieke tikene dama꞉ handeke lapa꞉ pa꞉ta꞉ mea pua wiekeme. Koto lapa꞉ data꞉ Diosepema꞉ manda꞉ piki toopi manda tomba꞉la awa wieke ekie. Mo hali toko wina꞉ laata꞉ Diosepema꞉ toopi homeke ma꞉nda꞉ mea pete pete peatiki pua mo toopi ka꞉ka꞉na꞉ a꞉mbaata꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Koto some peeke naneta꞉ wanda꞉ yaapo hande Ma꞉kadala wanda꞉ Meti make Meti ma꞉nda꞉ peaata꞉ mo hande lapa꞉ kake nanema꞉ handa꞉ moneao pitipikime. ");
INSERT INTO ssx_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Koto da ka꞉la꞉peeketa꞉ mo hande Diu wanda꞉halina꞉ hoto pila꞉ natena꞉ta꞉ mo hande yeni peao hayeke you haliweki pita꞉ Pa꞉tisi tapake yaapoma꞉ Pailedi pa꞉ta꞉ pi loluekema꞉ momba꞉lolo hata꞉ ipiki pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Hande ya pi lo haya꞉ somema꞉ pa hande haya꞉ dina꞉ ipikana꞉ma꞉ alota꞉ Hoto tepo natena꞉ wiaata꞉ I̱ta꞉ paa mea tialieke leekeeki niminaasoma꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Koto ekina꞉ta꞉ naka꞉ ami haliwekima꞉ ipika꞉ lapa꞉ta꞉ hoto tepo natena꞉ sembepela handeteke hapa꞉peke laa lae. Do aloma꞉ ekina꞉ teketa꞉ wetepe ipika꞉ disaipolo haliwekima꞉ pua ipika꞉ toko pake mea wanda꞉hali pa꞉ta꞉ alota꞉ Ipikita꞉ da꞉taa tiao pa꞉la꞉me laapa꞉na꞉ yeke aloma꞉me. Do koto tupa꞉ lelimi ya pita꞉ mo hande amba꞉ titina꞉ lea꞉ ya pi ota꞉ lombei pikieki laapa꞉na꞉ aloma꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Koto lemekeeki opuaata꞉ Pailedima꞉ iki pa꞉ta꞉ alota꞉ A꞉pa꞉la꞉me. Sa꞉sa꞉ pita꞉la꞉ tapake ma꞉nda꞉ hatuku puaata꞉ mo hali lapa꞉na꞉ pota꞉ kaketa꞉ epeke tupa꞉ katolapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Koto leeketa꞉ ikana꞉ma꞉ Pailedi mina꞉pa꞉lao mo hali lapa꞉ pa꞉ta꞉ pua mo lapa꞉ kake a꞉mbeeke toopi ka꞉ka꞉na꞉ manuta꞉ domama꞉ a꞉mbo hopa꞉liao paeyeketa꞉ mo hande sa꞉sa꞉ pita꞉la꞉ tapakema꞉ handeteke haena꞉ laa pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mo Diu wanda꞉halina꞉ hoto pitu haemeke nate (Sa꞉ta꞉de) paeyeketa꞉ mo Sande da siki panake ka꞉la꞉ polo haena꞉ hande Ma꞉kadala wanda꞉ Meti make Meti ma꞉nda꞉ yaapoma꞉ mo hande Yesu hoiyeke lapa꞉ toopi apa꞉nda꞉ handuluekema꞉ mo lapa꞉ teke pa꞉ta꞉ opolo pu alu pitolo haena꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","koto kone yu momeni tieke piekeme. Kutu pieke taapuna꞉ta꞉ Tekehali Koda꞉na꞉ enisolo homeke oli hepeni nanema꞉ hola꞉pa꞉niao a꞉pa hata꞉ mo hande apa꞉nda꞉ kake a꞉mbeeke toopi londolo pete pete peaota꞉ mo toopi manda ipiki pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mo enisolo ipika꞉ leke popelekena꞉ta꞉ ti tekele tekele leeke ale peaota꞉ ipika꞉ dau make hake pea yahapima꞉ handeekeme. ");
INSERT INTO ssx_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kutu piekeeki handolo hata꞉ta꞉ mo hande hali lapa꞉ sa꞉sa꞉ pitolo handeteke haemeke haliwekima꞉ paala꞉ tieke pitolo pututu liaaso hata꞉ homeke toko leke wia yapemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kutupa mo hande enisoloma꞉ hande wanda꞉ yaapo pa꞉ta꞉ alota꞉ Ipilikana꞉ma꞉ paala꞉ma꞉ na homa꞉pepee. Mo hande tamendiao lia꞉ hali Yesu handuluekema꞉ ipilipime hone witolome. ");
INSERT INTO ssx_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ipikita꞉ do pa꞉ta꞉ na ula꞉me. Ipika꞉ amba꞉ hande la꞉ wia꞉ tupa꞉ kone tiao pa꞉la꞉me. Ipika꞉ hande toko hoimiki lapa꞉ da panda꞉ doma꞉ a꞉pa handa꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Koto ekina꞉ ame do siki a̱i̱ koto kone pua ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ Yesuta꞉ mo hande naku pa꞉ta꞉ pa da꞉taa tiao ameta꞉ mo Ka꞉lili nane ipiki amba꞉la꞉ pulu hala꞉me. Ikana꞉ma꞉ ipiki koto pa꞉ta꞉ handilimikie lapa꞉peke la alota꞉ Do la kitolo pita꞉ hone na yonka꞉lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Koto pi lo paeyeke opuaata꞉ mo wanda꞉ yaapoma꞉ pututuma꞉ homa꞉peke pateta꞉ ta꞉na꞉ tieke make homa꞉ paleke a̱i̱ koto kone mo lapa꞉ mina꞉pa꞉lao mo disaipolo tonu pa꞉ta꞉ la haluekema꞉ a̱i̱ a̱i̱ya pepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ipilikana꞉ma꞉ mo pimanu loluekema꞉ a̱i̱ya pepekepate pota꞉ hopikina꞉ penkilipao Yesu manda꞉hande pipikime. Ipikana꞉ma꞉ alota꞉ Epeke da ka꞉la꞉paaso leekeme. Ipiliki Yesu tekepa꞉ta꞉ a꞉pa ipika꞉ anke teke pa꞉ta꞉ howa lopolo panda꞉ pitolo hata꞉ ipikina꞉ pi laepekeme. ");
INSERT INTO ssx_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesuma꞉ ipiliki pa꞉ta꞉ alota꞉ Paala꞉ma꞉ na homeke pua mo hande ya kame tonu pa꞉ta꞉ta꞉ Oli Ka꞉lili nane puaata꞉ I̱ta꞉ koto pa꞉ta꞉ handilimikie lea꞉me laa lawapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Koto wanda꞉ yaapo la꞉ka꞉la pulu haena꞉ta꞉ mo hande lapa꞉ handeteke haemeke mandane ami haliwekima꞉ mo hande Diutuseleme daoni nane paa la꞉ka꞉la puaata꞉ hande yeni peao hayeke you haliweki pa꞉ta꞉ mo hande pieke yeke hau paeyao la halemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Koto ekina꞉ mo yeni peao hayeke you haliwekima꞉ koto lemeke pimanu opuaata꞉ ikana꞉ma꞉ mo hande tondiki haliweki ame̱le̱ mombelemekeme. Kota꞉ momba꞉la pi hotu tikitiki yaaso hata꞉ta꞉ mo hande lapa꞉ yu pamba haemeke ami haliweki pa꞉ta꞉ta꞉ mani tieke aneke halolo ");
INSERT INTO ssx_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","alota꞉ Wanda꞉hali paeyaoma꞉ opina꞉ dupa lelimikie. Nikana꞉ma꞉ u poluma꞉ nane ipika꞉ disaipolo haliweki a꞉pa hande toko pake mea pelememe lelimikie. ");
INSERT INTO ssx_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kutupa koto lelimi pi a꞉nda꞉ mo Kapomani tiekema꞉ opia꞉ka꞉na꞉ta꞉ kota꞉ nikana꞉ma꞉ ika꞉ hoke hau na peleme ekita꞉ ipiki pa꞉ta꞉ epeke tupa꞉ pua la halumekema꞉ hone na wia꞉pa꞉peke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hande ami haliwekima꞉ mo mani meata꞉ iki pa꞉ta꞉ lapa꞉peke laa la haleeke tupa꞉ kone pua la꞉tia tia pimikime. Kutu pimiki handaata꞉ koto pita꞉ma꞉ kini pu meata꞉ ame do make mo Diu tapake tukiki pa꞉ta꞉ta꞉ koto pi kone paa la꞉ alualu pu halememe. ");
INSERT INTO ssx_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Hande 11 disaipolo haliwekita꞉ mo Ka꞉lili opolo puaata꞉ Yesuma꞉ Pua꞉pekee laa amba꞉ la꞉ wieke peiyene pa꞉ta꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Koto pa꞉ta꞉ta꞉ Yesu hosiki pa pate leke hayekeeki ikana꞉ma꞉ handaata꞉ ipikina꞉ pi laemekeme. Pate mandane haliwekima꞉ta꞉ hone yaapo wimikime. ");
INSERT INTO ssx_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesuma꞉ teke pa꞉ta꞉ opolo ipulu iki pa꞉ta꞉ alota꞉ Mo hepeni handeteke hapeke wele make do kenke handeteke hapeke wele make Koda꞉ma꞉ I̱ pa꞉ta꞉ ka꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Koto ekina꞉ta꞉ wanda꞉hali paeyao ya disaipolo haena꞉ mea hamena꞉ kenke honiki honiki paeyao pa꞉ta꞉ wala꞉tia pu hapa꞉peke. Koto ya disaipolo halimi wanda꞉halita꞉ Koda꞉na꞉ bikina꞉ make Ya bikina꞉ make mo Holi Sipitidina꞉ bikina꞉ make bapitaisi hau peao hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kutaa make hande I̱ma꞉ iki pa꞉ta꞉ la kua꞉ pimanu paeyaota꞉ mo wanda꞉halima꞉ miniki hata꞉ tolu haena꞉ iki pa꞉ta꞉ wala꞉tiki pu hapa꞉peke. I̱ta꞉ mo paelo pa꞉la꞉ nate epea꞉ka꞉na꞉ kia꞉ naluekema꞉ iki ame̱le̱ nate paeyao mandake hao halumeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Koda꞉na꞉ Eiyeke Yesu Ketiso ipika꞉ pi seliapo doe. ");
INSERT INTO ssx_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Do pita꞉ hande potopede Aisayama꞉ wape pea ula꞉ ekita꞉ dupa. Koda꞉ma꞉ alota꞉ Opua꞉pe. Ya pi mea puaasa꞉ hali amba꞉la tapaalueke. Naka꞉ pota꞉ epeaena꞉yeke tapaalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kutupa ma꞉nda꞉ma꞉ hapu hayeke alena꞉ hata꞉ wi ala꞉me dupa Tekehalina꞉ pota꞉ epeaape. Ipika꞉ pota꞉ tikitiki yao epeaape laa wi ala꞉me laa wape piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Koto wape pieke tupa꞉ bapitaisi peao hayeke hali Dionima꞉ hapu hayeke alena꞉ a꞉pa hayekeme. Kutupa ipikana꞉ma꞉ wanda꞉hali bapitaisi peaaso hata꞉ pi make wala꞉tiki piekeme. Dupa leekeme. Hone la꞉ka꞉la mina wimika꞉na꞉ta꞉ I̱ma꞉ iki bapitaisi peaalueke. Koto ekina꞉ Koda꞉ma꞉ ika꞉ hoke haumanu paeyaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Diudia nane haemeke wanda꞉hali paeyao make Diutuseleme da pa꞉ta꞉ haemeke wanda꞉hali paeyao make Dioni pa꞉ta꞉ pua꞉tiki pu haemekeme. Kutupa Diodani ikali pa꞉ta꞉ wanda꞉halima꞉ ika꞉ hoke haumanu ka꞉la꞉polo haena꞉ Dionima꞉ bapitaisi peatiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Dionima꞉ta꞉ kemolo ma꞉na꞉ itikima꞉ wepieke dau pambaota꞉ ba꞉ta꞉idota꞉ ma꞉na꞉ yonkelekema꞉ wepiekeeki yameekeme. Kutupa ipika꞉ neta꞉ hombuta꞉ make boi hapeke make na꞉tiki pu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ipikana꞉ma꞉ pi walolo hata꞉ dupa leekeme. Ya hoki nane ipilia꞉ halita꞉ I̱ halo tupa꞉ na hala꞉ hali ipilieke. Ipikita꞉ hali tieke ipilieke. I̱ta꞉ ipiki pa꞉la꞉ tupa꞉ epeke hali dia꞉me. I̱ma꞉ panda꞉puniao ipika꞉ anke dake pu ka꞉la꞉papeketa꞉ ana꞉ na pa꞉la꞉me laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","I̱ma꞉ta꞉ ikalima꞉ iki bapitaisi peaasopate ipikana꞉ma꞉ta꞉ Holi Sipitidima꞉ iki bapitaisi peaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Koto dina꞉ta꞉ Yesuma꞉ Ka꞉lili nane hayeke Na꞉sa꞉tete da mina꞉pa꞉lao Diodani ikali pa꞉ta꞉ peekeme. Koto ikali pa꞉ta꞉ Dionima꞉ Yesu bapitaisi peaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kutupa Yesuma꞉ ikali pa꞉ta꞉ mina꞉pa꞉lao opa꞉liaaso hata꞉ koto kone oli ya akolopa꞉pa wiekeeki handaata꞉ oli Holi Sipitidi make melipu tupa꞉ ipiki pa꞉ta꞉ hola꞉pa꞉niaeyekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kutupa pi ho̱la̱꞉makema꞉ ya nane hata꞉ la꞉niaeyeke pita꞉ dupae. Neketa꞉ ya pukipiki wekie. Neke pa꞉ta꞉ I̱ma꞉ ta꞉na꞉ma꞉ wopu homolome laa la꞉niaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Koto kone Holi Sipitidima꞉ hapu hayeke alena꞉ Yesu pena꞉yeke tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kutupa Sadanima꞉ Yesu la handa haena꞉ta꞉ nate hali tieke yaapona꞉ Yesu koto pa꞉ta꞉ hayekeme. Ipikita꞉ ma꞉na꞉ yeti hao hayeke alena꞉ hayekepate mo enisolo tonuma꞉ a꞉pa petelemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Dioni dipula mea pitaeyeke hoki naneta꞉ Yesuma꞉ mo Ka꞉lili nane puaata꞉ Koda꞉na꞉ Pi Seliapo wala꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Dupa leekeme. Ameta꞉ Koda꞉ ipika꞉ natee. Ameta꞉ Koda꞉ ipika꞉ Kilu Tombuao Hala꞉eki teke pa꞉ta꞉ ya꞉la꞉me laa Hone ma꞉nda꞉ la꞉ka꞉la꞉ mina wiaata꞉ do Pi Seliapo hone tulao hapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kutupa Yesuma꞉ mo tunkulu pa ula꞉ Ka꞉lili ikali tea꞉na꞉ yopulu hata꞉ mo Saimono A꞉ndutu hama̱la̱꞉ma꞉ tenkinu tieke kiake ikali pa꞉ta꞉ mea lopaaso haepekeeki handeekeme. Ipilikita꞉ ta꞉peli mu haepeke hali yaapoe. ");
INSERT INTO ssx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesuma꞉ ipiliki pa꞉ta꞉ alota꞉ Yaka hoki nane tolu hapa꞉peke leekeme. Kutu pipika꞉na꞉ta꞉ ipilikita꞉ haliweki mulu pelepe hali yaapo hapena꞉ walueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Koto leekeeki opua ipilika꞉ tenkinumanu mina꞉pa꞉lao koto kone Yesuna꞉ hoki nane teli mea pepekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kutupa Yesuma꞉ hosiki siki mopate leke puaata꞉ Dia꞉mesi Dioni hama̱la̱꞉ Sepedina꞉ eiyeke yaapo ipilika꞉ palai kawasona꞉ pita꞉ tenkinumanu tombulolo haepekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesuma꞉ handaata꞉ koto kone Ipupe laa wi leekeme. Koto leekeeki opuata꞉ mo hama̱la̱꞉ma꞉ ipilika꞉ ateke Sepedi make mo e pokaemeke haliweki make palai kawasona꞉ pitina꞉ mina꞉pa꞉lao Yesuna꞉ hoki nane teli mea pepekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kutupa Kapeneami da nane pemekepate koto da pa꞉ta꞉ hata꞉ Diu wanda꞉halina꞉ Hoto Pila꞉ Natena꞉ ipikana꞉ma꞉ mo pi hotu haemeke da pa꞉ta꞉ honda꞉ pambaata꞉ pi waleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kutupa wanda꞉halima꞉ta꞉ Yesuma꞉ waleeke pi opuaata꞉ leke opo handake wimikime. Wape pea wala꞉tiki pu haemeke haliwekima꞉ walo haemeke tupa꞉ na waleke ipikana꞉ma꞉ biki ula꞉ halima꞉ wala꞉la꞉ tupa꞉ waleeke handa pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Koto kone pi hotu haemeke da pa꞉ta꞉ hali ma꞉nda꞉ a꞉pa hayekepate ipika꞉ weleke pa꞉ta꞉ hoke temoko pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Mo halima꞉ dupa e̱ wi leekeme. Yesuo. Na꞉sa꞉tete halio. Niki pa꞉ta꞉ eki puluekema꞉ a꞉pa pipe laa Neketa꞉ niki hoeyaaluekema꞉ a꞉pa pipe. Neketa꞉ handolome. Neketa꞉ Koda꞉ ipika꞉ yako piki halie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Koto lemekepate Yesuma꞉ sa꞉sa꞉ pea hoke temoko pa꞉ta꞉ alota꞉ Pi na leke. Koto hali mina꞉pa꞉lao opolu bao yopue leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Koto leeke handaa hoke temokoma꞉ hoke e̱ wi la꞉ paleke mo hali mea putuputu liaaso hata꞉ mina꞉pa꞉lao opolu baeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Koto ekina꞉ wanda꞉hali paeyaoma꞉ penkilipa꞉tia pominolo hata꞉ ika꞉ ika꞉ kone lota꞉ lota꞉ pimikieki dupae. Dota꞉ eki haupe laa Panake hau wala꞉la꞉ekipe laa Biki ula꞉ halima꞉ tupa꞉ ipikana꞉ma꞉ mo hoke temokomanu pa꞉ta꞉ pi lea꞉ka꞉na꞉ta꞉ ipika꞉ pi tunkula꞉peke na ya꞉la꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Koto ekina꞉ koto kone Ka꞉lili nane paeyao Yesuna꞉ biki kende tupa꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","30","Yesuta꞉ mo Diu wanda꞉halina꞉ pi hotu haemeke da mina꞉pa꞉lao Dia꞉mesi Dioni ame̱le̱ mo Saimono A꞉ndutu yaapona꞉ da pa꞉ta꞉ pua honda꞉ pambemekepate Saimonona꞉ meiyeke wanda꞉ta꞉ ki yeni hapa wiekeme. Yesuma꞉ mo da opolo peeke mo wanda꞉na꞉ yeni hapa wiekeeki ipiki pa꞉ta꞉ la halemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Koto lemeke handaa Yesuma꞉ pua ipika꞉ kiki mea tiaaso haena꞉ yeni tandeleekeme. Kutupieke handaa mo wanda꞉ma꞉ mo hali manuna꞉ ne yankao haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Koto dina꞉ welealo nate pambolo haena꞉ta꞉ yeni ta꞉ta꞉ ta꞉ta꞉ haemeke wanda꞉hali make weleke pa꞉ta꞉ hoke temoko pitimiki wanda꞉hali make paeyao Yesu pa꞉ta꞉ hatuku a꞉paata꞉ daoni wanda꞉hali paeyao make Yesu hayeke pota꞉ kake pa꞉ta꞉ a꞉pa penke haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yeni ta꞉ta꞉ ta꞉ta꞉ haemeke wanda꞉hali wopuna꞉ yeni Yesuma꞉ tandelaota꞉ hoke temokomanu wotu make tolu liaata꞉ temokomanu ipiki handemeke handaata꞉ Yesuma꞉ Pi na lapa꞉pe laata꞉ tolu liekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Da ka꞉la꞉paaso nate a̱i̱ na opeke haena꞉ Yesuma꞉ tiao pa keneme nane pua hata꞉ Koda꞉ pa꞉ta꞉ yeni piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Koto ekina꞉ Saimono ipiki ame̱le̱ haemeke haliwekima꞉ Yesuna꞉ anke teli mea pua handa꞉ wiaata꞉ ipiki pa꞉ta꞉ alota꞉ Wanda꞉hali paeyaoma꞉ neke weitelememe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Koto lemeke handaa Yesuma꞉ iki pa꞉ta꞉ alota꞉ Mandane da pa꞉ta꞉manu ota꞉ pomana꞉e. I̱ma꞉ koto pa꞉ta꞉ make pi wala꞉peke ya꞉la꞉me laata꞉ Pa ekipekepe. I̱ta꞉ kutu puluekema꞉ a꞉pa poloma꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Koto laata꞉ Yesuma꞉ Ka꞉lili da paeyao pa꞉ta꞉ ika꞉ pi hotu haemeke damanu pa꞉ta꞉ pi walolo hata꞉ hoke temokomanu tolu lutia pomiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kutupa mo kindi yeni hayeke hali homekema꞉ Yesu pa꞉ta꞉ a꞉pa tumiki yotu hao pita꞉ ipiki pa꞉ta꞉ honke alo hata꞉ alota꞉ Nakana꞉ma꞉ hone pika꞉na꞉ta꞉ ya loke wamo pea hano lapeke ya꞉la꞉me laa honke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesuma꞉ ipika꞉ pukima꞉ e̱ leeke handaata꞉ ipika꞉ kiki tindipa moneao wataaso hata꞉ ipiki pa꞉ta꞉ alota꞉ I̱ma꞉ hone pa꞉la꞉me. Naka꞉ loke koto wamo peaaso handa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Koto leeke koto kone kindi yeni wamo peaeyeketa꞉ pa kindi yeni na hake hali leke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kutupa Yesuma꞉ mo hali hando alo hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Hone wopu wia pua꞉peke. Ma꞉nda꞉ pa꞉ta꞉ pi na leke ame do kone mo yeni peao hala꞉ hali pa꞉ta꞉ naka꞉ loke pua wala꞉peke. Kutupa mo hande Mosesima꞉ hala꞉peke laa waleeke aleta꞉ naka꞉ kindi yeni wamo peaowa꞉ ekina꞉ mea hala꞉peke. Kota꞉ koto hauta꞉ mo wanda꞉halima꞉ handena꞉yeke loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Koto laa tapaeyekepate kone mo halima꞉ wanda꞉hali pa꞉ta꞉ la꞉tia pomiekeme. Koto ekina꞉ Yesuta꞉ wanda꞉halima꞉ handolo haena꞉ da pua꞉peke na yeke handaata꞉ keneme nane hata꞉ mandane mandane da wanda꞉hali ipiki pa꞉ta꞉ mombelemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nate mandaneeki hao Yesuma꞉ Kapeneami da pa꞉ta꞉ pa pua haena꞉ wanda꞉halima꞉ Yesuta꞉ da pa꞉ta꞉ pa a꞉pa hala꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kotoeki opua wanda꞉hali wopu pua mombola tumbulu baemeke handaa da pa꞉ta꞉ waleke na wiekeme. Pota꞉ kake pa꞉ta꞉ make waleke na wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kutupa Yesuma꞉ iki pa꞉ta꞉ pi walolo haena꞉ tonkopu haliwekima꞉ Yesu pa꞉ta꞉ kiki anke homa꞉ pa wieke some homeke meatia epemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ipulu hata꞉ handemekepate wanda꞉hali wopu haemeke handaata꞉ Yesu teke pa꞉ta꞉ mea tia pua꞉peke na yaalo hata꞉ da holu akolo puluekema꞉ a꞉meimikime. Kutupa ka꞉ka꞉na꞉ wiaota꞉ mo hande kiki anke homa꞉ pa wieke some tili tonka꞉na꞉ mea lopa꞉niaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kutupieketa꞉ Yesuma꞉ ika꞉ hone tulaemekeeki handaata꞉ mo homa꞉ pa wieke some pa꞉ta꞉ alota꞉ Ya wekio. Naka꞉ hoke hau manuta꞉ pa paeyaasome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Koto leekepate mandane wape pea wala꞉tiki pu haemeke haliwekima꞉ koto da pa꞉ta꞉ pita꞉ ika꞉ honema꞉ kone weimikime. ");
INSERT INTO ssx_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Do halima꞉ do ala꞉ pita꞉ eki epi alo hala꞉pe. Ipika꞉ pima꞉ Koda꞉na꞉ biki lo hoeyaasa꞉me hone wia Koda꞉ma꞉ homeke hoke haumanu pa paeyaapeke ya꞉la꞉me hone wimikime. ");
INSERT INTO ssx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Koto kone Yesu ipika꞉ honema꞉ kone mo haliwekina꞉ hone wimiki ekimanu handa꞉ wiaata꞉ iki pa꞉ta꞉ alota꞉ Ekipeke koto hone witeleme ekimanu weitelemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Eki epi aloeki yapa꞉ pa꞉la꞉pe laa kiki anke homa꞉ pa ula꞉ some pa꞉ta꞉ loa꞉ka꞉na꞉ta꞉ Naka꞉ hoke hau paeyao paeyaalome aloeki yapa꞉ pa꞉la꞉pe o Tiae. Naka꞉ tili meatia pue aloeki yapa꞉ pa꞉la꞉pe leekeme. Hando ekipe laa ");
INSERT INTO ssx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ikana꞉ma꞉ handoemena꞉yeke Wanda꞉halina꞉ Eiyeke I̱ta꞉ hoke haumanu pa paeyaasa꞉ biki ula꞉ hali halome laata꞉ kiki anke homa꞉ pa wieke some pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Neke pa꞉ta꞉ alome. Tiao. Naka꞉ tili meatia da pua꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Koto leeke handaa mo hali tiaeyekeme. Koto kone ipika꞉ tili tamba꞉ mea mina paeyaoma꞉ handolo haena꞉ hama peekeme. Koto ekina꞉ iki paeyaoma꞉ penkilipa꞉ Koda꞉na꞉ biki mea a꞉meiyao alota꞉ Dupita꞉la꞉ ekita꞉ ota꞉ hoto homeke a꞉nda꞉ na handoloma꞉ haue lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesuta꞉ Ka꞉lili nane tunkulu pa ula꞉ ikali tea꞉na꞉ paa la꞉ka꞉la puaata꞉ wanda꞉hali paeyao ipiki pa꞉ta꞉ pua mombelemeke handaata꞉ Yesuma꞉ pi waleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pi wala pulu hata꞉ A꞉lopia꞉sina꞉ eiyeke Lipaeta꞉ mo dakisi mani mu hayeke alena꞉ pitina꞉ Yesuma꞉ handa ipiki pa꞉ta꞉ alota꞉ Yaka hoki nane teli mea a꞉pa꞉peke leeke handaa Lipaema꞉ tiao Yesuna꞉ hoki nane teli mea peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kutupa Yesuma꞉ Lipaena꞉ da pa꞉ta꞉ ne nalo pitina꞉ dakisi mani mu haemeke haliweki wopu make hoke haliweki wopu make Yesu ipika꞉ hoki nane telimiki disaipolo haliweki ame̱le̱ mandake pa꞉ta꞉ pitimikime. Yesuna꞉ hoki nane teli mea epeme ekina꞉ pitimikime. ");
INSERT INTO ssx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kutupa mandane wape pea wala꞉tiki pu haemeke haliwekima꞉ Pa꞉tisi haliweki kone Yesuta꞉ mo dakisi mu haemeke haliweki make hoke haliweki ame̱le̱ ne nalo pitimikieki handolo hata꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ Ekipeke Yesuma꞉ dakisi mani mu haleme haliweki mo hoke haliweki ame̱le̱ ne no pilimipe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesuma꞉ koto lemeke pi opua iki pa꞉ta꞉ alota꞉ Yeni na hasa꞉ wanda꞉halima꞉ dokeda hali pa꞉ta꞉ na polo pelemepate pa yeni hasa꞉ wanda꞉halita꞉ dokeda hali pa꞉ta꞉ pelimikie leekeme. Tiki tiki hau pu hala꞉ wanda꞉halima꞉ hone ma꞉nda꞉ la꞉ka꞉la wina꞉yeke wi loluekema꞉ na epoa꞉me leekeme. Hoke hau pu haleme wanda꞉halima꞉ hone ma꞉nda꞉ la꞉ka꞉la wina꞉yeke wi loluekema꞉ epoa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kutupata꞉ nate ma꞉nda꞉na꞉ Dionina꞉ disaipolo haliweki make Pa꞉tisi haliweki make Koda꞉ pa꞉ta꞉ hone uluekema꞉ ne wahapa꞉ pimikime. Wanda꞉halima꞉ Yesu pa꞉ta꞉ a꞉pa alota꞉ Pa ekipeke mo Dionina꞉ disaipolo haliwekima꞉ make Pa꞉tisi haliwekina꞉ disaipolo haliwekima꞉ make ne wahapa꞉ pia꞉tiki pitelemepate pa naka꞉ disaipolo haliwekima꞉ta꞉ koto hau na pu halemepe laa lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Koto lemeke Yesuma꞉ iki pa꞉ta꞉ alota꞉ Wanda꞉ panake mea kiki ta꞉ma꞉ni pita꞉la꞉ natena꞉ta꞉ wanda꞉ teke halima꞉ wi leeke epemeke wanda꞉hali ame̱le̱ mandake pa꞉ta꞉ hata꞉ wanda꞉halima꞉ ne na neke pa hapeke na yelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kutu pimipate nate ma꞉nda꞉na꞉ ma꞉nda꞉ma꞉ mo wanda꞉ teke hali hatuku pelieke. Koto natena꞉ta꞉ ne wahapa꞉ pea hatiki pilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ma꞉nda꞉ma꞉ amba꞉ dauna꞉ panake dau sinkipiki mea talao na tumbulu hala꞉me leekeme. Kutu pia꞉ka꞉na꞉ta꞉ panake dau sinkipiki talaasa꞉ ekima꞉ amba꞉ dau sinkipa ka꞉ka꞉na꞉ tieke wilieke leekeme. Amba꞉ titina꞉ sinkipi ekita꞉ ota꞉ hoelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Koto tupa꞉ ma꞉nda꞉ma꞉ panake waini ikali amba꞉ ma꞉na꞉ yonkeleke ipi kanake manuna꞉ na holo pambo hala꞉me laa pa holo pambea꞉ka꞉na꞉ta꞉ kota꞉ panake waini ikalima꞉ dako a꞉meiya꞉ka꞉na꞉ta꞉ ma꞉na꞉ yonkeleke kanake yambilieke leekeme. Kutupa waini ikali make ma꞉na꞉ yonkeleke kanakemanu make telipina꞉ hoelieke leekeme. Kotoeki na pulu pa꞉la꞉pate pa mo panake waini ikalita꞉ panake ma꞉na꞉ yonkeleke kanake manuna꞉ holo pambilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesuta꞉ ipika꞉ disaipolo haliweki ame̱le̱ Diu wanda꞉halina꞉ Hoto Pila꞉ Nate homekena꞉ mo konima꞉ handeke ale widi e manuna꞉ pulu hata꞉ widi kilikimanu honda꞉ mepi pu mimikime. ");
INSERT INTO ssx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kutupata꞉ Pa꞉tisi haliwekima꞉ Yesu pa꞉ta꞉ alota꞉ Handa꞉e laa Hoto Pila꞉ Natena꞉ pia꞉peke na ya꞉la꞉eki pitolo pitelememe. Pa ekipeke pitelemepe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Mo hande Deipidima꞉ pieke ekita꞉ hoto homeke a꞉nda꞉ na yata꞉pemepe. ");
INSERT INTO ssx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Deipidi ipiki ame̱le̱ haemeke haliwekita꞉ ka꞉nda꞉ma꞉ homolo hata꞉ tea꞉ma꞉ homemekeme. Koto ekina꞉ Koda꞉ pa꞉ta꞉ hayeke da tukiki pa꞉ta꞉ honda꞉ pambaata꞉ Koda꞉ pa꞉ta꞉ wieke palaowa naaka꞉na꞉ta꞉ yeni peao haemeke haliwekima꞉ homeke napeke yeeke palaowa kone naaka꞉na꞉ta꞉ ipiki ame̱le̱ haemeke haliweki make mea haleekeme leekeme. Abaiya꞉ta꞉ma꞉ mo yeni peao haemeke haliwekina꞉ you hali hayeke pita꞉ pimikime. Kutu pieke ekita꞉ na yata꞉pemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Koda꞉ma꞉ wanda꞉hali epeaena꞉yeke Hoto Pila꞉ Nate wina꞉ la꞉la꞉pate pa wanda꞉halima꞉ Hoto Pila꞉ Natena꞉ biki daeyaena꞉yeke wepia na pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Koto ekina꞉ Wanda꞉halina꞉ Eiyekema꞉ mo Hoto Pila꞉ Natena꞉ Tekehali kone hala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesuta꞉ Diu haliwekina꞉ pi hotu haemeke da tukiki pa꞉ta꞉ paa honda꞉ pambaata꞉ kiki hapueke endiki hali homeke koto da pa꞉ta꞉ hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kutupata꞉ mandane haliwekima꞉ Yesu handa꞉ pelia haemekeme. Pa ekipeke Hoto Pila꞉ Natena꞉ Yesuma꞉ mo halina꞉ kiki epeaaliepe o na epeaaliepe hone wia handa꞉ pelia hata꞉ pi yamba꞉lea꞉me loluekema꞉ handa꞉ pelia haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Koto pimipate Yesuma꞉ kiki hapueke endiki hali pa꞉ta꞉ alota꞉ Do pa꞉ta꞉ epoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Epeeketa꞉ Yesuma꞉ iki pa꞉ta꞉ alota꞉ Hoto Pila꞉ Natena꞉ pi ula꞉ ekina꞉ aleke wape pea ula꞉pe leekeme. Wanda꞉hali epeaasa꞉ ekita꞉ ana꞉ pa꞉la꞉pe o hoeyaasa꞉ ekita꞉ ana꞉ pa꞉la꞉pe laa ombu alota꞉ Wanda꞉hali mea tiaowa꞉ka꞉na꞉ta꞉ ana꞉ pa꞉la꞉pe o homaoa꞉ka꞉na꞉ta꞉ ana꞉ pa꞉la꞉pe leekepate mo haliwekima꞉ pi na leke pa pambo haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kutupa Yesuma꞉ mineke pankolo hata꞉ mo haliweki handolo hata꞉ lekema꞉ lekema꞉ pea handeekeme. Ika꞉ hone taka꞉laeyeke handaa Yesuma꞉ pukima꞉ ka꞉nda꞉ma꞉ homolo hata꞉ mo hali pa꞉ta꞉ alota꞉ Naka꞉ kiki tindipae leekeme. Koto leeke handaa ipika꞉ kiki tindipaeyeke epeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Koto kone mo Pa꞉tisi haliwekima꞉ hama opolu baota꞉ Hetodina꞉ hoki nane telimiki haliweki ame̱le̱ momba꞉la hata꞉ Yesu luekema꞉ tome tome pambemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuma꞉ ipika꞉ disaipolo haliweki ame̱le̱ Ka꞉lili ikali leke pa꞉ta꞉ pemeketa꞉ tapake tieke teliekeme. Ka꞉lili wanda꞉hali Diudia wanda꞉hali ");
INSERT INTO ssx_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Diutuseleme wanda꞉hali make Idumia kenke nane haemeke wanda꞉hali make Diodani ikali nate opa꞉la꞉ nane haemeke wanda꞉hali make Taiya Saidoni yaapo nane haemeke wanda꞉hali make paeyaoma꞉ Yesuma꞉ pieke ekimanu paeyao opimiki handaata꞉ Yesu pa꞉ta꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kutupata꞉ Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ Mo wanda꞉hali wopu ya꞉leke I̱ pendila pendila peaama꞉na꞉ kawaso homeke ma꞉nda꞉ mea a꞉pa endi baape leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pa ekipeke Yesuma꞉ wanda꞉hali wopu epeaeyeke handaata꞉ mo yeni pambemeke wanda꞉hali paeyaoma꞉ Yesu wataaluekema꞉ pasa꞉tei pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kutupata꞉ weleke pa꞉ta꞉ hoke temoko pitieke wanda꞉halima꞉ Yesu handolo hata꞉ ipiki pa꞉ta꞉ panda꞉punialo ende pitolo hata꞉ hoke e̱ wi la꞉ paleke paleke pitolo hata꞉ dupa lemekeme. Neketa꞉ Koda꞉na꞉ Eiyekee lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kutupa Yesuma꞉ mo hoke temokomanu pa꞉ta꞉ hando alo alota꞉ I̱ na peneme yaapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kutupata꞉ Yesuma꞉ pote ma꞉nda꞉ a꞉meiya puaata꞉ ipika꞉ hone pieke haliweki wi la꞉ mepi pieketa꞉ ipiki pa꞉ta꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Yesuma꞉ 12 haliweki ipiki ame̱le̱ hao haena꞉yeke haena꞉ laata꞉ ipikana꞉ma꞉ mo haliwekima꞉ pi walo pua꞉tiki pina꞉yeke ipika꞉ wele pita꞉la꞉eki halolo alota꞉ Hoke temokomanu tolu luemena꞉yeke kitolome leekeme. Yesuma꞉ mo haliweki tapa tapa puluekema꞉ haena꞉ hata꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mo haliwekina꞉ biki manuta꞉ Saimono biki ma꞉nda꞉ Yesuma꞉ leeke bikita꞉ Pida leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Dia꞉mesi Dioni hama̱la̱꞉ta꞉ Sepedina꞉ eiyeke yaapo Yesuma꞉ ipilika꞉ biki ma꞉nda꞉ Boana꞉si leekeme. Do bikita꞉ Tutu lita꞉la꞉ ekina꞉ eiyekee. ");
INSERT INTO ssx_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","A꞉ndutu Pilipi Badolomiu make Ma꞉tiu make Tomasi make A꞉lopia꞉sina꞉ eiyeke Dia꞉mesi make Ta꞉dia꞉si make Saimono Seloti make mo Isekatioti hali Diudasita꞉ Yesu lina꞉ a꞉nda꞉ lomba꞉ polo pieke hali make do haliweki paeyaona꞉ bikimanue. ");
INSERT INTO ssx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kutupa Yesuta꞉ da peekeme. Wanda꞉hali wopu pa mombelemeke handaa Yesuma꞉ ipika꞉ haliweki ame̱le̱ ne napeke nate dia꞉yekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Doeki opuaata꞉ ipika꞉ tapake titima꞉ Yesu handa꞉ muluekema꞉ pemekeme. Pa ekipeke mandane wanda꞉halima꞉ Ipikana꞉ma꞉ hone momata꞉la꞉me lea꞉tiki pimikieki opuaata꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mandane wape pea wala꞉tiki pu haemeke haliwekima꞉ Diutuseleme da nane hao a꞉pa Yesu hayeke alena꞉ pua alota꞉ Bielisibuluma꞉ Yesuna꞉ lokena꞉ talolo pa꞉la꞉me laa Ipikana꞉ma꞉ hoke temoko manuna꞉ you halina꞉ wele pita꞉la꞉ ekima꞉ hoke temokomanu tolu lina꞉ pia꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Koto ekina꞉ Yesuma꞉ mo haliweki ipiki pa꞉ta꞉ epena꞉ laa iki pa꞉ta꞉ onkoluma꞉ laa alota꞉ Sadanima꞉ ipiki kone ekipa teliepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mo kenke homekena꞉ Kapomanima꞉ ika꞉ kone putupa alu alu pea a꞉nda꞉ lia꞉ka꞉na꞉ta꞉ kota꞉ ika꞉ wanda꞉halita꞉ epeke tupa꞉ hapeke na yelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Homeke tapake wanda꞉halima꞉ ika꞉ kone putupa alu alu pea a꞉nda꞉ pimika꞉na꞉ta꞉ kota꞉ koto tapaketa꞉ epeke tupa꞉ hapeke na yelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kutupata꞉ Sadanima꞉ ipiki kone a꞉nda꞉ lia hone yaapo wia꞉ka꞉na꞉ta꞉ epeke tupa꞉ hapeke na yelieke. Ipika꞉ wele pita꞉la꞉eki paelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kutu piliepate ma꞉nda꞉ma꞉ mo honkopu hala꞉ halina꞉ da pa꞉ta꞉ ipika꞉ ala꞉ta꞉ ala꞉ta꞉ pake muluekema꞉ pa ponda꞉pe lia pua꞉peke na ya꞉la꞉me leekeme. Titina꞉ta꞉ mo honkopu hala꞉ hali amba꞉la tonkao ipika꞉ da pa꞉ta꞉ ula꞉ ala꞉ta꞉ ala꞉ta꞉ mea pua꞉peke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","Iki pa꞉ta꞉ ota꞉ pi alome. Kenke wanda꞉halima꞉ hoke hau peleme ekimanu paeyao make ika꞉ Koda꞉na꞉ biki lo hoeyaaseme ekimanu make Koda꞉ma꞉ paeyaapeke ya꞉la꞉pate hali epima꞉ Holi Sipitidina꞉ biki lo hoeyaeka꞉na꞉ta꞉ Koda꞉ma꞉ koto ekita꞉ ota꞉ paeya wahapeke na ya꞉la꞉me leekeme. Koto hoke hauta꞉ hoto paeyao pa u halieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mo haliwekima꞉ Yesu ipika꞉ lokena꞉ hoke temoko talolo pa꞉la꞉me laa lemeke handaata꞉ koto pimanu Yesuma꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kutupa ipika꞉ ama꞉ ipika꞉ hameke titima꞉ a꞉paata꞉ hama꞉ nane hata꞉ Yesu epena꞉ pi la꞉niaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yesuta꞉ wanda꞉hali momba꞉la pitimiki ale tukiki pa꞉ta꞉ pitina꞉ ikana꞉ma꞉ alota꞉ Naka꞉ ama꞉ kame titima꞉ hama꞉ nane hata꞉ neke epoelena꞉ handeteke halememe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","Kutupa Yesuma꞉ alota꞉ Ya ama꞉ ya kametiti epipe laata꞉ mo momba꞉la pitimiki wanda꞉hali handolo hata꞉ alota꞉ Dota꞉ ya ama꞉ ya kametiti do pilimime laa ");
INSERT INTO ssx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Koda꞉na꞉ hone pa꞉la꞉ hau pu haleme wanda꞉hali ikita꞉ ya kame ya ana꞉ ya ama꞉ halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mo hande ikali leke tea꞉na꞉ hata꞉ Yesuma꞉ pi pa waleekeme. Wanda꞉hali wopu a꞉pa ipiki pa꞉ta꞉ mombelemekeme. Koto ekina꞉ wanda꞉hali paeyao ikali tea꞉na꞉ haena꞉ Yesuta꞉ ikali pa꞉ta꞉ wieke palai kawaso homekena꞉ pua pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kutupa ipikana꞉ma꞉ iki pa꞉ta꞉ onkoluma꞉ laa pimanu wotu waleekeme. Pi walolo hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Opua꞉pe. Hali ma꞉nda꞉ma꞉ wae alemanu tandeloluekema꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kutupa tandela꞉tiki pulu haena꞉ mandane wae manuta꞉ pota꞉na꞉ lopa꞉ lopa꞉ pieke ekita꞉ ba titima꞉ a꞉pa talopu nemekeme laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mandane wae manuta꞉ toopimanu manda taleeke kenke sikina꞉ lopeekeme. Koto wae sunu koto kone opeekepate kenke hosiki siki taleekeeki yaalo hata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","nate talo hata꞉ piki lopaapeke na yaalo pou ta hapiekeme ");
INSERT INTO ssx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mandane wae manuta꞉ tekeke hake ale polu pa꞉ta꞉manu lopeekeme. Kutupa mo tekeke hake alemanu opa꞉liaaso hande wae alemanu opolo pieke ekita꞉ tumbuaeyekeme. Kutu pieke ekima꞉ kiliki na a꞉eyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kutu piekepate mandane wae ale manuta꞉ epeke kenkena꞉ lopeekeeki patela opa꞉liaota꞉ napeke wiekeeki manuta꞉ dupae. Mandaneeki 30 tupa꞉ mandaneeki 60 tupa꞉ mandaneeki 100 tupa꞉ wiekeme leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kutupa Yesuma꞉ alota꞉ Katake lomba꞉la꞉ halima꞉ wotu opina꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ipika꞉ honu make haena꞉ wanda꞉hali pemeke naneta꞉ ipiki teke pa꞉ta꞉ haemeke wanda꞉halima꞉ hande 12 haliweki ame̱le̱ make Yesu pa꞉ta꞉ ipika꞉ onkoluma꞉ leeke ekina꞉ lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Ikana꞉ma꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki a꞉mbaala꞉ ekimanu handilimikie. Pate pa hao haleme wanda꞉hali pa꞉ta꞉ta꞉ onkoluma꞉ ala꞉ ekimanu homeke opilimikie. ");
INSERT INTO ssx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Handena꞉yeke onkoluma꞉manu la꞉la꞉pate handa꞉ wina꞉yeke na la꞉la꞉me. Opina꞉yeke onkoluma꞉ pimanu la꞉la꞉pate ota꞉ hone wina꞉yeke na la꞉la꞉me. Opimika꞉na꞉ yoluta꞉ hone ma꞉nda꞉ la꞉ka꞉la꞉ mina wimika꞉na꞉ta꞉ ika꞉ hoke hau paeyaalo pia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kutupa Yesuma꞉ iki pa꞉ta꞉ alota꞉ Do onkoluma꞉ alo ekita꞉ ikana꞉ma꞉ hone na witelemepe. Kota꞉ do alo ekita꞉ hone na wimika꞉na꞉ta꞉ onkoluma꞉ aloeki paeyao ekipa hone wilimikipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Hande wae alemanu tandeleeke halima꞉ Koda꞉na꞉ pi alemanu tandelo hala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mo hande pota꞉na꞉ haleme wanda꞉hali pa꞉ta꞉ pi alemanu lopa꞉ lopa꞉ pu hala꞉me. Kutupa opitolo haena꞉ kone mo tandeleeke pi ale manuta꞉ Sadanima꞉ koto kone a꞉pa yoka꞉ mea pu hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Mandane wanda꞉halita꞉ toopi manda taleeke kenke sikina꞉ lopa꞉niaasa꞉ wae ale manuma꞉ handelememe. Pi opuelemepate koto kone ta꞉na꞉ma꞉ homolo hata꞉ minelemepate wopu na mendiaake hosiki hao kutupa ka꞉nda꞉ma꞉ homa꞉la꞉eki make a꞉nda꞉ lita꞉la꞉eki make koto pi alena꞉ epea꞉ka꞉na꞉ta꞉ koto kone lopo halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mandane wanda꞉halita꞉ mo tekeke hapeleke ale polu pa꞉ta꞉ tandeleeke wae ale manuma꞉ handelememe leekeme. Mo hande pi alemanu opitelemepate ");
INSERT INTO ssx_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kenke hau hone wita꞉la꞉eki manuma꞉ hamoko alemanu pa꞉ta꞉ ta꞉na꞉ homa꞉la꞉eki manuma꞉ mandane alemanu pa꞉ta꞉ we pamba꞉la꞉eki manuma꞉ mo hande pi alemanu da꞉ka꞉pa꞉ miniki pita꞉ka꞉na꞉ta꞉ napeke na u halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kutu pitelemepate mandane wanda꞉halita꞉ epeke kenke seliapona꞉ lopeekeeki manuma꞉ handelememe laa pi alemanu opua meata꞉ kutupa napeke a꞉eyo halememe leekeme. Mandaneeki 30 tupa꞉ mandaneeki 60 tupa꞉ mandaneeki 100 tupa꞉ a꞉eyo halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kutupa Yesuma꞉ iki pa꞉ta꞉ lota꞉ pitolo alota꞉ Ola꞉pake mea epemeka꞉na꞉ta꞉ disi tieke oto pa꞉ta꞉ wilimikipe o bedi tokele pa꞉ta꞉ wilimikipe. Dia꞉me. Manda keo u halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kutupa panka꞉ wilimieki manuta꞉ ma꞉nda꞉ma꞉ walena꞉yeke panka꞉ wilimime. A꞉mbao wilimieki manuta꞉ ma꞉nda꞉ma꞉ ka꞉la꞉pena꞉yeke a꞉mbao wilimime leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Katake lomba꞉la꞉ halima꞉ wotu opina꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kutupa Yesuma꞉ iki pa꞉ta꞉ alota꞉ Mo opiteleme ekimanu hone wopu wia꞉pa꞉peke. Ikana꞉ma꞉ haleme tupa꞉ kone koto ana꞉na꞉ paa milimikie. Kutupa pa haka꞉ta꞉pao mandane ekimanu make milimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ala꞉ta꞉ ala꞉ta꞉ wia hala꞉ halima꞉ mandane ekimanu make haka꞉ta꞉pao milieke leekeme. Ala꞉ta꞉ ala꞉ta꞉ na wia hala꞉ halima꞉ta꞉ ala꞉ta꞉ ma꞉nda꞉ na milieke. Ipika꞉ wia hala꞉eki kone mata꞉lieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kutupa Yesuma꞉ alota꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki dupae. Hali ma꞉nda꞉ma꞉ wae alemanu kenkena꞉ tandeleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kutupa timba꞉ leeke pelia꞉tiki da ka꞉la꞉peeke tiatiki piekeme. Kutupa hande wae alemanu patela opa꞉liaeyekeme. Opa꞉liao pieke ekita꞉ ekipa opa꞉la꞉pe mo halita꞉ mateekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Wae ale manuta꞉ kenkema꞉ peaaseke handaa wae ale opo halememe. Katake titina꞉ amba꞉la꞉ ka꞉la꞉paata꞉ wetepena꞉ honke pankaata꞉ kutupa napeke panka tumba꞉ wilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kutu piliepate napeke naa pia꞉ka꞉na꞉ta꞉ koto kone kepetema꞉ poka꞉mepi pilieke. Mo naa pita꞉la꞉ dina꞉ ya꞉leke handaa milieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kutupa Yesuma꞉ alota꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekita꞉ alekema꞉ handena꞉ loluma꞉pe o eki onkoluma꞉ loluma꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ipikita꞉ masidadi wae ale sikima꞉ handa꞉la꞉me leekeme. Mo wae alesiki ota꞉ hosiki alesiki ya꞉la꞉pate ");
INSERT INTO ssx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kenkena꞉ nokepea꞉ka꞉na꞉ta꞉ opa꞉liaota꞉ beli ponda꞉pa ota꞉ tieke halieke laa kutupa paleke paleke tiekemanu pilia꞉ka꞉na꞉ kotota꞉ ba titima꞉ katake tu̱ pa꞉ta꞉ a꞉pa dake hapeke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kutupiki onkoluma꞉manu Yesuma꞉ iki pa꞉ta꞉ waleeke ekita꞉ opuma homaena꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Onkoluma꞉manu pi waleekepate pi ma꞉nda꞉ na waleke ipika꞉ disaipolo haliweki pa꞉ta꞉ homeke pi tekemanu la haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Koto onkoluma꞉ leeke natena꞉ welealo nane Yesuma꞉ iki pa꞉ta꞉ alota꞉ Nikita꞉ do ikali tunkula mo tea꞉ nane pomana꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kutupa wanda꞉hali mina꞉pa꞉lao Yesuta꞉ mo kawaso pa꞉ta꞉ pitieke tupa꞉ pita꞉ pelia haena꞉ haliwekima꞉ mea pemekeme. Kawaso mandane ekimanu make tonka꞉na꞉ apa꞉tao pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Po tilipu tieke epeekeme. Kutupa ikali ho a꞉meiya mo kawaso litolo hata꞉ ikali pambo tumbiekeme. Koto ekina꞉ mo kawasona꞉ ikalima꞉ amba꞉ tumbuluekema꞉ dodo piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kutu piekepate Yesuta꞉ kawaso mendeke nane pita ka꞉nda꞉ lia peliekeme. Haliwekima꞉ Yesu mea tiao ipiki pa꞉ta꞉ alota꞉ Disao. Niki homoluma꞉ma꞉ hone na witelepe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesuma꞉ tiao mo po tilipu pa꞉ta꞉ make mo ikali pa꞉ta꞉ make pi alo hata꞉ alota꞉ Pae. Tunkulie leekeme. Po tilipu tunkula ikali la꞉ma꞉ la꞉ma꞉ na piki pa wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kutupa ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Alekena꞉ paala꞉ma꞉ homelemepe. Ikita꞉ Koda꞉ pa꞉ta꞉ hone na tulaasemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mo disaipolo haliwekima꞉ penkilipa꞉tia pomua ika꞉ ika꞉ kone pi lemekeeki dupa. Do halita꞉ epi ya꞉ka꞉ta꞉pe. Po tilipuma꞉ make ikalima꞉ make ipika꞉ pi opua tunkulia꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mo hande ikali leke mone tea꞉ nane yopuata꞉ mo Kedasa wanda꞉halina꞉ kenke nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Kutupa koto kone mo kawaso mina꞉pa꞉lao puaata꞉ weleke pa꞉ta꞉ hoke temoko pitieke hali ma꞉nda꞉ manda꞉ hande piekeme. Mo halita꞉ hali holiki u hayeke tikene da pa꞉ta꞉manu hao opolo a꞉pa Yesu manda꞉ hande pipikime. Hande halita꞉ koto tikena꞉ da pa꞉ta꞉manu hao hayekeme. Hali ma꞉nda꞉ma꞉ seni puma꞉ kone ipiki pa tonkaapeke na yeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Amba꞉ta꞉ hoto eleke eleke ipika꞉ kiki anke yaapo seni pu manuma꞉ tonkao haemekepate ipika꞉ kiki tonkao hayeke seni pumanu tunkula꞉tiki piekeme. Kutupa ipika꞉ anke tonkao hayeke seni pumanu tunkulu bepi pia꞉tiki piekeme. Kutupata꞉ hali ma꞉nda꞉ma꞉ honkopu hao homu peaapeke na yeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ipikana꞉ma꞉ tikene da pa꞉ta꞉manu pote pa꞉ta꞉manu make timba natena꞉ hoto paeyao e̱ wi alo hata꞉ ipika꞉ kone toopima꞉ litolo hata꞉ hao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kutupa ipikita꞉ papate hata꞉ Yesu hando haota꞉ a̱i̱ya pua ipiki pa꞉ta꞉ panda꞉ puniaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kutupa pi anekehapu alo hata꞉ alota꞉ Yesuo. Neketa꞉ ota꞉ oli Manda Hala꞉ Koda꞉ Tiekena꞉ Eiyekee leekeme. I̱ pa꞉ta꞉ eki puluekema꞉ a꞉pa pipe laa Koda꞉ma꞉ I̱ handolo haena꞉ neke pa꞉ta꞉ alo I̱ tanda tanda na peaapee leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yesuma꞉ amba꞉ kone ipiki pa꞉ta꞉ Hoke temokoo. Do hali mina꞉pa꞉lao pue leeke handaa mo halima꞉ koto leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kutupa Yesuma꞉ ipiki pa꞉ta꞉ lota꞉ pitolo alota꞉ Naka꞉ bikita꞉ epi ya꞉ka꞉ta꞉pe laa ipikana꞉ma꞉ alota꞉ Yaka bikita꞉ Eleke elekee laata꞉ Nikita꞉ wopu eleke eleke halomeke handa loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kutupa ipikana꞉ma꞉ Yesu pa꞉ta꞉ Mo hoke temokomanu do kenke mina꞉pa꞉lao na pena꞉ laa honke honke wopu leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma꞉na꞉ titi peiyene tea꞉na꞉ ne nalo haena꞉ ");
INSERT INTO ssx_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","mo hoke temoko manuma꞉ Yesu pa꞉ta꞉ honke lemekeeki dupa. Ma꞉na꞉ titina꞉ weleke pa꞉ta꞉ pitulu pomono lae lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Koto ekina꞉ Yesuma꞉ pitulu pena꞉ leekeme. Mo hoke temoko manuma꞉ mo hali mina꞉pa꞉lao ma꞉na꞉ titina꞉ weleke pa꞉ta꞉ pitulu pemekeme. Koto ma꞉na꞉ titita꞉ 2 daoseni tupa꞉ mo peiyene seseme̱le̱na꞉ a̱i̱ya hola꞉pa꞉niao ikali pa꞉ta꞉ puaata꞉ ikali naa honki lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Koto ekina꞉ mo ma꞉na꞉titi handeteke haemeke haliwekima꞉ pindipa puaata꞉ daoni nane haemeke wanda꞉hali topu da pa꞉ta꞉manu haemeke wanda꞉hali make la꞉tiki pomimikita꞉ wanda꞉halima꞉ hande pieke ekimanu handuluekema꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kutupa Yesu pa꞉ta꞉ a꞉paata꞉ amba꞉ hande weleke pa꞉ta꞉ hoke temokomanu pitieke hali koto pa꞉ta꞉ dau yama epeke hone wia pitiekeeki handemeke handaa paala꞉ma꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kutupa amba꞉ hande hoke temokomanu pitieke hali pa꞉ta꞉ pieke ekimanu make mo ma꞉na꞉manu pa꞉ta꞉ pieke ekimanu make handemeke wanda꞉halima꞉ta꞉ la hale hale pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Koto ekina꞉ koto kone Yesu ika꞉ kenke mina꞉pa꞉lao pena꞉yeke Pu pu lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hande kawasona꞉ kone pitulu pulu haena꞉ amba꞉ hoke temokomanu pitieke halima꞉ Yesu pa꞉ta꞉ Hapana꞉e laa pi wopu leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Koto leekepate Yesuma꞉ na epena꞉ laaka꞉na꞉ta꞉ ipiki pa꞉ta꞉ alota꞉ Naka꞉ Tekehalima꞉ neke pa꞉ta꞉ peaasa꞉ ekimanu make neke pa꞉ta꞉ a꞉ta꞉ma꞉ homa꞉la꞉ ekimanu make naka꞉ yankeketiti pa꞉ta꞉ pua lapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mo halima꞉ Daoni kiki yaapo haemeke kenke nane puaata꞉ Yesuma꞉ peaasa꞉ ekimanu waloendi piekeme. Kutupa wanda꞉hali paeyaoma꞉ opuaata꞉ penkilipa꞉tia pomimikime. ");
INSERT INTO ssx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu mo kawasona꞉ pita mone tea꞉na꞉ paa la꞉ka꞉la peeketa꞉ wanda꞉hali wopu ipiki pa꞉ta꞉ a꞉pa mombelemekeme. Ipikita꞉ tunkulu pa ula꞉ ikali tea꞉na꞉ haena꞉ mombelemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pi hotu haemeke da you hali ma꞉nda꞉ Diaitisima꞉ a꞉pa Yesuna꞉ anke teke pa꞉ta꞉ panda꞉puniao honke alo hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ya wandikisiki ota꞉ homuluekema꞉ taapolo pila꞉me leekeme. Tiao haena꞉yeke nakana꞉ma꞉ a꞉pa naka꞉ kikima꞉ ipiki wataapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kutupa Yesu Diaitusi yaapo pepekeme. Wanda꞉hali wopu Yesu ame̱le̱ pulu hata꞉ pendila pendila putia pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Koto pa꞉ta꞉ wanda꞉ ma꞉nda꞉ hayekeme. Mo wanda꞉ta꞉ bapi 12 tukiki pa꞉ta꞉ hata꞉ we yopu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dokeda titima꞉ taapemeke ekima꞉ tanda halo haemekema꞉ ipika꞉ mani paeyao pa batiki piekepate we na tunkuliki pa daeyatiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Wanda꞉halima꞉ Yesu pa꞉ta꞉ lemeke pi mo wanda꞉ma꞉ opuaata꞉ wanda꞉hali anka꞉lopuna꞉ pua Yesuna꞉ hoki nane puaata꞉ ipika꞉ dau wataeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ipika꞉ honema꞉ta꞉ mo ipika꞉ dau wataoka꞉na꞉ta꞉ I̱ epeaalieke hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kutupa koto kone we yopu hayekeeki tunkula ipika꞉ honema꞉ hone witolo hata꞉ta꞉ hande yeni paeya꞉me. Ameta꞉ tiaasome hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesuma꞉ ipika꞉ honema꞉ kone hone witolo hata꞉ ya wele pita꞉la꞉eki mandane ekita꞉ pea꞉ka꞉ta꞉me hone wiekeme. Kutupa koto kone mo wanda꞉hali pa꞉ta꞉ la꞉ka꞉la hata꞉ alota꞉ Epina꞉ kikima꞉ ya dau wataeya꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ipika꞉ disaipolo haliwekima꞉ ipiki pa꞉ta꞉ alota꞉ Handa꞉taa. Do wanda꞉hali wopuma꞉ pendila pendila piteleme ekita꞉ do handolo hata꞉ kone nakana꞉ma꞉ alota꞉ I̱ta꞉ epima꞉ wataeya꞉pe aleme lemekepate ");
INSERT INTO ssx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesuma꞉ ipiki wataeyeke wanda꞉ o hali handuluekema꞉ hando hopa꞉liaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mo wanda꞉ma꞉ ipiki epeaeyekeeki hone witolo hata꞉ paala꞉ma꞉ homolo hata꞉ putu putu lutiki a꞉pa Yesuna꞉ anke pa꞉ta꞉ panda꞉puniaeyekeme. Kutupa Yesu pa꞉ta꞉ ota꞉ ekimanu pi peneme yao laata꞉ hande alemanu la haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Ya wandikio. I̱ pa꞉ta꞉ hone tulaase ekima꞉ tiaaseme. Puki lopaniao pua꞉peke. Naka꞉ yeni paeya꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuma꞉ pi pa alo haena꞉ mandane haliwekima꞉ hande pi hotu haemeke da you halina꞉ da nane hao a꞉pa alota꞉ Naka꞉ wandikita꞉ ota꞉ homea꞉me laa Ekipeke mo Disa honke loloendi pitelepe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Koto lemekepate Yesuma꞉ na opiki mo hali pa꞉ta꞉ alota꞉ Paala꞉ma꞉ na homa꞉peke. I̱ pa꞉ta꞉ pa hone tulaapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesuma꞉ Pida pita꞉ Dia꞉mesi Dioni hama̱la̱꞉ make koto haliweki homeke ipiki telina꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pi hotu haemeke da you halina꞉ da pa꞉ta꞉ opolo pemekepate Yesuma꞉ wanda꞉hali wopuma꞉ e̱ la alu alu pitolo haemekeeki opiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kutupa honda꞉ pambaata꞉ wanda꞉hali pa꞉ta꞉ alota꞉ Ekipeke e̱ la alu alu pitelemepe. Mo wandikita꞉ na homa꞉la꞉pate u̱ pela꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wanda꞉halima꞉ ipiki pa꞉ta꞉ ki taemekeme. Kutu pimikipate Yesuma꞉ mo wanda꞉hali paeyao hama tolu liekeme. Wandikina꞉ inkiki ateke yaapo ipiki ame̱le̱ haemeke haliweki make wandiki wieke alena꞉ hatuku peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kutupa ipikana꞉ma꞉ mo wandikina꞉ kiki minaaka꞉na꞉ alota꞉ Talida kumi o Wandikio. Neke pa꞉ta꞉ tiae alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kuta kone mo wandiki tiao pota꞉ pomiekeme. Ipika꞉ bapita꞉ 12 paeyeke handaa loa꞉me. Koto piekeeki handaata꞉ wanda꞉halima꞉ penkilipa꞉tia pomua pomoma꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesuma꞉ iki pa꞉ta꞉ hando alo hata꞉ alota꞉ Ma꞉nda꞉ pa꞉ta꞉ na lapa꞉peke leekeme. Kutupa wandiki pa꞉ta꞉ ne mea hala꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesuma꞉ koto pa꞉ta꞉ mina꞉pa꞉lao ipika꞉ disaipolo haliweki ame̱le̱ da nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kutupa mo Hoto Pila꞉ Natena꞉ Diu haliwekina꞉ pi hotu haemeke da tukiki pa꞉ta꞉ honda꞉ pamba puaata꞉ pi waleekeme. Mo yeni pu haemeke da pa꞉ta꞉ pitimiki wanda꞉hali wopuma꞉ opua penkilipa꞉tia pominolo hata꞉ alota꞉ Do wala꞉la꞉eki paeyaota꞉ ipikana꞉ma꞉ hando pa꞉ta꞉ opua pa꞉la꞉pe. Do halima꞉ ipikana꞉ma꞉ epeke honemanu ekipa handa꞉ wia mea pa꞉la꞉pe laa ipikana꞉ma꞉ wele pita꞉la꞉ ekimanu do aleke welema꞉ pita꞉la꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Do halita꞉ kapenda hali dia꞉ya꞉ka꞉ta꞉pe laa Metina꞉ eiyeke dia꞉ya꞉ka꞉ta꞉pe. Dia꞉mesi Diosepe Diudasi make Saimono make ipika꞉ hameke titi dia꞉ya꞉ka꞉ta꞉pe laa Ipika꞉ beliki titi do pa꞉ta꞉ niki ame̱le̱ na halemepe lemekeme. Kutupa ipiki pa꞉ta꞉ honditi pitolo hata꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Koto lemeke ekina꞉ Yesuma꞉ iki pa꞉ta꞉ alota꞉ potopede halita꞉ da ma꞉nda꞉ wanda꞉hali paeyaoma꞉ta꞉ ipika꞉ pi opu halemepate ipika꞉ da haleme wanda꞉halima꞉ make ipika꞉ tapake manuma꞉ make ikana꞉ma꞉ta꞉ ipika꞉ pi na opilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kutupa Yesuma꞉ ipika꞉ da pa꞉ta꞉ hata꞉ wele pita꞉la꞉ ekimanu pia꞉peke na yeekepate pa yeni hayeke wanda꞉halimanu ipika꞉ kikima꞉ minaa ika꞉ yeni tandelaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ika꞉ hone na tulaemeke ekina꞉ Yesuma꞉ penkilipa꞉tia pominolo hata꞉ ikita꞉ ekipeke pi na opitolo pitelemepe hone wiekeme. Kutupa mo da ma꞉nda꞉ pa꞉ta꞉manu pominolo hata꞉ pi wala꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kutupa Yesuma꞉ mo hande 12 haliweki ipiki pa꞉ta꞉ epena꞉yeke wi la꞉ mea yaapo la la pu tapa tapa piekeme. Ikana꞉ma꞉ mo hoke temokomanu tolu lina꞉yeke ipika꞉ wele pita꞉la꞉eki haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kutupa mana꞉ alo hata꞉ alota꞉ Tumapu homeke mea minaa ala꞉ta꞉ ma꞉nda꞉ na mea miniki pua꞉pa꞉peke laata꞉ tia nu make mani make na mea pua꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Anke dake pambaota꞉ sedi yaapo atulao na pambaake pua꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pi ma꞉nda꞉ make alota꞉ Da ma꞉nda꞉ hala꞉ alena꞉ pemeka꞉na꞉ta꞉ hali ma꞉nda꞉na꞉ da pa꞉ta꞉ pelia haluekema꞉ honda꞉ pambemeka꞉na꞉ta꞉ kota꞉ koto da pa꞉ta꞉ homeke hao hapa꞉peke. Kutupa mo damanu mina꞉pa꞉lao da ma꞉nda꞉ hala꞉ alena꞉ pemeka꞉na꞉ta꞉ titina꞉ honda꞉ pamba pua haeme data꞉ mina꞉pa꞉lao pua꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Da ma꞉nda꞉ nane pemeka꞉na꞉ta꞉ iki na handa꞉ mimika꞉na꞉ta꞉ ika꞉ pi na opimiki kiaemeka꞉na꞉ta꞉ kota꞉ koto da pa꞉ta꞉ na hake pemeka꞉na꞉ta꞉ ika꞉ ankena꞉ tala꞉la꞉ dokolo tandelapa꞉peke. Mo wanda꞉halima꞉ kiaemekeeki tombo waluekema꞉ tandelapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kutupa mo disaipolo haliwekima꞉ puaata꞉ wanda꞉hali pa꞉ta꞉ pi walolo hata꞉ alota꞉ Hone ma꞉nda꞉ la꞉ka꞉la wia꞉pa꞉peke laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","hoke temokomanu wopu tolu liaata꞉ yeni haemeke wanda꞉hali wopuna꞉ youna꞉ honkuma꞉ handeke ale lekeeki holaota꞉ tandelena꞉ peaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Wanda꞉halima꞉ Yesuna꞉ biki kende tupa꞉ wina꞉ lemeke handaa Kini Hetodima꞉ Yesuma꞉ tapaeyeke haliwekima꞉ pieke ekimanu opiekeme. Mandane wanda꞉halima꞉ alota꞉ Bapitaisi peao hayeke hali Dionita꞉ homa kone paa tiao pia꞉ka꞉ta꞉me laa koto pa꞉la꞉ ekima꞉ do wele pita꞉la꞉ ekimanu pitolo pia꞉ka꞉ta꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Koto lemekepate mandane wanda꞉halima꞉ alota꞉ Ipikita꞉ Elaidia ya꞉ka꞉ta꞉me lemekepate mandane wanda꞉halima꞉ alota꞉ Ipikita꞉ potopede hali ma꞉nda꞉ ya꞉ka꞉ta꞉me laa amba꞉ kone hayeke hali tupa꞉ ya꞉ka꞉ta꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hetodima꞉ koto pimanu opua alota꞉ Ipikita꞉ Dionie. I̱ma꞉ you tunkulua꞉ hali tiao pia꞉ka꞉ta꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Amba꞉ta꞉ Hetodima꞉ Dioni yola꞉ mea epena꞉yeke haliweki tapaota꞉ Dionita꞉ tonkao dipula mea lopaeyekeme. Hetodiasima꞉ honke leeke handaa piekeme. Hetodiasita꞉ Hetodina꞉ hameke Pilipina꞉ wanda꞉ hayekepate Hetodima꞉ petolo miekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Dionima꞉ Hetodi pa꞉ta꞉ pi amba꞉ leekeeki dupa. Naka꞉ kamena꞉ wanda꞉ petolo mele ekita꞉ ana꞉ na pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Koto leeke handaata꞉ Hetodiasima꞉ Dioni pa꞉ta꞉ mineke pankolo hata꞉ luekema꞉ ho̱linda꞉lu hayekepate lia꞉peke na yekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hetodima꞉ta꞉ Dionina꞉ tiki tiki hau pu hayekeeki make yako piki hali make handeeke handaata꞉ ipiki pa꞉ta꞉ paala꞉ma꞉ homolo hata꞉ panka mea hao hayekeme. Dionima꞉ wala꞉tiki pieke pimanu Hetodima꞉ opua weiya꞉tiki piekepate ta꞉na꞉ma꞉ homa opua꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hetodima꞉ ipika꞉ mendieke nate epeeke handaata꞉ ne pambuluekema꞉ ipika꞉ kapomani tumiki haliweki make ipika꞉ a꞉nda꞉ tumiki haliweki make Ka꞉lili nane haemeke hali tieke tieke make wi la꞉ mepi pieke a꞉pa mombelemekeme. Koto dina꞉ta꞉ Hetodiasima꞉ Yaka natee hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hetodiasina꞉ wanekema꞉ a꞉paata꞉ keliapo pambolo hata꞉ Hetodi make epemeke haliweki make ta꞉na꞉ma꞉ homaeyeke handaa kini halima꞉ mo wandiki pa꞉ta꞉ alota꞉ Naka꞉ hone pa꞉la꞉ ale I̱ pa꞉ta꞉ honke leka꞉na꞉ta꞉ ota꞉ kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mo wandiki pa꞉ta꞉ la꞉ witolo hata꞉ alota꞉ Naka꞉ hone pa꞉la꞉ ale I̱ pa꞉ta꞉ honke leka꞉na꞉ta꞉ ota꞉ kulueke. Ya kilu tombuao hala꞉eki kone putupa ota꞉ kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Koto leeke handaa mo wandikima꞉ puaata꞉ ipika꞉ ama꞉ pa꞉ta꞉ lota꞉ pea alota꞉ Aleke honke lonope leekeme. Mo wanda꞉ma꞉ alota꞉ Bapitaisi peao haya꞉ hali Dioni ipika꞉ you honke lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kutupa mo wandikima꞉ koto kone kini hali pa꞉ta꞉ a̱i̱ a꞉pa honke alo hata꞉ alota꞉ Yaka hone pa꞉la꞉ aleta꞉ mo bapitaisi peao haya꞉ hali Dionina꞉ youta꞉ metekina꞉ wia ame do kone kuelena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mo kini halima꞉ ipika꞉ pukima꞉ tanda wotu homeekepate mo la꞉ wieke pimanu leeke handaa make mo epemeke haliweki haemeke handaa make ipika꞉ pi tunkula꞉peke na yeeke handaata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","kota꞉ koto kone ipikana꞉ma꞉ ipika꞉ a꞉ndeli miniki hali homekema꞉ Dionina꞉ you tunkulu mea epena꞉yeke tapaeyekeme. Kutupa mo halima꞉ puaata꞉ dipula da pa꞉ta꞉ Dionina꞉ you tunkula ");
INSERT INTO ssx_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","metekina꞉ wia mea a꞉paata꞉ mo wandiki pa꞉ta꞉ haleekeme. Mo wandikima꞉ meata꞉ ipika꞉ inkiki pa꞉ta꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dionina꞉ disaipolo haliweki manuma꞉ opuaata꞉ ipika꞉ toko mulu puaata꞉ toopi ka꞉ka꞉na꞉ pa꞉ta꞉ pua tu wimikime. ");
INSERT INTO ssx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hande tapaeyeke haliwekima꞉ Yesu pa꞉ta꞉ paa a꞉paata꞉ ika꞉ pi walemeke ekimanu make ika꞉ pimiki ekimanu paeyao make Yesu pa꞉ta꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wanda꞉hali wopu pa a꞉pa꞉tiki pua꞉tiki pimiki handaa Yesu ipika꞉ disaipolo haliweki ame̱le̱ ne napeke nate dia꞉ yeekeme. Koto ekina꞉ Yesuma꞉ iki pa꞉ta꞉ alota꞉ Iki homeke pomana꞉ ipupe. Mo Keneme nane hoto siki pitulu pomana꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kutupa amba꞉ hande kawasona꞉ pita keneme nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Keneme nane pemekepate wanda꞉hali wopuma꞉ ika꞉ pemekeeki handolo hata꞉ dota꞉ handa꞉ haliweki ya꞉ka꞉ta꞉me hone wimikime. Ikana꞉ma꞉ daoni paeyao mina꞉pa꞉lao anke hao paka꞉lao puaata꞉ Yesu ameda a̱i̱ na opolo yapemeke haena꞉ iki amba꞉la opolo yapemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesuma꞉ mo kawaso mina꞉pa꞉lao kenke nane opolo pulu hata꞉ wanda꞉hali wopu handaata꞉ ikita꞉ mo handeteke hala꞉ hali dia꞉ ya꞉la꞉ sipisipi ma꞉na꞉manu tupa꞉ handaata꞉ ipika꞉ pukima꞉ e̱ alo hata꞉ iki pa꞉ta꞉ a꞉ta꞉ma꞉ homeekeme. Kutupa pimanu wopu waleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kutupa nate paeta꞉leke handaa ipika꞉ disaipolo haliwekima꞉ ipiki pa꞉ta꞉ a꞉pa alota꞉ Do aneta꞉ keneme nanee. Ameta꞉ nate paeta꞉la꞉me laa ");
INSERT INTO ssx_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","topu da aneke da pa꞉ta꞉manu make wanda꞉halima꞉ ne hamba꞉tiki pena꞉ tapa tapa pie lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Koto lemekepate Yesuma꞉ iki pa꞉ta꞉ alota꞉ Ikana꞉ma꞉ nemanu mandaneeki mea hala꞉pa꞉peke leekeme. Ikana꞉ma꞉ ipiki pa꞉ta꞉ alota꞉ Nikana꞉ma꞉ 200 kina mea pua palaowa hambaata꞉ iki nena꞉yeke halomono alepe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kutupa ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Mo palaowa kitiki siki ekipu halemepe handolo pupe leekeme. Kutupa ikana꞉ma꞉ handaa paa a꞉pa alota꞉ Yunki hata꞉ ula꞉me kutupa ta꞉pelita꞉ yaapo ula꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Koto lemeketa꞉ Yesuma꞉ iki pa꞉ta꞉ pi alo hata꞉ alota꞉ Mo noma꞉ seliapona꞉ momba꞉la pituma꞉ pituma꞉ pea pita꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Koto ekina꞉ mo hande momba꞉la pituma꞉ pituma꞉ pemeke wanda꞉halita꞉ mandaneeki 100 tupa꞉ mandaneeki 50 tupa꞉ pituma꞉ pituma꞉ pea pitimikime. ");
INSERT INTO ssx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kutupa Yesuma꞉ hande palaowa kitiki siki yunki hata꞉ make hande ta꞉peli yaapo make minaata꞉ ya nane handa꞉liao Koda꞉ pa꞉ta꞉ keiyae laata꞉ palaowa kitiki sunu pindi pindi pea ipika꞉ disaipolo haliwekima꞉ mea wanda꞉hali mina꞉yeke hale hale piekeme. Ipikana꞉ma꞉ ta꞉peli yaapo make pindi pindi pea disaipolo haliwekima꞉ hale hale pina꞉ haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Paeyaoma꞉ naaka꞉na꞉ta꞉ Weleke tala꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mo wanda꞉hali pa꞉ta꞉ pa wieke palaowa ta꞉peli putu piliki pa wieke ekimanu meata꞉ nu 12 tumbaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kutupa hande palaowa kitiki sunu nemeke haliwekita꞉ 5 daoseni haliwekie. ");
INSERT INTO ssx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Koto kone Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ Kawasona꞉ pita mone tea꞉na꞉ hala꞉ da Betesaida da pa꞉ta꞉ iki amba꞉la opolo pua꞉pa꞉peke laata꞉ mo hande wanda꞉hali wopu tapa tapa piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kutupa Yesuma꞉ mo disaipolo haliweki mina꞉pa꞉laota꞉ pote pa꞉ta꞉ yeni pulu peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Timba꞉leke hauta꞉ kawaso ikali tukikina꞉ pulu haena꞉ ipika꞉ honu makesiki kenkena꞉ hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesuma꞉ handaata꞉ ipika꞉ disaipolo haliwekima꞉ deli awolo hata꞉ po tieke wenoko nane epeeke handaa weleke we pimikieki handeekeme. Koto ekina꞉ da ka꞉la꞉puluekema꞉ okona꞉ Yesuta꞉ mo haliweki haemeke alena꞉ poluekema꞉ ikali manda ankena꞉ peekeme. Lombei pu pa poluekema꞉ hone wiekepate ");
INSERT INTO ssx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","mo haliwekima꞉ ipiki ikali manda ankena꞉ peekeeki handaata꞉ temokopate ipula꞉me hone witolo hata꞉ e̱ wi lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Paeyaoma꞉ ipiki handolo hata꞉ paala꞉ma꞉ wotu homemekeme. Kutu pimikipate koto kone Yesuma꞉ iki pa꞉ta꞉ pi alo hata꞉ alota꞉ Honkopu hape. Dota꞉ I̱e. Paala꞉ma꞉ na homa꞉pepee leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kutupa Yesuta꞉ mo kawasona꞉ iki ame̱le̱ pitulu peeke haena꞉ta꞉ po tieke tunkuliekeme. Kutu pieketa꞉ mo haliwekima꞉ penkilipa꞉tia pomimikime. ");
INSERT INTO ssx_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pa ekipeke ikana꞉ma꞉ta꞉ mo hande 5 daoseni wanda꞉hali pa꞉ta꞉ palaowa kitiki sunu telipieke ekina꞉ teketa꞉ hone lenkipa na wimiki ekiyalo hone na wimikime. ");
INSERT INTO ssx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mo kawasona꞉ ikali tunkula puaata꞉ Kenesatete nane opolo puaata꞉ mo kawaso a꞉ndimikime. ");
INSERT INTO ssx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kawaso mina꞉pa꞉laemeketa꞉ kutaa kone wanda꞉halima꞉ ipika꞉ leke popeleke handolo hata꞉ hone wimikime. ");
INSERT INTO ssx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Koto ekina꞉ koto da nina꞉ a̱i̱ya pua mo yeni hapa wieke wanda꞉hali tilina꞉ mu wiaata꞉ Yesu hayeke pa꞉ta꞉ mea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu peeke alena꞉ paeyao pa꞉ta꞉ da nane make daonimanu make topu topu da nina꞉ make opolo peeke dina꞉ da nane yeni hapa wimiki wanda꞉hali mea tia pua makedi yalao tu uma꞉ uma꞉ pimikime. Kutupa mo wanda꞉halima꞉ Yesuna꞉ dau honiki wataaluekema꞉ honke lemekeme. Wataemeke wanda꞉halina꞉ yeni tandelemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pa꞉tisi haliweki make mandane wape pea wala꞉tiki pu haemeke haliweki make Diutuseleme da mina꞉pa꞉lao a꞉paata꞉ Yesu pa꞉ta꞉ mombelemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kutupa Yesuna꞉ disaipolo haliwekima꞉ na tandepemeke kikima꞉ ne nemekeeki handemekeme. Mo Pa꞉tisi haliwekima꞉ dupiki tandepea꞉peke laa lemeke tupa꞉ kiki na tandepemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Hande Pa꞉tisi haliwekima꞉ make Diu haliweki paeyaoma꞉ make apa꞉meina꞉ haumanu pu haemekeeki hone witolo hata꞉ ne noluekema꞉ kiki amba꞉la tandepo haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kutupa makedina꞉ hao a꞉paata꞉ ikali a̱i̱ na peki hata꞉ta꞉ ne a̱i̱ na netiki pu halememe. Ika꞉ apa꞉meina꞉ titina꞉ haumanu make wopu opua pu halememe. Koto ekina꞉ kapomanu make sosepenimanu make kopama꞉ wepiki metekimanu make bedi make tandepo halememe. ");
INSERT INTO ssx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kutupa mo Pa꞉tisi haliwekima꞉ make mo wape pea wala꞉tiki pu haemeke haliwekima꞉ make Yesu pa꞉ta꞉ lota꞉ pitolo hata꞉ alota꞉ Naka꞉ disaipolo haliwekima꞉ ika꞉ ateke meiyekena꞉ haumanu na opiki ekipeke kiki hoke ekima꞉ ne no halemepe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Ikita꞉ yayapiki hau pu haleme haliwekie laata꞉ Aisayama꞉ iki pa꞉ta꞉ pi walolo hata꞉ wape piekeeki dupa. Do wanda꞉halima꞉ ika꞉ hambilikima꞉ yaka biki mea a꞉meiyaasemepate ika꞉ puki pa꞉ta꞉ hone ta꞉ta꞉ witelememe. ");
INSERT INTO ssx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","I̱ pa꞉ta꞉ pa hameke panda꞉ puniao yeni pu halememe. Pa ekipeke ikana꞉ma꞉ Dota꞉ Koda꞉na꞉ pi wieke ekimanue alo hata꞉ pa ika꞉ ateke meiyekena꞉ wimikieki kone walo halememe laa wape piekeme laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesuma꞉ ombu alota꞉ Koda꞉na꞉ pi ula꞉ ekimanu na waleke ika꞉ ateke meiyekena꞉eki kone walo halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kutupa ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Koda꞉na꞉ pi ula꞉ ekimanu mina꞉pa꞉laota꞉ ika꞉ ateke meiyekena꞉ hau pimiki ekimanu pu haleme ekita꞉ epeke hau pitolo pimipe laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesima꞉ alota꞉ Naka꞉ ama꞉ apa꞉ yaapo oto pa꞉ta꞉ hapeke la꞉la꞉me. Kutupa ipika꞉ apa꞉ ama꞉ pa꞉ta꞉ hoke pi ala꞉ halita꞉ ota꞉ homena꞉ lia꞉pa꞉peke la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Koto leekepate ikana꞉ma꞉ alota꞉ Hali ma꞉nda꞉ma꞉ ipika꞉ apa꞉ ama꞉ pa꞉ta꞉ alota꞉ Ipiliki pa꞉ta꞉ kulu polo ala꞉ta꞉ ameta꞉ Kobana ula꞉me lea꞉ka꞉na꞉ta꞉ kobana la꞉la꞉ ekita꞉ Koda꞉na꞉ ekie ");
INSERT INTO ssx_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","kota꞉ ikana꞉ma꞉ta꞉ mo halima꞉ ipika꞉ apa꞉ ama꞉ pa꞉ta꞉ koto ala꞉ta꞉ hala꞉peke na ya꞉la꞉me lo halememe. ");
INSERT INTO ssx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Do tupa꞉ ika꞉ ateke meiyekema꞉ pimiki ekimanu opitolo hata꞉ Koda꞉ma꞉ la꞉la꞉ pita꞉ alupaasememe. Kutupa ika꞉ hoki nane telieleme haliweki make walo halememe laata꞉ Koto tupa꞉ kone mandane haumanu make pu halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kutupa Yesuma꞉ wanda꞉hali ipiki pa꞉ta꞉ epena꞉yeke paa wi lemipi piekeme. Kutupa iki pa꞉ta꞉ alota꞉ Iki paeyao ya pi opua hone wia꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wanda꞉halita꞉ hama꞉ nane ula꞉ alemanu mea naloma꞉eki manuma꞉ na hoeyaalo pa꞉la꞉pate tukiki nane wia ipula꞉ ale manuma꞉ kone wanda꞉hali hoeyaapeke ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ipikana꞉ma꞉ wanda꞉hali mina꞉pa꞉lao da tukiki pa꞉ta꞉ honda꞉ pambeeketa꞉ ipika꞉ disaipolo haliwekima꞉ onkoluma꞉ leeke ekina꞉ ipiki pa꞉ta꞉ lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kutupa ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Kotota꞉ iki make pi teke hone na witelemepe leekeme. Yonkeleke hama꞉ nane ula꞉ alemanu mea naloma꞉eki manuma꞉ tukiki nane pea꞉ka꞉na꞉ta꞉ hoeyaapeke na ya꞉la꞉me. Koto ekita꞉ hone na witelemepe. ");
INSERT INTO ssx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ekipeke. Neta꞉ ipika꞉ puki pa꞉ta꞉ na peke ipika꞉ weleke pa꞉ta꞉ puaata꞉ hoke ale yapilieke leekeme. Koto pi leeke handaata꞉ Yesuma꞉ nemanu paeyaota꞉ pa napeke ana꞉ pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kutupa ipikana꞉ma꞉ alota꞉ Wanda꞉hali tukiki pa꞉ta꞉ wia ipula꞉ ale manuma꞉ wanda꞉hali hoeyao halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wanda꞉halina꞉ puki tukiki pa꞉ta꞉ wia hone pa꞉ta꞉ ipu hala꞉ hau manuta꞉ dupae. Hoke honemanu make loke apa꞉taasa꞉ hau make pake nala꞉ hau make hali homena꞉ lita꞉la꞉eki make ");
INSERT INTO ssx_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tooli ka꞉taasa꞉ hau make we pamba꞉la꞉ hau make hoke hoke hau make yayapiki hau make pamba꞉ na piki hau make ne tunkula꞉la꞉ hau make pi lala pu handaena꞉ hau make hone na wiki hau make ");
INSERT INTO ssx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","do haumanu paeyaota꞉ puki pa꞉ta꞉ pita ipulu hata꞉ wanda꞉hali hoeyao halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesuma꞉ koto alena꞉ mina꞉pa꞉lao Taiya nane peekeme. Mo da homeke ma꞉nda꞉ honda꞉ pambaata꞉ wanda꞉halima꞉ ipiki handaama꞉na꞉ a꞉mbao panka pituluekema꞉ peekepate a꞉mbaapeke na yeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Koto kone wanda꞉ ma꞉nda꞉ma꞉ Yesuna꞉ pieke haumanu opuaata꞉ Yesu pa꞉ta꞉ a꞉pa ipika꞉ anke pa꞉ta꞉ panda꞉ puniaeyekeme. Koto wanda꞉na꞉ wandikita꞉ weleke pa꞉ta꞉ hoke temoko pitieke handaata꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ipikita꞉ Sitia nane hala꞉ da Pinisia wanda꞉ kone hayekepate Kitiki pi lo hayekeme. Ipika꞉ wandikina꞉ weleke tukiki pa꞉ta꞉ pitieke hoke temoko Yesuma꞉ tolu lina꞉yeke honke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Honke leekepate Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Weki wandiki sunuma꞉ ne amba꞉la nena꞉e leekeme. Wekiwandiki sununa꞉ neta꞉ kika sunu pa꞉ta꞉ mea lopaeya꞉ka꞉na꞉ta꞉ ana꞉ na pilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Koto leekepate koto wanda꞉ma꞉ alota꞉ Tekehalio. Ota꞉ alepate weki wandiki sunuma꞉ pindipu lopa꞉ lopa꞉ piteleme ekimanu tokele pa꞉ta꞉ kika sunuma꞉ no halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kutupa Yesuma꞉ mo wanda꞉ pa꞉ta꞉ alota꞉ Koto pi leeke handaata꞉ a꞉pa꞉la꞉me. Pue. Hoke temokoma꞉ naka꞉ wandiki mina꞉pa꞉lao opolu bao pea꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kutupa ipika꞉ da puaata꞉ ipika꞉ wandiki da panda꞉ pa꞉ta꞉ peli hake wiekeeki handeekepate mo hoke temoko amba꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesuma꞉ Taiya nane la꞉ka꞉la꞉ minaata꞉ mo Saidoni nane make Daoni kiki yaapo haemeke kenke nane make lombei pupa Ka꞉lili ikali leke pa꞉ta꞉ opolo peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Koto pa꞉ta꞉ wanda꞉halima꞉ mo pi na opu na lo pieke hali homeke Yesu pa꞉ta꞉ hatuku epemekeme. Yesuma꞉ ipika꞉ kikima꞉ mo halina꞉ loke wataena꞉yeke honke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kutupa Yesuma꞉ ipiki hosiki mopateleke wanda꞉hali na hayeke pa꞉ta꞉ hatuku mea pua ipika꞉ kiki ma̱leke mo halina꞉ katake ka꞉ka꞉na꞉ pa꞉ta꞉ pankaata꞉ kutupa dopi taata꞉ ipika꞉ kiki ma̱leke yola꞉ mea mo halina꞉ kekekena꞉ makeke mea kitaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kutupa oli ya nane handa꞉liaaso hata꞉ pomoma꞉ homata꞉ Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Epa꞉da꞉e leekeme. Koto pita꞉ Lomba꞉e laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Koto kone ipika꞉ katake yaapo lumbupa wiaata꞉ ipika꞉ kekeke tindipao hayeketa꞉ kutupa pi epeke tupa꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesuma꞉ wanda꞉hali paeyao pa꞉ta꞉ mana꞉ honkopu hao alota꞉ Ma꞉nda꞉ pa꞉ta꞉ do pitoloeki na lapa꞉peke leekepate kone wanda꞉halima꞉ pa honkopu hao la꞉tia tia pea hande leeke pita꞉ kende tupa꞉ wina꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Koto pita꞉la꞉eki opimiki wanda꞉hali paeyaoma꞉ ota꞉ wopu penkilipa꞉tia pomua꞉tiki pitolo hata꞉ alota꞉ Ipikana꞉ma꞉ hau paeyao pieke ekina꞉ epeke tupa꞉ pu hala꞉me laata꞉ pi opua꞉peke na ya꞉la꞉ halima꞉ opina꞉ pi lapeke na ya꞉la꞉ halima꞉ pi lena꞉ lo hala꞉me laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Koto pita꞉ta꞉ wanda꞉hali wopu tayaemeketa꞉ kutupa napeke ne dia꞉yekeme. Yesuma꞉ ipika꞉ disaipolo haliweki ipiki pa꞉ta꞉ epena꞉ wi la꞉ lemipi pea iki pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Do wanda꞉hali pa꞉ta꞉ ya pukima꞉ e̱ ala꞉me leekeme. Hoto tepo I̱ ame̱le̱ haememe. Kutupa ameta꞉ napeke ne dia꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","I̱ma꞉ta꞉ ika꞉ da tea꞉ma꞉ homa꞉ paleke tapa tapa pua꞉ka꞉na꞉ta꞉ kota꞉ pota꞉ hopikina꞉ tea꞉ma꞉ homilimikie. Mandane wanda꞉halita꞉ papatena꞉ hao a꞉pa pelememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ipika꞉ disaipolo haliwekima꞉ ipiki pa꞉ta꞉ alota꞉ Do hapu hayeke alena꞉ hata꞉ta꞉ koto wanda꞉hali pa꞉ta꞉ neta꞉ handopate mea halomana꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesuma꞉ iki pa꞉ta꞉ dupa lota꞉ pitolo alota꞉ Palaowa siki ekipu wia halemepe laa lota꞉ piekeme. Mo haliwekima꞉ alota꞉ Watake hata꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesuma꞉ mo wanda꞉hali wopu pa꞉ta꞉ alota꞉ Kenkena꞉ pita꞉pe leekeme. Kutupa mo palaowa siki watake hata꞉ meaata꞉ Koda꞉ pa꞉ta꞉ keiyae pi laa pindi pindi peaata꞉ ipika꞉ disaipolo haliwekima꞉ wanda꞉hali pa꞉ta꞉ hale hale pina꞉ haleekeme. Kutupa mo disaipolo haliwekima꞉ mo wanda꞉hali pa꞉ta꞉ mea hale hale pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ta꞉peli tepo a꞉nda꞉ make wia haemeke handaa Yesuma꞉ Koda꞉ pa꞉ta꞉ keiyae pi laata꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ Do ta꞉pelimanu make mea hale hale pipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Kutupa paeyaoma꞉ naa weleke haemekeme. Mo wanda꞉halima꞉ naa putu piliki wieke ekita꞉ meaata꞉ ala꞉ta tieke watake hata꞉ tumbaemekeme. Wanda꞉halita꞉ 4 daoseni tupa꞉ wanda꞉hali haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yesuma꞉ iki paeyao tapa tapa peaata꞉ koto kone ipika꞉ disaipolo haliweki ame̱le̱ kawaso pa꞉ta꞉ pita Da꞉la꞉ma꞉nuta da nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pa꞉tisi haliwekima꞉ Yesu pa꞉ta꞉ a꞉pa mineke pi laa ipika꞉ anke yololo alota꞉ Hepeni nane wele pita꞉la꞉eki ma꞉nda꞉ handomono pie lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesuma꞉ ipika꞉ pukima꞉ pomo tieke wotu homolo hata꞉ alota꞉ Ame do haleme wanda꞉halima꞉ ekipeke wele pita꞉la꞉eki ma꞉nda꞉ weitelemepe leekeme. Iki pa꞉ta꞉ ota꞉ pi alome. Ame do haleme wanda꞉halima꞉ wele pita꞉la꞉eki ma꞉nda꞉ na handilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kutupa mo haliweki mina꞉pa꞉laota꞉ kawasona꞉ pua pita mone tea꞉na꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesuna꞉ disaipolo haliwekima꞉ palaowa hone yonka꞉lao na mea pemekeme. Koto ekina꞉ kawasona꞉ palaowa homekesiki wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesuma꞉ mana꞉ alo hata꞉ iki pa꞉ta꞉ alota꞉ Wotu hapa꞉peke. Pa꞉tisi haliwekina꞉ palaowa pombei yaasa꞉eki make Hetodina꞉ palaowa pombei yaasa꞉eki make wotu handa꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ika꞉ ika꞉ kone hone wia pipi lemekeme dupa. Nikita꞉ palaowa dia꞉ya꞉ka꞉ta꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kutupa Yesuma꞉ ika꞉ hone wimikieki handaa iki pa꞉ta꞉ alota꞉ Ne dia꞉ ya꞉leketa꞉ pa ekipeke pipi alemepe. Ika꞉ hone na wiki a̱i̱ na handelemepe. Ika꞉ honemanu taka꞉laalemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ika꞉ leke hala꞉pate na hando halemepe. Ika꞉ katake hala꞉pate na opu halemepe. Na niminaasemepe. ");
INSERT INTO ssx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mo hande palaowa siki yunki hata꞉ 5 daoseni haliwekina꞉ pindi pindi peaowa꞉ pita꞉ma꞉ta꞉ putu pilikima꞉ta꞉ ala꞉ta tieke ekipu tumba mimipe leekeme. Ikana꞉ma꞉ ipiki pa꞉ta꞉ alota꞉ 12 lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kutupa Yesuma꞉ alota꞉ Mo hande palaowa siki watake hata꞉ mo 4 daoseni wanda꞉halina꞉ pindi pindi peaowa꞉ pita꞉ma꞉ta꞉ putu pilikima꞉ta꞉ ala꞉ta tieke ekipu tumba mimipe leekeme. Ikana꞉ma꞉ ipiki pa꞉ta꞉ alota꞉ Watake hata꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kutupa ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ A̱i̱ na handelemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ikana꞉ma꞉ Betesaida da opolo pemekeme. Mandane wanda꞉halima꞉ leke holupiki hali ma꞉nda꞉ Yesu pa꞉ta꞉ hatuku a꞉paata꞉ koto hali wataena꞉yeke Yesu pa꞉ta꞉ honke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesuma꞉ mo hande leke holupiki halina꞉ kiki minaata꞉ da mina꞉pa꞉lao mo pate leke hatuku peekeme. Hatuku pua ipika꞉ leke pa꞉ta꞉ dopi taata꞉ ipika꞉ kiki yaapoma꞉ mo halina꞉ lokena꞉ kiki tapopao lota꞉ pitolo hata꞉ alota꞉ Ala꞉ta꞉ ma꞉nda꞉ handelepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mo halima꞉ handa꞉liao alota꞉ Haliweki handolopate pa ti leke ale pominelememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kutupa Yesuma꞉ ipika꞉ kiki yaapoma꞉ mo halina꞉ leke yaapo paa wataeyeke mo halima꞉ wotu handaata꞉ ipika꞉ leke telipina꞉ pa epeekeme. Kutupa ala꞉ta꞉ ala꞉ta꞉ paeyao epeke tupa꞉ handeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesuma꞉ mo hali ipika꞉ da tapaaso hata꞉ alota꞉ Da teke nane a̱i̱ na pua꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kutupa Yesuma꞉ ipika꞉ disaipolo haliweki ame̱le̱ mo Sesatia Pilipai nane damanu pa꞉ta꞉ pemekeme. Pota꞉na꞉ pulu hata꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ lota꞉ piekeme dupa. I̱ta꞉ epiya꞉ka꞉ta꞉pe. Wanda꞉halima꞉ eki lo halemepe laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kutupa ikana꞉ma꞉ ipiki pa꞉ta꞉ alota꞉ Bapitaisi peao hayeke hali Dionie. Mandane wanda꞉halima꞉ta꞉ Neketa꞉ Elaidiae. Mandane wanda꞉halima꞉ta꞉ Neketa꞉ potopede hali ma꞉nda꞉e lo halememe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kutupa iki pa꞉ta꞉ paa lota꞉ piekeme dupa. Koto lo halemepate ikana꞉ma꞉ta꞉ I̱ta꞉ epi lo halemepe leekeme. Pidama꞉ ipika꞉ pi hombo peaaso alota꞉ Neketa꞉ Ketisoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesuma꞉ iki pa꞉ta꞉ hando alo hata꞉ alota꞉ I̱ pa꞉ta꞉ koto aleme pita꞉ wanda꞉hali ma꞉nda꞉ pa꞉ta꞉ na lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesuma꞉ panake pi ma꞉nda꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ walolo hata꞉ alota꞉ Wanda꞉halina꞉ Eiyeketa꞉ tanda tanda tieke wotu milieke leekeme. Mo tondiki haliwekima꞉ make yeni peao haleme you haliwekima꞉ make wape pea wala꞉tiki pu haleme haliwekima꞉ make ipiki kiao limika꞉na꞉ta꞉ homilieke leekeme. Kutu pimika꞉na꞉ta꞉ hoto tepo wia paa tiaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Koto leeke ekita꞉ ota꞉ peneme waleekeme. Kutupa Pidama꞉ Yesu hosiki mopate leke hatuku mea pua ipiki pa꞉ta꞉ alota꞉ Kutupiki pi na lapeke leekepate ");
INSERT INTO ssx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesuma꞉ la꞉ka꞉la ipika꞉ disaipolo haliweki handaata꞉ Pida hando alo hata꞉ alota꞉ Sadani neke pue. I̱ teke pa꞉ta꞉ na hapeke leekeme. Neketa꞉ Koda꞉ma꞉ ula꞉ hone tupa꞉ na wiki pa wanda꞉halima꞉ witeleme hone leke wilimee leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesuma꞉ pota꞉na꞉ titi yola pemeke wanda꞉hali make ipika꞉ disaipolo haliweki make ipiki pa꞉ta꞉ epena꞉yeke wi lemipi peaata꞉ iki pa꞉ta꞉ alota꞉ Ya hoki nane toluekema꞉ hone pa꞉la꞉ halima꞉ ipiki pa꞉ta꞉ kone hone ula꞉ ekimanu tunkulaata꞉ ipika꞉ a꞉ka꞉tei wapepiki ti mea tia ya hoki nane telina꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kutu pa꞉la꞉ ekima꞉ hali epima꞉ ipika꞉ hao hala꞉eki miniki hao haluekema꞉ hone wia꞉ka꞉na꞉ta꞉ kota꞉ ipika꞉ hao hala꞉eki kone alupilieke leekeme. Kutu piliepate I̱ pa꞉ta꞉ make do handa꞉ Pi Seliapo pa꞉ta꞉ make hone witolo hata꞉ ipika꞉ hao hala꞉eki alupaasa꞉ halima꞉ ota꞉ da꞉taa halieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Hali epima꞉ do kenke ala꞉ta꞉ ala꞉ta꞉ paeyao ipika꞉eki wina꞉ laa alo hata꞉ ipika꞉ hao hala꞉eki alupia꞉ka꞉na꞉ta꞉ kota꞉ epeke ekita꞉ ekipa miliepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Koto somema꞉ ipika꞉ hao hala꞉eki paa muluekema꞉ alekema꞉ topo peaalia꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Do hande Koda꞉ pa꞉ta꞉ hone na wiki ti teke yoko haleme wanda꞉hali ame̱le̱ hala꞉ hali ma꞉nda꞉ epima꞉ I̱ pa꞉ta꞉ tonka꞉na꞉ yaka pi alemanu pa꞉ta꞉ tonka꞉na꞉ hunkupuma꞉ homea꞉ka꞉na꞉ta꞉ kota꞉ koto hali pa꞉ta꞉ mo Wanda꞉halina꞉ Eiyekema꞉ hunkupuma꞉ homilieke. Ipika꞉ Atekena꞉ pa̱a̱ pa꞉la꞉eki tukiki pa꞉ta꞉ hao hande yakopiki enisolo tonu ame̱le̱ ipilia꞉ dina꞉ta꞉ kota꞉ koto hali handa꞉peketa꞉ hunkupuma꞉ homilieke. ");
INSERT INTO ssx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kutupa ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Iki pa꞉ta꞉ ota꞉ pi alome. Do haleme wanda꞉hali mandaneeki manuta꞉ a̱i̱ na homeke pa hata꞉ kone Koda꞉ ipika꞉ welema꞉ ipika꞉ Kilu Tombuao Hala꞉eki epolo pa꞉la꞉ ekita꞉ handilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kutupa hoto yunki mindiki hata꞉ hao Yesuma꞉ Pida Dia꞉mesi Dioni tepo handa꞉ meaata꞉ pote tumiki pa꞉ta꞉ pua ika꞉siki haemekeme. Kutupa ika꞉ leke popeleke nane hata꞉ Yesuna꞉ loke wonu piliekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kutupa ipika꞉ daumanu make pa̱a̱ peaata꞉ hake wopu piekeme. Kenke hali ma꞉nda꞉ma꞉ koto tupa꞉ dau hake peaapeke na ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kutupa Elaidia Mosesi yaapo opolo a꞉paata꞉ Yesu ame̱le̱ pi pi lo haemekeme. Kutu pitolo haena꞉ koto disaipolo hali tepoma꞉ handemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pidama꞉ Yesu pa꞉ta꞉ alota꞉ Tekehalio. Do pa꞉ta꞉ do haloma꞉ ekita꞉ a꞉pa꞉la꞉me. Sale da tepo a꞉eyamono lae laata꞉ Homeke naka꞉eki ma꞉nda꞉ Mosesina꞉eki ma꞉nda꞉ Elaidiana꞉eki pea a꞉eyamono lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pututuma꞉ homemeke handaa Pidama꞉ pi loluekema꞉ hayekepate hone na wiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kutupa koama꞉ iki tu̱ peaaso haena꞉ mo koa tukiki pa꞉ta꞉ pi ho̱la̱꞉makema꞉ la꞉niaeyekeme dupa. Kotota꞉ yaka puki piki wekie. Ipika꞉ pi opua꞉pa꞉peke la꞉niaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kutupa koto kone koto hali tepoma꞉ lekema꞉ lekema꞉ pimikipate hali ma꞉nda꞉ na handeke Yesu homeke handemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Potena꞉ hola꞉pa꞉niaaso hata꞉ Yesuma꞉ iki hando alo hata꞉ alota꞉ Oli handemeeki ma꞉nda꞉ pa꞉ta꞉ na lapa꞉peke. Wanda꞉halina꞉ Eiyeketa꞉ ota꞉ homa paa tiao haya꞉ka꞉na꞉ alota꞉ Ana꞉ pilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Koto ekina꞉ ika꞉ kone pi wia miniki hata꞉ ota꞉ homa paa tiaalieke laa lea꞉ ekita꞉ lota꞉ lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yesu pa꞉ta꞉ lota꞉ pimikime dupa. Pa ekipeke mo wape pea wala꞉tiki pu haleme haliwekima꞉ titina꞉ amba꞉la Elaidia ipilieke lo halemepe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kutupa Yesuma꞉ iki pa꞉ta꞉ alota꞉ Titina꞉ amba꞉la Elaidia ota꞉ ipilieke. Ala꞉ta꞉ ala꞉ta꞉ tikitiki yao wina꞉yeke ipilieke laata꞉ Mo hande Wanda꞉halina꞉ Eiyeke pa꞉ta꞉ tanda tieke mu yaala꞉ma꞉ homao kiaalo peleme ekita꞉ eki eki pa la꞉la꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kutu piliepate I̱ma꞉ iki pa꞉ta꞉ alome. Elaidia amba꞉la epea꞉pate pa mo Baibolo bukana꞉ wape pa꞉la꞉ tupa꞉ ika꞉ hone pa꞉la꞉ ekimanu ipiki pa꞉ta꞉ pimikime leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kutupa ikana꞉ma꞉ mo mandane disaipolo haliweki haemeke alena꞉ opolo puaata꞉ koto haliwekita꞉ wanda꞉hali wopu hao popei yao yopua haemeke ekina꞉ handemekeme. Pa ekipeke mandane wape pea wala꞉tiki pu haemeke haliwekita꞉ hande disaipolo haliweki ame̱le̱ kake ne̱li pitolo hata꞉ haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kota꞉ koto kone mo wanda꞉hali paeyaoma꞉ Yesu handaata꞉ penkilipa ipiki pa꞉ta꞉ anke hao puaata꞉ pi pi lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kutupa Yesuma꞉ iki pa꞉ta꞉ lota꞉ pitolo alota꞉ Mo haliweki ame̱le̱ alekena꞉ pi pi alemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wanda꞉hali tukiki pa꞉ta꞉ hayeke hali ma꞉nda꞉ma꞉ ipika꞉ pi hombo peaaso alota꞉ Tekehalio. Yaka weki neke pa꞉ta꞉ hatuku epoa꞉me. Hoke temoko pila꞉ ekima꞉ pi na lo hala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kutupa mo hoke temokoma꞉ da꞉ka꞉pe miniki pita꞉ka꞉na꞉ mea lopao hala꞉me leekeme. Koto ekima꞉ ya wekina꞉ kake pa꞉ta꞉ dako hankoloma꞉ lia ipika꞉ kake lenkena꞉ lao hala꞉me leekeme. Kutupa ipika꞉ loketa꞉ tindipulu bao da̱o̱la hao hala꞉me la ombu alota꞉ Naka꞉ disaipolo haliwekima꞉ tolu lina꞉yeke honke loa꞉pate mo haliwekima꞉ ana꞉ na pia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Ikita꞉ hone na tulaaseme wanda꞉halie. Nate ekipuna꞉ iki ame̱le̱ ombu hao hanope. Nate ekipuna꞉ ika꞉ ka꞉nda꞉ kiteleme ekimanu meonope laata꞉ I̱ pa꞉ta꞉ hatuku ipupe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Koto leeke mo wekita꞉ ipiki pa꞉ta꞉ hatuku mea pemekeme. Pate mo hoke temokoma꞉ Yesu handaata꞉ mo weki lu keayekeme. Kutu pieke mo wekita꞉ ipika꞉ kake pa꞉ta꞉ dako hankoloma꞉ liaaso haena꞉ kenkena꞉ lopaaniao petepete pomiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesuma꞉ ipika꞉ ateke pa꞉ta꞉ lota꞉ pitolo alota꞉ Do hauta꞉ nate ekipuna꞉ pea pa꞉la꞉pe leekeme. Ipika꞉ atekema꞉ alota꞉ Panake wekisiki ya꞉pate kone pea pia꞉me laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hoke temokoma꞉ hoto eleke eleke ti uleke pa꞉ta꞉ make ikali pa꞉ta꞉ make ipiki hoeyaaluekema꞉ mea lopaatiki pu haya꞉me leekeme. Kutu pia꞉pate nakana꞉ma꞉ ana꞉ pia꞉ka꞉na꞉ta꞉ kota꞉ niki pa꞉ta꞉ a꞉ta꞉ma꞉ homa pa꞉ta꞉la꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Koto leeke Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Aowe. Naka꞉ hone tulaasa꞉ ekita꞉ ana꞉ pia꞉ka꞉na꞉ kota꞉ I̱ma꞉ epeaalueke. Wanda꞉hali epi amedama꞉ hone tulaeka꞉na꞉ta꞉ hau paeyao pea꞉peke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kutupa koto kone mo wekina꞉ atekema꞉ wi alo hata꞉ alota꞉ Hone tulaasome. Ya hone na tulaasoeki nakana꞉ma꞉ pa꞉ta꞉la꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesuma꞉ wanda꞉hali wopu a̱i̱ya epemekeeki handaata꞉ mo hoke temoko hando alo hata꞉ alota꞉ Pi na lao pi na opuaasa꞉ temoko neke pa꞉ta꞉ dupiki pi alome. Koto weki mina꞉pa꞉lao opolu bao yopuata꞉ paa na honda꞉ pamba꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Koto pi opuaata꞉ hoke temokoma꞉ hoke e̱ wi alo hata꞉ mo weki wopu mea lu keaota꞉ mina꞉pa꞉lao opolu bao yapeekeme. Kutu pieketa꞉ mo weki ota꞉ homeeke hali toko leke wiekeme. Koto ekina꞉ wanda꞉hali eleke elekema꞉ alota꞉ Ipikita꞉ ota꞉ homea꞉ka꞉ta꞉me lemekepate ");
INSERT INTO ssx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesuma꞉ ipika꞉ kiki yola꞉ mea miniliaeyeke mo weki tiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesuta꞉ da tukiki pa꞉ta꞉ honda꞉ pambaa ipiki honu make haena꞉ mo disaipolo haliwekima꞉ lota꞉ pitolo hata꞉ alota꞉ Nikana꞉ma꞉ mo hoke temoko tolu lia꞉peke na yeke ekita꞉ ekipape lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Koto lemeke Yesuma꞉ iki pa꞉ta꞉ alota꞉ Kutupiki hoke temokota꞉ Koda꞉ pa꞉ta꞉ yeni pita꞉la꞉me ekima꞉ homeke tolu lia꞉peke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Koto alena꞉ mina꞉pa꞉lao puaata꞉ mo Ka꞉lili nane lombei pu pa puaata꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ pi la haluekema꞉ta꞉ wanda꞉halima꞉ ipiki handaapena꞉ hone wiekeme. Ipika꞉ disaipolo haliweki pa꞉ta꞉ dupa waleekeme. Wanda꞉halina꞉ Eiyeketa꞉ haliweki oto pa꞉ta꞉ haena꞉ loluekema꞉ mea halieke. Kutu pia꞉ka꞉na꞉ta꞉ mo haliwekima꞉ ipiki limikie. Kota꞉ ota꞉ homiliepate hoto tepo wia paa da꞉taalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Koto leekepate mo haliwekima꞉ta꞉ hone na wimikime. Kutupa paala꞉ma꞉ homolo hata꞉ lota꞉ na pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapeneami da pa꞉ta꞉ puaata꞉ da tukiki pa꞉ta꞉ honda꞉ pamba hata꞉ Yesuma꞉ ipika꞉ disaipolo haliweki lota꞉ pitolo hata꞉ alota꞉ Ikana꞉ma꞉ pota꞉na꞉ ipulu hata꞉ aleke ata꞉ta꞉ pimipe laa leekepate ");
INSERT INTO ssx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ikana꞉ma꞉ pi na leke pa pitimikime. Ekipeke mo pota꞉na꞉ ipulu hata꞉ epi tieke hala꞉pe laa ata꞉ta꞉ pimiki handaa pi na leke pa pitimikime. ");
INSERT INTO ssx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kutupa Yesuta꞉ pitiniao pita꞉ mo 12 haliweki wi laa iki pa꞉ta꞉ alota꞉ Hali epima꞉ titina꞉ I̱ halueke hone wia꞉ka꞉na꞉ta꞉ kota꞉ koto halita꞉ wetepena꞉ hali hano laata꞉ wanda꞉hali paeyaona꞉ e pokaasa꞉ hali hano lena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Koto laata꞉ wekisiki ma꞉nda꞉ mea iki tukiki pa꞉ta꞉ haena꞉ laata꞉ mo wekisiki hopula꞉ mea iki pa꞉ta꞉ alota꞉ Hali epima꞉ dupiki wekisiki I̱ pa꞉ta꞉ hone witolo hata꞉ handa꞉ mia꞉ka꞉na꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","kota꞉ I̱ kone handa꞉ mina꞉la꞉me. Kutupa hali epima꞉ I̱ handa꞉ mia꞉ka꞉na꞉ta꞉ I̱ homeke dia꞉me. Hande I̱ tapaeya꞉ hali make handa꞉ mina꞉la꞉me laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Koto leeke handaa Dionima꞉ ipiki pa꞉ta꞉ alota꞉ Disao. Hali ma꞉nda꞉ma꞉ naka꞉ biki alo hata꞉ hoke temokomanu tolu lia꞉tiki pia꞉eki handoma꞉me. Koto someta꞉ niki ame̱le̱ mandakena꞉ na pomieke handaa sa꞉sa꞉ puma꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Koto leekepate Yesuma꞉ alota꞉ Pa sa꞉sa꞉ na pea꞉pa꞉peke. Hali epima꞉ yaka biki alo hata꞉ wele pita꞉la꞉eki pia꞉ka꞉na꞉ta꞉ wetepena꞉ koto halima꞉ta꞉ yaka biki na hoeyaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Hali ma꞉nda꞉ epima꞉ niki pa꞉ta꞉ a꞉nda꞉ na lia꞉ka꞉na꞉ta꞉ ipikita꞉ nika꞉ halie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Iki pa꞉ta꞉ ota꞉ pi alome. Ikana꞉ma꞉ta꞉ ya biki melemeke handaata꞉ hali epima꞉ ikali naaka꞉na꞉ ipi kanakena꞉ hola꞉ pamba iki kia꞉ka꞉na꞉ta꞉ ipika꞉ yenki ota꞉ milieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Hali epima꞉ do I̱ pa꞉ta꞉ hone tulaaseme weki wandiki sunu homeke ma꞉nda꞉ma꞉ hoke hau pina꞉ pu tiaena꞉ lea꞉ka꞉na꞉ta꞉ kota꞉ koto halina꞉ make pa꞉ta꞉ toopi hombeleke mea tonkao oni dawala pa꞉ta꞉ mo hali mea lopaeya꞉ka꞉na꞉ yoluta꞉ epolo pia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Naka꞉ kikima꞉ hoke hau puelena꞉ lea꞉ka꞉na꞉ta꞉ koto kiki tunkulu baapeke leekeme. Kiki homeke hata꞉ hao hala꞉eki mika꞉na꞉ta꞉ epolo pa꞉la꞉pate kiki yaapo hata꞉ ti to hala꞉ alena꞉ peka꞉na꞉ta꞉ hoelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(besi namba 48 handa꞉peke) ");
INSERT INTO ssx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Naka꞉ ankema꞉ hoke hau puelena꞉ lea꞉ka꞉na꞉ta꞉ naka꞉ anke tunkulu baapeke leekeme. Anke homeke hata꞉ hao hala꞉eki mika꞉na꞉ta꞉ epelieke leekeme. Anke yaapo hata꞉ ti to hala꞉ alena꞉ peka꞉na꞉ta꞉ hoelieke. ");
INSERT INTO ssx_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(besi namba 48 handa꞉peke) ");
INSERT INTO ssx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Naka꞉ lekema꞉ hoke hau puelena꞉ lea꞉ka꞉na꞉ta꞉ naka꞉ leke yoka꞉ mea baapeke leekeme. Leke homeke hata꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki pa꞉ta꞉ peka꞉na꞉ta꞉ epelieke. Leke yaapo haeka꞉na꞉ta꞉ mo ti to hala꞉ alena꞉ neke mea lopaeya꞉ka꞉na꞉ta꞉ hoelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Koto alena꞉ta꞉ iki no haleme kimimanu na homo halememe. Kutupa mo ti to hala꞉eki na hundinekepato hala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ma꞉na꞉ hotekena꞉ damena pu ala꞉ tupa꞉ wanda꞉hali paeyaona꞉ ti tala꞉eki pu lelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Epita꞉ a꞉pa꞉la꞉pate ipika꞉ tende pa꞉la꞉eki a꞉nda꞉ alu pia꞉ka꞉na꞉ta꞉ kota꞉ ikana꞉ma꞉ mo epita꞉ ekipa paa tende peaalipikipe leekeme. Ika꞉ kone epi wia hapa꞉peke leekeme. Kutupa ika꞉ ika꞉ kone a꞉nda꞉ pelia homu pu alu alu pea꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Koto alena꞉ mina꞉pa꞉lao Yesu Diudia nane pua mo Diodani ikali yuma mone tea꞉ nane make peekeme. Wanda꞉hali wopu ipiki pa꞉ta꞉ pa a꞉pa mombelemekeme. Kutupa amba꞉ walo hayeke tupa꞉ paa waleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mandane Pa꞉tisi haliwekima꞉ Yesuna꞉ anke yololo hata꞉ a꞉pa lota꞉ pimikime dupa. Hali ma꞉nda꞉ma꞉ ipika꞉ wanda꞉ yokea꞉ka꞉na꞉ta꞉ o kiaeya꞉ka꞉na꞉ta꞉ ana꞉ pa꞉la꞉pe o ana꞉ na pa꞉la꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Mosesima꞉ eki pi ula꞉eki leekepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ikana꞉ma꞉ alota꞉ Mosesima꞉ta꞉ ipika꞉ wanda꞉ yoka꞉la꞉eki o kiaasa꞉eki tameiya꞉na꞉ wape pina꞉ laa kutupa yokena꞉ o kiaena꞉ lo hayekeme lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Ika꞉ puki taka꞉laaso hamina꞉ koto hau pea꞉pa꞉peke laa wape piekepate ");
INSERT INTO ssx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ala꞉ta꞉ ala꞉ta꞉ wepia haena꞉ la꞉la꞉ dina꞉ta꞉ Koda꞉ma꞉ hali make haena꞉ wanda꞉ make haena꞉ leekeme laa ");
INSERT INTO ssx_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Koto ekita꞉ hali ma꞉nda꞉ma꞉ ipika꞉ ateke inkiki yaapo mina꞉pa꞉lao ipika꞉ ma꞉la꞉ wanda꞉ yaapo pa꞉ta꞉ apa꞉tao ta꞉ma꞉ni pea halipipikie. ");
INSERT INTO ssx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kutupa ipilikita꞉ homeke kone halipipikie leekeme. Koto ekina꞉ ipilikita꞉ yaapo dia꞉me. Homeke kone halepeme leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Koto ekina꞉ Koda꞉ma꞉ apa꞉taasa꞉ ekita꞉ halima꞉ ka꞉ta꞉alu na peaena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Da pa꞉ta꞉ honda꞉ pambaa hata꞉ Yesuma꞉ hande leeke pi pa꞉ta꞉ ipika꞉ disaipolo haliwekima꞉ ipiki paa lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Hali epima꞉ ipika꞉ wanda꞉ yokaata꞉ o kiaota꞉ wanda꞉ ma꞉nda꞉ mia꞉ka꞉na꞉ta꞉ mo mupeke wanda꞉ pa꞉ta꞉ pi ula꞉eki yamba꞉la hoke hau pita꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kutupa wanda꞉ma꞉ ipika꞉ haliki ota꞉ mina꞉pa꞉lao hali ma꞉nda꞉ pea꞉ka꞉na꞉ta꞉ kota꞉ koto wanda꞉ma꞉ pi ula꞉eki yamba꞉la hoke hau pita꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","14","Wanda꞉halima꞉ weki wandiki sunu Yesu pa꞉ta꞉ hatuku pemekeme. Ipikana꞉ma꞉ wataena꞉yeke pimikime. Mo disaipolo haliwekima꞉ wanda꞉hali sa꞉sa꞉ pimikipate Yesuma꞉ handaata꞉ mineke pankolo hata꞉ iki pa꞉ta꞉ alota꞉ Koto weki wandiki sunu I̱ pa꞉ta꞉ epena꞉ lape. Sa꞉sa꞉ na pia꞉pa꞉peke leekeme. Dupiki weki wandiki sunuma꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekita꞉ handilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iki pa꞉ta꞉ ota꞉ pi alome. Wanda꞉hali epima꞉ mo wekiwandiki sunuma꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki minolo piteleme tupa꞉ na mimika꞉na꞉ta꞉ kota꞉ ikita꞉ koto pa꞉ta꞉ ana꞉na꞉ na hondo pambilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kutupa Yesuma꞉ mo wekiwandiki sunu ipika꞉ kiki yaapoma꞉ miniki hata꞉ hopulu mea wamo puma꞉ puma꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesuma꞉ pota꞉na꞉ poluekema꞉ haena꞉ hali homekema꞉ a̱i̱ya puaata꞉ Yesuna꞉ puki pa꞉ta꞉ tumiki yotuao pita꞉ lota꞉ piekeme dupa. Epeke Wala꞉la꞉ Halio. Deto hala꞉eki muluekema꞉ eki ponope leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kutupa Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Ekipeke I̱ pa꞉ta꞉ Epeke halio alepe laata꞉ Ma꞉nda꞉ hali a꞉nda꞉ na a꞉pa꞉la꞉pate Koda꞉ homeketa꞉ a꞉pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Neketa꞉ mo pi ula꞉ ekimanu opueleme. Hali ma꞉nda꞉ ota꞉ homena꞉ na lia꞉peke. Hali ma꞉nda꞉na꞉ wanda꞉na꞉ hakopu na tunkula꞉peke. Pake na napeke. Yayapiki pi na lapeke. Na makeaapeke. Naka꞉ ama꞉ apa꞉ yaapona꞉ pi opua꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kutupa ipikana꞉ma꞉ Yesu pa꞉ta꞉ alota꞉ Wala꞉la꞉ Halio. Koto pimanu paeyao weki hata꞉ kone opu haowa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesuma꞉ ipiki pa꞉ta꞉ handolo hata꞉ a꞉ta꞉ma꞉ homolo hata꞉ alota꞉ Nakana꞉ma꞉ta꞉ homeke hau homeke na pa꞉la꞉me. Neke pua naka꞉ wia hale alemanu paeyao ma꞉nda꞉ma꞉ hambaata꞉ mo natehali wanda꞉hali pa꞉ta꞉ hale hale pika꞉na꞉ta꞉ neketa꞉ oli hepeni nane yenki tieke wialieke leekeme. Kutupa a꞉pa ya hoki nane telia꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesuma꞉ koto leeke handaa mo halima꞉ wenoko homa꞉niao ka꞉nda꞉ma꞉ homolo hata꞉ peekeme. Hamoko hali hayeke handaa piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesuma꞉ la꞉ka꞉la꞉ moneao ipika꞉ disaipolo haliweki handaata꞉ iki pa꞉ta꞉ alota꞉ Hamoko wanda꞉halima꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki pa꞉ta꞉ haena꞉ weleke we wotu pilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ipika꞉ disaipolo haliwekima꞉ koto pi opua penkilipa꞉tia pomimikipate Yesuma꞉ iki pa꞉ta꞉ paa alota꞉ Ya weki titio. Hamoko wanda꞉halima꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki pa꞉ta꞉ pua꞉peke ekita꞉ ka꞉nda꞉ pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kemolo ma꞉na꞉ta꞉ no̱i̱ ka꞉ka꞉na꞉ pa꞉ta꞉ pea꞉ka꞉na꞉ta꞉ yapa꞉ pa꞉la꞉pate hamoko halima꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki pa꞉ta꞉ poluekema꞉ ka꞉nda꞉ pilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kutupa ikana꞉ma꞉ penkilipa꞉tia wotu pomua ipiki pa꞉ta꞉ alota꞉ Kota꞉ epima꞉ da꞉ta꞉la꞉eki mea꞉peke ya꞉la꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesuma꞉ iki handa alota꞉ Wanda꞉halima꞉ ika꞉ kone pea꞉peke na ya꞉la꞉pate Koda꞉ma꞉ homeke ana꞉ pa꞉la꞉me. Koda꞉ma꞉ hau paeyao pea꞉peke ya꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pidama꞉ Yesu pa꞉ta꞉ pi loluekema꞉ alota꞉ Opie. Nikana꞉ma꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao mina꞉pa꞉lao naka꞉ hoki nane telioloma꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Koto leeke Yesuma꞉ alota꞉ Iki pa꞉ta꞉ ota꞉ pi alome. Hali epima꞉ ipika꞉ da ipika꞉ hameke titi ipika꞉ ana꞉ titi ipika꞉ apa꞉ ama꞉ make ipika꞉ wekiwandiki sunu make ipika꞉ kenkemanu make mina꞉pa꞉laeya꞉ka꞉na꞉ta꞉ I̱ pa꞉ta꞉ make koto Pi Seliapo pa꞉ta꞉ make hone witolo hata꞉ koto ekimanu mina꞉pa꞉laeya꞉ka꞉na꞉ta꞉ kota꞉ do kenkena꞉ hata꞉ kone damanu 100 tupa꞉ hameke titi make ana꞉ titi make apa꞉ ama꞉ titi make wekiwandiki sunu make kenkemanu make 100 tupa꞉ miliepate tanda mina꞉la꞉ ekimanu make milieke leekeme. Kutupa mo hao epolo pa꞉la꞉ dina꞉ make deto hala꞉eki milieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kutu pa꞉la꞉pate ame do titina꞉ halo pa꞉la꞉ wanda꞉hali woputa꞉ wetepena꞉ta꞉ wetepe nane halimikie. Kutupa wetepena꞉ ipula꞉ wanda꞉hali woputa꞉ titina꞉ halo pelimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ipika꞉ disaipolo haliweki ame̱le̱ Diutuseleme da nane pula꞉ pota꞉na꞉ opa꞉liaaso haena꞉ Yesu amba꞉ titina꞉ peekema꞉ ipika꞉ disaipolo haliwekima꞉ penkilipa꞉tia pomimikime. Kutupa wetepena꞉ ipulu hata꞉ wanda꞉halima꞉ paala꞉ma꞉ homa꞉ paleke teli mea epemekeme. Yesuma꞉ hande 12 haliweki hosiki mopate leke pa hatuku pua ipiki minulu pimiki haliwekima꞉ ipiki pa꞉ta꞉ pulu pa꞉la꞉ ekimanu koto haliweki pa꞉ta꞉ kini pu mea la hale hale pitolo alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Opua꞉pe. Nikita꞉ ameta꞉ Diutuseleme nane opa꞉liaasoma꞉me. Mo yeni peao haleme you haliwekima꞉ make mo wape pea wala꞉tiki pu haleme haliwekima꞉ make Wanda꞉halina꞉ Eiyeke mea dupa lelimikie. Neketa꞉ homoelena꞉ lumeke lelimikie laata꞉ ikana꞉ma꞉ta꞉ ipikita꞉ mo Diendaili haliweki pa꞉ta꞉ mea halimikie laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","kutupa mo haliwekima꞉ ipiki kitao ipika꞉ lokena꞉ dopi taa yumbua bao limikie leekeme. Kutupa nate tepo wia paeya꞉ka꞉na꞉ta꞉ paa tiaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepedina꞉ eiyeke Dia꞉mesi Dioni yaapoma꞉ Yesu teke pa꞉ta꞉ pua alota꞉ Wala꞉la꞉ Halio. Dika꞉ hone pa꞉la꞉ ale ma꞉nda꞉ honke lolupekema꞉ kuelena꞉e lepekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kutupa Yesuma꞉ ipiliki pa꞉ta꞉ alota꞉ Eki peaanope leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ipilikana꞉ma꞉ alota꞉ Naka꞉ biki tieke mea pitika꞉na꞉ dikita꞉ homeke naka꞉ popeke nane pa꞉ta꞉liki nanema꞉ mea pitao ma꞉nda꞉ naka꞉ hoeya꞉ nane pa꞉ta꞉liki nanema꞉ mea pitaalena꞉e lepekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Koto lepekepate Yesuma꞉ ipiliki pa꞉ta꞉ alota꞉ Ipilika꞉ honke alepe ekita꞉ hone wotu na wiki hata꞉ alepeme leekeme. I̱ma꞉ kapona꞉ nolue ekita꞉ ipilikana꞉ma꞉ make napa꞉peke ya꞉la꞉pe. I̱ bapitaisi peaalia꞉ tupa꞉ ipiliki make bapitaisi peaapeke ya꞉la꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kutupa ipilikana꞉ma꞉ ipika꞉ pi hombo peaaso alota꞉ Diki ana꞉ pa꞉la꞉me lepekeme. Yesuma꞉ ipiliki pa꞉ta꞉ alota꞉ I̱ma꞉ kapona꞉ nolue ekita꞉ ota꞉ nelipipikie. I̱ bapitaisi peaalua꞉ tupa꞉ ipiliki ota꞉ bapitaisi peaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kutu piliepate ya popeke nane kiki hoeya꞉ nane kiki yaapo pa꞉ta꞉ epima꞉ pitilipipikipe laata꞉ I̱ma꞉ lapeke na ya꞉la꞉me. Koda꞉ma꞉ ipika꞉ mulu pa꞉la꞉ hali pa꞉ta꞉ mo pitulu pa꞉la꞉ ale wamo peao ula꞉me. Koto ekina꞉ Koda꞉ma꞉ ipika꞉ mulu pa꞉la꞉ hali pa꞉ta꞉ halieke. ");
INSERT INTO ssx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mo hande kiki yaapo haliwekima꞉ Dia꞉mesi Dioni yaapoma꞉ Yesu pa꞉ta꞉ honke lepekeeki opuaata꞉ ipiliki pa꞉ta꞉ mineke pankemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kutupa Yesuma꞉ mo haliweki ipiki pa꞉ta꞉ epena꞉ laa iki pa꞉ta꞉ alota꞉ Ikana꞉ma꞉ handelememe. Diendaili wanda꞉halina꞉ kapomani tumiki haliwekima꞉ wanda꞉hali tombuao halememe. Kutupa ika꞉ hali tieke tieke manuma꞉ wanda꞉hali Dupa꞉pe laa pi wotu hapolo halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Koto tupa꞉ lo halemepate ikana꞉ma꞉ta꞉ koto hau na pea꞉pa꞉peke. Iki pa꞉ta꞉ hali epima꞉ I̱ tieke halueke hone wia꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ ika꞉ hau peawalieke. ");
INSERT INTO ssx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kutupa iki ame̱le̱ hali epima꞉ I̱ titina꞉ hali haluekee hone wia꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ iki paeyaona꞉ hau peawalieke. ");
INSERT INTO ssx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pa ekipeke mo Wanda꞉halina꞉ Eiyeke kone mo wanda꞉halima꞉ ipika꞉ e pokaena꞉ loluekema꞉ yeke na epeeke yekepate ipikana꞉ma꞉ pa ika꞉ e pokaaluekema꞉ make ipika꞉ da꞉ta꞉la꞉ ekima꞉ta꞉ iki wopuna꞉ hoke hauna꞉ yenki haluekema꞉ epea꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ikana꞉ma꞉ Dietiko da pa꞉ta꞉ opolo pemekeme. Kutupa Yesuma꞉ ipika꞉ disaipolo haliweki make wanda꞉hali wopu make Dietiko da nane mina꞉pa꞉laaso haena꞉ Timeiya꞉sina꞉ eiyeketa꞉ Batimeiya꞉si leke holupiki hali hata꞉ mani honke loluekema꞉ yeke pota꞉ nepokona꞉ pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wanda꞉halima꞉ Na꞉sa꞉tete hali Yesuta꞉ yopula꞉me lemeke pi opuaata꞉ ipikana꞉ma꞉ wi alo hata꞉ alota꞉ Oe. Yesuo. Deipidina꞉ tapake halio. Nakana꞉ma꞉ I̱ pa꞉ta꞉ a꞉ta꞉ma꞉ homa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ipika꞉ leekeeki opuaata꞉ wanda꞉hali wopuma꞉ Pi na lapema laa sa꞉sa꞉ pimikipate ipikana꞉ma꞉ wi anekehapu alota꞉ Deipidina꞉ tapake halio. Nakana꞉ma꞉ I̱ pa꞉ta꞉ a꞉ta꞉ma꞉ homa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kutupa Yesuma꞉ pua pota꞉ hopikina꞉ hando hata꞉ alota꞉ Epena꞉ wi lape leekeme. Wanda꞉halima꞉ mo leke holupiki hali wi laa ipiki pa꞉ta꞉ alota꞉ Puki hana꞉ noka꞉pa tiae. Neke wi ala꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Koto lemeke ipika꞉ make aka꞉ holo baota꞉ anekema꞉ tiaa lupao Yesu pa꞉ta꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Eki peaano hone pa꞉la꞉pe leekeme. Mo leke holupiki halima꞉ ipiki pa꞉ta꞉ alota꞉ Tekehalio. Ya leke yaapo ki laae leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Neke pue. Naka꞉ hone tulaasa꞉ ekima꞉ epeaasa꞉me leekeme. Kutupa koto kone ipika꞉ leke yaapo epeeketa꞉ Yesuna꞉ hoki nane teli mea peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Diutuseleme da teke pa꞉ta꞉ pulu hata꞉ Betepeisi Bedani da yaapo pa꞉ta꞉ opolo pemekeme. Mo da yaapota꞉ mo Olipi ti polu haemeke peiyenena꞉ hayekeme. Kutupa Yesuma꞉ ipika꞉ disaipolo hali yaapo tapaaso hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Mo koto nane hala꞉ da pa꞉ta꞉ puaata꞉ da opolo pulu hata꞉ kuta kone donki ma꞉na꞉na꞉ panake donkisiki homeke wakapena꞉ endia haena꞉ handilipipikie leekeme. Koto donki ma꞉na꞉siki ma꞉nda꞉ma꞉ ipika꞉ hokina꞉ amba꞉ na pita handeke donkie laa Wakapa꞉ hola꞉ mea a꞉pa꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma꞉nda꞉ma꞉ ipiliki pa꞉ta꞉ Ekipeke pitelepepe lea꞉ka꞉na꞉ta꞉ dupa lapa꞉peke. Tekehalima꞉ muluekema꞉ hone pa꞉la꞉me lapa꞉peke. Wetepena꞉ kuta kone ma꞉nda꞉ma꞉ paa mea epena꞉ lelieke lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Koto leeke puaata꞉ mo donki ma꞉na꞉ pota꞉ kake pa꞉ta꞉ endia lepolo pota꞉na꞉ haena꞉ handa꞉ wiaata꞉ kelepa꞉ mipikime. ");
INSERT INTO ssx_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ka꞉la꞉paaso haena꞉ta꞉ koto alena꞉ haemeke haliwekima꞉ hololo haena꞉ ipiliki pa꞉ta꞉ alota꞉ Mo donkisiki kelepelepe ekita꞉ eki puluekema꞉ kelepelepepe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kota꞉ Yesuma꞉ leeke ekita꞉ mo haliweki pa꞉ta꞉ lepekeme. Leeke ekita꞉ opuaata꞉ mo haliwekima꞉ pa꞉na꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yesu pa꞉ta꞉ mea pepeketa꞉ ika꞉ daumanu mea mo donki sikina꞉ hokina꞉ yamaemeketa꞉ Yesu manda a꞉meiya pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wanda꞉hali wopuma꞉ ika꞉ daumanu lepolona꞉ yamoma꞉ yamoma꞉ pimikime. Kutupa mandane wanda꞉halima꞉ katake mendia wiki ti palekemanu tondopa꞉ mea yamoma꞉ yamoma꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Titina꞉ pemeke wanda꞉halima꞉ make wetepena꞉ pemeke wanda꞉halima꞉ tonka꞉na꞉ wi la alu alu pitolo alota꞉ Hosa꞉na꞉e. Ta꞉na꞉e. Tekehalina꞉ bikina꞉ ipula꞉ halita꞉ Koda꞉ma꞉ ipika꞉ pi laena꞉e laa ");
INSERT INTO ssx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nika꞉ apa꞉ Deipidi ipika꞉ kilu tombuao hala꞉eki ipula꞉ ekina꞉ ipika꞉ pi lamana꞉e. Hepeni nane Hosa꞉na꞉ pi lamana꞉e. Koda꞉na꞉ biki a꞉meiyaomana꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesuma꞉ Diutuseleme da opolo pua tembolo da tukiki pa꞉ta꞉ honda꞉ pambaata꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao handoma꞉ handoma꞉ peaata꞉ nate amba꞉ paeyeke handaata꞉ timba꞉ lapeke yeeke mo disaipolo haliweki ame̱le̱ Bedani da nane pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kutupa da ka꞉la꞉peeke haena꞉ta꞉ mo Bedani da mina꞉pa꞉lao paa la꞉ka꞉la ipulu hata꞉ Yesuma꞉ tea꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Pota꞉na꞉ puaata꞉ nose ti homeke katake mendia wieke ekina꞉ mopate leke hata꞉ handaata꞉ kiliki a꞉ela꞉patema꞉ handolo peekepate teke pa꞉ta꞉ opolo puaata꞉ pa katakemanu homeke handeekeme. Mo nose kiliki a꞉eya꞉peke nate a̱i̱ dia꞉yeke piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kutupa Yesuma꞉ mo nose pa꞉ta꞉ alota꞉ Naka꞉ kilikimanu ma꞉nda꞉ma꞉ na talo nelieke leekeme. Ipika꞉ disaipolo haliwekima꞉ koto leeke pita꞉ opimikime. ");
INSERT INTO ssx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Diutuseleme da pa꞉ta꞉ opolo puaata꞉ Yesuma꞉ mo tembolo da honda꞉ pambaata꞉ koto da pa꞉ta꞉ sipisipi ma꞉na꞉manu hambo haemeke haliweki hama꞉ nane tolu liaata꞉ mo mani topo pu haemeke haliwekina꞉ teipolomanu make melipu bamanu hambo haemeke haliwekina꞉ pitieke alemanu hoila꞉mina꞉ lopaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kutupa ipikana꞉ma꞉ ma꞉nda꞉ma꞉ ala꞉ta꞉ ala꞉ta꞉ mo tembolo da puku toka꞉la꞉ mea tia yopua꞉tiki peaama꞉na꞉ sa꞉sa꞉ pitolo leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kutupieke ipikana꞉ma꞉ pi wala iki pa꞉ta꞉ alota꞉ Mo Baibolona꞉ wape pea ula꞉ pita꞉ Koda꞉ma꞉ alota꞉ Yaka data꞉ kenke paeyao wanda꞉hali paeyaoma꞉ yeni pu halo pa꞉la꞉ da hala꞉me laa wape pa ula꞉pate ikana꞉ma꞉ta꞉ do data꞉ pake no pamboloendi piteleme da haena꞉ alememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wanda꞉hali wopuma꞉ Yesuna꞉ waleeke pimanu opuaata꞉ penkili pimiki handaata꞉ mo yeni peao haemeke you haliwekima꞉ make mo wape pea wala꞉tiki pu haemeke haliwekima꞉ make Yesu pa꞉ta꞉ paala꞉ma꞉ homolo hata꞉ ipiki lu alu palo pimiki pota꞉ weimikime. ");
INSERT INTO ssx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kutupa nate pambolo haena꞉ Yesu ipika꞉ disaipolo haliweki ame̱le̱ teke da mina꞉pa꞉lao pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Da ka꞉la꞉peketa꞉ pota꞉na꞉ yopulu hata꞉ hande nose ti handemekepate katake teke tonka꞉na꞉ paeyao hapua hayekeeki handemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pidama꞉ hone wia ipiki pa꞉ta꞉ alota꞉ Tekehalio. Handa꞉e. Nakana꞉ma꞉ pima꞉ kone hoeyaeye nose ti koto hapua hala꞉ handa꞉e leeketa꞉ ");
INSERT INTO ssx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Koda꞉ pa꞉ta꞉ hone tulao hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iki pa꞉ta꞉ ota꞉ pi alome. Hali epima꞉ oli pote pa꞉ta꞉ alota꞉ Naka꞉ kone tiao mo dawala pa꞉ta꞉ pua lopa꞉peke lea꞉ka꞉na꞉ta꞉ ipika꞉ puki pa꞉ta꞉ hone ti na yokeke pa ipika꞉ dupilieke leeke pi manuta꞉ ota꞉ pilieke laa homeke hone witolo hata꞉ lea꞉ka꞉na꞉ta꞉ mo hali pa꞉ta꞉ ota꞉ pina꞉ lelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Koto ekina꞉ iki pa꞉ta꞉ alome. Ala꞉ta꞉ ma꞉nda꞉na꞉ yeni pitolo hata꞉ honke lemeka꞉na꞉ta꞉ kota꞉ Amba꞉ mea wia halome hone wia hata꞉ milimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kutupa make Koda꞉ pa꞉ta꞉ tiao hata꞉ yeni pimika꞉na꞉ta꞉ ma꞉nda꞉ma꞉ iki pa꞉ta꞉ hoke hau pa꞉la꞉eki pa꞉ta꞉ hone pa upaleke hata꞉ pimika꞉na꞉ta꞉ kota꞉ ipika꞉ hoke hau tombuao pa paeyaapa꞉peke leekeme. Ika꞉ hepeni nane hala꞉ Apa꞉ma꞉ ika꞉ hoke hau paeyaena꞉yeke ma꞉nda꞉ma꞉ iki pa꞉ta꞉ hoke hau pa꞉la꞉eki paeyaapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ikana꞉ma꞉ ma꞉nda꞉ma꞉ pa꞉la꞉eki na paeyaemeka꞉na꞉ta꞉ ika꞉ hepeni nane hala꞉ Apa꞉ma꞉ ika꞉eki make na paeyaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu ipika꞉ disaipolo haliweki ame̱le̱ Diutuseleme da nane paa puaata꞉ tembolo da tukiki pa꞉ta꞉ pulu haena꞉ mo yeni peao haemeke you haliwekima꞉ make mo wape pea wala꞉tiki pu haemeke haliwekima꞉ make tondiki haliwekima꞉ make paeyaoma꞉ ipiki pa꞉ta꞉ pua alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Hande pu haleeki manuta꞉ ekipa pipe o epima꞉ neke wele peaeya꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ I̱ma꞉ iki pa꞉ta꞉ lota꞉ pitolo pi ma꞉nda꞉ opua la kimika꞉na꞉ta꞉ kota꞉ I̱ma꞉ pu halo hau manuta꞉ I̱ wele peao hala꞉ halina꞉ biki la kulueke. ");
INSERT INTO ssx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Dionima꞉ bapitaisi peao haya꞉ hauta꞉ hepeni nane ekipe o kenke wanda꞉halina꞉ ekipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Koto pi opuaata꞉ mo haliwekima꞉ ika꞉ ika꞉ kone pi lemekeme dupa. Hepeni nane ekie loma꞉ka꞉na꞉ta꞉ niki pa꞉ta꞉ Kota꞉ Dionima꞉ lo haya꞉ pi manuta꞉ ekipeke na miniki haemepe lelieke laa ");
INSERT INTO ssx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kenke wanda꞉halina꞉ ekie loluma꞉pe lemekepate wanda꞉hali paeyaoma꞉ Dionita꞉ Koda꞉ ipika꞉ pi la꞉ mea halo haya꞉ halie lo halemeke handaa mo wanda꞉hali pa꞉ta꞉ paala꞉ma꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Koto ekina꞉ mo haliwekima꞉ Yesu pa꞉ta꞉ alota꞉ Niki na handoloma꞉me lemekeme. Kutupa Yesuma꞉ iki pa꞉ta꞉ alota꞉ I̱ma꞉ make yaka pu halo haumanu I̱ wele peao hala꞉ halina꞉ bikita꞉ iki na la kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Koto laa Yesuma꞉ onkoluma꞉ laa iki pa꞉ta꞉ alota꞉ Hali ma꞉nda꞉ma꞉ waini e pokaata꞉ pape pea mo waini kilikimanu dikili pulu pieke alena꞉ kenke awaata꞉ ti hokulu mea a꞉meiyao noka꞉pa oli manda hata꞉ e handeteke haena꞉ da a꞉eyekeme. Dupa pea ipika꞉ e pokaaseme haliweki mea haena꞉ laata꞉ kenke ma꞉nda꞉ nane peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Bapina꞉ mo e teke halima꞉ ipika꞉ e pokaasa꞉ hali ma꞉nda꞉ hande e pokao haemeke haliweki pa꞉ta꞉ kilikimanu mandaneeki meaena꞉yeke tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Koto haliwekima꞉ mo e pokaasa꞉ hali meaata꞉ yombua bao kiki hameke tapaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kutupa e teke halima꞉ e pokaasa꞉ hali ma꞉nda꞉ tapaeyekepate mo haliwekima꞉ koto somena꞉ amboke yombua baota꞉ hoke tupa꞉ yaala꞉ tieke homaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","E teke halima꞉ paa ma꞉nda꞉ tapaeyekepate ota꞉ limikime. Koto haliwekima꞉ mandaneeki wopu pa꞉ta꞉ make kutu pimikime. Mandane ekimanu yombua baota꞉ mandane ekimanu ota꞉ limikime. ");
INSERT INTO ssx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mo e teke hali yaapota꞉ homeketa꞉ pa hayekeme. Ipika꞉ puki piki weki homeke pa hayekeme. Paeyaaso hata꞉ mo haliweki pa꞉ta꞉ ipika꞉ eiyeke tapaaso hata꞉ alota꞉ Yaka wekina꞉ pi opua homu pea halimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Koto leekepate mo e pokao haemeke haliwekima꞉ ika꞉ ika꞉ kone alota꞉ Dota꞉ e teke halina꞉ anke teke mulu pa꞉la꞉ halina꞉ alema꞉ Lumana꞉ bape lemekeme. Kutupa ipika꞉ mulu pa꞉la꞉ ekita꞉ nikana꞉ma꞉ mumana꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kutupa mo hande halina꞉ eiyeke mea ota꞉ liaata꞉ ipika꞉ loke mo e tikene nane mea baemekeme leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesuma꞉ alota꞉ Mo e teke halima꞉ eki pilia꞉pe laa Ipikana꞉ma꞉ a꞉paata꞉ mo e pokao haemeke haliweki ota꞉ lia paeyaota꞉ mandane haliwekima꞉ta꞉ ipika꞉ e pokao haena꞉ lelieke laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kota꞉ mo Baibolo bukana꞉ wape pea ula꞉ pi do ekita꞉ na yata꞉pelemepe. Mo da a꞉eyo haemeke haliwekima꞉ baemeke toopita꞉ da keneme nane ota꞉ teke toopi ula꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kutu pia꞉ ekita꞉ Tekehalima꞉ pia꞉me. Kutupa nikana꞉ma꞉ handaata꞉ penkili poloma꞉me laa wape pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mo hande yeni peao haemeke teke haliwekima꞉ make mo wape pea wala꞉tiki pu haemeke haliwekima꞉ make tondiki haliwekima꞉ make paeyaoma꞉ do onkoluma꞉ pita꞉ niki pa꞉ta꞉ lea꞉me hone witolo hata꞉ Yesu minina꞉ loluekema꞉ taapemekepate wanda꞉hali pa꞉ta꞉ paala꞉ma꞉ homemeke handaata꞉ Yesu mina꞉pa꞉lao pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pate ikana꞉ma꞉ mandane Pa꞉tisi haliweki make Hetodina꞉ hoki nane telimiki haliweki make Yesuna꞉ pi ta molo pena꞉ Yesu pa꞉ta꞉ tapaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ikana꞉ma꞉ ipiki pa꞉ta꞉ a꞉pa alota꞉ Wala꞉la꞉ Halio. Nakana꞉ma꞉ ota꞉ pimanu lo hale halie. Nikana꞉ma꞉ opoloma꞉me lemekeme. Nakana꞉ma꞉ wanda꞉hali pa꞉ta꞉ hone ma꞉nda꞉ ma꞉nda꞉ na u haleme. Nakana꞉ma꞉ wanda꞉hali paeyao pa꞉ta꞉ mandake hau piki wanda꞉halie laaka꞉na꞉ Koda꞉na꞉ ota꞉ hau pita꞉la꞉ pi homeke walo haleme la alota꞉ Mo Kapomani tieke Sisa pa꞉ta꞉ dakisi mani hala꞉la꞉ ekita꞉ a꞉pa꞉la꞉pe o hoela꞉pe. Mani halomonope o na halomonope laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Koto lemeketa꞉ Yesuma꞉ ika꞉ kekeke haemekeeki handolo hata꞉ alota꞉ Ikana꞉ma꞉ ya anke ekipeke yola꞉lemepe leekeme. Toopi poeke homeke handono mea ipupe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Homeke mea a꞉pa haena꞉ Yesuma꞉ iki pa꞉ta꞉ alota꞉ Koto su̱a̱ su̱a̱ ula꞉ ekita꞉ epina꞉ leke popelekepe leekeme. Ikana꞉ma꞉ ipika꞉ pi hombo peaaso alota꞉ Sisana꞉ ekie lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Sisana꞉ ale manuta꞉ Sisa pa꞉ta꞉ pa mea hala꞉pa꞉peke. Kutupa Koda꞉na꞉ ale manuta꞉ kota꞉ Koda꞉ pa꞉ta꞉ pa hala꞉pa꞉peke leekeme. Mo haliwekima꞉ koto pi opuaata꞉ penkili pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mandane Sa꞉dusi haliweki Yesu pa꞉ta꞉ epemekeme. Koto tapakema꞉ ota꞉ homemeke wanda꞉hali paa na tiaalieke lo haemeke haliwekie. Ikana꞉ma꞉ Yesu pa꞉ta꞉ a꞉pa lota꞉ pitolo alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Wala꞉la꞉ Halio. Mosesima꞉ niki pa꞉ta꞉ dupa wape piekeme. Hali ma꞉nda꞉ma꞉ ipika꞉ mupeke hameketa꞉ wanda꞉ pa haena꞉ weki wandiki na mendiki homea꞉ka꞉na꞉ta꞉ kota꞉ koto wetepe nane halima꞉ wanda꞉ kosa꞉piki meaata꞉ ipika꞉ homeeke hamekena꞉ weki wandikimanu mendiao haena꞉ lena꞉ lapa꞉peke wape piekeme leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kutupata꞉ hameketiti watake hata꞉ haemekeme. Mupeke wekima꞉ wanda꞉ meaata꞉ weki wandiki na mendiki homeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kutupa hoki nane wekima꞉ mo wanda꞉ meaata꞉ weki wandiki na mendiki homeekeme. Kutupa koto hoki nane weki ma꞉nda꞉ma꞉ kutu piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Watake hata꞉ hama̱la̱꞉ hama̱la̱꞉ paeyaoma꞉ koto tupa꞉ miekepate mo wanda꞉ pa haena꞉ weki wandiki na mendiki pa haena꞉ homeke homeke lo homemekeme. Kutupa homo paeyaeyeke naneta꞉ mo hande wanda꞉ make homeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kutupa wanda꞉hali paa tialimi natena꞉ta꞉ ota꞉ epina꞉ wanda꞉ haliepe. Pa ekipeke mo watake hata꞉ haliwekima꞉ta꞉ mo wanda꞉ homeke kone mimikime lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Ikana꞉ma꞉ pi lo hoeyaasememe. Pa ekipeke mo Baibolo bukana꞉ wape pea ula꞉ ekimanu na handelememe. Kutupa Koda꞉na꞉ wele pu hala꞉ ekimanu make na handelememe. ");
INSERT INTO ssx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Amba꞉ homemeke wanda꞉halima꞉ paa tiaemeka꞉na꞉ta꞉ wanda꞉ na miki hali na peke oli hepeni nane enisolo tapake haleme tupa꞉ pa hao halimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kutupa Yesuma꞉ pi ma꞉nda꞉ alota꞉ Mo hande homemeke wanda꞉hali paa tiaalo pelemeeki pa꞉ta꞉ alome dupa. Mosesima꞉ wape pieke bukana꞉ mo hande pa hayeke ti sikina꞉ kone ti to hayekeeki na yata꞉pemepe. Do mana꞉ta꞉ Koda꞉ma꞉ Mosesi pa꞉ta꞉ leekeme dupa. I̱ta꞉ Eipoloha꞉ma꞉na꞉ Koda꞉ make Aisa꞉kena꞉ Koda꞉ make Dieikopena꞉ Koda꞉ make halome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kutupa Yesuma꞉ alota꞉ Do lea꞉ ekina꞉ kota꞉ Koda꞉ta꞉ homolo peleme wanda꞉halina꞉ Koda꞉ dia꞉me. Deto halo peleme wanda꞉halina꞉ Koda꞉e laa la꞉la꞉pate ikana꞉ma꞉ hone u hoeyaasememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kutupa mo wape pea wala꞉tiki pu hayeke hali homekema꞉ a꞉paata꞉ ika꞉ pi pi lemekeeki opitolo hata꞉ Yesuma꞉ ika꞉ pi epeke tupa꞉ hombo peaaso leekeeki opuaata꞉ Yesu pa꞉ta꞉ lota꞉ pitolo alota꞉ Mo hande pi ula꞉eki manuta꞉ titina꞉ ekita꞉ handoekipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Titina꞉eki doe. Isulai wanda꞉halio. Opua꞉pe la꞉la꞉me. Tekehali Koda꞉ta꞉ nika꞉ Tekehali homeke hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kutupa mo Tekehali naka꞉ Koda꞉ pa꞉ta꞉ naka꞉ puki paeyaoma꞉ make naka꞉ temoko paeyaoma꞉ make naka꞉ hone witeleeki paeyaoma꞉ make naka꞉ honkopu haseeki paeyaoma꞉ make pukima꞉ homo hapa꞉pekee la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wetepena꞉eki doe. Neke pa꞉ta꞉ naka꞉ kone a꞉ta꞉ma꞉ homele tupa꞉ da wanda꞉hali pa꞉ta꞉ make a꞉ta꞉ma꞉ homo hapa꞉pekee la꞉la꞉me laa koto hande pi ula꞉eki yaapota꞉ ota꞉ titina꞉ekie. Mandaneeki manuta꞉ wetepena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kutupa mo wape pea wala꞉tiki pu hayeke halima꞉ Yesu pa꞉ta꞉ alota꞉ Wala꞉la꞉ Halio. Ota꞉ aleme. Koda꞉ homeke hala꞉ ekita꞉ ota꞉ leme. Ma꞉nda꞉ dia꞉me ipiki homekee. ");
INSERT INTO ssx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kutupa Koda꞉ pa꞉ta꞉ puki paeyaoma꞉ make hone wita꞉la꞉eki paeyaoma꞉ make honkopu hasa꞉eki paeyaoma꞉ make a꞉ta꞉ma꞉ homa꞉pa꞉peke. Kutupa nikana꞉ma꞉ niki pa꞉ta꞉ niki kone a꞉ta꞉ma꞉ homoloma꞉ tupa꞉ da wanda꞉hali pa꞉ta꞉ kone a꞉ta꞉ma꞉ homa꞉la꞉ ekita꞉ ota꞉ titina꞉ekie leekeme. Koda꞉ pa꞉ta꞉ yanka hala꞉la꞉ ekimanu paeyao make liaa hala꞉la꞉ ekimanu make koto ekita꞉ wetepena꞉ekie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kutupa Yesuma꞉ mo halina꞉ hone wopu wia epeke tupa꞉ leekeeki opuaata꞉ ipiki pa꞉ta꞉ alota꞉ Nakana꞉ma꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki teke pa꞉ta꞉ haleme leekeme. Koto lea꞉eki hoki naneta꞉ wanda꞉halima꞉ paala꞉ pieke handaa ma꞉nda꞉ma꞉ lota꞉ paa na piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuma꞉ mo tembolo da tukiki pa꞉ta꞉ hata꞉ pi walolo hata꞉ alota꞉ Wape pea wala꞉tiki pu haleme haliwekima꞉ Ketisota꞉ Deipidina꞉ tapake wekie la꞉la꞉ ekita꞉ ekipa la꞉la꞉pe laa ");
INSERT INTO ssx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Deipidima꞉ ipika꞉ kone alota꞉ Holi Sipitidima꞉ la halolo haena꞉ alota꞉ Mo Tekehalima꞉ yaka Tekehali pa꞉ta꞉ leekeeki dupa. Naka꞉ a꞉nda꞉ tunkuliki haliweki naka꞉ anke oto pa꞉ta꞉ mea pitaanoyeke yaka popeke nane kikina꞉ pita꞉peke la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kota꞉ Deipidima꞉ ipika꞉ kone Ketiso pa꞉ta꞉ Yaka Tekehalie la꞉la꞉me. Koto ekina꞉ ipika꞉ tapake wekita꞉ ekipa haliepe leekeme. Mo wanda꞉hali wopuna꞉ Yesuna꞉ pi ta꞉na꞉ma꞉ homa opimikime. ");
INSERT INTO ssx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ipikana꞉ma꞉ iki pa꞉ta꞉ pi walolo hata꞉ alota꞉ Mo wape pea wala꞉tiki pu haleme haliwekina꞉ hau wotu handeteke hapa꞉peke leekeme. Hokulupiki daumanu pambao pomu hata꞉ta꞉ makedina꞉ hatiki pita꞉la꞉ wanda꞉halima꞉ iki pa꞉ta꞉ pi la halena꞉ hone u halememe. ");
INSERT INTO ssx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kutupa pi hotu haemeke damanu tukiki pa꞉ta꞉ pituluekema꞉ wanda꞉halima꞉ iki handena꞉ hone wia epeke sea manuna꞉ pitu halememe. Ne pambaasa꞉ ekina꞉ make epeke haupiki seana꞉ pituluekema꞉ hone u halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kutupa kosa꞉piki wanda꞉wekina꞉ ala꞉ta꞉ ala꞉ta꞉ pa meaata꞉ kutu pitolo kone handaena꞉ hau puluekema꞉ yeni pu hokulu peao halememe leekeme. Mo haliwekima꞉ ika꞉ hoke yenkita꞉ ota꞉ tieke milimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesuma꞉ta꞉ mani pambo haemeke bokosi teke pa꞉ta꞉ ti lao pita꞉ wanda꞉halima꞉ koto pa꞉ta꞉ a꞉pa mani lopaemekeeki handeekeme. Hamoko wanda꞉hali wopuma꞉ mani wopu mea a꞉pa lopaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Wetepena꞉ natehali kosa꞉piki wanda꞉ sikima꞉ a꞉paata꞉ manisiki yaapo 2 toeama꞉ handekeeki mea a꞉pa lopaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kutupa Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ epena꞉ wi la꞉ mepi pea iki pa꞉ta꞉ alota꞉ Iki pa꞉ta꞉ ota꞉ pi alome. Do natehali kosa꞉piki wanda꞉ sikima꞉ mea a꞉pa lopaeya꞉ eki sikita꞉ tiekee. Mo mea a꞉pa lopaaseme wanda꞉hali paeyaona꞉ ekita꞉ hosiki alesikie. ");
INSERT INTO ssx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wanda꞉hali paeyaoma꞉ ika꞉ mani tieke putupu mea putupiliki wimiki ekimanu mea lopaememe. Kutu pimikipate do wanda꞉ma꞉ ipika꞉ natehali hata꞉ ipika꞉ wia꞉ hayekeeki paeyao mea lopaeya꞉me leekeme. Ipika꞉ ne hamba꞉pekeeki kone mea lopaeya꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesuma꞉ mo tembolo da mina꞉pa꞉lao hama꞉ nane opolu baaso haena꞉ ipika꞉ disaipolo hali homekema꞉ ipiki pa꞉ta꞉ alota꞉ Wala꞉la꞉ Halio. Handa꞉e. Do toopimanu tieke tiekee leekeme. Do da tiekemanu make seliapo seliapoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Do da tiekemanu handelepe. Toopi manda ma꞉nda꞉ na tapa꞉ pelia hata꞉ paeyao ota꞉ lopilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesuta꞉ oli Olipi ti polu peiyene pa꞉ta꞉ mo tembolo da handa꞉moneao pitina꞉ Pida Dia꞉mesi Dioni A꞉ndutu make ika꞉ honumake sikima꞉ Yesu pa꞉ta꞉ lota꞉ pea alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","La kie lemekeme. Hande le ekita꞉ handima꞉ ipiliepe laa lota꞉ pimikime. Kutupa ipuluekema꞉ haena꞉ eki hau pulu pa꞉la꞉eki handuluma꞉pe laa lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesuma꞉ iki pa꞉ta꞉ la halolo hata꞉ alota꞉ Wotu handeteke hapa꞉peke. Hali ma꞉nda꞉ma꞉ iki hatuku pu hoeyaama꞉na꞉ handeteke hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Haliweki wopuma꞉ yaka biki alo hata꞉ alota꞉ I̱ta꞉ Ketisoe lelimikie. Kutupa wanda꞉hali wopu hatuku pu hoeyaalimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Teke pa꞉ta꞉ make papate make a꞉nda꞉ pitelememe pi opimika꞉na꞉ta꞉ paala꞉ma꞉ na homa꞉pa꞉peke. Kutu pulu pelemepate paelo pa꞉la꞉ nateta꞉ a̱i̱ dia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Koto ekina꞉ kenke homeke wanda꞉halima꞉ tiaota꞉ kenke ma꞉nda꞉ wanda꞉hali pa꞉ta꞉ a꞉nda꞉ pilimikie. Na꞉sinolo Kapomani homekena꞉ wanda꞉halima꞉ tiaota꞉ Na꞉sinolo Kapomani ma꞉nda꞉ pa꞉ta꞉ a꞉nda꞉ pilimikie leekeme. Yu kenke ta꞉ta꞉ ta꞉ta꞉ pa꞉ta꞉manu yu momeni wotu pilimikie. Kutupa da ma꞉nda꞉ nane da ma꞉nda꞉ nane halo peleme wanda꞉hali pa꞉ta꞉ tea꞉ ki ipilieke leekeme. Kutupulu pelemeeki manuta꞉ tandama꞉ homolo peleme ekita꞉ kini pu milimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Koto ekina꞉ta꞉ ika꞉ kone wotu handeteke hapa꞉peke. Pa ekipeke wanda꞉halima꞉ iki mo pi yokaalu pulu pa꞉la꞉ haliweki pa꞉ta꞉ mea hatuku pelimikie. Pi hotu hala꞉ damanu tukiki pa꞉ta꞉ iki yombu mea baalimikie. Kutupa yaka bikina꞉ kapomani you halimanu pa꞉ta꞉ make Kini haliweki pa꞉ta꞉ make hata꞉ ika꞉ pu halemekeeki la halimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kutu puluekema꞉ haena꞉ titina꞉ amba꞉la mandane wanda꞉halima꞉ mo hande Pi Seliapo kenke ma꞉nda꞉ kenke ma꞉nda꞉ wanda꞉hali paeyao pa꞉ta꞉ walimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kutupa pi yokaalu puluekema꞉ iki mea hatuku pemeka꞉na꞉ta꞉ kota꞉ ika꞉ lolo peleme pi amba꞉la hone bao hapa꞉peke. Koto pita꞉ta꞉ Koda꞉ma꞉ la kia꞉ka꞉na꞉ta꞉ kotoeki lapa꞉peke leekeme. Ika꞉ kone pi na lelimikie. Holi Sipitidima꞉ lawaalieke. ");
INSERT INTO ssx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kutupa hameke ma꞉nda꞉ma꞉ ipika꞉ kamesiki ota꞉ homena꞉ lelieke. Atekema꞉ make ipika꞉ weki kone ota꞉ homena꞉ laata꞉ weki wandiki tonuma꞉ make tiaota꞉ ika꞉ ateke inkiki yaapo ota꞉ homena꞉ lelimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yaka biki menelemeke handaa wanda꞉hali paeyaoma꞉ iki ota꞉ kiaalimikie. Kutu pilimipate hali epima꞉ kima꞉ na homeke paelo pa꞉la꞉ tombona꞉ opolo puaata꞉ deto hala꞉eki milieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Hoeyaapeke ya꞉la꞉ aleta꞉ mo hoke ale wia꞉peke na ya꞉la꞉ alena꞉ mea wia haena꞉ handemeka꞉na꞉ta꞉ Do pi yata꞉pa꞉la꞉ halima꞉ hone wina꞉e mo Diudia nane halo peleme wanda꞉halita꞉ mo potemanu pa꞉ta꞉ pindipa pena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Da holuna꞉ halia꞉ halima꞉ hola꞉pa꞉niao ala꞉ta꞉ ala꞉ta꞉ mea poluekema꞉ da tukiki pa꞉ta꞉ na honda꞉ pambena꞉e. ");
INSERT INTO ssx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ena꞉ halia꞉ halima꞉ ipika꞉ dau mea poluekema꞉ hoki na lekelena꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Weki pitiki wanda꞉weki make andu halimi wanda꞉weki make koto nate manuna꞉ta꞉ a꞉ta꞉e laata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","koto dina꞉ta꞉ mo kosa꞉ kina꞉ta꞉ na epena꞉yeke yeni pea꞉pa꞉peke leekeme. Koto nate manuna꞉ta꞉ ka꞉nda꞉ma꞉ homa꞉la꞉eki hone matekeeki ipilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ka꞉nda꞉ma꞉ homa꞉la꞉eki koto tupa꞉ amba꞉ na epeekeme. Koda꞉ma꞉ ala꞉ta꞉ ala꞉ta꞉ wepia haena꞉ la꞉la꞉ dina꞉ kini pa pua ame do make dia꞉me. Wetepena꞉ make ka꞉nda꞉ma꞉ homa꞉la꞉eki koto tupa꞉ na ipilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Koto natena꞉ wanda꞉hali paeyao homolo pelemepate Koda꞉ma꞉ koto natemanu tunkulina꞉ la꞉la꞉me. Pa ekipekepe. Ipika꞉ talopu ma꞉la꞉ wanda꞉hali pa꞉ta꞉ hone wiaata꞉ koto natemanu tunkulina꞉ la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Koto natena꞉ta꞉ ma꞉nda꞉ma꞉ iki pa꞉ta꞉ alota꞉ Handa꞉pe. Ketiso do ane hala꞉me o Handa꞉pe. Ketiso mo nane hala꞉me lea꞉ka꞉na꞉ta꞉ na opua꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yayapiki Ketiso haliweki make yayapiki potopede haliweki make a꞉paata꞉ iki penkilipulu peleme alemanu make wele pita꞉la꞉ ekimanu make walaata꞉ mo hande Koda꞉na꞉ talopu ma꞉la꞉ wanda꞉hali kone kutu pea꞉peke ya꞉ka꞉na꞉ta꞉ hatuku pu hoeyaaluekema꞉ walimikie. ");
INSERT INTO ssx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kutu pilimipate wotu handeteke hapa꞉peke. Epolo pa꞉la꞉ haumanu paeyao amba꞉ titina꞉ iki pa꞉ta꞉ la kua꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Koto nate manuna꞉ mo hande ka꞉nda꞉ma꞉ homolo pelemeeki hone matekeeki paeya꞉ka꞉na꞉ta꞉ wetepena꞉ oli nate make timba꞉ lo pambaata꞉ oli sumba꞉ make ipika꞉ pa̱a̱ na pilieke. ");
INSERT INTO ssx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Oli hombulanka꞉manu make ya nane hao honda꞉ pa pa pu lopa꞉tiki pilieke. Kutupa oli ya nane wele peaasa꞉ ekimanu la꞉ma꞉la꞉ma꞉ pupa wilimikie. ");
INSERT INTO ssx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Koto natena꞉ta꞉ Wanda꞉halina꞉ Eiyeketa꞉ koa tukiki pa꞉ta꞉ hata꞉ wele wotu pitolo hata꞉ make pa̱a̱ tieke pitolo hata꞉ make epolo pa꞉la꞉eki handilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ipikana꞉ma꞉ mo enisolomanu tapa tapa peaata꞉ Koda꞉ma꞉ talopu ma꞉la꞉ wanda꞉halita꞉ nate opa꞉la꞉ nane make nate pamba꞉la꞉ nane make oni nane make oli nane make paeyao pa꞉ta꞉ mea mombelaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nose tima꞉ pu hala꞉eki hone wia꞉pa꞉peke. Ipika꞉ paleke ada꞉ pea katake tindiki lia kelepea꞉ka꞉na꞉ta꞉ bapi ipuluekema꞉ pita꞉la꞉me hone u halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kutupa make hande loa꞉ alemanu ipula꞉eki handemeka꞉na꞉ta꞉ kota꞉ tekepa꞉ta꞉ ya꞉la꞉me laa pota꞉ kake pa꞉ta꞉ hande nate kone a꞉pa hala꞉me hone wia꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iki pa꞉ta꞉ ota꞉ pi alome. Do haleme wanda꞉halita꞉ paeyao na homeke halimi pita꞉ I̱ma꞉ loa꞉ alemanu paeyao amba꞉ ipilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Oli ya do kenke yaapota꞉ paelo pa꞉la꞉pate yaka pi lo haloeki manuta꞉ na paelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kutu piliepate hande loa꞉ nate epolo pa꞉la꞉ ekita꞉ ma꞉nda꞉ma꞉ na handa꞉la꞉me. Nate handopa꞉ta꞉ haena꞉ epolo pa꞉la꞉eki make ma꞉nda꞉ma꞉ na handa꞉la꞉me. Oli hepeni nane haleme enisolo tapakema꞉ make Eiyekema꞉ make na handelema꞉pate Atekema꞉ homeke handa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ikita꞉ u̱ na peliki yu wia hapa꞉peke. Mo epolo pa꞉la꞉ dita꞉ iki mateleme. ");
INSERT INTO ssx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Do tupa꞉e leekeme. Hali ma꞉nda꞉ma꞉ kimisu pea꞉ka꞉na꞉ta꞉ da mina꞉pa꞉lao ipika꞉ e pokaaseme haliwekima꞉ handeteke haena꞉ laa ika꞉ kaukata walaa tapa tapa pea kutupa pota꞉ kake handeteke hala꞉ halima꞉ wopu handeteke haena꞉ lelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Koto ekina꞉ handeteke hapa꞉peke. Hande da teke halina꞉ epolo pa꞉la꞉ dita꞉ iki mata꞉la꞉me. Timba꞉ timba꞉ alo haena꞉pe o buta꞉ hokina꞉pe o koka꞉la꞉ e̱ alo haena꞉pe o da ka꞉la꞉paaso nanepe. ");
INSERT INTO ssx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ikita꞉ u̱ peliolo hamina꞉ ipikita꞉ kutaa kone a꞉paama꞉na꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kutupa I̱ma꞉ iki pa꞉ta꞉ alo ekita꞉ wanda꞉hali paeyao pa꞉ta꞉ alome. Handeteke hapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Diu wanda꞉halima꞉ Lombei Pupa Yapeeke nate make Na Pombei Yaake Palaowa Nala꞉ di make hone uluekema꞉ ne pambaaluekema꞉ nate yaapo titina꞉ amba꞉la꞉ wiekeme. Kutupa mo yeni peao haemeke you haliwekima꞉ make wape pea wala꞉tiki pu haemeke haliwekima꞉ make Yesu a꞉mbao mina lu pimiki pota꞉ weimikime. ");
INSERT INTO ssx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ikana꞉ma꞉ alota꞉ Ne pambaaso haena꞉ta꞉ dia꞉me. Wanda꞉halima꞉ niki pa꞉ta꞉ mineke pankaapa꞉na꞉ lemekeme. Kutupa pota꞉ ma꞉nda꞉ weimikime. ");
INSERT INTO ssx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesuta꞉ Bedani da puaata꞉ kindi yeni hayeke hali Saimonona꞉ da pa꞉ta꞉ ne nalo pitina꞉ wanda꞉ ma꞉nda꞉ma꞉ a꞉la꞉ba꞉seta꞉ toopi kanake homeke mea epeekeme. Mo kanake pa꞉ta꞉ senisi totopo pikieki seliapo pambeekeme. Koto senisina꞉ bikita꞉ Nadae. Yenki tieke alee. Kutupa mo wanda꞉ma꞉ kanake yamba꞉la꞉ liaata꞉ hande senisita꞉ Yesuna꞉ youna꞉ holaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kutu piekepate mandane wanda꞉halima꞉ ika꞉ ika꞉ kone mineke pankolo hata꞉ alota꞉ Koto senisita꞉ ekipeke pa hameke hoeyaasa꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Do senisi ma꞉nda꞉ma꞉ hambea꞉ka꞉na꞉ yoluta꞉ 300 kina mea꞉peke yolo pia꞉me. Kutupa mo manita꞉ natehali wanda꞉hali pa꞉ta꞉ hala꞉peke yolo pia꞉me lemekeme. Kutupa mo wanda꞉ pa꞉ta꞉ hoke hone witolo hata꞉ tandapiki pi lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Koto lemekepate Yesuma꞉ alota꞉ Koto wanda꞉ pa꞉ta꞉ pi na leke mina꞉pa꞉lape. Pa ekipeke ipiki ka꞉nda꞉ma꞉ homaasemepe. Ipikana꞉ma꞉ I̱ pa꞉ta꞉ epeke hau pia꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Natehali wanda꞉halita꞉ nate paeyao iki ame̱le̱ hao halimikie. Kutupa ika꞉ hone pa꞉la꞉ natena꞉ epeke haumanu iki pa꞉ta꞉ pea꞉peke ya꞉la꞉pate I̱ta꞉ iki ame̱le̱ hoto paeyao na hao halueke. ");
INSERT INTO ssx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Do wanda꞉ma꞉ ipika꞉ pia꞉peke ya꞉la꞉eki pia꞉me. Yaka loke a̱i̱ na hoitelemepate ipikana꞉ma꞉ senisi amba꞉la꞉ holaeya꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kutupa iki pa꞉ta꞉ ota꞉ pi alome. Kenke paeyao pa꞉ta꞉ Pi Seliapo wala꞉tiki pimika꞉na꞉ta꞉ do wanda꞉ma꞉ I̱ pa꞉ta꞉ pia꞉ ekita꞉ ipiki pa꞉ta꞉ hone wina꞉yeke wala꞉tiki pilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kutupa Isekatioti hali Diudasima꞉ mo hande 12 haliweki hayeke halima꞉ kone Yesu lina꞉yeke a꞉nda꞉ lombuluekema꞉ mo yeni peao haemeke you haliweki pa꞉ta꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kutupa mo haliwekima꞉ ipika꞉ pi opuaata꞉ ta꞉na꞉ma꞉ homemekeme. Ipiki pa꞉ta꞉ mani haluekema꞉ pi la꞉ wimikime. Kutupa yeni peao haemeke teke haliwekima꞉ Yesu minina꞉yeke Diudasima꞉ pota꞉ weiyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na Pombei Yaake Palaowa Ne pambaeya꞉ pita꞉ titina꞉ natena꞉ Lombei Pupa Yapeeke natena꞉ sipisipi ikiki lu haemeke pita꞉ kone Yesuna꞉ disaipolo haliwekima꞉ ipiki pa꞉ta꞉ alota꞉ Lombei Pupa Yapeeke nate hone uelena꞉yeke ne pambaaluma꞉eki noelena꞉yeke hando pa꞉ta꞉ pua da wamo peamonope lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kutupa Yesuma꞉ ipika꞉ disaipolo hali yaapo tapaaso hata꞉ ipiliki pa꞉ta꞉ alota꞉ Mo daoni nane puaata꞉ hali ma꞉nda꞉ma꞉ ikali kanake homeke tia ipulu hata꞉ ipiliki manda꞉hande pilieke. Kutupa mo hali teli mea pua꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ipikana꞉ma꞉ da ma꞉nda꞉ pa꞉ta꞉ honda꞉ pamba pea꞉ka꞉na꞉ta꞉ ipilikana꞉ma꞉ koto da teke hali pa꞉ta꞉ dupa lapa꞉peke. Wala꞉la꞉ Halima꞉ alota꞉ Yaka disaipolo haliweki I̱ ame̱le̱ Lombei Pupa Yapeeke natena꞉ ne nolo poloma꞉ da panda꞉ hando pa꞉ta꞉pe lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kutupa ipikana꞉ma꞉ manda nane wamo pea ula꞉ da panda꞉ tieke walieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mo disaipolo hali yaapoma꞉ daoni nane puaata꞉ Yesuna꞉ leeke pita꞉ ota꞉ yaeyekeme. Kutupa mo hande Lombei Pupa Yapeeke natena꞉ ne hone uluekema꞉ ika꞉ ne wamo pipikime. ");
INSERT INTO ssx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Timba꞉ alo haena꞉ Yesu mandane 12 haliweki ame̱le̱ koto pa꞉ta꞉ opolo pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kutupa ne nalo pitina꞉ Yesuma꞉ alota꞉ Iki pa꞉ta꞉ ota꞉ pi alome. I̱ minina꞉yeke I̱ ame̱le̱ do ne nala꞉ hali homekema꞉ kone a꞉nda꞉ lomba꞉lieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Koto leeke handaa ikana꞉ma꞉ ka꞉nda꞉ma꞉ homolo hata꞉ ma꞉nda꞉ ma꞉nda꞉ma꞉ ipiki pa꞉ta꞉ I̱ma꞉pe la꞉tiki pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Iki 12 haliweki tukiki pa꞉ta꞉ homeke halima꞉ pilieke. I̱ma꞉ta꞉ palaowa tenke laaso metekina꞉ kone ipikana꞉ma꞉ make palaowa tenke laasa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wanda꞉halina꞉ Eiyeke pa꞉ta꞉ mo Baibolo bukana꞉ wape pa꞉la꞉ tupa꞉ homena꞉ a꞉ndu halimipate pa Wanda꞉halina꞉ Eiyeke minina꞉yeke a꞉nda꞉ lomba꞉la꞉ hali pa꞉ta꞉ta꞉ A꞉ta꞉e. Na mendia꞉ka꞉na꞉ yoluta꞉ epolo pia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ne nalo pitina꞉ Yesuma꞉ palaowa mea Koda꞉ pa꞉ta꞉ keiyae laa pindi pindi pea iki pa꞉ta꞉ hala alota꞉ Mipe. Dota꞉ ya loke mindikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kutupa kapo mea keiyae laaka꞉na꞉ iki pa꞉ta꞉ hale hale piekeme. Iki paeyaoma꞉ mo kapona꞉ nemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kutupa ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Pi la꞉ uluekema꞉ yaka we doe. Wanda꞉hali paeyao epeaaluekema꞉ yaka we lopilieke laa ");
INSERT INTO ssx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iki pa꞉ta꞉ ota꞉ pi alome. Do naloma꞉ waini ikali I̱ta꞉ paata꞉ na neke hao wetepena꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki pa꞉ta꞉ hata꞉ panakeeki nolueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ikana꞉ma꞉ emeli ma꞉nda꞉ laata꞉ mo Olipi Pote pa꞉ta꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kutupa Yesuma꞉ iki pa꞉ta꞉ alota꞉ Iki paeyaoma꞉ I̱ mina꞉pa꞉lalimikie. Mo Baibolo bukana꞉ wape pa꞉la꞉ ekita꞉ dupae. Sipisipi handeteke hao hala꞉ hali lueke. Kutupa mo sipisipi titi mandane mandane pindipa pomu keaalimikie wape pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kutu pilimipate I̱ paa mea tiaeya꞉ka꞉na꞉ta꞉ I̱ amba꞉la Ka꞉lili nane polueke. Ikita꞉ wetepena꞉ a꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Koto leeke Pidama꞉ ipiki pa꞉ta꞉ alota꞉ Wanda꞉hali paeyaoma꞉ neke mina꞉pa꞉laemeka꞉na꞉ta꞉ I̱ma꞉ta꞉ neke na mina꞉pa꞉lalueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Neke pa꞉ta꞉ ota꞉ pi alome. Ame timba kone koka꞉la꞉ma꞉ hoto yaapo peao e a̱i̱ na leke haena꞉ nakana꞉ma꞉ hoto tepo yaka biki amba꞉la hoeyaalipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Koto leekepate Pidama꞉ pi taka꞉lakema꞉ alota꞉ Diki mandakena꞉ homopono lea꞉ka꞉na꞉ kone naka꞉ biki na hoeyaalueke leekeme. Kutupa mo haliweki paeyaoma꞉ make koto tupa꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu make mo haliweki ame̱le̱ Kesema꞉ni e nane pemekeme. Kutupa ipikana꞉ma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ I̱ma꞉ Koda꞉ pa꞉ta꞉ yeni pulu pono ikita꞉ do pa꞉ta꞉ pita꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kutupa Yesuma꞉ Pida Dia꞉mesi Dioni ameda hatuku puaata꞉ koto kone ipika꞉ pukima꞉ ka꞉nda꞉ wopu miekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ I̱ta꞉ yaka pukima꞉ ka꞉nda꞉ma꞉ wopu homolome. Homeke nono pea halome. Ikita꞉ do pa꞉ta꞉ yu wia hata꞉ handeteke hapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kutupa hosiki mopate leke puaata꞉ kenkena꞉ peliniao yeni piekeme. Ipika꞉ yeni pieke ekita꞉ dupa piekeme. Ana꞉ pia꞉ka꞉na꞉ta꞉ do ka꞉nda꞉ pa꞉la꞉eki ipula꞉eki mone yaae laa yeni piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ipikana꞉ma꞉ alota꞉ Ya apa꞉o. Hau paeyao nakana꞉ma꞉ pea꞉peke ya꞉la꞉me. Do I̱ pa꞉ta꞉ ipula꞉ kapo I̱ pa꞉ta꞉ na epena꞉ lapeke. Kutu pea꞉peke ya꞉la꞉pate yaka hone pa꞉la꞉eki dia꞉me. Naka꞉ hone pa꞉la꞉eki homekee leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kutupa Yesuma꞉ paa la꞉ka꞉la a꞉paata꞉ mo haliweki u peliekeeki handaata꞉ ipikana꞉ma꞉ Pida pa꞉ta꞉ alota꞉ Saimonoo. Polu pili leekeme. Hosiki handeteke hapeke na ya꞉la꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Handeteke hata꞉ yeni pu hapa꞉peke. La handa꞉la꞉eki a꞉paama꞉na꞉ loa꞉me. Pukima꞉ hone pa꞉la꞉pate lokema꞉ soka꞉la꞉ma꞉ homa adaada꞉ pea wita꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kutupa paa pua yeni pitolo hata꞉ mo hande pimanu kone paa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Paa a꞉pa handeekepate ikita꞉ pelimikieki handeekeme. Ika꞉ leke pa꞉ta꞉ u pamba wimiki handaa pimikime. Kutupa ikana꞉ma꞉ Yesu pa꞉ta꞉ hombo peaaluekema꞉ pi ma꞉nda꞉ hone na wimikime. ");
INSERT INTO ssx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesuma꞉ hoto tepo peao a꞉pa iki pa꞉ta꞉ alota꞉ Ikita꞉ pa peliake u pita꞉ hoto pita꞉ pimi. Ana꞉e. Mo handa꞉e. A꞉nda꞉ lomba꞉la꞉ halima꞉ Wanda꞉halina꞉ Eiyeke I̱ta꞉ hoke hau pu haleme haliwekima꞉ minina꞉ a꞉nda꞉ lomba꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pomana꞉ tiaape. I̱ minina꞉ a꞉nda꞉ lomba꞉la꞉ hali koto ipula꞉ handa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Koto pi alo haena꞉ kone Diudasita꞉ mo hande 12 haliweki ame̱le̱ hayeke hali kone epeekeme. Kutupa Diudasi ame̱le̱ haliweki wopuma꞉ kepete tieke make dolo make miniki epemekeme. Mo yeni peao haemeke you haliwekima꞉ make mo wape pea wala꞉tiki pu haemeke haliwekima꞉ make mo tondiki haliwekima꞉ make tapaeyeke handaa epemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yesu minina꞉ a꞉nda꞉ lombeeke halima꞉ mo haliweki pa꞉ta꞉ patehau amba꞉ waleekeeki dupa. I̱ma꞉ nunu pulua꞉ halita꞉ ipikie. Koto hali da꞉ka꞉pa꞉ miniki hao hatuku mea pupe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kutupa Diudasima꞉ a꞉paata꞉ kutaa kone Yesu pa꞉ta꞉ pua ipiki pa꞉ta꞉ alota꞉ Tekehalio laa ipikana꞉ma꞉ Yesu nunu piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mo haliwekima꞉ nunu piekeeki handaata꞉ Yesu meaata꞉ da꞉ka꞉pa꞉ miniki haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kutu pimikipate koto pa꞉ta꞉ hayeke hali homekema꞉ ipika꞉ kepete poneke hokulu yola꞉ mea mo yeni peao haemeke haliwekina꞉ you halina꞉ e pa pokao hayeke hali pokeekepate katake tunkulu poka lopaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Ika꞉ honema꞉ta꞉ I̱ta꞉ pake hali patema꞉ kepete tieke dolo make miniki a꞉pa pimipe. ");
INSERT INTO ssx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nate wopu I̱ma꞉ta꞉ mo tembolo da tukiki pa꞉ta꞉ iki ame̱le̱ pi walo haowa꞉pate ikana꞉ma꞉ I̱ na da꞉ka꞉pa꞉ minimime. Kutu pimipate mo Baibolo bukama꞉ la꞉la꞉eki yaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kutupa disaipolo haliweki paeyaoma꞉ Yesu mina꞉pa꞉lao pindipa pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wekihali homekema꞉ta꞉ Yesu teli mea peekeme. Koto wekita꞉ pa dau homeke yameekeme. Kutupa haliwekima꞉ ipiki da꞉ka꞉pa꞉ miniki haemekepate ");
INSERT INTO ssx_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","hande dau leisi minolo haena꞉ loke homeke pindipa peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kutupa Yesu mo yeni peao haemeke you haliwekina꞉ you hali pa꞉ta꞉ hatuku pemekeme. Mo yeni peao haemeke haliweki make mo wape pea wala꞉tiki pu haemeke haliweki make mo tondiki haliweki make paeyao momba꞉la pitimikime. ");
INSERT INTO ssx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pidama꞉ Yesu mo pate leke teli mea peekeme. Kutupa mo yeni peao haemeke you haliwekina꞉ you halina꞉ da mandane mandane hao yapena꞉ tukikina꞉ pua pitiekeme. Ipika꞉ loke titipu pina꞉yeke mo do handeteke haemeke haliweki ame̱le̱ tina꞉ pitimikime. ");
INSERT INTO ssx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Yeni peao haemeke you haliweki make ka̱le̱sete haliweki paeyaoma꞉ make Yesu lu homaaluekema꞉ pota꞉ weimikipate ota꞉ na handa꞉ wimikime. ");
INSERT INTO ssx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mo la halemeke haliwekima꞉ yayapiki pi la halemeke handaata꞉ pi homeke na lemeke handaa na handa꞉ wimikime. ");
INSERT INTO ssx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kutupa mandane haliwekima꞉ tiao la halolo hata꞉ yayapiki pi alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Do halima꞉ta꞉ mo koto haliwekima꞉ a꞉emeke tembolo data꞉ I̱ma꞉ hoeyaalueke lea꞉eki opuma꞉me laa Nate tepo paeya꞉ka꞉na꞉ta꞉ haliwekima꞉ na a꞉elo pa꞉la꞉eki I̱ma꞉ a꞉elueke lea꞉eki opuma꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Koto lemekepate mo la halemeke haliwekima꞉ta꞉ pimanu alo hata꞉ homeke pi kone na lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kutupa yeni peao haemeke you haliwekina꞉ you halima꞉ tiao mo haliweki tukiki pa꞉ta꞉ hata꞉ Yesu pa꞉ta꞉ lota꞉ pea alota꞉ Pi ma꞉nda꞉ na lelipikipe. Koto haliwekima꞉ neke laaseme ekita꞉ eki hauna꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Koto leekepate Yesuma꞉ pi na honda꞉ mea leke pa hayekeme. Kutupa yeni peao haemeke you haliwekina꞉ you halima꞉ ipiki pa꞉ta꞉ paa lota꞉ pea alota꞉ Neketa꞉ Ketiso ya꞉ka꞉ta꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesuma꞉ alota꞉ I̱e. Kutupa iki paeyaoma꞉ mo hande Wanda꞉halina꞉ Eiyeketa꞉ mo Wele Pita꞉la꞉ Teke Halina꞉ popeke nane kikina꞉ pitilieeki handilimikie leekeme. Kutupa ya nane koa tukiki pa꞉ta꞉ hola꞉paniao ipilieeki handilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Do pi opuaata꞉ mo hande yeni peao haemeke you haliwekina꞉ you halima꞉ ipika꞉ daumanu sinki pea alota꞉ Ekipeke la kita꞉la꞉ haliweki ma꞉nda꞉ pa muluma꞉pe. ");
INSERT INTO ssx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Do Koda꞉ laasa꞉ pimanu opuma꞉me. Eki hau puluekema꞉ hone witelemepe leekeme. Mo haliweki paeyaoma꞉ alota꞉ Lu homamana꞉ pipe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kutupa mandane haliwekima꞉ ipika꞉ lokena꞉ dopi taata꞉ ipika꞉ leke popeleke a꞉mbao ipiki litolo hata꞉ alota꞉ Neke lia꞉ halina꞉ biki la kie lemekeme. Kutupa mo da handeteke haemeke haliwekima꞉ yombua baemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pidata꞉ oni da mandane mandane hao tukikina꞉ pitina꞉ mo yeni peao haemeke you haliwekina꞉ you halina꞉ e pokao hayeke wandiki ma꞉nda꞉ma꞉ a꞉paata꞉ ");
INSERT INTO ssx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pidama꞉ ipika꞉ loke titipu pina꞉ pitiekeeki handaa pa wopu handolo alota꞉ Neke make mo Na꞉sa꞉tete hali Yesu ame̱le̱ haepeme leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Koto leekepate Pidama꞉ alota꞉ I̱ dia꞉me. I̱ mata꞉la꞉me laata꞉ Nakana꞉ma꞉ le pita꞉ eki epina꞉ lepe. I̱ na handolome leekeme. Kutupa hama nane pua hayekeme. Koto kone koka꞉la꞉ma꞉ tiaaso hata꞉ e̱ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hande e pokao hayeke wandikima꞉ Pida handaata꞉ mo pambo haemeke haliweki pa꞉ta꞉ paa alota꞉ Koto halita꞉ ipika꞉ tapakee leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Koto leekepate Pidama꞉ paa alota꞉ I̱ dia꞉me leekeme. Hosiki hao wetepena꞉ mo hande pambo haemeke haliwekima꞉ Pida pa꞉ta꞉ paa alota꞉ Neketa꞉ ipika꞉ tapake halie. Neketa꞉ Ka꞉lili hali yeke handaa loma꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Koto lemekepate Pidama꞉ alota꞉ Koda꞉ma꞉ I̱ hoeyaena꞉ Koda꞉ma꞉ opitolo haena꞉ alome laata꞉ Ikana꞉ma꞉ aleme halita꞉ I̱ na handolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kutupa koto kone mo koka꞉la꞉ma꞉ hoto yaapo peao tiaaso hata꞉ e̱ leekeme. Kutupa Pidama꞉ Yesuma꞉ amba꞉ ipiki pa꞉ta꞉ leekeeki hone wiekeme. Mo koka꞉la꞉ma꞉ hoto yaapo peao a̱i̱ na leke haena꞉ kone hoto tepo ya biki a꞉mbao lo hoeyaalipikie leekeeki hone wiekeme. Kutupa Pidama꞉ koto leekeeki hone witolo hata꞉ e̱ wopu leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Da ka꞉la꞉paaso siki yeni peao haemeke you haliwekima꞉ make tondiki haliwekima꞉ make wape pea wala꞉tiki pu haemeke haliwekima꞉ make ka̱le̱sete haliweki paeyaoma꞉ make pi hotimikime. Kutupa mo haliwekima꞉ Yesu tonkao mea Pailedi pa꞉ta꞉ hatuku pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailedima꞉ Yesu pa꞉ta꞉ lota꞉ pitolo alota꞉ Neketa꞉ Diu wanda꞉halina꞉ kini hali halepe leekeme. Yesuma꞉ Pailedina꞉ pi hombo peaaso alota꞉ Koto aleme leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kutupa mo yeni peao haemeke you haliwekima꞉ kiki ma̱leke litolo Yesuna꞉ pieke ekimanu pa la꞉ mea tiaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailedima꞉ Yesu paa lota꞉ pitolo alota꞉ Pi ma꞉nda꞉ na lelipikipe. Naka꞉ hau pu hala꞉ ekimanu wopu pa꞉ta꞉ neke do la꞉ mea tiaaseme handa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Koto leekepate Yesuma꞉ pi ma꞉nda꞉ na leekeme. Koto ekina꞉ Pailedima꞉ penkili piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lombei Pupa Yapeeke natena꞉ ne pambao haemeke pita꞉ wanda꞉halina꞉ honke la꞉tiki pu haemeke tupa꞉ dipula pitieke hali homeke honke lemeketa꞉ da pena꞉ Pailedima꞉ tapatiki pu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Koto dina꞉ta꞉ haliweki mandane ekimanu dipula da pa꞉ta꞉ pitimikime. Koto haliwekima꞉ kapomani pa꞉ta꞉ a꞉nda꞉ limiki pita꞉ wanda꞉hali limikime. Kutupa iki ame̱le̱ hali homeke ipika꞉ bikita꞉ Batabasi pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wanda꞉hali paeyao wopuma꞉ momba꞉la hata꞉ Pailedi pa꞉ta꞉ a꞉pa honke alo hata꞉ alota꞉ Niki pa꞉ta꞉ peao hale tupa꞉ peae lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailedima꞉ iki pa꞉ta꞉ alota꞉ Ika꞉ honema꞉ta꞉ mo hande Diu wanda꞉halina꞉ Kini hali tapawanope leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ipika꞉ honema꞉ta꞉ yeni peao haemeke you haliwekima꞉ Yesu pa꞉ta꞉ honditi pitolo hata꞉ ipiki pa꞉ta꞉ mea hatuku epena꞉ lemeke ekita꞉ Pailedima꞉ hone wieke handaa leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Koto leekepate mo yeni peao haemeke you haliwekima꞉ta꞉ wanda꞉halima꞉ Yesu na tapake Batabasi tapawaena꞉ honke lape laa ti lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kutupa Pailedima꞉ iki pa꞉ta꞉ alota꞉ Diu wanda꞉halina꞉ Kini halie aleme halita꞉ eki peaanope leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Haliweki paeyaoma꞉ pa pi tanda pu alualu pitolo alota꞉ A꞉ka꞉tei wape piki tina꞉ homena꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailedima꞉ iki pa꞉ta꞉ alota꞉ Ekipekepe. Eki hau pa꞉la꞉pe leekepate pi pa daeyao tanda pitolo hata꞉ alota꞉ A꞉ka꞉tei wape piki tina꞉ homena꞉e lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Koto ekina꞉ Pailedima꞉ mo wanda꞉hali paeyaona꞉ hone pa꞉la꞉eki puluekema꞉ Batabasi da tapawaeyekeme. Kutupa Yesuta꞉ yombua baena꞉ laata꞉ haliwekima꞉ a꞉ka꞉tei wapepiki tina꞉ tamendiao homaena꞉yeke haliweki pa꞉ta꞉ Yesu mea haleekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dolo a꞉ndeli miniki haemeke haliwekima꞉ta꞉ mo Kapomani tiekena꞉ da hama tukiki pa꞉ta꞉ Yesu hatuku pemekeme. Koto da bikita꞉ Pa꞉totiomo dae. Kutupa mandane dolo a꞉ndeli miniki haemeke haliweki paeyao epena꞉ wi lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Haliwekima꞉ wepiki nono piki dau ma꞉nda꞉ meaata꞉ Yesuna꞉ lokena꞉ pambaemekeme. Kutupa tekeke hake alemanu meaata꞉ hopa꞉ hopa꞉ liao ipika꞉ youna꞉ pambaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kutupa kikima꞉ salusi pitolo hata꞉ alota꞉ Diu wanda꞉halina꞉ Kini halio. Hao hapekee lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kutupa doloma꞉ ipika꞉ you yumba꞉tiki pea ipiki pa꞉ta꞉ dopi taatiki peaata꞉ tumiki yotu hatiki pea ipiki pa꞉ta꞉ yayapiki hau pitolo hata꞉ panda꞉ puniatiki pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yesu makeao moneaota꞉ mo hande dau wepikieki hola꞉ meata꞉ ipika꞉ ota꞉ daumanu yamaemekeme. Kutupa a꞉ka꞉tei wapepiki tina꞉ tamendiao homaaluekema꞉ Yesu hama hatuku pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pota꞉na꞉ puaata꞉ hali ma꞉nda꞉ manda꞉hande pimikime. Mo halita꞉ Saitini da hali Saimonoe. Ipikita꞉ A꞉lekesa꞉nda Lupasi yaapo ipilika꞉ ateke hayekeme. Dolo a꞉ndeli miniki haemeke haliwekima꞉ mo hali meaata꞉ Yesuna꞉ a꞉ka꞉tei wape piki ti mea tiawaena꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kutupa ikana꞉ma꞉ Yesuta꞉ mo Kolokoda alena꞉ hatuku pemekeme. Hali you holikima꞉ handeke alena꞉e. Koto ekina꞉ Kolokoda lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Koto alena꞉ waini ikalita꞉ mo mulamula ale ma꞉nda꞉ taapuna꞉ apa꞉tao Yesu pa꞉ta꞉ halemekepate ipikana꞉ma꞉ kiao na neekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kutupa ikana꞉ma꞉ mo a꞉ka꞉tei wapepiki tina꞉ Yesu tamendiaota꞉ ipika꞉ daumanu telipuluekema꞉ haliwekima꞉ kase tupa꞉ peaata꞉ tombo wataeyeke halima꞉ ipika꞉ hone pa꞉la꞉ dau mia꞉tiki pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nate wenokona꞉ haena꞉ Yesu mo a꞉ka꞉tei wapepiki tina꞉ tamendiaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kutupa mo a꞉ka꞉tei wapepiki tina꞉ pi dupa wape piekeme. Diu wanda꞉halina꞉ Kini halie wape piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pake nepeke hali yaapo make Yesu ame̱le̱ a꞉ka꞉tei wapepiki tina꞉ tamendiaemekeme. Ma꞉nda꞉ta꞉ Yesuna꞉ popeke nane kikina꞉ ma꞉nda꞉ta꞉ ipika꞉ hoe nane kikina꞉ tamendiaemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kutu pimiki ekita꞉ mo Baibolo buka pa꞉ta꞉ wape pa꞉la꞉ pita꞉ ota꞉ yaeyekeme dupae. Mo pi wieke ekimanu yambelemeke haliweki ame̱le̱ hala꞉ halie hone wimikime wape pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pota꞉na꞉ lombei pupa pa pu yapemeke wanda꞉halima꞉ Yesu ki ta ta pu amboke wankeatiki pitolo alota꞉ Aha. Neketa꞉ mo hande tembolo da I̱ma꞉ hoeyao hoto tepona꞉ paa a꞉elueke le hande halipe. ");
INSERT INTO ssx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Naka꞉ kone da꞉ta mo a꞉ka꞉tei wapepiki tina꞉ hola꞉pa꞉niao epoe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kutupa mo yeni peao haemeke you haliwekima꞉ make mo wape pea wala꞉tiki pu haemeke haliweki ame̱le̱ ika꞉ ika꞉ kone Yesu kitaaso hata꞉ hande lemeke tupa꞉ alota꞉ Mandane wanda꞉hali da꞉tatiki piekepate ipikana꞉ma꞉ ipika꞉ kone da꞉taapeke na ya꞉la꞉me laata꞉ ipiki pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Neketa꞉ Isulai wanda꞉halina꞉ Kini hali hande Ketiso haekena꞉ta꞉ ota꞉ koto a꞉ka꞉tei wapepiki tina꞉ neke holepeleeki nikana꞉ma꞉ handoma꞉ka꞉na꞉ta꞉ naka꞉ pi ota꞉ opulumeke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nate you tikekena꞉ haena꞉ mo kenke paeyao timba꞉ la꞉ pamba puaata꞉ nate 3 okoloko (lekelo yopula꞉ dina꞉ta꞉) paa pa̱a̱ piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nate 3 okoloko (lekelo yopula꞉ haena꞉) Yesuma꞉ anekehapu wi la alota꞉ Eloi. Eloi. Lama sa꞉ba꞉kadani la alota꞉ doeki leekeme. Ya Koda꞉o. Ya Koda꞉o. I̱ ekipeke yonka꞉laalepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ipiki teke pa꞉ta꞉ haemeke wanda꞉hali mandaneeki manuma꞉ opua alota꞉ Opua꞉pe. Elaidia wi ala꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kutupa hali ma꞉nda꞉ma꞉ anke hao pua wa꞉la꞉mbima꞉ handeke ale ma꞉nda꞉ meaata꞉ kake liki neke waini ikali tenke lao tumba pitina꞉ laa tumapuna꞉ hapulao Yesuma꞉ dodopo lena꞉ hala꞉liaaso alota꞉ Hando hape. Elaidiama꞉ ipiki a꞉pa honda꞉ miliepe. Handomana꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kutupa Yesuma꞉ anekehapu wi laa ota꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yesu homeeke ekima꞉ta꞉ mo tembolo da tukiki pa꞉ta꞉ hande tupele pieke dauta꞉ oli holu nanema꞉ sinki peaalupuniaota꞉ ta꞉ta꞉ ualu piekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kutupata꞉ a꞉ndeli miniki haemeke haliwekina꞉ opisa halima꞉ Yesuna꞉ leke popeleke nane hayekeme. Kutupa Yesuna꞉ homeekeeki handolo alota꞉ Woo. Do halita꞉ ota꞉ Koda꞉na꞉ Eiyeke ya꞉ka꞉ta꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mandane wanda꞉wekima꞉ hosiki yola꞉ta꞉ pao hata꞉ handeteke haemekeme. Koto wanda꞉weki ame̱le̱ Ma꞉kadala da wanda꞉ Meti hayeketa꞉ kutupa mo wetepe weki Dia꞉mesi Diosepe hama̱la̱꞉na꞉ inkiki Meti make Salome make haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesuta꞉ Ka꞉lili nane hayeke pita꞉ koto wanda꞉wekima꞉ ipika꞉ hoki nane teli mea pomu hata꞉ ipika꞉ ne yankatiki pu haemekeme. Mandane wanda꞉weki wopu make ipiki ame̱le̱ Diutuseleme da a꞉paata꞉ koto alena꞉ haemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kutupa nate honda꞉ pambuluekema꞉ semoko da wape pitolo haena꞉ Diu wanda꞉halina꞉ Hoto Pila꞉ Natena꞉ pituluekema꞉ tiki tiki yao wamo pita꞉la꞉ dina꞉ yeeke handaa ");
INSERT INTO ssx_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","A꞉ta꞉matia da hali Diosepe epeekeme. Ipikita꞉ epeke ka̱le̱sete hali hayeketa꞉ ipikana꞉ma꞉ make Koda꞉na꞉ Kilu Tombuao Hala꞉eki epena꞉yeke handeteke hayekeme. Ipikana꞉ma꞉ honkopu hao puaata꞉ Pailedi pa꞉ta꞉ Yesuna꞉ toko honda꞉ meonoe laa honke leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kutupa Pailedima꞉ Yesu amba꞉ homea꞉ka꞉ta꞉me pi opuaata꞉ penkilipa꞉tia pomua mo hande a꞉ndeli dolo miniki haemeke haliwekina꞉ opisa hali epena꞉ wi la꞉ mea lota꞉ pitolo alota꞉ Yesu amba꞉ homa꞉la꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Homea꞉me leekeeki opuaata꞉ Diosepema꞉ Yesuna꞉ toko mina꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Diosepema꞉ epeke hakepiki dau seliapo hambaata꞉ Yesuna꞉ toko honda꞉ mea hande dau te̱liao tonka mea tiaa puaata꞉ toopi ka꞉ka꞉na꞉ pa꞉ta꞉ lapa꞉ piekeme. Toopi homeke ma꞉nda꞉ mea petepete peatiki pua mo toopi ka꞉ka꞉na꞉ a꞉mbeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma꞉kadala da wanda꞉ Metima꞉ make Diosepena꞉ inkiki Metima꞉ make Yesu ipika꞉ lapa꞉ piekeeki handepekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kutupa Diu wanda꞉halina꞉ Hoto Pila꞉ Nate welealo nane paeyeketa꞉ Ma꞉kadala wanda꞉ Metima꞉ make Dia꞉mesina꞉ inkiki Metima꞉ Salomema꞉ make Yesuna꞉ tonka꞉na꞉ yankaalo poluekema꞉ senisi alemanu hambemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sande da ka꞉la꞉paaso siki nate opa꞉la꞉ haena꞉ Yesuna꞉ toko wieke ale pa꞉ta꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pulu hata꞉ ika꞉ ika꞉ kone alota꞉ Mo hande toopi ka꞉ka꞉na꞉ a꞉mba ula꞉ toopita꞉ epima꞉ mea a꞉meiyao petepete yawalia꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Koto lemekepate pa handa꞉liaaso hata꞉ mo hande toopi petepete yawao lumbupa wieke ekita꞉ handemekeme. Kutupa make mo toopita꞉ ota꞉ tieke yeekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mo toopi lumba wieke alena꞉ honda꞉ pambaata꞉ weki hali homeke handemekeme. Mo wekihalita꞉ hakepiki dau hokulu pikieki pambaota꞉ ika꞉ popeke nane kiki nane pitiekeme. Kutupa mo wanda꞉ manuma꞉ta꞉ penkili pimikime. ");
INSERT INTO ssx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mo hande wekihalima꞉ iki pa꞉ta꞉ alota꞉ Na penkili pea꞉pa꞉peke. Ikana꞉ma꞉ Na꞉sa꞉tete hali Yesu mo a꞉ka꞉tei wapepiki tina꞉ tamendiaemeke hali weitelememe. Ipikita꞉ do pa꞉ta꞉ na ula꞉me. Amba꞉ tia꞉me. Ipika꞉ toko wimiki alena꞉ koto handa꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kotoeki handaa Pupe laa Pida make Yesu ipika꞉ mandane disaipolo haliweki make Yesuta꞉ mo Ka꞉lili nane titina꞉ amba꞉la pea꞉me lolo pupe. Ipikana꞉ma꞉ iki pa꞉ta꞉ amba꞉ hande lea꞉ tupa꞉ koto pa꞉ta꞉ handilimikie lolo pupe leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mo wanda꞉manu hama nane opolu bao mo toko wieke alena꞉ mina꞉pa꞉laota꞉ pututu litolo hata꞉ make penkili pitolo hata꞉ pindi pa puaata꞉ paala꞉ma꞉ homemeke handaa ma꞉nda꞉ pa꞉ta꞉ pi na lemekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesuma꞉ta꞉ Sande da panake ka꞉la꞉polo haena꞉ tiaota꞉ titina꞉ amba꞉la mo Ma꞉kadala wanda꞉ Metima꞉ handena꞉yeke peneme yaeyekeme. Mo wanda꞉ta꞉ Yesuma꞉ amba꞉ kone ipika꞉ hoke temoko watake hata꞉ tolu lieke wanda꞉e. ");
INSERT INTO ssx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mo wanda꞉ma꞉ Yesu ame̱le̱ amba꞉ pomu haemeke wanda꞉halima꞉ e̱ alo haena꞉ Yesuma꞉ leeke pi lolo peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kutu piekepate mo wanda꞉halima꞉ Yesu paa tiao hala꞉me leekeeki opuata꞉ I̱ma꞉ handoa꞉me leekeeki opua kone ota꞉ na opimikime. ");
INSERT INTO ssx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wetepena꞉ hali yaapo pota꞉na꞉ pepekepate Yesuma꞉ mo hali yaapoma꞉ handena꞉yeke ta꞉ta꞉ piki hali leke peekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kutupa mo hali yaapoma꞉ paa la꞉ka꞉la puaata꞉ mandane hoki nane tolu haemeke wanda꞉hali lolo pepekepate ipilika꞉ pi make na opimikime. ");
INSERT INTO ssx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kutupa wetepena꞉ mo hande kiki yaapona꞉ ankena꞉ homeke pu haliweki kone ne nalo pitina꞉ iki pa꞉ta꞉ ipika꞉ kone waleekeme. Yesuma꞉ mo haliwekima꞉ ipika꞉ tiao hayekeeki handemeke wanda꞉halina꞉ pi na opimiki handaata꞉ Yesuma꞉ mo haliwekina꞉ pi na opimiki ekina꞉ make ika꞉ puki taka꞉laeyeke ekina꞉ make pi leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Kenke paeyao pa꞉ta꞉ puaata꞉ wanda꞉hali paeyao pa꞉ta꞉ do pi seliapo wala꞉pa꞉peke laa ");
INSERT INTO ssx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hali epima꞉ pi mea bapitaisi peawaya꞉ka꞉na꞉ta꞉ koto halita꞉ da꞉ta halieke. Kutu piliepate hali epima꞉ pi na mia꞉ka꞉na꞉ta꞉ ipika꞉ yenki milieke. Koda꞉ma꞉ pi yokaalu pia꞉ka꞉na꞉ta꞉ kota꞉ alu pilieke. ");
INSERT INTO ssx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kutupa pi mulu peleme wanda꞉halima꞉ do wele pita꞉la꞉ ekimanu handilimikie leekeme. Ya bikina꞉ hoke temokomanu tolu limikie. Panake pimanu lelimikie. ");
INSERT INTO ssx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hoke ketomanu kikima꞉ minilimikie. Hali homaasa꞉ ikali nemeka꞉na꞉ta꞉ na homilimikie. Yeni haaseme wanda꞉halina꞉ ika꞉ kiki wimika꞉na꞉ta꞉ koto wanda꞉hali tiaalimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Koto ekina꞉ Tekehali Yesuma꞉ mo wanda꞉hali pi la halo paeyaota꞉ Koda꞉ma꞉ Yesu mea oli ya nane hatuku miekeme. Kutupa Yesuta꞉ Koda꞉na꞉ popeke nane kiki nane pitiniaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yesuta꞉ oli hepeni nane pua hata꞉ disaipolo wanda꞉halima꞉ kenke paeyaona꞉ do pi seliapo wala꞉tiki pu hayekeme. Kutupa Tekehalima꞉ mandakena꞉ e pokolo hata꞉ wanda꞉halima꞉ ika꞉ pi ota꞉ pie lena꞉yeke wele pieke ekimanu pimikime. Kutu pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Diopilusio. Mo niki tukiki pa꞉ta꞉ pa꞉la꞉eki manuta꞉ mandane wanda꞉hali wotuma꞉ ika꞉ ika꞉ kone honkopu wotu hao wape lao wilimime. ");
INSERT INTO ssx_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mo amba꞉ hande pieke ekimanu paeyaota꞉ ota꞉ kini pea handaa walemeke haliwekima꞉ niki pa꞉ta꞉ la kimi tupa꞉ kone ikana꞉ma꞉ make ika꞉ wapemanu pa꞉ta꞉ laemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Koto ekina꞉ epeke some Diopilusio. I̱ma꞉ do hau manuna꞉ kini pa꞉la꞉ tupa꞉ sembepela hone na u pita꞉ handa꞉ wiaata꞉ naka꞉eki make tikitiki yao wape lao wiaasota꞉ epolo pia꞉me laa loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","I̱ma꞉ dupiki hauta꞉ nakana꞉ma꞉ naka꞉ waleke pimanu paeyaona꞉ teke handoelena꞉ yeke loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mo Diudia nane hande kini hali Hetodi hayeke pita꞉ yeni peao hayeke hali homeke Sekataiya make hayekeme. Ipikita꞉ mo yeni peao haemeke Abaisia tapake halie. Ipika꞉ wanda꞉ Elisa꞉bedi make mo hande yeni peao haemeke Etoni tapake wanda꞉e. ");
INSERT INTO ssx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mo wanda꞉ hali yaapota꞉ Koda꞉na꞉ leke popelekena꞉ tikitiki yao hata꞉ ipika꞉ pi ula꞉ ekimanu paeyao opu haepekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kutu pu haepekepate weki ma꞉nda꞉ na hatuku haepekeme. Pa ekipeke mo Elisa꞉bedita꞉ kenohali hayekeme. Kutupa ipilikita꞉ koke tooli haepekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sekataiyata꞉ ipika꞉ tapake haliwekina꞉ Koda꞉ pa꞉ta꞉ hata꞉ hande yeni peao haemeke nate epeeke handaata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","mo yeni peao haemeke haliwekima꞉ pu haemeke tupa꞉ Sekataiyama꞉ mo hande totopo piki ale mo olodana꞉ yankaena꞉yeke mimikime. ");
INSERT INTO ssx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Koto ekina꞉ mo hande totopo piki ale yankeeke pita꞉ mo wanda꞉hali paeyaoma꞉ hama꞉ nane hata꞉ yeni pitolo haena꞉ Sekataiyata꞉ mo Tekehalina꞉ tembolo da pa꞉ta꞉ honda꞉ pamba peekepate ");
INSERT INTO ssx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","mo hande totopo piki ale oloda yanko hayeke popeke nanema꞉ kiki nane Tekehalina꞉ enisolo homeke a꞉pa hayekeeki handeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kutupa Sekataiyama꞉ mo enisolo hando haota꞉ paala꞉ma꞉ homolo hata꞉ make ka꞉nda꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kutu piekepate mo enisoloma꞉ ipiki pa꞉ta꞉ alota꞉ Sekataiyao. Paala꞉ma꞉ na homa꞉peke laata꞉ Koda꞉ma꞉ naka꞉ yeni pieki opu haota꞉ naka꞉ wanda꞉ Elisa꞉bedima꞉ naka꞉ weki mendiaena꞉ lelieke. Kutupa nakana꞉ma꞉ mo wekina꞉ bikita꞉ Dioni lapeke laata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nakana꞉ma꞉ make ta꞉na꞉ma꞉ homolo pelepateta꞉ mo weki mendia꞉ka꞉na꞉ta꞉ mandane wanda꞉hali wopuma꞉ make ta꞉na꞉ma꞉ wotu homilimikie. Kutupa ");
INSERT INTO ssx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","mo weki daeya hata꞉ta꞉ Koda꞉na꞉ leke popelekena꞉ hata꞉ hali tieke halieke laata꞉ Ipikana꞉ma꞉ta꞉ mo waini ikali make mo hoke ikali make na nelieke. Kutupa ipikita꞉ inkikina꞉ weleke pa꞉ta꞉ pitina꞉ kone mo Holi Sipitidi tumbaalieke. ");
INSERT INTO ssx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kutupa ipikana꞉ma꞉ Isulai wanda꞉hali wopu pa hatuku ika꞉ Tekehali Koda꞉ pa꞉ta꞉ pelimikie. ");
INSERT INTO ssx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ipikita꞉ Tekehalina꞉ tapaalia꞉ hali pua hata꞉ta꞉ hande Elaidia tupa꞉ honkopu hao wele pitolo hata꞉ kutupa wekiwandiki ateke ameda titi make paa mea apa꞉taota꞉ mo hande pi na opueleme wanda꞉halima꞉ tikitiki piki hone wina꞉yeke mea la꞉ka꞉laota꞉ mo hande Tekehalina꞉ epolo pa꞉la꞉ dina꞉yeke ipika꞉ wanda꞉hali mea tikitiki yao haena꞉ lelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekataiyama꞉ mo enisolo pa꞉ta꞉ alota꞉ Do pita꞉ ota꞉ekie laa ekipa hone wionope laata꞉ Ya wanda꞉ diki telipina꞉ koke ya halopa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mo hande enisoloma꞉ ipika꞉ pi hombo peaaso alota꞉ I̱ta꞉ Keipitelee laata꞉ Koda꞉na꞉ leke popelekena꞉ hao halome. Kutupa Koda꞉ma꞉ta꞉ do pi seliapo neke pa꞉ta꞉ lonoyeke I̱ tapaeya꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Do I̱ma꞉ mea epolo pita꞉ ipika꞉ nate epea꞉ka꞉na꞉ ota꞉ yaalo pa꞉la꞉pate nakana꞉ma꞉ na opueleme laata꞉ Kota꞉ do alo pi na opiki handaa neketa꞉ pi na leke kake a꞉mba halipikie. Kutupa I̱ma꞉ neke pa꞉ta꞉ do la꞉ witolo pi ota꞉ yaeya꞉ka꞉na꞉ta꞉ naka꞉ kake paa lombaa pi lelipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Koto pi alo haepekepate mo wanda꞉halima꞉ hama꞉ nane hata꞉ Sekataiya epena꞉ handeteke haemekepate a̱i̱ na epeeke handaata꞉ ikana꞉ma꞉ hone ta꞉ta꞉ ta꞉ta꞉ wimikime. ");
INSERT INTO ssx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kutupa Sekataiya opolu bao hama꞉ nane epeekepate mo wanda꞉hali pa꞉ta꞉ pi ma꞉nda꞉ lapeke na yeekeme. Koto ekina꞉ wanda꞉halima꞉ hone witolota꞉ ipikana꞉ma꞉ mo tembolo da tukiki pa꞉ta꞉ hata꞉ aleta꞉ ma꞉nda꞉ handolo pia꞉me la hone wimikime. Kutupa Sekataiyama꞉ pi lapeke na yaalo hata꞉ wanda꞉hali pa꞉ta꞉ ipika꞉ kiki homeke wankeaaso hata꞉ kikima꞉ kone waleekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekataiyama꞉ mo hande tembolo da pa꞉ta꞉ ipika꞉ e poko hayeke natemanu paeyeketa꞉ ipika꞉ da paa la꞉ka꞉la peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kutupa koto hoki naneta꞉ ipika꞉ wanda꞉ Elisa꞉bedima꞉ weki loke lombeeketa꞉ sumba꞉ yunki hata꞉ ipika꞉ da na mina꞉pa꞉lake pa pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisa꞉bedima꞉ alota꞉ Tekehalima꞉ ame do tupa꞉ tamba꞉ ma꞉la꞉me laata꞉ Wanda꞉hali pa꞉ta꞉ yaala꞉ma꞉ homoa꞉ ekita꞉ ipikana꞉ma꞉ yoka꞉ mea baala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kutupa Elisa꞉bedima꞉ weki loke lomba haena꞉ sumba꞉ yunki mindiki a꞉pa opeeke dina꞉ta꞉ Koda꞉ma꞉ hande enisolo Keipitele mo Ka꞉lili nane hayeke da Na꞉sa꞉tete da pa꞉ta꞉ tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mo hande amba꞉ hayeke kini hali Deipidina꞉ tapake hali Diosepena꞉ da polo pieke wandiki pa꞉ta꞉ pi la꞉ ulu pena꞉ tapaeyekeme. Mo wandikina꞉ bikita꞉ Metie. ");
INSERT INTO ssx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mo hande enisoloma꞉ ipiki pa꞉ta꞉ pua alota꞉ Keiyae. Neketa꞉ Tekehalima꞉ ota꞉ amba꞉ epeaala꞉ wandikie. Neke yaapo hala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Metima꞉ koto pi opiekepate Eki hau pulu polo ekina꞉ ala꞉pe laa ipika꞉ honema꞉ mo pi teke wotu weiyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mo hande enisoloma꞉ ipiki pa꞉ta꞉ alota꞉ Metio. Koda꞉ma꞉ neke pa꞉ta꞉ hone wotu wita꞉la꞉ma꞉ paala꞉ma꞉ na homa꞉peke laata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Neketa꞉ weki loke lombaata꞉ wetepena꞉ hali weki mendilipikima꞉ ipika꞉ bikita꞉ Yesu lapeke. ");
INSERT INTO ssx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kutupa ipiki daeyaata꞉ hali tieke halieke. Kutupa ipikita꞉ Ota꞉ Manda Hala꞉ Koda꞉na꞉ Eiyeke lelimikie leekeme. Kutupa mo hande Tekehali Koda꞉ma꞉ ipika꞉ amba꞉ titina꞉ kini hali Deipidina꞉ kilu tombuao hayekeeki ipikana꞉ma꞉ mina꞉ lelieke. ");
INSERT INTO ssx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kutupa ipikita꞉ Dieikope tapake wanda꞉halina꞉ kini hali hao hata꞉ ipika꞉ kilu tombuao halo pa꞉la꞉ ekita꞉ na paelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Koto leeketa꞉ Metima꞉ mo enisolo pa꞉ta꞉ alota꞉ Kotoeki pulu pa꞉la꞉ ekita꞉ ekipape. I̱ta꞉ halina꞉ da a̱i̱ na polome leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mo hande enisoloma꞉ ipika꞉ pi hombo peaaso alota꞉ Mo Holi Sipitidi neke pa꞉ta꞉ ipilieke. Kutupa make Ota꞉ Manda Hala꞉ Koda꞉ ipika꞉ wele pita꞉la꞉eki neke pa꞉ta꞉ a꞉pa pitilieke. Kutu pita꞉la꞉ ekima꞉ta꞉ mo hande nakana꞉ma꞉ mondulu pele yako piki weki ipikita꞉ Koda꞉na꞉ Eiyekee lelimikie. ");
INSERT INTO ssx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Naka꞉ tapake wanda꞉ Elisa꞉bedi pa꞉ta꞉ hone wia꞉peke. Ipiki pa꞉ta꞉ Weki kenohali wanda꞉e lo halemepateta꞉ ame ipikita꞉ koke wanda꞉sikima꞉ kone ipika꞉ weki loke lombeeke sumba꞉ yunki mindiki hata꞉ amba꞉ opa꞉la꞉me laata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Hau paeyao kone Koda꞉ma꞉ pea꞉peke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Koto leeke handaa Metima꞉ alota꞉ I̱ta꞉ Tekehalina꞉ e pokao halo wandikie. Nakana꞉ma꞉ la꞉ witele tupa꞉ pina꞉e leekeme. Kutupa mo enisolota꞉ mo wandiki mina꞉pa꞉lao peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Koto pita꞉ kone Metita꞉ tiao Diuda nane peiyene wieke pa꞉ta꞉ hayeke da ma꞉nda꞉ pa꞉ta꞉ a̱i̱ya peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Puaata꞉ Sekataiyana꞉ da pa꞉ta꞉ honda꞉ pamba pua Elisa꞉bedi pa꞉ta꞉ keiyae pi pua leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Metima꞉ leeke pi Elisa꞉bedima꞉ opitolo haena꞉ kone mo ipika꞉ weleke pa꞉ta꞉ pitieke weki la꞉ma꞉ la꞉ma꞉ piekeme. Kutupa Elisa꞉bedima꞉ mo Holi Sipitidima꞉ tumba pitina꞉ pi ");
INSERT INTO ssx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","anekema꞉ alota꞉ Wanda꞉weki poluna꞉ kone Koda꞉ma꞉ neke mea epeaala꞉me laata꞉ Nakana꞉ma꞉ mondulu pele weki make Koda꞉ma꞉ amba꞉ epeaala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yaka Tekehalina꞉ ama꞉ma꞉ I̱ handolo epele ekita꞉ do hau tiekena꞉ pa ekipeke epelepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Naka꞉ keiyae pi leeki opitolo hano kone ya weleke pa꞉ta꞉ pila꞉ wekima꞉ ta꞉na꞉ma꞉ homolo hata꞉ tia liaeya꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nakana꞉ma꞉ta꞉ mo hande Tekehalima꞉ neke pa꞉ta꞉ pi la꞉ ula꞉ ekita꞉ opua ota꞉ pilieke hone tula ale ekima꞉ta꞉ ta꞉na꞉ma꞉ homilipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Koto leeketa꞉ Metima꞉ alota꞉ Yaka pukima꞉ Tekehalina꞉ pi laasome. ");
INSERT INTO ssx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","I̱ Mea Da꞉taasa꞉ Hali Koda꞉ma꞉ta꞉ I̱ta꞉ ipika꞉ e pokaaso wanda꞉siki pa꞉ta꞉ kone hone ula꞉ ekina꞉ yaka temokoma꞉ta꞉ ta꞉na꞉ma꞉ homa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Hande Wele Pita꞉la꞉ Koda꞉ma꞉ta꞉ I̱ pa꞉ta꞉ hau tiekemanu peala꞉ ekina꞉ta꞉ ame make wetepe make wanda꞉hali paeyaoma꞉ I̱ pa꞉ta꞉ta꞉ Koda꞉ma꞉ epeaala꞉ wanda꞉e lelimikie. Mo Koda꞉na꞉ bikita꞉ yakopiki bikie. ");
INSERT INTO ssx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ipiki pa꞉ta꞉ paala꞉ma꞉ homeleme wanda꞉hali pa꞉ta꞉ make koto wanda꞉halina꞉ weki wandiki pa꞉ta꞉ make ipikana꞉ma꞉ a꞉ta꞉ma꞉ homo hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ipikana꞉ma꞉ ipika꞉ wele pita꞉la꞉ kiki tindipaota꞉ mo hakoko liteleme wanda꞉hali ika꞉ dupumana꞉e laa amu piteleme alemanu tonka꞉na꞉ ta꞉ta꞉ ta꞉ta꞉ pea wina꞉yeke la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wele piteleme kini haliwekimanu make manda pitimikipate ipikana꞉ma꞉ iki mea lopa꞉niao mo hande pa haleme haliweki mea a꞉meiyala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tea꞉ma꞉ homemeke wanda꞉hali pa꞉ta꞉ epeke napeke alemanu mea tumbaeyekepate pa mo hamoko wanda꞉halita꞉ kiki hameke tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nika꞉ amba꞉ titina꞉ apa꞉mei pa꞉ta꞉ la꞉ wieke pi manuta꞉ ipikana꞉ma꞉ ota꞉ yao piekeme. Ipika꞉ e pokaeyeke hali Isulai pa꞉ta꞉ ipikana꞉ma꞉ tamba꞉ mulu epeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kutupa Eipoloha꞉ma꞉ pa꞉ta꞉ make ipika꞉ hoki nane wanda꞉hali paeyao pa꞉ta꞉ make hoto paeyao ipikana꞉ma꞉ a꞉ta꞉ma꞉ homo halueke hone wiekeme laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Koto laa Metita꞉ Elisa꞉bedi ame̱le̱ sumba꞉ tepo haota꞉ paa la꞉ka꞉la ipika꞉ da peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kutupa Elisa꞉bedima꞉ ipika꞉ weki mondulu pieke nate epeeke handaata꞉ haliweki mendiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kutu pieke handaa ipika꞉ tapake wanda꞉halima꞉ make ipiki ame̱le̱ haemeke wanda꞉halima꞉ make Tekehalima꞉ ipiki ota꞉ epeaeyekeeki handaata꞉ pea꞉ paeyaoma꞉ make Elisa꞉bedima꞉ make ta꞉na꞉ma꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pula homeke paeyeketa꞉ mo weki sekemesaisi hau pealuekema꞉ momba꞉la hata꞉ ipika꞉ atekena꞉ biki kone Sekataiya loluekema꞉ pimikipate ");
INSERT INTO ssx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ipika꞉ inkikima꞉ alota꞉ Dia꞉me. Ipika꞉ bikita꞉ Dionie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kutupa mo wanda꞉halima꞉ ipiki pa꞉ta꞉ alota꞉ Koto biki lolo poloma꞉pateta꞉ naka꞉ tapake hali homeke a꞉nda꞉ koto biki leke hali ma꞉nda꞉ na haya꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Koto laa mo wanda꞉halima꞉ kiki wankeaaso hata꞉ mo wekina꞉ ateke pa꞉ta꞉ alota꞉ Ta wekita꞉ eki biki lomana꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Koto ekina꞉ Sekataiyama꞉ wape puluekema꞉ tameiya꞉ honke laa dupa wape piekeme. Do wekina꞉ bikita꞉ Dioni alome laa wape piekeme. Kutu pieke handaa mo wanda꞉hali paeyaoma꞉ penkilipa꞉tia pomimikime. ");
INSERT INTO ssx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kutu pieketa꞉ kutaa kone Sekataiyana꞉ kake lumbieketa꞉ pi lapeke yalo hata꞉ ipikana꞉ma꞉ Koda꞉na꞉ pi laeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Koto ekina꞉ta꞉ koto pa꞉ta꞉ haemeke wanda꞉halima꞉ paala꞉ma꞉ homemekeme. Kutupa mo pieke ekimanu mo Diudia nane peiyene pa꞉ta꞉ hayeke da sunu paeyao pa꞉ta꞉manu la꞉tia pomimikime. ");
INSERT INTO ssx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mo pi opimiki wanda꞉hali paeyaoma꞉ opua hone witolo alota꞉ Do wekita꞉ ekipiki hali halia꞉pe laa lota꞉ lota꞉ pimikime. Tekehalina꞉ wele pita꞉la꞉eki mo weki pa꞉ta꞉ peneme yao pitiekeeki handolo hata꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mo wekina꞉ ateke Sekataiyama꞉ mo Holi Sipitidi tumba pitina꞉ hata꞉ pi la꞉ witolo alota꞉ ");
INSERT INTO ssx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Tekehalima꞉ ipika꞉ wanda꞉hali tamba꞉ mulu a꞉paata꞉ iki tonkaala꞉ alemanu ka꞉la꞉pa wala꞉ ekina꞉ Isulai wanda꞉halina꞉ Koda꞉ ipika꞉ pi laamana꞉e. ");
INSERT INTO ssx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ipika꞉ e pokaeyeke hali Deipidina꞉ tapake hali kone niki Mea Da꞉taalo Pa꞉la꞉ wele pita꞉la꞉ Hali ipikana꞉ma꞉ amba꞉ mea a꞉meiyawala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ame do yaaso hata꞉ pita꞉la꞉ ekita꞉ amba꞉ titina꞉ kone ipika꞉ pi la꞉mea halo haemeke yako piki haliwekima꞉ ipika꞉ pi la꞉ wiaena꞉yeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Niki ame̱le̱ a꞉nda꞉ liteleme haliwekima꞉ make leke tankema꞉ handeleme haliwekina꞉ wele pita꞉la꞉eki manuma꞉ make niki bepolaapa꞉na꞉ niki mea tamba꞉ muluekema꞉yeke ipikana꞉ma꞉ pi amba꞉ la꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kutupa nika꞉ amba꞉ titina꞉ haemeke haliweki pa꞉ta꞉ta꞉ Iki pa꞉ta꞉ a꞉ta꞉ma꞉ homolueke laa Yaka yako piki pi la꞉ ulueki make hone uluekee leekeme laata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Nika꞉ amba꞉ titina꞉ hayeke hali Eipoloha꞉ma꞉ pa꞉ta꞉ ipikana꞉ma꞉ pi tieke la꞉ witolo hata꞉ leeketa꞉ niki pa꞉ta꞉ make ipikana꞉ma꞉ pi dupa la꞉ ula꞉me. Ikana꞉ma꞉ paala꞉ma꞉ na homeke ");
INSERT INTO ssx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","yaka e pokao hata꞉ yako piki wanda꞉hali make tikitiki yao haleme wanda꞉hali make I̱ pa꞉ta꞉ bapi paeyao koto tupa꞉ hamena꞉yeke ika꞉ a꞉nda꞉ tunkuliki haliwekima꞉ iki bepolaapa꞉na꞉ I̱ma꞉ iki tamba꞉ mulueke laa pi la꞉ wiekeme leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Koto ekina꞉ ya wekio. Neketa꞉ Ota꞉ Manda Hala꞉ Koda꞉ ipika꞉ pi la꞉mea halo hala꞉ hali haleme laa lelimikie. Kutupa Tekehali wetepena꞉ epena꞉ nakana꞉ma꞉ ipika꞉ pota꞉ tikitiki yawaluekema꞉ amba꞉la pelipikie. ");
INSERT INTO ssx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nakana꞉ma꞉ ipika꞉ wanda꞉hali pa꞉ta꞉ dupa lelipikie. Koda꞉ma꞉ ika꞉ hoke hau peleme ekimanu paeyaaso hata꞉ta꞉ iki mea da꞉taalieke laa lelipikie. ");
INSERT INTO ssx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Pa ekipeke. Nika꞉ Koda꞉ta꞉ yopu hao hata꞉ niki pa꞉ta꞉ a꞉ta꞉ma꞉ homo hala꞉me. Da panake ka꞉la꞉polo hata꞉ pa̱a̱ peaasa꞉ tupa꞉ta꞉ Koda꞉ma꞉ niki pa꞉ta꞉ da꞉ta꞉la꞉eki kilieke. ");
INSERT INTO ssx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kutupata꞉ mo homa꞉la꞉ ekina꞉ paala꞉ma꞉ homolo hata꞉ timba꞉ la꞉pa pa꞉la꞉ ekina꞉ tu̱ pa꞉ta꞉ haleme wanda꞉hali pa꞉ta꞉ make Koda꞉ma꞉ oli ya nane hata꞉ pa̱a̱ peanialieke. Nikita꞉ mo puki lopa꞉niao pula꞉ pota꞉na꞉ pomonoyeke ipikana꞉ma꞉ nika꞉ pota꞉ walolo hata꞉ do haumanu pilieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kutupa mo wekita꞉ epeke tupa꞉ daeyaata꞉ ipika꞉ temoko make daeyatia pulu hata꞉ mo Isulai wanda꞉halina꞉ leke popelekena꞉ haluekema꞉ handeteke hata꞉ mo hapu hayeke alena꞉ hao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mo Sisa Okasitasima꞉ ipika꞉ kilu tombuao hayeke da wanda꞉hali paeyaona꞉ bikimanu wape pina꞉yeke momba꞉lapa꞉peke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Koto titina꞉ biki mimiki pita꞉ta꞉ mo Sitia nane handeteke hayeke kapomani tieke halita꞉ Kuliniasi hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Koto leeke handaa wanda꞉hali paeyao biki mina꞉yeke ika꞉ da teke pa꞉ta꞉manu pemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hali ma꞉nda꞉ Diosepeta꞉ mo Ka꞉lili nane hayeke da Na꞉sa꞉tete da mina꞉pa꞉laota꞉ mo Diudia nane hayeke da Beteleha꞉ma꞉ da pa꞉ta꞉ peekeme. Koto data꞉ hande kini hali Deipidi mendieke dae. Diosepeta꞉ Deipidina꞉ tapake hali hayekeeki yaalo koto da pa꞉ta꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kutupa ipika꞉ wanda꞉ Meti yaapo biki mina꞉yeke pepekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Metita꞉ weki loke lomba pitina꞉ pepekepate mo Beteleha꞉ma꞉ da pa꞉ta꞉ pua hata꞉ Meti weki hoki neekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kutupa ipika꞉ mupeke weki mendiata꞉ hokulupeke dau manuma꞉ ambulata꞉ kimisu wanda꞉halima꞉ hambo haemeke da pa꞉ta꞉ pelia꞉peke da dia꞉yeke handa kao ma꞉na꞉na꞉ ne halo haemeke u̱lu̱ pa꞉ta꞉ mea pua wiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kutupa mandane sipisipi handeteke haemeke haliwekima꞉ta꞉ koto data꞉ pa ambu hapeke nane ika꞉ sipisipi ma꞉na꞉ titi timba handeteke haemekepate ");
INSERT INTO ssx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tekehalina꞉ enisolo homeke iki pa꞉ta꞉ opolo epeekeme. Kutupa mo Tekehali ipika꞉ pa̱a̱ pa꞉la꞉ ekima꞉ iki dupaeyekeme. Koto ekina꞉ mo haliwekima꞉ paala꞉ma꞉ wopu homemekepate ");
INSERT INTO ssx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","mo enisoloma꞉ iki pa꞉ta꞉ alota꞉ Paala꞉ma꞉ na homa꞉pepee. Iki pa꞉ta꞉ epeke pi seliapo loluekema꞉ epolome. Koto ekima꞉ta꞉ wanda꞉hali paeyao ta꞉na꞉ma꞉ homaalieke. ");
INSERT INTO ssx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ame do timbata꞉ oni hande Deipidina꞉ da teke pa꞉ta꞉ta꞉ ika꞉ da꞉taalo pa꞉la꞉ Tekehali amba꞉ mendia꞉la꞉me. Ipikita꞉ Tekehali Ketisoe. ");
INSERT INTO ssx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iki pa꞉ta꞉ I̱ma꞉ alo ekita꞉ ota꞉ pi aloma꞉ handolo pupe. Mo wekita꞉ dauma꞉ ambula bao mo kao ma꞉na꞉ manuma꞉ ne no haleme u̱lu̱na꞉ ula꞉ma꞉ handolo pupe laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Koto kone oli hepeni nane haemeke enisolo titi wopuma꞉ mo hande enisolo homeke ame̱le̱ apa꞉tao a꞉pa pambo hata꞉ Koda꞉na꞉ pi laaso hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Oli ya manda hala꞉ Koda꞉na꞉ pi lapa꞉peke. Ipikana꞉ma꞉ ta꞉na꞉ma꞉ homolo hata꞉ kenkena꞉ haleme haliwekina꞉ puki lopaala꞉me laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mo hande enisolo tapake pa la꞉ka꞉la ya nane pemeke hoki nane mo ma꞉na꞉ handeteke haemeke haliwekima꞉ pi hotiolo hata꞉ alota꞉ Mo Tekehalima꞉ niki pa꞉ta꞉ la kia꞉ ekita꞉ oni Beteleha꞉ma꞉ da nane pa꞉la꞉eki handomana꞉ bape lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kotoeki laa a̱i̱ya puata꞉ Meti Diosepe yaapo handa꞉ wiata꞉ u̱lu̱ pa꞉ta꞉ hande weki wiekeeki handemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mo ma꞉na꞉ handeteke haemeke haliwekima꞉ mo weki handolo hata꞉ hande enisoloma꞉ mo wekima꞉ pulu piekeeki iki pa꞉ta꞉ la kiekeeki manuta꞉ mo wanda꞉ hali yaapo pa꞉ta꞉ la halemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kota꞉ koto haliwekima꞉ la halemeke ekimanu opimiki wanda꞉hali paeyaoma꞉ta꞉ penkilipa꞉tia pomimikime. ");
INSERT INTO ssx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kutupa Metima꞉ta꞉ hande pi paeyao pa꞉ta꞉ hone witolo hone wopu u pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kutupata꞉ mo hande ma꞉na꞉ handeteke haemeke haliwekima꞉ pa la꞉ka꞉la pulu hata꞉ta꞉ mo enisoloma꞉ leeke tupa꞉ kone hande hau paeyao handaata꞉ Koda꞉na꞉ biki mina꞉liaaso hata꞉ pi laatia pemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kutupa pula homeke paeyeketa꞉ mo weki pa꞉ta꞉ sekemesaisi hau peaota꞉ ipika꞉ biki Yesu lemekeme. Mo weki a̱i̱ na pitiki haena꞉ hande enisoloma꞉ lahaleeke biki kone lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hande Mosesina꞉ pi ula꞉eki manuna꞉ wape pa꞉la꞉ tupa꞉ mo ankula꞉ epeaalo pieke nate epeeke handa mo wekita꞉ Tekehali pa꞉ta꞉ haluekema꞉ Diosepe Meti yaapoma꞉ ipiki hatuku Diutuseleme da pemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tekehalina꞉ pi ula꞉ ekimanu pa꞉ta꞉ dupa wape pea ula꞉me. Mupeke nanema꞉ mendilimi weki paeyao Tekehali pa꞉ta꞉ mea haena꞉ lapa꞉peke laa wape pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma꞉nda꞉ make dupa wape pa꞉la꞉me. Homupiki ba yaapo o melipu panake ba yaapo lia hala꞉peke laa wape pa꞉la꞉ tupa꞉ ipilikana꞉ma꞉ mo ba yaapo Koda꞉ pa꞉ta꞉ lia haluekema꞉ pepekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kutupa mo Diutuseleme da pa꞉ta꞉ta꞉ koke hali ma꞉nda꞉ Simioni hayekeme. Koto halima꞉ta꞉ Koda꞉ pa꞉ta꞉ paala꞉ma꞉ homa hata꞉ epeke hau pitolo hata꞉ make mo Isulai wanda꞉halina꞉ da꞉taalo pieke nate epena꞉ handeteke hao hayekeme. Ipikita꞉ Holi Sipitidi yaapo hayekeeki yolo hata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","mo Holi Sipitidima꞉ ipiki pa꞉ta꞉ pi la꞉ witolo alota꞉ Neketa꞉ a̱i̱ na homeke pa halena꞉ kone mo Tekehalima꞉ pi la꞉ ula꞉ hali ipilieke. Mo Ketiso kone handilipikie laa pi la꞉ wiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kutupata꞉ mo Holi Sipitidima꞉ Simioni hatuku mo tembolo da pa꞉ta꞉ peekeme. Kutupa mo hande pi wiekeeki puluekema꞉ Diosepe Meti yaapoma꞉ mo tembolo da pa꞉ta꞉ mo hande weki Yesu hatuku pepekepate ");
INSERT INTO ssx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simionima꞉ mo weki meata꞉ Koda꞉ pa꞉ta꞉ keiyae pi alo hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Tekehalio. Ameta꞉ naka꞉ hande pi la꞉ wili ekita꞉ ota꞉ yaaleme. Koto ekina꞉ naka꞉ e pokaaso halina꞉ puki lopao pono lae. ");
INSERT INTO ssx_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Do ekina꞉ yeke loa꞉me. Naka꞉ hande wanda꞉hali da꞉taalo pa꞉la꞉ hali ame yaka lekema꞉ handolome. ");
INSERT INTO ssx_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Do hauta꞉ wanda꞉hali paeyaoma꞉ handolo haena꞉ piteleme. ");
INSERT INTO ssx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kutu pitolo hata꞉ ipikana꞉ma꞉ mo Diendaili wanda꞉hali pa꞉ta꞉ pa̱a̱ pa꞉la꞉eki haluekema꞉ make Isulai wanda꞉halina꞉ biki tieke wina꞉ loluekema꞉ make pilieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Koto pita꞉ta꞉ mo Simionima꞉ mo weki pa꞉ta꞉ leeke pi opuaata꞉ mo ateke inkiki yaapoma꞉ penkilipa꞉tia pomipikime. ");
INSERT INTO ssx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simionima꞉ iki epeaota꞉ mo wekina꞉ inkiki Meti pa꞉ta꞉ alota꞉ Isulai wanda꞉hali wopu mea da꞉taaluekema꞉ make hoeyaaluekema꞉ make Koda꞉ma꞉ do weki mea haena꞉ laa pa꞉la꞉me. Ipikita꞉ Koda꞉ma꞉ tombo leke haya꞉ka꞉na꞉ta꞉ wanda꞉hali wopuma꞉ ipiki pa꞉ta꞉ pi la la pitolo hata꞉ make ");
INSERT INTO ssx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ika꞉ hone a꞉mbao wita꞉la꞉ ekimanu peneme yao lelimikie. Kutupa ka꞉nda꞉ pikieki ma꞉nda꞉ make kepete ne haake ekima꞉ leke naka꞉ puki awilieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mo A꞉sea tapake hali Pa꞉nuele ipika꞉ waneke A꞉na꞉ma꞉ta꞉ Koda꞉na꞉ pi la꞉mea halo hayeke wanda꞉ hayekeme. Ipika꞉ haliki yaapota꞉ bapi watake hata꞉ hao haliki homeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ipikita꞉ koke wanda꞉ hata꞉ ipika꞉ bapita꞉ 84 yeekeme. Kutupa ipikana꞉ma꞉ mo tembolo da na mina꞉pa꞉lake timba make natena꞉ make Koda꞉ pa꞉ta꞉ panda꞉puniao hata꞉ ne pi wia꞉tiki pea yeni pu hatiki pu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mo wanda꞉ta꞉ koto pita꞉ kone ipikana꞉ma꞉ koto pa꞉ta꞉ opolo puata꞉ mo weki handaata꞉ Koda꞉ pa꞉ta꞉ keiyae pi laata꞉ Koda꞉ma꞉ mo Diutuseleme wanda꞉hali da꞉taena꞉yeke handeteke haemeke wanda꞉hali paeyaoma꞉ opina꞉ mo wekina꞉ pi wotu leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mo Tekehalina꞉ pi ula꞉ ekima꞉ pea꞉pa꞉peke la꞉la꞉ hau paeyao pu paeyaepeketa꞉ mo Ka꞉lili nane ota꞉ ipilika꞉ haepeke da Na꞉sa꞉tete nane paa pepekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kutupa mo wekita꞉ daeya hata꞉ honkopu hao hata꞉ make hone wopu u hayeketa꞉ Koda꞉ma꞉ epeatiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bapi paeyaota꞉ Yesuna꞉ apa꞉ ama꞉ yaapota꞉ Diutuseleme nane mo Lombei Pupa Yapeeke nate mia꞉tiki pieke handaa pua꞉tiki pipikime. ");
INSERT INTO ssx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesuta꞉ bapi kiki yaapo paeya ankena꞉ yaapo mieke natena꞉ta꞉ mo ne pamba꞉la꞉ nane ika꞉ pu haemeke tupa꞉ kone pemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mo hande ne pamba paeyeketa꞉ ika꞉ da poluekema꞉ yeke pemekepate Yesuta꞉ Diutuseleme da pa hapelia hayekeme. Ipika꞉ apa꞉ ama꞉ yaapoma꞉ta꞉ do ekita꞉ hone na wipikime. ");
INSERT INTO ssx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ipilika꞉ honema꞉ta꞉ Yesuta꞉ mo hande ika꞉ mandakena꞉ pemeke wanda꞉hali ame̱le̱ amba꞉ pa꞉la꞉me hone wipikime. Kutupa nate homekena꞉ pota꞉ ipu hao welealo nane ipilika꞉ tapake make ipilika꞉ yankekemanu pitimiki alena꞉ opolo a꞉pa Yesu weimea pominolo hata꞉ lota꞉ putia pomipikime. ");
INSERT INTO ssx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kutu pipikipate Yesuta꞉ ota꞉ na handa꞉ u haota꞉ Diutuseleme nane paa la꞉ka꞉la pulu hata꞉ weiya꞉tiki pepekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nate tepo peaota꞉ oli yeni pu haemeke da pa꞉ta꞉ Yesu pitiekeeki handa꞉ wipikime. Yesuta꞉ mo Diu wanda꞉halina꞉ pi walo hayeke haliweki ame̱le̱ pita꞉ ika꞉ pi opitolo hata꞉ make lota꞉ pita꞉la꞉ ekimanu pitolo pitimikime ");
INSERT INTO ssx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yesuma꞉ta꞉ tandapiki hombo peatiki pieke ekina꞉ mo ipika꞉ pi opimiki wanda꞉hali paeyaota꞉ penkilipa꞉tia pomimikime. ");
INSERT INTO ssx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ipika꞉ apa꞉ ama꞉ yaapoma꞉ta꞉ Yesu hando haota꞉ penkilipa꞉tia pomipikime. Kutupa Yesuna꞉ ama꞉ma꞉ alota꞉ Ya wekio. Ekipeke nakana꞉ma꞉ diki pa꞉ta꞉ dupiki hau pea pelepe. Neke weitolo hata꞉ naka꞉ apa꞉ dikana꞉ma꞉ pomoma꞉ wotu homopa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesuma꞉ inkikina꞉ pi hombo peaaso alota꞉ Ekipeke ipilikana꞉ma꞉ I̱ weiya꞉ mea pomua pelepepe. I̱ta꞉ yaka Apa꞉na꞉ da pa꞉ta꞉ pitoloeki ipilikana꞉ma꞉ta꞉ hone na wipipa꞉ laa loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Koto leekepate ipilikana꞉ma꞉ta꞉ koto ipikana꞉ma꞉ hombo peayeke pina꞉ teketa꞉ hone na wipikime. ");
INSERT INTO ssx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kutupata꞉ Yesuta꞉ ipika꞉ apa꞉ ama꞉ yaapona꞉ pi opua Na꞉sa꞉tete nane mandakena꞉ pemekeme. Kutupa ipika꞉ apa꞉ ama꞉ yaapona꞉ pi nate paeyao opua homu pea hayekeme. Kutu piekepate ipika꞉ ama꞉ma꞉ta꞉ mo hande lemeke pimanu paeyaota꞉ hone na yonka꞉lake hone pa wia hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kutupa Yesuta꞉ epeke honema꞉ tumba꞉tia daetolo hata꞉ kenke wanda꞉halina꞉ make Koda꞉na꞉ hone pa꞉la꞉ ekina꞉ make daeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mo Loma꞉ Kapomani titina꞉ You hali Sisa Taibitiasi ipika꞉ bapi 15 peao handeteke hayeke da yu paeyaota꞉ pa handeteke hayekeme. Koto pita꞉ma꞉ta꞉ ipikana꞉ma꞉ mea haena꞉ leeke Kapomani you haliweki manuma꞉ ika꞉ handeteke hatia epena꞉ leeke kenke manuta꞉ dupa handeteke haemekeme. Pontiasi Pailedita꞉ Diudia kenke handeteke hayekeme. Hetodita꞉ Ka꞉lili kenke handeteke hayekeme. Kutupa Hetodina꞉ hameke Pilipita꞉ Idulia make Data꞉kenaidisi koto kenke yaapo handeteke hayekeme. Laisaniasita꞉ Abilini kenke handeteke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Koto pita꞉ma꞉ kone A꞉nasi Kaiya꞉pasi yaapota꞉ Koda꞉na꞉ yeni peao haepeke you hali haena꞉ta꞉ mo hapu hayeke alena꞉ hayeke hali Sekataiyana꞉ eiyeke Dioni pa꞉ta꞉ta꞉ Koda꞉na꞉ pi epeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kutu pieke handaata꞉ Dionima꞉ mo Diodani ikali tea꞉na꞉ wieke yu paeyao pa꞉ta꞉ Koda꞉na꞉ pi latiki pomuolo hata꞉ alota꞉ Wanda꞉halio. Iki paeyaoma꞉ ika꞉ amba꞉ pimi haumanu make ika꞉ honemanu make la꞉ka꞉la꞉ minaata꞉ bapitaisi peano lapa꞉peke. Koto haumanu ota꞉ pimika꞉na꞉ta꞉ kota꞉ Koda꞉ma꞉ ika꞉ pimi haumanu paeyaosiki paeyaaso hata꞉ paa na niminaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Koto Dionima꞉ pieke ekita꞉ amba꞉ titina꞉ Koda꞉na꞉ pi la halo hayeke hali ma꞉nda꞉ bikita꞉ Aisaya ipikana꞉ma꞉ bukana꞉ wape pea ula꞉ ekita꞉ dupa la꞉la꞉me. Hali ma꞉nda꞉ma꞉ hapupapeke alena꞉ hata꞉ wi laa dupiki pi ala꞉me. Tekehalina꞉ pota꞉ tikitiki yao wia꞉pa꞉peke. Ipiki epeke tupa꞉ epena꞉ mo ipika꞉ pota꞉ wamo peao mea tikitiki yao epeapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kutupata꞉ mo hawete manuta꞉ mea tumbapa꞉peke. Mo yu elimanu make mo potemanu make paeyao ao tumbaota꞉ mandake pina꞉ lapa꞉peke. Kutu pitolo hata꞉ mo pota꞉ hoihoi pa꞉la꞉ ekimanu make ota꞉ epeke tupa꞉ tikitikina꞉ mea epeaaso hata꞉ mo hana꞉manu pota꞉na꞉ wekila꞉la꞉ ekimanu make ota꞉ epeke tupa꞉ tikitiki yao epeapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kutu pimikina꞉ta꞉ kota꞉ wanda꞉hali paeyaoma꞉ Koda꞉na꞉ kita꞉la꞉ da꞉ta꞉la꞉eki handilimikie laa la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Koto dina꞉ta꞉ wanda꞉hali wotuma꞉ Dionima꞉ iki bapitaisi peaena꞉yeke paeyao epemekeme. Kutu pimiki handaa Dionima꞉ koto wanda꞉hali pa꞉ta꞉ alota꞉ Ikita꞉ ketomanue. Ikita꞉ Koda꞉ma꞉ teke pa꞉ta꞉ epena꞉ lolo pa꞉la꞉ mineke panka꞉la꞉ ekita꞉ wonduluekema꞉ hamena꞉ laa ma꞉nda꞉ epita꞉ pindipa pelimiki pita꞉ epima꞉ kinki pa꞉la꞉pe. ");
INSERT INTO ssx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ika꞉ pimi hoke haumanu paeyao amba꞉ hoki waleme ekina꞉ wanda꞉halima꞉ handena꞉ mo epeke kiliki a꞉ela꞉ tima꞉ pa꞉la꞉eki pina꞉ epeke haumanu pea꞉pa꞉peke. Koto ekina꞉ta꞉ ikana꞉ma꞉ Nika꞉ meita꞉ Eipoloha꞉ma꞉e laa kutupiki pimanu na lapa꞉peke laata꞉ Dionima꞉ iki pa꞉ta꞉ alota꞉ Opua꞉pe. Koda꞉ma꞉ do toopimanu meaata꞉ Eipoloha꞉ma꞉na꞉ mondu semba꞉lala꞉ wanda꞉hali ana꞉na꞉ wepia haena꞉ lapeke ya꞉la꞉me alome. ");
INSERT INTO ssx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hande hapula꞉ ti manuna꞉ teke pa꞉ta꞉ pokuluekema꞉ manda꞉ meaowa꞉me leekeme. Epeke kiliki na a꞉eya꞉la꞉ timanu paeyao siki poko lopaota꞉ ti talo hala꞉ pa꞉ta꞉ paeyao siki mu yankilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Do pimanu opua mo wanda꞉halima꞉ Dioni pa꞉ta꞉ lota꞉ pitolo hata꞉ alota꞉ Kota꞉ nikana꞉ma꞉ta꞉ eki hau peomonope lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dionima꞉ ika꞉ pi hombo peaaso hata꞉ alota꞉ Hali ma꞉nda꞉ma꞉ ipika꞉ dau yaapo wia꞉ka꞉na꞉ta꞉ kota꞉ ma꞉nda꞉ta꞉ mo dau dia꞉ya꞉la꞉ natehali ma꞉nda꞉ pa꞉ta꞉ hala꞉peke. Kutupa make ne napekeeki wia꞉ka꞉na꞉ta꞉ kota꞉ ne dia꞉ya꞉la꞉ wanda꞉halimanu pa꞉ta꞉ telipea hala꞉pa꞉pekee leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Koto natena꞉ta꞉ mo mandane dakisi mani mu haemeke haliwekima꞉ Dionima꞉ iki bapitaisi peaena꞉ ipiki a꞉pa lota꞉ pitolo alota꞉ Wala꞉la꞉ halio. Nikana꞉ma꞉ta꞉ eki hau piomonope laa lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Koto lemeke Dionima꞉ hombo peaaso alota꞉ Ikana꞉ma꞉ mo wanda꞉halina꞉ dakisi mani mimika꞉na꞉ta꞉ kota꞉ haka꞉ta꞉pao na miki mo Kapomanina꞉ Lo pima꞉ tombo ula꞉ tupa꞉ mia꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mandane ami haliwekima꞉ make a꞉pa lota꞉ pitolo hata꞉ alota꞉ Nikana꞉ma꞉ make ekipiki haumanu peomonope lemekeme. Koto lemeke Dionima꞉ iki pa꞉ta꞉ alota꞉ Ma꞉nda꞉na꞉ mani pake muluekema꞉ paala꞉ tiao o yayapiki ekina꞉ pa hameke la꞉ tiaasa꞉eki ota꞉ na pea꞉pa꞉peke. Kutupa ika꞉ e pokaasemeke kita꞉la꞉ yenkita꞉ ana꞉na꞉ kita꞉la꞉me hone wia꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mo wanda꞉halima꞉ koto haumanu paeyao handaata꞉ ika꞉ puki pa꞉ta꞉ hayeke ale tialu baeyeke ekima꞉ta꞉ ikana꞉ma꞉ hone eleke eleke witolo hata꞉ta꞉ do Dionita꞉ hande Ketiso pateya꞉la꞉me laa hone wimikime. ");
INSERT INTO ssx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Koto ekina꞉ Dionima꞉ iki pa꞉ta꞉ alota꞉ I̱ma꞉ ikita꞉ ikalima꞉ bapitaisi peao halopate hali ma꞉nda꞉ wetepena꞉ ipilia꞉ halita꞉ ota꞉ honkopu wotu hala꞉me. I̱ta꞉ ipiki yaapo ana꞉ pea꞉peke na ya꞉la꞉me. Ipika꞉ anke dake holaapeke make I̱ta꞉ ana꞉ na pa꞉la꞉me leekeme. Ipikana꞉ma꞉ ikita꞉ Holi Sipitidi pita꞉ ti uleke yaapoma꞉ bapitaisi pealieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ipikana꞉ma꞉ mo hande widi kilikina꞉ ambuku napeke yaapo putupa alu puluekema꞉ pana꞉pulu pa꞉la꞉ sa꞉sata꞉ ipika꞉ kikina꞉ miniki hala꞉me. Ipika꞉ widi kiliki epekeeki paeyaota꞉ ipika꞉ widi napeke u hala꞉ da pa꞉ta꞉ momba꞉la wilieke. Pate mo ambuku paeyaota꞉ tina꞉ pana꞉pu yankilieke. Koto tita꞉ na paeyeke pa to halieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mo wanda꞉hali ika꞉ hoke haumanu hoki wala puki hone lekelena꞉yeke Dionima꞉ Koda꞉na꞉ Pi Seliapomanu ota꞉ epeke tupa꞉ la hala꞉tiki pominolo hata꞉ wanda꞉hali sutiatia pua꞉tiki pomiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Koto pa꞉la꞉pate Dionima꞉ mo kapomani hali tieke Hetodi pa꞉ta꞉ la halolo hata꞉ alota꞉ Neketa꞉ hoke haumanu peleme laa la haleekeme. Ekipeke. Hetodi ipika꞉ hamekena꞉ weteke Hetodiasi pa ipika꞉ handa꞉mea make ipikana꞉ma꞉ ti teke wotu yoka꞉tiki pomieke handa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Koto leeke ekina꞉ Hetodi ipikana꞉ma꞉ Dioni dipula mea lopaeyeke ekima꞉ta꞉ mo ipika꞉ amba꞉ pieke hoke haumanu paeyaota꞉ koto ekima꞉ lu ankula yeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kutupa Dionima꞉ wanda꞉hali paeyao siki bapitaisi hau peaota꞉ wetepe nane Yesu make bapitaisi hau peayekeme. Kutupa Yesuma꞉ yeni pitolo haena꞉ta꞉ oli hepeni lumba ");
INSERT INTO ssx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","mo Holi Sipitidita꞉ ba melipuma꞉ handekeeki hola꞉pa꞉niao Yesuna꞉ lokena꞉ a꞉pa holopeekeme. Kutaa oli ya nanema꞉ pi ho̱la̱꞉make homekema꞉ pi alo alota꞉ Neketa꞉ ota꞉ yaka puki piki wekie. Yaka pukima꞉ neke pa꞉ta꞉ ta꞉na꞉ma꞉ wotu homolome leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu ipika꞉ bapita꞉ hali tieke homeke paeyao kiki yaapo bapimanu tupa꞉ yeketa꞉ ipika꞉ e kinipea pokeekeme. Mo wanda꞉halima꞉ hone witolota꞉ ipikita꞉ Diosepena꞉ eiyekee hone wimikime. Diosepe ipikita꞉ Helina꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Helita꞉ Madadina꞉ eiyeke hayekeme. Madadita꞉ Lipaena꞉ eiyeke hayekeme. Lipaeta꞉ Mela꞉kina꞉ eiyeke hayekeme. Mela꞉kita꞉ Dia꞉naina꞉ eiyeke hayekeme. Dia꞉naita꞉ Diosepena꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Diosepeta꞉ Mataatiasina꞉ eiyeke hayekeme. Mataatiasita꞉ Amosina꞉ eiyeke hayekeme. Amosita꞉ Nahumina꞉ eiyeke hayekeme. Nahumita꞉ Eselina꞉ eiyeke hayekeme. Eselita꞉ Nakaina꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakaita꞉ Maadina꞉ eiyeke hayekeme. Maadita꞉ Mataatiasina꞉ eiyeke hayekeme. Mataatiasita꞉ Semenina꞉ eiyeke hayekeme. Semenita꞉ Diosekina꞉ eiyeke hayekeme. Diosekita꞉ Diodana꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Diodata꞉ Dioananina꞉ eiyeke hayekeme. Dioananita꞉ Etesana꞉ eiyeke hayekeme. Etesata꞉ Setubabelena꞉ eiyeke hayekeme. Setubabeleta꞉ Sieletielina꞉ eiyeke hayekeme. Sieletielita꞉ Netina꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Netita꞉ Melekina꞉ eiyeke hayekeme. Melekita꞉ A꞉dina꞉ eiyeke hayekeme. Adita꞉ Kosamina꞉ eiyeke hayekeme. Kosamita꞉ Elemadamina꞉ eiyeke hayekeme. Elemadamita꞉ A꞉eta꞉na꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","A꞉eta꞉ta꞉ Diosuana꞉ eiyeke hayekeme. Diosuata꞉ A꞉liesana꞉ eiyeke hayekeme. A꞉liesata꞉ Diotamana꞉ eiyeke hayekeme. Diotamata꞉ Madadina꞉ eiyeke hayekeme. Madadita꞉ Lipaena꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lipaeta꞉ Simionina꞉ eiyeke hayekeme. Simionita꞉ Diudana꞉ eiyeke hayekeme. Diudata꞉ Diosepena꞉ eiyeke hayekeme. Diosepeta꞉ Dionamena꞉ eiyeke hayekeme. Dionameta꞉ Elaia꞉kimina꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaia꞉kimita꞉ Meleana꞉ eiyeke hayekeme. Meleata꞉ Menana꞉ eiyeke hayekeme. Menata꞉ Madadana꞉ eiyeke hayekeme. Madadata꞉ Neidanina꞉ eiyeke hayekeme. Neidanita꞉ Deipidina꞉ eiyeke hayekeme. Deipidita꞉ Diesina꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Diesita꞉ Obedina꞉ eiyeke hayekeme. Obedita꞉ Boa꞉sina꞉ eiyeke hayekeme. Boa꞉sita꞉ Sa꞉limonina꞉ eiyeke hayekeme. Sa꞉limonita꞉ Na꞉sionina꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na꞉sionita꞉ Amina꞉da꞉bena꞉ eiyeke hayekeme. Amina꞉da꞉beta꞉ A꞉da꞉minina꞉ eiyeke hayekeme. A꞉da꞉minita꞉ Anina꞉ eiyeke hayekeme. Anita꞉ Hesotonona꞉ eiyeke hayekeme. Hesotonota꞉ Petesena꞉ eiyeke hayekeme. Peteseta꞉ Diudana꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Diudata꞉ Dieikopena꞉ eiyeke hayekeme. Dieikopeta꞉ Aisa꞉kena꞉ eiyeke hayekeme. Aisa꞉keta꞉ Eipoloha꞉ma꞉na꞉ eiyeke hayekeme. Eipoloha꞉ma꞉ta꞉ Titana꞉ eiyeke hayekeme. Titata꞉ Neihona꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neihota꞉ Setakona꞉ eiyeke hayekeme. Setakota꞉ Eteyuna꞉ eiyeke hayekeme. Eteyuta꞉ Pelekena꞉ eiyeke hayekeme. Peleketa꞉ Ebena꞉ eiyeke hayekeme. Ebeta꞉ Silana꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Silata꞉ Keinanina꞉ eiyeke hayekeme. Keinanita꞉ Apa꞉ka꞉sa꞉dina꞉ eiyeke hayekeme. Apa꞉ka꞉sa꞉dita꞉ Siemena꞉ eiyeke hayekeme. Siemeta꞉ Noana꞉ eiyeke hayekeme. Noata꞉ Lamekena꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameketa꞉ Madiuselana꞉ eiyeke hayekeme. Madiuselata꞉ Inokana꞉ eiyeke hayekeme. Inokata꞉ Dia꞉tedina꞉ eiyeke hayekeme. Dia꞉tedita꞉ Mahalalielina꞉ eiyeke hayekeme. Mahalalielita꞉ Kenanina꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenanita꞉ Inosina꞉ eiyeke hayekeme. Inosita꞉ Sedena꞉ eiyeke hayekeme. Sedeta꞉ A꞉da꞉ma꞉na꞉ eiyeke hayekeme. A꞉da꞉ma꞉ta꞉ Koda꞉na꞉ eiyeke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesuta꞉ mo Diodani ikali mina꞉pa꞉lao paa epeeke pita꞉ma꞉ta꞉ mo Holi Sipitidima꞉ ipiki pa꞉ta꞉ ota꞉ tumbiekeme. Koto dina꞉ta꞉ mo hande Holi Sipitidima꞉ Yesuta꞉ hapupapeke alena꞉ hatuku peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Koto pa꞉ta꞉ta꞉ nate hali tieke yaapo pa꞉ta꞉ Sadanima꞉ Yesu a꞉pa la handa꞉tiki piekeme. Koto hali tieke yaapo nate manuna꞉ta꞉ Yesuma꞉ ala꞉ta꞉ ma꞉nda꞉ siki make ota꞉ na neeke ekima꞉ tea꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kutupa Sadanima꞉ Yesu pa꞉ta꞉ alota꞉ Neketa꞉ ota꞉ Koda꞉na꞉ Eiyeke ya꞉ka꞉na꞉ta꞉ kota꞉ do toopi kone palaowa au lapeke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesuma꞉ mo Sadanina꞉ pi litolo hata꞉ alota꞉ Mo Baiboloma꞉ alota꞉ Halima꞉ palaowa homeke naa na hapeke ya꞉la꞉me laa la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kutupa mo Sadanima꞉ Yesu oli manda hatuku pua mo kenkena꞉ kilu tombuao hala꞉ ekimanu paeyao siki ti tekele pea ipiki pa꞉ta꞉ waleekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kutu pitolo hata꞉ mo Sadanima꞉ Yesu pa꞉ta꞉ alota꞉ Mo alemanu paeyaota꞉ I̱ pa꞉ta꞉ ka꞉la꞉pate yaka honema꞉ta꞉ hali ma꞉nda꞉ pa꞉ta꞉ haloa꞉ka꞉na꞉ta꞉ ota꞉ ana꞉ pilieke. Koto ekina꞉ta꞉ mo kilu tombuao hala꞉ ekimanu paeyao pita꞉ ika꞉ hamoko alemanu paeyao telipina꞉ nakana꞉ma꞉ handeteke halena꞉ neke kuluekema꞉ ");
INSERT INTO ssx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","neketa꞉ ya biki laaluekema꞉ panda꞉ puniaeka꞉na꞉ta꞉ do alemanu paeyaota꞉ naka꞉eki yelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Koto leeke Yesuma꞉ alota꞉ Mo Baiboloma꞉ dupa la꞉la꞉me. Tekehali naka꞉ Koda꞉ ipiki pa꞉ta꞉ homeke yeni pu hata꞉ e poko hapeke laa la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pa mo Sadanima꞉ Yesu mo Diutuseleme nane yeni pu haemeke da tiekena꞉ holu manda hatuku pua haena꞉ leekeme. Kutupa Sadanima꞉ Yesu pa꞉ta꞉ alota꞉ Neketa꞉ ota꞉ Koda꞉na꞉ Eiyeke ya꞉ka꞉na꞉ta꞉ do alena꞉ hao oni kenkena꞉ naka꞉ kone lopa꞉niae. ");
INSERT INTO ssx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kutu pikina꞉ta꞉ mo Baiboloma꞉ la꞉la꞉ tupa꞉ Koda꞉ma꞉ ipika꞉ enisolo tonuma꞉ neke epeke tupa꞉ handeteke haena꞉ laa pi lelieke la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kutupa mo Baiboloma꞉ paa la꞉la꞉ tupa꞉ Koto enisolo tonuma꞉ toopi ponekema꞉ naka꞉ anke awaama꞉na꞉yeke ika꞉ kiki manuma꞉ neke miniliao handeteke halimikie laa la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Koto leekepate Yesuma꞉ ipika꞉ pi litolo hata꞉ alota꞉ Baibolo pima꞉ta꞉ do la꞉la꞉me. Tekehali naka꞉ Koda꞉ta꞉ na la handa꞉peke laa la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mo Sadanima꞉ Yesu pa꞉ta꞉ hoke la handa꞉la꞉ ekimanu ane mone eki paeyao siki peaata꞉ pa hosiki mina꞉pa꞉lao peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mo Holi Sipitidina꞉ honkopuma꞉ Yesu handeteke haena꞉ laa Yesu mo Ka꞉lili nane paa peekeme. Kutupa koto da yu paeyao pa꞉ta꞉ haemeke wanda꞉halima꞉ Yesuna꞉ biki kende tupa꞉ wina꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ipikana꞉ma꞉ Koda꞉na꞉ pi hotu haemeke damanu pa꞉ta꞉ pua꞉tiki pea wanda꞉hali pa꞉ta꞉ pi wala꞉tiki pomieke handaata꞉ mo wanda꞉hali paeyaoma꞉ ipika꞉ biki mea miniliatiki pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kutupa Yesu ipika꞉ daeyeke da Na꞉sa꞉tete da pa꞉ta꞉ pua ipika꞉ pu hayeke tupa꞉ Diu wanda꞉halina꞉ hoto pitu haemeke natena꞉ Koda꞉na꞉ pi hotu haemeke da pa꞉ta꞉ peekeme. Kutupa ipikana꞉ma꞉ mo Baibolo buka yata꞉puluekema꞉ yeke tiao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Hali ma꞉nda꞉ma꞉ mo Koda꞉na꞉ potopede hali Aisayama꞉ wape pu wieke buka Yesu pa꞉ta꞉ haleekeme. Kota꞉ Yesuma꞉ mo buka lombaata꞉ handa꞉tiki pua pi ma꞉nda꞉ dupa laeyekeeki handa꞉ witolo hata꞉ yata꞉peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","I̱ma꞉ natehali wanda꞉hali pa꞉ta꞉manu mo Pi Seliapomanu laanoyeke mo I̱ mea haena꞉ la꞉la꞉ Tekehalima꞉ ipika꞉ Sipitidi I̱ yaapo hala꞉me. Ipikana꞉ma꞉ I̱ tapaala꞉ ekita꞉ mo dipula pila꞉ wanda꞉hali ikita꞉ ka꞉la꞉pa꞉ tapao halememe lono make mo leke holupiki wanda꞉hali ikita꞉ ika꞉ leke manuma꞉ paa handilimikie laa lonoyeke tapaala꞉me. Kutupa make mo ika꞉ ka꞉nda꞉ manuma꞉ kone tekepa꞉ta꞉ hoeyaapeke ya꞉la꞉ wanda꞉hali ka꞉la꞉pa꞉ tapawano make ");
INSERT INTO ssx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","wanda꞉hali wotu pa꞉ta꞉ta꞉ Tekehalima꞉ ipika꞉ wanda꞉hali tamba꞉ mulu pa꞉la꞉ nate a꞉pa hala꞉me laa lono yeke I̱ tapaala꞉me laa leekeeki yata꞉peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesuma꞉ mo buka yata꞉paata꞉ amba꞉ bukamanu handeteke hayeke hali pa꞉ta꞉ paa hala꞉ moneao pitiniaeyekeme. Kota꞉ mo Koda꞉na꞉ pi hotu haemeke da pa꞉ta꞉ pitimiki wanda꞉hali paeyao sikima꞉ Yesu handolo hata꞉ yola꞉ pambemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kota꞉ Yesuma꞉ iki pa꞉ta꞉ pi alo hata꞉ alota꞉ Do yata꞉pa kua꞉ hande Baibolo pita꞉ ikana꞉ma꞉ opitolo hamena꞉ kone ota꞉ ame do kone yaya꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ipika꞉ leeke pi manuma꞉ tende pieke handaa iki paeyao siki leke opa penkiliputia pominolo hata꞉ make haleke lomba mo ikana꞉ma꞉ ipikina꞉ do pi lemekeme. Ipikita꞉ Diosepena꞉ eiyeke dia꞉yekea laa ika꞉ ika꞉ kone lota꞉ pu alu alu pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Koto lemeke handaa Yesuma꞉ mo wanda꞉hali pa꞉ta꞉ alota꞉ Ota꞉ loa꞉me laa Ikana꞉ma꞉ I̱ pa꞉ta꞉ make mo wanda꞉halima꞉ amba꞉ loma꞉ loma꞉ pa꞉la꞉me pi siki ma꞉nda꞉ dupa lelimikie. Dokeda halio. Naka꞉ yenita꞉ naka꞉ kone mea epeapeke lelimikie. Kutupa pi ma꞉nda꞉ make I̱ pa꞉ta꞉ dupa lelimikie. Hau ma꞉nda꞉ ma꞉nda꞉ mo Kapeneami teke da nane hata꞉ pi hande hau manuta꞉ nikana꞉ma꞉ amba꞉ opuma꞉me. Kota꞉ do naka꞉ ota꞉ teke da pa꞉ta꞉ make kutupiki homeke haumanu kone pie laa lelimikie laata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesuma꞉ iki pa꞉ta꞉ alota꞉ I̱ma꞉ iki pa꞉ta꞉ alome. Koda꞉na꞉ pi wala꞉la꞉ potopede hali ipika꞉ teke wanda꞉halima꞉ ipiki hone wotu na wilimikie. ");
INSERT INTO ssx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Opua꞉pe. I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Mo Elaidia hayeke dina꞉ta꞉ kineke wanda꞉ sunuta꞉ wotu aneke hapu mo Isulai da yu pa꞉ta꞉ haemekeme. Koto natena꞉ bapi tepona꞉ sumba꞉ yunki mindiki hata꞉ lako ota꞉ na a꞉paata꞉ da yu paeyao pa꞉ta꞉ tea꞉ma꞉ homa꞉la꞉eki wotu aneke hapu epeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kutu piekepate Koda꞉ma꞉ Elaidiata꞉ Isulai da yu pa꞉ta꞉ hayeke wanda꞉hali ma꞉nda꞉ pa꞉ta꞉ na tapaeyekepate ipikita꞉ mo Saidoni da yu tukiki pa꞉ta꞉ hayeke teke da Sa꞉tepa꞉di hayeke kineke wanda꞉ homeke pa꞉ta꞉ tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kutupa make Koda꞉na꞉ pi la꞉ mea halo hayeke hali Elaisa hayeke dina꞉ta꞉ kindi yeni homo haemeke wanda꞉hali wotu anekema꞉ mo Isulai da yu pa꞉ta꞉ haemekepate Koda꞉ma꞉ koto wanda꞉halita꞉ ota꞉ ma꞉nda꞉ hondo na mea epeaeyekepate pa Sitia da yu pa꞉ta꞉ hayeke hali Neimana꞉ homeke mea epeaeyekeme leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mo Koda꞉na꞉ pi hotu haemeke da pa꞉ta꞉ pitimiki wanda꞉halima꞉ koto pi leekeeki opua ikana꞉ma꞉ mineke tieke wotu pankemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kutupa ikana꞉ma꞉ tiao Yesu minaa ika꞉ teke da mina꞉pa꞉lao hama nane yolaa pemekeme. Mo ika꞉ teke data꞉ pote elina꞉ hayekeeki yaalo Yesu mo pote elina꞉ hatuku pua oni paeleke alena꞉ poneke wato lopaaluekema꞉ hatuku pemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kutu pimikipate Yesuta꞉ mo wanda꞉hali anka꞉lopuna꞉ pa꞉ta꞉ kone pa pa꞉nka꞉pa peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kutupa Yesuta꞉ mo Ka꞉lili da yu pa꞉ta꞉ hayeke teke da Kapeneami nane peekeme. Puaata꞉ mo hoto pitu haemeke natena꞉ wanda꞉hali pa꞉ta꞉ pi waleekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mo wanda꞉halima꞉ta꞉ Yesuma꞉ waleekeeki opuaata꞉ leke opo handake wimikime. Pa ekipeke. Ipikana꞉ma꞉ biki ula꞉ halima꞉ wala꞉la꞉ tupa꞉ waleeke handaa pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mo pi hotu haemeke da pa꞉ta꞉ta꞉ hoke temoko pitieke hali ma꞉nda꞉ hayekeme. Koto halima꞉ Yesu handaata꞉ ipiki pa꞉ta꞉ wi aneke hapu la alota꞉ ");
INSERT INTO ssx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ae. Yesu Na꞉sa꞉tete da halio. Nakana꞉ma꞉ta꞉ niki ame̱le̱ eki puluekema꞉ a꞉pa pipa꞉ laata꞉ Neke epele ekita꞉ niki paeyao mea hoeyaaluekema꞉ a꞉pa pipe. Neketa꞉ I̱ma꞉ hone witolome. Neketa꞉ Koda꞉ma꞉ tapaeya꞉ yako piki hali ya꞉ka꞉ta꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Koto ekina꞉ Yesuma꞉ mo hoke temoko pa꞉ta꞉ tandapiki pi alo hata꞉ alota꞉ Neketa꞉ koto hali ota꞉ mina꞉pa꞉lao naka꞉ pi na leke a̱i̱ hosiki ya꞉la꞉na꞉ kone yopue leekeme. Koto pi leekeeki opua mo hoke temokoma꞉ mo wanda꞉halina꞉ leke taapuna꞉ mo hali mea wato lopao yopusiki hama nane opolu baeyekepate mo halina꞉ loke ma꞉nda꞉ na mea hoeyaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Koto eki handaata꞉ wanda꞉hali paeyao sikima꞉ penkilipa꞉tia pomua ika꞉ ika꞉ kone pi la alu alu pitolo hata꞉ alota꞉ Dota꞉ ekipiki pimanu ala꞉pe laata꞉ Do halita꞉ you hali ma꞉nda꞉ma꞉ leke nono pita꞉la꞉ tupa꞉ mo hoke temokomanu pa꞉ta꞉ dupi dupi aleke handaa hama ipulimime lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Koto ekina꞉ta꞉ wanda꞉hali manuma꞉ Yesuma꞉ pieke ekimanu handaata꞉ da yu ma꞉nda꞉ ma꞉nda꞉ pa꞉ta꞉manu kendetia pomimikime. ");
INSERT INTO ssx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu mo Koda꞉na꞉ pi hotu haemeke da mina꞉pa꞉laota꞉ Saimonona꞉ da pa꞉ta꞉ peekeme. Saimonona꞉ meiyeke wanda꞉ta꞉ titipu yeni tiekema꞉ homa꞉pa wieke handaa ikana꞉ma꞉ Yesu pa꞉ta꞉ mo wanda꞉na꞉ yeni hayeke tupa꞉ la halemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kota꞉ ipiki pua mo wanda꞉ homa꞉pa wieke alena꞉ pa꞉ta꞉liki nane pua tiao hata꞉ mo hande titipu yeni hayeke ekima꞉ mo wanda꞉ mina꞉pa꞉laena꞉ tanda piki pi leekeme. Kutupiki pi leeke handaata꞉ mo yenima꞉ mo wanda꞉ mina꞉pa꞉lao tandela꞉pa yapeeke handaata꞉ koto kone mo wanda꞉ma꞉ tiao hata꞉ mo tapakena꞉ ne wamo peayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nate amba꞉ pambeeke hoki naneta꞉ wanda꞉halima꞉ ika꞉ yankeke sunu ane mone yeni manuma꞉ homa꞉pa wia꞉tiki pimiki yeke handaa Yesu teke pa꞉ta꞉ mea epemeke handaa ipikana꞉ma꞉ ipika꞉ kiki iki manda wia꞉tiki pieke handaa paeyao mea epeatiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kutupata꞉ mo hoke temoko manuma꞉ wanda꞉hali aneke tukiki pa꞉ta꞉ pita e̱ la꞉tiki yopulu hata꞉ alota꞉ Neketa꞉ Koda꞉na꞉ eiyekee lemekeme. Yesuma꞉ mo hoke temoko manuma꞉ pi ma꞉nda꞉ laama꞉na꞉ pi taka꞉lake leekeme. Pa ekipeke. Ika꞉ hone wimikipate ipikita꞉ hande Mesaya yeke handaa pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Da panake kelepolo haena꞉ Yesu ipikita꞉ koto teke da mina꞉pa꞉lao wanda꞉hali na hala꞉ da yu ma꞉nda꞉ pa꞉ta꞉ ipika꞉ honumake siki peekeme. Kota꞉ mo wanda꞉halima꞉ Yesu ipiki pu moneaekeeki weitia pomu hao ipiki hayeke pa꞉ta꞉ pua handa꞉ witolota꞉ ika꞉ ta꞉na꞉ piki ekita꞉ Yesuma꞉ iki na kiao pena꞉ hone wia sa꞉sa꞉ puluekema꞉ taapemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Koto hau pimikipate Yesuma꞉ iki pa꞉ta꞉ alota꞉ Koda꞉ma꞉ I̱ tapaala꞉ ekita꞉ ipika꞉ Kilu Tombuao Hala꞉ ekina꞉ Pi Seliapo mandane teke da ma꞉nda꞉ ma꞉nda꞉ pa꞉ta꞉ haleme wanda꞉halimanu pa꞉ta꞉ make walono yeke I̱ tapaeya꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Koto ekina꞉ta꞉ mo da yu paeyao pa꞉ta꞉ ika꞉ pi hotu haemeke da pa꞉ta꞉manu pomu lopa꞉tia pominolo hata꞉ Koda꞉na꞉ pimanu walao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nate ma꞉nda꞉na꞉ Yesuta꞉ mo Kenesatete ikali leke wieke ikali tea꞉ nane haena꞉ta꞉ wanda꞉hali aneke wopuma꞉ Koda꞉na꞉ pi opuluekema꞉ yeke ika꞉ ika꞉ kone pendilatia pulu hata꞉ titi ata꞉ta꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesuma꞉ mo ikali tea꞉na꞉ kawaso yaapo wiekeeki handeekeme. Mo kawaso teke haliwekita꞉ ika꞉ kawaso yaapo mina꞉pa꞉laota꞉ ika꞉ tenkinumanu tandepolo pitimikime. ");
INSERT INTO ssx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kutupa Yesuta꞉ Saimono ipika꞉ kawasona꞉ opa꞉liao ipikana꞉ma꞉ Saimono pa꞉ta꞉ alota꞉ Naka꞉ kawaso mo ikali houna꞉ hosiki siki mo pate leke mea pue laa mo kawasona꞉ pita꞉ wanda꞉hali pa꞉ta꞉ Koda꞉na꞉ pimanu waleekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Koto hande pi walo paeyao wetepe naneta꞉ Yesuma꞉ Saimono pa꞉ta꞉ alota꞉ Nakana꞉ma꞉ naka꞉ kawaso mo ikali noka꞉ ula꞉ alena꞉ leke pendila moneae laata꞉ Neke make naka꞉ ta꞉ma꞉ni tonu ame̱le̱ ika꞉ tenkinu paeyao do ikali pa꞉ta꞉ ta꞉peli muemena꞉ lopape leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Koto leeke handaa Saimonoma꞉ ipika꞉ pi litolo hata꞉ alota꞉ Tekehalio. Do timba andusa꞉na꞉ niki paeyaoma꞉ e tieke pokoma꞉pate ta꞉peli ota꞉ homeke siki a꞉nda꞉ make na muma꞉pate nakana꞉ma꞉ aleke handaata꞉ mo tenkinu paeyao paa ikali pa꞉ta꞉ lopanoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kotoeki pimiki dina꞉ta꞉ ikana꞉ma꞉ ta꞉peli ota꞉ wotu aneke hapu mimiki yeke handaata꞉ mo hande tenkinu paeyaota꞉ tumbulu baasota꞉ tunkuluekema꞉ taapeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kutu pieke handaa mo kawaso ma꞉nda꞉na꞉ pitimiki haliwekima꞉ ika꞉ ta꞉ma꞉ni tonuma꞉ iki tamba꞉ mulu epena꞉ yeke kiki wanke pitolo hata꞉ ipupa꞉ laa lemekeme. Iki a꞉paata꞉ mo ta꞉pelimanu paeyao siki mo kawaso yaapona꞉ mea wimiki ekima꞉ mo hande kawaso yaapota꞉ ikali pa꞉ta꞉ honki loluekema꞉ taapepekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kutu piekeeki handaata꞉ Saimono Pidama꞉ Yesu teke pa꞉ta꞉ tumiki yotuao alota꞉ Tekehalio. I̱ta꞉ hoke hau polo somema꞉ I̱ kiao pue leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimono ipiki ame̱le̱ haemeke haliweki ika꞉ tenkinu paeyao siki pa꞉ta꞉ ta꞉peli wotu anekema꞉ mu wimikieki handaata꞉ penkilipa꞉tia pomimikime. ");
INSERT INTO ssx_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimono ipika꞉ ta꞉ma꞉ni pieke hama̱la̱꞉ Sepedina꞉ eiyeke yaapo Dia꞉mesi Dioni yaapoma꞉ make penkilipa꞉tia pomipikime. Yesuma꞉ Saimono pa꞉ta꞉ alota꞉ Nakana꞉ma꞉ paala꞉ma꞉ na homa꞉peke laata꞉ Ekipeke ame do kini peaata꞉ nakana꞉ma꞉ pa haliweki mealipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Koto ekina꞉ta꞉ mo kawaso yola꞉ mea mo ikali tea꞉na꞉ mea wiata꞉ ika꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao mina꞉pa꞉lao Yesuna꞉ hoki nane teli mea pemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nate ma꞉nda꞉na꞉ Yesuta꞉ mo kindi yenima꞉ loke paeyao tumbieke hali ma꞉nda꞉ hayeke daoni ma꞉nda꞉ pa꞉ta꞉ hayekeme. Koto halima꞉ Yesu handaata꞉ ipiki teke pa꞉ta꞉ a꞉pa oni kenkena꞉ lopolo hata꞉ alota꞉ Tekehalio. Nakana꞉ma꞉ hone pia꞉ka꞉na꞉ta꞉ I̱ mea epeapeke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Koto leeke pi opua Yesuma꞉ ipika꞉ kiki tindipao mo halina꞉ lokena꞉ wataaso hata꞉ alota꞉ I̱ma꞉ ya hone pa꞉la꞉me. Naka꞉ loke epena꞉e. Koto leeke handaata꞉ koto kone mo kindi yeni hayekeeki tandela꞉pa peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesuma꞉ pi honkopu hao ipiki pa꞉ta꞉ alota꞉ Do pitolo ekita꞉ ma꞉nda꞉ pa꞉ta꞉ a̱i̱ na leketa꞉ pa mo yeni peao hala꞉ halima꞉ titina꞉ amba꞉la naka꞉ yeni ota꞉ paela꞉pe laa handena꞉ a̱i̱ ipiki pa꞉ta꞉ pua꞉peke. Kutaata꞉ wanda꞉halima꞉ naka꞉ yenita꞉ ota꞉ paela꞉me hone wina꞉ mo hande Mosesima꞉ la꞉ wieke tupa꞉ Koda꞉ pa꞉ta꞉ lia hala꞉la꞉ ale lia hala꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Koto pi leeke pateta꞉ wanda꞉hali paeyaoma꞉ Yesuma꞉ pieke ekimanu da yu paeyao pa꞉ta꞉ la꞉tiki pomimikime. Koto ekina꞉ta꞉ wanda꞉hali aneke hapuma꞉ Yesu ipika꞉ leeke pimanu opua make ipikana꞉ma꞉ ika꞉ yenimanu mea epeaena꞉ yeke epemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kutu pimikipate Yesuma꞉ mo wanda꞉hali na hayeke alena꞉ pua Koda꞉ pa꞉ta꞉ yeni puluekema꞉ pua꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nate ma꞉nda꞉na꞉ Yesuma꞉ wanda꞉hali pa꞉ta꞉ Koda꞉na꞉ pi walolo haena꞉ta꞉ mandane Pa꞉tisi haliweki make mo Lo Pimanu wala꞉la꞉ haliweki make pitimikime. Koto haliwekita꞉ Ka꞉lili kenke pa꞉ta꞉ hala꞉ daonimanu make Diudia kenke pa꞉ta꞉ hala꞉ daonimanu make mo Diutuseleme teke da pa꞉ta꞉ make a꞉pa pitimikime. Koto natena꞉ta꞉ mo yeni homemeke wanda꞉hali paeyao Yesuma꞉ mea epeaena꞉ mo Tekehali Koda꞉na꞉ weleta꞉ ipiki pa꞉ta꞉ aneke hapu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mandane haliwekima꞉ta꞉ mo kiki anke lupa wiki some ma꞉nda꞉ tilina꞉ mea tia a꞉paata꞉ ipiki mo da tukiki pa꞉ta꞉ tia pua Yesuna꞉ leke tonkona꞉ pua tu uluekema꞉ taapemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kutu pimikipate polo pimiki pota꞉ta꞉ wanda꞉hali wotu aneke hapuma꞉ tumbieke handaata꞉ ikana꞉ma꞉ mo hali da tukiki pa꞉ta꞉ tia pua꞉peke pota꞉ ma꞉nda꞉ na wiekeme. Koto ekina꞉ta꞉ mo haliwekima꞉ hande da holuna꞉ mea opa꞉liao ka꞉ka꞉na꞉ mea wiao ipika꞉ loketa꞉ tilina꞉ wia mo wanda꞉hali anka꞉lopuna꞉ Yesu hayeke alena꞉ uniaemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kutupa Yesuma꞉ mo haliwekina꞉ hone tulaemekeeki handaata꞉ ipikana꞉ma꞉ mo kiki anke lupa wiki hali pa꞉ta꞉ alota꞉ Kame. Naka꞉ hande pi hoke hau manuta꞉ pa paeyaasa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Koto leekeeki opuaata꞉ mo Lo Pimanu wala꞉la꞉ haliweki make mo Pa꞉tisi haliweki paeyaoma꞉ ika꞉ ika꞉ kone pi pi alo alota꞉ Mo Koda꞉na꞉ biki hoeyaaso pimanu ala꞉ halita꞉ epi ya꞉ka꞉ta꞉pe. Ma꞉nda꞉na꞉ hoke hau manuta꞉ Koda꞉ma꞉ homeke ana꞉na꞉ paeyaapeke ya꞉la꞉taa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kutupa mo haliwekima꞉ hone wimiki ekita꞉ Yesuma꞉ amba꞉ hone wia iki pa꞉ta꞉ alota꞉ Ekipeke ikana꞉ma꞉ ika꞉ hone pa꞉ta꞉ do honemanu witelemepe laa lota꞉ pitolo alota꞉ ");
INSERT INTO ssx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Do pi yaapona꞉ yapa꞉ pa꞉la꞉ ekita꞉ handoeki ka꞉ta꞉pe. Naka꞉ hokeeki pa꞉la꞉eki manuta꞉ pa paeyaasa꞉me laa la꞉la꞉eki yapa꞉ pa꞉la꞉pe o Tiao pue aloeki yapa꞉ pa꞉la꞉pe laa ");
INSERT INTO ssx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","I̱ma꞉ iki pa꞉ta꞉ta꞉ Wanda꞉halina꞉ Eiyekema꞉ do kenkena꞉ hata꞉ hoke haumanu paeyaapeke wele wia halo ekita꞉ ame peneme yanoma꞉ handa꞉pa꞉peke leekeme. Koto ekina꞉ta꞉ Yesuma꞉ mo hande kiki anke lupa wiki hali pa꞉ta꞉ alota꞉ I̱ma꞉ neke pa꞉ta꞉ alome. Ame tiao. Naka꞉ tilita꞉ da pa mea tia pue leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Koto tomona꞉ kone mo wanda꞉halina꞉ leke tonka꞉na꞉ mo hande hali tiao mo ipiki pelieke tili mea tia ipika꞉ da nane pulu hata꞉ta꞉ Koda꞉na꞉ biki mea miniliatia peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kutupa koto piekeeki handaata꞉ mo hande wanda꞉hali manuta꞉ penkilipa꞉tia pomua ikita꞉ pututuma꞉ homolo hata꞉ Koda꞉na꞉ biki mea miniliaaso alota꞉ Ameta꞉ nikana꞉ma꞉ na handeke epeke haumanu wotu handoma꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wetepena꞉ Yesu hama opolu bao pulu hata꞉ dakisi mani mu hayeke hali ma꞉nda꞉ ipika꞉ biki Lipae handeekeme. Koto halita꞉ mo dakisi mani mu hayeke opisi pa꞉ta꞉ pitiekeme. Yesuma꞉ Lipae pa꞉ta꞉ alota꞉ I̱ telia꞉ mea epoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Koto ekina꞉ Lipae tiao ipika꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao siki kiao Yesu telia꞉ mea peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kutupa Lipaema꞉ta꞉ ipika꞉ da pa꞉ta꞉ Yesuna꞉ aneke ne ma꞉nda꞉ pambaeyekeme. Lipaema꞉ wi leeke epemeke haliweki ame̱le̱ mo dakisi mani mu haemeke haliweki aneke hapu make pa mandane haliweki make ipika꞉ da pa꞉ta꞉ pitimikime. ");
INSERT INTO ssx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kutupa mandane Pa꞉tisi haliweki manuma꞉ make iki ame̱le̱ apa꞉taemeke mandane Lo Pi wala꞉la꞉ haliwekima꞉ make Yesuna꞉ disaipolo haliweki pa꞉ta꞉ ka꞉nda꞉ piki pimanu lota꞉ pitolo hata꞉ alota꞉ Mo dakisi mani mu haleme haliweki make mo hoke hauma꞉ ha̱i̱ pieke handaa mina꞉pa꞉laemeke wanda꞉hali ame̱le̱ mandake pa꞉ta꞉ pita꞉ ne ikalimanu ekipeke nalemepe laa lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Koto ekina꞉ta꞉ Yesuma꞉ ika꞉ pi hombo peaaso hata꞉ alota꞉ Mo wanda꞉hali ma꞉nda꞉ epima꞉ yeni na homemeka꞉na꞉ta꞉ kota꞉ dokeda haliweki pa꞉ta꞉ na pu halemepate ota꞉ yeni homo haleme wanda꞉hali homeke dokeda hali pa꞉ta꞉ pu halememe. ");
INSERT INTO ssx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","I̱ma꞉ta꞉ epeke hau pu haleme wanda꞉hali hone ma꞉nda꞉ la꞉ka꞉la wina꞉yeke wi loluekema꞉ na epoa꞉pate pa hoke hau pu haleme wanda꞉hali wi loluekema꞉ epoa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kota꞉ mandane wanda꞉halima꞉ Yesu pa꞉ta꞉ dupa lemekeme. Dionina꞉ disaipolo haliweki make mo Pa꞉tisi haliwekina꞉ disaipolo haliweki make nate paeyao nee pi u moneaaso hata꞉ Koda꞉ pa꞉ta꞉ yeni pea꞉tiki pu halemepate pa naka꞉ disaipolo haliwekima꞉ta꞉ ikali ne manuta꞉ pa no halememe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Koto ekina꞉ Yesuma꞉ ika꞉ pi hombo peaaso hata꞉ alota꞉ Ika꞉ honema꞉ta꞉ hali ma꞉nda꞉ma꞉ wanda꞉ panake mea pita꞉ ne pambolo hata꞉ mo wi leeke epemeke wanda꞉halima꞉ ipiki ame̱le̱ pa mandake pitu haya꞉ka꞉na꞉ta꞉ koto wanda꞉halita꞉ ne na neke pi wipe lea꞉ka꞉na꞉ta꞉ opilimikipe. Ota꞉ dia꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Koto pa꞉la꞉pate mo wanda꞉ panake mina꞉la꞉ halita꞉ ma꞉nda꞉ma꞉ hatuku pua꞉peke nate opolo epea꞉ka꞉na꞉ta꞉ kota꞉ koto natena꞉ta꞉ ikana꞉ma꞉ nee pi wia꞉tiki pu halimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesuma꞉ iki pa꞉ta꞉ onkoluma꞉ pi ma꞉nda꞉ dupa leekeme. Hali ma꞉nda꞉ma꞉ ipika꞉ sinkipiki amba꞉ sedi ma꞉nda꞉ epeaaluekema꞉ta꞉ ipika꞉ panake sedi tunkulu mea mo amba꞉ ekina꞉ na tombilieke. Koto hau pia꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ ipika꞉ panake sedi tunkulieke make mo panake aka꞉ta꞉ tunkulu mieke mo ambisanake sedi mandakena꞉ apa꞉tao tombilia꞉ka꞉na꞉ta꞉ mandake na pilieke. ");
INSERT INTO ssx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Koto tupa꞉ kone hali ma꞉nda꞉ma꞉ ambisanake ma꞉na꞉ yonkelekema꞉ wa꞉pa꞉la꞉ ipi kanake pa꞉ta꞉ panake waini ikali na holo pambilieke. Koto hau pia꞉ka꞉na꞉ta꞉ mo panake waini ikalima꞉ mo ma꞉na꞉ yonkelekema꞉ wa꞉pa꞉la꞉ amba꞉ ipi kanaketa꞉ sinkipa hoelo baalieke leekeme. Kutupa mo ma꞉na꞉ yonkeleke make hoeyaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dia꞉me. Mo panake waini ikalita꞉ mo panake ma꞉na꞉ yonkelekema꞉ wa꞉pa꞉la꞉ ipi kanakena꞉ holo pambilieke. ");
INSERT INTO ssx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kutupa mo amba꞉ waini ikali amba꞉la꞉ nala꞉ halima꞉ta꞉ mo panake waini ikali napeketa꞉ kialieke. Ekipeke. Ipikana꞉ma꞉ amba꞉ waini ikalita꞉ ota꞉ a꞉pa꞉la꞉me lelieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yesuta꞉ ipika꞉ hoki nane telimiki haliweki ame̱le̱ Diu wanda꞉halina꞉ hoto pila꞉ nate homekena꞉ mo konima꞉ handeke ale widi emanu pa꞉ta꞉ pemekeme. Kutupa ipika꞉ disaipolo haliwekima꞉ mo widi kilikimanu honda꞉ mea ika꞉ kikima꞉ da꞉ka꞉pa꞉ mina꞉ bepia kilikimanu homeke nemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kutupa mo mandane Pa꞉tisi haliwekima꞉ alota꞉ Pa ekipeke ikana꞉ma꞉ mo nika꞉ Lo Pi manuma꞉ la꞉la꞉ tupa꞉ mo Hoto Pila꞉ Natena꞉ na pea꞉pa꞉peke la꞉la꞉ ekita꞉ ekipeke pitolo pimipe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Koto lemeke Yesuma꞉ iki pa꞉ta꞉ alota꞉ Deipidi ipiki ame̱le̱ haemeke haliweki hoto ma꞉nda꞉na꞉ tea꞉ma꞉ homolo hata꞉ Deipidima꞉ pieke ekita꞉ na yata꞉pemepe. ");
INSERT INTO ssx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ipikana꞉ma꞉ mo Koda꞉na꞉ da tukiki pa꞉ta꞉ honda꞉ pamba puaata꞉ mo wanda꞉halima꞉ Koda꞉ pa꞉ta꞉ halemeke palaowa pua mea neekeme. Kutupa ipiki ame̱le̱ haemeke haliweki make mea haleekeme. Kutu piekepate mo wape pea ula꞉ Lo Pi manuma꞉ alota꞉ Do palaowata꞉ wanda꞉hali ma꞉nda꞉ma꞉ na napa꞉peke ya꞉la꞉pate ota꞉ mo yeni peao haemeke da handeteke haemeke haliwekima꞉ homeke napa꞉peke ya꞉la꞉me la꞉la꞉me laata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesuma꞉ ipika꞉ pi lo paeyaaso hata꞉ alota꞉ Hoto pila꞉ nateta꞉ Wanda꞉halina꞉ Eiyekema꞉ handeteke hala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mo hoto pila꞉ nate ma꞉nda꞉na꞉ Yesuta꞉ mo Diu haliwekina꞉ pi hotu haemeke da ma꞉nda꞉ pa꞉ta꞉ honda꞉ pamba Koda꞉na꞉ pi waleekeme. Kutupa koto pa꞉ta꞉ mo popeke nane kiki hapueke endiki hali ma꞉nda꞉ hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mo wape pea ula꞉ Lo Pi walo haemeke haliweki make Pa꞉tisi haliwekima꞉ make Do nika꞉ Hoto Pila꞉ Natena꞉ Yesuma꞉ ma꞉nda꞉ mea epeaalia꞉pe laa handa꞉hake wimikime. Yesuma꞉ pi yamba꞉lea꞉me loluekema꞉ yeke pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kutu pimikipate Yesuma꞉ta꞉ mo haliwekina꞉ hone wimikieki amba꞉ handa꞉ wiaata꞉ mo kiki hapueke endiki hali pa꞉ta꞉ alota꞉ Tiao. Do wanda꞉halina꞉ leke popeleke nane epoe leekeme. Mo halita꞉ tiao mo wanda꞉halina꞉ leke popeleke nane tiao halo yapeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kutu pieketa꞉ Yesuma꞉ mo wanda꞉hali pa꞉ta꞉ alota꞉ I̱ma꞉ iki pa꞉ta꞉ lota꞉ pitolome. Mo Hoto Pila꞉ Natena꞉ nika꞉ Lo Pi ula꞉ ekima꞉ta꞉ eki pea꞉pa꞉peke la la꞉la꞉pe. Pa tamba꞉ muluekema꞉ o hoeyaaluekema꞉ la꞉la꞉pe. Mo wanda꞉halina꞉ hala꞉eki tamba꞉ muluekema꞉pe o hoeyaaluekema꞉pe laa lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kotoeki laata꞉ Yesuma꞉ leke taka꞉lakema꞉ mo haliweki handa꞉ mone mone pitolo hata꞉ mo some pa꞉ta꞉ alota꞉ Naka꞉ kiki tindipae leekeme. Koto leeke mo halima꞉ ipika꞉ kiki tindipaeyeketa꞉ paa epeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kutu pieke handaa mo Lo Pi walo haemeke haliwekima꞉ mo Pa꞉tisi haliwekima꞉ tonka꞉na꞉ mineke pankolo hata꞉ titipu tieke a꞉meiyeke handaa Yesu pa꞉ta꞉ta꞉ eki pumana꞉pe laa a꞉nda꞉ lombemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Koto dina꞉ta꞉ Yesuta꞉ Koda꞉ pa꞉ta꞉ yeni puluekema꞉yeke pote ma꞉nda꞉ a꞉meiya peekeme. Koto timba andusa꞉na꞉ Yesuma꞉ yeni paa pitolo ombu pitina꞉ta꞉ da paa kelepeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kutupa nate teeketa꞉ Yesu ipika꞉ hoki nane tolu haemeke haliweki paeyao wi leekeme. Koto haliweki tukiki pa꞉ta꞉ kone 12 haliweki ma̱leke litolo hata꞉ alota꞉ Ikita꞉ yaka Aposolo haliweki hapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mo haliwekina꞉ biki manuta꞉ Saimono Yesuma꞉ leeke biki ma꞉nda꞉ta꞉ Pida ipika꞉ hameke A꞉ndutu make Dia꞉mesi Dioni Pilipi Badolomiu make ");
INSERT INTO ssx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ma꞉tiu make Tomasi make A꞉lopia꞉sina꞉ eiyeke Dia꞉mesi make Saimono ipika꞉ biki ma꞉nda꞉ta꞉ Seloti make ");
INSERT INTO ssx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Dia꞉mesina꞉ eiyeke Diudasi make Isekatiotina꞉ eiyeke Diudasi ipikita꞉ hande Yesu ba꞉sa꞉ pulu yapolo pieke some hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kutupa Yesuma꞉ mo Aposolo haliweki ame̱le̱ mo hande potena꞉ hao hola꞉pa꞉niao ikita꞉ epeke hawete epeekena꞉ Yesu ipika꞉ hoki nane tolu haemeke haliweki paeyao ame̱le̱ hata꞉ tiao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Koto dina꞉ta꞉ Diudia da yu paeyaona꞉ haemeke wanda꞉hali make Diutuseleme daoni wanda꞉hali make epemekeme. Kutupa mo dawala ikali tea꞉ pa꞉ta꞉ hayeke teke da yaapo Taiya pita꞉ Saidoni da yu pa꞉ta꞉ haemeke wanda꞉hali make epemekeme. Ikita꞉ Yesuma꞉ waleeke pi opuluekema꞉ make ika꞉ yeni ta꞉ta꞉ ta꞉ta꞉ hayekeeki mea epeaena꞉yeke make a꞉pa mombelemekeme. Koto dina꞉ta꞉ mo hoke temokoma꞉ ka꞉nda꞉ mea peatiki pimiki wanda꞉hali make ipiki pa꞉ta꞉ epemeke handaa Yesuma꞉ mea epeaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mo wanda꞉halina꞉ yenimanu mea epeapeke honkopu tieke Yesu pa꞉ta꞉ hao yapeeke handaa mo wanda꞉hali paeyaoma꞉ ipiki wataluekema꞉ taapemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesuma꞉ ipika꞉ hoki nane tolu haemeke haliweki handolo hata꞉ alota꞉ Natehali wanda꞉halita꞉ ta꞉na꞉ma꞉ homo halememe. Koda꞉na꞉ Kilu Tombuao Hala꞉ ekita꞉ ika꞉ ekie. ");
INSERT INTO ssx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ame tea꞉ma꞉ homeleme wanda꞉hali iki ta꞉na꞉ma꞉ homo halememe. Ikita꞉ weleke tieke telieke. Ame e̱ aleme wanda꞉hali ikita꞉ ta꞉na꞉ma꞉ homo halememe. Ikita꞉ kitelimikie. ");
INSERT INTO ssx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ikita꞉ mo Wanda꞉halina꞉ Eiyeke tolu halemeke handaa mandane wanda꞉halima꞉ iki pa꞉ta꞉ yaala꞉ma꞉ homao make tanda ku make ika꞉ biki hoeyaaluekema꞉ hoke ba꞉sa꞉ pitolo yayapiki pimanu sa꞉mba꞉lao pitolo haena꞉ kone ");
INSERT INTO ssx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","pa pina꞉ma꞉ ikana꞉ma꞉ta꞉ pa epeke puki haaso hata꞉ ta꞉na꞉ma꞉ homolo make pita ponka꞉ lapa꞉peke. Pa ekipeke ika꞉ mulu peleme yenki tieketa꞉ oli hepeni nane wiawala꞉me. Amba꞉ hande haemeke potopede haliweki pa꞉ta꞉ make ika꞉ apa꞉meima꞉ pimieki kone pitolo pitelememe. ");
INSERT INTO ssx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Koto pa꞉la꞉pate aiyo ame do hamoko haaseme wanda꞉halio. Iki pa꞉ta꞉ta꞉ ka꞉nda꞉ tieke ipula꞉me. Ika꞉ epeke tupa꞉ hao pa꞉limi ekita꞉ ame homeke minelememe. ");
INSERT INTO ssx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","A꞉pei. Ame do weleke tumbao hala꞉ wanda꞉halio. Ka꞉nda꞉ tieke ipula꞉me. Ikita꞉ tea꞉ma꞉ homilimikie. A꞉pei. Ame kitaleme wanda꞉halio. Ka꞉nda꞉ tieke ipula꞉me. Ikita꞉ ika꞉ pukima꞉ e̱ tieke alo hata꞉ e̱ pankeke lopena꞉ lelimikie. ");
INSERT INTO ssx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","A꞉pei. Wanda꞉hali paeyaoma꞉ ika꞉ hauna꞉ pi laemeka꞉na꞉ta꞉ ka꞉nda꞉ tieke ipula꞉me. Ekipeke amba꞉ kiake koto wanda꞉halina꞉ apa꞉meima꞉ mo makeaaso potopede haliweki tonu pa꞉ta꞉ lo haemeke tupa꞉ kone alo alememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pate ame ya pi opiteleme wanda꞉hali iki pa꞉ta꞉ta꞉ I̱ma꞉ dupa alome. Ika꞉ a꞉nda꞉ tunkuliki wanda꞉hali pa꞉ta꞉ta꞉ pukima꞉ homo hapa꞉peke. Kutupa iki pa꞉ta꞉ honditi pu haleme wanda꞉hali pa꞉ta꞉ tonka꞉na꞉ epeke hau homeke pu hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Iki pa꞉ta꞉ keke pi aleme tapake pa꞉ta꞉ta꞉ pukipiki pi homeke lapa꞉peke. Kutaa make iki hoeyaaseme tapake pa꞉ta꞉ta꞉ yeni peawapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Hali ma꞉nda꞉ma꞉ naka꞉ pakena꞉ lia꞉ka꞉na꞉ta꞉ mandane pakena꞉ make lina꞉ lapeke. Hali ma꞉nda꞉ma꞉ naka꞉ kosa꞉ aka꞉ mia꞉ka꞉na꞉ta꞉ naka꞉ sedi make mina꞉ lapeke. ");
INSERT INTO ssx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Hali ma꞉nda꞉ma꞉ neke pa꞉ta꞉ ale ma꞉nda꞉ kie laa honke lea꞉ka꞉na꞉ta꞉ hala꞉peke. Hali ma꞉nda꞉ma꞉ naka꞉ ala꞉ta꞉ ma꞉nda꞉ mia꞉ka꞉na꞉ta꞉ ipiki pa꞉ta꞉ Yaka ale paa kie laa paa na mia꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mandane wanda꞉halima꞉ iki pa꞉ta꞉ pina꞉e hone u haleme tupa꞉ ikana꞉ma꞉ ana꞉na꞉ iki pa꞉ta꞉ make mandake hau pu hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Iki pukima꞉ homeleme wanda꞉hali pa꞉ta꞉ homeke ikana꞉ma꞉ pukima꞉ homemeka꞉na꞉ta꞉ pa ekipeke ikita꞉ Koda꞉na꞉ epeaasa꞉ ekita꞉ milimipe. Hoke hau pu haleme wanda꞉halima꞉ kone iki pa꞉ta꞉ pukima꞉ homeleme wanda꞉hali pa꞉ta꞉ta꞉ pukima꞉ homo halememe. ");
INSERT INTO ssx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kutupa ikana꞉ma꞉ iki pa꞉ta꞉ epeke haumanu piteleme wanda꞉hali pa꞉ta꞉ homeke paa epeke haumanu pimika꞉na꞉ta꞉ kota꞉ Koda꞉na꞉ epeaasa꞉ ekita꞉ ekipeke kilieke ya꞉ka꞉ta꞉pe. Mo hoke hau pu haleme wanda꞉hali make koto hau koto tupa꞉ kone pu halememe. ");
INSERT INTO ssx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kutupa make ikana꞉ma꞉ ala꞉ta꞉ ma꞉nda꞉ I̱ pa꞉ta꞉ paa kilimikie hone witolo hata꞉ tondiki halemeka꞉na꞉ta꞉ kota꞉ Koda꞉na꞉ epeaasa꞉ ekita꞉ ekipa milimikipe. Mo hoke hau pu haleme wanda꞉halima꞉ta꞉ ika꞉ haleme tupa꞉ paa muluekema꞉ ika꞉ ala꞉ta꞉ ala꞉ta꞉ mo hoke hau pu haleme yankeke tonu pa꞉ta꞉ kone halo halememe. ");
INSERT INTO ssx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dia꞉me. Ika꞉ a꞉nda꞉ tunkuliki wanda꞉hali pa꞉ta꞉ pukima꞉ homa iki pa꞉ta꞉ epeke hau homeke pu hapa꞉peke. Ikana꞉ma꞉ wanda꞉hali ma꞉nda꞉ pa꞉ta꞉ ala꞉ta꞉ ma꞉nda꞉ tondiki halemeka꞉na꞉ta꞉ paa muluekema꞉ hone na u hapa꞉peke. Kutu pu haemeka꞉na꞉ta꞉ ika꞉ yenki aneke hapu meata꞉ oli Koda꞉ Manda Hala꞉ Tiekena꞉ eiyeke titi halimikie. Ekipeke Koda꞉ma꞉ta꞉ mo ipika꞉ epeke haumanu pita꞉la꞉ ekina꞉ ta꞉na꞉e pi na lo haleme wanda꞉hali make mo hoke haumanu wotu pu haleme wanda꞉hali pa꞉ta꞉ make epeke hau pu hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Koto ekina꞉ta꞉ ika꞉ Apa꞉ma꞉ iki pa꞉ta꞉ a꞉ta꞉ma꞉ homolo hata꞉ tamba꞉ mu hala꞉ tupa꞉ kone ikana꞉ma꞉ make mandane wanda꞉hali pa꞉ta꞉ a꞉ta꞉ma꞉ homolo hata꞉ tamba꞉ mu hapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Koda꞉ma꞉ iki pa꞉ta꞉ pi yokaalu kiaapa꞉na꞉ ikana꞉ma꞉ make ma꞉nda꞉ pa꞉ta꞉ pi yokaalu na hala꞉pa꞉peke. Kutupa ma꞉nda꞉ na teli pimika꞉na꞉ta꞉ kota꞉ Koda꞉ma꞉ make iki na teli pilieke. Mandane wanda꞉halima꞉ iki pa꞉ta꞉ hoke hau pelemeeki ikana꞉ma꞉ pa paeyaemeka꞉na꞉ta꞉ kota꞉ Koda꞉ma꞉ make ika꞉ hoke hauta꞉ pa paeyaalieke. ");
INSERT INTO ssx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ma꞉nda꞉ pa꞉ta꞉ ala꞉ta꞉ ma꞉nda꞉ pa hameke kone halemeka꞉na꞉ta꞉ kota꞉ Koda꞉ma꞉ iki pa꞉ta꞉ ipiki epetolo hata꞉ ota꞉ anekehapu tumbao iki pa꞉ta꞉ wendiao kilieke. Ekipeke ikana꞉ma꞉ ma꞉nda꞉ pa꞉ta꞉ manda꞉ meao haleleme tupa꞉ kone Koda꞉ma꞉ iki pa꞉ta꞉ make koto tupa꞉ manda꞉ meao kone kilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kutupa Yesuma꞉ iki pa꞉ta꞉ onkoluma꞉ pi ma꞉nda꞉ dupa leekeme. Leke holupiki hali ma꞉nda꞉ma꞉ leke holupiki hali ma꞉nda꞉ hatuku pua꞉peke na ya꞉la꞉pate pa pea꞉ka꞉na꞉ta꞉ ipiliki telipina꞉ ikali hanka꞉na꞉ pa꞉ta꞉ pua lopilipikie. ");
INSERT INTO ssx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sukulu pita꞉la꞉ weki o wandikita꞉ ipika꞉ wala꞉la꞉ disa some lombei peao na hala꞉me. Pate mo wekiwandikima꞉ ika꞉ sukulu pitelemeeki paeyaemeka꞉na꞉ta꞉ kota꞉ ikita꞉ mo disama꞉ handilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ekipeke naka꞉ kamena꞉ leke pa꞉ta꞉ ula꞉ dokolo siki hone wopu witolo hata꞉ta꞉ mo naka꞉ lekena꞉ ula꞉ ti taka꞉la꞉pake tieketa꞉ hone na u halepe. ");
INSERT INTO ssx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mo ti taka꞉la꞉pake tieke naka꞉ leke pa꞉ta꞉ pa wina꞉ alo hata꞉ta꞉ ekipa naka꞉ kame pa꞉ta꞉ta꞉ Naka꞉ leke ula꞉ dokolo siki meanoe lelipikipe. Aa. Makeaasa꞉ hau pu hala꞉ someo. Titina꞉ mo naka꞉ leke pa꞉ta꞉ ula꞉ ti taka꞉la꞉pake kiake amba꞉la꞉ mea baeka꞉na꞉ta꞉ kota꞉ mo naka꞉ kamena꞉ leke pa꞉ta꞉ ula꞉ dokolo siki meawaluekema꞉ta꞉ epeke handilipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ipi saosao liki ti ma꞉nda꞉ma꞉ta꞉ hoke kiliki na a꞉ilieke. Kutupa make haka꞉teke ti ma꞉nda꞉ma꞉ta꞉ epeke kiliki na a꞉ilieke. ");
INSERT INTO ssx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ti paeyaota꞉ dupiki ti ya꞉ka꞉ta꞉me laata꞉ ipika꞉ kiliki a꞉eta꞉la꞉ ekima꞉ peneme yao la kilieke. Ikana꞉ma꞉ nose kiliki taluekema꞉ta꞉ sutekena꞉ na talimikie. Kutupa mo waini kiliki taluekema꞉ta꞉ mo taola꞉ puna꞉ na talipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Epeke halima꞉ta꞉ ipika꞉ puki pa꞉ta꞉ a꞉mbao ula꞉ epeke hau manuta꞉ hama nane koto epeke haumanu homeke peneme yao walieke. Hoke halima꞉ta꞉ ipika꞉ puki pa꞉ta꞉ a꞉mbao ula꞉ hoke hau manuta꞉ hama nane koto hoke haumanu homeke peneme yao walieke. Ipika꞉ kake pa꞉ta꞉ ala꞉ pi manuna꞉ teke tieketa꞉ ipika꞉ puki pa꞉ta꞉ ula꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Pa ekipeke ikana꞉ma꞉ I̱ pa꞉ta꞉ Tekehalio. Tekehalio alo hata꞉ pu halemepe. ");
INSERT INTO ssx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ma꞉nda꞉ epima꞉ I̱ teke pa꞉ta꞉ a꞉pa yaka pi opua pimika꞉na꞉ta꞉ I̱ma꞉ta꞉ ikita꞉ dupiki halie laa manda꞉ meanoe. ");
INSERT INTO ssx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ipikita꞉ hali ma꞉nda꞉ ipika꞉ da a꞉eluekema꞉ta꞉ yu amba꞉la aowa꞉tia pua toopi handa꞉ witolota꞉ pinkimanu koto toopi manda nokopo hala꞉ hali tupa꞉e. Ikali tieke ta ipulu hata꞉ hande da a꞉pa wataa hande hande piekepate hande data꞉ na lombeekeme. Pa ekipeke mo data꞉ ota꞉ epeke tupa꞉ a꞉eyeke handaa piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Koto pa꞉la꞉pate wanda꞉hali ma꞉nda꞉ epima꞉ yaka pi opuaata꞉ na pimika꞉na꞉ta꞉ ipikita꞉ mo kenke toopi na handa꞉ wiki hata꞉ kone pa hameke pinki nokopo hala꞉ hali tupa꞉e. Mo hande ikali tieke ta a꞉pa mo hande da wataa hande hande pieke pa꞉ta꞉ kone lombeekeme. Hande da lombolo hata꞉ta꞉ ota꞉ hoke tupa꞉ anekema꞉ lombeekeme leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kutupa Yesuma꞉ mo wanda꞉hali pa꞉ta꞉ koto pimanu lo paeyaota꞉ mo Kapeneami daoni nane peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Koto pa꞉ta꞉ mo Loma꞉ ami haliwekina꞉ you hali ma꞉nda꞉ hayekeme. Koto halima꞉ ipika꞉ pukima꞉ ta꞉na꞉ tieke homeeke e pokao hayeke hali teke pa꞉ta꞉ homuluekema꞉ taapeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kutu pieke handaa mo ami you halima꞉ Yesuma꞉ pieke ekimanu opuaata꞉ ipikana꞉ma꞉ mo mandane Diuna꞉ tondiki haliweki pa꞉ta꞉ Yesuma꞉ mo ipika꞉ e pokao hayeke some a꞉pa epeawaena꞉ yeke handaa mulu pupe laa tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Koto tondiki haliwekima꞉ Yesu pa꞉ta꞉ a꞉pa ota꞉ meme piki honke alo hata꞉ alota꞉ Do halita꞉ nakana꞉ma꞉ epeke tamba꞉ mia꞉peke ya꞉la꞉ halie. Pa ekipeke. ");
INSERT INTO ssx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ipikana꞉ma꞉ nika꞉ wanda꞉hali teke pa꞉ta꞉ pukima꞉ wotu homo hala꞉ make ipikana꞉ma꞉ ipika꞉ siki kone nika꞉ pi hotu haloma꞉ da ma꞉nda꞉ a꞉eyaeya꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kotoeki opuaata꞉ Yesuta꞉ mo haliweki ame̱le̱ mandakena꞉ pua mo da teke pa꞉ta꞉ polueke alo pulu haena꞉ mo ami you halima꞉ ipika꞉ yankeke tonuma꞉ Yesu pa꞉ta꞉ dupiki pimanu lena꞉yeke tapaeyekeme. Tekehalio. Pina꞉ pae. ");
INSERT INTO ssx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Neke ya da pa꞉ta꞉ epoelena꞉ loluekema꞉ta꞉ I̱ta꞉ epeke hali dia꞉ya꞉la꞉ ekina꞉ na ipilipikie laa Neke hale alena꞉ a꞉pa꞉peke make ota꞉ ana꞉ na pa꞉la꞉me. Nakana꞉ma꞉ta꞉ ipika꞉ yeni pa paena꞉e pi homeke leka꞉na꞉ta꞉ kota꞉ ya e pokaasa꞉ someta꞉ tialieke. ");
INSERT INTO ssx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pa ekipeke. I̱ta꞉ mandane ami you hali oto pa꞉ta꞉ halome. Kutaa I̱ oto pa꞉ta꞉ make mandane ami haliweki halememe. Kutupa I̱ma꞉ ma꞉nda꞉ pa꞉ta꞉ Pue loa꞉ka꞉na꞉ta꞉ pelieke. Ma꞉nda꞉ pa꞉ta꞉ make Epoe loa꞉ka꞉na꞉ta꞉ ipilieke. Kutupa yaka pa hameke e pokaasa꞉ some pa꞉ta꞉ Do e pokae loa꞉ka꞉na꞉ta꞉ kota꞉ ota꞉ pealieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Koto leekeeki Yesuma꞉ opuolota꞉ penkilipa꞉tia pominolo hata꞉ mo hande ipiki telimiki wanda꞉hali pa꞉ta꞉ la꞉ka꞉la꞉ moneao handolo hata꞉ alota꞉ I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Dupiki hone tulaake some homeke ma꞉nda꞉ a꞉nda꞉ I̱ na handolome. Mo Isulai tapake tukiki pa꞉ta꞉ kone ota꞉ ma꞉nda꞉ a꞉nda꞉ na handa꞉ ulume. ");
INSERT INTO ssx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kutupa mo tapaeya꞉ haliweki paa la꞉ka꞉la mo ami you halina꞉ da pa꞉ta꞉ pua mo hande e pokao hayeke halita꞉ pa epeke tupa꞉ tiao pitiekeeki handemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hosiki siki haota꞉ wetepe nane Yesu ipika꞉ hoki nane telimiki haliweki make wanda꞉hali wotu anekehapu ame̱le̱ Neini daoni pa꞉ta꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ipiki pua mo teke da anekena꞉ wieke daoni pota꞉ kake pa꞉ta꞉ opolo polueke alo pulu haena꞉ mandane haliwekima꞉ mo homeeke hali toko mea hoilu poluekema꞉ yeke tia ipulu pitimikime. Mo homeeke halita꞉ kineke wanda꞉ siki ma꞉nda꞉na꞉ ota꞉ homeke weki siki yeekeme. Mo teke da aneke pa꞉ta꞉ haemeke wanda꞉hali woputa꞉ mo kineke wanda꞉ siki ame̱le̱ ipulu pitimikime. ");
INSERT INTO ssx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tekehalima꞉ mo hande kineke wanda꞉ handaata꞉ ipika꞉ pukima꞉ a꞉ta꞉ tiekema꞉ homolo hata꞉ ipikana꞉ma꞉ mo wanda꞉ pa꞉ta꞉ alota꞉ E na lapee leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kutupa ipikana꞉ma꞉ mo toko tia epemeke bokosi teke pa꞉ta꞉ pua wataeyekeme. Kutu pieketa꞉ mo hande hali toko timiki haliwekima꞉ta꞉ pa tupaleke handeteke haemekeme. Yesuma꞉ alota꞉ Wekio. I̱ma꞉ neke pa꞉ta꞉ loma꞉ tiae leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mo hande homeeke wekita꞉ paa tiao pita꞉ta꞉ pimanu lombo leekeme. Kutu pieke Yesuma꞉ mo hande wekita꞉ inkiki pa꞉ta꞉ hala꞉ moneayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Koto ekina꞉ta꞉ wanda꞉hali paeyaoma꞉ dupiki hau hando hao pututuma꞉ homolo hata꞉ Koda꞉na꞉ biki mea miniliaaso hata꞉ alota꞉ Ota꞉ aneke potopede ma꞉nda꞉ niki tukiki pa꞉ta꞉ a꞉pa꞉la꞉me. Koda꞉ma꞉ ipika꞉ wanda꞉hali tamba꞉ muluekema꞉ yeke a꞉pa꞉la꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Do hande Yesuma꞉ pieke ekina꞉ pi manuta꞉ koto kenke paeyao pa꞉ta꞉ make mo kenke honiki honiki paeyao pa꞉ta꞉manu latia pomimikime. ");
INSERT INTO ssx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Koto dina꞉ta꞉ Dionina꞉ hoki nane tolu haemeke haliwekima꞉ Yesuma꞉ pieke ekimanu paeyao ipiki pa꞉ta꞉ la halemekeme. Koto leeke Dionima꞉ ipika꞉ disaipolo hali yaapo wi la꞉mea ");
INSERT INTO ssx_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","alota꞉ Tekehali pa꞉ta꞉ pua dupa lota꞉ pea꞉pa꞉peke. Neketa꞉ hande Dionima꞉ Ipilieke leeke niki paeyaoma꞉ yu wia haloma꞉ hande hali ya꞉ka꞉ta꞉pe o hali ma꞉nda꞉ epena꞉ yu wia hamonope laa Yesu pa꞉ta꞉ lota꞉ pea꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mo hande hali yaapota꞉ Yesu pa꞉ta꞉ opolo a꞉pa alota꞉ Mo bapitaisi peao hala꞉ hali Dionima꞉ neke pa꞉ta꞉ diki tapaeyeke handaa epopa꞉me. Neketa꞉ Dionima꞉ hande ipilieke leeke yu wia haloma꞉ hali ya꞉ka꞉ta꞉pe o paa hali ma꞉nda꞉ epena꞉ yu wia hamonope laa lota꞉ pitolopa꞉me lepekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Koto tomona꞉ kone Yesuma꞉ yeni ta꞉ta꞉ ta꞉ta꞉ hake wanda꞉hali make hoke temoko pitieke wanda꞉hali wopu make leke holu piki wanda꞉hali make paeyao mea epeatiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kutupa Yesuma꞉ mo Dionima꞉ tapaeyeke hali yaapona꞉ pi hombo peaaso hata꞉ alota꞉ Ipiliki paa la꞉ka꞉la puaata꞉ do handepe ekimanu make do opipieki paeyaota꞉ Dioni pa꞉ta꞉ pua la hala꞉pa꞉peke. Dupa lapa꞉peke. Mo leke holu piki wanda꞉halita꞉ ameta꞉ paa handelememe. Mo anke dola꞉pake piki wanda꞉hali make ameta꞉ pota꞉ pulimime. Kutupa mo kindi yeni hala꞉ wanda꞉hali make ameta꞉ epeke tupa꞉ halememe. Mo katake poka꞉la꞉ wanda꞉hali make ameta꞉ pi ana꞉na꞉ opitelememe. Ota꞉ homemeke wanda꞉hali make ameta꞉ paa mea tiao epeke tupa꞉ halememe. Kutupa maketa꞉ mo hande Pi Seliapota꞉ mo natehali wanda꞉hali sunu pa꞉ta꞉ wala꞉la꞉me laata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","I̱ pa꞉ta꞉ hone yaapo yaapo lo na wimika꞉na꞉ta꞉ kota꞉ koto wanda꞉halita꞉ ta꞉na꞉ma꞉ homo halememe laa lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mo hande hali yaapo Yesu mina꞉pa꞉lao pepeketa꞉ Yesuma꞉ koto pa꞉ta꞉ haemeke wanda꞉hali pa꞉ta꞉ Dionina꞉ pi dupa laeyekeme. Ikana꞉ma꞉ mo hapupapeke alena꞉ Dioni handuluekema꞉ pemeke hauta꞉ ota꞉ aleke handuluekema꞉ pemepe. Poma꞉ mo ambu mea anemone pea mekeaasa꞉eki handuluekema꞉ pemepe. ");
INSERT INTO ssx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ikana꞉ma꞉ koto alena꞉ ota꞉ aleke handuluekema꞉ pemepe. Ikana꞉ma꞉ hali ma꞉nda꞉ma꞉ epeke hamoko aka꞉manu pambao halia꞉eki handuluekema꞉ pemepe. Kutupiki aka꞉manu yama haleme wanda꞉halita꞉ hamoko hali leke hata꞉ kini haliwekina꞉ aneke da epeke pa꞉ta꞉ homeke halimikie. ");
INSERT INTO ssx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ikana꞉ma꞉ I̱ la kipa꞉e. Aleke handuluekema꞉ pemepe. Potopede hali handuluekema꞉ pemepe. Aowe. Ota꞉e. Kutu pimipate ipikita꞉ mo potopede haliweki paeyao ota꞉ ankulake hali handememe. ");
INSERT INTO ssx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Koto ekita꞉ mo hande Baibolo bukama꞉ Dionina꞉ piekeeki dupa lao ula꞉me. Koda꞉ma꞉ alota꞉ Neketa꞉ a̱i̱ na epeke halena꞉ta꞉ amba꞉ titina꞉ I̱ma꞉ ya pimanu mea epena꞉yeke hali ma꞉nda꞉ tapalueke. Titina꞉ta꞉ ipikana꞉ma꞉ naka꞉ pota꞉ pilawalieke laa la꞉la꞉me laata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesuma꞉ iki pa꞉ta꞉ alota꞉ Opua꞉pe. Dioni ipikita꞉ amba꞉ haemeke haliweki paeyao lu ankulala꞉pate Koda꞉na꞉ Kilu Tombuao Hala꞉ alena꞉ oto pa꞉ta꞉ hala꞉ hali ipikita꞉ Dioni lu ankulao hala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wanda꞉halima꞉ koto pi opuaata꞉ iki make mo dakisi mani mu haemeke haliweki ame̱le̱ paeyaota꞉ Dionima꞉ amba꞉ iki bapitaisi peaena꞉ laata꞉ ame dota꞉ Yesuna꞉ pi opitolo hata꞉ta꞉ Koda꞉na꞉ hau manuta꞉ ota꞉ tikitiki ya꞉la꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pate mo Pa꞉tisi haliweki pita꞉ Lo Pi walo haemeke haliwekima꞉ta꞉ Koda꞉ma꞉ iki pa꞉ta꞉ hone pa꞉la꞉eki manuta꞉ kiaasota꞉ Dionima꞉ iki bapitaisi peaapa꞉na꞉yeke kiaemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Koto ekina꞉ Yesuma꞉ alota꞉ Ameta꞉ do kenkena꞉ haleme wanda꞉halita꞉ aleke tupa꞉ manda꞉ meanope o ikita꞉ alekema꞉ handelemepe. ");
INSERT INTO ssx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Koto wanda꞉hali ikita꞉ mo makedi hama pa pitu haleme wekiwandikima꞉ handelememe. Mo tapake ma꞉nda꞉ma꞉ pa mo tapake ma꞉nda꞉ pa꞉ta꞉ wi la꞉moneaso hata꞉ alota꞉ Nikana꞉ma꞉ iki sama꞉ puemena꞉yeke tapeke luma꞉pate ikana꞉ma꞉ sama꞉ na piki kiaememe. Koto ekina꞉ nikana꞉ma꞉ pa homa꞉ emelimanu laoma꞉pate ikana꞉ma꞉ e̱ na leke kiaememe laa lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mo hande bapitaisi peao hayeke hali Dionima꞉ hoto paeyaota꞉ hoto ma꞉nda꞉na꞉ nee pi wia꞉tiki piekeeki make waini ikali na na꞉tiki pieke ekina꞉ ikana꞉ma꞉ alota꞉ Ipikita꞉ hoke temoko pila꞉ halie lememe. ");
INSERT INTO ssx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Koto lemepate mo Wanda꞉halina꞉ Eiyeke ipiki a꞉paata꞉ ne make ikali a꞉pa na꞉tiki pieke handaata꞉ ikana꞉ma꞉ alota꞉ Do hali handa꞉pa꞉ ikali ne wopu no hake some ya꞉ka꞉ta꞉me. Kutupa ipikita꞉ mo dakisi mani mu haleme haliweki make mo wanda꞉halima꞉ ta꞉na꞉ma꞉ na homeleme tapekena꞉ yankeke hala꞉me laa lememe ");
INSERT INTO ssx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","laata꞉ Koda꞉na꞉ epeke hone wita꞉la꞉eki tolu haleme wanda꞉hali ika꞉ hauma꞉ kone mo hande hone wita꞉la꞉ ekita꞉ ota꞉ epekeekie laa peneme yao halimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kutupa nate ma꞉nda꞉na꞉ mo Pa꞉tisi hali ma꞉nda꞉ma꞉ ipika꞉ da pa꞉ta꞉ Yesu ne nolo epena꞉ yeke wi leeke handaa Yesuta꞉ ne nolueke alo pua pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kutupa koto da teke pa꞉ta꞉ta꞉ hali yolo hayeke wanda꞉ ma꞉nda꞉ hayekeme. Koto wanda꞉ma꞉ Yesuta꞉ mo Pa꞉tisi halina꞉ da pa꞉ta꞉ a꞉pa ne no pila꞉me lemeeki opuaata꞉ ipikana꞉ma꞉ta꞉ a꞉la꞉ba꞉seta꞉ toopima꞉ wepiki kanakena꞉ mo totopo wotu piki oeta pambekeeki mea mina꞉ mo da pa꞉ta꞉ epeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kutupa mo wanda꞉ma꞉ Yesuna꞉ hoki nane a꞉pa ipika꞉ anke teke pa꞉ta꞉ tiao hata꞉ ipika꞉ e̱ tonda꞉pa꞉ta꞉ Yesuna꞉ ankena꞉ lopena꞉ leekeme. Kutupa ipika꞉ itikima꞉ Yesuna꞉ ankena꞉ mo hande e̱ tonda꞉pa꞉ honia nunu peata꞉ mo totopo wotu piki oetata꞉ Yesuna꞉ ankena꞉ holayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mo hande Pa꞉tisi halima꞉ kotoeki handaata꞉ ipika꞉ honema꞉ kone alota꞉ Do halita꞉ Koda꞉na꞉ potopede hali ya꞉ka꞉na꞉ yoluta꞉ ipikana꞉ma꞉ ipikita꞉ do wanda꞉ma꞉ wataasa꞉me laa peneme handolo pia꞉me. Ipikana꞉ma꞉ koto wanda꞉na꞉ pa꞉la꞉ hoke hauta꞉ hone ulu pia꞉me laa hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Koto ekina꞉ Yesuma꞉ alota꞉ Saimonoo. Neke pa꞉ta꞉ I̱ma꞉ pi siki ma꞉nda꞉ lonoe leekeme. Mo halima꞉ Yesuna꞉ pi litolo hata꞉ alota꞉ Aowe disao. La kie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Koto leeke Yesuma꞉ dupa leekeme. Nate ma꞉nda꞉na꞉ toopi tondiki halo hayeke hali ma꞉nda꞉ pa꞉ta꞉ta꞉ hali yaapoma꞉ toopi tondiki mipikime. Hali ma꞉nda꞉na꞉ pa wieke tondikita꞉ 100 kina. Kutupa hali ma꞉nda꞉na꞉ ekita꞉ 10 kina pa wiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mo hande tondiki mipiki hali yaapoma꞉ ana꞉na꞉ ambula꞉peke na yeke handaa mo tondiki halo hayeke halima꞉ta꞉ ipilika꞉ tondikita꞉ pina꞉ pa paeyaeyekeme laata꞉ Yesuma꞉ Saimono pa꞉ta꞉ alota꞉ Koto hali yaapo epima꞉ hondo mo tondiki halo hayeke hali pa꞉ta꞉ puki anekehapu halia꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Koto leeke Saimonoma꞉ alota꞉ Pa mata꞉la꞉me. Ya honema꞉ta꞉ mo ipika꞉ tondiki tieke kone pa paeyaeyeke hali yelieke leekeme. Koto leeke handaa Yesuma꞉ alota꞉ Nakana꞉ma꞉ ota꞉ aleme leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kutaata꞉ Yesuma꞉ pa mo wanda꞉ handolo hata꞉ Saimono pa꞉ta꞉ alota꞉ Nakana꞉ma꞉ta꞉ do wanda꞉ta꞉ handelepe. I̱ta꞉ naka꞉ da pa꞉ta꞉ a꞉pa honda꞉ pamboa꞉pate nakana꞉ma꞉ ya anke tanda꞉pa꞉peke ikali ma꞉nda꞉ na kipate do wanda꞉ma꞉ta꞉ ipika꞉ e̱ tonda꞉pa꞉ma꞉ kone ya anke tanda꞉pao ipika꞉ itikima꞉ pa mea honiaeya꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kutupa I̱ do da pa꞉ta꞉ honda꞉ pamboa꞉ dina꞉ta꞉ I̱ nunu na pipate do wanda꞉ma꞉ta꞉ ya anke nunu pia꞉ ekita꞉ hande I̱ epoa꞉ dina꞉ kini peaata꞉ ame do make paa pitolo pila꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nakana꞉ma꞉ta꞉ mo olipi oetata꞉ ya youna꞉ na kitaepate do wanda꞉ma꞉ta꞉ ota꞉ epeke totopo piki oeta yaka ankena꞉ kitawaya꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","I̱ma꞉ neke pa꞉ta꞉ alome. Ipika꞉ pukima꞉ homa꞉la꞉eki tieke I̱ pa꞉ta꞉ peneme yaala꞉ ekima꞉ta꞉ ipika꞉ wopu pa꞉la꞉ hoke hauta꞉ do paeta꞉la꞉ handa꞉e laa wala꞉la꞉me. Koto pa꞉la꞉pate ma꞉nda꞉ma꞉ ipika꞉ hoke hau hosikale siki kone Koda꞉ma꞉ paeyaowaya꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ Koda꞉ pa꞉ta꞉ta꞉ puki hosikale siki halieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Koto laa Yesuma꞉ mo wanda꞉ pa꞉ta꞉ alota꞉ Naka꞉ pele hoke hau paeyaota꞉ paela꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pate mo teipolona꞉ tilao pitimiki wanda꞉halima꞉ ika꞉ ika꞉ kone pi la alualu pitolo hata꞉ alota꞉ Do hoke hau kone tanda꞉paasa꞉ halita꞉ epi ya꞉ka꞉ta꞉pe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Koto leekepate Yesuma꞉ mo wanda꞉ pa꞉ta꞉ alota꞉ Naka꞉ hone tulale ekima꞉ta꞉ neke pa꞉ta꞉la꞉la꞉me. Puki lopao pue leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hosiki siki hao wetepe naneta꞉ Yesuta꞉ mo daoni paeyao pa꞉ta꞉ make mo hosiki da sunu pa꞉ta꞉ make pominolo hata꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekina꞉ Pi Seliapo wanda꞉hali paeyao pa꞉ta꞉ la hala꞉tiki pomiekeme. Kutupa make ipika꞉ 12 disaipolo haliweki make ipiki ame̱le̱ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kutupa amba꞉ titina꞉ mo hande hoke temokomanu tolu lia make yenimanu pea mea epeaeyeke wanda꞉weki make Yesu telia꞉ mea pomimikime. Metita꞉ mo ipika꞉ puki pa꞉ta꞉ta꞉ temoko watake hata꞉ pitiekeeki tolu lieke wanda꞉e. Ipika꞉ biki ma꞉nda꞉ta꞉ Ma꞉kadalawanda꞉e. ");
INSERT INTO ssx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kutupa mo Hetodina꞉ da handeteke hayeke ami you hali Tiusana꞉ weteke bikita꞉ Dioa꞉na make Susa꞉na make mandane wanda꞉wekima꞉ make yeekeme. Mo wanda꞉wekima꞉ ika꞉ mani manuta꞉ Yesu make ipika꞉ disaipolo haliweki tonka꞉na꞉ tamba꞉ mutia pomu hatiki pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wanda꞉hali aneke hapuma꞉ daoni ma꞉nda꞉ ma꞉nda꞉ pa꞉ta꞉ pa ipulu ipulu ombu hata꞉ wanda꞉hali tieke mombelemeke handaa Yesuma꞉ onkoluma꞉ pi ma꞉nda꞉ dupa la haleekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Hali ma꞉nda꞉ma꞉ ipika꞉ e pa꞉ta꞉ wae alemanu a꞉pa tandeleekeme. Tandela꞉tia pulu haena꞉ mandane wae ale manuta꞉ pota꞉na꞉ lopa꞉ lopa꞉ piekeme. Kutu pieke mo wanda꞉halina꞉ ankema꞉ tumba tumba piki hau make ba titima꞉ make a꞉pa yata꞉po nemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mandane wae ale manuta꞉ toopimanu manda ta̱leeke kenke sikina꞉ lopeekeme. Koto wae aleta꞉ opeekepate koto toopi manda wieke kenketa꞉ tenke tenke na leekeeki yaalo opuluekema꞉ piki nono peata꞉ pa hapiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mandane wae ale manuta꞉ tekeke hake alemanu pa꞉ta꞉manu lopeekeme. Kutupa mo tekeke hake alemanu opa꞉liaaso hata꞉ hande wae alemanu opolo pieke ekita꞉ tombuaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kutu piekepate mandane wae ale manuta꞉ epeke kenkena꞉ lopaata꞉ opa꞉liao napeketa꞉ 100manu wiekeme. Kutupa Yesuma꞉ ipika꞉ pi lo a꞉mbolo hata꞉ alota꞉ Katake lomba꞉la꞉ halima꞉ta꞉ wotu opina꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesuna꞉ disaipolo haliwekima꞉ ipiki pa꞉ta꞉ lota꞉ pitolo alota꞉ Do onkoluma꞉na꞉ teke pi la kie lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ipikana꞉ma꞉ ika꞉ pi hombo peaaso hata꞉ alota꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekina꞉ a꞉mbaala꞉eki manuta꞉ iki pa꞉ta꞉ amba꞉ wala꞉la꞉me. Pate mo mandane wanda꞉hali pa꞉ta꞉ta꞉ onkoluma꞉ pi homekema꞉ la halolome. Pa ekipeke. Ikana꞉ma꞉ handolo pelemepate na handena꞉ opulu pelemepate hone na wina꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kutupa Yesuma꞉ alota꞉ Do onkoluma꞉ alo ekina꞉ teketa꞉ dupae. Mo hande wae aleta꞉ Koda꞉na꞉ pie. ");
INSERT INTO ssx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mo pota꞉na꞉ lopea꞉ wae ale manuta꞉ pi opiteleme wanda꞉hali ana꞉na꞉ halememe. Mo hoke Sadanima꞉ hande pi ika꞉ puki pa꞉ta꞉ yoka꞉ mea ikana꞉ma꞉ koto pi pa꞉ta꞉ hone na tulao tamba꞉ mina꞉la꞉eki na mina꞉yeke do hau pu hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mo toopi panka꞉ panka꞉ pa꞉la꞉ kenkena꞉ lopa꞉la꞉ wae ale manuta꞉ wanda꞉hali ma꞉nda꞉ma꞉ Koda꞉na꞉ pi opua ta꞉na꞉ma꞉ homolo hata꞉ mina꞉lemepate ota꞉ wopu na mendiki hosiki haota꞉ mo la handa꞉la꞉ ekimanu ipula꞉ dina꞉ta꞉ paa lopo halememe. ");
INSERT INTO ssx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kutupa mo hande tekeke hake ale polu pa꞉ta꞉ lopeeke wae ale manuta꞉ pi opu haleme wanda꞉hali tupa꞉ ya꞉la꞉pate do kenkena꞉ haumanu pa꞉ta꞉ hone eleke eleke wopu wita꞉la꞉meeki make hamoko hau make do kenke lokena꞉ hone pa꞉la꞉ ekimanu make paeyaoma꞉ ika꞉ honemanu tumbatiki pita꞉leke handaa da꞉ka꞉polo hata꞉ ika꞉ kiliki na pota꞉lieke. ");
INSERT INTO ssx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kutupa mo epeke kenkena꞉ lopa꞉la꞉ wae ale manuta꞉ pi opua homu pu haleme wanda꞉hali ikana꞉ma꞉ honkopu hao epeke tupa꞉ minaata꞉ ika꞉ kiliki aneke a꞉eluekema꞉ pa putia pelimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesuma꞉ alota꞉ Hali ma꞉nda꞉ma꞉ lamepa ka꞉waata꞉ sini tiekema꞉ na mea dopuaniao o bedi tokele pa꞉ta꞉ na u hala꞉me. Koto hau na pikita꞉ wanda꞉hali a꞉pa honda꞉ pambetiki pitolo handena꞉ yeketa꞉ mo lamepa u hala꞉ alena꞉ u hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ala꞉ta꞉ ma꞉nda꞉ a꞉mbao panka꞉ ula꞉ aleta꞉ hama nane peneme yao mea a꞉pa wilieke. Kutupa make ala꞉ta꞉ ma꞉nda꞉ tote pealimi ekita꞉ pa̱a̱na꞉ peneme yao mea ipilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Koto ekina꞉ta꞉ ikana꞉ma꞉ pi opu haleme ekita꞉ wotu handeteke hao hapa꞉peke. Ekipeke ma꞉nda꞉ma꞉ ala꞉ta꞉ ma꞉nda꞉ wia꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ haka꞉ta꞉pao ota꞉ wotu milieke. Pate hali ma꞉nda꞉ma꞉ ala꞉ta꞉ ma꞉nda꞉ na wia꞉ka꞉na꞉ta꞉ kota꞉ mo hosikieki make ipika꞉ honema꞉ Ulume laa wia꞉eki kone yoka꞉ mealieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesuna꞉ ama꞉ make hameke tonuma꞉ ipiki handolo epemekepate Yesu teke pa꞉ta꞉ pua꞉peke na yeekeme. Ekipeke wanda꞉hali anekehapuma꞉ Yesu mea hopa꞉liao haemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma꞉nda꞉ma꞉ Yesu pa꞉ta꞉ a꞉pa alota꞉ Naka꞉ ama꞉ kame tonuta꞉ neke handuluekema꞉ da hama do a꞉pa halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Koto leeke Yesuma꞉ mo wanda꞉hali paeyao pa꞉ta꞉ alota꞉ Koda꞉na꞉ pi opua pu haleme wanda꞉halita꞉ yaka ama꞉ kametonu halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nate ma꞉nda꞉na꞉ Yesu ipika꞉ disaipolo haliweki ame̱le̱ pua kawaso ma꞉nda꞉na꞉ pitulu pemekeme. Yesuma꞉ iki pa꞉ta꞉ alota꞉ Nikita꞉ do ikali tunkula mone tea꞉na꞉ bape leekeme. Kutupata꞉ iki kini pea puluta꞉ ");
INSERT INTO ssx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","mo kawaso pulu haena꞉ta꞉ Yesuta꞉ u peliekeme. Kutupa koto kone po tilipu tieke epeeketa꞉ mo ikalita꞉ kawaso tukiki pa꞉ta꞉ tumbieke ekima꞉ta꞉ homa꞉la꞉ ekita꞉ teke pa꞉ta꞉ yeekeme. Koto ekina꞉ mo haliwekita꞉ paala꞉ tiekema꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kutupa ikana꞉ma꞉ Yesu a꞉pa tiao alota꞉ Aneke halio. Aneke halio. Nikita꞉ teke pa꞉ta꞉ do homoloma꞉ handa꞉e lemekeme. Koto lemeke Yesu tiaota꞉ mo hande honkopu wopu hake po tilipu pa꞉ta꞉ make mo la꞉ma꞉ la꞉ma꞉ piki honkopu hake ikali yaapo pa꞉ta꞉ta꞉ Paae leeke handaa ipilika꞉ honkopu paeyao upa lopaata꞉ la꞉ma꞉ na piki e̱ pondo na lepekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kutupa Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ Ika꞉ hone tulaleme ekita꞉ hando ka꞉ta꞉pe laa lota꞉ piekeme. Koto leekepate iki paeyaoma꞉ penkilipa꞉tia pominolo make paala꞉ma꞉ wotu homolo hata꞉ ika꞉ ika꞉ kone alota꞉ Do halita꞉ epi ya꞉ka꞉ta꞉pe. Mo ikali pita꞉ po tilipu yaapoma꞉ ipika꞉ pi ota꞉ opitelepeme lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Koto hau pea paeyeketa꞉ Yesu ipika꞉ disaipolo haliweki ame̱le̱ mo Kedasa kenke pa꞉ta꞉ kawasona꞉ pua opa꞉liaemekeme. Koto Kedasa kenketa꞉ mo Ka꞉lili kenke nanema꞉ hao mo ikali leke tunkula pua mone tea꞉na꞉ ula꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesuma꞉ mo kawaso mina꞉pa꞉lao mo ikali tea꞉na꞉ pulu haena꞉ta꞉ mo hoke temokomanu pitiki hali ma꞉nda꞉ mo daoni ma꞉nda꞉ pa꞉ta꞉ hao ipiki manda꞉hande pipikime. Ota꞉ amba꞉ hande hatiki a꞉paata꞉ ame make mo someta꞉ aka꞉ na yameke make da pa꞉ta꞉ na hao polu make ipikita꞉ mo homo hayeke haliweki u haemeke tikene da pa꞉ta꞉manu hao hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ipikana꞉ma꞉ Yesu handaata꞉ wi tieke alo hata꞉ Yesuna꞉ anke pa꞉ta꞉ handa꞉niao kenkena꞉ tu lopaata꞉ wi anekema꞉ pa alo alota꞉ Yesuo. Neketa꞉ Koda꞉ Manda Hala꞉ Tiekena꞉ Eiyekee. Nakana꞉ma꞉ I̱ yaapo eki hau puluekema꞉ pitelepe. Nakana꞉ma꞉ I̱ pa꞉ta꞉ tanda na kia꞉pee laa honke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Koto leeke ekita꞉ Yesuma꞉ mo hoke temoko pa꞉ta꞉ Pue leeke ekina꞉ leekeme. Nate paeyao mo hoke temokoma꞉ mo hali wotu lu keatiki pomu hayekeme. Nate ma꞉nda꞉ nina꞉ta꞉ mo halita꞉ dipula pitao senipu manuma꞉ ipika꞉ kiki anke mea tonkao u hatiki pimikipate kone ipikana꞉ma꞉ mo senipumanu tunkula꞉ lubepi pia꞉tiki peaata꞉ mo hoke temokoma꞉ koto halita꞉ hapu hayeke alena꞉ lu mea pua꞉tiki piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesuma꞉ mo hali pa꞉ta꞉ alota꞉ Naka꞉ bikita꞉ epi ya꞉ka꞉ta꞉pe laa lota꞉ pieke handaa ipikana꞉ma꞉ alota꞉ Yaka bikita꞉ Eleke elekee leekeme. Koto leeke ekita꞉ temoko eleke eleke wotu ipiki pa꞉ta꞉ pitieke ekina꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mo hoke temoko tonuma꞉ta꞉ Yesu pa꞉ta꞉ honke honke wotu alo hata꞉ alota꞉ Niki mo tanda mu halo poloma꞉ naku ka꞉ka꞉na꞉ tieke pa꞉ta꞉ dipula pitulu pomono na tapaapeke lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Koto alena꞉ ma꞉na꞉ titi monema꞉ hayeke peiyene tea꞉na꞉ ne nalo haena꞉ mo hoke temoko tonuma꞉ Yesu pa꞉ta꞉ honke alota꞉ Mo ma꞉na꞉ titina꞉ weleke pa꞉ta꞉ pitulu pomono lae lemeke handaa Yesuma꞉ ika꞉ honke lemeke tupa꞉ pa pina꞉ la kiaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Koto ekina꞉ ikana꞉ma꞉ mo hali mina꞉pa꞉lao ma꞉na꞉ titina꞉ weleke pa꞉ta꞉ pitulu pemekeme. Kutu pimikita꞉ mo ma꞉na꞉ paeyaota꞉ mo peiyene paeleeke alena꞉ a̱i̱ya pua hola꞉pa꞉niao ikali pa꞉ta꞉ puaata꞉ ikali naa honki lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mo ma꞉na꞉ titi handeteke haemeke haliwekima꞉ mo pieke ekimanu handaata꞉ pindipa puata꞉ daoni nane haemeke wanda꞉hali make koto daoni tekepa꞉ta꞉ haemeke wanda꞉hali make la꞉tiki pomimikime. ");
INSERT INTO ssx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Koto ekina꞉ mo wanda꞉halima꞉ hande pieke ekimanu handuluekema꞉ pua Yesu pa꞉ta꞉ a꞉paata꞉ amba꞉ hande weleke pa꞉ta꞉ hoke temokomanu pitieke halita꞉ Yesuna꞉ anke teke pa꞉ta꞉ dau yama epeke hone wia pitiekeeki handolo hata꞉ta꞉ iki paeyaoma꞉ paala꞉ma꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mo hali mea epeaaso piekeeki handemeke wanda꞉halima꞉ mo piekeeki manuta꞉ mo epemeke wanda꞉hali pa꞉ta꞉ la halemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kutupa mo Kedasa kenke wanda꞉hali paeyaoma꞉ paala꞉ma꞉ homolo hata꞉ Yesu pa꞉ta꞉ alota꞉ Nakana꞉ma꞉ niki mina꞉pa꞉lao pue lemekeme. Koto lemeke Yesuma꞉ mo kawasona꞉ pitulu pua peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kutu pitolo haena꞉ mo hoke temokomanu tolu lieke halima꞉ Yesu pa꞉ta꞉ honke alo alota꞉ I̱ta꞉ neke yaapo pana꞉e leekeme. Koto leeke Yesuma꞉ mo hali paa tapaaso hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Neke naka꞉ da nane paa la꞉ka꞉la pua Koda꞉ma꞉ neke pa꞉ta꞉ pia꞉ hande ekimanu paeyao wanda꞉hali paeyao pa꞉ta꞉ pua la hala꞉tiki pu hapeke leekeme. Koto ekina꞉ta꞉ mo halima꞉ ipika꞉ teke da nane puaata꞉ Yesuma꞉ ipiki tamba꞉ miekeeki paeyaosiki wanda꞉hali pa꞉ta꞉ pua la hale hale piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu mo kawasona꞉ pita ikali leke mone tea꞉na꞉ paa la꞉ka꞉la peeke pita꞉ma꞉ta꞉ wanda꞉halima꞉ ipika꞉ opolo polo pieke ekina꞉ yu wia handeteke haemeke ekina꞉ ta꞉na꞉ma꞉ wopu homemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Koto tomona꞉ta꞉ hali ma꞉nda꞉ ipikita꞉ mo pi hotu haemeke dana꞉ you hali bikita꞉ Diaitusima꞉ a꞉pa Yesuna꞉ anke teke pa꞉ta꞉ panda꞉ puniao ipika꞉ da pa꞉ta꞉ epena꞉ honke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Pa ekipeke ipika꞉ ota꞉ homeke hayeke bapita꞉ 12 yeeke wandikita꞉ tekesiki pa꞉ta꞉ homuluekema꞉ taapolo pitieke handaa leekeme. Koto leeke Yesu pulu haena꞉ mo wanda꞉hali anekehapu mandane mandane yama꞉ a꞉pa momba꞉laaso hata꞉ Yesu mea daka꞉pa daka꞉pa puluekema꞉ taapemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kutupa mo wanda꞉hali anka꞉lopuna꞉ mo bapi 12 andusa꞉na꞉ we yopu hayeke wanda꞉ ma꞉nda꞉ hayekeme. Ipika꞉ yeni tamba꞉ mina꞉yeke dokeda haliweki pa꞉ta꞉ ipika꞉ mani paeyao hala꞉tiki piekepate ipika꞉ yenita꞉ ota꞉ na epeaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kutupa mo wanda꞉ma꞉ mo wanda꞉hali anka꞉lopuna꞉ puata꞉ Yesuna꞉ hoki nanema꞉ a꞉pa ipika꞉ dopieke dau honiki wataeyekeme. Koto tomona꞉ kone hande we yapeeke ekita꞉ paeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesuma꞉ mo wanda꞉hali pa꞉ta꞉ lota꞉ pitolo alota꞉ I̱ta꞉ epima꞉ wataeya꞉pe leekeme. Mo wanda꞉halima꞉ alota꞉ Niki ma꞉nda꞉ma꞉ na wataoma꞉me lemeketa꞉ Pidama꞉ Yesuna꞉ pi hombo peaaso alota꞉ Tekehalio. Do wanda꞉halima꞉ neke mea hopa꞉liao daka꞉paasa꞉ handa꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Koto leekepate Yesuma꞉ alota꞉ Ekipeke I̱ tukiki pa꞉ta꞉ ula꞉ honkoputa꞉ ma꞉nda꞉ teke pa꞉ta꞉ puleke handaa ma꞉nda꞉ma꞉ I̱ ota꞉ wataeya꞉me laa loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mo wanda꞉ma꞉ Yesuma꞉ I̱ma꞉ pua꞉ ekita꞉ handa꞉ ya꞉ka꞉ta꞉me laa pututuma꞉ homa꞉tia a꞉pa Yesuna꞉ anke teke pa꞉ta꞉ a꞉pa panda꞉ puniaeyekeme. Wanda꞉hali paeyaona꞉ leke tonka꞉na꞉ hata꞉ mo wanda꞉ma꞉ Yesu pa꞉ta꞉ ipika꞉ dau honiki wataeyeke ekina꞉ teke make mo ipika꞉ yeni koto kone paeyekeeki make laa haleekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Koto ekina꞉ta꞉ Yesuma꞉ mo wanda꞉ pa꞉ta꞉ alota꞉ Ya wandikio. Naka꞉ hone tulale ekima꞉ naka꞉ yeni ame do kone mea epeaasa꞉me. Puki lopao pue leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuma꞉ do pi alo haena꞉ta꞉ hali ma꞉nda꞉ma꞉ mo you halina꞉ da nane hao a꞉pa Diaitusi pa꞉ta꞉ alota꞉ Naka꞉ wandikita꞉ ota꞉ homea꞉me. Mo Disa pa꞉ta꞉ pina꞉ pa paena꞉ lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Koto leekeeki opua Yesuma꞉ Diaitusi pa꞉ta꞉ alota꞉ Paala꞉ma꞉ na homa꞉pee. Hone tulaase hau homeke pika꞉na꞉ta꞉ naka꞉ wandiki sikita꞉ ota꞉ paa tialieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu mo da pa꞉ta꞉ opolo pulu haena꞉ mo da tukiki pa꞉ta꞉ta꞉ ma꞉nda꞉ ota꞉ na pena꞉ leekepate pa Pida Dioni Dia꞉mesi make mo wandikina꞉ ateke inkiki yaapo pea Yesu ame̱le̱ da pa꞉ta꞉ honda꞉ pambemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Koto da pa꞉ta꞉ pitimiki wanda꞉hali paeyaoma꞉ta꞉ mo wandikina꞉ e̱ alo hata꞉ homa꞉ wia pitimikime. Yesuma꞉ mo wanda꞉hali pa꞉ta꞉ alota꞉ E̱ na lapepe. Do wandiki sikita꞉ ota꞉ na homa꞉la꞉pate pa u peliolo hata꞉ pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Koto leekeeki opuaata꞉ mo wanda꞉halima꞉ta꞉ mo wandiki siki ota꞉ homea꞉eki handemeke ekina꞉ Yesu pa꞉ta꞉ kitaemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Koto lemekepate Yesuma꞉ mo wandiki sikina꞉ kiki mea wi alo hata꞉ alota꞉ Wandiki sikio. Tiae leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Koto alema꞉ kone mo wandiki pa꞉ta꞉ deto hala꞉eki paa a꞉pa ipiki paa tiaeyekeme. Kutupa Yesuma꞉ mo ateke inkiki pa꞉ta꞉ Mo wandiki ne ma꞉nda꞉ hala꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kotoeki handaata꞉ mo wandikina꞉ ateke inkiki yaapoma꞉ta꞉ dota꞉ ota꞉ pita꞉la꞉pe honema꞉ lapeke pi pea꞉ mamata꞉pa pekepate Yesuma꞉ mo tooli pa꞉ta꞉ pi tanda pikima꞉ alota꞉ Wanda꞉hali ma꞉nda꞉ pa꞉ta꞉ do pitoloeki na la hala꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuma꞉ mo 12 disaipolo haliweki pa꞉ta꞉ Ipupa꞉e laa homeke pa꞉ta꞉ mea momba꞉laota꞉ ikana꞉ma꞉ yenimanu mea epeaena꞉ make hoke temokomanu paeyaosiki tolu lina꞉yeke Yesuma꞉ iki pa꞉ta꞉ wele pita꞉la꞉ biki pita꞉ honkopu yaapo hale hale piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kutupa mo haliwekima꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekina꞉ pi walolo hata꞉ yeni haleme wanda꞉hali mea epeawaena꞉ Yesuma꞉ iki tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tapaaso hata꞉ta꞉ dupa leekeme. Iki paeyao pota꞉ poluekema꞉ta꞉ ala꞉ta꞉ ma꞉nda꞉ na mea mina꞉pa꞉peke. Koto alo ale manuta꞉ tumapu o nu o ne o mani o topo pea꞉peke sedi homeke kone na mea mina꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kutupa ma꞉nda꞉ epima꞉ ta꞉na꞉ma꞉ homolo hata꞉ ipika꞉ da pa꞉ta꞉ iki hatuku pea꞉ka꞉na꞉ta꞉ mo daoni mina꞉pa꞉lalueke hone wimika꞉na꞉ta꞉ kota꞉ koto pua hale da pa꞉ta꞉ homeke hao pua꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Daoni ma꞉nda꞉ pa꞉ta꞉ mandali epima꞉ iki na handa꞉ mimika꞉na꞉ta꞉ kota꞉ koto daoni mina꞉pa꞉laaso hata꞉ mo wanda꞉hali kinki pitolota꞉ ika꞉ ankena꞉ ta̱la̱꞉la̱꞉ dokolo tande lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Koto ekimanu lo paeyaeyeketa꞉ hande 12 disaipolo haliwekita꞉ Yesu mina꞉pa꞉lao da hala꞉ hala꞉ pomu lopolo hata꞉ hande Pi Seliapo wala꞉tiki pominolo hata꞉ iki pomimiki ale pa꞉ta꞉manu wanda꞉hali mea epeatia pomimikime. ");
INSERT INTO ssx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mo Ka꞉lili da kenke pa꞉ta꞉ you hali Hetodima꞉ koto pieke ekina꞉ pi paeyao opieke ekima꞉ pomoma꞉ homeekeme. Pa ekipeke mandane haliwekima꞉ dupiki pi la alualu pimikime. Mo bapitaisi peao hayeke hali Dionita꞉ paa tiao a꞉pa hala꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kutupa mandane wanda꞉halima꞉ta꞉ Elaidia peneme yao opolo a꞉pa꞉la꞉me lemekeme. Mandane wanda꞉halima꞉ alota꞉ Amba꞉ hande hayeke potopede hali ma꞉nda꞉ paa tiaeya꞉ka꞉ta꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Koto ekina꞉ta꞉ Hetodima꞉ alota꞉ I̱ma꞉ta꞉ Dionina꞉ make mea tunkulua꞉pate pa do pi ma꞉nda꞉ ma꞉nda꞉ opitolo halita꞉ ota꞉ epi ya꞉ka꞉ta꞉pe. Koto ekina꞉ ipikana꞉ma꞉ Yesu ota꞉ handuluekema꞉ taapa꞉tiki pu hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mo aposolo haliwekima꞉ paa a꞉pa ika꞉ pimiki ekimanu paeyaosiki Yesu pa꞉ta꞉ la halemekeme. Koto ekina꞉ta꞉ Yesuma꞉ mo haliweki ame̱le̱ ika꞉ siki mo Betesaida teke da pa꞉ta꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kutu pimikieki opitolo hata꞉ wanda꞉hali wopuma꞉ momba꞉latia pulu hata꞉ Yesu teli mea pemekeme. Yesuma꞉ mo epemeke wanda꞉hali handaata꞉ ta꞉na꞉ma꞉ homolo hata꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekina꞉ pi walolota꞉ yeni homemeke wanda꞉halita꞉ mea epeaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Welealo nane nate pambolo haena꞉ta꞉ mo 12 disaipolo haliwekima꞉ Yesu pa꞉ta꞉ a꞉pa alota꞉ Do niki haloma꞉ alena꞉ta꞉ wanda꞉hali na hake alena꞉ma꞉ do wanda꞉halita꞉ mo da sunu make mo napeke ne make pelia꞉peke damanu weina꞉ma꞉ pena꞉ tapae lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Koto lemekepate Yesuma꞉ alota꞉ Ikana꞉ma꞉ kone mo wanda꞉hali ne hala꞉pa꞉peke leekeme. Koto leeke ikana꞉ma꞉ alota꞉ Niki pa꞉ta꞉ta꞉ palaowa wala꞉ kiki homekena꞉ ta꞉peli yaapo pea homeke wia haloma꞉me. Naka꞉ honema꞉ta꞉ nikana꞉ma꞉ do wanda꞉hali paeyaona꞉ ne paeyao hambalo pomonope laa lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ekipeke 5 daoseni haliweki koto pa꞉ta꞉ haemekeme. Yesuma꞉ mo disaipolo haliweki pa꞉ta꞉ alota꞉ Mo wanda꞉halita꞉ hali tieke yaapona꞉ kiki yaapomanu tupa꞉ momba꞉lao kenkena꞉ mea pitama꞉ pitama꞉ pipee leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mo disaipolo haliwekima꞉ koto hau pimikita꞉ ");
INSERT INTO ssx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesuma꞉ mo hande kiki homeke palaowa wala꞉ sunu make mo ta꞉peli yaapo pea meata꞉ oli ya nane handa꞉liao hata꞉ Koda꞉ pa꞉ta꞉ keiyae pi leekeme. Koto laata꞉ mo ne pindi pindi peaata꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ta꞉ mo wanda꞉hali paeyao pa꞉ta꞉ telipape laa haleekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mo wanda꞉hali paeyaoma꞉ ne ana꞉na꞉ no tumba tumba peaata꞉ mo disaipolo haliwekima꞉ mo putupiliki wiekeeki manuta꞉ kiki yaapo paeya ankena꞉ yaapo wieke nuna꞉ mondu tumba tumba pea wimikime. ");
INSERT INTO ssx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nate ma꞉nda꞉na꞉ Yesuma꞉ ipika꞉ honumake hata꞉ yeni pitolo haena꞉ta꞉ ipika꞉ disaipolo haliweki opolo epemekeme. Yesuma꞉ mo haliweki pa꞉ta꞉ lota꞉ pitolo alota꞉ Wanda꞉halima꞉ I̱ta꞉ Epina꞉ biki lo halemepe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ipika꞉ disaipolo haliwekima꞉ ipika꞉ pi hombo peaaso alota꞉ Mandane wanda꞉halima꞉ta꞉ neketa꞉ mo bapitaisi peao haya꞉ hali Dioni lo halememe. Mandane wanda꞉halima꞉ta꞉ Elaidia lo halememe. Mandane wanda꞉halima꞉ta꞉ potopede hali ma꞉nda꞉ amba꞉ hande homea꞉pate ame dosiki paa tiao hala꞉ halie lo halememe lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Koto lemeke Yesuma꞉ mo haliweki pa꞉ta꞉ alota꞉ Pa ikana꞉ma꞉ I̱ta꞉ epi lo halemepe leeke handaa Pidama꞉ alota꞉ Neketa꞉ Koda꞉na꞉ Ketisoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Koto leeke Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ I̱ma꞉ ota꞉ loa꞉ma꞉ do pita꞉ wanda꞉hali ma꞉nda꞉ pa꞉ta꞉ na lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesuma꞉ paa pi ma꞉nda꞉ alo alota꞉ Wanda꞉halina꞉ Eiyeketa꞉ tanda tieke ota꞉ wotu meaata꞉ mo Diu tondiki haliwekima꞉ make yeni peao haleme you haliwekima꞉ make wape pea ula꞉ Lo Pimanu wala꞉tiki pu haleme haliwekima꞉ make ipiki kialimikie. Ipikita꞉ homena꞉ lulu pelemepate hoto tepo wiaata꞉ paa tialieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Koto laata꞉ Yesuma꞉ iki paeyao pa꞉ta꞉ alota꞉ Hali ma꞉nda꞉ epima꞉ I̱ telia꞉ mea ipulueke hone wia꞉ka꞉na꞉ta꞉ ipika꞉ kone hone yonka꞉lao nate paeyao ipika꞉ a꞉ka꞉tei wapepiki ti mea tia pominolo hata꞉ I̱ telia꞉ mea pomu haena꞉e. ");
INSERT INTO ssx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pa ekipeke. Hali ma꞉nda꞉ epima꞉ ipika꞉ deto hala꞉eki alupaama꞉na꞉ yeke hone wotu wia꞉ka꞉na꞉ta꞉ kota꞉ ipika꞉ deto hala꞉ ekita꞉ alupalieke. Kutu pulu pa꞉la꞉pate I̱ pa꞉ta꞉ hone witolo hata꞉ ipika꞉ deto hala꞉eki alu pina꞉ lea꞉ka꞉na꞉ta꞉ kota꞉ koto halita꞉ ipika꞉ deto hala꞉ ekita꞉ paa miniki halieke. ");
INSERT INTO ssx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hali ma꞉nda꞉ma꞉ honkopu hao do kenkena꞉ anemone ale paeyao mina꞉la꞉pate ipika꞉ halo pa꞉la꞉eki kone alu pao o tondiki halea꞉ka꞉na꞉ta꞉ kota꞉ koto ale manuma꞉ta꞉ ipikita꞉ ekipa tamba꞉ milia꞉pe. ");
INSERT INTO ssx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hali ma꞉nda꞉ epima꞉ I̱ pa꞉ta꞉ make yaka waloa꞉ pimanu pa꞉ta꞉ make yaala꞉ma꞉ homea꞉ka꞉na꞉ta꞉ kota꞉ mo Wanda꞉halina꞉ Eiyeke make Ateke make yako piki enisolo tonu make iki paeyaona꞉ pa̱a̱ pa꞉la꞉eki ame̱le̱ a꞉paata꞉ mo Wanda꞉halina꞉ Eiyekema꞉ mo hande hali pa꞉ta꞉ make yaala꞉ma꞉ homaalieke. ");
INSERT INTO ssx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Do haleme mandane wanda꞉halita꞉ ambi na homeke hamena꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki ota꞉ handilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuma꞉ dupiki pi laa pula homekemanu paeyeketa꞉ yeni puluekema꞉ pote ma꞉nda꞉ pa꞉ta꞉ peekeme. Ipikana꞉ma꞉ta꞉ Pida Dioni Dia꞉mesi hatuku opa꞉liaemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesuma꞉ yeni pitolo pitina꞉ta꞉ ipika꞉ leke popeleketa꞉ ta꞉ta꞉ ma꞉nda꞉ pikieki hao make ipika꞉ pambaeyeke aka꞉ta꞉ ota꞉ hake wotu pea baeyeke ekima꞉ leke yale yale piki nono piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kutupa koto kone hali yaapota꞉ Yesu ame̱le̱ hata꞉ pi lemekeme. Mo hali yaapota꞉ Mosesi pita꞉ Elaidia yaapo yeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ipilikita꞉ Koda꞉na꞉ pa̱a̱na꞉ a꞉pa hata꞉ Yesu ame̱le̱ ipiki teke pa꞉ta꞉ Koda꞉ma꞉ pina꞉e hone ula꞉ tupa꞉ Diutuseleme da pa꞉ta꞉ homolo pieke ekina꞉ pi hotiolo haemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pida pita꞉ mo hali yaapo peata꞉ u yoka꞉lupa pemekepate tiaota꞉ Yesuna꞉ pa̱a̱ pikieki make mo Yesu ame̱le̱ haepeke hali yaapo handemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Koto ekina꞉ta꞉ hali yaapota꞉ Yesu mina꞉pa꞉lao poluekema꞉ pulu haena꞉ laata꞉ Pidama꞉ Yesu pa꞉ta꞉ alota꞉ Tekehalio. Niki do pa꞉ta꞉ haloma꞉ ekita꞉ ota꞉ epeke epomekeme. Topu da tepo a꞉eyamono lae. Ma꞉nda꞉ naka꞉eki. Ma꞉nda꞉ Mosesina꞉eki. Ma꞉nda꞉ Elaidiana꞉eki pea a꞉eyamono lae leekeme. Pidama꞉ leeke pi manuta꞉ hone wotu na wiki hata꞉ leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pidama꞉ dupiki pi alo haena꞉ta꞉ koa a꞉pa ipika꞉ su̱a̱ma꞉ta꞉ iki mea tumbaeyekeme. Tumbaeyeke handaata꞉ mo disaipolo haliweki tepoma꞉ paala꞉ma꞉ homemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mo koa tukiki pa꞉ta꞉ pi ho̱la̱꞉makema꞉ la꞉niaaso hata꞉ alota꞉ Do ya wekita꞉ I̱ma꞉ kiki ma̱leke lulu wekima꞉ pa꞉la꞉me. Ipika꞉ pi opua꞉pe laa la꞉niaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Koto pi ho̱la̱꞉make laa paeyeke naneta꞉ Yesu homeke hapelia hayekeeki handemekeme. Mo hali tepoma꞉ mo handemeke ekimanu wanda꞉hali ma꞉nda꞉ pa꞉ta꞉ na la haleke ika꞉ homeke hone wimikime. ");
INSERT INTO ssx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Da ma꞉nda꞉ kelepeeketa꞉ Yesuta꞉ mo hali tepo ame̱le̱ mo pote mina꞉pa꞉lao hola꞉pa꞉niaemekepate wanda꞉hali aneke hapuma꞉ Yesu a꞉pa manda꞉hande pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mo wanda꞉hali anka꞉lopuna꞉ a꞉pa hayeke hali ma꞉nda꞉ma꞉ Yesu pa꞉ta꞉ wi anekema꞉ alo alota꞉ Disao. I̱ma꞉ neke pa꞉ta꞉ honke aloma꞉ yaka weki a꞉pa handa꞉e. Ipikita꞉ yaka ota꞉ homeke wekie. ");
INSERT INTO ssx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kutupa ipikita꞉ mo hoke temokoma꞉ mina꞉tiki pita꞉la꞉ natena꞉ta꞉ e̱ wi tieke la꞉tiki pu hala꞉me. Kutupa mo hoke temokoma꞉ mo weki mea lu keao kake pa꞉ta꞉ dako hankoloma꞉ lu hala꞉me. Kutupa mo hoke temokoma꞉ yombu moneatiki pu hata꞉ a̱i̱ na mina꞉pa꞉lalieke. ");
INSERT INTO ssx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Koto ekina꞉ta꞉ I̱ma꞉ naka꞉ disaipolo haliwekima꞉ tolu lina꞉yeke honke loa꞉pate mo haliwekima꞉ ana꞉ na pia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Koto ekina꞉ta꞉ Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Ikita꞉ hone wopu na tulaake ata꞉ka꞉ peao haleme wanda꞉halie. Nate ekipuna꞉ iki ame̱le̱ ombu hao hanope. Nate ekipuna꞉ ika꞉ ka꞉nda꞉ kiteleme ekimanu meanope laata꞉ mo hali pa꞉ta꞉ alota꞉ Naka꞉ weki I̱ pa꞉ta꞉ hatuku epoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mo weki ipulu haena꞉ta꞉ mo hande hoke temokoma꞉ mo weki kenkena꞉ mea lopao lu keayekeme. Yesuma꞉ mo hoke temoko hando laata꞉ mo weki mea epeao ipika꞉ ateke pa꞉ta꞉ paa hala꞉ moneayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Koto hau handemeke wanda꞉hali paeyaoma꞉ Koda꞉na꞉ honkopu wotu hala꞉eki handolo hata꞉ penkilipa꞉tia pomimikime. Wanda꞉hali paeyaoma꞉ Yesuma꞉ putia pomiekeeki handaata꞉ pututu pieke pi pa alo alo haena꞉ Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ikana꞉ma꞉ I̱ma꞉ la kulu polo pi opua hone na yonka꞉lapa꞉peke. Wanda꞉halina꞉ Eiyeketa꞉ mo mandane haliwekina꞉ kiki pa꞉ta꞉ hala꞉ monealieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Koto leeke ekina꞉ teketa꞉ mo disaipolo haliwekima꞉ hone na wimikime. Mo pi teketa꞉ iki a꞉mbaeyeke handaa ika꞉ honema꞉ hone wia꞉peke na yeekeme. Koto ekina꞉ta꞉ ikana꞉ma꞉ mo pi tekena꞉ lota꞉ pia꞉peke ekita꞉ paala꞉ma꞉ homolo hata꞉ na lota꞉ pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kutupa mo disaipolo haliwekima꞉ ika꞉ ika꞉ kone tumiki halita꞉ epipe laa pi la alualu pimikime. ");
INSERT INTO ssx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesuma꞉ ika꞉ hone pa꞉ta꞉ wimiki ekimanu handaata꞉ hosiki weki siki ma꞉nda꞉ hatuku a꞉pa tiao hata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","iki pa꞉ta꞉ alota꞉ Ma꞉nda꞉ epima꞉ yaka bikina꞉ dupiki weki siki handa꞉ mia꞉ka꞉na꞉ta꞉ kota꞉ I̱ kone handa꞉ mina꞉la꞉me. Kutupa hali epima꞉ I̱ handa꞉ mia꞉ka꞉na꞉ta꞉ kota꞉ I̱ tapaeya꞉ hali make handa꞉ mina꞉la꞉me leekeme. Iki tukiki pa꞉ta꞉ta꞉ biki na wiki hali ma꞉nda꞉ haya꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ iki paeyaosiki lu ankulala꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dionima꞉ alota꞉ Tekehalio. Hali ma꞉nda꞉ma꞉ naka꞉ bikina꞉ hoke temokomanu tolu baeya꞉pate mo halita꞉ niki ame̱le̱ na tunaleke handaa nikana꞉ma꞉ koto hau na pia꞉pe laa sa꞉sa꞉ puma꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Koto leeke Yesuma꞉ Dioni pa꞉ta꞉ make ipika꞉ disaipolo haliweki paeyao pa꞉ta꞉ make alota꞉ Ikana꞉ma꞉ ipiki sa꞉sa꞉ puluekema꞉ na taapa꞉peke. Ekipeke iki ame̱le̱ a꞉nda꞉ na lita꞉la꞉ halita꞉ kota꞉ ika꞉ ta꞉ma꞉nie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesu oli hepeni nane mea polo pieke nate teke pa꞉ta꞉ yolo epeeketa꞉ ipikita꞉ mo Diutuseleme teke da nane ota꞉ polueke hone u paleke peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ipikana꞉ma꞉ mo Sametia da ma꞉nda꞉ nane ipika꞉ da ne ala꞉ta꞉ ala꞉ta꞉ wamo peaena꞉ yeke kinki haliweki tapaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kutu pimikipate koto pa꞉ta꞉ haemeke wanda꞉halima꞉ hone witolota꞉ Yesuta꞉ mo Diutuseleme da nane yopula꞉me laata꞉ ipiki na handa꞉ mimikime. ");
INSERT INTO ssx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kutu pimikieki mo disaipolo hali Dia꞉mesi pita꞉ Dioni yaapoma꞉ dupiki hau handaata꞉ Yesu pa꞉ta꞉ alota꞉ Tekehalio. Naka꞉ honema꞉ta꞉ dikana꞉ma꞉ oli ya nanema꞉ ti uleke a꞉pa do wanda꞉hali mea hoeyaena꞉ wi loponope lepekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesuma꞉ ipiliki pa꞉ta꞉ la꞉ka꞉la꞉ moneaaso hata꞉ alota꞉ Kutupiki pi na lapepee leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kutupa Yesu ipika꞉ disaipolo haliweki ame̱le̱ da siki ma꞉nda꞉ pa꞉ta꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ikita꞉ mo pota꞉na꞉ pulu haena꞉ hali ma꞉nda꞉ma꞉ Yesu pa꞉ta꞉ alota꞉ I̱ta꞉ neke pomilipi ale pa꞉ta꞉manu ta꞉lia꞉ mea ipulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesuma꞉ mo hali pa꞉ta꞉ alota꞉ Tikene kika manuma꞉ta꞉ ika꞉ kenke ka꞉ka꞉na꞉ wiaata꞉ ba manuma꞉ make ika꞉ dakemanu hala꞉pate pa mo Wanda꞉halina꞉ Eiyeketa꞉ ipika꞉ hoto minolo pelia꞉peke da ota꞉ ma꞉nda꞉ siki make dia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kutupa Yesuma꞉ hali ma꞉nda꞉ pa꞉ta꞉ alota꞉ I̱ telia꞉ mea epoe leekepate mo halima꞉ alota꞉ Tekehalio. Titina꞉ amba꞉la yaka apa꞉ mea hoilu pono lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesuma꞉ alota꞉ Homeeke wanda꞉halima꞉ kone ika꞉ homa꞉la꞉ wanda꞉hali toko mea hoina꞉ma꞉ neketa꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekina꞉ pi pua wala꞉tiki pu hae leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hali ma꞉nda꞉ma꞉ alota꞉ Tekehalio. I̱ta꞉ neke telia꞉ mea ipuluekema꞉ titina꞉ amba꞉la yaka tapake pa꞉ta꞉ A꞉taloe lolo ponoe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesuma꞉ alota꞉ Hali epima꞉ ipika꞉ kenke aowa꞉ mea lopaasa꞉ ale miniki hata꞉ kenke aowa꞉tia puluta꞉ hoki nane handa꞉tiki pu haya꞉ka꞉na꞉ta꞉ kota꞉ koto halita꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki tukiki pa꞉ta꞉ta꞉ e pokaapeke ana꞉ na pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Do hande haumanu peaata꞉ Tekehalima꞉ 72 haliweki mea yaapo yaapo pu mo ipiki polo pieke da pa꞉ta꞉manu tapa tapa piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kutupa ipikana꞉ma꞉ iki pa꞉ta꞉ alota꞉ Ne napeke wotu mo ena꞉ta꞉ pota꞉la꞉pate mo ne momba꞉laapeke wanda꞉halita꞉ aneke hapu dia꞉me. Koto ekina꞉ta꞉ mo e teke halima꞉ ipika꞉ ena꞉ ne mea momba꞉laalo peleme wanda꞉hali ana꞉na꞉ tapaena꞉ ikana꞉ma꞉ yeni pu hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pupa꞉e I̱ma꞉ ikita꞉ sipisipi ma꞉na꞉na꞉ ikikisunu mandane tikene kikamanu haleme ale pa꞉ta꞉manu taa tapaaso handa꞉e. ");
INSERT INTO ssx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ikana꞉ma꞉ mani pausa o nu sunu o anke dake ma꞉nda꞉ na mea pua꞉pa꞉peke. Ma꞉nda꞉ ame̱le̱ pota꞉na꞉ manda꞉hande pitolo hata꞉ pi na lapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ikana꞉ma꞉ da ma꞉nda꞉ pa꞉ta꞉ honda꞉ pambemeka꞉na꞉ta꞉ titina꞉ amba꞉la koto da pa꞉ta꞉ta꞉ A꞉nda꞉ peliaasa꞉eki epena꞉e lapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kutupa koto da pa꞉ta꞉ a꞉nda꞉ peliaasa꞉ ekina꞉ hone wopu u hala꞉ hali ma꞉nda꞉ haya꞉ka꞉na꞉ta꞉ kota꞉ a꞉nda꞉ peliaasa꞉ pi le ekita꞉ ipiki pa꞉ta꞉ pa wina꞉ lapa꞉peke. Dia꞉ya꞉ka꞉na꞉ta꞉ kota꞉ naka꞉ hande a꞉nda꞉ peliaaso pita꞉ pao mia꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","E pokao hala꞉ hali ipika꞉ yenkita꞉ ota꞉ mea꞉peke ya꞉la꞉ ekina꞉ da lumbu na likita꞉ homeke da pa꞉ta꞉ pa hao hata꞉ ne ikali alekemanu kimika꞉na꞉ta꞉ pa napa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kutupa ikita꞉ da yu ma꞉nda꞉ pa꞉ta꞉ pemeka꞉na꞉ta꞉ koto pa꞉ta꞉ haleme wanda꞉halima꞉ iki pa꞉ta꞉ ta꞉na꞉ma꞉ homolo hata꞉ hatuku mea nemanu kimika꞉na꞉ta꞉ kota꞉ pa napa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Koto da yu pa꞉ta꞉ yeni haleme wanda꞉hali wopu mea epeapa꞉peke. Kutupa koto pa꞉ta꞉ haleme wanda꞉hali pa꞉ta꞉ta꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekita꞉ iki teke pa꞉ta꞉ amba꞉ opolo a꞉pa꞉la꞉me lapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Koto pa꞉la꞉pate da yu ma꞉nda꞉ pa꞉ta꞉ pemeka꞉na꞉ta꞉ mo wanda꞉halima꞉ iki ika꞉ da pa꞉ta꞉ na hatuku pemeka꞉na꞉ta꞉ kota꞉ ikana꞉ma꞉ mo pota꞉ nina꞉ pua hata꞉ alota꞉ ");
INSERT INTO ssx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ika꞉ daoni tukiki pa꞉ta꞉ ula꞉ dokolota꞉ nika꞉ ankena꞉ ta̱la̱꞉la̱꞉ ekita꞉ iki pa꞉ta꞉ kone koto tandela꞉neasoma꞉pate doeki homeke hone wipee laata꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekita꞉ iki teke siki pa꞉ta꞉ koto epea꞉me hone wotu wia꞉pa꞉peke lapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","I̱ma꞉ iki pa꞉ta꞉ ota꞉ alome. Hande pi yokaalu pulu pa꞉la꞉ nate opolo epea꞉ka꞉na꞉ta꞉ kota꞉ Koda꞉ma꞉ mo Sodomo halo pa꞉la꞉ a꞉ta꞉ma꞉ homa꞉la꞉ ekita꞉ mo hande daoni pa꞉ta꞉ halo pa꞉la꞉ ekita꞉ ota꞉ haka꞉ta꞉pao ankulao halieke alome leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","A꞉ta꞉ tieke Kotaasini daonio. A꞉ta꞉ tieke Betesaida daonio. I̱ma꞉ mo ipiliki pa꞉ta꞉ na handeke haumanu paeyao a꞉nda꞉ mo hande daoni yaapo Taiya Saidoni pa꞉ta꞉ pua꞉ka꞉na꞉ yoluta꞉ kota꞉ koto da yaapo pa꞉ta꞉ haleme wanda꞉hali ika꞉ puki lekelemeka꞉ta꞉me laa Koda꞉ma꞉ handena꞉ta꞉ busa꞉ pitikimanu wepia yamaata꞉ lanka꞉ apolo kitulu pimime. I̱ma꞉ ipiliki pa꞉ta꞉ta꞉ ota꞉ pi alome. Mo pi yokaalu pulu pa꞉la꞉ nate opolo epea꞉ka꞉na꞉ta꞉ kota꞉ ");
INSERT INTO ssx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Koda꞉ma꞉ mo Taiya Saidoni yaapo pa꞉ta꞉ halo pa꞉la꞉ a꞉ta꞉ma꞉ homa꞉la꞉ ekita꞉ mo ipiliki Kotaasini Betesaida yaapo pa꞉ta꞉ kulu pa꞉la꞉eki ota꞉ haka꞉ta꞉pao ankulao halieke. ");
INSERT INTO ssx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kutupa Kapeneamio. Neketa꞉ naka꞉ homeke oli ya nane mea a꞉meiyalueke hone wipe. Neketa꞉ oni ti to hala꞉ pa꞉ta꞉ mea lopaalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ Ma꞉nda꞉ epima꞉ ika꞉ pi opia꞉ka꞉na꞉ta꞉ kota꞉ yaka pi kone opita꞉la꞉me. Ma꞉nda꞉ epima꞉ iki kiaeya꞉ka꞉na꞉ta꞉ ota꞉ I̱ kone kiaasa꞉me. Kutupa make hali epima꞉ I̱ kiaeya꞉ka꞉na꞉ta꞉ mo I̱ tapaeya꞉ hali kone kiaasa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mo hande 72 haliwekita꞉ ta꞉na꞉ tiekema꞉ homolo hata꞉ paa opolo epemekeme. Tekehalio. Nikana꞉ma꞉ naka꞉ biki laaso hata꞉ teliolo hamono kone mo hoke temoko manuma꞉ nika꞉ pi ota꞉ opimime lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ I̱ma꞉ Sadani oli ya nane yama꞉ ti tekele manda꞉na꞉ do kenkena꞉ lopea꞉ ekita꞉ handoa꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Opua꞉pe. Ikana꞉ma꞉ mo ketomanu make tei halimanu make da꞉ka꞉pa꞉ tombuamena꞉ make mo a꞉nda꞉ tunkuliki hoke temokona꞉ honkopu paeyao lu tombuao bepolamina꞉ta꞉ ya bikina꞉ welema꞉ iki handeteke halieke. Koto ekina꞉ta꞉ ikita꞉ ala꞉ta꞉ ma꞉nda꞉ma꞉ na hoeyaalieke. ");
INSERT INTO ssx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Koto pa꞉la꞉ma꞉ mo hoke temoko manuma꞉ ika꞉ pi opua pilia꞉eki pa꞉ta꞉ ta꞉na꞉ma꞉ na homa꞉pa꞉peke. Pate ika꞉ bikita꞉ amba꞉ hepeni nane wape pea ula꞉ma꞉ ta꞉na꞉ma꞉ homa꞉pa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Koto natena꞉ta꞉ mo Holi Sipitidima꞉ Yesu pa꞉ta꞉ epeke ta꞉na꞉ pita꞉la꞉ ekima꞉ tumbieketa꞉ Yesuma꞉ alota꞉ Apa꞉o. Oli ya do kenke yaapona꞉ Tekehalio. I̱ma꞉ neke pa꞉ta꞉ Ta꞉na꞉e alome. Ekipeke nakana꞉ma꞉ mo hande hone wotu u tekele peleme wanda꞉hali make mo sukulu wotu peleme wanda꞉hali ameda pa꞉ta꞉ a꞉mbao wina꞉ le hau manuta꞉ pa mo panake wekiwandiki sunu pa꞉ta꞉ wala꞉leke handa alome. Aowe Apa꞉o. Koto ekita꞉ naka꞉ hone pieke yekeeki yaena꞉yeke pina꞉ aleme leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yaka Apa꞉ma꞉ta꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao sikita꞉ I̱ pa꞉ta꞉ ka꞉la꞉me. Mo Eiyeketa꞉ ma꞉nda꞉ma꞉ hone na ula꞉pate ipika꞉ Atekema꞉ homeke hone ula꞉me. Kutupa Ateketa꞉ ma꞉nda꞉ma꞉ hone na ula꞉pate ipika꞉ Eiyekema꞉ homeke hone ula꞉me. Kutupa make mo Eiyekema꞉ ipika꞉ hone pilia꞉ wanda꞉hali pa꞉ta꞉ta꞉ ipika꞉ Ateke walea꞉ka꞉na꞉ta꞉ kota꞉ ikana꞉ma꞉ homeke Ateke hone wilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kutupa Yesuma꞉ ika꞉ honumake siki hata꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ la꞉ka꞉la꞉ moneaaso alota꞉ Ikita꞉ ta꞉na꞉ma꞉ homa꞉pa꞉peke. Ikana꞉ma꞉ handeleme ale handolo peleme ekina꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","I̱ma꞉ iki pa꞉ta꞉ loa꞉ma꞉ mo amba꞉ potopede haliweki wopu make kini haliweki make ikana꞉ma꞉ handeleme alemanu handuluekema꞉ taapemekepate handa꞉peke na yaalo make ikana꞉ma꞉ opitelemeeki opuluekema꞉ pimikipate opua꞉peke ana꞉ na piekeme leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mo Lo Pi walo hayeke hali homekema꞉ Yesu tamuluekema꞉ la handolo alota꞉ Disao. Deto hala꞉eki muluekema꞉ eki pionope laa lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Koto leeke Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Mo hande Baibolo pi manuma꞉ta꞉ eki ala꞉pe. Nakana꞉ma꞉ta꞉ ekipa hone wilipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kutupa mo halima꞉ Yesuna꞉ pi hombo peaaso alota꞉ Baiboloma꞉ dupa la꞉la꞉me. Naka꞉ Tekehali Koda꞉ pa꞉ta꞉ pukima꞉ homolo hata꞉ naka꞉ puki paeyaoma꞉ make naka꞉ temoko paeyaoma꞉ make naka꞉ honkopu paeyaoma꞉ make naka꞉ hone paeyaoma꞉ make ipiki pa꞉ta꞉ pukima꞉ homo hapeke la꞉la꞉me laa make Nakana꞉ma꞉ naka꞉ kone pukima꞉ homele tupa꞉ ma꞉nda꞉ pa꞉ta꞉ make koto tupa꞉ kone pukima꞉ homo hapeke la꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Koto leeke Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Naka꞉ ale pita꞉ epeke aleme. Koto ale ekita꞉ ota꞉ pika꞉na꞉ta꞉ deto hala꞉eki milipikie laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Koto leekepate hande Lo Pi walo hayeke halima꞉ ipika꞉ biki kone epeaaluekema꞉ Yesu paa lota꞉ pitolo alota꞉ Koto hali ma꞉nda꞉e la꞉la꞉ ekita꞉ epipe laa lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Hali ma꞉nda꞉ta꞉ Diutuseleme da mina꞉pa꞉lao oni Dietiko da nane pulu haena꞉ mo pota꞉na꞉ mandane pake naleme haliwekima꞉ mina ipika꞉ dau titipila꞉ mina꞉ bepie yombua bao homuluekema꞉ taapolo pitina꞉ pemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kutupa koto natena꞉ kone mo yeni peao hayeke hali homeke ma꞉nda꞉ koto pota꞉na꞉ peekepate hande yombua bao wina꞉ lemeke some handeekepate pa wina꞉ kone paka꞉lao pota꞉ tea꞉ nane peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Koto hoki naneta꞉ Lipae tapake hali ma꞉nda꞉ make koto tupa꞉ peekepate mo hande yombua bao wina꞉ lemeke hali pua handa kone pao paka꞉lao pota꞉ tea꞉na꞉ peekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pate Sametia hali ma꞉nda꞉ koto pota꞉na꞉ a꞉paata꞉ mo hali hando haota꞉ ipika꞉ pukima꞉ a꞉ta꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kutupa mo hali wieke alena꞉ puaata꞉ mo limiki ale nina꞉ ipikana꞉ma꞉ honku make waini ikali make holaota꞉ banisima꞉ tonkawayekeme. Kutupa mo halima꞉ hande someta꞉ ipika꞉ donki ma꞉na꞉na꞉ hoki manda mea wiaata꞉ hatuku pua hande kimisu haliwekima꞉ hamba polu haemeke da ma꞉nda꞉ pa꞉ta꞉ opolo puaata꞉ koto da pa꞉ta꞉ mo hali handeteke hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kutupa da kelepeeketa꞉ mo Sametia halima꞉ hande da teke hali pa꞉ta꞉ 2 kina halaa alota꞉ Do hali wotu handeteke hapeke. I̱ doane la꞉ka꞉la ipulua꞉ dina꞉ta꞉ mo hali handeteke halena꞉ kitolo 2 kina ana꞉ na pia꞉ka꞉na꞉ta꞉ kota꞉ yenkita꞉ haka꞉ta꞉pao a꞉pa kulueke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Koto laa Yesuma꞉ mo hali pa꞉ta꞉ pi paeyaaso hata꞉ alota꞉ Do tepo hali aloma꞉pate mo pake nala꞉ haliwekima꞉ limiki some teke pa꞉ta꞉ta꞉ epima꞉ puki halea꞉pe laa lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hande Lo Pi walo hayeke halima꞉ Yesuna꞉ pi hombo peaaso alota꞉ Hande a꞉ta꞉ma꞉ homeeke halie laa leekeme. Koto leeke Yesuma꞉ ipiki pa꞉ta꞉ alota꞉ Kota꞉ nakana꞉ma꞉ make kutu piki hau pu hapeke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuta꞉ ipika꞉ disaipolo haliweki ame̱le̱ pota꞉na꞉ pulu hata꞉ da yu siki ma꞉nda꞉ pa꞉ta꞉ opolo pemekeme. Koto da yu pa꞉ta꞉ta꞉ wanda꞉ ma꞉nda꞉ hayekeme. Ipika꞉ bikita꞉ Mada. Koto wanda꞉ma꞉ Yesu ipika꞉ da pa꞉ta꞉ epena꞉ta꞉ ta꞉na꞉ma꞉ homeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mada ipika꞉ hakepiki homeke Meti hayekeme. Metima꞉ta꞉ mo Tekehalina꞉ anke lopao pitieke alena꞉ a꞉pa pita꞉ ipika꞉ pi waleekeeki opu pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kutu piekepate Madata꞉ ne aneke hapu wamo pieke ekima꞉ ipika꞉ hone ka꞉nda꞉ wotu pieke a꞉pa alota꞉ Tekehalio. Yaka asima꞉ I̱ma꞉ mo emanu paeyao yaka honumake piono ala꞉ ekita꞉ nakana꞉ma꞉ta꞉ hone na witelepe. Ipikana꞉ma꞉ I̱ tamba꞉ mulu epena꞉ lae leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Koto leeke Tekehalima꞉ Madana꞉ pi hombo peaaso alota꞉ Madao. Madao. Nakana꞉ma꞉ ala꞉ta꞉ ala꞉ta꞉ wotu pa꞉ta꞉ hone u taapo make hone ka꞉nda꞉ma꞉ homelepate ");
INSERT INTO ssx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pa ota꞉ pea꞉peke hau homeke homeke na peleme. Metima꞉ta꞉ hone wia ota꞉ hau ma꞉la꞉ ekita꞉ ma꞉nda꞉ma꞉ pendilao mea꞉peke na ya꞉lieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nate ma꞉nda꞉na꞉ Yesuta꞉ ala꞉ta꞉ ma꞉nda꞉ pa꞉ta꞉ pua yeni pu pitiekeme. Yeni pu paeyaeyeketa꞉ ipika꞉ disaipolo hali ma꞉nda꞉ma꞉ ipiki pa꞉ta꞉ alota꞉ Tekehalio amba꞉ hande Dionima꞉ ipika꞉ disaipolo haliweki yeni pina꞉yeke waleeke tupa꞉ niki pa꞉ta꞉ make koto tupa꞉ wala꞉e leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Koto leeke Yesuma꞉ iki pa꞉ta꞉ walolo hata꞉ alota꞉ Ikana꞉ma꞉ yeni pimika꞉na꞉ta꞉ dupa pia꞉pa꞉peke. Apa꞉o. Naka꞉ yako piki bikita꞉ ota꞉ manda wia haena꞉e. Naka꞉ Kilu Tombuao Haleeki do ane opolo epena꞉e. ");
INSERT INTO ssx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nika꞉ ame nolo poloma꞉ neta꞉ ana꞉na꞉ kia꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mandane wanda꞉halima꞉ niki pa꞉ta꞉ hoke hau pimieki nikana꞉ma꞉ pa paeyaasoma꞉ ekina꞉ nika꞉ hoke hau puma꞉eki make nakana꞉ma꞉ koto tupa꞉ pa paeyawapeke. Ka꞉nda꞉ piki la handa꞉la꞉eki pa꞉ta꞉ niki na hatuku a꞉pa꞉peke laa lapa꞉peke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kutupa Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ Iki pa꞉ta꞉ hala꞉ hali homeke ma꞉nda꞉ma꞉ buta꞉ hokina꞉ naka꞉ yankekena꞉ da pa꞉ta꞉ pua alota꞉ Kameo. Palaowa punka tepo ta꞉ka꞉li kie. ");
INSERT INTO ssx_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ya yankeke ma꞉nda꞉ pota꞉ pomulu yapuluekema꞉ ame do timba ya da pa꞉ta꞉ opolo a꞉pa pila꞉pate I̱ma꞉ hala꞉peke ne dia꞉ya꞉leke handa loa꞉ma꞉ ma꞉nda꞉ kie laa leka꞉na꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","kota꞉ naka꞉ yankekema꞉ ipika꞉ da tukiki pa꞉ta꞉ hata꞉ naka꞉ pi hombo peaaso alota꞉ I̱ ka꞉nda꞉ma꞉ na homake. Yaka pota꞉ta꞉ amba꞉ loka꞉ hao yaka weki wandiki ame̱le̱ amba꞉ u pa꞉eloma꞉me. Naka꞉ honke ale ala꞉ta꞉ ekipa tiao mea kionope laa lea꞉ka꞉na꞉ta꞉ ");
INSERT INTO ssx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","kota꞉ eki pilipikipe. Iki pa꞉ta꞉ I̱ma꞉ do pi alome. Mo da teke halima꞉ neketa꞉ ipika꞉ yankeke halena꞉ kone mo hande palaowa kuluekema꞉ na tialo pa꞉la꞉pateta꞉ nakana꞉ma꞉ yaala꞉ma꞉ na homeke honke wotu leka꞉na꞉ta꞉ kota꞉ ota꞉ opua tiao naka꞉ mea꞉peke ya꞉la꞉ ekimanu ana꞉na꞉ mea kilieke alome. ");
INSERT INTO ssx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Koto ekina꞉ iki pa꞉ta꞉ do pi alome. Honke leka꞉na꞉ta꞉ ota꞉ kilieke. Weika꞉na꞉ta꞉ handa꞉ wilipikie. Kilikili laeka꞉na꞉ta꞉ pota꞉ lombawalieke. ");
INSERT INTO ssx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Do ekina꞉ yeke loa꞉me. Honke la꞉tiki pu haya꞉ka꞉na꞉ta꞉ kota꞉ koto somema꞉ milieke. Kutaa make ma꞉nda꞉ epima꞉ weiya꞉tiki pu haya꞉ka꞉na꞉ta꞉ ipikana꞉ma꞉ handa꞉ wilieke. Epima꞉ pota꞉ lia꞉tiki pu haya꞉ka꞉na꞉ta꞉ kota꞉ mo pota꞉ta꞉ koto some pa꞉ta꞉ lombawalieke. ");
INSERT INTO ssx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Do pita꞉ weki wandiki hala꞉ haliweki pa꞉ta꞉ alome. Ika꞉ wekima꞉ iki pa꞉ta꞉ ta꞉peli teekeeki honke lea꞉ka꞉na꞉ta꞉ hoke keto mea halimikipe. ");
INSERT INTO ssx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ba hapeke honke lea꞉ka꞉na꞉ta꞉ tei hali mea halimikipe. ");
INSERT INTO ssx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ikita꞉ hoke haliweki halemepate kone ika꞉ weki wandiki pa꞉ta꞉ta꞉ epeke epeke alemanu halo halememe. Koto hau ota꞉ lombei peaaso hata꞉ta꞉ oli ya nane hala꞉ Apa꞉ma꞉ta꞉ mo Holi Sipitidi honke aleme wanda꞉hali pa꞉ta꞉ta꞉ ota꞉ halieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Hali ma꞉nda꞉ta꞉ pi na leke hoke temoko pitiki hali hayeke Yesuma꞉ mo hoke temoko tolu lieke handa mo halima꞉ pi lombo leekeme. Kutu pieke handa wanda꞉hali paeyaoma꞉ tola꞉tia pomimikipate ");
INSERT INTO ssx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","mandane wanda꞉halima꞉ alota꞉ Ipikana꞉ma꞉ mo hande hoke temoko manuna꞉ you hali Bielisibuluna꞉ wele pita꞉la꞉eki mea hoke temokomanu tolu lita꞉la꞉me lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mandane wanda꞉halima꞉ Yesu tamuluekema꞉ alota꞉ Nakana꞉ma꞉ hepeni nanema꞉ ipula꞉ patehau ma꞉nda꞉ nikana꞉ma꞉ handomono pie lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Koto lemekepate Yesuma꞉ mo wanda꞉halina꞉ hone teke amba꞉ handa꞉ wiata꞉ dupa leekeme. Kapomani homekena꞉ handeteke hala꞉ wanda꞉halima꞉ ika꞉ ika꞉ kone tekilipa꞉ alu alu pea a꞉nda꞉ pimika꞉na꞉ta꞉ ika꞉ hande tapake au leleme ekita꞉ koto kone paelieke. Kutupa tapakesiki ma꞉nda꞉ma꞉ ika꞉ ika꞉ kone tekilipa꞉ alu alu pimika꞉na꞉ta꞉ kota꞉ koto tapake sikina꞉ hao pelia꞉peke ekita꞉ hoelieke. ");
INSERT INTO ssx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Koto ekina꞉ta꞉ Sadanina꞉ kilu tombuao hala꞉eki pa꞉ta꞉ haleme tapakema꞉ ta꞉ta꞉ ta꞉ta꞉ lo tekilipa꞉ alu alu pea ika꞉ ika꞉ kone a꞉nda꞉ pimika꞉na꞉ta꞉ ekipa hao pelia꞉tiki pu halimikipe. Ikana꞉ma꞉ I̱ pa꞉ta꞉ta꞉ Bielisibuluma꞉ I̱ honkopu kita꞉leke handa hoke temokomanu tolu lita꞉la꞉me laa alemeeki ");
INSERT INTO ssx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ota꞉ ya꞉ka꞉na꞉ta꞉ kota꞉ ika꞉ disaipolo haliwekima꞉ta꞉ ekipa hoke temoko tolu lu halemepe. Koto haliwekina꞉ piteleme hauma꞉ kone ika꞉ hau telipilimikie. ");
INSERT INTO ssx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dia꞉me. Koda꞉na꞉ honkopu homekema꞉ mo hoke temoko tolu lu halome. Kutu pu halo ekima꞉ta꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekita꞉ iki teke pa꞉ta꞉ amba꞉ a꞉pa꞉la꞉ ekita꞉ peneme yao wala꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Honkopu hake hali ma꞉nda꞉ma꞉ ipika꞉ a꞉nda꞉ pita꞉la꞉ alemanu tiki tiki yao wia hata꞉ mo ipika꞉ da handeteke haya꞉ka꞉na꞉ta꞉ ipika꞉ da tukiki pa꞉ta꞉ ula꞉ alemanu paeyaota꞉ epeke tupa꞉ pa wilieke. ");
INSERT INTO ssx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Koto pa꞉la꞉pate ota꞉ honkopu wopu hake hali ma꞉nda꞉ma꞉ koto da teke hali yaapo a꞉nda꞉ pea mo da teke hali lu bepolaota꞉ ipika꞉ a꞉nda꞉ alemanu paeyao mea pelieke. Kutupa mo pake mia꞉ ale manuta꞉ telipilieke. ");
INSERT INTO ssx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ma꞉nda꞉ epita꞉ yaka yankeke na haeka꞉na꞉ta꞉ kota꞉ I̱ yaapo a꞉nda꞉ lita꞉la꞉me. Kutupa make hali ma꞉nda꞉ epima꞉ yaka sipisipi momba꞉laaso hano I̱ na tamba꞉ mia꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ta꞉ panane tolu lita꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesuma꞉ alota꞉ Hali ma꞉nda꞉na꞉ weleke pa꞉ta꞉ pila꞉ hoke temoko ma꞉nda꞉ hama opolu bao yapea꞉ka꞉na꞉ta꞉ mo hapula꞉ alena꞉ pomu lopolo hata꞉ hoto pita꞉peke da panda꞉ ma꞉nda꞉ weita꞉la꞉me. Hoto pita꞉peke ale ma꞉nda꞉ na handa꞉ wia꞉ka꞉na꞉ta꞉ kota꞉ mo hoke temokoma꞉ ipika꞉ kone alota꞉ Yaka hande mina꞉pa꞉lao epoa꞉ da nane paa la꞉ka꞉la polueke laa ");
INSERT INTO ssx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ipikana꞉ma꞉ la꞉ka꞉la pua mo da a꞉pa handilia꞉pate ma꞉nda꞉ na hake wamo pea bao epeke tupa꞉ halia꞉eki handilieke. ");
INSERT INTO ssx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Koto pa꞉leketa꞉ mo hoke temoko pua pa mandane watake hata꞉ hoke temokomanu paeyao hatuku milieke. Koto hoke temoko manuna꞉ hoke hau pita꞉la꞉ ekita꞉ mo ipiki make lu ankulalimikie. Iki paeyao mandake pa꞉ta꞉ a꞉pa halimikie. Kutu pimika꞉na꞉ta꞉ mo halita꞉ amba꞉ta꞉ hoke tupa꞉ hao pelia꞉pate ameta꞉ ota꞉ hoke tupa꞉ hao pelieke laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuma꞉ koto pi lo paeyeketa꞉ mo wanda꞉hali anka꞉lopuna꞉ pitieke wanda꞉ ma꞉nda꞉ma꞉ anekema꞉ alota꞉ Neke ma꞉nda꞉la꞉ make andu ka꞉la꞉ wanda꞉ta꞉ ta꞉na꞉ma꞉ homolo pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Koto leeke Yesuma꞉ alota꞉ Dia꞉me. Koda꞉na꞉ pi opua pu haleme wanda꞉hali ikana꞉ma꞉ta꞉ ta꞉na꞉ma꞉ wotu homa꞉peke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wanda꞉hali wopuma꞉ Yesu a꞉pa momba꞉la hopa꞉liao haena꞉ Yesuma꞉ alota꞉ Ame do natena꞉ haleme wanda꞉halita꞉ hoke wanda꞉hali halememe. Ikana꞉ma꞉ta꞉ mo na handeke patehau ma꞉nda꞉ handuluekema꞉ I̱ pa꞉ta꞉ honke aleme pateta꞉ I̱ma꞉ta꞉ iki pa꞉ta꞉ ota꞉ ma꞉nda꞉siki make na walo polopate mo hande Dionama꞉ patehau piekeeki homeke handilimikie. ");
INSERT INTO ssx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mo hande potopede hali Dionama꞉ Ninipa wanda꞉hali pa꞉ta꞉ patehau pieke tupa꞉ kone mo Wanda꞉halina꞉ Eiyekema꞉ make ame wanda꞉hali pa꞉ta꞉ patehau pilieke. ");
INSERT INTO ssx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mo hande pi yokaalu pulu pa꞉la꞉ nate opolo epea꞉ka꞉na꞉ta꞉ mo hande Siba da yu handeteke hala꞉ kuini wanda꞉ma꞉ tiao hata꞉ ame do natena꞉ haleme wanda꞉halina꞉ hoke hau manuna꞉ ma̱leke lilieke. Ekipeke mo wanda꞉ma꞉ta꞉ mo kini hali Solomonona꞉ epeke hone wotu u tekelepea wala꞉la꞉ pimanu opuluekema꞉ yeke mo kenke honiki ma꞉nda꞉ nane hao epeekeme. Kutu piekepate I̱ma꞉ iki pa꞉ta꞉ alome. Ameta꞉ Solomono ankulala꞉ ale ma꞉nda꞉ a꞉pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mo hande pi yokaalu pulu pa꞉la꞉ nate opolo epea꞉ka꞉na꞉ta꞉ Ninipa wanda꞉halima꞉ tiao hata꞉ ika꞉ hoke hauna꞉ ma̱leke lilimikie. Ekipeke. Dionama꞉ pi waleeke dina꞉ta꞉ koto wanda꞉halima꞉ ika꞉ hoke hoke haumanu hoki walemekeme. Koto pa꞉la꞉ ekina꞉ I̱ma꞉ iki pa꞉ta꞉ alome. Ameta꞉ Diona ankulala꞉ ale ma꞉nda꞉ a꞉pa꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ma꞉nda꞉ma꞉ ipika꞉ ola꞉pake ka꞉waata꞉ na a꞉mbao u hala꞉ o mo disi kawaso tieke oto pa꞉ta꞉ na wilieke. Koto hau na pikita꞉ mo da pa꞉ta꞉ wanda꞉hali a꞉pa honda꞉ pamba꞉tiki pitolo handena꞉ mo lamepa u hala꞉ alena꞉ u hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Naka꞉ leketa꞉ naka꞉ lokena꞉ ola꞉pakee. Naka꞉ leke a꞉nda꞉ ota꞉ epea꞉ka꞉na꞉ta꞉ kota꞉ naka꞉ loke paeyaota꞉ pa̱a̱ma꞉ tumbilieke. Koto pa꞉la꞉pate naka꞉ leke a꞉nda꞉ hoeya꞉ka꞉na꞉ta꞉ naka꞉ loke paeyaota꞉ timba꞉la꞉ pambilieke. ");
INSERT INTO ssx_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Koto ekina꞉ta꞉ mo naka꞉ lokena꞉ pa̱a̱ pa꞉la꞉ ekita꞉ timba꞉ na la꞉na꞉ leketa꞉ ota꞉ wopu handeteke hapeke ");
INSERT INTO ssx_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kutupa naka꞉ loke paeyao a꞉nda꞉ pa̱a̱ma꞉ tumba hata꞉ pa timba꞉ timba꞉ homeke a꞉nda꞉ na lea꞉ka꞉na꞉ta꞉ kota꞉ ola꞉pake pa̱a̱ pita꞉la꞉ ma꞉nda꞉na꞉ naka꞉ loke paeyao pa̱a̱ pu kimalieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuma꞉ pimanu lo paeyeketa꞉ Pa꞉tisi hali ma꞉nda꞉ma꞉ ne nolo pana꞉e leeke handa ipika꞉ da pa꞉ta꞉ honda꞉ pamba pua ne nolueke alo pitiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mo hande Pa꞉tisi halima꞉ta꞉ Yesuma꞉ ne noluekema꞉ ipika꞉ kiki amba꞉la na tandepeekeeki hando haota꞉ pututuma꞉ homa tola꞉tia pomiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kutu piekeeki handaata꞉ mo Teke Halima꞉ ipiki pa꞉ta꞉ alota꞉ Ameta꞉ kota꞉ iki Pa꞉tisi haliwekima꞉ta꞉ ika꞉ kapo make kawaso manuta꞉ manda homeke tandepo halemepate tukiki pa꞉ta꞉ta꞉ pasa꞉tei pita꞉la꞉ hau make hoke hoke hau paeyaoma꞉ iki tumba halememe. ");
INSERT INTO ssx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ikita꞉ hone na wiki haliwekio. Koda꞉ma꞉ hama nane wa꞉pa꞉la꞉ tupa꞉ tukiki nane make na wa꞉pa꞉la꞉pe. ");
INSERT INTO ssx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Koto ekina꞉ ika꞉ kapo make kawasomanu pa꞉ta꞉ ula꞉ ale manuta꞉ mo nate hali wanda꞉hali pa꞉ta꞉ pa hala꞉pa꞉peke. Kutu piki hau a꞉nda꞉ pimika꞉na꞉ta꞉ kota꞉ ika꞉eki paeyao ota꞉ hake wotu pilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pa꞉tisi haliwekio. Ika꞉ hoke yenki tiekena꞉ I̱ paala꞉e. Ikana꞉ma꞉ta꞉ ika꞉ hande ena꞉ hala꞉ ale tekia꞉ o totopo piki tanima꞉ handeke ale sunuta꞉ kiki yaapo telipata꞉ putupa homeke sikita꞉ Koda꞉ pa꞉ta꞉ halo halemepate mo Koda꞉ teke pa꞉ta꞉ta꞉ puki hala꞉pekeeki make epeke tikitiki piki hau manuta꞉ hone yonka꞉lalememe. Dupiki hau manuta꞉ ota꞉ pea꞉tiki pitolo hata꞉ mo mandaneeki make na mina꞉pa꞉lapeke. ");
INSERT INTO ssx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Pa꞉tisi haliwekio ika꞉ hoke yenki tiekena꞉ I̱ paala꞉e. Ikana꞉ma꞉ta꞉ oni yeni pu hala꞉ da pa꞉ta꞉ mo you haliwekina꞉ wiala꞉ sea manuna꞉ pituluekema꞉ hone wotu u haleme make oni makedi hama haleme wanda꞉halima꞉ ika꞉ biki miniliaaso Epeke daka꞉la꞉paaso꞉e la꞉tiki pina꞉ hone wopu u halememe. ");
INSERT INTO ssx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ika꞉ hoke yenki tiekena꞉ I̱ paala꞉e. Ikita꞉ wanda꞉halima꞉ mo patehau na pa꞉la꞉ hali lapa꞉ma꞉ handeke nono pelemeke handa tumbao pomu haleme haliwekima꞉ lapa꞉ma꞉ handelememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Koto leeke mo Lo Pi walo haemeke hali ma꞉nda꞉ma꞉ Yesu pa꞉ta꞉ alota꞉ Disao. Nakana꞉ma꞉ kutupiki pi ale ekima꞉ta꞉ niki manda꞉ meake nono piteleme leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesuma꞉ alota꞉ Lo Pi walo haleme haliwekio iki make ika꞉ hoke yenki tiekena꞉ I̱ paala꞉e. Ikana꞉ma꞉ wanda꞉halina꞉ hoki mandata꞉ ma꞉nda꞉ma꞉ tia꞉peke na yeke ka꞉nda꞉ piki alemanu mea tiao halemepate ikana꞉ma꞉ta꞉ ika꞉ kiki ma̱leke kone tindipao na tamba꞉ mea tialimikie. ");
INSERT INTO ssx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ika꞉ hoke yenki tiekena꞉ I̱ paala꞉e. Ikana꞉ma꞉ta꞉ mo hande potopede haliwekina꞉ toko ula꞉ apa꞉nda꞉ta꞉ epeke tupa꞉ wamo pea wiao halememe. Pate koto potopede haliwekita꞉ hande ika꞉ apa꞉mei tonuma꞉ kone lia꞉tiki pimiki haliwekie. ");
INSERT INTO ssx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ikana꞉ma꞉ ika꞉ apa꞉meima꞉ pimiki ekina꞉ ta꞉na꞉ma꞉ homo haloma꞉me alememe. Pa ekipeke ika꞉ apa꞉meima꞉ta꞉ mo potopede haliweki pa lu pitaemeke handa ikana꞉ma꞉ta꞉ ika꞉ apa꞉nda꞉ manuta꞉ wamo peao halememe. ");
INSERT INTO ssx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Doeki tekena꞉ta꞉ Koda꞉na꞉ epeke hone wotu wita꞉la꞉ ekima꞉ta꞉ do la꞉la꞉me. I̱ma꞉ta꞉ yaka potopede haliweki make pi mea pomuao haleme haliweki tapaalo polopate mandaneta꞉ lu baalimiki make mandaneta꞉ tanda tanda wopu halimikie laa la꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Koto ekina꞉ta꞉ mo hande do ya yu kini pea a꞉pa ame do limiki potopede haliweki paeyao limiki ekina꞉ hoke yenkita꞉ ame do haleme wanda꞉halima꞉ milimikie. ");
INSERT INTO ssx_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mo hande Eipolo limikieki kini pea a꞉pa mo hande oloda pita꞉ yako piki da yaapo tukiki pa꞉ta꞉ a꞉mbolo hata꞉ limiki hali Sekataiya alome. Aowe. I̱ma꞉ iki pa꞉ta꞉ ota꞉ loa꞉ma꞉ ame do wanda꞉halita꞉ koto limikieki paeyaona꞉ hoke yenki milimikie. ");
INSERT INTO ssx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mo Lo Pi walo haleme haliweki ika꞉ hoke yenki tiekena꞉ I̱ paala꞉e. Ikana꞉ma꞉ta꞉ mo hande hone wotu mia꞉peke da pota꞉na꞉ kita꞉ ika꞉ wia halemepate koneta꞉ ika꞉ kone na honda꞉ pambeketa꞉ mo honda꞉ pambuluekema꞉ taapeleme wanda꞉halita꞉ sa꞉sa꞉ pu halememe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesuma꞉ koto da mina꞉pa꞉lao peeke naneta꞉ mo Lo Pi walo haemeke haliwekima꞉ make Pa꞉tisi haliwekima꞉ make Yesuta꞉ ota꞉ hoke tetopiki tupa꞉ kitaaso hata꞉ ane mone alena꞉ ipiki pa꞉ta꞉ lota꞉ pita꞉la꞉eki wotu halemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kutu pimiki hauta꞉ Yesu hona꞉ma̱o̱ tamuluekema꞉ make ipikana꞉ma꞉ ata꞉ka꞉ piki pi ma꞉nda꞉ lea꞉ka꞉na꞉ minulua꞉ patema꞉ lemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wanda꞉hali pisetekema꞉ ika꞉ ika꞉ kone lu tumbapeke nono pea mombololo haena꞉ Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ amba꞉la alota꞉ Ikana꞉ma꞉ mo Pa꞉tisi haliwekina꞉ palaowa pombeiyaasa꞉ ale yisiti wotu handeteke hapa꞉peke. Doeki alo ekita꞉ ika꞉ yayapiki makeaaso hauna꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Panka꞉ wilimi ekimanu paeyaota꞉ wetepena꞉ta꞉ pa peneme yaalieke. Kutupa mo a꞉mbao aleme pimanu paeyaota꞉ wetepena꞉ peneme yaalieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Koto ekina꞉ ikana꞉ma꞉ mo timba a꞉mbao leleme pi manuta꞉ paa natena꞉ opina꞉ lelimikie. Kutupa pota꞉ poka꞉la꞉ da panda꞉ pa꞉ta꞉ pita꞉ ma꞉nda꞉na꞉ haleke pa꞉ta꞉ tome pambele pita꞉ paeyaoma꞉ opina꞉ yeke da holu manda nina꞉ tiao hata꞉ pi anekema꞉ lelimikie. ");
INSERT INTO ssx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ya yankeke tonuo. I̱ma꞉ iki pa꞉ta꞉ aloma꞉ Mo ika꞉ manda loke lu homaemeka꞉na꞉ta꞉ wetepe nane hau ma꞉nda꞉ pea꞉peke na ya꞉la꞉ wanda꞉hali pa꞉ta꞉ta꞉ paala꞉ma꞉ na homa꞉pa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ikana꞉ma꞉ mo hali homeke ma꞉nda꞉ liaata꞉ ipika꞉ temokota꞉ oni ti to hala꞉ ale pa꞉ta꞉ baapeke ya꞉la꞉ wele pa꞉la꞉ Koda꞉ pa꞉ta꞉ paala꞉ma꞉ homa꞉pa꞉peke. Iki pa꞉ta꞉ ota꞉ loa꞉ma꞉ Ipiki pa꞉ta꞉ homeke paala꞉ma꞉ homa꞉pa꞉peke aleo. ");
INSERT INTO ssx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mo hande wesoma꞉ handeke basunu yunki hata꞉ 20 toeama꞉ hambo halemeke yekea. Koto pa꞉la꞉pate Koda꞉ma꞉ta꞉ koto wesoma꞉ handeke ba sikita꞉ homeke kone hone na yonka꞉lala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Koto tupa꞉ kone ika꞉ you itiki paeyao make amba꞉ yata꞉pa꞉ ta꞉pao ana꞉ lao ula꞉me. Koto ekina꞉ta꞉ ikana꞉ma꞉ paala꞉ma꞉ na homo hapa꞉peke. Pa ekipeke. Ika꞉ tombota꞉ koto hosiki ba sunu wopuna꞉ yenki ota꞉ lombei pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesuma꞉ alota꞉ I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi alome. Ma꞉nda꞉ epima꞉ wanda꞉halina꞉ leke popelekena꞉ peneme yaaso hata꞉ I̱ta꞉ Ketisona꞉ halie lea꞉ka꞉na꞉ta꞉ kota꞉ mo Wanda꞉halina꞉ Eiyekema꞉ make mo Koda꞉na꞉ enisolo manuna꞉ leke popelekena꞉ make homeke hau kone pilieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pate ma꞉nda꞉ hali epima꞉ wanda꞉halina꞉ leke pototona꞉ hata꞉ yaka biki na leke kiaeya꞉ka꞉na꞉ta꞉ kota꞉ mo Wanda꞉halina꞉ Eiyekema꞉ta꞉ Koda꞉na꞉ enisolo manuna꞉ leke pototona꞉ hata꞉ ipika꞉ biki make na leke kiaalieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ma꞉nda꞉ epima꞉ Wanda꞉halina꞉ Eiyeke pa꞉ta꞉ hoke pimanu lea꞉ka꞉na꞉ta꞉ kota꞉ koto ekita꞉ pa paeyaapeke ya꞉la꞉pate pa ma꞉nda꞉ epima꞉ Holi Sipitidi kitake hoke pimanu lea꞉ka꞉na꞉ta꞉ kota꞉ koto ekita꞉ ota꞉ na paeyawalieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ma꞉nda꞉ epima꞉ iki pi yokaalu puluekema꞉ ika꞉ pi hotu haleme da pa꞉ta꞉manu make o mo kapomani haliweki pa꞉ta꞉ make o handeteke haleme haliweki pa꞉ta꞉ hatuku pemeka꞉na꞉ta꞉ kota꞉ ikana꞉ma꞉ta꞉ eki pi lolua꞉pe o ekipa ya kone tamba꞉ miki pi lolua꞉pe laa ka꞉nda꞉ma꞉ na homo taapa꞉peke ");
INSERT INTO ssx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pa ekipeke. Mo Holi Sipitidima꞉ta꞉ koto nate leke sikina꞉ kone ika꞉ lolo peleme pi manuta꞉ walekena꞉ walieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wanda꞉hali momba꞉la haemeke tukiki pa꞉ta꞉ hayeke hali homekema꞉ Yesu pa꞉ta꞉ alota꞉ Disao. Yaka kamema꞉ dika꞉ apa꞉na꞉ anke teketa꞉ yakaeki telipa kina꞉ lawae leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesuma꞉ ipika꞉ pi hombo peaaso alota꞉ Someo. Ipilika꞉ alemanu telipaano make ipilika꞉ pi tikitiki yawaanota꞉ I̱ta꞉ epima꞉ mea haena꞉ la꞉la꞉pe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Koto laa Yesuma꞉ paeyao pa꞉ta꞉ alota꞉ Handeteke hapa꞉peke. Hande pasa꞉tei hau ta꞉ta꞉ ta꞉ta꞉ pikieki a꞉paapa꞉na꞉ ika꞉ kone wopu handeteke hata꞉ leke leke lo hapa꞉peke. Wanda꞉hali paeyaoma꞉ hamoko tieke ekipa haena꞉ kone ika꞉ da꞉ta꞉la꞉ ekina꞉ teketa꞉ ika꞉ wia haleme alemanu pa꞉ta꞉ na ula꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Koto laa Yesuma꞉ iki pa꞉ta꞉ onkoluma꞉ pi dupa leekeme. Amba꞉ a꞉nda꞉ta꞉ mo hamoko hali ma꞉nda꞉na꞉ e pa꞉ta꞉ ne napekemanu wotu wiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kutupa mo halima꞉ ipika꞉ honema꞉ kone alota꞉ Mo hande ne napekemanu poka꞉ mepi pea wia꞉peke alena꞉ ana꞉ na pa꞉la꞉ma꞉ eki puluepe laa hone wiekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kutupa ipika꞉ honema꞉ kone alota꞉ Dupulueke. Yaka ne napekemanu u hala꞉ damanu londa꞉la kutupa da tieke tiekemanu a꞉eyaata꞉ mo ne napekemanu make yaka mandane alemanu paeyao make koto da pa꞉ta꞉manu mu ulueke laata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","kota꞉ ya kone dupa lolueke. Naka꞉ta꞉ yolee. Naka꞉ wia hale ale manuta꞉ bapi wotu kone ana꞉na꞉ wilieke laa Ameta꞉ pa pitu hata꞉ ne ikali nalo hata꞉ ta꞉na꞉ma꞉ homo hapeke lolueke leekepate ");
INSERT INTO ssx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Koda꞉ma꞉ ipiki pa꞉ta꞉ alota꞉ Neketa꞉ hone na wiki halio. Ame do timba kone naka꞉ da꞉ta꞉la꞉eki pao yokulueke. Kutu pua꞉ka꞉na꞉ta꞉ kota꞉ nakana꞉ma꞉ naka꞉eki laa wia hale ale manuta꞉ epima꞉ milia꞉pe laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kutupa Yesuma꞉ pi paeyaaso alota꞉ Hali epima꞉ Dota꞉ yakaeki homekee laa alemanu wopu mu momba꞉la꞉tiki pita꞉la꞉ dina꞉ta꞉ Koda꞉na꞉ leke popelekena꞉ta꞉ pa natehali hala꞉me. Kota꞉ dupiki some a꞉nda꞉ta꞉ mo hande titina꞉ loa꞉ haumanu pa꞉ta꞉ opolo ipilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Koto hoki naneta꞉ Yesuma꞉ ipika꞉ disaipolo haliweki pa꞉ta꞉ alota꞉ I̱ma꞉ do alo ekita꞉ ikana꞉ma꞉ iki pa hapeke ekina꞉ nemanu make lokena꞉ yama꞉peke alemanu koto alemanu pa꞉ta꞉ta꞉ ka꞉nda꞉ma꞉ na homo hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pa ekipeke. Da꞉ta꞉la꞉ ekima꞉ta꞉ ne ota꞉ lombei pa꞉la꞉ make mo lokema꞉ta꞉ dau make ota꞉ lombei pu pa꞉la꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ba manuna꞉ hau handa꞉pa꞉peke. Ikana꞉ma꞉ta꞉ e wae alemanu na nokopata꞉ na mondu no halememe. Ika꞉ sidowa o ne amu pu u haleme da ma꞉nda꞉ na hala꞉me. Koda꞉ma꞉ taa halo hala꞉ handa꞉e. Koto ekina꞉ta꞉ ikana꞉ma꞉ mo ba manuta꞉ taa lu ankulalemetaa. ");
INSERT INTO ssx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Iki ma꞉nda꞉ epima꞉ ipika꞉ hone wopu wita꞉la꞉ ekima꞉ ipika꞉ do kenkena꞉ halo pa꞉la꞉ nate leke manuta꞉ mu moneao ulu pua꞉peke ya꞉la꞉pe. ");
INSERT INTO ssx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kota꞉ koto hosiki ale siki kone na pea꞉peke ya꞉ka꞉na꞉ta꞉ pa ekipeke mo mandane ale pa꞉ta꞉ manuta꞉ ka꞉nda꞉ma꞉ homo halemepe. ");
INSERT INTO ssx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mo hapeke pa꞉ta꞉manu pa opa꞉la꞉ moma sununa꞉ opa꞉la꞉ ekita꞉ handa꞉pa꞉peke. Ikana꞉ma꞉ta꞉ e na poko make aka꞉manu na tombulu yamo halememe. Koto pa꞉la꞉pate I̱ma꞉ iki pa꞉ta꞉ alome. Kini Solomonoma꞉ta꞉ hamoko alemanu wotu wiekepate kone do moma manuna꞉ loke hake dau epeke epeke ekimanu ma꞉nda꞉ ota꞉ na wia hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mo ame homeke opa haena꞉ laa beliata꞉ tunkula hapuao tina꞉ yanka꞉peke yeke ambu manuna꞉ au kone Koda꞉ma꞉ lawao haya꞉ka꞉na꞉ta꞉ a꞉pei kota꞉ ika꞉ hone tulaaseme ekita꞉ ota꞉ hodiki ale siki ya꞉ka꞉ta꞉me. Koto alemanu pa꞉ta꞉ kone Koda꞉ma꞉ kutu pu haya꞉ka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ iki make dau ota꞉ ana꞉na꞉ kone yamatiki pilieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kutu piliekema꞉ ikana꞉ma꞉ta꞉ Ya nolo polo ne ikali hanema꞉ epea꞉ka꞉na꞉ mulua꞉pe laa ka꞉nda꞉ma꞉ na homo hapa꞉peke. ");
INSERT INTO ssx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mo Koda꞉na꞉ biki na opeleme wanda꞉halima꞉ta꞉ hoto paeyao koto alemanu hone wopu u halememe. Pate ika꞉ Apa꞉ma꞉ta꞉ koto alemanu nate paeyao ikana꞉ma꞉ mu halo peleme ekita꞉ hone ula꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Koto pa꞉la꞉ ekina꞉ta꞉ ikana꞉ma꞉ta꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉eki amba꞉la weiyu haemeka꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ mo koto ale manuta꞉ haka꞉ta꞉pao ku halieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yaka sipisipi ma꞉na꞉ tapake sikio. Paala꞉ma꞉ na homa꞉pa꞉peke. Pa ekipeke ika꞉ Apa꞉ma꞉ta꞉ oli hande Kilu Tombuao Hala꞉ ekita꞉ iki pa꞉ta꞉ kuluekema꞉ta꞉ ta꞉na꞉ma꞉ homo hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ika꞉ ala꞉ta꞉ ala꞉ta꞉ta꞉ tapao mani meaata꞉ mo natehali wanda꞉hali pa꞉ta꞉ hala꞉pa꞉peke. Kutupa na kukutu pulu pa꞉la꞉ mani pausa meaata꞉ ika꞉ hamoko ale manuta꞉ oli ya nane na paeya꞉niake pa wia halo pelemeeki homeke amu pu hapa꞉peke. Ekipeke koto naneta꞉ mo pake no haleme haliwekima꞉ make bisapu inkikima꞉ make na hoeyaalimikie. ");
INSERT INTO ssx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ika꞉ hone manuta꞉ mo ika꞉ epeke epeke alemanu u haleme ale pa꞉ta꞉ mandakena꞉ u pelia halimikie. ");
INSERT INTO ssx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ikana꞉ma꞉ta꞉ mo e pokaasa꞉ haliweki tupa꞉ hata꞉ta꞉ ika꞉ you halita꞉ hali ma꞉nda꞉ma꞉ wanda꞉ panake mea ne pamba꞉la꞉ ekina꞉ pa꞉leke handaa paa epena꞉ yu wia haleme tupa꞉ ikana꞉ma꞉ta꞉ ika꞉ aka꞉manu wotu soto la꞉tia haena꞉ yama ika꞉ ola꞉pakemanu ka꞉watia hata꞉ta꞉ anemone ipilia꞉ ekimanu lekema꞉ lekema꞉ pitolo hata꞉ hao hapa꞉peke. Koto ekina꞉ta꞉ mo you halima꞉ a꞉pa pota꞉ lia꞉ka꞉na꞉ta꞉ kota꞉ koto kone lombilimikie. ");
INSERT INTO ssx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kutupa mo you hali paa la꞉ka꞉la a꞉pa mo ipika꞉ e pokaaseme hali wekita꞉ u̱ na polu pitiki a꞉nda꞉ pa ipiki yu wia pilimieki a꞉pa handea꞉ka꞉na꞉ta꞉ kota꞉ ikita꞉ ta꞉na꞉ma꞉ homo halimikie. I̱ma꞉ iki pa꞉ta꞉ ota꞉ pi aloma꞉ Mo haliwekima꞉ koto hau pimiki yeke handaa ika꞉ you halima꞉ta꞉ ipika꞉ manda aka꞉ hola wiaata꞉ iki pa꞉ta꞉ Ne no hala꞉ alena꞉ a꞉pa pita꞉pe laa ne pana꞉ pu kilieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kutupa make mo you halita꞉ buta꞉ hokina꞉ o hoki nane kone epea꞉ka꞉na꞉ ikana꞉ma꞉ tiki tiki yao ipiki yu wia pilimieki handea꞉ka꞉na꞉ta꞉ kota꞉ ikita꞉ ta꞉na꞉ma꞉ homo halimikie. ");
INSERT INTO ssx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kutupa make doeki hone wotu wia꞉pa꞉peke. Mo da teke hali ma꞉nda꞉ma꞉ mo pake nala꞉ hali ma꞉nda꞉ epolo pa꞉la꞉eki amba꞉ handa꞉ wia꞉ka꞉na꞉ta꞉ kota꞉ koto someta꞉ oni ipika꞉ da yamba꞉la na yapena꞉ lelieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Iki make ota꞉ tikitiki yao hapa꞉peke. Pa ekipeke. Mo hande Wanda꞉halina꞉ Eiyeketa꞉ ipilieke hone na witolo halimi di nina꞉ ipilieke laa loa꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pidama꞉ alota꞉ Tekehalio. Nakana꞉ma꞉ do ale onkoluma꞉ pita꞉ niki pa꞉ta꞉ homeke alepe o mo wanda꞉hali paeyao pa꞉ta꞉ alepe laa lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Koto leeke mo Tekehalima꞉ Pidana꞉ pi hombo peaaso alota꞉ Kima꞉ na homeke make ota꞉ epeke hone wotu u lenkene pu wia e poko halia꞉ halita꞉ epi ya꞉ka꞉ta꞉pe. Koto halita꞉ mo da teke halima꞉ta꞉ ipika꞉ da handeteke haena꞉yeke make mo ipika꞉ mandane e pokao haleme wanda꞉hali pa꞉ta꞉ ika꞉ ne no haleme di mia꞉ka꞉na꞉ta꞉ ika꞉ ne nena꞉ teli teli peao halieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ipika꞉ you hali paa la꞉ka꞉la a꞉pa ipika꞉ e pokao hala꞉ halima꞉ mo hande emanu ota꞉ epeke tupa꞉ pitolo pitilia꞉eki a꞉pa handa꞉ ya꞉ka꞉na꞉ta꞉ kota꞉ koto e pokao hala꞉ halita꞉ ta꞉na꞉ma꞉ homo halieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ota꞉ alome. Mo you halima꞉ta꞉ koto someta꞉ ipika꞉ ala꞉ta꞉ ala꞉ta꞉ paeyao handeteke haena꞉ la꞉lieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kutu pulu pa꞉la꞉pate mo e pokaasa꞉ halima꞉ta꞉ ipika꞉ kone alota꞉ Yaka you someta꞉ di hokulu hokulu pitolo hata꞉ a̱i̱ na ipula꞉me laa mo mandane e pokaasa꞉ wanda꞉ pita꞉ hali yaapo kini pea hali lu yombitolo hata꞉ ikali ne nalo keaaso hata꞉ ");
INSERT INTO ssx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ipika꞉ you halita꞉ Do natena꞉ ipilieke hone na witolo halia꞉ natena꞉ta꞉ koto kone opolo ipilieke. A꞉paata꞉ mo e pokaasa꞉ halita꞉ homena꞉ liaata꞉ pa pi na opiki wanda꞉hali ame̱le̱ haena꞉ la꞉lieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mo e pokaasa꞉ hali ma꞉nda꞉ epima꞉ ipika꞉ you halima꞉ pea꞉peke la꞉la꞉ haumanu hone wia ipikana꞉ma꞉ ipika꞉ kone ana꞉ lao na piki ipika꞉ you halima꞉ pea꞉peke la꞉la꞉ haumanu na pia꞉ka꞉na꞉ta꞉ kota꞉ koto halita꞉ mo you halima꞉ dopitama꞉ podela꞉ mia꞉ka꞉na꞉ta꞉ tanda tieke nelieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pate e pokaasa꞉ hali ma꞉nda꞉ma꞉ta꞉ ipika꞉ you halima꞉ hone pa꞉la꞉eki hone na witolo kone tanda napekeeki pia꞉ka꞉na꞉ta꞉ kota꞉ ipikita꞉ ae̱ya̱piki dopitama꞉ hosiki podela꞉ milieke. Hali ma꞉nda꞉ta꞉ mandane alemanu handeteke haena꞉ yeke anekema꞉ halea꞉ka꞉na꞉ta꞉ kota꞉ mo hali pa꞉ta꞉ yama꞉ta꞉ anekema꞉ muluekema꞉ hone wilieke. Koto tupa꞉ kone hali ma꞉nda꞉ pa꞉ta꞉ ala꞉ta꞉ ma꞉nda꞉ wopu handeteke haena꞉ yeke halea꞉ka꞉na꞉ta꞉ kota꞉ mo hali pa꞉ta꞉ yama꞉ta꞉ ota꞉ ankulao anekema꞉ muluekema꞉ hone wilieke leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesuma꞉ alota꞉ I̱ epolo ekita꞉ ti ulekema꞉ do kenkena꞉ mo yaaluekema꞉ epoa꞉pate ya honema꞉ta꞉ amba꞉ kone talo hapeke alee. ");
INSERT INTO ssx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","I̱ta꞉ bapitaisi pea꞉peke hau homeke mulueke hone ulupate pa a̱i̱ na pu paeyaaso ekina꞉ kota꞉ yaka weleke pukima꞉ ka꞉nda꞉ tieke minolome. ");
INSERT INTO ssx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ika꞉ honema꞉ta꞉ I̱ma꞉ta꞉ ika꞉ a꞉nda꞉ piteleme ekimanu homu pealo epoa꞉me hone wi witelemepe. Ota꞉ dia꞉me. I̱ta꞉ wanda꞉hali tapake tekili pawaluekema꞉ epoa꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ame do hao kini peaata꞉ wetepena꞉ make tapakesiki yunki hata꞉ma꞉ ika꞉ kone tekilipa tepoma꞉ta꞉ yaapo pa꞉ta꞉ a꞉nda꞉ litolo hata꞉ yaapo sikima꞉ta꞉ pa tepo pa꞉ta꞉ a꞉nda꞉ lia꞉tiki pu halimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ateke tonuma꞉ta꞉ pa eiyeke ame̱le̱ a꞉nda꞉ lualu peaata꞉ eiyeke tonuma꞉ta꞉ ateke tonu ame̱le̱ a꞉nda꞉ lualu pilimikie. Inkiki tonuma꞉ta꞉ waneke tonu ame̱le̱ a꞉nda꞉ lualu peaata꞉ waneke tonuma꞉ta꞉ inkiki tonu ame̱le̱ a꞉nda꞉ lualu pilimikie. Halikina꞉ inkiki tonuma꞉ta꞉ ika꞉ aeya꞉ tonu ame̱le̱ a꞉nda꞉ lualu peaata꞉ mo aeyeke tonuma꞉ta꞉ ika꞉ halikina꞉ inkiki tonu ame̱le̱ a꞉nda꞉ lualu pilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuma꞉ mo wanda꞉hali pa꞉ta꞉ alota꞉ Ikana꞉ma꞉ oni nate pamba꞉la꞉ nane yama꞉ ipula꞉ koa handolota꞉ kota꞉ koto kone ikana꞉ma꞉ alota꞉ Lako ipilieke lo halemeketa꞉ kota꞉ ota꞉ ipu hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kutupa oni ka꞉wa꞉na꞉ yu nanema꞉ tilao po ipula꞉eki handolota꞉ kota꞉ ikana꞉ma꞉ koto kone alota꞉ Nate tieke talo hata꞉ titipu tieke pilieke lo halemeketa꞉ ota꞉ titipu tieke pu hala꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Makeaasa꞉ hau pu haleme haliwekio. Ikana꞉ma꞉ta꞉ do ya yu nane pita꞉la꞉ ekimanu handolo hata꞉ dupilieke aleme ekita꞉ ota꞉ yao hala꞉pate pa ekipeke ame do natena꞉ ipula꞉ hau manuna꞉ teketa꞉ na handa꞉ witolo pimipe leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ekipeke handaa ika꞉ kone mo epeke hau pia꞉peke ekita꞉ na teli pitolo pimipe. ");
INSERT INTO ssx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Hali ma꞉nda꞉ma꞉ neketa꞉ pi yokaaluna꞉ hatuku poluekema꞉ pia꞉ka꞉na꞉ta꞉ kota꞉ a̱i̱ na peke hata꞉ kone nakana꞉ma꞉ tiki tiki yaaluekema꞉ taapa꞉peke. Nakana꞉ma꞉ koto hau na pika꞉na꞉ta꞉ kota꞉ ipikana꞉ma꞉ neketa꞉ oli pi yokaalu pu hala꞉ hali teke pa꞉ta꞉ yola꞉ mea puaata꞉ pa koto halima꞉ta꞉ mo polisi haliwekina꞉ kikina꞉ mea halaata꞉ neketa꞉ dipula da pa꞉ta꞉ mea pitalieke. ");
INSERT INTO ssx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kutupa neke pa꞉ta꞉ Mo opisi hamba꞉e lelia꞉ tupa꞉ a̱i̱ na hambo paeyaeka꞉na꞉ta꞉ kota꞉ neketa꞉ koto pa꞉ta꞉ pa pita꞉ pelia halipikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Koto natena꞉ta꞉ koto pa꞉ta꞉ haemeke mandane haliwekima꞉ Yesu pa꞉ta꞉ a꞉pa mo Pailedima꞉ Ka꞉lili mandane haliwekita꞉ ika꞉ hotekemanu lia Koda꞉ pa꞉ta꞉ halolo haena꞉ kone lieke ekina꞉ pi la halemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Koto ekina꞉ Yesuma꞉ ika꞉ pi hombo peaaso alota꞉ Mo Ka꞉lili haliweki paeyaota꞉ hoke hau pu halemepate ika꞉ honema꞉ta꞉ mo hande limiki haliwekima꞉ hoke hau ota꞉ haka꞉ta꞉pao pimiki yeke handa liekeme hone witelemepe. ");
INSERT INTO ssx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ota꞉ dia꞉me. I̱ma꞉ iki pa꞉ta꞉ ota꞉ loa꞉me. Iki make ika꞉ piteleme hoke haumanu na kiaemeka꞉na꞉ta꞉ kota꞉ iki make mo hande Ka꞉lili haliweki homemeke tupa꞉ kone homilimikie. ");
INSERT INTO ssx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kutupa make mo hande Sailoa꞉me da pa꞉ta꞉ haliao a꞉emeke da hokulu tieke lombolo hata꞉ lu sesape pieke 18 wanda꞉hali pa꞉ta꞉ta꞉ eki hone witelemepe. Mo hande dama꞉ lieke ekina꞉ta꞉ ika꞉ hoke hauta꞉ mo Diutuseleme haleme wanda꞉hali paeyaona꞉ pimiki hoke hau ota꞉ lombei peake tupa꞉ pimikieki peneme yaasa꞉pe. ");
INSERT INTO ssx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ota꞉ dia꞉me. I̱ma꞉ iki pa꞉ta꞉ ota꞉ loa꞉me. Iki make ika꞉ piteleme hoke haumanu na kiaemeka꞉na꞉ta꞉ kota꞉ koto tapake homemeke tupa꞉ kone homilimikie leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kutupa Yesuma꞉ iki pa꞉ta꞉ onkoluma꞉ pi ma꞉nda꞉ dupa leekeme. Amba꞉ hali ma꞉nda꞉ma꞉ ipika꞉ e tukikina꞉ta꞉ nose ti ma꞉nda꞉ nokopeekeeki hayekeme. Mo halima꞉ta꞉ mo nose kiliki a꞉ela꞉ patema꞉ handolo endi pu hayekepate homeke a꞉nda꞉ na a꞉eyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Koto ekina꞉ta꞉ mo halima꞉ ipika꞉ e pokao hayeke hali pa꞉ta꞉ alota꞉ Handa꞉e. Bapi tepo tukiki pa꞉ta꞉ta꞉ do nose tina꞉ kiliki a꞉ela꞉pe laa handolo endi pu halopate homeke a꞉nda꞉ ota꞉ na a꞉ela꞉me. Koto pa꞉la꞉ ekina꞉ta꞉ do hoke tima꞉ mo epeke kenke pa hameke naata꞉ paama꞉na꞉ poko bae leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Koto leekepate mo e pokaeyeke halima꞉ alota꞉ Yaka tiekeo. Bapi homekena꞉ pa haena꞉ lae. I̱ma꞉ do ti teke hopa꞉liao yu lia kao imanu lekeluekema꞉ loa꞉me. ");
INSERT INTO ssx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yaka honema꞉ta꞉ mone mo bapina꞉ kiliki a꞉eya꞉ka꞉na꞉ta꞉ ota꞉ epolo pa꞉la꞉pate na a꞉eya꞉ka꞉na꞉ta꞉ kota꞉ pao poko baena꞉ lolena꞉e laa leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mo hoto pila꞉ nate ma꞉nda꞉na꞉ Yesuta꞉ mo pi hotu haemeke da ma꞉nda꞉ pa꞉ta꞉ pi walo hayekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Koto pa꞉ta꞉ta꞉ hoke temoko pitieke wanda꞉ ma꞉nda꞉ pitiekeme. Kutu pieke ekima꞉ kone mo wanda꞉ta꞉ 18 bapina꞉ yeni mea hao hayeke ekima꞉ mo wanda꞉na꞉ hoki hoi peaota꞉ tindipapeke na yeekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuma꞉ mo wanda꞉ hando hao wi la꞉moneaso alota꞉ Wanda꞉o. Neketa꞉ naka꞉ yeni ta paetolo hata꞉ neketa꞉ walekena꞉ ta hale handa꞉e. ");
INSERT INTO ssx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Koto laa Yesuma꞉ ipika꞉ kiki mo wanda꞉na꞉ loke manda wieke dina꞉ koto kone ipikana꞉ma꞉ ipika꞉ hoki tindi paeyekeme. Koto ekina꞉ta꞉ Koda꞉na꞉ biki mea miniliaeyekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kutu pieke handaa mo pi hotu haemeke da handeteke hayeke halima꞉ta꞉ Yesuma꞉ mo wanda꞉ta꞉ mo Hoto Pila꞉ Natena꞉ kone epeaeyeke handa Yesu yaapo mineke pankeekeme. Koto ekina꞉ ipikana꞉ma꞉ mo wanda꞉hali pa꞉ta꞉ alota꞉ E poka꞉peke nate manuta꞉ yunki mindiki hata꞉ taama꞉ ika꞉ yenimanu epeaena꞉ hone wimika꞉na꞉ta꞉ kota꞉ koto nate nina꞉ a꞉pa꞉peke ya꞉la꞉pate pa do Hoto Pila꞉ Natena꞉ta꞉ ota꞉ dia꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mo Tekehalima꞉ ipika꞉ pi hombo peaaso alota꞉ Makeaasa꞉ hau pu haleme haliwekio. Iki ma꞉nda꞉ hondoma꞉ mo Hoto Pila꞉ Natena꞉ ika꞉ kao o donki ma꞉na꞉ make mo ho̱linda꞉ pa꞉ta꞉ mea hama lomba꞉ ta꞉pao ikali na꞉na꞉yeke mea pelimikie. ");
INSERT INTO ssx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Koto tupa꞉ kone do Eipoloha꞉ma꞉na꞉ tapake wanda꞉ta꞉ hoke temokoma꞉ 18 bapina꞉ tonkao ula꞉ puta꞉ mo Hoto Pila꞉ Natena꞉ta꞉ na ka꞉la꞉pa꞉ tapaena꞉pe laa lota꞉ piekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Koto hombo peayeke ekima꞉ta꞉ Yesu ipika꞉ a꞉nda꞉ tunkuliki haliwekima꞉ yaala꞉ma꞉ homolo haena꞉ta꞉ mo wanda꞉halima꞉ta꞉ mo epeke haumanu piekeeki handolo hata꞉ ta꞉na꞉ma꞉ wotu homemekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesuma꞉ alota꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekita꞉ alekema꞉ handa꞉la꞉pe laa manda꞉ meanope. ");
INSERT INTO ssx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mo Kilu Tombuao Hala꞉ ekita꞉ mo (ki̱mi̱le̱ma꞉ handeke) masidadi wae ale sikita꞉ hali ma꞉nda꞉ma꞉ mea ipika꞉ ena꞉ tande leekeeki opaata꞉ ota꞉ aneke ti hombeleke hao paleke palekena꞉ ba titima꞉ dake hapeke ya꞉la꞉me leekeme. ");
INSERT INTO ssx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kutupa Yesuma꞉ paa make lota꞉ pitolo alota꞉ Koda꞉na꞉ Kilu Tombuao Hala꞉ ekita꞉ alekema꞉ manda꞉ mealua꞉pe. ");
INSERT INTO ssx_vpl VALUES ("LK13_21","072_13_21","LUK","13",