﻿USE sofia;
DROP TABLE IF EXISTS sofia.ssg_vpl;
CREATE TABLE ssg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ssg_vpl WRITE;
INSERT INTO ssg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ie se sale nenex ti Jises Krais. Jises Krais i nakuama ti David a David nakuama ti Abraham. ");
INSERT INTO ssg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham tel tame Aisak, Aisak tel tame Jekop, Jekop tel tame Juda ma tesol ukalan. ");
INSERT INTO ssg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda tel tame Peres ma Sera, tinalalu Tamar. Peres tel tame Hesron, Hesron tel tame Ram. ");
INSERT INTO ssg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram tel tame Aminadab, Aminadab tel tame Nason, Nason tel tame Salmon. ");
INSERT INTO ssg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon tel tame Boas, tinan Rahab. Boas tel tame Obed, tinan Rut. Obed tel tame Jesi. ");
INSERT INTO ssg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi tel tame tel masiwi David. David tel tame Solomon, tel tini Solomon tetel axoi Uraia axan Batseba. ");
INSERT INTO ssg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon tel tame Rehoboam, Rehoboam tel tame Abija, Abija tel tame Asa. ");
INSERT INTO ssg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa tel tame Jeosapat, Jeosapat tel tame Jeoram, Jeoram tel tame Usaia. ");
INSERT INTO ssg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia tel tame Jotam, Jotam tel tame Ahas, Ahas tel tame Hesekaia. ");
INSERT INTO ssg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia tel tame Manase, Manase tel tame Amon, Amon tel tame Josaia. ");
INSERT INTO ssg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia tel tame Jehoiakin ma tesol ukalan. Tataen ien teka Israel kalabus hani Babilon. ");
INSERT INTO ssg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Muhin ti lato kalabus kewa ti Babilon: Jehoiakin tel tame Sealtiel, Sealtiel tel tame Serubabel. ");
INSERT INTO ssg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel tel tame Abiud, Abiud tel tame Eliakim, Eliakim tel tame Asor. ");
INSERT INTO ssg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor tel tame Sadok, Sadok tel tame Akim, Akim tel tame Eliud. ");
INSERT INTO ssg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud tel tame Eleasar, Eleasar tel tame Matan, Matan tel tame Jekop. ");
INSERT INTO ssg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop tel tame Josep, tel axoi Mary, tetel tini Jises, tel Krais Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tataen Abraham hanima David, nakuale huopanim hinalo. David hanima tataen ti lato kalabus hani Babilon, nakuale tin huopanim hinalo ape huopanim hinalo hani tataen takahe Krais. ");
INSERT INTO ssg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sale takahe Jises Krais. Tel tinan Mary laha kilami hani axoi Josep, tuahe imat ti lalu sal, liai i petiwen akaik ti pohe Holi Spirit. ");
INSERT INTO ssg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep se seilon sawisawin, i watakai hahienai Mary ti puli lawe seilon. Aile ape i namiloi na i tua lioi hakokol Mary. ");
INSERT INTO ssg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lokon ti i to nanamiloi, tel engel, spirit solian ti tel Masiwi Haeu, sohot hani i ti paxangongo, i ukek, “Josep, tel kahi nati David, kum maamata waxiai axoam Mary. Tel akaik he tian i pet ti pohe Holi Spirit. ");
INSERT INTO ssg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I hatakaha tel akaik wawan, o axaiwa axan Jises nake i awai seilon ti kawate saun lialun ti laha.” ");
INSERT INTO ssg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Hatesol waliko ie i sohot hapoponowi hawane kakai Haeu masin ti tel seilon kuluiai kakaian kakawen, i ukek, ");
INSERT INTO ssg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Tel hehin tenen i tai eng akakati tel na wawan i pet akaik ape i hatakaha tel akaik wawan, laha axai axan Imanuel. Tenen kakain Imanuel i ukek, ‘Haeu kapi kaha.’” ");
INSERT INTO ssg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Muhin ti Josep haiwa, i waxi Mary hanowi ti tel engel ti Haeu kaakane i. ");
INSERT INTO ssg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tuahe Josep tai eng akati i hani tataen tel akaik takah. Ape Josep axai axan Jises. ");
INSERT INTO ssg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jises takah leili taon Betlehem ti Judia, lokon ti Herod masiwi. Lokon ien, tesol seilon ti sai angiha tahia hani Jerusalem. Lato aneso mumuh ti kohot. ");
INSERT INTO ssg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ape lato kamea, “Ia tetel akaik i takahale masiwi tapein ti teka Ju? Amite ningahi tehu kohot ti sai angiha i kola takahan ape amite nahima lotuian.” ");
INSERT INTO ssg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ti tel masiwi Herod hongoa, namilon sihikuk hawane hetekie teka seilon ti Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","I tiloi teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses ape i kamei lato, “Tel Krais i takah tetesol ia?” ");
INSERT INTO ssg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Lato ukek, “Leili taon Betlehem ti Judia masin ti tel kuluiai kakai Haeu taiwen ukek, ");
INSERT INTO ssg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Betlehem, taon ti Judia, o kumahe tehu taon tap axan ti Judia nake o tetesol tel masiwi i po sohot ti ngahatiai teka seilon tetak ti Israel.’” ");
INSERT INTO ssg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ape Herod tiloi tesol soliwa ti angiha. I kamei hakokol lato lokon wanen ti tehu kohot sohot. ");
INSERT INTO ssg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ape i talo lato hani Betlehem i ukek, “Amuto nahiwa ape puas nihehi upia aluini hawanewa tel akaik. Na amuto tunahi, hahongo aliakema nga lehe tin nga nahih lotui i.” ");
INSERT INTO ssg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Muhi kakai Herod ape lato nahih. Ti lato luluainiwa, tehu kohot i sohot alia ape i to neneiniwa aweisalulato hani tataen tesol tel akaik takah. ");
INSERT INTO ssg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ti lato ningahiwa tehu kohot pate lato amuam hawane. ");
INSERT INTO ssg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ti lato soh haniwa leili ing, lato ningahi tel akaik ma tel tinan Mary. Lato lokuha lotui tel akaik. Lato heiwa kakulato ape axi i waliko tuah: gol, sanda ma mer, paura tenen poun pate solian. ");
INSERT INTO ssg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ti leili paxangoalato Haeu hahongo lato ukek, “Kum alia hahani kapi Herod.” Ape lato non aweisal liai alia hani xuxulato. ");
INSERT INTO ssg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Muhin ti tesol soliwa aliawa, Josep i paxangong. Leili paxangoan tel engel ti Haeu hone i ukek, “Xahatawa! Waxiwa tel akaik ma tel tinan ape ox haniwa Igip nake Herod i upiup tel akaik lehe i telei. Amuto toa ien atengi tataen na nga hahongo aliakewa amuto.” ");
INSERT INTO ssg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep xahat waxi tel akaik ma tel tinan ti ipong tutuen ape lato ox hani Igip. ");
INSERT INTO ssg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Lato to ien atengi tataen Herod mat. Waliko ien i sohot hapoponowi hawane waliko ti Haeu kaxiwen leili pepai tel kuluiai kakaian i ukek, “Nga tiloi ahuti tel Natuk ti Igip.” ");
INSERT INTO ssg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ti Herod tioiwa ka tesol soliwa ti angiha pisiwen i, lon lialu hawane. I hani kakain ahian ti teleiai hatesol akaik wawan ti Betlehem ma xux ti xohixohin, akaik ti ahangun huohu hanima itan. I usima menge tesol soliwa ti angiha ka lato ningahi tehu kohot ahang huohu tamusuen. ");
INSERT INTO ssg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","I sohot hapoponowi hawane waliko ti tel kuluiai kakai Haeu, Jeremaia ukek, ");
INSERT INTO ssg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tangitangi lalap ma kinax ti tatahan i sohot ti tehu taon Rama. Rakel i tangixi tesol natun. I watakai laha hasoli i nake tesol natun mat hatapoen.” ");
INSERT INTO ssg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Muhi matei Herod, tel engel ti Haeu sohot hani Josep ti leili paxangoan lokon ti i Igip. ");
INSERT INTO ssg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","I ukek, “Xahatawa, waxiwa tel akaik ma tel tinan ape alia haniwa xux ti Israel pake teka lehe laha telei tel akaik ape laha matewen.” ");
INSERT INTO ssg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josep xahat waxi tel akaik ma tel tinan ape lato alia hani Israel. ");
INSERT INTO ssg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tuahe ti Josep hongoa Akilaus kewen totone tel taman Herod masiwi ti Judia, i mamata na i sosoa. Haeu hone ulea i leili paxangoan ka sos haniwa Galili texux xux leili Israel. ");
INSERT INTO ssg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ape Josep aile tonalato tewau toan Nasaret. I haponowia hawane kakai tesol kuluiai kakai Haeu, lato ukek, “Laha axai i Nasarin.” ");
INSERT INTO ssg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hina ahang tamusua Jon Baptis i hutui ahutiai kakai Haeu ti i nahih hahaniwa he lohong ti Judia. ");
INSERT INTO ssg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","I ukek, “Towiahua ti saun lialun ti amuto nake nenein ti Haeu i xohiwen!” ");
INSERT INTO ssg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon se tetel seilon Aisaia kakak imat, i ukek, “Tel seilon i titilol he lohong, ‘Towiahua ti lialui woumuto lehe tel Masiwi neini amuto taen i tahiama!’” ");
INSERT INTO ssg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon, soson ma puxuaun uli kamel, teik tahan tin tuahe uli manihuh a anan kukunalel ma xuni awe nini. ");
INSERT INTO ssg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Seilon ti laha nahih hani kapin, teka ti Jerusalem, ti hatehu Judia ma kakalini toan ti xohixohin kan Jodan. ");
INSERT INTO ssg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Laha kaxi ahuti lialui woulaha ape i baptaisi laha leili tehu kan Jodan. ");
INSERT INTO ssg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tataen ti Jon ningahiwa kilai teka Parisi ma teka Sadusi nahih hahanima kapin ti ukei baptais, i kakane lato ukek, “Amuto seilon tenen lehomuto huoka! Aita hone amuto ka amuto salia uke ti kaui kawatan ti Haeu hani amuto? ");
INSERT INTO ssg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ailewa saun tenen ti i kola ka amuto lioiwen saun lialun. ");
INSERT INTO ssg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kum ukekek amuto salia uke ti kaui kawatan nake amuto nakuama ti Abraham. Nga kakane amuto, Haeu pon kolitiniai tesol pot ie hani kahi nati Abraham! ");
INSERT INTO ssg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Haeu apeseniwen tea ngolapung. Pata tenen i kum hua alua, i koti hamahusu ape i towi lui hani leili ah. ");
INSERT INTO ssg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nga baptaisi teka seilon ani kan ti kolaian ka laha lioiwen saun lialun tuahe Jises Krais, tel i sohotuma muhik, i hani laha Holi Spirit ti kapitialaha. Jises pamu masiwian tetak, masiwiaian ala i kum pon nga unauan. ");
INSERT INTO ssg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","I hiniti seilon masin tel na i hapuasa nuhinuh ti i selai api ti penun. I apuhini api wanen ape i lui xoini penun. Tin masin Jises i towi xoini teka seilon lialun hani leili tehot ah tap tahi pehoan.” ");
INSERT INTO ssg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lokon ien Jises nahih ti Galili hani kapi Jon ti ukei baptais he kan Jodan. ");
INSERT INTO ssg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tuahe Jon towiahu lali namilon. I ukek, “Lehe nga baptaisi o? Ala o baptaisi nga.” ");
INSERT INTO ssg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jises hone i, “Tilimuen masin ie. Kalu tua aile usi waliko ti namili Haeu.” Ape Jon sowini. ");
INSERT INTO ssg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Muhin ti Jises baptais kewa, i xaheale. Maun i hea ape i ningahi Spirit ti Haeu mos hani kapin hanowi tok pux. ");
INSERT INTO ssg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tataen ien teik kakain ahuma ti tone Haeu, “Ie se tel Natuk wanen nga waheni, nga amuke hawane i.” ");
INSERT INTO ssg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Muhin Holi Spirit kapiti Jises hani he lohong lehe Satan tohongi haputaian. ");
INSERT INTO ssg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jises tai angiang leili 40 ngain ma ipong ape pate i hitol. ");
INSERT INTO ssg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Satan nahih hani kapin ape i ukek, “Na o tel Nati Haeu, kolitiniwa tesol pot ie haniwa bret.” ");
INSERT INTO ssg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jises pahoi i, “Leili pepai Haeu i kak ukek, “‘Seilon ala i hana hatapo namilon hani kakai Haeu kumahe an.’” ");
INSERT INTO ssg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Muhin Satan hakahita Jises hani Jerusalem ape hatuhi i he teik tumi Ingi Haeu patul wanen. ");
INSERT INTO ssg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ape Satan kakane i, “Na masin salan o tel Nati Haeu, tautit haniwa itan. Ti leili pepai Haeu i kak ukek, “‘Haeu talo tesol engelaun tengeni awaiam he minalato lehe kalak taen aem pot kum hamange.’” ");
INSERT INTO ssg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jises hone i, “Leili pepai Haeu tin i kak ukek, ‘Kum totohongi Haeu tel Masiwi.’” ");
INSERT INTO ssg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satan hakahita ulei Jises hani tehu maunten patul wanen ape kola hani i hatesol xux ma soliai waliko ti tehu pon itan ie. ");
INSERT INTO ssg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Satan hone Jises, “Hatesol waliko ie nga hani tetam na o lokuha lotui nga.” ");
INSERT INTO ssg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jises kak pahoi i, “Nahih xaxaua Satan! Teik pepai Haeu i kak ukek, “‘Lotuiwa mewenae Haeu tel Masiwi ma ailewa mewenae puasan.’” ");
INSERT INTO ssg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ape Satan nahih salili Jises. Teka engel ti Haeu tahia hani kapi Jises ape lato ngahati i. ");
INSERT INTO ssg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ti Jises hongoa ka Jon kalabusawen, i nahih alia hani texux xux Galili. ");
INSERT INTO ssg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","I salili Nasaret ape aile tonan Kapenaum, tehu taon xohixohin ti kanitax Galili ma xuxi teka Sebulun ma Naptali. ");
INSERT INTO ssg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Waliko ie sohot haponowiai kakai Aisaia, masin ti i kakawen, ");
INSERT INTO ssg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Teka seilon ti xux ti Sebulun ma Naptali, xux ti pahoiwa kanitax Galili, pape kan Jodan, tewaok ti Galili ti teka kumahe Ju totonai, laha toto he tilokoan ti saun lialun tuahe laha po tunahi lalape xewai Haeu. Laha toto he tilokoan ti matemate tuahe xewai Haeu po haxewa laha.” ");
INSERT INTO ssg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lokon ien Jises hutui pupuasan ti sawateniai kakai Haeu i ukek, “Amuto towiahua ti lialui woumuto nake xohiwen ti Haeu neini hatesol seilon.” ");
INSERT INTO ssg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ti Jises tau nanahih pape kanitax Galili, i ningahi hua seilon ti tikei xixi, Saimon Pita ma tel ukalan Andru. Lalu totowi upen puliai xixi. ");
INSERT INTO ssg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jises hone lalu, “Kahitima nga lehe nga hanau amulu tike waxainiai seilon hani kahikahik.” ");
INSERT INTO ssg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kakanua lalu hana lioi upen ape kahiti i. ");
INSERT INTO ssg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jises nahih ahewa ape i ningahi hahutalin liai, Jeims ma Jon, nati Sebedi. Lalu he tea koap kapi tel tamalalu apepeseni upenaulato. Ape Jises tiloi lalu. ");
INSERT INTO ssg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ape salan, lalu nahih salili tea koap ma tel tamalalu ape kahiti i. ");
INSERT INTO ssg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jises nahih hani tesol tesol ti Galili hahanau teka seilon leili synagog, ing ti apuhai teka Ju. I kakaxi meng solian ti Haeu neini seilon ape i aile hasolia teka hina nax tenen tenen. ");
INSERT INTO ssg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Menge waliko ti i ailele i sawat kakalini hatexux xux ti Siria. Ape teka seilon atoheni hani i hatesol teka tinun, teka hina moloan lalap, seilon teka spirit lialun kapiti hahalialu, teka lawe laha put xexex ma teka laha kum nahih uke. Jises aile haewia laha. ");
INSERT INTO ssg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kilan wanen seilon kakahiti i, teka ti Galili, seilon ti huopanim taon axan Dekapolis, Jerusalem, Judia ma teka ti liai tepaun ti tehu kan Jodan. ");
INSERT INTO ssg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jises ningahiwa mongohe teka seilon ape i nahih hani he maunten. Teka kahikahin nahih to apuha hani kapin. ");
INSERT INTO ssg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ape i hutui hanau lato saun ti soliai Haeu, i ukek, ");
INSERT INTO ssg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Haeu aile hasolia hani teka pahalaha wanen i neini ma ngahati laha. ");
INSERT INTO ssg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Haeu aile hasolia hani teka laha toto ti tatahan. I hasoli laha. ");
INSERT INTO ssg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Haeu aile hasolia hani teka laha tap namil ti halepelep. I aile laha tame tehu pon ie. ");
INSERT INTO ssg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Haeu aile hasolia hani teka pahalaha wanen usiai nauna tetan. Laha pono ti waliko tenen solian. ");
INSERT INTO ssg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Haeu aile hasolia hani teka laha hina tatahan ti seilon liai. I tin hina tatahan ti laha. ");
INSERT INTO ssg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Haeu aile hasolia hani teka laha hani hatapo namilolaha ailei pupuasan. Imuh laha ningahi i. ");
INSERT INTO ssg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Haeu aile hasolia hani teka laha pupuas ti hasoliai wasole seilon. I axai laha natun wanen. ");
INSERT INTO ssg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Haeu aile hasolia hani teka seilon teteka liai aile halialu nake laha ailele pupuasan. Laha seilon tetan wanen. ");
INSERT INTO ssg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Haeu aile hasolia hani amuto na seilon kak saxuti axamuto, sului putini amuto ma aile waliko lialun hani amuto nake huak. ");
INSERT INTO ssg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Amuamua nake kahumuto solian Haeu apeseniwen patul leili tonan. Nameniwa ka teka kuluiai kakai Haeu ti matahaun tin lato kauen kawatan ti teka seilon aile halialu lato. ");
INSERT INTO ssg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Amuto tuah ti hani lawe seilon masin sol ti hanamui an. Tuahe na taxiai sol i tapo, kaha kum hataxia aliake uke. I ape tap solian tetan. Seilon towi xoini ape laha tua nahih tutuhi. ");
INSERT INTO ssg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Amuto tuah masin xewan ti kolai aweisali Haeu ti tehu pon itan ie. Amuto masin tehu taon laha atai patul he tehu maunten lehe lawe seilon ningahi. ");
INSERT INTO ssg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tap tel i hakama tehu kamaian ape hana hani hahitake salek. Laha hakama ape hakea hani patul koukean lehe i haxewa seilon ti leili ing. ");
INSERT INTO ssg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tin masin amuto haxewa haniwa seilon liai lehe laha ningahi saun solian ti amuto ape laha sameni Haeu tel Tamamuto. ");
INSERT INTO ssg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Amuto kum ukekek ka nga tahiama xaxaweniai nauna ti Moses ma kakain ti teka kuluiai kakai Haeu kakaxi. Nga tahiama haponowiaian lehe seilon xeu kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nga kakane hawane amuto, ti maun aheah ma pon itan ie tutuen, tap teik kakain ti Haeu haniwen Moses i sohia atengi lawe waliko sohot poponowi hanowi ti Haeu kakawen. ");
INSERT INTO ssg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tel na i tahi tuahe teik nauna ti Haeu ape i hanau seilon liai tahian, Haeu namiloi ukek i tel pate naun. A tel na i puas usi ma hanau seilon liai puas usiai nauna ien, Haeu namiloi ukek i tel pate tuah. ");
INSERT INTO ssg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nga kakane hawane amuto, Haeu hani amuto tonain tuah kapin mewenae na usiai Haeu ti amuto i xoini teka Parisi ma teka hanaui nauna ti Moses. ");
INSERT INTO ssg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Amuto hongoen nauna ti Moses hani teka seilon ti kuewen i ukek, ‘Tel na i ulini ape i telei seilon i tu ti sulusulu.’ ");
INSERT INTO ssg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tuahe nga kakane hawane amuto, tel na i tua lengeini lalolal seilon, i tu ti sulusulu ti puli Haeu. Ape tel na i kak halialu seilon liai i ukek, ‘O tap pupuasam,’ laha sului i hani teka masiwi. Ape tel na i kak halialu seilon liai i ukek, ‘O taxitaxia,’ i kane tehot ah lalap tap tahi pehoan. ");
INSERT INTO ssg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Na masin ti leili Ingi Haeu lehe o hani i teik na waliko ape o nameni tunahi ka wasolamulu tel seilon o halialuen, hana lioimua teik akekenam he aweing, ape nahih hasawimua wasolamulu tel seilon ien. Na o hasawi kewa, ien, ape o haniwa Haeu teik akekenam. ");
INSERT INTO ssg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Na tel i namiloi suluiai tel ti amuto, hasawi koseniwa wasolamulu uke i hatuhi o hani puli tel masiwi ti hongoi meng. Ape i hana o hani mini teka masiwi ti kalabusiam. ");
INSERT INTO ssg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na i sohot ukek ien, o kum ahuta atengi o hasawi hatapoa moni. Tin masin amuto hasawiwa wasolamuto ma Haeu uke amuto kau kawatan ti lialui woumuto. ");
INSERT INTO ssg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Amuto hongoen, ‘Kum ailele saun lialun ti wawan hehin.’ ");
INSERT INTO ssg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tuahe nga kakane amuto, tel na i paxai nahaini tel na hehin ape namilon i eliel pahan i eng akati, tel seilon ien i ailewen saun lialun ti wawan hehin leili namilon. ");
INSERT INTO ssg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na o hapuasa tepaun pulam manau ti ailei saun lialun, xaxusi xaxaweniwa! Pamu ewian na o lioi teik ti tupuam uke laha towi xoini o hani tesol ti kawatan tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na o hapuasa tepaun minam manau ti ailei saun lialun, koti xaxaweniwa! Pamu ewian na o lioi tepaun minam uke laha towi tupuam hatel hani tesol tonain ti kaui kawatan lian tehue. ");
INSERT INTO ssg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tin Moses kakawen, ‘Tel na pahan i lioi tel axoan hehin, i tai hahongoa tel hehin sale lilioaialalu.’ ");
INSERT INTO ssg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tuahe nga kakane amuto, tel seilon i tapai lioiai tel axoan hehin mewenae na tel hehin eng akati tel seilon liai. Na i lioi tel axoan ti hui waliko liai, i aile haputa tel axoan ti ailei saun lialun ti wawan hehin. Tin i aile haputa hetekie tel wawan ti i uke tetel hehin mahe axoan. ");
INSERT INTO ssg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tin amuto hongoen, ‘Kum xaxaputi kakain ti na o tuoha haniwen Haeu.’ ");
INSERT INTO ssg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tuahe ape nga hone amuto, kum tutuoha ukek kuinakei tone Haeu nake se tone tel Masiwi Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kum tutuoha ukek kuinakei tehu pon itan ie nake i ti Haeu. Kum tutuoha ukek kuinakei Jerusalem nake se taon ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kum tutuoha ukek kuinakei patum nake o kum pon aile hapolui ma hapaxaxui tok na uk. ");
INSERT INTO ssg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Na o tuoha, tua kakawa ‘se’ ma na ‘kumahe.’ Na o kak hakila kuinake ti tutuoh tetam, i ahuma ti Satan. ");
INSERT INTO ssg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Imat amuto hongoen, ‘Na tel seilon i xaxusi tepaun pulam, o xaxusi aliakewa tepaun pulan. Na tel taputui hataxuxu nisum, o taputui hataxuxu aliakewa nisun.’ ");
INSERT INTO ssg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tuahe nga hone amuto, kum kahui aliliake waliko lialun ti seilon liai aile hani amuto. Na tel seilon aile hani amuto saun tenen pate hahien, kum aile kahui aliliake. Tiliwen i aile tuhi ulea. ");
INSERT INTO ssg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na tel lehe i sului amuto ape waxi lungei tehu puxuaumuto, hani palahiwa i tehu liai. ");
INSERT INTO ssg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na tel i hone lungei amuto kaua teik kokol tehu kakun, amuto kau haxau ahekewa teik. ");
INSERT INTO ssg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na tel katei amuto teik na soxi, haniwa i. Na tel seilon pahan i hapuasa teik na soxiamuto, haniwa i hapuasa. ");
INSERT INTO ssg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Imat amuto hongoen, ‘Waheniwa teka lohumuto ma tumuiwa teka na lialun ti amuto.’ ");
INSERT INTO ssg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tuahe nga hone amuto, waheniwa teka laha pahoxai amuto. Lotu hualiwa teka laha halialu amuto. ");
INSERT INTO ssg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Na amuto aile ukek ien, amuto sohot hawane nati tel Tamamuto Haeu. Waheniwa hatesol seilon tekewe nake Haeu hani alon haxewai ati seilon solian ma lialun. Ape i hauxa akah hani seilon teka sawisawin ma teka weli ailei saun lialun. ");
INSERT INTO ssg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Haeu kum kahui hasolia amuto na masin amuto waheni mewenae teka laha waheni amuto. Kalak taen teka seilon waxiai moni hani teka masiwi ti Rom, lato waheni mewenae teka laha waheni lato. ");
INSERT INTO ssg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na amuto kakak mewenae kapi teka lawamuto, kalahai lehe Haeu kahui hasolia amuto? Kalak taen laha kum tioi Haeu laha ailele saun tenen ien. ");
INSERT INTO ssg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Amuto kewa seilon sawisawin wanen hanowi ti tel Tamamuto Haeu i sawisawin wanen. ");
INSERT INTO ssg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Na amuto aile puasain solian, lepeteniwa, kum ailele ti lehe laha sameni amuto. Na amuto aile kola lehe lawe seilon sameni, amuto kum uke kahumuto ti tel Tamamuto Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Na masin amuto huali tel seilon, amuto kum aile kokola hanowi teka seilon leholaha huoka, laha ailele leili synagog ma he puli lawe seilon. Laha aile lehe teka seilon haxawa axalaha. Nga hone amuto, laha uke hatapoen kahulaha. ");
INSERT INTO ssg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Na masin amuto huali tel seilon, amuto kum kakaxi hani tel na seilon kalak i lohumuto solian. ");
INSERT INTO ssg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na masin amuto huali tel seilon a teka liai kum tioi, tel Tamamuto Haeu lawe i ningahi ape i kahui amuto. ");
INSERT INTO ssg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Na amuto lotu, amuto kum aile hahanowi teka seilon leholaha huoka. Pahalaha lawe laha lotu ti leili synagog ma ti he puli lawe seilon lehe lawe seilon niningahi laha. Nga hone amuto, laha uke hatapoen kahulaha. ");
INSERT INTO ssg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Na masin amuto lotu, soh haniwa leili ing, keitiwa aweing ape lotu haniwa tel Tamamuto Haeu. Kalak amuto kum niningahi i, tel Tamamuto lawe i ningahi waliko likihan ti amuto ailele ape i kahui amuto. ");
INSERT INTO ssg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Na amuto lotu, kum aile hahakila kakain tenen i tua lalolal, hanowi ti teka seilon laha kum tioi Haeu. Laha sokok Haeu hong laha nake lotu ti laha pate weluwelun. ");
INSERT INTO ssg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Amuto kum hahanowi ti laha. Tel Tamamuto hoi liai i tioiwen waliko tenen amuto tae, imat ti amuto kamea. ");
INSERT INTO ssg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Na amuto lotu, amuto kak kewak: “‘Tel Tamamite Haeu, amite sameni o nake o pate tuah wanen. ");
INSERT INTO ssg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pahamite o neiniwa ma ngahatiwa amite. Hualima amite usiam hanowi tetesol lato kapim leili tonam. ");
INSERT INTO ssg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Axima amite an tapai ti ngain tehu tehu. ");
INSERT INTO ssg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Oxoxiwa amite ti kawatan ti lialui woumite, masin ti amite oxoxi seilon liai ti kawatan ti waliko lialun laha aile hani amite. ");
INSERT INTO ssg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","O kum hahani amite totohong ailan lehe amite kum aile saun lialun. Ape awaiwa amite ti Satan ma teka spirit lialun tetan.’ ");
INSERT INTO ssg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Na masin amuto oxoxi seilon liai ti kawatan ti waliko lialun laha aile hani amuto, tel Tamamuto Haeu tin i oxoxi amuto ti kawatan ti lialui woumuto. ");
INSERT INTO ssg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tuahe na amuto kum oxoxi seilon liai ti kawatan ti waliko lialun laha aile hani amuto, tel Tamamuto tin i kum oxoxi amuto ti kawatan ti waliko lialun amuto ailewen. ");
INSERT INTO ssg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ti amuto halini an hualiai lotu ti amuto hani Haeu, kum aile kokola he kawamuto, hanowi ti teka seilon leholaha huoka lawe to ailele. Laha aile kola lehe hatesol seilon tioi ka laha hahalini an. Nga hone amuto, laha uke hatapoen kahulaha. ");
INSERT INTO ssg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tuahe na amuto halini an, nuhiwa kawamuto ma hexiwa ukumuto. ");
INSERT INTO ssg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Amuto aile kewak ien lehe laha kum tioi ka amuto hahalini an. Pake tel Tamamuto Haeu, amuto kum niningahi, i tioi. Lawe i ningahi waliko likihan ti amuto ailele ape i kahui amuto. ");
INSERT INTO ssg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Amuto kum apuhini hahakila waliko solian tenen tenen ti itan ie. I aneso lialu ma teka seilon ti xuxuina waxi. ");
INSERT INTO ssg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hani hatapoa kuimuto ma namilomuto haniwa Haeu. Ie masin ka amuto apepeseni kahumuto ti tonan. Tesol ien tap tahi lialuan ma tap teka xuxuina. ");
INSERT INTO ssg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Namilomuto toi waliko tuah ti amuto. Aile ape kewa Haeu kapitiai namilomuto. ");
INSERT INTO ssg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Namilomuto masin tehu kamaiamuto. Aile ape na namilomuto solian, amuto xuhai xewan ti saun solian. ");
INSERT INTO ssg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tuahe na namilomuto lialun, amuto xuhai tilokoan ti saun lialun. Ien masin ka kamaiamuto i peh ape amuto leili lalape tilokoan. ");
INSERT INTO ssg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Amuto kum puas uke hahitake masiwi hua, uke amuto waheni tel ape amuto watakai tel, amuto hong kakai tel ape kum hong tel. Amuto kum aile uke puase Haeu na masin namilomuto tin xoxoan ti ngahoi moni. ");
INSERT INTO ssg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nga hone amuto, kum namiloi hahakila an, unumamuto ma sosomuto. Sale totonamuto seilon pamu tuah ti an a tupuamuto pamu tuah ti maia. ");
INSERT INTO ssg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Paxaiwa manixux, laha kum seseini ma apupuhini an a tel Tamamuto Haeu ngangahati laha! Nga kakane hawane amuto ka Haeu namiloi ukek amuto pamu tuah ti manixux. ");
INSERT INTO ssg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kaie amuto pon hawelu ahekei tuahe na teik totonamuto ti amuto to nanamiloi? ");
INSERT INTO ssg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ape kalahai amuto to nanamiloi maia? Paxaiwa sale xexei palawa. Laha malang puas sawitiai maia sosolaha! ");
INSERT INTO ssg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tuahe nga hone amuto, kalak taen tel masiwi Solomon, soson, maia ma hatesol soliai waliko tetan, i kum pon soliai palawa. ");
INSERT INTO ssg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Haeu tel i ngangahati pahoah, i ie tetelao ape letu laha lui xoini. Kaie kumahe pamu i ngahati aluluini amuto? Amuto tap namil xoxoan ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ape amuto kum namiloi ukekek, ‘Kaie anak, unumak ma sosok nga kema ia?’ ");
INSERT INTO ssg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tesol waliko ien, teka laha kum tioi Haeu to namiloi hahakila. Tel Tamamuto Haeu tioi waliko ti amuto tap. ");
INSERT INTO ssg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Haniwa i neini amuto ape ailewa waliko tenen i hamuamua i. Ape i hani amuto hatesol waliko ien. ");
INSERT INTO ssg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kum namiloi hahakila waliko ti na i sohot letu. Waliko ti letu, tiliwen ti letu. Amuto kum huhukumini kawatan ti ngain tehu tehu. ");
INSERT INTO ssg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kum kak hahalialu woi seilon liai lehe Haeu kum lengeini amuto. ");
INSERT INTO ssg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Haeu nam kolongeni woumuto hanowi na amuto nam kolongeni woi teka liai. Ape i aile hani amuto waliko tenen na amuto aile hani teka liai. ");
INSERT INTO ssg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Kum hahanowi teka laha kak halialu woi seilon liai a laha kum paxai tioi puki lialui woulaha. Laha masin teka seilon laha ningahi teik masiap kokol he puli tel seilon liai a laha kum paxai tioi teik masiap lalap he puki pulalaha. ");
INSERT INTO ssg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Lehe amuto hone ukek ia tel seilon liai, ‘Hanima nga xaxaweni teik masiap kokol he pulam’ na masin puki amuto teik masiap lalap he pulamuto? ");
INSERT INTO ssg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Seilon tenen lehomuto huoka! Amuto xaxawenimua teik masiap lalap he pulamuto ape muhin ien amuto paxapax alua ti xaxaweniai teik masiap kokol he puli tel seilon liai. ");
INSERT INTO ssg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kum kaxi hahanau kakai Haeu hani teka laha watakai hawane i. Laha aile hanowi ti sinen ma pou. Na amuto towi hani lato waliko tenen tuah, lato tuhi pexi halialu ape lato towiahu atalahi amuto. Tin masin teka laha watakai hawane Haeu, laha hil pahoi aliake amuto ape laha kak halialu kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Amuto kamei talingoiwa ape Haeu hani amuto waliko ti amuto kakamea. Upia talingoiwa ape Haeu huali amuto tunahian. Kikini talingoiwa kahip ape Haeu hei hani amuto. ");
INSERT INTO ssg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Teka na laha kamea, Haeu hani laha. Tel na i upia, Haeu huali i tunahian. Teka na laha kikini talingoi kahip, Haeu hei hani laha. ");
INSERT INTO ssg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Na natumuto kamea an, kaie amuto hani i pot? ");
INSERT INTO ssg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Na natumuto kamea xixi, amuto hani i weiko? ");
INSERT INTO ssg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kalak woumuto lialun, amuto tioi haniai waliko solian hani natumuto. Tuahe Haeu tel Tamamuto i hani amuto pamu kilaian ti na amuto kamei i. ");
INSERT INTO ssg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Aile haniwa seilon liai saun tenen pahamuto laha aile haniwa amuto. Tenen saun ien i salangawe nauna ti Moses ma teka kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nahih usiwa tewau aweisal omiomin kane tesol tonain kapi Haeu ti tap tahi tapoan. Tewau aweisal hani tesol ti kawatan tap tahi tapoan i mamanahan ma pate malimun ape pate kilan seilon nanahih ien. ");
INSERT INTO ssg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ape tewau aweisal kane tesol tonain kapi Haeu ti tap tahi tapoan, i se omiomin a pate ailan ma pate palai seilon tunahian. ");
INSERT INTO ssg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Amuto kanipetiwa teka seilon laha woinakon kuluiai kakai Haeu. Paxaialaha ti melal masin sipsip tuahe ti leilon laha masin sinen tenen tumun pate kalimen. ");
INSERT INTO ssg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Amuto paxai tioi laha ti sale pupuasalaha. Au i kum hahuama huai laku ape sawaul i kum hahuama huai ul. ");
INSERT INTO ssg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pata xexean solian, huan solian a pata xexean lialun, huan lialun. ");
INSERT INTO ssg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pata tenen xexean solian, huan kumahe lialun ape pata xexean lialun, huan kumahe solian. ");
INSERT INTO ssg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tenen pata na i kum hua alua, laha koti hamahusu ape lui xaxaweni. ");
INSERT INTO ssg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aile ape amuto tioi teka seilon woinakon kuluiai kakai Haeu na amuto paxai ani pupuasalaha. ");
INSERT INTO ssg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Teka laha axai nga Masiwi, kumahe hatesol soh hani tesol tone Haeu ti neiniai lawe seilon, mewenae teka na laha puas usi waliko ti tel Tamak Haeu pahan. ");
INSERT INTO ssg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tehu ngain tapeinan ti Haeu hiniti seilon, kilan teka laha kum puas usi kakai Haeu laha hone nga ukek, ‘Tel Masiwi, hahitake axam amite kului kakai Haeu, amite usi xaxaweni spirit lialun ma aile kilan waliko lalap ti i kola pohem.’ ");
INSERT INTO ssg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ape nga kakane laha, ‘Nga kum tioi amuto. Xaxaua tetak amuto seilon lialun!’ ");
INSERT INTO ssg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Na amuto hong kakaiak ape puas usi, amuto masin seilon tenen hina namilon. I atai tehu ingan he hepekeun ailan. ");
INSERT INTO ssg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Akah lalap uxalih, weu lalap hutomile, aupol kuin taheilih tehu ingan tuahe i tai put manan nake i hahatuhi he hepekeun ailan. ");
INSERT INTO ssg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tuahe na amuto hong kakaiak a kum puas usi, amuto masin seilon tenen tap namilon. I atai ingan he hepekeun wakiakin. ");
INSERT INTO ssg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Akah lalap uxalih, weu lalap hutomile, aupol kuin taheilih tehu ingan ape i manan. Malehe ape lialui mananaian!” ");
INSERT INTO ssg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Taen Jises kak hatapoa, teka laha apupuha laha hong ong amuke hawane sale kakaian. ");
INSERT INTO ssg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","I kumahe masin teka hanaui nauna ti Moses, kakaian masin ka i tel pamu masiwian ti lato. ");
INSERT INTO ssg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Muhin ti Jises hanau kewa teka seilon, i mos alialih he maunten ape kilan wanen seilon nahih kahiti i. ");
INSERT INTO ssg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tel seilon hina nax lialun he tinun nahih hani kapin, i lokuha mateiwaun ape i ukek, “Tel Masiwi, na o waheni, xaxaweniwa naxe tinuk lehe nga hau alia.” ");
INSERT INTO ssg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jises tulini aka soti tel seilon. I ukek, “Nga waheni. Ewiwa ma haua!” Ti i kakawa tel seilon ewi huluta. ");
INSERT INTO ssg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ape Jises hone i, “Kum kaxi hahani teka seilon liai. Nahih sawi haniwa kapi tel masiwi ti hukuminiai Haeu ma seilon lehe i paxai kalisi tinum. Kau hetekiewa huok manixux ti haniai Haeu masin ti Moses kakawen. Ien kola haniai teka seilon ka o ewiwen ape pon o hukuma hani kapi laha.” ");
INSERT INTO ssg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ti Jises tahia haniwa Kapenaum, tel masiwi ti hile ti Rom kamei i huhual. ");
INSERT INTO ssg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","I ukek, “Tel masiwi, tel unauak pate tinun engeeng leili ing, tupuan maten ma pate i lamani tinun.” ");
INSERT INTO ssg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jises ukek, “Nga nahima aile haewiaian.” ");
INSERT INTO ssg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tel seilon pahoi ukek, “Oie tel masiwi, kumahe. O pate masiwi kasia ti na o nahih hanima leili ingak. O tua kakawa ape tel unauak i ewi. ");
INSERT INTO ssg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nga tin hina seilon pamu masiwian tetak ma tin hina seilon ti hile hahitakak. Na nga hone tel, ‘Nahiwa,’ i nahih. Na nga hone tel, ‘Nahima,’ i nahima. Ape na nga talo tel unauak, ‘Ailewa tetenen,’ i aile.” ");
INSERT INTO ssg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ti Jises hongoa, pate i ongake ape i hone teka seilon kakahiti i, “Nga kakane amuto, ti leili Israel nga tai tutunah tel seilon i hina namil xoxoan tetak masin tel seilon ti Rom ie. ");
INSERT INTO ssg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nga kakane hawane amuto, ngain telao ti Haeu hiniti hatesol seilon, kilan laha ahuma xux tesol tesol ape to kapi Abraham, Aisak ma Jekop ti tehu angiain lalap Haeu apepeseni leili tonan. ");
INSERT INTO ssg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tuahe teteka seilon ala ti Haeu, teka ien Haeu towi xoini hani he tilokoan. Laha tang lialu ma atalahi hamekimeki nisulaha nake moloan lalap tap tahi tapoan.” ");
INSERT INTO ssg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ape Jises hone tel masiwi ti teka seilon ti hile, “Nahih haniwa ingam. Nake o soh ka nga pon haewia tel unauam, i sohot.” Tataen ien wanen tel unauan ewi huluta. ");
INSERT INTO ssg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jises nahih hani leili ingi Pita ape i paxai tunahi tel hehin ihai Pita tinun engeeng he sau. Lul tunahi i. ");
INSERT INTO ssg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ti Jises aka sotiwa minan, tinun ewi. Ape se i xahat apeseni ani Jises. ");
INSERT INTO ssg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ti ape alohah, teka seilon hakahita hani Jises kilan seilon ti spirit lialun kapiti hahalialu. Kakain tehue Jises xaxaweni hatapo teka spirit lialun ape i haewia hatesol seilon tinun. ");
INSERT INTO ssg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Waliko ien i haponowi hawane waliko ti Aisaia tel kuluiai kakai Haeu kak kilamiwen, “I xaxaweni nax tenen tenen ti kaha.” ");
INSERT INTO ssg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ti Jises ningahiwa kilai teka seilon kapin, i hone tesol kahikahin lang haniai sai liai tepaun ti kanitax Galili. ");
INSERT INTO ssg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tel seilon ti hanaui nauna ti Moses, i nahih hani kapin ape i ukek, “Tel masiwi, tesol tesol na o nahih, nga kahiti o. Nga lawe kahikahim.” ");
INSERT INTO ssg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tuahe Jises pahoi i ukek, “Sinen hina walun, manixux hina ingan a nga, tel Nati Seilon, tap tuahe tesol na tone hanawaiak.” ");
INSERT INTO ssg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tel seilon liai, tel ti kahikahin, hone i ukek, “Tel masiwi, nga aunimu tel tamak atengi tataen i matewa ape nga tihini.” ");
INSERT INTO ssg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tuahe Jises pahoi i ukek, “O kahitima nga. Teka seilon kumahe ti Haeu laha masin seilon maten. Tiliwen teka ien tihiniai teka maten.” ");
INSERT INTO ssg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jises ku haniwa he tea koap ape tesol kahikahin kuoxi i. ");
INSERT INTO ssg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tai kue, ahon lalap tunahi lato. Laman i hutomi tea koap. A Jises i mamatih. ");
INSERT INTO ssg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tesol kahikahin hangoni i. Lato ukek, “Tel Masiwi, hualiwa kako uke kako taxix mat!” ");
INSERT INTO ssg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jises ukek, “Alahan ka pate amuto mamata? Nakon amuto tap namil xoxoan ti Haeu?” I xahatawa ape i kakane aupol ma laman, “Mongawa!” Ape i tuxi. ");
INSERT INTO ssg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tesol kahikahin pate lato tataxini, “Seilon lahan tetenen? Taen aupol ma kanitax hong usi kakaian!” ");
INSERT INTO ssg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jises kolia hani pape kanitax Galili sai liai tepaun, hepekeun ti Gadara. Hua seilon lalu sohotuma he amal ti ien nahih pahoima i. Spirit lialun kapiti halialu lalu ape lalu se lengean wanen. Aile ape tap tel seilon nanahih tewau aweisal ien. ");
INSERT INTO ssg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ti lalu ningahiwa Jises, tesol spirit lialun leilolalu ausini, “Tel Nati Haeu, o paham waliko la ti amite? O nanahima ti aile halialuamite? I tai meiwa ngain ti Haeu kikilami.” ");
INSERT INTO ssg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Xohixohin ien, kilan pou exiex. ");
INSERT INTO ssg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tesol spirit lialun kamei eliel Jises, “Na masin o usi ahuti amite, talo haniwa amite leili tesol pou.” ");
INSERT INTO ssg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Salan, Jises hone lato, “Amuto nahiwa!” Ape lato ahuta soh hani leili tesol pou. Hatesol pou ien kiliwau mosua ti he sahikekean tamus hani itax ape lato waut mat. ");
INSERT INTO ssg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tesol ngahatiai pou, lato mamata kiliwau hani taon ape kaxi sawateni waliko ti i sosohot. Tin lato kaxi hetekie waliko ti i sohot hani huhua seilon spirit lialun kapiti halialu lalu. ");
INSERT INTO ssg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ape kilan wanen seilon ti tehu taon ien, laha nahih upia Jises. Ti laha tunahiwa, laha kamei eliel i ti nahih saliliai hepekeunaulaha. ");
INSERT INTO ssg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jises ku haniwa he tea koap ape i luaini kotiwa kanitax Galili hani tehu taon tonan. ");
INSERT INTO ssg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Teka seilon kau hani i tel seilon tupuan maten engeeng he sau. Ti Jises ningahiwa xoxoi namilolaha, i hone tel tinun, “Tu xoxoa tel natuk! Nga oxoxi o ti kawatan ti lialui woum.” ");
INSERT INTO ssg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ape tesol hanaui nauna ti Moses kakak alia puki lato, “Tel seilon ie kak hanowi ka i Haeu. Mewenae Haeu pon oxoxiai seilon ti kawatan ti lialui woulaha.” ");
INSERT INTO ssg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jises tioi namilolato ape i ukek, “Alahan namilomuto lialun? ");
INSERT INTO ssg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tetenen ia pamu malimuan? Nakon pamu malimun na nga hone tel seilon tupuan maten, ‘Xahatawa ape nahiwa,’ ka ‘Nga oxoxi o ti kawatan ti lialui woum’? Ti ailei hahuonen, mewenae seilon ti hina pohe Haeu i pon ailean. ");
INSERT INTO ssg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nga aile kola lehe amuto tioi ka nga, tel Nati Seilon, he tehu pon ie nga hina poh oxoxiai seilon ti kawatan ti saun lialun ti laha.” Ape i hone tel seilon tupuan maten, “Xahatawa, waxiwa enepam ape nahih haniwa tonam.” ");
INSERT INTO ssg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","I xahat ape i nahih hani ingan. ");
INSERT INTO ssg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ti teka seilon paxaiwa, laha ong mamata hawane ape laha sameni Haeu nake i axi poh tenen masin ien hani seilon. ");
INSERT INTO ssg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jises nahih salili tesol ien. Ti i nanahiwa, i ningahi tel seilon axan Matiu toto tesol tone puasan. Pupuasan waxiai moni ti teka Ju hani teka masiwi ti Rom. Jises hone i, “Kahitima nga. Pahak o kahikahik.” Matiu tule ape kahiti i. ");
INSERT INTO ssg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ti Jises to angiang leili tehu ingi Matiu, kilan teka waxiai moni ma teka weli ailei saun lialun nahima to akati Jises ma tesol kahikahin. ");
INSERT INTO ssg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Teka Parisi paxaiwa ape laha kamei tesol kahikahin, “Kalahai Jises to ang kapi seilon tetenen?” ");
INSERT INTO ssg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jises hong lato kakak ape i ukek, “Dokta kum puasake seilon huliwi, mewenae teka tinun. ");
INSERT INTO ssg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nahiwa ape paxai tioiwa waliko ti Haeu kakaxi leili pepaun ti i ukek, ‘Nga pahak amuto hina tatahan ti seilon liai, kumahe pahak amuto telei axi nga manihuh.’ Kumahe ka nga he tehu pon ie upiai kahikahik seilon tenen laha sokok laha sawisawin. Nga tahiama upiai kahikahik seilon tenen laha tioi woulaha lialun.” ");
INSERT INTO ssg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Imuh tesol kahikahi Jon Baptis nahih hani kapi Jises ape kamei i, “Nakon lahan teka kahikahim kum halini an ti hualiai lotu ti lato hanowi ti amite ma teka Parisi?” ");
INSERT INTO ssg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jises kak pahoi lato, “Taen tel seilon i sal i kapi tesol seilon ti laha ilowima ti salasala, kaie lato to ti tatahan ape kum ang? Kumahe! Lato ang amuam kapin. Tuahe ngain tehu i luluainima ti laha waxi tel seilon i sal ti lato ape tataen ien lato halini an. ");
INSERT INTO ssg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tap tel ukeke teik maia haun paxatawaiai teik maia wasan. Na i aile ukek ien, teteik haun i lexi teik wasan ape wawan i lap ahe. ");
INSERT INTO ssg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Seilon kum lohi hahakila patula wel hani tehu po wasan nake na i lauti, tehu po i watat ape patula tapulol. Pamu ewian na i lohi hani he tehu po haun lehe ati lalu kum lialu.” ");
INSERT INTO ssg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ti Jises kaakane lato, tel ti tesol masiwi ti teka Ju nahih hani kapin. I lokuha mateiwaun ape i ukek, “Tel natuk hehin i mamatewa aope. Pahak o nahih hanawa minam patul tetan lehe i moih alia.” ");
INSERT INTO ssg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jises tu nahih kahiti i ape tesol kahikahin tin nahih usiwa i. ");
INSERT INTO ssg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Lokon ien tel hehin hina nax ti sale tapunaun leili ahang huopanim huohu, i nahih usi Jises ape soti ngixi tehu puxuaun. ");
INSERT INTO ssg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ti namilon wanen i ukek, “Kalak nga tua soti tehu puxuaun, naxe tinuk i tapo.” ");
INSERT INTO ssg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jises tohea paxai i ape ukek, “Amuamua tel natuk. Xoxoi namilom tetak i aile hasolia o.” Ape salan, i ewi huluta. ");
INSERT INTO ssg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ti Jises nahih haniwa leili tehu ingi tel masiwi, i ningahi ka teka seilon laha tangitang ma wiliwilia. ");
INSERT INTO ssg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ape i ukek, “Amuto hatesol nahiwa! Tel akaik ie i tai mat, i tua mamatih.” Tuahe laha hatesol mal soxeni i. ");
INSERT INTO ssg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ti laha sohot hatapoa, Jises nahih hani kapi enepe tel akaik. I akeni minan ape tel akaik xahat. ");
INSERT INTO ssg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Menge waliko ti i ailele i sawat kakalini hatesol xux ti ien. ");
INSERT INTO ssg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jises nahih salili tesol ien. Ti i nanahiwa hua seilon pulaxa nahih usiusi i. Lalu tilol ukek, “Tahanema amili, tel kahi nati David!” ");
INSERT INTO ssg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ti Jises soh haniwa leili ing, huhua seilon pulaxa nahih hani kapin. Ape i kamei lalu, “Amulu soh ka nga pon haewiamulu?” Lalu ukek, “A se, tel masiwi.” ");
INSERT INTO ssg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jises soti pulalalu ape i ukek, “I sohot hanowi ti xoxoi namilomulu.” ");
INSERT INTO ssg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ape pulalalu ewi. Jises kakane lalu, “Kum kakaxi wanen hani tel na seilon.” ");
INSERT INTO ssg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tuahe lalu nahih kaxi sawateni hani tesol tesol ti xux ien waliko ti Jises ailewen. ");
INSERT INTO ssg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ti lalu nahih saliliwa Jises, laha hakahita hani kapin tel seilon i kum kak uke nake spirit lialun kapiti halialu i. ");
INSERT INTO ssg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tuahe tataen Jises xaxaweniwa spirit lialun ape tel seilon kakak. Hatesol seilon laha ongake hawane. Laha kak ausini, “Amite tai papaxai waliko tetenen ti Israel hatexux!” ");
INSERT INTO ssg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tuahe teka Parisi ukek, “Satan axi i poh ti xaxaweniai spirit lialun.” ");
INSERT INTO ssg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jises nahih kakalini taon ma toan tewau tewau. I hanau teka seilon leili synagog. I kaxi meng solian ti Haeu neini seilon ma i aile haewia seilon ti hina nax tenen tenen. ");
INSERT INTO ssg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ti i paxaiwa kilai seilon, i tahane hawane nake laha masin seilon tenen lioan. Laha namiloi hakila waliko tenen tenen ape laha masin sipsip tenen tap ngahatan. ");
INSERT INTO ssg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ape i kakane tesol kahikahin ukek, “Teka seilon ie masin kilai an he kin ti i apeasawen. Tuahe seilon ti apuhiniai an, teteka ti neiniai seilon hani Haeu, laha pate palai. ");
INSERT INTO ssg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kameiwa Haeu tel Tame kin lehe i talo palahi seilon ti apuhiniai an ti i apeasawen.” ");
INSERT INTO ssg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jises tiloi apuhini tesol huopanim hua kahikahin ape i axi lato poh ti xaxaweniai spirit lialun ma haewiai seilon ti hina nax tenen tenen. ");
INSERT INTO ssg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ie axe tetesol huopanim huhua aposel: imat Saimon (axan liai Pita) ma tel ukalan Andru, Jeims ma tel ukalan Jon, lalu nati Sebedi, ");
INSERT INTO ssg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip ma Batolomiu, Tomas, Matiu, kemuk i tel waxiai moni, Jeims tel nati Alapeus, Tadeus, ");
INSERT INTO ssg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon, kemuk i tel ti teka Ju laha hil pahoi teka Rom, ape Judas Iskariot, tetel seilon imuh i hangaini Jises. ");
INSERT INTO ssg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jises talo tesol aposel ape i kakane lato ukek, “Amuto kum nahih hahani kapi teka kumahe Ju ma na tuahe tehu taon ti Samaria. ");
INSERT INTO ssg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amuto nahih haniwa kapi teka seilon ti Israel, laha masin teka sipsip tap ngahatalaha. ");
INSERT INTO ssg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nahiwa ape kaxi sawateniwa ka Haeu tel neiniakako ape i xohiwen. ");
INSERT INTO ssg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Haewiawa teka tinun, hamoiha aliakewa seilon maten, haewiawa teka seilon hina nax lialun he tinulaha ma ahuti xaxaweniwa spirit lialun ti leilolaha. Masin ti amuto tua uke tap kahun, tin amuto tua haniwa, kum kakamea kahi puasamuto. ");
INSERT INTO ssg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Kum kakau moni. ");
INSERT INTO ssg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kum kakau kak, sohiai sosomuto, axahe aemuto ma na teik kuaiamuto. Seilon ti ailei puase Haeu, laha kum tae ti lawe waliko. ");
INSERT INTO ssg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Na amuto tahia haniwa taon ma na toan, pax ngahoa tel na i waxi auni amuto ape amuto toa kapin atengi tataen telao amuto salili i. ");
INSERT INTO ssg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ti amuto soh haniwa tehu ing, amuto kak kewak, ‘Amuam ti Haeu hani amuto.’ ");
INSERT INTO ssg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na seilon ti leili ing waxi auni amuto, amuto axiwa laha amuam ti Haeu. Na laha kum waxi auni amuto, amuam ti Haeu i alia hani kapimuto. ");
INSERT INTO ssg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na seilon watakai amuto ma na kum hong amuto, tapahi xaxaweniwa hepekeun he anele aemuto. Ien se kolakol ti laha kum waxi auni seilon ti Haeu. Ape nahih saliliwa tehu taon ma na tewau toan ien. ");
INSERT INTO ssg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nga hone amuto, tehu ngain ti hinitiai seilon, Haeu kolongeni ka laha pamu lialuan ti teka seilon lialun ti Sodom ma Gomora. ");
INSERT INTO ssg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Hongoa! Nga talo amuto hanowi tanih hani leili teka wako. Aile ape amuto hanowiwa anesoi uxi ma hanowiwa xu ka masop. ");
INSERT INTO ssg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Lepetawa hina seilon laha pohi xioti amuto ape sului amuto hani teka seilon ti hong paxaiai kakain ape laha xai amuto leili synagog. ");
INSERT INTO ssg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nake amuto kahikahik, laha ati lungei amuto hani teka masiwi tenen tenen. Ape amuto kaxi meng solian ti Haeu hani laha ma teka laha kum tioi i. ");
INSERT INTO ssg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ti laha aka kongini amuto, kum hahakila namilomuto waliko tenen ti na amuto kak. ");
INSERT INTO ssg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Spirit ti Haeu hanamiloa amuto waliko tenen na amuto kak. ");
INSERT INTO ssg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Hahutalin, tel i hangaini tel hani laha telei. Tin masin hahutaman, tel taman i hangaini tel natun hani laha telei. Teka akaik laha watakai hawane tamalaha ma tinalaha ape laha hangaini lato hani seilon telei. ");
INSERT INTO ssg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kilan wanen seilon laha watakai hawane amuto nake huak, tuahe na amuto tu xox kahikahik atengi amuto mat, Haeu waxi auni amuto lian tehue. ");
INSERT INTO ssg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Na teka seilon ti tewau toan aile halialu amuto, ox haniwa toan liai. Nga kakane amuto, nga, tel Nati Seilon, nga alia hani kapi tel Tamak Haeu imat ti amuto hatapo puasamuto leili Israel. ");
INSERT INTO ssg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tap tel seilon i xoini tel hanauan, tap tel unaui tel masiwi i xoini tel masiwi tetan. ");
INSERT INTO ssg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Laha kum aile hani tel na seilon pamu soliaian ti laha aile hani tel hanauan. Ape laha kum aile hani tel unaui tel masiwi pamu soliaian ti laha aile hani tel masiwi tetan. Na nga tel tame tehu ing laha axai Satan, pamu laha aile halialu ahekewa teka hahitakak! ");
INSERT INTO ssg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kum maamata tuahe seilon. Waliko ti i atutuha ma na mumuna aope ie, imuh Haeu hatakei. ");
INSERT INTO ssg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Waliko tenen ti nga kaxi mumuneni hani amuto, kaxi ahuti haniwa teka liai. Waliko ti mewenae amuto hongohong, kaxi ahuti haniwa lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kum maamata teka laha tua telei tupuamuto, laha kum pon teleiai namilomuto ma hanawain ti Haeu haniwen amuto. Mamatawa mewenae Haeu nake i pon telei xoiniai tupuamuto ma hatesol waliko leilomuto hani tesol ti kaui kawatan tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Moni kokol i pon kahuiai huok piakus tuahe tap tok i mat halik na Haeu ukek i mat. ");
INSERT INTO ssg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Amuto seilon, Haeu tioi hatapo mongohe uk he patumuto. ");
INSERT INTO ssg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","I namiloi ukek ka amuto pamu tuah ti piakus. Aile ape, kum maamata. ");
INSERT INTO ssg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Na tel i namiloi waxi nga ma kakaiak ape i kaxi ahuti hani seilon ka i kahikahik, nga kaxi hani tel Tamak Haeu ka i tetak. ");
INSERT INTO ssg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tuahe na tel i puluhini ti puli seilon ka i kahikahik, nga hone tel Tamak Haeu ka tel seilon ien i kumahe tetak. ");
INSERT INTO ssg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kum nanamiloi ka nga tahiama hasoliai wasole seilon ti tehu pon ie. Kumahe, kakain nga kema ti Haeu, i axi wasole teka namilolaha xoxoan hani Haeu ma teka laha kum soh kakaian. ");
INSERT INTO ssg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aile ape akaik wawan pahoi taman, akaik hehin pahoi tinan ape hehin pahoi ihan hehin. ");
INSERT INTO ssg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Teka ti akikimuto wanen laha hilei amuto nake huak. ");
INSERT INTO ssg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Na tel seilon pamu i waheni tel taman ma tel tinan i xoini ti i waheni nga, i kum pon kahikahik. Na tel seilon pamu i waheni tel natun i xoini ti i waheni nga, i kum pon kahikahik. ");
INSERT INTO ssg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na tel seilon pahan kum is kaui kawatan masin ti nga kakau, i kum pon hawane kahikahik. ");
INSERT INTO ssg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Na tel seilon pahan kum is kahikahik nake pahan i akeni kongini totonan ti itan ie, i lioi totonan ti kapi Haeu. Tuahe na tel seilon i to kahikahik kalak na masin i lioi totonan ti itan ie, i waxi totonan ti kapi Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Na tel seilon auni amuke amuto tesol kahikahik, tin masin i auni amuke nga. Na tel seilon auni amuke nga, tin masin i amuke Haeu tel i taloma nga. ");
INSERT INTO ssg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Na tel seilon waxi auni tel kuluiai kakai Haeu nake i tel unaui Haeu, i waxi kahun masin ti tel kuluiai kakai Haeu. Na tel seilon waxi auni tel seilon sawisawin nake i unaui Haeu, i waxi kahun masin ti tel seilon ien. ");
INSERT INTO ssg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tioi kewak! Na tel seilon axi kalak tuahe na kaniup hani tel nake i kahikahik, i uke kahun ti Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Muhin ti Jises hanau kewa tesol huopanim hua kahikahin, i nahih salili tesol toan ien ape i nahih hani taon ti xohixohin. I hahanau ma kakaxi meng solian ti Haeu hani teka seilon. ");
INSERT INTO ssg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ti Jon Baptis leili kalabus, i hong waliko ti Krais ailele. I talo tesol kahikahin hani kapin. ");
INSERT INTO ssg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ape lato kamei i ukek, “Nakon o se Krais, tel amite to atetengi Haeu taloma, a amite atetengi tel seilon liai?” ");
INSERT INTO ssg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jises pahoi lato ukek, “Amuto nahih aliawa, honewa Jon waliko ti amuto hongohong ma niningahi. ");
INSERT INTO ssg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Teka pulaxa, laha nahih hanima kapik ape laha paxapax, teka laha kum nanahih ape laha nahih uke, teka hina nax lialun he tinulaha, laha ewi, teka taxingalaha sutu ape laha hong uke kakain. Teka maten laha moih alia ape teka pahalaha wanen Haeu neini ma ngahati laha, laha hongohong meng solian ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ape kaxi haniwa Jon ka teka namilolaha xoxoan tutuen tetak, Haeu aile hasolia hani laha.” ");
INSERT INTO ssg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ti teka kahikahi Jon nahih aliliawa, Jises kakane teka seilon kapin sale Jon, i ukek, “Ti amuto nahiwa hongoi kakai Jon ti he lohong, amuto sokok amuto ningahi aita? Tel seilon namilon lawe i sohisohia? ");
INSERT INTO ssg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Amuto sokok ka amuto ningahi aita? Tel seilon tenen soson pate solian? Kumahe, seilon kum sosoi maia solian he lohong. ");
INSERT INTO ssg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Amuto kaxi hanima nga, amuto sokok amuto ningahi aita? Tel kuluiai kakai Haeu? Se, salan wanen, tuahe nga kakane amuto, Jon kumahe tuahe tel kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon tel seilon Haeu kakaxi leili pepaun. Haeu kakane tel Natun i ukek, “‘Nga talo tel ahutiai kakaiak imat tetam ti apeseniai seilon ti sohotuam.’ ");
INSERT INTO ssg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nga hone amuto, puase Jon ti Haeu kilami i ailean, se pamu tuah ti puase hatesol seilon liai. Tuahe kalak teka ti pate naun leili teka seilon Haeu neneini, anesoalaha sale nenein ti Haeu pamu lapan ti Jon. ");
INSERT INTO ssg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Lokon ti Jon kakaxi kakai Haeu hanima tataen aope ie, kilan seilon pahalaha wanen Haeu neini laha. ");
INSERT INTO ssg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Imat ti Jon, teka kuluiai kakai Haeu ma nauna ti Moses, hatesol kak kilamiwen taun ti nenein ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ala amuto sohoa ka Jon se masin Elaija tel kuluiai kakai Haeu, sohotuan Haeu kilamiwen. ");
INSERT INTO ssg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na amuto hina taxing ti hongoi kakain, amuto hongoa! ");
INSERT INTO ssg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Kaie nga kolongeni teka seilon ti aope ie ukek ia? Laha masin teka akaik laha toto ti tone halokoin. Laha tilol ausisini hani teka liai, ");
INSERT INTO ssg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Amite pakui pak solian ti salasala hani amuto tuahe amuto kum amuam. Amite pakui pak ti tatahan tuahe amuto kum tang.’ ");
INSERT INTO ssg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Masin Jon Baptis ti i sohotuma, i kum ang halapa ma i kum un waen, ape teka seilon ukek, ‘Spirit lialun kapiti halialu i.’ ");
INSERT INTO ssg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ape ti nga tel Nati Seilon sohotuma, nga ang ma un waen hanowi teka seilon liai, ape teka seilon ukek, ‘Paxaiwa tel seilon ien! Puhuan wawan ma weli unum. I tin lohi teka seilon ti waxiai moni hani teka masiwi ti Rom ma lohi teka seilon woulaha lialun.’ Tuahe nga kakane amuto, anesoi Haeu ti amili Jon hahanau seilon, i sohot xeu hawane ka salan, na auha paxai soliai puasamili, tataen ti kilan seilon ape laha aile usi hanauan ti amili.” ");
INSERT INTO ssg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Teka seilon ti tesol taon ti kewi Jises hahapuasa poh ti ailei waliko lalap tenen tenen, laha kum towiahu ti lialui woulaha hani Haeu. Aile ape i kak hakawata hani laha. I ukek, ");
INSERT INTO ssg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Teka seilon ti Korasin ma Betsaida, Haeu axi amuto kawatan. Na nga aile hanila teka Taia ma Saidon waliko tenen lalap nga aile haniwen amuto, teka Taia ma Saidon laha towiahu kueiniwen ti lialui woulaha! ");
INSERT INTO ssg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aile ape, nga kakane amuto, tehu ngain ti hinitiai seilon, Haeu axi kawatan hani amuto i xoini kawatan ti i axi teka Taia ma Saidon. ");
INSERT INTO ssg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ape teka seilon ti Kapenaum, amuto namiloi ukek ka Haeu sameni amuto ape waxi amuto hani kapin. Tuahe Haeu towi xoini amuto hani tesol ti kaui kawatan ti tap tahi tapoan. Kalak amuto ningahiwen waliko tenen lalap nga ailele, amuto kum towiahu ti lialui woumuto hani Haeu. Na nga aile haniwen teka Sodom waliko ti kui pohek nga aile hahani amuto, kaie Haeu tai halialu Sodom! ");
INSERT INTO ssg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aile ape, tehu ngain ti hinitiai seilon, Haeu axi kawatan hani amuto i xoini kawatan ti i axi teka Sodom.” ");
INSERT INTO ssg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ape Jises lotu hani Haeu ukek, “Tel Tamak Haeu, Masiwi ti lawe waliko ti patul ma tehu pon itan ie, nga kak kemulik hani o nake o mumuneni sale pohem ti teka laha sokok laha seilon aneso ape o haxewa hani teka seilon laha hana aliake laha hahitake ngahat tetam masin teka akaik. ");
INSERT INTO ssg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nga kak kemulik hani o tel Tamak nake paham i sohot ukek ien.” ");
INSERT INTO ssg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ape Jises hone teka seilon ukek, “Tel Tamak Haeu hani hatapoen nga pohen ma anesoan. Mewenae tel Tamak Haeu tioi hawane nga tel Natun ma mewenae nga tel Natun tioi hawane tel Tamak Haeu. Ape nga tel Natun nexi haxewa tel Tamak Haeu hani teka seilon ti nga kilami. ");
INSERT INTO ssg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Teteka amuto kakau kawatan ma namilomuto kilan, kewa amuto kahikahik lehe nga hani amuto hanawain solian. ");
INSERT INTO ssg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Amuto puas elieliwa tetak ape hong usiwa kakaiak nake nga teheni hawane nga hani ailei puase Haeu. Na amuto aile ukek ien namilomuto heh. ");
INSERT INTO ssg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pake puasain nga hani amuto se paupaun ape usiai kakaiak se solian.” ");
INSERT INTO ssg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tai kue, telao ngain Sabat, Jises nahih kokotiwa tesol kini kon. Tesol kahikahin hitol ape asahi ani huai kon. ");
INSERT INTO ssg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ti tesol Parisi ningahiwa, lato hone Jises ukek, “Paxaiwa, tesol kahikahim ailele waliko tenen hahalin ti telao ngain Sabat!” ");
INSERT INTO ssg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jises kak pahoi ukek, “Nakon amuto kum tioi waliko ti tel masiwi David ma tesol seilon hahitakan aile lokon ti pate lato hitol? ");
INSERT INTO ssg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","I nahih haniwa leili Ingi Haeu ape i ma teka kapin lato ani bret ti laha haniwen Haeu, kalak hahalin. Mewenae teka masiwi ti hukuminiai Haeu ma seilon pon anian. ");
INSERT INTO ssg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nakon amuto kum tioi nauna ti Moses? Teka masiwi ti hukuminiai Haeu ma seilon laha puas telao ngain Sabat leili Ingi Haeu tuahe Haeu kum namiloi ukek laha talesiwen. ");
INSERT INTO ssg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nga kakane amuto, nga pamu tuah ti Ingi Haeu ti Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kakai Haeu i ukek, ‘Pamu nga waheni amuto aile saun ti tatahan hani seilon i xoini na amuto kau hani nga manihuh.’ Na amuto tioi hawane puole teik kakain ie, ala amuto kum tieni halialu seilon ti laha tai aile saun lialun, hanowi tesol kahikahik. ");
INSERT INTO ssg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pake nga tel Nati Seilon, nga se Masiwi ti Sabat. Nga tel sowini haniai seilon waliko tenen i pon ma na i kum pon laha aile telao ngain Sabat.” ");
INSERT INTO ssg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jises nahih salili tesol ien ape i nahih hani synagog. ");
INSERT INTO ssg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ape ti ien, tel seilon minan maten. Hina seilon pahalaha sakaloi aweisal ti suluiai Jises. Aile ape laha kamei hataehu i, “Ewi na haewia seilon telao Sabat?” ");
INSERT INTO ssg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jises pahoi ukek, “Na tel ti amuto tok tupun manihuh put hani tewau wal tahuloun ti telao ngain Sabat, kaie i kum ahuti? ");
INSERT INTO ssg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Seilon i pamu tuah ti tok na manihuh. Aile ape ewi ti hualiai seilon telao Sabat.” ");
INSERT INTO ssg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jises hone tel seilon tepaun minan maten, “Hokahiwa minam!” Ti i hokahiwa, tepaun minan maten ewi hanowi tepaun liai. ");
INSERT INTO ssg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ti tesol Parisi ningahiwa, lato aile ngah aweisal ti teleiai Jises. ");
INSERT INTO ssg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ti Jises hongoa ka lato hina namil ti teleian, i nahih salili tesol ien. Kilan wanen seilon nahih kakahiti i. ");
INSERT INTO ssg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","I aile haewia hatapo teka tinun ape i hone hatuoha lato kum kaakane tel na seilon waliko ti i ailele. ");
INSERT INTO ssg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Waliko ti Jises ailele i haponowi hawane teik kakai Haeu leili pepai Aisaia. I ukek, ");
INSERT INTO ssg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ie tel Natuk, i unauak, tel nga kilamiwen, nga waheni ma pate nga amuke hawane i. Nga hani i Spirit tetak, ape i kaxi ahuti hani lawe seilon aweisal ti nga neini hasawi laha. ");
INSERT INTO ssg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I kum kak lungelung, i kum tilol ma kak ausini sameniai kakaian mate seilon. ");
INSERT INTO ssg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","I tahane teka seilon tenen masin topiu ti i kekelel. I huali teka seilon namilolaha tetak masin kamai ah tenen lehe i peh. I puas tatale atengi tataen teka seilon waheni nga neini laha. ");
INSERT INTO ssg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ape kilan seilon ti lawe xux hana hatapo laha hani he minan.” ");
INSERT INTO ssg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Teka seilon hakahita hani Jises tel seilon pulaxa ma i kum kak uke nake spirit lialun kapiti halialu i. Jises aile haewia tel seilon ape i pon kak ma paxapax. ");
INSERT INTO ssg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Teka seilon paxai tataxini waliko ti Jises ailele. Laha he kamekam alia laha, “Nakon se i Krais, tel kahi nati tel masiwi David?” ");
INSERT INTO ssg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ti teka Parisi hongoa, laha ukek, “I xaxaweni spirit lialun nake Satan tel masiwi ti spirit lialun axi i poh ti usi xaxawenialaha.” ");
INSERT INTO ssg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jises tioi waliko ti lato nanamiloi ape i hone lato, “Na seilon ti xux texux laha tikela ape hil alia puki laha, texux xux ien i lialu tamus. Na tesol akikin lato hil alia puki lato, tesol akikin ien lato kum tu xox. ");
INSERT INTO ssg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na masin Satan hilei aliake Satan, nenein tetan tapo tamus. ");
INSERT INTO ssg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Amuto ukek nga usi xaxaweni teka spirit lialun nake Satan hakui nga. Na masin ien, kaie Satan haniwen tesol kahikahimuto poh ti usi xaxaweniai spirit lialun? Puase tesol kahikahimuto kola ka kumahe salan nga hahapuasa pohe Satan. ");
INSERT INTO ssg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Spirit ti Haeu axi nga poh ti usi xaxaweniai spirit lialun. I kola ka Haeu tel neiniamuto ape i tahiawen. ");
INSERT INTO ssg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Satan masin tel seilon kuin. Tap tel seilon soh uke hani ingi tel seilon kuin ape waxi waliko tetan leili ing, halik na i xioti konginimu tel seilon kuin. Mewenae na i pamu kuiaian, i pon xoiniai tel seilon kuin. Se tin masin nga xoini Satan ape nga xaxaweni spirit lialun tetan ti seilon. ");
INSERT INTO ssg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Tel ti na i kumahe tepaun tetak, i pahoxai nga. Tel ti na i kum huali nga neiniai teka seilon hani Haeu, i neini hasele laha ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nga hone amuto, Haeu oxoxi seilon ti kawatan ti lawe saun lialun laha aile, tuahe na tel i kak halialu Holi Spirit, tap wanen Haeu oxoxi i ti kawatan ien. ");
INSERT INTO ssg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tel na i kak halialu nga tel Nati Seilon, Haeu oxoxi i ti kawatan ti saun lialun ien, tuahe tel na i kak halialu Holi Spirit, Haeu kum oxoxi i ti kawatan ti saun lialun ien lian tehue. ");
INSERT INTO ssg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Pata amuto paxai tioi na amuto paxai huan. Pata tenen huan solian i pata solian. Pata tenen huan lialun i pata lialun. Tin masin ala amuto tioi seilon solian ma na lialun na amuto paxai ani pupuasan. ");
INSERT INTO ssg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Amuto masin noh! Amuto kak ukek ia kakain solian na amuto seilon lialun? Kakain ti seilon ahuti i ahutama ti namilon. ");
INSERT INTO ssg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Seilon solian hina namil solian ape i ahuti kakain solian. Seilon lialun hina namil lialun ape i ahuti kakain lialun. ");
INSERT INTO ssg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Amuto tioi kewak, telao ngain ti Haeu hiniti seilon, lawe seilon uke kahi kakain lialun ti laha kakawen. ");
INSERT INTO ssg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Puki kakaiamuto sului aliake amuto. I kola na amuto seilon solian ma na lialun.” ");
INSERT INTO ssg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Teka hanaui nauna ti Moses ma teka Parisi kak ukek, “Tel masiwi, kola hanima amite pohem lehe amite tioi ka salan Haeu taloma o.” ");
INSERT INTO ssg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tuahe Jises kak pahoi, “Teka seilon ti aope ie laha watakai hawane Haeu, laha kakamei nga ailei waliko tenen lalap. Tuahe Haeu kola hani amuto tenenawe kolakol ie, waliko i sohot hani nga masin ti i sohot haniwen Jona, tel kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Masin ti Jona to ngain toluhu leili tiai tok xixi lalap, nga tel Nati Seilon, nga tin ngain toluhu leili amal. ");
INSERT INTO ssg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Telao ngain ti Haeu hiniti seilon, Haeu namiloi ukek teka seilon ti Niniva pamu sawisawin ti amuto nake laha towiahu ti saun lialun hani Haeu ti Jona kaxi ahutiwa kakai Haeu hani laha. Tuahe amuto kum towiahu ti lialui woumuto kalak nga kaxi ahuhuti kakai Haeu hani amuto. Nga kakane hawane amuto, nga pamu tuah ti Jona. ");
INSERT INTO ssg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tel hehin masiwi ti Siba luama ti xuxun pate xauxaun hongoi soliai nauna ti tel masiwi Solomon. Telao ngain ti Haeu hiniti seilon, waliko ti i aile i sului amuto nake amuto kum hong kakaiak kalak nga pamu tuah ti Solomon.” ");
INSERT INTO ssg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jises kak ulea ukek, “Na masin tel spirit lialun ahuta ti tel seilon ape i nahih hani he lohong upiai tesol na i to. Tuahe i kum tunah. ");
INSERT INTO ssg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","I kakane aliake i, ‘Nga alia hani leili tel seilon.’ I alia tunahi ka tel seilon aope i masin tehu ing tenen malaian ma tap tel ingangai. ");
INSERT INTO ssg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","I nahih waxi tepanim hua spirit lialun, pamu lialuan tetan ape lato soh hani leili tel seilon. Lato kapiti halialu akulai ti imat. Waliko ien tin i sohot hani teka seilon ti aope laha watakai hawane Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ti Jises kakak tutuen, tel tinan ma tesol ukalan tahiama. Pahalato kakak kapin. ");
INSERT INTO ssg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ape tel ti teka seilon ien kakane i, “Paxaiwa, tel tinam ma tesol ukalam lato ie. Pahalato kakak kapim.” ");
INSERT INTO ssg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jises ukek, “Aita wanen tel tinak? Aita wanen tesol ukalak?” ");
INSERT INTO ssg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","I kola tesol kahikahin ape i ukek, “Paxaiwa! Teka seilon ie se tinak ma ukalak. ");
INSERT INTO ssg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Hatesol teka na laha aile usi waliko ti tel Tamak Haeu pahan, laha se ukalak, tuak ma tinak.” ");
INSERT INTO ssg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ngain tin tetehu Jises nahih salili tehu ing ape i nahih to hani pape kanitax Galili ti hanaui teka seilon. ");
INSERT INTO ssg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kilan kasia seilon apuha kakalini i, aile ape i ku to hani he tea koap. Teka seilon tutu peixux hongoi kakaian. ");
INSERT INTO ssg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","I kaxi kilan meng ti hanaualaha. I ukek, “Telao tel seilon seini waki maia. ");
INSERT INTO ssg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ti i totowi waki maia, hina i put hani he aweisal ape manixux ngong ani. ");
INSERT INTO ssg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hina i put hani he kalamael. Waki maia i xex, tuahe hepekeun pate pakepaken. ");
INSERT INTO ssg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ti alon kekelih, i mani telei supuli maia nake i tai wahai aluini. ");
INSERT INTO ssg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hina waki maia i put hani leili au. Ti i xexele, au talini ape i kum hua. ");
INSERT INTO ssg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tuahe waki maia liai i put hani hepekeun solian. I xex ape hua palahi 30, hina palahi 60 ma teka palahi 100 akulaiwen ti tel seilon seini.” ");
INSERT INTO ssg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ape Jises tili kakaian ukek, “Na amuto hina taxing ti hongoi kakain, hongoa!” ");
INSERT INTO ssg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Muhin tesol kahikahi Jises nahih hani kapin ape lato kamei i, “Nake lahan o uke meng ti na o hanau seilon?” ");
INSERT INTO ssg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jises pahoi ukek, “Haeu haxewa hani amuto sale nenein tetan tuahe kumahe laha. ");
INSERT INTO ssg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Na tel seilon hong usi kakai Haeu, Haeu axi aheke anesoan tuahe na tel seilon kum hong usi kakaian, anesoan Haeu waxi aliake. ");
INSERT INTO ssg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nga kaxi meng hani laha nake laha papaxai waliko ti nga ailele tuahe laha kum ningahi, laha hongohong waliko ti nga kakak tuahe laha kum xeu. ");
INSERT INTO ssg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tenen ien i hapoponowi hawane waliko ti Aisaia kak kilamiwen. I ukek, “‘Teka seilon laha hongohong kakai Haeu tuahe laha kum xeu, laha papaxai waliko ti Haeu ailele tuahe laha kum ningahi. ");
INSERT INTO ssg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nake patulaha pate ailan, taxingalaha kilakilan a pulalaha masin pulaxa. Kaie ala laha ningahiwen ma hong xewawen ma towiahuen ti lialui woulaha ape nga aile haewiawen laha.’” ");
INSERT INTO ssg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ape Jises kakane tesol kahikahin ukek, “Tanusik ka amuto hong xeu kakaiak ape amuto paxai tioi waliko ti nga ailele. ");
INSERT INTO ssg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nga kakane hawane amuto, kilan teka kuluiai kakai Haeu ma teka seilon sawisawin, pahalaha wanen ningahiai waliko ti amuto niningahi tuahe laha tai ningahi. Ape pahalaha hongoi waliko ti amuto hongohong tuahe laha tai hong.” ");
INSERT INTO ssg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Amuto hongoa! Nga kaxi haxewa hani amuto tenen meng ti seiniai waki maia. ");
INSERT INTO ssg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Teka laha hong kakain ti Haeu neini seilon a laha kum xeu, laha masin aweisal ti waki maia put to. Laha hong kakai Haeu tuahe malimun wanen na Satan xaxaweni kakai Haeu ti leilolaha. ");
INSERT INTO ssg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kalamael ti waki maia put to, i kikilami teka seilon laha hongoa kakai Haeu ape pate laha amuke. ");
INSERT INTO ssg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tuahe masin tesol waki maia i tai wahai aluini, teka seilon ien tap namil xoxoan ti Haeu. Laha soh kakai Haeu teik kukunun. Taen kawatan ma totohong tunahiwa laha ti usiai kakai Haeu, xoxoi namilolaha ti Haeu pate i put kosea. ");
INSERT INTO ssg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Hepekeun ti hina au ti waki maia put to, i kikilami teka seilon laha hong kakai Haeu, tuahe laha namiloi kasini waliko ti itan ie. Pahalaha soxialaha kilan. Namil tenen ien kokongini kakai Haeu ape laha kum hua. ");
INSERT INTO ssg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tuahe hepekeun solian kikilami teka seilon laha hong auni kakai Haeu ape laha hua. Teka laha hua 30, teka 60 ma teka liai 100 akulaiwen ti uli seinian.” ");
INSERT INTO ssg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jises kakane laha tenen meng i ukek, “Aweisal ti Haeu neini seilon masin tel seilon i seini peteta he tesol kinen. ");
INSERT INTO ssg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ipong tehu ti hatesol seilon mamatih, tel seilon lialun nahih seini kango hani he tesol kin ape i nahih salili. ");
INSERT INTO ssg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tataen ti peteta xexele i xex hetekiele kango. ");
INSERT INTO ssg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Teka unaui tel tame tesol kin nahih hani kapin ape lato ukek, ‘Amite sokok o seseini peteta. Alahan ka hina kango leili tesol kinem?’ ");
INSERT INTO ssg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“I ukek, ‘Tel seilon i watakai hawane nga i seini kango.’ “Lato kamei i, ‘Paham amite nahih sohuti hatapo kango?’ ");
INSERT INTO ssg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Tuahe i ukek, ‘Kumahe, uke na amuto sohuti kango, amuto sohuti hetekie tunahi peteta. ");
INSERT INTO ssg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tiliwen lato xex hetekie atengi tataen ti tahiwiai ane peteta. Ape nga talo teka unauak sohuti apuhini luimu kango. Imuh lato apuhini peteta hani tehu ing ti tone an.’” ");
INSERT INTO ssg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jises kaxi ulea tenen meng i ukek, “Aweisal ti Haeu neini seilon tin masin tel seilon i waxi tehu waki lilieu ape i seini. ");
INSERT INTO ssg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","I pate kokol ti lawe waki pata tuahe ti i xexewa i pamu lapan ti lawe pata ape teka manixux atai ingalaha he ngaxon.” ");
INSERT INTO ssg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jises kaxi ulea tenen, “Aweisal ti Haeu neini seilon tin masin ie. Tel hehin i waxi teik kokole ist ape i talini hani he palawa. Kalak teik ist kokol, i haxiwa palawa hatehu.” ");
INSERT INTO ssg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jises lawe kaxi meng ti hanaui teka seilon sale nenein ti Haeu. Ti lawe i kakane laha i hapuasa meng. ");
INSERT INTO ssg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","I aile ukek lehe i hapoponowi hawane waliko ti tel kuluiai kakai Haeu kakawen. I ukek, “Nga kaxi meng na nga kakane laha. Nga kakane laha waliko ti laha tai tioi hutuima ti Haeu tanomi lawe waliko.” ");
INSERT INTO ssg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ti Jises saliliwa teka laha apupuha, i soh hani leili ing ape tesol kahikahin kamei i, “Kaxi hanima amite salangawe menge kango ti leili tesol kin.” ");
INSERT INTO ssg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jises pahoi lato, “Tel seilon seiniai peteta i tu kikilami nga tel Nati Seilon. ");
INSERT INTO ssg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tesol kin se lawe xux itan ie. Peteta se teka unaui Haeu a kango se teka unaui Satan. ");
INSERT INTO ssg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tel seilon i seini kango ien se Satan. Ngain ti tahiwiai ane peteta i kikilami tapoi lawe xux itan ie. Teka unaui tel tame kin se teka engel, spirit solian ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ti teka seilon sohuti lui kango se masin wanen na laha aile ti tapoi lawe xux itan ie. ");
INSERT INTO ssg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nga tel Nati Seilon, nga talo teka unauak engel apuhiniai teka seilon laha aile haputa teka liai ma teka laha aile saun lialun. ");
INSERT INTO ssg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ape lato towi laha hani tehot ah lalap. Tesol ien laha tang lialu ape atalahi nisulaha nake pate moloan. ");
INSERT INTO ssg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ape teka seilon ti Haeu laha kamakam hanowi alon he tesol tone Haeu. Na amuto hina taxing ti hongoi kakain, hongoa! ");
INSERT INTO ssg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Aweisal ti Haeu neini seilon tin masin tel seilon tihini muneni waliko pate tuah leili hepekeun. Ape tel liai tahiwi tunahi. Pate i amuam hawane ape i tihini aliake. I nahih hangaini hatapo soxian ape i kahui teik hepekeun ien. ");
INSERT INTO ssg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Aweisal ti Haeu neini seilon tin masin tel seilon i upia teik waliko pate tuah. ");
INSERT INTO ssg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tataen ti i tunahiwa, i nahih hangaini hatapo soxian ape i kahui teik waliko ien. ");
INSERT INTO ssg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Aweisal ti Haeu neini seilon masin teka seilon towi tehu ka hani itax ape lato tike kilan xixi tenen tenen. ");
INSERT INTO ssg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lato itini hani peixux ape hiniti, xixi solian hani leili po ape xixi lialun lato xoini. ");
INSERT INTO ssg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tin masin wanen taun ti tapoi lawe xux itan ie, teka engel ti Haeu hiniti seilon. ");
INSERT INTO ssg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ape laha towi seilon lialun hani tehot ah lalap. Tesol ien laha tang lialu ma atalahi nisulaha nake pate moloan.” ");
INSERT INTO ssg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jises kamei tesol kahikahin, “Amuto xewan waliko ti nga kakak?” Lato ukek, “Se, amite xewawen.” ");
INSERT INTO ssg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ape i ukek, “Teteka hanaui nauna ti Moses lato hong usi ma hanau nauna ti Haeu ti imat ma aope, lato masin tame tehu ing. I pon hapuasai waliko haun ma wasan he tesol tone auniai soxi.” ");
INSERT INTO ssg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ti Jises kaxi kewa meng hani lato i nahih salili tesol ien. ");
INSERT INTO ssg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","I alia hani tesol puki tonan ti Nasaret. I nahih soh hani synagog ape i hanau teka seilon. Teka laha hongohong laha ongake hawane waliko ti i kakak ape laha ukek, “I kekema anesoan ia? Alahan i pon aile hasohotui waliko tenen poh ti seilon kum pon ailean? ");
INSERT INTO ssg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","I tuahe nati tel ataiai ing. I tel nati Mary ma ukale Jeims, Josep, Saimon ma Judas. ");
INSERT INTO ssg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nakon tesol tuan kumahe tin lato toto ie? Lawe waliko ien i kema ia?” ");
INSERT INTO ssg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aile ape laha watakai hongoi kakaian. Jises hone laha, “Nga masin tel kuluiai kakai Haeu. Ti toan liai seilon sameni i tuahe ti puki tonan wanen laha watakai hongoi kakaian.” ");
INSERT INTO ssg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ape Jises kum aile hakila puasain ti poh hani laha nake laha tap namil xoxoan hani i. ");
INSERT INTO ssg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lokon ien, Herod tel masiwi ti Galili hong tunahi menge Jises. ");
INSERT INTO ssg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","I kakane teka masiwi laha pupuas hahitakan, “Ie se Jon Baptis i moih aliawen. Aile ape i hina poh ti ailei waliko tenen lalap ti seilon kum pon.” ");
INSERT INTO ssg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ti imat, Herod talo teka unauan xinoti kalabusiai Jon. Herod tel i xuina Herodias, axoi tel ukalan Pilip. ");
INSERT INTO ssg_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Aile ape Jon Baptis lawe i to kaakane Herod, “Kumahe wanen sawisawin o uke axoam Herodias!” ");
INSERT INTO ssg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod pahan i telei Jon, tuahe i mamata teka Ju nake laha ukek Jon i tel kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tehu ngain ti nameniai telao Herod takah, tel nati Herodias hehin denis hani teka seilon laha apupuha ti angiain. I hamuamua hawane Herod. ");
INSERT INTO ssg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Aile ape Herod kak tuoha hani i, “Waliko tenen na paham, nga hani o!” ");
INSERT INTO ssg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ape i usi namili tel tinan i ukek, “Hanima nga pati Jon Baptis. Lohi hanima he tehu kapi!” ");
INSERT INTO ssg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Namili Herod sihikuk hawane tuahe i kak tuoha haniwen tel hehin ti puli lawe seilon ka i hani i waliko tenen na pahan. ");
INSERT INTO ssg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","I talo tel unauan nahih hani ingi kalabus ti koti xaxaweniai kinawe Jon Baptis. ");
INSERT INTO ssg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","I hana pati Jon leili tehu kapi, i kau hani tel hehin ape i hani tel tinan. ");
INSERT INTO ssg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Imuh tesol kahikahi Jon nahima. Lato waxi mewenae tupuan ape tihini auni. Muhin lato nahih hone Jises. ");
INSERT INTO ssg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tataen ti Jises hong tunahiwa waliko ti i sohot hani Jon, i ku he tea koap ape i salili tesol ien hani tesol tahain. Teka seilon leili taon hongoa, laha nahih usi i. ");
INSERT INTO ssg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ti Jises mosua he tea koap, i ningahi kilan wanen seilon. I tahane hawane laha ape i haewia teka tinun. ");
INSERT INTO ssg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ti ape alohah, tesol kahikahi Jises nahih hani kapin, lato hone i, “Pate ape alohah a tap toan ie. Taloa teka seilon hani toan lehe laha kahui analaha.” ");
INSERT INTO ssg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jises hone lato, “Kumahe, laha kum nahih salili kako. Amuto axiwa analaha.” ");
INSERT INTO ssg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lato hone i, “I kum pon! Toi amite tepanimawe bret ma huok xixi.” ");
INSERT INTO ssg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jises ukek, “Kau hanima nga.” ");
INSERT INTO ssg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","I hone teka seilon to haniai he pahoah. I waxi tepanim bret ma huok xixi. I pax hani patul, i kak kemulik hani Haeu ape i wiki. I hani tesol kahikahin ape lato sei hani teka seilon. ");
INSERT INTO ssg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Laha hatesol ang ahoi hawane. Ape huopanim huohu po moxe an tutuen ti tesol kahikahi Jises apuhiniwa. ");
INSERT INTO ssg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mongohe seilon laha angiang sai 5,000, tai wexe teka hehin ma akaik. ");
INSERT INTO ssg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Muhin Jises hone tesol kahikahin langai imat tetan hani liai tepaun ti kanitax Galili he koap. Ape i talo aliake teka kilai seilon. ");
INSERT INTO ssg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mewenae i nahih hani patul he tehu maunten ape i lotu. Ti ape alohah, Jises mewenae i tutuen. ");
INSERT INTO ssg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lokon ien tea koap ape i xauwen. Laman hapa ahuahu tea koap nake aupol ah suei i. ");
INSERT INTO ssg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sikole letu ti teik tilokoan tutuen, Jises nahiwa patul he kanitax hani kapi tesol kahikahin. ");
INSERT INTO ssg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ti tesol kahikahin ningahiwa i nanahih patul he kanitax, lato mamata hawane ape lato tilol ausisini, “Tel manu!” ");
INSERT INTO ssg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jises hone hamatua lato, “Haxoxoa namilomuto! Se nga. Kum maamata!” ");
INSERT INTO ssg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita hone i, “Tel masiwi, na salan wanen o, honema nga nahih patul he kanitax hani kapim.” ");
INSERT INTO ssg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jises ukek, “Nahima!” Pita mos he tea koap ape i hutui nahih patul he kanitax hani kapi Jises. ");
INSERT INTO ssg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tuahe ti i ilameniwa kuiai aupol, i mamata ape lehe i taxix. I tilol ausini, “Tel masiwi, hualima nga!” ");
INSERT INTO ssg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kiliwan wanen Jises tuliniwa minan, i akeni Pita ape i ukek, “Nake lahan namilom wakul alia tetak?” ");
INSERT INTO ssg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ti lalu ku haniwa he tea koap, aupol mat. ");
INSERT INTO ssg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tesol kahikahin he tea koap lokuha hani Jises. Lato ukek, “Salan wanen o tel Nati Haeu!” ");
INSERT INTO ssg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ti lato meiwa liai tepaun ti kanitax Galili, lato mos he tea koap hani Genesaret. ");
INSERT INTO ssg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ti teka seilon ti tesol ien paxai tioiwa Jises, laha sawateni kakain hani teka seilon leili lawe toan. Kilan seilon hakahita teka tinun hani kapin. ");
INSERT INTO ssg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Laha kamei eliel i na ewi teka tinun tua soti ngixi puxuaun. Ape teka laha soti, laha ewi. ");
INSERT INTO ssg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Lokon ien teka Parisi ma teka hanaui nauna ti Moses laha nahima Jerusalem hani kapi Jises. Laha kamei i, ");
INSERT INTO ssg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Alahan tesol kahikahim kum aile usi nauna ti teka matahaun? Ti lato ang, lato tai nuhi minalato.” ");
INSERT INTO ssg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jises hone lato ukek, “A alahan amuto kum hong usi nauna ti Haeu ape amuto usi puki saun ti amuto? ");
INSERT INTO ssg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Haeu ukek, ‘Hong tamaniwa kakai tamam ma tinam ape aile hasolia haniwa lalu. Na o kak halialu tamam ma tinam, o laha telei.’ ");
INSERT INTO ssg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tuahe amuto ukek se ewi na seilon kum huali tamalaha ma tinalaha na teik huhual ti hualialalu laha haniwen Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Amuto hanau ukek ien ape seilon kum huali tamalaha ma tinalaha. Ti amuto aile ukek ien, kumahe amuto usiusi kakai Haeu, amuto hakoutama saun tenen puki ti amuto. ");
INSERT INTO ssg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Amuto seilon tenen lehomuto huoka! Aisaia tel kuluiai kakai Haeu, kakaian sawisawin ti i kakak amuto. I ukek, ");
INSERT INTO ssg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Teka seilon sameni nga ti tuahe awalaha a namilolaha pate xauxaun tetak. ");
INSERT INTO ssg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kumahe salan laha lolotui nga. Laha hanau waliko ti puki seilon namiloi tanomi.’” ");
INSERT INTO ssg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ape Jises tiloi apuhini teka kilai seilon. I kakane laha ukek, “Amuto hongoa lehe amuto xeu. ");
INSERT INTO ssg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Waliko ti i soh nonoa he awamuto, i kum haloloa amuto. Mewenae waliko tenen na i ahutama he awamuto, i haloloa amuto.” ");
INSERT INTO ssg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Imuh tesol kahikahin nahih hani kapin. Lato kakane i ukek, “O tioi ka waliko ti o kakak i hakawata tiai teka Parisi?” ");
INSERT INTO ssg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jises hone lato ukek, “Lawe pata ma pahoah ti kumahe tel Tamak Haeu seini, i sohuti xaxaweni. ");
INSERT INTO ssg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aile ape maluhewa lato! Lato masin seilon tenen pulaxa neiniai teka pulaxa. Na masin tel pulaxa neini tel pulaxa liai, ati lalu put hani leili wal.” ");
INSERT INTO ssg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ape Pita ukek, “Nexi haxewa hanima amite salangawe teik kakain ti o kakak.” ");
INSERT INTO ssg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jises ukek, “Tin amuto tai xeu tutuen? ");
INSERT INTO ssg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nakon amuto kum tioi ka waliko tenen i soh nonoa he awamuto i tamus hani he puhuamuto? Imuh ape i ahuta hani melal. ");
INSERT INTO ssg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tuahe lawe waliko i ahutama he awamuto i ahuma he atemuto. Ape tesol waliko ien i haloloa amuto. ");
INSERT INTO ssg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Waliko lialun ti i ahutama leilomuto se tetesol: namil lialun, na ulini ape telei seilon, xuinai axoi seilon liai, saun lialun ti wawan hehin, xuxuina, puputa ma kak halialui seilon liai. ");
INSERT INTO ssg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tesol waliko ien lawe i haloloa seilon. Tuahe na seilon kum nuhi min ape i ang, Haeu kum namiloi ukek ka tenen ien i haloloa seilon.” ");
INSERT INTO ssg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jises nahih salili ien ape i nahih hani tesol toan xohixohin Taia ma Saidon. ");
INSERT INTO ssg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tel hehin i kumahe Ju toto ien. I nahih hani kapi Jises ape i kamei eliel ukek, “Tel Masiwi kahi nati David, tahanema nga! Spirit lialun kapiti halialuen tel natuk hehin.” ");
INSERT INTO ssg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tuahe Jises tai kak pahoi i na tenen. Ape tesol kahikahin kamei i ukek, “Talo aliakewa tel hehin nake i kak hakatole kako.” ");
INSERT INTO ssg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jises hone tel hehin ukek, “Tel Tamak Haeu taloma nga ti hualiai teka Ju nake laha masin teka sipsip tap ngahatalaha, a o kumahe Ju.” ");
INSERT INTO ssg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tel hehin lokuha hani kapi aen ape i ukek, “Tel masiwi, hualima nga!” ");
INSERT INTO ssg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tuahe i kakane tel hehin ukek, “Kumahe solian na tel i waxi ani natun ape towi hani ani sinen.” ");
INSERT INTO ssg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A tel hehin ukek, “Salan wanen, tel masiwi. Tuahe sinen ani peni tamalaha na i put hani itan.” ");
INSERT INTO ssg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jises kakane tel hehin ukek, “Namilom salan xoxoan wanen tetak! Nga aile usi waliko tenen paham.” Ape tel natun i ewi huluta tataen ien. ");
INSERT INTO ssg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jises nahih salili tewau toan ien ape i nahih xohi hani kanitax Galili. I nahih hani patul he tehu maunten ape i to ien. ");
INSERT INTO ssg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kilan wanen seilon hakahita hani kapin teka laha nahih tawen, teka pulaxa, teka waxosi, teka laha wix tawen ma kilan teka liai. Laha hana teka tinun hani kapi ae Jises ape i haewia laha. ");
INSERT INTO ssg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Teka seilon ongake hawane ti laha ningahiwa teka laha wix tawen ape laha kak uke, teka waxosi laha ewi, teka laha nahih tawen laha nahih uke ape teka pulaxa laha paxapax. Ape laha sameni Haeu ti Israel. ");
INSERT INTO ssg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jises tiloi tesol kahikahin ape i ukek, “Nga tahane hawane teka seilon ie nake laha kapik kewen ngain toluhu a laha tap an. Nga kum talo aliake laha hetekie hitolo, uke laha akimatu he aweisal.” ");
INSERT INTO ssg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tesol kahikahin kamei i, “Ti he lohong ie, kako kema an ia ti axiai ani teka lawalawai seilon?” ");
INSERT INTO ssg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ape Jises kamei lato, “Hil bret toi amuto?” Lato ukek, “Tepanim huaik ma tok palai xixi kokol.” ");
INSERT INTO ssg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jises hone hatesol seilon ka to haniwa itan. ");
INSERT INTO ssg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","I waxi tesol tepanim huaik bret ma tok palai xixi ape i kak kemulik hani Haeu. I wiki, i hani tesol kahikahin ape lato hani tesol kilai seilon. ");
INSERT INTO ssg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Laha hatesol ang ahoi hawane. Muhin, ti tesol kahikahi Jises apuhiniwa moxe an, i sohotua po tepanim huohu. ");
INSERT INTO ssg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mongohe teka seilon laha angiang sai 4,000, tai wexe teka hehin ma akaik. ");
INSERT INTO ssg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Muhin ien Jises talo aliake teka kilai seilon. Ape i ku he tea koap hani texux xux Magadan. ");
INSERT INTO ssg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Teka Parisi ma teka Sadusi nahih hani kapi Jises ape pahalaha hauhe i. Laha ukek, “Kola hanima amite pohem lehe amite tioi ka Haeu taloma o.” ");
INSERT INTO ssg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tuahe Jises pahoi lato ukek, “Na amuto paxai loloi al maun kakan, amuto ukek letu se hunawi ape salan. ");
INSERT INTO ssg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ape na amuto paxai maun kakan ma polun ti pate letu, amuto ukek tetelao hunaxa. Salan amuto tioi hunan na amuto paxai maun tuahe amuto kum tioi salangawe waliko ti i sosohot aope, waliko ti nga ailele. ");
INSERT INTO ssg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Teka seilon ti aope ie pate lialun ma xauxaun ti Haeu. Nga kum kola hani amuto kolakol ti poh. Mewenae kolakol ti Haeu kola hani amuto se waliko ti i sohot haniwen Jona tel kuluiai kakai Haeu!” Ape Jises nahih salili laha. ");
INSERT INTO ssg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tataen tesol kahikahi Jises lang haniwa liai tepaun ti kanitax Galili, lato upia tunahi ka lato maluhewen analato bret. ");
INSERT INTO ssg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jises hone lato, “Kanipetiwa! Lepeta hawanewa ist ti teka Parisi ma teka Sadusi.” ");
INSERT INTO ssg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tesol kahikahin kakak alia wasolalato ukek, “I kak ukek nake kako maluhe anakako bret.” ");
INSERT INTO ssg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jises tioi waliko ti lato kakak, aile ape i kamei lato, “Alahan amuto kakak ka tap anamuto bret? Namilomuto kumahe xoxoan tetak. ");
INSERT INTO ssg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tin amuto tai xeu? Amuto kum nameni ti nga waxi tepanim bret hani ani teka seilon laha akulai 5,000? Amuto kum nameni hil po moxe an ti amuto apuhini? ");
INSERT INTO ssg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ape ti tepanim huaik bret ti nga hani ani teka seilon laha akulai 4,000? Amuto kum nameni hil po moxe an ti amuto apuhini? ");
INSERT INTO ssg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ala amuto tioiwa kumahe nga kakak sale bret. Kakaiak nga ukek amuto lepeta hawanewa ist ti teka Parisi ma teka Sadusi.” ");
INSERT INTO ssg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tataen ien tesol kahikahin tioi ka kumahe i kakak kanipetiai ist ti ailei bret, tuahe i kakak lato kanipetiwa teka Parisi ma Sadusi nake laha hanau puluti seilon. ");
INSERT INTO ssg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jises nahih hani toan leili Sisaria Pilipai ape i kamei tesol kahikahin, “Teka seilon laha ukek nga tel Nati Seilon, aita wanen?” ");
INSERT INTO ssg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Lato ukek, “Teka laha ukek o Jon Baptis. Teka liai ukek o Elaija ape teka liai ulea ukek o Jeremaia ma na tel liai ti teka kuluiai kakai Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","I kamei lato, “A puki amuto ukek nga aita?” ");
INSERT INTO ssg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita ukek, “O Krais, tel Nati Haeu. Haeu tel tap tahi matean!” ");
INSERT INTO ssg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jises ukek, “Saimon tel nati Jona, tanusik o nake tap tel seilon kakane o nga aita. Tel Tamak Haeu hani o teik namil ien. ");
INSERT INTO ssg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pita, o masin teik hepekeun ailan. Masin ti tel seilon atai ingan patul he hepekeun ailan, hetekie huhual tetam nga aile hasohotu teka seilon kahikahik hahitake axak. Ape tap tenen waliko i xoini laha, kalak pohe Satan. ");
INSERT INTO ssg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nga hana o tel neiniai teka seilon hani Haeu lehe laha sohot kahikahik. Waliko tenen o halini ti itan ie, Haeu tin i halini. Waliko tenen o waheni teka kahikahik aile ti itan ie, Haeu tin i waheni.” ");
INSERT INTO ssg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ape Jises hone tesol kahikahin kum kaakane teka seilon liai ka i Krais, tel Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lokon ien Jises hutui kakane tesol kahikahin ukek, “Nga nahih hani Jerusalem. Ti ien teka masiwi ti teka Ju, teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses, laha axi nga kawatan ma moloan lalap. Laha telei nga tuahe muhi ngain toluhu nga xahat alia.” ");
INSERT INTO ssg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita waxi siaini Jises ape kahiloloi i. I ukek, “O kum kak ukekek ien. Waliko ien kum sosohot wanen hani o!” ");
INSERT INTO ssg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jises tohea paxai tesol kahikahin ape i kak kahiloloi Pita, “Tahawa! O kak hanowi Satan! O tiehi aweisaluk. Namilom kumahe i ahuma ti Haeu, i ahuma ti seilon.” ");
INSERT INTO ssg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ape Jises hone tesol kahikahin, “Na seilon pahan sohot kahikahik, laha kum namiloi wawaxi mewenae laha. Laha kaua kawatan masin ti nga kakau. Ien i kola ka laha kahikahik wanen. ");
INSERT INTO ssg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Seilon teka namilolaha mewenae hasoliai tonalaha ti itan ie, laha kum tunahi tonain kapi Haeu. Tuahe teka na laha hana tonalaha hahitake nenein ti Haeu nake nga, laha tunahi tonain kapi Haeu ti tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Na tel seilon hapono hatapo i waliko ti itan ie tuahe i lioi tonain kapi Haeu, solian la i uke? Tap. Tap tenen waliko kahui uke tonain kapi Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nga kakane amuto tetenen nake nga tel Nati Seilon alia hetekiema poh ma xewai tel Tamak Haeu ma teka engel, spirit solian tetan. Tataen ien nga kahui hapoponowi hani teka seilon tenen tenen ti laha ailewen. ");
INSERT INTO ssg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nga kakane hawane amuto, teka ti amuto ie, amuto kum matemu atengi tataen amuto ningahi nga tel Nati Seilon neini teka seilon.” ");
INSERT INTO ssg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Muhi ngain tepanim tehu tamusua, Jises hakahita tolu kahikahin Pita ma hahutalin Jeims ma Jon hani he tehu maunten patul ti mewenae lato. ");
INSERT INTO ssg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ti lato ien, tanome Jises i sohia. Kawan kamakam hawane hanowi alon a puxuaun paxaxu talepalep hawane. ");
INSERT INTO ssg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hahutuia hawane Moses ma Elaija take hani kapi lato ape lalu kakak kapi Jises. ");
INSERT INTO ssg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ape Pita hone Jises ukek, “Tel masiwi, pate ewi ti kako ie! Na o waheni, nga atai toluhu houha, tehu tetam, tehu ti Moses ma tehu ti Elaija.” ");
INSERT INTO ssg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ti Pita kakak, teik maun tenen xewan wanen man atuhi lato. Ape kakai Haeu i ahuma he maun ien, i ukek, “Tel seilon ie se Natuk pate nga waheni. Nga amuke hawane i. Hong usiwa kakaian!” ");
INSERT INTO ssg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ti tolu kahikahi Jises hongoa, lato mamata hawane ape lato eng kalunga muneni kawalato. ");
INSERT INTO ssg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jises nahih hani kapi lato. I aka soti lato ape i ukek, “Xahatale! Kum maamata!” ");
INSERT INTO ssg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ti lato xeisale, tap seilon kapi Jises, se ape mewenae i. ");
INSERT INTO ssg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ti lato momosua he tehu maunten, Jises kakane eliel lato i ukek, “Kum kakaxi hani tel na seilon waliko ti amuto ningahiwen atengi tataen nga tel Nati Seilon xahat alia ti mateak.” ");
INSERT INTO ssg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tesol kahikahin kamei i ukek, “Nake lahan teka hanaui nauna ti Moses ukek ka Elaija i sohotumu imat ti Krais?” ");
INSERT INTO ssg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jises ukek, “Salan wanen, tel masin Elaija i sohotumu apeseniai teka seilon imat ti Krais sohot. ");
INSERT INTO ssg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tuahe nga hone amuto, tel masin Elaija i sohotuen, tuahe teka seilon kum paxai tioi. Laha aile halialu i. Tin masin kawatan ma moloan ti na laha aile hani nga tel Nati Seilon.” ");
INSERT INTO ssg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tataen ien tesol kahikahin hong tioi ka i kakak Jon Baptis, tel i sohotuma imat ti Krais. ");
INSERT INTO ssg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ti lato tahia haniwa itan, kilan seilon apupuha ien. Tel seilon nahih hani kapi Jises ape i lokuha hani kapi aen. ");
INSERT INTO ssg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","I ukek, “Tel masiwi, tahanema tel natuk! Pate i lamani moloan ape i taxitaxia. Hina lawe i put hani leili kan ma he ah. ");
INSERT INTO ssg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nga hakahitawen i hani kapi tesol kahikahim tuahe lato kum haewia uke i.” ");
INSERT INTO ssg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jises ukek, “Amuto teka seilon ti aope ie tap namil xoxoan ti Haeu ma saun ti amuto pate lialun. Nga to kapimuto ma hanau kueiniwen amuto. Kaie kuehuan ia pahamuto nga to kapimuto lehe namilomuto xox tetak? Ati hanima nga tel akaik!” ");
INSERT INTO ssg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ape Jises tumei xaxaweni spirit lialun ti i aile hahalialu tel akaik. Tataen ien wanen i ewi. ");
INSERT INTO ssg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Muhin ien tesol kahikahi Jises nahih hani kapin ti tesol mewenae i ape lato kamei, “Nake lahan amite kum xaxaweni uke spirit lialun ti tel akaik?” ");
INSERT INTO ssg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jises pahoi lato ukek, “Nake amuto tap namil xoxoan ti Haeu. Nga kakane hawane amuto, kalak na xoxoi namilomuto ti Haeu lapan waki lilieu, amuto pon kak naxiai tehu maunten ie ape i naxia. I pon amuto aile lawe waliko!” ");
INSERT INTO ssg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ape Jises tili kakaian, “Spirit lialun tenen ien mewenae na amuto halini an hualiai lotu i pon xaxawenian.” ");
INSERT INTO ssg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ti tesol kahikahi Jises apuha haniwa Galili, Jises hone lato, “Nga tel Nati Seilon, imuh laha hana hani mini teka seilon laha watakai hawane nga. ");
INSERT INTO ssg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Laha telei nga ape muhi ngain toluhu nga xahat alia.” Tesol kahikahin lolato tel hawane. ");
INSERT INTO ssg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ti Jises ma tesol kahikahin nahih haniwa Kapenaum, teka waxiai moni ti ailei puasain leili Ingi Haeu, laha nahih hani kapi Pita ape kamei i, “Jises, tel masiwi ti amuto, i totowi moni hani Ingi Haeu?” ");
INSERT INTO ssg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita pahoi lato “Se, i axiaxi.” Ape i nahih hani leili tehu ing Jises toto. Jises kak suei non i, “Saimon o namiloi ukek ia? Ti teka masiwi waxi moni, laha waxi ti teka akikilaha ka ti teka liai?” ");
INSERT INTO ssg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita pahoi i ukek, “Teka seilon liai.” Ape Jises ukek, “Na masin ien, teka akikilaha kum towi moni. ");
INSERT INTO ssg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tuahe kumahe pahakalu aile halengealaha. Nahih haniwa peixux ape towiwa tehu kapetum haniwa itax. Tok xixi uli o ahetiwa, heiwa awan ape o tunahi tehu moni. Waxiwa ape kau haniwa Ingi Haeu, ati ti kalu.” ");
INSERT INTO ssg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ti lokon ien tesol kahikahi Jises kamei i, “Aita tel pamu tuah leili teka seilon ti Haeu neneini?” ");
INSERT INTO ssg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jises tiloi hatuhi tel akaik matalato. ");
INSERT INTO ssg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ape i ukek, “Nga kakane hawane amuto, na amuto kum towiahu ti lialui woumuto ape sohot hanowi akaik kokol, amuto kum tuai uke teka seilon ti Haeu neneini. ");
INSERT INTO ssg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aile ape na tel seilon i teheni i hanowi tel akaik ie, i tel pate tuah leili teka seilon ti Haeu neneini. ");
INSERT INTO ssg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Na tel i waxi auni akaik masin ie nake nga, se i aunini nga. ");
INSERT INTO ssg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tuahe na tel i aile haputa tel seilon kalak i seilon naun ma namilon kumahe xoxoan tetak, pamu ewian na laha xinoti tehu mes lalap he kinawen ape hataxixi hani ilam. ");
INSERT INTO ssg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Pate lialun wanen ti teka seilon, nake kilan waliko lialun i tohongi haputa laha. Tesol waliko ien liai i sohot, tuahe pamu lialuan ti teka seilon laha aile haputa seilon liai. ");
INSERT INTO ssg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Na amuto hapuasa tepaun minamuto ma na aemuto ailei saun lialun, koti xaxaweniwa. Pamu ewian na amuto uke tonain kapi Haeu ti tap tahi tapoan ti minamuto ma na aemuto tepaunue. I se pamu ewian ti na Haeu towi amuto hetekie minamuto ma na aemuto hupaun hani tesol ti tehot ah xekean tap tahi pehoan. ");
INSERT INTO ssg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na amuto hapuasa tepaun pulamuto ailei saun lialun, axixi xaxaweniwa. Pamu ewian na amuto uke tonain kapi Haeu ti tap tahi tapoan ti pulamuto tepaunue. Ien se pamu ewian ti na Haeu towi amuto hetekie pulamuto hupaun hani leili tehot ah, tetesol ti kawatan tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Amuto kum paxai wawasi seilon tenen teka liai ukek laha kaliap. Nga hone amuto, teka engel ngahatialaha pon kaxialaha hani tel Tamak Haeu, tuahe na telao.” ");
INSERT INTO ssg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Jises kakane tesol kahikahin, “Nga tel Nati Seilon sohotuma neiniai teka seilon hani Haeu, teteka laha xauxaun tetan nake ti lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Amuto namiloi ukek ia? Na masin tel seilon i hina 100 sipsip ape tok i nahih mitaxia, hoi liai i nahih salili tesol 99 ape i nahih upia tok i mitaxiawen. ");
INSERT INTO ssg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na masin i tunahiwa, nga kakane hawane amuto, i amuke hawane i akulai amukei tesol 99 lato tai mitaxia. ");
INSERT INTO ssg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tin masin tel Tamak Haeu watakai wanen kalak tel seilon naun ti teka seilon tetan nahih mitaxia ape i selaia tetan.” ");
INSERT INTO ssg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jises kak ulea ukek, “Na tel kahikahik aile saun lialun hani tel ti amuto, nahih haniwa kapin ti mewenae amulu ape kak nexi haniwa i saun lialun ti i aile. Na masin i hong waheni kakaiam, o aile hasoliawen wasolamulu. ");
INSERT INTO ssg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tuahe na i hong watakai kakaiam, waxiwa tel ma na hua seilon liai lehe tel ma na hua hong paxai kakaiamulu. ");
INSERT INTO ssg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ape na i kum hong, kakanewa teka kahikahik liai. Na tin i kum hong teka kahikahik liai, ien, paxai tioiwa ka i masin tel i kum soh ti Haeu ma tel ti woun lialun wanen. ");
INSERT INTO ssg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nga kakane hawane amuto tesol kahikahik, waliko tenen amuto halini ti itan ie, Haeu tin i halini. Waliko tenen amuto waheni seilon aile ti itan ie, Haeu tin i waheni. ");
INSERT INTO ssg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ape nga kakane aheke amuto, na masin hua ti amuto kamei Haeu tenen na waliko hetekie namil teikawe, tel Tamak Haeu i aile hani amulu. ");
INSERT INTO ssg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ape na hua ma na tolu lato apuha hetekie nake lato kahikahik, nga kapi lato.” ");
INSERT INTO ssg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Imuh Pita nahih kamei Jises, “Tel masiwi, na tel seilon aile saun lialun hani nga, mongohun ia nga oxoxi i ti kawatan ti lialui woun? Tepanim huohu?” ");
INSERT INTO ssg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jises pahoi i ukek, “Kumahe tepanim huohu, tap tahi tilian! ");
INSERT INTO ssg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nga kaxi tenen meng haxewaiam. Aweisal ti Haeu neini seilon masin tel masiwi ti pahan waxi aliakei moniun ti teka unauan. ");
INSERT INTO ssg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Imat wanen laha ati hani i tel seilon i tua kemu moniun lalap wanen, i pon kahi tel seilon na i pupuas ti ahang kilan. ");
INSERT INTO ssg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tuahe i tap moni ti hamatean. Aile ape tel masiwi hone teka unauan, ‘Hangainiwa tel seilon ien, tel axoan ma tesol natun hetekie hatesol soxian lehe nga uke aliake moniuk.’ ");
INSERT INTO ssg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Tel unauan lokuha hani kapi aen ape kamei eliel i, ‘Tahanema nga! Atengiwa pake nga hamate hatapo monium.’ ");
INSERT INTO ssg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Tel masiwi tahane i ape hone i ukek, ‘Nga oxoxi o ti kawatan tetam. Kum hahamate moniuk.’ ");
INSERT INTO ssg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ape tel seilon ien nahih. I tunahi tel puas akatan, tel i tua kemu moniun pate kokol. Kakanua i pohi isihi kinawe tel puas akatan ape lungei i ukek, ‘Hamate hatapoa moniuk!’ ");
INSERT INTO ssg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Tel puas akatan lokuha hani kapi aen ape kamei eliel i, ‘Tahanema nga! Atengiwa pake nga hamate hatapo monium.’ ");
INSERT INTO ssg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tuahe i watakai. Kakanua i hana tel puas akatan hani he kalabus atengi tataen na i hamate hatapo moniun. ");
INSERT INTO ssg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ti teka puas akatan liai hongoa, lolaha lialu. Ape laha nahih hone tel masiwi waliko tenen i sohotuen. ");
INSERT INTO ssg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tel masiwi hongoa, i tiloi tel unauan kemuk i oxoxi ti kawatan tetan. I hone i, ‘O pate seilon lialun wanen! Nga oxoxiwen o ti kawatan tetam ape nga honewen o ka kum hahamate moniuk nake o kamei eliel nga. ");
INSERT INTO ssg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Alahan o kum tahane tel puas akatam masin ti nga tahane o?’ ");
INSERT INTO ssg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tel masiwi lon lialu hawane ape i hana tel seilon ien hani he kalabus atengi tataen i hamate hatapo moni ti i kewen.” ");
INSERT INTO ssg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ape Jises ukek, “Tel Tamak Haeu tin i aile hani amuto ukek ien na amuto kum oxoxi teka seilon liai ti kawatan ti waliko lialun laha aile hani amuto. Haeu pahan amuto aile hawanewa ti leili atemuto.” ");
INSERT INTO ssg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jises kak hatapoa ape i nahih salili Galili hani toan ti sai Judia, liai tepaun ti kan Jodan. ");
INSERT INTO ssg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kilan wanen seilon nahih kakahiti i ape i haewia teka tinun. ");
INSERT INTO ssg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Teka Parisi nahih kamei tohongi Jises, “Nakon ewi na tel wawan i lioi tel axoan ti tuahe na tenen?” ");
INSERT INTO ssg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ape Jises pahoi lato ukek, “Nakon amuto kum tioi kakain leili pepai Haeu ka ti hutuan wanen Haeu tanomi wawan hetekie hehin? ");
INSERT INTO ssg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Haeu ukek, ‘Aile ape tel wawan i salili tel taman ma tel tinan ape i hukuma hani kapi tel axoan. Ape lalu sohot hanowi seilon tel.’ ");
INSERT INTO ssg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Lalu ape kumahe hua, lalu masin seilon telawe. Waliko ti na Haeu hukumini, seilon kum seselai.” ");
INSERT INTO ssg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ape teka Parisi kamei i, “A alahan Moses kakawen ka ewi na tel wawan tai teik kakain ti sale lioiai tel axoan?” ");
INSERT INTO ssg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","I kakane lato, “Moses sowini hani amuto sale lioiai axoamuto hehin nake hanauamuto pate ailan. Tuahe ti hutuan wanen Haeu hahalini. ");
INSERT INTO ssg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nga kakane amuto, na tel wawan lioi tel axoan ti tel axoan tai aile saun lialun ti wawan hehin ape i waxi axoan tel hehin liai, tel wawan ien i ailewen saun lialun ti wawan hehin.” ");
INSERT INTO ssg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tesol kahikahin hone i, “Na sale tone hahunatun pate ailan masin ien, pamu ewian kaha kum sal!” ");
INSERT INTO ssg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jises ukek, “Kumahe hatesol seilon laha pon na laha kum sal, mewenae teka na Haeu huali laha. ");
INSERT INTO ssg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Salangawan tenen tenen teka na laha kum sal. Hina seilon laha kum sal nake soxi tinulaha ti tanomiai akaik lialun ti laha takahama. Teka laha kum sal nake seilon liai aile halialu soxi tinulaha ti tanomiai akaik. Ape teka liai laha kum sal nake laha hani hatapo laha ailei puase Haeu. Tel na i hong xeu teik kakaiak, i hong waheni.” ");
INSERT INTO ssg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lokon ien teka seilon hakahita teka akaik kokol hani Jises. Pahalaha i hanawa minan he teka akaik ti lotu hualialato. Tuahe tesol kahikahin kahiloloi teka seilon. ");
INSERT INTO ssg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ape Jises ukek, “Tiliwen teka akaik nahih hani kapik, kum talo xaaxaweni lato. Seilon teka laha sohot hanowi teka akaik ie, Haeu neini aweisalulaha ape laha natun wanen.” ");
INSERT INTO ssg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jises hana minan he teka akaik ti lotu hualialato ape i nahih salili tesol ien. ");
INSERT INTO ssg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tel seilon nahih hani kapi Jises ape i ukek, “Tel masiwi, nga aile waliko la tenen solian lehe nga uke tonain kapi Haeu ti tap tahi tapoan?” ");
INSERT INTO ssg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ape Jises kamei i ukek, “Nake lahan o kamei nga sale saun tenen solian? Na masin o kamei nga, namiloi paxaiwa nake mewenae Haeu solian ma i tioi waliko tenen solian. Na paham o uke tonain kapi Haeu ti tap tahi tapoan, hong usiwa nauna tetan.” ");
INSERT INTO ssg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","I kamea, “Nauna la?” Jises pahoi i, “Haeu ukek, ‘Kum tetelei seilon, kum ailele saun lialun ti wawan hehin, kum xuuxuina, kum kau puputini kakain. ");
INSERT INTO ssg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Hongoa kakai tamam tinam ma aile hasolia haniwa lalu ma waheniwa seilon liai hanowi ti o waheni aliake o.’” ");
INSERT INTO ssg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tel seilon uluha ukek, “Nga usi hahatapo tesol nauna ien. Ape nga aile ulea waliko la?” ");
INSERT INTO ssg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jises hone i, “Na paham Haeu namiloi ukek o seilon sawisawin wanen, nahih hangaini hatapoa soxiam ape moni haniwa teka seilon tap soxi lehe imuh o uke kahum ti tone Haeu. Ape nahih kahitima nga lehe o sohot kahikahik.” ");
INSERT INTO ssg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tel seilon uluha hongoa, i nahih alia hetekie tatahan, nake soxian pate kilan ape i watakai na i hangaini. ");
INSERT INTO ssg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jises hone tesol kahikahin, “Nga kakane hawane amuto, seilon tenen kilan soxi, pate ailan wanen ti usiai aweisal ti Haeu neneini. ");
INSERT INTO ssg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nga kakane ulei amuto, ailan wanen ti tok kamel na i soh non he tewau aweing laha axai nil ti sawitiai maia tuahe pamu ailaian ti seilon tenen kilan soxi ti usiai aweisal ti Haeu neneini.” ");
INSERT INTO ssg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ti tesol kahikahin hongoa, lato ongake hawane, lato ukek, “Lehe ape aita pon usiai aweisal ti Haeu neneini?” ");
INSERT INTO ssg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jises paxai lato ape i ukek, “Ti mewenae kui seilon i kum pon. Tuahe hetekie huhual ti Haeu, seilon pon.” ");
INSERT INTO ssg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita ukek, “Paxaiwa, amite tesol kahikahim salili hatapoen waliko ti amite ape amite kakahiti o. Kaie amite uke waliko la?” ");
INSERT INTO ssg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jises kakane lato i ukek, “Nga kaxi haxewa hani amuto, taen ti Haeu aile sohi hasolia hatapo lawe waliko, nga tel Nati Seilon nga uke tesol tonain ti neiniai seilon hetekie poh ma xewai Haeu. Ape amuto tesol kahikahik, amuto uke tesol tonain ti kolongeniai saun ti teka seilon ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ape hatesol teka laha salili tonalaha, ukalalaha, tualaha, tamalaha, tinalaha, natulaha ma na kinelaha nake laha kahikahik, laha uke pamu mongohuan, hetekie tonain kapi Haeu ti tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tuahe kilan teka axalaha lalap ti aope ie, Haeu paxai ukek laha seilon tenen tap axalaha ape seilon ti tap axalaha ti aope ie, Haeu paxai ukek laha seilon tenen axalaha lalap.” ");
INSERT INTO ssg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Aweisal ti Haeu neini seilon masin ie. Letuan tehu tel seilon nahih ngah seilon na laha puas he kinen. ");
INSERT INTO ssg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ti i tunahawa, i hone laha ka i hani laha moni kahi puasain ti ngain tehu. Ape i talo laha puas he kin. ");
INSERT INTO ssg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Sai letu tutuen i nahih hani tone apuhain ape i ningahi teka seilon tua tutu, tap puasalaha. ");
INSERT INTO ssg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","I hone lato, ‘Amuto tin nahih puas haniwa he kinek. Ape nga hani amuto moni kahi puasain ti na amuto aile.’ ");
INSERT INTO ssg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ape laha nahih puas. I nahih ulea ti lape ngain ape tehu ti al paihua teik, i aile waliko tin tetenen. ");
INSERT INTO ssg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Ti sai alohah i nahih ulea hani tone apuhain ape i ningahi hina seilon tua tutu ien. I kamei laha, ‘Alahan amuto tua tutu ie ngain hatehu, tap tenen waliko na amuto aile?’ ");
INSERT INTO ssg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Laha ukek, ‘Tap tel seilon axiwen amite puasain.’ “Ape i hone laha, ‘Na masin ien, amuto nahih puas haniwa he kinek.’ ");
INSERT INTO ssg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ti pate alohah, tel tame tesol kin hone tel unauan, ‘Tiloima teka laha pupuas ape haniwa laha kahi puasalaha. Hutuiwa teteka nga hapuasa laha tapeinan.’ ");
INSERT INTO ssg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Teka laha hutui puasain ti sai alohah nahima ape i hani laha kahi puasain ti ngain tehu. ");
INSERT INTO ssg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Teka laha hutui puasain imat nahima. Laha sokok kahulaha pamu lapan ti teka liai tuahe tin i hani laha kahi puasain ti ngain tehu. ");
INSERT INTO ssg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Laha waxiwa kahulaha ape laha lengeini tel tame tesol kin. Laha ukek, ");
INSERT INTO ssg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Teka laha nahima puas tapeinan laha puasawen teik kukunan. Amite puas eliliel ngain hatehu he kekei alon tuahe kahumite tekewe.’ ");
INSERT INTO ssg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Tel tame tesol kin kak pahoi laha, ‘Oie, kumahe nga aile puluti amuto. Puki amuto waheni nga hani amuto kahi puasain ti ngain tehu. ");
INSERT INTO ssg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ie, waxiwa kahumuto ape nahih alia haniwa tonamuto. Teka nga hapuasa tapeinan nga hani laha moni mongohun tekewe masin ti nga hani amuto nake pahak nga aile ukek ien. ");
INSERT INTO ssg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nakon lialun na nga hapuasa moniuk usi tenen ti pahak? Nakon amuto lengeini nga nake nga ongawi hani teka seilon liai ape nga hani laha pamu i akulai lapan ti namilomuto?’” ");
INSERT INTO ssg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ape Jises ukek, “Kilan teka laha namiloi ukek laha seilon pate tuah ti aope ie, Haeu namiloi ukek laha seilon pate naun. Ape teka laha namiloi ukek laha seilon pate naun, Haeu namiloi ukek laha seilon pate tuah.” ");
INSERT INTO ssg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ti Jises nahih hahaniwa Jerusalem, i kaxi hani tesol huopanim hua kahikahin waliko ti na i sohot hani i ien. I ukek, ");
INSERT INTO ssg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Hongoa! Ti na ape kako Jerusalem laha hana nga tel Nati Seilon hani mini teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses. Lato noseni teleiak. ");
INSERT INTO ssg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Lato hangaini nga hani mini teka seilon ti Rom. Laha soxeni nga, heti nga ma tahi hakea nga hani he kros ape nga mat. Tuahe muhi ngain toluhu nga xahat alia.” ");
INSERT INTO ssg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tel axoi Sebedi nahih hani kapi Jises hetekie hua natun wawan. I lokuha hani mateiwaun lehe i katei i tenen. ");
INSERT INTO ssg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jises kamei i, “Paham waliko la?” Tel hehin ukek, “Tataen o sohotua tel Masiwi ti neiniai hatesol seilon, pahak o hanawa huhua natuk ie kapim, tel tepaun manau, tel tepaun kalamau lehe lalu sohot masiwi ti neiniai seilon.” ");
INSERT INTO ssg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jises hone hua natun, “Amulu kum tioi waliko tenen amulu kakamei. Nakon amulu lang pahoi uke laman ti ape nga lang pahoi?” Lalu ukek, “Amili pon.” ");
INSERT INTO ssg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jises hone lalu, “Salan imuh amulu lang pahoi laman ti nga lang pahoi. Tuahe kumahe nga tel kilamiai seilon ti tone minak manau ma na kalamau ti neiniai seilon. Tonain ien Haeu tel Tamak hani teka i kilamiwen.” ");
INSERT INTO ssg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ti tesol huopanim kahikahin hongoa, lolato lialu hawane ti hahutalin. ");
INSERT INTO ssg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jises tiloi apuhini lato hatesol ape i ukek, “Amuto tioi ka kewi teka masiwi ti he tehu pon ie, lato neini halialu teka seilon hahitakalato ape lato lungei laha ka tua hongoa lato. ");
INSERT INTO ssg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tuahe saun tenen ien kewak i kum sosohot leilomuto. Na tel ti amuto pahan ax lalap, i sohot hawanewa tel ti hualiai seilon. ");
INSERT INTO ssg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ape na tel ti amuto pahan i sohot seilon tuah, i kewa unauamuto hatesol. ");
INSERT INTO ssg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tataen nga tel Nati Seilon, kumahe nga toma lehe seilon to unauak, nga toma unaui seilon. Ape nga mat ti ukei kahi lialui woi seilon.” ");
INSERT INTO ssg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ti Jises ma tesol kahikahin nahih saliliwa Jeriko, kilan wanen seilon kakahiti lato. ");
INSERT INTO ssg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lokon ien, hua seilon pulaxa toto pape aweisal. Lalu hong ka Jises nanahima ape lalu tilol eliel, “Tel Masiwi, tel kahi nati David, tahanema amili!” ");
INSERT INTO ssg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Teka seilon tumei hapangisu lalu. Tuahe lalu tilol eliel ahe, “Tel Masiwi, tel kahi nati David, tahanema amili!” ");
INSERT INTO ssg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jises tu hamalum ape i kamei lalu, “Pahamulu nga aile waliko la hani amulu?” ");
INSERT INTO ssg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lalu ukek, “Pahamili amili paxapax.” ");
INSERT INTO ssg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jises tahane hawane lalu ape i akeni soti pulalalu. Tataen ien wanen pulalalu ewi ape lalu nahih kahiti i. ");
INSERT INTO ssg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ti Jises ma tesol kahikahin nahih xohi haniwa Betfage, pape tehu Maunt Oliv, ti kane Jerusalem, i talo hua kahikahin imat tetan. ");
INSERT INTO ssg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ape i hone lalu, “Amulu nahih haniwa tewau toan mateiwaukako. Amulu ningahi tok donki hehin hetekie tok natun ien, xinotan. Amulu upatiwa ape hakahitama. ");
INSERT INTO ssg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na tel seilon kamei amulu kalahai amulu upati, honewa i ka tel Masiwi pahan pake i atoheni aliake koseni.” ");
INSERT INTO ssg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Waliko ien i sohot hapoponowi hawane waliko ti tel kuluiai kakai Haeu kakawen. I ukek, ");
INSERT INTO ssg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Honewa teka seilon ti Jerusalem, ‘Paxaiwa, tel Masiwi ti amuto i luluainima kumahe masin seilon ti hile, i toto patul he tok donki, tok donki uluha.’” ");
INSERT INTO ssg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Huhua kahikahin nahih aile waliko ti Jises kakak. ");
INSERT INTO ssg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Lalu hakahita tok donki hetekie tok natun. Lalu axaheni puxuaulalu he tehiti tok donki uluha ape Jises to. ");
INSERT INTO ssg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kilan wanen seilon axaheni puxuaulaha ma kai hatoh he aweisal mateiwai Jises. ");
INSERT INTO ssg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Teka seilon nanahiwa mateiwaun ma teka nanahima muhin, hatesol tilol ausini eliliel ukek, “Kako sameniwa ma amukewa tel kahi nati David, tel i nahih hehetekiema poh ma solian ti Haeu! Kako sameniwa Haeu tel pohen tapein!” ");
INSERT INTO ssg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ti Jises tahiawa Jerusalem, hatesol seilon laha wiliwilia ape laha he kamekam, “Aita tel seilon ie?” ");
INSERT INTO ssg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Teka seilon kakahiti Jises laha ukek, “Ie se Jises, tel kuluiai kakai Haeu. I ti Nasaret leili Galili.” ");
INSERT INTO ssg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Muhin Jises nahih hani mate Ingi Haeu. Kilan seilon hahangaini soxi ma manihuh ien. Hangainiai waliko ti laha pate lialun. Ti Jises ningahiwa, i usi xaxaweni laha. I aka suoteni tesol sau ti sohiai moni ma tesol sau ti teka seilon hahangaini pux. ");
INSERT INTO ssg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ape i kakane nau laha, “Kakai Haeu ukek, ‘Tehu ingak ing ti lotu.’” Jises kak tatale, “Tuahe amuto aile hanowi ka ing ti tone munai teka xuxuina!” ");
INSERT INTO ssg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tataen ien, teka pulaxa ma teka suxuxu nahih hani kapi Jises ape i haewia laha. ");
INSERT INTO ssg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tuahe teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses leng hawane ti laha ningahiwa waliko tenen i aile ti kui poh ma ti laha hongoa teka akaik tilol eliel hawane mate Ingi Haeu, “Kako sameni ma amuke tel kahi nati David!” ");
INSERT INTO ssg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Teka masiwi kamei Jises, “O hongohong waliko ti tesol akaik titilol?” Jises ukek, “Nga hongohong. Nakon amuto kum tioi waliko ti Haeu kaakane tel Natun? I ukek, ‘Taen teka akaik ma teteka pate kokol laha sameni o.’” ");
INSERT INTO ssg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ape Jises nahih salili laha ti Jerusalem. I nahih hani Betani ape i to ipong tehu ien. ");
INSERT INTO ssg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pate letu ti ngain liai telao, ti Jises ma tesol kahikahin nahih alia hahaniwa Jerusalem, i hitol. ");
INSERT INTO ssg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ape i ningahi tea pata axan fig pape aweisal. I nahih paxai na masin hina huan, tuahe tap. Mewenae kaun. Kakanua i hone tea pata, “O kum hua lian tehue!” Tataen ien wanen tea pata mat. ");
INSERT INTO ssg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tesol kahikahin paxaiwa, pate lato ongake hawane. Lato kamei i, “Tea pata mat kosea ukek ia?” ");
INSERT INTO ssg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jises ukek, “Nga kakane hawane amuto, na namilomuto xox hawane ti Haeu, tap kakapax, amuto pon ailei waliko masin ti nga aile haniwen tea pata ie. Kumahe mewenae tenen ien, tin amuto pon kakanei tehu maunten ie, ‘Hutawa tesol ien towia haniwa itax,’ ape i sohot ukek ien. ");
INSERT INTO ssg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na amuto soh hawane ti Haeu, waliko tenen tenen na amuto kamei i, i aile hani amuto.” ");
INSERT INTO ssg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ti Jises hahanau teka seilon mate Ingi Haeu, teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka masiwi liai nahih hani kapin ape kamei i, “Aita hone o ailei waliko ti o ailele? Aita sowini hani o?” ");
INSERT INTO ssg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jises ukek, “Nga kameimu amuto tenen kamekame. Na amuto pahoi hani nga, nga kaxi hani amuto tetel i sowini hani nga. ");
INSERT INTO ssg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kaxi hanima nga, aita sowini hani Jon baptaisiai seilon, Haeu ka seilon?” Ape lato kakak wasolalato, “Kaie kako kak ukek ia? Na kako ukek Haeu sowini hani Jon, i kamei kako, ‘Na masin ien, alahan amuto kum soh Jon?’ ");
INSERT INTO ssg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tuahe na kako ukek seilon sowini hani i, kaie waliko la i sohot? Kako lepetawa nake kilan seilon ukek Jon se tel kuluiai kakai Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aile ape lato hone Jises, “Amite kum tioi aita sowini hani Jon.” Jises kakane lato ukek, “Nga tin nga kum kaxi hani amuto aita hone nga ailei waliko ti nga ailele.” ");
INSERT INTO ssg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jises hone teka masiwi ti teka Ju ukek, “Hongoa, nga kaxi hani amuto tenen meng. Tel seilon ma hua natun wawan. Tel tamalalu hone tel natun pamu i ukek, ‘O nahih puas haniwa he kin tetelao!’ ");
INSERT INTO ssg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tel natun watakai tuahe imuh i towiahu namilon ape i nahih puas. ");
INSERT INTO ssg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Tel tamalalu hone ulea tel natun liai waliko tin tetenen. Tel natun ukek, ‘Ewi, nga nahih puas.’ Tuahe i tai nahih.” ");
INSERT INTO ssg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ape Jises kamei lato, “Aita tel ti lalu i hong usi kakai tel taman?” Lato ukek, “Tel pamu.” Jises ukek, “Nga kakane hawane amuto, teka seilon ti saun lialun masin teka waxiai moni hani tel masiwi ti Rom ma teka hehin laha eng akati wawan ukei moni, laha hong usi Haeu i xoini amuto. ");
INSERT INTO ssg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ti Jon Baptis kola hahani amuto aweisal sawisawin, amuto kum soh kakaian. Tuahe teka waxiai moni ma teka hehin ailei saun lialun, laha soh. Kalak amuto ningahi laha hong usi kakaian, amuto kum towiahu ti lialui woumuto hani Haeu ma amuto kum soh tetan.” ");
INSERT INTO ssg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jises ukek, “Nga kaxi ulei tenen meng liai. Tel seilon seini tesol lalape kin ape i tiehi kalini. I tahiwi tewau wal, tone pisihi waxiai kani huai pata ape i atai tehu kokole ing patul totone teka peteniai tesol kin. Ape i hani teka seilon puas ngahati tesol kin lehe tin i uke aliake hina huai pata. Ape i ku hani texux xux xauxaun. ");
INSERT INTO ssg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ti huai pata pamua, i talo teka unauan hani he kin waxiai ti tetan. ");
INSERT INTO ssg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tuahe teka ngahatiai tesol kin pohi teka unauan. Tel lato xai, tel lato telei ape tel lato hokai pot. ");
INSERT INTO ssg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tel tame tesol kin talo hakila aheke teka unauan tuahe teka ngahatiai kin aile waliko tin tetenen. ");
INSERT INTO ssg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Tapeinan i talo tel natun wanen. Namilon i ukek, ‘Tel ie natuk wanen ma lato aile aluini.’ ");
INSERT INTO ssg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ti teka ngahatiai kin ningahiwa tel natun, lato kakak alia puki lato, ‘Tel natun wanen nanahima. Kako telei i lehe tesol kin ape ti kako.’ ");
INSERT INTO ssg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Lato pohi towi xoini i hani melal ti tesol kin ape lato telei.” ");
INSERT INTO ssg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ape Jises kamei teka laha hongohong tenen mengon, “Ti tel tame kin aliawa, i aile waliko la hani teka ngahatiai kin? Amuto ukek i aile la?” ");
INSERT INTO ssg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Teka masiwi ti teka Ju ukek, “I telei tesol seilon lialun ien ape tesol kin i hani he mini teka seilon ti laha axi aliake i hina huai pata.” ");
INSERT INTO ssg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jises hone lato, “Ala amuto tioi teik kakain ie: “‘Tehu kuku teka ataiai ing hilisa, Haeu aile ape i sohot kuku tehu pamu tuah ti kuku liai. Haeu aile ape kako amuam hawane.’ ");
INSERT INTO ssg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Nga kakane hawane amuto, Haeu kum neini amuto nake amuto kum hong usi kakaian. Haeu neini teka seilon laha hong kakaian ape laha aile waliko tenen pahan. ");
INSERT INTO ssg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Teka seilon laha hong watakai kakaiak, laha tunahi kawatan ma moloan lalap.” ");
INSERT INTO ssg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka Parisi ti lato hongoa kakai Jises, lato tioi i kak nanami lato. ");
INSERT INTO ssg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lato upiup tewau aweisal ti xotian tuahe lato mamata nake kilan seilon ukek Jises se tel kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jises uke ulei tenen meng ti i kakane teka seilon. I ukek, ");
INSERT INTO ssg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Aweisal ti Haeu neini seilon masin na tel masiwi hone teka unauan apeseniai tehu angiain lalap ti salai tel natun wawan. ");
INSERT INTO ssg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","I talo tesol unauan nahih honei teka seilon i ilowiwen ti nahih haniai tehu angiain ti sala. Tuahe laha watakai. ");
INSERT INTO ssg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ape i talo ulei tesol unauan liai hetekie kakaian. Lato ukek, ‘An ti sala i apeasawen. Laha teleiwen hina bulmakau tenen xuxu solian ma lawe waliko i apeasawen. Nahih hanima tehu angiain lalap.’ ");
INSERT INTO ssg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Tuahe teka seilon ti tel masiwi ilowiwen, laha kum hong waxi kakaialato. Laha aile waliko ti pahalaha. Teka laha nahih hani he kinelaha, teka liai nahih hani puasalaha ti hangainiai soxi. ");
INSERT INTO ssg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ape teka liai akeni pohi tesol unaui tel masiwi. Laha aile halialu hawane lato ape teka laha telei. ");
INSERT INTO ssg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tel masiwi leng hawane. I talo tesol unauan ti hile teleiai teka seilon laha telei tesol unauan ape i hone lato luiai tehu taon ti laha. ");
INSERT INTO ssg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“I tiloi tesol unauan liai ape i hone lato, ‘Angiain ti sala i apeasawen, tuahe teka seilon ti nga ilolowi, laha kumahe solian ti i tapai laha to ti tehu angiain ti sala. ");
INSERT INTO ssg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Amuto nahih haniwa aweisal ti tehu taon ie ape ilowi hatapoma teka ti na amuto tunahi.’ ");
INSERT INTO ssg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tesol unauan nahih hani he aweisal ape lato ilowi hatapo seilon ti lato tunahi, teka seilon sawisawin ma teka seilon lialun. Lato hakahita hatesol hani leili ing ti sala ape tehu ing xuh hawane. ");
INSERT INTO ssg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ti tel masiwi nahih soh paxai teka seilon lato hakahitama, i ningahi tunahi tel seilon kumahe i sosoi maia tenen ti angiain ti sala. ");
INSERT INTO ssg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ape i hone i, ‘Oie, o ala kumahe ie. O tap maia tenen ti angiain ti sala.’ Tuahe tel seilon kum tunah pahoan. ");
INSERT INTO ssg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Tel masiwi hone tesol unauan, ‘Xiotiwa minan ma aen ape towi xoini haniwa i melal he tilokoan, tetesol tonain laha kau kawatan ma tangike moloan.’” ");
INSERT INTO ssg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jises kak tili kakaian, “Haeu ilowi kilan seilon lehe i neini laha tuahe teka palai Haeu kilami.” ");
INSERT INTO ssg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Teka Parisi apuha ape laha sakal aweisal lehe Jises kak tunahi waliko tenen na i sului aliake i. ");
INSERT INTO ssg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Lato talo hani kapin teka kahikahi lato ma teka tepaun ti Herod. Lato ukek, “Tel masiwi, amite tioi o seilon sawisawin. Ti o hanau seilon saun ti Haeu, kakain tenen salan. Woum o aile hani teka masiwi ma teka seilon naun lawe tekewe. ");
INSERT INTO ssg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","O namiloi ukek ia? Ewi na kako hani Sisa moni ti pahan?” ");
INSERT INTO ssg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jises tioi ka lato pisi totohongi i ape i hone lato, “Lehomuto huoka. Alahan amuto kamei pisi nga? ");
INSERT INTO ssg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kola hanima nga tehu ti tesol puli moni lawe amuto hahani Sisa.” Lato hani i tehu. ");
INSERT INTO ssg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","I kamei lato, “Kawe aita ma axe aita he tehu puli moni?” ");
INSERT INTO ssg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Lato ukek, “Ti Sisa.” Ape Jises hone lato, “Ien, waliko ti Sisa haniwa Sisa, waliko ti Haeu haniwa Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ti lato hongoa pahoan tetan, lato ong hawane ape lato nahih salili i. ");
INSERT INTO ssg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ngain tin tetehu teka Sadusi nahih hani kapi Jises. Lato soh ka seilon maten kum moih alia. ");
INSERT INTO ssg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Lato ukek, “Tel masiwi, Moses tai hanawen na masin tel wawan i mat a i tap natun, tel ukalan kewa axoan tel hehin ien lehe lalu tan natulalu ape tesol akaik nati tel i matewen. ");
INSERT INTO ssg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hongoa mengomite. Telao hatotalin lato tepanim hua. Tel pamu i sal ape i mat, tap natun. Tel ukalan usian waxi axoan tel hehin. ");
INSERT INTO ssg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tel usiai tel pamu tin i mat tap natulalu ape tel usialalu uke axoan tel hehin. Waliko tin tetenen sohot hani lato hatesol. ");
INSERT INTO ssg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tapeinan ape tel hehin mat. ");
INSERT INTO ssg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Taen Haeu xahateni hatapo seilon maten, tel hehin ape axoi aita? Nake ati lato ukewen tel hehin ien.” ");
INSERT INTO ssg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jises kak pahoi lato, “Namilomuto kumahe salan ka seilon maten kum moih alia nake amuto kum tioi kakai Haeu ma pohe Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Taen teka maten moih alia, ape tapein tenen hahunatun. Ti tone Haeu, seilon kum sal masin teka engel. ");
INSERT INTO ssg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nga kaxi haxewa hani amuto sale xahatai seilon maten. Amuto tioi waliko ti pepai Haeu kakak. I kakaxi waliko ti Haeu kakak muhin ti Abraham, Aisak ma Jekop matewa. I ukek, ");
INSERT INTO ssg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nga Haeu tetel ti Abraham, Aisak ma Jekop lolotui.’” Ape Jises ukek, “I Haeu ti teka seilon moihin nake teka seilon tetan laha matewen, laha kumahe salan maten.” ");
INSERT INTO ssg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ti teka kilai seilon hongoa kakai Jises, laha ongaini hawane sale hanauan tetan. ");
INSERT INTO ssg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ti tesol Parisi hongoa ka Jises kak hatahunosoen tesol Sadusi, lato apuha ape lato nahih hani kapin. ");
INSERT INTO ssg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Leilolato, tel ti hanaui nauna ti Moses i kamei pisi Jises. I ukek, ");
INSERT INTO ssg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tel masiwi, ti lawe nauna ti Moses lahe nauna tuah tapein?” ");
INSERT INTO ssg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jises kak pahoi i, “‘Waheni hawanewa Haeu tel Masiwi ti amuto, xoiniwa ti amuto waheni teka seilon liai. Amukewa Haeu ti leili tiamuto, namiloi eliel hawanewa i ma aile hatapoa puasan ti hatesol kuimuto.’ ");
INSERT INTO ssg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","I se nauna tenen tuah tapein i xoini lawe nauna. ");
INSERT INTO ssg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tenen nauna usian i masin, ‘Waheniwa seilon liai hanowi ti amuto waheni aliake puki amuto.’ ");
INSERT INTO ssg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Huonen nauna ien se salangawe lawe nauna ti Moses ma hatesol waliko ti teka kuluiai kakai Haeu hanauen.” ");
INSERT INTO ssg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ti tesol Parisi tutuen ien, Jises kamei lato, ");
INSERT INTO ssg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kaie amuto namiloi ukek ia? Krais, tel seilon Haeu taloma, i kahi nati aita?” Lato hone i, “Kahi nati David.” ");
INSERT INTO ssg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jises kamei lato, “Na masin ien, alahan David axai i tel Masiwi tetan? Puki Holi Spirit hanamiloa David kak kewak, ");
INSERT INTO ssg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Haeu kakane tel Masiwi tetak, toma papak tepaun manau ti neiniai seilon atengi tataen nga hanawa teka seilon laha pahoxai o hani hahitakam.’ ");
INSERT INTO ssg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na masin David axai Krais tel Masiwi tetan, i kumahe tuahe tel ti kahi natun.” ");
INSERT INTO ssg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tap tel ti lato kak pahoi uke i. Muhin ape laha mamata kamei pisiai Jises. ");
INSERT INTO ssg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Imuh Jises kakane teka kilai seilon ma tesol kahikahin, i ukek, ");
INSERT INTO ssg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Teka hanaui nauna ti Moses ma teka Parisi lato kukului puase Moses ti lato hanau seilon nauna tetan. ");
INSERT INTO ssg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tenen na lato hone amuto, amuto puas usiwa. Tuahe amuto kum puas usiusi woulato nake puki lato kum puas usi kakaialato. ");
INSERT INTO ssg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Lato lungei teka seilon usiai kilai nauna ailan ti puki ti lato, tuahe lato kum solonga ti usiai tesol nauna ien ma kum hana minalato hualiai teka liai. ");
INSERT INTO ssg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Lawe waliko lato aile se lehe seilon paxai sameni lato. Teik waliko teka Ju uke lohiai kakai Haeu ape laha xinoti he kawalaha ma huipaulaha sai kalamau, lato aile halapa. Hinaloik maia teka Ju hakea he ngixi puxuaulaha ti kolakol ka laha ailele puase Haeu, lato aile hawelu aheke lehe seilon ningahi. ");
INSERT INTO ssg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Lato waheni totoan tuah ti tone angiain lalap ma leili synagog. ");
INSERT INTO ssg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pahalato seilon namiloi kewak lato tuah ti puli lawe seilon ma pahalato seilon axaiwa lato ‘masiwi tuah.’ ");
INSERT INTO ssg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Tuahe amuto, kum hahani laha axai amuto ‘masiwi tuah’ nake amuto hatesol tekewe masin talin ma tuan. Telawe Masiwi ti amuto. ");
INSERT INTO ssg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aile ape amuto kum lolotui tel na seilon ti tehu pon ie nake ala amuto lotui tel Tamamuto Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kum hahani laha axai amuto teka neinialaha nake telawe Krais neiniai seilon. ");
INSERT INTO ssg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tel masiwi leilomuto i kewa unauamuto. ");
INSERT INTO ssg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na tel i sameni aliake i, Haeu teheni i. Ape na tel i teheni aliake i, Haeu aile i seilon tuah. ");
INSERT INTO ssg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Amuto teka hanaui nauna ti Moses ma teka Parisi, Haeu axi hawane amuto kawatan. Lehomuto huoka! Waliko ti amuto hahanau i tiehi teka seilon ti Haeu neneini laha. Puki amuto, Haeu kum neini amuto ape amuto hasele teka ti pahalaha Haeu neini laha. ");
INSERT INTO ssg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Amuto teka hanaui nauna ti Moses ma teka Parisi, Haeu axi hawane amuto kawatan. Lehomuto huoka! Amuto pisi teka hehin axoalaha matewen lehe amuto seseke soxialaha ma ingalaha. Ape amuto aile lotu weluwelun lehe teka seilon namiloi kewak amuto sawisawin. Hui tesol waliko ien, kawatan ti amuto pamu sean. ");
INSERT INTO ssg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Salan, Haeu axi hawane amuto kawatan. Lehomuto huoka! Amuto lang koti kanitax ma amuto hasunga hani kilan xux ti waxainiai seilon tel hani Haeu lehe i soh tetan hanowi ti amuto. Ti amuto waxainiwa, amuto aile tel seilon ien i sohot lialu hawane, pamu lialuan ti amuto. ");
INSERT INTO ssg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Amuto masin teka pulaxa neiniai teka seilon. Haeu axi hawane amuto kawatan. Amuto kakaxi ka na tel kak kuinakei tehu Ingi Haeu, ewi na i kum aile usi, tuahe na tel kak kuinakei teik waliko tuah leili Ingi Haeu masin gol, amuto ukek i aile usiwa. ");
INSERT INTO ssg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Amuto masin pulaxa a taxitaxia! Tenen ia pamu tuah, gol ka tehu Ingi Haeu? Pake i aile ape gol tuah. ");
INSERT INTO ssg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tin amuto hanau seilon, tap tenen na tel kak kuinakei tesol tone waliko teka seilon kau hani Haeu leili Ingan. Tuahe na i kak kuinakei waliko teka seilon kau hani Haeu, amuto ukek i aile usiwa. ");
INSERT INTO ssg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Amuto masin teka pulaxa. Tenen ia pamu tuah, waliko tenen teka seilon kau hani Haeu ka tesol tone waliko laha kau hani Haeu? Pake i aile ape teik waliko tuah. ");
INSERT INTO ssg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na amuto kak kuinakei tesol tone waliko teka seilon hani Haeu, amuto kuinake hehetekie hatesol waliko ti laha hahana ien. ");
INSERT INTO ssg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na amuto kak kuinakei tehu Ingi Haeu, amuto kuinake hehetekie Haeu, tetel i ingai tehu ing ien. ");
INSERT INTO ssg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na amuto kak kuinakei tone Haeu, amuto kuinake hehetekie Haeu ma tehu totonan. ");
INSERT INTO ssg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Amuto teka hanaui nauna ti Moses ma teka Parisi, Haeu axi hawane amuto kawatan. Lehomuto huoka! Amuto hani Haeu tenen ti huopanim soxiamuto masin kai pata ti hanamui an. Tuahe amuto kum usi tesol nauna tuah ti Moses masin ailei saun sawisawin hani seilon, tahanei seilon ma puas usiai waliko ti Haeu pahan. Solian amuto hani Haeu tenen ti huopanim soxiamuto tuahe tin amuto usi hetekiewa tesol nauna ien. ");
INSERT INTO ssg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Amuto masin teka pulaxa neiniai teka seilon. Pate amuto haeliel usiai nauna kokol masin na amuto xaxaweni lang he unumamuto uke amuto haleke, tuahe amuto kum usi nauna tuah ti Haeu. Ien masin ka amuto haleke tunahi tok pou! ");
INSERT INTO ssg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Amuto teka hanaui nauna ti Moses ma teka Parisi, Haeu axi hawane amuto kawatan. Lehomuto huoka! Pate amuto haeliel nuhiai melal ti kap ma pelet tuahe waliko ti leilon, amuto kema ti pipis ma halepelep. ");
INSERT INTO ssg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Teka Parisi, amuto masin teka pulaxa! Nuhi haunimua leilomuto. Haunimua namilomuto ma atemuto lehe waliko amuto aile ma kak mewenae solian. ");
INSERT INTO ssg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Amuto teka hanaui nauna ti Moses ma teka Parisi, Haeu axi hawane amuto kawatan. Lehomuto huoka! Amuto masin wanen amal tenen melal tetan haun ma paxaian solian, tuahe namilomuto ma atemuto masin leili amal xuhai kui seilon maten ma waliko kohan. ");
INSERT INTO ssg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Amuto woinakon ka seilon sawisawin tuahe salan wanen amuto xuhai saun lialun a amuto putini ka amuto ailele puase Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Amuto teka hanaui nauna ti Moses ma teka Parisi, Haeu axi hawane amuto kawatan. Lehomuto huoka! Amuto tanomi hasolia hahawane amali teka kuluiai kakai Haeu ma teka seilon sawisawin liai a amuto kum usi kakaialato. ");
INSERT INTO ssg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ape amuto ukek na masin amuto ien lokon ti teka tamamuto ti matahaun, amuto tai huali laha teleiai teka kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Puki kakaiamuto sului aliake amuto ka amuto kahi nati teka kuewen laha telei teka kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ien, amuto aile tinamiwa waliko tenen lialun ti teka kuewen hutuiwen. ");
INSERT INTO ssg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Amuto masin noh! Amuto kum salia ti tesol kaui kawatan tenen tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nga kakane amuto, nga talo hani amuto teka kuluiai kakai Haeu, teka seilon aneso ma teka hanaui saun ti Haeu. Amuto telei teka, amuto tahi hakea teka he kros, teka amuto heti leili synagog ape teka amuto usi haoxa hani toan tewau tewau. ");
INSERT INTO ssg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aile ape amuto uke kawatan ti teleiai teka seilon sawisawin, hutui ti teleiai Abel hani tataen ti teleiai Sakaraia tel nati Barakaia, tetel laha telei wasole Ingi Haeu ma tone waliko ti haniai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nga kaxi hawane hani amuto, kawatan ti tesol matemate ien, kauan teka seilon ti aope ie.” ");
INSERT INTO ssg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ape Jises ukek, “Teka seilon ti Jerusalem, amuto telei teka kuluiai kakai Haeu ma amuto hokai teka liai pot, teteka Haeu talo hani amuto. Mongohuan pahak nga apuhini aumi amuto masin mom hehin poni natun hahitake paun, tuahe amuto watakai. ");
INSERT INTO ssg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aile ape Haeu lioi amuto ma kum ingai tehu Ingan hetekie tehu taon kapimuto. ");
INSERT INTO ssg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nga kakane amuto, amuto kum ningahi ulea nga atengi tataen amuto ukek, ‘Kako amukewa tel i nahih hehetekiema poh ma solian ti Haeu.’” ");
INSERT INTO ssg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ti lehe Jises nahih salili tehu Ingi Haeu, tesol kahikahin kakane i sale tesol ing ti i tanomi tehu Ingi Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ape Jises ukek, “Amuto sasameni tesol ing ie. Nga kakane hawane amuto, imuh laha toi hamanana ape tesol pot ti tesol ing i put silahota.” ");
INSERT INTO ssg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ti Jises toto he tehu Maunt Oliv, tesol kahikahin nahih hani kapin ti mewenae lato. Lato kamei i, “Kaxi hanima amite lokon wanen ape waliko ien sohot? Kaie kikilam la i sohot imat ti aliaiam ma tapoi tehu pon ie?” ");
INSERT INTO ssg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jises ukek, “Kanipetiwa, kum hahani laha puluti amuto. ");
INSERT INTO ssg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Imuh kilan seilon ukek ka laha Krais. Laha puluti kilan wanen seilon. ");
INSERT INTO ssg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ti amuto hong hilehile sosohot xohixohin ma xauxaun, amuto kum maamata. Waliko masin hoi liai i sohot tuahe kumahe ape tapoi tehu pon ie. ");
INSERT INTO ssg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hilehile i sohot wasole xux, toan tewau hilei toan liai. Hitolo lalap i sohot ma hepekeun i nuea eliel ti xux tesol tesol. ");
INSERT INTO ssg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Waliko ien tuahe hutuiai kawatan ti i luluainima imuh. ");
INSERT INTO ssg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tataen ien amuto laha pohi. Laha aile lehe amuto kau moloan ma laha telei amuto. Kilan seilon ti lawe xux laha watakai hawane amuto nake amuto kahikahik. ");
INSERT INTO ssg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kilan seilon laha soh tetak laha kapaxe aliake. Laha he wawatak alia laha ma laha he hahangain alia laha. ");
INSERT INTO ssg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kilan seilon laha woinakon ka teka kuluiai kakai Haeu ape laha puluti kilan wanen seilon. ");
INSERT INTO ssg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Saun lialun kila kasia ape kilan seilon lioi saun ti wawahen. ");
INSERT INTO ssg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tuahe teka na laha tu matuha kahikahik atengi taun ti kawatan tapo, Haeu waxi auni laha lian tehue. ");
INSERT INTO ssg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ape teka kahikahik kaxi ahuti meng solian ti Haeu neini seilon hani hatesol xux. Taen ien tehu pon ie i tapo. ");
INSERT INTO ssg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Amuto hong matainiwa. Ngain tehu i luluainima amuto ningahi waliko ti Daniel tel kuluiai kakai Haeu kak kilamiwen. Amuto ningahi waliko pate lialun wanen ti seilon tanomi, i tetesol ti Haeu hahalini. ");
INSERT INTO ssg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tataen ien, teka laha toto Judia, kewak laha kiliwau muna haniwa he maunten. ");
INSERT INTO ssg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tel na i melal, tin i kiliwawa. I kum alia hahani leili ing waxiai soxian. ");
INSERT INTO ssg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tin masin na tel i he kin, liai i kum alilia hani leili ingan waxi palahiai puxuaun. Tin i kiliwawa. ");
INSERT INTO ssg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Taun tehu ien, kawatan wanen ti teka hehin tialaha hina akaik ma teka natulaha susus tutuen. ");
INSERT INTO ssg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kameiwa Haeu lehe taun ien i kum sohot leili taun ti waiwain ma na telao Sabat nake ngain tehu ien hahalin ti puasain ma kiliwain. ");
INSERT INTO ssg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kawatan ti ien i xoini kawatan ti imat, ti uli tanomiai tehu pon ie haniwa taen imuh. ");
INSERT INTO ssg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tuahe Haeu namiloi teka seilon tetan ape i koti hakukuna taun lialun ien uke tap seilon moih. ");
INSERT INTO ssg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Taun tehu ien, na tel hone amuto, ‘Paxaiwa, Krais ie,’ ma na i ukek, ‘Paxaiwa, Krais io,’ kum hong sohosoh. ");
INSERT INTO ssg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Hina seilon puputa sohotuma ukek ka laha Krais ma teka ukek laha kuluiai kakai Haeu. Laha aile hasohotu waliko lalap tenen tenen ape laha tohongi pulutiai teka seilon ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hongoa! Nga hahongo pepelei amuto waliko na i sohot. Amuto lepetawa! ");
INSERT INTO ssg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Na laha hone amuto, ‘Paxaiwa, Krais io, he lohong,’ amuto kum nanahiwa. Tin masin na laha hone amuto, ‘Krais ie, leili tehu ing,’ kum sohosoh. ");
INSERT INTO ssg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nga tel Nati Seilon sohotuak hanowi usil i xep koti maun hutuima ti angiha haniwa ahang. ");
INSERT INTO ssg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Amuto tioi xixi tetesol na amuto ningahi taliah. Tin masin amuto tioi aliaiak ape i xohiwen taen ti amuto ningahi waliko ti nga kakanewen amuto. ");
INSERT INTO ssg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Muhi kawatan ien, “‘al i kum kam, pangapang i kum xeu, kohot ti he maun i put, hatesol waliko ti he maun i nuea.’ ");
INSERT INTO ssg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tataen ien, kolakol ti aliaiak tel Nati Seilon i sohot he maun. Teka seilon ti lawe xux laha tang mamata. Ape laha ningahi nga tel Nati Seilon mosulih patul he maun hetekie lalape poh ma soliai talepai xewaiak. ");
INSERT INTO ssg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tataen ien nga talo tesol engel, spirit solian ti Haeu. Lato kuini suhusuh ape lato waxi apuhini teka seilon Haeu kilamiwen tetan ti tesol tesol, ti sai ahang, angiha, haiup ma tola. ");
INSERT INTO ssg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Amuto paxai kilami haniwa talil. Ti kaun mak put, amuto tioi ka taun ti aupol angiha. ");
INSERT INTO ssg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tin masin, taen amuto ningahi tesol waliko nga kakanewen amuto ape i sohot, amuto tioi kewak aliaiak ape i xohi hawanewen. ");
INSERT INTO ssg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nga kakane hawane amuto, hina seilon ti aope ie laha kum matemu atengi tataen waliko ien i sohot. ");
INSERT INTO ssg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Maun ma xux ti aope i tapo tamus tuahe kakaiak hamalum lian tehue. ");
INSERT INTO ssg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Tap tel tioi ngain tetehu ma lokon wanen tesol waliko ien i sohot. Teka engel, spirit solian ti Haeu, kum tioi ma puki nga tel Natun, tin nga kum tioi, mewenae tel Tamak Haeu tioi. ");
INSERT INTO ssg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Aliaiak tel Nati Seilon i hanowi lokon taun ti Noa. ");
INSERT INTO ssg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Lokon ien, imat ti Haeu hasomu mat atuhi lawe xux, teka seilon laha ang, un ma sal amuam atengi tataen ti Noa soh hani leili tea waian. ");
INSERT INTO ssg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Laha amuam luh ape laha kum tioi waliko ti lehe i sohot. Ape ti mat somule i soheni hatapo laha. Tin masin wanen aliaiak tel Nati Seilon, i haonga seilon. ");
INSERT INTO ssg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Telao ngain ien hua wawan lalu pupuas he kin ape nga tel Nati Seilon waxi tel ape tel tiliwen. ");
INSERT INTO ssg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hua hehin lalu nunuhi api. Nga waxi tel ape tel tiliwen. ");
INSERT INTO ssg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Aile ape apeas peleawa nake amuto kum tioi lokon wanen nga, tel Masiwi ti amuto, aliama. ");
INSERT INTO ssg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Amuto hong matainiwa, na masin tel tame tehu ing i tioiwen lokon tel seilon ti xuxuina nahima, ala i ah peteni lehe tel seilon kum soh hani leili ingan. ");
INSERT INTO ssg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aile ape amuto kum luhuluh nake amuto kum tioi lokon wanen nga tel Nati Seilon aliama.” ");
INSERT INTO ssg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jises kak tatale ukek, “Amuto hanowiwa tel unaui tel tame tehu ing, lawe i aile aluini puasan. Tel tame tehu ing hani tel unauan ngahatiai teka unauan liai ma axiai analaha ti taun ti angiain. ");
INSERT INTO ssg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Na tel tame tehu ing aliama ape i paxai tunahi ka tel unauan aile aluluini pupuasan, i axi aluini kahun. ");
INSERT INTO ssg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nga kakane hawane amuto, tel tame tehu ing hana i ngahatiai lawe soxian. ");
INSERT INTO ssg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tuahe na masin tel unauan seilon lialun, i namiloi ukek, ‘Pake tel tame tehu ing aliaian kuen.’ ");
INSERT INTO ssg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","I hutui xaiai teka unauan hahitakan ape i tua ang ma un kapi teka seilon ti unum. ");
INSERT INTO ssg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Imuh tel tame tehu ing alia haonga tel unauan. ");
INSERT INTO ssg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","I axi hawane tel unauan ien kawatan. I towi i hani tesol ti teka laha woinakon ka ailei puase Haeu ape i tang atalahi nisun nake ti lalape moloan.” ");
INSERT INTO ssg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jises kak ulea ukek, “Aweisal ti Haeu neini seilon masin tesol huopanim hehin uluha. Lato waxi tesol kamaialato ape lato nahih tengeni tel seilon i sal. ");
INSERT INTO ssg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tepanim, lato hina namilolato a tepanim tap namilolato. ");
INSERT INTO ssg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tesol hehin tap namilolato, lato tai kau hasea wel ti kamaialato. ");
INSERT INTO ssg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tesol tepanim liai, lato kau hasea wel kamaialato. ");
INSERT INTO ssg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tel seilon ti i sal kuen tahiaian, aile ape puli tesol hehin lihi ape lato matih. ");
INSERT INTO ssg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ti luhui ipong lato hong tel seilon titilol ukek, ‘Tel seilon i sal ape i nanahima. Amuto nahih tengeniwa i.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ien, hatesol hehin uluha lato xahat ape apeseni kamaialato. ");
INSERT INTO ssg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ape tesol hehin tap namilolato katei tesol hehin liai, lato ukek, ‘Tihi axima amite teik welaumuto nake kamaiamite ape lehe i peh.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Tuahe tesol hehin hina namilolato ukek, ‘Tap. I kum pon ti ati kamaiakako. Amuto nahih kahui ngahawa.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Taen ti lato nahiwa, tel seilon i sal tahiama. Tesol hehin lato apeasawen, lato soh akati i hani leili ing ti tehu angiain lalap ti sala. Ape teka seilon kongini aweing. ");
INSERT INTO ssg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Muhin ien tesol hehin uluha liai aliama ape lato titilol, ‘Tel masiwi, tel masiwi, hei hanima amite kahip.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Tuahe i kakane lato ukek, ‘Nga kum tioi amuto.’” ");
INSERT INTO ssg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ape Jises ukek, “Aile ape amuto pax petawa ma apeasawa nake amuto kum tioi lokon wanen aliaiak.” ");
INSERT INTO ssg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jises kak ulea ukek, “Aweisal ti Haeu neini seilon tin masin na tel seilon lehe i nahih salili tesol tonan hani tesol xauxaun. I tiloi tesol unauan ape i hani lato soxian lehe lato auni. ");
INSERT INTO ssg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","I namiloi anesoalato ti ngahatiai moni ape i sei moni hani lato. Tel i hani tepanim tomi moni, tel tom huohu, tel tom tehu. Ape i nahih. ");
INSERT INTO ssg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tel unauan i waxi tom tepanim, i hapuasa hulutini tesol moni ien ape kiliwan wanen i hasohotu tom tepanim liai. ");
INSERT INTO ssg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tel i waxi tom huohu, i hasohotu tom huohu liai. ");
INSERT INTO ssg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tuahe tel i waxi tom tehu, i tihini auni tesol moni. ");
INSERT INTO ssg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“I kuewa tel tame tesol moni i aliama. I tiloi tesol unauan lehe i upia paxai sale ngahatiai moni ti lato aunini. ");
INSERT INTO ssg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ape tel unauan i waxi tom tepanim ukek, ‘Tel masiwi, o hani nga tepanim tomi moni. Nga hapuasa ape nga hasohotuen tom tepanim liai.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Tel tame moni ukek, ‘Puasam solian. O unauak solian, o auni aluini moniuk. O ngahati aluini waliko kokol, aile ape nga hani o ngahatiai waliko pamu tuah. Amuam akatima nga.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Imuh tel unauan i waxi tom huohu ukek, ‘Tel masiwi, o hani nga huohu tomi moni. Nga hapuasa ape nga hasohotuen tom huohu liai.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Tel tame moni ukek, ‘Puasam solian. O unauak solian, o auni aluini moniuk. O ngahati aluini waliko kokol, aile ape nga hani o ngahatiai waliko pamu tuah. Amuam akatima nga.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ape tel unauan i waxi tom tehu ukek, ‘Tel masiwi, nga tioi o seilon ahian. O waxi an ti kumahe o seini. Paham o waxi moni ti seilon liai hasohotu. ");
INSERT INTO ssg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nga mamata uke nga lioi monium ape nga tihini muneni. Monium ie.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Tuahe tel tame moni ukek, ‘O seilon lialun ma nunuxa. O sokok nga seilon ahian, nga waxi an ti kumahe nga seini ma pahak nga waxi moni ti seilon liai hasohotu. ");
INSERT INTO ssg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na o namiloi ukek ien, kaie ala o hapuasawen tesol moni lehe nga uke palahi.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ape tel tame moni hone teka unauan liai, ‘Waxiwa tesol moni toi i ape haniwa tel unauak i hina huopanim tomi moni. ");
INSERT INTO ssg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tel na i aile aluini puasak, nga axi palahi waliko ti i auni ape i uke akulai kahun. Tuahe tel i kum puas alua, nga waxi aliake teik kokolean toi i. ");
INSERT INTO ssg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aile ape towiwa tel unauak puasan lialun haniwa tesol ti i tang atalahi nisun nake ti lalape moloan.’” ");
INSERT INTO ssg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jises kak ulea ukek, “Taun ti nga tel Nati Seilon alia hetekiema hatesol engel ti Haeu, nga to Masiwi ti tesol tonain neiniai seilon hetekie poh ma xewai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Seilon ti lawe xux apuha hani kapik. Ape nga sei laha uke hupaun masin tel ngahat i selai teka sipsip ti teka meme. ");
INSERT INTO ssg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nga selai teka seilon sawisawin hani minak sai manau a teka liai sai kalamau. ");
INSERT INTO ssg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ape nga hone teka seilon minak sai manau, ‘Amuto se seilon teka tel Tamak Haeu aile hasolia hani amuto. Nahima lehe Haeu neini amuto hani leili tesol tonain i apeseni haniwen amuto hutui ti tanoi tehu pon ie. ");
INSERT INTO ssg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ti nga hitol, amuto axi anak, ti pahak nga un, amuto axi unumak. Ti nga tel soliwa ti xuxumuto, amuto ilowi nga hani leili ing. ");
INSERT INTO ssg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ti nga tap sosok, amuto axi sosok. Ti nga tinun, amuto ngahati nga. Ti nga kakalabus, amuto nahih paxai nga.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ape tesol seilon sawisawin ukek, ‘Tel Masiwi, lokon amite ningahi o hitol ape amite axi anam? Lokon paham o un ape amite axi unumam? ");
INSERT INTO ssg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lokon telao amite ningahi o soliwa ape amite ilowi o hani leili ingamite? Lokon amite ningahi o tap sosom ape amite axi sosom? ");
INSERT INTO ssg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lokon amite ningahi o tinun ma na he kalabus ape amite nahih paxai o?’ ");
INSERT INTO ssg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ape nga pahoi lato ukek, ‘Nga kakane hawane amuto, waliko ti amuto aile haniwen tel na seilon, kalak na i tap wanen axan, tin masin ka amuto aile hahani nga.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ape nga hone teka sai kalamau tetak, ‘Amuto xaxaua kapik. Amuto teteka seilon amuto uke kawatan ti tel Tamak Haeu hani amuto. I towi amuto hani he tehot ah tap tahi pehoan i apeseni haniwen Satan ma teka spirit lialun tetan. ");
INSERT INTO ssg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ti nga hitol, amuto tai axi anak. Ti pahak nga un, amuto tai axi unumak. ");
INSERT INTO ssg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ti nga tel soliwa ti xuxumuto, amuto tai ilowi nga hani leili ingamuto. Ti nga tap sosok, amuto tai axi sosok. Ti nga tinun ma he kalabus amuto tai nahih paxai nga.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ape lato pahoi nga ukek, ‘Tel Masiwi, lokon wanen amite ningahi o hitol, paham kan, tel soliwa, tap sosom, tinun, he kalabus ape amite tai huali o?’ ");
INSERT INTO ssg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ape nga pahoi lato ukek, ‘Nga kakane hawane amuto, waliko ti amuto tai aile hani tel na seilon, kalak na i tap wanen axan, tin masin ka amuto tai aile hani nga.’ ");
INSERT INTO ssg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ape tel Tamak Haeu i towi lato hani tesol kaui kawatan tap tahi tapoan ape teka seilon sawisawin i waxi hani tetesol ti lato to kapin lian tehue.” ");
INSERT INTO ssg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ti Jises kak hatapoa hatesol kakaian, i hone tesol kahikahin, ");
INSERT INTO ssg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Amuto tioi ka Pasova, tehu angiain lalap ti laha telei sipsip wawan uluha, i hutui muhi ngain huohu. Tataen ien laha hangaini nga hani laha telei. Laha tahi hakea nga tel Nati Seilon hani he kros.” ");
INSERT INTO ssg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lokon ien teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka masiwi liai, laha apuha hani leili ingi Kaiapas, tel masiwi tapein ti hukuminiai Haeu ma seilon. ");
INSERT INTO ssg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Laha xinoti tanomi kakain, ti tap tel seilon tioi, sale pohiai Jises ma teleian. ");
INSERT INTO ssg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tuahe laha ukek, “Kako kum aile ti leili Pasova uke teka seilon paxaiwa ape laha hutui hile wasolalaha.” ");
INSERT INTO ssg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Lokon ien Jises Betani leili ingi Saimon, tel seilon kemuk hina nax lialun he tinun. ");
INSERT INTO ssg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ti lato to angiang, tel hehin kauma tehu sanda kahun pate lalap ma poun pate solian ape i tihi hani he pati Jises. ");
INSERT INTO ssg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ti tesol kahikahin paxaiwa, lolato lialu. Lato ukek, “Kalahai i tua tihi xoini tehu sanda? ");
INSERT INTO ssg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pamu ewian na hangaini waxiwen moni lalap ape hani teka seilon tap soxi.” ");
INSERT INTO ssg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tuahe Jises hone lato ukek, “Kum hohowini i nake i ailele saun solian hani nga. ");
INSERT INTO ssg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Teka seilon tap soxi laha lawe kapimuto, amuto pon hualialaha telao ti na pahamuto. Tuahe nga kumahe lawe kapimuto. ");
INSERT INTO ssg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","I tihi sanda hani patuk apeseniak ti tehu tihiniak. ");
INSERT INTO ssg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nga kakane hawane amuto, tesol tesol ti laha kaxi meng solian ti Haeu, tin laha kaxi waliko ti tel hehin aile hahani nga lehe seilon nameni i.” ");
INSERT INTO ssg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Imuh, tel ti tesol huopanim hua kahikahin axan Judas Iskariot, i nahih hani kapi teka masiwi tuah ti hukuminiai Haeu ma seilon. ");
INSERT INTO ssg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","I kamei lato, “Na nga hangaini Jises hani amuto, hil moni amuto hani nga?” Ape lato hani i 30 moni silva. ");
INSERT INTO ssg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Taen ien ape Judas upia tehu taun solian na i hangaini Jises hani lato. ");
INSERT INTO ssg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ngain tehu hutuiai angiain lalap ti teka Ju ani bret tenen i tai xiu, tesol kahikahi Jises nahih hani kapin ape kamei i, “Paham amite apeseni tehu angiain ti Pasova hani ia?” ");
INSERT INTO ssg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jises hone lato, “Nahih haniwa Jerusalem kapi tel seilon nga kakanewen amuto ape honewa i, ‘Tel masiwi ukek ka taun tetan ti Haeu kikilami ape i xohiwen. I ma tesol kahikahin ang tehu angiain ti Pasova leili ingam.’” ");
INSERT INTO ssg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tesol kahikahin aile usi waliko ti Jises hohone lato ape lato apeseni an ti Pasova ien. ");
INSERT INTO ssg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ti i alohahawa, Jises ma tesol huopanim huhua kahikahin to ang apuha. ");
INSERT INTO ssg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ti lato angiang, Jises ukek, “Nga kakane amuto, tel ti amuto hangaini nga hani mini teka laha watakai hawane nga.” ");
INSERT INTO ssg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ti lato hongoa, tialato kawat hawane ape tel tel ti lato kamei Jises, “Kaie kumahe nga?” ");
INSERT INTO ssg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jises kak pahoi lato ukek, “Tel na i xomi anan hani leili tehu tone an kapik, i tetel i hangaini nga. ");
INSERT INTO ssg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nga tel Nati Seilon imuh nga mat, masin ti kakai Haeu kakawen. Tuahe kawatan lalap tunahi tel seilon i hangaini nga hani laha telei. Pamu ewian na i tai takah!” ");
INSERT INTO ssg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, tel hangainian tin i kamea, “Tel masiwi, kaie kumahe o kakak nga?” Jises pahoi i ukek, “Masin ti puki o kakawen.” ");
INSERT INTO ssg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Leilon ti lato angiang, Jises waxi bret, i kak kemulik hani Haeu ape i wiki sei hani tesol kahikahin. I ukek, “Waxi aniwa, se tupuak.” ");
INSERT INTO ssg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","I waxi tehu kap waen, i kak kemulik hani Haeu ape i hani tesol kahikahin. I ukek, “Amuto hatesol unumiwa. ");
INSERT INTO ssg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ie se kakauk i xiweu ti kolakol ka Haeu oxoxi seilon ti kawatan ti lialui woulaha na laha hana namil xoxoan hani i. Mateak kola hapoponowi ka Haeu xinoti tenen namil haun kapi seilon. ");
INSERT INTO ssg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nga kakane hawane amuto, nga kum un ulea waen atengi tataen ti kako amuam leili tone Haeu tel Tamak.” ");
INSERT INTO ssg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Muhin ien lato pakui tenen pak hani Haeu ape lato nahih ahuta hani Maunt Oliv. ");
INSERT INTO ssg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jises hone lato, “Ti ipong tetehu amuto hatesol kiliwau salili nga, masin ti kakai Haeu kakawen, i ukek, “‘Nga telei tel ngahatiai sipsip ape teka sipsip kiliwau silahota!’” ");
INSERT INTO ssg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ape Jises ukek, “Tuahe muhin ti Haeu xahateni aliakewa nga ti mateak, nga nahih hani Galili imat ti amuto.” ");
INSERT INTO ssg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita hone Jises, “Nga kum ox salili wanen o, kalak na lato hatesol ox salili o.” ");
INSERT INTO ssg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jises hone Pita, “Nga kakane hawane o, imat ti tok mom wawan kokoini ipong tetehu, o putini ka o kum tioi wanen nga uke he toluhu.” ");
INSERT INTO ssg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tuahe Pita ukek, “Nga kum kak wanen ukek ien, kalak na nga mat ohoi o!” Ape hatesol kahikahin tin lato kak ukek ien. ");
INSERT INTO ssg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jises ma tesol kahikahin tahia hani tesol kin axan Getsemani. I hone lato, “Amuto tiliwen ie ti nga kakak kapi tel Tamak Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","I waxi Pita ma hua nati Sebedi, Jeims ma Jon. Tian pate i kawat ape i mamata xexex. ");
INSERT INTO ssg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","I kakane lato ukek, “Tiak pate kawatan, sikole i telei nga. Amuto tiliwen ie, ah akatima nga.” ");
INSERT INTO ssg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I nahih ahewa teik kokol ape i eng kalunga hani hepekeun. I kamei eliel Haeu ukek, “Tel Tamak Haeu, na i pon, xaxaweniwa kawatan ti matemate ti lehe i tunahi nga! Tuahe pahak nga usi namilom.” ");
INSERT INTO ssg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jises nahih alia hani kapi tolu kahikahin ape i ningahi lato mamatih. I kakane Pita, “Alahan pate amuto kum ah? ");
INSERT INTO ssg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ah kapitawa ma lotu tatalewa lehe amuto xoini totohong ti Satan na i tunahi amuto. Pahamuto ailean tuahe tupuamuto pate kawatan.” ");
INSERT INTO ssg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jises nahih ape i kakak ulea kapi tel Taman Haeu. I ukek, “Tel Tamak Haeu, na kumahe paham xaxaweniai kawatan ti matemate, nga usi namilom.” ");
INSERT INTO ssg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ti i nahih aliawa, i ningahi lato mamatih ulea. Lato kum kongini uke lihiai pulalato. ");
INSERT INTO ssg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ape he toluhu i nahih kakak kapi tel Taman. I kakak waliko tin tetenen. ");
INSERT INTO ssg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ti i nahih alia haniwa kapi tesol kahikahin i hone lato, “Amuto matih hahanau tutuen? Hongoa! Ape i meiwen taun ti nga tel Nati Seilon, laha hani he mini teka seilon lialun. ");
INSERT INTO ssg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Xahatawa! Seilon tetel hangainiak ape i nanahima. Kako nahih pahoi i.” ");
INSERT INTO ssg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jises kakak tutuen ti Judas tel ti tesol huopanim huhua kahikahin tahiawa. Kilan wanen seilon kakahiti i, laha akekeni ngol weluwelun ma pata ti hile. Teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka masiwi liai taloa laha. ");
INSERT INTO ssg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas hani peleiwen laha tenen kolakol, i ukek, “Seilon tel nga asoi taliopan se tetel ien. Amuto pohiwa!” ");
INSERT INTO ssg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas nahih sawi hani kapi Jises ape i ukek, “Tel masiwi, amuam ti Haeu hani o.” Ape i asoi taliope Jises. ");
INSERT INTO ssg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jises hone i, “Tel lohuk, aile koseniwa waliko ti lehe o aile.” Laha pohi i ape akeni kongini. ");
INSERT INTO ssg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tel ti tesol kahikahi Jises waxi tea ngol weluwelun ape i tai koti haputa taxingi tel unaui tel masiwi tapein ti hukuminiai Haeu ma seilon. ");
INSERT INTO ssg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jises hone i, “Hana aliakewa tea ngol haniwa he ingan. Seilon teka laha hil ani ngol, laha mat alia ti ngol. ");
INSERT INTO ssg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Oheak o kum tioi ka nga pon kameiai huhual ti tel Tamak Haeu ape i pon hamosu hanima nga lawalawai teka engel ti hile? ");
INSERT INTO ssg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tuahe na Haeu aile ukek ien, kakain ti kakai Haeu kaxiwen i kum sohot poponowi.” ");
INSERT INTO ssg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jises hone teka seilon, “Amuto nahih hetekiema paumuto ti hile waxiak hanowi ka nga seilon lengean. Lawe ngain nga to hahanau teka seilon leili Ingi Haeu tuahe amuto tai pohi nga lokon ien. ");
INSERT INTO ssg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tesol waliko ie i sohot hapoponowiai kakain ti teka kuluiai kakai Haeu taiwen.” Lokon ien hatesol kahikahin kiliwau salili i. ");
INSERT INTO ssg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Teka seilon laha akeni kongini Jises, laha ati i hani tehu ingi Kaiapas, tel masiwi tapein ti hukuminiai Haeu ma seilon. Teka hanaui nauna ti Moses ma teka masiwi liai hoi laha apupuha ien. ");
INSERT INTO ssg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita nahih otioti Jises tamus hani mate ingi Kaiapas. I to akati tesol peteniai Ingi Haeu. Pahan i paxai waliko tenen na i sohot hani Jises. ");
INSERT INTO ssg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kaiapas ma teka masiwi liai ti teka Ju, laha upiup teka seilon na laha aile kakain puputa ti suluiai Jises lehe waxi laha telei. ");
INSERT INTO ssg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kilan seilon laha nahima tuahe kakaialaha i kum pon suluiai Jises. Tapeinan hua seilon nahima ape lalu ukek, ");
INSERT INTO ssg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Tel seilon ie ukek ka i pon toi hamananai tehu Ingi Haeu ape hatuhi aliakean leili ngain toluhu.” ");
INSERT INTO ssg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kaiapas tua ape i hone Jises, “Huhua seilon ie susului o. Hina kakaiam?” ");
INSERT INTO ssg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tuahe Jises tai wix pahoi. Ape Kaiapas hone ulei i ukek, “O tuohawa ti puli Haeu na masin o Krais tel Nati Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jises kakane i, “Masin ti o kakawen. Nga kaxi hani amuto hatesol, imuh amuto ningahi nga tel Nati Seilon toto he tepaun min manau ti Haeu tel pohen wanen, neiniai seilon kapin ma ti nga luainima he maun.” ");
INSERT INTO ssg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ti Kaiapas hongoa, i leng lexi tehu puxuaun ape i ukek, “Kako kum ngah ulea seilon suluian. Amuto hongoen i ukek i tel Nati Haeu. ");
INSERT INTO ssg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Amuto namiloi kako aile ukek ia?” Laha pahoi ukek, “I aile hawane kakain lialun. I kak hahataehu Haeu. Pon hawane telei i.” ");
INSERT INTO ssg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ape laha pukeini kawan ma xai i. Teka uke maia talini puxui pulan, teka laha tapahi i ape ukek, ");
INSERT INTO ssg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Na o Krais, tilawa aita tel tapahi o!” ");
INSERT INTO ssg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita toto tutuen mate ingi Kaiapas ti tel hehin unaui Kaiapas nahima ape i ukek, “O tin tel kapi Jises ti Galili!” ");
INSERT INTO ssg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tuahe Pita ase he matalato hatesol, i ukek, “Nga kum tioi waliko tenen o kakak.” ");
INSERT INTO ssg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ape i nahih hani onote aweing ti melal. Tel hehin liai unaui Kaiapas ningahi i ape hone teka seilon ien, i ukek, “Tel seilon ie i tin kapi Jises ti Nasaret.” ");
INSERT INTO ssg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita ase ulea, i ukek, “Kuinake, nga kum tioi wanen tel seilon ien.” ");
INSERT INTO ssg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tai kue, teka seilon laha tutu ien nahih hani kapi Pita ape laha ukek, “Salan wanen o tel ti lato, kinaxom kaxi ka o ti Galili.” ");
INSERT INTO ssg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ape Pita ukek, “Nga tuoha hawane. Na nga puputa, Haeu axi nga kawatan. Nga kum tioi wanen tel seilon ien!” Tataen ien wanen tok mom wawan kokoini. ");
INSERT INTO ssg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ape Pita nameni kakai Jises ti i ukek, “Imat ti mom wawan kokoini, o putini ka o kum tioi wanen nga uke he toluhu.” Pita nahih salili laha ape i tang tahane hawane. ");
INSERT INTO ssg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ti pate letu wanen teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka masiwi liai ti teka Ju, lato aile ngah namil ti sale teleiai Jises. ");
INSERT INTO ssg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Lato hone teka unaualato xinotian ape laha ati i hani kapi Pailat, tel ti teka masiwi ti Rom. ");
INSERT INTO ssg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ti Judas, tel i hangaini Jises, upia tunahiwa ka teka masiwi ti teka Ju sului Jises waxi laha telei, i towiahu namilon ape i kau atoheni aliake tesol 30 moni silva hani laha. ");
INSERT INTO ssg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ape i ukek, “Nga aile hawane saun lialun nake nga hangaini tel seilon tenen tap teik waliko lialun na i ailewen ape lehe amuto telei.” Lato pahoi i ukek, “Kalahai lehe amite nam waxi? Ien soxiam.” ");
INSERT INTO ssg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas towi lioiwa tesol moni leili tehu Ingi Haeu ape i nahih hakea telei aliake i. ");
INSERT INTO ssg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tesol masiwi waxiwa tesol moni ien ape lato ukek, “Ie se moni ti i kahuiwen teleiai tel seilon. Lialun na kako hana hani kapi moni ti Ingi Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Imuh lato xinoti tenen namil ukek lato hapuasa teik moni ien kahuiai teik pekeun ti teka seilon laha tanomi salek. Tesol ien lato hani tihiniai seilon ti xux liai. ");
INSERT INTO ssg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hanima aope seilon axai teik pekeun Pekeun ti Kaka nake kahuan teik moni ti kahi teleiai seilon. ");
INSERT INTO ssg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aile ape waliko ti Jeremaia tel kuluiai kakai Haeu kakawen sale Jises i sohot poponowi. I ukek, “Laha uke tesol 30 moni silva, lapan ti teka seilon ti Israel kolongeniwen kahi teleian. ");
INSERT INTO ssg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ape laha hapuasa tesol moni ien kahuiai teik pekeun ti teka seilon laha tanomi salek, masin ti tel Masiwi honewen nga.” ");
INSERT INTO ssg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jises tutu mate Pailat ape Pailat kamei i ukek, “Nakon o se tel masiwi tapein ti teka Ju?” Ape Jises pahoi i ukek, “Se, masin ti o kakawen.” ");
INSERT INTO ssg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tuahe ti teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka masiwi liai ti teka Ju kak hohokai i, Jises tai wix pahoi. ");
INSERT INTO ssg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ape Pailat hone i ukek, “Nakon o hongohong hatesol waliko ti laha kak susului o?” ");
INSERT INTO ssg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tuahe tap tenen na Jises kakawen, aile ape Pailat pate i ongaini. ");
INSERT INTO ssg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Leili taun ti Pasova, tehu angiain lalap ti nameniai ngain ti Haeu waxi aliake teka Ju ti Igip, saun ti tel masiwi Pailat i ahuti tel ti teka kalabus, tel ti na teka seilon pahalaha. ");
INSERT INTO ssg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ti lokon ien tel seilon leili kalabus axan Barabas, axan lalap wanen ti ailei waliko lialun. ");
INSERT INTO ssg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ti teka kilai seilon apuhawa, Pailat kamei laha, “Pahamuto nga ahuti hani amuto Barabas ka Jises, tel laha ukek Krais?” ");
INSERT INTO ssg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Puki i tioi hawane ka teka masiwi ti teka Ju atoheni Jises hani kapin nake lato watakai kilan seilon sameni i. ");
INSERT INTO ssg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Lokon ti Pailat hong papaxai kakain, tel axoan hakau hani i teik kakain i ukek, “Kum aile hahalialu tel seilon ien. Tap tenen waliko lialun na i ailewen. Ipong tehu tamusuen, nga tunahi paxangongo tenen lialun wanen sale tel seilon ien.” ");
INSERT INTO ssg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tin lokon ien, teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka masiwi liai ti teka Ju hahika teka seilon kameiai Pailat ti ahutiai Barabas ma teleiai Jises. ");
INSERT INTO ssg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tuahe Pailat kamei ulei teka seilon, “Pahamuto nga ahuti hani amuto aita?” Ape laha pahoi i ukek, “Barabas!” ");
INSERT INTO ssg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat kamei laha, “Ape nga aile la hani Jises tel laha ukek Krais?” Laha hatesol pahoi i ukek, “Teleiwa i! Tahi hakeawa i he kros!” ");
INSERT INTO ssg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ape Pailat kamei laha i ukek, “Nake lahan? Waliko la lialun na i ailewen?” Tuahe laha tilol eliel hawane ukek, “Tahi hakeawa i he kros!” ");
INSERT INTO ssg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ti Pailat paxaiwa ka laha kum hong waxi i, ma tehu lape hile uke i sohot wasole teka seilon, i waxi kan ape nuhi minan he pulalaha. I ukek, “Tap teik kawatan tetak ti sale matei tel seilon ie, ien se waliko ti amuto!” ");
INSERT INTO ssg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Laha hatesol pahoi i ukek, “Hanima amite ma natumite kaui kawatan ti matean!” ");
INSERT INTO ssg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ape salan, Pailat ahuti hani laha Barabas ape i hone teka unauan hetiai Jises. Imuh i hani laha tahi hakeai Jises he kros. ");
INSERT INTO ssg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Imuh teka unaui Pailat ti hile ati Jises hani leili tehu ingi Pailat ape lato tiloi tesol tuaulato. ");
INSERT INTO ssg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Lato xaxaweni puxuaun ape puxui i tehu puxux weluwelun kakai ati polun. ");
INSERT INTO ssg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Lato alingini ngaxe au ape nihini hana hani he patun. Lato waxi teik pata ape hana hani he tepaun minan manau aile hanowi i tel masiwi. Lato lokuha hanowi ka lato lotui i. Lato ukek, “Tel masiwi tapein ti teka Ju tap tahi mateam!” ");
INSERT INTO ssg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Lato pukeini i ape waxi teik pata he minan ape lato xai patun. ");
INSERT INTO ssg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ti lato heisawa soxenian, lato naxi xaxaweni tehu puxux weluwelun ape puxui aliake i puxuaun. Lato ati i hani tesol ti lehe lato tahi hakea i hani he kros. ");
INSERT INTO ssg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ti lato nanahiwa, lato apatuini tel seilon ti Sairini axan Saimon ape teka seilon ti hile lungei i kaui teik kros ti Jises kakau. ");
INSERT INTO ssg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Lato tahia hani tesol axan Golgota. Teik kakain ien ukek, “Tetesol tanoman masin kui pati seilon.” ");
INSERT INTO ssg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ti ien lato axi unumi Jises waen tenen maxaian ti hamongai moloan. Ti i namihini laliwa ape i kum unumi. ");
INSERT INTO ssg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Lato tahi hakea i hani he teik kros pata ape lato halokeni satu ti upiai tetel i uke tetenen ia ti tesol sose Jises. ");
INSERT INTO ssg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Muhin lato to paxai peteni i. ");
INSERT INTO ssg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Teik kakain ti suluian lato tahi hahakea onote patun i kak ukek, “Ie se Jises, tel Masiwi Tapein ti teka Ju.” ");
INSERT INTO ssg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Imuh lato tahi hakea hua seilon lialun xohixohin kapi Jises, tel papan sai manau ape tel sai kalamau. ");
INSERT INTO ssg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Teka seilon ti laha nahiwa nahima laha tohutohuini patulaha ape laha kak soxeni Jises, ");
INSERT INTO ssg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“O ukek o toi hamanana tehu Ingi Haeu ape o atai aliake leili ngain toluhu! Na masin o tel Nati Haeu, huali aliakewa o ape mosulih ti he teik kros ien!” ");
INSERT INTO ssg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Teka masiwi tuah ti hukuminiai Haeu ma seilon, teka hanaui nauna ti Moses ma teka masiwi liai ti teka Ju, tin laha kak soxeni i ukek, ");
INSERT INTO ssg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“I huali seilon liai tuahe i kum pon huali aliakean! Nakon i tel masiwi tapein ti teka Israel? Na masin i mos ti he teik kros aope, kako soh tetan! ");
INSERT INTO ssg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Na masin namilon xoxoan ti Haeu ma salan ka i Natun, kako paxaimu na Haeu pahan i huali i aope!” ");
INSERT INTO ssg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Huhua lalu akeak kapi Jises, tin lalu kak soxeni i. ");
INSERT INTO ssg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ti lape ngain, hatehu xux i tilok ti leili aua toluhu. ");
INSERT INTO ssg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ti 3 kilok alohah, Jises tilol eliel hawane, “Eloi, Eloi, lama sabatani?” Teik kakain ien i ukek, “Haeu tetak, Haeu tetak, nakon lahan o lioi hawane nga?” ");
INSERT INTO ssg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Teka seilon ti laha tutu ien laha hong ape laha ukek, “I titiloi Elaija!” ");
INSERT INTO ssg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tel ti lato kiliwawa ape waxi teik maia. I xomi hani waen wangingian ape i hana hani tumi teik pata. I tulini hani he awe Jises lehe waxi i sumuxi. ");
INSERT INTO ssg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tuahe tesol liai ukek, “Nutomu, kako paxaimu na Elaija luainima hualian!” ");
INSERT INTO ssg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jises ausini eliel hawane ape i mat. ");
INSERT INTO ssg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tataen ien wanen Haeu lexi teik maia i akeak leili tehu Ingi Haeu, ti patul hani taen itan. Xux nuea ape pot lalap takel. ");
INSERT INTO ssg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Amal hea ape teka kilai seilon ti Haeu laha matewen laha xahat alia. ");
INSERT INTO ssg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Laha salili amal ape muhin ti Jises xahat aliawa ti matean, laha soh hani Jerusalem ape kilan seilon ningahi laha. ");
INSERT INTO ssg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lokon ien, tel masiwi ti teka seilon ti hile ma tesol unauan to paxai pepeteni Jises. Ti lato ningahiwa xux i nuea ma hatesol waliko ti i sosohot, lato mamata hawane ape lato ukek, “Salan wanen i Nati Haeu!” ");
INSERT INTO ssg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kilan hehin laha tu siasia papaxai waliko ti i sosohot. Lato kahitima Jises Galili ngahatian. ");
INSERT INTO ssg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Leilolato se Mary Magdalen, Mary tel tini Jeims ma Joses ma tel tini Jeims ma Jon tetel axoi Sebedi. ");
INSERT INTO ssg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ti ape alohah, Josep tel seilon kilan wanen soxi, i nahih hani kapi Pailat. I ti tehu taon axan Arimatea ma tel ti teka kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","I kamei Pailat na i waxi auni tupui Jises. Ape Pailat hone teka unauan haniai Josep tupui Jises. ");
INSERT INTO ssg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ti Josep waxiwa, i puxui talini i teik maia haun weluwelun. ");
INSERT INTO ssg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","I hana tupui Jises hani leili tehu amal, kemuk teka unauan tanomi he pot patul ti hepekeun. Muhin i hulini tehu pot lalap tiehiai tewau wal ti tesol amal ape i nahih. ");
INSERT INTO ssg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalen ma tel Mary liai, lalu toto onote tesol amal papaxai waliko ti i sosohot. ");
INSERT INTO ssg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ti ngain liai telao, tehu ngain ti Sabat, teka Parisi ma teka masiwi tuah ti hukuminiai Haeu ma seilon, lato apuha hani kapi Pailat. ");
INSERT INTO ssg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ape lato ukek, “Amite nameni ka ti lokon tel seilon ti puputa i moihin tutuen i kak ukek, ‘Nga xahat alia muhi ngain toluhu.’ ");
INSERT INTO ssg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Amite kamei o honei teka unauam ti peteni aluiniai amali Jises leili ngain toluhu, lehe teka kahikahin kum pon xuinai tupuan ape lato kum hone teka seilon ka i xahat aliawen. Tehu puputa ie i pamu lialuan, i xoini tehu imat ti i ukek i Krais.” ");
INSERT INTO ssg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat hone lato ukek, “Waxiwa teka unauak ape peteni aluini hawanewa amali Jises.” ");
INSERT INTO ssg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ape salan, lato nahih hana ngah kikilam he tehu pot lehe lato tioi na hina seilon tohongi lali laha soh. Ape teka unaui Pailat to paxai peteni. ");
INSERT INTO ssg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Muhi telao Sabat, pate letu ti Sande, Mary Magdalen ma tel Mary liai nahih paxai amali Jises. ");
INSERT INTO ssg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hepekeun i nuea eliel hahutuia hawane. Tel engel ti Haeu mosulih ape i hulini xaxaweni tehu pot laha uke siponiai amali Jises ape i to patul he tehu pot. ");
INSERT INTO ssg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kawan i xepaxep hawane hanowi usil, puxuaun papaxaxun wanen hanowi ole olawik. ");
INSERT INTO ssg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Teka peteniai amali Jises mamata xexex hawane ape lato put hani itan masin seilon tenen maten. ");
INSERT INTO ssg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tel engel hone huhua hehin, “Kum maamata. Nga tioi ka amulu paxai sasakal Jises, tel laha teleiwen. ");
INSERT INTO ssg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I ape tap ie. I xahatawen masin ti i kakawen imat. Nahima paxai tesol laha hahanopi i. ");
INSERT INTO ssg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ape nahih koseawa honei tesol kahikahin ka Haeu xahateni aliakewen i ti matean. Jises nahih imat ti amuto hani Galili ape amuto ningahi i ien. Nameniwa waliko ti nga kaakane amulu.” ");
INSERT INTO ssg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Talowian wanen lalu nahih salili amali Jises. Pate lalu mamata hetekie amuam ape lalu uke ani kikiliu honei tesol kahikahin. ");
INSERT INTO ssg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ti he aweisal, Jises sohot hahutuia hani kapi lalu ape i ukek, “Amuam lalap haniwa amulu!” Lalu kiliwau lokuha akeni aen ape lalu lotui i. ");
INSERT INTO ssg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jises hone lalu, “Kum maamata! Honewa tesol kahikahik lawak lato nahih haniwa Galili lehe lato ningahi nga ien.” ");
INSERT INTO ssg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ti hua hehin nanahiwa he aweisal, teka peteniai amal alia hani Jerusalem kakanei teka masiwi tuah ti hukuminiai Haeu ma seilon waliko ti i sosohot. ");
INSERT INTO ssg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ti lato hongoa, lato apuhini hatapo teka masiwi liai ape lato taneni apeseni kakain. Lato hani teka peteniai amali Jises moni lalap wanen. ");
INSERT INTO ssg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Lato ukek, “Amuto kaxiwa ka tesol kahikahi Jises nahima ipong ti amuto mamatih ape xuina tupuan. ");
INSERT INTO ssg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ape na Pailat hong tunahi ka kumahe amuto peteni aluluini, amite tukei awamuto.” ");
INSERT INTO ssg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Teka peteniai amali Jises waxi moni ape lato puas usi waliko ti teka masiwi kakanewen lato. Ape kakaialato i sawat hatapo hani teka Ju hanima tataen tetelao. ");
INSERT INTO ssg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tesol huopanim tel kahikahi Jises nahih hani he tehu maunten leili Galili, tetesol Jises hone lato atengian. ");
INSERT INTO ssg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ti lato ningahiwa i, lato lotui i tuahe teka ti lato kapaxe ka i Jises. ");
INSERT INTO ssg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jises xohi hani kapi lato ape i hone lato ukek, “Haeu hanawen nga Masiwi ti lawe waliko ti patul ma tehu pon ie. ");
INSERT INTO ssg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aile ape nahih haniwa lawe xux ape aile hasohotua teka seilon kahikahik. Baptaisiwa laha hahitake axe tel Tamak Haeu, nga tel Natun ma Holi Spirit. ");
INSERT INTO ssg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ape hanaua laha usi hatapoi waliko ti nga honewen amuto. Nga kakane hawane amuto, nga kapimuto lian tehue.” ");
INSERT INTO ssg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hutuiai meng solian ti Jises Krais tel Nati Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Leili pepai Aisaia, Haeu kakane tel Natun ukek, “Nga talo tel ahutiai kakaiak imat tetam ti apeseniai seilon ti sohotuam. ");
INSERT INTO ssg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","I titilol he lohong, ‘Towiahua ti lialui woumuto lehe tel Masiwi neini amuto taen i tahiama.’” ");
INSERT INTO ssg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ape salan, ti Jon Baptis tahia haniwa he lohong, i hone teka seilon nahima lehe i baptaisi laha. Teteka laha uke baptais, i kola ka laha towiahuen ti lialui woulaha hani Haeu lehe i oxoxi laha ti kawatan ti saun lialun. ");
INSERT INTO ssg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Lokon ien kilan wanen seilon ti Jerusalem ma ti Judia laha nahih hong kakai Jon. Teteka seilon laha kaxi ahuti lialui woulaha, Jon baptaisi laha leili tehu kan Jodan. ");
INSERT INTO ssg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon, soson ma puxuaun tuahe uli kamel, teik tahan tin tuahe uli manihuh a anan kukunalel ma xuni awe nini. ");
INSERT INTO ssg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","I kakane teka seilon ukek, “Tetel i luluainima muhik i pamu masiwian tetak. Masiwiaian ala i kum pon nga unauan. ");
INSERT INTO ssg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nga baptaisi amuto ani kan tuahe taen i baptaisi amuto, i hani amuto Holi Spirit ti kapitiamuto.” ");
INSERT INTO ssg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lokon ien Jises nahima Nasaret, tehu taon ti Galili ape Jon baptaisi i he tehu kan Jodan. ");
INSERT INTO ssg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ti Jises xaheale, i ningahi maun hea ape Holi Spirit mos hani kapin hanowi tok pux. ");
INSERT INTO ssg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ape tenen kinax wixima ti tone Haeu i ukek, “O se Natuk pate nga waheni, nga amuke hawane o.” ");
INSERT INTO ssg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Taen ien wanen Holi Spirit kapiti hulutini Jises hani he lohong. ");
INSERT INTO ssg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","40 ngain Jises he lohong kapi teka manihuh lengean ape Satan tohongi haputaian. Ti ien teka engel, spirit solian ti Haeu, mosulih ape ngahati i. ");
INSERT INTO ssg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Muhin ti Herod Antipas hanawa Jon leili kalabus, Jises nahih hani Galili ape i kaxi ahuti tenen meng solian ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","I ukek, “Taun ti nenein ti Haeu ape i xohiwen. Towiahua ti saun lialun ti amuto ape hong sohoa tenen meng solian ie!” ");
INSERT INTO ssg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ti Jises nanahih peixux ti Galili, i ningahi hua seilon ti tikei xixi, Saimon ma tel ukalan Andru. Lalu totowi upen puliai xixi. ");
INSERT INTO ssg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jises hone lalu, “Kahitima nga ape nga hanau amulu sale tike waxainiai seilon hani kahikahik.” ");
INSERT INTO ssg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Taen ien wanen lalu hana lioi upen ape kahiti i. ");
INSERT INTO ssg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jises tai nahih xau ape i ningahi hahutalin Jeims ma Jon, nati Sebedi. Lalu xoxoi upen leili koap. ");
INSERT INTO ssg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jises hone lalu kahitian. Lalu nahih salili tel tamalalu ma teka seilon laha pupuas ti lato ape lalu nahih usi Jises. ");
INSERT INTO ssg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jises ma tesol kahikahin nahih hani tehu taon Kapenaum. Telao Sabat, i nahih hani leili synagog, tehu ing ti apuhai teka Ju, ape i hanau teka seilon. ");
INSERT INTO ssg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ti teka seilon hongoa pate laha ongake sale kakaian nake i kumahe masin teka hanaui nauna ti Moses. Kakaian masin ka i tel pamu masiwian ti lato. ");
INSERT INTO ssg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lokon ien, tel seilon spirit lialun kapiti hahalialu, i tilol ausisini leili synagog. ");
INSERT INTO ssg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","I ukek, “Jises ti Nasaret, paham la ti amite? Nakon o ie ti halialuamite? Nga tioi o tel seilon sawisawin Haeu taloma!” ");
INSERT INTO ssg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jises tumei spirit lialun ukek, “Minginiwa awam ape ahuta xaxaua ti tel seilon ie!” ");
INSERT INTO ssg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Spirit lialun haxexe eliel tel seilon ti i ahuta ape i ausini eliel hawane. ");
INSERT INTO ssg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Teka seilon ongake hawane ape he kakak alia laha, “Nakon waliko la tetenen? Tetel seilon ie i ahuti kakain tenen haun. Kakaian masin tel seilon masiwi wanen. I tumei spirit lialun ape laha hong usi kakaian!” ");
INSERT INTO ssg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ape axe Jises i sawata leili Galili hatexux. ");
INSERT INTO ssg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ti Jises ma tesol kahikahin sohotua leili synagog, i hetekie Jeims ma Jon lato nahih sawi hani ingi Saimon ma Andru. ");
INSERT INTO ssg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tini tel axoi Saimon tinun. I engeeng he sau, tinun pate ahian. Ape laha kaxi hani Jises. ");
INSERT INTO ssg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","I nahih haniwa kapi tel hehin, i akeni minan ape xahateni. Kiliwan wanen tinun xo ewiwa ape i apeseni analato. ");
INSERT INTO ssg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ti al loloa, laha hakahita hani Jises kilan seilon tinun ma teka ti spirit lialun kapiti hahalialu. ");
INSERT INTO ssg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kilan wanen seilon ti Kapenaum apuha hanima mate ing. ");
INSERT INTO ssg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jises haewia kilan teka tinun ti nax tenen tenen ma i xaxaweni kilan spirit lialun leili teka seilon. Teka spirit lialun tioi ka Jises se Nati Haeu, aile ape i halini na lato kaxi. ");
INSERT INTO ssg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pate letu ti teik tilokoan tutuen, Jises xahat nahih ahuta ti taon hani tesol ti tap seilon ape i kakak kapi tel Taman Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon ma tesol tuaun nahih upia i. ");
INSERT INTO ssg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ti lato tunahiwa, lato ukek, “Lawe seilon upiup o!” ");
INSERT INTO ssg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jises kak pahoi lato ukek, “Kako tin hina kane toan liai lehe nga kaxi ulei meng solian ti Haeu. Pake nga ie ti ailei teik puasain ien.” ");
INSERT INTO ssg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ape Jises nahih kakalini Galili ti kaxi ahutiai kakai Haeu leili synagog ma i xaxaweni spirit lialun leili kilan seilon. ");
INSERT INTO ssg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Telao tel seilon hina nax lialun he tinun nahih hani kapi Jises ape i lokuha hani kapi aen. I kamei eliel Jises ukek, “Na o waheni, xaxaweniwa naxe tinuk lehe nga hau alia!” ");
INSERT INTO ssg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jises xuhai tatahan. I tulini aka soti tel seilon ape i ukek, “Nga waheni, ewiwa ma haua!” ");
INSERT INTO ssg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kiliwan wanen naxe tinun tapo ape i ewi. ");
INSERT INTO ssg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jises kakane eliel i ukek, ");
INSERT INTO ssg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kum kaxi hahani teka seilon liai. Nahih sawi haniwa kapi tel masiwi ti hukuminiai Haeu ma seilon lehe i paxai kalisi tinum. Kau hetekiewa huok manixux ti haniai Haeu masin ti Moses kakawen. Ien kola haniai teka seilon ka o ewiwen ape pon o hukuma hani kapi laha.” ");
INSERT INTO ssg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tuahe ti tel seilon nahiwa, i kaxi sawateni ka tinun ape i ewiwen. Aile ape Jises kum nahih hani taon ti leili seilon kilan. I tua nanahih melal ti taon tuahe seilon nahih tatale hani kapin. ");
INSERT INTO ssg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ngain hina tamusua ape Jises alia hani Kapenaum. Kakain sawata ka Jises tahia aliawen. ");
INSERT INTO ssg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kilan seilon apupuha tehu ing ti Jises heheuta. Leili ing ma melal kilan wanen seilon. ");
INSERT INTO ssg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ti Jises kakaxi kakai Haeu hani laha, hinalo seilon tahia haniwa ien. Lato kakau tel seilon tupuan maten. ");
INSERT INTO ssg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lato kum tapauake uke i hani kapi Jises nake pate kilan seilon. Lato haneke i hani hongin onotan ti Jises tutu. Lato hawawai ape halahe i hetekie enepan hani kapi Jises. ");
INSERT INTO ssg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ti Jises ningahiwa xoxoi namilolato, i hone tel tinun, “Tel natuk, nga oxoxi o ti kawatan ti saun lialun ti o ailewen.” ");
INSERT INTO ssg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Leili teka seilon ien hina teka hanaui nauna ti Moses. Lato kakak alia puki lato, ");
INSERT INTO ssg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kalahai i kak ukek? I kak hanowi i Haeu! Aita pon oxoxiakako ti kawatan ti saun lialun? Mewenae Haeu!” ");
INSERT INTO ssg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jises tioi namilolato ape i hone lato, “Nakon lahan amuto namiloi namil tenen ien? ");
INSERT INTO ssg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tetenen ia pamu malimuan? Nakon pamu malimun na nga hone tel seilon tupuan maten, ‘Xahatawa ape nahiwa,’ ka ‘Nga oxoxi o ti kawatan ti lialui woum’? Ti ailei hahuonen, mewenae seilon ti hina pohe Haeu i pon ailean. ");
INSERT INTO ssg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nga aile kola lehe amuto tioi ka nga tel Nati Seilon, he tehu pon ie nga hina poh oxoxiai seilon ti kawatan ti saun lialun ti laha.” Ape i hone tel seilon tupuan maten, ");
INSERT INTO ssg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nga hone hawane o, xahatawa, waxiwa enepam ape nahih haniwa tonam.” ");
INSERT INTO ssg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ti puli lawe seilon i xahat, i waxi enepan ape i nahih. Laha paxai ongake hawane ape laha ukek, “Amite tai niningah waliko tetenen i sohot ukek!” Ape laha kak kemulik hani Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Liai telao ulea Jises tau nanahih peixux ti kanitax Galili. Kilan seilon nahih hani kapin ape i hanau laha kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ti i nanahih i ningahi Matiu Livai, tel nati Alapeus, i to wawaxi moni ti teka seilon. Pupuasan waxiai moni ti teka Ju hani teka masiwi ti Rom. Jises hone i ukek, “Kahitima nga! Pahak o kahikahik.” Livai tule ape kahiti i. ");
INSERT INTO ssg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Imuh Jises to angiang kapi Livai leili ingan. Kilan seilon pupuasalaha masin puase Livai, hetekie teka seilon woulaha lialun, laha angiang kapi Jises ma tesol kahikahin. Kilan seilon tenen tenen kakahiti Jises lawe ngain. ");
INSERT INTO ssg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ti teteka Parisi hanaui nauna ti Moses, ningahiwa Jises angiang kapi teka woulaha lialun, lato hone tesol kahikahin, “Kalahai i ang akati seilon tetenen?” ");
INSERT INTO ssg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jises hong lato kakak ape i ukek, “Dokta kum puasake seilon huliwi, mewenae teka tinun. Kumahe ka nga he tehu pon ie upiai kahikahik seilon tenen laha sokok laha sawisawin. Nga tahiama upiai kahikahik seilon tenen laha tioi ka woulaha lialun.” ");
INSERT INTO ssg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Hina ngain taun ti tesol kahikahi Jon Baptis ma tesol Parisi halini an ti hualiai lotu ti lato. Teka seilon nahih hani kapi Jises ape kamei i, “Nakon lahan tesol kahikahim lato kum halini an ti hualiai lotu ti lato hanowi tesol kahikahi Jon Baptis ma tesol kahikahi teka Parisi?” ");
INSERT INTO ssg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jises kak pahoi lato ukek, “Na tel seilon i sal i kapi tesol seilon ti laha ilowi ti angiain ti salasala, kaie lato kum ang? Kumahe! Lato ang akati i. ");
INSERT INTO ssg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tuahe ngain tehu i luluainima, laha waxi xaxaweni tel seilon i sal ti lato. Tataen ien lato halini an. ");
INSERT INTO ssg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Tap tel ukeke teik maia haun paxatawaiai teik maia wasan. Na i aile ukek ien, teteik haun i lexi teik wasan ape wawan i lap ahe. ");
INSERT INTO ssg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Seilon kum lohi hahakila patula wel hani tehu po wasan nake na i lauti, tehu po i watat ape patula tapulol. Pamu ewian na i lohi hani he tehu po haun lehe ati lalu kum lialu.” ");
INSERT INTO ssg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Telao ngain Sabat Jises nahih kokotiwa tesol kini kon hetekie tesol kahikahin. Ape tesol kahikahin asahi ani huai kon. ");
INSERT INTO ssg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tesol Parisi kakane Jises, “Paxaiwa! Nakon lahan lato aile saun tenen hahalin ti telao ngain Sabat?” ");
INSERT INTO ssg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jises kak pahoi lato ukek, “Amuto se teka hanaui kakai Haeu. Ala amuto tioi waliko ti tel masiwi David ma tesol seilon hahitakan aile ti pate lato hitol. ");
INSERT INTO ssg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Lokon ti Abiata tel masiwi tapein ti hukuminiai Haeu ma seilon, David nahih soh hani Ingi Haeu ape i waxi bret, kalak hahalin. Ape i ma teka kapin lato ani.” ");
INSERT INTO ssg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jises kakane lato ukek, “Haeu tanomi Sabat ti hualiakaha seilon, kumahe i tanomi kaha seilon hualiai Sabat. ");
INSERT INTO ssg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ape nga tel Nati Seilon, nga se Masiwi ti Sabat. Nga tel sowini haniai seilon waliko tenen i pon ma na i kum pon laha aile telao ngain Sabat.” ");
INSERT INTO ssg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Telao Sabat Jises nahih alia hani leili synagog ape i ningahi tel seilon minan maten. ");
INSERT INTO ssg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hina seilon ien laha sasakal aweisal ti suluiai Jises. Aile ape laha paxai otioti na i aile haewia tel seilon lehe laha sului i ti ailei saun tenen hahalin telao Sabat. ");
INSERT INTO ssg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jises hone tel seilon ukek, “Nahih hanima mateiwa!” ");
INSERT INTO ssg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ape i kamei teka seilon, “Nakon saun la ewi na kako aile telao Sabat? Saun ti hasoliai seilon ka halialualaha? Saun ti hualiai seilon ka hamangealaha?” Tuahe laha tai wix pahoi i. ");
INSERT INTO ssg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jises pax kakalini laha ape lon lialu hawane nake laha kum tahane tel seilon. Ape Jises hone i ukek, “Hokahiwa minam!” I hokahiwa tepaun minan ape i ewi. ");
INSERT INTO ssg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tesol Parisi nahih sohot ti synagog ape nahih apuha hani kapi tesol tepaun ti Herod. Lato aile namil ti sale teleiai Jises. ");
INSERT INTO ssg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jises ma tesol kahikahin nahih salili teka seilon lehe lato nahih hani kanitax Galili. Kilan seilon kahitiwa lato. ");
INSERT INTO ssg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ti laha hongoa waliko tenen kuin ti i ailele, kilan ti laha nahih hani kapin. Laha ti Galili, Judia, Jerusalem, Idumea, pape kan Jodan sai liai tepaun ma kakalini toan ti Taia ma Saidon. ");
INSERT INTO ssg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Seilon pate kilan kasia, aile ape Jises hone tesol kahikahin apeseniai tea koap lehe seilon kum tu pisipis hani kapin. ");
INSERT INTO ssg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","I haewia kilan seilon, aile ape teka seilon tinun nahih tatale hani kapin. Pahalaha wanen laha soti i. ");
INSERT INTO ssg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lawe seilon ti spirit lialun kapiti hahalialu, laha ningahiwa Jises, laha put hani mateiwaun ape tilol ausisini ukek, “O se tel Nati Haeu!” ");
INSERT INTO ssg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tuahe Jises halini laha ti kaxi haniai teka seilon liai ka i tel Nati Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Imuh Jises han hani he tehu maunten ape i tiloi teka seilon lehe i kilami teteka ti pahan. Ape laha hatesol nahih hani kapin. ");
INSERT INTO ssg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","I kilami huopanim hua aposel, tetesol lato lawe kapin. I hone lato ukek, “Nga kilami amuto hamalum kapitama kapik. Tin nga talo amuto kaxi ahutiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ape nga hani amuto poh ti xaxaweniai spirit lialun.” ");
INSERT INTO ssg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Teteka i kilami se Saimon, tetel Jises axai axan Pita, ");
INSERT INTO ssg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jeims ma tel ukalan Jon, lalu nati Sebedi (Jises axai lalu Seilon ti kuhuh), ");
INSERT INTO ssg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Pilip, Batolomiu, Matiu, Tomas, Jeims tel nati Alapeus, Tadeus, Saimon tenen axan liai Selot, ");
INSERT INTO ssg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iskariot, tetel seilon imuh i hangaini Jises hani laha telei. ");
INSERT INTO ssg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ti Jises nahih alia haniwa tehu ing ti i heheuta, kilan seilon apuha uleawa ape Jises ma tesol kahikahin kum ang uke. ");
INSERT INTO ssg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ti tesol akiki Jises wanen hongoa, lato nahih upia i nake lato sokok ka i taxitaxiawen. ");
INSERT INTO ssg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Teka hanaui nauna ti Moses nahima ti Jerusalem lato ukek, “Jises spirit lialun kapiti halialuawen! Satan axi i poh ti xaxaweniai spirit lialun.” ");
INSERT INTO ssg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jises tiloi lato hani kapin ape i kakane lato, “Satan i xaxaweni ukek ia Satan?” Ape i kak kolongeni hani lato i ukek, ");
INSERT INTO ssg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Na seilon ti xux texux laha tikela ape hil alia puki laha, texux xux ien i lialu tamus. ");
INSERT INTO ssg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na tesol akikin lato hil alia puki lato, tesol akikin ien lato kum tu xox. ");
INSERT INTO ssg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na Satan hilei aliake Satan, nenein tetan tapo tamus. ");
INSERT INTO ssg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Satan masin tel seilon kuin. Tap tel seilon soh uke hani ingi tel seilon kuin ape waxi waliko ti leili ing, halik na i xioti konginimu tel seilon kuin. Mewenae na i pamu kuiaian, i pon xoiniai tel seilon kuin. Se tin masin nga xoini Satan ape nga xaxaweni spirit lialun tetan leili teka seilon. ");
INSERT INTO ssg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nga kakane amuto waliko salan. Haeu i oxoxi seilon ti kawatan ti hatesol lialui woulaha hetekie ti na tel seilon kak halialu tel liai. ");
INSERT INTO ssg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tuahe na tel i kak halialu Holi Spirit, tap wanen Haeu po oxoxi i ti kawatan ien nake i aile saun lialun ti kawatan tetan tap tahi tapoan.” ");
INSERT INTO ssg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jises kak ukek ien nake teka seilon kakaxi ka spirit lialun kapiti hahalialu i. ");
INSERT INTO ssg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Muhin ien tel tinan ma tesol ukalan tahia hani tehu ing ti Jises hahanau teka seilon. Lato tua tutu melal ape hakouta hani i kakain. ");
INSERT INTO ssg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kilan seilon to kakalini Jises ape tel ti laha hone i, “Paxaiwa, tel tinam ma tesol ukalam atetengi o melal.” ");
INSERT INTO ssg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jises kak ukek, “Aita wanen tel tinak? Aita wanen tesol ukalak?” ");
INSERT INTO ssg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I paxai teka seilon kapin ape i ukek, “Teka seilon ie se tinak ma ukalak. ");
INSERT INTO ssg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Hatesol teka na laha aile usi waliko ti Haeu pahan, laha se ukalak, tuak ma tinak.” ");
INSERT INTO ssg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Liai telao Jises kak hahanau teka seilon pape kanitax Galili. Pate kilan seilon apuha kakalini i, aile ape i ku to hani he tea koap. Teka seilon tutu peixux. ");
INSERT INTO ssg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jises hapuasa meng ti i hanau waliko kilan. I kakane laha ukek, ");
INSERT INTO ssg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Hongoa! Tel seilon ti ailei kin i nahih seini waki maia. ");
INSERT INTO ssg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ti i totowi waki maia, hina i put hani he aweisal ape manixux ngong ani. ");
INSERT INTO ssg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hina i put hani he kalamael, tesol ti hepekeun pakepaken. Waki maia i xex. ");
INSERT INTO ssg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tuahe ti alon kekelih, i mani telei tesol supuli maia nake wahan pate pakepaken. ");
INSERT INTO ssg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hina waki maia i put hani leili au. Ti i xexele, au talini ape i kum hua. ");
INSERT INTO ssg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tuahe waki maia liai i put hani hepekeun solian. I xex ape hua palahi 30, hina palahi 60 ma teka palahi 100 akulaiwen ti tel seilon seini.” ");
INSERT INTO ssg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jises ukek, “Na amuto hina taxing ti hongoi kakain, hongoa.” ");
INSERT INTO ssg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ti ape mewenae Jises, tesol huopanim huhua kahikahin ma teka liai kamei i salangawe tenen meng i kakaxi. ");
INSERT INTO ssg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","I kakane lato ukek, “Pahak nga kaxi haxewa hani amuto waliko tenen amuto kum xeu sale nenein ti Haeu, tuahe teka laha kum soh ti Haeu, nga hapuasa meng ti nga hahanau laha ape laha kum hong tioi aluini. ");
INSERT INTO ssg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Masin ti leili pepai Aisaia i ukek, “‘Laha papaxai he tange pulalaha waliko ti Haeu ailele tuahe laha kum ningahi, laha hongohong kakai Haeu tuahe laha kum xeu. Na masin ala laha hong tioila kakai Haeu, laha towiahu haniwen i ape i oxoxiwen laha ti kawatan ti lialui woulaha.’” ");
INSERT INTO ssg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jises kakane tesol kahikahin ukek, “Na amuto kum xeu ti tenen menge hepekeun, tin amuto kum xeu ti meng liai. ");
INSERT INTO ssg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tel seilon seiniai waki maia i tu kikilami tel kaxiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Seilon hina masin aweisal ti waki maia put to, laha hong kakai Haeu tuahe malimun wanen na Satan xaxaweni kakain ien ti leilolaha. ");
INSERT INTO ssg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kalamael ti waki maia put to, i kikilami teka seilon laha hongoa kakai Haeu ape pate laha amuke. ");
INSERT INTO ssg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tuahe i kum wahai aluini ape i kum xex kue. Taen kawatan ma totohong tunahiwa laha ti usiai kakai Haeu, xoxoi namilolaha ti Haeu pate i put kosea. ");
INSERT INTO ssg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Teteka seilon laha masin hepekeun ti hina au waki maia put hani leilon, laha hong kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tuahe laha namiloi kasini waliko ti itan ie. Pahalaha soxialaha kilan ma laha nahaini waliko ti seilon liai. Namil tenen ien kokongini kakai Haeu ape laha kum hua. ");
INSERT INTO ssg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tuahe teka liai masin hepekeun solian. Laha hong auni kakai Haeu ape laha hua. Teka laha hua 30, teka 60 ma teka liai 100 akulaiwen ti uli seinian.” ");
INSERT INTO ssg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ape Jises kamei tesol kahikahin ukek, “Na amuto hakama tehu kamaiamuto, kaie amuto hana hahitake po ma na sau? Kumahe, amuto hakea hani patul koukean lehe i haxewa leili ing. ");
INSERT INTO ssg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Waliko ti i mumuna aope, i kouke. Waliko tenen amuto kum xeu ti kakai Haeu aope ie, Haeu haxewa hani amuto imuh. ");
INSERT INTO ssg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Na amuto hina taxing ti hongoi kakain, hongoa!” ");
INSERT INTO ssg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jises hone lato ukek, “Kakain ti amuto hongohong, hong matainiwa lehe amuto xeu! Saun ti amuto aile hani seilon liai, tin Haeu hani aliake amuto tuahe tetan pamu sean. ");
INSERT INTO ssg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Na tel seilon i hong usi kakaiak, Haeu axi aheke anesoan tuahe na tel seilon kum hong usi kakaiak, anesoan Haeu waxi aliake.” ");
INSERT INTO ssg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jises kak ulea ukek, “Nenein ti Haeu masin ti tel seilon i seini waki komem leili kin. ");
INSERT INTO ssg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kalak tel seilon kum tioi i sohot ukek ia, supuli komem i xex ipong ma ngain, ti tel seilon mamatih ma na i tau nanahih. ");
INSERT INTO ssg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hepekeun haxexe waki komem ma hahua. Imat i supulamu, imuh i tan kaun ma huan. ");
INSERT INTO ssg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tataen huai komem pamua, tel tame tesol kin uke ngol kotian nake an he kin i apeasawen.” ");
INSERT INTO ssg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jises ukek, “Nga kak kolongeni haxewa hani amuto sale nenein ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ien masin tehu kokole waki lilieu tel seilon seini. ");
INSERT INTO ssg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kalak i pate kokol, i xex lap ape i sohot tea pata lapalap wanen. Ngaxon lap hawane ape manixux atai ingalaha ien.” ");
INSERT INTO ssg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kilan meng Jises hapuasa hanaui seilon. I kak kolongeni kakai Haeu hani tenen ti lehe seilon hong tioi kakaian. ");
INSERT INTO ssg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ti i kaxi kakai Haeu hani seilon liai, lawe i hapuasa meng, tuahe taen mewenae i ma tesol kahikahin, i kaxi haxewa hawane hani lato. ");
INSERT INTO ssg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Alohah telao ien Jises hone tesol kahikahin ukek, “Kako lang hani pape kanitax liai tepaun.” ");
INSERT INTO ssg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tesol kahikahin ku haniwa he tea koap ti Jises toto ape lato lang salili teka kilai seilon apupuha. Tin hina koap liai ien. ");
INSERT INTO ssg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tai kue ahon tunahi lato. Aupol kuin ma laman lalap tenen i hu mamatit, hin i matit hani leili koap. Sikole wanen lato kaxox. ");
INSERT INTO ssg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jises matih lululung he teik lulungan muhiwai tea koap. Kakanua lato hangoni i ape lato ukek, “Tel masiwi, nakon o kum nam waxi na kako kaxox ape kako mat?” ");
INSERT INTO ssg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jises tule i kakane aupol, “Mongawa!” Ape i kakane laman, “Hamalumua!” Aupol mat ape i tuxi. ");
INSERT INTO ssg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jises hone lato ukek, “Alahan ka amuto mamata? Nakon amuto tap namil xoxoan tetak?” ");
INSERT INTO ssg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pate lato mamata ape lato he kamekam alia puki lato, “Seilon tenen lahan ka aupol ma laman hong usi kakaian?” ");
INSERT INTO ssg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jises ma tesol kahikahin tahia hani liai tepaun ti kanitax Galili, xux ti teka Gerasa. ");
INSERT INTO ssg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ti Jises mosua he tea koap, tel seilon sohotuma he amal ape kiliwau pahoi i. Tel seilon ien spirit lialun kapiti halialua. ");
INSERT INTO ssg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tonan leili amal. Tap tel pon xioti konginian. ");
INSERT INTO ssg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Laha xioti hakilawen minan ma aen. Laha uke sen tuahe lawe i xaputi. I pate kuin wanen, tap tel kongini uke i. ");
INSERT INTO ssg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ngain ma ipong i nahih lolilolia he amal tilol ausisini ma i uke hat tahai hanaxo lalolal tinun. ");
INSERT INTO ssg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ti i xauxaun tutuen, i ningahi Jises ape i kiliwau lokuha hani itan kapi aen. ");
INSERT INTO ssg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tel spirit lialun tilol eliel ukek, “Jises, tel Nati Haeu pate tuah! Lehe o aile la hani nga? Nga kamei hawane o ti puli Haeu, o kum aile hahalialu nga!” ");
INSERT INTO ssg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","I kak ukek nake imat Jises honemu i, “Ahutawa ti tel seilon ien!” ");
INSERT INTO ssg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jises kamei i, “Axam la?” I pahoi ukek, “Axak Kilan nake amite pate kilan.” ");
INSERT INTO ssg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ape spirit lialun leili tel seilon kamei talingoi Jises, “Kum usi xaaxaweni amite!” ");
INSERT INTO ssg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tesol kilai pou exiex ngixi maunten xohixohin tewau toan ien. ");
INSERT INTO ssg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tesol spirit lialun kamei eliel Jises, “Talo haniwa amite leili tesol pou!” ");
INSERT INTO ssg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jises sowini hani lato. Tesol spirit lialun ahuta ti leili tel seilon ape lato soh hani leili tesol pou. Mongohe tesol pou 2,000. Lato kiliwau hanahi hani he sahikek, lato put hani itax ape lato waut mat. ");
INSERT INTO ssg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tesol ngahatiai pou kiliwau kaxi hani teka seilon leili taon ma tesol tesol. Ti teka seilon hongoa, laha nahih paxai waliko ti i sosohot. ");
INSERT INTO ssg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ti laha nahih haniwa kapi Jises, laha ningahi tel seilon kemuk kilan spirit lialun kapiti hahalialu. I hina puxux ma namilon tin ape solian. Ape laha mamata. ");
INSERT INTO ssg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tesol seilon lato ningahiwen waliko ien, lato kaxi hani laha waliko ti i sohot haniwen tel seilon ma tesol pou. ");
INSERT INTO ssg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ti laha hongoa, laha kamei eliel Jises na masin i lua salili tonalaha. ");
INSERT INTO ssg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ti Jises ku haniwa he tea koap, tel seilon kemuk spirit lialun kapiti hahalialu, kamea eliliel na i kahiti Jises. ");
INSERT INTO ssg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jises ukek, “Kumahe, alia haniwa tonam kapi tesol akikim ape kaxiwa waliko solian tel Masiwi aile haniwen o nake ti lalape tatahan tetan.” ");
INSERT INTO ssg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ape salan, i nahih hani tesol huopanim taon axalato Dekapolis. I kaxi hani laha waliko ti Jises aile haniwen i. Laha hatesol ongake hawane. ");
INSERT INTO ssg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Muhin ien, Jises lang alia hani liai tepaun ti kanitax Galili. Kilan wanen seilon apuha kalini i peixux. ");
INSERT INTO ssg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Lokon ien Jairus tahiama. I tel ti tesol masiwi ti synagog. Ti i ningahiwa Jises, i lokuha hani itan kapi aen. ");
INSERT INTO ssg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","I kamei eliel Jises, “Tel natuk hehin pate tinun sikole i mat. O nati kahitima nga ape hanawa minam patul tetan lehe i ewi!” ");
INSERT INTO ssg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ape salan, Jises nahih kahiti Jairus. Kilan wanen seilon nahih pisipis kapin. ");
INSERT INTO ssg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Leili teka seilon ien, tel hehin hina nax ti sale tapunaun leili ahang huopanim huohu. ");
INSERT INTO ssg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","I paxaiwen kilan dokta. Moniun tua tapo ti ukei huhual tuahe i to lialu tatalewa. ");
INSERT INTO ssg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ti tel hehin hongoa ka Jises nahih tamusuen, i nahih usiwa muhin ape ti leili teka seilon i akeni soti puxuaun. ");
INSERT INTO ssg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","I aile ukek ien nake xoxoi namilon i ukek, “Kalak nga tua soti puxui Jises, tinuk i ewi.” ");
INSERT INTO ssg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ape salan, kiliwan wanen naxe tinun i tapo ape i ilameni ka leili tinun ewiwen. ");
INSERT INTO ssg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Taen ien Jises ilameni ka pohen i puasawen. I toheawa ape i kamei teka seilon, “Aita tel i soti puxuauk?” ");
INSERT INTO ssg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tesol kahikahin kakane i, “O ningahi ka seilon pate laha pisipis, nake lahan o kamea tetel i soti o?” ");
INSERT INTO ssg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tuahe Jises pax upiup tutuen tel i soti puxuaun. ");
INSERT INTO ssg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tel hehin ilameni tioi i ewiwen ape i mamata xexex lokuha hani itan kapi ae Jises. I kaxi waliko tenen i sohot haniwen i. ");
INSERT INTO ssg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jises kakane i ukek, “Tel natuk, xoxoi namilom tetak i aile tinum ewi. Nahih hetekiewa amuam he tiam. Naxe tinum ape i tapoen.” ");
INSERT INTO ssg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Leilon ti Jises kakak, teka seilon leili ingi Jairus hakauma kakain hani Jairus ukek, “Tel natum i matewen, kum hakalakala nanahiai tel masiwi.” ");
INSERT INTO ssg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kalak Jises hongoen waliko ti lato kakak, i hone Jairus, “Kum namiloi hahalapa, o kewa hina namil xoxoan tetak.” ");
INSERT INTO ssg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jises hone teka seilon ka laha kum kakahiti i ape i hakahita mewenae Pita, Jeims ma tel ukalan Jon, tesol kahikahin. ");
INSERT INTO ssg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ti lato tahia haniwa ingi Jairus, lato hong seilon tangitang “nieilit,” teka laha tang ausisini. ");
INSERT INTO ssg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jises soh haniwa leili ing ape i hone laha, “Alahan pate amuto tang ausisini? Tel akaik kumahe maten, i tua mamatih.” ");
INSERT INTO ssg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tuahe laha mal soxeni i. Jises talo hasohotu laha. I waxi tel tame tel akaik, tel tinan ma tolu kahikahin ape lato soh hani tesol laha hahanopi tel akaik. ");
INSERT INTO ssg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jises akeni mini tel akaik ape kakane i, “Talita kum!” Teik kakain ien i ukek, “Tel kokole akaik, xahatale!” ");
INSERT INTO ssg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Taen ien wanen i xahat ape i tau nanahih. Teka seilon ongake hawane ka i moih aliawen. Ahangi tel akaik hehin ien huopanim huohu. ");
INSERT INTO ssg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jises kakane eliel lato, “Axiwa ani tel akaik. Ape kum kaxi sasawateni hani seilon liai waliko ti nga ailewen.” ");
INSERT INTO ssg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jises ma tesol kahikahin nahih salili tewau toan ien ape lato nahih hani tesol tonan ti Nasaret. ");
INSERT INTO ssg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Telao Sabat i hutui hanaui teka seilon leili synagog. Kilan seilon ti ien laha hongoa kakai Jises, laha ongaini hawane ape kumahe laha amuam. Laha kamea, “I kema ia kakain tenen masin? Anesoin tenen lahan i hina? I aile ukek ia poh tenen ti seilon kum aile uke? ");
INSERT INTO ssg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","I tel tuahe ataiai ing. I tel nati Mary, ukale Jeims, Josep, Judas ma Saimon. Nakon tesol tuan kumahe tin lato toto ie?” Ape laha watakai hongoi kakaian. ");
INSERT INTO ssg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jises kakane laha ukek, “Nga masin teka kuluiai kakai Haeu. Ti toan liai seilon sameni laha tuahe ti puki tonalaha wanen seilon watakai hongoi kakaialaha.” ");
INSERT INTO ssg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Aile ape, nake laha kum soh ti Jises, i tai aile hakila puasain ti poh hani laha. Pate palai teka seilon tinun i haewia. I hana minan patul ti laha ape laha ewiwen. ");
INSERT INTO ssg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pate i ongaini hawane ka lato tap namil xoxoan hani i. Ape Jises nahih hani toan tewau tewau hanaui teka seilon. ");
INSERT INTO ssg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","I tiloi apuhini tesol huopanim hua kahikahin ape i talo lato uke hua hua. I hani lato poh ti xaxaweniai spirit lialun. ");
INSERT INTO ssg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","I kakane lato ukek, “Kum kau hahakila soxi, tataen bret, kak ma moni, mewenae kuaiamuto. ");
INSERT INTO ssg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Hanawa axahe aemuto tuahe kum kau hahasea sosomuto.” ");
INSERT INTO ssg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ape i kakane ulei lato, “Na amuto tahia haniwa tewau toan, heutawa ing tehue atengi tataen amuto nahih salili tewau toan ien. ");
INSERT INTO ssg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na hina toan kum amuke amuto ma kum hong amuto, tapahiwa anele aemuto ape nahih saliliwa toan ien. I kola ka teka seilon ien puki laha aile axi laha kawatan nake laha kum hong kakai Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Muhi kakai Jises tesol huopanim huhua kahikahin nahih kaxi ahuti meng solian ti Haeu hani teka seilon lehe laha towiahu ti lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lato xaxaweni spirit lialun ti leili kilan seilon ma ahui wel he kawe kilan teka tinun ape laha ewi. ");
INSERT INTO ssg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herod tel masiwi ti Galili i hong ka axe Jises sawat hani tesol tesol. Hina seilon laha soh ukek Jon Baptis moih aliawen nake laha paxai ka Jises hina poh tenen seilon kum pon hasohotuan. ");
INSERT INTO ssg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Seilon teka laha ukek, “I Elaija.” Ape teka liai ukek, “I tel kuluiai kakai Haeu masin teka kuluiai kakai Haeu ti kuewen.” ");
INSERT INTO ssg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ti Herod hongoa, i ukek, “I Jon Baptis, tetel nga koti xaxaweniwen kinawen ape i moih alia!” ");
INSERT INTO ssg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod tetel i uke axoan Herodias, axoi tel ukalan Pilip. I talo teka seilon kalabusiai Jon. ");
INSERT INTO ssg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Imat ti Herod kalabusi i, Jon Baptis to kaakane Herod, “Nakon o sokok saun solian ti o uke axoi tel ukalam?” ");
INSERT INTO ssg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias lon mewenae lialun ti Jon, pahan i telei tuahe i kum pon. ");
INSERT INTO ssg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod mamata aile halialui Jon nake i tioi ka Jon seilon sawisawin, lawe i usiusi nauna ti Haeu. Aile ape Herod awai i ti Herodias. Kalak kakai Jon tuhuke halialu i, Herod hong waheni kakaian. ");
INSERT INTO ssg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Telao Herod hone laha ailei tehu angiain lalap ti nameniai tehu ngain i takah. I ilowi teka masiwi laha pupuas hahitakan, masiwi ti hile ma masiwi ti toan tewau tewau ti Galili. Tel axoan Herodias namiloi ukek, “Taun tetak ie ti teik waliko nga to nanamiloi.” ");
INSERT INTO ssg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ti tel hehin nati Herodias dedenisama, i hamuamua hawane Herod ma teka seilon kapin. Ape Herod hone i, “Waliko tenen na paham, nga hani o.” ");
INSERT INTO ssg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","I kakane tel hehin ien ti puli lawe seilon, “Na o kamei nga tuahe na tenen, tataen tepaun soxi ti nga ngangahati, nga hani o.” ");
INSERT INTO ssg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ape tel hehin nahih kamei tel tinan, “Kaie nga kamei i waliko la?” Herodias ukek, “Pati Jon Baptis.” ");
INSERT INTO ssg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kiliwan wanen tel hehin nahih alia hani kapi Herod ape i ukek, “Pahak aope ie o hanima nga pati Jon Baptis. Hana haniwa leili tehu kapi ape kau hanima nga.” ");
INSERT INTO ssg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Namili Herod sihikuk hawane tuahe i kum kapitini uke nake i kak tuohawen ti puli teka seilon kapin ka i hani tel hehin waliko ti na i kamea. ");
INSERT INTO ssg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ape se i talo tel unauan nahih hani ingi kalabus ti koti xaxaweniai kinawe Jon Baptis. ");
INSERT INTO ssg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","I hana pati Jon leili tehu kapi ape kau hani tel hehin lehe i hani tel tinan. ");
INSERT INTO ssg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ti tesol kahikahi Jon hongoa, lato kau tihini auni tupuan. ");
INSERT INTO ssg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tesol huopanim huhua aposel tahia alia hani kapi Jises ape kaxi hani i waliko ti lato ailewen ma hanauen seilon. ");
INSERT INTO ssg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lokon ien kilan wanen seilon nahiwa nahima. Aile ape Jises ma tesol kahikahin kum ang uke. Jises hone lato, “Kako nahih hani tesol ti mewenae kako lehe amuto hanawamu teik.” ");
INSERT INTO ssg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ape lato lang he tea koap hani tesol tahain. ");
INSERT INTO ssg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tuahe kilan seilon ningahi ti lato ku ape seilon ti lawe toan laha kiliwau tahiamu imat ti Jises ma tesol kahikahin. ");
INSERT INTO ssg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ti Jises mosua he koap, i ningahi teka kilai seilon ape lon i tel. I tahane laha nake laha masin teka sipsip tap ngahatalaha. Ape i hutui hanau laha kilan waliko ti saun ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Al ape sikole i lol. Tesol kahikahin nahih hani kapin, lato ukek, “Pate ape alohah a tap toan ie. ");
INSERT INTO ssg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Taloa teka seilon hani tesol toan na palieh lehe laha kahui analaha.” ");
INSERT INTO ssg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tuahe Jises ukek, “Puki amuto axiwa analaha.” Lato namiloi ukek, “Malehe kilai seilon, kaie amite pon? I tapai ti kahi tel seilon na i puas ti pangapang tepanim toluhu! Nakon paham amite towi halapa moni ti kahuiai bret ape hani teka kilai seilon ie?” ");
INSERT INTO ssg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jises kamei lato, “Hil bret toi amuto? Nahih paxaimua.” Ti lato tioiwa, lato ukek, “Tepanimawe bret ma huok xixi.” ");
INSERT INTO ssg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jises hone tesol kahikahin ti hatona seiai seilon hani tesol tesol ti he pahoah. ");
INSERT INTO ssg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ape laha to apuha 100 ma 50 ti tonain tesol tesol. ");
INSERT INTO ssg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ti laha toa, Jises akeni tepanim bret ma huok xixi. I pax hani patul ape i kak kemulik hani Haeu. I wiki bret uke teik teik hetekie xixi ape i hani tesol kahikahin sei haniai teka seilon. ");
INSERT INTO ssg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Laha hatesol ang ahoi hawane. ");
INSERT INTO ssg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tuahe kilan moxe an tutuen. Huopanim huohu poi bret ma xixi tesol kahikahin apuhini. ");
INSERT INTO ssg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mongohe seilon ti Jises axi analaha 5,000, tai wexe teka hehin ma akaik. ");
INSERT INTO ssg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Muhin Jises hone tesol kahikahin nahih haniwa he tea koap ape lalangawa imat hani Betsaida. Ape i talo aliake teka kilai seilon. ");
INSERT INTO ssg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","I kak tapeiniwa teka seilon ape i nahih hani patul he maunten. Ti ien i kakak kapi tel Taman Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ti alohahawa, tea koap ape ilam patalal. Jises tutuen ixux. ");
INSERT INTO ssg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","I paxai tesol kahikahin pate lato makeh xoxeiai tea koap nake lato xoxei papahoi aupol. Pate letu ti teik tilokoan tutuen, i nahih patul he kanitax hani kapi lato. Sikole i nahih akulai lato. ");
INSERT INTO ssg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tuahe lato ningahi i nanahih patul he kanitax. Lato sokok ka tel manu. Ausisinialato. ");
INSERT INTO ssg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Lato mamata hawane. Ape Jises kakane lato ukek, “Haxoxoa namilomuto! Kum maamata. Se nga.” ");
INSERT INTO ssg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","I ku haniwa he tea koap ape aupol tuxi. Tesol kahikahin pate lato ongaini. ");
INSERT INTO ssg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kalak lato ningahiwen ti Jises axi ani kilai seilon i akulai 5,000, namilolato tai xeu tutuen Jises i seilon tetenen. ");
INSERT INTO ssg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ti lato takana haniwa texux xux Genesaret, lato xuoti tea koapaulato. ");
INSERT INTO ssg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ti lato mosua, teka seilon ila tioi Jises. ");
INSERT INTO ssg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tataen teka seilon ti lawe toan hongoa ka Jises tahiawen, laha kau talowike hawane teka seilon tinun hani kapin. ");
INSERT INTO ssg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tesol tesol ti i nahiwa, toan lalap ma kokol, teka seilon kaua teka tinun hani tesol tone apuhain. Ape laha kamei eliel Jises na laha tua soti puxuaun. Teka laha soti, laha ewi. ");
INSERT INTO ssg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Telao tesol hanaui nauna ti Moses nahima Jerusalem. Lato ma tesol Parisi apuha kalini Jises. ");
INSERT INTO ssg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Lato ningahi tesol kahikahin tai nuhi minalato ti lato ang. ");
INSERT INTO ssg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tesol Parisi ma teka Ju liai, laha kum ang na laha tai nuhi minalaha ti usiai saun ti teka matahaun. ");
INSERT INTO ssg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na laha aliama ti tesol tone hangainiai waliko, laha kum ang atengi laha ailemu saun ti nuhi haunialaha. Kilan saun tutuen, masin sale nuhiai kap, salek ma pelet. ");
INSERT INTO ssg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ape tesol Parisi ma tesol hanaui nauna ti Moses kamei Jises, “Alahan tesol kahikahim kum aile usi nauna ti teka matahaun? Ti lato ang, lato tai nuhi minalato.” ");
INSERT INTO ssg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","I kak pahoi lato ukek, “Amuto seilon tenen lehomuto huoka! Kakai Haeu ti Aisaia taiwen pate salan ti i kak kilami woumuto. Haeu kakane Aisaia ukek, “‘Teka seilon sameni nga ti tuahe awalaha a namilolaha pate xauxaun tetak. ");
INSERT INTO ssg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kumahe salan laha lolotui nga. Laha hanau waliko ti puki seilon namiloi tanomi.’” ");
INSERT INTO ssg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ape Jises kakane lato, “Amuto aka lioi nauna ti Haeu ape akeni kongini saun tenen puki ti amuto. ");
INSERT INTO ssg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Amuto pate aneso wanen nexi haselei nauna ti Haeu lehe amuto akeni kongini saun tenen puki ti amuto. ");
INSERT INTO ssg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ala amuto tioi waliko ti Moses hahanau seilon. I ukek, ‘Hong tamaniwa kakai tamam ma tinam ape aile hasolia haniwa lalu. Na o kak halialu tamam ma tinam, o laha telei.’ ");
INSERT INTO ssg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tuahe amuto ukek se ewi na seilon kum huali tamalaha ma tinalaha na teik huhual ti hualialalu laha haniwen Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Amuto hanau ukek ien ape seilon kum huali tamalaha ma tinalaha. ");
INSERT INTO ssg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ti amuto aile ukek ien, kumahe amuto usiusi kakai Haeu, amuto hakoutama saun tenen puki ti amuto. Kilan waliko liai tenen masin ien amuto ailele.” ");
INSERT INTO ssg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Muhin ien Jises tiloi teka lawalawai seilon hani kapin ape i ukek, “Amuto hatesol, heiwa taxingamuto lehe amuto hong tioi kakaiak. ");
INSERT INTO ssg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Waliko ti i soh nonoa he awe seilon i kum haloloa i. Mewenae waliko tenen na i ahutama he awe seilon i haloloa i. ");
INSERT INTO ssg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Na amuto hina taxing ti hongoi kakain, hongoa.” ");
INSERT INTO ssg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ape i nahih salili laha hani leili ing. Tesol kahikahin kamei i ti haxewai teik kakaian. ");
INSERT INTO ssg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","I kamei lato, “Tin amuto kum xeu? Nakon amuto tai titioi ka tap waliko ti melal i soh hani leili seilon i haloloa i? ");
INSERT INTO ssg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kumahe i soh hani leili aten, i soh hani leili puhuan. Imuh i ahuta.” Ape Jises kakane lato ka Haeu namiloi ukek hatesol an haun. ");
INSERT INTO ssg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","I ukek, “Waliko ti i ahutama leili seilon, tetenen ien i aile haloloa seilon. ");
INSERT INTO ssg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Waliko lialun ti i ahutama leili seilon se tetesol: namil lialun, saun lialun ti wawan hehin, xuxuina, na ulini ape telei seilon, xuinai axoi seilon liai, ");
INSERT INTO ssg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","saun ti halepean, saun ti halialui seilon liai, puputa, tap saun ti hienain, wiwilik, mimisah, hanasanas ma tua aile lalolal waliko. ");
INSERT INTO ssg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Haeu ukek tesol waliko lialun ien i ahutama leili seilon ape aile haloloa i.” ");
INSERT INTO ssg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jises salili tesol ien ape i nahih hani tesol toan xohixohin Taia. I nahih soh hani tehu ing. Kumahe pahan seilon ningahi i tuahe i kum muna uke. ");
INSERT INTO ssg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tel hehin spirit lialun kapiti hahalialu tel natun hehin, hong tunahi sale puase Jises. Aile ape i nahih kosea hani kapi Jises ape i lokuha hani kapi aen. ");
INSERT INTO ssg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tel hehin ien i kumahe Ju, i hehin Grik, i takah Penisia taon ti Siria. Pahan wanen Jises xaxaweniwa spirit lialun ti leili tel natun. ");
INSERT INTO ssg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jises kakane tel hehin ien ukek, “Kumahe solian na tel i waxi ani natun ape towi hani ani sinen. Ala nga hualimu teka Ju.” ");
INSERT INTO ssg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tel hehin i hong tioi waliko ti Jises kakak ape i ukek, “Salan wanen, tel masiwi, tuahe sinen ani peni ani akaik na i put hani itan.” ");
INSERT INTO ssg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jises kakane i, “Pahoan tetam pate solian. Nahih hetekiewa amuam nake nga xaxaweniwen spirit lialun ti tel natum.” ");
INSERT INTO ssg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ape salan, tel hehin nahih alia hani leili ingan. I ningahi ka tel natun engeeng he sau ape i ewiwen. Spirit lialun saliliwen i. ");
INSERT INTO ssg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jises nahih salili tesol toan xohixohin Taia. I nahih sahi Saidon ma Dekapolis ape i tamus hani kanitax Galili. ");
INSERT INTO ssg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Teka seilon hakahita hani i tel seilon taxingan sutu ma i kum kak alua uke. Laha kamei eliel Jises na i hana minan patul tetan. ");
INSERT INTO ssg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jises aka waxi tel seilon hani kapin. I soti leili taxingan ma i pukeini ngaxe minan ape i soti lehe tel seilon. ");
INSERT INTO ssg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Lon tel hawane ape i pax hani patul. I hone tel seilon, “Epata!” Teik kakain ie i ukek, “Heawa!” ");
INSERT INTO ssg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Taen ien, taxingan hea, lehon tin i puas ape kakaian i xeu. ");
INSERT INTO ssg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jises hone laha, “Kum kakaxi wanen hani teka seilon liai.” Tuahe laha kum puluhini uke, laha kaxi tatale. ");
INSERT INTO ssg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ti teka liai hongoa, laha ongake hawane. Laha ukek, “Kalak taxing sutu ma seilon kum kak uke, i pon haewian. Waliko ti i aile, se hatesol solian.” ");
INSERT INTO ssg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tai kue kilan ulea seilon nahih hani kapi Jises. Ti laha apupuha ien, analaha tapo. Jises tiloi tesol kahikahin hani kapin. ");
INSERT INTO ssg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ape i ukek, “Nga tahane teka seilon ie nake laha kapik kewen ngain toluhu a tap analaha. ");
INSERT INTO ssg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na nga talo aliake laha hetekie hitolo, teka ti tonalaha xauxaun laha tua akimatu luhui aweisal.” ");
INSERT INTO ssg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tesol kahikahin kamei i, “Ti he lohong ie kako kema an ia ti axiai ani teka lawalawai seilon?” ");
INSERT INTO ssg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jises kamei lato, “Hil bret toi amuto?” Lato ukek, “Tepanim huaik.” ");
INSERT INTO ssg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","I hone hatesol seilon ka to haniwa itan. I waxi tepanim huaik bret ape i kak kemulik hani Haeu. I wiki ape i hani tesol kahikahin sei hani teka seilon ape tesol kahikahin aile usi. ");
INSERT INTO ssg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tin hina palaiai kokole xixi. Jises kak kemulik hani Haeu ape i hani tesol kahikahin sei ulea hani teka seilon. ");
INSERT INTO ssg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Hatesol seilon ang ahoi hawane. Ti tesol kahikahin apuhiniwa moxe an i sohotua po tepanim huohu. ");
INSERT INTO ssg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mongohe seilon hatesol 4,000. Jises talo aliake laha hani tonalaha. ");
INSERT INTO ssg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","I ma tesol kahikahin nahih ku hani he tea koap ape lato lang hani texux xux Dalmanuta. ");
INSERT INTO ssg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ti tesol Parisi hongoa Jises tahiawen, pahalato lato kamei tohongi i. Lato nahih hani kapin ape lato lungei i ukek, “Kola hanima amite pohem lehe amite tioi ka salan Haeu taloma o.” ");
INSERT INTO ssg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tuahe Jises tioi waliko ti lato nanamiloi ape i ukek, “Alahan lawe pahamuto nga aile kolawa pohek? Nga kaxi hawane hani amuto, nga kum kola hani teka seilon ti aope ie kolakol ti Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Muhin ien Jises nahih salili lato. I ku hani he tea koap ape i lang hani liai tepaun ti kanitax Galili. ");
INSERT INTO ssg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tesol kahikahin maluhe analato bret, teikawe toi lato he koap. ");
INSERT INTO ssg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jises kakane hawane lato, “Kanipetiwa amuto ti tesol Parisi ma Herod nake laha masin ist.” ");
INSERT INTO ssg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tesol kahikahin he kakak alia lato, “I kak ukek nake kako tap bret.” ");
INSERT INTO ssg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jises tioi waliko ti lato kakak ape i hone lato, “Alahan amuto to kak hahakila ka amuto tap bret? Amuto tai titioi? Amuto kum xeu? Patumuto nakon pate ailan ukean? ");
INSERT INTO ssg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nakon pulamuto pulaxa ma taxingamuto sutu? Amuto tai niningahi ma tai hongohong? Amuto kum nameni? ");
INSERT INTO ssg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ti nga wiki tepanim bret waxeniai teka seilon laha akulai 5,000, hil po moxe an amuto waxi?” Lato ukek, “Huopanim huohu.” ");
INSERT INTO ssg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ape ti nga wiki tepanim huaik bret waxeniai teka seilon kilaialaha 4,000, hil po moxe an amuto waxi?” Lato ukek, “Tepanim huohu.” ");
INSERT INTO ssg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ape Jises hone lato, “Nakon amuto tai xewaxeu?” ");
INSERT INTO ssg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jises ma tesol kahikahin tahia hani Betsaida. Hina seilon ati tel pulaxa hani kapi Jises ape laha kamei eliel i ti akeni sotiai tel seilon ien. ");
INSERT INTO ssg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jises akeni mini tel pulaxa ape ati hani melal ti toan. Muhin ti i pusuiniwa pulan, i hana minan he puli tel seilon ape kamei i, “O ningahi uke waliko?” ");
INSERT INTO ssg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tel seilon paxawa ape i ukek, “Se, nga ningahi seilon nanahih, tuahe tanomalaha masin pata.” ");
INSERT INTO ssg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jises hana ulea minan hani he puli tel pulaxa. Tataen ien pulan xeu hawane ape i paxapax alua. ");
INSERT INTO ssg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jises kakane i, “Nahih sawi haniwa ingam, kum nanahih leili toan.” ");
INSERT INTO ssg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jises ma tesol kahikahin nahih hani toan ti kapi Sisaria Pilipai. Ti lato nanahiwa aweisal, Jises kamei lato, “Kaxi hanima nga, teka seilon laha ukek nga aita?” ");
INSERT INTO ssg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Lato pahoi ukek, “Teka laha ukek o Jon Baptis, teka laha ukek Elaija ape teka liai ukek o tel kuluiai kakai Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jises kamei lato, “A amuto? Amuto ukek nga aita?” Pita pahoi ukek, “O Krais, tel Haeu taloma.” ");
INSERT INTO ssg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jises kakane eliel lato ukek, “Kum kakaxi ka nga Krais.” ");
INSERT INTO ssg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Muhin Jises hutui hanau tesol kahikahin, i ukek, “Nga tel Nati Seilon, nga tunahi lalape kawatan ma moloan ape teka masiwi ti teka Ju, teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses, laha watakai hawane nga. Laha telei nga tuahe muhi ngain toluhu nga xahat alia.” ");
INSERT INTO ssg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","I kaxi haxewa hawane haniwa lato ape Pita waxi tahaini Jises hani kapin ape kahiloloi i nake i kum ukek waliko ien i sohot hani Jises. ");
INSERT INTO ssg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jises tohea paxai tesol kahikahin liai ape i kahiloloi Pita, “Tahawa! O kak hanowi Satan! Namilom kumahe i ahuma ti Haeu, i ahuma ti seilon.” ");
INSERT INTO ssg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ape Jises tiloi teka kilai seilon ma tesol kahikahin hani kapin. I ukek, “Na seilon pahan sohot kahikahik, laha kum namiloi wawaxi mewenae laha. Laha kaua kawatan masin ti nga kakau lehe i kola laha kahikahik wanen. ");
INSERT INTO ssg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Seilon teka pahalaha laha akeni kongini totonalaha ti itan ie, laha kum tunahi tonain kapi Haeu. Tuahe teka laha to kahikahik kalak na masin laha lioi totonalaha ti itan ie nake ti usiai kakai Haeu, laha tunahi tonain kapi Haeu ti tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Na tel seilon hapono hatapo i waliko ti itan ie tuahe i lioi tonain kapi Haeu, solian la i uke? Tap. ");
INSERT INTO ssg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tap tenen waliko kahui uke tonain kapi Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na tel seilon hiena puluhini nga ma kakaiak aope ie, leili taun ti teka seilon to ailele saun lialun, nga tel Nati Seilon tin nga hiena puluhini i taen ti nga alia hetekiema poh ma xewai tel Tamak Haeu ma tesol engel, spirit solian tetan.” ");
INSERT INTO ssg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jises kak tatale ukek, “Nga kaxi hawane hani amuto, teka ti amuto ie, imat ti amuto mat, amuto ningahi nenein ti Haeu sohot hetekiema lalape kui pohen.” ");
INSERT INTO ssg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ngain tepanim tehu tamusua Jises hakahita Pita, Jeims ma Jon hani he tehu maunten patul, mewenae lato. Ti lato ien, tanome Jises sohia hawane. ");
INSERT INTO ssg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tehu puxuaun i xeu papaxaxu hawane, paxaxuan i xoini na seilon nuhi. ");
INSERT INTO ssg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Moses ma Elaija take hahutuia hani kapi lato ape lalu kakak kapi Jises. ");
INSERT INTO ssg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita kakane Jises, “Tel masiwi, pate ewi ti kako ie. Amite atai toluhu houha, tehu tetam, tehu ti Moses ma tehu ti Elaija.” ");
INSERT INTO ssg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","I kak ukek ien nake i ongake hawane ape i kum tioi tenen na i kak. ");
INSERT INTO ssg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Lokon ien, teik lihui maun atuhi lato ape tenen kinax i wixima he maun ien i ukek, “Tel seilon ie se Natuk pate nga waheni. Hongoa i.” ");
INSERT INTO ssg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Muhin ien lato pax ahuahu tuahe lato kum niningah Moses ma Elaija, mewenae Jises. ");
INSERT INTO ssg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ti lato nahih momosua he maunten Jises kakane lato ukek, “Kum kakaxi hani seilon liai waliko ti amuto ningahiwen. Atengiwa tataen ti nga tel Nati Seilon xahat ti mateak.” ");
INSERT INTO ssg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lato hong tamani kakaian. Tuahe ti puki lato, lato to kakak tutuen salangawe teik kakain “xahat ti matemate” ti Jises kakak. ");
INSERT INTO ssg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ape lato kamei Jises, “Nake lahan teka hanaui nauna ti Moses ukek ka Elaija i sohotumu imat ti Krais?” ");
INSERT INTO ssg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jises ukek, “Salan wanen tel masin Elaija i sohotumu apeseniai teka seilon imat ti Krais sohot. Tuahe nake lahan kakai Haeu i ukek ka tel Nati Seilon i tunahi kawatan ma moloan lapalap wanen ma laha watakai hawane i? ");
INSERT INTO ssg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nga kaxi hani amuto, Jon Baptis, tel masin Elaija, i sohotuen tuahe laha aile hani i waliko ti pahalaha. Laha aile halialu i masin ti kakai Haeu kaxiwen leili pepaun.” ");
INSERT INTO ssg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ti Jises ma tolu kahikahin nahih aliawa he maunten, lato ningahi kilan seilon kapi tesol kahikahin liai. Teka hanaui nauna ti Moses lato kak he lungelung kapi tesol kahikahin ien. ");
INSERT INTO ssg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ti teka seilon ningahiwa Jises, pate laha ongake ape kiliwau tengeni amuke i. ");
INSERT INTO ssg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jises kamei tesol kahikahin, “Amuto kak hapatapat waliko la?” ");
INSERT INTO ssg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tel seilon ti leilolaha ukek, “Tel masiwi, nga nahike hanima o tel natuk wawan. Spirit lialun kapiti halialu ape i kum kak uke. ");
INSERT INTO ssg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Lawe na spirit soh haniwa tel natuk, i haputa i hani he hepekeun. Pok sal he awan, i hahakiki nisun ape tupuan tua wakowako. Nga kamei tesol kahikahim ti xaxaweniai spirit lialun tuahe lato kum pon.” ");
INSERT INTO ssg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jises ukek, “Nakon lahan amuto seilon ti aope ie pate tap namil xoxoan? Nga to kapimuto ma tin nga hanau kueiniwen amuto. Kaie kuehuan ia pahamuto nga to kapimuto lehe namilomuto i xox tetak? Ati hanima nga tel akaik!” ");
INSERT INTO ssg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ape lato hakahita i hani Jises. Ti spirit lialun ningahiwa Jises, i aile hahaxexe tel akaik. Tel akaik put huhulil he hepekeun ape pok sal ulea he awan. ");
INSERT INTO ssg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jises kamei tel taman, “Lokon wanen tenen waliko ie tunahi i?” Tel taman ukek, “Lilian ti kokolen. ");
INSERT INTO ssg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Spirit lialun lawe i tohongi lalali teleian. I haputa i hani he ah ma leili kan. Tahanema amili. Na o pon, hualima amili!” ");
INSERT INTO ssg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jises ukek, “Na nga pon? Alahan o ukek na nga pon? Tel na i hina namil xoxoan ti Haeu, lawe waliko i pon.” ");
INSERT INTO ssg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tel tame tel akaik tilol eliel ukek, “Teik kokole namilok xoxoan tuahe i kum tapai. Hualima nga lehe nga uke aheke!” ");
INSERT INTO ssg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ti Jises ningahiwa ka teka seilon to kila aheahema, i tumei spirit lialun ti hasutui taxing ma siponiai au, i ukek, “Nga hone o, ahutawa ti tel akaik. O taha xaxau hawanewa! Kum soh ulelea hani i.” ");
INSERT INTO ssg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Spirit lialun ausisini. I hahaxexe tel akaik ape i sohot ahuta tetan. Lawe seilon sokok tel akaik mat tamusuen nake tanoman masin ka maten. ");
INSERT INTO ssg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tuahe Jises akeni xahateni tel akaik ape i tu. ");
INSERT INTO ssg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Muhin ien Jises ma tesol kahikahin alia hani tonalato ape ti mewenae lato wanen, lato kamei i, “Nake lahan amite kum pon xaxaweniai tenen spirit lialun ien?” ");
INSERT INTO ssg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jises ukek, “Spirit lialun tenen ien mewenae na amuto lotu eliel kamei poh ti Haeu, i pon xaxawenian.” ");
INSERT INTO ssg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Imuh Jises ma tesol kahikahin nahih tamus hani Galili. Kumahe pahan teka seilon liai tioi lato tetesol. ");
INSERT INTO ssg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Pahan i hanau tesol kahikahin. I ukek, “Nga tel Nati Seilon, laha hangaini hani teka seilon ape laha telei. Tuahe muhi ngain toluhu nga xahat alia.” ");
INSERT INTO ssg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lato kum xeu waliko ti Jises kakak. Tuahe lato mamata kamean. ");
INSERT INTO ssg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jises ma tesol kahikahin nahih tahia hani tehu taon Kapenaum. Ti lato leili ing Jises kamei lato, “Ti kako nanahima aweisal, amuto kak lungelung waliko la?” ");
INSERT INTO ssg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lato tai wix pahoi i nake ti he aweisal lato kak hapatapat aita tel pamu tuah ti lato. ");
INSERT INTO ssg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jises to ape i kakane huopanim huhua kahikahin ukek, “Na pahamuto amuto to masiwi, teheniwa amuto ape hualiwa seilon liai.” ");
INSERT INTO ssg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jises aka hatuhi tel akaik matalato. I akeni aumi tel akaik ape i kakane lato ukek, ");
INSERT INTO ssg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Na tel i waxi auni akaik masin ie nake nga, se i aunini nga. Ape tel i waxi auni nga, i waheni tel Tamak Haeu, tetel i taloma nga.” ");
INSERT INTO ssg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon tel kahikahi Jises ukek, “Tel masiwi, amite ningahi tel seilon i xaxaweni spirit lialun leili teka seilon hahitake axam. Tuahe i kumahe tel ti kako ape amite honewen i ka kum ailele.” ");
INSERT INTO ssg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jises hone tesol kahikahin ukek, “Kum hahalini i. Na tel seilon aile hasohotu waliko tenen lalap hahitake axak, i kum pon kak halialuak. ");
INSERT INTO ssg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Na tel seilon i kum pahoxai kako ti pupuasakako, i tepaun ti kako. ");
INSERT INTO ssg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nga kakane hawane amuto, na tel seilon axi amuto kalak tuahe na kaniup nake amuto tetak, i uke kahun ti Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jises hahanau tutuen lato ukek, “Pate lialun wanen ti tel seilon na i aile haputa tel seilon liai kalak i seilon naun ma namilon kumahe xoxoan tetak. Pamu ewian laha xioti tehu mes lalap hani he kinawen ape hataxixi hani ilam. ");
INSERT INTO ssg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na o hapuasa tepaun minam ti ailei saun lialun, koti xaxaweniwa. Pamu ewi na o uke tonain kapi Haeu ti tap tahi tapoan minam tepaunue. Ien se pamu ewian ti na o sohot hani tesol ti kawatan tap tahi tapoan hetekie minam hupaun. ");
INSERT INTO ssg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tetesol ien, tehot ah xekean tap tahi pehoan. ");
INSERT INTO ssg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na o hapuasa tepaun aem ti ailei saun lialun, koti xaxaweniwa. Pamu ewi na o uke tonain kapi Haeu ti tap tahi tapoan kalak o mangei. Ien se pamu ewian ti na laha towi o hani tesol ti kawatan tap tahi tapoan hetekie aem hupaun. ");
INSERT INTO ssg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tetesol ien ‘ul ani laha lian tehue ape tin laha kum tipehi uke ah.’ ");
INSERT INTO ssg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na o hapuasa tepaun pulam ti ailei saun lialun, xaxusi xaxaweniwa. Pamu ewi na o sohot hani tone Haeu pulam tepaunue. Ien se pamu ewian ti na laha towi o hani leili tesol ti kawatan tap tahi tapoan hetekie pulam hupaun. ");
INSERT INTO ssg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tetesol ien ‘ul ani laha lian tehue ape tin laha kum tipehi uke ah.’ ");
INSERT INTO ssg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Totohong ma kawatan masin ah na i lui amuto. Tuahe na amuto waxaini, amuto masin sol ti hanamui an. ");
INSERT INTO ssg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sol solian tuahe na namun tapo, o aile ukek ia aliakei namun? Amuto hanowiwa sol uke tap pupuasamuto ti Haeu. Tin haeliel hawanewa lehe waxi wasolamuto tel tel mewenae solian.” ");
INSERT INTO ssg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Imuh Jises nahih salili Kapenaum ape i nahih hani texux xux Judia. I kolia hani pape kan Jodan. Kilan seilon nahih apuha hani kapin ape i hanau laha kakai Haeu hanowi ti lawe i to ailele. ");
INSERT INTO ssg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Teka Parisi nahih hani kapi Jises ape kamei tohongi i ukek, “Nakon ewi na tel wawan lioi tel axoan?” ");
INSERT INTO ssg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jises kamei lato, “Moses kakane amuto waliko la?” ");
INSERT INTO ssg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Lato ukek, “Moses kakawen ka ewi na tel wawan tai teik kakain ti sale lioiai tel axoan.” ");
INSERT INTO ssg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jises hone lato, “Moses ukek ewi nake hanauamuto pate ailan. ");
INSERT INTO ssg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tuahe ti uli tanomiai tehu pon ie, Haeu ‘tanomi wawan hetekie hehin.’ ");
INSERT INTO ssg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Aile ape tel wawan i salili tel taman ma tinan ape i hukuma hani kapi tel axoan. ");
INSERT INTO ssg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Lalu sohot hanowi seilon tel.’ Lalu ape kumahe hua, lalu masin ka telawe. ");
INSERT INTO ssg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aile ape waliko ti na Haeu hukumini, seilon kum seselai.” ");
INSERT INTO ssg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ti lato nahih alia haniwa leili ing, tesol kahikahin kamei Jises sale teik kakain i kakak. ");
INSERT INTO ssg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","I kak pahoi lato ukek, “Na tel wawan i lioi tel axoan ape i waxi axoan tel hehin liai, i ailewen saun lialun ti wawan hehin. ");
INSERT INTO ssg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tin masin na tel hehin i lioi tel axoan ape i waxi axoan tel wawan liai, tin i ailewen saun lialun ti wawan hehin.” ");
INSERT INTO ssg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Telao teka seilon hakahita teka akaik kokol hani kapi Jises lehe i lotu huali lato tuahe tesol kahikahin kahiloloi laha. ");
INSERT INTO ssg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ti Jises paxaiwa, lon i lialu ape i hone tesol kahikahin, “Tiliwen teka akaik nahih hani kapik, kum talo xaaxaweni lato. Teteka seilon laha sohot hanowi teka akaik ie, Haeu neini aweisalulaha. ");
INSERT INTO ssg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nga kakane hawane amuto, Haeu neini mewenae teteka laha hana xoxoi namilolaha hani i masin teka akaik laha hana xoxoi namilolaha hani tamalaha ma tinalaha.” ");
INSERT INTO ssg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","I akeni aumi akaik tel tel ape i hana minan patul ti lato ti lotu hualialato. ");
INSERT INTO ssg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ti Jises hutui i nahih, tel seilon kiliwama ape i put lokuha hani itan kapi ae Jises, i ukek, “Tel masiwi solian, nga aile la lehe nga uke tonain kapi Haeu ti tap tahi tapoan?” ");
INSERT INTO ssg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jises kamei i, “Nake lahan o ukek nga solian? Na masin o ukek nga solian, namiloi paxaiwa nake mewenae Haeu solian. ");
INSERT INTO ssg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","O tioi nauna tetan: ‘Kum tetelei seilon, kum ailele saun lialun ti wawan hehin, kum xuuxuina, kum kau puputini kakain, kum aile pipisi seilon liai ma hongoa kakai tamam tinam ape aile hasolia haniwa lalu.’” ");
INSERT INTO ssg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tel seilon ukek, “Tel masiwi, nga usi hahatapo tesol nauna ien lilian ti nga akaik.” ");
INSERT INTO ssg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jises paxai tioi namili tel seilon ien. Ape hetekie tatahan i ukek, “O tai aile teik waliko. Nahih hangainiwa hatesol soxiam ape haniwa teka seilon tap soxi lehe imuh o uke kahum ti tone Haeu. Ape o nahih kahitima nga lehe o sohot kahikahik.” ");
INSERT INTO ssg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ti tel seilon hongoa kakai Jises, tian kawat hawane ape i nahih alia hetekie tatahan nake soxian pate kilan. ");
INSERT INTO ssg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jises paxai aliake tesol kahikahin ape i kakane lato, “Seilon tenen kilan soxi, pate ailan wanen ti usiai aweisal ti Haeu neneini!” ");
INSERT INTO ssg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tesol kahikahin ongaini hawane kakaian. Tuahe Jises kak tuhi ulea, “Tesol natuk, pate ailan wanen ti seilon tenen laha hana soxi mateiwa ti laha ti usiai aweisal ti Haeu neneini. ");
INSERT INTO ssg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kumahe malimun ti tok kamel na i soh non he tewau aweing laha axai nil ti sawitiai maia. Tuahe pamu ailaian ti seilon tenen kilan soxi ti usiai aweisal ti Haeu neneini.” ");
INSERT INTO ssg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tesol kahikahin pate lato hong ongaini hawane. Lato he kakak puki lato, “Lehe ape aita pon?” ");
INSERT INTO ssg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jises paxai lato ape i ukek, “Ti mewenae kui seilon i kum pon. Tuahe hetekie huhual ti Haeu, lawe waliko i pon.” ");
INSERT INTO ssg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita ukek, “Kaien amite pon nake amite saliliwen lawe waliko ape amite nahih usiusi o.” ");
INSERT INTO ssg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jises hone lato, “Nga kakane hawane amuto. Tel na i salili tonan, ukalan, tuan, tinan, taman, natun ma na soxian nake ti usiai kakai Haeu, i uke waliko pamu kilaian. ");
INSERT INTO ssg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ti aope ie, i kilan ukalan, tuan, tinan, akaik, soxi ma na tonan. Tuahe tin i tunahi kawatan ma moloan. Ape ngain ti luluainima, i uke tonain kapi Haeu ti tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tuahe kilan teka axalaha lalap ti aope ie, Haeu paxai ukek laha seilon tenen tap axalaha ape seilon ti tap axalaha ti aope ie, Haeu paxai ukek laha seilon tenen axalaha lalap.” ");
INSERT INTO ssg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jises ma tesol kahikahin nahih hahaniwa Jerusalem. Jises nanahiwa imat. Tesol kahikahin ilameni ox tuhi lato. Teteka laha nahih usiusi lato, laha mamata waliko tetenen na i sohot Jerusalem. Jises waxi selai tesol huopanim huhua kahikahin hani tesol mewenae lato ape i kaxi hani lato waliko tetenen na i sohot hani i. ");
INSERT INTO ssg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jises hone lato ukek, “Kako ape nahih hahaniwa Jerusalem. Ti ien, nga tel Nati Seilon, laha hangaini nga hani mini teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses. Lato noseni teleiak ape lato hangaini nga hani mini teka seilon ti Rom. ");
INSERT INTO ssg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Laha soxeni, pukeini, heti ma telei nga tuahe muhi ngain toluhu nga xahat alia.” ");
INSERT INTO ssg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Muhin ien Jeims ma Jon, hua nati Sebedi, nahih hani kapi Jises. Lalu ukek, “Tel masiwi, pahamili o aile hanima amili teik waliko.” ");
INSERT INTO ssg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jises kamei lalu, “Waliko la pahamulu nga aile hani amulu?” ");
INSERT INTO ssg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Lalu hone Jises, “Tataen o sohotua tel Masiwi ti neiniai hatesol seilon, pahamili o hatonama amili kapim, tel tepaun manau, tel tepaun kalamau lehe tin amili sohot masiwi ti neiniai seilon.” ");
INSERT INTO ssg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jises ukek, “Amulu kum tioi waliko tetenen amulu kakamei. Nakon amulu lang pahoi uke laman ti ape nga lang pahoi? Nakon amulu pon kaui kawatan ti nga kau kalak na amulu mat?” ");
INSERT INTO ssg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Lalu pahoi ukek, “Amili pon.” Jises hone lalu, “Salan imuh amulu lang pahoi laman ti nga lang pahoi. ");
INSERT INTO ssg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tuahe kumahe nga tetel kilamiai seilon ti tone minak manau ma na kalamau ti neiniai seilon. Tonain ien Haeu hani teka i kilamiwen.” ");
INSERT INTO ssg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ti tesol huopanim kahikahin liai hongoa, lolato lialu ti Jeims ma Jon. ");
INSERT INTO ssg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jises apuhini lato hatesol ape i ukek, “Amuto tioi ka kewi teka masiwi ti he tehu pon ie lato neini halialu teka seilon hahitakalato ape lato lungei laha ka tua hongoa lato. ");
INSERT INTO ssg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tuahe kumahe pahak i sohot ukek ien leilomuto. Na tel ti amuto pahan ax lalap, i kola hawanewa ka i tel ti hualiai seilon. ");
INSERT INTO ssg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tin masin na tel ti amuto pahan i sohot seilon tuah, i kewa unauamuto hatesol. ");
INSERT INTO ssg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tataen nga tel Nati Seilon, kumahe nga toma lehe seilon to unauak, nga toma unaualaha. Ape nga mat ti ukei kahi lialui woi seilon.” ");
INSERT INTO ssg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ti lato nahih sasaliliwa Jeriko hani Jerusalem, Jises ma tesol kahikahin hetekie kilai seilon, lato apatuini tel seilon pulaxa axan Batimeus, nati Timeus. Lawe i toto ngixi aweisal kameiai huhual. ");
INSERT INTO ssg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ti i hongoa ka Jises ti Nasaret ien, i tilol, “Jises, tel kahi nati David, tahanema nga!” ");
INSERT INTO ssg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kilan seilon tumei i ka minginiwa awan. Tuahe i tilol eliel ahe, “Tel kahi nati David, tahanema nga!” ");
INSERT INTO ssg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jises tu hamalum ape i ukek, “Taloma i.” Ape laha tilol hone tel seilon pulaxa, “Amuamua! Tua! Jises titiloi o!” ");
INSERT INTO ssg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Amuamui Batimeus i hana lioi tehu atuhiai puxuaun, i tit tu ape i nahih hani kapi Jises. ");
INSERT INTO ssg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jises kamei i, “Paham nga aile hani o waliko la?” Tel pulaxa ukek, “Tel masiwi, pahak o haewiama pulak.” ");
INSERT INTO ssg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jises hone i, “Nahiwa, xoxoi namilom ti Haeu aile haewiawen o.” Tataen ien wanen, pulan ewi ape i nahih kahiti Jises. ");
INSERT INTO ssg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jises ma tesol kahikahin nahih hani huowau toan Betfage ma Betani, pape tehu Maunt Oliv, xohixohin Jerusalem. I kilami hua ti lato ti ailei tenen puasain. ");
INSERT INTO ssg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","I hone lalu ukek, “Nahih haniwa tewau toan mateiwaukako. Na amulu tahiawa, amulu tunahi tok donki uluha xinotan ien. Tap tel seilon kikiliwakewen i. Upatiwa ape hakahitama. ");
INSERT INTO ssg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na tel seilon kamei amulu, ‘Kalahai amulu upati tok donki?’ honewa i, ‘Tel Masiwi pahan pake i atoheni aliake koseni.’” ");
INSERT INTO ssg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ti lalu nahiwa, lalu tunahi tok donki tutu pape aweisal, xinotan he kukui ing. ");
INSERT INTO ssg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ti lalu upapati, teka seilon ien kamei lalu, “Kalahai amulu upati?” ");
INSERT INTO ssg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Lalu kakane laha hanowi ti Jises hohone lalu ape laha sowini hani lalu waxiai tok donki. ");
INSERT INTO ssg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lalu hakahita tok donki hani kapi Jises ape lalu axaheni puxuaulalu he tehiton. Jises to patul ape tok donki kiliwake i. ");
INSERT INTO ssg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kilan seilon axaheni puxuaulaha he aweisal ti i luluainiwa. Ape teka liai axaheni kai hatoh ti laha kotima he kin. ");
INSERT INTO ssg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Teka seilon nanahiwa mateiwai Jises ma teka nanahima muhin, hatesol tilol ausisini ukek, “Kako haxawawa axe Haeu. Kako amukewa tel kahi nati David, tel i nahih hehetekiema poh ma solian ti Haeu! ");
INSERT INTO ssg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tel seilon ie lehe i neini kako masin ti tel masiwi David neiniwen! Kako sameniwa Haeu tel pohen tapein!” ");
INSERT INTO ssg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ti Jises tahiawa Jerusalem, i nahih soh hani tehu Ingi Haeu. I paxai kalini hatapo lawe waliko ape i nahih ahuta alia hani Betani hetekie huopanim huhua kahikahin nake pate ape alohah. ");
INSERT INTO ssg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ngain liai telao ti lato nahih sasaliliwa Betani, Jises ilameni ka i hitol. ");
INSERT INTO ssg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ti i pax haniwa mateiwa, i ningahi tea pata axan fig hina kaun. I nahih paxai na hina huan. Ti i tahiawa i tunahi ka tap huan, mewenae kaun nake kumahe taun ti huai fig. ");
INSERT INTO ssg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ape i kakane tea pata ukek, “Tap o po hua ulea.” Tesol kahikahin hongoen kakain ti i kakawa. ");
INSERT INTO ssg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ti lato tahiawa Jerusalem, lato nahih hani mate Ingi Haeu. Kilan seilon hahangaini soxi ma manihuh ien. Hangainiai waliko ti laha pate lialun. Ti Jises ningahiwa, i usi xaxaweni laha. I aka suoteni sau ti sohiai moni ma sau ti teka seilon laha hahangaini pux. ");
INSERT INTO ssg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","I halini teka seilon kau koti mate Ingi Haeu soxi ti hangaini. ");
INSERT INTO ssg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ape i kakane nau laha, “Kakai Haeu ukek, “‘Tehu ingak ing ti lotu ti lawe seilon.’” Ape Jises ukek, “Tuahe amuto aile hanowi ka ing ti tone munai teka xuxuina.” ");
INSERT INTO ssg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses, lato hongoa waliko ti Jises ailewen ape lato upiup aweisal ti teleian. Lato mamata i nake kilan seilon sameni waliko ti i hahanau laha. ");
INSERT INTO ssg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ti ape alohah, Jises ma tesol kahikahin nahih ahuta ti Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pate letu ti liai telao, ti lato tau nanahih aweisal, lato ningahi ulea tea pata axan fig. I ape maten, mat tamus haniwen taen puolan. ");
INSERT INTO ssg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita nameni aliake kakai Jises ape i ukek, “Tel masiwi, paxaiwa! Tea pata ti o kakane ka i kum huhua ape i matewen! Alahan pate i mat kosea?” ");
INSERT INTO ssg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jises hone lato ukek, “Haxoxoa namilomuto ti Haeu! ");
INSERT INTO ssg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nga kaxi hawane hani amuto, na tel seilon hina namil xoxoan, tap kakapax, ape i kakane tehu maunten ie, ‘Hutawa ie ape towia haniwa itax,’ hoi liai i sohot. ");
INSERT INTO ssg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nga kakane hawane amuto, na amuto kamei Haeu tenen na waliko ape amuto soh hawane ka Haeu hani amuto, amuto uke tetenen ti amuto kamekam. ");
INSERT INTO ssg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ti na amuto lotu, hasawimua lialui lomuto ti seilon liai lehe tel Tamamuto Haeu i oxoxi amuto ti kawatan ti saun lialun ti amuto. ");
INSERT INTO ssg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tuahe na amuto kum hasawi lialui lomuto ti seilon liai, tel Tamamuto Haeu kum oxoxi amuto ti kawatan ti saun lialun ti amuto. ");
INSERT INTO ssg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Muhin ien lato ape alia haniwen Jerusalem. Ti Jises tau nanahih mate Ingi Haeu, teka masiwi tuah ti hukuminiai Haeu ma seilon, teka hanaui nauna ti Moses ma teka masiwi liai ti teka Ju, lato nahih hani kapin. ");
INSERT INTO ssg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Lato kamei i, “Aita hone o ailei waliko ti o ailele? Aita sowini hani o?” ");
INSERT INTO ssg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jises kak pahoi lato, “Nga kameimu amuto tenen kamekame. Amuto pahoimuma nga ape nga kaxi hani amuto tetel i sowini hani nga. ");
INSERT INTO ssg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kaxi hanima nga, aita sowini hani Jon baptaisiai seilon, Haeu ka seilon?” ");
INSERT INTO ssg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Lato kak namiloi papaxai puki lato, “Kaie kako kak ukek ia? Na kako ukek Haeu sowini hani Jon, i kak ukek, ‘A alahan amuto kum soh Jon?’ ");
INSERT INTO ssg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tuahe na kako ukek seilon sowini hani i, kaie waliko la i sohot?” Lato mamata uke lato halenge teka kilai seilon laha namiloi ukek Jon i tel kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aile ape lato kak pahoi Jises ukek, “Amite kum tioi aita sowini hani Jon.” Jises ukek, “Nga tin nga kum kaxi hani amuto aita hone nga ailei waliko ti nga ailele.” ");
INSERT INTO ssg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Muhin ien Jises hutui kakaian hanaui teka seilon. I kaxi tenen meng i ukek, “Tel seilon seini tesol lalape kin ape i tiehi kalini. I tahiwi tewau wal, tone pisihi waxiai kani huai pata ape i atai tehu kokole ing patul, totone teka peteniai tesol kin. I hani teka seilon puas ngahati tesol kin lehe tin i uke aliake hina huai pata. Ape i ku hani texux xux xauxaun. ");
INSERT INTO ssg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ti huai pata pamua, i talo tel unauan hani kapi teka ngahatiai tesol kin waxiai ti tetan. ");
INSERT INTO ssg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tuahe teka ngahatiai tesol kin pohi xai i ape tua talo aliake. ");
INSERT INTO ssg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tel masiwi ti tesol kin talo ulei tel unauan liai hani kapi lato. Tuahe lato xai patun ma aile halialu i. ");
INSERT INTO ssg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tel masiwi ti tesol kin talo ulei tel unauan liai ape tetel ien lato telei. I talo uleiwa teka muhin, teka lato xai, teka lato telei. ");
INSERT INTO ssg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tapeinan i talo telawe natun pate i waheni. I ukek, ‘Tel ie natuk wanen ma lato aile aluini.’ ");
INSERT INTO ssg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Tuahe teka ngahatiai kin he kakak alia puki lato ukek, ‘Tetel ie se tel natun wanen. Ien, kako telei i lehe tesol kin ape ti kako.’ ");
INSERT INTO ssg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Lato pohi telei ape towi xoini i hani melal ti tesol kin.” ");
INSERT INTO ssg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ape Jises kamei teka laha hongohong tenen mengon, “Tel masiwi ti tesol kin kaie ape i aile waliko la? Nga kakane hawane amuto, na i tahiawa, i telei lato ape tesol kin ien i hani he mini teka seilon liai. ");
INSERT INTO ssg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ala amuto tioi teik kakain ie: “‘Tehu kuku teka ataiai ing hilisa, Haeu aile ape i sohot kuku tehu pamu tuah ti kuku liai. ");
INSERT INTO ssg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Haeu aile ape kako amuam hawane.’” ");
INSERT INTO ssg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tesol masiwi ti teka Ju lato tioi ka meng ti Jises kakaxi i kak nanami lato. Aile ape lato upiup aweisal ti pohian tuahe lato mamata teka kilai seilon kapin ape lato nahih salili i. ");
INSERT INTO ssg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Muhin teka masiwi ti teka Ju talo teka Parisi ma teka kahikahi Herod hani kapi Jises ape lato kamei tohongi i. Lato sasakal na Jises kak tunahi waliko tenen na i sului aliake i. ");
INSERT INTO ssg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Lato ukek, “Tel masiwi, amite tioi ka kakaiam mewenae salan. Woum o aile hani teka seilon masiwi ma teka seilon naun lawe tekewe. Ti o hanau seilon kakai Haeu, kakain tenen salan, tap puputa leilon. Kaxi hanima amite, ewi na kako hani Sisa teik moni pahan? ");
INSERT INTO ssg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kaie kako hani?” Tuahe Jises tioiwen namilolato. Ape i kamei aliake lato ukek, “Alahan amuto kamei tohongi nga? Kau hanima nga tehu puli moni lehe nga paxai.” ");
INSERT INTO ssg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Lato hani i tehu ape i kamei lato, “Kawe aita ma axe aita he tehu puli moni?” Lato ukek, “Ti Sisa.” ");
INSERT INTO ssg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jises hone lato ukek, “Waliko ti Sisa haniwa Sisa, waliko ti Haeu haniwa Haeu.” Pate lato ongaini sale pahoan tetan. ");
INSERT INTO ssg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Teka Sadusi kapaxe ka seilon maten moih alia. Lato nahih hani kapi Jises ape lato ukek, ");
INSERT INTO ssg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tel masiwi, Moses tai hanawen na tel wawan mat salili tel axoan a tap natulalu, tel ukalan kewa axoan tel hehin ien. Ape na lalu tan akaik, tesol akaik ien nati tel i matewen. ");
INSERT INTO ssg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hongoa mengomite. Telao hatotalin lato tepanim hua. Tel pamu i sal ape i mat salili tel axoan, tap natulalu. ");
INSERT INTO ssg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tel usiai tel pamu uke tel hehin ape tin i mat, tin tap natulalu. Tin masin tel usiai tel i matewen, tin i mat. ");
INSERT INTO ssg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Lato hatesol tepanim huhua talin ien mat a tap natulato. Tapeinan ape tel hehin mat. ");
INSERT INTO ssg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Taen Haeu xahateni hatapo seilon maten, tel hehin ape axoi aita? Nake ati lato ukewen tel hehin ien.” ");
INSERT INTO ssg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jises pahoi lato ukek, “Kakaiamuto kumahe salan nake amuto kum tioi kakai Haeu ma pohe Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Taen Haeu xahateni aliake lawe seilon laha matewen, ape tapein tenen hahunatun. Ti tone Haeu, seilon kum sal masin teka engel. ");
INSERT INTO ssg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nga kaxi haxewa hani amuto sale xahatai seilon maten. Amuto tioi meng ti Moses taiwen. I kakaxi waliko ti Haeu kakanewen i ti leili teik sisihan ti ah xekexek. Haeu hone i ukek, ‘Nga Haeu tetel ti Abraham, Aisak ma Jekop lolotui.’ ");
INSERT INTO ssg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","I Haeu ti teka seilon moihin nake teka seilon tetan laha matewen laha kumahe salan maten. Namilomuto kumahe salan ka seilon maten i kum moih alia.” ");
INSERT INTO ssg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Muhin ien tel hanaui nauna ti Moses nahih hani kapi lato. I hong ka Jises kak pahoi hapoponowi hawane tesol Sadusi ape i kamei Jises, “Ti lawe nauna ti Haeu, lahe nauna tuah tapein?” ");
INSERT INTO ssg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jises pahoi i ukek, “Nauna tuah tapein tenen ie, ‘Amuto teka Israel hongoa! Telawe Haeu i Masiwi ti kaha, tap tel tutuen. ");
INSERT INTO ssg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Waheni hawanewa Haeu tel Masiwi ti amuto, xoiniwa ti amuto waheni teka seilon liai. Amukewa Haeu ti leili tiamuto, namiloi eliel hawanewa i ma aile hatapoa puasan ti hatesol kuimuto.’ ");
INSERT INTO ssg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tenen nauna usian masin: ‘Waheniwa teka seilon liai hanowi ti amuto waheni aliake amuto.’ Tap nauna liai i pamu tuah ti huhuonen.” ");
INSERT INTO ssg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tel seilon ukek, “Tel masiwi, kakaiam pate sawisawin. Salan ti o ukek Haeu i telawe, tap tel tutuen. ");
INSERT INTO ssg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Salan ti o ukek kaha amukewa Haeu ti leili tiakaha, namiloi eliel hawanewa i, aile hatapoa puasan ti hatesol kuikaha ape waheniwa teka seilon liai hanowi ti kaha waheni aliake kaha. Saun masin ien i xoini na kaha kau soxi ma manixux hani Haeu ape i xoini na kaha lelei manixux hani i.” ");
INSERT INTO ssg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jises hong tioi ka kakaian pate sawisawin. Ape i ukek, “O pate xohixohin kapi Haeu tel neiniam.” Muhin tap tel seilon pahan i kamei ulei Jises tenen na kamekame. ");
INSERT INTO ssg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ti Jises to hahanau teka seilon mate Ingi Haeu, i kamei laha ukek, “Nake lahan tesol hanaui nauna ti Moses ukek ka Krais, tel Haeu taloma, i kahi nati David? ");
INSERT INTO ssg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Puki Holi Spirit hanamiloa David ape i kak ukek, “‘Haeu kakane tel Masiwi tetak, “Toma papak tepaun manau ti neiniai seilon atengi tataen nga hanawa teka laha pahoxai o hani hahitakam.” ’ ");
INSERT INTO ssg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Paxaiwa, puki David axai Krais Masiwi tetan. Na masin ien, i kumahe tuahe kahi natun.” Teka laha hongohong kakai Jises pate laha hong amuke. ");
INSERT INTO ssg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jises kakane teka seilon ien i ukek, “Amuto lepetawa. Kum usiusi saun ti teka hanaui nauna ti Moses. Lato hana puxux weluwelun ape tau nanahih ti puli lawe seilon lehe laha paxai tioi ka lato seilon tuah. Ape pahalato hatesol seilon kak sameniwa lato. ");
INSERT INTO ssg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pahalato ukei totoan tenen tuah leili synagog ma tone angiain lalap. ");
INSERT INTO ssg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Lato pisi teka hehin axoalaha matewen lehe lato seseke soxialaha ma ingalaha. Lato aile lotu weluwelun lehe teka seilon paxai sameni. Teka hanaui nauna ti Moses ien, Haeu hani lato kawatan lalap wanen.” ");
INSERT INTO ssg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Muhin ien Jises toto onote tehu lohe moni ti Ingi Haeu. I ningahi kilan seilon kau lolohi moniulaha. Teka seilon moniulaha kilan, laha hana halapa moni. ");
INSERT INTO ssg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ape tel hehin axoan matewen i tap moni, nahima ape i hana huohu puli moni pate kokol. ");
INSERT INTO ssg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jises ilowi apuhini tesol kahikahin ape i hone lato ukek, “Nga kakane hawane amuto, tel hehin ie i hana moni pamu lapan ti teka liai. ");
INSERT INTO ssg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Teka laha hana hahalapa, moniulaha pate kilan tutuen, tuahe tel hehin ie moniun pate kokol wanen, i hana hatapoen ti i hina.” ");
INSERT INTO ssg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ti Jises nahih salili Ingi Haeu, tel ti tesol kahikahin hone i ukek, “Oie! Tel masiwi, paxaimua lalape pot ti tesol Ingi Haeu! Laha atai hasolia hawane tanoman.” ");
INSERT INTO ssg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jises pahoi i ukek, “Salan i pate solian tuahe imuh laha toi hamanana ape tesol pot ie put silahota.” ");
INSERT INTO ssg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Muhin ien Jises han to hani he tehu Maunt Oliv onote Ingi Haeu. Pita, Jeims, Jon ma Andru kamei i ti ape mewenae lato, ");
INSERT INTO ssg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kaxi hanima amite lokon wanen tesol waliko ti o kakaxi sohot? Kaie kikilam la i sohot imat ti tesol waliko ien?” ");
INSERT INTO ssg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jises hone lato, “Lepetawa uke teka seilon puluti amuto. ");
INSERT INTO ssg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Imuh kilan seilon tahiama ape laha ukek laha Krais. Laha puluti hakila seilon. ");
INSERT INTO ssg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na amuto hong hilehile i sosohot, amuto kum maamata. Tesol waliko ien hoi i sohot tuahe i tai meiwa ti tapoi tehu pon ie. ");
INSERT INTO ssg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Seilon ti xux texux texux hilei seilon ti xux liai. Seilon ti toan tewau hilei seilon ti toan liai. Xux ti tesol tesol i nuea ape kilan seilon laha mat ti hitolo. Tesol waliko ien tuahe hutuiai kawatan imat ti tapoi tehu pon ie. ");
INSERT INTO ssg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Amuto lepetawa! Amuto laha hana hani mini teka masiwi ti toan ape laha xai amuto leili synagog. Laha sului amuto hani teka masiwi ti puasain tenen tenen nake amuto kahikahik. Ien se aweisal ti amuto kaxi nga hani laha. ");
INSERT INTO ssg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ape imat ti tapoi tehu pon ie, teka kahikahik kaxi ahutimu meng solian ti Haeu hani seilon ti lawe xux. ");
INSERT INTO ssg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na laha xoti ma sului amuto, kum hahakila namilomuto waliko tenen ti na amuto kak. Pake Holi Spirit hanamiloa amuto kakain. ");
INSERT INTO ssg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Taun tehu ien kumahe solian. Hahutalin, tel i hangaini tel hani laha telei. Tin masin hahutaman, tel taman i hangaini tel natun hani laha telei. Teka akaik hangaini tamalaha ma tinalaha hani seilon telei. ");
INSERT INTO ssg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kilan seilon watakai hawane amuto nake amuto kahikahik. Tuahe na amuto tu matuha atengi tataen kawatan tapo, Haeu waxi auni amuto lian tehue. ");
INSERT INTO ssg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tuah wanen na amuto xeu waliko ti nga kakak. Na amuto ningahi waliko tenen lialun wanen ti seilon aile tanomi i tetesol ti Haeu hahalini, amuto teka toto Judia kiliwau muna haniwa he maunten. ");
INSERT INTO ssg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tel na i melal, i kiliwawa. I kum alia hahani leili ing waxiai soxian. ");
INSERT INTO ssg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tin masin tel na i pupuas he kinen, i kum tohea alilia hani leili ingan waxi palahiai puxuaun, tin i kiliwawa. ");
INSERT INTO ssg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tataen ien, kawatan wanen ti teka hehin tialaha hina akaik ma teka natulaha susus tutuen. ");
INSERT INTO ssg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kamei elieliwa Haeu lehe taun masin ien i kum sohot leili hunan lialun ma taun ti waiwain. ");
INSERT INTO ssg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kawatan ien i xoini kawatan ti imat, ti uli tanomiai tehu pon ie haniwa taen imuh. ");
INSERT INTO ssg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tuahe Haeu namiloi teka seilon tetan ape i koti hakukuna taun lialun ien uke tap seilon moih. ");
INSERT INTO ssg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Taun tehu ien, na tel hone amuto ukek, ‘Paxaiwa, Krais ie,’ ma na i ukek, ‘Paxaiwa, Krais io,’ kum hong sohosoh. ");
INSERT INTO ssg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Hina seilon ti puputa sohotuma ukek ka laha Krais ma teka ukek laha kuluiai kakai Haeu. Laha aile hasohotu waliko lalap tenen tenen ape laha tohongi pulutiai teka seilon ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nga kakane hahatapo amuto waliko imat ti i sohot. Amuto lepetawa! ");
INSERT INTO ssg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Muhi kawatan ien, “‘al i kum kam, pangapang i kum xeu, ");
INSERT INTO ssg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kohot ti he maun i put, hatesol waliko ti he maun i nuea.’ ");
INSERT INTO ssg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Taen ien hatesol seilon ningahi nga tel Nati Seilon mosulih patul he maun hetekie lalape poh ma soliai talepai xewaiak. ");
INSERT INTO ssg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ape nga talo tesol engel, spirit solian tetak waxi apuhiniai teka seilon nga kilamiwen tetak ti tesol tesol, ti sai ahang, angiha, haiup ma tola. ");
INSERT INTO ssg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Amuto namiloi paxaiwa talil. Ti kaun mak put, amuto tioi ka taun ti aupol angiha. ");
INSERT INTO ssg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tin masin, taen amuto ningahi tesol waliko nga kakanewen amuto i sohot, amuto tioi kewak aliaiak ape i xohi hawanewen. ");
INSERT INTO ssg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nga kakane hawane amuto, hina seilon ti aope ie laha kum matemu atengi tataen waliko ien i sohot. ");
INSERT INTO ssg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Maun ma xux ti aope i tapo tamus. Tuahe kakaiak hamalum lian tehue. ");
INSERT INTO ssg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Tap tel tioi ngain tetehu ma lokon wanen tesol waliko ien i sohot. Teka engel ti Haeu kum tioi ma puki nga tel Natun tin nga kum tioi, mewenae tel Tamak Haeu tioi. ");
INSERT INTO ssg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lepetawa ma apeas peleawa nake amuto kum tioi lokon wanen sohotuan. ");
INSERT INTO ssg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Pate masin na tel seilon nahih salili tesol tonan ape i nahih hani tewau toan xauxaun. Tehu ingan i hani he mini tesol unauan ape i axi puasalato. I hone tel ngahatiai ing, ‘O peteniwa aliaiak.’ ");
INSERT INTO ssg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tin amuto pax petawa nake amuto kum tioi loke aliai tel masiwi ti tehu ing. Uke na alohah ka luhui ipong ka ti mom wawan kokoini ma na ti i ninitinile. ");
INSERT INTO ssg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Amuto kum matih luhuluh, uke i sohot haonga amuto. ");
INSERT INTO ssg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Waliko ti nga kaakane amuto, nga kakane lawe seilon. Amuto peteniwa aliaiak!” ");
INSERT INTO ssg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Lawe ahang teka Ju aile angiain lalap ti nameniai ngain ti lokon Haeu waxi aliake teka tamalaha ti matahaun leili Igip. Ngain tehu hutuan laha ani sipsip wawan uluha, tenen angiain ien laha axai Pasova. Ape tesol ngain muhin laha ani bret tenen i tai xiu. Ngain huohu imat ti Pasova, teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses, lato sasakal aweisal ti seilon kum tioi lehe lato xoti Jises ape hakahita hani teka teleian. ");
INSERT INTO ssg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Lato ukek, “Kako kum ailemu leili taun ti angiain lalap uke teka seilon hil pahoi kako.” ");
INSERT INTO ssg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Lokon ien Jises tewau toan ti Betani, leili ingi Saimon, tetel kemuk tinun hina nax lialun. Ti lato to angiang, tel hehin kauma tehu sanda kahun pate lalap ma poun tin pate solian. I hei tehu peti sanda ape i tihi hani pati Jises. ");
INSERT INTO ssg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ti teka seilon ien paxaiwa, lolaha lialu ape laha he kakak alia puki laha, “Kalahai i tua tihi xoini tehu sanda? ");
INSERT INTO ssg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pamu ewian na hangaini waxiwen moni lalap ape hani teka seilon tap soxi.” Ape laha kahiloloi i. ");
INSERT INTO ssg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tuahe Jises ukek, “Kum hohowini i nake i ailele saun solian hani nga. ");
INSERT INTO ssg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Teka seilon tap soxi laha lawe kapimuto, amuto pon hualialaha telao ti na pahamuto. Tuahe nga kumahe lawe kapimuto. ");
INSERT INTO ssg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ti i tihi sanda hani patuk, se i apepeseni nga ti tehu tihiniak. I aile hani nga waliko tenen ti i pon. ");
INSERT INTO ssg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nga kakane hawane amuto, tesol tesol ti laha kaxi meng solian ti Haeu tin laha kaxi waliko ti tel hehin aile hahani nga lehe seilon nameni i.” ");
INSERT INTO ssg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Taen ien Judas Iskariot, tel ti tesol huopanim hua kahikahi Jises, i nahih hani kapi teka masiwi tuah ti hukuminiai Haeu ma seilon ape hone lato ka pahan i hangaini Jises hani minalato. ");
INSERT INTO ssg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ti lato hongoa, pate lato amuam hawane. Ape lato kakane Judas ka lato axi i moni. Ien, Judas ape i sakal tehu taun solian ti na i hangaini Jises hani minalato. ");
INSERT INTO ssg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ngain tehu hutuiai angiain lalap ti laha telei sipsip wawan uluha, tesol kahikahi Jises kamei i, “Paham amite apeseni tonain ti tehu angiain lalap hani ia?” ");
INSERT INTO ssg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ape Jises talo hua kahikahin i ukek, “Amulu nahih haniwa leili Jerusalem. Ti ien, amulu apatuini tel wawan kakau tehu peti kan. Kahitiwa i. ");
INSERT INTO ssg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Na i soh hani leili ing, soh usiwa ape honewa tel tame tehu ing kewak, ‘Tel masiwi kamekam tetesol na i ma tesol kahikahin lato to ang tehu angiain ti Pasova.’ ");
INSERT INTO ssg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","I kola hani amulu tesol tonain ti leili ing teke patul, lawe waliko ti angiain leilon. Apeseniwa anakako ien.” ");
INSERT INTO ssg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ti huhua kahikahin nahih haniwa leili taon, lalu tunahi lawe waliko masin ti Jises kakawen. Ape lalu apeseni an ti nameniai lokon ti Haeu waxi ahuti tesol tamalaha teka Ju ti Igip. ");
INSERT INTO ssg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ti ape alohah, Jises ma tesol huopanim huhua kahikahin tahia hani tesol ien. ");
INSERT INTO ssg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ti lato angiang, Jises hone lato, “Nga kakane hawane amuto, tel ti amuto hangaini nga, kalak i to angiang kapik.” ");
INSERT INTO ssg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tialato kawat hawane ape lato tel tel kamei i, “Kaie kumahe nga?” ");
INSERT INTO ssg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","I hone lato, “Se tel ti amuto tesol huopanim huhua kahikahik. I tetel i xomi anan hani leili tehu tone an kapik. ");
INSERT INTO ssg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nga tel Nati Seilon, imuh nga mat masin ti leili pepai Haeu kakawen. Tuahe kawatan lalap tunahi tel seilon i hangaini nga hani laha telei. Pamu ewian na i tai takah.” ");
INSERT INTO ssg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Leilon ti lato angiang, Jises waxi teik bret, i kak kemulik hani Haeu ape i wiki sei hani tesol kahikahin. I ukek, “Waxi aniwa, se tupuak.” ");
INSERT INTO ssg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Muhin i waxi tehu kap waen, i kak kemulik hani Haeu ape i hani lato hatesol unumi. ");
INSERT INTO ssg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","I kakane lato, “Ie se kakauk i xiweu ti kolakol ka Haeu oxoxi seilon ti kawatan ti lialui woulaha na laha hana namil xoxoan hani i. Mateak kola hapoponowi ka Haeu xinoti tenen namil haun kapi seilon. ");
INSERT INTO ssg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nga kakane hawane amuto, nga kum un ulea waen atengi taun ti amuam leili tone Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Muhin ien lato pakui tenen pak hani Haeu ape lato nahih ahuta hani Maunt Oliv. ");
INSERT INTO ssg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jises kakane tesol kahikahin ukek, “Amuto hatesol kiliwau salili nga masin ti leili pepai Haeu kakawen, “‘Nga telei tel ngahatiai sipsip ape teka sipsip kiliwau silahota.’ ");
INSERT INTO ssg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Tuahe taen nga moih aliawa, nga tahia imat ti amuto hani Galili.” ");
INSERT INTO ssg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita hone i, “Kalak na lato hatesol kiliwau salili o, nga tiliwen kapim.” ");
INSERT INTO ssg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jises hone Pita, “Nga kakane hawane o, imat ti tok mom wawan kokoini uke he huohu ipong tetehu, o putini ka o kum tioi wanen nga uke he toluhu.” ");
INSERT INTO ssg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tuahe Pita kak eliel ahe ukek, “Kalak na nga mat ohoi o, nga kum kak wanen ka nga kum tioi o.” Ape hatesol kahikahin tin lato kak ukek ien. ");
INSERT INTO ssg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Imuh lato tahia hani tesol kin axan Getsemani. Jises hone teka ti tesol kahikahin ukek, “Amuto tiliwen ie, nga kaakamu kapi tel Tamak Haeu.” ");
INSERT INTO ssg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ape i waxi Pita, Jeims ma Jon kahitian. I ilameni kawatan lalap wanen ape i mamata xexex, mapuke hetekie. ");
INSERT INTO ssg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","I hone lato, “Lalape tatahan tetak ma matauak i nisohi hawane hanawaiak. Amuto tiliwen ie ape pax petawa.” ");
INSERT INTO ssg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I nahih ahewa teik ape i eng kalunga hani hepekeun. I kamei eliel Haeu na masin i xaxaweni kawatan ti matemate. ");
INSERT INTO ssg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","I ukek, “Tel Tamak Haeu, o pon ailei lawe waliko. Xaxaweniwa kawatan ti matemate ti lehe i tunahi nga. Tuahe pahak nga usi namilom.” ");
INSERT INTO ssg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jises nahih alia hani kapi tesol kahikahin ape i tunahi ka lato mamatih. I hone Pita, “Saimon, amuto mamatih! Alahan pate amuto kum ah? ");
INSERT INTO ssg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ah kapitawa ma lotu tatalewa lehe amuto xoini totohong ti Satan na i tunahi amuto. Pahamuto ailean tuahe tupuamuto pate kawatan.” ");
INSERT INTO ssg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jises nahih ulea ape i kamei tel Taman Haeu waliko tin tetenen. ");
INSERT INTO ssg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ti i nahih alia haniwa kapi tesol kahikahin, i tunahi lato mamatih ulea. Pulalato pate lihian. Lato kum tioi waliko tenen na lato kak. ");
INSERT INTO ssg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ti aliaian kewa he toluhu, i hone lato, “Tin amuto mamatih tutuen! Tapan matihu! Hongoa! Ape i meiwen taun ti nga tel Nati Seilon, laha hani he mini teka seilon lialun. ");
INSERT INTO ssg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Xahatawa! Tel hangainiak i nanahima. Kako nahih pahoi i.” ");
INSERT INTO ssg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ti Jises kakak tutuen, Judas tahiawa. I tel ti tesol huopanim huhua kahikahin. I kakahiti kilan seilon liai hetekie ngol weluwelun ma pata ti hile. Teka masiwi tuah ti hukuminiai Haeu ma seilon, teka hanaui nauna ti Moses ma teka masiwi liai taloma laha. ");
INSERT INTO ssg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas hani peleiwen laha tenen kolakol, i ukek, “Seilon tel na nga asoi taliopan se tetel ien. Pohi hakahitawa ma peteniwa.” ");
INSERT INTO ssg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas nahih sawi hani kapi Jises ape i ukek, “Tel masiwi, amuam ti Haeu hani o.” Ape i asoi taliope Jises. ");
INSERT INTO ssg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tataen ien laha pohi kongini i ape hakahita. ");
INSERT INTO ssg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tuahe tel seilon leilolato waxi tea ngol weluwelun ape i tai koti haputa taxingi tel unaui tel masiwi tapein ti hukuminiai Haeu ma seilon. ");
INSERT INTO ssg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jises hone laha, “Amuto nahih hetekiema paumuto ti hile waxiak hanowi ka nga seilon lengean. ");
INSERT INTO ssg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Lawe ngain nga to hahanau seilon leili Ingi Haeu a amuto tai pohi nga. Tuahe kakai Haeu i sohot poponowi hani nga.” ");
INSERT INTO ssg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Lokon ien hatesol kahikahin kiliwau salili i. ");
INSERT INTO ssg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Leilolaha tel seilon uluha, i soosoi teik maia ti matihu. I nahih kakahiti Jises ape lehe teka seilon pohi hetekie i. ");
INSERT INTO ssg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ti tel seilon mamata kiliwawa, teik maia toia ape i kiliwawa makahul. ");
INSERT INTO ssg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Laha hakahita Jises hani kapi Kaiapas tel masiwi tapein ti hukuminiai Haeu ma seilon ape hatesol masiwi liai ti teka Ju apuha hani kapin. ");
INSERT INTO ssg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita nahih otioti Jises tamus hani mate ingi Kaiapas. I to akakati tesol peteniai Ingi Haeu ma hahahia tinun pape ahilato. ");
INSERT INTO ssg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hatesol masiwi ti teka Ju upiup aweisal ti teleiai Jises, tuahe lato kum tunah. ");
INSERT INTO ssg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kilan seilon kak sului putini Jises a kakaialaha kumahe tenenawe. ");
INSERT INTO ssg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hina seilon tule ape kak tanomi kakain puputa ti suluiai Jises. ");
INSERT INTO ssg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Laha ukek, “Amite hong i kak ukek, ‘Nga toi hamanana tehu Ingi Haeu ape leili ngain toluhu nga hatuhi tehu Ingi Haeu liai, kumahe ing tenen mini seilon atai.’” ");
INSERT INTO ssg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tuahe kakaialaha tin kumahe tenenawe. ");
INSERT INTO ssg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tel masiwi tapein ti hukuminiai Haeu ma seilon tule ape hone Jises, “Teka seilon ie laha susului o. Hina kakaiam?” ");
INSERT INTO ssg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tuahe Jises tai wix pahoi. Kaiapas kamei ulei i, “Nakon o Nati Haeu, tel Krais Haeu taloma?” ");
INSERT INTO ssg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jises ukek, “Se nga. Imuh amuto ningahi nga tel Nati Seilon toto he tepaun mini Haeu sai manau neiniai seilon kapin ma tin amuto ningahi nga luainima he maun.” ");
INSERT INTO ssg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kaiapas hongoa ape i leng lexi tehu puxuaun. I ukek, “Kako kum ngah ulea seilon suluian. ");
INSERT INTO ssg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Amuto hongoen i ukek i tel Nati Haeu. Kaie kako aile ukek ia?” Lato hatesol xinoti namil tenenawe ti teleiai Jises. ");
INSERT INTO ssg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Teka seilon pukeini i ape uke maia talini puxuiai pulan. Lato taputui i ma kak soxeni i ukek, “Na o Krais, tilawa aita xai o!” Ape tesol peteniai Ingi Haeu xai halialu i. ");
INSERT INTO ssg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Lokon ien Pita toto tutuen kapi teka seilon mate ingi Kaiapas ape tel hehin unaui tel masiwi nahima. ");
INSERT INTO ssg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ti i ningahiwa Pita toto pape ah, i ila mataini ape i ukek, “O tel ti teka lawe kapi Jises ti Nasaret.” ");
INSERT INTO ssg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tuahe Pita ase ukek, “Nga kum tioi tel seilon ien.” Ape i nahih hani onote aweing ti melal. ");
INSERT INTO ssg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tel hehin ningahi ulei i ape kakane tesol seilon lato tutu kapin ukek, “I tel ti teka kahikahi Jises.” ");
INSERT INTO ssg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tuahe Pita ase ulea. Tai kue, teka seilon tutu xohixohin kapi Pita ukek, “Salan, o tel ti lato nake o ti Galili.” ");
INSERT INTO ssg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita ukek, “Kuinake, nga kak hahawane nga kum tioi tel seilon amuto kakak.” ");
INSERT INTO ssg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tataen ien tok mom wawan kokoini uke he huohu. Ape Pita nameni aliake kakain ti Jises kaakane i ka imat ti tok mom wawan kokoini uke he huohu, i kak uke he toluhu ka i kum tioi Jises. Pita nameniwa ape i tang tahane hawane. ");
INSERT INTO ssg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pate letu wanen, hatesol masiwi ti teka Ju apuha ailei namil ti waliko tenen na lato aile hani Jises. Lato xioti i ape hakahita hani kapi Pailat, tel ti teka masiwi ti Rom kiliwakei Judia. ");
INSERT INTO ssg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat kamei Jises, “Nakon o tel masiwi tapein ti teka Ju?” Jises kak pahoi ukek, “Masin ti o kakawen.” ");
INSERT INTO ssg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Teka masiwi tuah ti hukuminiai Haeu ma seilon lato kak susului Jises hani Pailat ti kilan waliko tenen puputa. ");
INSERT INTO ssg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ape Pailat kamei ulei i, “Tap pahoan tetam? Hongoa, kilan waliko laha susului o.” ");
INSERT INTO ssg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tuahe tin Jises tai wix pahoi. Pailat pate i ongaini. ");
INSERT INTO ssg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Leili taun ti angiain lalap ti nameniai ngain ti Haeu waxi aliake teka Ju ti Igip, saun ti Pailat i ahuti tel ti teka kalabus, tetel na teka seilon pahalaha. ");
INSERT INTO ssg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ti lokon ien tel seilon axan Barabas i kakalabus kapi teka seilon tuaun nake lato hil pahoi teka masiwi ti kiliwakei xuxulaha. Ti leili hilehile lato teleiwen hina seilon. ");
INSERT INTO ssg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kilan seilon nahih hani kapi Pailat kameian ti ahutiai tel na kalabus. ");
INSERT INTO ssg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat kamei laha, “Pahamuto nga ahuti hani amuto tel masiwi tapein ti teka Ju?” ");
INSERT INTO ssg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat pate i tioi ka teka masiwi tuah ti hukuminiai Haeu ma seilon hangaini Jises hani i tuahe ti wawatak nake kilan seilon sameni i. ");
INSERT INTO ssg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tuahe teka masiwi tuah ti hukuminiai Haeu ma seilon kak hahika teka seilon ti laha apupuha ien kameiai Pailat ti ahuti hanialaha Barabas, kumahe Jises. ");
INSERT INTO ssg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat kamei ulei laha, “Pahamuto ape nga aile waliko la wanen hani tetel seilon amuto ukek i tel masiwi tapein ti teka Ju?” ");
INSERT INTO ssg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Laha tilol pahoi Pailat, “Teleiwa i! Tahi hakeawa i he kros!” ");
INSERT INTO ssg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat kamei laha, “Nake lahan? Waliko la pate lialun i aile talesiwen?” Laha tilol ausini aheke, “Tahi hakeawa i he kros!” ");
INSERT INTO ssg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat pahan i hamuamua teka seilon. Aile ape i ahuti Barabas. I hani tesol unauan ti hile heti Jises ape hakahita lehe waxi lato tahi hakea i hani he kros. ");
INSERT INTO ssg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tesol unaui Pailat ti hile ati hasoho Jises hani tehu ing lalap, ingi Pailat, ape lato tiloi tesol tuaulato. ");
INSERT INTO ssg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lato waxi teik maia tenen kakai ati polun ape sosoi hani Jises. Lato alingini ngaxe au ape nihini hana hani he patun. ");
INSERT INTO ssg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ape lato soxeni i ukek, “Tel masiwi tapein ti teka Ju tap tahi mateam!” ");
INSERT INTO ssg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Lato uke teik pata xai tuhituhi patun ape lato pukeini i. Lato lokuha hanowi ka lato lotu sameni i. ");
INSERT INTO ssg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ti lato heisawa soxenian, lato naxi xaxaweni teik maia. Lato sosoi aliake i teik puki soson ape ati i lehe lato tahi hakea i hani he kros. ");
INSERT INTO ssg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ti lato hakahitawa Jises, lato apatuini tel seilon axan Saimon nahih hahaniwa taon. Teka unaui Pailat ti hile lungei i kaui teik kros ti Jises kakau. Saimon akiki tehu taon lalap axan Sairini, tame Aleksanda ma Rupus. ");
INSERT INTO ssg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Lato hakahita Jises hani tesol axan Golgota. Teik kakain ien i ukek, “Tetesol tanoman masin kui pati seilon.” ");
INSERT INTO ssg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ape lato axi i unum ti hamongai moloan tuahe Jises kum unumi. ");
INSERT INTO ssg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Lato tahi hakea Jises he teik kros pata ape lato sei puxuaun wasolalato. Lato halokeni satu ti upiai tetel i uke tetenen ia ti tesol sose Jises. ");
INSERT INTO ssg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ti 9 kilok letu lato hakea Jises. ");
INSERT INTO ssg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Teik kakain ti suluian lato tahi hahakea onote patun i kak ukek, “Tel Masiwi Tapein ti teka Ju.” ");
INSERT INTO ssg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tin lato tahi hakea hua seilon ti xuxuina xohixohin kapi Jises, tel sai manau ape tel sai kalamau. ");
INSERT INTO ssg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kakai Haeu i poponowi hawane ti i ukek, “Laha aile hanowi i seilon tenen woun pate lialun.” ");
INSERT INTO ssg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Teka seilon ti laha nahih sahiwa Jises, laha tohutoh ape kak soxeni ma kak halialu i ukek, “Se o tel seilon o ukek o toi tehu Ingi Haeu ape muhi ngain toluhu o hatuhi aliake! ");
INSERT INTO ssg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Awai aliakewa o. Na o pon, mosulih he teik kros ien!” ");
INSERT INTO ssg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses, tin lato tutu ien papaxai Jises ape lato he kakak ukek, “I huali uke seilon liai tuahe i kum pon huali aliakean. ");
INSERT INTO ssg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Na kako paxai ka tel Krais ie, tetel masiwi tapein ti Israel, i mosulih he teik kros, kako soh tetan.” Huhua lalu akeak kapi Jises tin lalu kak halialu i. ");
INSERT INTO ssg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ti lape ngain, hatehu xux i tilok ti leili aua toluhu. ");
INSERT INTO ssg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ti 3 kilok alohah, Jises tilol eliel hawane, “Eloi Eloi, lama sabatani?” Ien i ukek, “Haeu tetak, Haeu tetak, nakon lahan o lioi hawane nga?” ");
INSERT INTO ssg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Teka seilon xohixohin kapin, laha ukek, “Hongoa, i titiloi Elaija.” ");
INSERT INTO ssg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tel i kiliwau waxi teik maia, i xomi hani he waen tenen wangingian ape i hana hani tumi teik pata. I tulini hani he awe Jises lehe waxi i sumuxi. I ukek, “Nutomu, kako paxaimu na Elaija mosulih ape hamosu i he teik kros.” ");
INSERT INTO ssg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jises ausini eliel hawane ape i mat. ");
INSERT INTO ssg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tataen ien wanen Haeu lexi teik maia i akeak leili tehu Ingi Haeu, ti patul hani taen itan. ");
INSERT INTO ssg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tel ti teka unaui Pailat ti hile tutu mate Jises. I paxai otioti sale matei Jises ape i ukek, “Salan wanen tel seilon ie Nati Haeu!” ");
INSERT INTO ssg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Teka hehin tu siasia paxaiai Jises. Leilolato Mary Magdalen, Salome ma Mary, tel tini Joses ma Jeims tel uluha. ");
INSERT INTO ssg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Lokon ti Jises tutuen Galili tesol hehin ien lawe lato kakahiti ma huhuali i. Kilan hehin liai laha kahitima Jises hani Jerusalem, laha tin ien. ");
INSERT INTO ssg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sai alohah ti tehu ngain ti apeseniai Sabat. ");
INSERT INTO ssg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josep ti Arimatea i nahih hani kapi Pailat ape i matut kamean na i waxi auni tupui Jises. Josep i tel ti tesol masiwi ti teka Ju. I to mon atetengi ngain ti Haeu neini lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat pate i kum amemene ti i hongoa kiliwai matei Jises. I tiloi tel unauan ti hile ape kamei i na salan Jises matewen. ");
INSERT INTO ssg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ti i hongoa ka salan, i hani Josep waxi tupui Jises. ");
INSERT INTO ssg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep kahui teik maia ti auniai seilon maten. I hamosu Jises hani itan ape i puxui talini tupuan. I hana auni hani leili amal tenen laha tanomi he pot patul ti hepekeun. Muhin i hulini tehu pot lalap siponiai tehu amal. ");
INSERT INTO ssg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalen ma Mary tel tini Joses ma Jeims, lalu niningahi tesol ti Josep hahana tupui Jises. ");
INSERT INTO ssg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ti Sabat tapoa, Mary Magdalen, Salome ma Mary tel tini Joses ma Jeims, lato kahui sanda tenen poun solian lehe lato ahui hani tupui Jises. ");
INSERT INTO ssg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sande ti pate letu, lato nahih hahaniwa amali Jises. ");
INSERT INTO ssg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Lato he kamekam alia puki lato, “Kaie aita tel na i hulini xaxaweni hani kako tehu pot lalap he aweingi amal?” ");
INSERT INTO ssg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ti lato xeisawa, lato ningahi tehu pot lalap ape hulinan. ");
INSERT INTO ssg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Lato sohoa ape lato ningahi tel seilon uluha i toto sai manau, puxuaun weluwelun a papaxaxun. Ape lato mamata hawane. ");
INSERT INTO ssg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","I hone lato, “Kum maamata! Nga tioi ka amuto upiup Jises ti Nasaret, tetel laha telei. I kumahe ie, i moih aliawen! Paxaiwa, i tap tetesol laha hahana i. ");
INSERT INTO ssg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aope ie amuto nahih kaxi haniwa Pita ma tesol kahikahin liai ka Jises nahiwen imat ti amuto hani Galili. Amuto ningahi i ien masin ti i kakanewen amuto.” ");
INSERT INTO ssg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tesol hehin nahih ahutawa ape lato kiliwau salili tesol ien. Lato tataxini hetekie ox tuhi tinulato ma lato xexex. Lato tai kakane tel na seilon nake pate lato mamata. ");
INSERT INTO ssg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Muhin ti Jises moih aliawa ti Sande pate letu, i take hani Mary Magdalen, tetel imat Jises xaxaweni tepanim hua spirit lialun leilon. ");
INSERT INTO ssg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mary Magdalen nahih hani kapi tesol kahikahi Jises lawan. Lato hatesol tang tahane hawane matei Jises. Ape i kakane lato waliko ti i sohot hani i. ");
INSERT INTO ssg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ti lato hongoa ka Mary ningahiwen Jises ape moihin, lato kapaxe hawane. ");
INSERT INTO ssg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Imuh Jises take hani kapi huhua kahikahin lalu nanahih ti Jerusalem hani tesol tahain. Pala lalu kum ila tioi i nake tanoman sohiawen. ");
INSERT INTO ssg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lalu nahih alia ape kaxi hani tesol liai, tuahe tin lato kapaxe. ");
INSERT INTO ssg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tapeinan Jises take hani kapi huopanim tel kahikahin ti lato angiang. Jises tumei lato nake lato kapaxe i ma lato kum hong soh teka laha ningahiwen ka i moih aliawen. ");
INSERT INTO ssg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jises kakane tesol kahikahin ukek, “Lua tapaiwa lawe xux ti itan ie ape kaxi sawateniwa meng solian ti Haeu haniwa lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Na tel seilon i soh tetak ti amuto kakaxi tenen meng solian ien ape amuto baptaisi i, tel seilon ien i to kapi Haeu lian tehue. Tuahe na tel seilon i kum soh, Haeu selai xaxaweni i kapin lian tehue. ");
INSERT INTO ssg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Teka laha hong soh, nga hani laha poh ti ailei tesol waliko ie. Ti hahitake axak laha xaxaweni spirit lialun leili seilon. I pon laha kak kakain ti kumahe kakaialaha. ");
INSERT INTO ssg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Na laha akeni weiko tenen i hamange seilon ma unumi unum tenen hina suhasuh, i kum halialu laha. Ape na laha lotu hana minalaha patul ti teka tinun, laha ewi.” ");
INSERT INTO ssg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Muhin ti Jises kak kewa kapi tesol kahikahin, Haeu waxi i hani patul ti tesol tonan ape i to sai tepaun mini Haeu manau ti neiniai lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tesol kahikahin lato kaxi sawateni meng solian tetan hani tesol tesol. Pohe Haeu pupuas hualialato. Haeu haxoxo tenen meng ti lato kakaxi ape i kola ka kakaian salan wanen, usiwa waliko tenen lato ailele ti kui pohen. ");
INSERT INTO ssg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nga tua tai hahongo o tel masiwi Teopilus, kilan seilon laha tohongiwen taiai menge Jises ti lawe waliko ti i sohotuen leilomite teka kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Laha usiusi kakain ti teka laha ningahiwen waliko ti i sohotuen ma teka hanaui meng solian ti Jises kakaxi. ");
INSERT INTO ssg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aile ape nga upia mataini menge Jises ti hutuan wanen ape nga namiloi ukek ka solian na tin nga tai haxewa hani o waliko ti i sohotuen. ");
INSERT INTO ssg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nga aile ukek lehe o tioi hawane ka waliko ti teka kahikahi Jises hanauen o, salan wanen. ");
INSERT INTO ssg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lokon Herod masiwi ti Judia, Sakaraia tel masiwi ti hukuminiai Haeu ma seilon, i pupuas leili Ingi Haeu hetekie tesol tuaun. Axalato Abijaia. Tenen ax ie lato kema axe tel masiwi ti hukuminiai Haeu ma seilon ti matahaun. Tel axoi Sakaraia Elisabet i kahi nati Aron tel masiwi tapein ti hukuminiai Haeu ma seilon. ");
INSERT INTO ssg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Haeu namiloi ukek lalu hauhua seilon sawisawin. Lawe lalu puas usi mataini hatapo hatesol nauna ti Haeu tel Masiwi. ");
INSERT INTO ssg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lalu tap natulalu nake Elisabet i lieheh hetekie lalu tin ape salaimat. ");
INSERT INTO ssg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ngain tehu, Sakaraia ma teka tuaun lato pupuas leili Ingi Haeu nake taun ti lato ti puas leili puasain tehu ien. ");
INSERT INTO ssg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Usiai saun ti teka masiwi ti hukuminiai Haeu ma seilon, lato kilami tel ti leilolato soh hani leili Ingi Haeu ti luiai sanda hani Haeu ma lotu hualiai teka seilon. Telao ien lato kilami Sakaraia. ");
INSERT INTO ssg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ti tehu sanda lulua, kilan seilon laha tu lolotu melal. ");
INSERT INTO ssg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Leili Ingi Haeu tel engel, spirit solian ti Haeu, i take hani Sakaraia. I tutu sai manau ti tone luiai sanda. ");
INSERT INTO ssg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ti Sakaraia ningahiwa, i tataxini ma i mamata hawane. ");
INSERT INTO ssg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tuahe tel engel kakane i ukek, “Kum maamata, Sakaraia! Haeu hongoen kamekame tetam. Tel axoam Elisabet hatakaha tel akaik natum. Axaiwa axan Jon. ");
INSERT INTO ssg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Amulu ma kilan seilon liai amuke hawane i. ");
INSERT INTO ssg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Amuto hatesol amuam nake Haeu namiloi ukek Jon i sohot tel seilon pate tuah. I kum un unum ailan. Tataen ti uli takahan, Haeu hani i Holi Spirit ti kapitian. ");
INSERT INTO ssg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ape i neini kilan ti amuto Israel lehe amuto towiahu ti lialui woumuto hani Haeu tel Masiwi ti amuto. ");
INSERT INTO ssg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","I sohotuma imat ti Krais, tel Haeu taloma. Ape Holi Spirit hapohea i hanowi ti i hapohea Elaija tel kuluiai kakai Haeu. Jon huali seilon ti apesenialaha ti sohotui Krais. I hukumini aliake akaik ma taman ma huali teka tahitah ti usiai nauna ti Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaraia kakane tel engel ukek, “Lehe nga tioi ukek ia ka teik waliko ti o kakak i sohot? Amili tel axoak ape salaimat.” ");
INSERT INTO ssg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tel engel ukek, “Nga Gabriel, tel unaui Haeu pate tuah. I taloma nga hahongoam tenen meng solian ien. ");
INSERT INTO ssg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tuahe nake o hong kapaxe kakaiak, o kum wix uke atengi taen tel natum takah. Waliko ti nga kakane o i po sohot onoteni hawane taun ti Haeu kikilami.” ");
INSERT INTO ssg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lokon ien teka seilon melal atetengi Sakaraia ape laha nam tataxini ti i pate kuen leili Ingi Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ti i ahutama i kum kakane uke laha. I tua hapuasa minan kakanealaha ape laha paxai tioi ka tenen waliko tuah take haniwen i. ");
INSERT INTO ssg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tataen puasain tehu ti puase Sakaraia leili Ingi Haeu tapoa, i nahih alia hani tonan. ");
INSERT INTO ssg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Muhin ien tel axoan Elisabet pet akaik ape i tai sosohot melal ti pangapang tepanim. ");
INSERT INTO ssg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","I ukek, “Ti soliai Haeu i huali nga ape i xaxaweni hatapo hienain ti na lieheh. Teka seilon ape laha kum paxai teheni nga.” ");
INSERT INTO ssg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Muhi pangapang tepanim tehu ti Elisabet petiwa akaik, Haeu talo tel engel Gabriel hani tehu taon Nasaret leili Galili. ");
INSERT INTO ssg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","I hakouta kakain hani tel hehin axan Mary i tai engeeng kapi tel na wawan. I tel laha otei haniwen axoi Josep, kahi nati tel masiwi David. ");
INSERT INTO ssg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tel engel hone Mary, “Haeu aile hasolia hawanewen o. I kapim.” ");
INSERT INTO ssg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mary namiloi taxiake hawane kakai tel engel ape i namiloi papaxai haxewai teik kakain ien. ");
INSERT INTO ssg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tel engel kakane Mary ukek, “Kum maamata, Haeu aile kola soliaian hani o. ");
INSERT INTO ssg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","O hanatua tel akaik wawan. Na i takahawa, axaiwa axan Jises. ");
INSERT INTO ssg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I sohot tel seilon pate tuah ma pohe Haeu toi i ape laha axai i Nati Haeu. Haeu hana i tel masiwi ti teka Ju masin tel masiwi David, tetel Jises nakuama tetan. ");
INSERT INTO ssg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ape i neini teka Israel ma i to Masiwi lian tehue.” ");
INSERT INTO ssg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary kakane tel engel ukek, “Nga tai engeeng kapi tel na wawan, aile ape i sohot ukek ia?” ");
INSERT INTO ssg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tel engel kak pahoi i ukek, “Ti pohe Haeu, Holi Spirit atuhi halihu o ape o pet akaik. I hani hatapo tupuan ailei puase Haeu ape laha axai i Nati Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nam paxaiwa tel akikim Elisabet. Kalak i salaimat i petiwen akaik. Kemuk i lieheh ape aope ie pangapangaun tepanim tehu. ");
INSERT INTO ssg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tap tenen waliko Haeu kum aile uke.” ");
INSERT INTO ssg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary ukek, “Nga unaui Haeu tel Masiwi. Ewi i sohot hani nga masin ti o kakawen.” Ape tel engel salili i. ");
INSERT INTO ssg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Muhin Mary nahih kosea hani tehu taon ti leili Judia he maunten. ");
INSERT INTO ssg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","I nahih soh hani leili ingi Sakaraia ape i kak amuke Elisabet. ");
INSERT INTO ssg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ti Mary kakak tutuen, tel akaik leili tiai Elisabet pixewa. Ape Holi Spirit hanamiloa Elisabet kakain. ");
INSERT INTO ssg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ape i kak eliel hani Mary ukek, “Haeu aile hasolia hani o, akulai lawe hehin liai. Tin i aile hasolia hani tel akaik na o hatakaha. ");
INSERT INTO ssg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Lehe lahan ka tel tini tel Masiwi tetak nahih paxai nga? Se pate tuah wanen! ");
INSERT INTO ssg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nga tioi ka o tini tel Masiwi nake tel akaik leili tiak pix amuam hawane ti nga hongoa kakaiam. ");
INSERT INTO ssg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Haeu aile kola hani o lalape soliaian nake o hong soh ka i aile hawane waliko ti i kakawen.” ");
INSERT INTO ssg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary ukek, “Tupuak hatel hetekie namilok nga sameni hawane Haeu tel Masiwi. ");
INSERT INTO ssg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Pate nga amuam hawane nake Haeu tel awaiak ti lawe waliko lialun. ");
INSERT INTO ssg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","I kum maluhe nga ma i ngahati nga tel unauan kalak axak pate itan leili teka seilon. Seilon telok aope ie ma telok imuh laha ukek ka Haeu aile kola hani nga lalape soliaian. ");
INSERT INTO ssg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","I tel pate pohen ma i aile waliko lalap hani nga. I pate solian ma pate tuah xoini lawe seilon ma lawe waliko. ");
INSERT INTO ssg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","I aile kola tatahan tetan hani teka laha sameni ma hong tamani i leili teka seilon ti aope ie ma imuh. ");
INSERT INTO ssg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ti pohen i aile kilan waliko lalap ape i usi xaxaweni teka seilon ti hanasanas. ");
INSERT INTO ssg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Hina teka masiwi i hatapo laha ti neiniai seilon a teka seilon laha teheni aliake laha ti usiai namilon i aile laha seilon tuah. ");
INSERT INTO ssg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Haeu axi waliko solian hani teka pahalaha wanen usiai aweisalun ape i tua hanahi lioi teka laha kilan waliko ma pahalaha kum is usian. ");
INSERT INTO ssg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Haeu to huhuali teka seilon ti Israel, teteka unauan. ");
INSERT INTO ssg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","I namiloi i aile kola tatale tatahan hani Abraham ma teka laha nakuama tetan masin ti i kakanewen laha.” ");
INSERT INTO ssg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary to pangapang toluhu kapi Elisabet ape i nahih alia hani tonan. ");
INSERT INTO ssg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ti ape Elisabet pangapangaun kewa tepanim hinalo i hatakaha tel akaik wawan. ");
INSERT INTO ssg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Teka laha toto xohixohin kapin ma teka akikin hong waliko solian ti Haeu tel Masiwi aile hani Elisabet ape laha hatesol amuam akati i. ");
INSERT INTO ssg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Muhi puasain tehu ti tel akaik takahawa, teka akikin apuha ti ailei teik kikilam ti kotiai uli walikoi tel akaik ti kolakol ka i seilon ti Haeu. Pahalato uliai i Sakaraia masin axe tel taman. ");
INSERT INTO ssg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tuahe Elisabet kak eliel ukek, “Kumahe! Tel taman lehe i axai axan Jon!” ");
INSERT INTO ssg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Lato kakane Elisabet, “Tuahe tap tel akikim axan Jon.” ");
INSERT INTO ssg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lato kamei tel taman ax tetenen pahan i uliai hani tel natun. Lato tua hapuasa minalato nake i kum kak uke ape lato sokok ka tin i kum hong kakain. ");
INSERT INTO ssg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaraia aile kola ka pahan i tai waliko. Ti lato haniwa i teik patiu ti taiai kakain i tai ukek, “Axan Jon.” Lato hatesol ongaini hawane. ");
INSERT INTO ssg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lokon ien wanen Sakaraia pon i wix ulea ape i kak sameni Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Teka seilon laha toto xohixohin kapi Sakaraia ma Elisabet laha hatesol ong mamata hawane. Ape laha kaxi sawateni waliko tenen i sohot hani lalu hani teka seilon ti lawe toan he maunten ti leili Judia. ");
INSERT INTO ssg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Teka ti laha hongoa ien, laha to nanamiloi ape laha ukek, “Tel akaik ie liai i sohot tel seilon pate tuah nake Haeu tel Masiwi hoi kapin.” ");
INSERT INTO ssg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Muhin Holi Spirit hanamiloa Sakaraia tel tame Jon kaxiai tenen kakai Haeu ie, ");
INSERT INTO ssg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kako sameniwa Haeu tel Masiwi ti kako teka Israel. I tahiama ti hualiakako teka seilon tetan ma oxoxiakako ti kalabus ti saun lialun. ");
INSERT INTO ssg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","I haniwen kako Krais, tetel ti lalape pohen i awai kako ti kawatan ti lialui woukako. I kahi tel masiwi David, tel unaui Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Teka kuluiai kakai Haeu laha hani hatapo laha ti ailei puasan, laha kaxiwen ti kuewen waliko ti Haeu aile. ");
INSERT INTO ssg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","I awai kako ti teka laha watakai hawane kako. I huali kako na pahalaha aile halialuakako. ");
INSERT INTO ssg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","I aile kola tatahan hani teka tamakako ti matahaun nake i nameni ti i xinoti namil kapi lato ka i Haeu tel Masiwi ti lato ape lato seilon tetan. ");
INSERT INTO ssg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tenen kakain ien imat i kaxi haniwen Abraham tel tamakako. ");
INSERT INTO ssg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","I awai kako ti teka laha watakai hawane kako lehe kako aile puasan ma lotui i hetekie tap mamata. ");
INSERT INTO ssg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","I huali kako sohot seilon sawisawin ti usiai nauna tetan ma ti ailei lawe waliko ti i paxai waheni.” ");
INSERT INTO ssg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ape Sakaraia kakane tel natun ukek, “Tel natuk, o sohot tel kuluiai kakai Haeu. O hutui puasam imat ti Krais tel Haeu taloma ape o huali seilon ti apesenialaha ti sohotui Krais. ");
INSERT INTO ssg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","O kaxi hani teka seilon tewau aweisal ti Haeu awai laha ti kawatan ti lialui woulaha ma oxoxi laha ti kawatan ien. ");
INSERT INTO ssg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ti lalape tatahan ti Haeu, Krais luainima ti tone Haeu hani kapi kako masin sasai al. ");
INSERT INTO ssg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Masin xewan ti i haxewa tilokoan, Krais kaxi waliko salan hani teka seilon laha leili tilokoan ti lialui woulaha. Ape i neini kako lehe wasolakako ma Haeu i sawi.” Tataen ie Sakaraia tili kakaian. ");
INSERT INTO ssg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tel natun Jon lapale ape Holi Spirit hapohea i. I heheuta he lohong atengi tataen i kaxi ahuti kakai Haeu hani teka seilon ti Israel. ");
INSERT INTO ssg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lokon ien Augustus tel masiwi tapein ti Rom, hone teka unauan waxi hatapoi axe seilon ti Rom ma lawe xux hahitake ngahat ti Rom lehe i tioi mongohe seilon towiai moni hani Rom. ");
INSERT INTO ssg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tetehu se uli waxiai axe seilon. I po sosohotua lokon Kwirinius i tel masiwi ti texux xux Siria. ");
INSERT INTO ssg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Lawe seilon lua hani tone tamalaha hanai axalaha. ");
INSERT INTO ssg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aile ape Josep lua salili Nasaret leili Galili ape i nahih hani Betlehem leili Judia, taon tetehu tel masiwi David takah. Josep lua hana axan ien nake i nakuama ti tel masiwi David. ");
INSERT INTO ssg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep hakahita hetekie Mary, tel hehin laha otei haniwen axoan ape i hana ati axalalu. Lokon ien Mary hoi i petiwen akaik. ");
INSERT INTO ssg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lokon ti lalu Betlehem, taun tetan ti hatakahai tel akaik. ");
INSERT INTO ssg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ien uli hatakahai akaik tetan. Tel akaik ien se wawan. I puxui he teik maia ape i hanopi hani leili tone ani manihuh nake leili ing ti tone soliwa pate xuhan. ");
INSERT INTO ssg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ipong tehu ien hina seilon ngangahati sipsip xohixohin Betlehem, tetesol ti kilan pahoah solian. ");
INSERT INTO ssg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tel engel, spirit solian ti Haeu, i take hahutuia hani lato ape xewai Haeu i xeu kakalini lato. Pate lato mamata. ");
INSERT INTO ssg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tuahe tel engel hone lato ukek, “Kum maamata! Nga tahiakema meng solian ti hamuamuai lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hongoa! Ngain tetelao leili Betlehem, tehu taon ti tel masiwi David takah, tel awaiakaha i takahawen. I awai kaha ti kawatan ti lialui woukaha. I Krais tel Masiwi, tetel Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Amuto paxai tioi tel akaik na amuto tunahiwa i engeeng leili tone ani manihuh pupuxua leili maia.” ");
INSERT INTO ssg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tataen ien, kilan wanen engel ti Haeu take ulea hani kapi tel engel ien ape lato pak sameni Haeu ukek, ");
INSERT INTO ssg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Haeu, tel tonan patul wanen, i pate tuah ma pate solian! I aile hasolia wasolakaha hani i ma wasole teka seilon i amumuke!” ");
INSERT INTO ssg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ti teka engel alia haniwa tone Haeu, tesol ngahatiai sipsip he kakak alia puki lato, “Kako nahih hani Betlehem lehe kako paxai waliko ti i sohotuen masin ti tel engel ti Haeu tel Masiwi kakanewen kako.” ");
INSERT INTO ssg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Lato nahih kosea hani Betlehem ape lato tunahi Mary ma Josep hetekie tel akaik i engeeng leili tone ani manihuh. ");
INSERT INTO ssg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ti tesol ngahatiai sipsip ningahiwa tel akaik, lato kaxi hani teka seilon waliko ti tel engel kakanewen lato sale tel akaik ien. ");
INSERT INTO ssg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ti laha hatesol hongoa, laha ongake hawane. ");
INSERT INTO ssg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary nameni lawe waliko ti i sohotuen ape i to namiloi haweluwelu. ");
INSERT INTO ssg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tesol ngahatiai sipsip nahih alia hani kapi tupulato sipsip ape kak sasameni Haeu ti lawe waliko lato hongoen ma ningahiwen masin wanen ti tel engel kakanewen lato. ");
INSERT INTO ssg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Muhi ngain tepanim huohu ti tel akaik takahawa, teka masiwi ti teka Ju aile teik kikilam ti kotiai uli walikoun ti kolakol ka i seilon ti Haeu. Ape Josep uliai i Jises, tetenen ax ti tel engel uliaiwen imat ti i pet. ");
INSERT INTO ssg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ien taun ti Josep ma Mary aile saun ti haunialalu ti puli Haeu usiai nauna ti Moses. Aile ape lalu kau tel akaik hani Ingi Haeu leili Jerusalem ape lalu hani i hahitake ngangahat ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Masin ti teik kakain leili pepai Haeu tel Masiwi i ukek, “Lawe akaik wawan pamu laha selai haniwa ailei puase Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ape lalu hani Haeu huok pal ti lalu aile saun ti haunialalu ti pulan, usiwa nauna ti Moses. ");
INSERT INTO ssg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lokon ien tel seilon toto Jerusalem axan Simeon. Holi Spirit kakapiti i ape lawe i aile waliko sawisawin ti puli Haeu ma i usi hahatapo hatesol nauna tetan. Masin teka Ju liai, tin i monomon atengiai Krais tel Haeu taloma ti awaialato ma hualialato. ");
INSERT INTO ssg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ti imat Holi Spirit kola haxewa hani Simeon ka i kum matemu atengi i ningahiwa Krais, tel Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ti Mary ma Josep atoheniwa kokole Jises hani Ingi Haeu lehe lalu hani i hahitake ngangahat ti Haeu, Holi Spirit kapiti Simeon nahih haniwa ien. ");
INSERT INTO ssg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon akeni aumi kokole Jises ape i kak sameni Haeu i ukek, ");
INSERT INTO ssg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Haeu tel Masiwi, o puas usiwen kakaiam, aile ape namilok i heh hawanewen ape ewi na nga mat. ");
INSERT INTO ssg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Pake ti puki pulak wanen nga ningahiwen tel awaiamite, tetel i awai amite ti kawatan ti lialui woumite seilon. ");
INSERT INTO ssg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","O kilamiwen i tel awaiamite lawe seilon ti xux texux texux. ");
INSERT INTO ssg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","I masin xewai alon, i kaxi haxewa o hani teka seilon kumahe Ju ma i aile hasohotu teka Israel seilon pate tuah nake puki i nakuama ti lato.” ");
INSERT INTO ssg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Josep ma Mary hong ongaini hawane waliko ti Simeon kakak sale tel natulalu. ");
INSERT INTO ssg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ape Simeon kamei Haeu ti hanialalu soliaian. I hone Mary ukek, “Tel akaik ie Haeu kilamiwen, kilan seilon kum soh ka i Krais ape Haeu teheni ma paxai lioi laha. Ape kilan seilon liai laha soh ka i Krais ape Haeu namiloi ukek laha seilon tuah. Jises masin kolakol ti Haeu tuahe kilan seilon pahoxai i. ");
INSERT INTO ssg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Aweisal tewau ien Haeu hatakei namili hatesol seilon. Ape o Mary, moloan ma tatahan lalap wanen tunahi o masin ka tea ngol melomelon i tapuhi pele atem.” ");
INSERT INTO ssg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ana, tel hehin kuluiai kakai Haeu, i tin leili Ingi Haeu. I nati Panuel, akiki Aser tel nati Jekop tel matahaun ti lato. I hehin salaimat. I hina axoan leili ahang tepanim huohu. ");
INSERT INTO ssg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Muhin ti tel axoan matewa i tai sal ulea. Aope ie ahangun 84. Lawe i nahih hani Ingi Haeu. Ngain ma ipong lawe i lotu ma halini an ti hualiai lotu tetan. ");
INSERT INTO ssg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ti Simeon kak hatapoa, Ana nahih xohi hani kapi lato ape i kak kemulik hani Haeu ti Jises. Ape i kaxi sale Jises hani hatesol seilon ti laha monomon atengiai Krais tel Haeu taloma awaiai teka Israel ti kawatan ti lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ti Josep ma Mary aile hatapoa lawe waliko ti nauna ti Moses kakak, lalu alia hani tonalalu ti Nasaret leili Galili. ");
INSERT INTO ssg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ti ien Jises lap ape i kui. I uke anesoin ti sale aweisali Haeu ma Haeu aile kola soliaian hani i. ");
INSERT INTO ssg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lawe ahang tehu tehu ti taun ti Pasova, tel tame Jises ma tel tinan lalu lua hani Jerusalem nake ngain ti nameniai lokon Haeu waxi aliake teka Ju ti Igip. ");
INSERT INTO ssg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ti Jises ahangun kewa huopanim huohu, lato lua hani ien ti tehu Pasova usiwa saun ti teka Ju. ");
INSERT INTO ssg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tataen Pasova tapoa, lalu alia hahaniwa tonalalu tuahe Jises tutuen Jerusalem. Taman tinan kum tioi. ");
INSERT INTO ssg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Lalu sokok i kakahiti teka kilai seilon tuaulalu ape lalu lua tatalewa ngain hatehu. Ti ape alohah i tai tahiama kapi lalu ape lalu upia i leili teka akikilalu ma lohulalu. ");
INSERT INTO ssg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Lalu tai tunahi i ape lalu alia hani Jerusalem upiaian. ");
INSERT INTO ssg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ngain toluhu tamusua lalu tunahi i leili Ingi Haeu, toto kapi teka hanaui kakai Haeu ma saun ti teka Ju. I hongohong lato ma kakamei hina kamekame. ");
INSERT INTO ssg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tesol lato hongohong Jises, pate lato hong ongaini sale anesoan ti i kakak kapi lato. ");
INSERT INTO ssg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tel taman ma tel tinan pate lalu ongaini ti lalu ningahiwa i ien ape tel tinan hone i, “Jises, kalahai o aile hani amili ukek? Amili tel tamam to nanamiloi o ape amili puas lialu hawane upiaiam.” ");
INSERT INTO ssg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","I kak pahoi lalu ukek, “Ala amulu kum upiup nga! Ala amulu tioiwa ka nga ie ailei puase Haeu tel Tamak.” ");
INSERT INTO ssg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tuahe lalu kum hong xeu kakaian. ");
INSERT INTO ssg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jises kahiti aliake lalu hani Nasaret ape lawe i hong usi kakaialalu. Tel tinan namiloi kakapitini waliko ti i sosohot. ");
INSERT INTO ssg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jises lap hetekiele anesoin ti sale Haeu. Amukean ti Haeu ma ti seilon hani i to lap ahe tatalele. ");
INSERT INTO ssg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Leili ahang 15 ti Taiberius masiwi tapein ti Rom, Pontius Pailat i masiwi ti Judia, Herod Antipas i masiwi ti Galili, tel ukalan Pilip i masiwi ti Iturea ma Trakonitis ape Lisanias i masiwi ti Abilene. ");
INSERT INTO ssg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas ma Kaiapas lalu hauhua masiwi tapein ti hukuminiai Haeu ma seilon. Lokon ien Jon tel nati Sakaraia toto he lohong. Haeu hani i kakaian lehe i kaxi ahuti hani teka seilon. ");
INSERT INTO ssg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ape Jon nahih hani tesol tesol ti pape kan Jodan. I kaxi hani teka seilon ka laha uke baptais na laha towiahu ti lialui woulaha hani Haeu lehe i oxoxi laha ti kawatan ti saun lialun ti laha. ");
INSERT INTO ssg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","I seilon tetel Aisaia tel kuluiai kakai Haeu kakaxi ti kuewen, i ukek, “I titilol he lohong, ‘Towiahua ti lialui woumuto lehe tel Masiwi neini amuto taen i tahiama! ");
INSERT INTO ssg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Towiahu haniwa Haeu ma teheniwa amuto lehe i kapiti hasolia amuto! Hasawiwa namilomuto ti hasoliai wasolamuto ma Haeu hanowi ti laha taneni aweisal suxasuxan lehe nanahihi soli. ");
INSERT INTO ssg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ape lawe seilon paxai tioi sale Haeu awai laha ti kawatan ti lialui woulaha.’” Ie tiliai kakai Aisaia ti i kak kilami sale Jon. ");
INSERT INTO ssg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ti kilai seilon nahih haniwa kapi Jon lehe i baptaisi laha, i hone teka woinakon pahalaha lehe laha towiahu ti lialui woulaha, “Amuto lehomuto huoka! Aita hone amuto ka amuto salia uke ti kawatan ti na Haeu hani amuto? ");
INSERT INTO ssg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ailewa saun tenen ti i kola ka amuto lioiwen saun lialun. Kum ukekek ka amuto salia uke ti kaui kawatan nake amuto nakuama ti Abraham. Nga kakane amuto, Haeu pon kolitiniai tesol pot ie hani kahi nati Abraham! ");
INSERT INTO ssg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Haeu apeseniwen tea ngolapung. Pata tenen i kum hua alua, i koti hamahusu ape i towi lui hani leili ah.” ");
INSERT INTO ssg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Teka seilon kamei i, “Ape amite aile la?” ");
INSERT INTO ssg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","I pahoi laha ukek, “Teka ti amuto na puxuaumuto huohu, tehu haniwa tel na i tap wanen ape na amuto hina an, sei axiwa teka laha hihitol.” ");
INSERT INTO ssg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tataen teka seilon ti waxiai moni ti teka Ju hani teka masiwi ti Rom, tin laha nahima lehe Jon baptaisi laha. Ape laha kamei i, “Tel masiwi, amite aile la lehe amite salia ti kawatan ti Haeu?” ");
INSERT INTO ssg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","I hone lato, “Kum pupuluti teka seilon. Kum waxi hahasea moni lapan ti teka masiwi kilamiwen.” ");
INSERT INTO ssg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ape teka seilon ti hile tin laha kamei i, “A amite ape lahan? Amite aile la?” I hone aliake lato, “Kum lulungei seilon waxiai moniulaha. Kum hahamatau laha ka amuto aile halialu laha ma na amuto sului laha na laha kum hani amuto moni. Amukewa lape kahumuto ti amuto kewen.” ");
INSERT INTO ssg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jon tioi ka kilan ti teka Ju laha to monomon atengiai Krais, laha sokok ka i uke tetel Krais Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ape Jon kakane laha, “Nga baptaisi amuto ani kan tuahe tel i luluainima muhik, taen i baptaisi amuto i hani amuto Holi Spirit ti kapitiamuto. I pamu masiwian tetak. Masiwiaian ala i kum pon nga unauan. ");
INSERT INTO ssg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","I hiniti seilon masin tel na i hapuasa nuhinuh ti i selai api ti penun. I apuhini api wanen ape i lui xoini penun.” ");
INSERT INTO ssg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon hapuasa kakain tenen tenen ti kaxi haxewai meng solian ti Jises Krais hani teka seilon ape i kak eliel ka laha hong tamaniwa kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tin i kak nanami Herod tel masiwi ti Galili nake i waxi axoan Herodias, axoi tel ukalan, ma i aile hakilawen saun lialun. ");
INSERT INTO ssg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Muhin Herod aile ulea tenen saun lialun, i hana Jon hani kalabus. ");
INSERT INTO ssg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ngain tehu ti Jon baptaisi teka seilon, tin i baptaisi hetekie Jises. Leilon ti Jises lolotu, maun hea. ");
INSERT INTO ssg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Lokon ien Holi Spirit mos hani kapin hanowi tok pux. Ape tenen kinax wixima ti tone Haeu i ukek, “O se Natuk pate nga waheni, nga amuke hawane o.” ");
INSERT INTO ssg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ti Jises hutui ailei puasain tenen Haeu kilamiwen i ailean, ahangun sai 30. Jises nati Josep. Ti Jises he tehu pon ie teka seilon namiloi ukek ka i tel nati Josep. Josep tel nati Heli. ");
INSERT INTO ssg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli nati Matat. Matat nati Livai. Livai nati Melki. Melki nati Janai. Janai nati Josep. ");
INSERT INTO ssg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep nati Matatias. Matatias nati Amos. Amos nati Nahum. Nahum nati Esli. Esli nati Nagai. ");
INSERT INTO ssg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nati Maat. Maat nati Matatias. Matatias nati Semein. Semein nati Josek. Josek nati Joda. ");
INSERT INTO ssg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda nati Joanan. Joanan nati Resa. Resa nati Serubabel. Serubabel nati Sealtiel. Sealtiel nati Neri. ");
INSERT INTO ssg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri nati Melki. Melki nati Adi. Adi nati Kosam. Kosam nati Elmadam. Elmadam nati Er. ");
INSERT INTO ssg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nati Josua. Josua nati Elieser. Elieser nati Jorim. Jorim nati Matat. Matat nati Livai. ");
INSERT INTO ssg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai nati Simeon. Simeon nati Juda. Juda nati Josep. Josep nati Jonam. Jonam nati Eliakim. ");
INSERT INTO ssg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim nati Melea. Melea nati Mena. Mena nati Matata. Matata nati Natan. Natan nati David. ");
INSERT INTO ssg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David nati Jesi. Jesi nati Obed. Obed nati Boas. Boas nati Salmon. Salmon nati Nason. ");
INSERT INTO ssg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nati Aminadab. Aminadab nati Ram. Ram nati Hesron. Hesron nati Peres. Peres nati Juda. ");
INSERT INTO ssg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda nati Jekop. Jekop nati Aisak. Aisak nati Abraham. Abraham nati Tera. Tera nati Nahor. ");
INSERT INTO ssg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor nati Serug. Serug nati Reu. Reu nati Peleg. Peleg nati Eber. Eber nati Sela. ");
INSERT INTO ssg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela nati Kainan. Kainan nati Arpakad. Arpakad nati Sem. Sem nati Noa. Noa nati Lamek. ");
INSERT INTO ssg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek nati Metusela. Metusela nati Enok. Enok nati Jared. Jared nati Mahalalel. Mahalalel nati Kenan. ");
INSERT INTO ssg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan nati Enos. Enos nati Set. Set nati Adam ape Adam nati Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Muhin ti Jises baptais kewa, i nahih salili tehu kan Jodan. Holi Spirit hapohea i ape kapiti i hani he lohong. ");
INSERT INTO ssg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ti ien Satan tohongi haputaian. Jises tai angiang leili 40 ngain ape pate i hitol. ");
INSERT INTO ssg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satan hone i, “Na o tel Nati Haeu, kolitiniwa tehu pot ie haniwa bret.” ");
INSERT INTO ssg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jises pahoi i ukek, “Kakai Haeu ukek, ‘Seilon ala i hana hatapo namilon hani kakai Haeu kumahe an.’” ");
INSERT INTO ssg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satan hakahita i hani patul tehu maunten ape kola hani i hatesol xux ti itan ie lape tehue. ");
INSERT INTO ssg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Satan kakane i, “Nga hani hatapo o lawe soliai waliko ti hatesol xux ie ma nga hana o masiwi ti laha nake Haeu haniwen he minak ape nga pon haniai tuahe tel na pahak. ");
INSERT INTO ssg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Lawe waliko ie tetam na masin o lokuha lotui nga.” ");
INSERT INTO ssg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jises kak pahoi i, “Kakai Haeu ukek, “‘Lotuiwa mewenae Haeu tel Masiwi ma ailewa mewenae puasan.’” ");
INSERT INTO ssg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Muhin Satan hakahita Jises hani Jerusalem ape hatuhi i he teik tumi Ingi Haeu patul wanen. Ape kakane i, “Na o tel Nati Haeu, tit haniwa itan. ");
INSERT INTO ssg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pake kakai Haeu i ukek, “‘Haeu talo teka engel tetan ti awaiam ma ngahatiam. ");
INSERT INTO ssg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ape lato akeni o he minalato lehe pot kum hamange o kalak taen aem.’” ");
INSERT INTO ssg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jises pahoi i ukek, “Tuahe kakai Haeu tin i ukek, ‘Kum totohongi Haeu tel Masiwi tetam.’” ");
INSERT INTO ssg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ti Satan tohongi kewa Jises, i nahih salili i atengi tehu taun solian tetan. ");
INSERT INTO ssg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jises alia hani Galili hetekie xuhai pohe Holi Spirit. Meng ti sale Jises sawata hani lawe toan ma taon ti Galili. ");
INSERT INTO ssg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","I hanau teka seilon sale Haeu leili synagog, ing ti apuhai teka Ju, ape kilan seilon amuke i. ");
INSERT INTO ssg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Muhin ien Jises tahia hani Nasaret, tehu taon ti i lapale. Telao Sabat i nahih hani tehu synagog hanowi ti lawe i ailele. I tule lehe i ridai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ape laha hani i teik pepai Aisaia, tel kuluiai kakai Haeu. I holaiwa teik pepa ape i onoteni tesol ti i ukek, ");
INSERT INTO ssg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Spirit ti Haeu tel Masiwi i kapik nake i kilamiwen nga kaxi ahutiai meng solian ti Haeu hani teka laha tae ti usiai aweisali Haeu. I taloma nga hetekie kakain ka nga ahutiai teka kalabus ma oxoxiai seilon ti kawatan ti lialui woulaha. Nga haewia teka pulaxa ma haxewa seilon ti sale aweisali Haeu. Nga awai seilon ti teka liai aile halialu laha. ");
INSERT INTO ssg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tataen ien teka seilon tioi ka taun ti Krais i tahiawen ape Haeu aile kola lape soliaian hani laha.” ");
INSERT INTO ssg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jises lumini aliake teik pepa. I hani tel hualiai ailei lotu ape i to. Lawe seilon leili synagog paxai kapitini i. ");
INSERT INTO ssg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","I kakane lato, “Teik kakai Haeu amuto hongoen aope ie, i sohot poponowi hawane tetelao.” ");
INSERT INTO ssg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Teka seilon ien kak amuke i ma sameni soliai kakaian. Tuahe teka ti laha kakak alia puki laha ukek, “I se tetel nati Josep. I sohot ukek ia ka i Krais?” ");
INSERT INTO ssg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","I hone laha, “Nga sixi ka lehe amuto hone nga ukek, ‘Kolawa pohem. Ailewa waliko tenen lalap puki leili tonam masin ti amite hongohong o ailewen leili Kapenaum.’” ");
INSERT INTO ssg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jises kak ahe ukek, “Tuahe nga kakane hawane amuto, ti toan liai seilon sameni tel kuluiai kakai Haeu tuahe ti puki tonan wanen laha wiliki i. Ien se masin ti i sohot hani nga. ");
INSERT INTO ssg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Salan lokon ti Elaija tel kuluiai kakai Haeu, kilan hehin ti Israel axoalaha matewen, pahalaha huhual nake tap akah leili ahang toluhu tewaok ape seilon lialu hahawane ti hitolo leili xux hatexux. ");
INSERT INTO ssg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tuahe Haeu tai talo Elaija hualiai teka hehin ien. I talo non hani tel hehin kumahe Ju axoan matewen, i toto Sarepat xohixohin kapi tehu taon lalap axan Saidon. ");
INSERT INTO ssg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tin masin lokon ti Elaisa, kilan wanen seilon ti Israel naxe tinulaha lialun, pahalaha huhual tuahe Elaisa tai haewia laha, i haewia non Naman tel kumahe Ju, i ti texux xux Siria.” ");
INSERT INTO ssg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ti teka Ju leili tehu synagog hongoa, lolaha lialu hawane. ");
INSERT INTO ssg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kakanua laha itini ahuti Jises hani melal ti Nasaret ape hakahita i hani ngixi tehu maunten kokol. Laha namiloi na laha sipeli i hani he sahikek. ");
INSERT INTO ssg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tuahe Jises non alia wasole teka kilai seilon ape i nahih salili laha. Tap tel hamangewen i. ");
INSERT INTO ssg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Muhin ien Jises nahih hani Kapenaum, tehu taon leili Galili. Telao ngain Sabat i hanau teka seilon leili tehu synagog. ");
INSERT INTO ssg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pate laha ongake sale kakaian nake masin kakai tel masiwi wanen. ");
INSERT INTO ssg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ti leili synagog, tel seilon spirit lialun kapiti hahalialu, i tilol leng ausisini, ");
INSERT INTO ssg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jises ti Nasaret, paham la ti amite? Nakon o ie ti halialuamite? Nga tioi o tel seilon sawisawin Haeu taloma!” ");
INSERT INTO ssg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jises tumei spirit lialun ukek, “Minginiwa awam ape ahuta xaxaua ti tel seilon ie!” Spirit lialun towi xoini tel seilon hani itan ti puli lawe seilon tuahe i tai mange. Ape spirit lialun ahuta salili i. ");
INSERT INTO ssg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hatesol seilon hong ongake ape laha kakak alia puki laha, “Nakon waliko la tetenen? Masiwian ma pohen i ke nonoma ia ka spirit lialun hong tamani i ape lato ahuta xaxau?” ");
INSERT INTO ssg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Menge waliko ti Jises ailele sawata hani tesol tesol ti ien. ");
INSERT INTO ssg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jises nahih salili synagog ape i nahih hani ingi Saimon. Tini tel axoi Saimon tinun pate ahian ape teka seilon ien kamei eliel Jises haewian. ");
INSERT INTO ssg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jises tu pape enepe tel tinun ape i tumei xaxaweni nax. Ti naxe tinun tahawa, tel hehin xahat hahutuia ape i apeseni analato. ");
INSERT INTO ssg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ti ape alohah laha hakahita teka hina nax tenen tenen hani kapi Jises. I hana minan patul ti laha tel tel ti haewialaha ape laha ewi. ");
INSERT INTO ssg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Teka ti laha spirit lialun kapiti hahalialu. Kakai Jises tehue ape spirit lialun ox ahuta titilol, “O tel Nati Haeu!” Jises watakai teka spirit lialun kaxi hani teka seilon ka i Krais, aile ape i halini na lato kaxi. ");
INSERT INTO ssg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pate letu Jises nahih salili tehu taon ape i nahih hani tesol ti tap seilon. Teka seilon to upiup i ape ti laha tunahiwa, laha hakongu i ka kum nahih sasalili laha. ");
INSERT INTO ssg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tuahe i hone laha, “Meng ti Haeu neini seilon tin nga kaxi hani toan ma taon liai nake Haeu taloma nga ailei teik puasain ien.” ");
INSERT INTO ssg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ape i kaxi ahuti tatale kakai Haeu hani teka Ju leili synagog ti Judia. ");
INSERT INTO ssg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ngain tehu Jises tutu peixux ti kanitax Galili ape kilan seilon pungei hapisipisi i hongoi kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","I ningahi hua koap peixux tetesol teka seilon ti telei xixi mos saliliwen ape lato nunuhi upen. ");
INSERT INTO ssg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jises ku haniwa he tea koapai Saimon ape hone i uhi siainiai teik tea koap. Jises to ape i hanau teka seilon. ");
INSERT INTO ssg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ti i kak kewa, i hone Saimon, “Sulini tea koap haniwa sai ilam ape o ma tesol mahoam haputawa upen puliai xixi.” ");
INSERT INTO ssg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon pahoi i ukek, “Tel masiwi, amite puas eliel hawanewen ipong hatehu tuahe tap onamite. Tuahe nake o kak ukek ien, amite haputa ulea upen.” ");
INSERT INTO ssg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Lato haputawa ape lato tiuk kila hawane xixi moxemoxe tehu upen xaputa. ");
INSERT INTO ssg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lato alohi teka tuaulato he tea koap liai hualialato. Lato hatesol lohi haxuhaxuha xixi hani koap hauhua ape sikole lalu kaxox. ");
INSERT INTO ssg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ti Saimon Pita ningahiwa tenen waliko i sohot ien, i lokuha mateiwai Jises hetekie mamata ape i ukek, “Tel Masiwi, siawa tetak nake wouk pate lialun!” ");
INSERT INTO ssg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","I kak ukek ien nake i ma tesol liai ongake hawane mongohe xixi lato tikewen. ");
INSERT INTO ssg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hua tuaun Jeims ma Jon, nati Sebedi tin lalu ongake hawane. Ape Jises hone Saimon, “Kum maamata! Tataen ie ahua, ape o tiuk seilon hani kahikahik!” ");
INSERT INTO ssg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ti lato uhi koap hanile ixux, lato hana lioi hatesol waliko ti lato ape kahiti Jises. ");
INSERT INTO ssg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Telao Jises leili tehu ti tesol taon ape tel seilon naxe tinun lialun nahih hani kapin. I lokuha hana kawan itan ape i kamei eliel Jises, “Tel masiwi, na o waheni, xaxaweniwa naxe tinuk lehe nga hau alia.” ");
INSERT INTO ssg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jises tulini aka soti tel seilon. I ukek, “Nga waheni, ewiwa ma haua!” Tataen ien wanen tenen nax salili i. ");
INSERT INTO ssg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jises hone i, “Kum kaxi hahani teka seilon liai. Nahih sawi haniwa kapi tel masiwi ti hukuminiai Haeu ma seilon lehe i paxai kalisi tinum. Kau hetekiewa huok manixux ti haniai Haeu masin ti Moses kakawen. Ien kola haniai teka seilon ka o ewiwen ape pon o hukuma hani kapi laha.” ");
INSERT INTO ssg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tuahe meng ti sale puase Jises sawat ahe tatale hani tesol tesol ape kilan seilon nahih hani kapin hongoi kakaian ma lehe i haewia laha. ");
INSERT INTO ssg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Leili pupuasan hina ngain Jises nahih hani tesol mewenae i lehe i lotu. ");
INSERT INTO ssg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ngain tehu ti Jises hahanau teka seilon, teka Parisi ma teka hanaui nauna ti Moses laha toto ien. Laha luama ti Jerusalem, Judia ma kilan toan ti Galili. Haeu tel Masiwi hapohea Jises ti haewiai teka tinun. ");
INSERT INTO ssg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ape teka seilon kau hani i tel seilon tupuan maten engeeng he sau. Lato sisixeh hani kapi Jises. ");
INSERT INTO ssg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tuahe lato kum pon nake husele kilai seilon. Aile ape lato haneke i hani hongin. Lato hawawai ape halahe i he tehu enepan hani wasole teka seilon mateiwai Jises. ");
INSERT INTO ssg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jises tioi namilolato xoxoan ka i pon haewian ape i hone tel tinun, “Tel natuk, nga oxoxi o ti kawatan ti lialui woum.” ");
INSERT INTO ssg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Teka Parisi ma teka hanaui nauna ti Moses laha he kakak alia puki laha, “Kalahai i kak ukek? I kak hanowi i Haeu! Aita pon oxoxiakako ti kawatan ti saun lialun? Mewenae Haeu!” ");
INSERT INTO ssg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jises tioi namilolaha ape i hone laha, “Nakon lahan amuto namiloi namil tenen ien? ");
INSERT INTO ssg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tetenen ia pamu malimuan? Nakon pamu malimun na nga hone tel seilon tupuan maten, ‘Xahatawa ape nahiwa,’ ka ‘Nga oxoxi o ti kawatan ti lialui woum’? Ti ailei hahuonen, mewenae seilon ti hina pohe Haeu i pon ailean. ");
INSERT INTO ssg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nga aile kola lehe amuto tioi ka nga tel Nati Seilon, he tehu pon ie nga hina poh oxoxiai seilon ti kawatan ti saun lialun ti laha.” Ape i hone tel seilon tupuan maten, “Nga hone hawane o, xahatawa, waxiwa enepam ape nahih haniwa tonam nake ape o ewiwen!” ");
INSERT INTO ssg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tuhan tehue tel seilon xahat waxiwa enepan. Ti i nahih hahaniwa tonan i sameni amumuke Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Laha hatesol ong mamata pohe Haeu. Laha sasameni Haeu ukek, “Waliko tenen lalap kako paxaiwen tetelao!” ");
INSERT INTO ssg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Muhin Jises nahih salili tehu taon ape i ningahi Matiu Livai, i to wawaxi moni ti teka seilon. Pupuasan waxiai moni ti teka Ju ti haniai teka masiwi ti Rom. Jises hone i, “Kahitima nga. Pahak o kahikahik.” ");
INSERT INTO ssg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Livai tule, i lioi lawe waliko ape kahiti i. ");
INSERT INTO ssg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Imuh Livai aile tehu angiain lalap hani Jises leili ingan. I ilowi teka tuaun puasalaha masin puasan ma teka seilon liai. ");
INSERT INTO ssg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tuahe teka Parisi ma teka hanaui nauna ti Moses laha kahiloloi teka kahikahi Jises, laha ukek, “Kalahai amuto ang ma un akati teka waxiai moni ti teka puki akikilaha ma teka woulaha lialun?” ");
INSERT INTO ssg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jises hone laha, “Dokta kum puasake seilon huliwi, mewenae teka tinun. ");
INSERT INTO ssg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kumahe ka nga he tehu pon ie upiai kahikahik seilon tenen laha sokok laha sawisawin. Nga tahiama upiai kahikahik seilon tenen laha tioi ka woulaha lialun.” ");
INSERT INTO ssg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Teka seilon kamei Jises, “Nakon lahan tesol kahikahim lato kum halini an ti hualiai lotu ti lato hanowi tesol kahikahi Jon Baptis ma tesol kahikahi teka Parisi?” ");
INSERT INTO ssg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jises kak pahoi lato, “Na tel seilon i sal i kapi tesol seilon ti laha ilowi ti angiain ti salasala, kaie lato kum ang? Kumahe! Lato ang akati i. ");
INSERT INTO ssg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tuahe ngain tehu i luluainima, laha waxi xaxaweni tel seilon i sal ti lato ape tataen ien lato halini an.” ");
INSERT INTO ssg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jises kak kolongeni hani lato ukek, “Tap tel ukeke teik maia haun paxatawaiai teik maia wasan. Na i aile ukek ien, teteik haun i lexi teik wasan ape wawan i lap ahe. ");
INSERT INTO ssg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Seilon kum lohi hahakila patula wel hani tehu po wasan nake na i lauti, tehu po i watat ape patula tapulol. ");
INSERT INTO ssg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pamu ewian na i lohi hani he tehu po haun lehe ati lalu kum lialu. ");
INSERT INTO ssg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Tuahe kilan seilon laha waheni usiai saun ma nauna wasan nake laha namiloi ukek ka saun ma nauna wasan pamu soliaian.” ");
INSERT INTO ssg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Telao ngain Sabat Jises nahih kokotiwa tesol kini kon hetekie tesol kahikahin. Ape tesol kahikahin asahi ani huai kon. ");
INSERT INTO ssg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Teka Parisi kamei, “Nakon lahan amuto aile saun tenen hahalin ti telao ngain Sabat?” ");
INSERT INTO ssg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jises pahoi lato, “Oheak amuto tai hong xeu waliko ti tel masiwi David ma tesol lawan aile ti pate lato hitol? ");
INSERT INTO ssg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I nahih soh hani Ingi Haeu ape i waxi bret hahalin. Mewenae teka masiwi ti hukuminiai Haeu ma seilon pon anian. Tuahe i ma tesol lawan ani.” ");
INSERT INTO ssg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ape Jises tili kakaian, “Nga tel Nati Seilon, nga se Masiwi ti Sabat. Nga tel sowini haniai seilon waliko tenen i pon ma na i kum pon laha aile telao ngain Sabat.” ");
INSERT INTO ssg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tehu ngain Sabat liai Jises nahih hani tehu synagog ape i hanau teka seilon kakai Haeu. Ti ien tel seilon minan tepaun manau maten. ");
INSERT INTO ssg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Teka hanaui nauna ti Moses ma teka Parisi laha sasakal aweisal ti suluiai Jises. Aile ape laha paxai otioti na i aile haewia tel seilon lehe laha sului i ti ailei waliko tenen laha hahalini telao Sabat. ");
INSERT INTO ssg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tuahe Jises tioiwen namilolaha ape i hone tel seilon minan maten, “Tua ape nahih hanima mateiwa ie.” Ape tel seilon nahih hani kapin. ");
INSERT INTO ssg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jises hone laha, “Nga hina tenen kamekame hani amuto. Nakon saun la ewi na kako aile telao Sabat? Saun ti hasoliai seilon ka halialualaha? Saun ti hualiai seilon ka hamangealaha?” ");
INSERT INTO ssg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","I pax kakalini laha hatesol ape i hone tel seilon, “Hokahiwa minam.” I aile usi ape tepaun minan i ewi. ");
INSERT INTO ssg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Teka hanaui nauna ti Moses ma teka Parisi lolaha manomano hawane ape laha he kakak alia puki laha sale aile halialui Jises. ");
INSERT INTO ssg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lokon ien Jises nahih lotu hani he maunten ape i kakak kapi Haeu ti ipong hatehu. ");
INSERT INTO ssg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ti i letule, i tiloi hatesol kahikahin. I kilami huopanim hua ti leilolato ape axai lato aposel. Axalato ie: ");
INSERT INTO ssg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon tel i axai Pita ma tel ukalan Andru, Jeims, Jon, Pilip, Batolomiu, ");
INSERT INTO ssg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu, Tomas, Jeims tel nati Alapeus, Saimon tetel axan liai Selot, ");
INSERT INTO ssg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas tel nati Jeims ma Judas Iskariot, tetel seilon imuh i hangaini Jises. ");
INSERT INTO ssg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Muhin ti Jises ma teka kahikahin mos aliawa he maunten, i tu teke nahonahon ape teka kilai kahikahin ma kilai seilon liai tu kalini i. Teka seilon ien laha ti Judia, Jerusalem ma taon Taia ma Saidon xohixohin peixux. ");
INSERT INTO ssg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Laha luama hongoi kakaian ma kameiai Jises ti haewiai teka tinun. Teka ti spirit lialun kapiti hahalialu, i xaxaweni spirit lialun ti leilolaha. ");
INSERT INTO ssg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Lawe seilon ien tohongi sotiai Jises nake Haeu hapohea i haewiai teka seilon tinun. ");
INSERT INTO ssg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jises paxai teka kahikahin ape i kakane laha hatesol, “Haeu aile hasolia hani teka pahalaha wanen i neini ma ngahati laha. ");
INSERT INTO ssg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Haeu aile hasolia hani teka pahalaha isian wanen usiai namilon. Laha pono ti lawe waliko. Haeu axi waliko solian hani teka laha toto ti tatahan. Haeu hasoli laha ape laha amuam ulea. ");
INSERT INTO ssg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Haeu aile hasolia hani teteka seilon teka liai watakai hawane, kak saxuti laha ma hana laha kaliap nake laha kahikahik wanen. ");
INSERT INTO ssg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Amukewa na tenen ien sohot hani amuto ape tautit amuamua nake kahumuto solian Haeu apeseniwen patul leili tonan. Nameniwa ka teka kuluiai kakai Haeu ti matahaun tin laha kauen kawatan ti teka seilon aile halialu laha. ");
INSERT INTO ssg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Tuahe Haeu axi kawatan hani teka pahalaha kum is i neini ma ngahati laha. Haeu kum axi laha waliko solian nake laha ukek laha pono ti lawe waliko ti aope ie. ");
INSERT INTO ssg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Haeu axi kawatan hani teka pahalaha kum is usiai namilon. Laha tae ti lawe waliko. Haeu axi kawatan hani teka namilolaha mewenae ti hamuamuaialaha. Imuh laha tunahi tatahan ma tangitangi. ");
INSERT INTO ssg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Haeu axi kawatan hani teka pahalaha wanen seilon sameniwa laha. Ien masin teka woinakon ka kuluiai kakai Haeu teka seilon ti matahaun sasameni.” ");
INSERT INTO ssg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jises kak tatale, “Nga kakane amuto teka amuto hongohong nga, waheniwa teka laha pahoxai amuto ma ailewa saun solian hani laha. ");
INSERT INTO ssg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kameiwa Haeu axiai waliko solian hani teka laha sai halialu amuto ma kameiwa i hualiai teka laha aile halialu amuto. ");
INSERT INTO ssg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Na tel seilon aile hani amuto saun tenen pate hahien, kum aile kahui aliliake. Tiliwen i aile tuhi ulea. Na tel seilon waxi lungei tehu puxuaumuto, hani palahiwa i tehu liai. ");
INSERT INTO ssg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Axiwa laha waliko na laha kamei amuto. Na tel xuina waliko ti amuto, kum lungelung waxi aliakean. ");
INSERT INTO ssg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Aile haniwa seilon liai masin ti pahamuto laha aile haniwa amuto. ");
INSERT INTO ssg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Haeu kum kahui hasolia amuto na amuto waheni mewenae teka seilon ti laha waheni amuto. Kalak teka seilon ti ailei saun lialun, lato waheni teka seilon ti laha waheni lato. ");
INSERT INTO ssg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A na masin amuto aile saun solian mewenae hani teka laha aile saun solian hani amuto, kalahai lehe Haeu kahui hasolia amuto? Kalak teka seilon ti ailei saun lialun, tin laha ailele tenen ien. ");
INSERT INTO ssg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Haeu kum sameni amuto na amuto axi moni mewenae hani teteka ti amuto pon waxi aliakean. Kalak teka seilon ti ailei saun lialun, laha axi kakali moni hani teteka ti i pon hani hahamahuli aliake laha. ");
INSERT INTO ssg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Tuahe amuto kewa liai tenen ti laha. Waheniwa teka seilon laha watakai amuto ma ailewa saun solian hani laha. Axiwa seilon moni ape kum amemene lehe laha aliake hani amuto. Na amuto aile ukek ien, i kola ka amuto salan wanen nati Haeu ape Haeu kahui halapa hani amuto. Aile kolawa solian ti amuto haniwa teka laha watakai amuto nake Haeu tin i aile kola soliaian hani teka seilon lialun ma teka laha kum nam waxi soliaian. ");
INSERT INTO ssg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kewa amuto aile kola tatahan hani seilon liai hanowiwa tel Tamamuto Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kum kak hahalialu woi seilon liai lehe Haeu kum lengeini halialu amuto. Kum tieni hahalialu seilon liai lehe Haeu kum namiloi ukek ka amuto uke kawatan ti woumuto. Oxoxiwa seilon liai ti kawatan ti lialui woulaha hani amuto lehe Haeu tin i oxoxi amuto ti kawatan ti lialui woumuto. ");
INSERT INTO ssg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Amuto kewa ongawi lehe Haeu aile hasolia hawane hani amuto. Saun ti amuto aile hani seilon liai tin Haeu aile aliake hani amuto.” ");
INSERT INTO ssg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ape Jises kak haxewa hani teka seilon ukek, “Na tel seilon pulaxa ati tel pulaxa liai, ati lalu put hani leili wal. Teka masiwi laha kum usi nauna tetak, laha masin tel seilon pulaxa neneini tel pulaxa liai. Kum hahanowi ti laha. ");
INSERT INTO ssg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tap tel seilon xoini tel hanauan. Na masin tel hanauan hanau aluini tel kahikahin, tel kahikahin ien i sohot hanowi tel hanauan. ");
INSERT INTO ssg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Na amuto kahikahik, kum hahanowi teka seilon laha kak halialu woi seilon liai a laha kum paxai tioi puki lialui woulaha. Laha masin teka seilon laha ningahi teik masiap kokol he puli tel seilon liai a laha kum paxai tioi teik masiap lalap he puki pulalaha. ");
INSERT INTO ssg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Amuto kum hone uke tel seilon liai, ‘Hanima nga xaxaweni teik masiap kokol he pulam’ na masin puki amuto teik masiap lalap he pulamuto. Seilon tenen lehomuto huoka! Amuto xaxawenimua teik masiap lalap he pulamuto ape muhin ien amuto paxapax alua ti xaxaweniai teik masiap kokol he puli tel seilon liai.” ");
INSERT INTO ssg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jises hanau tatale teka seilon ukek, “Pata tenen solian, huan kumahe lialun. Pata tenen lialun, huan kumahe solian. ");
INSERT INTO ssg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Amuto paxai tioi pata na amuto paxai huan. Au kum hahuama huai laku ma koila kum hahuama huai maia. ");
INSERT INTO ssg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tin masin seilon solian i ahuti kakain solian nake namilon solian. Ape seilon lialun i ahuti kakain lialun nake namilon lialun. Ie se salan wanen nake kakain ti seilon ahuti i ahutama ti namilon.” ");
INSERT INTO ssg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ape Jises kak tatale ukek, “Kalahai amuto axai nga Masiwi na amuto kum hong tamani kakaiak? ");
INSERT INTO ssg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tuahe tel na i hong ma puas usi kakaiak nga kaxi haxewa hani amuto i seilon tetenen. ");
INSERT INTO ssg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I masin tel seilon i tahiwi hatahulou hepekeun ailan tuhi kukueun ti i atai tehu ingan. Na kanitax som ape wei tehu ingan, i kum manan nake tutuhan xoxoan. ");
INSERT INTO ssg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Tuahe tel seilon i hong kakaiak a kum puas usi, i masin tel seilon i atai ingan he hepekeun wakiakin ape kukui ingan waxuexuen. Ti weu wei tehu ingan i tua mahus. Malehe ape lialui mananaian!” ");
INSERT INTO ssg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ti Jises ahuti hatapoa kakaian haniwa teka seilon, i alia hani tehu taon Kapenaum. ");
INSERT INTO ssg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ti ien tel masiwi ti hile ti Rom. Tel unauan tuah pate tinun sikole i mat. ");
INSERT INTO ssg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ti tel masiwi hongoa sale puase Jises, i talo teka masiwi ti teka Ju kameiai Jises ka nahima haewia tel unauan. ");
INSERT INTO ssg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lato nahih hani kapi Jises ape kamei eliel i, “Kahitima amite ape hualiwa tel masiwi ti hile nake i tel seilon solian tapai hawane ti o huali. ");
INSERT INTO ssg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","I waheni hawane kako teka Ju ape i hatuhi tehu synagog hani amite ti Kapenaum.” ");
INSERT INTO ssg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ape Jises nahih kahiti lato. Tuahe imat ti lato tahia, tel masiwi ien talo teka lohun kakanean. Lato hone Jises, “Tel masiwi ukek, ‘O pate masiwi kasia ti na o nahih hanima leili ingak. ");
INSERT INTO ssg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aile ape puki nga kum nahima kakaneam. O tua kakawa ape tel unauak i ewi. ");
INSERT INTO ssg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nga kak ukek nake tin hina seilon pamu masiwian tetak ma hina seilon ti hile hahitakak. Na nga hone tel, “Nahiwa,” i nahih. Na nga hone tel, “Nahima,” i nahima. Ape na nga talo tel unauak, “Ailewa tetenen,” i aile.’” ");
INSERT INTO ssg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ti Jises hongoa i ongake hawane. I xeisale ape i hone teka seilon kakahiti i, “Nga kakane amuto, ti leili Israel nga tai tutunah tel seilon i hina namil xoxoan tetak masin tel seilon ti Rom ie.” ");
INSERT INTO ssg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Teka kaui kakain alia hani ingi tel masiwi ti hile ape lato tunahi ka tel unauan i ewiwen. ");
INSERT INTO ssg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tai kue, Jises ma tesol kahikahin nahih hani tehu taon Nain ape kilan seilon kahitiwa lato. ");
INSERT INTO ssg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jises tahia hani aweingi tehu taon onoteni teka seilon kakau tel seilon maten ti tihinian. Tel seilon maten ien i telawe wanen nati tel hehin axoan matewen. Kilan seilon ti tehu taon ien kakahiti tel hehin. ");
INSERT INTO ssg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ti Jises tel Masiwi paxaiwa tel hehin, i tahane hawane. Ape kakane i, “Kum tangitang.” ");
INSERT INTO ssg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jises nahih soti teik patiu ti tel maten engeeng ape teka seilon kauan laha tu hamalum. Jises ukek, “Tel wawan uluha, xahatale!” ");
INSERT INTO ssg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ape tel seilon kemuk maten xahat to. I hutui kakak kapi teka seilon. Ape Jises aliake i hani tel tinan. ");
INSERT INTO ssg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Teka kilai seilon ongake hetekie mamata ape laha kak sameni Haeu, laha ukek, “Tel kuluiai kakai Haeu pate tuah tahiawen kapi kako! Ie i kola ka Haeu huali kako teka seilon tetan!” ");
INSERT INTO ssg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Meng ti sale puase Jises sawata hani hatexux Judia ma xux ti xohixohin kapin. ");
INSERT INTO ssg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Teka kahikahi Jon Baptis kaxi hani i lawe waliko ti Jises ailele. Ape Jon hone hua ti lato nahih hani kapin. ");
INSERT INTO ssg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","I talo lalu hani kapi Jises tel Masiwi kameian na i se Krais, tetel teka Ju to atetengi na Haeu taloma, ka lato atengi tel seilon liai. ");
INSERT INTO ssg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ti lalu tahia haniwa kapi Jises, lalu ukek, “Jon Baptis taloma amili kameiam na o se Krais, tetel amite to atetengi na Haeu taloma, ka amite atengi tel seilon liai?” ");
INSERT INTO ssg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lokon ien Jises haewia kilan seilon laha hina nax tenen tenen, teka ti spirit lialun kapiti hahalialu ma teka pulaxa. ");
INSERT INTO ssg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ape i pahoi huhua kahikahi Jon i ukek, “Amulu alia honewa Jon waliko ti amulu hongohong ma niningahi. Teka pulaxa laha nahih hanima kapik ape laha paxapax, teka laha kum nanahih ape laha nahih uke, teka hina nax lialun he tinulaha ape laha ewi, teka taxingalaha sutu ape laha hong uke kakain. Teka maten laha moih alia ape teka pahalaha wanen Haeu neini ma ngahati laha, laha hongohong meng solian ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ape kaxi haniwa Jon ka teka namilolaha xoxoan tutuen tetak, Haeu aile hasolia hani laha.” ");
INSERT INTO ssg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Muhin ti huhua kahikahi Jon nahiwa, Jises kakane teka seilon sale Jon. I ukek, “Ti amuto nahiwa hongoi kakai Jon ti he lohong, amuto sokok amuto ningahi aita? Tel seilon namilon lawe i sohisohia? ");
INSERT INTO ssg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Amuto sokok ka amuto ningahi aita? Tel seilon tenen soson pate solian? Kumahe, seilon kum sosoi maia solian he lohong. ");
INSERT INTO ssg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nakon amuto sokok ka amuto ningahi tel kuluiai kakai Haeu? Salan wanen, tuahe nga kakane amuto, Jon tel seilon pamu tuah ti tel kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jon i tel seilon Haeu kakaxi leili pepaun. Haeu kakane tel Natun i ukek, “‘Nga talo tel ahutiai kakaiak imat tetam ti apeseniai seilon ti sohotuam.’” ");
INSERT INTO ssg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jises kak ulea ukek, “Nga kakane amuto, puase Jon ti Haeu kilami i ailean se pamu tuah ti puase hatesol seilon liai. Tuahe kalak teka ti pate naun leili teka seilon Haeu neneini, anesoalaha sale nenein ti Haeu pamu lapan ti Jon.” ");
INSERT INTO ssg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kilan teka seilon naun, tataen teka waxiai moni ti teka Ju, ti laha hongoa, laha paxai tioi ka waliko ti Haeu namiloi peleiwen pate sawisawin. Aile ape laha towiahu ti lialui woulaha hani Haeu ape Jon baptaisi laha. ");
INSERT INTO ssg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tuahe teka Parisi ma teka hanaui nauna ti Moses lato kum nam waxi waliko ti Haeu namiloi peleiwen ti lato. Aile ape lato kum towiahu ti lialui woulato ape Jon tai baptaisi lato. ");
INSERT INTO ssg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jises kak ulea ukek, “Kaie nga kolongeni teka seilon ti aope ie ukek ia? Laha masin waliko la? ");
INSERT INTO ssg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Laha masin teka akaik laha toto ti tone halokoin. Laha tilol ausisini hani teka liai, “‘Amite pakui pak solian ti salasala hani amuto tuahe amuto kum amuam. Amite pakui pak ti tatahan, tuahe amuto kum tang.’ ");
INSERT INTO ssg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Masin Jon Baptis ti i sohotuma, i kum ang halapa ma i kum un waen ape amuto ukek, ‘Spirit lialun kapiti halialu i.’ ");
INSERT INTO ssg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ape ti nga tel Nati Seilon sohotuma, nga ang ma un waen hanowi teka seilon liai ape amuto ukek, ‘Paxaiwa tel seilon ien! Puhuan wawan ma weli unum. I tin lohi teka seilon ti waxiai moni hani teka masiwi ti Rom ma lohi teka seilon woulaha lialun.’ ");
INSERT INTO ssg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tuahe nga kakane amuto, anesoi Haeu ti amili Jon hahanau seilon, i sohot xeu hawane ka salan, na seilon paxai soliai puasamili, tataen ti na kilan seilon aile usi waliko ti amili hahanau laha.” ");
INSERT INTO ssg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tel Parisi axan Saimon ilowi Jises hani tehu angiain. Jises nahih hani leili ingan ape i to ang. ");
INSERT INTO ssg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ti tehu taon ien tel hehin ti ailei saun lialun i hong tunahi ka Jises angiang leili ingi Saimon ape i kauma tehu sanda kahun pate lalap ma poun pate solian. ");
INSERT INTO ssg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ape i tu tehiti Jises sai aen. I tang ape kani pulan tuh hawaxexa ae Jises. I uke ukun umeni hapaxean ape i to asoasoi aen ma i tihi tehu sanda hani he aen. ");
INSERT INTO ssg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ti Saimon ningahiwa, i kakane aliake i, “Tel seilon ie i liai kumahe tel kuluiai kakai Haeu nake i hani lioi tetel hehin soti tinun. Na i tioila ka tel hehin ien weli ailei saun lialun ala i hakonguen.” ");
INSERT INTO ssg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jises hone i ukek, “Saimon, nga teik kakain kakaneam.” Saimon ukek, “Tel masiwi, kakain la?” ");
INSERT INTO ssg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ape Jises hutui kaxi hani i tenen meng. I ukek, “Hua seilon lalu hahapuasa moniai tel seilon liai, tel hapuasa moni pate lalap ape tel moni kokol. Taun ti lalu ti ape hamatean. ");
INSERT INTO ssg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tuahe tap tel ti lalu pon hamatean ape tel seilon ien oxoxi ati lalu ti kawatan ti lalu. I hone lalu ka lalu kum hahamate moniun. O namiloi ukek ia? Kaie aita ti lalu pamu i amuke tel seilon ien?” ");
INSERT INTO ssg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon pahoi ukek, “Nga namiloi ukek tetel i uke moni pamu lapan.” Jises ukek, “Salan wanen.” ");
INSERT INTO ssg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jises xeisa paxai tel hehin ape i hone Saimon, “Paxaiwa tel hehin ie. Ti nga tahia hanima leili ingam o tai hani nga kan nuhiai aek, tuahe i nuhi aek kani pulan ape i uke ukun umenian. ");
INSERT INTO ssg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","O tai asoi taliopak ti tengeniak tuahe i asoasoi aek lilian ti nga tahiama. ");
INSERT INTO ssg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","O tai ahui wel hani patuk ti kolakol ka o waxi auni nga tuahe i tihi hani aek tehu sanda kahun pate lalap. ");
INSERT INTO ssg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nga kakane hawane o, tel hehin ie waheni hawane nga. Nake ti tetenen, nga oxoxiwen i ti kawatan ti kilan saun lialun i ailewen. Tuahe tel seilon nga oxoxi i ti kawatan ti palaiai saun lialun ti i ailewen, i waheni nga pamu kolean. ");
INSERT INTO ssg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ape Jises hone tel hehin, “Nga oxoxiwen o ti kawatan ti lialui woum.” ");
INSERT INTO ssg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Teka liai laha to angiang kapin laha he kakak alia puki laha, “Nakon i ukek i aita ka i oxoxi seilon ti kawatan ti lialui woulaha? Mewenae Haeu pon.” ");
INSERT INTO ssg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ape Jises kakane tel hehin, “Haeu awai o ti kawatan ti lialui woum nake namilom xoxoan tetak. Nahih hawanenewa.” ");
INSERT INTO ssg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Muhin ien Jises lua hani taon ma toan tewau tewau kaxiai meng solian ti sale Haeu neini seilon. Tesol huopanim huhua aposel nahih kakahiti i. ");
INSERT INTO ssg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tin hina hehin kapin. Kemuk i haewia lato ma xaxaweni spirit lialun ti lato. Leilolato Mary Magdalen, tetel Jises xaxaweni tepanim hua spirit lialun leilon. ");
INSERT INTO ssg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Susana ma Joana tin kapi Jises. Tel axoi Joana axan Kusa i tetel ngahatiai hatesol soxiai tel masiwi Herod. Kilan hehin liai tin laha kakahiti Jises. Hatesol hehin ien laha hapuasa moniulaha hualiai Jises ma tesol aposel. ");
INSERT INTO ssg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Telao, ti kilan wanen seilon ti taon tehu tehu nahih apuha hani kapi Jises, i kaxi hani laha tenen meng. ");
INSERT INTO ssg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","I ukek, “Telao tel seilon nahih towi seini waki maia. Hina i put hani aweisal. Imuh teka seilon nahih tuhi ma manixux ngong ani hatapo. ");
INSERT INTO ssg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hina i put hani he kalamael. Tuahe waki maia ti i supulale lato aleal nake kan ti hepekeun i tae. ");
INSERT INTO ssg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hina waki maia i put hani leili au. Ti i xexele, au talini ape i kum hua. ");
INSERT INTO ssg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tuahe hina waki maia i put hani he hepekeun solian. I xexele ape i hua palahi 100 ulea akulai ti tel seilon seini.” Jises tiliwa kaxiai tenen meng ape i ukek, “Na amuto hina taxing ti hongoi kakain, hongoa!” ");
INSERT INTO ssg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tesol kahikahi Jises kamei i ti kaxi haxewa hanialato salangawe tenen meng ien. ");
INSERT INTO ssg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ape i ukek, “Haeu haxewa hani amuto teka kahikahik sale nenein tetan kumahe hani seilon liai. Teka seilon kumahe kahikahik nga kaxi meng ti hanaualaha lehe waliko ti Aisaia kaxiwen i sohot poponowi. I ukek, “‘Teka seilon papaxai waliko tenen ti nga ailele, tuahe laha kum ningahi, laha hongohong kakaiak tuahe laha kum xeu.’” ");
INSERT INTO ssg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jises ukek, “Ie salangawe tenen meng nga kaxiwen. Waki maia kikilami kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aweisal ti waki maia put to, kikilami teka seilon laha hong kakai Haeu. Tuahe Satan tahiama ape i xaxaweni kakain ien ti laha lehe laha kum soh Haeu ape Haeu kum awai laha ti kawatan ti lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kalamael ti waki maia put to, i kikilami teka seilon pate laha hong amuke kakai Haeu tuahe laha tap namil xoxoan ti Haeu. Laha soh kakai Haeu teik kukunun. Taen kawatan ma totohong tahiama, xoxoi namilolaha ti Haeu pate i put kosea. ");
INSERT INTO ssg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Hepekeun ti hina au waki maia put to, i kikilami teka seilon laha hong kakai Haeu tuahe laha namiloi kasini waliko ti itan ie. Pahalaha soxialaha kilan ma laha nahaini waliko ti seilon liai. Namil tenen ien kokongini kakai Haeu ape laha kum hua nake namilolaha ti Haeu kumahe xoxoan. ");
INSERT INTO ssg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tuahe hepekeun solian kikilami teka seilon sawisawin laha hong auni kakai Haeu ape laha hua hakila nake laha usi kapitini nauna ti Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jises kak tatale ukek, “Tap tel i hakama tehu kamaian ape i atuhi ma na hana hahitake sau. Mewenae i hakama hakea hani patul koukean lehe i haxewa leili ing. ");
INSERT INTO ssg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Waliko ti i mumuna aope i sohot kouke. Waliko ti amuto kum xeu ti kakai Haeu aope ie, imuh Haeu haxewa hani amuto. ");
INSERT INTO ssg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Aile ape amuto hong matainiwa kakai Haeu lehe amuto xeu. Na tel seilon i hong usi kakaiak, Haeu axi aheke anesoan, tuahe na tel seilon kum hong usi kakaiak, anesoan Haeu waxi aliake.” ");
INSERT INTO ssg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ngain telao ti Jises hahanau teka seilon, tel tinan ma tesol ukalan nahima paxai i. Tuahe lato kum ngasoha uke hani kapin nake husele kilai seilon. ");
INSERT INTO ssg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tel ti laha hone Jises, “Tel tinam ma tesol ukalam tutu melal. Pahalato paxaiam.” ");
INSERT INTO ssg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ape Jises ukek, “Teteka laha hong usi hatapo kakai Haeu laha se tinak, ukalak ma tuak.” ");
INSERT INTO ssg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ngain tehu Jises ku hani he tea koap hetekie tesol kahikahin ape i hone lato ukek, “Kako lang hani liai tepaun ti kanitax Galili.” Ape lato lang. ");
INSERT INTO ssg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Leilon ti lato langalang, Jises pulan lihi ape i matih. Tai kue tehu ahon taheima. Laman hutomi tea koap ape sikole lato kaxox. ");
INSERT INTO ssg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tesol kahikahin hangoni i ape lato ukek, “Tel masiwi, tel masiwi! Sikole kako mat!” Jises haiwa ape i kakane aupol ma laman, “Mongawa!” Ape i tuxi. ");
INSERT INTO ssg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jises hone lato ukek, “Nakon amuto tap namil xoxoan tetak?” Tuahe lato mamata ma ongake hawane ape lato he kakak alia lato, “Seilon tenen lahan ka aupol ma laman hong usi kakaian?” ");
INSERT INTO ssg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jises ma tesol kahikahin lang hani texux xux Gerasa, i liai tepaun ti kanitax Galili onote texux xux Galili. ");
INSERT INTO ssg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ti lato tahia haniwa peixux, Jises mosua ape i apatuini tel seilon spirit lialun kapiti hahalialu. Pate kuewen i tai sosos maia ma tin i kum toto ixux, totonan he amal. ");
INSERT INTO ssg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ti i ningahiwa Jises, i tang ausini ape i lokuha mateiwaun. I tilol ukek, “Jises, tel Nati Haeu pate tuah, lehe o aile la hani nga? Nga kamei eliel o, kum aile hahalialu nga!” ");
INSERT INTO ssg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","I kak ukek nake Jises kakanewen spirit lialun ien ka i ahuta xaxaua ti tel seilon. Kemuk spirit lialun ien kapiti halialu hakilawen i. Kalak na laha peteni tel seilon ien ma xinoti kongini minan ma aen ani sen, i xaputi uke. Ape spirit lialun kapiti hakiliwawa i hani he lohong. ");
INSERT INTO ssg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jises kamei i, “Axam la?” I pahoi ukek, “Axak Kilan.” I kak ukek nake kilan spirit lialun ingangai tel seilon ien. ");
INSERT INTO ssg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Teka spirit lialun kamei talingoi Jises, “Kum towi xoxoini amite hani tesol ti hahitake tehu pon ie ti kaui kawatan.” ");
INSERT INTO ssg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tesol kilai pou exiex ngixi maunten xohixohin kapi tesol ien. Ape tesol spirit lialun kamei eliel Jises, “Talo haniwa amite leili tesol pou!” Salan, i sowini hani lato. ");
INSERT INTO ssg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lato ox sohotua ti tel seilon ape lato soh hani leili tesol pou. Hatesol pou ien kiliwau mosua ti he sahikekean tamus hani itax ape lato waut mat. ");
INSERT INTO ssg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Teka ngahatiai tesol pou ningahiwa, lato kiliwau kaxi sawateni waliko ti i sosohot hani teka seilon ti taon ma toan tewau tewau ti ien. ");
INSERT INTO ssg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Teka seilon nahih paxai waliko ti i sosohot. Ti laha xohi haniwa kapi Jises, laha ningahi ka tel seilon kemuk spirit lialun kapiti hahalialu, i toto kapi ae Jises. I hina puxux ma namilon tin ape solian. Ape laha mamata. ");
INSERT INTO ssg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Teka seilon laha ningahiwen ti Jises haewia tel seilon spirit lialun kapiti hahalialu, laha kaxi hani teka seilon liai laha nahih paxaiai waliko ti i sosohot. ");
INSERT INTO ssg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ti laha hongoa, teka seilon ti Gerasa kamei Jises ti ku salilialaha nake laha mamata hawane. Kakanua Jises ma tesol kahikahin ku hani he koap ape lato apepeas ti lang. ");
INSERT INTO ssg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tel seilon teka spirit lialun ox sasaliliwa, i kamei eliel Jises na i kuoxi lato. Tuahe Jises hone i ukek, ");
INSERT INTO ssg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kumahe, alia haniwa tonam ape kaxiwa waliko solian Haeu aile haniwen o.” Tel seilon hong usi kakai Jises ape i nahih kaxi hani lawe seilon leili tehu taon waliko ti Jises aile haniwen i. ");
INSERT INTO ssg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ti Jises tahia alia haniwa liai tepaun ti kanitax Galili, teka seilon pate laha amuam nake hoi laha to atetengi i. ");
INSERT INTO ssg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ti ien tel seilon axan Jairus tahiama. I tel ti tesol masiwi ti synagog. I lokuha hani itan kapi ae Jises ape kamei eliel i ka kahitiwa i hani ingan. ");
INSERT INTO ssg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Natun telawe hehin ahangun huopanim huohu, i pate tinun sikole i mat. Ape Jises nahih kahiti Jairus. Kilan wanen seilon nahih pisipis kapin. ");
INSERT INTO ssg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ti leili kilai seilon, tel hehin i hina nax ti sale tapunaun leili ahang huopanim huohu. I paxaiwen kilan dokta. Moniun tua tapo ti ukei huhual tuahe i to lialu tatalewa. ");
INSERT INTO ssg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","I ngasoha hani muhiwai Jises ape i soti ngixi puxuaun. Hahutuia hawane naxe tinun tapo. ");
INSERT INTO ssg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","“Aita tel soti nga?” Jises kameawa. Teka laha hong ti i kamekam laha ukek laha tai soti i. Ape Pita hone i, “Tel masiwi, kilan seilon nahih pisipis kapim.” ");
INSERT INTO ssg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tuahe Jises ukek, “Tel seilon sotiwen nga, kumahe ka i tua soti nake nga ilameni hina poh i ahutawen tetak.” ");
INSERT INTO ssg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ti tel hehin paxai tioiwa ka Jises tioi ka i tetel i soti puxuaun, i mamata xexex ape i lokuha hani itan kapi ae Jises. Ti puli lawe seilon i kaxi hani Jises salangawan ti i soti puxuaun ma ti i ewi hahutuia. ");
INSERT INTO ssg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jises hone i ukek, “Tel natuk, o ewiwen nake ti xoxoi namilom tetak. Nahih hawanenewa.” ");
INSERT INTO ssg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ti Jises kaakane tutuen tel hehin, tel seilon tahiama ti ingi Jairus ape i hone Jairus ukek, “Tel natum i matewen, kum hakalakala nanahiai tel masiwi.” ");
INSERT INTO ssg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ti Jises hongoa, i hone Jairus, “Kum namiloi hahalapa, tua sohoa tetak lehe tel natum i moih alia.” ");
INSERT INTO ssg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ti Jises tahia haniwa ingi Jairus, lon kum al seilon kilan kahiti i hani leili ing mewenae tolu kahikahin Pita, Jeims, Jon ma tel tame tel akaik ma tel tinan. ");
INSERT INTO ssg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kilan seilon laha tang tatahane tel akaik. Jises ukek, “Kum tatangixi tel akaik, i tai mat, i tua mamatih.” ");
INSERT INTO ssg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tuahe laha hatesol mal soxeni Jises nake laha tioi ka tel akaik i matewen. ");
INSERT INTO ssg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jises akeni mini tel akaik ape i ukek, “Tel natuk, xahatale!” ");
INSERT INTO ssg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tataen ien wanen tel akaik moih alia ape i xahat. Jises hone laha, “Axiwa anan.” ");
INSERT INTO ssg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tel taman ma tel tinan ningahiwa, lalu ongake hawane. Ape Jises hone lalu, “Kum kakaxi hani tel na seilon waliko ti i sohotuen ie.” ");
INSERT INTO ssg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jises ilowi apuhini huopanim hua aposel ape i axi lato poh ti xaxaweniai spirit lialun ma nax tenen tenen ti teka seilon. ");
INSERT INTO ssg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ape i talo lato kaxiai meng solian ti Haeu neini seilon ma haewiai teka tinun. ");
INSERT INTO ssg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","I hone lato ukek, “Kum lua hehetekie tenen na soxi. Kum kakau kuaiamuto, moni, kak, an ma sohiai sosomuto. ");
INSERT INTO ssg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Amuto toa leili ing tetehu na laha waxi auni amuto atengi tataen amuto nahih salili tesol ien. ");
INSERT INTO ssg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na teka seilon kum waxi auni amuto ma kum hong amuto, tapahiwa anele aemuto ape nahih saliliwa tesol ien. I kola ukek ka teka seilon ien imuh laha kau kawatan nake laha kum hong kakai Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ape tesol aposel nahih kakaxi meng solian ti Jises hani toan tewau tewau ma hahaewia teka seilon tinun. ");
INSERT INTO ssg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ti Herod tel masiwi ti Galili hong tunahiwa waliko ti Jises ma tesol aposel ailele, pate i tataxini nake hina seilon ukek ka Jon Baptis moih aliawen. ");
INSERT INTO ssg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Teka liai ukek ka Elaija take aliawen ma teka liai ulea ukek ka tel ti teka kuluiai kakai Haeu liai ti kuewen moih aliawen. ");
INSERT INTO ssg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod ukek, “Nga tioi ka Jon Baptis matewen nake nga honewen tel unauak koti xaxaweniai kinawen. Lehe aita ulea tel nga hongohong i ailele tesol waliko lalap?” Ape pahan i paxai Jises. ");
INSERT INTO ssg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tesol huopanim huhua aposel tahia aliama ape lato kaxi hani Jises lawe waliko ti lato ailewen. Muhin ien i hakahita lato hani tesol xohixohin ti tehu taon Betsaida lehe mewenae lato. ");
INSERT INTO ssg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tuahe kilan seilon laha hongoen tetesol Jises ma tesol aposel lua hahaniwa ape laha kahiti lato. Jises paxai amuke laha. I haewia teka tinun ma hanau teka seilon sale nenein ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ti ape alohah, tesol huopanim huhua aposel nahih hani kapin ape lato kakane i ukek, “Taloa teka seilon hani toan ti palieh lehe laha ngah an ma tone matihuin nake tap toan ie.” ");
INSERT INTO ssg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jises hone lato ukek, “Puki amuto axiwa analaha.” Ape lato ukek, “I kum pon! Toi amite ie tepanimawe bret ma huok xixi. Nakon paham amite towi halapa moni ti kahuiai an ape hani teka kilai seilon ie?” ");
INSERT INTO ssg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mongohe teka seilon ien 5,000, tai wexe teka hehin ma akaik. Jises hone tesol kahikahin ukek, “Hatona seiwa teka seilon hani 50 ti tesol tesol.” ");
INSERT INTO ssg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ape hatesol seilon to. ");
INSERT INTO ssg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jises waxi tepanim bret ma huok xixi. I pax hani patul ape i kak kemulik hani Haeu ti tesol an. I wiki ape i hani tesol kahikahin sei haniwa lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Laha hatesol ang ahoi hawane ape huopanim huohu po moxe an ti tesol kahikahi Jises apuhiniwa. ");
INSERT INTO ssg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ngain tehu Jises lolotu mewenae i ti i kapi tesol kahikahin. I lotu kewa ape i kamei lato, “Kaxi hanima nga, teka seilon laha ukek nga aita?” ");
INSERT INTO ssg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Lato pahoi i ukek, “Teka ukek o Jon Baptis, teka liai ukek o Elaija ape teka laha ukek ka o tel ti teka kuluiai kakai Haeu liai ti kuewen i moih aliawen.” ");
INSERT INTO ssg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ape Jises kamei lato, “A puki amuto? Amuto ukek nga aita?” Pita pahoi i ukek, “O Krais, tel Haeu taloma.” ");
INSERT INTO ssg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Muhin ien Jises hone tesol kahikahin ukek, “Kum kakaxi hani tel na seilon ka nga se Krais.” ");
INSERT INTO ssg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tin i kakane lato ukek, “Nga tel Nati Seilon, nga kau kilan kawatan ma moloan lalap. Ape teka masiwi ti teka Ju, teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses, laha watakai hawane nga. Laha telei nga tuahe muhi ngain toluhu nga xahat alia.” ");
INSERT INTO ssg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ape Jises kakane hatesol seilon ien ukek, “Na seilon pahan sohot kahikahik, laha kum namiloi wawaxi mewenae laha. Laha kaua kawatan masin ti nga kakau. Ien i kola ka laha kahikahik wanen. ");
INSERT INTO ssg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Seilon teka namilolaha mewenae hasoliai tonalaha ti itan ie, laha kum tunahi tonain kapi Haeu. Tuahe teka na laha hana tonalaha hahitake nenein ti Haeu nake nga, laha tunahi tonain kapi Haeu ti tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Na tel seilon hapono hatapo i waliko ti itan ie tuahe i lioi tonain kapi Haeu, solian la i uke? Tap. Tap tenen waliko kahui uke tonain kapi Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Na tel seilon hiena puluhini nga ma kakaiak, nga tel Nati Seilon tin nga hiena puluhini i taen ti nga alia hetekiema poh ma xewai tel Tamak Haeu ma tesol engel, spirit solian tetan. ");
INSERT INTO ssg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nga kaxi hawane hani amuto, teka ti amuto ie, imat ti amuto mat amuto ningahi Haeu i neini seilon.” ");
INSERT INTO ssg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Muhi puasain tehu kewa, Jises hakahita tolu kahikahin Pita, Jeims ma Jon hani he tehu maunten patul lehe lato lotu. ");
INSERT INTO ssg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ti Jises kakak kapi tel Taman Haeu, kawan sohia ma tehu puxuaun i xeu papaxaxu hawane. ");
INSERT INTO ssg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Moses ma Elaija take hahutuia hani kapi lato. Puxuaulalu tin xeu papaxaxu hawane. ");
INSERT INTO ssg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ape lalu kakak kapi Jises sale matean leili Jerusalem ti i hapoponowi namili tel Taman Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ma huhua tuaun matih luhuen. Ti lato haiwa, lato ningahi xewai kamai Jises hetekie Moses ma Elaija. ");
INSERT INTO ssg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ti lehe lalu salili Jises, Pita kak ukek, “Tel masiwi, pate ewi ti kako ie. Amite atai toluhu houha, tehu tetam, tehu ti Moses ma tehu ti Elaija.” I kak ukek ien nake i ongake hawane ape i kum tioi tenen na i kak. ");
INSERT INTO ssg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lokon ti Pita kakak tutuen, teik maun man atuhi lato ape tolu kahikahi Jises lato mamata hawane. ");
INSERT INTO ssg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ape kakai Haeu i ahuma he maun ien i ukek, “Tetel se Natuk, tel nga kilamiwen. Hong usiwa kakaian.” ");
INSERT INTO ssg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ti Haeu kak kewa, lato ningahi mewenae Jises tutu. Tolu kahikahin kum kaxi hanimu tel na seilon waliko ti lato ningahiwen. ");
INSERT INTO ssg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ngain liai tehu, Jises ma tolu kahikahin nahih mosulih he tehu maunten. Kilan wanen seilon apuha hani kapi Jises. ");
INSERT INTO ssg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tel ti laha tiloa, “Tel masiwi, nga kamei eliel o tahanema tel natuk wawan, natuk se telawe ien! ");
INSERT INTO ssg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Lawe na spirit lialun soh haniwa tel natuk, i haxexe hangaxangaxa ape pok sal he awan. Spirit lialun ien lawe i to aile hahalialu tel natuk. ");
INSERT INTO ssg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nga kamei eliel hawane tesol kahikahim ti xaxaweniai spirit lialun ien tuahe lato kum pon.” ");
INSERT INTO ssg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jises hone laha hatesol ukek, “Amuto teka seilon ti aope ie, tap namil xoxoan ti Haeu ma woumuto pate lialun! Nga hanau kueiniwen amuto. Kaie kuehuan ia pahamuto nga to kapimuto lehe namilomuto i xox tetak? Ati hanima nga tel akaik!” ");
INSERT INTO ssg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ti tel akaik nahih xohi haniwa kapi Jises, spirit lialun aile haputa hahaxexe i. Tuahe Jises usi xaxaweni spirit lialun ien ape i haewia tel akaik. Muhin ien i aliake tel akaik hani tel taman. ");
INSERT INTO ssg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ape teka seilon paxai ongaini hawane pohe Haeu. Ti teka seilon ongangake tutuen lawe waliko ti Jises ailewen, Jises hone tesol kahikahin ukek, ");
INSERT INTO ssg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Hong konginiwa! Nga tel Nati Seilon, laha hangaini hani he mini teka seilon laha watakai hawane nga.” ");
INSERT INTO ssg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tuahe tesol kahikahin kum xeu waliko ti i kakak. Haeu tai haxewa hani lato salangawe kakain ien. Lato mamata kameiai Jises waliko tetenen. ");
INSERT INTO ssg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tesol kahikahi Jises he hapatapat aita tel pamu tuah ti lato. ");
INSERT INTO ssg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jises tioi waliko ti lato nanamiloi ape i waxi hatuhi tel akaik hani papan. ");
INSERT INTO ssg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","I ukek, “Tel na i waxi auni akaik masin ie nake nga, se i aunini nga. Ape tel i waxi auni nga, i waheni tel Tamak Haeu, tetel i taloma nga. Tel na i teheni i ape i huali seilon liai, tel seilon ien Haeu namiloi ukek ka i pate tuah.” ");
INSERT INTO ssg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon tel kahikahi Jises kakane i, “Tel masiwi, amite ningahi tel seilon i xaxaweni spirit lialun hahitake axam. Tuahe i kumahe tel ti kako ape amite honewen i ka kum ailele.” ");
INSERT INTO ssg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jises ukek, “Kum hahalini i nake tel na i kum pahoxai kako ti pupuasakako, i tepaun ti kako.” ");
INSERT INTO ssg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pate ape i xohiwen ti Haeu waxi aliake Jises hani tonan. Aile ape namili Jises i xox ka i lua hani Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","I talo teka seilon nahiwa imat tetan hani tewau toan ti Samaria, apeseniai lawe waliko pake i ma tesol kahikahin tahiawa. ");
INSERT INTO ssg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tuahe teka seilon ti tewau toan ien, laha kum waxi auni Jises ma tesol kahikahin nake laha tioi ka lato nahih hahaniwa Jerusalem. Teka Samaria laha watakai na teka Ju lotu leili Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ti hua kahikahin Jeims ma Jon paxaiwa woulaha, lalu ukek, “Tel masiwi, nakon o waheni na amili kamei Haeu hamosulih ah ti tonan lehe i lui laha?” ");
INSERT INTO ssg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tuahe Jises kahiloloi lalu. ");
INSERT INTO ssg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ape Jises ma tesol kahikahin nahih hani tewau toan liai. ");
INSERT INTO ssg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Lokon ti Jises ma tesol kahikahin nanahiwa he aweisal, tel seilon hone Jises, “Tesol tesol na o nahih, nga kahiti o. Nga lawe kahikahim.” ");
INSERT INTO ssg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tuahe Jises hone i, “Sinen hina walun ma manixux hina ingan, tuahe nga tel Nati Seilon, tap tuahe tesol na tone hanawaiak.” ");
INSERT INTO ssg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ape i hone tel seilon liai, “Kahitima nga. Pahak o kahikahik.” Tuahe tel seilon ien hone i, “Tel masiwi, nga aunimu tel tamak lehe na i matewa nga tihini.” ");
INSERT INTO ssg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jises ukek, “Teka seilon kumahe ti Haeu laha masin seilon maten. Tiliwen teka ien tihiniai teka maten. Tuahe o nahih kaxi sawateniwa meng solian ti Haeu neini seilon.” ");
INSERT INTO ssg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tel seilon liai ukek, “Tel masiwi, pahak nga kahikahim tuahe imat nga to tapeinimu tesol akikik.” ");
INSERT INTO ssg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tuahe Jises hone aliake i, “Tel na i kum aile matuhini puase Haeu, liai i kum tapai ailei tenen puasain ien ma kaxi sawateniai meng solian ti Haeu neini seilon.” ");
INSERT INTO ssg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Muhin tel Masiwi Jises kilami 72 kahikahin liai ape i talo lato hua hua imat tetan hani lawe taon ma toan ti i namiloi na i nahiwa. ");
INSERT INTO ssg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","I kakane lato, “Kilan seilon laha xohixohin ti lehe laha sohot kahikahik. Laha masin kilai an ti he kin i apeasawen. Tuahe seilon ti apuhiniai an, teka ti neinialaha hani Haeu, laha pate palai. Kameiwa Haeu lehe i talo palahi seilon ti neiniai seilon liai lehe laha sohot kahikahik. ");
INSERT INTO ssg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ape nahiwa! Nga talo amuto hanowi sipsip uluha hani leili teka sinen tumulaha kalimen. ");
INSERT INTO ssg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Na amuto nahiwa, kum kakau moni ma kak. Tin kum ngah hahasea axahe aemuto. Kum tu kak kukue kapi seilon ti na amuto apatuini he aweisal. ");
INSERT INTO ssg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Na amuto soh hani ing tehu, amuto kak kewak, ‘Amuam ti Haeu hani amuto.’ ");
INSERT INTO ssg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na seilon ti leili ing tehu ien waxi auni amuto, amuto haniwa laha amuam ti Haeu. Na laha kum waxi auni amuto, amuam ti Haeu i alia hani kapimuto. ");
INSERT INTO ssg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Na tel seilon waxi auni amuto, toa leili ingalaha, kum sos ahuahu. Kum wawatakai aniai an ma unumiai unum ti na laha hani amuto nake seilon ti laha pupuas laha aka kahulaha. ");
INSERT INTO ssg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ti na amuto tahia haniwa tehu taon ape laha ilowi amuto, tua aniwa an tenen na laha axi amuto. ");
INSERT INTO ssg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Haewiawa teka tinun leili tehu taon ien ape kaxi haniwa laha ka taun ti Haeu neini laha ape i xohiwen. ");
INSERT INTO ssg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tuahe na laha kum ilowi amuto, nahih saliliwa laha ape kaxi hatakei haniwa lawe seilon ti tehu taon ien kewak, ");
INSERT INTO ssg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Amite tapahi xaxaweni hepekeun he anele aemite. I kola ka amuto kum waxi auni seilon ti Haeu, aile ape i axi kawatan hani amuto. Amuto hasaliawen nenein ti Haeu.’ ");
INSERT INTO ssg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nga kakane hawane amuto, tehu ngain ti hinitiai seilon, Haeu axi kawatan hani laha, i xoini kawatan ti i hani teka seilon lialun ti Sodom.” ");
INSERT INTO ssg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ape Jises kakak sale toluhu taon i aile kilan waliko tenen lalap. I ukek, “Teka seilon ti Korasin ma Betsaida, Haeu axi kawatan hani amuto. Na nga aile hanila teka Taia ma Saidon waliko tenen lalap nga aile haniwen amuto, teka Taia ma Saidon laha towiahu kueiniwen ti lialui woulaha kalak laha kumahe Ju. ");
INSERT INTO ssg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aile ape tehu ngain ti hinitiai seilon, Haeu axi kawatan hani amuto i xoini kawatan ti i axi teka Taia ma Saidon. ");
INSERT INTO ssg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ape teka seilon ti Kapenaum, amuto namiloi ukek ka Haeu sameni amuto tuahe Haeu towi xoini amuto hani tesol ti kaui kawatan tap tahi tapoan. Kalak amuto ningahiwen waliko tenen lalap nga ailele, amuto kum towiahu ti lialui woumuto hani Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jises kakane tatale teka kahikahin ukek, “Tel ti na i hong usi kakaiamuto, tin masin i hong usi kakaiak. Tuahe tel ti na i kum nam waxi kakaiamuto, tin masin i kum nam waxi kakaiak. Ape tel ti na i kum nam waxi kakaiak, i kum nam waxi Haeu tetel i taloma nga.” Jises tiliwa kakaian ape 72 kahikahin lato nahih aile waliko ti Jises tatalo lato ailean. ");
INSERT INTO ssg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Imuh teka 72 kahikahi Jises alia hani kapin. Hetekie lalape amuam lato ukek, “Tel Masiwi, taen spirit lialun laha hong amite na amite xaxaweni laha leili seilon ti hahitake axam.” ");
INSERT INTO ssg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jises hone lato, “Ti amuto xaxaweni spirit lialun, i kola ka Haeu to xoxoini Satan. Ien masin wanen usil xepalih he maun. ");
INSERT INTO ssg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nga axiwen amuto pohe Haeu. Aile ape kalak amuto tuhi tunahi noh ma na mini anepapap, i kum hamange amuto. Tin masin amuto xoini pohe Satan ape tap tenen i pon konginiai hatesol waliko Haeu namiloi peleiwen hani amuto. ");
INSERT INTO ssg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Solian ti spirit lialun hong usi kakaiamuto tuahe pamu amuto amuamua nake Haeu hana konginiwen axamuto ti ukei tonain kapin ti tap tahi tapoan.” ");
INSERT INTO ssg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Holi Spirit hanamiloa Jises ape i kak hetekie amuam i ukek, “Tel Tamak Haeu, Masiwi ti lawe waliko ti patul ma tehu pon itan ie, nga kak kemulik hani o nake o mumuneni pohem ti teka laha sokok laha seilon aneso ape o haxewa hani teka laha hana laha hahitake ngahat tetam masin teka akaik. Nga kak kemulik hani o tel Tamak Haeu nake paham i sohot ukek ien.” ");
INSERT INTO ssg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jises hone teka seilon ukek, “Tel Tamak Haeu hani hatapoen nga pohen ma anesoan. Mewenae tel Tamak Haeu tioi hawane nga tel Natun ma mewenae nga tel Natun tioi hawane tel Tamak Haeu. Ape nga tel Natun nexi haxewa tel Tamak Haeu hani teka seilon ti nga kilami.” ");
INSERT INTO ssg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ape Jises kakane mewenae tesol kahikahin i ukek, “Tanusik amuto ka Haeu hani amuto ningahi waliko tenen lalap. ");
INSERT INTO ssg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nga kakane hawane amuto, kilan teka kuluiai kakai Haeu ma teka masiwi ti teka Ju, pahalaha paxaiai waliko tenen lalap ti amuto niningahi nga ailele tuahe laha tai ningahi. Tin pahalaha hongoi waliko ti amuto hongohong nga kakaxi tuahe laha tai hong.” ");
INSERT INTO ssg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lokon ien tel ti teka hanaui nauna ti Moses kamei pisi Jises. I ukek, “Nga aile la lehe nga uke tonain kapi Haeu tenen tap tahi tapoan?” ");
INSERT INTO ssg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jises kak pahoi ukek, “Tesol nauna ti Moses kak ukek ia sale ukei tonain kapi Haeu tenen tap tahi tapoan? O namiloi ukek ia kakain ien?” ");
INSERT INTO ssg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tel seilon pahoi ukek, “Nauna ti Moses kak ukek, ‘Waheni hawanewa Haeu tel Masiwi ti amuto, xoiniwa ti amuto waheni teka seilon liai. Amukewa Haeu ti leili tiamuto, namiloi eliel hawanewa i ma aile hatapoa puasan ti hatesol kuimuto. Ape waheniwa seilon liai hanowi ti amuto waheni aliake amuto.’” ");
INSERT INTO ssg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jises ukek, “Kakaiam salan. Aile kewak ien ape o uke tonain kapi Haeu tenen tap tahi tapoan.” ");
INSERT INTO ssg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tel hanaui nauna ti Moses i tioi hawane ka kumahe i waheni lawe seilon ape i kamei Jises, “Tuahe aita tel seilon liai o ukek nga waheniwa hanowi ti nga waheni aliake nga?” ");
INSERT INTO ssg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jises hapuasa tenen meng ti pahoiai tel seilon ien. I ukek, “Telao tel seilon nanahih ti Jerusalem hani Jeriko. Teka seilon lialun koui hahutuia i ape laha waxi hatesol moniun ma soxian. Laha xai hakimatua i ape nahih salili i he aweisal. ");
INSERT INTO ssg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Imuh tel masiwi ti hukuminiai Haeu ma seilon nanahih he aweisal ien. I paxaiwa tel seilon engeeng ien ape i non salia hani liai tepaun. I tai huali. ");
INSERT INTO ssg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Muhin tel puase leili Ingi Haeu nahima, i ningahi tel seilon ien ape tin i non salia hani liai tepaun. I tai huali. ");
INSERT INTO ssg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Tapeinan tel ti Samaria nahima. Amuto tioi wasole teka Ju ma teka Samaria kumahe ewi. Ti i ningahiwa tel Ju mangein, i tahane hawane. ");
INSERT INTO ssg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","I kiliwau tamus hani kapin. I tihi wel ma waen hani he naxonaun ape i pulai. Muhin ien i hana tel seilon hani patul he tok tupun donki. I hakahita hani leili tehu ing ti tone hanawain ape i auni. ");
INSERT INTO ssg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Ngain liai telao i hani tel tame tehu ing moni ape i ukek, ‘Auniwa tel seilon mangein. Na o hapuasa akulai lape moni ti nga hani o, nga saiti na nga aliama.’” ");
INSERT INTO ssg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ape Jises tili kakaian ukek, “O namiloi ukek ia? Aita tel ti tolu seilon ien kola ka i waheni tel seilon mangein hanowi ti i waheni aliake i?” ");
INSERT INTO ssg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tel hanaui nauna ti Moses pahoi ukek, “Tetel i kola tatahan tetan.” Ape Jises ukek, “Nahiwa ape aile ukenewa.” ");
INSERT INTO ssg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ti Jises ma tesol kahikahin lua hahaniwa Jerusalem, lato tahia tewau toan. Ti ien tel hehin axan Mata ilowi lato hani ingan. ");
INSERT INTO ssg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tel tuai Mata axan Mary i to onote ae Jises tel Masiwi ape i to hongohong mengon. ");
INSERT INTO ssg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tuahe Mata pate i namiloi halapa apeseniai an ape i hone Jises, “Tel masiwi, nakon o kum nam waxi ka Mary hani lioi nga ailei hatesol puasain? Ewi na o hone i nahima hualiak?” ");
INSERT INTO ssg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tuahe Jises tel Masiwi ukek, “Mata, pate o namiloi kasini lawe waliko. ");
INSERT INTO ssg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tuahe tenenawe waliko pate tuah. Aope ie Mary ailele. Aile ape nga kum kongini i.” ");
INSERT INTO ssg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ngain tehu Jises nahih lotu hani tesol ti mewenae i. Ti i heisawa, tel ti teka kahikahin nahima ape i ukek, “Tel masiwi, Jon Baptis hanau teka kahikahin sale lotu. Pahamite tin o hanaua amite sale lotu hani Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jises hone lato, “Na amuto lotu, amuto kak kewak: “‘Tel Tamamite Haeu, amite sameni o nake o pate tuah wanen. Pahamite o neiniwa ma ngahatiwa amite. Hualima amite usiam hanowi tetesol lato kapim leili tonam. ");
INSERT INTO ssg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Axima amite an tapai ti ngain tehu tehu. ");
INSERT INTO ssg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Oxoxiwa amite ti kawatan ti lialui woumite masin ti amite oxoxi seilon liai ti kawatan ti waliko lialun laha aile hani amite. O kum hahani amite totohong ailan lehe amite kum aile saun lialun. Ape awaiwa amite ti Satan ma teka spirit lialun tetan.’” ");
INSERT INTO ssg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ape Jises hanau aheke lato sale lotu ape i kaxi hani lato tenen meng ie. I ukek, “Na tel ti amuto nahih hani ingi tel lawan ti luhui ipong ape i ukek, ‘Aximuma nga teik na an. ");
INSERT INTO ssg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tel lawak tahiawen leili ingak a nga tap wanen an na nga axi i.’ ");
INSERT INTO ssg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Tuahe tel lawan wixima leili ing ukek, ‘Kum hakalakala nga. Aweing ape konginan ape amite hatesol mamatih. Nga kum hualimu o tetehu.’ ");
INSERT INTO ssg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nga kakane amuto, kalak i kum xahat hualian nake se lawan, i huali na i kamei talingoi. ");
INSERT INTO ssg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Tin masin na amuto lotu, amuto kamei talingoiwa ape Haeu hani amuto waliko ti amuto kakamea. Upia talingoiwa ape Haeu huali amuto tunahian. Kikini talingoiwa kahip ape Haeu hei hani amuto. ");
INSERT INTO ssg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Teka na laha kamea, Haeu hani laha. Teka na laha upia, Haeu huali laha tunahian. Teka na laha kikini talingoi kahip, Haeu hei hani laha. ");
INSERT INTO ssg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Na natumuto kamea lato ang xixi, kaie amuto axi lato weiko? ");
INSERT INTO ssg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na natumuto kamea analato peteta, kaie amuto axi lato wasiwasin? ");
INSERT INTO ssg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kalak woumuto lialun, amuto tioi haniai waliko solian hani natumuto. Tuahe tel Tamamuto Haeu pate pamu soliaian, aile ape i hani Holi Spirit kapitiai teka seilon laha kamei i.” ");
INSERT INTO ssg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ngain tehu Jises apatuini tel seilon i kum kak uke nake spirit lialun kapiti halialu i. Ti Jises xaxaweniwa spirit lialun leili tel seilon ien, ape i kak uke. Ti teka seilon ien ningahiwa laha ongake hawane. ");
INSERT INTO ssg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tuahe teka ti laha ukek, “I xaxaweni spirit lialun nake i kema poh ti Satan, tel masiwi ti spirit lialun.” ");
INSERT INTO ssg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Teka liai laha kamei hataehu Jises ailei waliko tenen lalap lehe i kola ka Haeu taloma i. ");
INSERT INTO ssg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tuahe Jises tioi waliko ti laha nanamiloi ape i hone laha, “Na seilon ti xux texux laha tikela ape hil alia puki laha, texux xux ien i lialu tamus. Na tesol akikin lato hil alia puki lato, tesol akikin ien lato kum tu xox. ");
INSERT INTO ssg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Amuto ukek ka nga hahapuasa pohe Satan ti xaxaweniai spirit lialun tetan. Tuahe na Satan hilei aliake i, nenein tetan i kum tu xox. ");
INSERT INTO ssg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Amuto ukek ka nga usi xaxaweni teka spirit lialun nake Satan hakui nga. Na masin ien, kaie Satan haniwen tesol kahikahimuto poh ti usi xaxaweniai spirit lialun? Puase tesol kahikahimuto i kola ka amuto puputa ka nga hahapuasa pohe Satan. ");
INSERT INTO ssg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kumahe nga hapuasa pohe Satan. Spirit ti Haeu axi nga poh ti usi xaxaweniai spirit lialun. I kola ka Haeu tel neiniamuto ape i tahiawen. ");
INSERT INTO ssg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Satan masin tel seilon kuin. Na paun tonawi ti peteniai tehu ingan, tap tel waxi uke soxian. ");
INSERT INTO ssg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tuahe na tel ti pamu kuiaian hilei tel seilon kuin ape i tike, i waxi hatapo paun ti peteniai ingan ape i sei soxi hani teka seilon liai. Se tin masin nga xoini Satan ape nga xaxaweni spirit lialun tetan ti leili seilon. ");
INSERT INTO ssg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Tel na i kumahe tepaun tetak, i pahoxai nga, i tepaun ti Satan. Tel na i kum huali nga neiniai teka seilon hani Haeu, i huhuali Satan neini haselealaha ti Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ape Jises kak tatale ukek, “Na tel spirit lialun ahuta ti tel na seilon, i nahih hani he lohong upiai tesol na i to. Tuahe i kum tunah. I kakane aliake i, ‘Nga alia hani leili tel seilon.’ ");
INSERT INTO ssg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ape i alia tunahi tel seilon ien, aope i masin tehu ing malaian ma tap tel ingangai. ");
INSERT INTO ssg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ape i nahih waxi tepanim hua spirit lialun liai, pamu lialuan tetan ape lato hatesol soh hani leili tel seilon ien. Lato kapiti halialu i akulai ti imat.” ");
INSERT INTO ssg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ti Jises kakak tutuen, tel hehin ti leili teka seilon ien tilol ukek, “Liai tel tinam amuam hawane nake o tel natun seilon pate tuah.” ");
INSERT INTO ssg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ape Jises kak ukek, “Salan. Tuahe teka seilon laha hong ape usi kakai Haeu pamu laha amuam.” ");
INSERT INTO ssg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ti seilon kila tatalema, Jises kakane laha, “Amuto seilon lialun ti aope ie, amuto to lulungei nga ailei waliko tenen lalap lehe i kola ka Haeu taloma nga. Tuahe Haeu kola hani amuto tenenawe kolakol ie, waliko tenen i sohot hani nga masin wanen ti i sohot haniwen Jona tel kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","“Masin ti Jona to ngain toluhu leili tiai tok xixi lalap, nga tel Nati Seilon nga tin ngain toluhu leili amal. Waliko ti i sohot haniwen Jona, i kola hawane hani teka Niniva ka Haeu talo i hani laha kaxiai kakaian. Tin masin waliko ti sohot hani nga, i kola hawane hani amuto teka seilon ti aope ie, ka Haeu taloma nga kaxiai kakaian. ");
INSERT INTO ssg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Nga kakane amuto, tel hehin masiwi ti Siba luama ti xuxun pate xauxaun hongoi soliai nauna ti tel masiwi Solomon. Telao ngain ti Haeu hiniti seilon, waliko ti i aile i sului amuto nake amuto kum hong kakaiak kalak nga pamu tuah ti Solomon. ");
INSERT INTO ssg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tin masin saun ti teka seilon ti Niniva, i sului amuto ti tehu ngain ien nake laha towiahu ti saun lialun tataen ti Jona kaxi ahutiwa kakai Haeu hani laha. Tuahe amuto kum towiahu ti lialui woumuto kalak nga kaxi ahuhuti kakai Haeu hani amuto. A nga pamu tuah ti Jona.” ");
INSERT INTO ssg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jises kak tatale ukek, “Tap tel i hakama tehu kamaian ape i atuhi ma na hana hani hahitake po. Mewenae i hakama hakea hani patul koukean lehe i haxewa leili ing. ");
INSERT INTO ssg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Namilomuto masin tehu kamaiamuto. Aile ape na namilomuto solian, amuto xuhai xewan ti saun solian. Tuahe na namilomuto lialun, amuto xuhai tilokoi saun lialun. ");
INSERT INTO ssg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Amuto eliel kewak waliko ti amuto namiloi sale Haeu se salan, uke namilomuto leili lalape tilokoan. ");
INSERT INTO ssg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Na pahamuto tioi hawane Haeu, i haxewa hatapo hani amuto masin tehu xewai kamaiamuto i haxewa amuto.” ");
INSERT INTO ssg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ti muhi kakai Jises, tel Parisi ilowi i hani tehu angiain. Jises nahih hani leili ingan ape i to ang. ");
INSERT INTO ssg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tel Parisi ongaini ti i ningahi ka Jises tai nuhi minan imat ti i ang. Teka Parisi ma teka Ju liai, laha kum ang na laha tai nuhi minalaha ti usiai saun ti teka matahaun. ");
INSERT INTO ssg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jises kakane i ukek, “Amuto teka Parisi, pate amuto haeliel nuhiai melal ti kap ma pelet tuahe waliko ti amuto ani ma unumi ti leilon, amuto kema ti saun ti pipis ma halepelep. Saun tenen ien i ahutama leilomuto. ");
INSERT INTO ssg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Amuto teka taxitaxia! Haeu tanomi hahuonen melal ma leili lawe waliko. I tanomi tupuamuto ma leilomuto. ");
INSERT INTO ssg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ti leili atemuto, axiwa teka seilon waliko ti laha tap. Na amuto aile ukek, i kola ka amuto kum nam waxi ka auni hauniai waliko i pate tuah. Na masin ien, Haeu namiloi ukek amuto haun ma sawisawin. ");
INSERT INTO ssg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Amuto teka Parisi, Haeu axi hawane amuto kawatan. Amuto hani Haeu tenen ti huopanim soxiamuto masin kai pata ti hanamui an. Tuahe amuto watakai Haeu ma kum aile saun solian hani seilon liai. Ala amuto aile hahuonen. ");
INSERT INTO ssg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Amuto teka Parisi, Haeu axi hawane amuto kawatan. Amuto waheni tonain tuah leili synagog ma amuto waheni seilon kak sameniwa amuto ti puli lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Haeu axi hawane amuto kawatan. Amuto masin amal ti kumahe kilaman ape seilon tau nanahih patul ti tesol amal ien nake laha kum tioi ka waliko kohan leilon.” ");
INSERT INTO ssg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tel ti teka hanaui nauna ti Moses hone Jises, “Tel masiwi, ti o kakane teka Parisi ukek ien, o hahiena hetekie amite!” ");
INSERT INTO ssg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jises kak pahoi ukek, “Amuto teka hanaui nauna ti Moses, amuto tin Haeu axi hawane kawatan. Amuto lungei teka seilon usiai kilai nauna ailan tenen puki ti amuto tuahe amuto kum solonga ti usiai tesol nauna ien ma kum hana minamuto hualiai teka liai. ");
INSERT INTO ssg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Haeu axi hawane amuto kawatan. Teka tamamuto ti matahaun telei teka kuluiai kakai Haeu. Amuto tanomi hasolia hahawane amalulato a amuto kum usi kakaialato. ");
INSERT INTO ssg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ti amuto kum usi kakaialato, i kola hawane ka amuto waheni teletele ti teka matahaun ti amuto aile haniwen teka kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nake ti tenen ien, ti anesoi Haeu hoi i kakawen ukek, ‘Nga talo teka kuluiai kakaiak ma teka aposel hani teka Israel. Laha telei teka ma aile halialu teka.’ ");
INSERT INTO ssg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Aile ape amuto teka seilon ti aope ie, amuto uke kawatan ti teleiai teka kuluiai kakai Haeu hutuima lokon ti Haeu tanomi tehu pon ie. ");
INSERT INTO ssg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Hutuan ti teleiai Abel hanima tataen teleiai Sakaraia, tel laha telei wasole Ingi Haeu ma tone waliko ti teka seilon kau hani Haeu. Salan wanen, Haeu axi amuto kawatan ti hatesol teletele ien. ");
INSERT INTO ssg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Amuto teka hanaui nauna ti Moses, Haeu axi hawane amuto kawatan. Waliko ti amuto hahanau, i tiehi teka seilon ti tioi hawanei Haeu. Puki amuto, Haeu kum neini amuto ape tin amuto neini hasele teka ti pahalaha Haeu neini laha.” ");
INSERT INTO ssg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ti teka hanaui nauna ti Moses ma teka Parisi hongoa, lolaha lialu hawane. Hutui taen ien laha watakai hawane Jises ma kamei i kilan kamekame ailan. ");
INSERT INTO ssg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Laha kak hahika i lehe i kak waliko tenen laha pon suluan. ");
INSERT INTO ssg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lokon ien kilan wanen seilon apupuha. Pahalaha wanen laha ngasoha hani kapi Jises ape laha pisipis hawane. Jises kakanemu imat teka kahikahin. I ukek, “Lepeteniwa amuto ti teka Parisi nake leholaha huoka. ");
INSERT INTO ssg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Imuh Haeu hatakei hawane namili teka laha putini ka laha seilon liai tenen ti puki alia laha. Haeu hatakei lawe waliko ti laha mumuneni. ");
INSERT INTO ssg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ape waliko ti amuto kak lilikoheni, imuh Haeu kak hatakei hani lawe seilon. Kilan seilon laha tunahi waliko ti amuto kaxi mumuneni hani teka seilon liai. ");
INSERT INTO ssg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Amuto teka kahikahik, nga kakane hawane amuto, kum maamata teka pahalaha laha telei amuto. Laha tua telei tupuamuto tuahe laha kum pon teleiai hatesol waliko ti leili namilomuto ma atemuto. ");
INSERT INTO ssg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mamatawa mewenae Haeu. I pon telei xoiniamuto hani tesol ti kaui kawatan tap tahi tapoan. Nga kaxi ulea ka Haeu tel amuto mamatawa. ");
INSERT INTO ssg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Amuto tioi ka moni kokol i pon kahuiai tepanim piakus nake lato pate naun. Tuahe Haeu nanamiloi lato hatesol. ");
INSERT INTO ssg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aile ape amuto kum maamata. Haeu namiloi ukek ka amuto pamu tuah ti piakus. Kalak taen ukumuto i tioi hatapo mongohuan. ");
INSERT INTO ssg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nga kakane hawane amuto, na tel seilon i kak hei ti puli seilon ka i kahikahik, tin nga kaxi hani Haeu ma teka engel tetan ka i kahikahik. ");
INSERT INTO ssg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tuahe na tel seilon puluhini ti puli seilon ka i kahikahik, tin nga kaxi hani Haeu ma teka engel tetan ka i kumahe kahikahik. ");
INSERT INTO ssg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tel na i kak halialu nga tel Nati Seilon, Haeu oxoxi i ti kawatan ti saun lialun ien, tuahe tel na i kak halialu Holi Spirit, Haeu kum oxoxi i ti kawatan ti tenen saun lialun ien. ");
INSERT INTO ssg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Na laha sului amuto hani teka masiwi ti synagog ma teka masiwi tenen tenen, kum hahakila namilomuto waliko tenen na amuto kak ti awaiamuto. ");
INSERT INTO ssg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pake tataen ien ape Holi Spirit hanamiloa amuto waliko tenen na amuto kak.” ");
INSERT INTO ssg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Muhin tel ti leili teka kilai seilon ien kakane Jises, “Tel masiwi, honewa tel ukalak ka i seiwa wasolamili soxi ti tel tamamili mat lioi haniwen amili.” ");
INSERT INTO ssg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jises kak pahoi i, “Tap tel kilamiwen nga aile hasawiai wasolamulu.” ");
INSERT INTO ssg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ape i kakane laha hatesol, “Lepeteniwa amuto kum halepelep ti tenen tenen. Kalak mongohe soxi ti amuto hina, i kum pon i hasolia ma i hawelu tonamuto he tehu pon ie.” ");
INSERT INTO ssg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ape Jises kaxi hani laha tenen meng ti hanaualaha. I ukek, “Tel seilon ti pate kilan soxi, i teik hepekeun ti an pate xex soli. ");
INSERT INTO ssg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","I kakane aliake i, ‘Ing ti apuhiniai anak ape xuhan. Tap tonan liai. Kaie nga aile ukek ia?’ ");
INSERT INTO ssg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“I namiloi ape i ukek, ‘Nga toi haputa tetehu ape atai tehu ing pamu lalap lehe nga hana hatapo anak ma soxiak hani leilon. ");
INSERT INTO ssg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nga apuhini hapono hawane lehe i pon ti ahang kilan. Ape nga kum puas. Nga tua ang, un ma to amuam.’ ");
INSERT INTO ssg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Tuahe Haeu kakane i, ‘O pate tap namilom. O mat ipong tetehu ie ape seilon liai uke hatesol soxiam.’” ");
INSERT INTO ssg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ape Jises ukek, “Salan wanen, seilon tenen tap namilon i apuhini hakila soxi mewenae tetan a i kum aile waliko tenen Haeu namiloi ukek ka pate tuah.” ");
INSERT INTO ssg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jises hone tesol kahikahin, “Aile ape amuto kum namiloi hahakila an ma sosomuto. ");
INSERT INTO ssg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sale totonamuto seilon pamu tuah ti an a tupuamuto pamu tuah ti maia. ");
INSERT INTO ssg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Namiloi paxaiwa manixux. Laha kum seseini ma kum apupuhini an tuahe Haeu ngangahati laha. Nga kakane hawane amuto ka Haeu namiloi ukek amuto pamu tuah ti manixux. ");
INSERT INTO ssg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kaie amuto pon hawelu ahekei tuahe na teik totonamuto ti amuto to nanamiloi? ");
INSERT INTO ssg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na amuto kum pon, tap salangawan ti amuto to nanamiloi waliko liai. ");
INSERT INTO ssg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Namiloi paxaiwa sale xexei palawa. Laha kum pupuas sawitiai maia sosolaha! Tuahe nga hone amuto, kalak taen tel masiwi Solomon, soson maia ma hatesol waliko solian tetan, i kum pon soliai palawa. ");
INSERT INTO ssg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Haeu tel i ngangahati pahoah, i ie tetelao ape letu laha lui xoini. Kaie kumahe pamu Haeu ngahati aluluini amuto? Amuto tap namil xoxoan hani i. ");
INSERT INTO ssg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ape kum nanamiloi ukek, ‘Kaie anak ma unumak nga kema ia?’ Kum namiloi hahakila tesol waliko ien. ");
INSERT INTO ssg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Teka laha kum tioi Haeu, laha to namiloi hahakila tesol waliko ien. Tuahe tel Tamamuto Haeu tioi waliko ti amuto tap. ");
INSERT INTO ssg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Haniwa i neini amuto ape ailewa waliko tenen i hamuamua i. Ape i hani amuto hatesol waliko ien. ");
INSERT INTO ssg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Amuto tesol kahikahik, kalak amuto palai ma kumahe pate kuin, kum maamata. Pake tel Tamamuto Haeu hani amuto neiniai seilon kapin. ");
INSERT INTO ssg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Hangainiwa soxiamuto lehe amuto axi moni hani teka seilon totonalaha lialun. Hani hatapoa kuimuto ma namilomuto haniwa Haeu. Ie masin ka amuto apepeseni kahumuto ti tonan. Tesol ien tap tahi lialuan ma tap teka xuxuina. ");
INSERT INTO ssg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Namilomuto toi waliko tuah ti amuto, aile ape kewa Haeu kapitiai namilomuto.” ");
INSERT INTO ssg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jises kakane teka kahikahin ukek, “Amuto apeasawa ailei puase Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Amuto hanowiwa teka seilon laha atetengi tel tame ing ti i aliama ti tehu sala. Liai laha apepeas heiai kahip ti i tahiama. ");
INSERT INTO ssg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ti tel tame ing paxai tunahiwa ka teka unauan to atetengi aliaian, lato uke kahulato. Nga kakane hawane amuto, puki i hatona lato ma axi analato. ");
INSERT INTO ssg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kalak na i tahiama ti luhui ipong ma na sikole letu ape i paxai tunahi lato to atetengi aliaian, lato uke kahulato. ");
INSERT INTO ssg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Amuto hong matainiwa, na masin tel tame tehu ing i tioiwen lokon tel seilon ti xuxuina nahima, ala i ah peteni lehe tel seilon kum soh hani leili ingan. ");
INSERT INTO ssg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aile ape amuto kum luhuluh nake amuto kum tioi lokon wanen nga tel Nati Seilon aliama.” ");
INSERT INTO ssg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita ukek, “Tel Masiwi, nakon kakaiam nanami mewenae amite teka kahikahim ka i nanami lawe seilon?” ");
INSERT INTO ssg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jises pahoi ukek, “Nga kakak tel na seilon i aile puase tel masiwi tetan. I hani i ngahatiai teka unauan liai ma axiai analaha ti taun ti angiain. ");
INSERT INTO ssg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ti tel masiwi tahiama ape i paxai tunahi ka tel unauan aile aluluini pupuasan, i axi kahun. ");
INSERT INTO ssg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nga kakane hawane amuto, i hani tel unauan ngahatiai lawe soxian. ");
INSERT INTO ssg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tuahe na tel unauan seilon lialun, i namiloi ukek, ‘Tel masiwi tetak aliaian kuen.’ I hutui xaiai teka unaui tel masiwi hahitakan ape i tua ang ma un taxitaxia. ");
INSERT INTO ssg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Imuh tel masiwi alia haongama tel unauan ien. Ape i axi hawane i kawatan. I towi i hani tesol ti teka laha kum hong tamani Haeu, tesol ti laha kau kawatan ma moloan lalap. ");
INSERT INTO ssg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Tel masiwi axi i kawatan nake kalak i tioi puasain tetenen ala i aile, i tai puas usi. ");
INSERT INTO ssg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tuahe tel na i kum paxai tioi ka waliko i ailele se lialun, i uke kawatan kokol. Na Haeu hani halapa tel seilon, i amemene ka tel seilon ien hani aliake i tin lalap. Na Haeu hana tel seilon ngahatiai waliko tenen pate tuah, i amemene ka tel seilon ien ngahati aluini akulai tetel Haeu hani i puasain tenen naun.” ");
INSERT INTO ssg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jises kak ukek, “Nake ti tenen puasain Haeu haniwen nga aile he tehu pon ie, teka seilon solian ma lialun laha selaia. Nga hahaxe sohotuan. ");
INSERT INTO ssg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tuahe imat ti i sohot, nga kau kawatan ma moloan lalap ape nga mat. Namilok i kum to alua, atengi taen i tinama. ");
INSERT INTO ssg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kum nanamiloi ka nga tahiama hasoliai wasole seilon ti tehu pon ie. Kumahe, kakain nga kema ti Haeu i axi wasole teka namilolaha xoxoan hani Haeu ma teka laha kum soh kakaian. ");
INSERT INTO ssg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Aile ape teka seilon leili ing tehu laha he lungelung huak ape laha selaia. ");
INSERT INTO ssg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tel taman pahoi tel natun wawan, tel tinan pahoi tel natun hehin ma hahuihan tel pahoi tel.” ");
INSERT INTO ssg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jises kakane teka kilai seilon, “Na amuto paxai maun atai sai ahang, amuto ukek i ux ape salan. ");
INSERT INTO ssg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na aupol ahoma sai angiha, amuto ukek kekean tahiama ape salan. ");
INSERT INTO ssg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Lehomuto huoka! Amuto tioi hunan na amuto paxai maun. Tuahe amuto kum tioi salangawe waliko ti i sosohot aope ie ma waliko ti nga ailele nake amuto putini ka amuto tioi Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Aile aluiniwa namilomuto ti waliko tenen Haeu paxai ukek sawisawin. ");
INSERT INTO ssg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Na tel i namiloi suluiai tel ti amuto, hasawi koseniwa wasolamulu uke i hatuhi o hani puli tel masiwi ti hongoi meng. Ape i hana o hani mini teka laha kalabusi o. ");
INSERT INTO ssg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na i sohot ukek ien, o kum ahuta atengi o hamate hatapoa moni. Tin masin amuto hasawiwa wasolamuto ma Haeu, uke amuto kau kawatan ti lialui woumuto.” ");
INSERT INTO ssg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lokon ien hina seilon laha kakane Jises ka Pailat, tel kiliwakei texux xux Galili, i hone teka unauan teleiai teka seilon ti ien. Laha telei lato leilon ti lato kakau waliko hani Haeu leili Ingan. ");
INSERT INTO ssg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jises kak ukek, “Kum namiloi ukekek ka sale matealato pate lialun masin nake woulato pamu lialuan ti teka seilon liai leili Galili. ");
INSERT INTO ssg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kumahe! Tuahe na amuto kum towiahu ti lialui woumuto hani Haeu, tin amuto mat ape wasolamuto ma Haeu kum sawi. ");
INSERT INTO ssg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ape tesol 18 seilon tehu ing lalap ti Siloam mahus telei lato, kum namiloi ukekek ka lato mat ukek ien nake woulato pamu lialuan ti teka seilon liai leili Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kumahe! Tuahe nga kakane ulei amuto, na amuto kum towiahu ti lialui woumuto, tin amuto mat ape wasolamuto ma Haeu tin i kum sawi.” ");
INSERT INTO ssg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Muhin ien Jises kaxi hani laha tenen meng hanaualaha waliko i sohot hani teteka tap pupuasalaha ti Haeu. I ukek, “Tel seilon seini tea laku leili tesol kin. Lawe i to nahih papaxai na masin i huawen tuahe i tai huhua. ");
INSERT INTO ssg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ape i hone tel ngahatiai kin, ‘Ahang toluhu nga atengi na tea pata i hua tuahe nga kum niningah tehu na huan. Koti hamahusu xaxaweniwa! I tua hapuasa xoini hepekeun.’ ");
INSERT INTO ssg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Tuahe tel ngahatiai tesol kin ukek, ‘Tilimuen, paxai ahekemua ahang liai tehu lehe nga ngahati hasolia aheke ape nga piei. ");
INSERT INTO ssg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sohin i hua ahang tehu toma. Na i kum hua, ien, koti xaxaweni.’” ");
INSERT INTO ssg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Telao Sabat Jises hahanau teka seilon leili tehu synagog. ");
INSERT INTO ssg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ti ien tel hehin spirit lialun kapiti hahalialu. Leili ahang 18 tehiton kakawin ma i kum hokaha uke. ");
INSERT INTO ssg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ti Jises ningahiwa, i tiloi tel hehin ape i ukek, “Nga aile haewia o.” ");
INSERT INTO ssg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","I hanawa minan patul ti tel hehin. Hahutuia hawane tel hehin hokaha ape i sameni Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tel masiwi ti tehu synagog lon lialu hawane nake Jises haewia tel hehin telao Sabat ape i kakane teka seilon ien ukek, “Ngain tepanim tehu ailei puasain. Nahima leili tesol ngain ien lehe haewia amuto, kumahe telao Sabat!” ");
INSERT INTO ssg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jises tel Masiwi pahoi i, “Seilon lehomuto huoka! Puki amuto pupuas telao Sabat. Amuto upati tupumuto manihuh ape hakahita axi unumalaha telao Sabat. ");
INSERT INTO ssg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tel hehin ie, tel kahi nati Abraham, Satan kapiti hahalialu leili ahang 18. Nakon lialun ti oxoxiai tel hehin telao Sabat?” ");
INSERT INTO ssg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kakaian hahiena teka lato watakai hawane i. Tuahe teka seilon liai laha amumuke soliai puasain ti i ailewen. ");
INSERT INTO ssg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jises ukek, “Nga kak kolongeni haxewa hani amuto sale nenein ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ien masin tehu kokole waki lilieu tel seilon seini. Kalak i pate kokol, i xex lap ape i sohot tea pata lapalap wanen. Ngaxon lap hawane ape manixux atai ingalaha ien.” ");
INSERT INTO ssg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jises kak ukek, “Nga kaxi ulei hani amuto sale nenein ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ien masin teik kokole ist tel hehin waxi ape i talini hani he palawa. Kalak teik ist kokol, i haxiwa palawa hatehu.” ");
INSERT INTO ssg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ti Jises nahih tatale hahaniwa Jerusalem, i hahanau teka seilon leili toan ma taon tehu tehu. ");
INSERT INTO ssg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tel seilon kamei i, “Tel masiwi, kaie palai seilon Haeu awai ti kawatan ti lialui woulaha?” Jises pahoi i, ");
INSERT INTO ssg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Amuto elieliwa sohoi tewau aweing omiomin kane tesol tonain kapi Haeu ti tap tahi tapoan. Aweisal tetewau kumahe malimun. Kilan seilon laha tohongi hani ien tuahe laha kum pon. ");
INSERT INTO ssg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tewau aweing kane tesol ien hean tutuen. Tuahe na tel tame tesol ien i keiti kahip, amuto teka amuto kum non usi tewau aweing omiomin, amuto tu melal kikini kahip ape kamea ukek, ‘Hei hanima amite kahip.’ “Tuahe i ukek, ‘Nga kum tioi amuto ma tesol amuto luama.’ ");
INSERT INTO ssg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ape amuto ukek, ‘A amite ang ma un akati hakilawen o ma o hahanauen seilon leili taon ti amite.’ ");
INSERT INTO ssg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ape i ukek, ‘Nga kakane tuhi amuto, nga kum tioi amuto. Xaxaua tetak amuto teka weli ailei saun lialun.’” ");
INSERT INTO ssg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jises kak tatale ukek, “Ape taen ien amuto ningahi Abraham, Aisak, Jekop ma teka kuluiai kakai Haeu lato hatesol kapi Haeu leili tonan, a amuto, Haeu halini amuto soh. Aile ape amuto tang ma atalahi nisumuto ti lialui lomuto ma ti lalape moloan. ");
INSERT INTO ssg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kilan seilon laha ahuma xux tesol tesol ape laha to leili tehu angiain lalap Haeu apepeseni leili tonan. ");
INSERT INTO ssg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ape teka seilon kemuk teka liai paxai ukek pate naun, tataen ien Haeu paxai ukek laha tuah. Ape teka seilon kemuk teka liai sameni laha, tataen ien Haeu paxai ukek laha pate naun.” ");
INSERT INTO ssg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lokon ien teka Parisi nahima ape laha hone Jises, “Lua saliliwa ie nake Herod Antipas pahan i telei o.” ");
INSERT INTO ssg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jises hone lato, “Nahih honewa Herod tel weli moleiai seilon ka nga xaxaweni tatale spirit lialun ti seilon ma haewia tatale laha. Tuahe kum kue nga hatapo tenen puasain ti Haeu hani nga aile. ");
INSERT INTO ssg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tap tenen i kongini nga ti ailei tenen puasain ien ti tehu luaiak hani Jerusalem. Ti ien amuto telei kilan teka kuluiai kakai Haeu ape nga masin tel ti laha.” ");
INSERT INTO ssg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ape Jises nameni teka seilon ti Jerusalem. I ukek, “Teka seilon ti Jerusalem laha hokai telei teka kuluiai kakai Haeu pot, teteka ti i talo haniwen laha. Nga tohongi hakilawen apuhini aumialaha masin mom hehin poni natun hahitake paun, tuahe laha watakai. ");
INSERT INTO ssg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aile ape Haeu lioi laha. I kum ingai tehu Ingan ape i kum to leili tehu taon kapi laha. Nga kakane hawane amuto, laha kum ningahi ulea nga atengi tataen laha ukek, ‘Kako amukewa tel i nahih hehetekiema poh ma solian ti Haeu.’” ");
INSERT INTO ssg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ngain tehu ti Sabat, Jises nahih ang hani ingi tel ti teka masiwi ti teka Parisi ape teka seilon ien paxai oti na i aile tenen ti na i pon lato sului i. ");
INSERT INTO ssg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tel wawan leilolato hina nax tenen i haxekaxeka tini seilon. ");
INSERT INTO ssg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jises kakane teka Parisi ma teka hanaui nauna ti Moses ukek, “Ala amuto tioiwa ka nauna ti Moses kum hahalini haewiai seilon telao Sabat.” ");
INSERT INTO ssg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lato tai kak pahoi na tenen. Jises aka soti tel wawan ien ape aile haewia. Muhin ien i talo aliake. ");
INSERT INTO ssg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ape i kakane lato, “Na tel ti amuto tel natun ma na tok tupun manihuh put hani he kan wal telao Sabat, kaie amuto kum ahuti? Se amuto aile.” ");
INSERT INTO ssg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tuahe lato kum tunah pahoi kakaian. ");
INSERT INTO ssg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jises ningahi ka teka seilon lato nahima ti tehu angiain, lato upiup tonain tuah. Ape i nau lato ukek, ");
INSERT INTO ssg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Na tel seilon ilowi o hani tehu angiain ti sala, o kum upiup tonain tuah uke laha ilowiwen tel seilon pamu masiwian tetam. ");
INSERT INTO ssg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na i sohot ukek ien, tel tame tehu angiain hone o, ‘Hatahawa tonain ien haniwa tel seilon ie.’ Na i aile ukek ien o tahunos ape o nahih to hani tonain kaliap. ");
INSERT INTO ssg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Pamu ewian na o to hanimu tesol tonain kaliap. Na tel tame tehu angiain ningahi o ien, uke i hone o, ‘Tel lawak, nahih to haniwa tesol tonain tuah.’ Na i sohot ukek ien, hatesol seilon ien laha ningahi ka tel tame tehu angiain pate i aile aluini hani o. ");
INSERT INTO ssg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nga kaxi hahani amuto waliko ie nake Haeu teheni teka seilon ti hanasanas ape teka laha teheni laha, Haeu aile laha seilon tuah.” ");
INSERT INTO ssg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Muhin Jises kakane tel Parisi i ilowi i ukek, “Na o aile angiain lalap, kum iilowi mewenae teka lohum, teka akikim wanen ma teka seilon laha kilan soxi. Teka seilon ien i pon laha kahui aliake o. ");
INSERT INTO ssg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Na o aile angiain lalap, o ilowi hetekiewa teka seilon tap soxi, teka waxosi ma teka pulaxa. ");
INSERT INTO ssg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kalak teka seilon ien kum kahui uke hani o, Haeu kahui aliake hani o taen ti i xahateni teka seilon sawisawin ti matealaha.” ");
INSERT INTO ssg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tel ti leilolato hongoa ape i kakane Jises ukek, “Amuamui teka Haeu neini laha ma laha soh leili tehu angiain lalap ti Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jises hongoa ape i kaxi hani lato tenen meng, i ukek, “Tel seilon apepeseni tehu angiain lalap ape i ilowi hakila seilon. ");
INSERT INTO ssg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ti i meiwa taun ti angiain, i talo tel unauan honei teka seilon i ilowiwen nahima nake lawe waliko apeasawen. ");
INSERT INTO ssg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Tuahe laha hatesol aile ngah kakain tenen tenen lehe laha kum nahiwa. Tel i ukek, ‘Nga kahuiwen teik hepekeun. Pahak nga paxai kalisimu, aile ape nga kum nahima.’ ");
INSERT INTO ssg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tel liai ukek, ‘Nga kahuiwen 50 nati pou. Pahak nga ailemu tiehialato, aile ape nga kum nahima.’ ");
INSERT INTO ssg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tel liai ulea ukek, ‘Nga sasalawa pate aope, aile ape nga kum nahima.’ ");
INSERT INTO ssg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Tel unaui tel tame tehu angiain nahih alia ape i kaxi hani i hatesol waliko ti teka seilon kakawen. Tel tame tehu angiain lon lialu hawane ape i hone tel unauan ukek, ‘Nahih haniwa lawe aweisal ti taon ape ilowima teka seilon tap soxi, teka waxosi ma teka pulaxa.’ ");
INSERT INTO ssg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Tai kue tel unauan aliama ape hone i ukek, ‘Nga ilowiwen laha tuahe kilan totoan tutuen.’ ");
INSERT INTO ssg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ape tel tame tehu angiain hone tel unauan ukek, ‘Nahih haniwa aweisal melal ti taon ape eliel hawanewa ilowiai teka seilon hanima tehu angiain lalap nake pahak tehu ingak i xuh. ");
INSERT INTO ssg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nga kakane amuto hatesol ka teka nga ilowimu ape laha kong, tap tuahe na tel ti lato i soh leili tehu angiain ien.’” ");
INSERT INTO ssg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kilan wanen seilon kakahiti Jises. I toheawa ape i kakane laha ukek, ");
INSERT INTO ssg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Na tel seilon pahan i sohot kahikahik, i waheni hawanewa nga xoiniwa ti i waheni taman, tinan, axoan, natun, ukalan, tuan ma puki alia i. Na tap, i kum pon kahikahik. ");
INSERT INTO ssg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tel na pahan kum is kaui kawatan masin ti nga kakau i kum pon kahikahik. ");
INSERT INTO ssg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Na paham o sohot kahikahik, namiloi matainimua nake kumahe puasain malimun. Masin tel na i atai tehu ing. Imat i to namiloi paxaimu ka hatesol waliko ti ataiai tehu ing i tapai. ");
INSERT INTO ssg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Na i kum aile ukek ien, waliko ti ataiai tehu ing uke i tae. I tua hutui lioi a i kum huna. Ape teka seilon soxeni i. ");
INSERT INTO ssg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Laha ukek, ‘Tel seilon ie i hutui ataiai tehu ing tuahe i kum hahuna uke.’ ");
INSERT INTO ssg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Tin masin tel masiwi ti hile. Na unauan ti hile pamu palaian ti tel lehe i hilei, i to namiloi aluinimu kapi teka masiwi hahitakan ka i waxaini a kumahe. ");
INSERT INTO ssg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na lato ukek i kum waxaini, i talo teka seilon tetan hani kapi tel masiwi ti hile ti tepaun liai ti kak hasawiai wasolalalu.” ");
INSERT INTO ssg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ape Jises tili kakaian i ukek, “Tap tel ti amuto i pon kahikahik halik i hani hatapo nga neini i. ");
INSERT INTO ssg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Teka kahikahik wanen laha masin sol. Sol solian tuahe na taxian tetan i tapo, tap aweisal ti hataxia aliakean. ");
INSERT INTO ssg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","I ape tap pupuasan. Na amuto hina taxing ti hongoi kakaiak, hong matainiwa lehe amuto xeu.” ");
INSERT INTO ssg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Teka seilon waxiai moni hani teka masiwi ti Rom ma teka seilon woulaha lialun kewi laha nahih hani kapi Jises lehe laha hong na i hanau seilon. ");
INSERT INTO ssg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tuahe teka Parisi ma teka hanaui nauna ti Moses lato howini woun. Lato ukek, “Tel seilon ie i lawai teka seilon woulaha lialun ma i ang akati laha.” ");
INSERT INTO ssg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Telao Jises kaxi hani lato tenen meng i ukek, ");
INSERT INTO ssg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Amuto namiloi ukek ia? Na tel ti amuto hina 100 sipsip ape tok i nahih mitaxia, hoi liai i nahih salili tesol 99 ape i nahih upia tok i mitaxiawen atengi taen i tunahi. ");
INSERT INTO ssg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ti i tunahiwa i amuam hawane ape i kau tok sipsip he wahen hani tonan. ");
INSERT INTO ssg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","I tiloi apuhini teka lawan ma teka seilon ingalaha xohixohin, i ukek, ‘Amuam akatima nga nake nga tunahiwen tok tupuk sipsip i mitaxia.’ ");
INSERT INTO ssg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tin masin wanen Haeu ma teteka kapin leili tonan lato amuke tel seilon lialun na i towiahu ti lialui woun, i xoini ti na lato amuke tesol 99 seilon sawisawin pake laha hoi liai seilon sawisawin.” ");
INSERT INTO ssg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jises kak ulea ukek, “Na tel hehin hina huopanim moni ape tehu i put kaluta, liai i hakama tehu kamaian ape i upia mataini leili ing atengi taen i tunahi. ");
INSERT INTO ssg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ti i tunahiwa, i ilowi teka lawan ma teka ingalaha xohixohin, i ukek, ‘Amuam akatima nga nake nga tunahiwen tehu moniuk i put kaluta.’ ");
INSERT INTO ssg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tin masin Haeu ma teka engel, spirit solian tetan, lato amuke tuahe tel na seilon lialun na i towiahu ti lialui woun hani Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jises kaxi ulea tenen meng, i ukek, “Tel seilon natun hua akaik wawan. ");
INSERT INTO ssg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tel komuh hone tel taman, ‘Seiwa soxiam ape hanima nga ti tetak.’ Kakanua tel tamalalu sei soxi wasolalalu. ");
INSERT INTO ssg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Tai kue, tel komuh apeseni hatesol soxian ape i ku hani texux xux xauxaun. Ti ien i tua hapuasa xoini hatapo moniun. ");
INSERT INTO ssg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Taen i hatapoa moniun, tehu lape hitolo tunahi seilon ti texux xux ien ape i tap wanen teik na waliko. ");
INSERT INTO ssg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aile ape i nahih ngah puasan kapi tel seilon ti texux xux i toto. Tel seilon ien talo i ngahatiai teka tupun pou. Tenen puasain ien, teka Ju namiloi ukek puasain ti pate hahien. ");
INSERT INTO ssg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","I hitol lialu hawane ape pahan is aniai taen ani pou, tuahe tap tel seilon axi anan. ");
INSERT INTO ssg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ti namilon xewawa i namiloi ukek, ‘Teka unaui tel tamak analaha i tua sesea a nga hitol lialu hahawane ie. ");
INSERT INTO ssg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nga alia hani kapi tel tamak ape kakane i ukek, “Nga ailewen saun lialun hani o ma Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nga kumahe solian ti i tapai o namiloi ukek nga natum. Hapuasa nga hanowiwa tel ti teka unauam.”’ ");
INSERT INTO ssg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Ape salan, i nahih alia hani kapi tel taman. Tel taman ningahi i xauxaun tutuen ape lon tel hawane. I kiliwau amuam aka aumi tel natun ape i asoi taliopan. ");
INSERT INTO ssg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tel natun ukek, ‘Tel tamak, nga ailewen saun lialun hani o ma Haeu. Nga kumahe solian ti i tapai o namiloi ukek nga natum.’ ");
INSERT INTO ssg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Tuahe tel taman hone teka unauan ukek, ‘Kau kosenima tehu puxux pate solian ape puxui haniwa i. Nihiniwa teik ring tuah he ngaxe minan ape hanawa su he aen.’ Tel taman aile ukek ti kolakol ka tel natun uke aliakewen totonan. ");
INSERT INTO ssg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tin i hone lato, ‘Nahih waxiwa tok bulmakau xuxu ape teleiwa lehe kako aile tehu angiain lalap ti amukei tel natuk. ");
INSERT INTO ssg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Amuam akatima nga nake tel natuk ie, i masin tel seilon i matewen ape i moih alia. I masin tel seilon i kalutawen ape nga tunahi aliake.’ Ape lato hutui tehu angiain lalap. ");
INSERT INTO ssg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Lokon ien tel ukalan pamu he kin. Ti i nahih xohi hahanima leili ing i hong tunahi seilon pak amuam. ");
INSERT INTO ssg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","I tiloi tel unaui tel taman ape i kamei, ‘Laha hehei la?’ ");
INSERT INTO ssg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Ape i pahoi ukek, ‘Tel ukalam aliawen ie ape tel tamam hone amite teleiai tok bulmakau xuxu nake i amuke hawane tel natun aliama huliwi.’ ");
INSERT INTO ssg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Tel ukalan pamu lon lialu ape i kum soh hani leili ing. Tel taman sohotua ape kamei eliel i na i soh akati laha. ");
INSERT INTO ssg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tuahe i kak pahoi tel taman ukek, ‘Mongohe ahang nga puas eliel hahawane tetam ma nga tai tatahi o na tehu. Tuahe o tai hahani nga tuahe tok na mom lehe nga ang amuam kapi teka lawak. ");
INSERT INTO ssg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tuahe tel lialui natum ien i tua xoini monium hani teka hehin ti aweisal. Ti i aliama ape o telei tok bulmakau xuxu ti amukean.’ ");
INSERT INTO ssg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tel taman hone i ukek, ‘Tel natuk, o kapik lawe ngain. Waliko tetak se tetam. ");
INSERT INTO ssg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tuahe ewi wanen kako amuam tetelao nake tel ukalam i masin tel seilon i matewen ape i moih alia. Masin ka i kalutawen ape nga tunahi aliake.’” ");
INSERT INTO ssg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jises kaxi hani tesol kahikahin tenen meng. I ukek, “Tel seilon soxian pate kilan, i tel unauan ti ngahatiai moniun. Teka unauan liai tunahi ka tel ngahatiai moni pipisi tel masiwi tetan sale hapuasai moni ape lato kaxi hani i. ");
INSERT INTO ssg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tel masiwi tiloi tel ngahatiai moni ape i ukek, ‘Nga tunahiwen ka o pipisi nga. Aile ape liai nga xaxaweni o ti pupuasam. Tai haxewa hanima nga sale hapuasai moniuk.’ ");
INSERT INTO ssg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Tel ngahatiai moni namiloi ukek, ‘Kaie nga aile la? Tel masiwi tetak i hatapo nga ti pupuasak. Nga tap kuik ti ailei puasain tenen ailan ma nga hiena na nga kat. ");
INSERT INTO ssg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nga tioiwen. Nga aile ngah aweisal lehe teka seilon waxi auni nga na nga tapoa pupuasak.’ ");
INSERT INTO ssg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“I ilowi tel tel ti teka laha kemu moniai tel masiwi. I kameimu tel, ‘O kewen hil waliko ti tel masiwi?’ ");
INSERT INTO ssg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“I ukek, ‘3,000 patula wel.’ “Tel ngahatiai moni hone i ukek, ‘Waxiwa teik pepa i kola mongohe waliko ti o kewen ape o tai sohiwa. Hanawa 1,500 patula wel.’ ");
INSERT INTO ssg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“I kamei tel liai ukek, ‘O kewen hil?’ “Tel seilon ukek, ‘16,000 tomi komem.’ Tel ngahatiai moni hone i ukek, ‘Waxiwa teik pepa i kola mongohe waliko ti o kewen ape tai sohiwa. Hanawa 12,800 tomi komem.’ Tel ngahatiai moni tin i aile hani teka liai. ");
INSERT INTO ssg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Kalak tel ngahatiai moniun pisiwen i, tel masiwi tetan sameni i ti upiai aweisal lehe teka seilon huali i na i tapo ti pupuasan.” Jises tili kakaian ukek, “Nga kaxi hani amuto tenen meng ie nake kilan seilon laha kumahe ti Haeu, laha hapuasa namilolaha ti taneniai waliko ti i sosohot tehu pon ie, i xoini teka seilon ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nga hone amuto, hapuasawa moniumuto ti hualiai seilon. Na amuto aile ukek ien, amuto tunah lohumuto. Kalak na moniumuto tapo, imuh Haeu waxi auni amuto hani tesol tonan. ");
INSERT INTO ssg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Tel na i ngahati aluini waliko kokol, tel masiwi tetan soh i ti ngahatiai waliko pamu lapan. Tel na i pisi tel masiwi tetan ti waliko kokol, tel masiwi tetan kum soh i ti ngahatiai waliko pamu lapan. ");
INSERT INTO ssg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na amuto kum ngahati aluini waliko ti tehu pon ie, Haeu kum soh amuto ti ngahatiai waliko tuah tetan. ");
INSERT INTO ssg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na amuto kum ngahati aluini waliko ti Haeu haniwen amuto he tehu pon ie, Haeu kum hani amuto waliko tenen pate solian ti tesol tonan. ");
INSERT INTO ssg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Amuto kum puas uke hahitake masiwi hua, uke amuto waheni tel ape amuto watakai tel, amuto hong kakai tel ape amuto kum hong tel. Amuto kum aile uke puase Haeu na masin namilomuto tin xoxoan ti ngahoi moni.” ");
INSERT INTO ssg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ti teka Parisi hongoa waliko ti Jises kakak, lato soxeni i nake lato seilon tenen pate pahalato moni. ");
INSERT INTO ssg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jises hone lato, “Amuto puas eliliel kolaiamuto lehe seilon sameni amuto tuahe Haeu tioi hawane leilomuto. Hina waliko tenen seilon hana tuah ti laha, Haeu namiloi ukek pate lialun masin ti na seilon pate pahan moni.” ");
INSERT INTO ssg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jises kak tatale ukek, “Imat ti Jon Baptis kaxi ahuti kakai Haeu, amuto teka Israel hahitake hatesol nauna ti Moses ma kakain ti teka kuluiai kakai Haeu. Tuahe aope ie, nga ma tesol kahikahik kakaxi meng solian ti Haeu neini seilon ape kilan seilon pahalaha wanen Haeu neini laha. ");
INSERT INTO ssg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tuahe kumahe ka tesol nauna ien kumahe tuah. Nga kakane hawane amuto, maun ma tehu pon ie i tapo tuahe tap teik ti tesol nauna ien i kumahe tuah. ");
INSERT INTO ssg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Tuahe kilan ti amuto, amuto hakalala nauna ti Moses masin tenen nauna sale lioiai hehin. Nga hone amuto, na tel i lioi tel axoan hehin ape i uke liai tel, Haeu namiloi ukek i ailewen saun lialun ti wawan hehin. Ape tel na i uke axoan tel hehin ti wawan liai lioi, tin masin Haeu namiloi ukek i ailewen saun lialun ti wawan hehin.” ");
INSERT INTO ssg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jises hahanau tutuen laha ape i kaxi tenen meng i ukek, “Tel seilon tenen kilan soxi, soson mewenae solian. Husele kilai waliko tetan ape i ang amuam kapi teka lawan tapai ngain. ");
INSERT INTO ssg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tel seilon axan Lasarus, tap wanen soxian ma tinun kilai naxon. Lawe laha hatona i aweingi tel seilon kilan soxi. Mewenae i to katekat an ma moni. ");
INSERT INTO ssg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pahan wanen i ani taen peni an na i put hani itan hahitake tone ani tel seilon kilan soxi. Taen teka sinen laha nahima kamoti naxonaun. ");
INSERT INTO ssg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Imuh Lasarus mat ape teka engel waxi i hani tone Haeu kapi Abraham, tetesol tonain pate tuah. Tel seilon kilan soxi tin i mat ape laha tihini. ");
INSERT INTO ssg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","I kane tesol kaui kawatan ti tap tahi tapoan. I lamani hawane moloan. I xeisa hanile patul ape i ningahi Abraham xauxaun wanen, hetekie Lasarus. ");
INSERT INTO ssg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Ape i tilol, ‘Tel tamamite Abraham! Nga lamani hawane moloan he tehot ah ie. Tahanema nga ape taloma Lasarus lehe i soti ngaxe minan he kan ape hawai lehok.’ ");
INSERT INTO ssg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Tuahe Abraham ukek, ‘Tel natuk, nameniwa ti imat. O hina waliko tenen solian ti paham lokon ti o tutuen he tehu pon itan a Lasarus totonan pate lialun. Tuahe aope totonan ape pate solian ma amuam tetan lalap wanen a o toto leili moloan lalap. ");
INSERT INTO ssg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tuai tesol waliko ien, wasolakako pate xauxaun wanen. Haeu tiehiwen wasolakako lehe amite kum kolia kewa ma tin amuto kum kolia kema.’ ");
INSERT INTO ssg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Tel seilon kilan soxi ukek, ‘Na masin ien, taloa Lasarus haniwa ingi tel tamak. ");
INSERT INTO ssg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tepanim ukalak ien. Pahak i hahongoa lato ka pate lialun wanen tesol ti nga toto ape lato towiahua ti lialui woulato lehe lato kum lua hanima kapik taen lato mat.’ ");
INSERT INTO ssg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham pahoi ukek, ‘Moses ma teka kuluiai kakai Haeu hanauen lato nauna ti Haeu. Tesol ukalam ala lato hong usiwa tesol nauna ien.’ ");
INSERT INTO ssg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Tel seilon kilan soxi ukek, ‘Ien i kum pon nake lato kum soh. Tuahe na tel seilon masin Lasarus i moih alia ape kaxi hani lato nauna ti Haeu, lato towiahu ti lialui woulato.’ ");
INSERT INTO ssg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ape Abraham ukek, ‘Na lato kum hong soh kakai Moses ma teka kuluiai kakai Haeu, tin lato kum hong soh kalak na tel i moih alia ape i kakane lato.’” ");
INSERT INTO ssg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jises hone tesol kahikahin, “Kilan waliko ti tohongi haputai seilon ailei saun lialun tuahe Haeu axi hawane kawatan hani tel seilon i aile haputa seilon liai ailei saun lialun. ");
INSERT INTO ssg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pamu ewian laha xinoti tehu mes lalap he kinawen ape hataxixi hani ilam. Ien pamu ewian ti na imuh i tunahi kawatan ti ailei tenen saun ien. ");
INSERT INTO ssg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Amuto kanipetiwa. Kum ailele tenen saun ien. “Na tel kahikahik aile saun lialun hani amuto, nexi haxewa haniwa i ka saun tenen i aile i halialu wasolamuto. Ape honewa i kum aile ulelei. Na i towiahu ti lialui woun, amuto oxoxiwa i ti kawatan ti saun i aile haniwen amuto. ");
INSERT INTO ssg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“Kalak i aile hani amuto kilan saun lialun leili ngain tehu ape lawe i nahima i ukek ka i tahane hawane, amuto oxoxiwa i ti kawatan ti lialui woun.” ");
INSERT INTO ssg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Telao tesol aposel kamei tel Masiwi Jises, “Haxoxo ahekema namilomite hani Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jises pahoi lato ukek, “Kalak lape namilomuto hani Haeu masin waki lilieu, i pon amuto hone tea pata ie, ‘Sohutawa tesol ie ape tu haniwa itax.’ Ape salan i hong usi kakaiamuto.” ");
INSERT INTO ssg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jises kak tatale ukek, “Na masin tel masiwi tel unauan i aliama ti i pupuas he kin, i kum tua to ang. ");
INSERT INTO ssg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Lawe i apesenimu ani tel masiwi tetan, muhin ape i ang. ");
INSERT INTO ssg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tel masiwi kum kak kemulik hani tel unauan nake se liai pupuasan. ");
INSERT INTO ssg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tin masin amuto. Na amuto aile usi waliko ti Haeu pahan, amuto namiloi kewak, ‘Amite tuahe unaui Haeu. Amite kum namiloi ukek Haeu sameni amite pake waliko ti amite aile liai pupuasamite.’” ");
INSERT INTO ssg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jises ma tesol kahikahin nahih hahaniwa Jerusalem nonoa wasole huoxux xux Galili ma Samaria. ");
INSERT INTO ssg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ti lato soh haniwa tewau toan, huopanim seilon tinulato hina nax tenen pate lialun, lato tu siasia xauxaun. ");
INSERT INTO ssg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Lato tilol ausisini, “Jises tel masiwi tahanema amite!” ");
INSERT INTO ssg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ti Jises ningahiwa lato i ukek, “Nahih kolawa tinumuto haniwa teka masiwi ti hukuminiai Haeu ma seilon lehe lato paxai kalisi tinumuto ka amuto ewiwen ma tin ape haun.” Ape ti lato nanahiwa, Jises aile haewia tinulato. ");
INSERT INTO ssg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ti lato paxaiwa ka tinulato ewiwen, telawe i alia hani kapi Jises ape i tilol ukek, “Nga sameni Haeu. Nga amuam hawane nake nga ewiwen.” ");
INSERT INTO ssg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","I put lokuha hani kapi ae Jises ape i kak kemulik hani i. Tel seilon ien i ti texux xux Samaria. ");
INSERT INTO ssg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jises kakane teka seilon kapin, “Huopanim seilon nga haewia. Tuahe telawe aliama. ");
INSERT INTO ssg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mewenae tel seilon ie aliama kak kemulik hani Haeu a i kumahe Ju.” ");
INSERT INTO ssg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ape Jises hone tel seilon ien, “Tua ape nahih tamusua. Xoxoi namilom hani Haeu i aile haewiawen o.” ");
INSERT INTO ssg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Telao teka Parisi kamei Jises ukek, “Lokon wanen taun ti ape Haeu neini seilon?” Jises pahoi ukek, “Nenein ti Haeu kumahe waliko tenen lehe amuto ningahi. ");
INSERT INTO ssg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tap tel i kola uke, ‘Paxaiwa, Haeu neini teka seilon ie.’ Ape tap tel i kola uke, ‘Paxaiwa, Haeu neini teka seilon io.’ Nake ti Haeu neini seilon, i neini namilolaha ma pupuasalaha.” ");
INSERT INTO ssg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jises kakane tesol kahikahin, “Taun i luluainima tutuen ti pahamuto wanen nga tel Nati Seilon kapimuto tuahe tataen ien i kum pon na nga kapimuto. ");
INSERT INTO ssg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na teka seilon hone amuto, ‘Paxaiwa, tel Nati Seilon tahiawen,’ amuto kum soh usiusi laha. ");
INSERT INTO ssg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Amuto tioi hawane aliaiak nake nga tel Nati Seilon sohotuak hanowi usil i xep haxewa maun tepaun hani tepaun. ");
INSERT INTO ssg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tuahe imat ti ien, nga tel Nati Seilon nga kaumu moloan pate lalap ape teka seilon ti aope ie laha pahoxai nga ma watakai waliko ti nga hahanau seilon. ");
INSERT INTO ssg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Taun ti aliaiak tel Nati Seilon, saun ti teka seilon masin wanen lokon ti Noa tel seilon sawisawin. ");
INSERT INTO ssg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Lokon ien, imat ti Haeu hasomu mat atuhi lawe xux, teka seilon laha ang, un ma sal amuam atengi tataen ti Noa soh hani leili tea waian. Laha amuam luh ape laha kum tioi waliko ti lehe i sohot. Ape ti mat somule, i soheni hatapo laha. Tin masin wanen aliaiak tel Nati Seilon, i haonga seilon. ");
INSERT INTO ssg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Tin masin lokon ti Lot tel seilon sawisawin. Teka seilon lialun ti tehu taon Sodom tin laha ang ma un amuam, laha kakahui ma hahangaini waliko, seseini an ma atatai ing tuahe laha kum nam waxi Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Telao ti Lot nahih ahuta ti Sodom, Haeu haputa ah lalap ma pot pate kekean lui telei hatapo teka seilon ti Sodom. ");
INSERT INTO ssg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Tin masin wanen aliaiak tel Nati Seilon, i haonga seilon. ");
INSERT INTO ssg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Taun tehu ien kawatan lalap wanen tunahi seilon. Tel na i melal, i kiliwawa. I kum alia hahani leili ing waxiai soxian. Tin masin na tel i he kin, tin i kiliwawa. I kum alia hahani leili ingan waxiai soxian. ");
INSERT INTO ssg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Amuto nameniwa waliko ti sohot hani tel axoi Lot. Ti lalu ahuta ti Sodom, tel axoi Lot tohea alia waxiai soxian ape i mat. ");
INSERT INTO ssg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nga kakane hawane amuto, na tel seilon pahan kum is kahikahik nake pahan i akeni kongini totonan ti itan ie, i lioi totonan ti kapi Haeu. Tuahe na tel seilon i to kahikahik kalak na masin i lioi totonan ti itan ie, i waxi tonain kapi Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Tataen ti nga aliama, ti na hua seilon matih hehetekie, nga waxi tel ape tel tiliwen. ");
INSERT INTO ssg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Hua hehin lalu nuhi hehetekie api, nga waxi tel ape tel tiliwen. ");
INSERT INTO ssg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hua wawan lalu puas hehetekie he kin, nga waxi tel ape tel tiliwen.” ");
INSERT INTO ssg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ti tesol kahikahin hongoa lato kamea, “Amite tioi ukek ia tetesol na i sohot?” Jises pahoi lato ukek, “Amuto tioi xixi tetesol na amuto ningahi taliah. Tin masin amuto tioi tetesol ti aliaiak, taen ti amuto ningahi waliko ti nga kakanewen amuto.” ");
INSERT INTO ssg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Telao Jises kaxi tenen meng hani tesol kahikahin ti hanaualato ka lawe lato kamei talingoiwa Haeu ma kum kakapaxe i. ");
INSERT INTO ssg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","I ukek, “Leili tehu taon tel seilon puasan hong paxaiai kakain. I kum nam waxi Haeu ma seilon. ");
INSERT INTO ssg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tel hehin axoan matewen tin i toto taon tehu ien. Lawe i to nahih tuhituhi kameiai huhual ti tel seilon ien. I ukek, ‘O sauma tetak nake tel seilon liai i aile halialu nga.’ ");
INSERT INTO ssg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Kemuk tel hong paxaiai kakain i kum hong waxi i. Tuahe imuh i namiloi ukek, ");
INSERT INTO ssg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","‘Kalak nga kum nam waxi Haeu ma seilon, nga huali tel hehin ie nake lawe i hakatole nga. I hapuso nawak na nga kum huali i.’” ");
INSERT INTO ssg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ape tel Masiwi Jises ukek, “Namiloi paxaiwa waliko ti tel hong paxaiai kakain noseni i aile kalak i seilon lialun. ");
INSERT INTO ssg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aile ape Haeu tel pate solian, pamu i sa huali teka seilon i kilamiwen tetan na laha kamea talingoi. Kumahe i papalata hualialaha. ");
INSERT INTO ssg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pate i sa kosea hualialaha. Tuahe kaie nga tunahi kilan seilon namilolaha xoxoan tetak ti na nga tel Nati Seilon aliama?” ");
INSERT INTO ssg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Leili teka seilon laha hongohong Jises, teka ti laha namiloi ukek ka laha seilon sawisawin nake ti saun ti laha ailele. Laha namiloi ukek ka laha pamu ewian ti teka liai ape laha teheni seilon liai. Aile ape Jises kaxi hani laha tenen meng ie. ");
INSERT INTO ssg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","I ukek, “Hua seilon lalu nahih lotu hani Ingi Haeu, tel Parisi ma tel puasan waxiai moni ti teka Ju hani teka masiwi ti Rom. ");
INSERT INTO ssg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tel Parisi tu ape i lotu ukek, ‘Haeu, nga kak kemulik hani o, nga kumahe masin teka seilon woulaha lialun kasini tel seilon tutu io. Nga malang pipis, nga kum ailele saun lialun ti wawan hehin ma lawe nga ailele saun solian. ");
INSERT INTO ssg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Lawe nga halini an hualiai lotu tetak ti ngain huohu leili puasain tehu. Lawe nga axi o tenen ti lawe huopanim soxi nga hina.’ ");
INSERT INTO ssg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Tel waxiai moni i tu siasia nake i namiloi ukek i seilon tenen woun pate lialun. Aile ape i kum xeisa hani patul ti i lolotu. I tui patanawan nake pate i tahane lialui woun ti i ailewen. Ape i lotu ukek, ‘Haeu tahanema nga nake nga seilon tenen ailei saun lialun.’” ");
INSERT INTO ssg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ape Jises tili kakaian ukek, “Nga kakane hawane amuto, muhi lotu ti lalu, tel seilon waxiai moni Haeu namiloi ukek i seilon sawisawin, kumahe tel Parisi. Na tel sameni aliake i, Haeu teheni tel seilon ien. Tuahe na tel teheni aliake i, Haeu namiloi ukek i seilon pate tuah.” ");
INSERT INTO ssg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lokon ien teka seilon hakahita teka akaik kokol hani kapi Jises. Pahalaha i hanawa minan he teka akaik lehe i lotu huali lato. Tuahe tesol kahikahin kahiloloi teka seilon. ");
INSERT INTO ssg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jises tiloi teka akaik hanima kapin ape i ukek, “Tiliwen teka akaik nahih hani kapik, kum hahakongu lato. Na seilon sohot hanowi teka akaik ie, Haeu neini aweisalulaha ape laha natun wanen. ");
INSERT INTO ssg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nga kakane hawane amuto, Haeu neini mewenae teteka laha hana xoxoi namilolaha hani i masin teka akaik laha hana xoxoi namilolaha hani tamalaha ma tinalaha.” ");
INSERT INTO ssg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Telao tel ti teka masiwi ti teka Ju kamei Jises, “Tel masiwi solian, nga aile waliko la lehe nga uke tonain kapi Haeu ti tap tahi tapoan?” ");
INSERT INTO ssg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jises kamei aliake i, “Nake lahan o ukek nga solian? Na masin o ukek nga solian, namiloi paxaiwa nake mewenae Haeu solian. ");
INSERT INTO ssg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","O tioi nauna tetan: ‘Kum tetelei seilon, kum ailele saun lialun ti wawan hehin, kum xuuxuina, kum kau puputini kakain, hongoa kakai tamam ma tinam ma aile hasolia haniwa lalu.’” ");
INSERT INTO ssg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","I hone Jises, “Nga usi hahatapo tesol nauna ien lilian ti nga kokol.” ");
INSERT INTO ssg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ti Jises hongoa kakaian i ukek, “Tenen waliko tutuen o tai aile. Nahih hangaini hatapoa soxiam ape moni haniwa teka seilon tap soxi lehe imuh o uke kahum ti tone Haeu. Ape nahih kahitima nga lehe o sohot kahikahik.” ");
INSERT INTO ssg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ti tel seilon hongoa, tatahan lalap tunahi i nake i kilan soxi ape i tahane na i hangaini. ");
INSERT INTO ssg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jises paxai i ape i ukek, “Seilon tenen kilan soxi, pate ailan wanen ti usiai aweisal ti Haeu neneini. ");
INSERT INTO ssg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nga kakane hawane amuto, ailan wanen ti tok kamel na i soh non he tewau aweing laha axai nil ti sawitiai maia tuahe pamu ailaian ti seilon tenen kilan soxi ti usiai aweisal ti Haeu neneini.” ");
INSERT INTO ssg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Teka seilon apupuha hongoa, laha kamei i, “Lehe ape aita pon usiai aweisal ti Haeu neneini?” ");
INSERT INTO ssg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jises pahoi ukek, “Ti mewenae kui seilon i kum pon. Tuahe hetekie huhual ti Haeu, seilon pon.” ");
INSERT INTO ssg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ape Pita ukek, “Paxaiwa, amite tesol kahikahim salili hatapoen waliko ti amite ape amite kakahiti o. Kaie amite uke waliko la?” ");
INSERT INTO ssg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jises pahoi ukek, “Nga kakane hawane amuto, Haeu kahui hasolia tel na i namiloi ukek nenein ti Haeu pamu tuah ti tonan, axoan, ukalan, taman tinan ma natun. ");
INSERT INTO ssg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Haeu axi aheke i lawe waliko ti he tehu pon ie ape tin i uke tonain kapi Haeu ti tap tahi tapoan.” ");
INSERT INTO ssg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jises hakahita huopanim hua aposel hani tesol mewenae lato ape i ukek, “Kako nahih hahaniwa Jerusalem. Lawe waliko ti teka kuluiai kakai Haeu taiwen ti i kakak nga tel Nati Seilon, i sohot poponowi hani nga ien. ");
INSERT INTO ssg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Laha hana nga hani he mini teka seilon laha kumahe Ju. Laha soxeni nga ape aile halialu nga ma pukeini nga. ");
INSERT INTO ssg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Laha heti nga ape laha telei. Tuahe muhi ngain toluhu nga moih alia.” ");
INSERT INTO ssg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tesol aposel kum xeu waliko ti Jises kakak. Salangawe teik kakaian, lato kum tioi. ");
INSERT INTO ssg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ti Jises ma tesol kahikahin nahih xohi hahaniwa Jeriko, tel seilon pulan pulaxa toto ngixi aweisal kamekam huhual. ");
INSERT INTO ssg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","I hong ka kilan seilon nahih sahima i tatamusua he aweisal. I kamea, “Waliko la i sosohot?” ");
INSERT INTO ssg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hina seilon hone i ka Jises ti Nasaret nahih tatamusua. ");
INSERT INTO ssg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ape i tilol eliel ukek, “Jises tel kahi nati David, tahanema nga!” ");
INSERT INTO ssg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Teka seilon nanahiwa mateiwai Jises laha tumei hapangisu i tuahe i tilol eliel ahe, “Tel kahi nati David, tahanema nga!” ");
INSERT INTO ssg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jises tu hamalum ape i hone teka seilon ukek, “Ati hanima nga tel seilon ien.” Ti i nahih xohiwa, Jises kamei i, ");
INSERT INTO ssg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Paham nga aile waliko la hani o?” Tel pulaxa ukek, “Tel Masiwi, pahak nga paxapax.” ");
INSERT INTO ssg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jises hone i, “Aope ie ape o paxapax. Xoxoi namilom hani Haeu i haewia o.” ");
INSERT INTO ssg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tataen ien wanen pulan ewi ape i kahiti Jises. I kak kemulik ma sameni Haeu. Ti teka seilon ningahiwa, tin laha sameni Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jises ma tesol kahikahin soh haniwa Jeriko ape lato nahih tatamusua leili taon. ");
INSERT INTO ssg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ti ien tel seilon axan Sakias. I tel masiwi ti teka waxiai moni ti teka Ju hani teka masiwi ti Rom. Sakias kilan moniun. ");
INSERT INTO ssg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pahan wanen i paxai Jises tuahe i seilon kukunun. I kum ningahi uke Jises nake pate kilan seilon lilikihini i. ");
INSERT INTO ssg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aile ape i kiliwau pelea han hani he tea pata lalap lehe i pon ningahiai Jises na i nahima. ");
INSERT INTO ssg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ti Jises mei haniwa onote tea pata, i pax haniwa patul ape i ukek, “Sakias, mos kosealih nake ngain tehu ie nga to kapim leili ingam.” ");
INSERT INTO ssg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakias mos saxohuxoh hanilih itan, leili tian i amuam hawane ape i hakahita amuke Jises hani leili ingan. ");
INSERT INTO ssg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ti teka seilon ningahiwa, laha kak mumum hui Jises ukek, “I to akakati tel seilon woun lialun.” ");
INSERT INTO ssg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ti lato leili ing, Sakias tule ape i hone Jises ukek, “Tel Masiwi, tepaun ti lawe soxiak nga hani teka tap soxi. Na nga pisi waxiwen moniai tel na seilon, nga aliake hani i taen hinalo akulai lapan ti nga pisiwen i.” ");
INSERT INTO ssg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jises kakane i ukek, “Aope ie Haeu oxoxi o ma teka leili ingam ti kawatan ti lialui woumuto nake o hina namil xoxoan hani Haeu masin Abraham, tel tamakako ti matahaun. ");
INSERT INTO ssg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pake salangawe luaiak tel Nati Seilon hanima tehu pon itan ie upiai teka seilon woulaha lialun masin Sakias ma awaialaha ti kawatan ti saun lialun ti laha.” ");
INSERT INTO ssg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ti Jises ma tesol kahikahin xohi hahaniwa Jerusalem, kilan seilon laha hongohong kakaian. Kilan ti laha sokok ka taun ti Haeu neini lawe seilon ape i sohot huluta ien. Aile ape Jises kaxi hani laha tenen meng ie. ");
INSERT INTO ssg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","I ukek, “Tel seilon tuah lua hani texux xux xauxaun lehe tel masiwi tapein ti ien hana i tel masiwi ti xuxun. ");
INSERT INTO ssg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Imat ti i ku i tiloi apuhini huopanim unauan ape i hani lato tel tel tehu tomi moni. I ukek, ‘Amuto hapuasa haxexewa teik moni ie lehe nga uke palahi taen nga aliama.’ ");
INSERT INTO ssg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Tuahe teka seilon ti xuxun laha watakai hawane i ape laha talo tesol seilon hani tel masiwi tapein hetekie teik kakain ukek, ‘Amite watakai tel seilon ien to masiwi ti amite.’ ");
INSERT INTO ssg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Tuahe tel masiwi tapein hana i masiwi ti laha. Ti i alia haniwa xuxun, i tiloi apuhini huopanim unauan lehe i upia paxai lape moni ti lato hasohotuen. ");
INSERT INTO ssg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Tel imat nahima i ukek, ‘Tel masiwi, nga hasohotu palahiwen huopanim tomi monium.’ ");
INSERT INTO ssg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Tel masiwi ukek, ‘Puasam solian. O unauak solian, o auni aluini moniuk. O ngahati aluini waliko kokol, aile ape nga hana o masiwi ti huopanim taon.’ ");
INSERT INTO ssg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Tel muhin nahima i ukek, ‘Tel masiwi, nga hasohotu palahiwen tepanim tomi monium.’ ");
INSERT INTO ssg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Tel masiwi ukek, ‘Puasam solian. Nga hana o masiwi ti tepanim taon.’ ");
INSERT INTO ssg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Tel liai nahima i ukek, ‘Tel masiwi, teik monium kemuk o hanimu nga ie. Nga puxui mumuneni he teik maia. ");
INSERT INTO ssg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nga mamata o nake o seilon ahian. O waxi an ti kumahe o seini. Paham o waxi moni ti seilon liai hasohotu.’ ");
INSERT INTO ssg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Tuahe tel masiwi kakane i ukek, ‘O pate unauak lialun ma nunuxa. O sokok nga seilon ahian, nga waxi an ti kumahe nga seini ape pahak nga waxi moni ti seilon liai hasohotu. Puki kakaiam sului o. ");
INSERT INTO ssg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na o namiloi ukek ka nga seilon ahian, kaie ala o hapuasa haxexewen moniuk lehe nga uke palahi.’ ");
INSERT INTO ssg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ape i hone teka unauan liai ukek, ‘Waxiwa teik moni toi i ape haniwa tetel i hasohotuen huopanim tomi moni.’ ");
INSERT INTO ssg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Tuahe lato kakane i ukek, ‘Tel masiwi, i liai huopanim tomi moni toi i!’ ");
INSERT INTO ssg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Tel masiwi pahoi lato ukek, ‘Salan. Tel na i aile aluini puasak, nga axi palahi waliko ti i auni. Tuahe tel na i kum puas alua, nga waxi aliake teik kokolean toi i. ");
INSERT INTO ssg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ien ape taun ti nga axi kawatan hani teka laha watakai nga to masiwi ti laha. Atima laha ape teleiwa ti he pulak.’” ");
INSERT INTO ssg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jises kak kewa ape i nanahiwa mateiwai tesol kahikahin hani Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ti lato xohi haniwa huowau toan Betfage ma Betani, pape tehu Maunt Oliv, Jises talo hua kahikahin imat tetan. ");
INSERT INTO ssg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ape i hone lalu, “Nahih haniwa tewau toan mateiwaukako. Amulu ningahi tok donki uluha xinotan ien, laha tai kikiliwake. Upatiwa ape hakahitama. ");
INSERT INTO ssg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na tel seilon kamei amulu kalahai amulu upati, honewa i ka tel Masiwi pahan i hapuasa.” ");
INSERT INTO ssg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Lalu nahiwa ape lalu tunahi waliko masin ti Jises kakanewen lalu. ");
INSERT INTO ssg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ti lalu upapati tok donki, teka taman kamei lalu, “Kalahai amulu upati?” ");
INSERT INTO ssg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ape lalu ukek, “Tel Masiwi pahan i hapuasa.” ");
INSERT INTO ssg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ape lalu hakahita tok donki hani Jises. Lalu axaheni puxuaulalu he tehiti tok donki ape lalu huali Jises ku to hani patul. ");
INSERT INTO ssg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Teka seilon axaheni puxuaulaha he aweisal ape Jises kikiliwawa patul tetan. ");
INSERT INTO ssg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ti i xohi haniwa Jerusalem he tetewau aweisal i mos haniwa Maunt Oliv, kilan wanen teka kahikahin laha tilol amuam ma sasameni Haeu ti lawe waliko lalap laha ningahi Jises ailewen. ");
INSERT INTO ssg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Laha tilol ukek, “Kako sameniwa ma amukewa tel kahi nati David, tel i nahih hehetekiema poh ma solian ti Haeu! Kako sameniwa Haeu tel pohen tapein, tel i hatona hasolia tiakako.” ");
INSERT INTO ssg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Teka Parisi leilolaha kakane Jises ukek, “Tel masiwi, tumei hapangisua teka kahikahim!” ");
INSERT INTO ssg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jises ukek, “Nga kakane hawane amuto, na lato monga, tesol pot ie tilol amuam sameniak.” ");
INSERT INTO ssg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ti Jises xohi haniwa Jerusalem i paxaiwa tehu taon ape i tang tahane. ");
INSERT INTO ssg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","I ukek, “Nga hahaxe amuto seilon ti Jerusalem hasawiai wasolamuto kapi Haeu taen tetelao. Haeu kola haniwen amuto aweisal ti na amuto usi tuahe amuto watakai. ");
INSERT INTO ssg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ngain ti luluainima imuh, teka seilon ti hile ti xux liai laha atai hanein kakalini Jerusalem lehe laha han kolia hani leili taon ape hilei amuto. ");
INSERT INTO ssg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Laha aile halialu hawane hatehu taon ape telei hetekie teka seilon. Laha hamanana ukek ien nake amuto kum nam waxi Krais, tel Haeu taloma awaiamuto ti kawatan ti lialui woumuto.” ");
INSERT INTO ssg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ti Jises soh haniwa Jerusalem i nahih hani Ingi Haeu. Kilan seilon hahangaini soxi ma manihuh ien. Hangainiai waliko ti laha pate lialun. Ti Jises ningahiwa, i usi xaxaweni laha. ");
INSERT INTO ssg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ape i kakane nau laha i ukek, “Kakai Haeu ukek, ‘Tehu ingak ing ti lotu.’” Ape Jises kakane laha, “Tuahe amuto aile hanowi ka ing ti tone munai teka xuxuina!” ");
INSERT INTO ssg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Muhin Jises hanau teka seilon leili Ingi Haeu lawe ngain. Tuahe teka masiwi tuah ti hukuminiai Haeu ma seilon, teka hanaui nauna ti Moses ma teka masiwi liai, lato upiup aweisal ti teleian. ");
INSERT INTO ssg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tuahe laha kum pon nake kilan seilon kapi Jises laha hong mamataini kakaian. ");
INSERT INTO ssg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ngain tehu ti Jises kakaxi meng solian ti Haeu hani teka seilon leili Ingi Haeu, teka masiwi tuah ti hukuminiai Haeu ma seilon, teka hanaui nauna ti Moses ma teka masiwi liai ti teka Ju, lato hatesol nahih hani kapin. ");
INSERT INTO ssg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Lato ukek, “Kakanema amite, aita hone o ailei waliko ti o ailele? Aita sowini hani o?” ");
INSERT INTO ssg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jises kak pahoi lato ukek, “Nga kameimu amuto tenen kamekame. Na amuto pahoi, nga kaxi hani amuto tetel i sowini hani nga. ");
INSERT INTO ssg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kaxi hanima nga, aita sowini hani Jon baptaisiai seilon, Haeu ka seilon?” ");
INSERT INTO ssg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ape lato kakak alia wasolalato, “Kaie kako kak ukek ia? Na kako ukek Haeu sowini hani Jon, i kamei kako, ‘Na masin ien, alahan amuto kum soh Jon?’ ");
INSERT INTO ssg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tuahe na kako ukek seilon sowini hani i, teka seilon hokai telei kako pot nake laha ukek Jon se tel kuluiai kakai Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aile ape lato ukek, “Amite kum tioi aita sowini hani Jon.” ");
INSERT INTO ssg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jises kakane lato ukek, “Nga tin nga kum kaxi hani amuto aita hone nga ailei waliko ti nga ailele.” ");
INSERT INTO ssg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Muhin ien Jises kaxi tenen meng i ukek, “Tel seilon seini tesol lalape kini huai pata ape i hani teka seilon ngahati lehe tin i uke aliake hina. Ape i ku to kue hani texux xux liai. ");
INSERT INTO ssg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ti huai pata pamua, i talo tel unauan hani he kin waxiai ti tetan. Tuahe teka ngahatiai tesol kin xai halialu tel unauan ape tua talo aliake. ");
INSERT INTO ssg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tel tame tesol kin talo ulea tel, tuahe tin lato xai halialu ape tua talo aliake. ");
INSERT INTO ssg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ape i talo ulea liai tel. Lato xai hamange ape towi xoini i hani melal ti he kin. ");
INSERT INTO ssg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Muhin tel tame tesol kin namiloi ukek, ‘Kaie nga aile la? Nga tioiwen. Nga talo tel natuk pate nga waheni. Sohin uke lato aile aluini i.’ ");
INSERT INTO ssg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Tuahe ti teka ngahatiai kin ningahiwa tel natun, lato kakak alia puki lato, ‘Tel natun wanen nanahima. Kako telei i lehe tesol kin ape ti kako.’ ");
INSERT INTO ssg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Lato pohi towi xoini i hani melal ti tesol kin ape lato telei.” Ape Jises kamei teka laha hongohong tenen mengon, “Amuto namiloi ukek ia? Ti tel tame tesol kin aliawa, i aile waliko la hani teka ngahatiai kin? ");
INSERT INTO ssg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nga kakane hawane amuto, i telei hatapo teka ngahatiai tesol kin ape i hani teka seilon liai ngahati.” Ti laha hong kewak ien, laha ukek, “Kumahe, tap wanen i sohot ukek ien.” ");
INSERT INTO ssg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jises paxaiwa laha ape i ukek, “Na masin ien, salangawan la teik kakai Haeu ti i ukek, “‘Tehu kuku teka ataiai ing hilisa, Haeu aile ape i sohot kuku tehu pamu tuah ti kuku liai.’” ");
INSERT INTO ssg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ape Jises tili kakaian ukek, “Teka seilon laha hong watakai kakaiak, laha tunahi kawatan ma moloan lalap.” ");
INSERT INTO ssg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Teka hanaui nauna ti Moses ma teka masiwi tuah ti hukuminiai Haeu ma seilon, ti lato hongoa tenen meng Jises kakaxi, lato tioi i kak nanami lato. Pahalato xoti hulutiniai Jises tuahe lato mamata uke teka seilon hutui hile nake laha sameni i. ");
INSERT INTO ssg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Teka hanaui nauna ti Moses ma teka masiwi ti hukuminiai Haeu ma seilon, lato pepeteni tutuen Jises. Lato talo hina seilon ti kamei tohongiai Jises lehe waxi i kak waliko tenen na i sului aliake i ape lato hana hani he mini Pailat tel ti teka masiwi ti Rom kiliwakei Judia. ");
INSERT INTO ssg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tesol seilon ien nahih hani kapi Jises ape lato ukek, “Tel masiwi, amite tioi o seilon sawisawin. Ti o hanau seilon saun ti Haeu, kakain tenen salan. Woum o aile hani teka masiwi ma teka seilon naun lawe tekewe. ");
INSERT INTO ssg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kaxi hanima amite, ewi na kako teka Ju hani Sisa teik moni pahan, a kumahe?” ");
INSERT INTO ssg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jises tioi ka lato kamei pipisi i ape i hone lato, ");
INSERT INTO ssg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kola hanima nga tehu ti tesol puli moni lawe amuto hahani Sisa.” Lato hani i tehu. Ape i kamei lato, “Kawe aita ma axe aita he tehu puli moni?” Lato ukek, “Ti Sisa.” ");
INSERT INTO ssg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ape Jises hone lato, “Ien, waliko ti Sisa haniwa Sisa, waliko ti Haeu haniwa Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Aile ape lato kum tunah sale suluan. Lato ong sameni pahoan tetan ape lato mangong. ");
INSERT INTO ssg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Muhin ien teka Sadusi nahih hani kapi Jises. Lato soh ka seilon maten kum moih alia. ");
INSERT INTO ssg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Lato ukek, “Tel masiwi, Moses tai hanawen na masin tel wawan i mat a i tap natun, tel ukalan kewa axoan tel hehin ien lehe lalu tan natulalu ape tesol akaik ien nati tel i matewen. ");
INSERT INTO ssg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hongoa mengomite. Telao hatotalin lato tepanim hua. Tel pamu i sal ape i mat, tap natun. ");
INSERT INTO ssg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tel ukalan usian waxi axoan tel hehin. Tel usiai tel pamu tin i mat, tap natulalu. ");
INSERT INTO ssg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ape tel usialalu uke ulei axoan tel hehin, tin tap natulalu. Waliko tin tetenen sohot hani tesol talin liai. ");
INSERT INTO ssg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tapeinan ape tel hehin mat. ");
INSERT INTO ssg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Taen Haeu xahateni hatapo seilon maten, tel hehin ape axoi aita? Nake ati lato ukewen tel hehin ien.” ");
INSERT INTO ssg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jises pahoi lato ukek, “Seilon sal mewenae ti laha he tehu pon ie. ");
INSERT INTO ssg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tuahe taen Haeu hamoiha aliake seilon tetan, ape seilon kum sal. ");
INSERT INTO ssg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ape laha kum mat ulea masin teka engel, spirit solian ti Haeu. Laha nati Haeu i xahateni aliake lehe laha to kapin lian tehue. ");
INSERT INTO ssg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nga kaxi haxewa hani amuto sale xahatai seilon maten. Puki Moses kolawen ka teka maten laha moih alia. Amuto tioi meng ti i taiwen. I kaxi lokon ti Haeu kakane i ti leili teik sisihan ti ah xekexek. Haeu ukek ka i tetel ti Abraham, Aisak ma Jekop lolotui. I ukek ien muhi matealato. ");
INSERT INTO ssg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Aile ape i Haeu ti teka moihin kumahe teka maten nake i nam paxai ukek seilon tetan laha lawe moihin tutuen.” ");
INSERT INTO ssg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Teka hanaui nauna ti Moses hongoa ape lato ukek, “Tel masiwi, kakaiam sawisawin wanen.” ");
INSERT INTO ssg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Muhin ien tap tel kamei pisi ulei Jises. ");
INSERT INTO ssg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Muhin ien Jises kamei teka seilon laha hongohong kakaian, i ukek, “Nake lahan teka seilon ukek ka Krais i kahi nati David? ");
INSERT INTO ssg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Puki David i kakaxi leili kakai Haeu ti he pepai Salm, “‘Haeu kakane tel Masiwi tetak, “Toma papak tepaun manau ti neiniai seilon atengi tataen nga hanawa teka seilon laha pahoxai o hani hahitakam.” ’ ");
INSERT INTO ssg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David axai Krais tel Masiwi tetan. Na masin ien, i kumahe tuahe tel ti kahi natun.” ");
INSERT INTO ssg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ape Jises tohea kakane tesol kahikahin ti lawe seilon hongohong. ");
INSERT INTO ssg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","I ukek, “Amuto lepetawa. Kum usiusi saun ti teka hanaui nauna ti Moses. Lato hana puxux weluwelun ape tau nanahih ti puli lawe seilon lehe laha paxai tioi ka lato seilon tuah ape sameni lato. Lato waheni totoan tuah ti tone angiain lalap ma leili synagog. ");
INSERT INTO ssg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tuahe lato pisi teka hehin axoalaha matewen lehe lato seseke soxialaha ma ingalaha. Ape lato aile lotu weluwelun lehe teka seilon namiloi kewak lato sawisawin. Hui tesol waliko ien, Haeu axi lato kawatan lalap wanen.” ");
INSERT INTO ssg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Imuh Jises toto onote tehu lohe moni ti Ingi Haeu. I ningahi teka seilon kilan moni lolohi moniulaha. ");
INSERT INTO ssg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ape tel hehin axoan matewen i tap moni, nahima ape i hana huohu puli moni pate kokol. ");
INSERT INTO ssg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ape Jises kakane tesol kahikahin ukek, “Nga kakane hawane amuto, tel hehin ie i hana moni pamu lapan ti teka liai. ");
INSERT INTO ssg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Teka seilon liai, moniulaha pate kilan tutuen tuahe tel hehin ie moniun pate kokol wanen, i hana hatapoen ti i hina.” ");
INSERT INTO ssg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Teka ti tesol kahikahin lato sasameni soliai Ingi Haeu, tesol pot laha uke ataian ma soliai waliko ti teka seilon aile hasoliai paxaian. ");
INSERT INTO ssg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ape Jises ukek, “Nga kakane hawane amuto, imuh tesol ing ie laha toi hamanana ape pot ti tesol ing i put silahota.” ");
INSERT INTO ssg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Lato kamei i, “Tel masiwi, lokon wanen ape waliko ien sohot? Kaie kikilam la i sohot imat ti tesol waliko ien?” ");
INSERT INTO ssg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jises hone lato ukek, “Lepetawa uke teka seilon puluti amuto. Imuh kilan seilon putini ka laha luama hahitake axak ape laha ukek laha Krais. Laha ukek ka taun ti Haeu neini hatesol seilon i tahiawen. Amuto kum soh usiusi laha. ");
INSERT INTO ssg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na amuto hong hilehile sosohot tesol tesol, kum maamata. Waliko masin hoi liai i sohot tuahe kumahe ka ape tapoi tehu pon ie. ");
INSERT INTO ssg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Hilehile i sohot wasole xux, toan i hilei toan liai. ");
INSERT INTO ssg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tataen ien hepekeun i nuea eliel, hitolo lalap ma nax tenen tenen i sohot tesol tesol. Teka seilon paxai waliko tenen tenen i hamatau seilon ma waliko lalap ti laha tai niningahi i sohot patul he maun. ");
INSERT INTO ssg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Tuahe imat ti lawe waliko ien i sohot, laha xoti ma aile halialu amuto. Laha hatuhi amuto ti sulusulu leili synagog ma hana amuto he kalabus. Laha sului amuto he puli teka masiwi tenen tenen nake amuto kahikahik. ");
INSERT INTO ssg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ien se aweisal ti amuto kaxi meng solian tetak hani laha. ");
INSERT INTO ssg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Amuto kum namiloi pepeleini sale xengeiamuto. ");
INSERT INTO ssg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Puki nga hanamiloa amuto kakain sawisawin ti na amuto kak ape tap tel ti teka laha sului amuto pon kak ukek kakaiamuto kumahe salan. ");
INSERT INTO ssg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Teka ti amuto puki tamamuto, tinamuto, ukalamuto, akikimuto ma lawamuto hangaini amuto. Ape teka ti amuto laha telei. ");
INSERT INTO ssg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tesol tesol kilan seilon laha watakai amuto nake amuto kahikahik. ");
INSERT INTO ssg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kalak laha axi amuto kawatan tenen tenen, laha kum selai uke amuto ti hahitake ngangahat ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Amuto tu xoxoa tetak lehe amuto uke tonain kapi Haeu ti tap tahi tapoan.” ");
INSERT INTO ssg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ape Jises kak ulea ukek, “Na amuto ningahi teka seilon ti hile tu kaliniwa Jerusalem, amuto tioiwa ka ape laha aile halialu tehu taon. ");
INSERT INTO ssg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Taen ien, amuto teka Judia kiliwau haniwa he maunten. Teka leili Jerusalem laha oxawa ape teka laha toto melal ti Jerusalem laha kum soh hahani ien. ");
INSERT INTO ssg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Taun tehu ien, Haeu axi kawatan hani teka seilon ti Israel nake laha kum hong waxi i. Waliko ien i sohot haponowiai waliko ti teka kuluiai kakai Haeu tai kilamiwen leili pepaun. ");
INSERT INTO ssg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tataen ien, kawatan wanen ti teka hehin tialaha hina akaik ma teka natulaha susus tutuen. Kawatan tenen tenen tunahi teka seilon leili Israel nake Haeu lengeini hawane laha. ");
INSERT INTO ssg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Teka seilon ti hile ti xux liai laha telei kilan teka Ju ape kilan laha kalabusi hani xuxulaha. Laha aile halialu tatale teka seilon ti Israel atengi tataen tehu ngain Haeu kikilami.” ");
INSERT INTO ssg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ape Jises kak tatale ukek, “Taen ien waliko tenen tenen i sohot hani alon, pangapang ma kohot, i hamatau seilon. Seilon ti hatesol xux laha mamata hawane ma to akiaki nake taun ti weu ma teletele. ");
INSERT INTO ssg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kilan seilon laha akimatu ma na laha mat ti mamataualaha nake hatesol waliko he maun i nuea eliel. ");
INSERT INTO ssg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ape laha ningahi nga tel Nati Seilon mosulih patul he maun hetekie lalape poh ma soliai talepai xewaiak. ");
INSERT INTO ssg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ti waliko ien sosohotule, amuto tu xoxoa nake Haeu tel awaiamuto i xohiwen ti ape i waxi auni amuto lian tehue. ");
INSERT INTO ssg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jises kak kolongeni hani tesol kahikahin i ukek, “Amuto namiloi paxaiwa talil. ");
INSERT INTO ssg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ti kaun mak put, amuto tioi ka taun ti aupol angiha. ");
INSERT INTO ssg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tin masin, taen amuto ningahi tesol waliko nga kakanewen amuto i sohot, amuto tioi kewak taun ti Haeu neini seilon ape i xohi hawanewen. ");
INSERT INTO ssg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nga kakane hawane amuto, hina seilon ti aope ie laha kum matemu atengi tataen waliko ien i sohot. ");
INSERT INTO ssg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Maun ma xux ti aope i tapo tamus tuahe kakaiak hamalum lian tehue. ");
INSERT INTO ssg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Amuto lepetawa. Kum namiloi hahakila waliko ti itan ie. Kum un taxitaxia, kum ailele saun lialun ti teka weli unum ailele ma kum namiloi hahakila waliko tenen amuto tae. Na amuto aile luhuke tesol waliko ien, aliaiak i haonga amuto hanowi hunan lialun na i tunahi amuto itax. ");
INSERT INTO ssg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nga hone amuto tetenen nake waliko ti i sohot taun ti aliaiak, i hani kawatan tenen tenen hani seilon ti xux texux texux. ");
INSERT INTO ssg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Amuto kum luhuluh. Amuto lotu elieliwa lawe ngain lehe Haeu huali amuto haxoxoi namilomuto tetan leili taun ti tesol kawatan ien. Na amuto aile ukek ien, amuto kum hienake woumuto taun ti nga tel Nati Seilon aliama ti hinitiai seilon.” ");
INSERT INTO ssg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tesol ngain ien Jises nahih hani Ingi Haeu hanaui teka seilon ngain hatehu. Ape lawe ipong i matih he tehu Maunt Oliv. ");
INSERT INTO ssg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Lawe letu teka seilon nahih hani Ingi Haeu ti hongoi kakaian. ");
INSERT INTO ssg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ngain lalap ti teka Ju ti aniai bret tenen i tai xiu ape i xohiwen. Laha axai tehu angiain ien Pasova. ");
INSERT INTO ssg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses, lato upiup aweisal ti teleiai Jises. Tuahe pahalato seilon kum tioi nake lato mamata uke laha hutui hile. ");
INSERT INTO ssg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Taen ien Satan ape i puas leili Judas Iskariot, tel ti tesol huopanim hua aposel. ");
INSERT INTO ssg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aile ape Judas nahih hani kapi teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka masiwi ti teka peteniai Ingi Haeu. Lato kak tataneni aweisal ti na Judas hangaini Jises hani lato. ");
INSERT INTO ssg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Teka masiwi amuam hawane ti teik namil ien ape lato kakane Judas ka lato kahui i. ");
INSERT INTO ssg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas waheni ape i atengi tehu taun solian na i hangaini Jises ti tap tel tioi. ");
INSERT INTO ssg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ngain lalap ti teka Ju ti aniai bret tenen i tai xiu ape i tahiawen. Ngain tehu ien tin laha telei sipsip wawan uluha angiain ti Pasova. ");
INSERT INTO ssg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ape Jises talo Pita ma Jon ukek, “Nahih apeseniwa angiain ti Pasova ti kako hatesol.” ");
INSERT INTO ssg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Lalu kamei i, “Amili apeseni hani ia?” ");
INSERT INTO ssg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","I pahoi lalu ukek, “Na amulu soh haniwa Jerusalem, amulu apatuini tel wawan kakau tehu peti kan. Kahiti i haniwa tehu ing na i sohoa. ");
INSERT INTO ssg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ape kameiwa tel tame tehu ing kewak, ‘Tel masiwi kamekam, tetesol ia na i ang tehu angiain ti Pasova kapi tesol kahikahin?’ ");
INSERT INTO ssg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","I kola hani amulu tesol tonain ti leili ing teke patul, lawe waliko ti angiain leilon. Apeseniwa anakako ien.” ");
INSERT INTO ssg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ti lalu nahih haniwa Jerusalem, lalu tunahi lawe waliko masin ti Jises kakawen. Ape lalu apeseni an ti Pasova ien. ");
INSERT INTO ssg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ti ape lolohan, Jises to ang akati tesol huopanim huhua aposel. ");
INSERT INTO ssg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","I hone lato, “Nga hoi pahak wanen nga ang tetehu angiain ti Pasova ie kapimuto imat ti nga kau kawatan. ");
INSERT INTO ssg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nga kakane hawane amuto, nga kum ang ulea angiain ti Pasova atengi taen ti nenein ti Haeu i sohot xeu.” ");
INSERT INTO ssg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ape Jises waxi tehu kap hina waen, i kak kemulik hani Haeu ape i ukek, “Waxiwa tehu kap ape un seiwa wasolamuto. ");
INSERT INTO ssg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nga kum un ulea waen atengi taun ti amuam leili tone Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ape i waxi teik bret, i kak kemulik hani Haeu, i wiki sei hani tesol kahikahin ape i ukek, “Ie tupuak nga hani Haeu. Nga hani i lehe nga mat ti kaui kawatan ti lialui woumuto. Amuto wiki seiwa bret masin ti kako ailele tetelao. Amuto aile kapitiniwa ti nameniai mateak.” ");
INSERT INTO ssg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ti lato ang kewa i waxi tehu kap waen ape i ukek, “Ie se kakauk i xiweu ti kolakol ka Haeu oxoxi seilon ti kawatan ti lialui woulaha na namilolaha xoxoan tetan. Mateak i kola hapoponowi ka Haeu xinoti tenen namil haun kapi seilon. ");
INSERT INTO ssg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tuahe leilokako ie tel seilon i hangaini nga hani teka teleiak. ");
INSERT INTO ssg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nga tel Nati Seilon, hoi liai nga mat masin ti Haeu namiloiwen. Tuahe Haeu axi hawane kawatan hani tel hangainiak.” ");
INSERT INTO ssg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ape tesol aposel he kamekam alia puki lato aita wanen lehe i aile saun tenen ien. ");
INSERT INTO ssg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Muhin ien tesol aposel he lungelung aita tel pamu tuah leilolato. ");
INSERT INTO ssg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jises hone lato, “Amuto tioi ka kewi teka masiwi ti he tehu pon ie lato neini halialu teka seilon hahitakalato ape lato lungei laha ka tua hongoa lato. Ape teka masiwi ien namiloi ukek ka lato seilon ti huhual. ");
INSERT INTO ssg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tuahe amuto kum aile hahanowi woulato. Tel pate tuah leilomuto i teheni aliakewa i hualiai seilon liai ma tel masiwi i kewa masin tel unauamuto. ");
INSERT INTO ssg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Aita pamu masiwi, tel i to angiang ka tel lohiai anan? Se tetel i to angiang. Tuahe nga kakane amuto, kalak nga tel masiwi, nga puas hanowi tel tuahe unaui seilon ti nga kapimuto. ");
INSERT INTO ssg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nga paxai tioi ka lawe amuto tu xox kapik kalak nga kau kawatan ma moloan. ");
INSERT INTO ssg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Masin ti tel Tamak Haeu kilamiwen nga neiniai seilon, nga kilami ulei amuto. ");
INSERT INTO ssg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Imuh amuto ang ma un amuam kapik leili tone Haeu. Ape amuto uke tesol tonain ti kolongeniai saun ti teka seilon ti Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jises kakane Pita ukek, “Saimon hongoa! Haeu sowini hani Satan puas eliel tohongi lali amuto hatesol na xoxoi namilomuto hani Haeu i tapo. Ie masin wanen peni api laha selai ti apieun. ");
INSERT INTO ssg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tuahe nga kamei eliel Haeu ti hualiam lehe namilom i xox tatale tetan. Ape na o towiahu ti lialui woum hani Haeu, huali haxoxoa namili teka kahikahik hani i.” ");
INSERT INTO ssg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tuahe Pita ukek, “Xoxoi namilok hani Haeu i kum tapo kalak na laha kalabusi nga ma na telei nga ohoi o.” ");
INSERT INTO ssg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jises ukek, “Nga kakane hawane o, imat ti tok mom wawan kokoini ipong tetehu, o putini ka o kum tioi wanen nga uke he toluhu.” ");
INSERT INTO ssg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ape Jises kamei tesol kahikahin ukek, “Amuto nameni ti nga talomu amuto ailei puasak, nga hone amuto kum kau hehetekie moni ma kakumuto, ma tin kum ngah hahasea axahe aemuto. Nakon hina waliko amuto tae ti lokon ien?” Lato pahoi ukek, “Tap.” ");
INSERT INTO ssg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jises ukek, “Tuahe aope ie na amuto aile puasak, amuto tunahi kawatan tenen tenen. Aile ape amuto apeas aluawa. ");
INSERT INTO ssg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Waliko ti Haeu kakawen i sohot hani nga, sikole ape i sohot ti i ukek, ‘Laha aile hani i hanowi tel seilon woun lialun.’” ");
INSERT INTO ssg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tesol kahikahin ukek, “Amite apeasawen. Hua ngol weluwelun ti hile ie.” Tuahe Jises ukek, “Ape tapan. Kum kakak waliko tenen ien.” ");
INSERT INTO ssg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Muhin ien Jises nahih ahuta ti Jerusalem ape i nahih hani tehu Maunt Oliv, masin ti lawe i ailele. Ape tesol kahikahin kahiti i. ");
INSERT INTO ssg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Taen ti lato tahiawa, i kakane lato ukek, “Amuto lotu petawa lehe totohong kum haputa amuto.” ");
INSERT INTO ssg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jises nahih ahewa teik, i lokuha ape i lotu. ");
INSERT INTO ssg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","I ukek, “Tel Tamak Haeu, na lom al, xaxaweniwa tehu lalape kawatan ti lehe i tunahi nga. Tuahe pahak nga usi namilom.” ");
INSERT INTO ssg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Taen ien tel engel, spirit solian ti Haeu, sohot hani kapin hakuian. ");
INSERT INTO ssg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tian kawat eliel hawane ape i lotu eliel ahe. Mapuen masin tuhui kaka i put haniwa itan. ");
INSERT INTO ssg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","I lotu kewa ape i nahih alia hani kapi tesol kahikahin. I tunahi lato mamatih nake tialato xuhai tatahan. ");
INSERT INTO ssg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","I kamei lato, “Alahan amuto mamatih? Amuto xahatawa ape lotu petawa lehe amuto xoini totohong ti Satan na i tunahi amuto.” ");
INSERT INTO ssg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jises kakak tutuen ti Judas hakahitama teka seilon. I tel ti tesol huopanim huhua kahikahi Jises. I nahih xohiwa ape i asoi taliope Jises. ");
INSERT INTO ssg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tuahe Jises ukek, “Alahan o asoi nga hanowi kalu lohun a lehe ape o hangaini nga tel Nati Seilon?” ");
INSERT INTO ssg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ti tesol kahikahin paxai tioiwa ka laha tahiama pohiai Jises lato ukek, “Tel masiwi, kaie amite hil pahoi lato? Amite hina ngol weluwelun ti hile.” ");
INSERT INTO ssg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ape tel ti kahikahi Jises tai koti haputa taxing tepaun sai manau ti tel unaui tel masiwi tapein ti hukuminiai Haeu ma seilon. ");
INSERT INTO ssg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tuahe Jises ukek, “Kum hilehil.” Ape i aile hasolia aliake taxingi tel seilon. ");
INSERT INTO ssg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Muhin ien i hone teka masiwi tuah ti hukuminiai Haeu ma seilon, teka masiwi ti teka peteniai Ingi Haeu ma teka masiwi ti Ju liai, i ukek, “Amuto kauma ngol ma pata ti hile hanowi ka nga seilon lengean. ");
INSERT INTO ssg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Lawe ngain nga hahanau teka seilon leili Ingi Haeu a amuto tai xoti nga. Tuahe ie taun ti Haeu haniwen amuto xotiak. Teik taun kukunun Haeu sowini hani Satan neini amuto aile halialuak.” ");
INSERT INTO ssg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Laha xotiwa Jises ape hakahita i hani tehu ingi Kaiapas, tel masiwi tapein ti hukuminiai Haeu ma seilon. Pita nahih paxai otioti Jises ti tesol pala xauxaun. ");
INSERT INTO ssg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ti lato tahiawa, teka peteniai ingi Kaiapas hahawia tehot ah mate ing ape Pita to hah akati lato. ");
INSERT INTO ssg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tel hehin unaui Kaiapas paxai kapitini Pita ape i ukek, “Tel seilon ie tin tel ti tesol kahikahi Jises.” ");
INSERT INTO ssg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tuahe Pita ukek, “Oie, nga kum tioi tel seilon ien!” ");
INSERT INTO ssg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tai kue tel seilon liai ningahi Pita ape i ukek, “O liai tel ti lato!” Pita pahoi ukek, “Kumahe, nga tap.” ");
INSERT INTO ssg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Imuh tel liai kak ulea ukek, “Tel seilon ie liai lawe kapi Jises nake i ti Galili.” ");
INSERT INTO ssg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tuahe Pita pahoi ukek, “Oie, waliko ti o kakak kumahe salan.” Ti Pita kakak tutuen tok mom wawan kokoiniwa. ");
INSERT INTO ssg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Lokon ien wanen Jises xeisa pax sawi hani Pita ape Pita nameni aliake kakai Jises ti i ukek, “Imat ti tok mom wawan kokoini ipong tetehu, o putini ka o kum tioi wanen nga uke he toluhu.” ");
INSERT INTO ssg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita sohot ape i tang tahane hawane. ");
INSERT INTO ssg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Teka peteniai Jises laha mal soxeni ma xai i. ");
INSERT INTO ssg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Lato xioti atuhi pulan ape hone i, “Na o Krais, tilawa tetel i xaxai o!” ");
INSERT INTO ssg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Lato towi hakila kakain tenen pate lialun hani i. ");
INSERT INTO ssg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ti letua teka masiwi tenen tenen ti teka Ju, laha apuha hukuma. Leilolaha tesol masiwi tuah ti hukuminiai Haeu ma seilon ma tesol hanaui nauna ti Moses. Ape laha ati Jises hani mateiwaulaha. ");
INSERT INTO ssg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ape teka ti laha ukek, “Kaxi hanima amite na salan o Krais.” Tuahe i pahoi ukek, “Na nga kaxi hani amuto, amuto kum soh. ");
INSERT INTO ssg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A na nga kamei amuto nake lahan amuto kum soh nga Krais, amuto kum pahoi nga. ");
INSERT INTO ssg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tuahe nga kakane amuto, tai kue nga tel Nati Seilon, nga to he tepaun min manau ti Haeu tel pohen wanen, neiniai seilon kapin.” ");
INSERT INTO ssg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Laha hatesol kamea, “Na masin ien, nakon o tel Nati Haeu?” I pahoi ukek, “Puki namilomuto ukek ien.” ");
INSERT INTO ssg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ape laha ukek, “Kako kum ngah ulea seilon suluan. Amuto hongoen i ukek i tel Nati Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Muhin ien hatesol masiwi ti tehu apuhain ien, laha tua ape ati Jises hani kapi Pailat, tel ti teka masiwi ti Rom kiliwakei Judia. ");
INSERT INTO ssg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ape laha aile tanomi ngah kakain ti suluan, laha ukek, “Tel seilon ie hahika teka seilon ti amite pahoiai teka masiwi ti Rom laha neneini amite. I hone laha kum hahani Sisa, tel masiwi tapein ti Rom, moni ti pahan. Ape i ukek i tel masiwi ti teka seilon ma i Krais, tel Haeu taloma.” ");
INSERT INTO ssg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailat kamei i, “Nakon o tel masiwi tapein ti teka Ju?” Ape Jises pahoi ukek, “Puki o kak ukek ien.” ");
INSERT INTO ssg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ape Pailat hone teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka laha apupuha, i ukek, “Nga tai tunah tenen na i pon suluiai tel seilon ie.” ");
INSERT INTO ssg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tuahe laha lungelung eliel ahe ape laha ukek, “I hanau hahalialu hatesol seilon ti Judia. I hutui leili Galili ape i tamus hahanima ie.” ");
INSERT INTO ssg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ti Pailat hong kewak ien, i kamea, “Nakon tel seilon ie i ti Galili?” ");
INSERT INTO ssg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ti i tioiwa ka Jises i ti xux ti Herod ngangahati, i talo Jises hani kapi Herod i tin Jerusalem lokon ien. ");
INSERT INTO ssg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod amuam hawane ti i ningahiwa Jises nake i hongoen axan. Kue hawanewen pahan i paxai. Pahan Jises aile kolawa waliko tenen lalap ti kui poh lehe i paxai. ");
INSERT INTO ssg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ape Herod kamei hakila hawane Jises kamekame tuahe i tai kak pahoi na tenen. ");
INSERT INTO ssg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Teka masiwi tuah ti hukuminiai Haeu ma seilon, ma teka hanaui nauna ti Moses tutu ien ape lato eliel hawane suluiai Jises. ");
INSERT INTO ssg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Aile ape Herod ma tesol unauan ti hile lato soxeni Jises ma lato kak teheni halialu hawane i. Lato puxui i tehu puxux pate solian hanowi ka i tel masiwi ape lato talo aliake i hani kapi Pailat. ");
INSERT INTO ssg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kemuk, Herod ma Pailat lalu he wawatak tuahe ngain tehu ien ape lalu lohuloh. ");
INSERT INTO ssg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Muhin ien Pailat apuhini teka masiwi tuah ti hukuminiai Haeu ma seilon, teka masiwi liai ti teka Ju ma teka tuahe seilon. ");
INSERT INTO ssg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ape i hone laha ukek, “Amuto ati hanima nga tel seilon ie, amuto ukek i hahika teka seilon pahoiai nenein ti amite teka masiwi ti Rom. Nga kamei nihehi paxaiwen i he matamuto ape nga tunahi ka kakaiamuto i kum pon suluan. ");
INSERT INTO ssg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod tin i tai tunah tenen waliko lialun na i ailewen, aile ape i talo aliake i hanima kapi kako. Tap tenen waliko tel seilon ie ailewen ti i tapai na telei i. ");
INSERT INTO ssg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Aile ape nga hani teka unauak ti hile heti i ape hanahi lioi.” ");
INSERT INTO ssg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Leili taun ti Pasova, tehu angiain lalap ti nameniai ngain ti Haeu waxi aliake teka Ju ti Igip, saun ti tel masiwi Pailat i ahuti tel ti teka kalabus, tetel ti teka seilon pahalaha. ");
INSERT INTO ssg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Hatesol seilon laha apupuha kapin laha ausini ukek, “Teleiwa Jises ape oxoxi hanima amite Barabas!” ");
INSERT INTO ssg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas i kalabus kapi teka seilon tuaun nake lato hil pahoi teka masiwi ti kiliwakei xuxulaha teka Ju. Leili hilehile i telei hina seilon. ");
INSERT INTO ssg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat pahan i oxoxi Jises, aile ape i kamei ulei teka seilon. ");
INSERT INTO ssg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tuahe laha tilol pahoi ukek, “Teleiwa i! Tahi hakeawa i he kros.” ");
INSERT INTO ssg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailat hone tuhi ulea laha ukek, “Waliko la lialun i ailewen? Nga tai tunah tenen waliko na i ailewen ti i tapai na telei i. Aile ape nga hani teka unauak ti hile heti i ape nga hanahi lioi.” ");
INSERT INTO ssg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tuahe laha tilol ausini tatale ka teleiwa Jises. Titilolo ti laha i aile ape Pailat sowini hani laha. ");
INSERT INTO ssg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aile ape Pailat usi namilolaha ape i noseni ka telei Jises. ");
INSERT INTO ssg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","I oxoxi hani laha tel pahalaha, tetel i kalabus ti hilehile ma teleiai seilon. Ape i hone teka unauan ti hile tahi hakeai Jises he kros pata. ");
INSERT INTO ssg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ti teka unaui Pailat ti hile hakahitawa Jises, lato apatuini tel seilon axan Saimon nahih hahaniwa taon. Ape lato lungei i kau usiai Jises teik kros ti Jises kakau. ");
INSERT INTO ssg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kilan wanen seilon nanahima muhi Jises. Leilolaha teka hehin lato tang tatahane i. ");
INSERT INTO ssg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jises paxaiwa lato ape i ukek, “Hehin ti Jerusalem, kum tangixi eliliel nga, amuto tangixi elieliwa puki amuto ma natumuto. ");
INSERT INTO ssg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ngain i luluainima laha aile halialu Jerusalem ape telao ien amuto ukek teka hehin tap akaik laha amas. Teka hehin lieheh ma teka laha tai hahasu akaik laha amas. ");
INSERT INTO ssg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ti lalape kawatan ma moloan, teka seilon hone tesol maunten masin ti tel kuluiai kakai Haeu kakawen, ‘Put tihini teleiwa amite.’ ");
INSERT INTO ssg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ti laha aile halialu nga tel seilon sawisawin, ien masin ka laha lui salo moihin, i kum lua tapo. Tuahe Haeu pamu i axi kawatan hani teka seilon laha kum towiahu ti lialui woulaha. Ien masin salo paxean i lua tapo hawane.” ");
INSERT INTO ssg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Teka seilon ti hile tin lato ati hetekie hua seilon woulalu pate lialun lehe telei akati Jises. ");
INSERT INTO ssg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ti lato tahia haniwa tesol axan “Tetesol tanoman masin kui pati seilon,” teka seilon ti hile tahi hakea Jises he kros pata. Muhin lato tahi hakea huhua liai, tel tepaun manau ape tel sai kalamau ti Jises. ");
INSERT INTO ssg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ti Jises patul he kros i ukek, “Tel Tamak Haeu, oxoxiwa teka seilon ie ti kawatan ti tenen saun lialun ie nake laha kum tioi waliko tenen laha ailele.” Ape teka seilon ti hile lato halokeni satu ti upiai tetel i uke tetenen ia ti tesol sose Jises. ");
INSERT INTO ssg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Teka seilon tu paxapax a teka masiwi ti teka Ju kak soxeni Jises ukek, “I huali teka seilon liai. Na masin salan i Krais, tel Haeu kilami ma taloma, i huali aliakewa i!” ");
INSERT INTO ssg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Teka seilon ti hile tin lato kak soxeni i. Lato nahih hani kapin ape axi unuman waen wangingian. ");
INSERT INTO ssg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ape lato ukek, “Huali aliakewa o na o masiwi tapein ti teka Ju!” ");
INSERT INTO ssg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Teik kakain ti suluian lato tahi hakea onote patun i kak ukek, “Tel Masiwi Tapein ti teka Ju.” ");
INSERT INTO ssg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tel ti huhua seilon laha hakea kapi Jises, i soxeni Jises ukek, “Na o Krais, hualiwa kako.” ");
INSERT INTO ssg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ape tel liai tumei i ukek, “Namiloiwa Haeu nake o tin ape o mat. ");
INSERT INTO ssg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sawisawin wanen ti laha telei kalu. Kawatan ti kalu uke, i hapono hawane saun ti kalu ailewen tuahe tel seilon ie i tai aile tenen waliko lialun.” ");
INSERT INTO ssg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ape i ukek, “Jises, taen o toa Masiwi ti neiniai lawe seilon, tahanema nga.” ");
INSERT INTO ssg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jises hone i ukek, “Nga kakane hawane o, taen tetelao o soh akati nga hani tone Haeu, tesol ti amuamu tap tahi tapoan.” ");
INSERT INTO ssg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ti lape ngain, hatehu xux i tilok ti leili aua toluhu. ");
INSERT INTO ssg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tataen ien wanen Haeu lexi teik maia i akeak leili tehu Ingi Haeu, ti patul haniwa taen itan. ");
INSERT INTO ssg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ape Jises tilol eliel ukek, “Tel Tamak Haeu, nga hana nga hani he minam.” I kak kewak ien ape i mat. ");
INSERT INTO ssg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tel masiwi ti teka seilon ti hile i namiloi paxai hatesol waliko ti i sosohot ti Jises mat. Ape i sameni Haeu. I ukek, “Salan wanen, tel seilon ie seilon sawisawin, i tai aile tenen na saun lialun.” ");
INSERT INTO ssg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kilan seilon laha apupuha ti paxapaxa tin laha paxai tioi ka i seilon sawisawin ape laha alia hani tonalaha hetekie lalape tatahan. ");
INSERT INTO ssg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ape teteka laha tioi Jises, laha tu siasia papaxai waliko ti sosohot lokon ien. Leilolaha tesol hehin lato kahitima Jises ti Galili hani Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ti ien tel seilon sawisawin axan Josep ti tehu taon Arimatea leili Judia. I tel ti teka masiwi ti teka Ju ape i atetengi taun ti Haeu neini lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kalak i tel ti teka masiwi, i kum amuke namil ti lato ailewen teleiai Jises. ");
INSERT INTO ssg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","I nahih hani kapi Pailat ape i kamei na i waxi auni tupui Jises. ");
INSERT INTO ssg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ti Pailat sowini haniwa i, Josep ma teka hualian hamosu tupui Jises ape lato puxui talini i teik maia weluwelun. Muhin lato hana i hani leili amal tenen laha tanomi he pot patul ti hepekeun. Tehu amal ien laha tai hahana tupui seilon. ");
INSERT INTO ssg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sai ape alohah ti ngain ti apeseniai Sabat. ");
INSERT INTO ssg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tesol hehin ti lato kahitima Jises ti Galili, lato nahih usi tamusuke Josep hani he amal ape lato paxai ti i hana tupui Jises. ");
INSERT INTO ssg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Muhin ien lato nahih alia ape apeseni sanda lehe lato ahui hani tupuan. Lato tai aile telao ien nake lato hanau telao Sabat usiai nauna ti Moses. ");
INSERT INTO ssg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pate letu ti Sande, tesol hehin nahih hani he tehu amal. Lato kaua sanda ti lato apeseniwen. ");
INSERT INTO ssg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lato ningahi tehu pot laha uke siponiai amali Jises ape hulinan. ");
INSERT INTO ssg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ape lato soh hani leilon tuahe lato kum niningah tupui tel Masiwi Jises. ");
INSERT INTO ssg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lato tataxini ape tua tu lalolal. Hua seilon take hahutuia hani kapi lato. Puxuaulalu xeu talepalep hawane. ");
INSERT INTO ssg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tesol hehin mamata hawane ape lato lokuha lakua hani itan. Huhua seilon ien hone lato ukek, “Kalahai amuto pax upiup tel seilon moihin he tone teka maten? ");
INSERT INTO ssg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","I kumahe ie. I moih aliawen! Nameniwa kakaian ti i kakanewen amuto ti Galili. ");
INSERT INTO ssg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Lokon ien i ukek, ‘Nga tel Nati Seilon, hoi liai laha hana hani mini teka seilon woulaha lialun. Laha tahi hakea nga hani he kros ape nga mat tuahe muhi ngain toluhu nga moih alia.’” ");
INSERT INTO ssg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ti tesol hehin hongoa, lato nameni aliake kakai Jises. ");
INSERT INTO ssg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Lato nahih salili amal ape lato kaxi hatapo waliko ti i sosohot hani tesol huopanim tel kahikahi Jises ma teka kapi lato. ");
INSERT INTO ssg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tesol hehin kaxiai tenen meng ien hani tesol aposel, axalato Mary Magdalen, Joana, Mary tel tini Jeims ma hina hehin liai. ");
INSERT INTO ssg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tuahe lato sokok tesol hehin tua kak lalolal ma lato kapaxe. ");
INSERT INTO ssg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tuahe Pita tua ape i kiliwau hani he tehu amal. I wana hani leilon ape i ningahi mewenae teik maia puxuiai Jises. I nahih alia hani kapi tesol liai ape i to namiloi tataxini waliko ti i sosohot. ");
INSERT INTO ssg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ngain tin tetehu, hua kahikahi Jises nahih hani tewau toan axan Emaus, sai masin huopanim tehu kilomita xauxaun ti Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ti lalu nanahiwa, lalu he kakak lawe waliko ti i sohotuen. ");
INSERT INTO ssg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ti lalu to kakak, Jises sohot hani kapi lalu ape i nahih akati lalu. ");
INSERT INTO ssg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tuahe lalu kum ila tioi i nake pulalalu masin i kum xeu. ");
INSERT INTO ssg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jises kamei lalu, “Amulu he kakak waliko la?” Lalu tu hamalum, kawalalu kola ka lolalu pate teluan. ");
INSERT INTO ssg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tel ti lalu axan Kleopas hone Jises, “Oheak mewenae o leili teka seilon ti laha nahih haniwa Jerusalem kum tioi waliko ti i sosohot ien hina ngain tamusuen.” ");
INSERT INTO ssg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","I kamea, “Waliko la?” Lalu pahoi ukek, “Waliko ti i sohot hani Jises ti Nasaret, tel kuluiai kakai Haeu. Haeu hapohea i ape kilan seilon sameni pohe kakaian ma puasan. ");
INSERT INTO ssg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Teka masiwi tuah ti hukuminiai Haeu ma seilon ma teka masiwi liai ti kaha, lato aile namil ti teleian ape hani laha tahi hakea Jises hani he kros ape i mat. ");
INSERT INTO ssg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aiha sokok i se tetel oxoxiai teka seilon ti Israel ti hahitake teka Rom ma kawatan tenen tenen. Tuahe laha telei i ngain toluhu tamusuen a tap tenen waliko sohotuen. ");
INSERT INTO ssg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ape tetelao menge tesol hehin kahikahi Jises ti lato aliama he tehu amal i hahataxina amite. ");
INSERT INTO ssg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Lato kum niningah tupui Jises. Lato ukek lato ningahi hina engel ape teka engel hone lato ka Jises ape moihin. ");
INSERT INTO ssg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aile ape teka ti amite nahih hani he tehu amal ape lato ningahi masin wanen ti tesol hehin kakaxi tuahe lato tai ningahi Jises.” ");
INSERT INTO ssg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ape Jises hone lalu ukek, “Patumulu pate ailan. Pate amuto soh hahakokol hatesol waliko ti teka kuluiai kakai Haeu kakawen. ");
INSERT INTO ssg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Hoi namili Haeu ka Krais kaumu lalape kawatan ma moloan ape muhin Haeu hamoiha i ape waxi hani tesol tonain tuah leili tonan.” ");
INSERT INTO ssg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ape Jises nexi hani lalu ka waliko ti Moses ma hatesol teka kuluiai kakai Haeu taiwen kakak alia i. ");
INSERT INTO ssg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ti lato xohi haniwa Emaus, Jises lehe i nahih ahe. ");
INSERT INTO ssg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tuahe lalu ukek, “O tilimuen kapimili nake sikole ape i tilok.” Ape i soh akati lalu. ");
INSERT INTO ssg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ti lato to ang, Jises waxi teik bret, i kak kemulik hani Haeu, i wiki ape i hani lalu. ");
INSERT INTO ssg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tataen ien pulalalu xeu ape lalu ila tioi Jises. Muhin ape i kaluta ti lalu. ");
INSERT INTO ssg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ape lalu kakak alia puki lalu ukek, “Ti kako he aweisal, tiakalu i amuam hawane ti i kakak kapi kalu ma nexi hahani kalu kakain ti he pepai Haeu.” ");
INSERT INTO ssg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Lalu tu huluta ape lalu nahih alia hani Jerusalem, tetesol huopanim tel kahikahi Jises ma teka kapi lato apupuha. ");
INSERT INTO ssg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Lato kakane lalu ukek, “Salan wanen! Tel Masiwi Jises i moih aliawen. Tin i sohot haniwen kapi Saimon Pita.” ");
INSERT INTO ssg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ape lalu kaxi hani lato waliko ti i sohot he aweisal. Lalu ukek, “Ti Jises wiki teik bret, tataen ien wanen ape amili ila tioi i.” ");
INSERT INTO ssg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lokon ti lalu to kakaxi hani lato tesol waliko ien, Jises take hahutuia hani kapi lato ape i hone lato ukek, “Amuam ti Haeu hani amuto.” ");
INSERT INTO ssg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lato ong mamata hawane nake lato sokok lato niningahi hosai tel seilon maten. ");
INSERT INTO ssg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tuahe Jises ukek, “Alahan amuto mamata? Ala amuto kum kakapaxe ka nga moih alia. ");
INSERT INTO ssg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Paxaiwa minak ma aek ka salan wanen nga. Sotima nga lehe amuto tioi ka nga tel seilon moihin. Hosai seilon maten tap tupuan masin ti amuto ningahi nga hina.” ");
INSERT INTO ssg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","I kak kewa ape i kola hani lato minan ma aen. ");
INSERT INTO ssg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Lato ong ma amuam hawane tuahe namilolato i uke huaik. Aile ape i katei lato an. ");
INSERT INTO ssg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ape lato hani i teik xixi lelean. ");
INSERT INTO ssg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","I waxi ape i ani he pulalato. ");
INSERT INTO ssg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Muhin i hone lato, “Ti nga tutuen kapimuto nga honewen amuto ka waliko ti laha taiwen leili pepai Moses, teka kuluiai kakai Haeu ma leili pepai Salm i kakak nga, liai i sohot poponowi.” ");
INSERT INTO ssg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ape Jises haxewa namilolato sale kakain ti leili pepai Haeu. ");
INSERT INTO ssg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","I hone lato, “Kakain ti leili pepai Haeu i ukek ka Krais tunahi kawatan ma moloan lalap ape i mat tuahe muhi ngain toluhu i moih alia. ");
INSERT INTO ssg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Hutui ti Jerusalem teka kahikahik sawateni meng solian ti Haeu hahitake axak hani teka seilon ti lawe xux. Teka laha towiahu ti lialui woulaha, Haeu oxoxi laha ti kawatan ti saun lialun ti laha. ");
INSERT INTO ssg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Amuto kaxi hatapoa waliko ti amuto ningahiwen i sohot hani nga ma hatesol waliko ti nga hanauen seilon. ");
INSERT INTO ssg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Ape nga hani amuto Holi Spirit masin ti tel Tamak Haeu kakawen. Amuto tiliwen Jerusalem atengi taen Holi Spirit haniwa amuto poh ti ailei puasak ma ti kapitiamuto.” ");
INSERT INTO ssg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Muhin ien Jises hakahita tesol kahikahin ti Jerusalem hani taen tewau toan Betani. I tulini minan hani patul ape i kamei Haeu ti hualialato. ");
INSERT INTO ssg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ti ien Haeu waxi i hani tesol tonan patul. ");
INSERT INTO ssg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ti Jises saliliwa tesol kahikahin, lato lokuha ape lotu sameni i. Muhin ape lato nahih alia hani Jerusalem hetekie lalape amuam. ");
INSERT INTO ssg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Lawe ngain lato nahih hani Ingi Haeu. Lato lotu sameni Haeu ma kak kemulik hani i ti lawe waliko i ailewen. ");
INSERT INTO ssg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ti uli hutui lawe waliko tetel i Kakain i liai hoi ien. I kapi Haeu ma i se Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Uli hutui lawe waliko i hoi liai kapi Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Haeu hapuasa i ti tanomiai lawe waliko. Na Haeu kum hapuasa i, tap wanen tenen waliko tanomawen. ");
INSERT INTO ssg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tetel i Kakain i to kapi Haeu lian tehue ape i tetel haniai seilon tonain kapi Haeu ti tap tahi tapoan. I masin xewai alon. I haxewa hani seilon lawe waliko. ");
INSERT INTO ssg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","I hokai haxewa tilokoi namili seilon ape tilokoan kum pon tipehian. ");
INSERT INTO ssg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tel seilon axan Jon Baptis, Haeu talo i hani kapi teka seilon ailei pupuasan. ");
INSERT INTO ssg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","I kaxi hani laha tetel masin xewai alon lehe lawe seilon soh tetan. ");
INSERT INTO ssg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Puki Jon kumahe tetel masin xewai alon, i tua kaxi haxewa hahani laha tel masin xewai alon. ");
INSERT INTO ssg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tetel masin xewai alon i tahia hanima hatehu pon itan ie lehe i haxewa hawane lawe waliko salan ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","I hoi lawe kapi Haeu ape Haeu hapuasa i tanomiai tehu pon itan ie tuahe ti i tahiama, teka seilon kum paxai tioi i. ");
INSERT INTO ssg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I lua hani xuxun tuahe puki teka akikin kum tani waxi i. ");
INSERT INTO ssg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","A teka laha tani waxi i ape laha soh tetan, i huali laha sohot nati Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kumahe laha sohot nati Haeu ti sale nenex, ti namili seilon ma na isiai wawan ti hatanoan. Puki Haeu aile, ape laha sohot natun. ");
INSERT INTO ssg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tetel i Kakain i sohot seilon hanowi kaha ape i luama to kapi kaha ti tehu pon itan ie. Kaha ningahi lalape pohen ma soliaian, tel pate tuah wanen i luama ti Haeu tel Taman. Tap tel soliaian masin tetan. Ti soliaian i kola lalape wawahen ti Haeu hani kaha ape i kola hatakei lawe waliko salan ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon kaxi hani seilon sale tetel i Kakain ti i ukek, “Tel seilon ien i tetel nga kakaxi ti nga ukek, ‘Tel na i luainima muhik i pamu masiwian tetak nake i hoi imat tetak.’” ");
INSERT INTO ssg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ti lalape soliaian i to aile hasolia hawane hahani kaha. ");
INSERT INTO ssg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moses hani kaha nauna ti Haeu tuahe Jises Krais aile kola lalape wawahen ti Haeu hani kaha ma lawe waliko salan ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tap tel ningahiwen Haeu. Tuahe telawe Natun i kola haxewa hani kaha seilon. Tel Natun se he aten wanen ma i se Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Telao teka masiwi ti teka Ju leili Jerusalem talo teka masiwi ti hukuminiai Haeu ma seilon ma teka puase leili Ingi Haeu hani kapi Jon Baptis lehe laha kamei i, “O aita? Nakon o Krais?” ");
INSERT INTO ssg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon kum puluhini, i kak haxewa ukek, “Nga kumahe Krais.” ");
INSERT INTO ssg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Laha kamea ulea, “A o aita wanen? Nakon o Elaija?” Jon pahoi ukek, “Nga kumahe Elaija.” Laha kamea ulea, “Nakon o tel kuluiai kakai Haeu masin Moses?” Jon pahoi laha ukek, “Kumahe.” ");
INSERT INTO ssg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Laha kamea ulea, “A o lahe seilon? Haxewa hanima amite lehe amite tioi hahongoi teka laha taloma amite.” ");
INSERT INTO ssg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ape Jon tua uke teik kakai Aisaia tel kuluiai kakai Haeu i ukek, “Nga tel i titilol hani seilon he lohong, ‘Towiahua ti lialui woumuto lehe tel Masiwi neini amuto taen i tahiama!’” ");
INSERT INTO ssg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tesol seilon teka Parisi taloma, lato kamei Jon ukek, ");
INSERT INTO ssg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Kalahai o baptaisi seilon na o kumahe Krais, kumahe Elaija, ma tin kumahe tel kuluiai kakai Haeu masin Moses?” ");
INSERT INTO ssg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon pahoi ukek, “Haeu sowini hani nga baptaisiai seilon ani kan tuahe ti wasolamuto tel seilon tuah amuto kum paxai tioi. ");
INSERT INTO ssg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I tel puasama muhik. Masiwiaian ala i kum pon nga unauan.” ");
INSERT INTO ssg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hatesol waliko ie i sosohot leili tewau toan Betani ti sai angiha pape kan Jodan, tetesol Jon baptaisi teka seilon. ");
INSERT INTO ssg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ngain liai telao Jon ningahi Jises nahih hahanima kapin ape i ukek, “Ie se tetel Haeu taloma lehe i mat hanowi sipsip uluha ti laha telei hani Haeu. I aile ape Haeu oxoxi seilon ti kawatan ti lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Seilon tetel nga kakak ti nga ukek, ‘Tel seilon na i luainima muhik, i pamu masiwian tetak nake i hoi imat tetak.’ ");
INSERT INTO ssg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Imat nga kum paxai tioi i tuahe nga luama baptaisiai teka seilon ani kan lehe teka seilon ti Israel laha paxai tioi hawane i. ");
INSERT INTO ssg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","“Nga ningahi Holi Spirit mosulih ti he maun hanowi tok pux ape to kapin. ");
INSERT INTO ssg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ape nga tioi i tetel nake Haeu, tel i taloma nga baptaisiai seilon ani kan, i kaxi hani nga ukek, ‘Tetel o ningahi Holi Spirit mos hanilih kapin i se tetel i hani seilon Holi Spirit ti kapitialaha.’ ");
INSERT INTO ssg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Salan wanen, nga ningahi waliko ien i sohotuen ape nga kaxi hani amuto ka tel seilon ie se tel Nati Haeu.” ");
INSERT INTO ssg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ngain liai telao Jon Baptis tutu kapi hua kahikahin. ");
INSERT INTO ssg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ti Jises nahih tatamusua, Jon pax sawi hani i ape i ukek, “Paxaiwa, ie tetel Haeu taloma lehe i mat hanowi sipsip uluha ti laha telei hani Haeu.” ");
INSERT INTO ssg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Huhua kahikahi Jon hong kewak ien ape lalu nahih kahiti Jises. ");
INSERT INTO ssg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jises tohea paxai tunahi ka lalu kakahitima i ape i kamei lalu, “Pahamulu waliko la? Lalu pahoi i ukek, “Tel masiwi, o toto ia?” ");
INSERT INTO ssg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","I pahoi lalu ukek, “Nahima paxai.” Lokon ien sai 4 kilok alohah. Ape lalu nahih kahiti i hani tonan. Lalu heuta kapin alohah hatehu. ");
INSERT INTO ssg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tel ti lalu axan Andru ukale Saimon Pita. ");
INSERT INTO ssg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kiliwan wanen Andru upia tel ukalan ape kakane i, “Amite paxaiwen Mesaia.” Tenen kakain “Mesaia” i ukek, “Krais.” ");
INSERT INTO ssg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Muhin ien Andru hakahita Saimon hani kapi Jises. Jises paxaiwa i ape i ukek, “Axam Saimon, tetel nati Jon, tuahe nga axai axam Kepas.” (Tenen kakain “Kepas” i ukek, “Pita” ma tin “tehu pot.”) ");
INSERT INTO ssg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ngain liai telao Jises nahih hani Galili. I apatuini Pilip ape hone i ukek, “Kahitima nga lehe o sohot kahikahik!” ");
INSERT INTO ssg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip seilon ti Betsaida, taon tin tetehu ti Andru ma Pita. ");
INSERT INTO ssg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip nahih upia Nataniel ape hone i, “Amite paxaiwen tel seilon ti Moses ma teka kuluiai kakai Haeu tai kakaxi. I Jises tel nati Josep ti Nasaret.” ");
INSERT INTO ssg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel kamei i, “Kaie hina waliko solian ti Nasaret?” Ape Pilip ukek, “Kahitima nga lehe o paxai.” ");
INSERT INTO ssg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ti Jises paxaiwa Nataniel nahih hahanima kapin, i ukek, “I tel seilon wanen ti Israel, i malang pulutiai seilon.” ");
INSERT INTO ssg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel kamei i, “O tioi nga ukek ia?” Jises pahoi i ukek, “Imat ti Pilip tunahi o, nga tioiwen ka o to nanamiloi kakai Haeu hahitake tea pata fig.” ");
INSERT INTO ssg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel ausinike hawane, “Tel masiwi, o tel Nati Haeu! O se masiwi tapein ti Israel!” ");
INSERT INTO ssg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jises ukek, “Nakon o soh tetak nake nga tioi ka o to nanamiloi kakai Haeu hahitake tea pata fig? Imuh o ningahi nga aile waliko tenen pamu lapan.” ");
INSERT INTO ssg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ape i hone lato, “Nga kakane hawane amuto, imuh amuto paxai tioi ka nga tel Nati Seilon se aweisal ti hukuminiai Haeu ma seilon masin ti Haeu kolawen ti leili paxangoi Jekop ti i ningahi teka engel han haniwa tone Haeu ma mos hanima itan.” ");
INSERT INTO ssg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Muhi ngain huohu, tehu salasala i sohot leili tewau toan Kana ti Galili. Leili teka seilon laha ilowi tel tini Jises hetekie Jises ma tesol kahikahin. ");
INSERT INTO ssg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ti leili salasala unumalaha waen i tapo ape tel tini Jises hone i, “Laha ape tap waen.” ");
INSERT INTO ssg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jises hone i ukek, “Kumahe puasakalu namiloan. I tai meima taun tetak ti Haeu kikilami.” ");
INSERT INTO ssg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tel tinan hone tesol ailei puasain ti sala, “Tua aile usiwa tenen na i hone amuto.” ");
INSERT INTO ssg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tepanim tehu peti kan ani pot hoi tutu ien, tehu tehu ti lato i akeni akulai 100 lita. Lawe teka Ju hapuasa ti nuhiai lawe waliko usiai saun ti haunialaha ti puli Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jises hone teka unaui tehu ing, “Utuhi tihiwa kan hani tesol peti kan ie.” Ape lato utuhi tihi atengi i xuh. ");
INSERT INTO ssg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","I hone ulea lato, “Utuhiwa teik ape kau haniwa tel ngahatiai sala.” Salan, lato aile usi kakaian. ");
INSERT INTO ssg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ti tel ngahatiai sala namihiniwa, kumahe ape kan nake Jises kolitini haniwen waen. I kum tioi lato kema tetesol, tuahe tesol utuhiai kan lato tioi. I tiloi tel seilon i sal ape i ukek, ");
INSERT INTO ssg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Tel masiwi ti sala lawe i hanimu imat waen tenen pate solian ape imuh taen ti laha un ahoiwa, i hani waen ti kumahe pate solian. Tuahe o alolomeni waen tenen pate solian hani tapeinan.” ");
INSERT INTO ssg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Teik kolakol ien ti Jises aile leili Kana ti Galili i kola hutui ka i pate tuah wanen hetekie lalape pohen. Ape tesol kahikahin lato soh tetan. ");
INSERT INTO ssg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Muhin ien Jises ma tel tinan, tesol ukalan ma tesol kahikahin nahih hani tehu taon Kapenaum ape lato to teik ien. ");
INSERT INTO ssg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Lawe ahang teka Ju aile angiain lalap ti nameniai ngain ti lokon Haeu waxi aliake teka tamalaha ti matahaun ti Igip. Laha axai Pasova. Taun ti Pasova i xohiwen ape Jises nahih hani Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mate Ingi Haeu i ningahi hina seilon hahangaini bulmakau, sipsip ma pux ti seilon kahui ti haniai Haeu. I ningahi hetekie teka laha toto pape sau sohi he kolikol moni kahuiai soxi. ");
INSERT INTO ssg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ti Jises paxaiwa, i aile teik wakowak ani tal. I hape xaxaweni lawe manihuh, i towi silahoteni hatesol moni ape i aka suoteni tesol sau. ");
INSERT INTO ssg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","I hone teka laha hahangaini pux, “Kau xaxaweniwa tesol waliko ie ape kum hahapuasa Ingi tel Tamak hanowi tone hangainiai soxi.” ");
INSERT INTO ssg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Lokon ien wanen tesol kahikahin nameni kakain ti he pepai Haeu ti i ukek, “Wawahen tetak hani Ingi Haeu pate xoxoan wanen. Aile ape laha telei nga.” ");
INSERT INTO ssg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ti teka Ju ningahiwa ma hongoa, laha ukek, “Aita sowini hani o ailei tesol waliko ien? Kola hanima amite tenen kolakol lehe amite soh ka Haeu taloma o.” ");
INSERT INTO ssg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jises kak pahoi laha ukek, “Hamananawa Ingi Haeu ape leili ngain toluhu nga hatuhi aliake.” ");
INSERT INTO ssg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ape teka Ju eseini hawane ukek, “Nakon o sokok o waxaini hatuhi aliakean ti leili ngain toluhue? 46 ahang hatuhiai tesol Ingi Haeu ie.” ");
INSERT INTO ssg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tuahe laha kum xeu ka kumahe Jises kakak tetesol ing. I kakak puki i tehu Ingi Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Imuh, taen ti Jises moih aliawa ti matean, tesol kahikahin nameni aliakema teik kakaian ien ape lato soh Jises ma kakain ti leili pepai Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Aope ie, ti i Jerusalem, kilan seilon soh hawane tetan ti laha ningahiwa kolakol lalap ti i aile leili Pasova. ");
INSERT INTO ssg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tuahe Jises tap namil xoxoan ti laha nake i tioi hawane woi lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","I kum hapuasa tel na seilon kaxi hanian nake puki i tioi namili lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tel seilon masiwi ti teka Ju, axan Nikodimus. I tel ti teka Parisi. ");
INSERT INTO ssg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ipong tehu i nahih hani kapi Jises ape i ukek, “Tel masiwi, amite tioi ka Haeu taloma o hanaui seilon. Tap tel seilon pon ailei kolakol lalap ti lawe o ailele, mewenae na i hina pohe Haeu.” ");
INSERT INTO ssg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jises hone i ukek, “Nga kakane o kakain salan, Haeu kum neini wanen seilon, mewenae na i takah ulea.” ");
INSERT INTO ssg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimus ong hawane ape i kamei Jises, “Seilon tenen hoi liai salaimat i takah ulea ukek ia? Seilon tenen i takahawen i kum pon soh alia hani tiai tinan lehe i takah ulea.” ");
INSERT INTO ssg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jises pahoi ukek, “Nga kakane hawane o, tap tel seilon Haeu po neini, mewenae na i takah ulea ti i sohot seilon haun ti pohe Holi Spirit. ");
INSERT INTO ssg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Seilon hanatuale seilon tuahe mewenae Holi Spirit i pon towiahualaha hani nati Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aile ape kum ongaong ti nga hone o ka amuto hatesol takah uleawa. ");
INSERT INTO ssg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Aupol ah hani tesol tesol ti pahan. Seilon hong tangian tuahe i kum tioi tetesol ti aupol ahoma ma tetesol i ahua. Tin masin seilon kum xeu sale Holi Spirit ti i towiahu laha hani nati Haeu.” ");
INSERT INTO ssg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimus kamei Jises, “Tesol waliko ien sohot ukek ia?” ");
INSERT INTO ssg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jises pahoi i ukek, “O tel seilon tuah hanaui teka Ju a o kum tioi tenen nga kakak. ");
INSERT INTO ssg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nga kakane hawane o, nga ma tesol kahikahik amite kakaxi waliko ti amite tioi ma ningahiwen tuahe pahamuto kum is hong waxiai kakaiamite. ");
INSERT INTO ssg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Amuto kum soh nga ti nga kakane amuto waliko ti tehu pon ie ape lehe amuto soh nga ukek ia na nga kakane amuto waliko ti tone Haeu? ");
INSERT INTO ssg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nga tel Nati Seilon, tetel i luama ti tone Haeu, mewenae nga tioi hawane waliko ti i sosohot ien. ");
INSERT INTO ssg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Nga kakane amuto, masin ti he lohong, Moses tulini hana tok weiko samen patul he pata ti awaiai teka Ju, tin masin laha hakea nga tel Nati Seilon hani patul he kros lehe teka laha soh tetak, laha uke tonain kapi Haeu ti tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Ti lalape wawahen ti Haeu hani hatesol seilon, i taloma telawe Natun lehe teka laha soh tetan laha kum selaia ti Haeu lian tehue. Laha uke non tonain tuah kapin ti tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kumahe Haeu taloma tel Natun howiniai seilon ma axialaha kawatan ti lialui woulaha. Haeu taloma i awaiai seilon ti kawatan ti lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Teka namilolaha xoxoan ti tel Natun, Haeu kum axi kawatan hani laha ti lialui woulaha a teka tap namil xoxoan hani i, hoi Haeu namiloiwen ka laha uke kawatan. ");
INSERT INTO ssg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ie se huan ti Haeu axi kawatan hani seilon. Tetel masin xewai alon i tahiawen tehu pon itan ie tuahe seilon pamu laha waheni tilokoan ti xewan nake laha waheni ailei saun lialun. ");
INSERT INTO ssg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Teka seilon ailei saun lialun laha watakai xewan ma laha sia ti xewan nake kumahe pahalaha seilon liai ningahi lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","A teka seilon laha hong usi kakai Haeu, laha waheni xewan ma laha kum namiloi na seilon liai ningahi waliko ti laha ailele nake laha ailele saun tenen Haeu pahan.” ");
INSERT INTO ssg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Muhin ien Jises ma tesol kahikahin nahih salili Jerusalem ape lato lua hani toan ti Judia. Leili taun ti i kapi lato ien, i baptaisi teka seilon. ");
INSERT INTO ssg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Lokon ien Jon Baptis tin i baptaisi seilon he kan Enon xohixohin kapi tehu taon Salim. Tesol ien kilan kan ape teka seilon to nahih hahaniwa kapin lehe i baptaisi laha. ");
INSERT INTO ssg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Puasain ien i sohot imat ti laha hana Jon hani ingi kalabus. ");
INSERT INTO ssg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ngain telao tesol kahikahi Jon kak hapatapat kapi tel Ju liai sale baptaisiai seilon. Laha kak hapatapat ka saun tenen ia salan ti na seilon aile usi lehe Haeu namiloi ukek laha sawisawin. ");
INSERT INTO ssg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ape lato nahih hani kapi Jon Baptis. Lato kakane i ukek, “Tel masiwi, tetel seilon kemuk i kapim sai angiha ti tehu kan Jodan, tetel lawe o to kakaxi, kilan seilon nahih hahaniwa kapin ape i baptaisi laha.” ");
INSERT INTO ssg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon pahoi lato ukek, “Kum nanamiloi. Tap tel i tua aile puase Haeu halik na Haeu kilami i ailean. ");
INSERT INTO ssg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Puki amuto hongoen kakaiak ka nga kumahe Krais, tetel Haeu taloma. Nga tuahe tel apeseniai seilon ti tahiaian. ");
INSERT INTO ssg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Masin ti tel lohi tel seilon i sal, i to hong atetengi na tel seilon i sal hukuma hani kapi tel axoan. Ape i amuke hawane ti i sohot. Tin masin lalape amuam tetak tetelao nake salan i sohotuen, kilan seilon nahih hani kapi Jises hongoi kakaian. ");
INSERT INTO ssg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aile ape seilon namiloi eliel kewak i pamu tuah tetak. ");
INSERT INTO ssg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Tel i luama tone Haeu i Masiwi ti lawe waliko. Seilon ti tehu pon ie, i kakaxi waliko ti tehu pon ie. Aile ape Krais, tel i luama tone Haeu, i pamu tuah ti hatesol seilon. ");
INSERT INTO ssg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","I kakaxi waliko ti i ningahiwen ma hongoen tuahe seilon kum hong soh kakaian. ");
INSERT INTO ssg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tel na i hong soh kakaian i kola haxewa ka kakai Haeu pate salan. ");
INSERT INTO ssg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tetel Haeu taloma, i kakaxi kakai Haeu nake Haeu hani hatapo hawane i Spirit tetan. ");
INSERT INTO ssg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Haeu tel Taman waheni hawane tel Natun, aile ape i hana tel Natun Masiwi ti lawe waliko. ");
INSERT INTO ssg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tel na namilon xoxoan ti tel Nati Haeu, i uke tonain kapin ti tap tahi tapoan. Tuahe tel na i tale tehiton hani tel Nati Haeu, tap wanen i uke tonain ien. I hamalum hahitake lengei Haeu.” ");
INSERT INTO ssg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Teka Parisi hong ka Jises baptaisiwen ma i itini waxainiwen seilon hani kahikahin pamu kilaian ti Jon. ");
INSERT INTO ssg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tuahe salan tetan teka kahikahin baptaisi laha, kumahe Jises. ");
INSERT INTO ssg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ti Jises tioiwa waliko ti teka Parisi hongoen, i lua salili Judia ape i alia hani Galili. ");
INSERT INTO ssg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ti luaian i nonoa texux xux Samaria. ");
INSERT INTO ssg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ape i sota tehu taon axan Sika. I xohixohin kapi teik hepekeun Jekop haniwen tel natun Josep. ");
INSERT INTO ssg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tehu kan wal ti Jekop ien ape ti lape ngain Jises to hahanau papan nake nawan pusoan ti welui nanahian. ");
INSERT INTO ssg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tai kue tel hehin ti Samaria nahima utuhiai kan. Jises kamei i, “Ewi na o axi unumak teik kan?” ");
INSERT INTO ssg_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Mewenae i wanen nake tesol kahikahin nahiwen leili taon kahuiai an. ");
INSERT INTO ssg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tel hehin ong hawane nake teka Ju ma teka Samaria laha kum hukuma hehetekie. Ape i ukek, “Nga hehin ti Samaria. Alahan o tel Ju kamei nga utuhi axiai unumam kan?” ");
INSERT INTO ssg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jises pahoi i, “O kum paxai tioi waliko ti Haeu pahan i hani o ma tin o kum paxai tioi nga. Na o tioila, o katewen ape ala nga axiwen o tenen kan wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tel hehin ukek, “Tel masiwi, o tap ututuh a tehu kan wal se pate walawalan. O kema tenen kan wanen ia? ");
INSERT INTO ssg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jekop tel tamamite ti matahaun hani amite tehu kan wal ie. Imat tesol natun ma tupun manihuh lawe lato unun ie. Nakon o pamu masiwian ti Jekop? Nakon o hina kan tenen pamu soliaian?” ");
INSERT INTO ssg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jises pahoi i ukek, “Tehu kan ie na seilon un i kum ahoi laha lian tehue. Teteka laha unuen, pahalaha un ulea. ");
INSERT INTO ssg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tuahe tehu kan nga hani seilon, i ahoi laha lian tehue nake i sohot hanowi kan tenen tap tahi lil mongaian leilolaha. Tehu kan ien kan wanen, i aile ape seilon to kapi Haeu lian tehue.” ");
INSERT INTO ssg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tel hehin kamea, “Tel masiwi, axima nga kan tenen ien lehe pahak kum is ulea ape nga kum aliama utuhiai kan.” ");
INSERT INTO ssg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jises hone i, “Nahih hakahitama tel axoam.” ");
INSERT INTO ssg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tel hehin pahoi i ukek, “Nga tap axoak.” Ape Jises ukek, “Kakaiam salan, o tap axoam. ");
INSERT INTO ssg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kemuk o sal kewen he tepanim ape tel wawan o toto kapin aope ie, i kumahe axoam.” ");
INSERT INTO ssg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tel hehin ukek, “Tel masiwi, sale kakaiam nga paxai tioi ka o tel kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kaien kaxi hanima nga, alahan amuto teka Ju ukek lotuiai Haeu tesoloe leili Jerusalem? Teka matahaun ti amite lawe laha lotui Haeu ie patul he tehu maunten Gerisim.” ");
INSERT INTO ssg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jises hone i, “Hong sohoma nga, taun i luluainima ape ewi na seilon lotui Haeu tuahe na tesol, kumahe mewenae he tehu maunten ie ma leili Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Amuto teka Samaria amuto lolotui Haeu tuahe amuto kum tioi aluini i. Amite teka Ju amite tioi hawane Haeu tel amite lolotui nake i haxewa hani amite sale awaiai seilon ti kawatan ti lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tehu taun ti i luluainima se liai ape ie ti seilon lotu sameni tel Tamalaha Haeu ti leili atelaha nake Holi Spirit neini lotu ti laha. Saun ti lotu tenen ien Haeu pahan. ");
INSERT INTO ssg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Haeu kumahe tuahe seilon, i Spirit ape teka na laha lotu sameni i, pahan Holi Spirit neini lotu ti laha lehe laha lotui i ti leili atelaha wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tel hehin ukek, “Nga tioi ka Mesaia tel laha axai Krais, i luluainima. Na i tahiama, i kaxi nexi hatapo lawe waliko hani amite.” ");
INSERT INTO ssg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jises hone i, “Se nga tetel. Nga Krais.” ");
INSERT INTO ssg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lokon ien wanen tesol kahikahi Jises aliama ape lato kuaini hawane ka Jises kakak kapi tel hehin. Tuahe tap tel ti lato kamei Jises waliko tenen i pahan ti tel hehin ma nake lahan i kakak kapin. ");
INSERT INTO ssg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tel hehin hana lioiwa tehu peti kan ape i kiliwau alia hani leili taon. I kakane teka seilon ukek, ");
INSERT INTO ssg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nahima paxai tel seilon i kaxi hatakei hani nga lawe waliko ti nga ailewen! I uke Krais, tetel Haeu taloma.” ");
INSERT INTO ssg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kilan seilon leili taon laha ahuta paxai Jises. ");
INSERT INTO ssg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ti tesol waliko ien sosohot, tesol kahikahin kamei eliel Jises, “Tel masiwi, angimua teik.” ");
INSERT INTO ssg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tuahe Jises hone lato, “Nga hina an ti amuto kum tioi.” ");
INSERT INTO ssg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tesol kahikahin he kamekam alia lato, “Nakon saka tel kau axiwen anan?” ");
INSERT INTO ssg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jises ukek, “Ti nga aile waliko ti Haeu pahan, ien se masin ka anak. Ape ti na nga aile hatapo puasain tenen ti Haeu taloma nga ailean, se masin ka anak. ");
INSERT INTO ssg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Amuto ukek hina pangapang tutuen imat ti amuto hutui apuhiniai an ti he kin. Tuahe amuto paxapax aluawa lehe amuto ningahi ka kilan seilon laha apeasawen ti Haeu neini laha ape laha masin an ti i apeasawen ti waxi apuhini. ");
INSERT INTO ssg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","Ti aope ie hina seilon laha neneini seilon ien hani Haeu ti ukei tonain kapin ti tap tahi tapoan. Ape Haeu hani laha kahi puasalaha. Amuto tioi teik kakain i ukek, ‘Hina seilon ti seiniai kin ma hina seilon ti apuhiniai an.’ Se pate salan. Tin masin puase Haeu, hina seilon laha kaxi ahuti kakai Haeu ape hina seilon laha neini seilon hani Haeu. Ti waliko ien sohot, teka ti kaxi ahutiai kakai Haeu ma teka ti neiniai seilon hani kapin laha amuam hetekie. ");
INSERT INTO ssg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nga talo amuto ti neiniai seilon hani Haeu. Teka imat hoi liai laha puas eliel hahawane ape ti aope amuto puas kului puasain ti hoi laha ailewen. ");
INSERT INTO ssg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kilan teka Samaria ti leili tehu taon ien soh hawane ti Jises nake tel hehin kaxi haniwen laha ukek, “Tel seilon ien i kaxi hatakei hani nga lawe waliko ti nga ailewen.” ");
INSERT INTO ssg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ti laha nahih haniwa kapi Jises laha kamei eliel i na i tomu teik kapi laha. Se ape i to ngain huohu. ");
INSERT INTO ssg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kilan teka Samaria liai tin laha soh tetan ti laha hongoa kakaian. ");
INSERT INTO ssg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Laha kakane tel hehin, “Amite soh hawane tetan nake puki amite hong hawanewen kakaian kumahe mewenae nake ti o kaxi hani amite. Ape amite tioi hawanewen ka i se tetel i awai lawe seilon ti kawatan ti lialui woulaha!” ");
INSERT INTO ssg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Muhi ngain huohu ape Jises lua ulea hani Galili. ");
INSERT INTO ssg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ti imat, teka seilon ti puki tonan laha hong watakai kakai Jises. Lokon ien i ukek, “Ti toan liai seilon sameni tel kuluiai kakai Haeu tuahe ti puki tonan wanen laha watakai hongoi kakaian.” ");
INSERT INTO ssg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ape aope ie ti Jises tahia haniwa Galili, pate laha amuke i nake ti laha Jerusalem lokon ti Pasova, laha ningahiwen waliko tenen pate lalap i aile. ");
INSERT INTO ssg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ti Jises Galili, i alia hani tehu taon Kana, tetesol kemuk i kolitini kan hani waen. Xohixohin ien, leili tehu taon Kapenaum, tel akaik wawan pate tinun. I nati tel masiwi hahitake tel masiwi Herod. ");
INSERT INTO ssg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ti tel seilon ien hongoa ka Jises luawen ien ti Judia, i lua kamei eliel Jises haewiai tel natun sikole i mat. ");
INSERT INTO ssg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jises kakane tel seilon, “Alahan pahamuto paxaimu puase poh ti nga ailele lehe amuto soh tetak?” ");
INSERT INTO ssg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tuahe tel seilon ukek, “Tel masiwi, hualima tel natuk uke i mat.” ");
INSERT INTO ssg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ape Jises hone i, “Nahih aliawa, tel natum i ewi.” Tel seilon soh kakai Jises ape i nahih alia hani tonan. ");
INSERT INTO ssg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Teka unaui tel seilon nahih upia hahongo i ukek, “Tel natum ape i ewiwen!” ");
INSERT INTO ssg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ti i kameiwa lato lokon wanen tel natun ewi, lato ukek, “Tihah alohah sai 1 kilok, lul ti tel natum i tapo hahutuia.” ");
INSERT INTO ssg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ape tel tame tel akaik paxai tioi ka i sohot hawane lokon Jises kaakane i ka tel natun i ewi. Aile ape tel seilon ien ma hatesol seilon leili ingan laha soh hawane ti Jises. ");
INSERT INTO ssg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ie ape kewen he huohu puase poh i aile leili Galili muhin ti i luama Judia. ");
INSERT INTO ssg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Muhin ien Jises nahih hani Jerusalem ti tehu angiain lalap ti teka Ju. ");
INSERT INTO ssg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Leili Jerusalem tehu kanipet axan Betesda ti kakai Arameik, tepanim ing tenen saxawaxawan tu kakalini. I xohixohin kapi tewau kahip ti taon, axan Sipsip. ");
INSERT INTO ssg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kilan wanen seilon tinun lawe laha engeeng tesol ien. Leilolaha teka pulaxa, teka laha nahih tawen ma teka tupualaha maten. ");
INSERT INTO ssg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Hina taun tel engel ti Haeu mos hapixe tehu kan ape na tel tinun i soh hani he tehu kan ti i pixepix tutuen, tetel ien i ewi. ");
INSERT INTO ssg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tel ti teka seilon ien i tinu kuewen leili ahang 38. ");
INSERT INTO ssg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ti Jises paxaiwa tel seilon engeeng ien, i paxai tioi ka i tinu kuewen. Ape Jises kamei i, “Paham o ewi?” ");
INSERT INTO ssg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tel tinun wix pahoi i, “Tel masiwi, nga kum nahih uke. Tap seilon hualiak hani he tehu kan ti i pixepix tutuen. Nga to totohongi tuahe seilon liai lawe imat tetak.” ");
INSERT INTO ssg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jises hone i, “Xahatawa, lumiwa enepam ape tau nahiwa.” ");
INSERT INTO ssg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Taen ien wanen tel seilon ewi. I lumi kau enepan ape i hutui i nahih. Tetelao ien ngain Sabat ti Jises haewia tel seilon ien. ");
INSERT INTO ssg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Aile ape teka masiwi ti teka Ju kumahe laha amuam. Ape laha hone tel seilon ukek, “Tetelao se Sabat, hahalin na o kakau enepam telao ngain Sabat.” ");
INSERT INTO ssg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tuahe i kak pahoi laha ukek, “Tetel seilon i aile haewia nga, i hone nga lumi kaui enepak ape tau nahiwa.” ");
INSERT INTO ssg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Laha kamei i, “Aita tetel seilon i haewia o ape hone o lumi kaui enepam ape tau nahiwa?” ");
INSERT INTO ssg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tuahe tel seilon kum tioi. I tai tioi Jises tetel nake lokon ti i ewiwa Jises hoi i nanahih leili lawalawai seilon. ");
INSERT INTO ssg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Muhin ien, Jises apatuini tel seilon ien leili Ingi Haeu ape Jises hone i, “O ape ewi tuahe kum aile ulelea saun lialun uke kawatan pamu lapan tunahi o.” ");
INSERT INTO ssg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ti tel seilon nahih saliliwa Jises, i nahih kakane teka masiwi ti teka Ju ka Jises tetel aile haewia i. ");
INSERT INTO ssg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ape teka masiwi ti teka Ju aile saun tenen lialun hani Jises nake i aile haewia seilon telao ngain Sabat. ");
INSERT INTO ssg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tuahe Jises ukek, “Tel Tamak Haeu puas huali seilon lawe ngain, aile ape tin nga aile usi.” ");
INSERT INTO ssg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ti teka masiwi hongoa, pahalaha is eliel hawane teleiai Jises, kumahe mewenae nake i xaputi nauna ti sale Sabat tuahe hetekie ti i ukek Haeu se Taman wanen. Nake ti tenen ien lato ukek Jises namiloi ka i Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jises hone teka masiwi ti teka Ju ukek, “Nga kakane hawane amuto, nga Nati tel Tamak Haeu, puki nga kum pon ailei tenen na waliko halik na nga ningahimu tel Tamak aile. Lawe waliko tel Tamak aile, nga tel Natun tin nga aile. ");
INSERT INTO ssg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","I sohot ukek nake tel Tamak waheni hawane nga tel Natun ma i kola hani nga waliko ti i aile. Imuh tin i hani nga puasake waliko tenen pamu lapan. Ape amuto ongaini hawane waliko ti na nga aile. ");
INSERT INTO ssg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Masin ti tel Tamak Haeu hamoiha seilon maten ape axi laha tonain ti tap tahi tapoan kapin, tin masin nga tel Natun aile hani teka ti pahak. ");
INSERT INTO ssg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tel Tamak Haeu hani lioi nga tel Natun paxai kolongeniai woi lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","I aile ukek lehe lawe seilon hong ma sameni nga tel Natun masin ti laha hong ma sameni tel Tamak Haeu. Tel na i watakai nga tel Natun, liai hoi i watakai tel Tamak Haeu, tetel i taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nga kakane hawane amuto, tel na i hong usi kakaiak ma namilon xoxoan ti Haeu tetel i taloma nga, tel seilon ien liai hoi i to hutuiwen kapi Haeu. Haeu kum axi i kawatan ti lialui woun. Kemuk ti i tai hong usi kakaiak, woun haxau i ti Haeu ape aope ie i pakata xoxox kapi Haeu lian tehue. ");
INSERT INTO ssg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Nga kakane hawane amuto, tehu taun ti i luluainima se liai ape ie ti teka woulaha haxau laha ti Haeu, hong kakaiak tuahe mewenae teteka laha hong tamani laha to kapi Haeu lian tehue. ");
INSERT INTO ssg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Pon i sohot ukek ien nake masin ti Haeu i hina poh ti axiai seilon tonain kapin ti tap tahi tapoan, i hani nga tel Natun poh tenen ien. ");
INSERT INTO ssg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ape i haniwen nga paxai kolongeniai woi teka seilon nake nga tel Nati Seilon, nga se Krais. ");
INSERT INTO ssg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Kum ongaong waliko ti nga kakak nake taun i luluainima ti teka maten hong nga tiloi laha. ");
INSERT INTO ssg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ape laha xahat alia he amal. Lawe seilon laha ailewen saun tenen Haeu pahan, laha uke tonain kapin ti tap tahi tapoan ape teka laha ailewen saun lialun, laha uke kahulaha ti lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nga kum tua aile waliko ti puki namilok. Nga paxai kolongeni woi seilon hanowi ti tel Tamak Haeu kaakane nga. Ti nga paxai kolongeni woi seilon, nga aile usi namili Haeu, tetel i taloma nga, kumahe puki namilok. Aile ape kolongenian tetak sawisawin wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jises kakak tutuen ukek, “Na masin mewenae nga kaxi aliliake nga, seilon kum soh kakaiak. ");
INSERT INTO ssg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tuahe tin tel seilon liai, tel Tamak Haeu i kakaxi nga ape nga tioi ka waliko ti i kakak nga se salan wanen. ");
INSERT INTO ssg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Puki amuto taloen seilon hongoi kakai Jon Baptis ape waliko ti i kakak nga se salan. ");
INSERT INTO ssg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Tuahe kumahe nga upia seilon lehe laha kak hawane ka nga tel Nati Haeu. Nga hanamena amuto kakai Jon lehe amuto soh tetak ape Haeu awai amuto ti kawatan ti lialui woumuto. ");
INSERT INTO ssg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Kakai Jon masin xewan i haxewa hani amuto waliko tenen salan ti i kakak nga ape hina taun ti amuto amuke kakaian. ");
INSERT INTO ssg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tuahe pupuasak ti Haeu hani nga aile hatapoan, ien pamu i haxewa ka tel Tamak Haeu taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Puki i haxewa ka nga se tel Natun kalak amuto tai hongohong kinaxon ma tai niningahi kawan. ");
INSERT INTO ssg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tuahe kakai Haeu amuto kum uke hanowi waliko tenen tone atemuto wanen nake amuto kum hong soh nga, tetel Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Lawe ngain amuto ridai upia eliliel salangawe kakain leili pepai Haeu nake amuto sokok i hani amuto tonain kapi Haeu ti tap tahi tapoan. Tuahe amuto sel hawane nake leili pepai Haeu i kakaxi nga tel Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ape amuto kum soh tetak, tetel i hani seilon tonain kapi Haeu ti tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Kumahe nga kak ukek ien lehe seilon sameni nga. ");
INSERT INTO ssg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tuahe nga tioi amuto. Tap wawahen ti Haeu leilomuto. ");
INSERT INTO ssg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tel Tamak Haeu taloma nga hahitake axan a amuto kum hong kakaiak. Tuahe na seilon kakak puki hahitake axan amuto hong usi kakaian. ");
INSERT INTO ssg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Amuto aile ukek nake amuto he sasamen alia amuto. A amuto kum namiloi waxi lehe telawe Haeu namiloi ukek amuto seilon tuah. ");
INSERT INTO ssg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Tuahe kum namiloi ukekek ka nga tetel suluiamuto hani tel Tamak Haeu. Moses tel suluiamuto, nauna tetan ti amuto monomon ka i huali amuto. ");
INSERT INTO ssg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Na amuto hong sohola kakai Moses, tin ala amuto hong soh kakaiak nake waliko ti Moses tai kakaxi, se i kakak nga. ");
INSERT INTO ssg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tuahe amuto kum hong soh kakain ien. Ape lehe amuto hong soh ukek ia kakaiak?” ");
INSERT INTO ssg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Muhin ien Jises ma tesol kahikahin lang kolia hani liai tepaun ti kanitax Galili. Tesol kanitax ien axan liai tenen Taibirias. ");
INSERT INTO ssg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kilan wanen seilon kakahiti Jises nake laha ningahiwen i haewia seilon ti kui pohen. ");
INSERT INTO ssg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jises ma tesol kahikahin nahih hani patul he tehu maunten kokol ape lato to hetekie. ");
INSERT INTO ssg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pasova, ngain lalap ti teka Ju ape i xohiwen. ");
INSERT INTO ssg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jises paxawa, i ningahi teka kilai seilon nahih hahanima kapin ape i kamei tel kahikahin Pilip, “Kako kahui an ia lehe i pon waxeniai tesol mongohe seilon ie?” ");
INSERT INTO ssg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","I kak ukek ien ti tohongi paxaiai Pilip. Hoi i tioiwen waliko tenen lehe i aile. ");
INSERT INTO ssg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip hone pahoi, “Mongohualaha! Kahi tel seilon na i puas ti pangapang tepanim toluhu i kum pon tutuen kahuiai an lehe lawe seilon pon ukei tuahe na teik.” ");
INSERT INTO ssg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andru tel kahikahin liai, tetel ukale Saimon Pita, i ukek, ");
INSERT INTO ssg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Tel akaik wawan ie hina tepanim bret ma huok xixi. Tuahe i kum pon wanen waxeniai lawalawai seilon!” ");
INSERT INTO ssg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jises hone tesol kahikahin, “Hatonawa teka seilon.” Hina pahoah ien i tapai ti hatesol seilon to hani itan. Mongohe seilon i akulai 5,000. ");
INSERT INTO ssg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jises waxi tesol bret ape i kak kemulik hani Haeu. Muhin i sei hani teka seilon. Tin masin i sei huok xixi atengi tataen an ahoi laha hatesol. ");
INSERT INTO ssg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tataen an ahoiwa lawe seilon, Jises hone tesol kahikahin, “Waxi apuhini hatapoa moxe an lehe i kum tua xoina.” ");
INSERT INTO ssg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tesol kahikahin aile usi ape moxe teik kokole an ien, lato lohi apuhini aliake huopanim huohu po. ");
INSERT INTO ssg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ti teka seilon ningahiwa waliko tenen lalap Jises aile ti kui pohen, laha he kakak, “I liai tel kuluiai kakai Haeu, tetel kako teka Ju mon atetengi.” ");
INSERT INTO ssg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jises paxai tioi ka uke laha lungei i sohot tel masiwi ti nahikei xuxulaha. Aile ape i nahih hani patul he maunten ti tesol mewenae i. ");
INSERT INTO ssg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Alohah tehu ien tesol kahikahi Jises nahih hani kanitax Galili. ");
INSERT INTO ssg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Muhi lolohan Jises tai tahia hani kapi lato ape lato ku hani he tea koap. Lato lang hani tehu taon Kapenaum liai tepaun ti kanitax Galili. ");
INSERT INTO ssg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tai kue aupol ah kui ape i hatano laman. ");
INSERT INTO ssg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tataen tesol kahikahin xoxei haxaua tea koap xawaian sai masin tepanim kilomita, lato ningahi tel seilon nanahih patul he kanitax. I to nahih xohi hahaniwa kapi tea koap ape lato mamata. ");
INSERT INTO ssg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tuahe i ukek, “Se nga Jises! Kum maamata!” ");
INSERT INTO ssg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ape lato amuam hakuhi i hani he koap. Tataen ien wanen tea koap takana hani tesol ti pahalato. ");
INSERT INTO ssg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ngain liai telao teka kilai seilon laha apupuha tetesol pape kanitax ti tesol kahikahi Jises ahuta sasaliliwa. Lato hapuasa teawe koap ien. Teka seilon tioi ka Jises tai kuoxi lato ape laha to atetengi i tetesol ien. ");
INSERT INTO ssg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lokon ien hina koap ti tehu taon Taibirias tahia hani kapi laha, tetesol ti Jises axiaxi ani teka kilai seilon muhin ti i kak kemulik haniwa Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ti laha paxai tioiwa ka Jises tin tap, laha ku hani he tesol koap ien ape laha lang hani Kapenaum pax upiaian. ");
INSERT INTO ssg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ti laha tunahiwa i liai tepaun ti kanitax, laha kamei i, “Tel masiwi, saka o non ukek ia hanima ie?” ");
INSERT INTO ssg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tuahe Jises kak ukek, “Nga kakane hawane amuto, amuto upiup nga kumahe nake amuto xeu ti hui waliko ti nga aile ti kui pohek tuahe nake nga axi ahoi hawane amuto an. ");
INSERT INTO ssg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Amuto kum puas eliliel upiai an tetenen aneso i tapo. Puas upia elieliwa an tetenen i kum tapo. Haelieliwa ukei tonain kapi Haeu ti tap tahi tapoan ti nga tel Nati Seilon pon haniamuto. Tel Tamak Haeu hani nga ailei teik puasain ien.” ");
INSERT INTO ssg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Teka seilon kamei Jises, “Haeu pahan amite aile waliko la?” ");
INSERT INTO ssg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jises kak pahoi laha, “Haeu pahan namilomuto xoxoa tetak, tetel i taloma.” ");
INSERT INTO ssg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Laha ukek, “Aile kola hanima amite kolakol tenen lalap lehe amite soh o. Kaie o kola hani amite waliko la? ");
INSERT INTO ssg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Teka matahaun ti kako, Haeu kola hani laha tenen kolakol ti i hapuasa Moses hani laha ani mana ti he lohong. I sohot poponowi usima kakai Haeu ti i kakawen, ‘Moses hani laha ani bret ti i ahuma tone Haeu.’” ");
INSERT INTO ssg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jises hone ulei laha, “Nga kakane hawane amuto, kumahe Moses tetel i hani laha bret ti tone Haeu. Se hahaniai tel Tamak Haeu. I se tetel axiamuto an wanen. ");
INSERT INTO ssg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","A an wanen ti Haeu se tetel i tahia hanima tehu pon ie ti axiai seilon tonain kapi Haeu ti tap tahi tapoan.” ");
INSERT INTO ssg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Teka seilon kak ukek, “Tel masiwi, lawe ngain axima amite tenen an wanen ien.” ");
INSERT INTO ssg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jises kak pahoi laha, “Nga se an wanen ti haniai seilon tonain kapi Haeu ti tap tahi tapoan. Tap tel i hitol ulea ma pahan is ulea i un na namilon xoxoan tetak. ");
INSERT INTO ssg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tuahe amuto tap namil xoxoan tetak kalak amuto ningahiwen waliko tenen lalap nga ailewen. ");
INSERT INTO ssg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Lawe seilon tel Tamak Haeu haniwen nga ape laha sohot kahikahik, tap nga tale tehitok hani laha. ");
INSERT INTO ssg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kumahe nga tahiama ti tone Haeu ailei waliko ti puki namilok. Haeu taloma nga ailei waliko ti pahan nga ailewa. ");
INSERT INTO ssg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Teka seilon ti i haniwen nga, teteka laha sohot kahikahik, Haeu pahan nga ngahati aluiniwa laha hatesol nake i pahan nga xahateniwa laha ti matealaha ngain tetehu ti hinitiai lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ie namili tel Tamak Haeu ka lawe seilon paxai tioiwa ka nga se tel Natun ma tin laha soh hawanewa tetak lehe laha uke tonain kapin ti tap tahi tapoan ape nga hamoiha aliake laha ti ngain tetehu ti hinitiai lawe seilon.” ");
INSERT INTO ssg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Teka seilon hong lengeke ma kak hahakila nake Jises ukek se i an wanen ti tone Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Laha he kakak alia puki laha, “I tuahe tel nati Josep! Kako tioi taman ma tinan. Ape lahan i ukek i luama ti tone Haeu?” ");
INSERT INTO ssg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jises hone lato, “Kum kak mumum hahakila! ");
INSERT INTO ssg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tap tel i tua sohot kahikahik halik na tel Tamak Haeu, tetel i taloma nga, i towiahu namilon ti soh tetak. Na i sohot ukek ien, nga xahateni aliake i ngain tehu ti hinitiai lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Masin ti teka kuluiai kakai Haeu taiwen, ‘Haeu i hanau teka seilon.’ Ape teka laha hong usi kakai Haeu, laha sohot kahikahik. ");
INSERT INTO ssg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tuahe kumahe nga ukek ka tel na seilon ningahiwen tel Tamak Haeu, mewenae nga, tetel ahuma ti Haeu, ningahiwen i. ");
INSERT INTO ssg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Nga kakane hawane amuto, tel na namilon xoxoan tetak, hoi liai i to kapi Haeu lian tehue. ");
INSERT INTO ssg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","A salan, nga se an wanen ti axiai seilon tonain ien. ");
INSERT INTO ssg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Teka matahaun ti amuto laha aniani mana ti he lohong tin laha mat. ");
INSERT INTO ssg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tuahe an wanen ti tone Haeu, tel na i ani i kum mat. ");
INSERT INTO ssg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nga tetel an wanen ti tone Haeu se ape kapimuto. Hatesol teteka laha ani, laha to kapi Haeu lian tehue. Tenen an wanen ien se tupuak nga hani ti nga mat lehe seilon uke tonain kapi Haeu ti tap tahi tapoan.” ");
INSERT INTO ssg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ti teka seilon hongoa, laha kak he lungelung alia puki laha ape laha he kamekam, “I hani kako ani tupuan ukek ia?” ");
INSERT INTO ssg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tuahe Jises ukek, “Nga kakane hawane amuto, amuto kum uke tonain kapi Haeu ti tap tahi tapoan, halik na amuto ani tupuak ma unumi kakauk tel Nati Seilon. ");
INSERT INTO ssg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tuahe na amuto ani tupuak ma unumi kakauk, hoi liai amuto to kapi Haeu lian tehue ape nga xahateni aliake amuto tehu ngain ti hinitiai lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pake tupuak se an wanen ma kakauk se unum wanen. ");
INSERT INTO ssg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Na amuto ani tupuak ma unumi kakauk, amuto se kahikahik wanen ape nga lawe kapimuto lian tehue. ");
INSERT INTO ssg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Masin ti tel Tamak Haeu taloma nga, i aile lehe nga moih lian tehue, tin masin na amuto to hawane kahikahik wanen, nga aile lehe amuto moih lian tehue. ");
INSERT INTO ssg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nga se an wanen ti tone Haeu. Teka matahaun ti amuto laha ani mana, tin laha mat. Tuahe tel na i ani an wanen ti tone Haeu i kum mat.” ");
INSERT INTO ssg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jises hahanau teka seilon leili tehu synagog ti tehu taon Kapenaum ti i kakaxi tesol kakain ien. ");
INSERT INTO ssg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tesol kahikahi Jises hongoa ape kilan ti lato ukek, “Kakaiam pate ailan ti amite ukean ma usian.” ");
INSERT INTO ssg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jises paxai tioi ka tesol kahikahin kak mumum ape i kamea, “Nakon teik kakaiak pate i hahataxina halialu namilomuto? ");
INSERT INTO ssg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ape amuto namiloi ukek ia na amuto ningahi nga tel Nati Seilon nga alia hani tone Haeu? ");
INSERT INTO ssg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Holi Spirit ti Haeu i tetel axiai seilon tonain kapi Haeu ti tap tahi tapoan. Ti puki kui seilon i kum pon ailean. Kakain ti nga kakane amuto i ahuma ti Holi Spirit ape i axi seilon tonain kapi Haeu ti tap tahi tapoan na laha soh tetak. ");
INSERT INTO ssg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tuahe teka ti amuto laha kum hong soh nga.” Jises kak ukek ien nake hoi i tioiwen teteka laha soh tetan. Tin i tioi seilon tetel imuh i hangaini i hani mini teka seilon teleian. ");
INSERT INTO ssg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ape Jises ukek, “Teka ti amuto kum soh tetak nake masin ti nga kakanewen amuto, tap tel i tua sohot kahikahik halik na tel Tamak Haeu towiahu namilon ti soh tetak.” ");
INSERT INTO ssg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hutui taen ien, kilan kahikahi Jises laha tale tehitolaha tetan ape laha kum kahiti i. ");
INSERT INTO ssg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jises kamei tesol huopanim huhua kahikahin i ukek, “A amuto? Kaie amuto kum nahih salili nga?” ");
INSERT INTO ssg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita kak pahoi, “Tel masiwi, lehe amite kahiti ulea aita? O tel hanauamite kakai Haeu ti ukei tonain kapin ti tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Amite hong soh kakaiam ma amite tioi ka o tel seilon sawisawin wanen ti Haeu.” ");
INSERT INTO ssg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jises kakane tesol huopanim huhua kahikahin, “Nga kilami amuto aposel tetak tuahe tel ti leilomuto, Satan kapiti ma hapuasa i.” ");
INSERT INTO ssg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jises kakak Judas, nati Saimon Iskariot. Imuh i hangaini Jises hani teka seilon ti teleian, kalak i tel ti tesol huopanim huhua aposel. ");
INSERT INTO ssg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Muhin ien Jises hanau tatale teka seilon leili Galili. Kumahe pahan i nahih hani Judia nake teka Ju ien hina namil ti teleian. ");
INSERT INTO ssg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Taun ti angiain lalap ti teka Ju atai ingalaha houha i xohiwen. Laha aile ukek ien ti nameniai lokon teka matahaun ti laha he lohong. ");
INSERT INTO ssg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ape tesol ukale Jises kak soxeni i, “Nahih saliliwa ie haniwa Jerusalem lehe teka kahikahim paxai waliko tenen lalap na o aile. ");
INSERT INTO ssg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Na paham lawe seilon tioi o, kum mumuneni puasam. Na o pon ailei waliko tenen lalap ti kui pohem, aile kolawa lehe lawe seilon sameni o.” ");
INSERT INTO ssg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Lato kak ukek ien nake lato kum soh tetan kalak lato se ukalan wanen. ");
INSERT INTO ssg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jises hone lato, “Taun ti lawe seilon tioi nga i tai meima. Ti amuto, lawe taun se solian ti ailei waliko. ");
INSERT INTO ssg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tap huan ti seilon watakai amuto tuahe laha watakai nga nake nga kaxi hatakei lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mewenae amuto nahih haniwa tehu angiain lalap ien. Nga tai apeas nake taun tetak i tai meima.” ");
INSERT INTO ssg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jises hone lato kewak ien ape i hamalum Galili. ");
INSERT INTO ssg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Muhi tesol ukalan nahih haniwa Jerusalem, Jises tin i nahih tuahe kumahe i nahih tatake nake kumahe pahan teka seilon ila tioi i. ");
INSERT INTO ssg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Lokon ien leili Jerusalem teka masiwi ti teka Ju to pax upiup Jises. Laha he kamekam, “Jises tel hatanoi wasol ia?” ");
INSERT INTO ssg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kilan seilon laha kak hahakokol sale Jises wasolalaha. Teka laha ukek, “I se seilon solian.” Teka liai ukek, “I neini puluti teka seilon.” ");
INSERT INTO ssg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tuahe tap tel i kakak sale Jises ti taxingi lawe seilon nake laha mamata teka masiwi ti teka Ju. ");
INSERT INTO ssg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Patalal ti taun ti nameniai lokon teka matahaun ti teka Ju he lohong, Jises nahih hani Ingi Haeu ape i hutui hanau teka seilon. ");
INSERT INTO ssg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Teka masiwi ti teka Ju kuaini hawane ape laha ukek, “Tel seilon ie i tai sukul, saka anesoan ti kakai Haeu i ukema ia?” ");
INSERT INTO ssg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jises ukek, “Tetenen ti nga hahanau amuto kumahe puki namilok, i ahuma ti Haeu tetel i taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tel na i aile usiusi namili Haeu i tioi ka waliko ti nga hahanau seilon i ahuma ti Haeu kumahe puki namilok. ");
INSERT INTO ssg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tel na i kakak puki hahitake axan i aile ukek ien lehe seilon sameni i. Tuahe tel i puas eliliel lehe seilon sameni tetel i taloma i, kakaian salan ape i malang pulutiai seilon. ");
INSERT INTO ssg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses hani amuto nauna ti Haeu, kewak? Tuahe tap tel ti amuto puas usiusi. Ape kalahai amuto tohongi teleiak?” ");
INSERT INTO ssg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kilan wanen seilon kak pahoi Jises, “Spirit lialun kapiti halialuen o. Aita pahan teleiam?” ");
INSERT INTO ssg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jises kak ukek, “Nga aile haewiawen tel seilon telao ngain Sabat ape amuto hatesol ong lengeke. ");
INSERT INTO ssg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tuahe puki amuto pupuas telao ngain Sabat ti amuto aile teik kikilam ti kotiai uli walikoi natumuto wawan usiai nauna ti Moses. Tenen saun ien hoi imat ti Moses, lokon ti Abraham tel matahaun ti kako. ");
INSERT INTO ssg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Na tenen saun ien i onoteni telao ngain Sabat, amuto aile haseleni lehe amuto kum xaputi nauna ti Moses. Ape lahan amuto lengeini nga ti nga haewia tel seilon ti telao ngain Sabat? ");
INSERT INTO ssg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kum paxai kokolongeni saun ti seilon ti puki namilomuto, tuahe ti namili Haeu.” ");
INSERT INTO ssg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hina seilon leili Jerusalem laha ukek, “Nakon i seilon tetel teka masiwi ti kako pahalaha teleian? ");
INSERT INTO ssg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Paxaiwa! I leili teka seilon, i hanau ulelea laha tuahe tap tel hakume i. Sohin laha paxai tioi ka i Krais. ");
INSERT INTO ssg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Saka i sohot ukek ia nake amite tioi ka i ti Nasaret tuahe amite kum tioi tetesol Krais ahuma.” ");
INSERT INTO ssg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aile ape ti Jises hahanau tutuen teka seilon mate Ingi Haeu, i kak eliel hani laha, “Amuto sokok amuto tioi nga ma tetesol ti nga ahuma. Tuahe kumahe nga luama ti puki namilok, tel liai taloma nga. I se tel Haeu salan tuahe amuto kum tioi i. ");
INSERT INTO ssg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","A nga tioi hawane i nake nga nakuama tetan ape i taloma nga.” ");
INSERT INTO ssg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ti teka masiwi ti teka Ju hongoa, laha tohongi xotiai Jises tuahe tap tel aka pohiwen i nake i tai meiwa taun tetan. ");
INSERT INTO ssg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tuahe kilan seilon soh tetan ape laha ukek, “I aile hahakila waliko tenen lalap ti kui pohen. I se Krais nake soliai puasan masin ti Krais.” ");
INSERT INTO ssg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Teka Parisi hong ka kilai seilon kak wixiwix sale puase Jises ape lato ma tesol masiwi tuah ti hukuminiai Haeu ma seilon, lato talo tesol peteniai Ingi Haeu ti xotiai Jises. ");
INSERT INTO ssg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jises kak ulea ukek, “Nga kapimuto hatesol teik taun kukunun ape nga alia hani kapi tetel i taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ape taen ien amuto pax upia nga ti huhual tuahe amuto kum pon tunahiak. Tin amuto kum lua uke hani tetesol ti nga ien.” ");
INSERT INTO ssg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Teka masiwi ti teka Ju he kakak alia laha, “Kaie i nahih kelak lehe kako kum pon tunahian? Nakon i nanamiloi na i nahih salili xuxukako hani kapi teka akikikako Ju kakaialaha Grik? Sohin uke pahan i hanau teka Grik. ");
INSERT INTO ssg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Salangawe kakaian ukek ia ti i kakak ka kako pax upia i tuahe kako kum pon tunahian? A i ukek ia ti i kakak ka kako kum lua uke hani tetesol ti na i lua to?” ");
INSERT INTO ssg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ti ape tehu ngain tapeinan ti taun ti nameniai lokon teka matahaun ti teka Ju he lohong. Ngain tehu ien Jises tu ape i kak eliel ukek, “Tel na pahan is i un, soh hawanewa tetak ape nga hani i unum wanen. ");
INSERT INTO ssg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tel na i soh tetak, i un lian tehue. Masin ti pepai Haeu kakaxi, ‘Tenen unum wanen i masin kan tenen i lilil tap mongaian ti leili tel na i soh.’” ");
INSERT INTO ssg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kakai Jises ti i kakak ien i kakaxi sale Holi Spirit, tetel Haeu hani teka laha soh ti Jises. Hanima tataen, Haeu tai axi Holi Spirit hani teka kahikahi Jises nake Haeu tai kola hatakei hatesol pohe Jises. ");
INSERT INTO ssg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ti teka kilai seilon hongoa kakai Jises, teka ti laha ukek, “Tel seilon ie, salan wanen i tetel kuluiai kakai Haeu ti kako teka Ju to monomon.” ");
INSERT INTO ssg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Teka liai ukek, “I se Krais.” Tuahe teka liai ulea ukek, “Tap wanen nake i se seilon ti Galili. ");
INSERT INTO ssg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","A kakain ti leili pepai Haeu i ukek Krais, tel ti kaha to monomon, i nakuama ti tel masiwi David ma i takah Betlehem, tetewau toan ti kemuk David toto.” ");
INSERT INTO ssg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aile ape kakaialaha hatesol sale Jises i hil. ");
INSERT INTO ssg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Teka pahalaha laha xoti Jises tuahe tap tel aka pohiwen i. ");
INSERT INTO ssg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ti teka peteniai Ingi Haeu nahih alia haniwa kapi teka masiwi ti hukuminiai Haeu ma seilon ma teka Parisi, tesol masiwi ien kamei lato ukek, “Alahan amuto kum xoti Jises ape hakahita hanima kapimite?” ");
INSERT INTO ssg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Lato pahoi ukek, “Tel seilon ien kak hanowi ka i tel masiwi tapein. Tap tel kaakawen masin tel seilon ien!” ");
INSERT INTO ssg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Teka Parisi kak ukek, “Kaie i puluti hetekiewen amuto? ");
INSERT INTO ssg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Saka tap tel ti kako teka Parisi ma na teka masiwi laha soh tetan. ");
INSERT INTO ssg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mewenae teka seilon ie tap namilolaha laha soh tetan nake laha kum tioi aluini kakai Haeu ape Haeu hani laha kaui kawatan.” ");
INSERT INTO ssg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimus, tel ti teka Parisi i paxaiwen Jises ti imat, i hone teka liai, ");
INSERT INTO ssg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nauna ti Moses halini kako tieniai tel seilon na kako tai hong ma upia mataini waliko ti i ailewen.” ");
INSERT INTO ssg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ape lato pahoi i, “Sale kakaiam masin ka o tin ti Galili ma o saupa ti Jises. Nihehi paxaiwa pepai Haeu lehe o tioi ka tap tel kuluiai kakai Haeu i ahuma ti Galili.” ");
INSERT INTO ssg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Muhin ien hatesol seilon nahih alia hani tonalaha. ");
INSERT INTO ssg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ape Jises nahih hani Maunt Oliv. ");
INSERT INTO ssg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Uli letu ti ngain liai telao Jises nahih alia hani Ingi Haeu. Kilan seilon apuha kalini i. Jises to hani itan ape i hutui hanau laha. ");
INSERT INTO ssg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Lokon ien tesol hanaui nauna ti Moses ma tesol Parisi ati tel hehin lato tunahi i eng akakati tel wawan kumahe axoan. Ape lato hatuhi i mate teka kilai seilon ien. ");
INSERT INTO ssg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Lato kakane Jises, “Tel masiwi, tel hehin ie amite atima nake i eng akakati tel wawan kumahe axoan. ");
INSERT INTO ssg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nauna ti Moses kak eliliel ka hehin tenen masin ie mewenae ti hokai teleiwa ani pot. Kaie o kak ukek ia?” ");
INSERT INTO ssg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Lato kamei Jises tenen ien nake pahalato i kakawa waliko tenen i pon na lato sului i. Tuahe Jises tuole ape i tai kakain he pekeun ani ngaxe minan. ");
INSERT INTO ssg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ti lato to kakamei Jises, i tu hokahale ape i kakane laha hatesol, “Tel ti amuto na i tai aile saun lialun, kewa i imat ti hokaiai tel hehin pot.” ");
INSERT INTO ssg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","I tuole ape i tai ulea. ");
INSERT INTO ssg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ti laha hongoa kakai Jises, laha nahih salili i uke tel tel, nahiai imat teteka salaimat. Mewenae Jises tutuen kapi tel hehin. ");
INSERT INTO ssg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jises tu hokahale ape i kamei tel hehin, “Teka suluiam ia? Nakon teka lehe laha aile halialu o, laha ox nahiwen?” ");
INSERT INTO ssg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tel hehin kakane Jises, “Tel masiwi, tap tel tutuen ie.” Ape Jises ukek, “Ien, nga tin nga kum aile hani o na tenen. Ewi na o nahih tuahe kum ailele ulei saun lialun.” ");
INSERT INTO ssg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jises kakane ulei teka kilai seilon, “Nga masin xewai alon. Nga kola aweisal tenen sawisawin hani seilon. Tel na i sohot kahikahik, tap i po to ti tilokoan ailei saun lialun nake nga tel neinian lehe i to kapi Haeu lian tehue.” ");
INSERT INTO ssg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Teka Parisi hone Jises, “Mewenae o kakak alia o, tap tel liai ukek ka kakaiam salan.” ");
INSERT INTO ssg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jises kak pahoi lato ukek, “Kalak mewenae nga kakak alia nga, kakaiak se salan nake nga tioi tetesol ti nga ahuma ma tetesol ti nga alia. Tuahe amuto kum tioi tenen ien. ");
INSERT INTO ssg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Amuto paxai kolongeni woi seilon ti puki namilomuto tuahe nga aile usiusi namili Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ti na nga paxai kolongeni woi seilon, kolongenian tetak se sawisawin nake kumahe nga ailele ti puki namilok. Tel Tamak Haeu tetel i taloma nga, i lawe kapik. ");
INSERT INTO ssg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Leili pepai nauna ti puki ti amuto i ukek ka na kakai hua seilon tenenawe, tenen kakain ien salan. ");
INSERT INTO ssg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Puki nga kola ka kakaiak salan hetekie tel Tamak tin i kola ka kakaiak salan.” ");
INSERT INTO ssg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Lato kamei Jises, “Tel tamam ia?” Jises kak pahoi lato, “Amuto kum tioi nga ma tel Tamak. Na amuto tioila nga, ala tin amuto tioi tel Tamak.” ");
INSERT INTO ssg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jises kakak ien ti i hahanau teka seilon mate Ingi Haeu, xohixohin tesol hanai moni ti ailei puase Haeu. Laha tai xoti i nake taun tetan i tai meiwa. ");
INSERT INTO ssg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jises hone ulei teka seilon, “Kum kue ape nga salili tamusuke amuto. Amuto pax upia nga ti huhual tuahe amuto kum tunahi ape amuto mat hetekie lialui woumuto. Amuto kum lua uke hani tesol ti nga luawa.” ");
INSERT INTO ssg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Teka masiwi ti teka Ju ukek, “Salangawe kakaian i ukek ia? Kaie i telei aliake i? Alahan i ukek kako kum lua uke hani tesol ti na i luawa?” ");
INSERT INTO ssg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jises kak tatale ukek, “Amuto se ti tehu pon itan ie. Namilomuto ma pupuasamuto tuahe ti seilon. A nga se ti tone Haeu patul, pupuasak nga aile usiusi namili Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nga kakawen ka amuto mat hetekie lialui woumuto. Na amuto kum soh ka nga se tetel ti nga kakaxi, salan i sohot hani amuto.” ");
INSERT INTO ssg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Lato kamei i, “Kaie o aita?” Jises kak pahoi, “Nga kaxi hakila haniwen amuto. ");
INSERT INTO ssg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Pate tutuen kakaiak salemuto ape kilai lialui woumuto i pon na nga sului amuto. Tuahe nga kakane teka seilon ti tehu pon ie mewenae waliko ti nga hong ti tel i taloma nga, tetel i salan wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Teka masiwi ti teka Ju tai hong xeu tutuen ka Jises kaakane lato sale tel Taman Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ape Jises hone lato, “Tataen amuto tahi hakea nga tel Nati Seilon patul he kros, Haeu hatakei hani amuto ka nga se tetel ti nga kakaxi. Nga kum aile tenen na waliko ti puki namilok. Masin ti tel Tamak hahanau nga, tin nga kaxi hani teka seilon. ");
INSERT INTO ssg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","A tetel i taloma nga i lawe kapik. I kum lioi nga nake lawe nga aile waliko tenen i hamuamua i.” ");
INSERT INTO ssg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ti Jises kakak tutuen, kilan seilon soh tetan. ");
INSERT INTO ssg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ape Jises kakane teteka Ju laha soh tetan, “Na amuto puas usi matuhini waliko ti nga hahanau, amuto kahikahik wanen. ");
INSERT INTO ssg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na masin ien, amuto tioi aluini waliko tenen salan sale Haeu ape amuto kumahe unaui saun lialun ulea, amuto ape oxoxain.” ");
INSERT INTO ssg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Seilon teka kak pahoi Jises, “Amite kahi nati Abraham ma tap wanen amite po to unaui tenen na waliko. Kalahai o kak ukek ien?” ");
INSERT INTO ssg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jises hone laha, “Nga kakane amuto kakain salan. Tel na i aile tatale saun lialun i se unauan. ");
INSERT INTO ssg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tel unaui tel tame tehu ing i kum to kapin hanowi tel na natun wanen. ");
INSERT INTO ssg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Aile ape na nga tel Nati Haeu oxoxi amuto ti unaui saun lialun, amuto oxoxa hawanewen. ");
INSERT INTO ssg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nga tioi amuto kahi nati Abraham tuahe teka ti amuto tohongi teleiak nake amuto kum hong auni kakaiak. ");
INSERT INTO ssg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nga kakak waliko tetenen tel Tamak kola haniwen nga tuahe amuto ailele waliko tetenen tel tamamuto hohone amuto.” ");
INSERT INTO ssg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Laha kak pahoi Jises, “Abraham se tamamite.” Jises ukek, “Na amuto nati Abraham, amuto puas usiwen waliko ti i ailele. ");
INSERT INTO ssg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nga kaxi hahani amuto kakain salan ti nga hongoma ti Haeu tuahe amuto totohongi tutuen teleiak. Abraham tai ailele saun tetenen. ");
INSERT INTO ssg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Amuto aile waliko tenen tel tamamuto ailele.” Laha kak pahoi Jises, “Amite kumahe tuahe nati aweisal. Amite se nati Haeu wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jises hone laha, “Na Haeu se salan wanen tamamuto, amuto waheniwen nga nake nga luama ti Haeu. Kumahe nga luama ti puki namilok, i taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Lahan amuto kum hong xeu waliko tenen ti nga kakak? Se nake amuto kum hong waxi kakaiak. ");
INSERT INTO ssg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ien se nake amuto nati tel tamamuto Satan ma pahamuto wanen puas usiai namilon. Ti pate uli hutuan, i tel halialu tamusukei seilon ma i kum xeisa waxi waliko tenen salan nake tap wanen i kakak waliko tenen salan. Ti i kak puputa, i aile ti puki saun tetan nake i weli puputa ma i se tel tame puputa. ");
INSERT INTO ssg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Aile ape ti nga kakak waliko tenen salan, amuto kapaxe. ");
INSERT INTO ssg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nakon aita ti amuto pon sehatuhini ka nga ailewen saun lialun? Ape lahan amuto kum soh nga kalak kakaiak salan? ");
INSERT INTO ssg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tel seilon na i ti Haeu, i hong usi kakai Haeu. Tuahe amuto kum hong usi kakaian nake amuto kumahe tetan.” ");
INSERT INTO ssg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Teka Ju kak lengeleng, “Salan wanen ti amite ukek ka o tel Samaria ma spirit lialun kapiti hahalialu o.” ");
INSERT INTO ssg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jises kak aseini, “Tap wanen nake nga sameni tel Tamak Haeu a amuto watakai nga. ");
INSERT INTO ssg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kalak nga kum upiup seilon sameniak, Haeu pahan seilon sameniwa nga a namilon mewenae sawisawin. ");
INSERT INTO ssg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nga kakane hawane amuto, tel na i puas usi kakaiak i kum mat wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Teka seilon kak eliel hawane, “Ape amite tioi hawane ka spirit lialun kapiti halialuen o! Abraham matewen ma teka kuluiai kakai Haeu tin laha matewen a o ukek tel na i puas usi kakaiam i kum mat. ");
INSERT INTO ssg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kaie o pamu tuah ti Abraham tel tamamite? Abraham i mat ma teka kuluiai kakai Haeu tin laha mat. Nakon o sokok o aita?” ");
INSERT INTO ssg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jises kak pahoi laha, “Na puki nga sameni nga, tap solian tetan. Se puki tel Tamak i hana nga seilon pate tuah. I se tetel amuto ukek i Haeu ti amuto. ");
INSERT INTO ssg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tuahe amuto kum tioi i. Nga tioi hawane i. Na masin nga ukek nga kum tioi i, nga puputawen, hanowi ti amuto. Tuahe nga tioi i ape nga puas usiusi kakaian. ");
INSERT INTO ssg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tel tamamuto Abraham i amuam hawane ti i ningahiwa tahiaiak. I paxaiwa ape i amuke.” ");
INSERT INTO ssg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Teka seilon kak ukek, “Ahangum tai meiwa 50! Lehe o ningahi Abraham ukek ia?” ");
INSERT INTO ssg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jises kak pahoi laha, “Nga kakane hawane amuto, imat ti Abraham takah, nga se liai ien, tetel ti nga kakaxi.” ");
INSERT INTO ssg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tataen ien wanen, laha waxi pot ti hokaiai Jises tuahe i kuosel ti laha ape i nahih salili Ingi Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ti Jises ma tesol kahikahin tau nanahih, lato ningahi tel seilon pulaxa. Liai i takahama pulaxa. ");
INSERT INTO ssg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tesol kahikahi Jises kamei i, “Tel masiwi, nake lahan tel seilon ie pulan pulaxa? Nakon i sohot ukek ti puki lialui woun ka lialui woi taman ma tinan?” ");
INSERT INTO ssg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jises kak pahoi ukek, “Kumahe nake ti lialui woun ma na lialui woi taman ma tinan. Pulan i pulaxa lehe Haeu kola hani teka seilon lalape pohen ti i huali tel seilon ie. ");
INSERT INTO ssg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ti nga tel haxewaiamuto tutuen kapimuto, kako kewa ailei puase tetel i taloma nga. Kum kue ape nga salili amuto. Ien masin tilokoan ti seilon kum puas uke. ");
INSERT INTO ssg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nga masin xewai alon ti haxewai lawe seilon ti nga he tehu pon ie.” ");
INSERT INTO ssg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ti Jises kak kewa, i uke teik pekeun. I pukeini ma talini hawasalisali ape ahui hani puli tel seilon pulaxa. ");
INSERT INTO ssg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ape i ukek, “Nahih nuhiwa pulam haniwa tehu kan Siloam.” Tetenen ax Siloam i ukek, “talo.” I nahiwa ape i nuhi pulan. Tataen ien pulan ewi ape i paxapax uke. ");
INSERT INTO ssg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Teka seilon laha toto xohixohin kapin ma teka laha ningahiwen i imat ti lawe i to katekat huhual, laha he kamekam, “Nakon i se tetel seilon pulaxa, lawe kako ningahi i to katekat huhual?” ");
INSERT INTO ssg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Teka laha ukek, “Se tetel ien.” Tuahe teka liai ukek, “Kumahe, tuahe tanoman masin wanen i.” Ape puki tel seilon hone laha, “Se nga tetel seilon amuto he kamekam.” ");
INSERT INTO ssg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Laha kamei i, “I sohot ukek ia ape pulam ewi?” ");
INSERT INTO ssg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","I kak pahoi ukek, “Tel seilon axan Jises pukeini hawasalisali teik pekeun ape i ahui hani pulak. I talo nga nahih nuhi kawak hani tehu kan Siloam ape nga aile usi. Tataen ien pulak i ewi ape nga paxapax uke.” ");
INSERT INTO ssg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Laha kamei i, “Tel seilon ien ape ia?” I ukek, “Nga kum tioi.” ");
INSERT INTO ssg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Muhin ien laha hakahita tel seilon kemuk pulan pulaxa hani teka Parisi. ");
INSERT INTO ssg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ngain tetelao ien Sabat ti Jises aile hawasalisali teik pekeun ti aile haewiai puli tel seilon ien. ");
INSERT INTO ssg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Teka Parisi kamei i, “I sohot ukek ia ape o paxapax?” Ape i kakane lato, “Jises hana teik pekeun wasalisalin hani he pulak ape ti nga nahih nuhiwa kawak, pulak ewi.” ");
INSERT INTO ssg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tesol ti teka Parisi ukek, “Tel seilon Jises i kumahe wanen ti Haeu nake i xaputi nauna ti telao ngain Sabat.” Tuahe teka liai ukek, “Kumahe, nake tap tel seilon woun lialun i pon ailei waliko tenen lalap ti kui pohen masin ti tel seilon ien.” Kakaialaha i hatano wasolalaha. ");
INSERT INTO ssg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ape teka Parisi kamei ulei tetel seilon, “Tel seilon i haewia pulam, kaie o ukek i aita?” Tel seilon kak pahoi, “Nga ukek i tel kuluiai kakai Haeu.” ");
INSERT INTO ssg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Teka masiwi ti teka Ju lato kum soh ka tetel seilon ien kemuk pulan pulaxa ape lato ilowi taman ma tinan. ");
INSERT INTO ssg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Lato kamei lalu, “Tel seilon ien, i natumulu? Nakon i tetel amulu ukek hoi i takahama pulaxa? Ape lahan ka i paxapax?” ");
INSERT INTO ssg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tel taman ma tel tinan kak ukek, “I se natumili. Salan hoi i takahama pulaxa. ");
INSERT INTO ssg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tuahe amili kum tioi i sohot ukek ia. Amili kum tioi aita haewia pulan. I ape lalap, i pon tukei awan. Kameiwa i!” ");
INSERT INTO ssg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Lalu kak ukek ien nake lalu mamata teka masiwi ti teka Ju. Lalu tioi lato ailewen namil ka na tel seilon i ukek Jises se Krais, lato xaxaweni tamusuke i ti synagog. ");
INSERT INTO ssg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nake ti tenen ien lalu ukek, “I ape lalap, i pon tukei awan. Kameiwa i.” ");
INSERT INTO ssg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Lato ilowi tuhi tel seilon kemuk pulaxa ape kakane i ukek, “Kakawa ti kuinakei Haeu ka waliko ti na o kak se salan nake amite tioi ka tetel seilon i haewia o woun pate lialun.” ");
INSERT INTO ssg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ape tel seilon kak pahoi lato ukek, “Nga kum tioi na i woun lialun ma na kumahe. Tuahe nga tioi tetenen, kemuk nga pulaxa ape aope ie nga paxapax uke.” ");
INSERT INTO ssg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tuahe lato kamea, “Waliko la i aile hani o? I haewia pulam ukek ia?” ");
INSERT INTO ssg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","I kak pahoi lato ukek, “Nga kakanewen amuto tuahe amuto kum hong. Alahan pahamuto hong ulea? Halik na pahamuto sohot kahikahin.” ");
INSERT INTO ssg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Lato kak saxuti i ape ukek, “Puki o kahikahin, amite se kahikahi Moses. ");
INSERT INTO ssg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Amite tioi ka Moses tel tuah wanen nake Haeu kakawen kapin tuahe tel seilon ien, i pupuas hahitake aita?” ");
INSERT INTO ssg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tel seilon ukek, “Saka i aile ukek ia ka amuto kum tioi? Amuto kum tioi aita tel hani i ailei puasan kalak i haewiawen pulak. ");
INSERT INTO ssg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kako tioi Haeu kum hong seilon tetenen woun lialun, i hong teka laha lotu sameni i ma puas usi waliko ti pahan. ");
INSERT INTO ssg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kemuk tap wanen tel hahaewiawen puli tel na seilon i takahama hoi pulaxa. ");
INSERT INTO ssg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Na masin tel seilon ien kumahe i ahuma ti Haeu, ala i kum pon ailei tenen ien.” ");
INSERT INTO ssg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Lato kak lengeleng ukek, “Lilian ti o takahama o tel weli ailei saun lialun. O kumahe tel hanauamite!” Ape lato talo xaxaweni i ti synagog. ");
INSERT INTO ssg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ti Jises hongoa waliko ti i sohot hani tel seilon ien, i nahih upia i. Ti i tunahiwa, i kamei tel seilon, “Nakon namilom xoxoan ti tel Nati Seilon?” ");
INSERT INTO ssg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","I pahoi Jises ukek, “I aita? Tel masiwi, kaxi hanima nga lehe nga soh tetan.” ");
INSERT INTO ssg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jises hone i, “O paxaiwen i. Ti aope ie i kakak kapim.” ");
INSERT INTO ssg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tel seilon ukek, “Tel Masiwi, nga soh hawane tetam.” I lokuha hani itan ape i lotui Jises. ");
INSERT INTO ssg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jises hone i ukek, “Nga lua hanima tehu pon ie paxai kolongeniai woi seilon. Nga luama haxewai namili teka laha kum xeu ningahiai lawe waliko salan sale Haeu. Ape teka seilon laha sokok hoi laha xewawen ti lawe waliko salan sale Haeu, laha masin teka pulaxa wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Teka Parisi tutu ien. Ti laha hongoa kakai Jises, laha kamea, “Kaie o ukek amite masin teka pulaxa wanen?” ");
INSERT INTO ssg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jises pahoi laha ukek, “Na masin amuto pulaxa wanen, tap tel i tieniwen amuto. Tuahe nake amuto sokok amuto xewawen ti lawe waliko salan sale Haeu, amuto puluti aliliake amuto ape lialui saun ti amuto tutuen.” ");
INSERT INTO ssg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jises kakane teka seilon ukek, “Nga kakane hawane amuto, tel na i kum soh non he aweing hani tone sipsip a i soh muna hakokol, tel seilon ien i tel seilon xuxuina. ");
INSERT INTO ssg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tuahe tel ngahatiai sipsip lawe i soh non he aweing. ");
INSERT INTO ssg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tel peteniai tesol ien i hei kahip hani tel ngahatiai sipsip ape lato hong tioi hawane kinaxon. Ti i hasohotu lato i tiloi axalato tok tok. ");
INSERT INTO ssg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","I nahike hasohotu ape i neini lato. Lato kahiti i nake lato hong tioi hawane kinaxon. ");
INSERT INTO ssg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Lato kum nahih kahiti seilon liai, lato ox salili nake lato kum hong tioi kinaxon.” ");
INSERT INTO ssg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jises kak kokolongeni kakain ien hani teka seilon tuahe laha kum xeu salangawan. ");
INSERT INTO ssg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aile ape Jises kaxi haxewa hani laha i ukek, “Nga kakane hawane amuto, nga masin tewau aweing ti teka sipsip nahih soh. ");
INSERT INTO ssg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Teka seilon imat tetak laha woinakon ngahatiai sipsip, laha seilon ti xuxuina ma aile halialualato. Tuahe teka sipsip tetak lato kum hong usi laha. ");
INSERT INTO ssg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nga masin tewau aweing. Tel na i non tewau aweing ien, i tunahi tonain kapi Haeu lian tehue. Ape tesol tesol ti na i nahih, i kum tae tenen na waliko nake Haeu lawe kapin. ");
INSERT INTO ssg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tel seilon lialun namilon mewenae ti xuxuina, teletele, halialui seilon ma soxi. Tuahe nga luama lehe seilon hina tonain tenen laha amuke hawane. ");
INSERT INTO ssg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nga tel ngahat solian. Tel ngahat solian i kum nomuha na i mat ukei totone teka sipsip tetan. ");
INSERT INTO ssg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Seilon ti laha kahui i moni peteniai sipsip, i kumahe tel ngahat wanen nake lato kumahe tetan. Ti i ningahiwa sinen tenen tumun kalimen kiliwama, i ox salili teka sipsip. Ape sinen xohoti hamange ma usi silahoteni lato. ");
INSERT INTO ssg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tel seilon ien ox salili lato nake i kumahe tel tamalato wanen ape i kum nam waxi waliko ti na i sohot hani lato. ");
INSERT INTO ssg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Tuahe nga se tel ngahat solian. Nga ma teka sipsip tetak amite lohun xoxoan. ");
INSERT INTO ssg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Masin nga ma tel Tamak amili pate lohun xoxoan. Aile ape nga kum nomuha na nga mat ukei totone teka sipsip tetak. ");
INSERT INTO ssg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hina sipsip laha kumahe kapik tuahe laha tin tetak. Ape namilok xoxoan wanen ti hukumini hatapoalaha, lehe hatesol sipsip tetak hong usi kakaiak. Ape ngain ti i luluainima, laha hatesol hukuma hetekie hahitake ngahat telawe. ");
INSERT INTO ssg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tel Tamak Haeu waheni nga nake puki nga hani lioi nga mat lehe nga moih alia. ");
INSERT INTO ssg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tap tel pon teleiak halik na nga sowini. Nga pon hani seilon telei nga ma nga pon moih alia tuahe nga puas usiusi waliko ti tel Tamak honewen nga ailean.” ");
INSERT INTO ssg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Teik kakain ien i selai teka seilon. ");
INSERT INTO ssg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kilan seilon kakak Jises ukek, “Spirit lialun kapiti halialu i! I taxitaxiawen! Ape lahan amuto hong kakaian?” ");
INSERT INTO ssg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tuahe seilon teka laha kak ukek, “Tel seilon na spirit lialun kapiti halialu i, i kum kak ukek ien. Spirit lialun kum pon haewiai puli seilon pulaxa!” ");
INSERT INTO ssg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ngain lalap ape i tahiawen leili Jerusalem ti teka Ju nameni taun ti hil waxi aliakei Ingi Haeu ti teka Siria. Lokon ien taun ti waiwain. ");
INSERT INTO ssg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jises tau nanahih tesol Totone Solomon kapi Ingi Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Teka Ju apuha kalini i ape ukek, “Kum tua kak hahatila amite. Na o Krais, se kaxi hawane hanima amite.” ");
INSERT INTO ssg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jises kak pahoi laha, “Nga kakanewen amuto tuahe amuto kum hong soh. Waliko tenen lalap nga ailele hahitake axe tel Tamak Haeu i kola hawane ka nga se tetel ti nga kakaxi. ");
INSERT INTO ssg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tuahe amuto kum hong soh nake amuto kumahe tesol ti teka sipsip tetak. ");
INSERT INTO ssg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Teka sipsip tetak hong usi kakaiak. Nga tioi hawane lato ape lato se kahikahik. ");
INSERT INTO ssg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nga hani lato tonain kapi Haeu lian tehue ape lato kum to wanen lioan ti kaui kawatan ti lialui woulato. Tap tel pon waxi xaxawenialato ti ngangahat tetak. ");
INSERT INTO ssg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tel Tamak Haeu hani nga teteka lato sohot kahikahik. I pamu masiwian ti lawe seilon, aile ape tap tel i pon waxi xaxawenialato ti ngangahat tetan. ");
INSERT INTO ssg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nga ma tel Tamak Haeu amili pakata xox hahawane, amili masin seilon tel.” ");
INSERT INTO ssg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ti laha hongoa, laha waxi ulea pot ti hokaian. ");
INSERT INTO ssg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tuahe Jises ukek, “Tel Tamak Haeu hapohea nga ailei kilan waliko solian ti hualiai seilon. Tenen ia ti tesol waliko ien i talesi amuto lehe pahamuto telei nga?” ");
INSERT INTO ssg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Laha kak pahoi Jises, “Kumahe pahamite hokai o ti waliko solian o ailewen tuahe nake o teheni halialu Haeu. O tuahe seilon masin amite ape o ukek ka o se Haeu.” ");
INSERT INTO ssg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jises ukek, “Ala puki amuto tioi ka Haeu kaakane hina teka masiwi leili pepaun, ‘Nga ukek amuto se haeu.’ ");
INSERT INTO ssg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Amuto tioi ka kakai Haeu lawe sawisawin ma tuah. Na Haeu ukek ka teka masiwi ti seilon tetan se haeu na laha teka ti hong usiai kakaian, alahan amuto ukek nga teheni hahalialu Haeu ti nga ukek nga tel Nati Haeu? Nga pakata xoxox kapi tel Tamak Haeu. Puki i kilami nga ailei pupuasan ape i taloma nga ailean. ");
INSERT INTO ssg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Na masin kumahe nga ailele puase tel Tamak Haeu, kum hong sohosoh nga. ");
INSERT INTO ssg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tuahe na nga ailele puasan, kalak amuto kum hong soh nga, sohoa kui pohek ti waliko tenen lalap nga ailele lehe amuto xeu ma tioi ka nga ma Haeu amili pakata xox hahawane, amili masin seilon tel.” ");
INSERT INTO ssg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ti laha hongoa, laha tohongi ulea pohiai Jises tuahe i kuosel ti laha. ");
INSERT INTO ssg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ti tesol ien Jises non koti tehu kan Jodan ape i nahih to hani tetesol kemuk Jon baptaisi teka seilon. ");
INSERT INTO ssg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kilan seilon opea hani kapi Jises. Laha ukek, “Tap tenen waliko lalap Jon ailewen tuahe kakaian ti tel seilon ie se salan wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ape kilan seilon ien laha hong soh ti Jises. ");
INSERT INTO ssg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Tel seilon axan Lasarus i ti tewau toan Betani tesol ti hahutuan toto, Mary ma Mata. Mary se tetel imuh i tihi sanda tenen poun solian hani he ae tel Masiwi Jises ape i uke ukun umeni hapaxean. Aope Lasarus tinun. ");
INSERT INTO ssg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Aile ape hahutuan hakau kakain hani Jises ukek, “Tel Masiwi, tel lohum wanen i pate tinun.” ");
INSERT INTO ssg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ti Jises hongoa i ukek, “Tenen nax ien kumahe i sohot hani Lasarus lehe i mat tamus tuahe lehe Haeu kola lalape kui pohen ape teka seilon sameni nga tel Natun.” ");
INSERT INTO ssg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jises tone aten wanen Mata, Mary ma Lasarus. ");
INSERT INTO ssg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tuahe kalak i hongoen ka Lasarus pate tinun, i to ahe ngain huohu tesol ti i heheuta. ");
INSERT INTO ssg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Imuh i hone tesol kahikahin, “Kako nahih alia hani Judia.” ");
INSERT INTO ssg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tesol kahikahin pahoi i ukek, “Tel Masiwi, pate aope wanen teka seilon ien lehe hokai telei o ani pot. Alahan lehe o alia kewak ien?” ");
INSERT INTO ssg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ape Jises ukek, “Ti nga tel haxewaiamuto kapimuto, kum nanamiloi nake hina taun tutuen Haeu hani kako ailei waliko ti pahan. ");
INSERT INTO ssg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tuahe ti na seilon kum nam waxi nga tel haxewaialaha, ien masin laha nanahih ti leili tilokoan ape laha kum pon ailei waliko ti Haeu pahan.” ");
INSERT INTO ssg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jises kak kewa ape i ukek, “Tel lohukako Lasarus ape i matihuen. Tuahe nga nahih hangoni i.” ");
INSERT INTO ssg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tesol kahikahin pahoi i ukek, “Tel Masiwi, na masin i mamatih pake i ewi.” ");
INSERT INTO ssg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tuahe salangawe kakai Jises i ukek ka Lasarus matewen ape lato sokok i ukek Lasarus tua mamatih. ");
INSERT INTO ssg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Aile ape Jises kaxi haxewa hani lato, “Lasarus matewen. ");
INSERT INTO ssg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kalak nga kumahe kapin ti lokon i mat, nga amuam nake waliko ti lehe i sohot, i pon haxoxoi namilomuto tetak. Kako nahih hani kapin.” ");
INSERT INTO ssg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, tel laha axai i Sangasang, hone tesol tuaun, “Kako nahih kahiti tel masiwi lehe tin kako mat ohoi i.” ");
INSERT INTO ssg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ti lato tahiawa Betani, Jises hong ka laha tihiniwen Lasarus ngain hinalo tamusuen. ");
INSERT INTO ssg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani kumahe xauxaun ti Jerusalem, sai toluhu kilomita. ");
INSERT INTO ssg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kilan seilon nahih paxai Mata ma Mary hasolialalu ti matei tel ukalalalu. ");
INSERT INTO ssg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ti Mata hongoa ka Jises nanahima, i nahih tengeni i a Mary tutuen leili ing. ");
INSERT INTO ssg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata kakane Jises, “Tel Masiwi, na masin o ie, kaie tel ukalak i tai mat. ");
INSERT INTO ssg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tuahe kalak Lasarus matewen, nga tioi hawane ka Haeu aile tuahe tenen na o kamei i.” ");
INSERT INTO ssg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jises hone i ukek, “Tel ukalam i xahat alia.” ");
INSERT INTO ssg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ape Mata ukek, “Nga tioi ka i xahat alia taen hatesol seilon xahat alia, ti taun ti hinitiai lawe seilon.” ");
INSERT INTO ssg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jises hone i ukek, “Nga tel xahateniai seilon maten ma hanialaha tonain kapi Haeu ti tap tahi tapoan. Tel na namilon xoxoan tetak kalak i mat i moihin tutuen. ");
INSERT INTO ssg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ape tel i soh tetak ma i to kapi Haeu lian tehue, tel ien i kum mat tamus. Kaie o soh ti waliko ie?” ");
INSERT INTO ssg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ape Mata pahoi i ukek, “Tel Masiwi, nga soh hawane ka o Krais, tel Nati Haeu, tetel Haeu taloma.” ");
INSERT INTO ssg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ti Mata kak kewa, i nahih alia. I waxi tahaini Mary ti teka seilon ape i ukek, “Tel Masiwi tahiawen, i kamekam o.” ");
INSERT INTO ssg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ti Mary hongoa i saxoh ahuta tengenian. ");
INSERT INTO ssg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ti lokon ien Jises tai soh hani leili toan, i tutuen tetesol ti Mata nahih tengeni i. ");
INSERT INTO ssg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Teteka seilon laha apupuha leili tehu ing kapi Mary ti hasolian, taen laha ningahi i tua ape i saxoh ahuta hani melal, laha kahiti i. Laha sokok lehe i nahih tang hani he amal. ");
INSERT INTO ssg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ti Mary tahia haniwa kapi Jises, i lokuha hani itan kapi aen ape i ukek, “Tel Masiwi, na masin o ie, kaie tel ukalak i tai mat.” ");
INSERT INTO ssg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ti Jises ningahiwa Mary ma teka seilon kapin tatangixi Lasarus, lon tel hetekie tian i kawat hawane. ");
INSERT INTO ssg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","I kamei lato, “Amuto hahanopi i ia?” Ape lato ukek, “Tel Masiwi, nahima paxai.” ");
INSERT INTO ssg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ape ti tatahan tetan kani pulan lil. ");
INSERT INTO ssg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Hina seilon ien, laha ukek, “Paxaiwa, lalap wanen wawahen tetan ti Lasarus.” ");
INSERT INTO ssg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tuahe teka liai, laha ukek, “I aile haewia puli tel pulaxa, kewak? Kaie ala i awaiwen Lasarus.” ");
INSERT INTO ssg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ape lato tahia hani tehu amali Lasarus. Amal tenen ien laha tanomi he pot patul ti hepekeun. Laha hulini tehu lalape pot ti siponian. Ti lato tutu ien, Jises lon tel ulea. ");
INSERT INTO ssg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","I hone lato, “Hulini xaxaweniwa tehu pot.” Tuahe Mata ukek, “Tel Masiwi, poun ape kohan. I leili amal kewen ngain hinalo.” ");
INSERT INTO ssg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jises hone i ukek, “Hoi nga kakanewen o ka na namilom xoxoan tetak, o ningahi waliko tenen lalap ti pohe Haeu aile.” ");
INSERT INTO ssg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aile ape lato hulini xaxaweni tehu pot. Jises pax hani patul ape i ukek, “Nga kak kemulik hani o tel Tamak Haeu nake o hongoen kamekame tetak. ");
INSERT INTO ssg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nga tioi ka lawe o hong nga, tuahe nga kamei o ti puli lawe seilon ie lehe laha soh ka o taloma nga.” ");
INSERT INTO ssg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Muhin ti i kak kewa, i tilol eliel ukek, “Lasarus ahutama!” ");
INSERT INTO ssg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ape tel seilon kemuk maten, i ahuta. Minan, aen ma patun talinan tutuen maia ti puxuiai seilon maten. Jises hone lato, “Upati xaxaweniwa maia ape hanahiwa i.” ");
INSERT INTO ssg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Aile ape kilan ti teka seilon kapi Mary, ti laha paxaiwa waliko ti Jises aile, laha soh tetan. ");
INSERT INTO ssg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tuahe teka ti laha nahih hani kapi teka Parisi ape kaxi hani lato waliko ti Jises ailele. ");
INSERT INTO ssg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aile ape teka Parisi ma teka masiwi tuah ti hukuminiai Haeu ma seilon apuha hani kapi teka masiwi tapein ti teka Ju ape lato ukek, “Kaie kako aile waliko la? Tel seilon ien aile kilan kolakol tenen lalap. ");
INSERT INTO ssg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Na kako paxai lioi waliko ti i ailele, hatesol seilon laha soh tetan ape teka Rom aile halialu Ingi Haeu ti kako hetekie kako teka Ju.” ");
INSERT INTO ssg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tel ti lato, axan Kaiapas, i tel masiwi tapein ti hukuminiai Haeu ma seilon ti ahang tehu ien. I ukek, “Tap namilomuto. ");
INSERT INTO ssg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Amuto kum paxai tioi ka pamu ewian na seilon telawe i mat, kumahe lawe seilon. Pamu lialuan na teka Rom telei kako teka Ju hatesol.” ");
INSERT INTO ssg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Waliko ti i kakak kumahe ti puki namilon. Nake i tel masiwi tapein ti hukuminiai Haeu ma seilon ti ahang tehu ien, Haeu aile i kak kilami ka Jises mat ti hualiai teka Ju hatesol. ");
INSERT INTO ssg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Tuahe kumahe mewenae ti lato, hetekie hatesol seilon ti Haeu laha tesol tesol lehe laha hukuma hetekie namil tenenawe ti usiai nauna ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tataen ien teka masiwi ti teka Ju hutui aile namil ti teleiai Jises. ");
INSERT INTO ssg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Aile ape Jises monga ailei puasan ti puli lawe seilon. I nahih ahuta hani Epraim, tehu taon xohixohin kapi lohong. Ape i ma tesol kahikahin to ien. ");
INSERT INTO ssg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ngain lalap ti Pasova ape i xohiwen. Kilan seilon ti toan tesol tesol laha nahih hani Jerusalem ti ailei saun tenen ti haunialaha ti puli Haeu masin ti teka Ju lawe ailele apesenialaha ti Pasova. ");
INSERT INTO ssg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Laha to pax upiup Jises. Ti laha leili Ingi Haeu, laha he kamekam alia laha, “Amuto namiloi ukek ia? Kaie i nahih hanima tehu apuhain ti Pasova ka tap?” ");
INSERT INTO ssg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Lokon ien tesol masiwi tuah ti hukuminiai Haeu ma seilon hetekie tesol Parisi lato honewen teka seilon ka na tel i tioi Jises tetesol, hahongoa lato lehe lato xoti i. ");
INSERT INTO ssg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ngain tepanim tehu imat ti Pasova, Jises nahih hani Betani, tesol tone Lasarus, tetel Jises hamoiha aliake ti matean. ");
INSERT INTO ssg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ti ien lato apeseni angiain ti amukei Jises. Mata tel lohiai an. Lasarus tin ien leili teka laha toto he tone angiain kapi Jises. ");
INSERT INTO ssg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ti lokon ien Mary waxi tehu sanda kahun pate lalap ma poun pate solian. I tihi hatapo hani he ae Jises ape i uke ukun umeni hapaxean. Soliai poi tehu sanda i atuhi ing hatehu. ");
INSERT INTO ssg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tuahe Judas Iskariot, tel ti tesol kahikahi Jises, tetel imuh i hangaini Jises hani mini teka masiwi ti teka Ju, i ukek, ");
INSERT INTO ssg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kalahai i tua aile xoini tehu sanda? Pamu ewian na hangaini waxiai moni lalap ape hani teka seilon tap soxi.” ");
INSERT INTO ssg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kumahe i kak ukek ien nake i tahane teka seilon tap soxi tuahe nake i seilon tenen xuxuina. I tetel auniai moniulato ape hina lawe i xuina. ");
INSERT INTO ssg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tuahe Jises ukek, “Kum hohowini i nake i auni tehu sanda atengi tetelao. I tihi hani he aek apeseniak ti tehu mateak. ");
INSERT INTO ssg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Teka seilon tap soxi laha lawe kapimuto, tuahe nga kumahe lawe kapimuto.” ");
INSERT INTO ssg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kilan seilon hong ka Jises Betani ape laha nahih kewak ien. Tin pahalaha paxaiai Lasarus, tetel Jises hamoiha aliake ti matean. ");
INSERT INTO ssg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Aile ape teka masiwi tuah ti hukuminiai Haeu ma seilon aile teik namil ti telei hetekieai Lasarus. ");
INSERT INTO ssg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Pahalato lato telei Lasarus nake xahat aliaian aile, ape kilan teka Ju laha kum hong lato, laha soh non ti Jises. ");
INSERT INTO ssg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ngain liai telao teka kilai seilon nahih hani tehu apuhain lalap ti Pasova. Laha hong ka Jises nahih hahanima Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Laha koti kai hatoh ape nahih titilol tengenian, “Kako haxawawa axe Haeu. Kako sameniwa ma amukewa tel i nahih hehetekiema poh ma solian ti Haeu! Kako sameniwa ma amukewa tel Masiwi tapein ti Israel!” ");
INSERT INTO ssg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jises waxi tok donki uluha, i to he tehiton ape tok donki tau kakau i, masin ti pepai Haeu kakawen ukek, ");
INSERT INTO ssg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Teka seilon ti Israel, kum maamata. Paxaiwa, tel Masiwi ti amuto i luluainima, i toto patul he tok donki uluha.” ");
INSERT INTO ssg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ti lokon ien tesol kahikahi Jises kum xeu salangawe waliko ti i sosohot. Tuahe muhin ti Jises xahat aliawa ti matean, lato nameni ka pepai Haeu i kakawen ka hatesol waliko ien i sohot hani i. ");
INSERT INTO ssg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Teteka seilon laha kapi Jises ti i tiloi ahuti Lasarus he amal lokon ti i hamoiha aliake i, laha kaxi hani teka liai waliko ti i sohotuen. ");
INSERT INTO ssg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ape kilan seilon nahih tengeni Jises nake laha hongoen waliko tenen lalap i ailewen ti pohe Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Teka Parisi kakak alia puki lato, “Amuto ningahi kako kum waxaini wanen. Paxaiwa, hatesol seilon nahih kakahiti i ma hongohong kakaian.” ");
INSERT INTO ssg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tesol ti teka Grik tin lato nahih lotu hani Jerusalem ti tehu apuhain lalap ti Pasova. ");
INSERT INTO ssg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Lato nahih hani kapi Pilip, tel seilon ti tehu taon Betsaida ti Galili ape lato ukek, “Kaie ewi na o huali amite? Pahamite amite paxai Jises.” ");
INSERT INTO ssg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip nahih hahongo Andru ape ati lalu nahih kakane Jises. ");
INSERT INTO ssg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jises kakane teka seilon ukek, “Taun ti mateak i xohiwen. Ape teka seilon paxai tioi ka nga tel Nati Seilon pate tuah ape laha sameni nga. ");
INSERT INTO ssg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nga kaxi hawane hani amuto, ien masin wanen tehu waki maia ti seilon seini, i matemu ape imuh i hahua hakila. Na tap, i hamalum waki maia tehue. ");
INSERT INTO ssg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Na tel seilon pahan mewenae akeni konginiai totonan ti itan ie, i lioi totonan ti kapi Haeu. Tuahe na tel seilon i to kahikahik kalak na masin i lioi totonan ti itan ie, i waxi totonan ti kapi Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tel na pahan i sohot kahikahik kewa ka i hong usi kakaiak. Na tel i sohot kahikahik lawe i kakahiti nga hani tuahe na tesol. Ape tel Tamak Haeu namiloi ukek i tel seilon tuah. ");
INSERT INTO ssg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Aope ie tiak pate kawatan. Tuahe nga kum kamei Haeu awaiak ti mateak nake hoi liai nga luama ti haponowiai namilon. ");
INSERT INTO ssg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tel Tamak Haeu, kola haniwa lawe seilon lalape pohem ma soliaiam.” Tataen ien tenen kinax wixima ti tone Haeu i ukek, “Nga kolawen ape nga kola ulea.” ");
INSERT INTO ssg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Teka kilai seilon tutu ien hongoa ape teka ti laha ukek, “Sohin tonui kuhuh.” Teka liai ukek, “Tel engel kakak kapin.” ");
INSERT INTO ssg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tuahe Jises hone laha, “Tenen kakain ien kumahe ti hualiak, ti hualiamuto. ");
INSERT INTO ssg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Aope ie teka seilon ti tehu pon ie laha tu ti sulusulu nake ti lialui woulaha. Tuahe taun ape i tahiawen ti nga waxaini xaxaweni Satan tel i neini hahalialu laha. ");
INSERT INTO ssg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Taen ti laha tahi hakea nga hani patul he kros, nga kapiti seilon ti lawe xux hanima kapik lehe laha soh tetak.” ");
INSERT INTO ssg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jises kak ukek ti kilamiai sale matean. ");
INSERT INTO ssg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Teka seilon ukek, “Amite tioi ti he pepai Haeu ka Krais i moih lian tehue. Alahan o ukek laha tahi hakea i hani patul he kros? Ape o kakak ulea lahe Krais?” ");
INSERT INTO ssg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jises pahoi laha ukek, “Kum kue nga tel haxewaiamuto ape kumahe kapimuto. Aile ape ti nga tutuen kapimuto, usiwa nenein tetak lehe amuto kum puhei ailei saun lialun. Ien masin seilon na i nahih tatanga leili tilokoan. ");
INSERT INTO ssg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ti nga tutuen kapimuto, amuto sohoa tetak nake nga masin xewan ti neiniamuto. Na amuto aile usi, amuto sohot hanowi seilon ti xewan.” Muhin ti Jises kak kewa, i nahih hani tesol ti laha kum tioi. ");
INSERT INTO ssg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kalak Jises ailele kilan waliko lalap ti pohe Haeu he puli teka seilon, laha kum soh tutuen tetan. ");
INSERT INTO ssg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Masin wanen ti Aisaia tel kuluiai kakai Haeu kak kilamiwen, “Haeu tel Masiwi, tap seilon hong soh ti amite kakaxi o hani laha. Tin tap seilon paxai tioi lalape pohem.” ");
INSERT INTO ssg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Aile ape laha kum soh. Aisaia tin i kakawen, ");
INSERT INTO ssg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pulalaha masin ka pulaxa. Laha papaxai waliko ti Haeu ailele tuahe laha kum ningahi. Patulaha pate ailan, laha kum xeu. Ape laha kum towiahu ti lialui woulaha lehe Haeu aile haewia laha.” ");
INSERT INTO ssg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia kak ukek nake i ningahiwen lalape poh ma solian ti Jises ape i kaxi i hani teka seilon. ");
INSERT INTO ssg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kilan seilon laha soh ti Jises. Hina masiwi ti teka Ju tin lato soh tuahe lato mamata kolaian uke teka Parisi xaxaweni tamusuke lato ti synagog. ");
INSERT INTO ssg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pamu lato halepelep lehe seilon sameni lato, i xoini na Haeu sameni lato. ");
INSERT INTO ssg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jises kak eliel ukek, “Tel na i soh tetak tin i soh hetekie ti tel i taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tel i paxaiwen nga, i paxai hetekiewen tel i taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nga lua hanima tehu pon ie masin xewai alon lehe hatesol seilon laha soh tetak laha kum to leili tilokoan ti saun lialun. ");
INSERT INTO ssg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na tel hong kakaiak ape i kum puas usi, nga kum sului i nake nga luama awaiai seilon ti kawatan ti lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tel na i kum nam waxi nga ma kum hong auni kakaiak, puki kakain ien sului i. Ape telao ngain ti hinitiai lawe seilon, Haeu axi i kawatan nake ti kakaiak ien. ");
INSERT INTO ssg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kakaiak salan nake kumahe nga kakak ti puki namilok. Se tetel i taloma nga, tel Tamak Haeu hone nga waliko ti nga kakaxi. ");
INSERT INTO ssg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ape nga tioi ka ti usiai nauna tetan i hani seilon tonain kapin ti tap tahi tapoan. Aile ape nga kakaxi waliko tenen tel Tamak hone nga kaxian.” ");
INSERT INTO ssg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sikole ngain ti Pasova ape Jises ma tesol kahikahin ang apuha hetekie. Jises tioi ka se ape taun ti i salili tehu pon ie ape alia hani kapi tel Taman Haeu. I waheni hawane tesol kahikahin, seilon tetan ape i kola lalape wawahen tetan hani lato. ");
INSERT INTO ssg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Satan hoi i hanamiloawen Judas tel nati Saimon Iskariot hangainiai Jises hani teka teleian. ");
INSERT INTO ssg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jises tioi ka tel Taman Haeu hana i Masiwi ti lawe waliko ma tin i tioi ka i ahuma ti Haeu ape i alia hani kapi Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Lokon ti lato angiang, Jises tu, i naxi xaxaweni tehu atuhiai puxuaun, i waxi teik taol ape i xioti hani luhuan. ");
INSERT INTO ssg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","I tihi kan hani tehu kapi ape i nuhi ae tesol kahikahin. I uke teik taol i xixioti luhuan ape i umeni hapaxe aelato. ");
INSERT INTO ssg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ti i tahiawa kapi Saimon Pita, Pita kamei i, “Tel Masiwi, lehe o nuhi aek?” ");
INSERT INTO ssg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jises hone i ukek, “Waliko ti nga ailele o kum paxai tioi tuahe imuh o xeu.” ");
INSERT INTO ssg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita hone i ukek, “Tap wanen ka o nuhi aek.” Jises kakane aliake i ukek, “Na nga kum nuhi aem, o kumahe tel kahikahik wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pita ukek, “Tel Masiwi, na masin ien, kumahe mewenae aek, nuhi hetekiema minak ma patuk.” ");
INSERT INTO ssg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jises ukek, “Seilon ti i kikanoen i kum kikan ulea. Tapai i tua nuhi aen ape i hau hawane. Tuahe kumahe amuto hatesol leilomuto haun.” ");
INSERT INTO ssg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jises ukek ka kumahe hatesol kahikahin haun nake i tioi ka tel ti lato hangaini i hani teka teleian. ");
INSERT INTO ssg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ti Jises nuhi kewa aelato, i puxui aliake tehu atuhiai puxuaun ape i nahih alia hani tesol totonan. I kamei lato, “Saka amuto tioi waliko tetenen nga aile hahani amuto? ");
INSERT INTO ssg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lawe na amuto kakane nga, amuto ukek tel Masiwi ma na tel hanauamite. A salan nake nga Masiwi ma tel hanaui seilon. ");
INSERT INTO ssg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kalak nga Masiwi ma hanaui seilon, nga nuhi aemuto. Aile ape amuto tin he nuhinuhawa aemuto. ");
INSERT INTO ssg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nga aile kola hahani amuto sale auni hasoliai seilon ape amuto aile usiwa. ");
INSERT INTO ssg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nga kakane hawane amuto, tap tel unaui tel masiwi i pamu masiwian ti tel masiwi tetan. Tin masin tel kaui kakain, i kumahe pamu tuah ti tel taloan. ");
INSERT INTO ssg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ape amuto tioiwen tesol waliko ien. Na amuto puas usi, Haeu auni hasolia amuto.” ");
INSERT INTO ssg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Jises kakak tutuen ukek, “Waliko tenen ti lehe nga kak, kumahe nga kakak amuto hatesol. Nga tioi hawane amuto, tetesol nga kilamiwen tetak. Tuahe waliko ti lehe i sohot hoi pepai Haeu kakawen ukek, ‘Tetel i ang kapik masin ka tel lohuk xoxoan, i tale tehiton hani nga watakaiak.’ ");
INSERT INTO ssg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nga hahongo pepelei amuto lehe tataen ti i sohot, amuto soh ka nga se tetel ti nga kakaxi. ");
INSERT INTO ssg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na tel seilon hong waxi kakai tel ti nga taloma, tin masin i hong waxi kakaiak. Ape tel na i hong waxi kakaiak tin masin i hong waxi kakai tel i taloma nga.” ");
INSERT INTO ssg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Muhin ti i kak kewa, tian i kawat ape i kak hei hawane ukek, “Salan wanen, tel ti amuto i hangaini nga.” ");
INSERT INTO ssg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tesol kahikahi Jises he paxapax alia lato, ape lato to nanamiloi ka kaie i kakak aita. ");
INSERT INTO ssg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tel ti lato, tetel lohuloh ti lalu Jises pate xoxoan, i to palahah hani patanawan. ");
INSERT INTO ssg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita aile kola hani i ukek, “Kameiwa Jises i kakak aita.” ");
INSERT INTO ssg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ape tel xohixohin kapi Jises kamea, “Tel masiwi, o kakak aita?” ");
INSERT INTO ssg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ape Jises kak pahoi ukek, “Tel nga hani i teik bret ie muhin ti nga xomi haniwa tehu tone an, i tetel ien.” Salan, i xomi ape i hani Judas Iskariot, tel nati Saimon. ");
INSERT INTO ssg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Muhin wanen ti Judas ani kewa teik bret, Satan kapiti namilon. Ape Jises hone i, “Aile koseniwa waliko ti lehe o aile.” ");
INSERT INTO ssg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tap tel ti tesol kahikahi Jises ien hong xeu salangawe kakaian. ");
INSERT INTO ssg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Teka ti lato sokok ka Jises tatalo i kahuiai an ti tehu angiain ti Pasova ma na i tatalo i axiai moni hani teka laha tap soxi nake Judas i tel auniai moniulato. ");
INSERT INTO ssg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tataen ien wanen Judas nahih salili lato. Hoi ape tilokoan. ");
INSERT INTO ssg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ti Judas nahiwa, Jises kakane lato ukek, “Taun ti mateak i xohiwen. Ape teka seilon paxai tioi ka nga tel Nati Seilon se pate tuah ape laha sameni. Ape puasak aile kola hani seilon lalape poh ma solian ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nake ti tenen ien, kum kue Haeu tin i kola lalape pohek ma soliaiak tel Natun. ");
INSERT INTO ssg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tesol natuk, kumahe pate nga kue kapimuto. Nga kakane ulei amuto waliko ti nga kakanewen teka liai, amuto pax upia nga tuahe amuto kum pon lua hani tetesol ti na nga luawa. ");
INSERT INTO ssg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Tenen nauna sale wawahen ti Haeu hani seilon, nga kaxi haxewa ma haxoxo hani amuto. Amuto he wawahenawa masin ti nga waheni hawane amuto. ");
INSERT INTO ssg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Na amuto he wawahen alia amuto, i kola hani teka seilon liai ka amuto se kahikahik wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita kamei i, “Tel masiwi, o nahih kelak?” Jises pahoi i ukek, “Aope ie o kum kahiti uke nga hani tesol na nga luawa tuahe imuh o lua hani kapik.” ");
INSERT INTO ssg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita kamei i, “Tel masiwi, alahan nga kum pon kahitiam aope? Nga kum nomuha na nga mat ohoi o.” ");
INSERT INTO ssg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jises pahoi i, “Nga kum ukek. Nga kakane hawane o, imat ti tok mom wawan kokoini, o putini ka o kum tioi wanen nga uke he toluhu.” ");
INSERT INTO ssg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jises kakane tesol kahikahin, “Kum aile hahakawata namilomuto ti tuahe tenen na waliko. Namilomuto kewa xoxoan ti Haeu ma nga. ");
INSERT INTO ssg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ti tone tel Tamak Haeu kilan ing. Na kumahe salan kaie nga tai kakane amuto. Nga lua hani ien apeseniai ingamuto. ");
INSERT INTO ssg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na nga apeseni kewa nga aliama waxi amuto lehe amuto to kapik tetesol ti nga toto. ");
INSERT INTO ssg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Amuto tioi aweisal ti kane tesol nga luawa.” ");
INSERT INTO ssg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas kakane Jises, “Tel masiwi, amite kum tioi tetesol ti na o luawa ape lehe amite tioi ukek ia aweisal?” ");
INSERT INTO ssg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jises pahoi ukek, “Nga se aweisal hani tel Tamak Haeu. Nga tel kaxiai kakain salan sale Haeu ma tel haniai tonain kapin ti tap tahi tapoan. Mewenae nga se aweisal ti seilon kane tel Tamak. ");
INSERT INTO ssg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Na amuto tioi hawanewen nga, hoi amuto tioi tel Tamak. Aope ie amuto tioiwen ma ningahiwen i.” ");
INSERT INTO ssg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip ukek, “Tel masiwi, kolama tel Tamam ape tap pahamite ulea na tenen.” ");
INSERT INTO ssg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jises pahoi Pilip, “Nga to kue hawanewen kapimuto. Ala o tioiwen nga. Tel ti i paxaiwen nga, i ningahiwen tel Tamak. Aile ape alahan o ukek nga kola haniwa amuto tel Tamak? ");
INSERT INTO ssg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nakon o kum soh ka nga ma tel Tamak amili pakata hahawane ape amili masin tel? Kakain ti nga kaakane amuto kumahe ti puki namilok. Se tel Tamak, tel i to papakata kapik i ailele puasan. ");
INSERT INTO ssg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Hong sohoa ka nga ma tel Tamak amili pakata hahawane. Na amuto kapaxe kakaiak, amuto sohoa nake ti waliko lalap nga ailele ti pohe Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Nga kakane hawane amuto, tel na namilon xoxoan tetak i pon ailei waliko ti nga ailele. Tin i pon ailei waliko pamu lapan, taen ti nga alia haniwa kapi tel Tamak. ");
INSERT INTO ssg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nga aile waliko ti amuto kamei nga ti hahitake axak lehe poh ma solian ti Haeu, nga tel Natun kola. ");
INSERT INTO ssg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Na amuto kamei nga tenen na waliko ti hahitake axak, nga aile hani amuto.” ");
INSERT INTO ssg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jises kakane tesol kahikahin ukek, “Na amuto waheni nga, amuto puas usiwa nauna tetak. ");
INSERT INTO ssg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ape nga kamei tel Tamak ti haniamuto tel hakuiamuto lehe i to lian tehue kapimuto. ");
INSERT INTO ssg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","I se Holi Spirit, i kola hatesol waliko tenen salan sale Haeu. Teka seilon kumahe ti Haeu laha kum hong waxi i nake laha kum paxai tioi i. Tuahe amuto tioi i nake i se wasolamuto ape imuh i tin leilomuto tel tel ti kapitiamuto. ");
INSERT INTO ssg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ti nga lua salili amuto, kumahe nga lioi tamusuke amuto, nga alia hanima kapimuto. ");
INSERT INTO ssg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kum kue ape teka seilon kumahe ti Haeu laha kum ningahi nga tuahe amuto ningahi ulei nga. Ape kalak amuto mat, amuto moih ulea nake nga moih ulea. ");
INSERT INTO ssg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Taen ti Haeu hamoiha nga ti mateak, amuto paxai tioi ka nga ma tel Tamak amili pakata hahawane ma tin kako pakata hahawane. ");
INSERT INTO ssg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tel na i puas usi nauna tetak, i waheni nga. Ape tel na i waheni nga, tel Tamak waheni i ma tin nga waheni tel seilon ien. Ape nga kola haxewa hawane nga hani i lehe i tioi aluini.” ");
INSERT INTO ssg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, kumahe tetel Judas Iskariot, i ukek, “Tel masiwi, nake lahan o kola haxewa o hani mewenae amite a kumahe hani lawe seilon?” ");
INSERT INTO ssg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jises pahoi ukek, “Teka laha waheni nga, laha hong usi kakaiak ape tel Tamak waheni laha. Se teka ien nga ma tel Tamak to hawane kapi laha. ");
INSERT INTO ssg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Teka laha tap wawahen hani nga, laha kum hong usi kakaiak. A kakain ien kumahe ti puki namilok, se kakai tel Tamak, tel i taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nga kakane amuto tesol waliko ien ti nga tutuen kapimuto. ");
INSERT INTO ssg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tuahe Holi Spirit tel hakuiamuto, tetel tel Tamak taloma ti hahitake axak, i hanau amuto lawe waliko ma i hanamena amuto hatesol waliko ti nga kaxi haniwen amuto. ");
INSERT INTO ssg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Kum hahakawata tiamuto ti tenen na waliko ma kum maamata. Nga tel hapaui namilomuto ma tiamuto. Ti nga aile ukek, namilomuto ma tiamuto heh hawane, kumahe masin ti seilon aile hahani amuto. ");
INSERT INTO ssg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nga kakanewen amuto ka nga salili amuto tuahe nga aliama. Na salan amuto waheni nga, ala amuto amuam ti nga alia hani kapi tel Tamak tetel pamu tuah tetak. ");
INSERT INTO ssg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nga kakane amuto imat ti i sohot lehe na i sohotua hoi amuto soh kakaiak. ");
INSERT INTO ssg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Nga kum kak kue kapimuto nake Satan lehe i tohongi aile halialuak. Tuahe pohen i kum pon kui pohek. ");
INSERT INTO ssg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nga puas usi hatesol namili tel Tamak lehe lawe seilon tioi ka nga waheni i. “Ien, kako nahih.” ");
INSERT INTO ssg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jises kakane tesol kahikahin, “Nga se tea pata huan kilan ma solian ape tel Tamak Haeu i se tetel ngahatiai tea pata ien. ");
INSERT INTO ssg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lawe ngaxon tenen i kum hua, Haeu koti xaxaweni ape i sahuli hasolia ngaxon tenen i huhua lehe i sihai hakila ape hua kila. ");
INSERT INTO ssg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Amuto hoi liai masin ngaxe pata tenen laha sahuli hasoliawen nake amuto hong usi kakaiak. ");
INSERT INTO ssg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pakata xoxoa kapik ape nga pakata xox kapimuto. Tap ngaxe pata i tua hua, i hua mewenae na i papakata he tea patan. Tin masin amuto. Mewenae na amuto pakata xox kapik amuto hua kila. ");
INSERT INTO ssg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nga se tea pata huan kilan ape amuto se ngaxon. Tel na i pakata xox kapik, i hua kila. Na amuto selaia tetak, amuto kum aile uke tenen na waliko solian ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tel na i kum pakata xox kapik i masin ngaxe pata ti laha koti xaxaweni ape i aiol mat. Laha apuhini ape lui xoini hani he ah. ");
INSERT INTO ssg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Na amuto pakata xox kapik ma hong auni kakaiak, tenen na amuto kamea, nga aile hani amuto. ");
INSERT INTO ssg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Na amuto hua kila, amuto se kahikahik wanen ape waliko ti amuto aile i kola lalape poh ma soliai tel Tamak Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Nga waheni amuto masin ti tel Tamak waheni nga. Amuto pakata xoxoa kapik lehe kako to he wawahen ukek ien. ");
INSERT INTO ssg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na amuto puas usi nauna tetak, amuto waheni tatale nga masin ti nga puas usi hahatapo nauna ti tel Tamak ape nga waheni tatale i. ");
INSERT INTO ssg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nga kaakane amuto waliko ie lehe amuam tetak kapimuto ape tiamuto tin i xuh ti amuam. ");
INSERT INTO ssg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nauna tetak ie, waheniwa amuto tel tel masin ti nga waheni amuto. ");
INSERT INTO ssg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tel na i mat ukei totone tel lohun se i kola hahawane wawahen. ");
INSERT INTO ssg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Amuto se lohuk wanen na amuto usi hatapo nauna tetak. ");
INSERT INTO ssg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nga kum namiloi ukek ka amuto tuahe unauak nake tel unaui seilon i kum tioi namili tel masiwi tetan. Nga namiloi ukek ka amuto se lohuk nake nga kaxi hatakei hahani amuto lawe waliko nga hongoen ti tel Tamak Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kumahe amuto otei nga, nga otei non amuto tetak ape nga kilami amuto lehe amuto hua, huan tetenen tap tahi lialuan ma tapoan. Ape tel Tamak aile hani amuto tuahe tenen na amuto kamei ti hahitake axak. ");
INSERT INTO ssg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nga nau hahawane amuto, he wawahenawa.” ");
INSERT INTO ssg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jises kakak tutuen ukek, “Na teka seilon watakai amuto, nameniwa ka imat laha watakaimu nga. ");
INSERT INTO ssg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Na amuto tuaiwen teka seilon kumahe ti Haeu, ala laha waheni amuto. Tuahe amuto kumahe tuaulaha nake nga otei amuto ti leilolaha hani kahikahik. Aile ape laha watakai amuto. ");
INSERT INTO ssg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nameniwa ti nga kakanewen amuto, tel unaui seilon kumahe pamu masiwian ti tel masiwi tetan. Seilon axi nga kawatan ape tin laha axi kawatan hani amuto. Na laha hong usi kakaiak, tin laha hong usi kakaiamuto. ");
INSERT INTO ssg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Laha aile halialu amuto nake amuto kahikahik a laha kum tioi tetel i taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na masin nga tai kakane laha waliko tenen salan sale Haeu, tap tel tieni laha ti lialui woulaha. Tuahe laha hongoen kakaiak ape laha tioi hawane ti laha aile saun lialun. ");
INSERT INTO ssg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Teka laha watakai nga, tin laha watakai tel Tamak. ");
INSERT INTO ssg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na nga tai aile waliko tenen lalap ti pohe Haeu, tap tel pon tienialaha ti lialui woulaha. Tuahe kalak laha ningahiwen, laha watakai ati amili tel Tamak. ");
INSERT INTO ssg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Wawatak ti laha ien i sohot ti hapoponowiai waliko ti pepai Haeu kakawen. I ukek, ‘Laha watakai nga ti tap wanen huan.’ ");
INSERT INTO ssg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Taen ti Holi Spirit tel hakuiamuto tahiama, tetel i ahuma ti Haeu ma i kak hatakei lawe waliko salan sale Haeu, i kaxi haxewa nga hani amuto. ");
INSERT INTO ssg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ape tin amuto kaxi haxewawa nga hani seilon liai, pake amuto se kapik ti uli hutui puasak.” ");
INSERT INTO ssg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jises kaakane tutuen tesol kahikahin ukek, “Nga kaxi hahani amuto ukek ien lehe xoxoi namilomuto tetak i kum put. ");
INSERT INTO ssg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Laha xaxaweni tamusuke amuto ti synagog ape taun i luluainima ti teka seilon laha telei amuto laha namiloi ukek ka saun tenen ien i kola ka laha se unaui Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Laha aile ukek ien hani amuto nake laha kum tioi amili tel Tamak. ");
INSERT INTO ssg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tesol waliko ien nga kaxi hahani amuto aope ie lehe ti na i sohot, amuto nameni kakaiak. Nga tai kaxi hani amuto ti imat nake nga kapimuto ma tap tel aile halialu amuto. ");
INSERT INTO ssg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Aope ie nga alia hani kapi tel i taloma nga tuahe tap tel ti amuto i kamei nga tetesol ti na nga lua hani. ");
INSERT INTO ssg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tiamuto xuhai tatahan nake ti waliko nga kakanewen amuto. ");
INSERT INTO ssg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nga kakane hawane amuto, ti solian ti amuto pamu ewi nga salili amuto nake na nga kum alia hani kapi tel Tamak, Holi Spirit tel hakuiamuto i kum tahia hani kapimuto. Tuahe na nga salili amuto, muhin nga talo i hanima kapimuto. ");
INSERT INTO ssg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ape na i tahiama i sehatuhini hani teka seilon ka laha ailele saun lialun. Tin i kak haxewa sale aweisal ti laha sohot seilon sawisawin ti Haeu ma sale Haeu axi kawatan ti lialui woulaha na laha kum towiahu ti saun ien ape usi i. ");
INSERT INTO ssg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Holi Spirit kola hani teka seilon ka laha ailele saun lialun nake laha kum soh tetak. ");
INSERT INTO ssg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","I kola haxewa ka laha sohot seilon sawisawin na laha soh tetak. Nga lua hani kapi tel Tamak nake nga tel pate sawisawin. Ape amuto kum ningahi ulea nga. ");
INSERT INTO ssg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Holi Spirit kola ka Haeu hoi i namiloiwen ukek ka i axi kawatan hani Satan tel neini halialui seilon ma hani teteka ti ailei saun lialun. ");
INSERT INTO ssg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Kilan kakaiak tutuen ti kakaneamuto tuahe kilan kasia ti na amuto hong xeu lape tehue. ");
INSERT INTO ssg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tuahe tataen Holi Spirit tahiama, tetel i kola lawe waliko salan sale Haeu, i neini amuto ti tioiai Haeu. Kumahe i kakak ti puki namilon, i kakaxi waliko tenen i hong ti Haeu ape i kakane amuto waliko ti luluainima tutuen. ");
INSERT INTO ssg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","I kaxi hani amuto waliko ti nga kaxi hani i ape i kola lalape pohek ma soliaiak. ");
INSERT INTO ssg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Hatesol waliko ti tel Tamak hina se tetak, aile ape waliko ti nga kaxi hani Holi Spirit, i kaxi hani amuto.” ");
INSERT INTO ssg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jises ukek, “Kum kue ape amuto kum ningahi nga ape tin kum kue amuto ningahi ulea nga.” ");
INSERT INTO ssg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Teka ti tesol kahikahin he kamekam, “Salangawe kakaian ukek ia ti i kaakane kako ka kum kue ape kako kum ningahi i ape tin kum kue kako ningahi ulea i? Salangawe kakaian ukek ia ti i kaakane kako ka i sohot ukek ien nake i lua hani kapi tel Taman?” ");
INSERT INTO ssg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Lato he kamekam tutuen, “Salangawe tenen kakain ‘kum kue’ i ukek ia? Kako kum xeu waliko tenen i kakak.” ");
INSERT INTO ssg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jises tioiwen ka pahalato lato kamei i ape i ukek, “Nakon amuto he kamekam salangawe waliko ti nga kakak? ");
INSERT INTO ssg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nga kakane hawane amuto, amuto tang tahane taen ti teka seilon laha kumahe kahikahik laha amuam. Amuto to leili tatahan tuahe imuh tatahan ti amuto towiahu hani lalape amuam. ");
INSERT INTO ssg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Masin tel hehin ti lehe i hatakaha natun, i ilamenimu moloan ape imuh i amuam nake i hatakahawen tel akaik. ");
INSERT INTO ssg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tin masin amuto, amuto toto leili tatahan tuahe taen nga ningahi ulea amuto, tiamuto amuam hawane. Tap tel i pon xaxaweniai amuam ien leili tiamuto. ");
INSERT INTO ssg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Taun tehu ien, amuto kum kamei ulea nga na tenen. Nga kakane hawane amuto, tel Tamak Haeu aile hani amuto tuahe tenen na amuto kamei i ti hahitake axak. ");
INSERT INTO ssg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hanima tataen aope amuto tai kamea ukek ien. Kameiwa Haeu hahitake axak lehe i hani amuto ape amuto amuam hawane. ");
INSERT INTO ssg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nga hahapuasa meng tenen tenen ti nga hanau amuto tuahe taun tehu i luluainima ti nga kaxi hei hani amuto sale tel Tamak Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tataen ien amuto kamei i ti hahitake axak. Nga kum ukek nga tuke awamuto ti kameian. ");
INSERT INTO ssg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Puki tel Tamak Haeu waheni amuto nake amuto waheni nga ape amuto soh ka nga ahuma tetan. ");
INSERT INTO ssg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nga ahuma ti tel Tamak Haeu hani tehu pon itan ie ape aope ie nga lua salili tehu pon ie hani kapi tel Tamak.” ");
INSERT INTO ssg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ape tesol kahikahin ukek, “Aope ie o kaxi haxewa hawanewen, kumahe o hahapuasa meng hanowi ti imat. ");
INSERT INTO ssg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Aope ie amite tioiwen ka o tioi lawe waliko, ape tap i hapuasa amite kameiam. Ti nake tenen ien amite soh ka o ahuma ti Haeu.” ");
INSERT INTO ssg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jises kakane lato ukek, “Aope ie amuto soh. ");
INSERT INTO ssg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tuahe tehu taun i luluainima, a se hoi liai i tahiawen, ti amuto ox salili nga hani tonamuto. Tuahe nga kumahe lioan nake tel Tamak se kapik. ");
INSERT INTO ssg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nga kakane amuto waliko ie lehe namilomuto ma tiamuto i ewi hawane ti amuto pakata xox kapik. Ti tehu pon ie amuto tunahi kilan kawatan tuahe tu xoxoa. Nga waxainiwen pohe Satan ma lawe waliko lialun.” ");
INSERT INTO ssg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ti Jises kakane kewa tesol kahikahin, i pax hani patul ti tone Haeu ape i lotu ukek, “Tel Tamak, taun tetak i meiwen ti nga mat ma xahat alia. Kola haniwa lawe seilon lalape pohek ma soliaiak nga tel Natum lehe nga kola hani laha lalape pohem ma soliaiam. ");
INSERT INTO ssg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pake o hana nga Masiwi ti lawe seilon lehe nga axi tonain kapim ti tap tahi tapoan hani teteka seilon o hana hahitake ngangahatak. ");
INSERT INTO ssg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Lato uke tonain kapim ti tap tahi tapoan na lato tioi hawane o, tel Haeu salan ma nga Jises Krais tel o taloma. ");
INSERT INTO ssg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nga kola haniwen teka seilon lalape pohem ma soliaiam ti nga aile hatapo puasain ti o hahani nga ailean. ");
INSERT INTO ssg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tel Tamak, aope ie kola haniwa laha lalape pohekalu ma soliaiakalu, i se hoi liai ti kalu, imat ti hutuiai tehu pon itan ie. ");
INSERT INTO ssg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nga kaxi haxewawen o hani tesol kahikahik, tetesol o waxi ahuti ti leili teka seilon laha kumahe tetam ape o hana lato hahitake ngangahatak. Lato hoi lawe tetam. O aile lehe lato sohot kahikahik ape lato hong usi kakaiam. ");
INSERT INTO ssg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aope ie lato tioi ka lawe waliko ti o hani nga, i ahuma tetam. ");
INSERT INTO ssg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nga kaxi hani lato waliko ti o kaxi haniwen nga ape lato hong waxi kakaiakalu. Lato tioi hawane ka nga ahuma tetam ape lato soh ka o taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nga lotu huhuali lato. Aope ie kumahe nga lotu huhuali teka seilon laha kumahe tetam, nga lotu huhuali tetesol o hana hahitake ngangahatak nake lato seilon tetam. ");
INSERT INTO ssg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Lawe seilon tetak se tetam ma lawe seilon tetam se tetak. Ape sale pupuasalato i kola lalape pohek ma soliaiak. ");
INSERT INTO ssg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kum kue nga lua salili tehu pon itan ie hani kapim tuahe lato tiliwen ie wasole teka seilon laha kumahe tetam. Tel Tamak pate tuah, ti lalape pohem awaiwa lato, ti poh tetenen o haniwen nga lehe lato pakata xox hetekie hanowi kalu. ");
INSERT INTO ssg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ti nga kapi lato ie, nga hahapuasa pohem ti awaialato ape tap tel ti lato i selaia ti nenein tetam mewenae Judas Iskariot. I tetel lioan, hoi i kau kawatan ti lialui woun lehe kakain ti he leili pepaum sohot poponowi. ");
INSERT INTO ssg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Aope ie nga alia hani kapim. Nga kakak tesol waliko ie ti nga tutuen he tehu pon itan lehe lalape amuam tetak tin he tialato. ");
INSERT INTO ssg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nga kakanewen lato kakaiam ape teka seilon laha kumahe tetam laha watakai hawane lato nake lato ape kumahe tuaulaha. Nga tin kumahe tuaulaha. ");
INSERT INTO ssg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kumahe nga kamei o ti waxi ahutialato ti leilolaha tuahe nga kamei o ti awaialato ti Satan. ");
INSERT INTO ssg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Salan wanen, tesol kahikahik lato kumahe tuai teka seilon laha kumahe tetam masin ti nga kumahe tuaulaha. ");
INSERT INTO ssg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Hapuasawa kakaiam ti hualialato lehe lato sohot unauam wanen ti ailei pupuasam. Pake kakaiam pate salan. ");
INSERT INTO ssg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Masin ti o taloma nga hani tehu pon ie ti ailei pupuasam, tin nga talo lato hani tesol tesol ti ailei pupuasam. ");
INSERT INTO ssg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nga hani hatapo nga unauam wanen lehe tin lato sohot unauam wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kumahe nga lotu huhuali mewenae tesol kahikahik kapik, tin nga lotu huhuali hatesol teka laha soh tetak ti laha hong soh kakai tesol kahikahik. ");
INSERT INTO ssg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tel Tamak, nga lotu huali laha hatesol lehe laha pakata xox hetekie hanowi kalu, ape tin laha pakata xox kapi kalu lehe teka seilon soh ka o taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Nga hani laha pohem ma soliaiam ti o haniwen nga lehe laha pakata xox hetekie hanowi hawane kalu. ");
INSERT INTO ssg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ape tin nga pakata xox kapi laha masin ti o pakata xox kapik lehe ti xoxoi pakataialaha laha sohot hanowi seilon tel. Ien i kola hawane hani teka seilon laha kumahe tetam ka o taloma nga ma o waheni hawane laha masin ti o waheni hawane nga. ");
INSERT INTO ssg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tel Tamak, pahak wanen ka teka seilon o hana hahitake ngangahatak, lato lawe kapik lehe lato ningahi lalape pohek ma soliaiak ti o hani nga nake hoi o waheni nga imat ti hutui tehu pon itan. ");
INSERT INTO ssg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tel Tamak, tel pate sawisawin, teka seilon kumahe tetam laha kum tioi o tuahe nga tioi hawane o ma teka kahikahik tioi ka o taloma nga. ");
INSERT INTO ssg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nga kola haxewawen o hani lato ape nga kola tatale lehe lato waheni seilon liai masin ti o waheni nga ape wawahen tetak hamalum leilolato tel tel.” ");
INSERT INTO ssg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Muhin ti Jises lotu kewa, i ma tesol kahikahin nahih hani tesol axan Kitron Vali. Ti ien, lato soh hani leili tesol kini oliv. ");
INSERT INTO ssg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, tetel imuh i hangaini Jises hani teka seilon teleian, i tioi tetesol kin nake Jises ma tesol kahikahin nahih hakila hani ien. ");
INSERT INTO ssg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ape Judas nahih hani tetesol kin. Kahitiwa i tesol seilon ti hile ti Rom, tesol unaui teka masiwi tuah ti hukuminiai Haeu ma seilon ma tesol unaui teka Parisi. Laha kakau paulaha, lul ma kamaialaha liai. ");
INSERT INTO ssg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jises hoi i tioi lawe waliko ti lehe i sohot hani i. Kakanua i nahih kouke hani mateiwaulaha ape i kamea, “Amuto upiup aita?” ");
INSERT INTO ssg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Laha ukek, “Jises ti Nasaret.” Ape Jises kak pahoi, “Se nga.” Judas tetel hangainian tin i tutu kapi laha ien. ");
INSERT INTO ssg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ti Jises ukek, “Se nga,” laha sue alia ape laha put hani itan. ");
INSERT INTO ssg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jises kamei ulea laha, “Amuto upiup aita?” Laha ukek, “Jises ti Nasaret.” ");
INSERT INTO ssg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jises hone laha, “Nga kakanewen amuto ka se nga tetel. Na masin salan amuto upiup nga, amuto hanahi lioiwa tesol kahikahik, tiliwen lato nahih taha.” ");
INSERT INTO ssg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","I kak ukek ien lehe kakain ti i kakawen i sohot poponowi ti i ukek, “Tel Tamak, nga awai teka seilon o haniwen nga, tap tel seilon i pon waxi xaxawenialato ti ngahat tetak.” ");
INSERT INTO ssg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Taen ien Saimon Pita itini ahuti tea ngolun weluwelun. I kaheni ape i koti haputa taxingi Malkus, tel ti tesol unaui tel masiwi tapein ti hukuminiai Haeu ma seilon. I koti tose tepaun taxingan manau. ");
INSERT INTO ssg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tuahe Jises hone Pita, “Hana aliakewa tea ngolum haniwa he ingan. Liai nga kau kawatan ti tel Tamak namiloiwen nga kau.” ");
INSERT INTO ssg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ape tesol seilon ti hile ti Rom hetekie tel masiwi ti laha ma teka peteniai Ingi Haeu, laha xioti Jises. ");
INSERT INTO ssg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Imat laha hakahita i hani kapi Anas, tel wawan ihai Kaiapas. Kaiapas i masiwi tapein ti hukuminiai Haeu ma seilon ti ahang tehu ien. ");
INSERT INTO ssg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","I tetel kemuk i kakane teka masiwi ti teka Ju ka pamu ewian na seilon telawe mat ti awaiai lawe seilon ti matemate. ");
INSERT INTO ssg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita ma tel kahikahi Jises liai, lalu nahih usi Jises ma tesol hakahitaian. Tetel kahikahin liai ien, laha sowini i soh hani tesol mate ingi Kaiapas, tel masiwi tapein ti hukuminiai Haeu ma seilon nake Kaiapas tioi i. ");
INSERT INTO ssg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita tutuen melal kapi aweing. Aile ape tetel kahikahi Jises liai alia hani kapin ape i hone tel hehin pepeteni aweing hasohoi Pita. ");
INSERT INTO ssg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tel hehin ien kamei Pita, “Nakon o kumahe se tel ti kahikahi tel seilon Jises?” Pita pahoi ukek, “Kumahe.” ");
INSERT INTO ssg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tesol unaui Kaiapas ma teka peteniai Ingi Haeu, lato tu kakalini tehot ah hahiai tinulato nake pate waiwain. Ape Pita tin i nahih tu akati lato hahiai tinun. ");
INSERT INTO ssg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ti lokon ien Anas kakamei Jises sale tesol kahikahin ma waliko ti i hahanau teka seilon. ");
INSERT INTO ssg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jises kak pahoi i ukek, “Lawe nga kak hehei ti taxingi seilon. Nga hahanau laha leili synagog ma leili Ingi Haeu, tetesol ti teka Ju apuha hehetekie. Nga kum kak mumuneni tenen na waliko. ");
INSERT INTO ssg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ape nake lahan o kamei nga ukek ien? Kameiwa teka laha hongoen kakaiak. Liai laha tioi waliko ti nga kakaxi.” ");
INSERT INTO ssg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ti Jises kak kewak ien, tel ti tesol peteniai Ingi Haeu tapahi i ape i ukek, “Kalahai o towi kakain tenen masin ien hani tel masiwi tapein ti hukuminiai Haeu ma seilon?” ");
INSERT INTO ssg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jises pahoi i ukek, “Na masin nga kakawen waliko kumahe salan, kola sehatuhinima. Tuahe na nga kakawen kakain salan, nake lahan o tapahi nga?” ");
INSERT INTO ssg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ape Anas talo Jises ti i xiotan tutuen hani kapi Kaiapas tel masiwi tapein ti hukuminiai Haeu ma seilon. ");
INSERT INTO ssg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Lokon ien Saimon Pita tutu tutuen kapi teka seilon pape tehot ah ape lato kamei i, “Nakon o kumahe se tel ti kahikahi tel seilon Jises?” Pita pahoi ukek, “Kumahe.” ");
INSERT INTO ssg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Leilolato tel unaui Kaiapas, i akiki tel seilon Pita koti tose taxingan ti leili kini oliv. I kamei Pita, “Nakon o kumahe se tetel nga ningahi kapi Jises leili kini oliv?” ");
INSERT INTO ssg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita ase ulea ka i kum tioi Jises. Ape ti lokon ien wanen tok mom wawan kokoiniwa. ");
INSERT INTO ssg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ti pate uli letu, laha hakahita Jises ti ingi Kaiapas hani tehu ingi Pailat, tel ti teka masiwi ti Rom. Tuahe hahalin ti teka Ju soh hani tehu ing ien nake se ingi teka kumahe Ju. Na laha soh, laha kum pon aniai an ti Pasova nake laha ape lolo. ");
INSERT INTO ssg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Aile ape Pailat nahih sohot hani kapi laha ape i kamea, “Pahamuto sului tel seilon ie ti waliko la?” ");
INSERT INTO ssg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Laha kak pahoi ukek, “Na masin i kumahe tel seilon ti ailei saun lialun kaie pake amite kum hakahita hanima kapim.” ");
INSERT INTO ssg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat hone laha ukek, “Kaien puki amuto waxi suluiwa i usiwa puki nauna ti amuto.” Laha kakane i ukek, “Amite hahalin wanen ti teleiai tel na seilon.” ");
INSERT INTO ssg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Waliko ien i sohot lehe kakain ti Jises kakak sale matean i sohot poponowi. ");
INSERT INTO ssg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailat nahih alia hani leili ing ape i hone tesol unauan hakahitai Jises hani kapin. Ape i kamei i, “Nakon o se tel masiwi tapein ti teka Ju?” ");
INSERT INTO ssg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jises ukek, “Nakon o kakamei nga ti puki namilom ka teka liai kaxi hani o nga?” ");
INSERT INTO ssg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat pahoi ukek, “Kumahe namilok. Nga kumahe tel Ju. Puki teka akikim ma teka masiwi tuah ti hukuminiai Haeu ma seilon laha hana o hani he minak. Waliko la tenen lialun o ailewen?” ");
INSERT INTO ssg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jises ukek, “Na masin nga masiwi ti tuahe namili seilon, hoi teka unauak hil awaiwen nga ti mini teka Ju masiwi ti amite. Tuahe kumahe puki seilon hana nga masiwi.” ");
INSERT INTO ssg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ape Pailat ukek, “Kaien o se tel masiwi tapein, kewak?” Jises pahoi i ukek, “Puki o ukek nga masiwi tapein. Nga takah hanima tehu pon ie ti kola hatake haniai seilon waliko tenen salan. Hatesol teka laha waheni waliko tenen salan, laha hong usi kakaiak.” ");
INSERT INTO ssg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ape Pailat kamei i, “A waliko la tenen salan?” Muhin ien Pailat nahih alia hani melal kapi teka seilon ape i hone laha ukek, “Nga tai upia tunah tenen ti i pon suluan. ");
INSERT INTO ssg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tuahe ti usiai saun ti amuto, lawe nga oxoxi ahuti tel ti teka kalabus hani amuto ti taun ti Pasova. Kaie pahamuto nga oxoxi ahuti tel masiwi tapein ti amuto teka Ju?” ");
INSERT INTO ssg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Laha ausini eliliel ukek, “Kumahe! Kumahe i! Pahamite Barabas!” Barabas i tel ti teka Ju laha hil pahoi teka masiwi ti kiliwakei xuxulaha. ");
INSERT INTO ssg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Muhin ien Pailat hani teka unauan ti hile heti Jises. ");
INSERT INTO ssg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Lato alingini ngaxe au ape nihini hana hani he patun. Lato sosoi i teik maia tenen kakai ati polun. ");
INSERT INTO ssg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Lato kak soxeni i ukek, “Tel masiwi tapein ti teka Ju tap tahi mateam!” Ape lato tapahi tuhituhi i. ");
INSERT INTO ssg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat nahih ulea hani kapi teka seilon laha apupuha ape i kak ukek, “Nga atoheni i hani amuto. Tuahe amuto tioi kewak nga tai tunahi tenen na waliko lialun ti i pon suluan.” ");
INSERT INTO ssg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Laha hasohotu Jises hani melal. Ngaxe au alinginian he patun ma teik soson maia kakai ati polun. Ape Pailat kak ukek, “Paxaiwa tel seilon ti amuto susului.” ");
INSERT INTO ssg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Teka masiwi tuah ti hukuminiai Haeu ma seilon ma teka peteniai Ingi Haeu paxaiwa Jises ape lato leng ausisini, “Tahi hakea i haniwa he kros!” Tuahe Pailat ukek, “Puki amuto tahi hakeawa i. Nga tai upia tunah waliko tenen lialun i ailewen.” ");
INSERT INTO ssg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Teka laha apupuha ien tilol pahoi i ukek, “Tenen nauna ti amite ukek ka liai i mat nake i kakaxi ka i tel Nati Haeu.” ");
INSERT INTO ssg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ti Pailat hongoa, i mamata hawane. ");
INSERT INTO ssg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","I hakahita aliake Jises hani leili ing ape i kamei i, “A o seilon ti ia?” Tuahe Jises tai wix pahoi. ");
INSERT INTO ssg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailat hone i, “Nake lahan o kum wix pahoi nga? O tioi kewak, i pon na nga oxoxi o ma na tahi hakea o.” ");
INSERT INTO ssg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ape Jises ukek, “Na Haeu tai sowini hani o, o kum pon ailean. Aile ape tel seilon i hana nga hani he minam, i aile saun pamu lialuan ti o aile.” ");
INSERT INTO ssg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ti Pailat hong kewak ien, i tohongi oxoxi ahuhuke Jises. Tuahe teka seilon ien leng ausini ukek, “Na masin o oxoxi ahuti tel seilon ie, o kumahe lohi Sisa. Tel na i ukek i se tel masiwi tapein, i pahoxai Sisa tel masiwi tapein ti Rom.” ");
INSERT INTO ssg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ti Pailat hongoa kakain ien i hakahita aliake Jises hani melal ti mateiwai teka seilon ape i to hani tesol totoan ti hong paxaiai kakain, ti kakai Arameik laha axai, Gabata. Tenen kakain ien ukek, “Tesol Pot.” ");
INSERT INTO ssg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Waliko ien i sohot ti tehu ngain ti apesenialaha ti Pasova. Ti sai lape ngain, Pailat kakane teka seilon, “Tel masiwi tapein ti amuto ie!” ");
INSERT INTO ssg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Laha tilol pahoi Pailat, “Teleiwa i! Teleiwa i! Tahi hakea i haniwa he kros! Pailat kamei lato, “Kaie pahamuto nga telei tel masiwi tapein ti amuto?” Teka masiwi tuah ti hukuminiai Haeu ma seilon pahoiwa, “Masiwi ti amite mewenae Sisa.” ");
INSERT INTO ssg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pailat kakanua i hani Jises he minalaha lehe laha tahi hakea i hani he kros. Ape teka seilon ti hile waxi Jises. ");
INSERT INTO ssg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ape laha nahih hahaniwa tesol axan Golgota. Teik kakain ien ti kakai Arameik. I ukek, “Tetesol tanoman masin kui pati seilon.” Puki Jises kakau teik kros pata. ");
INSERT INTO ssg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ti tesol ien laha tahi hakea i hani he teik kros i kakau. Tin laha tahi hakea hua seilon, tel sai tepaun, tel liai tepaun ape Jises patalal ti lalu. ");
INSERT INTO ssg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ti hahitake axe Pailat teka seilon ti hile tahi hakea teik kakain onote pati Jises. I ukek, “Jises ti Nasaret, tel Masiwi Tapein ti teka Ju.” ");
INSERT INTO ssg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kilan wanen seilon paxaiwen kakain ien nake tetesol ti Jises akeak xohixohin tehu taon lalap a kakain ien laha tai ti kakai Arameik, Latin ma Grik. ");
INSERT INTO ssg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Teka masiwi tuah ti hukuminiai Haeu ma seilon hone Pailat, “Kumahe i tel Masiwi Tapein ti teka Ju. Tai sohi kewak, tel seilon ie i ukek i Masiwi Tapein ti teka Ju.” ");
INSERT INTO ssg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat pahoi ukek, “Waliko ti taiwen tiliwen masin ien.” ");
INSERT INTO ssg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Muhin ti teka seilon ti hile tahi hakea kewa Jises, lato sei tesol maia Jises sosoi wasolalato seilon hinalo. Lato waxi hetekie tehu atuhiai puxuaun tuahe i maia teikawe ape lato kum pon seian. ");
INSERT INTO ssg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aile ape lato ukek, “Kako kum lexi sei. Kako halokeni satu upiai tel waxian.” Waliko ien i sohot haponowiai teik kakain leili pepai Haeu. I ukek, “Lato sei tesol sosok maia wasolalato ma halokeni satu waxiai tehu atuhiai puxuauk.” Ape salan, tesol seilon ti hile aile ukek ien. ");
INSERT INTO ssg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tutu xohixohin kapi teik kros se tel tini Jises, tel tuai tel tinan, Mary tel axoi Klopas ma Mary Magdalen. ");
INSERT INTO ssg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ti Jises paxaiwa tel tinan tutu ien kapi tel kahikahin lohun pate xoxoan, i ukek, “Tel tinak, o kewa tel seilon ie masin natum wanen.” ");
INSERT INTO ssg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ape Jises kakane tel kahikahin ien, “I se ape tinam.” Hutui tataen ien tel kahikahin waxi auni i. ");
INSERT INTO ssg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jises tioi ka hatesol puasain ti tel Taman talo i aile ape i hatapoen. Lehe kakain ti pepai Haeu i sohot poponowi, Jises ukek, “Kinawek paxepaxen, pahak nga un.” ");
INSERT INTO ssg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tehu peti waen wangingian ien, aile ape laha xomi hawaxexa teik maia hani he waen, laha hana hani teik tumi ngaxe pata axan hisop ape tulini hani he singi awan. ");
INSERT INTO ssg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ti Jises namihiniwa i ukek, “Pupuasak nga hatapoen!” I lakuini patun ape i hana aliake i hani he mini Haeu. ");
INSERT INTO ssg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Telao ien ngain ti apesenialaha ti Sabat ape Sabat tehu ien se ngain lalap ti tehu Pasova. Aile ape teka masiwi ti teka Ju watakai tupui tesol seilon ien akeak tutuen he kros telao Sabat. Laha kamei Pailat na i sowini hani teka unauan ti hile xai otohi ae tesol seilon ien lehe lato mat kosea ape laha hamosu tupualato hani itan. ");
INSERT INTO ssg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ape tesol unaui Pailat ti hile nahih xai otohi ae huhua seilon laha tahi hahakea kapi Jises. ");
INSERT INTO ssg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ti lato tahia haniwa kapi Jises, lato ningahi ka i matewen ape lato kum otohi aen. ");
INSERT INTO ssg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tuahe tel ti tesol seilon ti hile tapuhi pope Jises tehu samen ape kaka ma kan xiweu ahuta hahutuia. ");
INSERT INTO ssg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tetel i ningahiwen waliko ti i sohot ien i kakaxi waliko salan. I tioi waliko ti i kakaxi se salan. I kaxi waliko tenen ien lehe tin amuto soh ti Jises. ");
INSERT INTO ssg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tesol waliko ien i sohot haponowiai teik kakain leili pepai Haeu, i ukek, “Tap tea na kuin laha otohi.” ");
INSERT INTO ssg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tin i haponowia teik kakain liai leili pepai Haeu i ukek, “Teka seilon paxai tetel laha tapuhi.” ");
INSERT INTO ssg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Muhin ien Josep ti tehu taon Arimatea kamei Pailat na i waxi auni tupui Jises. Josep i tel kahikahi Jises tuahe i puluhini nake i mamata teka masiwi ti teka Ju. Ti Pailat sowini haniwa Josep, i waxi tupui Jises. ");
INSERT INTO ssg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimus, tetel kemuk ipong tehu i nahih paxai Jises, i kahiti Josep kau hehetekie 33 kilo mer ma aloes, waliko tenen masin sanda poun pate solian. ");
INSERT INTO ssg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ape lalu waxi mer ma aloes hetekie teik maia weluwelun ape puxui talini tupui Jises. Lalu aile ukek usiai saun ti teka Ju sale tihiniai seilon maten. ");
INSERT INTO ssg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tetesol laha tahi hahakea Jises xohixohin kapi tesol kin. Leili tesol kin ien tehu amal haun, tenen laha tanomi he pot patul ti hepekeun. Laha tai hahana tupui seilon maten ien. ");
INSERT INTO ssg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Lalu hana Jises ien nake tehu amal xohixohin a ngain tetehu ien se ti apesenialaha ti Sabat. ");
INSERT INTO ssg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pate letu ti Sande, ti tilokoan tutuen, Mary Magdalen nahih hani tehu amal ape i ningahi tehu pot laha uke siponiai amali Jises ape hulinan. ");
INSERT INTO ssg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aile ape i kiliwau hani kapi Saimon Pita ma tel kahikahi Jises liai, tel lohun xoxoan. I ukek, “Laha waxi ahutiwen tupui tel masiwi ti leili amal ape amite kum tioi tesol laha hahana i!” ");
INSERT INTO ssg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ape Pita ma tel kahikahi Jises liai lalu lua hani tehu amal. ");
INSERT INTO ssg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ati lalu kikiliwau tuahe tel kahikahi Jises liai i pamu nahiaian ape i tahia imat hani amal. ");
INSERT INTO ssg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","I teha wana ape i ningahi maia ti laha pupuxui Jises tuahe i tai soh hani leilon. ");
INSERT INTO ssg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita, tel i usima muhin, i tahiawa ape i soh hani leilon. Tin i ningahi teik maia puxuiai tupui Jises ien. ");
INSERT INTO ssg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Teik maia laha tatalini patun, i toto tanenan kumahe kapi maia liai. ");
INSERT INTO ssg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ape tel kahikahi Jises i tahiamu imat he amal, tin i soh hani leilon. I ningahi waliko ti leili amal ape i soh ka Jises moih aliawen. ");
INSERT INTO ssg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tuahe kalak tataen ien tesol kahikahi Jises tai xeu tutuen teik kakain ti pepai Haeu kakaxi ka Jises moih alia ti matean. ");
INSERT INTO ssg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Muhin ien huhua kahikahi Jises nahih alia hani tonalalu. ");
INSERT INTO ssg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary tu tangitang melal ti tehu amal. I tang teha wana hani leilon. ");
INSERT INTO ssg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ape i ningahi hua engel puxuaulalu pate papaxaxun. Lalu toto tesol kemuk laha hahana tupui Jises, tel onote patun ma tel onote aen. ");
INSERT INTO ssg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lalu kamei i, “O tatangike la?” I pahoi lalu ukek, “Laha waxi ahutiwen tel masiwi tetak, nga kum tioi laha hahana i ia!” ");
INSERT INTO ssg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","I kak kewa ape i tohea. I ningahi Jises tutu ien, tuahe i kum ila tioi i. ");
INSERT INTO ssg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jises kamei i, “O tatangike la? O paxai upiup aita?” Mary sokok i tel seilon ti lawe i pupuas leili tesol kin ien. I ukek, “Tel masiwi, na o waxi ahutiwen tupui Jises, kaxi hanima nga tesol ti o hahana i lehe nga waxi auni.” ");
INSERT INTO ssg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jises ukek, “Mariam!” I tiloi axan ti Arameik, puki kakaialalu. Mary hongoa ape tohea pahoi i. Tataen ien i paxai tioi Jises ape tin i hapuasa kakai Arameik i ukek, “Raboni!” Teik kakain ien i ukek, tel Hanaui seilon. ");
INSERT INTO ssg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jises hone i, “Kum aka hahaxomu tetak, nga tai alia hani kapi tel Tamak Haeu. Tuahe nahih haniwa kapi tesol kahikahik. Honewa lato kum kue nga alia hani kapi tel Tamak i se tin Tamalato, tel Haeu tetak i se tin Haeu tel Masiwi ti lato.” ");
INSERT INTO ssg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalen nahih hani kapi tesol kahikahin ape i ukek, “Nga ningahiwen tel Masiwi!” Ape i kakane lato kakain ti Jises hohone i. ");
INSERT INTO ssg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Alohah ti telao Sande ien, tesol kahikahi Jises apupuha leili tehu ing, aweing konginan nake lato mamata teka Ju liai. Lokon ien Jises take hani kapi lato ape i ukek, “Amuam ti Haeu kapimuto.” ");
INSERT INTO ssg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ti i kak kewak ien, i kola hani lato minan ma popon. Tesol kahikahi Jises amuam hawane ti lato ningahiwa tel Masiwi. ");
INSERT INTO ssg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jises kak ulea ukek, “Amuam ti Haeu kapimuto. Masin ti tel Tamak Haeu taloma nga ailei puasan, tin nga talo amuto.” ");
INSERT INTO ssg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Muhin ien i uhui aupolun hani lato ape i ukek, “Amuto kewa Holi Spirit. ");
INSERT INTO ssg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Na amuto oxoxi teka seilon ti kawatan ti saun lialun ti laha aile hani amuto, Haeu tin i oxoxi laha ti kawatan ien. Na amuto kum oxoxi laha ti kawatan ti saun lialun ti laha, Haeu tin i kum oxoxi laha.” ");
INSERT INTO ssg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas, tel ti tesol huopanim huhua kahikahi Jises, tin laha axai i Sangasang, i kumahe ien lokon ti Jises take hani kapi tesol kahikahin liai. ");
INSERT INTO ssg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ape lato kakane i ukek, “Amite ningahiwen tel Masiwi!” Tomas pahoi ukek, “Nga kum soh, halik na nga paxai mahe tuhi nil he minan ma nga soti mahe naxon he popon.” ");
INSERT INTO ssg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Muhi puasain tehu, tesol kahikahi Jises hukuma ulea leili ing ape Tomas tin kapi lato. Kalak aweing konginan, Jises take tu hani kapi lato. I ukek, “Amuam ti Haeu kapimuto.” ");
INSERT INTO ssg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ape i kakane Tomas, “Paxaima minak. Sotima mahe tuhi nil ape sotima mahe naxon he popok. Kum kakapaxe, soh hawanema tetak.” ");
INSERT INTO ssg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas paxai tioiwa ape i kak eliel hawane, “O se Masiwi tetak ma Haeu tetak!” ");
INSERT INTO ssg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jises kakane i, “O soh nake o ningahi hawane nga. Tuahe teka laha tai ningahi nga a laha soh tetak, Haeu aile hasolia hawane hani laha.” ");
INSERT INTO ssg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Tesol kahikahi Jises tin lato ningahi kilan waliko tenen pate lalap liai Jises aile ti pohe Haeu tuahe tap leili teik pepa ie. ");
INSERT INTO ssg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tuahe tetesol ti leili pepa ie nga tai lehe amuto soh ka Jises i se Krais tel Nati Haeu ape ti xoxoi namilomuto tetan, amuto uke tonain kapi Haeu ti tap tahi tapoan. ");
INSERT INTO ssg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Muhin ien Jises take ulea hani tesol kahikahin. I sohot ukek. ");
INSERT INTO ssg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Lokon ien tepanim hua ti lato pape kanitax Galili, axan liai tenen Taibirias. Lato tetesol ien se Saimon Pita, Tomas tel laha axai Sangasang, Nataniel tel ti Kana ti Galili, hua nati Sebedi ma hua kahikahi Jises liai. ");
INSERT INTO ssg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita kakane tesol liai, “Nga lua teletel xixi.” Lato ukek, “Amite mahoi o.” Ape lato ku hani he tea koap tuahe lato tai tiuk xixi ipong hatehu. ");
INSERT INTO ssg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ti i ninitinile, Jises tutu ngixi peixux tuahe tesol kahikahin kum ila tioi i. ");
INSERT INTO ssg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ape i tilol hani lato, “Tesol teleiai xixi, amuto tai tiuk na tok, kewak?” Lato ukek, “Tap wanen!” ");
INSERT INTO ssg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","I kakane lato, “Towi uleawa tehu upenaumuto haniwa tepaun sai manau ti tea koap lehe amuto tiuk.” Lato towi haputa tehu upen ape lato kum tei aliake uke nake kilan wanen xixi lato puliwen. ");
INSERT INTO ssg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tel kahikahi Jises lohun xoxoan hone Pita, “I se Jises tel Masiwi!” Ti Pita hongoa ka se tel Masiwi, i talini xioti luhuan tehu puxuaun ape i tautit hani itax. ");
INSERT INTO ssg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tesol kahikahi Jises liai xoxei ititini tehu upen xuhai xixi hani peixux. Lato kumahe pate xauxaun, xawaian sai 100 mita. ");
INSERT INTO ssg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ti lato mos haniwa peixux, lato ningahi xixi patul he ah tenen tuahe nawal. Tin hina bret ien. ");
INSERT INTO ssg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ape Jises hone lato, “Kau ngahoma xixi ti amuto tikewen.” ");
INSERT INTO ssg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon Pita nahih hani he tea koap ape itini xaheni tehu upen xuhai 153 xixi hani peixux. Kalak xixi pate kilan ma lalap, upen tai watat. ");
INSERT INTO ssg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jises hone lato, “Nahima ang.” Tap tel ti tesol kahikahin kameawen ka i aita nake lato tioi i se tel Masiwi ti lato. ");
INSERT INTO ssg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jises waxi bret ma xixi ape hani lato ani. ");
INSERT INTO ssg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ie se ape he toluhu ti Jises take hani tesol kahikahin muhin ti i moih aliawa ti matean. ");
INSERT INTO ssg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ti lato ang kewa, Jises kamei Saimon Pita ukek, “Saimon tel nati Jon, nakon wawahen tetam hani nga pamu i xoini wawahen tetam hani lawe waliko liai?” I pahoi ukek, “A se. Tel Masiwi, o tioi nga waheni o.” Jises kakane i, “Ngahati aluiniwa teka kahikahik masin ti tel ngahatiai sipsip.” ");
INSERT INTO ssg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jises kamei ulea, “Saimon tel nati Jon, nakon o waheni hawane nga?” I pahoi ukek, “A se. Tel Masiwi, o tioi nga waheni hawane o.” Ape Jises ukek, “Ngahati aluiniwa teka kahikahik masin ti tel ngahatiai sipsip.” ");
INSERT INTO ssg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jises kamei i he toluhu i ukek, “Saimon tel nati Jon, nakon o waheni nga?” Saimon Pita tian i kawat nake Jises kamei i uke he toluhu sale wawahen tetan hani i. Ape i ukek, “Tel Masiwi, o tioi lawe waliko. O tioi ka nga waheni hawane o.” Jises hone i, “Ngahati aluiniwa teka kahikahik masin ti tel ngahatiai sipsip. ");
INSERT INTO ssg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nga kakane hawane o, lokon ti o uluha, lawe o aile waliko ti paham ma lawe o nahih hani tesol ti paham. Tuahe ti na o salaimatawa, teka liai waxi o hani tesol ti kumahe paham.” ");
INSERT INTO ssg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jises kak ukek ien kilamiai sale matei Pita. Matean i haxawa hawane Haeu. Ape Jises hone i, “Tu xox tatalewa tel kahikahik!” ");
INSERT INTO ssg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ti Jises ma Pita tau nanahih, Pita tohea ape ningahi tel kahikahi Jises liai lohun xoxoan, kakahiti lalu. I tetel i to papalahah hani patanawe Jises lokon ti lato ang tehu angiain ti Pasova ape i kamea, “Tel Masiwi, aita ti amite tel hangainiam hani mini teka seilon teleiam?” ");
INSERT INTO ssg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ti Pita ningahiwa tel i kakahiti lalu, i kamei Jises, “A tel io, waliko la na i sohot hani i?” ");
INSERT INTO ssg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jises pahoi ukek, “Sohin uke pahak i moihin tutuen atengi taen nga aliama. O kum namiloi hahakila tenen ien. A o, tu xox tatalewa tel kahikahik.” ");
INSERT INTO ssg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ti nake ien, kakain sawata wasole teka kahikahi Jises ka tel kahikahin lohun xoxoan i kum mat. Tuahe Jises tai kak ukek ien. I tua ukek, “Sohin uke pahak i moihin tutuen atengi taen nga aliama. O kum namiloi hahakila tenen ien.” ");
INSERT INTO ssg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tel kahikahi Jises lohun xoxoan i se tetel i ningahiwen ma tai kakaxi tesol waliko ie. Ape amite teka kahikahi Jises tioi ka waliko ti i kakak salan wanen. ");
INSERT INTO ssg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kilan wanen waliko liai tutuen ti Jises ailewen. Na masin pahalaha tai kongini hatapo tesol waliko ien, nga kum ukek ka hatehu pon ie i tapai tone hatesol pepa ti sale Jises. ");
INSERT INTO ssg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tel masiwi Teopilus, leili teik pepa Meng solian ti Jises nga kakaxi hatesol waliko ti Jises ailewen ma hanauen ti i hutui pupuasan, hani tataen ti Haeu waxi i hani kapin ti tesol tonan. Imat ti Haeu waxi i, Jises hani teka kahikahin kakain ti pohe Holi Spirit ti i talo lato ailei puasalato. Teteka kahikahin i kilamiwen aposel tetan. ");
INSERT INTO ssg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Leili 40 ngain muhi matean i sohot take kila hani kapi lato. I kola ka i moih aliawen. Lokon ien i kakane lato sale nenein ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Telao ti lato ang apupuha i hone lato, “Amuto kum nahih sasalili Jerusalem, atengimua tataen tel Tamak Haeu hani amuto Holi Spirit ti i honewen amuto, masin ti nga kakanewen amuto. ");
INSERT INTO ssg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon baptaisi seilon ani kan tuahe pate ape sikole Haeu hani amuto Holi Spirit ti kapitiamuto.” ");
INSERT INTO ssg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Telao ti tesol kahikahi Jises apuha haniwa kapin, lato kamei i, “Tel masiwi, nakon se ape o hani kaha teka Israel ngahati aliake kaha ma neini xux liai?” ");
INSERT INTO ssg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jises pahoi lato ukek, “Kumahe waliko ti lehe amuto tioi. Mewenae Haeu noseniai taen ti tesol waliko ien sohot. ");
INSERT INTO ssg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tuahe ti Haeu hani amuto Holi Spirit, amuto uke pohen ape amuto kaxi sawateni nga hani teka seilon ti Jerusalem, hatexux ti Judia, Samaria ma lawe xux.” ");
INSERT INTO ssg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Muhin ti i kak kewa, Haeu waxi i hani patul kapin ti puli tesol kahikahin ape teik maun likihini i ti pulalato. ");
INSERT INTO ssg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Lato to paxapax tutuen, hua seilon puxuaulalu papaxaxun sohot tu hahutuia hani kapi lato. ");
INSERT INTO ssg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Lalu ukek, “Tesol akiki Galili, alahan amuto paxai kakapitini maun? Tetel Jises, Haeu waxi hani patul kapin, tin i aliama masin ti amuto ningahi i luainiwa.” ");
INSERT INTO ssg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Waliko ien i sohot ti Maunt Oliv, xohixohin tehu taon Jerusalem. Muhin ien tesol aposel alia hani taon. ");
INSERT INTO ssg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ti lato tahiawa, lato soh hani tehu ing teke patul, tesol lawe lato heheuta. Lato tetesol: Pita, Jon, Jeims, Andru, Pilip, Tomas, Batolomiu, Matiu, Jeims tel nati Alapeus, Saimon tenen axan liai Selot ma Judas tel nati Jeims. ");
INSERT INTO ssg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Lato hatesol lawe lato apuha lotu hetekie namil tenenawe kapi tesol hehin ma Mary tel tini Jises hetekie tesol ukale Jises. ");
INSERT INTO ssg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ngain telao, sai 120 kahikahi Jises laha apuha ape Pita tua i ukek, ");
INSERT INTO ssg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Tesol akikik ti Krais, waliko ti kakai Haeu kaxiwen i sohot hapoponowi sale Judas, tetel i atima teka xotiai Jises. Ti kuewen wanen Holi Spirit hanamiloa tel masiwi David ti kak kilamiai tesol waliko ien. ");
INSERT INTO ssg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kemuk Judas tel ti leilokako, Jises kilami i puas akatiakako.” ");
INSERT INTO ssg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Imuh Judas waxi teik moni ti hangainiai Jises ape i kahui teik pekeun. Ti ien i haputa kalungini i, tian tapox, puhuan ahuta ape i mat. ");
INSERT INTO ssg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Lawe seilon ti Jerusalem hong menge matei Judas, ape laha axai teik pekeunaun ien ti kakaialaha Arameik. Laha axai Akeldama. Teik kakain ien ukek, Pekeun ti Kaka. ");
INSERT INTO ssg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita kak tatale ukek, “Leili pepai Salm ti tataiai David i ukek, ‘Tiliwen tap seilon leili ingan, laha kum ingangai.’ Tin i ukek, ‘Tel seilon liai akeniai pupuasan.’ ");
INSERT INTO ssg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Aile ape ewi na tel seilon soh ulea hani kapi kako ti kaxiai xahatai Jises tel Masiwi. Kako kilami tel ti lawe kapi kako lokon kako kapi Jises, hutui ti Jon baptaisi Jises haniwa tataen ti Haeu waxi i hani kapin ti tesol tonan.” ");
INSERT INTO ssg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ape lato noseni kilamiai tel ti huhua seilon ie: Josep Basabas, axan liai tenen Justus, ma Matias. ");
INSERT INTO ssg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Lato kamei Haeu ukek, “Tel Masiwi, o tioi namili lawe seilon. ");
INSERT INTO ssg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Kola hanima amite tetel ti o kilamiwen lehe i sohot tel aposel ukei pupuase Judas, tel i saliliwen amite hani tesol hoi liai totonan.” ");
INSERT INTO ssg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ape lato halokeni satu upiai tel ti Haeu kilami. Haeu kilami Matias ape i hukuma hani kapi tesol huopanim tel aposel. ");
INSERT INTO ssg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tehu ngain lalap ti Pentekos, teka kahikahi Jises apuha hetekie hani leili tehu ing. ");
INSERT INTO ssg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Lato hong tangiai waliko tenen i hahutuialih patul masin aupol kuin ape i haxuha hatehu ing ti lato toto. ");
INSERT INTO ssg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Lato ningahi tenen waliko masin xekei ah a tanome leh i sawat to hani pati tel tel. ");
INSERT INTO ssg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Holi Spirit soh xuh hani leilolato ape lato hutui kakak kakai xux liai ti Holi Spirit hanesoa lato. ");
INSERT INTO ssg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ti lokon ien, teka Ju ti xux texux texux laha toto leili Jerusalem. Laha seilon ti lotuiai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ti laha hongoa tangiai waliko tenen masin aupol kuin, kilan seilon apuha paxai ape laha hong ongaini nake tel tel hong ka teka kahikahi Jises ape lato kakak puki kakaialaha. ");
INSERT INTO ssg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Teka Ju ien pate laha tataxini ape laha eseini hawane ukek, “Nakon tesol seilon ien kumahe akiki Galili? ");
INSERT INTO ssg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","A i sohot ukek ia ape kako hong lato kakak kakaiakako? ");
INSERT INTO ssg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kako teka ti Partia, Midia, Elam, Mesopotamia, Judia, Kapadosia, Pontus ma Asia, ");
INSERT INTO ssg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","teka ti Prigia, Pampilia, Igip ma teka ti Libia tetesol xohixohin tehu taon Sairini, hetekie kako teka soliwa ti Rom. ");
INSERT INTO ssg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kako teka nakuama ti teka Ju ma teka lotu usiusi teka Ju. Ape kako teka ti Krit ma Arabia. Tuahe kako hatesol hong ka lato kakak kakaiakako wanen sale waliko lalap ti Haeu ailewen!” ");
INSERT INTO ssg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Laha kum tioi ka i sohot ukek ia ape laha he kamekam alia puki laha, “Waliko tenen lahan ie?” ");
INSERT INTO ssg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Teka ti laha kak soxeni teka kahikahi Jises ukek, “Lato un kasia unum ailan!” ");
INSERT INTO ssg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita tule kapi tesol huopanim tel aposel ape i kak eliel lehe laha hong, i ukek, “Amuto teka Ju ma amuto hatesol ti Jerusalem, hong matainiwa na nga kaxi haxewa hani amuto. ");
INSERT INTO ssg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Teka seilon ie kumahe ka lato unuun hanowi ti amuto nanamiloi nake seilon kum unuun letu masin. ");
INSERT INTO ssg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tenen waliko amuto niningahi masin ti Joel tel kuluiai kakai Haeu kaxiwen i ukek, ");
INSERT INTO ssg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Haeu ukek, ‘Leili taun imat ti tehu pon ie tapo, nga axi Holi Spirit hani seilon tenen tenen. Natumuto wawan ma hehin laha kak kului kakaiak, teka natumuto uluha ma teka wawan salaimat nga hapaxangongo. ");
INSERT INTO ssg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kalak tuahe teka unauak wawan ma hehin nga hani laha Holi Spirit telok ien ape laha kak kului kakaiak. ");
INSERT INTO ssg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nga aile hasohotu kolakol tenen lalap he maun ma he tehu pon itan ie. Matemate, ah ma axuan tenen pate kilakilan i sohot he tehu pon itan. ");
INSERT INTO ssg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Imat ti tehu ngain lalap ti sohotui Krais tel Masiwi al i tilok a pangapang i sohot kakan masin kaka. ");
INSERT INTO ssg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Taen ien, teka laha upia huhual ti tel Masiwi, i waxi auni laha lian tehue.’ ");
INSERT INTO ssg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Hongoa amuto tesol Israel! Jises tetel ti Nasaret i aile waliko lalap tenen tenen ti pohe Haeu. I kola ka Haeu taloma i. Puki amuto tioiwen ma ningahiwen nake i sohotuen wasolamuto. ");
INSERT INTO ssg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tetel seilon ien, Haeu kak kilamiwen ka amuto hangaini hani teka seilon lialun ape laha telei. Laha tahi hakea i hani he kros. ");
INSERT INTO ssg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tuahe Haeu hamoihawen Jises. I oxoxiwen i ti matemate nake kum pon wanen matemate aka kongini i. ");
INSERT INTO ssg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kako tioi ka salan wanen nake David tel masiwi kakawen sale Jises. I ukek, “‘Nga niningahi tel Masiwi kapik lawe ngain. Lawe i huali nga ape nga kum mamata kawatan na i tunahi nga. ");
INSERT INTO ssg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Aile ape leili tiak hetekie kakaiak mewenae nga amuam. Kalak nga tioi nga mat, nga tioi hawane ka Haeu i tel ngahatiak. ");
INSERT INTO ssg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Haeu, nga soh o kum aka lioi nga leili amal. O kum hakoha lioi tupuak leili amal nake nga tel unauam lolowi. ");
INSERT INTO ssg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","O kola haniwen nga aweisal ti ukei tonain solian. Ti o kapik, nga amuam.’” ");
INSERT INTO ssg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita kak tatale ukek, “Amuto tesol akikik, nga kaxi hawane hani amuto ka tel masiwi David, tetel matahaun ti kako, i matewen ape laha tihiniwen. Aope ie, amalun tutuen kapi kako. ");
INSERT INTO ssg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David kumahe i kakak puki i. David i tel kuluiai kakai Haeu, i tioi Haeu kakawen ka tel ti nakuama tetan i sohot Masiwi hanowi i. ");
INSERT INTO ssg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David liai i tioiwen waliko ti na Haeu aile, ape i kakak sale xahatai Jises Krais ti i ukek ka Haeu kum aka lioi i leili amal lehe tupuan koha. ");
INSERT INTO ssg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Tetel Jises nga kakaxi, Haeu xahateniwen ti matemate ape amite hatesol kahikahin ningahiwen ka i ape moihin. ");
INSERT INTO ssg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Haeu hana Jises hani minan tepaun manau ti neiniai seilon ape hani i Holi Spirit masin ti i kakawen i aile. Tin i hahani kako Holi Spirit ape waliko ti amuto niningahi ma hongohong aope ie se pupuase Holi Spirit. ");
INSERT INTO ssg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Haeu tai waxi David tel masiwi hani tonan, i waxi Jises masin ti puki David kakawen. I ukek, “‘Haeu kakane tel Masiwi tetak, “Toma papak tepaun manau ti neiniai seilon atengi tataen nga hanawa teka seilon laha pahoxai o hani hahitakam.” ’ ");
INSERT INTO ssg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Aile ape amuto hatesol Israel tioi kewak, tetel Jises amuto teleiwen, se tetel Haeu kilamiwen Masiwi ti amuto ma i tin Krais, tetel Haeu taloma!” ");
INSERT INTO ssg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ti laha hongoa teik kakain ien, pate i tuhuke hakawata hawane tialaha ape laha kamei Pita ma tesol aposel liai ukek, “Tesol akikimite, kaie ape amite aile la?” ");
INSERT INTO ssg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita pahoi laha ukek, “Towiahua ti saun lialun ti amuto lehe amite baptaisi amuto hahitake axe Jises Krais. Ape Haeu oxoxi amuto ti kawatan ti saun lialun ti amuto ape i hani amuto Holi Spirit. ");
INSERT INTO ssg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Haeu kakawen ka i hani amuto, natumuto ma tin hani teka seilon ti xux liai, hatesol teteka ti i kilamiwen.” ");
INSERT INTO ssg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kilan kakain tuah Pita kakane laha ape i kak haxoxo ma hanamena kapitini laha i ukek, “Na amuto hong tamani kakaiak, amuto salia ti hukuma akatiai teka seilon lialun ti aope ie.” ");
INSERT INTO ssg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Teteka seilon lato hong soh kakai Pita, teka kahikahi Jises baptaisi lato. Telao ien 3,000 seilon soh palahi teka kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Teka lato sohot kahikahi Jises lato hani hatapo lato ukei anesoin ti tesol aposel. Hatesol kahikahi Jises lato hina namil teikawe ti to hukuma hetekie, lotu hukuma ma ang hukuma ti nameniai matei Jises. ");
INSERT INTO ssg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tesol aposel aile hasohotu kilan waliko tenen lalap wanen ape hatesol seilon paxai ma ong amuke. ");
INSERT INTO ssg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Hatesol kahikahi Jises lawe lato to hukuma ma he axiax soxi. ");
INSERT INTO ssg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Lato hangaini soxialato ape sei moni hani hualiai teka tap soxi. ");
INSERT INTO ssg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lawe ngain lato apuha hetekie ti namil teikawe leili Ingi Haeu. Lato ang bret nameniai matei Jises ma amuam ti he axiax an leili ingalato. ");
INSERT INTO ssg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Lato kak ma pak sameni Haeu ape lato amuke saun solian seilon liai aile hani lato. Lawe ngain Haeu hasoho palahi seilon hani kapi teka kahikahi Jises, teteka i awai laha ti kawatan ti lialui woulaha. ");
INSERT INTO ssg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ngain tehu taun ti lotu ti alohah, Pita ma Jon, hua kahikahi Jises, nahih hani Ingi Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lalu ningahi tel seilon aen lialun lilian ti i takahama. I toto pape tewau aweing axan Solian. Lawe ngain teka akikin kau hatona i hani pape tewau aweing ien lehe i kat moni ti teka seilon na laha soh hani Ingi Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ti i ningahi Pita ma Jon nahih sosohoa, i katei lalu moni. ");
INSERT INTO ssg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Lalu pax sawi hani i ape Pita ukek, “Paxaima amili!” ");
INSERT INTO ssg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ape se i paxai lalu, i sokok ka lalu axi i na tenen. ");
INSERT INTO ssg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ape Pita ukek, “Nga tap moni tuahe waliko tenen nga hina nga hani o. Ti pohe Jises Krais tel ti Nasaret, nga hone hawane o, tua ape tau nahiwa!” ");
INSERT INTO ssg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita akeni tepaun minan manau ape aka hatuhi i. Tuhan tehue anele aen ma titin i soli. ");
INSERT INTO ssg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","I tit hokahale ape i tau nanahih. I nahih kahiti lalu hani Ingi Haeu. I tit amumuke pohe Haeu ape i kak kemulik hani i. ");
INSERT INTO ssg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Hatesol seilon ien ningahi i nanahih ma hong i sasameni Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ti laha paxai tioiwa ka se tetel i to katekat pape tewau aweing axan Solian, pate laha ongaini hawane waliko ti i sohot hani i. ");
INSERT INTO ssg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Hatesol seilon ongaini hawane ape laha kiliwau hani kapi tesol axan Totone Solomon, tetesol ti tel seilon kemuk aen lialun pohi amumuke Pita ma Jon. ");
INSERT INTO ssg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ti Pita ningahiwa teka seilon apuhawa, i hone lato ukek, “Amuto teka Israel, alahan waliko tetenen ie i hahataxina amuto? Alahan amuto paxai hamalumini amili? Kumahe kuimili ma soliai woumili i aile tel seilon ie nanahih. ");
INSERT INTO ssg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Haeu ti Abraham, Aisak, Jekop ma teka matahaun ti kako, i hanawen tel unauan Jises seilon pate tuah, tetel amuto hangaini hani teka masiwi ti Rom. Pate amuto watakai i kalak Pailat ailewen namil ti oxoxian. ");
INSERT INTO ssg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Amuto watakai hawane Jises, tetel i ailele mewenae puase Haeu a woun pate sawisawin. Amuto kamei Pailat na i ahuti hani amuto tel weli teleiai seilon. ");
INSERT INTO ssg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ape amuto telei Jises, tel haniai hanawain tenen tap tahi tapoan. Tuahe Haeu xahateni aliakewen i ape puki amite ningahiwen ka i moihin. ");
INSERT INTO ssg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Se pohe Jises hakui tel seilon aen lialun. Amili haewia i ti xoxoi namilomili ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Teka soliai akikik, nga tioi ka amuto ma tesol masiwi ti amuto kum paxai tioi waliko tenen auha aile haniwen Jises. ");
INSERT INTO ssg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tuahe Haeu kakanewen teka kuluiai kakaian ape laha kak kilamiwen ka Krais tel Nati Haeu, liai i kau kawatan ape se i sohotuen. ");
INSERT INTO ssg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Aile ape amuto lioiwa saun lialun. Towiahu haniwa Haeu lehe i oxoxi amuto ti kawatan ti lialui woumuto. ");
INSERT INTO ssg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Na amuto aile ukek ien, Haeu hakui amuto ape i hamosu Jises Krais, tel i kilami hahani amuto. ");
INSERT INTO ssg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Aope ie i tutuen tone Haeu atetengi taun ti Haeu aile hauni hasolia lawe waliko masin ti Haeu hanamiloa kakain hani teka kuluiai kakaian ti kuewen. Lawe laha puas hahawane ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Lokon ti kuewen, Moses kakaxi Krais ti i ukek, ‘Haeu tel Masiwi ti kako, imuh i talo tel kuluiai kakaian masin ti i taloma nga. I uke tel ti puki akikikako. Amuto hong tamaniwa lawe waliko na i kakane amuto ailean. ");
INSERT INTO ssg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Na tel kum hong tamani kakai tel kuluiai kakai Haeu ien, Haeu namiloi ukek tel ien kumahe tetan.’ ");
INSERT INTO ssg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Hutuima ti Samuel, hatesol kuluiai kakai Haeu liai laha kak kilamiwen waliko ti i sosohot aope ie. ");
INSERT INTO ssg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Masin teka kuluiai kakai Haeu, tin amuto uke waliko ti Haeu kakanewen tesol tamakako ti kuewen. Haeu xinoti teik namil kapi Abraham i ukek, ‘Nga hapuasa tesol lato nakuama tetam auni hasoliai hatesol seilon ti tehu pon ie.’ ");
INSERT INTO ssg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Haeu kilamiwen tel unauan Jises ti talo hanimu kako teka Ju. I aile kola lalape soliaian ti i huali kako ti towiahuakako ti saun lialun.” ");
INSERT INTO ssg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ti Pita ma Jon kakak tutuen kapi teka seilon, teka masiwi tahiama. Lato se teka ti hukuminiai Haeu ma seilon, tel masiwi ti teka peteniai Ingi Haeu ma teka Sadusi. ");
INSERT INTO ssg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Lolato lialu nake Pita ma Jon kakaxi hani teka seilon ka Jises moih aliawen. Ien i kola ka teka laha mat laha xahat alia. ");
INSERT INTO ssg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kakanua lato akeni kongini lalu ape hana hani leili kalabus atengi ngain liai tehu nake pate ape alohah. ");
INSERT INTO ssg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tuahe kilan teka laha hong meng ien, laha soh. Mongohe kahikahi Jises han hani sai 5,000. ");
INSERT INTO ssg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Taen kewa ngain liai tehu, teka masiwi ti teka Ju tenen tenen ma teka hanaui nauna ti Moses laha apuha Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Laha apuha hani kapi Anas, tel masiwi tapein ti hukuminiai Haeu ma seilon, ma Kaiapas, Jon, Aleksanda ma teka akiki Anas liai. ");
INSERT INTO ssg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Teka unaualaha hakahita Pita ma Jon hani kapi teka masiwi ape laha kamei lalu ukek, “Amulu kema poh ti aita ti amulu haewia tel seilon aen lialun? Amulu ailele ti hahitake axe aita?” ");
INSERT INTO ssg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Holi Spirit hakui Pita ape i kakane laha, “Amuto hatesol teka masiwi ti teka Ju, nakon amuto kamei amili nake amili tahane tel seilon aen lialun? Ape tin pahamuto tioi sale ewiai tinun? ");
INSERT INTO ssg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ien, amuto ma hatesol seilon ti Israel tioiwa, tel seilon tutu ie mateiwaumuto tinun ewi hawanewen nake ti pohe axe Jises Krais ti Nasaret, tetel amuto telei ape Haeu xahateni i ti matean. ");
INSERT INTO ssg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jises se tel seilon ti pepai Haeu kakak, “‘Tehu kuku teka ataiai ing hilisa, Haeu aile hasohotu i kuku pamu tuah ti kuku liai!’ ");
INSERT INTO ssg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tap wanen tel seilon pon awaiakaha ti lengei Haeu ti saun lialun ti kaha, mewenae Jises, tetel Haeu kilamiwen. Ti hatehu pon itan ie mewenae i tapai.” ");
INSERT INTO ssg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Teka masiwi ongaini hawane ti laha paxai Pita ma Jon kak mamatut. Laha tioi lalu tuahe seilon naun tai sukul. Laha ila tioi ka lalu se kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tap laha kak ulea tenen nake tel seilon i ewiwen tutu kapi Pita ma Jon. ");
INSERT INTO ssg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ape teka masiwi hone lalu nahih ahutamua ti tehu ing laha toto, ape laha he kakak aliamu puki laha. ");
INSERT INTO ssg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Laha he kamekam, “Kako aile la hani lalu? Lawe seilon leili Jerusalem laha tioi hatapoen waliko tenen lalap lalu ailewen. Kako kum puluhini uke. ");
INSERT INTO ssg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tuahe kako halini lalu kaxiai puase Jises lehe axe Jises i kum sawata ahe hani teka seilon.” ");
INSERT INTO ssg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Laha tiloi hasoho aliake lalu ape kakane lalu ka tapeiniwa kaxi hanaui teka seilon ti hahitake axe Jises. ");
INSERT INTO ssg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tuahe Pita ma Jon kak pahoi laha ukek, “Amili namiloi ukek pamu ewian na amili hong usi kakai Haeu kumahe amuto. ");
INSERT INTO ssg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Amili kum kongini uke kaxiai waliko ti puki amili ningahiwen ma hongoen.” ");
INSERT INTO ssg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Teka masiwi kum tunah huan ti kalabusiai Pita ma Jon. Laha tua kak hahamatau lalu ape hanahi nake lawe seilon laha sameni Haeu ti waliko i sosohot telao ien. ");
INSERT INTO ssg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tel seilon i ewike pohe Haeu, ahangun akulai 40. ");
INSERT INTO ssg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tataen Pita ma Jon ahuta kewa, lalu nahih alia hani kapi teka kahikahi Jises liai ape kaxi waliko tenen teka masiwi tuah ti hukuminiai Haeu ma seilon ma teka masiwi liai kakak. ");
INSERT INTO ssg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ti teka kahikahi Jises hongoa, lato lotu hetekie hani Haeu, lato ukek, “Tel Masiwi, o tanomi maun aheah ma tehu pon itan ie, kanitax ma lawe waliko ti heihon. ");
INSERT INTO ssg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","O hapuasa Holi Spirit kakanei tel unauam David, tel tame tesol tamamite, i kak ukek, “‘Kalahai teka seilon laha kum tioi Haeu lolaha lialu? Kalahai teka seilon tua namiloi pahoxai Haeu? ");
INSERT INTO ssg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Teka masiwi tenen tenen ti tehu pon itan ie apuha hetekie ti hileiai Haeu tel Masiwi ma Krais tel Natun.’ ");
INSERT INTO ssg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ape salan, Herod ma Pontius Pailat apuha hetekie kapi teka seilon laha kum tioi Haeu ma teka seilon ti Israel leili Jerusalem ape laha aile namil ti halialui Jises, tel o kilamiwen, tel unauam i hani hatapo namilon ti puasam. ");
INSERT INTO ssg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ape waliko ti o namiloiwen i sohot, laha apuha hetekie ailean. ");
INSERT INTO ssg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tel Masiwi, ti tenen ien paxai tioiwa kakain ti laha kak hahamatau amite ape aile hamatuawa amite teka unauam ti kaxiai kakaiam. ");
INSERT INTO ssg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Hanima amite pohem ti haewiai seilon ma hasohotui kolakol tenen lalap hahitake axe tel unauam Jises.” ");
INSERT INTO ssg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ti lato lotu kewa, tetesol ti lato apupuha i nuea ape Holi Spirit soh hapohea lato. Aile ape tap lato mamata kaxiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Hatesol kahikahi Jises namilolato teikawe. Tap tel na i ukek teik na soxian mewenae tetan, lawe waliko na lato hina lato sei. ");
INSERT INTO ssg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hetekie lalape poh, tesol aposel kaxi tatale xahatai tel Masiwi Jises ape Haeu to hasolia hahani lato. ");
INSERT INTO ssg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tap tel ti lato kukun teik na soxi. Teka na hina teik hepekeun ma na ing, laha hangaini ukei moni. ");
INSERT INTO ssg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Laha atoheni hani mini teka aposel ape lato sei hani teka seilon pahalaha huhual. ");
INSERT INTO ssg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Masin ti Josep aile, tel Livai ti texux xux Saiprus. Tesol kahikahi Jises axai i Banabas. Salangawe axan ukek, “Tel ti kak haxoxoi seilon.” ");
INSERT INTO ssg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","I hangaini teik hepekeunaun. I kewa moni ape i hani teka aposel. ");
INSERT INTO ssg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tel seilon axan Ananaias hetekie tel axoan Sapaira, tin lalu hangaini teik hepekeunaulalu. ");
INSERT INTO ssg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ti lalu kewa moni, lalu akeni kongini aliake teik ape ti liai, lalu atoheni hani tesol aposel. ");
INSERT INTO ssg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pita ukek, “Ananaias, nake lahan o hani lioi Satan kapiti namilom ape o aile puluti Holi Spirit ti akeni kongini aliakei teik moni ti kahi hepekeun? ");
INSERT INTO ssg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Imat ti o hangaini, hepekeun liai tetam ape moni ti o uke liai tetam. Alahan o puputa? Kumahe o pupuluti mewenae seilon, o puluti hehetekie Haeu.” ");
INSERT INTO ssg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ti Ananaias hongoa, i put mat. Ape teka seilon mamata hawane ti laha hongoa waliko ti i sohot hani Ananaias. ");
INSERT INTO ssg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Teka seilon uluha nahima, puxui auni tupuan, lato kau hasohotu ape tihini. ");
INSERT INTO ssg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ti muhi aua toluhu tamusua, tel axoan hehin nahima. I kum tioi waliko ti i sohotuen. ");
INSERT INTO ssg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ape Pita kamei i, “Kaxi hanima nga, nakon moni se hatesol lapan ie amulu akeni ti kahi hepekeunaumulu?” Sapaira pahoi ukek, “Se mewenae ien.” ");
INSERT INTO ssg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita kakane i ukek, “Alahan o ma tel axoam hahelehele Holi Spirit? Tesol seilon lato tihini tel axoam lato tutu aweing, tin lato apepeas kaui tupuam!” ");
INSERT INTO ssg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tataen wanen ien i put mat hani itan. Tesol seilon uluha nahih sohoa ningahi i maten, lato kau hasohotu tupuan ape tihini i pape tel axoan. ");
INSERT INTO ssg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ti hatesol kahikahi Jises ma teka liai hongoa waliko ti i sohot hani Ananaias ma Sapaira, pate laha mamata. ");
INSERT INTO ssg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Teka aposel aile hasohotu kilan kolakol tenen pate lalap ape teka seilon ningahi pohe Haeu. Hatesol kahikahi Jises lawe lato apuha hetekie ti tesol Totone Solomon pape Ingi Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tap seilon melal ti lato pahalaha saupa kapi lato, kalak pate laha sasameni lato. ");
INSERT INTO ssg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tuahe seilon to kila ahe tatale teteka laha soh ti Jises Krais ape laha soh palahi teka kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ti teka seilon paxaiwa puase teka aposel, laha kau teka tinun hani he aweisal ape hana laha patul he sau ma he tahi lehe tuahe lihui hosai Pita i halihu laha na i nahih sahiwa. Ien i tapai ti haewiai teka tinun. ");
INSERT INTO ssg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ape kilan seilon ti lawe taon kakalini Jerusalem tin laha kau teka seilon tinun ma teka ti spirit lialun kapiti hahalialu ape Haeu haewia laha hatesol. ");
INSERT INTO ssg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tel masiwi tapein ti hukuminiai Haeu ma seilon ma hatesol tuaun laha ti teka Sadusi, laha lohaini tesol aposel nake kilan seilon sameni lato. ");
INSERT INTO ssg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Laha xoti teka aposel ape hana hani tehu ing ti kalabusiai lawe seilon lialun. ");
INSERT INTO ssg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tuahe ti ipong tetehu ien, tel engel ti Haeu i hei kahip ti aweingi kalabus ape hasohotu lato. ");
INSERT INTO ssg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ape i hone lato ukek, “Nahih haniwa Ingi Haeu ape kaxi tatale haniwa teka seilon meng solian sale tonain kapi Haeu ti tap tahi tapoan.” ");
INSERT INTO ssg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ti i letule lato nahih hani Ingi Haeu ape hahanau teka seilon ien. Letuan tin tetehu, tel masiwi tapein ti hukuminiai Haeu ma seilon ma hatesol masiwi ti Israel lato apuha hetekie. Lato talo teka unaualato nahih waxiai tesol aposel lehe teka masiwi kamei lato hina kamekame. ");
INSERT INTO ssg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ti teka unaualato tahia haniwa ingi kalabus lato tai tunahi tesol aposel ape lato nahih alia hani kapi teka masiwi. ");
INSERT INTO ssg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Lato ukek, “Ti amite tahiawa, tewau kahip ti aweingi kalabus konginan xoxoan. Teka peteniai kalabus tin laha tutu aweing. Tuahe ti amite heiwa kahip, tap seilon ien.” ");
INSERT INTO ssg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ti tel masiwi ti teka peteniai ingi kalabus ma teka masiwi tuah ti hukuminiai Haeu ma seilon hongoa, lato tataxini ape lato ukek, “Waliko la sohotuen?” ");
INSERT INTO ssg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tataen ien tel seilon tahia hani kapi lato ape i ukek, “Hongoa! Tesol seilon amuto hahana leili kalabus lato tutu ulea mate Ingi Haeu hahanau teka seilon sale Jises!” ");
INSERT INTO ssg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kakanua tel masiwi ti teka peteniai kalabus hetekie tesol unauan lato nahih waxi aliake tesol aposel. Lato aile hakokol nake lato mamata uke teka seilon hokai lato pot. ");
INSERT INTO ssg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ape lato hakahita tesol aposel hani kapi teka masiwi lehe tel masiwi tapein ti hukuminiai Haeu ma seilon kamei lato hina kamekame. ");
INSERT INTO ssg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","I ukek, “Amite halini hawanewen amuto hanaui teka seilon waliko ti Jises hanauen. Tuahe amuto kaxi sawateni kaliniwen Jerusalem ape amuto tieni amite teleiai Jises.” ");
INSERT INTO ssg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita tuke awe tesol aposel, i ukek, “Amite hong usiusi kakai Haeu, kumahe kakai seilon. ");
INSERT INTO ssg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tel Tamakako Haeu xahateni aliakewen Jises ti matean, tetel amuto tahi hakea hani he kros ape i mat. ");
INSERT INTO ssg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Haeu waxi i hani papan tepaun manau ape i sohot tel Masiwi ti neiniai seilon ma tel ti awaiai seilon ti lengei Haeu ti saun lialun ti kaha. Haeu aile ukek ien lehe kako teka seilon ti Israel hina aweisal ti towiahu ti saun lialun ape Haeu oxoxi kako ti kawatan ti lialui woukako. ");
INSERT INTO ssg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Amite teka kahikahi Jises ningahi hawanewen waliko ien ape amite kakaxi. Holi Spirit tin i hahaxoxo kakaiamite, tetel Haeu hani teteka seilon laha hong usi kakaian.” ");
INSERT INTO ssg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Teka masiwi ti teka Ju hongoa, lolato lialu hawane ape pahalato telei tesol aposel. ");
INSERT INTO ssg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tuahe tel ti lato axan Gamaliel, i tel Parisi a tin tel hanaui nauna ti Moses, i tule ape i talo tesol aposel hanimu melal. Gamaliel pate lawe seilon hong kakaian. ");
INSERT INTO ssg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ape i hone teka masiwi ien, “Amuto seilon ti Israel, amuto namiloi aluinimua waliko tenen na kako aile hani tesol seilon ie. ");
INSERT INTO ssg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Amuto nameni tel seilon Teudas ti i ukek ka i tel seilon masiwi, ape 400 seilon lato sohot kahikahin. Ti laha teleiwa i, tesol kahikahin ox silahota ape teik puasan i mat. ");
INSERT INTO ssg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Muhin ien Judas ti Galili apuhini teka seilon ti hil pahoiai teka seilon ti Rom lokon ti ngain ti wexei teka Ju lehe laha tioi mongohe seilon ti haniai teka masiwi ti Rom moni. I tin laha telei ape tesol kahikahin ox silahota. ");
INSERT INTO ssg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Aile ape nga nau amuto kum aile hahalialu tesol seilon ie, hanahiwa lato. Pake na puasalato i tua nakuale ti puki seilon, i tapo kaluta. ");
INSERT INTO ssg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tuahe na puasalato ahuma ti Haeu, amuto kum pon konginialato. Amuto aile tunahi amuto puas hilei hawane Haeu!” ");
INSERT INTO ssg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ape teka masiwi hong usi nauna ti Gamaliel. Lato tiloi hasoho tesol aposel ape teka unaualato heti. Muhin ien teka masiwi halini lato hanaui seilon waliko ti Jises hanauen. Ape lato talo hasohotu tesol aposel. ");
INSERT INTO ssg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ti tesol aposel nahih saliliwa teka masiwi ti teka Ju, pate lato amuke ti Haeu hani lato kau kawatan nake lato kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ape lawe ngain lato nahih hani Ingi Haeu ma ingi teka seilon ti hanaualaha ma kaxiai meng solian ka Jises i se Krais, tel Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ti ape mongohe teka kahikahi Jises kikilale, teka Ju kakaialaha Grik laha wiliki teka Ju kakaialaha Arameik ma Hibru nake laha kum sei hapono waliko hani teka hehin kakaialato Grik axoalato matewen. ");
INSERT INTO ssg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tesol aposel apuhini hatesol kahikahi Jises ape lato ukek, “Kumahe solian na amite aka lioi puasain ti kaxiai menge Haeu ape amite tani waxi seiai waliko ti huhual. ");
INSERT INTO ssg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Amuto kilamiwa tepanim hua seilon ti leilomuto, tetesol Holi Spirit kakapiti lato ma namilolato xewan. Amite hani lato akeniai teik puasain ti seiai waliko ti huhual. ");
INSERT INTO ssg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ape amite hani hatapo amite ailei puase lotu ma ti kaxiai menge Haeu.” ");
INSERT INTO ssg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hatesol kahikahi Jises lato amuke teik namili tesol aposel ape lato kilami Stiven, tel seilon namilon xoxoan ti Haeu ma Holi Spirit kakapiti i. Tin lato kilami Pilip, Prokorus, Nikanor, Timon, Parmenas ma Nikolas ti Antiok, tetel i sohot tel ti usiai lotu ti teka Ju ape tin i sohot tel kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Lato kola hani tesol aposel tetesol seilon ti lato kilamiwen ape tesol aposel hana min patul he pati tesol seilon ien kameiai Haeu ti hakuialato ailei teik puasain ien. ");
INSERT INTO ssg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ape meng solian ti Jises i sawat tatale. Mongohe kahikahi Jises leili Jerusalem kila kosea hawane. Lokon ien kilan teka masiwi ti hukuminiai Haeu ma seilon laha sohot kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stiven aile hasohotu kilan kolakol lalap wanen nake ti soliai Haeu i axi Stiven poh. ");
INSERT INTO ssg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tuahe hina seilon laha kak wawatakai Stiven. Teka Ju ti Sairini ma Aleksandria lato seilon ti tehu synagog axan Oxoxai ma teka Ju ti Sailisia ma Asia, laha kak he hapatapat kapi Stiven. ");
INSERT INTO ssg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tuahe laha kum xoini Stiven ti kakain nake i seilon tenen namilon xewan ape Holi Spirit hani i kakain solian. ");
INSERT INTO ssg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ape laha xui ngah seilon liai ti kak kewak, “Amite hong Stiven kak halialu Moses ma Haeu.” ");
INSERT INTO ssg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Aweisal tetewau ien laha hahika teka Ju, teka masiwi ti laha ma teka hanaui nauna ti Moses ape laha akeni kongini Stiven. Laha hakahita i hani kapi teka masiwi tuah ti teka Ju. ");
INSERT INTO ssg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ape laha hakahitama tesol seilon lato tua kak tanomi putini kakain. Teka ti lato ukek, “Stiven lawe i kak halialu tehu Ingi Haeu ma nauna ti Moses. ");
INSERT INTO ssg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Amite hong i ukek ka tetel Jises ti Nasaret i hamanana tehu Ingi Haeu ma i sohi saun ti Moses hakouta hanima kako.” ");
INSERT INTO ssg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ape hatesol masiwi laha toto ti tehu apuhain ien laha paxai kapitini Stiven. Laha ningahi kawan i xeu hanowi kawe tel engel, spirit solian ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ape tel masiwi tapein ti hukuminiai Haeu ma seilon kamei Stiven, “Kakain ti laha susului o salan?” ");
INSERT INTO ssg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stiven ukek, “Tesol akikik, hongoa. Haeu take hani kapi Abraham hetekie lalape xewaian, lokon ti Abraham, tel matahaun ti kako, i toto tutuen Mesopotamia imat ti i sos hani Haran. ");
INSERT INTO ssg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ape Haeu hone Abraham, ‘Nahih saliliwa tesol akikim ma xuxum ape nahih haniwa xux ti na nga kola hani o.’ ");
INSERT INTO ssg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Salan, i nahih salili texux xuxun Kaldea ape i to hani Haran. Muhin ti tel taman matewa, Haeu hasoso Abraham hanima texux xuxukako ie. ");
INSERT INTO ssg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ti lokon ien Haeu tai hani Abraham teik na hepekeun. Tuahe i kakane Abraham ka i ma teka lato nakuama muhin, lato uke hatesol hepekeun ie, kalak Abraham tap natun lokon ien. ");
INSERT INTO ssg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Haeu kakane i, ‘Imat, teka lato nakuama tetam lato sohot soliwa ti texux xux liai ma unaui seilon. Laha aile halialu lato leili 400 ahang. ");
INSERT INTO ssg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tuahe nga axi kawatan hani teka laha hapuasa halialu lato ape imuh nga waxi aliake lato lehe lato lotui nga ie, tetesol hepekeun ti nga kakawen nga hani lato.’ ");
INSERT INTO ssg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Haeu xinoti namil kapi Abraham ti ailei teik kikilam ti kotiai uli walikoi teka akaik wawan ti kolakol ka i ma teka lato nakuama tetan lato seilon ti Haeu. Ape Abraham aile hani tel natun Aisak muhi takahan kewa ngain tepanim toluhu. Imuh Aisak hatano Jekop ape Jekop sohot tel tame tesol huopanim huhua seilon lato sohot tame teka Israel. ");
INSERT INTO ssg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Tesol nati Jekop wiliki tel ukalalato Josep. Lato hangaini i hani teka Igip ape laha uke i unaualaha. Tuahe Haeu kapi Josep. ");
INSERT INTO ssg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Haeu huali i ti hatesol kawatan tetan. Haeu hanesoa hawane i ape Fero, tel masiwi tapein ti Igip, amuke hawane i. I hana Josep tel masiwi hahitakan ngahatiai Igip ma hatesol soxian. ");
INSERT INTO ssg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Telok, tehu hitolo lalap ti Igip ma Keinan. Teka seilon tunahi kawatan lalap. Ape tesol akiki Josep lato tin tap analato. ");
INSERT INTO ssg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ti Jekop hong tunahiwa ka hina an ti Igip laha hana alolomeni, i talo tesol natun hani ien. ");
INSERT INTO ssg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ti Jekop taloa tesol natun hani Igip, Josep aile kola ka i tetel ukalalato. Ape tataen ien Fero tioi tesol akiki Josep. ");
INSERT INTO ssg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Muhin Josep tapea waxi tel taman Jekop ma tesol akikin, 75 hatesol sohot haniwa kapin Igip. ");
INSERT INTO ssg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ape salan, Jekop sos hani Igip. I ma tesol natun to mat ien. ");
INSERT INTO ssg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kuilato laha kau aliake hani tehu taon Sekem ape hana hani tehu amal ti Abraham kahui ti tesol nati Hamor. ");
INSERT INTO ssg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ti sikole ape Haeu haponowia waliko ti i kakane Abraham, teka Israel leili Igip laha kila hahawanele. ");
INSERT INTO ssg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ti tel liai toa masiwi ti Igip, i kum nam waxi Josep. ");
INSERT INTO ssg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tel masiwi ien i hapuasa halialu teka matahaun ti kako ma i lungei lato xoiniai natulato kokol lehe i mat. ");
INSERT INTO ssg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Moses takah lokon ien. Haeu namiloi ukek i akaik solian. Leili pangapang toluhu tel tinan ma tel taman aunini i leili ingalalu. ");
INSERT INTO ssg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tap aliakean, lalu kum muneni uke i ape lalu ahuti i hani melal. Tel nati Fero hehin tunahi i ape waxi auni hanowi natun wanen. ");
INSERT INTO ssg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses uke anesoin hanowi teka akaik ti Igip. Ape i tin tel seilon solian ti kakain ma puasain. ");
INSERT INTO ssg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ti ahangi Moses kewa 40, i namiloi na i nahih paxai teka Ju akikin. ");
INSERT INTO ssg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Lokon ien i ningahi tel akiki Igip aile hahalialu tel akiki Ju. Ti Moses awawai tel akikin, i telei tel Igip. ");
INSERT INTO ssg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses sokok tesol akikin paxai tioi ka Haeu hapuasa i ahutiai teka Ju ti Igip. Tuahe lato kum paxai tioi. ");
INSERT INTO ssg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Ngain liai tehu Moses ningahi hua Ju akikin lalu hilehil, ape i tohongi lali hasoliai wasolalalu. l ukek, ‘Amulu akikin. Alahan amulu hil?’ ");
INSERT INTO ssg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Tuahe tetel i hutui hile i sipeli xaxaweni Moses ape i hone i, ‘O kumahe tel masiwi ti amite. ");
INSERT INTO ssg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Lehe o telei nga hanowi ti o telei tel Igip titihah?’ ");
INSERT INTO ssg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ti Moses hongoa i ox hani texux xux Midian ape i to ien hanowi soliwa. I sal ien ape i hanatua hua natun wawan. ");
INSERT INTO ssg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ahang 40 tamusua, tel engel take hani kapi Moses leili teik sisihan i xekexek he lohong, xohixohin kapi Maunt Sainai. ");
INSERT INTO ssg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ti Moses ningahiwa, i tataxini. Ti i nahih xohi ahewa paxai aluinian, i hong kinaxe Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","I ukek, ‘Nga Haeu ti tesol matahaun tetam, Abraham, Aisak ma Jekop.’ Moses i mamata xexex ape kumahe pahan i paxai. ");
INSERT INTO ssg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ape Haeu hone Moses, ‘Akahetiwa sueum nake o tutu matak Haeu tel Masiwi tetam. ");
INSERT INTO ssg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nga ningahiwen teka Igip hapuasa hahalialu tesol seilon tetak ape nga hongoen tangialato. Nga mosuma taloam ti oxoxialato. Ape nga talo aliake o hani Igip ailei teik namilok.’ ");
INSERT INTO ssg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses tetel teka Ju watakai laha ukek, ‘O kumahe tel masiwi ti amite.’ Moses se tetel Haeu hana i masiwi ape talo aliake hani Igip oxoxiai teka Ju. Telao tel engel ti Haeu sohot hani kapi Moses leili teik sisihan i xekexek. I huali Moses ailei teik puasain ien. ");
INSERT INTO ssg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ape Moses nahike ahuti teka Ju ti Igip. Lokon ien i aile hasohotu kilan kolakol lalap wanen ti Igip, ti tesol kanitax axan Kakan ma he lohong. ");
INSERT INTO ssg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moses tin tetel i kakane teka Israel, ‘Imuh Haeu hani amuto tel kuluiai kakaian. I puki tel akikikako masin nga.’ ");
INSERT INTO ssg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses tin tel i kapi tesol tamakako ti he lohong ape tel engel ti Haeu kakak kapin ti Maunt Sainai. Lokon ien Haeu hani Moses nauna ti kola haniakako sale hasoliai woukako masin ti Haeu pahan. ");
INSERT INTO ssg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Tuahe tesol tamakako kum hong usi Moses. Ti namilolato wanen, lato kum nam waxi Moses, pahalato alia hani Igip. ");
INSERT INTO ssg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ti Moses tutuen Maunt Sainai lato hone Aron ukek, ‘Tanomi hanima amite tesol haeu ti neiniamite nake Moses tetel i ahutima amite ti Igip, amite kum tioi waliko tetenen tunahiwen i.’ ");
INSERT INTO ssg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Lokon ien lato tanomi tok bulmakau uluha. Lato telei manihuh ape lelei hani i hanowi ka i tel Haeu Masiwi ti lato. Ape lato aile tehu angiain lalap ti amukei waliko ti lato tanomiwen. ");
INSERT INTO ssg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Aile ape Haeu hani lioi lato lotui hatapo waliko ti he maun aheah. I hapoponowi waliko ti Haeu kaxiwen leili pepai teka kuluiai kakaian. I ukek, “‘Teka seilon ti Israel, ti amuto he lohong leili 40 ahang, salan amuto telei ma lelei manihuh tuahe kumahe amuto aile hahani nga. ");
INSERT INTO ssg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Amuto kakau ing sosoxope ti Molek ma tehu kohot ti Repan amuto tanomi ape amuto lotui lalu hanowi nga tel Haeu. Aile ape nga hana lioi amuto he mini teka seilon laha waxi amuto hanowi tuahe unaualaha hani tesol tataen i akilaua tehu taon Babilon.’” ");
INSERT INTO ssg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stiven kakak tutuen, i ukek, “Tesol tamakako lato kakau ing sosoxope ti Haeu, kolakol ka Haeu kapi lato ti he lohong. Lato tanomi tehu ing ien hanowi ti Haeu kola haniwen Moses ti Maunt Sainai. ");
INSERT INTO ssg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Lokon ti Josua tel masiwi ti kako neini teka Israel hetekie huhual ti Haeu, lato waxaini hile ape lato uke hepekeun ti Haeu kakawen i hani lato. Tetehu ing sosoxope ti Haeu lato kau hehetekie kapi lato ape i to hamalum ien atengi tataen ti tel masiwi David. ");
INSERT INTO ssg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Haeu amuke David ape David kamei na i atai hani i, tel Haeu ti Jekop, tehu ing. ");
INSERT INTO ssg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tuahe tel masiwi Solomon ataian. ");
INSERT INTO ssg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","A kako tioi ka Haeu tel Masiwi tapein i kum to leili ing ti seilon atai ani min. Masin ti Haeu kakawen leili pepai tel kuluiai kakaian. ");
INSERT INTO ssg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","I ukek, “‘Nga Masiwi ti lawe waliko ti patul ma tehu pon itan ie. Nakon amuto sokok i tapai na amuto atai hani nga tehu ing? Nakon amuto sokok i tapai na amuto atai hani nga tehu ing lehe nga to hanau? ");
INSERT INTO ssg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Se nga tel tanomi hatapo lawe waliko.’” ");
INSERT INTO ssg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stiven kakane tutuen tesol masiwi i ukek, “Patumuto pate ailan nake amuto kum hong tamani kakai Haeu. Amuto masin tesol tamamuto. Puasamuto i hihilei Holi Spirit. ");
INSERT INTO ssg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tamamuto aile halialu hatesol kuluiai kakai Haeu! Tin lato telei teka laha kak kilami sohotui tel seilon sawisawin ti Haeu, tel Krais Haeu taloma, tetel amuto hangaini hani laha telei. ");
INSERT INTO ssg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kalak teka engel haniwen amuto nauna ti Haeu, amuto kum hong usi.” ");
INSERT INTO ssg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ti teka masiwi ti teka Ju hongoa kakai Stiven lato atalahi nisulato ti lialui lolato. ");
INSERT INTO ssg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tuahe Stiven tak hani patul. Hetekie huhual ti Holi Spirit i ningahi lalape xewai Haeu ape i ningahi Jises tutu pape Haeu sai manau ti neiniai seilon. ");
INSERT INTO ssg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","I ukek, “Hongoa! Nga niningahi maun hea ape tel Nati Seilon i tutu pape Haeu sai manau!” ");
INSERT INTO ssg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ti lato hongoa lato aka siponi taxingalato, lato ausini eliel hawane ape lato kiliwau nami Stiven. ");
INSERT INTO ssg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Lato itini hahatete Stiven hani melal ti Jerusalem ape hokai i pot. Tesol seilon lato papaxai sale teleiai Stiven lato naxi teke puxuaulato patul. Lato hani tel seilon axan Sol peteni ape tin lato hokai telei Stiven. ");
INSERT INTO ssg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Leilon ti lato hohokai i pot, Stiven tilol hani tel Masiwi ukek, “Jises tel Masiwi tetak, waxiwa nga!” ");
INSERT INTO ssg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","I aleal put hani itan ma tang ausini hani Haeu, “Oxoxiwa lato ti kawatan ti saun lialun ti lato ailele!” Ti i kak kewa ape i mat. ");
INSERT INTO ssg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol paxai waheni ti laha telei Stiven. Ti ngain tehu ien teka seilon hutui axiai kawatan tenen lialun wanen hani teka kahikahi Jises leili Jerusalem. Aile ape hatesol kahikahi Jises ox hani tesol tesol ti Judia ma Samaria tuahe tesol aposel lato hamalum Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Teteka seilon laha lolotui Haeu, laha tihini auni Stiven ma laha tahane hawane i. ");
INSERT INTO ssg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tuahe Sol i hutui aile halialui teka kahikahi Jises. I soh hani ing tehu tehu, i itini ahuti wawan ma hehin ape lohi laha hani ingi kalabus. ");
INSERT INTO ssg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Teteka kahikahi Jises laha ox, laha kaxi meng solian ti Jises hani tesol tesol. ");
INSERT INTO ssg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip nahih hani tehu taon lalap leili Samaria ape i kaxi hani teka seilon ka Jises se Krais, tel Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ti kilai seilon hongoa kakai Pilip ma ningahiwa i aile hasohotu kolakol lalap wanen, laha hong aka mataini. ");
INSERT INTO ssg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Teka spirit lialun laha tang eliel hawane ti Pilip ahuti xaxaweni laha leili teka seilon. Tin i aile haewia teka seilon tupualaha maten ma teka aelaha lialun. ");
INSERT INTO ssg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Aile ape amuamu lalap wanen leili tehu taon ien. ");
INSERT INTO ssg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ti lokon ien tel seilon axan Saimon i hahapuasa pohe Satan hasohotui kolakol lalap ti tehu taon ien. Ape kilan seilon laha ong amuke waliko ti i ailele. Saimon hanasanas ukek ka i tel seilon wanen. ");
INSERT INTO ssg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Lawe seilon tuah ma naun, laha hong mataini Saimon ape laha ukek, “Tel seilon ie hina pohe Haeu, poh tenen lalap wanen.” ");
INSERT INTO ssg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Laha soh i nake laha ong amuke kilan waliko lalap ti i ailewen. ");
INSERT INTO ssg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tuahe ti Pilip kaxi ahuhuti meng solian sale aweisal ti Haeu neini seilon ma pohe Jises, laha hong soh ape Pilip baptaisi laha, wawan ma hehin. ");
INSERT INTO ssg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Puki Saimon tin i soh ape muhin ti Pilip baptaisiwa i, i kahiti Pilip hani tesol tesol. Saimon ong amuke kolakol lalap ti Pilip ailele. ");
INSERT INTO ssg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ti tesol aposel leili Jerusalem hongoa ka teka seilon ti Samaria laha ukewen kakai Haeu, lato talo Pita ma Jon hani kapi laha. ");
INSERT INTO ssg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ti lalu tahiawa lalu kamei Haeu ti axiai Holi Spirit hani teka laha soh kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ti imat Pilip baptaisi laha hahitake axe Jises tuahe laha tai uke Holi Spirit ti kapitialaha. ");
INSERT INTO ssg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ape aope Pita ma Jon hana minalalu patul ti laha kameiai Haeu ti hanialaha Holi Spirit ape se laha uke. ");
INSERT INTO ssg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon paxai tioi ka laha kewen Holi Spirit ti Pita ma Jon hana minalalu patul ti laha. Pahan i axi Pita ma Jon moni ape i ukek, ");
INSERT INTO ssg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nga hani amulu moni na amulu hani nga tenen poh ien, lehe na nga hana minak patul ti seilon, tin laha uke Holi Spirit.” ");
INSERT INTO ssg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita ukek, “Tiliwen o mateke hetekie monium nake o sokok ka o pon kahuiai pohe Haeu ani moni. ");
INSERT INTO ssg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tap pupuasam puasain ti amili ailele nake namilom kum onoteni namili Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Towiahua ti tenen saun lialun ien, ape kameiwa Haeu oxoxiam ti kawatan ti lialui namilom. ");
INSERT INTO ssg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Aile kewak ien nake nga paxai o seilon tenen pate hanasanas ma saun lialun xioti kokongini o.” ");
INSERT INTO ssg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ape Saimon pahoi ukek, “Amulu kameiwa Haeu lehe i kum axi nga kawatan ti lialui namilok.” ");
INSERT INTO ssg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ti Pita ma Jon kaxi kewa titioalalu sale Jises ma kaxi ahutiwa kakaian, lalu nahih alia hani Jerusalem. Ti aweisalulalu lalu kaxi ahuti meng solian ti Jises hani toan tewau tewau ti Samaria. ");
INSERT INTO ssg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ngain tehu tel engel ti Haeu hone Pilip, “Nahih haniwa tewau aweisal sai haiup he lohong ti i luainiwa Jerusalem hani Gasa.” ");
INSERT INTO ssg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ape salan i nahih. Ti i nanahiwa i apatuini tel seilon ti Itiopia, tel masiwi ti ngahatiai lawe soxi ti tel masiwi hehin ti Itiopia axan Kandis. Tel seilon ien heheisama lotuiai Haeu leili Jerusalem ape i aliliama. ");
INSERT INTO ssg_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","I kiliwau alia hahaniwa tonan leili tea wain karis. I riridai pepai Aisaia tel kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ape Holi Spirit hone Pilip, “Nahih xohi kapita haniwa tea karis.” ");
INSERT INTO ssg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilip kiliwau haniwa kapi tea karis ape i hong tel seilon riridai pepai Aisaia. Ape Pilip kamei i, “O xeu waliko ti o riridai?” ");
INSERT INTO ssg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tel seilon ukek, “Lehe nga xeu ukek ia halik na tel haxewa hani nga?” Ape i ilowi Pilip ku to hani kapin. ");
INSERT INTO ssg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Teik kakai Haeu tel seilon riridai, i ukek, “I masin tok sipsip laha hakahita hani teka teleian. I masin tok nati sipsip i to hamalum na laha koti ole tinun. I kum kak na tenen. ");
INSERT INTO ssg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Woulaha teheni hawane i. Kumahe wanen salan saun ti laha aile hani i. Tap tel pon kaxiai teka laha nakuama tetan nake laha telei i.” ");
INSERT INTO ssg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tel seilon kamei Pilip, “Tel kuluiai kakai Haeu kakak aita leili teik kakai Haeu nga riridai? I kakak puki i a tel seilon liai?” ");
INSERT INTO ssg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ape Pilip kaxi haxewa hani i hutui ti teik kakain ien ma i kaxi ahuti hani i meng solian ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ti lalu kikiliwawa, lalu tahia hani ngixi tehu kan. Ape tel seilon hone Pilip, “Tehu kan ie. Ewi na o baptaisi nga?” ");
INSERT INTO ssg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilip ukek, “Na namilom xoxoan ti Jises Krais, nga baptaisi o.” Ape tel seilon ukek, “Nga soh ka Jises Krais i tel Nati Haeu.” ");
INSERT INTO ssg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tel seilon ti Itiopia hapeti tea karis. Ati lalu mos hani he kan. Pilip baptaisi i ape i sohot kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ti lalu ahutama he kan, Holi Spirit waxi hahutuia Pilip. Tel seilon kum niningah i tuahe i kiliwau tatalewa hetekie amuamu he tian. ");
INSERT INTO ssg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Lokon ien Pilip tahia hani tehu taon Asotus. I kaxi ahuhuti meng solian ti Jises ien ma leili lawe taon ti aweisalun haniwa tehu taon Sisaria. ");
INSERT INTO ssg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lokon ien Sol pate pahan tutuen wanen teleiai teka kahikahi Jises. I nahih hani kapi tel masiwi tapein ti hukuminiai Haeu ma seilon. ");
INSERT INTO ssg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Sol kamea na i tai axi i hina pas lehe i kola hani teka masiwi ti synagog leili tehu taon Damaskas. Tesol pas ien i kaxi ka Sol pon xotiai teka seilon laha usiusi aweisali Krais ma hakahita kalabusialaha hani Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ti Sol nahih xohi hahaniwa Damaskas, teik xewan i ahuma he maun ape i kam hahutuia kakalini i. ");
INSERT INTO ssg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sol put hani itan ape i hong tenen kinax kakane i ukek, “Sol, Sol, nake lahan o to aile hahalialu nga?” ");
INSERT INTO ssg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ape Sol ukek, “Tel masiwi, o aita?” Ape i pahoi ukek, “Nga Jises, tetel o to aile hahalialu. ");
INSERT INTO ssg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Xahatawa, nahih tamus haniwa Damaskas lehe ape o hong waliko tetenen na o aile.” ");
INSERT INTO ssg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tesol seilon kakahiti Sol lato ongaini hawane, tap tel wixiwix. Lato hong kinaxe tel seilon i kakak tuahe lato kum niningah tupuan. ");
INSERT INTO ssg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol xahatale ape i haxepa pulan, tuahe i kum ningahi uke waliko. Aile ape lato akeni minan ape hakahita i hani Damaskas. ");
INSERT INTO ssg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ngain toluhu i kum paxapax. Tin i kum angiang ma unuun kan. ");
INSERT INTO ssg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ti leili Damaskas tel kahikahi Jises axan Ananaias. Lokon ti waliko ien sohot hahani Sol, Haeu tiloi Ananaias i ukek, “Ananaias.” Ape i pahoi ukek, “Alahan tel Masiwi? Nga ie.” ");
INSERT INTO ssg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tel Masiwi kakane i ukek, “Nahih haniwa leili tehu ingi Judas he tewau aweisal axan Sawisawin ape kamea upiawa tel seilon akiki Tarsus, axan Sol. Aope ie i lolotu ien. ");
INSERT INTO ssg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Leilon ti Sol lolotu nga kola hani i ka o Ananaias nahih hana minam patul tetan ti haewiai pulan.” ");
INSERT INTO ssg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaias kak pahoi i ukek, “Tel Masiwi, nga hong kilan seilon tau kakaxi tel seilon ien ka lawe i aile halialu teka wawan ma hehin tetam ti Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ape aope i nahih hanima Damaskas nake teka masiwi tuah ti hukuminiai Haeu ma seilon sowini haniwen i xotiai teka seilon laha lolotui o.” ");
INSERT INTO ssg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tuahe tel Masiwi hone Ananaias, “O nahiwa nake nga kilamiwen i ailei puasak. I kaxi sawateni meng solian tetak hani teka seilon laha kum soh tetak ma hani teka masiwi ti laha hetekie teka seilon ti Israel. ");
INSERT INTO ssg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ape nga hanau i ka liai i tunahi kawatan ma moloan nake i tel unauak.” ");
INSERT INTO ssg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ape se Ananaias nahih soh hani leili tehu ing Sol toto. I hana minan patul ti Sol ape i ukek, “Sol tel akikik Ju, tel Masiwi Jises i take hani kapim he aweisal ti o lua hahanima ie, i taloma nga haewiai pulam ma kameiai Haeu haniam Holi Spirit.” ");
INSERT INTO ssg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Lokon ien wanen, tenen waliko masin ungi xixi i tawakale he puli Sol ape i paxapax alia. I tule ape Ananaias baptaisi i. ");
INSERT INTO ssg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Muhin ien laha axi anan ape tinun kui. Sol tomu teik kapi teka kahikahi Jises leili Damaskas. ");
INSERT INTO ssg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Taen ien i soh hani synagog tehu tehu kakaxi ka Jises i tel Nati Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Lawe seilon teka laha hongoa mengon laha ongaini hawane ape laha ukek, “Nakon i kumahe seilon tetel kemuk ti Jerusalem i aile hahalialu teka seilon laha lolotui Jises? Nakon i ie kumahe ti xotiai teka kahikahi Jises ma hakahitaialaha hani Jerusalem kapi teka masiwi tuah ti hukuminiai Haeu ma seilon?” ");
INSERT INTO ssg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tuahe Sol kaxi ahuti aheke meng solian ti Jises hetekie pohe Haeu. Ape teka Ju ti Damaskas laha hong tataxini ti i kaxi nexi haxewa ka Jises se Krais. ");
INSERT INTO ssg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kilan ngain tamusua ape hina ti teka Ju laha aile namil ti teleiai Sol. ");
INSERT INTO ssg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tuahe Sol tioiwen namilolaha. Ngain ma ipong laha peteni aweingi Damaskas lehe laha telei Sol na i ahuta ti taon. ");
INSERT INTO ssg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tuahe ipong tehu tesol lawan hana i leili tehu po lalap, lato xioti tok tal ape halahe i hani melal ti tehu titieh ti Damaskas. ");
INSERT INTO ssg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Taen Sol tahia haniwa Jerusalem, i tohongi hukuma hani kapi teka kahikahi Jises tuahe lato hatesol mamata i nake lato kum soh ka i tin tel kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tuahe Banabas hakahita Sol hani kapi tesol aposel. I kaxi hani lato ka Sol ningahi Jises he aweisal ti hani Damaskas ape Jises kakak kapin. Tin i kaxi hani lato ka Sol kak matut ti i kaxi ahuti meng solian ti Jises leili Damaskas. ");
INSERT INTO ssg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Aile ape Sol to kapi lato. I kaxi matuke sawateniai meng solian hahitake axe Jises leili Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Lawe i to he kakak kapi teka Ju kakaialaha Grik tuahe lato aile namil ti teleian. ");
INSERT INTO ssg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ti teka kahikahi Jises tioiwa, lato hakahita Sol hani Sisaria ape lato hakau i hani tehu taon Tarsus, tesol puki tonan. ");
INSERT INTO ssg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tataen ien teka kahikahi Jises ti Judia, Galili ma Samaria lato tunahi tonain solian nake tap seilon aile hahalialu lato. Haeu hakui lato ape Holi Spirit aile hasolia hawane lato. Teka kahikahi Jises laha kila ti laha aile usi lawe waliko ti Jises hanauen laha. ");
INSERT INTO ssg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Lokon ien Pita lua hani taon tehu tehu ape ngain telao i nahih paxai teka kahikahi Jises laha toto tehu taon Lida. ");
INSERT INTO ssg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ti ien i tunahi tel seilon axan Enias. Ahang tepanim toluhu i tua engeeng nake tupuan maten. ");
INSERT INTO ssg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita hone i, “Enias, Jises haewia o. Xahatawa! Lumiwa enepam.” Tataen ien wanen Enias xahat. ");
INSERT INTO ssg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lawe seilon ti laha toto Lida ma Saron paxaiwa waliko ti i sohot hani Enias, laha towiahu ti lialui woulaha ape usi Haeu tel Masiwi. ");
INSERT INTO ssg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lokon ien ti tehu taon Jopa, tel hehin kahikahi Jises axan Tabita (ti kakai Grik laha axai Dorkas) lawe i aile saun solian hani teka seilon liai ma i huali teka seilon tap soxi. ");
INSERT INTO ssg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","I tinu mat. Laha kikanomi i ape hanopi hani leili ing teke patul. ");
INSERT INTO ssg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa xohixohin kapi Lida. Taen teka kahikahi Jises hongoa ka Pita Lida, lato talo hua seilon hani kapin ape lalu kakane i, “Pahamite wanen o nahih koseama!” ");
INSERT INTO ssg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita kahiti lalu. Ti i tahiawa, laha waxi i hani leili ing teke patul. Lawe hehin teteka axoalaha matewen laha apuha kalini Pita ape tang kokola puxux ma maia ti Tabita sawiti. ");
INSERT INTO ssg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Muhin ti Pita talo hasohotua laha ti tesol ien, i lokuha ape i kamei huhual ti Haeu. I tale matan hani tel maten ape i ukek, “Tabita xahatawa!” Ti tel hehin haxepale pulan, i ningahi Pita ape i xahat to. ");
INSERT INTO ssg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita akeni mini tel hehin ape huali i hatuhian. I tiloi teka hehin axoalaha matewen ma teka kahikahi Jises liai ape i kola hani lato ka Tabita moih aliawen. ");
INSERT INTO ssg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Meng ti Pita hamoiha Tabita sawat kakalini Jopa ape kilan seilon soh ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita to kue Jopa kapi Saimon, tel seilon ti uluti apeseniai uli manihuh ti hangaini. ");
INSERT INTO ssg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Leili tehu taon Sisaria, tel seilon axan Konilius. I tel masiwi ti hile ti Rom, tehu taon lalap ti Itali. Kilai teka seilon ti hile hahitakan sai 600. ");
INSERT INTO ssg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","I ma teka lohe ingan lato waheni Haeu. Konilius huali teka Ju laha tap soxi ma lawe i lolotui Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Alohah tehu, taun ti i lotu, Haeu hanamiloa i ningahi haxewa tel engel tetan nahih hanima kapin ape i ukek, “Konilius!” ");
INSERT INTO ssg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilius paxai kapitini i hetekie mamata ape i kak ukek, “Tel Masiwi, paham la?” Tel engel pahoi i ukek, “Haeu hongoen lotu tetam ma ningahiwen soliai puasam ti o huhuali teka seilon tap soxi. Haeu amuke tenen woum ien. ");
INSERT INTO ssg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Aope ie taloa teka seilon haniwa Jopa ape hakahitama tel seilon axan Saimon Pita. ");
INSERT INTO ssg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","I heheuta tehu ingi Saimon, tel seilon uluti apeseniai uli manihuh. Ingan tutu peixux. Honewa Pita nahima.” ");
INSERT INTO ssg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ti tel engel kakane kewa Konilius ape i salili i. Konilius tiloi hua unauan pate lolowi ma tel seilon ti hile i waheni Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Konilius kaxi hani lato lawe waliko ti i sohot hani i ape i talo lato hani Jopa. ");
INSERT INTO ssg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ti ngain liai telao, lato nahih xohi hahaniwa Jopa. Ngain tin tetehu, ti lalape ngain, Pita han hani hongini tehu ing, tenen honginan mamanahan, lehe i lotu. ");
INSERT INTO ssg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pita pate i hitol pahan i ang. Ti laha apepeseni tutuen an, Haeu hanamiloa Pita ape i ningahi maun hea. ");
INSERT INTO ssg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ape tenen waliko masin teik lalape maia tumun hahinalopaun xinotan mos hahanima kapin. ");
INSERT INTO ssg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","He teik maia ien manihuh ma manixux tenen tenen. ");
INSERT INTO ssg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pita hong kinaxe Haeu i ukek, “Pita, xahatawa ape telei aniwa!” ");
INSERT INTO ssg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tuahe Pita ukek, “Tel Masiwi, nga kum aile ukek ien. Liai nga kum aniani waliko tenen nauna ti Moses hahalini ma amite teka Ju ukek i kumahe haun.” ");
INSERT INTO ssg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Haeu kakane ulea i ukek, “Waliko ti nga ailewen haun, kum ukekek ka kumahe haun.” ");
INSERT INTO ssg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pita ningahi tesol waliko ien uke he toluhu. Muhin ien teik maia lauta alia hani patul. ");
INSERT INTO ssg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ti Pita to nanamiloi salangawe waliko ti i ningahiwen, tesol seilon tataloi Konilius, lato tunahiwen ingi Saimon ape lato he aweing. ");
INSERT INTO ssg_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ape lato tilol kamea na Saimon Pita toto ien. ");
INSERT INTO ssg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ti Pita nanamiloi tutuen, Holi Spirit hone i ukek, “Tolu seilon nahiwen ie upiaiam. ");
INSERT INTO ssg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Xahatawa, mosua ape kahitiwa lato. Kum hahakila namilom pake puki nga taloma lato.” ");
INSERT INTO ssg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita mos hani kapi lato ape i kak ukek, “Se nga tel seilon amuto upiup. Amuto luama ti waliko la?” ");
INSERT INTO ssg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ape lato ukek, “Konilius tel masiwi ti hile ti Rom taloma amite. I seilon tenen sawisawin, lawe i lolotui Haeu. Teka Ju sameni ka i seilon tenen solian. Tel engel ti Haeu kakane i ka ilowiwa o haniwa leili ingan lehe i hong tenen na o kak.” ");
INSERT INTO ssg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ape Pita ilowi lato lawai i leili ing. Ti ngain liai telao Pita apeas kewa ape i kahiti tesol seilon Konilius taloma. Hina kahikahi Jises ti Jopa tin laha kahitiwa lato. ");
INSERT INTO ssg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ti ngain liai telao, lato tahia hani Sisaria, tetesol Konilius atetengi lato. Tesol akikin ma tesol lohun hoi laha apupuha ien. ");
INSERT INTO ssg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ti Pita sohoa, Konilius nahih tengeni i ape lokuha matan. ");
INSERT INTO ssg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pita akeni minan ape hone i, “Tule! Nga tuahe seilon masin o.” ");
INSERT INTO ssg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita kakak tutuen kapin ape i ningahi kilan seilon apupuha leili tehu ing. ");
INSERT INTO ssg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita kakane lato ukek, “Amuto tioi hawane ka hahalin wanen ti amite teka Ju hukuma kapi teka seilon ti xux liai. Tuahe Haeu kola haniwen nga ka tap hahalin ti na nga lawai tuahe tel na seilon. ");
INSERT INTO ssg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Aile ape ti Konilius ilowima nga, tap nga watakai. Konilius, nake lahan o tapea waxi nga?” ");
INSERT INTO ssg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilius kak pahoi ukek, “Ngain hinalo tamusuen ti nga lolotu, nga ningahi hahutuia tel engel puxuaun pate i xeu talepalep. ");
INSERT INTO ssg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ape i kakane nga, ‘Konilius, Haeu hongoen lotu tetam ma ningahiwen soliai puasam ti o huhuali teka seilon tap soxi. Haeu amuke tenen woum ien. ");
INSERT INTO ssg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Taloa teka seilon haniwa Jopa ape hakahitama tel seilon axan Saimon Pita. I heheuta tehu ingi Saimon, tel seilon uluti apeseniai uli manihuh. Ingan tutu peixux.’ ");
INSERT INTO ssg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aile ape nga tapea kosea waxiam. Ti soliaiam o tahiama. Amite hatesol apupuha ie ti puli Haeu hongoi lawe waliko i hohone o kaxi haniamite.” ");
INSERT INTO ssg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita hutui kakaian ukek, “Aope ie nga paxai tioi ka Haeu kum aile nenexi seilon. ");
INSERT INTO ssg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Haeu amuke teteka seilon ti lawe xux laha lolotui i ma aile saun tenen i pahan. ");
INSERT INTO ssg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Amuto tioi tenen meng solian ti Jises Haeu haniwen amite tesol seilon ti Israel. Jises, Masiwi ti lawe seilon, i aile hasolia wasolakaha hani Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Amuto tioi waliko ti i sohot kakalini Judia, hutui Galili ti Jon Baptis hone teka seilon lioi xaxaweniai saun lialun lehe i baptaisi laha. ");
INSERT INTO ssg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Amuto tioi Haeu hani Jises Holi Spirit ma poh. I nahih hani tesol tesol ailei puasain solian ma haewiai teka seilon spirit lialun kapiti hahalialu nake Haeu kapin. ");
INSERT INTO ssg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Amite tesol aposel, amite kaxi ahuti lawe waliko ti amite ningahi i aile leili xuxumite teka Ju hetekie Jerusalem. Ape imuh laha tahi hakea i he kros ape i mat. ");
INSERT INTO ssg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tuahe muhi ngain toluhu Haeu xahateni aliake i ti matean ape kilan seilon ningahiwen ka i moihin. ");
INSERT INTO ssg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kumahe lawe seilon ningahiwen i, mewenae amite tesol ang akatiwen i muhin ti i moih aliawa. Liai Haeu kilamiwen amite ti kaxi ahutiai meng solian ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ape i hone amite ti kaxi haxewa haniai teka seilon ka i tetel Haeu kilamiwen hinitiai seilon, teka moihin ma teka maten. ");
INSERT INTO ssg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Hatesol teka kuluiai kakai Haeu lato tai kaxiwen ka Haeu oxoxi teka seilon ti kawatan ti saun lialun ti pohe Jises, na namilolaha xoxoan tetan.” ");
INSERT INTO ssg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ti Pita kakak tutuen, Haeu axi Holi Spirit hani hatesol seilon laha hongohong kakai Pita. ");
INSERT INTO ssg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tesol Ju kahikahi Jises lato kahitima Pita ti Jopa pate lato ongaini ka Haeu tin i axi Holi Spirit hani teka seilon laha kumahe Ju. ");
INSERT INTO ssg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Lato hong teka seilon ien kakak kakain ti kumahe kakaialaha ti Holi Spirit hanamiloa laha ma lato hong laha sasameni Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ape Pita ukek, “Tesol seilon ie kewen Holi Spirit masin kako teka Ju. Aile ape tap tel pon konginiakako ti baptaisialato ti kan.” ");
INSERT INTO ssg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ape Pita hone tesol seilon kumahe Ju i ukek, “Amuto kewa baptais hahitake axe Jises.” Ti lato baptais kewa, lato kamei eliel Pita na i tilimuen teik kapi lato. ");
INSERT INTO ssg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tesol aposel ma teka kahikahi Jises liai ti tesol tesol ti Judia, lato hongoen ka teka kumahe Ju tin laha hong soh kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ape ti Pita nahih tahia haniwa Jerusalem, teka Ju kahikahi Jises lato kahiloloi i. ");
INSERT INTO ssg_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Lato ukek, “O heheuta ingi teka kumahe Ju ma tin o angiang kapi laha.” ");
INSERT INTO ssg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ape Pita hutui kaxi haxewa hatapo hani lato waliko ti i sohotuen. ");
INSERT INTO ssg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","I ukek, “Ngain telao ti nga Jopa, leilon ti nga lolotu, Haeu hanamiloa nga ningahi tenen waliko masin teik lalape maia mosulih he maun hahanima kapik. ");
INSERT INTO ssg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nga pax haniwa he teik maia, nga ningahi manihuh ma manixux tenen tenen. ");
INSERT INTO ssg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ape nga hong kinaxe Haeu i ukek, ‘Pita, xahatawa ape telei aniwa.’ ");
INSERT INTO ssg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Tuahe nga ukek, ‘Tel Masiwi, nga kum aile ukek ien. Liai nga kum aniani waliko tenen nauna ti Moses hahalini ma amite teka Ju ukek kumahe haun.’ ");
INSERT INTO ssg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ape Haeu kakane ulea nga, ‘Waliko ti nga ailewen haun, kum ukekek ka kumahe haun.’ ");
INSERT INTO ssg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nga ningahi tesol waliko ien uke he toluhu. Muhin ien teik maia lauta alia hani patul. ");
INSERT INTO ssg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Lokon ien wanen tolu seilon laha taloma ti Sisaria tahia hanima ing tetehu nga heheuta. ");
INSERT INTO ssg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Holi Spirit kakane nga ka nga kahitiwa lato kum hahakila namilok. Tepanim tel kahikahi Jises ie tin lato kahiti nga hani Sisaria ape amite hatesol nahih hani leili ingi Konilius. ");
INSERT INTO ssg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Konilius kaxi hani amite ka i ningahi tel engel ti Haeu leili ingan. Tel engel kakane i, ‘Taloa teka seilon haniwa Jopa ape hakahitama tel seilon axan Saimon Pita. ");
INSERT INTO ssg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","I kaxi ahuti hani o meng solian ti Jises. Na o ma hatesol seilon leili ingam hong soh kakaian, Jises awai amuto ti kawatan ti saun lialun ti amuto.’ ");
INSERT INTO ssg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ape tataen nga hutui kakaiak, Haeu hani teka seilon ien Holi Spirit masin ti i hani kako teka Ju lokon ti Pentekos. ");
INSERT INTO ssg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tataen ien wanen nga nameni kakai tel Masiwi Jises, i ukek, ‘Jon baptaisi seilon ti kan, tuahe Haeu hani amuto Holi Spirit ti kapitiamuto.’ ");
INSERT INTO ssg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pate xewan ka Haeu haniwen lato teka kumahe Ju Holi Spirit masin ti i haniwen kako teka Ju, ti kako soh ti Jises tel Masiwi. Na masin ien, nga aita lehe nga pon konginiai Haeu?” ");
INSERT INTO ssg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ti lato hong kewak ien ape lato kum kahiloloi Pita. Lato sameni Haeu ukek, “Haeu tin hanamiloa teka kumahe Ju lehe laha towiahu ti saun lialun ape laha uke tonain kapin ti tap tahi tapoan.” ");
INSERT INTO ssg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Teteka kahikahi Jises lato ox hani tesol tesol nake laha axi lato kawatan ti lokon laha telei Stiven, lato lua hani tataen Penisia, Saiprus ma Antiok. Lato kakaxi meng solian ti Jises hani mewenae teka Ju. ");
INSERT INTO ssg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tuahe teka ti lato ti Saiprus ma Sairini lua hani Antiok ape tin lato kakaxi meng solian ti Jises hani teka kumahe Ju. ");
INSERT INTO ssg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Pohe Haeu huali lato ape kilan seilon hong soh meng solian ti Jises. Laha towiahu ti saun lialun ape usi Jises Krais tel Masiwi. ");
INSERT INTO ssg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tesol kahikahi Jises ti Jerusalem hong tunahiwa ape lato talo Banabas hani Antiok. ");
INSERT INTO ssg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ti i tahiawa i paxai solian ti Haeu aile hani teka Antiok ape i amuam hawane. I hone lato ti haxoxoi namilolato ti Jises Krais ma hani hatapoi tupualato ti wahenian. ");
INSERT INTO ssg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas hina namil xoxoan ti Jises. I tel seilon solian nake Holi Spirit kakapiti i. Kilan seilon soh ti Jises ti laha hongoa kakai Banabas. ");
INSERT INTO ssg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Muhin Banabas lua hani Tarsus ti upiai Sol. ");
INSERT INTO ssg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ti i tunahiwa, ati lalu alia hani Antiok. Lawe lalu huhukuma kapi teka kahikahi Jises ma hahanau kilan seilon sale puase Jises leili ahang tehu. Lokon ien ti Antiok, laha axai hutui teka kahikahi Jises, Kahikahi Krais. ");
INSERT INTO ssg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ti lokon ien teka kuluiai kakai Haeu ti Jerusalem lato lua hani Antiok. ");
INSERT INTO ssg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tel ti lato axan Agabus tule leili tehu apuhain lalap ape hetekie huhual ti Holi Spirit i kak kilami tehu hitolo lalap i sohot hani hatehu pon ie. Ape imuh i sohot hawane, lokon Klodius masiwi tapein ti Rom. ");
INSERT INTO ssg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aile ape teka kahikahi Jises ti Antiok namiloi ka lato tel tel hakau huhual ti lato pon, ti hualiai teka kahikahi Jises ti Judia. ");
INSERT INTO ssg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ti lato apeseni kewa waliko ti huhual, lato hani he mini Banabas ma Sol lehe lalu hakau hani teka masiwi ti kahikahi Jises leili Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lokon ti Banabas ma Sol lua hani Jerusalem, tel masiwi Herod Agripa xoti teka ti kahikahi Jises lehe i aile halialu lato. ");
INSERT INTO ssg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","I talo teka unauan teleiai tel aposel Jeims, tel ukale Jon. Laha koti kinawen ani ngol weluwelun. ");
INSERT INTO ssg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ti i paxaiwa ka teka Ju pate laha amuke waliko ti i ailewen, i xoti ulei Pita. Tesol waliko ien i sohot lokon ti Pasova, ngain ti nameniai lokon Haeu waxi aliake teka Ju ti Igip. ");
INSERT INTO ssg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herod lohi Pita hani kalabus ape i hana teka unauan ti hile petenian. I sei lato hinalo hinalo ukei aua toluhu toluhu. Herod namiloi i hatuhi Pita ti sulusulu he puli lawe seilon muhi Pasova. ");
INSERT INTO ssg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tuahe ti Pita leili kalabus, teka kahikahi Jises lato lotu kamei eliliel Haeu hualian. ");
INSERT INTO ssg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ipong tehu imat ti Herod pahan i hatuhi Pita ti sulusulu, Pita mamatih leili kalabus wasole hua petenian. Laha xinoti i ani sen hani lalu hauhua ape hua liai pepeteni aweing. ");
INSERT INTO ssg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tel engel ti Haeu take hahutuia hani kapi Pita ape xewan haxewa tehu ingi kalabus. Tel engel huei hangoni i ukek, “Xahat koseawa!” Ape sen tua put oxoxa he mini Pita. ");
INSERT INTO ssg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tel engel hone i ukek, “Xinotiwa tehu puxuaum ape nihiniwa sueum.” Pita aile usi ape tel engel kak ukek, “Hanawa tehu atuhiai puxuaum ape kahitima nga.” ");
INSERT INTO ssg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita nahih sohot kahiti i ti ingi kalabus. I kum ukek waliko ti i sosohot salan wanen. I sokok ka Haeu tua hahanamiloa i ningahi tesol waliko ien. ");
INSERT INTO ssg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Lalu nahih sahiwa teka peteniai kalabus imat ma teka liai ape lalu nahih tamus hani tewau kahip samen haniwa leili taon. Tewau kahip i tua hea ape lalu nahih ahuta. Lalu nanahiwa he aweisal ape tel engel kaluta hahutuia ti Pita. ");
INSERT INTO ssg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pita namilon ape i xeu waliko ti i sohot hani i ape i ukek, “Nga tioi salan wanen! Tel Masiwi taloma tel engel oxoxiak ti Herod ma ti hatesol waliko teka Ju nanamiloi laha aile hani nga.” ");
INSERT INTO ssg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ti namilon xewawa i nahih hani ingi Mary tel tini Jon Mak. Kilan kahikahi Jises apupuha ien ti lotu hualiai Pita. ");
INSERT INTO ssg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita tuitui kahip ti melal ape tel hehin uluha, axan Roda, nahih paxai. ");
INSERT INTO ssg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ti tel hehin hong tioiwa kinaxe Pita, amuamuaian i tai hei aweing. I kiliwau hahongo teka liai ka Pita tutu melal. ");
INSERT INTO ssg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Lato hone tel hehin, “O taxitaxiawen!” Tuahe i kak tatale ka salan wanen. Ape lato ukek, “Sohin tel engel ngahatian.” ");
INSERT INTO ssg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pita tui tatale kahip. Ti lato heiwa lato ong hawane ti lato ningahiwa Pita. ");
INSERT INTO ssg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita aile kola minan hani lato ka kum wixiwix ape i kaxi hani lato aweisal ti Haeu ahuti i ti kalabus. Ape i ukek, “Kaxi haniwa Jeims tel ukale Jises ma teka kahikahi Jises liai waliko ti i sohot haniwen nga.” Ape i nahih salili lato hani tesol liai. ");
INSERT INTO ssg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ti ape letu, teka peteniai kalabus laha kum niningah Pita. Pate laha mamata ma tataxini. Laha ukek, “Nakon Pita oxoxa ukek ia?” ");
INSERT INTO ssg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod talo teka unauan upia elieliwa Pita tuahe lato kum tunahi. Ape Herod kamei hakila kamekame hani teka peteniai Pita. Muhin Herod hone teka unauan teleiwa lato. Lokon ien Herod sos salili Judia hani Sisaria ape i to ien. ");
INSERT INTO ssg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Telao Herod lon pate lialun ti teka seilon ti Taia ma Saidon. Teka seilon ien pahalaha aile hasolia wasolalaha ma Herod nake laha kema analaha ti xuxi Herod. Ape laha kamei eliel huhual ti Blastus, tel unaui Herod pate i papanga kapin. Hetekie huhual tetan Herod waheni na i to kakak kapi laha. ");
INSERT INTO ssg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tehu ngain Herod kilami ti i to kakak kapi laha, i puxui tehu puxuaun ti masiwi, i to he tehu tonain tuah tetan ape i kaxi ahuti kakaian. Kilan seilon apupuha hongoi kakai Herod. ");
INSERT INTO ssg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Laha tilol ukek, “I haeu, kumahe tuahe seilon.” ");
INSERT INTO ssg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tel engel ti Haeu aile hatinu hahutuia Herod nake i kum lotui Haeu. Ul tan leili tian ape imuh i mat. ");
INSERT INTO ssg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Teka kahikahi Jises sawateni tutuen meng solian ti Jises ape kilan seilon laha hong soh kakaialato. ");
INSERT INTO ssg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas ma Sol hatapoa pupuasalalu ti atoheniai huhual hani teka kahikahi Jises ti Jerusalem ape lalu alia hani Antiok hetekie Jon Mak. ");
INSERT INTO ssg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Leili teka kahikahi Jises ti Antiok, Banabas, Simeon tel laha axai i Polun, Lusius ti Sairini, Sol ma Manaen, tel i lap tuaima Herod Antipas. Tesol seilon ien lato teka kaxi ahutiai meng solian ti Jises ma hanaui seilon sale usian. ");
INSERT INTO ssg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ngain tehu ti teka kahikahi Jises hahalini an ti hualiai lotu ti lato hani Haeu, Holi Spirit hone lato ukek, “Talaheniwa Banabas ma Sol hanima nga nake nga hina puasain tuah ti lalu.” ");
INSERT INTO ssg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Lato halini tatale an ma lotu tatale. Lato hana minalato patul ti lalu kameiai Haeu ti hakuialalu. Ape lato talo lalu ailei puasain ti Holi Spirit kikilami lalu puasakean. ");
INSERT INTO ssg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Holi Spirit kapiti Banabas ma Sol hani tehu taon Selusia ape lalu lang hani texux xux Saiprus. ");
INSERT INTO ssg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ti lalu tahia haniwa tehu taon Salamis, lalu kaxi ahuti kakai Haeu leili synagog. Jon Mak tin kapi lalu, i huali lalu ailei puasain. ");
INSERT INTO ssg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Lato kolia koti Saiprus hani tehu taon Papos. Ti ien lato tunahi tel seilon axan Bar Jises, akiki Ju. I woinakon kuluiai kakai Haeu. I hahapuasa pohe spirit lialun ailei puasan. ");
INSERT INTO ssg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","I lohi Sergius Paulus, tel masiwi kiliwakei Saiprus, seilon tenen namilon xewan. Sergius Paulus ilowi Banabas ma Sol nake pahan i hong kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Tuahe Bar Jises, axan tenen liai Elimas, i nam watakai Banabas ma Sol ape i xui Sergius Paulus kum hong sohosoh lalu uke i sohot kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sol, ti aope laha axai i Pol, Holi Spirit hanamiloa i ape i paxai kahiloloi Elimas. ");
INSERT INTO ssg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","I ukek, “O unaui Satan! O pahoxai hatapo waliko tenen solian, o puluti seilon ma aile hakila saun lialun. Kakai Haeu lawe o kaxi towiahu hani puputa. ");
INSERT INTO ssg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","O ape Haeu axi tenen kawatan. O pulaxamu ape o kum tua pon ningahiai al.” Tataen ien wanen Elimas kum pon paxapax. I soxa upiup aweisalun ape i kamea na tel ati i. ");
INSERT INTO ssg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ti Sergius Paulus ningahiwa waliko ti i sohot hani Elimas, i soh ti Jises ape i ong amuke waliko ti Pol ma Banabas hahanau sale puase Jises tel Masiwi. ");
INSERT INTO ssg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol ma hua mahoan lato lang ti Papos hani Perga, tehu taon ti Pampilia. Ti ien Jon Mak lua salili Pol ma Banabas ape i alia hani Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ape lalu lua salili Perga hani Antiok, tehu taon ti Pisidia. Telao Sabat lalu nahih hani leili synagog. Lalu to ape lotu kapi teka Ju. ");
INSERT INTO ssg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Muhin ti tel seilon kaxi kewa hina nauna ti Moses ma ti teka kuluiai kakai Haeu, teka masiwi ti synagog kamei Pol ma Banabas ukek, “Hua Ju akikimite, na amulu hina kakain ti hualiamite, kakawa.” ");
INSERT INTO ssg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol tua, i tulini minan i kola ka ape i kak. I ukek, “Amuto tesol Israel ma tesol kumahe Ju amuto lolotui Haeu, hongoa! ");
INSERT INTO ssg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tel Haeu ti kako teka Israel lolotui, i kilamiwen tetan tesol tamakako ti matahaun. Lokon ti lato toto Igip, Haeu hakila lato ape ti kui pohen, i oxoxi lato ti Igip. ");
INSERT INTO ssg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ti lato nanahiwa he lohong leili ahang 40, Haeu kum lioi lato kalak lato kum hong tamani i. ");
INSERT INTO ssg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Haeu huali teka Israel hileiai teka akiki tepanim huoxux xux liai laha toto leili texux xux Keinan. Ape Haeu hani lato tamai hepekeun ti Keinan. ");
INSERT INTO ssg_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","I uke 450 ahang ti hil waxiai hepekeun ien. “Muhin ien i axi lato masiwi ti neinialato hanima taen ti Samuel, tel kuluiai kakaian. ");
INSERT INTO ssg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Imuh lato kamei Haeu axialato tel masiwi liai. Ape i hani lato Sol, tel nati Kis, kahi nati Benjamin. I masiwi ti lato leili ahang 40. ");
INSERT INTO ssg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Muhin ti Haeu xaxaweniwa i masiwi ti lato, i kilami David. Haeu kakak sale David ukek, ‘Nga amuke hawane David, tel nati Jesi. I aile hatapo waliko tenen pahak.’ ");
INSERT INTO ssg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Ti leili teka kahi nati David, Haeu hani teka Israel Jises, tel awaialato ti kawatan ti saun lialun ti lato, masin ti i kakawen. ");
INSERT INTO ssg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Imat ti Jises hutui puasan, Jon Baptis kakane hatesol seilon ti Israel ka laha towiahua ti saun lialun ape usiwa Haeu lehe Jon baptaisi laha. ");
INSERT INTO ssg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ti lehe Jon hatapo puasan i hone teka seilon, ‘Amuto sokok nga aita? Nga kumahe Krais, tel amuto to atetengi. I sohotuma muhik. Masiwiaian ala i kum pon nga unauan.’ ");
INSERT INTO ssg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Amuto teka kahi nati Abraham ma teka kumahe Ju amuto lolotui Haeu, tenen meng solian ti Jises awai kako ti kawatan ti saun lialun, Haeu hani kako hatesol. ");
INSERT INTO ssg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Teka seilon ti Jerusalem ma teka masiwi ti laha, laha kum paxai tioi Jises. Tuahe ti laha hani Jises he mini teka teleian, i hapoponowi hawane kakai teka kuluiai kakai Haeu ti lawe kako riridai na Sabat. ");
INSERT INTO ssg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kalak laha kum tunah huan ti teleiai Jises, laha kamei Pailat ka teleiwa i. ");
INSERT INTO ssg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Ape ti laha aile hatapoa waliko ti kakai Haeu kakawen, laha hamosu tupui Jises ti he teik kros ape hana i hani he amal. ");
INSERT INTO ssg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tuahe Haeu xahateni aliake Jises. ");
INSERT INTO ssg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ape teka seilon lato kakahiti i ti Galili hani Jerusalem, ngain kilan lato ningahi i moihin. Teka seilon ien kaxi sawateni lawe waliko ti lato ningahiwen hani kako hatesol. ");
INSERT INTO ssg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ape amili kaxi hahani amuto meng solian ie. ");
INSERT INTO ssg_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Waliko ti Haeu kakanewen tesol tamakako ti matahaun i hapoponowi hani kako tesol kahi natulato ti i hamoiha aliake Jises. Masin ti Haeu kakawen leili pepai Salm, i ukek, “‘O se Natuk. Nga kilamiwen o ailei puasak.’ ");
INSERT INTO ssg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Haeu hamoiha Jises ti matean lehe i kum mat ulea, masin ti Haeu kakawen leili pepai tel kuluiai kakaian i ukek, “‘Nga aile hasolia hani amuto masin ti nga kakanewen tel masiwi David.’ ");
INSERT INTO ssg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Masin ti David kakak kapi Haeu ti i ukek, “‘O kum hani tel unauam solian koha leili amal.’ ");
INSERT INTO ssg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David kumahe i kakak alia i nake ti i aile hatapoa puase Haeu lokon ti i masiwi ti teka Israel, i mat ape laha tihini i kapi teka taman ti matahaun ape tupuan i koha. ");
INSERT INTO ssg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Tuahe Jises, tel Haeu hamoiha ti matean, i tai koha leili amal. ");
INSERT INTO ssg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Aile ape pahak amuto xeu waliko ti amili kaxi hahani amuto ka Haeu oxoxi seilon ti kawatan ti lialui woulaha nake ti puase Jises. ");
INSERT INTO ssg_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Wasolakaha seilon ma Haeu i kum sawi na kaha tua hong usi mewenae nauna ti Moses. Se mewenae na namilokaha xoxoan ti Jises, Haeu namiloi ukek kaha seilon sawisawin. ");
INSERT INTO ssg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Lepetawa uke waliko ti Haeu kakawen leili pepai tel kuluiai kakaian i sohot hani amuto. ");
INSERT INTO ssg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“I ukek, ‘Teteka ti amuto mal sosoxeni nga, hongoa! Amuto ong mamata ape amuto mat nake kawatan nga hani amuto pate lialun wanen. Amuto kum soh ti kawatan ien, kalak na seilon nexi hahani amuto.’” ");
INSERT INTO ssg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ie tiliai kakai Pol. Ti ape lehe Pol ma Banabas nahih sohot he synagog, tesol seilon ien ilowi lalu alia uleama Sabat tehu toma lehe lalu kaxi ulea waliko ti lalu kakaxi. ");
INSERT INTO ssg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Muhin ti laha heisawa lotu, kilan teka laha soh kakai Pol, teka Ju ma teka kumahe Ju, laha kahiti Pol ma Banabas. Lalu kakak kapi laha ape hakui laha ti tu xox tatale ti xoxoi namilolaha hani Jises nake ti lalape soliai Haeu i hani laha tel Natun. ");
INSERT INTO ssg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabat liai tehu, sikole ka hatesol seilon ti Antiok nahih hani synagog ti hongoi meng solian ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Taen ti teka masiwi ti teka Ju ningahiwa kilai seilon, namilolato i lialu ti Pol ma Banabas ape lato kak halialu kakai Pol. ");
INSERT INTO ssg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tuahe Pol ma Banabas kak matut, lalu ukek, “Haeu taloma amili kaxiai meng solian ti Jises hanimu amuto teka Ju, tuahe amuto kum hong soh. Ien i kola ka amuto kumahe solian ti i tapai amuto uke tonain kapi Haeu ti tap tahi tapoan. Aile ape aope ie amili kaxi meng solian ti Jises hani teka kumahe Ju. ");
INSERT INTO ssg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Masin ti Haeu kakanewen tel Natun, i ukek, “‘Nga kilami o hanowi xewan ti hani lawe seilon ti xux tesol tesol lehe o awai laha ti kawatan ti saun lialun ti laha.’” ");
INSERT INTO ssg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ti teka kumahe Ju hongoa, pate laha amuam ape laha sameni kakai Haeu. Teteka ti Haeu kilamiwen laha ukei tonain kapin ti tap tahi tapoan, laha hong soh meng solian ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ape meng ien i sawata kakalini Antiok. ");
INSERT INTO ssg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tuahe teka masiwi ti teka Ju lato hahika teka masiwi ti Antiok ma tesol hehin kumahe Ju lato lolotui Haeu ma axalato lalap. Tesol seilon ien xui teka seilon ti Antiok aile halialui Pol ma Banabas ape usi xaxawenialalu ti ien. ");
INSERT INTO ssg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Aile ape Pol ma Banabas tapahi hepekeun ti he anele aelalu, i kola ka Haeu kum amuke teka seilon ien. Ape lalu lua hani tehu taon Ikonium. ");
INSERT INTO ssg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Teka kahikahi Jises ti Antiok lato to amuam hawane ma Holi Spirit kapiti tatale lato. ");
INSERT INTO ssg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ti Ikonium Pol ma Banabas nahih hani tehu synagog. Lalu kakak hetekie pohe Haeu, aile ape kilan teka Ju ma teka kumahe Ju laha hong soh meng solian ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tuahe teteka Ju laha kum hong soh, laha hahika teka kumahe Ju ti watakaiai Pol ma Banabas. ");
INSERT INTO ssg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pol ma Banabas to kue ien ape lalu kaxi matuke ka ti lalape soliai Haeu i hani teka seilon Jises. Haeu kola ka kakaialalu salan ti i hani lalu poh ti aile hasohotui kilan kolakol tenen lalap. ");
INSERT INTO ssg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tuahe teka seilon ti Ikonium laha tikela, teka tepaun ti teka Ju laha kum soh ti Jises ape teka tepaun ti Pol ma Banabas. ");
INSERT INTO ssg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tesol ti teka Ju ma kumahe Ju hetekie teka masiwi ti lato, lato aile namil ti aile halialui Pol ma Banabas ape hokai telei lalu pot. ");
INSERT INTO ssg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Tuahe ti lalu tioiwa, lalu ox hani Listra ma Derbe, huohu taon leili Likaonia ma tesol toan melal ti taon ien. ");
INSERT INTO ssg_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ti ien lalu kaxi tatale meng solian ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ti Pol ma Banabas Listra lalu tunahi tel seilon aen lialun. I kum nanahih lilian ti i takahan. ");
INSERT INTO ssg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ngain tehu i to hongohong ti Pol kakaxi meng solian ti Jises. Ti Pol pax sawi haniwa i, i paxai tioi ka tel seilon ien namilon xoxoan ka Jises pon haewian. ");
INSERT INTO ssg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ape Pol tilol hani i ukek, “O tua!” Ti i kakawa, tel seilon tit tua ape i tau nanahih. ");
INSERT INTO ssg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ti teka kilai seilon ningahiwa waliko ti Pol aile, laha tilol ausisini ti kakaialaha Likaonian, “Hua haeu lalu sohot hanowi seilon ape mosuen kapi kako.” ");
INSERT INTO ssg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ape laha axai Banabas Seus nake Seus i tel masiwi ti teka haeu laha lolotui ape Pol laha axai Hermes nake laha soh ka i tel ti kaxiai kakain. ");
INSERT INTO ssg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tehu ing ti lotuiai Seus xohixohin melal ti taon. Tel masiwi ti hukuminialaha ma Seus i atima bulmakau ti laha hahasahe palawa he kinawen, haniwa he aweing ti Listra nake i ma teka seilon pahalaha aile pali hani lalu. ");
INSERT INTO ssg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tuahe ti Banabas ma Pol paxai tioiwa, lalu lexi puxuaulalu nake lalu watakai hawane ape lalu kiliwau hani leili teka seilon. ");
INSERT INTO ssg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Lalu tilol ukek, “Kalahai amuto aile saun tetenen? Amili tuahe seilon masin amuto. Amili ie ti kaxi haniamuto meng solian ti Jises lehe amuto kum lotui haeu tenen kumahe salan ma kum pon hualiai seilon. Amuto lotuiwa Haeu telawe, tetel i tanomi hatesol waliko ti patul, hatesol hepekeun ti itan ie ma itax ma waliko ti heihon. ");
INSERT INTO ssg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ti imat, Haeu hani lioi teka kumahe Ju aile usi waliko ti pahalaha. ");
INSERT INTO ssg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tuahe Haeu kola ka i salan nake ti soliaian i hani amuto akah ma an ti he kinemuto. I axi hapono hawane amuto an ape i aile hamuamua amuto.” ");
INSERT INTO ssg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kalak tesol kakain ien, ailan wanen ti konginiai teka seilon ti ailei pali hani lalu. ");
INSERT INTO ssg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Muhin ien tesol ti teka Ju ti Antiok ma Ikonium lato tahiama ape itini namili teka seilon ti Listra hani tepaun ti lato. Laha hokai Pol pot ape itini leleteni i hani melal ti taon. Laha sokok i matewen. ");
INSERT INTO ssg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tuahe tataen ti teka kahikahi Jises nahih apuha kaliniwa Pol, i tu hahutuia ape i kahiti aliake lato hani leili taon. Ti ngain liai tehu Pol ma Banabas lua hani tehu taon Derbe. ");
INSERT INTO ssg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ti Derbe, Pol ma Banabas kaxi meng solian ti Jises ape kilan seilon laha sohot kahikahi Jises. Muhin ien lalu alia hani Listra, Ikonium ma Antiok. ");
INSERT INTO ssg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Lalu kakane hakui teka kahikahi Jises ape hone lato akeni kongini tatalei namil xoxoan ti Jises. Lalu ukek, “Kako tunahi kilan kawatan imat ti kako to kapi Haeu tel neiniakako lian tehue.” ");
INSERT INTO ssg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ti lawe taon ien Pol ma Banabas kilami teka masiwi ti ngahatiai teka kahikahi Jises. Lalu lotu ape lalu halini hetekie an ti hualiai lotu ti lalu. Lalu kamei Haeu ti hualiai teka kahikahi Jises laha hana hatapo namilolaha hani Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Imuh lalu luaini kotiwa Pisidia ape lalu tahia hani texux xux Pampilia. ");
INSERT INTO ssg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ti ien lalu kaxi meng solian ti Jises leili tehu taon Perga ape imuh lalu lua tamus hani tehu taon Atalia. ");
INSERT INTO ssg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ti ien lalu lang alia hani Antiok ti Siria, tetesol ti lalu hutui ailei puasalalu. Lokon ti imat, teka kahikahi Jises ien laha kamei Haeu hualialalu ailei puasain ti ape lalu hatapoen. ");
INSERT INTO ssg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Lalu apuhini hatapo teka kahikahi Jises ien ape lalu kaxi hatapo hatesol waliko ti Haeu hualiwen lalu ailean. Tin lalu kakane lato ti sale Haeu hei aweisal hani teka kumahe Ju lehe laha soh ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ape lalu to kue ien kapi teka kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tesol seilon ti Judia lato lua hani Antiok ape lato hutui hanaui teka kahikahi Jises ukek, “Amuto ailewa teik kikilam ti kotiai uli walikoumuto usiwa nauna ti Moses. Na amuto kum aile ukek ien, Haeu kum awai amuto ti kawatan ti saun lialun ti amuto.” ");
INSERT INTO ssg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol ma Banabas kak hapatapat kapi tesol seilon ien. Aile ape teka kahikahi Jises hakau Pol ma Banabas hetekie teka kahikahi Jises liai hani Jerusalem ti paxaiai tesol aposel ma teka masiwi ti teka kahikahi Jises ti ingi lotu ti hasawiai teik waliko ien. ");
INSERT INTO ssg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ti lato lua hahaniwa xux ti Penisia ma Samaria kane Jerusalem, lato kaxi hahani teka kahikahi Jises aweisal ti teka kumahe Ju laha sohot kahikahi Jises. Tenen meng ien aile hamuamua hawane teka kahikahi Jises ien. ");
INSERT INTO ssg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ti lato tahiawa Jerusalem, tesol aposel, teka kahikahi Jises liai ma teka masiwi ti lato waxi auni lato. Ape Pol ma Banabas kaxi hatesol waliko Haeu hualiwen lalu ailean. ");
INSERT INTO ssg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Muhin ien teka kahikahi Jises lato tepaun ti teka Parisi lato tua ape lato ukek, “Teka kumahe Ju laha usi hatapoa hatesol nauna ti Moses. Laha ailewa teik kikilam ti kolakol ka laha seilon ti Haeu.” ");
INSERT INTO ssg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ape tesol aposel ma teka masiwi ti kahikahi Jises leili Jerusalem lato apuha ti kak paxaiai teik waliko ien. ");
INSERT INTO ssg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Muhi welui kak hapatapat ti lato, Pita tule ape i ukek, “Amuto tesol akikik ahuma ti Jises, amuto tioi ka hina ngain tamusuen Haeu kilami nga, tel ti leilomuto, kaxiai meng solian ti Jises hani teka kumahe Ju lehe laha hong soh ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Haeu tel i tioi namili hatesol seilon, i kola ka i namiloi ukek laha seilon tuah ti i hani laha Holi Spirit masin ti i hani kako. ");
INSERT INTO ssg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ti i aile teik waliko ien i kola ka laha kumahe liai tenen ti kako. Ape Haeu oxoxi laha ti kawatan ti saun lialun ti laha nake laha hana hatapo namilolaha hani Jises. ");
INSERT INTO ssg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Aile ape amuto kum aile hahalenge Haeu! Kum hahani laha kawatan ti usiai hatesol nauna ti Moses nake tamakako ti matahaun ma puki kako kum pon usian. ");
INSERT INTO ssg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kako soh ka ti lalape soliai Jises tel Masiwi ti kako, i awai kako ti kawatan ti saun lialun ti kako. Tin masin teka kumahe Ju.” ");
INSERT INTO ssg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ti Pita kak kewa, tap tel wixiwix ape lato hong ulea Pol ma Banabas. Lalu kaxi hatapo hatesol kolakol lalap ti Haeu hualiwen lalu ailean hani teka kumahe Ju. ");
INSERT INTO ssg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Muhin ti lalu kak kewa, Jeims ukek, “Amuto tesol akikik ahuma ti Jises, hongoa! ");
INSERT INTO ssg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Waliko ti Saimon Pita kakaxi, i haxewa haniwen kako ka Haeu namiloi tahane teka kumahe Ju. I huali laha ape teka ti laha sohot seilon tetan. ");
INSERT INTO ssg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Masin ti Haeu kakawen leili pepai teka kuluiai kakaian. ");
INSERT INTO ssg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","I ukek, “‘Imuh nga aliama haxoxo aliakei tehu nenein ti David. Laha aile halialuawen tuahe nga aile hasolia aliake. ");
INSERT INTO ssg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nga aile ukek ien lehe teka kumahe Ju tin laha sohot seilon tetak, teka pahalaha nga Haeu Masiwi ti laha, teteka nga kilamiwen tetak. ");
INSERT INTO ssg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nga Haeu, tel nga aile hatapo tesol waliko ien, nga kakaxi waliko ti teka seilon tioiwen lilian ti kuewen wanen.’” ");
INSERT INTO ssg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ape Jeims kak tatale ukek, “Aile ape nga namiloi ukek kako kum aile hahakawata teka kumahe Ju, teteka laha towiahu ti lialui woulaha ape usi Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tuahe kako tai non hani laha teik kakain ka laha kum aniani an tenen teka seilon ailewen pali hani teka haeu kumahe salan. Laha kum ailele saun lialun ti wawan hehin, laha kum ununumi kaka ape laha kum aniani xixioi manihuh tenen hina kaka leilon. ");
INSERT INTO ssg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Laha aile usiwa tesol waliko ien nake lawe Sabat leili synagog ti lawe taon laha to kakaxi nauna ti Moses lilian ti kuewen. Ape na laha kum usi, laha aile halialu namili teka Ju kahikahi Jises.” ");
INSERT INTO ssg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tesol aposel, teka masiwi ti kahikahi Jises ti Jerusalem hetekie teka kahikahi Jises liai lato namiloi na hakau hina seilon hani Antiok akati Pol ma Banabas. Lato kilami Judas Basabas ma Sailas, huhua seilon ti teka kahikahi Jises sasameni. ");
INSERT INTO ssg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Lato hakau tuaiwa lalu teik kakain i ukek, “Amuam ti amite tesol aposel ma teka masiwi ti teka kahikahi Jises ti Jerusalem, tesol akikimuto ahuma ti Jises haniwa amuto teka kumahe Ju leili Antiok, Siria ma Sailisia. ");
INSERT INTO ssg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Amite hongoen ka hina seilon ti leilomite lua haniwen kapimuto ape laha aile hahataxina ma hanamiloa hakila amuto. Tesol seilon ien kumahe amite taloa. ");
INSERT INTO ssg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Aile ape amite hatesol kilami hina seilon lehe amite hakau hani kapimuto akatiwa Banabas ma Pol, huhua lohumite. ");
INSERT INTO ssg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Lalu hani hahatapo lalu ti ailei puase Jises kalak na hina kawatan ma matemate. ");
INSERT INTO ssg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Amite hakaua Judas ma Sailas lehe tin lalu kaxi hani amuto waliko ti leili teteik kakain. ");
INSERT INTO ssg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Holi Spirit hanamiloa amite ka amite kum axi papalahi kawatan hani amuto tuahe amuto aile usiwa tesol kakain ie. ");
INSERT INTO ssg_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Amuto kum aniani an tenen teka seilon ailewen pali hani teka haeu kumahe salan. Kum ailele saun lialun ti wawan hehin. Kum ununumi kaka ma kum aniani xixioi manihuh tenen hina kaka leilon. Pamu ewian na amuto kum aile tesol waliko ien. Amuam ti amite haniwa amuto.” ");
INSERT INTO ssg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ape lato lua hani Antiok. Lato apuhini teka kahikahi Jises ape hani laha teik kakain ien. ");
INSERT INTO ssg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ti laha hongoa, laha amuam hawane nake i hakui xoxoi namilolaha ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ma Sailas, huhua ti kaxi ahutiai meng solian ti Jises, tin lalu kak hakui xoxoi namilolaha ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tesol seilon lato luama Jerusalem lato to teik kokol ien ape teka kahikahi Jises ti Antiok talo aliake lato hani Jerusalem. Lato ukek, “Amuam ti Haeu kapimuto.” ");
INSERT INTO ssg_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Tuahe Sailas nanamiloi na i tilimuen. ");
INSERT INTO ssg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol ma Banabas tin lalu hamalum Antiok ape hetekie teka kahikahi Jises liai lato hanau kakai Haeu ma kaxi ahuti meng solian ti Jises hani teka seilon. ");
INSERT INTO ssg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Hina ngain tamusua ape Pol hone Banabas, “Kalu alia hani kapi teka kahikahi Jises ti lawe taon ti kalu kakaxi meng solian tetan lehe kalu paxai na namilolaha ti Jises xoxoan tutuen.” ");
INSERT INTO ssg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas pahan i waxi Jon Mak kahitialalu. ");
INSERT INTO ssg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Tuahe Pol namiloi ukek ka kumahe pate ewi nake Jon Mak ox salili lalu ti lato Pampilia ape i tai puas akati lalu ti hatapoi puasalato. ");
INSERT INTO ssg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pol ma Banabas lalu kak hapatapat ape lalu selaia. Banabas waxi Jon Mak ape lalu lang hani Saiprus. ");
INSERT INTO ssg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol kilami kahitian Sailas. Imat ti lalu lua salili Antiok, teka kahikahi Jises kamei Haeu ti ngahatialalu. ");
INSERT INTO ssg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ti lalu lua hahaniwa Siria ma Sailisia, lalu kak hahakui xoxoi namili teka kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol ma Sailas lua hani tehu taon Derbe ape imuh hani tehu taon Listra. Ti ien tel kahikahi Jises axan Timoti. Tel tinan i tin tel kahikahi Jises, i akiki teka Ju. Tuahe tel taman i akiki teka Grik. ");
INSERT INTO ssg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Teka kahikahi Jises ti Listra ma Ikonium kak sasameni Timoti. ");
INSERT INTO ssg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol pahan i waxi Timoti kahitialalu. Aile ape Pol aile hani i kikilam ti teka Ju ti kolakol ka i tel seilon ti Haeu. I aile ukek ien nake teka Ju laha toto ien laha tioi ka tel tame Timoti i akiki Grik. Na i kum aile ukek ien, teka Ju kum hong lato. ");
INSERT INTO ssg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ti Pol, Sailas ma Timoti luluawa leili taon tehu tehu, lato kaxi hani teka kahikahi Jises laha kumahe Ju waliko ti tesol aposel ma teka masiwi ti kahikahi Jises ti Jerusalem hohone laha puas usian. ");
INSERT INTO ssg_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Aile ape teka kahikahi Jises namilolato i xox ahe tetan ape lawe ngain kilan seilon laha soh papalahiwa teka kahikahin. ");
INSERT INTO ssg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol, Sailas ma Timoti lato lua non wasole Prigia ma Galasia nake Holi Spirit lon kum al lato kaxi kakai Haeu hani teka seilon ti Asia. ");
INSERT INTO ssg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ti lato meiwa texux xux Misia, lato tohongi lali na lato lua hani texux xux Bitinia tuahe Holi Spirit ti Jises kum sowini hani lato. ");
INSERT INTO ssg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ape lato lua sahiwa texux xux Misia tamus hani tehu taon Troas. ");
INSERT INTO ssg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ti ipong, Haeu hanamiloa Pol ningahi tel seilon ti Masedonia tutu. I kamei eliliel Pol ukek, “Lua hanima Masedonia! Hualima amite!” ");
INSERT INTO ssg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Muhin ien Pol, Sailas, Timoti ma nga Luk, tel nga tai tenen meng ie, amite apeas talowi ti kane Masedonia nake amite namiloi tioi ka Haeu pahan amite kaxiwa meng solian ti Jises hani teka seilon ien. ");
INSERT INTO ssg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Amite lang salili Troas sawi hani texux xux kokol axan Samotres. Ape ngain liai tehu amite lang hani tehu taon Neapolis. ");
INSERT INTO ssg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ti ien amite non aweisal hani Pilipai, tehu taon lalap tuah ti Masedonia. Tehu taon ien hahitake teka masiwi ti Rom. Amite to hina ngain ien. ");
INSERT INTO ssg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Telao Sabat, amite nahih ahuta ti taon hetekie teka Ju hani tesol lawe laha lolotu pape tehu kan. Ti amite tunahiwa tesol ti na amite to, amite kakak kapi tesol hehin lato apupuha ien. ");
INSERT INTO ssg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tel ti tesol lato hongohong amite axan Lidia. I ti tehu taon Tiatira. I tel ti hangainiai maia tenen kakai ati polun kahun pate lalap. Lidia tel ti i lolotui Haeu ape Haeu haxewa namilon lehe i hong tioi ma soh meng solian ti Jises Pol kakaxi. ");
INSERT INTO ssg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Muhin ti amite baptaisiwa i ma hatesol seilon leili ingan, i ilowi amite i ukek, “Na amuto ukek nga tel kahikahi Jises, amuto nahih to hanima leili ingak.” Ape salan amite to kapin. ");
INSERT INTO ssg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ngain tehu ti amite nahih hahaniwa tesol ti tone lotu, tel hehin uluha unaui teka seilon apatuini amite he aweisal. Spirit lialun kakapiti i ape i pon kaxiai waliko ti na i sohot imuh. I hasohotu kilan moni hani teka masiwi tetan ti kaxi haniai teka seilon liai waliko ti i sohot hani laha imuh. ");
INSERT INTO ssg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tel hehin kakahiti amite Pol to titilol, “Tesol seilon ie lato unaui Haeu tel Masiwi tapein. Lato kakaxi sale awaiai seilon ti kawatan ti saun lialun ti laha.” ");
INSERT INTO ssg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kilan ngain i aile saun tin tetenen ape Pol lon manomano. I tohea paxai tel hehin ape i kakane tel spirit lialun leilon i ukek, “Ti poh Jises haniwen nga, nga hone o ahutawa ti tel hehin ie.” Tataen ien wanen tel spirit lialun ahuta salili i. ");
INSERT INTO ssg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ti tesol masiwi tetan tioiwa ka aweisal ti hatanoi moniulato keitawen, lato pohi Pol ma Sailas ape lato itini lalu hani teka masiwi ti Rom ti tehu taon ien, tetesol tone apuhai seilon. ");
INSERT INTO ssg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ape lato hone teka masiwi ukek, “Huhua seilon ie lalu Ju. Lalu aile hahataxina teka seilon ti taon ti kako. ");
INSERT INTO ssg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Lalu hahanau teka seilon saun tenen pate i hilei saun ti kako. A amite teka Rom, lialun na amite puas usi tenen saun ien.” ");
INSERT INTO ssg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Teka kilai seilon laha apupuha ien laha huali teka sulualalu. Aile ape teka masiwi ien hone teka unaualato lexi xaxaweniai puxui Pol ma Sailas ma hetialalu. ");
INSERT INTO ssg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Laha heti halialu kewa lalu, laha towi lalu hani leili ingi kalabus. Ape laha hone tel peteniai kalabus peteni aluinialalu. ");
INSERT INTO ssg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tel peteniai kalabus towi lohi lalu hani tesol tone kalabus patalal wanen ape i xioti kongini aelalu wasole pata tenen kawatan. ");
INSERT INTO ssg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Sai luhui ipong, Pol ma Sailas lotu ma pak hahani Haeu. Teka kalabus liai hongohong lalu. ");
INSERT INTO ssg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Xux i nuea hahutuia ape i nuei tehu ingi kalabus. Ti lokon ien wanen hatesol kahip tua hea ape sen tua oxoxa ti teka kalabus. ");
INSERT INTO ssg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ti tel peteniai kalabus haiwa i ningahi hatesol kahip hean ape i sokok hatesol seilon ti kalabus kiliwau ahutawen. Kakanua i ahuti tea ngolun ti hile ape lehe i tapuhi aliake i. ");
INSERT INTO ssg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Tuahe Pol tilol eliel ukek, “Kum tetelei o! Amite hatesol tutuen ie!” ");
INSERT INTO ssg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tel peteniai kalabus tilol hone tel liai ukek, “Kauma lul.” Ape i kiliwau soh hani leili kalabus. I mamata xexex ape i lokuha mate Pol ma Sailas. ");
INSERT INTO ssg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","I hakahita ahuti lalu ape i kamea, “Nga aile la lehe i pon awaiak ti kawatan ti saun lialun tetak?” ");
INSERT INTO ssg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Lalu pahoi i ukek, “Namilom kewa xoxoan ti tel Masiwi Jises ape i awai o ti kawatan ti saun lialun. Tin masin hatesol seilon leili ingam, aweisal tenenawe.” ");
INSERT INTO ssg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ape lalu kaxi meng solian ti Jises hani i ma hatesol seilon ti leili ingan. ");
INSERT INTO ssg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kalak ape ipong kuewen, tel peteniai kalabus nuhi mange tinulalu ape lalu baptaisi i ma hatesol seilon ti leili ingan. ");
INSERT INTO ssg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Muhin ien i ilowi Pol ma Sailas hani leili ingan ape i axi analalu. I ma hatesol seilon leili ingan lato amuam hawane nake aope namilolato xoxoan ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Letu ti ngain liai telao teka masiwi ti tehu taon ien lato talo tesol masiwi hahitakalato hetekie teik kakain i ukek, “Oxoxiwa lalu.” ");
INSERT INTO ssg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tel peteniai kalabus hone Pol, “Teka masiwi hakauma kakain ti oxoxiamulu ti kalabus. Ape ewi na amulu nahih. Nahih hawanenewa!” ");
INSERT INTO ssg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Tuahe Pol pahoi tesol unaui teka masiwi ukek, “Laha tai hatuhi amili ti sulusulu kalak amili seilon ti hahitake ngahat ti Rom. Laha kum tunahi tenen na waliko lialun amili ailewen. Laha heti amili he puli lawe seilon ape towi lohi amili hani leili kalabus. Aope pahalaha oxoxi muneni amili. Kumahe masin ien! Puki laha nahih oxoxima amili ape hakahita ahutiwa.” ");
INSERT INTO ssg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Muhin tesol seilon ien kaxi hani teka masiwi ti tehu taon ien kakai Pol. Ti lato hongoa ka Pol ma Sailas seilon ti hahitake ngahat ti Rom, lato mamata. ");
INSERT INTO ssg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ape lato nahih hani kapi Pol ma Sailas lato ukek, “Amite tahane hawane ti amite aile saun tenen lialun hani amulu.” Muhin lato ati ahuti lalu ti kalabus ape lato kamei lalu na lalu nahih salili tehu taon. ");
INSERT INTO ssg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tuahe Pol ma Sailas nahih hanimu ingi Lidia. Ti ien lalu kak hakui teka kahikahi Jises lehe namilolato xox tatale ti usian. Ape lalu salili tehu taon Pilipai. ");
INSERT INTO ssg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol ma Sailas lua akilaua huohu taon Ampipolis ma Apolonia ape tahia hani tehu taon Tesalonika. Tehu synagog ti teka Ju ien. ");
INSERT INTO ssg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol nahih hani tehu synagog hanowi ti lawe i to ailele. Sabat toluhu i to kakak kapi teka Ju kakain ti he pepai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","I kaxi haxewa kakai Haeu ape i nexi hani lato ka hoi liai ti kuewen Haeu namiloiwen ka Krais kau kawatan ma moloan ma i xahat alia ti matean. Pol ukek, “Jises, tetel nga kaakane amuto, i se Krais, Haeu taloma ti awaiakako ti kawatan ti saun lialun ti kako.” ");
INSERT INTO ssg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Teka ti tesol Ju lato soh kakai Pol ape lato sohot kahikahi Jises. Ape kilan teka Grik laha lolotui Haeu ma teka hehin axalaha lalap tin laha sohot kahikahi Jises. ");
INSERT INTO ssg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tuahe kilan teka Ju laha hin namil lialun nake kilan seilon laha sohot kahikahi Jises. Laha apuhini teka seilon lialun ape hahika kilan seilon ti leili taon. Laha hamanana tewau kahip ti tehu ingi tel seilon axan Jason ape laha soh upia Pol ma Sailas lehe laha ati lalu hani kapi teka kilai seilon. ");
INSERT INTO ssg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Tuahe ti laha tai tunahi lalu, laha itini Jason ma teka kahikahi Jises liai hani kapi teka masiwi ti tehu taon ien. Laha tilol ukek, “Huhua seilon Pol ma Sailas aile saun tenen hahataxina seilon ti tesol tesol. Lalu ape ie ailele saun tin tetenen! ");
INSERT INTO ssg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","A Jason waxi auni lalu hani leili ingan. Lato hatesol seilon ti xaputiai kakai Sisa tel masiwi tapein ti Rom. Tin lato ukek ka tel seilon axan Jises i masiwi tapein ti kako.” ");
INSERT INTO ssg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ti teka masiwi ma teka kilai seilon hongoa, laha leng lialu hawane. ");
INSERT INTO ssg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Teka masiwi akeni kongini moni lalap ti Jason ma tesol liai lehe lato kum aile ulei saun tenen i hahataxina teka seilon. Ape teka masiwi hanahi lioi lato. ");
INSERT INTO ssg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ipong tehu ien, teka kahikahi Jises talo Pol ma Sailas hani tehu taon Berea. Timoti tin i lua hani ien tuahe imuh. Ti lalu tahiawa, lalu nahih hani tehu synagog ti teka Ju. ");
INSERT INTO ssg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Teka seilon ti Berea lawe laha hong mataini kakai seilon, laha xoini teka ti Tesalonika. Laha hong amuke hawane meng solian ti Jises tuahe lawe ngain laha nihehi paxai pepai Haeu ti paxaiai waliko ti Pol kakak na masin salan. ");
INSERT INTO ssg_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Aile ape kilan teka Ju, teka hehin Grik axalaha lalap ma teka Grik wawan, laha soh ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ti teka Ju ti Tesalonika hongoa ka Pol kakaxi kakai Haeu hani teka Berea, teka ti lato lua haniwa Berea ape hahika kilan seilon aile halialui Pol. ");
INSERT INTO ssg_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Aile ape teka kahikahi Jises talo Pol ma teka liai laha lua akakati i hani Aten tehu taon leili texux xux Akaia. A Sailas ma Timoti hamalum Berea. ");
INSERT INTO ssg_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ti lato tahiawa Aten, tesol akatiai Pol alia hani Berea hetekie kakaian. Pahan Sailas ma Timoti kosea haniwa kapin. ");
INSERT INTO ssg_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Lokon ti Pol to atetengi Sailas ma Timoti Aten, tian kawat hawane ti i ningahiwa kilan haeu tenen kumahe salan laha tanomi ape lotui. ");
INSERT INTO ssg_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Aile ape leili synagog i to kakaxi meng solian ti Jises hani teka Ju ma teka Grik laha lolotui Haeu. Lawe ngain i nahih hani tesol tone apuhai teka seilon ape tin i kaxi meng solian ti Jises hani teka na laha ien. ");
INSERT INTO ssg_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tesol seilon Epikurian ma Stoik laha teteka hanaui sale totone seilon, tin laha kak hapatapat kapi Pol. Teka ti laha ukek, “Tel seilon ie tua kak lalolal.” Teka liai ukek, “Tanoman i kakak haeu tenen kako kum tioi.” Laha kak ukek ien nake Pol kakaxi sale puase Jises ma xahataian ti matean. ");
INSERT INTO ssg_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Laha ilowi Pol hani kapi teka masiwi ti nahikei Aten ape teka masiwi ukek, “Pahamite amite tioi waliko haun ti o hahanau teka seilon. ");
INSERT INTO ssg_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Hatesol waliko ti o kakak amite tai hongohong. Pahamite tioiai salangawan.” ");
INSERT INTO ssg_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Pahalato lato tioi nake hatesol seilon ti Aten ma teka seilon ti xux liai laha toto ien, lawe pahalaha tua to kakak ma hongohong waliko haun teka seilon kakaxi. ");
INSERT INTO ssg_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pol tule ape i ukek, “Amuto teka seilon ti Aten, nga tioi hawane amuto seilon ti lotu. ");
INSERT INTO ssg_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ti nga tau nanahih leili taon ti amuto, nga ningahi kilan wanen waliko ti amuto lolotui. Tin nga tunahi tesol tone hanai pali hina kakain taian ien i ukek, ‘Hani haeu tetenen ti kaha kum tioi.’ Aope nga kaxi hani amuto tel Haeu amuto tua lolotui tuahe amuto kum tioi i. ");
INSERT INTO ssg_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Haeu tetel i tanomi hatehu pon itan ie ma hatesol waliko ti heihon. I tel Masiwi ti hatesol waliko ti patul ma itan ie. Kumahe totonan leili ing ti seilon atai lotuian. ");
INSERT INTO ssg_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ape teka seilon kumahe laha puas tetan nake i pahan huhual. I tetel i hani seilon hanawain ma lawe waliko liai. ");
INSERT INTO ssg_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Imat Haeu tanomi seilon tel ape tel ien i hanatua seilon tenen tenen ti hatehu pon itan ie. Puki Haeu namiloiwen tetesol ti na laha to ma lokon ti laha takah ma mat. ");
INSERT INTO ssg_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“Haeu tanomi seilon lehe laha haeliel hawane ti tioi aluinian. A Haeu kumahe xauxaun kapi kaha tel tel. ");
INSERT INTO ssg_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ti pohe Haeu kaha puki masin ti i namiloiwen. I axi hanawaiakaha ma hakui kaha ailei puasain. Tel ti amuto teka taiai kakain i kakak sale tesol waliko ien. I ukek, ‘Kako hatesol nonoma ti Haeu.’ ");
INSERT INTO ssg_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Na masin ien, kaha kum namiloi ukekek ka Haeu masin waliko ti tel seilon tanomi ani pata ma na pot. ");
INSERT INTO ssg_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","“Ti imat Haeu kum axi kawatan hani teka seilon ti lialui woulaha nake laha kum tioi Haeu. Tuahe aope ie, i hone eliel hatesol seilon ka kaha towiahua ti lialui woukaha ape hong usiwa kakaian. ");
INSERT INTO ssg_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Haeu kilamiwen ngain telao ti tel Natun hiniti hatesol seilon ape hinitian tetan sawisawin. Haeu kola ka tesol waliko ien salan ti i xahateni aliake tel Natun ti matean.” ");
INSERT INTO ssg_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ti laha hongoa ka Pol kakaxi sale xahateniai seilon maten, teka ti laha soxeni i tuahe teka liai lato ukek, “Pahamite amite hong ulea tenen meng o kakaxi.” ");
INSERT INTO ssg_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ape Pol nahih salili tehu apuhain ien. ");
INSERT INTO ssg_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Teka ti laha hong soh kakai Pol ape i hanau aheke lato. Leilolato Daionisius tel ti teka masiwi ti Aten, tel hehin axan Damaris ma hina seilon liai. ");
INSERT INTO ssg_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Muhin ien Pol salili Aten ape i lua hani tehu taon Korin, i tin leili texux xux Akaia. ");
INSERT INTO ssg_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ti ien i apatuini tel Ju axan Akila i takah texux xux Pontus. Pala aope i luama ti texux xux Itali hetekie tel axoan Prisila nake Klodius, tel masiwi tapein ti Rom, i talo xaxaweni teka Ju ti Rom. ");
INSERT INTO ssg_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ape Pol heuta ma puas kapi lalu. Lato hatolu hapuasa uli manihuh tanomiai houha ape lato hangaini ti waxenialato. ");
INSERT INTO ssg_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Lawe Sabat Pol nahih hani leili synagog. I tohongi itiniai namili teka Ju ma teka Grik lehe laha soh ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ti Sailas ma Timoti tahiama ti Masedonia, Pol pupuasan ape mewenae kaxi ahutiai meng solian ti Jises. I kaxi haxewa hani teka Ju ka Jises se Krais tel Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ti lato kak pahoi ma kak halialua i, Pol tapahi xaxaweni hepekeun ti tehu puxuaun. Ien i kola ka Haeu kum amuke lato. I ukek, “Kumahe nakek na Haeu axi amuto kawatan ti amuto kum hong soh kakaiak. Tataen ti aope ie nga nahih hani kapi teka seilon kumahe Ju ti kaxi ahutiai meng solian ti Jises hani laha.” ");
INSERT INTO ssg_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ape i sos hani tehu ingi tel seilon axan Titius Justus. I kumahe Ju tuahe i lolotui Haeu kapi teka Ju. Ingan kapi tehu synagog. ");
INSERT INTO ssg_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, tel ti teka masiwi ti tehu synagog, i sohot kahikahi Jises hetekie hatesol seilon ti lohe ingan. Kilan seilon ti Korin tin laha hong soh meng solian ti Jises ape laha uke baptais. ");
INSERT INTO ssg_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ipong tehu Haeu kakane Pol ukek, “Kum maamata! Kaxi tatalewa kakaiak ma kum aile lilioi. ");
INSERT INTO ssg_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nga lawe kapim, tap tel pon aile halialuam nake ti leili tehu taon ie kilan seilon tetak.” ");
INSERT INTO ssg_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Aile ape Pol to ien ahang tehu tewaok. I hahanau teka seilon kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lokon ti Galio tel neiniai texux xux Akaia, teka Ju aile namil teikawe ape lato akeni kongini Pol. Lato ati i hani Galio lehe i tu ti sulusulu. ");
INSERT INTO ssg_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Lato ukek, “Tel seilon ie i lungei teka seilon ti lotuiai Haeu ti aweisal tenen i xaputi nauna ti teka masiwi ti Rom.” ");
INSERT INTO ssg_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol lehe i kak tuahe Galio tua kakanewa teka Ju i ukek, “Na hina waliko pate lialun i ailewen, se liai pupuasak ti hongoamuto teka Ju. ");
INSERT INTO ssg_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Tuahe ie se kakain ti he wawatak, kakain ti ax tenen tenen ma nauna ti amuto teka Ju. Puki alia amuto kak hasawiwa. Nga kumahe hongoi meng ti waliko tenen ien.” ");
INSERT INTO ssg_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ape i talo xaxaweni lato hatesol ti tone hongoi meng. ");
INSERT INTO ssg_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ti lialui lolato kakanua lato akeni pohi Sostenes tel masiwi ti synagog ape xai i mate Galio tuahe Galio kum nam waxi. ");
INSERT INTO ssg_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol to kapi teka kahikahi Jises ti Korin ape imuh i hetekie Akila ma Prisila lang salili laha hani texux xux Siria. Imat ti lato lang salili tehu taon Kenkeria, Pol uluhi ukun i kola ka i hatapoen puasain leili Korin ti i tuoha hahani Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ti lato hasungawa Epesus, Pol nahih salili Prisila ma Akila. I nahih hani tehu synagog ape i kakak kapi teka Ju sale puase Jises. ");
INSERT INTO ssg_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Teka seilon kamei i na i to ahemu kapi lato tuahe i ukek kumahe. ");
INSERT INTO ssg_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Tuahe i hone lato, “Na Haeu pahan, nga alia hanima kapimuto imuh.” Ape i lang salili Epesus. ");
INSERT INTO ssg_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","I hasunga hani tehu taon Sisaria. Ti ien i lua hani Jerusalem paxaiai teka kahikahi Jises. Ape imuh i lua hani tehu taon Antiok. ");
INSERT INTO ssg_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","I to teik kukunun ien ape i lua hani huoxux xux Galasia ma Prigia. I kak hakui teka kahikahi Jises lehe laha puas usi tatale kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Lokon ien, tel Ju axan Apolos i luama tehu taon Aleksandria leili Igip hani tehu taon Epesus. I seilon tenen solian ti kakain ma pate i tioi kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Laha hanauen i sale aweisal ti Jises. I amuam hawane ti kaxiai sale puase Jises ma kakaian pate salan. Tuahe i tioi mewenae baptais ti Jon ailele. ");
INSERT INTO ssg_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Lawe i kaxi matuke leili synagog. Ti Prisila ma Akila hongoa kakaian, lalu waxi i hani tonalalu ape hanau aheke i sale aweisali Jises. ");
INSERT INTO ssg_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Imuh Apolos namiloi na i lua hani texux xux Akaia. Teka kahikahi Jises ti Epesus lato kak haxoxo i ape lato tai teik kakain hani teka kahikahi Jises ti Akaia kameialato ti waxi aunian. Ti Apolos tahia haniwa Akaia, huhual lalap i hani teka seilon laha soh ti Jises nake ti lalape soliai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ti i kak he hapatapat kapi teka Ju, kakaian xoini kakaialaha. I uke kakain ti he pepai Haeu ti nexi hanialaha ka Jises se tel Krais Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ti Apolos leili tehu taon Korin, Pol lua nonoa Galasia ma Prigia ape i tahia hani tehu taon Epesus. Ti ien i tunahi teka seilon laha soh ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ape i kamei laha, “Ti amuto sohoa ti Jises, nakon amuto ukewen Holi Spirit ti kapitiamuto?” Laha pahoi ukek, “Tin liai amite tai hong na hina Holi Spirit.” ");
INSERT INTO ssg_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pol kamei laha, “Lehe baptais tenen lahan amuto ukeke?” Laha pahoi ukek, “Baptais ti Jon.” ");
INSERT INTO ssg_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol ukek, “Jon baptaisi teka laha towiahu ti saun lialun ape laha usi Haeu. I hone teka seilon ti Israel ka laha sohoa ti Jises, tetel i tahiama muhin.” ");
INSERT INTO ssg_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ti laha hongoa ien, laha uke baptais ti hahitake axe Jises Krais. ");
INSERT INTO ssg_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pol hana minan patul ti laha ti lotu hualialaha ape Haeu hani laha Holi Spirit. Tataen ien laha lotui Haeu ti kakain ti laha tai hanau ma tin laha kului kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mongohualaha sai huopanim hua. ");
INSERT INTO ssg_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ti leili pangapang toluhu, Pol lawe i nahih hani synagog. I kak matuke ahutiai meng solian ti Jises ape i tohongi itiniai namili teka Ju ti sale nenein ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Tuahe teka ti lato hong watakai hetekie namil ti kakapax. Ape lato kak halialu sale aweisali Krais. Aile ape Pol nahih salili lato. I hakahita teka kahikahi Jises hani tehu ingi Tiranus, ing ti hanaui teka seilon. Ti ien, lawe ngain i kakak kapi teka kahikahi Jises ti sale nenein ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ti leili ahang huohu i kaxi ahuti meng solian ti Jises hani teka Ju ma teka kumahe Ju laha toto leili texux xux Asia. Ape kilan ti laha hong soh kakaian. ");
INSERT INTO ssg_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Haeu hani Pol poh ti ailei waliko tenen lalap wanen. ");
INSERT INTO ssg_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Aile ape kalak maia ti Pol hapuasawen laha waxi ape hani teka tinun ma teka ti spirit lialun kapiti hahalialu. Ape teka tinun laha ewi ma spirit lialun ox salili teka seilon lato kapiti hahalialu. ");
INSERT INTO ssg_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Tesol ti teka Ju, ti lato lua hani tesol tesol, lato hapuasa axe Jises tel Masiwi ti xaxaweniai spirit lialun ti seilon. Lato hone teka spirit lialun ukek, “Ti pohe Jises, tetel Pol kakaxi, amuto ahutawa!” ");
INSERT INTO ssg_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Tepanim hua hatotalin, nati Skeva tel masiwi tuah ti hukuminiai Haeu ma seilon, lato ailele tenen saun ien. ");
INSERT INTO ssg_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Telao tel spirit lialun kak pahoi lato ukek, “Nga tioi Jises ma Pol, a amuto aita?” ");
INSERT INTO ssg_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tel seilon spirit lialun kapiti hahalialu, i leng hilei hatotalin ape itini lexi puxuaulato. Lato kiliwau salili i, tinulato mangein. ");
INSERT INTO ssg_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Hatesol teka Ju ma teka kumahe Ju laha toto Epesus, laha mamata hawane ti laha hongoa waliko ti i sosohot ape laha sameni hawane axe Jises tel Masiwi. ");
INSERT INTO ssg_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Kilan ti teka laha soh ti Jises, lato kaxi ahuti saun lialun ti lato ti taxingi seilon. ");
INSERT INTO ssg_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Teka lato hapuasa pohe Satan ti ailei waliko tenen lalap, lato kau apuhini pepa ti hanaualato ailei tesol waliko ien. Kalak kahi tesol pepa ien pate lalap, lato lui ti puli lawe seilon nake ape lato soh ti Jises. ");
INSERT INTO ssg_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Aile ape ti kui pohe Haeu, meng solian ti Jises sawat hani kilan seilon. ");
INSERT INTO ssg_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Muhin ien Holi Spirit hanamiloa Pol alia hani Jerusalem nonoa xux ti Masedonia ma Akaia. Pol hone teka kahikahi Jises ukek, “Muhin ti na nga heisawa Jerusalem, nga kane Rom.” ");
INSERT INTO ssg_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ape i talo hua hualian Timoti ma Erastus hani Masedonia nake i to ahemu teik leili texux xux Asia. ");
INSERT INTO ssg_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ti lokon ien hina kawatan lalap sosohot leili Epesus nake hina seilon laha kak halialu aweisali Krais. ");
INSERT INTO ssg_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tenen kawatan ien Demetrius hutui. I tel seilon ti tanomi ukenei teka ing nameniai tel haeu hehin axan Artemis teka Grik lolotui. I ma tesol puase kapin lato uke silva ti tanomi ukenei tetesol ing ape lato hasohotu hakila moni ti lato hangaini. ");
INSERT INTO ssg_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","I tiloi teka puas akatan ma teka laha ailele puasain hanowi ti lato ape i ukek, “Amuto tioi ka moniukako tenen puasain ie hasohotu. ");
INSERT INTO ssg_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ape puki amuto papaxai ma hongohong waliko ti Pol ailele leili Epesus ma tin leili lawe toan ti Asia. I kak hahataxina kilan seilon ka waliko ti kako tanomi ani min kumahe haeu tenen salan. ");
INSERT INTO ssg_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Na Pol aile tatale tenen puasain ien, teka seilon kak halialu tenen puasakako ape laha ukek ka Artemis ma tehu ing ti lotuian ape kumahe tuah. Ape Artemis, tetel ti kilan seilon ti Asia ma tehu pon itan ie to lolotui, axan i taxix.” ");
INSERT INTO ssg_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ti teka seilon hongoa teik kakain ien, laha leng hawane ape tilol ausisini, “Kumahe! Artemis tel ti kako Epesus lolotui, axan lalap wanen!” ");
INSERT INTO ssg_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Laha hahika teka seilon liai. Ape kilan seilon laha kiliwau itini lungei Gaius ma Aristakus, huhua lua akatiai Pol, hani tesol tone apuhain. ");
INSERT INTO ssg_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol pate pahan i kakane teka seilon tuahe teka kahikahi Jises kongini, uke laha aile halialu i. ");
INSERT INTO ssg_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Teka masiwi lawe Pol ti texux xux Asia, lato hakouta kakain kamei eliliel i ka i kum kokola kawan hani leili tesol tone apuhain. ");
INSERT INTO ssg_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lokon ien leili tesol tone apuhain, kilan seilon laha tataxini. Teka ausisini tenen, teka ausisini tenen nake kilan ti laha kum tioi salangawe apuhain. ");
INSERT INTO ssg_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ape teka Ju hone lungei Aleksanda i tel ti lato na i kakane laha ien. Aleksanda tulini minan lehe i kak haxewa hani teka seilon waliko ti i sosohot. ");
INSERT INTO ssg_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tuahe ti laha paxai tioiwa ka i tel Ju, laha hatesol ausisini ukek, “Artemis ti kako Epesus i pate tuah wanen!” Sai aua huohu laha tua to ausisini ukek ien. ");
INSERT INTO ssg_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Imuh tel ti teka masiwi ti Epesus hamonga laha, i ukek, “Teka akikik! Hatesol seilon tioi ka kako teka Epesus aunini tehu ing ti lotuiai Artemis ma tehu pot hina hosaun ti i putalih he maun. ");
INSERT INTO ssg_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hatesol seilon tioi ka waliko ie salan wanen. Aile ape amuto hamalumua ma kum aile saxohuxoh waliko. ");
INSERT INTO ssg_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Amuto hakahitama huhua seilon ie kalak lalu tai xuina waliko ti leili ing ti lotuiai Artemis ma tai kak halialu i. ");
INSERT INTO ssg_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Na Demetrius ma teka puas akatan hina kakain ti sulualalu, kaha hina teka masiwi ti xux ma teka hongoi meng. Lato haniwa lalu he mini teka masiwi ti hasawian. ");
INSERT INTO ssg_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Na hina kakain liai ti sulusulu, tin haniwa he mini teka masiwi ti hasawian. ");
INSERT INTO ssg_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nga namiloi ukek ka teka masiwi ti Rom sului kako ti saun tenen ti amuto ailele nake tap tutuhan.” ");
INSERT INTO ssg_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Muhin ien i hatapo tehu apuhain. ");
INSERT INTO ssg_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Hina ngain tamusua, Pol apuhini teka kahikahi Jises hani kapin. I kak haxoxo tapeini lato ape i lua hani texux xux Masedonia. ");
INSERT INTO ssg_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ti ien i kak hahaxoxo teka kahikahi Jises ti toan tewau tewau. Ape muhin i tahia hani Akaia. ");
INSERT INTO ssg_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ti ien i to pangapang toluhu. I apepeas na i lang hani texux xux Siria tuahe i upia tunahi ka teka Ju namiloi hahalialu i. Aile ape i noseni i non hani Masedonia tamus hani Siria. ");
INSERT INTO ssg_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Hina seilon kukuoxi Pol. Lato se Sopater nati Pirus ti Berea, Aristakus ma Sekundus ti Tesalonika, Gaius ti Derbe, Tikikus ma Tropimus ti texux xux Asia ma Timoti. ");
INSERT INTO ssg_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tesol seilon ien langawen imat hani Troas ape lato atetengi amite, nga Luk ma Pol mela. ");
INSERT INTO ssg_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Muhi tehu Pasova, amite lang salili Pilipai leili Masedonia. Ngain tepanim imuh amite takana hani Troas ape amite to puasain tehu ien. ");
INSERT INTO ssg_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Tehu ngain ti nameniai xahatai Jises, amite tesol kahikahin hukuma ti aniai bret. Muhin ien Pol kakak kapi teka seilon sale puase Jises atengi taen luhui ipong nake ngain liai telao pahan i salili lato. ");
INSERT INTO ssg_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kilan kamaiamite leili ing patul ti amite apupuha. ");
INSERT INTO ssg_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Leilon ti Pol kakak tutuen, tel seilon uluha axan Utikus i toto he pax ti palaen, pulan lihi eliel ti momoi kamaiamite. Ti i matih luhua i putalih patul ti tehu ing toluke hani itan. Ti laha lautiwa Utikus, i se maten. ");
INSERT INTO ssg_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Tuahe ti Pol mos haniwa itan, i tuole akeni aumi Utikus ape i ukek, “Kum tatahane, i moih aliawen!” ");
INSERT INTO ssg_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pol soh alia hani leili ing teke patul ape lato hatesol ang hukuma. I kak kue hawane kapi lato atengi ti ape i nitini. Muhin ien i nahih salili lato. ");
INSERT INTO ssg_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Teka ngahatiai Utikus lato hakahita i hani tonan. Pate lato amuam hawane nake i moih alia. ");
INSERT INTO ssg_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pol nahih non aweisal hani tehu taon Asos. A amite lang ani waian atengi i hani ien. ");
INSERT INTO ssg_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ti ape i tahia hanima kapimite, amite hatesol lang hani tehu taon Mitilini. ");
INSERT INTO ssg_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ti ngain liai telao amite lang sahi texux xux kokol axan Kios. Telao ngain imuh amite lang sahi texux xux kokol axan Samos ape ti ngain liai telao ulea amite takana hani tehu taon Miletus. ");
INSERT INTO ssg_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol namiloiwen ka amite kum takana Epesus lehe i kum hatalia amite nake i haxehax ti tahia hani Jerusalem ti telao ngain ti Pentekos. ");
INSERT INTO ssg_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Tuahe taen amite tahiama Miletus, Pol hakau kakain hani Epesus kameiai teka masiwi ti teka kahikahi Jises na i tengeni lato Miletus. ");
INSERT INTO ssg_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ti lato tahiawa, Pol hone lato, “Amuto tioi sale totonak ma wouk ti nga kapimuto, hutuima telao ngain nga tahiama texux xux Asia. ");
INSERT INTO ssg_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nga teheni nga ti ailei puase Haeu hetekie tatahan tetak hani seilon liai kalak teka masiwi ti teka Ju aile axi nga kawatan tenen tenen. ");
INSERT INTO ssg_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Amuto tioi nga tai puluhini teik na kakain tenen i pon hualiamuto. Nga hahanau amuto sale puase Jises leili kilan seilon ma ti ingi tel tel. ");
INSERT INTO ssg_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nga hahanau teka Ju ma teka kumahe Ju tenenawe ti nga kakane laha ka laha towiahua ti lialui woulaha ape usiwa Haeu ma sohoa ti Jises tel Masiwi. ");
INSERT INTO ssg_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ti aope ie, Holi Spirit hanamiloa eliel hawane nga kane Jerusalem. Nga kum tioi waliko tenen na i sohot hani nga ien. ");
INSERT INTO ssg_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Tuahe Holi Spirit hahongo nga leili lawe taon ti nga tahiawa ka kalabus ma kawatan tenen tenen atetengi nga. ");
INSERT INTO ssg_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nga soh ka totonak tuah mewenae na nga aile hatapo puasain tenen Jises haniwen nga. I pahan nga kaxi sawateniwa sale lalape soliaian ma wawahen ti Haeu ti i hani kaha Jises, tel awaiakaha ti kawatan ti lialui woukaha. ");
INSERT INTO ssg_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nga tioi ka tap tel ti amuto, teteka ti nga kaakane sale nenein ti Haeu, po ningahi ulea nga. ");
INSERT INTO ssg_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ti aope ie nga kakane hawane amuto, na tel seilon i uke kawatan ti Haeu nake ti lialui woun, kum titieni nga. ");
INSERT INTO ssg_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nga tai pupuluhini lawe waliko ti Haeu pahan amuto tioiwa ma ailewa. ");
INSERT INTO ssg_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Ngahati aliakewa amuto ma teka seilon Holi Spirit hanawen hahitake aunian ma nenein ti amuto. Lato sohot seilon ti Haeu nake tin Jises mat kahuiai lialui woulato. Ngahati hanowiwa ti tel seilon ngahati sipsip. ");
INSERT INTO ssg_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nga tioi hawane ka muhin ti na nga saliliwa amuto, teka woinakon hanaui kakai Haeu laha tahia hanima kapimuto masin sinen tenen tumun kalimen. Laha haeliel halialui teka seilon ti Haeu lehe lato kum usi kakain salan tetan. ");
INSERT INTO ssg_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Puki alia teka ti amuto laha hulo towiahu kakai Haeu itiniai teka seilon tetan usiai kakaialaha. ");
INSERT INTO ssg_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Aile ape lepeteniwa teka seilon ien. Nameniwa waliko ti lawe nga to hahanau amuto leili ahang toluhu ma telui lok ti amuto. ");
INSERT INTO ssg_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Aope nga hana amuto hahitake ngahat ma nenein ti Haeu. Nameniwa ka ti lalape soliai Haeu ma wawahen tetan, i hani kako meng solian ti Jises. Ape teka ti amuto laha hani hatapo tupualaha ailei puase Haeu, kakaian i pon hakuialaha ape kahulaha solian i hani laha ti leili tonan. ");
INSERT INTO ssg_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“Tiliai kakaiak, nga liai kumahe pahak moni ma na maia ti amuto. ");
INSERT INTO ssg_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Amuto tioi ka nga hatano moni ti puki minak ma tin nga huhuali teka seilon kapik. ");
INSERT INTO ssg_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ti lawe waliko nga aile, nga kola hani amuto ka mewenae na kaha puas eliel kaha pon hualiai teka tap kuilaha. Nameniwa kakai Jises ti i ukek, ‘Pamu amuam lalap na amuto hani, i xoini ti na amuto uke.’” ");
INSERT INTO ssg_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ti i kak hatapoa, i lokuha ape i lotu kapi lato. ");
INSERT INTO ssg_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Lato akeni aumi Pol ape lato hatesol tang nake ape i salili lato. ");
INSERT INTO ssg_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pate lato tahane nake i ukek ka lato kum ningahi ulea i. Ape lato nahih tapeini amite hani he tea waian. ");
INSERT INTO ssg_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ti amite lang saliliwa lato hani texux xux Kos, lomite i tel. Ti ngain liai telao amite tahia haniwa texux xux kokol axan Rodes ape lang ulea hani tehu taon Patara. ");
INSERT INTO ssg_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ti ien amite ku soha he tea waian liai kane texux xux Penisia leili Siria. ");
INSERT INTO ssg_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ti amite langalang amite ningahi texux xux Saiprus ape amite lang non sai haiup hani tehu taon Taia ti Siria. Amite takana ien nake laha tiheli hina angah. ");
INSERT INTO ssg_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ti ien amite paxai ngah teka kahikahi Jises ape amite to kapi lato puasain tehu. Holi Spirit kak hatakei hani lato waliko ti na i sohot hani Pol ape lato hahongo i ka i kum lua hahani Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Tapeini ngain ti puasain tehu ien, amite nahih alia hani he tea waian. Hatesol kahikahi Jises hetekie tesol axoalato hehin ma natulato nahih tapeini amite. Ti ien, amite hatesol lokuha ape amite lotu. ");
INSERT INTO ssg_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Lotu kewa amite kak tapeini lato ape amite nahih ku hani heiwai tea waian. Ape lato nahih alia hani tonalato. ");
INSERT INTO ssg_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Amite lang tatale hani tehu taon Petolemais. Ti amite hasungawa, tin hina teka kahikahi Jises ien ape amite to lawai lato ti ngain tehu. ");
INSERT INTO ssg_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ngain liai telao amite ku salili lato ape amite takana hani tehu taon Sisaria. Ti ien amite to kapi Pilip, tel ti ahutiai meng solian ti Jises. I tin tel ti tepanim huhua seilon ti ailei puasain ti seiai waliko ti huhual, ti laha kilami leili Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Natun hehin hinalo lato tai sal, lato teka ti kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Muhi hina ngain ti amite toto ien, tel seilon axan Agabus i tahiama ti Judia. I tin tel kuluiai kakai Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ti i nahima paxai amite, i waxi teik tahe Pol ape i xinoti aliake puki minan ma aen ape i ukek, “Holi Spirit i ukek, ‘Tin masin tel seilon tahan teteik tah, teka masiwi ti teka Ju ti Jerusalem xinoti ape laha hangaini hani teka seilon ti Rom.’” ");
INSERT INTO ssg_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ti amite hongoa, amite ma teka kahikahi Jises ti tesol ien, amite hatesol kamei eliel Pol ka i kum lua hahani Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Tuahe Pol ukek, “Kalahai amuto tangixi nga ma tohongi sohiai namilok? Nga hean wanen kumahe mewenae na nga kalabus leili Jerusalem tuahe hetekie na nga mat ti ailei puase Jises tel Masiwi.” ");
INSERT INTO ssg_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Amite kum pon towiahui namili Pol ape amite ukek, “Tiliwen Haeu aile haseleni pupuasan.” ");
INSERT INTO ssg_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Muhin ien amite apeseni soxiamite ti kane Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Teka ti kahikahi Jises leili Sisaria lato hakahita amite to kapi Menason ti tehu luaiamite ien hani Jerusalem. Menason i tel akiki seilon ti texux xux Saiprus ma i tel kahikahi Jises lilian ti imat wanen. ");
INSERT INTO ssg_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ti amite tahia haniwa Jerusalem, teka kahikahi Jises pate lato amuke ma waxi auni amite. ");
INSERT INTO ssg_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ngain liai telao amite ma Pol nahih paxai Jeims ape hatesol masiwi ti teka kahikahi Jises ti Jerusalem tin lato tahiama. ");
INSERT INTO ssg_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol tengeni lato hatesol ape i kaxi nexi hatapo waliko ti Haeu hualiwen i ailean hani teka kumahe Ju. ");
INSERT INTO ssg_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ti i kak kewa lato hatesol kak sameni Haeu. Tuahe lato ukek, “Tel akikimite ahuma ti Jises, kilan kilan wanen teka Ju laha sohot kahikahi Jises. O tioi ka laha hani hahatapo namilolaha usiai nauna ti Moses. ");
INSERT INTO ssg_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tuahe laha hongoen ka o to hahanau hatesol Ju, laha toto xuxi teka kumahe Ju, ka laha lioiwa nauna ti Moses. Laha ukek ka o hone laha kum ailele teik kikilam ti kotiai uli walikoi natulaha wawan masin kolakol ka laha seilon ti Haeu. Tin laha ukek ka o hone laha kum usiusi saun liai ti kako teka Ju. ");
INSERT INTO ssg_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Liai laha tioi ka o tahiawen. Kako namiloi upia tewau aweisal lehe laha paxai tioi ka o usiusi nauna ti kako teka Ju. ");
INSERT INTO ssg_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","“Amite tenen namil. Hinalo seilon ie lato kak tuoha haniwen Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nahih kahitiwa lato hani tehu Ingi Haeu ape hukumawa kapi lato ti ailei saun ti hauniamuto ti puli Haeu. Ape kahuiwa ti uluhiai patulato masin kolakol ka lato aile hapoponowi hawanewen tutuoh ti lato hani Haeu. Na o aile ukek ien, hatesol seilon paxai tioi ka kumahe salan waliko ti laha hongoen pake o usiusi nauna ti Moses. ");
INSERT INTO ssg_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tuahe ti hani teka kahikahi Jises laha kumahe Ju, amite kaxi haniwen laha namilomite leili teik kakain. Amite taiwen ka laha kum aniani an tenen teka seilon ailewen pali hani teka haeu kumahe salan. Laha kum ailele saun lialun ti wawan hehin, kum ununumi kaka ma kum aniani xixioi manihuh tenen hina kaka leilon.” ");
INSERT INTO ssg_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ape Pol aile usi teik namilolato. Ngain liai telao i hukuma hani kapi tesol hinalo seilon ti aile haunialato usiwa saun ti teka Ju. Muhin ien Pol nahih hani tehu Ingi Haeu ape i hahongo teka hukuminiai Haeu ma seilon ka muhi ngain tepanim huohu lato kau huok manixux hani Haeu ti kolakol ka tutuoh ti lato hani Haeu ape tapein. ");
INSERT INTO ssg_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ti ngain tepanim huohu sikole i tapo, teka Ju akiki texux xux Asia lato ningahi Pol leili Ingi Haeu. Lato hahika teka kilai seilon ape laha akeni pohi Pol. ");
INSERT INTO ssg_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ape laha tilol, “Seilon ti Israel! Hualima amite xotian! Tel seilon ie i tel ti lawe i nahih tapai tesol tesol hahanau seilon watakaiai seilon ti Israel ma nauna ti Moses hetekie tehu Ingi Haeu ie. Ape tin i hakahita teka seilon kumahe Ju hani Ingi Haeu ape aile haloloa.” ");
INSERT INTO ssg_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Laha kak ukek ien nake laha ningahi Pol kapi Tropimus, tel kumahe Ju ti Epesus, leili Jerusalem ape laha sokok ka Pol hakahitawen i hani Ingi Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Hatesol seilon leili Jerusalem leng hawane ape laha kiliwama tesol tesol. Laha itini ahuti Pol ti Ingi Haeu ape kakanua laha keiti kahip. ");
INSERT INTO ssg_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Teka kilai seilon ien laha tohongi teleiai Pol tuahe kakain tahia tamus hani Klodius tel masiwi ti hile ti Rom ka hilehile i sosohot leili Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kiliwan wanen i waxi teka seilon ti hile ma teka masiwi hahitakan ape lato kiliwau kosea hani kapi teka laha apupuha. Ti teka kilai seilon ningahiwa lato, laha monga xaiai Pol. ");
INSERT INTO ssg_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ape tel masiwi Klodius xoti Pol. I hone teka unauan ka lato kewa huaik sen xinoti konginian. Ape i kamei teka kilai seilon, “Aita tel seilon ie? I ailewen waliko la?” ");
INSERT INTO ssg_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Teka ti laha tiloma tenen, teka liai tiloma liai tenen. I kum pon tunahiai kakain salan nake pate laha wiliwilia ma laha hahataxina aliake laha. Aile ape i hone teka unauan atiai Pol hani tehu ing tone teka seilon ti hile. ");
INSERT INTO ssg_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Lato tai nahih xau ape teka seilon leng eliel ahe. Aile ape ti awaiai Pol, teka seilon ti hile lauti kau i. ");
INSERT INTO ssg_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Teka seilon to nahih usiusi Pol ape tilol ausisini, “Teleiwa i! Teleiwa i!” ");
INSERT INTO ssg_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ti teka seilon ti hile lehe hasoho Pol hani leili ing, Pol kamei tel masiwi Klodius i ukek, “Ewi na nga kaakamu kapim?” Ti tel masiwi hongoa, i ong tilol ukek, “O se o kakak kakai Grik! ");
INSERT INTO ssg_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nga sokok o tel seilon ti Igip, tetel i neini teka seilon hil pahoiai teka Rom ape i hakahita 4,000 seilon tuaun hani lohong tesol ti laha toto.” ");
INSERT INTO ssg_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol kak pahoi, “Kumahe! Nga tel Ju ti Tarsus leili Sailisia, tehu taon lalap tuah. Ewi na nga kakane teka seilon ie?” ");
INSERT INTO ssg_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ti tel masiwi sowini haniwa Pol, i tu patul lehe laha ningahi i. I tulini minan lehe i kak. Ti teka kilai seilon kak mongawa, Pol hutui kakaian ti kakai Arameik, puki kakaialaha. ");
INSERT INTO ssg_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pol ukek, “Amuto teka akikik, teka masiwi ma teka lokok, hongoa kakain ti ape nga kaxi nexi hani amuto waliko ti i sohotuen.” ");
INSERT INTO ssg_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ti laha hongoa i kaakane laha ti puki kakaialaha, laha hamalum hawane ape Pol hutui kakaian. ");
INSERT INTO ssg_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nga tel Ju ti Tarsus leili Sailisia tuahe nga lap ie leili Jerusalem. Gamaliel tel i hanau hatapo nga sale nauna ti teka tamakako ti imat ape nga hani hatapoen kuik ailei puase Haeu masin ti amuto. ");
INSERT INTO ssg_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Imat nga aile halialu teka seilon laha usiusi aweisali Krais ape teka, laha telei. Nga xoti wawan ma hehin. Nga xioti laha ani sen ape hana hani kalabus. ");
INSERT INTO ssg_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Tel masiwi tapein ti hukuminiai Haeu ma seilon ma hatesol masiwi liai pon kaxi haniamuto ka kakaiak salan. Nga kema pas ti lato haniai teka masiwi ti tesol synagog leili Damaskas, i kaxi ka nga pon xotiai teka kahikahi Jises ape hakahita kalabusialaha hani Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ti nga lua xohi hahaniwa Damaskas, ti lape ngain teik xewan ahuma he maun i xeu hahutuia kakalini nga. ");
INSERT INTO ssg_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nga put hani itan ape nga hong tenen kinax kakane nga ukek, ‘Sol, Sol, alahan o to aile hahalialu nga?’ ");
INSERT INTO ssg_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ape nga kamea, ‘Tel masiwi, o aita?’ “Ape i pahoi ukek, ‘Nga Jises ti Nasaret, tetel o to aile hahalialu.’ ");
INSERT INTO ssg_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Tesol seilon kapik lato ningahi teik xewan, tuahe lato kum hong kinaxe tel seilon i kakak. ");
INSERT INTO ssg_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Nga kamei i, ‘Tel Masiwi, kaie nga aile la?’ “Ape tel Masiwi hone nga, ‘Xahatawa, nahih tamus haniwa Damaskas lehe ape o hong waliko tenen na o aile.’ ");
INSERT INTO ssg_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","“Teka seilon kapik akeni minak ape hakahita nga hani Damaskas nake teik lalape xewan hapulaxa pulak. ");
INSERT INTO ssg_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ti leili tehu taon ien, tel seilon axan Ananaias. I tel seilon ti usi hawanei nauna ti Moses ma hatesol teka Ju leili Damaskas laha sameni i. ");
INSERT INTO ssg_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","I nahih tu hanima kapik ape i ukek, ‘Sol, tel akikik Ju, nga kakane o, paxapax aliawa!’ Tataen ien wanen, nga paxapax alia ape nga ningahi i. ");
INSERT INTO ssg_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ape Ananaias kakane nga ukek, ‘Haeu tel Masiwi ti kako ma ti teka tamakako ti matahaun i kilamiwen o lehe o tioi waliko ti i pahan ma lehe o ningahi Jises tel unauan sawisawin ape hong hawane kakaian. ");
INSERT INTO ssg_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ape o kaxi sale puase Jises hani lawe seilon, waliko ti o ningahiwen ma hongoen. ");
INSERT INTO ssg_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kum talitalia. Haxoxoa namilom haniwa Jises ape nga baptaisi o hahitake axan lehe Haeu oxoxi o ti kawatan ti lialui woum.’ ");
INSERT INTO ssg_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ti nga nahih alia haniwa Jerusalem ape nga lolotu leili Ingi Haeu, Holi Spirit hanamiloa nga ningahiai Jises. ");
INSERT INTO ssg_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Jises hone nga, ‘Salili koseniwa Jerusalem nake teka seilon ie laha kum hong soh na o kaxi nga hani laha.’ ");
INSERT INTO ssg_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Nga kak pahoi ukek, ‘Tel Masiwi, kemuk nga kalabusi ma xai teka kahikahim leili synagog. ");
INSERT INTO ssg_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ape ti laha hokai telei Stiven tel unauam ani pot, nga tutu ien. Puki nga paxai waheni. Nga tetel peteniai atuhiai puxui teka seilon laha hohokai i. Tuahe ape seilon paxai tioi ka nga towiahuen.’ ");
INSERT INTO ssg_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Tuahe Jises tel Masiwi hone nga, ‘O saliliwa Jerusalem nake nga talo haxau o hani kapi teka kumahe Ju lehe laha hong meng solian tetak.’” ");
INSERT INTO ssg_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Teka seilon laha hong atengi tataen Pol tili kakaian ka Jises talo i hani teka kumahe Ju. Ape laha ausini ukek, “Hatapo xaxaweniwa axan! Teleiwa i! Tapai ala telei kueiniwen i!” ");
INSERT INTO ssg_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ti laha leng ausisini, laha totowi atuhiai puxuaulaha ma towi sasapoxi hepekeun hani patul kolai lialui lolaha ti Pol. ");
INSERT INTO ssg_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Klodius tel masiwi ti hile ti Rom hakahita Pol hani leili tehu ing tone teka seilon ti hile ape i hone teka unauan ka lato hetiwa i lehe i kaxi waliko tetenen teka Ju ausini wawatakai. ");
INSERT INTO ssg_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ti lato xinoti kewa Pol ape apeas ti hetian, Pol kakane tel masiwi hahitake Klodius tutu ien, “Nakon ewi ti hetiai tel seilon hahitake ngahat ti Rom na masin i tai tu ti sulusulu?” ");
INSERT INTO ssg_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ti i hong kewak ien, i nahih hani kapi Klodius ape i ukek, “Tel seilon ien i hahitake ngahat ti Rom! Ape o aile ukek ia?” ");
INSERT INTO ssg_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kakanua Klodius nahih hani kapi Pol ape kamei i, “Kaxi hanima nga, o tel ti hahitake ngahat ti Rom?” Pol pahoi ukek, “Salan.” ");
INSERT INTO ssg_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Klodius ukek, “Nga kahui halapa hawane moni lehe nga sohot tel ti hahitake ngahat ti Rom.” Pol ukek, “Nga tel ti hahitake ngahat ti Rom nake tel tamak i tin hahitake ngahat ti Rom!” ");
INSERT INTO ssg_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Tataen ien wanen teka seilon ti hile lehe laha heti Pol, laha sia alia tetan. Ti Klodius tioiwa ka Pol tel ti hahitake ngahat ti Rom, i mamata hawane nake i honewen teka unauan xinoti hetiai Pol. ");
INSERT INTO ssg_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Tel masiwi Klodius pahan i tioi huan ti teka Ju sului Pol. Aile ape ngain liai tehu i oxoxi sen ti he mini Pol ape i hone teka masiwi tuah ti hukuminiai Haeu ma seilon ma teka Ju masiwi liai ka lato apuhawa. Ape i waxi hatuhi Pol hani matalato. ");
INSERT INTO ssg_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol pax sawi hani hatesol masiwi ien ape i ukek, “Teka Ju akikik. Nga ilameni tioi ka pupuasak ti Haeu sawisawin wanen.” ");
INSERT INTO ssg_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ti i hongoa ien, Ananaias tel masiwi tapein ti hukuminiai Haeu ma seilon, hone teka seilon tutu xohixohin kapi Pol ka tapahiwa i. ");
INSERT INTO ssg_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ape Pol hone i ukek, “Haeu tin i tapahi o, tel seilon lehom huoka! O toto ie ape o susului nga hahitake nauna ti Moses tuahe puki o xaxaputi nauna tetan ti o hone laha tapahiak.” ");
INSERT INTO ssg_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Tesol seilon tutu xohixohin kapi Pol laha hong teik kakaian ape laha hone i, “Kalahai o kak halialu tel masiwi tapein ti hukuminiai Haeu ma seilon?” ");
INSERT INTO ssg_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pol kak pahoi ukek, “Tesol akikik, nga tai tioi ka i tel masiwi tapein ti hukuminiai Haeu ma seilon. Na nga tioila, nga tai kak halialu i nake teik kakai Haeu ukek, ‘Kum kak hahalialu tel masiwi ti neiniamuto.’” ");
INSERT INTO ssg_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ti Pol paxai tioiwa ka leili teka masiwi ien hina teka Sadusi ma teka Parisi i tilol hani lato, “Teka akikik, nga tel Parisi masin teka tamak ti matahaun. Nga tu ti sulusulu nake nga soh ka seilon maten laha moih alia.” ");
INSERT INTO ssg_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ti i kak kewak ien, teka Parisi ma Sadusi hutui kak he hapatapat. ");
INSERT INTO ssg_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Namilolato ape i selaia nake teka Sadusi ukek ka teka seilon matewen laha kum moih alia, a tin tap teka engel ma tap teka spirit, tuahe teka Parisi soh ti hatolunen waliko ien. ");
INSERT INTO ssg_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Lato tit tule ape leng ausisini hawane. Teka ti hanaui nauna ti Moses lato Parisi, lato kak eliel, “Amite tai upia tunahi tenen saun lialun na i ailewen. Sohin uke na spirit ma na engel kaakane i.” ");
INSERT INTO ssg_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Tel masiwi Klodius paxai ka ape laha leng eliel hahawane. I mamata uke laha aile hamange Pol. Kakanua i hone teka unauan ka lato nahih haniwa leilolaha, waxi lungeiwa Pol ape hakahita haniwa tehu ingi teka seilon ti hile. ");
INSERT INTO ssg_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ipong tehu ien Jises tel Masiwi take hani kapi Pol ape i ukek, “Kum maamata! Masin ti o kaxi sasawateni nga leili Jerusalem, tin kaxi ahutiwa meng solian tetak leili Rom.” ");
INSERT INTO ssg_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ti ngain liai telao, tesol ti teka Ju apuha ape aile teik namil ti aile halialui Pol. Lato kak kuinake hani Haeu ka lato kum ang ma un hani tataen na lato telei kewa Pol. ");
INSERT INTO ssg_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mongohe teteka seilon akulai 40. ");
INSERT INTO ssg_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ape lato nahih hani kapi teka masiwi tuah ti hukuminiai Haeu ma seilon ma teka masiwi liai ape lato ukek, “Amite tuoha ka amite kum ang ma un hani tataen na amite telei kewa Pol. ");
INSERT INTO ssg_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Amite ailewen teik namil. Amuto ma teka masiwi liai kameiwa tel masiwi Klodius waxi aliakema Pol. Kak hanowiwa ka pahamuto kamei aheke Pol waliko ti amuto susului i. Ape amite telei i imat ti i tahiama.” ");
INSERT INTO ssg_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ti tel wawan uluha nati tel tuai Pol hongoa teik namil ien, i nahih hani ingi teka seilon ti hile ape i kaxi hani Pol. ");
INSERT INTO ssg_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pol tiloi tel ti teka masiwi hahitake Klodius ape hone i, “Hakahitawa tel seilon uluha ie hani tel masiwi Klodius. I hina waliko tuah ti na i kaxi.” ");
INSERT INTO ssg_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ape i aile usi. I kakane Klodius, “Tel seilon kalabus axan Pol hone nga hakahita hanima o tel seilon uluha ie nake pahan i kakak kapim.” ");
INSERT INTO ssg_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Klodius ati i hani tesol mewenae lalu ape kamei i, “Waliko la paham o kakane nga?” ");
INSERT INTO ssg_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tel seilon uluha ukek, “Tesol ti teka Ju ailewen teik namil ka letu lato kamei o waxiai Pol hani kapi teka masiwi ti lato. Lato kak hanowi ka pahalato kamei ahekean waliko ti lato susului i. ");
INSERT INTO ssg_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Tuahe kum ailele nake kilai seilon akulai 40 lato muna pepeteni i ti teleian. Lato tuohawen ka lato kum ang ma un hani tataen na lato telei i. Aope ie lato atetengi na o sowini hani lato waxiai Pol.” ");
INSERT INTO ssg_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Klodius hone i, “Kum kakaxi hani tel na seilon ka o kaxi haniwen nga.” Ape i talo aliake tel seilon uluha. ");
INSERT INTO ssg_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ape tel masiwi Klodius tiloi hua unauan, masiwi ti hile ape i ukek, “Waxiwa 70 seilon ti hile laha kiliwakei hos, 200 seilon ti hile laha hokahoka ti samen ma 200 liai. Amuto apeasawa ti lua hani tehu taon Sisaria ti 9 kilok ipong tetehu. ");
INSERT INTO ssg_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Waxi apeseni haniwa Pol hina hos lehe amuto atoheni hahamahuli i hani kapi Feliks, tel masiwi ti Sisaria.” ");
INSERT INTO ssg_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Muhin ien i tai teik pas hani Feliks. I ukek, ");
INSERT INTO ssg_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Kakaiak nga Klodius Lisias, hani o Feliks, tel masiwi tuah. Letu solian! ");
INSERT INTO ssg_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Tesol ti teka Ju pohi kongini tel seilon ie ape lehe lato telei. Ti nga tioiwa ka i tel seilon hahitake ngahat ti Rom, nga hetekie tesol seilon tetak amite awai i. ");
INSERT INTO ssg_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Pahak nga tioi hui suluan, aile ape nga hakahita i haniwen teka masiwi ti teka Ju. ");
INSERT INTO ssg_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nga tunahi ka tesol Ju sului Pol ti xaputiai nauna ti lato teka Ju. Sulusulu ti lato i kum pon xotian ma teleian. ");
INSERT INTO ssg_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nga hongoen ka teka seilon aile teik namil ti teleiai Pol. Aile ape nga hakau koseni i hani o. Ape nga hone lato ka pamu ewi na o hongoi sulusulu ti lato.” ");
INSERT INTO ssg_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Teka seilon ti hile aile usi kakai Klodius Lisias, tel masiwi ti lato. Ipong tetehu ien, lato waxi Pol ape hakahita i hani tataen tehu taon Antipatris. ");
INSERT INTO ssg_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ti ngain liai telao tesol ti teka seilon ti hile laha alia hani Jerusalem ape teka liai ti kiliwakei hos laha hakahita tamusuke Pol hani tehu taon Sisaria. ");
INSERT INTO ssg_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ti laha tahia haniwa Sisaria, laha hani tel masiwi Feliks teik pasi Klodius ape hana Pol he minan. ");
INSERT INTO ssg_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Muhin ti i ridaiwa teik pas, i kamei Pol, “O ti lahe xux?” Pol pahoi ukek, “Ti Sailisia.” ");
INSERT INTO ssg_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Feliks ukek, “Nga hong mengom na teka suluam tahiama.” Ape i hone teka unauan peteniai Pol leili tehu ing lalap atataiai tel masiwi Herod. ");
INSERT INTO ssg_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Muhi ngain tepanim, Ananaias tel masiwi tapein ti hukuminiai Haeu ma seilon, tahia hani Sisaria hetekie teka Ju masiwi liai ma Tertelus, tel pupuasan tukei awe teka suluiai Pol. Lato tahia ti suluiai Pol hani tel masiwi Feliks. ");
INSERT INTO ssg_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ti tel masiwi hasohoa Pol hani tesol tone apuhain, Tertelus hutui kakaian hani Feliks. I ukek, “O tel masiwi tuah, o huali hatona hasoliawen amite teka Ju ape tap hilehile. Ti soliai namilom, o aile sohi hakila waliko ti hasoliai xuxumite. ");
INSERT INTO ssg_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Amite paxai tesol waliko ien ape amite hatesol sameni o. Amite kak kemulik hawane hani o. ");
INSERT INTO ssg_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nga kum kongini kueini o. Nga kamei eliel o, ti soliaiam nati hongoa teik kukunui kakaiamite. ");
INSERT INTO ssg_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Amite paxai tioi tel seilon ie i weli aile halialui wasole seilon. Lawe i hahika teka Ju tesol tesol ti hil pahoiai teka masiwi ti Rom. I nanahike temat seilon laha axai Nasarin, teka kahikahi Jises ti Nasaret. ");
INSERT INTO ssg_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Tin lehe i halialu tehu Ingi Haeu tuahe amite akeni kongini i. ");
INSERT INTO ssg_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Tel masiwi Klodius Lisias waxi lungei Pol ti amite ape taloma teka suluan hani o. ");
INSERT INTO ssg_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Kewa puki o kameian lehe o tioi waliko ti amite susului i.” ");
INSERT INTO ssg_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tesol Ju sa huali kakai Tertelus ape lato ukek ka kakaian pate salan. ");
INSERT INTO ssg_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ape tel masiwi Feliks kola Pol ka i kakawa. Ape Pol kak ukek, “O tel masiwi tuah, nga tioi ka ahang kilan o toto tel nam paxaiamite teka Ju. Aile ape tiak i amuam ti nga kak xengei kakaialato matam. ");
INSERT INTO ssg_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Na o kamei teka seilon, o tunahi koseni ka i tai akulai ngain huopanim huohu ti nga lolotu leili Ingi Haeu ti Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Laha tioi ka nga tai kak he lungelung kapi tel na seilon ti leili Ingi Haeu. Tin laha tioi ka nga tai hahika teka Ju leili synagog ma tesol tesol ti Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ape teka seilon ie lato tap aweisal ti kolaian ka sulusulu ti lato salan. ");
INSERT INTO ssg_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“A waliko tetenen salan ie. Nga usiusi aweisali Krais tenen lolaha kum al. Nga lolotui tel Haeu ti teka matahaun ti amite lolotui ape nga soh hawane hatesol nauna ti Moses ma lawe waliko ti teka kuluiai kakai Haeu taiwen. ");
INSERT INTO ssg_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Tin masin teka seilon ie, nga monomon ka Haeu hamoiha aliake teka seilon matewen, teka seilon solian ma teka lialun. ");
INSERT INTO ssg_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Aile ape lawe nga puas eliel hawane lehe tiak mewenae ewi ti Haeu ma teka seilon. ");
INSERT INTO ssg_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Hina ahang tamusuen nga alia hani Jerusalem. Nga atoheni moni hualiai teka akikik Ju ma nga lelei manihuh hani Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Teka suluak ningahi nga ailele saun ti hauniak ti puli Haeu leili Ingan. Tap seilon wiliwilia nake ti huak lokon ien. ");
INSERT INTO ssg_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Tuahe tesol ti teka Ju ti Asia lato ien, lato ala matam ie na lato hina kakain ti suluak. ");
INSERT INTO ssg_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","I pon o kamei tesol seilon ie waliko ti lato titieni nga lokon ti nga tutu ti sulusulu mate teka masiwi ti teka Ju. ");
INSERT INTO ssg_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Lato pon suluak mewenae ti teik kakain nga ukek ka nga tu ti sulusulu nake nga soh ka seilon maten laha moih alia.” ");
INSERT INTO ssg_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks tioi hawane teka laha usiusi aweisali Krais ka laha kum pahoi teka masiwi ti Rom tuahe i mongenimu tehu sulusulu ien ape i ukek, “Ti na tel masiwi Klodius Lisias tahiama, nga aile namilok sale hasawiai tehu sulusulu.” ");
INSERT INTO ssg_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ape i hone tel ti teka seilon ti hile peteniai Pol tuahe i ukek ka ewi na teka lohun huali i ti tenen waliko na i tap. ");
INSERT INTO ssg_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Hina ngain tamusuen, Feliks ma tel axoan Drusila tel hehin Ju, lalu tiloi Pol ape lalu hong kakaian. Pol kak nexi sale usiai aweisali Jises. ");
INSERT INTO ssg_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","I kaxi hani lalu ukek, “Mewenae na namilokaha xoxoan ti Jises, wasolakaha seilon ma Haeu i sawi. Haeu pahan kaha seilon tahiwa hatesol isiakaha tenen i aile halialu kaha. Ngain tehu Haeu hiniti hatesol seilon.” Feliks hongoa kakaian ape i mamata hawane. I ukek, “O nahimua. Nga po ilowi o na pahak.” ");
INSERT INTO ssg_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Muhin ien, Feliks ilowi hakila hawane Pol nahih kakak kapin nake i kakatohoi Pol moni ahutian ti kalabus. ");
INSERT INTO ssg_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Feliks aile ukek ien leili ahang huohu. I kongini hamalumini Pol leili kalabus nake pahan i hamuamua teka masiwi ti teka Ju. Imuh Porkius Festus uke totonan ti nahikei Sisaria. ");
INSERT INTO ssg_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tel masiwi Festus tahia haniwa Sisaria ape ti ngain toluhu tamusua i lua hani Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Teka masiwi tuah ti hukuminiai Haeu ma seilon ma teka Ju masiwi liai hahongo i sale suluiai Pol. ");
INSERT INTO ssg_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Lato kamei eliel Festus, “Ewi na o hakau sohi Pol hanima Jerusalem?” Lato kak ukek nake pahalato teleiai Pol ti luaian hani Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Tuahe Festus hone lato ukek, “Kumahe! Pol tiliwen kalabus ti Sisaria pake kum kue nga alia hani ien. ");
INSERT INTO ssg_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Teka masiwi ti amuto kahitima nga hani Sisaria. Na Pol ailewen tenen waliko lialun, amuto suluiwa i ien.” ");
INSERT INTO ssg_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Muhi ngain huopanim, Festus alia hani Sisaria ape ti ngain liai telao, laha hutui suluiai Pol. Festus hone teka unauan ka lato hakahitama Pol. ");
INSERT INTO ssg_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Tataen Pol tahiama, teka masiwi ti Jerusalem tu koui i ape lato kak susului i kakain tenen tap salangawan. ");
INSERT INTO ssg_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pol ukek ka kakaialato kumahe salan. I ukek, “Nga tai xaputi tesol nauna ti Moses, nga tai halialu Ingi Haeu ma nga tai xaputi tuahe na tenen nauna ti teka masiwi ti Rom.” ");
INSERT INTO ssg_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Tuahe Festus pahan i aile haewia namili teka Ju ape i kamei Pol, “Nakon o waheni na nga hong paxai tehu sulusulu ie hani Jerusalem?” ");
INSERT INTO ssg_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pol kak pahoi i ukek, “Kumahe! Ti aope ie nga tutu mate tel ti teka masiwi ti Rom. Nga tel seilon hahitake ngahat ti Rom, aile ape o pon hong paxaiai kakain ti suluak. O tioi hawane ka nga tai aile tenen na waliko lialun hani teka Ju. ");
INSERT INTO ssg_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Na nga ailewen tenen saun lialun ti i pon nga mat, nga kum salini uke. Tuahe na tap kakain salan ti lato sului nga, tap tel pon hangainiak hani lato. Katekate tetak ka Sisa tel masiwi tapein ti Rom hong paxaiai kakain ti suluak.” ");
INSERT INTO ssg_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus kakak kapi tesol hualian ti axiai namil ape i pahoi Pol ukek, “Katekate tetam nga sowini, nga hakau o hani Sisa!” ");
INSERT INTO ssg_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Muhi hina ngain tel masiwi Agripa ma tel tuan Bernis tahia hani Sisaria ti paxaiai Festus. ");
INSERT INTO ssg_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Lalu to kapin kilan ngain ape Festus kaxi haxewa hani lalu sale Pol. I ukek, “Tel seilon i kakalabus ie lilian ti Feliks. ");
INSERT INTO ssg_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Lokon ti nga Jerusalem, teka masiwi tuah ti hukuminiai Haeu ma seilon ma teka Ju masiwi liai, laha sului Pol ape kamei nga ti axian kawatan. ");
INSERT INTO ssg_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Tuahe nga kakanewen lato ka kumahe saun ti kako seilon ti Rom ti axiai seilon kawatan na kako tai hatuhi laha ti sulusulu. Imat kako hani laha kak xengeimu kakain ti teka sulualaha. ");
INSERT INTO ssg_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Aile ape ti teka suluiai Pol tahia kemak ie, nga akeni hulutini tehu sulusulu ti ngain liai telao. Ape nga hone teka unauak ka lato hakahitama Pol. ");
INSERT INTO ssg_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ti teka suluian tua ape lato kak, kumahe lato susului i waliko ti nga amemene. ");
INSERT INTO ssg_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Lato kakak sale lotuiai Haeu ti lato ma sale Jises, tel i matewen, tetel Pol ukek ka i moihin tutuen. ");
INSERT INTO ssg_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nga kum tioi aluini sale kiliwakei tehu sulusulu ape nga kamei Pol na i waheni lua hani Jerusalem lehe laha hong paxai kakain ti suluan ien. ");
INSERT INTO ssg_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Tuahe Pol pahan Sisa hong paxaiai kakain ti suluan. Aile ape nga kongini hamalumini i leili kalabus atengi tataen na nga hakau uke i hani Sisa.” ");
INSERT INTO ssg_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa kakane Festus, “Pahak puki Pol kakak kapik.” Festus ukek, “Ewi, letu ape o hong kakaian.” ");
INSERT INTO ssg_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ti ngain liai tehu Agripa ma Bernis nahih soh hani tehu ing ti hong paxaiai sulusulu, hetekie teka masiwi ti teka seilon ti hile ma teka seilon tuah ti Sisaria. Hatesol seilon ien laha paxai sameni lalu. Ape Festus hone teka unauan ka lato hakahitama Pol. ");
INSERT INTO ssg_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus kak ukek, “Tel masiwi Agripa ma amuto hatesol, ie se seilon tetel teka Ju ti Jerusalem ma teka Ju ti Sisaria laha eliliel ka teleiwa. ");
INSERT INTO ssg_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Tuahe taen ti nga hong paxaiwa, nga tai tunahi waliko tenen na lialun ti i pon kaha telei i. Tuahe ti i katei ka Sisa hongoi mengon, nga noseni hakauan hani Sisa. ");
INSERT INTO ssg_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Tuahe nga kum tioi aluini waliko tenen na nga tai hani Sisa sale Pol. Aile ape nga atoheni i hanima kapimuto hatesol ma o tel masiwi Agripa, tel seilon pate tuah ti kako. Taen kako kamei matainiwa i ape nga tioi waliko na nga tai hani Sisa. ");
INSERT INTO ssg_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nga namiloi ukek kumahe solian ti hakaui tel seilon kalabus hani tel masiwi Sisa na kako kum tioi aluini waliko tenen lialun ti laha susului i.” ");
INSERT INTO ssg_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tel masiwi Agripa hone Pol, “Ape ewi na o kak xengei kakai teka suluam aope ie.” Pol tulini minan i kola ka ape i kak. I ukek, ");
INSERT INTO ssg_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Tel masiwi Agripa! Pate onotan ka o tel hong paxaiai kakaiak ti nga xengei kakai teka suluak. ");
INSERT INTO ssg_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Pake pate o tioi hatesol saun ti teka Ju ma waliko ti laha kak he hapatapat. Nga kamei eliel o, hong matainiwa kakaiak. ");
INSERT INTO ssg_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Hatesol Ju laha tioi sale totonak lilian ti uluhauk, ti nga toto xuxuk ma leili Jerusalem. ");
INSERT INTO ssg_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Laha tioiwen nga lilian ti kuewen ape na pahalaha kaxi kakain salan, pon laha kak ka laha tioi ka nga tel ti teka Parisi amite puas usi aluluini hatesol nauna ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Aope ie lato sului nga nake nga to monomon ka Haeu aile hapoponowi waliko ti i kakanewen teka tamamite Ju sale xahateniai seilon maten. ");
INSERT INTO ssg_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Teka huopanim huosol seilon ti Israel lato monomon waliko tin tetenen ape lawe lato lolotui Haeu ma ailele puasan. Tel masiwi, ti teik monomon ien teka Ju susului nga.” ");
INSERT INTO ssg_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ape Pol kakane teka Ju i ukek, “Alahan teka ti amuto kapaxe ka Haeu hamoiha aliake seilon maten? ");
INSERT INTO ssg_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Puki nga kemuk nga soh hawane ka ewi ti aile halialui teka kahikahi Jises ti Nasaret. ");
INSERT INTO ssg_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Se pupuasak wanen ti leili Jerusalem. Na teka masiwi tuah ti hukuminiai Haeu ma seilon sowiniwa, nga xoti teka kahikahi Jises ape hana hani kalabus. Tin nga waheni na telei lato. ");
INSERT INTO ssg_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nga nahih hani synagog tehu tehu ti aile halialualato ape lungei lato kak halialui Haeu. Kalak tataen ti taon ti teka kumahe Ju nga kum sosokol aile halialualato. ");
INSERT INTO ssg_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Telao nga lua hahaniwa Damaskas ailei tenen puasain ien ti teka masiwi tuah ti hukuminiai Haeu ma seilon sowini haniwen nga. ");
INSERT INTO ssg_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Tel masiwi, ti lape ngain nga ningahi hahutuia teik xewan, i xoini hawane xame al. I kakalini nga ma teka seilon kapik. ");
INSERT INTO ssg_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Amite hatesol put hani itan ape nga hong tenen kinax i kakane nga ti Arameik, kakaiak wanen, ‘Sol, Sol, alahan o aile hahalialu nga? Tel na i hil pahoi nga, i tunahi kawatan.’ ");
INSERT INTO ssg_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Nga kamea, ‘Tel Masiwi, o aita?’ “Ape tel Masiwi pahoi ukek, ‘Nga Jises, tetel lawe o to aile hahalialu. ");
INSERT INTO ssg_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Xahatawa! Nga take hani kapim ti kilamiam tel unauak ma kaxi haniai lawe seilon waliko ti o ningahi tetelao ma imuh. ");
INSERT INTO ssg_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ape nga awai o ti teka Ju ma ti teka seilon laha kumahe Ju, teteka ti nga talo o hani kapi laha. ");
INSERT INTO ssg_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","O haxewai pulalaha waxi laha towiahu ti tilokoan hani xewan, ti pohe Satan hani Haeu lehe Haeu oxoxi laha ti kawatan ti lialui woulaha. Ape laha selaia hani ailei puasan nake namilolaha xoxoan tetak.’ ");
INSERT INTO ssg_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Tel masiwi Agripa, aile ape nga kum tahi waliko ti Jises kakane nga ailean ti i take hani nga he aweisal hani Damaskas. ");
INSERT INTO ssg_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Imat nga kaxi ahuti meng solian ti Jises hani teka seilon ti Damaskas, muhin leili Jerusalem ma hatexux xux ti Judia ape tin hani teka seilon laha kumahe Ju. Nga honewen laha ka laha towiahua ti lialui woulaha ape usiwa Haeu. Nga kakanewen laha ti ailei saun tetenen i kola ka laha lioiwen saun lialun. ");
INSERT INTO ssg_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nake ti kaxiai kakai Haeu, tesol Ju aka kongini nga leili Ingi Haeu ape lato tohongi teleiak. ");
INSERT INTO ssg_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","“Tuahe Haeu lawe i huhuali nga hanima taen tetelao. Aile ape nga tutu ie kakaxi sale puase Jises hani teka seilon tuah ma teka seilon naun. Kumahe nga kakaxi waliko liai tenen ti teka kuluiai kakai Haeu ma Moses ukek i sohot. ");
INSERT INTO ssg_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Nga kakaxi ka Krais, tetel Haeu taloma, i tunahi kawatan ape laha telei i. Tin nga kakaxi ka i tetel Haeu hamoihamu imat ti lawe seilon maten. Kakaian masin teik xewan hani teka Ju ma teka kumahe Ju.” ");
INSERT INTO ssg_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ti Festus hongoa ien, i tilol tumei Pol, i ukek, “O taxitaxiawen! Anesoam lap kasia ape i aile hataxitaxia o!” ");
INSERT INTO ssg_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Tuahe Pol pahoi ukek, “Tel masiwi tuah, nga kumahe taxitaxia. Kakaiak hina salangawan. Salan wanen waliko ti nga kakak. ");
INSERT INTO ssg_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ape tel masiwi Agripa i tioi aluini hawane waliko ti nga kakak. Nga kak matut hani i nake nga soh ka hatesol waliko nga kakaxi koukean tetan. Waliko ien kumahe ti lehe i muna.” ");
INSERT INTO ssg_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ape Pol kakane tel masiwi Agripa i ukek, “Nga tioi hawane ka o soh waliko ti teka kuluiai kakai Haeu kakawen.” ");
INSERT INTO ssg_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa kamei Pol, “Nakon o sokok o sohi koseni uke nga hani tel kahikahi Jises?” ");
INSERT INTO ssg_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pol ukek, “Kalak na i kosea ma na kumahe, nga kamei Haeu ka kumahe mewenae o tuahe amuto hatesol ti amuto hongohong kakaiak amuto sohot kahikahi Jises hanowi nga, tuahe kumahe masin ti nga kakalabus ie.” ");
INSERT INTO ssg_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Muhin ien tel masiwi Agripa, tel tuan Bernis, tel masiwi Festus ma teka masiwi liai tule ape lato nahih salili tesol ien. ");
INSERT INTO ssg_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Lato kakak alia puki lato, “Tel seilon ien i tai aile waliko lialun tenen i tapai i kalabus ma na telei.” ");
INSERT INTO ssg_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa hone Festus ukek, “Na i tai katei ka Sisa hongoi kakain ti suluan, i pon kako hanahi lioi i.” ");
INSERT INTO ssg_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Lokon ien Pol ma teka kalabus liai laha hani he mini Julius, tel masiwi ti teka seilon ti hile ti Sisa. Tel masiwi Festus noseni ka Pol ma teka kalabus liai lato lang hani Rom. A nga, tetel taiai tenen meng ie, nga kukuoxi lato. ");
INSERT INTO ssg_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Aristakus, tel seilon ti Masedonia tonan leili tehu taon Tesalonika, i tin kapimite. Amite ku hani he tea waian ti tehu taon Adramitium, i apepeas ti lang sota hani taon tehu tehu peixux ti Asia. ");
INSERT INTO ssg_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ngain liai telao amite tahia hani tehu taon Saidon. Ti soliai Julius i sowini hani Pol nahih paxaiai teka lawan ien lehe laha huali i tenen na i tap. ");
INSERT INTO ssg_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ape amite lang ahe ulea. Aupol pate lengan tunahi amite, aile ape amite towiahuahu wasole texux xux Saiprus ma peixux ti xux lalap ien. ");
INSERT INTO ssg_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Amite lang towiahuahu usiai peixux ti texux xux Sailisia ma Pampilia ape amite tahia hani tehu taon Mira leili texux xux Lisia. ");
INSERT INTO ssg_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ti ien Julius tunahi tea waian ti tehu taon Aleksandria leili Igip i kane texux xux Itali. Ape i hakuhi amite he tea waian ien. ");
INSERT INTO ssg_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kilan ngain amite lang hahakokol ape amite tahia hani tehu taon Kenidus tuahe pate ailan. Amite tunahi aupol lengan wanen, aile ape amite lang non luainan ti texux xux Krit sahiwa toun ti Salmone. ");
INSERT INTO ssg_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Amite lang sahisahi peixux atengi amite tahia hani tesol axan Tone Petiain Solian, xohixohin tehu taon axan Lasea. ");
INSERT INTO ssg_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Hatalia langaiamite nake hunan pate lialun. Liai ape muhi tehu ngain ti teka Ju lelei manihuh hani Haeu kahi lialui woulaha. Laman pate lalap nake taun ti hunaxa. Aile ape Pol hone laha ka amite kum lang ahe. ");
INSERT INTO ssg_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","I kakane laha ukek, “Hongoa! Na kako lang lungelung, kako tunahi kawatan. Tea waian manan, kako lioi kilan soxi ma uke kilan seilon laha mat.” ");
INSERT INTO ssg_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Tuahe Julius hong soh kakai tel huniwa ma tel tame tea waian ape i kum tani waxi kakai Pol. ");
INSERT INTO ssg_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Petiai waian ti ien tin kumahe solian ti seilon heuta leili taun ti waiwain ma aupol kuin. Aile ape sikole hatesol teka maho noseni ka lato lang tatale hani Piniks, tesol petiai waian ti Krit, i pamu lihun ti hunan lialun. ");
INSERT INTO ssg_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kokole aupol ahoma sai haiup ape lato namiloi ka lato lang tohongi. Lato tei xuot, aheti lih ape lang sahisahi peixux ti Krit. ");
INSERT INTO ssg_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Tuahe tai kue tehu lamin luainima sai tolai angiha ti texux xux. ");
INSERT INTO ssg_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ti aupol taheima lato kum pon kapiti hasawiai tea waian ape amite puasake lioi tea waian aupol tua paxeni hamanumanu. ");
INSERT INTO ssg_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Pala amite lihu ti amite man haniwa sai haiup pape texux xux kokol axan Kauda. Tataen ien amite aheti ahuke tea koap amite wawati hani heiwai tea waian. ");
INSERT INTO ssg_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ape amite xioti talini haxo tea waian. Teka maho losi lih lehe tea waian tua man nake lato mamata uke amite oh hepekeun ti waloke Sirtis peixux ti Afrika. ");
INSERT INTO ssg_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ngain liai telao hunan pate lialun tutuen. Laman pexupexuini tea waian ape sikole amite kaxox. Kakanua lato towi xoini angah ti he tea waian. ");
INSERT INTO ssg_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ngain liai telao ulea tin lato towi xoini soxi tini tea waian ti hapalean. ");
INSERT INTO ssg_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kilan ngain amite kum niningah puli al ma kohot nake pate hunaxa tutuen. Aile ape namilomite sihikuk hawane aita pon huali amite. ");
INSERT INTO ssg_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kilan ngain amite tai angiang. Ape Pol hone tesol maho ukek, “Ala amuto hong usiwen kakaiak! Na kako tutuen Krit, ala kako tai xoini soxi ma tenen kawatan ie tai tunahi kako. ");
INSERT INTO ssg_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Tuahe amuto tu xoxoa pake tap tel ti amuto mat, mewenae tea waian manan. ");
INSERT INTO ssg_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Haeu, tetel nga unauan ma lawe nga lolotui, i taloma tel engel tetan hani kapik ipong tehu tatamusua. ");
INSERT INTO ssg_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ape i hone nga, ‘Pol, kum maamata! Haeu hong kamekame tetam ape i awai hatesol seilon kuoku kapim. Pahan o tu mate Sisa ti sulusulu!’ ");
INSERT INTO ssg_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Aile ape tu xoxoa! Nga soh hawane ka Haeu aile usi waliko ti i kakawen. ");
INSERT INTO ssg_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Tuahe tea waian i manan ape kako pap hasunga hani peixux ti texux xux.” ");
INSERT INTO ssg_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Muhi ngain huopanim hinalo ti amite manuman itax ti Adria, ti luhui ipong tesol maho sixi ka amite man xohi haniwen xux. ");
INSERT INTO ssg_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Lato halahe tok kapet tumun teik samen ape tunahi ka tahulouan ngahainan 20. Tai kue lato tohongi ulei ape tunahi ka ngahainan 15. ");
INSERT INTO ssg_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Pate lato mamata ka tea waian uke i man xotui hat. Aile ape lato halahe hinalo xuot muhiwai tea waian. Lato to hahaxe letuan. ");
INSERT INTO ssg_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Tesol maho lato tohongi ox saliliai tea waian ape lato halahe hamosu tea koap hani itax woinakon halahei xuot ti mateiwa. ");
INSERT INTO ssg_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Tuahe Pol hone Julius ma teka seilon ti hile, “Na tesol maho lato kum hamalum heiwa, kako hatesol mat.” ");
INSERT INTO ssg_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Aile ape teka seilon ti hile koti tok tal ti xiotiai tea koap ape i man. ");
INSERT INTO ssg_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Sikole letu, Pol kakane lato, “Amuto tai angiang ngain huopanim hinalo nake namilomuto kilan ti mamata ma monomon. ");
INSERT INTO ssg_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nga kamei eliel amuto, angimua teik lehe amuto kui. Kum maamata pake tap tel ti amuto mange.” ");
INSERT INTO ssg_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Muhin ien Pol waxi hina bret ape i kak kemulik hani Haeu ti he pulalato ape i ani. ");
INSERT INTO ssg_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Namilolato hatesol i soli ape lato ang. ");
INSERT INTO ssg_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mongohumite hatesol heiwai tea waian 276. ");
INSERT INTO ssg_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ti lato ang xuhawa, lato towi xoini tomi an hani itax lehe tea waian pal ahe. ");
INSERT INTO ssg_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ti letule, tesol maho kum paxai tioi texux xux ien. Tuahe lato ningahi teik walokan ma peixux ape lato namiloi na lato lang hani ien. ");
INSERT INTO ssg_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ape lato koti tesol tal xuot lehe i taxix. Lato upati tal ti xiotiai kapit ape lato aheti teik lih mateiwa lehe aupol halanga tea waian hani peixux. ");
INSERT INTO ssg_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Tuahe tea waian lang oh. Konokonoi tea waian latuha he hepekeun ape mau to xai hahamanana sai muhiwa. ");
INSERT INTO ssg_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Teka seilon ti hile aile teik namil ka lato telei hatapo tesol kalabus lehe laha kum pap hani peixux ape kiliwau muna. ");
INSERT INTO ssg_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Tuahe Julius tel masiwi watakai na telei Pol, aile ape i hakongu lato ti teleiai teka kalabus. I hone lawe seilon ka teka laha pap uke, laha titiwa imat hani itax ape pap haniwa peixux. ");
INSERT INTO ssg_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ape i hone teka liai ka laha sakalawa patiu ma na mananai waian papaialaha hani peixux. Ie sale ti ape amite hatesol pap hasunga. ");
INSERT INTO ssg_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ti amite meiwa peixux ien, amite upia tunahi ka texux xux ien axan Malta. ");
INSERT INTO ssg_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Teka seilon ti ien pate laha aile aluini amite. Akah hutui ux ma tin waiwain. Laha hawia tehot ah ape ilowi amite hatesol ti hahiai tinumite. ");
INSERT INTO ssg_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol awiti salo ape ti i hana momokoi hani he tehot ah, tok weiko tenen i telei seilon ahutama leili salo nake i ilameni kekean ape i atalahi minan. ");
INSERT INTO ssg_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Teka seilon ti xux ningahi ka tok weiko ien akeak he mini Pol ape laha he kakak alia puki laha, “I liai tel teleiai seilon. Kalak i kuosel ti kawatan ti itax, haeu ti kako tetel ti nam kolongeniai seilon, i hani lioi Pol mat.” ");
INSERT INTO ssg_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Tuahe Pol tohoi tok weiko hani he tehot ah a i tai mange. ");
INSERT INTO ssg_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ape laha to atetengi na tinun hul ma na i put mat. Tuahe ti i kuewa tap tenen waliko lialun sohotuen ape laha sohi namilolaha ka Pol i haeu. ");
INSERT INTO ssg_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Teik hepekeun xohixohin ien, hepekeunai Publius tel masiwi ti Malta. I ilowi amumuke amite hani tonan ape waxi auni amite ti ngain toluhu. ");
INSERT INTO ssg_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Lokon ien tel taman tinun, i tua engeeng. Lul tunahi i hetekie i lamani tian. Pol nahih paxai i ape i hana minan patul tetan kameiai Haeu ti haewian. Ape tinun ewi. ");
INSERT INTO ssg_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Muhin ien laha atoheni teka tinun hani kapi Pol ape i haewia laha. ");
INSERT INTO ssg_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Pate laha auni hasolia amite. Ape tataen ti lehe amite ku salili laha, laha axi amite waliko tenen amite tap. ");
INSERT INTO ssg_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Muhi pangapang toluhu amite ku hani he tea waian ti tehu taon Aleksandria i pet lilihu lokon ti hunan lialun. Axan Dioskuri, i kilami nati Seus sangasang axalalu Kastor ma Poluks, hua haeu ti teka Grik lolotui. ");
INSERT INTO ssg_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Amite tahia hani tehu taon Sirakus leili Sisili ape amite to ien ngain toluhu. ");
INSERT INTO ssg_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ti ien amite lang ahe ape takana hani tehu taon Regium leili texux xux Itali. Ti ngain liai telao aupol ahoma sai haiup ape ti liai telao amite takana hani tehu taon Puteoli. ");
INSERT INTO ssg_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Amite tunahi teka kahikahi Jises ien ape lato ilowi amite to kapi lato puasain tehu. Muhin ien amite lua ulea hani Rom. ");
INSERT INTO ssg_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Tataen teka kahikahi Jises ti Rom hongoa ka amite luluainiwa, lato lua tengeni amite. Tesol, lato apatuini amite tehu taon axan Apius Forum a tesol liai apatuini amite tesol axan Ing Toluhu. Ti Pol ningahiwa lato, leili tian i amuam hawane ape i kak kemulik hani Haeu. ");
INSERT INTO ssg_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ti amite tahia haniwa Rom, laha sowini hani Pol heuta tehu ing mewenae i tuahe tel seilon ti hile petenian. ");
INSERT INTO ssg_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Muhi ngain toluhu ti amite Rom, Pol ilowi teka masiwi ti teka Ju hani tehu apuhain. Ape i kakane lato, “Amuto teka akikik, nga tai aile teik na waliko lialun hani tel na seilon ma nga tai tahi teik na saun ti tesol tamakako ti matahaun. Tuahe ti nga Jerusalem, laha xoti nga ape hana nga hani mini teka Rom ti kalabusiak. ");
INSERT INTO ssg_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Lato hong paxai meng ti suluak. Pahalato oxoxiak nake lato tunahi ka nga tai aile waliko lialun tenen na i pon laha telei nga. ");
INSERT INTO ssg_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Tuahe teka masiwi ti teka Ju watakai teik namil ien. Aile ape tap tewau aweisal ulea mewenae nga kamei ka Sisa hong paxaiai kakain ti suluak. Kumahe pahak suluiai teka akikik Ju, pahak nga kak xengei kakai teka suluak. ");
INSERT INTO ssg_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Aile ape nga ilowima amuto ti kakak kapimuto. Ti nake monomon ti kako teka Israel hani Krais tetel Haeu taloma, laha xioti kalabusi nga sen.” ");
INSERT INTO ssg_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ape lato kak pahoi ukek, “Amite tai uke teik na pas ti Judia hahongoamite sale huam ma tin tap tel ti teka kahikahi Jises tahiawen ie ape kaxiwen ka o ailele waliko tenen lialun. ");
INSERT INTO ssg_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Amite tioi ka seilon tesol tesol laha kak halialu teka seilon laha usiusi aweisali Krais tuahe pahamite amite hong hawane namilom.” ");
INSERT INTO ssg_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Lato kilami ngain tehu ape lato kilan nahih kakak kapi Pol tesol i heheuta. Ti letu haniwa ipong i kaxi hani lato sale nenein ti Haeu. I hapuasa kakai Moses ma kakain ti teka kuluiai kakai Haeu taiwen ape i kaxi hawane hani lato ka Jises se tel Krais Haeu taloma. ");
INSERT INTO ssg_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Teka laha hong soh kakai Pol tuahe teka liai laha kum soh. ");
INSERT INTO ssg_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ape lato kak he hapatapat alia puki lato. Imat ti lato nahih salili tesol ien, Pol kak ukek, “Pate salan wanen waliko ti Holi Spirit kakanewen Aisaia tel kuluiai kakai Haeu ti kaxi haniai tesol tamakako ti matahaun. I kak ukek, ");
INSERT INTO ssg_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“‘Nahiwa ape honewa teka Israel, “Amuto hongohong kakaiak tuahe amuto kum hong tioi, amuto papaxai waliko ti nga ailele tuahe amuto kum xeu.” ");
INSERT INTO ssg_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Honewa laha kewak ien nake patulaha pate ailan, taxingalaha kilakilan ma pulalaha masin pulaxa. Kaie ala laha ningahiwen ma hong xewawen ma tin towiahuen ti lialui woulaha ape nga aile haewiawen laha.’” ");
INSERT INTO ssg_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ape Pol tili kakaian ukek, “Aisaia kakak tesol tamakako ti matahaun tuahe kilan teka Ju ti aope ie, lato kum soh meng solian ti Jises. Amuto tioi kewak, tenen meng solian ti Haeu ka Jises awai seilon ti kawatan ti lialui woulaha tin i hani teka kumahe Ju. Ape laha hong soh.” ");
INSERT INTO ssg_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Ti i kak kewa, teka Ju nahih salili i ape lato kak he hapatapat alia puki lato. ");
INSERT INTO ssg_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Ahang huohu Pol eng kakahui tehu ing i heheuta. Pate i amuam na seilon nahih paxai i. ");
INSERT INTO ssg_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","I angiamatake kaxiai sale nenein ti Haeu ma sale puase tel Masiwi Jises Krais. Tap tel kongini uke i. ");
INSERT INTO ssg_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nga Pol tel unaui Jises Krais. Haeu kilami nga aposel. I talaheni nga hani kaxi ahutiai meng solian ti Jises Krais ti i ahuma tetan. ");
INSERT INTO ssg_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ti kuewen wanen teka kuluiai kakai Haeu kak kilamiwen tenen meng ien he teik pepaun. ");
INSERT INTO ssg_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Tenen meng solian ien i kakak tel Nati Haeu. Ti i sohot seilon hanowi kaha, i nakuama ti tel masiwi David. ");
INSERT INTO ssg_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","I seilon sawisawin tapein. Ti lalape kui poh, Haeu hamoiha i ti matean ape i kola hawane ka i se Natun. I Jises Krais tetel Masiwi ti kako. ");
INSERT INTO ssg_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ti lalape soliaian i kilami nga aposel nake pahan kilan seilon haxawai axan. Haeu talo nga hani teka kumahe Ju lehe laha hong soh meng solian ti Jises Krais ma usi nauna tetan. ");
INSERT INTO ssg_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ape tin Haeu kilamiwen amuto hani kahikahi Jises Krais. ");
INSERT INTO ssg_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Aile ape nga tai hani amuto hatesol teka Rom ti Haeu waheni, teteka i kilami seilon tetan ape amuto hani hahatapo i tupuamuto. Nga kamei Haeu tel Tamakako ma tel Masiwi Jises Krais kolai lalape soliaialalu ma hatona hasoliai tiamuto. ");
INSERT INTO ssg_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Hutuiai kakaiak nga kak kemulik hani Haeu tel Masiwi ti kako ti lawe waliko Jises Krais aile haniwen amuto. Nga kak kemulik nake ti tesol tesol seilon kakaxi sale xoxoi namilomuto ti Jises Krais. ");
INSERT INTO ssg_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Haeu, tetel nga hani hahatapo i tupuak kaxiai meng solian ti tel Natun, i tioi ka nga nameni kakapitini amuto. ");
INSERT INTO ssg_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Tapai na nga lotu, nga lotu huhuali amuto. Aope ie nga kamei Haeu na ape i nati hei hanimu nga tewau aweisal ti lua hani kapimuto na masin pahan. ");
INSERT INTO ssg_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Pahak wanen nga paxaimu amuto ti hualiamuto lehe amuto kui ahe ti pohe Holi Spirit. ");
INSERT INTO ssg_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Salangawe namilok masin lehe xoxoi namilokako ti Haeu i hakui ati kako. ");
INSERT INTO ssg_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Teka akikik ti Krais, pahak amuto tioi kewak, nga tohongi hakilawen lehe nga lua paxai amuto tuahe hina waliko lawe i kongini nga hanima tataen. Sohotuak hani kapimuto lehe pupuasak wasolamuto i kau anan masin ti i sohotuen leili teka kumahe Ju liai ti nga kapi laha. ");
INSERT INTO ssg_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Tinuk ilameni ka se ape pupuasak wanen kaxiai meng solian ti Jises Krais hani hatesol seilon, teka Grik ma teka kumahe Grik, teka seilon aneso ma teka tap titioalaha. ");
INSERT INTO ssg_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Aile ape namilok xoxoan wanen ka meng solian ien tin nga kaxi hetekie hani amuto teka toto Rom. ");
INSERT INTO ssg_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","I kum hahiena nga kaxiai meng solian ti Jises Krais nake taen seilon hong soh, ti kui pohe Haeu i awai laha hatesol ti kawatan ti lialui woulaha. I awaimu teka Ju nake laha hongoi imat ape imuh teka kumahe Ju. ");
INSERT INTO ssg_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Se tenen meng solian ien i nexi kola aweisal ti hasawiai wasolakaha hani Haeu. Tap tewau aweisal tutuen, mewenae na kaha hana hatapo xoxoi namilokaha hani Jises Krais kaha sohot seilon sawisawin ti puli Haeu. Masin ti tel kuluiai kakai Haeu tai kueiniwen, i ukek, “Teka seilon sawisawin, xoxoi namilolaha ti Haeu neneini laha ape laha to lian tehue kapin.” ");
INSERT INTO ssg_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Haeu tel Masiwi tapein kola ka i lengeini teka seilon laha kum nam waxi i ma teka laha aile hahakila saun tenen pate lialun ape i kahui aliake hani laha. Ti lialui woulaha i tipahi muneni waliko tenen salan sale Haeu ti ala teka seilon tioi. ");
INSERT INTO ssg_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Tuahe sale Haeu hoi liai xewan nake puki Haeu kola hahatakei hani laha. ");
INSERT INTO ssg_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Salan kaha kum niningahi i tuahe kaha papaxai waliko ti i aile lilian ti i tanomiwa tehu pon ie. I kola hawanewen lalape kui pohen ti tap tahi tapoan. Aile ape ala kaha tioiwa ka i se Haeu wanen. Nake ti tetenen ala tap tel ukek i tap titioan ti Haeu. ");
INSERT INTO ssg_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ape kalak teteka laha kum nam waxi Haeu hina titioalaha tetan, laha kum sameni i ma kum kak kemulik ti lawe waliko i aile. Teka seilon ien tap solian ti namilolaha ape ti takalahui patulaha laha kum paxai tioi waliko tenen lialun ma solian. ");
INSERT INTO ssg_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Laha sokok laha seilon tenen pate aneso tuahe salan tetan namilolaha tap wanen. ");
INSERT INTO ssg_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Laha kum paxai tioi lalape xewai Haeu ma pohen tel tap tahi matean. Laha lotui waxi waliko ti laha tua tanomi hanowi seilon, kalak i aneso mat. Tin laha tanomi manihuh, manixux hetekie tataen loloma lehe waxi laha lotui. ");
INSERT INTO ssg_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Aile ape Haeu hani lioi laha usi isiai pahalaha ti ailei waliko tenen i haloloa leilolaha. Ape laha teheni hahalialu tupualaha nake ti ailei saun lialun ti wawan hehin. ");
INSERT INTO ssg_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ti ala laha soh waliko salan sale Haeu, laha soh non waliko tenen putain. Laha lotui waliko ti tatanomiai Haeu ti ala laha lotui ma sameni non Haeu tetel i tanomi lawe waliko. I se tetel ala kaha seilon haxawa kapitiniwa axan lian tehue. Salan wanen ala masin ien. ");
INSERT INTO ssg_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Nake ti tenen ien Haeu hani lioi laha hongeni isiai pahalaha ti ailei saun tenen pate hienain. Aile ape hehin teka, kumahe laha usiusi saun ti wawan hehin tenen ti i onoteni namili Haeu, laha eng akati non hehin liai. ");
INSERT INTO ssg_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Tin masin hina wawan laha lioi aweisal sawisawin ti wawan hehin ape laha is eliel eng akatiai wawan liai. Ape laha aile saun tenen ti pate hienain alia hani laha tel tel. Ti lialui woulaha ien laha uke hapoponowi kahulaha. ");
INSERT INTO ssg_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Teka seilon laha kum nam waxi Haeu, laha ukek ka tap solian tetan ti tioiai Haeu. Aile ape i hani laha usi lialui namilolaha ti ailei waliko tenen ala i kum alune. ");
INSERT INTO ssg_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Laha xuhai saun lialun tenen tenen ma kumahe sawisawin. Namilolaha xoxoan ti ailei waliko tenen lialun hani seilon liai. Laha watakai na seilon liai xoini laha ma laha tin halepean. Laha seilon ti hatanoi wasol, pulutiai teka liai ma teleiai seilon. Laha misahi ma nam halialu seilon liai. ");
INSERT INTO ssg_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Teka laha kakak tehiti seilon, laha watakai Haeu, laha paxai teheni seilon liai, laha itini laha ma weli hanasanas. Laha aneso hawane namiloiai aweisal ti ailei saun lialun ma tin laha tahi kakain ti tamalaha ma tinalaha. ");
INSERT INTO ssg_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Laha kum hapuasa namilolaha ma kum aile usi kakaialaha. Laha tin tap wawahen ma tatahan leili tialaha. ");
INSERT INTO ssg_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Kalak laha tioi ka ti sawisawiai Haeu i namiloi ukek ka teteka laha aile tenen saun lialun ien, kahulaha mewenae matemate, laha aile tatale tesol waliko ien kasinan ti ape laha hongeni hetekie teteka laha ailele saun tenen lialun ien. ");
INSERT INTO ssg_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Aile ape Haeu kahui aliake lialui woi lawe seilon teteka laha aile saun lialun. Amuto teteka ti na amuto howini halialu woi seilon liai, puki amuto hahani Haeu kahui aliake lialui woumuto nake amuto tin amuto ailele saun lialun. ");
INSERT INTO ssg_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Kako tioi hawane ka paxai kolongenian ti Haeu pate sawisawin wanen. Lawe i kahui hapoponowi kaha ti lialui woukaha. ");
INSERT INTO ssg_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Aile ape amuto teteka na amuto howini halialu woi seilon liai a tin amuto ailele saun lialun, kaie amuto pon saliniai kawatan ti na Haeu hani amuto? ");
INSERT INTO ssg_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Paxaiwa lalape ewiai Haeu i kola hahani amuto. I kum sasaxoh kahuiamuto ti lialui woumuto, lawe i tani waxi kapitini amuto. Nakon pate amuto kum paxai tioi ka soliai Haeu ien i nexi hani amuto aweisal ti na amuto towiahu ti saun lialun ti amuto? ");
INSERT INTO ssg_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Tuahe tap amuto nam waxi. Ailai patumuto halenge aheheke Haeu hani tataen ti hinitiai lawe seilon ti i axi kawatan hani teka ailei saun lialun, usiwa sawisawiai paxai kolongenian tetan. ");
INSERT INTO ssg_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Taen ien Haeu kahui hapoponowi hawane kaha ti lawe waliko kaha ailewen. ");
INSERT INTO ssg_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Seilon teka, laha kum lioi wanen ailei waliko tenen solian. Ien i kola ka tuah wanen ti laha na Haeu sameni amuke laha ma hani laha hanawain ti tap tahi tapoan. Seilon teteka ien, Haeu hani laha to kapin lian tehue. ");
INSERT INTO ssg_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","A seilon teka, laha namiloi wawaxi mewenae laha. Laha kum usi waliko tenen salan, laha usi waliko tenen ti i pahoxai namili Haeu. Seilon teteka ien, ti lengei Haeu i axi hawane laha kawatan. ");
INSERT INTO ssg_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Teteka laha aile kakapitini waliko lialun, laha kau moloan lalap ma tialaha i kawat hawane. I sohot hanimu teka Ju ape tin hetekie hani teka kumahe Ju. ");
INSERT INTO ssg_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","A teteka laha aile kakapitini waliko solian, Haeu sameni amuke laha ma i hatona hasolia tialaha. I aile non hanimu teka Ju ape tin hetekie hani teka kumahe Ju. ");
INSERT INTO ssg_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ati laha uke hapoponowi kahulaha nake Haeu kum paxai nenexi seilon. ");
INSERT INTO ssg_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Kalak teka kumahe Ju laha kumahe hahitake tesol nauna ti Haeu hahaniai Moses, laha lialu tamus na laha to aile tatale saun lialun. Ape teka laha hoi hahitake tesol nauna ien, na laha to aile tatale saun lialun, Haeu kahui aliake hani laha usiwa titioalaha ti tesol nauna ien. ");
INSERT INTO ssg_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Se sawisawin na laha uke kawatan nake kumahe ka tuahe ti hongoi tesol nauna ien Haeu paxai ukek laha seilon sawisawin, mewenae na laha aile usi waliko ti tesol nauna ien kakak. ");
INSERT INTO ssg_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Teka kumahe Ju, kalak tap titioalaha ti tesol nauna Haeu hahaniai Moses, laha pon aile usiai waliko ti tesol nauna ien kakak. Puki laha ilameni tioi waliko tenen ewi ma na lialun. Aile ape i pon na nanahialaha i pahowi hani tesol nauna ien kalak laha tai hong ti taxingalaha. ");
INSERT INTO ssg_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Saun ti laha kola ka waliko ti tesol nauna hahanau hoi liai leilolaha. Puki namilolaha tin i kola ukek ien. Hina i tieni laha, hina i namiloi amuke laha. ");
INSERT INTO ssg_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Taun ti hinitiai lawe seilon, Haeu hani Jises Krais paxai kolongeniai woulaha kalak tataen waliko ti laha aile mumuneni. Ti nga kakaxi meng solian ti Jises Krais se nga kakak tesol waliko ie. ");
INSERT INTO ssg_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Amuto teteka Ju amuto amasake hawane ka amuto se akiki Ju ma tin seilon ti Haeu kilamiwen tetan, amuto hana hahatapo xoxoi namilomuto hani nauna ti Moses. Amuto sokok ka usiai tesol nauna ien i hasawi wasolamuto kapi Haeu. ");
INSERT INTO ssg_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Se amuto tioi waliko tetenen Haeu pahan amuto ailewa. Amuto paxai tioi waliko tenen sawisawin tapein nake laha hanauen amuto nauna ti Moses. ");
INSERT INTO ssg_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Amuto soh hawane ka amuto pon neiniai teka kumahe Ju hani Haeu masin na tel seilon neini tel pulaxa. Amuto ukek amuto pon kola haxewai Haeu hani seilon masin xewan i haxewa seilon he tilokoan. ");
INSERT INTO ssg_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Namilomuto pate i eliliel ka amuto pon nau hasawiai teka tap titioalaha ma hanaui teteka laha masin akaik kokol laha kum tioi Haeu nake amuto tioi hatapoen nauna ti Moses ti hina anesoin ma waliko salan. ");
INSERT INTO ssg_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Amuto hahanau seilon liai usiai nauna ien. Alahan amuto kum hanau aliakemu amuto? Amuto hohone seilon ka kum xuuxuina tuahe puki alia amuto hina amuto xuxuina. ");
INSERT INTO ssg_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Amuto ukek kum ailele saun lialun ti wawan hehin a puki alia amuto ailele. Amuto watakai hawane seilon lotui waliko tenen kumahe Haeu a hina amuto aile waliko tenen i teheni halialu tetel i salan Haeu. ");
INSERT INTO ssg_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Pate amuto hanasanasake nauna ti Moses tuahe amuto kola tapoi lomuto hani Haeu ti amuto xaputi nauna ien. ");
INSERT INTO ssg_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Aile ape ala kako kum tataxini ti pepai Haeu kak ukek, “Teka kumahe Ju laha kak saxuti Haeu nake ti woi teka Ju.” ");
INSERT INTO ssg_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Amuto teka Ju amuto kewen teik kikilam ti kotiai uli walikoumuto ti kolakol ka amuto seilon ti Haeu. Tuahe teik kikilam ien i tuah mewenae na amuto usi nauna ti Haeu hani Moses. Na amuto tahi tesol nauna ien, kikilam ti amuto tap pupuasan ape amuto masin seilon ti laha kum tioi Haeu. ");
INSERT INTO ssg_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ape teka kumahe Ju laha tap kikilam tenen ien, Haeu paxai ukek laha seilon tetan na laha aile usi waliko ti nauna tetan kakak. ");
INSERT INTO ssg_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Na masin teka tap teik kikilam ien laha aile usiusi nauna ti Haeu hani Moses, i kola ka sawisawin wanen na Haeu axi kawatan hani teka Ju laha xaputi tesol nauna ien kalak laha kewen teik kikilam ien ma nauna ti Haeu tataiai Moses toi laha. ");
INSERT INTO ssg_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kumahe teka laha tua aile usiusi saun ti teka Ju laha ape seilon ti Haeu. Tin masin kikilam ti laha kewen ti kolakol ka laha seilon ti Haeu, i kum aile Haeu paxai ukek laha seilon tetan wanen. ");
INSERT INTO ssg_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Seilon ti Haeu wanen se teteka laha hani Haeu hauni leilolaha. Ukei kikilam ti uli walikoi seilon ma tuahe usiai nauna ti Moses, i kum towiahu hasolia seilon. Mewenae na kaha hani Holi Spirit kapitiakaha i aile kaha sohot seilon haun. Na masin ien, kalak seilon kum sameni kaha, Haeu tetel sameniakaha. ");
INSERT INTO ssg_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Uke hina ti amuto laha kamea, lahe aweisal lehe kako teka Ju xoini teka kumahe Ju? Ewian la tel Ju uke ti teik kikilam ti kotiai uli walikoun? ");
INSERT INTO ssg_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Kilan solian tetan na tel seilon i nakuama ti teka Ju. Solian tenen ti pate tuah ie. Se kako teka Ju Haeu hanimu kakaian lehe kako usi ma kaxi sawateni. ");
INSERT INTO ssg_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Salan hina teka laha xaputi namil ti Haeu xinotiwen kapi laha. Tuahe kalak na masin ien, nakon Haeu kum hamalumini tewaok tetan? ");
INSERT INTO ssg_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Nga kum ukek! Kalak na tap wanen seilon aile usi waliko ti i kakawen, Haeu lawe i aile usi hawane waliko ti i kakawen. Masin ti leili pepai Haeu tel masiwi David ukek, ti i kaakane Haeu, “Lawe seilon paxai tioiwa ka kakaiam mewenae salan. Na tel seilon ukek paxai kolongenian tetam kumahe sawisawin, i kum pon waxainiai suluam nake lawe o kola ka o mewenae sawisawin.” ");
INSERT INTO ssg_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Uke teka ti amuto namiloi ukek, na masin lialui woukako i kola hawane ka Haeu se pate sawisawin, kaie i poponowi na i kahui kako ti lialui woukako? Nga tua kak hahanowi paxapaxa ti seilon. ");
INSERT INTO ssg_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kum nanamiloi ukek ien. Na masin kumahe sawisawin ti Haeu kahui kako ti lialui woukako, ala kumahe i poponowi ti i axi kawatan hani tuahe na seilon ti tehu pon ie. ");
INSERT INTO ssg_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Teka ti amuto uke laha kak pahoi nga ukek, na masin putai xoxoi namil ti usiai aweisali Haeu i kola hawane soliai sawisawiaian ma i aile seilon haxawa hawane axan, kum pon ti na i tieni kaha ti saun lialun. ");
INSERT INTO ssg_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Hina seilon laha kak putini ka amite tesol aposel hahanau ka ewi na seilon aile saun lialun lehe teka liai paxai tioi soliai Haeu. Seilon teka ien, Haeu hani hapoponowi hawane laha kawatan. ");
INSERT INTO ssg_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Kaie kako namiloi ukek ia? Nakon kako teka Ju pamu ewian ti teka liai? Tap wanen! Amite kolawen ka lawe seilon, teka Ju ma teka kumahe Ju, kaha hatesol aile saun lialun. ");
INSERT INTO ssg_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Masin ti leili pepai Haeu i ukek, “Tap tel seilon sawisawin ti puli Haeu. Tap tel na seilon i kum aile saun lialun. Tap wanen. ");
INSERT INTO ssg_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Tap tel i xeu hawane aweisali Haeu, tap tel i hitoloke hawane Haeu. ");
INSERT INTO ssg_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Hatesol seilon talewen tehitolaha hani Haeu, laha hatesol talesawen. Tap tel i aile waliko tenen i hasolia seilon. Tap tuahe na tel.” ");
INSERT INTO ssg_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Awalaha mewenae kohan. Laha seilon ti weli pipis. Kakaialaha sisiaian wauni puliweu.” ");
INSERT INTO ssg_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Laha weli kak sai halialui seilon hetekie wawatak.” ");
INSERT INTO ssg_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Lawe laha is eliel hawane ti halialui ma teleiai seilon. ");
INSERT INTO ssg_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Tesol tesol na laha tahiawa laha aile hakila waliko tenen kohan ma hakawata tiai seilon. ");
INSERT INTO ssg_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Teka seilon ien tap wanen namil ti hasoliai wasole seilon.” ");
INSERT INTO ssg_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Tap wanen lolaha hani Haeu.” ");
INSERT INTO ssg_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Taen ie ala amuto paxai tioi ka tap tel i sawisawin ti puli Haeu, kasinan kako teka Ju nake Moses haniwen kako nauna ti Haeu ti usian. Aile ape kaha hatesol, teka Ju hetekie lawe seilon ti tehu pon ie kaha kum pon awaiakaha ti na Haeu tieni kaha ti saun lialun. ");
INSERT INTO ssg_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ti tenen ien kako paxai tioiwa ka Haeu kum ukek kaha seilon sawisawin ti usiai nauna tetan ti hahaniai Moses. Nauna ien i kola haxewa ka kaha hina saun lialun. ");
INSERT INTO ssg_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Aope ie Haeu kola haniwen kaha aweisal ti hasawiai wasolakaha hani kapin, aweisal liai tenen ti usiai nauna ti hahaniai Moses. Puki Moses ma teka kuluiai kakai Haeu lato taiwen leili pepai Haeu sale tenen ien. ");
INSERT INTO ssg_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Haeu namiloi ukek wasole seilon hani kapin i sawi na namilokaha xoxoan ti Jises Krais. Haeu hei tewau aweisal ien hani hatesol teka laha soh ti Jises Krais, teka Ju ma teka kumahe Ju. I kum nam nenexi na tel. ");
INSERT INTO ssg_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Se lawe seilon aile saun lialun. Nanahiakaha hatesol pate i tae haxawai axe Haeu. ");
INSERT INTO ssg_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ti lalape soliai Haeu i aile wasolakaha hani kapin i sawi, kumahe ti soliai pupuasakaha. I aile ukek ti Jises Krais mat kahuiai saun lialun ti kaha. ");
INSERT INTO ssg_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Haeu talo Jises Krais mat ukei kawatan ti lialui woukaha lehe ape i hatapo lengean. Kaha kum uke kawatan ti saun lialun na kaha soh hawane ka Jises mat ti ukei totonakaha. Haeu aile ukek ien lehe waxi i kola ka waliko ti i ailele se sawisawin. Imat ti tahiai Krais, i kum kahui aliake lialui woi teka seilon, i tani waxi kapitini laha. ");
INSERT INTO ssg_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Aope ie saun lialun ti kaha ape kahuian. I kola hawane ka waliko ti Haeu aile se pate sawisawin. I kola ka puki i se pate sawisawin ma i aile kaha teka hina namil xoxoan ti Jises Krais wasolakaha kapin i sawi. ");
INSERT INTO ssg_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nameniwa, kumahe ka ti usiai nauna ti Moses i hasawi wasolakaha hani kapi Haeu. Aile ape i kum pon wanen kaha sameni aliake kaha. Ti xoxoi namilokaha hani Jises Krais i aile wasolakaha kapi Haeu i soli. ");
INSERT INTO ssg_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ape amuto papaxai? Mewenae ti xoxoi namilokaha hani Jises Krais wasolakaha hani kapi Haeu i sawi, kumahe ti ailei waliko ti nauna ti Moses hahanau nake seilon kum pon usi hawanean. ");
INSERT INTO ssg_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Namiloi paxaiwa. Nakon Haeu se mewenae Masiwi ti teka Ju? Kumahe, tin hetekie teka kumahe Ju. ");
INSERT INTO ssg_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Pate amuto tioi ka Haeu se telawe ape tin aweisal tewawawe ti hasawiai wasolakaha hani kapin. Aile ape mewenae ti xoxoi namil ti Jises Krais wasolakaha hani kapi Haeu i sawi, kako teka hina kikilam ti kotiai uli walikoukako ma teka kumahe Ju laha tap kikilam tenen ien. ");
INSERT INTO ssg_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Uke amuto namiloi ukek ka ape tap pupuase nauna ti Moses nake kaha hina namil xoxoan ti Jises Krais. Kumahe wanen masin ien. Xoxoi namilokaha ti Jises Krais i kola ka nauna ti Moses hina tupunan. ");
INSERT INTO ssg_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Namiloi paxaiwa Abraham tel tamakako teka Ju ti matahaun. Ti lahe aweisal wasolan hani kapi Haeu i sawi? ");
INSERT INTO ssg_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Na masin i sawi ti soliai pupuasan, ala i pon sameni aliakean hani seilon. Tuahe tap salangawan na i sameni aliake i hani Haeu. ");
INSERT INTO ssg_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ala amuto tioi waliko ti leili pepai Haeu i ukek, “Abraham soh hawane Haeu ape ti xoxoi namilon ien Haeu paxai ukek ka i tel seilon sawisawin.” ");
INSERT INTO ssg_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Nga kaxi haxewa aheke ukek. Tel na i puas hahitake seilon liai, i uke kahun ti tenen puasain i aile. I kum namiloi ukek tuahe ti soliai tel kahuian i tua axi i moni. Ien se liai kahi puasain. ");
INSERT INTO ssg_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Tuahe soliai wasolakaha hani kapi Haeu kumahe ka kahi pupuasakaha. Ien se ani xoxoi namilokaha ti Jises Krais. Kaha soh ka Haeu i pon aile teka seilon laha xauxaun tetan, wasolalaha hani kapin i sawi. ");
INSERT INTO ssg_vpl VALUES ("RM4_6","075_4_6