﻿USE sofia;
DROP TABLE IF EXISTS sofia.ssd_vpl;
CREATE TABLE ssd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ssd_vpl WRITE;
INSERT INTO ssd_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tugu mbolŋge Kuate nu samba kilke kile-mayokkina. ");
INSERT INTO ssd_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nu kilke te-mayokna ta kilke ake baknu minna. Kule suŋgo kilke ŋakmba soŋga minna le ma make suŋgoŋge kule ta kaimba minmba minna le Kuate tuku Guwa kule ta mbolŋge kine promba minna. ");
INSERT INTO ssd_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kile Kuate nu sakina: Ma purfewa ŋgina le ma purfena. ");
INSERT INTO ssd_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ma purfena le Kuate nu kaŋgermba garena. Taŋamba nu ait armba yimyam patike likina ta ande ma purfeŋ tuku ande ma make tuku. ");
INSERT INTO ssd_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Taŋana sulumba ma purfeŋ ta mafe ŋgina sulumba ma make ta furir ŋgina. Taŋakina le furir promba kumba ka maratukuk ta ait ndindo. ");
INSERT INTO ssd_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kile Kuate nu sakina: Kule purkuwa sulumba ande mbol ambeŋge ka minwa le ande ibeŋŋge minwa. Ma baknu ŋgamu taŋge kule ar ta tukulnikam tuku minamŋgat ŋgina. Taŋakina ta kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kuate nu ma baknu taŋge te-mayokmba kule ar ta ande mbolŋge ande ibeŋŋge patikina. ");
INSERT INTO ssd_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Patikina sulumba ma baknu ta samba ŋgina. Taŋakina le furir promba kumba ka maratukuk ta ait arnu. ");
INSERT INTO ssd_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kile Kuate nu sakina: Kule suŋgo ibeŋŋge minit ta ka ma ndindo mbolŋge ulendikuwa le kilke pagranu prowaig ŋgina. Taŋakina ta kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kilke pagranu pronaig ta kilke ŋgina sulumba kule suŋgo ulendikina ta yu ŋgina. Taŋakina sulumba kaŋgerka nu garena. ");
INSERT INTO ssd_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kile Kuate nu sakina: Kilke mbol taŋge agaŋ waŋe ŋak prowaig. Aŋga yeki yeki silonu ŋak, ilinzu yeki yeki tumunu ŋak, kumzaŋ ail tiŋnu tumunu ŋak yeki yeki ŋakmba prowaig ŋgina. Taŋakina ta kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Aŋga yeki yeki silonu ŋak, ilinzu yeki yeki tumunu ŋak, ail yeki yeki tiŋnu ŋak ta ŋakmba kilke mbolŋge fare prowe likinaig le Kuate nu kaŋgerka garena. ");
INSERT INTO ssd_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Taŋana le furir promba kumba ka maratukuk ta ait keŋnu. ");
INSERT INTO ssd_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Kile Kuate nu sakina: Agaŋ bulu ŋak samba mbolŋge mayok kuwaig le buluŋga kilke tugu kilŋawam tuku mafeŋ furir walam tuku mine likuwaig. Ait ŋakmba ki tuku ait, sawe tuku ait, mara tuku ait, piro tugu tuku ait ta ŋakmba tumniŋgam tuku minwaig ŋgina. Taŋakina ta kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kuate nu bulu sugo armba kile-mayokkina ta ande suŋgo ta mafeŋ kulatkam tuku ande fudiŋ ta furir kulatkam tuku kile-mayokka mbai turmba kile-mayokkina. ");
INSERT INTO ssd_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Nu bulu kame ta samba mbol taŋge kilke tugu kilŋawam tuku mafeŋ furir walmba kulatkam tuku patike likina. Taŋana sulumba kaŋgerka nu garena le ");
INSERT INTO ssd_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","furir promba kumba ka maratukuk ta ait bailkanu. ");
INSERT INTO ssd_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kile Kuate nu sakina: Kule sinamŋge agaŋ abo minam tuku kuasmbi ŋak mayok ke likuwaig. Sar umaŋ mata mayok ke lika samba kumnemŋge buŋga likuwaig ŋgina. Taŋakina ta kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nu kualegaŋ sugo agaŋ abo minam tuku yeki yeki kule sinamŋge likade ta ŋakmba kile-mayokka sar umaŋ yeki yeki ŋakmba turmba kile-mayokkina. Taŋamba nu kaŋgerka garena sulumba ");
INSERT INTO ssd_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","nyaro niŋmba saniŋgina: Tane tugekap sulumba kule sina yu sina ŋakmba kumuŋgap. Sar umaŋ mata kilke mbolŋge tugekap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Taŋakina le furir promba kumba ka maratukuk ta ait wai inum sulumba. ");
INSERT INTO ssd_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kile Kuate nu sakina: Kilke mbolŋge agaŋ abo minam tuku yeki yeki mayok kuwaig. Agaŋmor tumbraŋok duŋekok agaŋ yeki yeki rabmba likam tuku ta ŋakmba mayok kuwaig ŋgina. Taŋakina ta kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nu agaŋmor tumbraŋok ŋguikok agaŋ yeki yeki rabmba likade ta ŋakmba kile-mayokkina sulumba kaŋgerka garena. ");
INSERT INTO ssd_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Taŋana sulumba Kuate nu maŋ lato sakina: Kile sine taŋgo kile-mayokkube le siŋgine suk minwaig. Nane kilke tugu ŋakmba agaŋ ndende ŋakmba kulatka gabat minwaig. Kualegaŋ, sar umaŋ, kilke mbolok agaŋmor agaŋ yeki yeki kilke mbolŋge rabmba likade ta ŋakmba tuku gabat minwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Taŋakina sulumba Kuate nu taŋgo nuŋe suk kile-mayokkina. Nu taŋgo pino turmba kile-mayokkina. ");
INSERT INTO ssd_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kile-mayokkina sulumba nyaro nikmba sanikina: Tale kiŋo kame kile-patikap le tugeka kilke tugu ŋakmba kumuŋguwaig. Tane kilke tugu ta ŋakmba kilap sulumba kulatkap. Kualegaŋ, sar umaŋ, agaŋmor ŋguikok ta mata ŋakmba kulatke likap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Taŋakina sulumba nu maŋ sanikina: Tale kaŋgerap. Nyamagaŋ ŋakmba kilke mbolŋge prode ta ye tane tiŋget. Ilinzu tumunu ŋak ail tiŋnu tumunu ŋak ta ŋakmba tane tuku nyamagaŋ minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Agaŋ ŋakmba nzu ŋak ŋak ta ye agaŋmor nyuwaig ŋga nane niŋgen tuku. Agaŋ nzu ŋak ŋak ta sar umaŋ kilke mbolok agaŋmor nane tuku nyamagaŋ minamŋgaig ŋgina. Taŋakina ta kumuŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kuate nu agaŋ ndende ŋakmba kile-mayokkina ta kaŋgerka ŋakmba magenu ndo minnaig le nu ndek gare torna. Taŋana le furir promba kumba ka maratukuk ta ait wai inum sulumba wai ŋgiri ndindo. ");
INSERT INTO ssd_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kile kilke samba agaŋ ndende ŋakmba kumuŋge likinaig le piro ŋakmba kugana. ");
INSERT INTO ssd_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ait 7-nu mbolŋge Kuate nu piro ŋakmba ke likina ta piroke suglukina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","mabtina. Ta tuku nu ait ta tukulmba kusem pilna. ");
INSERT INTO ssd_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Kuate Suŋgo nu taŋamba samba kilke kile-mayokkina tuku. ");
INSERT INTO ssd_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Kuate Suŋgo nu samba kilke kile-mayokkina ta nu sawe te-ibeŋ ndana tukunu agaŋ waŋe ŋak mine ndakinaig. Agaŋ kitek mata mbur ndanaig. Taŋgo ande kilke mbolŋge tumtuwam tuku mata mine ndakina. ");
INSERT INTO ssd_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ait ta mbolŋge kule nu kilke sinamŋge nzomba minna le kilke nu bisuknu minna. ");
INSERT INTO ssd_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kuate Suŋgo nu taŋgo wakeiyam tuku ŋga kilke tumba tambi taŋgo wakeina. Wakeina sulumba taŋgo ta fumbenu mbolŋge abo guwa Ŋtna le taŋgo ta abo guwa ŋak aboŋga tiŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Tiŋgina le Kuate Suŋgo nu Eden kumamŋge ki prote kumam taŋge piro ande wakeina. Wakeina sulumba taŋgo buk wakeina ta tumba piro ta sinamŋge pilna le minna. ");
INSERT INTO ssd_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Piro ta sinamŋge Kuate Suŋgo nu ail magenu yeki yeki kile-mayokkina. Ail ta ŋakmba kaŋgerka nzali tumba alowaig le nyam tuku. Piro ta ŋgamukŋge nu ail armba turmba patikina le pronaik ta ande alonu nyumba minmba minam tuku ail ande maŋau magenu ŋaigonu pileŋga kila palmbim tuku ail. ");
INSERT INTO ssd_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Eden kilke mbolŋge kule suŋgo ande bulbulmba prona sulumba piro ta bisumba minna. Nu Eden kusremba mayok ka wai fet bailkana. ");
INSERT INTO ssd_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Wainu suŋgo ande nyunu Pison ta kinit kumba ka Awila kilke laipmba kinit. ");
INSERT INTO ssd_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Awila kilke ta gol, ail ŋair mundur mayenu, ndame magenu ŋak minit). ");
INSERT INTO ssd_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Wainu ande nyunu Gion ta Kus kilke laipmba kinit. ");
INSERT INTO ssd_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Wainu ande nyunu Tigris ta Asiria kilke ki prote kumam tambi kinit. Wainu ande ta nyunu Yufretis. ");
INSERT INTO ssd_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Kuate Suŋgo nu taŋgo ta tumba Eden piro ta mbolŋge piroka kulatka minam tuku pilna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","wam pagumba sana: Ail ŋakmba piro te sinamŋge minig ta alonu ne nyam kumuŋ. ");
INSERT INTO ssd_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ail ndindo ndo ye ne peunumba tukulnet. Ail ta maŋau magenu ŋaigonu pileŋga kila palmbim tuku. Ne ail ta tuku alonu ndanya. Mbula. Ne nyumba ta ait ta mbolŋge ndo ne kumamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Taŋakina sulumba Kuate Suŋgo nu sakina: Taŋgo te nuŋe ndo minit. Maŋau ta mayenu kuga tukunu ye tur nuŋe ande nu suk wakeiyamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Taŋamba sakina sulumba nu kilke tumba sar umaŋ agaŋmor ŋakmba wakeika nuŋge nyu patikuwa ŋga kilmba taŋgo ta tugum prona le nu agaŋmor ta ŋakmba nyu yimyam niŋgina le nane nyu ta ŋak minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Nu sar umaŋ agaŋmor tumbraŋok ŋguikok ŋakmba tuku nyu patike likina ta tur nuŋe nu suk ande nda mayok kina le taŋgo ta nu nuŋe ndo minna. ");
INSERT INTO ssd_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kile Kuate Suŋgo nu taŋgo ta ginyum pak tuna le nu kinymba gilaiŋgina le Kuate Suŋgo nu taŋgo ta takelnu ande gona sulumba ndemnu tumba takelnu gona ma mbolŋge tukulmba pilna. ");
INSERT INTO ssd_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Takelnu tambi nu pino ande wakeina sulumba tumba ka taŋgo tugum taŋge pilna le ");
INSERT INTO ssd_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","taŋgo ta nu pino ta kaŋgermba sakina: Ese. Agaŋ te ye tuku isu ye tuku ndem minit teŋen. Nu taŋgo tuku ŋgarosu mbolŋge mayok ket tukunu ye nu nyun ta pino ŋgamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ta tuku taŋgo nu ina mam nuŋe kusreka piyo nuŋe ndoŋ muŋgu kile-deŋga minwaik. Nale ŋgarosu ndindo mayok kaŋgaik. ");
INSERT INTO ssd_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Taŋgo ta piyo nuŋe ndoŋ wagek minnaik ta nale kiko ndanikina. ");
INSERT INTO ssd_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mbeŋ nu yabri paknu ŋak minmba agaŋmor ŋakmba Kuate Suŋgoŋge patike likina ta nane tuku maŋau liniŋmba mbolŋge minna. Taŋamba mbeŋŋge pino kusnana: Kuate nu tale ndaŋmba satikina? Tale piro te tuku kumzaŋ ail alonu ndanyam tuku satikina e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","pino ta nu mbeŋ tuku pasa lafumba sana: Kuga. Sile piro te tuku kumzaŋ ail ŋakmba alonu nyam tuku sasikina. ");
INSERT INTO ssd_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Nu teŋenmba sile sasikina: Tale ail ndindo piro te ŋgamukŋge minit ta ndo alonu kiremba ndanyap. Tale kumpekaik ŋga sasikina ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","mbeŋ ta ndek nu sana: Tale kume nda. ");
INSERT INTO ssd_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Tale nyap sulumba wamdus pulutikuwa le Kuate suk maŋau magenu ŋaigonu pileŋgam tuku kila ŋak minamŋgaik ta Kuate nu kila. Ta tuku nu tale nda nyam tuku satikina ŋga pino sana le ");
INSERT INTO ssd_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","pino ta nu nuŋe wamdusmbi sakina: Ail ta mayenu ndo ŋgina sulumba nu alonu ta kaŋgermba am kikoŋ tiŋga wamdus kuyar mayenu ŋak minam tuku nzalina le nu ail ta alonu ande purmba tumba nyina. Tumba nyina sulumba inum tumba taŋgo nuŋe tuna le nyina. ");
INSERT INTO ssd_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nale nyinaik sulumba wamdus pulunikina le nale wagek minnaik ta katesemba kila pilnaik sulumba kikonikina le fik waŋenu kilmba ŋgika malnu tiŋginaik. ");
INSERT INTO ssd_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Taŋamba minnaik le furiram Kuate Suŋgo nu pro piro ta sinam lika minna le nalekam zigna isnaik sulumba ail sumba kuirkinaik. ");
INSERT INTO ssd_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Taŋanaik le Kuate Suŋgo nu taŋgo ta wika sana: Ne aniŋge minit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","nu ndek sakina: Ye ne tuku zigna ismba wagek minet te kuru-kuruka kuirket ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","nu ndek kusnana: Ne wagek minit ta imaŋge sanat e? Ne ail alonu tale peunikmba tukultiken ta nyat e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","taŋgo ndek lafumba sana: Pino ye ndoŋ minam tuku ye sina nuŋge ail alonu ta tumba sat le nyit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Taŋakina le Kuate Suŋgo nu pino ta kusnana: Ne ndaŋam taŋawat ŋgina le nu lafumba sana: Mbeŋŋge ye yabriyat le nyit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kile Kuate Suŋgo ndek mbeŋ ta sana: Ne maŋau ta kat ta agaŋmor ŋakmba ŋgamukŋge ye ne kasurnumba te-yamoknamŋgit. Ne mara mindek fuŋgulmbi ndo lika kilke kutur nyumba taŋamba minmba ma ma kumamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Tale pino ta ndoŋ tale ŋgamukŋge gubra pili le tale muŋgu ŋgueu ŋak minamŋgaik. Ne tuku kutu pino tuku kutu nane mata taŋamba muŋgu ŋgueu ŋak minamŋgaig. Nu ne tuku gabat to fetkuwa le ne nu tuku kupe tugunu makewamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Taŋakina sulumba nu ndek pino ta sana: Ne kiŋo kile-patinu ait mbolŋge ye ne ŋgaro rar suŋgo tini le tamŋgat ta ne maŋ taŋgo naŋe nzalinamŋgat. Ne nu tuku miŋge kumnemŋge mina le nuŋge ne kulatka minamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Taŋakina sulumba nu ndek Adam sana: Ne piyo naŋe tuku miŋge ismba dubimba ail alonu peutikmba tukultiken ta tumba nyat tukunu ye ne tuku ŋga kilke kasuramŋgit. Ne nyamagaŋ te-silikam tuku piro kareŋka tumba nyamŋgat. Ne mara mindek taŋamba minmba ma ma kumamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kilke te mbolŋge aŋga ŋaigonu prowe likuwaig le ne fare fare ilinzu sota nyumba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ta tuku ne piro kareŋka ŋgarosu mundunuwa le kilke mbolŋge nyamagaŋ te-silika nyamŋgat. Taŋamba minmba ma ma ne luka kilkek sinam kaŋgat. Ye ne kilkembi wakeinen tukunu ne tuku ŋgarosu ta kilke. Ne maŋ luka ta sinam kumba kilke kuilkamŋgat ŋga taŋgo sana. ");
INSERT INTO ssd_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam nu piyo nuŋe nyunu Eva ŋgina. Nyu ta tugunu teŋenmba: Nu taŋgo pino ŋakmba tuku ina naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kuate Suŋgo nu agaŋmor ŋgaronumbi tawi wakeika Adam nale piyo nuŋe ndoŋ tiŋgine nikina. ");
INSERT INTO ssd_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Taŋana sulumba kile Kuate Suŋgo nu sakina: Taŋgo nu maŋau magenu ŋaigonu pileŋgam tuku kila palet tukunu nu sine taŋaŋ minit. Nu minmba minam tuku ail alonu ta turmba nyuwa sulumba minmba minikat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nale taŋapekaik ŋga Kuate Suŋgo nu nale Eden piro ta sinamŋge pitaika kukulnikina le kilke tumba taŋgo wakeina ta mbolŋge piroka minnaik. ");
INSERT INTO ssd_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Taŋamba minnaik le taŋgo nu ail alonu nyumba minmba minam tuku ta tugum kakat ŋga Kuate nu nuŋe eŋel afu kukulniŋgina le Eden piro ki prote kumam taŋge ndin tukulmba ail ta ŋgailkinaig. Kame bagi suŋgo pa bulu ŋak ta turmba taŋge pilna le kuanyi-kuanyiŋga minna. ");
INSERT INTO ssd_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam nu piyo nuŋe Eva ndoŋ minnaik sulumba pino ta buk fuŋgul ŋakna sulumba kiŋo te-pilmba sakina: Suŋgoŋge ye sinzaŋyat le ye kiŋo ande te-pilit ŋgina. Taŋakina sulumba nu kiŋo ta nyunu Kain ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Taŋamba minnaig ma ma nu maŋ kiŋo ande te-pilna ta nyunu Abel ŋgina. Kiŋo ta suŋgoka nu sipsip kulat taŋgo mayok kina le aba nuŋe nu mara mindek nyamagaŋ piroka minanu. ");
INSERT INTO ssd_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Minnaig ma ma mara ande aba nuŋe nu nyamagaŋ afu kilmba Suŋgo atraukam tuku patikina le ");
INSERT INTO ssd_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","maib nuŋe nu sipsip mulum mayenu ande balemba ndemnu kuya ŋak ta tumba nu mata Suŋgo atraukam tuku pilna. Pilna le Suŋgo nu kaŋgermba ndek Abel tuku garena sulumba ");
INSERT INTO ssd_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kain tuku atrau agaŋ ta kaŋgermba Kain tuku gare ndana le Kain nu gubra kagli Ŋrka aiŋel pasi kume ŋgurŋgurkina. ");
INSERT INTO ssd_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Taŋana le Suŋgo nu ndek Kain kusnana: Ne ndaŋam tuku gubranate e? Ndaŋam ne tuku aiŋel pasi kume ŋgurŋgurkate e? ");
INSERT INTO ssd_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ne maŋau mayete kande ye ne tuku gare-gareket kande. Ne maŋau ŋayote tukunu une ta ne kainumba te-ibeŋnuwa ŋga ne kagmate ta ne saŋgri tiŋga une ta te-ibeŋmba te-siwa ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Taŋaka sana le Kain nu maib nuŋe wika sana: Sile piro mbol nzi kap ŋgina. Taŋamba nale kinaik ka piro mbol taŋge Kain nu tiŋga maib nuŋe balena le kumna. ");
INSERT INTO ssd_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Taŋana le Suŋgo nu Kain kusnana: Maib naŋe aniŋge minit ŋgina le nu ndek sana: Iyo. Ye nu kaŋger ndawit. Ndaŋam saka maib yiŋe tuku kusnayate? Ye nu tuku kulat taŋgo kuga ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Suŋgo nu ndek sana: Ne siŋka maŋau ŋayonu kat. Maib naŋe tuku ndare kilke mbolŋge kutuwat ta witite le iset. ");
INSERT INTO ssd_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nu tuku ndare kutuwat ta kilke teŋge ndare ta biyat. Ta tuku ye ne kasurnumba pitaini le ne ma te mbolŋge mine nda. ");
INSERT INTO ssd_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ne kilke mbolŋge nyamagaŋ ŋguka ta alowe nda. Ne mara mindek tumbraŋ tumbraŋ ŋakmba kine promba minamŋgat ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Taŋakina le Kain ndek lafumba Suŋgo sana: Ta tuku lafunu ye pa ta kurawam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ne kilke te mbolŋge ye pitaiya le ye ne ndoŋ mine ndaka kine promba minamŋgit. Taŋgo andeŋge ye ndinŋge kaŋgeryuwa sulumba ye baleyuwa le kumamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Suŋgo nu Kain sana: Kuga. Taŋgo inum ne balenuwa ta ye lafumba nu tuku kuasmbi 7 bale farniŋgamŋgit ŋgina. Taŋakina sulumba Suŋgo nu taŋgo ande Kain kaŋgermba ndabalewa ŋga nu tuku ŋgarosu mbolŋge peuka suku kuyar ande pilna. ");
INSERT INTO ssd_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Taŋana le Kain nu Suŋgo kusremba ka Eden ma ki prote kumamŋge minna. Ma tugu ta nyunu Kine Pro. ");
INSERT INTO ssd_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain piyo nuŋe nu kiŋo ande nyunu Enok te-pilna. Taŋamba minnaig ma ma Kain nu tumbraŋ suŋgo ulmba wande patikina sulumba tumbraŋ ta mata nyunu Enok ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok tuku kiŋo nuŋe nyunu Irad. Irad nu kiŋo ande nyunu Mehuyal te-pilna. Mehuyal nu kiŋo ande nyunu Lamek te-pilna. ");
INSERT INTO ssd_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek nu pino armba kilna ta ande nyunu Ada ande Zila. ");
INSERT INTO ssd_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada nu kiŋo ande nyunu Yabal te-pilna. Yabal nu makau kulatkade kuasmbi ta tuku mbuŋ naŋgine. Nane kinenumba baibai patika minanu. ");
INSERT INTO ssd_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Mambo nuŋe nyunu Yubal nu gita le tabu tabu usrede kuasmbi ta tuku mbuŋ naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila nu kiŋo ande nyunu Tubal-Kain te-pilna. Tubal-Kain nu ain yeki yekimbi piro agaŋ suŋgomba wakeikanu. Zila nu kulim ande turmba te-pilna ta nyunu Nama. ");
INSERT INTO ssd_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Mara ande Lamek nu piyo kat nuŋe sanikina: Ada le Zila tale isap. Kiŋo ande ye katyina le ye nu balewen le kumna. ");
INSERT INTO ssd_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Taŋgo ande Kain balewa ta lafumba taŋgo 7 bale faramŋgaig. Taŋgo ande ye baleyuwa ta lafumba taŋgo 77 bale faramŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam le piyo nuŋe nale maŋ kiŋo ande te-pilnaik sulumba Eva nu sakina: Kain nu Abel balena le kumna. Kile Kuateŋge kiŋo ande ye sat le kiŋo ta Abel tuku ma tamŋgat ŋgina sulumba nu kiŋo ta nyunu Set ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set nu suŋgokina sulumba pino ande tina. Pino ta kiŋo ande nyunu Enos te-pilna. Ait ta mbolŋge taŋgo pino nane Suŋgo tuku nyu te-duŋgam tuku tugu pilnaig. ");
INSERT INTO ssd_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Kuate nu taŋgo pino nuŋe suk kile-mayokkina. Nu taŋgo pino turmba kile-mayokkina sulumba nyaro nikmba nyu ta taŋgo ŋgina. Adam tuku ndare tuturmba teŋenmba kina. ");
INSERT INTO ssd_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","5","Adam nu yar 130 ŋak minna sulumba kiŋo ande nuŋe suk te-pilna. Nu kiŋo ta nyunu Set ŋgina. Taŋana sulumba Adam maŋ lato yar 800 minmba kiŋo kulim afu turmba kile-patikina. Nuŋe yar ulendimba 930 kusrena sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","8","Set nu yar 105 ŋak minna sulumba kiŋo ande nyunu Enos te-pilna. Te-pilna sulumba nu maŋ lato yar 807 minmba kiŋo kulim afu turmba kile-patikina. Nuŋe yar ulendimba 912 kusrena sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","11","Enos nu yar 90 ŋak minna sulumba kiŋo ande nyunu Kenan te-pilna. Te-pilna sulumba nu maŋ lato yar 815 minmba kiŋo kulim afu turmba kile-patikina. Nuŋe yar ulendimba 905 kusrena sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","14","Kenan nu yar 70 ŋak minna sulumba kiŋo ande nyunu Mahalalel te-pilna. Te-pilna sulumba nu maŋ lato yar 840 minmba kiŋo kulim afu turmba kile-patikina. Nuŋe yar ulendimba 910 kusrena sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","17","Mahalalel nu yar 65 ŋak minna sulumba kiŋo ande nyunu Yaret te-pilna. Te-pilna sulumba nu maŋ lato yar 830 minmba kiŋo kulim afu turmba kile-patikina. Nuŋe yar ulendimba 895 kusrena sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","20","Yaret nu yar 162 ŋak minna sulumba kiŋo ande nyunu Enok te-pilna. Te-pilna sulumba nu maŋ lato yar 800 minmba kiŋo kulim afu turmba kile-patikina. Nuŋe yar ulendimba 962 kusrena sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","24","Enok nu yar 65 ŋak minna sulumba kiŋo ande nyunu Metusala te-pilna. Te-pilna sulumba nu maŋ lato yar 300 minmba Kuate biye demba minna. Taŋamba nu kiŋo kulim afu turmba kile-patikina. Nuŋe yar ulendimba 365 kusrena sulumba Kuate ndoŋ sail mayena le Kuateŋge nu ŋgarosu ŋak tina. Nu kume ndakina. ");
INSERT INTO ssd_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","27","Metusala nu yar 187 ŋak minna sulumba kiŋo ande nyunu Lamek te-pilna. Te-pilna sulumba nu maŋ lato yar 782 minmba kiŋo kulim afu turmba kile-patikina. Nuŋe yar ulendimba 969 kusrena sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek nu yar 182 ŋak minna sulumba kiŋo ande te-pilmba sakina: ");
INSERT INTO ssd_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Suŋgo nu kilke te kasurna le sine piro kareŋka wamdus pitisiŋgit. Kiŋo te sine tuku wamdus bul sersiŋgamŋgat ŋgina. Taŋakina sulumba kiŋo ta nyunu Noa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","31","Lamek nu maŋ lato yar 595 minmba kiŋo kulim afu turmba kile-patikina. Nuŋe yar ulendimba 777 kusrena sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa nu yar 500 kusrena sulumba kiŋo keŋmba kile-patikina ta ande nyunu Sem ande Ham ande Yafet. ");
INSERT INTO ssd_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Taŋgo pino tugeka sili-silinaig sulumba kulim kame kile-patike likinaig le ");
INSERT INTO ssd_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Kuate tuku kuasmbi nane kulim kame ta kaŋgerkinaig. Kulim kame ta ŋgarosu tumail pasi magenu ndo le nzaliniŋgina le nane ndoŋ minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Taŋanaig le Suŋgo nu sakina: Taŋgo nane ŋgarosu ndo. Nane minmba mine nda. Ye nane tuku ait kuerkamŋgit. Nane tuku yar 120 ndo palmbimŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Kuate tuku kuasmbi nane pino kame ndoŋ minnaig sulumba taŋgo sugo saŋgriknu kile-patikinaig. Ait ta mbolŋge ŋgumneŋga mata taŋgo sugo saŋgri ŋak ta kilke te mbolŋge mine likinaig. Nane saŋgri sugo nyu ŋak minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Taŋgo pino ŋakmba nane maŋau ŋaigonu kumba wamdus mata ŋaigonu ndo kumba minanu le Suŋgo nu nane kaŋgerka ");
INSERT INTO ssd_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ŋgamuŋgal rarmba wamdus tatrukina sulumba sakina: Ndaŋam saka ye taŋgo pino kile-mayokka kilke te mbolŋge patiken a. ");
INSERT INTO ssd_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ye kile taŋgo pino ŋakmba sar umaŋ agaŋmor tumbraŋok ŋguikok kilke te mbolŋge ma gureŋmba kile-ŋgisike suluwamŋgit. Ye yiŋe wakeika kile-mayokken ta kile ye wamdus tatrukate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Taŋakina ta Suŋgo nu Noa tuku maŋau kaŋgermba nu ndo nzalina. ");
INSERT INTO ssd_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noa nu taŋgo purfeŋnu mayenu. Nu Kuate ndoŋ sail mayena. Nu tuku kiŋo keŋmba ta Sem Ham Yafet. Noa tuku ait mbolŋge taŋgo pino ŋakmba maŋau ŋaigonu ndo ke lika minnaig ta nane ŋgamukŋge Noa ndo maŋau purfeŋnu dubimba minna. ");
INSERT INTO ssd_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Kilke te mbolŋge Kuate am mbolŋge maŋau ŋaigonu ta tumbraŋ kilke ŋakmba kumuŋgina le naŋgine taŋgo afu ŋaigo siglika minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kuate nu taŋgo pino ta tuku maŋau ŋaigonu kaŋgerka nane tuku uneŋge tumbraŋ ŋakmba ŋaigo siglikina ta nu kaŋgerkina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","nu ndek Noa sana: Ye taŋgo pino ŋakmba pitaike suluwamŋgit. Naŋgine naŋgine taŋgo afu ŋaigo siglikade le nane tuku maŋau ŋaigonu ta kilke tugu ŋakmba kumuŋgade tukunu ye nane ŋakmba kile-ŋgisikamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ta tuku ne ail magenu pikmba waŋ inum wakeimba kusa. Kusmba wandenu pilmba sinanu afu pugurke lika sulumba waŋ ta sinamŋge kilimŋge gulgol daŋga le tikŋguwa. ");
INSERT INTO ssd_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Waŋ ta teŋenmba wakeiya. Kuennu mita 130 wakeiya. Suŋgonu mita 22 wakeiya. Ŋgirpenu arŋeŋ mita 13 wakeika. ");
INSERT INTO ssd_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Taŋamba ne funu tukula sulumba ŋgirpenu mbol ta tukul ndawa. Wai dagol ndindo burok waŋ laipmba pale le waŋ sinanu purfeŋnu minwa. Ŋgirpenu mbolŋge malaŋga wakeimba pale sulumba sinamŋge mbain armba kusa le waŋ sinanu keŋmba minwaig. Ande mbolŋge ande ŋgamuŋge ande ibeŋŋge minwaig. ");
INSERT INTO ssd_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Yeŋge saki le kule suŋgo prowa sulumba taŋgo pino ŋakmba kilke mbol agaŋ ndende ŋakmba soŋguwa le butoka ŋgisike suluwamŋgaig ta ");
INSERT INTO ssd_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ye ne ndoŋ wamdus ulendika siŋka son pasa sanet ta ye siŋka kumuwamŋgit. Ne, piyo naŋe, kiŋo kat naŋe, rugan kat naŋe tane ŋakmba waŋ poŋgap sulumba ");
INSERT INTO ssd_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","agaŋ nyunu mindek abo minig ta mata turmba kilmba waŋ poŋgap. Ar ar pailnu paŋgarnu nane abo minam tuku kilmba patika. ");
INSERT INTO ssd_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Sar umaŋ yeki yeki agaŋmor tumbraŋok ŋguikok ta ŋakmba ar ar kilmba waŋ poŋgap. ");
INSERT INTO ssd_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Taŋgine nyamagaŋ agaŋmor tuku nyamagaŋ yeki yeki turmba kilmba patikap ŋga Noa sana. ");
INSERT INTO ssd_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Taŋakina le Noa nu Kuate tuku miŋge dubimba taŋamba ndo kina. ");
INSERT INTO ssd_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kile Suŋgo nu Noa sana: Ye taŋgo pino ŋakmba kaŋgerket ta nane ŋgamukŋge neŋge ndo maŋau purfeŋnu ŋak minit le ye ne kagmanet. Ta tuku kile ne naŋe gageu turmba waŋ ta poŋgap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Agaŋmor nyam tuku atraukam tuku ta ar ar pailnu 7 paŋgarnu 7 kilmba waŋ mbolŋge patika. Agaŋmor tane pintiŋgen ta armba ndo pailnu paŋgarnu kila. ");
INSERT INTO ssd_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Sar umaŋ ar ar pailnu 7 paŋgarnu 7 kila. Agaŋ ŋakmba tumunu minam tuku kila. ");
INSERT INTO ssd_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kusem ndindo te kugawa le ye saki le sawe suŋgokanu ki 40 furir 40 piymba minamŋgat. Sawe ta mbolŋge ye agaŋ wakeiken le abo minig ta ŋakmba ma gureŋmba kile-ŋgisike suluwamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Suŋgo nu Noa wam paguna ta Noa nu miŋge kumumba taŋamba ndo kina. ");
INSERT INTO ssd_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa nu yar 600 ŋak minna le kule suŋgo ta promba kilke soŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa, kiŋo kat nuŋe, piyo nuŋe, rugan kat nuŋe nane kule prowamŋgat ŋga waŋ poŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Sar umaŋ agaŋmor nyam tuku pinkam tuku ");
INSERT INTO ssd_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ar ar pailnu paŋgarnu nane Kuate nu Noa wam paguna ta kumumba Noa ndoŋ waŋ poŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Waŋ poŋginaig le kusem ndindo kugana le kule suŋgo ta kilke mbol prona. ");
INSERT INTO ssd_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa tuku yar 600 tambun arnu ait 17 ait ta mbolŋge kilke puluke lika kule sugokanu bulbulmba kilke mbolŋge prowe likinaig. Samba mata puluka sawe suŋgokanu piyna. ");
INSERT INTO ssd_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ki 40 furir 40 sawe ta pur ndamba piymba minna. ");
INSERT INTO ssd_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ki ait ndui ta mbolŋge Noa nuŋe piyo nuŋe kiŋo kat nuŋe Sem Ham Yafet nuŋe rugan kat nuŋe keŋmba ndoŋ nane waŋ poŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Sar umaŋ agaŋmor tumbraŋok ŋguikok nane yeki yeki ar ar ŋakmba Noa nane ndoŋ waŋ poŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Kilke mbol agaŋ nyu mindek pailnu paŋgarnu Kuate buk sana ta kumumba waŋ poŋginaig. Taŋanaig le Suŋgoŋge malaŋga tukulna. ");
INSERT INTO ssd_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Sawe ta mara 40 piymba minna le kule ta nzomba waŋ te-faitna. ");
INSERT INTO ssd_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Taŋamba kule nzomba mbolka waŋ te-faitna le kule mbol mbol lika minna. ");
INSERT INTO ssd_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Kule suŋgo ŋayomba tabe sugo funu basleniŋmba biŋ ŋakmba kile-butokina. ");
INSERT INTO ssd_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Kile-butokina sulumba maŋ kule mbolke ŋayomba mita 7 mbolŋge kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Sar umaŋ agaŋmor tumbraŋok ŋguikok agaŋ ŋakmba kilke mbolŋge likinaig tuku taŋgo pino ŋakmba turmba butoka ŋgisike sulunaig. ");
INSERT INTO ssd_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Agaŋ nyunu mindek kilke mbolŋge mabseŋ ŋak ta ŋakmba kume sulunaig. ");
INSERT INTO ssd_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Suŋgoŋge kilke mbol mbal ŋakmba ma gureŋmba kile-ŋgisike suluna. Taŋgo pino sar umaŋ agaŋmor tumbraŋok ŋguikok agaŋ afu mine ndakinaig. Noa nane ndo waŋ sinam taŋge abo minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Kule ta tambun 5 mara 150 taŋamba kilke mbolŋge ibeŋ ndaka suŋgokanu minna. ");
INSERT INTO ssd_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kuate nu Noa nane agaŋmor ndoŋ waŋ sinam taŋge minnaig ta nu sina so ndana. Nu nane idusniŋmba minna sulumba bubre sakina le pinderka kule muku serna. ");
INSERT INTO ssd_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Taŋamba nu kilke mbolŋge kule bulbulnaig ta mata tukulniŋgina sulumba samba mata tukulna le sawe ta kugana. ");
INSERT INTO ssd_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Tambun 5 ta sinamŋge kule ta ibeŋ-ibeŋmba minna. ");
INSERT INTO ssd_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Taŋamba minna ka ka tambun 7 ait 17 mbolŋge waŋ ta ndeka Ararat biŋ mbol taŋge minyokina. ");
INSERT INTO ssd_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Kule ibeŋ-ibeŋmba minna le tambun 10 ait 1 mbolŋge biŋ funu afu mayok kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Mara 40 kinaig le Noa nu bubre malaŋga fudiŋndo ta talka ");
INSERT INTO ssd_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","kal ande kukulna le nu kule parakuwa ŋga ta tairŋga kine promba minmba luka pro ndana. ");
INSERT INTO ssd_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Taŋana le Noa nu kilke buk parakina e ŋga idusna sulumba gami ande kukulna le kina ");
INSERT INTO ssd_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","kumba ka kule ndo minna le tiŋga mabtam tuku ma kugatok le nu maŋ luka waŋ tugum ta prona. Prona le Noa ndek wai kuitka tumba waŋ sinamŋge pilna. ");
INSERT INTO ssd_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Minna ma ma kusem ndindo kina le nu gami ta maŋ kukulna le kina ");
INSERT INTO ssd_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","kumba ka furiram maŋ luka olif waŋenu abonu purmba tina ta nzoŋga tumba luka nu tugum ta prona. Taŋana le Noa nu ail waŋe ta kaŋgermba kule buk ibeŋ ket ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Minna ma ma maŋ kusem ande kugana le maŋ gami ta kukulna le kina sulumba maŋ luka pro ndana. Nu nduiye kina. ");
INSERT INTO ssd_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa tuku yar 601 tambun ndindo ait ndindo mbolŋge kule kilke mbolŋge ta parakina le Noa nu wande funu buromba burok tambi mambilmba kilke kaŋgerna ta parakina. ");
INSERT INTO ssd_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tambun arnu ait 27 mbolŋge kilke paraka kareŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kile Kuate nu Noa sana: ");
INSERT INTO ssd_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Ne, piyo naŋe, kiŋo kat naŋe rugan kat naŋe tane ŋakmba waŋ mbolŋge mayok ka ibeŋ kape. ");
INSERT INTO ssd_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Agaŋmor ŋakmba tane ndoŋ minig ta sar umaŋ turmba ŋakmba kilmba kile-ibeŋkap. Taŋawap le nane tugeka kilke ŋakmba kumuŋge likamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Taŋakina le Noa, nuŋe kiŋo kat nuŋe, piyo nuŋe, rugan kat nuŋe nane ŋakmba ibeŋ kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Sar umaŋ agaŋmor ŋakmba kilke mbolŋge likinaig tuku ta nyu mindek nane mata ibeŋ kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ibeŋ kinaig le Noa nu Suŋgo tuku idusmba ndame afu kilmba atraukam tuku pa laŋlaŋ wakeina. Wakeina sulumba sar umaŋ agaŋmor nyam tuku ndui ndui kilmba bale farmba pa laŋlaŋ ta mbolŋge patika Suŋgo atraukam tuku pasokina le ugmba usarkinaig. ");
INSERT INTO ssd_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Usarkinaig le Suŋgo nu mundur mayenu ta kamusna sulumba nu garena le wamdusmbi sakina: Taŋgo pino nane maŋ mbarwaig ta ye kilke te maŋ ŋayo siliwe nda. Nane kiŋo ndo wamdus ŋaigonu ŋak sugoka taŋamba ndo minig. Ye buk agaŋ abo minnaig tuku ta ŋakmba kile-ŋgisike suluwen ta ye maŋ taŋawe nda. ");
INSERT INTO ssd_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Kilke te minwa le nyamagaŋ ŋgunu tuku ait, nyamagaŋ mayekam tuku ait, sawe tuku ait, ki tuku ait, mafeŋ tuku ait, furir tuku ait ta ŋakmba kugawe nda. Mara mindek muŋgu dubika minmba minamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kuate nu Noa nuŋe kiŋo kat nuŋe turmba nyaro pasa niŋge lika saniŋgina: Tane kiŋo kulim kile-patikap le tane tuku ndare mbolŋge kilke te kumuŋguwaig. ");
INSERT INTO ssd_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ye kile agaŋ ndende ŋakmba tane kulatkam tuku tiŋget. Sar umaŋ kilke mbolok agaŋmor kualegaŋ ŋakmba tane tuku kuru-kuruka minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Agaŋ ŋakmba likade ta tane tuku nyamagaŋ minig. Ye buk ilinzu ŋakmba tiŋgen taŋamba ndo kile agaŋmor ŋakmba tiŋget. ");
INSERT INTO ssd_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tane agaŋmor ndemnu ndare ŋak ŋak ndanyap. Mbulap. Ta ndaŋam? Ndare ta nuŋe abo tugu. Ta tuku tane ndanyap. ");
INSERT INTO ssd_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Taŋgo andeŋge ko agaŋmor andeŋge taŋgo inum balewa le kumwa ta nu mata kumamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kuate nu taŋgo pino kile-mayokkina ta nuŋe suk. Ta tuku taŋgo andeŋge taŋgo inum balewa ta nu mata kumamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ye tane satiŋget: Tane tugeka kiŋo kulim kile-patikap le kilke kumuŋguwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Taŋakina sulumba Kuate nu Noa nuŋe kiŋo kat nuŋe ndoŋ teŋenmba saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Tane isap. Ye kile tane ndoŋ wamdus ulendika siŋka son pasa satiŋget te ye siŋka kumuwamŋgit. Ŋgumneŋga tane tuku ndare mbolŋge mata pasa te kumuwamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Sar umaŋ agaŋmor tumbraŋok ŋguikok kilke mbolok agaŋ ŋakmba abo minig tane ndoŋ waŋ mbolŋge ibeŋ kinaig ta nane mata tane ŋakmba tuku pasa te saket. ");
INSERT INTO ssd_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ye maŋ kule suŋgombi agaŋ ndende ŋakmba kile-ŋgisike nda. Kule suŋgoŋge kilke maŋ ŋayo siliwe nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Taŋakina sulumba nu maŋ lato saniŋgina: Ye kile tane ŋakmba ndoŋ wamdus ulendiket. Mara mindek taŋamba minmba minamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ta tuku ye kile wanzu kuambor taŋaŋ gau mbolŋge pilet. Kilke mbol mbal ŋakmba nane wanzu ta kaŋgerwaig sulumba pasa te idusamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Yeŋge wi le gau tiŋguwa le wanzu prowa ta ");
INSERT INTO ssd_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ye siŋka son pasa satiŋget te idusamŋgit. Kule suŋgo maŋ promba tane ŋakmba kile-ŋgisike nda. ");
INSERT INTO ssd_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Wanzu ta gau mbolŋge minwa le ye kaŋgeri sulumba pasa te idusamŋgit. Ye siŋka son pasa te agaŋ ŋakmba ŋgarosu ŋak abo minig ta tane satiŋget ta siŋka kumuwamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ye kilke mbol mbal ŋakmba ndoŋ wamdus ulendika wanzu kuambor taŋaŋ pilet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa tuku kiŋo kame waŋ mbolŋge ibeŋ kinaig ta nyu kat naŋgine Sem Ham Yafet. Kanan nu Ham tuku kiŋo. ");
INSERT INTO ssd_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noa tuku kiŋo kame keŋ ta nane tuku ndare tugeka kile sine kilke mbol mbal ŋakmba mineg. ");
INSERT INTO ssd_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa nu nyam piro ndo kumba minna tuku. Nuŋge tugu pilmba grep piro ande ŋgukina. ");
INSERT INTO ssd_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mara ande nu grep kule afu nyina le grep kuleŋge balena le ŋginŋganka baibai sinamŋge tawi kuklikina le wagek kinymba minna. ");
INSERT INTO ssd_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Taŋana le Kanan mam nuŋe Ham nu mam nuŋe wagek kinymba minna ta kaŋgerna sulumba nu ndek kumba ka aba kat nuŋe sanikina le ");
INSERT INTO ssd_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem nale Yafet ndoŋ nale ndek tawi ande tumba kaika ŋgumnem-ŋgumnem baibai sinam kumba mam nakile kainaik. Nale mam nakile wagek minna ta kaŋgeram mbulmba tumail te-sinaik. ");
INSERT INTO ssd_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kile Noa nu ŋgaro purfena le kiŋo ŋgrimbik wam kina ta kubenaik le isna sulumba nu ndek sakina: ");
INSERT INTO ssd_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ye kile Kanan kasuri le nu nuŋe tira kame kumnemŋge nane tuku sanzal taŋgo piroka minamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Taŋakina sulumba nu maŋ lato sakina: Sine Suŋgo tuku nyu te-duŋgube. Nu Sem tuku Mbara. Kanan nu Sem kumnemŋge nu tuku sanzal taŋgo piroka minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kuateŋge Yafet sinzaŋwa le nu tuku ndare tugekamŋgat. Nu tuku mbuŋ kame Sem tuku mbuŋ kame ndoŋ ulendika minwaig le Kanan nu Yafet kumnemŋge nu tuku sanzal taŋgo piroka minamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Kule suŋgo ta kugana le Noa nu maŋ lato yar 350 minna. ");
INSERT INTO ssd_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuŋe yar ulendimba ta 950 kusrena sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noa tuku ndare ta teŋenmba. Noa tuku kiŋo keŋmba ande nyunu Sem ande Ham ande Yafet. Kule suŋgo ibeŋ kina le nane keŋ ta kiŋo afu kile-patikinaig. ");
INSERT INTO ssd_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet tuku kiŋo kat nuŋe nyu naŋgine ta teŋenmba. Gomer, Makok, Madai, Yawan, Tubal, Mesek, Tiras. Ŋgumneŋga nane tuku ndare tugekinaig sulumba mbuŋ kat naŋgine tuku nyu ta tumba naŋgine tumbraŋ yimyam kilmba minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer tuku mbuŋ kat nuŋe ta Askenas mbal Rifat mbal Tokarma mbal. ");
INSERT INTO ssd_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawan tuku mbuŋ kat nuŋe ta Elisa mbal Spen mbal Siprus mbal Rodes mbal. ");
INSERT INTO ssd_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Nane yu make tumba minig mbal le nuy mbolŋge minig mbal ta tuku mbuŋ naŋgine. Yafet tuku ndare ta taŋamba ndo. Nane tuku tumbraŋ yimyam, ma tugu yimyam, pasa mata yimyam. ");
INSERT INTO ssd_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham tuku kiŋo kat nuŋe nyu naŋgine ta teŋenmba. Kus, Isip, Libia, Kanan. Ŋgumneŋga nane tuku ndare tugekinaig sulumba mbuŋ kat naŋgine tuku nyu ta tumba naŋgine tumbraŋ yimyam kilmba minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus tuku mbuŋ kat nuŋe ta Seba mbal Awila mbal Sabta mbal Rama mbal Sabteka mbal. Rama tuku mbuŋ ta Zeba mbal Dedan mbal. ");
INSERT INTO ssd_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus tuku kiŋo ande nyunu Nimrod. Nimrod nu kame bumba tumbraŋ afu kilke yaika kilmba minna tukunu nu gabat suŋgo mayok kina. ");
INSERT INTO ssd_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nu Suŋgoŋge turna le nu kanzerek taŋgo minna. Ta tuku nane afu naŋgine naŋgine teŋenmba sakade. Suŋgoŋge ne turnuwa le kanzerek taŋgo Nimrod suk minamŋgat ŋgade. ");
INSERT INTO ssd_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","O buk Nimrod nu Babilonia kilke ta tuku tumbraŋ keŋmba kulatkina. Tumbraŋ keŋmba ta ande nyunu Babilon ande Erek ande Akad. ");
INSERT INTO ssd_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nu Babilonia kilke kusremba Asiria kina sulumba tumbraŋ sugo bailkamba ninde lika wande patike likina. Tumbraŋ sugo ta ande nyunu Nineve ande Rehobot-Ir ande Kala ande Resan. ");
INSERT INTO ssd_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resan nu Nineve le tumbraŋ suŋgo Kala ŋgamu-ŋgamuŋge minna. ");
INSERT INTO ssd_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Isip tuku mbuŋ kat nuŋe ta Lidia mbal Anam mbal Leab mbal Naftu mbal Patrus mbal Kaslu mbal Kreta mbal. Kreta mbal nane Filistia mbal nane tuku mbuŋ naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanan nu kiŋo armba ŋak minna. Kiŋo mulum ta Sidon ande nyunu Het. Ŋgumneŋga nale tuku ndare tugekinaik sulumba mbuŋ kat naŋgine tuku nyu ta tumba naŋgine tumbraŋ yimyam kilmba minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","18","Kanan nu Yebus mbal Amor mbal Girkas mbal Hiwi mbal Arka mbal Sini mbal Arwat mbal Semar mbal Hamat mbal nane tuku mbuŋ naŋgine. Kanan tuku tumbraŋ mboŋ nane sili-silinaig le ");
INSERT INTO ssd_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","nane tuku tumbraŋ mboŋ makenu ande kumba ka Sidoŋge tiŋgina le ande kumba ka Gerarŋge tiŋgina. Gerar tumbraŋ ta Gasa tumbraŋ patumba. Tumbraŋ make ki prote kumam kina ta kumba ka Sodom, Gomora, Atma, Seboimŋge tiŋgina. Seboim tumbraŋ ta Lasa tumbraŋ patumba minna. ");
INSERT INTO ssd_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ham tuku ndare ta taŋamba ndo. Nane tuku tumbraŋ yimyam, ma tugu yimyam, pasa mata yimyam. ");
INSERT INTO ssd_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafet aba nuŋe Sem nu Hibru mbal ŋakmba tuku mbuŋ naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem tuku kiŋo kat nuŋe tuku nyu ta teŋenmba. Elam, Asur, Arpaksad, Lud, Aram. Ŋgumneŋga nane tuku ndare tugekinaig sulumba mbuŋ kat naŋgine tuku nyu ta tumba naŋgine tumbraŋ yimyam kilmba minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram tuku mbuŋ ta Us mbal Hul mbal Geter mbal Mesek mbal. ");
INSERT INTO ssd_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad tuku kiŋo nuŋe nyunu Sela. Sela tuku kiŋo nuŋe nyunu Eber. ");
INSERT INTO ssd_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber nu kiŋo armba kile-patikina ta ande nyunu Pelek. Pelek tuku ait mbolŋge taŋgo pino ŋakmba sili-silinaig. Eber tuku kiŋo ande nyunu Yoktan. ");
INSERT INTO ssd_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","29","Yoktan tuku mbuŋ ta Almodad mbal Selef mbal Hasarmawet mbal Yera mbal Hadoram mbal Usal mbal Dikla mbal Obal mbal Abimael mbal Seba mbal Ofir mbal Awila mbal Yobab mbal. Nane ŋakmba Yoktan tuku ndare. ");
INSERT INTO ssd_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Nane tuku ma tugu makenu ta Mesaŋge tiŋga laipmba kumba ka Sefarŋge tiŋgina. Sefar tumbraŋ ma taknu ki prote kumamŋge minna. ");
INSERT INTO ssd_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sem tuku ndare ta taŋamba ndo. Nane tuku tumbraŋ yimyam, ma tugu yimyam, pasa mata yimyam. ");
INSERT INTO ssd_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Taŋgo kuasmbi ŋakmba ta Noa tuku ndare. Kule suŋgo kugana le Noa tuku kiŋo kat nuŋe tuku ndare puluka tugekina. Nane keŋ ta kilke mbol mbal ŋakmba tuku mbuŋ kat naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","O buk tugu mbolŋge taŋgo pino kilke ŋakmba mbolŋge pasa ndindo agaŋ ndende ŋakmba nyu ndindo saka minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Nane ki prote kumamŋge kine promba minnaig. Taŋamba minnaig ma ma mara ande nane kinaig ka Babilonia tuku ma gutoŋ ande mbol pronaig sulumba nane taŋge tumbraŋ ulnaig. ");
INSERT INTO ssd_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Taŋamba nane naŋgine naŋgine sakinaig: Sine kilke kilmba pasoka ndame wakeikube le kareŋguwaig ŋginaig. Nane taŋamba wakeikinaig sulumba wande palmbim tuku gulgol ta tumba ndame ta pisneniŋginaig le ndame ta deŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kile nane ndek sakinaig: Sine tumbraŋ suŋgo ande ulmba wande patikube sulumba wande suŋgo kuen ŋayo ande pilbe. Funu ka samba kirewa. Taŋamba sine nyu ŋak minbe sulumba sili-silimba ma tugu ŋakmba kine ndakube ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Nane wande ta pilnaig le Suŋgo nu nane tumbraŋ ulmba wande kuen ŋayo pilnaig ta kaŋgeram ndekina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","sakina: Taŋgo pino nane ndare ndindo pasa kuale ndindo. Nane maŋau te tugu pilmba kade ta ŋgumneŋga naŋgine nzali dubimba maŋau afu kam tuku sakuwaig sulumba ta kamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ta tuku sine ndek kab sulumba taŋgo tuku mane tugu mbilniŋbe le nane naŋgine naŋgine pasa katese ndawaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Taŋakina sulumba Suŋgo nu taŋgo pino ŋakmba tugena le nane wande piro suŋgo ta kusremba sili-silimba kilke tugu ŋakmba mbol kine likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Tumbraŋ suŋgo ta nyunu Babilon ŋginaig. Ma ta mbolŋge Suŋgo nu nane tuku mane tugu mbilniŋge likina le nane sili-silimba kilke tugu ŋakmba mbol kine likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sem tuku ndare tuturmba teŋenmba kina. Kule suŋgo ta ibeŋ kina le yar armba kinaig le Sem nu yar 100 ŋak minmba kiŋo ande nyunu Arpaksad te-pilna. ");
INSERT INTO ssd_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Te-pilna sulumba nu maŋ lato yar 500 kusremba kiŋo kulim afu turmba kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksad nu yar 35 ŋak minna sulumba kiŋo ande nyunu Sela te-pilna. ");
INSERT INTO ssd_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Te-pilna sulumba nu maŋ lato yar 403 minmba kiŋo kulim afu turmba kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela nu yar 30 ŋak minna sulumba kiŋo ande nyunu Eber te-pilna. ");
INSERT INTO ssd_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Te-pilna sulumba nu maŋ lato yar 403 minmba kiŋo kulim afu turmba kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber nu yar 34 ŋak minna sulumba kiŋo ande nyunu Pelek te-pilna. ");
INSERT INTO ssd_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Te-pilna sulumba nu maŋ lato yar 430 minmba kiŋo kulim afu turmba kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelek nu yar 30 ŋak minna sulumba kiŋo ande nyunu Reu te-pilna. ");
INSERT INTO ssd_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Te-pilna sulumba nu maŋ lato yar 209 minmba kiŋo kulim afu turmba kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu nu yar 32 ŋak minna sulumba kiŋo ande nyunu Seruk te-pilna. ");
INSERT INTO ssd_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Te-pilna sulumba nu maŋ lato yar 207 minmba kiŋo kulim afu turmba kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk nu yar 30 ŋak minna sulumba kiŋo ande nyunu Nahor te-pilna. ");
INSERT INTO ssd_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Te-pilna sulumba nu maŋ lato yar 200 minmba kiŋo kulim afu turmba kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor nu yar 29 ŋak minna sulumba kiŋo ande nyunu Tera te-pilna. ");
INSERT INTO ssd_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Te-pilna sulumba nu maŋ lato yar 119 minmba kiŋo kulim afu turmba kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera nu yar 70 kusrena sulumba kiŋo afu kile-patikina ta ande nyunu Abram ande Nahor ande Haran. ");
INSERT INTO ssd_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","29","Tera tuku ndare tuturmba teŋenmba kina. Nu kiŋo keŋmba kile-patikina ta ande Abram ande Nahor ande Haran. Haran nu Lot te-pilna sulumba nu kulim armba turmba kile-patikina ta ande nyunu Milka ande Iska. Mam naŋgine kume ndakina le Haran nu amboŋga nuŋe tumbraŋ tuguk Urŋge minmba kumna. Ma tugu ta nyunu Babilonia. Abram nu Sarai tina le Nahor nu mambo nuŋe Haran tuku kulim Milka tina. ");
INSERT INTO ssd_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai nu niŋka kiŋo kugatok minna. ");
INSERT INTO ssd_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Kile Tera nu kiŋo nuŋe Abram rugan nuŋe Sarai wa nuŋe Lot nane keŋ ta kilmba Babilonia ma tugu Ur tumbraŋ kusremba Kanan kilke mbol kambim saka kinaig kumba ka Haran tumbraŋ promba taŋge minnaig ma ma Tera nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Nu yar ŋakmba 205 kusrena sulumba Haran tumbraŋ taŋge nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Mara ande Suŋgo nu Abram sana: Ne naŋe kilke naŋe tumbraŋ tuguk naŋe ndare kusreka ye ma ande tumni le ne ka kilke ta mbolŋge mina. ");
INSERT INTO ssd_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Yeŋge ki le ne tuku ndare tugeka taŋgo kuasmbi suŋgokanu mayok kaŋgat. Yeŋge ne nyaro tini le ne taŋgo suŋgo nyu ŋak minamŋgat. Taŋawa le nane ŋgumneŋga ne tuku saka nane afu nyaro niŋge likamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nane afu ne nyaro tinwaig ta ye mata nane nyaro niŋgamŋgit. Ko nane afu ne kasurnuwaig ta ye mata nane kasurniŋgamŋgit. Ne mbolŋge ye kilke tugu ŋakmba mbolŋge wam mayenu kamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Suŋgo nu taŋakina le Abram nu miŋge dubimba tiŋga Haran tumbraŋ kusremba kina le Lot nu dubimba kina. Ait ta mbolŋge Abram nu yar 75 ŋak minna. ");
INSERT INTO ssd_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram nu kumba piyo nuŋe Sarai, nzamu nuŋe Lot, Haran mbal afu nu piyaniŋmba kilna ta agaŋ ndende ŋakmba kilmba Kanan kambim saka kinaig kumba ka ka Kanan kilke mbol pronaig. ");
INSERT INTO ssd_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Pronaig sulumba kilke ŋgamu fetka kumba ka Sekem ma promba More ma tuku ail suŋgo ta tugumŋge minnaig. Ait ta mbolŋge Kanan mbal nane kilke ta mbolŋge mine likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Minnaig le Suŋgo nu Abram tugum promba sana: Ye ne tuku ndare kilke te siŋka serniŋgamŋgit ŋgina. Taŋakina le Abram nu Suŋgo nu teŋge ye tugum prowat ŋga ndame afu kilmba turŋaŋga atraukam tuku pa laŋlaŋ inum wakeina. ");
INSERT INTO ssd_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Taŋana sulumba nu ma ta kusremba kina ka tabe ande poŋga baibai patika taŋge minnaig. Tabe ta Betel tumbraŋ ki butuŋgate kumam Ai tumbraŋ ki prote kumam nu ŋgamuŋge minna. Tabe mbol taŋge Abram nu ndame turŋaŋga Suŋgo atraukam tuku pa laŋlaŋ wakeimba Suŋgo mbariŋmba nu tuku nyu te-duŋga minna. ");
INSERT INTO ssd_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Taŋana sulumba nu maŋ tiŋga kumba ka Negeb ma baknu ta kambim saka kina. Negeb ma baknu ta Kanan kilke mbolŋge minit. ");
INSERT INTO ssd_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nu kina ta Negeb kilke mbolŋge guba suŋgo prona tukunu Abram nane gubak minnaig sulumba ndeka kilke ta kusremba Isip kilke mbol ndekinaig. ");
INSERT INTO ssd_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ndekinaig sulumba Isip kilke mbol prowam bafumba nu piyo nuŋe Sarai sana: Ne pino tumail pasi ŋgarosu mayenu ndo. ");
INSERT INTO ssd_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Isip taŋgo kame nane ne kaŋgernumba nuŋe piyo nuŋe ŋga idusmba ne tam tuku ye baleyumba ne kusrenamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ta tuku taŋgo te ye tuku leu ŋga saniŋga le nane ne tuku ŋga ye bale ndayuwaig le ye maye minamŋgit ŋga Sarai sana. ");
INSERT INTO ssd_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Taŋakina sulumba Abram nu Isip kilke mbol prona le Isip mbal mambilmba Sarai kaŋgermba pino ta mayenu ndo ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Farao tuku mbal afu nane Sarai kaŋgermba kumba ka Farao sanaig. Sanaig le nu ismba taŋgo afu kukulniŋgina le pro Sarai tumba Farao tuku wande mbol kinaig le nu taŋge minna. ");
INSERT INTO ssd_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Minna le Farao nu Sarai tuku garena le nu Abram kigamba agaŋ ndende suŋgomba tuna. Nu agaŋmor suŋgomba sipsip makau kamel doŋki piro mbal turmba Abram tuna le kilna. ");
INSERT INTO ssd_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Farao nu Abram piyo nuŋe Sarai pinonu tina tukunu Suŋgo nu Farao nuŋe wande tuma mbal turmba ŋaigo siglikina le guaze sugo kile-likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Taŋanaig le Farao ndek Abram wika kusnana: Ne ame maŋau ye mbolŋge kina? Ndaŋam saka ne naŋe piyo naŋe ta ye ndasayina? ");
INSERT INTO ssd_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ne yiŋe kulim ŋga sayina tukunu ye yiŋe pinonu ten. Kile piyo naŋe te tumba kua kaye ŋga Abram sana. ");
INSERT INTO ssd_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Taŋakina sulumba nu nuŋe mbal saniŋgina le nane Abram mindemba kumba ndinŋge mbilnaig le Abram nale piyo nuŋe ndoŋ agaŋ ndende ŋakmba kilmba kinaik. ");
INSERT INTO ssd_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram nu piyo nuŋe Sarai nzamu nuŋe Lot agaŋ ndende ŋakmba kilmba Isip kusremba kina ka Negeb ma baknu mbol prona. ");
INSERT INTO ssd_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram nu agaŋmor silwa ndametiŋ gol ndametiŋ agaŋ ndende ta suŋgomba ŋak minna. ");
INSERT INTO ssd_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nu Negeb ma mbol prona sulumba maŋ tiŋga kumba ka ka Betel tumbraŋ patumba nu o buk baibai patikina ma ta tugum prona. Ma ta Betel tumbraŋ Ai tumbraŋ ŋgamu-ŋgamuŋge minit. ");
INSERT INTO ssd_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Minna sulumba o buk atraukam tuku pa laŋlaŋ wakeina ma ndui ta mbolŋge maŋ Suŋgo mbariŋmba nu tuku nyu te-duŋga minna. ");
INSERT INTO ssd_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot nane Abram ndoŋ minnaig ta nu mata agaŋ ndende sipsip makau baibai suŋgomba ŋak minna. ");
INSERT INTO ssd_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nale ar ta agaŋmor suŋgomba ŋak tukunu nale ma ta tuma minam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ta tuku Abram tuku agaŋmor kulat taŋgo nane Lot tuku agaŋmor kulat taŋgo ndoŋ muŋgu gubra ŋak minnaig. Ait ta mbolŋge Kanan mbal Peris mbal nane ma ta mbolŋge minnaig tuku. ");
INSERT INTO ssd_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kile Abram nu ndek Lot sana: Ne sile ndare ndui ta ndo. Ta tuku sile ŋgamukŋge muŋgu gubra ŋak mine ndakupe. Sile tuku piro taŋgo mata nane muŋgu gubra ŋak mine ndakuwaig. ");
INSERT INTO ssd_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ma te suŋgokanu. Ne naŋe kilke inum kaŋgermba madiwa le sile purkupe. Ne ma ande mbol kaye ndeta ye ma ande mbol ka ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Taŋakina le Lot nu mambilmba Yordan kule kumamŋge ma gutoŋ ta kaŋgerna. Ma ta kule suŋgomba ŋak kumba ka Soar tumbraŋŋge tiŋgina. Ait ta mbolŋge Suŋgo nu Sodom le Gomora ŋaigo sili ndakina. Ma ta mayenu ndo Suŋgo tuku piro Isip mbal tuku kilke taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ta tuku Lot nu ma ta mayenu ndo ŋga Yordan ma gutoŋ ta ŋakmba madimba te-suluna. Taŋamba nu Abram kusremba ki prote kumam ma ta mbolŋge ka minna le nale yimyam minnaik. ");
INSERT INTO ssd_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram nu Kanan kilke mbolŋge minna le Lot nu Yordan ma gutoŋ ta kumba ka taŋge minyokina sulumba nuŋe baibai Sodom tumbraŋ patumba patike likina sulumba nu taŋge minna. ");
INSERT INTO ssd_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom mbal nane une maŋau suŋgomba kumba Suŋgo tuku miŋge ŋgurmba minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot nu Abram kusrena le Suŋgo nu Abram sana: Ne tiŋga mambilmba ma tugu ŋakmba kaŋgerka. ");
INSERT INTO ssd_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ma ŋakmba ne kaŋgerkate ta ne naŋe ndare ŋakmba ndoŋ sertiŋgi le tane tuku kilke minmba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Yeŋge ki le ne tuku ndare tugeka ne tuku mbuŋ burnu kumuŋ kuga prowamŋgaig. Kilke mbolŋge tub tub taŋaŋ burnu kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kile ne tiŋga kilke tuku kuennu kilke tuku suŋgonu ŋakmba lika kaŋgerka. Ye kilke ta ŋakmba ne tanmbimŋgit ŋga Abram sana. ");
INSERT INTO ssd_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Taŋakina le Abram nu nuŋe baibai sambriniŋmba ma ta kusremba kumba ka Hebron tumbraŋŋge Mamre tuku ail sugo tugum taŋge minyokina. Minyokina sulumba Suŋgo atraukam tuku pa laŋlaŋ ande wakeina. ");
INSERT INTO ssd_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Mara ande Babilonia tuku gabat suŋgo Amrafel, Elasar tuku gabat suŋgo Ariok, Elam tuku gabat suŋgo Kedorlaomer, Goim tuku gabat suŋgo Tidal nane bailka ta ");
INSERT INTO ssd_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","gabat sugo 5 ndoŋ kame bunaig. Gabat sugo 5 ta Sodom tuku gabat suŋgo Bera, Gomora tuku gabat suŋgo Birsa, Atma tuku gabat suŋgo Sinab, Seboim tuku gabat suŋgo Semeber, Bela tuku gabat suŋgo turmba. Bela tumbraŋ tuku nyu ande Soar ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Gabat sugo 5 ta ulendika pasa katnaig sulumba Sidim tuku ma gutoŋ ta kinaig. Ma ta kile Yu Kagli Ŋayo taŋge te-suluna. ");
INSERT INTO ssd_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kedorlaomer nu yar 12 gabat sugo 5 ta kulatkina le nane ta tuku ndagariniŋgina le yar 13 mbolŋge nane nu ndoŋ kame bunaig. ");
INSERT INTO ssd_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Yar 14 mbolŋge Kedorlaomer nuŋe gulab kame gabat sugo keŋ ta ndoŋ nane naŋgine kame mbal kile-maŋgurka kinaig ka tumbraŋ afu ndoŋ kame bunaig. Asterot-Karnaim tumbraŋŋge Kedorlaomer nu Refaim mbal ndoŋ kame bumba nane kile-ibeŋkina sulumba ka Ham tumbraŋŋge nu Susim mbal ndoŋ kame bumba nane kile-ibeŋkina sulumba ka Kiriatim tuku ma gutoŋ taŋge nu Emim mbal ndoŋ kame bumba nane kile-ibeŋkina. ");
INSERT INTO ssd_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Taŋamba nu maŋ kina ka Edom ma biŋ taŋge nu Hor mbal ndoŋ kame bumba nane yokerkina le nane sili-silinaig le nu nane dubika kina ka Elparan tumbraŋ ma baknu ta makembiŋge lukina. ");
INSERT INTO ssd_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Lukina sulumba kumba ka Enmispat tumbraŋ pronaig. (Tumbraŋ ta kile nyunu Kades ŋgade). Tumbraŋ taŋge nane Amalek mbal Amor mbal ndoŋ kame bunaig sulumba nane tuku kilke ta yaike likinaig. Amor mbal nane Hasason-Tamar tumbraŋŋge minnaig tuku. ");
INSERT INTO ssd_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ait ta mbolŋge Sodom, Gomora, Atma, Seboim, Bela tumbraŋ 5 ta tuku gabat sugo nane naŋgine kame mbal ndoŋ Sidim tuku ma gutoŋ ta kinaig sulumba taŋge nane kame tuku kuaneka minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elam tuku gabat suŋgo Kedorlaomer, Goim tuku gabat suŋgo Tidal, Babilonia tuku gabat suŋgo Amrafel, Elasar tuku gabat suŋgo Ariok nane mata kame tuku kuaneka minnaig. Gabat sugo bailka ta nane gabat sugo 5 ta ndoŋ kame buwam bafunaig. ");
INSERT INTO ssd_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidim tuku gutoŋ ta nane buk ndame dabuk dabuk kolta suk ta sota burok suŋgomba sarke likinaig. Kile kame saŋgri tiŋgina le Sodom tuku gabat suŋgo Gomora tuku gabat suŋgo nale kuru-kuruka nakile kame mbal ndoŋ kua ka bariŋga burok ta sinam kinaig le gabat sugo keŋ ta nane kame kuasmbi afu ndoŋ kua ka ma tabenu ta poŋga kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Taŋanaig le gabat sugo bailka ta nane Sodom le Gomora tuku agaŋ ndende, nyamagaŋ, taŋgo pino turmba yomba kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram nzamu nuŋe Lot nu Sodomŋge minna le nane nu tumba nu tuku agaŋ ndende turmba kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Taŋanaig le taŋgo ande nu wam ta kaŋgermba kua ka Abram sota kina sulumba Abram kila sana. (Abram nu Mamre tuku ail tugum taŋge minna. Mamre nu Amor taŋgo ande. Nu nuŋe mambo kat nuŋe ndoŋ nane keŋ ta Abram tuku gulab kat nuŋe minnaig. Mambo ar ta nyu nakile Eskol le Aner). ");
INSERT INTO ssd_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Nane Abram tuku nzamu nuŋe tumba kinaig ta taŋgo taŋge wam kubeu tuna le Abram nu ismba nuŋe kuasmbi kame taŋgo 318 ta ŋakmba kile-maŋgurkina sulumba nane ndoŋ gabat sugo bailka ta dubika Dan tumbraŋ kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Furir ŋgamuna le nu nuŋe kuasmbi ta kilmba walna sulumba gabat sugo bailka ta ndoŋ kame bumba nane kile-ibeŋka yokerkinaig le nane sili-silinaig le nane dubika kinaig ka Hoba tumbraŋ pronaig. Hoba tumbraŋ ta Damaskus tumbraŋ patumba minna. ");
INSERT INTO ssd_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Nu Sodom le Gomora tuku gabis agaŋ ndende ŋakmba ta kile-luka kilmba nzamu nuŋe Lot turmba tumba Lot tuku agaŋ ndende taŋgo pino ŋakmba turmba kilmba luka kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram nu gabat sugo bailka ta ndoŋ kame bumba nane kile-ibeŋkina sulumba luka prona le Sodom tuku gabat suŋgo ta Abram sota kina ka Zawe ma gutoŋ taŋge Abram te-silikina. (Ma gutoŋ ta tuku nyu ande Gabat Sugo tuku Gutoŋ ŋgade). ");
INSERT INTO ssd_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Salem tuku gabat Melkisedek nu Kuate o mbolok tuku pris minna. Nu bret grep kule kilmba Abram tugum kumba ");
INSERT INTO ssd_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","nyaro pasa tuna sulumba sakina: Kuate nu o mbolok. Nuŋge samba kilke kile-mayokkina. Nuŋge ne nyaro pasa tinwa. ");
INSERT INTO ssd_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kuate nu o mbolok. Sine nu tuku nyu te-duŋgube. Nuŋge ne sinzaŋnat le naŋe ŋgueu mbal ŋakmba kile-ibeŋkat ŋgina. Taŋakina le Abram nu gabis agaŋ ndende ŋakmba kilna ta maŋgur 10 patika ande tumba Melkisedek tuna. ");
INSERT INTO ssd_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Taŋana le Sodom tuku gabat suŋgoŋge ndek Abram sana: Taŋgo pino ŋakmba yiŋe kili le gabis agaŋ ndende ŋakmba ne kila ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram ndek Sodom tuku gabat suŋgo ta sana: Kuate Suŋgo nu o mbolok. Nuŋge samba kilke kile-mayokkina le ye kile Suŋgo tuku nyu mbolŋge pasa saŋgri pilewet. ");
INSERT INTO ssd_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ne ŋgumneŋga sakikat: Yeŋge Abram agaŋ ndende suŋgomba tuwen le kile nu agaŋ ndende suŋgomba ŋak minit ŋga sakikat tukunu ye ne tuku agaŋ inum te nda. Muli foŋfoŋ afu ko kupe ŋgaro tuku muli ande mata ye te nda. ");
INSERT INTO ssd_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ye mbulit. Ye agaŋ ndende afu kile nda. Ye tuku kuasmbiŋge nyamagaŋ afu kilmba nyinaig ta maye. Ye tuku gulab kame Aner Eskol Mamre nane ndo agaŋ ndende afu niŋga ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Mara ande Abram nu kiŋatanu suk Suŋgoŋge wika sana: Abram, ne kuru kuru ndaka. Ye ne tuku kandim taŋaŋ ne kulatka minet. Ne lafu mayenu suŋgokanu tamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Taŋakina le Abram nu ndek sana: O Kuate Suŋgo, ye kiŋo kugatok minet. Ye kumi le Damaskusnu taŋgo Elieser nuŋge ye tuku agaŋ ndende kilamŋgat. Ta tuku ne ame agaŋ mayenu ye samŋgat? ");
INSERT INTO ssd_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ne ye tuku ndare tumunu ande ndasina tukunu ye tuku kukul taŋgo nuŋge ye tuku agaŋ ndende kilamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Taŋakina le Suŋgo nu pasa lafumba sana: Kuga. Kukul taŋgo naŋe Elieser nu ne tuku agaŋ ndende kile nda. Naŋe kiŋo ndinok ta nuŋge ne tuku agaŋ ndende kilamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Taŋakina sulumba nu Abram tumba kilim kumba sana: Ai ambe. Samba mbol ambe tandeka mambilmba mbai kaŋgerka. Ne ŋakmba burkam kumuŋ e? Ŋgumneŋga ne tuku ndare mbolŋge mbuŋ gudommba mayok kaŋgaig. Samba mbolŋge mbai minig taŋaŋ burnu kumuŋ kuga ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Taŋakina le Abram nu Suŋgo tuku pasa ta ismba nu tuku saŋgri tomba tiŋgina le Suŋgo nu tuku ŋgamuŋgal son ta kaŋgermba nu taŋgo tiŋreknu ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Taŋakina sulumba nu Abram sana: Ye Suŋgo. Ye ne Babilonia mbal tuku kilke Ur tumbraŋŋge ye ne mindenumba te prowen. Kilke te ne sernam tuku ŋga ye taŋawen ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram ndek lafumba sakina: O Kuate Suŋgo, ye kilke te miro minam tuku sayate ta ye ndaŋmba pasa ta son pasa ŋga kila pili e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kuate nu ndek sana: Agaŋmor afu kilmba ye tugum te prowa. Makau paŋgarnu ande, meme paŋgarnu ande, sipsip pailnu ande ŋakmba yar keŋmba ŋak, gami ande, sar umaŋ kitek ande turmba kilmba ye tugum te prowa ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram nu pasa ta kumumba agaŋmor ta kilmba nu tugum prona sulumba agaŋmor ta ŋgamuŋge fetke lika inumnu ndinamŋge inumnu ŋaiŋamŋge patike likina sulumba umaŋ armba ta fet ndakina. ");
INSERT INTO ssd_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Taŋana le wir afu ndem ta kilam tuku fumba ndekinaig le Abram nu ndem ta ŋgailka nane yokerke likina. ");
INSERT INTO ssd_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ki ka butuŋgina le Abram nu kinymba ma make suŋgo kaŋgermba ŋgamuŋgal pitina le nu kuru kuru suŋgo tina. ");
INSERT INTO ssd_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Taŋamba minna le Suŋgo nu Abram sana: Ye siŋka sanet. Ne tuku mbuŋ kilke te kusremba kilke kise mbolŋge rawe taŋgo minwaig le kilke ta mbolok mbal nane piro kareŋnu niŋguwaig le piroka nane ait kuen ŋayo yar 400 nane sanzalnu minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ait ta kugawa le ye kilke ta mbolok mbal lafumba piti niŋgi le naŋe mbuŋ kame kusrekuwaig le agaŋ ndende suŋgomba ŋak tiŋga ma ta kusrewamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Neŋge ndo mine mayemba ma ma saibo pilmba kuma le ŋgunuŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Amor mbal kilke te mbolŋge minig ta naŋgine mbar sugo ke likade ta kumuŋguwaig le naŋe ndare pulumba kinit ta ka bailkanu mbolŋge maŋ luka te prowamŋgaig ŋga Abram sana. ");
INSERT INTO ssd_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Taŋakina le ki butuŋga furirna le waim ande pa guwa ŋak sati ande turmba mayok kinaik sulumba agaŋmor ndemnu Abrahamŋge fetka patikina ta ŋgamuk ŋgamuk kinaik. ");
INSERT INTO ssd_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Taŋanaik le Suŋgo nu Abram ndoŋ wamdus ulendika siŋka son pasa Abram sana: Ne tuku ndare ye kilke te serniŋgamŋgit. Isip tuku kule suŋgo kumamŋge kumba ka kule suŋgo Yufretis kumamŋge tiŋgate kilke ta ŋakmba tane sertiŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Ken mbal Kenis mbal Kadmon mbal Hit mbal Peris mbal Refaim mbal Amor mbal Kanan mbal Girkas mbal Yebus mbal nane tuku kilke ta ŋakmba tane sertiŋgamŋgit ŋga Abram sana. ");
INSERT INTO ssd_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","2","Sarai nu Abram tuku kiŋo ande te-pile ndakina sulumba nu taŋgo nuŋe sana: Suŋgo nu kiŋo ande ndasina tukunu ne ye tuku piro pino ndoŋ minap le nu kiŋo ande te-pilwa le yiŋe kiŋonu tamŋgit ŋgina. (Sarai tuku piro pino ta nyunu Hagar. Hagar nu Isipnu). Abram nu Sarai ndoŋ wamdus ulendinaik sulumba ");
INSERT INTO ssd_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarai nu nuŋe piro pino ta tumba Abram pinonu tuna. Ait ta mbolŋge Abram buk yar 10 Kanan kilke mbolŋge minna. ");
INSERT INTO ssd_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram nu Hagar tumba nu ndoŋ minnaik sulumba Hagar nu kiŋo konna ta kamusmba nu Sarai ake agaŋ taŋaŋ ŋga talana. ");
INSERT INTO ssd_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Taŋana le nu ndek Abram sana: Hagarŋge ye talayate ta naŋe mbar. Ye yiŋe piro pino ne tinnen ta nu kile fuŋgulok minmba nu ye talayate. Suŋgoŋge ndo nu sile pilesikuwa ŋga taŋgo nuŋe sana. ");
INSERT INTO ssd_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Taŋakina le nu ndek Sarai sana: Pino ta ne tuku piro pino ndo. Ne ame wam nu mbol kam ndeta ka ŋgina. Taŋakina le Sarai nu Hagar sawe lika katna le kua ka nu kusrena. ");
INSERT INTO ssd_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hagar nu Sarai kusremba Sur kambim tuku ndin dubimba kina ka ma baknu mbolŋge kule burok tugum taŋge minna le Suŋgo tuku Eŋel nu tugum prona sulumba ");
INSERT INTO ssd_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","nu kusnana: Hagar, Sarai tuku piro pino, ne aniŋge prowat sulumba animbi kaŋgat e ŋgina le nu ndek eŋel ta sana: Ye yiŋe piro gabat Sarai tuku kuru-kuruka kua ka tembi prowit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Suŋgo tuku Eŋel nu sana: Ne luka naŋe piro gabat sota kumba naŋe ŋgamuŋgal te-ibeŋmba Sarai kumnemŋge mina. ");
INSERT INTO ssd_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Yeŋge ki le ne tuku ndare tugeka kuasmbi suŋgokanu mayok kaŋgat. Burnu kumuŋ kuga ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Taŋakina sulumba Suŋgo tuku Eŋel maŋ lato sana: Ne kiŋo te-palmbimŋgat. Suŋgo nu ne tuku malmbi ta isna tukunu ne kiŋo ta nyunu Ismael ŋga. ");
INSERT INTO ssd_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Nu doŋki ŋguikok taŋaŋ minmba nu taŋgo pino ŋakmba tuku ŋgueu minamŋgat. Nu nuŋe ndare tuma ndoŋ mata nu mine nda. Nu kasomŋge minamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Taŋaka sana le Hagar nu nuŋe wamdusmbi sakina: i ... Ye Kuate kaŋgerit ta ye kume ndakit ŋgina. Suŋgo nu Hagar ndoŋ pasatina le Hagar nu sakina: O Kuate, ne tuku am mbolŋge agaŋ ndende ŋakmba mayokŋge minit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ta tuku nane kule burok ta nyunu “Suŋgo abo tugu ŋak nu ye kaŋgeryate” ŋgade. Kule burok ta Kades tumbraŋ Bered tumbraŋ ŋgamu-ŋgamuŋge minit. ");
INSERT INTO ssd_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Abram Hagar fuŋgul te-tuna ta kile nu kiŋo te-pilna le Abram nu kiŋo ta nyunu Ismael ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram nu yar 86 ŋak minna le Hagar nu kiŋo ta te-pilna. ");
INSERT INTO ssd_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram nu yar 99 ŋak minna le Suŋgo nu Abram tugum promba sana: Ye Kuate Saŋgri Ŋayo. Ye ne sanet. Ne ye tuku miŋge dubimba maŋau purfeŋnu ndo ŋak mina. ");
INSERT INTO ssd_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ye ne ndoŋ wamdus ulendika siŋka son pasa pilet ta dubimba kumuwamŋgit. Yeŋge ki le ne tuku ndare tugeka taŋgo pino suŋgomba mayok kaŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Taŋakina le Abram ndek truk kina le Kuate nu maŋ lato sana: ");
INSERT INTO ssd_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Ne isa. Ye tuku siŋka son pasa ne mbolŋge minit tukunu ne taŋgo kuasmbi suŋgomba tuku mbuŋ naŋgine minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ta tuku ne tuku nyu Abram kuga. Ne taŋgo kuasmbi suŋgomba tuku mbuŋ minamŋgat tukunu ye ne tuku nyu kitek Abraham pili le minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Yeŋge ki le ne tuku ndare mbolŋge kuasmbi suŋgomba mayok kaŋgaig. Afu gabat sugo mayok kaŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ye ne ndoŋ ne tuku ndare kame ndoŋ wamdus ulendika siŋka son pasa te pilet ta kugawe nda. Ye siŋka kumuwamŋgit. Ye ne tuku Mbara, ne tuku ndare pulumba tuturmba kaŋgat ta tuku turmba Mbara minmba minamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ne kilke te tuku tuguk taŋgo kuga ta ye kilke te nduiye naŋe ndare kame ta ndoŋ tane sertiŋgamŋgit. Kanan kilke ŋakmba te tane tuku kilke minmba minamŋgat. Kugawe nda. Ye siŋka tane tuku Mbara minmba minamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kuate nu maŋ lato Abraham sana: Ye siŋka son pasa te sanet. Naŋe ndare puluka tuturmba kuwaig ta tane pasa saket te ismba kumumba dubiwap. ");
INSERT INTO ssd_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ye ne ndoŋ naŋe ndare kame ndoŋ wamdus ulendika pasa dubimba kumuwam tuku ta teŋenmba. Tane taŋgo kiŋo kame ŋakmba tuku ŋgaro pikap sulumba ");
INSERT INTO ssd_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ye tane ndoŋ pasa katet te gilai ndaŋgap. ");
INSERT INTO ssd_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Tane kiŋo kile-patikap sulumba mara 8 kugawaig le nane tuku ŋgaro pikap. Taŋgine piro taŋgo tuku kiŋo kame tane kasomok taŋgo piyamba kile-likinaig ta ŋakmba tuku ŋgaro pikap. Taŋamba minmba minap le ");
INSERT INTO ssd_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ye tane ŋakmba ndoŋ wamdus ulendika minmba minamŋgit. Ta tuku nane ŋakmba tuku ŋgaro pikap le taŋgine ŋgarosu mbolŋge nzilal ta minwaig. ");
INSERT INTO ssd_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Taŋgo ande ŋgarosu nzilal ta kugatok ta nu tane ŋgamukŋge mine nda. Nu ye ndoŋ wamdus ulendikam tuku wam ta purmba pitaite ŋga sakina. ");
INSERT INTO ssd_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kuate nu maŋ Abraham sana: Ye kile piyo naŋe Sarai tuku sanet. Ne kile nyunu Sarai ndaŋga. Kile nyunu kitek Sara ŋga. ");
INSERT INTO ssd_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Yeŋge nu nyaro tuwi le nu ne ndoŋ kiŋo ande te-palmbimŋgaik. Taŋamba nu taŋgo kuasmbi suŋgomba gabat sugo afu turmba tuku ina naŋgine minamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Taŋakina le Abraham nu truk ka nzumilka wamdusmbi sakina: Yoi. Ye buk saibo pilmba yar 100 ŋak minet ta ndaŋmba ye kiŋo tam tuku sakate? Sara mata buk saibo pilmba yar 90 ŋak minit tukunu nu mata kiŋo te-palmbim kumuŋ kuga ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Taŋamba idusna sulumba Abraham nu Kuate sana: Ne ye tuku kiŋo Ismael ndo kulatka le nu maye minwa ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kuate ndek Abraham sana: Kuga. Piyo naŋe Sara nu ne tuku kiŋo ndinok te-palmbimŋgat ta ne kiŋo ta nyunu Isak ŋga. Ye kiŋo ta tuku ndare ŋakmba ndoŋ wamdus ulendika yiŋe siŋka son pasa kumumba dubimba minmba minamŋgit. Kugawe nda. ");
INSERT INTO ssd_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ne Ismael tuku sayat ta ye mata isit. Yeŋge nu nyaro tuwi le nu tuku ndare tugekuwaig sulumba nu tuku ndare mbolŋge gabat sugo 12 mayok kaŋgaig. Nu tuku ndare mbolŋge kuasmbi suŋgo mayok kaŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ye Ismael tuku taŋawamŋgit ta ye Isak ndoŋ wamdus ulendika yiŋe pasa kumumba minmba minamŋgit. Yar ande si ait teŋen prowa le Sara nu kiŋo ta te-palmbimŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Taŋakina sulumba Kuate nu Abraham ndoŋ pasate deŋpurmba nu kusremba kina. ");
INSERT INTO ssd_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kile Abraham nu Kuate tuku miŋge dubimba ki ait ndui ta mbolŋge kiŋo nuŋe Ismael tuku ŋgaro pikna sulumba nu tuku wande tuma mbal nu taŋgo ndametiŋmbi piyamba kile-likinaig ta ŋakmba tuku ŋgaro pike likina. ");
INSERT INTO ssd_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Abraham nu yar 99 ŋak minna le kiŋo nuŋe Ismael nu yar 13 ŋak minna le nane nale tuku ŋgaro piknaig. ");
INSERT INTO ssd_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ki ait ndui ta mbolŋge ndo nane Abraham le Ismael tuku ŋgaro piknaig sulumba ");
INSERT INTO ssd_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","nu tuku wande tuma mbal nu taŋgo ndametiŋmbi piyamba kile-likinaig ta ŋakmba tuku ŋgaro turmba pike likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mara ande ki pa tiŋgina le Abraham nu Mamre tuku ail sugo tugum taŋge nuŋe baibai kawaŋŋge minyok minna le Suŋgo nu tugum prona. ");
INSERT INTO ssd_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham nu mambilmba taŋgo keŋmba kaŋgerkina sulumba tiŋga pinderka kumba ka nane tugumŋge dagol tidroŋga loka saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","O taŋgo sugo, mayemba prowaig. Tane ye liyumba ndakape. Tane teŋge mabtumba isukusmba kape. ");
INSERT INTO ssd_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Teŋge minap le nane kule fudiŋ tumba prowaig le kupe minyaŋga ail kumnem teŋge minyoka mabtap. ");
INSERT INTO ssd_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mabta minap le ye nyamagaŋmbi tane turtiŋgi le nyumba saŋgri tumba kape ŋgina. Taŋakina le nane sakinaig: Ne sakate taŋamba ka ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Taŋakinaig le Abraham nu pitik ndo nuŋe baibai sinam kina sulumba Sara sana: Pitik ndo plaua mayenu inum kunya sulumba waimbi pipmba bret foŋfoŋ pasoka ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Taŋakina sulumba Abraham nu pinderka nuŋe makau fonde tugum promba fatnu kitek butuknu kuya ŋak ande madimba tumba nuŋe piro taŋgo tuna le nuŋge pre pre balemba kuapikina. ");
INSERT INTO ssd_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Taŋana le Abraham nu makau fatnu kuapikina ta tumba bata le amo turmba kilmba nane tugumŋge patikina le nane kilmba nyumba minnaig. Nane isukusmba minnaig le Abraham nu nane tugum taŋge ail kumnemŋge nane tairŋga tiŋ minna le ");
INSERT INTO ssd_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","nane nu kusnanaig: Piyo naŋe Sara nu aniŋge minit ŋginaig le nu ndek sakina: Nu baibai sinam teŋge minit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","taŋgo inum taŋge ndek nu sana: Yar ande si piyo naŋe Sara nu kiŋo tuwa le ye siŋka luka prowamŋgit ŋgina. Taŋakina le Sara nu nu ŋgumnemŋge baibai malaŋga tugum taŋge pasa ta kagmaŋga ismba tiŋ minna. ");
INSERT INTO ssd_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham nale Sara ndoŋ buk saibo patika yar gudommba kinaig le Sara nu kiŋo te-palmbim kumuŋ kuga tukunu ");
INSERT INTO ssd_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","nu wamdusmbi nzumilka sakina: Ye buk saibo pilen. Yiŋe gabat mata saibo pilna. Ye ndaŋndaŋmba tuma kinymba kamusi ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Taŋamba idusna le Suŋgo nu Abraham sana: Ndaŋam tuku Sara nu nzumilka sakat: Ye buk saibo pilen ta ndaŋmba ye kiŋo tamŋgit ŋga sakat. ");
INSERT INTO ssd_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ye Suŋgo. Ne iduste ye wam ta kam kumuŋ kuga ŋga ne iduste e? Kuga. Ye wam ŋakmba kam kumuŋ. Ye buk sakit. Yar ande si ait teŋen mbolŋge Sara nu kiŋo tuwa le ye luka prowamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Taŋakina le Sara nu yabuka sakina: Ye nzumil ndakit ŋgina le nu ndek nu sana: Kuga. Ne siŋka ne nzumilkat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kile taŋgo keŋ ta tiŋga Sodom tumbraŋ tumail tumba kinaig le Abraham nu nane mindeka ndinŋge mbilniŋgam bafuna le ");
INSERT INTO ssd_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Suŋgo nu wamdusmbi sakina: Ye maŋau kam bafuwet te ye Abraham yabuwe nda. Kuga. ");
INSERT INTO ssd_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ŋgumneŋga Abraham tuku ndare mbolŋge taŋgo kuasmbi suŋgo saŋgri ŋak mayok kaŋgaig. Nu mbolŋge kilke tugu ŋakmba mbolŋge ye wam mayenu kamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ye nu madiwen le nu nuŋe kiŋo kame nuŋe wa kat nuŋe ye tuku maŋau tumniŋguwa le nane maŋau purfeŋnu tiŋreknu ŋak minamŋgaig. Taŋawa le ye nu mbolŋge siŋka pasa sawen ta kumumba tambimŋgit ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Taŋamba idusmba nu Abraham sana: Sodom Gomora nale une maŋau sugokanu ŋak. Nale tuku une maŋau ta taŋgo pino ŋakmba naŋgine naŋgine sakade le iset. ");
INSERT INTO ssd_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nane sakade ta kumumba une ta minit e ta ye kumba katesewamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Taŋakina le taŋgo ar ta Sodom tumail tumba kinaik le Suŋgo nu Abraham ndoŋ minna le ");
INSERT INTO ssd_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","nu ndek Suŋgo kusnana: Ne taŋgo tiŋreknu ŋaigonu ŋakmba ulendimba bale faramŋgat e? ");
INSERT INTO ssd_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tumbraŋ taŋge taŋgo tiŋreknu 50 minwaig ndeta ne tumbraŋ ta te-ŋgisiwamŋgat e ko nanenu ŋga mapewamŋgat? ");
INSERT INTO ssd_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ne nane tiŋreknu ŋaigonu ŋakmba ulendimba bale faramŋgat e? Ne taŋawam kumuŋ kuga. Ne taŋgo ŋakmba kulatka kumumbi pileŋgate tuku. Ne maŋau mayenu ndo kate tuku ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Suŋgo nu lafumba sana: Ye Sodom taŋgo tiŋreknu burka ka 50 ta ye nanenu ŋga ŋakmba mapenuŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Taŋakina le Abraham nu maŋ lato sana: O Suŋgo, ye maŋ ne kusnani le ne ye tuku ndagari ndanuwa. Ye ake taŋgo ndo. Ne ye tuku ise ndaka. ");
INSERT INTO ssd_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ne taŋgo tiŋreknu burka ka 50 kuga 5 den ndeta ne tumbraŋ ta te-ŋgisiwamŋgat e ŋgina le Suŋgo nu sana: Taŋgo tiŋreknu 45 ndo minwaig ta ye tumbraŋ ta te-ŋgisiwe nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Kile Abraham nu maŋ lato Suŋgo kusnana: Ata. Taŋgo tiŋreknu 40 ndo nziŋge minwaig ndeta ne ndaŋamŋgat ŋgina le Suŋgo nu lafumba sana: Nane 40 ndo nziŋge minwaig ta ye tumbraŋ ta te-ŋgisiwe nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Taŋaka sana le Abraham nu maŋ kusnana: O Suŋgo, ye maŋ lato kusnanamŋgit ta ne ye tuku ndagari ndanuwa. Taŋgo tiŋreknu 30 ndo nziŋge minwaig ndeta ne ndaŋamŋgat ŋgina le Suŋgo ndek nu sana: Ye nane 30 ndo kaŋgerkumba ta ye tumbraŋ ta te-ŋgisiwe nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Kile Abraham maŋ lato nu kusnana: O Suŋgo, ye gabat kuilŋga ne ndoŋ pasatet. Taŋgo tiŋreknu 20 ndo nziŋge minwaig ndeta ne ndaŋamŋgat ŋgina le Suŋgo nu sana: Nane 20 ndo minwaig ta ye tumbraŋ ta te-ŋgisiwe nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Taŋakina le Abraham nu maŋ lato kusnana: O Suŋgo, ye pasa ndindo te ndo sani le ne ye ndoŋ gubra ndata. Taŋgo tiŋreknu 10 ndo nziŋge minwaig ndeta ne ndaŋamŋgat ŋgina le Suŋgo nu sana: Nane 10 ndo minwaig ta ye tumbraŋ ta te-ŋgisiwe nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Taŋakina sulumba Suŋgo nu Abraham ndoŋ pasate deŋpurmba nu kusremba kina le Abraham nu luka nuŋe tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Furirna le eŋel ar ta Sodom pronaik. Lot nu Sodom tumbraŋ fonde malaŋga tugum taŋge minyok minna sulumba nu nale kaŋgerka tiŋga kumba ka nale tugumŋge loka sakina: ");
INSERT INTO ssd_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","O taŋgo sugo, mayemba prowaik. Tale kupe minyaŋga ye tuku wande mbolŋge kinymba indole mafewa le maŋ kape ŋgina le nale ndek Lot sanaik: Kuga. Sile tumbraŋ ŋgamu mayok siŋge kinyamŋgik ŋginaik kande ");
INSERT INTO ssd_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lot nu nale saŋgrimba sarsarnikmba nu tuku wande mbol kuwaik ŋga sanikina le nale tiŋga nu dubimba nu tuku wande mbol kinaig. Taŋamba Lot nu nuŋe piro mbal saniŋgina le nane nale tuku pagunaig sulumba bret yis kugatok pasokinaig le nu nyamagaŋ ta kilmba nale nikina le nyinaik. ");
INSERT INTO ssd_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Isukuse deŋpurmba nale kinyam bafunaik le Sodom tumbraŋ taŋgo kiŋo kame ta ŋakmba pro Lot tuku wande kornaig sulumba ");
INSERT INTO ssd_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","wi kueŋka nu sanaig: Taŋgo ar furirat le ne sota prowaik ta nale aniŋge minik? Ne nale kile-mayokka le sine nale ndoŋ karbe ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Taŋakinaig le Lot nu nane sota kilim kina sulumba malaŋga tukulmba saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Tira kame, tane maŋau ŋayonu te nale mbolŋge ndakap. ");
INSERT INTO ssd_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ye tuku kulim ar minik te nale taŋgo ande ndoŋ kinye ndakinaik. Ye nale kile-mayokka tane tiŋgi le tane ame maŋau kam ndeta nale mbolŋge kap. Taŋgo ar te mbolŋge maŋau ŋayonu ande ndakap. Nale ye tuku gulab prowaik le ye nale kulatket ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Taŋakina le nane Lot sanaig: Ne kua kaye. Ne tumbraŋ tuguk taŋgo kuga. Ne ndaŋam saka siŋgine maŋau te kusrewam tuku peusiŋgit? Kua kaye. Kuga ta sine ne mata tumba ŋayo silinamŋgig ŋginaig. Taŋakinaig sulumba nane Lot mbiti-mbitimba malaŋga sambriwam bafunaig le ");
INSERT INTO ssd_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","taŋgo ar taŋge malaŋga talka wai sirmba Lot didikinaik le sinam kina le nale malaŋga tukulnaik. ");
INSERT INTO ssd_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Tukulnaik sulumba nale taŋgo kiŋo kame malaŋga tugumŋge minnaig ta ŋakmba am tukulniŋge likinaig le nane malaŋga te-sili ndakinaig. ");
INSERT INTO ssd_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Kile nale ndek Lot sanaik: Naŋe ndare afu minig e? Naŋe mbiyel, naŋe kiŋo, naŋe kulim afu turmba minig kande kilmba tumbraŋ te kusremba kua kape. ");
INSERT INTO ssd_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Sile tumbraŋ te te-ŋgisiwamŋgik. Tumbraŋ te tuku taŋgo pino nane tuku une maŋau suŋgokina le taŋgo pino nane naŋgine naŋgine sakade le Suŋgo nu isna. Ta tuku Suŋgo nu sile tumbraŋ te te-ŋgisiwam tuku kukulsikina le prowik ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Taŋakinaik le Lot nu tiŋga kumba taŋgo armba nu tuku kulim kat nuŋe kilam tuku madinikina ta sanikina: Tale tiŋgap le sine tumbraŋ te kile ndo kusremba kua kab. Suŋgo nu tumbraŋ te te-ŋgisiwamŋgat ŋgina kande nale nu usre pasa sakate ŋga idusmba nale numbik ri ndanaik. ");
INSERT INTO ssd_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mafena le Suŋgo tuku eŋel ar ta nale saŋgri mbakmba Lot sanaik: Ne tiŋga piyo naŋe, naŋe kulim ar ta kilmba kile ndo tiŋga pitik kua kape. Kuga ta tumbraŋ te tuku une ŋayonu lafunu ne turmba ŋgisinuŋgat ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Taŋakinaik le Lot nu wam nzumbileŋga gitmba minna ta Suŋgo nu Lot sinana le taŋgo ar ta Lot le piyo nuŋe, kulim ar ta nane wainu kilmba kumba tumbraŋ tuku fonde kilimŋge patikinaik. ");
INSERT INTO ssd_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Nane kilimŋge patikumba eŋel inum ta nane saniŋgina: Kua ka kape sulumba mbilka ŋgumnem mambil ndawap. Ma gutoŋ teŋge mabte ndakap. Kua ka ka tabe si poŋgap. Tane ŋgisikubekaig ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot nu lafumba sakina: O taŋgo suŋgo, taŋamba kuga. ");
INSERT INTO ssd_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Tale buk ye tuku sinatikina le ye mbolŋge maŋau mayenu kaik. Tabe si masken ŋayo tukunu ye tabe mbol ambe kua ka kambim fuguwet. Kumba mini le ndinŋge pa ta ye tuwa le kummba ŋgisinuŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ta tuku tale maŋ ye mbolŋge maŋau mayenu kap. Tumbraŋ patuk si kaŋgerap. Si fudiŋndo. Maye ndeta ye siŋge ka mini sulumba kummba ŋgisike nda ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","nu lafumba sana: Ta maye. Ne sakat taŋawamŋgit. Ye tumbraŋ si te-ŋgisiwe nda. ");
INSERT INTO ssd_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ne pateŋ kua ka tumbraŋ si kaye. Ye ne tairŋgamŋgit. Ne kumba si prowa le ye ma tugu te te-ŋgisiwamŋgit ŋgina. Lot nu tumbraŋ ta fudiŋndo ŋgina tukunu nane tumbraŋ ta nyunu Soar ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ki mbol kina le Lot nu Soar prona le ");
INSERT INTO ssd_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Suŋgo nu ndame pa soŋ ŋak sawe piyanu sukmba Sodom Gomora tuku ma tugu ŋakmba kumuŋge likina. ");
INSERT INTO ssd_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Tumbraŋ ar ta tuku ma gutoŋ ta taŋgo pino agaŋ ŋakmba kilke mbolŋge prowe likinaig ta ŋakmba usarke sulunaig. ");
INSERT INTO ssd_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Taŋanaig le Lot piyo nuŋe mbilka ŋgumnem mambilna kande nuŋe ŋgarosu ta sol kuilka kareŋga makek suk tiŋ minna. ");
INSERT INTO ssd_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mafena le Abraham nu maratukuk tiŋga kina ka Suŋgo ndoŋ pasata minnaik ma ta tugum prona sulumba ");
INSERT INTO ssd_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","mambilmba Sodom Gomora tuku ma gutoŋ kilke ŋakmba kaŋgerkina ta pa guwa suŋgo tafil ŋak tiŋga minna le kaŋgerna. ");
INSERT INTO ssd_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kuate nu ma gutoŋ ta te-ŋgisiwam bafuna sulumba nu Abraham idusmba Lot kukulna le nu tiŋga ma kise kina. Taŋana le nu Lot buk minna tumbraŋ ta ŋakmba kile-ŋgisike suluna. ");
INSERT INTO ssd_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot nu Soar tumbraŋŋge minam tuku kuru-kuruka nuŋe kulim ar ta kilmba tumbraŋ ta kusremba tabe poŋga kinaig ka ndame burok ande kaŋgermba sinam taŋge minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Taŋamba taŋge minnaig sulumba kulim mulum ta mambo nuŋe sana: Mam buk saibo pilna. Kilke te mbolŋge taŋgo ande sile kilam tuku mine ndakate. ");
INSERT INTO ssd_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ta tuku ne isa. Sile mam grep kule tupe le nu nyumba ŋginŋgankuwa le sile nu ndoŋ kinype. Taŋape sulumba sile kiŋo kile-patikupe ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Taŋamba furirna le nale mam nakile grep kule tunaik le nu nyumba ŋginŋgankina. Ŋgin-ŋgankina le kulim nuŋe mulum ta mam nuŋe ndoŋ kinynaik ta mam nuŋe ŋginŋganka nu wam ta katese ndana. ");
INSERT INTO ssd_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mafena le kulim mulum ta ndek mambo nuŋe sana: Furir ye mam ndoŋ kinyit. Ŋgilaiŋge sile maŋ mam grep kule tupe le nyumba ŋginŋgankuwa le ne suk mam ndoŋ kinya. Taŋape sulumba sile kiŋo ŋak minpe ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Taŋakina sulumba nale mam nakile maŋ grep kule tunaik le nu nyumba ŋginŋgankina. Ŋgin-ŋgankina le mambo nuŋe suk mam nuŋe ndoŋ kinynaik ta mam nuŋe ŋginŋganka wam ta mata katese ndana. ");
INSERT INTO ssd_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Taŋana le Lot tuku kulim ar ta mam nakileŋge fuŋgul nikina le kutunaik. ");
INSERT INTO ssd_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kulim mulum ta kiŋo ande te-pilna sulumba kiŋo ta nyunu Moab ŋgina. Kiŋo ta nu Moab mbal tuku mbuŋ naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mambo nuŋe mata kiŋo ande te-pilna sulumba kiŋo ta nyunu Ben-Ami ŋgina. Ben-Ami nu Amon mbal tuku mbuŋ naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham nu kumba ka Negeb ma baknu mbol prona sulumba Gerar tumbraŋŋge minna. Gerar nu Kades tumbraŋ Sur tumbraŋ ŋgamu-ŋgamuŋge minna. ");
INSERT INTO ssd_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Taŋge minna sulumba Abraham nu Sara nu yiŋe kulim ŋgina le Gerar tuku gabat suŋgo Abimelek nu taŋgo afu kukulniŋgina le nane pro Sara tumba ka Abimelek tunaig. ");
INSERT INTO ssd_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Taŋamba minmba ait ande furir ŋgamu Abimelek nu kinyna sulumba kiŋatina le Kuateŋge sana: Ne isa. Ne pino te taŋgo ŋak tina tukunu ne kumamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek nu Sara ndoŋ kinye ndakinaik tukunu nu Suŋgo lafumba sana: O Suŋgo, ye mbar ndawen. Ne taŋgo mbar ndade ta ne baleniŋgam kumuŋ e? ");
INSERT INTO ssd_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham nu nuŋe ye sayina: Pino te ye tuku kulim ŋgina le Sara mata ye sayina: Taŋgo te ye tuku leu ŋgina. Ye mbar ndawen. Ye taŋgo pino ŋakmba am mbolŋge ye maŋau te ken ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kuate nu kiŋambi lafumba sana: Ne taŋgo pino ŋakmba tuku am mbolŋge taŋana ta ye kila. Ta tuku ye ne nu ndoŋ une ndaka ŋga peunen le ne pino ta kire ndana. ");
INSERT INTO ssd_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ne kile pino ta tumba luka ka taŋgo nuŋe tawe. Taŋgo ta nu tuan taŋgo ande. Nu ne tuku yabaŋwa le ne kume nda. Ne pino ta luka nu ndatawe ta ne naŋe kuasmbi ndoŋ tane ŋakmba kume likamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mafena le maratukuk tiŋga Abimelek nu nuŋe piro taŋgo ŋakmba kile-maŋgurka pasa ŋakmba Kuateŋge sana le isna ta saniŋgina le nane kuru kuru suŋgo tinaig. ");
INSERT INTO ssd_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Taŋanaig le Abimelek nu Abraham wika sana: Ne ame maŋau sine mbolŋge kina? Ye ame mbar ken le ne sine ŋakmba piti suŋgo te siŋgam bafute? Ne siŋka maŋau ta ŋayonu kina. ");
INSERT INTO ssd_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ne ndaŋam saka maŋau teŋenmba kina ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham lafumba nu sana: Ye idusen tumbraŋ te tuku taŋgo nane Kuate tuku miŋge kumnemŋge minmba nu tuku nyu kurau ndakade tukunu nane ye tuku pino tumba ye baleyubekaig ŋga idusen. ");
INSERT INTO ssd_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Pino te son ye tuku kulim. Sile mamŋge kile-patikina ta sile ina yimyam le ye nu pinonu ten. ");
INSERT INTO ssd_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kuate nu ye kukulyina le ye yiŋe tumbraŋ tuguk kusrewen sulumba nu sawen: Ne ye mbolŋge maŋau mayenu kumba ma ŋakmba mbolŋge taŋgo ŋakmba teŋenmba saniŋga: Taŋgo te ye tuku leu ŋga saka ŋgen. Abraham nu taŋamba Abimelek sana le ");
INSERT INTO ssd_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","nu kina ka Sara tumba pro Abraham tuna sulumba sipsip makau piro taŋgo piro pino afu turmba kilmba promba Abraham tuna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","sana: Kilke te ŋakmba ye tuku ndo. Ne ma ani nzalinu minam idusmba ndeta ka taŋge minyoka ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Taŋamba nu ndek Sara sana: Ne mbar ndana. Taŋgo kame ne ndoŋ minig ta nane katesewaig ŋga ye leu naŋe ndametiŋ soŋ 100 tuwet. Ye taŋawi le ne mbar ande ke ndakina ta nane ŋakmba katesemba kila palmbimŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Abimelek nu Abraham piyo nuŋe tina tukunu Kuate nu Abimelek tuku piyo nuŋe, piro pino kat nuŋe nane ŋakmba kiŋo ŋgailniŋgina tukunu Abraham ndek Kuate yabaŋna le Abimelek nale piyo nuŋe ndoŋ, nuŋe piro pino ŋakmba nane wakeikina le nane maŋ kiŋo kile-patike likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Suŋgo nu siŋka pasa buk Abraham sana ta nu Sara mbolŋge kina le ");
INSERT INTO ssd_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","nu fuŋgul ŋakna. Abraham nu buk saibo pilmba yar 100 ŋak minna le piyo nuŋe Sara nu Kuate nu ait sana ta mbolŋge kiŋo ta te-pilna le ");
INSERT INTO ssd_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham nu kiŋo ta nyunu Isak ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","7","Kile Sara ndek sakina: Kuateŋge ye sinzaŋyat le ye kiŋo te-pilit. Ta tuku ŋga ye gare-gareka nzumilket. Nane ŋakmba ye maŋau kit ta iswaig sulumba gare-gareka nzumilkamŋgaig ŋgina. Taŋakina sulumba nu maŋ lato sakina: Nane buk idusnaig Sara nu Abraham tuku kiŋo ande te-pile nda ŋga idusnaig ta ye tuku taŋgo saibo pilna le kile ye nu tuku kiŋo ande te-pilit ŋgina. Isak nu mara 8 kusrena le ki ait ta mbolŋge Kuate nu Abraham buk sana ta kumumba nu kiŋo nuŋe tuku ŋgaro pikna. ");
INSERT INTO ssd_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kiŋo ta suŋgokina le ina nuŋeŋge nu amo ŋgailna. Ki ait ta mbolŋge Abraham nu kiŋo amo kusrena ta tuku pagumba nye suŋgokina. ");
INSERT INTO ssd_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Taŋana le Abraham tuku kiŋo Ismael nu Isipnu pino Hagar ndoŋ te-pilnaik ta nu Isak maim maim pasa tumba minna le Sara nu ismba ");
INSERT INTO ssd_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","taŋgo nuŋe sana: Kiŋo ta Isak ndoŋ ne tuku agaŋ ndende tuma kile nda. Piro pino ta kiŋo nuŋe ndoŋ pitaika le kasom kuwaik ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","nu pasa ta ismba kiŋo nuŋe Ismael tuku wamdus pitina le ");
INSERT INTO ssd_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kuateŋge nu sana: Piro pino ta kiŋo nuŋe ndoŋ ne wamdus piti ndanuwa. Ne Sara tuku pasa ismba dubiwa. Isak tuku ndare mbolŋge ndo ne tuku mbuŋ mayok kaŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Piro pino ta tuku kiŋo nu mata ne tuku kiŋo tukunu yeŋge ki le nu tuku ndare mbolŋge taŋgo kuasmbi suŋgo ande tugekamŋgat ŋga Abraham sana. ");
INSERT INTO ssd_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Taŋakina le maratukuk tiŋga Abraham nu nyamagaŋ kilmba agaŋmor ŋgarombi kule kunyna ta turmba kilmba Hagar tuku kailmane mbolŋge patika kiŋo nuŋe ndoŋ kukulnikina le kinaik kumba ka Berseba tuku ma baknu mbolŋge kine promba lika minnaik. ");
INSERT INTO ssd_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Lika minnaik ma ma kule kugana le kiŋo nuŋe tumba kumba ka ail fudiŋndo ande kumnemŋge pilna le kinymba minna. ");
INSERT INTO ssd_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kinymba minna le Hagar nu kiŋo nuŋe ta kusremba nane tui fat parsiŋgade le kumba tiŋgate taŋamba nu kumba ka minyokina sulumba wamdusmbi sakina: Ye kiŋo kaŋgermba mini le kumwa ta ŋayo ŋgina. Taŋakina sulumba nu taŋge minyok minmba malmbika minna. ");
INSERT INTO ssd_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Kiŋo ta mata malmbika minna le Kuate nu isna le samba mbolŋge Kuate tuku Eŋel ndek Hagar wika sana: Hagar, ne ndaŋam wamdus pitinate? Ne kuru kuru ndaka. Kiŋo naŋe malmbikate ta Kuate nu o buk isat. ");
INSERT INTO ssd_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ne tiŋga kumba ka kiŋo naŋe tumba wamdus bul sera. Yeŋge ki le nu tuku ndare tugeka taŋgo kuasmbi suŋgo ande mayok kaŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Taŋakina sulumba Kuate nu Hagar tuku am talkina le kule burok ande kaŋgerna sulumba kumba ka agaŋmor ŋgaro tambi kule kunyna. Kunyna sulumba kiŋo nuŋe kule ta tuna le nyina. ");
INSERT INTO ssd_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Kuateŋge kiŋo ta kulatka minna le suŋgokina sulumba kumba ka Paran tuku ma baknu mbolŋge minyokumba kanzerek taŋgo minna le ");
INSERT INTO ssd_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ina nuŋeŋge Isipnu pino ande tumba Ismael te-tuna. ");
INSERT INTO ssd_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ait ta mbolŋge Abimelek nuŋe kame gabat nyunu Pikol tumba Abraham tugum promba sana: Kuate tuku nyaro ne mbolŋge minit. ");
INSERT INTO ssd_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ta tuku ne kile Kuate tuku nyu tambi pasa saŋgri pilewa sulumba ye mbolŋge maŋau ŋayonu ande ndaka. Ye tuku kutu mbolŋge ye tuku wa kame mbolŋge mata maŋau ŋayonu ande ndaka. Ye buk ne mbolŋge maŋau mayenu ken ta kile ne suk ye mbolŋge, kilke kile ne rawe taŋgo taŋaŋ minit ta mbolŋge maŋau mayenu ndo ka ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham ndek nu sana: Ne sakate taŋamba ye pasa saŋgri pilewet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Taŋakina le Abraham nu kule burok ande Abimelek tuku piro taŋgoŋge tinaig ta tuku nu sana le ");
INSERT INTO ssd_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","nu ndek Abraham sana: Imaŋge kule burok ta tina ta ye gilai. Ne ye ndasayina. Kile ndo sayate le ye iset ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Taŋakina le Abraham nu kina ka sipsip makau turmba kilmba promba Abimelek tuna sulumba nale wamdus ulendinaik. ");
INSERT INTO ssd_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Taŋanaik sulumba Abraham nu sipsip fat 7 kilmba yamokŋge patikina le ");
INSERT INTO ssd_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek nu Abraham kusnana: Ne ndaŋam sipsip fat 7 ta yamokŋge patikat e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham lafumba nu sana: Yeŋge kule burok ta sarken ta ne son ŋga sulumba sipsip fat 7 te kila ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","(Nale wamdus ulendinaik tuku ma ta nane kile nyunu Berseba ŋgade). ");
INSERT INTO ssd_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Bersebaŋge wamdus ulendika Abimelek nuŋe kame gabat Pikol ndoŋ nale luka Filistia ma mbol kinaik le ");
INSERT INTO ssd_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham nu Bersebaŋge ail ande ŋgukina sulumba Kuate Suŋgo abo tugu ŋak nu tuku nyu te-duŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Taŋamba nu yar gudommba Filistia kilke mbolŋge minna. ");
INSERT INTO ssd_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Mara ande Kuate nu Abraham tuku ŋgamuŋgal son tagomba nu wika sana: Abraham ŋgina le nu woka sakina: Ye minet te ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Taŋakina le Kuate nu sana: Ne tiŋga naŋe kiŋo naŋe ndindo Isak ne nu tuku kume purte ta tumba kumba ka Moria kilke mbolŋge tabe ande ye ne tumnamŋgit ta mbolŋge ne ye tuku atrauka kiŋo ta balemba piya le ugmba usarkuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Taŋamba sana le Abraham nu maratukuk tiŋga kuaneka doŋki inum tumba saŋgilnu mbolŋge kumiŋ depolka kusmba nuŋe piro taŋgo armba kilmba atraukam tuku pa fetka ndaleka tumba Isak ndoŋ Kuate nu ma sakina ta kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Kumba minnaig le mara armba kinaig le mara keŋnu mbolŋge Abraham nu tiŋga mambilmba Kuate nu ma sakina ta maskenŋge kaŋgerna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","nuŋe piro taŋgo ar ta sanikina: Tale doŋki tumba teŋge minap. Ye yiŋe kiŋo ndoŋ kumba ambeŋge Kuate mbariŋmba nu tuku nyu te-duŋga maŋ luka ndekamkik ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Taŋaka sanikmba nu pa ndale ŋak tumba Isak tuna le kurana le Abraham nu pa wagmbi bagi turmba kilmba nale kigriŋga kinaik ");
INSERT INTO ssd_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","kumba ka ndinŋge Isak nu mam nuŋe wika sana: Mam o ŋgina le mam nuŋe ae ŋgina le Isak nu kusnana: Sile pa wagmbi pa ndale ŋak kilkik ta Kuate atraukam tuku sipsip fat aniŋge ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham lafumba sana: Kiŋo, Kuate nuŋe atraukam tuku sipsip fat ande sile sikamŋgat ŋgina. Taŋamba saka nale maŋ kigriŋga kinaik. ");
INSERT INTO ssd_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Nale Kuate nu ma sakina ta mbol pronaik sulumba Abraham nu ndame turŋaŋga pa laŋlaŋ wakeimba pa ndale ŋak ta kuklimba ta mbolŋge farna sulumba kiŋo nuŋe Isak kupe wai kusmba pa farna ta mbolŋge pilna. ");
INSERT INTO ssd_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Taŋana sulumba nu nuŋe kiŋo balewam saka bagi gomba tumba wai sukakina kande ");
INSERT INTO ssd_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Suŋgo tuku Eŋel samba mbolŋge wika sana: Abraham, Abraham ŋgina le nu woka sakina: Ye minet te ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Eŋelŋge nu sana: Kiŋo tuku ŋgarosu ŋayo sili ndawa. Ne naŋe kiŋo naŋe ndindo mape ndamba balemba ye atraukam bafuwat ta ye kaŋgerit. Ne ye tuku miŋge dubite ta ye kile kila pilit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Taŋakina le Abraham nu mbilka mambilmba meme pailnu ande ail fudiŋndo sinamŋge naunu konka minna le kaŋgerna sulumba kumba ka meme ta Isak tuku lafuknu tumba balemba Kuate atraukina. ");
INSERT INTO ssd_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Taŋana sulumba Abraham nu ma ta nyunu “Suŋgoŋge sine tursiŋgit” ŋgina. (Kile nane teŋenmba sakade: Suŋgo tuku tabe mbolŋge nu sine tursiŋgit ŋgade). ");
INSERT INTO ssd_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kile Suŋgo tuku Eŋel nu samba mbolŋge Abraham wi arnu sana: ");
INSERT INTO ssd_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Ye Suŋgo. Ne ye tuku miŋge dubimba naŋe kiŋo naŋe balemba ye atraukam bafuwat tukunu ye yiŋe nyu tambi pasa saŋgri pilewamŋgit ta ne isa. Ye siŋka ne mbolŋge wam mayenu kamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Yeŋge ne tuku ndare te-tugewi le samba mbolŋge mbai minig piyalŋge fulbul minig taŋaŋ suŋgomba mayok kaŋgaig. Ne tuku mbuŋ kat naŋe ŋgueu mbal ndoŋ kame bumba nane kile-ibeŋkamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Taŋgo kuasmbi ŋakmba nane ne tuku saka nane afu nyaro niŋge likamŋgaig. Ne ye tuku miŋge ismba dubiwat ta tuku ŋga sanet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Taŋakina le Abraham nale maŋ luka nuŋe piro taŋgo ar ta tugum pronaik sulumba nane luka Berseba tumbraŋ kinaig. Taŋamba Abraham nu Bersebaŋge minmba minna. ");
INSERT INTO ssd_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Taŋamba minnaig ma ma mara ande nane afu Abraham tugum promba sanaig: Milka nu maib naŋe Nahor tuku kiŋo 8 kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","22","Kiŋo mulum ta nyunu Us. Nu tuku mambo kat nuŋe ta nyu naŋgine Bus, Kemuel, Kesed, Haso, Pildas, Yidlaf, Betuel. Kemuel tuku kiŋo nuŋe Aram ŋga Abraham sanaig. ");
INSERT INTO ssd_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel nu Rebeka te-pilna. Milka nu kiŋo 8 ta Abraham maib nuŋe Nahor ndoŋ kile-patikinaik le ");
INSERT INTO ssd_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor nu nuŋe pino ande nyunu Reuma ndoŋ Teba, Gaham, Tahas, Maka nane kile-patikinaik. ");
INSERT INTO ssd_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara nu yar 127 ŋak minna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Kanan kilke Hebron tumbraŋŋge nu kumna. Nu kumna le Abraham nu wamdus tatrukina le nu kumba Sara tugumŋge malmbikina. ");
INSERT INTO ssd_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Malmbikina sulumba tiŋga piyo nuŋe tuku mindesiŋ ta kusremba Hit mbal tugum promba nane saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Ye tumbraŋ tuguk taŋgo kuga. Ye rawe taŋgo minet. Tane kilke ande ye sap le ye piyawi sulumba yiŋe pino ŋguki ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hit mbal nane lafumba Abraham sanaig: ");
INSERT INTO ssd_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","O taŋgo suŋgo, ne isa. Ne gabat suŋgo taŋaŋ sine ŋgamukŋge minit. Sine tuku ndame burok mayenu ndo ande kaŋgermba madiwa sulumba kumba ka piyo naŋe ŋguka. Ne piyo naŋe ŋgukam tuku ndame burok ande madiwa ta taŋgo andeŋge ne ŋgailne nda ŋga Abraham sanaig. ");
INSERT INTO ssd_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Taŋakinaig le Abraham nu Hit mbal ŋakmba tugumŋge loka saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","Tane son sakade ndeta tane Sohar tuku kiŋo nuŋe Efron sawap le nu nuŋe ndame burok nyunu Makpela nuŋe kilke make mbolŋge minit ta ye suwa le ye yiŋe pino ŋgukam tuku piyawi. Tane nu sawap le ndame burok ta tuku piyanu giganmba ta sakuwa le ye tane tuku am mbolŋge piyawi sulumba mindesiŋ ŋgunu tuku ti ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron nu Hit mbal tuku gabat ande minna. Nu nane ŋakmba ndoŋ tumbraŋ ta tuku fonde malaŋga tugumŋge minyok minna sulumba nu sakina: ");
INSERT INTO ssd_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","O taŋgo suŋgo, ne isa. Kilke sakat ta ndame burok turmba ye kile nane ŋakmba tuku am mbolŋge ne tinet. Ne piyo naŋe tumba kumba ka taŋge ŋguka ŋgina le nane ŋakmba isnaig. ");
INSERT INTO ssd_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kile Abraham ndek Hit mbal ŋakmba tugumŋge lokina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Efron sana: Ye pasa ande sanamŋgit ta ne isa. Ye kilke ta piyawi sulumba ndametiŋ ne tanmbimŋgit. Taŋawi sulumba ye yiŋe pino taŋge ŋgunuŋgit ŋgina le nane ŋakmba isnaig le ");
INSERT INTO ssd_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron lafumba Abraham sana: ");
INSERT INTO ssd_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","O taŋgo suŋgo, sile mbolŋge kilke te tuku piya ta suŋgokanu kuga. Soŋ 40 ndo. Ne kilke ta tumba kumba ka piyo naŋe ŋguka ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham nu pasa ta ismba ndametiŋ Efron sakina le Hit mbal nane ŋakmba isnaig ta nane piyade mbal ndametiŋ pitinu kaŋgerde ta kumumba Efron tuna. ");
INSERT INTO ssd_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Taŋamba Abraham nu Efron tuku kilke Makpela tumbraŋŋge Mamre tugumŋge minna ta tina sulumba kilke ta tuku ndame burok ail ŋakmba turmba kilna le ");
INSERT INTO ssd_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Hit mbal tumbraŋ ta tuku malaŋga tugumŋge minyok minnaig ta nane ŋakmba ismba wokinaig. ");
INSERT INTO ssd_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Taŋanaig le Abraham nu piyo nuŋe Sara tumba kumba ka Makpela kilke ndame burok ta sinamŋge pilna. (Ma ta Kanan tuku kilke mbolŋge Hebron tumbraŋ patukŋge minna). ");
INSERT INTO ssd_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Taŋamba Hit mbal tuku kilke ta ndame burok turmba mindesiŋ ŋgunu tuku Abraham tunaig. ");
INSERT INTO ssd_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Suŋgo tuku nyaro mara mindek Abraham mbolŋge minna le nu yar suŋgomba kusremba saibo pilna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","nuŋe piro taŋgo ambokok Abraham tuku agaŋ ndende kulatkina ta wika sana: Naŋe wai tumba ye tuku fel karaukŋge pale. ");
INSERT INTO ssd_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ne samba le kilke tuku Mbara Suŋgo nuŋe nyu tambi ne pasa saŋgri pilewa sulumba Kananŋge yiŋe kiŋo tuku pino ande ndata. ");
INSERT INTO ssd_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ne kumba ka yiŋe kilke tuguk ta mbolŋge yiŋe ndare tugumŋge Isak tuku pino ande ta ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","piro taŋgo taŋge ndek Abraham kusnana: Pino ta nuŋe kuasmbi kusreka ye dubiyam mbulwa ndeta ye kiŋo naŋe kukuli le nu naŋe tumbraŋ tuguk kuwa e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham lafumba sana: Taŋamba kuga. Ne ye tuku kiŋo kukula le kilke ta mbol ndakuwa. ");
INSERT INTO ssd_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Samba tuku Mbara Suŋgo nuŋge ye kukulyina le ye yiŋe ndare yiŋe tumbraŋ tuguk yiŋe kilke kusreken le nuŋge ye siŋka son pasa saŋgrinu teŋenmba sayina: Ne tuku ndare ye kilke te siŋka serniŋgamŋgit ŋga sayina. Nuŋge nuŋe eŋel kukulwa le amboŋga kaŋgat. Ne kumba taŋge yiŋe kiŋo tuku pino ande ta. ");
INSERT INTO ssd_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Pino ta ne dubinam mbulwa ndeta pasa ta ake ŋgisikuwa. Ne ye tuku kiŋo ta ndoŋ luka kilke ta mbol ndakape ŋga piro taŋgo nuŋe sana. ");
INSERT INTO ssd_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Taŋaka sana le piro taŋgo ta nuŋe gabat Abraham tugum promba wai tumba Abraham tuku fel karaukŋge pilna sulumba Abraham pasa sakina ta kumuwamŋgit ŋga wokina. ");
INSERT INTO ssd_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Taŋamba piro taŋgo ta nu Abraham tuku kamel 10 kilmba Abraham tuku agaŋ ndende magenu turmba kilna sulumba tiŋga Mesopotamia kilke Nahor tuku tumbraŋ ta kina kumba ka ka ta prona. ");
INSERT INTO ssd_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Prona sulumba kamel 10 ta saniŋgina le nane tumbraŋ kilimŋge kule burok ta tugumŋge mabta kinymba minnaig. Ki butuŋgina le furiram pino kame nane kule kunyam prowam bafunaig le ");
INSERT INTO ssd_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","taŋgo ta yabaŋmba sakina: O Suŋgo, yiŋe gabat Abraham tuku Mbara, ne kite yiŋe gabat Abraham idusmba ye turya. ");
INSERT INTO ssd_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ye kule burok te tugumŋge minet le tumbraŋ te tuku pino mbanzo kame nane kule kunyam prode. ");
INSERT INTO ssd_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ye pino ande teŋenmba sawamŋgit: Naŋe waim kule ŋak ta ye sa le ye nyi ŋga sawamŋgit. Pino ta nu sakuwa: Ne ilmba nya le ye ne tuku kamel kame tuku kule afu turmba kunyamŋgit ŋguwa ndeta ye katesewamŋgit. Ne pino ta naŋe piro taŋgo Isak tuku pino madina ŋga katesewamŋgit. Nu taŋakuwa le ne ye tuku gabat buk turat ta ye katesewamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Nu yabaŋmba minna le Betuel tuku kulim nyunu Rebeka nu kilke waim kuramba prona. (Rebeka mam nuŋe Betuel. Betuel nu Nahor le Milka tuku kiŋo nakile. Nahor nu Abraham tuku maib nuŋe). ");
INSERT INTO ssd_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeka nu ŋgarosu tumail pasi mayenu ndo. Nu buk taŋgo ande ndoŋ kinye ndakina. Nu ndeka kule burok ta tugum promba waim kule kunyna sulumba maŋ luka mbuna. ");
INSERT INTO ssd_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Taŋana le piro taŋgo ta nu pinderka nu tugum kina sulumba sana: Waim kule ta ye sa le ye kule nyi ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","nu ndek sana: O taŋgo suŋgo, ne ilmba nya ŋgina sulumba nu waim kule te-ibeŋmba biye ŋak minmba nu tuna le kule nyina. ");
INSERT INTO ssd_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nu kule nye deŋpurna le Rebeka nu sana: Ye ne tuku kamel kame tuku kule afu turmba kunyi le nane mata nyuwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Taŋakina sulumba nu pitik ndo nuŋe waim kule agaŋmor kule nyade tuku nza ta sinamŋge kutuna sulumba pinderka kumba ka kule burok tugum promba taŋgo ta tuku kamel kame tuku kule kunye niŋmba minna le kamel kame ta ŋakmba nyinaig le ");
INSERT INTO ssd_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","piro taŋgo ta nu ye Suŋgoŋge buk turyat e ŋga idusmba maninok pino ta kaŋgermba minna. ");
INSERT INTO ssd_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Nu kule kunye deŋpurna le taŋgo ta fumbe sikor ande golmbi wakeiwanu ta tumba nu tuku fumbe mbolŋge pilmba sagi armba golmbi wakeikanu ta turmba kilmba nu tuku wai mban mbolŋge siluk tuna sulumba sana: ");
INSERT INTO ssd_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ne saka. Ne mam naŋe ima? Mam naŋe tuku wandekŋge yiŋe kuasmbi ye ndoŋ sine kinyam tuku ma ŋak e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","nu sana: Ye tuku mam Betuel. Nu Nahor le Milka tuku kiŋo. ");
INSERT INTO ssd_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Sine ire suŋgomba kamel kinyam tuku ŋak. Kamel tuku nyamagaŋ mata suŋgomba minig. Tane mata kinyam tuku ma ŋak ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","taŋgo ta pasa ta ismba loka Suŋgo tuku nyu te-duŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","sakina: O Suŋgo, yiŋe gabat Abraham tuku Mbara, sine ne tuku nyu te-duŋgube. Ne mara mara ye tuku gabat turte. Neŋge ye mindeyumba ndin tumyat le ye yiŋe gabat tuku kuasmbi tugum prowit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kile pino ta pinderka ina nuŋe tuku wande mbol kumba pro taŋge nane wam kubeu niŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebeka tuku leu nuŋe Laban nu kulim nuŋe wam kubeu niŋgina ta isna sulumba fumbe tuku sikor ta kaŋgermba sagi ar kulim nuŋe tuku wai mban mbolŋge minnaik ta turmba kaŋgerka nu pitik ndo kilim ka Abraham tuku piro taŋgo kamel kame ndoŋ kule burok tugum taŋge minnaig ta sota kina sulumba sana: ");
INSERT INTO ssd_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Suŋgo tuku nyaro ne mbolŋge minit. Ne ndaŋam kilim teŋge tiŋ minit? Ne yale le sine wande mbol kab. Ye buk tane tuku ma wakeiwit. Ne tuku kamel kame tuku ma mata ŋak ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Taŋakina le piro taŋgo ta nu wande mbol kina le Laban nu kamel kame tuku kumiŋ depol kame ta paske lika ire farniŋgina sulumba nyamagaŋ kilmba pro niŋgina le nyinaig. Taŋanaig le Laban nu maŋ kumba Abraham tuku piro taŋgo, taŋgo kame nu ndoŋ promba minnaig ta tuku kule tumba luka prona le nane kupe minyaŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Taŋanaig le nane piro taŋgo ta tuku pagumba tunaig kande nu sakina: Ye pasa ande ŋak. Nyamagaŋ te minwa le ye pasatumba isukusamŋgit ŋgina le Laban ndek sakina: Ta maye. Saka le sine isbe ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Taŋakina le nu ndek sakina: Ye Abraham tuku piro taŋgo. ");
INSERT INTO ssd_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Suŋgoŋge ye tuku gabat nyaro mayenu tuna le nu maror taŋgo mayok kina. Nu Suŋgoŋge sipsip meme makau kamel doŋki silwa ndametiŋ, gol ndametiŋ, piro taŋgo, piro pino agaŋ ndende gudommba tuna. ");
INSERT INTO ssd_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Yiŋe gabat tuku pino Sara nu saibo pilmba Abraham tuku kiŋo te-pilna le nu nuŋe agaŋ ndende ta kiŋo nuŋe tuna. ");
INSERT INTO ssd_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Yiŋe gabat nu ye sayina le ye nu tuku pasa saŋgri pilewen. Nu teŋenmba sayina: Ne Kananŋge yiŋe kiŋo tuku pino ande ndata. ");
INSERT INTO ssd_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ne kumba yiŋe kuasmbi yiŋe ndare kame tugum kaye sulumba nane ŋgamukŋge yiŋe kiŋo tuku pino ande ta ŋga sayina le ");
INSERT INTO ssd_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ye ndek yiŋe gabat teŋenmba kusnawen: Pino ta ye dubiyam mbulwa ndeta ye ndaŋi ŋgen le ");
INSERT INTO ssd_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","nu lafumba sayina: Ye mara mara Suŋgo tuku miŋge dubiwet tuku. Nu nuŋe eŋel kukulwa le ne turnamŋgat. Taŋawa le ne ye tuku kuasmbi mbolŋge ye tuku ndare ŋgamukŋge yiŋe kiŋo tuku pino ande tamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ne ye tuku pasa saŋgri pilewat ta pur ndawa. Ne ye tuku kuasmbi tugum prowa le nane pino ta ne ŋgailnuwaig ndeta pasa ta ake ka ŋgisikuwa ŋga ye sayina. ");
INSERT INTO ssd_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ye kite kule burok tugum nziŋge prowit sulumba teŋenmba yabaŋit: O Suŋgo, yiŋe gabat Abraham tuku Mbara, ye ilit ta tuku agaŋ alonu te-mayokmba tumya le kaŋgeri. ");
INSERT INTO ssd_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ye kule burok te tugumŋge minet. Pino mbanzo ande kule kunyam prowa le ye nu teŋenmba sawamŋgit: Naŋe waim kule ŋak ta ye sa le ye nyi ŋga sawamŋgit. Pino ta nu sakuwa: ");
INSERT INTO ssd_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ne nya le ye ne tuku kamel kame tuku kule afu turmba kunyamŋgit ŋguwa ndeta ye katesewamŋgit. Pino ta neŋge yiŋe gabat tuku kiŋo nuŋe tuku pino madina ŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ye wamdusmbi yabaŋmba minit le Rebeka nu waim kuramba prowat sulumba ndeka kule burok sinam taŋge waim kule kunyat le ye nu sawit: Ye kule afu nyam ŋga sawit. ");
INSERT INTO ssd_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Taŋakit le nu pitik ndo waim te-ibeŋat sulumba sayat: Ne nya le ye ne tuku kamel kame tuku kule afu turmba kunyi ŋgat. Ye kule tumba nyit le nu kamel kame tuku mata kule kunyat. ");
INSERT INTO ssd_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Taŋawat le ye nu kusnawit: Ne mam naŋe ima ŋgit le nu sayat: Ye tuku mam Betuel. Nu Nahor le Milka tuku kiŋo ŋga sayat le ye fumbe sikor ta tumba nu tuku fumbe mbolŋge pilit sulumba sagi armba ta kilmba nu tuku wai mban mbolŋge patikit sulumba ");
INSERT INTO ssd_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","loka Suŋgo tuku nyu te-duŋgit. Nu yiŋe gabat Abraham tuku Mbara. Nuŋge ye mindeyumba ndin tumyat le ye yiŋe gabat tuku kuasmbi tugum prowit sulumba nzamu nuŋe tuku kulim kaŋgerit ta ye yiŋe gabat nu tuku kiŋo nuŋe tuku pinonu tamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ta tuku tane ye tuku gabat idusmba pino ta ye sam kumuŋ e ko kuga? Tugusemba ye sayap le ye isi sulumba ame maŋau kam tuku ta kila palmbimŋgit ŋga Laban nane saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Taŋakina le Laban nale Betuel ndoŋ lafumba sakinaik: Suŋgoŋge ne kukulnat le ne te prowat tukunu sine ame pasatube? Sine pasa kuga. ");
INSERT INTO ssd_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka minit te. Ne nu tumba kaye. Nu naŋe gabat tuku kiŋo nuŋe tuku pino minamŋgat. Ne Suŋgo tuku miŋge dubimba taŋamba ka ŋginaik le ");
INSERT INTO ssd_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abraham tuku piro taŋgo ta pasa ta ismba truk kumba Suŋgo tuku nyu te-duŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","mindepiyam tuku agaŋ ndende silwa golmbi wakeikinaig tuku tawi afu turmba kilmba Rebeka tuna sulumba agaŋ ndende magenu afu leu nuŋe nale ina nuŋe ndoŋ nikina. ");
INSERT INTO ssd_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Taŋana sulumba nu taŋgo kame nu ndoŋ pronaig ta nane ŋakmba isukusmba kule nyumba furirna le taŋge kinynaig. Mafena le maratukuk tiŋga nu nane saniŋgina: Ye kile luka yiŋe gabat sota kambimŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Rebeka leu nuŋe nale ina nuŋe ndoŋ sakinaik: Kulim te kusem ndindo ait 10 taŋamba sine ndoŋ minwa le tumba kape ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Taŋakinaik le nu ndek sanikina: Tane ye ŋgail ndakap. Suŋgoŋge ye turyina le alonu mayok ket tukunu ye dalke nda. Ye kile ndo maŋ luka yiŋe gabat sota kaŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Taŋakina le nale sakinaik: Sile kulim wika kusnawamkik ŋginaik sulumba ");
INSERT INTO ssd_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rebeka wika kusnanaik: Ne taŋgo te ndoŋ kambimŋgat e ŋginaik le nu sakina: Au. Ye kambimŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Taŋakina le Rebeka nuŋe kulat pino ndoŋ nale Abraham tuku piro taŋgo kame ndoŋ kambim bafunaig le ");
INSERT INTO ssd_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","nale Rebeka nyaro pasa tumba sakinaik: O sile tuku kulim, ne taŋgo kuasmbi suŋgokanu tuku ina naŋgine minwa. Ne tuku mbuŋ kat naŋe nane ŋgueu mbal ndoŋ kame bumba naŋgine tumbraŋ yaika kilwaig ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Taŋakinaik le Rebeka nuŋe piro pino mbanzo afu ndoŋ nane kamel poŋga mbolŋge minyokinaig le Abraham tuku piro taŋgo ta Rebeka tumba kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ait ta mbolŋge Isak nu Negeb ma baknu mbolŋge minna tuku. Mara ande nu kule burok nyunu “Suŋgo abo tugu ŋak nu ye kaŋgeryate” ta kusremba ");
INSERT INTO ssd_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","furiram tiŋtiŋka ake kaloymba kina sulumba mambilmba kamel afu promba ilnaig le kaŋgerkina. ");
INSERT INTO ssd_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka nu mambilmba Isak kaŋgermba kamel mbolŋge ibeŋ kina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Abraham tuku piro taŋgo ta kusnana: Taŋgo ilit si imaŋge ŋgina le piro taŋgo ta lafumba sana: Taŋgo si yiŋe gabat ŋgina le Rebeka nu kumiŋ tumba tumail pasi soŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Piro taŋgo ta promba nu maŋau kina ta ŋakmba Isak kubeu tuna le ismba ");
INSERT INTO ssd_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Rebeka tumba ina nuŋe Sara tuku baibai sinamŋge pilmba nuŋe pinonu tina. Taŋamba nu Rebeka tuku kume purna sulumba ina nuŋe buk kumna le nu ŋgamuŋgal tatruka minna ta kile nu garena. ");
INSERT INTO ssd_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham maŋ pino ande nyunu Ketura tina le ");
INSERT INTO ssd_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","nu Simran, Yoksan, Medan, Midian, Isbak, Sua nane kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan nu kiŋo armba kile-patikina ta ande Seba ande Dedan. Dedan tuku mbuŋ ta Asur mbal Letus mbal Leum mbal. ");
INSERT INTO ssd_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian nu kiŋo 5 kile-patikina. Nane tuku nyu ta teŋenmba. Efa, Efer, Hanok, Abida, Elda. Kiŋo kame ta ŋakmba Ketura tuku ndare. ");
INSERT INTO ssd_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham nu nuŋe agaŋ ndende ŋakmba Isak tuku wai mbolŋge kusrekina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","nuŋe kiŋo kat nuŋe pino afu ndoŋ kile-patike likina ta mata gare agaŋ afu niŋgina sulumba nane kukulniŋgina le kinaig. Abraham nu kume ndaka minna le nane Isak kusremba ki prote kumam kinaig ka taŋge minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham nu saibo pile mayemba yar 175 ŋak minna sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Kiŋo kat nuŋe ar ta Isak nale Ismael nale mam nakile tuku mindesiŋ tumba ka Makpela ndame burok ta sinamŋge nu tumba pilnaik. Ndame burok ta Abraham nu o buk piyo nuŋe Sara tumba pilna. Makpela kilke ta Mamre tugumŋge minna ta o buk Hitnu taŋgo Soar tuku kiŋo nuŋe Efron nu tuku kilke minna le Abrahamŋge nu tugumŋge piyana tuku. ");
INSERT INTO ssd_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham nu kumna le Kuate nu Abraham tuku kiŋo nuŋe Isak nyaro tuna le nu mine mayena. Nu kule burok nyunu “Suŋgo abo tugu ŋak nu ye kaŋgeryate” ta tugumŋge minna. ");
INSERT INTO ssd_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Sara tuku piro pino Isipnu Hagar nu Abraham ndoŋ Ismael te-pilnaik. ");
INSERT INTO ssd_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismael tuku kiŋo kat nuŋe ta teŋenmba. Kiŋo mulum ta nyunu Nebayot. Kiŋo afu nu dubimba pronaig ta nyu naŋgine teŋenmba. Kedar, Adbel, Mibsam, ");
INSERT INTO ssd_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO ssd_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafis, Kedema. ");
INSERT INTO ssd_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Nane ŋakmba Ismael tuku kiŋo kat nuŋe. Nane tuku ndare tugekinaig sulumba mbuŋ kat naŋgine tuku nyu ta tumba nane afu tumbraŋ yimyam ninde lika minnaig le nane afu ma yimyam mbol kine promba minnaig. Nane 12 ta tumbraŋ mboŋ 12 ta tuku gabat minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael nu yar 137 ŋak minna sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismael tuku mbuŋ kat nuŋe nane Awila tuku kilke Sur tuku kilke ma ŋgamu-ŋgamuŋge minnaig. (Ma ta Isip limba ki prote kumamŋge Asiria kambim tuku ndin ta tugumŋge minit). Nane Isak tuku mbuŋ kat nuŋe ndoŋ purka yimyam minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham tuku kiŋo nuŋe Isak tuku wam kube ta teŋenmba. ");
INSERT INTO ssd_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isak nu yar 40 ŋak minna sulumba Rebeka tina. Rebeka nu Aramnu Mesopotamia kilke mbolok pino. Mam nuŋe Betuel. Leu nuŋe Laban. ");
INSERT INTO ssd_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isak nu piyo nuŋe niŋkina le nu Suŋgo yabaŋna le Suŋgo nu tuku yabaŋ pasa ismba piyo nuŋe wakeina le kiŋo konna ta ");
INSERT INTO ssd_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","fuŋgul sinamŋge kiŋo armba ŋak. Kiŋo ar ta nale fuŋgul sinamŋge suŋgomba muŋgu signa-signaŋga minnaik le nu kamusmba wamdusmbi sakina: Ndaŋam tuku ye tuku kiŋo ar te muŋgu signa-signaŋga minik ŋgina. Taŋakina sulumba nu katesewam tuku Suŋgo kusnawam kina le ");
INSERT INTO ssd_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Suŋgoŋge nu sana: Kiŋo armba ne tuku fuŋgul sinamŋge minik ta kile-patika le nale tuku ndare tugeka taŋgo kuasmbi armba mayok ka nane purka yimyam minamŋgaig. Andeŋge ande tuku saŋgri liwamŋgat. Kiŋo mulum nu kiŋo ŋgumneŋgamŋgat ta tuku miŋge kumnemŋge minamŋgat ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rebeka nu kiŋo te-palmbim tuku ait kumuŋgina le nu kiŋo armba kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kiŋo mulum te-pilna ta ŋgarosu gurgurnu ŋgue kumuk. Ta tuku nane nyun ta Esau ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Nu dubiknu maib nuŋe nu Esau tuku kupe tugu biymba ŋak prona. Ta tuku nane nyun ta Yakob ŋginaig. Isak nu yar 60 ŋak minna le Rebeka nu nale ar ta kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nale sugokinaik sulumba Esau nu kanzerek taŋgo minmba nu mara mindek sayokam duŋe kambinu le Yakob nu taŋgo mukuknu minmba nu mara mindek tumbraŋŋge ndo minanu. ");
INSERT INTO ssd_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esau nu agaŋmor bale farmba mam nuŋe tambinu le kuapika nyumba minanu tukunu nu Esau tuku kume purna le Rebeka nu Yakob tuku kume purna. ");
INSERT INTO ssd_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ait ande Yakob nu pagumba minna le Esau nu duŋeŋge sayokmba minna sulumba guba mayena le luka tumbraŋ prona sulumba ");
INSERT INTO ssd_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Yakob sana: Kule pak gurgur ta ye inum sa le nyi. Ye guba mayeyumba isu baklelyumba am kuilkuilyate ŋgina. (Ta tuku nane nu tuku mape nyu ande kitek Edom ŋginaig). ");
INSERT INTO ssd_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Taŋakina le Yakob nu lafumba sakina: Ne kiŋo mulum tuku agaŋ ndende nyaro pasa ŋakmba ye samŋgat kande ye kule pak te ne tini le nya ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau nu ndek sakina: Ta maye. Ye guba mayeyate. Ye kumi le nyaro pasa ta ye turye nda. Kule pak ta ye inum sa le nyi ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakob ndek nu sana: Kuga. Amboŋga ne siŋka son pasa saŋgrinu ye saya ŋgina le Esau nu pasa ta saŋgri pilemba kiŋo mulum tuku agaŋ ndende ta Yakob tuna. ");
INSERT INTO ssd_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Taŋakina le Yakob nu kule pak bret afu turmba Esau tuna le nyina. Nyina sulumba nu tiŋga kina. Taŋamba Esau nu mulum maŋau ta ake agaŋ taŋaŋ ŋga bukŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","O buk Abraham tuku ait mbolŋge guba suŋgo prona taŋamba kile maŋ guba suŋgo prona le Isak nu Filistia mbal tuku gabat suŋgo Abimelek sota Gerar tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Taŋana le Suŋgo nu Isak tugum promba sana: Ne Isip kilke mbol ndakaye. Ne ye tuku miŋge dubimba kilke te mbolŋge ndo mina le ");
INSERT INTO ssd_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ye ne ndoŋ mini sulumba ne nyaro tanmbimŋgit. Kilke te ŋakmba ye ne naŋe ndare ndoŋ sertiŋgi sulumba siŋka son pasa buk mam naŋe Abraham sawen ta kumuwamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","5","Yeŋge ne tuku ndare te-tugewi le taŋgo pino gudommba samba mbolŋge mbai minig taŋaŋ mayok kuwaig le ye kilke te ŋakmba nane serniŋgamŋgit. Mam naŋe nu ye tuku miŋge dubina sulumba pasa ŋakmba nu sawen ta kumuna. Ta tuku taŋgo kuasmbi ŋakmba nane tane tuku saka nane naŋgine naŋgine afu nyaro niŋge likamŋgaig ŋga Isak sana. ");
INSERT INTO ssd_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isak nu Gerar tumbraŋŋge minna le ");
INSERT INTO ssd_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","tumbraŋ ta tuku taŋgo kame nane piyo nuŋe tuku Isak kusnanaig le nu nane saniŋgina: Pino te yiŋe kulim ŋgina. Rebeka nu tumail pasi ŋgarosu mayenu ndo tukunu nu taŋgo kame nane Rebeka tam tuku ye baleyamŋgaig ŋga idusmba kuru-kuruka pino te yiŋe pino ŋgam mbulna. ");
INSERT INTO ssd_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Taŋamba minnaig le mara ande Filistia mbal tuku gabat suŋgo Abimelek nu bubre malaŋgambi mambilna kande Isak nu Rebeka kire-kiremba minna le kaŋgerna. ");
INSERT INTO ssd_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kaŋgerna sulumba nu taŋgo afu kukulniŋgina le pro Isak tumba Abimelek tuku wande mbol kinaig le Abimelek nu sana: Ne ndaŋam saka pino ta yiŋe kulim ŋgina. Pino ta naŋe pino ŋga Isak sana le nu ndek sakina: Ye idusen ye taŋaki le nane ye baleyamŋgaig ŋga idusen ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Taŋakina le Abimelek nu sana: Ne ame maŋau sine mbolŋge kina tuku? Ye tuku taŋgo ande piyo naŋe ndoŋ kinyna kande neŋge sine une siŋgina kande ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Taŋakina sulumba Abimelek nu nuŋe mbal ŋakmba saniŋgina: Taŋgo andeŋge taŋgo te ko piyo nuŋe ŋayo siliwa ta nu kumamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Suŋgo tuku nyaro Isak mbolŋge minna le Isak nu agaŋ tumunu bareŋniŋgina ta yar ta mbolŋge nyamagaŋ suŋgomba pronaig le kaŋgerkina. ");
INSERT INTO ssd_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Taŋamba nu agaŋ ndende suŋgomba kilmba maror taŋgo mayok kina. ");
INSERT INTO ssd_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Nu sipsip makau piro mbal suŋgomba ŋak minna le Filistia mbal nane nu kaŋgermba am kikoŋ tiŋginaig le ");
INSERT INTO ssd_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","nane kule burok kame mam nuŋe Abraham kume ndakina le nuŋe piro taŋgo kameŋge sarke likinaig ta luka kilke kainiŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Taŋanaig le Abimelek nu Isak sana: Ne taŋgo suŋgo nyu ŋak. Ne sine ŋakmba lisiŋgit. Ne sine tuku kilke te kusremba kaye ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Taŋakina le Isak nu ma ta kusremba Gerar tuku ma gutoŋ ta mbol kina sulumba taŋge nane baibai patika minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Taŋamba minnaig ma ma Isak nane kule burok kame mam nuŋe Abraham tuku ait mbolŋge sarke likinaig le Filistia mbalŋge luka kilke kainiŋginaig ta maŋ luka sarke likinaig. Sarke likinaig sulumba Isak nu mam nuŋe kule burok ta buk nyu patike likina ta taŋamba maŋ nyu ndui ta ndo patike likina. ");
INSERT INTO ssd_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Taŋamba Isak tuku piro taŋgo nane ma gutoŋ taŋge burok inum maŋ sarkinaig le kule bulbulmba prona. ");
INSERT INTO ssd_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Prona le Gerar tumbraŋ tuku agaŋmor kulat taŋgo nane Isak tuku kulat taŋgo kame ndoŋ kualeyauka kame pasa tumba minnaig sulumba sakinaig: Kule burok te sine tuku ŋginaig. Ta tuku Isak nu kule burok ta nyun ta Kame Pasa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kile Isak tuku piro taŋgo nane maŋ burok inum sarkinaig le kame pasa maŋ tiŋgina. Ta tuku Isak nu kule burok ta nyun ta Muŋgu Gubra ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Taŋamba nu ma ta kusremba ma ande mbol kina sulumba burok inum sarkina le kile kame pasa pro ndana tukunu Isak nu kule burok ta nyun ta Mine Mayenu ŋgina. Taŋakina sulumba sakina: Suŋgoŋge kilke suŋgokanu siŋgina le sine mine mayewamŋgig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kile Isak nu ma ta kusremba Berseba tumbraŋ prona le ");
INSERT INTO ssd_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","furir ŋgamu Suŋgo nu nu tugum promba sana: Ye mam naŋe Abraham tuku Mbara. Ne kuru kuru ndaka. Ye ne ndoŋ minmba siŋka son pasa buk mam naŋe Abraham sawen ta kumuwi sulumba yeŋge ne tuku ndare te-tugewi le taŋgo pino suŋgomba mayok kaŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Taŋakina le Isak nu ndame turŋaŋga atraukam tuku pa laŋlaŋ wakeina sulumba Suŋgo mbariŋmba nu tuku nyu te-duŋgina. Taŋamba nane taŋge baibai patika minnaig le nu tuku piro taŋgo kame nane maŋ kule burok ande sarkinaig. ");
INSERT INTO ssd_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelek nu Ahusat le kame gabat Pikol ndoŋ nane Gerarŋge Isak sota pronaig. (Ahusat nu kame ait mbolŋge nu Abimelek wam paguwanu taŋgo). ");
INSERT INTO ssd_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Nane pronaig le Isak nu nane kaŋgerka kusnaniŋgina: Tane buk ye kasuryumba pitaiyinaig. Tane kile ndaŋam tuku ye tugum prode ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","nane nu sanaig: Suŋgo nu ne ndoŋ minit ta sine kila. Ta tuku sine ne ndoŋ wamdus ulendiwam proweg. Ne pasa saŋgri pilemba ");
INSERT INTO ssd_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","sine mbolŋge maŋau ŋayonu ande ndaka. Sine mata buk ne mbolŋge maŋau ŋayonu ande ndakigeŋ. Sine ne mbolŋge maŋau mayenu kumba mine mayegeŋ le ne sine kusreka kina. Kile Suŋgo tuku nyaro ne mbolŋge minit ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Taŋakinaig le nu nane tuku paguna le nane nyinaig. ");
INSERT INTO ssd_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mafena le nane pasa katmba ŋgamuŋgal tumanaig sulumba nane kinaig le Isak nu nane mindeka ndinŋge mbilniŋgam kina. ");
INSERT INTO ssd_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ki ait ndui ta mbolŋge ndo Isak tuku piro taŋgo kame nane pro kule burok ande sarkinaig ta tuku Isak kila samba sanaig: Sine buk kule inum kaŋgergig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","nu kule burok ta nyun ta Seba ŋgina. Ta tuku tumbraŋ ta kile Berseba tumbraŋ ŋgade. ");
INSERT INTO ssd_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau nu yar 40 kusremba Hitnu pino armba kilna. Pino ar ta ande Yudit ande Basemat. (Yudit nu Beri tuku kulim nuŋe. Basemat nu Elon tuku kulim nuŋe). ");
INSERT INTO ssd_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Esau nu pino ar ta kilna le Isak nale Rebeka ndoŋ nale pino ar ta tuku ŋgamuŋgal piti ŋak minnaik. ");
INSERT INTO ssd_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isak nu saibo pilmba am tukulok minna le nu kiŋo nuŋe mulum Esau wika sana: Mam o ŋgina le nu ndek sakina: Ye minet te ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Taŋakina le mam nuŋe nu sana: Ye buk saibo pilmba kumam tuku ait patukate ta ne kila. ");
INSERT INTO ssd_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ne kile tui tumba duŋe kumba ye tuku agaŋmor ande ŋguikok balewe sumba ");
INSERT INTO ssd_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ye nzaliyate taŋamba pagumba tumba pro ye sa le ye nyumba nyaro pasa ne tini sulumba ye kumi ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isak nu Esau wam pagumba minna le Rebeka nu kagmamba ismba minna. Esau nu sayokam kina le ");
INSERT INTO ssd_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka nu kiŋo nuŋe Yakob sana: Mam naŋe aba naŋe Esau ndoŋ pasataik le ye isit. ");
INSERT INTO ssd_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Nu teŋenmba aba naŋe sawat: Ne agaŋmor ande balemba ye tuku pagumba tumba pro ye sa le ye nyumba Suŋgo am mbolŋge nyaro pasa ne tini sulumba ye kumi ŋga sawat. ");
INSERT INTO ssd_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ta tuku kiŋo, ne kile ye isa sulumba ame wam kam tuku sani kande ne kumu-kumuwa. ");
INSERT INTO ssd_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ne agaŋmor tuku fonde ta sinam kaye sulumba meme fatnu armba butuknu kilmba ye tugum te prowa le mam naŋe nzalite taŋamba paguwi le ");
INSERT INTO ssd_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ne tumba ka mam naŋe tawe. Mam naŋe nyamagaŋ ta nyumba nuŋe nyaro pasa ta ne tinwa sulumba nu kumwa ŋga Yakob sana. ");
INSERT INTO ssd_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Taŋakina le Yakob ndek ina nuŋe sana: Ye tuku aba Esau nu ŋgue kumuk. Ye ŋgarosu basleŋnu. ");
INSERT INTO ssd_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mamŋge ye kireyuwa sulumba ye nu yabriwi ta nu kateseyumba ye nyaro pasa se nda. Nu ye kasuryumba ŋguspeyamŋgat ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ina nuŋe nu sana: Kiŋo, nu taŋawa ndeta kasur pasa ta ye mbolŋge minamŋgat. Ne kile ndo pasa ne sanit ta kumumba ka meme sakit ta kilmba yale ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Taŋakina le Yakob nu kumba meme armba ta kilmba ilmba ina nuŋe tuna le ina nuŋeŋge mam nuŋe nzalina taŋamba paguna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Esau tuku tawi mayenu ndo wande mbolŋge minna tuku ta tumba Yakob tuna le silikina. ");
INSERT INTO ssd_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Silikina le Rebeka nu meme ŋgaronu kilmba Yakob tuku wai mbolŋge ŋinfok basleŋnu ta mbolŋge turmba patikina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","nyamagaŋ kikoŋnu kuapikina ta tumba bret piyna ta turmba tumba Yakob tuna. ");
INSERT INTO ssd_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Taŋana le Yakob nu mam nuŋe tugum kina sulumba sana: Mam a ŋgina le mam nuŋe woka sakina: Ae ne kiŋo ima e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakob nu sakina: Ye kiŋo naŋe mulum Esauŋge. Ne pasa sakat ta ye ne tuku miŋge kumuwit. Ne ndem ye kilmba prowit te nya sulumba ye nyaro pasa sa ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","mam nuŋe nu sana: O kiŋo, ne ndaŋmba pitik ndo agaŋmor te-silikat ŋgina le Yakob nu lafumba sana: Ne tuku Mbara Suŋgo nuŋge ye turyat le ye agaŋmor inum te-silikit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Taŋakina le mam nuŋe nu sana: Ne dirka ye tugum te yale le ye ne kireni. Ne sonndo Esau e ko kuga ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","nu dirka mam nuŋe tugum kina le mam nuŋe nu kiremba sakina: Ne tuku ŋin tugu Yakob tuku ŋin tugu taŋaŋ ta wai Esau tuku wai taŋaŋ ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ta ndaŋam? Yakob tuku wai ta Esau tuku wai taŋaŋ ŋgue kumuk tukunu Isak nu ŋginŋganka Yakob kila pile ndakina sulumba nu Yakob nyaro pasa tambim bafumba ");
INSERT INTO ssd_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","nu maŋ lato kusnana: Ne sonndo Esauŋge e ŋgina le au ye nuŋge ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Taŋakina le mam nuŋe nu sana: Ndem kilmba prowat ta ye sa le ye nyi. Ye isukuse deŋpurmba ne nyaro pasa sani ŋgina. Taŋakina le Yakob nu nyamagaŋ tumba mam nuŋe tuna sulumba nu grep kule tumba turmba mam nuŋe tuna le nyina. ");
INSERT INTO ssd_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nyina sulumba mam nuŋe ndek nu sana: Kiŋo, ne ilmba ye mumuya ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","nu dirka mam nuŋe tugum kumba nu mumuna. Taŋana le nu tawi mundur ta kamusmba nyaro pasa tuna sulumba sakina: Yiŋe kiŋo tuku tawi te piro ande Suŋgoŋge nyaro tuna le mundur mayete taŋamba mundurkate. ");
INSERT INTO ssd_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kuateŋge sakuwa le mbai ŋgislu ne tuku piro mbolŋge minwa le nyamagaŋ suŋgomba prowamŋgaig. Nu wit, grep suŋgomba ne tanmbimŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kuasmbi suŋgomba ne naŋe mbuŋ kat naŋe ndoŋ kumnemŋge sanzalnu piroka minamŋgaig. Tane taŋgine tira kame tuku gabat minap le nane tane kumnemŋge minamŋgaig. Nane afu tane kasurtiŋguwaig ta Kuateŋge mata nane kasurniŋgamŋgat. Nane afu tane nyaro tiŋguwaig ta Kuateŋge mata nane nyaro niŋgamŋgat ŋga Yakob sana. ");
INSERT INTO ssd_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak nu nyaro pasa saka deŋpurna le Yakob nu mam nuŋe kusremba kina le kile ndo aba nuŋe Esau duŋeŋge luka prona. ");
INSERT INTO ssd_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nu mata nyamagaŋ mayenu kikoŋnu kuapika tumba mam nuŋe tugum promba sana: Mam, ne ndem ye tumba prowit te tumba nya sulumba ye nyaro pasa sa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Taŋakina le mam nuŋe nu kusnana: Ne imaŋge ŋgina le nu lafumba sana: Ye ne tuku kiŋo naŋe mulum Esauŋge ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","mam nuŋe ndek pirerek purka sakina: i ... Imaŋge amboŋga ye tuku agaŋmor inum balemba kuapika tumba prowat le ye nyit? Ye buk nyit le ne prote. Ye buk nyaro mayenu ta nu tuwit. Nyaro pasa ta nduiye nu mbolŋge minamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Taŋaka sana le Esau nu pasa ta ismba ŋgamuŋgal ŋayoŋgina le suŋgomba mindesimba sakina: Mam, nyaro pasa ande ye sa ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","mam nuŋe nu sana: Mambo naŋe promba ye yabriyat le ye nyaro pasa ne tanmbim tuku ta nu tuwit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau ndek sakina: Nu kile buk ye yabriyam aryate. Nu tuku nyu Yakob ŋgade ta kumumbi. Amboŋga nu kiŋo mulum tuku agaŋ ndende ta kilna. Kile maŋ ye tuku nyaro mayenu tat. Nyaro pasa inum ye sam tuku mine ndakate e ŋgina ");
INSERT INTO ssd_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","le mam nuŋe nu sana: Ye buk nyaro pasa nu tuwit le nu ne tuku gabat minwa le ne nu tuku kumnemŋge minamŋgat. Nu tuku tira kame mata nu kumnemŋge sanzal minamŋgaig. Ye buk wit le grep ŋakmba nu tuwit. O kiŋo, ye kile ne mbolŋge maŋau ande kam kumuŋ kuga ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Taŋakina le Esau nu maŋ saŋgri tiŋga mam nuŋe sarsarmba sana: Mam, ne nyaro pasa ndindo not ndo e? Ye mata nyaro pasa inum sa ŋgina sulumba nu suŋgomba malmbikina le ");
INSERT INTO ssd_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","mam nuŋe nu sana: Mbai ŋgislu ne tuku piro mbolŋge nde ndakuwa le nyamagaŋ suŋgomba prowe nda. ");
INSERT INTO ssd_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ne mbuŋ kat naŋe ndoŋ tane kame bumba nyamagaŋ kilmba nyamgaig. Tane mambo naŋe tuku mbuŋ kat nuŋe kumnemŋge sanzal minamŋgaig. Tane saŋgri tiŋgap ta taŋgine saŋgrimbi minamŋgaig ŋga Esau sana. ");
INSERT INTO ssd_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau nu mam nuŋeŋge Yakob nyaro pasa tuna le nu Yakob kasurmba gubra tumba ndek sakina: Mam kumam tuku ait buk patukate. Nu kumwa le nu tuku kuamel minmba ta kugawa le ye Yakob balewamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","taŋgo ande nu Esau pasatina ta kagmamba minna sulumba kumba ka Rebeka sana le nu taŋgo ande kukulna le kumba Yakob sana le prona. Prona le Rebeka nu sana: Kiŋo, ne isa. Aba naŋe Esauŋge ne maŋau nu mbolŋge kat ta lafumba ne balenam sakate. ");
INSERT INTO ssd_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ta tuku ne kile ye isa. Ne pateŋ tiŋga ŋga naŋe Laban sota Haran kaye ");
INSERT INTO ssd_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","kumba ka taŋge ŋga naŋe ndoŋ mina le aba naŋe ŋgamuŋgal mukuwa le ");
INSERT INTO ssd_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","maŋau ne nu mbolŋge kat ta gilaiŋguwa le ye taŋgo ande kukuli le ne tam prowamŋgat. Kuga ta ye tuku kiŋo tale arŋeŋ ait ndindo mbolŋge kumamŋgaik ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Taŋakina sulumba Rebeka nu Isak tugum kumba sana: Esau nu Hitnu pino armba kilna tukunu ye nale kaŋgerka kanyum mayeyate. Yakob nu mata Hitnu pino ande tuwa ta ye abo minam para ndayikat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Taŋakina le Isak nu Yakob wika wam pagu pasa sana: Kiŋo, ne Kanan pino ande ndata. ");
INSERT INTO ssd_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ne tiŋga wa naŋe Betuel tuku kuasmbi sota Mesopotamia kilke mbol kaye sulumba taŋge ŋga naŋe Laban tuku kulim ande ta. ");
INSERT INTO ssd_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kuate Saŋgri Ŋayo nuŋge kuwa le ne tuku ndare tugeka taŋgo pino gudommba mayok kuwaig le ne kuasmbi suŋgomba tuku mbuŋ naŋgine minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kuate o buk wa naŋe Abraham nyaro tuna taŋamba kile ne naŋe mbuŋ kat naŋe ndoŋ mata nyaro tiŋguwa le ne buk Kuateŋge wa naŋe Abraham kilke serna le ne rawe taŋgo taŋaŋ minyokate ta yaika minyokap ŋga Yakob sana. ");
INSERT INTO ssd_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Taŋamba Isak nu Yakob kukulna le ŋga nuŋe Laban sota Mesopotamia kilke mbol kina. Laban nu Aramnu taŋgo Betuel ta tuku kiŋo nuŋe. Laban tuku kulim Rebeka nu Yakob le Esau tuku ina nakile. ");
INSERT INTO ssd_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Isak nu Yakob nyaro pasa tumba nu Kanan pino ande ndatuwa ŋga wam pagu pasa sana sulumba nu kukulna le nu ina mam nuŋe tuku miŋge dubimba pino tam tuku Mesopotamia kilke mbol kina le Esau nu wam ta kila pilna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","mam nuŋe Isak nu Kanan pino tuku nzali kuga ta kamusmba ");
INSERT INTO ssd_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","nu nzamu nuŋe Ismael sota kina sulumba Ismael tuku kulim Mahalat pinonu tina. Ismael nu Abraham tuku kiŋo ande. Ismael tuku kulim ande nyunu Nebayot. ");
INSERT INTO ssd_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakob nu Berseba kusremba Haran kambim tuku ŋga kumba ");
INSERT INTO ssd_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","tukul ma ande mbol promba furirna le ndame ande tumba gabat tatu pilmba nu kinyna. ");
INSERT INTO ssd_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nu kinyna sulumba nu kiŋata mbili ande kuen ŋayo ndumornu samba mbolŋge tugunu kilke mbolŋge tiŋgina ta kaŋgerna. Mbili ta mbolŋge Kuate tuku eŋel kame muŋgu lilika minnaig le kaŋgerkina. ");
INSERT INTO ssd_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Taŋana le Suŋgo nu nu tugum taŋge mayok ka ndek sana: Ye wa naŋe Abraham mam naŋe Isak tuku Mbara Suŋgo. Ne kinymba minit kilke te ta ye ne naŋe mbuŋ kat naŋe ndoŋ sertiŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ne tuku ndare tugeka kilke mbolŋge tub tub minig taŋawamŋgaig. Ma ŋakmba tugeka kumuŋge likamŋgaig. Taŋawaig le taŋgo kuasmbi ŋakmba tane tuku saka nane naŋgine naŋgine afu nyaro niŋge likamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ye siŋka sanet. Ye ne ndoŋ mara mindek minmba mini sulumba ne kigraibkamŋgit. Ne ma aniŋge minamŋgat ta ye ne ndoŋ mini sulumba ŋgumneŋga maŋ tumba luka te prowamŋgit. Ye pasa te kumumba ne kusrene nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Taŋakina le Yakob nu aboŋga sakina: Ake ma ŋgamuŋge ye kinyit ŋga idusit ta Suŋgo nu ma te mbolŋge minit ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","nu piriri ŋayomba kuru-kuruka sakina: Ma te tukul ma ande. Kuate minit tuku ma. Samba malaŋga teŋge minit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mafena le maratukuk tiŋga Yakob nu ndame gabat tatu pilna ta tumba kilke mbolŋge te-timba gureŋ manza ŋak ndame ta mbolŋge kutuna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ma ta nyunu Betel ŋgina. (O buk nyunu minna ta Lus). ");
INSERT INTO ssd_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Taŋaka sakina sulumba nu Kuate ndoŋ pasa katmba sakina: O Suŋgo, ne ye ndoŋ minmba ye kigraibka sulumba nyamagaŋmbi tawimbi ye turyumba ");
INSERT INTO ssd_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ne maŋ ye tumba luka mam tuku tumbraŋ tuguk prowa ndeta ne ye tuku Mbara Suŋgo mina le ye ne tuku miŋge kumnemŋge minamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ndame te-tiwit ma te ne tuku nyu te-duŋgam tuku ma minamŋgat. Ne agaŋ ndende ŋakmbambi ye turya ta ye agaŋ ndende ta maŋgur 10 patika ande tumba ne tanmbimŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakob nu maŋ tiŋga ki prote kumam kina ka ");
INSERT INTO ssd_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ma baknu mbolŋge kule burok ande tugum prona. Kule burok ta tugumŋge sipsip kuaŋ keŋmba kinymba minnaig le kaŋgerkina. Tumbraŋ ta tuku sipsip kulat taŋgo nane kule burok ta sipsip kule niŋganu ta ndame suŋgo ande tumba kule burok ta tukulanu. ");
INSERT INTO ssd_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tumbraŋ ta tuku sipsip furiram ŋakmba ta prowanu le sipsip kulat taŋgo nane ndame ta barimba talka sipsip kule niŋganu. Nane kule nye deŋpuranu le nane ndame ta maŋ tumba luka kule burok ta tukulanu. ");
INSERT INTO ssd_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Kile Yakob nu sipsip kulat taŋgo kame ta kusnaniŋgina: Tira kame, tane anikok ŋgina le nane nu sanaig: Sine Harannu ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Taŋakinaig le nu ndek nane saniŋgina: Tane Nahor tuku kiŋo nuŋe Laban tane kila e ŋgina le nane lafumba sanaig: Au. Sine kila ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","nu nane kusnaniŋgina: Nu maye minit e ŋgina le nane nu sanaig: Au. Nu maye minit. Ai si. Kulim nuŋe Rahel mam nuŋe tuku sipsip kilmba ilit si ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakob nu ndek nane saniŋgina: Ki mbolŋge minit te tane ndaŋam sipsip kile sinam kambim bafude? Tane sipsip kame kule niŋmba kilmba kape le nyamagaŋ sota nyuwaig ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","nane nu sanaig: Sineŋge ndo maŋau ta kam kumuŋ kuga. Nane ŋakmba sipsip kilmba prowaig le sine ndame suŋgo si barimba talkube sulumba sipsip kame kule niŋgamŋgig ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob nu nane ndoŋ pasata minna le Rahel nu sipsip kilmba prona. ");
INSERT INTO ssd_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakob nu Rahel kaŋgermba ŋga nuŋe Laban tuku sipsip turmba kaŋgerkina sulumba kule burok ta tugum kumba ndame suŋgo ta barimba talkumba sipsip kame ta kule niŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Taŋamba nu nuŋem nuŋe Rahel mumumba gare tormba malmbikina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","nu sana: Mam naŋe ta ye tuku ŋga. Kulim nuŋe Rebeka ta yiŋe ina ŋgina. Taŋaka sana le nu pinderka mam nuŋe sota kina le ");
INSERT INTO ssd_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","mam nuŋe Yakob prona pasa ta ismba nu pinderka ŋga nuŋe te-silika bagailmba mumuna. Taŋamba nu ŋga nuŋe tumba wande mbol kinaik. Yakob nu ŋga nuŋe ndoŋ maŋau ŋakmba kina ta kubeu tuna le ");
INSERT INTO ssd_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban nu ismba sana: Son. Ne siŋka ye tuku ndare ŋgina. Taŋakina le Yakob nu tambun ndindo ŋga nuŋe ndoŋ minna. ");
INSERT INTO ssd_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","17","Laban nu kulim armba ŋak minna. Kulim mulum ta nyunu Lea. Mambo nuŋe nyunu Rahel. Lea nu am magenu kuga ta Rahel nu pino ŋgarosu tumail pasi mayenu ndo. Kile Laban nu Yakob sana: Ne ake pirokate ta ŋayo. Ne yiŋe ndare. Ne mata piya fudiŋ tam tuku. Ne saka. Ne ame piya tam tuku iduste ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakob nu Rahel tuku nzali suŋgokanu ŋak minna tukunu nu ŋga nuŋe sana: Ye yar 7 ne tuku piro taŋgo mini sulumba kulim naŋe Rahel tamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban nu lafumba sana: Ta maye. Ye tuku kulim neŋge tamŋgat. Ye taŋgo ande tambim tuku idus ndawet. Ne ye ndoŋ piroka mina ŋga Yakob sana. ");
INSERT INTO ssd_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Taŋakina le Yakob nu Rahel tam tuku yar 7 ŋga nuŋe tuku piro taŋgo taŋaŋ minna ta nu Rahel tuku nzali suŋgokanu ŋak minna tukunu yar 7 ta ait armba ko keŋmba taŋaŋ ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ait ta kumuŋgina le Yakob nu ŋga nuŋe sana: Ne ait sakina ta kile kumuŋgat. Ye kile kulim naŋe tamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Taŋakina le Laban nu nale muŋgu kilam tuku nane ŋakmba wikina sulumba pagumba nye suŋgokina. ");
INSERT INTO ssd_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Isukuse deŋpurmba furir ta mbolŋge Laban nu Lea tumba Yakob tugum kina le nu Lea tumba nu ndoŋ kinynaik. ");
INSERT INTO ssd_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Laban nu nuŋe piro pino Zilpa tumba kulim nuŋe Lea tuna). ");
INSERT INTO ssd_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mafena le Yakob nu Lea tunaig ta kaŋger timba nu kumba ka mbiyel nuŋe Laban tugum kumba sana: Ne ndaŋam saka maŋau te ye mbolŋge kat? Rahel tam tuku ye piroken ta ndaŋam saka ne ye yabriyumba Lea sat ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ndek lafumba nu sana: Sine tuku maŋau ta kulim mulum ta aboŋga taŋgo tuweg tuku. ");
INSERT INTO ssd_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tale muŋgu kilnaik tuku kusem mineg ait 7 te kugawaig le ye ne Rahel tini le ne maŋ lato yar 7 ye tuku piro taŋgo taŋaŋ mina ŋga Yakob sana. ");
INSERT INTO ssd_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Taŋakina le Yakob nu wokina le muŋgu kilnaik tuku kusem ta ka kugana le Laban nu kulim nuŋe Rahel tumba Yakob tuna. ");
INSERT INTO ssd_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Laban nu nuŋe piro pino Bila tumba kulim nuŋe Rahel tuna). ");
INSERT INTO ssd_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakob nu Rahel ndoŋ kinymba Rahel tuku kume purmba Lea tuku kume pur ndana. Taŋamba nu maŋ lato yar 7 Laban tuku piro taŋgo taŋaŋ minna. ");
INSERT INTO ssd_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yakob nu Lea tuku kume pur ndana ta Suŋgo nu katesemba Lea turna le kiŋo afu kile-patikina le Rahel nu niŋka kiŋo kugatok minna. ");
INSERT INTO ssd_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea nu fuŋgul ŋakna sulumba kiŋo ande te-pilmba sakina: Suŋgo nu ye tuku piti kaŋgerna. Kile yiŋe taŋgo nu ye tuku kume puramŋgat ŋgina. Taŋakina sulumba nu kiŋo ta nyunu Ruben ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea nu maŋ fuŋgul ŋakna sulumba kiŋo ande te-pilmba sakina: Yiŋe taŋgo nu ye tuku kume pur ndate ta Suŋgo nu ismba kiŋo te turmba ye sat ŋgina. Taŋakina sulumba nu kiŋo ta nyunu Simeon ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nu maŋ lato fuŋgul ŋakna sulumba kiŋo ande te-pilmba sakina: Kile yiŋe taŋgo nu ye ndoŋ sailkamŋgat. Ye kile buk nu tuku kiŋo keŋmba kile-patikit ŋgina. Taŋakina sulumba nu kiŋo ta nyunu Levi ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Kile nu maŋ lato fuŋgul ŋakna sulumba kiŋo ande te-pilmba sakina: Ye kile Suŋgo tuku nyu te-duŋgamŋgit ŋgina sulumba kiŋo ta nyunu Yuda ŋgina. Taŋakina sulumba nu maŋ lato kiŋo ande te-pile ndakina. ");
INSERT INTO ssd_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rahel nu Yakob tuku kiŋo ande te-pile ndakina tukunu nu aba nuŋe tuku tirakina sulumba Yakob sana: Ne ye kiŋo ande nda te-sa ta ye kumamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Taŋakina le Yakob nu Rahel ndoŋ gubrana sulumba sana: Ye Kuate tuku ma tam kumuŋ kuga. Nuŋge ne kiŋo ŋgailnate ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","nu ndek sakina: Ai te. Ye tuku piro pino Bila minit te. Ne nu ndoŋ kinyap le nu ye tuku kiŋo ande te-pile suwa. Taŋawa le ye kiŋo ŋak mini ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Taŋakina sulumba nu Bila tumba taŋgo nuŋe tuna le nu nu ndoŋ kinynaik. ");
INSERT INTO ssd_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Taŋamba Bila nu fuŋgul ŋakna sulumba Yakob tuku kiŋo ande te-pilna le ");
INSERT INTO ssd_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahel nu ndek sakina: Kuate nu maŋau tiŋreknumbi ye turyat. Nu ye tuku yabaŋ pasa ismba kiŋo ande ye sat ŋgina sulumba nu kiŋo ta nyunu Dan ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Taŋamba minnaig ma ma Bila nu maŋ fuŋgul ŋakna sulumba Yakob tuku kiŋo arnu te-pilna le ");
INSERT INTO ssd_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahel ndek sakina: Ye yiŋe aba ndoŋ taŋgo piraibkek ta kile ye nu te-ibeŋit ŋgina. Taŋakina sulumba nu kiŋo ta nyunu Naftali ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea nu maŋ kiŋo ande te-pile nda ŋga katesemba nu nuŋe piro pino Zilpa tumba Yakob pinonu tuna. ");
INSERT INTO ssd_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Taŋana le Zilpa nu Yakob ndoŋ kinynaik sulumba nu tuku kiŋo ande te-pilna le ");
INSERT INTO ssd_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea nu sakina: Ye yiŋe mambo liwit ŋgina sulumba nu kiŋo ta nyunu Gat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Taŋamba minnaig ma ma Zilpa nu maŋ Yakob tuku kiŋo ande te-pilna le ");
INSERT INTO ssd_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea nu sakina: Ye siŋka gare suŋgo tet. Pino kame ŋakmba nane sanuŋgaig: Pino ta gare suŋgo ŋak minit ŋga sanuŋgaig ŋgina. Taŋaka nu kiŋo ta nyunu Aser ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Wit alonu kilam tuku ait mbolŋge Ruben nu piro mbol kumba ail waŋe afu kilna ta kumba ka ina nuŋe Lea tuna le Rahel nu ndek aba nuŋe sana: Naŋe kiŋo naŋe tuku ŋgirman agaŋ ta inum ye sa ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","aba nuŋe nu lafumba sana: Ne buk ye tuku taŋgo tina ta kile ne maŋ yiŋe kiŋo tuku ŋgirman agaŋ te kilam sakate ŋgina le Rahel lafumba nu sana: Ne ŋgirman agaŋ ta inum ye sa ta ne furir Yakob ndoŋ kinyamŋgaik ŋgina le Lea nu wokina. ");
INSERT INTO ssd_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Furiram bafuna le Yakob nu piro mbolŋge prona le Lea nu tugum kumba sana: Furir te ne ye ndoŋ kinyamkik. Ye yiŋe kiŋo tuku ŋgirman agaŋ tambi ye ne piyanit ŋgina. Ta tuku Yakob nu furir ta mbolŋge Lea ndoŋ kinynaik le ");
INSERT INTO ssd_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Kuate nu Lea tuku yabaŋ pasa ta isna le nu fuŋgul ŋakna sulumba Yakob tuku kiŋo 5-nu te-pile tuna. ");
INSERT INTO ssd_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Taŋamba Lea nu ndek sakina: Ye buk yiŋe piro pino ta tumba yiŋe taŋgo tuwen le kile Kuate nu ye tuku lafu mayenu sat ŋgina. Taŋakina sulumba nu kiŋo ta nyunu Isakar ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Taŋamba minnaig ma ma Lea nu maŋ fuŋgul ŋakna sulumba Yakob tuku kiŋo 6-nu te-pile tuna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","sakina: Kuate nu agaŋ mayenu ye sat. Kile yiŋe taŋgo ye ndoŋ minamŋgat. Ye buk kiŋo 6 kile-patike tuwit ŋgina sulumba nu kiŋo ta nyunu Sebulun ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ŋgumneŋga nu kulim ande te-pilna ta nyunu Dina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kile Kuate nu Rahel idusna sulumba nu tuku yabaŋ pasa ta ismba Rahel tuku fuŋgul wakeina le nu kiŋo konmba fuŋgulok minna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","kiŋo ande te-pilmba sakina: Kuateŋge ye tuku kiko pitaiwat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Taŋakina sulumba nu kiŋo ta nyunu Yosef ŋgina sulumba sakina: Suŋgo nu maŋ kiŋo ande turmba ye suwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rahel nu Yosef te-pilna le Yakob nu mbiyel nuŋe Laban sana: Ne woka le ye maŋ luka yiŋe tumbraŋ tuguk ka. ");
INSERT INTO ssd_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ye yiŋe pino pirokumba kilen ta yiŋe kutu kame ta turmba kilmba kaŋgit. Ye ne sinzaŋ mayenen ta ne kila ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","mbiyel nuŋe ndek nu sana: Yauk. Ne isa. Suŋgo nu ne idusnumba ye nyaro mayenu sina ta ye katesemba kila pilen. ");
INSERT INTO ssd_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ne ame piya tam ŋga idusmba ndeta ye saya le ne tini ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakob lafumba nu sana: Ye ne tuku piro taŋgo minen le ne tuku agaŋmor ye kulatken ta ŋakmba tugekinaig ta ne kila. ");
INSERT INTO ssd_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ye te nda prowen ta ne agaŋ ndende suŋgomba ŋak nda minna. Ye ne tugum te prowen le ne tuku agaŋmor puluka tugekinaig. Suŋgo nu ye idusyumba ne nyaro mayenu tinna. Ye kile yiŋe kuasmbi idusniŋgamŋgit ŋga mbiyel nuŋe sana. ");
INSERT INTO ssd_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Taŋakina le mbiyel nuŋe nu sana: Ye ame piya ne tini ŋgina le Yakob ndek sana: Ye ndametiŋ kilam tuku idus ndawet. Ne ye tuku wamdus ismba ye tuku nzali dubiwa ta ye maŋ ne tuku agaŋmor kulatkamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ye tuku nzali ta teŋenmba. Ye kite ne tuku agaŋmor ta ŋakmba pileniŋgamŋgit. Sipsip fat baseunu ta ye ŋakmba kilmba meme kitek ŋgarosu kalbob ŋak ŋgarosu bagli ŋak ta turmba ŋakmba kilamŋgit. Agaŋmor kame ta ye tuku piya agaŋ taŋaŋ minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ye ne yabrini ta ne pitik ndo katesewamŋgat. Ne ŋgumneŋga ye tuku piya ta pileniŋmba meme ande ŋgarosu bagli kugatok ŋgarosu kalbob kugatok ko sipsip ande baseunu kuga ta kaŋgermba ye agaŋmor ta kuayaren ta ne kila palmbimŋgat ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","mbiyel nuŋe ndek nu sana: Ne sakate ta maye. Sile taŋape ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ki ait ta mbolŋge ndo Laban nu kumba ka meme pailnu ŋgarosu mambriŋ ŋak ŋgarosu kalbob ŋak meme paŋgarnu ŋgarosu bagli ŋak ŋgarosu kalbob ŋak ta ŋakmba kilna sulumba sipsip baseunu ta ŋakmba turmba kilna sulumba agaŋmor ta kiŋo kat nuŋe kulatkam tuku niŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Taŋamba nu agaŋmor ta kilmba Yakob kusremba ma masken kina. Ait keŋmba kuganaig le ma ta tugum prona le Yakob nu mbiyel nuŋe agaŋmor afu kusrekina ta ndo kulatkina. ");
INSERT INTO ssd_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Taŋamba Yakob nu ail tugu keŋmba ta tuku wainu afu kilna sulumba bagimbi waswas pike likina le ndemnu kaukauk prowe likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Taŋanaig le nu waswas pike likina ta kilmba kumba ka agaŋmor kule nyade tuku nza sinam taŋge patikina. Patikina le agaŋmor kame kule nyam promba pailnuŋge paŋgarnu dubikinaig. ");
INSERT INTO ssd_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Meme kame nane waswas patikina ta tugumŋge paŋgarnu dubikanu ta nane meme fatnu ŋgarosu mambriŋ ŋak ŋgarosu bagli ŋak ŋgarosu kalbob ŋak ta ndo kile-patike likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Taŋanaig le Yakob nu sipsip kilmba ŋakmba kasomŋge Laban tuku agaŋmor ŋgarosu mambriŋ ŋak baseunu ta tumailamŋge patikina. Taŋana le Yakob tuku agaŋmor tugekinaig le nu ndek agaŋmor kame ta pileŋga mbiyel nuŋe tuku agaŋmor kasomŋge patika nu nuŋe ta kasomŋge patikina. ");
INSERT INTO ssd_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Agaŋmor ŋgarosu saŋgri ŋak paŋgarnu dubikanu ta Yakob nu waswas pike likina ta kilmba agaŋmor kule nyade tuku nza ta sinamŋge patikanu. Taŋawanu le nane waswas ta tugumŋge paŋgarnu dubikanu. ");
INSERT INTO ssd_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Agaŋmor baklelok prowanu ta Yakob nu waswas pike likina ta nane tugumŋge nda patikanu. Taŋawanu le Laban nu agaŋmor baklelok ndo kilna le Yakob nu agaŋmor ŋgarosu saŋgri ŋak ta ŋakmba kilna. ");
INSERT INTO ssd_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Wam ta mbolŋge Yakob nu maror taŋgo mayok kumba agaŋmor, piro mbal, kamel, doŋki, agaŋ ndende suŋgomba ŋak minna. ");
INSERT INTO ssd_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laban tuku kiŋo kat nuŋe nane naŋgine naŋgine sakinaig: Yakob nu mam tuku agaŋ ndende ŋakmba kile likina. Nu tuku agaŋ ndende ta ŋakmba buk mam tuku minnaig ŋginaig le Yakob nu pasa ta isna. ");
INSERT INTO ssd_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Mbiyel nuŋe buk nu ndoŋ gulab mayemba minnaik ta kile nu wamdus kareŋgina ta Yakob nu mata kamusna. ");
INSERT INTO ssd_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Taŋana le Suŋgo nu ndek Yakob sana: Ne luka wa mbuŋ tuku kilke mbol naŋe ndare kame sota kaye le ye ne ndoŋ minamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ta tuku Yakob nu taŋgo ande kukulna le nu kumba ka Rahel nale Lea kile-siglika sanikina le Yakob sota kinaik ka nu piro mbolŋge agaŋmor kulatka minna le te-silikinaik. ");
INSERT INTO ssd_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Te-silikinaik le nu nale sanikina: Mam takile buk ye ndoŋ gulab mayemba minkeŋ ta kile nu wamdus kareŋgate le kamuset ta yiŋe mam tuku Mbara nu ye kusre ndayina. ");
INSERT INTO ssd_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ye mam takile tuku piro taŋgo minmba piro kareŋ suŋgowen ta tale kila. ");
INSERT INTO ssd_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Nu ye yabri-yabriyumba ye tuku piya mata mbilmbilam gudomna ta Kuate nu ye kulat mayeyina le nu ye ŋayo sili ndayina. ");
INSERT INTO ssd_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Mam takile nu meme ŋgarosu bagli ŋak ta ne tuku piya naŋe ŋgina ta meme ŋakmba fatnu ŋgarosu bagli ŋak ndo kile-patikinaig. Nu ndek meme ŋgarosu mambriŋ ŋak ta ne tuku piya naŋe ŋgina ta meme ŋakmba fatnu ŋgarosu mambriŋ ŋak ta ndo kile-patikinaig. ");
INSERT INTO ssd_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kuateŋge mam takile tuku agaŋmor kilmba ye sina ŋga sanikina. ");
INSERT INTO ssd_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Taŋakina sulumba nu maŋ lato sanikina: Agaŋmor paŋgarnu dubikam tuku ait mbolŋge ye kinymba kiŋaten sulumba meme paŋgarnu dubikinaig maŋau ta kaŋgeren. Meme pailnu kaŋgerken ta ŋakmba ŋgarosu mambriŋ ŋak ŋgarosu kalbob ŋak ŋgarosu bagli ŋak kaŋgerken le ");
INSERT INTO ssd_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kuate tuku Eŋel kiŋambi ye wika sayina: Yakob ŋgina kande ye minet te ŋgen. ");
INSERT INTO ssd_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Nu maŋ lato sayina: Ne kaŋgera. Meme kame paŋgarnu dubikade ta ŋakmba ŋgarosu mambriŋ ŋak ŋgarosu kalbob ŋak ŋgarosu bagli ŋak minig. Laban nu ne mbolŋge maŋau ŋayonu kate ta ye kaŋgeren. Ta tuku maŋau te yeŋge ken. ");
INSERT INTO ssd_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ye Kuate. Ye Betelŋge ne tugum prowen le ne ndame ande pilmba kilke mbolŋge te-timba gureŋ manza ŋak ndame ta mbolŋge kutuna sulumba siŋka son pasa saŋgrinu sakina ta kile ne tiŋga luka naŋe tumbraŋ tuguk kaye ŋgina ŋga nale sanikina. ");
INSERT INTO ssd_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Taŋakina le nale ndek Yakob sanaik: Mam nu sile tuku wai mbolŋge agaŋ ande kusrewam tuku mine ndakate. ");
INSERT INTO ssd_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nu sile rawe taŋgo taŋaŋ ŋga iduste. Amboŋga nu sile tuku ŋga nu ndametiŋ suŋgokanu tina sulumba ŋgumneŋga maŋ ndametiŋ ta ŋakmba panke suluna. ");
INSERT INTO ssd_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mam tuku agaŋ ndende ŋakmba Kuateŋge yaina ta sine tuku siŋgine kiŋo kame tuku. Kuate ne sanina taŋamba ka ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Taŋakinaik le Yakob nu kuaneka mam nuŋe sota Kanan kilke mbol kambim bafuna sulumba kutu kat nuŋe piyo kat nuŋe ta ŋakmba kilmba kamel mbolŋge patike likina. Taŋamba nu agaŋmor Mesopotamia kilke mbolŋge kilna ta ŋakmba sisilaniŋgina sulumba nu tuku agaŋ ndende ŋakmba ta turmba kilmba kina. ");
INSERT INTO ssd_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban nu nuŋe wande kusremba sipsip ŋguenu kugernu kina le Rahel nu mam nuŋe tuku wande mbol kumba mbara kanunu saike likina ta kuayar kilna. ");
INSERT INTO ssd_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakob nu mbiyel nuŋe yabrimba nu kila sa ndamba kua kina. ");
INSERT INTO ssd_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nu nuŋe agaŋ ndende ŋakmba kilmba pitik ndo kua ka kina sulumba Yufretis kule ulmba Gilead ma taknu mbol kina. ");
INSERT INTO ssd_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ait keŋmba kinaig le Yakob nu kua kina ta sakinaig le Laban nu isna. ");
INSERT INTO ssd_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Isna sulumba nu nuŋe gageu ta kilmba mara 7 Yakob dubimba kinaig ka ka Gilead ma taknu mbolŋge nu te-silikinaig. ");
INSERT INTO ssd_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Furir ta mbolŋge Laban nu kinymba kiŋatina le Kuate nu tugum promba sana: Ne kurauka. Ne Yakob tuku ŋerŋerka pasa pitinu sa ndawa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakob nu nuŋe baibai Gilead ma taknu inum mbolŋge patike likina le Laban nu nuŋe kuasmbi ndoŋ nuŋe baibai ma taknu inum mbolŋge patike likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Kile Laban nu Yakob te-silika sana: Ndaŋam ne ye yabriyumba yiŋe kulim ar ta kame ait mbolŋge pino didika kilig taŋamba kilmba kua kina? ");
INSERT INTO ssd_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ne ndaŋam ye yabriyumba ye nda sayumba siŋsiŋndo kua kina? Ne ye sayina kande ye ne mindenumba ndinŋge sine gare-gareka mune ulmba gita katmba tambariŋ katmba mbilnumba ne kusrenigeŋ kande. ");
INSERT INTO ssd_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ne sonndo maŋau ŋayonu kina. Ye mata yiŋe wa kame yiŋe kulim ar ta mumu ndaniŋmba kaŋger ndaken le kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ye ne ŋayo silinam kumuŋ ta furir ŋgamuŋge mam naŋe tuku Mbara nu ye ne ŋerŋerka pasa pitinu nda sanam tuku ŋga riroŋ pasa sat. ");
INSERT INTO ssd_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ne naŋe tumbraŋ tuguk kambim paranina le ye kusreyina ta ye kila ta ndaŋam tuku ne ye tuku mbara kanunu saike liken ta kuayar kilna ŋga Yakob sana le ");
INSERT INTO ssd_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","nu mbiyel nuŋe tuku pasa lafumba sana: Ne naŋe kulim ar te ŋgailka yaiyikat ŋga ye kuru-kuruka taŋawen ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Rahel nu mbara kanunu afu mam nuŋeŋge saike likina ta kuayar kilna ta Yakob nu gilai tukunu nu ndek mbiyel nuŋe sana: Ne kumba kaŋgerka. Andeŋge ne tuku mbara kanunu kilna ndeta nu balewamŋgig. Ne kile ndo taŋgo te ŋakmba tuku am mbolŋge mambila sulumba ne tuku agaŋ inum kaŋgermba ndeta agaŋ ta luka ta ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Taŋakina le Laban nu kumba ka Yakob tuku baibai sinamŋge mambilna sulumba ka Lea tuku baibai sinamŋge mambilmba ka piro pino ar ta tuku baibai sinamŋge mambilna ta agaŋ inum kaŋger ndana. ");
INSERT INTO ssd_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahel nu mbara kanunu ta kilmba baibai sinamŋge kamel tuku kumiŋ saŋgil mbolŋge depolka kusam tuku pale ta sinamŋge sigrikina sulumba nu ta mbolŋge minyokina. Taŋge minyokina le mam nuŋe pro baibai sinamŋge mambilna ta agaŋ inum kaŋger ndana le ");
INSERT INTO ssd_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahel ndek nu sana: Mam, ne ye tuku gubra ndanuwa. Ye wandek kat tukunu ye ne tuku am mbolŋge ye tiŋgam kumuŋ kuga ŋgina. Taŋakina le Laban nu mambilna ta nu nuŋe mbara kanu kame ta kaŋger ndakina. ");
INSERT INTO ssd_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Taŋana le Yakob nu gubra mayena le mbiyel nuŋe sana: Ye ame maŋau mbaren le ne ye agaŋmor yokeranu sukte? ");
INSERT INTO ssd_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ne ye tuku agaŋ ndende ŋakmba kaŋgerka mambilat. Ne naŋe agaŋ inum te-silikat ndeta teŋge pale le sile tuku piro taŋgo te ŋakmba kaŋgerwaig. Taŋamba nane sile tuku maŋau pileŋguwaig. ");
INSERT INTO ssd_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ye yar 20 taŋaŋ ne tuku piro taŋgo minen. Ne tuku sipsip ne tuku meme nane mara mara kutunaig. Ye ne tuku meme pailnu ande kuayarmba nda nyen. ");
INSERT INTO ssd_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Agaŋmor ŋguikok ande ne tuku sipsip ande balewanu ta ye ta lafumba yiŋe sipsip inum tumba ne tinmba minen. Agaŋmor ande ki mbol ko furir ŋgamu ŋgisikanu ta ne ye pasa saŋgrinu sayanu le ye yiŋe agaŋmormbi lafumba ne tinen. ");
INSERT INTO ssd_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Mara afu ki mbolkanu ta ye ŋgaro pa tiŋganu ko furir ma tido ŋayo prowanu ta ye murkenu kinyam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Taŋamba minmba ma ma ye yar 20 ne tuku piro taŋgo taŋaŋ minen. Ye yar 14 ne tuku kulim ar ta kilam tuku piroken sulumba maŋ lato yar 6 ne tuku agaŋmor kilam tuku piroken ta ne ye tuku piya mbilmbilam gudomna. ");
INSERT INTO ssd_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Yiŋe mam Isak yiŋe wa Abraham tuku Mbara nu ye nda turyina kande ake sinaŋ ne kusrenen kande. Ta tuku Kuate nu ye tuku piti kaŋgerna sulumba furir ne riroŋ pasa tanet ŋga mbiyel nuŋe sana. ");
INSERT INTO ssd_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Kile Laban nu ndek mbiyel nuŋe sana: Kulim ar te yiŋe. Kiŋo kame te mata ye tuku. Agaŋmor te ŋakmba mata yiŋe. Agaŋ ndende ŋakmba ne kile kaŋgerkate ta yiŋe ta ye nane ŋgailniŋgam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kile sile wamdus ulendipe sulumba ndame afu kilmba pro teŋge patikupe. Taŋamba sile maŋau ta gilaiŋge nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Taŋakina le Yakob nu ndame ande tumba kilke mbolŋge te-tina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","nuŋe kuasmbi kile-maŋgurka nane saniŋgina: Tane kumba ndame afu kilmba pro te taŋge ndame ta ŋakmba turŋaŋgap ŋgina. Nane taŋanaig le nane ndame turŋaŋginaig ta tugumŋge isukusnaig. ");
INSERT INTO ssd_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Taŋamba Laban nu ma ta Yegar Saduta ŋgina le Yakob nu ndek ma ta Galed ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ta ndaŋam? Laban nu Yakob sana: Sile ŋgumneŋga ndame maŋgur ta kaŋgermba wamdus ulendiwik ta idusamŋgik ŋgina. Ta tuku nane ma ta nyunu Galed ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban nu maŋ sakina: Sile pur yimyam ka minpe le Kuate nu sile kaŋgerkuwa ŋgina. Ta tuku nane ma ta nyunu ande Mispa ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kile Laban maŋ lato mbiyel nuŋe sana: Ne ye tuku kulim ar te ŋaigo siglika ko pino afu kitek kila ta ye kila pile nda ta Kuate nu maŋau ta kaŋgeramŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ai te. Ndame turŋaŋgit ndame ne kilke mbolŋge te-tiwat minig te. ");
INSERT INTO ssd_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Agaŋ ta kaŋgerka sile wamdus ulendiwik ta maŋ idusamŋgik. Ye ne ŋayo silinam tuku ndame te liwe nda. Ne mata ye ŋayo siliyam tuku ndame te nda liwa. ");
INSERT INTO ssd_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abraham le Nahor tuku Mbara sile pilesikuwa ŋgina. Taŋakina le Yakob nu mam nuŋe Isak tuku Mbara nyu mbolŋge mbiyel nuŋe ndoŋ pasa katmba saŋgri pilena. ");
INSERT INTO ssd_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Taŋamba Yakob ndek kumba ka agaŋmor inum tumba balemba tabe ta mbolŋge atraukina. Atraukina sulumba nuŋe kuasmbi wikina le nane promba isukusnaig. Isukuse deŋpurmba nane tabe ta mbolŋge kinynaig. ");
INSERT INTO ssd_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mafena le Laban nu wa kat nuŋe nuŋe kulim ar ta mumuniŋgina sulumba nane kusreka luka nuŋe tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Kile Yakob nu tiŋga ndin dubimba kina le Kuate tuku eŋel afu promba nu te-silikinaig le ");
INSERT INTO ssd_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","nu kaŋgerka sakina: Ma te Kuate nuŋe kuasmbi minig tuku ma ŋgina sulumba ma ta nyunu Mahanaim ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","5","Taŋakina sulumba Yakob nu taŋgo afu wam paguka saniŋgina: Tane kumba ka yiŋe aba Esau te-silika teŋenmba sawap: Ye Yakob. Ye ne tuku piro taŋgo. Ye sikile ŋga Laban tugumŋge rawe taŋgo taŋaŋ minen ma ma kile ndo makau doŋki sipsip meme piro taŋgo piro pino suŋgomba kilmba luka prowet. Ye taŋgo afu kukulniŋgen le nane ne kila pasa tinwaig le ne ye mbolŋge maŋau mayenu ka. Tane ka taŋamba nu sawap ŋgina. Nu wam paguniŋge deŋpurmba nu nane kukulniŋgina le amboŋga Esau sota Edom kilke mbol kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kinaig ka ndinŋge nane Esau te-silika maŋ luka Yakob tugum promba sanaig: Sine aba naŋe Esau sota kageŋ ta ka ndinŋge nu taŋgo 400 kilmba ne sota ilit ta kaŋgergeŋ ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Taŋakinaig le Yakob nu ndek kuru kuru suŋgo tumba wamdus pitina le nu nuŋe kuasmbi nuŋe sipsip meme makau kamel agaŋmor ta ŋakmba fet arna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","nuŋe wamdusmbi sakina: Aba Esau promba kuasmbi ande ndoŋ kame buwa ndeta kuasmbi ande kua kuwa ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Taŋamba Yakob nu yabaŋmba sakina: O yiŋe wa Abraham yiŋe mam Isak tuku Mbara ne ye isa. Ne Suŋgo, neŋge ye sayina le ye luka yiŋe tumbraŋ tuguk yiŋe ndare tuma mbal sota ka le ne ye kulatka turyam tuku sayina. ");
INSERT INTO ssd_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ye ame maŋau mayenu ken le ne taŋamba ye turyina? Ye ne am mbolŋge taŋgo mayenu kuga ta ne naŋe pasa dubimba mara mindek ye tuku kume purmba tur mayeyina. O buk ye agaŋ ndende kugatok ndumndum ndo biymba Yordan kule pakarken ta kile ye taŋgo kuasmbi armba ŋak minet. ");
INSERT INTO ssd_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","O Suŋgo, ye kile ne yabaŋnet. Aba Esauŋge ye yiŋe pino kiŋo kame ndoŋ balesiŋgikat ŋga ye kuru-kuruket. Ta tuku ne sine kigraibka ŋga ne yabaŋnet. ");
INSERT INTO ssd_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ne o buk ye sayina: Ne tuku ndare piyalŋge fulbul minig taŋaŋ gudommba tugekamŋgaig burnu kumuŋ kuga ŋga sayina. Ta tuku neŋge sine kigraibka ŋga yabaŋnet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Furirna le nu kinyna ka mafena le maratukuk tiŋga Yakob nu agaŋ ndende afu Esau tambim tuku walmba patikina. ");
INSERT INTO ssd_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Meme paŋgarnu 200 pailnu 20 kilmba sipsip paŋgarnu 200 pailnu 20 kilmba ");
INSERT INTO ssd_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamel paŋgarnu fat ŋak ŋak ta 30 kilmba makau paŋgarnu 40 pailnu 10 kilmba ");
INSERT INTO ssd_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","agaŋmor ta ŋakmba fetkina sulumba nuŋe piro taŋgo afu agaŋmor kuaŋ ndui ndui kulatkam tuku niŋgina sulumba saniŋgina: Tane kuit nduimba ndakape. Agaŋmor kuaŋ mindek muŋgu dubi-dubikuwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Taŋakina sulumba nu nuŋe piro taŋgo amboŋga kambim tuku ta wam pagumba sana: Ne yiŋe aba te-silika le nu ne kusnanuwa naŋe gabat aniŋge minit? Ne ani kinit? Agaŋmor te ŋakmba ima tuku ŋga ne kusnanuwa kande ne teŋenmba nu tuku pasa lafuwa: ");
INSERT INTO ssd_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Agaŋmor te ŋakmba ne tuku piro taŋgo Yakobŋge ne tanmbim tuku patikina le kilmba prowet. Nu mata sine dubika ilit ŋga sawa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakob nu taŋgo afu piro taŋgo amboŋga kina ta dubimba agaŋmor kilmba kambim tuku ta mata taŋamba ndo wam pagukina sulumba saniŋgina: Tane yiŋe aba te-silika teŋenmba sawap: ");
INSERT INTO ssd_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Naŋe piro taŋgo Yakob nu sine dubika ilit ŋga sawap ŋgina. Yakob nu teŋenmba idusna: Nu agaŋmor te ŋakmba kaŋgerka ye tuku mbar gilaiŋgamŋgat. Taŋamba nu ye kaŋgeryumba ye ndoŋ wamdus tumawamŋgik ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Yakob nu agaŋmor ta ŋakmba patikina le kilmba kinaig le furir ta mbolŋge nu bubre tam tuku ma ta mbolŋge nu kinyna. ");
INSERT INTO ssd_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Furir ndui ta mbolŋge ndo Yakob nu tiŋga nuŋe pino ar ta, nuŋe piro pino ar ta, nuŋe kiŋo kame 11 ta nane ŋakmba kilmba kumba ka Yabok kule pakarka sim kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Taŋamba nu maŋ luka nuŋe piro taŋgo kame tugum kumba nane kukulniŋgina le nu tuku agaŋ ndende ŋakmba kilmba kule ta pakarka kinaig le ");
INSERT INTO ssd_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakob nu nuŋe ndo taŋge minna. Taŋge minna le taŋgo ande nu tugum prona sulumba nu ndoŋ kame bumba muŋgu bagailka minnaik le ka mafena. ");
INSERT INTO ssd_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Taŋgo taŋge Yakob te-kinye ndana tukunu nu ndek Yakob tuku manunsu katna le supikina. ");
INSERT INTO ssd_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Taŋana le taŋgo ta nu Yakob sana: Mafete le ye kusreya le ka ŋgina le Yakob nu ndek sana: Ne ye nyaro sa ta ye ne kusrenamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Taŋakina le taŋgo ta nu Yakob kusnana: Ne tuku nyu ima ŋgina le ye Yakobŋge ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","taŋgo ta nu sana: Ne tuku nyu Yakob kuga. Ne tuku nyu kitek Israelŋge. Ne Kuate ndoŋ taŋgo kame ndoŋ mata ne saŋgri muŋgu tumka minna ta ne buk nane kile-ibeŋkina tukunu ne tuku nyu kitek Israel ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kile Yakob nu taŋgo ta kusnana: Ata. Ne tuku nyu ima ŋgina le taŋgo ta nu sana: Ne ndaŋam ye tuku nyu kila palmbim sakate ŋgina. Taŋakina sulumba nu Yakob nyaro tuna. ");
INSERT INTO ssd_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Taŋana le Yakob nu sakina: i Ye Kuate tuku tumail pasi kaŋgerit ta ye kume ndakit ŋgina. Ta tuku nu ma ta nyunu Peniel ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Maratukuk nu Peniel ma ta kusremba nu grisemka gitmba kumba minna le ki prona. ");
INSERT INTO ssd_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Taŋgo ta nu Yakob tuku manunsu katna le supikina. Ta tuku kile nane Israel mbal agaŋmor manunsunu nda nyade tuku. ");
INSERT INTO ssd_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Kile Esau nu nuŋe piro taŋgo 400 ta ndoŋ ilmba minna le Yakob nu nane kaŋgerka nuŋe kiŋo kat nuŋe kilmba walna sulumba afu Lea tumba afu Rahel tumba afu nuŋe piro pino ar ta nikina. ");
INSERT INTO ssd_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Taŋamba nu piro pino ar ta nakile kiŋo kat nakile ndoŋ tumailamŋge kile-tidiŋgina le tiŋginaig. Tiŋginaig le kile Yakob nu Lea kiŋo kat nuŋe ndoŋ piro pino ar ta ŋgumnemŋge kile-tidiŋgina le tiŋginaig. Nane ŋgumnemŋge maŋ Rahel nale Yosef ndoŋ kile-tidiŋgina le tiŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Taŋamba Yakob nu nane kusreka kina ka aba nuŋe tuku tumailamŋge truk kam 7-na le ");
INSERT INTO ssd_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau nu pinderka nu sota kina sulumba Yakob bagailmba mumuna. Taŋamba nale muŋgu malmbi-malmbikinaik. ");
INSERT INTO ssd_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kile Esau ndek mambilmba pino kame kiŋo kame ta kaŋgerka mambo nuŋe kusnana: Te ima kate tuku kuasmbi ne ndoŋ prowaig ŋgina le Yakob nu sana: O aba, te yiŋe kuasmbi. Kuate nu ye tur mayeyina sulumba kiŋo kame te ŋakmba ye sina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Taŋakina le nuŋe piro pino ar ta nakile kiŋo kame kilmba pro Esau tugumŋge lokinaig. ");
INSERT INTO ssd_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lokinaig le kile Lea ndek nuŋe kiŋo kat nuŋe ndoŋ nane dubika pro Esau tugumŋge lokinaig le Yosef nale Rahel ndoŋ nale ndek nane dubika pro Esau tugumŋge lokinaik. ");
INSERT INTO ssd_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Taŋanaig le nu mambo nuŋe kusnana: Kuasmbi amboŋga ye tugum prowaig ta ndaŋam tuku ŋgina le mambo nuŋe nu sana: Ye ne tuku wamdus te-ibeŋam tuku nane kukulniŋgit le ne sota kagig ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","aba nuŋe nu sana: O aba, ye mata agaŋ ndende suŋgomba ŋak. Agaŋ ndende ta ŋakmba naŋe minwaig ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","mambo nuŋe nu sana: Kuga. Sile gulab mayewik ŋga idusmba ndeta ne agaŋ ndende te ŋakmba kila. Ne maŋ ye ndoŋ gulab mayewik tukunu ne tuku tumail pasi kaŋgeret ta Kuate tuku tumail pasi kaŋgeranu suk. ");
INSERT INTO ssd_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Agaŋ ndende ne tanmbim tuku kilmba prowit te ne kila. Kuate nu ye tur mayeyina le ye agaŋ ndende suŋgomba ŋak minet ŋgina. Taŋamba Yakob nu aba nuŋe sarsarmba pasa saŋgrinu sana le nu agaŋ ndende ta kilna. ");
INSERT INTO ssd_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kile Esau nu sakina: Kile sine kab. Ye amboŋga kaŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","mambo nuŋe nu sana: Kiŋo kame te saŋgri kugatok ta ne kila. Sipsip makau afu mata fat ŋak ŋak. Sine agaŋmor ta mara ndindo mbolŋge suŋgomba sisilaniŋbe ta nane ŋakmba kume suluwamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ne amboŋga sila le ye gitmba agaŋmor kiŋo kame te ŋakmba kilmba ne dubinamŋgit. Taŋamba ye Edomŋge ne maŋ te-silikamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Taŋakina le aba nuŋe ndek sakina: Taŋamba ndeta ye yiŋe piro taŋgo afu ne ndoŋ kusreki ŋgina le Yakob nu lafumba sana: Kuga. Ye maye. Ne nane ŋakmba kilmba kaye ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Taŋakina le ki ait ta mbolŋge Esau nu maŋ tiŋga luka Edom kilke mbol kina le ");
INSERT INTO ssd_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yakob nu Sukot kilke mbol kina sulumba nuŋe wande pilmba agaŋmor tuku baibai afu turmba patikina. Ta tuku nu ma ta nyunu Sukot ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakob nu Mesopotamia kilke kusremba ndinŋge piti ande te-sili ndaka Sehem tumbraŋ Kanan kilke mbolŋge prona sulumba tumbraŋ suŋgo ta tugumŋge nuŋe baibai patike likina. ");
INSERT INTO ssd_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Nu silwa ndametiŋ soŋ 10 tambi nuŋe baibai patike likina kilke ta Sehem mam nuŋe Hamor tuku kiŋo kat nuŋe tugumŋge piyana. ");
INSERT INTO ssd_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Taŋamba nu taŋge ndame turŋaŋga atraukam tuku pa laŋlaŋ ande wakeina sulumba pa laŋlaŋ ta Israel Mbara tuku nyu tumba El ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Mara ande Yakob le Lea tuku kulim Dina nu tiŋga Kanan pino afu kaŋgerkam kina. ");
INSERT INTO ssd_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kilke ta tuku gabat suŋgo ta nyunu Hamor. Hamor nu Hiwinu taŋgo. Dina nu ma ta mbol prona le Hamor kiŋo nuŋe Sehem nu Dina kaŋgermba biye timba tumba totona. ");
INSERT INTO ssd_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Taŋamba nu kulim ta tuku nzali mayena sulumba nu Dina pinonu tam tuku wamdus suŋgo tumba nu tuwa ŋga sarsarmba saŋgri tiŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","nu nuŋe mam nuŋe sota kumba sana: Mam, ne kulim ta ye tuku pinonu ta ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakob nu Dina kiko maŋau tina ta nu buk isna ta nu tuku kiŋo kat nuŋe nane agaŋmor kulatkam tuku ma ande mbol kinaig tukunu Yakob nu nane ndo tairŋga minna. ");
INSERT INTO ssd_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Taŋamba minna le Sehem nu mam nuŋe Hamor ndoŋ Yakob ndoŋ pasatam pronaik le ");
INSERT INTO ssd_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ait ndui ta mbolŋge ndo Yakob tuku kiŋo kat nuŋe mata luka pronaig. Sehem nu Israel mbal mbolŋge maŋau ŋayonu kumba Yakob tuku kulim nuŋe biye timba tumba totona ta nane ismba wamdus ŋaigoŋginaig sulumba gubra mageniŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kile Hamor nu Yakob sana: Yiŋe kiŋo Sehem nu kulim naŋe tuku nzali suŋgo ŋak. Ne kulim naŋe ta ye tuku kiŋo tambim kumuŋ e? ");
INSERT INTO ssd_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Sine wamdus ulendika kulim kame kiŋo kame nane muŋgu kile-kile kuwaig. ");
INSERT INTO ssd_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Taŋamba tane kilke te mbolŋge minap sulumba ma aniŋge minam ŋga idusmba ndeta ka taŋge minmba agaŋ afu piyawam ŋak ndeta piyawap sulumba agaŋ ndende afu kilap ta taŋgine minmba minwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Taŋakina le Sehem nu ndek Dina mam nuŋe leu kat nuŋe teŋenmba saniŋgina: Tane ye mbolŋge maŋau mayenu kap le ame agaŋ kilam ŋga idusap ta tane tiŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tane ame piya kilam ŋga idusde ta ye sayap. Kulim ta tuku piya mata suŋgokanu mbolŋge madiwap. Tane taŋgine kulim ye sap le tane ame piya kilam sakap ta tane tiŋgamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sehem nu kulim naŋgine Dina kiko maŋau tuna tukunu Yakob tuku kiŋo kat nuŋe nane Sehem le mam nuŋe Hamor yabrinikmba sanikinaik: ");
INSERT INTO ssd_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Taŋgo ŋgaro pike ndakanu ta nu sine tuku kulim te nda. Wam ta sine mbolŋge kiko ŋak. ");
INSERT INTO ssd_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Sine buk taŋgo ŋakmba tuku ŋgaro pike likigeŋ. Tane taŋamba ndo taŋgo ŋakmba tuku ŋgaro pike likap ta sine siŋgine kulim ta sertiŋgamŋgig. ");
INSERT INTO ssd_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tane taŋawap le sine muŋgu kile-kile kube sulumba tane ndoŋ sine tugu ndindo taŋaŋ ulendika minbe. ");
INSERT INTO ssd_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tane wam sakeg te kam mbulap ndeta sine siŋgine kulim tumba ma tugu te kusrewamŋgig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamor le kiŋo nuŋe Sehem nale pasa ta ismba maye ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Taŋgo mo ta nu nu nuŋe kuasmbi ŋgamukŋge taŋgo suŋgo nyu ŋak minna. Nu Yakob kulim nuŋe tuku nzali mayena tukunu nu dal ndaka nuŋe mbal kila saniŋgam kina. ");
INSERT INTO ssd_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor nale kiŋo nuŋe Sehem ndoŋ nale kinaik ka nakile tumbraŋ tuku fonde malaŋga tugum promba nakile mbal maŋgurka minnaig ta saniŋginaig: ");
INSERT INTO ssd_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Taŋgo kame ta sine ndoŋ gulab mayenu. Nane sine tuku kilke mbolŋge minwaig sulumba ma ŋakmba mbol kuwaig. Kilke te suŋgokanu sine ŋakmba minam kumuŋ. Sine nane tuku kulim kame kilbe le nane sine tuku kulim kame kilwaig. ");
INSERT INTO ssd_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nane sine wam ndindo ndo kam tuku sasikaig ta teŋenmba. Sine taŋgo ŋakmba tuku ŋgaro pikam tuku sakaig. Nane buk naŋgine taŋgo kame ta ŋakmba tuku ŋgaro pike likinaig. Sine mata taŋamba kube ta nane sine ŋgamukŋge tugu ndindo taŋaŋ minamŋgig. Nane taŋamba sile sasikaig le iskik. ");
INSERT INTO ssd_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Sine taŋabe ta nane tuku agaŋmor nane tuku agaŋ ndende ŋakmba sine tuku minamŋgaig. Ta tuku sine wokube le nane sine ŋgamukŋge minwaig ŋginaik le ");
INSERT INTO ssd_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","tumbraŋ ta tuku taŋgo ŋakmba nane Hamor le Sehem tuku pasa ta ismba pasa katmba wokinaig sulumba nane taŋgo ta ŋakmba tuku ŋgaro pike likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Mara keŋmba kuganaig le taŋgo kame ŋgaro pike likinaig ta nane ŋgaro rar ŋak minnaig tukunu nane tambik ri ndamba minnaig le Dina tuku leu kat nuŋe ndinok armba Simeon nale Levi ndoŋ nale kame bagi kilmba tumbraŋ ta kinaik sulumba taŋgo ta ŋakmba bale far sulunaik. ");
INSERT INTO ssd_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Taŋamba nale Hamor le kiŋo nuŋe Sehem turmba bale farnaik sulumba Sehem tuku wande mbol kumba Dina te-silika tumba kinaik. ");
INSERT INTO ssd_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Taŋanaik le Yakob tuku kiŋo afu nane pro kulim naŋgine kiko maŋau tuna ta lafumba tumbraŋ suŋgo ta tuku gabis agaŋ ndende ŋakmba yomba kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Nane sipsip makau doŋki tumbraŋ ta tuku agaŋ ndende ŋakmba kilmba ka piro mbolŋge mata agaŋ ndende ŋakmba yomba kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Taŋamba nane tumbraŋ ta tuku gabis agaŋ ndende ta ŋakmba kilmba kiŋo kame foŋfoŋ pino kame ta ŋakmba turmba kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Taŋanaig le Yakob nu ndek Simeon nale Levi sanikina: Kile Kanan mbal Peris mbal kilke te tuku taŋgo ŋakmba nane ye kasuryamŋgaig. Ye mata piro taŋgo suŋgomba kuga. Nane ŋakmba ulendika pro ye ndoŋ kame bumba sine ŋakmba bale farsiŋgamŋgaig ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","nale ndek sakinaik: Taŋgo ta nu sine tuku kulim ma ŋgamukok pino taŋaŋ ŋga idusmba nu biye timba tumba totona. Maŋau ta sine mapewam kumuŋ kuga ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kile Kuate nu Yakob sana: Ne tiŋga Betel kaye sulumba kumba ka taŋge mina. Taŋge mina sulumba ne ndame turŋaŋga ye atraukam tuku pa laŋlaŋ ande wakeiwa. Ye Kuate. Ne aba naŋe Esau kusremba kua kina ait ta mbolŋge ye ne tugum prowen ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Taŋakina le Yakob nu nuŋe kuasmbi nuŋe piro taŋgo ta wam paguka saniŋgina: Tane taŋgine mbara kise ta ŋakmba pitaike likap. Ŋgarosu purfeŋnu mayok kuwaig le tawi purfeŋnu silikap. ");
INSERT INTO ssd_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Sine ma te kusremba Betel kab kumba ka taŋge ye Kuate atraukam tuku pa laŋlaŋ wakeiwamŋgit. Ye piti suŋgomba ŋak minen le Kuateŋge ye turyina sulumba ye ma ŋakmba liken ta nu mata ye ndoŋ minna ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Taŋakina le nane mbara kanu saike likinaig ta ŋakmba Yakob kile tunaig sulumba naŋgine kilba sikor ta turmba nu kile tunaig. Taŋanaig le Yakob nu agaŋ ndende ta ŋakmba kilmba Sekem tumbraŋŋge ail suŋgo ande kumnemŋge ŋguke likina. ");
INSERT INTO ssd_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Taŋamba Yakob nane tiŋga ma ta kusrenaig le tumbraŋ sugo ta ŋakmba Kuateŋge kuru kuru serniŋgina le nane dubi ndakinaig. ");
INSERT INTO ssd_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakob nu nuŋe taŋgo kuasmbi ŋak ndoŋ kinaig ka Lus tumbraŋ Kanan kilke mbol pronaig. Lus tumbraŋ ta kile Betel ŋgade. ");
INSERT INTO ssd_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Tumbraŋ ta prona sulumba Yakob nu Kuate atraukam tuku pa laŋlaŋ ande wakeina sulumba nu buk aba nuŋe tuku kuru-kuruka kua kina le Kuateŋge nu tugum prona ta idusmba nu ma ta nyunu Betel tuku Mbara ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nane taŋge minnaig ma ma Rebeka tuku piro pino Debora nu kumna le nane nu tumba ail suŋgo ande Betel patumba minna ta kumnemŋge ŋgukinaig sulumba ail ta nyunu Malmbikam tuku Ail ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakob maŋ luka Mesopotamiaŋge prona le Kuate maŋ nu tugum promba nu nyaro tuna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","sana: Ne tuku nyu Yakob ta kile ne tuku nyu Israel palmbimŋgit ŋgina. Taŋamba Kuate nu Yakob nyunu Israel tuna. ");
INSERT INTO ssd_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Taŋakina sulumba Kuate nu sana: Ye Kuate Saŋgri Ŋayo. Tane kiŋo kame kile-patikap le ne tuku ndare mbolŋge kuasmbi suŋgomba mayok kaŋgaig. Ne gabat sugo kame tuku mbuŋ naŋgine prowamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ye o buk Abraham le Isak kilke te serniken ta kile ne tanmbimŋgit. Ŋgumneŋga naŋe ndare kame tuku kilke minamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Taŋaka sakina sulumba Kuate nu kusremba kina le ");
INSERT INTO ssd_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakob nu ndame suŋgo ande tumba Kuate nu Yakob ndoŋ pasatina ma ta mbolŋge te-tina sulumba grep kule tumba gureŋ butol ŋak ta turmba tumba ndame ta mbolŋge kutuna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ma ta nyunu Betel ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakob nuŋe kuasmbi ndoŋ Betel tumbraŋ kusremba Efrat tumbraŋ patu ndanaig le Rahel nu kiŋo te-palmbim tuku ait kumuŋgina le nu ŋgaro rar torna. ");
INSERT INTO ssd_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ŋgaro rar torna le nuŋe kulat pinoŋge nu sana: Ne kuru kuru ndaka. Nu buk kiŋo te-palet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Taŋakina le Rahel nu kumam bafuna le nu tuku saŋgri buk kuganaig le nu kiŋo ta Ben-Omi ŋgina le mam nuŋeŋge kiŋo ta Benyamin ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rahel nu kumna le nane nu tuku mindesiŋ tumba Efrat tumbraŋ kambim tuku ndin ta tugumŋge ŋgukinaig. (Kile nane tumbraŋ ta nyunu Betlehem ŋgade). ");
INSERT INTO ssd_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Taŋamba Yakob nu ndame ande tumba Rahel ŋgukinaig ma ta mbolŋge te-tina. Ndame ta kile minit. ");
INSERT INTO ssd_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Taŋana sulumba Israel nane tiŋga kumba ka Eder tumbraŋ tuku wande kuen ŋayo ta kusremba bubre tam tuku baibai patika minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yakob nu kilke ta mbolŋge minna le Ruben nu mam nuŋe tuku piro pino nyunu Bila ta ndoŋ kinyna. Taŋana le Yakob nu kiŋo nuŋe wam kina ta ismba nu gubra suŋgo tina. Yakob tuku kiŋo kame ta ulendika 12 minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Piyo nuŋe Lea tuku kiŋo kat nuŋe ta teŋenmba. Yakob tuku kiŋo mulum ta nyunu Ruben ande Simeon ande Levi ande Yuda ande Isakar ande Sebulun. ");
INSERT INTO ssd_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Piyo nuŋe Rahel tuku kiŋo ar ta Yosef le Benyamin. ");
INSERT INTO ssd_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel tuku piro pino Bila nuŋe kiŋo ar ta Dan le Naftali. ");
INSERT INTO ssd_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea tuku piro pino Zilpa nuŋe kiŋo ar ta Gat le Aser. Yakob nu kiŋo kame ta ŋakmba Mesopotamia kilke mbolŋge kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Kile Yakob nu tiŋga mam nuŋe Isak sota Mamre tumbraŋ Hebron kilke mbol kina. O buk Abraham nale Isak rawe taŋgo taŋaŋ taŋge minnaik. ");
INSERT INTO ssd_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak nu yar 180 kusremba ");
INSERT INTO ssd_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","saibo pile mayena sulumba nu kumna le kiŋo kat nuŋe ar ta Esau le Yakobŋge nu tumba ŋgukinaik. ");
INSERT INTO ssd_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esau tuku ndare tuturmba teŋenmba kina. Esau tuku mape nyu ande Edom. ");
INSERT INTO ssd_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","3","Esau nu Kanan pino keŋmba kilna ta ande Ada ande Oholibama ande Basemat. Ada mam nuŋe Elon nu Hitnu. Oholibama mam nuŋe Ana wa nuŋe Sibeon. Sibeon nu Hiwinu. Basemat nu Ismael tuku kulim nuŋe. Leu nuŋe Nebayot. ");
INSERT INTO ssd_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada nu Elifas te-pilna le Basemat nu Ruel te-pilna le ");
INSERT INTO ssd_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama nu Yeus Yalam Kora nane kile-patikina. Esau tuku kiŋo kame Kanan kilke mbolŋge kile-patikina ta taŋamba ndo. ");
INSERT INTO ssd_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Esau le Yakob nale agaŋmor suŋgomba ŋak minnaig tukunu kilke nale tuma minnaik ta nale turkam kumuŋ kuga. Ta tuku Esau nu pino kat nuŋe, kiŋo kat nuŋe, kulim kat nuŋe, nuŋe wande tuma mbal ta ŋakmba kilmba nuŋe agaŋmor nuŋe agaŋ ndende ŋakmba Kananŋge kile likina ta turmba kilmba maib nuŋe Yakob kusremba kilke ande mbol kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Taŋamba Esau nu Edom tuku ma taknu ta mbolŋge minna. ");
INSERT INTO ssd_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esau tuku ndare tuturmba teŋenmba kina. Esau nu Edom mbal ŋakmba tuku mbuŋ naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esau piyo nuŋe Ada nu kiŋo ndindo te-pilna ta nyunu Elifas. Elifas nu kiŋo kame 5 Teman, Omar, Sefo, Gatam, Kenas nane kile-patikina. Elifas tuku piyo nuŋe ande nyunu Timna nu kiŋo ande nyunu Amalek te-pilna. Esau piyo nuŋe Basemat nu kiŋo ande nyunu Ruel te-pilna. Ruel nu kiŋo bailkamba Nahat Sera Sama Misa nane kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau piyo nuŋe Oholibama nu Sibeon kiŋo nuŋe Ana tuku kulim. Nu kiŋo keŋmba Yeus Yalam Kora nane kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esau tuku ndare mbolŋge kuasmbi afu pronaig ta teŋenmba. Esau tuku kiŋo mulum Elifas nu Teman mbal Omar mbal Sefo mbal Kenas mbal ");
INSERT INTO ssd_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora mbal Gatam mbal Amalek mbal ta ŋakmba tuku mbuŋ naŋgine. Nane ŋakmba Esau piyo nuŋe Ada tuku ndare. ");
INSERT INTO ssd_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau tuku kiŋo nuŋe ande Ruel nu Nahat mbal Sera mbal Sama mbal Misa mbal ta ŋakmba tuku mbuŋ naŋgine. Nane ŋakmba Esau piyo nuŋe Basemat tuku ndare. ");
INSERT INTO ssd_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau piyo nuŋe Oholibama nu Ana kulim nuŋe. Oholibama nu Yeus mbal Yalam mbal Kora mbal ta ŋakmba tuku mbuŋ naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Mbal ta ŋakmba Esau tuku ndare. ");
INSERT INTO ssd_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Edom kilke tuguk mbal nane buk purka tumbraŋ mboŋ 7 minnaig. Tumbraŋ mboŋ 7 ta tuku mbuŋ kat naŋgine ta ŋakmba Hornu taŋgo Seir tuku ndare. Nane tuku nyu naŋgine ta teŋenmba. Lotan, Sobal, Sibeon, Ana, Dison, Eser, Disan. ");
INSERT INTO ssd_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan nu Hori tumbraŋ mboŋ le Hema tumbraŋ mboŋ ta tuku mbuŋ naŋgine. Lotan tuku kulim nuŋe nyunu Timna. ");
INSERT INTO ssd_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal nu Alwan tumbraŋ mboŋ, Manahat tumbraŋ mboŋ, Ebal tumbraŋ mboŋ, Sefo tumbraŋ mboŋ, Onam tumbraŋ mboŋ ta tuku mbuŋ naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon nu kiŋo armba. Ande nyunu Aia ande Ana. Mara ande Ana nu mam nuŋe tuku doŋki kame kulatka minna sulumba ma baknu mbol taŋge nu kule mbam paknu kaŋgerkina. ");
INSERT INTO ssd_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Ana tuku kiŋo nuŋe nyunu Dison. Dison nu Hemdan tumbraŋ mboŋ, Esban tumbraŋ mboŋ, Itran tumbraŋ mboŋ, Keran tumbraŋ mboŋ ta tuku mbuŋ naŋgine. Ana tuku kulim nuŋe nyunu Oholibama. ");
INSERT INTO ssd_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser nu Bilan tumbraŋ mboŋ, Sawan tumbraŋ mboŋ, Akan tumbraŋ mboŋ ta tuku mbuŋ naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan nu Us le Aran tumbraŋ mboŋ tuku mbuŋ naŋgine. ");
INSERT INTO ssd_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Edom kilke tuku Hor mbal ta teŋenmba. Lotan mbal Sobal mbal Sibeon mbal Ana mbal ");
INSERT INTO ssd_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison mbal Eser mbal Disan mbal. ");
INSERT INTO ssd_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israel mbal nane buk gabat sugo kugatok. Ait ta mbolŋge Edom tuku gabat sugo afu nane Edom kilke kulatkinaig. ");
INSERT INTO ssd_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Gabat sugo dubike likinaig ta teŋenmba. Beor kiŋo nuŋe Bela nu Dinabanu. ");
INSERT INTO ssd_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Sera kiŋo nuŋe Yobab nu Bosranu. ");
INSERT INTO ssd_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Husam nu Temannu. ");
INSERT INTO ssd_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Bidad kiŋo nuŋe Hadad nu Awitnu. (Kame suŋgo ande mbolŋge nu Moab kilke mbolŋge Midian mbal ndoŋ kame bumba nane kile-ibeŋkina). ");
INSERT INTO ssd_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Samla nu Masrekanu. ");
INSERT INTO ssd_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Saul nu Rehobotnu taŋgo. (Rehobot tumbraŋ ta kule suŋgo ande tugumŋge minna). ");
INSERT INTO ssd_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Akbor kiŋo nuŋe Baal-Hanan. ");
INSERT INTO ssd_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Hadad nu Paunu taŋgo. (Hadod piyo nuŋe nyunu Mehetabel. Mehetabel mam nuŋe nyunu Matred. Matred mam nuŋe nyunu Mesahab). ");
INSERT INTO ssd_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esau nu Edom tumbraŋ mboŋ suŋgomba tuku mbuŋ naŋgine. Tumbraŋ mboŋ ta tuku nyu naŋgine ta teŋenmba. Timna, Alwa, Yetet, ");
INSERT INTO ssd_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO ssd_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mibsar, ");
INSERT INTO ssd_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, Iram. Naŋgine kilke ta mata tumbraŋ mboŋ ta tuku nyu tinaig. ");
INSERT INTO ssd_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakob nu Kanan kilke mbolŋge minna. O buk mam nuŋe rawe taŋgo taŋaŋ nu kilke ta mbolŋge minna. ");
INSERT INTO ssd_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yakob nuŋe ndare tuku wam kube ta teŋenmba. Yosef nu kiŋo mo yar 17 ŋak minmba nu mam nuŋe tuku agaŋmor aba kat nuŋe afu ndoŋ kulatka minnaig. Aba kat nuŋe ta Bila le Zilpa tuku kiŋo kame. (Bila le Zilpa nale Yakob tuku pino kame). Yosef nu maŋau ŋaigonu aba kat nuŋe ke likanu ta pro mam nuŋe tugumŋge kile-mayokka sawanu. ");
INSERT INTO ssd_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel nu saibo pilmba Yosef te-pilna tukunu nu Yosef make pilmba nu tuku kume purna. Kiŋo kame ŋakmba tuku nzalina ta liniŋgina. Taŋamba Israel nu Yosef tuku tawi kuen wainu kuennu ŋak mindepiye yeki yeki ŋak wakeimba tuna. ");
INSERT INTO ssd_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Taŋana le Yosef tuku aba kat nuŋe mam naŋgine nu Yosef make pilmba nu tuku kume purna ta kaŋgermba nane Yosef kasurnaig sulumba gulab mayenu taŋaŋ nu ndoŋ pasate ndakinaig. ");
INSERT INTO ssd_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Furir ande Yosef nu kiŋatina sulumba mafena le maratukuk tiŋga nu kumba ka aba kat nuŋe kubeu niŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","saniŋgina: Tane ye kiŋatit te kubewi le isap. ");
INSERT INTO ssd_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Sine ŋakmba wit ndaleke likig ta ye tuku ndale ta tiŋreknu tiŋgat le tane tuku ndale ta ye tuku ndale ta laipmba loke likaig le kaŋgerkit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Taŋakina le aba kat nuŋe ndek nu kusnanaig: Ne iduste neŋge ndo gabat suŋgo mina le sine ŋakmba ne kumnemŋge minbe ŋga iduste e ŋginaig. Taŋamba nane Yosef kiŋatina pasa ta tuku nane gubra lato suŋgomba tumba nu kasur mayenaig. ");
INSERT INTO ssd_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ŋgumneŋga Yosef nu maŋ kiŋatina sulumba aba kat nuŋe tugumŋge maŋ kiŋa ta kubeu niŋmba saniŋgina: Ye maŋ kiŋatit sulumba ki tambun mbai 11 ŋakmba ye tugumŋge lokaig le ye kaŋgerkit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Taŋamba nu kumba ka kiŋa ta mam nuŋe ndoŋ mata sakina le mam nuŋeŋge nu sigair-sigairmba kusnana: Anikok kiŋa taŋaŋ. Ne iduste ye, ina naŋe, aba kat naŋe sine ŋakmba ne tugumŋge lokamŋgig ŋga iduste e ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Yosef tuku aba kat nuŋe ta nane Yosef ndoŋ tironaig. Mam nuŋe nu Yosef tuku kiŋa ta idus timba minna. ");
INSERT INTO ssd_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Mara ande Yosef tuku aba kat nuŋe ta nane agaŋmor kulatkam tuku Sekem tumbraŋ kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Taŋanaig le Israel nu kiŋo nuŋe Yosef sana: Ne kaye sulumba kumba ka Sekemŋge aba kat naŋe agaŋmor kulatkade ta kaŋgerka ŋgina le nu lafumba sakina: Ta maye. Ye kaŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israel nu ndek sana: Ne kaye sulumba aba kat naŋe tuku mine agaŋmor tuku mine kaŋgerka nane mage minwaig kande luka promba ye saya le isi ŋgina. Taŋamba Israel nu Yosef kukulna le nu Hebron ma gutoŋ ta kusremba kina ka Sekem tumbraŋ prona. ");
INSERT INTO ssd_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Pro taŋge nu kine promba minna le taŋgo andeŋge nu kaŋgermba kusnana: Ne ima sota te prote ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","nu lafumba sana: Ye yiŋe aba kame sotet. Nane agaŋmor kulatka tembi ndekinaig ŋgina. Taŋakina sulumba nu ndek taŋgo ta kusnana: Ne nane kaŋgerkat e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","taŋgo taŋge nu sana: Nane buk ma te kusremba Dotan kambim sakinaig le ye isen ŋgina. Taŋakina le Yosef nu aba kat nuŋe ŋgumnem dubika kina ka Dotanŋge nane kile-siglikina. ");
INSERT INTO ssd_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yosef nu maskenŋge ilmba minna le nane nu kaŋgernaig sulumba Yosef balewam tuku pasa katmba ");
INSERT INTO ssd_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","naŋgine naŋgine sakinaig: Ai si. Kiŋa tugu taŋgo prote si. ");
INSERT INTO ssd_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kile sine nu balemba mindesiŋ nuŋe tumba kule kugatok sambu ande sinamŋge bukŋgube. Taŋamba sine teŋenmba mam sabe: Nu agaŋmor ŋguikok andeŋge balemba nyina ŋgube. Taŋamba sine nu tuku kiŋa alonu prowa le kaŋgerbe ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Nane taŋamba sakinaig ta Ruben nu isendo ka ismba nu Yosef mapewam idusmba nane saniŋgina: Sine nu balemba ");
INSERT INTO ssd_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ake sinaŋ nu tuku ndare kutu ndabe. Ake nu biye timba tumba sambuk teŋge bukŋgube le ma ŋgamu teŋge minwa ŋgina. Ruben nu Yosef turmba maŋ luka mam nuŋe sota kukulam tuku ŋga taŋakina. ");
INSERT INTO ssd_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kile Yosef nu aba kat nuŋe tugum ta prona le nane nu biye timba tawi kuen wainu kuennu ŋak ta biymba sambrinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","nu tumba kumba ka sambu sakina ta sinamŋge bukŋginaig le minna. Sambu ta kule buk parakina tuku. ");
INSERT INTO ssd_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Taŋamba nane isukusmba minnaig le kile ndo Ismael kuasmbi ande Gileadŋge Isip kambim tuku pronaig le kaŋgerkinaig. Nane agaŋ ndende suŋgomba gureŋ magenu afu kilmba kamel mbol patike likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kile Yuda ndek aba kat nuŋe saniŋgina: Sine Yosef balemba yubeŋgube wam ta mayenu kuga. ");
INSERT INTO ssd_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Sine nu ŋayo sili ndamba nu tumba Ismael mbal prode si nane mbol piyabe. Nu mata sine tuku maib. Sine ndare ndui ta ndo ŋgina. Taŋakina le nane wokinaig le ");
INSERT INTO ssd_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Midian mbal pronaig le nane Yosef sambuk sinam taŋge tumba silwa ndametiŋ soŋ armbambi nane mbolŋge piyanaig le tumba Isip kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Taŋanaig le Ruben nu luka sambu miŋge ta tugum promba mambilna kande Yosef sambu sinam ta mine ndakina le nu nuŋe tawi silikina ta fetfetna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","luka mambo kat nuŋe sota kumba saniŋgina: Kiŋo ta siŋge mine ndakate. Ye kile ndaŋamŋgit e ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Taŋakina le nane meme ande tumba balemba Yosef tuku tawi ta tumba meme ndarenu pisnenaig sulumba ");
INSERT INTO ssd_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","tawi ta tumba kumba ka mam naŋgine tumnaig sulumba sanaig: Sine agaŋ te-silikig te kiŋo naŋe tuku tawi e ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakob nu tawi ta kaŋgermba katesemba sakina: Son. Tawi te nu tuku tawi. Yiŋe kiŋo ta agaŋmor ŋguikok andeŋge balemba make purpurmba nyina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Taŋakina sulumba Yakob nu sina suŋgona sulumba nuŋe tawi kat fetfetmba tawi ŋayonu ande tumba silikina. Taŋamba nu ait kuen ŋayo kiŋo nuŋe tuku malmbika minna le ");
INSERT INTO ssd_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","nu tuku kiŋo kat nuŋe kulim kat nuŋe nane ŋakmba mam naŋgine wamdus te-ibeŋam tuku pronaig ta nu nane ise ndakina sulumba sakina: Ye yiŋe kiŋo tuku ninanka malmbika ma ma kumi sulumba kumanu mbal tuku ma mbolŋge nu ndoŋ minamkik ŋgina. Taŋakina sulumba Yakob nu kiŋo nuŋe Yosef tuku wamdus tatrukina le ninanka minna. ");
INSERT INTO ssd_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yakob nu kiŋo nuŋe tuku ninanka minna le Midian mbal ta nane Yosef tumba pro Isipŋge taŋgo ande nyunu Potifar nu mbol piyanaig. Potifar nu Farao tuku gabat suŋgo ande. Nu Farao tuku wande kulatkanu gabat minna. ");
INSERT INTO ssd_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ait ta mbolŋge Yuda nu aba kat nuŋe kusreka Adulamnu taŋgo ande nyunu Hira sota kumba nu ndoŋ minnaik. ");
INSERT INTO ssd_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Minnaik ma ma nu Kanan kulim ande kaŋgermba pinonu tina. Pino ta mam nuŋe nyunu Sua. ");
INSERT INTO ssd_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Minnaig ma ma pino ta nu fuŋgul ŋakna sulumba Yuda tuku kiŋo ande te-pilmba nyunu Er ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Taŋamba nu maŋ fuŋgul ŋakna sulumba kiŋo ande te-pilmba nyunu Onan ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nu maŋ lato fuŋgul ŋakna sulumba kiŋo ande nyunu Sela te-pilna. Yuda nu Kesibŋge minna le piyo nuŋe kiŋo ta te-pilna. ");
INSERT INTO ssd_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Er nu suŋgokina le mam nuŋe Yuda nu kiŋo nuŋe mulum ta tuku pino ande nyunu Tamar tumba tuna. ");
INSERT INTO ssd_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er tuku mine ŋayonu ta Suŋgo nu kaŋgermba ndagarina le Suŋgoŋge nu balena le kumna. ");
INSERT INTO ssd_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Taŋana le Yuda nu kiŋo nuŋe Onan sana: Ne kumba ka siŋgine maŋau ta dubimba aba naŋe tuku pino pinonu tumba nu ndoŋ kinya le aba naŋe tuku kiŋo te-pilwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Taŋakina le Onan nu kiŋo ta ye tuku kiŋo kuga ŋga idusna sulumba pino ta aba nuŋe tuku kiŋo ande nda te-pilwa ŋga nu pino ta ndoŋ kinymba nuŋe minde kule ta ake kilke mbolŋge kutuna. ");
INSERT INTO ssd_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Taŋana le Suŋgo nu maŋau ta kaŋgermba nu gare ndana le nu mata balena le kumna. ");
INSERT INTO ssd_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Taŋana le Yuda nu rugan nuŋe Tamar sana: Ne luka mam naŋe sota kaye sulumba pino kuembol taŋaŋ mina le yiŋe kiŋo Sela nu suŋgokuwa le ne tini ŋgina. Sela nu mata kumikat ŋga mam nuŋe nu taŋakina. Taŋakina le Tamar nu luka mam nuŋe sota kina. ");
INSERT INTO ssd_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Taŋamba minnaig ma ma Yuda piyo nuŋe kumna. Nu tuku kuamel kugana le Yuda ndek nuŋe Adulamnu gulab Hira ndoŋ nuŋe sipsip ŋguenu kugerkam Timna tumbraŋ kinaik. ");
INSERT INTO ssd_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Taŋanaik le taŋgo ande pro Tamar sana: Rugan naŋe sipsip ŋguenu kugerkam tuku Timna ket ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Yuda tuku kiŋo ŋgrimbik ta buk suŋgokina ta Yuda nu kiŋo ta ŋgailka Tamar nda tuna. Ta tuku Tamar nu kuembol tawi o buk silikina ta paska tawi kitek silika tumail pasi tawimbi soŋgina sulumba kumba ka Timna kambim tuku ndin Enaim tumbraŋ tuku fonde malaŋga ta tugumŋge minyok minna. ");
INSERT INTO ssd_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Pino ta tumail pasi soŋgina le Yuda nu kaŋgermba ndin ŋgamukok pino ande ŋga idusmba ");
INSERT INTO ssd_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","nu tugum ndin dabil inum kumba pino ta rugan nuŋe ta katese ndamba sana: Ye ne ndoŋ kinyamŋgit ŋgina le nu ndek sakina: Ne ame agaŋ ye samŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Taŋakina le nu sakina: Ye yiŋe meme fatnu inum tumba taŋgo ande tuwi le tumba ilmba ne tanmbimŋgat ŋgina le nu sakina: Ta maye. Naŋe agaŋ inum ye sa le meme fatnu ta prowa le naŋe agaŋ ta maŋ luka tini ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda nu kusnana: Ye ame agaŋ ne tini ŋgina le nu sakina: Naŋe sikor muli ŋak naŋe ndumndum ta turmba ye sa ŋgina le nu agaŋ ndende ta pino ta kile tuna. Taŋamba nu nu ndoŋ kinyna le nu kiŋo konna. ");
INSERT INTO ssd_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Taŋamba Tamar nu luka nuŋe tumbraŋ kina sulumba tumail pasi soŋgina tawi ta paska kuembol tawi maŋ silikina. ");
INSERT INTO ssd_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kile Yuda nu gulab nuŋe Hira kukulna le meme ande pino ta tambim tuku tumba kina ta nu pino ta kaŋger ndana sulumba agaŋ ndende pino ta kilna ta mata luka kile ndakina. ");
INSERT INTO ssd_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Taŋamba nu tumbraŋ ta tuku taŋgo afu kaŋgerka kusnaniŋgina: Pino ande ndin teŋge minyok minna ta kile ani taŋge minit ŋgina kande nane nu sanaig: i ... Pino ande ndin teŋge mine ndakate ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Taŋamba sanaig le Hira nu luka Yuda tugum kumba sana: Ye pino ta te-sili ndakit. Tumbraŋ ta tuku taŋgo kame nane pino ande kaŋger ndanaig ŋga sakaig ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda nu ndek sakina: Taŋgo kame sine nzumilsiŋbekaig ŋga agaŋ ndende ta nuŋe kilwa ŋgina. Nu nuŋe piya ye tambim tuku sakit ta ne nu te-sili ndakat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Taŋamba minnaig ma ma tambun keŋmba kinaig le nane afu pro Yuda sanaig: Rugan naŋe Tamar nu fare-farekina sulumba kile nu fuŋgul ŋak minit ŋginaig le Yuda ndek nane saniŋgina: Tane kumba ka pino ta tumba te-kilimba pambi piyap le kumwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Nane nu tumba te-kilimam bafunaig le Tamar nu pino ande kukulna le rugan nuŋe Yuda sota kumba sana: Rugan naŋe teŋenmba sakate. Taŋgo nu fuŋgul ye sina ta nu tuku agaŋ ndende noten. Ne sikor muli ŋak te ndumndum te turmba kaŋgerka ŋga sakate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Taŋakina le Yuda nu agaŋ ndende ta kaŋgerka katesena sulumba sakina: Pino ta nu son sakate. Ye mbaren. Ye yiŋe kiŋo Sela nu tambim tuku ta tuwe ndaken ŋgina. Taŋamba Yuda nu maŋ Tamar ndoŋ kinye ndakina. ");
INSERT INTO ssd_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar nu kiŋo te-palmbim tuku ait kumuŋgina le nu kiŋo armba kile-patikam tuku ŋgaro kamusna. ");
INSERT INTO ssd_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Nu kutumba minna le kiŋo ande tuku wai prona le kulat pino taŋge wai ta tumba muli ande gurgur wai mbol kusna sulumba sakina: Te ta mulum ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","kiŋo ta wai te-lukina le kiŋo inum ta amboŋga prona. Taŋana le kulat pino ta nu sakina: Ne sonndo sambrimba prote ŋgina. Ta tuku nane kiŋo ta nyunu Peres ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Taŋakinaig le maib nuŋe wainu muli gurgur ŋak ta prona le nyunu Sera ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ismael mbal nane Yosef tumba Isip pronaig le Isipnu taŋgo Potifar nu Isip tuku gabat suŋgo kumnemŋge nuŋe wande kulatkade mbal ta kulatka minna ta nuŋge Yosef piyamba tina. ");
INSERT INTO ssd_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yosef nu nuŋe kulat taŋgo tuku wandekŋge minna le Suŋgo nu Yosef sinzaŋna le nu tuku mine mayenu ndo mayok kina le ");
INSERT INTO ssd_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","nuŋe kulat taŋgo ta nu tuku piro mayenu ta kaŋgerna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","nu Yosef tuku garena le Yosef nu nu kumnemŋge pirokina. Taŋamba nu nu tuku wande, wande mbolŋge agaŋ ndende, nu tuku taŋgo kame ta ŋakmba Yosef tuku wai mbolŋge patikina le nuŋge nane kulatkina. ");
INSERT INTO ssd_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Taŋana le Suŋgo nu Isip taŋgo ta tuku agaŋ ŋakmba wandekŋge piro mbolŋge nyaro niŋgina le mine mayemba minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Taŋamba Yosefŋge nu tuku agaŋ ndende ŋakmba kulatka minna le nuŋe kulat taŋgo ta nu nuŋe agaŋ ndende ta tuku idus ndana. Nu isukusam tuku ta ndo idusmba minna. Yosef tuku ŋgarosu tumail pasi maditaknu ndo. ");
INSERT INTO ssd_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Mara ande Potifar piyo nuŋe nu Yosef kaŋgermba am kikoŋ tiŋgina le Yosef sana: Ne ilmba ye ndoŋ karpe ŋgina ta ");
INSERT INTO ssd_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","nu mbulmba wo ndamba nuŋe kulat taŋgo tuku piyo nuŋe ta teŋenmba sana: Yiŋe kulat taŋgo nu wande te mbolŋge agaŋ ndende ŋakmba ye tuku wai mbolŋge patikina le ye kulatka minet. Nu agaŋ ande tuku idus ndate. ");
INSERT INTO ssd_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Wande te mbolŋge taŋgo ande ye li ndayate. Agaŋ inum ye ŋgail ndayina. Neŋge ndo nu tuku piyo nuŋe ye ne kulat ndaket. Ta tuku ye ndaŋmba maŋau ŋayonu suŋgo te ki? Ye siŋka Kuate tuku miŋge lukamba une te kam kumuŋ kuga ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Pino ta mara mindek Yosef te-saimba minanu ta Yosef nu nda womba nu ndoŋ minam mbulanu. ");
INSERT INTO ssd_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Taŋamba minnaig ma ma mara ande Yosef nu pirokam wandek sinam kina. Ait ta mbolŋge piro taŋgo ande mine ndakina le ");
INSERT INTO ssd_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","pino ta maŋ pro Yosef tuku tawi kuennu silikina ta pakarka biymba sana: Sile karpe ŋgina kande Yosef nu mbulmba nuŋe tawi kuennu ta pino ta tuku wai mbolŋge kusremba kua ka mayok kina. ");
INSERT INTO ssd_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Taŋana le pino ta tawi kuen nu tuku wai mbolŋge kusrena ta kaŋgermba ");
INSERT INTO ssd_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nuŋe piro taŋgo kame wike lika saniŋgina: Ai te. Hibru taŋgo ta sine kiko pilesiŋgam tuku sine tugum prona. Nu ye ndoŋ minam tuku ye tugum prowat le ye suŋgomba witiwit le ");
INSERT INTO ssd_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","nu ye tuku wi ismba tawi kusremba kua ka mayok ket ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Taŋamba saniŋmba nu tawi ta pilna le minna. Taŋgo nuŋe luka prona le ");
INSERT INTO ssd_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","nu wam kubeu tumba sana: Ne Hibru taŋgo tumba sine tugum prona ta nu ye kiko pileyam tuku ye tugum prowat le ");
INSERT INTO ssd_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","suŋgomba witiwit le ismba nu tawi kusremba kua ka mayok ket ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yosef tuku kulat taŋgo nu piyo nuŋe tuku pasa ta ismba gubra mayena le ");
INSERT INTO ssd_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","nu Yosef muliŋtumba wandekŋge pilna le minna. Muli wande ta Farao tuku taŋgo muliŋ kilanu le nane kilmba wandek sinam taŋge patikanu le minanu. ");
INSERT INTO ssd_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yosef nu muli wandek sinam taŋge minna le Suŋgo nu mara mindek nu sinzaŋmba nyaro mayenu tambinu. Ta tuku muli wande tuku kulat taŋgo ta nu Yosef tuku garena le ");
INSERT INTO ssd_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","muliŋ kilanu taŋgo ŋakmba nu tuku wai mbolŋge patikina le nu piro ŋakmba kulatka minna. ");
INSERT INTO ssd_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Suŋgo nu Yosef sinzaŋna tukunu muli wande tuku kulat taŋgo ta nu Yosef agaŋ ndende kulatkina ta nu idus ndaniŋgina. Agaŋ ndende ŋakmba nu kulatkina ta mine magenaig. ");
INSERT INTO ssd_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Mara afu kuganaig le Isip tuku gabat suŋgo tuku grep kule kulatkanu gabat nale bret pasokanu gabat ndoŋ nale nakile gabat suŋgo Farao tugumŋge maŋau ande mbarnaik le ");
INSERT INTO ssd_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao nu piro gabat ar ta tuku gubra suŋgo tina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","nale muliŋ kilmba kame gabat tuku wandekŋge patikina le minnaik. Yosef nu mata muli wande ndui ta sinamŋge minna. ");
INSERT INTO ssd_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Taŋamba minnaig ma ma kame gabat suŋgo ta Yosef nale tuku kulat taŋgo minwa ŋga madina. ");
INSERT INTO ssd_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Furir ait ande Farao tuku bret pasokanu gabat nale grep kule kulatkanu gabat ndoŋ nale kiŋatinaik ta kiŋa ta tugunu yimyam. ");
INSERT INTO ssd_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mafena le maratukuk Yosef nu nale tugum prona le nale wamdus sulumba minnaik le nu katesemba ");
INSERT INTO ssd_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","nale kusnanikina: Tale ndaŋam tumail pasi kume ŋgurŋgurka minik ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","nale ndek sanaik: Sile kiŋatik ta andeŋge sile tuku kiŋa tugu ta bitekŋgam tuku mine ndakate ŋginaik. Taŋakinaik le Yosef ndek nale sanikina: Kuateŋge ndo nu sine tuku kiŋa tugu bitekŋgam kumuŋ. Tane ye ndoŋ kubewap le ye isi ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","grep kule kulatkanu gabat ta nu nuŋe kiŋatina ta ndek Yosef kubeu tuna sulumba sana: Ye kiŋatumba grep muli ande ye tugumŋge minat le kaŋgerit. ");
INSERT INTO ssd_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Grep muli ta wainu keŋmba. Nu pitik ndo nzumba silo promba alonu mayok ka pitik ndo manderke suluwaig le kaŋgerkit. ");
INSERT INTO ssd_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Taŋamba ye ndek Farao tuku murko biye ŋak grep muli alonu afu kilmba waimbi piske likit le kulenu murko sinam ket le murko ŋak tumba ka Farao tuwit ŋga Yosef sana. ");
INSERT INTO ssd_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Taŋaka sana le Yosef nu ismba sakina: Ne tuku kiŋa tugunu ta teŋenmba. Grep muli wainu keŋmba kaŋgerkat ta mara keŋmba tuku. ");
INSERT INTO ssd_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mara keŋmba ta kuwaig le Farao nu ne maŋ te-luka tamŋgat. Taŋamba nu ne maŋ naŋe piro mbolŋge palmbimŋgat. Taŋawa le ne buk Farao tuku grep kule murko ŋak Farao tumba minna ta ne maŋ piro ta kamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ta tuku ne isa. Ne taŋamba mine mayewa sulumba ye idusyumba mina. Ne ye tuku ŋga Farao sawa le ye muli wandek sinam teŋge minet ta ye te-kilimyuwa. ");
INSERT INTO ssd_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","O buk nane ye Hibru mbal tuku kilke mbolŋge ye sanzal taŋgo taŋaŋ kuayar tumba te pronaig. Ye Isip kilke te mbolŋge minen ta ye maŋau ande mbar ndawen. Nane ye ake sinaŋ muliŋtumba wande te sinamŋge pilnaig le ye minet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Taŋakina le bret pasokanu gabat ta kiŋa tugunu mayenu ta ismba nu suk ndek Yosef sana: Ye mata kiŋa ande tit ta teŋenmba. Ye sambe keŋmba kilmba babokit ta sinamŋge bret yeki yeki sambe ta liganu ŋak. ");
INSERT INTO ssd_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Sambe keŋnu mbolmba babowit ta Farao tuku bret kikoŋnu foŋfoŋ yeki yeki minaig le sar umaŋŋge pro nye suglukaig le kaŋgerkit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Taŋakina le Yosef nu kiŋa ta isna sulumba sana: Kiŋa ta tugunu teŋenmba. Sambe keŋmba ta mara keŋmba taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mara keŋmba kugawaig le Farao ne tumba te-kilimnuwa le nane ne tuku ŋinfok kat puramŋgaig. Taŋawaig sulumba ne tuku mindesiŋ ta tumba ail darok ande mbolŋge taikuwaig le sar umaŋŋge pro ne tuku ndem paska nyamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Mara keŋmba kuganaig le Farao te-pilna tuku pagumba nye suŋgo ait ta mbolŋge nu nuŋe gabat kame ta ŋakmba wike likina. Taŋamba nu muliŋ kilanu taŋgo ar ta turmba kile-kilimka nuŋe gabat kame tumailamŋge kile-tidiŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","nu grep kule kulatkanu gabat ta maŋ luka tumba nuŋe piro mbolŋge pilna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","bret pasokanu gabat ta ndo tumba nuŋe kame mbal niŋgina le naneŋge nu tuku ŋinfok kat purnaig le kumna. Yosef nu nale tuku kiŋa tugu kukliniŋgina ta taŋamba ndo kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Taŋana le grep kule kulatkanu gabat ta nu Yosef idus ndamba ndo gilai mayena. ");
INSERT INTO ssd_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Bret pasokanu gabat ta balenaig le yar armba kinaig le Farao nu kiŋatina sulumba nu Nail kule make mbiŋge tiŋ minna. ");
INSERT INTO ssd_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nu taŋge tiŋ minna le makau butuknu 7 kule sinam taŋge pronaig sulumba pibi nyumba minnaig le kaŋgerkina. ");
INSERT INTO ssd_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kaŋgerka minna le makau nziroŋsu prowanu 7 kule sinam taŋge pronaig sulumba kuasmbi amboŋga prona ta tugumŋge kule make mbiŋge tiŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Taŋamba makau nziroŋsu prowanu kame taŋge makau butuknu ta kile-ŋinke suglukinaig. Taŋanaig le Farao nu birtekŋga aboŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Taŋamba nu maŋ kinyna sulumba maŋ lato kiŋatumba wit tugu ndindo ta mbolŋge alonu 7 kaŋgerkina. Nane alonu tikŋganu magekinaig. ");
INSERT INTO ssd_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Wit tugu ndui ta mbolŋge maŋ alonu 7 pronaig ta nane alo pirik-parak ndo ma paknu tuku bubrenuŋge fruŋniŋgina tuku. ");
INSERT INTO ssd_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Taŋamba wit alo pirik-parak taŋge wit alo tikŋganu ta ŋakmba kile-ŋinke suglukinaig. Taŋanaig le Farao nu aboŋga kiŋatina ta idusmba minna. ");
INSERT INTO ssd_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mafena le nu kiŋa ta tuku wamdus sulumba minna. Taŋamba nu Isipnu kila taŋgo kagmaikanu mbal ta ŋakmba wike likina le nane promba maŋgurkinaig le nu ndek kiŋa kilna ta kubeu niŋgina ta ande nu kiŋa ta tugunu kukliwam tuku mine ndakina. ");
INSERT INTO ssd_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Taŋamba minnaig le grep kule kulatkanu gabat ta nu ndek Farao sana: Kile ye mbaren ta ne ndoŋ sanuŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","O buk ne tuku piro taŋgo ar sile bret pasokanu gabat ndoŋ ne sile tuku gubra tina sulumba ne sile muliŋ kilmba ka kame gabat tuku wandekŋge patikina le sile minkeŋ. ");
INSERT INTO ssd_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Taŋge minkeŋ sulumba furir ande mbolŋge sile kiŋatikeŋ. Kiŋatikeŋ ta tugunu yimyam. ");
INSERT INTO ssd_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Hibru taŋgo mbanzo ande nu kame gabat tuku piro taŋgo nu sile ŋak minna le sile kiŋatikeŋ ta nu kubeu tukeŋ le nuŋge kiŋa tugunu kukliniŋmba sasikina. ");
INSERT INTO ssd_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Sasikina ta kumumba mayok kina. Ne ye luka tina sulumba yiŋe piro mbolŋge pilna. Bret pasokanu gabat ta ne tumba ŋinfok kuerka ail mbolŋge taikina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Taŋakina le Farao ndek taŋgo afu kukulniŋgina le nane pitik ndo kinaig ka muli wandek sinamŋge Yosef te-mayoknaig. Taŋanaig le Yosef ndek gigloka tawi mayenu tiŋmba Farao tugum prona. ");
INSERT INTO ssd_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Prona le Farao ndek nu sana: Ye kiŋa ande ten ta taŋgo ŋakmba nane kiŋa tugunu bitekŋgam kumuŋ kuga le taŋgo ande teŋenmba ye sayat: Ne kiŋa ismba ta ne tugunu bitekŋgam kumuŋ ŋgat le ye isit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Taŋakina le Yosef ndek sakina: O taŋgo suŋgo, yeŋge kumuŋ kuga. Kuate nuŋge ndo ne tuku kiŋa tugu bitek mayewam kumuŋ ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Farao nu sana: Ye kiŋaten ta teŋenmba. Ye Nail kule make mbiŋge tiŋ minen le ");
INSERT INTO ssd_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","makau butuknu 7 kule sinam taŋge promba kule make mbiŋge pibi nyumba minnaig le kaŋgerken. ");
INSERT INTO ssd_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ŋgumneŋga maŋ makau 7 nziroŋsu prowanu kule sinam taŋge pronaig. Ye buk Isip ma te mbolŋge makau taŋaŋ ande kaŋger ndawen. ");
INSERT INTO ssd_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Makau nziroŋsu prowanu taŋge ndek makau butuknu ta ŋakmba kile-ŋinkinaig. ");
INSERT INTO ssd_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Nane kile-ŋinkinaig ta nane ndanyanu sukmba nane nziroŋsu prowanu taŋamba ndo minmba minnaig. Taŋamba kaŋgerken sulumba ye aboŋgen. ");
INSERT INTO ssd_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Kile ye maŋ kinyen sulumba maŋ kiŋaten. Ye wit tugu ndindo mbolŋge alonu 7 kaŋgerken ta alonu sugokanu tikŋganu. ");
INSERT INTO ssd_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Tugu ndui ta mbolŋge maŋ alonu 7 pronaig ta alonu pirik-parak ndo ma paknu tuku bubrenuŋge fruŋniŋgina tuku. ");
INSERT INTO ssd_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kile wit alo pirik-parak taŋge wit alo tikŋganu ta ŋakmba kilmba kile-ŋinke suglukinaig. Ye taŋamba kaŋgeren sulumba kiŋa ta kagmaikade mbal saniŋgen ta nane ŋgamukŋge ande kiŋa tugunu kuklimba sa ndayina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Taŋaka sakina le Yosef ndek Farao sana: Kiŋa armba ta tugunu ndindo ndo. Kuate nu maŋau kam bafute ta ne tumnina. ");
INSERT INTO ssd_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Makau butuknu 7 ta yar 7 taŋaŋ. Wit alo tikŋganu 7 ta mata yar 7 taŋaŋ. Kiŋa ar ta tugunu ndui ta ndo. ");
INSERT INTO ssd_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Makau 7 nziroŋsu prowanu ŋgumneŋga pronaig le wit alonu pirik-parak ndo 7 bubre paknuŋge fruŋniŋge likina tuku ta teŋenmba. Yar 7 guba suŋgo tuku ait prowamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ye buk ne sanit taŋamba ndo Kuate maŋau kam bafute ta ne tumnina. ");
INSERT INTO ssd_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Yar 7 ta sinamŋge Isip kilke te mbolŋge nyamagaŋŋge ndo kumuŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Yar 7 ta kugawaig le maŋ yar 7 guba suŋgo prowamŋgat. Isip kilke ŋakmba gubak minwaig sulumba nyamagaŋ ŋak ait ta iduse nda. Nane gilaiŋgamŋgaig. Guba ait suŋgoŋge kilke tugu te ŋayo siliwamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Guba ait ta sonndo ait ŋayonu tukunu taŋgo pino nane maro suŋgo te-silikuwaig sulumba nyamagaŋ ŋak ait ta iduse nda. ");
INSERT INTO ssd_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kuate nu o buk wam ta kam tuku wamdus kuyarkina. Nu siŋka maŋau ta kamŋgat. Ta tuku ne kiŋa ta tam arna. Mine minemba Kuate nu wam kame ta kile-mayokkamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ta tuku ne taŋgo ande wamdus kuyar mayenu ŋak te-silika le nuŋge Isip ma tugu te ŋakmba kulatkuwa. ");
INSERT INTO ssd_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Gabat kame afu turmba madiniŋga le nane yar 7 nyamagaŋ suŋgomba ŋak ta sinamŋge nane Isip mbal tuku nyamagaŋ ŋakmba walmba patike likuwaig. Bailkamba taŋgo pino nyam tuku ndindo minam tuku. ");
INSERT INTO ssd_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ne gabat kame ta saniŋga le nane yar magenu 7 ta tuku wit ta ŋakmba kile-maŋgurka patikuwaig sulumba kulat magekuwaig. ");
INSERT INTO ssd_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Guba tuku yar 7 ta Isip kilke mbolŋge prowa le Isip taŋgo pino nane nyamagaŋ maŋgurkuwaig ta nyumba nane gubanu kume nda ŋga Farao sana. ");
INSERT INTO ssd_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Farao nu nuŋe gabat sugo ta ndoŋ pasa ta ismba maye ŋginaig sulumba ");
INSERT INTO ssd_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","nu ndek nane saniŋgina: Taŋgo te nu Kuate tuku Guwa ŋak. Sine taŋgo teŋen inum animŋge te-silikube ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Taŋamba nu ndek Yosef sana: Kuate nu nuŋe miroŋ wam kame te tumnat. Ta tuku taŋgo ande wamdus kuyar mayenu ŋak ne minit taŋaŋ mine ndakate. ");
INSERT INTO ssd_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kile ye ne tumba yiŋe kilke tugu te tuku gabat suŋgo palmbimŋgit. Yiŋe kuasmbi ŋakmba nane ne tuku miŋge kumnemŋge minamŋgaig. Yeŋge ndo ye gabat suŋgo minmba nyu ŋak mbolŋge minamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kile ye ne tumba Isip kilke tugu te ŋakmba tuku gabat suŋgo madinet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Taŋakina sulumba Farao nu nuŋe waitok yubi ta paska Yosef tuku waitok mbolŋge pilna. (Waitok yubi ta gabat suŋgo tuku waitok yubi ndo. Farao tuku kuyar ŋak). Taŋamba nu ndek tawi mayenu ande tumba Yosef siluk tuna sulumba kalolai mayenu ande golmbi wakeinaig tuku tumba nu tuku ŋinfok mbolŋge birŋeŋ tuna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","nu ndek Farao dubiknu tuku karis mayenu ta tumba Yosef tuna le nu tambi likina. Kame mbal nane ŋgumbeyumba kumbaŋge sakinaig: Ndin kusrewap o, ndin kusrewap o ŋginaig. Maŋau ta mbolŋge Farao nu Yosef tumba Isip kilke ŋakmba tuku gabat suŋgo pilna. ");
INSERT INTO ssd_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kile Farao nu ndek Yosef sana: Ye gabat suŋgo Farao ye ne sanet. Isipnu taŋgo kame nane naŋgine nzalimbi maŋau afu ke nda. Nane maŋau ande kam idusmba ne kusnanuwaig le ne woka ta nane maŋau ta kamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Taŋamba nu Yosef tuku nyu kitek tuna ta Safenat-Paneya ŋgina sulumba nu pino ande tumba Yosef tuna le tina. Pino ta nyunu Asenat. Mam nuŋe nyunu Potifera. Nu Heliopolis tumbraŋ suŋgo tuku pris minna. Yosef nu yar 30 ŋak minna sulumba Farao tuku piro tugu pilna. Nu Farao kusremba Isip tuku ma tugu ŋakmba mbol likina. ");
INSERT INTO ssd_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Yar magenu 7 ta sinamŋge kilke nyamagaŋŋge ndo kumuŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","nu nyamagaŋ ta kilmba tumbraŋ ŋakmba tuku nyamagaŋ wandek sinamŋge patike likina sulumba tumbraŋ mindek sinamŋge wit yeki yeki kile-wandek ke likina. ");
INSERT INTO ssd_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yosef nu wit suŋgomba maŋgurkina ta burnu kumuŋ kuga piyalŋge fulbul minig taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Guba tuku ait ta pro ndamba minna le Yosef piyo nuŋe Asenat nu kiŋo armba kile-patikina. ");
INSERT INTO ssd_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Taŋana le Yosef ndek sakina: Kuate nu ye sinzaŋyina le ye yiŋe piti ŋakmba yiŋe ndare tuma tuku maŋau ŋaigonu ta ŋakmba gilaiŋgen ŋgina. Ta tuku nu nuŋe kiŋo mulum ta nyunu Manase ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Taŋamba nu maŋ lato sakina: Ye kilke piti ten te mbolŋge Kuate nu kiŋo te ye sat ŋgina sulumba kiŋo arnu ta nyunu Efraim ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Kile yar 7 nyamagaŋ ŋak ta kuganaig le ");
INSERT INTO ssd_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","yar 7 guba tuku ait Yosef tuku pasa kumumba tugu pilna le kilke ŋakmba guba suŋgo te-silikinaig. Isip kilke mbolŋge ndo nane nyamagaŋ ŋak minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Taŋamba minnaig ma ma Isip mbal nane mata guba suŋgo tinaig sulumba Farao tugum kumba sanaig: Sine nyamagaŋmbi turka ŋginaig le nu ndek nane saniŋgina: Tane Yosef tugum kape le ndaŋmba satiŋguwa ndeta taŋamba kap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Guba ta kile suŋgo ŋayomba Isip ma tugu ŋakmba kumuŋgina le Yosef nu ndek nyamagaŋ wande ŋakmba talke likina le Isip mbal nane pro wit piyawe likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Kilke ŋakmba guba suŋgo tinaig tukunu kilke tugu ŋakmba nane mata wit piyawam tuku Isip kilke mbol Yosef tugum prowe likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kile Yakob Isipŋge wit minnaig ta isna sulumba nuŋe kiŋo kat nuŋe saniŋgina: Ndaŋam saka tane guba tuku ri ndamba ake minig? ");
INSERT INTO ssd_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Isipŋge wit minig ŋga sakade le iset. Tane kumba ka afu piyawap. Kuga ta sine gubanu kumamŋgig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Taŋakina le Yosef tuku aba kat nuŋe 10 ta tiŋga wit piyawam tuku Isip kilke mbol kinaig ta ");
INSERT INTO ssd_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yakob nu Yosef tuku mambo nuŋe ndinok Benyamin piti ande te-silikikat ŋga nane ndoŋ pilna le ndakina. ");
INSERT INTO ssd_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kananŋge guba suŋgo prona tukunu Israel tuku kiŋo kat nuŋe mbal afu ndoŋ wit piyawam Isip kilke mbol pronaig. ");
INSERT INTO ssd_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yosef nu Isip tuku gabat suŋgo minna tukunu nuŋge wit ŋakmba kulatka piyamba minna. Ta tuku nuŋe aba kat nuŋe nane pro nu tumailamŋge dagol tidroŋga lokinaig le ");
INSERT INTO ssd_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosef nu nuŋe aba kat nuŋe kaŋgerka katesena sulumba nu ndek nane-naneniŋmba ŋerŋerka pasa saŋgrimbi nane kusnaniŋgina: Tane aniŋge prowaig ŋgina le nane nu sanaig: Sine Kananŋge nyamagaŋ piyawam tuku te prowig ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosef nu aba kat nuŋe kateseniŋgina ta nane nu kaŋgermba wam lislisnaig le ");
INSERT INTO ssd_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","nu o buk kiŋatina ta kile idusmba saniŋgina: Tane ma wam katesewam tuku likade. Tumbraŋ ndaŋ ndaŋ nu kame buwam tuku saŋgri kuga ta kaŋgermba likade ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","nane nu sanaig: O taŋgo suŋgo, taŋamba kuga. Sine ne tuku piro taŋgo ndo. Sine nyamagaŋ piyawam prowig. ");
INSERT INTO ssd_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Sine tugu ndindo ndo. Sine ma wam katesewam tuku li ndakeg. Sine yabri pasa sa ndaka son pasa sakeg ŋginaig kande ");
INSERT INTO ssd_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yosef ndek nane saniŋgina: Kuga. Tane sine tuku kilke tugu te ndaŋ ndaŋ nu kame buwam tuku saŋgri kuga ta kaŋgeram prowaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Taŋakina le nane ndek sakinaig: O taŋgo suŋgo, sine taŋgo ndindo tuku kutu. Mam nu Kanannu. Sine ŋakmba taŋgo 12 ta sine tuku mambo ande kumna. Siŋgine maib fudiŋ kusregeŋ le mam ndoŋ minit ŋginaig kande ");
INSERT INTO ssd_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosef ndek nane saniŋgina: Ye sakit not ndo. Tane ma wam katesewam tuku likade. ");
INSERT INTO ssd_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ye katesewam tuku tane teŋenmba tagotiŋgamŋgit. Ye sonndo Farao tuku nyu mbolŋge pasa saŋgri pilewet. Tane tuku maib taŋgine te nda prowa ta tane ŋakmba maŋ luka taŋgine tumbraŋ kine nda. ");
INSERT INTO ssd_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tane tuku ande luka kumba ka maib taŋgine tumba te prowa. Tane afu ŋakmba muli wande kape le tane son sakade e ko yabrikade ta ye kaŋgeramŋgit. Ye siŋka Farao tuku nyu mbolŋge saket. Maib taŋgine nda prowa ta ye kila tane ma wam katesewam tuku likade ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Nu taŋamba sake deŋpurmba nane kilmba muli wandek sinamŋge patikina le ait keŋmba minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ait keŋnu mbolŋge Yosef ndek nane saniŋgina: Ye Kuate kumnemŋge minmba nu tuku nyu kurauket tuku. Tane ye tuku miŋge dubiwap ta tane maye minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Tane son pasa sakade ndeta tane tuku ande muli wandek sinam teŋge minwa le tane afu ŋakmba taŋgine wit piyanaig ta kilmba ka taŋgine kuasmbi gubak tawondo minig ta niŋgap. ");
INSERT INTO ssd_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Taŋamba taŋgine maib taŋgine fudiŋ ta tumba ye tugum prowap. Taŋawap le ye tane son sakade ta kaŋgermba ye tane baletiŋge nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Taŋakina le Yosef aba kat nuŋe naŋgine naŋgine teŋenmba sakinaig: Son. Sine siŋgine miroŋ siŋgine maib tumba ŋayo siligeŋ le nu wamdus fagka sarsarka ye turyap e ŋgina ta sine ismba nda isanu sukgeŋ. Wam ta tuku kile sine piti teg ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Taŋakinaig le Ruben ndek sakina: Ye o buk satiŋgen: Siŋgine maib ŋayo sili ndawap ŋgen ta tane ye tuku pasa nda isnaig. Kile ndare ta lafunu piti teg ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yosef nu nane tuku pasa ta kagmaŋga minna ta aba kat nuŋe nane katese ndanaig. Ta ndaŋam? Yosef nu nane ndoŋ Hibru pasa ndatina. Nane pasatanu le pasa mbilam taŋgo andeŋge pasa mbilmba Yosef aba kat nuŋe saniŋganu. ");
INSERT INTO ssd_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Kile Yosef nu nane kusreka ka malmbikina. Nu malmbi deŋpurmba maŋ pro nane ndoŋ pasatumba minna sulumba Simeon madimba aba kat nuŋe tumailamŋge ndaleka kusnaig. ");
INSERT INTO ssd_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Kile Yosef ndek nane afu wam pagukina le nu tuku pasa dubimba aba kat nuŋe tuku bek ta wit fuluknye likinaig sulumba nane tuku ndametiŋ mata luka wit bek sinam taŋge sigrikinaig. Taŋanaig sulumba nyamagaŋ afu ndinŋge nyam tuku turmba niŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Taŋanaig le aba kat nuŋe nane wit piyanaig ta kilmba naŋgine doŋki kame mbolŋge patikinaig sulumba kinaig kumba ka ");
INSERT INTO ssd_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","furirna le kinyanu ma ande mbol promba nane tuku ande nuŋe doŋki tuku nyamagaŋ kilam saka nuŋe bek talka mambilna kande nuŋe ndametiŋ bek sinam taŋge minnaig le kaŋgerkina. ");
INSERT INTO ssd_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kaŋgerkina sulumba aba kat nuŋe wika saniŋgina: Ai te. Ye tuku ndametiŋ luka sigrikaig te ŋgina. Taŋakina le nane wamdus fulilka kuru-kuruka naŋgine naŋgine sakinaig: i ... Kuate nu ame maŋau sine mbolŋge teŋenmba kat ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Nane ndek kumba ka Kanan kilke mbol promba mam naŋgine tugum kinaig sulumba wam ŋakmba ta nu kubeu tumba sakinaig: ");
INSERT INTO ssd_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Isip tuku gabat suŋgo ta ŋerŋerka pasa saŋgrimbi sine ndoŋ pasatina sulumba tane ma wam katesewam tuku likade ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","sine lafumba sakigeŋ: Sine ma katesewam tuku mbal kuga. Sine son pasa ndo sakeg. ");
INSERT INTO ssd_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Sine taŋgo ndindo tuku kutu. Sine ŋakmba taŋgo 12 ta mambo ande kumna le sine tuku maib fudiŋ kile mam ndoŋ Kananŋge minit ŋga sageŋ le ");
INSERT INTO ssd_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","taŋgo ta nu sakina: Tane son sakade e ko kuga ta ye kaŋgeramŋgit. Tane ande ye ndoŋ minwa le tane afu ŋakmba wit kilmba ka taŋgine kuasmbi gubak tawondo minig ta niŋgap. ");
INSERT INTO ssd_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Taŋamba taŋgine maib taŋgine tumba ye tugum prowap le tane ma katesewam tuku mbal kuga tane son pasa sakade ta ye kaŋgeramŋgit. Tane taŋawap le ye taŋgine aba taŋgine paska luka tane tiŋgi le tane teŋge ndo nyamagaŋ piyamba minap ŋga sasiŋgina ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Nane taŋamba mam naŋgine sanaig sulumba naŋgine bek wit ŋak ta kutuniŋmba naŋgine pale fat yimyam ndametiŋ ŋak ŋak ta kaŋgerka mam naŋgine ndoŋ kuru kuru suŋgo tinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","mam naŋgine ndek saniŋgina: Tane ndaŋam saka yiŋe kiŋo kame ŋakmba kile-ŋgisikade e? Yosef buk ŋgisikina. Simeon kile maŋ ŋgisikat. Kile tane maŋ Benyamin tumba kambim tuku sakade. Ye sonndo piti suŋgomba kile-sigliket ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Taŋakina le Ruben ndek mam nuŋe sana: O mam, ne isa. Ye Benyamin nda tumba ne tugum luka prowi ndeta ne yiŋe kiŋo ar ta bale fara. Sine kumba yeŋge Benyamin kulatki sulumba maŋ luka ne tugum prowamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yakob nu sana: Yiŋe kiŋo ta tane ndoŋ kine nda. Aba nuŋe buk kumna. Kile nu nuŋe ndo minit. Nu mata ndinŋge piti ande te-silikikat. Ye buk saibo pilen. Nu kumwa ta tane ye tuku ŋgamuŋgal kuerkap le ye wamdus tatrukuwa le kumamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kile Kananŋge guba ait ta suŋgokina le ");
INSERT INTO ssd_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yakob tuku kuasmbi wit Isipŋge kilnaig ta buk nye suglukinaig sulumba Yakobŋge kiŋo kat nuŋe kukulniŋgina le maŋ luka nyamagaŋ piyawam tuku Isip kuwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Taŋakina le Yudaŋge nu sana: Mam, sine buk ne pasa sanigeŋ ta Isip tuku gabat suŋgo ta nu sine kaŋgerka ŋerŋerka pasa saŋgrinu sasiŋgina. Nu sakina sine maib tumba kine ndakube ta nu sonndo sine kaŋgerke nda. ");
INSERT INTO ssd_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ne siŋgine maib fudiŋ ta ŋgail ndaka ta sine maŋ kumba ka ne tuku nyamagaŋ afu piyaniŋgamŋgig. ");
INSERT INTO ssd_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kuga ta sine kine nda. Isip tuku gabat ta nu buk sakina sine maib nda tumba kab ta nu sine kaŋgerke nda ŋga mam nuŋe sana. ");
INSERT INTO ssd_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Taŋakina le Israel ndek sakina: Tane ndaŋam tuku gabat suŋgo ta mambo taŋgine tuku sanaig le ye kile piti suŋgoyate ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","nane ndek nu sanaig: Taŋgo ta nu sine kusnasiŋmba lok ndeka minna sulumba nu sine tuku tugu mata kusnaŋgina le sine maŋau ke fugugeŋ. Ne tuku mata kusnaŋgina. Nu teŋenmba sakina. Tane mambo taŋgine ande minit e ko kuga ŋgina. Taŋakina le sine nu sageŋ. Nu siŋgine mambo tumba nu tugum kambim tuku ta sine kila kande nu sa ndageŋ kande ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Taŋakinaig sulumba Yuda nu maŋ mam nuŋe sana: Mam, Benyamin sine ndoŋ kukula le yeŋge kulatki. Ne taŋawa le sine kile ndo kaŋgig. Taŋamba sine gubanu kume nda. ");
INSERT INTO ssd_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ye nu kulat maye ndamba luka tumba pro ndawi ndeta piti ta ye mbolŋge minmba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Sine dal ndakigeŋ kande sine buk Isip kilke mbol kumba lukam argeŋ kande ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Taŋamba sana le Mam naŋgineŋge nane saniŋgina: Taŋamba ndeta tane siŋgine nyamagaŋ magenu kikoŋnu afu kilmba sigrika gabat suŋgo ta tambim tuku kilmba kape. Grep alonu pagranu, ŋguimzaŋ kulenu, agaŋ ndende mundur magenu afu ta ŋakmba kilmba kape sulumba kaŋair alonu pistasio le amon afu turmba kilmba kumba nu tape. ");
INSERT INTO ssd_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Tane ndametiŋ soŋ amboŋga nyamagaŋ tuku kilnaig ta kilmba maŋ nyamagaŋ kitek tuku ta ulendimba kilmba maŋ luka kape. Nane mbarmba ndametiŋ ta luka sigrikinaig inde. ");
INSERT INTO ssd_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mambo taŋgine te tap sulumba pitik taŋgo ta sota luka kape. ");
INSERT INTO ssd_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kuate Saŋgri Ŋayo nuŋge taŋgo ta wamdus biye mbilwa le nu tane sinatiŋmba Benyamin nale aba taŋgine ande ta turmba maŋ patikuwa le luka prowap. Yiŋe kiŋo kame ŋakmba ŋgisikuwaig ndeta taŋaig ta Kuate nuŋe agaŋ ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Taŋakina le Israel tuku kuasmbi nane Isip gabat tuku gare tambim tuku agaŋ ndende ta kilmba ndametiŋ armba ta turmba kilmba Benyamin tumba Isip kilke mbol kinaig ka taŋge Yosef tugum pronaig. ");
INSERT INTO ssd_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yosef nu ndek mambilmba aba kat nuŋe Benyamin turmba kaŋgerka nuŋe wande kulatkanu taŋgo ta sana: Ne taŋgo kame te kilmba yiŋe wande mbol kaye. Nane ki mbol ye ndoŋ isukusamŋgig. Ne kumba ka agaŋmor ande balemba kuapika ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Taŋakina le piro taŋgo ta Yosef pasatina ta kumumba kina. Nu nane ta kilmba Yosef tuku wande mbol kinaig le ");
INSERT INTO ssd_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","nane kuru-kuruka teŋenmba idusnaig: Ndametiŋ buk nyamagaŋ piyageŋ ta luka sigrikinaig ta tuku sine kilmba wande te mbolŋge patikate inde. Ŋgilaiŋge nane sine ndoŋ kame bumba sine tuku doŋki kilamŋgaig. Taŋawaig le sine nane tuku piro taŋgo taŋaŋ minamŋgig ŋga idusnaig. ");
INSERT INTO ssd_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Taŋamba idusmba nane kumba ka Yosef tuku wande kulatkanu gabat ta tugum kumba sanaig: ");
INSERT INTO ssd_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","O taŋgo suŋgo, sine buk pro teŋge nyamagaŋ piyageŋ sulumba ");
INSERT INTO ssd_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","kumba ka furirna le kinyam saka ndinŋge sine bek miŋgenu talka sine siŋgine ndametiŋ ta ŋakmba kaŋgerkigeŋ. Kile sine ndametiŋ ta maŋ kilmba lukig sulumba ");
INSERT INTO ssd_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ndametiŋ kitek afu turmba nyamagaŋ piyawam tuku kilmba prowig. Imaŋge ndametiŋ ta luka sigrikina ta sine gilai ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Taŋakinaig le piro taŋgo taŋge ndek nane saniŋgina: Tane ta tuku kuru-kuruka wamdus suŋgo te ndakap. Tane tuku Mbara, mam taŋgine tuku Mbaraŋge maŋau ta kina kande. Tane tuku ndametiŋ ambokok ta yeŋge buk kilen ŋgina. Taŋamba nu kumba ka Simeon tumba prona. ");
INSERT INTO ssd_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kile nu ndek nane kilmba Yosef tuku wandek sinam kina sulumba nu kule kilmba nane niŋgina le kupe minyaŋginaig. Taŋanaig le nu doŋki kame ta nyamagaŋ niŋge likina le nyinaig. ");
INSERT INTO ssd_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Taŋamba nane ki mbol Yosef ndoŋ isukusam tuku pasa ta ismba nane Yosef gare tambim tuku agaŋ ndende kilmba pronaig ta kilmba kuaneka ");
INSERT INTO ssd_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","wande mbol taŋge minnaig le Yosef prona le nane gare tambim tuku agaŋ ndende ta kilmba Yosef tugum kinaig sulumba nu tugumŋge dagol tidroŋga lokinaig le ");
INSERT INTO ssd_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yosef ndek nane kusnaniŋgina: Tane ŋakmba mage minig e ko kuga ŋgina sulumba maŋ lato kusnaniŋgina: Mam saibo taŋgine buk ye sayinaig ta nu maye minit e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","nane nu sanaig: Ne tuku piro taŋgo sine tuku mam ta maye minit ŋginaig sulumba maŋ dagol tidroŋga nu tugum taŋge lokinaig. ");
INSERT INTO ssd_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kile Yosef nu mambilmba mambo nuŋe Benyamin kaŋgermba sakina: Tane tuku mambo fudiŋ tane buk ye sayinaig ta not e ŋgina sulumba maŋ sakina: O kiŋo, Kuate nu ne make pilmba sinzaŋnuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Taŋakina sulumba Yosef nu mambo nuŋe tuku wamdus tatruka ŋin tugu malmbi prona le nu nane kusreka nuŋe wandek sinam kumba kuirka malmbikina. ");
INSERT INTO ssd_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Malmbike deŋpurmba nu tumail pasi minyaŋgina sulumba ŋgamuŋgal wamdus tatrukina ta tomba luka nane tugum prona sulumba nuŋe piro taŋgo kame ta saniŋgina le nyamagaŋ wakeika patikinaig. ");
INSERT INTO ssd_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Nane Yosef tuku nyamagaŋ kilmba mbain inum mbolŋge patikinaig sulumba aba kat nuŋe tuku nyamagaŋ ta mbain inum mbolŋge patikinaig. Isip mbal afu Yosef ndoŋ minnaig ta nane mata mbain yamokŋge isukusnaig. Ta ndaŋam? Isip mbal nane Hibru mbal talaniŋmba ake agaŋ taŋaŋ ŋga nane ndoŋ tuma isukuse ndakanu. ");
INSERT INTO ssd_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yosef tuku aba kat nuŋe ta nane isukusam tuku mbili mbolŋge ina kat naŋgineŋge kile-patike likinaig ta kumumba nane kile-minyokinaig. Kiŋo mulum mbolŋge kumba ka kiŋo ŋgrimbik mbolŋge tiŋgina. Taŋanaig le nane maŋau kinaig ta kaŋgermba nane naŋgine naŋgine muŋgu kaŋgerka wamdus sulumba minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Taŋamba minnaig le piro taŋgo kame ta nane nyamagaŋ afu Yosef tuku isukusanu mbili mbolŋge patikinaig ta kilmba pro nane niŋginaig sulumba nane Benyamin tuku nyamagaŋ suŋgomba taŋgo 5 tuku nyamagaŋ taŋaŋ patikinaig. Taŋamba nane Yosef ndoŋ isukusmba kule nyumba gare-gareka minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Nane isukuse deŋpurnaig sulumba Yosef nu wande kulatkanu gabat ta wam pagumba sana: Nane kambim tuku ta idusmba nyamagaŋ fuluknye niŋmba nane tuku bek nduik nduik sinamŋge ndametiŋ ta mata luka sigrika. ");
INSERT INTO ssd_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Taŋawa sulumba ye tuku murko silwa ta tumba kiŋo ŋgrimbik ta tuku bek sinam siriwa sulumba ndametiŋ wit piyawam tuku ta turmba sigrika ŋgina. Taŋakina le Yosef tuku piro taŋgo ta nu taŋamba ndo kina. ");
INSERT INTO ssd_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mafena le maratukuk tiŋga piro taŋgo taŋge nane kukulniŋgina le nane doŋki kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nane tumbraŋ suŋgo ta kusremba masken ndakumba minnaig le Yosef nu wande kulatkanu gabat ta kukulmba sana: Ne pateŋ tiŋga nane kuasmbi kagig ta ŋgumnem dubika kaye. Ne kumba ndinŋge nane kaŋgerkumba ndeta teŋenmba saniŋga: Ndaŋam tuku tane maŋau mayenu kig ta idus ndamba maŋau ŋayonu kaig? ");
INSERT INTO ssd_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tane ndaŋam saka yiŋe gabat tuku murko silwa ta kuayar taig? Nu murko tambi kule nyate tuku. Murko tambi maŋau ŋgumneŋga prowam tuku katesete. Ne ka taŋamba nane saniŋga ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yosef tuku piro taŋgo ta kumba ka ndinŋge nane kaŋgerkina sulumba nu Yosef tuku pasa ta nane saniŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","nane ndek sakinaig: O gabat suŋgo, ne ndaŋam tuku ŋerŋerkate? Sine maŋau ande taŋawam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Sine ndametiŋ o buk bek sinamŋge kaŋgerkigeŋ ta kilmba luka Kanan kilke mbolŋge progeŋ ta ne kila. Ne ndaŋam sine gabat naŋe tuku silwa ko gol kuayarig ŋga iduste? ");
INSERT INTO ssd_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","O gabat suŋgo, ne murko ta ima tuku bek sinamŋge kaŋgermba tumba ndeta nuŋge ndo kumwa le sine ŋakmba ne tuku piro taŋgo taŋaŋ minbe ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Taŋakina le piro taŋgo ta lafumba saniŋgina: Tane sakade ta maye ta ye ima tuku bek sinamŋge murko ta te-siliki ta nuŋge ndo ye tuku piro taŋgo minwa le tane afu ŋakmba luka kape ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Taŋakina le nane pitik ndo naŋgine bek kame ta paska ibeŋŋge patike likinaig sulumba nane bek miŋgenu talke likinaig. ");
INSERT INTO ssd_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Taŋanaig le Yosef tuku piro taŋgo ta nu murko ta bek mindek sinamŋge sotina. Nu kiŋo mulum ta tuku bek sinamŋge tugu pilmba kumba ka kiŋo ŋgrimbik mbolŋge tiŋgina. Taŋamba Benyamin tuku bek sinamŋge murko ta te-silikina. ");
INSERT INTO ssd_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Taŋana le aba kat nuŋe ta nane ndek wamdus pitiniŋgina le nane naŋgine tawi ta ŋakmba kat fetfetmba agaŋ ndende ŋakmba doŋki mbol patika luka Isip kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Taŋamba Yuda nane luka kumba ka Yosef tuku wande mbol pronaig. Yosef nu wande mbol taŋge minna le nane kumba ka nu tugum promba nu tuku tumailamŋge lokinaig le ");
INSERT INTO ssd_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosef nu nane saniŋgina: Tane ndaŋaig? Tane idusde ye wam kuirok minig ta ye kila palmbim kumuŋ kuga ŋga idusde e ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Taŋakina le Yuda lafumba nu sana: O gabat suŋgo, sine ndaŋmba pasa lafube? Sine ndaŋmba mbar te lafumba wakeibe? Kuateŋge sine tuku une ta buk te-mayokat. Ta tuku o gabat suŋgo, taŋgo murko tat taŋge ndo nu ne tuku sanzal mine nda. Sine ŋakmba ne tuku piro taŋgo taŋaŋ minamŋgig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Taŋamba sana le Yosef ndek sakina: Kuga. Ye taŋamba ke nda. Taŋgo murko tat ta nuŋge ndo ye tuku sanzal minwa le tane afu ŋakmba luka mam taŋgine sota kape. Ye tane ndoŋ pasa kuga ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Taŋakina le Yuda ndek Yosef tugum kina sulumba sana: O gabat suŋgo, ne Farao suk minit. Ne ye tuku gubra te ndaka ye tuku pasa te isa. ");
INSERT INTO ssd_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ne o buk teŋenmba sine kusnasiŋgina: Tane mam ŋak e ko mambo taŋgine ande ŋak e ŋga kusnasiŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","sine lafumba sanigeŋ: Sine mam ŋak. Mam nu saibonu. Maib mbanzonu mata minit. Mam buk saibo pilna sulumba kiŋo ŋgrimbik ta te-pilna. Aba nuŋe ta nu o buk kumna. Kile nu nuŋe ndo ina nuŋe tuku kiŋo minit. Mam nu tuku kume purte ŋga sanigeŋ. ");
INSERT INTO ssd_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","O gabat suŋgo, ne teŋenmba sine sasiŋgina: Tane taŋgine mambo fudiŋ ta tumba prowap le ye kaŋgeri ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","sine ne tuku pasa teŋenmba lafugeŋ: Kiŋo ta nu mam kusrewam kumuŋ kuga. Nu mam kusrewa ta mam nu kumamŋgat ŋgigeŋ le ");
INSERT INTO ssd_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ne ndek sakina: Mambo taŋgine ndaprowa ta ye maŋ tane kaŋgertiŋge nda ŋga sakina. ");
INSERT INTO ssd_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ne taŋakina le sine maŋ luka mam sota kageŋ sulumba maŋau ne sakina ta ŋakmba mam ndoŋ wam kubegeŋ le nu isna. ");
INSERT INTO ssd_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Taŋamba ŋgumneŋga mam ndek sasiŋgina: Tane maŋ luka kape sulumba nyamagaŋ fudiŋndo piyamba kilmba luka te prowap ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","sine nu sageŋ: O mam, sine maŋ luka kambim kumuŋ kuga. Siŋgine maib fudiŋ te nu sine ndoŋ ndakuwa ta sine gabat ta tuku am mbol prowam kumuŋ kuga. Maib fudiŋ te sine ndoŋ kuwa ta sine kaŋgig ŋgigeŋ le ");
INSERT INTO ssd_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","mam nu teŋenmba sasiŋgina: Yiŋe pino ta nu kiŋo armba ndo kile-patikina ta tane kila. ");
INSERT INTO ssd_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ande buk ye kusreyina le kile ye nu ndakaŋgeret. Agaŋmor ŋguikokŋge balena le kumna. ");
INSERT INTO ssd_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tane kile ande te tumba kape le nu kumwa ta tane ye tuku ŋgamuŋgal kuerkap le wamdus tatrukuwa le ye kumamŋgit. Ye buk saibo pile mayewit ŋga sasiŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","O taŋgo suŋgo, ye kiŋo te kusremba ake luka mam tugum prowi ta nu maib fudiŋ te ndakaŋgerwa sulumba kumamŋgat. Nu tuku ŋgamuŋgal ta ŋakmba kiŋo te mbolŋge ndo kume pur mayete. Sine tuku mam nu saibo pile mayena. Sine kiŋo te ndoŋ ndakab ta mam tuku wamdus kuerkube le nu wamdus tatrukuwa le kumamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ye mata teŋenmba mam sawen: Ye kiŋo te tumba luka ne tugum pro ndawi ndeta piti ta ye mbol minmba minwa le kumamŋgit ŋga nu sawen. ");
INSERT INTO ssd_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ta tuku ye kiŋo te tuku ma tumba teŋge ne tuku sanzal mini le ne nu ndo pitaiwa le aba kat nuŋe ndoŋ luka mam sota kuwaig. ");
INSERT INTO ssd_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kiŋo te ye ndoŋ luka ndakuwa ta ye luka mam tugum kambim kumuŋ kuga. Piti ta ye mam mbol kaŋgeram mbulit ŋga Yosef sana. ");
INSERT INTO ssd_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yosef nu Yuda pasatina ta ismba ŋgamuŋgal tatrukina le nuŋe piro mbal am mbolŋge parewam fugumba nu ndek wi kueŋka sakina: Tane piro taŋgo ŋakmba kilmba kilim kape ŋgina. Taŋamba nu nuŋe ndo aba kat nuŋe ndoŋ minna sulumba nu ndek nane saniŋgina: Ye Yosefŋge. Tane tuku maib taŋgineŋge ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Taŋakina sulumba Yosef ndek malmbi suŋgona le Isip mbal malmbi ta isnaig sulumba ka Farao tuku wande tuma mbal kubeu niŋginaig le isnaig. ");
INSERT INTO ssd_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Kile Yosef ndek aba kat nuŋe saniŋgina: Ye Yosefŋge. Ye tuku mam minit e ko kumna ŋgina kande aba kat nuŋe nane kuru-kuruka wamdus fagka nu tuku pasa lafuwam fugunaig le ");
INSERT INTO ssd_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yosef maŋ lato saniŋgina: Tane dirka ye tugum te yalpe ŋgina le nane dirka nu tugum kinaig le nu ndek nane saniŋgina: Ye Yosefŋge. Ye tane tuku maib taŋgineŋge. O buk tane ye tumba Midian mbal tugumŋge ye piyayinaig le tumba Isip pronaig ta ");
INSERT INTO ssd_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","kile tane wam o buk ye mbolŋge kinaig ta tuku wamdus piti ndatiŋguwa. Taŋgine taŋgine wamdus ndagari ndatiŋguwa. Tane kumbekaig ŋga Kuateŋge ye tumba te-amboyina. ");
INSERT INTO ssd_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kile yar arnu guba ait suŋgo ma tugu te biyit ta guba tuku yar 5 turmba minig. Taŋawa le taŋgo piro mbolŋge nyamagaŋ ande tumba nye nda. ");
INSERT INTO ssd_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kuate nu tane kumbekaig ŋga ye tane tugumŋge te-amboyina. Tane ŋgamukŋge suŋgomba abo ŋak minap ŋga nu taŋana. ");
INSERT INTO ssd_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ta tuku taneŋge ye pilnaig le ye tumbraŋ te pro ndawen. Kuga. Kuateŋge ye pilna le ye te prowen. Nuŋge ndo kina le ye Farao tuku mam nuŋe taŋaŋ minet. Yeŋge ndo nu tuku piro mbal nuŋe wande mbolŋge mine likade ta kulatket. Yeŋge ndo ye Isip ma tugu ŋakmba tuku gabat suŋgo. ");
INSERT INTO ssd_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ta tuku kile tane pitik ndo luka kape ka mam teŋenmba sawap: Kiŋo naŋe Yosef tuku pasa ta teŋenmba. Kuateŋge ye Isip ma ŋakmba tuku gabat madiyina tukunu ne dal ndaka braiŋ ndo ye tugum te prowa. ");
INSERT INTO ssd_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ne pro Gosen ma tugu teŋge ye patuyumba minyoka. Ne, naŋe kiŋo kame, naŋe wa kat naŋe, naŋe sipsip meme makau naŋe agaŋ ndende ŋakmba turmba kilmba ye tugum prowa. ");
INSERT INTO ssd_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ne Gosen ma tugu teŋge minyoka le ye ne kulatkamŋgit. Guba tuku yar 5 turmba minig ta ye ne, naŋe kuasmbi, naŋe agaŋmor ŋakmba gubanu ndakumwaig ŋga iduset. Tane taŋamba ka mam sawap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Taŋakina sulumba Yosef maŋ lato nane saniŋgina: Tane ŋakmba yiŋe aba kame yiŋe maib Benyamin kile tane ye kateseyade. Ye Yosefŋge, ye kile tane ndoŋ pasatet te ka mam sawap. ");
INSERT INTO ssd_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tane ka mam teŋenmba sawap. Ye kile Isip mbal ŋgamukŋge nyu suŋgo ŋak minet. Wam ŋakmba tane kaŋgerkaig ta turmba mam sawap. Tane braiŋ kape ka nu tumba luka te prowap ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Taŋaka saniŋgina sulumba Yosef ndek mambo nuŋe Benyamin bagailmba malmbikina le Benyamin mata aba nuŋe bagail ndiŋmba malmbikina. ");
INSERT INTO ssd_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Taŋamba Yosef nu ndek aba kat nuŋe ŋakmba bagailniŋmba mumuniŋmba nane ndoŋ malmbikina. Malmbi deŋpurna le nane nu ndoŋ pasa-pasakinaig. ");
INSERT INTO ssd_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yosef tuku aba kat nuŋe pronaig pasa ta nane afu ismba ka Farao tuku wande mbolŋge sakinaig le Farao nuŋe gabat sugo nane ŋakmba pasa ta ismba gareniŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farao ndek Yosef wika sana: Ne naŋe aba kat naŋe saniŋga le naŋgine agaŋ ndende kilmba doŋki mbol patika luka Kanan kilke mbol kuwaig. ");
INSERT INTO ssd_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Nane ka naŋgine mam naŋgine tumba naŋgine kuasmbi ŋakmba kilmba ye tugum te prowaig. Yeŋge nane kilke ande mayenu ndo Isipŋge serniŋgamŋgit. Taŋawi le nane ma ta mbolŋge minmba nyamagaŋ magenu suŋgomba kilmba nyumba minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ne nane saniŋga le Isip tuku karis afu naŋgine pino kutu kilmba yalmbim tuku turmba kilmba kuwaig sulumba mam naŋgine tumba te prowaig. ");
INSERT INTO ssd_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Nane agaŋ ndende Kanan kilke mbolŋge kusrekamŋgaig ta tuku wamdus piti ndaniŋguwa. Ye nane kilke mayenu ande Isipŋge serniŋgamŋgit ŋga Yosef sana. ");
INSERT INTO ssd_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Israel tuku kiŋo kat nuŋe nane Farao sakina taŋamba ndo kinaig le Yosef ndek Farao tuku miŋge dubimba karis afu niŋgina. Taŋamba nu nyamagaŋ afu ndinŋge nyam tuku turmba nane niŋmba ");
INSERT INTO ssd_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","tawi magenu ndui ndui aba kat nuŋe niŋgina sulumba nuŋe mambo nuŋe Benyamin ndametiŋ soŋ 30 tuna sulumba tawi magenu 5 turmba kile-tuna. ");
INSERT INTO ssd_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Taŋamba Yosef nu ndek Isip tuku agaŋ ndende mage mage mam nuŋe tambim tuku kilmba doŋki 10 ta mbolŋge patikina sulumba doŋki 10 afu ta mbolŋge wit bret nyamagaŋ yeki yeki ndinŋge nyam tuku patikina le turmba kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Taŋamba Yosef nu aba kat nuŋe kukulniŋgina le kambim bafunaig le nu ndek wam paguka saniŋgina: Tane kumba ka ndinŋge kualeyau ndakap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Nane Isip kusremba kumba ka ka mam naŋgine Yakob tugum Kanan kilke mbol pronaig sulumba ");
INSERT INTO ssd_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","sanaig: Yosef kume ndakina. Kile nu minit. Isip ma tugu ŋakmba nuŋge kulatkate ŋginaig. Taŋakinaig ta pasa ta mam naŋgine tuku wamdus ulmba sili ndana. ");
INSERT INTO ssd_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Taŋana le nane Yosef pasa sakina ta ŋakmba nu kubeu tunaig le nu ismba karis afu nu tumba Isip kambim tuku Yosefŋge patikina ta kaŋgerkina sulumba nu ndek gare-gareka sakina: ");
INSERT INTO ssd_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Sonndo. Ye tuku kiŋo Yosef abo minit. Kile ye piti kugatok. Ye kumba ka nu kaŋgeri sulumba ndo kumamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel nu agaŋ ndende ŋakmba kuane deŋpurna sulumba mam nuŋe Isak tuku Mbara atraukam Berseba tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Furir ta mbolŋge nu kiŋatanu suk Kuateŋge Yakob tugum promba wika sana: Yakob, Yakob ŋgina le nu woka sakina: Ye minet te ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Taŋakina le Kuate nu ndek sana: Ye Kuate. Ye mam naŋe tuku Mbara. Ne Isip kilke mbol kambim tuku kuru kuru ndaka. Yeŋge ki le ne tuku wa kat naŋe tuku kuasmbi tugekamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ye ne ndoŋ Isip kaŋgik. Taŋamba ŋgumneŋga ye ne tuku wa kat naŋe tuku kuasmbi kilmba maŋ luka te prowamŋgit. Yosef nu ne ndoŋ minmba ka ne kuma le nuŋge ne tuku am tukulniŋgamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakob nu Berseba tumbraŋ kusrena le nuŋe kiŋo kat nuŋe nu tumba naŋgine kutu kame foŋfoŋ naŋgine pino kame ŋakmba kilmba karis nane kilam tuku Faraoŋge patikina ta mbolŋge patikinaig. ");
INSERT INTO ssd_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Taŋamba nane makau kilmba agaŋ ndende afu Kananŋge kilnaig ta turmba kilmba Isip kinaig. Yakob nu nuŋe kutu kame ");
INSERT INTO ssd_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","wa kat nuŋe ta ŋakmba kilmba kina. ");
INSERT INTO ssd_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israel nuŋe kuasmbi kilmba Isip kilke mbol kina ta nane tuku nyu naŋgine ta teŋenmba. Kiŋo mulum ta nyunu Ruben. ");
INSERT INTO ssd_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben tuku kiŋo kame ta Hanok, Palu, Hesron, Karmi. ");
INSERT INTO ssd_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon tuku kiŋo kame ta Yemuel, Yamin, Ohad, Yakin, Sohar, Saul. Saul nu Kanannu pino ande ndoŋ tinaik. ");
INSERT INTO ssd_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi tuku kiŋo kame ta Gesron, Koat, Merari. ");
INSERT INTO ssd_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda tuku kiŋo kame ta Er, Onan, Sila, Peres, Sera. (Er le Onan nale Kananŋge kumnaik). Peres tuku kiŋo armba. Ande nyunu Hesron ande Hamul. ");
INSERT INTO ssd_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakar tuku kiŋo kame ta Tola, Pua, Yasub (nyunu ande Yob), Simron. ");
INSERT INTO ssd_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulun tuku kiŋo kame ta Seret, Elon, Yalel. ");
INSERT INTO ssd_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Yakob tuku kiŋo kame 6 ta ŋakmba Lea ndoŋ Mesopotamia kilke mbolŋge minmba kile-patikinaik. Nu kulim ande turmba te-pilna ta nyunu Dina. Lea tuku kiŋo kame wa kat nuŋe ta ulendimba 33. ");
INSERT INTO ssd_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gat tuku kiŋo kat nuŋe ta teŋenmba. Sefon, Hagi, Suni, Esbon, Eri, Arod, Areli. ");
INSERT INTO ssd_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser tuku kiŋo kame ta Imna, Iswa, Iswi, Beria. Kulim naŋgine nyunu Sera. Beria tuku kiŋo kat nuŋe ta Heber le Malkiel. ");
INSERT INTO ssd_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Nane 16 ta ŋakmba Yakob tuku ndare. Yakob nu Zilpa ndoŋ Gat le Aser kile-patikinaik. (Zilpa nu piro pino ande Labanŋge kulim nuŋe Lea tuna tuku). ");
INSERT INTO ssd_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakob piyo nuŋe Rahel tuku kiŋo armba ta Yosef le Benyamin. ");
INSERT INTO ssd_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosef nu Isipnu pino Asenat tina sulumba kiŋo armba kile-patikina ta Manase le Efraim. (Asenat nu Potifera tuku kulim nuŋe. Potifera nu Heliopolis tuku pris gabat). ");
INSERT INTO ssd_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin tuku kiŋo kat nuŋe ta teŋenmba. Bela, Beker, Asbel, Gera, Naman, Ehi, Ros, Mupim, Hupim, Art. ");
INSERT INTO ssd_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Nane 14 ta ŋakmba Yakob le Rahel tuku ndare. ");
INSERT INTO ssd_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan tuku kiŋo ta nyunu Husim. ");
INSERT INTO ssd_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali tuku kiŋo kat nuŋe ta Yasel, Guni, Yeser, Silem. ");
INSERT INTO ssd_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Nane 7 ta Yakob tuku ndare. Yakob nu Bila ndoŋ Dan le Naftali kile-patikinaik. (Bila nu piro pino ande Labanŋge kulim nuŋe Rahel tuna tuku). ");
INSERT INTO ssd_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakob nuŋe ndare ŋakmba kilmba Isip kina ta ulendimba 66. Nuŋe rugan kat nuŋe ta turmba kilmba kina. ");
INSERT INTO ssd_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yosef nu kiŋo armba Isipŋge kile-patikina. Ta tuku Yakob tuku kuasmbi ta ulendimba 70 kile Isipŋge minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakob nu Yuda kukulna le nu amboŋga kumba ka Yosef sawa le pro Gosenŋge mam nuŋe kaŋgeram tuku ŋgina. Taŋakina le Yakob tuku kuasmbi ka Gosenŋge pronaig le ");
INSERT INTO ssd_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosef nu ismba karis poŋga kumba ka Gosenŋge mam nuŋe te-silikina sulumba nu mam nuŋe tugum promba pitik ndo mam nuŋe bagailmba malmbi didika mine kuenna. ");
INSERT INTO ssd_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Malmbi deŋpurna le Israel ndek Yosef sana: Ye ne abo minit ta kaŋgernet. Kile ye kumi ndeta maye ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kile Yosef ndek aba kat nuŋe mam nuŋe tuku kuasmbi ŋakmba wam paguka saniŋgina: Ye kile ka Farao teŋenmba sawamŋgit. Yiŋe aba kame mam tuku kuasmbi Kananŋge minnaig ta kile prowaig. ");
INSERT INTO ssd_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nane sipsip makau kulatkade tuku. Nane naŋgine sipsip makau agaŋ ndende ŋakmba kilmba prowaig ŋga nu sawamŋgit. ");
INSERT INTO ssd_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Farao ndek tane wika kusnatiŋmba tane ame piro kade tuku ŋguwa ndeta ");
INSERT INTO ssd_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","tane nu teŋenmba sawap: O gabat suŋgo, sine buk foŋfoŋ ndo agaŋmor kulatka pirokigeŋ ta kile mata sine taŋamba ndo piroka minmba mineg. O buk siŋgine wa mbuŋ kame pirokinaig taŋamba keg. Tane taŋamba sawap ta nu tane mapekuwa le Gosen ma mbolŋge minyokamŋgaig ŋga saniŋgina. Ta ndaŋam? Nane Isip mbal agaŋmor kulatkanu mbal ndoŋ ulendika minam mbulnaig. Ta tuku Yosef nu aba kat nuŋe taŋamba wam pagukina. ");
INSERT INTO ssd_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Kile Yosef ndek aba kat nuŋe 5 kilmba kumba ka Farao teŋenmba sana: Yiŋe mam yiŋe aba kame nane ŋakmba kile Kananŋge Isip prowaig. Nane naŋgine sipsip makau naŋgine agaŋ ndende ŋakmba kilmba prowaig. Kile nane Gosenŋge minig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Taŋakina sulumba Yosef ndek aba kat nuŋe 5 ta Farao tuku tumailamŋge kile-tidiŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao ndek nane kusnaniŋgina: Tane ame pirokade tuku ŋgina le nane lafumba sanaig: O gabat suŋgo, sine agaŋmor kulatkeg tuku. Siŋgine wa mbuŋ kame nane kinaig taŋamba ndo sine tuturmba keg. ");
INSERT INTO ssd_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Guba suŋgo Kanan kilke mbolŋge prona le siŋgine agaŋmor isukusam tuku nyamagaŋ mata kuga tukunu sine kilke te mbolŋge minyoka pironu tuku prowig. Ta tuku ne woka le sine Gosenŋge minyokube ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Taŋaka sanaig le Farao ndek Yosef sana: Mam naŋe aba kat naŋe kile ne tugum prowaig. ");
INSERT INTO ssd_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ma magenu suŋgomba Isipŋge minig. Ne inum te-silika nane serniŋga le taŋge minyokuwaig. Nane Gosenŋge minyokuwaig ta mata maye. Nane afu agaŋmor kulatkam tuku kila magenu ŋak kaŋgerkumba ndeta ne nane madiniŋga le ye tuku agaŋmor kuaŋ kulatkam tuku gabat minwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Taŋakina le Yosef ndek mam nuŋe tumba Farao tugum kina le kaŋgerna. Taŋana le Yakobŋge Farao nyaro tuna le ");
INSERT INTO ssd_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","nu ndek nu kusnana: Ne kile yar giganmba ŋak e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob nu sana: Ye buk ma tugu suŋgomba mbolŋge rawe taŋgo taŋaŋ kinenumba piti suŋgomba ŋak yar 130 kusreken. Yar ta suŋgomba ndo kuga. Ye tuku yar te yiŋe wa le mam tuku yar suŋgomba nane buk rawe taŋgo taŋaŋ minmba likinaik taŋamba kuga ŋga Farao sana. ");
INSERT INTO ssd_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Taŋakina sulumba Yakob nu Farao maŋ lato nyaro tumba nu kusremba kina. ");
INSERT INTO ssd_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kile Yosef nu mam nuŋe aba kat nuŋe turniŋgina sulumba kilke ande Rameses ma tugu mbolŋge niŋgina le nane ka taŋge minyokinaig. Kilke ta mayenu ndo Isip ma tugu ŋakmba liniŋgina. Taŋamba Yosef nu Farao buk sakina ta kumu-kumumba kina. ");
INSERT INTO ssd_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yosef nu mara mindek nyamagaŋ mam nuŋe, aba kat nuŋe, naŋgine kuasmbi nane ŋakmba tuku kumumbi patika niŋmba minanu. ");
INSERT INTO ssd_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Guba tuku ait ta kile suŋgokina le ma tugu ŋakmba nyamagaŋ kugana tukunu Isip mbal Kanan mbal nane saŋgri kugatok minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Taŋanaig le Yosef nu ndametiŋ Isip taŋgo kame Kanan taŋgo kameŋge wit piyawe likinaig ta ŋakmba maŋgurka kilmba Farao tuku wande mbol kina. ");
INSERT INTO ssd_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Isip mbal Kanan mbal kile ŋakmba ndametiŋ kuganaig le Isip taŋgo pino ŋakmba Yosef tugum promba sanaig: Ne sine nyamagaŋmbi turka. Kuga ta sine gubanu kumamŋgig. Ne sine turnu tuku ndin ande sota. Sine ndametiŋ mata buk kuganaig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosef ndek nane saniŋgina: Tane sonndo ndametiŋ kuganaig ndeta taŋgine agaŋmor kilmba ye tugum prowap. Taŋawap le ye tane nyamagaŋ tiŋgamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Taŋakina le nane ndek hos sipsip meme makau doŋki kilmba Yosef tugum kinaig le nu ndek nane nyamagaŋ niŋgina. Yosef nu taŋamba minna le ka ka yar ta kugana. ");
INSERT INTO ssd_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Yar bailkanu mbolŋge nane maŋ Yosef tugum kumba sanaig: O gabat suŋgo, sine siŋgine piti ne tugumŋge yabune nda. Siŋgine ndametiŋ ŋakmba kuganaig. Siŋgine agaŋmor mata ne buk ŋakmba kilna. Sine kile ne agaŋ inum tanmbim tuku mine ndakate. Siŋgine ŋgarosu siŋgine kilke ta ndo minig. ");
INSERT INTO ssd_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ne sine pile ndo siŋga le gubanu kume ndakube. Ne ndin inum sine sinzaŋsiŋgam tuku te-silikam kumuŋ e? Sine tuku kilke mata ake minig. Ta tuku ne sine siŋgine kilke turmba kila sulumba nyamagaŋmbi sine turka. Ne taŋawa le sine Farao tuku piro taŋgo taŋaŋ minbe le sine tuku kilke mata nuŋge kilwa. Taŋamba ne sine wit nyam tuku nyamagaŋ tumunu ŋgukam tuku ta turmba siŋga. Kuga ta sine ŋakmba gubanu kumbe le kilke mata baknu ndo minikat ŋga Yosef sanaig. ");
INSERT INTO ssd_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Guba suŋgo ta kile saŋgri tiŋgina le Isip taŋgo pino kilke ŋakmba Yosef tunaig le piyawe suluna. Taŋana le Isip kilke ŋakmba Farao tuku ndo minnaig le ");
INSERT INTO ssd_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","taŋgo pino Isip kilke mbolŋge mine likinaig ta mata ŋakmba Farao tuku piro taŋgo ndo minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Pris kame tuku kilke ta ndo nu piya ndaniŋgina. Ta ndaŋam? Nane Faraoŋge piyaniŋgina le nane tambi nyamagaŋ piyamba nyinaig. Ta tuku nu naŋgine kilke piya ndana. ");
INSERT INTO ssd_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kile Yosef ndek taŋgo pino ŋakmba saniŋgina: Kile tane isap. Ye tane taŋgine kilke turmba Farao tuku piyawit. Ye kile nyamagaŋ tumunu tane tiŋgamŋgit ta tane kilmba ka piro mbolŋge ŋgukap. ");
INSERT INTO ssd_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Nyamagaŋ ka magekuwaig le tane nyamagaŋ ta walmba patikumba ndindo tumba Farao tape sulumba bailkamba ta taŋgine minwaig. Afu ŋgunu tuku minwaig afu taŋgine gageu ndoŋ nyam tuku minwaig ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","nane lafumba sakinaig: O gabat suŋgo, ne sine tur magekina le sine tuku ande kume ndakina. Kile sine ŋakmba Farao tuku piro taŋgo ndo minbe ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kile Yosef ndek tukul pasa ande Isipŋge pilna ta teŋenmba. Nyamagaŋ piro mbolŋge magekuwaig ta taŋgo ŋakmba walmba patikuwaig. Patikuwaig sulumba ndindo tumba Farao tuwaig le bailkamba naŋgine minwaig. Tukul pasa ta kile minmba minit. Pris kame tuku kilke ta ndo Farao nu kile ndakina. ");
INSERT INTO ssd_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel nane Isip kilke Gosenŋge minyoka kiŋo kame suŋgomba kile-patikinaig sulumba agaŋ ndende mata suŋgomba kilnaig. ");
INSERT INTO ssd_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakob nu yar 17 Isipŋge minna. Nu tuku yar ulendimba ta 147. ");
INSERT INTO ssd_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Taŋamba Israel nu kumam tuku ait fagkina le kamusmba nu kiŋo nuŋe Yosef wika sana: Naŋe wai tumba ye tuku fel karaukŋge pilmba son pasa saŋgrinu saka sulumba ne ye kulat mayeyumba Isip kilke mbol teŋge ye ŋgu ndaka. ");
INSERT INTO ssd_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ne ye Isipŋge tumba kaye ka yiŋe ina mam wa kame tugumŋge ŋguka ŋgina le Yosef ndek pasa lafumba sakina: Ye ne sakate taŋawamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Taŋakina le Israel nu ndek sakina: Ne sonndo maŋau ta kamŋgat kande pasa ta saŋgri pilewa ŋgina le Yosef nu pasa ta saŋgri pilena le Israel nu ndukuka kinyam mbili mbol taŋge Kuate gare pasa tuna. ");
INSERT INTO ssd_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Minnaig ma ma mara ande nane Yosef sanaig: Mam naŋe guaze ŋak ŋginaig le Yosef ndek kiŋo kat nuŋe ar Manase le Efraim kilmba mam nuŋe kaŋgeram kina le ");
INSERT INTO ssd_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","nane ndek Yakob sanaig: Kiŋo naŋe Yosef ne kaŋgernam tuku prowat ŋginaig. Taŋakinaig le Israel nu saŋgri tiŋga kinyam mbili mbolŋge minyokina. ");
INSERT INTO ssd_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yosef ka prona le mam nuŋe ndek nu sana: Kuate Saŋgri Ŋayo nu o buk Kanan kilke Lus tumbraŋŋge ye tugum promba ye nyaro sumba ");
INSERT INTO ssd_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","sayina: Yeŋge ki le ne tuku ndare tugeka taŋgo kuasmbi suŋgomba mayok kaŋgaig. Ye kilke te serniŋgi le kilke te nane tuku minmba minamŋgat ŋga sayina. ");
INSERT INTO ssd_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ye ne tugum Isip ndapromba minen le piyo naŋe kiŋo armba kile-patikina. Kiŋo ar ta ye tuku. Efraim le Manase te ye tuku kiŋo kame Ruben le Simeon minik taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kiŋo afu ŋgumneŋga Efraim le Manase dubiknu prowaig ndeta ta naŋe. Ŋgumneŋga kilke fetka kuasmbi yimyam niŋgam tuku ait ta ne tuku kiŋo kame afu tuku ndare ta nane aba kat naŋgine Efraim le Manase tuku kilke mbolŋge minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ye ina naŋe Rahel idusmba maŋau te ket. Ye luka Mesopotamia kilke mbolŋge ilmba minen le nu ndinŋge Kanan kilke mbolŋge Efrat tumbraŋ patumba kumna le ye wamdus tatrukina le ye nu Efrat tumbraŋ kambim tuku ndin make mbiŋge ŋguken ŋgina. (Efrat tumbraŋ ta kile Betlehem ŋgade). ");
INSERT INTO ssd_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Kile Israel ndek Yosef tuku kiŋo ar ta kaŋgerka kusnaŋgina: Ima tuku kiŋo ar te ŋgina le ");
INSERT INTO ssd_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosef lafumba sana: Kiŋo ar te ye tuku. Ye Isipŋge minen le Kuateŋge sina ŋgina le Israel nu sana: Nale kilmba ye tugum te yale le ye nale nyaro niki ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel nu buk saibo pilna tukunu nu am nuŋe mata agaŋ kaŋger mage ndakina tukunu Yosef nu kiŋo kat nuŋe ar ta kilmba mam nuŋe tugum kina le nu ndek nale bagailnikmba mumunikina. ");
INSERT INTO ssd_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Taŋana sulumba Israel ndek Yosef sana: Ye buk idusen ye ne maŋ kaŋgerne nda ŋga idusen ta Kuateŋge ye sinzaŋyina le ye kile ne tuku kiŋo armba kaŋgerket ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Taŋakina le Yosef ndek kiŋo kat nuŋe ar ta mam nuŋe tuku fel mbolŋge kile-sika mam nuŋe tuku tumailamŋge dagol tidroŋga lokina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yosef ndek nale tuku wai bigmba wai ndinammbi Efraim biyna le mam nuŋe tuku wai ŋaiŋam mbolŋge tiŋgina. Taŋana le nu Manase ndek wai ŋaiŋammbi biyna le mam nuŋe tuku wai ndinam mbolŋge tiŋgina kande ");
INSERT INTO ssd_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","mam nuŋe nu wai mbilmba wai ndinam tumba kiŋo ŋgrimbik Efraim tuku gabat mbolŋge pilna sulumba wai ŋaiŋam tumba kiŋo mulum Manase tuku gabat mbolŋge pilna. ");
INSERT INTO ssd_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Taŋamba nu nale nyaro nikina sulumba sakina: Yiŋe wa Abraham yiŋe mam Isak nale Kuate kumnemŋge minnaik. Mbara taŋge kiŋo ar te nyaro nikuwa. Kuate ye mara mindek kulatka tumba te prona le kile minet. Nuŋge nale nyaro nikuwa. ");
INSERT INTO ssd_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Nuŋe Eŋel o buk ye piti suŋgomba kaŋgerken le kulatkina nuŋge nale nyaro nikuwa. Ye tuku nyu, yiŋe wa Abraham tuku nyu, yiŋe mam Isak tuku nyu kiŋo ar te mbolŋge minmba minwaig le nale taŋgo kuasmbi suŋgomba ŋak prowaik ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosef mam nuŋe wai ndinam tumba Efraim tuku gabat mbolŋge pilna ta nu mbulna sulumba nu mam nuŋe tuku wai Efraim tuku gabat mbolŋge pilna ta biymba te-simba tumba Manase tuku gabat mbolŋge palmbim bafuna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","mam nuŋe sana: Mam, taŋamba kuga. Kiŋo te ta nu mulum. Wai ndinam tumba nu tuku gabat mbol pale ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","mam nuŋe mbulmba nu sana: Kiŋo, ye kila. Manase tuku ndare mbolŋge mata taŋgo kuasmbi suŋgokanu prowamŋgat ta kiŋo ŋgrimbik te tuku kuasmbi kiŋo mulum tuku kuasmbi liwamŋgat. Nu tuku ndare mbolŋge taŋgo kuasmbi suŋgomba prowamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ki ait ta mbolŋge Israel ndek nale teŋenmba nyaro nikina: Israel mbal taŋgo afu nyaro niŋgam ŋga tale tuku nyumbi teŋenmba sanuŋgaig: Kuateŋge sinzaŋtiŋguwa le tane Efraim le Manase taŋaŋ minamŋgaig ŋgina. Taŋamba Israel nu Efraim tumba kiŋo mulum taŋaŋ te-ambona. ");
INSERT INTO ssd_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kile Israel maŋ Yosef sana: Mine minemba ye kumamŋgit ta Kuate nu ne ndoŋ minamŋgat. Nuŋge ne tumba luka ka wa kat naŋe tuku kilke mbol kaŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sekem ma tugu ta kilke mayenu ndo. Ye o buk kame bagimbi tuimbi Amor mbal ndoŋ kame bumba yaiken. Kilke ta ye ne ndo sernet. Ye aba kat naŋe serniŋge nda ŋga Yosef sana. ");
INSERT INTO ssd_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Kile Yakob nu kiŋo kat nuŋe wika saniŋgina: Tane ilmba ye tugumŋge maŋgurkap le ye wam ŋgumneŋga tane mbolŋge prowamŋgaig ta satiŋgi. ");
INSERT INTO ssd_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Yakob tuku kiŋo kame, tane ŋakmba ilmba minyokap sulumba ise tiwap. Tane mam taŋgine Israel tuku pasa isap ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, ne ye tuku kiŋo mulum tukunu ne ye tuku isu. Ye mbanzo minen sulumba ne kiŋo mulum te-pilen. Ne saŋgri suŋgo ŋak. Ye tuku kiŋo afu nane ŋakmba ne kumnemŋge minig. ");
INSERT INTO ssd_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ne kule saŋgrinu ndekate taŋaŋ ta ne ye tuku pino ndoŋ kinyna sulumba kiko maŋau ye sina. Ta tuku ne mambo kat naŋe te tuku suŋgo mine nda. ");
INSERT INTO ssd_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon nale Levi ndoŋ wamdus ndindo. Nale kame agaŋ ndende kilmba tambi maŋau ŋaigonu kade tuku. ");
INSERT INTO ssd_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ye nale yabuka pasa katik ta ye maye ŋge nda. Nale gubra tinaik sulumba taŋgo bale farnaik tukunu ye nale tuku maŋgur sinamŋge minyokam mbulet. Nale nakile ake sinaŋ usremba makau pailnu kupenu kat ŋgurniŋge likinaik. ");
INSERT INTO ssd_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nale tuku gubra ta pak ŋayo. Ta tuku piti ta nale kaŋgerwaik. Ye nale pitaiki le Israel kilke mbol kuwaig sulumba Israel mbal ŋgamukŋge mine likamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, ne tuku tira kame ne tuku nyu te-duŋgamŋgaig. Ne naŋe ŋgueu mbal ŋinfokmbi biye likamŋgat. Ne tuku tira kame ta ne tugumŋge lokamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda nu laion taŋaŋ. Nu agaŋmor balemba luka nuŋe kuirkate burok sinam ta kumba nuŋe ŋgaro wakeimba kinyit le andeŋge nu kuanemba koroŋ ndate. ");
INSERT INTO ssd_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nu nuŋe ndare kame ndoŋ gabat suŋgo tuku ndumndum biymba minmba minwaig le gabat suŋgo ande prowa le taŋgo kuasmbi ŋakmba nu tuku miŋge kumnemŋge minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yuda nu nuŋe doŋki fatnu muli ŋak grep muli mayenu mbol kusit sulumba nuŋe tawi ta grep kulenu gurgur ndare suk tambi minyaŋgate. ");
INSERT INTO ssd_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Nu grep kule nyate le amnu gurkade. Nu amo nyate le maketiŋ kaukauknu ndo. ");
INSERT INTO ssd_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulun nu piyalŋge yu make mbolŋge minamŋgat. Piyal nuŋe ta waŋ tuku kundu magenu minamŋgaig. Nuŋe kilke make mbolŋge kumba ka Sidon tumbraŋŋge tiŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar nu doŋki kareŋnu taŋaŋ ake sinaŋ pale kame ŋgamukŋge kinymba minit. ");
INSERT INTO ssd_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Nu kilke mayenu mabtam tuku kaŋgerte ta nu isu maramba agaŋ ndende kugrakate sulumba sanzal taŋaŋ piro kareŋkate. ");
INSERT INTO ssd_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan nu nuŋe kuasmbi kulatkamŋgat. Kuasmbi ta nane Israel tuku kuasmbi ŋakmba taŋaŋ minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Nu kame mbeŋ taŋaŋ ndin make mbiŋge minamŋgat. Nu pateŋga hos kupenu makete le taŋgo hos mbolŋge minyokate ta nu bariŋga ndekate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Taŋakina sulumba nu ndek sakina: O Suŋgo, ne ye ta ŋga ye tairŋget ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Taŋamba nu maŋ lato sakina: Kuayar taŋgo kame afu Gat ndoŋ kame tiŋgamŋgaig. Taŋawaig le Gatŋge mbilka pani farka nane yokerkamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser tuku kilke mbolŋge nyamagaŋ mayenu prowamŋgat. Aser nu nyamagaŋ mayenu kikoŋnu wakeikuwa ta gabat sugo nane nyam kumuŋ. ");
INSERT INTO ssd_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali nu dia taŋaŋ nuŋe nzali dubimba likate. Nu tuku kutu magenu ndo. ");
INSERT INTO ssd_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosef nu doŋki ŋguikok kule make mbiŋge minit le hos ŋguikok tabe kumnemŋge minit taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Nuŋe ŋgueu mbal nane nu ndoŋ kame ŋayomba nu tuimbi koroŋwaig ta ");
INSERT INTO ssd_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","naŋgine tui ta ŋgurke likamŋgaig. Yakob tuku Mbara saŋgrinu taŋge naŋgine wai baklel serniŋgamŋgat. Kuate nu Israel mbal tuku Kulat Taŋgo mayenu. ");
INSERT INTO ssd_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mam naŋe tuku Mbara nu Saŋgri Ŋayo. Nuŋge ne turnumba nyaro tinit. Nyaro magenu suŋgomba ne mbolŋge minamŋgaig. Samba mbolŋge sawe nyaro ŋak ndeka minamŋgat. Kilke sinamŋge kule nyaro ŋak minmba minamŋgat. Kiŋo kame suŋgomba kile-patikam tuku nyaro pino kame mbolŋge minamŋgat. Agaŋmor tuku nyaro paŋgarnu kame mbolŋge minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Wit le plaua botnu prowam tuku nyaro, tabe ambokok tuku nyaro, tabe minmba minam tuku nyaro ta ŋakmba Yosef mbolŋge minwaig le nu aba kat nuŋe minig taŋaŋ mine nda. ");
INSERT INTO ssd_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin nu age ŋguikok agaŋmor bale farte taŋaŋ. Maratukuk furiram nu agaŋmor bale farniŋmba nyate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yakob nu taŋamba Israel tugu 12 ta tuku saniŋgina sulumba nyaro nduik nduik kiŋo kat nuŋe niŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Taŋamba Yakob nu maŋ kiŋo kat nuŋe wam paguniŋmba saniŋgina: Mine minemba ye ka kumanu mbal tuku tumbraŋŋge yiŋe wa mbuŋ kame kaŋgerka nane ndoŋ minamŋgit. Tane ye tumba ka ndame burok Hitnu taŋgo Efron tuku kilke mbolŋge minit ta sinamŋge wa mbuŋ kame ndoŋ palpe. ");
INSERT INTO ssd_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ndame burok ta Makpela Mamre tugumŋge Kanan kilke mbolŋge minit. Abraham nu o buk ndame burok ta kilke ta turmba mindesiŋ ŋgunu tuku Hitnu taŋgo Efron tugumŋge piyana. ");
INSERT INTO ssd_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nane o buk Abraham le piyo nuŋe Sara taŋge ŋgukinaig tuku. Ŋgumneŋga maŋ Isak nale piyo nuŋe Rebeka kilke ta mbolŋge ŋgukinaig. Ye mata ina taŋgine Lea kilke ndui ta mbolŋge ŋguken. ");
INSERT INTO ssd_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Abraham nu Hit mbal tugumŋge kilke ta ndame burok ta turmba piyana. Tane ka taŋge ye ŋgukap ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakob nu kiŋo kat nuŋe wam paguniŋge deŋpurmba nu maŋ mbilka kinyna sulumba kumna. ");
INSERT INTO ssd_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Kumna le Yosef ndek mam nuŋe tuku tumail mbol loka malmbika mam nuŋe mumuna sulumba ");
INSERT INTO ssd_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","mam nuŋe tuku mindesiŋ ta me ndaŋguwa ŋga nane afu saniŋgina le mindesiŋ ta ail ŋair afu kilmba pisnenaig. ");
INSERT INTO ssd_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Nane piro ta kumba minnaig le ait 40 kuganaig. Piro ta tuku ait taŋamba madinaig tuku. Taŋanaig le Isip mbal nane ki ait 70 Yakob malmbimba minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yosef mam nuŋe kumna ta tuku kuamel kugana le nu Farao tuku gabat sugo ta saniŋgina: Tane kumba Farao sawap. ");
INSERT INTO ssd_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Yosef nu teŋenmba sakat. Mam nu kumam bafuna sulumba nu ye sayina ye nu tumba ka Kanan kilke mbolŋge mindesiŋ palmbim tuku ma nuŋge buk wakeina tuku ta mbolŋge ŋgukam tuku ŋgina. Nu taŋamba ye sayina le kile ye mam tumba kumba ka ŋgukumba luka prowet ŋga sakate. Tane ka taŋamba Farao sawap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Nane kinaig ka Farao sanaig le nu lafumba sakina: Mam naŋe buk sakina taŋamba tumba kaye sulumba ŋguka ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Taŋakina le Yosef nu mam nuŋe tumba ŋgukam kina le Farao tuku piro taŋgo kame, nu tuku gabat kame, Isip tuku mage mage nane ŋakmba Yosef ndoŋ kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yosef tuku kuasmbi, nu tuku aba kat nuŋe, mam nuŋe tuku kuasmbi ta nane ŋakmba nu ndoŋ kinaig. Naŋgine kiŋo kame foŋfoŋ sipsip meme makau ta ŋakmba ndo Gosen kilke mbolŋge kusrekinaig le minnaig. ");
INSERT INTO ssd_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Karis kame taŋgo kame hos mbolŋge likade tuku ta nane ŋakmba kuasmbi suŋgo Yosef ndoŋ kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Taŋamba nane wit baurŋganu tuku ma tugu Yordan kule make mbol pronaig sulumba ninanka malmbi ŋgumbeyunaig. Taŋamba Yosef nu ait 7 mam nuŋe kumna ta tuku malmbika minna. ");
INSERT INTO ssd_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Nane malmbi ŋgumbeyunaig le Kanan mbal nane kaŋgerka sakinaig: i ... Isip mbal si naŋgine maŋaumbi malmbi ŋgumbeyu suŋgokade ŋginaig. Ta tuku nane ma ta nyunu Abel-Misraim ... ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yakob tuku kiŋo kame mam naŋgine buk saniŋgina taŋamba ndo kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nane mindesiŋ nuŋe tumba Kanan kilke mbol kinaig sulumba Makpela Mamre tugumŋge ŋgukinaig. Abraham nu buk Hitnu taŋgo Efron tugumŋge kilke ta piyana tuku. ");
INSERT INTO ssd_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosef nu mam nuŋe ŋgukina sulumba nu maŋ aba kat nuŋe taŋgo kuasmbi ŋakmba nu ndoŋ ilnaig ta ndoŋ luka Isip kinaig. ");
INSERT INTO ssd_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Mam naŋgine kumna le Yosef tuku aba kat nuŋe nane ndek sakinaig: Sine buk maŋau ŋayonu Yosef mbol kigeŋ. Kile Yosef nu gubrawa sulumba maŋau kigeŋ ta lafumba sine mbol kamŋgat kande ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Taŋamba nane taŋgo ande kukulnaig le Yosef tugum kina sulumba sana: Aba kat naŋe nane teŋenmba sakade. Mam naŋe kume ndakina sulumba ");
INSERT INTO ssd_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","nu teŋenmba sasiŋgina. Tane teŋenmba Yosef sawap. Aba kat naŋe nane o buk ne mbolŋge maŋau ŋayonu kinaig. Ta tuku ye ne sanet. Nane ne mbolŋge mbarmba unekinaig maŋau ta gilaiŋga. Mam nu taŋamba sakina. Sine mata mam naŋe tuku Mbara kumnemŋge mineg. Ta tuku sine mata ne saneg. Sine tuku mbar ta gilaiŋga ŋginaig. Aba kat naŋe taŋamba sakade ŋga Yosef sana le nu pasa ta ismba malmbikina. ");
INSERT INTO ssd_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kile aba kat nuŋe nane Yosef tugum pronaig sulumba truk ka sanaig: Sine ne tuku piro taŋgo taŋaŋ minamŋgig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","nu ndek nane saniŋgina: A ... tane kuru kuru ndakap. Ye Kuate tuku ma tam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tane buk pasa katmba maŋau ŋayonu ye mbol kinaig ta Kuateŋge maŋau ta mbilmba kina le maŋau mayenu prona. Ta tuku taŋgo pino suŋgomba kume ndaka kile abo minig. ");
INSERT INTO ssd_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ye tane satiŋget. Tane kuru kuru ndakap. Ye siŋka tane taŋgine kiŋo kame turmba kulatka minamŋgit ŋgina. Nu taŋamba saniŋmba nane tuku wamdus kuru-kurukinaig ta wamdus kile-ibeŋke niŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Taŋamba mam nuŋe tuku kuasmbi nane Yosef ndoŋ Isip kilke mbolŋge minnaig ma ma Yosef nu yar 110 kusrena sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Nu kume ndakina sulumba kiŋo nuŋe Efraim tuku kiŋo kame nu tuku wa kat nuŋe ta turmba kaŋgerka minna. Yosef wa nuŋe Makir tuku kiŋo kame nane mbuŋ naŋgine Yosef tugumŋge minmba sugokinaig. Makir nu Manase tuku kiŋo nuŋe. ");
INSERT INTO ssd_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Taŋamba minnaig sulumba mara ande nu aba kat nuŋe saniŋgina: Ye buk kumam patuket ta Kuateŋge tane kulatkamŋgat. Nuŋge kilke tuku pasa saŋgrinu Abraham Isak Yakob nane saniŋgina ta ŋgumneŋga nu tane kilke te mbolŋge kilmba ka kilke ta mbolŋge patinuŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Taŋamba Yosef nu Israel kiŋo kame tuku miŋgekŋge nane pasa saŋgrinu sakuwaig le nu isam sakina: Kuate nu tane turkam tuku prowa le tane ye tuku isu kilmba turmba kape ŋgina. ");
INSERT INTO ssd_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Taŋamba Yosef nu yar 110 kusremba Isip kilke mbolŋge kumna le nane nu tuku mindesiŋ ail ŋair pisnemba tumba ter sinamŋge pilnaig le minna. ");
INSERT INTO ssd_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","O buk Israel mbal nane gabat sugo kugatok kulat taŋgoŋge ndo Israel kulatka minnaig le guba suŋgo prona. Prona le Yuda kumamŋge Betlehemnu taŋgo ande nuŋe piyo nuŋe ndoŋ kiŋo armba ta kilmba guba gagnu kumba ka Moab kilke mbolŋge minyokinaig. Taŋgo ta nyunu Elimelek. Piyo nuŋe Neomi. Kiŋo kat nakile ta Malon le Kilion. Naŋgine tumbraŋ mboŋ Efrat. ");
INSERT INTO ssd_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Nane Moab kilke mbolŋge minnaig ma ma Elimelek nu kumna le Neomiŋge ndo kiŋo ar ta ŋak minna. ");
INSERT INTO ssd_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Taŋamba minnaig ma ma kiŋo ar ta Moabnu pino kilnaik. Pino ar ta nyu nakile Orpa le Rut. Nane taŋge minnaig ma ma yar 10 kusreka ");
INSERT INTO ssd_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Malon le Kilion mata kumnaik. Kumnaik le ina nakile Neomi nuŋe ndo minna. ");
INSERT INTO ssd_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Suŋgo nu nuŋe mbal Israel nyamagaŋ ait mayenu niŋgina pasa ta Neomi nu isna sulumba nu nuŋe rugan ar ta ndoŋ kuaneka Moab kilke kusremba ");
INSERT INTO ssd_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","luka Yuda ma tugu kambim saka kinaig. ");
INSERT INTO ssd_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Kinaig ka ndinŋge Neomi nu nuŋe rugan ar ta sanikina: Taŋaig le tale luka kumba ka takile tumbraŋŋge ina kat takile ndoŋ minap. Tale ye nane keŋ kumnaig ta sine tur magekinaig. Ta tuku tale Suŋgoŋge sinzaŋtikuwa le ");
INSERT INTO ssd_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","tale maŋ taŋgo kilmba nale ndoŋ mine mayewamŋgaig ŋga sanikina. Taŋakina sulumba Neomi nu rugan kat nuŋe ta mumunikmba kusrekam bafuna le nale ndek malmbi ŋayonaik sulumba ");
INSERT INTO ssd_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","rugan nakile sanaik: Kuga. Sile ne ndoŋ naŋe kuasmbi tugum kambimkik ŋginaik kande ");
INSERT INTO ssd_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Neomi nu sakina: Kuga. Tale luka kape. Ndaŋam tale ye ndoŋ kambim sakik? Tale idusik ye maŋ kiŋo afu kile-patiki le tale kilam idusik e? ");
INSERT INTO ssd_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Tale luka kape. Ye buk saibo pilen. Ye maŋ taŋgo tam kumuŋ kuga. Ko ye furir te mbolŋge taŋgo tumba kiŋo kile-patiki ta ");
INSERT INTO ssd_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","tale nale sugokuwaik le kilam tuku tairŋgam kumuŋ e? Kuga. Tale taŋgo kise kilam tuku idusamŋgaik. Suŋgo nu ye kusreyumba piti sina le tale tuku ninan suŋgowet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Taŋakina le Rut le Orpa maŋ lato malmbi ŋayonaik sulumba Orpa nu rugan nuŋe mumumba kusremba lukina le Rut nu rugan nuŋe kusre fuguna. ");
INSERT INTO ssd_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Kile Neomi ndek rugan nuŋe Rut sana: Ai si. Ne aba naŋe si kaŋgera. Nu luka nuŋe kuasmbi tugum kumba nuŋe mbara kame sota kinit. Ne nu ndoŋ kaye ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Taŋakina le Rut ndek nu sana: Ndaŋam ne ye lukam tuku sayate? Ye ne dubinumba kambim tuku peu ndaya. Ne ma inum kaye ta ye mata ne dubinumba kaŋgit. Ne ka aniŋge minamŋgat ta ye mata ne ndoŋ ka taŋge minamkik. Naŋe kuasmbi ta yiŋe kuasmbi taŋaŋ minamŋgat. Naŋe Mbara ta yiŋe Mbara taŋaŋ minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ne kuma le ŋgukuwaig ma ta ye mata kumi le ma ta mbolŋge ŋgukamŋgaig. Andeŋge sile tuku mine te pure nda. Kumeŋge ndo puramŋgat. Ye siŋka ndo saket. Pasa ŋakmba saket te dubi ndawi ta Suŋgo nu ye mapeye nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Rut nu dirnaŋga rugan nuŋe dubimba kambim sakina le nu maninkina. ");
INSERT INTO ssd_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Taŋamba nale ndin dubimba kinaik ka ka Betlehem pronaik. Pronaik le tumbraŋ ta tuku mbal nane pirerek purka sakinaig: i ... Si Neomiŋge ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Taŋakinaig le Neomi ndek sakina: Ye Neomi ndaŋgap. Kuate Saŋgri Ŋayo nuŋge ye piti sina tukunu ye tuku nyu Mara ŋgap. ");
INSERT INTO ssd_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Ye tumbraŋ te kusrewen ta ye gageu ŋak ye kumuŋ minen. Kile Suŋgo nu ye baknu tumba te prowat. Ndaŋam tane ye nyu tumba ŋgamuŋgal gare ŋak pino ŋgade? Suŋgo Saŋgri Ŋayo nuŋge ye te-ibeŋyumba piti suŋgo sina ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Wam kube te Neomi tuku. Nu Moab kilke kusremba rugan nuŋe Rut tumba lukinaik. Rut nu Moabnu pino. Wit magekinaig le kilam tuku ait mbolŋge nale Betlehem pronaik. ");
INSERT INTO ssd_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Boas nu maror taŋgo nu nyu suŋgo ŋak minna. Nu Neomi taŋgo nuŋe Elimelek nale tugu ndui ta. ");
INSERT INTO ssd_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Mara ande Rut nu rugan nuŋe sana: Ye kumba taŋgo ande kusnawi le wokuwa ta ye nu tuku piro taŋgo dubika wit kugerka ndaleka fambonu bude ta taŋgeramŋgit ŋgina le rugan nuŋe ndek nu sana: Ta maye le kaye ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Taŋakina le Rut nu kumba ka piro ande mbolŋge piro mbal dubika wit fambonu bunaig ta taŋgermba maŋgurka minna. Piro ta Boas tuku piro ta nu katese ndana. ");
INSERT INTO ssd_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Rut nu piroka minna le Boas nu Betlehemŋge promba nuŋe piro mbal kaŋgerka Suŋgo nu tane ndoŋ minwa ŋgina le nane ndek nu sanaig: Suŋgo tuku nyaro ne mbolŋge minwa ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Kile Boas nu nuŋe piro gabat ta kusnana: Pino mbanzo si nu kuasmbi ndaŋ tuku ŋgina le ");
INSERT INTO ssd_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","piro gabat ta lafumba nu sana: Pino si Moabnu. Nale Neomi ndoŋ Moabŋge te pronaik. ");
INSERT INTO ssd_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Nu piro mbal dubika wit fambonu taŋgeram tuku ye sayat. Nu maratukuk tiŋga piroka ma ma kile ndo baibai kumnemŋge fudiŋmba mabta minit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Taŋakina le Boas nu Rut sana: Kulim, ne ye tuku pasa isa. Ne piro kise mbol kumba wit fambonu taŋger ndawa. Ne piro te mbolŋge ndo minmba yiŋe piro pino kame tugum teŋge wit fambonu taŋgermba mina. ");
INSERT INTO ssd_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Nane taŋgo kame pino kame pirokade magot teŋge ndo piroka mina. Yiŋe piro taŋgo kame ne ŋayo sili ndanuwaig ŋga saniŋgit. Ne kule nyam paranuwa ndeta waim kule kunymba palig si kumba nya ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Taŋakina le Rut nu truk kumba Boas sana: Ye rawe pino. Ne ndaŋam ye mbolŋge maŋau mayenu kumba ye tur mayeyate ŋgina le ");
INSERT INTO ssd_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas nu lafumba sana: Ne taŋgo naŋe kumna le wam ŋakmba rugan naŋe mbolŋge ke likina ta sayinaig le isen. Ne naŋe tumbraŋ ina mam turmba kusreka ne pro sine mbal kise ŋgamukŋge minit ta ye kila. ");
INSERT INTO ssd_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Ne Israel mbal tuku Mbara Suŋgo tawok te prona. Nuŋge lafu mayenu lato-latomba ne mbolŋge kuwa ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Taŋaka sana le Rut ndek sakina: O taŋgo suŋgo, ne ye tur mayeyate. Ye ne tuku piro pino minig teŋen kuga. Ye nane kumnemŋge minet ta ne ye pasa bafumbi sayate le ye tuku ŋgamuŋgal saŋgri tiŋgate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Kile mabta isukusam bafumba Boas nu Rut sana: Ne te ilmba bret bateŋ inum tumba grep kule tomba nya ŋgina. Taŋakina le Rut nu kumba piro mbal tugum taŋge minyokina le Boas nu wit afu pasokinaig ta kilmba Rut tuna le nyumba marona le nyamagaŋ bateŋnu kusrekina. ");
INSERT INTO ssd_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Taŋamba Rut nu maŋ tiŋga wit fambonu taŋgeram kina le Boas nu nuŋe piro mbal saniŋgina: Pino si peu ndawap le wit ndale patikaig ta tugumŋge nu wit fambonu taŋgermba maŋgurkuwa. Tane nu sigair sigair ndawap. ");
INSERT INTO ssd_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Tane wit ndale ŋak ta afu goniŋmba kusrekap le nu kilmba maŋgurkuwa. Tane nu kasur ndawap ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rut nu piro mbolŋge wit fambonu taŋgermba minna le ki kumba ka butuŋgina. Nu ki kumba butuŋgina le wit fambonu taŋgerna ta kilmba mbanimbi baurŋgina le siŋ sikmba alonu ndekinaig le kilmba maŋgurkina. Alonu maŋgurkina ta pitinu 10 kilo taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Kile Rut nu wit alonu maŋgurkina ta kilmba tumbraŋ kumba rugan nuŋe tumna sulumba nu ki mbol isukusmba marona le ŋgirmannu kilmba kina ta mata rugan nuŋe tuna. ");
INSERT INTO ssd_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Tuna le Neomi nu ndek rugan nuŋe kusnana: Ne wit te aniŋge kilat? Taŋgo ima tuku piro mbolŋge ne pirokat? Taŋgo ne turnat ta Suŋgoŋge nyaro tuwa ŋgina le Rut nu sakina: Boas ŋgade taŋgo ta tuku piro mbolŋge ye pirokit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Taŋakina le Neomi ndek sakina: Taŋgo nane abo minig, nane kumig mbal ta Suŋgo nu nane tuku kume purte. Nuŋge taŋgo ta nyaro tuwa. Taŋakina sulumba nu maŋ lato sakina: Taŋgo ta nu sine tuku tira ande. Nu sile kulatkam tuku ŋgina ");
INSERT INTO ssd_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","le Rut ndek nu sana: Nu ye pasa ande turmba sayat. Ye nuŋe piro mbal dubika piroka mini le ka piro ta kugawam tuku sakat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Taŋakina le Neomi nu sakina: O rugan, ta son sakat. Ne kumba taŋgo ande tuku piro mbolŋge piroka ta piro mbal taŋge ne ŋayo silinubekaig. Ne Boas tuku piro pino kame ndo dubika piroka mina ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Taŋaka sana le Rut nu mara mindek Boas tuku piro pino kame dubika piroka minna le ka ka wit kilam tuku piro ta kugana. Kugana le Rut nu rugan nuŋe ndoŋ minnaik. ");
INSERT INTO ssd_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Taŋamba minnaik ma ma ait ande Neomi nu rugan nuŋe sana: Rugan, ye taŋgo ande ne tam tuku te-siliki le nu ne tuwa le ne mine mayewamŋgat. ");
INSERT INTO ssd_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Boas ŋgade taŋgo ne nu tuku piro pino kame dubika pirokina ta nu sine tuku tugu ndui ta. Ta tuku ne isa. Kite furir nu kumba ka wit baurŋgade ma mbolŋge wit roka bareŋguwa le bubreŋge firfirnu pufuŋguwa le alonu ndekuwaig le kilamŋgat. ");
INSERT INTO ssd_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ne kumba kule pismba gureŋ mundur mayenu ta pismba tawi mayenu silika wit baurŋganu ma ta tugum ndek kumba nu tuku am mbolŋge pro ndawa. Ne nu tairŋga mina le nu isukusmba kule nye deŋpurmba ");
INSERT INTO ssd_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","nu kumba kinyam bafuwa ndeta nu kinyit ma ta kaŋgera sulumba nu kinymba ŋgilaiŋguwa le nu ne kulatkuwa ŋga ne kumba nu tuku kupe kuitkambiŋge tawi kaikanu ta talka kaika sulumba nu tuku kupe tugum taŋge kinya le nu ne ndaŋka sanuwa ndeta ne ka ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Taŋaka sana le Rut nu sakina: Ta maye. Ye ne tuku pasa dubimba taŋamba kamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Kile Rut nu tiŋga ndek kumba ka wit baurŋgade ma ta mbol promba rugan nuŋe pasa sana ta kumumba kina. ");
INSERT INTO ssd_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas nu isukusmba kule nyumba gare-gareka ginyumna le nu kumba ka wit maŋgurkinaig ta tugumŋge kinyna. Nu kinymba gilaiŋgina le Rut nu siŋsiŋndo kumba tawi kaikina ta talka nu tuku kupe kuitkambi tugum taŋge kinyna. ");
INSERT INTO ssd_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Kinyna le furir ŋgamu Boas nu kinymba mbilkina sulumba pino nu tuku kupe kuitkambiŋge kinyna ta kamusna. Kamusna kande pino le nu piririmba ");
INSERT INTO ssd_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","i ... Ne imaŋge ŋgina le Rut ndek nu sana: Ye ne tuku piro pino Rutŋge. Ne Elimelek tuku tugu ndui ta tukunu ne ye pinonu tumba kulatka ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Taŋakina le Boas ndek sakina: O kulim, Suŋgoŋge ne nyaro tinwa. Ne kile wam kat te amboŋga rugan naŋe mbolŋge wam mayenu kina ta lite. Taŋgo mo gudommba minig te. Nane afu agaŋ ndende suŋgomba ŋak afu agaŋ ndende kugatok ta ne nane tuku inum tam idus ndate. ");
INSERT INTO ssd_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ne kuru kuru ndaka. Ne pino mayenu ta sine tumbraŋ taŋgo pino ŋakmba sine kila. Wam ŋakmba ye kam tuku sayat ta ye kamŋgit. ");
INSERT INTO ssd_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ne sakate ta son. Ye rugan naŋe Elimelek ndoŋ tugu ndindo. Ye ne kulatkam tuku ta tira ande mata sine ndoŋ tugu ndindo minit ta nu ye tuku suŋgo. Ye nu liwam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ne teŋge mina. Ye indole maratukuk kumba nu tuku wamdus katesewamŋgit. Nu ne kulatkam sukuwa ndeta maye. Nu mbulwa ndeta yiŋe ne kulatkamŋgit. Ye Suŋgo tuku nyu mbolŋge pasa te saŋgri pilewet. Ne maŋ kinya ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","nu sana: Ne ye tugum prowat te taŋgo kame nane kaŋger ndanuwaig ŋgina. Taŋakina le Rut nu maŋ Boas tuku kupe kuitkambiŋge kinyna. Mafe maye ndana le Rut nu tiŋga kambim bafuna le ");
INSERT INTO ssd_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Boas nu sana: Ne naŋe tawi inum tumba kilke mbol teŋge fara ŋgina. Rut nu taŋamba nuŋe tawi ande tumba farna le Boas nu wit maŋgur 6 kilmba tawi ta mbolŋge kutuna. Taŋamba Boas nu Rut turmba wit tawi ŋak ta te-duŋga tuna le tumba luka nuŋe tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut nu kumba rugan nuŋe tugum prona le rugan nuŋeŋge nu kusnana: Rugan, ne wam kat ta kubewa le ye isi ŋgina le Rut nu Boasŋge wam ŋakmba kina ta kubeu tuna. ");
INSERT INTO ssd_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Kubeu tuna sulumba rugan nuŋe sana: Boas nu teŋenmba ye sayat. Ne ake luka rugan naŋe sota kaye ta mayenu ndo kuga ŋga wit te ŋakmba tolmba ye sat ŋgina le ");
INSERT INTO ssd_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","rugan nuŋe nu sana: Rugan, ne nu ndo tairŋga mina. Kite Boas nu ake minam kumuŋ kuga. Nu pasa ta te-tiwa le ame wam prowa le sile kaŋgeramkik ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boas nu mbumba kumba maŋgurkam tuku ma mbolŋge minyokina. Ma ta tumbraŋ ta tuku fonde malaŋga tugumŋge. Nu minyok minna le Elimelek tuku tugu mbolŋge Boas nuŋe tira nuŋe ilmba minna le kaŋgermba wikina: Mata, ne ilmba teŋge minyoka le ye pasa ande fudiŋndo ŋak ŋgina. Taŋakina le nu ilmba nu tugum taŋge minyokina. ");
INSERT INTO ssd_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Minyokina le Boas nu tumbraŋ ta tuku gabat kame 10 saniŋgina le nane mata promba taŋge minyokinaig. ");
INSERT INTO ssd_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Nane minyokinaig le nu nuŋe tira nuŋe ta sana: Neomi Moabŋge luka prona ta nu sikile tira Elimelek tuku kilke sile tuku inumŋge piyawa ŋga sakate ta ");
INSERT INTO ssd_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","ye ne sanam tuku wikit. Ne ye tuku suŋgo. Ne kilke ta piyawam idusmba kande siŋgine gabat kame taŋgo minig te am mbolŋge piyawa. Ne mbulmba ndeta ye tugusemba saya le isi. Taŋgo ande mine ndakate. Sileŋge ndo ŋgina. Taŋakina le taŋgo ta nu sana: Maye. Yeŋge piyawamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Taŋakina le Boas ndek nu sana: Ne Neomi tuku kilke ta piyamba ndeta Moabnu pino kuembol Rut turmba ne tamŋgat. Taŋawa le nu kiŋo inum te-pilwa ta taŋgo kumna ta tuku kuasmbi nane tuku kilke naŋgine minamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Taŋaka sana le taŋgo ta ndek sakina: Wam minde bada taŋaŋ ta ye kilke ta piyawam mbulit. Ŋgumneŋga kiŋo taŋge ye tuku kilke ta tuwa le ye tuku ndametiŋ ake ŋgisikikat tukunu ye mbulit. Neŋge kilke ta piyawa ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","nu nuŋe kupe ŋgaro paska Boas tuna. Ta ndaŋam? O buk Israel mbal nane agaŋ ande taŋgo inum tambim bafumba taŋamba kumba minanu. Taŋgo andeŋge nuŋe kupe ŋgaro paska taŋgo inum tambinu. Israel mbal nane taŋamba pasa te-tiwanu. ");
INSERT INTO ssd_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ta tuku taŋgo ta nu Boas sana: Neŋge kilke ta piyawa ŋgina sulumba nuŋe kupe ŋgaro paska Boas tuna. ");
INSERT INTO ssd_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Tuna le Boas nu gabat kame taŋgo pino nane teŋenmba saniŋgina: Elimelek Kilion Malon nane keŋ ta tuku agaŋ ndende Neomiŋge kulatkate ta kile yeŋge ŋakmba piyamba kilit ta tane ŋakmba kaŋgerde. ");
INSERT INTO ssd_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Moabnu pino Malon tuku kuembol Rut nu mata yiŋe pinonu kile tet. Taŋawi le taŋgo kumna ta tuku kilke ta nuŋe kuasmbi tuku kilke minmba minamŋgat. Nu tuku nyu mata nuŋe kuasmbi ŋgamukŋge ŋgisike nda. Minmba minamŋgat. Ye maŋau ket te tane kile kaŋgerde ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Taŋaka saniŋgina le nane gabat kame taŋgo kame ndoŋ nane ndek sakinaig: Sine kile kaŋgermba kila pileg. Pino neŋge tamŋgat ta ne tuku wande mbol kuwa le Suŋgoŋge sinzaŋwa le Israel mbal tuku mbuŋ Rahel nale Lea taŋaŋ minwa. Ne Efrat tumbraŋ mboŋ ŋgamukŋge Betlehem tumbraŋŋge ne nyu suŋgo ŋak mayok kuwa. ");
INSERT INTO ssd_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Pino ta Suŋgoŋge turwa le kiŋo gudommba kile-patike tinwa le ne tuku kuasmbi ta Yuda le Tamar tuku kiŋo Peres nu tuku kuasmbi taŋaŋ mayok kuwa ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kile Boas nu nuŋe pasa kumumba Rut pinonu tina sulumba nu tumba nuŋe wande mbol kina. Kina sulumba Boas nu Rut ndoŋ kinyna le Suŋgoŋge Rut sinzaŋna le nu fuŋgul ŋakna. Taŋamba minna ma ma nu kiŋo te-pilna. ");
INSERT INTO ssd_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Kiŋo ta te-pilna le tumbraŋ ta tuku pino kame nane Neomi sanaig: Sine Suŋgo tuku nyu te-duŋgube. Nuŋge kiŋo te ne kulatkam tuku tanet. Nu Israel mbal tuku kuasmbi ŋgamukŋge nu nyu suŋgo ŋak minwa. ");
INSERT INTO ssd_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Rugan naŋe tuku maŋau mayenu taŋge ne tuku kiŋo kame suŋgomba taŋaŋ minanu suk. Ne kiŋo te kaŋgermba ne maŋ saŋgri tiŋgamŋgat. Ne saibo pale le kiŋo teŋge ne turnumba kulat mayenamŋgat ŋga sanaig. ");
INSERT INTO ssd_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Taŋamba sanaig le Neomi ndek kiŋo ta tumba bagailmba nuŋe kulat kuapina. ");
INSERT INTO ssd_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Kulat kuapina le tumbraŋ ta tuku pino kame nane ndek sakinaig: Neomi nu kiŋo inum tat ŋginaig sulumba kiŋo ta nyunu Obed ŋginaig. Obed nu suŋgokina sulumba Yesi te-pilna. Yesi tuku kiŋo nuŋe David. ");
INSERT INTO ssd_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Peres tuku ndare pulu tuturmba ka David mbolŋge tiŋgina ta teŋenmba. Peres kiŋo nuŋe Hesron. ");
INSERT INTO ssd_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesron kiŋo nuŋe Ram. Ram kiŋo nuŋe Aminadab. ");
INSERT INTO ssd_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab kiŋo nuŋe Nason. Nason kiŋo nuŋe Salmon. ");
INSERT INTO ssd_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon kiŋo nuŋe Boas. Boas kiŋo nuŋe Obed. ");
INSERT INTO ssd_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed kiŋo nuŋe Yesi. Yesi kiŋo nuŋe David. ");
INSERT INTO ssd_vpl VALUES ("S11_1","010_1_1","1SA","1","1","2","Taŋgo ande nyunu Elkana nu tumbraŋ suŋgo Rama Efraim kumamŋge ma taknu mbolŋge minnaig. Taŋgo ta nu pino armba ŋak ande Hana ande Penina. Penina nu kutu ŋak. Hana nu kutu kugatok. Elkana mam nuŋe Yeroam. Wa nuŋe Elihu. Mbuŋ mbuŋ nuŋe Tohu. Tumbraŋ mboŋ naŋgine Suf. ");
INSERT INTO ssd_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Elkana nu yar mindek Rama tumbraŋ kusremba Suŋgo Saŋgri Ŋayo tuku nyu te-duŋga nu tuku atraukam saka Silo tumbraŋ kambinu. Tumbraŋ suŋgo taŋge Elai tuku kiŋo armba Hofni le Pineas nale Suŋgo tuku pris minnaik. ");
INSERT INTO ssd_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Elkana nu atraukam ait mbolŋge agaŋmor ndemnu kilmba walmba ndindo piyo nuŋe Penina tumba ande tumba nu tuku kutu kame foŋfoŋmba walmba kilwaig ŋga niŋganu. ");
INSERT INTO ssd_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Hana nu Suŋgoŋge kutu ŋgailna ta Elkana nu kasur ndamba nu tuku kume purmba minna sulumba nu agaŋmor ndemnu walmba Hana armba tambinu. ");
INSERT INTO ssd_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Hana nu Suŋgoŋge kutu ŋgailna tukunu Penina nu mara mindek taŋgo tuku tira dirka Hana maim maim te-tumba nzumil-nzumilmba minanu. ");
INSERT INTO ssd_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Yar mindek nane wam ta kanu. Nane Suŋgo tuku tukul wande mbol kambinu ta Penina nu Hana maim maim te-tambinu le nu malmbika isukuse ndaka minanu. ");
INSERT INTO ssd_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Ait ande nu taŋana le Elkanaŋge kaŋgermba Hana kusnana: Ndaŋam tuku ne malmbika isukusam mbulit sulumba wamdus ŋgamuŋgal piti ŋak ndo minit e. Ne pino kuembol kuga. Ye ne ndoŋ minmba ne tuku kume puret tukunu ne kiŋo kugatok ta tuku piti ndanuwa ŋga piyo nuŋe sana. ");
INSERT INTO ssd_vpl VALUES ("S11_9","010_1_9","1SA","1","9","10","Taŋamba minnaig ma ma ait ande nane Silo tumbraŋŋge atrauka isukusmba minnaig. Isukuse deŋpurnaig sulumba Hana nu ŋgamuŋgal tatruka wamdus ndekina le nu ndek tiŋga nane kusreka ka Suŋgo tuku tukul wandek sinam kumba ka taŋge malmbika Suŋgo yabaŋmba minna. Yabaŋmba minna le Kuate tuku pris Elai nu malaŋga tugum taŋge minyok minna. ");
INSERT INTO ssd_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Kile Hana ndek yabaŋmba Suŋgo ndoŋ pasa katmba teŋenmba sakina: O Suŋgo Saŋgri Ŋayo, ye ne tuku piro pino minet. Ne ye tuku ŋgamuŋgal wamdus tatrukate te kaŋgermba ŋgumne ndayumba ye idusyumba kiŋo ande te-sa le ye kiŋo ta maŋ luka ne tini le ne tuku piro taŋgo minmba minamŋgat. Ta tuku nu tuku gabat waŋe ta andeŋge kuerke nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S11_12","010_1_12","1SA","1","12","13","Hana nu wamdus sinamŋge ndo Suŋgo yabaŋmba miŋge motmotka minna le ma ma Elai ndek mambilmba nu tuku miŋge kaŋger tina sulumba idusna: i ... Pino si kule kamenu nyumba ŋginŋgankate ŋga idusmba ");
INSERT INTO ssd_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","nu tiŋga nu tugum kumba sawe lika sana: Ne ginu le grep kule nyumba ŋginŋgankate wam ta mbulamŋgat e ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Hana ndek lafumba sana: O taŋgo suŋgo, taŋamba kuga. Ye kule kamenu ande nye ndakit. Ye piti suŋgo ŋak tukunu ye Suŋgo yabaŋmba yiŋe piti ta ŋakmba kile-mayokit le purfewat. ");
INSERT INTO ssd_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Ne ye pino ŋayonu ŋga tala ndaya. Ye piti suŋgo kamusmba ŋgamuŋgal ŋayoŋga wamdus tatrukat le ye wam ta tuku yabaŋit ŋga Elai sana. ");
INSERT INTO ssd_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Taŋakina le Elai ndek lafumba nu sana: Ta maye. Ne ŋgamuŋgal mukuk wamdus bulok ŋak kaye le sine Israel mbal tuku Mbaraŋge ne ame agaŋ nzalinu nu yabaŋat ta ne kumumbi tanmbimŋgat ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Hanaŋge Elai sana: O taŋgo suŋgo, ne mara mindek ye gilai ndaŋga ye idusya ŋga sana sulumba nu wamdus bulka nu kusremba isukusam kina. ");
INSERT INTO ssd_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Mafena le maratukuk tiŋga Elkana nane Suŋgo tuku nyu te-du deŋpurmba luka Rama tumbraŋ kinaig. Kinaig ka taŋge Elkana nu piyo nuŋe Hana ndoŋ tuma kinynaik le Suŋgo ndek Hana tuku yabaŋ pasa ta idusmba kumuwe tuna le nu kiŋo konna. ");
INSERT INTO ssd_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Taŋamba minna ma ma Hana nu kiŋo ande te-pilna ta nyunu Samuel ŋgina sulumba nyu ta tugunu kuklimba teŋenmba sakina: Ye kiŋo te tuku ŋga Suŋgo yabaŋen ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Kile Elkana nuŋe gageu ndoŋ maŋ Suŋgo atraukam saka Silo kinaig. Nu yar mindek nuŋe pasa buk saŋgri pilena ta kumumba maŋau kanu taŋamba maŋ kam saka kinaig. ");
INSERT INTO ssd_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Hanaŋge ndo nane ndoŋ kine ndakina. Nu taŋgo nuŋe teŋenmba sana: Tane kape. Ye kiŋo te amo ŋgailmba nu tumba Suŋgo tuku tukul wande mbol ka le nu Suŋgo tuku Wandekŋge minmba minamŋgat ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Elkana lafumba Hana sana: Ne sakate ta maye. Ne tumbraŋ teŋge ndo mina le kiŋo amo kusrewa le tale Suŋgo ndoŋ pasa katnaik ta tuku alonu prowamŋgat ŋgina. Taŋakina le Hana tumbraŋŋge kiŋo nuŋe amo tumba minna. ");
INSERT INTO ssd_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Minnaig ma ma kiŋo ta suŋgoka amo kusrena le ina nuŋe nu tumba Silo tumbraŋ kambim saka makau pailnu yar keŋmba ŋak ta tumba plaua bek ande tumba grep kule agaŋmor ŋgaronumbi tolnaig ta turmba kilmba kina. Samuel nu amo kusrena le nane nu tumba Silo tumbraŋ Suŋgo tuku Wande mbol kinaig. ");
INSERT INTO ssd_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Kinaig ka ta promba nane makau pailnu ta tumba balenaig sulumba kiŋo ta tumba Elai tugum pronaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Hana ndek Elai sana: O taŋgo suŋgo, ne ye idusyate e. Ye o buk teŋge Suŋgo yabaŋmba minen le ne ye kaŋgeryina ta ");
INSERT INTO ssd_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","ye kiŋo te tuku ŋga Suŋgo yabaŋen le kiŋo te ye te-sina. ");
INSERT INTO ssd_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Ta tuku ye kile nu tumba Suŋgo tuku wai mbol palmbim tuku prowet. Nu Suŋgo tuku piro taŋgo minmba minwa ŋga Elai sana. Taŋaka sana le nu ndek dagol tidroŋga Suŋgo tuku nyu te-duŋgina. ");
INSERT INTO ssd_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Kile Hana nu yabaŋmba sakina: O Suŋgo, ne ye sinzaŋ mayeyina le kile ye nyu ŋak minmba ne tuku gare suŋgo tet. Ne ye tur mayeyina le ye mbal kasur-kasuryinaig ta nzumilniŋget. ");
INSERT INTO ssd_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","O Suŋgo, ne ndo purfeŋnu. Ande ne suk mine ndakate. Neŋge ndo sine kigraibka turkate. ");
INSERT INTO ssd_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","O Suŋgo, sine maŋau ŋakmba ke likeg ta ne kumumbi pileniŋgit. Ta tuku taŋgo pino naŋgine nyu payamkade wam ta kusreka miŋge tukulwaig. ");
INSERT INTO ssd_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Ne taŋgo saŋgriknu tuku tui ŋgurniŋgit. Afu saŋgri kugatok minig ta ne nane saŋgri pileniŋgit. ");
INSERT INTO ssd_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Afu buk maro ŋak minnaig ta kile nane gubanu nyamagaŋ kilam tuku ake pirokade. Afu buk gubak minnaig ta nane kile maro ŋak minig. Pino kame buk niŋkanu minnaig ta ne nane sinzaŋniŋgit le kile kutu suŋgomba kile-patikade. Afu buk kutu suŋgomba kile-patikinaig ta nane kile niŋanu minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","O Suŋgo, ne taŋgo abo minig ta baleniŋgit le kumig. Afu kume likinaig ta ne maŋ abo tugu niŋgit. Ne taŋgo kumig ta kilmba patikate le kumanu mbal tuku tumbraŋ kinig ta maŋ luka kilit sulumba abo tugu niŋgit. ");
INSERT INTO ssd_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Ne nane afu ndametiŋ sugo ŋak ta sanzal pileniŋgit sulumba sanzal mbal ndametiŋ suŋgo niŋgit. Ne taŋgo nyu ŋak te-ibeŋte sulumba taŋgo nyu kugatok ta taŋgo pino am mbolŋge nyu suŋgo tuwit. ");
INSERT INTO ssd_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Ne nane agaŋ ndende kugatok sanzal minig ta turkate le nane agaŋ ndende kumuŋ minig sulumba taŋgo nyu sugo ŋak ta ndoŋ ulendikade le nyu sugo niŋgig. O Suŋgo, ne kilke te te-mayokna sulumba agaŋ ndende yeki yeki patikina. ");
INSERT INTO ssd_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Ne naŋe miŋge kumnemŋge minig mbal tuku kume purte sulumba ne nane kulatkate. Afu ne idus ndanade ta ne nane kilmba piti niŋmba patikate le ma furir sinamŋge ŋgisinuŋgaig. Taŋgo saŋgri ŋaigo ta nane naŋgine saŋgri tambi minam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","O Suŋgo, ne samba mbolŋge kuaila pilit le suŋgomba fudukate le ne naŋe ŋgueu mbal ŋakmba ŋaigo siglikate. Ne taŋgo pino kilke tugu ŋakmba mbolŋge kilmba pasa mbolŋge patika nane pileniŋgit. Ne gabat suŋgo madina ta saŋgri pilemba nyu suŋgo nuŋe kuasmbi ŋgamukŋge tuwit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Hana nu yabaŋ deŋpurmba nu taŋgo nuŋe Elkana ndoŋ luka naŋgine tumbraŋ Rama kinaik le Samuel nu Siloŋge Suŋgo tuku piroka minna le Elaiŋge nu kulatka minna. ");
INSERT INTO ssd_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Elai tuku kiŋo kat nuŋe ar ta nale mugru sambek. Nale Suŋgo idus ndanaik. ");
INSERT INTO ssd_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Nale pris kame taŋgo pino mbolŋge agaŋ ndende kilam tuku tukul maŋau ta dubi ndanaik. Taŋgo ande atraukam tuku agaŋmor tumba waimmbi kusirkam bafumba minanu ta nale piro taŋgo ande kukulanu le nyagi tumba kumba ");
INSERT INTO ssd_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","waim sinamŋge nyagimbi ndem deŋŋga kilmba kumba nikanu. Israel mbal atraukam Silo prowanu ta nale wam ndui ta ndo kanu. ");
INSERT INTO ssd_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Taŋamba ndo taŋgo ande agaŋmor kuyanu te-si ndamba pa mbolŋge piye ndaka minanu ta piro taŋgo ta promba taŋgo ta teŋenmba sawanu: Pris tuku ndem afu abonu ta kile-sa le nuŋe pasokuwa. Nu ndem kusirkanu ta nu mbulit. Nu ndem abonu ndo nzalite ŋga sawanu. ");
INSERT INTO ssd_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Taŋgo ta ndek lafumba sawanu: Ye atraukam tuku tukul maŋau ta dubimba amboŋga kuyanu ta pambi pasoki le ugwaig le ŋgumneŋga ne ndem ndaŋ nzalinuwa kande ne kila ŋga sawanu ta piro taŋgo ta ndek sawanu: Kuga. Ne kile ndo ye sa. Kuga ta ye yiŋe waimbi kilamŋgit ŋganu. ");
INSERT INTO ssd_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Wam ta mbolŋge Elai tuku kiŋo ar ta nale Suŋgo am mbolŋge mbaranu le taŋgo pino nane Suŋgo atraukam tuku tukul maŋau ta ake agaŋ taŋaŋ ŋga talakanu. ");
INSERT INTO ssd_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Samuel nu kiŋo mo minna ta nu pris tuku mindepiye tawi tiŋmba Suŋgo tuku piroka minna. ");
INSERT INTO ssd_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Ina nuŋe yar mindek nu tuku tawi fudiŋndo wakeimba tumba atraukam tuku ait mbolŋge taŋgo nuŋe ndoŋ kumba ka nu tambinu. ");
INSERT INTO ssd_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Taŋawanu le Elaiŋge Elkana le piyo nuŋe nyaro nikmba sakanu: Suŋgoŋge piyo naŋe sinzaŋwa le kiŋo Suŋgo tunaik te lafunu maŋ kutu afu kile-patikamŋgat ŋga sanikanu le nale luka nakile tumbraŋ kambinu. ");
INSERT INTO ssd_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Kile Suŋgoŋge Hana sinzaŋ mayena le Hana nu kiŋo keŋmba kulim armba kile-patike likina ta Samuel nu Suŋgo tuku piroka minmba ma ma mbanzoŋgina. ");
INSERT INTO ssd_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Elai nu buk saibo pile mayena le nu tuku kiŋo kat nuŋe ar ta nale maŋau ŋaigonu kumba Suŋgo tuku baibai malaŋga tugum taŋge pirokinaig pino kame ta ndoŋ tuma kinyanu wam ta Israel taŋgo pino kaŋgermba kumba ka Elai samba kubeu tunaig le nu isna sulumba ");
INSERT INTO ssd_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","nuŋe kiŋo ar ta sanikina: Tale ndaŋam maŋau ŋaigonu ta kade? Tale taŋade le taŋgo pino ŋakmbaŋge tale tuku maŋau ŋaigonu kade ta tuku sakade le iset ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","sakina: O kiŋo kame, tale maŋau mbarmbarde ta kusrewap. Taŋgo pino ŋakmbaŋge tale wam mbarmbarde ta tuku sakade. Tale Suŋgo tuku piro mbal ndoŋ maŋau ŋaigonu kade ŋgade ta wam mayenu kuga. ");
INSERT INTO ssd_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Taŋgo andeŋge taŋgo inum mbolŋge mbarwa ta Kuateŋge pasa ta te-timba maŋau ta kume seramŋgat. Taŋgo ande Suŋgo kumammba mbarwa ta imaŋge ŋgamuŋge tiŋga pasa ta te-timba kume seramŋgat e ŋga sanikina. Taŋakina ta Suŋgo nu buk nale balenikam tuku wamdus kuyarkina tukunu nale mam nakile tuku pasa ta ise ndakinaik. ");
INSERT INTO ssd_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Samuel nu mbanzoŋgina le taŋgo pino ŋakmba Suŋgo mata nane nu make pilnaig. ");
INSERT INTO ssd_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Taŋamba minnaig ma ma ait ande Kuate tuku piro taŋgo ande Elai sota prona sulumba Suŋgo tuku miŋge tumba sana: Mbuŋ naŋe nuŋe kuasmbi ndoŋ Isip gabat suŋgo Farao tuku piro taŋgo minnaig le ye kilimok nane tugumŋge mayokkan sulumba ");
INSERT INTO ssd_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Israel tugu ŋakmba ŋgamukŋge mbuŋ naŋe tumba yiŋe pris minam tuku madiwen le nuŋge pris tuku tawi ta tiŋmba atrau mbain mbolŋge pa guwa mundur mayenu ŋak ta pilmba minanu. Taŋawanu le yeŋge agaŋmor atrauka pasokanu ndem ta nu nuŋe ndare kame ndoŋ nyuwaig ŋga saniŋgen. ");
INSERT INTO ssd_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Ta tuku ne ndaŋam tuku yiŋe wande mbolŋge agaŋmor baleniŋmba atraukam tuku wam ta talaka kiŋo kat naŋe ar ta tuku wamdus suŋgo ŋak minmba ye gilaiŋga tane agaŋmor ndemnu kuya ŋak ŋak ta nyumba sugo ŋaigode? ");
INSERT INTO ssd_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Ye tane Israel mbal tuku Mbara Suŋgo ye o buk tane tuku mbuŋ kat taŋgine teŋenmba saniŋgen: Tane taŋgine ndare ndoŋ ye tuku am mbolŋge pris piroka minmba minamŋgaig ŋga saniŋgen ta kile tane maŋ piro ta ke nda. Taŋgo ima nu ye tuku nyu te-duŋguwa ta yeŋge nu nyu suŋgo tambimŋgit. Taŋgo ima nu ye talayate ta yeŋge nu mata talawamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Ne ise tiwa. Mine minemba ye ne naŋe tugu ndoŋ saŋgri kile-ibeŋki le tane saibo patika kume nda. ");
INSERT INTO ssd_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Tane sinamanzerka minap le ye Israel mbal afu sinzaŋ mayeniŋgi le ne tuku tugu nane ndo saibo patika kume nda. ");
INSERT INTO ssd_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Ye ne tuku ndare afu mapeki le pris piroka minwaig ta nane mbarmba piti ne tinwaig le ne tuku wamdus tatrukamŋgat. Naŋe ndare ta ŋakmba taŋgo ŋgaro lewaig sulumba saibo patika kume nda. ");
INSERT INTO ssd_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","Ne tuku kiŋo armba Hofni le Pineas nale ait ndui ta mbolŋge ndo kumamŋgaik. Taŋawaik le ne pasa ŋakmba sanet ta son ŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Ye pris ande kateseknu madiwi le nu ye ndoŋ wamdus ulendi ŋak pris piro biywa le ye nu tuku kuasmbi ndo sinzaŋniŋgi le nu ye tuku am mbolŋge pris piroka minmba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Taŋawa le ne tuku ndare ande minwa ta nu pris ta sota kumba dagol tidroŋga ndametiŋ bret fambonu nu tuwa ŋga sawa sulumba sawamŋgat: Ne ye pris piro ande sa le ye piroka nyamagaŋ afu kili ŋga sawamŋgat ŋga Elai sana. ");
INSERT INTO ssd_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Samuel nu kiŋo mo minna sulumba nu Elai turturmba Suŋgo tuku piroka minna. Ait ta mbolŋge Suŋgo nu tuan taŋgo suŋgomba wam pagu pasa nda niŋganu. Nane ndui ndui ndo kiŋatanu suk wam afu tumniŋganu le kaŋgerkanu. ");
INSERT INTO ssd_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Elai nu buk am ŋaigoŋginaig le furir ande mbolŋge nu wandek sinam taŋge kinymba minna le ");
INSERT INTO ssd_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Samuel nu tukul wande sinam taŋge kinyna. Kuate tuku tukul bokis mata wande ndui ta sinamŋge minna. Lam buluŋga minna le mafewam patikina le ");
INSERT INTO ssd_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Suŋgo nu Samuel wikina le nu ndek woka sakina: Ye ilet o ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","pinderka kumba Elai sana: Neŋge ye wikat e ŋgina kande Elai nu sana: Kuga. Ye ne nda wikit. Luka ka kinya ŋgina le nu luka ka kinyna. ");
INSERT INTO ssd_vpl VALUES ("S13_6","010_3_6","1SA","3","6","7","Kinyna le Suŋgo maŋ lato Samuel wikina ta Samuel nu katese ndana. Ta ndaŋam? Suŋgo nu buk nu tugum promba pasa ande sa ndana tukunu nu Suŋgoŋge wikina ta nu katese ndana. Ta tuku nu pastiŋga Elai sota kina sulumba sana: Neŋge ye maŋ wikat e ŋgina kande Elai nu lafumba sana: O kiŋo, yeŋge ne nda wikit. Luka ka kinya ŋgina le nu maŋ luka ka kinyna. ");
INSERT INTO ssd_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Taŋamba kinyna le Suŋgo maŋ lato Samuel wikam keŋna le nu maŋ aboŋgina sulumba Elai sota kumba sana: Neŋge ye wika minit e ŋgina. Taŋakina le Elai nu wamdus puluna le Suŋgoŋge kiŋo te wikate ŋga idusna sulumba ");
INSERT INTO ssd_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Samuel sana: Luka ka kinya le nu maŋ ne wikuwa kande teŋenmba sawa: O Suŋgo, ye ne tuku piro taŋgo. Ne ye saya le isi ŋga sawa ŋgina. Taŋakina le Samuel luka ka kinyna. ");
INSERT INTO ssd_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Samuel nu kinymba minna le Suŋgo nu maŋ lato nu tugum promba wika sakina: Samuel, Samuel ŋgina le Samuel nu woka sakina: O Suŋgo, ye ne tuku piro taŋgo. Pasa saya le ye isi ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Taŋakina le Suŋgo ndek Samuel sana: Mine minemba ye Israel mbal ŋgamukŋge wam ande ki le nane ŋakmba ismba piriri ŋayowamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Ait ta mbolŋge ye wam afu Elai tuku ndare mbolŋge ke likam tuku buk saken ta kumumba nane mbolŋge kamŋgit. ");
INSERT INTO ssd_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Ye buk nu sawen. Nu tuku kiŋo ar ta ye kumammba ŋgumnem pasa sakade ta Elai nu kila ta nu nale peu ndanikit tukunu yeŋge nu tuku ndare tuturmba kaŋgat ta piti sugokanu niŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Ta tuku ye Elai nuŋe kuasmbi siŋka pasa saŋgrinu saniŋgen. Nane ye tuku atraukamŋgaig ta ye nane tuku une ŋaigonu ta sauka gilaiŋge nda ŋga Samuel sana. ");
INSERT INTO ssd_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samuel nu nuŋe mbain mbolŋge kinymba minna le ka mafena. Mafena le maratukuk nu aboŋga tiŋga ka Suŋgo tuku Wande malaŋga talke likina sulumba wam kiŋatanu suk kaŋgermba isna ta Elai sawam kuru-kurukina. ");
INSERT INTO ssd_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Taŋana le Elai nu wika sana: Kiŋo ya, ne ilmba o ŋgina le Samuel nu ndek sana: Au. Ye ilet o ŋgina sulumba nu sota kina le ");
INSERT INTO ssd_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Elai nu kusnana: Kuate nu ne ndaŋmba sanat? Ye mbolŋge pasa afu yabu ndaka. Ne ye mbolŋge pasa afu yabuka ta Kuateŋge ne mapene nda ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Taŋaka sana le Samuel nu pasa ŋakmba isna ta nu kubeu tuna. Nu pasa ande yabu ndakina le Elai ndek nu sana: Nu Suŋgo. Nu wam ndaŋ kam bafuwa ta nu kuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Taŋamba minnaig ma ma Samuel nu suŋgoka taŋgo ŋgaro lena le Suŋgo nu mara mindek nu ndoŋ minna. Samuel nu wam afu prowam tuku sakanu ta Suŋgoŋge alonu kile-mayokanu. ");
INSERT INTO ssd_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Taŋamba minna le Israel ma tugu ŋakmba mbolŋge taŋgo pino ŋakmba nane Samuel Suŋgoŋge tuan taŋgo madina ta nane kila pilnaig. ");
INSERT INTO ssd_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Suŋgo nu mara mindek Silo tumbraŋŋge Samuel tugum promba nu wam pagu pasa sawanu. Taŋawanu le Samuel nu pasatanu ta Israel mbal ŋakmba nane nu isanu. ");
INSERT INTO ssd_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Ait ta mbolŋge Israel mbal nane Filistia mbal ndoŋ kame buwam saka ka Eben-Eser tumbraŋŋge ma tumba kame tuku kuanekinaig le Filistia mbal mata nane Efekŋge ma tumba kame tuku kuanekinaig. ");
INSERT INTO ssd_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Taŋamba minnaig sulumba Filistia mbal nane ulendika ma gutoŋ taŋge Israel mbal ndoŋ kame bunaik sulumba kame saŋgri tiŋgina le nane Israel mbal kile-ibeŋka taŋgo 4,000 taŋaŋ bale farniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Taŋanaig le kame taŋgo afu ta luka Eben-Eser promba Israel mage mage wam kubeu niŋginaig le nane naŋgine naŋgine sakinaig: Ndaŋam tuku Suŋgo nu sine ŋgumnesiŋmba Filistia mbal sinzaŋniŋgit le nane sine bale far sulude? Sine Silo kab sulumba Suŋgo tuku pasa katanu bokis ta tumba probe le bokis taŋge sine sinzaŋsiŋguwa le ŋgueu mbal nane sine suluwe nda ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Taŋamba nane taŋgo afu kukulniŋginaig le Silo kinaig sulumba Suŋgo Saŋgri Ŋayo eŋel kanunu armba ŋgamukŋge minyok minit nu tuku pasa katanu bokis ta tumba luka ilnaig. Elai tuku kiŋo armba Hofni le Pineas mata bokis ta ndoŋ ndoŋ ilnaik. ");
INSERT INTO ssd_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Nane Suŋgo tuku pasa katanu bokis ta tumba pronaig le Israel mbal nane kaŋgermba gare-gareka wika raunaig le kilke buru-burukina. ");
INSERT INTO ssd_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Taŋanaig le Filistia mbal nane zigna ta ismba naŋgine naŋgine sakinaig: i ... Ndaŋam saka nane Hibru mbal si taŋamba wika raude ya ŋginaig le nane afu pro saniŋginaig: Suŋgo tuku tukul bokis tumba prowaig ŋginaig le nane pasa ta ismba ");
INSERT INTO ssd_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","nane kuru kuru mayemba sakinaig: i ... Kile naŋgine mbara nane tuku tumbraŋ towat. Kile sine ndaŋamŋgig? Sine maŋau ande taŋaŋ buk kaŋger ndageŋ. ");
INSERT INTO ssd_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Imaŋge sine sinzaŋsiŋguwa le nane tuku mbara Saŋgri Ŋayo ta sine ŋaigo siglike nda. Mbara taŋge ma baknu mbolŋge Isip mbal piti yeki yeki niŋgina tuku. ");
INSERT INTO ssd_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Hibru mbal si amboŋga sine tuku piro mbal minnaig ta kile sine maŋ nane tuku piro mbal minbekig tukunu sine kuru kuru ndaka saŋgri tiŋga kame bube ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Taŋakinaig sulumba Filistia mbal nane saŋgri tiŋga kame bunaig sulumba Israel mbal kile-ibeŋka nane suŋgomba bale farniŋginaig le nane afu kua ka Eben-Eser kinaig. Ki ait ta mbolŋge nane Filistia mbalŋge Israel taŋgo 30,000 bale farkinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Kuate tuku tukul bokis ta yaika tumba Elai tuku kiŋo armba Hofni le Pineas mata balenikinaik le kumnaik. ");
INSERT INTO ssd_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Kile Benyaminnu taŋgo ande kame ma ta kusremba nuŋe tawi fetfetmba kilke roka kilmba gabat pisnemba pinderka kua ka ka Silo prona. ");
INSERT INTO ssd_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Prona ta Elai nu ndin makembiŋge nuŋe minyo mbili mbolŋge minyoka ndin kulatka Kuate tuku tukul bokis ta tuku wamdus sulumba minna. Minna le taŋgo ta nu promba tumbraŋŋge taŋgo pino ŋakmba kame mbolŋge maŋau prowe likinaig ta kubeu niŋgina le nane ismba ŋgamuŋgal ŋaigoŋga malmbi wika raunaig. ");
INSERT INTO ssd_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Taŋanaig le Elai nu malmbi wika raunaig ta ismba kusnaŋga sakina: Nane ndaŋam tuku taŋade ŋgina. Taŋaka minna le taŋgo ta pinderka kumba Elai tugum promba wam kubeu tuna. ");
INSERT INTO ssd_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","Elai buk yar 98 tumba saibo pile mayemba am tukulkina. ");
INSERT INTO ssd_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Kile taŋgo taŋge nu sana: Ye kile ndo kame ma kusremba kua ka te prowet ŋgina le Elaiŋge nu kusnana: Kiŋo, ame maŋau prowe likaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Taŋamba kusnana le taŋgo pasa tumba prona taŋge pasa lafumba sakina: Filistia mbalŋge sine tuku kame taŋgo suŋgomba bale farkaig le sine Israel mbal nane ram kua kagig. Ne tuku kiŋo armba Hofni le Pineas mata balenikaik sulumba Kuate tuku tukul bokis ta turmba taig ŋga Elai sana. ");
INSERT INTO ssd_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Elai nu saibo butuknu tukunu taŋgo ta nu Kuate tuku tukul bokis tinaig ta tuku sakina le nu ŋgumnem-ŋgumnem nuŋe minyo mbili mbolŋge fonde malaŋga tugum taŋge ndeka nduku ŋgurmba kumna. Nu Israel mbal kulatka minna ta yarnu 40. ");
INSERT INTO ssd_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Pineas piyo nuŋe ta nu fuŋgulok minmba kiŋo te-palmbim tuku ait buk patukina le nu Filistia mbalŋge Kuate tuku tukul bokis tumba rugan nuŋe le taŋgo nuŋe kumnaik pasa ta ismba nu pirerek purka kiŋo te-pilna. ");
INSERT INTO ssd_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Taŋamba nu ŋgaro rar suŋgo tumba kumam bafuna le nu kulatkinaig pino kame taŋge nu sanaig: Ne kuru kuru ndaka. Ne buk kiŋo te-palet ŋginaig ta nu pasa ande lafu ndamba ise ndo ka ");
INSERT INTO ssd_vpl VALUES ("S14_21","010_4_21","1SA","4","21","22","nu kiŋo ta nyunu Ikabod ŋgina sulumba sakina: Sine Israel mbal kile nyu kugatok ŋgina. Ta ndaŋam? Nane tukul bokis yaika tumba rugan nuŋe le taŋgo nuŋe kumnaik ta tuku nu idusmba pasa ta taŋamba sakina. ");
INSERT INTO ssd_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Filistia mbalŋge Kuate tuku tukul bokis ta tumba Eben-Eser tumbraŋ kusremba kuramba tumba naŋgine tumbraŋ suŋgo Asdod kinaig ka ");
INSERT INTO ssd_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","taŋge tukul bokis ta tumba naŋgine mbara Dagon tuku zugu wandekŋge Dagon kanunu tugum taŋge pilnaig le minna. ");
INSERT INTO ssd_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Mafena le maratukuk tiŋga Asdod mbal nane aboŋginaig sulumba zugu wandek ta kumba mambilnaig kande naŋgine mbara Dagon kanunu ta Suŋgo tuku tukul bokis ta tugum ibeŋ kilke mbol taŋge ndeka truk ka minna le kaŋgernaig sulumba tumba nuŋe ma mbolŋge te-timba pilnaig le ka furirna le nane kinynaig. ");
INSERT INTO ssd_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Kinymba mafena le maratukuk tiŋga maŋ wandek kumba mambilnaig kande naŋgine mbara Dagon kanunu ta Suŋgo tuku tukul bokis ta tugumŋge maŋ ndeka truk ka minna le kaŋgernaig. Ŋgarosunu ndo maye minna ta gabatnu wainu arŋeŋ ŋgurka ibeŋ malaŋga tugum taŋge bagarok minnaig le kaŋgerkinaig. ");
INSERT INTO ssd_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Wam ta mbolŋge kile Dagon tuku pris kame taŋgo kame mata nane zugu wandek ta kambim bafumba ta nane Dagon kanunu bagarok minna magot ta lukamba sinam kinig. ");
INSERT INTO ssd_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Kile Suŋgoŋge Asdod mbal tumbraŋ afu Asdod patukŋge minnaig ta ŋaigo siglika piti suŋgokanu niŋgina le kamka ŋaigonu nane tuku ŋgarosu mbolŋge prowe likinaig. ");
INSERT INTO ssd_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Taŋanaig le Asdod mbal maŋau ta kaŋgermba nane ndek sakinaig: Israel mbal tuku Mbaraŋge sine tuku mbara Dagon sine turmba ŋaigo siglikate tukunu sine nane tuku tukul bokis te pilbe le tumbraŋ ande kuwa ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Taŋakinaig sulumba nane Filistia tuku gabat kame ta maŋgurkuwaig ŋga pasa patike likinaig le nane promba maŋgurkinaig. Maŋgurkinaig le Asdod mbalŋge kusnaniŋginaig: Sine kile Israel mbal tuku Mbara tuku tukul bokis ta tumba ndaŋamŋgig ŋginaig le nane pasa lafumba saniŋginaig: Tumba kuramba Gat tumbraŋ kape ŋginaig le nane Kuate tuku tukul bokis ta tumba kinaig ka Gat tumbraŋŋge pilnaig le minna. ");
INSERT INTO ssd_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Taŋanaig le Suŋgoŋge tumbraŋ ta tuku taŋgo pino kutu kame ŋakmba ŋaigo siglikina le kamka ŋaigonu nane tuku ŋgarosu mbolŋge prowe likinaig le nane kuru kuru suŋgo tumba wamdus fulilke likinaig. ");
INSERT INTO ssd_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Taŋanaig le nane Kuate tuku tukul bokis ta pilnaig le Ekron tumbraŋ kina. Kina ka ta prona le nane Ekron taŋgo pino gagniŋgina le suŋgomba wika raumba sakinaig: Nane sine ŋakmba bale farkam saka Israel mbal tuku Mbara tuku tukul bokis ta tumba te prowaig ŋginaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","nane Filistia gabat kame ta maŋ kile-maŋgurka saniŋginaig: Israel mbal tuku Mbara tuku tukul bokis te siŋgine kutu kame sine turmba bale farkikat tukunu palpe le luka nuŋe minna tuku ma ta mbol kuwa ŋga saniŋginaig. Ta ndaŋam? Kuateŋge nane ŋaigo siglikina le nane suŋgomba kume likinaig. ");
INSERT INTO ssd_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Afu kume ndakinaig ta kamka nane tuku ŋgarosu mbolŋge prowe likinaig le nane ŋgaro rar tormba malmbi wika raumba minnaig. ");
INSERT INTO ssd_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Suŋgo tuku tukul bokis ta Filistia mbal tugumŋge minna le ma ma tambun 7 kuganaig le ");
INSERT INTO ssd_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","kile Filistia gabat kameŋge nane pris kame kagmai taŋgo kame kile-maŋgurka kusnaniŋginaig: Sine Suŋgo tuku tukul bokis te tumba ndaŋndaŋmba kamŋgig? Sine ndaŋndaŋmba tumba ka nuŋe ma mbolŋge palmbimŋgig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","nane lafumba sakinaig: Tane Israel mbal tuku Mbara tuku tukul bokis ta ake sinaŋ palpe le kine ndakuwa. Tane mbar maŋau kinaig ta tuku atrau agaŋ afu turmba patikap le kuwaig le naŋgine Mbara taŋge tane tuku guaze pitaikuwa le nu ndaŋam tuku tane piti tiŋgit ta tugunu katesewamŋgaig ŋga saniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Taŋakinaig le gabat kameŋge maŋ lato kusnaniŋginaig: Sine nu garewa ŋga ame agaŋ patikube ŋginaig le nane lafumba saniŋginaig: Sine Filistia tuku gabat sugo 5 ta taŋgo pino turmba guaze ndui taŋge ŋaigo siglikate tukunu nane nduik nduik ta madiniŋmba golmbi kamka kanunu 5 wakeikap sulumba sib sine tuku ma ŋaigo siglikade ta tuku kanunu 5 wakeika ta turmba patikap le kuwaig. ");
INSERT INTO ssd_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Tane taŋamba Israel mbal tuku Mbara nyu te-duŋgap le nu tane, taŋgine mbara kame, taŋgine kilke turmba ŋaigo sigli ndakuwa. ");
INSERT INTO ssd_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Tane Isip mbal Farao ndoŋ wamdus kareŋ pilnaig taŋamba nda kap. Suŋgoŋge nane pilendo niŋmba piti yeki yeki niŋgina le nane Israel mbal pitaikinaig le kinaig wam ta tane ŋgilai ndaŋgap ŋginaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","saniŋginaig: Tane makau armba paŋgarnu fat ŋak piro nda niŋganu ta kilap sulumba karis ande kiteknu tumba makau arŋeŋ karis ta mbolŋge kusmba fatnu ta patikap le luka naŋgine fonde sinam kuwaig. ");
INSERT INTO ssd_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Taŋamba Suŋgo tuku tukul bokis ta tumba karis mbolŋge palpe sulumba taŋgine mbar maŋau kinaig ta tuku peuka agaŋ kame kanunu golmbi wakeikanu ta kilmba bokis fudiŋndo ande sinamŋge patika tukul bokis ta gemmba pilmba makau armba ta sisilaniŋgap le kuwaik. ");
INSERT INTO ssd_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","Makau armba ta kuwaik le kaŋgerndo ka minap. Nale tukul bokis ta karis ŋak didikumba ndin dubimba Bet-Semes tumbraŋ kuwaik ta sine katesewamŋgig Israel mbal tuku Mbara taŋge sine piti sersiŋgina ŋga idusamŋgig. Ko makau armba ta lukuwaik ta sine katesewamŋgig Mbara taŋge sine piti ser ndasiŋgina. Piti te ake sine mbolŋge prona ŋga idusamŋgig ŋga gabat kame ta saniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Kile taŋgo kame ta taŋamba kuanekinaig sulumba makau paŋgarnu armba fat ŋak ta kilmba karis mbolŋge kusmba fatnu ta kilmba luka fonde sinamŋge patikinaig. ");
INSERT INTO ssd_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Taŋanaig sulumba Suŋgo tuku tukul bokis ta tumba sib le kamka kanunu golmbi wakeikinaig bokis ŋak ta turmba tumba karis mbolŋge patikinaig le ");
INSERT INTO ssd_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","makau armba ta pitik ndo ndin suŋgo Bet-Semes tumbraŋ kina ta dubimba witimba witimba kinaik. Kinaik ta nale mbilmbil ndaka kine ndo kinaik le Filistia tuku gabat sugo 5 ta nale ŋgumnem dubika kinaig ka Bet-Semes tuku kilke ta mbol pronaig. ");
INSERT INTO ssd_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Nane Bet-Semes mbal ma gutoŋ taŋge wit magekinaig le kugerka minmba tandeka mambilnaig kande tukul bokis ta prona le kaŋgermba nane gare-garekinaig. ");
INSERT INTO ssd_vpl VALUES ("S16_14","010_6_14","1SA","6","14","15","Karis ta ka Bet-Semesnu taŋgo Yosua tuku piro sinam ta promba makau armba ta kinaik ka ndame suŋgo ande tugumŋge tiŋginaik. Tiŋginaik le nane Levi tuku kuasmbiŋge Suŋgo tuku tukul bokis ta tumba agaŋ kame kanunu golmbi wakeika sigrikinaig bokis ŋak ta turmba kilmba ndame suŋgo mbol taŋge patikinaig le Bet-Semes mbal taŋge karis mbainnu ta panu ŋga sambrimba kat fetfetnaig sulumba makau armba ta balenikmba Suŋgo atrauka pambi pasokinaig le uge suglukinaik. Ki ait ta mbolŋge nane atrau ta kumba agaŋmor afu turmba baleniŋmba Suŋgo atrauka pasokinaig le uge suglukinaig. ");
INSERT INTO ssd_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Nane wam ta kinaig le nane Filistia gabat sugo 5 ta kaŋgernaig sulumba ki ait ndui ta mbolŋge nane luka naŋgine tumbraŋ Ekron kinaig. ");
INSERT INTO ssd_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Nane Filistia mbalŋge naŋgine mbar maŋau kinaig ta tuku piti peuka kiga agaŋ kamka kanunu golmbi wakeikinaig ta ande Asdod tuku ande Gasa tuku ande Askelon tuku ande Gat tuku ande Ekron tuku. ");
INSERT INTO ssd_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Taŋamba ndo Filistia gabat sugo 5 ta tumbraŋ sugokanu fondembi korniŋganu tumbraŋ foŋfoŋ afu turmba kulatkinaig ta kumumba sib kanunu mata nduik nduik kidemba patikinaig. Bet-Semesnu taŋgo Yosua tuku piro sinamŋge ndame suŋgo ta mbolŋge Suŋgo tuku tukul bokis pilnaig ta idusam tuku ndame ta kile minit. ");
INSERT INTO ssd_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Kile Bet-Semes taŋgo afu nane Suŋgo tuku tukul bokis ta talka sinanu kaŋgernaig tukunu Suŋgo nane tuku taŋgo 70 bale farkina le taŋgo pino nane Suŋgoŋge nane ŋgamukŋge piti taŋamba kina ta tuku wamdus tatruka malmbikinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","naŋgine naŋgine sakinaig: Mbara Suŋgo te nu purfeŋnu ndo. Ande nu kumammba mbarwa ta nu mapewe nda tukunu sine tukul bokis te pilbe le ani kaŋgat ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Taŋamba nane taŋgo afu kukulniŋginaig le ka Kiryat-Yarim mbal saniŋginaig: Filistia mbalŋge Suŋgo tuku tukul bokis ta pilnaig le sine tugum teŋge minit. Tane ndeka tumba mbumba kape ŋga saniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Taŋakinaig le Kiryat-Yarimnu taŋgo kame promba Suŋgo tuku tukul bokis ta suku silimba waimbi tumba kinaig ka Abinadab tuku wande biŋ mbolŋge minna ta mbolŋge pilnaig. Pilnaig sulumba nu tuku kiŋo nuŋe Elasarŋge tukul bokis ta kulatkuwa ŋga madinaig. ");
INSERT INTO ssd_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Tukul bokis ta Kiryat-Yarim tumbraŋŋge minna le ma ma yar 20 kinaig. Ait ta mbolŋge Israel mbal nane sinamanzerka minmba Suŋgoŋge turka sinzaŋniŋguwa ŋga wika yabaŋmba minnaig. ");
INSERT INTO ssd_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Taŋamba minnaig le Samuelŋge ndek Israel mbal ŋakmba saniŋgina: Tane ŋgamuŋgal biye mbilmba Suŋgo ndo dubiwam idusmba kande tane mbara kise kise ŋakmba ŋgumneniŋmba Astarte ŋgade pino kanunu ta turmba kusrewap sulumba tane Suŋgo ndoŋ ulendika nu tuku miŋge kumnemŋge ndo minap. Taŋawap le nuŋge tane turtiŋmba sinzaŋtiŋguwa le Filistia mbal tuku saŋgri kile-ibeŋkamŋgaig ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Taŋakina le Israel mbal naŋgine yabri mbara kusrekinaig sulumba yabri mbara Baal le Astarte tuku kanunu ta pitaika Suŋgo tuku miŋge kumnemŋge ndo minnaig. ");
INSERT INTO ssd_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Taŋanaig le Samuelŋge Israel mbal ŋakmba tuku pasa pilmba sakina: Tane ŋakmba pro Mispaŋge maŋgurkap le yeŋge tane tuku ŋga Suŋgo yabaŋamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Taŋamba saniŋgina le nane ŋakmba promba Mispaŋge maŋgurkinaig sulumba nane kule burok sinam taŋge kule kunymba Suŋgo atraukam tuku kutunaig. Taŋamba nane sakinaig: Sine Suŋgo am mbolŋge unekigeŋ ŋga saka nyamagaŋ pinka minnaig le ki ka butuŋgina. Taŋamba Samuel nu Mispaŋge nane tuku piti ismba pasa afu kile-tidiŋgina. ");
INSERT INTO ssd_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Israel mbal Mispaŋge maŋgurkinaig ta Filistia mbal nane isnaig sulumba gabat sugo afu naŋgine kame kuasmbi ndoŋ kame ilnaig. Kame ilnaig le Israel mbal nane pasa ta ismba kuru-kurukinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Samuel sanaig: Ne siŋgine Mbara Kuate Suŋgo yabaŋa le nuŋge sine sinzaŋsiŋguwa le sine Filistia mbalŋge ŋaigo siglike nda ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Taŋakinaig le Samuel ndek sipsip fatnu ande tumba balemba Suŋgo tuku atrauka ŋak piyna le ugna. Ugna le Suŋgoŋge Israel mbal turniŋguwa ŋga yabaŋna le Suŋgo nu isna. ");
INSERT INTO ssd_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Samuel nu atrauka minna le Filistia mbal buk nane ndoŋ kame buwam tuku ilmba patuniŋginaig. Patuniŋginaig le Suŋgoŋge pitik ndo kuaila pilna le samba mbolŋge nane tugum taŋge suŋgomba puluka nane tuku wamdus ŋginŋgan serniŋgina le nane kuru kuru mayemba kua ka sili-silinaig. ");
INSERT INTO ssd_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Taŋanaig le Israel mbalŋge Mispa kusremba Filistia mbal kile-dubiŋga bale farka kinaig ka ka Bet-Kar tumbraŋ pronaig. ");
INSERT INTO ssd_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Kile Samuelŋge ndame suŋgo ande tumba Mispa tumbraŋ Sen tumbraŋ ŋgamu-ŋgamuŋge te-tina sulumba sakina: Suŋgoŋge sine tur mayekat ŋgina. Taŋakina sulumba ndame ta nyunu Eben-Eser ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Samuel tuku ait mbolŋge Suŋgo nu Filistia mbal ŋaigo siglika peuniŋgina le nane maŋ Israel kilke mbol pro ndanaig. ");
INSERT INTO ssd_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Israel mbal tuku tumbraŋ afu buk Filistia mbalŋge kame bumba yaike likinaig ta Ekronŋge tugu pilmba ka Gatŋge tiŋgina ta kile Israel mbal maŋ naŋgine luka kilnaig. Taŋanaig sulumba tumbraŋ kame ta tuku kilke ta nane Israel mbalŋge Filistia mbal ndoŋ kame bumba ŋakmba luka yaika kilnaig. Taŋamba Israel mbal nane mine mayemba Kanan mbal ndoŋ mata ŋgan minnaig. ");
INSERT INTO ssd_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Samuel nu mara mindek Israel mbal kulatka minna sulumba ");
INSERT INTO ssd_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","nu yar mindek Betel Gilgal Mispa kumba tumbraŋ keŋmba ta kidemba lika taŋgo pino tuku piti gubra ismba kile-tidiŋganu. ");
INSERT INTO ssd_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Kile-tidiŋge deŋpurniŋmba nu luka nuŋe tumbraŋ Rama kambinu ka tumbraŋ taŋge mata nu pasa kile-tidiŋganu. Ramaŋge minna sulumba nu ndame turŋaŋga Suŋgo atraukam tuku pa laŋlaŋ ande wakeina. ");
INSERT INTO ssd_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Samuel nu saibo pilmba nuŋe kiŋo ar ta Israel mbal kulatkuwaik ŋga madinikina. ");
INSERT INTO ssd_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Kiŋo mulum ta nyunu Yoel. Mambo nuŋe nyunu Abia. Berseba tumbraŋŋge nale Israel mbal kulatka minnaik. ");
INSERT INTO ssd_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Kulatka minnaik ta nale mam nakile tuku wam ta dubi ndanaik. Nale ndametiŋ tuku ndo wamdus ŋak. Nale pasa tugusemba pileniŋmba kaŋger ndaka ande ndametiŋ nale nikuwa ta pasa mbolŋge te-ti ndawanu. ");
INSERT INTO ssd_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Kile Israel mbal tuku gabat sugo sugo ŋakmba maŋgurkam Samuel sota Rama kinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Samuel sanaig: Ne isa. Ne buk saibo pilit ta ne tuku kiŋo ar ta nale ne maŋau kina taŋamba ke ndakade. Ta tuku ne gabat suŋgo ande madiwa le sine kulatkuwa. Kilke afu minig taŋamba ŋga Samuel sanaig. ");
INSERT INTO ssd_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Nane gabat suŋgo madiwam tuku sakinaig ta Samuel nu pasa ta tuku gare ndana le nu Suŋgo yabaŋmba kusnana. ");
INSERT INTO ssd_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Kusnana le Suŋgo nu ndek sana: Taŋgo pino nane ame maŋau ne ndoŋ sakuwaig ndeta ne ismba dubiwe niŋga. Nane ne pitai ndanade. Kuga. Ye nane tuku Suŋgo mine ndaki ŋga nane ye pitaiyade. ");
INSERT INTO ssd_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Ye o buk nane Isipŋge kilmba te prowen ta nane ye ŋgumneyumba mbara afu tuku nyu kile-duŋge likinaig. Nane mara mindek ye mbolŋge kade ta kile ne mbolŋge mata kade. ");
INSERT INTO ssd_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Ta tuku ne nane tuku miŋge dubiwa sulumba riroŋ pasa saniŋmba gabat suŋgo nu ndaŋndaŋmba nane kulatkamŋgat ta bitekŋga saniŋga le iswaig ŋga Samuel sana. ");
INSERT INTO ssd_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Pasa ŋakmba Suŋgoŋge Samuel sana ta nu suk ka taŋgo pino gabat suŋgo madiwam sakinaig ta saniŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","sakina: Ye kile gabat suŋgo tuku piro maŋau tugu biteŋgi le tane isap. Gabat suŋgo ta nu teŋenmba kamŋgat. Nu tane tuku kiŋo afu kilwa le nu tuku kame mbal taŋaŋ minamŋgaig. Kame ait mbolŋge nane afu karis mbolŋge pinderkuwaig le afu hos mbolŋge pinderkamŋgaig. Nu tumbraŋ inum kambim bafuwa ta nu karis mbolŋge minyokuwa le nane afu nu mindemba pinderka amboŋga kaŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Nuŋge nane afu kame gabat minam tuku madiniŋgamŋgat. Afu kame taŋgo 1,000 kulatkuwaig le afu kame taŋgo 50 kulatkamŋgaig. Tane tuku kiŋo kame afu nu tuku piro mbolŋge kilke pikmba nyamagaŋ ŋgukuwaig le afu nyamagaŋ magekuwaig le kilamŋgaig. Afu nu tuku kame agaŋ ndende wakeikuwaig le afu karis tuku agaŋ ndende wakeikamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Tane tuku kulim kame afu nu tuku gureŋ agaŋ ndende mundur mayenu ŋak ta wakeikuwaig le afu nu tuku paguwaig le afu nu tuku bret pasokamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Nu tane tuku nyamagaŋ piro, grep piro magenu, olif piro magenu ta ŋakmba yaika kilmba nuŋe gabat sugo sugo niŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Niŋguwa sulumba tane tuku wit grep muli ta ŋakmba kilmba fetka 9 tane tuku kusreka ndindo nuŋe tumba nuŋe gabat kame piro taŋgo kame niŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Nu tane tuku piro taŋgo, piro pino, taŋgo mo afu kilmba agaŋmor doŋki magenu ta pileŋga kilwa le nu tuku piroka minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Taŋamba tane tuku sipsip ta kilmba fetka 9 kusreka ndindo nuŋe tamŋgat. Tane mata nu tuku piro taŋgo taŋaŋ minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Ait ta mbolŋge tane taŋgine gabat suŋgo taŋgine madinaig ta tuku ndumor-ndumorkap ta Suŋgo nu tane tuku malmbi ise nda ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Taŋamba saniŋgina kande nane Samuel tuku pasa isam mbulnaig sulumba sakinaig: Kuga. Ne sine tuku gabat suŋgo ande madiwe siŋga. ");
INSERT INTO ssd_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Taŋabe sulumba sine kilke tugu afu minig taŋamba minamŋgig. Siŋgine gabat suŋgoŋge pasa siŋmba kulatkuwa sulumba kame ait prowa le nu sine kulatka kilmba ŋgueu mbal ndoŋ kame buwamŋgat ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Samuel nu nane pasa ŋakmba sakinaig ta ismba ka Suŋgo sana le ");
INSERT INTO ssd_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Suŋgo ndek lafumba sana: Naŋgine nzali ta dubimba gabat suŋgo madiwe niŋga ŋgina. Taŋakina le Samuel ndek Israel taŋgo ŋakmba saniŋgina le sili-silimba luka naŋgine tumbraŋ tumbraŋ kine likinaig. ");
INSERT INTO ssd_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Kis nu maror taŋgo ande. Nu nyu suŋgo ŋak Benyamin ma tugu mbolŋge minna. Kis mam nuŋe Abiel. Wa nuŋe Seror. Mbuŋ mbuŋ nuŋe Bekorat. Sikar sikar nuŋe Afia. Tumbraŋ mboŋ naŋgine Benyamin. ");
INSERT INTO ssd_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kis tuku kiŋo nuŋe nyunu Saul. Saul nu saŋgrinu ŋgarosu tumail pasi maditaknu. Taŋgo ande nu suk Israel ŋgamukŋge mine ndakina. Israel ŋgamukŋge nuŋge ndo kuennu. ");
INSERT INTO ssd_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Nane minnaig le ait ande Kis tuku doŋki afu kua ka sili-silinaig le nu ndek Saul kukulmba sana: Ne piro taŋgo ande tumba tale kumba ka doŋki kame sotap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Taŋakina le nale tiŋga kinaik ka Efraim ma taknu kumam kumba wat tiŋga Salisa ma tugu mbol kinaik ta doŋki kile-sigli ndakinaik. Taŋamba nale maŋ tiŋga Salim ma tugu mbol kinaik ta mata doŋki kame taŋge mine ndakinaig le kile nale maŋ tiŋga Benyamin tuku ma tugu mbol kinaik ta mata kile-sigli ndakinaik. ");
INSERT INTO ssd_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Nale doŋki sota sota ka Suf ma tugu mbol pronaik sulumba Saulŋge piro taŋgo nuŋe sana: Sile luka kap. Sile ŋgisikupe ta mam nu doŋki tuku idus ndamba sile tuku wamdus piti tikat ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Taŋakina le piro taŋgo taŋge ndek Saul sana: Yauk. Tumbraŋ teŋge Kuate tuku piro taŋgo ande nyu suŋgo ŋak minit ta nu wam ŋgumneŋga prowam tuku sakate ta alonu prote. Sile ka nu kaŋgermba. Nuŋge doŋki ma ani taŋge minig ta sile sasikam kumuŋ inde ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Saul ndek lafumba piro taŋgo nuŋe sana: Sile ame agaŋ tumba nu sota kaŋgik? Bret sigrikikeŋ ta buk kugawaig tukunu sile ame agaŋ nu tambimŋgik? Sile agaŋ inum nu tambim tuku mine ndakate ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","piro taŋgo taŋge maŋ lato Saul sana: Ye silwa ndametiŋ fudiŋndo ŋak. Ye ndametiŋ ta nu tuwi le nu sile doŋki ma ani taŋge minig ta sasikamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S19_9","010_9_9","1SA","9","9","11","Taŋakina le Saulŋge nu sana: Sile kap. Ne tuku wamdus ta mayenu ŋgina sulumba nale Kuate tuku piro taŋgo minna tumbraŋ ta kinaik. Kinaik ka tumbraŋ ta tuku tabe ta poŋga kumba minmba pino mbanzo afu kule kunyam saka ndekinaig le kile-siglikinaik. Kile-siglikinaik sulumba nane kusnaniŋginaik: Kagmai taŋgo ta tumbraŋ ambeŋge minit e ŋginaik. (Ait ta mbolŋge Israel mbal nane tuan taŋgo kame nyu kilmba kagmai taŋgo ŋganu. Taŋgo ande nu agaŋ inum tuku Kuate kusnawam kambim bafumba ta nu sakanu: Sine kagmai taŋgo kaŋgeram kab ŋganu). ");
INSERT INTO ssd_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Kile pino kame taŋge pasa lafumba sanikinaik: Nu ambe minit. Nu kite tumbraŋ ambe prowat. Taŋgo pino nane biŋ mbol ambeŋge atraukamŋgaig tukunu tale pitik mbumba kape. ");
INSERT INTO ssd_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Nu isukusam biŋ mbol ambe kakat. Taŋgo pino nu tairŋga minig. Nuŋge atrau agaŋ kame ta nyaro niŋguwa le taŋgo pino wike likinaig ta pagumba nyamŋgaig. Ta tuku tale pitik mbumba kape ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Taŋakinaig le Saul piro taŋgo nuŋe ndoŋ mbumba kumba tumbraŋ ta tuku fonde malaŋga sinam kambim saka Samuel nu biŋ mbol ambe kambim bafumba kilim kina le te-silikinaik. ");
INSERT INTO ssd_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Suŋgoŋge buk Samuel kila sana: ");
INSERT INTO ssd_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","Indole ait teŋen mbolŋge ye Benyamin tuku tugu mbolŋge taŋgo ande kukuli le ne tugum te prowamŋgat. Nu prowa le ne gureŋ pisnewa le nuŋge yiŋe kuasmbi Israel kulatka Filistia mbal tuku wai mbolŋge kile-lukamŋgat. Filistia mbal ta nane ye tuku kuasmbi ŋgaro rar pileniŋmba piro kareŋnu niŋmba minig le ye nane tuku malmbi iset ŋga Samuel sana. ");
INSERT INTO ssd_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Kile Samuel nu Saul kaŋgerna le Suŋgo nu sana: Taŋgo kubele ye ne sanen ta noten. Nuŋge ye tuku kuasmbi kulatkamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Kile Saul nu fonde malaŋga sinam kumba Samuel kaŋgermba kusnana: Kagmai taŋgo tuku wande aniŋge minit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Samuelŋge lafumba sana: Kagmai taŋgo ta ye noten. Ne amboŋga atraukam tuku biŋ mbol ambe kumba mina. Ye ne ŋgumnem dubinumba mbet. Ŋgilaiŋge ye ne ndoŋ tuma isukusmba kinymba indole mafewa le ne pasa afu ŋak ta saka le sani le ismba kaye. ");
INSERT INTO ssd_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Ne ailfu doŋki kame ŋgisikinaig ta tuku wamdus piti ndanuwa. Nane afuŋge buk kile-siglikinaig. Ne ise tiwa. Israel mbal nane gabat suŋgo madiwam tuku nzali ta ne tuku mam naŋe tuku tugu mbolŋge minit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Taŋakina le Saulŋge Samuel sana: Ndaŋam ne taŋamba ye sayate? Ye Benyamin tuku tugu. Israel sinamŋge sine tuku tugu ta fudiŋndo. Mam tuku ndare mata Benyamin tuku tugu mbolŋge nyu kugatok ŋga Samuel sana. ");
INSERT INTO ssd_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Kile Samuelŋge Saul le piro taŋgo nuŋe kilmba wandek sinam kina sulumba taŋgo 30 buk promba minyok minnaig ta nane tumailamŋge kile-minyokina. ");
INSERT INTO ssd_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Taŋana sulumba Samuel nu pagu taŋgo ta sana: Ye ne agaŋmor ndemnu tinmba sanit le palet ta tumba prowa ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","pagu taŋgo ta nu agaŋmor wainu ndem mayenu ŋak ta tumba promba Saul tuna. Tuna le Samuel ndek nu sana: Ye taŋgo kame tuma isukusam tuku saniŋgen le naneŋge ne tuku ndem ande pilnaig le yeŋge tumba kulatka minet te kile tumba nya ŋgina. Taŋakina le Saul nu ait ta mbolŋge Samuel nane ndoŋ tuma isukusnaig. ");
INSERT INTO ssd_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Isukuse deŋpurmba nale atraukam tuku biŋ ta kusremba ndek tumbraŋ kinaik sulumba wande poŋga funu mbol taŋge minyoka pasatinaik. ");
INSERT INTO ssd_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Pasate deŋpurmba Saul nu wande funu mbol taŋge kinyna. Kinymba mafena le maratukuk tiŋga Samuel nu Saul wika sana: Tiŋga ndeka le ye ne mindenumba kumba ka ndinŋge mbilni le kaye ŋgina le Saul ndek tiŋga ibeŋkumba Samuel ndoŋ wande kusremba kilim ka Saul tuku piro taŋgo ta ndoŋ ndin dubimba kinaig. ");
INSERT INTO ssd_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Nane kinaig ka tumbraŋ makembi taŋge Samuel nu Saul sana: Piro taŋgo naŋe sawa le amboŋga kumba minwa le ye Kuateŋge pasa afu sayina ta ne sanamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Piro taŋgo ta nale kusreka kina le Samuel ndek olif kule botol ŋak ta tumba Saul tuku gabat mbolŋge kutumba Saul mumuna sulumba sana: Ne Suŋgoŋge nuŋe kuasmbi Israel mbal kulatkam tuku madinina. ");
INSERT INTO ssd_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Kile ne ye kusreyumba kaye ka Benyamin ma tugu Selsa tumbraŋŋge Rahel tuku kumunu tugum taŋge taŋgo armba kile-siglika le naleŋge ne teŋenmba sanamŋgaik: Doŋki kame ŋgisikinaig le ne sota likate ta buk kile-siglikinaig le mam naŋe kile doŋki tuku wamdus piti ndamba nu maŋ ne ŋgisikanu ŋga idusmba nu wamdus piti ŋak minit ŋga ne sanamŋgaik. ");
INSERT INTO ssd_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Nale taŋamba ne sanuwaik le ne nale kusreka maŋ kumba ka Tabor tumbraŋ tuku ail suŋgo tugum taŋge taŋgo keŋmba Suŋgo atraukam tuku Betel kambim bafuwaig le kile-siglikamŋgat. Nane tuku ande nu meme fat keŋmba kugrakuwa le ande nu bret keŋmba bagailniŋguwa le ande nu grep kule botol ŋak kurawamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Nane keŋ taŋge ne kaiye ŋga sanumba bret armba tinwaig le ne yaika kila. ");
INSERT INTO ssd_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Taŋamba ne maŋ kumba ka Filistia kame mbalŋge baibai patike likinaig ma ta promba Kuate atraukanu tumbraŋ Gibea tuku fonde malaŋga sinam kumba tuan taŋgo kuasmbi ande Suŋgo tuku tabe mbol ndekuwaig le kile-siglikamŋgat. Taŋgo afu nane tuan taŋgo kuasmbi ta mindeka gita yeki yeki katniŋmba kem fitke lika tambariŋ katniŋguwaig le tuan taŋgo kuasmbi ta Suŋgo tuku Guwaŋge wamdus niŋguwa le pasa yeki yeki kukliwamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Taŋawaig le Suŋgo tuku Guwa ne mbol kuwa le ne mata nane ndoŋ ulendika pasa yeki yeki kukliwamŋgat. Taŋawa sulumba ne kisemba kiteknu mayok kaŋgat. ");
INSERT INTO ssd_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Ye ne sanet pasa kame te tuku alonu prowe likuwaig ta Suŋgoŋge ne ndoŋ minwa le ne nu tuku miŋge dubimba ke ndo ka ŋga Saul sana sulumba ");
INSERT INTO ssd_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","nu maŋ sana: Kile ne amboŋga Gilgal kaye le ye ne dubinumba ta promba agaŋmor afu kilmba bale farka pasoka ŋgamuŋgal ulendiwam tuku agaŋmor turmba atraukamŋgit. Ne ka Gilgalŋge ye tairŋga mina le kusem ndindo kuwa le ye ta prowi sulumba ne ame wam kam tuku ta ne sanamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Taŋakina le Saul nu pasa ta ismba nu mbilka Samuel kusremba kambim bafuna le Kuateŋge nu taŋgo kitek te-mayokna. Taŋana le nu kina le ki ait ndui ta mbolŋge ndo Samuelŋge nu maŋau ŋakmba tuku sana ta taŋamba prowe likinaig. ");
INSERT INTO ssd_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Nale Gibea pronaik le tuan taŋgo kuasmbi ande Saul te-silikinaig le Kuate tuku Guwa nu mbol kina le nu nane ndoŋ ulendika pasa yeki yeki sake likinaig. ");
INSERT INTO ssd_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Taŋanaig le nane afu nu kila ta nane wam ta kaŋgermba naŋgine naŋgine sakinaig: i ... Kis tuku kiŋo nuŋe si ame maŋau kate ya? Nu mata tuan taŋgo ande e ŋga saka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Taŋamba saka minnaig le tumbraŋ ta tuku taŋgo andeŋge ndek sakina: Nane tuku mam kat naŋgine ima? Nane mata tuan taŋgo kuga ŋgina. (Ta tuku Israel mbal nane kile yaba pasa ande teŋenmba sakade: Saul nu mata tuan taŋgo ande e ŋgade). ");
INSERT INTO ssd_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Saul nu tuan taŋgo kame ndoŋ maŋau ta ke deŋpurna sulumba nu atraukanu tabe mbol ambe kina le ");
INSERT INTO ssd_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","bab nuŋeŋge Saul piro taŋgo nuŋe ndoŋ kusnanikina: Tale animbi kinaik ma ma maŋ te prode ŋgina le Saulŋge lafumba sana: Sile doŋki ŋgisikinaig ta sota ma ma kuga le sile Samuel kaŋgeram kakeŋ ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Taŋakina le bab nuŋeŋge ndek kusnana: Nu tale ndaŋmba satikina ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Saul ndek lafumba bab nuŋe sana: Nu teŋenmba sile sasikina. Naneŋge doŋki ŋgisikinaig ta buk kile-siglikinaig ŋgina ŋga bab nuŋe sana. Taŋamba sana sulumba nu Samuelŋge gabat suŋgo prowam tuku madina ta yabuka bab nuŋe sa ndana. ");
INSERT INTO ssd_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Kile Samuel nu Israel ŋakmba wikina le Mispa tumbraŋŋge Suŋgo am mbolŋge maŋgurkinaig. ");
INSERT INTO ssd_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Maŋgurkinaig le Samuel nu nane saniŋgina: Sine Israel mbal tuku Mbara Kuate Suŋgoŋge teŋenmba tane tuku sakate. Yeŋge taŋgine mbuŋ kat taŋgine Isip mbal tuku wai mbolŋge kile-luka kilmba ilen. Nane ŋgueu mbalŋge ŋaigo siglika minnaig le yeŋge nane tuku muskil kile-tidiŋgen. ");
INSERT INTO ssd_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Ye tane tuku Mbara. Tane piro kareŋka piti suŋgomba kaŋgerka minnaig le yeŋge tane tuku muskil kile-tidiŋge tiŋgen ta kile tane ye pitaiyumba maŋ taŋgine gabat suŋgo ande madiwam tuku sakade. Ta tuku tane ye tuku am mbolŋge taŋgine tugu mbol kumba ka tumbraŋ mboŋ nduik nduik sinamŋge tiŋgap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Nane taŋamba tiŋginaig le Samuel nu ndek tugu nduik nduik tuku taŋgo wike likina le nu tuku tumailamŋge tiŋginaig. Tiŋginaig le Suŋgoŋge Benyamin tuku tugu ta madina. ");
INSERT INTO ssd_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Madina le Samuel ndek Benyamin tuku tugu sinamŋge kuasmbi nduik nduik wikina le nu tuku tumailamŋge tiŋginaig. Tiŋginaig le Suŋgoŋge Matri tuku kuasmbi madina. Matri tuku kuasmbi ta Samuel tuku tumailamŋge tiŋginaig le Suŋgoŋge Kis tuku kiŋo nuŋe Saul madina. Madina le nane ndek nu sota ma ma nda te-silikinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Suŋgo kusnanaig: Taŋgo ta prowat e ko kuga ŋginaig le nu ndek lafumba saniŋgina: Saul nu tane tuku agaŋ ndende patikaig ta ŋgamuk siŋge kuirka minit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Taŋaka saniŋgina le nane pinderka ka Saul te-silika nu tumba luka pronaig le taŋgo kame ŋakmba ndoŋ tiŋgina ta nane ŋgamukŋge nuŋge ndo kuennu. ");
INSERT INTO ssd_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Kile Samuel nu Israel mbal ŋakmba saniŋgina: Suŋgoŋge taŋgo madina ta noten. Sine ŋgamukŋge ande nu suk mine ndakate ŋgina le Israel mbal ŋakmba wika raumba sakinaig: Ese. Sine tuku gabat suŋgo teŋge sine kulatka minamŋgat ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Taŋakinaig le Samuelŋge taŋgo pino ame maŋau gabat suŋgo mbolŋge kam tuku ko gabat suŋgo tuku piro yeki yeki ta ŋakmba te-kilimba kuklimba saniŋgina sulumba nu waŋe ande tumba pasa ŋakmba ta kuyarniŋmba tumba Suŋgo tuku am mbolŋge tukul ma ta mbolŋge pilna. Pilna sulumba kile taŋgo pino ŋakmba kukulniŋgina le sili-silimba luka naŋgine tumbraŋ tumbraŋ kine likinaig. ");
INSERT INTO ssd_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Taŋanaig le Saul mata luka nuŋe tumbraŋ Gibea kina le Kuateŋge kame taŋgo saŋgriknu afu wamdus niŋgina ta nane Saul midemba kinaig. ");
INSERT INTO ssd_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Taŋanaig le taŋgo ŋaigonu afu nane Saul talamba sakinaig: Taŋgo taŋaŋ ta sine tursiŋgam kumuŋ kuga ya ŋginaig sulumba nane Saul gare agaŋ mayenu inum tuwe ndakinaig. Taŋanaig le Saul nu taŋaig ŋga ta tuku idus ndana. ");
INSERT INTO ssd_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Taŋamba minnaig ma ma mara ande Amon mbal tuku kame gabat Nahas nu nuŋe kame kuasmbi kilmba promba Gilead ma tugu mbolŋge Yabes tumbraŋ kormba kame tuku kuaneka tumbraŋ ulnaig. Tumbraŋ ulnaig le Yabes mbalŋge ndek Nahas sanaig: Ne sine ndoŋ pasa katmba sine mapeka le minbe ta sine ne gabat suŋgo madinamŋgig ŋginaig kande ");
INSERT INTO ssd_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Nahas nu nane saniŋgina: Ye tane ndoŋ ake pasa kate nda. Ye tane Israel mbal tuku nyu kile-ibeŋka tane ŋakmba tuku am ndinam ta goniŋgi sulumba tane ndoŋ pasa katamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Taŋakina le Yabes gabat taŋgo kameŋge Nahas sanaig: Tane sine kusem ndindo tairŋgap le sine taŋgo afu kukulniŋbe le ka Israel ma tugu ŋakmba mbolŋge sine tursiŋgam tuku taŋgo kile-siglika kilmba prowaig. Kuga ndeta sine tane kumnemŋge minbe le ne ame maŋau kam tuku idusmba sakate ta ne ka ŋga Nahas sanaig le Nahas nu wokina. ");
INSERT INTO ssd_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Wokina le nane taŋgo afu kukulniŋginaig le ka Saul tuku tumbraŋ Gibea pronaig sulumba pasa ta te-mayokmba taŋgo pino ŋakmba kila saniŋginaig le nane pasa ta ismba sinanu malmbi wika raunaig. ");
INSERT INTO ssd_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Wika raunaig le Saul nu piro mbolŋge zigna ta ismba nuŋe makau kulatka minna ta kusreka prona sulumba kusnaŋgina: Nane si ame wam tuku malmbikade e ŋgina le nane ndek Yabes mbal tuku pasa ta nu kubeu tunaig le ");
INSERT INTO ssd_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Saul nu isna le Kuate tuku Guwa nu mbol prona le nu gubra kagli firka ");
INSERT INTO ssd_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","makau pailnu armba kilmba balenikmba kat pur pur foŋfoŋmba taŋgo kame afu madiniŋmba kile-niŋmba kukulniŋgina le kugraka Israel ma tugu ŋakmba mbol kumba taŋgo pino ŋakmba tumniŋmba teŋenmba riroŋ pasa saniŋginaig: Taŋgo ima nu Saul le Samuel dubika kame kine ndakuwa ta sineŋge taŋgo ta tuku makau ŋakmba mbolŋge teŋenmba kamŋgig ŋginaig. Taŋakinaig le Suŋgoŋge taŋgo kame ta kuru kuru serniŋgina le nane ŋakmba tiŋga maŋgur ma mbol prowe likinaig. ");
INSERT INTO ssd_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Taŋanaig le Saulŋge nane ŋakmba Besek tumbraŋŋge kile-maŋgurka burkina ta Israel taŋgo 300,000 Yuda taŋgo 30,000. ");
INSERT INTO ssd_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Kile nane pasa tumba pronaig mbal ta saniŋginaig: Tane luka kape sulumba Yabes taŋgo kame teŋenmba saniŋgap. Indole ki mbol ka pa pakuwa ait ta mbolŋge sine promba ŋgueu mbal pitaika tane luka kilamŋgig ŋginaig. Taŋakinaig le taŋgo kame ta luka Yabes kinaig sulumba nane kila saniŋginaig le nane ndek gare-garekinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Nahas sanaig: Indole sine kilim kab le ne naŋe kuasmbi ndoŋ sine mbolŋge ame maŋau kam idusmba kande tane kap ŋga Nahas sanaig. ");
INSERT INTO ssd_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Taŋamba nane kinymba mafe ndamba minna le Saul nu taŋgo fet keŋna sulumba ma tugu rammba minna le nane pinder-pindermba Amon mbal tuku kame tumbraŋ ta kinaig sulumba nane bale farka minnaig le ma ma ki promba saŋgri tiŋgina. Taŋgo ndui ndui kusrekinaig ta nane kua ka sili-silinaig. ");
INSERT INTO ssd_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Kile Israel mbalŋge ndek Samuel sanaig: Taŋgo kame buk Saul talamba sine tuku gabat suŋgo mine ndakuwa ŋginaig ta kilmba prowa le sine bale farniŋbe ŋginaig kande ");
INSERT INTO ssd_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Saul nu ndek saniŋgina: Kuga. Kite Suŋgo nu sine Israel mbal ŋgueu mbal tuku wai mbolŋge kile-luka kilat tukunu sine kite taŋgo ande balewe nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Taŋakina le Samuel ndek taŋgo pino ŋakmba saniŋgina: Sine Gilgal kab sulumba Saul maŋ lato gabat suŋgo prowam tuku madibe ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","nane ŋakmba tiŋga Gilgal tumbraŋ kinaig ka taŋge Suŋgo am mbolŋge Saul maŋ lato gabat suŋgo tuku madinaig sulumba Suŋgo ndoŋ ŋgamuŋgal ulendiwam tuku atraukinaig. Taŋamba Saul nu Israel ŋakmba ndoŋ tumamba gare-gare suŋgokinaig. ");
INSERT INTO ssd_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Kile Samuel ndek Israel mbal ŋakmba saniŋgina: Tane ise tiwap. Tane buk wam ŋakmba tuku ye sayinaig ta kumumba ken sulumba tane kulatkam tuku gabat suŋgo ande madiwe tiŋgen ta ");
INSERT INTO ssd_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","nu tane tuku kulat taŋgo minamŋgat. Ye buk mbanzonu minmba tane kulatka minen ta kile ye gife ŋakmba saibo pilet. Yiŋe kiŋo kame tane ŋgamukŋge minig. ");
INSERT INTO ssd_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Ye wam ande mbaren ndeta tane kile Suŋgo am mbolŋge gabat suŋgo nuŋe madina te nale am mbolŋge ye sayap. Ye taŋgo ande tuku makau ko doŋki ake yaiwen e? Ko ye taŋgo ande yabri-yabrimba agaŋ inum yaimba ten e? Ko ye taŋgo ande ŋayo siliwen e? Ko ye taŋgo andeŋge kigayena le nu tumba pasa mbolŋge te-ti ndawen e? Ye wam ande taŋamba ken ndeta ye wam ta lafumba te-tiwamŋgit ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Taŋaka saniŋgina le taŋgo pinoŋge ndek lafumba sanaig: Kuga. Ne sine tuku ande yabrimba agaŋ inum ake yai ndana. Ne taŋgo ande ŋayo sili ndana. Ne taŋgo ande yabrimba ndametiŋ ake te ndakina ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Samuelŋge nane saniŋgina: Tane ye tuku mbar ande kaŋger ndawanu ŋgade ta kile Suŋgo nuŋe gabat suŋgo madina te nale tane tuku pasa isaik ŋgina le nane lafumba sakinaig: Ta son. Suŋgo nu sine tuku pasa isat ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Kile Samuel maŋ pasa lato saniŋgina: O buk Suŋgoŋge Moses le Aron madinikmba mbuŋ kat taŋgine Isip kilke mbolŋge kilmba te prona. ");
INSERT INTO ssd_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Ta tuku kile tane Suŋgo am mbolŋge tiŋgap le ye tane pasa mbolŋge patiki sulumba Suŋgoŋge wam magenu tane mbolŋge taŋgine mbuŋ kame mbolŋge ke likina ta te-mayokmba satiŋgi le isap. ");
INSERT INTO ssd_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","O buk Yakob nuŋe gageu kame ndoŋ Isip kilke mbolŋge minnaig ma ma nuŋe ndare kame Suŋgoŋge nane turkuwa ŋga sarsarmba minnaig le Suŋgoŋge Moses le Aron kukulnikina le Isipŋge mbuŋ kat taŋgine kilmba promba kilke te mbol pronaig. ");
INSERT INTO ssd_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Taŋamba nane naŋgine Mbara Suŋgo ŋgumnewanu le nuŋge nane kilmba Hasornu kame gabat suŋgo Sisera, Filistia mbal, Moabnu gabat suŋgo nane tuku wai mbolŋge patikanu le nane ndoŋ kame bumba nane bale faranu. ");
INSERT INTO ssd_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Taŋawanu le nane Suŋgoŋge turkuwa ŋga yabaŋmba sakanu: O Suŋgo, sine unekigeŋ sulumba ne ŋgumnenumba Baal le Astarte kanunu mbariŋniŋgigeŋ ta kile ne sine ŋgueu mbal tuku wai mbolŋge kile-luka kila le sine ne mbariŋnumba ne tuku miŋge kumnemŋge minamŋgig ŋganu le ");
INSERT INTO ssd_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Suŋgo nu nane tuku wi ta ismba Yerubaal Barak Yefta Samuel nane nduik nduik ka kukulniŋganu le promba ŋgueu mbal tuku wai mbolŋge kile-luka kilanu tukunu tane Israel mbal mine mayenaig. ");
INSERT INTO ssd_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","Taŋamba minnaig le Amon mbal tuku gabat suŋgo Nahas kame tuku prona le tane taŋgine Mbara Suŋgoŋge tane kulat ndakuwa ŋga teŋenmba ye sayinaig. Ne sine tuku gabat suŋgo ande madiwe siŋga ŋga sayinaig. ");
INSERT INTO ssd_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Tane gabat suŋgo tam tuku wamdus suŋgo ŋak minnaig le Suŋgoŋge tane tuku madiwe tiŋgina ta minit noten. ");
INSERT INTO ssd_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Tane Suŋgo tuku miŋge kumnem kape sulumba nu mbariŋmba nu tuku pasa ismba kumu-kumuwap sulumba tane taŋgine gabat suŋgo ndoŋ taŋgine Mbara Suŋgo ndo dubimba minap. ");
INSERT INTO ssd_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Tane Suŋgo tuku pasa isam mbulmba nu tuku miŋge ŋgurap ta Suŋgo nu buk mbuŋ kat taŋgine piti niŋgina taŋamba ndo tiŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","Kile tane tiŋga minap le Suŋgoŋge maŋau ande kuwa le tane kaŋgerap. ");
INSERT INTO ssd_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Kile ki mara ma kareŋganu ait ta ye kile Suŋgo yabaŋi le nuŋge gau pilwa le kuaila puluka sawe piyamŋgat. Taŋawa le tane wam ta kaŋgermba taŋgine mbarkinaig sulumba gabat suŋgo ande madiwe tiŋguwa ŋga Suŋgo kusnanaig ta tane katesewamŋgaig ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Taŋakina sulumba Samuel nu Suŋgo wika yabaŋna le ait ndui ta mbolŋge Suŋgoŋge kuaila pilna le ma fuduka sawe piyna le nane wam ta kaŋgermba Suŋgo le Samuel tuku kuru-kuruka ");
INSERT INTO ssd_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","taŋgo pino ŋakmba Samuel sanaig: O taŋgo suŋgo, neŋge naŋe Mbara Suŋgo sawa le sine mapekuwa le kume ndakube. Sine une maŋau suŋgomba kigeŋ ta kile sine maŋ lato mbarmba gabat suŋgo ande tam tuku sakigeŋ ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Taŋakinaig le Samuel nu lafumba saniŋgina: Tane kuru kuru ndakap. Tane siŋka maŋau ŋaigonu ke likinaig ta kile tane Suŋgo kumnemŋge minmba nu ndo dubimba nu tuku piro ndo kap sulumba ");
INSERT INTO ssd_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","yabri mbara kame dubi ndakap. Naneŋge tane turke nda. Nane ake agaŋ ndo. ");
INSERT INTO ssd_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Suŋgo nuŋe miroŋ tane nuŋe kuasmbi ŋga maditiŋgina tukunu nu nuŋe nyu suŋgokuwa ŋga idusmba nu tane pitaike nda. ");
INSERT INTO ssd_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Yeŋge mara mindek tane tuku ŋga Suŋgo yabaŋmba minet. Ye siŋka maŋau ta kusrewe nda. Ye kusrewi ta ye Suŋgo am mbolŋge unekamŋgit. Ye tane maŋau mayenu tiŋreknu dubiwam tuku wam pagutiŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Tane Suŋgo tuku miŋge kumnem kape sulumba wamdus ndindo tumba nu tuku ndo piroka minap. Suŋgoŋge tane turkam tuku wam ke likina ta tane ŋakmba kila. ");
INSERT INTO ssd_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Tane maŋ lato mbar maŋau ke likap ta Suŋgoŋge tane taŋgine gabat turmba ŋaigo siglikamŋgat ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Saul nu gabat suŋgo minmba Israel mbal kulatkina le ma ma yar armba kinaig. ");
INSERT INTO ssd_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Taŋamba kile nu Israel tuku taŋgo pileŋga 3,000 madiniŋgina sulumba afu ta ŋakmba kukulniŋgina le luka naŋgine tumbraŋ tumbraŋ kine likinaig. Taŋanaig le nu taŋgo 3,000 ta sinamŋge taŋgo 1,000 paplamba kukulniŋgina le kiŋo nuŋe Yonatan ndoŋ kinaig ka Benyamin ma tugu Gibea tumbraŋŋge minnaig le nuŋe kame taŋgo 2,000 ta kilmba ka Betel ma taknu Mikmas tumbraŋŋge nane ndoŋ minna. ");
INSERT INTO ssd_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Taŋamba minnaig ma ma Yonatan nu tiŋga nuŋe kame mbal ndoŋ kina ka Gebaŋge nane Filistia tuku kame kuasmbi ta ndoŋ kame bumba nane bale farkina. Bale farkina le Filistia mbal afu nane wam ta isnaig. Taŋanaig le Saul nu Hibru mbal ŋakmba nane pasa ta iswaig ŋga taŋgo afu kukulniŋgina le Israel ma tugu ŋakmba mbol kumba tabil fitke lika ");
INSERT INTO ssd_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Israel mbal teŋenmba saniŋginaig: Gabat suŋgo Saulŋge nane Filistia tuku kame kuasmbi ande bale far suluna le kile Filistia mbal nane sine tuku kagli firka gubra tormba minig tukunu tane ŋakmba Saul sota Gilgal kape ŋginaig le nane kinaig. ");
INSERT INTO ssd_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Filistia mbal nane Israel mbal ndoŋ kame buwam saka kame kuasmbi suŋgomba kile-maŋgurkinaig. Nane kame tuku karis 3,000 kuanekinaig sulumba taŋgo hos mbolŋge minyokanu ta 6,000 maŋgurkinaig. Nane tuku kame taŋgo suŋgomba piyalŋge fulbul minig taŋaŋ burnu kumuŋ kuga. Kame kuasmbi ta ŋakmba kinaig ka Bet-Awen ki prote kumam taŋge Mikmasŋge kame tuku kuaneka tumbraŋ ulnaig. ");
INSERT INTO ssd_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Nane tumbraŋ ulnaig le Israel taŋgo kame nane Filistia tuku kame kuasmbi ta kaŋgerka nane kuru-kuruka sine bale far suluwamŋgaig ŋga ka ndame sugo sugo kumnenu kilke burok sikar burok kule ŋguruŋ sinamŋge kuirke likinaig. ");
INSERT INTO ssd_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Taŋanaig le afu nane Yordan kule pakarka Gad le Gilead tuku ma tugu mbol kinaig. Taŋgo kuasmbi Saul ndoŋ Gilgalŋge minnaig ta nane mata kuru-kuruka taŋge minnaig. ");
INSERT INTO ssd_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Saul nu Samuelŋge ait tuna ta kumumba kusem ndindo Gilgalŋge nu minde minna. Minde ma ma kuga le taŋgo afu buk Saul kusremba sili-silinaig le ");
INSERT INTO ssd_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Saul ndek nane afu saniŋgina: Tane agaŋmor pambi pasokam le uge suglukam tuku ta kilmba ŋgamuŋgal ulendiwam tuku atrau agaŋ ta turmba kilmba ye tugum te prowap ŋgina le nane kilmba nu tugum kinaig. Taŋanaig le nu agaŋmor kame ta kilmba baleniŋmba atrauka pambi pasokina le ugnaig. ");
INSERT INTO ssd_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Uge suglukinaig le kile Samuel prona. Nu prona le Saul ndek nu kaŋgeram kilim kina le ");
INSERT INTO ssd_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Samuelŋge nu sana: Ne ame maŋau kat ŋgina le nu lafumba sana: Ne ye ait sina ta tair minit ta ne pro ndamba minat le taŋgo afu buk ye kusreyumba sili-siliwaig le ye Filistia kame kuasmbi Mikmasŋge maŋgurkaig ta kaŋgerkit sulumba ");
INSERT INTO ssd_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","ye idusit: Ye Suŋgoŋge sinzaŋyam tuku maŋau ande ke ndaki le nane Filistia mbalŋge pro sine ndoŋ kame bubekaig ŋga idusmba ye dirnaŋga atraukit ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Taŋaka sana le Samuel ndek nu sana: Ne ŋginŋgan maŋau kat ŋgina. Ne naŋe Mbara Suŋgo ne pasa sanina ta dubi ndawat. Ne nu tuku miŋge dubiwat kande ne naŋe ndare ndoŋ Israel mbal kulatka minmba minig kande. ");
INSERT INTO ssd_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Ne Suŋgo tuku miŋge ŋgurat tukunu ne Israel tuku gabat suŋgo mine kuene nda. Taŋgo ande kise Suŋgo ndoŋ wamdus ulendi ŋak Suŋgoŋge te-silika madiwa le nuŋge Israel mbal tuku gabat suŋgo minamŋgat ŋga Saul sana. ");
INSERT INTO ssd_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Samuel nu pasate suluna sulumba nu tiŋga Gilgal kusremba Benyamin ma tugu Gibea kina le Saul nu tiŋga nuŋe kame mbal nu ndoŋ minnaig ta burkina ta taŋgo 600. ");
INSERT INTO ssd_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Saul le kiŋo nuŋe Yonatan nakile kame kuasmbi ndoŋ Benyamin ma tugu Gebaŋge minnaig le Filistia mbal tuku kame kuasmbi ta Mikmasŋge minnaig. ");
INSERT INTO ssd_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Taŋamba minnaig sulumba Filistia mbalŋge naŋgine kuasmbi keŋmba kukulniŋginaig le kinaig sulumba ka Israel mbal tuku agaŋ ndende ŋakmba yomba kilmba kinaig. Kuasmbi ande ka Ofra tumbraŋ Sual kilke mbol kinaig le ");
INSERT INTO ssd_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","kuasmbi ande ka Bet-Horon kinaig le kuasmbi ande ka Seboim ma gutoŋ patumba ma baknu ta tugum kinaig. ");
INSERT INTO ssd_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Ait ta mbolŋge Israel ma tugu ŋakmba mbolŋge taŋgo afu ainmbi kame agaŋ wakeikinaig ta mine ndakinaig. Ta ndaŋam? Nane Filistia mbalŋge nane Hibru mbal kame bagi mbanduwaŋ wakeikam tuku piro ta peuniŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Israel mbal ŋakmba nane Filistia mbal tugum kumba ain kilke pikam tuku pik sapor sarip agaŋ ndende kame ta ŋakmba Filistia mbal niŋganu le rurke likanu. ");
INSERT INTO ssd_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Rurke likanu le nane Israel mbalŋge ndametiŋ suŋgokanumbi piyaniŋmba yaika kilanu. ");
INSERT INTO ssd_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Ta tuku kame ait mbolŋge nane Israel tuku kame kuasmbi ŋakmba kame bagi le mbanduwaŋ kugatok. Saul le kiŋo nuŋe Yonatanŋge ndo kame agaŋ ndende ta ŋak minnaik. ");
INSERT INTO ssd_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Kile nane Filistia mbalŋge kame kuasmbi ande kukulnaig le ka Mikmas kumba ma tabe ŋak mbol taŋge. ");
INSERT INTO ssd_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Minnaig le ait ande Saul kiŋo nuŋe Yonatan ndek taŋgo mo nu tuku kame agaŋ kugrakanu ta sana: Sile kumba ka Filistia kame kuasmbi ndin kulatkade ambe kap ŋgina. Taŋakina le nu mam nuŋe Saul kila sa ndana. ");
INSERT INTO ssd_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Saul nu Gibea patumba Mikronŋge ail suŋgo ande kumnemŋge minyok minna le kame taŋgo 600 nu ndoŋ minnaig. ");
INSERT INTO ssd_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Ahia nu pris tuku tawi ta tiŋmba nane ndoŋ minna. (Ahia mam nuŋe Ahitub. Ahitub mambo nuŋe Ikabod. Nale Pineas tuku kiŋo kat nuŋe. Pineas mam nuŋe Elai. Elai nu buk Silo tumbraŋŋge pris minna). Saul tuku kuasmbi nane Yonatan kina ta katese ndanaig. ");
INSERT INTO ssd_vpl VALUES ("S114_4","010_14_4","1SA","14","4","5","Kile Yonatan nu tabe fumbe armba ta ŋgamu ŋgamu ndin kina ta dubimba nane Filistia kame kuasmbi sota kambim bafuna. Ndin make inumŋge tabe fumbe ta nyunu Boses ta Mikmas tumbraŋ kumamŋge minna. Make inumŋge fumbenu ta nyunu Sene ta Geba tumbraŋ kumamŋge minna. ");
INSERT INTO ssd_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Kile Yonatan nu taŋgo mo nu tuku kame agaŋ kugrakina ta sana: Sile Filistia kame kuasmbi ŋgaro nda pikanu ndin kulatkade ambe kap. Taŋape le Suŋgoŋge sile sinzaŋsikuwa le nane bale faramŋgik inde. Suŋgo nu kame kuasmbi suŋgokanu sinzaŋte le ŋgueu mbal bale farde taŋamba ndo nu taŋgo ndindo armba mata sinzaŋnikuwa le ŋgueu mbal bale faramŋgaik ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","nu tuku kame agaŋ kugrakanu taŋgo taŋge lafumba sakina: Ta maye. Ne ame maŋau kam bafuwa ta ye ne turnamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Yonatanŋge nu sana: Sile kilim si ta kap le nane sile kaŋgerkuwaig. ");
INSERT INTO ssd_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Taŋawaig sulumba nane sile sota ndekam sakuwaig ndeta sile taŋge ndo tiŋga nane sota nda mbumba kap. ");
INSERT INTO ssd_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Ko nane sakuwaig: Tale mbape o ŋguwaig ndeta sile katesewamŋgik Suŋgo nu nane kilmba sile tuku wai mbolŋge patinuŋgat ŋga idusmba sile mbumba nane sota kap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Kile nale arŋeŋ bitek kilim ka tiŋginaik le nane Filistia mbal nale kaŋgerka sakinaig: Ai si. Hibru mbal afu burok sinamŋge kuirkinaig tuku prode si ŋginaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Filistia kame kuasmbi taŋge nale wika sanikinaig: Tale te mbape le sine tale maŋau tumtikbe o ŋginaig. Taŋakinaig le Yonatan nu taŋgo mo ta sana: Suŋgoŋge Filistia mbal si kilmba sine Israel tuku wai mbolŋge patikat tukunu ne ye ŋgumnem dubiya ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Yonatan nu rabmba ndame poŋga mbumba kina le taŋgo mo ta nu ŋgumnem dubina. Taŋamba Yonatanŋge Filistia mbal ta kat patika panke likina le kilke mbolŋge ndekinaig le taŋgo mo taŋge nane kame bagimbi pike patikina le kumnaig. ");
INSERT INTO ssd_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Ki ait ta mbolŋge Yonatan nu kame tugu pilmba taŋgo mo ta ndoŋ ma ŋai fudiŋndo ta mbolŋge kame taŋgo 20 taŋamba bale farkinaik le kumnaig. ");
INSERT INTO ssd_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Taŋanaig le Filistia mbal afu kame mbal tuku tumbraŋŋge minnaig afu tumbraŋ tumbraŋŋge minnaig afu ndin kulatka minnaig afu Israel mbal tuku agaŋ ndende kuayarka yomba kilmba kinaig ta nane ŋakmba Kuateŋge kuru kuru pileniŋgina. Taŋana le mumni promba kilke piririna le nane ŋakmba kua ka sili-silinaig. ");
INSERT INTO ssd_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Kile Saul tuku kame mbal Gibea tumbraŋ Benyamin ma tugu kulatka minnaig ta nane mambilnaig kande Filistia kame kuasmbi nane tumbraŋ kusre pilmba pinder-pindermba pupak tinaig le kaŋgerkinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Saulŋge kame taŋgo nu ndoŋ minnaig ta saniŋgina: Kame taŋgo burkap sulumba ima teŋge mine ndakate ta katesewap ŋgina. Taŋakina le nane burkinaig ta Yonatan le taŋgo mo nu tuku kame agaŋ kugrakanu ta nale ndo mine ndakinaik. ");
INSERT INTO ssd_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Ait ta mbolŋge Kuate tuku tukul bokis ta Israel mbal tugumŋge minna tukunu Saul nu pris Ahia sana: Tukul bokis tumba yale ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Saul nu pris ndoŋ pasata minnaik le Filistia mbal naŋgine kame tumbraŋ taŋge taŋgo ŋginŋgankanu sukmba wika raumba minnaig le Saulŋge ismba pris ta sana: Taŋaig le tukul bokis ta kusrewa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Taŋakina sulumba Saul nuŋe kame kuasmbi ta ndoŋ Filistia mbal tuku kame tumbraŋ kinaig kande nane Filistia mbal ŋginŋganka naŋgine naŋgine muŋgu bale-baleka minnaig le kaŋgerkinaig. ");
INSERT INTO ssd_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Taŋanaig le Hibru mbal afu o buk nane Filistia mbal ndoŋ minnaig sulumba naŋgine kame kuasmbi sinamŋge minnaig ta nane kile luka Saul le Yonatan ndoŋ ulendika naŋgine mbal Israel turka kame bunaig le ");
INSERT INTO ssd_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Israel mbal afu nane Efraim ma tabe mbol taŋge kuirke likinaig ta nane Filistia mbal kua kinaig pasa ta ismba nane mata promba Saul le Yonatan turnikmba nane Filistia mbal kilmba yokerka ");
INSERT INTO ssd_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","kame bumba kinaig ka Bet-Awen tumbraŋŋge lukinaig. Taŋanaig le ki ait ta mbolŋge Suŋgoŋge Israel mbal sinzaŋniŋmba nane Filistia mbal tuku wai mbolŋge kile-luka kilna. ");
INSERT INTO ssd_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Ki ait ndui ta mbolŋge ndo Saul nu pasa saŋgrinu Israel mbal saniŋmba sakina: Kile ye yiŋe ŋgueu mbal tuku mbar lafumba nane ŋakmba bale farkamŋgit tukunu tane taŋgo ŋakmba nyamagaŋ pinka minap le ki ka butuŋguwa. Taŋgo ande nyamagaŋ nyuwa ta Suŋgoŋge nu mapewe nda ŋgina le nane kame mbal ta isukuse ndaka gubak nane yokerka kinaig ka ");
INSERT INTO ssd_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","duŋe ande mbol promba ŋguimzaŋ kulenu ail burok sinamŋge bulmba kutuka minnaig le kaŋgerkinaig ta ");
INSERT INTO ssd_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","taŋgo andeŋge tumba nye ndakina. Ta ndaŋam? Nane Saulŋge peu pasa saŋgrinu pilna le nane ta tuku kuru-kuruka nye ndakinaig. ");
INSERT INTO ssd_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Yonatanŋge ndo mam nuŋe pasa sakina ta ise ndakina tukunu nu ndumndum biyna tambi ŋguimzaŋ tenu dauk tumba nyina sulumba nu gubanu am kuilkuilna ta ŋgarosu maŋ saŋgri tina. ");
INSERT INTO ssd_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Taŋana le taŋgo andeŋge ndek Yonatan sana: Mam naŋeŋge sine nyamagaŋ pinkam tuku pasa saŋgrinu sasiŋmba sakat. Taŋgo ande kite nyamagaŋ pin ndaka nyuwa ta Suŋgoŋge nu mapewe nda ŋga sakat tukunu sine ŋakmba gubanu baklelgeg ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Yonatanŋge taŋgo ta sana: Mam tuku pasa taŋge sine ŋakmba ŋaigo siglikate. Ye ŋguimzaŋ kulenu fudiŋmba nyit tukunu ye maŋ saŋgri tiŋget. ");
INSERT INTO ssd_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Sine ŋgueu mbal tuku nyamagaŋ kilig ta nyumba saŋgri tig kande sine Filistia mbal bale far suluwig kande. Sine saŋgri kugawaig tukunu sine Filistia suŋgomba bale far ndaniŋgig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Ait ta mbolŋge nane Filistia mbal ndoŋ Mikmas tumbraŋŋge tugu pilmba kame bumba kinaig ka Azalon tumbraŋŋge tiŋginaig. Taŋanaig sulumba nane Israel mbal gubanu baklelnaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","ŋgueu mbal tuku agaŋmor kame kilmba pre pre bale farka pasoka ndare ŋak ŋak nyinaig le ");
INSERT INTO ssd_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","taŋgo kame afuŋge kinaig ka Saul sanaig: Gabat suŋgo, nane kame mbal Suŋgo am mbolŋge unekumba nane ndem ndare ŋak nyumba minig ŋginaig le Saul ndek sakina: Tane sonndo mbaraig. Tane kape ka ndame suŋgo ande mbari-mbarimba tumba ye tugum te prowap ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","maŋ lato saniŋgina: Tane kape ka kame mbal ŋgamukŋge agaŋmor nduik nduik kilmba te promba ndame te mbolŋge bale farmba pagumba nyam tuku ŋga nane saniŋgap. Nane Suŋgo am mbolŋge unekumba ndem ndare ŋak nda nyuwaig ŋga saniŋgap ŋgina le nane furir ta mbolŋge ndo agaŋmor nduik nduik kilmba promba ma ta mbolŋge bale farmba kuapika nyinaig. ");
INSERT INTO ssd_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Taŋanaig le Saulŋge ndame turŋaŋga Suŋgo atraukam tuku pa laŋlaŋ ande wakeina. Saul nu buk atraukam tuku pa laŋlaŋ ande wakei ndana ta kile nu tugu pilmba wakeina. ");
INSERT INTO ssd_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Kile Saul nu nuŋe kame taŋgo saniŋgina: Furir te mbolŋge ndo sine kab sulumba Filistia mbal yokerka bale far sulube le ma purfewa le sine nane tuku agaŋ ndende kat naŋgine kilbe ŋgina le nane sakinaig: Ta maye. Sine taŋabe ŋginaig kande pris ta sakina: Tane yauk. Sine Kuate kusnabe sulumba ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Taŋakina le Saulŋge Kuate kusnamba sakina: Sine kumba Filistia mbal yokerkube ta ne sine sinzaŋsiŋmba nane kilmba sine wai mbolŋge patikamŋgat e ŋgina kande Suŋgo nu ait ta mbolŋge Saul tuku pasa lafu ndana. ");
INSERT INTO ssd_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Taŋana le Saul ndek Israel mage mage saniŋgina: Tane yalpe le sine imaŋge mbarat le Suŋgo nu sine tuku pasa lafu ndawat ta sota te-silikube ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Taŋamba nu maŋ sakina: Suŋgo abo tugu ŋak nu mara mindek sine Israel mbal sinzaŋsiŋgit ta ye nu tuku nyu mbolŋge siŋka saket. Taŋgo ima nu mbar te kat ta nu kumamŋgat. Ye tuku kiŋo Yonatan nu mata kumamŋgat ŋgina le taŋgo andeŋge nu tuku pasa ta lafu ndana. ");
INSERT INTO ssd_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Kile Saul nu Israel mbal ŋakmba saniŋgina: Tane ŋakmba kape ka si taŋge tiŋgap le sile Yonatan ndoŋ te taŋge minamŋgik ŋgina le nane sakinaig: Ta maye. Sine taŋabe ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Nane tiŋginaig le Saulŋge Suŋgo kusnamba sakina: O sine Israel mbal tuku Mbara Suŋgo, imaŋge mbar te kat ta te-mayokmba saya le isi ŋgina. Taŋakina le pris ta nuŋe tukul ndamembi wam katesemba sakina: Mbar te taŋgo pino mbolŋge kuga. Neŋge kiŋo naŋe Yonatan ndoŋ mbar te kaik ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Saul ndek sakina: Ne maŋ wam katesewa sulumba yeŋge ko Yonatanŋge mbarat ndeta saka le isbe ŋgina le nu maŋ lato tukul ndamembi wam katesena le Yonatan tuku nyu mayok kina. ");
INSERT INTO ssd_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Taŋana le Saul ndek Yonatan kusnana: Ne ame maŋau kat ta ye saya le isi ŋgina le Yonatan lafumba sana: Yeŋge ndumndummbi ŋguimzaŋ fudiŋmba dauk tumba nyit tukunu ne ye baleya le kumi ta maye ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Saul nu sana: Au. Kiŋo ne kumamŋgat. Ye siŋka saket. Ye ne bale ndani ta Kuateŋge ye mapeye nda ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","taŋgo kameŋge Saul peumba sanaig: Kuga. Yonatanŋge sine Israel mbal kile-ŋgumnemka nu amboŋga kame suŋgo ta mbol ket le sine Filistia mbal bale farkig. Nu Kuateŋge sinzaŋat le nu maŋau taŋamba kat tukunu sine Suŋgo abo tugu ŋak nu tuku nyu mbolŋge son pasa sakeg ta ne nu mbolŋge maŋau ande ke ndaka ŋga peunaig le nu Yonatan bale ndana. ");
INSERT INTO ssd_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Kile Saul nuŋe kame kuasmbi ndoŋ Filistia mbal yokerkinaig ta kusreka lukinaig le nane Filistia mbal ta luka naŋgine tumbraŋ kinaig. ");
INSERT INTO ssd_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Saul nu Israel mbal tuku gabat suŋgo minna sulumba nuŋe kame kuasmbi kilmba Israel mbal tuku ŋgueu mbal ma ŋakmba mbolŋge mine likinaig ta ndoŋ kame bumba Moab mbal Amon mbal Edom mbal Filistia mbal Soba tuku gabat sugo sugo nane ŋakmba kile-ibeŋka bale farniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","Taŋanaig sulumba nu kame kuasmbi suŋgokanu kile-maŋgurka nane saŋgri tiŋga kame bumba Amalek mbal mata bale farnaig sulumba kuasmbi afu Israel kilke mbolŋge agaŋ ndende kuayarmba lika minnaig ta pitaikinaig le nane maŋ luka Israel kilke mbol pro ndanaig. ");
INSERT INTO ssd_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Saul tuku kiŋo kat nuŋe keŋmba ta nyu naŋgine Yonatan Iswi Malkisua. Kulim nuŋe mulum ta nyunu Merab. Mambo nuŋe nyunu Mikal. ");
INSERT INTO ssd_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Saul piyo nuŋe nyunu Ahinoam. Ahinoam mam nuŋe nyunu Ahimas. Saul bab nuŋe tuku kiŋo nuŋe Abner nu Saul tuku kame gabat minna. ");
INSERT INTO ssd_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Saul mam nuŋe Kis. Kis le Ner nale Abiel tuku kiŋo kame. ");
INSERT INTO ssd_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Saul nu gabat suŋgo minna ta nu tuku kame kuasmbi ta nane saŋgrimba Filistia mbal ndoŋ kame buwanu. Taŋawanu le nu Israel taŋgo saŋgriknu kame tuku kuru kuru ndakanu ta ŋakmba kilmba nuŋe kame kuasmbi tuku madiniŋganu. ");
INSERT INTO ssd_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Ait ande Samuel nu Saul sana: Ye o buk Suŋgoŋge kukulyina le ne gureŋ pisnenen le kile ne Israel mbal kulatkate tukunu ne Suŋgo Saŋgri Ŋayo tuku pasa te isa. ");
INSERT INTO ssd_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","O buk Israel mbal nane Isip kilke kusremba ilmba minnaig le Amalek mbal pro nane ndoŋ kame tiŋginaig. Kile Suŋgoŋge maŋau ta lafumba Amalek mbal pa niŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Ne naŋe kame mbal kilmba kape sulumba Amalek mbal mape ndaniŋmba nane tuku agaŋ ndende ŋakmba ŋaigo siglikap. Taŋgo pino, kiŋo kame, kiŋo dabronu ta ŋakmba bale farkap sulumba makau sipsip kamel doŋki agaŋmor ta ŋakmba turmba bale farniŋgap ŋga Saul sana. ");
INSERT INTO ssd_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Taŋakina le Saul ndek nuŋe kame mbal ta ŋakmba Telem tumbraŋŋge kile-maŋgurka ulendimba burkina ta Israel tuku kame taŋgo 200,000 Yuda tuku kame taŋgo 10,000. ");
INSERT INTO ssd_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Burke deŋpurmba kile Saul ndek kame kuasmbi ta kilmba kinaig ka Amalek mbal tuku tumbraŋ suŋgo ma gutoŋ taŋge kame tuku kuaneka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Kame tuku kuaneka minnaig sulumba Saul ndek Ken mbal tuku pasa pilmba sakina: Tane Amalek mbal ndoŋ ulendika mine ndakap. Tane nane kusreka kua kape. Sine nane ndoŋ kame bumba tane turmba bale farbekig. Tane tuku wa kat taŋgine o buk sine tuku wa mbuŋ kame Isip kusremba ilmba minnaig le sinzaŋniŋginaig tukunu ye tane mapekam iduset ŋgina. Taŋaka saniŋgina le nane Ken mbal ŋakmba Amalek mbal kusreka kua ka kinaig. ");
INSERT INTO ssd_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Kua ka kinaig le kile Saul nu nuŋe kame mbal ndoŋ Awilaŋge Amalek mbal ndoŋ kame bumba nane yokerka bale farmba ka ka Isip kilke ki prote kumamŋge Sur ma tugu mbol pronaig. ");
INSERT INTO ssd_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Promba Amalek taŋgo pino ŋakmba bale far sulumba naŋgine gabat suŋgo Agag mapemba bale ndanaig. ");
INSERT INTO ssd_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Taŋamba nane agaŋmor ŋaigonu ta ŋakmba bale farka makau sipsip fatnu mage mage ta ŋakmba bale far ndanaig. Nane agaŋmor magenu ta ŋakmba kusreke likinaig. ");
INSERT INTO ssd_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Taŋanaig le Suŋgo nu ndek Samuel sana: ");
INSERT INTO ssd_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","Osese. Yeŋge Saul madimba gabat suŋgo pilen ta nu ye ŋgumneyumba ye tuku miŋge ŋgurat tukunu ye nu tuku gare ndayate ŋgina le Samuel nu pasa ta ismba wamdus tatrukina le furir ta mbolŋge nu Suŋgo yabaŋmba minna le ka mafena. ");
INSERT INTO ssd_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Mafena le maratukuk Samuel nu tiŋga Saul sota kina le nane afu nu sanaig: Saul nu buk Karmel kumba ka taŋge nuŋe nyu minwa ŋga ndame kuen ande tumba kilke mbol te-tiwe deŋpurmba nu ndo tiŋga Gilgal tumbraŋ ket ŋga Samuel sanaig. ");
INSERT INTO ssd_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Taŋamba sanaig le Samuel ndek Saul dubimba kina ka nu te-silikina le Saul ndek nu sana: Suŋgo nu ne nyaro tinwa. Ye Suŋgo tuku miŋge kumu-kumuwen ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Samuel ndek nu sana: Sipsip makau zigna suŋgo promba minit le iset ta aniŋge kilnaig e ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Taŋakina le nu lafumba sana: Ne ŋgumbeyu isit ta taŋgo kameŋge Amalek mbal tugumŋge kilmba pronaig. Nane sipsip makau mage mage naŋe Mbara Suŋgo atraukam saka mapeka kilmba pronaig. Agaŋmor afu ta ŋakmba bale far sulugeŋ ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","nu ndek Saul sana: Ne maninka le ye furir Suŋgoŋge wam paguyat ta sani le ne isa ŋgina. Taŋaka sana le Saul ndek nu sana: Saka le ye isi ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Taŋakina le Samuel nu sana: O buk ne ake taŋgo nyu kugatok ŋga idusmba minna le Suŋgoŋge ne Israel tugu ŋakmba tuku gabat suŋgo madinina le kile ne minit. ");
INSERT INTO ssd_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Nuŋge ne Amalek mbal ŋaigonu ta ŋaigo siglike lika ŋakmba bale far suluwam tuku ŋga kukulnina ta ");
INSERT INTO ssd_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","ne ndaŋam saka nu tuku miŋge dubi ndana? Ne ndaŋam nane tuku gabis agaŋ ndende magenu kile-likina? Suŋgo nu ne tuku nzali kugatok ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Taŋakina le Saul ndek pasa lafumba sakina: Kuga. Ye Suŋgo tuku miŋge dubiwen. Suŋgo nu ye kukulyina taŋamba ndo ken sulumba Amalek mbal ta ŋakmba bale far sulumba naŋgine gabat suŋgo Agag ndo biye timba tumba progeŋ. ");
INSERT INTO ssd_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Taŋgo kameŋge ndo naŋgine nzali dubimba agaŋ ndende magenu agaŋmor mage mage Gilgalŋge naŋe Mbara Suŋgo atraukam tuku ŋga kilnaig ŋga Samuel sana. ");
INSERT INTO ssd_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Taŋakina le Samuel nu maŋ lato sana: Ne ndaŋmba iduste? Suŋgo nu miŋge dubiwanu maŋau suŋgomba nzalite e ko nu agaŋmor kilmba atraukanu maŋau suŋgomba nzalite e ŋga iduste. Ne ise tiwa. Miŋge dubiwanu maŋau ta nu suŋgomba nzalite. Atraukanu maŋau ta nu suŋgomba nzali ndate. ");
INSERT INTO ssd_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Kuate tuku miŋge ŋguranu maŋau ta une suŋgokanu anzilaŋ guwa wikade taŋamba. Ko ande nu Kuate idus ndamba nuŋe nzali ndo dubimba likate ta nu yabri mbara dubiwanu taŋaŋ. Ne Suŋgo tuku miŋge ŋgurna tukunu nu kile ne pitainuwa le Israel mbal maŋ kulatke nda ŋga Saul sana. ");
INSERT INTO ssd_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Taŋakina le Saul ndek pasa lafumba sakina: Son. Ye mbaren. Ye Suŋgo tuku miŋge ne tuku miŋge turmba ŋguren. Ye yiŋe kame kuasmbi tuku kuru-kuruka nane tuku miŋge dubiwe niŋgen. ");
INSERT INTO ssd_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Ne ye tuku une te ŋgilaiŋga le ye ne ndoŋ Gilgal kumba ka taŋge Suŋgo mbariŋi ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Samuel ndek sana: Ye ne ndoŋ kine nda. Ne Suŋgo tuku miŋge pitaina le nu ndek ne pitainina le Israel mbal tuku gabat suŋgo mine nda ŋga Saul sana. ");
INSERT INTO ssd_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Taŋamba Samuel nu mbilka lukam bafuna kande Saulŋge nu ŋgailkam saka nu tuku tawi tundunnu biye ndiŋna le fetkina. ");
INSERT INTO ssd_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Fetkina le Samuelŋge ndek nu sana: Ne ye tuku tawi yaiyumba fetkat taŋamba ndo ki ait te mbolŋge Suŋgoŋge Israel kulatkam tuku piro ta ne yainumba taŋgo ande tawet. Taŋgo ta mayenu ndo ne suk kuga. ");
INSERT INTO ssd_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Israel mbal tuku Mbara Mbolok ta nu yabri ndakate tuku. Nu wamdus mbil ndate tuku. Sine kilke mbolok mbal wamdus mbilmbileg taŋamba kuga ŋga Saul sana le ");
INSERT INTO ssd_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Saul ndek sakina: Ye mbaren ta ne Israel mage mage am mbolŋge ye tala ndaya. Ye ndoŋ luka kap sulumba ye ne tuku Mbara Suŋgo mbariŋi ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Samuel ndek Saul dubimba luka kinaik. Luka Gilgal pronaik sulumba Saul nu Suŋgo mbariŋna. ");
INSERT INTO ssd_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Kile Samuel ndek taŋgo afu kukulniŋmba saniŋgina: Tane kape ka Amalek mbal tuku gabat suŋgo Agag tumba prowap ŋgina le nane kinaig ka Agag tumba pronaig. Agag nu wamdus fulilka minna ta kile nu idusna ye mapeyamŋgaig ŋga nu wamdus bulkina kande ");
INSERT INTO ssd_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Samuel ndek nu sana: Ne buk naŋe kame bagimbi taŋgo kame suŋgomba bale farkina le ina naŋgine kiŋo kugatok minig. Taŋamba ndo kile yeŋge ne baleni le ina naŋe mata kiŋo kugatok minamŋgat ŋga Agag sana. Taŋakina sulumba Samuel ndek Agag tumba Gilgal tumbraŋ taŋge Suŋgo am mbolŋge balena le kumna le pike tatana. ");
INSERT INTO ssd_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Taŋamba Samuel ndek tiŋga nuŋe tumbraŋ Rama kina le Saul nu tiŋga nuŋe tumbraŋ Gibea kina. ");
INSERT INTO ssd_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Samuel nu Saul kusremba nduiye kina. Nu maŋ pro Saul kaŋger ndana sulumba nu idusmba ŋgamuŋgal tatruka wamdus piti ŋak minna. Suŋgo nu nuŋe miroŋ Saul madimba Israel mbal tuku gabat suŋgo pilna ta kile nu Saul tuku gare ndana. ");
INSERT INTO ssd_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Kile Suŋgo nu Samuel sana: Ne mara mindek Saul tuku ŋgamuŋgal tatrukate. Ne wamdus piti ta ginu le kusrewamŋgat? Ye buk nu Israel mbal tuku gabat suŋgo nda minwa ŋga pitaiwen. Kile ne sipsip naunu ande tumba olif kule tolmba tumba ka taŋgo ande nyunu Yesi sota Betlehem tumbraŋ kaye. Yeŋge taŋgo ta tuku kiŋo ande gabat suŋgo minwa ŋga madiwen ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Taŋakina le Samuel nu ndek sana: Ye ndaŋmba wam ta ki? Saul nu iswa sulumba ye baleyikat ŋgina le Suŋgo nu lafumba sana: Ne makau fatnu ande tumba ka teŋenmba nane saniŋga: Ye Suŋgo atraukam tuku te prowet ŋga saniŋga. ");
INSERT INTO ssd_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Taŋamba Yesi tuku pasa pale le nu mata atraukam tuku ma ta mbol prowa le ye ne ndaŋmba kam tuku ta sanamŋgit. Yeŋge taŋgo ande ne tumni le gabat suŋgo minam tuku ŋga olif kulenu ta pisnewa ŋga Samuel sana. ");
INSERT INTO ssd_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Taŋaka sana le Samuel nu tiŋga Suŋgo tuku miŋge dubimba Betlehem kambim saka kina le tumbraŋ ta tuku gabat kame nane nu te-silikinaig sulumba piririmba kuru kuru mayemba nu sanaig: Ne ŋgamuŋgal mukuk siŋgam prote e ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Samuel ndek lafumba sakina: Au. Ye Suŋgo atraukam prowet. Tane mata Suŋgo am mbolŋge purfeŋnu mayok kumba ye dubiyap le sine atraukam kab ŋga saniŋgina. Taŋamba Yesi nuŋe kiŋo kame ndoŋ ŋakmba purfeŋnu mayok kinaig le nu nane atraukam tuku ma mbol kambim tuku wikina le pronaig. ");
INSERT INTO ssd_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Nane pronaig le Samuel nu Yesi tuku kiŋo nuŋe Eliab kaŋgermba nuŋe wamdusmbi sakina: Sonndo. Taŋgo Suŋgoŋge madina ta prowat noten ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Suŋgoŋge nu sana: Ne nu tuku ŋgarosu kuennu maditaknu ta kaŋgerte ta ye nu mbulit. Taŋgo kameŋge ŋgarosu mbolŋge ndo pileŋgade ta ye taŋgo tuku ŋgamuŋgal kaŋgerka pileniŋget tuku ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Kile Yesi ndek kiŋo nuŋe Abinadab wika tumba Samuel tugum kina le Samuel nu sana: Suŋgoŋge taŋgo te mata madi ndana ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Taŋakina le Yesi nu maŋ ka Sama tumba prona le Samuel nu sakina: Suŋgoŋge taŋgo te mata madi ndana ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Taŋakina le Yesi nu nuŋe kiŋo kat nuŋe bailkamba kusrekina ta maŋ nduik nduik kilmba Samuel tugum prona le Samuel nu sana: Suŋgoŋge nane te inum madi ndana ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","nu maŋ Yesi kusnana: Ne tuku kiŋo kat naŋe noten ndo e ŋgina le Yesi nu sana: Kiŋo ŋgrimbik ta nda prowat. Nu sipsip kulatnu ket ŋgina le Samuel ndek nu sana: Ne ka taŋgo ande kukula le kumba ka nu tumba te prowa. Prowa le sine atraukamŋgig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Taŋakina le Yesi nu taŋgo ande kukulna le kumba ka kiŋo nuŋe ta tumba prona. Kiŋo mo ta saŋgriknu. Nuŋe ŋgarosu tumail pasi gabat waŋe amnu maditaknu. Kile Suŋgoŋge Samuel sana: Taŋgo sakit ta noten. Ne olif kulenu tumba taŋgo te kule pisnewa ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Samuel ndek David tuku aba kat nuŋe tuku am mbolŋge olif kulenu ta tumba David tuku gabat mbolŋge kutuna. Taŋamba nu tiŋga luka Rama kina. Kina le Suŋgo tuku Guwa ta David saŋgri pilemba nu mbolŋge minmba minna. ");
INSERT INTO ssd_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Suŋgo tuku Guwa o buk Saul kusrena le kile Suŋgoŋge bukla ande kukulna le Saul ŋginŋgan serna. ");
INSERT INTO ssd_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Taŋana le nuŋe piro taŋgo kameŋge nu sanaig: O suŋgo, ne isa. Bukla ande Kuateŋge kukulna le ne ŋginŋgan sernate tukunu ");
INSERT INTO ssd_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","ne sine pasa sasiŋga le sine taŋgo ande gita kat kila ta te-silika tumba ne tugum probe le bukla ta maŋ ne ŋginŋgan sernam prowa ta nuŋge gita ta katwa le ne maŋ mayekamŋgat ŋga Saul sanaig. ");
INSERT INTO ssd_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Taŋaka nu sanaig le nu piro taŋgo kame ta saniŋmba sakina: Ta maye. Tane kape ka taŋgo ima nu gita usre mayete ta te-silika tumba ye tugum te prowap ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","piro taŋgo andeŋge ndek Saul sana: Ye Betlehemnu taŋgo Yesi tuku kiŋo nuŋe nu gita usre tugunu ta ye nu kila. Nu kame taŋgo saŋgriknu. Nu kuru kuru ndakate tuku. Nu miŋge taŋgo maditaknu. Suŋgo nu ndoŋ minit ŋga Saul sana le ");
INSERT INTO ssd_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","nu ndek nane kukulniŋmba Yesi sota kape sulumba kiŋo nuŋe David sipsip kulatkate ta tumba prowap ŋgina le nane Yesi sota kinaig. ");
INSERT INTO ssd_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Nane kinaig ka Yesi tugum pronaig le nu ndek bret afu kilmba sambe sigrika doŋki mbol pilmba grep kule agaŋmor ŋgaronumbi tolna ta tumba meme fatnu ande tumba David kile-tuna le kilmba Saul sota kinaig. ");
INSERT INTO ssd_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Kinaig ka Saul tugum pronaig le nu David kaŋgermba nzali mayena le Saul nu David madimba nuŋe kame agaŋ ndende kugraka nu dubiwam tuku piro ta nu tuna. ");
INSERT INTO ssd_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Taŋamba Saul ndek Yesi tuku pasa pilmba sakina: Ye ne tuku kiŋo te nzaliyate. Nu ye tuku piro taŋgo minamŋgat ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","David nu Saul ndoŋ minmba Kuateŋge bukla kukulanu le Saul ŋginŋgan seranu ta Davidŋge ndek gita katanu le bukla ta Saul kusremba kua kambinu le Saul nu maŋ wamdus purfemba maye minanu. ");
INSERT INTO ssd_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Mara ande Filistia mbal nane kame tuku kuaneka pro Yuda kilke suŋgo Soko tumbraŋŋge maŋgurkinaig. Maŋgurkinaig sulumba nane ka Efes-Damimŋge tumbraŋ ulnaig. Efes-Damim ta Soko tumbraŋ Aseka tumbraŋ ŋgamu-ŋgamuŋge minna. ");
INSERT INTO ssd_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Nane taŋge minnaig le Saul nu Israel tuku kame taŋgo kile-maŋgurka kilmba ka kame tuku kuaneka Ela ma gutoŋŋge tumbraŋ ulnaig. ");
INSERT INTO ssd_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Filistia mbal nane tabe inumŋge tiŋginaig le Israel mbal nane tabe inumŋge tiŋginaig. Ma gutoŋ ta ŋgamuŋge. ");
INSERT INTO ssd_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Kile kame gabat ande nyunu Goliat nu Filistia mbal tuku nyu tumba kilim ka nane Israel mbal kame tuku wikina. Goliat nu Gatnu. Nu kuen ŋayo mita keŋmba taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Nu hat kareŋnu kaikina ta ainmbi wakeiwanu. Ŋgarosu soŋgam tuku agaŋ silikina ta mata ainmbi wakeiwanu ta pitinu 50 kilo taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Nu kupe soŋgina agaŋ ta mbanduwaŋ mirena ta mata ainmbi ndo wakeikanu. ");
INSERT INTO ssd_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Nu tuku sibugi ta suŋgokanu piti ŋayo. Agonu ainmbi wakeiwanu ta pitinu 7 kilo taŋaŋ. Kame taŋgo andeŋge Goliat tuku kandim nuŋe kuramba Goliat tumailamŋge tiŋgina. ");
INSERT INTO ssd_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Kile Goliat nu tiŋga Israel kame kuasmbi ta wi kueŋka saniŋgina: Tane ndaŋam kame tuku kuaneka tiŋga minig e? Ye Filistianu. Tane ŋakmba Saul tuku piro taŋgo kame. Taŋgine taŋgo ande madiwap le pro ye ndoŋ kame buwa o. ");
INSERT INTO ssd_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Nu ye te-ibeŋyumba baleyuwa ta sine ŋakmba tane tuku piro taŋgo minamŋgig. Ko yeŋge nu te-ibeŋmba balewi ta tane ŋakmba sine tuku piro taŋgo minamŋgaig ŋga wikina. ");
INSERT INTO ssd_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Taŋakina sulumba nu maŋ lato maim maim pasa ande saniŋgina sulumba sakina: Tane Israel kame kuasmbi o. Taŋgine kame taŋgo ande madiwap le sile nu ndoŋ kame bupe o ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Saul nu nuŋe kame kuasmbi ndoŋ pasa ta ismba kuru kuru ŋayomba wamdus fulilka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","David mam nuŋe Yesi nu Betlehemnu taŋgo. Nu Efrat kumamŋge Yuda ma tugu mbolŋge minna. Yesi nu kiŋo kame 8 ŋak. Saul nu gabat suŋgo minna ta Yesi nu buk saibo pile mayena. ");
INSERT INTO ssd_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Nu tuku kiŋo kame keŋmba ta nane Saul ndoŋ kame mbolŋge minnaig. Kiŋo mulum ta nyunu Eliab. Nu dubiknu ta nyunu Abinadab. Kiŋo keŋnu ta nyunu Sama. ");
INSERT INTO ssd_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","David nu kiŋo ŋgrimbik. Nu tuku aba kat nuŋe keŋ ta ndo Saul ndoŋ kame mbolŋge minnaig. ");
INSERT INTO ssd_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","David nu ait afu Saul tugumŋge piroka minanu. Ait afu nu Saul kusremba ka Betlehemŋge mam nuŋe tuku sipsip kulatka minanu. ");
INSERT INTO ssd_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Filistia taŋgo ta maratukuk furiram mindek ait 40 nu pro ma kilimŋge tiŋga kame tuku wika minmba minna. ");
INSERT INTO ssd_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Taŋamba minna le mara ande Yesi nu kiŋo nuŋe David kukulmba sana: Ne braiŋ tiŋga wit pasokanu soŋ ŋak te tumba bret 10 te turmba kilmba aba kat naŋe kame mbolŋge minig ta sota kaye. ");
INSERT INTO ssd_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Ne sis 10 te turmba kilmba ka naŋgine kame gabat suŋgo ta tawe sulumba aba kat naŋe kaŋgerka. Nane mine mayewaig kande nane tuku mindesil ande tumba luka prowa le nane mage minig ta ye kila palmbimŋgit. ");
INSERT INTO ssd_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Aba kat naŋe, Saul, kame kuasmbi ŋakmba nane Ela ma gutoŋ taŋge Filistia mbal ndoŋ kame bumba minig ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Kinymba mafena le maratukuk tiŋga David nu sipsip kilmba taŋgo andeŋge kulatkuwa ŋga samba nu mam nuŋeŋge kukulna ta dubimba nyamagaŋ kilmba kina. Kina ka Israel kuasmbi kame tuku ŋgumbeyumba kine ilemba minnaig le kile-siglikina. ");
INSERT INTO ssd_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Nane Israel mbal inumŋge Filistia mbal inumŋge kame tuku muŋgu titika minnaig. ");
INSERT INTO ssd_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Minnaig le David ndek nuŋe agaŋ ndende ta kulat taŋgo tugum taŋge kusreka nu pinderka kame kuasmbi ta tugum kumba aba kat nuŋe kaŋgerka tane mage minig e ŋga kusnaniŋgina. ");
INSERT INTO ssd_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","David nu aba kat nuŋe ndoŋ pasatumba minna le Filistia kame gabat Gatnu taŋgo Goliat nu maŋ kilim ka mayok taŋge tiŋgumba wi kueŋka pasa mara mindek sakina taŋamba maŋ sakina le David nu isna. ");
INSERT INTO ssd_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Nane Israel kame kuasmbi taŋgo ta kaŋgermba kuru kuru mayemba kua kinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","naŋgine naŋgine sakinaig: Ai si. Taŋgo si maŋ pro sine maim maim pasa siŋmba kame tuku wika minit. Taŋgo ima nu taŋgo si balewa le kumwa ta nu Saulŋge ndametiŋ suŋgokanu tumba kulim nuŋe turmba tambimŋgat. Taŋgo ta tuku tugu mata nane takis yaika kile nda ŋga saka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Taŋamba saka minnaig le David nu nane afu nu tugumŋge minnaig ta kusnaniŋgina: i ... Filistia taŋgo ŋgaro nda pikanu si nu Kuate abo tugu ŋak nu tuku kame kuasmbi maim maim pasa niŋgit. Taŋgo inumŋge Filistia taŋgo si balewa le sine kiko patikate ta kugawa ta Saulŋge ndaŋamŋgat e ŋga kusnaniŋgina le ");
INSERT INTO ssd_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","nane nu sanaig: Taŋgo ima nu Filistia taŋgo ta balewa ta nu taŋamba taŋamba kamŋgat ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","David nu nane ndoŋ pasata minna le aba nuŋe suŋgo Eliab nu kaŋgerna sulumba ka David sawe lika sana: Ne ndaŋam saka pro te taŋge minit? Ne tuku sipsip ma baknu mbolŋge imaŋge kulatkate? Ye kila. Ne maim maim taŋgo. Ne tuku maŋau ta mayenu kuga. Ne ake kame bube le kaŋgeram saka te ta prowat ŋga sawe likina. ");
INSERT INTO ssd_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Taŋakina le David ndek aba nuŋe sana: Ne ndaŋam ye saye likate. Ye ake kusnaŋgit ŋga sakina sulumba ");
INSERT INTO ssd_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","nu aba nuŋe ŋgumnemba maŋ taŋgo ande kusnana le taŋgo taŋge maŋ pasa ndui ta ndo David kubeu tuna. ");
INSERT INTO ssd_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Kile taŋgo afu nane David pasatina ta ismba ka Saul kubeu tunaig le nu ndek nane afu kukulniŋmba saniŋgina: Kape ka David tumba prowap ŋgina le nane kinaig ka David tumba pronaig. ");
INSERT INTO ssd_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Nane David tumba pronaig le nu ndek Saul sana: O gabat suŋgo, tane Filistia taŋgo si tuku wamdus fulil ndakap. Ye ne tuku piro taŋgo minet. Yeŋge ka nu ndoŋ kame buwamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Saul nu sana: A ... ne kumuŋ kuga. Ne ndaŋam Filistia taŋgo si ndoŋ kame buwam sakate? Ne saŋgrinu kuga. Nu si kame gabat ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Taŋakina le David ndek nu sana: O gabat suŋgo, ye yiŋe mam tuku sipsip kulatket tuku. Laionŋge beaŋge sipsip fatnu ande nzoŋga tumba kinit ta ");
INSERT INTO ssd_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","ye nu yokermba sipsip fat ta yaiwet tuku. Taŋawet le nu ye makeyam bafute le ye nu tuku ŋinfok biymba balewet. ");
INSERT INTO ssd_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Ye buk laion bea bale faren. Taŋamba ndo kile Filistia taŋgo ŋgaro nda pikanu si Kuate abo tugu ŋak nu tuku kame kuasmbi maim maim pasa niŋgit ta mata balewamŋgit. ");
INSERT INTO ssd_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Suŋgoŋge ye sinzaŋyina le laionŋge beaŋge ye bale ndayinaig. Nuŋge ye maŋ sinzaŋyuwa le Filistia taŋgo siŋge ye baleye nda ŋgina. Taŋakina le Saul nu sana: Ta maye. Ne kaye. Suŋgo nu ne ndoŋ minamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Taŋakina sulumba Saul nu nuŋe kame agaŋ ndende ta kilmba David silik-tuna sulumba hat kareŋnu ainmbi wakeiwanu ta tumba David tuku gabat kaina. ");
INSERT INTO ssd_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Kaina le David nu Saul tuku kame bagi ta tina sulumba like tumna ta nu agaŋ taŋaŋ buk sili ndakina tukunu nu like fugumba Saul sana: Ye agaŋ ndende te ŋak like fuguwet. Ye agaŋ ndende te sili gilai ŋgina sulumba agaŋ ndende ta paske likina. ");
INSERT INTO ssd_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Taŋamba nu nuŋe sipsip kulatkanu ndumndum ta tina sulumba kumba ka kule skur taŋge ndame foŋfoŋ gubo gubok 5 kilmba pale fat sigrikina. Sigrikina sulumba nuŋe sikpir ta tumba biyam biyam Goliat tugum kina le ");
INSERT INTO ssd_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Filistia taŋgo ta David kaŋgermba gitmba nu sota ilna. Nu tuku kandim kurawanu taŋgo ta amboŋgina le Goliat nu ŋgumnem dubina. ");
INSERT INTO ssd_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Taŋamba nu David kaŋger tina ta David nu mbanzonu maditaknu tukunu taŋgo ta kame buwam kumuŋ kuga ŋga nu talana. ");
INSERT INTO ssd_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Talana sulumba nu David kusnana: Ye ne tuku age le ne ye katyam saka ndumndum tumba ilit e ŋga David kusnana sulumba nuŋe mbara nyu mbolŋge David taprana sulumba ");
INSERT INTO ssd_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","sana: Ne yale le ye ne baleni sulumba ŋgarosu naŋe tumba sar umaŋ agaŋmor ŋguikok niŋgi le nyamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Taŋakina le David ndek miŋge lafumba sana: Ne naŋe kame bagi, mbanduwaŋ, kandim agaŋ ndende ta kilmba ye ndoŋ kame buwam prote ta ye Israel kame kuasmbi tuku Mbara Saŋgri Ŋayo ne nu maim maim te-tuwit Mbara Suŋgo ta nu tuku nyu mbolŋge ne ndoŋ kame buwam prowet. ");
INSERT INTO ssd_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Ki ait te mbolŋge Suŋgoŋge ne tumba ye wai mbolŋge pilwa le yeŋge ne baleni sulumba ŋinfok naŋe kat puramŋgit. Taŋawi sulumba ye tane Filistia kame mbal tuku ŋgarosu taŋgine kilmba sar umaŋ agaŋmor ŋguikok niŋgi le nyuwaig le sine Israel mbal tuku Mbara sine ndoŋ minit ta kilke ŋakmba nane katesewamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Suŋgo nu kame bagimbi mbanduwaŋmbi nuŋe mbal muskil kile-tidiŋge ndaniŋgit tuku ta maŋgur suŋgo te nane katesewamŋgaig. Nu nuŋe saŋgri tambi ndo kame bumba tane ŋakmba kilmba sine wai mbolŋge patinuŋgat ŋga Goliat sana. ");
INSERT INTO ssd_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Taŋamba sana le Goliat ndek dirka David tugum ilna le David nu pitik ndo pinderka Filistia taŋgo ta tugum kina sulumba ");
INSERT INTO ssd_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","nuŋe pale fat sinam ta wai sirmba ndame ande tumba nuŋe sikpir ta mbolŋge pilna sulumba kuilkuilŋga saŋgrimba bukŋgina le ndame taŋge ka Filistia taŋgo ta tuku tumail pasinu kat fetka sinam kina le nu ndeka kummba truk kina. ");
INSERT INTO ssd_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","David nu kame bagi kugatok ta nu nuŋe sikpir le ndame tambi ndo Goliat balena sulumba ");
INSERT INTO ssd_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","pinderka ka nu tugum taŋge tiŋga Goliat nu nuŋe kame bagi ta gomba tumba ŋinfoknu kat purna le kumna. Kile Filistia mbal naŋgine kame gabat ta kumna le kaŋgermba nane drumba kua ka kinaig. ");
INSERT INTO ssd_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Kua ka kinaig le Israel Yuda kame mbalŋge nane Filistia mbal ta wika raumba kogroŋka bale farmba kinaig. Nane Saraim kambim tuku ndin ta dubimba kinaig ka ka Gat tumbraŋ Ekron tumbraŋ fonde malaŋga tugum taŋge kusrekinaig. ");
INSERT INTO ssd_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Kusrekinaig sulumba luka pro Filistia kame kuasmbi tuku agaŋ ndende kusreka kua kinaig ta nane kumba agaŋ ndende ta ŋakmba yomba kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Kilmba kinaig le David ndek Goliat tuku gabat ŋinfok kat purmba tumba Yerusalem kina sulumba Goliat tuku kame agaŋ ndende ta kilmba ka David nuŋe baibai sinam taŋge patikina le minnaig. ");
INSERT INTO ssd_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","David nu Filistia taŋgo ta tuku kame kina le Saul nu kame gabat Abner kusnana: Kiŋo mo si ima tuku kiŋo ŋgina le Abner ndek nu sana: O gabat suŋgo, sonndo son nu ima tuku kiŋo ta ye gilai ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Taŋakina le gabat suŋgo Saulŋge nu sana: Ne kaye ka katesewa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","David nu Goliat tuku gabat biyam biyam prona le Abner ndek nu tumba Saul sota kinaik ka nu tugum pronaik. ");
INSERT INTO ssd_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Pronaik le nu ndek David kusnana: Kiŋo mo, ne ima tuku kiŋo ŋgina le nu ndek lafumba sana: Ye piro taŋgo naŋe Yesi tuku kiŋo. Nu Betlehemnu ŋga Saul sana. ");
INSERT INTO ssd_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Saul nu David ndoŋ pasate deŋpurnaik le Yonatan nu David ndoŋ wamdus sailkinaik sulumba nu David tuku kume purna. ");
INSERT INTO ssd_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Taŋana le Saul nu David ŋgailka tumba nuŋe wande mbolŋge pilna le nu maŋ luka mam nuŋe sota nda kina. ");
INSERT INTO ssd_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Taŋamba minna le Yonatan nu David tuku kume purmba nu ndoŋ pasa katmba wamdus ulendinaik sulumba ");
INSERT INTO ssd_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Yonatan ndek nuŋe tawi kuen silikina ta paska David tuna sulumba nuŋe kame agaŋ silikanu, kame bagi, tui paŋgar, let turmba kilmba David kile-tuna. ");
INSERT INTO ssd_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Saul nu David kukulanu ta nu kumba kame bumba ŋgueu mbal kilmba bale farniŋganu. Taŋamba kumba minna le Saulŋge nu tumba kame kuasmbi ande tuku gabat minwa ŋga pilna le Saul tuku kame kuasmbi Israel taŋgo pino ŋakmba nane gare-garekinaig. ");
INSERT INTO ssd_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","David nu Filistia mbal tuku kame gabat ta balena le Israel kame mbal nane Filistia ndoŋ kame bumba nane bale farka luka ilmba minnaig le pino kame ŋakmba tumbraŋ mindek Israel sinamŋge nane gare-gareka kupesmba mune ninde lika tambariŋ katniŋmba naŋgine gabat suŋgo Saul ndinŋge te-silikam kinaig. ");
INSERT INTO ssd_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Pino kame ta mune ulmba sakinaig: Saul nu ŋgueu mbal 1,000 bale farkina le David nu ŋgueu mbal 10,000 bale farkina ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Taŋakinaig le Saul nu mune ta ismba gubra torna sulumba nuŋe wamdusmbi sakina: David nu taŋgo 10,000 bale faranu ŋgade sulumba ye taŋgo 1,000 ndo bale faranu ŋgade. Mine minemba nane nu tumba naŋgine gabat suŋgo palmbimŋgaig ŋga idusna sulumba ");
INSERT INTO ssd_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","nu David tuku gubra tumba tira dirka minna. ");
INSERT INTO ssd_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Kinymba mafena le Kuateŋge guwa ŋayonu pilna le pro Saul tuku wamdus ŋginŋgan serna le nu wi kagru-kagrumba mbanduwaŋ gomba biyna le David nu nuŋe gita ta tumba mara mindek usremba minna taŋamba nu katna. ");
INSERT INTO ssd_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","Taŋana le Saul ndek nuŋe wamdusmbi sakina: Ese. Kile ne yeŋge kair turnamŋgit ŋga mbanduwaŋ kuanyiŋgina kande David nu lo silina le maŋ ande gomba tumba kuanyiŋgina kande ta mata nu lo silina le mbarna. ");
INSERT INTO ssd_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Saul nu wam ta kaŋgermba Suŋgo nu David sinzaŋmba ye ŋgumneyate ŋga idusmba nu David tuku kuru-kurukina. ");
INSERT INTO ssd_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Ta tuku Saul nu David nuŋe wande mbolŋge mine ndakuwa ŋga nu pilna le ka kame kuasmbi 1,000 tuku gabat minna sulumba David nu kame kuasmbi ta kilmba ŋgueu mbal ndoŋ kame ulmba likina. ");
INSERT INTO ssd_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Taŋamba likina le Suŋgo nu David sinzaŋ mayena le wam ŋakmba kanu ta pro mayenaig le ");
INSERT INTO ssd_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Saul nu kaŋgermba David tuku kuru-kurukina. ");
INSERT INTO ssd_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Taŋana le nane Israel kuasmbi Yuda kuasmbi nane David kame gabat minmba kame ulmba likina ta kaŋgermba nu tuku nyu payamkinaig. ");
INSERT INTO ssd_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Taŋamba minnaig ma ma ait ande Saul ndek David sana: Ne mara mindek ye tuku piro taŋgo minmba kame mbol saŋgri tiŋga Suŋgo tuku nyu mbolŋge ŋgueu mbal ndoŋ kame bumba mina ta ye yiŋe kulim mulum Merab ne tanmbimŋgit ŋga sana. Saul nu David balewam fugumba kame mbolŋge Filistia mbalŋge balewaig ŋga David taŋamba sana. ");
INSERT INTO ssd_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Sana le David ndek nu tuku pasa lafumba sakina: Ye taŋgo nyu kugatok. Ye tuku tugu mata nane Israel ŋgamukŋge nane nyu kugatok tukunu ye kulim naŋe ta tam kumuŋ kuga ŋgina ta Saul nu dirnaŋga sakina: Kuga. Ne yiŋe kulim mulum ta tamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Taŋamba minnaig ma ma nane muŋgu kilam tuku ait madina ta ka kumuŋgina le Saul ndek kulim nuŋe mulum Merab tumba David tuwe ndaka mbilmba Meholanu taŋgo Adriel tuna. ");
INSERT INTO ssd_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Taŋana le Saul tuku kulim nuŋe ande nyunu Mikal nu ndek David tam tuku torna le nane ka Saul sanaig le ismba ta maye ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","ndek idusna: Ye Mikal tuwi le nu pinonu tumba Filistia mbal ndoŋ kame bumba tumailam kuwa le balewaig ŋga idusmba nu David sana: Ne yiŋe kulim mulum tam mbulna tukunu kile kulim ande te ne pinonu ta ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Taŋakina sulumba nu nuŋe piro mbal wika saniŋgina: Tane ka David siŋsiŋndo te-minyomba sawap: Gabat suŋgo nuŋe piro mbal mata nane ne tuku wamdus gare ŋak. Ta tuku ne Saul kulim nuŋe pinonu ta. Tane ka taŋamba David sawap ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","nane ka David sanaig kande nu nane tuku pasa pitaimba saniŋgina: Ye taŋgo ande nyu ŋak ŋga idusmba gabat suŋgo tuku kulim nuŋe tam tuku wam sa kuaki ŋgade e? Ye taŋgo ŋai ŋguesuk teŋen nde nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Taŋakina le Saul tuku piro taŋgo kame luka ka David mbulmba sakina ta Saul kubeu tunaig le ");
INSERT INTO ssd_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","Saul maŋ ndek nuŋe piro mbal kukulniŋmba saniŋgina: Tane ka teŋenmba David sawap. Gabat suŋgo nu ne agaŋ ndindombi ndo pino piyawam tuku sakat ta teŋenmba. Ne ka nu tuku ŋgueu mbal mbar lafuwam tuku Filistia taŋgo 100 bale farka nane tuku nduwa ŋgaro kugerka kilmba nu tugum prowa ŋga David sawap ŋgina. Saul nu idusmba David nu ka Filistia mbal ndoŋ kame bumba Filistia mbalŋge balewaig le kumwa ŋga idusmba nu piro ta David tuna. ");
INSERT INTO ssd_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Taŋana le piro taŋgo kame maŋ ka David kubeu tunaig le nu gabat suŋgo tuku kulim ta tam tuku wokina. Saul nu David ait tuna ta kile ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","nu aŋge suk nuŋe kame kuasmbi kilmba ka Filistia taŋgo 200 bale farniŋmba nduwa ŋgaro naŋgine kugerka kilmba ka gabat suŋgo Saul tuna. Taŋana le nu ndek kulim nuŋe Mikal tumba David tuna le pinonu tina. ");
INSERT INTO ssd_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Wam ta mbolŋge Saul nu katesemba sakina: Suŋgo nu kile David ndoŋ minit ŋgina. Saul tuku kulim nuŋe Mikal mata David tuku kume purna le ");
INSERT INTO ssd_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","Saul nu David tuku kuru kuru mayemba nu ndoŋ ŋgueu ŋak minmba minna. ");
INSERT INTO ssd_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Filistia mbal tuku kame gabat sugo sugo nane pro Israel mbal ndoŋ kame buwanu ta David nuŋe kame kuasmbi ndoŋ nane suŋgomba bale faranu. Saul tuku kame kuasmbi nane suŋgomba nda bale faranu. Ta tuku nane taŋgo pino ŋakmba David tuku nyu ndo payamkinaig. ");
INSERT INTO ssd_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Saul nu David balewam tuku wamdusna sulumba nuŋe piro taŋgo kame kiŋo nuŋe Yonatan nane saniŋgina ta Yonatan nu David tuku kume purna tukunu ");
INSERT INTO ssd_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","nu ka David kila samba sakina: Mam nu ne balenam sakate tukunu ne indole maratukuk tiŋga siŋsiŋndo kaye ka ma kuirok ande piro mbolŋge kaŋgermba kuirka le ");
INSERT INTO ssd_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","sile mam ndoŋ kumba ne kuirkamŋgat ma ta tugumŋge tiŋga ye mam ne tuku sawi le nu ne mbolŋge ame maŋau kam sakuwa ndeta ye ne sanamŋgit ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","David nu taŋamba kuirkam kina le Yonatan mam nuŋe ndoŋ pasata pasata kinaik ta Yonatan nu David tuku maŋau mayenu ke likina ta tuku mam nuŋe sana: Mam, ne naŋe piro taŋgo David ŋayo sili ndamba maŋau ande ke ndaka. Ta ndaŋam? Nu ne mbolŋge mbar ande ke ndakina. Nu maŋau ŋakmba kina ta nu ne turnumba ke likina sulumba ");
INSERT INTO ssd_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","nu nuŋe kumam tuku idus ndamba Filistia taŋgo ta balena le Suŋgoŋge sine Israel mbal Filistia mbal tuku wai mbolŋge kile-lukina le ne kaŋgermba gare-garekina. David nu mbar ande ke ndakina ta ne ndaŋam tuku ake sinaŋ nu tuku ndare kutuwam sakate ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Saul nu Yonatan tuku pasa ismba nu pasa saŋgri pilemba sakina: Suŋgo abo tugu ŋak nu tuku nyu mbolŋge ye siŋka saket. Ye David balewe nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Taŋakina le Yonatan nu kumba David wikina le prona le pasa ŋakmba mam nuŋe sakina ta nu kubeu tuna sulumba nu David tumba mam nuŋe tugum kina le David nu kame gabat tuku piro amboŋga kina ta ndo kumba minna. ");
INSERT INTO ssd_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Taŋamba minnaig ma ma mara ande nane Filistia maŋ kame ilnaig le David nu nuŋe kame kuasmbi ndoŋ kinaig ka nane ndoŋ kame bunaig sulumba nane suŋgomba bale farkinaig le nane kua ka sili-silinaig. ");
INSERT INTO ssd_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Ait ande Saul nu mbanduwaŋ ande waimbi biye ŋak nuŋe wandek sinamŋge minna le Suŋgoŋge guwa ŋayonu ta maŋ pilna le Saul mbol kina. David nu taŋge gita katmba minna le ");
INSERT INTO ssd_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Saul nu David mbanduwaŋ kuanyiŋga kair turam bafuna kande David nu mbanduwaŋ ta lo silina le kair nduasena. Taŋana le David nu pinderka kilim ka pro kina. ");
INSERT INTO ssd_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Furirna le Saul nu taŋgo afu wam paguka kukulniŋmba saniŋgina: Tane ka David tuku wande kulatka minap le mafewa le maratukuk nu balewap ŋga saniŋgina le nane kinaig. Taŋanaig le piyo nuŋe Mikalŋge David sana: Furir te mbolŋge ndo ne kua kine ndaka ta indole maratukuk ne balenamŋgaig ŋga David sana sulumba ");
INSERT INTO ssd_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Mikalŋge muli ande tumba bubre malaŋga mbolŋge kusna le David nu muli ta dubimba ibeŋ ka kua ka pro kina. ");
INSERT INTO ssd_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Taŋana le piyo nuŋe nu mbara kanunu ande tumba David tuku kinyam mbili mbolŋge te-kinyena sulumba gabat tatu ande meme ŋguenumbi wakeiwanu ta tumba gabat mbolŋge pilmba tawi kaina. ");
INSERT INTO ssd_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Kile Saul tuku taŋgo kame ta David tam pronaig kande ");
INSERT INTO ssd_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","piyo nuŋeŋge nane saniŋgina: Nu guaze ŋak ŋgina le nane luka kumba Saul kila sanaig le nu nane maŋ kukulniŋmba saniŋgina: Tane luka kape sulumba David mbain ŋak tumba yalpe le ye nu balewi le kumwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Taŋakina le nane luka kinaig sulumba wandek sinam kumba mbain mbol mambilnaig kande mbara kanunu meme ŋguenu gabat mbolŋge pilna ta mbain mbolŋge minna le kaŋgernaig. Kaŋgernaig sulumba nane luka kumba Saul sanaig le ");
INSERT INTO ssd_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","nu ndek Mikal wika kusnana: Ndaŋam saka ne ye yabriyumba yiŋe ŋgueu taŋgo ta kaŋger ndowat le kua ka pro ket ŋgina le Mikal nu pasa lafumba sana: Nu ye sayina ye nu turi le kua kine ndakuwa ta nu ye baleyam sakina. Taŋakina le ye nu turen le pro kina ŋga mam nuŋe sana. ");
INSERT INTO ssd_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","David nu kua ka kina ka Rama tumbraŋŋge Samuel te-silikumba maŋau kame Saulŋge nu mbol kina ta kubeu tuna le Samuel nu ismba David ndoŋ kinaik ka Nayot tumbraŋŋge minnaik. ");
INSERT INTO ssd_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Taŋge minnaik le taŋgo afuŋge pro Saul sanaig: David nu Nayot tumbraŋ Rama patumba taŋge minit ŋga Saul sanaig le ");
INSERT INTO ssd_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","Saul ndek taŋgo afu kukulniŋgina le David biye tiwam kinaig kande tuan taŋgo kuasmbi ande Samuel dubimba pasa yeki yeki kuklimba minnaig le kaŋgerkinaig. Taŋanaig sulumba taŋgo kame ta Kuate tuku Guwaŋge wamdus niŋgina le nane mata pasa yeki yeki kuklimba minnaig. ");
INSERT INTO ssd_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Taŋamba minnaig le Saul nu isna sulumba nu maŋ taŋgo afu kukulniŋgina le kinaig ta nane mata Kuate tuku Guwaŋge wamdus niŋgina le pasa yeki yeki saka minnaig. Taŋanaig le Saul nu maŋ lato taŋgo kuasmbi ande kukulniŋgina le kinaig ta nane mata wam ndui ta ndo kinaig. ");
INSERT INTO ssd_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Taŋanaig le Saul nuŋe miroŋ Rama kina ka kule burok ande Seku ma tugumŋge minna ta tugum prona sulumba taŋgo afu kaŋgerka kusnaniŋgina: Samuel le David ani taŋge minik e ŋgina le nane nu sanaig: Nale Rama patumba Nayot tumbraŋŋge minik ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","nu ndin dubimba Nayot tumbraŋ ta kumba ndinŋge Kuate tuku Guwa nu mbol prona le nu ndin dubimba kumba pasa yeki yeki kuklimba kina ka Nayot prona. ");
INSERT INTO ssd_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Prona sulumba nu tawi suŋgo ta paskumba Samuel tugum taŋge pasa yeki yeki kuklimba saka minna. Ki ait ta mbolŋge nu ki mbol taŋamba kinymba minna le ka furirmba maŋ mafena. Ta tuku nane kile yaba pasambi sakade: Saul nu mata tuan taŋgo ande e ŋgade. ");
INSERT INTO ssd_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Saul nu Nayot tumbraŋ prona le David nu Saul ram kua ka ma ta kusremba Yonatan sota kina sulumba sana: Ye ame maŋau mam naŋe mbolŋge mbaren le nu ye baleyam bafute e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","nu lafumba sana: Mam ne balene nda. Nu ame maŋau kam bafumba ta nu ye sayumba yabuye nda. Ta tuku ye ne sanet nu ne balene nda ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","David maŋ lato sana: Ne ye tuku kume purte ta mam naŋe nu kila tukunu ne wamdus ŋayoŋgikat ŋga idusmba ne sane nda. Suŋgo abo tugu ŋak nu tuku nyu mbolŋge ne tuku nyu mbolŋge ye siŋka sanet. Mam naŋe buk ye baleyam bafute le kamuset ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Taŋakina le Yonatan nu ndek David sana: Ye ne ndaŋndaŋmba turnam tuku saka ta ye kamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","David nu teŋenmba sana: Indole tambun kitek prote tuku ait ta ye gabat suŋgo ndoŋ isukusam tuku ta ne woka ta ye ka gutoŋ taŋge ait keŋmba kuirka minamŋgit. ");
INSERT INTO ssd_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Taŋawi le mam naŋe nane promba isukusmba minmba ye kiriŋga kusnanuwa kande ne teŋenmba sawa: Yar mindek nuŋe tugu nane promba Betlehemŋge maŋgurka atraukade tukunu nu pitik ndo kambim tuku ye sayat. ");
INSERT INTO ssd_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Taŋamba mam naŋe sawa le nu ta maye ŋguwa ta ne katesewamŋgat nu ye bale ye nda. Ko nu gubra suŋgo tuwa ndeta ne katesewamŋgat nu ye baleyam tuku wamdus kuyarkat ŋga Yonatan sana. ");
INSERT INTO ssd_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Taŋakina sulumba nu maŋ lato sana: Sile buk Suŋgo am mbolŋge pasa katmba ŋgamuŋgal ulendikeŋ tukunu ne ye gilai ndaŋga ye sinzaŋyumba mina. Ko ye mbar ande ŋak ndeta ne ye tumba mam naŋe tuku wai mbolŋge pale le bale ndayuwa. Naŋe miroŋ ye baleya ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Yonatanŋge nu sana: Ne wamdus taŋamba nda ta. Mam nu ne ŋayo silinumba balenam bafuwa le ye kamusmba ta ye ne yabune nda. Ye ne kila sanamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","David ndek nu kusnana: Indole tane isukusmba minmba ne mam naŋe ye tuku ŋga kila sawa le nu gubrambi pasa lafuwa ta imaŋge pro ye kila sayamŋgat e ŋga Yonatan sana le ");
INSERT INTO ssd_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","nu ndek David sana: Sile gutoŋ si kap sulumba pasa-pasakube ŋga nale tiŋga kinaik. ");
INSERT INTO ssd_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Nale kinaik ka gutoŋ ta promba kile Yonatanŋge David sana: Siŋgine Israel mbal tuku Mbara Suŋgo sile pasa sakamŋgik ta nu isamŋgat. Indole ko aspile ait teŋen mbolŋge ye mam ne tuku ŋga sawi le nu wokuwa ndeta ye ne tuku pasa palmbimŋgit. ");
INSERT INTO ssd_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Ko mam nu ne ŋayo silinam bafuwa ta ye ne kila sani le ne kaye. Ye taŋa ndawi ta Suŋgo nu ye mapeye nda. Suŋgo nu mam ndoŋ minna taŋamba ndo nu ne ndoŋ mata minwa le ");
INSERT INTO ssd_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","ye kume ndaka mini kande ne ye idusyumba Suŋgoŋge sine mapesiŋgit taŋamba ye mapeya le nane ye bale ndayuwaig. ");
INSERT INTO ssd_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","Taŋamba ndo Suŋgoŋge ne tuku ŋgueu mbal ŋakmba ŋaigo siglikuwa le ne ye tuku ndare kame ndo mapeniŋmba sinzaŋniŋga ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Taŋakina sulumba Yonatan le David nakile ndare ndoŋ pasa katmba Yonatanŋge David sana: Suŋgoŋge ne tuku ŋgueu mbal mapeniŋge nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Taŋakina sulumba Yonatan nu David tuku kume purna tukunu nu David maŋ lato pasa saŋgri pilewa ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Kile Yonatan ndek David sana: Indole tambun kitek tuku pagumba nye ait ta ne isukusam pro ndawa ta mam nu wamdus suluwamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Taŋawa sulumba ne aspile maŋ ka ne amboŋga kuirkina ma ndame suŋgo Esel ŋgade ta ŋgumnemŋge kuirka mina le ");
INSERT INTO ssd_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","ye tui fatnu keŋmba ne minamŋgat ma ta tugumŋge agaŋ ande madiwanu sukmba parsiŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","Taŋamba ye kiŋo ande tui fat kame ta sotam tuku kukulmba ne katesewam tuku pasa teŋenmba sawamŋgit: Tui fat kame ta ibeŋ ta taŋge ndekaig ŋgi ndeta ne teŋenmba katesewa. Mam nu ne mbolŋge maŋau ande ke nda. Ye pasa ta Suŋgo abo tugu ŋak nu tuku nyu mbolŋge sanet. ");
INSERT INTO ssd_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Ko ye kiŋo ta sawamŋgit: Tui fat kame ta o kasom siŋge ndekaig ŋgi ndeta ne ma ta kusremba kua kaye. Suŋgo nu ne kukulnuwa le ma ta kusremba pro kambim tuku ŋga sanate ŋga katesewamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Sile pasa katmba saŋgri pilewik ta Suŋgoŋge kaŋgerat. Nu mara mindek sile ndoŋ minamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Kile David nu kina ka ma gutoŋ taŋge kuirkina. Kuirka minna le tambun kitek prona le Saul nu isukusam promba ");
INSERT INTO ssd_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","nuŋe mara mindek minyokanu mbili kair gemmba ta tumba minyokina. Taŋana le Yonatan nu tiŋgina le Abner pro Saul gemmba minyokina. David tuku mbili ta ndo ake minna ta ");
INSERT INTO ssd_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Saul nu ait ta mbolŋge nu tuku kusna ndaŋgina. Nu teŋenmba idusna: David nu wam ande Suŋgo am mbolŋge mbarmba nu purfeŋnu kuga tukunu pro ndawat ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Taŋamba idusmba minna le tambun kiteknu tuku ait arnu mbolŋge David nu maŋ isukusam nda prona le Saulŋge kiŋo nuŋe Yonatan kusnamba sakina: Ndaŋam tuku Yesi tuku kiŋo ta kubele kite mata sine ndoŋ isukusam pro ndawat ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Yonatanŋge mam nuŋe tuku pasa lafumba sana: Nu Betlehem kambim tuku ye dirnaŋga kusnayina sulumba ");
INSERT INTO ssd_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","sakina: Yiŋe abaŋge sine Betlehemŋge maŋgurka atraukam tuku pasa pilna tukunu ne ye tuku gulab mayenu ndeta ne ye kaye ŋga le ye yiŋe aba kame sota ka ŋgina. Wam ta mbolŋge nu sine ndoŋ isukusam pro ndawat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Taŋakina le Saul nu Yonatan tuku gubra torna sulumba sana: Ne ma ŋgamukok kutu ande. Ne Yesi tuku kiŋo ta ndoŋ gulab mayete ta ye kila. Ne naŋe wam ta mbolŋge ndo tale ina naŋe ndoŋ kiko tamŋgaik ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","sakina: Yesi tuku kiŋo ta minwa ta ne gabat suŋgo mine nda. Ta tuku ne taŋgo afu kukulniŋga le kuwaig ka nu tumba prowaig le ye nu balewi ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Yonatan nu pasa lafumba mam nuŋe sana: Nuŋge ame maŋau mbarna le ne nu balewam sakate ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Saul nu nuŋe mbanduwaŋ tumba Yonatan nduasewam tuku kuanyiŋgina sulumba ndaflona. Taŋana le Yonatan nu mam nuŋe David balewam tuku wamdus suŋgokanu ŋak ta katesena sulumba ");
INSERT INTO ssd_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","nu gubra tormba isukusam tuku mbili ta kusremba kilim kina. Tambun kiteknu tuku ait arnu ta mbolŋge nu isukuse ndaka minna le ka furirna. Ta ndaŋam? Mam nuŋe David kiko pilena le nu ta tuku wamdus tatrukina le isukusam mbulna. ");
INSERT INTO ssd_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Mafena le maratukuk tiŋga Yonatan nu nakile pasa katnaik ta dubimba kiŋo ande tumba David sota ma gutoŋ ta kinaik ka ");
INSERT INTO ssd_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","ma gutoŋ taŋge Yonatanŋge kiŋo ta sana: Ye tui fat parsiŋgi le o si ta kuwaig kande ne pinderka ka sota ŋgina. Taŋakina le kiŋo ta pinderka kumba minna le nu lukamba mbol mbol tui fat ande parsiŋgina le simŋge ndekina. ");
INSERT INTO ssd_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Kiŋo ta nu kina ka tui fat ndekina magot ta tugumŋge tiŋgina le Yonatan ndek wika sana: Dir dir si kaye. Tui fat ta o si tamŋge ndekat ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Yonatan nu maŋ lato kiŋo ta wika sana: Ne ake taŋge tiŋ mine ndaka. Pitik kaye ŋgina le kiŋo ta ka tui fat tumba luka nuŋe gabat tugum kina. ");
INSERT INTO ssd_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Kiŋo ta nu Yonatan maŋau kina ta tuku tugu katese ndana. Yonatan le David nakile ndo kila. ");
INSERT INTO ssd_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Kile Yonatanŋge kiŋo ta tui paŋgarnu fatnu kame ta turmba kile-tumba kukulna le kilmba luka tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Kiŋo ta luka tumbraŋ kina le David nu ndame maŋgur ŋgumnemŋge kuirka minna ta tiŋga kilim ka promba Yonatan tugum taŋge dagol tidroŋga lokam keŋna. Taŋamba nu tiŋga Yonatan mumumba nale muŋgu mumuka malmbikinaik. David nu wamdus tatruka suŋgomba malmbikina le ");
INSERT INTO ssd_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Yonatan ndek nu sana: Sile Suŋgo tuku nyu mbolŋge pasa saŋgri pilekeŋ ta Suŋgo nu sile ndoŋ sikile ndare kame ta ndoŋ minmba minamŋgat tukunu ne ŋgamuŋgal mukuk wamdus bulok ŋak kaye ŋgina le David nu tiŋga kina le Yonatan nu luka nuŋe tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Kile David nu kua ka pris Ahimelek sota Nob tumbraŋ kina ka ta prona le nu David kaŋgermba kuru-kuruka nu tugum kumba kusnana: Ne ndaŋam naŋe mata te prote e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","David nu lafumba sana: Gabat suŋgo Saulŋge ye piro sat le te prowit. Nu teŋenmba ye sayat. Ye ne piro tinmba kukulni le andeŋge ise ndakuwa ŋga sayat. Yiŋe kuasmbi nane ye te-silikam kande nane ma inumŋge ye te-silikuwaig ŋga saniŋgen. ");
INSERT INTO ssd_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Kile ne bret afu ŋak ndeta ye 5 kile-sa. Kuga ndeta nyamagaŋ afu kise sa ŋga pris ta sana. ");
INSERT INTO ssd_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Taŋakina le pris ta ndek nu sana: Ye ake bret afu mine ndakade. Tukul bret Kuate am mbolŋge patikanu ta ndo minig. Ne naŋe kame taŋgo ndoŋ tane pino ndoŋ kinye ndakade kande ne bret ta kila ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","David nu lafumba pris ta sana: Ye ne yabrine nda. Sine kile pino ndoŋ kinye ndakeg. Sine ŋgueu mbal ndoŋ kame buweg ta kame mbal naŋgine kame agaŋ ndende ta turmba Suŋgo am mbolŋge purfeŋnu ndo minig. Kite sine piro ande kamŋgig tukunu sine taŋamba purfeŋnu ndo mineg ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Nyamagaŋ afu mine ndakinaig tukunu pris ta tukul bret ta kilmba David kile-tuna. Nane tuku maŋau ta bret ambokok ta kilmba kile-kasoka bret kitek kilmba Kuate am mbolŋge patikanu. ");
INSERT INTO ssd_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","Ait ta mbolŋge Saul tuku agaŋmor kulatkanu gabat Edomnu taŋgo nyunu Dowek nu atraukam tuku Suŋgo tuku Wande mbol taŋge minna. ");
INSERT INTO ssd_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Minna le David ndek Ahimelek kusnana: Ne mbanduwaŋ ande ko kame bagi ande ŋak kande ye sa. Ye gabat suŋgoŋge piro sat ta braiŋ kam tuku ŋgat le ye prepreka kame agaŋ ande te ndakit ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","nu ndek David sana: Ye kame bagi ndindo ndo minit. Ne buk Ela ma gutoŋ nziŋge Filistia taŋgo Goliat balena nu tuku kame bagi ta tumba tawimbi soŋga pris tuku tawi ŋgirpemŋge pilnaig ta ndo minit. Tamŋgat kande te-tini ŋgina le David ndek sakina: Ese. Kame bagi ta mayenu ndo kame bagi afu minig taŋaŋ kuga ŋga yaimba tumba kina. ");
INSERT INTO ssd_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Kile David nu Saul ram kua ka kina ka Gatnu gabat suŋgo Akis tugum prona le ");
INSERT INTO ssd_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Akis tuku piro taŋgo kame David kaŋgermba ka Akis sanaig: Taŋgo si Davidŋge. Nu nuŋe kilke tuku gabat suŋgo. Nane pino kame o buk nu tuku mune ulmba kupesmba sakinaig: Saul nu ŋgueu mbal 1,000 bale farniŋgina le David nu ŋgueu mbal 10,000 bale farniŋgina ŋginaig ŋga Akis sanaig le ");
INSERT INTO ssd_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","David nu pasa ta ismba gabat suŋgo Akis tuku kuru kuru mayemba ");
INSERT INTO ssd_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","nane tuku am mbolŋge nu ŋginŋgan taŋgoŋge wam kekekina sulumba nu ndo ŋginŋgan mayewanu sukmba kumba ka tumbraŋ koranu fonde malaŋga mbolŋge ma kuyir-kuyarna sulumba subal promba miŋge zizin mbolŋge kutuka ndekina. ");
INSERT INTO ssd_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Taŋana le gabat suŋgo Akis ndek nuŋe piro taŋgo kame saniŋge lika sakina: Ŋgan palmbinu te ndaŋam saka tumba ye tugum te prowaig? ");
INSERT INTO ssd_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","Tane idusde sine tuku tumbraŋ te ŋginŋgan taŋgo kugatok e ŋga maŋ ŋgan palmbinu te tumba te ta prowaig? Taŋgo te ye tuku wande mbolŋge nda palpe le minwa ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Kile David nu Gat kusremba kua ka kina ka Adulam sikar burok kumba taŋge minna. Minna le nuŋe aba kat nuŋe, nuŋe kuasmbi ŋakmba nu taŋge minna ta isnaig sulumba nane kinaig ka taŋge nu te-silikinaig. ");
INSERT INTO ssd_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Taŋanaig le taŋgo afu nane piti ŋak ŋak afu ndametiŋ kugatok afu ndagari ŋak ta nane kua ka David te-silika nu ndoŋ taŋge minnaig sulumba nu naŋgine gabat minwa ŋga madinaig. Nane kuasmbi taŋge kua ka nu ndoŋ minnaig ta ulendimba 400. ");
INSERT INTO ssd_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Taŋamba minnaig ka mara ande David ndek tiŋga Mispe tumbraŋ Moab kilke mbol kina sulumba Moabnu gabat suŋgo ta sana: Ye yiŋe ina mam kilmba pro ne tugum teŋge kusreki le minwaik le Kuateŋge ye mbol ndaŋndaŋamŋgat ta kila pili sulumba maŋ luka pro kilamŋgit ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Taŋaka sana le Moabnu gabat suŋgo nu wokina le David ndek ina mam nuŋe kilmba nu tugumŋge kusreka nu nuŋe tiŋga luka kumba ka sikar burok sinam taŋge kuirka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Taŋamba minnaig le mara ande tuan taŋgo Gad nu David tugum promba sana: Ne tiŋga sikar burok te kusremba Yuda ma tugu mbol kaye ŋgina le David nu ndek tiŋga Heret ma yamban sinam ta kina. ");
INSERT INTO ssd_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Minnaig ma ma nane afuŋge David nuŋe kuasmbi kilmba ka Heret yambanŋge minnaig ta kumba ka Saul sanaig. Sanaig le Saul ndek Gibea tumbraŋ biŋ mbol taŋge ail suŋgo ande kumnemŋge nuŋe mbanduwaŋ biye ŋak minyokina sulumba piro mbal nu laipmba minnaig ta ");
INSERT INTO ssd_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","saniŋge likina: Tane Benyamin tuku kuasmbi tane ise tiwap. Tane idusde Yesi kiŋo nuŋeŋge tane nyam piro sugo sugo grep piro sugo sugo walmba tiŋguwa sulumba kame gabat maditiŋmba kuasmbi 1,000 ko kuasmbi 100 kulatkam tuku patikamŋgat ŋga idusde e? ");
INSERT INTO ssd_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","Tane taŋamba idusnaig sulumba pasa katmba ye yiŋe kiŋo Yonatan nale Yesi kiŋo nuŋe ndoŋ wamdus ulendinaik ta ye yabuyinaig e ŋga saniŋge likina sulumba sakina: Yiŋe kiŋo nu yiŋe piro taŋgo David ndoŋ wamdus ulendinaik tukunu David kile ye ŋayo siliyam tuku ndin sotate ta tane tuku andeŋge ye idusyumba ye kila sa ndayina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Taŋakina le Edomnu taŋgo Dowek nu Saul tuku piro mbal tugum taŋge minna nuŋge ndek Saul sana: Ye Yesi kiŋo nuŋe pro Nobŋge Ahitub kiŋo nuŋe Ahimelek tugum prona le kaŋgeren. ");
INSERT INTO ssd_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","Ahimelek ndek Suŋgoŋge David sinzaŋwa ŋga yabaŋna sulumba nyamagaŋ afu kile-tumba Filistia taŋgo Goliat tuku kame bagi ta turmba David te-tuna ŋga Saul sana le ");
INSERT INTO ssd_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","nu pasa ta ismba taŋgo afu kukulniŋgina le ka Ahimelek nuŋe kuasmbi ndoŋ Nobŋge pris pirokinaig ta ŋakmba kilmba gabat suŋgo Saul tugum pronaig. ");
INSERT INTO ssd_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Kile Saul ndek Ahimelek sana: Ahitub kiŋo nuŋe, ye ne ndoŋ pasa ŋak ŋgina le nu ndek sana: O gabat suŋgo, ne saka le isi ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Saul ndek nu sana: Yesi kiŋo nuŋe ne sota kina le ne ndaŋam saka nyamagaŋ afu kile-tumba kame bagi te-tumba Kuateŋge sinzaŋwa ŋga nu tuku yabaŋna? Ne taŋana le kile nu ye ŋayo siliyam tuku tair minit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Taŋakina le Ahimelek ndek Saul tuku pasa lafumba sakina: Ne tuku piro mbal te ima David suk miŋge dubi mayete? Naŋe mbiyel naŋe nu kame gabat minmba ne kigraibka ne tuku wande mbolŋge nyu suŋgo ŋak minit. ");
INSERT INTO ssd_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","Ta tuku ye Kuate yabaŋmba nu sinzaŋwa ŋgen wam ta kitek ande ken le ne ye yiŋe kuasmbi te ndoŋ sine kilmba pasa mbolŋge patikate e? Nu ne ŋayo silinam tuku tair minanu ŋgate pasa ta sonndo ye gilai ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","gabat suŋgo nu tuku pasa ta lafumba sana: Kuga. Ne naŋe kuasmbi ndoŋ tane ŋakmba kumamŋgaig ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","nu kame mbal nane laipniŋmba minnaig ta saniŋgina: David nu ye ram kua ka kina ta nane kila ta nane ye yabuyumba nu mapenaig le kina tukunu tane Suŋgo tuku pris kame te kilmba bale farap ŋgina kande nane pris kame ta bale faram tuku kuru-kuruka mbulnaig. ");
INSERT INTO ssd_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Mbulnaig le Saul ndek Dowek sana: Ne ilmba pris kame te kilmba bale farka ŋgina le nuŋge pro Suŋgo tuku pris 85 ta ŋakmba bale farke suglukina. ");
INSERT INTO ssd_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Taŋana le Saul nu tiŋga pris kame ta tuku tumbraŋ Nob kina sulumba taŋge nu taŋgo pino, kiŋo kame, kutu amo mbolok, makau doŋki agaŋmor ŋakmba bale farmba tumbraŋ sina tumu pilna. ");
INSERT INTO ssd_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Taŋana le Ahimelek tuku kiŋo nuŋe Abiatar nuŋge ndo kua ka David sota kumba ");
INSERT INTO ssd_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","Saulŋge Suŋgo tuku pris kame bale farniŋgina wam ta kubeu tuna le ");
INSERT INTO ssd_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","David ndek nu sana: Ye pro mam naŋe tugumŋge minen sulumba Dowek taŋge minna le kaŋgermba ye buk idusen ta kile kumuŋgat. Osese. Yeŋge ne tuku ndare tuma yambarken. ");
INSERT INTO ssd_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Ta tuku ne kuru kuru ndaka. Saul nu sile balesikam tuku ndin sotate tukunu ne ye ndoŋ teŋge mina le yeŋge ne kigraibkamŋgit ŋga Abiatar sana. ");
INSERT INTO ssd_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","Taŋamba minnaig ma ma mara ande taŋgo afu nane pro David kubeu tumba sanaig: Nane Filistia mbalŋge pro Keila mbal ndoŋ kame bumba nane tuku nyamagaŋ kile-wandekkinaig ta ŋakmba kuayarmba yomba kilmba kinaig ŋga sanaig. ");
INSERT INTO ssd_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","Taŋaka sanaig le David ndek Suŋgo kusnana: Ye ka Keila mbal turka Filistia mbal ndoŋ kame buwam kumuŋ e ŋgina le Suŋgo ndek nu sana: Ta maye. Ne ka Keila mbal turka Filistia mbal bale farka ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","Taŋakina le nane David tuku kuasmbi ndek nu sanaig: Sine Yuda ma tugu te mbolŋge ŋgueu mbalŋge kugor-kugorka minig le ne ndaŋam saka kile maŋ Keila mbal turka Filistia kame kuasmbi suŋgo ta ndoŋ kame buwam sakate ŋga David sanaig. ");
INSERT INTO ssd_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","Taŋakinaig le David maŋ lato Suŋgo kusnana kande nu sana: Tiŋga Keila tumbraŋ kaye le yeŋge ne sinzaŋnumba Filistia mbal kilmba ne tuku wai mbol patikamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","Taŋaka sana le David nuŋe kame kuasmbi kilmba ka Keilaŋge Filistia mbal ndoŋ kame bumba nane suŋgomba bale farnaig sulumba nane tuku agaŋmor ŋakmba yaika kilmba Keila mbal taŋgo pino ŋakmba kile-luka kilna. ");
INSERT INTO ssd_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","Abiatar nu o buk pris tuku tawi ta tumba kua ka David sota kina. ");
INSERT INTO ssd_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","Kile David nu Keilaŋge minna pasa ta nane afu kinaig ka Saul sanaig le nu ndek sakina: Ese. Kile Kuateŋge nu tumba ye tuku wai mbolŋge palmbimŋgat. Nuŋe miroŋ tumbraŋ suŋgo koranu ta sinam kina ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","Saul ndek nuŋe kame kuasmbi kilmba David tuku kuasmbi kugorkam Keila kinaig. ");
INSERT INTO ssd_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","Saul nu David balewam kina ta David sanaig le isna sulumba nu pris Abiatar wika sana: Naŋe tawi ta tumba yale ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","Abiatar nu pris tuku tawi ta tumba prona le David ndek yabaŋmba sakina: O siŋgine Israel mbal tuku Mbara Suŋgo, Saul nu piro taŋgo naŋe ye tuku ŋga Keila tumbraŋ te ŋayo siliwam tuku ilit ŋgaig le isit. ");
INSERT INTO ssd_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","Ta tuku ne ye saya. Tumbraŋ te tuku taŋgo kameŋge ye tumba Saul tuku wai mbol palmbimŋgaig e? Saul nu ye sota te ta prowamŋgat ta son sakaig e? O siŋgine Israel mbal tuku Mbara Suŋgo, ne ye kila saya ŋgina le Suŋgo nu sana: Au. Nu prowamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","Taŋakina le David maŋ ndek Suŋgo kusnana: Tumbraŋ te tuku taŋgo kameŋge ye yiŋe taŋgo kame te ndoŋ sine kilmba Saul tuku wai mbol patikamŋgaig e ŋgina le Suŋgo nu sana: Au. Nane taŋawamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","David Suŋgoŋge taŋamba sana le nu tiŋga nuŋe taŋgo kuasmbi 600 ta kilmba Keila tumbraŋ ta kusremba nane duŋe fumbe ŋakmba mbol kinenumba minnaig le Saul nu David kua kina pasa ta ismba nu nane maŋ yoker ndakina. ");
INSERT INTO ssd_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","David nu kua ka kina ka Sif tuku ma taknu ma baknu taŋge kuirka minna. Saul nu mara mindek David sota minna ta Kuate nu David sinzaŋmba nu tumba Saul tuku wai mbol pile ndakina. ");
INSERT INTO ssd_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","David nu kina ka Sif ma baknu Horesŋge minna le Saul nu balewam tuku sota minna ta David sanaig le isna. ");
INSERT INTO ssd_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","Taŋana le Yonatan nu kina ka Horesŋge David te-silika Suŋgoŋge ne kulatkate ŋga nu wamdus saŋgri pilena sulumba ");
INSERT INTO ssd_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","sakina: Ne kuru kuru ndaka. Mam nu ne ŋayo siline nda. Mine minemba ne sine Israel mbal tuku gabat suŋgo mina le ye ne gemnu minamŋgit ta mata mam nu kila ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","Taŋakina le nale Suŋgo am mbolŋge pasa katmba wamdus ulendinaik. Taŋamba David nu Horesŋge minna le Yonatan maŋ luka nuŋe tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","Kile Sifnu taŋgo kame afu kinaig ka Gibeaŋge Saul sanaig: O gabat suŋgo, ne isa. David nu kile sine tuku ma tugu Horesŋge minit. Nu Yuda yamban Akila biŋ mbolŋge kuirka minit. ");
INSERT INTO ssd_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","Ta tuku gabat suŋgo, ne nu biye timba tam kande ne ndeka le sine ne turnumba nu biye timba tanmbimŋgig ŋga sanaig le ");
INSERT INTO ssd_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","Saul ndek nane saniŋgina: Tane ye turyumba maŋau mayenu ndo kade tukunu Suŋgo nu tane ndoŋ minwa ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","maŋ ndek saniŋgina: Tane kape sulumba ka nu minit magot ta buro-burowap. Nu taŋge minanu ŋgade ta son taŋge minit e ta kaŋgerap. Taŋgo ta nu ŋgisi-ŋgisikate tuku ŋga sayade tukunu ");
INSERT INTO ssd_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","tane ka nu kuirke likate tuku magot ta ŋakmba katese mayemba pro ye tap le tane ndoŋ kumba ka nu korkorbe le nu kua ka Yuda ma animbi kuwa ta ye ka nane ŋgamukŋge nu tamŋgit ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","Taŋakina le taŋgo kame ta Saul kusremba amboŋga naŋgine tumbraŋ Sif kinaig. David nu nuŋe taŋgo kuasmbi ndoŋ kinaig ka Maon ma baknu Yuda yamban kumam taŋge minnaig le ");
INSERT INTO ssd_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","Saul nu nuŋe kame kuasmbi kilmba David sota nane minnaig ma tambi kinaig le nane afu ka David sanaig. Sanaig le nu nuŋe taŋgo kuasmbi kilmba kua ka Maon ma baknu sikar ŋak taŋge ka minna. Taŋge minna le Saul nu ismba David dubimba kina. ");
INSERT INTO ssd_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","Saul tuku kuasmbi pro tabe dabil inum inum kinaig le David nuŋe kuasmbi kilmba tabe dabil inum inum Saul ram kua kinaig. Taŋanaig le Saul nuŋe taŋgo kuasmbi ndoŋ nane buk David tuku kuasmbi kile-fag kinaig le ");
INSERT INTO ssd_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","kile Saul tuku piro taŋgo ande tumbraŋŋge pasa tumba promba Saul sana: Filistia mbal pro sine ndoŋ kame bude tukunu ne braiŋ luka yale ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","Saul nu David yokermba minna ta kusremba nuŋe kame kuasmbi kilmba luka Filistia mbal ndoŋ kame buwam kina. (Ta tuku kile nane magot ta nyun ta Kame peukina tuku Sikar ŋgade). ");
INSERT INTO ssd_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","Taŋana le David nu ma tugu ta kusremba kua ka kina ka Eŋgedi ma taknu sikar burok sinam taŋge kuirka minna. ");
INSERT INTO ssd_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Saul nu Filistia mbal yokerka kina ka kusreka maŋ luka prona le nane afu pro nu sanaig: David nu kile ka Eŋgedi ma baknu sikar burok sinam ambeŋge minit ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Saul ndek Israel taŋgo saŋgriknu 3,000 pilemba kilmba David biye tiwam tuku ma ande nyunu Meme ŋguikok tuku Sikar ta kinaig ka ");
INSERT INTO ssd_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","sikar burok suŋgo ande tugum pronaig. Burok ta tugumŋge sipsip tuku fonde mata minnaig. David nu nuŋe taŋgo kame ta kilmba nane sikar burok ta sinamŋge kuirka minnaig. Kile Saul ndek sumbikam saka sikar burok ta sinam kina le ");
INSERT INTO ssd_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","David tuku kuasmbi taŋge David sanaig: Ese. Kile ait te mbolŋge Suŋgoŋge ne tuku ŋgueu taŋgo tumba ne wai mbolŋge pilit. Ne ame maŋau kam ndeta ka ŋga sanaig le David ndek kurauka kina ka Saul tuku tawi kuennu ta tundunnu ndo kat purmba tina ta Saul nu kamus ndana. ");
INSERT INTO ssd_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","David nu Saul tuku tawi tundunnu ta kat purmba tina sulumba nu ndaflowit a ŋga wamdus fulilka ");
INSERT INTO ssd_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","nuŋe kame kuasmbi saniŋgina: Taŋgo te Suŋgoŋge ye tuku gabat suŋgo madina tukunu ye nu balewe nda ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","David nu pasa saŋgrinu saka saniŋgina: Tane Saul bale ndawap ŋga peuniŋgina. Kile Saul nu sikar burok sinam taŋge sumbike deŋpurmba kilim ka kina le ");
INSERT INTO ssd_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","David ndek Saul ŋgumnem dubimba kilim kumba Saul wikina: O yiŋe gabat suŋgo ŋgina le Saul nu mbilkina. Mbilkina le David ndek dagol tidroŋga lokina sulumba ");
INSERT INTO ssd_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","sana: Ne ndaŋam taŋgo kame tuku yabri pasa yeŋge ne ŋayo silinam tuku sakade le nane tuku pasa ta isit? ");
INSERT INTO ssd_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Ne kile kaŋgera. Ne kite ait te mbolŋge sikar burok te sinamŋge Suŋgoŋge ne tumba ye tuku wai mbolŋge palet le taŋgo kameŋge ye ne baleni ŋga siseŋyaig ta ye ne Suŋgoŋge ye tuku gabat suŋgo madina ŋga ye nane peuniŋmba ne mapenit. ");
INSERT INTO ssd_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Mam, ne te kaŋgera. Ye ne balenam mbulmba ne tuku tawi kuen ta tundunnu ndo kat purmba tit. Ta tuku ne kaŋgermba katesewa. Ye ne mbolŋge maŋau ande ŋayonu kumba ne ŋayo sili ndanit ta ne ndaŋam tuku ye korkoryumba baleyam bafute? ");
INSERT INTO ssd_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Suŋgo sile tuku maŋau te pilewa sulumba ne ye mbolŋge maŋau kate ta lafunu ne tinwa. Yeŋge ne ŋayo siline nda. ");
INSERT INTO ssd_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Ne wa mbuŋ kame tuku wam pagu pasa ta idusa. Nane teŋenmba sakade: Taŋgo ŋayonu nu maŋau ŋaigonu ndo kate ŋgade. Ta tuku yeŋge ne ŋayo siline nda. ");
INSERT INTO ssd_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","Ne Israel mbal tuku gabat suŋgo ta ne ye ame agaŋ le ye tumba korkoryate? Ye taŋgo ŋai ŋguesuk kuga age kumak meu taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Ta tuku Suŋgoŋge sile pilesikuwa sulumba ne ye mbol mbarte ta lafunu ne tinmba ye ne tuku wai mbolŋge te-lukuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","David nu pasate deŋpurna le Saul ndek nu wika sana: O kiŋo, ta neŋge e ŋgina sulumba malmbika ");
INSERT INTO ssd_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","ndek David sana: Ye son mbar suŋgokanu ne mbol ket ta ne tiŋreknu minmba maŋau mayenu ndo ye mbolŋge kate. ");
INSERT INTO ssd_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Kite Suŋgo nu ye tumba ne tuku wai mbol palet ta ne ye mapeyumba bale ndayat. ");
INSERT INTO ssd_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Taŋgo ande nu nuŋe ŋgueu taŋgo te-silikuwa ta nu nu ake mapewa le kine nda ta ne taŋa ndawat. Ne ye mbol wam mayenu kat tukunu Suŋgoŋge ne nyaro tinwa. ");
INSERT INTO ssd_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Ye buk katesewet. Ne sine Israel mbal ŋakmba tuku gabat suŋgo minmba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Ta tuku ne Suŋgo tuku nyu mbolŋge pasa saŋgri pilewa sulumba ye tuku gageu tumu pile ndaka ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Taŋaka sana le David ndek pasa ta woka saŋgri pilena. Taŋana le Saul ndek luka nuŋe tumbraŋ kina le David nuŋe taŋgo kuasmbi kilmba naŋgine minnaig mbi sikar burok ta kinaig. ");
INSERT INTO ssd_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Taŋamba minnaig ma ma Samuel nu kumna le nane Israel mbal ŋakmba pro maŋgurka nu malmbinaig. Malmbiwe deŋpurmba nu tuku mindesiŋ tumba ka Rama tumbraŋŋge nuŋe wandembi taŋge ŋgukinaig. Ŋgukinaig le David nu tiŋga kuirka minna magot ta kusremba Paran ma baknu ta kina ka taŋge minna. ");
INSERT INTO ssd_vpl VALUES ("S125_2","010_25_2","1SA","25","2","3","Maonnu taŋgo ande nyunu Nabal nu nuŋe agaŋmor kame ta tumbraŋ suŋgo Karmelŋge kulatka minanu. Taŋgo ta nu maror taŋgo. Nu sipsip 3,000 meme 1,000 ŋak minna. Piyo nuŋe ta nyunu Abigail. Nu pino ŋgarosu mayenu raŋgun mayenu. Taŋgo nuŋe ta nu mugru sambek nu gubra te-fagna tuku. Nu Kaleb tuku ndare. Taŋgo ta tuku piro mbal nane Karmelŋge sipsip ŋguenu kugerka minnaig le nu ka nane kulatka taŋge minna le ");
INSERT INTO ssd_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","David nu Paran ma baknu taŋge minmba nane pirokinaig pasa ta isna sulumba ");
INSERT INTO ssd_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","nuŋe taŋgo 10 ta kukulniŋmba saniŋgina: Tane kape ka Karmelŋge Nabal te-silika ye tuku nyu mbolŋge gare pasa tape sulumba ");
INSERT INTO ssd_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","teŋenmba sawap: Ne naŋe gageu naŋe agaŋmor ŋakmba mage minwaig. ");
INSERT INTO ssd_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","Tane kile sipsip ŋguenu kugerka minig pasa ta David nu isna. Sine buk naŋe piro mbal ndoŋ minmba nane sipsip kulatkinaig le sine Karmelŋge nane ndoŋ gulab mayemba mingeŋ. Nane tuku agaŋmor inum kuayarmba ŋgisi ndageŋ. ");
INSERT INTO ssd_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","Ne naŋe piro taŋgo ta kusnaniŋga ta nane son ŋgamŋgaig. Ta tuku ne kite pagumba nye suŋgo ta David nu isat sulumba sine kukulsiŋgat. Ne nyamagaŋ afu minig ndeta afu sine siŋmba afu David tuku patika le kilmba kaŋgig. Tane taŋamba ka Nabal sawap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","David tuku taŋgo kame ta ka David wam pagukina taŋamba ndo Nabal sanaig sulumba pasa lafunu isam tuku tair minnaig kande ");
INSERT INTO ssd_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","Nabal nu David tuku taŋgo kame ta teŋenmba saniŋgina: Yesi tuku kiŋo nuŋe David nu gabat suŋgo ndaŋ ndaŋ le ye nu nyamagaŋmbi turam tuku ŋga sakade. Kile piro taŋgo suŋgomba naŋgine gabat ram kua ka duŋe pisnemba minig. ");
INSERT INTO ssd_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Ndaŋam tuku tane bret kule agaŋmor ndemnu yiŋe piro mbal tuku kuanekit te kilmba ma biri sambek tane tiŋgam tuku sakade ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Taŋakina le David tuku kuasmbi nane luka kumba ka Nabal nane saniŋge likina taŋamba David kubeu tunaig le ");
INSERT INTO ssd_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","David ndek nuŋe taŋgo kame ta saniŋgina: Tane tiŋga kame bagi kilap ŋgina sulumba nu tiŋga nuŋe kame bagi tumba kame kambim tuku kuanekina. Taŋamba nu nuŋe taŋgo 400 kilmba kame kina le taŋgo 200 kusrekina ta nane agaŋ ndende kulatka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","Kile Nabal tuku piro taŋgo ande kina ka Nabal piyo nuŋe Abigail sana: David ma baknu taŋge minmba nuŋe taŋgo afu kukulniŋgat le pro siŋgine gabat gare pasa tawig le nu nane kasurniŋmba pitaikat ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Abigail sana: Taŋgo kame ta sine ndoŋ mine mayegeŋ. Sine sipsip kulatka mingeŋ ta nane sine kulat magekinaig le agaŋmor inum ŋgisi ndakina. ");
INSERT INTO ssd_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Sine nane tugum taŋge sipsip kulatka mingeŋ ta nane mara mara sine kile-kogorka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Ta tuku ne isa. Kile David nuŋe taŋgo kame ndoŋ promba sine tuku gabat nuŋe gageu ndoŋ bale faramŋgat. Nabal nu taŋgo ande gubra te-fagte tuku. Sine nu sabe ta nu sine tuku pasa ise nda. Ta tuku ne kile ndaŋndaŋamŋgat e ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Taŋakina le Abigail nu pasa ta ismba pitikndo tiŋga nyamagaŋ kuaneka bret 200 kilmba grep kule armba agaŋmor ŋgaronumbi tolniŋganu ta kilmba sipsip kuapikanu 5 kilmba wit pasokanu afu kilmba bret foŋfoŋ 100 grep mbilmba pasokanu ŋak ta kilmba fik kareŋganu 200 kilmba nyamagaŋ ta ŋakmba doŋki afu mbol patikina. ");
INSERT INTO ssd_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Taŋamba nu siŋsiŋndo taŋgo nuŋe kila sa ndamba nuŋe piro taŋgo afu kukulniŋmba saniŋgina: Tane amboŋga silap. Ye tane ŋgumnem dubiket ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","Nane kine sulunaig le Abigail nu ndek doŋki ande poŋga kina ka te-tirmba kumba minna sulumba David nuŋe kame kuasmbi ndoŋ nane buk tabe ta poŋga mbumba minnaig le kaŋgerkina. ");
INSERT INTO ssd_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","David nu wamdusmbi sakina: Ndaŋam saka ye taŋgo ta tuku agaŋmor nuŋe duŋe ŋgamu taŋge kulat mageken le inum ŋgisi ndakina. Ye nu mbol maŋau mayenu ken ta nu lafumba ye kiko pileyat. ");
INSERT INTO ssd_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Ta tuku kite ye nuŋe taŋgo kame nuŋe gageu ta ŋakmba bale far suglukamŋgit. Kuga ta Kuateŋge yiŋe ŋgueu mbal mapeniŋge nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Kile Abigail nu David kaŋgermba nuŋe doŋki mbol pateŋga ibeŋkina sulumba David tuku kupe tugum taŋge dagol tidroŋga ");
INSERT INTO ssd_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","lokina sulumba David sana: O taŋgo suŋgo, ye wam mbarit ta tuku ye ne ndoŋ pasa ŋak. Ye saki le ne isa. ");
INSERT INTO ssd_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Ne Nabal tuku pasa isat ta tuku gubra ndata. Nu mugru sambek nu gubra te-fagte tuku. Nu tuku nyu tugunu ta ŋginŋgan. Taŋamba ndo nuŋe maŋau nuŋe nyu ta dubite. Ne naŋe piro taŋgo kukulniŋgat le prowaig ta ye nane kaŋger ndakit. ");
INSERT INTO ssd_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","Ne isa. Suŋgoŋge ne peu ndanat kande ne taŋgo ta tuku mbar ta lafumba nu buk balewat kande. Ta tuku Suŋgo abo tugu ŋak nu tuku nyu mbolŋge ne naŋe nyu mbolŋge ye pasa saŋgrinu saket. Suŋgoŋge ndo ne tuku ŋgueu mbal ŋakmba kilmba ŋaigo siglika Nabal mbol mata taŋamba kuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","Taŋaka Abigail maŋ lato sana: O taŋgo suŋgo, ne garenuwa ŋga nyamagaŋ kilmba prowit te naŋe taŋgo kuasmbi te niŋga sulumba ");
INSERT INTO ssd_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","naŋe piro pino ye tuku mbar te ŋgilaiŋga. Ne mara mindek Suŋgo tuku ŋgueu mbal ndoŋ kame bumba ne mbar ande ke ndakate tukunu Suŋgoŋge ne gabat suŋgo pilwa le minmba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","Taŋgo ande pro ne ndoŋ kame saka ne balenam bafuwa ta Suŋgoŋge ne kigraibka kulat mayenumba ne tuku ŋgueu mbal kilmba sikpirmbi ndame bukŋgade le kinit taŋaŋ kile-pankamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","Suŋgo nu ne mbolŋge wam magenu kam sakina ta ŋakmba ne mbol kuwa le ne sine Israel mbal tuku gabat suŋgo minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","Ta tuku ne ake sinaŋ Nabal tuku mbar lafumba nu tuku ndare kutuwa ta ne gabat suŋgo mina sulumba naŋe mbar ta idusmba wamdus pitinuwa le kikotikat. Suŋgo nu ne sinzaŋnuwa le piro pino naŋe ye idusya ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","Taŋakina le David ndek nu sana: Israel mbal tuku Mbara Suŋgoŋge ne kukulnat le pro ye ndinŋge te-silikat. Ta tuku sine nu tuku nyu te-duŋgube ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","nu ndek sakina: Ne tuku wamdus mayenu taŋge taŋgo ta tuku mbar nu tuku ndare ake sinaŋ kutuwikit ŋga ne ye peuyat. Ta tuku Suŋgoŋge ne nyaro tinwa. ");
INSERT INTO ssd_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","Israel mbal tuku Mbara Suŋgo abo tugu ŋak nuŋge ye peuyat. Ye nu tuku nyu mbolŋge sanet. Ne ndinŋge ye te-sili ndakat kande indole maratukuk Nabal tuku kuasmbi inum mine ndakate kande ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","Taŋakina sulumba David nu Abigailŋge nyamagaŋ kilmba prona ta yaimba sana: Kile ne wamdus bulok luka naŋe wande mbol kaye. Ne tuku pasa maŋau mayenu ta mbolŋge ne ye muku seryate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","Taŋakina le Abigail luka taŋgo nuŋe sota kina ka tumbraŋ prona kande Nabal nu pagumba nye suŋgo gabat sugoŋge pagumba nye sugokade taŋamba kina sulumba nu kule nyumba gare-gare suŋgokumba minna le Abigail nu pasa pasa ndana le ka mafena. ");
INSERT INTO ssd_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","Mafena le Nabal nu kule nyumba ŋginŋgankina ta ka purfena le piyo nuŋe ndek wam kame prowe likinaig ta kubeu tuna. Kubeu tuna le Nabal nu pirerek purka kumaknu suk ndekina. ");
INSERT INTO ssd_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","Taŋamba minna ma ma ait 10 kuganaig le Suŋgoŋge Nabal balena le kumna. ");
INSERT INTO ssd_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","Kumna le David nu pasa ismba sakina: Kile ye Suŋgo tuku nyu te-duŋget. Nuŋge Nabal ye kiko pileyina ta lafuwat. Suŋgoŋge nuŋe piro taŋgo nuŋe ye peuyina le maŋau ŋayonu ke ndaken. Nuŋe mbar ta nuŋe miroŋ nu kurau tawet ŋgina. Taŋakina sulumba David ndek taŋgo afu kukulniŋgina le ");
INSERT INTO ssd_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","nane ka Karmelŋge Abigail sanaig: Sine Davidŋge ne pinonu tam tuku sine kukulsiŋgat ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","pino ta pasa ta ismba tiŋga dagol tidroŋga loka sakina: Ye nu tuku piro pino. Ye piro taŋgo kame tuku kupe minyaŋgamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","Taŋakina sulumba Abigail nu pastiŋga nuŋe piro pino 5 kilmba nuŋe doŋki tumba poŋga David tuku piro taŋgo dubika kinaig. Kinaig ka David tugum prona le Davidŋge pinonu tina. ");
INSERT INTO ssd_vpl VALUES ("S125_43","010_25_43","1SA","25","43","44","David nu o buk Yesrelnu pino Ahinoam tina sulumba ŋgumneŋga nu maŋ Saul kulim nuŋe Mikal tina ta Saulŋge yaimba tumba Lais kiŋo nuŋe Paltiel tuna. Taŋgo ta tumbraŋ suŋgo Galimnu. ");
INSERT INTO ssd_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Kile Sifnu taŋgo kame afu kinaig ka Gibeaŋge Saul sanaig: O gabat suŋgo, ne isa. David nu kile sine tuku kilke Yuda yamban Akila biŋ mbolŋge kuirka minit ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Saul ndek tiŋga nuŋe Israel kame kuasmbi saŋgriknu 3,000 ta pilemba kilmba David biye tiwam Sif ma baknu ta kinaig ka ");
INSERT INTO ssd_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","Akila tabe yamban ndin taŋge tumbraŋ ulnaig. David nuŋe kuasmbi ndoŋ ma baknu taŋge minmba Saul nu biye tiwam prona ta ismba ");
INSERT INTO ssd_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","nu taŋgo afu kukulniŋmba kape ka buro-burowap ŋgina le nane kurauka kinaig ta Saul pro taŋge minna le kaŋgermba luka ka David kubeu tunaig. ");
INSERT INTO ssd_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Kubeu tunaig le kile David ndek taŋgo afu kilmba Saul tumbraŋ ulmba minna magot ta kinaig sulumba Saul nuŋe kame gabat suŋgo Ner kiŋo nuŋe Abner ndoŋ kinymba minnaik le kaŋgerkinaig. Saul nu ŋgamu-ŋgamuŋge kinyna le nane kame kuasmbi nu laipmba kinynaig. ");
INSERT INTO ssd_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Taŋamba minnaig le David ndek Hitnu taŋgo Ahimelek le Abisai kusnanikina: Ima ye ndoŋ Saul tuku kuasmbi ma ulmba minig sinam nzi kaŋgik ŋgina le Abisai ndek sakina: Sile kap ŋgina. (Abisai nu Seruya tuku kiŋo nuŋe. Aba nuŋe Yoab). ");
INSERT INTO ssd_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Furirna le David le Abisai nale kurauka Saul nuŋe kuasmbi ndoŋ tumbraŋ ulmba minnaig ta ndek kinaik ka Saul kinymba minna le kaŋgernaik. Saul nu nuŋe mbanduwaŋ ta tumba gabat tatum taŋge te-timba ŋgamu-ŋgamuŋge kinyna le Abner kame kuasmbi ŋakmba nane nu laipmba kinynaig. ");
INSERT INTO ssd_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Taŋamba kaŋgerka Abisai ndek David sana: Kile Kuateŋge naŋe ŋgueu taŋgo ta tumba ne wai mbolŋge palet. Saka le nuŋe mbanduwaŋ te tumba manyub kilke turi le kumwa ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","David ndek nu peumba sana: Ne nu mba tuwe ndaka. Suŋgoŋge gabat madina ta andeŋge balewa ta Suŋgoŋge nu mapewe nda ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","sakina: Ye Suŋgo abo tugu ŋak nu tuku nyu mbolŋge ne sanet. Suŋgoŋge Saul balewamŋgat. Nu ake kumamŋgat e ko nuŋe ŋgueu mbalŋge balewaig le kumamŋgat e ta Suŋgo nuŋe ait. ");
INSERT INTO ssd_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","Suŋgoŋge gabat suŋgo madina ta ye nu balewe nda. Nuŋge ye peuyate. Sile nu tuku mbanduwaŋ murko kule te ndo kilmba kap ŋga sana sulumba ");
INSERT INTO ssd_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","David ndek mbanduwaŋ murko kule gabat tatumŋge ta kilmba Abisai ndoŋ kinaik ta taŋgo ande nale kamuska kaŋger ndakina. Nane ŋakmba Suŋgoŋge ginyum paknu niŋgina le ndo kinymba gilaiŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Kile nale nane kusreka kinaik ka ka David nu tabe inum poŋga funu mbolŋge tiŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","Abner nuŋe kame kuasmbi ta ndoŋ wika saniŋgina: Abner o. Ne ye tuku pasa isit e ŋgina le Abner ndek nu tuku miŋge lafumba sakina: Ne imaŋge gabat suŋgo wikate e ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","Taŋakina le David ndek Abner maim maim te-tumba wi kueŋka sana: Ne Israel ŋgamukŋge taŋgo nyu ŋak ŋgate ta ndaŋam saka naŋe gabat suŋgo ta kulat maye ndawat le taŋgo ande nu ŋayo siliwam sinam ket? ");
INSERT INTO ssd_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","Ne taŋamba gubat suŋgo kulatkate tuku e? Tane taŋgine gabat suŋgo Suŋgoŋge madina ta kulat maye ndawaig. Ta tuku ye Suŋgo abo tugu ŋak nu tuku nyu mbolŋge siŋka satiŋget. Tane ŋakmba kumam kumuŋ. Tane gabat suŋgo tuku mbanduwaŋ murko kule gabat tatum taŋge ta kaŋgerkap ta kile aniŋge minig e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Saul nu David tuku ŋin tugu ismba wika sakina: O kiŋo, ta neŋge e ŋgina le David ndek wika sana: Au. Yeŋge o. ");
INSERT INTO ssd_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","O gabat suŋgo, ye ame mbar ken le ne naŋe piro taŋgo naŋe ye tumba yokeryate? ");
INSERT INTO ssd_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","O gabat suŋgo, ne naŋe piro taŋgo tuku pasa te isa. Ne Suŋgoŋge kukulnat le ye ŋayo siliyam tuku ye sotate ndeta maye. Ye nu tuku atrauki le Suŋgo nu maŋ ye tuku garewa. Ko taŋgoŋge ne tuku wamdus kunde-kundenade ndeta Suŋgoŋge nane kasurniŋguwa. Nane ndaŋam tuku ye Israel kilke kusremba ka kasomok mbal tuku kilke mbolŋge naŋgine yabri mbara bariŋgi ŋga ye tumba korkoryade? ");
INSERT INTO ssd_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","Ta tuku ye Suŋgo kasomŋge mini le tane ye tuku ndare kutu ndawap. Ne sine Israel mbal tuku gabat suŋgo ta ne ye ŋai ŋguesuk kuga meu taŋaŋ baleyam tuku sota taŋgo afu tabe mbolŋge mula nindam tuku kuraukade taŋamba ne kate ŋga Saul sana. ");
INSERT INTO ssd_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Taŋakina le Saul ndek David wika sana: O kiŋo, ye mbaret. Kile ne maŋ tawok te prowa le ye ne maŋ ŋayo siline nda. Ne furir te mbolŋge ye baleyam kumuŋ ta ne ye mapeyat. Ye siŋka mbarmba ŋginŋgan maŋau ket ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","David ndek wika sana: O gabat suŋgo, mbanduwaŋ naŋe noten. Naŋe taŋgo ande kukula le pro tumba kine tinwa. ");
INSERT INTO ssd_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","Suŋgo nu taŋgo maŋau mayenu tiŋreknu kate ta lafu mayenu tuwit. Kite Suŋgo ne tumba ye tuku wai mbol palet ta ye Suŋgoŋge ne madinina ŋga ne bale ndanit. ");
INSERT INTO ssd_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","Ye ne mapenumba ŋayo sili ndanit. Taŋamba ndo kile Suŋgo ye sinzaŋyuwa le mine mayemba wamdus bulok ŋak minamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Saul ndek David wika sana: O kiŋo, Suŋgo ne nyaro tinwa le ame maŋau kam bafuwa ta kumu-kumumba alonu taŋamba prowamŋgat ŋgina. Taŋaka saka deŋpurna le David luka nuŋe kuasmbi sota kina le Saul mata mbilka luka nuŋe tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","Taŋamba minnaig ma ma David nu wamdusmba sakina: Ye te taŋge mini ta Saul nu maŋ wamdus mbilmba ye baleyamŋgat tukunu ye kua ka Filistia kilke mbol ka le kanyumwa le nu maŋ Israel kilke mbol teŋge ye sote nda ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","Taŋamba idusna sulumba David ndek tiŋga nuŋe taŋgo kuasmbi 600 ta kilmba Maok kiŋo nuŋe Akis Gat mbal tuku gabat suŋgo ta sota kambim saka ");
INSERT INTO ssd_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","nu nuŋe pino ar ta kilmba nuŋe taŋgo kuasmbi naŋgine gageu kame ta turmba kilmba kina ka Gatŋge Akis ndoŋ minnaig. (David tuku pino ar ta ande Ahinoam nu Yesrelnu. Ande Abigail Nabal tuku pino kuembol nu Karmelnu). ");
INSERT INTO ssd_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","David kua ka Gatŋge minna pasa ta Saul nu ismba nu maŋ David sote ndakina. ");
INSERT INTO ssd_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","Kile David nu Akis teŋenmba sana: O gabat suŋgo, ye naŋe tumbraŋ suŋgo sinam teŋge minet ta mayenu ndo kuga tukunu ne ye sinayumba kilke fudiŋ ande serya le ye yiŋe kuasmbi ndoŋ ka taŋge minyoki ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","Akis ndek woka tumbraŋ fudiŋ Siklak David nane minyokuwaig ŋga serna. Ta tuku kile Siklak tumbraŋ ta Yuda tuku gabat sugo naŋgine kulatka minig. ");
INSERT INTO ssd_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","David nu Filistia kilke mbol kumba minna ta yar ndindo tambun bailkamba turmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","Taŋge minna sulumba David nu nuŋe kame kuasmbi kilmba ka Gesur mbal Gisri mbal Amalek mbal nane ndoŋ kame bumba minanu. Mbal kame ta o buk ma tugu ta mbolŋge tumbraŋ ulmba minnaig tuku. Nane tuku kilke ta Sur kumamŋge kina ka Isipŋge dikŋgina. ");
INSERT INTO ssd_vpl VALUES ("S127_9","010_27_9","1SA","27","9","11","David nu nane ndoŋ kame buwanu ta nu taŋgo pino ŋakmba bale far sugluka makau doŋki kamel agaŋmor ŋakmba ta kilmba tawi mindepiye agaŋ ndende ta turmba kile-sugluka luka Akis tugum kambinu. David nu tumbraŋ kame ta ŋakmba tumu pilmba ma sina minyaŋganu. Ta ndaŋam? Taŋgo ande pro Gatŋge Akis kila sawikat ŋga nu taŋawanu. David nu Filistia kilke mbolŋge minna sulumba nu maŋau ndui ta ndo kumba minanu le Akis ndek nu kusnamba ne ka aniŋge kame ulmba prote e ŋga kusnawanu ta David ndek nu wam sisauka sawanu: Sine ka Yudaŋge o ka Yerakmelŋge o ka Ken ma ki prote kumam taŋge kame ulmba prowet ŋga Akis yabriwanu. ");
INSERT INTO ssd_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","Taŋawanu le Akis ndek David tuku pasa ta son ŋga wamdusmba sakanu: Son. Nu nuŋe ndare tuma Israel ndoŋ kame bute. Kile nu nuŋe mbal ndoŋ ŋgueu minmba ye tuku piro taŋgo minmba ye kulatka minmba minamŋgat ŋga idusanu. ");
INSERT INTO ssd_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","Minnaig ka ait ande Filistia mbal naŋgine kame kuasmbi kile-maŋgurka Israel mbal ndoŋ kame buwam tuku ŋginaig sulumba Akis ndek David sana: Kite ne naŋe kame kuasmbi ta kilmba ŋakmba ye dubiyumba ka Israel mbal ndoŋ kame buwamŋgig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","Taŋaka sana le David ndek woka sakina: Ta maye. Ye ne tuku piro taŋgo. Ne ndaŋmba kam tuku saya ta ye taŋamba ndo kamŋgit ŋgina le Akis ndek sana: Ese. Ne taŋawa le ye ne tumba yiŋe ŋgarosu kulatkam tuku palmbimŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Samuel nu buk kumna le nane Israel mbal ŋakmba wamdus tatruka malmbimba nuŋe tumbraŋ Ramaŋge ŋgukinaig. Ait ta mbolŋge Saulŋge taŋgo kanunu wikanu mbal ta Israel kilke mbolŋge mine ndakuwaig ŋga ŋakmba pitaikina le sili-silinaig. ");
INSERT INTO ssd_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Kile Filistia mbal pro Sunem tumbraŋ suŋgo ta makembiŋge kame buwam tuku ma ulnaig le Saul ndek Israel kame kuasmbi ta kilmba pro Gilboa tabe mbol taŋge ma ulmba minnaig. ");
INSERT INTO ssd_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Taŋamba minnaig le Saul nu Filistia tuku kame kuasmbi ta kaŋgerka nu kuru kuru ŋayomba wamdus fulilka ");
INSERT INTO ssd_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Suŋgo yabaŋmba kusnana: Ye kile ndaŋi ŋgina kande Suŋgo nu tuku pasa inum kiŋambi ko tukul ndamembi ko tuan taŋgo tuku miŋge mbolŋge mata lafuna le ise ndakina le ");
INSERT INTO ssd_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","nu ndek nuŋe piro mbal wika saniŋgina: Tane kumba pino ande taŋgo kanunu wikanu ta sota te-silikap le ye ka nu kusnawi ŋgina le nane ndek nu sanaig: Pino ande taŋgo kanunu wikate tuku Endorŋge minit ŋga sanaig. ");
INSERT INTO ssd_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Taŋaka sanaig le Saul ndek gabat suŋgo tuku mindepiye ta paska patika tawi kise kilmba kaika taŋgo armba kilmba furir ta mbolŋge ndo tiŋga ka pino ta tugum pronaig sulumba Saul ndek pino ta sana: Ye taŋgo kumanu ande nyun ti le ne nu wika le ame wam prowamŋgaig ta ne sanuwa le ye saya ŋga pino ta sana kande ");
INSERT INTO ssd_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","pino ta ndek nu sana: Gabat suŋgo Saulŋge Israel mbal tuku taŋgo kanunu wikade mbal ta pitaikina ta ne gilai e? Ne ndaŋam saka ye te-mayokyumba baleyuwaig ŋga taŋate ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Saul ndek pasa saŋgri pilemba sakina: Ye Suŋgo nyu mbolŋge ne sanet. Ne wam te ka ta nane ne tumba pasa mbol pile nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Taŋakina le pino ta ndek Saul kusnana: Ye ima wiki ŋga iduste ŋgina le Saul ndek nu sana: Ne Samuel wika ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Taŋaka sana le pino ta ndek Samuel wikina le mayok kina. Mayok kina le pino ta nu Samuel kaŋgermba wi ŋayomba Saul sana: Ne ndaŋam saka ye yabriyat? Ne Saulŋge ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Taŋakina le gabat suŋgo ndek pino ta sana: Ne kuru kuru ndaka. Ame agaŋ kaŋgerat ta ye saya le isi ŋgina le pino ta lafumba Saul sana: Ye mindekanu ande sambu kusremba mayok ket le kaŋgerit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Saul ndek nu kusnana: Taŋgo ta ndaŋ ndaŋ ŋgina le pino ta nu sakina: Taŋgo saibo tawi kuennu silika mayok ket ŋgina le Saul nu katesena ta Samuelŋge ŋga nu ndek dagol tidroŋga lokina. ");
INSERT INTO ssd_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Taŋana le Samuel ndek Saul kusnana: Ne ndaŋam saka ye wikat ŋgina le nu lafumba sana: Suŋgo nu ye ŋgumneyina le Filistia mbal ye ndoŋ kame buwam bafude. Ta tuku ye wamdus piti suŋgo ŋak. Nu ye tuku pasa inum tuan taŋgo tuku miŋge mbolŋge ko kiŋambi sayate le ise ndaket tukunu ye kile ndaŋndaŋamŋgit ŋga pro neŋge ye saya ŋga ne wikit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Taŋakina le Samuel ndek nu sana: Suŋgo o buk ne ŋgumnenumba nu ne ndoŋ ŋgueu minit. Ne ndaŋam saka ye ne turnam tuku wikate? ");
INSERT INTO ssd_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Suŋgoŋge o buk ye wam paguyina le ye tuku miŋge mbolŋge pasa prona le ne isna ta nu kile dubimba kate. Nu Israel kulatkam tuku piro ta ne yainumba David tuna. ");
INSERT INTO ssd_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Ne buk Suŋgo tuku miŋge ŋgurna. Nu Amalek mbal tuku gubra suŋgo tumba ne nane ŋakmba bale farkam tuku ŋgina ta ne kumu ndana. Ta tuku kile Suŋgo nu wam ta lafumba ne mbol kate. ");
INSERT INTO ssd_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Ne naŋe kuasmbi Israel tane ŋakmba Suŋgoŋge kilmba Filistia tuku wai mbol patinuŋgat. Indole ne naŋe kiŋo kat naŋe ndoŋ kummba pro teŋge ye ndoŋ minamŋgaig. Suŋgo nu Filistia mbal sinzaŋniŋmba Israel tuku kame kuasmbi kilmba nane tuku wai mbol patinuŋgat ŋga Saul sana. ");
INSERT INTO ssd_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Saul nu Samuel tuku pasa ta ismba kuru kuru mayemba ŋgurŋgurka kilke mbol ndeka milmailka kinye ŋak minna. Ta ndaŋam? Ki ait ka furir ŋgamuna nu isukuse ndaka minna tukunu nu milmailka minna. ");
INSERT INTO ssd_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Taŋamba minna le pino ta ka Saul kuru kuru mayena le kaŋgermba nu sana: O taŋgo suŋgo, ye yiŋe ŋgarosu yambarkam kuru kuru ndaka ne tuku miŋge dubiwit. ");
INSERT INTO ssd_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Taŋamba ndo ne kile ye tuku miŋge dubimba tiŋga bret afu nyumba ŋgarosu saŋgri tiŋguwa le luka kaye ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Saul ndek nu sana: Ye isukusam mbulit ŋgina. Taŋakina le nuŋe piro taŋgo ar ta pino ta ndoŋ nane dirnaŋginaig le nu nane tuku miŋge dubimba tiŋga ka mbili mbol minyokina. ");
INSERT INTO ssd_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Minyokina le pino ta pre pre nuŋe makau fat butuknu ande kulatka minna ta balena sulumba pikmba ndemnu ta kilmba kuapikina. Kuapikina sulumba plaua yis kugatok ta kilmba pipmba bret afu wakeika pasoka ");
INSERT INTO ssd_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","niŋgina le nane nyinaig. Nye deŋpurmba furir ndui ta ndo nane tiŋga luka naŋgine tumbraŋ kinaig. ");
INSERT INTO ssd_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","Kile Filistia kame gabat nane kame kuasmbi kilmba pro Afekŋge ma ulmba maŋgurkinaig le nane Israel kame kuasmbi pro Yesrel ma kule bulbultembi taŋge ma ulmba maŋgurkinaig. ");
INSERT INTO ssd_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","Nane Filistia tuku gabat sugo ta naŋgine kame kuasmbi walmba afu 100 afu 1,000 taŋamba fetke lika kame tuku kuaneka tiŋge likinaig le David nu nuŋe kame kuasmbi kilmba Akis ndoŋ nane ŋgumnem dubikina. ");
INSERT INTO ssd_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Taŋana le nane Filistia tuku kame gabat ta nane kaŋgerka Akis sanaig: Ndaŋam Hibru taŋgo kame te sine dubika kame kaŋgig ŋginaig le Akis lafumba nane saniŋgina: Taŋgo si Davidŋge. Nu Israel mbal tuku gabat suŋgo Saul tuku piro taŋgo ta nu o buk Saul kusremba yar ndindo taŋaŋ pro ye ndoŋ teŋge minit ta tane gilai e? Ye nu wam afu mbarna le kaŋger ndaken ŋga saniŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","nane kame gabat sugo sugo Akis tuku gubra pasa tumba sanaig: Taŋgo si te-luka le ka tumbraŋ sernambi taŋge ka minwa. Kuga ta nu nuŋe gabat suŋgo Saul garewa ŋga mbilka sine ndoŋ kame bumba sine kilmba bale farikat. ");
INSERT INTO ssd_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","Taŋgo si sine kila. O buk pino kame nane kupesmba mune ulmba sakinaig: Saul nu ŋgueu mbal 1,000 bale farniŋgina le David nu ŋgueu mbal 10,000 bale farniŋgina ŋginaig ŋga Akis sanaig. ");
INSERT INTO ssd_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Taŋamba sanaig le Akis ndek David wika sana: Mbara Suŋgo abo tugu ŋak nu tuku nyu mbolŋge ye ne sanet. Ne tiŋreknu. Ne ye dubiyumba kame mbol tiŋga ye turya ŋga iduset. Ne o buk ye sota prona kile minit ta ne wam ande mbarna le kaŋger ndawen ta nane gabat sugo si nane ne sine dubi ndaka ŋga sakade. ");
INSERT INTO ssd_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","Ta tuku ne kile wamdus bulok luka tumbraŋ kaye ka taŋge mina. Ne sine dubika ta kame gabat afu si ne tuku ndagariniŋgikat ŋga sana kande ");
INSERT INTO ssd_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","David ndek nu tuku pasa lafumba sana: O gabat suŋgo, ye ne tugumŋge ame wam mbaren? Ye o buk ne tuku piro tugu pilen sulumba kile ye minet ta ye mbar ande ken le ne kame kambim tuku ye peuyate e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","Akis ndek nu tuku pasa lafumba sana: Son. Ye tuku am mbolŋge ne tiŋreknu Kuate tuku eŋel suk ta kame gabat afu nane sakaig ne sine dubika kame mbol kine nda ŋga sakaig. ");
INSERT INTO ssd_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Ta tuku indole mafewa le maratukuk tiŋga ne sine kusreka naŋe kuasmbi o buk Saul tugumŋge kilmba ilna ta ŋakmba kilmba luka kaye ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Taŋaka sana le David nu maratukuk tiŋga nuŋe kuasmbi ta kilmba luka Siklak tumbraŋ Filistia kilke mbol kina le nane Filistia mbal ndek tiŋga Yesrel kinaig. ");
INSERT INTO ssd_vpl VALUES ("S130_1","010_30_1","1SA","30","1","3","David nuŋe kame kuasmbi kilmba luka Siklak tumbraŋ kambim tuku kumba minnaig le Amalek mbal Yuda ma tugu ki prote kumamŋge promba Siklak tumbraŋ piynaig sulumba pino kutu ŋakmba kilmba kine sulunaig. Ande bale ndanaig. David nane ait keŋnu mbolŋge Siklak patumba mambilnaig kande Amalek mbalŋge tumbraŋ piynaig le pa guwa ma gur tiŋgina le kaŋgermba nane pro tumbraŋ sinam kumba pino kutu ŋakmba kilmba kine sulunaig ta kaŋgermba ");
INSERT INTO ssd_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","nane malmbi ŋayonaig ka ka saŋgri kugamba baklele likinaig. ");
INSERT INTO ssd_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","David tuku pino ar ta Ahinoam Yesrelnu nale Abigail Nabal tuku pino kuembol Karmelnu ta mata kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","David nuŋe kame kuasmbi nane tuku pino kutu ŋgueu mbalŋge kilmba kine sulunaig tukunu nane David tuku gubra tormba nu ndamembi balewam tuku saka minnaig le nu ismba wamdus piti suŋgo tina ta nuŋe Mbara Suŋgoŋge nu saŋgri pilena le ");
INSERT INTO ssd_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","nu ndek pris Abiatar sana: Ka pris tuku tawi ta tumba pro ye sa ŋgina le nu kina ka tawi ta tumba pro David tuna. ");
INSERT INTO ssd_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","Tuna le David ndek Suŋgo kusnamba sakina: Ye Amalek kuasmbi ta dubika ka nane ndinŋge kile-siglikamŋgit e ŋgina le Suŋgoŋge lafumba sana: Ne nane dubika kaye ka pino kutu kame ta ŋakmba yaika kile-luka kilamŋgat ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","Taŋaka sana le David ndek nuŋe kame kuasmbi 600 ta ŋakmba kilmba Amalek mbal kupel kupel dubika kinaig ka Besor kule mbol ta pronaig. ");
INSERT INTO ssd_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","Pronaig sulumba taŋgo 200 nane saŋgri kugamba Besor kule pakarke fugunaig ta taŋge kusrekinaig le minnaig le David nu taŋgo 400 ta ndo kilmba Amalek mbal dubika kinaig. ");
INSERT INTO ssd_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","Nane kinaig ka ndinŋge Isipnu taŋgo mo ande te-silika tumba David tugum kumba nane ndek Isip taŋgo ta bret afu tumba kule turmba tunaig le nyina. ");
INSERT INTO ssd_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","Taŋana le nane ndek fik kareŋganu soŋ ŋak ande tumba bret foŋfoŋ grep kareŋganumbi pipnaig tuku ta turmba nu tunaig le nyina. Taŋgo ta nu ait keŋmba nyamagaŋ kule kugatok minna tukunu kile nu nyamagaŋ ta kilmba nyumba maŋ saŋgri tina. ");
INSERT INTO ssd_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","Saŋgri tina le David ndek taŋgo mo ta kusnana: Ne anikok? Ne tuku gabat ima ŋgina le nu lafumba sana: Ye Isipnu ta Amaleknu taŋgo andeŋge o buk ye piyayumba tina. Ye ailfu guazeŋgen le nane teŋge ye kusreyinaig. ");
INSERT INTO ssd_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","Sine kageŋ ka Keret ma tugu Yuda ma tugu Kaleb ma tugu ki prote kumamŋge kame bugeŋ sulumba pro Siklakŋge tumbraŋ piygeŋ ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","Taŋakina le David ndek taŋgo mo ta kusnana: Ne sine kilmba nane minig magot ta tumsiŋgam kumuŋ e ŋgina le nu ndek sakina: Ne Kuate tuku nyu mbolŋge ye bale ndayumba ye tumba yiŋe gabat tuku wai mbol pile nda ŋga pasa saŋgri pilewa le ye tane kilmba nane minig ma ta tumtiŋgamŋgit ŋga David sana le wokina. ");
INSERT INTO ssd_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","Kile taŋgo mo ta ndek nane kilmba ka Amalek mbal mine likinaig ma ta kinaig. Kinaig ka ta pronaig kande nane Filistia kilke mbolŋge Yuda ma tugu mbolŋge gabis agaŋ ndende suŋgomba yomba kilnaig ta tuku nane gare-gareka pagumba nye suŋgo te-ibeŋnaig. ");
INSERT INTO ssd_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","Taŋamba minnaig le ka furirna le David nuŋe kame kuasmbi kilmba sinam ka Amalek mbal ndoŋ kame bumba nane bale farka kinaig ka mafemba maŋ furirna. David tuku kuasmbi taŋge nane ŋakmba bale far sulunaig. Amalek taŋgo 400 ndo kamel poŋga kua kinaig. ");
INSERT INTO ssd_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","Taŋanaig le David ndek pino kutu gabis agaŋ ndende ŋakmba Amalek mbalŋge kilnaig ta luka kilna sulumba nuŋe pino ar ta turmba kilna. ");
INSERT INTO ssd_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","Nane tuku agaŋ inum ŋgisi ndakina. Kiŋo kame kulim kame gabis agaŋ ndende ŋakmba Amalek mbalŋge kile likinaig ta kumu-kumumba kile-luka kilnaig. ");
INSERT INTO ssd_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","Taŋanaig sulumba Amalek mbal tuku makau sipsip agaŋmor ta ŋakmba kilmba David tuku ŋga sisilaniŋmba amboŋga kinaig. ");
INSERT INTO ssd_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","Luka kumba minnaig le kuasmbi 200 matuk ka Besor kule makembiŋge kusrekinaig ta nane kaŋgerka tiŋga nane ndin kinaig ka ndinŋge nane tumaka ulendikinaig. Taŋanaig sulumba David ndek nane tugum kumba tane kumumbi minig e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","nane David ndoŋ kinaig taŋgo afu ŋaigonu mugru sambek ta nane ndek sakinaig: Nane sine ndoŋ kine ndakinaig tukunu sine agaŋ ndende kame bumba kilgeŋ te nane walmba niŋge nda. Nane naŋgine pino kutu ndo niŋgap le kilmba kuwaig ŋginaig kande ");
INSERT INTO ssd_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","David ndek sakina: Yiŋe tira kame, tane taŋa ndawap. Sine agaŋ ndende te Suŋgoŋge sinzaŋsiŋgina le luka kilgeŋ. Nuŋge sine turkina le kuasmbi sine tuku tumbraŋ piynaig ta kilmba bale farkigeŋ tukunu ");
INSERT INTO ssd_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","ye tane tuku pasa ta dubiwe nda. Kuga. Agaŋ ndende ta ŋakmba walmba tane kinaig mbal nane agaŋ ndende kulatka minnaig mbal ta kumu kumu kilap ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","David nu taŋaka saka pasa ta saŋgri pilena le Israel ŋgamukŋge pasa ta mara mindek dubimba kile mata taŋamba minig. ");
INSERT INTO ssd_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","Kile David luka kina ka Siklak prona sulumba kame mbol gabis agaŋ ndende kile-lika pronaig ta walmba nuŋe tira kame Yuda mage mage ta tuku patike lika pasa turmba patikina sulumba sakina: Agaŋ ndende Suŋgo tuku ŋgueu mbal mbolŋge yaika kilgeŋ te ye walmba tane tiŋget ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","David nu agaŋ ndende walmba tumbraŋ tumbraŋ mage mage niŋgina ta teŋenmba. Betel mage mage. Ramot mage mage ki prote kumamŋge. Yatir mage mage. ");
INSERT INTO ssd_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","Aroer mage mage. Sifmot mage mage. Estemoa mage mage. ");
INSERT INTO ssd_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","Rakal mage mage. Yeramel mbal mage mage. Ken mbal mage mage. ");
INSERT INTO ssd_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","Korma mage mage. Bor-Asan mage mage. Atak mage mage. ");
INSERT INTO ssd_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","Hebron mage mage. Tumbraŋ afu turmba David nuŋe kuasmbi ndoŋ kupe pilmba likinaig mage mage mata walmba niŋgina. ");
INSERT INTO ssd_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","David nu Siklakŋge minna le Filistia mbal nane Israel mbal ndoŋ Gilboa tabe mbolŋge kame bunaig sulumba Israel mbal afu bale farniŋginaig. Afu nane sili-silimba kua kinaig le ");
INSERT INTO ssd_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Filistia mbal nane dubika kinaig sulumba Saul tuku kiŋo kat nuŋe keŋmba Yonatan Abinadab Malkisua nane turmba baleniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Saul nu minna ma ta mbolŋge kame saŋgri tiŋgina le ŋgueu mbal afuŋge tui fat parsiŋga Saul tuiŋ tinaig le nu kumam bafumba ");
INSERT INTO ssd_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","kiŋo mo nu tuku kame agaŋ ndende kugrakina ta sana: Ne ilmba naŋe kame bagi ta gomba tumba ye baleya le kumi. Taŋawa le Filistia mbal ŋgaro nda pikanu si nane ye aza pile-pileyumba bale ndayuwaig ŋgina kande taŋgo mo ta nu balewam kuru-kuruka mbulna le Saul nu nuŋe miroŋ nuŋe kame bagi ta tumba te-timba pateŋga kame bagi ta mbol kumba kumna. ");
INSERT INTO ssd_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Saul nu kumna le taŋgo mo ta nu kaŋgerna sulumba nu suk nuŋe kame bagi ta tumba te-tina sulumba pateŋga kame bagi ta mbol kumba kumna. ");
INSERT INTO ssd_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Ki ait ndui ta mbolŋge ndo Saul nuŋe kiŋo kame keŋmba ta taŋgo mo ta Saul tuku kame mbal nane ŋakmba kume farnaig. ");
INSERT INTO ssd_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Saul nuŋe kiŋo kat nuŋe ndoŋ kumnaig le Israel kame kuasmbi nane kua ka sili-silinaig ta nane Israel kuasmbi afu ma gutoŋ Yordan kule make simŋge minnaig ta nane kaŋgerka nane mata kua ka tumbraŋ kusreka sili-silinaig le Filistia mbalŋge pro tumbraŋ ta kile-lika taŋge kinynaig. ");
INSERT INTO ssd_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Nane kinynaig ka mafena le Filistia mbal nane Israel mbal bale farnaig ta tuku kame agaŋ ndende paska kilam kinaig. Kinaig ka Gilboa tabe mbol taŋge Saul nuŋe kiŋo kat nuŋe keŋ nane tuku mindesiŋ naŋgine kaŋgerkinaig. ");
INSERT INTO ssd_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Kaŋgerkinaig sulumba nane ndek Saul tuku ŋinfok kat purmba kame tuku agaŋ ndende paska kilmba nane taŋgo afu kukulniŋginaig le pasa tumba Filistia ma tugu ŋakmba mbol kine likinaig sulumba naŋgine zugu wandek sinam kumba taŋge maŋgurka kubeu niŋge likinaig le taŋgo pino ŋakmba ismba gare-garekinaig. ");
INSERT INTO ssd_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","Taŋanaig sulumba Saul tuku kame agaŋ ndende ta kilmba naŋgine pino mbara Astarte tuku zugu wande sinam taŋge patika Saul kiŋo kat nuŋe keŋ ta tuku mindesiŋ kilmba Bet-San tumbraŋ fonde mbol taŋge taikinaig. ");
INSERT INTO ssd_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Kile Yabes tumbraŋ mbal Gilead ma tugu mbolŋge nane Filistia mbal Saul tuku mindesiŋ tumba taikinaig pasa ta isnaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","nane taŋgo saŋgriknu afu kukulniŋginaig le furir ta mbolŋge ndo nane tiŋga kinaig ka ka Bet-San promba fonde mbol taŋge Saul nuŋe kiŋo kat nuŋe keŋ ta tuku mindesiŋ taikinaig ta kilmba luka pro Yabes tumbraŋŋge mindesiŋ kame ta pasokinaig. ");
INSERT INTO ssd_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Pasokinaig sulumba isu kat naŋgine ta ndo kilmba Yabesŋge ail suŋgo ande kumnemŋge ŋgukinaig. Taŋanaig sulumba nane ndek kusem ndindo nyamagaŋ pinka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","Nane Saul balenaig le kumna ait ta David nuŋe kame mbal kilmba ka Amalek mbal ndoŋ kame bumba nane bale farkina sulumba nane luka naŋgine tumbraŋ Siklak kinaig. ");
INSERT INTO ssd_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","David nu Siklakŋge minna le ait keŋmba kinaig le Saul tuku kame taŋgo ande kumba ka Siklak prona. Nu sagkanu taŋaŋ David tugum kumba dagol tidroŋga lokina le ");
INSERT INTO ssd_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","David ndek nu kusnana: Ne aniŋge prote ŋgina le taŋgo mo ta ndek lafumba sana: Ye kame sinamŋge Israel mbal bale farkinaig le ye kua ka te prowet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","Taŋakina le David ndek nu kusnana: Kame mbolŋge ame wam prowe likinaig ta ye saya le isi ŋgina le taŋgo mo ta ndek nu sana: Sine tuku kame taŋgo nane kua ka sili-silinaig le Filistia mbalŋge sine tuku kuasmbi suŋgomba bale farniŋge likinaig. Taŋamba Saul le kiŋo nuŋe Yonatan mata balenikinaig ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","Kile David ndek nu kusnana: Saul le Yonatan kumnaik ta sonndo ne kaŋgerkina e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","taŋgo mo ta lafumba sakina: O suŋgo, ye Gilboa tabe mbolŋge minen sulumba Saul kaŋgeren ta nu nuŋe mbanduwaŋ ta kilke mbolŋge te-timba nuŋe ŋgaro tugunemba tiŋ minna le kaŋgeren. Kame mbal hos mbol pinderkanu karis mbol pinderkanu mata nane Saul buk te-kornaig. ");
INSERT INTO ssd_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","Taŋanaig le nu mbilmbilka ye kaŋgeryumba wikina le ye woka nu sota kan le ");
INSERT INTO ssd_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","nu ndek ye kusnayina: Ne anikok ŋgina le ye Amaleknu ŋgen. ");
INSERT INTO ssd_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","Taŋaken le nu ndek ye sayina: Ne ilmba ye tapleya. Tui fat andeŋge ye te-mayeyat le ye kumam bafuwet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","Taŋaka nu buk surka ndeka kumam bafuna tukunu ye ka nu taplewen sulumba nu tuku gol hat kaikanu ta gomba tumba sagi nzar wai mban mbolŋge ta paska ten sulumba agaŋ kame ta kilmba ne tugum te prowet ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","Taŋakina le David nu ismba ŋgamuŋgal tatrukina le nuŋe tawi fetfetna le nuŋe kuasmbi mata ŋakmba maŋau ndui ta ndo kinaig. ");
INSERT INTO ssd_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Ta ndaŋam? Saul le Yonatan, Israel kame mbal suŋgomba nane Kuate tuku kuasmbi ta kame suŋgo ta mbolŋge bale farkinaig tukunu nane malmbika nyamagaŋ pinka minnaig le ka furirna. ");
INSERT INTO ssd_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","Furirna le David ndek taŋgo mo ta kusnana: Ne anikok ŋgina le nu sakina: Ye Amaleknu. O buk mam nu Amalek kilke kusremba pro Israel kilke mbolŋge rawe taŋgo taŋaŋ minyokina ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","David ndek nu sana: Ndaŋam saka ne Suŋgoŋge gabat madina ta balena ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","nuŋe kame taŋgo ande wika sana: Ne ilmba taŋgo te balewa le kumwa ŋgina le kame taŋgo ta kumba ka Amalek taŋgo ta kame bagimbi balena le kumna. ");
INSERT INTO ssd_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","Kumna le David ndek Amalek taŋgo ta sana: Ne Suŋgoŋge gabat madina ta balewanu sakat tukunu kile lafunu naŋe miroŋ naŋe ndare kutute ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","Kile David nu ninanka Saul le kiŋo nuŋe Yonatan tuku ŋga mune-munekina sulumba ");
INSERT INTO ssd_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","nuŋe kuasmbi wam paguniŋmba saniŋgina: Tane mune te tumba ka Yuda taŋgo pino ŋakmba tumniŋgap le tago-tagomba kila pilwaig ŋgina. Mune mbara ta Tui Mune. Kile mune ta Yasa tuku waŋe mbolŋge minit. ");
INSERT INTO ssd_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","Sine Israel mbal tuku gabat kame tabe mbolŋge kume likinaig. Siŋgine kame gabat ŋakmba kume likinaig. ");
INSERT INTO ssd_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","Tane pasa te kumba ka Gat le Askelon mbal sa ndaniŋgap. Saniŋgap le Filistia pino kame kasomok pino kame nane ismba gare-garekubekaig. ");
INSERT INTO ssd_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","Siŋgine kame gabat mbal tuku kandim kame kile ake sinaŋ Gilboa tabe mbolŋge mine likade. Saul tuku kandim mata andeŋge maŋ gureŋ pisnewe nda. Ta tuku sawe le mbai ŋgislu tabe ta mbolŋge nde ndakuwaik le nyamagaŋ mata tabe ta mbolŋge prowe nda. ");
INSERT INTO ssd_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","Yonatan nu tui wai paknu. Nu kame mbolŋge agaŋ inum tui ful ndawanu. Saul tuku kame bagi ake sinaŋ mine ndakina. Nu nuŋe ŋgueu mbal saŋgriknu ŋakmba bale farniŋganu. ");
INSERT INTO ssd_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","Taŋgo pino ŋakmba nane Saul le Yonatan tuku gare tornaig. Nale mara mindek kigri-kigriŋga minnaik sulumba kumu kumu ndo kumnaik. Nale tuku pinder ta paŋus fumba kinit taŋaŋ. Nale tuku saŋgri ta laion tuku saŋgri taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","Tane Israel pino kame tane Saul tuku ninanka malmbikap. Nu tane tawi gurgur magenu ndo agaŋ ndende golmbi wakeikanu ŋgarosu mindepiye mayewam tuku tiŋge likina. ");
INSERT INTO ssd_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","Kame gabat ar ta kame mbolŋge kumnaik. Yonatan tuku mindesiŋ tabe mbol ambeŋge minit. ");
INSERT INTO ssd_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","O yiŋe aba Yonatan, ye ne tuku sina suŋgo ŋak. Sile muŋgu kume purkikeŋ wam ta pino kame nane ye tuku ŋga kume purde wam ta lite. ");
INSERT INTO ssd_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","Kame gabat mbal ŋakmba kame mbolŋge kume likinaig le nane tuku kame agaŋ ndende mata ake ŋaigoŋgamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Kile David nu Suŋgo kusnamba sakina: Ye kumba ka Yuda mbal tuku tumbraŋ suŋgo ande mbol minyoki e ŋgina le Suŋgo nu ndek sana: Ta maye ŋgina. Taŋakina le David maŋ lato kusnana: Ye ka tumbraŋ ndaŋ mbol minyoki ŋgina le Suŋgo nu lafumba sana: Ne kumba ka Hebronŋge minyoka ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Taŋamba sana le David nu tiŋga nuŋe pino ar Ahinoam le Abigail kilmba kinaig ka Hebron tumbraŋ tumba minyokinaig. Ahinoam nu Yesrelnu. Abigail nu Karmelnu. Nu Nabal tuku pino kuembol Davidŋge tina. ");
INSERT INTO ssd_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","David tuku taŋgo kuasmbi naŋgine gageu ŋakmba David ndoŋ kinaig ta nane tumbraŋ afu Hebron tumbraŋ patuk patuk mine likinaig ta kilmba minyoke likinaig. ");
INSERT INTO ssd_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Taŋanaig le Yuda taŋgo kame pro Hebronŋge David naŋgine gabat suŋgo minwa ŋga gureŋ tumba nu tuku gabat mbolŋge kutunaig. Yabes mbal Gilead ma tugu mbol minnaig ta nane buk Saul tuku mindesiŋ tumba ŋgukinaig pasa ta David nu ismba ");
INSERT INTO ssd_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","nuŋe taŋgo afu kukulniŋmba saniŋgina: Tane kape ka Yabes mbal teŋenmba saniŋgap: Suŋgo nu tane nyaro tiŋguwa. Taneŋge Saul nu siŋgine gabat suŋgo ŋga mindesiŋ nuŋe tumba ŋgukinaig ta tuku ye tane gare pasa tiŋget. ");
INSERT INTO ssd_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","Suŋgo nu tane sinzaŋtiŋmba minmba minwa. Tane gabat suŋgo Saul mbolŋge wam mayenu kinaig tukunu kile ye suk tane mbolŋge wam magenu kamŋgit. ");
INSERT INTO ssd_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","Taŋgine gabat suŋgo Saul nu kumna le kile nane Yuda mbal ye nane tuku gabat suŋgo mini ŋga madiyinaig. Ta tuku tane saŋgri tiŋga ŋgueu mbal tuku kuru kuru ndakap ŋga saniŋgap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","Saul tuku kame gabat suŋgo Abner nu Saul kiŋo nuŋe Isboset tumba kua ka Yordan kule pakarka Mahanaim tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","Kinaig ka taŋge Abner ndek Isboset nu Gilead, Asur, Yesrel, Efraim, Benyamin, Israel ma tugu ŋakmba tuku gabat suŋgo minwa ŋga madina. ");
INSERT INTO ssd_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","Isboset nu yar 40 ŋak minna le nu Israel mbal tuku gabat suŋgo minwa ŋga madinaig le nu yar armba ndo Israel ma tugu kulatkina. Yuda tuku tuguŋge ndo David dubinaig le ");
INSERT INTO ssd_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","nu yar 7 bateŋnu turmba Hebronŋge nane kulatkina. ");
INSERT INTO ssd_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","Abner nu Isboset tuku kuasmbi kilmba Mahanaim kusremba Gibeon tumbraŋ pronaig le ");
INSERT INTO ssd_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","Seruya kiŋo nuŋe Yoab mata David tuku kuasmbi ndoŋ pro Gibeon kule kualiŋ tugum taŋge nane kile-siglikinaig. Isboset tuku kuasmbi pro kule kualiŋ make simŋge minyokinaig le David tuku kuasmbi pro kule kualiŋ make temŋge minyokinaig. ");
INSERT INTO ssd_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","Taŋanaig sulumba Abner ndek Yoab sana: Ye taŋgo mo afu madiniŋgi le ne mata taŋgo mo afu madiniŋga le nane kame agaŋ ndende kilmba kame saŋgri muŋgu tumkuwaig ŋgina le Yoab nu lafumba sana: Ta maye ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","Taŋamba nane Isboset tuku taŋgo 12 madiniŋginaig ta nane ŋakmba Benyamin tuku tugu ndo. Nane pro David tuku taŋgo 12 ta ndoŋ kame bumba ");
INSERT INTO ssd_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","naŋgine naŋgine gabat waŋe roka kame bagimbi takel make kumu kumu nduaseka taŋgo 24 ta ŋakmba kume likinaig. Ta tuku nane ma tugu ta nyun ta Kame Bagi tuku Ma ŋgade. ");
INSERT INTO ssd_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","Taŋanaig le kame suŋgo kuasmbi ar ta ŋgamukŋge tiŋgina le David tuku kuasmbiŋge Abner tuku kuasmbi Israel mbal kile-ibeŋkinaig le kua ka sili-silinaig. ");
INSERT INTO ssd_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","Seruya tuku kiŋo kame keŋmba kame mbolŋge minnaig ta nane tuku nyu teŋenmba: Yoab, Abisai, Asahel. Asahel tuku pinder nuŋe ta nane ŋakmba tuku pinder liniŋganu tukunu ");
INSERT INTO ssd_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","nu Abner madimba tumba yokerna le ");
INSERT INTO ssd_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","Abner nu pinderka minmba mbilka mambilna kande Asahel nu madimba yokermba kina le nu kusnana: Ne Asahelŋge e ŋgina le nu sakina: Au. Yeŋge ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","Taŋakina le Abner nu peumba sana: Ne ye yoker ndaya. Ne luka ka taŋgo ande tumba yokermba nu tuku kame agaŋ ndende ta yaimba kila ŋgina kande Asahel nu Abner tuku pasa ise ndaka nu ndo madimba yokermba kina le ");
INSERT INTO ssd_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","nu maŋ lato sana: Ne ye yoker ndaya. Ye ne baleni ta ye aba naŋe Yoab am mbolŋge kikoyamŋgat ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","Asahel nu nda isanu sukmba nu yokermba lok ndeka kina le Abner ndek nuŋe mbanduwaŋ tugunumbi ŋgumnem ŋgumnem te-lukina le Asahel fuŋgul mbolŋge nduasemba ka inumŋge bitekŋgina le nu kummba ndekina. Kummba ndekina le kame mbal afu pinderka pro taŋge Asahel tuku mindesiŋ kaŋgermba laipmba tiŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","Yoab nale Abisai nale ar taŋge ndo Abner madimba yokermba kinaik ka ka Ama tabe tugu mbol ta pronaik le ki ka ululuna. (Ama tabe ta Giya tumbraŋ ki prote kumamŋge Gibeon yamban kambim tuku ndin miŋge mbiŋge minit). ");
INSERT INTO ssd_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","Ki ka ululuna le Benyamin tuku kuasmbi nane ka Abner te-silikinaig sulumba nane ka tabe fudiŋ ande mbolŋge tiŋga kame tuku kuaneka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","Taŋamba minnaig le Abner ndek Yoab kaŋgermba wi kueŋka sana: Ne kame te minmba minwa ŋga iduste e? Kame te kuga ndawa ta sine muŋgu ŋgueu minmba minamŋgig ta ne idus ndate e? Sine ndare ndindo ndo. Ne naŋe kuasmbi ta peuniŋga le maŋ sine yoker ndakuwaig ŋga Yoab sana le ");
INSERT INTO ssd_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","nu pasa ta isna sulumba nu ndek lafumba sana: Kuate abo tugu ŋak nu tuku nyu mbolŋge ye ne sanet. Ne ye peu ndayat kande yiŋe kuasmbi kile tane yokerka minig le ka ka mafete kande ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","Yoab nu pasate deŋpurna sulumba kame tukulmba nuŋe kame mbal maŋ Israel mbal yoker ndakuwaig ŋga tabil fitkina le kame ta kusremba sili-silinaig. ");
INSERT INTO ssd_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","Kile Abner nuŋe kame mbal ndoŋ ma ta kusremba Yordan ma gutoŋ ta kuerka kumba minnaig le ka ka mafena. Mafena le ma gutoŋ ta kusremba Yordan kule pakarka kinaig ka ka ki mbilna le nane luka Mahanaim pronaig. ");
INSERT INTO ssd_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","Abner nu nuŋe kame mbal kilmba kina le Yoab ndek nuŋe kame kuasmbi kile-maŋgurka burkina ta nu tuku kame taŋgo 20 ndo te-denna. Asahel mata kumna. ");
INSERT INTO ssd_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","David tuku kuasmbiŋge Abner tuku kuasmbi 360 bale farnaig. Kuasmbi ta ŋakmba Benyamin tuku tugu ndo. ");
INSERT INTO ssd_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","Kile Yoab tuku kuasmbi nane Asahel tuku mindesiŋ tumba kumba ka Betlehem tumbraŋŋge mam naŋgine tuku ndame burok sinam taŋge pilnaig. Pilnaig sulumba furir ndui ta mbolŋge ndo nane tiŋga luka kinaig ka ka mafena le Hebron pronaig. ");
INSERT INTO ssd_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","Kile David tuku kuasmbi Saul tuku kuasmbi ndoŋ kame maŋ tumba tiŋgina ka ka Yuda mbalŋge Israel kuasmbi suŋgomba bale farkinaig le Saul tuku kuasmbi buk denkina. ");
INSERT INTO ssd_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","David nu Hebronŋge minyokina sulumba kiŋo 6 kile-patikina. Nane tuku nyu naŋgine teŋenmba. Kiŋo mulum Amnon. Ina nuŋe nyunu Ahinoam. Nu Yesrelnu. ");
INSERT INTO ssd_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","Kiŋo mulum dubiknu ta Kileab. Ina nuŋe Abigail. Nu Karmelnu Nabal tuku pino kuembol Davidŋge tina. Kiŋo keŋnu ta Absalom. Ina nuŋe Maka. Nu Gesurnu gabat suŋgo Talmai tuku kulim nuŋe. ");
INSERT INTO ssd_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","Kiŋo bailkanu ta Adonia. Ina nuŋe Hagit. Kiŋo inum Sefatia. Ina nuŋe Abital. ");
INSERT INTO ssd_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","Kiŋo 6-nu ta Itream. Ina nuŋe Egla. Kiŋo kame ta ŋakmba Hebronŋge kile-patike likinaig. ");
INSERT INTO ssd_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","Kame suŋgo Saul tuku kuasmbi David tuku kuasmbi ta minmba minna le Abner nu Saul tuku kuasmbi ŋgamukŋge taŋgo nyu ŋak mayok kina. ");
INSERT INTO ssd_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","Taŋamba minnaig ma ma ait ande Isboset nu Abner sawe lika sana: Ne ndaŋam saka mam tuku piyo nuŋe Rispa ndoŋ kinyat ŋgina. (Rispa nu Aya tuku kulim nuŋe Saulŋge pinonu tina tuku). ");
INSERT INTO ssd_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","Taŋakina le Abner ndek gubra tormba nu sana: Ye Yuda tugu turket le ne ye saye likate e? Ye buk mam naŋe Saul, nuŋe tira kat nuŋe, nuŋe gulab kame dubiken ta kile ye minmba minet. Ne Davidŋge ŋayo silinam bafuna le yeŋge ne kigraibken ta ne ndaŋam saka kile pino ta tuku ye saye likate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S23_9","011_3_9","2SA","3","9","10","Taŋakina sulumba nu maŋ lato sana: Suŋgo nu buk David sana: Yeŋge Saul tuku gageu pitaiki le nane Israel mbal tuku gabat sugo mine nda ŋgina. Suŋgoŋge David nu Israel mbal Yuda mbal tuku gabat suŋgo minam tuku madina le nu Israel ma tugu ŋakmba kulatkamŋgat. Ta tuku ye ne sanet. Ye mata David sinzaŋamŋgit. Ye pasa sanet te kumu ndawi ta Kuateŋge ye mapeye nda ŋga Isboset sana le ");
INSERT INTO ssd_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","nu pasa ta ismba nu tuku kuru-kuruka maninok minna. ");
INSERT INTO ssd_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","Kile Abner ndek taŋgo afu kukulniŋmba saniŋgina: Tane kape ka David teŋenmba sawap. Abner nu ne ndoŋ pasa katmba wamdus ulendimba ne sinzaŋnuwa le Israel kuasmbi ŋakmba ne ndo dubinamŋgaig. Tane ka taŋamba nu sawap ŋga pasa pilna le nane ndek David sota kinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","Abner tuku pasa ta David kubeu tunaig le nu ismba nu suk lafumba pasa pilmba sakina: Tane ka Abner teŋenmba sawap. Ne tuku pasa maye ta ye wam ande ne sani le kumuwa le ye ne ndoŋ wamdus ulendiwamŋgit. Ne yiŋe pino Mikal Saul kulim nuŋe ta tumba ye tugum te prowa ŋga nu sawap ŋgina le nane pasa ta tumba luka Abner sota kinaig. ");
INSERT INTO ssd_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","Nane kinaig le David ndek nuŋe taŋgo afu kukulniŋmba saniŋgina: Tane kumba ka Isboset sawap le nu yiŋe pino Mikal pilwa le luka prowa. Ye buk pino ta Filistia taŋgo 100 tuku nduwa ŋgarombi piyamba pinonu ten ŋga sawap ŋgina le nane pasa ta tumba Isboset sota kinaig. ");
INSERT INTO ssd_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","Isboset nu pasa ta sanaig le isna sulumba nu ndek taŋgo afu kukulniŋgina le kinaig ka Lais kiŋo nuŋe Paltielŋge Mikal tina ta yaimba tumba David tugum kinaig le ");
INSERT INTO ssd_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","Paltiel nu malmbitamtam Mikal dubimba kina ka ka Bahurim tumbraŋ pronaig. Tumbraŋ ta pronaig sulumba Abnerŋge Paltiel peumba ne luka naŋe tumbraŋ kaye ŋga kukulna le nu luka nuŋe tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","Kile Abner nu Israel mage mage kile-maŋgurka saniŋgina: Tane o buk David taŋgine gabat suŋgo minwa ŋga saka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","Pasa ta kile idusap. O buk Suŋgo nu sakina: David nu yiŋe piro taŋgo. Ye nu sinzaŋi le yiŋe kuasmbi Israel mbal nane Filistia mbal ŋgueu mbal afu tuku wai mbolŋge minig ta kile-luka kilamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","Taŋamba saniŋgina sulumba Abner nu maŋ tiŋga Benyamin tuku tugu ta ndoŋ minyoka taŋamba ndo pasa katnaig sulumba kile nu tiŋga taŋgo 20 kilmba nuŋe ndoŋ David sota Hebron kinaig. Kinaig ka taŋge Israel mage mage Benyamin tuku tugu nane pasa wakeimba katnaig ta David kubeu tuna le ");
INSERT INTO ssd_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","David ndek Abner nuŋe kuasmbi ta ndoŋ isukusneniŋgam tuku pagunaig. ");
INSERT INTO ssd_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","Taŋamba nane isukuse deŋpurmba Abner ndek David sana: Ye luka ka sulumba Israel mage mage ŋakmba tuku wamdus didiki le ne nane ndoŋ wamdus ulendimba ne Israel ma tugu te ŋakmba kulatkam tuku nzalinate taŋamba nane tuku gabat suŋgo minamŋgat ŋga David sana. Taŋakina le nu nuŋe kame kuasmbi peuniŋmba Abner mapenaig le nu kusremba kina. ");
INSERT INTO ssd_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","Abner nu David kusremba kina le Yoab nu nuŋe kame kuasmbi kilmba ŋgueu mbal ndoŋ kame bumba gabis agaŋ ndende kilnaig ta ŋakmba yomba kilmba luka Hebron pronaig le ");
INSERT INTO ssd_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","nane ndek Yoab kubeu tumba sanaig: Abner pro teŋge siŋgine gabat David kaŋgerat le nu sine peusiŋgat le mapewig le luka kinit ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","Taŋamba kubeu tunaig le Yoab ndek tiŋga gabat suŋgo David sota kumba ka sawe lika sana: Ne ndaŋam saka Abner mapewat le luka kinit? ");
INSERT INTO ssd_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","Nu ne yabrinumba ne piroka likate wam ta katesewam prowat ta ne gilai e ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","Taŋamba sawe lika Yoab nu David kusremba kilim kina ka taŋgo afu kukulniŋgina le Abner ŋgumnem te-dubimba kinaig ka Sira kule burok tugum taŋge nu te-silika tumba luka Hebron pronaig ta David nu katese ndana. ");
INSERT INTO ssd_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","Nane Abner tumba luka Hebron pronaig le Yoab nu wam sisauka Abner sana: Ye ne ndoŋ pasa ŋak ŋgina sulumba nu tumba fonde malaŋga tugum kumba ka taŋge kame bagimbi fuŋgul so fetkina le kumna. Ta ndaŋam? Abner buk Yoab mambo nuŋe Asahel balena ta lafumba nu Abner balena le kumna. ");
INSERT INTO ssd_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","Abner nu kumna le nane afu kumba ka David kubeu tunaig le ismba nu ndek sakina: Abner balewaig le ndare kutukat ta ye yiŋe gageu ndoŋ sine tuku mbar kuga ta Suŋgo nu kila. ");
INSERT INTO ssd_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","Ta tuku ndare ta kile luka Yoab tuku gageu ŋakmba pasokuwa. Nane tuku afu kareŋ we ŋak ŋak afu ŋgirŋger ŋak ŋak afu kupe baklelok minwaig. Afu kame bagimbi bale farwaig le kumwaig. Afu nyamagaŋ kugatok gubak minwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","Abner nu buk kame suŋgo Gibeonŋge prona le Yoab nale Abisai tuku mambo nakile Asahel balena ta lafumba Abner balenaik le kumna. ");
INSERT INTO ssd_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","Kile David ndek Yoab nane saniŋgina: Tane taŋgine minde piye paska fetfetmba sinamanzer tawi siglika Abner ninanka malmbiwap ŋgina. Taŋakina sulumba David nu ter tumba kinaig le ŋgumnem dubikina le ");
INSERT INTO ssd_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","nane Abner tuku mindesiŋ tumba Hebron tumbraŋ taŋge ŋgukinaig. Taŋanaig le David nu nuŋe taŋgo kuasmbi ŋakmba ndoŋ sambu laipmba ninanka malmbinaig. ");
INSERT INTO ssd_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","Taŋamba David nu Abner tuku mindesiŋ ninanka mune-muneka sakina: Ndaŋam tuku Abner nu ŋginŋgan taŋgo taŋaŋ kumat? ");
INSERT INTO ssd_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","Ne kame mbolŋge kumna kande maye kande. Nane taŋgo yabriniŋmba baleniŋgig le kumig taŋamba ndo ne balenaig le kumat ŋgina. Taŋakina le taŋgo pino maŋ nu tuku ninanka malmbinaig. ");
INSERT INTO ssd_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","Malmbiwe deŋpurmba taŋgo pino ŋakmba David sanaig: Kile ne ka isukusa ŋginaig kande David nu pasa saŋgri pilemba nane saniŋgina: Ye isukuse nda. Ye pinka mini le ki ka butuŋguwa. Ye isukusi ta Kuate nu ye mapeye nda ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","taŋgo pino ŋakmba nu tuku pasa ta ismba nu wam ke likina ta kaŋgerka nu tuku gare suŋgo tinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","Israel mbal ŋakmba Davidŋge siseŋkat le Abner bale ndawaig ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","Kile David ndek nuŋe taŋgo kuasmbi ta wam paguniŋmba saniŋgina: Ki ait te mbolŋge kame gabat ande saŋgriknu kumat ta tane ŋakmba kila. ");
INSERT INTO ssd_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","Yoab le Abisai nale saŋgri ŋaigo. Ye Kuateŋge gabat suŋgo madiyina ta ye nale peunikam fuguwet. Ta tuku Suŋgoŋge mbar ta tuku piya ta lafunu nikuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","Abner balenaig le kumna pasa ta Isboset nu ismba kuru-kuruka ŋgamuŋgal piti ŋak minna le nane Israel mbal mata ŋakmba piriri ŋayonaig. ");
INSERT INTO ssd_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","Rimon tuku kiŋo armba Bana nale Rekab ndoŋ nale Isboset tuku kame gabat minnaik. Nale kame mbal kilmba ŋgueu mbal ndoŋ kame buwanu. Mam nakile Rimon nu Berotnu. Nane tuku tumbraŋ mboŋ ta Benyamin. (Berot tumbraŋ ta nane Benyamin mbal tuku ŋgade. ");
INSERT INTO ssd_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","Taŋgo pino o buk Berotŋge minnaig ta nane kua ka kinaig ka Gitaimŋge kile minig). ");
INSERT INTO ssd_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","Saul tuku kiŋo nuŋe Yonatan nu kiŋo ande ŋak ta nyunu Mefiboset. O buk Saul nale Yonatan kumnaik le Mefiboset nu yar 5 ŋak minna le Yesrel mbalŋge pasa pilnaig le Yonatan tuku kuasmbi tugum kina le nane pasa ta ismba kutu kulat pino nu Mefiboset didik tumba kua kinaig ka biye baslena le nu ndeka kile isu ŋayo silina. ");
INSERT INTO ssd_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","Ait ande ki mbol Isboset nu mabta nuŋe wande mbol kinymba minna le Rimon tuku kiŋo armba Rekab nale Bana ndoŋ tiŋga nu tuku wande mbol kinaig. ");
INSERT INTO ssd_vpl VALUES ("S24_6","011_4_6","2SA","4","6","7","Nale ar ta wam sisauka wit kilam tuku wandek sinam kinaik ka taŋge nale Isboset nu nuŋe mbain mbol kinymba minna le kaŋgernaik sulumba kame bagimbi fuŋgulnu nduasenaik le kumna. Kumna le ŋinfok kat purmba gabatnu tumba siŋsiŋndo tumba kua ka kinaik ka Yordan kule ma gutoŋ pronaik le furir ŋgamuna. ");
INSERT INTO ssd_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","Mafena le nale ar ta Isboset tuku gabatnu tumba ka gabat suŋgo David tugum promba sanaig: O gabat suŋgo, ne te kaŋgera. Te naŋe ŋgueu taŋgo Isboset tuku gabat. O buk Saul nu ne ndoŋ ŋgueu minmba ne balenam tuku korkornina ta kile Suŋgoŋge Saul tuku ndare ta lafunu pa niŋgit ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","Taŋakinaik le David ndek pasa lafumba sanikina: Suŋgo abo tugu ŋak nu piti yeki yeki mbolŋge ye sinzaŋyina. Ye nu tuku nyu mbolŋge satiket. ");
INSERT INTO ssd_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","Ye Siklakŋge minen le taŋgo ande pro ye sayumba sakina: Saul buk kumat ŋgina. Nu idusna ye pasa ta ismba gare-garekamŋgit ŋga idusna kande ye nu tuku wam kube pasa ta piya agaŋ taŋaŋ kame mbal wiken le nu tumba ka balenaig le kumna. ");
INSERT INTO ssd_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","Taŋamba ndo tale mata ake sinaŋ taŋgo nuŋe wande mbolŋge kinymba minat le balewaik. Tale siŋka maŋau mbaraik le ye tale mapeke nda. Tale ndare kutuwaik ta lafumba ye kile tale baletikamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","Taŋaka David nu ndek nuŋe kame mbal saniŋgina le nane taŋgo ar ta kilmba ka balenikinaig. Balenikinaig sulumba kupe wai kat nakile kat pugurka kilmba pankinaig sulumba ŋgarosu kat nakile kilmba ka Hebron kule kualiŋ tugum taŋge taikinaig. Taŋamba kame mbal Isboset tuku gabat tumba ka Hebronŋge Abner ŋgukinaigmbi taŋge ŋgukinaig. ");
INSERT INTO ssd_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Kile Israel tugu ŋakmba pro Hebronŋge David sanaig: Sine siŋka ne ndoŋ ndare tuma ndindo ndo. ");
INSERT INTO ssd_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","O buk Saul nu sine tuku gabat suŋgo minna le neŋge sine Israel mbal tuku kame gabat minna le Suŋgo nu teŋenmba ne sanina: Neŋge yiŋe Israel kuasmbi kulatka sulumba nane tuku gabat suŋgo minamŋgat ŋga sanina ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Nane taŋamba David sanaig le nu Israel gabat sugo sugo ŋakmba ndoŋ Suŋgo am mbolŋge wamdus ulendinaig. Taŋanaig sulumba nane ndek David nu Israel mbal tuku gabat suŋgo minwa ŋga gureŋ tumba gabat mbolŋge kutunaig. ");
INSERT INTO ssd_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","David nu yar 30 ŋak minna le nane nu gabat suŋgo minwa ŋga madinaig. Nu yar 40 nane tuku gabat suŋgo minna. ");
INSERT INTO ssd_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Amboŋga nu Hebronŋge Yuda mbal ndo kulatkina ta yar 7 bateŋnu turmba kina ka Yerusalemŋge nu Israel mbal Yuda mbal ulendimba kulatkina ta yar 33 kina. ");
INSERT INTO ssd_vpl VALUES ("S25_6","011_5_6","2SA","5","6","8","Kile David nu nuŋe kame kuasmbi kilmba Yebus mbal tuku tumbraŋ Yerusalem kame kina le mbal ta nane idusnaig: David nu sine tuku tumbraŋ tam kumuŋ kuga ŋga nane David maim maim pasa te-tumba sakinaig: Taŋgo am tukulok kupe baklelok naneŋge ndin kuerwaig le ne sinam kambim kumuŋ kuga ŋginaig. Taŋakinaig le David ndek nuŋe kame kuasmbi wam paguka saniŋgina: Ye nane tuku ndagariyate. Tane kule burok silika fonde sinam kape sulumba am tukulok kupe baklelok nane ndoŋ kame buwap ŋgina. Taŋakina sulumba David nuŋe kame kuasmbi kilmba Sion tumbraŋ fonde kareŋnu ŋak ta sinam kumba tumbraŋ ta tinaig. Tinaig sulumba nane tumbraŋ ta David tuku Tumbraŋ ŋginaig. Kile nane David tuku pasa ta idusmba yaba pasambi mbilmba sakade: Am tukulok kupe baklelok nane kilimŋge minwaig ŋgade. ");
INSERT INTO ssd_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","Taŋamba David nu Sion tumbraŋ fonde ŋak ta tumba minyokina sulumba tumbraŋ ta nyunu David tuku Tumbraŋ ŋgina. Taŋamba nu ndek piro mbal saniŋgina le nane tumbraŋ fonde ŋak ta ki prote kumamŋge kilke diŋnaig tuku magot taŋge wande patike lika Sion tumbraŋ laipnaig le tumbraŋ ta suŋgokina. ");
INSERT INTO ssd_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Kuate Suŋgo Saŋgri Ŋayo nuŋge David sinzaŋna le nu gabat suŋgo saŋgri ŋak mayok kina. ");
INSERT INTO ssd_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","Kile Tirus mbal tuku gabat suŋgo Hiram nu nuŋe gabat kame afu kukulniŋgina le piro agaŋ ndende, ail mage mage, ndamembi wande patikanu kila taŋgo kame turmba kilmba David tugum pronaig le ");
INSERT INTO ssd_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","David nu agaŋ ndende ta kaŋgerkumba nu Kuateŋge Israel tugu ŋakmba kulatkam tuku gabat suŋgo madimba Israel mbal sinzaŋniŋgina ta katesena. ");
INSERT INTO ssd_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","Taŋamba David nu Hebron kusremba Yerusalemŋge minyokina sulumba nu maŋ lato pino afu kilmba kutu afu kile-patikinaig. ");
INSERT INTO ssd_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","Kutu kame ta nyu kat naŋgine teŋenmba. Samua, Sobab, Natan, Solomon, ");
INSERT INTO ssd_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","Ibar, Elisua, Nefeg, Yafia, ");
INSERT INTO ssd_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","Elisama, Eliada, Elifelet. ");
INSERT INTO ssd_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","David nu Israel mbal tuku gabat suŋgo madiwanu pasa ta Filistia mbal ndek ismba nane nu biye timba tumba kambim saka ilnaig le David nu pasa ta ismba nu tiŋga ka nuŋe tumbraŋ fonde kareŋnu ta sinam kina. ");
INSERT INTO ssd_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","Taŋana le nane Filistia kame kuasmbi ta pro Refaim ma gutoŋ taŋge kame tuku kuaneka tumbraŋ ulnaig le ");
INSERT INTO ssd_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","David ndek Suŋgo kusnamba sakina: Ye ka nane Filistia mbal ndoŋ kame buwi e ko kuga. Ye kame ka le ne ye sinzaŋyamŋgat e ŋgina le Suŋgo nu lafumba sana: Ne kaye. Ye nane kilmba ne tuku wai mbolŋge patiki le ne nane kile-ibeŋkamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","Taŋakina le David nu tiŋga ndek gutoŋ nzi kumba ka Filistia mbal ndoŋ kame bumba nane kile-ibeŋkina sulumba sakina: Suŋgo nu sawe piymba kule ndekate taŋaŋ ye tuku ŋgueu mbal tugewat ŋgina. Ta tuku nane ma tugu ta nyun ta Baal Perasim ŋgade. ");
INSERT INTO ssd_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","Filistia mbal nane kua ka naŋgine yabri mbara kanunu kusreke likinaig le David nuŋe kame kuasmbi ndoŋ agaŋ kanunu ta kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","Minnaig le ait ande Filistia mbal maŋ pro Refaim ma gutoŋ taŋge kame tuku kuaneka tumbraŋ ulmba minnaig le ");
INSERT INTO ssd_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","David nu maŋ Suŋgo kusnamba sakina: Ye kile ndaŋamŋgit ŋgina le Suŋgo ndek nu sana: Kaye ka nane ndoŋ kame buwap ŋgina sulumba wam pagumba sana: Tane kumba tumailam tumailam ndakape. Tane kape ka nane laipniŋmba ŋgumnem ŋgumnem ail sugo kumnem siŋge kame tuku tiŋga tairŋgap. ");
INSERT INTO ssd_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","Tane ye ail kame si fu mbol mbol liki le zigna ismba kande ye Suŋgo ye amboŋga Filistia mbal ndoŋ kame kinet ŋga tane ka kame buwap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","Taŋaka sana le David nu Suŋgo tuku wam pagu ta dubimba Filistia mbal Geba tumbraŋŋge bale farka kinaig ka ka Geser tumbraŋŋge tiŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","Kile David nu maŋ Israel kame kuasmbi saŋgriknu 30,000 kilmba maŋgurkina sulumba ");
INSERT INTO ssd_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","nu nane kilmba Kuate tuku tukul bokis tam tuku ŋga Bala tumbraŋ Yuda ma tugu mbol kambim kinaig. Tukul bokis ta Suŋgo Saŋgri Ŋayo eŋel kanunu armba ŋgamukŋge minyok minit nu tuku tukul bokis. ");
INSERT INTO ssd_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","Nane Bala tumbraŋ promba Abinadab tuku wande tabe fudiŋ mbol minna ta mbol kinaig ka Kuate tuku tukul bokis ta tumba ka karis abonu mbolŋge pilnaig sulumba luka kambim bafunaig. Taŋamba Abinadab tuku kiŋo kat nuŋe Usa nale Ahio ndoŋ tiŋga karis ndin tumtummba didika kinaig. ");
INSERT INTO ssd_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","Ahio nu amboŋgina. ");
INSERT INTO ssd_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","Taŋana le David nuŋe kuasmbi Israel ŋakmba karis ta dubimba kupesmba pate-pateŋga mune kueŋka gita tagail tambariŋ agaŋ ndende yeki yeki katniŋmba Kuate tuku nyu te-duŋga kinaig. ");
INSERT INTO ssd_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","Kile kuasmbi ta nane Nakon tuku wit baurŋganu ma mbol pronaig le makau pailnu karis didikinaik ta mbiki-mbikekina le Kuate tuku tukul bokis ta bariska ndekam bafuna le Usa ndek wai pilmba bokis ta biye tina. ");
INSERT INTO ssd_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","Taŋana le Suŋgo nu Usa tuku gubrana le nu balena le kumna. Ta ndaŋam? Usa nu Kuate tuku tukul bokis ta ake agaŋ ande ŋga idusna sulumba biye tina tukunu Suŋgoŋge nu balena le kumna. ");
INSERT INTO ssd_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","Taŋana le David nu wam ta tuku ndagarina. Kile nane ma ta nyunu Peres Usa ŋgade. ");
INSERT INTO ssd_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","Kile David nu Suŋgo kuru-kuruka sakina: Ye kile ndaŋndaŋmba Suŋgo tuku tukul bokis te tumba ka yiŋe tugum pili le minamŋgat ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","nu bokis ta tumba Yerusalem kine ndaka mbilmba nu Gat tumbraŋ Obed-Edom tuku wande mbol kina. ");
INSERT INTO ssd_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","Pro taŋge nu bokis ta kusrena le tambun keŋmba Obed-Edom tuku wande mbol taŋge minna. Minna le Suŋgo nu taŋgo ta tuku kuasmbi nyaro mayenu niŋgina. ");
INSERT INTO ssd_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","Gabat suŋgo David nu Obed-Edom nuŋe gageu ndoŋ Suŋgoŋge nyaro niŋgina pasa ta sanaig le ismba nu tiŋga Obed-Edom tuku wande mbol kumba Kuate tuku tukul bokis ta tumba Yerusalem kambim tuku ŋga tiŋga kina le Israel taŋgo pino ŋakmba ndek gare-garekinaig. ");
INSERT INTO ssd_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","Nane Suŋgo tuku tukul bokis ta tumba kuramba kambim saka taŋgo kupe diram 6-naig sulumba tiŋginaig le David ndek makau pailnu suŋgokanu ande fatnu butuknu ande turmba kilmba Suŋgo tuku atraukina. ");
INSERT INTO ssd_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","Taŋamba David ndek pris tuku tawi kaukauk tiŋmba gare-gareka kupesmba pate-pateŋga Suŋgo tuku nyu te-duŋgina le ");
INSERT INTO ssd_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","Israel taŋgo pino ŋakmba David ndoŋ gare-gareka ŋgumbeyumba tabil fitka Suŋgo tuku tukul bokis ta tumba Yerusalem kinaig. ");
INSERT INTO ssd_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","Nane taŋamba tukul bokis ta tumba David tuku tumbraŋ sinam kinaig le Saul kulim nuŋe Mikal nu bubre malaŋga kumam mambilmba David nu kupesmba pate-pateŋga kupe sili-salemba Suŋgo tuku nyu te-duŋga kina le kaŋgermba nu talana. ");
INSERT INTO ssd_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","Kile nane Suŋgo tuku tukul bokis ta tumba David baibai ande pilna ta sinamŋge pilnaig le minna. Taŋamba nu ndek agaŋmor afu kilmba bale farka pasoka ŋgamuŋgal ulendiwam tuku agaŋmor turmba atraukina. ");
INSERT INTO ssd_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","Wam ta ke sugluka David ndek taŋgo pino ŋakmba saniŋmba sakina: Suŋgo Saŋgri Ŋayo nu tane ŋakmba nyaro tiŋguwa ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","nu ndek taŋgo pino yimyam bret, ndem pasokanu, bret foŋfoŋ grep tiŋnu mbilmba pasokanu ŋak ta walmba niŋge likina le nane kilmba sili-silimba naŋgine tumbraŋ tumbraŋ kine likinaig. ");
INSERT INTO ssd_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","Taŋanaig le David nu tiŋga nuŋe wande mbol kumba nuŋe gageu nyaro pasa niŋgina le Mikal pro nu te-silikumba nu sawe lika sana: Osese. Israel mbal tuku gabat suŋgo, ne naŋe nyu suŋgo te-duŋga ŋginŋgan taŋgo taŋaŋ agaŋ ndende paskat le gabat kame tuku piro pino kameŋge kaŋgernaig ŋga sawe likina le ");
INSERT INTO ssd_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","David ndek lafumba sana: Ye Suŋgo tuku nyu te-duŋga pate-pateŋgit. Nuŋge mam naŋe tuku kuasmbi pitaika ye Israel tuku gabat suŋgo minam tuku madiyina ta tuku ye gare-garekit. Ye maŋ taŋamba ndo Suŋgo tuku nyu te-duŋga ");
INSERT INTO ssd_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","yiŋe nyu te-ibeŋmba mini le piro pino kame ne nane tuku sakat ta naneŋge ye tuku nyu te-duŋgamŋgaig ŋga Mikal sana. ");
INSERT INTO ssd_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","Taŋamba sana le Saul kulim nuŋe Mikal nu niŋka ake saibo pilmba kumna. ");
INSERT INTO ssd_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","David Suŋgoŋge kigraibka sinzaŋna le nu nuŋe wande mbolŋge mine mayemba ŋgueu mbalŋge nu ŋayo sili ndanaig. ");
INSERT INTO ssd_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Ta tuku David ndek tuan taŋgo Natan sana: Yiŋe wande te suŋgokanu ail sidambi wakeigeŋ. Kuate tuku tukul bokis ta ake kilim baibai sinamŋge minit ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Taŋamba sana le Natan ndek pasa lafumba sana: Suŋgo nu ne ndoŋ minit tukunu ne wam ndaŋ kam idusmba kande ne ka ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Taŋamba nu luka nuŋe wande mbol kina le furir ŋgamu Suŋgo nu Natan tugum promba wam pagumba sana: ");
INSERT INTO ssd_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","Ne ye tuku miŋge tumba kaye ka yiŋe piro taŋgo David teŋenmba sawa. Nuŋge ye minam tuku wande wakeiwa ŋga ye idus ndawet. ");
INSERT INTO ssd_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Ye o buk Israel mbal Isip mbal tuku wai mbolŋge kile-luka kilen ait ta ye wande suŋgo ande mbol nda minen. Ye ake kinenumba baibai sinamŋge ndo minen sulumba kile ye minmba minet. ");
INSERT INTO ssd_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Ye ma ŋakmba mbolŋge Israel kuasmbi ndoŋ kine promba minen sulumba gabat kame madiniŋgen ta nane saniŋmba tane ye tuku wande mayenu ail sidambi wakeiye sap ŋga sa ndaken. Ne ka taŋamba nu sawa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Taŋamba nu maŋ lato Natan sana: Ne ka yiŋe piro taŋgo David teŋenmba sawa. Suŋgo Saŋgri Ŋayo nu teŋenmba ne tuku sakat. Yeŋge o buk ne sipsip kulatka minna le ne Israel mbal kulatka ŋga madinen. ");
INSERT INTO ssd_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Ye ne ndoŋ ma animbi kine promba minna ta ye ne ndoŋ minmba minen. Yeŋge ne sinzaŋnen le naŋe ŋgueu mbal ŋakmba bale farkina. Kile ye maŋ lato ne sinzaŋni le gabat sugo nyu ŋak ŋak mine likade taŋaŋ minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","Ye yiŋe kuasmbi Israel tuku kilke ande madiwi le nane minyoka wamdus mukuk piti kugatok minamŋgaig. O buk nane ma tugu te mbol pronaig le ŋgueu mbalŋge kilmba ŋaigo siglikinaig ta kile yeŋge tane kigraibki le ŋgueu mbalŋge tane maŋ ŋaigo siglike nda. Yeŋge pasa saŋgrinu sanet. Ne tuku ndare puluka tugeka minmba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Ne kuma le ŋgukuwaig ta yeŋge ne tuku kiŋo ande maŋ madiwi le gabat suŋgo minamŋgat. Nuŋge nuŋe kuasmbi ta kulatkuwa le nane saŋgri ŋak minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Nuŋge tiŋga ye tuku wande suŋgo te-tiwamŋgat. Yeŋge ndo gabat sugo ndare ndui ta mbolŋge madiniŋgi le tugeka tuturmba minmba minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Yeŋge ndo nu tuku mam taŋaŋ mini le nu yiŋe kiŋo taŋaŋ minamŋgat. Nu mbarwa ta ye nu te-tiwam tuku ŋgusamŋgit. Kiŋo nu mbarte le mam nuŋeŋge nu te-tiwam tuku ŋguste taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Taŋamba ye nu tuku kume purmba minamŋgit. Ye buk Saul pitaiwen le ne nu tuku ma tina taŋamba maŋ ke nda. ");
INSERT INTO ssd_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Ne tuku ndare tugekamŋgat. Ye naŋe ndare kulatka sinzaŋniŋgi le minmba minamŋgaig. Ne tuku ndare ta ndo tuturmba gabat sugo sugo promba minmba minamŋgaig. Ne ka taŋamba David kubeu tawe ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Natan Kuateŋge dir pasa sana ta ka taŋamba ndo David kubeu tuna. ");
INSERT INTO ssd_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","Kubeu tuna le gabat suŋgo David nu tiŋga Suŋgo tuku Baibai sinam kumba ka taŋge minyoka Suŋgo yabaŋmba sana: O Kuate Suŋgo, ye yiŋe gageu ndoŋ sine ne am mbolŋge magenu kuga ta ne ye mbol wam magenu ndo kate. ");
INSERT INTO ssd_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","O Kuate Suŋgo, kile ne maŋ lato ye tuku ndare mbolŋge wam magenu kam sakate. Ye ake taŋgo ndo ta ne wam suŋgo ye mbolŋge kamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","Ye kile ame pasa ne sani? Ye ne tuku piro taŋgo ndo ta ne kila. ");
INSERT INTO ssd_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","Ta tuku ne naŋe pasa saŋgrinu dubimba wam suŋgo ta ye mbolŋge kamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","O Kuate Suŋgo, ne o mbolok. Ande ne suk nda minit. Ne ndindo Mbara Suŋgo ta o buk siŋgine wa kame tuku miŋge mbolŋge isgeŋ. ");
INSERT INTO ssd_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","Taŋgo pino kuasmbi afu sine suk mine ndakade. Ne o buk sine Israel mbal Isip kilke mbolŋge sanzal mingeŋ le kile-luka kilmba sine ne tuku kuasmbi minam tuku madisiŋgina. Ne sine Israel mbal turkam tuku wam kitek saŋgrinu ke lika sine kilmba pro kilke te mbol prona. Taŋamba ne kilke te mbolŋge minnaig mbal naŋgine yabri mbara turmba ŋaigo siglika pitaikina le kilke tugu ŋakmba taŋgo pino ne tuku nyu isnaig. ");
INSERT INTO ssd_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","O Suŋgo, ne sine Israel tugu ne tuku kuasmbi ndo minam tuku madisiŋgina tukunu sine ne tuku ndo minbe le ne sine tuku Mbara minmba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","O Kuate Suŋgo, ne dir pasa sakat ta ye mbolŋge yiŋe ndare tuturmba kaŋgat ta ŋakmba mbolŋge kumuŋguwa. ");
INSERT INTO ssd_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","Taŋawa le ne tuku nyu o mbolŋge minmba minwa le nane teŋenmba sakamŋgaig: Suŋgo Saŋgri Ŋayo nu Israel mbal tuku Mbara minit ŋgamŋgaig. Taŋamba neŋge ndo gabat sugo ye tuku ndare mbolŋge madiniŋga le tuturmba minmba minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","O Suŋgo Saŋgri Ŋayo, ne sine Israel mbal tuku Mbara. Ne buk ye sayumba sakina: Ne tuku ndare kame ta mara mindek saŋgri ŋak minamŋgaig ŋga sayina. Ta tuku ye naŋe piro taŋgo ye gabat kuilŋga yabaŋnet. ");
INSERT INTO ssd_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","O Kuate Suŋgo, ne ndo mbolŋge minit. Ne naŋe pasa saŋgri pilete ta ne kumumbi kate. Ne ye mbolŋge mata taŋamba ndo kamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","O Kuate Suŋgo, ne naŋe pasa ta idusmba mara mindek ye tuku ndare nyaro niŋmba mina le nane ne kumnemŋge nyaro pasa ta ŋak minmba minwaig ŋga Kuate sana. ");
INSERT INTO ssd_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","Taŋamba minnaig sulumba David ndek nuŋe kame mbal kilmba Filistia mbal ndoŋ kame bunaig. Kame bumba bale farka naŋgine tumbraŋ suŋgo ta tina. ");
INSERT INTO ssd_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","Tina sulumba kile nu ka Moab mbal ndoŋ kame bumba nane afu bige tidiŋgina. Bige tidiŋga nane kile-maŋgurka kilke mbolŋge truk ka kuit nduimba kinyap ŋga saniŋgina le nane taŋamba kilke mbolŋge truk ka kinynaig. Truk ka kinynaig le nu ndek taŋgo keŋ keŋ burka armba baleniŋmba ndindo mapemba armba baleniŋmba ndindo mapemba taŋamba ndo ka ka bitekŋgina. Afu mapekina ta nane David kumnemŋge nu tuku piro taŋgo minmba naŋgine pirokanu piya ta nu tumba minnaig. ");
INSERT INTO ssd_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","Kile Soba tuku gabat suŋgo Hadadeser nu nuŋe kame kuasmbi kilmba Yufretis kule makembi kilke ta luka tam saka kame kinaig. (Hadadeser mam nuŋe Rehob. Nu Siria kilke Soba ma tugu kulatkina). Kame kinaig le David tuku kuasmbi nane kile-siglika kame bumba nane suŋgomba bige tidiŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","Nu hos mbol mbol kame buwanu taŋgo kame 1,700 bige tidiŋgina sulumba ibeŋŋge kame buwanu taŋgo 20,000 bige tidiŋgina. Taŋamba nu hos karis didika pinderkanu ta ŋakmba yaika kilmba afu kupe kat ŋgurŋgurniŋmba kusrekina sulumba 100 ndo nuŋe kilna. ");
INSERT INTO ssd_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","Kame suŋgo ta minmba minna le Siria gabat afu Damaskusŋge minnaig ta nane ndek gabat suŋgo Hadadeser turam tuku kame kuasmbi suŋgo ande kukulnaig le David ndoŋ kame buwam saka pronaig kande David tuku kame kuasmbiŋge nane tuku kame taŋgo 22,000 bale farnaig. ");
INSERT INTO ssd_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","Taŋanaig sulumba David ndek kame maŋ nda tiŋguwa ŋga nuŋe kame mbal afu kilmba Siria kilke mbol patike likina le kilke suŋgo ta kulatka minnaig. Kulatka minnaig le Siria mbal nane David kumnemŋge nu tuku piro taŋgo minmba naŋgine pirokanu piya ta nu tumba minnaig. Taŋanaig le David Suŋgoŋge sinzaŋna le nuŋe ŋgueu mbal ŋakmba kile-ibeŋkina. ");
INSERT INTO ssd_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","Kile David ndek Hadadeser tuku gabat sugo sugo naŋgine kandim golmbi wakeikanu migreke lika pronaig ta ŋakmba yaika kilna sulumba ");
INSERT INTO ssd_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","Hadadeser tuku tumbraŋ sugo Beta le Berotai nane tuku agaŋ ndende ainmbi wakeikanu ta mata suŋgomba yaika kilmba yomba Yerusalem kinaig. ");
INSERT INTO ssd_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","David nu Hadadeser tuku kame kuasmbi bale farmba kile-ibeŋkina pasa ta Hamat tuku gabat suŋgo Toi nu isna. ");
INSERT INTO ssd_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","Toi nu mara mindek Hadadeser ndoŋ kame ndo minna tukunu nu gare-gareka nuŋe kiŋo nuŋe Yoram David sota kuwa ŋga gare agaŋ ndende gol silwa ainmbi wakeikanu ta kile-tumba kukulna le David kile-tambim tuku kina ka nu tugum prona. ");
INSERT INTO ssd_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","Prona sulumba agaŋ ndende ta David kile-tuna le nu ndek agaŋ ndende ta Suŋgo tuku minwaig ŋga kilmba ka gabis agaŋ ndende gol silwa ain ŋgueu mbal afu ndoŋ kame bumba yaika kile likina ta turmba ulendimba patikina. ");
INSERT INTO ssd_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","Nu gol silwa gabis agaŋ ndende ta ŋakmba Edom Moab Amon Filistia Amalekŋge kile likina. Agaŋ ndende afu Sobanu gabat suŋgo Hadadeser yaimba kile likina tuku. ");
INSERT INTO ssd_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","Kile David nu maŋ nuŋe kame kuasmbi kilmba Edom mbal ndoŋ kame buwam tuku ma gutoŋ Kagli Ŋayo ta kinaig sulumba Edomnu taŋgo 18,000 bale farnaig le taŋgo pino ŋakmba nane David tuku saka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","Taŋamba David ndek nuŋe kame kuasmbi afu kilmba Edom ma tugu ta ŋakmba kulatkuwaig ŋga patikina le Edom mbal nane nu kumnemŋge minnaig. Suŋgoŋge David sinzaŋna le nu ma ŋakmba mbol kumba nuŋe ŋgueu mbal ŋakmba kile-ibeŋkina. ");
INSERT INTO ssd_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","Taŋamba David nu Israel ma tugu ŋakmba kulatkumba taŋgo pino ŋakmba mbolŋge wam magenu ndo ke likina. ");
INSERT INTO ssd_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","Seruya kiŋo nuŋe Yoab nu kame kuasmbi ŋakmba tuku gabat suŋgo minna. Ahilud kiŋo nuŋe Yehosafat nu waŋe kuyaram tuku piro kulatkina. ");
INSERT INTO ssd_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","Sadok le Ahimelek nale pris pirokinaik. (Sadok mam nuŋe Ahitub. Ahimelek mam nuŋe Abiatar). Seraya nu David tuku waŋe kuyaranu taŋgo. ");
INSERT INTO ssd_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","Yehoyada kiŋo nuŋe Benaya nu David kulatkanu kuasmbi tuku gabat minna. (Nane kuasmbi ta Keret le Pelet mbal). David tuku kiŋo kat nuŋe ta nane pris pirokinaig. ");
INSERT INTO ssd_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","Taŋamba minnaig ma ma David nu taŋgo afu wika kusnaniŋgina: Saul tuku ndare ande minit e ko kuga. Ande minwa ndeta ye Yonatan idusmba nu kulatkamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","nane ndek Saul tuku piro taŋgo Siba wika David sota kuwa ŋga sanaig. Taŋamba sanaig le nu ndek nu kaŋgeram kina le David nu taŋgo ta kusnana: Ne Siba e ŋgina le nu lafumba sakina: Au. Ye ne tuku piro taŋgo ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","Taŋakina le David maŋ lato nu sana: Saul tuku ndare inum minwa ndeta ye Kuate tuku nyu mbolŋge nu kulatka sinzaŋamŋgit ŋga sana le Siba ndek lafumba sakina: Yonatan tuku kiŋo ndindo ndo minit ta nu kupe arŋeŋ pagliskinaik ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","Taŋaka sana le David maŋ Siba kusnana: Nu kile aniŋge minit ŋgina le nu ndek sakina: Nu Lodebar tumbraŋŋge Amiel kiŋo nuŋe Makir tuku wande mbolŋge minit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","Taŋaka sana le David ndek taŋgo afu kukulniŋmba saniŋgina: Tane kumba ka nu tumba ye tugum te prowap ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","nane kinaig ka Saul wa nuŋe Mefiboset, Yonatan tuku kiŋo nuŋe ta tumba David tugum pronaig le nu David tumailamŋge dagol tidroŋga lokina. Taŋana le David ndek nu sana: Ne Mefiboset e ŋgina le nu woka sakina: Ye piro taŋgo naŋe ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","David nu sana: Ne kuru kuru ndaka. Ye mam naŋe Yonatan tuku ŋga ye ne kulatka sinzaŋnumba wa naŋe Saul tuku kilke ta ŋakmba luka tanmbimŋgit. Ne mara mindek ye tugum teŋge ndo isukusamŋgat ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","Taŋakina le Mefiboset ndek loka sana: Ye taŋgo ŋai ŋguesuk kuga age kumak taŋaŋ ta ne ndaŋam ye sinzaŋyam sakate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","Kile David ndek Saul tuku piro taŋgo Siba wika sana: Ye naŋe gabat suŋgo Saul tuku agaŋ ndende ŋakmba kile ndo luka wa nuŋe Mefiboset tambimŋgit. ");
INSERT INTO ssd_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","Ta tuku ne naŋe kiŋo kame naŋe piro mbal taneŋge ndo kilke ta mbolŋge piroka nyamagaŋ ŋguka minap. Nyamagaŋ ka magekuwaig le alonu kilmba naŋe gabat suŋgo Saul tuku kuasmbi ta niŋgap. Mefibosetŋge ndo ye tugum teŋge isukusmba minamŋgat ŋga Siba sana le ");
INSERT INTO ssd_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","nu ndek David sana: Ye ne tuku pasa ta kumuwamŋgit ŋgina. Taŋakina le Mefiboset nu mara mindek gabat suŋgo David tugumŋge nuŋe kiŋo nuŋe taŋaŋ isukusmba minanu. ");
INSERT INTO ssd_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","Mefiboset nu kiŋo ndindo ndo ŋak. Kiŋo mo ta nyunu Mika. Siba tuku kiŋo kame nu tuku piro mbal nane ŋakmba Mefiboset tuku piro taŋgo ndo minnaig le ");
INSERT INTO ssd_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","Mefiboset nu Yerusalemŋge minmba mara mindek gabat suŋgo David tugumŋge isukusmba minanu. Nu nuŋe kupe arŋeŋ pagliskinaik. ");
INSERT INTO ssd_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","Amon mbal tuku gabat suŋgo Nahas kumna le kiŋo nuŋe Hanun ndek mam nuŋe tuku ma tumba gabat suŋgo mayok kina le ");
INSERT INTO ssd_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","David nu wam ta ismba sakina: Ye wam mayenu Hanun mbol kamŋgit. Mam nuŋe Nahas nu buk wam mayenu ye mbol kina ta lafumba kamŋgit ŋgina sulumba taŋgo afu kukulniŋgina le nane Nahas tuku wamdus bul seram kinaig. Kinaig ka ta promba minnaig le ");
INSERT INTO ssd_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","Amon mbal tuku gabat kame ndek naŋgine gabat suŋgo sanaig: Ne iduste taŋgo kame te David tuku miŋge tumba mam naŋe idusmba nu ninankam prowaig ŋga iduste e? Kuga. Nane sine tuku tumbraŋ ndaŋ ndaŋ ta kaŋgermba wam katesewam prowaig. Taŋamba ŋgumneŋga nane sine tuku kamenu luka prowamŋgaig ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","Taŋakinaig le Hanun nu pasa ta ismba nu ndek David tuku taŋgo kame ta bige-tidiŋga nane tuku miŋge ŋgue dabilsu inum tuku saike sugluka tawi kat naŋgine kat pur fagke likina le pine kat naŋgine ta kilimŋge minnaig le kukulniŋgina le luka kinaig. ");
INSERT INTO ssd_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","Taŋamba taŋgo kuasmbi ta kikonu nane luka Yerusalem kambim fugunaig le David nu ismba nuŋe taŋgo kuasmbi ta tuku pasa pilmba sakina: Taŋaig le tane Yerikoŋge minap le ka miŋge ŋgue prowaig le tane luka te prowap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","Kile Amon mbal David ŋgueu pilenaig ta katesemba nane ndek taŋgo afu kukulniŋginaig le Siria kilke mbol kinaig ka Betrehob le Soba tumbraŋ kumba kame dunaig le tumbraŋ ar ta kame taŋgo 20,000 Amon mbal turkam tuku pronaig. Pronaig le Amon mbal maŋ ndek kinaig ka Tob tumbraŋŋge kame dunaig sulumba kame taŋgo 12,000 kilnaig. Taŋamba nane maŋ kinaig ka Maka tumbraŋ tuku gabat suŋgo tugumŋge kame dumba kame kuasmbi 1,000 nane turkam tuku kilnaig. ");
INSERT INTO ssd_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","Amon mbal taŋamba kame kuasmbi kile-maŋgurka minnaig pasa ta David nu ismba nu ndek Yoab kukulna le Israel kame kuasmbi ŋakmba kilmba ka Amon mbal ndoŋ kame buwam kinaig. ");
INSERT INTO ssd_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","Taŋanaig le Amon kame kuasmbi nane naŋgine tumbraŋ suŋgo Raba fonde malaŋga kumamŋge kame tuku kuaneka tiŋginaig le nane Siria kame kuasmbi Tob mbal Maka mbal nane ma kukliknu ta tumba tiŋginaig sulumba Israel mbal tuku kame kuaneka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","Kile Yoab nu kame kuasmbi armba ta nu buk kornaik ta kaŋgerka nu nuŋe kame kuasmbi saŋgriknu pileniŋmba kilmba Siria mbal ndoŋ kame buwam tuku kuaneka tiŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","Taŋamba nu ndek nuŋe maib nuŋe Abisai kame kuasmbi afu kulatkuwa ŋga madina le nu ndek nuŋe kame kuasmbi ta kilmba nane Amon mbal ndoŋ kame buwam tuku kuaneka tiŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","Yoab ndek mambo nuŋe wam pagumba sana: Kame saŋgri tiŋga Siria mbalŋge sine kile-ibeŋkam bafuwaig kande tane ilmba sine turkap. Amon mbalŋge saŋgri tiŋga tane kile-ibeŋkam bafuwaig ta ye yiŋe kuasmbi kilmba pro tane turkamŋgit. ");
INSERT INTO ssd_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","Tane kuru kuru ndakap. Sine siŋgine tumbraŋ kame taŋgo pino Kuateŋge siŋgina ta nane idusniŋmba saŋgri tiŋga kame bube. Taŋabe le Suŋgoŋge ame wam kam idusmba ndeta kuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","Taŋakina sulumba Yoab ndek nuŋe kame kuasmbi kilmba Siria mbal ndoŋ kame puluna le nane kua ka sili-silinaig le ");
INSERT INTO ssd_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","Amon kame kuasmbi Siria mbal drumba sili-silinaig ta kaŋgerka nane mata kuru-kuruka Abisai nane kusreka kua ka naŋgine tumbraŋ fonde sinam kinaig. Taŋanaig le Yoab ndek Amon mbal kusreka nuŋe kame kuasmbi kilmba luka Yerusalem kina. ");
INSERT INTO ssd_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","Nane Siria mbal kame mbolŋge Israel mbalŋge kile-ibeŋkinaig le kua kinaig tukunu nane naŋgine kame kuasmbi ŋakmba kile-maŋgurkinaig. ");
INSERT INTO ssd_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","Taŋamba Hadadeser ndek taŋgo afu kukulniŋgina le nane ka Siria kuasmbi afu Yufretis kule pakarka ki prote kumamŋge minnaig ta nane kilmba pro Helam tumbraŋŋge maŋgurkinaig le Hadadeser tuku kame gabat Sobakŋge nane kulatkina. ");
INSERT INTO ssd_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","Siria mbal Helamŋge kame tuku maŋgurka minnaig le David nu ismba nu ndek Israel kame kuasmbi kilmba Yordan kule pakarka Helam pronaig. Taŋanaig le Siria mbal tiŋga Israel mbal ndoŋ kame bunaig le ");
INSERT INTO ssd_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","Israel mbal saŋgri tiŋga Siria mbal signaniŋmba ka taŋgo karis mbol tiŋga kame buwanu ta 700 bale farka taŋgo hos mbol mbol minyoka kame buwanu ta 40,000 bale farnaig sulumba Siria mbal tuku kame gabat Sobak turmba kame ma ta mbolŋge balenaig le kumna. ");
INSERT INTO ssd_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","Taŋanaig le tumbraŋ gabat sugo afu Hadadeser kumnemŋge minnaig ta nane Israel mbalŋge kame mbolŋge kile-ibeŋkinaig ta tuku kuru-kuruka Israel mbal ndoŋ pasa katmba nane kumnemŋge minnaig. Taŋamba Siria mbal nane Israel mbal tuku kuru-kuruka Amon mbal maŋ kame tuku tur ndaniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Yar ndui ndui sinamŋge ma tidonu ka deŋpurkanu le gabat sugo sugo nane ait ta dubimba naŋgine ŋgueu mbal ndoŋ kame buwanu. Ait ta mbolŋge David ndek Yoab kame gabat sugo sugo ta Israel kame kuasmbi ŋakmba kukulniŋgina le nane kinaig ka Amon mbal ndoŋ kame bumba nane bale farkinaig sulumba naŋgine tumbraŋ suŋgo Raba te-kornaig le David nu nuŋe ndo Yerusalemŋge minna. ");
INSERT INTO ssd_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Minna ka ki ait ande ma bafuna le David nu nuŋe kinyam mbili kusremba bubre tam saka wande fu mbolŋge kinenumba bubre tumba minna. Minna sulumba pino ande kule pismba minna le kaŋgerna. Pino ta mayenu ndo. ");
INSERT INTO ssd_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Kile David ndek taŋgo ande kukulmba sana: Ne kaye ka pino ima kule pismba minit nzi ka katesewa ŋgina le taŋgo ta ka katesena sulumba pro David sana: Pino ne sakat ta Eliam tuku kulim nuŋe Batseba. Nu Hitnu taŋgo Uria tuku piyo nuŋeŋge ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Taŋakina le David maŋ taŋgo afu kukulniŋmba saniŋgina: Tane kape ka pino ta tumba ye tugum te mbape ŋgina. Batseba nu nzuam minna ta kile nu kule mayenu tina tukunu nu tiŋga taŋgo kame ta dubika kina le David nu tumba kinyna. Kinye deŋpurmba nu maŋ luka nuŋe wande mbol kina. ");
INSERT INTO ssd_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Minna ma ma Batseba nu kiŋo konna ta kamusmba David tuku pasa pilna le nu ismba ");
INSERT INTO ssd_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Yoab tuku pasa pilmba sakina: Hitnu taŋgo Uria sawa le ye tugum te prowa ŋgina. Taŋakina le Yoab ndek Uria kukulna le David tugum kina. ");
INSERT INTO ssd_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Nu pro David te-silikina le nu ndek Uria kusnana: Yoab nuŋe kame kuasmbi ndoŋ mage minig e ko kuga? Kame kile ndaŋndaŋmba minit? Siŋgine kuasmbiŋge nane kile-ibeŋkade e ko kuga ŋgina le Uria ndek wam kame ta ŋakmba kubeu tuna. ");
INSERT INTO ssd_vpl VALUES ("S211_8","011_11_8","2SA","11","8","9","Taŋana le David ndek Uria sana: Wam kube ŋakmba sayat le isit. Kile ne kaye ka naŋe wande mbolŋge mabtumba mina ŋga sana kande Uria nu gabat suŋgo tuku wande kusremba kilim ka nuŋe wande mbol kine ndakina. Nu gabat suŋgo tuku kulat taŋgo kame ndoŋ wande malaŋgambi taŋge kinyna. Taŋana le David ndek taŋgo ande wika Uria tuku gare agaŋ inum te-tumba kukulna le kina sulumba ");
INSERT INTO ssd_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","luka pro David sana: Uria nu nuŋe wande mbol ndaket ŋgina. Taŋakina le David pro Uria te-silika sana: Ne o buk naŋe wande kusrena ta ndaŋam tuku ne naŋe wande mbol kine ndakat e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Uria ndek pasa lafumba sana: Israel taŋgo kuasmbi Yuda taŋgo kuasmbi ŋakmba wande kusreka maskenŋge kame mbolŋge minig. Pasa katanu bokis mata nane ndoŋ minit. Yiŋe kame gabat Yoab nuŋe gabat sugo sugo mata kilimŋge kinymba minig. Ndaŋam ye ka pino ndoŋ isukuse mayemba kinye mayemba minam tuku sayate? Ye siŋka ki am mbolŋge sanet. Ye wam ta ke nda ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Taŋaka sana le David ndek nu sana: Ta maye. Ne teŋge mina. Indole ne maŋ pili le luka kaŋgat ŋgina. Taŋakina le Uria nu Yerusalemŋge kinyna le ka mafena. ");
INSERT INTO ssd_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Mafena le ka furiram David ndek Uria wika nu ndoŋ tuma isukusnaik. Isukuse deŋpurmba nu ndek Uria kule kamenu tuna le nyumba ŋginŋgankina ta nu nuŋe wande mbol kine ndakina. Nu wande kulatkanu mbal ndoŋ tawi kaika kawaŋ taŋge kinyna. ");
INSERT INTO ssd_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Mafena le maratukuk tiŋga David ndek Yoab tuku waŋe ande kuyarmba Uria tumba kukulna le tumba kina ka Yoab tuna. ");
INSERT INTO ssd_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Waŋe ta mbolŋge kuyarmba teŋenmba sakina: Kame saŋgri tiŋguwa kande Uria tumba kame tumailamŋge pilmba kigraib ndakap le balewaig le kumwa ŋga kuyarna. ");
INSERT INTO ssd_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Yoab nuŋe kame kuasmbi ndoŋ Raba tumbraŋ suŋgo ta kormba kame bumba minnaig le ka kame saŋgri tiŋgina. Kame saŋgri tiŋgina magot ta Uria kukulna le kame tumail mbol tiŋgina. ");
INSERT INTO ssd_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Tiŋgina le tumbraŋ ta tuku kame kuasmbi fonde malaŋga talka kilim ka pro Yoab tuku kame kuasmbi ndoŋ kame bumba David tuku kame taŋgo afu bale farnaig sulumba Uria turmba balenaig le kumna. ");
INSERT INTO ssd_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Taŋana le Yoab ndek taŋgo ande wika wam pagumba sana: Ne kame tuku pasa te tumba gabat suŋgo David sota kumba ");
INSERT INTO ssd_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","kame mbolŋge wam prowe likaig ta ŋakmba kubeu tawe. ");
INSERT INTO ssd_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","Taŋawa le nu gubra tumba teŋenmba ne sanuwa: Tane ndaŋam tuku tumbraŋ fonde patumba kame buwaig? Ŋgueu mbal nane fonde mbolŋge tiŋga tane tuimbi ninde faramŋgaig ta tane idus ndanaig? ");
INSERT INTO ssd_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","O buk Tebes tumbraŋŋge pino ande tumbraŋ koranu fonde mbolŋge tiŋga wit firfiranu ndame suŋgo ta mbarina le ndeka Gideon tuku kiŋo nuŋe Abimelek balena le kumna ta tane gilai le ka fonde tugumŋge tiŋgaig e ŋga ne sanuwa kande ne teŋenmba gabat suŋgo tuku pasa lafumba sawa: Kame gabat Uria turmba balewaig le kumat ŋga nu sawa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Yoab nu taŋamba taŋgo ta wam paguna le nu pasa ta tumba ka David tugum promba nu kubeu tuna sulumba ");
INSERT INTO ssd_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","sakina: Ŋgueu mbal nane kuasmbi suk suk kuga. Sine suŋgomba ndo kuga tukunu nane kilim kumba sine ŋak ma kilimŋge kame buwaig le sine saŋgri tiŋga nane kile-ibeŋkig le nane luka tumbraŋ fonde sinam kagig. ");
INSERT INTO ssd_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Taŋamba nane afu fonde mbol tiŋga tuimbi ne tuku kame gabat afu ninde farkaig le kumaig. Kame gabat Uria turmba balewaig le kumat ŋga David sana le ");
INSERT INTO ssd_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","nu ndek taŋgo ta lafumba sana: Ne kumba ka teŋenmba Yoab sawa. Ne wamdus sulu ndawa. Kame mbolŋge ima kumamŋgat ta sine gilai tukunu ne saŋgri tiŋga nane ndoŋ kame bumba tumbraŋ ta tumu pilmba tumbraŋ sina minyaŋga ŋga Yoab sawa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Batseba taŋgo nuŋe balenaig le kumna pasa ta nu isna sulumba wamdus tatrukina le ninanka malmbi ŋakmba minna. ");
INSERT INTO ssd_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Nu tuku kuamel ta ka kugana le David ndek pasa pilna le Batseba tumba nu tugum kinaig le nuŋe pinonu tina. Pinonu tumba minnaig ma ma nu tuku kiŋo te-pile tuna ta Suŋgo nu David maŋau kina ta tuku gare ndana. ");
INSERT INTO ssd_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Kile Suŋgo nu tuan taŋgo Natan kukulna le ka David tugum promba nu sana: Taŋgo armba tumbraŋ suŋgo ndindo mbolŋge minnaik. Taŋgo ande nu maror taŋgo. Ande nu sanzal taŋgo agaŋ ndende kugatok ŋak minna. ");
INSERT INTO ssd_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Maror taŋgo ta nu makau sipsip suŋgomba ŋak. ");
INSERT INTO ssd_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Sanzal taŋgo nu sipsip fat ndindo ndo nu piyamba tumba kulatka minna le ka suŋgoka taŋgo ta tuku kiŋo kat nuŋe ndoŋ minna. Nu nuŋe nyamagaŋmbi nu isukusnemba nuŋe murkombi nu kule tambinu le nu kule nyumba kinyam ŋga ta nu tumba nuŋe fel mbol palmbinu le nu kinymba minanu. Taŋamba sipsip ta nuŋe kulim nuŋe taŋaŋ minna. ");
INSERT INTO ssd_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Ait ande maror taŋgo ta tuku tira ande nu tugum prona le nu nuŋe sipsip ta mapeka sanzal taŋgo ta tuku sipsip yaimba tumba balemba tira nuŋe ta tuku kuapika tuna le nyina ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Taŋamba sana le David ndek Natan tuku pasa lafumba maror taŋgo ta tuku gubra kagli firka sakina: Suŋgo abo tugu ŋak nu tuku nyu mbolŋge ye siŋka saket. Taŋgo ima nu taŋana ta nu balewap le kumwa ta maye. ");
INSERT INTO ssd_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Nu sanzal taŋgo ta sina ndana tukunu nu taŋgo ta tuku sipsip lafumba bailkamba tuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Taŋakina le Natan ndek David sana: Maror taŋgo ta ne. Sine Israel mbal tuku Mbara Suŋgo ne tuku teŋenmba sakate. Yeŋge ne Israel mbal tuku gabat suŋgo minam tuku madinen. Taŋamba yeŋge ne kigraibken le Saul nu ne ŋayo sili ndanina. ");
INSERT INTO ssd_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Yeŋge Saul tuku wande agaŋ ndende ŋakmba pino kuasmbi turmba ne tinmba ne Israel Yuda ma tugu ŋakmba tuku gabat suŋgo madinen. Ne agaŋ afu denka ye kusnayina kande ye agaŋ ndende suŋgomba turmba tinen kande. ");
INSERT INTO ssd_vpl VALUES ("S212_9","011_12_9","2SA","12","9","10","Ta tuku ne ndaŋam saka ye tuku miŋge ŋgurmba une maŋau ta kina? Ne ye talayumba Uria tumba Amon mbal tuku wai mbolŋge pilna le balenaig. Taŋanaig le ne nu tuku piyo nuŋe tina. Ta tuku naŋe ndare mbolŋge wa kat naŋe tuku ndare mbolŋge tuturmba lafunu ndare kutumba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Yeŋge ne kasur pasa sanet. Naŋe ndare taŋge tiŋga ne piti tanmbimŋgat. Yeŋge piyo kat naŋe ta kilmba ne am mbolŋge naŋe ndare ta seri le ma kilimŋge kilmba tido-tidoŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Ne kuirkuirka wam ŋayonu ta kina ta ye lafunu Israel mbal ŋakmba tuku am mbolŋge ki le kaŋgeramŋgaig ŋga sakate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Taŋakina le David ndek sakina: Ye Suŋgo kumammba nu am mbolŋge une suŋgo ken ŋgina le Natan ndek lafumba sana: Suŋgo nu ne tuku mbar ta sauka gilaiŋgate. Ne kume nda. Kiŋo naŋe Batsebaŋge te-pile tinna ta ndo nu mapewe nda. Ta ndaŋam? ");
INSERT INTO ssd_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Ne unekina wam ta mbolŋge ŋgueu mbalŋge Suŋgo maim maim te-tumba talade tukunu kiŋo ta kumamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Taŋakina sulumba Natan nu tiŋga nuŋe wande mbol kina. Taŋamba minnaig ma ma Suŋgoŋge David tuku kiŋo ta guaze suŋgo serna le ");
INSERT INTO ssd_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","David ndek kiŋo nuŋe mayekuwa ŋga Suŋgo yabaŋmba nyamagaŋ pinka minna. Furir mindek nu ka nuŋe kinyanu ma ta sinam kumba ka ake ibeŋŋge kinyanu. ");
INSERT INTO ssd_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Taŋawanu le mage mage nu kulatka pirokanu kuasmbi ta ka nu wam yoyomba tiŋga isukuswa ŋginaig kande nu tiŋga nane ndoŋ isukusam mbulna. ");
INSERT INTO ssd_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Kusem ndindo kina le kiŋo ta kumna le David tuku piro mbal nu sawam tuku kuru-kuruka naŋgine naŋgine ndek sakinaig: Kiŋo nuŋe kume ndaka minna le sine nu ndoŋ pasa-pasakigeŋ ta nu sinembik ri ndana. Ta tuku kile sine nu kiŋo nuŋe kumat ta ndaŋmba sabe? Sabe le nu pirirek purka nuŋe ŋgaro ŋayo siliwikat ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Nane sisu-sasuka pasata minnaig le David nu kiŋo nuŋe kumna ta buk katesemba nane kusnaniŋgina: Kiŋo kumat e ŋgina le nane ndek lafumba sanaig: Au. Nu kumat ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Taŋakinaig le David ndek tiŋga ka kule pismba pro gureŋ pismba minde piymba Suŋgo tuku Baibai sinam kumba ka Suŋgo tuku nyu te-duŋgina. Nyu te-duŋge deŋpurmba nu ndek kilim ka luka nuŋe wande mbol kina sulumba pagu taŋgo saniŋgina le nu tuku kuapi kutumba pro tunaig le nu isukusna. ");
INSERT INTO ssd_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Taŋana le piro taŋgo wam ta kaŋgermba ndek nu sanaig: Kiŋo kume ndaka minat le ne pinka malmbika minna. Kile kiŋo kumat le ne tiŋga isukusit ta anikok maŋau ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","David lafumba saniŋgina: Kiŋo kume ndaka minat le ye pinka malmbika minmba teŋenmba idusen. Suŋgo nu ye sinanu kiŋo yaiye nda ŋga idusen ta ");
INSERT INTO ssd_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","nu buk kumat. Ye maŋ pinki le nu aboŋge nda. Nu o buk kumat. Mine minemba ye mata kummba ma ndui ta mbol kaŋgit. Nu ket ta maŋ luka ye tugum prowe nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Batseba nu wamdus tatrukina ta David nu piyo nuŋe wamdus bul serna sulumba nu ndek nu ndoŋ tuma kinynaik. Tuma kinynaik le nu kiŋo konmba David tuku kiŋo ande te-pile tuna le nu kiŋo ta Solomon ŋgina. Suŋgo nu kiŋo ta tuku kume purmba ");
INSERT INTO ssd_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","tuan taŋgo Natan kukulna le David tugum kumba sana: Kiŋo ta Yedidia ŋga nyu tape ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","Ait ta mbolŋge Yoab nuŋe kame kuasmbi kilmba ka Amon mbal ndoŋ Raba tumbraŋŋge kame bumba minnaig sulumba nane buk nane kile-ibeŋka tumbraŋ ta tam bafunaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","Yoab ndek David tuku pasa pilmba sakina: Ye buk nane kile-ibeŋka kule kunyig ma tugu ta tit. ");
INSERT INTO ssd_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","Ta tuku ne braiŋ naŋe kame kuasmbi afu kilmba pro Raba mbal ndoŋ kame bumba tumbraŋ suŋgo te ta. Kuga ta yiŋe kame kuasmbi teŋge tumbraŋ te te-ibeŋwaig le nane tumbraŋ te ye tuku nyu mbolŋge nyun ta Yoab tuku Tumbraŋ ŋgamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","David nu pasa ta ismba nu ndek nuŋe kame kuasmbi kile-maŋgurka kilmba Raba tumbraŋ suŋgo ta kame kinaig ka taŋge kame bumba nane kile-ibeŋka tumbraŋ ta tinaig. ");
INSERT INTO ssd_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","Tinaig sulumba David ndek Amon mbal tuku yabri mbara tuku gol hat paska tina. Hat ta pitinu ta 35 kilo. Hat ta ndame mayenu piya o mbolok tambi wakeiwanu. Taŋamba David ndek ndame mayenu ta gomba tumba nuŋe gol hat ta mbolmba kaikina sulumba tumbraŋ ta tuku gabis agaŋ ndende mage mage ŋakmba yomba kilmba kina. ");
INSERT INTO ssd_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","Kile David ndek Rabanu taŋgo ŋakmba kilmba piro yeki yeki kuwaig ŋga madiniŋgina. Afu sombi afu bairambi afu sapormbi pirokam tuku madiniŋgina sulumba afu kilke kilmba pasoka ndame wakeikuwaig ŋga piro niŋgina. Nu taŋamba ndo tumbraŋ afu Amon ma tugu sinamŋge minnaig ta mata piro niŋge likina. Taŋamba deŋpurmba David nuŋe kame kuasmbi kilmba luka Yerusalem kinaig. ");
INSERT INTO ssd_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","David tuku kiŋo nuŋe Absalom nu kulim ndindo ndo ŋak. Kulim ta nyunu Tamar. David tuku kiŋo ande Amnon nu Tamar tam tuku nzali suŋgo ŋak minna ta ");
INSERT INTO ssd_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","nu nu tugum kambim fuguna. Ta ndaŋam? Tamar nu taŋgo ande ndoŋ kinye ndakina tukunu nane taŋgo afu nu tugum kine ndakuwaig ŋga tukulniŋginaig le Amnon nu wamdus piti suŋgo tumba guaze ŋak minanu sukna. ");
INSERT INTO ssd_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","Taŋamba minna le Amnon tuku gulab ande Sama tuku kiŋo nuŋe Yonadab nuŋge Amnon kaŋgeram prona. Taŋgo ta nu maŋau magenu ŋaigonu kam tuku wamdus kuyarkanu taŋgo. ");
INSERT INTO ssd_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","Nu ndek Amnon kusnana: Ne gabat suŋgo tuku kiŋo ta ne ndaŋam tuku mara mindek tumail pasi so tukulmba minit ŋgina le Amnon ndek lafumba sana: Ye aba Absalom tuku kulim nuŋe Tamar tam tuku nzali mayeyate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","Taŋakina le Yonadab ndek Amnon wam pagumba sana: Ne guazeŋget guazeŋget ŋga naŋe wande mbolŋge kinymba mina le mam naŋe pro ne kaŋgernuwa kande ne teŋenmba nu sawa: Ne ka yiŋe kulim Tamar sawa le pro teŋge ye tuku pagumba yiŋe mbili mbol teŋge suwa le nyi ŋga mam naŋe sawa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","Taŋakina le Amnon nu Yonadab tuku pasa dubimba guazeŋget guazeŋget ŋga nuŋe mbili mbolŋge kinymba minna le gabat suŋgo David nu ismba nu ka Amnon kaŋgeram kina le nu ndek sana: Ye guaze ŋak tukunu ne ka yiŋe kulim Tamar sawa le pro teŋge ye tuku bret foŋfoŋ pasoka kilmba pro yiŋe mbili mbol teŋge suwa le nyi ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","Taŋamba sana le David nu taŋgo ande kukulna le gabat suŋgo tuku wande mbol kumba Tamar sana: Ne ka Amnon tuku nyamagaŋ afu pasoke tawe ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","Taŋakina le Tamar nu tiŋga leu nuŋe tuku wande mbol kumba Amnon nuŋe mbili mbolŋge kinymba minna le kaŋgermba nu ndek plaua kilmba pipmba bret foŋfoŋ pasokina le Amnon nu kinye ŋak nu kaŋgermba minna. Bret foŋfoŋ ta pasoka ugnaig le ");
INSERT INTO ssd_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","nu nza mbol kutumba Amnon nyuwa ŋgina kande nu isukusam mbulmba ndek sakina: Taŋgo pino ŋakmba ibeŋka sili-siliwaig ŋgina le nane ibeŋka sili-silinaig. ");
INSERT INTO ssd_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","Taŋanaig le Amnon ndek kulim nuŋe sana: Ye tuku bret ta kilmba pro ye sa le nyi ŋga Tamar sana le nu bret ta kilmba nu tugum kumba ");
INSERT INTO ssd_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","leu nuŋe tambim bafuna kande nu kulim nuŋe biye timba sana: Sile karpe ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","Tamar nu mbulmba sakina: Ne ye wam ŋayonu tuku didi ndaka. Sine Israel mbal tuku maŋau taŋamba kuga. Maŋau te mayenu ndo kuga. ");
INSERT INTO ssd_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","Ne taŋawa ta ye kiko suŋgo ŋak minmba ye maŋ taŋgo pino am mbolŋge likam kumuŋ kuga. Ne mata Israel afuŋge ne tuku nyu ŋayo siliwamŋgaig. Ta tuku ne ka mam sawa le nu wokuwa le sile muŋgu kilamŋgik ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","Amnon nu Tamar tuku pasa ise ndaka nu biye timba tumba totona. ");
INSERT INTO ssd_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","Taŋamba nu nu tuku nzali suŋgokanu ŋak minna ta kugana le kile nu ndek kulim nuŋe kasur mayemba pitaimba sana: Ne tiŋga kua kaye ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","Tamar ndek nu sana: Yiŋe leu, ne taŋa ndawa. Ne ye pitaiya ta kiko suŋgokanu. Maŋau ye mbol kat ta limba o mbolŋge ŋgina kande Amnon nu kulim nuŋe tuku pasa ise ndakina sulumba ");
INSERT INTO ssd_vpl VALUES ("S213_17","011_13_17","2SA","13","17","18","nu nuŋe piro taŋgo ta wika sana: Ilmba pino te tumba te-simba wande tukula ŋgina le piro taŋgo ta nu te-simba wande tukulna. Tamar nu gabat suŋgo tuku kulim kame taŋgo kile ndakanu naŋgine maŋau dubimba nu minde piye mayenu silika likina ta ");
INSERT INTO ssd_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","kile nu kina ka kukedu kilmba gabat mbolŋge kutumba nuŋe minde piye mayenu ta fetfetmba wai baboka malmbitamtam kina le ");
INSERT INTO ssd_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","leu nuŋe Absalom ndek kulim nuŋe kaŋgermba kusnana: Ne leu naŋe Amnonŋge am sesenat e? Ne ta tuku wamdus piti ndanuwa. Nu leu naŋe tukunu taŋaig le maninka ŋgina le Tamar ndek kina ka leu nuŋe Absalom tuku wande mbolŋge ake sinamanzerka minna. ");
INSERT INTO ssd_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","Taŋana le gabat suŋgo David nu maŋau mayok kina ta ismba nu gubra kagli firkina. ");
INSERT INTO ssd_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","Absalom mata nu Amnon tuku gubra tormba nu kasurna. Ta ndaŋam? Amnon nu kulim nuŋe Tamar biye timba totona tukunu Absalom nu ŋak pasa pasa ndakina. ");
INSERT INTO ssd_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","Minnaig ma ma yar armba kinaig le Absalom tuku piro mbal ndek sipsip ŋguenu kugerkam tuku Baal-Hasor tumbraŋ kinaig. Tumbraŋ ta Efraim tumbraŋ suŋgo patumba minit. Absalom nu gabat suŋgo tuku kiŋo kat nuŋe ŋakmba aukniŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","nu gabat suŋgo David tugum kumba sana: O gabat suŋgo, nane ye tuku sipsip ŋguenu kugerkade tukunu ye pagumba nye suŋgokamŋgit. Ta tuku ne naŋe gageu naŋe kuasmbi ŋakmba ye tuku pagumba nye ta mbol prowap ŋga mam nuŋe sana le ");
INSERT INTO ssd_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","gabat suŋgo David nu tuku pasa lafumba sakina: Kiŋo, sine kine nda. Sine ŋakmba kab ta ne piro kareŋka sine tuku ŋga panzaririwamŋgat ŋgina. Taŋakina le Absalom nu gabat suŋgo kuwa ŋga sarsarmba minna le nu maŋ lato sakina: Sine kine nda. Ne ŋgamuŋgal mukuk ŋak kaye ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","Absalom ndek nu sana: Ne kambim mbulmba ndeta Amnon ndo pale le kuwa ŋga sakina le gabat suŋgo ndek nu kusnana: Ne ndaŋam tuku Amnon kuwa ŋga sakate e ŋgina ta ");
INSERT INTO ssd_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","nu Amnon kuwa ŋga dirnaŋga minna le David ndek kiŋo kat nuŋe afu turmba patikina le Amnon ndoŋ Absalom dubimba kinaig. ");
INSERT INTO ssd_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","Kile Absalom nu nuŋe piro mbal wam paguniŋmba saniŋgina: Amnon nu grep kule nyumba gare-gareka minwa le ye tane satiŋgi le tane Amnon balewap. Tane kuru kuru ndakap. Piti ta yeŋge kurawamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","nane Absalom tuku pasa ta kumu-kumumba Amnon balenaig le kumna. Taŋana le gabat suŋgo tuku kiŋo kame afu wam ta kaŋgermba doŋki poŋge lika kua ka sili-silimba kinaig. ");
INSERT INTO ssd_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","Nane ndin dubimba kumba minnaig le taŋgo afu o buk kumba David sanaig: Absalom nu kiŋo kat naŋe ŋakmba bale far suglukat ŋga David sanaig le ");
INSERT INTO ssd_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","nu pasa ta ismba nu piriri ŋayona sulumba nuŋe tawi fetfetmba kilke mbolŋge truk kina. Taŋana le nuŋe piro mbal mata taŋamba ndo naŋgine tawi fetfete likinaig le ");
INSERT INTO ssd_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","David aba nuŋe Sama tuku kiŋo nuŋe Yonadab nuŋge ndek gabat suŋgo sana: Naŋe kiŋo kame ŋakmba bale far ndakaig. Amnon ndo balewaig le kumat. Nu buk Absalom tuku kulim nuŋe Tamar tumba totona tukunu Absalom nu Amnon balewam tuku wamdus kuyarkina ta ye o buk katesewen. ");
INSERT INTO ssd_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","Kiŋo kame ŋakmba bale far suglukaig ŋgaig ta yabri pasa ndo. Ne pasa ta son ndaŋga. Amnon ndo balewaig le kumat ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","Nu taŋamba gabat suŋgo samba minna le Absalom o buk kua ka kina. Kile tumbraŋ kulatkanu taŋgo ande nu Horonaim ndin kumam mambilna kande taŋgo afu gurdu-gurdu ndeka minnaig le kaŋgerka ka gabat suŋgo kila sana le ");
INSERT INTO ssd_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","Yonadab ndek David sana: Ye buk ne wam kube sanit ta naneŋge ndekade ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","Taŋaka sana le David tuku kiŋo kat nuŋe ta pinder-pindermba pro wandek ka malmbi ŋgumbeyunaig le David nuŋe piro mbal ŋakmba nane mata malmbi ŋayonaig. ");
INSERT INTO ssd_vpl VALUES ("S213_37","011_13_37","2SA","13","37","38","Absalom nu kua ka Gesur ma tugu tuku gabat suŋgo Talmai kiŋo nuŋe Amihud ndoŋ minnaik le yar keŋmba kinaig. David nu Amnon tuku ŋgamuŋgal tatruka ninanka malmbi ŋakmba minna ma ma ");
INSERT INTO ssd_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","ka wamdus ibeŋkina le nu maŋ Absalom luka prowa ŋga idus timba minna. ");
INSERT INTO ssd_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","Gabat suŋgo David nu kiŋo nuŋe Absalom te-denna sulumba ŋgamuŋgal piti ŋak minna ta Yoab nu katesena tukunu ");
INSERT INTO ssd_vpl VALUES ("S214_2","011_14_2","2SA","14","2","2","nu taŋgo ande kukulna le nu tiŋga kina ka Tekoa tumbraŋ prona sulumba pino ande wamdus kuyar mayenu ŋak ta tumba luka Yoab tugum kinaik le nu ndek pino ta wam pagumba sana: Ne kaye sulumba pino kuembol taŋgo nuŋe o buk kummba kusrena le sagka minanu taŋaŋ ");
INSERT INTO ssd_vpl VALUES ("S214_3","011_14_3","2SA","14","3","3","gabat suŋgo tugum kumba ka pasa ne sanamŋgit te nu sawa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S214_4","011_14_4","2SA","14","4","4","Taŋamba nu Tekoanu pino ta wam paguna le nu kumba ka gabat suŋgo tuku tumailamŋge dagol tidroŋga loka sakina: O gabat suŋgo, ne ye turya ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S214_5","011_14_5","2SA","14","5","5","gabat suŋgo ta ndek nu kusnana: Ne ame piti ŋak le ye ne turni e ŋgina le pino ta lafumba sana: O gabat suŋgo, ye taŋgo o buk kumna le ye kuembolnu minet. ");
INSERT INTO ssd_vpl VALUES ("S214_6","011_14_6","2SA","14","6","6","O buk ye kiŋo armba kile-patiken ta mara ande nale piro mbolŋge kame bunaik. Kame bunaik le taŋgo ande nale kigraibkam tuku nda minna. Taŋana le kiŋo andeŋge saŋgri tiŋga kiŋo ande balena le kumna le ");
INSERT INTO ssd_vpl VALUES ("S214_7","011_14_7","2SA","14","7","7","kile yiŋe taŋgo tuku kuasmbi nane ye tuku gubra suŋgo tumba nane teŋenmba ye sayinaig. Naŋe kiŋo ta sine siŋga le kiŋo inum kumna ta tuku lafunu nu turmba balebe le kumwa ŋga sayinaig. Nane taŋawaig ta ye kiŋo kugatok mini le yiŋe taŋgo tuku ndare mata kugawamŋgat ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S214_8","011_14_8","2SA","14","8","8","Taŋakina le gabat suŋgo ndek pino ta tuku pasa lafumba sana: Ne luka naŋe wande mbol kaye le yeŋge pasa ta nane ndoŋ te-tiwamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S214_9","011_14_9","2SA","14","9","9","pino ta ndek nu sana: O gabat suŋgo, ne ye tuku piti te te-tiwam bafuwa le nane gubraniŋguwa ndeta ne tuku mbar kuga. Piti ta ye yiŋe ndare ndoŋ sine kurawamŋgig ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S214_10","011_14_10","2SA","14","10","10","gabat suŋgo ndek lafumba sana: Taŋgo ande nu ne kumammba pasa pitinu ande sanuwa kande ne nu tumba ye tugum te prowa. Taŋawa le nu ne maŋ lato piti ande tine nda ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S214_11","011_14_11","2SA","14","11","11","nu ndek sakina: O gabat suŋgo, ne naŋe Mbara Suŋgo yabaŋa le nane ye tuku kiŋo kumna ta lafunu ye tuku kiŋo ande te bale ndawaig ŋgina le David nu sakina: Suŋgo abo tugu ŋak nu tuku nyu mbolŋge ye son pasa ne sanet. Nane maŋau ande ne tuku kiŋo mbolŋge ke nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S214_12","011_14_12","2SA","14","12","12","Kile pino ta maŋ lato pasa sana: O gabat suŋgo, ye maŋ pasa ande ne sanamŋgit ŋgina le nu ndek sakina: Maye ne saka le isi ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S214_13","011_14_13","2SA","14","13","13","pino ta nu sana: Ne ndaŋam tuku Kuate tuku mbal mbolŋge maŋau ŋayonu kate? Ne naŋe kiŋo pitaina sulumba nu te-luka tam nda iduste tukunu kile naŋe miroŋ naŋe pasa teŋge ne naŋe ŋgaro pasa mbolŋge palet. ");
INSERT INTO ssd_vpl VALUES ("S214_14","011_14_14","2SA","14","14","14","Kule nu kilke mbolŋge kutukate ta taŋgo nu maŋ luka tam kumuŋ kuga. Taŋamba ndo sine ŋakmba kumbe sulumba maŋ luka aboŋge nda. Kuate nu ake sinaŋ taŋgo bale ndaniŋgit. Ande nu ŋgumnemba maskenŋge minit ta nu te-luka tam tuku nu piro kareŋkate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S214_15","011_14_15","2SA","14","15","15","Taŋamba nu maŋ lato sakina: O gabat suŋgo, nane ye mbolŋge maŋau kam sakinaig ta ye kuru-kuruka ne sota prowit. Ye idusit ye ne kusnani le ne ye tuku pasa ismba ye turyumba ");
INSERT INTO ssd_vpl VALUES ("S214_16","011_14_16","2SA","14","16","16","taŋgo ta peuniŋga le sile kiŋo ndoŋ ŋaigo siglike nda ŋga idusit. ");
INSERT INTO ssd_vpl VALUES ("S214_17","011_14_17","2SA","14","17","17","Neŋge ye turya le ye mine mayewamŋgit. O gabat taŋgo, ne Kuate tuku eŋel suk. Ne maŋau magenu ŋaigonu kumumbi pileniŋgit. Naŋe Mbara Suŋgo ne ŋak minwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S214_18","011_14_18","2SA","14","18","18","Taŋakina le gabat suŋgo pino ta tuku pasa lafumba sana: Ye kusna ande ŋak ta ne lafuwa ŋgina le nu ndek sakina: O gabat suŋgo, saka le ye isi ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S214_19","011_14_19","2SA","14","19","19","nu ndek kusnana: Ne Yoabŋge kukulnat le pasa te tumba prowat e ŋgina le pino ta lafumba sana: O gabat suŋgo, ne tuku kusna ta ye yabukam kumuŋ kuga. Ne kumumbi sakate. Naŋe kame gabat Yoabŋge ye wam paguyumba kukulyat le wamdus te tumba ne tugum prowit ta ");
INSERT INTO ssd_vpl VALUES ("S214_20","011_14_20","2SA","14","20","20","nu Absalom tuku ŋga maŋau ta kina. O gabat suŋgo, ne wamdus kuyar mayenu ŋak Kuate tuku eŋel suk. Ne kilke tugu ŋakmba mbolŋge maŋau prowe likade ta ne kila ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","Pino ta David kusremba kina le nu ndek Yoab wikina le nu sota prona le nu ndek sana: Ne isa. Ye ne tuku wamdus dubiwamŋgit. Ne kumba ka Absalom tumba te prowa ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","Yoab nu pasa ta ismba David tumailamŋge truk kina sulumba sakina: O gabat suŋgo, Kuate nu ne nyaro tinwa. Kile ye kila pilet. Ne ye tuku wamdus gare ŋak ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","Taŋaka sana sulumba Yoab nu tiŋga Gesur tumbraŋ kina ka taŋge Absalom tumba luka Yerusalem prona kande ");
INSERT INTO ssd_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","David nu Absalom kaŋgeram mbulmba sakina: Nu nuŋe wande mbolŋge minwa. Ye nu tumail kaŋgere nda ŋgina le Absalom ndek nuŋe wande mbol kumba mam nuŋe tugum kine ndakina. ");
INSERT INTO ssd_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","Absalom tuku ŋgarosu ta uge liŋnu. Israel sinamŋge taŋgo ande nu suk mine ndakina. Nane ŋakmba nu tuku saka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","Nu tuku gabat waŋe ta suŋgokanu kuen ŋayo. Yar nduik nduik sinamŋge ait ndindo ndo nuŋe gabat kuerkanu. Gabat waŋe ta pitinu 2 kilo taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","Absalom nu kiŋo keŋmba kulim ndindo kile-patikina. Kulim ta nyunu Tamar. Nu pino ŋgarosu tumail pasi mayenu ndo. ");
INSERT INTO ssd_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","Absalom nu yar armba Yerusalemŋge minna ta nu gabat suŋgo David kaŋger ndana. ");
INSERT INTO ssd_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","Taŋamba nu Yoab gabat suŋgo tugum kuwa ŋga pasa pilna kande Yoab nu ismba nda isanu sukmba minna le nu maŋ lato pasa pilna kande nu maŋ ismba nda isanu sukna. ");
INSERT INTO ssd_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","Taŋana le Absalom ndek gubrana le nuŋe piro taŋgo siseŋniŋmba saniŋgina: Tane ka Yoab tuku wit piro ta piyap ŋgina le nane kinaig ka wit piro ta piynaig. ");
INSERT INTO ssd_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","Taŋanaig le Yoab ndek Absalom tuku wande mbol kumba sawe lika sana: Ne ndaŋam saka naŋe piro mbal siseŋniŋgat le ye tuku wit piro piyaig ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","Absalom ndek Yoab tuku pasa lafumba sana: Ye ne tuku pasa palmbim aren ta ne ye tuku pasa ismba nda isanu sukmba ye tugum te pro ndana. Ye ne wam paguni le ne ka gabat suŋgo kaŋgeram tuku pasa pilen. Ne kumba ka gabat suŋgo teŋenmba sawa. Tane ndaŋam tuku ye Gesurŋge didika tumba te pronaig? Mbulap le yiŋe Gesurŋge minam tuku ŋga nu sawa ŋgina. Taŋaka sana sulumba nu maŋ lato sana: Ne ka gabat suŋgo sawa le nu ye kaŋgeryuwa. Nu ye mbaren ŋga idusmba baleyam ndeta baleyuwa le kumi ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","Taŋakina le Yoab ndek tiŋga Absalom tuku pasa ta tumba ka gabat suŋgo kubeu tuna le nu ndek pasa ta ismba taŋgo afu kukulniŋgina le ka Absalom tumba pronaig le nu gabat suŋgo tuku tumailam taŋge dagol tidroŋga lokina le nu bagailmba mumuna. ");
INSERT INTO ssd_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","Minnaig ma ma Absalom ndek karis ande tumba hos afu kilmba taŋgo 50 nane amboŋga pinderka kuwaig le nu kambim tuku ta turmba madiniŋmba kilna. ");
INSERT INTO ssd_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","Taŋamba nu mara mindek maratukuk tiŋga ka tumbraŋ fonde malaŋga sinam kambinu ndin ta kulatka minanu. Nu taŋamba minanu le taŋgo afu naŋgine tira ndoŋ gubra ŋak gabat suŋgo ndoŋ te-tiwam prowanu ta Absalomŋge ndin kuermba tane anikok ŋganu le nane Israel tugu ndaŋ mbolŋge prowanu ta nu sawanu le ");
INSERT INTO ssd_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","Absalom ndek piti ndaŋ ŋak ta ismba nane teŋenmba saniŋganu: Taŋgine piti kile-mayokkade ta kumumbi sakade ta gabat suŋgoŋge taŋgo piti ŋak ta kile-tidinu tuku gabat ande madi ndana ŋga saniŋganu. ");
INSERT INTO ssd_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","Taŋamba Absalom nu taŋgo kame ta teŋenmba saniŋganu: Nane ye pasa pilewanu gabat madiyinaig kande ye tane tuku piti ŋakmba kile-tidiŋget kande ŋga saniŋganu. ");
INSERT INTO ssd_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","Taŋamba ndo taŋgo kame ta pro Absalom tugumŋge dagol tidroŋgam bafuwanu ta nu nane peuniŋmba nuŋe ndek nane bagailniŋmba mumuniŋganu. ");
INSERT INTO ssd_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","Israel kuasmbi naŋgine piti kilmba gabat suŋgo tugum kile-tidiŋgam prowanu ta nu mara mindek wam ndui ta ndo kumba Israel mbal tuku wamdus didikanu le taŋgo ŋakmba nu tuku nzali suŋgo tinaig. ");
INSERT INTO ssd_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","Taŋamba minnaig ma ma yar bailkamba kinaig le Absalom kumba gabat suŋgo David sana: Ye kumba ka Hebronŋge Suŋgo ndoŋ pasa katen ta kumuwam iduset. ");
INSERT INTO ssd_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","Ta ndaŋam? Ye o buk Gesur tumbraŋŋge Siria ma tugu mbolŋge minmba Suŋgo ndoŋ pasa katmba teŋenmba nu sawen. Ne ye tumba Yerusalem kaye ta ye ka Hebronŋge ne tuku nyu te-duŋgamŋgit ŋga sawen ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","gabat suŋgo ndek nu sana: Ta maye. Wamdus mukuk ŋak kaye ŋgina le Absalom nu Yerusalem kusremba Hebron kina. ");
INSERT INTO ssd_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","Taŋana sulumba nu taŋgo afu kukulniŋgina le nane siŋsiŋndo kinaig ka Israel tugu ŋakmba saniŋmba sakinaig: Tane tabil fudukuwa le ismba kande ŋakmba ŋgumbeyumba teŋenmba sakap: Absalom kile Hebronŋge gabat suŋgo prowat ŋgap ŋga saniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","Absalom nu Yerusalem kusremba Hebron kina ta taŋgo kuasmbi 200 nu dubimba kinaig. Taŋgo kame ta nane Absalom tuku wamdus katese ndanaig. Nane ake nu dubimba kinaig. ");
INSERT INTO ssd_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","Nane kinaig ka Hebron promba kile Absalom ndek Suŋgo tuku atraukina sulumba taŋgo afu kukulniŋmba saniŋgina: Tane Gilo tumbraŋ kumba Ahitofel tumba ye tugum te prowap ŋgina. (Ahitofel nu gabat suŋgo David wam paguwanu taŋgo ande.) Taŋamba taŋgo suŋgomba nane David te-siwam saka Absalom tugum prowe likinaig. ");
INSERT INTO ssd_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","Kile taŋgo ande pro David sana: Israel taŋgo kile ŋakmba ne kusrenumba Absalom dubide ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","nu pasa ta ismba gabat kame nu ndoŋ Yerusalemŋge minnaig ta kile-maŋgurka saniŋgina: Braiŋ tiŋgap le sine Yerusalem kusremba kua ka kab. Kuga ta Absalomŋge nuŋe kuasmbi kilmba pro sine ŋakmba bale faramŋgat ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","nuŋe gabat sugo sugo nane ndek nu sanaig: Gabat suŋgo, ne ndaŋmba saka ta sine ake ne dubi ndo namŋgig ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","Taŋamba sakinaig le gabat suŋgo nuŋe gageu nuŋe gabat sugo sugo ŋakmba Yerusalem kusremba kua ka kinaig. David nu nuŋe pino kuasmbi 10 ta ndo kusrekina le nane gabat suŋgo tuku wande ta kulatka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","Gabat suŋgo nuŋe kuasmbi ndoŋ Yerusalem kusremba kilim kinaig ka tumbraŋ makembiŋge wande ande minna taŋge tiŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","Taŋamba David nu nuŋe gabat kame ndoŋ kuit nduimba tiŋginaig le nuŋe kulatkanu kuasmbi Keret le Pelet mbal nane amboŋga paska kinaig. Taŋanaig le Gatnu kame kuasmbi 600 nane ŋgumnem paska dubika kinaig le ");
INSERT INTO ssd_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","David ndek nane tuku gabat taŋgo Itai sana: Ne ndaŋam sine dubika kambim bafute? Ne luka ka gabat suŋgo kitek Absalom ndoŋ minap. Ne naŋe kilke kusremba rawe taŋgo taŋaŋ pro sine ndoŋ teŋge minit. ");
INSERT INTO ssd_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","Ne ait fagnu ndo sine ndoŋ minna ta ye maŋ ne tumba ake ma ŋgamuŋge kinenumam ta ye mbulit. Ne naŋe kuasmbi kilmba luka Yerusalem kape le Suŋgoŋge ne sinzaŋnuwa ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","Itai ndek nu sana: Suŋgo abo tugu ŋak nu tuku nyu mbolŋge ye ne son sanet. Ye ne ndoŋ minamŋgit. Ne ma tugu animbi kaŋgat ta ye ne ndoŋ kaŋgit. Nane ne balenuwaig sulumba ye mata baleyuwaig le kumi ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","David ndek lafumba sakina: Ta maye. Silap ŋgina le Itai tuku kame kuasmbi naŋgine gageu ŋakmba kuasmbi amboŋga kinaig ta dubika kilim kinaig. ");
INSERT INTO ssd_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","David nane Yerusalem kusremba kinaig le taŋgo pino ŋakmba malmbi ŋgumbeyunaig. Taŋamba gabat suŋgo David ndek nuŋe kuasmbi kilmba Kidron kule pakarka ma baknu kumam kinaig. ");
INSERT INTO ssd_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","Nane kinaig le pris Sadok nane Levi mbal ndoŋ Kuate tuku pasa katanu bokis tumba pro ibeŋŋge pilmba Abiatar ndek Suŋgo tuku atraukumba minna le ka ka nane ŋakmba Yerusalem kusremba kumba sulunaig. ");
INSERT INTO ssd_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","Taŋanaig le gabat suŋgo ndek Sadok sana: Kile Kuate tuku tukul bokis tumba luka ka Yerusalemŋge nuŋe minanu ma mbol pale. Suŋgo nu ye tuku nzali ŋak ndeta nu maŋ ye te-luka pilwa le pro bokis te nuŋe minanu ma mbol kaŋgeramŋgit. ");
INSERT INTO ssd_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","Nu ye mbik ri ndawa ndeta nu ame maŋau ye mbolŋge kam idusmba ndeta kuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","Taŋamba nu maŋ ndek Sadok sana: Ai te. Ne naŋe kiŋo naŋe Ahimas le Abiatar tuku kiŋo nuŋe Yonatan kilmba wamdus mukuk ŋak luka Yerusalem kape. ");
INSERT INTO ssd_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","Ye kile ma baknu kumam kumba ka pro taŋge kule pakarkam tuku ma mbolŋge ne tuku pasa tairŋga minmba ka ame wam Yerusalemŋge prowaig ta isamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","Taŋaka sawe deŋpurna le kile Sadok le Abiatar nale Kuate tuku tukul bokis ta kuramba luka Yerusalem kumba ka taŋge pilnaig le minna. ");
INSERT INTO ssd_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","Kile David nu kupe ŋgaro paska gabat soŋga malmbitamtam Olif tabe poŋga ndin dubimba kina le taŋgo pino kuasmbi nu dubimba kinaig ta nane ŋakmba maŋau ndui ta kumba gabat soŋga malmbitamtam kinaig. ");
INSERT INTO ssd_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","Taŋamba kumba minnaig le taŋgo ande pro David sana: Ahitofel o buk tiŋga Absalom tuku kuasmbi ta turkam kina ŋgina le David nu ismba nu ndek yabaŋmba teŋenmba sakina: O Suŋgo, neŋge ndo Ahitofel tuku wam pagu pasa ta bizi-buzawa ŋga Suŋgo sana. ");
INSERT INTO ssd_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","Kile nane tabe fu mbol promba Suŋgo mbariŋanu ma ta tugum pronaig le David tuku gulab taŋgo Husai pro nu te-silikina. Taŋgo ta Arknu. Nu nuŋe tawi fetfetmba kilke roka kilmba gabat mbol patika David tugum prona le ");
INSERT INTO ssd_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","David ndek nu kaŋgermba sana: Ne sine dubika ta ne sine piti siŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","Ne ye turyam kande ne luka Yerusalem kumba ka Absalom te-silika teŋenmba sawa. Yeŋge o buk mam naŋe tuku piro taŋgo minen. Taŋamba ndo ye kile ne tuku piro taŋgo minamŋgit ŋga nu sawa. Ne taŋawa le Ahitofel nu wam pagu pasa ande Absalom sawa kande neŋge nu tuku wam pagu pasa ta mbilmba wam pagu kisemba tawe. ");
INSERT INTO ssd_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","Ne ise tiwa. Pris Sadok le Abiatar nale Yerusalemŋge minik. Neŋge pasa ndaŋ gabat suŋgo tuku wande mbolŋge sakuwaig kande nale kubeu nika. ");
INSERT INTO ssd_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","Nale tuku kiŋo kat nakile Ahimas le Yonatan nale mata mam kat nakile ndoŋ taŋge minik. Ame pasa naneŋge sakuwaig kande neŋge pro nale kubeu nika le naleŋge pro ye kubeu suwaik ŋga Husai sana. ");
INSERT INTO ssd_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","Taŋakina le David tuku gulab nuŋe Husai nu pasa ta ismba nu kina ka Yerusalem prona. Prona le ait ndui ta mbolŋge ndo Absalom mata Yerusalem prona. ");
INSERT INTO ssd_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","David nu tabe funu ta kusremba kina ka Mefiboset tuku piro taŋgo Siba te-silikina. Siba nu bret 200 kilmba grep kareŋganu 100 ndaleka kilmba ail tiŋ mandernu 100 kilmba grep kule meme ŋgaronumbi tolanu ande turmba tumba agaŋ ndende ta kilmba doŋki armba fuluknyumba kilmba David sota kumba ");
INSERT INTO ssd_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","nu te-silikina le nu kusnamba sana: Agaŋ ndende fuluk ŋak ta ima tuku e ŋgina le Siba ndek lafumba sana: Doŋki armba te naŋe gageu turka linu tuku kilmba prowit. Bret ail tiŋ kareŋganu ta naŋe taŋgo kuasmbi nyam tuku kilmba prowit. Grep kule ta mata tane ma baknu te lika ka matuk kumba ndeta nyam tuku ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","Taŋakina le gabat suŋgo ndek nu sana: Naŋe gabat Saul wa nuŋe Mefiboset kile aniŋge minit ŋgina le Siba nu lafumba sana: Nane Israel mbal kite naŋgine gabat suŋgo madiwaig le nu wa nuŋe Saul tuku ma tumba nane kulatkuwa ŋga nu Yerusalemŋge minit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","gabat suŋgo David ndek pasa ta ismba Siba sana: Taŋamba ndeta Mefiboset tuku agaŋ ndende ta ŋakmba ne tanmbimŋgit ŋgina le Siba ndek nu sana: O gabat suŋgo, ye ne tuku piro taŋgo. Ye mara mindek ne tuku piroka minamŋgit ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","David nane Siba kusremba Bahurim tumbraŋ pronaig le Saul tuku ndare ande Gera kiŋo nuŋe Simei nu David te-silika kasurmba nu tugum prona. ");
INSERT INTO ssd_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","David kulatkanu kame taŋgo suŋgomba nu kormba tiŋginaig ta Simei nu nane tuku kuru kuru ndaka nane mbol ndame pankina. ");
INSERT INTO ssd_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","Taŋamba Simei ndek David kasurmba sana: Ne kua kaye. Ne taŋgo baleniŋgina tuku ndare ŋak. Ne siŋka taŋgo ŋayonu ndo. ");
INSERT INTO ssd_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","Ne buk gabat suŋgo Saul pitaimba nu tuku ma tumba gabat suŋgo prona. Ne Saul tuku kuasmbi suŋgomba bale farmba nane tuku ndare kutuna. Ta tuku kile Suŋgoŋge wam ta ne mbolŋge lafumba ne pitainat le kiŋo naŋe Absalom ne tuku ma tumba Israel mbal tuku gabat suŋgo prowat. Ne taŋgo baleniŋgina tuku ndare ŋak ŋga David sana. ");
INSERT INTO ssd_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","Taŋamba saka minna le Abisai ndek gabat suŋgo David sana: O gabat suŋgo, ne ndaŋam tuku age kumaknu te mapete le ne kasurnate. Saka le ye ka kame bagimbi ŋinfok kat puri ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","gabat suŋgo ndek Abisai le Yoab peunikmba sanikina: Tale mbulap. Tale ye ndoŋ wamdus tuma kuga. Wam te Suŋgoŋge sawat le ye kasuryate ndeta imaŋge nu peuwam kumuŋ ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","Taŋakina sulumba David ndek Abisai gabat afu turmba saniŋgina: Tane isap. Yiŋe kiŋoŋge ye baleyam bafute ta ndaŋam tuku sine Benyaminnu taŋgo te ŋayo silibe. Mbulap. Suŋgoŋge sate le ye kasuryate ndeta maye. ");
INSERT INTO ssd_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","Suŋgo nu ye tuku piti te kaŋgermba kasur pasa ta mbilmba nyaro mayenu ye suwa ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","Taŋaka saniŋgina le nane ndin ta dubimba kinaig le Simei maŋ nane dubika kina ka David kasurmba ndame kilmba kilke kilmba nane mbol pankina. ");
INSERT INTO ssd_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","Taŋana le gabat suŋgo David nuŋe kuasmbi ŋakmba ake kine ndo kinaig ka ka matuk tukulkinaig sulumba Yordan kule makembi taŋge mabtinaig. ");
INSERT INTO ssd_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","Kile Absalom Israel kuasmbi ŋakmba kilmba Ahitofel ndoŋ Yerusalem pronaig le ");
INSERT INTO ssd_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","David gulab nuŋe Husai ndek kumba ka Absalom te-silikumba wi kueŋka sakina: Ese. Ne sine tuku gabat suŋgo ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","Taŋakina le Absalom nu pasa ta ismba nu ndek Husai sana: E-e ne mam tuku gulab nuŋe. Ndaŋam tuku ne nu ndoŋ kine ndakina ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","Husai ndek nu sana: Kuga. Ne Suŋgoŋge madinina. Israel kuasmbi ŋakmba nane mata ne madininaig tukunu ye ne tuku piro taŋgo ndo ne kumnemŋge minamŋgit. ");
INSERT INTO ssd_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","Ye ne kumnemŋge minmba ne tuku piro ndaki ta ye ka ima tuku piro taŋgo mini. Ye buk mam naŋe tuku piro taŋgo minen. Taŋamba ndo ye kile ne tuku piro taŋgo minamŋgit ŋga Absalom sana. ");
INSERT INTO ssd_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","Kile Absalom ndek Ahitofel kusnana: Ne ndaŋmba iduste. Kile sine ndaŋamŋgig ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","Ahitofel lafumba nu sana: Ne kumba ka mam naŋe tuku pino kuasmbi wande kulatkuwaig ŋga kusrekina si kilmba ka nane ndoŋ kinya. Ne taŋawa ta Israel taŋgo pino ŋakmba teŋenmba ne tuku sakamŋgaig. Nu sonndo mam nuŋe ndoŋ ŋgueu minit ŋga saka nane ŋakmba ne ndo dubinam tuku saŋgri tiŋgamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","Taŋakina le nu taŋgo afu kukulniŋgina le ka gabat suŋgo tuku wande fu mbolŋge baibai ande te-tinaig le Absalom ndek taŋgo pino ŋakmba tuku am mbolŋge baibai ta sinam kina le nane ka mam nuŋe tuku pino kuasmbi ta kilmba pronaig le Absalom ndek nane kilmba tido-tidoŋgina. ");
INSERT INTO ssd_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","Ahitofel nu wam pagu pasa ndaŋ gabat suŋgo sawanu ta nane Suŋgo tuku pasa isanu sukmba dubiwanu. O buk David nu Ahitofel tuku wam pagu pasa ismba dubina taŋamba ndo Absalom mata nu tuku miŋge dubiwanu. ");
INSERT INTO ssd_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","Kile Ahitofelŋge ndek Absalom sana: Ye taŋgo 12,000 madiniŋgi le furirwa le sine David biye tiwam kab. ");
INSERT INTO ssd_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","Nu matuk ka ŋgamuŋgal piti ŋak minwa le sine ka nu ndoŋ kame bube le nu tuku taŋgo kuasmbi nane pirirek purka sili-siliwaig le ye gabat suŋgo ndo balewamŋgit. ");
INSERT INTO ssd_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","Taŋamba ye taŋgo kuasmbi nu dubide ta ŋakmba kilmba ne tugum te prowamŋgit. Sine David balebe le taŋgo kuasmbi nu dubide ta ŋakmba mapeka kilmba ne tugum te probe le ne tuku ndo minwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","Taŋakina le Absalom Israel gabat sugo sugo ŋakmba nane pasa ta ismba maye ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","Absalom ndek sakina: Sine Husai wikube le nu promba nuŋe wamdus ta kukliwa le ismba ŋgina le nane nu tumba pronaig. ");
INSERT INTO ssd_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","Nu tumba pronaig le Absalom ndek Ahitofel tuku wam pagu ta kubeu tumba nu kusnana: Sine pasa ta dubibe e ko kuga? Kuga ndeta sine ame maŋau kam tuku ŋga sasiŋga ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","Taŋakina le Husai ndek lafumba sakina: Ahitofel tuku wam pagu pasa ta mayenu ndo kuga. ");
INSERT INTO ssd_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","Mam naŋe nuŋe kame kuasmbi ndoŋ nane saŋgri ŋaigo. Bea fat kilig le gubra tumba minit taŋaŋ. Mam naŋe nuŋe kuasmbi kame ta nane kirair ŋak. Nu furir taŋgo kame ŋak nda minit. ");
INSERT INTO ssd_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","Nu ka ndame burok ande sinamŋge e ko ma inumŋge kuirka minit. Sine tuku kame kuasmbi kuwaig le bale farkuwaig ta taŋgo pino nane pasa ta ismba sanuŋgaig: O Absalom tuku kuasmbi bale faraig ŋga sakamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","Taŋakuwaig le ne tuku kame kuasmbi ŋakmba ismba kuru-kurukamŋgaig. Ta tuku mbulap. Mam naŋe nuŋe kame kuasmbi nane saŋgri ŋaigo ta Israel taŋgo ŋakmba nane kila. ");
INSERT INTO ssd_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","Ta tuku ye tuku wamdus teŋenmba. Ne Israel taŋgo ŋakmba kile-maŋgurka kame kuasmbi burnu kumuŋ kuga prowaig le ne naŋe miroŋ nane kilmba ka mam naŋe ndoŋ kame buwap. ");
INSERT INTO ssd_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","Sine kumba ka ma tugu aniŋge mam naŋe nuŋe kuasmbi ndoŋ kile-siglika ta sine nane ndoŋ kame buwamŋgig. Nane sine peusiŋgam kumuŋ kuga. Sine David balemba nuŋe kuasmbi ŋakmba turmba bale faramŋgig. ");
INSERT INTO ssd_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","Nu kua ka tumbraŋ suŋgo ande sinam kuwa ta siŋgine kuasmbi muli kareŋnu kilmba tumbraŋ fonde ta kusmba didika te-bukŋgube le ma gutoŋ sinam nziŋge ndeka fofokuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","Husai nu pasa deŋpurna le Absalom Israel mbal ŋakmba ndek sakinaig: Husai tuku wam pagu pasa ta mayenu ndo. Ahitofel tuku wam pagu pasa ta mayenu ndo kuga ŋginaig. Ta ndaŋam? Suŋgoŋge nane Ahitofel tuku wam pagu pasa mayenu ta pitaiwaig le nu Absalom ŋayo siliwam tuku wamdus kuyarkina. ");
INSERT INTO ssd_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","Kile Husai ndek kumba ka nu wam pagu pasa Absalom Israel mage mage nane saniŋgina ta pris Sadok le Abiatar ndoŋ kubeu nikina sulumba Ahitofel tuku wam pagu pasa ta turmba nale sanikina sulumba ");
INSERT INTO ssd_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","sakina: Tale pitik pasa palpe le David tugum kuwa le nu kite Yordan kule pakarkammbi taŋge kinye ndakuwa. Nu braiŋ kule pakarka sim kuwa ta nane nu nuŋe kuasmbi ndoŋ bale farke nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","Taŋakina le nale piro pino ande kukulnaik le nu ka Yonatan le Ahimas kubeu nikina. Nale ar ta o buk kua ka Yerusalem kusremba ka Enrogel kule bulbulmba prote tuku magot taŋge kuirka minnaik. Yerusalemŋge ame maŋau prowanu ta piro pino taŋge ka nale sanikanu le naleŋge ka David sawanu. ");
INSERT INTO ssd_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","Kile kiŋo ande nale kaŋgerkina sulumba ka Absalom sana le nale ar ta braiŋ ndo kumba ka Bahurimnu taŋgo ande tuku wande sinam kumba kule burok sinam kumba kuirkinaik. ");
INSERT INTO ssd_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","Kuirkinaik le nale ar sinam taŋge minnaik ta andeŋge katese ndawa ŋga taŋgo ta tuku piyo nuŋe tawi ande tumba burok miŋgenu kaimba wit afu kilmba tawi farna ta mbolŋge bareŋna. ");
INSERT INTO ssd_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","Kile Absalom tuku taŋgo kame nale ar ta sota sota pro pino ta kusnanaig: Ahimas le Yonatan aniŋge minik ŋginaig le pino ta ndek nane saniŋgina: Nale o buk kule pakarka sim kakik ŋgina le taŋgo kame ta ka nale sotete piseŋga nane luka Yerusalem kinaig. ");
INSERT INTO ssd_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","Nane kinaig le Ahimas nale Yonatan burok ta kusremba kilim kumba tiŋga David tugum kumba nu sanaig: Ahitofel nu ne ŋayo silinam tuku sakate tukunu ne kile ndo ma te kusremba kule pakarka sim kaye ŋga sanaig le ");
INSERT INTO ssd_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","David nu pasa ta ismba nuŋe kuasmbi ta ŋakmba kule pakarka sim kinaig le ka mafena. ");
INSERT INTO ssd_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","Absalom nu Ahitofel tuku wam pagu pasa ta dubi ndana le nu ka nuŋe doŋki poŋga luka nuŋe tumbraŋ kina ka taŋge nuŋe gageu ndoŋ piro kile-tidiŋga ka muli ŋinfok panmba kumna le nuŋe gageu kame ta nu tuku mindesiŋ tumba ka mam nuŋe ŋgukinaigmbi taŋge ŋgukinaig. ");
INSERT INTO ssd_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","Kile Absalom Israel kame kuasmbi kilmba David dubimba kinaig ka Yordan kule pakarkinaig ta David nu o buk nuŋe kuasmbi ta kilmba ka Mahanaim tumbraŋ sinam kinaig. ");
INSERT INTO ssd_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","(Absalom nu Amasa tumba Yoab tuku ma tumba nuŋe kame kuasmbi tuku gabat minwa ŋga madina. Amasa mam nuŋe Yeter. Ina nuŋe Abigail. Abigail mam nuŋe Nahas. Abigail aba nuŋe ta Yoab ina nuŋe Seruya). ");
INSERT INTO ssd_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","Kile Absalom nuŋe kame kuasmbi ndoŋ kinaig ka Gilead ma tugu promba taŋge tumbraŋ ulnaig. ");
INSERT INTO ssd_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","David nu kumba ka Mahanaim tumbraŋ prona le taŋgo keŋmba ka nu tugum pronaig. Nane tuku ande Nahas kiŋo nuŋe Sobi nu Rabanu Amon ma tugu mbolok. Ande Amiel kiŋo nuŋe Mahir nu Lodebarnu. Ande nyunu Barsilai nu Rogelimnu Gilead ma tugu mbolok. ");
INSERT INTO ssd_vpl VALUES ("S217_28","011_17_28","2SA","17","28","29","Nane keŋ ta nza, kilke waim, kinya mbili, nyamagaŋ turmba kilmba David nuŋe kuasmbi niŋgam tuku pronaig. Nyamagaŋ kilmba pronaig ta wit yeki yeki abonu pasokanu, kuslin yeki yeki, ŋguimzaŋ kulenu, makau tuku amo ŋair, sis, sipsip afu turmba kilmba pronaig. David nuŋe taŋgo kuasmbi ndoŋ ma baknu mbol lika ma ma kule paranu gubanu isu baklelnaig ta nane katesemba nyamagaŋ ta kilmba pronaig. ");
INSERT INTO ssd_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","Kile gabat suŋgo David ndek nuŋe kame kuasmbi kilmba walmba afu 100 afu 1,000 taŋamba fetke lika kame gabat afu nane kulatkam tuku madiniŋgina. ");
INSERT INTO ssd_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","Taŋamba nu taŋgo kuasmbi kame ta fet keŋna sulumba kame gabat keŋmba nane kulatkam tuku patikina. Kame gabat keŋmba ta ande Yoab ande Abisai ande Itai. Abisai nu Yoab tuku mambo nuŋe. Itai nu Gatnu. Kile David ndek nane saniŋgina: Ye mata tane ndoŋ kame kaŋgig ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","nane nu sanaig: Ne sine ndoŋ kine nda. Kame mbolŋge nane sine kile-ibeŋkuwaig le kua kab ta nane sine idussiŋge nda. Sine tuku taŋgo bale farwaig ta mata nane burke nda. Ne sine dubika kaye le ne balenuwaig ta sine tuku taŋgo 10,000 baleniŋganu taŋaŋ. Ta tuku ne tumbraŋ teŋge mina. Sine kame taŋgo afu denkumba pasa pilbe kande ne taŋgo afu patika le prowaig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","David ndek lafumba saniŋgina: Ta maye. Ye tane tuku miŋge dubiwamŋgit ŋgina. Taŋamba David ndek tumbraŋ koranu fonde malaŋgambi taŋge tiŋ minna le kame kuasmbi afu taŋgo 1,000 ŋak afu taŋgo 100 ŋak ta ŋakmba pro kilim kinaig. ");
INSERT INTO ssd_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","Taŋanaig le David ndek Yoab Abisai Itai wam paguniŋmba saniŋgina: Tane ye idusyumba ye tuku kiŋo Absalom mapewap ŋgina le kame kuasmbi ŋakmba nane David tuku wam pagu pasa ta isnaig. ");
INSERT INTO ssd_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","Kile David tuku kame kuasmbi kinaig ka Israel mbal tuku kame kuasmbi Efraim duŋe sinam taŋge kile-siglika nane ndoŋ kame bunaig. ");
INSERT INTO ssd_vpl VALUES ("S218_7","011_18_7","2SA","18","7","8","Kame bumba kinaig ka ka David tuku kuasmbiŋge nane Israel kame kuasmbi kile-ibeŋka kilmba yokerka ka bale farniŋginaig le nane kua ka duŋe sinam kumba ka taŋge nane suŋgomba kume farnaig. Kame suŋgo ta sinamŋge taŋgo kume farnaig ta ulendika 20,000 taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","Absalom nu doŋki poŋga kua kina sulumba David tuku kame taŋgo afu kile-siglikina. Kile doŋki ta ail suŋgo ande kumnem kumnem pinderka kina ka taŋge gabatnu ail kazaŋka ndiŋkina le doŋki nu ake pinderka kina le Absalom nu ail wai mbol taŋge kuikok minna. ");
INSERT INTO ssd_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","Taŋamba minna le David tuku kame taŋgo ande Absalom ail mbol taŋge kuikok minna le kaŋgermba kumba ka Yoab sana: Absalom ail suŋgo wainu mbol nziŋge kuikok minit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","Yoab ndek taŋgo ta sana: Ne nu kaŋgerat ta ndaŋam saka ne nu bale ndawat? Ne nu balewat kande ye ne silwa ndametiŋ soŋ ndindo tinmba let ande turmba tinit kande ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","Taŋakina le taŋgo ta ndek Yoab sana: Ne silwa ndametiŋ soŋ 100 sa mata ye nu mbol wam inum ke nda. Nu gabat suŋgo tuku kiŋo. Gabat suŋgo nu ne Abisai Itai tane keŋ wam pagukat ta sine ŋakmba isig. Nu teŋenmba satiŋgat. Tane ye idusyumba ye tuku kiŋo Absalom mapewap ŋgat. ");
INSERT INTO ssd_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","Ye gabat suŋgo tuku miŋge ŋgurmba Absalom balewi le kumwa ta nu ismba ye tumba pasa mbol pilwa le ne ye pasambi turye nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","Taŋakina le Yoab ndek taŋgo ta sana: Ye ne tuku pasa isam mbulit ŋgina sulumba nu ndek nuŋe mbanduwaŋ keŋmba kilmba Absalom ail mbol kuikok minnambi ta kina. Absalom nu kume ndaka minna le Yoabŋge mbanduwaŋ kame ta tawo mbolŋge nduasekina le ");
INSERT INTO ssd_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","nu tuku kame taŋgo 10 pro Absalom taplenaig le kumna. ");
INSERT INTO ssd_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","Absalom kumna le Yoab ndek kame taŋgo ande sana: Tabil fitka le nane kame Israel mbal yokerkade ta kusrekuwaig ŋgina le nu tabil fitkina le kame mbal tabil fudu ta ismba Israel mbal kusreka luka pronaig. ");
INSERT INTO ssd_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","Taŋanaig le Israel mbal kua ka sili-silimba naŋgine tumbraŋ tumbraŋ kine likinaig. Kile Yoab nane Absalom tuku mindesiŋ tumba duŋe ŋgamu taŋge burok suŋgo ande sinamŋge bukŋga ndamembi diŋmba minnaig le ka mbuter tiŋgina. ");
INSERT INTO ssd_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","Absalom kume ndaka minna sulumba nu nuŋe nyu ŋgisi ndakuwa ŋga ndame kuennu ande tumba Gabat Suŋgo tuku Ma Gutoŋ taŋge te-tina. Ta ndaŋam? Absalom nu kiŋo kugatok minna tukunu nu tuku nyu ŋgisi ndakuwa ŋga maŋau ta kina. Kile Israel mbal nane ndame ta Absalom tuku Ndame ŋgade. ");
INSERT INTO ssd_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","Absalom kumna le Sadok kiŋo nuŋe Ahimas ndek Yoab sana: Ye kumba Suŋgoŋge sine ŋgueu mbal tuku wai mbolŋge kile-luka kilat wam ta gabat suŋgo David sawam iduset ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","Yoab ndek nu sana: Kuga. Kiŋo nuŋe balewig le kumat tukunu ne kite pasa tumba ka gabat suŋgo sa ndawa. Ait mara ande ta maye ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","nu ndek Etiopianu piro taŋgo nuŋe wika kukulmba sana: Ne kaye ka kame mbolŋge wam prowe likaig ta ka gabat suŋgo kubeu tawe ŋgina le piro taŋgo ta ndek Yoab tugum taŋge loka pinderka kina. ");
INSERT INTO ssd_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","Nu kina le Ahimas ndek dirnaŋga Yoab sana: Ye mata gabat suŋgo sota kaŋgit. Ame wam ye mbolŋge prowa ndeta taŋaig ŋgina le nu ndek taŋgo ta sana: Ndaŋam tuku ne kambim tuku dirnaŋ ndekate? Ame agaŋ mayenu ne tamŋgat ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","Ahimas maŋ lato sakina: Ye kaŋgit ŋgina le Yoab ndek nu sana: Maye le kaye ŋgina. Taŋakina le Ahimas nu ndin dubimba kumba ka Yordan kule ma gutoŋ kumam kuerka pinderka kina ka Etiopianu piro taŋgo ta limba nu amboŋga prona. ");
INSERT INTO ssd_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","David nu tumbraŋ koranu fonde malaŋga suŋgo tugum taŋge minyok minna le tumbraŋ kulatkanu taŋgo nu fonde poŋga mbolŋge tiŋga mambilmba minna kande taŋgo ande pinderka mbuna le kaŋgermba ");
INSERT INTO ssd_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","nu wi kueŋka gabat suŋgo sana: Taŋgo ande pinderka mbate o ŋgina le gabat suŋgo ndek sana: Taŋgo ndindo ndeta nu pasa mayenu tumba prote ŋgina. Kile taŋgo ta nu buk pro tumbraŋ suŋgo ta patuna le ");
INSERT INTO ssd_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","tumbraŋ kulatkanu taŋgo ta mambilmba minna kande taŋgo ande nu ŋgumnem pinderka minna le kaŋgermba nu wi kueŋka malaŋga kulatkanu taŋgo sana: Ai si. Taŋgo ande ŋgumnem pinderka mbate o ŋgina le gabat suŋgo nu pasa ta ismba sakina: Nu mata pasa mayenu tumba prote ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","Kile tumbraŋ kulatkanu taŋgo maŋ wi kueŋka sakina: Taŋgo amboŋga pinderka mbate nzi Sadok kiŋo nuŋe Ahimas suk ŋgina le gabat suŋgo ndek sakina: Nu taŋgo mayenu ndo. Nu pasa mayenu tumba prote ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","Ahimas pinderka pro tumbraŋ patumba gabat suŋgo kaŋgermba nu tuku tumailam taŋge truk ka sana: O gabat suŋgo, sine siŋgine Mbara Suŋgo tuku nyu te-duŋgube. Nane taŋgo kuasmbi ne te-sinam tuku bafunaig ta Suŋgoŋge kilmba sine tuku wai mbolŋge patikat le sineŋge kile-ibeŋkig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","Taŋakina le gabat suŋgo ndek Ahimas kusnana: Ye tuku kiŋo Absalom maye minit e ŋgina le Ahimas nu lafumba sana: O gabat suŋgo, taŋgo suŋgomba ŋgumbeyumba minaig le ye Yoabŋge kukulyat le pinderka prowet. Ame wam kaig ta ye kaŋger ndakit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","gabat suŋgo ndek nu sana: Ne ka o siŋge tiŋga ŋgina le Ahimas dirka ka kasom siŋge tiŋgina. ");
INSERT INTO ssd_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","Taŋana le Etiopianu taŋgo ta pinderka pro gabat suŋgo sana: Yiŋe gabat suŋgo, ye pasa mayenu ne sanam prowet. Kuasmbi ne te-sinam bafuwaig ta Suŋgoŋge kilmba ne tuku wai mbolŋge patikat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","Taŋaka sana le gabat suŋgo ndek nu kusnana: Ye tuku kiŋo Absalom maye minit e ŋgina le piro taŋgo ta ndek lafumba sana: O gabat suŋgo, wam kiŋo naŋe mbol prowat ta naŋe ŋgueu mbal ne te-sinam sakade nane ŋakmba mbol taŋamba ndo prowa ŋga iduset ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","gabat suŋgo nu pasa ta ismba ŋgamuŋgal tatrukina le nu tiŋga fonde poŋga wande ta sinam kumba ka taŋge malmbika minna sulumba malmbi kueŋka sakina: O yiŋe kiŋo Absalom. Kiŋo nyek o. Kiŋo nyek o. O Absalom, yeŋge kumi ta maye. O yiŋe kiŋo. Kiŋo nyek o ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","Gabat suŋgo David nu Absalom tuku ninanka malmbika minna ta nane afu ka Yoab sanaig le ");
INSERT INTO ssd_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","kame kuasmbi ŋakmba gabat suŋgo David kiŋo nuŋe Absalom tuku malmbika minna pasa ta ismba nane wamdus piti suŋgo tumba kame mbolŋge ŋgueu mbal kile-ibeŋkinaig gare gare ta kugatok ");
INSERT INTO ssd_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","siŋsiŋndo kame mbolŋge kua ka kiko ŋak prowanu sukmba tumbraŋ sinam kinaig. ");
INSERT INTO ssd_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","Ait ta mbolŋge gabat suŋgo nu tawi tumba tumail soŋga ninanka malmbi kueŋka sakina: O yiŋe kiŋo Absalom. Kiŋo nyek o. Kiŋo nyek o ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","Taŋamba minna le Yoab ndek gabat suŋgo tuku wande mbol kumba David sawe lika sana: Ne wam kate ta naŋe kuasmbi ŋakmba kiko pileniŋgit. Kite ait te mbolŋge taŋgo kame teŋge ne turnumba ne tuku piyo kat naŋe kutu kat naŋe kile-luka kilaig ta ");
INSERT INTO ssd_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","ne taŋgo kame ne tuku kume purde ta pitaikate sulumba taŋgo ne kasurnade ta sinzaŋniŋgit. Ne tuku maŋau ta ne naŋe taŋgo kuasmbi naŋe gabat kame ta ake agaŋ taŋaŋ talaniŋgit. Ye kila. Absalom kume ndaka sine ŋakmba kumig kande ne kile garenate kande. ");
INSERT INTO ssd_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","Ne isa. Ne kile ndo tiŋga kaye ka naŋe kame kuasmbi ndoŋ pasa-pasaka wam yoyoniŋga. Ye Suŋgo tuku nyu mbolŋge ne sanet. Ne taŋa ndawa ta furir te mbolŋge nane ŋakmba sili-siliwaig le ne piti suŋgo tamŋgat. Piti ande taŋamba ne buk kaŋger ndana ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S219_8","011_19_8","2SA","19","8","8","Yoab nu pasate deŋpurna le David ndek tiŋga kumba ka tumbraŋ fonde malaŋgambi taŋge minyokina le nuŋe kame kuasmbi ŋakmba ismba nane pro nu laipmba maŋgurkinaig. Israel kuasmbi yimyam kua ka sili-silimba naŋgine tumbraŋ tumbraŋ kine likinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","naŋgine naŋgine pasambi muŋgu tuwe-tuwekinaig sulumba sakinaig: Gabat suŋgo David minna sulumba sine kigraibkina le Filistia mbalŋge sine kilmba ŋaigo sigli ndakinaig. Kile nu Absalom ram kua ka tumbraŋ tuguk kusrena. ");
INSERT INTO ssd_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","Sine Absalom siŋgine gabat suŋgo minwa ŋga madigeŋ ta kame mbolŋge nu balenaig le kumna. Ta tuku ndaŋam tuku sine teŋenmba ake ndo minbe. Sine ka gabat suŋgo David tumba probe ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S219_11","011_19_11","2SA","19","11","11","Taŋamba saka minnaig le gabat suŋgo David nu ismba ndek pris Sadok le Abiatar tuku pasa pilmba sakina: Tale ye tuku pasa te tumba Yuda gabat kame teŋenmba saniŋgap. ");
INSERT INTO ssd_vpl VALUES ("S219_12","011_19_12","2SA","19","12","12","Tane ye tuku ndare tuma ta ndaŋam tuku nane Israel mbalŋge tane Yuda mbal lukaka ye luka yiŋe wande mbol prowam tuku sayade. Tale ka taŋamba nane saniŋgap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","Taŋakina sulumba David maŋ lato wam paguka sanikina: Tale ka Amasa teŋenmba sawap. Sile ndare tuma ndindo. Yeŋge ne tumba Yoab tuku ma mbol pili le neŋge ye tuku kame kuasmbi tuku gabat minamŋgat. Ye taŋa ndawi kande Kuateŋge ye mapeye nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","Taŋamba David nu Yuda mbal tuku wamdus didikina le nane nu tuku pasa pilmba sakinaig: Ne naŋe kuasmbi ta ŋakmba kilmba Yerusalem prowap ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","Taŋamba pasa pilmba Yuda kuasmbi suŋgomba nane kinaig ka Gilgal tumbraŋŋge kule make mbiŋge gabat suŋgo prowa le te-temam tuku tair minnaig. Taŋanaig le David nu nuŋe kuasmbi ta kilmba ka Yordan kule mbol pronaig le ");
INSERT INTO ssd_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","Gera kiŋo nuŋe Simei nu pre pre Yuda mbal ndoŋ David te-silikam Yordan kule mbol prona. (Simei nu Benyamin tuku tugu. Nu tuku tumbraŋ tuguk Bahurim). ");
INSERT INTO ssd_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","Simei nu Benyamin tuku kuasmbi 1,000 kilmba pronaig le Saul tuku piro taŋgo Siba mata nuŋe kiŋo kat nuŋe 15 piro taŋgo 20 ta kilmba ka Yordan kule mbolŋge gabat suŋgo David tair minnaig. ");
INSERT INTO ssd_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","Minnaig le gabat suŋgo tuku kuasmbi pro kule make simŋge tiŋginaig le Simei tuku taŋgo kuasmbi ta ndek kule pakarka gabat suŋgo tuku gageu kile-temkam kinaig sulumba nane ndek gabat suŋgo tuku piro taŋgo ndo minam tuku sanaig. Gabat suŋgo nu kule pakarkam bafuna le Simei pro nu tumailamŋge truk kina sulumba ");
INSERT INTO ssd_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","nu sana: O gabat suŋgo, o buk ne Yerusalem kusremba kina le ye ne mbolŋge mbaren ta kile ne ye sinayumba ye tuku mbar ta ŋakmba gilaiŋga. ");
INSERT INTO ssd_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","O gabat suŋgo, ye uneken ta idusmba ye Israel mbal ŋakmba ŋgamukŋge ye amboŋga ne te-silikam prowit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","Taŋakina le Abisai ndek sakina: Sine Simei balebe le kumwa. Nu o buk gabat suŋgo Suŋgoŋge madina ta kasurna ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","David ndek Abisai le aba nuŋe Yoab sanikina: Tale ndaŋam tuku ye piti sam bafuwik. Tale ye ndoŋ wamdus tuma kuga. Ye kile Israel mbal ŋakmba tuku gabat suŋgo minamŋgit. Ki ait te mbolŋge sine Israel inum balewe nda ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","nu ndek Simei sana: Ki am mbolŋge ye ne sanet. Andeŋge ne balene nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","David nu o buk Yerusalem kusremba kua kina ait ta mbolŋge Saul wa nuŋe Mefiboset nu sagka minna ka ka David luka prona. Taŋana le Mefiboset nu mata pro gabat suŋgo David te-silikina. ");
INSERT INTO ssd_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","Mefiboset nu Yerusalem kusremba ka gabat suŋgo tugum prona le nu ndek nu kusnana: Mefiboset, ne ndaŋam tuku ye dubiyumba kine ndakina ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","nu ndek lafumba sana: O gabat suŋgo, ye kupe pagliskinaik ta ne kila. Ne Yerusalem kusrena le ye yiŋe piro taŋgo sawen. Ye tuku doŋki ande tumba kuaneka le ye ta mbol minyoka gabat suŋgo dubimba kaŋgit ŋgen kande nu ye yabriyumba kua ka ");
INSERT INTO ssd_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","ne tugum kumba ne yabrinina sulumba ye tuku nyu ŋayo silina. O gabat suŋgo, ne Suŋgo tuku eŋel taŋaŋ. Ne wam ndaŋ ye mbol kam ndeta ka. ");
INSERT INTO ssd_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","Ne yiŋe kuasmbi mam tuku ndare kame ta ŋakmba bale farkam kumuŋ ta ne ye mapeyina le ye ne tuku wande mbolŋge isukusmba minen. Ta tuku ye maŋ agaŋ inum sa ŋgam mbulit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","Taŋakina le gabat suŋgo ndek nu sana: Ta maye. Ne pasa sakat le isit. Tale Siba ndoŋ Saul tuku kilke ta walmba kilap ŋga sana kande ");
INSERT INTO ssd_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","Mefiboset ndek gabat suŋgo sana: Taŋaig. Sibaŋge ŋakmba kilwa. Ne maŋ luka prowat le ye ta tuku gare-gareket ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","Barsilai nu Rogelimnu Gilead ma tugu mbolok. Nu mata pro gabat suŋgo ndoŋ Yordan kule pakarkam saka ndekina. ");
INSERT INTO ssd_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","Barsilai nu saibo pile mayemba yar 80 ŋak minna. Nu maror taŋgo ande. O buk gabat suŋgo Mahanaim tumbraŋŋge minna le nu nyamagaŋmbi turna. ");
INSERT INTO ssd_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","Kile gabat suŋgo ndek nu te-silika sana: Ne ye ndoŋ Yerusalem kumba ye suk ne kulatki ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","Barsilai nu tuku pasa ta lafumba sana: O gabat suŋgo, mine minemba ye kumamŋgit. Ta tuku ye ne dubinumba Yerusalem kine nda. ");
INSERT INTO ssd_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","Ye kile yar 80 ŋak. Ye ame wam gare-garekam tuku ta kamus ndawet. Ye isukusmba kule nyet ta mata kualenu kamus ndawet. Ye kilba mata tukulok. Taŋgo pino kupesmba mune ulwaig ta ye isam kumuŋ kuga. Ta tuku ye ne dubinumba ka ne minde bada tine nda. ");
INSERT INTO ssd_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","Ne ndaŋam tuku ye mbolŋge maŋau mayenu kam bafute? Ye ne ndoŋ kule pakarka kumba ne kusrenumba ");
INSERT INTO ssd_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","luka ka yiŋe tumbraŋŋge ina mam kumnaig le ŋgukigeŋmbi taŋge ye kumi le ŋgukuwaig ŋgina sulumba sakina: Ye tuku kiŋo Kimam minit te. Nu ne dubinumba kuwa le ne ame agaŋmbi nu turam kande ke ndo ka ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","Taŋakina le gabat suŋgo ndek pasa lafumba sana: Ta maye. Kimam ye tumba kaŋgit. Ne ame wam nu mbol ki ŋga saka ta ye kamŋgit. Ame agaŋ nu tambim tuku saka ta ye tambimŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","Taŋakina sulumba gabat suŋgo nuŋe kuasmbi ŋakmba kilmba nane Yordan kule pakarka sim kumba gabat suŋgo ndek Barsilai mumumba nyaro tuna le nu luka nuŋe tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","Gabat suŋgo nu kule pakarka sim kina le Yuda taŋgo pino ŋakmba Israel taŋgo pino afu turmba nu ndoŋ kinaig. Kimam mata gabat suŋgo ndoŋ kina. Taŋamba nane kinaig ka Gilgal tumbraŋ pronaig. ");
INSERT INTO ssd_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","Kile Israel mbal ŋakmba pro gabat suŋgo David sanaig: O gabat suŋgo, ndaŋam tuku siŋgine tira kame Yuda mbal nane sine Israel mbal yabusiŋmba ne naŋe gageu naŋe kuasmbi ta ŋakmba kile-temkam tuku Yordan kule mbol kinaig ŋginaig kande ");
INSERT INTO ssd_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","Yuda taŋgo ŋakmba pasa lafumba sakinaig: Gabat suŋgo nu siŋgine tugu ndindo ndo. Ta tuku sine maŋau ta kig. Ndaŋam tuku tane sine tuku gubratiŋgig? Gabat suŋgo nu sine agaŋ inum siŋge ndakat ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","Israel mbal nane pasa lafumba sakinaig: Sine Israel mbal tugu 10 ŋak. Tane Yuda mbal tugu ndindo ndo. David nu tane tuku tugu ŋgaig ta son ta nu sine ŋakmba tuku gabat minwa. Ta tuku tane ndaŋam tuku sine ake agaŋ taŋaŋ talasiŋgig? Gabat suŋgo tumba luka te prowam tuku wamdus ta sineŋge tugu pilgeŋ ŋginaig. Taŋakinaig kande nane Yuda mbal pasambi kualeyauka Israel mbal kile-ibeŋkinaig. ");
INSERT INTO ssd_vpl VALUES ("S220_1","011_20_1","2SA","20","1","1","Taŋgo ŋayonu ande Bikri kiŋo nuŋe Seba nu nane ndoŋ Gilgal tumbraŋ taŋge minna. Taŋgo ta nu Benyamin tuku kuasmbi. Nane kualeyauka minnaig le Seba ndek tabil fitka wi kueŋka sakina: Tane David kusrewap. Sine Yesi kiŋo nuŋe David tuku kuasmbi kuga. Tane Israel taŋgo ŋakmba tiŋga taŋgine tumbraŋ tumbraŋ kine likap ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S220_2","011_20_2","2SA","20","2","2","Israel taŋgo ŋakmba pasa ta ismba tiŋga David kusremba Seba dubimba kinaig. Taŋamba kinaig le nane Yuda kuasmbi ndo David kumnemŋge minnaig sulumba Yordan kule kusremba nu dubimba ka Yerusalem pronaig. ");
INSERT INTO ssd_vpl VALUES ("S220_3","011_20_3","2SA","20","3","3","Nane Yerusalem pronaig sulumba David ndek nuŋe wande sinam kumba ka pino kame 10 gabat suŋgo tuku wande kulatkam tuku kusrekina ta kilmba wande ande serniŋmba taŋgo afu madiniŋgina le nane kulatka minnaig. Taŋamba nu pino kame ta nyamagaŋ agaŋ ndende niŋmba maŋ nane ndoŋ kinye ndakina. Nane ake pino kuembol taŋaŋ wande ta mbolŋge minmba ma ma saibo patika kume likinaig. ");
INSERT INTO ssd_vpl VALUES ("S220_4","011_20_4","2SA","20","4","4","Kile David ndek Amasa wika sana: Ne kaye ka Yuda taŋgo ŋakmba wika kile-maŋgurka aspile nane ŋakmba kilmba ye tugum te prowap ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S220_5","011_20_5","2SA","20","5","5","nu kina ka Yuda mbal wike lika minna ma ma gabat suŋgo nu lunu tuku ait tuna ta lina. ");
INSERT INTO ssd_vpl VALUES ("S220_6","011_20_6","2SA","20","6","6","Limba pitik pro ndana le gabat suŋgo ndek Abisai sana: Absalomŋge sine buk piti suŋgokanu siŋgina ta kile maŋ Sebaŋge piti suŋgokanu siŋgamŋgat. Ta tuku ne braiŋ yiŋe kame kuasmbi ta kilmba Seba yokermba ka biye tiwap. Kuga ta nu nuŋe kuasmbi ta ndoŋ kua ka tumbraŋ fonde kareŋnu ande sinam kuwa le sine nu te nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S220_7","011_20_7","2SA","20","7","7","Taŋakina le Abisai ndek Yoab tuku kame kuasmbi gabat suŋgo kulatkanu kuasmbi kame taŋgo ŋakmba kilmba Yerusalem kusremba Seba yokeram kinaig. ");
INSERT INTO ssd_vpl VALUES ("S220_8","011_20_8","2SA","20","8","8","Nane kinaig ka Gibeon ndame suŋgo tugum ta pronaig le Amasa pro nane kile-siglikina. Yoab nu kame tuku minde piye agaŋ silikina sulumba nuŋe kame bagi tumba niŋgot sirmba let mbol kusmba nu ndek Amasa tugum kina le kame bagi ta limba kilke mbolŋge ndekina. ");
INSERT INTO ssd_vpl VALUES ("S220_9","011_20_9","2SA","20","9","9","Taŋana le Yoab ndek Amasa sana: O tira, ne maye minit e ŋga nu wai ndinammbi Amasa tuku miŋge ŋgue biymba nu mumuwet mumuwet ŋga ");
INSERT INTO ssd_vpl VALUES ("S220_10","011_20_10","2SA","20","10","10","wai ŋaiŋammbi kame bagi kilke mbolŋge ŋgumnem ŋgumnem tina ta Amasa nu katese ndana. Kile Yoab nu kame bagi tambi Amasa fuŋgul sambrina le sina goka kilke mbol ndeka kummba maninkina. Yoab nu Amasa balena sulumba nu mambo nuŋe Abisai ndoŋ Seba yokermba te-dubinaig le ");
INSERT INTO ssd_vpl VALUES ("S220_11","011_20_11","2SA","20","11","11","Yoab tuku kame taŋgo ande nu Amasa tuku mindesiŋ tugum taŋge tiŋ minmba wi kueŋka sakina: Tane David le Yoab tuku kuasmbi kande ka Yoab dubiwap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S220_12","011_20_12","2SA","20","12","12","Amasa tuku mindesiŋ ta ndin ŋgamu taŋge ndareŋge ndo soŋga minna le kame kuasmbi promba mindesiŋ ndin tukulmba minna le nane ririŋga tiŋginaig le Yoab tuku kame taŋgo ta kaŋgermba mindesiŋ ta didika ndin makembi kumba tawimbi kaina. ");
INSERT INTO ssd_vpl VALUES ("S220_13","011_20_13","2SA","20","13","13","Taŋamba nu Amasa tuku mindesiŋ ndin kusremba ŋgaŋŋgiŋmba pilna le kame kuasmbi Yoab dubimba Seba te-dubimba kinaig. ");
INSERT INTO ssd_vpl VALUES ("S220_14","011_20_14","2SA","20","14","14","Seba nu Israel ma tugu ŋakmba kusreka kina ka Abel-Bet-Maka tumbraŋ prona le mam nuŋe Bikri tuku kuasmbi nane nu dubimba tumbraŋ sinam kinaig. ");
INSERT INTO ssd_vpl VALUES ("S220_15","011_20_15","2SA","20","15","15","Taŋanaig le Yoab tuku kuasmbi pro Seba tumbraŋ te sinam ket ŋginaig le ismba nane tumbraŋ ta te-kornaig sulumba afu nane tumbraŋ fonde tugumŋge kilke maŋgurkinaig le biŋ tiŋgina le nane ta mbolŋge tiŋga kame bunaig le afu nane tumbraŋ fonde ta sambriwam tago-tagomba minnaig. ");
INSERT INTO ssd_vpl VALUES ("S220_16","011_20_16","2SA","20","16","16","Tumbraŋ taŋge pino ande minna. Pino ta nu wamdus kuyar mayenu ŋak. Nu ndek tumbraŋ fonde poŋga Yoab tuku kuasmbi wika saniŋgina: Tane isap. Kape ka Yoab sawap le ye tugum te ilwa. Ye nu ndoŋ pasa ŋak ŋgina le nane ka Yoab sanaig le ");
INSERT INTO ssd_vpl VALUES ("S220_17","011_20_17","2SA","20","17","17","nu pino ta tugum kina le nu kusnana: Ne Yoabŋge e ŋgina le nu lafumba sakina: Au. Yeŋge ŋgina le pino ta nu ndek sana: O taŋgo suŋgo, ye pasa ande sani le isa ŋgina le Yoab ndek sakina: Ta maye. Saka le ye isi ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S220_18","011_20_18","2SA","20","18","18","Taŋakina le pino taŋge ndek teŋenmba Yoab sana: O buk nane teŋenmba sakanu. Ne piti ŋak kande ne Abel tumbraŋ kaye le Abel mbalŋge ne tuku piti ta te-tiwamŋgaig ŋganu. ");
INSERT INTO ssd_vpl VALUES ("S220_19","011_20_19","2SA","20","19","19","Sine tuku tumbraŋ suŋgo te mayenu ndo tumbraŋ afu Israel kilke mbolŋge mine likade ta liniŋgit. Sine tuku mine bafuknu. Sine Israel mbal tuku gabat suŋgo tuku miŋge kumnemŋge mineg. Tumbraŋ te Suŋgoŋge kulatkate ta ne ndaŋam tuku sine tuku tumbraŋ te ŋayo siliwam bafute ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S220_20","011_20_20","2SA","20","20","20","Taŋaka sana le Yoab nu lafumba sakina: Ye tane tuku tumbraŋ te ŋayo siliwe nda. ");
INSERT INTO ssd_vpl VALUES ("S220_21","011_20_21","2SA","20","21","21","Sine taŋgo ndindo ndo biye tiwam prowig. Taŋgo ta nyunu Seba. Nu Bikri kiŋo nuŋe. Nu Efraim ma taknu mbolŋge minna ta nu buk taŋgo kame kile-maŋgurka gabat suŋgo David te-siwam sakina. Ta tuku tane Seba tumba sine siŋgap le sine tane tuku tumbraŋ kusremba kaŋgig ŋgina le pino ta ndek Yoab sana: Ta maye. Sine taŋgo ta ŋinfok kat purmba gabatnu te-bukŋgube le fonde lukamba kilim kuwa le ne kaŋgeramŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S220_22","011_20_22","2SA","20","22","22","Taŋakina sulumba pino ta kumba ka tumbraŋ taŋgo kame ndoŋ sakina le isnaig. Ismba nane kinaig ka Seba ŋinfoknu kat purmba te-bukŋginaig le fonde lukamba kilimŋge Yoab tugumŋge ndekina le nu ndek tabil fitkina le kame kuasmbi ŋakmba tumbraŋ kusremba sili-silimba kinaig le Yoab ndek luka gabat suŋgo sota Yerusalem kina. ");
INSERT INTO ssd_vpl VALUES ("S220_23","011_20_23","2SA","20","23","23","Yoab nu Israel kame kuasmbi ŋakmba tuku gabat suŋgo minna. Yehoyada kiŋo nuŋe Benaya nu David kulatkanu kuasmbi tuku gabat minna. (Nane kuasmbi ta Keret le Peret mbal). ");
INSERT INTO ssd_vpl VALUES ("S220_24","011_20_24","2SA","20","24","24","Adoniram nu David tuku piro mbal tuku gabat. Ahilud kiŋo nuŋe Yehosafat nu waŋe kuyaram tuku piro kulatkina. ");
INSERT INTO ssd_vpl VALUES ("S220_25","011_20_25","2SA","20","25","25","Seva nu David tuku waŋe kuyaranu taŋgo. Sadok le Abiatar nale pris pirokinaik. ");
INSERT INTO ssd_vpl VALUES ("S220_26","011_20_26","2SA","20","26","26","Yairnu taŋgo Ira nu mata David tuku pris pirokina tuku taŋgo ande. ");
INSERT INTO ssd_vpl VALUES ("S221_1","011_21_1","2SA","21","1","1","David nu gabat suŋgo minna le guba suŋgo prona le yar keŋmba ma tugu ŋakmba nyamagaŋ tuku fagkinaig tukunu David ndek Suŋgo sana: O Suŋgo, piti te ndaŋam prote ŋgina le Suŋgo ndek nu sana: Piti prote te tugunu teŋenmba. Gabat suŋgo Saulŋge o buk Gibeon mbal suŋgomba bale farkina le nane tuku ndare ta Saul tuku kuasmbi kile pasokate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S221_2","011_21_2","2SA","21","2","2","Taŋakina le David ndek Gibeon mbal wikina le pronaig. (Gibeon mbal nane Israel tugu kuga. Nane Amornu. Israel mbalŋge o buk nane ndoŋ pasa katmba wamdus ulendimba nane mapekam tuku sakinaig ta Saulŋge pasa ta pitaimba Israel le Yuda mbal ndo Israel ma tugu mbol minwaig ŋga Gibeon mbal suŋgomba bale farkina). ");
INSERT INTO ssd_vpl VALUES ("S221_3","011_21_3","2SA","21","3","3","Kile David ndek Gibeon mbal ta kusnaniŋgina: Sine tane mbol mbargeŋ ta kile ye tane ndoŋ te-tiwamŋgit. Taŋawi le tane Suŋgo tuku kuasmbi te nyaro niŋgap ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S221_4","011_21_4","2SA","21","4","4","nane ndek David sanaig: Piti ta sine ŋgamukŋge Saul nuŋe kuasmbi ŋgamukŋge minit. Piti ta tane silwa ndametiŋ ko gol ndametiŋmbi te-tiwam kumuŋ kuga. Sine Israel taŋgo afu mata bale fare nda ŋginaig le David ndek saniŋgina: Ata. Ye ame maŋau tane mbol ki ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S221_5","011_21_5","2SA","21","5","5","nane lafumba sakinaig: Saul tuku wamdus ta nu sine ŋakmba ŋaigo siglika tumbraŋ tumu pilwa le Israel mbalŋge ndo minam tuku idusna. ");
INSERT INTO ssd_vpl VALUES ("S221_6","011_21_6","2SA","21","6","6","Ta tuku ne Saul tuku ndare mbolŋge taŋgo 7 madiniŋmba siŋga le sine nane kilmba ka gabat suŋgo Saul nuŋe tumbraŋ tuguk Gibea kumba ka taŋge Suŋgo am mbolŋge muli ŋinfok panniŋbe le kumwaig ŋginaig. Taŋakinaig le David ndek nane saniŋgina: Ta maye. Ye taŋawamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S221_7","011_21_7","2SA","21","7","7","David nu o buk Suŋgo tuku nyu mbolŋge Yonatan ndoŋ pasa katnaik tukunu nu pasa ta idusmba Yonatan tuku kiŋo nuŋe Mefiboset mapemba nu tumba Gibeon mbal nda niŋgina. ");
INSERT INTO ssd_vpl VALUES ("S221_8","011_21_8","2SA","21","8","8","Nu Armoni le Mefiboset wau nuŋe ande ta kilmba nane niŋgina. (Taŋgo ar ta Saul tuku kiŋo kame. Nale Aia kulim nuŋe Rispaŋge kile-patike tuna). Taŋamba David nu Saul kulim nuŋe Merab tuku kiŋo 5 ta turmba kilmba nane niŋgina. (Meholanu taŋgo Barsilai kiŋo nuŋe Adriel nuŋge Saul kulim nuŋe Merab tumba kiŋo kame 5 ta kile-patikina). ");
INSERT INTO ssd_vpl VALUES ("S221_9","011_21_9","2SA","21","9","9","David ndek taŋgo 7 ta kilmba Gibeon mbal niŋgina le kilmba ka tabe mbol kinaig sulumba ka Suŋgo am mbolŋge taŋgo 7 ta muli ŋinfok panniŋmba taikinaig le ŋakmba kumnaig. Piro mbolŋge wit magekinaig le taŋgo nane wit kilmba minnaig le wam ta kinaig. ");
INSERT INTO ssd_vpl VALUES ("S221_10","011_21_10","2SA","21","10","10","Kile taŋgo ar kumnaik ta tuku ina nakile Rispa ndek tawi urfunu afu kilmba ka tabe mbol taŋge baibai ande pilmba nu ka sinam taŋge minmba agaŋmor ŋguikokŋge ko sar umaŋŋge mindesiŋ ta nyubekaig ŋga ki mindek furir mindek mindesiŋ ta kulat magekina le ma ma sawe tuku ait prona. ");
INSERT INTO ssd_vpl VALUES ("S221_11","011_21_11","2SA","21","11","11","David nu Rispa wam kina ta sanaig le ismba ");
INSERT INTO ssd_vpl VALUES ("S221_12","011_21_12","2SA","21","12","12","nu ndek Gilead ma tugu Yabes tumbraŋ kina ka Saul le Yonatan tuku isu kilna. (O buk Filistia mbalŋge Gilboa tabe mbolŋge balenikmba nale tuku mindesiŋ kilmba ka maŋgurkanu ma Bet-Sanŋge taikinaig le Yabes mbalŋge ka isu ta kuayarkumba kinaig). ");
INSERT INTO ssd_vpl VALUES ("S221_13","011_21_13","2SA","21","13","13","Kile David ndek nuŋe piro taŋgo saniŋgina le Saul le Yonatan tuku isu ta kilmba taŋgo 7 Gibeon mbalŋge kilmba ŋinfok panniŋginaig ta tuku isu ta ulendimba kilmba kinaig ka ");
INSERT INTO ssd_vpl VALUES ("S221_14","011_21_14","2SA","21","14","14","Sela tumbraŋ Benyamin tuku ma tugu taŋge Saul le Yonatan tuku isu kilmba Saul mam nuŋe Kis ŋgukinaigmbi taŋge ŋgukinaig sulumba gabat suŋgoŋge wam paguniŋmba saniŋgina ta kumumba kinaig. Wam kame ta deŋpurmba kile nane Suŋgo yabaŋnaig le nu nane tuku yabaŋ pasa ismba sakina le piro mbolŋge nyamagaŋ maŋ kumuŋginaig. ");
INSERT INTO ssd_vpl VALUES ("S221_15","011_21_15","2SA","21","15","15","Taŋamba minnaig ma ma kame maŋ Filistia Israel ŋgamukŋge tumba tiŋgina le David ndek nuŋe kame kuasmbi kilmba Filistia mbal ndoŋ kame bunaig. Kame bumba minnaig ma ma David buk matuk kina le ");
INSERT INTO ssd_vpl VALUES ("S221_16","011_21_16","2SA","21","16","16","Filistia taŋgo ande nyunu Isbibenob nu pro David balewam bafuna. Isbibenob nu taŋgo sugo sugo ta tuku ndare ande. Nu tuku mbanduwaŋ gabatnu ta ainmbi wakeiwanu. Pitinu ta 3 kilo lina. Nu kame bagi kitek tumba likina. ");
INSERT INTO ssd_vpl VALUES ("S221_17","011_21_17","2SA","21","17","17","Nu David balewam bafuna le Abisai pro David te-simba Filistia taŋgo suŋgo ta ndoŋ kame bumba nu balena le kumna. Taŋana le David tuku kame kuasmbi pro nu sanaig: Sine kamenu kab kande ne maŋ sine dubi ndaka. Ne sine Israel mbal tuku bulu taŋaŋ kilŋasiŋgit ta kupe serikat ŋginaig le David nu nane ndoŋ pasa katmba sakina: Ye maŋ kame mbol kine nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S221_18","011_21_18","2SA","21","18","18","Minnaig ma ma Israel mbal maŋ kinaig ka Gob tumbraŋŋge nane Filistia mbal ndoŋ kame bunaig. Kame ta mbolŋge Husanu taŋgo Sibekai nu mata taŋgo ndare sugo sugo ta tuku ande nyunu Saf balena le kumna. ");
INSERT INTO ssd_vpl VALUES ("S221_19","011_21_19","2SA","21","19","19","Mara ande nane Israel mbal maŋ kinaig ka Gob tumbraŋŋge Filistia mbal ndoŋ kame bunaig le Betlehemnu taŋgo Yair tuku kiŋo nuŋe Elhanan nuŋge mata taŋgo ndare sugo sugo ta tuku ande nyunu Goliat balena le kumna. Goliat nu Gatnu. Nu tuku sibugi ta suŋgokanu piti ŋayo. ");
INSERT INTO ssd_vpl VALUES ("S221_20","011_21_20","2SA","21","20","20","Mara ande nane maŋ kinaig ka Gat tumbraŋŋge kame bunaig. Tumbraŋ taŋge taŋgo ndare ndui ta tuku ande minna. Taŋgo ta nu suŋgokanu kuen ŋayo. Nu tuku wai nyigriŋ ta 12 kupe nyigriŋ mata 12. ");
INSERT INTO ssd_vpl VALUES ("S221_21","011_21_21","2SA","21","21","21","Taŋgo ta ndek nane Israel mbal maim maim pasa saniŋgina le Yonatanŋge taŋgo ta balena le kumna. (Yonatan nu David aba nuŋe Sama tuku kiŋo nuŋe). ");
INSERT INTO ssd_vpl VALUES ("S221_22","011_21_22","2SA","21","22","22","Taŋgo bailkamba ta nane Gatnu taŋgo sugo sugo nane tuku ndare. Nane David tuku kuasmbiŋge bale farkinaig. ");
INSERT INTO ssd_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","Suŋgoŋge David Saul tuku wai mbolŋge ŋgueu mbal ŋakmba tuku wai mbolŋge te-luka tina le nu Suŋgo tuku nyu te-duŋga mune te ulna. ");
INSERT INTO ssd_vpl VALUES ("S222_2","011_22_2","2SA","22","2","2","Ye piti sinamŋge minet ta Suŋgo nu fonde kareŋnu taŋaŋ ye tumba koryate. ");
INSERT INTO ssd_vpl VALUES ("S222_3","011_22_3","2SA","22","3","3","Nu ndame kune taŋaŋ ye ka sinam taŋge kuirket. Nu kandim taŋaŋ ye kigraibkate le ŋgueu mbalŋge ye ŋayo sili ndayade. Nu ye kigraibkate le ye mine mayewet. ");
INSERT INTO ssd_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","Sine Suŋgo tuku nyu te-duŋgube. Ye nu wika yabaŋet le nu ye ŋgueu mbal tuku wai mbolŋge te-luka tate. ");
INSERT INTO ssd_vpl VALUES ("S222_5","011_22_5","2SA","22","5","5","Yu mbalo sugo sugo tiŋga ye kaiyam bafude taŋaŋ nane ye ŋayo siliyam bafunaig. ");
INSERT INTO ssd_vpl VALUES ("S222_6","011_22_6","2SA","22","6","6","Nane ye tumba muli-muliyinaig le ye kume dirmba ");
INSERT INTO ssd_vpl VALUES ("S222_7","011_22_7","2SA","22","7","7","wamdus piti ŋak minmba yiŋe Mbara Suŋgo ye turyuwa ŋga wiken le nu nuŋe tukul wande mbolŋge ye tuku wi ta isna. ");
INSERT INTO ssd_vpl VALUES ("S222_8","011_22_8","2SA","22","8","8","Taŋamba Kuate nu nane tuku gubrana le kilke samba buru-burukina. ");
INSERT INTO ssd_vpl VALUES ("S222_9","011_22_9","2SA","22","9","9","Nu tuku fumbe burok kumam pa guwa prona. Miŋge kumam pa suŋgo kraŋer-kraŋerka tui fat taŋaŋ pirsi-parsinaig. ");
INSERT INTO ssd_vpl VALUES ("S222_10","011_22_10","2SA","22","10","10","Nu samba malaŋga talka gau dabuk dabuk mbol tiŋga ndekina. ");
INSERT INTO ssd_vpl VALUES ("S222_11","011_22_11","2SA","22","11","11","Nu eŋel mbol minyokina le bubre pinderka kinit taŋaŋ fumba tumba ndekina. ");
INSERT INTO ssd_vpl VALUES ("S222_12","011_22_12","2SA","22","12","12","Ma furir suŋgo sawe ma kimkanu suk nu tumba soŋgina le ");
INSERT INTO ssd_vpl VALUES ("S222_13","011_22_13","2SA","22","13","13","teliŋ sana le ma kilŋamba ndekina. ");
INSERT INTO ssd_vpl VALUES ("S222_14","011_22_14","2SA","22","14","14","Taŋana le Suŋgo samba mbolŋge kuaila fudukate taŋaŋ kueŋka sakina le ");
INSERT INTO ssd_vpl VALUES ("S222_15","011_22_15","2SA","22","15","15","ma teliŋmba tui fat taŋaŋ ŋgueu mbal ninde farna le kua ka sili-silinaig. ");
INSERT INTO ssd_vpl VALUES ("S222_16","011_22_16","2SA","22","16","16","Suŋgo nu ŋgueu mbal tuku gubra kagli firka nane saniŋge likumba miŋgembi bubre fitkina le yu paraka yu sinamok agaŋ ta ŋakmba kilim kinaig. ");
INSERT INTO ssd_vpl VALUES ("S222_17","011_22_17","2SA","22","17","17","Taŋanaig le Suŋgo nu wai sirmba ye te-luka tina. ");
INSERT INTO ssd_vpl VALUES ("S222_18","011_22_18","2SA","22","18","18","Ŋgueu mbal saŋgriknu ye te-ibeŋyam bafunaig le Suŋgo nu ye te-luka tina. ");
INSERT INTO ssd_vpl VALUES ("S222_19","011_22_19","2SA","22","19","19","Ye piti suŋgomba ŋak minen le nane pro ye ndoŋ kame bunaig ta Suŋgo nu ye kusre ndayina. ");
INSERT INTO ssd_vpl VALUES ("S222_20","011_22_20","2SA","22","20","20","Nu ye tuku garena tukunu nu ye te-luka tina le ye mine mayewen. ");
INSERT INTO ssd_vpl VALUES ("S222_21","011_22_21","2SA","22","21","21","Ye maŋau tiŋreknu ndo dubimba minen le nu lafumba wam mayenu ye mbol kina. ");
INSERT INTO ssd_vpl VALUES ("S222_22","011_22_22","2SA","22","22","22","Ye Suŋgo tuku tukul pasa ndo dubiwen sulumba Kuate ŋgumne ndawen. ");
INSERT INTO ssd_vpl VALUES ("S222_23","011_22_23","2SA","22","23","23","Ye nu tuku tukul kame mara mindek idus timba dubiniŋmba minmba nu tuku pasa pitai ndawet. ");
INSERT INTO ssd_vpl VALUES ("S222_24","011_22_24","2SA","22","24","24","Ye nu tuku am mbolŋge purfeŋnu minmba une maŋau ke ndaken. ");
INSERT INTO ssd_vpl VALUES ("S222_25","011_22_25","2SA","22","25","25","Ta tuku Suŋgo nu ye tuku maŋau ta lafumba maŋau mayenu ye mbol kina. ");
INSERT INTO ssd_vpl VALUES ("S222_26","011_22_26","2SA","22","26","26","O Suŋgo, sine ne kusre ndanube ta ne mata sine kusreke nda. Sine maŋau purfeŋnu ndo kumba minbe ta ne maŋau mayenu ndo sine mbol kate. ");
INSERT INTO ssd_vpl VALUES ("S222_27","011_22_27","2SA","22","27","27","Sine mbar maŋau kumba minbe ta ne lafunu ŋayonu sine siŋgit. Sine maŋau tiŋreknu ndo dubibe ta ne lafunu maŋau tiŋreknu sine mbol kate. ");
INSERT INTO ssd_vpl VALUES ("S222_28","011_22_28","2SA","22","28","28","Sine siŋgine nyu yabukube ta ne sine kile-luka kilit. Sine siŋgine nyu payamkube ta ne sine tuku nyu kile-ibeŋkamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S222_29","011_22_29","2SA","22","29","29","O Suŋgo, ne ye tuku bulu taŋaŋ ma furir pitaite. ");
INSERT INTO ssd_vpl VALUES ("S222_30","011_22_30","2SA","22","30","30","Ne ye sinzaŋya le ye ŋgueu mbal tuku fonde kareŋnu lukamba nane kile-ibeŋkamŋgit. ");
INSERT INTO ssd_vpl VALUES ("S222_31","011_22_31","2SA","22","31","31","Kuate tuku maŋau purfeŋnu ndo. Pasa nuŋe ta tiŋreknu ndo. Nu kandim taŋaŋ nuŋe mbal kigraibkate. ");
INSERT INTO ssd_vpl VALUES ("S222_32","011_22_32","2SA","22","32","32","Suŋgo nu Mbara ndindo. Nu ndo ndame kune suŋgo taŋaŋ sine kilmba korsiŋgit. ");
INSERT INTO ssd_vpl VALUES ("S222_33","011_22_33","2SA","22","33","33","Kuate nu ye kuirkam tuku ma mayenu. Nu ye kambim tuku ndin mayenu fuŋgit. ");
INSERT INTO ssd_vpl VALUES ("S222_34","011_22_34","2SA","22","34","34","Nu ye tuku kupe saŋgri pilete le ye saŋgri tiŋga kinenumet. ");
INSERT INTO ssd_vpl VALUES ("S222_35","011_22_35","2SA","22","35","35","Nu ye tuku wai saŋgri pilete le ye tui kareŋnu didiket. ");
INSERT INTO ssd_vpl VALUES ("S222_36","011_22_36","2SA","22","36","36","O Suŋgo, ne ye sinzaŋyumba naŋe kandim saŋgrinu ye sumba kaiyate le ye nyu ŋak minet. ");
INSERT INTO ssd_vpl VALUES ("S222_37","011_22_37","2SA","22","37","37","Ne ye ndin mayenu tumyate le ye kupe basleŋga bari ndaŋget. ");
INSERT INTO ssd_vpl VALUES ("S222_38","011_22_38","2SA","22","38","38","Ye ŋgueu mbal kogroŋka ŋakmba kilmba ŋaigo siglike suluwen le ");
INSERT INTO ssd_vpl VALUES ("S222_39","011_22_39","2SA","22","39","39","nane gororomba ye tuku kupe tugum taŋge ndekinaig. ");
INSERT INTO ssd_vpl VALUES ("S222_40","011_22_40","2SA","22","40","40","Ne ye saŋgri pileyina le ye kame mbolŋge ŋgueu mbal ŋakmba kile-ibeŋken. ");
INSERT INTO ssd_vpl VALUES ("S222_41","011_22_41","2SA","22","41","41","Ne ye sinzaŋyina le ŋgueu mbal ŋakmba kua ka sili-silinaig le ye nane kilmba ŋaigo sigliken. ");
INSERT INTO ssd_vpl VALUES ("S222_42","011_22_42","2SA","22","42","42","Nane wikinaig ta andeŋge nane kile-luka kile ndakina. O Suŋgo, ne mata nane ismba nda isanu sukna. ");
INSERT INTO ssd_vpl VALUES ("S222_43","011_22_43","2SA","22","43","43","Ye nane kilmba tidoŋ firfirken le nane kukedu suk pronaig. ");
INSERT INTO ssd_vpl VALUES ("S222_44","011_22_44","2SA","22","44","44","Israel mbal afu nane ye ndoŋ kame bumba ye te-ibeŋyam bafunaig le ne ye te-luka tumba nane tuku gabat madiyina. Taŋgo pino buk nane ye gilai ta nane kile ye tuku miŋge kumnemŋge minig. ");
INSERT INTO ssd_vpl VALUES ("S222_45","011_22_45","2SA","22","45","45","Rawe mbal ye tugum promba dagol tidroŋga lokade. Nane ye tuku pasa ismba dubide. ");
INSERT INTO ssd_vpl VALUES ("S222_46","011_22_46","2SA","22","46","46","Nane naŋgine tumbraŋ fonde kareŋnu ŋak ta kusreka kuru-kuruka ye tugum prode. ");
INSERT INTO ssd_vpl VALUES ("S222_47","011_22_47","2SA","22","47","47","Suŋgo nu abo tugu ŋak. Nu ye tuku ndame kune suŋgo taŋaŋ ye tumba kaiyate. Kuateŋge ye te-luka tina. Ta tuku sine nu tuku nyu te-duŋgube. ");
INSERT INTO ssd_vpl VALUES ("S222_48","011_22_48","2SA","22","48","48","Nu ŋgueu mbal ŋakmba kile-ibeŋka ye sinzaŋyate le nane ŋakmba ye kumnemŋge minig. ");
INSERT INTO ssd_vpl VALUES ("S222_49","011_22_49","2SA","22","49","49","Yiŋe ŋgueu mbal ŋgamukŋge nu ye kor mayeyate. O Suŋgo, ne yiŋe ŋgueu mbal ŋgamukŋge ne ye kigraibka ye sinzaŋ mayeyina sulumba ne ye madiyumba nane tuku gabat pilna le minet. ");
INSERT INTO ssd_vpl VALUES ("S222_50","011_22_50","2SA","22","50","50","Ta tuku ye kile kasomok mbal tuku am mbolŋge gare-gareka ne tuku nyu te-duŋget. ");
INSERT INTO ssd_vpl VALUES ("S222_51","011_22_51","2SA","22","51","51","Kuate nu ye gabat suŋgo mini ŋga madiyina. Mara mindek nu ye turyina le ŋgueu mbal ŋakmba kile-ibeŋken. Nuŋe raŋgun mayenu kume pur maŋau mara mindek ye mbolŋge yiŋe ndare mbolŋge tuturmba minmba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S223_1","011_23_1","2SA","23","1","1","Pasa te David tuku wam pagu pasa. Ye David Yesi tuku kiŋo nuŋe yeŋge wam pagu pasa te saket. Yakob tuku Mbara Suŋgo Saŋgri Ŋayo nuŋge ye gabat suŋgo minam tuku madiyina le taŋgo ŋakmba tuku am mbolŋge ye nyu suŋgo ŋak minet. Ye mune magenu suŋgomba Israel mbal nindam tuku kuyarke liken. Ye yiŋe pasa tukulmba teŋenmba saket. ");
INSERT INTO ssd_vpl VALUES ("S223_2","011_23_2","2SA","23","2","2","Suŋgo tuku Guwaŋge ye sayate le pasa kukliwet. Nuŋge ye tuku miŋge tumba tane wam pagutiŋgit. ");
INSERT INTO ssd_vpl VALUES ("S223_3","011_23_3","2SA","23","3","3","Israel mbal tuku Mbara nu ndame kune suŋgokanu taŋaŋ sine kilmba kaisiŋgit. Nu teŋenmba ye sayina. Gabat suŋgo nu Kuate kumnemŋge minmba maŋau tiŋreknumbi taŋgo pino kulatkate ta ");
INSERT INTO ssd_vpl VALUES ("S223_4","011_23_4","2SA","23","4","4","nu ki kitek prowam tuku ma tugu ramba gau purfemba ki buluŋgate taŋaŋ. Nu ki promba mbai ŋgislu aŋga waŋe mbol liŋleŋkanu taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("S223_5","011_23_5","2SA","23","5","5","Suŋgoŋge ye tuku ndare tuturmba kaŋgat ta nyaro niŋguwa. Nu o buk ye ŋak wamdus ulendimba pasa katna ta nu pasa ta mbile nda. Nu mara mindek nuŋe raŋgun mayenumbi ye saŋgri pileyate le ye mine mayewet. ");
INSERT INTO ssd_vpl VALUES ("S223_6","011_23_6","2SA","23","6","6","Taŋgo ŋaigonu ta Kuateŋge muli ago ŋak taŋaŋ kilmba kile-pankamŋgat. Taŋgo andeŋge muli ago ŋak ta nuŋe waimbi biye nda. ");
INSERT INTO ssd_vpl VALUES ("S223_7","011_23_7","2SA","23","7","7","Nu muli ago ŋak ta mbanimbi silimba ka pasokam tuku ma mbolŋge maŋgurka pa dikŋguwa le ugmba tatrukamŋgat. ");
INSERT INTO ssd_vpl VALUES ("S223_8","011_23_8","2SA","23","8","8","David tuku kame gabat sugo sugo tuku nyu kat naŋgine ta teŋenmba. Yoseb Basebet nu kame gabat sugo keŋ ta tuku amboŋganu gabat. Taŋgo ta nu Takemon mbal tuku ndare. Ait ande nu kame mbolŋge mbanduwaŋ biymba kame bumba ŋgueu mbal 800 bale farkina le kumnaig. ");
INSERT INTO ssd_vpl VALUES ("S223_9","011_23_9","2SA","23","9","9","Nu dubiknu ta Dodo kiŋo nuŋe Eleasar. Eleasar nu Aho mbal tuku ndare. Nu mata David tuku kame gabat sugo keŋ ta tuku ande. Ait ande nu David ndoŋ minna sulumba Filistia mbal kame tuku maŋgurka minnaig le nale ndek Filistia mbal ta kame tuku kile-saika minnaik. Taŋanaik le nane promba kame bunaig le Israel mbal ŋakmba kua ka sili-silinaig le ");
INSERT INTO ssd_vpl VALUES ("S223_10","011_23_10","2SA","23","10","10","Eleasar nuŋe ndo tiŋga Filistia mbal ndoŋ kame bumba kina ka ka nu matuk kumba wai kume tirina ta nu kame bagi kusre ndana. Ait ta mbolŋge Suŋgoŋge Filistia mbal kile-ibeŋkina le Israel mbal kua ka sili-silinaig ta nane maŋ luka Eleasar tugum promba Filistia mbal kume farnaig ta tuku ŋgaro yubeŋgam tuku minde piye agaŋ ta paske likinaig. ");
INSERT INTO ssd_vpl VALUES ("S223_11","011_23_11","2SA","23","11","11","David tuku kame gabat sugo keŋ ta tuku inum ta Agi kiŋo nuŋe Sama. Taŋgo ta Hararnu. Ait ande nane Filistia mbal pro Lei tumbraŋŋge piro ande tugumŋge kame tuku kuaneka tiŋginaig le Israel mbal nane kaŋgerka kua kinaig. ");
INSERT INTO ssd_vpl VALUES ("S223_12","011_23_12","2SA","23","12","12","Taŋanaig le Sama nu kua kine ndaka nu piro sinam taŋge tiŋga nane Filistia mbal kilke ta tubekaig ŋga kame tiŋga Filistia mbal ta bale farna. Ait ta mbolŋge Suŋgoŋge Filistia mbal ŋakmba kile-ibeŋkina. ");
INSERT INTO ssd_vpl VALUES ("S223_13","011_23_13","2SA","23","13","13","Mo ait mbolŋge Filistia tuku kame kuasmbi afu pro Refaim ma gutoŋ taŋge kame tuku kuaneka minnaig le David nu Adulam tuku ndame burok sinam taŋge minna le nu tuku kame gabat sugo keŋ ta nu tugum pronaig. ");
INSERT INTO ssd_vpl VALUES ("S223_14","011_23_14","2SA","23","14","14","Taŋanaig le David nu tabe poŋga nuŋe fonde kareŋnu sinam kumba ka taŋge minna le Filistia mbal buk Betlehem tumbraŋ tinaig. ");
INSERT INTO ssd_vpl VALUES ("S223_15","011_23_15","2SA","23","15","15","Tinaig le David ndek nuŋe tumbraŋ idusmba kule parana sulumba sakina: Ye kumba ka Betlehem tumbraŋ fonde malaŋgambi kule burok sinamŋge kule bulbulmba prote ta ye nyam parayate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S223_16","011_23_16","2SA","23","16","16","Taŋakina le nane gabat sugo keŋ ta tiŋga kinaig ka Filistia mbal Betlehem kulatka minnaig tambik ri ndamba nane ndoŋ kame bumba ka sinam ka David kule burok sakina ta kunymba tumba pro David tunaig kande nu nyam mbulmba kule ta tumba Suŋgo tuku atraukina sulumba ");
INSERT INTO ssd_vpl VALUES ("S223_17","011_23_17","2SA","23","17","17","ndek sakina: O Suŋgo, ye kule te nyi ta taŋgo kame te tuku ndare nyanu taŋaŋ. Nane kumam tuku ndin mbolŋge kagig ka kule kunymba prowaig ŋgina. Taŋakina sulumba nu kule ta nyam mbulmba atraukina. Gabat sugo keŋ ta nane taŋamba ndo maŋau ke likinaig le Israel mbal ŋakmba nane tuku saka minnaig. ");
INSERT INTO ssd_vpl VALUES ("S223_18","011_23_18","2SA","23","18","18","Yoab mambo nuŋe Abisai nu kame gabat saŋgriknu 30 ta tuku gabat naŋgine. (Nale tuku ina nakile Seruya). Ait ande Abisai nu nuŋe mbanduwaŋ tambi ŋgueu mbal 300 kilmba bale farna le kumnaig tukunu nu taŋgo 30 ta ŋgamukŋge nu taŋgo nyu ŋak minna. ");
INSERT INTO ssd_vpl VALUES ("S223_19","011_23_19","2SA","23","19","19","Taŋamba minmba nu nane tuku gabat mayok kina ta nu kame gabat sugo keŋ ta kumnemŋge minna. ");
INSERT INTO ssd_vpl VALUES ("S223_20","011_23_20","2SA","23","20","20","Yehoyada kiŋo nuŋe Benaya nu mata kame taŋgo ande nyu ŋak minna. Benaya nu Kabselnu. Nu kuru kuru ndaka ŋgueu mbal suŋgomba bale farkina sulumba Moabnu kame taŋgo nyu ŋak armba turmba bale farkina le kumnaik. Bidu tiŋga ma tido pilna ait ta mbolŋge nu burok ande sinam kumba ka laion ande balena le kumna. ");
INSERT INTO ssd_vpl VALUES ("S223_21","011_23_21","2SA","23","21","21","Taŋamba ait ande nu ka Isipnu taŋgo suŋgo ande te-silikina. Taŋgo ta nu nuŋe mbanduwaŋ biye ŋak minna le Benayaŋge mbanduwaŋ yaimba tumba nu balena le kumna. ");
INSERT INTO ssd_vpl VALUES ("S223_22","011_23_22","2SA","23","22","22","Benaya nu maŋau taŋamba ndo ke likina sulumba nu gabat 30 ta tuku ande minna. ");
INSERT INTO ssd_vpl VALUES ("S223_23","011_23_23","2SA","23","23","23","Nu nane ŋgamukŋge nyu ŋak minna ta nu kame gabat sugo keŋ ta kumnemŋge minna. ");
INSERT INTO ssd_vpl VALUES ("S223_24","011_23_24","2SA","23","24","24","Kame gabat 30 ta tuku nyu kat naŋgine ta teŋenmba. Ande Asahel nu Yoab tuku mambo nuŋe. Ande Elhanan nu Betlehemnu. Mam nuŋe Dodo. ");
INSERT INTO ssd_vpl VALUES ("S223_25","011_23_25","2SA","23","25","25","Sama le Elika nale Harodnu. ");
INSERT INTO ssd_vpl VALUES ("S223_26","011_23_26","2SA","23","26","26","Heles nu Paletnu. Ira nu Tekoanu. Mam nuŋe Ikes. ");
INSERT INTO ssd_vpl VALUES ("S223_27","011_23_27","2SA","23","27","27","Abieser nu Anatotnu. Mebunai nu Husanu. ");
INSERT INTO ssd_vpl VALUES ("S223_28","011_23_28","2SA","23","28","28","Salmon nu Ahonu. Maharai nu Netofanu. ");
INSERT INTO ssd_vpl VALUES ("S223_29","011_23_29","2SA","23","29","29","Heleb nu mata Netofanu. Mam nuŋe Bana. Itai nu Gibeanu Benyamin ma tugu mbolok. Mam nuŋe Ribai. ");
INSERT INTO ssd_vpl VALUES ("S223_30","011_23_30","2SA","23","30","30","Benaya nu Piratonnu. Hidai nu Gas ma gutoŋ mbolok. ");
INSERT INTO ssd_vpl VALUES ("S223_31","011_23_31","2SA","23","31","31","Abi-Albon nu Arbatnu. Asmafet nu Bahurimnu. ");
INSERT INTO ssd_vpl VALUES ("S223_32","011_23_32","2SA","23","32","32","Eliaba nu Salbonnu. Yasen tuku kiŋo kat nuŋe mata nane ŋgamukŋge minnaig. Taŋgo ande nyunu Yonatan nu mata nane ndoŋ minna. ");
INSERT INTO ssd_vpl VALUES ("S223_33","011_23_33","2SA","23","33","33","Samat nu Hararnu. Ahiam nu Hararnu. Mam nuŋe Sarar. ");
INSERT INTO ssd_vpl VALUES ("S223_34","011_23_34","2SA","23","34","34","Elifelet nu Makanu. Mam nuŋe Ahasbai. Eliam nu Gilonu. Mam nuŋe Ahitofel. ");
INSERT INTO ssd_vpl VALUES ("S223_35","011_23_35","2SA","23","35","35","Hesro nu Karmelnu. Parai nu Arbnu. ");
INSERT INTO ssd_vpl VALUES ("S223_36","011_23_36","2SA","23","36","36","Igal nu Sobanu. Mam nuŋe Natan. Wa nuŋe Hagri. ");
INSERT INTO ssd_vpl VALUES ("S223_37","011_23_37","2SA","23","37","37","Bani nu Gadnu. Selek nu Amonnu. Naharai nu Berotnu. Nu Yoab tuku kandim agaŋ ndende kugrakanu taŋgo. ");
INSERT INTO ssd_vpl VALUES ("S223_38","011_23_38","2SA","23","38","38","Ira le Gareb nale Itranu. ");
INSERT INTO ssd_vpl VALUES ("S223_39","011_23_39","2SA","23","39","39","Uria nu Hitnu. Nane ulendimba taŋgo 37 minnaig. ");
INSERT INTO ssd_vpl VALUES ("S224_1","011_24_1","2SA","24","1","1","Ait ande Suŋgo nu Israel mbal tuku gubrana le nu nane Davidŋge piti niŋguwa ŋga nu sana: Ne kumba Israel taŋgo pino Yuda taŋgo pino ŋakmba pileniŋmba burke lika ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S224_2","011_24_2","2SA","24","2","2","Taŋakina le David ndek nuŋe kame gabat Yoab wam pagumba sana: Ne tiŋga naŋe gabat kame kilmba ka siŋgine kuasmbi Israel taŋgo pino ŋakmba burkap. Tane Israel ma tugu ŋakmba mbol kape sulumba Israel taŋgo pino burkap le ye taŋgo giganmba minig ta katesewi ŋgina le ");
INSERT INTO ssd_vpl VALUES ("S224_3","011_24_3","2SA","24","3","3","Yoab ndek lafumba nu sana: O gabat suŋgo, naŋe kuasmbi Israel mbal Suŋgoŋge sinzaŋniŋguwa le taŋgo pino puluka tugeka suŋgomba prowaig ŋga iduset ta kile ne ndaŋam tuku taŋgo pino burkam sakate? Wam ta mayenu ndo kuga ŋgina kande ");
INSERT INTO ssd_vpl VALUES ("S224_4","011_24_4","2SA","24","4","4","gabat suŋgo nu Yoab nuŋe gabat kame piro ta kuwaig ŋga dirnaŋga minna le nane nu tuku pasa dubimba ndek Israel taŋgo pino burnu kinaig. ");
INSERT INTO ssd_vpl VALUES ("S224_5","011_24_5","2SA","24","5","5","Kinaig ka Yordan kule pakarka Aroer tumbraŋ pronaig. Tumbraŋ ta Gad ma tugu mbolŋge ma gutoŋŋge minit. Taŋamba nane tumbraŋ ta kusremba kinaig ka Yaser tumbraŋ pronaig sulumba ");
INSERT INTO ssd_vpl VALUES ("S224_6","011_24_6","2SA","24","6","6","Yaser kusremba kinaig ka Gilead ma tugu mbol kumba ka Kades tumbraŋ pronaig. Tumbraŋ ta Hit mbal tuku kilke mbolŋge minit. Taŋamba nane maŋ tiŋga kumba ka Dan ma tugu mbol promba kinaig ka Sidon tumbraŋ pronaig. ");
INSERT INTO ssd_vpl VALUES ("S224_7","011_24_7","2SA","24","7","7","Pro taŋge nane luka kinaig ka Tirus tumbraŋ pronaig. Tumbraŋ ta fonde kareŋnumbi koranu. Tirus tumbraŋ kusremba kinaig ka Hivi mbal tuku tumbraŋ kame Kanan mbal tuku tumbraŋ kame ta ŋakmba kinaig ka Berseba tumbraŋ Yuda ma tugu mbol pronaig. ");
INSERT INTO ssd_vpl VALUES ("S224_8","011_24_8","2SA","24","8","8","Nane ka ma tugu ŋakmba mbol kumba piro ke sugluka tambun 9 ait 20 kinaig le maŋ luka Yerusalem pronaig. ");
INSERT INTO ssd_vpl VALUES ("S224_9","011_24_9","2SA","24","9","9","Taŋamba Yoab ndek gabat suŋgo tugum kina sulumba sana: Israel mbal taŋgo 800,000 nane ne tuku kame taŋgo pirokam kumuŋ. Yuda mbal taŋgo 500,000 nane ne tuku kame kuasmbi pironu kumuŋ ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S224_10","011_24_10","2SA","24","10","10","Kile David nu wam kina ta tuku wamdus pitina le nu ndek Suŋgo yabaŋmba sana: O Suŋgo, ye ŋginŋgan maŋau kumba siŋka uneken. Ne ye tuku une ta sauka gilaiŋga ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S224_11","011_24_11","2SA","24","11","12","Taŋakina le Suŋgo ndek David tuku tuan taŋgo Gad wam pagumba sana: Ne ka teŋenmba David sawa. Suŋgo nu piti sugo keŋmba ne tanmbim iduste ta ne ismba inum pilemba madiwa ŋga sawa. Nu inum madiwa ta ye taŋamba kamŋgit ŋga Gad sana. ");
INSERT INTO ssd_vpl VALUES ("S224_13","011_24_13","2SA","24","13","13","Mafena le David nu aboŋgina le Gad nu tugum promba pasa ta ŋakmba David kubeu tumba sana: Suŋgo nu piti sugo keŋmba ne tanmbim iduste ta ne ta tuku inum madiwa. Ne kilke tugu te mbol guba suŋgo yar 7 minwa ŋga madiwamŋgat e? Ko naŋe ŋgueu mbalŋge kamembi yokernuwaig le tambun keŋmba kua ka ma baknu mbolŋge kuirka minamŋgat e? Ko guaze suŋgo ait keŋmba Israel taŋgo pino bale farwa ŋga idusmba madiwamŋgat e? Ne wamdus pile timba piti sugo keŋmba te tuku inum madiwa le ye ka Suŋgo sawi ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S224_14","011_24_14","2SA","24","14","14","Taŋakina le David ndek Gad sana: Ye wamdus matuk tukulka piti suŋgoyate. Suŋgo nu sine make patikate tuku tukunu nuŋe wamdus ndaŋmba kam idusmba ndeta kuwa ta ye ŋgueu mbal pro kamembi yokeryam wam ta ndo ye mbulit ŋga Gad sana. ");
INSERT INTO ssd_vpl VALUES ("S224_15","011_24_15","2SA","24","15","15","Kile Suŋgo nu guaze suŋgo ande pilna le Israel ma tugu ŋakmba kumuŋgina. Israel taŋgo guazembi bale farna ta ulendika 70,000. ");
INSERT INTO ssd_vpl VALUES ("S224_16","011_24_16","2SA","24","16","16","Suŋgo tuku eŋel guaze tambi taŋgo pino bale farkam tuku piro tuna ta nu buk Yerusalem mbal ŋaigo siglikam bafuna le Suŋgo nu wamdus te-ibeŋna sulumba eŋel peuna. Peuna le eŋel nu Yebusnu taŋgo Arauna tuku kilke tugumŋge tiŋgina. ");
INSERT INTO ssd_vpl VALUES ("S224_17","011_24_17","2SA","24","17","17","David ndek mambilmba eŋel taŋgo pino bale farmba minna le kaŋgerna sulumba nu Suŋgo sana: Mbar te ye tuku. Yeŋge mbar te ken. Taŋgo kame sinamanzerok te tuku mbar kuga. Piti te ye mbolŋge yiŋe ndare mbolŋge prowa ta maye ŋga Suŋgo sana le ");
INSERT INTO ssd_vpl VALUES ("S224_18","011_24_18","2SA","24","18","18","ki ait ndui ta mbolŋge ndo Gad nu David tugum kumba sana: Ne kaye ka Arauna tuku kilke mbolŋge ndame turŋaŋga Suŋgo atraukam tuku pa laŋlaŋ ande wakeiwa ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("S224_19","011_24_19","2SA","24","19","19","nu ndek Suŋgo tuku pasa ta dubimba kumba ka Gad nu sana taŋamba ndo kina. ");
INSERT INTO ssd_vpl VALUES ("S224_20","011_24_20","2SA","24","20","20","Kile Arauna mambilna kande gabat suŋgo nuŋe piro mbal ndoŋ nu sota pronaig le kaŋgerkina sulumba nu David tumailamŋge dagol tidroŋga loka ");
INSERT INTO ssd_vpl VALUES ("S224_21","011_24_21","2SA","24","21","21","kusnana: O gabat suŋgo, ne ndaŋam ye tugum te prote ŋgina le nu lafumba sana: Ye ne tuku kilke te piyawam prowet. Piyamba guaze suŋgo prote te kugawa ŋga Suŋgo atraukam tuku pa laŋlaŋ ande wakeiwamŋgit ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("S224_22","011_24_22","2SA","24","22","22","Taŋaka sana le Arauna ndek David sana: O gabat suŋgo, kilke te ne ake ta sulumba Suŋgo atraukam tuku sakate taŋamba ka. Ye tuku makau minig te kila sulumba makau tuku pirokanu suku agaŋ ndende te turmba kilmba fetfetmba Suŋgo atraukam tuku pa dikŋga ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("S224_23","011_24_23","2SA","24","23","23","nu nuŋe agaŋ ndende ta ŋakmba kilmba David kile-tumba sana: Naŋe Mbara Suŋgo nu ne tuku atrau tuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("S224_24","011_24_24","2SA","24","24","24","Taŋakina le David ndek lafumba sana: Kuga. Ye agaŋ ndende ta ŋakmba ndametiŋmbi piyawamŋgit. Ye agaŋ inum ake yainumba yiŋe Mbara Suŋgo atrauke nda ŋga sana. Taŋaka sana sulumba nu kilke makau kilna ta ulendimba silwa ndametiŋ soŋ 5-mbi piyana. ");
INSERT INTO ssd_vpl VALUES ("S224_25","011_24_25","2SA","24","25","25","Taŋamba nu ndame kilmba turŋaŋga pa laŋlaŋ wakeimba makau afu bale farmba pasokina le ugnaig. Taŋamba maŋ Suŋgo ndoŋ wamdus ulendikam tuku makau afu ta kilmba pasokina le ugnaig le Suŋgoŋge guaze suŋgo Israel ŋgamukŋge minna ta pitaimba tukulna le kugana. ");
INSERT INTO ssd_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","O Kuate, kume pur maŋau ta ne tugu. Ne sine make patikate wam ta mata suŋgokanu. Ta tuku ne ye mapeyumba ye tuku une ŋakmba sauka kile-sika. ");
INSERT INTO ssd_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Ne ye tuku mbar maŋau ŋakmba sauka gilaiŋga le ye ne am mbolŋge tiŋreknu purfeŋnu mayok ka. ");
INSERT INTO ssd_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Ye siŋka mbaren sulumba une maŋau ken. Wam ta ye mara mindek idusmba minet. ");
INSERT INTO ssd_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Ye ne am mbolŋge mbaren. Mbar ta ne kumammba ken. Ta tuku ne kumumbi ye tumba pasa mbolŋge pilit. ");
INSERT INTO ssd_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Ye inaŋge te-pile ndakina ait ta ye une ŋak minen. Nu ye te-pilna le ye mbar maŋau kam tuku ndo mayok kan. ");
INSERT INTO ssd_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Ye maŋau purfeŋnu tugusek ndo dubiki ŋga ne wamdus suŋgo ŋak minit. Ta tuku ne wamdus kuyar mayenumbi ye sinzaŋya. ");
INSERT INTO ssd_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ne ye tuku une ta ŋakmba sauka kile-sika. Taŋawa le ye ne am mbolŋge purfeŋnu ndo mayok ka. ");
INSERT INTO ssd_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","9","Ne ye piti suŋgo sina le ye tuku saŋgri ŋakmba kuganaig. Ne ye tuku mbar maŋau ta kile-sikumba ye tuku une ta nduiye gilaiŋga. Taŋamba ne naŋe gare maŋau ta ye sa le ye maŋ gare-gareki. ");
INSERT INTO ssd_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","O Kuate, ne ye tuku ŋgamuŋgal purfeu sera sulumba ye tuku wamdus te-tiwe sa le ye ne ndo dubinam idusi. ");
INSERT INTO ssd_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Ne ye pitai ndayumba naŋe Tukul Guwa mata ye yai ndaya. ");
INSERT INTO ssd_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","O buk ne ye te-luka tina le ye gareyina. Taŋamba ndo ne naŋe gare maŋau ta sa le ye maŋ gare-gareki. Ye mara mindek ne ndo dubinam tuku wamdus tambi sinzaŋya. ");
INSERT INTO ssd_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Taŋawa le ye une ŋak mbal ne tuku wam tugusek ta tumniŋgi le nane mbilka ne dubinamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","O Kuate, ye ndare kutuwen ta idusmba ne ye kasuryumba pasa mbol pile ndaka. Ne ye mapeyumba ye te-luka ta le ye ne tuku maŋau tiŋreknu ta idusmba mune-munekamŋgit. ");
INSERT INTO ssd_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","O Suŋgo, ne ye sinzaŋya le ye maŋ yiŋe miŋgembi ne tuku nyu te-duŋgi. ");
INSERT INTO ssd_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Ye ne tuku atrauka agaŋmor kilmba bale farmba pasoki le ugwaig ta ne nzali ndanate. ");
INSERT INTO ssd_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","O Kuate, ye tuku atrau agaŋ ta ye yiŋe nyu te-ibeŋmba ne kumnemŋge mini ta ne nzalinate. Ye ŋgamuŋgal biye mbilmba ne tugum prowi ta ne ye pitaiye nda. ");
INSERT INTO ssd_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Ne Yerusalem fonde kareŋnumbi te-kormba naŋe nzali dubimba Sion mbal sinzaŋniŋga le nane mine magewaig. ");
INSERT INTO ssd_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Taŋamba nane tukul dubimba makau pailnu kilmba ne tuku atrauka agaŋmor ta bale farmba pasoka ugwaig le ne gare-garekamŋgat. ");
INSERT INTO ssd_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Mara ande Suŋgo nu Amitai kiŋo nuŋe Yona wam pagumba sana: ");
INSERT INTO ssd_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Ne tiŋga Nineve tumbraŋ suŋgo ta kaye sulumba riroŋ pasa niŋga. Ye nane tuku wam ŋaigonu suŋgomba ke likade ta ye kaŋgerket ŋgina. ");
INSERT INTO ssd_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Taŋakina le Yona nu Suŋgo ram kua ka Spen kilke mbol kambim bafuna sulumba kile nu tiŋga Yafo tumbraŋ fudiŋ ta mbol kina ka taŋge waŋ ande Spen kambim bafuna ta te-silikina sulumba Suŋgo ram kua ka waŋ ta piyamba poŋga kinaig. ");
INSERT INTO ssd_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Nane kinaig le kile Suŋgoŋge bubre saŋgrinu yu mbolŋge pilna le prona. Bubre saŋgrinu taŋge waŋ tumba sambriwa le fofokam bafuna le ");
INSERT INTO ssd_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","waŋ kulatkanu taŋgo kame nane wamdus fulilka kuru kuru mayemba naŋgine mbara yimyam wike likinaig sulumba nane waŋ piti suŋgo tina ta bulkuwa ŋga agaŋ ndende afu waŋ mbolŋge paska kilmba yu mbol pankinaig ta Yona nu katese ndana. Nu waŋ sinam nziŋge kinymba gilaiŋgina. ");
INSERT INTO ssd_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Kile waŋ ta tuku gabat Yona te-silika kuanemba sana: Ne ndaŋam tuku kinymba minit? Ne tiŋgumba naŋe mbara wika le nu sine sinasiŋmba tursiŋguwa le sine ŋgisi ndakube ŋgina. ");
INSERT INTO ssd_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Taŋakina le waŋ kulatkanu taŋgo kame nane naŋgine naŋgine sakinaig: Sine kagmaika taŋgo ande tuku nyu mayok kuwa ndeta nuŋge mbarna le sine ŋgisikam bafuweg te kila palmbimŋgig ŋginaig. Nane taŋamba kagmaikinaig kande Yona tuku nyu mayok kina. ");
INSERT INTO ssd_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Taŋana le nane nu sanaig: Sine piti suŋgo teg te tugunu te-mayokmba sasiŋga le sine isbe. Ne ame piro ŋak? Ne anikok? Ne kilke tugu ndaŋ tuku kuasmbi ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Yona ndek nane tuku pasa lafumba saniŋgina: Ye Hibrunu. Ye Suŋgo tuku nyu kurauket tuku. Nu samba mbolok Mbara. Nuŋge yu kilke turmba kile-mayokkina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Taŋakina sulumba Yona nu Suŋgo ram kua kina ta kubeu niŋgina le waŋ kulatkanu taŋgo kame nane ismba kuru kuru suŋgo tinaig sulumba Yona sanaig: i ... Ne siŋka mbar suŋgona ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Bubre kile saŋgri tiŋgina le yu mbalo sugo sugo tiŋginaig le waŋ kulat taŋgo nane ndek sakinaig: Sine ne mbolŋge ndaŋbe le yu mukuwa le sine mine mayewamŋgig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Yona nu ndek saniŋgina: Ye tumba yu mbol bukŋgap le yu mukuwamŋgat. Yeŋge mbaren le yu mbalo sugo sugo te tiŋgade le tane piti tade ŋgina. ");
INSERT INTO ssd_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Taŋakina le nane waŋ kulat taŋgo waŋ tumba makembi kambim bafumba nane saŋgri tiŋga koikinaig. Koikinaig ta yu saŋgri tiŋgina le nane waŋ tumba piyal kambim fugumba ");
INSERT INTO ssd_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Suŋgo wika sanaig: O Suŋgo, sine taŋgo te tumba yu mbol bukŋgube le nu kumwa le ne sine pasa mbolŋge patika le ma ŋayo mbolŋge ŋgisi ndakube. O Suŋgo, ne naŋe nzali ndo dubimba wam te kate ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Taŋakinaig sulumba nane Yona tumba yu mbol bukŋginaig le yu ndek mukuna. ");
INSERT INTO ssd_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Yu mukuna le taŋgo kame ta Suŋgo tuku kuru kuru suŋgo tumba agaŋmor ande balemba Suŋgo atraukinaig sulumba nu tuku pasa saŋgri pilenaig. ");
INSERT INTO ssd_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Yona tumba yu mbol bukŋginaig le Suŋgo nu kualegaŋ suŋgo ande sana le nu promba Yona tumba ŋinkina. Ŋinkina le Yona nu mara keŋmba furir keŋmba kualegaŋ fuŋgul sinam taŋge minna. ");
INSERT INTO ssd_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Yona nu kualegaŋ fuŋgul sinamŋge minmba nuŋe Mbara Suŋgo gare pasa tumba sakina: ");
INSERT INTO ssd_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","O Suŋgo, ye piti suŋgo kurawit sulumba ne wikit le ne ye turyat. Ma ŋayonu kumanu mbal tuku ma mbolŋge minit sulumba ye ne tuku wi kueŋkit le ne isat. ");
INSERT INTO ssd_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Neŋge ye bukŋgat le ye yu buto sinam nzi kat. Yuŋge ye soŋgat le yu mbalo sugo sugo ye mbolŋge ŋgurkaig le ");
INSERT INTO ssd_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","ye sakit: Ne ye pitaiyat. Ne tuku tukul wande ta ye maŋ kaŋgere nda ŋga sakit. ");
INSERT INTO ssd_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Yu mbalo ye mbolŋge ŋgurmba minaig le ye tuku mabseŋ tukulkat le yuŋge ye ŋak soŋgat. Yu sinamok aŋgaŋge ye tuku gabat soŋgat. ");
INSERT INTO ssd_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ye yu sinamŋge tabe minig ta tugunu tugum nzi kat. Ma ta ŋayonu ndo ye tukulyat ta o Kuate Suŋgo, ne ye maŋ luka te-mayokyat le ma ŋayonu ta kusrewit. ");
INSERT INTO ssd_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","O Suŋgo, ye kumam tuku kamusit sulumba ye ne idusnumba yabaŋnit le ne samba mbolŋge naŋe tukul wande sinamŋge ne isat. ");
INSERT INTO ssd_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Nane afu yabri mbara dubikade ta nane ne kusrenade ta ");
INSERT INTO ssd_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","ye munembi ne tuku nyu te-duŋga ne atraukamŋgit. Ye ne ndoŋ tumamba pasa saŋgri pilewen ta maŋ kamŋgit. O Suŋgo, neŋge ndo sine kile-luka kilit le sine abo ŋak mineg ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Kile Suŋgo nu maŋ kualegaŋ ta sana le kumba ka piyalŋge Yona ŋgilikina le mayok kina. ");
INSERT INTO ssd_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Suŋgo nu maŋ lato Yona wam pagumba sana: ");
INSERT INTO ssd_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","Ne tiŋga Nineve tumbraŋ suŋgo ta kaye sulumba pasa ye ne sanet te kuklimba saka ŋgina. ");
INSERT INTO ssd_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Taŋakina le Yona nu tiŋga Suŋgo tuku miŋge dubimba Nineve kina. Nineve nu tumbraŋ suŋgo pasa ŋak. Taŋgo ande tumbraŋ ta dubimba make inum kumam kambim ŋga ta nu mara keŋnu mbolŋge ta prowanu. ");
INSERT INTO ssd_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Kile Yona nu tugu pilmba tumbraŋ suŋgo ta dubimba kina ka ki butuŋgina le furiram nu wi kueŋka nane saniŋgina: Ait 40 kugawaig le Kuateŋge Nineve tumbraŋ te te-ŋgisiwamŋgat ŋga saniŋgina le ");
INSERT INTO ssd_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ninevenu taŋgo pino nane Kuate tuku pasa ta ismba sonŋga nane ndek sakinaig: Sine ŋakmba nyamagaŋ pinka taŋgo nyu ŋak taŋgo nyu kugatok sine ŋakmba ŋgamuŋgal biye mbilmba sinamanzer tawi tiŋbe ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Kile Nineve tuku gabat suŋgo ta pasa ta ismba nuŋe minyokam mbili suŋgo maditaknu ta kusremba nuŋe mindepiye mayenu ta paska pilmba sinamanzer tawi tiŋmba kuke tugu sinamŋge minyok minna. ");
INSERT INTO ssd_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Taŋamba nu taŋgo afu kukulniŋgina le nane kumba ka Ninevenu taŋgo pino ŋakmba wam paguka saniŋginaig: Siŋgine gabat suŋgo nuŋe gabat kame ndoŋ nane teŋenmba sakaig. Tane taŋgo pino agaŋmor ŋakmba nyamagaŋ kule pinka ndanyap. ");
INSERT INTO ssd_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Tane ŋakmba agaŋmor turmba sinamanzer tawi tiŋmba tane Kuate wika yabaŋap sulumba taŋgine wam ŋaigonu ta ŋakmba kusreka mine maŋau ŋaigonu ke likade ta turmba ŋakmba kusrekap. ");
INSERT INTO ssd_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Sine taŋabe le Kuate nu sine tuku gubra suŋgo pilit ta wamdus mbilmba kusrewa le sine ŋgisike nda. Gabat sugo sugo nane taŋakaig ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Kile Nineve mbal nane wam ŋaigonu ŋakmba kusrekinaig le Kuate nu wam kinaig ta kaŋgerka nane tuku gubra suŋgo tina ta wamdus biye mbilna sulumba nu nane kile-ŋgisikam sakina ta ke ndakina. ");
INSERT INTO ssd_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Yona nu wam ta tuku ŋgamuŋgal ŋayoŋga nu gubra tina sulumba ");
INSERT INTO ssd_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","nu Suŋgo yabaŋmba sana: O Suŋgo, ye yiŋe tumbraŋŋge minmba ne Nineve tumbraŋ ŋgisiwe nda ta o buk katesewen. Ta tuku ye kua ka Spen kambim bafuwen. Ne sine sinasiŋmba mapekate tuku Mbara ta ye kila. Ne pitik gubra ndanate tuku. Ne sine tuku kume purte tuku. Ne wamdus biye mbilmba taŋgo tuku mbar ne lafu ndate. ");
INSERT INTO ssd_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","O Suŋgo, ne ye baleya. Ye abo minam mbulit. Ye kumi ko ŋgina le ");
INSERT INTO ssd_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Suŋgo nu ndek sana: Ne gubranate wam ta kumumbi e ŋgina. ");
INSERT INTO ssd_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Kile Yona nu tumbraŋ suŋgo ta kusremba kumba ka ki prote kumamŋge minyokina. Nu baibai ande nzaŋnu pilmba ta kumnemŋge minyok minmba ame wam tumbraŋ suŋgo ta mbolŋge prowamŋgat ŋga tairŋga minna. ");
INSERT INTO ssd_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Taŋana le Yona kiŋge piyikat ŋga Kuate Suŋgoŋge ail ande te-mayokna le ail ta suŋgoka nzaŋnuŋge nu kaina. Yona nu ŋgamuŋgal ŋayoŋgina ta kusrewa ŋga taŋana le Yona nu ail ta kaŋgermba gare suŋgo tina. ");
INSERT INTO ssd_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Mafena le maratukuk Kuate nu ŋguakile ande kukulna le promba ail sumbailnu ta nye fofona le ail ta kummba kareŋgina. ");
INSERT INTO ssd_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Kile ki pro saŋgri tiŋgina le Kuate nu bubre paknu ki prote kumamŋge pilna le prona. Kiŋge Yona gabatnu piyna le nu am purmba ndeke dirna sulumba sakina: Ye abo minam mbulit. Ye kumi ko ŋgina le ");
INSERT INTO ssd_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Kuate nu Yona sana: Ail te kummba kareŋgat le ne gubranate wam ta kumumbi e ŋgina le nu ndek sakina: Au. Ye kumumbi gubrayate. Ye gubra tet ta dubimba kumi ta maye ŋgina. ");
INSERT INTO ssd_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Taŋakina le Suŋgo nu Yona sana: Furir ndindo mbolŋge ail te promba suŋgokat. Furir ande mbolŋge nu kummba kareŋgat. Ne ta tuku piro kareŋ ndakat. Neŋge nu te-suŋgo ndawat. Ndaŋam tuku ne ail ta tuku ninankate? ");
INSERT INTO ssd_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ye mata taŋamba ndo Nineve tumbraŋ tuku sina suŋgoyate le mapewet. Tumbraŋ suŋgo ta kiŋo kame foŋfoŋ gudommba 120,000 ta lite. Nane mbar kugatok. Agaŋmor mata gudommba minig ŋga Yona sana. Tuan taŋgo suŋgomba Israel mbal Yuda mbal riroŋ pasa niŋganu kande nane ismba nda isanu sukmba yabri mbara kanunu mbariŋniŋmba minanu. Taŋawanu le Kuate nu Babilon gabat suŋgo Nebukadnesar wamdus tuna le nu pro nane ndoŋ kame bumba kusem wande suŋgo Solomonŋge te-tina ta turmba ŋayo silimba Israel mbal Yuda mbal ŋakmba muliŋ kilmba Babilon kilke mbol kinaig. (Aposel 7.42-43 kaŋgerap). Israel mbal nane Babilon kilke mbolŋge minnaig ma ma yar 70 kinaig le Daniel tuku ait mbolŋge Suŋgoŋge Babilon gabat suŋgo kitek Darius wamdus tuna le nane mapekina le nane luka Israel kilke mbol kinaig sulumba kusem wande kitek ande maŋ te-tinaig. Taŋamba minnaig ma ma nane tuan taŋgo kame tuku dir pasa kame ta idusniŋmba Kuate nu Mesias nyunu ande Kristus kukulwa ŋga nu tairŋga minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesus Kristus nu David le Abraham tuku mbuŋ. Nu tuku mbuŋ Abraham tuku ndare tuturmba teŋenmba kina. ");
INSERT INTO ssd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham tuku kiŋo nuŋe Isak. Isak tuku kiŋo nuŋe Yakob. Yakob tuku kiŋo kame 12 ande Yuda. ");
INSERT INTO ssd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda tuku kiŋo kat nuŋe Peres le Sera. (Ina nakile Tamar). Peres tuku kiŋo nuŋe Hesron. Hesron tuku kiŋo nuŋe Ram. ");
INSERT INTO ssd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram tuku kiŋo nuŋe Aminadab. Aminadab tuku kiŋo nuŋe Nason. Nason tuku kiŋo nuŋe Salmon. ");
INSERT INTO ssd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon tuku kiŋo nuŋe Boas. (Boas ina nuŋe Rahab). Boas tuku kiŋo nuŋe Obed. (Obed ina nuŋe Rut). Obed tuku kiŋo nuŋe Yesi. ");
INSERT INTO ssd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi tuku kiŋo nuŋe David nu gabat suŋgo. David tuku kiŋo nuŋe Solomon. (Ina nuŋe Uria tuku pino kuembol Davidŋge tina). ");
INSERT INTO ssd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon tuku kiŋo nuŋe Rehoboam. Rehoboam tuku kiŋo nuŋe Abia. Abia tuku kiŋo nuŋe Asa. ");
INSERT INTO ssd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa tuku kiŋo nuŋe Yehosafat. Yehosafat tuku kiŋo nuŋe Yehoram. Yehoram tuku kiŋo nuŋe Usia. ");
INSERT INTO ssd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia tuku kiŋo nuŋe Yotam. Yotam tuku kiŋo nuŋe Ahas. Ahas tuku kiŋo nuŋe Hesekia. ");
INSERT INTO ssd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia tuku kiŋo nuŋe Manase. Manase tuku kiŋo nuŋe Amon. Amon tuku kiŋo nuŋe Yosia. ");
INSERT INTO ssd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia tuku kiŋo gudommba ande Yehoyakin. Ait ta mbolŋge nane Israel mbal muliŋ kilanu taŋaŋ Babilon kilke mbol kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kinaig ka Babilonŋge minnaig sulumba Yehoyakin nu Sealtiel te-pilna. Sealtiel tuku kiŋo nuŋe Serubabel. ");
INSERT INTO ssd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel tuku kiŋo nuŋe Abihud. Abihud tuku kiŋo nuŋe Eliakim. Eliakim tuku kiŋo nuŋe Asor. ");
INSERT INTO ssd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor tuku kiŋo nuŋe Sadok. Sadok tuku kiŋo nuŋe Akim. Akim tuku kiŋo nuŋe Eliud. ");
INSERT INTO ssd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud tuku kiŋo nuŋe Eleasar. Eleasar tuku kiŋo nuŋe Matan. Matan tuku kiŋo nuŋe Yakob. ");
INSERT INTO ssd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob tuku kiŋo nuŋe Yosef. Piyo nuŋe Maria. Maria nu Yesus te-pilna. Yesus nyunu ande Kristus. ");
INSERT INTO ssd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Taŋamba Abraham tuku ait kusremba nuŋe ndare tuturmba ka kuasmbi 14 mayok kinaig le David prona. David tuku ait kusremba nuŋe ndare tuturmba ka kuasmbi 14 mayok kinaig sulumba muliŋ kilanu taŋaŋ Babilon kinaig. Babilonŋge minnaig ait ta kusremba ndare tuturmba ka kuasmbi 14 mayok kinaig le Kristus prona. ");
INSERT INTO ssd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesus Kristus nu ina nuŋeŋge te-pilna ta teŋenmba. Ina nuŋe Maria. Maria nu Yosef tam tuku madinaig. Nale muŋgu kile ndaka minmba Maria nu buk Tukul Guwa tuku saŋgrimbi kiŋo konmba fuŋgul te-mayokna ta katesena. ");
INSERT INTO ssd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosef nu tam tuku madinaig ta nu wamdus tiŋreknu ŋak tukunu Maria kiko tikat ŋga nu siŋsiŋndo kusrewam tuku idusna. ");
INSERT INTO ssd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Taŋamba wamdus teroka minmba nu kiŋambi Suŋgo tuku eŋel ande pro nu sana: David tuku mbuŋ Yosef, ne piyo naŋe Maria tam tuku wamdus piti ndanuwa. Ne nu ta. Nu kiŋo konna ta Tukul Guwa tuku saŋgri mbolŋge nu kile fuŋgulok minit. ");
INSERT INTO ssd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nu kiŋo te-palmbimŋgat ta nyunu Yesus ŋga. Israel mbal une maŋauŋge nane tidoŋgate ta nuŋge nane tuku muskil kile-tidiŋge niŋgamŋgat ŋga Yosef sana. ");
INSERT INTO ssd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Wam ŋakmba mayok kine likinaig ta Suŋgo tuku pasa ande tuan taŋgoŋge te-mayokna ta kumuŋgina. Nu teŋenmba kuyarna. ");
INSERT INTO ssd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tane isap. Pino mbanzo ande nu taŋgo ndoŋ mine ndakanu minmba ma ma fuŋgulok minwa sulumba nu kiŋo te-palmbimŋgat. Kiŋo ta nu tuku nyu Emanuel ŋgina. Emanuel pasa ta tugunu: Kuate nu sine ndoŋ minit. ");
INSERT INTO ssd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosef nu kinyna tuku aboŋga Suŋgo tuku eŋel pasa sana ta kumumba nu Maria nuŋe pinonu tina. ");
INSERT INTO ssd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nu tina ta nu ndoŋ kinye ndakinaik sulumba kumba ka nu kiŋo te-pilna. Nu kiŋo te-pilna le Yosef nu tuku nyu Yesus ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodus nu gabat suŋgo minna ait mbolŋge Yudea ma tugu Betlehem tumbraŋŋge Yesus ina nuŋeŋge te-pilna. Te-pilna le ki prote kumamŋge kila mbal afu mbai kitek kaŋgermba Yerusalem tumbraŋ suŋgo mbol pronaig sulumba kusnaŋginaig: ");
INSERT INTO ssd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Zu mbal tuku gabat suŋgo ina nuŋeŋge te-pilna ta aniŋge minit. Nu mayok kina ta tumsiŋgam tuku mbai ki prote kumamŋge kaŋgergeŋ sulumba sine nu mbariŋam proweg ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mandor Herodus Yerusalem mbal ŋakmba wam ta ismba wamdus pitiniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Taŋanaig sulumba Herodus nu pris gabat mbal kusem pasa tugunu bitekŋganu mbal ŋakmba wike lika kile-maŋgurka kusnaniŋgina: Kuateŋge madina taŋgo Kristus ina nuŋeŋge nu aniŋge te-palmbimŋgat ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","nane lafumba nu sanaig: Yudea ma tugu Betlehem tumbraŋŋge. Kuate tuku tuan taŋgo teŋenmba kuyarna. ");
INSERT INTO ssd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Betlehem tumbraŋ fudiŋndo Yudea ma tugu mbolŋge ne Yudea tumbraŋ ŋakmba ŋgamukŋge nyu suŋgo tamŋgat. Ne sinamŋge taŋgo suŋgo nyu ŋak mayok kuwa sulumba yiŋe mbal Israel kulatkamŋgat. Tuan taŋgo taŋamba kuyarna ŋga Herodus sanaig. ");
INSERT INTO ssd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kile Herodus nu kuirkuirka pasa pilna le kila taŋgo nane nu tugum pronaig le nu nane kusnaniŋgina: Mbai mayok kina ta ait giganmba kusreka ye tugum te prowaig ŋga kusnaniŋgina le nane ait ta kumumba sanaig. ");
INSERT INTO ssd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sanaig le nu nane Betlehem kuwaig ŋga saniŋgina: Tane kape ka kiŋo fudiŋ ta sote mayemba kaŋgerap sulumba luka pro ye sayap le ye mata kumba mbariŋi ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Taŋakina le nane gabat suŋgo tuku pasa ismba tiŋga kinaig. Kinaig le mbai buk ki prowanu kumamŋge kaŋgernaig ta mayok ka nane tumailamŋge kina ka kiŋo minna ma ta mbolŋge amtiŋga minna le ");
INSERT INTO ssd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","nane mbai ta kaŋgermba gare tormba ");
INSERT INTO ssd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","kumba ka wande ta sinam kinaig sulumba kiŋo fudiŋ ina nuŋe Maria ndoŋ kaŋgerka kiŋo tugumŋge dagol tidroŋga nu mbariŋnaig. Mbariŋnaig sulumba gol, minde sili soŋ mundur mayenu ŋak, gureŋ mayenu nyunu mer ta palekŋge paska nu tuku patikinaig. ");
INSERT INTO ssd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Taŋamba nane maŋ luka kambim ŋga furir ta nane kiŋambi Kuate nu nane riroŋ pasa saniŋgina le nane Herodus tugum kine ndaka ndin kise tumba naŋgine tumbraŋ kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kila mbal luka kinaig le Yosef nu kiŋata Suŋgo tuku eŋel pro nu sana: Herodus nu kiŋo fudiŋ te balewam tuku nu sotam bafute. Ne pino kiŋo fudiŋ te kilmba kua ka Isip kilke mbol kaye sulumba taŋge ye tuku pasa tairŋga ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Taŋakina le furir ta ndo Yosef nu pino kiŋo kilmba kua ka Isip kina. ");
INSERT INTO ssd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kinaig ka taŋge minnaig ma ma Herodus nu kumna. Wam mayok kina ta Suŋgo tuku pasa ande tuan taŋgoŋge te-mayokna ta kumuŋgina. Nu teŋenmba sakina. Yiŋe Kiŋo nu Isipŋge minna le prowam tuku ye nu wiken ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodus nu kila mbal nu yabrimba laipmba kinaig le katesemba gubra kagli firka ndek nuŋe kame mbal kukulniŋgina le Betlehemŋge, Betlehem makembiŋge kiŋo kame yar armba kusrekanu afu ŋgumnemŋge mayok kanu ta ŋakmba bale far sulunaig. Herodus nu buk kila mbal kusnaniŋgina le mbai mayok kina tuku ait ta sanaig le isna. Ait ta idusmba nu taŋana. ");
INSERT INTO ssd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wam mayok kina ta tuan taŋgo Yeremia tuku pasa sakina ta kumuŋgina. Nu teŋenmba kuyarna. ");
INSERT INTO ssd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rama tumbraŋŋge malmbi suŋgo ŋgamuŋgal ŋayo tuku zigna mayok kaŋgat. Rahel nu nuŋe kiŋo kame tuku malmbikamŋgat. Nu tuku kiŋo ande mine nda. Wam ta tuku nane nu tuku ŋgamuŋgal rar ta te-ibeŋam kumuŋ kuga ŋga sakina. ");
INSERT INTO ssd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodus nu kumna le Yosef nu Isipŋge minmba kiŋambi Suŋgo tuku eŋel ande nu tugum promba sana: ");
INSERT INTO ssd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ne pino kiŋo kilmba luka Israel kilke mbol kaye. Taŋgo nu kiŋo te balewam sakina ta nu buk kumna ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Taŋakina le Yosef nu pino kiŋo kilmba maŋ luka Israel kilke mbol pronaig. ");
INSERT INTO ssd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Promba Herodus tuku kiŋo nuŋe Arkelaus nu mam nuŋe tuku ma tumba Yudea tuku gabat minna le Yosef nu ismba kuru-kurukina. Nu kuru-kuruka minmba nu kiŋata riroŋ pasa ande isna sulumba nu Yudea kusremba Galilea ma tugu mbol kina ka ");
INSERT INTO ssd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nasaret tumbraŋŋge minnaig. Taŋamba tuan taŋgo kame nane Kuateŋge madina taŋgo nu Nasaretnu taŋgo ŋginaig ta kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ait ta mbolŋge Yohanus kule pisne taŋgo nu promba Yudea ma baknu mbolŋge pasa kuklimba teŋenmba saka minna: ");
INSERT INTO ssd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kuate nu nuŋe gageu kulatkam tuku ait buk patukate. Tane ŋgamuŋgal biye mbilmba maŋau ŋaigonu kusrekap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tuan taŋgo Aisaia nu ande tuku sakina ta nu Yohanus tuku sakina. Nu teŋenmba kuyarna. Ma baknu mbolŋge wi ande kueŋka teŋenmba sakate. Suŋgo tuku ndin wakeimba kuanekap. Nu likam tuku ndin te-tiwap ŋgate. ");
INSERT INTO ssd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanus nu kamel ŋguenu ŋak tawi silika let tiŋgina. Nu tuku nyamagaŋ ta kasbur wak le ŋguimzaŋ kulenu. Nu agaŋ ta nyumba minanu. ");
INSERT INTO ssd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yudea tumbraŋ yimyam Yerusalem tumbraŋ suŋgo Yordan kule patukŋge tumbraŋ mine likinaig ta ŋakmba Yohanus tugum prowe likinaig. Nane naŋgine une maŋau kile-mayokke likinaig le ");
INSERT INTO ssd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","nu ndek Yordan kule mbolŋge nane kule pisneniŋmba minna. ");
INSERT INTO ssd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Farisi mbal Sadusi mbal nane gudommba kule pisneniŋguwa ŋga nu tugum pronaig le nu nane saniŋgina: Tane mbeŋ tuku fat Kuate tuku pa tam tuku minig. Tane imaŋge riroŋ pasa satiŋgat le pa ta laiptiŋguwa ŋga kule pisne tam prode. ");
INSERT INTO ssd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tane siŋka ŋgamuŋgal biye mbilmba taŋgine maŋau ŋaigonu kusrekinaig ndeta alonu kumumbi kile-mayokkap le kaŋgerkube. ");
INSERT INTO ssd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tane Abraham nu sine tuku mbuŋ ŋga payam ndakap. Ye tane kilimok satiŋget. Kuate nu tane pitaika ndame kame tembi Abraham tuku ndare kitek kile-mayokkam kumuŋ. ");
INSERT INTO ssd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kuate nu sapor ail tugunu tugumŋge pilna le minit. Ail afu alo mage ndade ta ŋakmba pike lika pankate le pa mbol kinig. ");
INSERT INTO ssd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tane ŋgamuŋgal biye mbilmba maŋau ŋaigonu kusrekade ta ye tane kulembi kule pisnetiŋget. Ande ye ŋgumnemŋge prowamŋgat ta nu ye tuku saŋgri lite. Ye taŋgo mayenu kuga. Ye nu tugumŋge nu tuku kupe ŋgaro kugrakam wam ŋai ta mata nu mbolŋge kam kumuŋ kuga. Nu Tukul Guwambi pambi tane tuku ŋgamuŋgal kule pisne taŋaŋ tiŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nu wit pileŋgam bafute. Nu pro wit mbain mbolŋge minig ta silimba bareŋmba alonu kilmba nuŋe nyamagaŋ wande mbolŋge patikamŋgat. Nu tiglu kilmba pa mbolŋge kutuwa le ugmba minmba minamŋgat. Pa ta kupe nda ŋga nane saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesus nu Galilea ma kusremba kumba ka Yohanusŋge nu kule pisnewa ŋga Yordan kule mbol ta prona sulumba ");
INSERT INTO ssd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yohanus sana le nu ndek peuwam bafumba sakina: Ye taŋgo mayenu kuga. Yeŋge ne kule pisnenam kumuŋ kuga. Neŋge ye kule pisneya ta maye ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Taŋakina le nu lafumba sana: Ne mbule ndaka. Kuateŋge maŋau dubikam tuku tumsiŋgit ta sine kusrekam kumuŋ kuga ŋgina. Taŋakina le Yohanus nu woka Yesus kule pisnena. ");
INSERT INTO ssd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nu kule silika bitekŋgina le samba talkina le Kuate tuku Guwa gami taŋaŋ ndeka nu mbolŋge minyokina le Yohanus nu kaŋgerna. ");
INSERT INTO ssd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Taŋamba samba mbolŋge pasa ande teŋenmba mayok kina: Ande te yiŋe Kiŋo. Ye nu tuku kume purmba nu tuku gare suŋgo tet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kile Tukul Guwaŋge Yesus wamdus tuna le nu tiŋga Satan nu tagowam tuku ma baknu mbol kina. ");
INSERT INTO ssd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mara 40 taŋaŋ nu taŋge minna sulumba nu agaŋ inum nye ndaka minna. Ait ta kugana le nu guba mayena le ");
INSERT INTO ssd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Satan nu tugum promba sana: Ne Kuate tuku Kiŋo ŋga sakate ta ndame kame te saniŋga le bret kuilkuwaig le ne kilmba nya ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Taŋakina le nu lafumba sana: Kuate tuku kuyar pasa ande teŋenmba sakate. Taŋgo nane bret nyade ta mbolŋge ndo abo minam kumuŋ kuga. Kuate tuku miŋge pasa ŋakmba ta turmba kilmba dubiwaig ŋga sakate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kile Satan nu Yesus tumba kumba ka Yerusalem kusem wande suŋgo funu kuennu ta mbolŋge pilna sulumba sana: ");
INSERT INTO ssd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ne Kuate tuku Kiŋo ŋga sakate ta pateŋga o ibeŋ nzi kaye. Kuyar pasa ande teŋenmba sakate. Kuate nu nuŋe eŋel kame kukulniŋguwa le pro ne kulatkamŋgaig. Ne ndame mbolŋge naŋe kupe daŋŋga fetkikat ŋga nane pro waimbi ne biye-biyenamŋgaig ŋga sakate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Taŋakina le Yesus ndek Satan sana: Kuyar pasa ande mata teŋenmba sakate. Taŋgine Mbara Suŋgo tago ndawap ŋgate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kile Satan nu maŋ Yesus tumba biŋ suŋgo ande mbol kumba ka taŋge kilke te tuku sugo ŋakmba nane tuku saŋgri turmba tummba sana: ");
INSERT INTO ssd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ne ye tugumŋge dagol tidroŋga ye tuku nyu te-duŋga mbariŋya ta ye saŋgri ŋakmba te ne tanmbimŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Taŋakina le nu ndek Satan sana: Kuyar ande teŋenmba minit. Taŋgine Mbara Suŋgo tuku nyu te-duŋga nu mbariŋap. Nu tuku miŋge ndo kumnemŋge minap ŋga sakate ŋgina. Taŋamba nu maŋ sakina: Satan, ne kilmba kua kaye ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Taŋaka sana le Satan nu kusremba kina le Kuate tuku eŋel kame promba Yesus sinzaŋnaig. ");
INSERT INTO ssd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nane Yohanus muliŋtumba wandekŋge pilnaig le Yesus nu ismba nu maŋ luka Galilea ma mbol kina. ");
INSERT INTO ssd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kina ka nuŋe tumbraŋ Nasaret kusremba ka Kaperneum tumbraŋŋge minna. Kaperneum nu Galilea kule kualiŋ tuku piyalŋge minit. Ma ta Sebulan le Naftali tuku kilke. ");
INSERT INTO ssd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesus nu tumbraŋ taŋge minna ta tuan taŋgo Aisaia tuku dir pasa ta kumuŋgina. Nu teŋenmba sakina. ");
INSERT INTO ssd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulan le Naftali tuku kilke Yordan kule make sim yu kumamŋge minit. Kasomok mbal tuku ma tugu Galilea. ");
INSERT INTO ssd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nane ma make suŋgo sinamŋge minig mbal ta bulu suŋgo kaŋgeramŋgaig. Nane ma furir sinamŋge kumanu suk minig ta bulu suŋgo tiŋga nane kilŋaniŋgamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ait ta mbolŋge Yesus nu tugu pilmba pasa kuklimba teŋenmba saka minna: Kuate nu nuŋe gageu kulatkam tuku ait buk patukate. Tane ŋgamuŋgal biye mbilmba maŋau ŋaigonu kusrekap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesus nu Galilea kule kualiŋ make dubimba kumbaŋge nale aba nakile Simon le Andreus ndoŋ kumaŋ bukŋga minnaik le kaŋgerkina. Simon tuku mape nyu inum Petrus. Nale tuku piro ta kualegaŋ kilanu. ");
INSERT INTO ssd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kile Yesus ndek nale sanikina: Tale ye dubiyap le yeŋge tumtiki le taŋamba ndo taŋgo kilamŋgaik ŋga sanikina. ");
INSERT INTO ssd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sanikina le nale pitik ndo tiŋga kumaŋ kusreka Yesus dubimba kinaik. ");
INSERT INTO ssd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesus nu maŋ lika kina ka nale aba nakile Yakobus le Yohanus kaŋgerkina. Nale mam nakile Sebedeus ndoŋ waŋ ande mbolŋge minyoka kumaŋ zailŋga minnaig le nu nale wikina. ");
INSERT INTO ssd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wikina le nale mata pitik ndo tiŋga mam nakile waŋ mbolŋge kusremba Yesus dubimba kinaik. ");
INSERT INTO ssd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus nu Galilea tumbraŋ ŋakmba mbol lika naŋgine kusem wandekŋge pasa tumniŋmba pasa mayenu Kuate nu nuŋe gageu kulatkate wam ta kuklimba minanu. Nu taŋamba lika nane tuku guaze yeki yeki kile-tidiŋganu. ");
INSERT INTO ssd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Taŋamba minna le nu tuku nyu Siria kilke kumuŋgina le nane naŋgine guaze mbal kilmba prowe likinaig. Afu guaze tugu kise kise, afu ŋgaro rar, afu bukla ŋaigonu ŋak, afu zulbarekŋga kumanu sukanu, afu milmailkanu ta ŋakmba kilmba pronaig le nu nane wakeike likina. ");
INSERT INTO ssd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yerusalem tumbraŋ suŋgo, Dekapolis tuku tumbraŋ 10, Galilea le Yudea ma tugu, Yordan kule make sim ta ŋakmba tuku mbal gudommba pro Yesus dubimba likinaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus nu maŋgur suŋgo ta kaŋgerka nu tabe poŋga minyok minna le nuŋe dubinaig mbal nu tugum pronaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nane nu tugum pronaig le nu nane wam paguka saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Tane Kuate am mbolŋge kumuŋ kuga ŋga kamusde mbal tane gare maŋau mbolŋge minap. Tane Kuate tuku ma mbol kambim tuku minig. ");
INSERT INTO ssd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tane ŋgamuŋgal rar tumba malmbika minig mbal tane gare maŋau mbolŋge minap. Kuate nu tane tuku ŋgamuŋgal rar ta bul sertiŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tane ŋgan mukuknu minig mbal tane gare maŋau mbolŋge minap. Tane kilke tugu ŋakmba kulatkam tuku minig. ");
INSERT INTO ssd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tane tiŋreknu mayok kambim tuku dirnaŋga minig mbal tane gare maŋau mbolŋge minap. Kuate nu lafunu kumumbi tiŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tane taŋgo mapekade mbal tane gare maŋau mbolŋge minap. Kuate nu mata tane mapekamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tane ŋgamuŋgal purfeŋnu minig mbal tane gare maŋau mbolŋge minap. Tane Kuate kaŋgeramŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tane taŋgo tuku gubra peuka ŋgamuŋgal mukuk niŋgig mbal tane gare maŋau mbolŋge minap. Tane Kuate tuku kiŋo kame minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tane Kuate dubimba maŋau tiŋreknu ke likade le afuŋge tane piti tiŋgig ta tane gare maŋau mbolŋge minap. Tane Kuate tuku ma mbol kambim tuku minig. ");
INSERT INTO ssd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tane ye tuku mbal minig tukunu afuŋge tane tumail pantiŋmba piti sertiŋmba yabri pasa suŋgombambi ake tulitiŋgig ta tane gare maŋau mbolŋge minap. ");
INSERT INTO ssd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nane taŋawaig kande tane gare torap. Samba mbolŋge tane tuku lafu mayenu minit. O buk nane Kuate tuku tuan taŋgo kilmba piti ndui ta ndo niŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tane sol kaglinu taŋaŋ kilke te mbolok mbal ŋgamukŋge minig. Sol kaglinu kugawa le sine ame agaŋmbi maŋ wakeibe le kaglinu mayok kambim kumuŋ? Kumuŋ kuga. Nu piro kugatok. Nane ake kutumba bareŋguwaig le taŋgo pinoŋge tido-tidoŋga likamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tane sati taŋaŋ kilke te mbolok mbal kilŋaniŋgig le ndin kaŋgerde. Tumbraŋ ande tabe mbolŋge minit ta nu kuirka minam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Taŋgo nane lam bulumba nza kai ndade. Nane te-mayokmba taikade le nane ŋakmba wandek sinamŋge minig ta kilŋaniŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Taŋamba ndo tane taŋgo pino ŋgamukŋge sati taŋaŋ buluŋga minap le nane tane kaŋgertiŋmba taŋgine Mam samba mbolŋge minit nu tuku nyu te-duŋguwaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ye tukul pasa tuan taŋgo kame tuku pasa pitaikam prowen ŋga idus ndawap. Ye pasa ta kumu-kumumba alonu kile-mayokkam prowen. ");
INSERT INTO ssd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tane pasa te ise tiwap. Tukul pasa fambonu inum fudiŋndo ŋgisi ndaka minwa le ma ma wam kame te ŋakmba kumuŋguwaig le samba kilke kugawamŋgaik. ");
INSERT INTO ssd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ande nu tukul pasa fudiŋndo inum te-ibeŋmba baklel sermba afu tumniŋguwa ta nu Kuate tuku gageu ŋgamukŋge nyu kugatok minamŋgat. Ande nu tukul pasa ŋakmba dubika afu tumniŋguwa ta nu Kuate tuku gageu ŋgamukŋge nyu ŋak minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ye tane satiŋgamŋgit. Tane maŋau magenu kumba Farisi le kusem pasa bitekŋganu mbal tuku maŋau magenu li ndaniŋgap ta tane Kuate kulatkate ma ta mbol kine nda. ");
INSERT INTO ssd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Moses nu siŋgine wa mbuŋ kame teŋenmba saniŋgina. Taŋgo bale ndawap. Andeŋge taŋgo balewa kande nu pasa mbolŋge te-tiwap ŋgina. Pasa ta tane isnaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ye tane teŋenmba satiŋgamŋgit. Ande nu tira nuŋe tuku gubra ndo tuwa kande nu mata pasa mbolŋge te-tiwap. Ande nu tira nuŋe tumail panmba agaŋmor taŋaŋ wamdus kugatok ŋga sawa ta nu pasa suŋgo mbolŋge te-tiwap. Ande nu nuŋe tira tapramba ŋginŋgan taŋgo ŋga sawa ta nu ma ŋayo tuku pa mbol kambim tuku minit. ");
INSERT INTO ssd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ta tuku ne Kuate atraukam ŋga tira naŋe ne ndoŋ gubra ŋak minit ta idusmba kande ne Kuate atrau ndaka. ");
INSERT INTO ssd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Agaŋ ta atrau mbain tugumŋge kusremba luka kumba ka naŋe tira ndoŋ wamdus tumawap sulumba luka pro Kuate atrauka. ");
INSERT INTO ssd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Taŋgo ande ne pasa mbolŋge pilmba pasa pilewanu wande mbol kambim saka kumba ka ndinŋge nu ndoŋ pitik ndo wamdus tumawa. Kuga ta nu ne tumba ka pasa pilewanu taŋgo tuku wai mbol pilwa le nuŋge ne tumba muli wande kulatkate taŋgo ta tuwa le ne muli wandek sinamŋge palmbimŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ye siŋka tane satiŋgamŋgit. Naŋe mbar tuku piya suŋgo ta kumumba fudiŋndo lafu sulu ndawa ta ne muli wandek sinamŋge prowe nda. ");
INSERT INTO ssd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Moses nu teŋenmba sakina. Taŋgo pino muŋgu kuayar ndakap ŋgina. Pasa ta tane isnaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ye tane teŋenmba satiŋgamŋgit. Ande nu ammbi pino kaŋgerte sulumba am kikoŋ tiŋgate le wamdus ŋayonu tate ta nu buk wamdusmbi pino ta kuayarmba unekate. ");
INSERT INTO ssd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ne tuku am ndinamŋge ne unekam tuku didikate ndeta gomba bukŋga. Ne tuku ŋgarosu inumnu taŋamba ŋgisi ndakuwa le ne ŋgarosu ŋakmba kumumbi minwaig ta ne ma ŋayo mbol kaŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne tuku wai ndinamŋge ne unekam tuku didikate ndeta pike purmba bukŋga. Ne tuku ŋgarosu inumnu taŋamba ŋgisi ndakuwa le ne ŋgarosu ŋakmba kumumbi minwaig ta ne ma ŋayo mbol kaŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Moses nu pasa ande teŋenmba sakina. Ima nu piyo nuŋe pitaiwam ndeta nu pitaiwam tuku waŋe kuyarmba tuwa ŋga sakina. ");
INSERT INTO ssd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ye tane teŋenmba satiŋgamŋgit. Pino ande nu taŋgo ande ndoŋ fare mine ndakate le taŋgo nuŋeŋge nu maŋau kise tuku pitaite le nu kumba taŋgo kise tate ta nu taŋgo ambokok tuku mbar mbolŋge nu taŋgo kuayarmba unekate. Taŋgo kitek ta nu mata pino kuayarmba unekate. ");
INSERT INTO ssd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Moses nu wa mbuŋ kame pasa ande teŋenmba saniŋgina. Tane pasa saŋgri pilede ta kusre ndawap. Kuate am mbolŋge pasa ta kumuwap ŋgina. Pasa ta tane isnaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ye tane teŋenmba satiŋgamŋgit. Tane pasa ande saŋgri pile ndawap. Tane pasa saŋgri pilewam tuku samba kilke nyu nda tap. Samba Kuate minit tuku ma. ");
INSERT INTO ssd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kilke Kuate kupe patikate tuku ma. Yerusalem mata nyu nda tap. Tumbraŋ suŋgo ta Kuate Suŋgo tuku tumbraŋ. ");
INSERT INTO ssd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tane taŋgine gabat mata nyu nda tap. Ata. Tane taŋgine gabat waŋe inum kaukauk ko dabuk dabuk te-mayokam tuku tane saŋgri kugatok. ");
INSERT INTO ssd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tane au ŋgumba kande au ndo ŋgap. Kuga ŋgumba kande kuga ndo ŋgap. Tane saŋgri pilewam tuku pasa tuturte ta Satan tugumŋge ilit. ");
INSERT INTO ssd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Moses nu teŋenmba sakina. Taŋgo andeŋge ande tuku am gowa kande lafumba nu tuku am mata gowap. Taŋgo andeŋge ande tuku maketiŋ ŋgurwa kande lafumba nu tuku maketiŋ mata ŋgurap ŋgina. Pasa ta tane isnaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ye tane teŋenmba satiŋgamŋgit. Taŋgo ande nu ne ŋayo silinuwa kande ne lafu ndawa. Ande nu ne tuku dabil ndinam pannuwa ndeta ne mbilka dabil inum tawe le pannuwa. ");
INSERT INTO ssd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Taŋgo ande nu ne tumba pasa mbolŋge pilmba ne tuku tawi tuwa ndeta ne naŋe tawi ande turmba tawe. ");
INSERT INTO ssd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Taŋgo ande nu agaŋ ande pitinu neŋge turmba diram tuku sarsarmba sanuwa kande ne agaŋ ta tumba nu ndoŋ kumba ka lukam tuku ma ta limba ka palmbim tuku ma mbol pale. ");
INSERT INTO ssd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ande nu agaŋ ande tuku yabaŋnuwa kande nu tawe. Ande nu ne tuku agaŋ tumba ŋgumneŋga ne luka tanmbimŋgit ŋga sanuwa ndeta mbule ndaka nu tawe. ");
INSERT INTO ssd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Moses nu teŋenmba sakina. Tane taŋgine gulab kame tuku kume purmba taŋgine ŋgueu taŋgo kasurniŋgap ŋgina. Pasa ta tane isnaig. ");
INSERT INTO ssd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ye tane teŋenmba satiŋgamŋgit. Taŋgine ŋgueu mbal tuku kume purap. Nane afu tane kilmba piti sertiŋgig mbal nane sinanu Kuate yabaŋap. ");
INSERT INTO ssd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tane taŋawap ta taŋgine Mam samba mbolokŋge minit nu tuku kiŋo kame minmba nu tuku maŋau te-purde. Nuŋge ki siŋgit le taŋgo magenu ŋaigonu turmba mbol prote. Nuŋge sawe siŋgit le taŋgo tiŋreknu taŋgo une ŋak turmba turkate. ");
INSERT INTO ssd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nane afu tane tuku kume purwaig le tane ndek nane tuku kume purmba Kuate nu wam ta tuku lafunu mayenu tiŋgamŋgat ŋga idus ndawap. Takis kilanu mbal ŋaigonu nane mata wam ndui ta ndo kade tae. ");
INSERT INTO ssd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Taŋgine tira kame ndo kile-tawokkap ta tane Kuate ŋgumnede mbal li ndaniŋgig. Kuate gilai mbal nane mata taŋade tae. ");
INSERT INTO ssd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Taŋgine Mam samba mbolŋge minit nu taŋgo ŋakmba mbolŋge maŋau magete taŋamba tane mata nane ŋakmba mbolŋge maŋau magewap. ");
INSERT INTO ssd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tane maŋau te riroŋkap. Tane taŋgo pinoŋge sine kaŋgersiŋguwaig ŋga nane am mbolŋge maŋau magenu kumba payam ndakap. Tane taŋawap ta tane tuku Mam samba mbolŋge minit nu lafu mayenu tiŋge nda. ");
INSERT INTO ssd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tane sanzal mbal agaŋ ndendembi turkade ta tane yabri mbal maŋau kade taŋamba pasa sulu ndawap. Yabri mbal nane taŋgo pinoŋge nane tuku nyu kile-duŋguwaig ŋga kusem wandekŋge ko tumbraŋ ŋgamuŋge nane agaŋ ndende niŋgig. Ye siŋka satiŋget. Nane wam ta tuku lafunu nyu sugo ndo kile sulude. Lafunu ande te nda. ");
INSERT INTO ssd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tane sanzal mbal turkam ndeta tane tuku wai ŋaiŋamŋge katese ndawa ŋga wai ndinam kuirkuirka pirokate taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tane taŋawap le tane tuku Mam nu wam kuirok kaŋgerkate ta nuŋge ndo lafunu mayenu tiŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ne Kuate ndoŋ pasatate ta yabri mbal maŋau kade ne taŋamba ke ndaka. Afuŋge nane kaŋgerkuwaig ŋga nane kusem wandekŋge ko tumbraŋ ŋgamuŋge tiŋga Kuate yabaŋam nzaliniŋgit. Ye siŋka satiŋget. Nane wam ta tuku lafunu nyu sugo ndo kile sulude. Lafunu ande te nda. ");
INSERT INTO ssd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ne Kuate ndoŋ pasatam ndeta naŋe mata wandek sinam kumba malaŋga tukulmba nu ndoŋ pasata. Ne taŋawa le ne tuku Mam nu wam kuirok kaŋgerkate ta nuŋge lafunu mayenu tanmbimŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ne Kuate ndoŋ pasatam ndeta kasomok mbal nane naŋgine mbara pasa alo kugatok yabaŋmba lato-latomba pasatade ne taŋamba ke ndaka. Nane lato-latomba wikuwaig ta mbara nu isamŋgat ŋga idusde. ");
INSERT INTO ssd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ne nane kade taŋamba ke ndaka. Ne naŋe Mam nda yabaŋte le nu o buk ne agaŋ ndende denkate ta nu kila minit. ");
INSERT INTO ssd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ta tuku ne teŋenmba Kuate ndoŋ pasata: Siŋgine Mam ne samba mbolŋge minit. Naŋe nyu purfeŋnu ta taŋamba minmba minwa. ");
INSERT INTO ssd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ne naŋe gageu kilmba kulatkam tuku prowa. Ne tuku nzali samba mbolŋge mayok kinit taŋamba kilke te mbolŋge mata mayok kuwa. ");
INSERT INTO ssd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ki ait te tuku nyamagaŋ kumumbi siŋga. ");
INSERT INTO ssd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nane afu sine mbolŋge mbarde le sine ndek gilaiŋgeg taŋamba ndo ne sine tuku mbar mata sauka gilaiŋga. ");
INSERT INTO ssd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sine tagosiŋgam tuku ait prowa le piti ta peuwa. Satan tuku saŋgri mbolŋge ne sine kilmba kile-mayokka. Ne ndo Gabat Suŋgo Ndindo. Ne saŋgri ŋakmba ŋak. Ne tuku nyu suŋgo pasa ŋak. Ne taŋamba minmba minamŋgat. Son. Ne taŋamba Kuate yabaŋa. ");
INSERT INTO ssd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ne afu tuku mbar gilaiŋga ta ne tuku Mam samba mbolŋge minit nu mata ne tuku mbar sauka gilaiŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ne taŋgo pino tuku mbar gilai ndaŋga ta ne tuku Mam mata ne tuku mbar sauka gilaiŋge nda. ");
INSERT INTO ssd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ne Kuate yabaŋam ŋga nyamagaŋ pinkate ta yabri mbal maŋau kade taŋamba ke ndaka. Nane taŋgo pino ŋakmba kila pilwaig ŋga guba tumail pasi pilmba likade. Ye siŋka satiŋget. Nane ta tuku lafunu nyu sugo ndo kile-sulude. Lafunu ande te nda. ");
INSERT INTO ssd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ne nyamagaŋ pinkam ndeta ŋgarosu wakeimba tumail pasi minyaŋga gabat pareŋa. ");
INSERT INTO ssd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Taŋgo pino nane gilai minwaig le ne tuku Mam nu wam kuirok kaŋgerkate nuŋge ndo ne kaŋgernuwa ŋga ne taŋawa. Taŋawa le ne tuku Mam nu wam kuirok kaŋgerkate ta nuŋge lafunu mayenu tanmbimŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kilke te mbolŋge agaŋ ndende magenu kile-maŋgurka patikam tuku idus ndawap. Ma te mbolŋge agaŋ ndende use purka sasuka subiŋge ŋaigo siglika kuayar taŋgo pro kilig tuku. ");
INSERT INTO ssd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tane samba mbolŋge agaŋ ndende magenu patikam tuku idusap. Ma ta mbolŋge agaŋ ndende use purka sasuke nda. Subiŋge ŋaigo siglike nda. Kuayar taŋgo mata pro kile nda. ");
INSERT INTO ssd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Taŋgine agaŋ ndende magenu minig ma ta mbolŋge taŋgine ŋgamuŋgal mata taŋge minig. ");
INSERT INTO ssd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Taŋgo tuku am sati taŋaŋ ŋgarosu kilŋawam tuku minit. Ne am mayenu minit ta ne tuku ŋgarosu ŋakmba bulu mbolŋge minit. ");
INSERT INTO ssd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ne am ŋayonu minit ta ne tuku ŋgarosu ŋakmba ma make sinamŋge minit. Ne tuku ŋgamuŋgal tuku sati am ŋayonu taŋaŋ minit ta ne siŋka ma make suŋgo ŋayo sinamŋge minit. ");
INSERT INTO ssd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Taŋgo ande nu gabat armba tugumŋge nu pironu kumuŋ kuga. Nu ande ŋgamuŋgal tumba ande idus ndate. Nu ande tuku nyu te-mayokmba ande tuku nyu te-mayok ndate. Taŋamba ndo ne ndametiŋ kilam tuku ndo iduste ta ne Kuate wamdus tambim kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ta tuku ye tane satiŋget. Tane ŋgarosu turam tuku nyamagaŋ ko kule ko tawi kilam tuku wamdus piti ser ndawap. Ŋgarosu saŋgri pilewam tuku nyamagaŋ ndo kuga. Ne maye minam tuku tawi ndo kuga. ");
INSERT INTO ssd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tane sar umaŋ kaŋgerkap. Nane nyamagaŋ ŋguka alonu kile ndakade. Nane guba ait mbolŋge nyamagaŋ nyam tuku pati ndakade. Taŋgine Mam samba mbolŋge minit nuŋge nane nyamagaŋ niŋgit. Nu tuku am mbolŋge tane sar umaŋ liniŋganu minig. ");
INSERT INTO ssd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wamdus piti ta kusrewap. Ande tane ŋgamukŋge nu wamdus piti suŋgo tumba maŋau tambi nuŋe abo minam tuku ait tuturam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ndaŋam tane tawi kilam tuku wamdus sulumba piti ŋak minig. Tane aŋga bot prode maŋau ta kaŋgerkap. Nane tawi wakeiwam tuku piro ndakade. ");
INSERT INTO ssd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ye tane satiŋget. O buk gabat suŋgo Solomon nu mindepiye maditaknu silikina ta aŋga bot tuku mindepiye li ndaniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Aŋga ta ki ndindo ndo minig. Mafete le fulka kilmba pa mbolŋge pankade. Aŋga ŋagai pa mbolŋge pankade ta mata Kuate nu mindepiyeniŋgit. Nu siŋka tane tawi kile-tiŋgamŋgat. Tane Kuate nu kumuŋ kuga ŋga idusde e? ");
INSERT INTO ssd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tane wamdus teroka piti sermba sine ndaŋndaŋmba nyamagaŋ kule kilmba nyube o ko ndaŋndaŋmba tawi kilmba tiŋbe ŋga idusmba mine ndakap. ");
INSERT INTO ssd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nane Kuate gilai minig mbal agaŋ kame ta kilam tuku wamdus sulude. Tane agaŋ kame ta kugatok minam kumuŋ kuga ta taŋgine Mam samba mbolŋge minit nu kila. ");
INSERT INTO ssd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tane Kuate tuku gageu nu tuku miŋge kumnemŋge minmba tiŋreknu mayok kambim tuku wamdus saŋgrinu palpe ta Kuate nu ŋgarosu maye minam tuku agaŋ kame kumumbi tiŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tane indole tuku piti ta tuku kite wamdus sulu ndawap. Ki ndindo tuku piti ta ndo tane kurawam kumuŋ. ");
INSERT INTO ssd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ne taŋgo afu tuku maŋau pile ndaniŋga le Kuate nu ne tuku maŋau mata pilewe nda. ");
INSERT INTO ssd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ne nane afu pileniŋgit ta maŋau ndui tambi Kuateŋge ne pilenamŋgat. Ne nane afu mbolŋge maŋau kate ta maŋau ndui tambi Kuateŋge ne mbolŋge kamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ndaŋam naŋe am mbolŋge ail baŋ minit le ne kaŋger ndamba naŋe tira tuku am mbolŋge am sumbi kaŋgermba sakate. ");
INSERT INTO ssd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ndaŋam tuku ne tira ta sate: Ye ne tuku am mbolŋge am sumbi ta saukamŋgit ŋgate. ");
INSERT INTO ssd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ne yabri taŋgo ndo. Ne amboŋga naŋe am mbolŋge ail baŋ ta paska. Ne am purfewa le naŋe tira tuku am mbolŋge am sumbi ta saukam kumuŋ. ");
INSERT INTO ssd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kuate tuku wam magenu kame ta age nda niŋgap. Nane mbilka tane maketiŋbekaig. Kuate nu wam magenu tiŋgit ta mbo tugumŋge pan ndakap. Nane agaŋ magenu ta ake agaŋ ŋga totobekaig. ");
INSERT INTO ssd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ne wam ande tam tuku Kuate yabaŋmba dirnaŋga ta tanmbimŋgat. Ne wam ande sota mina ta te-silikamŋgat. Ne malaŋga ande katkata ta talke tanmbimŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ima nu wam ande tuku Kuate yabaŋmba dirnaŋgate ta nu tate. Ima nu agaŋ ande sota minit ta nu te-silika tate. Ima nu malaŋga katkatmba minit ta nu talke tuwit. ");
INSERT INTO ssd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tane ŋgamukŋge ande kiŋo nuŋe nyamagaŋ yabaŋte le nu lafumba ndame tuwit e? ");
INSERT INTO ssd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ko kualegaŋ yabaŋte le mbeŋ tuwit? ");
INSERT INTO ssd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tane kilke mbol mbal une ŋak ta taŋgine kiŋo kame agaŋ magenu niŋgig tuku. Taŋgine Mam samba mbolŋge minit nu purfeŋnu ndo. Nu tane tuku maŋau limba nu yabaŋde mbal agaŋ magenu niŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nane afu ne mbolŋge maŋau magenu kuwaig ŋga idusmba nzalinate taŋamba ndo ne nane afu mbolŋge ka. Tukul pasa tuan taŋgo kame tuku pasa tugunu not. ");
INSERT INTO ssd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Tane malaŋga fudiŋndo sinam kambim tuku saŋgri tiŋga minap. Ŋgisikam tuku malaŋga suŋgokanu. Ndin mata wam bada kuga. Taŋgo pino gudommba ndin ta dubimba sinam kinig. ");
INSERT INTO ssd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Abo tugu tam tuku malaŋga fudiŋndo. Ndin mata kambim tuku minde bada. Nane ndui ndui ndo ndin ta te-silika dubimba sinam kinig. ");
INSERT INTO ssd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tane yabri tuan taŋgo tuku riroŋkap. Nane sipsip tuku ŋgaro kaika sipsip magenu minet minet ŋga tane tugum prode ta nane age ŋguikok ndo. ");
INSERT INTO ssd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Naŋgine wam kile-mayokkade ta mbolŋge katesewamŋgaig. Tane suwar ail mbolŋge apasin alonu kilig e? Ko tane ulem mbolŋge mar alonu kilig? ");
INSERT INTO ssd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Taŋamba ndo ail mayenu nu alonu magenu ndo kile-mayokkate. Ail ŋayonu nu alonu ŋaigonu ndo kile-mayokkate. ");
INSERT INTO ssd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ail mayenu alonu ŋaigonu kile-mayokkam kumuŋ kuga. Ko ail ŋayonu alonu magenu kile-mayokkam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ail alo mage ndade ta ŋakmba pike lika pa mbolŋge kile-pankade le uge sulude. ");
INSERT INTO ssd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yabri tuan taŋgo nane wam kile-mayokkade ta mbolŋge tane katesewamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nane ye nyu ta Suŋgo ŋgade mbal ta afu Kuate kulatkate ma mbol kine nda. Ye tuku Mam samba mbolŋge minit nu tuku nzali dubide mbal ndo ma ta mbol kaŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ait suŋgo mbolŋge taŋgo suŋgomba ye teŋenmba sayamŋgaig: O Suŋgo, sine ne tuku nyu mbolŋge dir pasa bitekŋga bukla ŋaigonu pitaika maŋau kitek saŋgrinu gudommba ke likigeŋ ŋga sayamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Taŋakuwaig le ye nane kilimok saniŋgamŋgit: Ye siŋka tane gilai. Tane maŋau ŋaigonu kanu mbal tane kua kape ŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ima nu ye tuku pasa ise mayemba ka kumu-kumute ta nu taŋgo teŋen. Taŋgo ande nu wamdus kuyar mayenu ŋak wande palmbim ŋga ndame sugo mbolŋge makek tugunu ndame patika daŋŋgina taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ŋgumneŋga sawe suŋgo piymba kule suŋgo ndeka bubre saŋgrinu tiŋga wande ta kulisokŋga buruna kande wande sur ndakina. Wande ta makek ndamembi daŋŋgina tukunu wande saŋgri ŋak minna. ");
INSERT INTO ssd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ande nu ye tuku pasa ismba nda dubite ta nu taŋgo teŋen. Taŋgo ande nu wamdus kuyar mayenu kugatok wande palmbim ŋga fulbul mbolŋge ake makek tidiŋgina taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ŋgumneŋga sawe suŋgo piymba kule suŋgo ndeka bubre saŋgrinu tiŋga wande ta kaduna le surka ndeka fudu ŋayona ŋga nane saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus nu pasa ta ŋakmba sake deŋpurna le maŋgur suŋgo ta nu tuku wam pagu pasa isnaig ta tuku ndek pirerek purkinaig. ");
INSERT INTO ssd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nu kusem pasa tugunu bitekŋganu mbalŋge nane tumniŋginaig taŋamba nu nane tum ndaniŋgina. Nu pasa miro taŋaŋ tumniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus nu tabe kusremba ndekina le taŋgo pino gudommba nu dubinaig. ");
INSERT INTO ssd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Taŋamba kinaig le taŋgo ande ŋgirŋger ŋak pro nu tugumŋge dagol tidroŋga nu sana: O Suŋgo, ne kumuŋ. Ne nzalinuwa ndeta ye tuku ŋgarosu wakeiwa ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","nu ndek wai kuitka nu kiremba sana: Au. Ye ne wakeinet. Ne mayeka ŋgina. Taŋakina le ŋgirŋger ta gagulka ŋgarosu mayekina le ");
INSERT INTO ssd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesus nu sana: Ye ne mbolŋge maŋau kit te afu sa ndaniŋga. Ne kumba ka naŋe ŋgarosu pris tuma. Moses tuku tukul dubimba atrau agaŋ pris tawe le atraukuwa le ŋakmba ne mayekat ta kila pilwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesus nu kumba Kaperneum tumbraŋ prona le Rom mbal tuku kame gabat ande nu tugum promba nu sarsarmba sana: ");
INSERT INTO ssd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","O Suŋgo, ye tuku piro taŋgo ande nu tuku ŋgarosu ŋakmba milmailkina le nu sinamanzer suŋgo ŋak minit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Taŋakina le Yesus ndek nu sana: Ye kumba wakeiwamŋgit ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","kame gabat ta nu ndek Yesus peumba sana: O Suŋgo, ye mayenu kuga. Ne ye tuku wande mbol pro ndawa. Ne sando ka le ye tuku piro taŋgo mayekuwa. ");
INSERT INTO ssd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ye sugo afu kumnemŋge minet. Ye mata kame mbal afu tuku gabat minet. Ye ande kukulmba ne kaye ŋget ta nu kinit. Ande wika yale ŋget ta nu ilit. Yiŋe piro taŋgo ande piro si ka ŋget ta nu kate. Ne saŋgri suŋgo ŋak ta ye kila. Sando ka ta kumuŋ ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus nu pasa ta ismba nu pirerek purka mbilka nane nu dubimba kinaig mbal saniŋgina: Ye siŋka tane satiŋgamŋgit. Kasomok taŋgo te nu ye tuku saŋgri tomba tiŋgate. Sine Israel ŋgamukŋge ye son maŋau saŋgrinu taŋaŋ kaŋger ndawet. ");
INSERT INTO ssd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ye tane satiŋget. Kilke tugu ŋakmba mbolŋge kasomok mbal gudommba pro Kuate kulatkate ma sinam kumba ka Abraham Isak Yakob ndoŋ minyoka isukusmba minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Israel afu Kuate tuku gageu minam tuku nyu ŋak minig ta nu nane pitaikuwa le ma ŋayo ma make suŋgo sinam kaŋgaig. Ma ta mbolŋge minamŋgaig mbal nane malmbi suŋgo tumba maketiŋ tikŋga minamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Taŋamba saniŋmba nu ndek mbilka kame gabat ta sana: Ne luka kaye. Ne ye wam kam kumuŋ ŋga idusat ta taŋamba mayok kuwa ŋgina le ait ta mbolŋge ndo nuŋe piro taŋgo mayekina. ");
INSERT INTO ssd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesus nu Petrus tuku wande mbol kumba Petrus magma nuŋe ŋgaro pa tiŋgina le kinye ŋak minna le kaŋgermba ");
INSERT INTO ssd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","nu wainu kirena le ŋgaro pa tiŋgina ta mukuna. Taŋana le nu tiŋga Yesus tuku paguna. ");
INSERT INTO ssd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Taŋamba furirna le nane gudommba bukla ŋak mbal mindeka kilmba Yesus tugum prowe likinaig le nu bukla miŋgembi sando kina le nane taŋgo kusreka kua kinaig. Nu guaze mbal ŋakmba wakeikina le magekinaig. ");
INSERT INTO ssd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesus nu taŋamba kina le Kuate tuku tuan taŋgo Aisaia tuku pasa kumuŋgina. Nu teŋenmba sakina. Nu sine tuku guaze yaika guaze tuku piti kugrakina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesus nu maŋgur suŋgo nu tugumŋge maŋgurkinaig le kaŋgerka nuŋe dubinaig mbal saniŋgina: Sine kule kualiŋ sim kab ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Taŋakina le kusem pasa bitekŋganu taŋgo ande nu Yesus tugum promba sana: Tum Taŋgo, ne ma ŋakmba mbol kambim tuku saka ta ye ne ndoŋ kaŋkik ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesus ndek nu sana: Mbo ŋguikok sar umaŋ nane te ŋak ta ye Ndindo Katesek Taŋgo ye mabtam tuku wande kugatok. Ne ye ndoŋ lika piti ta kurawam kumuŋ e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","nuŋe dubiwanu taŋgo ande ndek Yesus sana: Suŋgo, ye ne ndoŋ minam iduset ta ye luka kumba ka mam kumwa le ŋguki sulumba ne dubinamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Taŋakina le nu lafumba sana: Mbal afu wamdus kumaknu minig naneŋge kumanu mbal ŋgukuwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesus nu waŋ ande poŋgina le nuŋe dubinaig mbal nu ndoŋ poŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nane kule kualiŋ mbol mbol kumba minnaig le Yesus nu waŋ mbolŋge kinymba gilaiŋgina. Kinymba gilaiŋgina le bubre suŋgo tiŋgina le kule toŋgel tiŋga waŋ sinam kumba minna le ");
INSERT INTO ssd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","nane nu kuanemba sanaig: Suŋgo, ne pitik sine tursiŋga. Sine ŋgisikam bafuweg ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","nu ndek saniŋgina: Ndaŋam tane wamdus fulilkade. Tane Kuate nu kumuŋ kuga ŋga idusde e ŋga saniŋgina sulumba nu tiŋga bubre kule sanike likina le ma betkiremba kule basle mayena. ");
INSERT INTO ssd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Taŋana le nane wam ta kaŋgermba piriri ŋayomba sakinaig: i ... Taŋgo te nu ima suk a. Bubre kule nale mata nu tuku miŋge dubide ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nane kule kualiŋ sim ka Gadara mbal tuku ma mbolŋge ibeŋ kinaig le taŋgo armba bukla ŋak nale mindesiŋ patikinaig tuku ma ndame burok sinam taŋge mayok ka Yesus tugum pronaik. Nale mara mara ndin ta tukulmba kame-kameka minanu. ");
INSERT INTO ssd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nale wi kueŋka Yesus sanaik: Kuate tuku Kiŋo, ne sine ndoŋ wamdus tuma kuga. Ne ndaŋam kile sine piti sersiŋgam te prote? Ait ta kile ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ma ta masken suk mbo gudommba suŋarka mine likinaig tukunu ");
INSERT INTO ssd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","bukla kame ta nane Yesus sarsarmba kusnanaig: Ne sine taŋgo te mbolŋge pitaikumba kande sine kukulsiŋga le mbo kame si fuŋgul sinam kab ŋga sanaig le ");
INSERT INTO ssd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","nu pasa lafumba taŋawap ŋgina. Kile bukla ŋaigonu taŋgo ar ta kusreka mbo fuŋgul sinam kine likinaig le nane ŋakmba saŋgri ŋak pinder-pindermba tabe te-tirok ta dubimba biri-bariŋga kule kualiŋ butonu sinam kumba ŋgisike sulunaig. ");
INSERT INTO ssd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kile mbo kulatkanu mbal kua ka pinder-pindermba ka tumbraŋ suŋgo mbolŋge maŋau mayok kina ta ŋakmba kubeu niŋginaig sulumba taŋgo ar bukla ŋak nane tuku wam mata turmba sakinaig. ");
INSERT INTO ssd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Taŋakinaig le tumbraŋ suŋgo ta tuku mbal ndek Yesus sota kaŋgermba nane nu sarsarmba nane tuku ma ta kusremba kuwa ŋga sanaig. ");
INSERT INTO ssd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesus nu waŋ poŋga luka nuŋe tumbraŋ prona. ");
INSERT INTO ssd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Prona le nane afuŋge taŋgo ŋgarosu milmailkanu kinye ŋak minna le sukuŋga tumba nu tugum pronaig. Yesus nu nane nu tuku saŋgri tomba tiŋginaig ta katesemba nu taŋgo ŋgarosu milmailkanu ta sana: Kiŋo, ne wamdus bulka piti ndanuwa. Ye ne tuku mbar ŋakmba sauka gilaiŋget ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nu taŋakina le kusem pasa bitekŋganu mbal afu naŋgine wamdusmbi sakinaig: Nu Kuate le taŋakate e ŋga idusmba minnaig ta ");
INSERT INTO ssd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesus nu nane tuku wamdus katesemba nu nane saniŋgina: Ndaŋam saka tane ŋgamuŋgal sinamŋge wamdus ŋayonu tade. ");
INSERT INTO ssd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ye tane kusnatiŋgamŋgit. Ame pasa taŋgo te sawam tuku wam bada? Ye ne tuku mbar sauka gilaiŋget ko tiŋga lika kaye ŋget. ");
INSERT INTO ssd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ye Ndindo Katesek Taŋgo ye kilke te mbolŋge mbar saukam tuku ye saŋgri ŋak. Tane wam ta kila palmbim tuku ye kile pasa wam bada te sakamŋgit ŋgina. Taŋaka nu ŋgarosu milmailkanu ta sana: Kile ne tiŋga nzaŋnzaŋ kuramba naŋe tumbraŋ kaye ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","nu tiŋga lika kumba nuŋe tumbraŋ kina. ");
INSERT INTO ssd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Taŋana le maŋgur suŋgo taŋge minnaig nane wam ta kaŋgernaig sulumba nane kuru-kuruka Kuateŋge saŋgri suŋgo kilke mbolok taŋgo tuwit ŋga Kuate tuku nyu te-duŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kile Yesus nu tiŋga kumba ka takis kilanu wande mbolŋge taŋgo ande nyunu Mateus nu piroka minna le nu kaŋgermba sana: Ne ilmba ye dubiya ŋgina le nu ndek tiŋga nu dubimba kina. ");
INSERT INTO ssd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesus nu nuŋe dubinaig mbal ndoŋ wandekŋge isukusmba minnaig le takis kilanu mbal afu mbar ŋak nane gudommba pro nane ndoŋ minyok minnaig le ");
INSERT INTO ssd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisi mbal nane maŋau ta kaŋgermba Yesus dubinaig mbal saniŋginaig: Ndaŋam saka taŋgine Tum Taŋgo nu takis kilanu mbal wam ŋaigonu kade mbal ndoŋ isukusit ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Taŋakinaig le Yesus nu pasa ta ismba lafumba saniŋgina: Guaze kugatok mbal nane dokta tugum kine ndakade. Guaze ŋak mbal ndo nu tugum kinig. ");
INSERT INTO ssd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nane afu sine magenu ŋgade ta ye nane wika wakeikam pro ndawen. Ye nane une ŋak mbal wika wakeikam tuku prowen. Kuate tuku pasa tuan taŋgo andeŋge kuyarna ta teŋenmba sakate: Tane ye tuku ŋga agaŋmor kilmba atraukade ta ye suŋgomba idus ndawet. Tane taŋgo sinaniŋmba nzaliniŋgam tuku ye suŋgomba iduset ŋgate. Tane pasa ta kila pile mayewap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mara ande Yohanus kule pisne dubinaig mbal pro Yesus kusnanaig: Sine Yohanus dubiweg mbal Farisi mbal turmba sine ait afu Kuate tuku ŋga nyamagaŋ pinkeg. Ndaŋam naŋe dubinade mbal maŋau ta ke ndakade ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus nu nane saniŋgina: Taŋgo ande nu pino tam tuku pagumba nye mbolŋge nu nuŋe mbal ndoŋ minit tukunu nane piti ŋak minam kumuŋ kuga. Ait ande prowa le afuŋge pro taŋgo ta nane ŋgamukŋge tuwaig le nane wamdus piti niŋguwa le nyamagaŋ pinka minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ande nu tawi urfunu burokuwa le tawi abonu tumba burok ta tukulmba zail ndaŋgate. Nu taŋawa ta kumiŋ kitek taŋge urfunu didikuwa le lato fetkamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ande nu grep kule kitek tumba agaŋmor ŋgaro urfunu sinamŋge tol ndate. Nu taŋawa ta grep kule fulilka agaŋmor ŋgaro urfunu fetkuwa le grep kule kutuka ndeke suluwamŋgat. Agaŋmor ŋgaro ta mata ŋayoŋgamŋgat. Nane grep kule kitek tumba agaŋmor ŋgaro kitek sinamŋge tolde. Taŋade le grep kule agaŋmor ŋgaro turmba mage minamŋgaik ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus nu taŋamba pasata minna le taŋgo suŋgo ande pro nu tugum taŋge dagol tidroŋga sana: Ye tuku kulim kile ndo kumat. Ne kumba naŋe waimbi ŋgarosu kirewa le aboŋguwa ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Taŋaka sana le nu ndek tiŋga nuŋe dubiwanu taŋgo ndoŋ taŋgo ta dubimba kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nane kumba minnaig le kile pino ande nu yar 12 mara mindek tambun guaze ŋak minna ta nu pro Yesus ŋgumnemŋge nu tuku tawi nzalenu kirena. ");
INSERT INTO ssd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nu teŋenmba idusna: Ye nu tuku tawi ndo kirewi ta ye mayekamŋgit ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Taŋamba idusmba nu tawi kirena le Yesus ndek mbilka pino ta kaŋgermba sana: Kulim, ne wamdus bulka piti ndanuwa. Ne ye tuku saŋgri tomba tiŋgate tukunu ne mayekat ŋgina. Taŋakina le ait ta mbolŋge ndo nu mayekina. ");
INSERT INTO ssd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kile Yesus nu taŋgo suŋgo ta tuku wande tugum prona. Nu pro taŋge nane gudommba malmbi wikaraumba tabu tabu fitke likinaig le saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tane kua ka sili-siliwap. Kulim te kume ndakat. Nu kinymba minit ŋgina le nane ndek nu talamba nzumilnaig. ");
INSERT INTO ssd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Taŋanaig le Yesus nu nane ŋakmba mayok kuwaig ŋga pitaika nu wandek sinam kumba ka mindesiŋ tuku wai biyna le nu tiŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Taŋana le pasa ta suŋgoka ma ta tuku tumbraŋ ŋakmba kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesus nu ma ta kusremba kina le taŋgo armba am tukulok nu ŋgumnem dubimba wi kueŋka sakinaik: Suŋgo, ne David tuku mbuŋ. Ne sile sinasikmba tursika o ŋga wika minnaik le ");
INSERT INTO ssd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesus nu kumba wande poŋgina le nale nu dubimba nu tugum pronaik. Taŋanaik le nu nale kusnanikina: Ye tale tuku am wakeikam kumuŋ ŋga idusik e ŋgina le nale sakinaik: Suŋgo, ne kumuŋ ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Taŋakinaik le nu ndek nale tuku am kigreka sanikina: Tale ye tuku saŋgri tomba tiŋgade tukunu wam ta mayok kuwa ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","nale tuku am magekinaik. Kile Yesus nu saŋgrimba nale sanikina: Ye tale mbolŋge wam kit ta afu sa ndaniŋgap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Taŋamba peunikina ta nale kinaik ka nu tuku nyu saka saka kinaik le ma ta ŋakmba kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yesus nane ma ta kusrewam bafunaig le afuŋge taŋgo ande buklaŋge miŋge tukulna ta tumba Yesus tugum pronaig. ");
INSERT INTO ssd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pronaig le nu bukla pitaina le taŋgo ta ndek pasatina le taŋgo pino kaŋgermba pirerek purka sakinaig: Yoi. Sine Israel ŋgamukŋge maŋau teŋen mayok kinit le nda kaŋgereg tuku ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Taŋakinaig le Farisi mbal ndek sakinaig: Nu bukla kame tuku gabat tugumŋge saŋgri tate sulumba bukla pitaike likate ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus nu tumbraŋ foŋfoŋ tumbraŋ sugo sugo ŋakmba mbolŋge lika nane tuku kusem wande mbolŋge Kuate nu nuŋe gageu kulatkate wam ta tuku pasa mayenu kuklimba saniŋmba nane tuku guaze tugu yeki yeki wakeike likina. ");
INSERT INTO ssd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Taŋamba nu maŋgur sugo gudommba kaŋgerka nane sipsip kulat taŋgo kugatok taŋaŋ wamdus fulilka naŋgine miroŋ ŋgaro turkam kumuŋ kuga ŋga saka nu nane sinanu ");
INSERT INTO ssd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","nuŋe dubiwanu taŋgo saniŋgina: Piro mbolŋge nyamagaŋ alonu gudommba minig ta kilam tuku piro taŋgo denkate. ");
INSERT INTO ssd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tane piro miro taŋgo yabaŋap le nu piro taŋgo afu kukulniŋguwa le nane nu tuku nyamagaŋ alonu kilwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kile Yesus nu nuŋe dubiwanu taŋgo 12 ta wika kile-maŋgurka nane mata bukla ŋaigonu pitaika guaze tugu yimyam ŋakmba wakeikam tuku saŋgri niŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposel 12 ta nane tuku nyu naŋgine teŋenmba. Ande Simon nyunu ande Petrus ŋgade. Ande maib nuŋe Andreus. Ande Yakobus nu Sebedeus tuku kiŋo nuŋe. Ande Yohanus nu Yakobus maib nuŋe. ");
INSERT INTO ssd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nane afu Filipus, Bartolomeus, Tomas. Ande Mateus nu takis kilanu taŋgo. Ande Yakobus nu Alfeus tuku kiŋo nuŋe. Ande Tadeus. ");
INSERT INTO ssd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ande Simon mape nyu ande Selot. Ande Yudas Iskariotnu ŋgumneŋga nu Yesus tuku kupet mayok kina. ");
INSERT INTO ssd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus nu nane 12 ta kukulniŋgam bafumba saniŋgina: Tane kasomok mbal tuku ma ande ko Samaria mbal tuku tumbraŋ ande mbol kine ndakap. ");
INSERT INTO ssd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tane ka Israel mbal nane sipsip ŋgisikanu taŋaŋ minig nane tugum kape. ");
INSERT INTO ssd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tane kumba Kuate nu nuŋe gageu kulatkam tuku ait buk patukate ŋga saniŋmba likap. ");
INSERT INTO ssd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tane guaze mbal wakeika kumanu mbal kile-tidiŋga ŋgirŋger ŋak mbal mage serniŋmba guwa ŋaigonu pitaikap. Saŋgri ta piya kugatok ake tiŋget tukunu saŋgri tambi pirokap sulumba piya wi ndakap. ");
INSERT INTO ssd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tane kambim ŋga taŋgine ndametiŋ ");
INSERT INTO ssd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","pale fat kupe ŋgaro ndumndum ta ŋakmba kusrekap. Tane tawi tiŋganu ta ndo ŋak kape. Tane piro taŋgo tukunu tane nane afu tugumŋge agaŋ ndende kilam kumuŋ. ");
INSERT INTO ssd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Tane tumbraŋ ande mbol promba taŋgo mayenu ande tane kulatkam tuku sota kaŋgermba nu ndoŋ minmba piroka ka kambim ŋga nu kusremba kape. ");
INSERT INTO ssd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tane wande ande poŋga wande tuku mbal ŋgamuŋgal mukuk ŋak minam tuku saniŋgap. ");
INSERT INTO ssd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nane mbal magenu ndeta tane pasa saniŋgig taŋamba nane ŋgamuŋgal mukuk ŋak minwaig. Kuga ta pasa ta luka taŋgine tugum prowa. ");
INSERT INTO ssd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mbal afu tane kilam mbulmba ko tane pasa kukliwap le isam mbulwaig kande wande ko tumbraŋ ta kusrewam bafumba nane katesemba riroŋkuwaig ŋga nane am mbolŋge tuptup kupe mbolŋge deŋganu minig ta paurŋgap. ");
INSERT INTO ssd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ye siŋka satiŋgamŋgit. Ait suŋgo mbolŋge tumbraŋ tane pitaikate ta nu tumbraŋ ŋaigonu Sodom le Gomora tuku pa limba suŋgo pasa ŋak tamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Tane isap. Ye tane kukultiŋgi le kumba sipsip taŋaŋ ŋgannu age ŋguikok ŋgamukŋge minamŋgaig. Ta tuku tane kurau mayemba gami taŋaŋ wamdus bafuk minap. ");
INSERT INTO ssd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tane riroŋkap. Afuŋge tane kilmba pasa mbolŋge kile-tidiŋga naŋgine kusem wandekŋge tane pani faramŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Afuŋge tane didika kilmba ka gabat kame nyu sugo ŋak mbal tugumŋge kile-tidiŋguwaig le tane ye tuku ŋga pasa mayenu saniŋgap le gabat mbal kasomok mbal turmba ye tuku nyu isamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nane taŋamba tane kilmba gabat sugo tuku wai mbolŋge patikuwaig ta tane wamdus fulilka ndaŋmba sakube o ŋga wamdus te-sulu ndawap. Pasa te-tiwam ait mbolŋge tane tuku wamdus sinamŋge pasa mayok kaŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Taŋgine wamdusmbi kuga. Mam Kuate tuku Guwaŋge wamdus tiŋguwa le tane sakamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ait ta mbolŋge ande nu nuŋe tira nuŋe kumam tuku ŋgueu mbal tuku wai mbolŋge palmbimŋgat. Mam nu nuŋe kiŋo mbolŋge taŋawamŋgat. Kiŋo kame nane ina mam kat naŋgine kasurniŋmba kumwaig ŋga pasa mbolŋge patikamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tane yiŋe mbal tukunu nane ŋakmba tane kasurtiŋgamŋgaig. Ande nu saŋgri tiŋga dirnaŋga minwa ta Kuateŋge nu tuku muskil te-tiwe tambimŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tumbraŋ ande mbolŋge nane tane kilmba piti sertiŋguwaig ndeta tane kua ka tumbraŋ ande mbol kape. Ye siŋka satiŋgamŋgit. Tane taŋamba Israel mbal tuku tumbraŋ afu mbol kine ndakap le ye Ndindo Katesek Taŋgo prowamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Skul kiŋo nu nuŋe tisa li ndate. Piro taŋgo nu nuŋe suŋgo li ndate. ");
INSERT INTO ssd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kiŋo ande nu nuŋe tisa suk ko piro taŋgo ande nuŋe suŋgo suk mayok kuwa ta kumuŋ. Ye tane tuku Suŋgo ta nane ye bukla ŋaigonu tuku gabat Belsebul ŋgade. Ta tuku nane tane mata nyu sugo ŋaigonu taŋaŋ satiŋgamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Nane tane kilmba ŋaigo siglikade mbal tuku kuru kuru ndakap. Wam kame kile taŋgo am mbolŋge mine ndakade ta kilimok mayok kaŋgaig. Wam afu kuirok minig ta ŋakmba kila patikamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ye kuirka tane pasa satiŋget te tane pasa ta tumba maŋgur sinamŋge saniŋgap. Tane kile yabu pasa isig ta ŋakmba isam tuku kueŋka saniŋgap. ");
INSERT INTO ssd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nane tane tuku ŋgarosu bale faram sakade mbal tuku kuru kuru ndakap. Nane kanu balewam kumuŋ kuga. Kuate nu tane tuku ŋgarosu kanu turmba ma ŋayo mbolŋge pankam kumuŋ tukunu tane nu tuku ndo kuru-kurukap. ");
INSERT INTO ssd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Taŋgo nu sulik sulik armba maket mbolŋge patika ndametiŋ fudiŋndo ndo tate ta sulik sulik ŋakmba siŋgine Mam nu idusniŋmba nu wokate le ndo ande kumit. ");
INSERT INTO ssd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nu tane tuku gabat waŋe giganmba ta mata nu kila minit. ");
INSERT INTO ssd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ta tuku tane wam ande tuku kuru kuru ndakap. Kuate am mbolŋge tane sulik sulik gudommba liniŋmba mbolŋge minig. ");
INSERT INTO ssd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ande nu taŋgo ŋgamukŋge ye tuku nyu te-mayokmba sakate ta ye mata yiŋe Mam samba mbolŋge minit nu am mbolŋge taŋgo ta tuku nyu te-mayokamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ande nu taŋgo ŋgamukŋge ye tuku nyu yabukate ta ye mata yiŋe Mam samba mbolŋge minit nu am mbolŋge nu tuku nyu yabukamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tane ye wamdus ulendi maŋau kilke mbol mbal ŋgamukŋge palmbim tuku prowen ŋga idus ndawap. Ye kame bagi tumba nane tetkam tuku prowen. ");
INSERT INTO ssd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kiŋo nu mam nuŋe ndoŋ ko kulim nu ina nuŋe ndoŋ ko pino nu nuŋe rugan nuŋe ndoŋ nane taŋamba muŋgu purkam tuku ye prowen. ");
INSERT INTO ssd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Taŋgo tuku wande tuma mbal nu tuku ŋgueu mbal mayok kaŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ande nu ina mam ko kiŋo kat nuŋe tuku suŋgomba kume purmba ye tuku suŋgomba kume pur ndate ta nu ye tuku nyu ŋak minit ta nu denkate. ");
INSERT INTO ssd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Taŋgo ande nu ye tuku ŋga idusmba nu nuŋe miroŋ nuŋe ail kazrai kuramba ye dubi ndayate ta nu ye tuku nyu ŋak minit ta nu denkate. ");
INSERT INTO ssd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ande nu nuŋe abo mine mayewam tuku suŋgomba idusmba kurau mayete ta nu ŋgisikamŋgat. Ande nu ye tuku ŋga nuŋe abo mine mayewam tuku idus ndate ta nu siŋka nuŋe abo ta tumba ŋak minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ande nu tane auktiŋmba wakeikate ta nu ye mbolŋge mata taŋate. Ye mbol taŋate ta Mam nu ye kukulyina nu mbol mata taŋate. ");
INSERT INTO ssd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ande nu Kuate tuku tuan taŋgo minit le andeŋge nu aukmba wakeite ta nu tuan taŋgo ndoŋ lafu mayenu tamŋgat. Taŋgo ande nu taŋgo tiŋreknu minit le andeŋge nu aukmba wakeite ta nu taŋgo tiŋreknu ndoŋ lafu mayenu tamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ye siŋka satiŋgamŋgit. Ande nu nyu kugatok minmba ye dubiyanu taŋgo taŋaŋ minit le andeŋge nu kule tidonu ndo tuwit ta Kuate nu wam ta mata lafunu tambimŋgat ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus nu nuŋe dubinaig taŋgo 12 wam pagu pasa niŋge deŋpurmba nu tiŋga ma ta tuku tumbraŋ afu mbol pasa kuklimba wam pagukam kina. ");
INSERT INTO ssd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohanus nu muli wandek sinamŋge minmba Kristus nu wam afu ke likina ta ismba nu tuku pasa pilna le nuŋe dubiwanu taŋgo armba ka Yesus kusnanaik: ");
INSERT INTO ssd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ande nu prowam tuku kuyar pasa sakate ta ne e ko sine ande tairŋgube ŋginaik le ");
INSERT INTO ssd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","nu pasa lafumba sanikina: Ye wam ke liket te takile ammbi kaŋgerka kilbambi isik ta luka kumba ŋakmba Yohanus kubeu tape. ");
INSERT INTO ssd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kile am tukulok mbal mambilde. Kupe ŋaigoŋgade mbal likade. Ŋgirŋger ŋak mageke likade. Kilba tukulok pasa isig. Afu kume likade ta aboŋga tiŋgade. Sanzal mbal Kuate tuku pasa mayenu isig. ");
INSERT INTO ssd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ande nu ye tuku ŋga wamdus tero ndakate ta nu gare-gareka minit. Tale taŋamba ka Yohanus sawap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nale luka kinaik le Yesus nu ndek maŋgur suŋgo ta Yohanus tuku saniŋgina: Tane ame agaŋ kaŋgeram tuku ma baknu mbol kinaig? Bubreŋge ulem waŋe ande mbilmbilwa le tane kaŋgeram kinaig e? ");
INSERT INTO ssd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ko tane taŋgo ande tawi mayenu tiŋganu kaŋgeram kinaig e? Nane tawi magenu tiŋganu mbal wande sugo sinamŋge nyu ŋak minig tuku. ");
INSERT INTO ssd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tane ndaŋam tuku ma baknu mbol kinaig? Tane tuan taŋgo ande kaŋgeram kinaig e? Yohanus nu tuan taŋgo ta ye tane kila satiŋgamŋgit. Nu tuan taŋgo ndo kuga. Nu tuan taŋgo ŋakmba liniŋmba mbolŋge minit. ");
INSERT INTO ssd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kuyar pasa ande nu tuku teŋenmba sakate. Ne isa. Ye taŋgo ande kukuli le nu amboŋga prowa sulumba ne tuku ndin wakeiyamŋgat ŋgate. ");
INSERT INTO ssd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ye siŋka satiŋgamŋgit. Taŋgo ŋakmba Yohanus kule pisneŋge liniŋmba mbolŋge minit ta Kuate tuku gageu mayok kinig mbal ŋakmba nane Yohanus lide. Afu nyu kugatok mata. ");
INSERT INTO ssd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Moses tuku tukul tuan taŋgo kame nane Kuate nu nuŋe gageu kulatkam tuku dir pasa ndo saka ka Yohanus mbolŋge dikŋginaig. Yohanus tuku ait mbolŋge tugu pilmba taŋgo pino gudommba Kuate tuku gageu mayok kambim tuku saŋgri tiŋga muŋgu signa-signaŋga mburerika kile minig. ");
INSERT INTO ssd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kuate nu nuŋe gageu kulatkate wam ta pro ndawa le Elia nu amboŋga prowam tuku kuyar pasa sakate ta Yohanus tuku sakate. Tane pasa te ismba son ŋgade e? ");
INSERT INTO ssd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tane kilba ŋak ndeta pasa te isap. ");
INSERT INTO ssd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tane ait te mbolŋge minig mbal tane tuku maŋau ta ame wam taŋaŋ ŋga saki. Tane kiŋo kame maket mbolŋge minyoka muŋgu wiwikade taŋaŋ. Nane teŋenmba muŋgu wiwikade: ");
INSERT INTO ssd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Sine tabu tabu fitka mune uleg ta tane ndek kupes kupes ndade. Sine maŋ malmbikeg ta tane ndek malmbiketket ŋga lok mine ndakade ŋgade. ");
INSERT INTO ssd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ata. Yohanus nu prona sulumba nyamagaŋ ko grep kule nye ndaka minna le nu bukla ŋayonu ŋak ŋga saka nu mbulnaig. ");
INSERT INTO ssd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ye Katesek Taŋgo ye pro nyamagaŋ le grep kule nyet le tane sakade: Ai si. Nu nyamagaŋ grep kule nyam tuku piririte taŋgo. Nu takis kilanu mbal une ŋak mbal ndoŋ gulab mayete ŋga tane ye mata mbulig. Ata. Wamdus kuyar mayete taŋgo wam ke likate ta mbolŋge nu tiŋreknu kilimok mayok kinit ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tumbraŋ afu Yesus nu buk nane ŋgamukŋge wam kitek saŋgrinu ke likina ta nane ŋgamuŋgal biye mbil ndanaig tukunu kile nu nane kilmba saniŋge likina: ");
INSERT INTO ssd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Korasin tumbraŋ le Betsaida tumbraŋ ose. Ye wam kitek saŋgrinu tale ŋgamukŋge ke liken ta ande nu wam ndui ta Tirus le Sidon ŋgamukŋge ke likina kande nane dal ndaka naŋgine mbar tuku ŋgamuŋgal biye mbilmba nane tawi urfunu tiŋmba kuke tugu pismba taŋanaig kande. ");
INSERT INTO ssd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ye siŋka satiŋgamŋgit. Ait suŋgo mbolŋge tale Korasin le Betsaida tumbraŋ tale Sidon le Tirus tuku pa limba tale suŋgo pasa ŋak tamŋgaik. ");
INSERT INTO ssd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kaperneum tumbraŋ ne nyu suŋgo ŋak minmba ne samba mbol kambim tuku ŋga iduste e? Kuateŋge ne tumba bukŋguwa le ne kumanu mbal tuku tumbraŋ kaŋgat. Ye wam kitek saŋgrinu tane ŋgamukŋge ke liken ta ande nu wam ndui ta Sodom tumbraŋ ŋgamukŋge ke likina kande nane ŋgamuŋgal biye mbilmba kile minig kande. ");
INSERT INTO ssd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ye tane satiŋgamŋgit. Ait suŋgo mbolŋge tane Kaperneum mbal Sodom tuku pa ta limba tane suŋgo pasa ŋak tamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ait ta mbolŋge ndo Yesus nu sakina: O Mam, ne samba kilke tuku Suŋgo. Ye ne tuku nyu te-duŋget. Afu kila sugo wamdus kuyar ŋak ne naŋe wam kame tum ndaniŋgit. Kiŋo kame taŋaŋ minig mbal ne nane ndo tumniŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O Mam, ne naŋe nzali dubimba ne taŋate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kile Yesus nu nane saniŋgina: Mam nu wam ŋakmba ye wai mbolŋge patikina. Ande nu Kuate tuku Kiŋo kila mine ndakate. Mam nu ndo ye kila. Ande nu Mam kila mine ndakate. Ye nu tuku Kiŋo ye ndo nu kila. Ye nane afu Mam kila pilwaig ŋga nu tumniŋget ta nane mata nu kila minig. ");
INSERT INTO ssd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tane piro kareŋka agaŋ pitinu kuramba poska minig mbal tane ye tugum te yalpe le yeŋge muskil kile-tidiŋge tiŋgi. ");
INSERT INTO ssd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ye wamdus bafuk ŋak minmba ŋgan mukuk minet tukunu tane ye tuku pasa kumnemŋge minap le tane tumtiŋgi le tane mabtap. ");
INSERT INTO ssd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ye tuku miŋge pasa ta piti kuga. Ye tane mbolŋge agaŋ pilet ta buloknu ndo ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kusem ait ande mbolŋge Yesus nane wit piro ande sinam sinam lika nuŋe dubinaig mbal gubaniŋgina le nane wit alonu supika nyam nyam kinaig le ");
INSERT INTO ssd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisi mbal afuŋge nane kaŋgerka nane Yesus sanaig: Ai si. Naŋe dubinade mbal sine tuku tukul lukamba kusem ait mbolŋge nane nyamagaŋ kilig ŋga sanaig. ");
INSERT INTO ssd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Taŋakinaig le nu ndek nane saniŋgina: David nuŋe mbal ndoŋ nane guba ŋaigoniŋgina le nu wam ande kina ta tane kuyar ta burkade tae. ");
INSERT INTO ssd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nu Kuate tuku wandek sinam kina sulumba tukul bret Kuate am mbolŋge patikinaig ta afu kilmba pro nuŋe mbal ndoŋ nyinaig. Bret ta taŋgo nane nye ndakade tuku. Pris mbalŋge ndo nyade tuku. ");
INSERT INTO ssd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pris mbal mata nane kusem ait mindek kusem wande suŋgo sinamŋge pirokade ta nane mbar ndade. Moses nu nane taŋamba kam kumuŋ ŋga kuyarna ta tane kila. ");
INSERT INTO ssd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tane isap. Ande nu kile tane ŋgamukŋge minit ta nu kusem wande suŋgo ta limba nu mbolŋge minit. ");
INSERT INTO ssd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kuate tuku kuyar pasa ande teŋenmba sakate. Tane ye tuku ŋga agaŋmor kilmba atraukade ta ye suŋgomba idus ndawet. Tane taŋgo sinaniŋmba nzaliniŋgam tuku ye suŋgomba iduset ŋgate. Tane kuyar pasa ta tugunu katesede kande tane ye dubiyanu mbal te pasa mbolŋge pati ndakade kande. ");
INSERT INTO ssd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ye Ndindo Katesek Taŋgo ye kusem ait tuku gabat minet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus nu taŋamba tiŋga kumba nane tuku kusem wandek sinam kina. ");
INSERT INTO ssd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Sinam taŋge taŋgo ande wai kummba pagriŋganu ŋak minna le Farisi mbal nane Yesus tumba pasa mbolŋge palmbim saka nu kusnanaig: Sine siŋgine tukul maŋau dubimba kusem ait mbolŋge guaze taŋgo ande wakeiwam kumuŋ e ŋga kusnanaig le ");
INSERT INTO ssd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","nu ndek nane saniŋgina: Tane tuku ande nu sipsip ndindo ŋak minit le kusem mbolŋge nu bariŋga burok sinam ndekate ta nu kusem ŋga idusmba tam tuku piro ndakate e? ");
INSERT INTO ssd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ata. Taŋgo nu siŋka sipsip lite. Ne kusem ait mbolŋge ande turte ta ne tukul luka ndate ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Taŋakina sulumba kile nu ndek taŋgo ta sana: Ne wai kuitka ŋgina le nu wai kuitka wai mayekina. Nuŋe wai inum taŋaŋ mayok kina. ");
INSERT INTO ssd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Taŋana le Farisi mbal nane mayok ka Yesus balewam tuku pasa katmba ndin sotinaig. ");
INSERT INTO ssd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesus nu Farisi mbal tuku wamdus ta katesemba nu ma ta kusremba ma ande mbol kina le taŋgo pino gudommba nu dubinaig. Nu nane tuku guaze wakeike likina sulumba ");
INSERT INTO ssd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","nu nane mbolŋge maŋau ke likina ta afu sa ndaniŋguwaig ŋga miŋge pipniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nu taŋana ta tuan taŋgo Aisaia tuku kuyar pasa ande kumuŋgina. Nu teŋenmba Kuate tuku miŋge kuyarna. ");
INSERT INTO ssd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Tane isap. Taŋgo te nu ye tuku piro taŋgo. Ye nu madiwen. Ye nu tuku kume purmba nu tuku gare toret. Ye yiŋe Guwa nu tuwi le nu ye tuku maŋau tiŋreknu kasomok mbal ŋakmba saniŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nu afu ndoŋ kualeyau ndaka miŋge fetke nda. Nu ndinmba siŋsiŋ likuwa le ande nu tuku pasa ise nda. ");
INSERT INTO ssd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ande nu ulem taŋaŋ isunu baklelkanu minwa le nu ŋgurmba bukŋge nda. Ko ande nu bulu taŋaŋ kupam bafumba fudiŋmba buluŋga minwa le nu fuwe nda. Nu taŋamba minmba ma ma nu wam ŋakmba kile-ibeŋka maŋau tiŋreknu ndo te-mayokamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kasomok mbal ŋakmba nu sine muskil kile-tidiŋge siŋguwa ŋga nu tairŋga minamŋgaig. Aisaia nu taŋamba kuyarna. ");
INSERT INTO ssd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Taŋgo ande buklaŋge nu tuku am miŋge tukulnikina ta nane mindemba Yesus tugum pronaig le nu taŋgo ta wakeina le nu mambilmba pasatina. ");
INSERT INTO ssd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Taŋana le taŋgo pino ŋakmba pirerek purka ndek sakinaig: i ... Taŋgo te David tuku mbuŋ e ŋga saka minnaig le ");
INSERT INTO ssd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisi mbal nane pasa ta ismba ndek sakinaig: A ... bukla kame tuku gabat Belsebulŋge nu saŋgri ta tuwit le nu bukla pitaike likate ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kile Yesus nu nane tuku wamdus ta katesemba saniŋgina: Gabat suŋgo ande tuku kuasmbi nane pur yimyamka naŋgine naŋgine kame buwaig ta nane kugawamŋgaig. Tumbraŋ mbal ko wande tuma mbal nane pur yimyamka naŋgine naŋgine kame buwaig ta nane saŋgri ŋak minam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Taŋamba ndo Satan nu nuŋe mbal afu pitaikate kande nane pur yimyamka naŋgine naŋgine kame bumba Satan nu saŋgri ŋak mine ndakate kande. ");
INSERT INTO ssd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tane ye Belsebul tuku saŋgrimbi bukla pitaikanu sakade e? Taŋgine mbal afu bukla pitaikade ta nane mata Belsebul tuku saŋgrimbi taŋade e? Nane kusnaniŋgap le nane tuku pasa lafunu tambi taŋgine pasa ta pilewaig. ");
INSERT INTO ssd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ye Kuate tuku Guwa tuku saŋgrimbi bukla pitaiket ta Kuate nu nuŋe gageu kulatkate wam tane ŋgamukŋge buk prote. ");
INSERT INTO ssd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Taŋgo saŋgrinu ande nuŋe wande kulatkate ta ande pro nu tuku agaŋ ndende kuayaram kumuŋ kuga. Nu taŋgo saŋgrinu ta ndaleka te-ibeŋwa sulumba ndo agaŋ ndende ta kilam kumuŋ. ");
INSERT INTO ssd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ande nu ye tuku taŋgo mine ndakate ta nu ye tuku ŋgueu taŋgo. Ande nu ye tur ndayumba ake minit ta nu ye tuku piro ŋayo silite. ");
INSERT INTO ssd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tane isap. Taŋgo tuku une maŋau tumail panniŋgig maŋau ta Kuate nu ŋakmba sauka gilaiŋgate tuku. Ande nu Tukul Guwa tumail pante ta Kuate nu mbar ta gilaiŋge nda. ");
INSERT INTO ssd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ande nu ye Ndindo Katesek Taŋgo tala pasa sayate ta Kuate nu mbar ta sauka gilaiŋgate tuku. Ande nu Tukul Guwa tala pasa tuwit ta Kuate nu ait te mbolŋge ŋgumneŋga mata mbar ta sauka gilaiŋge nda. ");
INSERT INTO ssd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ail alonu magenu kaŋgerka ail ta ŋayonu ŋga sa ndakap. Ko ail alonu ŋaigonu kaŋgerka ail ta mayenu ŋga sa ndakap. Sine ail alonu kaŋgerka ail ta tuku tugu kateseweg. ");
INSERT INTO ssd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ŋgamuŋgal sinamŋge wamdus minig ta miŋge mbolŋge kilimok alonu mayok kinig. Tane mbeŋ ŋaigonu tuku fat. Tane taŋgo ŋaigonu tukunu tane pasa mayenu inum te-mayokam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Taŋgo mayenu nu nuŋe ŋgamuŋgal mayenu minit sulumba nu ndek wam magenu ndo ke likate. Taŋgo ŋayonu nu nuŋe ŋgamuŋgal ŋayonu minit sulumba nu ndek wam ŋaigonu ndo ke likate. ");
INSERT INTO ssd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tane isap. Taŋgo fare ake wamdusmbi sakade ta pileniŋgam tuku ait mbolŋge nane naŋgine pasa ta ŋakmba Kuate am mbolŋge kile-mayokkamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ne pasa sake likate ta mbolŋge Kuate nu ne pileŋga lafunu tanmbimŋgat ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kile kusem pasa bitekŋganu mbal nane Farisi ndoŋ Yesus sanaig: Tum Taŋgo, ne maŋau kitek saŋgrinu ande te-mayoka le sine kaŋgerbe ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","nu ndek nane saniŋgina: Tane siŋka mbal ŋaigonu Kuate ŋgumnede tuku. Tane ye tuku saŋgri kaŋgeram idusde ta ye tane tumtiŋge nda. Wam saŋgrinu ande tuan taŋgo Yona mbolŋge prona ta ndo tumtiŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona nu kualegaŋ suŋgo tuku fuŋgul sinamŋge mara keŋmba minna. Taŋamba ndo ye Ndindo Katesek Taŋgo ye kilke sinamŋge mara keŋmba minamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yona nu maŋ mayok ka Nineve mbal riroŋ pasa saniŋgina le nane ndek ŋgamuŋgal biye mbilnaig. Ande teŋge minit ta nu Yona lite ta tane nu tuku pasa pitaide. Ta tuku ait suŋgo mbolŋge tane ait te mbolŋge minig mbal Nineve mbal ndoŋ tiŋgap le Nineve mbal tuku maŋau mayenuŋge tane tuku maŋau ŋayonu te-mayokamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","O buk mandor pino ande Siba kilke kulatkina ta nu Solomon tuku wamdus kuyar mayenu isam tuku ndin kuen ŋayo dubimba nu tugum kina. Ande teŋge minit ta nu Solomon lite ta tane nu tuku pasa ise ndakade. Ait suŋgo mbolŋge tane ait te mbolŋge minig mbal pino ta ndoŋ tiŋgap le nu tuku maŋau mayenuŋge tane tuku maŋau ŋayonu te-mayokamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Andeŋge guwa ŋayonu taŋgo ande mbolŋge pitaite le nu ka ma baknu mbol kumba mabta minam tuku ma sota kine promba lika ka kuga le nu sakate: ");
INSERT INTO ssd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yiŋe buk minen tuku wande mbol maŋ luka ka ŋgate. Nu pro nane buk firfir gureŋmba agaŋ ndende ŋakmba kile-tidiŋga patikinaig le wande ta ŋgaskolnu minit le kaŋgerte. ");
INSERT INTO ssd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nu kaŋgermba saŋgri tiŋga minam tuku ta nu kumuŋ kuga le nu kumba ka nuŋe kuasmbi 7 nane nu tuku maŋau liwanu ta kilmba luka pro wande ta mbolŋge minig. Taŋade le taŋgo ta tuku mine maŋau ambokok limba kile ŋayonu suŋgokanu sinamŋge minit. Wam ndui ta ndo tane maŋau ŋaigonu kade mbal tane mbolŋge prowamŋgat ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus nu taŋamba pasata minna le ina nuŋe mambo kat nuŋe pro mayok taŋge nu tuku pasa pilnaig le ");
INSERT INTO ssd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ande nu Yesus sana: Ina naŋe mambo kat naŋe pro kilimŋge minmba ne kusnaŋgade ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Taŋakina le nu taŋgo ta sana: Ne yiŋe ina yiŋe mambo kame tuku sayate e ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","wai tok nuŋe dubinaig kuasmbi deŋniŋmba sakina: Mbal te yiŋe ina yiŋe mambo kame taŋaŋ minig. ");
INSERT INTO ssd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yiŋe Mam nu samba mbolŋge minit ima nu nu tuku nzali dubite ta nu yiŋe maib kulim ina taŋaŋ minit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yesus nu ki ndui ta mbolŋge wande kusremba kina ka kule kualiŋ piyal taŋge minyok minna le ");
INSERT INTO ssd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","maŋgur sugo nu te-ŋgamumba maŋgurkinaig le nu ndek waŋ ande poŋga ta mbolŋge minyoka pasa niŋmba minna le nane piyal taŋge tiŋga pasa isnaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nu yaba pasambi wam gudommba saniŋgina sulumba sakina: Taŋgo ande nu agaŋ tumunu bareŋniŋgam piro mbol kina. ");
INSERT INTO ssd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kina ka bareŋniŋgina ta tiŋnu afu ndinŋge ndeke likinaig ta sar umaŋŋge pro nye sulunaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tiŋnu afu kilke ndame ŋak ma mbolŋge ndeke likinaig ta kilke fudiŋndo tukunu pitik ndo maŋge pronaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pronaig ta ki suŋgo promba pasokina le sumbailnu sinam nzi kine ndakinaig tukunu kareŋga kume sulunaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tiŋnu afu ma aŋga ŋaigonu sinamŋge ndeke likinaig ta aŋgaŋge tiŋga soŋginaig le rure-rureka pro mage ndanaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tiŋnu afu kilke mayenu mbolŋge ndeke likinaig ta ndo alo magenaig. Tugunu mindek mbolŋge afu alonu 100 afu 60 afu 30 taŋamba taŋamba alonaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tane kilba ŋak ndeta pasa te isap ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kile nuŋe dubinaig mbal Yesus tugum promba nu kusnanaig: Ne ndaŋam yaba pasambi ndo nane saniŋgit ŋga kusnanaig le ");
INSERT INTO ssd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","nu ndek nane saniŋgina: Kuate nu nuŋe gageu kulatkate wam afu kuirok minig ta tane kila palmbim tuku ye tane maditiŋgen. Nane afu wam ta kila pilwaig ŋga madi ndaniŋgen. ");
INSERT INTO ssd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ande nu wam afu ŋak minit ta Kuateŋge nu maŋ lato tuwit le nu suŋgomba ŋak minit. Ande nu wam denkanu minit ta Kuateŋge nuŋe wam fudiŋndo ta yaite. ");
INSERT INTO ssd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ye yaba pasambi ndo pasa saniŋget ta tugunu teŋenmba. Nane wam afu kaŋgerka alonu kaŋger ndakade. Nane isig sulumba ise ti ndamba tugunu katese ndade. ");
INSERT INTO ssd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tuan taŋgo Aisaia nu dir pasa kuyarna ta nane siŋka kumude. Nu Kuate tuku miŋge teŋenmba kuyarna. Tane pasa isamŋgaig ta tugunu katesewe nda. Tane wam afu kaŋgerkamŋgaig ta alonu kaŋger tiwe nda. ");
INSERT INTO ssd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mbal te nane tuku ŋgamuŋgal tukulok. Nane kilba tukulniŋgig. Nane am tukulok minig. Kuga ta nane ammbi alonu kaŋgermba kilbambi tugunu ismba wamdus puluniŋguwa le ŋgamuŋgal biye mbilmba ye tugum prowaig le wakeikamŋgit. Aisaia nu taŋamba kuyarna. ");
INSERT INTO ssd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tane Kuateŋge make patikate le tane wam magenu kaŋgerka pasa mayenu isig. ");
INSERT INTO ssd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ye siŋka tane satiŋgamŋgit. Tuan taŋgo kame mbal tiŋreknu tane wam kaŋgerka isig te nane kaŋgerka isam tuku wamdus suŋgo pilmba kume farnaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kile Yesus ndek nane saniŋgina: Taŋgo nu nyamagaŋ tumunu bareŋniŋgina ŋgit pasa ta tugunu satiŋgi le isap. ");
INSERT INTO ssd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tiŋnu afu ndinŋge ndeke likinaig ŋgit ta mbal afu taŋaŋ. Nane Kuate tuku gageu mayok kambim tuku pasa ta ismba katese maye ndade le Satanŋge pro nane tuku ŋgamuŋgal sinamŋge pasa ta yaika tumba balete. ");
INSERT INTO ssd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tiŋnu afu kilke ndame ŋak mbolŋge ndeke likinaig ŋgit ta mbal afu taŋaŋ. Nane Kuate tuku pasa ismba nzali suŋgo ŋak pitik ndo tade sulumba ");
INSERT INTO ssd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","nane sumbailnu kugatok taŋaŋ ait fagnu ndo dubide. Nane pasa ta dubide ta afuŋge piti serniŋgig le nane pitik ndo kusrede. ");
INSERT INTO ssd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tiŋnu afu ma aŋga ŋaigonu sinamŋge ndekinaig ŋgit ta mbal afu taŋaŋ. Nane Kuate tuku pasa isig ta kilke te tuku piti agaŋ ndende kilam tuku nzali wamdus ta ŋak minig le pasa isig ta balete le alo ndate. ");
INSERT INTO ssd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tiŋnu afu kilke mayenu mbolŋge ndekinaig ta nane afu Kuate tuku pasa ismba katesede taŋaŋ. Nane katesemba minig sulumba alo kile-mayokka afu alonu 100 afu 60 afu 30 taŋamba taŋamba kile-mayokkade ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus nu yaba pasa ande teŋenmba saniŋgina: Kuate nu taŋgo pileŋga nuŋe gageu kilit wam ta taŋgo ande nuŋe piro mbolŋge wit tiŋnu bareŋniŋgina taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bareŋniŋgina le furirna le nane kinye sulunaig le nuŋe ŋgueu taŋgoŋge aŋga ŋaigonu tiŋnu kilmba pro nu tuku piro mbol taŋge bareŋniŋmba nu kua ka kina. ");
INSERT INTO ssd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wit ta tiŋga ka koknaig le aŋga ŋaigonu mata kilimok mayok kinaig le nuŋe piro mbalŋge kaŋgerkinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","kumba ka piro miro taŋgo sanaig: Suŋgo, ne wit tumunu magenu ŋguke likina ta ndaŋam kile aŋga ŋaigonu turmba prode ŋga sanaig le ");
INSERT INTO ssd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","nu ndek nane saniŋgina: A ... ŋgueu taŋgo andeŋge taŋana ŋgina. Taŋakina le nane nu kusnanaig: Sine ka aŋga ta fulkube e ŋginaig le nu saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kuga. Tane aŋga ŋaigonu ta fulkam saka ka mbarmba wit turmba fulkubekaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aŋga ŋaigonu ta ulendika minwaig le ait kumuŋguwa le ye piro mbal teŋenmba saniŋgamŋgit: Tane amboŋga ka aŋga ŋaigonu ta fulka pa mbolŋge pannu tuku ndaleka patikap sulumba wit kilmba nyamagaŋ wandekŋge patikap ŋga saniŋgamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus nu maŋ yaba pasa ande teŋenmba saniŋgina: Kuate tuku gageu tugeka suŋgokate wam ta mastet tiŋnu taŋgo andeŋge tumba ka nuŋe piro mbolŋge ŋgukina taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet tiŋnu ta agaŋ ŋai fudiŋndo agaŋ tumunu ŋakmbaŋge nu liwanu ta nu promba suŋgoka nu kumzaŋel ail ŋakmba liniŋmba nu ail suŋgo taŋaŋ mayok kinit. Sar umaŋ pro wainu mbolŋge te patikade ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Taŋamba nu maŋ lato yaba pasa ande teŋenmba saniŋgina: Kuate tuku gageu taŋgo ŋgamukŋge minig wam ta yis pino andeŋge tumba plaua sinamŋge pilna taŋaŋ. Yis ta plaua ŋakmba ulmba silina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus nu wam ta ŋakmba yaba pasambi ndo maŋgur suŋgo ta saniŋgina. Nu pasa ande te-mayokmba sa ndakina. ");
INSERT INTO ssd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nu taŋana ta tuan taŋgo ande o buk pasa sakina ta kumuŋgina. Pasa ta teŋenmba. Ye yaba pasambi pasa sakamŋgit. Tugu mbolŋge wam kame kuirok mine likinaig kile taŋamba minig ye wam kame ta kile-mayokkamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kile Yesus nu tiŋga maŋgur suŋgo ta kusreka kina ka wande poŋgina le nuŋe dubinaig mbal pro nu sanaig: Ne aŋga ŋaigonu tuku yaba pasa sakat ta tugunu te-mayokmba sasiŋga le sine isbe ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Taŋakinaig le nu ndek nane saniŋgina: Taŋgo wit tumunu ŋgukina ŋga sakit ta ye Ndindo Katesek Taŋgo. ");
INSERT INTO ssd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Piro ma ta kilke te. Wit tiŋnu magenu ta Kuate tuku gageu. Aŋga ŋaigonu ta Satan tuku gageu. ");
INSERT INTO ssd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ŋgueu taŋgo aŋga ŋaigonu ŋgukina ŋga sakit ta Satan. Wit alonu kilam tuku ait sakit ta kugawam tuku ait. Wit alonu kilam tuku mbal nane Kuate tuku eŋel kame. ");
INSERT INTO ssd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nane aŋga ŋaigonu fulka ndaleka pa mbolŋge pankade ŋgit ta kugawam tuku ait mbolŋge taŋamba mayok kaŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ye Ndindo Katesek Taŋgo ye yiŋe eŋel kukulniŋgi le nane pro yiŋe gageu mine ndaka wam ŋaigonu ke likade mbal nane afu mata mbarwaig ŋga didikade ta nane kilmba ");
INSERT INTO ssd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","pankuwaig le pa suŋgo mbol kaŋgaig. Ma ta mbolŋge minamŋgaig mbal nane malmbi suŋgomba maketiŋ tikŋga minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ait ta mbolŋge mbal tiŋreknu nane naŋgine Mam kulatkate ma mbolŋge ki taŋaŋ buluŋga minamŋgaig. Tane kilba ŋak ndeta pasa te isap. ");
INSERT INTO ssd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kuate tuku gageu mayok kambim tuku wam suŋgo ta yaba pasa te suk. Taŋgo ande kilke sarka agaŋ mayenu piya o mbolŋge nane kilkek sinamŋge yubeŋginaig ta kaŋgerna. Kaŋgermba nu maŋ burok tukulmba nu gare ŋak kumba nuŋe agaŋ ndende ŋakmba piyate sulumba ndametiŋ kilmba ka kilke ta piyamba nuŋe tate. ");
INSERT INTO ssd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kuate tuku gageu mayok kambim tuku wam suŋgo ta yaba pasa ande te suk. Taŋgo ande nane afu tugumŋge igog tiŋ magenu sota piyamba likate. ");
INSERT INTO ssd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nu igog tiŋ inum maditaknu piya o mbolŋge kaŋgermba nu kumba nuŋe agaŋ ndende ŋakmba kilmba piyana sulumba ndametiŋ kilmba ka igog tiŋ mayenu ta piyamba tina. ");
INSERT INTO ssd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kuate nu taŋgo pileŋga nuŋe gageu kilig wam ta yaba pasa te suk. Nane afu kumaŋ yu sinamŋge bukŋginaig le kualegaŋ gudommba yeki yeki kumaŋ sinam kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kumaŋ kumuŋgina le nane didika tumba tabekŋge minyoka kualegaŋ ta pileŋga magenu nza sinamŋge patika ŋaigonu ta kilmba pankinaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kugawam tuku ait mbolŋge maŋau taŋamba ndo mayok kaŋgat. Eŋel kame nane pro taŋgo pileŋga magenu kusreka ŋaigonu kilmba ");
INSERT INTO ssd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","pankuwaig le pa suŋgo mbol kaŋgaig. Ma ta mbolŋge minamŋgaig mbal nane malmbi suŋgomba maketiŋ tikŋga minamŋgaig ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kile Yesus nu nane kusnaniŋgina: Tane pasa kame satiŋgit ta tane tugunu katesede e ŋgina le nane au ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Taŋakinaig le nu ndek saniŋgina: Kusem pasa bitekŋganu taŋgo ande Kuate tuku kuasmbi mayok kumba ye dubiyate ta nu wande miro taŋgo taŋaŋ. Nu nuŋe wandekŋge agaŋ ndende urfunu kiteknu turmba kile-mayokkate taŋaŋ ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus nu yaba pasa sake deŋpurna sulumba nu tiŋga ma ta kusremba ");
INSERT INTO ssd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","luka nuŋe tumbraŋ tuguk prona. Pro taŋge nu nane tuku kusem wande sinam kumba pasa kuklina le nane ndek pirerek purka sakinaig: i ... Nu ima tugumŋge kila suŋgo ta tina? Imaŋge nu saŋgri tuna le nu wam saŋgrinu te ke likate? ");
INSERT INTO ssd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nu sine tuku wande pilit taŋgo ta tuku kiŋo nuŋe ndo. Ina nuŋe Maria. Nu tuku mambo kat nuŋe Yakobus Yosef Simon Yudas sine nane ŋakmba kila mineg. ");
INSERT INTO ssd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kulim kat nuŋe mata tumbraŋ tekok. Nu aniŋge saŋgri ta tina ŋga saka minmba ");
INSERT INTO ssd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","nu talamba gubra tinaig le nu nane saniŋgina: Kuate tuku tuan taŋgo nane ŋakmbaŋge nu tuku nyu te-mayokde. Nuŋe tumbraŋ tuguk nuŋe tugu ndare tuma kat nuŋe naneŋge ndo nu talade ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nane nu talanaig tukunu Yesus nu nane ŋgamukŋge wam saŋgrinu suŋgomba ke ndakina. ");
INSERT INTO ssd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ait ta mbolŋge Yesus tuku nyu suŋgoka tugekina le Galilea ma tugu kulatkanu mandor Herodus Antipas nu wam ta ismba ");
INSERT INTO ssd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nuŋe piro mbal saniŋgina: Taŋgo ta nu Yohanus kule pisne inde. Nu kummba maŋ aboŋga tiŋgina. Ta tuku nu saŋgri kitek ŋak wam ta ke likate ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Yohanus kumna ta tugunu teŋenmba. Herodus nu mambo nuŋe Filipus tuku pino Herodias yaina le Yohanus nu Herodus sawe lika sana: Ne tukul lukamba mbarte ŋga sawe lika minna. Taŋana le Herodus nu nane afu kukulniŋgina le Yohanus biye timba ndaleka tumba muli wandekŋge pilnaig. ");
INSERT INTO ssd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nu Yohanus balewam bafuna ta taŋgo pino nane Yohanus tuan taŋgo ŋginaig tukunu nu kuru-kuruka muli wandekŋge ndo kusrena. ");
INSERT INTO ssd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kile Herodus ina nuŋeŋge te-pilna ait ta kumuŋga mayok kina le Herodias kulim nuŋe nu maŋgurkinaig mbal am mbolŋge kupesna le Herodus nu nzalina sulumba sana: ");
INSERT INTO ssd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ye siŋka ki am mbolŋge ne sanet. Ne ame agaŋ nzalinu tam saka ta ye ne tanmbimŋgit ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Taŋaka sana le nu mayok kina le ina nuŋe nu wam paguna le nu pro Herodus sana: Yohanus kule pisne gabatnu nza ŋak sa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodus nu pasa ta ismba ŋgamuŋgal pitina ta nu buk pasa saŋgri pilena le nane ŋakmba isnaig tukunu nu taŋgo afu kukulniŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","nane muli wandek kumba Yohanus ŋinfok kat purmba ");
INSERT INTO ssd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","gabatnu nza ŋak tumba pino mbanzo tunaig le nu ndek tumba ka ina nuŋe tuna. ");
INSERT INTO ssd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Taŋanaig le Yohanus dubiwanu kuasmbi nane wam ta ismba nane kumba ka mindesiŋ ta tumba ŋgukinaig sulumba ka Yesus kila sanaig. ");
INSERT INTO ssd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesus nu pasa ta ismba nu tiŋga waŋ ande poŋga kumba ka ma yamok kina le taŋgo pino gudommba Yesus nu kina pasa ta ismba naŋgine tumbraŋ kusreka ndinmba nu dubinaig. ");
INSERT INTO ssd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kile Yesus nu ka ibeŋ ka nu taŋgo gudommba kaŋgerka nu nane sinaniŋgina sulumba afu guaze ŋak ta wakeike likina. ");
INSERT INTO ssd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ki butuŋgina le nuŋe dubiwanu taŋgo pro nu sanaig: Sine ma baknu mbolŋge mineg. Buk furirte. Ne maŋgur te kukulniŋga le kuwaig ka tumbraŋ afu mbolŋge nyamagaŋ piyaniŋmba nyuwaig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","nu ndek saniŋgina: Tane ndaŋam nane kuwaig ŋga sakade. Taneŋge isukusneniŋgap ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","nane lafumba Yesus sanaig: i ... Sine bret 5 kualegaŋ kareŋganu armba ndo ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","nu ndek nane saniŋgina: Kilmba yalpe ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kile Yesus nu taŋgo pino nane pibi mbol taŋge minyokuwaig ŋga saniŋgina. Nane minyokinaig le nu bret foŋfoŋ kualegaŋ ta turmba kilmba tandeka samba mbol ambe mambilmba Kuate gare pasa tumba bret fetfetmba nuŋe dubinaig mbal niŋgina le nane walmba niŋge likinaig le ");
INSERT INTO ssd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","nane kilmba nyumba maroniŋgina. Nane bret fetfetna ta bateŋnu kilmba sambe 12 ligneniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Isukusnaig taŋgo ta gudommba 5,000 taŋaŋ. Pino kiŋo kame afu mata turmba minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kile Yesus nu nuŋe dubiwanu taŋgo saniŋgina: Tane amboŋga waŋ poŋga luka kule kualiŋ sim kape le ye kuasmbi te kukulniŋgi le kuwaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nu taŋgo pino kukulniŋgina le kinaig le nuŋe ndo tabe poŋga Kuate ndoŋ pasatam kina ka nuŋe mata taŋge minna le buk furirna. ");
INSERT INTO ssd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nuŋe dubiwanu taŋgo nane waŋ ŋak kumba minnaig le bubre suŋgo tumailamŋge pro waŋ te-lukina. Nane kule kualiŋ ŋgamuŋge minnaig le kule mbalo waŋ katmba minna. ");
INSERT INTO ssd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Taŋamba minna le ma ma mafewam patukina le Yesus nu kumba kule mbol mbol lika nane tugum kina. ");
INSERT INTO ssd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nane nu kule mbol mbol lika ilna ta kaŋger ti ndamba mindekanu ande ilit ŋga nane kuru kuru ŋayomba wikaraunaig le ");
INSERT INTO ssd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesus nu pitik ndo wika nane saniŋgina: Tane kuru kuru ndakap. Te yeŋge. Tane wamdus bulka piti ndatiŋguwa ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrus nu ndek sana: Suŋgo, siŋka neŋge e? Taŋamba kande ne ye saya le ye mata ne sota kule mbol mbol ili ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","nu ndek yale ŋgina. Yale ŋgina le Petrus nu waŋ ta kusremba gurdukŋga kule mbolŋge tiŋga lika Yesus tugum kina. ");
INSERT INTO ssd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nu kumba minna sulumba nu bubre suŋgo ta kaŋgermba kuru-kuruka nu buto kambim bafuna sulumba wika sakina: Suŋgo, ye turya ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Taŋakina le nu pitik ndo Petrus pakarka biymba te-duŋga nu sana: Ne ndaŋam ye tuku saŋgri tuku wamdus terokate? Ne ye kumuŋ kuga ŋga iduste e ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Taŋamba nale waŋ poŋginaik le kule bubre kugana le ");
INSERT INTO ssd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","waŋ mbolŋge minnaig mbal nu mbariŋmba sanaig: Ne siŋka Kuate tuku Kiŋo ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nane kumba ka kule kualiŋ pakarka Genesaretŋge ibeŋ kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ibeŋ kinaig le Genesaret mbal nane Yesus kila pilmba afu kukulniŋginaig le naŋgine tumbraŋ ŋakmba kumba ka kila saniŋginaig le guaze mbal ŋakmba kilmba nu tugum prowe likinaig. ");
INSERT INTO ssd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nane Yesus sarsarmba guaze mbal nu tuku tawi nzalenu ndo kiremba mayekam tuku sanaig. Taŋamba nane nu tuku tawi nzalenu kirenaig mbal ta ŋakmba mageke likinaig. ");
INSERT INTO ssd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farisi kusem pasa bitekŋganu mbal ndoŋ Yerusalemŋge ndeka Yesus tugum promba nu kusnanaig: ");
INSERT INTO ssd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ndaŋam saka ne dubinade taŋgo wa mbuŋ kame tuku tukul lukamba nane wai minya ndaŋga isukusig ŋga sanaig le ");
INSERT INTO ssd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","nu ndek nane saniŋgina: Ye mata tane kusnatiŋgamŋgit. Ndaŋam saka tane siŋgine wa mbuŋ kame tuku tukul dubikade sulumba Kuate tuku tukul afu lukakade. ");
INSERT INTO ssd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kuate nu tukul ande pilna ta teŋenmba sakate. Tane ina mam tuku nyu kurauka miŋge kumnemŋge minap. Ande nu ina mam nuŋe tapra pasa sanikuwa kande nu balewap ŋgate. ");
INSERT INTO ssd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tane tukul pasa ta lukamba teŋenmba sakade. Ande nu ina mam kat nuŋe agaŋ afu nikam mbulmba ye yiŋe agaŋ ŋakmba buk Kuate tuku ŋga madiwen ŋgate le tane nu mam nuŋe agaŋ nda tuwa ŋgade. ");
INSERT INTO ssd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ata. Tane siŋgine wa mbuŋ kame tuku maŋau ndo dubikade sulumba Kuate tuku tukul te-side. ");
INSERT INTO ssd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tuan taŋgo Aisaia tuku dir pasa ande kumumbi tane yabri mbal mbol mayok kinit. Nu teŋenmba Kuate tuku miŋge kuyarna. ");
INSERT INTO ssd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Mbal te nane miŋgembi ndo ye kumnemŋge minanu sukde. Nane tuku ŋgamuŋgal ye maskenŋge minig. ");
INSERT INTO ssd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nane ye mbariŋyade ta alo kugatok. Nane taŋgo tuku wamdus te-mayokmba Kuate tuku pasa taŋaŋ tumniŋgig. Aisaia nu taŋamba kuyarna ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kile Yesus nu maŋgur suŋgo ta wika yalpe ŋga saniŋgina: Tane pasa te ismba katese mayewap. ");
INSERT INTO ssd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Taŋgo nu agaŋ tumba nyate taŋge nu tuku ŋgamuŋgal kutur tuwe ndakate. Nu miŋgembi ndo wam kile-mayokka ŋgamuŋgal kutur tuwit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Taŋakina le nuŋe dubiwanu taŋgo kame nu tugum promba sanaig: Ne taŋamba sakat le Farisi mbal nane ne tuku wamdus palseŋniŋgat ta ne kamus ndate e ŋga sanaig le ");
INSERT INTO ssd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","nu ndek yaba pasambi saniŋgina: Yiŋe Mam samba mbolŋge minit nu agaŋ afu ŋgu ndakina le ake prode ta nu siŋka goniŋmba pankamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tane Farisi mbal idus ndaniŋgap. Nane am tukulok minmba tugusemba taŋgo pino tum ndaniŋgig. Taŋgo am tukulok ande nu inum am tukulok ta tumba ndin tumam tuku kinit ta nale arŋeŋ bariŋga burok sinamŋge ndekade ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Taŋakina le Petrus ndek nu sana: Taŋgo kutur tuwit tuku ne yaba pasa sakat ta tugunu te-mayokmba sasiŋga le isbe ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","nu ndek sakina: Tane Farisi taŋaŋ wamdus kareŋnu minig e? ");
INSERT INTO ssd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Taŋgo nu agaŋ nyate ta falŋgu sinam kumba nu sumbikate le mayok kinit. Tane wamdus pulu ndatiŋgit e? ");
INSERT INTO ssd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Taŋgo nu ŋgamuŋgal sinamŋge iduste sulumba miŋgembi te-mayokte wam taŋge nu kutur tuwit. ");
INSERT INTO ssd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Taŋgo tuku ŋgamuŋgal sinamŋge maŋau afu teŋenmba. Wamdus ŋaigonu, taŋgo bale maŋau, pino kuayar, taŋgo pino ndoŋ fare une maŋau, kuayar maŋau, yabri pasambi afu ndalekam tuku, waŋe pasa. ");
INSERT INTO ssd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wam ŋaigonu ŋakmba taŋge taŋgo tumba kutur tuwig. Taŋgo nu wai minya ndaŋga isukusit maŋau taŋge nu kutur tuwe ndakate ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kile Yesus nu tiŋga Tirus le Sidon patukŋge ma tugu ta mbol kina. ");
INSERT INTO ssd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nu kumba ka ma ta prona le Kanannu pino ande pro Yesus wika sana: O Suŋgo, ne David tuku mbuŋ. Ne ye sinanu turya. Yiŋe kulim buklaŋge wanena le sinamanzer suŋgo ŋak minit ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Taŋakina le Yesus nu nda isanu sukmba minna le nuŋe dubinaig taŋgo pro nu sarsarmba sanaig: Pino te nu sine dubika wika wika ilit. Ne sawa le luka kuwa ŋga sanaig le ");
INSERT INTO ssd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","nu ndek nane saniŋgina: Ye Israel mbal sipsip ŋgisikanu taŋaŋ minig nane tugumŋge ndo pirokam tuku yiŋe Mam nu ye kukulyina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kile pino ta pro Yesus tugumŋge dagol tidroŋga sana: O Suŋgo, ne ye turya ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","nu ndek lafumba sana: Ande nu kiŋo kame tuku nyamagaŋ yaika age niŋgit ta nu wam maye ndate ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Taŋakina le pino ta nu maŋ sana: Suŋgo, ta son ta age nane mata taŋgo tuku nyamagaŋ fambonu mbain kumnemŋge ndekade le nyade tuku ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Taŋaka sana le nu pasa lafumba sana: Pino, ne siŋka ye tuku saŋgri tomba tiŋgate. Ne ye wam kam tuku nzalinate ta taŋamba ndo mayok kuwa ŋgina le ait ta mbolŋge ndo kulim nuŋe mayekina. ");
INSERT INTO ssd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kile Yesus nu tiŋga Galilea kule kualiŋ make dubimba kumba tabe poŋga minyokina le ");
INSERT INTO ssd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","taŋgo kuasmbi gudommba nu tugum prowe likinaig. Kupe ŋaigonu, kupe wai isu kigi-kagoŋganu, am tukulok, pasate ndakanu ta ŋakmba kilmba Yesus tugumŋge patikinaig le nu nane wakeike likina. ");
INSERT INTO ssd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wakeikina le pasate ndakanu ta pasatinaig. Kupe wai isu kigi-kagoŋganu ta magekinaig. Kupe ŋaigoŋganu ta likinaig. Am tukulok ta nane mambilnaig. Taŋanaig le maŋgurka minnaig mbal wam kame ta kaŋgerka nane pirerek purka Israel mbal tuku Mbara nyu te-duŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kile Yesus nu nuŋe dubinaig mbal ta wika yalpe ŋga saniŋgina: Mbal te pro ye ndoŋ maŋgurka minig te ki keŋmba buk kugade. Naŋgine nyamagaŋ ta buk nye suglukinaig tukunu ye nane tuku sinayate. Ye nane kukulniŋgi le gubak kuwaig ta nane ka ndinŋge gubanu baklelbekaig ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Taŋakina le nuŋe dubiwanu taŋgo nu sanaig: Sine ndaŋbe. Ma baknu te aniŋge nyamagaŋ kumumbi maŋgur suŋgo te niŋbe le nyuwaig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","nu ndek nane kusnaniŋgina: Tane bret giganmba ŋak e ŋgina le nane lafumba sakinaig: Sine bret 7 kualegaŋ kareŋganu foŋfoŋ ndui ndui ndo ŋak ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Taŋakinaig le Yesus nu maŋgur suŋgo ta minyokuwaig ŋga saniŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","bret foŋfoŋ 7 kualegaŋ turmba kilmba Kuate gare pasa tuna sulumba fetfetmba nuŋe dubiwanu taŋgo niŋgina le nane kilmba walmba niŋge likinaig. ");
INSERT INTO ssd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Niŋge likinaig le nane ŋakmba kilmba nyinaig le maroniŋgina. Agaŋ fetfetna bateŋnu ta kilmba nane sambe 7 ligneniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Isukusnaig taŋgo ta gudommba 4,000 taŋaŋ. Pino kiŋo kame afu mata turmba minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kile Yesus nu mbal ta kukulniŋgina le kinaig le nu waŋ poŋga kumba Magadan ma mbol kina. ");
INSERT INTO ssd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kile Farisi mbal Sadusi mbal ndek Yesus tugum promba nu tagowam tuku samba mbolok saŋgri ande te-mayokuwa le kaŋgeram sanaig. ");
INSERT INTO ssd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Taŋamba sanaig le nu lafumba sakina: Tane ki butuŋgam bafute le tane sakade: Indole ki pro mayewamŋgat. Ma ŋakmba gurkate ŋgade. ");
INSERT INTO ssd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Maratukuk tane sakade: Kite sawe piyamŋgat. Gauŋge ma soŋgate ŋgade. Samba mbolŋge agaŋ mayok kinig ta tane kaŋgerkade. Wam kame ait te mbolŋge kilimok mayok kinig ta tane kaŋgerka katese ndade e? ");
INSERT INTO ssd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tane siŋka mbal ŋaigonu Kuate ŋgumnede tuku. Tane ye tuku saŋgri kaŋgeram tuku idusde ta ye tumtiŋge nda. Wam saŋgrinu ande tuan taŋgo Yona mbolŋge prona ta ndo tumtiŋgamŋgit ŋgina. Taŋakina sulumba nu tiŋga nane kusreka kina. ");
INSERT INTO ssd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesus nane waŋ poŋga kumba ka kule kualiŋ simŋge ibeŋ kinaig ta nuŋe dubiwanu taŋgo nane bret afu kile ndaka kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nane taŋge minnaig le Yesus nu nane saniŋgina: Tane Farisi le Sadusi mbal tuku yis ta riroŋkap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nu taŋakina le nane naŋgine naŋgine saka ismba sine bret afu nda kilgig ta tuku nu sakate inde ŋga saka minnaig le ");
INSERT INTO ssd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","nu nane tuku wamdus katesemba saniŋgina: Tane ndaŋam bret kile ndakaig ta tuku saka minig. Tane ye kumuŋ kuga ŋga idusde? ");
INSERT INTO ssd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tane wamdus pulu ndatiŋgit? Ye wam afu ke liken ta tane gilaiŋgade e? Ye bret 5 tambi taŋgo 5,000 isukusneniŋgen le bateŋnu sambe giganmba ligneniŋginaig? ");
INSERT INTO ssd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ko bret 7 tambi taŋgo 4,000 isukusneniŋgen le bateŋnu sambe gigannaig? ");
INSERT INTO ssd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ye Farisi le Sadusi mbal tuku yis riroŋkap ŋga satiŋgit ta bret tuku sa ndatiŋgit. Ndaŋam saka tane wam ta kila pile ndakade ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nu taŋakina le nane wamdus puluniŋgina. Nu bret tuku yis riroŋkam tuku sa ndakina. Nu Farisi le Sadusi mbal tuku tum maŋau riroŋkam tuku sakina. ");
INSERT INTO ssd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus nane Sesarea Filipi ma tugu mbol pronaig sulumba nu nuŋe dubinaig mbal kusnaniŋgina: Taŋgo pino nane ye Ndindo Katesek Taŋgo ye ima ŋgade ŋga kusnaniŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","nane ndek nu sanaig: Nane afu ne Yohanus kule pisneŋge ŋgade. Afu ne Eliaŋge ŋgade. Afu sakade ne Yeremia ko tuan taŋgo ambokok ande ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Taŋakinaig le nu nane kusnaniŋgina: Tane ye ima ŋga idusde e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrus nu lafumba sana: Ne Kristus Kuateŋge madinina taŋgo. Kuate nu abo minit ne nu tuku Kiŋo ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","nu ndek Petrus sana: Simon, Yona tuku kiŋo, Kuate nu siŋka ne make pilit. Ne taŋgo tugumŋge wamdus ta te ndakate. Yiŋe Mam nu samba mbolŋge minit nuŋge wamdus ta te-mayokmba tumnate. ");
INSERT INTO ssd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ye ne sanamŋgit. Ne tuku nyu Petrus. Ye ndame ta mbolŋge yiŋe kuasmbi patiki le kume tuku saŋgriŋge nane kile-ibeŋkam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kuate nu nuŋe gageu kulatkate wam ta te-mayokam tuku ye ne saŋgri tanmbimŋgit. Ne wam afu kilke te mbolŋge peuniŋga ta samba mbolŋge mata wam ta peuniŋgamŋgat. Ne wam afu kilke te mbolŋge peu ndaniŋga ta samba mbolŋge mata peuniŋge nda ŋga Petrus sana. ");
INSERT INTO ssd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Taŋamba nu nuŋe dubinaig taŋgo nu Kuateŋge madina taŋgo ta afu sa ndaniŋguwaig ŋga saŋgrimba peuniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ait ta mbolŋge ndo Yesus nu tugu pilmba nuŋe dubiwanu mbal saniŋgina: Ye mbumba Yerusalem kaŋgit. Ye ka le taŋge Israel mage mage pris gabat mbal kusem pasa bitekŋganu mbal nane ye tumba piti gudommba suwaig le afuŋge ye baleyamŋgaig. Ye kumi le mara keŋnu mbolŋge Kuate nu te-tiyamŋgat ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Taŋakina le Petrus nu Yesus tumba te Yamokmba sawe lika sana: A ... Suŋgo. Ndo kuga. Kuate nu ne kulatkate. Wam ta ne mbol prowe nda ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","nu mbilka Petrus sana: Satan, ne kua kaye. Ye tuku ndin tukul ndawa. Ne Kuate tuku wamdus pitaimba taŋgo tuku wamdus ndo dubite ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Taŋakina sulumba Yesus nu nuŋe dubiwanu taŋgo saniŋgina: Ima nu ye tuku taŋgo minam idusmba kande nu nuŋe nzali kusreka nuŋe miroŋ nuŋe ail kazrai kuramba ye dubiyuwa. ");
INSERT INTO ssd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ima nu nuŋe abo mine mayewam tuku suŋgomba idusmba kurau mayete ta nu ŋgisikamŋgat. Ima nu ye tuku ŋga nuŋe abo mine mayewam tuku idus ndate ta nu nuŋe abo ta tumba ŋak minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ande nu kilke te tuku agaŋ ndende ŋakmba kilwa le nuŋe kanu ŋgisikuwa ta nu mine mayewam tuku ta ose. Ande nuŋe kanu ŋgisikuwa ta ame agaŋmbi piyamba maŋ luka tam kumuŋ? ");
INSERT INTO ssd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ye Ndindo Katesek Taŋgo ye yiŋe Mam tuku kilŋa saŋgri ŋak nuŋe eŋel kame ndoŋ luka prowamŋgit. Prowi sulumba ye taŋgo yimyam ŋakmba nane maŋau ke likinaig ta lafunu niŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ye siŋka satiŋgamŋgit. Tane teŋge tiŋ minig mbal afu kume ndaka minap le ye Ndindo Katesek Taŋgo yiŋe gageu kulatkam tuku prowi le tane kaŋgeryamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mara 6 kugana le Yesus nu Petrus Yakobus le maib nuŋe Yohanus nane kilmba naneŋge ndo tabe suŋgo ande poŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ka taŋge nane keŋ ta mambilmba minnaig kande Yesus tuku ŋgarosu mbilka kisemba mayok kina. Nuŋe tumail pasi ki tuku kilŋa suk. Nu tuku tawi kauknu uge liŋnu ndo mayok kina. ");
INSERT INTO ssd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Taŋana le Moses le Elia nale mayok ka Yesus ndoŋ pasata minnaik le nane kaŋgerkinaig. ");
INSERT INTO ssd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Taŋamba Petrus nu ndek Yesus sana: Suŋgo, sine teŋge mineg te mayenu ndo. Ne woka le ye baibai keŋmba ande ne tuku ande Moses tuku ande Elia tuku patiki ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petrus nu taŋamba saka minna le gau ande uge liŋnu ndo pro nane kainiŋgina le gau ta sinamŋge pasa ande mayok ka teŋenmba sakina: Ande te ye tuku Kiŋo. Ye nu tuku kume purmba nu tuku gare suŋgo tet. Tane nu tuku pasa ise mayewap ŋga sakina le ");
INSERT INTO ssd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Petrus nane miŋge pasa ta ismba kuru kuru mayemba ndek kilke mbolŋge truk kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Taŋamba minnaig le Yesus nu pro nane kigreka saniŋgina: Tane kuru kuru ndakap. Tane tiŋgap ŋga saniŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","nane tandeka mambilmba Yesus nuŋe ndo minna le kaŋgernaig. ");
INSERT INTO ssd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nane tiŋga Yesus ndoŋ luka ndek ka ndinŋge Yesus nu nane peuniŋmba saniŋgina: Ye Ndindo Katesek Taŋgo ye kummba maŋ tiŋgi le ndo tane wam kiŋatanu suk kaŋgeraig ta afu saniŋgap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kile nuŋe dubiwanu taŋgo keŋ ta nu kusnanaig: Ndaŋam kusem pasa bitekŋganu mbal nane Elia nu amboŋga prowa le ndo Kristus nu prowamŋgat ŋga sakade ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","nu ndek nane saniŋgina: Son. Elia nu amboŋga prowa sulumba wam ŋakmba kuaneka kile-tidiŋgam tuku ta ");
INSERT INTO ssd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ye tane teŋenmba satiŋget. Elia nu buk mayok kina le nane nu kila pile ndakinaig. Nane nu tumba naŋgine nzali dubimba ŋayo silinaig. Taŋamba ndo nane ye Ndindo Katesek Taŋgo mata ŋayo siliyamŋgaig ŋga saniŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","nuŋe dubiwanu taŋgo pasa ta ismba nu Yohanus kule pisne tuku saniŋgina ta nane wamdus puluniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nane keŋ ta Yesus ndoŋ maŋ luka ka maŋgur suŋgo ta tugum pronaig le taŋgo ande pro Yesus tugumŋge dagol tidroŋga nu sana: ");
INSERT INTO ssd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","O Suŋgo, ne ye tuku kiŋo sinanu tura. Zulbarek maŋau nu mbol prote le nu sinamanzer suŋgo ŋak minit. Maŋau taŋge nu tate le ait afu nu pa mbol ndekate. Ait afu nu kule sinamŋge ndekate. ");
INSERT INTO ssd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ye nu tumba naŋe dubinade taŋgo te tugum prowit ta nane nu wakeiwam fuguwaig ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Taŋakina le nu ndek sakina: Tane Kuate talamba ŋgamuŋgal son tugusek kugatok mbal tane ye piti seryade. Ye ait giganmba tane ndoŋ minamŋgit? Kiŋo ta tumba yalpe ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Taŋakina le nane kiŋo ta tumba pronaig le nu bukla ŋayonu ta sawe likina le nu kiŋo ta kusremba kua kina le kiŋo ta mayekina. ");
INSERT INTO ssd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Taŋamba Yesus nuŋe ndo minna le nuŋe dubiwanu taŋgo nane nu tugum promba kusnanaig: Ndaŋam sine bukla ta pitaiwe fuguwig ŋga kusnanaig le ");
INSERT INTO ssd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","nu ndek nane saŋgina: Tane ŋgamuŋgal son tugusek kugatok ta tuku. Ye siŋka satiŋget. Tane Kuate tuku saŋgri tomba tiŋgade maŋau ta mastet tiŋnu taŋaŋ fudiŋndo ndo minwa ta tane tabe te samba ne goka ka ma si kaye ŋga sawap ta nu taŋawamŋgat. Ŋgamuŋgal son maŋau tambi tane wam ŋakmba kaŋgerkam kumuŋ. Ande nu nyamagaŋ pinka ndo Kuate yabaŋte sulumba nu bukla pitaikam kumuŋ. ");
INSERT INTO ssd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesus nane Galilea ma tugu mbolŋge kine promba minmba nu nuŋe dubiwanu kuasmbi saniŋgina: Nane ye Ndindo Katesek Taŋgo tumba kilke mbol mbal tuku wai mbolŋge pilwaig le baleyamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Baleyuwaig le ye kumi sulumba mara keŋnu mbolŋge Kuate nu ye kuaneyuwa le tinuŋgit ŋga saniŋgina. Taŋakina le nane pasa ta ismba piti suŋgo ŋak minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesus nane Kaperneum tumbraŋ pronaig le kusem wande suŋgo tuku ndametiŋ kilanu mbal pro Petrus kusnanaig: Tane tuku tum taŋgo nu kusem wande suŋgo tuku takis ndametiŋ patikate e ŋginaig le nu au ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Taŋakina sulumba nu maŋ luka wande mbol kina le Yesus nu katesemba Petrus kusnana: Simon, kilke te mbolok gabat sugo nane ima tugumŋge takis ndametiŋ kilig? Nane naŋgine kiŋo kame tugumŋge kilig e ko mbal afu tugumŋge kilig ŋga Petrus kusnana le ");
INSERT INTO ssd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","nu ndek Yesus sana: Nane mbal afu tugumŋge kilig ŋgina. Taŋakina le nu Petrus sana: Ta tuku gabat suŋgo tuku kiŋo kame takis patinu tuku piti ta nane mbolŋge mine ndakate ta ");
INSERT INTO ssd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","sine kusem wande suŋgo ta tuku takis ndametiŋ pan ndakube ta nane afu gubra tubekaig. Ta tuku ne kule kualiŋ nzi mbol kumba kuku tilaiŋga kualegaŋ amboŋga tamŋgat ta miŋgenu kakerka takis ndametiŋ kumumbi kaŋgeramŋgat. Ndametiŋ ta tumba ye tuku takis naŋe turmba patika ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ait ta mbolŋge Yesus dubiwanu taŋgo nane nu tugum promba nu kusnanaig: Kuate kulatkate mbal ŋgamukŋge ima suŋgo minit ŋga kusnanaig le ");
INSERT INTO ssd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","nu ndek kiŋo ande tumba nane ŋgamukŋge te-timba nane saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ye siŋka satiŋgamŋgit. Tane mbilka kiŋo kame taŋaŋ mayok ndakape ta tane Kuate kulatkate ma mbol kine nda. ");
INSERT INTO ssd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ande nu kiŋo teŋen nyu kugatok minam iduste ta nu Kuate tuku gageu ŋakmba ŋgamukŋge nu suŋgo minit. ");
INSERT INTO ssd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ande nu ye tuku ŋga idusmba kiŋo teŋen tate ta nu ye mata tate. ");
INSERT INTO ssd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kiŋo ande teŋen ye tuku son ŋgate le andeŋge didikate le nu ye ŋgumneyate ta taŋgo ta ose. Nu kiŋo didi ndaka minwa le amboŋga afuŋge wit firfiranu ndame suŋgo tumba ŋinfok tur kusmba bukŋginaig le yu buto ka kumna kande maye kande. Nu pa tam tuku mine ndakate kande. ");
INSERT INTO ssd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Taŋgo pino Kuate ŋgumnewaig ŋga tago afu siŋka prowamŋgaig ta ima nu taŋamba taŋgo tagoniŋgit le nane Kuate ŋgumnede ta ose. Nu pa suŋgo tamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ne tuku wai ko kupe ne unekam tuku didikate ndeta pike purmba bukŋga. Ne wai ko kupe ndindo ŋak minmba Kuate tugumŋge abo tugu kaŋgera ta maye. Ne wai ko kupe armba ŋak mina le Kuateŋge ne tumba bukŋguwa le ne ugmba minmba minam tuku ma ta mbol kaye ta ŋayo. ");
INSERT INTO ssd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ne tuku am ande nu ne unekam tuku didikate ndeta gomba bukŋga. Ne am ndindo ŋak minmba Kuate tugumŋge abo tugu kaŋgera ta maye. Ne am armba ŋak mina le Kuateŋge ne tumba bukŋguwa le pa suŋgo mbol kaye ta ŋayo. ");
INSERT INTO ssd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Tane kiŋo ande teŋen talamba ake agaŋ ŋga idus ndawap. Kiŋo kame kulatkanu eŋel kame mara mara samba mbolŋge yiŋe Mam am mbolŋge minig. Ye Ndindo Katesek Taŋgo ye ŋgisikanu minig mbal muskil kile-tidiŋgam tuku ye prowen. ");
INSERT INTO ssd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Tane wam te ismba tane ndaŋmba idusde. Taŋgo ande nu sipsip 100 ŋak ndindo inum ŋgisikate le nu taŋaig ŋgate ŋga idusde? Kuga. Nu sipsip afu 99 ta kilmba ka tabe ande mbolŋge kusreka nu luka kumba ande ŋgisikate ta sotate. ");
INSERT INTO ssd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ye siŋka satiŋgamŋgit. Nuŋe sipsip 99 ŋgisi ndakade ta nu nane tuku gare fudiŋmba tate. Sipsip ndindo ŋgisikate le sota luka tate sulumba nu ta tuku gare suŋgo tate. ");
INSERT INTO ssd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Taŋamba ndo taŋgine Mam nu samba mbolŋge minit nu kiŋo inum teŋen mata nu ŋgisi ndakuwa ŋga iduste. ");
INSERT INTO ssd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Tira ande nu ne mbolŋge mbar ande kuwa ndeta ne kumba siŋsiŋndo nu ndo sawa. Nu ne tuku pasa pitai ndamba ŋgamuŋgal biye mbilwa ndeta maye. Maŋau tambi ne naŋe gulab maŋ luka tate. ");
INSERT INTO ssd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ko nu ne tuku pasa isam mbulwa kande ne tira ndindo ko armba kilmba nu tugum kape sulumba nu ndoŋ pasa te-tiwap. Tane ar ko tane keŋ pasa ta sawap ta maye. ");
INSERT INTO ssd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Taŋgo ta nu nale tuku mata isam mbulwa kande kile ne Kuate tuku kuasmbi ŋakmba saniŋga le iswaig. Nu nane tuku mata isam mbulwa kande nu kasomok taŋgo ko takis kilanu taŋgo taŋaŋ nu ndoŋ ulendi ndakap. ");
INSERT INTO ssd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ye siŋka satiŋgamŋgit. Tane wam afu kilke te mbolŋge peuniŋgap ta samba mbolŋge mata wam ta peuniŋgamŋgat. Tane wam afu kilke te mbolŋge peu ndaniŋgap ta samba mbolŋge mata peuniŋge nda. ");
INSERT INTO ssd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ye maŋ satiŋgi le isap. Tane tuku armba nale wamdus ulendimba wam ande tuku Kuate yabaŋwaik ta yiŋe Mam nu samba mbolŋge minit nu wam ta kamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Taŋgo armba ko keŋmba nane ye tuku nyu mbolŋge maŋgurkade ta ye nane ŋgamukŋge minet ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kile Petrus nu Yesus tugum promba nu kusnana: Suŋgo, yiŋe tira ande nu ye mbolŋge mbar giganwa le ye gilaiŋgi. Nu mbaram 7-wa le ye mbar ta gilaiŋgi e ŋga kusnana le ");
INSERT INTO ssd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","nu lafumba sana: Kuga. Ne nu tuku mbar 7 ndo gilaiŋga ta kumuŋ kuga. Ne nu tuku mbar 77 taŋamba gilaiŋga. ");
INSERT INTO ssd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tane isap. Kuate nu nuŋe gageu kulatkate maŋau ta wam kube te suk. Taŋgo suŋgo ande nuŋe piro mbal afu nane nu tuku ndametiŋ kilnaig ta luka lafuwaig ŋga sakina. ");
INSERT INTO ssd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nu lafunu kilam tuku tugu pilna le taŋgo ande nu lafuwam tuku ndametiŋ soŋ 100,000 taŋaŋ nane nu tumba pronaig. ");
INSERT INTO ssd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nu ndametiŋ ta lafuwam kumuŋ kuga tukunu taŋgo suŋgo nu nane afu saniŋgina: Tane taŋgo te tumba nuŋe pino kiŋo kat nuŋe ndoŋ agaŋ ndende ŋakmba turmba afu tugumŋge piro agaŋ taŋaŋ minam tuku piyamba ndametiŋ kilmba pro nuŋe ndametiŋ lafuwap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Taŋakina le nu suŋgo tugumŋge ndeka dagol tidroŋga sarsarmba sana: O suŋgo, ne ait tutura le ye lafunu ta kumumbi kilmba tanmbimŋgit ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Taŋaka sana le taŋgo suŋgo nu sinanu lafuwam tuku wamdus kusremba nu ake kukulna le kina. ");
INSERT INTO ssd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nu kumba ka nuŋe piro tuma ande nu tuku soŋ ndindo lafuwam tuku minna ta kaŋgerna. Kaŋgermba nu biye timba ŋinfok pipka ye tuku ndametiŋ lafuwa ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Taŋakina le nuŋe piro tuma ta ndek nu tugumŋge truk ka nu sarsarmba sana: Ne ait tutura le ye lafunu ta te-kumumbimba tanmbimŋgit ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Taŋamba sana ta nu mbulmba nu tumba ka muli wandekŋge pilmba nu tuku ndametiŋ ta ŋakmba lafuwe suluwa sulumba ndo nu mayok kuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kile nuŋe piro tuma mbal afu nu wam kina ta kaŋgermba nane pitiniŋgina le nane kumba ka naŋgine suŋgo ta kubeu tunaig le ");
INSERT INTO ssd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","nu pasa ta ismba piro taŋgo ta wikina sulumba sana: A ... ne siŋka taŋgo ŋayonu. Ne ye sarsaryat le ne ndametiŋ lafuwam tuku ta ye wamdus kusrewit. ");
INSERT INTO ssd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ye taŋamba ne sinanu mapenit ta ndaŋam saka naŋe piro tuma taŋgo ta sinanu mape ndawat ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Taŋaka nu gubra tormba taŋgo ta tumba muli wande kulatkanu mbal tuku wai mbolŋge pilmba saniŋgina: Nu ye tuku ndametiŋ ŋakmba lafuwe suluwa le nu mayok kuwa ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tane taŋamba ndo taŋgine tira tuku mbar tugusemba wamdus gilai ndaŋgap ta yiŋe Mam nu samba mbolŋge minit nu mata tane mbolŋge taŋawamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus nu pasa ta sake deŋpurmba nu tiŋga Galilea ma kusremba kumba Yudea ma tugu mbol promba Yordan kule sim kina le ");
INSERT INTO ssd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","taŋgo pino gudommba nu dubinaig le nu taŋge nane tuku guaze wakeikina. ");
INSERT INTO ssd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Taŋamba minna le Farisi taŋgo afu Yesus tagowam tuku pro nu kusnanaig: Sine siŋgine tukul maŋau dubimba ande nu piyo nuŋe mbar ande mbolŋge pitaiwam kumuŋ e ŋga kusnanaig le ");
INSERT INTO ssd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","nu ndek sakina: Tane Kuate tuku kuyar pasa bur ndakade e? Pasa ta teŋenmba sakate. Tugu mbolŋge Kuate nu taŋgo pino kile-mayokka nu ŋgarosu kise kise wakeikina sulumba sakina: ");
INSERT INTO ssd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Taŋgo nu ina mam nuŋe kusreka piyo nuŋe ndoŋ muŋgu kile-deŋga minwaik. Nale ŋgarosu ndindo mayok kaŋgaik ŋgina. Kuyar pasa nu taŋakate. ");
INSERT INTO ssd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ta tuku nale armba mine ndakik. Nale agaŋ ndindo taŋaŋ minik. Kuate nu agaŋ kilmba ulendinikit ta taŋgoŋge nale pur ndanikuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Taŋakina le Farisi nane ndek nu sanaig: Taŋamba ta ndaŋam Moses nu tukul pasa teŋenmba sakina: Ande nu piyo nuŋe pitaiwam ŋga waŋe ande kuyarmba tuwa sulumba nu pitaiwam kumuŋ ŋga sakina le ");
INSERT INTO ssd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","nu ndek nane saniŋgina: Tane wamdus kareŋnu ŋak. Ta tuku Moses nu taŋgo pino pitaikam tuku wokina. Tugu mbolŋge maŋau ta mine ndakina. ");
INSERT INTO ssd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ye teŋenmba satiŋgamŋgit. Pino ande nu taŋgo ndoŋ fare mine ndakate le taŋgo nuŋe maŋau kise tuku nu pitaimba pino kise ndoŋ muŋgu kilik ta nu pino kuayarmba unekate ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Taŋakina le nuŋe dubiwanu taŋgo ndek Yesus sanaig: Taŋgo pino kilmba maŋ pitaikam tuku tukul saŋgrinu taŋamba minwa kande sine taŋgo pino kile ndakube ŋga sanaig le ");
INSERT INTO ssd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","nu ndek nane saniŋgina: Taŋgo ŋakmba muŋgu kilam tuku minig. Kuate nu maŋau ta laipam tuku afu saŋgri niŋgit nane ndo muŋgu kile ndakade. ");
INSERT INTO ssd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Afu nane ina sinamŋge agaŋ afu denkanu mayok kinig tukunu nane pino kile ndakade. Afu taŋgo maŋaumbi nane tuku ŋgarosu ŋaigo siglikinaig. Afu nane Kuate tuku gageu tugekuwa ŋga piro ta kumba pino kilam tuku wamdus ta kugatok. Ande nu maŋau ta dubiwam kumuŋ ndeta dubiwa ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nane afu kiŋo kame foŋfoŋ kilmba Yesusŋge wai nane mbol patika Kuate yabaŋwa ŋga Yesus tugum pronaig le nuŋe dubinaig mbal taŋge nane saniŋge lika kile-luka minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Taŋanaig le Yesus nu nane saniŋgina: Kiŋo kame peu ndaniŋgap. Nane ye tugum te prowaig. Kiŋo kame nane Kuate tuku ma mbol kambim tuku minig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Taŋamba nu wai nane mbol patika sulumba tiŋga kina. ");
INSERT INTO ssd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mara ande taŋgo inum Yesus tugum promba nu kusnana: Tum Taŋgo, ye ame maŋau mayenu ki sulumba abo tugu tumba minmba minamŋgit ŋga kusnana le ");
INSERT INTO ssd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","nu lafumba sana: Ndaŋam ne maŋau mayenu tuku kusnayate. Kuate nu ndo mayenu. Ne minmba minam tuku abo tugu ta tam idusmba kande ne Kuate tuku tukul dubika ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Taŋaka sana le taŋgo ta nu kusnana: Ye tukul pasa ndaŋ dubiki ŋgina le nu lafumba sana: Taŋgo bale ndawa. Pino kuayar ndawa. Agaŋ ande kuayar ndawa. Yabri pasambi ande ndale ndaka. ");
INSERT INTO ssd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ina mam naŋe tuku nyu kurauka miŋge kumnemŋge mina. Ne naŋe ŋgarosu tuku wamdus suŋgo ŋak minit taŋamba ndo nane ne tugumŋge minig mbal tuku kume purmba mina ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","taŋgo mo ta ndek nu sana: Ye tukul ta ŋakmba dubika minet. Ame maŋau ye mbol denkate ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus lafumba ndek nu sana: Ne abo tugu ta tam idusmba kande ne kumba ka naŋe agaŋ ndende ŋakmba piyamba ndametiŋ kilmba sanzal mbal niŋmba ne ye dubiya. Ne taŋawa ta ne samba mbolŋge agaŋ ndende magenu ŋak minamŋgat ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","taŋgo mo nu pasa ta ismba nu agaŋ ndende suŋgomba ŋak tukunu nu wamdus piti ŋak Yesus kusremba kina. ");
INSERT INTO ssd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nu kina le Yesus nu nuŋe dubiwanu taŋgo saniŋgina: Ye siŋka satiŋgamŋgit. Agaŋ ndende suŋgomba ŋak mbal nane Kuate tuku gageu mayok kambim tuku minde bada suŋgo. ");
INSERT INTO ssd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Agaŋmor suŋgo kamel nu nil burok silinu tuku ta minde bada suŋgo kuga. Taŋgo nu agaŋ ndende suŋgomba ŋak ta nu ŋgumneniŋmba Kuate tuku gageu mayok kambim tuku maŋau ta siŋka minde bada suŋgokanu ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Taŋakina le nuŋe dubiwanu taŋgo pasa ta isnaig sulumba nane piriri ŋayomba sakinaig: Yoi. Taŋamba ndeta ndaŋndaŋmba sine afu abo minam tuku ndin te-silikamŋgig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus nu nane kaŋgerka saniŋgina: Taŋgo nane wam afu ke fugude ta Kuate nu wam ta ŋakmba kam kumuŋ ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kile Petrus lafumba Yesus sana: Ai te. Sine ne tuku ŋga siŋgine agaŋ ndende ŋakmba kusreka ne dubineg. Sine ame agaŋ tamŋgig ŋga kusnana le ");
INSERT INTO ssd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","nu ndek nane saniŋgina: Ye siŋka satiŋgamŋgit. Kilke kitek mayok kuwa le ye Ndindo Katesek Taŋgo yiŋe minyo mbili maditaknu mbolŋge minyoka ŋakmba kulatkamŋgit ta tane ye dubiyade mbal mata minyo mbili 12 mbolŋge minyoka Israel tuku tugu 12 ta kilmba pileniŋgamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ande nu ye tuku ŋga nuŋe wande, tira kat nuŋe, kulim kat nuŋe, ina mam kat nuŋe, kutu kat nuŋe, nuŋe kilke agaŋ kame taŋaŋ kusrekate ta nu agaŋ kusrekate ta kitek gudommba kilmba nu abo tugu ŋak minmba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ata. Nane afu kile tumailamŋge minig ta nane ŋgumnem kaŋgaig. Afu kile ŋgumnemŋge minig ta nane tumailam kaŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kile Yesus nu sakina: Kuate nuŋe gageu lafunu niŋgit wam ta piro miro taŋgo ande wam kina taŋaŋ. Nu maratukuk tiŋga ki nda promba minna le mbal afu nu tuku grep piro mbolŋge pirokam tuku sota kilam kina. ");
INSERT INTO ssd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nu kina ka afu kaŋgerka ki ndindo tuku piya niŋgam tuku saniŋgina le nane woka taŋgo ta tuku piro mbol kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ki kanum 9 mbolŋge nu maŋ kumba ka maket mbolŋge afu nane ake minnaig ta kaŋgerka saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tane pirokam idusmba kande tane ye tuku piro mbol kape le ye tane piya kumumbi tiŋgamŋgit ŋga saniŋgina le nane kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ki kanum 12 mbolŋge ki kanum 3 mbolŋge nu maŋ wam ndui ta ndo kina. ");
INSERT INTO ssd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Taŋamba ki kanum 5 mbolŋge nu maŋ kumba ka afu ake minnaig ta kaŋgerka saniŋgina: Ndaŋam tane ake tiŋ minig le ka furirte ŋga saniŋgina le nane nu sanaig: ");
INSERT INTO ssd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Afuŋge sine piro nda siŋgig ŋginaig le nu ndek saniŋgina: Tane kumba ye tuku piro mbolŋge pirokap ŋgina le nane kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ki butuŋga furirna le miro taŋgo nu nuŋe piro kulat taŋgo sana: Piro mbal wika nane piya niŋga. Ŋgumneŋga prowaig ta mbolŋge tugu pilmba ka ka maratukuk prowaig mbolŋge bitekŋga ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","piro kulat taŋgo nu mbal afu furiram piro tugu pilnaig ta wika ki ndindo tuku piya kumumbi niŋge likina. ");
INSERT INTO ssd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Taŋana le mbal maratukuk pronaig ta nane wam ta kaŋgermba sine ndametiŋ maŋ lato kilamŋgig ŋga idusnaig ta kuga. Nane mata ki ndindo tuku piya ndo kilnaig. ");
INSERT INTO ssd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Taŋamba nane gubra tumba ka piro miro taŋgo sanaig: ");
INSERT INTO ssd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mbal te nane ait fagnu ndo pirokaig a. Sine maratukuk tiŋga piro tugu pilmba ka ka kiŋge sine pasoka mundusiŋmba piro kareŋkigig le furirte. Ndaŋam saka ne sine nane ndoŋ piya kumu kumu siŋgat ŋga sanaig le ");
INSERT INTO ssd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","piro miro taŋgo nu nane tuku ande lafumba sana: Mata, ye ne mbolŋge mbar ndawit. Ne ye ndoŋ pasa katmba naŋe piro tuku ki ndindo tuku piya tam tuku wokat tae. ");
INSERT INTO ssd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ne naŋe ndametiŋ ta tumba kaye. Ye yiŋe nzalimbi nane afu furiram prowaig ta ne ndoŋ kumu kumu ndametiŋ niŋgam iduset. ");
INSERT INTO ssd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ndametiŋ te yiŋe ndametiŋ. Ye afu niŋgam bafuwi ta niŋgam kumuŋ. Ndaŋam saka ye waknyumba minet le ne ye tuku gubra tat ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kile Yesus nu teŋenmba saniŋgina: Afu ŋgumnemŋge minig ta tumailam kaŋgaig. Afu tumailamŋge minig ta ŋgumnem kaŋgaig ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesus nane Yerusalem kumbaŋge nu nuŋe dubiwanu taŋgo 12 ndo kilmba kile Yamokka saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Tane isap. Sine mbumba Yerusalem kaŋgig. Ka ambeŋge nane afu ye Ndindo Katesek Taŋgo tumba pris gabat kusem pasa bitekŋganu mbal tuku wai mbolŋge pilwaig le nane ye te-tiyumba kumwa ŋga sakamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nane kasomok mbal tuku wai mbolŋge ye pilwaig le nane ye maim maim te-sumba ŋgusyuwaig sulumba ail kazrai mbolŋge ye baleyamŋgaig. Ye kumi le mara keŋnu mbolŋge Kuate nu maŋ ye te-tiyamŋgat ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedeus tuku kiŋo armba Yakobus le Yohanus ina nakileŋge nale kilmba ka Yesus tugumŋge dagol tidroŋga nu agaŋ yabaŋna le ");
INSERT INTO ssd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","nu ndek kusnana: Ame agaŋ tuku ne ye yabaŋyate ŋgina le nu ndek sana: Ne yiŋe kiŋo ar te ma nika le ne naŋe gageu kulatka mina le inum ne tuku ndinamŋge inum ŋaiŋamŋge minyokuwaig ŋga iduset ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Taŋakina le Yesus nu lafumba sanikina: Tale wam yabaŋkik ta tugunu tale gilai. Ye kule kaglinu nyamŋgit ta tale mata nyam kumuŋ e ŋga sanikina le nale sakinaik: Au. Sile kumuŋ ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Taŋakinaik le Yesus nu nale sanikina: Son. Ye kule kaglinu nyamŋgit ta tale mata nyamŋgaik ta ye tuku ndinamŋge ko ŋaiŋamŋge afu taŋamba kile-minyokam tuku ta ye miro kuga. Yiŋe Mam nu taŋgo afu madiniŋgina nane ndo ma ta mbolŋge minyokamŋgaig ŋga sanikina. ");
INSERT INTO ssd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nu dubiwanu taŋgo 10 wam ta isnaig sulumba nale aba nuŋe tuku palseŋniŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesus nu nane te yalpe ŋga wika saniŋgina: Kasomok mbal tuku gabat sugo nane pasa saŋgrinu ŋak minig ta tane kila. Gabat afu nane kumnemŋge minig ta nane mata taŋgo pino nane kukul te-niŋmba matuk kinig ta ");
INSERT INTO ssd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","tane maŋau ta ke ndakap. Tane ŋgamukŋge ima nu suŋgo minam idusmba ndeta nu tane ŋakmba tuku piro taŋgo minwa. ");
INSERT INTO ssd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tane ŋgamukŋge ima nu kulat taŋgo minam idusmba ndeta nu tane ŋakmba tuku piro taŋgo taŋaŋ minwa. ");
INSERT INTO ssd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ye Ndindo Katesek Taŋgo ye mata taŋgo pino ye sinzaŋyuwaig ŋga pro ndawen. Ye nane sinzaŋniŋmba yiŋe ŋgarosu kumam tuku pilmba nane gudommba muskil kile-tidiŋge niŋgam tuku prowen ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesus nane Yeriko kusrewam bafunaig le taŋgo gudommba nu dubimba kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Taŋgo armba nale am tukulok ndin makembiŋge minnaik. Nale Yesus kina ta afuŋge sanikinaig le ismba nale ndek wi kueŋka sanaik: David tuku mbuŋ suŋgo, ne sile sinanu tursika ŋga sakinaik. ");
INSERT INTO ssd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Taŋakinaik le maŋgur suŋgo nale maninkuwaik ŋga sanike likinaig kande nale lato lato wika sakinaik: David tuku mbuŋ suŋgo, ne sile sinanu tursika ŋga saka minnaik. ");
INSERT INTO ssd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Taŋamba saka minnaik le Yesus nu tiŋga nale kusnanikina: Ye ame wam tale mbolŋge ki ŋga idusik ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","nale ndek nu sanaik: O Suŋgo, sile tuku am wakeika ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Taŋakinaik le Yesus nu nale sinanikmba nale tuku am kigrekina kande am maraŋga mambilnaik sulumba nu dubimba kinaik. ");
INSERT INTO ssd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus nane kumba ka Yerusalem patunaig sulumba Betfasi tumbraŋ Olif tabe patumba Yesus nu nuŋe dubinaig taŋgo armba sanikina: ");
INSERT INTO ssd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Tale tumbraŋ si kumba bitekŋga doŋki ande fat ŋak pannaig le tiŋ minik ta kaŋgerkamŋgaik. Kaŋgerka muli kuklinikmba kilmba ye tugum te yalpe. ");
INSERT INTO ssd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ande nu tale kusnatikuwa kande tale nu sawap: Suŋgo nu doŋki te piro ŋak ŋga sawap. Taŋakap le nu pitik ndo maye kilmba kape ŋga satikamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesus nu nale taŋamba wam pagukina ta o buk tuan taŋgo ande pasa sakina ta kumuŋgina. Nu teŋenmba kuyarna. ");
INSERT INTO ssd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sion tumbraŋ suŋgo sawap le nuŋe taŋgo suŋgo kaŋgerwa. Nu ŋgannu nyu kugatok taŋaŋ doŋki fat mbolŋge minyoka doŋki ŋak nu tugum prote ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yesus nu nuŋe dubinaig taŋgo ar ta wam pagukina le nale ka kumunaik. ");
INSERT INTO ssd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nale doŋki nuŋe fat ndoŋ kilmba Yesus tugum pronaik sulumba naŋgine kumiŋ kilmba muskilnu mbolŋge farnaig le Yesus nu poŋga minyokina. ");
INSERT INTO ssd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Taŋana le maŋgur suŋgo ta nane naŋgine kumiŋ kilmba ndinŋge farniŋmba afu nane ail wai kugerka kilmba pro ndinŋge farniŋge likinaig. ");
INSERT INTO ssd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Taŋamba kile afu Yesus tumailamŋge afu ŋgumnemŋge nane kumbaŋge wikaraumba sakinaig: Sine David tuku mbuŋ tuku nyu te-duŋgube o. Taŋgo te Suŋgo tuku nyu mbolŋge prote. Nu Suŋgoŋge nyaro tuwa o. Sine Suŋgo Kuate tuku nyu te-duŋgube o ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nane taŋamba kumba minnaig le Yesus nu doŋki ŋak Yerusalem bitek prona le tumbraŋ suŋgo ta tuku taŋgo pino ŋakmba pirerek purka taŋgo ta imaŋge ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","nane maŋgur suŋgo nu dubinaig ta nane ndek sakinaig: Taŋgo te Yesus. Nu tuan taŋgo. Nu Nasaretnu Galilea ma tugu mbolok ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kile Yesus nu Yerusalem kusem wande suŋgo ta sinam kumba ka kawaŋ taŋge nane afu agaŋ ndende piyaniŋginaig afu piyaniŋmba kilnaig ta nane ŋakmba kogroŋkina sulumba nane ndametiŋ muŋgu walka minnaig mbal tuku mbain kilmba kile-panka afu umaŋ kurinum piyawam tuku patikinaig mbal tuku minyo mbili mata kile-panka pitaike likina. ");
INSERT INTO ssd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Taŋamba nu nane saniŋgina: Kuyar pasa nu teŋenmba sakate. Ye tuku wande ta mbariŋyam tuku wande. Tane wande te mbilmba kuayar taŋgo tuku wande taŋaŋ pilig ŋgate. Yesus nu taŋamba nane saniŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","nu kusem wandek sinam taŋge minna le afu am tukulok afu kupe ŋaigonu nane gudommba nu tugum pronaig le nu nane wakeike likina. ");
INSERT INTO ssd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Taŋana le kiŋo kame nane kusem wandek sinam taŋge wikaraumba sakinaig: Sine siŋgine suŋgo David tuku mbuŋ tuku nyu te-duŋgube o ŋga saka minnaig. Taŋamba minnaig le pris gabat kame kusem pasa bitekŋganu afu ndoŋ Yesus nu wam kitek saŋgrinu ke likina le kaŋgerka kiŋo kame tuku zigna ta ismba nane palseŋniŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","nane Yesus sanaig: Nane ne tuku sakade ta ne nda isit e ŋginaig le Yesus nu lafumba saniŋgina: Ye iset. Tane kuyar pasa ande bur ndakade e? Pasa ta nu teŋenmba sakate. Ne kiŋo kame foŋfoŋ kiŋo dabronu turmba tumniŋgit le ne tuku nyu kumumbi te-duŋgade ŋgate. ");
INSERT INTO ssd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Taŋamba saniŋmba Yesus nu nane kusreka mayok ka tumbraŋ suŋgo kusremba ka Betani tumbraŋ promba taŋge minna. ");
INSERT INTO ssd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mafena le nane maŋ luka Yerusalem kambim saka kumba ka ndinŋge Yesus nu gubana le ");
INSERT INTO ssd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","nu fik ail ande ndin makembiŋge tiŋ minna ta alonu kilmba nyam saka tugum kumba mambilna kande kuga. Nu waŋenu ndo kaŋgerkina. Taŋamba nu fik ail ta sana: Ne maŋ alowe nda ŋga sana. Nu taŋaka sakina le ait ndui ta mbolŋge ndo ail ta waŋenu kareŋge sulunaig. ");
INSERT INTO ssd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Taŋanaig le nuŋe dubinaig mbal nane piriri ŋayomba sakinaig: i ... Ame maŋau taŋaŋ a. Fik ail te pitik ndo waŋenu kareŋge suluwaig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","nu lafumba nane saniŋgina: Ye siŋka satiŋgamŋgit. Tane Kuate nu kumuŋ ŋga wamdus tero ndakap ta ye fik ail mbolŋge maŋau kit taŋamba tane mata kam kumuŋ. Ta ndo kuga. Tane tabe si samba ne goka tiŋga yu buto sinam kaye ŋga sawap ta nu taŋawamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tane Kuate nu kumuŋ ŋga yabaŋap ta nu kumumbi tiŋgamŋgat ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus nu maŋ kusem wande suŋgo sinam kumba ka taŋge pasa kuklimba tumniŋmba minna le pris gabat kame Israel mage mage afu pro nu kusnanaig: Imaŋge ne kukulnina le ne wam kame te ke likate? Imaŋge ne saŋgri tinmba kukulnina ŋga kusnanaig le ");
INSERT INTO ssd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","nu ndek nane saniŋgina: Ye mata tane wam ande kusnatiŋgi le kumumbi lafuwap ta imaŋge ye wam kame te kam tuku kukulyina ta tane kila satiŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Imaŋge kule pisne piro Yohanus tuna? Kuateŋge e ko taŋgoŋge ŋgina. Taŋakina le nane ka kasomŋge naŋgine naŋgine muŋgu kusnaŋga sakinaig: Sine ndaŋmba sabe. Sine Kuateŋge ŋga sabe ta ndaŋam tane Yohanus tuku son nda ŋginaig ŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ko sine taŋgoŋge ndo ŋgube ta taŋgo pino nane sine mbolŋge wam ŋayonu kamŋgaig. Maŋgur suŋgo te nane ŋakmba Yohanus nu Kuate tuku tuan taŋgo ŋga idusde ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Taŋamba nane Yesus tuku pasa lafumba sakinaig: Iyo. Sine gilai ŋginaig le nu ndek nane saniŋgina: Ariya. Ye mata imaŋge kukulyina le wam kame ke liket te satiŋge nda ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus maŋ lato sakina: Tane pasa te ismba ndaŋmba idusamŋgaig. Taŋgo ande nu kiŋo armba ŋak minna. Nu kumba ka nuŋe kiŋo mulum ta sana: Kiŋo, kite ne kumba ka grep piro mbolŋge piroka ŋga sana le ");
INSERT INTO ssd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","kiŋo ta mam nuŋe sana: Ye mbulit ŋgina. Taŋakina ta mine minemba nu wamdus biye mbilmba tiŋga pirokam kina. ");
INSERT INTO ssd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kile taŋgo ta nu maŋ kumba ka maib nuŋe pasa ndui ta ndo sana le nu lafumba sakina: Ta maye. Ye kaŋgit ŋgina ta nu kine ndakina. ");
INSERT INTO ssd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tane ndaŋmba idusde. Kiŋo ndaŋ mam nuŋe tuku pasa kumumba kina ŋga kusnaniŋgina le nane ndek lafumba sakinaig: Kiŋo mulumŋge ŋginaig. Taŋakinaig le Yesus nu kusem gabat mbal ta saniŋgina: Ye siŋka satiŋgamŋgit. Takis kilanu mbal pino taŋgo didik farde mbal nane tane litiŋmba amboŋga Kuate tuku gageu mayok kinig. ");
INSERT INTO ssd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohanus nu maŋau tiŋreknu tumtiŋgina le tane son nda ŋginaig. Takis kilanu mbal pino nane taŋgo didik farde nane nu tuku pasa ismba son ŋga naŋgine maŋau ŋaigonu kusrekinaig. Nane taŋanaig le tane wam ta kaŋgerkinaig sulumba ŋgamuŋgal biye mbilmba nu tuku pasa mata son nda ŋginaig ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus nu maŋ sakina: Tane yaba pasa ande te mata isap. Kilke miro taŋgo ande nu grep piro ŋguka fondembi kormba nu grep alonu firfirmba kulenu kilam tuku ŋguruŋ wakeina sulumba piro kulatkam tuku wande kuennu o mbolok pilna. Piro ŋakmba deŋpurmba nu piro mbal kilmba patika nu tiŋga kilke kise mbol kina. ");
INSERT INTO ssd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kina ka taŋge minmba ma ma grep alonaig le kamusmba alonu kilam tuku nu mbal afu kukulniŋgina le piro taŋgo tugum kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kumba ka pronaig le nane kaŋgerka kilmba ande tumba paniŋtumba inum tumba balemba ande ndamembi balemba taŋamba taŋamba ke likinaig. ");
INSERT INTO ssd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nane taŋanaig le kilke miro nu amboŋga kukulniŋgina ta limba maŋ gudommba kukulniŋgina le nane mbolŋge mata wam ndui ta ndo ke likinaig. ");
INSERT INTO ssd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Taŋanaig le piro miro nu nuŋe kiŋo nuŋe kukulna le nane tugum kina. Nu teŋenmba isdusna: Nane nu kaŋgermba ye tuku kiŋo ŋga mapewamŋgaig ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Taŋana le piro mbal nane nu prona le kaŋgermba sakinaig: Taŋgo ilit si nu mam nuŋe tuku agaŋ ndende ŋakmba kilam tuku nyu ŋak. Sine nu balebe sulumba piro te siŋgine tube ŋga sakinaig. ");
INSERT INTO ssd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Taŋaka nane nu biye timba bukŋginaig le kilim kina le taŋge balenaig le kumna. ");
INSERT INTO ssd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ye tane kusnatiŋget. Piro miro taŋgo nu taŋgo kame ta tugum promba nane mbolŋge ame wam kamŋgat ŋga kusnaniŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","nane afu nu sanaig: Nu piro mbal ŋaigonu ta kume ŋayonu niŋguwa sulumba nu piro taŋgo afu kitek kilmba patikamŋgat. Alonu kilig ait mbolŋge nane alonu kilmba nu tumba minamŋgaig ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Taŋakinaig le Yesus nu nane saniŋgina: Kuyar pasa ande te tane bur ndakade e? Ndame suŋgo ande wande pilig mbal gisleknu ŋga te-sinaig ta kile wande ta tuku ndame ŋakmba nu mbolŋge saŋgri tiŋgade. Suŋgo nuŋge wam ta kina le sine kaŋgermba pirerek purka gare toreg ŋgate. ");
INSERT INTO ssd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ta tuku ye tane satiŋgamŋgit. Kuate nu tane Israel kile-sika mbal kise nuŋe gageu tuku madiniŋguwa le alonu kumumbi kile-mayokkamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ande nu ndame suŋgo ta mbolŋge bariŋga ndekuwa ta nu isu ŋgurŋgurmba nu kumamŋgat. Ndame suŋgo ta taŋgo ande mbolŋge ndekuwa ta nu du firfiramŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pris gabat kame Farisi mbal ndoŋ nane yaba pasa kame sake likina le ismba nu nane tuku sakina ta katesenaig sulumba ");
INSERT INTO ssd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","nane nu biye tiwam tuku ta maŋgur suŋgo nane nu tuan taŋgo ŋga sakinaig tukunu nane taŋgo pino tuku kuru-kurukinaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus nu maŋ yaba pasa ande saniŋmba sakina: ");
INSERT INTO ssd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Kuate nu nuŋe gageu wike likate wam ta gabat suŋgo ande nuŋe kiŋo pino tam tuku pagumba nye suŋgo pilna taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ait kumuŋgina le nu nuŋe piro taŋgo kukulniŋgina le kumba ka buk saniŋgina mbal ta kilam kinaig. Nane kumba nane saniŋginaig kande nane ŋakmba mbule sulunaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kile gabat suŋgo nu piro taŋgo afu saniŋgina: Tane kumba ka mbal buk saniŋgen ta teŋenmba saniŋgap. Nu makau ande pailnu fatnu afu kuya ŋak turmba bale farmba nyamagaŋ kilmba pagumba kile tane tairŋga minit. Nuŋe kiŋo pino tam tuku pagumba nye ta mbol prowap ŋga saniŋgap ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","nane kumba ka saniŋginaig kande nane ismba ake pasa sakanu sukmba ande nu tiŋga nuŋe piro mbol kina le ande nu tiŋga nuŋe ndametiŋ piro kam kina le ");
INSERT INTO ssd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","nane afu tiŋga nu tuku piro mbal ta kilmba ŋaigo siglika bale farnaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Taŋanaig le gabat suŋgo nu wam ta ismba nu gubra tumba nuŋe kame mbal kukulniŋgina le nane kumba ka nane bale far sulumba nane tuku tumbraŋ piynaig le ugna. ");
INSERT INTO ssd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kile nu nuŋe piro mbal afu saniŋgina: Pino tam tuku pagumba nye buk kuanekit ta saniŋgen mbal ta nane nda prowaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tane kumba ka tumbraŋ suŋgo tuku ndin ŋakmba dubike lika taŋgo ŋakmba kaŋgerka pagumba nye te mbol prowam tuku saniŋgap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Taŋakina le nane kinaig ka ndin ŋakmba dubike lika mbal magenu ŋaigonu turmba kile-siglika ŋakmba kilmba pronaig le pino tam tuku pagumba nye ta tuku wande kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Gabat suŋgo nu pronaig mbal ta kaŋgerkam wandek sinam kumba ande nu pagumba nye tuku kumiŋ tiŋge ndaka ake kumiŋ tiŋgina ta kaŋgerna sulumba ");
INSERT INTO ssd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","taŋgo ta sana: Mata, ne ndaŋam ake te prowat. Ne pagumba nye tuku kumiŋ tiŋgam kuga ŋga kusnana le nu kikonu maninok minna. ");
INSERT INTO ssd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kile gabat suŋgo ta nuŋe piro mbal saniŋgina: Taŋgo te kupe wai ndaleka bukŋgap le mayok ka ma make suŋgo sinam kuwa. Ma ta mbolŋge minamŋgaig mbal nane malmbi suŋgomba maketiŋ tikŋga minamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kuate nu nane gudommba nuŋe gageu minam tuku wikate ta nane ndui ndui ndo nu tuku gageu minam tuku madiniŋgit ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisi mbal nane kumba ka naŋgine naŋgine saka ismba nu ame pasa mbarwa le biye tibe ŋga ndin sotinaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Taŋamba nane naŋgine dubinaig mbal afu Herodus dubinaig mbal afu ndoŋ kukulniŋginaig le Yesus tugum promba sanaig: Tum Taŋgo, ne taŋgo tugusek ta sine kila. Ne ande tuku kiko ndanate. Ne taŋgo nyu ŋak tuku kuru kuru ndakate. Taŋgo ŋakmba Kuate tuku maŋau dubikam tuku tumsiŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ne sine sasiŋga. Sine Zu mbal siŋgine tukul maŋau dubimba Rom gabat Sesar takis tambim kumuŋ e? Ne ndaŋmba iduste ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nane Yesus yabri paknaig ta nu katesemba nane saniŋgina: Tane yabri taŋgo ndo. Ndaŋam ye tagoyade? ");
INSERT INTO ssd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis ndametiŋ ande tumba pro ye tumyap ŋgina le nane ndametiŋ ande tumba pro nu tunaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Taŋanaig le nu ndek nane kusnaniŋgina: Ndametiŋ te mbolŋge ima tuku kanu. Ima tuku nyu minit ŋga saniŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","nane ndek sakinaig: Sesar tuku ŋginaig le Yesus nu nane teŋenmba saniŋgina: Ata. Tane gabat suŋgo Sesar kumnemŋge minig. Nu tambim tuku agaŋ sakate ta nu tape. Kuate nu agaŋ tambim tuku sakate ta Kuate tape ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Taŋakina le nane pasa ta ismba pirerek purka nu kusremba luka kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ki ndui ta mbolŋge Sadusi taŋgo afu Yesus tugum pronaig. Sadusi mbal nane taŋgo kummba maŋ tiŋge nda ŋga idusmba minig tuku. Nane Yesus kusnanaig: ");
INSERT INTO ssd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tum Taŋgo, Moses nu teŋenmba kuyarna: Taŋgo ande kummba pino kuembol kiŋo kugatok kusrewa le maib nuŋeŋge pino ta tumba aba nuŋe tuku kiŋo te-pilwa ŋga kuyarna. ");
INSERT INTO ssd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ariya. Ma te mbolŋge taŋgo ande maib kat nuŋe 7 minnaig. Aba naŋgine pino ande tina sulumba minna ma ma kiŋo kugatok kumna le mambo nuŋe dubiknu nu pino ta tina. ");
INSERT INTO ssd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nu tumba minmba ma ma nu mata kiŋo kugatok kumna le mambo nuŋe keŋnu nu mata taŋana. Taŋamba taŋamba nane 7 ta pino ndui ta ndo tumba ka ka kiŋo kugatok kume farnaig le ");
INSERT INTO ssd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ŋgumneŋga pino kuembol nu mata kumna. ");
INSERT INTO ssd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ata. Ne kumanu mbal tiŋgamŋgaig ŋga sakate ta taŋgo 7 ŋgamukŋge nu ima tuku pino minamŋgat? Nane ŋakmba pino ndui ta ndo tinaig ŋga Yesus sanaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Taŋakinaig le nu nane saniŋgina: Tane Kuate tuku kuyar pasa nu tuku saŋgri tane wamdus pulu ndatiŋgit. Ta tuku tane wamdus mbarde. ");
INSERT INTO ssd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nane kumanu mbal aboŋga tiŋga Kuate tuku eŋel suk minamŋgaig. Nane muŋgu kile nda. ");
INSERT INTO ssd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tane kumanu mbal tiŋge nda ŋga idusmba sakade ta pasa ande sine ŋakmba isam tuku Kuate nu sakina ta tane bur ndakade e? Pasa ta teŋenmba sakate. ");
INSERT INTO ssd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ye Abraham Isak Yakob nane tuku Mbara Suŋgo minet ŋga sakate. Abraham nane kume likinaig ta nduiye ŋgisikinaig kande Kuate ye nane tuku Mbara ŋga Moses sa ndana kande. Nu abo ŋak minig mbal tuku Mbara ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Taŋakina le maŋgur suŋgo Yesus tuku tum pasa ta isnaig sulumba piriri ŋayonaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesus nu Sadusi mbal tuku pasa te-ibeŋna le nane pasa kugatok minnaig ta Farisi mbal nane wam ta ismba nane ŋakmba pro Yesus tugumŋge maŋgurkinaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Taŋamba nane tuku ande nu kusem pasa bitekŋga sakanu taŋgo Yesus tagowam tuku kusnana: ");
INSERT INTO ssd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tum Taŋgo, tukul ndaŋ tukul ŋakmba liniŋmba mbolŋge minit ŋga kusnana le ");
INSERT INTO ssd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","nu lafumba sana: Taŋgine Suŋgo Kuate tane nu tuku kume purmba taŋgine ŋgamuŋgal abo guwa wamdus ŋakmba nu tape. ");
INSERT INTO ssd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tukul pasa ta tukul ŋakmba liniŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tukul ande taŋaŋ nu dubiknu teŋenmba. Tane taŋgine ŋgarosu tuku kume purde taŋamba ndo tane tugumŋge minig mbal tuku kume purap. ");
INSERT INTO ssd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tukul armba ta tukul pasa afu tuan taŋgo kame tuku pasa ta ŋakmba tuku tugu minik ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi mbal nane taŋge maŋgurka minnaig le Yesus nu nane kusnaniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Kuateŋge madina taŋgo Kristus nu ima tuku mbuŋ ŋga idusde ŋga kusnaniŋgina le nane sakinaig: Nu David tuku mbuŋ ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Taŋakinaig le nu nane saniŋgina: Ta son ndeta Tukul Guwa nu ndaŋam David wamdus tuna le nu Kristus tuku saka nu ye tuku Suŋgo ŋga teŋenmba kuyarna. ");
INSERT INTO ssd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Suŋgo Kuate nu ye tuku Suŋgo sana: Ne ye tuku ndinam kumam teŋge saŋgri ŋak minyok mina le ma ma yeŋge ne tuku ŋgueu mbal ŋakmba kile-ibeŋka ne tuku kupe kumnemŋge patikamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David nu taŋamba kuyarmba nu ye tuku Suŋgo ŋgina. Ata. Nu David tuku mbuŋ ndo e ko nu David tuku Suŋgo ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nu taŋamba kusnaniŋgina ta ŋakmba nu tuku pasa lafuwam fugumba maninok minnaig. Taŋamba nane ki ait ta mbolŋge ŋgumneŋga mata nu kuru-kuruka wam ande kusna ndanaig. ");
INSERT INTO ssd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kile Yesus nu nuŋe dubiwanu taŋgo maŋgur suŋgo ta turmba saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kusem pasa tugunu bitekŋganu mbal Farisi mbal nane Moses taŋaŋ tukul pasa bitekŋga sanu tuku ndo piro ta biyig ta ");
INSERT INTO ssd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","nane sakade pasa ta nane kumu ndade. Tane nane sakade ta dubikap sulumba nane tuku maŋau dubi ndakap. ");
INSERT INTO ssd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nane tukul maŋau gudommba agaŋ pitinu taŋaŋ taŋgo mbolŋge patika minde bada suŋgo niŋgig ta nane naŋgine miroŋ fudiŋmba tur ndakade. ");
INSERT INTO ssd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nane afuŋge kaŋgerkuwaig ŋga nane taŋgo am mbolŋge wam magenu kade. Nane tukul pasa patinu tuku niŋgot wakeika tukul pasa kuyarka sigrika tumail mbol wai mbol kusmba ŋak likade. Naŋgine tawi mbolŋge nzale kugennu wakeikade. ");
INSERT INTO ssd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nane pagumba nye suŋgo ko kusem wandekŋge nane taŋgo tumailamŋge minyokam tuku nzaliniŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nane maket mbolŋge lika taŋgo nane sugo ŋga kaiyeniŋguwaig ŋga kilba pilig. Afuŋge nane kaŋgerka tum taŋgo ŋgade le nane gare suŋgoniŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tane taŋa ndawap. Ande nu tane tum taŋgo ŋguwa kande tane nu peuwap. Ndindo ndo nu Tum Taŋgo minit. Tane ŋakmba kumu kumu tira minig. ");
INSERT INTO ssd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kilke te mbolŋge gabat taŋgo ande yiŋe mam nda ŋgap. Tane tuku Mam ndindo nu samba mbolŋge minit. ");
INSERT INTO ssd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Afuŋge tane sugo ŋguwaig kande tane nane peuniŋgap. Tane tuku Suŋgo ndindo ndo minit. Nu Kristus. ");
INSERT INTO ssd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tane ŋgamukŋge ima nu suŋgo minam idusmba ndeta nu tane ŋakmba tuku piro taŋgo taŋaŋ minwa. ");
INSERT INTO ssd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ande nu nuŋe nyu payamkuwa ta Kuateŋge nu tuku nyu te-ibeŋamŋgat. Ande nu nuŋe nyu yabukuwa ta Kuateŋge nu tuku nyu te-mayokamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kusem pasa tugunu bitekŋganu mbal Farisi mbal ose. Tane yabri taŋgo ndo. Tane nane afu Kuate tuku gageu mayok kambim tuku ndin tukulde. Tane Kuate tuku gageu mayok kambim mbulmba nane afu mayok kambim bafude le nane peuniŋgig. ");
INSERT INTO ssd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Osese. Kusem pasa bitekŋganu mbal Farisi mbal tane pino kuembol kame tuku agaŋ ndende didika kile-suluwe niŋgig. Taŋgine ŋayonu ta yabukam tuku taŋgo am mbolŋge Kuate yabaŋ kuende. Ta tuku tane pa lato tamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Osese. Kusem pasa bitekŋganu mbal Farisi mbal tane taŋgine dubikanu taŋgo ndindo ndo te-silinu tuku yu mbol mbol kilke mbol mbol sota ma masken kinig. Ande tane dubikate le taŋgine yabri maŋau ta tumde le nu tane litiŋmba pa suŋgo ŋayo tam tuku minit. ");
INSERT INTO ssd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Tane am tukulok minmba tugusemba ndin tum ndaniŋgig mbal ose. Tane teŋenmba sakade. Ande nu nuŋe pasa saŋgri pilewam tuku kusem wande nyun tate ta ake. Nu kusem wande sinamŋge golmbi wakeikinaig agaŋ kame nyun kilig ta nu nuŋe pasa ta kumuwa ŋgade. ");
INSERT INTO ssd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tane am tukulok ŋginŋgan mbal ndo. Gol kame ta Kuate tuku wande sinamŋge minig tukunu nane tukul. Kuate tuku wande ta gol kame liniŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tane teŋenmba mata sakade. Ande nu nuŋe pasa saŋgri pilewam tuku Kuate tuku atrau mbain nyun tate ta ake. Nu atraukam tuku agaŋ mbain mbolŋge minit ta nyun tate ta nu nuŋe pasa ta kumuwa ŋgade. ");
INSERT INTO ssd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tane siŋka am tukulok mbal ndo. Atraukam tuku agaŋ ta atrau mbain mbolŋge minit tukunu nu tukul. Atrau mbain ta atrau agaŋ lite. ");
INSERT INTO ssd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ta tuku ande nu nuŋe pasa saŋgri pilewam tuku atrau mbain nyun tate ta agaŋ mbain mbolŋge minit ta turmba nyun tate. ");
INSERT INTO ssd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ande nu nuŋe pasa saŋgri pilewam tuku wande suŋgo nyun tate ta Kuate nu wande ta mbolŋge minit nu turmba nyun tate. ");
INSERT INTO ssd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ande nu nuŋe pasa saŋgri pilewam tuku samba nyun tate ta nu Kuate tuku minyo mbili suŋgo turmba nyun tumba Kuate nu ta mbolŋge minit nu mata nyun tate. ");
INSERT INTO ssd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kusem pasa bitekŋganu mbal Farisi mbal ose. Tane yabri taŋgo ndo. Tane tukul ande dubimba piro kareŋka agaŋ foŋfoŋ ŋguna ilinzu ŋakmba maŋgur 10 patika ande Kuate tuwig. Tane taŋade sulumba tane tukul maŋau sugo kusreka maŋau tiŋreknu mape maŋau taŋgo pino ŋgamukŋge ke ndaka taŋgine piro tugusemba biye ndakade. Tane tukul sugo ta turmba kade kande maye kande. ");
INSERT INTO ssd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tane am tukulok minmba taŋgo pino tugusemba ndin tum ndaniŋgig. Tane ŋgailmbo kule sinamŋge kaŋgermba pitaide sulumba kamel kule sinamŋge minit ta kaŋger ndamba kule tur ŋinkade. ");
INSERT INTO ssd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kusem pasa bitekŋganu mbal Farisi mbal ose. Tane yabri taŋgo ndo. Tane taŋgine waim nza saŋgilnu minya mayede ta taŋgine ŋgamuŋgal agaŋ ndende gudommba kilam tuku piririmba agaŋ terokam tuku wamdus liganu minig. ");
INSERT INTO ssd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi mbal tane am tukulok minig. Taŋgine waim nza sinanu kutur ŋakmba ta sauka minya mayewap le saŋgilnu turmba kau prowa. ");
INSERT INTO ssd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kusem pasa bitekŋganu mbal Farisi mbal ose. Tane yabri taŋgo ndo. Taŋgo kumu mbolŋge ndame suku kaukauk mindepiye mayenu prote ta sinam taŋge isu meŋga mundurkate taŋaŋ tane minig. ");
INSERT INTO ssd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tane taŋgo am mbolŋge tiŋreknu ndo minig. Taŋgine ŋgamuŋgal sinamŋge yabri maŋau kutur maŋau ligmba meŋga minig. ");
INSERT INTO ssd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kusem pasa bitekŋganu mbal Farisi mbal ose. Tane yabri taŋgo ndo. Tane tuan taŋgo kame tuku kumu mbolŋge ndame magenu patika taŋgo tiŋreknu tuku kumu mbolŋge mindepiye mayenu patika sakade: ");
INSERT INTO ssd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Sine tuku mbuŋ kame tuku ait mbolŋge sine mingeŋ kande nane tuan taŋgo kame tuku ndare kutuwe niŋginaig ta sine nane ndoŋ ulendi ndakigeŋ kande ŋgade. ");
INSERT INTO ssd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tane taŋamba pasa sakade ta taŋgine tugu te-mayokde. Kuate tuku tuan taŋgo kame bale farniŋginaig mbal ta tane nane tuku fat ŋgade. ");
INSERT INTO ssd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ese. Tane taŋgine mbuŋ kame tuku maŋau ŋaigonu ta tuturap le suŋgokuwa. ");
INSERT INTO ssd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tane mbeŋ ŋaigonu tuku fat. Tane pa ŋayonu tam tuku minig. Tane pa ta laipam tuku ndin kuga. ");
INSERT INTO ssd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ta tuku ye tuan taŋgo kame taŋgo wamdus kuyar magenu Kuate tuku pasa kukliwam tuku kukulniŋgi le tane tugum prowaig le tane nane afu kilmba bale farka afu ail kazrai mbolŋge patikamŋgaig. Afu taŋgine kusem wandekŋge ŋgusniŋmba afu kilmba amsesekap le nane kua ka sili-silimba tumbraŋ ŋakmba mbol kine prowamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tane taŋawap le taŋgo tiŋreknu kilke te mbolŋge bale farde ta nane ŋakmba tuku ndare taŋge tane pasokamŋgat. Abo abo taŋgo tiŋreknu Abel nu tugu pilmba ndare kutukina. Ta tuturmba kumba ka nane Berekia tuku kiŋo nuŋe Sakaria nu Kuate mbariŋam tuku mbain atrau mbain ŋgamukŋge minna le nane pro nu balemba ndare kutunaig. ");
INSERT INTO ssd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ye siŋka satiŋgamŋgit. Nane ŋakmba ndare kutuniŋge likinaig ndare taŋge tane pasokamŋgat ŋga saniŋgina sulumba sakina: ");
INSERT INTO ssd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O Yerusalem, Kuate nu buk tuan taŋgo kame kukulniŋgina le ne kilmba bale farmba afu ndamembi bale farniŋgina. Teg inonu fat kilmba tawo sirite taŋaŋ ye tane kilmba tawo siriwam bafuwet le tane ye ram kua kinig. ");
INSERT INTO ssd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tane isap. Kile Kuate nu tane ŋgamukŋge mine ndakate. ");
INSERT INTO ssd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ye tane satiŋget. Tane ye nda kaŋgeryap sulumba maŋ kaŋgeryumba ndek sakamŋgaig. Ne Suŋgo tuku nyu mbolŋge prote. Suŋgoŋge ne nyaro tinwa ŋga sakamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesus nu mayok ka kusem wande suŋgo ta kusremba kumba minna le nuŋe dubinaig mbal nane nu tugum promba kusem wande suŋgo ta tuku wande magenu ŋakmba kaŋgerkuwa ŋga nu samba tumnaig le ");
INSERT INTO ssd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","nu ndek nane saniŋgina: Ye siŋka satiŋgamŋgit. Tane wande ŋakmba kaŋgerkade te ŋgumneŋga ndame ŋakmba muŋgu sailka mine nda. Afuŋge sambriniŋguwaig le ŋakmba kutusewamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nane kumba ka Olif tabe mbol promba Yesus nu minyokina le nuŋe dubinaig taŋgo naneŋge ndo nu tugum promba sanaig: Ne kusem wande ŋayoŋgamŋgat ŋga sasiŋgat ta ginu mara prowamŋgat. Sine ame maŋau kaŋgermba ne prowam tuku ait kilke te kugawam tuku ait patukate ŋga idusmba katesewamŋgig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","nu ndek lafumba saniŋgina: Tane riroŋ mayewap. Nane afu gudommba pro tane yabritiŋmba ");
INSERT INTO ssd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ye tuku nyu tumba ye Kristus Kuateŋge madiyina taŋgo ŋga nane gudommba didikuwaig le ndenuŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tane kame sugo maskenŋge mayok kuwaig le pasa ismba ko taŋgine tugumŋge kame zigna afu ismba wamdus te-sulu ndawap. Wam kame ta siŋka prowe likamŋgaig ta kugawam tuku ait ta kile. ");
INSERT INTO ssd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kilke ande tiŋga kilke kise ndoŋ kame buwamŋgaik. Gabat ande nuŋe gageu kilmba gabat kise tuku gageu ndoŋ kame buwamŋgaig. Ma yimyam mbolŋge guba mumni prowe likamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Piti kame ta pino kutu te-palmbim tuku ŋgaro rar tate taŋaŋ prowamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Afuŋge tane bige tidiŋga piti suŋgo tam tuku gabat afu tuku wai mbolŋge patikuwaig le nane tane kilmba bale faramŋgaig. Tane yiŋe mbal tukunu kilke tugu ŋakmba tane kasurtiŋgamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Piti ta sinamŋge nane gudommba ye kusreyumba ndeka naŋgine naŋgine muŋgu kupet minmba muŋgu kasurka minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yabri tuan taŋgo gudommba mayok kuwaig sulumba taŋgo gudommba didikuwaig le nane yabri maŋau dubikamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ait ta mbolŋge maŋau ŋaigonu tugeka suŋgokuwa le taŋgo nane naŋgine naŋgine muŋgu iduska muŋgu turke nda. ");
INSERT INTO ssd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ande nu ye kusre ndayumba minmba ka kumwa ta Kuateŋge nu tuku muskil te-tiwe tambimŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kuate nu nuŋe gageu kulatkate pasa mayenu ta kilke tugu ŋakmba mbolŋge kukliwe likuwaig le ŋakmba iswaig le kugawam tuku ait prowamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tuan taŋgo Daniel tuku pasa ŋgumneŋga kumuŋguwa le ande ŋule parak tukul ma mbolŋge mayok ka tukul kuerka kutur tambimŋgat. (Tane pasa te burkade mbal tane wamdus pulutiŋguwa). ");
INSERT INTO ssd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tane Daniel tuku pasa kumuŋguwa le kaŋgermba Yudea mbal nane kua ka tabe poŋguwaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ande nuŋe wande kawaŋŋge minmba kande nu wandekŋge agaŋ ndende afu kilam idus ndamba pitik ndo kua kuwa. ");
INSERT INTO ssd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ande nu nuŋe piro mbolŋge minmba kande luka pro nuŋe tawi tam idus ndawa. ");
INSERT INTO ssd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ait ta mbolŋge pino fuŋgulok pino kiŋo dabronu amo nyanu ŋak ose. Nane piti suŋgo kaŋgeramŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tane Kuate yabaŋap le murke ait mbolŋge ko kusem ait mbolŋge maŋau ta pro ndawa. ");
INSERT INTO ssd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ait ta mbolŋge piti suŋgo pasa ŋak prowamŋgat. O buk tugu mbolŋge ka kile mata piti afu taŋaŋ kaŋger ndakeg. Piti ta kugawaig le maŋ piti taŋaŋ prowe nda. ");
INSERT INTO ssd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kuate nu nane kilam tuku madiniŋgina mbal idusniŋmba piti ait kuen ta kuerkina le ait fagnu ndo piti ta prowamŋgat. Nda kuerkina kande ait ta prowa le taŋgo ŋakmba ŋgisike sulude kande. ");
INSERT INTO ssd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ande nu tane satiŋmba kaŋgera Kristus Kuateŋge madina taŋgo minit te ko nu minit si ŋguwa kande nu tuku pasa ise ndakap. ");
INSERT INTO ssd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yabri taŋgo prowaig sulumba afu ye Kristus ŋgumba afu ye Kuate tuku tuan taŋgo ŋgamŋgaig. Nane Kuate madiniŋgina mbal yabriniŋmba didikube ŋga wam kitek saŋgrinu ke likamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wam kame ta siŋka prowamŋgaig. Ta tuku ye tane wam pagutiŋget. ");
INSERT INTO ssd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nane afu Kristus nu ma baknu mbolŋge minit ŋga satiŋguwaig kande nu kaŋgeram kine ndakap. Ko afu nu wande te sinamŋge kuirka minit ŋga satiŋguwaig kande tane nane tuku yabri pasa ta ise ndakap. ");
INSERT INTO ssd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Teliŋ nu ki prote ma mbolŋge teliŋmba pinderka kumba ka ki butuŋgate kumam kumba samba ŋakmba kilŋate taŋamba ndo ye Ndindo Katesek Taŋgo prowamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Agaŋ ande kumanu meŋga mundur kinit le wir taŋge minig. ");
INSERT INTO ssd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Sina manzer ait suŋgo ta kugawa le ki mukumba dabunuŋgat. Tambun mata buluŋge nda. Samba tuku saŋgri ŋakmba pirpurka buru-burukuwaig le mbai ŋakmba guroromba ndeke lika minamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wam kame ta mayok kuwaig le ye Ndindo Katesek Taŋgo ye samba mbolŋge mayok kaŋgit. Mayok ka ye kilŋa saŋgri suŋgo pasa ŋak gau mbolŋge ndeki le kilke mbolok mbal ŋakmba ye kaŋgeryumba wikaraumba malmbi ŋayowamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tabil wi suŋgo ande mayok kuwa le ye yiŋe eŋel kame kukulniŋgi le kilke tugu ŋakmba mbolŋge Kuateŋge nuŋe madiniŋgina mbal kile-maŋgurkamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Tane fik ail kaŋgerap. Nuŋge tumtiŋgamŋgat. Tane kuzrunu kitek promba nzude le kaŋgerka katesemba sakade: Ki ait patukate ŋgade. ");
INSERT INTO ssd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Taŋamba ndo wam kame sakit te prowaig le kaŋgerka ye prowam tuku ait patukate ta kila palmbimŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ye siŋka satiŋgamŋgit. Ait te mbolŋge minig mbal kume ndakuwaig le wam kame ŋakmba ta prowamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kilke tugu samba tugu ŋgisinuŋgaig. Ye tuku pasa ande ŋgisike nda. Minmba minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ginu mara ki kanum ndaŋ wam kame ta prowamŋgaig ta ande nu kila mine ndakate. Samba mbolŋge eŋel mata nane gilai. Ye Kuate tuku Kiŋo ye mata gilai. Mam nu ndo kila minit. ");
INSERT INTO ssd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noa tuku ait mbolŋge maŋau pronaig taŋamba ndo ye Ndindo Katesek Taŋgo prowam tuku ait mbolŋge maŋau ndui ta mayok kaŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kule suŋgo pro ndana le nane nyamagaŋ kule nyumba pino piyamba kilmba taŋamba taŋamba minnaig ma ma Noa nu waŋ poŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Waŋ poŋgina le ndo kule suŋgo promba nane ŋakmba ma gureŋmba kile-butokina le nane wamdus puluniŋgina. Taŋamba ndo ye Ndindo Katesek Taŋgo prowi le ndo nane ye idus ndayade mbal wamdus puluniŋgamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ait ta mbolŋge taŋgo armba piro ndindo mbolŋge minwaik le ye inum tumba inum kusrewamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pino armba wit firfirmba minwaik le ye inum tumba inum kusrewamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Taŋgine Suŋgo nu ginu mara prowamŋgat ta tane gilai. Ta tuku tane mambilmba tairŋga minap. ");
INSERT INTO ssd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wande miro taŋgo kuayar taŋgo prowam tuku ait pasa isit kande nu wande kulatka minmba kuayar taŋgo pro kuayaram tuku peute kande. ");
INSERT INTO ssd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tane kuaneka ye tairŋga minap. Ye Ndindo Katesek Taŋgo tane mata ait gilai minap le ye prowamŋgit ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesus nu maŋ lato sakina: Taŋgo ande wamdus kuyar mayenu ŋak piro mayete ta taŋgo suŋgo nu tumba nuŋe piro mbal kulatka ait kumuŋguwa le nyamagaŋ walmba niŋgam tuku nu pilit. ");
INSERT INTO ssd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Taŋgo ta nuŋe piro kumba minwa le nuŋe suŋgo promba kaŋgerwa le nu gare ŋak minamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ye siŋka satiŋgamŋgit. Nuŋe suŋgo taŋamba nu kaŋgermba nu nuŋe agaŋ ndende ŋakmba kulatkam tuku nu tumba palmbimŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ko piro taŋgo ta ŋayonu ndeta yiŋe suŋgo dalkate ya ŋga saka ");
INSERT INTO ssd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nu ndek kulatkate mbal pani farmba kule kamenu nyade mbal ndoŋ ulendika nyamagaŋ kule kamenu nyumba ");
INSERT INTO ssd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nuŋe suŋgo luka prowam tuku ait idus ndamba minwa le nu prowamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nu promba nu piti suŋgo tumba pitaiwa le ma ŋayo yabri mbal ŋgamukŋge minamŋgat. Ma ŋayo ta mbolŋge minamŋgaig mbal nane malmbi suŋgomba maketiŋ tikŋga minamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesus nu maŋ teŋenmba sakina: Kuate nu nuŋe gageu kilam tuku prowamŋgat ta wam kube te suk. Pino mbanzo 10 nane taŋgo ande pino tam tuku prowam bafuna le nu te-silikam tuku naŋgine lam kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pino mbanzo 5 ta nane wamdus kugatok. Nane 5 afu ta nane wamdus kuyar mayenu ŋak. ");
INSERT INTO ssd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pino wamdus kugatok ta nane kambim ŋga naŋgine lam kilmba kule kile ndaka kinaig le ");
INSERT INTO ssd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","pino wamdus kuyar mayenu ŋak ta nane kambim ŋga naŋgine lam kilmba kule turmba kilmba kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nane kinaig ka taŋgo pino tam tuku ta nu dalka pitik nda prona le minde ma ma ginyumniŋgina le kinynaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Furir ŋgamu wi ande mayok kina: Ai si. Taŋgo pino tam tuku prote si. Tane mayok ka kaŋgerap ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","pino kame ta ŋakmba aboŋga naŋgine lam bulu suŋgowam tuku wik wilnu mbilniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Taŋanaig sulumba pino kame wamdus kugatok taŋge nane ndek pino wamdus ŋak ta saniŋginaig: Sine kule afu siŋgap. Sine tuku lam kupam bafude ŋga saniŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","wamdus kuyar mayenu ŋak mbal ndek nane saniŋginaig: i ... Sine tane kule tiŋbe ta tane sine turmba lam kupe likamŋgaig. Tane luka kumba stua mbolŋge kule afu sota piyawap ŋga saniŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nane lam kule piyawam kinaig le taŋgo pino tam tuku ta nu prona le pino 5 nane nu tairŋga minnaig ta nu ndoŋ pagumba nye suŋgo tuku wande sinam kumba malaŋga tukulnaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Malaŋga tukulmba minnaig le pino 5 ta luka pro malaŋga katmba sakinaig: Suŋgo, malaŋga talka. Sine prowig o ŋginaig kande ");
INSERT INTO ssd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","taŋgo ta nu pasa lafumba saniŋgina: Tane ima kate. Ye siŋka tane gilai ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesus nu taŋamba ndek lato sakina: Ait ta ginu mayok kaŋgat ginu mara ki kanum ndaŋ mbolŋge ye prowamŋgit ta tane gilai tukunu tane ye tairŋga mambilmba minap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesus nu maŋ sakina: Kuate nu nuŋe gageu kilam tuku prowamŋgat ta wam kube te suk. Taŋgo ande nu kilke masken ande mbol kambim ŋga nuŋe agaŋ ndende kulatkam tuku nuŋe piro mbal tuku wai mbolŋge patikina sulumba ");
INSERT INTO ssd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","nu nane tuku maŋau kaŋgerka kumumbi piro walmba niŋgina. Nu piro taŋgo ande ndametiŋ soŋ 500 tumba ande soŋ 200 tumba ande soŋ 100 tuna. Nane ndametiŋ tambi pirokuwaig ŋga nu tiŋga ma masken kina. ");
INSERT INTO ssd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Piro taŋgo nu soŋ 500 kilna ta nu pitik ndo kumba ka ndametiŋ tambi piroka minna ma ma soŋ 500 maŋ lato kilna. ");
INSERT INTO ssd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wam ndui ta ndo piro taŋgo nu soŋ 200 kilna ta nu pitik ndo kumba ka ndametiŋ tambi piroka minna ma ma soŋ 200 maŋ lato kilna le ");
INSERT INTO ssd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","piro taŋgo nu soŋ 100 kilna ta nu kumba ka kilke sarka burok ta sinamŋge ndametiŋ patika yubeŋgina le taŋge minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Taŋamba minnaig ma ma suŋgo nu luka promba nuŋe ndametiŋ piro mbal niŋgina ta kilam tuku saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Taŋakina le ande nu soŋ 500 tuna ta nu pro sana: Suŋgo, ne buk soŋ 500 ye sina. Ai te. Ye tambi piroka maŋ soŋ 500 lato kilen ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","nuŋe taŋgo suŋgo nu sana: Ese. Ne piro taŋgo mayenu. Ne piro mayena. Ne ye tuku agaŋ fudiŋndo kulat mayena tukunu kile ne piro suŋgo kulatkam tuku ye ne palmbimŋgit. Ne yale. Ne ye ndoŋ sile gare-garekamŋgik ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kile ande nu soŋ 200 tuna ta nu pro sana: Suŋgo, ne buk soŋ 200 ye sina. Ai te. Ye tambi piroka maŋ soŋ 200 lato kilen ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","nuŋe taŋgo suŋgo nu sana: Ese. Ne piro taŋgo mayenu. Ne piro mayena. Ne ye tuku agaŋ fudiŋndo kulat mayena tukunu kile ne piro suŋgo kulatkam tuku ye ne palmbimŋgit. Ne yale. Ne ye ndoŋ sile gare-garekamŋgik ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kile ande nu soŋ 100 tuna ta nu pro teŋenmba sana: Suŋgo, ne taŋgo wamdus kareŋnu ŋak ta ye kila. Nane afu pirokade le ne pro alonu ake kilit. Afu agaŋ tumunu ŋgukade le ne pro goniŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ye ne tuku kuru-kuruka naŋe soŋ 100 ta ŋgisikikat ŋga kilmba kilke sarka burok sinamŋge yubeŋgen. Naŋe soŋ 100 ta noten ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Taŋakina le nuŋe taŋgo suŋgo ndek nu sana: Ne siŋka piro taŋgo ŋayonu. Ne kanyum taŋgo ndo. Nane afu pirokade le ye pro alonu ake kilet ŋga iduste? Afu agaŋ tumunu ŋgukade le ye pro goniŋget e? ");
INSERT INTO ssd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yiŋe maŋau ne kila ta ndaŋam saka ye tuku soŋ 100 beŋ mbolŋge pile ndakina. Ne taŋana kande ye pro yiŋe ndametiŋ lafunu lato kilet kande ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Taŋamba nu nuŋe piro mbal saniŋgina: Soŋ 100 yaimba taŋgo nu soŋ 1,000 ŋak ta tape ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ande nu agaŋ afu ŋak minit ta andeŋge nu maŋ lato tuwit le nu suŋgomba ŋak minamŋgat. Ande nu agaŋ denkanu minit ta andeŋge nu tuku agaŋ fudiŋndo ta yaite. ");
INSERT INTO ssd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Piro taŋgo kanyum sambek ta tumba kilimŋge bukŋgap le ma make suŋgo mbol kuwa. Ma ta mbolŋge nane malmbi suŋgomba maketiŋ tikŋga minamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ye Ndindo Katesek Taŋgo ye yiŋe kilŋa suŋgo eŋel kame ndoŋ prowi sulumba ye yiŋe minyo mbili maditaknu mbolŋge minyokamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ye minyoki le kilke tugu ŋakmba pro ye tugumŋge maŋgurkamŋgaig. Nane taŋawaig le sipsip kulatkanu taŋgo nu sipsip meme lislis minig le pileŋga kise kise patikate taŋaŋ ye maŋgur ta paplamba kuasmbi armba patinuŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Taŋamba ye sipsip kilmba yiŋe ndinamŋge patiki sulumba meme kilmba yiŋe ŋaiŋamŋge patinuŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ye Suŋgo ye yiŋe ndinamŋge minamŋgaig mbal ta teŋenmba saniŋgamŋgit: Yiŋe Mam nu siŋka tane make patikate. Tane yalpe. Nu kilke te te-mayok ndana ait mbolŋge tane nuŋe gageu mayok ka nu ndoŋ minam tuku maditiŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ye gubayina le tane nyamagaŋ sinaig. Ye kule parayina le tane kule sinaig. Ye rawe taŋgo taŋaŋ minen le tane ye tumba kulatkinaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ye tawi kugatok minen le tane tawi sinaig. Ye guaze ten le tane ye turyinaig. Ye muli wandekŋge minen le tane ye kaŋgeryam tuku pronaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ye taŋamba nane saniŋgi le nane tiŋreknu mbal ta lafumba sayamŋgaig: Suŋgo, sine ginu ne gubak minna le kaŋgernumba nyamagaŋ tingeŋ. Ko ne kule paranina le kule tingeŋ. ");
INSERT INTO ssd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ginu ne rawe taŋgo taŋaŋ minna le ne tumba kulatkigeŋ. Ko ginu ne tawi kugatok minna le ne tawi tingeŋ. ");
INSERT INTO ssd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Sine ginu ne guaze ŋak ko muli wandekŋge minna le ne kaŋgernam tuku progeŋ ŋga kusnayamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Taŋakuwaig le ye Suŋgo ye pasa lafumba saniŋgamŋgit: Tane yiŋe mbal nyu kugatok turkinaig ta tane ye turyanu taŋaŋ ŋga saniŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kile ye yiŋe ŋaiŋamŋge minamŋgaig mbal ta teŋenmba saniŋgamŋgit. Tane pa suŋgo tam tuku minig mbal tane ye kusreyumba kape. Kuate nu o buk Satan nuŋe eŋel kame ndoŋ minam tuku pa kuanekina ta mbol kape. ");
INSERT INTO ssd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ye gubak minen le nyamagaŋ se ndakinaig. Kule parayina le tane kule se ndakinaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ye rawe taŋgo taŋaŋ minen le tane ye kulat ndakinaig. Ye tawi kugatok minen le tane ye tawi se ndakinaig. Ye guaze ŋak ko muli wandekŋge minen le tane pro ye kaŋger ndayinaig ŋga saniŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ye taŋamba saniŋgi le nane mata pasa ndui ta ndo lafumba sayamŋgaig: Suŋgo, ne ginu mara gubak ko kule paranina ko rawe taŋgo taŋaŋ minna ko tawi kugatok ko guaze ŋak ko muli wandekŋge minna le kaŋgernumba tur ndanigeŋ ŋgamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nane taŋakuwaig le ye nane teŋenmba saniŋgamŋgit: Ye siŋka satiŋget. Tane yiŋe mbal nyu kugatok tur ndakinaig ta ye tur ndayanu taŋaŋ ŋga saniŋgamŋgit. ");
INSERT INTO ssd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mbal te nane ma ŋayo mbol kumba rar kamusmba minmba minamŋgaig. Rar ta kugawe nda. Mbal tiŋreknu nane abo tugu ŋak minmba minamŋgaig. Kume nda. ");
INSERT INTO ssd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus nu pasa ŋakmba saniŋge deŋpurmba nu nuŋe dubiwanu taŋgo saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ki ait armba kugawaik le pagumba nye suŋgo Pasowa prowamŋgat ta tane kila. Prowa le nane afuŋge ye tumba ail kazrai mbolŋge kumi ŋga afu tuku wai mbolŋge palmbimŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ait ta mbolŋge pris gabat mbal Israel mage ndoŋ pris suŋgo Kaiafas tuku wande mbol maŋgurkinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","nane Yesus kuirkuirka biye timba balewaig ŋga ndin sotinaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nane teŋenmba sakinaig: Sine pagumba nye tuku maŋgur suŋgo sinamŋge nu biye tibe ta ŋayo. Kame zigna suŋgo mayok kakat ŋga saka minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betani tumbraŋŋge Yesus nu taŋgo ande buk ŋgirŋger ŋak nyunu Simon nu tuku wandekŋge isukusmba minna. ");
INSERT INTO ssd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Isukusmba minna le pino ande ndame botol gureŋ mundur mayenu ŋak piyanu o mbolŋge ta tumba Yesus tugum promba nu tuku gabat mbolŋge gureŋ ta kutuna. ");
INSERT INTO ssd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Taŋana le nuŋe dubiwanu taŋgo wam ta kaŋgermba nane palseŋniŋgina le sakinaig: Ndaŋam saka gureŋ mayenu ake kutuwat a. ");
INSERT INTO ssd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nu gureŋ ta tumba nane afu mbolŋge piyana kande nu ndametiŋ suŋgo tina le ndametiŋ tambi sine sanzal mbal turkeg kande ŋga sakinaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Taŋakinaig le nu pasa ta ismba ndek saniŋgina: Ndaŋam tuku tane pino te piti serde. Nu ye mbolŋge wam mayewat. ");
INSERT INTO ssd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sanzal mbal mara mara tane ŋgamukŋge minamŋgaig. Ye tane ndoŋ ait kuennu mine nda. ");
INSERT INTO ssd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pino nu gureŋ mayenu tembi ye tuku ŋgarosu pisnewat ta nu ye ŋgunu tuku ŋgarosu wakeiyat. ");
INSERT INTO ssd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ye siŋka satiŋgamŋgit. Kilke tugu ŋakmba mbolŋge nane pasa mayenu kuklimba nu wam kat te turmba sakuwaig le nane ismba nu tuku saka minamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kile nane 12 ta tuku ande Yudas Iskariotnu nu ka pris gabat mbal tugum promba saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ye Yesus tumba tane tuku wai mbolŋge pili ta piyanu giganmba ye samŋgaig ŋgina le nane ndek silwa ndametiŋ soŋ keŋmba nu tunaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tunaig le Yudas nu kumba ka Yesus tumba nane tuku wai mbolŋge palmbim tuku ait mayenu ande tairŋga minna. ");
INSERT INTO ssd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bret yis kugatok nyam tuku kusem ait amboŋganu mbolŋge Yesus dubiwanu taŋgo nu tugum promba kusnanaig: Sine aniŋge ne ndoŋ Pasowa nyam tuku ka kuanekube ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","nu ndek saniŋgina: Yerusalem tumbraŋ suŋgo mbol kape. Taŋgo ande ye tane satiŋgi le nu tugum kumba sawap: Tum Taŋgoŋge nuŋe ait buk patukate ŋgat. Nuŋe dubinaig taŋgo ndoŋ ne tuku wandekŋge Pasowa nyam tuku sasiŋgat ŋga sawap. ");
INSERT INTO ssd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesus nu taŋamba sakina le nuŋe dubinaig taŋgo nane taŋamba kumba ka Pasowa nyam tuku agaŋ ndende kuanekinaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Furirna le Yesus nu nuŋe dubiwanu taŋgo 12 ndoŋ kumba ka isukusmba minmba ");
INSERT INTO ssd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","nu ndek sakina: Ye siŋka satiŋgamŋgit. Tane ŋgamukŋge ande nu ye tuku kupet minit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Taŋakina le nane wamdus ŋaigoŋga ndui ndui nu kusnanaig: i ... Suŋgo ne yeŋge ŋga iduste e ŋga kusnanaig le ");
INSERT INTO ssd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","nu lafumba sakina: Ande nu ye ndoŋ nza tuma bret kule pak mbilmba nyat ta not. ");
INSERT INTO ssd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ye Ndindo Katesek Taŋgo ye kuyar pasa kumumba kumamŋgit ta ande nu ye tumba nane wai mbolŋge palmbimŋgat ta ose. Nu piti suŋgo tamŋgat. Ina nuŋeŋge te-pile ndakina kande maye kande ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Taŋakina le nuŋe kupet taŋgo Yudas nu ndek sakina: i ... Tum taŋgo, ne yeŋge ŋga iduste e ŋgina le Yesus nu lafumba sana: Ne sakate not ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nane isukusmba minmba Yesus nu maŋ bret tumba Kuate gare pasa tumba fetfetmba nuŋe dubiwanu taŋgo niŋmba sakina: Bret te tumba nyap. Te yiŋe ŋgarosu ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Taŋamba nu grep kule murko ŋak ta mata tumba Kuate gare pasa tumba nane niŋmba sakina: Tane ŋakmba grep kule te tumba nyap. ");
INSERT INTO ssd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Te yiŋe ndare. Ndare ta mbolŋge pasa kitek Kuate nu taŋgo ndoŋ o buk katna ta alonu mayok kaŋgat. Ye yiŋe ndare kutuwi le Kuate nu nane gudommba tuku une saukamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ye tane satiŋgamŋgit. Ye maŋ grep kule teŋen nye ndaki ma ma yiŋe Mam kulatkate ma mbolŋge ye grep kule kitek maŋ tane ndoŋ nyamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Taŋaka deŋpurmba nane mune ande ulnaig sulumba tiŋga Olif tabe mbol kambim saka kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kumbaŋge Yesus nu nane saniŋgina: Furir te mbolŋge tane ŋakmba kua ka ye kusreyamŋgaig. Kuyar pasa teŋenmba sakate. Kuateŋge sipsip kulat taŋgo balewa le sipsip pururumba sili-siliwamŋgaig ŋgate. ");
INSERT INTO ssd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ye kummba maŋ tiŋgi sulumba ye amboŋga Galilea ma tugu mbol ka le tane ŋgumneŋga prowamŋgaig ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Taŋakina le Petrus nu ndek sana: Nane ŋakmba kuru-kuruka kua ka ne kusrenuwaig ta yeŋge ndo ne kusrene nda ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","nu Petrus sana: Ye siŋka ne sanamŋgit. Furir te mbolŋge teg witi ndawa le ne ye tuku nyu yabukam keŋamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Taŋaka sana le Petrus nu ndek lafumba sakina: Kuga. Ne balenumba ye mata baleyam bafuwaig le ta mata ye siŋka ne tuku nyu yabuke nda ŋgina le nuŋe dubinaig mbal ŋakmba pasa ndui ta ndo sakinaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesus nane kumba ka ma ande nyunu Getsemani pronaig sulumba nu nuŋe dubinaig taŋgo saniŋgina: Tane teŋge minap. Ye ka siŋge Kuate yabaŋamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Taŋaka nu ndek Petrus le Sebedeus tuku kiŋo armba Yakobus Yohanus nane keŋ ta kilmba kina ka taŋge nu ŋgamuŋgal piti suŋgo kamusmba wamdus fagka minna. ");
INSERT INTO ssd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Taŋamba nu nane saniŋgina: Ye wamdus ŋayoŋga piti suŋgo ye toyate le kamuset. Tane teŋge ye ndoŋ mambilmba minap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Taŋamba saka nu dirdirka kumba ŋgurŋgurka ndek truk ka Kuate yabaŋmba sakina: O Mam, kumuŋ ndeta kule murko te ye mbol pitaimba te-siwa ŋget ta ne ye tuku nzali te dubi ndawa. Naŋe nzali ndo dubiwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Taŋamba nu luka ka nuŋe dubiwanu taŋgo kaŋgerkina ta nane kinymba minnaig le nu ndek Petrus sana: Ne ait fagnu te ye tuku ŋga idusmba mambilmba minam kuga e? ");
INSERT INTO ssd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Satan tuku tago tane mbol prowikat tukunu tane abo minmba yabaŋmba minap. Taŋgine ŋgamuŋgal Kuate yabaŋam tuku idusde ta ŋgarosumbi dubiwam tuku ta piti ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesus nu maŋ lato kumba ka yabaŋmba sakina: O Mam, kule murko te ye laipyam kumuŋ kuga ta ye nyamŋgit. Naŋe nzali ta ndo dubiwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Taŋamba nu maŋ luka prona ta nane ginyumŋge am piti patikinaig le kinymba minnaig le ");
INSERT INTO ssd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","nu nane kaŋgerka nu maŋ nane kusreka luka kumba ka pasa ndui ta ndo yabaŋna. ");
INSERT INTO ssd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yabaŋ deŋpurmba nu pro nuŋe dubiwanu taŋgo kusnaniŋgina: Tane mabtumba kinymba minamŋgaig? Ait buk patukate. Andeŋge ye Ndindo Katesek Taŋgo tumba une ŋak mbal tuku wai mbolŋge palmbim tuku bafute. ");
INSERT INTO ssd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ai si. Ye tuku kupet prote si. Tane tiŋgap le sine nane tugum si kab ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nu taŋamba pasata minna le taŋgo 12 ta tuku ande Yudas nu taŋgo gudommba kame bagi sibugi kilmba ŋak pronaig. Pris gabat mbal Israel mage naneŋge taŋamba kukulniŋginaig le pronaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yesus tuku kupet taŋgo nu nane kila palmbim tuku buk teŋenmba wam paguniŋgina: Ye ka ande mumuwi ndeta not. Taŋgo ta biye tiwap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kile nane promba Yudas nu pitik ndo Yesus tugum kumba Tum Taŋgo kaiye ŋga sakina sulumba nu mumuna le ");
INSERT INTO ssd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","nu ndek Yudas sana: Mata, ne wam idusmba te prowat ta pitik ka ŋgina. Taŋamba sakina le nane pro Yesus biymba biye denaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kile Yesus dubiwanu taŋgo ande nuŋe kame bagi gomba tumba pris suŋgo tuku piro taŋgo kilbanu pike welna. ");
INSERT INTO ssd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Taŋana le Yesus nu taŋgo wam kina ta sana: A ... naŋe kame bagi tumba nuŋe ma mbolŋge pale. Taŋgo nane kame bagimbi kame bude ta afuŋge nane kame bagimbi bale faramŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ye yiŋe Mam yabaŋi ta nu pitik ndo eŋel kuasmbi gudommba kukulniŋguwa le ye turyam prowamŋgaig ta ne idus ndate? ");
INSERT INTO ssd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ye taŋawi ta Kuate tuku kuyar pasa ye tuku sakina ta kumuŋge nda ŋga sana. ");
INSERT INTO ssd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kile Yesus nu maŋgur suŋgo ta saniŋgina: Ndaŋam saka ye kuayar taŋgo taŋaŋ tane bagi sibugi kilmba ŋak ye biye tiyam prode. Ye mara mindek kusem wande suŋgo sinamŋge taŋgo pino wam paguka minyok minen tambi tane ye biye tiyam kuga e? ");
INSERT INTO ssd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wam ŋakmba mayok kinig te tuan taŋgo kame nane Kuate tuku pasa kuyarnaig ta kumude ŋgina. Taŋakina le nuŋe dubinaig taŋgo ŋakmba nu kusremba sili-silimba kua kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nane Yesus biye tinaig mbal ta nu tumba pris gabat suŋgo Kaiafas tuku wande mbol kinaig. Wande ta mbolŋge kusem pasa bitekŋganu mbal Israel mage mage nane buk pro maŋgurkinaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus nu maskenŋge Yesus dubimba kina ka pris gabat suŋgo tuku fonde sinam kina ka wande mab taŋge ame wam Yesus mbolŋge kuwaig le kaŋgeram tuku nu kame mbal ndoŋ minyok minna. ");
INSERT INTO ssd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pris gabat mbal Israel gabat sugo pasa pilewanu mbal ŋakmba Yesus balewam tuku afuŋge yabri pasa te-mayokuwaig ŋga sotinaig le ");
INSERT INTO ssd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","nane gudommba tiŋga yabri pasa tumba Yesus mbaranu ŋginaig ta nu kumam tuku pasa ande mayok nda kina. Nane taŋamba pasa ndin sotinaig ma ma kile taŋgo armba tiŋga sakinaik: ");
INSERT INTO ssd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Taŋgo te teŋenmba sakina le sile iskeŋ. Kusem wande suŋgo ye sambriwi sulumba mara keŋmba mbolŋge maŋ palmbim kumuŋ ŋga sakina le sile iskeŋ ŋginaik. ");
INSERT INTO ssd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Taŋakinaik le pris gabat suŋgo nu tiŋga Yesus kusnana: Nane ne mbaranu ŋga sakade te ne ndaŋmba iduste. Ne nane tuku pasa lafuwe nda e ŋgina ta ");
INSERT INTO ssd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","nu miŋge tukulmba maninok minna le pris gabat nu maŋ kusnana: Ne Kristus? Ne Kuate tuku Kiŋo e? Kuate nu abo minit ne nu am mbolŋge lafuwa le sine isbe ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus nu pasa lafumba sakina: Ne sakate not. Ye ne sanamŋgit. Ye Ndindo Katesek Taŋgo Kuate Saŋgri Ŋayo nu tuku ndinamŋge minyok mini sulumba gau mbolŋge ndeki le tane ye kaŋgeryamŋgaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Taŋakina le pris gabat suŋgo nu pasa ta ismba palseŋna le nu ndek nuŋe tawi fetfetmba sakina: Kile mbulbe. Pasa ande sote nda. Nu Kuate tuku nyu ŋayo silite. Tane nu tuku pasa ŋayonu te ismba ");
INSERT INTO ssd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","tane ndaŋmba idusde ŋgina le nane sakinaig: Nu taŋgo ŋayonu. Nu kumwa ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Taŋamba nane afu tiŋga ka Yesus tumailnu ŋguspemba nu waimbi katmba sanaig: ");
INSERT INTO ssd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Imaŋge ne katnate? Ne Kuateŋge madinina taŋgo ndeta nyun ta le sine isbe ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petrus nu wande mab taŋge minyok minna le pino ande nu tugum promba sana: Ne mata Galileanu taŋgo Yesus ndoŋ minna tuku ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Taŋakina le nu nane ŋakmba am mbolŋge nu Yesus tuku nyu yabuka sakina: i ... Ne pasa sakate ta ye ŋginŋganket ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kile nu tiŋga kumba ka fonde malaŋga ta tugumŋge tiŋ minna le piro pino ande nu kaŋgermba nane nu tugumŋge minnaig mbal saniŋgina: Nu Nasaretnu taŋgo Yesus nu ndoŋ minna tuku ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petrus nu saŋgri tiŋga maŋ Yesus tuku nyu yabukina: Ye Kuate am mbolŋge saket. Ne taŋgo sakate ta ye siŋka nu gilai ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Taŋamba minmba taŋgo afu Petrus tugumŋge minnaig ta nane pro nu sanaig: Ne yabrikate. Ne nu tuku taŋgo ande. Ne mata Galileanu taŋgo tuku pasa ŋin tugu sine iseg ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","nu nuŋe miroŋ nuŋe ŋgaro taprana sulumba sakina: Taŋgo ta ye siŋka gilai ŋgina. Taŋakina le pitik ndo teg witina. ");
INSERT INTO ssd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Taŋana le Yesusŋge Petrus pasa sana ta nu idusna: Teg witi ndawa le ne ye tuku nyu yabukam keŋamŋgat ŋga sana. Nu pasa ta idusmba nu tiŋga mayok ka malmbi ŋayona. ");
INSERT INTO ssd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mafena le maratukuk tiŋga pris gabat mbal Israel mage mage nane ŋakmba maŋgurkinaig sulumba Yesus balewam tuku pasa saka ismba minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pasate deŋpurmba nane Yesus ndaleka tumba ka gabat suŋgo Pilatus tuku wai mbolŋge pilnaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yesus tuku kupet taŋgo Yudas nu Yesus balewam tuku pasa saŋgri pilenaig le ismba nu wamdus biye mbilmba silwa ndametiŋ soŋ keŋmba ta kilmba pro pris gabat mbal Israel mage mage saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Taŋgo te ye tane tuku wai mbolŋge pilen ta nu mbar kugatok. Ye siŋka mbaren ŋgina le nane nu sanaig: Taŋaig. Piti ta naŋe ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Taŋakinaig le kusem wande suŋgo sinam taŋge ndametiŋ bareŋmba nu mayok ka kina ka nuŋe ŋinfok muli panmba kuikŋga kumna. ");
INSERT INTO ssd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kile pris gabat mbal nane ndametiŋ ta taŋgermba kilmba sakinaig: Ndametiŋ te taŋgo kumwa ŋga patikigeŋ. Ta tuku kusem wande sinamŋge ndametiŋ minig te tur ulendi ndabe ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Taŋamba nane pasa saka kine inummba minnaig sulumba rawe mbal kumwaig le ŋgunu tuku kilke ande piyanaig. Kilke ta waim wakeikanu tuku taŋgo kame tuku kilke. ");
INSERT INTO ssd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ta tuku kilke ta kile nyunu ndare kutukina tuku kilke ŋgade. ");
INSERT INTO ssd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Wam ta mbolŋge tuan taŋgo Yeremia tuku pasa ande kumuŋgina. Pasa ta teŋenmba sakate. Nane nu kaŋgermba piyanu silwa ndametiŋ soŋ keŋmba kumumbi patikinaig ta ");
INSERT INTO ssd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nane silwa ndametiŋ ta kilmba waim wakeikanu mbal tuku kilke ande piyanaig. Suŋgo nu nane taŋamba kam tuku ye sayina ŋgate. ");
INSERT INTO ssd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesus nu Rom mbal tuku gabat ta tugumŋge tiŋgina le nu Yesus kusnana: Ne Zu mbal tuku gabat suŋgo e ŋgina le Yesus ndek nu sana: Ne sakate not ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Taŋakina le pris gabat mbal Israel mage mage nane pasa gudommba kilmba Yesus mbolŋge patika nu mbaranu ŋga saka minnaig le nu nane tuku pasa ande lafu ndana le ");
INSERT INTO ssd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatus nu kusnana: Ai te. Ne mbar gudommba kanu sakade ta ne nda isit e ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nane nu mbar gudommba kanu sakinaig ta Yesus nu pasa ta inum lafumba gabat taŋgo sa ndana le nu wam ta tuku pirerek purkina. ");
INSERT INTO ssd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yar mindek Pasowa tuku ait mbolŋge nane Zu mbal Pilatus tugum kumba muliŋ kilanu taŋgo ande paska tam tuku sawanu le nu paska niŋganu. ");
INSERT INTO ssd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ait ta mbolŋge taŋgo mbaranu ande nyunu Barabas nu muli wandekŋge minna. ");
INSERT INTO ssd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Taŋgo ŋakmba Yesus tuku saka minnaig le pris gabat mbal gubra kagli firka ake Yesus tumba nu tuku wai mbolŋge pilnaig ta Pilatus nu kila. Ta tuku nane pro nu tugumŋge maŋgurkinaig le nu Yesus kusrewam idusmba nane kusnaniŋgina: Ye Yesus nane Kristus ŋgade nu paska tiŋgi e ko taŋgo ŋayonu Barabas paska tiŋgi ŋga kusnaniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatus nu nuŋe minyo mbili maditaknu ta mbolŋge minyoka Yesus pilemba minna le piyo nuŋe nu taŋgo ande kukulna le nu tugum promba sana: Piyo naŋe nu teŋenmba sakat. Ne taŋgo tiŋreknu ta kusrewa. Ye nu tuku kiŋatit sulumba ye wamdus fulilka minet ŋga sakat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pris gabat mbal Israel mage mage nane taŋgo pino siseŋniŋmba wam pagukinaig le Barabas paska te-luka niŋmba Yesus balewam tuku Pilatus sanaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Taŋamba sanaig le gabat taŋgo nu maŋ kusnaniŋgina: Ye nale tuku ima paski le mayok kuwa ŋga idusde ŋgina le nane Barabas ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Taŋakinaig le Pilatus nu nane saniŋgina: Ye Barabas paski sulumba Yesus nane Kristus ŋgade te ye nu ndaŋi ŋga idusde ŋgina le nane ŋakmba lafumba sakinaig: Ail kazrai mbolŋge nil daŋŋguwaig ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Taŋakinaig le nu ndek sakina: Ndaŋam. Nu ame wam mbarna ŋgina le nane maŋ suŋgomba wikaraumba sakinaig: Ail kazrai mbolŋge nil daŋŋguwaig ŋga saka minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kile zigna suŋgo mayok kambim bafuna le Pilatus nu kaŋgermba nuŋe pasambi nane tuku wamdus kile-ibeŋkam kumuŋ kuga ta katesemba nu kule tumba pro maŋgur suŋgo ta nane am mbolŋge nuŋe wai minyaŋga sakina: Taŋgo te kumwa ta ye tuku mbar kuga. Mbar ta taŋgine ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","nane ŋakmba ndek sakinaig: Ta maye. Nu tuku ndare ta sine siŋgine kiŋo kame turmba pasokuwa ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nane taŋamba sakinaig le Pilatus nu Barabas paska tumba Zu mbal niŋgina sulumba kame mbal saniŋgina le nane Yesus tumba muli kareŋnumbi ŋgusnaig. Taŋanaig le Pilatus nu nane saniŋgina: Taŋgo te tumba ail kazrai mbolŋge palpe ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kame mbal Yesus tumba Pilatus tuku wande suŋgo ŋgirpem taŋge pilmba kame taŋgo ŋakmba wikinaig le pro maŋgurkinaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kile nane Yesus tuku tawi paska tawi gurgur mindepiye mayenu tumba nu kai tunaig sulumba ");
INSERT INTO ssd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","muli nzapo ŋak pirka gabat kaimba dido tumba nu tuku wai ndinam mbolŋge pilmba nu usre kupetmba pro dagol tidroŋga sakinaig: Ese. Ne Zu mbal tuku gabat suŋgo ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Taŋamba nane nu ŋguspemba dido ta yaimba gabatnu katanu. ");
INSERT INTO ssd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nane taŋamba usre kupetmba nzumil te-tumba deŋpurmba tawi ta maŋ paska nuŋe tawi siluk tumba ail kazrai mbolŋge palmbim tuku nu tumba kinaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kinaig ka ndinŋge Sirenenu taŋgo Simon te-silika nu Yesus tuku ail kazrai kurawa ŋga saŋgrimba sanaig le nu kurana. ");
INSERT INTO ssd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Taŋamba nane kumba ka ma nyunu Golgota pronaig. Nyu ta tugunu Taŋgo Gabat Murko. ");
INSERT INTO ssd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pro taŋge nane ndek marasin kaglinu ande ŋgaro rar mukuwam tuku grep kule tur mbilmba nyuwa ŋga tunaig ta nu fudiŋmba tagomba mbulna. ");
INSERT INTO ssd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kame mbal Yesus tumba ail kazrai mbolŋge nil daŋŋginaig sulumba nu tuku tawi kilam tuku usre ande kinaig sulumba ");
INSERT INTO ssd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ail kazrai tugum taŋge minyoka nu kulatka minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Gabat fumŋge nu balenaig tuku pasa gabat teŋenmba kuyarnaig: Taŋgo te nyunu Yesus. Nu Zu mbal tuku gabat suŋgo ŋga kuyarnaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nane kuayar taŋgo armba turmba kilmba ande nu tuku ndinamŋge ande ŋaiŋam kumamŋge ail kazrai mbolŋge nil daŋŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nane afu muŋgu lilika kine ilemba Yesus nzumil te-tumba nduku-ndukumba sanaig: ");
INSERT INTO ssd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Taŋgo nu Israel kusem wande suŋgo sambrimba mara keŋmba mbolŋge maŋ palmbim tuku sakina ta kile aniŋge. Ne naŋe miroŋ naŋe ŋgarosu tura. Ne Kuate tuku Kiŋo kande ail kazrai kusremba ibeŋ kaye ŋga samba minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pris gabat mbal nane kusem pasa bitekŋganu mbal Israel mage mage nane mata Yesus nunumba piŋgil mer te-tumba sakinaig: ");
INSERT INTO ssd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Nu taŋgo afu tuku muskil kile-tidiŋgina. Kile nu nuŋe muskil te-tiwam kumuŋ kuga. Nu Israel mbal tuku gabat suŋgo minmba ndeta kile ail kazrai ta kusremba ndekuwa le sine son ŋgube. ");
INSERT INTO ssd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ye Kuate tuku saŋgri tomba tiŋget ŋga sakina. Ye nu tuku Kiŋo ŋgina. Ariya. Kuate nu nzalinu kande nu tuku muskil te-tiwe tuwa ŋga saka minnaig le ");
INSERT INTO ssd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","kuayar taŋgo armba Yesus tugumŋge ail kazrai mbolŋge daŋŋginaig ta nale mata maŋau ndui tambi nu tumail pannaik. ");
INSERT INTO ssd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ki kanum 12 mbolŋge ma ŋakmba ma furir suŋgo promba kumba ka ka ki kanum 3 mbolŋge kugana. ");
INSERT INTO ssd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ki kanum 3 taŋaŋ Yesus nu wi kueŋka sakina: Eli, Eli, lama sabaktani ŋgina. (Pasa ta tugunu teŋenmba. Yiŋe Mbara, yiŋe Mbara, ndaŋam ne ye kusreyat). ");
INSERT INTO ssd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Taŋakina le nane afu taŋge minnaig ta ndek sakinaig: Taŋgo te nu Elia wikate ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","pitik ndo taŋgo ande pinderka kumba ka kulelu tumba grep kule mbolŋge tolna sulumba Yesus nyuwa ŋga didombi te-duŋga nu tuku miŋge mbolŋge pilna le ");
INSERT INTO ssd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","nane afuŋge ndek sakinaig: Yauk. Elia nu pro nu paska te-ibeŋamŋgat inde ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kile Yesus nu maŋ suŋgomba witina sulumba nu kumna. ");
INSERT INTO ssd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yesus nu kumna le kusem wande suŋgo sinamŋge tukul wande tukulanu tawi suŋgo ta mbolŋge fetka ibeŋŋge bitekŋgina. Mumni suŋgo prona le ndame sugo afu fetke likinaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ndame burok afu mindesiŋ ŋgukanu ta kakerke likinaig le Kuate tuku mbal gudommba o buk kume likinaig tuku maŋ aboŋga tiŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesus nu maŋ tiŋgina le nane ndame burok kusreke lika mayok kumba Yerusalem tumbraŋ suŋgo ta kine likinaig le taŋgo gudommba nane kaŋgerkinaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kame mbal tuku gabat nuŋe kuasmbi ndoŋ Yesus kulatka minnaig ta nane mumni kamusmba wam afu pronaig ta kaŋgerka nane kuru-kuruka sakinaig: i ... Taŋgo te nu siŋka Kuate tuku Kiŋo ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pino afu gudommba maskenŋge mambilmba nu kaŋgermba minnaig. Yesus nu buk Galilea kusremba Yerusalem kina ta nane nu dubimba sinzaŋnaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nane ŋgamukŋge ande Maria nu Magdalanu pino. Ande Maria kise nu Yakobus le Yosef nale tuku ina nakile. Ande Sebedeus tuku kiŋo ar ta tuku ina nakile. ");
INSERT INTO ssd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ki ait ta furiram maror taŋgo ande Arimateanu nyunu Yosef nu prona. Nu Yesus dubiwanu taŋgo ande minna. ");
INSERT INTO ssd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nu Pilatus tugum kumba Yesus tuku mindesiŋ tam tuku sana le Pilatus nu woka mindesiŋ nu tape ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Saniŋgina le Yosef nu mindesiŋ tumba tawi kaukauk purfeŋnumbi soŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","nu tumba ka nuŋe ndame burok ande kitek buk sarka wakeina tuku ta sinamŋge pilna. Pilna sulumba ndame suŋgo ande barimba pro burok miŋge ta tukulmba nu kina. ");
INSERT INTO ssd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nu kina le Maria Magdalanu nale Maria kise ndoŋ nale ndame burok tumailam taŋge minyok minnaik. ");
INSERT INTO ssd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yesus nu kumna le mafena le pris gabat mbal Farisi mbal ndoŋ kumba ka Pilatus tugum promba maŋgurka sakinaig: ");
INSERT INTO ssd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Suŋgo, yabri taŋgo ta nu minna ait mbolŋge pasa ande sakina ta sine kile maŋ iduseg. Nu teŋenmba sakina: Ye kumi sulumba mara armba kusreka keŋnu mbolŋge maŋ tiŋgamŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ta tuku ne naŋe kame mbal kukulniŋga le nane kumba ka ki ait keŋmba mbolŋge nu tuku kumu kulatkuwaig. Kuga ta nuŋe dubinaig taŋgo nane nu tuku mindesiŋ kuayar tumba ka yubeŋga nu buk tiŋgat ŋga taŋgo pino saniŋguwaig le nuŋe yabri ambokok ta suŋgo ŋayowikat ŋga sanaig. ");
INSERT INTO ssd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Taŋaka sanaig le Pilatus nu ndek nane saniŋgina: Tane kame mbal afu kilmba ka nu tuku kumu ta kulat mayewap ŋga saniŋgina le ");
INSERT INTO ssd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","nane kumba ka ndame ta mbolŋge katesewam tuku wasik pilmba kame mbal taŋge patikinaig. ");
INSERT INTO ssd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Naŋgine kusem ta kugana le piro tugu palmbinu ait mbolŋge maratukuk tiŋga Maria Magdalanu nale Maria ande kise ndoŋ nale tiŋga ndame burok mindesiŋ pilnaig ta kaŋgeram kinaik. Kumba ka ta pronaik le ");
INSERT INTO ssd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","mumni suŋgo prona le Suŋgo tuku eŋel ande samba mbolŋge ndeka ndame suŋgokanu burok miŋge tukulnaig ta barina le kasom kina le ndame ta mbolŋge minyok minna. ");
INSERT INTO ssd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Eŋel ta tuku tumail pasi uge liŋnu ndo teliŋ tuku bulu taŋaŋ. Nu tuku tawi ta kauknu ndo. ");
INSERT INTO ssd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kame mbal ta nane nu kaŋgermba kuru-kuruka ŋgarosu piririmba ŋgurŋgurka ndeka taŋgo kumanu taŋaŋ minnaig. ");
INSERT INTO ssd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Taŋamba minnaig le eŋel pino ar ta sanikina: Tale kuru kuru ndakap. Yesus nane nu tumba ail kazrai mbolŋge nil daŋŋginaig ta tale nu sotade ta ye kila. ");
INSERT INTO ssd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nu teŋge mine ndakate. Nu buk sakina taŋamba nu tiŋgat. Ai te. Nu pilnaig tuku ma mbol te kuga. ");
INSERT INTO ssd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tale pitik luka kumba ka nuŋe dubiwanu taŋgo teŋenmba saniŋgap: Yesus nu kumna ta maŋ tiŋgat. Nu amboŋga Galilea ma tugu mbol kuwa le tane ka taŋge kaŋgeramŋgaig ŋga saniŋgap. Ye pasa ta tale satikam prowit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nu taŋakina le nale kuru-kuruka gare ŋak pitik ndo ndame burok ta kusremba nuŋe dubiwanu mbal saniŋgam tuku pinderkinaik. ");
INSERT INTO ssd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nale pinderka kinaik le Yesus pro ndinŋge nale kile-siglika kaiyenikina le nale ndek dagol tidroŋga nu tuku kupe biymba nu tuku nyu te-duŋginaik. ");
INSERT INTO ssd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Taŋanaik le nu nale sanikina: Tale kuru kuru ndakap. Tale kumba yiŋe tira kame saniŋgap le Galilea ma tugu kuwaig. Taŋge nane ye kaŋgeryamŋgaig ŋga saniŋgap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pino ar ta kumba minnaik le kame mbal Yesus tuku kumu kulatkinaig ta afuŋge kumba ka Yerusalemŋge wam ŋakmba mayok ke likinaig ta pris gabat mbal wam kubeu niŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kubeu niŋginaig le pris gabat kame Israel mage mage ndoŋ maŋgurkinaig sulumba wam ta tuku saka ismba deŋpurmba ndametiŋ afu kilmba kame mbal ta niŋmba saniŋginaig: ");
INSERT INTO ssd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tane taŋgo pino teŋenmba saniŋgap. Sine furir kinymba gilaiŋgig le nuŋe dubiwanu taŋgo afuŋge pro nu tuku mindesiŋ kuayar tumba kaig ŋga saniŋgap. ");
INSERT INTO ssd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gabat suŋgo Pilatus nu wam te iswa ta sine ka nu tugum kumba pasa kumumbi te-tibe le tane pa kaŋgere nda ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Taŋakinaig le kame mbal ta ndametiŋ yaika ka wam pagukinaig pasa ta kumunaig. Wam kube ta Zu mbal ŋgamukŋge suŋgoka kumuŋgina le kile saka minig. ");
INSERT INTO ssd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nuŋe dubiwanu taŋgo 11 nane Galilea ma tugu mbol kinaig ka taŋge Yesus nu o buk nane tabe ande saniŋgina ta nane ta poŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nane tabe ta mbolŋge Yesus kaŋgermba nu tuku nyu te-duŋginaig ta nane afu taŋgo kise ŋga wamdus terokinaig. ");
INSERT INTO ssd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kile Yesus pro nane saniŋgina: Saŋgri ŋakmba kilke mbolŋge samba mbolŋge Kuate nu ye tuku wai mbolŋge pilna. ");
INSERT INTO ssd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ta tuku tane kape sulumba kilke tugu ŋakmba mbolŋge taŋgo pino ŋakmba ye dubiyam tuku tumniŋgap. Taŋawap sulumba nane Mam tuku nyu mbolŋge Nindo nuŋe tuku nyu mbolŋge Tukul Guwa tuku nyu mbolŋge kule pisne niŋgap sulumba ye pasa afu tane dubikam tuku saka tumtiŋgen ta ŋakmba nane tumniŋgap. ");
INSERT INTO ssd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tane taŋawap le ye tane ndoŋ minmba mini le ma ma kilke te kugawam tuku ait prowamŋgat ŋga saniŋgina. Son. ");
INSERT INTO ssd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kuate tuku Kiŋo Yesus Kristus tuku pasa mayenu ta ");
INSERT INTO ssd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","tuan taŋgo Aisaia nu teŋenmba kuyarna le minit. Ne isa. Ye taŋgo ande kukuli le nu amboŋga promba ne tuku ndin wakeiyamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ma baknu mbolŋge wi ande kueŋka teŋenmba sakate. Suŋgo tuku ndin wakeimba kuanekap. Nu likam tuku ndin te-tiwap ŋgate. ");
INSERT INTO ssd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohanus kule pisne taŋgo nu pasa ta kumumba ma baknu mbolŋge minmba pasa kuklimba taŋgo nane ŋgamuŋgal biye mbilmba maŋau ŋaigonu kusreka kule pisne tuwaig le Kuate nu nane tuku une sauka gilaiŋgamŋgat ŋga saka minna. ");
INSERT INTO ssd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nu taŋamba minna le Yerusalem mbal Yudea tumbraŋ yimyam nane ŋakmba nu tugum prowe likinaig. Nane naŋgine une maŋau kile-mayokke likinaig le Yohanus nu ndek Yordan kule mbolŋge nane kule pisneniŋmba minna. ");
INSERT INTO ssd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanus nu kamel ŋguenu ŋak tawi silika let tiŋmba nu kasbur wak alonu ŋguimzaŋ kulenu kilmba nyumba taŋamba minna sulumba ");
INSERT INTO ssd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","pasa kuklimba saniŋgina: Ande nu ye ŋgumnemŋge prowamŋgat ta nu ye tuku saŋgri lite. Ye taŋgo mayenu kuga. Ye nu tugumŋge loka nu tuku kupe ŋgaro tuku muli kukliwam tuku wam ŋai ta mata ye nu mbolŋge kam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ye tane kulembi kule pisnetiŋget. Nu tane Tukul Guwambi tane tuku ŋgamuŋgal kule pisne taŋaŋ tiŋgamŋgat ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ait ta mbolŋge Yesus nu Galilea ma Nasaretŋge Yohanus tugum prona le Yohanusŋge nu Yordan kule mbolŋge kule pisnena. ");
INSERT INTO ssd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kule pisnena le nu tabek kina le pitik ndo samba talkina le Tukul Guwa gami taŋaŋ ndeka Yesus mbolŋge minna le kaŋgerna. ");
INSERT INTO ssd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Taŋana le samba mbolŋge pasa ande promba teŋenmba sakina: Ne yiŋe Kiŋo. Ye ne tuku kume purmba ne tuku gare suŋgo tet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nu kule pisne tina le kile ndo Tukul Guwa Yesus nu ma baknu mbol kuwa ŋga kukulmba sana le nu ndek kina. ");
INSERT INTO ssd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma ta mbolŋge agaŋmor ŋguikok ndo minnaig. Nu kumba ka mara 40 taŋge minna le Satan nu pro ndek Yesus tago-tagona. Taŋawe deŋpurna le Kuate tuku eŋel ndeka Yesus sinzaŋnaig. ");
INSERT INTO ssd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nane Yohanus muliŋtumba wandekŋge pilnaig le Yesus nu pro Galileaŋge Kuate tuku pasa mayenu kuklimba sakina: ");
INSERT INTO ssd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kile ait kumuŋgate le Kuate nu nuŋe gageu kulatkam tuku ait buk patukate. Tane ŋgamuŋgal biye mbilmba maŋau ŋaigonu kusreka pasa mayenu ismba son ŋgap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kile Yesus nu Galilea kule kualiŋ make dubimba kumbaŋge nale aba nakile Simon le Andreus ndoŋ kumaŋ bukŋga minnaik le kaŋgerkina. Nale tuku piro ta kualegaŋ kilnaik tuku. ");
INSERT INTO ssd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus nu nale kaŋgerka ndek sanikina: Tale ye dubiyap le yeŋge tale tumtiki le taŋamba taŋgo kilamŋgaik ŋga sanikina. ");
INSERT INTO ssd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sanikina le nale pitik ndo tiŋga kumaŋ kusreka nu dubimba kinaik. ");
INSERT INTO ssd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesus nu maŋ fudiŋmba kumba ka Sebedeus tuku kiŋo ar Yakobus nale maib nuŋe Yohanus ndoŋ kaŋgerkina. Nale nakile waŋ mbolŋge minyoka kumaŋ zailŋga minnaik le ");
INSERT INTO ssd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","nu kaŋgerka nale wikina le nale mam nakile Sebedeus nuŋe piro taŋgo ndoŋ waŋ mbol taŋge kusreka nu dubinaik. ");
INSERT INTO ssd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nane kinaig ka Kaperneum tumbraŋ pronaig. Pro kusem ait mbolŋge Yesus nu kusem wandek sinam kumba taŋge nane pasa tumniŋmba minna. ");
INSERT INTO ssd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nu kusem pasa bitekŋganu mbalŋge pasa tumniŋgig taŋamba tum ndaniŋgina. Nu pasa miro taŋgo taŋaŋ pasa saniŋgina le nane ŋakmba pirerek purkinaig. ");
INSERT INTO ssd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Naŋgine kusem wandek sinam taŋge taŋgo ande bukla ŋak minna. ");
INSERT INTO ssd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nu ndek witimba sakina: Yesus Nasaretnu, ne sine ndoŋ wamdus tuma kuga. Ne sine bale faram tuku prote e? Ne Kuate tuku Kiŋo ta ye kila ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","nu ndek bukla ta sawe lika sana: Ne maninka. Taŋgo ta kusremba mayok ka kaye ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Taŋakina le bukla taŋgo ta kusrewam bafumba witimba ŋgarosu zulbarekŋga nu mayok ka nu kusremba kina le ");
INSERT INTO ssd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","nane ŋakmba ndek pirerek purka muŋgu kusnaŋginaig: Ame wam teŋen. Pasa te kitek. Nu saŋgri ŋak taŋaŋ bukla mata saniŋgit le nane nu tuku pasa isig ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Taŋamba Yesus tuku nyu Galilea ma ŋakmba kumuŋge likina. ");
INSERT INTO ssd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kile Yesus nane ndek kusem wande ta kusremba Yakobus le Yohanus kilmba ka Simon le Andreus tuku wande mbol kinaig ka taŋge ");
INSERT INTO ssd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon magma nuŋe nu guaze ŋak ŋgaro pa tiŋgina le nu kinye ŋak minna le nane ndek Yesus kila sanaig. ");
INSERT INTO ssd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Taŋakinaig le nu pro pino ta wainu biymba te-tina le ŋgaro pa tiŋgina ta mukumba nu mayekina. Taŋamba nu tiŋga nane tuku paguna. ");
INSERT INTO ssd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ki butuŋgam bafuna le nane afuŋge naŋgine mbal guaze tugu yimyam ŋak afu bukla ŋak ta kilmba mindeka Yesus tugum prowe likinaig. ");
INSERT INTO ssd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tumbraŋ ta tuku mbal ŋakmba wande mab taŋge maŋgurkinaig le ");
INSERT INTO ssd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesus nu gudommba guaze tugu kise kise ŋak kile-tidiŋga bukla ŋaigonu ŋak ta pitaike likina. Bukla kame nane Yesus kila tukunu nu nane tuku miŋge pipniŋgina le nu tuku sa ndakinaig. ");
INSERT INTO ssd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mafemba minna le Yesus nu aboŋga tiŋga mayok kumba ka ma yamokŋge Kuate ndoŋ pasata minna. ");
INSERT INTO ssd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pasata minna le Simon nane nu sotinaig. ");
INSERT INTO ssd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Sota kumba ka taŋge nu te-silika sanaig: Nane ŋakmba ne sota kusnaŋgade ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","nu ndek nane saniŋgina: Sine tiŋga tumbraŋ patuk patuk ta kab. Ye taŋge mata pasa kukliwamŋgit. Kuate nu ta tuku ye kukulyina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Taŋamba nu Galilea tumbraŋ ŋakmba mbolŋge lika naŋgine kusem wande mbolŋge pasa kukliwe lika bukla gudommba pitaike likina. ");
INSERT INTO ssd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Taŋgo ande ŋgirŋger ŋak Yesus tugum promba dagol tidroŋga nu sarsarmba sana: O Suŋgo, ne kumuŋ. Ne nzalinuwa ndeta ye tuku ŋgarosu wakeiwa ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","nu taŋgo ta kaŋgermba sinamba ndek wai kuitka kiremba sana: Au. Ye ne wakeinet. Ne mayeka ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Taŋakina le ŋgirŋger gagulka ŋgarosu mayekina le ");
INSERT INTO ssd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesus nu kukulmba pasa saŋgrinu sana: ");
INSERT INTO ssd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ye ne mbolŋge maŋau kit te afu sa ndaniŋga. Ne mayekat tukunu ne kumba ka Moses tuku tukul dubimba atrau agaŋ pris tawe le atraukuwa le ŋakmba ne mayekat ta katesewaig ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Taŋamba peuna ta nu kina ka wam ta saka saka likina. Ta tuku Yesus nu kile tumbraŋ sugo afu ŋgamukŋge ake likam kumuŋ kuga. Nu ma yamok ta mbolŋge ndo minanu le nane tumbraŋ tumbraŋ ŋakmba nu tugum prowe likanu. ");
INSERT INTO ssd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mara afu kinaig le Yesus nu maŋ luka Kaperneum promba wande ande mbolŋge minna le nane pasa ismba ");
INSERT INTO ssd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","nane gudommba pro wande ta sinamŋge maŋgurka wande mab ta mata kumuŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kile nane afuŋge taŋgo ŋgarosu milmailkanu mindemba nane tuku bailkamba nu sukuŋga pronaig ta ");
INSERT INTO ssd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","taŋgo gudommbaŋge ma tukulnaig tukunu Yesus tugum prowam kumuŋ kuga le nane ndek wande poŋga Yesus gabat fumŋge wande fu tetka guaze taŋgo nzaŋnzaŋ ŋak ta muli panmba pilnaig le ndekina. ");
INSERT INTO ssd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Taŋana le Yesus nu nane nu tuku saŋgri tomba tiŋginaig ta katesemba nu ndek taŋgo ŋgarosu milmailkanu ta sana: Kiŋo, ye ne tuku mbar ŋakmba sauka gilaiŋget ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Taŋaka sana le wandek sinam taŋge kusem pasa bitekŋganu mbal afu minnaig ta nane naŋgine wamdusmbi sakinaig: ");
INSERT INTO ssd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ndaŋam saka taŋgo te taŋamba sakate. Nu Kuate le taŋgo tuku mbar saukate e? Kuateŋge ndo mbar saukam kumuŋ ŋga idusmba minnaig le ");
INSERT INTO ssd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","nu pitik nane tuku wamdus kamusmba ndek saniŋgina: Ndaŋam saka tane wamdus te-pilemba minig. ");
INSERT INTO ssd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ye tane kusnatiŋgamŋgit. Ame pasa ye taŋgo ŋgarosu milmailkanu te sanu tuku wam bada? Ye ne tuku mbar sauka gilaiŋget ko tiŋga naŋe nzaŋnzaŋ kuramba lika kaye ŋget. ");
INSERT INTO ssd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ye Ndindo Katesek Taŋgo kilke te mbolŋge mbar saukam tuku ye saŋgri ŋak. Tane wam ta kila palmbim tuku ye kile pasa wam bada te sakamŋgit ŋgina. Taŋaka nu taŋgo ŋgarosu milmailkanu ta sana: ");
INSERT INTO ssd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ye ne sanet. Tiŋga nzaŋnzaŋ kuramba naŋe tumbraŋ kaye ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Taŋakina le nu nane ŋakmba am mbolŋge pitik ndo tiŋga nuŋe nzaŋnzaŋ kuramba mayok ka kina le nane wam ta kaŋgermba pirerek purka wai makemba Kuate tuku nyu te-duŋga sakinaig: i ... Sine wam kitek teŋen kaŋger ndaweg ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus nu mayok kumba ka maŋ kule kualiŋ piyal taŋge minna le nane gudommba pro nu te-ŋgamunaig le nu nane pasa tumniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pasa tumniŋge deŋpurmba nu tiŋga kumba ka takis kilanu wande mbolŋge Alfeus tuku kiŋo Levi piroka minna le kaŋgermba sana: Ne ilmba ye dubiya ŋgina le nu ndek tiŋga nu dubimba kina. ");
INSERT INTO ssd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kile Yesus nuŋe dubiwanu mbal ndoŋ Levi tuku wande mbol kinaig le takis kilanu mbal nane afu une ŋak nane gudommba nu dubimba kinaig. Nane isukusmba minnaig le nu dubinaig mbal afu mata nu ndoŋ isukusnaig. ");
INSERT INTO ssd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Taŋanaig le kusem pasa bitekŋganu mbal Farisi afu nane Yesus mbal ŋaigonu ta ndoŋ isukusmba minna le kaŋgermba ndek nu dubiwanu kuasmbi saniŋginaig: Ndaŋam saka nu takis kilanu mbal wam ŋaigonu kade mbal ndoŋ isukusit ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","nu pasa ta ismba saniŋgina: Guaze kugatok mbal nane dokta tugum kine ndakade. Guaze ŋak mbal ndo nu tugum kinig. Afu sine magenu ŋgade ta ye nane wika wakeikam pro ndawen. Ye une ŋak mbal wika wakeikam tuku prowen ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mara ande Yohanus kule pisne dubiwanu mbal Farisi mbal nane Kuate tuku ŋga nyamagaŋ pinka minnaig le nane afu pro Yesus kusnanaig: Yohanus dubiwanu mbal Farisi dubikanu mbal ait afu nyamagaŋ pinkade. Ndaŋam naŋe dubinade mbal maŋau ta ke ndakade ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","nu lafumba saniŋgina: Taŋgo ande nu pino tam tuku pagumba nye mbolŋge nu nuŋe mbal ndoŋ minit tukunu nane nyamagaŋ pin ndakade. ");
INSERT INTO ssd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ait ande prowa le afuŋge pro taŋgo ta nane ŋgamukŋge tuwaig le nane pitinu nyamagaŋ pinkamŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ande nu tawi urfunu burokuwa le kumiŋ abonu tumba burok ta tukulmba zail ndaŋgate. Nu taŋawa ta kumiŋ kitek taŋge urfunu didikuwa le lato fetkamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ande nu grep kule kitek tumba agaŋmor ŋgaro urfunu sinamŋge tol ndate. Nu taŋawa ta grep kule fulilka agaŋmor ŋgaro urfunu fetka grep kule kutuke suluwamŋgat. Grep kule agaŋmor ŋgaro tur ŋgisikamŋgat. Nane grep kule kitek tumba agaŋmor ŋgaro kitek sinamŋge tolde ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kusem ande mbolŋge Yesus nane wit piro ande sinam sinam lika nuŋe dubiwanu mbal wit alonu supika nyam nyam kinaig le ");
INSERT INTO ssd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisi taŋgo afuŋge nane kaŋgerka Yesus sanaig: Ai si. Ndaŋam saka nane sine tuku tukul lukamba kusem ait mbolŋge nyamagaŋ kilig ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","nu lafumba saniŋgina: David nuŋe mbal ndoŋ nane guba ŋaigoniŋgina le wam pile paskinaig sulumba nu wam ande kina ta tane kuyar ta burkade tae. ");
INSERT INTO ssd_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar nu pris suŋgo minna le David nu Kuate tuku wandek kina sulumba tukul bret Kuate am mbolŋge patikinaig ta afu kilmba nyumba nuŋe mbal mata niŋgina le nyinaig. Bret ta taŋgo nane nye ndakade tuku. Prisŋge ndo nyade tuku ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","sakina: Kuate nu kusem ait taŋgoŋge kulatkuwa ŋga pilna. Kusem aitŋge taŋgo kulatkuwa ŋga taŋgo te-mayok ndana. ");
INSERT INTO ssd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ye Ndindo Katesek Taŋgo ye kusem ait tuku gabat mata minet ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesus nu maŋ kusem wandek sinam kina. Sinam taŋge taŋgo ande wai kummba pagriŋganu ŋak minna. ");
INSERT INTO ssd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Farisi nane nu kusem ait mbolŋge taŋgo wakeiwa le pasa mbolŋge palmbim tuku nu kulatka minnaig le ");
INSERT INTO ssd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","nu taŋgo wainu kummba pagriŋganu ŋak ta sana: Ne ilmba ŋgamu teŋge tiŋga ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Taŋakina sulumba Yesus ndek nane saniŋgina: Sine siŋgine tukul dubika kusem ait mbolŋge sine afu mbolŋge wam mayebe ko ŋayobe? Ande wakeibe ko balebe ŋga kusnaniŋgina le nane maninok minnaig. ");
INSERT INTO ssd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Taŋanaig le Yesus nu gubra tumba mbilmbilka nane kaŋgerkina ta nane ŋgamuŋgal kareŋganu ŋak tukunu nu ŋgamuŋgal pitina sulumba taŋgo ta sana: Ne wai kuitka ŋgina le nu wai kuitka wai mayekina. ");
INSERT INTO ssd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Taŋana le Farisi mbal pastiŋga mayok ka Herodus dubinaig mbal ndoŋ maŋgurkinaig sulumba Yesus balewam tuku pasa katmba ndin sotinaig. ");
INSERT INTO ssd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesus nuŋe dubiwanu mbal ndoŋ ma ta kusremba Galilea kule kualiŋ tugum kinaig le Galilea mbal gudommba nu dubimba kinaig. ");
INSERT INTO ssd_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yudea ma tugu Yerusalem tumbraŋ suŋgo Idumia ma Yordan kule make sim Tirus le Sidon patukŋge tumbraŋ foŋfoŋ ta tuku mbal gudommba Yesus wam ke likina ta ismba nu tugum prowe likinaig. ");
INSERT INTO ssd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Nane prowe likinaig mbal Yesus nu guaze taŋgo wakeike likina ta kila tukunu guaze mbal promba nu kirewam tuku muŋgu signaŋginaig le Yesus nu ndek nuŋe dubiwanu mbal saniŋgina: Ye tuku waŋ ande madiwap. Nane gudommba muŋgu signa-signaŋga ye pipkade ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mara mindek bukla ŋaigonu nane Yesus kaŋgermba ka nu tugumŋge bariŋge lika wikaraumba sakanu: Ne Kuate tuku Kiŋo ŋganu le ");
INSERT INTO ssd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","nu ndek nane miŋge pipniŋmba nu tuku nyu te-mayok ndawaig ŋga saniŋmba minanu. ");
INSERT INTO ssd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus nu tabe ande poŋgina sulumba nuŋe nzalimbi taŋgo wike likina le nane ndek nu tugum pronaig. ");
INSERT INTO ssd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Taŋanaig le nu nane ŋgamukŋge taŋgo 12 nu ndoŋ minam tuku madiniŋgina. Nu nane kukulniŋguwa le nuŋe pasa kuklimba ");
INSERT INTO ssd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","bukla pitaikam tuku saŋgri tam tuku ŋga nu nane madiniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nane tuku nyu kat naŋgine ta teŋenmba. Ande Simon Yesusŋge nyu kitek Petrus ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ande Yakobus nu Sebedeus tuku kiŋo nuŋe. Ande Yohanus nu Yakobus tuku maib nuŋe. (Nale ar ta Yesus nyu ande Boanesis ŋgina. Nyu ta tugunu Kuaila). ");
INSERT INTO ssd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nane afu Andreus, Filipus, Bartolomeus, Mateus, Tomas. Ande Yakobus nu Alfeus tuku kiŋo nuŋe. Ande Tadeus. Ande Simon mape nyu nuŋe Selot. ");
INSERT INTO ssd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ande Yudas Iskariotnu. Ŋgumneŋga nu Yesus tuku kupet taŋgo mayok kina. ");
INSERT INTO ssd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kile Yesus nu tiŋga ka wande mbol kina ta nane gudommba maŋ pro maŋgurkinaig le Yesus nane isukusam mata kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesus tuku ndare tuma wam ta ismba nu itilu ŋginŋgankate ŋga idusmba nane nu tam kinaig. ");
INSERT INTO ssd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kile kusem pasa bitekŋganu mbal afu Yerusalemŋge ndekinaig ta ndek sakinaig: A ... bukla Belsebulŋge nu tate. Bukla kame tuku gabat Belsebulŋge saŋgri ta tuwit le nu bukla pitaike likate ŋga sakinaig. ");
INSERT INTO ssd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Taŋakinaig le Yesus nu ndek te yalpe ŋga yaba pasa afu nane saniŋgina sulumba sakina: Satan nu nuŋe mbal pitaikam kumuŋ e? ");
INSERT INTO ssd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gabat suŋgo ande tuku kuasmbi nane pur yimyamka naŋgine naŋgine kame buwaig ta nane saŋgri ŋak minam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wande ande tuku mbal nane pur yimyamka naŋgine naŋgine kame buwaig ta nane mata saŋgri ŋak minam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Taŋamba ndo Satan nu nuŋe mbal pitaika pur yimyamka nane ndoŋ kame bute kande nu mata saŋgri ŋak mine ndaka ŋgisikam bafute kande. ");
INSERT INTO ssd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Taŋgo saŋgrinu ande nuŋe wande kulatkate ta ande pro nu tuku agaŋ ndende kuayaram kumuŋ kuga. Nu taŋgo saŋgrinu te-ibeŋmba nu ndalekuwa sulumba ndo agaŋ ndende kilam kumuŋ. ");
INSERT INTO ssd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ye siŋka satiŋgamŋgit. Taŋgo tuku une maŋau tumail pan maŋau ta ŋakmba Kuate nu sauka gilaiŋgate tuku. ");
INSERT INTO ssd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ande nu Tukul Guwa tumail pante ta Kuate nu mbar ta sauka gilaiŋge nda. Nu mbolŋge minmba minamŋgat ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nane Yesus nu bukla ŋak ŋginaig tukunu nu taŋamba nane riroŋ pasa niŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kile Yesus ina nuŋe mambo kat nuŋe ndoŋ nane pro wande tugum taŋge tiŋga pasa pilnaig le ");
INSERT INTO ssd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","nane maŋgur Yesus te-ŋgamumba minnaig ta nane nu sanaig: Ina naŋe mambo kat naŋe kulim kat naŋe nane pro kilimŋge tiŋga ne kusnaŋgade ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Taŋakinaig le Yesus nu nane saniŋgina: Tane yiŋe ina yiŋe maib kame tuku sayade e ŋgina sulumba ");
INSERT INTO ssd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","nu mbilka nane nu tugumŋge minyokinaig mbal ta saniŋmba sakina: Mbal te yiŋe ina yiŋe mambo kame taŋaŋ minig. ");
INSERT INTO ssd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ima nu Kuate tuku nzali dubite ta nu yiŋe maib yiŋe kulim yiŋe ina taŋaŋ minit ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mara ande kule kualiŋ piyal taŋge Yesus nu maŋ nane pasa tumniŋmba minna le maŋgur suŋgo nu te-ŋgamumba maŋgurkinaig. Taŋanaig le nu waŋ ande kule mbolŋge faitka minna ta poŋga minyokina le nane maŋgur ŋak ta piyalŋge minnaig. ");
INSERT INTO ssd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Taŋamba Yesus nu yaba pasambi wam gudommba nane tumniŋmba pasa ande teŋenmba saniŋgina: ");
INSERT INTO ssd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tane isap. Taŋgo ande nu agaŋ tumunu bareŋniŋgam piro mbol kina. ");
INSERT INTO ssd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kina ka bareŋniŋgina le tiŋnu afu ndinŋge ndeke likinaig ta sar umaŋŋge pro nye sulunaig. ");
INSERT INTO ssd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tiŋnu afu kilke ndame ŋak ma mbolŋge ndeke likinaig ta kilke fudiŋndo tukunu pitik ndo maŋge pronaig. ");
INSERT INTO ssd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pronaig ta ki suŋgo promba pasokina le sumbailnu sinam nzi kine ndakinaig tukunu kareŋga kume sulunaig. ");
INSERT INTO ssd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tiŋnu afu ma aŋga ŋaigonu sinamŋge ndeke likinaig ta aŋgaŋge tiŋga soŋginaig le rure-rureka pro mage ndanaig. ");
INSERT INTO ssd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tiŋnu afu kilke mayenu mbolŋge ndeke likinaig ta ndo alo magenaig. Maŋge pro magemba kumba ka tugunu mindek mbolŋge afu 30 afu 60 afu 100 taŋamba taŋamba alonaig. ");
INSERT INTO ssd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tane kilba ŋak ndeta pasa te isap ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nane ŋakmba sili-silinaig le Yesus nuŋe ndo minna le nuŋe dubiwanu taŋgo afu nu tugumŋge minnaig ta nane yaba pasa kame ta tuku kusnanaig le ");
INSERT INTO ssd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","nu ndek nane saniŋgina: Kuate nu nuŋe gageu kulatkate wam kuirok minit ta tane kila palmbim tuku ye tane maditiŋgen. Nane afu kasomŋge minig ta nane yaba pasa ndo isig. ");
INSERT INTO ssd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nane wam afu kaŋgerkade ta alonu kaŋger tiwe nda. Nane pasa isig ta tugunu katesewe nda. Nane katesemba ŋgamuŋgal biye mbilwaig le Kuate nu nane tuku une sauka gilaiŋge niŋgikat ŋga ye yaba pasambi ndo saniŋgit ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kile nu nane saniŋgina: Yaba pasa satiŋgit ta tane katese ndade ta ye ndaŋmba maŋ yaba pasa afumbi satiŋgi le katesewamŋgaig? ");
INSERT INTO ssd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Agaŋ tumunu taŋgo bareŋniŋgina ta Kuate tuku pasa. ");
INSERT INTO ssd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tiŋnu ndinŋge ndekinaig ŋga sakit ta mbal afu taŋaŋ. Nane Kuate tuku pasa isig le Satan nu pitik ndo pro nane tuku ŋgamuŋgal sinamŋge pasa ta yaika tumba balete. ");
INSERT INTO ssd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tiŋnu afu kilke ndame ŋak mbolŋge ndekinaig ŋgit ta mbal afu taŋaŋ. Nane Kuate tuku pasa isig sulumba nzali suŋgo ŋak pitik ndo tade ta ");
INSERT INTO ssd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","sumbailnu kugatok taŋaŋ ait fagnu ndo dubide. Nane pasa ta dubide ta afuŋge piti serniŋgig le nane pitik ndo kusrede. ");
INSERT INTO ssd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tiŋnu afu ma aŋga ŋaigonu sinamŋge ndekinaig ŋgit ta mbal afu taŋaŋ. Nane Kuate tuku pasa isig ta ");
INSERT INTO ssd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kilke te tuku piti, agaŋ ndende kilam tuku nzali, nzali afu wamdus ta ŋak minig le pasa isig ta balete le alo ndate. ");
INSERT INTO ssd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tiŋnu afu kilke mayenu mbolŋge ndekinaig ŋgit ta mbal afu taŋaŋ. Nane Kuate tuku pasa ismba tumba dubimba afu alo 30 afu 60 afu 100 taŋamba taŋamba alo kile-mayokkade ŋga saniŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus nu maŋ saniŋgina: Taŋgo lam bulumba tumba nza ko mbain kumnemŋge palmbim tuku idus ndate. Nu tumba kilimŋge taikate. ");
INSERT INTO ssd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Taŋamba ndo wam afu taŋgo am mbolŋge kuirok minig ta ŋakmba kilimok mayok kaŋgaig. ");
INSERT INTO ssd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tane kilba ŋak ndeta pasa ta isap ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Taŋamba nu maŋ lato saniŋgina: Tane pasa isig te ise mayewap. Tane nane afu mbolŋge maŋau kade ta maŋau ndui tambi ndo Kuate nu tane mbolŋge kumba maŋ lato kamŋgat. ");
INSERT INTO ssd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ande nu wam afu ŋak minit ta Kuateŋge nu maŋ lato tuwit. Ande nu wam denkanu minit ta Kuateŋge nu tuku wam fudiŋndo ta yaite ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus nu pasa ndui ta tuturmba sakina: Kuate nu nuŋe gageu tugeka suŋgokate wam ta yaba pasa te suk. Taŋgo nu agaŋ tumunu kilmba kilke mbolŋge bareŋniŋgit. ");
INSERT INTO ssd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bareŋniŋge deŋpurmba ka furir nu kinymba ki ait mbolŋge aboŋga likate. Nu taŋamba lika minit le agaŋ bareŋniŋgit ta maŋge promba ka ka sugokade. Maŋge ta ndaŋndaŋmba sugokade ta nu katese ndate. ");
INSERT INTO ssd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kilkeŋge kulatkate. Maŋge prode sulumba kuzru waŋe-waŋeka sugoka kumba ka alode. ");
INSERT INTO ssd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ait kumuŋga manderkade le nu pitik ndo ka alonu kilit ŋga sakina. ");
INSERT INTO ssd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kile Yesus nu maŋ sakina: Kuate nuŋe gageu tugeka suŋgokate wam ta mastet tiŋnu tuku maŋau suk. ");
INSERT INTO ssd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mastet tiŋnu nu agaŋ ŋai fudiŋndo. Agaŋ tumunu afu ŋakmbaŋge nu lide ta ");
INSERT INTO ssd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","taŋgo nu tumba ŋgukate le nu promba suŋgoka kumzaŋel ail ŋakmba liniŋgit. Wainu sugokade le sar umaŋ te patika nzaŋ taŋge minig tuku ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus nu taŋamba yaba pasa afu gudommbambi pasa tumniŋganu. Nane ismba katesewanu le nu maŋ yaba pasa ande saniŋganu. ");
INSERT INTO ssd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nu pasa ande te-mayokmba sa ndaniŋganu. Nu nuŋe dubiwanu taŋgo ndoŋ minmba nane ndo pasa alonu saniŋganu. ");
INSERT INTO ssd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mara ait ndui ta ki butuŋgam bafuna le Yesus nu nuŋe dubiwanu mbal saniŋgina: Sine kule kualiŋ sim kab ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Taŋaka nane maŋgur suŋgo ta kusreka Yesus minna waŋ ta poŋga kinaig le nane afu waŋ kise poŋge lika nu ndoŋ kinaig. ");
INSERT INTO ssd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Kumba minnaig le Yesus nu waŋ pine mbolŋge gabat tatu pilmba nu kinymba gilaiŋgina. Kinymba gilaiŋgina le bubre suŋgo tiŋgina le kule toŋgel tiŋga mbalo sugo tiŋge lika waŋ katmba kule waŋ sinam kumba ligam bafuna le nane ndek nu kuanemba sanaig: Tum Taŋgo, sine ŋgisikam bafuweg te ne idus ndate e ŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","nu aboŋga tiŋga bubre kule ta sanike likina sulumba sakina: Maninka ibeŋ ka basleŋgap ŋgina le bubre ndek mukumba ma betkiremba kule basle mayena. ");
INSERT INTO ssd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Taŋana le Yesus nu mbilka nane saniŋgina: Ndaŋam tane wamdus fulilkade. Tane Kuate nu kumuŋ kuga ŋga idusde e ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","nane ndek kuru-kuruka naŋgine naŋgine sakinaig: i ... Taŋgo te nu ima suk a. Bubre kule mata nu tuku pasa isik ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kile Yesus nane kule kualiŋ sim ka Gerasa mbal tuku ma ta mbol pronaig. ");
INSERT INTO ssd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ma ta mbolŋge taŋgo ande bukla ŋak mindesiŋ patikinaig tuku ma mbolŋge minanu. ");
INSERT INTO ssd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Taŋgo kame nane nu biye timba muli kareŋnumbi mata ndalekam kumuŋ kuga. ");
INSERT INTO ssd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nane afuŋge muli kareŋnu kilmba nu tuku wai kupe ndalekanu ta nu mburerika wai kupe mbolŋge muli ta purpurniŋmba minanu le nane nu te-ibeŋam fugunaig. ");
INSERT INTO ssd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nu furir mafeŋ mindek mindesiŋ patikanu ma mbolŋge tabe poŋ pilemba witimba ndamembi nuŋe ŋgaro katmba minanu. ");
INSERT INTO ssd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nane ma ta mbol promba Yesus nu waŋ kusremba ibeŋ kina le taŋgo bukla ŋak ta maskenŋge nu kaŋgermba pinderka nu tugum promba dagol tidroŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Taŋana le Yesus nu bukla sana: Guwa ŋayonu, ne taŋgo te kusremba mayok kaye ŋgina le bukla taŋge nu wi kueŋka sarsarmba sana: Yesus, Suŋgo Kuate tuku Kiŋo, ne ye ndoŋ wamdus tuma kuga. Ye Kuate am mbolŋge ne sanet. Ne piti ser ndaya ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Taŋakina le Yesus ndek nu kusnana: Naŋe nyu ima ŋgina le nu lafumba sakina: Ye tuku nyu Kame Kuasmbi. Sine gudommba teŋge mineg ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Taŋakina sulumba nu saŋgri tiŋga sarsarmba sana: Ne kukulsiŋga le ma kise ande mbol nda kab ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tabe ta mbolŋge mbo afu suŋarka mine likinaig le ");
INSERT INTO ssd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","guwa ŋaigonu nane Yesus sarsarmba sanaig: Sine kukulsiŋga le mbo kame si tuku fuŋgul sinam kab ŋginaig le nu wokina. ");
INSERT INTO ssd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Wokina le ŋaigonu taŋgo ta kusremba kumba ka mbo fuŋgul sinam kine likinaig le nane saŋgri ŋak pinder-pindermba tabe te-tirok ta dubimba biri-bariŋga kule kualiŋ butonu sinam kumba ŋgisike sulunaig. Mbo kame ta gudommba 2,000 taŋaŋ. ");
INSERT INTO ssd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kile mbo kulatkanu mbal kua ka pinder-pindermba kinaig ka tumbraŋ suŋgo mbolŋge tumbraŋ kilimŋge nane ŋakmba saniŋginaig le nane afu isnaig sulumba nane suk agaŋ ta kaŋgeram kinaig ka ");
INSERT INTO ssd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesus tugum promba taŋgo bukla ŋak minna ta kile nu tawi tiŋmba wamdus kuyar mayenu ŋak minna le kaŋgermba nane piriri ŋayonaig. ");
INSERT INTO ssd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Taŋanaig le nane wam amboŋga kaŋgernaig mbal taŋge nane pronaig mbal taŋgo bukla ŋak ta tuku wam, mbo maŋau ke likinaig ta ŋakmba kubeu niŋginaig le ");
INSERT INTO ssd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ismba nane ndek Yesus sarsarmba nu nane tuku ma kusremba kuwa ŋga sanaig. ");
INSERT INTO ssd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesus nu waŋ poŋga minna le taŋgo amboŋga bukla ŋak minna ta nu Yesus ndoŋ kambim tuku sarsarna le ");
INSERT INTO ssd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","nu peumba sana: Ne luka naŋe tumbraŋ kaye sulumba Suŋgo nu ne sinanumba ne mbolŋge wam mayewat ta naŋe gulab kame kubeu niŋga ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Taŋakina le nu luka kumba Dekapolis tumbraŋ 10 ta mbolŋge lika Yesus nu mbolŋge wam mayenu kina ta kubeu niŋgina le nane ŋakmba ismba pirerek purkinaig. ");
INSERT INTO ssd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus nu maŋ luka waŋ mbol mbol kule kualiŋ tem ilna ta nane maŋgur ŋak pro nu te-ŋgamunaig le nu piyal taŋge minna. ");
INSERT INTO ssd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Minna le kusem wande kulatkanu taŋgo ande nyunu Yairus nu pro Yesus kaŋgermba nu tugumŋge ŋgurŋgurka ndeka sarsarmba sana: ");
INSERT INTO ssd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ye tuku kulim tawo ndo minit. Ne kumba naŋe waimbi ŋgarosu kirewa le nu aboŋga mayekuwa ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Taŋakina le Yesus nu ndoŋ kina le nane gudommba nu te-ŋgamumba dubimba kinaig. ");
INSERT INTO ssd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pino ande nu mara mindek tambun guaze ŋak minmba minna le yar 12 kina. ");
INSERT INTO ssd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nu dokta gudommba tugum kina le nane nu wakeiwewe piseŋginaig. Nu nane piyaniŋmba nuŋe ndametiŋ mata panke suluna ta guaze suŋgoka ŋayona. ");
INSERT INTO ssd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Pino ta nu Yesus tuku nyu isna sulumba nu taŋgo ŋgamuk kina ka Yesus ŋgumnemŋge nu tuku tawi kirena. ");
INSERT INTO ssd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kiremba nu teŋenmba idusna: Ye nu tuku tawi ndo kirewi ta ye mayekamŋgit ŋga idusna. ");
INSERT INTO ssd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nu taŋamba tawi kirena le guaze ta kugana le kamusna. ");
INSERT INTO ssd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesus tuku saŋgri ande nu kusrena le kamusmba nu mbilka nane kusnaniŋgina: Imaŋge ye kireyat ŋgina le ");
INSERT INTO ssd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","nuŋe dubinaig mbal ndek Yesus sanaig: Ai ta. Nane gudommba ne te-ŋgamunumba signanade. Ndaŋam imaŋge ye kireyat ŋgate ŋginaig. ");
INSERT INTO ssd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Taŋakinaig le Yesus nu mbilka agaŋ nu kirena ta kaŋgeram tuku sotina. ");
INSERT INTO ssd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sota minna le pino nu mayekina ta katesemba nu kuru-kuruka ŋgarosu piririmba mayok kumba Yesus tugumŋge ŋgurŋgurka ndeka pasa ŋakmba kile-mayokkina le ");
INSERT INTO ssd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","nu ndek sana: Kulim, ne ye tuku saŋgri tomba tiŋgate tukunu ne mayekat. Ne wamdus bulok ŋak kaye ka maye mina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nu pasa ta saka minna le kile nane afu Yairus tuku wandekŋge pro nu sanaig: Ne tuku kulim buk kumat. Ne ake sinaŋ Tum Taŋgo te piro kareŋ tuwe ndaka ŋginaig ta ");
INSERT INTO ssd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesus nu pasa ta nda isanu sukmba kusem wande kulatkanu taŋgo ta sana: Ne wamdus fulil ndaka. Ne ye tuku saŋgri tomba tiŋgate ta ndo idusmba mina ŋgina. ");
INSERT INTO ssd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Taŋakina sulumba nu nan