﻿USE sofia;
DROP TABLE IF EXISTS sofia.srqNT_vpl;
CREATE TABLE srqNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES srqNT_vpl WRITE;
INSERT INTO srqNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ã ndei Jesucristo i ñiinda ã. David rei ei tuchɨ. Abraham abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ndei Isaac ndu. Isaac ndei Jacob ndu no. Jacob ndei Judá ru no. Judá nongue abe ru. ");
INSERT INTO srqNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá rei Fares ndu. Zara ru abe no. (Tamar rei ũquɨ̃si.) Fares ndei Esrom ndu. Esrom ndei Aram ndu. ");
INSERT INTO srqNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ndei Aminadab ndu. Aminadab ndei Naasón ndu. Naasón ndei Salmón ndu. ");
INSERT INTO srqNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ndei Booz ndu. (Rahab ndei esi.) Booz ndei Obed ndu. (Rut rei esi.) Obed ndei Isaí ru. ");
INSERT INTO srqNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí rei David ndu. David ndei ererecua. David ndei Salomón ndu. (Urías ninisi rei esi.) ");
INSERT INTO srqNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ndei Roboam ndu. Roboam ndei Abías ru. Abías rei Asa ru. ");
INSERT INTO srqNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa rei Josafat ndu. Josafat ndei Joram ndu. Joram ndei Uzías ru. ");
INSERT INTO srqNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías rei Jotam ndu. Jotam ndei Acaz ru. Acaz rei Ezequías ru. ");
INSERT INTO srqNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías rei Manasés ru. Manasés rei Amón ndu. Amón ndei Josías ru. ");
INSERT INTO srqNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías rei Jeconías ru. Jeconías nongue abe ru. Ũquɨ̃ ngue siqui abae judíos rerao mose Babilóniaa nda. ");
INSERT INTO srqNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jeconías rei Salatiel ndu no. Salatiel ndei Zorobabel ndu. ");
INSERT INTO srqNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ndei Abiud ndu. Abiud ndei Eliaquim ndu. Eliaquim ndei Azor ndu. ");
INSERT INTO srqNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ndei Sadoc ndu. Sadoc ndei Aquim ndu. Aquim ndei Eliud ndu. ");
INSERT INTO srqNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ndei Eleazar ndu. Eleazar ndei Matán ndu. Matán ndei Jacob ndu. ");
INSERT INTO srqNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob ndei José ru. José quia María quereco nguiã. María rei Jesús si. Cristo, ɨ equia ee. ");
INSERT INTO srqNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nyebe cator ce generaciones jaaja. Sã Abraham nane siqui no. David siqui mose, catorce generaciones cote. Abae judíos rerao mose Babilóniaa, catorce que aque abe mose cote ra. Cristo nyaacuquia mose que catorce aque mose cot e no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo chaacuquia tasenei na jẽje. María rei esi. María que siquichõ ndei quia José ninisirã nda. Nyucuaaque ru eã ngue siqui rei ra. Nguiirĩ ngue eteachõ nguíe ye ra. Siquíã ndaque José rese. Espíritu Turã ae que eriirĩ mondo erie ye ra. ");
INSERT INTO srqNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José turãte que eriqui rei ra. Eɨreɨ̃te que eriqui mae María rio rese ra. —Seninisirã eã nda cote reae. Ahuɨ rei ra esɨ mbia mbiiranua ndeae, ɨ rei que ndua ndua uchɨ angui re ra. María siqui reɨ̃ nguia emo ndese ee reaẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","José que ndua ndua quia erese ra. Ndua ndua mose que ángel mo ndu eque re cuu ra. Angel que ñee ee ra. —David riirĩ ño nde re. María eisi turã ño neninisirã. ¡Ndeɨreɨ̃ ngũíã ño jẽ! Emo ngue siqui ãte quia erese ra. Espíritu Turã ae que eriirĩ mondo erie ye ra. ");
INSERT INTO srqNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nguiirĩ nda etea. “Jesús” ere chõ eriirĩ je. Ae quia ra mbia sirõ tuchɨ eɨcuã sɨ, ɨ que ángel ñee José je cuu ra. ");
INSERT INTO srqNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Eɨ̃ nda Dios cheẽ ɨo cote. Ae Dios cheẽ mbuchecuasa mbesa cose nae, ũquɨ̃ nda ɨo cote. Ã ndei embesa ji ã: ");
INSERT INTO srqNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","¡Sã jẽ! Nyucuaaque ruã nda nguiirĩ tea. Emanuel, ɨ ra eriirĩ je. Dios riqui nanderese co, ɨ ñɨ Emanuel nde, ɨ que embesa ji cose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José que ñumumba cote ra. Angel cheẽ nduɨ sɨ que María rerequia turã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","José que siqui eã mbeɨ erese ra. Nguiirĩ ndea chee. Jesús ɨ que José eriirĩ je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús que nyaacuquia Belén nda. Judea, ɨ que hue ibi je ra. Herodes rei hue jenda mbia rerecua Jesús nyaacuquia mose. Mbia aquiatu mo ngue ngaẽ huee ra. Tenda semba sɨ que ecuaẽ Jerusalén nda. ");
INSERT INTO srqNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ũquɨ̃ ngue ñee ngaẽ judíos je ra. —¿Mangue judíos rerecua mangue re? Ae nyaacuquia ramo nae ¿mangue mangue re? Uremae ngue nyasitata embae rese ra. Ureɨco mose ure récuaa. Nyebe urechu nguiã erea co. Urecoi rã urenia ndese ñee ee. ¿Ma eriqui ma nde? ɨ que mbia aquiatu ñee judíos je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herodes que jirandu erese ra. “Judíos rerecua nyaacuquia” ɨ mose, Herodes que pare pare ɨ tuchɨ quia ra. Siqui turã eã cote. Jerusalén jenda abe que ndua ndua jate quia erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes que “jenyu” ɨ sacerdote rerecua ja je ra. Embesasa ja je abe que “jenyu” ɨ ra. —¿Mangue ra Cristo nyaacuquia mangue re? “Hue ra nyaacuquia” ¿ɨ embesa ji re? ɨ que Herodes ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ũquɨ̃ ngue ñee Herodes je ra. —Nyaacuquia ra Belén de Judea. Ɨ que embesa ji ra: ");
INSERT INTO srqNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Sucha ñetẽ tuchɨ rei Belén. Belén de Judea. Mbia chɨɨcua tuchɨ ra Belén cote. Hue jenda mo nda mbia rerecuarã tuchɨ cote. Ae ra serimba Israel jenda teaquiatu tuchɨ quia cote, ɨ que Dios cheẽ embesa ji ra, ɨ que sacerdotes ñee Herodes je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nyebe Herodes “jenyu” ɨ nguiã ũquɨ̃ mbia aquiatu je. Ñee ngue ũquɨ̃ ísaa ra. —¿Manosete nyasitata embae rese jemae nde? ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Herodes que ũquɨ̃ mbia aquiatu mondochoɨ Belén cote ra. —Jẽso Belén. Nyaacuquia ramo je rese jẽirandu tuchɨ. Jẽ erea mose, sembiirandu se. Ɨ̃ nda se abe aso mae erese. Ɨ̃ nda acoi senia ndese se abe ñee ee, ɨ rei que Herodes ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mbia aquiatu que nyoɨ cote ra. Ae nyasitata rese eriqui mae nyii nae, aque nyasitata que oso beɨ quia mbia rẽta ra. Tiba que ee Belén arõ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nyebe mbia aquiatu ia tuchɨ nguiã mae mose nyasitata tiba rese cote. ");
INSERT INTO srqNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mbia aquiatu que ɨque tuchúaa cote ra. Huee que ãquẽ ɨtãquieɨ̃ ndiqui ee cote ra. Usi rese. María, ɨ equia ee. Ngoi que ngũíã ndese eɨtãquieɨ̃ je cote ra. Ñee turã ngue ee ra. Mbae que esirõ mondo Jesús je cote ra. Oro. Mbae mbushɨmbusa abe no. Mirra abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Dios que ñee mbia aquiatu je cote ra. —Jẽsochɨ̃ nda ñee Herodes mbiirandu jẽ, ɨ que Dios ñee ee cuu ra. Nyebe echoɨ nguiã Herodes abi nguécuaa. ");
INSERT INTO srqNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aquere que Dio s ángel mo mondo ñee José je ra. Ñee ngue ee cuu ra. —Herodes ra eɨtãquieɨ̃ sequia sequia. Ɨquia serɨ̃te equia co. Jẽso uchã. Ãquẽ jendao sunuña Egíptoo. Esi rese. Huee jẽɨngochõ. Acheẽ jee ra ndeje huee, ɨ que Dios ñee José je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","José que ñumumba juã cote ra. Ãquẽ ngue ecuruchoɨ isa usi rese ra. Nyoɨ que Egipto quiti ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chɨ arete que Egíptoo ra. Ererecua Herodes que mano cote ra. Dios cheẽ ngue ɨque cote ra. Eɨ̃ ngue Dios cheẽ embesa ji ra: Seriirĩ ngue aru Egipto sɨ ra, ɨ que embesa ji ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes que paama ɨ tuchɨ cote ra. —Mbia aquiatu sembɨɨrɨ̃ ɨrɨ̃ ñochɨ̃. Nyebiã ñochɨ̃ ecuaẽ ñee seje, ɨ que ra. Nyebe que soldados mondo mbia riirĩ nacuẽ ɨquia ja cote ra. Ãquẽ ɨtãquieɨ̃ ngu e eɨquia ɨquia ja quia Belén jenda ra. Hue rurubinda ja abe no. Ngata ramo je abe ɨquia ja. Nyasitata nyecua quia mbia je nae, aque mosenda ãquẽ ɨtãquieɨ̃ ɨquia ja. ");
INSERT INTO srqNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Herodes ũquɨ̃ ɨquia mose que Dios cheẽ ɨque cote ra. Ae Jeremías mbesa quia: ");
INSERT INTO srqNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Mbia Ramá jenda nyeseo tuchɨ. Eya eã tuchɨ nguiirĩ ndese. Emo embia aroneãte. Eriirĩ nguia mano jate nguiã ee, ɨ que embesa ji ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","José chɨ mose Egipto que Herodes mano nyee ra. Nyebe Dios ángel mo mondo nguiã ñe e José je. ");
INSERT INTO srqNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—José, echumumba rã. Jẽso Israel cote. Ãquẽ abe erao. Esi rese. Ae ãquẽ ɨquia serɨ̃te quia nae, ũquɨ̃ ngue mano cote ra, ɨ que ángel ñee José je cuu ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","José que ñumumba cote ra. Nyoɨ que nyebi Israel quiti cote ra. Ãquẽ ngue equerao esi rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Herodes riirĩ ngue siqui Judea jenda rerecuarã cote ra. Arquelao, ɨ que ee ra. José jirandu mose erese que esiquiche cote ra. Oso sereãte que huee cote ra. Dios que ñee ee cuu ra. Nyebe esɨ nguiã Galilea cote. ");
INSERT INTO srqNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Sucha tubɨrɨã mo ngue chɨ Galiléaa ra. Nazaret, ɨ que hue je ra. José que nyoɨ beɨ hue, hue jendarã cote ra. Nyebe Dios cheẽ mbesa ji ɨque nguiã cote. Ɨ̃ ngue Dios cheẽ nda: Nazaret jenda ra Jesús, ɨ que Dios cheẽ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Emo mose que Juan el Bautista Dios cheẽ nenei nenei mbia je cote ra. Dios cheẽ ngue esenei senei nguia mbia je turúquiaa ra. ");
INSERT INTO srqNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Jendua sɨ jẽɨcuã ndese. Jendua sɨ Dios rese. Dios ra tu mbia rerecuarã tuchɨ cote, ɨ beɨte que Juan nguia ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sã Isaías embesa nyii no: Emo ndiqui ñeemombo mombo turúquiaa huee. “Sã emo ndiqui ñeenda mbuquiche no, eɨ̃ jenye sɨ chõ nguia jẽ abe ɨcoquiatu nandererecua je”, ɨ equia turúquiaa hue, ɨ que Isaías embesa ra. Juan nɨɨ sɨ que embesa ra. ");
INSERT INTO srqNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Quiicuã mbuaera chõ ngue Juan ɨrao ra. Mbae ɨre chõ ngue enumbicuasa no nda. Tucu mbuae chõ ngue eu quia no nda. Irao quiaa rɨɨnda abe. ");
INSERT INTO srqNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalén jenda que ngaẽ ngaẽ tuchɨ quia echeẽ andu ra. Judea jenda abe no. Ama Jordán nimia nduɨnda abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mbia huɨɨcuã nenei nenei mose Dios je, ũquɨ̃ mose que Juan ndiqui bautizar ɨ ee ra. Ama Jordán ye. ");
INSERT INTO srqNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fariseos tubɨrɨã abe que ngaẽ ngaẽ tuchɨ quia Juan ndea ra. Saduceos tubɨrɨã abe no. Juan ngue ñee asite ũquɨ̃ je ra. —Mbeɨ rã ño jẽɨngo nguiã ã. Mbae ɨcuã nda tu mbia je nae, ¿ũquɨ̃ nɨɨ ño jenyu quia uchã serea co re? ");
INSERT INTO srqNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Jẽ mbae ɨcuã ndecha mose Dios je, mbae turã jẽsaã saã mbeɨ quiatu quia ee cote. ");
INSERT INTO srqNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Abraham ndiirĩ nducucha chõ nande re. Nyebe ra Dios nandemingo beɨ” ¡jenyechɨ̃ nda jẽ! Dios Abraham ndiirĩ nducucha chao arõte raque sɨta je. ");
INSERT INTO srqNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ira rã sɨ chõ mbia riqui nguiã ã. Sã ira mo ndiqui ɨa turã no. Sã emo ndiqui ɨa eã no. Aque quia ra mbia maña cote. Erei sacuã. Eɨ̃ serɨ̃ serɨ̃ ño Dios nguiã mbia je co, mbia mbae turã naa eã mose. ");
INSERT INTO srqNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","I je chõ aɨco nguiã bautizar ɨ mbia je co. Jẽ ndua ndua sɨ mose Dios rese. Co chɨ emo ndu quia seruɨ co. Ae quia equirãcuã tuchɨ sesɨ re. Ae quia eturã tuchɨ sesɨ re. Ae quia ra bautizar ɨ mbia je Espíritu Turã je. Mbia chɨã mbitirõ sacuã. Sã tata riqui mbae mbitirõ no. ");
INSERT INTO srqNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ae ra mbia umbae mɨɨ ɨcúe. Eturã achõ ño embae re. Ae embae eã nae, ũquɨ̃ nda eséi cote. Ũquɨ̃ ndeisa ra ua eã mbeɨ tata. Sã mbia quiata a chiqui chiqui no. Sã ea mɨɨ ɨcúe no. Sã echuruique mombo tátaa no, ɨ que Juan ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús que tu Galilea sɨ cote ra. Tu que Juan ndea Ama Jordán nda. Juan bautizar ɨ sacuã ee. ");
INSERT INTO srqNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan ngue teã teã ndei ee ra. —¿Mañɨ ae ra bautizar ɨ ndeje re? Nde chõ bautizar ere seje ae, ɨ rei que Juan ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús que ñee ee ra. —Bautizar ere rei seje. Dios cheẽ nduɨ sɨ mbae nandesaã turã ja quia, ɨ que Jesús ee ra. Juan ngue eno ɨ chee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Juan ngue bautizar ɨ ee ra. Jesús que usẽ oso ama sɨ cote ra. Ibei que nyɨequia ee cote ra. Espíritu Turã ngue nguichi nyurushɨ rã nda. Nguichi que eu Jesús rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ibei jenda que ñee nda. —Seriirĩ ño co re. Sechesecua chõ co re. Seyate erese, ɨ que Dios ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Turúquiaa que Espíritu Turã Jesús rerao ra. “Tã tae Jesús je”, ɨ sacuã diablo Jesús je. ");
INSERT INTO srqNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Huee que Jesús riqui arete ra. Cuarenta días. Mbae mo ngue eu eã mbeɨ aque mose ra. Eriãcuãte que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aque mose tuchɨ que diablo sɨ ee ra. Embɨɨcuã sacuã. —Nde Dios riirĩ mose, mbichae esaã ã sɨta je. Ɨ̃ nda ereu, ɨ rei que diablo ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús que ñee ee ra. —Tei. Sã embesa ji ñee no: “Mbia chɨu achõ nda mbia mingo eã. Dios cheẽ nguia ra mbia mingo nguiã”, ɨ que embesa ji ra, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Aquere que diablo ererao Jerusalén nda. Querao que suruchuɨ ibate Dios chuchua arõ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ñee ngue Jesús je ibate ereco mose ra. —Nde Dios riirĩ mose, eo oso íbii no. Dios ra ndereaquiatu. Sã embesa ji riqu i ñee no: Dios ra ángeles mondo ndereaquiatu sacuã. Oje ra ndeisi. Nembuquichi mingue rae. Sɨta ra cua ɨã ndei je, ɨ que embesa ji ra, ɨ rei que diablo ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús que ñee diablo je ra. —Sã embesa ji ñee no: “‘Ma Dios sereaquiatu. Tã tae ee no’, jenyechɨ̃ nda Dios je”, ɨ ñɨ Dios cheẽ nde, ɨ que Jesús ñee diablo je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aquere que diablo ererao ibi ibate mo nda. Ibate tuchɨ ererao cote. Diablo que ibi teacuquia ja ee ra. Ɨshonda abe reacuquia ja ee. ");
INSERT INTO srqNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Diablo que ñee ee ra. —Sembae ja chõ ibi re. Ibi turã ja. Ndeɨco mose serese, tamondo ja ndeje. Serimbarã mose nde, tamondo ja ndeje, ɨ rei que diablo ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús que ñee ee ra. —Quiatúae sesɨ ae, Satanás. ¿Mañɨ nda se nderimbarã nde? “Dios ae rese chõ jeɨngo”, ɨ que embesa ji ñee ndesẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Diablo que oso erecha cote ra. Angeles que ngaẽ Jesús reaquiatu cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Aque mose que mbia rerecua Juan tarõ cárcel nda. Jesús jirandu mose etarõ ndese que esɨ Galilea cote ra. Nazaret, ɨ que sucha tubɨrɨã je ra. Aquere que esɨ siri Capernaum cote ra. Ama ndɨsha ji. Zabulón abe ji. Neftalí abe ji. Huee que Jesús sɨ siri ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Isaías chɨmbesa Dios cheẽ ngue ɨque cote ra. Jesús siqui mose huee. Eɨ̃ ngue Isaías embesa cose ra: ");
INSERT INTO srqNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","Mbia hue jenda ja que siqui itondáruu nyii ra. Zabulón jenda. Neftalí jenda. Ama ndɨsha ji jenda. Ama Jordán ndobeɨnda. Ae judíos eã Galilea jenda nae, ũquɨ̃ abe no. Ũquɨ̃ mbia que siqui ja rei itondáruu nyii ra. Nyaashɨ̃ ngue tu ee cote ra, ɨ que Isaías embesa ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aque mose beɨ chõ ngue Jesús riqui ñee mbia je cote ra. —Jendua sɨ Dios rese. Mbia rerecuarã tuchɨ ra Dios namo jiri, ɨ que Jesús quia ñee mbeɨ mbia je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Emo mose que Jesús sɨ quia ama nimia nduɨ ra. Ama Ndɨsha Galilea. Huee que mae Simón Pedro rese ra. Enongue rese abe que mae nda. Andrés, ɨ equia ee. Ɨ que eu sɨra mbuasa mondo mondo ii ra. Sɨra resenda beɨ rei ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús que ñee ee ra. —¡Seruɨ beɨ chõ jẽɨngo jẽ! Taembaaquiatu quiatu. Mbia teendu endu beɨ quia seje cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nyoɨ ja que eruɨ ra. Sɨra mbuasa sɨ que echoɨ huɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pe jiri que mae Jacobo rese ra. Enongue rese abe. Juan, ɨ equia ee. Eru abe que siqui erese ra. Zebedeo, ɨ equia ee. Huee que echɨ ja canoa ye sɨra mbuasa mbitirõ tirõ nda. —Jẽɨngo seruɨ, ɨ que Jesús Jacobo je ra. Juan je abe. ");
INSERT INTO srqNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jesús cheẽ nduɨbe tuchɨ que echoɨ eruɨ ra. Canoa ndecha. Ngu abe recha. ");
INSERT INTO srqNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús que ngata tuchɨ quia Galilea rɨ̃ nda. Mbia que embaaquiatu quiatu quia mbia chumunua nuásaa ra. Dios cheẽ turã ngue esenei senei nguia ee ra. Mbia rasi chumumbara que embucherõ cherõ nguia ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mbia Siri a jenda que jirandu tuchɨte chee erese ra. Nyebe eriqui nguiã erasi rurucuaẽ cuaẽ jate ee. Erasi chumumbara. Mbia aba checuayã nyɨreco abe no. Mbia quiachã quiachã je abe no. Mbia umɨ sayã je abe no. Jesús que embucherõ cherõ ja quia ra. ");
INSERT INTO srqNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mbia tubɨrɨã tuchɨ que siqui Jesús ruɨ cote ra. Galilea jenda. Decápolis jenda abe no. Jerusalén jenda abe no. Judea jenda abe no. Ama Jordán ndobeɨnda abe no. Uquɨ̃ jenda siqui ja Jesús ruɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mbia tubɨrɨã ngu e chɨ Jesús rese ra. Nyebe Jesús nyuɨ nguiã ibi ibate mo ndese ra. Ngoi que huee ra. Echɨmbaaquiatu que esɨɨchã ngaẽ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesús que embaaquiatu quiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Eɨ̃ ngue ñee ee ra: —Ae siqui mingue quia nae, eya chõ ũquɨ̃ nde. Ũquɨ̃ nda siqui Dios rese. ");
INSERT INTO srqNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ae nyeseo quia nae, eya chõ ũquɨ̃ nde. Dios ra embia tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ae eseteãte riqui nae, eya chõ ũquɨ̃ nde. Ibi ja ra embae cote. ");
INSERT INTO srqNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ae siqui turã sete quia nae, eya chõ ũquɨ̃ nde. Dios ra embucuata turã nguia. ");
INSERT INTO srqNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ae eya eãte riqui mbia rese nae, eya chõ ũquɨ̃ nde. Dios ia eãte ra ũquɨ̃ ndese. ");
INSERT INTO srqNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ae echɨã turãte riqui nae, eya chõ ũquɨ̃ nde. Ũquɨ̃ nda mae Dios rese. ");
INSERT INTO srqNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ae mbia mingo turã nguia nyɨese nae, eya chõ ũquɨ̃ nde. “Seriirĩ” ɨ ra Dios ũquɨ̃ je. ");
INSERT INTO srqNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mbia ɨcuã ɨcuã mose jẽturã je, jẽya tuchɨ rae. Jenderecua tuchɨ chõ Dios riqui nguiã co. ");
INSERT INTO srqNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mbia ñee ɨcuã mose jẽje serɨɨ̃, jẽya tuchɨ rae. Mbia ɨcuã ɨcuã mose jẽje serɨɨ̃. Mbia ñee ñooño mose jenɨɨ, jẽya tuchɨ rae. ");
INSERT INTO srqNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Jeñɨmbia chõ nguia ũquɨ̃ mose. Dios quia ra mbae turã tuchɨ mondo jẽje ibate. Mbia ɨcuã ɨcuande jẽje nyii. Eɨ̃ ngue mbia ɨcuã ɨcuã nguia Dios rimba je nyii no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Embiquesa rã ño jẽɨngo nguiã mbia je ã. Sã embiquesa turãte no. Eɨse quiachamba mose, eɨcuã tuchɨ ra cote. Mbia ra emombo chõ cote. Mbia ra irõ ño erese. ");
INSERT INTO srqNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tata rã ño jẽɨngo nguiã mbia Dios quiatoã je ã. Mbia sucha cuasu raã mose ibi ibátee, mbia ra mae ja erese. ");
INSERT INTO srqNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Sã nandeɨco lámpara mendi no. Sã nandeɨco eati eã no. Sã nandeɨco emɨɨ eã mbaequi re no. Erendi checua chõ nda nandemɨɨ nguiã. Mbia resae ja sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Eɨ̃ jenye sɨ chõ nguia tata turã na. Mbae resae turã mbia je. Eɨ̃ jenye mose ra mbia mae jẽturã ndese. Ñee turã nda jendu ibatenda je cote. ");
INSERT INTO srqNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Dios cheẽ ɨque ja sacuã ño achu nguiã co. Moisés cheẽ mbutiã sacuã eã ño ngue achu nguiã. Dios cheẽ mbuchecuasa cheẽ mbutiã sacuã eã ño ngue achu nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tacheẽ nyecua jẽje. Moisés cheẽ nda ɨque ja. Ibei ra ua. Ibi abe ra ua no. Moisés cheẽ nguia ra ua eã mbeɨ. Ique ja chee rae. ");
INSERT INTO srqNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dios cheẽ tubɨrɨãte raque mbia je, mbia echeẽ mumbayã sacuã. Emo echeẽ mɨɨ mumba mose, Dios biãte ra ũquɨ̃, Dios siqui mose ererecuarã tuchɨ cote. “Dios cheẽ mɨɨ emumba”, ɨ mose emo, Dios biãte ũquɨ̃. Ae echeẽ mumbayãte quia nae, Diosbi tuchɨ chõ ũquɨ̃ nde. Ae ñee nguia mbia je nae, “Dios cheẽ jemumbayã ja” ɨ quia mbia je nae, Diosbi tuchɨ chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tacheẽ nyecua jẽje. Fariseos uturã saã saã tuchɨ raque. Embesasa abe uturã saã saã tuchɨ raque. ¡Jẽ nguia jẽɨngo turã tuchɨ ũquɨ̃ sɨ jẽ! Jẽ jẽɨngo turã eã mose ũquɨ̃ sɨ, jẽɨngo eã nda Dios rese, Dios siqui mose mbia rerecuarã. ");
INSERT INTO srqNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ameɨ ñee ngue jeñandu rei ra. “Mbia mo nda ereɨquiachɨ̃. Nde mbia mo ɨquia mose, nde abe ra mbia ndeɨquia arõte”, ɨ rei que ameɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Se quia tacheẽ nyecua jẽje. Jẽ paama ɨ chooño mose jenongue je, mbia ra jeɨquia arõte. “Ndeaquiatuã nde” jenye mose jenongue je, mbia ra jẽɨquia arõte. “Ndearacuayã nde” jenye mose jenongue je, jẽso arõte ra tata cuasu. ");
INSERT INTO srqNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Nembae ofrenda rerao mose Dios je, endua rã nyii, emondo nonde ee. Ndenongue mo paama ɨ mose ndeje, ofrenda esecha rã oso ñee ndenongue je. Jeñɨmbuturã na nguia nyii. Aquere quiatu eso nyebi ofrenda mee Dios je cote. ");
INSERT INTO srqNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Emo mbia rerecua mbuqueta queta mose nderɨɨ̃, ndeturã ño ee. Echeẽ turã ño ee. Jẽ ae chõ jeñɨmbuturã jenyue. Ɨ̃ nda ndererao ɨcuã eã. Ndererao mose ra ndetarõ mbeɨ cárcel. ");
INSERT INTO srqNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Huee ra ereɨco beɨ. Nembae mondo ja tuchɨ chee ee. ");
INSERT INTO srqNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ameɨ ñee ngue jeñandu rei ra. “Emo ninisi rese ra jẽɨngochɨ̃”, ɨ rei que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Se quia tacheẽ nyecua jẽje. Emo mae ɨcuã mose cuña mo ndese, “aque rese nda aɨco raã ña” ɨ mose, ũquɨ̃ abe eɨcuãte. Siqui raanguia erese chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nderesa mae mose mbae ɨcuã ndese, echoo mombo. Nderesa nemingo serɨ̃ mose mbae ɨcuã nde se, echoo mombo. Coche nderesa mɨɨ eremombo nguiã. Ɨ̃ nda nderete osoã tata cuásuu. ");
INSERT INTO srqNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ndeo nemingo mose mbae ɨcuã ndese, echisia mombo. Coche ndeo mombo nguiã. Ndequiato cutinda raque. Ɨ̃ nda nderete osoã tata cuásuu. ");
INSERT INTO srqNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ameɨ ñee ngue jeñandu rei ra. “Emo ngũinisi mombose mose, sã emombo chõ. Papel mbesa ji emondo ee”, ɨ rei que ameɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Se quia tacheẽ nyecua jẽje. ¡Jeninisi ra jemombochɨ̃ jẽ! Jeninisi siqui mose emo ndese, ũquɨ̃ mose mɨɨ ño jeninisi jemombo arõte raque. Jẽ emombo chooño mose, jẽɨngo jeninisi mingo adulterio rese ũquɨ̃. Ae emombo ji quereco cote nae, ũquɨ̃ abe eɨcuãte no. Adulterio, ɨ chõ ũquɨ̃ je re. ");
INSERT INTO srqNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ameɨ ñee ngue jeñandu rei ra. “Jurar jenye mose Dios je, jeñee nda jembuchebichɨ̃ ee”, ɨ rei que ameɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Se quia tacheẽ nyecua jẽje. ¡Jurar jenye eã mbeɨ tuchɨ jẽ! Ibei rɨɨ̃ abe jurar jenye eã jẽ. Dios recua chõ ibei re. ");
INSERT INTO srqNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ibi rɨɨ̃ abe jurar jenye eã jẽ. Dios ironguia chõ ibi re. Jerusalén nɨɨ abe jurar jenye eã jẽ. Dios mbae tuchɨ chõ Jerusalén nde. ");
INSERT INTO srqNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jeãquĩ nɨɨ abe jurar jenye eã jẽ. Jẽa mɨɨ mo jembushĩ aroneate. Co mɨɨ jemondei aroneate no. ");
INSERT INTO srqNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","¡Jurar jenye eã jẽ! “Ae” jenye chõ. “Tei” jenye chõ. Ũquɨ̃ mɨɨ ño jeñee. Jurar jenye mose, eɨcuãte ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ameɨ ñee ngue jeñandu rei ra. “Emo nderesa mungue mose, nde abe aque resa emungue. Emo ndereɨ̃ siquio mose, nde abe ereɨ̃ esiquio”, ɨ rei que ameɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Se quia tacheẽ nyecua jẽje. Mbae ɨcuã nda jẽsaãchɨ̃ mbia ɨcuã je. Emo ucua mose nderitii rese, nderitii rɨbɨsho abe eteacuquia ee. ");
INSERT INTO srqNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Emo demandar ɨ mose ndeje, “nembae camisa emondo seje” ɨ mose, emondo chõ ee. Ndeɨrao nongue abe emondo ee. ");
INSERT INTO srqNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","“Sembae mbae usi erao jiri seje”, ɨ mose emo ndeje, peebe jiri erao ee. ");
INSERT INTO srqNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Emo ache ache ɨ mose ndeje, emondo ee. “Mbae mo prestar ere seje” ɨ mose emo, emondo ee. ");
INSERT INTO srqNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ameɨ ñee ngue jeñandu rei ra. “Ae eturãte riqui ndeje nae, echesecua erese. Ae ndeucuãyã nguia nae, nde abe eucuãyã” ɨ rei que ameɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Se quia tacheẽ nyecua jẽje. Echesecua chõ ndeucuãyãsa rese. Mbae turã esaã ño nguia ee. Ae ñee ɨcuã nguia nderɨɨ̃ nae, echeẽ turã ño nguia nde ee. Ae eɨcuãte riqui ndeje nae, ũquɨ̃ nɨɨ eɨco ñee turã Dios je. ");
INSERT INTO srqNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Eɨ̃ jenye mose ra Ibatenda riirĩ turã tuchɨ jẽ. Dios quiarei eturã mbia ja je. Mbia turã je. Mbia ɨcuã je abe no. Dios quiarei tenda mbusẽ turã mbeɨ mbia turã je. Eɨcuã je abe no. Dios quiarei ama mbuchaaqui turã mbeɨ mbia turã je. Eɨcuã je abe. ");
INSERT INTO srqNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ae eturãte riqui mbia jẽje nae, ũquɨ̃ achõ je jẽturã mose, eɨcuãte ũquɨ̃. Mbia ɨcuã abe mbae turã saãte uquiato achõ je. Eɨ̃ jenyechɨ̃ nda jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jẽquiato achõ je jeñee turã mose, aba biãte ũquɨ̃. Eɨ̃ ño Dios quiatoã abe nguiã ñee turã uquiato je. ");
INSERT INTO srqNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jẽ nguia jẽɨngo turã mbeɨ mbia ja je. Sã jendu Ibatenda turã mbeɨ riqui no. ");
INSERT INTO srqNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Sã mbia mae ja sechɨao turã ndese”, jenyechɨ̃ nda mbae turã naa mose. Mbia résaa achõ nda mbae turã jẽsaã saãchɨ̃ jẽ. Ũquɨ̃ jẽsaã saã mose ra jendu Ibatenda mbae turã mee eã jẽje. ");
INSERT INTO srqNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jẽɨngo mose mbae mee mee mbaecha reã je, jemondo checuayã ño nguia ee. Mbia mbiirandu randu eã. Ae uturã saã saã nguia nae, ũquɨ̃ na nda jẽɨngochɨ̃. Dios ra mbae turã mee eã ũquɨ̃ je. “Sã mbia mae ja sechɨao turã ndese”, jenyechɨ̃ nda jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mbae turã jẽsaã mose, jẽsaã mingue chõ. ");
INSERT INTO srqNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mbae turã jẽsaã nyecuayã ño. Jẽɨngo mose mbae turã naa naa nyecuayã, Dios ae ra mae jẽturã ndese. Ae quia ra mbae turã mee nyecua jẽje cote. ");
INSERT INTO srqNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jeñee mose Dios je, jeñee mingue chõ nguia ee. Uturã naa naasa rã nda jẽɨngochɨ̃. Ũquɨ̃ ndiqui nyoɨ choɨ mbiásaa ñee sacuã Dios je ũquɨ̃. “Sã mbia mae ja serese secheẽ mose Dios je”, ɨ equia ũquɨ̃. Mbia riqui mae jate raque erese. Dios quia ra mbae turã mee eã ee. ");
INSERT INTO srqNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nde ñeese mose Dios je, nde ae chõ echeẽ nguia ee ndechuchúaa. “Sa mbia mae ja serese”, erechɨ̃ nda jẽ. Nde a e chõ echeẽ nguia ee. Dios ae ra siqui nderese. Dios ae mbae ɨcua ja nguiã. Ae quia ra mbae turã mee ndeje cote. ");
INSERT INTO srqNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nde ñee mose Dios je, hue rɨ̃ beɨte ra ereɨcochɨ̃ ñee ee. Eɨ̃ ño Dios ɨcuasa reã nguiã ñee ndaque Dios je. “Hue rɨ̃ urecheẽ mbeɨ mose ra Dios ureandu”, ɨ rei nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ũquɨ̃ na nda jẽɨngochɨ̃. Ae mbae ãte riqui jẽje nae, ũquɨ̃ Dios ɨcuate quia co. Jeñee nonde ee. “Mbae embu ure je”, jẽ ɨ nonde ee. ");
INSERT INTO srqNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Eɨ̃ jenye chõ nguia ñee Dios je: Paba Ibatenda, sã mbia ñee turã mbeɨ quia nderɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mbia rere cuarã ja sacuã echu jeɨ íbii. Sã mbia ibatenda riqui siqui beɨte ndebi rese no. Sã mbia ibi jenda abe riqui ndebi rese. ");
INSERT INTO srqNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ae ra ureu namo, ũquɨ̃ embu rã urechɨurã. ");
INSERT INTO srqNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ae uresaã ɨcuã ɨcuã ndeje nae, ũquɨ̃ embutiã ná uresɨ. Sã ureɨco tesareɨ mbia ɨcuã ɨcuã mose ure je no. ");
INSERT INTO srqNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","“Mbae ɨcuã jẽsaã” ¡ɨchɨ̃ nda emo ure je jẽ! Urereaquiatu beɨ quia mbae ɨcuã sɨ. Nde mɨɨ ño mbia rerecuarã nde. Nde mɨɨ ño ndequirãcuã nde. Nde mɨɨ je mbia ñee turã sacuã mbeɨ. Amén. Eɨ̃ jenye chõ ñee Dios je. ");
INSERT INTO srqNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mbia ɨcuã ɨcuã mose jẽje, jẽtesareɨ chõ esɨ. Eɨ̃ jenye mose ra Dios Ibatenda abe jeɨcuã mbutiã jẽsɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jẽtesareɨ eã mose mbia ɨcuã sɨ, Dios abe ra jẽɨcuã mbutiã eã jẽsɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jenyɨu sɨ jẽhuɨ mose Dios je, “sã mbia mae jate seyayã ndese”, jenyechɨ̃ nda ñee. Jendesa ia eã techɨ̃ nda aque mose jẽ. Eɨ̃ ño uturã naa naasa nguiã. Mbia nda mae ja rei nguiã erese. Dios quia ra mbae turã mee eã ee. ");
INSERT INTO srqNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ndehuɨ mose ndechɨu sɨ Dios je, ndeya chõ eɨco. ");
INSERT INTO srqNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Sã mbia jiranuã nderiãcuã ndese. Sã Dios ae jirandu nderiãcuã ndese. Dios quia mbae ɨcua jate nguiã. Ae quia ra mbae mee ndeje cote. ");
INSERT INTO srqNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mbae turã tamunua nu a sembaerã aa íbii”, jenyechɨ̃ nda jẽ. Chicuaquiareɨ̃ nda eu arõte. Emo embuquiachã arõte jẽsɨ. Eichoi arõ ndete no. ");
INSERT INTO srqNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ibate quia mbae jemunua nua jembaerã. Ibate quia ra chicuaquiareɨ̃ eu eã. Ibate quia ra jembaerã ichoi eã mbeɨ. Ibate quia ra emo embuquiachã eã jẽsɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Jembaerã chɨ mose ibate, Dios rese ra jẽɨngo ndua turã. Jembaerã chɨ mose íbii, ibi jenda mɨɨ ndese ra jẽɨngo ndua. ");
INSERT INTO srqNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nanderesa quiarei mbae resae nanderete je. Nanderesa turã mose, nanderete abe ra oso turã. ");
INSERT INTO srqNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nanderesa ɨcuã mose, nanderete abe ra oso ɨcuã ɨcuã no. Tat a rendi rã jẽɨngo beɨ. Ũquɨ̃ mose ra jẽɨngo jiri jiriã itondáruu. ");
INSERT INTO srqNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Erimba mɨɨ mo siqui aronea ererecua nyeremo ndese. Ererecua nyeremo mose, huee ra erimba ererecua nongue ucuayã. Ererecua nongue ra ebite. Eɨ̃ sɨ chõ mbia re. Ae ndua beɨte quia mbae isiquia rese nae, ũquɨ̃ siqui aroneate Dios ruɨ. Ae siqui beɨte quia Dios rese nae, ũquɨ̃ nguiarei ndua eã jiri mbae isiquia rese. ");
INSERT INTO srqNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“¿Mbae ra nandeu re?” jenyechɨ̃ nda quɨcoɨ coɨ jẽ. “¿Ma tiru ra nandemingue re?” jenyechɨ̃ nda quɨcoɨ coɨ no jẽ. Mbia chɨu ae ra mbia mingo eã. Mbia ɨrao abe ra mbia mingo eã no. ");
INSERT INTO srqNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sã nguireɨ̃ no. Mbae tiquiayã ndaque. Mbae ɨshao eã ndaque no. Mbae ruacuã eãte raque embae no. Dios ae quiarei embuquiaru quiaru beɨ. Jẽ nguiarei Dios queteamba tuchɨ nguireɨ̃ sɨ. Dios ae jembuquiaru nguiã jẽ no. ");
INSERT INTO srqNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mbi a ae ra tiarõ eã. “Se ra atiarombe”, ɨ raque ndua ndua uchɨangui re. Dios ae mbia mbutiarõ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Ma tiru ra nandemingue re?” jenyechɨ̃ nda pare pare ɨ jẽ. Sã mbae uti no. Sã mbae uti turãte riqui no. Mbae ao ao eã ndaque. Ninyu mburirã ndirã eã ndaque. ");
INSERT INTO srqNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Dios ae chõ mbae uti mbuturã nguiã. Mbae uti quiarei eturã jiri Salomón sɨ. Salomón turãte raque. ");
INSERT INTO srqNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sã Dios quiata mbuturã no. Quiata mano jeɨte raque. ¿Mañɨ nda Dios jembɨɨrao eã jẽ nde no? ¿Mbaerã jẽɨngo Dios ɨcuayãte re? ");
INSERT INTO srqNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“¿Mbae ra nandeu re?” jenyechɨ̃ nda pare pare ɨ jẽ. “¿Mbae ra nandembei re?” jenyechɨ̃ nda pare pare ɨ jẽ. “¿Ma tiru ra nandemingue re?” jenyechɨ̃ nda eno jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Eɨ̃ ño Dios quiatoã nguiã. Jẽ nguia jendu Ibatenda tesareɨã mbeɨte nguiã jẽsɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jẽ nguia jẽɨngo tuchɨ Dios rese jenderecuarã. Sã Dios turãte no. Ũquɨ̃ na ño jẽɨngo. Ũquɨ̃ mose ra Dios mbae mee mee mbeɨ jẽje. Jenyɨurã. Jeñɨmbeirã abe no. Jẽɨraorã abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Mbae tiã ñochɨ̃ nda seje isamamɨ nde”, jenyechɨ̃ nda pare pare ɨ jẽ. Isamamɨnda rese ra jendua nduachɨ̃ namo jẽ. Namonda mɨɨ ndese jendua namo no. Isamamɨ nguiatu jendua isamamɨnda rese. ");
INSERT INTO srqNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Co que eɨcuãte ra”, jenyechɨ̃ nda emo nɨɨ. “Jẽɨcuãte” ɨã nda Dios jẽje chã. ");
INSERT INTO srqNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mbia ɨcuã mose, jeñeechɨ̃ nda ee. Jẽturã mose ee, Dios abe ra eturã jẽje. Mbae jemee mee turã mbia je. Dios abe quia ra mbae mee tuchɨ jẽje cote. Jẽ embisẽ mee mose emo je, Dios abe ra embisẽ mee jẽje no. ");
INSERT INTO srqNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Mbaerã jẽɨngo “eɨcuã” ɨ emo je re? Jẽ jẽɨcuã tuchɨ mose esɨ. “Mbae ñetẽ ndiqui nderésaa aque”, jenyechɨ̃ nda emo je, jẽ mbae cuasu rerequia mose jendésaa jẽ nguiatu. ");
INSERT INTO srqNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","“Mbae turã ndese chõ jẽɨngo”, jenyechɨ̃ nda jẽ jẽɨcuã mose jẽ. “Mbae ñetẽ tasirõ nderesa sɨ”, jenyechɨ̃ nda mbae cuasu siqui mose jendésaa jẽ. Jẽ nguia jẽturã jẽsaã saã ñote nguiã aque. Jẽ nane nguia jẽturã ndiqui. Aquere quia jeñee emo mingo turã cote. ");
INSERT INTO srqNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Sã mbia mo ndiqui perro rã sɨ no. Teasu socoi quía rã abe no. Ũquɨ̃ nguiarei mbia ɨcuã mbeɨ Dios cheẽ andure. Dios cheẽ isi teã teã. Dios cheẽ jẽsenei eã ũquɨ̃ je cote. Emo je quia jẽsenei cote. ");
INSERT INTO srqNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jeñee mbeɨ mose Dios je, mbae ra emondo jẽje. Jẽ mbae mo ndequia mose, jẽtea rae. Jẽ eɨquesa mbuu mbuu mose, ũquɨ̃ mose ra embuquiata jẽje no. ");
INSERT INTO srqNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ae ñee mbeɨte quia Dios je nae, mbae ra Dios mondo ee. Ae mbae mo sequia beɨte quia nae, tea rae. Ae eɨquesa mbuu mbuu quia no nae, equia ra ee no. ");
INSERT INTO srqNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Jendiirĩ “mbichae embu seje” ɨ mose, ¿sɨta ra eru mee ee re? ");
INSERT INTO srqNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jendiirĩ “sɨra embu seje” ɨ mose, ¿mbeɨ ra eru mondo ee re? ");
INSERT INTO srqNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mbia ɨcuã nyee mbae turã mondo mondo quia nguiirĩ je ã. Jendu Ibatenda quia ra mbae turã tuchɨ mee jẽje, jeñee mose ee. ");
INSERT INTO srqNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sã jẽyate riqui mbia siqui turã mose jẽje no. Eɨ̃ jenye sɨ chõ nguia siqui turã mbia je no. Moisés chɨmbesa tuchɨ chõ ũquɨ̃ nde. Dios quiato cose ndare chɨmbesa ja chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Eɨquesa chumumbi rɨ̃ ño jẽso ɨque jẽ. Aque ñeenda oso quia tata cuasu nae, eɨcoɨ chõ aque re. Ae eɨquesa ngasẽ nguia tat a cuasu nae, eɨcoɨ chõ aque no nde. Hue rɨ̃ mbia tubɨrɨã ndiqui nguiã ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ñeenda nongue ruɨ quiatu ngasẽ nguiã Dios je. Aque ñeenda quiarei echumumbi. Echumumbi chõ aque ñeenda ɨquesa re. Mbia mɨɨ mɨɨ ño siqui nguiã aque ñeenda ruɨ. Ũquɨ̃ nguia ra Dios mingo beɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ae Dios cheẽ senei ñooño nguia nae, aba mbɨɨrɨ̃ ɨrɨ̃sa chõ ũquɨ̃ nde. Ũquɨ̃ ndei Dios quiato raã ñooño. Mbia mbɨɨrɨ̃ ɨrɨ̃sa Dios rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sã ira ae e a ae ae no. Uva a rã eã nda nyu a ɨa no. Ea ae eno nde. Higo a rã eã nda isio rashɨ̃ a no. Ea ae eno nde. ");
INSERT INTO srqNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eɨ̃ sɨ chõ mbia no nde. Mbia turã nda siqui mbae turã ndese. Mbia ɨcuã nda siqui mbae ɨcuã ndese no. ");
INSERT INTO srqNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ira turã mose, ea abe ra eturã. Nyɨabi aronea. Ira ɨcuã mose, ea abe r a eɨcuã no. Ei rã sɨ ra ea. ");
INSERT INTO srqNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ira mo ɨa turã eã mose, nyisia rae. Mendi rae. ");
INSERT INTO srqNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Dios cheẽ nenei neneisa chõ jẽɨcua rã. Dios cheẽ nduɨ sɨ eriqui turã mose, Dios quiato chõ ũquɨ̃ nde. Dios cheẽ nduɨ eã mose, Dios quiato eã ño ũquɨ̃ no nde. ");
INSERT INTO srqNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Sererecua” ɨ rei mbia tubɨrɨã nguiã seje ã. Ũquɨ̃ nguia nda ɨque ja eã nguiã serécuaa. Ae siqui Seru Ibatenda cheẽ nduɨ nae, ũquɨ̃ mɨɨ ño nda ɨque serécuaa. ");
INSERT INTO srqNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aque mose ra mbia ñee tuchɨ seje. “Jesús, ndecheẽ ngue urembuchecua checua tuchɨ quia mbia je resẽ. Aba checuayã ngue urejea jea tuchɨ quia mbia sɨ nderɨɨ̃ ndesẽ. Mbia mae sayã ngue uresaã saã tuchɨ quia nderɨɨ̃ ndesẽ”, ɨ tuch ɨ rei ra mbia seje. ");
INSERT INTO srqNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ũquɨ̃ je ra acheẽ. “Co aɨco jẽɨcuayã mbeɨte co resẽ. Jẽso serecha. Mbae ɨcuã aosa chõ jẽ nde”, ae ra ee. ");
INSERT INTO srqNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ae siqui serese, ae secheẽ mumbayã nguia nae, ũquɨ̃ nguiarei eturã tuchɨ. Tuchua ãtã aosa rã ño ũquɨ̃ nde. Sã eaquiatu mo tuchua ao sɨta turã arõ no. ");
INSERT INTO srqNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ama nyaaqui mose, amandi cuasu raque. Quɨrɨrɨã abe ɨchu ɨchu raque tuchu a je. Tuchua mbuquiata aroneate. Sɨta turã arõ nguia ngue uchuchu a ao nguiã. Eɨ̃ sɨ chõ secheẽ mumbasa rẽ a nde. Tuchu a ãtã aosa rã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ae secheẽ mumba quia eandu mose nae, eaquiatuã na ño ũquɨ̃ nde. Sã eaquiatuã mo uchuchuarã ao no. Aque quiarei ibi rɨbɨcoɨ tuchɨã. Sɨta quiishɨ̃ arõchɨ chõ uchuchua ao nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ama nyaaqui mose, amandi cuasu ee cote. Quɨrɨrɨã abe ɨchu ɨchu tuchua je. Aque quiarei iãcuã mbucoɨ asi mondo. Eɨ̃ sɨ chõ secheẽ mumbasa re, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús que huɨ ucheẽ sɨ cote ra. Mbia que nyuruɨra tuchɨ echeẽ andu ra. ");
INSERT INTO srqNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ererecua rã ño ngue eriqui nguiã mbia mbaaquiatu quiatu. ");
INSERT INTO srqNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús que nguichi ibi ibate sɨ cote ra. Mbia cuabẽte que siqui eruɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Emo ndasi que tu ee ra. Leproso, ɨ que aque erasi je ra. Tu que ngoi ngũíã ndese ñee Jesús je ra. —Sererecua, nde sembucherõse mose, sembucherõ se, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús que oco erese cote ra. —Echerõ cote, ɨ que ee ra. Echeẽ mosebe que nyerõ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús que ñee ee ra. —¡Erecheẽchɨ̃ nda mbia mo je jẽ! Eso nderasiã ndeacuquia sacerdote je cote. Moisés cheẽ nduɨ sɨ chõ mbae mo emondo Dios je. Eɨ̃ nda mbi a jirandu nderasiã ndese cote, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús que oso sucha tubɨrɨã Capernaum cote ra. Soldado rerecu a mo ngue tu ñee ee ra. Capitán ngue ae ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Sererecua, serimba rasite riqui sechuchua huee. Erasi tuchɨ. Umɨ umɨ sayã tuchɨ, ɨ que capitán ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Taso embucherõ, ɨ que Jesús echeẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Capitán ngue ñee Jesús je ra. —Seɨcuãte aɨco co, Jesús. Sechuchua ra ereɨquechɨ̃. Echeeño. Ndecheẽ achõ ño emondo serimba mbucherõ sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Se abe sererecua riqui co. Echeẽ amumba aroneate quia co. Se abe soldados rerecua aɨco nguiã co no. Secheẽ abe emumbayãte quia co no. Eso, ɨ mose, secheẽ mumbayãte no. Echu, ɨ mose, secheẽ mumbayãte no. Se neẽ mose serimba je, secheẽ mumbayãte no. Ndequirãcuã na eãte raque se, ɨ que capitán ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Echeẽ andu mose que Jesús nyuruɨrate ra. Ñee ngue nguesenda je ra. —Tacheẽ nyecua jẽje. Capitán ndiqui seɨcua tuchɨte co. Seɨcua tuchɨte equia judíos mo sɨ co. ");
INSERT INTO srqNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tacheẽ nyecua jẽje. Ae judíos eã emo jenda ja nae, ũquɨ̃ tubɨrɨã nda siqui Dios rese. Dios siqui mose mbi a rerecuarã. Ũquɨ̃ tubɨrɨãte ra quiaru turã Abraham ndese. Isaac rese. Jacob rese no. Judíos eã ndaque ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Dios quia ra judíos mombo itaicuee. Itondáruu. Huee ra nyeseo tuchɨ cote. Erasite ra huee cote, ɨ que Jesús ñee judíos rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesús que ñee capitán je cote ra. —Eso chõ ndechuchúaa cote. Ereɨco seɨcuate co. Nyebe ndecheẽ amumba eã nguiã nderimba mbucherõ, ɨ que Jesús ee ra. Jesús cheẽ mosebe que erimba nyerõ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús que oso Pedro chuchua cote ra. Ɨ que Pedro chari rasi u nyaara ee ra. Eracu tuchɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús que oco ari o rese ra. Eracu que ti ɨ cote ra. Ari que juã cote ra. Mbae que echao chao quia mbia chɨurã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Itondaru ramo mose que mbia erasi rurucuaẽ cuaẽ tuchɨ Jesús je ra. Ae aba checuayã quereco qui a nae, ũquɨ̃ ndurucuaẽ tuchɨ Jesús je. Aba checuayã ngue usẽ usẽ nguia mbia sɨ Jesús cheẽ mose ra. Erasi chumumbara que embucherõ cherõ tuchɨ quia ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ũquɨ̃ mose que Isaías cheẽ ɨo cote ra. Eɨ̃ ño ngue Isaías embesa cose ra: “Dios rucucha que nandeɨcuã sirõ nandesɨ ra. Dios rucucha que nanderasi sirõ nandesɨ no nda”, ɨ que Isaías embesa ra. Ũquɨ̃ ngue ɨo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mbia cuabẽte que Jesús mamate ra. Nyebe Jesús ñee nguiã uchɨmbaaquiatu je. —Nyao rã sobeɨ, ɨ rei que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aque mosete que embesasa mo ñee ee ra. —Taɨco beɨ nderese. Ndeso mose manguiti, se abe ra aso beɨ quia nderese, ɨ rei que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús que ñee ee ra. —¿Mbae rasi ra eresaã saã serese re? Eoita quia ecua jiri re. Nguɨreɨ̃ nguia equisa jiri no nde. Se quia sequisayã mbeɨ re, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Echɨmbaaquiatu mo ngue ñee ee ra. —Sererecua, sã paba mano na. Aquere quia ra aɨco beɨ nderuɨ cote, ɨ rei que Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús que ñee ee ra. —Sã mbia ataque chõ nderu chati. Eɨco chõ seruɨ nde, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús que ua canoa ye cote ra. Uchɨmbaaquiatu rese. ");
INSERT INTO srqNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ama ndiit e re mose que quɨrɨrɨã ɨcuã ɨcuã ndu ee ra. I rebera que ɨque ɨque tuchɨ quia canoa ye ra. Jesús que uque oso quia canoa ye ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nyebe echɨmbaaquiatu Jesús mumba nguiã. —Urembaaquiatusa, echumumba. Ureraaro nã. Nandemanochɨ̃ nda re, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús que ñee uchɨmbaaquiat u je ra. —¿Mbaerã jẽsiquichete riqui re? ¿Seɨcuayãte equia ã nde? ɨ que Jesús ñee ee ra. Nyuruã ngue ñee asite quɨrɨrɨã je cote ra. Ama je abe no. Quɨrɨrɨã ngue ti ɨ echeẽ mose cote ra. Ama abe. ");
INSERT INTO srqNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Echɨmbaaquiatu que nyuruɨra tuchɨ mae Jesús quirãcuã ndese ra. —Quɨrɨrɨã echeẽ mumbayã ñochɨ̃. Ama abe echeẽ mumbayã ñochɨ̃, ɨ que ñee ñee nyue cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús que ngasẽ ama ndobeɨ cote ra. Gadara, ɨ que hue ibi je ra. Ameɨ mo nyeremo ngue ngaẽ ngasẽ Jesús je ra. Mbia raaque tãsa sɨ chõ ngue ecuaẽ ngasẽ Jesús je ra. Aba checuayã ɨcuã ño ngue siqui tuchɨ nguiã ũquɨ̃ ñɨangui re ra. Aba checuayã ño ũquɨ̃ mbɨɨcuã tuchɨ nguiã. Nyebe mbia mo hue rurubiã mbeɨ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ũquɨ̃ ngue ñee asite cuaẽ Jesús je ra. —¿Mañɨ ere ra equia ure je re, Jesús? Dios rucucha chõ nde re. ¿Urembasi jeɨ sacuã ño erechu aa re? ɨ que ñee tuchɨ Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Chɨasu socoɨ tubɨrɨã ngue chɨ quiaru huee rurubi ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nyebe aba checuayã ɨcuã ñee jate nguiã Jesús je. —Nde urejea mose mbia sɨ, chɨasu chɨangui re ureso rã, ɨ que aba checuayã ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Eno, ɨ que Jesús ee ra. Nyebe aba checuayã usẽ ja nguiã ameɨ ñɨa sɨ cote. Chɨasu chɨangui re que echoɨ ja ra. Chɨasu que uchã ja choɨ nyiichere ama nimia mbucu rɨ̃ nda. Ama ndɨsha ye que echoɨ ja mano nda. ");
INSERT INTO srqNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chɨasu raarõsa mundite que ra. Mae mose erese. Nyoɨ que mbia mbiirandu jate chɨasu rese ra. —Jesús que ameɨ mbucherõ nda. Aba checuayã ngue ejea esɨ ra, ɨ que maesa erese ñee mbia ataque je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nyebe hue jenda nyoɨ ja nguiã ñee Jesús je. —Eso rã urerecha urerecua sɨ, ɨ jate que hue such a jenda ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesús que ua canoa ye cote ra. Nyoɨ que sobeɨ ra. Ngasẽ ngue uchuchúaa cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mbia que erasi mo curucuaẽ quisa ye ee ra. Emɨ sayãte que ae ra. —Erurucuaẽsa riqui seɨcua ũquɨ̃, ɨ que Jesús ñee uchɨangui re ra. Nyebe ñee nguiã emɨ sayã je. —Echimbia chõ, Echo. Ndechɨsaã mbae ɨcuã ambutiã nguia ndesɨ a, ɨ que Jesús ñee umɨ sayã je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Embesasa que ñee nyue ra. —Jesús riqui Dios ibatenda raã naa ñochɨ̃ co, ɨ que ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús que ũquɨ̃ ndua ndua ɨcuate quia ra. Nyebe ñee nguiã ee cote. —¿Mbaerã jẽɨngo ndua ndua ɨcuã nde? ");
INSERT INTO srqNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ma mbaranguiatuã eã jiri jẽje re? ¿Mbia ɨcuã mbutiã esɨ ere? ¿Mbia rasi mbucherõ ere no? ¿Ma mbaranguiatuã eã jiri jẽje re? ");
INSERT INTO srqNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dios rucucha rei se. Mbia chɨao ɨcuã mbutiã aquiatu chõ se re. Sequirãcuã tateacuquia jẽje, ɨ que Jesús ñee ee ra. Ñee ngue erasi je cote ra. —Ehuã na. Ndechuchua eso cote. Ndequisa abe erao, ɨ que Jesús emɨ sayã je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Emɨ sayã ngue juã asi oso ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mbia que nyuruɨra ja u mae emɨ sayã ngata rese ra. Mbia que ñee turã ja Dios quirãcuã nɨɨ cot e ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mateo, ɨ que emo je ra. Ae que impuestos isi isi beɨ quia mbia rerecua mbaerã nda. Jesús que ngasẽ ee cote ra. Ngoi que huɨ̃ plata isi isi impuestorã nda. —Seruɨ beɨ eɨco, ɨ que Jesús ñee ee ra. Ae Mateo juã oso nguiã eruɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Emo mose que Jesús nyoɨ quiaru erese ra. Impuestos isi isiquia ata que chɨ quiaru erese huee ra. Echɨmbaaquiatu abe rese. Mbia ɨcuã mo abe que chɨ quiaru erese no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseos que ñee ɨcuãte Jesús chɨmbaaquiatu je ra. —¿Mbaerã Jesús riqui quiaru mbia ɨcuãte rese re? ɨ que ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nyebe Jesús ñee nguiã ee. —Sã mbia rasiã ndiqui aba mbucherõsa requia eãte no. Sã erasi chõ ndiqui erequia no. ");
INSERT INTO srqNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","¿Ã embesa ji jẽɨcuayãte re? “Mbae mo jemee seje”, ae eã nguiã jẽje co. “Jẽya eã ño mbia rese”, ae chõ nguiã jẽje co, ɨ que embesa ji ra. Ũquɨ̃ embesa ji jẽɨcua jiri ae. “Jenyu seje”, aeã ngue u nguiã mbia turã je. Mbia ɨcuã je chõ ngue achu nguiã “jenyu seje” ɨ, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan ñɨmbaaquiatu que ngasẽ ñee Jesús je ra. —Ure quia ureɨco nguiã huɨ huɨ urechɨu sɨ ã. Fariseos chɨmbaaquiatu abe huɨ huɨ quia uchɨu sɨ no. ¿Mbaerã ndechɨmbaaquiatu riqui huɨ ãte uchɨu sɨ ã nde? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús que ñee ee ra. —Sã emo ndiqui ngũinisirã isi ramo no. Sã eresenda iate riqui quiaru erese no. Sã eriqui huɨ aroneate uchɨu sɨ aque mose no. Sã eru riqui mano emo mose no. Aque mose quiatu ra equiato huɨ uchɨu sɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sã emo ndiqui tiru yasu mɨɨ aroneate tiru ima sorei rese no. Eyasu ra nyaacua quiata eima sɨ. Soro ɨcoɨ tuchɨ ra cote. ");
INSERT INTO srqNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sã emo mbaeri rasi ramo nderecoquiatu eã eriru ima ye no. Mbae ɨre ima ye ererecoquiatu aronea ño ñene. Eri rasi ra ñimatã ño mbae ɨre ndoro. Eri ra uchẽ ja. Mbae ɨre abe mbɨɨcuãte ra cote. Mbaeri yasu quia nda equerecoquiatu nguiã mbae ɨre yasu ye. Soroã sacuã, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús cheẽ mose que judío rerecua mo ngasẽ ee ra. Jesús jii que ngoi ñee ee ra. —Quɨ seriirĩ sɨ mano namote quɨ. Nyao rã erea. Ndeoco mose erese, quera sɨ rae, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús que juã oso erese ra. Echɨmbaaquiuiatu abe nyoɨ erese. ");
INSERT INTO srqNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ari rasi mo abe que oso quia mbia ite rɨ̃ nda. Eruqui nda uchẽ mbeɨ quia ee ra. Doce años nyee. Eruqui nda tibayã mbeɨ ee ra. Ari que tu Jesús quite quiti erɨɨchã nda. Jesús ɨrao ai rese que oco cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","—Seoco mose Jesús ɨrao rese ra acherõ, ɨ nda ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús que uba ñee ari je ra. —Coche ñene, Echo. Seɨcuate que se ra. Nyebe arembucherõ nguiã, ɨ que Jesús ñee ari je ra. Aque mose tuchɨ que eruqui tiba ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesús que ngasẽ nyee judío rerecua chuchua ra. Mbia que nyeseo seo quia ãquẽ ndaaque rese ra. Mbia que ɨraseɨ raseɨ eraaque tiquia nonde ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús que ñee ee ra. —¡Quɨ jẽ! Jẽso ja itaicuee. Eriirĩ mano eã ño nguiã. Uque chõ ñene, ɨ que ñee mbia je ra. Mbia que ɨquia ɨquia echeẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesús que mbia mondo ja chee itaicuee ra. Oso que ɨ que eraaque rea cote ra. Eraaque o que eisi ra. Quera sɨ que cote ra. Nyuruã ngue cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mbia hue jenda que jirandu jate erese ra. Jesús eraaque mbuquera rese. ");
INSERT INTO srqNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús que oso hue sɨ cote ra. Mbia resayã nyeremo ngue nyoɨ eruɨ ra. Ñee mombo mombo que Jesús je ra. —¡Jesús! ¡David rucucha! ¡Ndeyayã ño urerese jẽ! ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús que oso ɨque tuchúaa cote ra. Ae eresayã nyoɨ nguiã erurubi. Jesús que ñee ee ra. —¿Sequirãcuã jembucherõ arõte reɨ̃ nguiã jẽje re? ɨ que Jesús ñee ee ra. —Ae, ɨ que eresayã ñee ja ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ae Jesús oco nguiã eresa rese cote. —Seɨcua mose ra jaembucherõ, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Eresa que nyerõ ja ee cote ra. —Sã mbia jiranua serese, ɨ tuchɨ rei que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Eresayã ngue Jesús cheẽ mumba tuchɨ ra. Nyoɨ que mbia mbiirandu tuchɨ Jesús rese hue rɨ̃ ja ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jesús so mose que mbia echeẽ ngũíã mo curucuaẽ ee ra. Aba checuayã ɨcuã ngue siqui aque chɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús que aba checuayã ɨcuã jea esɨ ra. Echeẽ ngũíã ngue ñee turã cote ra. Nyebe mbia tubɨrɨãte chɨ nguiã nyuruɨra mae erese. —Emo ngue ũquɨ̃ saã eã mbeɨte quia aa Israel ra, ɨ que nyuruɨra jate ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseos quiatu que ñee ɨcuãte Jesús rɨɨ̃ nda. —Satanás quirãcuã je chõ Jesús riqui nguiã aba checuayã jea jea mbia sɨ co, ɨ rei que fariseos ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús que nyoɨ sucha mbuchesea sea ja ra. Mbia mbaaquiatu quiatu ja ra. Mbia chumunua nuásaa jate. Dios cheẽ ngue esenei senei tuchɨ quia ee ra. Mbia rasi chumumbara que embucherõ cherõ nguia ra. ");
INSERT INTO srqNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mbia rasi rasi tuchɨ que ee ra. Mbia ia eã tuchɨ que ee ra. Mbia quiachã je rã ngue ee ra. Sã oveja riqui quiachã jate eraarõ iriã no. Eɨ̃ sɨ chõ mbia nguiã Jesús je. Nyebe Jesús ia eã tuchɨ riqui nguiã erese. ");
INSERT INTO srqNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesús que ñee uchɨmbaaquiatu je ra. —Secheẽ andusa reã ndei etubɨrɨã jiri. Secheẽ nenei neneisa quia rei co mɨɨ jiri. ");
INSERT INTO srqNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jeñee nguia Dios je. “Dios, ndecheẽ nenei neneisa mo emondo tuchɨ. Mbia mbiirandu randu sacuã”, jenye chõ nguia Dios je. Sã mbaecha mbia mo mondo mbae a ɨreɨ̃ ɨshao shao equiche mose no, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús que “jenyu” ɨ uchɨmbaaquiatu doce je ra. Uquirãcuã ngue emee uchɨmbaaquiatu je cote ra. Aba checuayã ɨcuã jea jea sacuã mbia sɨ. Mbia rasi chumumbara mbucherõ cherõ sacuã abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ã ño echɨmbaaquiatu ã nde: Simón (Pedro, ɨ abe que mbia quia ee ra.) Andrés (Simón nongue rei Andrés.) Jacobo (Zebedeo riirĩ ndei Jacobo.) Juan (Jacobo nongue rei Juan.) ");
INSERT INTO srqNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe Bartolomé Tomás Mateo (Impuestos isi isiquia rei Mateo.) Jacobo (Alfeo riirí ndei Jacobo.) Lebeo (Tadeo, ɨ abe que ee ra.) ");
INSERT INTO srqNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón el Cananista Judas Iscariote (Aque que Jesús mondo mbia ɨcuã je ra.) Ũquɨ̃ ja que Jesús irabo ra. ");
INSERT INTO srqNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús que ũquɨ̃ mondo ja ucheẽ nenei nenei sacuã nda. Emondo nonde que ñee ee ra. —Judíos achõ jembaaquiatu quiatu quia. Jẽsochɨ̃ nda judíos eã je. Samaria jenda chuchua abe ra jẽsochɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel jenda chõ jembuchesea sea oso. Ovejas quiachã je rã ño Israel jenda re. ");
INSERT INTO srqNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jẽso mose, secheẽ jẽsenei senei mbeɨ quia ee. “Mbia rerecuarã tuchɨ ra Dios cote”, jenye oso secheẽ nenei nenei judíos je. ");
INSERT INTO srqNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mbia ɨre rasi jembucherõ cherõ nguia. Mbia rasi chumumbara jembucherõ cherõ nguia. Mbia raaque abe jembuquera quera quia. Aba checuayã ɨcuã abe jẽjea jea quia mbia sɨ. Sequirãcuã ngue amee ñooño jẽje. “Mbae mo jemee na seje erɨbɨshorõ”, ae eã tuchɨ se quia jẽje co. Nyebe jẽ abe mbae turã jẽsaã ñooño mbia je. “Mbae embu se”, ɨã mbia je. ");
INSERT INTO srqNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mbae mo nda jendaochɨ̃ ɨcua jẽso mose. Mbae isiquia mo nda jendaochɨ̃ ɨcua. Mbae isiquia ñete mo nda jendaochɨ̃ ɨcua. ");
INSERT INTO srqNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mbae riru mo abe ra jendaochɨ̃ no. Jẽɨrao nongue abe ra jendaochɨ̃ no. Jẽiyao nongue abe ra jendaochɨ̃ no. Jenyɨtochoquia abe ra jendaochɨ̃. Ae je ra mbae turã jẽsaã saã nae, sã ũquɨ̃ ae riqui jembuquiaru quiaru turã mingo. ");
INSERT INTO srqNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Jengasẽ mose sucha tubɨrɨã mo, mbia turã mo jẽtea huee. Aque chuchua mɨɨ ño jẽɨngo uque. Tuchua ra jembuchesea seate chɨ̃ jẽɨngo mose huee. Ae ra jengue nyii nae, hue tuchua beɨ chõ jẽɨngo uque. ");
INSERT INTO srqNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jẽɨque mose emo nyuchúaa, hue jenda je jeñee turã no. Saludar jenye turã ee no. ");
INSERT INTO srqNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Hue jenda siqui turã mose, Dios quirãcuã jemee ee. Siqui turã eã mose, Dios quirãcuã jẽisibe esɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hue jenda jẽisi sereã nea mose, jẽhuɨ chõ esɨ. Hue jenda jeñee andu sereã mose, jẽso chõ hue sɨ. Jẽi tubi jembutomo tomo ee. ");
INSERT INTO srqNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tacheẽ nyecua jẽje. Ae ra jeñee isi sereã nae, ũquɨ̃ nda Dios mbasi tuchɨ. Uquiatoã nda embasi ja aque mose. Sodoma jenda ra Dios mbasi raque. Gomorra jenda abe no. Ae jeñee isi sereã nae, ũquɨ̃ nguia ra embasi tuchɨ Sodoma jenda sɨ. Gomorra jenda abe sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","A aɨco jemondo secheẽ nenei nenei sacuã mbia je a. Sã nyacua ɨcuãte riqui oveja je no. Eɨ̃ sɨ ra mbia ɨcuã ɨcuãte jẽje. Oveja seteã na ño jẽɨngo. ¡Jẽaracua chõ nguia jẽ! Sã mbeɨ aracuate riqui no. Mbae ɨcuã mo nda jẽsaãchɨ̃ jẽ. Sã nyurushɨ riqui mbae ɨcuã naa eã mbeɨte no. ");
INSERT INTO srqNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","¡Sã jẽ! Mbia ɨcuã ɨcuãte ra jẽje. Jembɨɨrɨ̃ ɨrɨ̃ ndae. Jemee mee ɨcuã nda mbia rerecua je. Jẽɨruã nua nda mbia chumunuásaa. ");
INSERT INTO srqNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mbia ɨcuã ɨcuãte ra jẽje serɨɨ̃. Mbia rerecua je ra jenderao ɨcuã. Eɨ̃ jenye mbia rerecua mbiirandu randu serɨɨ̃. Judíos eã abe mbiirandu randu serɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jemee mose mbia rerecua je, pare pare jenyechɨ̃ nda jẽ. “¿Manyae ra ũquɨ̃ ñee ndɨbɨshorõ nde?” jenyechɨ̃ nda pare pare ɨ jẽ. Dios ae chõ nda jembucheẽ turã nuiã nguiã mbia je aque mose. ");
INSERT INTO srqNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Jẽ ae ra jeñee eã. Espíritu Turã ae nda jembucheẽ nguiã mbia je. ");
INSERT INTO srqNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Jenongue ra jemondo chee mbia ɨcuã je. Jẽɨquia sacuã. Jendu abe ra jemondo chee mbia ɨcuã je. Jendiirĩ abe ra jemondo chee mbia ɨcuã je. Mbia ɨcuã nda jemo ɨquia ɨquia chee. ");
INSERT INTO srqNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mbia ra jẽucuayã jate serɨɨ̃. Ae ra siqui beɨ serese, ũquɨ̃ nda Dios mingo beɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mbia ɨcuã ɨcuã mose jẽje sucha moo, jẽso chõ sucha tubɨrɨã nónguee. Tacheẽ nyecua jẽje. Achu jeɨbe ra se. Sucha Israel jenda jembuchesea sea ja eã mose chõ nda achu jeɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Jengasu ra jẽsaã saãchɨ̃ sesɨ jẽ. Se chõ jembaaquiatusa re. Embaaquiatusa quia ecuasu jiri echɨmbaaquiatu sɨ re. Ererecua quia ecuasu jiri erimba sɨ re. ");
INSERT INTO srqNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Coche jẽɨngo nguiã se rã sɨ. Sã mbia ɨcuã ɨcuãte riqui seje no. Eɨ̃ sɨ ra eɨcuã ɨcuã jẽje no. Sã mbia “Satanás” ɨ ñee ɨcuã seje no. Eɨ̃ sɨ ra ñee ɨcuã ɨcuã jẽje no. Serimba je no. ");
INSERT INTO srqNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jẽsiquiche quichechɨ̃ nda ñee ɨcuã ɨcuã je sɨ jẽ. Ae mbia saã nyecuayã cuayã nguia nae, ũquɨ̃ nda nyecua ja cote. Ũquɨ̃ nda mbia ɨcua ja cote. ");
INSERT INTO srqNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ae rɨɨ̃ aɨco ñee nyecuayã cuayã jẽje nae, ũquɨ̃ jẽsenei senei turã mbuchecua mbia je cote. Ae asenei senei nguia jẽísaa nae, ũquɨ̃ jẽsenei senei turã mbuchecua mbia je cote. ");
INSERT INTO srqNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ae “taɨquia” ɨ quia jenɨɨ nae, ¡ũquɨ̃ sɨ ra jẽsiquichechɨ̃ jẽ! Ae aba mombo serɨ̃te quia tata cuasu nae, aque sɨ quiatu jẽsiquiche. Aque sɨ quiatu jẽsiquiche tuchɨ jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Aba queteamba eã jiri raque nguireɨ̃. Mbae isiquia mumba eãte raque nguireɨ̃. Dios quia ra tesareɨã nguireɨ̃ mo sɨ. Nguireɨ̃ mo ngoɨ mose íbii, Dios riqui eɨcua jate ã. ");
INSERT INTO srqNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dios riqui jẽ mɨɨ mɨɨ ɨcua jate co. Jẽa mɨɨ mɨɨ abe eɨcua jate quia co. ");
INSERT INTO srqNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jẽsiquichechɨ̃ nda jẽ. Dios quiatu queteã tuchɨ nguiã jendese nguireɨ̃ mo sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Jesucristo quiato chõ se re”, ae ɨ quia mbia je nae, ũquɨ̃ nɨɨ nda acheẽ turã se abe. “Sequiato chõ ã nde”, ae ra Paba Ibatenda je. ");
INSERT INTO srqNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","“Jesucristo quiato chõ se re”, ae ɨ ãte quia mbia je nae, ũquɨ̃ nɨɨ nda acheẽ turã eã se abe. “Sequiato eã ño ũquɨ̃ nde”, ae ra Paba Ibatenda je. ");
INSERT INTO srqNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","¿Achu reɨ̃ mbia mbuturã turã sacuã serimba je jẽje re? Tei. Achu chõ ngue mbia mbuchao chao nyesɨ resẽ. Mbia ɨcuã ɨcuã nda uchue serɨɨ̃. Emo emo nda siqui seruɨ. Emo emo nda siqui ɨcuã ɨcuãte ee. ");
INSERT INTO srqNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Emo nda eɨcuãte ngu je serɨɨ̃. Cuña mo nda eɨcuãte usi je no. Acuanɨ mo nda eɨcuãte uchari je serɨɨ̃ no. ");
INSERT INTO srqNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tuchua jenda ra nyao nyao nyesɨ. Emo nda siqui serese serimbarã. Eataque ra nyao nyao esɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ae nyesecua tuchɨ quia ngu rese sesɨ nae, ũquɨ̃ nda serimbarã eã. Ae nyesecua tuchɨ quia usi rese sesɨ nae, ũquɨ̃ nda serimbarã eã no. Ae nyesecua tuchɨ quia nguiirĩ ndese sesɨ nae, ũquɨ̃ abe ra serimbarã eã no. ");
INSERT INTO srqNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ae ra siquíã seruɨ, ũquɨ̃ nda serimbarã eã. Ãe mano sereãte serɨɨ̃, ũquɨ̃ nda serimbarã eã. ");
INSERT INTO srqNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sã mbia nduate quia serese. Ae nduate quia nyɨese nae, ũquɨ̃ nda nyoɨ eãte ibate. Ae ndua eãte quia nyɨese nae, ũquɨ̃ nguia ra nyoɨ ibate. ");
INSERT INTO srqNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ae ra eturã ndiqui jẽje nae, seje abe chõ nda eturã ndiqui. Ae eturã ndiqui seje nae, semondosa je abe chõ eturã ndiqui nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ae eturã ndiqui Dios cheẽ mbuchecuasa je nae, Dios ra mbae turã mondo ee. Sã mbae turã mee ucheẽ mbuchecuasa je no. Ae eturã ndiqui echɨã mbuquishĩ ji je nae, ũquɨ̃ je abe ra Dios mbae turã mondo no. ");
INSERT INTO srqNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tacheẽ nyecua jẽje. Emo sechɨmbaaquiatu ɨseɨ mbiu turã mose serɨɨ̃, mbae turã abe ra Dios mondo aque je no, ɨ que Jesús ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús que huɨ ñee uchɨmbaaquiatu doce je cote ra. Aquere que esɨ Dios cheẽ nenei nenei hue rurubinda je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan ngue chɨ̃ cárcel nda. Hue eñɨ mose que jirandu Cristo chɨsaã ndese ra. Uchɨmbaaquiatu nyeremo ngue emondo Jesús rea ra. Ñee sacuã ee. ");
INSERT INTO srqNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—Jẽso ñee Jesús je. “‘Cristo ra tu’, ɨ beɨte equia ã nae, ¿ae nde re? ¿Cristo ra uresaarõ arõ mbeɨ quia re?” jenye oso Jesús je, ɨ que Juan uchɨmbaaquiatu mondo erea ra. ");
INSERT INTO srqNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús que ñee Juan nimba je ra. —Ae rese jemae nae, ũquɨ̃ jẽsenei oso Juan je. Ae jeñandu nae, ũquɨ̃ abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Eɨ̃ jenye chõ ñee Juan je: “Jesús que eresayã mbucherõ nyerõ nguia ra. Ecuatayã abe mbucuat a cuata. Eɨre rasi abe mbucherõ nyerõ. Eraaque abe mbuquera quera. Ucheẽ turã ngue esenei senei tuchɨ quia mbaecha reã je ra”, jenye oso Juan mbiirandu. ");
INSERT INTO srqNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Emo huɨ eã mbeɨ mose sesɨ, aque ia tuchɨ ra siqui cote, ɨ que Jesús ucheẽ mondo Juan je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juan ñɨmondo que nyebi nyoɨ Juan ndea cote ra. Jesús que ñee mbia ja je Juan nɨɨ cote ra. —¿Mbae rese mae jẽso turúquiaa re? ¿Quɨrɨrɨã idioi ɨchu ɨchu rese chõ jẽso mae nde? Quɨrɨrɨã ndese mae eã ngue jẽso resẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Emo ɨrao turã ndese jẽso mae nde? Ũquɨ̃ ndese eã ngue jẽso mae ndesẽ. Eɨrao turã siquíã nguiã turuquia ñɨ. Ae siqui quia mbia rerecua chuchua nae, ũquɨ̃ nguia eɨrao turã ndiqui nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Juan ndese mae ño ngue jẽso turúquiaa resẽ. Dios cheẽ nenei neneisa tuchɨ chõ ae mbia mo sɨ re. Ae chõ mbia mingoquiatu quiatu nguiã se ñee sacuã mbia je. ");
INSERT INTO srqNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sã embesa ji riqui ñee no: Secheẽ nderaosa tamondo ndenonde. Ae ra mbia mingoquiatu ndeje, nde ñee sacuã ee, ɨ que embesa ji ñee nda. Juan nɨɨ ño embesa ji riqui nguiã ñee. Nyebe Juan ndu nguiã senonde. ");
INSERT INTO srqNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tacheẽ nyecua jẽje. Juan el Bautista quiarei ɨ tuchɨ raque mbia ñiinda ja sɨ. Ae ra siqui tuchɨ Dios rese erimbarã cote nae, ũquɨ̃ nguia ra ɨ tuchɨ Juan sɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan Dios cheẽ nenei nenei namo mosenda beɨ chõ mbia riqui nguiã ngaẽ ngaẽ Dios cheẽ andu ã. Mbia bite Dios siqui mose mbia rerecuarã. ");
INSERT INTO srqNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan tu nonde chõ embesa ji riqui nguiã ñee j a serɨɨ̃. “Dios rucucha ra tu emo mose”, ɨ serɨɨ̃. Sechu eã mose. Juan nane ngue “co eru quia co” ɨ ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Sã embesa ji riqui ñee nyii no. “Elías raanguia ra tu mbae mbuquiche ja Cristo tu nonde”, sã ɨ embesa ji no. Juan nɨɨ ño eriqui nguiã ñee. ");
INSERT INTO srqNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jẽisa mose, ¡secheẽ jeñandu turã na! ");
INSERT INTO srqNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mbia namonda siqui turã eãte quia aba cheẽ nduɨ ã. Mbia riirĩ na ño eriqui nguiã ã. Sã mbia riirĩ ndiqui ñumbusareɨ sareɨ no. ");
INSERT INTO srqNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Sã eriqui ñee ñee nyue no. “Flauta que ambucheẽ ñee ndei jẽje ra. ¿Mbaerã jenyuruqui sereã nea nde?” sã ɨ chõ nyue no. “Mbae aba mbia eã ngue ambucheẽ ñee ndei jẽje resẽ. ¿Mbaerã jẽyate erese re?” sã ɨ chõ mbia riirĩ nyue no. Ũquɨ̃ na sɨ chõ mbia riqui nguiã aba cheẽ mumba ã. ");
INSERT INTO srqNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan el Bautista que tu rei mbia je ra. Mbia que eisi turã ẽ a nda. “Co eriqui quiaru sereãte nanderese co. Co eriqui mbae mbei sereãte nanderese co”, ɨ chõ mbia quia ee ã. “Aba checuayã ndesenda”, ɨ chõchɨ̃ equia ee ã. ");
INSERT INTO srqNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aquere que achu se abe ra. Aquiaru rei nguiã jendese co. Mbae abe ambei rei nguiã jendese co. Se abe que seisi turãyã nda. “Quiaru tuchɨ je”, ɨ chõchɨ̃ seje. “Mbae mbeisa”, ɨ abe que seje no nda. “Mbia ɨcuã quiato chõ ñene”, ɨ chõ ngue seje no nda. Ae earacuate nae, Dios aracua abe ra eɨcua. ");
INSERT INTO srqNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ae mbia je Jesús uquirãcuã ndeacuquia cuquia tuchɨ nae, ũquɨ̃ ngue Jesús isi eã mbeɨ ra. Nyebe Jesús riqui nguiã ñee asi asi mbia hue jenda je. ");
INSERT INTO srqNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Seya eãte jendese, Corazín jenda. Seya eãte jendese, Betsaida jenda. Jendasi tuchɨ rae. Mbia mae sayã ngue asaã saã jẽje nae, ũquɨ̃ naa mose Sidón jenda je, eɨ̃ nda Sidón jenda huɨɨcuã secha rei. Eɨ̃ nda Tiro jenda abe huɨɨcuã secha rei. Eɨ̃ nda eya eãte rei huɨɨcuã ndese. ");
INSERT INTO srqNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jẽ nguia jẽɨcuã jẽsecha sereãte rei. Nyebe ra Dios jembasi mbasi tuchɨ ũquɨ̃ sɨ quiatu. Dios mbia ɨcuã mbasi mbasi mose. ");
INSERT INTO srqNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jẽcuasu jẽsaã saã tuchɨ techɨ̃ nguia re, Capernaum jenda. Nyebe ra Dios jemondo tuchɨ tata cuasu. Mbia mae sayã ngue asaã saã jẽje nae, ũquɨ̃ naa mose Sodoma jenda je, eɨ̃ nda Sodoma jenda huɨɨcuã secha rei. Eɨ̃ nda Dios hue sucha cuasu mbutiã eã ndei. ");
INSERT INTO srqNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jẽ nguia jẽɨcuã jẽsecha sereãte rei. Nyebe ra Dios jembasi mbasi tuchɨ Sodoma jenda sɨ. Dios mbia ɨcuã mbasi mbasi mose, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesús que ñee Dios je cote ra. —Seyate aɨco nderese co, Paba. Ibi jenda rerecua ja chõ nde re. Ibei jenda abe rerecua ja chõ nde no nde. Ndecheẽ ngue erembuchecu a eã mbia aquiatu je ra. Mbia riirĩ naanguia je chõ ngue ndecheẽ erembuchecua nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ũquɨ̃ ño ngue eturã ndeje ra, Paba, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","—Seru que mbae mondo ja seje ra. Paba mɨɨ ño seɨcua tuchɨ nguiã. Paba riirĩ mɨɨ tuchɨ chõ se re. Se mɨɨ ño Paba aɨcua tuchɨ nguiã no. Ae je ra Paba ateacuquia nae, ũquɨ̃ mɨɨ ño nda Paba ɨcua tuchɨ nguiã serese. ");
INSERT INTO srqNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jenguenea mose, jenyu chõ seje. Jenguenea tamboseɨ̃ na jẽsɨ. Taembia mingo. ");
INSERT INTO srqNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Seseteã ño aɨco nguiã se. Aɨco mingue chõ nguiã se co. Jeñimbaaquiatu jiri serɨɨ̃. Jeñimbucha chõ serese. Eɨ̃ jenye mose ra jeñɨa pare pare ɨ eã cote. Jẽya beɨ ra jẽɨngo cote. ");
INSERT INTO srqNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ae siqui serimbarã nae, ũquɨ̃ iate riqui ã. Secheẽ mbaranguiatuã eãte aba je, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sábado mose que Jesús sɨ quia mbiaco ite ite rɨ̃ emo mose ra. Echɨmbaaquiatu riãcuãte que eriqui ra. Nyebe que quiata a ucua mɨɨ mɨɨ nyoɨ quia ecuã mose ra. Equiti quitire oo je que echoɨ quia eachãaña cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseos mo ngue ñee ee ra. —¿Mbaerã ndechɨmbaaquiatu riqui mbae ɨshao shao sábado mose re? Co mose chõ mbia riqui uquenea ucua resẽ, ɨ que fariseos ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús que ñee ee ra. —¿Embesa ji rese jemae eã David rɨɨ̃ nyii re? David riãcuãte que aque mose ra. Eresenda abe riãcuãte que eriqui aque mose no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David que ɨque Dios chuchúaa aque mose ra. Mbichae Dios chuchua jenda que eu ra. Mee mee ngue nguesenda abe je ra. Eriãcuãte quiatu ngue re. Sacerdote achõ mbaerã ndaque mbichae. ");
INSERT INTO srqNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Moisés chɨmbesa rese jemae ãte sacerdote rɨɨ̃ nde? Sábado mose que quieɨ quieɨ rei Dios chuchua ra. “Dios cheẽ mumbasa”, ɨ ãte quia mbia nguiã ñee ee. ");
INSERT INTO srqNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tacheẽ nyecua jẽje. Secheẽ nguia ɨ tuchɨ jiri nguiã Dios chuchua sɨ co. ");
INSERT INTO srqNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Co embesa ji jẽɨcuayãte quia ã. “Sebite jẽya eã jẽɨngo mose mbia rese. Sebiãte ofrenda jemee ñooño mose”, ɨ Dios quia co. Jẽɨngo ũquɨ̃ ɨcuayãte ã. Eɨ̃ nda jeñee ɨcuã eãte rei mbia turã je. ");
INSERT INTO srqNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sábado rerecua beɨ chõ se re, ɨ que Jesús ñee fariseos je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús que oso mbia chumunuásaa cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Huee que eo tomei mo ndiqui ee ra. Mbia que Jesús mbucheẽ ɨcuã sete ra. Nyebe ñee nguiã ee. —¿Eɨcuãte erasi mbucherõ sábado mose re? ¿Ɨ ere? Echeẽ ure je jẽ, ɨ que mbia ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús que ñee ee ra. —Sã jenimba oveja mo ndiqui jaã no. Ngoɨ oso ibicua mo ye no. ¿Sábado mose ra jenosẽ ibicua sɨ re? Ae. Jenosẽ jeɨ rae. Sábado mose raque. ");
INSERT INTO srqNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Dios queteamba tuchɨ chõ mbia riqui nguiã oveja sɨ ã. Coche nandeɨco nguiã mbae turã naa naa sábado mose, ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ñee ngue eo tomei je cote ra. —Ndeo emee secuti, ɨ que ee ra. O que emee Jesús cheẽ mose ra. Aque mosechɨ que eo nyerõ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nyebe fariseos paama ɨ nguiã Jesús je. Mbia mbucherõ mose sábado mose. —¿Mañɨ nande ra Jesús je re? Nandeɨquia rei ra reae, ɨ tuchɨ que eu ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús que jirandu ũquɨ̃ ñee ndese ra. Nyebe esɨ nguiã hue sɨ. Mbia tubɨrɨã ngue nyoɨ eruɨ ra. Jesús que mbia rasi mbucherõ cherõ ja quia ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","—¡Mbia ra jembiiranduchɨ̃ serese jẽ! ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aque mose que Isaías chɨmbesa ɨque cote ra. Eɨ̃ ngue Isaias embesa mɨɨ Jesús rɨɨ̃ nda: ");
INSERT INTO srqNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Serimba chõ co re. Co que airabo ra. Sechesecua chõ ae re. Seyate aɨco erese co. Espíritu Turã tamondo tuchɨ ee. Ae ra secheẽ turã senei senei ja mbia je. ");
INSERT INTO srqNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eɨcuã ɨcuã eã nda emo je. Ñee ɨcuã eã ndae. Ucuasu ra esaã saã eã mbia je. ");
INSERT INTO srqNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Siqui turãte ra equia equirãcuã nea je. Siqui turãte ra equia eaquiatuã je no. Mbia ra siqui turã nyee eruɨ ererecuarã. ");
INSERT INTO srqNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mbia ja ra ndua turã mbeɨ erese cote, ɨ que Isaías embesa cose ra. Ũquɨ̃ ngue ɨque cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mbia que eresayã mo curucuaẽ Jesús je ra. Echeẽ aquiatuãte abe que ra. Aba checuayã ɨcuã nguiatu ngue siqui nguiã echɨangui re. Jesús que embucherõ nda. Nyebe mae turã nguiã cote. Ñee turã abe cote no. ");
INSERT INTO srqNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mbia que nyuruɨra ja mae erese ra. —David rucucha chõ Jesús riqui re, ɨ chõ ngue mbia quia ndua ndua ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseos que echandu ja ra. Nyebe ñee ɨcuã ɨcuã nguiã Jesús je. —Ab a checuayã ɨcuã nderecua tuchɨ chõ Satanás nde. Satanás quirãcuã je chõ Jesús riqui nguiã aba checuayã ɨcuã jea jea mbia sɨ co, ɨ rei que fariseos ñee ɨcuã Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús que ũquɨ̃ ndua ndua ɨcuate ra. Nyebe ñee nguiã ee. —Gobierno ɨcuã ɨcuã mose nyue, ua rae. Tuchuamo jenda ɨcuã ɨcuã mose nyue, ua ra eno. ");
INSERT INTO srqNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","¿Mañɨ nda Satanás aba checuayã jea mbia sɨ re? Erimba chõ nyeresẽ. Satanás ɨcuã ɨcuã mose nyue, equirãcuã nda ua no. ");
INSERT INTO srqNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Satanás quirãcuã je chõ Jesús riqui nguiã aba checuayã jea jea mbia sɨ”, jenye chõchɨ̃ nguia seje ã. ¿Aba uquirãcuã mee jenimba je jẽ nde? Aba checuayã ɨcuã jea nonde re. ¿Satanás uquirãcuã mee jenimba je serese re? ");
INSERT INTO srqNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dios quirãcuã je quiatu aɨco nguiã aba checuayã jea jea mbia sɨ co. “Dios quirãcuã ndese chõ ureɨco nguiã mae”, jenye eã ñochɨ̃ equia ã. ");
INSERT INTO srqNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Satanás quirãcuã tuchɨte raque. Umbae rese ngueteãte raque. “Sembae chɨ turãte a”, ɨ raque. Dios quiarei equirãcuã tuchɨ Satanás sɨ. Dios Satanás mbae sirõ ja arõte quia esɨ co. Dios Satanás mbae mbutiã ja arõte quia co. ");
INSERT INTO srqNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ae siqui ãte quia serese nae, eɨcuã ño ũquɨ̃ ndiqui nguiã seje. Ae secheẽ senei senei eãte quia mbia je nae, ũquɨ̃ ɨcuã ño eriqui nguiã seje. ");
INSERT INTO srqNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tacheẽ nyecua jẽje. Emo siqui ɨcuã mose, Dios eɨcuã mbutiã arõte esɨ. Emo ñee ɨcuã mose, Dios echeẽ ɨcuã mbutiã arõte no. Emo ñee ɨcuã mose Espíritu Turã nɨɨ, ũquɨ̃ ɨcuã nguiatu ra Dios mbutiã eã mbeɨ esɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Emo ñee ɨcuã mose serɨɨ̃, Dios echeẽ ɨcuã mbutiã arõte. Emo ñee ɨcuã mose Espíritu Turã nɨɨ, ũquɨ̃ ɨcuã nguia ra Dios mbutiã eã mbeɨ. Mbae ua ja mose chee ra Dios ũquɨ̃ ñee ɨcuã mbutiã eã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ira turã mose, ea abe ra eturã no. Ira ɨcuã mose, ea abe ra eɨcuã no. Mbia ira ɨcua mose, ea abe ra eɨcua. Nyiabiã ndae. Sã ira ae ea ae ae no. ");
INSERT INTO srqNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mbeɨ rã ño jẽɨngo nguiã. Jẽɨcuã ño jẽɨngo nguiã. Nyebe jeñee turã aquiatu ãte riqui ã. Ae rese mbia riqui ndua ndua uchɨangui re nae, ũquɨ̃ nɨɨ sɨ́ ra ñee. ");
INSERT INTO srqNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mbia turã nda ñee turã. Echɨangui renda quia eturãte re. Nyebe eriqui nguiã ñee turã. Mbia ɨcuã nguia ñee ɨcuã nguiã. Echɨangui renda quia eɨcuãte riqui nguiã. Nyebe eriqui nguiã ñee ɨcuã. ");
INSERT INTO srqNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tacheẽ nyecua jẽje. Emo ñee ñooño mose, Dios ra ñee asite aque je. Dios mbia ɨcuã ndea rea mose. ");
INSERT INTO srqNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Emo ñee turã mose, echɨangui renda turã ño ñene. Nyebe ra Dios ñee asiã ee. Emo ñee ñooño mose, echɨangui renda ɨcuã ño ñene. Nyebe ra Dios ñee asi ũquɨ̃ je, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Fariseos mo ngue ngaẽ Jesús rea ra. Embesasa abe que ngaẽ erea ra. Ñee ngue ee ra. —Mbia mae sayã esaã na ure je, ɨ rei que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús que ñee ee ra. —Jẽɨcuãte riqui co mosenda jẽ ja ã. “Mbia mae sayã esaã ure je”, jenye beɨte equia ã. Mbia mae sayã mɨɨ ño nda asaã jẽje. Jonás na sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sã Jonás ndiqui raque tres días sɨra rie ye no nae. Jonás na sɨ́ ra asaã mbia je. Tres días ra aɨco ibicua rie. ");
INSERT INTO srqNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive jenda quia eturã jiri co mosenda sɨ re. Dios ra co mosenda mbasi tuchɨ Nínive jenda sɨ. Sã Nínive jenda huɨɨcuã ndecha Jonás ñee mose ee no. Aɨco raque ñee jẽje co mosenda je co. Jẽ secheẽ jemumbate chõ chɨ̃ nguia ã. Se quia raque ererecua tuchɨ Jonás sɨ. Nyebe ra Dios jembasi tuchɨ mbia ɨcuã ndea rea mose. ");
INSERT INTO srqNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","La reina de Seba quia eturã jiri mbia co mosenda sɨ re. Dios ra co mosenda mbasi tuchɨ la reina de Seba sɨ. Sã la reina de Seba tu ɨsho sɨ tuchɨ Salomón ñee andu no. Se quia acheẽ ndaque quia jẽje. Searacua tuchɨ raque se quiatu Salomón sɨ. Secheẽ jemumbate chõchɨ̃ nguia ã. Nyebe ra Dios jembasi tuchɨ mbia ɨcuã ndea rea mose. ");
INSERT INTO srqNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Aba checuayã ɨcuã usẽ mose emo ñɨa sɨ, ngata beɨ chõ nguiã. “¿Mangue ra sequenea aucua que re?” ɨ chõ nguiã. Uquenea ucua sacuã mo etea eãte. ");
INSERT INTO srqNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Tasobe rei nyebi. Ae sɨ achu usẽ, aque chɨã ye sɨ́ taso”, ɨ que aba checuayã nda. Nyebi sɨ mose u, mbia chɨã oreãte que ee ra. Echɨã ndecoteã eãte que ee ra. Tuchua tii ji raãte que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aba checuayã ɨcuã ngue nguesenda siete queru cote ra. Ɨque ja que echoɨ aque chɨangui re cote ra. Ae chɨangui re aba checuayã ɨcuã siete riqui nae, aque ɨcuã ɨ ɨ tuchɨ que eriqui cote ra. Aba checuayã mɨɨ ngue siqui eye nyii ra. Etubɨrɨãte cote. Aque ɨcuã tuchɨ cote nyii sɨ, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús ñee mbeɨ mose que esi ngaẽ ndei ee huee ra. Jesús nongue ja rese. Chɨchõ ja chõ ngue taicuee ra. Ñee serete que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","—Hue ndesi riqui nderequia taicuee huee. Ndenongue rese, ɨ que emo Jesús mbiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesús que ñee umbiirandusa je ra. —¿Aba je chõ aɨco “taĩ” ɨ chã? ¿Aba je chõ aɨco “senongue” ɨ no ña? ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jesús que o mee uchɨmbaaquiatu cuti ra. —Ã je chõ aɨco nguiã “taĩ” ɨ. Ã je chõ aɨco nguiã “senongue” ɨ no. ");
INSERT INTO srqNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ae Paba Ibatenda cheẽ mumbayã nguia nae, ũquɨ̃ je chõ aɨco nguiã “senongue” ɨ. Ũquɨ̃ je chõ aɨco nguiã “taĩ” ɨ no, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Aque mose sɨ́ que Jesús sɨ usẽ tuchua sɨ ra. Tuchua sɨ que esɨ ngoi ama ndɨsh a nimíaa nda. ");
INSERT INTO srqNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mbia que ngaẽ ngaẽ ja quia Jesús rea ra. Nyebe Jesús ua oso nguiã ngoi canoa ye. Mbia quiatu que chɨchõ ama nimíaa ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesús que embaaquiatu quiatu tuchɨ quia ra. Ejemplos que esaã saã tuchɨ ee ra. —Sã emo sɨ rei mbae eɨ̃ mombiquia mbiquia no. ");
INSERT INTO srqNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sã emo ndiqui uqui uqui ñeenda ruɨ no. Sã nguireĩ ndiqui ngaẽ eu no. ");
INSERT INTO srqNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sã emo emo ndiqui uqui sɨta arõ no. Sɨta aronda suri jeɨ raque. Ibi ererate quia ñene. ");
INSERT INTO srqNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tenda ibate mose que eriqui ñɨmama mano nda. Erao eãte quia ñene. Nyebe mano jeɨ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Sã emo ndiqui uqui uqui nyu réndaa no. Sã nyu abe riqui suri erese no. Nyu ruri que echati asi u eriquisã nda. ");
INSERT INTO srqNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Sã emo ndiqui uqui uqui ibi túraã no. Ũquɨ̃ nguiatu que ɨa turã nda. Sã emo ɨa cien no. Sã emo ɨa sesenta no. Sã emo ɨa treinta no. ");
INSERT INTO srqNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jẽisa mose, ¡secheẽ jeñandu turã na! ");
INSERT INTO srqNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesús chɨmbaaquiatu que ñee nyecuayã Jesús ísaa ra. —¿Mbaerã ejemplos achõ eresenei senei mbia je re? ɨ que echɨmbaaquiatu ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús que ñee ee ra. —Mbia rerecua tuchɨ quiarei Ibatenda. Ae riqui nguiã ucheẽ mbiasa asa ja jẽje co. Mbia ataque quia siqui sereã erese co. Mbia ataque je quia eriqui nguiã ucheẽ mbiasa eã jiri. ");
INSERT INTO srqNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Emo umbae rerequia mose, Dios ra emo mondobe ee. Emo embae eã mose, Dios ra embae sirõ ja esɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nyebe aɨco nguiã ejemplos achõ nenei nenei mbia je co. Eanduchõ sacuã. Eɨcua turã ndocoɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mbia eanduchõ mose que Isaías chɨmbesa ɨque cote ra: Mbia ra secheẽ ñandu raque. Ɨcuayã nguiatu rae. ");
INSERT INTO srqNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Eãquĩ ãtãte riqui ã. Secheẽ andu sereãte equia ã. Mae sereãte equia sechɨao rese ã. Ndua eã mbeɨ equia serese ã. Nyebe ra ambitirõ eã mbeɨ, ɨ que Dios cheẽ Isaías chɨmbesa rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jẽ nguiatu Dios cheẽ jeñandu turãte nguiã ã. Jẽ nguiatu jemae serete nguiã Dios chɨao rese ã. Nyebe jẽyate jẽɨngo nguiã ã. ");
INSERT INTO srqNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tacheẽ nyecua jẽje. Ae jeñandu quia secheẽ ã nae, Dios cheẽ mbuchecuasa ñiinda ã ñandu serete raque. Mbia turã ñiinda abe ã andu serete raque. Ñandu eã mbeɨte equia ã. Jẽ ae chõ jẽɨngo nguiã eandu ã cote. Jẽ ae je chõ echecua riqui nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Secheẽ tambiasa jẽje cote. Mbae eɨ̃ mombiquia mbiquia ji rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ae uqui uqui ñeenda rui nae, Dios cheẽ andu chooñosa rã ño ũquɨ̃ nde. Ɨcua eãte quia ñene. Nyebe diablo ru nguiã Dios cheẽ ndirõ echɨangui sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ae uqui uqui sɨta arõ nae, mbia mo na ño ũquɨ̃ no nde. Dios cheẽ andu mose, isi turã ndaque. Eyate raque erese. ");
INSERT INTO srqNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mbia ɨcuã ɨcuã mose ee Dios cheẽ nɨɨ, huɨ jeɨ chõ nguiã esɨ. Mbae rao eã naanguia chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ae uqui uqui nyu réndaa nae, mbia mo na ño ũquɨ̃ no nde. Dios cheẽ andu turã ndaque. Siqui beɨ eã ño nguiã eruɨ. Umbaerã achõ ndese chõ eriquichɨ̃ nguiã ndua. “Mbaecha tuchɨte ra se”, ɨ beɨ chõ nguiã ndua ndua. Nyebe huɨ chõ nguiã Dios cheẽ sɨ. Nyebe Dios cheẽ ndiqui nguiã ɨa eã mbeɨte ee. ");
INSERT INTO srqNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ae uqui uqui ibi túraã nae, mbia mo na ño ũquɨ̃ no nde. Ũquɨ̃ nguiatu Dios cheẽ ñandu turã nguiã. Ɨcua ɨcua turã ño nguiã. Nyebe eriqui beɨ nguiã erese. Ɨa ɨa beɨ raanguia cote. Emo emo ɨa cien. Emo ia sesenta no. Emo ɨa treinta no, ɨ que Jesús ucheẽ mbiasa ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús que ejemplo nongue senei ee ra. —Sã emo trigo eɨ̃ mombiquia mbiquia úcoo no. Ũquɨ̃ na ño Dios rimba riqui nguiã ã. ");
INSERT INTO srqNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sã trigo eɨ̃ mombiquiasa uque cote no. Sã emo tu nyu eɨ̃ mombiquia mbiquia trigo eɨ̃ mumbara mbara no. ");
INSERT INTO srqNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo eɨ̃ ngue obo cote ra. Nyu abe que suri erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nyebe erimba ñee nguiã echa je. “Trigo eɨ̃ achõ eremombiquia mbiquia reɨ̃ nguiã seje. ¿Mbaerã nyu abe riqui suri suri erese re?” ɨ que ererecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ererecua que ñee ee ra. “Seucuãyãsa chõ ũquɨ̃ nde. Nyu eɨ̃ mombiquia mbiquia chõchɨ̃ trigo eɨ̃ mumbara mbara”, ɨ que ererecua ñee nda. —¿Ureso ra eriqui riqui re? ɨ rei que erimba ñee nguerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ererecua que ñee nda. “Tei. Nyu riqui riqui mose ra trigo abe riqui riquichɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sã echɨchõ ja. Eucua mose ja chee. Ea ɨreɨ̃ mose quiatu ra acheẽ serimba je cote. Serimba ra nyu rane siqui siqui aque mose cote. Nyu ra esei cote. Aquere quia ra trigo a ɨshao shao erereco quiatu sacuã sechuchua cote”, ɨ que echa ñee nda, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús que ejemplo mo senei mbia je ra. —Mbae eɨ̃ na ño Dios rimba re. Sã mbia mostaza eɨ̃ tiquia no. ");
INSERT INTO srqNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Eñetẽ tuchɨte raque mbae eɨ̃ mo sɨ. Suri oso quia cote. Ecuasu tuchɨte chee cote. Ira rã ño cote re. Nguireɨ̃ nguichi quichi chee erãquiã ndese. Eɨ̃ sɨ chõ Dios rimba re. Ũquɨ̃ mɨɨ ndaque nyii. Ñimbeta tuchɨ cote. Mbae eɨ̃ na, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús que ejemplo mo senei mbia je ra. —Levadura rã ño Dios rimba re. Sã mbia levadura ñetẽ mondo mbichae ao ramo mose no. Sã levadura riqui oso mbichae mbuchɨmatã ja no. Eɨ̃ sɨ chõ Dios rimba re, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Eɨ̃ ño ngue Jesús quia mbia tubɨrɨã mbaaquiatu quiatu ejemplos je ra. Ejemplos achõ ngue esenei senei mbia mbaaquiatu sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nyebe Dios cheẽ mbuchecuasa chɨmbesa ɨque cote. Eɨ̃ ño echɨmbesa re: Ejemplos je mbia tambaaquiatu quiatu. Ae mbia ɨcuayã mbeɨte quia nae, ũquɨ̃ tambuchecua mbia je, ɨ que embesa ji ra, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús que mbia mondo ja cote ra. Aquere que esɨ ɨque tuchu a mo nda. Echɨmbaaquiatu que ecurubite ñee ee ra. —Ae ejemplo eresenei mbia je nyu eɨ̃ nɨɨ nae, ũquɨ̃ embiasa jiri ure je, ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús que ñee ee ra. —Ae trigo eɨ̃ mombiquia mbiquia nae, se rã ño ae re. ");
INSERT INTO srqNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ae íbii emombiquia mbiquia nae, mbia ja rã ño ũquɨ̃ ibi re. Trigo eɨ̃ turã na ño Dios quiato re. Nyu eɨ̃ ɨcuã na ño diablo quiato no nde. ");
INSERT INTO srqNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ae mbae eɨ̃ ɨcuã mombiquia mbiquia nae, aba checuayã nderecua rã ño ũquɨ̃ nde. Mbae a ɨshao shao raanguia ra ibi ua mose cote. Mbae a ɨshao shaosa rã ño angeles re. ");
INSERT INTO srqNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sã mbia riqui nyu mombo mombo tátaa nae, eɨ̃ sɨ ra Dios uquiatoã mombo tátaa ibi ua ja mose no. ");
INSERT INTO srqNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Serimba ángeles ra amondo mbi a rea rea ja. Ae mbae ɨcuã saã uquia quia mbia je nae, serimba ra ũquɨ̃ sirõ ja. ");
INSERT INTO srqNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Serimba ra ũquɨ̃ mombo mondo tata cuásuu. Nyeseo seo tuchɨ ra tátaa. Huee ra ureɨ̃ quiti quiti tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ae Dios mbuturã nae, ũquɨ̃ nininya tuchɨ ra tenda rã sɨ cote. Eru ibatenda siqui mose mbia rerecuarã tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Dios cheẽ nguiirĩ nɨɨ ndei eturã tuchɨ mbae ja sɨ. Eturã tuchɨ tesoro sɨ no. Sã ameɨ mo tesoro ati ji rea íbii no. Tesoro turã tuchɨ que ee ra. Ameɨ ia tuchɨ que erea mose ra. Sã ameɨ vender ɨ ja umbae je no. Aque ibi isi sacuã. Tesoro mɨɨ ndese ndua. ");
INSERT INTO srqNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Dios cheẽ nguiirĩ nɨɨ ndei eturã tuchɨ mbae ja sɨ. Sã comerciante mo perlas turã ndequia requia no. ");
INSERT INTO srqNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Perla turã tuchɨte mo ndea mose, aque mɨɨ ndese chõ eriqui nguiã ndua ndua cote. Sã vender ɨ ja umbae je aque perla rɨbɨshorõ no. ");
INSERT INTO srqNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Sɨra mbua mbua ji rã ño Dios rimba re. Sã emo tarafa mondo ii no. Sɨra chumumbarate que embua ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Sã sɨra mbuasa mbisẽ tuchɨ riqui no. Sã echa econosẽ serao usẽ cote no. Echa que ngoi sɨra turã irabo rabo cote ra. Sɨra ɨcuã ndirirõ ndirõ emombo sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Eɨ̃ sɨ ra Dios mbae ua ja mose. Dios ra ángeles mbu mbia ɨcuã mombo sacuã mbia turã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Eɨcuã nda emombo tata cuásuu. Nyeseo seo tuchɨ ra tátaa. Huee ra ureɨ̃ quiti quiti tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","¿Secheẽ jẽɨcuate rei quia ã nde? ɨ que Jesús ñee mbia je ra. —Ae, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesús que ñee ee ra. —Embesasa mo siqui mose serese, mbaecha rã ño aque re. Sã mbaecha riqui umbae ɨma ndirõ mbia je emo mose no. Umbae yasu abe rirõ emo mose no, ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús que ũquɨ̃ ejemplos senei ja mbia je ra. Hue sɨ que esɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Oso que ngasẽ nguecua Nazaret cote ra. Oso que mbia mbaaquiatu judíos chumunuásaa ra. Nyebe mbia nyuruɨra tuchɨ nguiã ñee nyue. —¿Mangue eriqui ñɨmbaaquiatu tuchɨte re? Nandemae sayã esaã saã tuchɨchɨ̃ nguia re. ");
INSERT INTO srqNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ira mbitirõ tirõsa riirĩ ño ndaque. María abe riirĩ ño ndaque no. Jacobo nongue chõ ndaque. José abe no. Simón abe no. Judas abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ã echari abe riqui ja raque nanderese ã. ¿Mañɨ equia mbae ɨ cua ja tuchɨte re? ɨ que mbia Jesús recu a jenda ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nyebe mbia hue jenda riqui Jesús isiteã nde. Jesús que ñee ee ra. —Dios cheẽ mbuchecuasa ɨshonda cheẽ nguia ra mbia isi turã mbeɨ. Nguecua jenda cheẽ achõ nguia ra eisi turã eã. Ngõngue cheẽ achõ nguia ra eisi turã eã no, ɨ que Jesús ñee nguecua jenda je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hue jenda mbia que Jesús ɨcua eãte ra. Isiteã ño ngue ra. Nyebe Jesús mbia mae sayã naa eã jiri nguiã ee huee. ");
INSERT INTO srqNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mbia que jirandu ja Jesús rese cote ra. Herodes abe que jirandu erese ra. Ererecua que ae ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Juan el Bautista Jesús riqui reɨ̃ ee reaẽ. Ae que ñee ngũimba je Jesús rɨɨ̃ nda. —Sechɨɨquia quera sɨ chõchɨ̃. Juan el Bautista quera sɨ chõchɨ̃. Nyebe eriqui nguiã mbia mae sayã naa naa co, ɨ que Herodes ñee Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herodes que Juan isi ɨcuã nyii ra. Nyucua que mondo tarõ nda. Paama ɨ nda Juan je ra. —¡Nde ndenongue ninisi erereco aroneate jẽ! ɨ quiatu que Juan ñee ee nyii ra. Herodes siqui mose nõngue ninisi rese. Herodías, ɨ que enongue ninisi je ra. Felipe, ɨ que enongue je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","—Juan taɨquia, ɨ rei que Herodes ñee nda. Mbia ataque quiarei siqui tuchɨ Juan ndese. Dios cheẽ mbuchecuasa, ɨ chõ mbia nguiã Juan je. Nyebe Herodes siquiche jiri nguiã Juan ɨquiayã aque mose. ");
INSERT INTO srqNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodes mbae cumpleaños mose, Herodías riirĩ ngue nyuruqui ruqui mbia ja je aque mose ra. Nyucuaaque que ae ra. Herodes ia tuchɨ que mae nyucuaaque nyuruqui rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","—¿Mbae ra amee ndeje re? Echeẽ ño seje. “Sebite co” nde ɨ mose, aque tamondo ndeje. Acheẽ ñooño eã ño nguiã ndeje a, ɨ que Herodes ñee nyucuaaque je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Esi quia ñee ñee nguia nyucuaaque je nyii reaẽ. Nyebe nyucuaaque ñee nguiã Herodes je. —Juan el Bautista ãquĩ emee na seje mbia chɨu riru ye, ɨ que nyucuaaque ñee ererecua Herodes je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ererecua chosoi que oso serɨ̃ tuchɨ echeẽ andu mose ra. —Acheẽchɨ̃ se quia ee. A seresenda chɨ ja quiaru serese a resẽ. Ã seandu ja chõchɨ̃. Nyebe ra secheẽ ambuchebi eã ee, ɨ que ererecua uchɨangui re ra. —Juan ãquĩ emee ee, ɨ que ngũimb a je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","—Juan ãquĩ jendoso oso cárcel. Jemondo nyucuaaque je, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","—Juan ãquĩ ngue ecurucuaẽ mbia chɨu riru ye cote ra. Mee ngue nyucuaaque je cote ra. Nyucuaaque que emee usi je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juan ñɨmbaaquiatu que ngaẽ Juan ndaaque rea ra. Nyati que suruchoɨ ra. Nyoɨ que Jesús mbiirandu erese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús jirandu mose Juan ndese que esɨ turúquiaa ra. Ama nduɨ que esɨ canoa ye ra. Mbia que jirandu randu erese ra. Nyebe nyoɨ ja nguiã eruɨ ibi rɨ̃. Sucha ja ja jenda. ");
INSERT INTO srqNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús que usẽ canoa sɨ cote ra. Mbia tubɨrɨã ndese que mae nda. Eya eã tuchɨte que erese ra. Erasi que embucherõ cherõ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tenda nyeseco mose que echɨmbaaquiatu ñee ndei ee ra. —Mbae ãte a turúquiaa. Tenda abe nyesecote. Mbia emondo rã sucha tubɨrɨã nɨa. Sã echoɨ beɨ uchɨurã isi, ɨ rei que echɨmbaaquiatu ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Sã echoɨ eã. Jeño mbae jemondo ee echɨurã, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Tei. Mbae quia ra aba mondo ee. Cinco chõ ngue mbichae ra. Sɨra abe nyeremoñote nyeresẽ, ɨ que echɨmbaaquiatu ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Jembu rã seje, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ñee ngue mbia tubɨrɨã je cote ra. —Jengoi ja quiata tose, ɨ que ra. Jesús que mbichae cinco sirõ cote ra. Sɨra nyeremo abe no. Mae ngue ibate ra. Gracias, ɨ que ñee Dios je ra. Mbichae que esiquio quio cote ra. Mee ngue uchɨmbaaquiatu je ra. Echɨmbaaquiatu que emee mee mbia ja je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mbia que embuquiaru ja tuchɨ cote ra. Miãtã tuchɨ que ra. Mbia huɨsa tubɨrɨã ngue cote ra. Sɨra rire. Mbichae rire abe no. Doce iru que mbia mombisẽ esique sique je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ae mbichae u sɨra rese nae, etubɨrɨã tuchɨte que ra. Cinco mil ndobeɨ. Cuña abe etubɨrɨã. Mbia riirĩ abe etubɨrɨã no. ");
INSERT INTO srqNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aquere que Jesús uchɨmbaaquiatu mondo ja canoa ye ra. —Jẽ nane jẽso sobeɨ. Mbia tambuɨ turã na mondo uchuchúaa se nyii, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jesús que mbia tubɨrɨã mbuɨ turã mondo uchuchúaa cote ra. Ae ae que oso sɨta ibate rɨ̃ cote ra. Ñee sacuã Dios je. Huee que ae ae riqui itondaru chee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Canoa yenda que chɨ beɨ quia ama ite rɨ̃ nda. Quɨrɨrɨã ngue tu ɨcuã ɨcuã ee ra. I rebera que tu asi asi tuchɨ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nguira cheẽ mose que Jesús ngasẽ ee ra. I arõ ngue esɨ quia ngata ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Echɨmbaaquiatu que mae erese ra. Echɨã ngue cuaãcuã ɨ tuchɨ ra. Ngata mose i arõ. —Aba checuayã ño tu nguiã aque, ɨ rei que tasẽ tasẽ nda. Siquiche tuchɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","—Jẽsiquichechɨ̃ nguiã. Se chõ nyeresẽ, ɨ jeɨte que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro que ñee ee ra. —Nde mose, echeẽ seje. “Echu ngata i arõ”, ere seje, ɨ que Pedro ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Quiatuchu, ɨ que Jesús ñee ee ra. Ae Pedro nguichi nguiã canoa sɨ i rese irõ. Oso nda ngata i arõ Jesús rea chã nde. ");
INSERT INTO srqNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pedro mae mose quɨrɨrɨã ɨcuã ndese que esiquichete ra. Ɨ que oso quia ñɨɨmɨ nda. —¡Sererecua! ¡Senonosẽ na se! ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ae Jesús o mondo nguiã eo isi. —Seɨcuayã ñochɨ̃. ¿Mbaerã ereɨco seɨcuayãte re? ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ua mose canoa ye que quɨrɨrɨã tiba cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Canoa yenda que ñee turãte Jesús je cote ra. —Dios rucucha tuchɨ chõ nde riqui re. ¡Ae beɨ jẽ! ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ngasẽ nyee que sobeɨ cote ra. Genesaret, ɨ que hue ibi je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hue jenda que jirandu ja erese ra. Hue rurubinda abe que mbia mbiirandu erese ra. Mbia que er asi curucuaẽ cuaẽ ja Jesús je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—Sã mbia rasi oco oco rã ndeɨrao ai rese, ɨ tuchɨ que mbia Jesús je ra. Ae oco erese nae, ũquɨ̃ ngue nyerõ nyerõ ja ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aquere que fariseos mo ngaẽ ñee Jesús je ra. Embesasa mo abe que ra. Jerusalén jenda chõ ũquɨ̃ ja re. ");
INSERT INTO srqNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ũquɨ̃ ngue ñee Jesús je ra. —¿Mbaerã ndechɨmbaaquiatu riqui nanderameɨ ñee mumba mumba beɨte re? Echoɨ quiiriã mbeɨ chõ quiaru nguiã, ɨ que ñee asite Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús que ñee ee ra. —¿Mbaerã jẽɨngo Dios cheẽ mumba mumba jẽ nde? Jenameɨ ñee ndese chõte jẽɨngochɨ̃ nguiã ã. Siqui rocoɨ̃ Dios cheẽ ndese. ");
INSERT INTO srqNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios que ñee mbia je cose ra. “Jẽturã ño jẽɨngo jendu je. Jẽsi je abe no. Emo ñee ɨcuã mose ngu rɨɨ̃, ũquɨ̃ jẽɨquia. Emo ñee ɨcuã mose usi abe rɨɨ̃ no, ũquɨ̃ abe jẽɨquia no”, ɨ quia que Dios ñee mbia mbaaquiatu cose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Dios cheẽ jenyabi tuchɨ chõchɨ̃ nguia mbia mbaaquiatu quiatu ã. “Ae nda amee neɨ̃ jẽje, ũquɨ̃ ngue amee ja Dios je ra”, ɨ mose emo ñee ngu je, “coche ñene” jenye chõchɨ̃ nguiã ee. Mbae mee eã mose ngu je. Usi abe je. Nyebe jẽɨngo nguiã mbia mbaaquiatu ɨcuã ɨcuã ũquɨ̃. Jenamei ñee achõ ño jẽsenei senei nguiã mbia je ũquɨ̃. Dios cheẽ nenei nenei ndocoɨ̃ ee. ");
INSERT INTO srqNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jẽturã jẽsaã ñooño ño nguiã ũquɨ̃. Jenɨɨ tuchɨ chõ ngue Isaías embesa nguiã cose. Eɨ̃ ngue Isaías embesa cose ra: ");
INSERT INTO srqNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ã mbia ñee turã ndaque quia seje ã. Uchɨangui re quia eriquiãte nguiã serese ã. ");
INSERT INTO srqNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ñee turãte raque equia seje ã. Ameɨ ñee achõ ño esenei seneichɨ̃ nguiã mbia je. Dios cheẽ mɨɨ nenei nenei ndocoɨ̃ ee, ɨ que Isaías embesa jenɨɨ nda, ɨ que Jesús ñee ucuasu raã naasa je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","—Jenyu rã secheẽ andu, ɨ que Jesús ñee mbia tubɨrɨã je ra. —Secheẽ jẽɨcua rã jeñɨangui re. ");
INSERT INTO srqNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mbia chɨu embɨɨcuã eã nguiã. Echɨangui renda chõ embɨɨcuã nguiã. Echɨangui renda chõ usẽ nguiã echuru rɨ̃ echeẽ mose. Ũquɨ̃ ño embɨɨcuã nguiã, ɨ que Jesús mbia mbaaquiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Echɨmbaaquiatu que ngaẽ ñee Jesús ísaa cote ra. —¿Ereɨcuayãte ere? Ndecheẽ ngue fariseos mbupaama ɨte ra, ɨ que echɨmbaaquiatu ñee nyecuayã ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús que ñee ee ra. —Ae ira Paba Ibatenda chutã eã nae, ũquɨ̃ nda esiqui ja erao resebe. Ũquɨ̃ ira rã ño fariseos riqui nguiã ã. ");
INSERT INTO srqNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Eresayã na ño fariseos riqui nguiã. Sã eresayã mo “ñeenda tateacuquia jẽje” ɨ raque emo je no. Quiachã ja chõ ndae, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro que ñee ee cote ra. —Erecheẽ ngue namo, “ũquɨ̃ nda mbia mbɨɨcuã” ere que, ũquɨ̃ embuchecua rã ndecheẽ ure je, ɨ que Pedro ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús que ñee ee ra. —¿Jẽ abe jẽɨcuayãte quia re? ");
INSERT INTO srqNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ae mbia u quia nae, oso chõ nguiã erie ye. Echiique ruɨ chõ eriqui nguiã oso oso. Usẽ nyee. ");
INSERT INTO srqNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mbia chɨangui renda chõ embɨɨcuã nguiã usẽ mose echuru rɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aba chɨangui renda quia aba mundua ɨcuã ɨcuãte nguiã. Nyebe mbia riqui nguiã emo ɨquia. Siqui siqui emo ninisi rese. Emo ndu rese abe no. Siqui siqui eruã ndese no. Mbae mbuquiachã quiachã no. Ñee ñooño abe no. Ñee ɨcuã ɨcuã no. ");
INSERT INTO srqNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mbia chɨangui renda ja chõ ũquɨ̃ nde. Ũquɨ̃ ño mbia mbɨɨcuã ɨcuã nguiã ũquɨ̃ ao ao mose. Uchoɨ quiiriã mose quiaru, ũquɨ̃ nguia ra mbia mbɨɨcuã eã, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús que nyoɨ hue recha cote ra. Ngasẽ ngue Tiro jii cote ra. Sidón jii abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ari mo Canaán jenda que siqui huee ra. Ae que tu ñee Jesús je ra. —David nducucha chõ nde re, Jesús. ¡Ndeyayã ño serese jẽ! Aba checuayã ɨcuã ndiqui seriirĩ mbasi mbasi co, ɨ tuchɨ que ari ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús que ñee ãte ee ra. Echɨmbaaquiatu que ngaẽ ñee Jesús je ra. —Ari emondo chõ uchuchúaa. Eñɨ mbeɨchɨ̃ ñee nande je a, ɨ que echɨmbaaquiatu ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús que ñee ee ra. —Sã ovejas mo quiachã no. Ũquɨ̃ na ño judíos riqui nguiã ã. Judíos achõ je chõ ngue Dios sembu nguiã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ari que tu ngoi ngũíã ndese ñee Jesús je ra. —Sererecua, seriirĩ embucherõ na seje, ɨ que ari ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús que ñee ee ra. —Judíos rese rane taɨco mbae raã naa. Ahuɨ aronea judíos sɨ, mbae raã naa mbiamo je, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ari que ñee ee ra. —Aɨcuate raque se, Sererecua. Mbiamo ndaque ure. Judíos eã ndaque ure. Ure abe je chõ mbae esaã ae. Seriirĩ embucherõ seje ae, ɨ que ari ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—Seɨcuate equia co, Ari. Nderiirĩ tambucherõ ndeje, ɨ que Jesús ñee ari je ra. Aque mosechɨ tuchɨ que eriirĩ nyerõ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús que oso hue recha cote ra. Oso que equia ama nimia nduɨ ra. Ama Ndɨsha Galilea nimia nduɨ. Hue sɨ que esɨ sɨta ibate cote ra. Huee que ngoi huee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mbia que ngaẽ ngaẽ tuchɨ quia ee huee ra. Erasi chumumbara rurucuaẽ cuaẽ tuchɨ ee. Ecuatayã. Eresayã. Echeẽ ngũíã. Eo ɨcuã. Mbia que ũquɨ̃ ndasi chono ja Jesús i jii ra. Jesús que ũquɨ̃ mbucherõ ja ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nyebe mbia riqui nguiã nyuruɨra tuchɨ mae erese. Echeẽ ngũíã ñee turã mose. Eo ɨcuã mbuturã mose. Ecuatayã ngata turã mose. Eresayã mae turã mose. Nyebe mbia ñee turã ja nguiã Dios rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús que ñee uchɨmbaaquiatu ísaa cote ra. —Seyayãte aɨco ã mbia tubɨrɨã ndese co. A echɨ arete serese tres días a. Embae mo eãte echɨurã aa. Eriãcuã amondo sereãte echuchúaa. Eriãcuã nda eɨquia ñeenda cúa, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Echɨmbaaquiatu que ñee ee ra. —Turúquiaa chõ nandeɨco a resẽ. ¿Mañɨ nda aba ã mbuquiaru ja re? Mbae eã tuchɨte a resẽ, ɨ que echɨmbaaquiatu ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Manya mbichae jembae re? ɨ que Jesús ee ra. —Siete mbichae. Sɨra ñetẽ mo ndese, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesús que mbia mbucoi ja íbii ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mbichae que eisi ja o je ra. Sɨra ñetẽ abe no. Gracias, ɨ que Dios je ra. Mbichae que esiquio quio mbia je cote ra. Sɨr a rese. Mee ja que uchɨmbaaquiatu je cote ra. Ũquɨ̃ ngue emee mee mbia ja je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mbia que eu ja ñimbio chee ra. Mbichae sique sique que emunua nua ja ra. Sɨra sique rese. Siete iru que emombisẽ nyee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mbichaecua rei mbia cuatro mil. Cuña abe abe. Mbia riirĩ abe abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesús que mbia mondochoɨ ja cote ra. Jesús que ua canoa ye cote ra. Oso que Magdala quiti cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","—Tã nande rã Jesús je, ɨ que fariseos ñee nyue ra. Saduceos rese. Nyebe ũquɨ̃ ngaẽ nguiã ñee Jesús je. —Mbia mae sayã esaã na ure je. Ɨ̃ nda “Dios chɨmbu” ure tuchɨ ndeje, ɨ rei que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús que ñee ee ra. —Ibei jẽɨcuate raque ũquɨ̃. Ibei ɨreɨ̃ ndese jemae mose eresaitõ, “ama nda nyaaquíã” jenye chõ nguiã eɨcua. ");
INSERT INTO srqNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ibei ɨreɨ̃ ndese jemae mose eresaitõ ndabe, “nyaaqui rae”, jenye chõ nguiã eɨcua ũquɨ̃ no. Ibei jẽɨcuate raque quia ã. Ae Dios teacuquia jẽje nae, ũquɨ̃ jẽɨcuayã mbeɨ chõchɨ̃ nguia ã. Ae ra tu ɨcuãte mbia je nae, ¿mbaerã jẽɨngo ũquɨ̃ nguiatu ɨcuayãte re? ¿Mbaerã jẽɨngo jẽaracua raã naa nde? ");
INSERT INTO srqNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mbia ɨcuã ja chõ ã nde. Ae siqui ibi rɨ̃ namo nae. Huɨ jate equia Dios sɨ ã. “Mbia mae sayã esaã ure je”, ɨ chõchɨ̃ equia seje ã. Aque mɨɨ nda asaã jẽje. Jonás na sɨ ra asaã jẽje, ɨ que Jesús ñee nda. Oso que erecha cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesús chɨmbaaquiatu que uchɨurã curuchoɨ eã nda. Tesareɨ que esɨ nyoɨ mose sobeɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús que ñee ee ra. —Mbichae mbuchɨmatãsa rã ndei fariseos cheẽ. Saduceos cheẽ abe no. Ũquɨ̃ ñee ndese ra jẽɨngochɨ̃ jẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","—Mbichae quiatu ngue nanderuã nguiã. Nyebe eriqui nguiã ñee nande je ũquɨ̃, ɨ rei que echɨmbaaquiatu ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús que echeẽ ñee ɨcuate ra. Nyebe ñee nguiã ee. —¿Mbaerã jẽɨngo “mbichae nanderuãchɨ̃” ɨ re? ¿Mbaerã jẽɨngo seɨcuayãte re? ");
INSERT INTO srqNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ae rɨɨ̃ aɨco ñee jẽje nae, ¿ũquɨ̃ jẽɨcuayã mbeɨte quia re? Se mbichae mbeta mose ¿ũquɨ̃ sɨ jẽtesareɨ chõ nde? Cinco mbichae mbeta mose mbia cinco mil je, ¿manya iru jemombisẽ mbichae sique sique je re? ");
INSERT INTO srqNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Siete mbichae mbeta mose mbia cuatro mil je ¿manya iru jemombisẽ mbichae sique sique je no? ");
INSERT INTO srqNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Secheẽ mose jẽje nyii, “mbichae mbuchɨmatãsa rã ndei fariseos cheẽ”, ɨ mose jẽje, secheẽ jẽɨcua rã. Mbichae rɨɨ̃ aɨco ñee ãte jẽje co. Fariseos cheẽ ndese jẽɨngo eã sacuã ño aɨco nguiã ñee jẽje. Saduceos cheẽ ndese abe jẽɨngo eã sacuã, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Echɨmbaaquiatu que eɨcua chee ra. —Mbi chae mbuchɨmatãsa rɨɨ̃ eã ño eriqui ñee nande je re. Ae fariseos senei senei ɨcuã nguia mbia mbaaquiatu nae, ũquɨ̃ nɨɨ ño eriqui ñee nde. Saduceo ñee nɨɨ abe no, ɨ que echɨmbaaquiatu eɨcua ramo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús que nyoɨ Cesarea de Filípoo cote ra. Huee que ñee uchɨmbaaquiatu je cote ra. —Mbiarã ngue achu íbii ra. ¿Aba aɨco reɨ̃ se mbia je re? ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Echɨmbaaquiatu que ñee ee ra. —Juan el Bautista ereɨco reɨ̃ nguiã mbia je co. Elías ereɨco reɨ̃ nguiã emo je no. Jeremías ereɨco reɨ̃ nguiã emo je no. Dios cheẽ nenei neneisa mo ereɨco reɨ̃ nguiã emo je no, ɨ que echɨmbaaquiatu ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—¿Aba aɨco reɨ̃ jẽje co re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","—Cristo chõ nde resẽ. Dios riirĩ ño nde resẽ, ɨ que Pedro ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","18","Jesús que ñee Pedro je cote ra. —Ndeyate ereɨco co, Simón. Mbia mo nembiirandu eãte quia serese co. Paba Ibatenda mɨɨ ño nembiirandu nguiã serese. Jonás ndiirĩ ndei nde. Tacheẽ tuchɨ ndeje. “Pedro” ɨ chõ equia ndeje co. “Sɨta” ɨ ñɨ Pedro je re. Aque sɨta arõ ño nda sembae iglesia achao. Satanás nda esiquisã eãte. Satanás quirãcuãte raque. Mbia ɨquiasa raque ae no. Ae ra sembae iglesia siquisã eã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mbae tamee ndeje. Llave tamee ndeje. Aque je ra Dios recua ɨquesa erembuquiata quiata mbia je. Mbia ɨque sacuã. Ae je ra erembuqui ata, ũquɨ̃ nda ɨque. Ae je ra erembuquiata eã, ũquɨ̃ nda ɨque eã, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesús que ñee uchɨmbaaquiatu ja je cote ra. —“Jesús rei Dios chɨmondo” jenyechɨ̃ nda emo mbiirandu jẽ, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Aque mose beɨ que Jesús umano nonde senei senei uchɨmbaaquiatu je ra. —Paba ra sererao Jerusalén. Huee ra ameɨ seiruã nu a tuchɨ. Sacerdotes rerecua abe ra sembasi mbasi tuchɨ no. Embesasa abe no. Seɨquia rae. Tres días mose ra aquera sɨ, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro que Jesús querao pe jiri ñee sacuã ee ra. —Mbia ra jeɨ̃ jeɨ̃chɨ̃ ndeje jẽ. Mbia ra ndeɨquiachɨ̃ jẽ, ɨ rei que Pedro ñee asi ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús que uba ñee Pedro je ra. —Ehuɨ chõ sesɨ, Satanás. ¿Mbaerã ereɨco seriquisã quisã nde? Mbia ndua rã ño ereɨco nguiã ndua. Dios ndua rã eã, ɨ que ñee Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesús que ñee uchɨmbaaquiatu je cote ra. —Emo siquise mose seruɨ, sã huɨ ja mbae ubi sɨ. Sã cruz umbaerã nduɨ se rã sɨ. Sã eriqui seruɨ beɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Emo ndua beɨ mose ngueco rese, ereco ra ua esɨ. Emo huɨ mose ngueco sɨ seje, ũquɨ̃ nda siqui beɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Emo ngueco mumba chooño mose, eya eã mbeɨ rae. Mbaecha rete raque. Emo ngueco mumba chooño mose, mbae mo eãte ereco rɨbɨshorõ sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Dios ra sembu sɨ íbii uquirãcuã je. Ibatenda rese ra achu ángeles. Ae mbae turã saã saã nguia nae, ũquɨ̃ je ra mbae turã amondo se tu mose. Ae mbae ɨcuã saã saã nguia nae, ũquɨ̃ je ra mbae ɨcuã amondo no. ");
INSERT INTO srqNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tacheẽ nyecua jẽje. A jengu a nae, jemo nda jemae sechu rese. Achu ra mbia rerecuarã tuchɨ cote. Jemo jemano eã mose r a achu mbia rerecuarã tuchɨ cote, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tenda seis uare que Jesús uchɨmbaaquiatu mo nderao sɨta ibátee ra. Pedro. Jacobo. Juan abe no. Jacobo nongue rei Juan. Ũquɨ̃ ngue equerao ja mbia tiãsaa ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jesús que nyɨɨcuabo erésaa ra. Eruba que ñimbiasu ra. Tenda nininya rã tuchɨ que eruba ra. Eɨrao abe nininya tuchɨ que ra. Eɨraoshĩ nininya tuchɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mbia nyeremo ngue nyecua u ibate sɨ ra. Jesús nininya mose que echɨ ñee ñee erese ra. Moisés que enongue ra. Elías que enongue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro que ñee Jesús je ra. —Sembaaquiatusa, nandecu turãte a. Sucha ñetẽ uresaã saã na, ndebi mose. Enongue nembaerã. Enongue Moisés mbaerã no. Enongue Elías mbaerã no, ɨ rei que Pedro ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro cheẽ mosete que ibeishĩ ndu eite ñɨ nda. Abamo ñee mo ngue echandu ibeishĩ qui re ra. —Co rei sebi tuchɨ seriirĩ co. Seya tuchɨte aɨco erese co. Echeẽ jeñandu beɨ quia, ɨ que Dios ñee ee ibeishĩ qui re ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Echɨmbaaquiatu que siquichete eandu mose ra. Echeẽ mose que echoɨ nyaara nguíe quiti ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús que esɨɨchã oco oco erese ra. —Jẽhuã na. Jẽsiquichechɨ̃ nda jẽ, ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Echɨmbaaquiatu soboiba mose que mae Jesús mɨɨ ndese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ɨ ecuaẽ nguia nguichi mose sɨta ibate sɨ que Jesús ñee ee ra. —Ae rese jemae namo nae, ũquɨ̃ nda jẽsenei seneichɨ̃ emo je jẽ. Seraaque quera sɨ mose, aque mose ramo ño jẽsenei senei mbia je cote, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Echɨmbaaquiatu que ñee ee cote ra. —¿Mbaerã “Elías rane nda tu Cristo sɨ” ɨ embesasa re? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús que ñee ee ra. —Ae beɨ. Coche Elías rane tu nguiã mbae mbitirõ ja. ");
INSERT INTO srqNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Elías que tu ra. Mbia que eɨcuayãte ra. Mbia ɨcuã ɨcuã jate que eriqui ee ra. Eɨ̃ sɨ ra mbia ɨcuã ɨcuã seje no, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Echɨmbaaquiatu que Jesús cheẽ ɨcua ramo cote ra. —Juan el Bautista rɨɨ̃ ño eriqui ñee nde, ɨ que Jesús cheẽ ɨcua ramo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ngasẽ ngue mbia ja je cote ra. Emo ngue ngoi ngũíã ndese ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Seriirĩ embucherõ na, Sererecua. Tẽ ɨ beɨte que equia ra. Titi titi ɨ beɨte que equia no nda. Erasi tuchɨte. Ngoɨ coɨ beɨte tátaa. Ama ye abe ngoɨ coɨ beɨte. ");
INSERT INTO srqNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","“Seriirĩ embucherõ na”, ae rei ngue nguiã ndechɨmbaaquiatu je. Mbia mbucherõ aquiatuã ño eriqui re, ɨ que eru ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús que ñee cote ra. —¿Mañɨ jenye quia seɨcuayãte re? ¿Secheẽ jemumba tuchɨ chõ nguia re? ¿Ñimbirãcuã mbeɨte ra aba quia jẽje re? ɨ que Jesús ra. —Eriirĩ jendu rã seje, ɨ que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús que ñee asite aba checuayã je cote ra. Aba checuayã ngue usẽ eriirĩ sɨ cote ra. Aque mose tuchɨ que eriirĩ nyerõ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aquere que echɨmbaaquiatu ñee Jesús ísaa ra. —¿Mbaerã ureɨco aba checuayã jea aroneate mbia sɨ re? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús que ñee ee ra. —Seɨcuayãte jiri quiatu nguiã ã. Tacheẽ nyecua jẽje. Sã mostaza eɨ̃ ñetẽte riqui raque no. Jẽ seɨcua ñetẽ mose, mbae ra asaã ja jẽje. “Eso pe jiri”, jenye mose co sɨta ibate je, siri ra oso pe jiri jeñee nguire. Jẽ seɨcua mose, mbae jẽ saã ja arondete. ");
INSERT INTO srqNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Aba checuayã ngue ajea namo, ũquɨ̃ nda jẽjea eã jeñee eã mose Dios je. Ũquɨ̃ nda jẽjea eã, jẽhuɨ eã mose jenyɨu sɨ, ɨ que Jesús ñee ee ra. Mbia ra seɨquia, ɨ sɨ Jesús ");
INSERT INTO srqNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea rɨ̃ ngue Jesús riqui ngata uchɨmbaaquiatu rese ra. Jesús que embaaquiatu quiatu quia ra. —Mbiarã ngue achu ra. Mbia ra semee mbia ɨcuã je. ");
INSERT INTO srqNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mbia ɨcuã nda seɨquia. Tres nyaashĩ mose r a aquera sɨ, ɨ que Jesús ra. Echɨmbaaquiatu ia eã tuchɨ que echeẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ngasẽ ja que Capernaum cote ra. Ae impuestos isi isi quia Dios chuchua jenda nae, ũquɨ̃ ngue nyoɨ ñee Pedro je ra. —¿Jenderecua impuestos mee eã nguia Dios chuchua jenda je re? ɨ que ñee Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Impuestos emee mee mbeɨte quia co, ɨ que Pedro ee ra. Pedro que oso ɨque tuchúaa cote ra. Jesús rane ngue ñee ee ra. —Ɨ ere, Pedro. ¿Aba je mbia rerecua riqui “impuestos jemee na seje” ɨ re? Ɨ eã nda nguiirĩ je. Mbiamo je chõ nda ñee nguiã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Ae. Mbiamo sɨ ra eisi, ɨ que Pedro ñee ee ra. Jesús que ñee ee cote ra. —Eriirĩ nda impuestos mee eã ee resẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dios riirĩ ndaque se. Impuestos nandemee ndei Dios chuchua jenda je. Sã mbia ndua ɨcuã eã nande rese. Quiatu ama ndɨ́shaa. Sɨra mbabasa emondo ii. Ae rane nda sɨra erembua nae, aque churu ye ra mbae isiquia mo eretea. Aque emee serao impuestos isi isiquia je. Sembae impuestos sacuã. Nembae sacuã abe no, ɨ que Jesús ñee Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aque mose que echɨmbaaquiatu ñee jate Jesús je ra. —¿Aba ra ererecua tuchɨ ure nderese re? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús que ãquẽ mo mbucoi mɨɨ eite re ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ñee ngue mbia je cote ra. —Tacheẽ nyecua jẽje. Dios quiti jemba eã mose ra jenderecua eã mbeɨ Dios. Mbia riirĩ na jẽɨngoã mose ra jenderecua eã mbeɨ Dios no. ");
INSERT INTO srqNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ae siqui quia cocheete nae, ũquɨ̃ nda mbia rerecuarã nyee Dios rese. Ae siqui quia mbia riirĩ n a nae, ũquɨ̃ nda mbia rerecuarã nyee Dios rese. ");
INSERT INTO srqNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ae eturã ndiqui mbia riirĩ je serɨɨ̃ nae, seje abe chõ eturã ndiqui nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ae ra mbae ɨcuã saã uquia seɨcuasa mo je nae, ũquɨ̃ nda mbae rasi saã tuchɨ cote. Ũquɨ̃ nda aba mombo chõ ama ndɨsha ye nyii re chã. Sɨta resebe ecua ji mondo. Ɨ̃ nda mbae ɨcuã naa uquia eãte rei seɨcuasa je. ");
INSERT INTO srqNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mbae ɨcuã nguiarei siqui beɨ tuchɨ mbia mbɨɨcuã nonde. Ae ñee nguia mbia je nae, “mbae ɨcuã esaã” ɨ nae, eɨcuã tuchɨ chõ ũquɨ̃ nde. Ae “mbae ɨcuã esaã” ɨ nae, ũquɨ̃ nda mbae rasi saã tuchɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ndeo nemingo mose mbae ɨcuã ndese, ndeo echisia mombo. Coche rei ra ereso ibate ndeo mɨɨ nderequia, siqui beɨ sacuã huee. Ndei nemingo mose mbae ɨ cuã ndese, ndei echisia mombo no. Coche rei ra ereso ibate ndei mɨɨ nderequia, siqui beɨ sacuã huee. Oso rocoɨ̃ tata cuásuu, ndeo nyeremo nderao. Ndei nyeremo nderao. Tata ra uqueã mbeɨ huee no. ");
INSERT INTO srqNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nderesa nemingo mose mbae ɨcuã ndese, nderesa echoo. Coche rei ra ereso ibate nderesa mɨɨ nderequia. Nemombo rocoɨ̃ tata cuásuu, nderesa nyeremo nderao. ");
INSERT INTO srqNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Seriirĩ ñetẽ mo nda jẽucuãyãchɨ̃ jẽ. Angeles riqui eraarõte ã. Angeles riqui Paba rese ibate pe. ");
INSERT INTO srqNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Se que achu quiachã je rea ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Sã emo nimba quiachã oveja no. Cien ndei ngue erimba re. Co mɨɨ ngue quiachã ee ra. Aque esɨ quia quiachã je requia aque. Eataque recha. Noventa y nueve recha. ");
INSERT INTO srqNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tacheẽ nyecua jẽje. Echa quiachã je rea mose, eyate que erese ra. Eya tuchɨ que erese ovejas ataque sɨ ra. Quiachã eã je sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sã jendu ibatenda abe no. —Sã aque mɨɨ quiachã eã seriirĩ ñetẽ mo, ɨ chõ Dios nguiã co. ");
INSERT INTO srqNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nderesenda ɨcuã mose ndeje, eso ñee ee. “Ã ngue eresaã mbae ɨcuã nda”, ere chõ ñee eísaa. Ndecheẽ andu turã mose, nderesenda que erembitirõ turã nda. ");
INSERT INTO srqNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ndecheẽ andu sereã mose, emo abe erao ñee sacuã ee. Aque mɨɨ nda reae. Nyeremo nda re no ae. Ũquɨ̃ abe ñee sacuã ee. Jeñee ja mose ee hue rɨ̃ ja, jẽandu turã arõte. ");
INSERT INTO srqNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ũquɨ̃ andu sereã mose, jeñee mbia chumunuásaa cote. Sã mbia ñumunua je ñee ja ee. Ũquɨ̃ ñee andu sereã mose, jemombo chõ cote. Dios quiatoã naanguia jẽsaã ño ee cote. Mbia ɨcuã naanguia jẽsaã ño nguia ee cote. ");
INSERT INTO srqNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tacheẽ nyecua jẽje. Jẽ mbae mo ndiquisã mose, Dios abe ra esiquisã. Jẽ mbae mo ndiquisã eã mose, Dios abe ra esiquisã eã no. ");
INSERT INTO srqNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tacheẽ nyecua jẽje. Jẽ nyeremo ndua turã mose hue rɨ̃ sɨ́, “co embu ure je” jenye turã ja mose Dios je, Paba Ibatenda ra emondo jẽje. ");
INSERT INTO srqNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jẽ nyeremo ñumunua mose serɨɨ̃, aɨco chee nguiã jendese jẽite re huee, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedro que ñee Jesús je ra. —Seresenda ɨcuã mbeɨ mose seje ¿manya veces ra atesareɨ eɨcuã sɨ re? ¿Siete veces ra re? ɨ que Pedro ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús que ñee ee ra. —Tei. Siete veces eã. Eata tuchɨ quia ñene. Setenta veces siete quia ñene, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sã ererecua mo ndiqui no. Dios rã sɨ chõ ererecua re. Sã ererecu a cuenta raã naa ja ngũimba je no. ");
INSERT INTO srqNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Cuenta raã naa mose que erimba mo ndurucuaẽ ee ra. Aque que deber ɨ tuchɨ quia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mbae ãte que erimba mbae pagar ɨ sacuã nda. Nyebe ererecua ñee nguiã. “Embae je vender nande ja rã. Eriirĩ abe je vender nande. Eninisi abe no. Ae abe je vender nande. Ɨ̃ nda cuenta ua jiri”, ɨ rei que ererecua ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Erimba ia eã tuchɨ que echeẽ andu ra. Ngoi que ngũíã ndese ñee nguerecua je ra. “Sererecua, eɨco tochi chõ seje ae. Mbae tamondo ja chee ndeje”, ɨ que erimba ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ererecua ia eã tuchɨ que erese ra. “Mbae emondo eã ndei seje pagar ɨ sacuã”, ɨ chõ nyee que ee ra. Huɨ chõ nyee que esɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Erimba que usẽ ndei oso quia ra. Aque mosechɨ que ngasẽ nguesenda mo je ra. Deber ɨ mɨɨte rei ee reaẽ. “Pagar ere rã seje”, ɨ que echosoɨ isi ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Eresenda que ngoi ngũíã ndese ñee ee ra. “Eɨco tochi chõ seje ae. Mbae tamondo ja chee ndeje”, ɨ que eresenda ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Nya” ɨ chõ ngue enongue echeẽ mose ra. Cárcel chõ ngue ererao chee matã nda. Mbae mondo ja chee sacuã ee. ");
INSERT INTO srqNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Eresenda ataque ia eã tuchɨ que mae erese ra. Nyebe echoɨ nguiã ñee ererecua je. ");
INSERT INTO srqNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nyebe ererecua “echu” ɨ nguiã ee. “Serimba ɨcuãte chõ ereɨcochɨ̃ nde re. Ae deber ere seje, ũquɨ̃ nɨɨ ngue acheẽ eãte ndeje. Seya eãte que nderese nde ñee mose seje nyii. ");
INSERT INTO srqNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Mbaerã ndeya eã eã ño ndenongue rese nde re? Sã ñɨ seya eãte nderese nyii no”, ɨ que ererecua ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ererecua que paama ɨ tuchɨ ee ra. “Jẽɨruã nua tuchɨ, pagar ɨ ja chee”, ɨ que ererecua ñee mbia je ra, ɨ que Jesús mbia mbaaquiatu quiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","—Eɨ̃ sɨ́ ra Paba Ibatenda paama ɨ jẽje, jẽtesareɨã mose jendesenda ɨcuã sɨ, ɨ que Jesús mbi a je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús cheẽ uare que esɨ Galilea sɨ cote ra. Ama Jordán ndobeɨ que esɨ sobeɨ cote ra. Judea beɨ chõ hue ja ibi re. ");
INSERT INTO srqNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mbia que nyoɨ ja tuchɨ quia eruɨ ra. Huee que mbia rasi mbucherõ cherõ tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariseos mo ngue nyoɨ Jesús rɨɨchã nda. —Tã nande Jesús je no. Ma ñee Dios cheẽ abi, ɨ que ñee nyue ra. —¿Coche mbia ngũinisi jea ubiã mose re? ɨ que ñee Jesús je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús que ñee ee ra. —¿Embesa ji rese jẽɨngo mae ãte re? “Dios mbia ao mose, nyeremo ngue echao ra. Erãcuẽ ngue echao ra. Eninisirã abe que echao no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nyebe ra emo ndiqui ngũinisi rese beɨ. Ngu sɨ ɨsho. Usi sɨ abe no. Ngũinisi rese siqui beɨ sacuã. Co mɨɨ na siqui sacuã nyɨese”, ɨ ñɨ embesa ji re. ");
INSERT INTO srqNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nyeremo siqui rã eã ño cote re. Co mɨɨ siqui rã ño ũquɨ̃ cote re. Ae Dios mbucha nyɨese nae, sã ũquɨ̃ huɨ̃ eã mbeɨ nyesɨ, ɨ que Jesús ñee ee ra ");
INSERT INTO srqNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fariseos que ñee ee cote ra. —¿Mbaerã Moisés ñee ũquɨ̃ nde? “Jeninisi jea nonde, papel mbesa je jemondo ee”, ɨ ee re, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús que ñee ee ra. —Jẽaquẽ ãtãte quiatu ngue re. Nyebe Moisés embesa nguiã jẽje ũquɨ̃. Ũquɨ̃ ɨ ãte que Dios mbia ao ramo mose nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ae ngũinisi jea nae, eninisi siquíã ndaque emo ndese, eɨcuã tuchɨ chõ ũquɨ̃ nde. Ae ngũinisirã mo ndeabe mose, adulterio ɨ que ũquɨ̃ je ra, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Echɨmbaaquiatu que ñee ee ra. —Mbaeɨae mose ngũinisi jea mose ¿mbaerã nguiatu ra ngũinisirã ndea re? ɨ rei que echɨmbaaquiatu ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús que ñee ee ra. —Mbia ja riqui ũquɨ̃ ɨcua eãte ã. Ae Dios mbaaquiatu quiatu nae, ũquɨ̃ mɨɨ ño siqui nguiã eɨcua ã. ");
INSERT INTO srqNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ae eninisi sereã mbeɨte nae, ũquɨ̃ nda siqui turã, eninisiã ndaque rae. Emo nyɨa o ji mose, ũquɨ̃ abe ra siqui turã, eninisiã ndaque rae. Emo ngũinisirã nderequia eã mose Dios rɨɨ̃, ũquɨ̃ abe ra siqui turã, eninisiã ndaque ra eno. Ae ra “coche seninisiã aɨco nguiã co” ɨ mose, sã eriqui beɨ eninisiã, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mbia que nguiirĩ ngurucuaẽ cuaẽ nguia Jesús je ra. Jesús o noono sacuã eãquĩ arõ. Jesús ñee sacuã Dios je erɨɨ̃. —¿Mbaerã jendiirĩ jendu quia co re? ɨ rei que Jesús chɨmbaaquiatu ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús que ñee nda. —Tei. Jẽhuɨ chõ esɨ. Sã nguiirĩ ndurucuaẽ cuaẽ seje. Eɨ̃ ño Dios rimba nguiã. Ucuasu raã naa eã. Mbia riirĩ na, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesús que o chono ñono mbia riirĩ arõ nda. Aquere que esɨ ngata cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Acuanɨndu mo ngue tu ñee Jesús je ra. —Mbia mbaaquiatusa turãte nde. ¿Mbae turã mo nda asaã Dios je semingo beɨ sacuã nde? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús que ñee ee ra. —¿Mbaerã ereɨco eturã ɨ seje re? Dios mɨɨ ño eturã ndesẽ. Nde ndeɨco beɨse mose, Dios cheẽ emumbayã ja, ɨ que Jesús ñee e e ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Mbae ra amumbayã Dios cheẽ nde? ɨ que acuanɨndu ee ra. Jesús que ñee ee ra. —“Mbia mo nda ereɨquiachɨ̃. Emo ninisi rese ra ereɨcochɨ̃. Mbae mo nda erembuquiachãchɨ̃. Erecheẽ ñooñochɨ̃ nda emo nɨɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ndeturã ño nderu je. Ndeturã ño ndesi abe je. Sã erechesecua ndechɨese no nae, eɨ̃ ere sɨ chõ nyesecua nde ji jenda rese”. Dios cheẽ ja chõ ũquɨ̃ nde. Mbia echeẽ mumbayã sacuã, ɨ que Jesús ñee acuanɨndu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Acuanɨndu que ñee ndei ee ra. —Ũquɨ̃ ngue amumbayã ja beɨ quia ra. Señetẽ mosenda beɨ. ¿Mbae mo abe ra asaã nde? ɨ que acuanɨndu ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús que ñee ee ra. —“Taɨco turã tuchɨ”, nde ɨ mose, ã abe esaã. Nembae emondo mondo ja mbia mbaecha reã je. Nde ũquɨ̃ naa mose, mbae tubɨrɨã nda nembae, ndeɨco mose ibate. Nembae mondo ja mose mbaecha reã je, seruɨ eɨco cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Acuanɨndu Jesús cheẽ andu mose que echosoi oso serɨ̃te cote ra. Eyayãte que oso ra. Mbaecha tuchɨte quiatu ngue ae re. ");
INSERT INTO srqNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesús que ñee uchɨmbaaquiatu je cote ra. —Tacheẽ nyecua jẽje. Mbaranguiatu ãte mbaecha je ngasẽ sacuã ibate siqui beɨ sacuã huee. ");
INSERT INTO srqNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sã ticuasu mo ndiqui oso aroneate ɨque aguja sorei rɨ̃ no nae. Eɨ̃ sɨ chõ mbaecha no nde. Oso aronea ibate Dios rese, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Echɨmbaaquiatu que nyuruɨra tuchɨ echeẽ andu ra. —¿Aba quia ra oso Dios rea ibate re no? ɨ que echɨmbaaquiatu Jesús je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús que mae erese ñee ee ra. —Ae mbia saã aroneate quia nae, Dios mɨɨ ño nda esaã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro que ñee Jesús je ra. —Ure que urembae uresech a ja ra. Siqui sacuã nderuɨ. ¿Mbae ra eremee ure je re? ɨ que Pedro ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús que ñee ee ra. —Tacheẽ nyecua jẽje. Dios mbae mbiasu ja mose ra ererecua tuchɨ rei se cote. Mbia ra mae ja serese aque mose. Aque mose ra jẽ abe ererecua. Jẽ doce. Trono jaaja ra jembaerã cote. Judíos rerecua ja ra jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Emo umbae secha ja mose siqui sacuã seruɨ, embae ra asɨbɨshorõ tuchɨ ee cote. Ae uchuchua secha. Ae ngõngue secha. Ae ngu secha. Ae usi secha. Ae ngũinisi secha. Ae nguiirĩ secha. Ae umbae ibi secha no. Ũquɨ̃ mbae ja ra asɨbɨshorõ tuchɨ cien veces. Aquere ra siqui beɨ tuchɨ Dios rese ibate cote. ");
INSERT INTO srqNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ae rane eriqui nyii nae, ũquɨ̃ nda siqui mbia ruɨ tuchɨ cote. Ae siqui quia mbia ruɨ tuchɨ nyii nae, ũquɨ̃ nane nda cote, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesús que mbia mbaaquiatu quiatube no nda. —Dios rei mbia rerecua tuchɨ. Sã mbaecha mo ndiqui no. Sã mbaecha uva tubɨrɨãte riqui embae no. Sã mbaecha mbia mo ndea rea umbae ɨshao shao sacuã no. Nyaashɨ̃ namo mose. ");
INSERT INTO srqNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“Denario mɨɨ tamondo mondo ja jẽje. Sembae ɨshao shao sacuã tenda mondo chee”, ɨ que emondochoɨ úcoo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tenda chuɨ mose que mae emo ndecoteã eã ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","—Jẽ abe jẽso sembae ɨshao shao. Mbae mo tamee jẽje, ɨ que ee ra. Nyoɨ que echeẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tenda nandeite re mose que echa emo mondo choɨ cote ra. Umbae ɨshao shao sacuã. Eɨ̃ sɨ que echa tenda chaara ramo mose no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tenda ɨreɨ̃ mose abe que mae emo ndecoteã eã ndese no nda. “¿Mbaerã jẽɨngo tenda mondochooño siqui rocoɨ̃ mbae mo ndese a re?” ɨ que echa ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Emo ngue ‘mbae mo esaã seje’ ɨ ãte ure je ra”, ɨ que ee ra. “Jẽso jẽ abe sembae ɨshao shao. Mbae mo tamee jẽje”, ɨ que echa ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Itondaru ramo mose que echa ñee mbia reaquiatusa je ra. “‘Jenyu’ ere sembae ɨshao shaosa je. Pagar ere rã ũquɨ̃ ja je. Ae ɨque ramo eresaitõ nae, ũquɨ̃ nane je pagar ere. Ae rane ɨque nyii nae, ũquɨ̃ je pagar ere huɨ beɨ cote”, ɨ que echa ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ae ɨque eresaitõ nae, ũquɨ̃ nane je que denario mɨɨ mee mee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ae rane ɨque nyii nae, ũquɨ̃ ngue ñee ñee u nyue ra. “Eata jiri ra emee nande je reae. Nande rane ngue uva a nandeɨshao shao”, ɨ rei que eu ñee ñee nyue ra. Ũquɨ̃ je abe que denario mɨɨ mee mee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagar ɨ mose ee que ñee asi asi echa je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ae ɨque ramo eresaitõ nae, ũquɨ̃ ngue mbae ɨshao shao eã jiri resẽ. Eresaitõte que ɨque. Ure quiatu que tenda uremumba rei uva a ɨshao shao ndeje. ¿Mbaerã mbae isiquia eremee ee ure rã sɨ chõ nde?” ɨ que ñee echa je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Echa que ñee ũquɨ̃ mo je ra. “Mbae ɨcuã mo asaã eãte ndeje resẽ. ‘Denario mɨɨ’, nande que ñee nyii resẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Quiatu nembae denario rerao cote. Ae ɨque ramo nae, ũquɨ̃ je abe denario tamee mee nde rã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Sembae ae rese aɨco nguiã. Sembae amondose mose emo je, ¿amondo aroneate se re? Se sembae mee mose emo je, ¿ndebiãte ũquɨ̃ nde?” ɨ que echa ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ae rane eriqui nyii nae, ũquɨ̃ nda siqui mbia ruɨ tuchɨ cote. Ae siqui quia mbia ruɨ tuchɨ nyii nae, ũquɨ̃ nane nda cote. “Jenyu seruɨ” ɨ tuchɨ Dios quia mbia ja je co. Mbia mɨɨ mɨɨ ño eisirõ sirõ nguiã co, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús que ngata oso quia Jerusalén quiti ra. Uchɨmbaaquiatu que equerao mbia tiãsaa ñee sacuã ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Co nyao quia Jeursalén co. Huee ra mbia semee sacerdotes rerecua je. Embesasa abe je. “Jesús jẽɨquia”, ɨ ra serɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Semee nda judíos eã je cote. Seɨquia sacuã. Mbia ra secheẽ saã saã. Seiruã nua abe ra eno. Sembucha chee ra ɨquia ira rese. Tres nyaashɨ̃ mose ra aquera sɨ, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ari mo ngue oso Jesús rɨɨchã nda. Jacobo si. Juan si. Zebedeo riirĩ ngue ũquɨ̃ nda. Ari que oso Jesús rɨɨchã nguiirĩ ndese ra. Ngoi que ngũíã ndese ñee Jesús je ra. —Mbae mo esaã na seje, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—¿Mbae ra aba saã ndeje re? ɨ que Jesús ñee ari je ra. Ari que ñee ee ra. —Ndeɨco mose ererecua tuchɨ, sã seriirĩ abe riqui ererecuarã nderese. Sã seriirĩ ngoi ja u ndejii. Enongue chɨ̃ ngoi ndequito cuti. Enongue ndequiato cutiã no, ɨ rei que ari ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús que ñee ee ra. —Ae rɨɨ̃ jẽɨngo ñee seje nae, jẽirandu turã eãte ũquɨ̃ ndese. Ae rasi ra asaã tuchɨ nae, ¿ũquɨ̃ ndasi ra jẽsaã jẽ abe re? ɨ que Jesús ee ra. “Ae”, ɨ que ari riirĩ ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús que ñee ee ra. —Ae beɨ. Ae rasi ra asaã tuchɨ nae, ũquɨ̃ ndasi ra jẽsaã tuchɨ raque jẽ abe. “Ererecuarã ure”, jenye que seje, ũquɨ̃ asaã aroneate se jẽje. Paba ae quiatu ra ũquɨ̃ saã. Ae ebite, ũquɨ̃ nda emɨɨ ererecuarã, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Echɨmbaaquiatu ataque que jirandu erese ra. Echɨmbaaquiatu diez. Paama ɨ que Juan je ra. Jacobo je abe. ");
INSERT INTO srqNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús que “jenyu” ɨ ñee uchɨmbaaquiatu ja je cote ra. —Mbia ataque rerecua riqui ucuasu raã naa tuchɨ ngũimba je ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ũquɨ̃ nda jẽsaãchɨ̃ jẽ. “Ererecua ra se”, ɨ mose jemo, sã aque riquichõ uataque rimbarã. ");
INSERT INTO srqNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Jemo “se rane jẽ” ɨ mose, sã ũquɨ̃ ndiqui beɨ mbae turã naa naa uataque je. ");
INSERT INTO srqNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","“Sã mbia mbae turã naa naa seje”, ae eã ngue u ra. “Se quiatu mbae turã tasaã saã mbia je”, ae u nguiã. Co achu quia mano mbia tubɨrɨã ndiquicharõ sacuã co, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús que ngata oso quia Jericó sɨ ra. Uchɨmbaaquiatu rese. Mbia tubɨrɨã ngue nyoɨ quia eruɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eresayã nyeremo ngue chɨ ñeenda jie ee ra. Eresayã ngue jirandu Jesús ucua rese ra. Ñeemombo mombo que Jesús je ra. —¡Sererecua! ¡David rucucha! ¡Ndeya eã ño urerese jẽ! ɨ que eresayã ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","—¡Jẽquɨrɨrɨ chõ jẽ! ɨ tuchɨ rei que mbia ñee ee ra. —¡Sererecua! ¡David rucucha! ¡Ndeya eã ño urerese jẽ! ɨbe que eresayã ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús que tiba ñee ee cote ra. —Jenyu rã. ¿Mañɨ ae ra jẽje re? ɨ que Jesús ñee eresayã je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Ureresa embuturã na, Urererecua, ɨ que eresayã ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús ia eã tuchɨ que erese ra. Oco ja que eresa rese ra. Aque mose tuchɨ que eresayã ndesa turã ja cote ra. Mae turã ngue cote ra. Jesús ruɨ que echoɨ quia cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesús que Jerusalén curubite nyoɨ quia ra. Betfagé, ɨ que hue sucha je ra. Ibi ibate mo abe que chɨ̃ huee ra. Monte de los Olivos, ɨ que hue je ra. Hue sɨ que Jesús uchɨmbaaquiatu nyeremo mondo ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ñee ngue ee ra. —Achɨ súchaa chõ jẽso rã. Burro cuasa ra chɨ̃ nguiirĩ ndese jẽje huee. Ũquɨ̃ jenyura seru seje. ");
INSERT INTO srqNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Emo ñee mose jẽje, “¿mbaerã nda jenyura re?” ɨ mose jẽje, jeñee ee. “Nandererecua que ‘jendu’ ɨ ra. Mondo jeɨbe ra jẽje”, jenye ee, ɨ que Jesús ñee ũquɨ̃ nyeremo mondo ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Embesa ji cheẽ ɨo sacuã ño ngue ũquɨ̃ nda. Ɨ embesa ji huɨ̃ a: ");
INSERT INTO srqNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jeñee Jerusalén jenda je. “¡Sã jẽ! Jenderecua ru quia jẽje burro ato co. Ucuasu esaã saã eãte u quia co. Burro riirĩ átoo eru quia co”, jenye ee, ɨ que embesa ji huɨ̃ nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ũquɨ̃ nyeremo ngue Jesús mondo cote ra. Ae rɨɨ̃ Jesús ñee ee nae, ũquɨ̃ ngue nyecua ja ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burro que ecuruchoɨ Jesús je ra. Huɨɨrao que echono ñono burro quite arõ nda. Burro riirĩ quite arõ abe. Jesús que nyuɨ eato cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jesús que ngata rei oso quia burro átoo ra. Mbia tubɨrɨã ngue huɨɨrao mbiitee tee nyoɨ quia ibi rɨ̃ enonde ra. Emo emo ngue sɨndo mbiitee tee ee no nda. Jesús oso sacuã hue rɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mbia ia tuchɨ que tasẽ tasẽ nda. —Co nandererecua ru quia ngasẽte co. Co Dios chɨmbu ru quia ngasẽte nande je co. David rucucha ru quia co. Dios turã tuchɨ riqui nande je co, ɨ tuchɨ que mbia quia ñee nda. Ae nyoɨ quia Jesús nonde nae, ũquɨ̃. Ae nyoɨ quia eruɨ nae, ũquɨ̃ abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús que ngasẽ Jerusalén cote ra. Mbia hue jenda ia tuchɨ que o o ja erese ra. —¿Aba co re? ɨ tuchɨ que equia Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mbia ataque que echeẽ sɨbɨshorõ nda. —Dios chɨmondo chõ co re. Jesús ɨ equia ee. Nazaret de Galilea jenda chõ ae re, ɨ que ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús que oso Dios chuchúaa ra. Huee que mbia riqui mbae isi isi beɨ ra. Mbae mondo mondo abe mbae isiquia rɨbɨshorõ. Ũquɨ̃ ja que Jesús mombo hue sɨ ra. Ae mbae isiquia sɨbɨshorõ shorõ nguia, ũquɨ̃ mbae abe que embuchiichere chere ja mesa ra. Mesa aronda resebe. Ae nyurushɨ cuasu mondo mondo mbia je mbae rɨbɨshorõ nae, ũquɨ̃ nenda abe que embuchiichere chere ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesús que ñee ũquɨ̃ ja je ra. —“‘Mbia cheẽsa Dios je’, ɨ ra mbia Dios chuchua je”, ɨ rei que embesa ji huɨ̃ nda. Jẽ nguia jẽɨcuã tuchɨte Dios chuchu a je re. Mbae mbuquiachãsa chuchua jẽsaãte chɨ̃ nguiã ee, ɨ que Jesús ñee asite ũquɨ̃ je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesús siqui mose Dios chuchúaa, mbia resayã ngue nyoɨ nyoɨ erea huee ra. Mbia cuatayã abe no. Jesús que ũquɨ̃ mbucherõ ja ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ererecua cuabẽte que chɨ mae ɨcuã ɨcuã erese ra. Sacerdote rerecua abe no. Embesasa abe no. Jesús chɨsaã turã ndese mae mose que paama ɨte ee no ra. —David rucucha turãte riqui co, ɨ mose mbia riirĩ Jesús rɨɨ̃, ũquɨ̃ mose que ererecua paama ɨ ja Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","—¿Mbia riirĩ ñee erechandu quia re? ɨ que ũquɨ̃ ñee Jesús je ra. Jesús que ñee ee cote ra. —Ae. ¿Embesa ji rese jemae eãte re? “Dios ra mbia riirĩ mbucheẽ turã uturã nɨɨ”, ɨ que embesa ji ra, ɨ que Jesús ñee ererecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesús que oso mbia rerecua recha ja cote ra. Sucha tubɨrɨã abe recha. Oso que Betániaa nda. Huee que itõ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Isamamɨmbe que Jesús choɨ sɨ́ quia sucha tubɨrɨã nda. Eriãcuãte abe que nyoɨ quia ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Higo i mo ndese que mae ñeenda jie ra. Sɨɨchã ndei que oso ra. Ea eãte que ee ra. Ero achõte chõ ngue ee ra. Nyebe Jesús ñee nguiã higo i je. —Ndea eã mbeɨ r a cote, ɨ que Jesús ñee ee ra. Aque mosebe tuchɨ que esɨ quia ñɨmama mano nda. ");
INSERT INTO srqNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Echɨmbaaquiatu que nyuruɨra tuchɨ mae erese ra. —¿Mañɨ higo i quia ñɨmama asite mano nde? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús que ñee ee ra. —Tacheẽ nyecua jẽje. Ae asaã higo i je nae, jẽ abe ra ũquɨ̃ jẽsaã serã sɨ́, jẽ Dios jẽɨcua tuchɨ mose. Jeñee nyee ra sɨta ibate mo je. “Esiri rã oso am a ndɨsha ye”, jenye chee ra sɨta ibate mo je. Sɨta ibate ra jeñee mumbayã jẽ Dios jẽɨcua tuchɨ mose. ");
INSERT INTO srqNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“Ã emondo seje”, jenye mose Dios je, mondo r a jẽje. “Dios ra emondo seje”, jenye mose jeñɨangui re, Dios ra emondo jẽje, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesús que oso Dios chuchúaa ra. Huee que eriqui mbia mbaaquiatu quiatu ra. Sacerdote rerecua que nyoɨ ñee ee ameɨ ndese ra. —¿Mbaerã ereɨco mbia mbaaquiatu quiatu Dios chuchúaa re? ¿Aba “ũquɨ̃ esaã saã” ɨ ndeje re? ɨ que ererecua ñee ja Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús que ñee ee ra. —Se rane tacheẽ jẽje. Se rane preguntar tae jẽje. Secheẽ jẽsɨbɨshorõ turã mose, ũquɨ̃ mose quiatu ra jeñee asɨbɨshorõ turã se abe. ");
INSERT INTO srqNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Aba ñee Juan je re? “Eso bautizar ɨ mbia je” ɨ ee re. ¿Dios eã ño ere? Jeñee seje, ɨ que Jesús ee ra. Ererecua que ndua ndua ja u cote ra. Ñee ñee ngue u nyue ra. —¿Mañɨ nande ra echeẽ ndobeɨshɨ̃ nde? “Dios que Juan mbu ra”, nande aroneate ñee ee. Nyebe ra ñee nande je. “¿Mbaerã jẽɨngo eãte eruɨ re no?” ɨ quiarei ra nande je. ");
INSERT INTO srqNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Dios eã ngue embu ra”, nande aroneate ñee ee no. Mbia ataque ra paama ɨ tuchɨ nande je. Juan quiato tuchɨ quiarei mbia, ɨ que ererecua u ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ererecua que ñee nyee Jesús je cote ra. —Ureɨcuayãte. Aba chõ Juan mbu bautizar ɨ sacuã mbia je, ɨ que ererecua ñee ja Jesús je ra. Jesús abe que ñee ee cote ra. —Se abe tacheẽ eã ndei jẽje no. Ae “ã esaã” ɨ seje nae, aque rɨɨ̃ nda acheẽ eã jẽje no, ɨ que Jesús ererecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús que ñeembe ee ra. —Ɨ ra ã jẽje reae. Sã ameɨ mo ndiirĩ nyeremo no. “Quiatu rã uvas ɨshao shao seje”, ɨ que ameɨ nguiirĩ ndiquii je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Nya” ɨ rei que eriirĩ ndiquii ñee ngu je ra. Aquere que ndua sɨ chõ oso uvas ɨshao shao ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Quiatu rã uvas ɨshao shao seje”, ɨ rei que ameɨ ñee nguiirĩ nduɨnda je cote ra. “Se quiatu taso, Paba”, ɨ rei que ee ra. Osoã ño ngue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ma ngu cheẽ mumbayã ũquɨ̃ mo nde? ɨ que Jesús ñee judíos rerecua je ra. —Eriquii chõ ngue ngu cheẽ mumbayã ndesẽ, ɨ que ñee ee ra. Jesús que ñee ee ra. —Tacheẽ nyecua jẽje. Cuñandu ata ata riqui Dios cheẽ andu turã jẽsɨ ã. Impuestos isi isiquia abe riqui Dios cheẽ andu turã jẽsɨ ã. Ũquɨ̃ nda siqui tuchɨ Dios rese jẽsɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“Eɨ̃ jenye chõ siqui turã Dios je”, ɨ rei que Juan el Bautista jembaaquiatu quiatu ra. Jẽ nguiatu que echeẽ jemumbate ra. Cuñandu ata ata quiatu que echeẽ isi turã nda. Impuestos isi isiqui a rese. Ũquɨ̃ ndese mae mose abe que jẽya eã eã jẽɨcuã ndese no nda. Jẽ echeẽ isi turã sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ã abe jeñandu. Sã mbia ibicha mo ndiqui no. Sã eriqui uva i tiquia tiquia no. Sã etarõ no. Uva rique rirurã abe que echao ra. Sucha ibate mo abe que echao ra. Uco raarõ turã ja sacuã. “Sembae uvas jẽsaarõ”, ɨ que emo je cote ra. Ae que oso ɨsho itõte cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uva quiche mose que ngũimba mo mondo rei umbaerã ndea ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Uva raarõsa que erimba mbucuasẽ ɨcuã ño nda. Iruã nua ño ngue ra. Echa que ngũimba nongue mo abe mondo rei erea ra. Eraarõsa que aque ɨquia ra. Enongue que echeɨ cheɨ tuchɨ mbuqui sɨta je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Eɨ̃ eɨ̃ mbeɨ que eraarõsa quia echa rimba ja je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Aquere que echa nguiirĩ mondo erea cote ra. “Ɨreɨ̃ ɨreɨ̃ jiri ra seriirĩ sɨ”, ɨ rei que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Uva raarõsa mae mose erese que ñee nyue ra. “¡Co eriirĩ ndu quia co cote jẽ! ¡Nandeɨquia rei jẽ! Ɨ̃ nda uvas nandembaerã ae tuchɨ cote”, ɨ que ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eraarõsa que eriirĩ isi ɨcuã cote ra. Curuchoɨ que pe jiri ɨquia ra. Mano ngue cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","¿Mañɨ nda echa quia eraarõsa je cote re? ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mbia que ñee ee ra. —Echa ra eraarõsa ɨcuã ɨquia ja cote. Uva i ra emondo emo je eraarõ sacuã cote. Ũquɨ̃ nguia ra embaerã mee turã turã ee equiche mose, ɨ que mbia ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús que ñee mbia je ra. —¿Ã embesa ji rese jemae ãte re? Sã emo ndiqui tuchua ao sɨta je no. Sɨta mo ngue equirirõ mombo ra. Eɨcuãte eriqui reĩ nguiã ee. Aquere Dios emundua sɨ erese. “Earonda sacuã turambi chõ eriqui re”, ɨ ndua sɨ uchɨmombo rese. Uchɨmombo que esirõ sɨ cote ra. Dios chɨao chõ ũquɨ̃ nde. Dios chɨao turã tuchɨ riqui nande je ã, ɨ ñɨ embesa ji re. ");
INSERT INTO srqNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tacheẽ nyecua jẽje. Jenderecua eã nyee ra Dios cote. Ae mbiamo nda Dios ɨcua nae, ũquɨ̃ nderecua quia ra Dios cote. ");
INSERT INTO srqNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ae ra ngoɨ aque sɨta arõ nae, ũquɨ̃ nda huẽ. Aque sɨta ngoɨ mose emo arõ, ũquɨ̃ nda mano no, ɨ que Jesús ra. —Aque sɨta rã ndei se, ɨ chõ ngue re. ");
INSERT INTO srqNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sacerdote rerecua que Jesús cheẽ ñandu ja ejemplos ra. Fariseos abe echandu ja. —Urerɨɨ̃ ño eriqui nguiã ñee co, ɨ que ndua ndua ra. ");
INSERT INTO srqNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Paama ɨ tuchɨ que Jesús je ra. Jesús nda eisi ɨcuã nguiã ña. Siquiche quiatu que mbia sɨ ra. —Dios cheẽ na sɨ tuchɨ chõ Jesús riqui nguiã ñee co, ɨ jate quiatu que mbia ataque quia ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús que ejemplo mo senei mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—“Jenyu serea”, ɨ raque Dios quia emo emo je co. Sã ererecua mo ndiqui ñee mbia je no. “Jenyu quiaru serese”, ɨ rei que uquiato je ra. Eriirĩ ngũinisi rea ramo mose. ");
INSERT INTO srqNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mbae quiche ja mose que ngũimba mo mondo rei mbia mbiirandu ra. Mbia que ngaẽ sereã nea ja chõ erea ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ngũimba mo ngue emondobe rei erea ra. “Mbae quiche jate que ra. Ticuasu quira tuchɨ que equishɨ̃ nda. Eriirĩ ngũinisirã isi ramo ndese jẽso mae. Jẽso quiaru erese”, ɨ rei que erimba mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ae je “jenyu” ɨ nae, ũquɨ̃ ngue echeẽ mumba ja chõ nda. “Co aso quia seco co”, ɨ que emo nda. “Co aso quia mbae mo naa naa se co no”, ɨ que emo no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mbia que teã teã ja ra. Ererecua rimba iruã nua ño ngue ra. Eɨquia chee. ");
INSERT INTO srqNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ũquɨ̃ mose que ererecua paama ɨ tuchɨ ra. Soldados que emondo ngũimba ɨquiasa ɨquia ɨquia ra. Echuchua abe rei rei. ");
INSERT INTO srqNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ererecua que ñee ngũimba je cote ra. “Mbae quiche chɨ ja raque a. Ae je ‘jenyu’ ae rei nyii nae, sã ũquɨ̃ ngaẽ eã. Eɨcuãte quia ñene. ");
INSERT INTO srqNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jẽso ñee mbia ja je. Ɨshonda ja je. ‘Jenyu ja ererecua riirĩ ngũinisi rerequia ramo ndese mae’, jenye oso quia mbia mbuchesea sea”, ɨ que ererecua ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Erimba que nyoɨ mbia mbiirandu randu ja ra. Mbia turã mbiirandu. Mbia ɨcuã abe mbiirandu randu no. Mbia que ngaẽ tuchɨ cote ra. Tuchua itãyã nyee que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ererecua que ɨque mbia tubɨrɨã ndese mae cote ra. Emo ɨrao ɨcuãte que chɨ̃ ee huee ra. Tiru ererecua chɨmondo emingue eã ñochɨ̃ nguia reaẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ererecua que ñee ee ra. “Seriirĩ ndiqui ngũinisirã isi a resẽ. ¿Mbaerã ndeɨrao turã eremingue eã nde?” ɨ que ererecua ñee ee ra. Ñee eãte que ererecua cheẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ererecua que ñee ngũimba je cote ra. “Co jẽisi jẽ. Eo jenyucua. Ei abe jenyucua. Jenosẽ serao mombo itaicuee itondaruqui re. Huee ra nyeseo tuchɨ. Huee ra ureɨ̃ quiti quiti tuchɨ”, ɨ que ererecua ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Jenyu seruɨ” ɨ tuchɨ Dios quia mbia ja je co. Mbia mɨɨ mɨɨ ño eisirõ sirõ nguiã co, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","—Jesús nandembucheẽ ɨcuã na. Ɨ̃ nda mbia paama ɨ ee, ɨ que fariseos ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nyebe fariseos uchɨmbaaquiatu mo mondochoɨ nguiã Jesús rea. Herodes chɨmbaaquiatu rese. Jesús mbucheẽ ɨcuã sacuã ño ũquɨ̃ nde. Uturã ngue esaã ñooño Jesús je ra. —Jesús, co ereɨco mbia mbaaquiatu quiatu turãte co. Ndeturãte ereɨco mbia ja je co. Co ereɨco turãt e mbia mbuchiabiã co. Mbia erembaaquiatu quiatu turãte quia Dios ɨcha rɨɨ̃ co. ");
INSERT INTO srqNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nyebe urechu nguiã ñee ndeje a. ¿Coche mbia mbae isiqui a mee mee Romano nderecua je re? ¿Uremee nda ee re? ¿Uremee eã nda ee re no? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús que ũquɨ̃ ɨcuã ɨcuate ra. Nyebe ñee nguiã ee. —¿Mbaerã jẽɨngo “ɨ̃ nda Jesús ucheẽ nyabi”, ɨ serɨɨ̃ nde? ");
INSERT INTO srqNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mbae isiquia mo jẽteacuquia ɨmbu seje, ɨ que ee ra. Mbia que eteacuquia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","—¿Aba mbae nombre ñɨ mbae isiqui a rese a re? ¿Aba ãquĩ aingue abe ñɨ a re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Romano nderecua, ɨ que ñee Jesús je ra. Jesús que ñee ee cote ra. —Romano nderecua mbaerã jemee ño ee. Dios mbaerã jemee ño ee no, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mbia que nyuruɨra jate u Jesús cheẽ andu ra. Nyoɨ ja que erecha cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","—Mbia raaque ra quera eã mbeɨ, ɨ que mbiamo nguia ñee nda. Saduceos ɨ que ũquɨ̃ je ra. Ũquɨ̃ mo ngue nyoɨ ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Sererecua, ã ngue Moisés mbesa nande je ra: “Emo mano mose eriiriã, sã enongue mano je ninisi rerequia erendaque re. Sã tiirĩ ngõngue raaque rɨɨ̃”, ɨ que Moisés embesa nande je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Eriquii mo ngue siqui urerese ra. Seis que eribi ra. Eriquii que ngũinisirã quereco rei ra. Mano ño ngue tiirĩ ndocoɨ̃ ngũinisi recha ra. Enongue que nguiquii checha quereco rei cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ae abe que mano ño tiirĩ ndocoɨ̃ no nda. Ũquɨ̃ seis que ngõngue cheecha quereco ja rei ra. Mano ja chõ ngue tiirĩ ndocoɨ̃ no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Eninisi eru cheecha que mano nyee chõ cote no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Siete rei que eru nyii ra. Mbia raaque quera sɨ ja mose, ¿abate ra equereco cote re? ɨ que saduceos ñee Jesús je ra. —Ma Jesús ñee ɨcuã, ɨ chõ ngue re. ");
INSERT INTO srqNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús que ñee ee ra. —¿Mbaerã jẽɨngo Dios cheẽ ɨcua eãte ã nde? Jẽɨngo Dios cheẽ abi tuchɨ ã. Jẽɨngo Dios quirãcuã ɨcua eãte ã. ");
INSERT INTO srqNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ae raaque ra Dios mbuquera sɨ nae, ũquɨ̃ nda ngũinisi quereco eã mbeɨ huee cote. Ũquɨ̃ nda ngu quereco eã mbeɨ huee cote no. Angeles rã mbeɨ ra mbia riqui huee ibate cote. ");
INSERT INTO srqNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mbia raaque quera sɨ rɨɨ̃ ño ngue Dios jembiirandu rei ra. ¿Embesa ji rese jemae ãte re? ");
INSERT INTO srqNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ã ño Dios cheẽ embesa ji re: Abraham nderecua chõ aɨco nguiã se co. Isaac nderecua abe. Jacob rerecua abe no, ɨ que embesa ji ra. Ã ngue mano ndei nyii ra. Ereco siqui beɨ chõ nguiã namo ã. Mbia raaque rerecua eã ño Dios re. Mbia reco rerecua chõ ae re, ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mbia tubɨrɨã ngue chɨ nyuruɨra tuchɨ eandu ra. Jesús mbae ɨcua ja mose. ");
INSERT INTO srqNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesús cheẽ aquiatu tuchɨ que ra. Nyebe saduceos cheẽ mbutiba nguiã. Fariseos jirandu mose erese que ñumunua ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","—Se chõ tacheẽ Jesús je. Ma Jesús ñee ɨcuã, ɨ rei que fariseo mo nda. Embesasa que ae ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Jesús, Dios cheẽ tubɨrɨãte riqui ã ndesẽ. Mbia echeẽ mumbayã sacuã. ¿Ma Dios cheẽ ndiita tuchɨ ma nde? ɨ que fariseo ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús que ñee ee ra. —Ã ño Dios cheẽ ndiita ã nde: “Echesecua tuchɨ quia Dios rese. Ndechɨã je. Neaĩ je abe. Nendua ndua je abe”. ");
INSERT INTO srqNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ũquɨ̃ ño Dios cheẽ ndiita ũquɨ̃ nde. Ũquɨ̃ ño Dios cheẽ ñiinda ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ã abe rei ũquɨ̃ nduɨnda ã no: “Sã ereɨco nyesecua ndechɨese no. Eɨ̃ ere sɨ chõ nyesecua mbia rese”. ");
INSERT INTO srqNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moisés chɨmbesa tuchɨ chõ ũquɨ̃ nde. Dios quiato cose ndare chɨmbesa ja chõ ũquɨ̃ nde, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseos chɨchõ mose ñumunua ngue Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Aba rucucha Cristo re? ¿Aba jenye equia ee re? ɨ que Jesús ñee ee ra. —David nducucha chõ ñene, ɨ que fariseos ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús que ñee ee cote ra. —¿Mbaerã David “sererecua” ɨ ee re no? Espíritu turã embucheẽ mose. ");
INSERT INTO srqNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ã ngue David ñee nda: Dios que ñee Cristo sererecua je ra: “Ecoi sejii. Nde abe ra ererecua serese. Ae ndeucuayãte quia nae, ũquɨ̃ je ra ndequirãcuã ateacuquia tuchɨ. Ndequirãcuã tuchɨ chee ra ũquɨ̃ sɨ”, ɨ que Dios ñee sererecua je ra, ɨ que David ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David sɨ́ chõ “sererecua” ɨ nguiã Cristo je. Cristo David rucucha mose, ¿mbaerã David “sererecua” ɨ ee re? ɨ que Jesús fariseos je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ũquɨ̃ ngue ñee aquiatuãte Jesús cheẽ ndɨbɨshorõ nda. Aque mose beɨ que mbia preguntar ɨ eã mbeɨ Jesús je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesús que ñee uchɨmbaaquiatu je ra. Mbia tubɨrɨã je abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Fariseos rã nda jẽɨngochɨ̃ jẽ. Embesasa rã abe ra jẽɨngochɨ̃ jẽ. “Ure quia Moisés chɨmbesa ureɨcuate nguiã ure ã”, ɨ chõ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Coche jẽɨngo nguiã echeẽ mumbayã ndaque. Erã sɨ́ quia nda jẽɨngoã nguiã. Echeẽ turã turãte raque. Siqui turã eãte quiatu nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dios cheẽ embeta mbeta tuchɨchɨ̃ nguia mbia je ã. Mbia echeẽ mumbayã aroneate chee quia ã. Eya eã eãte eriqui mbia rese ã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mbae turã naa mose, mbia mae sacuã erese chõ ũquɨ̃ nde. Tiru huɨɨrao ibi quitinda ai mbɨɨcoɨ tuchɨ equia ã. Dios cheẽ mbesa ji echucua beɨ quia uchiba cúa rese ã. Mbia mae sacuã erese chõ eriqui nguiã ũquɨ̃ naa naa ã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aba mbia eã tuchɨ fariseos. “Serendarã turã nguiatu se jẽ”, ɨ tuchɨ equia mbia chumunua nua mose ã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","“Sã mbia ererecua ɨ nande je”, ɨ beɨte equia ã. Ebi tuchɨ “mbia mbaaquiatusa” ɨ mose ee. ");
INSERT INTO srqNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Mbia mbaaquiatusa rei se”, jenyechɨ̃ nda jẽ. Se mɨɨ ño jembaaquiatusa re. Nyɨesenda chõ jẽ nde. ");
INSERT INTO srqNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","“Paba” jenyechɨ̃ nda mbia mo je jẽ. Jendu mɨɨ ño siqui nguiã ibate pe. ");
INSERT INTO srqNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","“Ererecuarã se”, jenyechɨ̃ nda eno. Se mɨɨ ño jenderecua re. ");
INSERT INTO srqNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jemo siqui mingue mose, mbae raã naa mose uataque je, aque quia ra ererecuarã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ae ucuasu raã naa nguia nae, mbia ñetẽ nda Dios saã ño ũquɨ̃ je. Ae siqui mingue quia nae, mbia rerecuarã ño nda Dios saã ũquɨ̃ je. ");
INSERT INTO srqNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Aba mbia eã tuchɨte jẽ, Embesasa. Aba mbia eã tuchɨte jẽ abe no, Fariseos. Jẽcuasu jẽsaã saãte quia ã. Jẽɨngo sereãte quia Dios rese ã. Mbia siquise mose Dios rese, jẽɨngo emingo eãte erese ã no. ");
INSERT INTO srqNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Aba mbia eã tuchɨte jẽ. Eru cheecha mbae jembutiã tiã ñochɨ̃ nguia ã. Ũquɨnde jẽɨngo chõchɨ̃ ñee oco oco Dios je ã no. “Ɨ̃ nda mbia mae nanderese” jenye chõchɨ̃ equia ã. Nyebe ra Dios jembasi tuchɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Aba mbia eã tuchɨte jẽ, Embesasa. Aba mbia eã tuchɨte jẽ abe no, Fariseos. Jẽcuasu jẽsaã saãte quia ã. “Jẽɨngo ure ruɨ” jenye beɨ chõchɨ̃ equia mbia je ã. Ũquɨ̃ mo siqui mose jenduɨ, eɨcuã tuchɨ chõ ũquɨ̃ abe cote re. ");
INSERT INTO srqNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Aba mbia eã tuchɨte jẽ. Sã eresayã mo ndiqui emo ndesayã mbuti echiba rese no. Ũquɨ̃ na ño jẽ nde. Jẽaquiatuã ño mbia mbaaquiatu quiatuchɨ̃ nguiã. “Jurar jenye mose Dios chuchua rɨɨ̃, coche jeñee jembuchebi nguiã”, jenye chõchɨ̃ nguia mbia je ã. “Jurar jenye mose oro Dios chuchua jenda rɨɨ̃, ũquɨ̃ mose quiatu jeñee jembuchebi aroneate nguiã”, jenye chõchɨ̃ nguia mbia je ã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¿Oro quiatu ɨ tuchɨ jiri Dios chuchua sɨ re? ¿Mbaerã jẽaquiatuãte riqui re? ");
INSERT INTO srqNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Jurar jenye mose altar rɨɨ̃, coche jeñee jembuchebi nguiã”, jenye chõchɨ̃ nguia mbia je ã. “Jurar jenye mose ofrenda altar jenda rɨɨ̃, ũquɨ̃ mose quiatu jeñee jembuchebi aroneate nguiã”, jenye chõchɨ̃ nguia mbia je ã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Eresayã na tuchɨ chõ jẽɨngochɨ̃ nguiã. ¿Mbaerã jẽaquiatuãte riqui re? ¿Ofrenda quiatu ɨ tuchɨ jiri altar sɨ re? ");
INSERT INTO srqNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jurar jenye mose altar rɨɨ̃, earonda abe rɨɨ̃ ño jẽɨngo nguiã jurar ɨ ofrenda. ");
INSERT INTO srqNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jurar jenye mose Dios chuchua rɨɨ̃, Dios abe rɨɨ̃ ño jẽɨngo nguiã jurar ɨ. Dios abe quia siqui nguiã uchuchua huee. ");
INSERT INTO srqNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jurar jenye mose ibei rɨɨ̃, Dios renda abe rɨɨ̃ ño jẽɨngo nguiã jurar ɨ. Dios sɨ́ rɨɨ̃ abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Aba mbia eã tuchɨte jẽ, Embesasa. Aba mbia eã tuchɨte jẽ abe no, Fariseos. Jẽcuasu jẽsaã saãte quia ã. Décimo jemee mee ndaque quia Dios je mbae ñetẽ nɨɨ. Comino. Menta. Anís. Dios cheẽ ndiita quiatu jemumba mumbate nguiã. Dios jẽɨcua rã nyii. Jẽɨngo turã na nyii. Jẽya eã na mbia rese nyii. Aquere quiatu mbae ñetẽ jẽsaã cote. ");
INSERT INTO srqNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sã eresayã mo ndiqui emo ndesayã mbuti echiba rese no. Ũquɨ̃ na ño jẽ nde. Mbae ñetẽ jẽsaã turã turãte raque quia ã. Dios cheẽ ndiita quiatu jemumba mumbate nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Aba mbia eã tuchɨte jẽ, Embesasa. Aba mbia eã tuchɨte jẽ abe no, Fariseos. Jẽcuasu jẽsaã saãte quia ã. Sã emo ndiqui i riru ɨreɨ ɨreɨ earonda no. Eɨmɨ nguiatu eɨreɨ quiiriãte re. Eɨ̃ ño jẽ no nde. Jẽturã aba reã ño jẽaronda no nde. Jeñɨangui renda quiatu eɨcuã ɨcuãte re. Mbae quia jembuquiachã quiachãte nguiã. Mbae abe quia jenyoseɨ ɨcuã ɨcuãte nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Eresayã na tuchɨ chõ jẽɨngochɨ̃ jẽ nde, Fariseos. Jeñɨangui renda rane nguiatu jẽɨreɨ. Jẽaronda abe ra equishĩ cote. ");
INSERT INTO srqNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Aba mbia eã tuchɨte jẽ, Embesasa. Aba mbia eã tuchɨte jẽ abe no, Fariseos. Jẽcuasu jẽsaã saãte quia ã. Mbia raaque tãsa rã ño jẽɨngo nguiã. Eati ji turãte raque. Eɨmɨ ye quiatu mbia raaque quiangue chɨ nguiã hue. Eroo cuɨ́ abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Eɨ̃ sɨ chõ jẽ nde. Jẽaronda turãte aba reã ndiqui raque mbia je. Jeñɨangui rend a quiatu eɨcuãte re. ");
INSERT INTO srqNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Aba mbia eã tuchɨte jẽ, Embesasa. Aba mbia eã tuchɨte jẽ abe no, Fariseos. Jẽcuasu jẽsaã saãte quia ã. Ae mbia turã mano cose nae, ũquɨ̃ tãsa jembiitã turã mbeɨte raque quia ã. Dios cheẽ mbuchecuasa tãsa abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","“Cose ureɨco mose, ɨ̃ nda ureɨcuã eãte rei Dios quiato je. Urerameɨ na eã”, jenye raque equia ã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Mbia ɨquia ɨquiasa riirĩ ño ure re”, jenyete equia ũquɨ̃. Jendu rã sɨ tuchɨ jẽ. Mbia ɨ quiasa. ");
INSERT INTO srqNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jenameɨ ɨcuã na sɨ chõ jẽɨngo no. ");
INSERT INTO srqNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mbeɨ tásie rã tuchɨ chõ jẽ nde. Eɨ̃ jenye beɨ oso quia aque ngasẽ nyee tata cuasu. ");
INSERT INTO srqNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nyebe ra Dios cheẽ mbuchecuasa amondo mondo quia jẽje. Mbia mbaaquiatusa ra amondo jẽje. Mbia aracua abe no. Jẽ nda sechɨmondo emo emo jẽɨquia. Emo emo nda jẽiruã nua mbia chumunuásaa no. Jẽɨco ɨco ra equia erese eɨquia chee. ");
INSERT INTO srqNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ae Dios quiato ɨquia ɨquia quia cose nae, ũquɨ̃ nɨɨ nda Dios jembasi cote. Sã mbia Abel ɨquia cose no. Sã mbia Zacarías abe ɨquia Dios chuchua jii no. Berequías riirĩ ndei aque. Sã mbia Dios quiato ɨquia ɨquia beɨ cose no. ");
INSERT INTO srqNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ũquɨ̃ ja rɨɨ̃ nda Dios jembasi cote. Acheẽ nyecua quia jẽje a. ");
INSERT INTO srqNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tacheẽ na jẽje, Jerusalén jenda. Seya eãte aɨcochɨ̃ jendese co. Hue jẽɨngo mbia ɨquia ɨquia beɨte hue. Dios cheẽ mbuchecuasa ɨquia ɨquia. Dios chɨmondo abe ɨquia ɨquia no. Sã nguira riqui nguiire reaquiatu mondo ujeoqui re no. “Eɨ̃ tae jendeaquiatu”, ae beɨte rei nguiã jẽje co. Secheẽ jẽisi sereã mbeɨ chõchɨ̃ nguia ã. ");
INSERT INTO srqNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","¡Aɨco jendecha a cote jẽ! ");
INSERT INTO srqNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jemae mae eã nda serese cote. Sechube mose ibate sɨ, aque ramo mose ra jemae serese cote. “¡Co chɨ Dios rucucha ru quia co cote jẽ!” ɨ ra mbia seisi turã aque mose cote, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús que oso usẽ Dios chuchua sɨ cote ra. Ecuata mose que echɨmbaaquiatu ñee ee ra. —Sã Dios chuchua turã tuchɨte jẽ, ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús que ñee ee ra. —Tacheẽ nyecua rã jẽje. Ae rese jẽɨngo mae ã nae, ũquɨ̃ nda mbia mbucoɨ ja cote. Sɨta mo nda chɨ eã nyɨchuarõ Dios chuchua cote. Mbia ra Dios chuchua mbucoɨ ja tuchɨ cote, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesús que chɨ̃ ngoi huee ibi ibátee mo nda. Monte de los Olivos ɨ que hue je ra. Echɨmbaaquiatu que ngasẽ ñee eísaa ra. —¿Manosete ra ũquɨ̃ nde? ¿Mbae ra urembiirandu nderese ndechu serɨ̃ mose re? ¿Mbae ra urembiirandu mbae ua ja serɨ̃ mose re no? ɨ que echɨmbaaquiatu ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús que ñee ee ra. —Jẽtesa jiri quia jẽ. Mbia mo nda jembɨɨrɨ̃ ɨrɨ̃chɨ̃ ñee jẽje jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","“Cristo chõ se re”, ɨ ra mbia ñee ata atate jẽje. Ũquɨ̃ ñee nda jeñanduchɨ̃ jẽ. Ũquɨ̃ nda mbia mbɨɨrɨ̃ ɨrɨ̃ jate. Ñee ñooño je chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mbia ra guerras saã saã tuchɨ. Mbia ra ñee ñee tuchɨ quia nyɨɨquia ɨquia je rɨɨ̃. Ũquɨ̃ mose ra jẽsiquichechɨ̃ jẽ. Ũquɨ̃ ja rane nda nyecua raque. Aque mose ra mbae ja ua eã ná. ");
INSERT INTO srqNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mbia ra guerras saã tuchɨ chee. Nyɨɨquia ɨquia tuchɨ rae. Mbia riãcuã tuchɨ ra aque mose no. Emo ñooñoa tuchɨ ra mbia rasi. Mangue chooñoa tuchɨ ra ibi nyere nyere. ");
INSERT INTO srqNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jembasi ramo mose chõ nda ũquɨ̃ nde. Aquere ra jembasi tuchɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mbia ɨcuã ɨcuã tuchɨ r a jẽje serɨɨ̃. Nguerecua je ra mbia jenderao rao tuchɨ. Jẽɨquia chee rae. Mbia mangue chooñoa jenda ra jẽucuayã tuchɨ serɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ae siqui quia seruɨ nae, ũquɨ̃ tubɨrɨã nda huɨ sesɨ ũquɨ̃ mose cote. Ũquɨ̃ nda nyɨucuayã. Ũquɨ̃ nda nguerecua mbuqueta queta tuchɨ ngõngue rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Dios cheẽ mbuchecuasa chõ se re”, ɨ ra mbia ñee ata atate jẽje. Ũquɨ̃ nda mbia mbɨɨrɨ̃ ɨrɨ̃ tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mbia ɨcuã ɨcuã tuchɨ ra cote. Aba cheẽ mumba mumba beɨte ra cote. Mbia ra nyesecua eã tuchɨ nyɨese cote. ");
INSERT INTO srqNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ae ra siqui beɨ serese, ũquɨ̃ nda Dios mingo beɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sequiato r a Dios cheẽ turã senei senei ná mbia ja je nyii. Mangue chooñoã jenda ja je. Aquere ra mbae ua ja cote. ");
INSERT INTO srqNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Dios cheẽ mbuchecuasa rei Daniel. Ae que embesa Mbae Mbutiãsa Ɨcuã nɨɨ nda. “Dios rendaque re taɨco se quiatu”, ɨ ra equia huee. (Ae ra mae nguia sechɨmbesa rese nae, sã ũquɨ̃ eɨcua.) ");
INSERT INTO srqNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jemae mose Mbae Mbutiãsa Ɨcuã ndese, jeña esɨ. Ae siqui quia Judéaa, sã ũquɨ̃ uchã jeɨ choɨ ibi ibátee mo. ");
INSERT INTO srqNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ae ra siqui tuchua quite rese, sã ũquɨ̃ ɨqueã nyoɨ uchuchua uquichi mose. Sã echoɨ chõ uchã hue sɨ beɨ, umbae rirõ ndocoɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ae ra siqui úcoo, sã ũquɨ̃ nyebiã ngaẽ huɨɨrao rea. Sã hue sɨ beɨ chõ echoɨ uchã. ");
INSERT INTO srqNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Aba mbia eã tuchɨ ra emo ãquẽ ndiru rerequia mose aque mose. Nguiirĩ mbuquiambu je abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Nyiiseĩ mose eã urechã” jenye Dios je. “Sábado mose eã abe urechã”, jenye abe Dios je no. ");
INSERT INTO srqNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mbia ra mbae rasi saã tuchɨ aque mose. Mbae rasi que mbia saã eã jiri nyii ra. Aque ramo mose ra mbae rasi raã tuchɨ cote. Mbae ua beɨ sacuã ño ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ae rasi ra mbia saã tuchɨ nae, ũquɨ̃ nda Dios mbujua jiri uquiato rɨɨ̃. Ɨ̃ nda emo ñɨmbirãcuã eã tuchɨ rei ũquɨ̃ ndasi je. ");
INSERT INTO srqNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“A Cristo riqui a jẽ” ɨ mose emo jẽje, “nyia” jenyechɨ̃ nda ũquɨ̃ ñee mose jẽ. “Hue Cristo riqui hue jẽ” ɨ mose emo jẽje, “nyia” jenyechɨ̃ nda eno jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","“Cristo chõ se re”, ɨchõɨño nda mbia ñee ata atate jẽje. “Dios cheẽ mbuchecuasa chõ se re”, ɨchõɨño nda mbia ñee ata atate jẽje no. Mbia mae sayã nda esaã saã tuchɨ mbia mbɨɨrɨ̃ ɨrɨ̃ sacuã. Ũquɨ̃ Dios quiato abe chee mbɨɨrɨ̃ ɨrɨ̃ arõte. ");
INSERT INTO srqNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ũquɨ̃ nonde chõ aɨco nguiã jembiirandu randu co. ");
INSERT INTO srqNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Hue Cristo riqui turuquia hue”, ɨchõɨño nda mbia jẽje serɨɨ̃. “A Cristo riqui tuchua a”, ɨchõɨño nda emo jẽje serɨɨ̃ no. Ũquɨ̃ mose ra “nyia” jenyechɨ̃ jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sã ama ndiqui pirirã ɨ ibei resae ja no, eɨ̃ nda sechu mose. Mbia ra mae ja serese. ");
INSERT INTO srqNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sã urubu riqui mae ja mbae raaque rese no. Eɨ̃ sɨ ra seɨcuasa mae ja sechu rese no. ");
INSERT INTO srqNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mbia ũquɨ̃ ndasi raã ja mose r a tenda checuayã mbeɨ cote. Nyasi abe no. Nyasitata ra ngoɨ ngoɨ. Ibei jenda abe ra quiata quiata chee cote no. ");
INSERT INTO srqNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aque mose ra achu ibei rese. Senininya tuchɨ ra sechu mose. Sequirãcuã tuchɨ ra sechu mose no. Mbia ra mae ja tuchɨ sechu rese mangue chooñoa jenda ja. Mbia ia eã tuchɨ ra nyeseo mae mose serese. ");
INSERT INTO srqNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Angeles serimba ra amondo corneta mbucheẽ sacuã. Ũquɨ̃ nda mbia sechiisirõ munua nua ja seje cote. Ɨshonda ja. Mangue chooñoa jenda ja. ");
INSERT INTO srqNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sã higuera riqui no. Sã ira mo ndiqui no. Ero quira usẽ j a mose, “iraro itõ ndacu ra cote”, ɨ chõ mbia nguiã aque mose. ");
INSERT INTO srqNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eɨ̃ sɨ́ ra mbae ua ja nonde. Ae rɨɨ̃ aɨco ñee jẽje nae, ũquɨ̃ ndese jemae mose, “mbae ra ua ja cote” jenye ra cote. ");
INSERT INTO srqNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tacheẽ nyecua jẽje. Ã mbia riqui ngata ibi ã nae, ũquɨ̃ emo emo nda manoã mbae ua ja nonde. ");
INSERT INTO srqNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ibei ra ua. Ibi abe ra ua no. Secheẽ nguia ra ua eã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Manosete chõ nda mbae ua ja. Aɨco eɨcuayãte co. Mbia mo abe eɨcuayãte quia ã no. Angeles abe eɨcuayãte quia ã no. Paba mɨɨ ño eɨcua nguiã co. ");
INSERT INTO srqNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sã Noé mosenda mbia siqui sereãte Dios rese cose no. Eɨ̃ sɨ ra mbia siqui sereã Dios rese sechu nonde no. ");
INSERT INTO srqNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sã Noé mosenda mbia quiaru chooño no. Ndua rocoɨ̃ Dios rese. Ngũinisirã ngue equereco chooño ndua rocoɨ̃ Dios rese no nda. Noé que ɨque chee arca ye ra. Amandi cuasu nonde. ");
INSERT INTO srqNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ama ngue uchɨ u quia mbia ɨquia ja nonde cote ra. Mbia mbua tuchɨ que ra. Eɨ̃ ae ra u mbia mbua tuchɨ sechu mose. ");
INSERT INTO srqNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sechu mose ra mbia nyeremo siqui úcoo. Co mɨɨ nda arao. Enongue ra siquichõ. ");
INSERT INTO srqNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cuña nyeremo nd a chɨ raque mbua tocho no. Co mɨɨ nda arao. Enongue ra siquichõ. ");
INSERT INTO srqNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jẽtesa beɨ quiatu quia serese. Ae mose ra achu, aque tenda rese jẽiranuate riqui ã. ");
INSERT INTO srqNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mbaecha mo jirandu mose mbae mbuquiachãsa rese, “co isa ra eru” ɨ mose, ũquɨ̃ mose nda uqueã nde chaẽ. Ɨ̃ nda mbae mbuquiachãsa mbae sirõ eã ndei. ");
INSERT INTO srqNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jẽɨngoquiatu beɨ quiatu quia seraarõ arõ. Jendua eã mose serese ra achu jembuate. ");
INSERT INTO srqNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Dios rimba aba cheẽ mumbayã je aɨco ñee a. Dios rimba aquiatu je aɨco ñee a. Sã ererecua mo ñee ngũimba turã je no. “Sembae esaarõ turã ja quia secutiã. Serimba ataque embuquiaru quiaru turã secutiã”, ɨ que ererecua ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Erimba echeẽ mumbayã mose, ererecua ia tuchɨ ra eru mose. Erimba abe ra eya tuchɨ no. ");
INSERT INTO srqNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ererecua ra ngũimba mɨɨ umbae raarõ mbeɨ sacuã cote. ");
INSERT INTO srqNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sã erimba ndua ndua uchɨangui re no. “Sererecua ra tu jeɨ ãte” ɨ ndua ndua. ");
INSERT INTO srqNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Hue ñee ɨcuã ɨcuã uataque je hue cote. Iruã nua cote. Quiaru chooño cote. Mbae mbei chooño abe cote. Quiacua quiacua mbia ɨcuã ndese cote. ");
INSERT INTO srqNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sã ererecua ruchɨ̃ nguia ngũimba mbuate aque mose cote jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ererecua ra eiruã nua tuchɨ. Mombo rae. Mbae rasi ra esaã tuchɨ. Ae ucuasu saã saã nguia nae, ũquɨ̃ ndese ra mbae rasi raã tuchɨ cote. Nyeseo seo tuchɨ ra equia. Ureɨ̃ nda equiti quiti tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nyucuaaque ɨcoquiatu je rã sɨ rei Dios rimba. Sã nyucuaaque diez nyoɨ quia emo ngũinisi nderequia ramo ndese maenno. Lamparina nendi que ecuruchoɨ ja quia ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco que ɨcoquiatu je ra. Cinco que ɨcoquiatuã je no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ae ɨcoquiatuã nae, ũquɨ̃ ngue mbae quira curuchoɨ eã umbae lamparina mombisẽ sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ae ɨcoquiatu nae, ũquɨ̃ ngue mbae quira curuchoɨ botella ye ra. Lamparina ye abe. ");
INSERT INTO srqNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ae ra ngũinisi isi reɨ̃ nguia ee, aque que itõte ee ra. Nyucuaaque reesi esi chee que ra. Uque uque ja chee que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Itondiite mose que to ɨ andu cote ra. “Co erurã ndu quia co cote jẽ. Jẽso mae erese cote”, ɨ que mbia tasẽ tasẽ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nyucuaaque que nyuruã ja cote ra. “Nandembae lamparina nandemombisẽ mbisẽ ja”, ɨ rei que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ae ɨcoquiatuã nae, ũquɨ̃ ngue ñee ndei ɨcoquiatu je ra. “Urembae uque uquete. Mbae quira ñetẽ jemee mee na ure je”, ɨ rei que uataque je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ateẽ. Nande ja chayãte ra resẽ. Emo jẽisi chõ oso ɨcua”, ɨ que ɨcoquiatu je ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nyoɨ rei que equia eisi cote ra. Ecutiã ngue erurã ndu cote ra. Nyucuaaque ɨcoquiatu je que nyoɨ ɨque erese ra. Ngũinisirã isi ramo ndese mae. Quiaru abe que echoɨ erese ra. Eɨquesa que ematã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ɨcoquiatuã je abe que ngaẽ nyee ra. Ɨ que eɨquesa matã ji mɨ ee ra. “Embuquiata rã ure je”, ɨ rei que ñee eru je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Eru que ñee ee ra. “Tei. Jaẽɨcuayã tuchɨte se”, ɨ que eru ñee ee ra, ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","—Jẽɨngoquiatu beɨ quia jẽ. Ae mose ra achu, ũquɨ̃ jẽɨcuayãte quia ã. ");
INSERT INTO srqNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sã ererecua mo mbae isiquia mee mee ngũimba je no. Eɨ̃ sɨ chõ Dios nguiã mbae mee mee ngũimba je. Ererecua oso serɨ̃ mose que umbae mbae isiquia mee mee ngũimba je ra. Embaata ata sacuã ño ngue emee nguiã ee. ");
INSERT INTO srqNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Cinco mil que emee emo je ra. Dos mil enongue je no. Un mil que enongue je no nda. “Jenya chõ tamee mee jẽje jẽ”, ɨ que ñee ee ra. Secha que oso ɨsho cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ae je ererecua cinco mil mondo nae, aque que negocio saã saã mbae isiquia je ra. Mbae isiquia que embaata tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ae je ererecua dos mil mondo nae, aque abe que negocio saã saã mbae isiquia je ra. Mbae isiquia que embaata tuchɨ no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ae je ererecua un mil mondo nae, aque que ibi sɨbɨcoɨ mbae isiquia rerecoquiatu sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Emo mose tuchɨ que ererecua ru cote ra. Ñee ngue ngũimba je cote ra. “Jenyu sembiirandu sembae mbae isiquia rese cote”, ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ae je cinco mil mondo nae, aque rane ngue tu ñee nguerecua je ra. “Cinco mil que eremee ndei seje nae, ũquɨ̃ ngue ambaata ra. Cinco mil que aisibe ra”, ɨ que emee ja nguerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ererecua que ñee ee ra. “Coche ñene. Nde quiarei serimba turã tuchɨ. Mbae ñetẽ ngue eresaã turãte nde ra. Nyebe ra mbae tubɨrɨã ereteaquiatu seje cote. Ndeya beɨ tuchɨ ra ereɨco serese cote”, ɨ que ererecua ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ae je ererecua dos mil mondo nae, aque que tu ñee nguerecua je cote ra. “Dos mil que eremee ndei seje nae, ũquɨ̃ ngue ambaata ra. Dos mil que aisibe ra”, ɨ que emee ja nguerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ererecua que ñee ee ra. “Coche ñene. Nde quiarei serimba turã tuchɨ. Mbae ñetẽ ngue eresaã turãte nde ra. Nyebe ra mbae tubɨrɨã ereteaquiatu seje cote. Ndeya beɨ tuchɨ ra ereɨco serese cote”, ɨ que ererecua ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ae je ererecua un mil mondo nae, aque que tu rei ñee nguerecua je cote ra. “Nde que ere queteãte quiatu nguiã mbae rese. Ndechitiquia eã abe ereɨshao shaote quia co. ");
INSERT INTO srqNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nyebe asiquiche tuchɨ nguiã mbae isiquia mee mose seje. Nyebe achati nguiã ibi je. Co é co resẽ”, ɨ que ñee nguerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ererecua que ñee ee ra. “Aba rimba biã tuchɨ quiarei nde. Ndetomei tuchɨ chõ eriqui re. Sequeteã mose mbae rese ndeje, ¿mbaerã secheẽ eremumba re? ");
INSERT INTO srqNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Sembae mbae isiquia eremonoã ñochɨ̃ banco. Ɨ̃ nda eata jiri sechu mose cote re chã”, ɨ que ererecua ñee asite ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ererecua que ñee mbi a hue jenda je cote ra. “Mbae isiquia jẽsirõ na esɨ un mil. Ae diez mil quereco nae, aque je jemondo. ");
INSERT INTO srqNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ae embae tubɨrɨãte nae, aque je mbae tamondobe. Ae embae ãte nae, embae ñetẽ tasirõ ja esɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Co que serimba ɨcuã tuchɨ ra. Jemombo itondaruqui re. Mbae rasi ra esaã tuchɨ huee. Huee ra nyeseo tuchɨ. Ureɨ̃ nda equiti quiti tuchɨ”, ɨ que ererecua ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sechu mose íbii mbia rerecuarã, ángeles sembae ra semama tuchɨ aque mose. Serenda nininya tuchɨ ra aque mose. ");
INSERT INTO srqNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mbia mangue chooñoa jenda ja ra chɨ ñumunua huee aque mose. Mbia emo emo nda achono ɨcúe sembaerã aque mose. Sã oveja raarõsa riqui ovejas no ɨcúe chivos sɨ no. ");
INSERT INTO srqNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Uquiato cuti ra ovejas no. Uquiato cutiã nda chivos no no. ");
INSERT INTO srqNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Eɨ̃ ae ra se mbia rerecua tuchɨ mose. Acheẽ nda mbia sequiato cutinda je. “Jenyu serese. Jenderecua turã tuchɨ ra aɨco jẽje. Paba turãte riqui jẽje co. Paba que jẽirabo nyii mbae ao nonde ra. Jẽɨngo sacuã serese. ");
INSERT INTO srqNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Seriãcuã mose que mbae jemee seje ra. Seɨseɨ mose que sembiu ra. Sechuchua eã mose que seisi turã no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Seɨrao eã mose que tiru jemee seje ra. Serasi mose que jẽso mae serese ra. Seɨco mose cárcel que jẽso mae serese no nda”, ae ra ñee sequiato cutinda je. ");
INSERT INTO srqNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Sequiato cutinda ra ñee seje cote. “¿Manose mbae uremee ndeje nderiãcuã mose re? ¿Manose ureso nembiu ndeɨseɨ mose re? ");
INSERT INTO srqNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Manose ure ndeisi turã ndechuchua eã mose re? ¿Manose tiru uremee ndeje ndeɨrao eã mose re? ");
INSERT INTO srqNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Manose ureso mae nderese nderasi mose re? ¿Manose ureso mae nderese ndeɨco mose cárcel re?” ɨ tuchɨ ra ñee seje. ");
INSERT INTO srqNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Aque mose ra acheẽ ee. “Tacheẽ nyecua jẽje. Senongue mo mbaech a reã ndaque. Ae turã jẽsaã senongue mo je nae, seje eraã naanguia chõ ũquɨ̃ nde”, ae ra ñee ee. ");
INSERT INTO srqNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Acheẽ nda sequiato cutiã quitinda je cote. “Jẽso sesɨ. Mbae turã nda jẽisiã seo jenda. Jẽso tata cuásuu. Ae Dios chɨao tata, diablo mbasi sacuã. Diablo rimb a abe mbasi sacuã. Ũquɨ̃ tata ra uqueã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Seriãcuã mose que mbae mo jemee eãte seje ra. Seɨseɨ mose que sembiu eãte no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Sechuchua eã mose que seisi turã eã nda. Seɨrao eã mose que tiru jemee eãte seje ra. Serasi mose que jẽso eãte mae serese ra. Seɨco mose cárcel que jẽso eãte mae serese no nda”, ae ra sequiato cutiã quitinda je. ");
INSERT INTO srqNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Sequiato cutiã quitinda ra ñee seje cote. “¿Manose mbae mo uremee eã ndeje nderiãcuã mose re? Ndeɨseɨ mose abe no. Ndechuchua eã mose abe no. Ndeɨrao eã mose abe no. ¿Manose uresoã nderea nderasi mose re? ¿Manose uresoã nderea ndereco mose cárcel nde no?” ɨ ra sequiato cutiã quitinda ñee seje. ");
INSERT INTO srqNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Acheẽ nda ee. “Mbae turã jẽsaã eã mose emo je, seje eraã eã naanguia chõ ũquɨ̃ nde”, ae ra sequiato cutiã quitinda je. ");
INSERT INTO srqNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ũquɨ̃ nda nyoɨ ja tata cuasu cote. Huee ra mbae rasi raã mbeɨ tuchɨ cote. Sequiato cutinda quia ra siqui turã mbeɨ ibate cote, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Aquere que Jesús ñee uchɨmbaaquiatu je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Dos días mose ra fiesta de la pascua cote. Aque mose ra mbia ɨcuã semee ererecua je seɨquia sacuã, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sacerdote rerecua que ñumunua ja cote ra. Ameɨ ja rese. Embesasa rese abe no. Ũquɨ̃ ngue ñumunua ja u Caifás itaicuee ra. Caifás rei sacerdote rerecua tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Caifás itaicuee que ũquɨ̃ nyɨ ñee ñee Jesús rɨɨ̃ nda. —Jesús nandembɨɨrɨ̃ ɨrɨ̃ jẽ. Eisi sacuã. Etarõ sacuã. Eɨquia sacuã cote, ɨ que u ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—Fiesta mose eã ño nandeisi jẽ. Mbia ra paama ɨ tuchɨ nande je, ɨ que u ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús que siqui Simón Leproso chuchúaa ra. Betania, ɨ que hue je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Cuña mo ngue tu erea hue ra. Aba mbusɨmbusa mo ngue equeru Jesús je ra. Embisẽ tuchɨ que equeru ra. Mbae isiquia mumbasa tuchɨ que ũquɨ̃ nda. Ichusẽ ja que Jesús ãquĩ ndese equiaru mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Echɨmbaaquiatu que chɨ ja mae erese ra. Paama ɨ que cuña je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","—¿Mbaerã eichusẽ ñooño nde? Mbae isiquia rɨbɨshorõ ño nda aba emondo re. Mbaecha reã je emee mee sacuã, ɨ que echɨmbaaquiatu ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús que echeẽ ñandu ra. Ñee ngue ee ra. —¿Mbaerã jẽɨngo ñee ũquɨ̃ nde? Sã cuña ae riqui ae. Ae esaã seje nae, eturãte seje ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mbaecha reã nguia ra chɨ arete íbii a. Se quia nda aɨco beɨ eã nguiã jendese aa. ");
INSERT INTO srqNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Seati nonde chõ ngue cuña aba mbusɨmbusa ichusẽ nguiã serese. ");
INSERT INTO srqNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tacheẽ nyecua jẽje. Mbia Dios cheẽ turã nenei nenei mose mangue chooñoa jenda ja je, cuña nyɨsaã abe ra esenei senei. Mbia ndua turã ja sacuã echɨsaã abe rese, ɨ que Jesús ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Judas Iscariote, ɨ rei que Jesús chɨmbaaquiatu mo je ra. Aque que oso ñee sacerdote rerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Jesús tamee jẽje. ¿Mbae ra jemee seje erɨbɨshorõ nde? ɨ que Judas ñee sacerdote rerecua je ra. Sacerdote rerecua que mbae isiquia ata mee ee ra. Treinta que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","—Mbia eãsa quiatu Jesús tamee jẽje, ɨ que Judas ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Fiesta que tu cote ra. Aque fiesta mose beɨ que mbia riqui oveja ɨquia ɨquia querabe ra. Mbichae mbuchɨmatã iriã ngue eu eu quia aque mose querabe no nda. Fiesta nonde que echɨmbaaquiatu ñee Jesús je ra. —¿Mangue ra oveja urembuchi mangue ndechɨurã nde? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús que ñee ee ra. —Jẽso sucha cuasu. Jeñee aque je. “Jesús que urembu ñee ndeje ra. ‘Ndechuchua oveja tau sequiato rese semano nonde’, ɨ que Jesús ucheẽ mbu ndeje ra”, jenye aque je, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Echɨmbaaquiatu que nyoɨ erea Jesús cheẽ nguire ra. Oveja que embuchi huee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Itondaru ramo mose que Jesús chɨ quiaru uchɨmbaaquiatu rese huee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Quiaru mose que Jesús ñee ee cote ra. —Tacheẽ nyecua jẽje. Jemo nda semondo mbia ɨcuã je, ɨ que ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Echɨmbaaquiatu ia eã tuchɨ que echeẽ mose ra. —¿Se ra aremondo ee re? ɨ ja jate que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús que ñee ee ra. —Ae chɨ̃ quiaru serese aque plato ye sɨ́ a nae, aque tuchɨ ra semondo mbia ɨcuã je. ");
INSERT INTO srqNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Dios cheẽ nduɨ sɨ́ tuchɨ ra amano ndaque. Ae ra semee mbia ɨcuã je, aque ra mbae rasi saã tuchɨ quia. Aba mbia eã tuchɨ ra aque. “Taĩ sembuchecua jirichɨ̃ nguia curɨ”, ɨ chee ra aque, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","—¿Se ra aremondo mbia ɨcuã je re? ɨ que Judas ñee Jesús je ra. Jesús rɨɨ̃ ñeende mbia ɨcuã je nyii. “Ae” ɨ que Jesús echeẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Quiaru que u ra. Jesús que mbichae sirõ nda. Gracias ɨ que Dios je ra. Siquio que mbuchao chao ee cote ra. —Ã mbichae jẽu. Serete chõ ã nde, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Vino mbeisa que esirõ cote no nda. Gracias ɨ que Dios je ra. Mondo que uchɨmbaa quiatu oo cote ra. —Jembei mbei ja. ");
INSERT INTO srqNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Seruqui chõ ã nde. Mbia ɨcuã mbutiã sacuã ño seruqui re. Dios cheẽ yasu ruɨ sɨ chõ seruqui riqui nguiã mbia ɨcuã mbutiã co. ");
INSERT INTO srqNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tacheẽ nyecua tuchɨ jẽje. Vino mo nda ambei eã mbeɨ cote. Paba mbia rerecua tuchɨ mose, aque mose ramo nguia nda ambei nguiã jendese cote, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ɨraseɨ raseɨ que cote ra. Nyoɨ que Monte de los Olivos ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús que ñee uchɨmbaaquiatu je ra. —Jẽɨreɨ̃ ɨreɨ̃te ra serɨɨ̃ co isa. Jeñɨmboseɨ̃ mboseɨ̃ nda oso serecha co isa. Sã embesa ji riqui ñee no: “Dios ra oveja raarõsa ɨquia. Oveja ra ñɨmboseɨ̃ nyoɨ cote”, sã embesa ji riqui ɨ no. ");
INSERT INTO srqNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Seraaque quera sɨre ra aso se rane jendaarõ Galilea, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro que ñee ee ra. —Seataque ra ɨreɨ̃ ɨreɨ̃te raque ndesɨ. Se quia ra aɨreɨ̃ ɨreɨã mbeɨ ndesɨ, ɨ rei que Pedro ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús que ñee ee ra. —Tacheẽ nyecua ndeje, Pedro. Nguira cheẽ nonde ra erecheẽ ñooño tres veces serɨɨ̃ namo, Pedro. “Jesús aɨcuayãte resẽ”, ere chooño ño nda serɨɨ̃, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro que ñee ee ra. —Mbia seɨquia arõte raque nderɨɨ̃, acheẽ ñooño eã nda nderɨɨ̃, ɨ rei que Pedro ra. Eɨ̃ ja que ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesús que oso Getsemaní cote ra. Uchɨmbaaquiatu rese. —Jengoi rã u aa. Taso rã ñee Paba je pe jiri se, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pe quiti jiri que Pedro rerao ra. Zebedeo riirĩ nyeremo ndese. Eya eã ndasi tuchɨ que tu ee aque mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ñee ngue ũquɨ̃ je ra. —Seya eã ndasi tuchɨ aɨco co. Seya eã ndasi ra seɨquia chee. Jenguchõ na jẽ aa. Jẽtesa tesa beɨ u aa, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús que oso pe quiti jiri cot e ra. Nyibi que u ngũíã ndese ñee Dios je ra. —Paba, ũquɨ̃ ndasi asaã sereãte raque quia co. Ae sebite riqui nae, ũquɨ̃ ndese semingo eã. Ae ndebite riqui nae, ũquɨ̃ ndese quiatu semingo, ɨ que Jesús ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nyebi que u uchɨmbaaquiatu je cote ra. Ɨ que eu uque ja ee cote ra. Ñee ngue Pedro je ra. —Jẽɨngo areã ñochɨ̃ tesa serese se ñee mose Dios je. ");
INSERT INTO srqNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jẽtesa tesa u. Jengue eã u ñee Dios je. Mbae ɨcuã tã ɨ eã sacuã jẽje. Jẽɨngo serete raque serese. Mbae ɨcuã nguiatu jembuti mbutite nguiã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Osobe que ñee Dios je pe jiri cote ra. —Paba, nde ñee mose seje, “mbae rasi ra eresaã” nde ɨ mose seje, asaã nda se, ɨ que ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nyebi que u uchɨmbaaquiatu je cote ra. Ɨ sɨ́ que u uque ee no nda. Eresa quiatu ngue eshɨu shɨute nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesús que osobe erecha ñee Dios je ra. Tres veces que aque cote ra. Hue rɨ̃ sɨ que ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Uchɨmbaaquiatu jii que esɨ ñee ee cote ra. —Jengue cote. Jenguenea jẽucua cote. Semondo ra mbia ɨcuã je cote. Seɨquia sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jẽhuã cote. Nyao cote. Ae ra semee mbia ɨcuã je, co eru quia semee sacuã co cote, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús cheẽ mosebe tuchɨ que Judas ru erea ra. Jesús chɨmbaaquiatu rei que ae ra. Aque rese que mbia cuaẽ tuchɨ quia ra. Tiquise abe que ecurucuaẽ nguia ra. Ira jua abe no. Sacerdote rerecua chõ ũquɨ̃ mbucuaẽ nguia reaẽ. Ameɨ abe. ");
INSERT INTO srqNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas ñee nyecuayã nguiatu quia ũquɨ̃ je nyii reaẽ. —Ae ritii ra asiite, aque chõ ñene. Aque jẽisi serao, ɨ quia equia ee nyii reaẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jesús rɨɨchã ngue esɨ saludar ɨ ee cote ra. Jesús ritii que esiite ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","—¿Mbaerã erechu serea re? ɨ que Jesús ee ra. Mbia que ngaẽ Jesús isi ecua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ũquɨ̃ mose que Jesús rimba mo uchuuru sirõ tiquise ra. Sacerdote rerecua rimba rese que tiquise uru ra. Eisa que echisia ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús que ñee ee ra. —Ndechuuru emingue chõ eriru ye. Nde emo nyɨɨsha mose tiquise je, nde abe ra emo ndeɨsha. ");
INSERT INTO srqNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ndeiranuate ángeles rese re? Se ñee mose Paba je, ángeles tubɨrɨã tuchɨ nda embu seje re chaẽ. Sereaquiatu sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","“Angeles embu rã sereaquiatu”, ae eã nda Paba je. Ũquɨ̃ mose ra embesa ji ɨque eã cote. Sã embesa ji riqui ñee no: “Mbae rasi ra esaã tuchɨ” ɨ no, ɨ que Jesús ñee Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesús que ñee mbia ja je cote ra. —¿Mbaerã jenyu quia tiquise rurucuaẽ serea co re? Ira jua abe no. Mbae mbuquiachãsa rea rocoɨ̃ jenyuchɨ̃ nguia serea co. Tenda que amumba mumba beɨte rei quia jendese Dios chuchua resẽ. Mbia que ambaaquiatu quiatu beɨ rei quia huee resẽ. ¿Mbaerã seisiã nyucua aque mose re? ");
INSERT INTO srqNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Embesa ji ɨque sacuã ño jẽɨcuã ɨcuã ndiqui nguiã seje ã, ɨ que Jesús ra. Echɨmbaaquiatu que nyoɨ ja chee uchã Jesús recha ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ae Jesús isi nae, ũquɨ̃ ngue ecuruchoɨ sacerdote rerecua je ra. Huee que embesasa chɨ ja ñumunua nda. Ameɨ ererecua ja abe. ");
INSERT INTO srqNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro que embuchurucha rucha oso quia eruɨ ra. Ngasẽ nyee que sacerdote rerecua itaicuee ra. Huee que ngoi sacerdote rimba mo ndese ra. —Mañɨ nda mbia Jesús je reae, ɨ que huɨ̃ ngoi eraarõ arõ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sacerdote rerecua que chɨ ja huee ra. Ameɨ mbia rerecua ja abe no. Mbia rerecua ja tuchɨ. —Jesús nandeɨquia, ɨ rei que ñee ñee nyue ra. —¿Mbae ɨ ra aba mbia je Jesús rɨɨcharã nde? ɨ rei que u ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Emo emo ngue ngaẽ ndei ñee ɨcuã ɨcuã Jesús rɨɨ̃ nda. Ũquɨnde que mbia nyeremo ngaẽ ñee ñooño Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Jesús que ñee ñooño Dios chuchua rɨɨ̃ nda. “Dios chuchua ra ambucoɨ. Tres días mose ra achaobe”, ɨ que urechandu Jesús cheẽ nda, ɨ que ũquɨ̃ ñee ñooño Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sacerdote rerecua que juã ñee Jesús je ra. —¿Echeẽ nda eresɨbɨshorõ eã mbeɨ re? ¿Mbae ɨ equia nderɨɨ̃ nde? ɨ que Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús que ñee eã mbeɨ echeẽ mose ra. Sacerdote rerecua que ñeembe ee ra. —¿Dios rucucha nde re? ¿Cristo nde re? Diósaa echeẽ ure je, ɨ que sacerdote rerecua ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús que ñee ee ra. —Ae. Dios rucucha chõ se re. Tacheẽ nyecua jẽje. Jemae nda serese se coi mose Dios quirãcuã jii. Sechu mose abe ibeishĩ ndese, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sacerdote rerecua que paama ɨ tuchɨ Jesús cheẽ mose ra. Huɨɨrao que endoro ndoro chee ra. Ñee ngue ererecua ataque je ra. —Jesús riqui Dios rucucha raã naa co. Jeñandu jate equia ã. Sã mbia mo nandembiirandube eã cote. Nandemae ndei ngue erese re. ");
INSERT INTO srqNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ɨ jẽje re? ¿Mañɨ nande ra equia re? ɨ que sacerdote rerecua ñee ererecua ataque je ra. —Eɨcuã tuchɨ que ra jẽ. Sã mbia eɨquia, ɨ jate que ererecua ñee Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mbia que ñinimbu nimbu Jesús ruba rese cote ra. Ucua ucua abe que erese ra. Emo emo ngue eritii mbeete ete o je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ñee ngue ee ra. —“Cristo chõ se re”, ere ñɨ equia. Aba chõ ucua nderese chã. Ma eɨcua no, ɨ que mbia ñee ɨcuã ɨcuã ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro que chɨ̃ mbeɨte ngoi itaicuee ra. Nyucuaaque mo ngue tu ñee ee mbia rimba mo nda. —Jesús resenda que nde abe ra. Galilea jenda, ɨ que nyucuaaque ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro que ñee ee ra. —Tei. Ndecheẽ aɨcuayãte, ɨchõɨño ngue Pedro mbia résaa ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro que oso quia eɨquesa cuti cote ra. Nyucuaaque nongue que ñee mbia je erɨɨ̃ nda. —Co abe que Jesús resenda ra. Nazaret jenda, ɨ que ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","—Tei. Jesús aɨcuayãte, ɨbe que Pedro ñee ɨcuã ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ae chɨ huee nae, ũquɨ̃ mo ngue ñee Pedro je cote ra. —Jesús resenda chõ nde abe resẽ. Ndecheẽ aba chɨɨcuate resẽ, ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pedro que jurar ɨ tuchɨ ñee ee ra. —Aɨcuayã tuchɨte se resẽ, ɨ que ñee ñooño nda. Aque mose tuchɨ que nguira ñee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pedro que ndua Jesús cheẽ ndese cote ra. Sã Jesús ñee ee nyii no. —Nguira cheẽ nonde ra erecheẽ ñooño tres veces serɨɨ̃, sã Jesús ɨ ee nyii no. Ũquɨ̃ ndese que Pedro ndua cote ra. Nyebe esɨ nguiã usẽ nyeseo tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nyaashɨ̃ namo mose que sacerdote rerecua ndua hue rɨ̃ ja ra. Ameɨ mbia rerecua ja abe no. Hue rɨ̃ ja ndua Jesús ɨquia sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jesús que echucua suruchoɨ Pilato je ra. Pilato rei mbia rerecua, hue jenda ja rerecua. ");
INSERT INTO srqNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mbia ra Jesús ɨquia, ɨ mose Judas je, eya eã tuchɨ que ũquɨ̃ mose ra. —Jesús amee jirichɨ̃ nguiã mbia je, ɨ que ra. Nyebe mbae isiquia mondobe nguiã sacerdote rerecua je. Ameɨ ererecua je abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Mbae ɨcuã tuchɨ asaãchɨ̃. Jesús seteã tuchɨ ameechɨ̃ jẽje. Eɨquia sacuã, ɨ que Judas ñee nda. —Nde quia rei. Ure eã ñene, ɨ ja que ererecua ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas que mbae isiquia mbaba asi mombo mondo íbii ra. Dios chuchúaa. Oso que uchosoi mumbi nyɨɨquia cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sacerdote rerecua que mbae isiquia sirõ ibi sɨ cote ra. —Mbia rɨbɨshoronda chõ ã mbae isiquia re. Nyebe nandemondo eã ofrendarã, ɨ que ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aquere que sacerdotes ibi mo isi aque mbae isiquia je ra. Ibi mo ngue eisi mbiamo tiquia tiquia sacuã nda. Ñionga, ɨ que hue ibi je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nyebe eriqui nguiã “mbia ruqui rua” ɨ beɨ hue je. Namo nyee. ");
INSERT INTO srqNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aque mose que Jeremías ñɨmbesa ɨque cote ra. Ã ndei Jeremías ñɨmbesa ã: Ũquɨ̃ mbae isiquia treinta que eisi cote ra. Ũquɨ̃ ndei mbia rɨbɨshoronda ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ũquɨ̃ mbae isiquia que emondo hue ñionga rɨbɨshorõ cote ra. Dios ñee nguia erɨɨ̃ seje nyii nae, ũquɨ̃ nduɨ sɨ, ɨ que Jeremías embesa cose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mbia que Jesús curuchoɨ Pilato je cote ra. Pilato que ñee ee ra. —¿Judíos rerecua chõ nde re? ɨ que ee ra. —Ae. Judíos rerecua chõ se re, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sacerdote rerecua que ñee ɨcuã ja Jesús je ra. Ameɨ ererecua abe no. Jesús que ñee ãte echeẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","—¿Erechanuãte equia ñee mose nderɨɨ̃ nde? ɨ que Pilato ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús que ñee ãte echeẽ mose ra. Nyebe Pilato nyuruɨra tuchɨ nguiã echeẽ eã mose. ");
INSERT INTO srqNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pilato que mbia tarõ ji mo mbusẽ mbeɨ quia pascua mose ra. Co mɨɨ ngue embusẽ mbusẽ mbeɨ quia pascua mose ra. Ae je mbia riqui ñee, “aque embusẽ mondo” ɨ nae, aque chõ ngue embusẽ mbeɨ quia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Barrabás, ɨ que etarõ ji mo je ra. Mbia chɨɨcua tuchɨ que ae ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mbia ñumunua ja mose que Pilato ñee ee ra. —¿Aba ra ambusẽ mondo jẽje re? ¿Barrabás ra re? ¿Jesús ra re? ɨ que Pilato ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","—Sacerdote rerecua riqui paama ɨ chooñote Jesús je ã, ɨ quiatu que Pilato ndua ndua uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato que chɨ̃ ngoi ndua ndua ngũenda tose ra. Eninisi que ucheẽ mondo ñee ee ra. —Ehuɨ chõ Jesús sɨ jẽ. Mbae ɨcuã ngue esaã eãte resẽ. Atea que seque re isa ra jẽ. Seque re ɨcuã tuchɨ que aa ra jẽ, ɨ que Pilato ninisi ñee ngu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sacerdote rerecua que ñee mbia ja je ra. Ameɨ ndese. —Sã Pilato Barrabás mbusẽ mondo. Sã Jesús quiatu ɨquia, ɨ que ererecua ñee ja mbia je ra. Nyebe mbia “eno” ɨ chee ee. ");
INSERT INTO srqNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato que ñee sɨ mbia je ra. —¿Aba ra ambusẽ mondo jẽje re? ¿Jesús ra re? ¿Barrabás ra re? ɨ que Pilato ra. —Barrabás embusẽ mondo ɨ que mbia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—¿Mañɨ ae quia ra Jesucristo je re no? ɨ que Pilato ra. —Embucha ira rese, ɨ ja que mbia ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Mbae ɨcuã esaã nde? ɨ que Pilato ee ra. —Embucha ira rese jẽ, ɨbe que mbia tasẽ tasẽ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","—Mbia riqui “Jesús eɨquia” ɨ ɨ tuchɨchɨ̃, ɨ que Pilato ndua ndua ra. —I mo embu seje, ɨ que mbia je cote ra. Nyoɨ que mbia résaa cote ra. —A aɨco nyoɨ a. Se ra Jesús aɨquiayã. Eseteãte quiatu ngue re. Jẽ nguiatu jẽɨngo erese, ɨ rei que Pilato ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mbia que ñee ja Pilato je ra. —¡Eɨquia jẽ! Eɨcuãte que eriqui ra jẽ. Dios ra paama ɨ eã eɨquia mose. Dios paama ɨ mose, sã ure je quiatu paama ɨ. Ureriirĩ je abe no, ɨ jate que mbia Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato que Barrabás mbusẽ mondo cote ra. Jesús cuasa quiatu que chɨño nda. Pilato que Jesús iruã nua cote ra. —Jembucha ɨquia ira rese, ɨ que ñee soldados je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Soldados que Jesús cuasa curuchoɨ ererecua chuchúaa ra. Huee que soldados ataque abe ngaẽ ja Jesús mama nda. ");
INSERT INTO srqNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jesús ɨrao que embuɨ esɨ ra. Tiru ɨreɨ̃ nguiatu ngue emingue nguiã ee cote. ");
INSERT INTO srqNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nyu ritiméi uma ji que emɨɨ eãquĩ ndese corona nda. Ira ñetẽ mo abe que emondo éoo ra. Ngoi ja que u ngũíã ndese Jesús nonde ra. Ñee ɨcuã ɨcuã ngue u erɨɨ̃ nda. —Judíos rerecua tuchɨ chõ nde re, ɨchõɨño ngue soldados Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ñinimbu nimbu abe que erese ra. Ira abe que euru uru eãquĩ ndese no nda. ");
INSERT INTO srqNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jesús rimba que esaã saã ee no nda. Ɨquia ɨquia que ee no nda. Aquere que tiru ɨreɨ̃ mbuɨ esɨ cote ra. Eɨraote que emingue ee cote ra. Curuchoɨ que embucha nonde ira rese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ɨ rei que echoɨ quia ra. Mbia mo ngue esobeɨshɨ̃ nda. Simón, ɨ equia ee. Cirene jenda que ae ra. —Cruz echa rã Jesús mbucha sacuã pe, ɨ que soldados ee ra. Nguerao que ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ngasẽ ngue pee cote ra. Gólgota, ɨ que hue je ra. Eresa cuare, ɨ chõ nguiã hue je. ");
INSERT INTO srqNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Huee que vino ñɨmocondo tuchɨ mo mondo Jesús je ra. Ubi rei que erese ra. Aquere que embei eã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Soldados que Jesús mbucha ira rese ra. Aquere que sɨta ñetẽ mbaba mbaba o je cote ra. —Aba ra Jesús ɨrao querao ñɨ ja, ɨ que nyue ra. Aque mose que embesa ji cheẽ ɨque cote ra. Seɨrao que embuchao chao nyue ra. Sɨta ñetẽ mbaba mbabare o je, ɨ que embesa ji ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Aquere que soldados chɨ ngoi Jesús raarõ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mbia que letrero mɨɨ Jesús ãquĩ nguiti ibate ra. JESUS REI JUDIOS RERECUA, ɨ que embesa mɨɨ nda. Ũquɨ̃ nɨɨ ño eriqui nguiã eɨquia hue. ");
INSERT INTO srqNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mbia nyeremo abe que embucha ira rese Jesús chabe ra. Jesús rereco chobeɨ que emɨɨ ira rese ra. Mbae mbuquiachãsa tuchɨ que ũquɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mbia que ɨquia ɨquia chõ nguia echeẽ naa naa ecuã nda. Ñee ɨcuã ɨcuã ee. ");
INSERT INTO srqNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—“Dios chuchua ra ambucoɨ. Tres días mose ra ambuchuruambe” ere que equia. Ndequirãcuã tuchɨ mose, equichi u hue sɨ. Nde Dios rucucha mose, equichi u cruz sɨ, ɨ tuchɨ que mbia quia ɨquia ɨquia ee ecuã mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sacerdote rerecua abe que ɨquia ɨquia chõ nguia ee ra. Embesasa abe no. Ameɨ ererecua abe no. Ũquɨ̃ ngue ñee ɨcuã ɨcuã ja quia erɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Mbia que embuquera quera rei nyii ra. Ae sɨ quia quera aroneate nguiã aque. Judío rerecua mose ae, sã ae ae nguichi ira sɨ. Ɨ̃ nda ureɨcu a cote, ɨ ja que ererecua ñee ɨcuã ɨcuã e erɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","—“Dios aɨcuate”, ɨ que equia, sã Dios ae embuquichi eya mose erese. “Dios rucucha rei se” ɨ que equia, ɨ ja que ererecua ñee ɨcuã ɨcuã erɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ae mbuchai chɨ ira rese mbae mbuquiachãsa nae, ũquɨ̃ abe que ñee ɨcuã ɨcuã nyee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tenda nandeite re mose que itondaru ru ra. Itondaru beɨ que mbia ja je tres horas ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tenda cheseco mose que Jesús ñeemombo cote ra. —Elí, Elí, ¿lam a sabactani? ɨ que ñeemombo ra. —Dios sererecua, ¿mbaerã ereɨco huɨ sesɨ re? ɨ chõ ngue ñee nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","—Elías je eriqui “quiatuchu” ɨ reae, ɨ rei que echeẽ andusa mo nda. ");
INSERT INTO srqNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aque mose tuchɨ que emo esponja monde vinagre ye ra. Ira ai rese que embia ji mondo rei Jesús chúruu cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","—Esecha rei. ¡Sã Elías ruãte quia erea! ɨ que eataque ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús que tasẽ mano mbeɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Aque mosechɨ tuchɨ que cortina nyisia Dios chuchua jenda ra. Ibate sɨ que eru nyisia íbii ra. Ibi que nyere nyere cote ra. Sɨta abe que nyisia sia nyibite bite rɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mbia tãsa mo abe que nyeequia equia ra. Dios quiato raaque mo ngue quera quera ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesús quera sɨ mose que ũquɨ̃ ndaaque usẽ nyoɨ cote ra. Nyoɨ que Jerusalén cote ra. Mbia tubɨrɨã ngue mae u erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldados rerecua que chɨ̃ mae Jesús rese ra. Soldados abe no. Ũquɨ̃ ngue siquichete Jesús mano mose ra. Ibi chere mose. Mae mose mbae ja rese. —Dios riirĩ ño eriqui re, ɨ jate que soldados ñee erɨɨ̃ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Cuña ngue chɨ jate mae Jesús rese ɨsho ra. María Magdalena abe que chɨ̃ huee ra. María abe no. María rei Jacobo si. José abe si. Zebedeo riirĩ si abe que chɨ̃ erese huee ra. Ũquɨ̃ ngue siqui beɨ quia Jesús ruɨ ra. Echɨurã ngue emɨɨ mɨɨ mbeɨ quia ee ra. Galiléaa eɨco mose beɨ. ");
INSERT INTO srqNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","José, ɨ que mbaecha mo je ra. Arimatea jenda rei ae. Jesús quiato que ae ra. Tenda ɨreɨ̃ mose que esɨ ñee Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","—Jesús raaque emee na seje, ɨ que oso ñee Pilato je ra. Pilato que “eno” ɨ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José que eraaque curuchoɨ cote ra. Ñuma ngue tirushĩ mo je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jesús raaque que eiti suruchoɨ sɨta rɨbɨcoɨ ji ɨmɨ ye ra. José chɨsaã ye. Nyati rei que sɨta cuasu mo je cote ra. Nyoɨ que erecha cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdalena ngue chɨ ngoi mae Jesús atisa rese ra. María rese. ");
INSERT INTO srqNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Isamamɨ ngue sacerdote rerecua choɨ ñee Pilato je ra. Fariseos abe no. Sábado isamamɨ ngue ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ũquɨ̃ ngue nyoɨ ñee Pilato je Jesús rɨɨ̃ nda. —Urendua nduachɨ̃ nguiã ñeeñooño je rese. “Tres días mose ra aquera sɨ”, ɨ que equia mano nonde ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Soldados emondo rã eatiquia raarõ. Sã echɨ beɨ tres días eraarõ huee. Ɨ̃ nda echɨmbaaquiatu eraaque siroã suruchoɨ. “Quera sɨ que ra” ¡ɨchɨ̃ nda ñee ñooño mbia je jẽ! Ũquɨ̃ mose ra mbia mbɨɨrɨ̃ ɨrɨ̃ tuchɨ cote, ɨ que ñee Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato que ñee ee ra. —Soldados jendao rã. Eraaque raarõ tuchɨ sacuã, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Soldados que ecuruchoɨ Jesús atíquiaa cote ra. Eɨquesa aronda que ematã tuchɨ cote ra. —Jẽsaarõ tuchɨ jẽ, ɨ rei que soldados je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jesús raaque ati ji que chɨbe sábado mose ra. Ɨ nyaashɨ̃ oso quia domingo mose, aque mose que cuña mo nyoɨ mae eatisa rese ra. María Magdaalena, ɨ que emo je ra. María, ɨ que enongue je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aque mose tuchɨ que ibi nyere nyere ee ra. Angel ibatenda mo nguia tu quia eatisa mbuquiata reaẽ. Sɨta eatiquia que ecuruba ra. Ngoi que etose ra. ");
INSERT INTO srqNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Enininya tuchɨ que chɨ̃ ngoi ra. Ama pirirã pirirã ɨ rã tuchɨ que ra. Eɨraoshĩ tuchɨ que chɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldados que titi titi ɨ tuchɨ chõ mae ũquɨ̃ ndese ra. Emundi tuchɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angel que ñee cuña je ra. —Jẽsiquiche quichechɨ̃ nguiã. Jẽɨngo raque Jesús raaque requia ã. ");
INSERT INTO srqNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Emoate aa resẽ. Eraaque que quera sɨ no. Ucheẽ nduɨ sɨ que quera resẽ. Jenyu rei mae eatisa rese ae. ");
INSERT INTO srqNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jẽso asi rã echɨmbaaquiatu mbiirandu equera sɨ rese. “Jenonde ra esɨ Galilea. Jemae nda erese huee”, jenye embiirandu. Ũquɨ̃ ae chõ ngue u nguiã jẽje, ɨ que ángel cuña je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Cuña ngue siquichete echeẽ andu ra. Eyate abe que ra. Uchã ndei que echoɨ quia Jesús chɨmbaaquiatu mbiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ñeenda cúa chõ ngue Jesús nyecua saludar ɨ ee ra. Cuña ngue nyoɨ oo erese ra. Jesús i que equiaama ama nda. ");
INSERT INTO srqNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús que ñee ee ra. —Jẽsiquichechɨ̃ nguiã sesɨ. Jẽso ñee seresenda je. “Jẽso rã Galilea. Hue ra jemae Jesús rese”, jenye oso ee, ɨ que Jesús ñee cuña je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Soldados eraaque raarõsa que nyoɨ sacerdotes rerecua mbiirandu Jesús quera rese ra. Ae rese mae nae, ũquɨ̃ ngue esenei ja ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sacerdotes rerecua que nyoɨ ja ñee ameɨ ererecua je cote ra. —¿Mañɨ nande ra equia mbia jiranuã sacuã Jesús quera rese re? ɨ que ererecua ndua ndua hue rɨ̃ ja ra. Nyebe mbae isiquia mee nguiã soldados je, ñee ñooño sacuã mbia je. ");
INSERT INTO srqNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Jeñee ñooño mbia je jẽ. “Ureque mose Jesús resenda eraaque suruchoɨ rei sirõ”, jenye chooño mbia je jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pilato jirandu mose jendese, urecheẽ nda ee. Paama ɨã nda jẽje chã, ɨ que ererecua ñee ja soldados je ra. ");
INSERT INTO srqNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soldados que mbae isiquia isi cote ra. Ñee ñooño tuchɨ que mbia je cote ra. Nyebe judíos riqui nguiã ñee mbeɨ ã cote. —Jesús chɨmbaaquiatu que eraaque sirõ cose ra, nyebe eriqui nguiã ɨ beɨ ã cote. ");
INSERT INTO srqNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesús chɨmbaaquiatu once que nyoɨ ja Galilea ra. Ibi ibate mo ngue echoɨ Jesús cheẽ nguire ra. ");
INSERT INTO srqNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesús que nyecu a ee huee ra. Jesús rese mae mose que ngoi ngũíã ndese ñee ee ra. —Jesús eã ño co reae, ɨ rei que emo emo ñee uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aquere que Jesús sɨ erɨɨchã ñee ee cote ra. —Sequirãcuã tuchɨ chõ se re. Se rei ibi jenda rerecua ja. Ibatenda abe rerecua ja. ");
INSERT INTO srqNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jẽso mbia mbaaquiatu quiatu ja serɨɨ̃. Mbia mangue chooñoa jenda ja. Bautizar jenye ee Paba rɨɨ̃. Serɨɨ̃ abe. Espíritu Turã nɨɨ abe no. ");
INSERT INTO srqNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jembaaquiatu quiatu tuchɨ secheẽ nɨɨ. Ae asenei senei nguia jẽje nae, ũquɨ̃ jẽsenei senei ja ee. Secheẽ mumbayã sacuã. Aɨco beɨ ra se quia jendese. Mbae ua j a chee, ɨ que Jesús ñee ee ra. Amén.");
INSERT INTO srqNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ã tasenei na jẽje. Dios cheẽ turã Jesucristo rɨɨ̃. Jesucristo rei Dios riirĩ. ");
INSERT INTO srqNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sã Isaías Dios cheẽ mbesa cose no: Secheẽ nderaosa amondo quia nderẽta aque. Ae ra ñeenda mbuquiche nembaerã, ɨ que Dios ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Emo ndiqui ñeemombo mombo turúquiaa hue. “Sã emo ndiqui ñeenda mbuquiche no, eɨ̃ jenye sɨ chõ nguia jẽ abe ɨco quiatu nandererecua raarõ arõ”, ɨ equia turúquiaa hue, ɨ que Isaías embesa ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Juan el Bautista que tu ũquɨ̃ ñee nguire cote ra. Dios cheẽ ngue esenei senei nguia turúquiaa cote ra. —Jendua sɨ Dios rese. Jẽhuɨ chõ jẽɨcuã sɨ. Dios jẽɨcuã mbutiã sacuã. Ũquɨ̃ mose nda bautizar ae jẽje chã, ɨ beɨte que Juan nguia ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jerusalén jenda que ngaẽ ngaẽ tuchɨ quia echeẽ andu ra. Judea jenda abe no. Mbia huɨɨcuã nenei nenei mose Dios je, ũquɨ̃ mose que Juan ndiqui bautizar ɨ ee ra. Ama Jordán ye. ");
INSERT INTO srqNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Quiicuã mbuaera chõ ngue Juan ɨrao ra. Camello. Mbae ɨre chõ ngue enumbicuasa no nda. Tucu mbuae chõ ngue eu eu quia ra. Irao quiaa rɨɨnda abe. ");
INSERT INTO srqNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Dios cheẽ ngue esenei senei nguia ra: —I achõ je chõ aɨco nguiã bautizar ɨ mbia je co. Co chɨ emo ndu quia seruɨ co. Dios riirĩ tuchɨ chõ ae re. Ae quia equirãcuã tuchɨ sesɨ re. Ae quia eturã tuchɨ sesɨ no nde. Ae quia tura bautizar ɨ mbia je Espíritu Turã je. Mbia chɨã mbitirõ sacuã, ɨ beɨte que Juan nguia ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Aque mose que Jesús ru sucha tubɨrɨã Nazaret sɨ ra. Galilea jenda rei Nazaret. Juan ngue bautizar ɨ Jesús je ra. Ama Jordán ye. ");
INSERT INTO srqNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesús que usẽ oso ama sɨ cote ra. Ibei que nyeequia ee cote ra. Espíritu Turã ngue nguichi u erese cote ra. Nyurushɨ rã ngue eru nguichi erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ibei jenda que ñee ee ra. —Seriirĩ ño nde re. Sechesecua chõ nde re. Seyate nderese, ɨ que Dios ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Espíritu Turã ngue Jesús querao turúquiaa cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Huee que Jesús riqui arete ra. Cuarenta días. Nyacua rɨsha ite re. Mbia rɨɨchare ja ite re. Satanás que tu rei tã ɨ ee cote ra. Angeles que ngaẽ ngaẽ nguia ereaquiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mbia rerecua que Juan tarõ cárcel cote ra. Aquere que Jesús sɨ Galiléaa ra. Dios cheẽ turã ngue esenei senei nguia huee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—Achɨte Dios ñɨ tu mbia rerecuarã a. Jendua sɨ́ Dios rese. Jẽhuɨ chõ jẽɨcuã sɨ. Dios cheẽ turã jẽɨcua. Ɨ̃ nda Dios jemingo beɨ, ɨ que Jesús quia ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús que ngata oso quia ama nimia nduɨ ra. Galilea, ɨ que aque ama ndɨsha je ra. Huee que mae Simón ndese ra. Enongue abe rese mae. Andrés, ɨ equia ee. I que u sɨra mbua mbuasa mondo mondo ii ra. Sɨra resenda beɨ rei ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús que ñee ee ra. —Seruɨ beɨ chõ jẽɨngo jẽ. Taembaaquiatu quiatu. Mbia teendu endu beɨ quia seje cote, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nyoɨ ja que eruɨ ra. Sɨra mbuasa sɨ que echoɨ huɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pe jiri que mae Jacobo rese ra. Enongue rese abe. Juan, ɨ equia ee. Zebedeo riirĩ ja rei ũquɨ̃. Huee que echɨ ja canoa ye sɨra mbuasa mbitirõ tirõ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","—Jẽɨngo seruɨ, ɨ que Jesús ñee ee ra. Echeẽ nduɨbe tuchɨ que echoɨ eruɨ ra. Ngu que esecha choɨ ra. Eru que siquichõ canoa ye ngũimba rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nyoɨ que sucha tubɨrɨã Capernaum nda. Sábado mose que Jesús sɨ judíos chumunua nuásaa ra. Mbia mbaaquiatu quiatu sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mbia rerecua rã ño ngue eriqui mbia mbaaquiatu quiatu ra. Embesasa rã eã. Nyebe mbia riqui nguiã nyuruɨra tuchɨ echeẽ andu. ");
INSERT INTO srqNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Huee que ameɨ mo ndiqui mbia chumunuásaa ra. Aba checuayã ɨcuã nyɨreco rei ae. Ñee asite que Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Mbaerã erechu urerea co re, Jesús? Quiatúae urerecha ae. ¿Urerɨɨcharã ño erechu quia co re? Dios rucucha chõ nde re. Areɨcuate se, ɨ rei que aba checuayã ñee asite ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús que ñee asi ee cote ra. —¡Equɨrɨrɨ chõ jẽ! Esẽ oso ameɨ ñɨangui sɨ, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jesús cheẽ mose que aba checuayã ameɨ mburirite cote ra. Tasẽ ngue oso usẽ ameɨ sɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mbia que nyuruɨra tuchɨ mae Jesús rese ra. Ñee ñee ja que nyue cote ra. —Jesús riquichɨ̃ mbia mbaaquiatu quiatu ucheẽ namonda je co. Equirãcuã ae ñee nguiã. Mbia rerecua rã ño eriqui nguiã ñee aba checuayã ɨcuã je co. Sã aba checuayã echeẽ mumbayãte jẽ, ɨ que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mbia que jirandu jeɨ Jesús rese Galilea jenda ja cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesús que usẽ nyoɨ mbia chumunuasa sɨ cote ra. Nyoɨ que Simón nyuchua ra. Andrés abe que siqui rei huee tuchua ra. Jesús que ɨque nyoɨ huee ra. Jacobo rese. Juan ndese abe no. ");
INSERT INTO srqNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","I que Pedro chari rasi u nyaara ee ra. Eracu tuchɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús que eo isi embuchuruã nda. Aque mosebe que eracu ti ɨ esɨ cote ra. Mbae que echao chao quia mbia chɨurã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Itondaru ramo mose que mbia erasi rurucuaẽ cuaẽ tuchɨ Jesús je ra. Ae aba checuayã quereco quia nae, ũquɨ̃ abe que ecurucuaẽ cuaẽ tuchɨ quia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sucha tubɨrɨã jenda ja que chɨ ñumunua eɨquésaa ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mbia rasi chumumbara que embucherõ cherõ ja ra. Aba checuayã ɨcuã tubɨrɨã ngue ejea jea quia mbia sɨ ra. Aba checuayã ngue Jesús ɨcuate rei ra. Nyebe Jesús riqui nguiã echeẽ ndiquisã quisãte. ");
INSERT INTO srqNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","I nyaashɨ̃ oso quia, aque mose que Jesús juã oso mbia tiãsaa ra. Ñee sacuã Dios je itondaru beɨ mose. ");
INSERT INTO srqNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón ngue oso eruɨ emuña nda. Nguesenda rese. ");
INSERT INTO srqNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ngasẽ ngue ee ra. —Pe mbia chɨ nderequia jate pe, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús que ñee ee ra. —Nyao sucha tubɨrɨã mbuchesea sea achɨ jenda. Dios cheẽ nda asenei senei ee chã. Nyebe achu nguiã, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galilea jenda que embuchesea sea ja cote ra. Dios cheẽ nenei nenei judíos chumunua nuásaa. Aba checuayã abe jea jea mbia sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Emo ndasi que ngasẽ Jesús je ra. Leproso, ɨ que ũquɨ̃ erasi je ra. Tu que ngoi ngũíã ndese ñee Jesús je ra. —Nde sembucherõse mose, sembucherõ se, ɨ tuchɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús ia eã tuchɨ que erese ra. Ñomee ngue oco erese cote ra. —Eno. Tarembucherõ, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Echeẽ nduɨbe tuchɨ que nyerõ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jesús que ñee ee ra. —Sã jẽ. Erecheẽchɨ̃ nda emo je jẽ. Eso nderasiã ndeacuquia sacerdote je cote. Moisés cheẽ nduɨ sɨ chõ mbae mo emondo Dios je. Eɨ̃ nda mbia jirandu nderasiã ndese cote, ɨ rei que Jesús ñee emondo ra. ");
INSERT INTO srqNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mbia que embiirandu ja tuchɨ chõ oso ra. Nyebe Jesús nyecua aroneate nguiã sucha tubɨrɨã mo. Siquiibi ibi chõ ngue eriqui cote ra. Ɨcuenda ja que ngaẽ ngaẽ nguia erea ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Emo mose jiri que Jesús nyebi Capernaum nda. Echuchua ereco mose que mbia jirandu erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mbia tubɨrɨã ngue ñumunua ee ra. Mbia chayã tuchɨ que ra. Eɨ quesa abe itãyã tuchɨ que ra. Dios cheẽ ngue esenei senei tuchɨ quia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mbia cuatro que erasi mo curucuaẽ ee ra. Emɨ sayã. ");
INSERT INTO srqNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mbia tubɨrɨã ngue tuchua mbiitãyãte eriquisã nda. Nyebe erasi ruruchoɨ nguiã suɨ tei quite arõ. Tei que endoro cote ra. Erasi que embuquichi ɨmbu quisa ye Jesús je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","—Erurucuaẽsa riqui seɨcuate ũquɨ̃, ɨ que Jesús ñee uchɨangui re ra. Nyebe ñee nguiã emɨ sayã je. —Echo, ndechɨsaã mbae ɨcuã ambutiã nguia ndesɨ a, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Embesasa mo abe que chɨ echeẽ andu ra. Mae ɨcuã ɨcuãte que equia Jesús res e ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Mbaerã Jesús riqui ñee ũquɨ̃ nde? Ñee ɨcuã ɨcuã ñochɨ̃ equia Dios rɨɨ̃ co. Dios ibatenda ae mbi a chɨao ɨcuã mbutiã tiã nguia esɨ resẽ, ɨ rei que ñee ɨcuã ɨcuã Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús que ũquɨ̃ ndua ndua ɨcuate quia ra. Nyebe ñee nguiã ee cote. —¿Mbaerã jẽɨngo ndua ndua ɨcuã nde? ");
INSERT INTO srqNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ma mbaranguiatuã eã jiri jẽje re? ¿Mbia ɨcuã mbutiã esɨ ere? Mbia rasi mbucherõ ere no ae. ¿Ma mbaranquiatuã eã jiri jẽje re? ");
INSERT INTO srqNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Dios rucucha rei se. Mbia chɨao ɨcuã mbutiã aquiatu chõ se re. Sequirãcuã tateacuquia jẽje, ɨ que Jesús ñee ee ra. Ñee ngue erasi je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ehuã na. Ndechuchua eso cote. Ndequisa abe erao, ɨ que Jesús emɨ sayã je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Emɨ sayã ngue juã asi Jesús cheẽ nduɨbe cote ra. Ngua que esirõ asite serao cote ra. Mbia resa rae ja. —Ã ndese que ureɨco mae eã tuchɨ emo mose ra, ɨ tuchɨ que mbia u mae nyuruɨra erese ra. Mbia que ñee turã jate Dios quirãcuã nɨɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesús que oso sɨ ama ndɨsha rimíaa nda. Mbia que ngaẽ ngaẽ jate erea ra. Jesús que embaaquiatu quiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","I que Jesús oso quia ra. Mae ngue Leví rese ra. Alfeo riirĩ ngue Leví ra. Ngoi que huɨ̃ plata isi isi impuestorã nda. —Seruɨ beɨ eɨco, ɨ que Jesús ñee ee ra. Ae Leví juã oso nguiã eruɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesús que nyoɨ quiaru erese ra. Impuestos isi isiquia ata que chɨ quiaru erese huee ra. Echɨmbaaquiatu abe rese. Mbia ɨcuã mo abe que chɨ quiaru erese no nda. Ũquɨ̃ tubɨrɨãte que siqui eruɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Fariseos que ñee ɨcuãte Jesús chɨmbaaquiatu je ra. Embesasa abe que ñee ɨcuãte ee ra. —¿Mbaerã Jesús riqui quiaru mbia ɨcuãte rese re? ɨ que ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nyebe Jesús ñee nguiã ee. —Sã mbia rasiã ndiqui aba mbucherõsa requia eãte no. Sã erasi chõ ndiqui erequia no. “Jenyu seje” ae eã ngue u nguiã mbia turã je. Mbia ɨcuã je chõ ngue achu nguiã “jenyu seje” ɨ, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juan ñɨmbaaquiatu que huɨ uchɨu sɨ aque mose ra. Fariseos chɨmbaaquiatu abe no. Nyebe mbia ngaẽ nguiã ñee Jesús je. —¿Mbaerã ndechɨmbaaquiatu abe riqui huɨ ãte uchɨu sɨ re? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús que ñee ee ra. —Sã emo ndiqui ngũinisirã isi ramo no. Sã eresenda iate riqui quiaru erese no. Sã eriqui huɨ aroneate uchɨu sɨ aque mose no. ");
INSERT INTO srqNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sã eru riqui mano emo mose no. Aque mose ramo nguiatu ra equiato huɨ uchɨu sɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sã emo ndiqui tiru yasu mɨɨ aroneate tiru ima sorei rese no. Eyasu ra nyaacua quiata eima sɨ. Soro ɨcoɨ tuchɨ chõ nda cote. ");
INSERT INTO srqNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sã emo mbaeri rasi ramo nderecoquiatu eã eriru ima ye no. Mbae ɨre ima ye ererecoquiatu aronea ño ñene. Eri rasi ra ñimatã ño mbae ɨre ndoro. Eri ra uchẽ ja. Mbae ɨre abe mbɨɨcuãte ra cote. Mbaeri yasu quia nda equerecoquiatu nguiã mbae ɨre yasu ye. Soroã sacuã, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sábado mose que Jesús sɨ quia mbiaco ite ite rɨ̃ emo mose ra. Echɨmbaaquiatu que quiata a nyiqui nyiqui choɨ quia eruɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseos mo ngue ñee ee ra. —¿Mbaerã ndechɨmbaaquiatu riqui mbae ɨshao shao sábado mose re? Co mose chõ mbia riqui uquenea ucua resẽ, ɨ que fariseos ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús que ñee ee ra. —¿Embesa ji rese jemae eã David rɨɨ̃ nyii re? David riãcuãte que aque mose ra. Eresenda abe riãcuãte que eriqui aque mose no nda. ");
INSERT INTO srqNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David que ɨque Dios chuchua aque mose ra. Abiatar que sacerdote rere cua aque mose ra. Mbichae Dios chuchua jenda que David u ra. Mee mee ngue nguesenda abe je ra. Eriãcuãte quiatu ngue re. Sacerdote mbaerã ja chõ ndaque mbichae, ɨ que Jesús fariseos je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","—Sábado que Dios chao mbia mbaerã nda. Sábado mbaerã eã ño Dios mbia ao nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sábado rerecua beɨ chõ se re, ɨ que Jesús ñee fariseos je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús que oso mbia chumunuásaa cote ra. Huee que eo tomei mo ndiqui ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mbia que mae nguiatute quia Jesús rese ra. —Ma Jesús eo tomei mbucherõ. Sábado mose raque co. Sã embucherõ. Nandecheẽ ɨcuã ɨcuã nda ee chã, ɨ que eu mae nguiatute Jesús rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús que ñee eo tomei je cote ra. —Ehuã na u aa mbia ite re, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesús que ñee mbia je ra. —¿Mbae eturãte jẽje co tenda sábado mose re? ¿Coche nandeɨco mbae turã naa naa sábado mose re? ¿Coche nandeɨco mbae ɨcuã naa naa co mose re no? ¿Coche mbia mbucherõ co mose re no? ¿Coche mbia ɨquia co mose re no? ɨ que Jesús ñee mbia ja je ra. Mbia que ñee ãte echeẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús que paama ɨ mae mbia rese ra. Eya eãte que eriqui mbia chɨã ãtã ndese ra. Ñee ngue eo tomei je cote ra. —Ndeo emee secuti, ɨ que ee ra. O que emee Jesús cheẽ mose ra. Aque mosechɨ que eo nyerõ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nyebe fariseos paama ɨ nguiã Jesús je. Mbia mbucherõ mose sábado mose. Ndua ndua ja que Jesús ɨ quia nonde ra. —Jesús nandeɨquia rei, ɨ tuchɨ que equia Herodes resenda ja je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús que oso ama ndɨsha quiti ra. Uchɨmbaaquiatu rese. Mbia tubɨrɨã Galilea jenda que nyoɨ quia eruɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Mbia que jirandu ja tuchɨ Jesús chɨsaã turã ndese ra. Nyebe eriqui nguiã ngaẽ ngaẽ erea. Judea jenda. Jerusalén jenda. Idumea jenda. Ama Jordán ndobeɨnda abe. Tiro rurubinda abe no. Sidón ndurubinda abe no. Ũquɨ̃ ja que ngaẽ ngaẽ nguia erea ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nyebe Jesús ñee nguiã uchɨmbaaquiatu je. —Canoa mo jendu rã ɨno mbuquiche co rɨ̃, ɨ que ee ra. Mbia quiatu ngue emumbite nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mbia que embucherõ cherõ tuchɨ quia nyii ra. Nyebe erasi ataque riqui nguiã “taoco erese” ɨ raque. Nyebe eriqui nguiã ñɨmaña maña tuchɨ. “Nandeoco Jesús rese” ɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aba checuayã ɨcuã mae mose Jesús rese que ngoi ngoi quia ngũíã ndese ñee ee ra. —Dios riirĩ ndei nde, ɨ que equia ñeemombo mombo ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús que ñee asite ee ra. —“Co rei Dios riirĩ co” jenyechɨ̃ nda jẽ, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesús que nyuɨ oso sɨta ibate mo ndese ra. “Jenyu” ɨ que uchiirabobi je ra. Nyoɨ que erea ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ũquɨ̃ doce que eirabo nguesendacuã nda. Embuchao chao sacuã mondo Dios cheẽ nenei nenei. ");
INSERT INTO srqNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Uquirãcuã ngue emondo ee ra. Aba checuayã jea jea sacuã mbia sɨ. Mbia rasi chumumbara mbucherõ cherõ sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ã ndei mbia echiirabo ã: Simón (Pedro, ɨ abe que ee ra.) ");
INSERT INTO srqNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo (Zebedeo riirĩ ndei Jacobo.) Juan (Jacobo nongue rei Juan. Boanerges, ɨ que ũquɨ̃ ja je ra. “Ama sɨeu je riirĩ” ɨ chõ nguiã ee.) ");
INSERT INTO srqNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés Felipe Bartolomé Mateo Tomás Jacobo (Jacobo rei Alfeo riirĩ.) Tadeo Simón el Cananista ");
INSERT INTO srqNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote (Aque que Jesús mondo mbia ɨcuã je ra.) Ũquɨ̃ ja que Jesús irabo ra. Nyoɨ que ɨque tuchúaa cote ra. Uchɨmbaaquiatu rese. ");
INSERT INTO srqNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mbia que ngaẽ ngaẽ tuchɨ quia erea no nda. Equiaru mose rocoɨ̃. Echɨmbaaquiatu abe quiaru mose rocoɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús nongue jirandu mose que echoɨ erea ra. Equiachã eriqui reĩ nguiã ee. Nyebe eriqui rei nguiã “nanderao” ɨ raque. ");
INSERT INTO srqNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Embesasa ngaẽ nguia Jerusalén sɨ nae, ũquɨ̃ ngue ñee ñee mbia je ra. Mbia mbuqueta queta Jesús rɨɨ̃. —Satanás quirãcuã je chõ Jesús riqui nguiã aba checuayã ɨcuã jea jea mbia sɨ co, ɨ rei que ñee ɨcuã Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","—Jenyu rã tacheẽ jẽje, ɨ que Jesús ee ra. —¿Mañɨ nda Satanás aba checuayã ɨcuã jea mbia sɨ re? Erimba chõ nyeresẽ. ");
INSERT INTO srqNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gobierno ɨcuã ɨcuã mose nyue, ua rae. ");
INSERT INTO srqNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tuchuamo jenda ɨcuã ɨcuã mose nyue, ua ra eno. ");
INSERT INTO srqNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanás ɨcuã ɨcuã mose nyue, equirãcuã nda ua no. ");
INSERT INTO srqNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Satanás quirãcuã tuchɨte raque. Umbae rese ngueteãte raque. “Sembae chɨ turãte a”, ɨ raque. Dios quiarei equirãcuã tuchɨ Satanás sɨ. Dios Satanás mbae sirõ ja arõt e quia esɨ co. Dios Satanás quirãcuã mbutiã ja arõte quia co. ");
INSERT INTO srqNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tacheẽ nyecua jẽje. Emo siqui ɨcuã mose, Dios eɨcuã mbutiã arõte esɨ. Emo ñee ɨcuã mose, Dios echeẽ ɨcuã mbutiã arõte no. ");
INSERT INTO srqNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Emo ñee ɨcuã mose Espíritu Turã nɨɨ, ũquɨ̃ ɨcuã nguiatu ra Dios mbutiã eã mbeɨ esɨ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","—Jesús chɨangui re aba checuayã ɨcuã ndiqui co, ɨ quiatu ngue mbia nguiã. Nyebe Jesús ñee nguiã ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús nongue que ngaẽ ndei erea ra. Usi rese. Chɨchõ ja chõ ngue itaicuee ra. —“Quiatuchu” ere Jesús je, ɨ que emo mondo ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mbia que chɨ jate ngoi Jesús jii ra. Ũquɨ̃ ngue ñee ee ra. —Hue ndesi riqui nderequia itaicuee hue. Ndenongue rese, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","—¿Aba je chõ aɨco “taĩ” ɨ chã? ¿Aba je chõ aɨco “senongue” ɨ no ña? ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jesús que mae ucheẽ andusa rese ra. —Ã je chõ aɨco nguiã “taĩ” ɨ. Ã je chõ aɨco nguiã “senongue” ɨ no. ");
INSERT INTO srqNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ae Dios cheẽ mumbayã nguia nae, ũquɨ̃ je chõ aɨco nguiã “senongue” ɨ. Ũquɨ̃ je chõ aɨco nguiã “taĩ” ɨ no, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús que mbia mbaaquiatu quiatu sɨ ama nimia ndese ra. Mbia que ñumunua tuchɨ u erese huee ra. Nyebe Jesús sɨ nguiã ua canoa mo ye. Ngoi que huɨ̃ huee mbia mbaaquiatu quiatu ra. Mbia que chɨ jate ama nimia ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesús que mbia mbaaquiatu quiatu tuchɨ quia ra. Ejemplos que esaã saã tuchɨ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Jenyisaquia rã serese. Sã emo sɨ rei mbae eɨ̃ mombiquia mbiquia no. ");
INSERT INTO srqNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sã emo ndiqui uqui uqui ñeenda ruɨ no. Sã nguireĩ ndiqui ngaẽ eu no. ");
INSERT INTO srqNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Sã emo emo ndiqui uqui sɨta arõ no. Sɨta aronda suri jeɨ raque. Ibi ererate quia ñene. ");
INSERT INTO srqNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tenda ibate mose que eriqui ñɨmama mano nda. Erao eãte quia ñene. Nyebe mano jeɨ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Sã emo ndiqui uqui uqui nyu réndaa no. Sã nyu abe riqui suri erese no. Nyu ruri que echati asi cuaẽ eriquisã nda. Nyebe ɨa eã ño nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Sã emo ndiqui uqui uqui ibi turã no. Ũquɨ̃ nguiatu que suri turã nda. Ɨ a turã ngue ra. Sã emo ɨa treinta no. Sã emo ɨa sesenta no. Sã emo ɨa cien no. ");
INSERT INTO srqNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jẽisa mose, secheẽ jeñandu turã na, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mbia ataque nyoɨ mose que Jesús ji jenda ñee ee ra. Echɨmbaaquiatu doce rese. —Ndecheẽ embiasa tuchɨ rã ure je mbae eɨ̃ nɨɨ, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús que ñee ee ra. —Mbia rerecua tuchɨ quiarei Ibatenda. Ae chõ asenei senei nguiã jẽje ã. Secheẽ ambiasa asa beɨ tuchɨ quia jẽje co. Mbia ataque quia siqui sereã erese co. Mbia ataque je aɨco ejemplos achõ naa naa mbeɨ co. ");
INSERT INTO srqNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Eanduchõ sacuã eɨcua turã nonde rocoɨ̃. Sã eriqui uba eãte Dios ɨcha ruɨ no. Dios eɨcuã mbutiã eã sacuã esɨ, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús que ñee ee ra. —¿Secheẽ jẽɨcuayãte mbae eɨ̃ nɨɨ ñee mose jẽje re? ¿Mañɨ jenye quiatu ra ejemplos ataque ɨcua re no? ");
INSERT INTO srqNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ae mbae eɨ̃ mombiquia mbiquia nae, Dios cheẽ nenei neneisa rã ño aque re. ");
INSERT INTO srqNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ae uqui uqui ñeenda ruɨ nae, mbia Dios cheẽ andu chooñosa rã ño ũquɨ̃ nde. Ae Dios cheẽ andu chooñote quia nae, ũquɨ̃ ñɨangui sɨ chõ Satanás ndiqui nguiã Dios cheẽ ndirõ. ");
INSERT INTO srqNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ae uqui uqui sɨta arõ nae, mbia mo na ño ũquɨ̃ no nde. Dios cheẽ andu mose, isi turã ndaque. Eyate raque erese nyii. ");
INSERT INTO srqNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mbia ɨcuã ɨcuã mose ee Dios cheẽ nɨɨ, huɨ jeɨ chõ nguiã esɨ. Mbae rao eã naanguia chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ae uqui uqui nyu réndaa nae, mbia mo na ño ũquɨ̃ no nde. Dios cheẽ andu turã ndaque. Siqui beɨ eã ño nguiã eruɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Umbaerã achõ ndese chõ eriquichɨ̃ nguiã ndua. “Mbaecha tuchɨte ra se”, ɨ beɨ chõ nguiã ndua ndua. Nyebe huɨ chõ nguiã Dios cheẽ sɨ. Nyebe Dios cheẽ ndiqui nguiã ɨa eã mbeɨte ee. ");
INSERT INTO srqNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ae uqui uqui ibi túraã nae, mbia mo na ño ũquɨ̃ no nde. Ũquɨ̃ nguiatu Dios cheẽ ñandu turã nguiã. Nyebe eriqui nguiã siqui beɨte erese. Ɨ a ɨa beɨ raanguia cote. Emo emo ɨa treinta. Emo emo ɨa sesenta no. Emo emo ɨa cien no, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús que ñeembe ee ra. —Sã nandeɨco lamparina ati eã no. Sã nandeɨco emɨɨ eã mbaequi re no. Erendi checua chõ nda nandemɨɨ. Mbia resae ja sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mbae checuayã nda nyecua ja emo mose. Mbia chɨangui renda checuayã nda nyecua emo mose no. ");
INSERT INTO srqNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jẽisa mose secheẽ jeñandu turã na. ");
INSERT INTO srqNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Secheẽ nda jeñandu chooñochɨ̃ jẽ. Jẽ secheẽ mumbayã mose, taembaaquiatu ɨ ɨ tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Emo umbae rerequia mose, Dios ra embaerã mo mondobe ee. Emo embae eã mose, Dios ra embae sirõ ja esɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Dios rimba ñɨmbeta chõ nguiã mbae eɨ̃ na. Sã emo mbae eɨ̃ tiquia tiquia no. ");
INSERT INTO srqNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Suri ra itõ mocoinde cote. Eruri cuasu tuchɨ ra cote. Echa embusuriã ndaque. ");
INSERT INTO srqNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Dios ae chõ embusuri nguiã. Eracói rane. Ɨa chee. Ea ñetẽ nane. Ea cuasute cote. Ea ɨreɨ̃ cote. ");
INSERT INTO srqNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ea ɨreɨ̃ tuchɨ mose ra eɨshao shao cote. ");
INSERT INTO srqNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mbae rã ño Dios rimba chã. Ejemplo mo tasenei jẽje. ");
INSERT INTO srqNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mbae eɨ̃ na ño Dios rimba re. Sã mbia mo mostaza eɨ̃ tiquia no. Eñetẽ tuchɨ raque mbae eɨ̃ mo sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Suri oso quia cote. Ecuasu tuchɨ chee. Ira rã ño cote re. Nguireɨ̃ nguichi quichi chee erãquiã ndese. Eɨ̃ sɨ chõ Dios rimba re. Ũquɨ̃ mɨɨ ndaque nyii. Ñɨmbeta tuchɨ cote. Mbae eɨ̃ na, ɨ que Jesús ñee mbia mbaaquiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Eɨ̃ ño ngue Jesús quia mbia tubɨrɨã mbaaquiatu quiatu ejemplos je ra. Mbia quenea tuchɨ chee que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ejemplos achõ ngue esenei senei mbia mbaaquiatu sacuã nda. Uchɨmbaaquiatu je quiatu que embiasa turã turã nda. ");
INSERT INTO srqNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Itondaru ramo mose que ñee uchɨmbaaquiatu je ra. —Nyao ama ndɨsha robeɨ, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ae canoa ye Jesús ñɨ mbia mbaaquiatu quiatu nae, aque ye sɨ́ que echɨmbaaquiatu Jesús rerao ra. Mbia tubɨrɨã ndecha. Canoa mo abe que nyoɨ quia erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ama ndiite re mose que quɨrɨrɨã ɨcuã icuã ndu ee ra. I rebera que ɨque ɨque tuchɨ quia canoa ye ra. Nyebe canoa ndiqui nguiã ñɨɨmɨ serɨ̃ tuchɨ ee. ");
INSERT INTO srqNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús que uque rei oso quia canoa ndiita quiti ra. Uãquĩ ndua arõ ngue esɨ rei quia ra. Echɨmbaaquiatu que emumba ra. —Urembaaquiatusa, echumumba. Nandemanochɨ̃ nda re, ɨ que Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús que nyuruã ñee asite quɨrɨrɨã je ra. —Ti ere cote, ama, ɨ que ama ndebera je no nda. Quɨrɨrɨã ngue tiba echeẽ mose cote ra. Ama ndebera abe que tiba ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ñee ngue uchɨmbaaquiatu je cote ra. —¿Mbaerã jẽsiquichete riqui re? ¿Seɨcuayãte equia ã nde? ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Siquiche beɨ que equia ra. Nyuruɨra tuchɨ que mae Jesús quirãcuã ndese ra. —Quɨrɨrɨã Jesús cheẽ mumbayã ñochɨ̃. Ama abe echeẽ mumbayã ñochɨ̃ no, ɨ que ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ngasẽ ngue ama ndobeɨ cote ra. Gadara, ɨ que hue ib je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Canoa sɨ Jesús nguichi mose que hue jenda mo tu erea ra. Aba checuayã ɨcuã ngue siqui echɨangui re ra. Mbia raaque tãsa sɨ chõ ngue eru ngasẽ Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mbia raaque tãsa beɨ que eriqui ra. Emo ngue echucua aroneate quia ra. Cadenas je abe que emo ndiqui ecua aroneate ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nyucua mocoĩte rei nda cadenas je raẽ. Ei nda echucua rei raẽ. Eo abe. Ucuasa nda endoso ndoso beɨ quia ra. Emo nda embutiba aronea tuchɨ quia ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ngata beɨ nda equia itondaru ra. Nyaashɨ̃ mose abe. Tasẽ tasẽ mbeɨ nda equia mbia raaque tãsa ra. Sɨta ibátee abe no. Sɨta je nda eriqui ñɨmbasi mbasite ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ɨsho que mae Jesús rese ra. Uchã asi que eu ngoi ngũíã ndese enonde ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesús que ñee ee ra. —Esẽ u aque chɨã sɨ, aba checuayã, ɨ que Jesús ñee ee ra. Aba checuayã ngue tasẽ tuchɨ ñee Jesús je ra. —¿Mañɨ ere ra equia seje re, Jesús? Dios riirĩ ño nde re. ¡Sembasichɨ̃ nda se jẽ! ɨ tuchɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—¿Mañɨ ndeje re? ɨ que Jesús ee ra. —Etubɨrɨã, ɨ chõ nguiã seje. Ure cuabẽte quia ñene, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","—Ɨsho ra uremondochɨ̃, ɨ tuchɨ que aba checuayã ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chɨasu socoɨ tubɨrɨã ngue chɨ quiaru huee ibi ibátee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nyebe aba checuayã ɨcuã ñee ja nguiã Jesús je. —Uremondo ja rã chɨasu socoɨ chɨangui re, ɨ tuchɨ que equia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Eno, ɨ que Jesús ee ra. Nyebe aba checuayã usẽ ja nguiã ameɨ ñɨa sɨ cote. Chɨasu chɨangui re que echoɨ ja cote ra. Dos mil rei chɨasu. Chɨasu que uchã ja choɨ nyiichere ama nimia mbucu rɨ̃ nda. Ama ndɨsha ye que echoɨ ja mano nda. ");
INSERT INTO srqNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chɨasu raarõsa mundite que ra. Uchã ngue echoɨ mbia mbiirandu randu ja ra. Sucha tubɨrɨã jenda mbiirandu. Ɨshonda abe mbiirandu no. Mbia que ngaẽ ngaẽ nguia jirandu turã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ngasẽ ngue ecuaẽ Jesús je ra. Ae aba checuayã ɨcuã nguereco uchɨangui re nyii nae, aque abe que siqui huee ee ra. Huɨɨrao resebe que eñɨ ngoi ra. Earacuate que ee cote ra. Nyebe mbia riqui nguiã siquichete. ");
INSERT INTO srqNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ae mae erese nae, ũquɨ̃ ngue ñee ñee mbia je ra. Mbia mbiirandu chɨasu socoɨ rese. Ae aba checuayã quereco quia nyii nae, aque rese abe no. ");
INSERT INTO srqNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","—Eso rã urerecha urerecua sɨ, ɨ jate que hue jenda ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ae aba checuayã quereco quia nyii nae, aque que ñee Jesús je ra. Jesús ua mose canoa ye. —Nderese beɨ chõ taso se jẽ, ɨ rei que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesús que ñee ee ra. —Tei. Quiatu rei ndechuchúaa. Quiatu ñee nderesenda je. “Dios chõ sembucherõ nguiã. Eya eã tuchɨte que eriqui serese ra”, ere oso nderesenda mbiirandu, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ameɨ ngue oso sucha mbuchesea sea cote ra. Mbia Decápolis jenda mbiirandu randu ja. —Jesús chõ sembucherõ nguiã, ɨ ja jate que equia mbia je ra. Mbia que nyuruɨrate quia mae erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús que tu sɨ iasa sobeɨ sɨ canoa ye ra. Mbia tubɨrɨã ngue ngaẽ ngaẽ nguia erea ra. Ama nimíaa eriquibe mose. ");
INSERT INTO srqNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Judíos rerecua mo ngue tu erea ra. Jairo, ɨ que ee ra. Judíos munua nuasa que ae ra. Jesús nonde que eru ngoi ngũíã ndese ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Quɨ seriirĩ sɨ quia mano quɨ. Nyao rã ndeo terechono earõ. Embucherõ sacuã, ɨ tuchɨ que equia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús que oso erese cote ra. Mbia tubɨrɨã abe que nyoɨ quia ñɨmajaã tuchɨ eruɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ari rasi mo abe que oso quia eruɨ ra. Eruqui nda uchẽ mbeɨ quia ee ra. Doce años nyee. ");
INSERT INTO srqNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ngasi nda esaã tuchɨ quia ra. Erasi rea reasa nda etea tea jate rei quia raẽ. Umbae nda emondo mondo ja chee ngasi rea reasa je ra. Nyerõ jiri jiriã tuchɨ que ra. Erasi ɨ ɨ tuchɨ chõ ngue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jirandu chee que Jesús rese ra. Equite quiti que esɨ mbia joõ nda. Oco que oso eɨrao rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","—Eɨrao achõ ndese se oco mose, acherõ nda se, ɨ nda ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aque mose tuchɨ que eruqui ti ɨ ee cote ra. Ngasiã ngue eɨcua uchɨangui re cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","—Sequirãcuã ngue mbia mo mbucherõ nda, ɨ que Jesús uchɨangui re ra. —¿Aba oco seɨrao rese re? ɨ que mae uquite quiti ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Echɨmbaaquiatu que ñee ee ra. —Mbia tubɨrɨãte nyeresẽ. Ñɨmajaãte nyeresẽ. ¿Mbaerã ereɨco “¿aba oco serese re?” ɨ re? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús que nyuruba ruba mae nda. —¿Aba oco serese re? ɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ari que jirandu tuchɨ ucherõ ndese ra. Eɨreɨ̃te que titi titi ɨ huɨ̃ ee ra. Ngoi que ngũíã ndese Jesús resa quiti ra. Mbae que esenei ja ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús que ñee ee ra. —Seɨcuate que se ra. Nyebe arembucherõ nguiã. Ndeya chõ eso cote. Nderasi ra tu sɨ eã ndeje, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Echeẽ mose chɨte que emo ngaẽ Jairo chuchua sɨ ra. —Nderiirĩ ngue mano cote ra. ¿Mbaerã nda Jesús ererao ndechuchua cote re? ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús que echeẽ ñandu ra. Ñee ngue Jairo je cote ra. —Ndeya eã techɨ̃ nda jẽ. Seɨcua chõ se jẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús que oso eraaque rea cot e ra. Uchɨmbaaquiatu tres que equerao ra. Pedro. Jacobo abe. Juan abe no. Jacobo nongue que Juan nda. Ũquɨ̃ mɨɨ ño ngue equerao erea ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ngasẽ ngue Jairo chuchua cote ra. Mbia que chɨ ja nyeseo ãquẽ ndaaque rese ee ra. Nyiibu tuchɨ que eu ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ɨque que oso ñee mbia je ra. —¿Mbaerã jẽɨngo nyiibute re? ¿Mbaerã jẽɨngo nyeseo re? Ãquẽ manoãte resẽ. Uque chõ u co resẽ, ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mbia que ɨquia ɨquia chõ ee ra. Jesús que mbia mondo ja chee itaicuee ra. Eru rese que esɨ ɨque eriirĩ ndaaque rea ra. Esi abe rese. Nguesenda abe rese. ");
INSERT INTO srqNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Eraaque o que eisi ñee ee ra. —Echuruã, Ãquẽ, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Echeẽ mose tuchɨ que ãquẽ juã ngata cote ra. Etiarõte que ra. Doce años que ra. Mbia que nyuruɨra tuchɨ mae erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","—“Jesús que co raaque mbuquera ra”, jenyechɨ̃ nda emo je jẽ, ɨ que Jesús mbia je ra. —Nderiirĩ embuquiaru cote, ɨ que ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hue sɨ que esɨ nguécuaa ra. Echɨmbaaquiatu abe que nyoɨ erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sábado mose que mbia mbaaquiatu quiatu judíos chumunuásaa ra. Mbia que nyuruɨra ja tuchɨ u echeẽ andu ra. Ñee ñee ngue u nyue ra. —¿Mangue eriqui ñɨmbaaquiatu tuchɨte re? ¿Mañɨ equia mbae ɨcua ja tuchɨte re? Nandemae sayã naa naa tuchɨchɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ira mbitirõ tirõsa chõ ndaque. María riirĩ ño ndaque. Jacobo nongue chõ ndaque. José abe no. Judas abe no. Simón abe no. Ã echari enongue riqui ja raque nanderese ã, ɨ que mbia ra. Nyebe mbia Jesús cheẽ andu sereã nea nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús que ñee ee ra. —Dios cheẽ mbuchecuasa ɨshonda cheẽ nguia ra mbia isi turã mbeɨ. Nguecua jenda cheẽ achõ nguia ra eisi turã eã. Ngõngue cheẽ achõ nguia ra eisi turã eã no, ɨ que Jesús ñee nguecua jenda je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jesús que mbia mae sayã saã saã aroneate quia huee ra. O que echono mbia rasi mɨɨ mɨɨ arõ embucherõ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hue jenda mbia que chɨ Jesús ɨcua eãte ra. Nyebe Jesús nyuruɨra tuchɨ nguiã mae erese. Sucha tubɨrɨã mbuchesea sea que equia mbia mbaaquiatu quiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","“Jenyu” ɨ que uchɨmbaaquiatu doce je ra. Nyeremo nemo ngue embuchao chao mondo ra. Uquirãcuã ngue emee mee ee ra. Aba checuayã ɨcuã jea jea sacuã mbia chɨangui sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","—Mbae mo nda jendaochɨ̃ ɨcua. Mbae riru mo abe ra jendaochɨ̃. Jenyɨurã mo abe ra jendaochɨ̃ no. Mbae isiquia abe ra jendaochɨ̃. Jẽiyao nongue mo nda jendaochɨ̃. Jẽɨrao nongue mo abe ra jendaochɨ̃ no. Jenyitochoquia mɨɨ ño jendao. ");
INSERT INTO srqNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jengasẽ mose sucha tubɨrɨã mo, aque tuchua mɨɨ ño jẽɨngo uque. Tuchua ra jembuchesea seate chɨ̃ jẽɨngo mose huee. Ae ra jengue nyii nae, hue tuchua beɨ chõ jẽɨngo uque. ");
INSERT INTO srqNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sucha tubɨrɨã jenda mo jẽisi sereã nea mose, jẽhuɨ chõ esɨ. Hue jenda jeñee andu sereã mose, jẽso chõ hue sɨ. Jẽi tubi jembutomo tomo ee. Hue jenda huɨɨcuã ɨcua sacuã. Tacheẽ nyecua jẽje. Ae ra jeñee isi sereã nae, ũquɨ̃ nda Dios mbasi tuchɨ. Uquiatoã nda embasi ja aque mose. Sodoma jenda ra Dios mbasi raque. Gomorra jenda abe no. Ae jeñee isi sereã nae, ũquɨ̃ nguia ra embasi tuchɨ Sodoma jenda sɨ. Gomorra jenda abe sɨ, ɨ que Jesús ñee uchɨmondobi je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nyoɨ nyoɨ ja que equia Dios cheẽ nenei nenei mbia je ra. —Jendua sɨ Dios rese, ɨ ɨte que equia mbia ja je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Aba checuayã ɨcuã ngue ejea jea tuchɨ quia mbia chɨangui sɨ ra. Mbae eɨ̃ quira que equiti quiti quia mbia rasi rese ra. Mbucherõ ja que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mbia que jirandu ja Jesús rese cote ra. Herodes abe que jirandu erese ra. Ererecua que ae ra. Juan el Bautista Jesús riqui reɨ̃ Herodes je reaẽ. —Juan ndaaque que quera sɨ ra. Nyebe eriqui nguiã mbae raã jate, ɨ rei que Herodes ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Elías Jesús riqui reɨ̃ emo je reaẽ. Dios cheẽ mbuchecuasa ñiinda Jesús riqui reɨ̃ emo je re no aẽ. ");
INSERT INTO srqNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes que jirandu Jesús rese ra. Juan el Bautista eriqui reɨ̃ nguiã ee. —Juan ño eriqui re. Ae ãquĩ achisia. Quera sɨ chõchɨ̃ ere, ɨ rei que Herodes ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herodes Juan mondo quiatu quia carcel nyii reaẽ. Nyucua nda cadena je ra. Paama ɨ nda Juan je ra. —¡Nde ndenongue ninisi erereco aroneate jẽ! ɨ quiatu que Juan ñee ee nyii ra. Herodes siqui mose nõngue ninisi rese. Herodías, ɨ que enongue ninisi je ra. Felipe, ɨ que enongue je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodías que Juan ucuayãte quia ra. —Taɨquia, ɨ rei que equia ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes bite rei que Juan ñee andu ra. Ɨcuayã jiri rei que ra. —Juan turãte que ra jẽ, ɨ que equia Juan nɨɨ nda. Nyebe eriqui nguiã ɨreɨ̃ ɨreɨ̃te esɨ. Nyebe Herodías Juan ɨquia aroneate nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","—Co mose chõ jẽ, ɨ que Herodías Herodes mbae cumpleaños mose cote ra. —Jenyu quiaru serese, ɨ que Herodes mbia rerecua ja je ra. Ererecua Galilea jenda ja je. ");
INSERT INTO srqNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aque mose que Herodías riirĩ nyuruqui ruqui mbia je ra. Nyucuaaque que ae ra. Herodes ia tuchɨ que mae nyucuaaque nyuruqui rese ra. Ñee ngue nyucuaaque je ra. —¿Mbae ra amee ndeje re? Echeẽ ño seje. ");
INSERT INTO srqNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“Sebite co” nde ɨ mose, aque tamondo ndeje. Sembae ataque tamondo ja ndeje ndebi mose. Acheẽ ñooñoa ño nguiã ndeje a, ɨ que Herodes ñee nyucuaaque je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nyucuaaque que oso ñee usi je ra. —¿Mbae “embu seje” ae ra ee re? ɨ que ñee usi je ra. —“Juan el Bautista ãquĩ ño embu seje”, ere chõ ee, ɨ que esi ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nyebe que esɨ ñee Herodes je cote ra. —Juan el Bautista ãquĩ emee na seje plato ye, ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes chosoi que oso serɨ̃ tuchɨ echeẽ andu mose ra. —Acheẽchɨ̃ se quia ee. A seresenda chɨ ja quiaru serese a resẽ. Ã seandu ja chõchɨ̃. Nyebe ra secheẽ ambuchebi eã ee, ɨ que Herodes uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Soldado mo ngue emondo cote ra. —Quiatu Juan ɨquia. Eãquĩ eru seje, ɨ que ñee soldado je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Cárcel que esɨ Juan ãquĩ sia cote ra. Eãquĩ ngue equeru plato ye nyucuaaque je cote ra. Nyucuaaque que emee usi je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan ñɨmbaaquiatu jirandu mose que echoɨ eraaque rea cote ra. Ñono ngue sɨta ndoro ji ye ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ae Jesús mondo quia uchɨmbaaquiatu, ũquɨ̃ ngue ngaẽ sɨ ee cote ra. Uchɨsaã ngue esenei senei cuaẽ ee ra. —Eɨ̃ ure que mbia mbaaquiatu quiatu ra, ɨ que ecuaẽ Jesús mbiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mbia tubɨrɨãte que ngaẽ ngaẽ nguia ñindecua ndecua erea ra. Equiaru mose rocoɨ̃ abe. Nyebe ñee nguiã uchɨmbaaquiatu je. —Nyao rã mbia eãsaa, jenguenea ucua mbɨrɨ̃, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ae ae que nyoɨ canoa ye mbia eãsaa ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mbia tubɨrɨã tuchɨ ngue mae ñochɨ̃ nguiã echoɨ rese. Jesús ɨcua chõ ngue ra. Mbia que nyoɨ uchã ibi rɨ̃ nda. Sucha jenda ja. Ũquɨ̃ nane ngue nyoɨ ngasẽ Jesús raarõ ama nimia nda. ");
INSERT INTO srqNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús que usẽ canoa sɨ cote ra. Mbia tubɨrɨã ndese que mae nda. Eya eã tuchɨte que erese ra. Oveja raarõ iriã na nguiatu que mbia chɨ ee ra. Mbia que embaaquiatu quiatu tuchɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tenda oso mose que echɨmbaaquiatu ñee ndei ee ra. —Tenda osote resẽ. Mbia chuchua mo ãte a resẽ. ");
INSERT INTO srqNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mbia chɨurã eã abete a resẽ. Mbia embuɨ mondo uchɨurã ndequia requia sacuã sucha achɨ jenda rea rea, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Jeño mbae jemondo ee echɨurã, ɨ chõ ngue Jesús ñee ee ra. —Tei. Mbae quia ra aba mondo ee. Mbia tubɨrɨã tuchɨte quia ñene. Mbae isiquia tubɨrɨã tuchɨ je quia nda aba mbae isi rei nguiã ña. Mbia chayãte chõ eno nde, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Manya mbichae jendeco ũquɨ̃ nde? Jẽso mae erese no, ɨ que Jesús ee ra. Emo ngue oso mae erese eɨcua ra. —Cinco mbichae riqu i co. Sɨra nyeremo abe, ɨ que echɨmbaaquiatu mo ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","—Sã mbia ngoi ngoi ja quiata tose. Echesea sea, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mbia que ngoi ngoi ja nyesea sea cote ra. Cincuenta jaaja. Cien abe no. ");
INSERT INTO srqNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús que mbichae cinco sirõ cote ra. Sɨra nyeremo abe no. Ibei rese que mae gracias ɨ Dios je ra. Mbichae que esiquio quio cote ra. Mee mee ngue uchɨmbaaquiatu je ra. —Jemee mee mbia je, ɨ que uchɨmbaaquiatu je ra. Sɨra nyeremo abe que esiquio quio mbia ja je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mbia ja que eu tuchɨ ra. Ñimbio chee que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mbia chɨu sique tubɨrɨã tuchɨ que ra. Mbichae rire. Sɨra rire abe no. Doce iru que mbia mombisẽ esique sique je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cinco mil hombres que mbia mbichaecua ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aquere que Jesús uchɨmbaaquiatu mondo ja canoa ye ra. —Jẽ nane jẽso Betsaida sobeɨ. Mbia tambuɨ turã na mondo uchuchúaa se nyii, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jesús que mbia mbuɨ turã mondo cote ra. Ae ae que oso sɨta ibátee cote ra. Ñee sacuã Dios je. ");
INSERT INTO srqNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Huee que ae ae riqui itondaru chee ra. Canoa yenda que chɨ beɨ ama ndiite rɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Echɨmbaaquiatu que pare pare ɨ canoa ibu ra. Quɨrɨrɨã ngue eɨchu ɨchute eruba quiti ra. Jesús que mae erese ɨshote ra. Nguira ñee mose que esɨ erɨɨchã nda. I arõ ngue esɨ quia ngata ra. Nyucuaño nda eña nde. ");
INSERT INTO srqNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Mbia aingue eriqui reɨ̃ nguiã echɨmbaaquiatu je. Ngata mose i arõ. Nyebe tasẽ tasẽ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Echɨmbaaquiatu chɨã ngue cuãacuã ɨ tuchɨ mae erese ra. —Jẽsiquichechɨ̃ nguiã. Jẽya chõ ae. Se chõ nyeresẽ, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ua que canoa ye embɨrõ cote ra. Quɨrɨrɨã ngue tiba cote ra. Echɨmbaaquiatu que nyuruɨra tuchɨ u mae erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesús mbichae mbeta quia nae, ũquɨ̃ ngue echɨmbaaquiatu ɨcuayãte uchɨangui re ra. —Dios riirí ño eriqui reaẽ, ɨ ãte que eɨcuayã nda. Eãquĩ ãtãte chõ ngue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ngasẽ nyee que sobeɨ cote ra. Genesaret, ɨ que hue ibi je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jesús usẽ mose canoa sɨ que mbia eɨcua jeɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mbia que nyoɨ ja uchã tuchua mbuchesea sea ra. Erasi rurucuaẽ cuaẽ sacuã Jesús je, erua resebe. ");
INSERT INTO srqNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesús cuatásaa que mbia riqui erasi rurucuaẽ cuaẽ ee ra. Sucha tubɨrɨã jenda jaaja. Sucha mɨɨ mɨɨ jenda jaaja abe no. Turuquia jenda abe no. Ũquɨ̃ ja que erasi curucuaẽ cuaẽ nguia ñono Jesús jii ra. —Sã erasi oco oco ja rã ndeɨrao ai rese, ɨ jaaja que ñee Jesús je ra. Ae oco erese nae, ũquɨ̃ ngue nyerõ ja ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Aquere que fariseos mo ngaẽ ñee Jesús je ra. Embesasa mo abe, ae ngaẽ Jerusalén sɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesús chɨmbaaquiatu mo ngue quiaru quiaru echoɨ quiiriã ee ra. —¿Mbaerã jẽɨngo quiaru jenyoɨ quiiriã nde? Nanderameɨ ñee nduɨ sɨ eã ño jẽɨngochɨ̃ nde, ɨ que ñee asite ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseos quiarei nyoɨ beɨ quiaru nonde. Judíos ja abe no. —Nandechoɨ eã mose ra nandechɨã mondeɨte, ɨ rei equia ã. Ngãmeɨ ñee nguire eriqui ũquɨ̃ naa naa mbeɨ ã. ");
INSERT INTO srqNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Echoɨ quiiriã mose eriqui quiaruã ã. Ngaẽ mose plaza sɨ eriqui nyoɨ nyoɨ tuchɨ quiaru nonde ã. Ngãmeɨ ñee nguire chõ eriqui nguiã mbae raã ja ã. Sã eriqui uyuquia ɨreɨ ɨreɨ no. Ñio abe no. Irachaẽ abe no. Uquisa abe no. ");
INSERT INTO srqNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nyebe fariseos ñee nguiã Jesús je. —¿Mbaerã ndechɨmbaaquiatu riqui eɨ̃ eã nanderameɨ ñee nguire re? ¿Mbaerã eriqui quiaru uchoɨ quiiriã nde? ɨ que fariseos ñee Jesús je ra. Embesasa abe no. ");
INSERT INTO srqNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús que ñee ee ra. —Isaías que embesa jenɨɨ cose ra. Eɨ̃ ngue embesa ra: Ã mbia riqui ñee turãte raque seje ã. Uchɨangui re quia eriquiãte nguiã serese ã. ");
INSERT INTO srqNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ñee turãte raque equia seje ã. Ameɨ ñee achõ ño esenei seneichɨ̃ nguiã mbia je. Dios cheẽ mɨɨ nenei nenei ndocoɨ̃ ee, ɨ que Isaías embesa jenɨɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jenameɨ ñee achõ ño jesenei seneichɨ̃ nguiã mbia je ũquɨ̃. Dios cheẽ nenei nenei ndocoɨ̃ ee. ");
INSERT INTO srqNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Dios cheẽ jemumba mumba chõ chɨ̃ nguiã ã. Nanderameɨ ñee ndese chõ jẽɨngochɨ̃ oote ã. ");
INSERT INTO srqNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés cheẽ nduɨ turã eã ño jẽɨngochɨ̃ ã. Sã Moisés ñee mbia je no: “Jẽturã ño nguia jendu je jẽ. Jẽsi je abe no. Emo ñee ɨcuã mose ngu je, ũquɨ̃ jẽɨquia chõ. Emo ñee ɨcuã mose usi abe je, ũquɨ̃ abe jẽɨquia no”, sã ɨ Moisés no. ");
INSERT INTO srqNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jẽ nguia jẽɨngo nguiã Moisés cheẽ abi abite ã. Sã jẽɨngo ñee no. “Ae nda amee neɨ jẽje, ũquɨ̃ ngue amondo ja Dios je ra”, ɨ mose emo ñee ngu je, “coche ñene” jenye chõchɨ̃ nguiã ee. Mbae mee eã mose ngu je. Usi abe je. Nyebe jẽɨngo nguiã mbia mbaaquiatu ɨcuã ɨcuã ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","¿Mbaerã jẽɨngo mbia riquisã quisãte mbae meese mose usi je re? Ngu je abe no. ");
INSERT INTO srqNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nanderameɨ ñee achõte jẽsenei seneichɨ̃ nguiã jendiirĩ je ã. Nyebe jẽɨngo nguiã Dios cheẽ mbuquiachãte jendiirĩ sɨ ã. Mbae ɨcuã atate jẽsaã saã nguia ã, ɨ que Jesús fariseos je ra. Embesasa abe je. ");
INSERT INTO srqNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","—Jenyu secheẽ andu, ɨ que Jesús mbia ja je ra. —Secheẽ jẽɨcua rã. ");
INSERT INTO srqNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mbia chɨu embɨɨcuã eã nguiã. Echɨangui renda chõ embɨɨcuã nguiã. Echɨangui renda chõ usẽ nguiã echuru rɨ̃ echeẽ mose. Ũquɨ̃ ño embɨɨcuã nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jẽisa mose, secheẽ jeñandu turã na, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús que mbia secha oso ɨque tuchúaa ra. Echɨmbaaquiatu que ñee ee cote ra. —Erecheẽ ngue namo, “ũquɨ̃ nda mbia mbɨɨcuã” ere que, ũquɨ̃ embuchecua rã ndecheẽ ure je, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús que ñee ee ra. —¿Jẽ abe jẽɨcuayãte quia re? Ae mbia u quia nae, ũquɨ̃ mbia mbɨɨcuã eã nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ɨqueã nda oso echɨangui re. Erie ye chõ eriqui nguiã oso. Echiique ruɨ chõ eriqui nguiã oso. Usẽ nyee, ɨ que Jesús ñee uchɨmbaaquiatu je ra. —Mbia chɨu turã ja, ɨ chõ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","—Mbia chɨangui renda chõ embɨɨcuã nguiã usẽ mose echuru rɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Aba chɨangui renda quia aba mundua ɨcuã ɨcuãte nguiã. Nyebe eriqui nguiã siqui emo ninisi rese. Emo ndu rese abe no. Siqui siqui eruã ndese abe no. Mbia abe ɨquia ɨquia. ");
INSERT INTO srqNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Mbae abe mbuquiachã quiachã no. “Aque raã nda sembaerã ña”, ɨ emo mbae je no. Mbae ɨcuã ñumumbara raã naa ja. Mbia abe mbɨɨrɨ̃ ɨrɨ̃ no. Mbae ɨcuã oseɨ oseɨ beɨ. “Se quiatu ae”, ɨ mbae je. Ñee ɨcuã ɨcuã no. Ucuasu abe raã naa no. Mbae ɨcuã naa ja chooño. ");
INSERT INTO srqNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mbia chɨangui renda ɨcuã ja chõ ũquɨ̃ nde. Ũquɨ̃ ño mbia mbɨɨcuã ɨcuã nguiã ũquɨ̃ ao ao mose, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús que nyoɨ hue recha cote ra. Ngasẽ ngue Tiro jii cote ra. Sidón jii abe no. Ɨque que oso tuchua mo nda. —Sã mbia jiranua serese, ɨ rei que ra. Mbia qu e jirandu chõ erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ari mo abe que jirandu erese ra. Eriirĩ ngue aba checuayã nguereco uchɨangui re ra. Ari que tu Jesús rea ra. Ngũíã ndese que ngoi ejii ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Sirofenisia jenda que ae ra. Judío eã tuchɨ que ae ra. Griego cheẽ ño ngue echeẽ nde. —Aba checuayã ɨcuã ejea rã seriirĩ sɨ, ɨ tuchɨ que Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús que ñee ee ra. —Judíos rese rane taɨco mbae raã naa. Ahuɨ aronea judíos sɨ, mbae raã naa mbiamo je, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ari que ñee ee ra. —Aɨcuate raque se, Sererecua. Mbiamo ndaque ure. Judíos eã ndaque ure. Ure je abe chõ mbae esaã ae. Seriirĩ embucherõ seje ae, ɨ que ari ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús que ñee ee ra. —Erecheẽ turãte. Quiatu rei. Nderiirĩ ngue nyerõ no, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ari que oso uchuchúaa cote ra. Ɨ que eriirĩ u ngua ye ee cote ra. Aba checuayã ɨcuã usẽ ño ngui a esɨ reaẽ. ");
INSERT INTO srqNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús que nyebi Tiro rurubi sɨ ra. Sidón ngue etasamo nda. Ama ndɨsha Galiléaa que esɨ ra. Decápolis rɨ̃ ngue esɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Eisayã mo ngue mbia curucuaẽ ee ra. Echeẽ aquiatuãte abe que ra. —Ndeo echono earõ embucherõ, ɨ tuchɨ que mbia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús que eisayã nguerao pe jiri mbia recha ra. O que emingue mondo eisacua rereco chobeɨ ra. O que embia ngũendi je ra. Mondo que echuru rɨ̃ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Soboiba que ibate cote ra. Jiabute que ñee ee ra. —Esoro, eisacua, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eisacua que soro cote ra. Echuru abe que nyerõ cote ra. Ñee ngue cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","—Emo nda jembiiranduchɨ̃ jẽ, ɨ rei que Jesús ñee mbia je ra. Mbia que ñɨmbiirandu ɨ ɨ tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mbia que ñee ñee nyue Jesús rɨɨ̃ nda. —Mbae raã turã turã ja tuchɨchɨ̃ equi a co. Eisayã abe isa ndoro chee no. Echeẽ ngũíã abe mbucheẽ nyee no, ɨ ja tuchi que mbia quia nyuruɨra mae erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mbia que ñumunua tuchɨ Jesús je aque mose ra. Ñee ngue uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Seya eãte aɨco ã mbia tubɨrɨã ndese co. A echɨ arete serese tres días a. Echɨurã mo eãte mbae mo aa. ");
INSERT INTO srqNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Eriãcuã amondo sereãte echuchúaa. Ngasẽ ãte chõ ndae. Ɨshote sɨ ecuaẽ aa resẽ. Nandembuquiaru chõ aa, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Echɨmbaaquiatu que ñee ee ra. —Turuquia re chõ nandeɨco a resẽ. ¿Mañɨ nda aba ã mbuquiaru ja re? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Manya mbichae jendeco re? ɨ que Jesús ee ra. —Siete, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesús que mbia mbucoi ja íbii ra. Mbichae siete que eisi ja o je cote ra. Gracias ɨ que Dios je cote ra. Mbichae qu e esiquio quio mee uchɨmbaaquiatu je cote ra. Ũquɨ̃ ngue embuchao chao mbia tubɨrɨã je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sɨra ñetẽ mɨɨ abe que equereco ra. Gracias ɨ que Jesús Dios je cote ra. —Sɨra abe jembuchao chao mbia je, ɨ abe que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mbia que eu ja ñimbio chee ra. Echɨu sique que emunua nua ja ra. Siete iru que emombisẽ nyee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mbichaecua rei mbia cuatro mil. Jesús que embuɨ turã mondo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Canoa ye que Jesús ua uchɨmbaaquiatu rese cote ra. Nyoɨ que Dalmanútaa ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","—Tã nande rã Jesús je, ɨ que fariseos cuaẽ ñee ñee ee ra. —Mbia mae sayã esaã na ure je. Ɨ̃ nda “Dios chɨmbu” ure tuchɨ ndeje, ɨ rei que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús que iabu tuchɨ ñee nda. —¿Mbaerã mbia riqui “mbia mae sayã esaã ure je” ɨ tuchɨ re? Tacheẽ nyecua jẽje. Mbia mae sayã mo nda ateacuquia eã tuchɨ jẽje, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Oso que mbia recha cote ra. Iasa que echoɨ sobeɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesús chɨmbaaquiatu que uchɨurã curuchoɨ eã nda. Tesareɨ que esɨ ra. Mbichae mɨɨ tuchɨ que equeru huee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús que ñee ee ra. —Mbichae mbuchɨmatãsa rã ndei fariseos cheẽ. Herodes chɨmbaaquiatu cheẽ abe no. Ũquɨ̃ ñee ndese ra jẽɨngochɨ̃ jẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","—Mbichae quiatu ngue nanderuã nguiã. Nyebe eriqui nguiã ñee nande je ũquɨ̃, ɨ rei que echɨmbaaquiatu ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús que echeẽ ñee ɨcuate ra. Nyebe ñee nguiã ee. —¿Mbaerã jẽɨngo “mbichae nanderuãchɨ̃” ɨ re? ¿Ae rɨɨ̃ aɨco ñee jẽje nae, ũquɨ̃ jẽɨcuayã mbeɨte quia re? ¿Jeñɨa ãtã mbeɨte eriqui re? ");
INSERT INTO srqNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jẽisate raque. ¿Secheẽ jeñanua mbeɨte quia re? Jendesate raque. ¿Sechɨsaã jẽɨcuayã mbeɨte quia re? ");
INSERT INTO srqNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Se mbichae cinco mbeta mose mbia cinco mil je, ¿manya iru jemombisẽ mbichae sique sique je re? ɨ que Jesús ee ra. Doce, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Mbichae siete mbeta mose mbia cuatro mil je, ¿manya iru jemombisẽ esique sique je re no? ɨ que Jesús ee ra. Siete, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—¿Jẽɨngo secheẽ ɨcuayã ɨ ɨte ã nde? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nyoɨ que Betsaida cote ra. Mbia que ameɨ ndesayã mo ngurucuaẽ Jesús je ra. Oco sacuã erese embucherõ. ");
INSERT INTO srqNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús que eo isi serao pe jiri sucha sɨ cote ra. Ngũendi que equiti eresa rese ra. O que echono earõ nda. —¿Eremaete mbae rese cote re? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eresayã ngue mae cote ra. —Mbia rese amaete cote. Ecuata rese amaete. Ira raãte mbia seje, ɨ que eresayã nda. ");
INSERT INTO srqNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús que o chonombe eresa rese ra. Mae turã ngue cote ra. Nyerõ tuchɨ que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús que embuɨ mondo uchuchúaa ra. —Eresochɨ̃ nda sucha ite rɨ̃ jẽ, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús que nyoɨ Cesarea de Filípoo cote ra. Huee que ñee uchɨmbaaquiatu je cote ra. —¿Aba aɨco reɨ̃ mbia je re? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Echɨmbaaquiatu que ñee ee ra. —Juan el Bautista ereɨco reɨ̃ nguiã mbia je co. Elías ereɨco reɨ̃ nguiã emo je no. Dios cheẽ nenei neneisa mo ereɨco reɨ̃ nguiã emo je no, ɨ que echɨmbaaquiatu ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—¿Aba aɨco reɨ̃ jẽje co re? ɨ que Jesús ee ra. —Cristo chõ nde resẽ, ɨ que Pedro ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Jeñeechɨ̃ nda mbia mo je ũquɨ̃ jẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús que umano nonde senei senei uchɨmbaaquiatu je ra. —Mbae rasi ra asaã tuchɨ. Judíos rameɨ ɨcuã ɨcuã tuchɨ ra seje. Sacerdotes rerecua abe no. Embesasa abe no. Seɨquia rae. Tres días mose ra aquera sɨ, ɨ que ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesús que ñee nyecua tuchɨ ee ra. Nyebe Pedro Jesús rerao nguiã suruɨcha. —¿Mbaerã erecheẽ ũquɨ̃ nde? Mbia ra ndeɨquiayã, ɨ rei que Pedro ñee asite Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús que uba mae uchɨmbaaquiatu rese ra. Ñee ngue Pedro je ra. —Ehuɨ chõ sesɨ, Satanás. Mbia ndua ndua rã ño ereɨco nguiã ndua. Dios ndua ndua rã eã, ɨ que ñee Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesús que ñee uchɨmbaaquiatu ja je cote ra. Mbia abe je. —Emo siquise mose seruɨ, sã huɨ ja mbae ubi sɨ. Sã cruz ruɨ umbaerã se rã sɨ. Sã eriqui seruɨ beɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Emo ndua beɨ mose ngueco rese, ereco ra ua esɨ. Emo huɨ mose ngueco sɨ seje, ũquɨ̃ nda siqui beɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Emo ngueco mumba chooño mose, eya eã mbeɨ rae. Mbaecha rete raque. ");
INSERT INTO srqNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Emo ngueco mumba chooño mose, mbae mo eãte ereco rɨbɨshorõ sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Emo ɨreɨ̃ ɨreɨ̃ mose sesɨ mbia ɨcuã ndésaa, se abe ra aɨreɨ̃ ɨreɨ̃ esɨ. Emo ɨreɨ̃ ɨreɨ̃ mose secheẽ sɨ, se abe ra aɨreɨ̃ ɨreɨ̃ esɨ, sechu mose mbia rerecuarã. Dios ra sembu sɨ íbii uquirãcuã je aque mose. Ibatenda rese ra achu ángeles, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","—Tacheẽ nyecua jẽje. A jengu a nae, jemo nda jemae sechu rese. Achu ra mbia rerecuarã tuchɨ cote. Jemo jemano eã mose ra achu mbia rerecuarã tuchɨ cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tenda seis uare que Jesús uchɨmbaaquiatu mo nderao sɨta ibátee ra. Pedro. Jacobo. Juan abe no. Ũquɨ̃ ngue equerao ja mbia tiãsaa ra. Jesús que nyɨɨcuabo erésaa huee ra. Enininya tuchɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Eɨrao abe nininya tuchɨ que ra. Eɨraoshĩ nininya tuchɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mbia nyeremo ngue ngaẽ ibate sɨ ra. Ñee ñee ngue ecuaẽ Jesús nininya rese ra. Moisés que ũquɨ̃ nda. Elías rese. ");
INSERT INTO srqNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro que ñee Jesús je ra. —Sererecua, nandecu turãte a. Sucha ñetẽ uresaã saã na. Enongue nembaerã. Enongue Moisés mbaerã. Enongue Elías mbaerã no, ɨ rei que Pedro ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Echɨmbaaquiatu siquichete quiatu ngue re. Nyebe Pedro riqui nguiã “mañɨ nda aba re” ɨte. ");
INSERT INTO srqNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ibeishĩ ngue tu nguichi eite re cote ra. Moisés mbuchecuayã ee. Elías abe no. Echeẽ mo ngue echandu ibeishĩ qui re ra. —Co rei sebi tuchɨ seriirĩ co. Echeẽ jeñandu beɨ quia, ɨ que Dios ñee ee ibeishĩ qui re ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Echɨmbaaquiatu mae mose que Jesús mɨɨ ndiqui ee cote ra. Moisés que nyecuayã asi ee ra. Elías abe. ");
INSERT INTO srqNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ecuaẽ mose nguichi sɨta ibate sɨ que Jesús ñee ee ra. —Ae rese jemae namo nae, ũquɨ̃ je jenyecuachõ jẽ. Sequera sɨ mose quiatu teñee ñee mbia je cote. Semano nonde eã, ɨ que Jesús ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nyebe ñee eã nguiã emo je. —¿Mbaerã eriqui “se quera sɨ mose” ɨ re? ɨ que ndua ndua ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ñee ngue Jesús je cote ra. —¿Mbaerã embesasa ñee nde? “Elías rane nda tu Cristo sɨ” ɨ re, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús que ñee ee ra. —Ae beɨ. Coche Elías rane tu nguiã mbae mbitirõ ja. ¿Mbae ɨ chõ embesa ji quia Cristo rɨɨ̃ ña? “Mbae rasi ra esaã tuchɨ”, ɨ chõ nguiã. “Mbia ra eucuayã tuchɨ”, ɨ chõ nguiã no. ");
INSERT INTO srqNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Elías que tu no. Mbia ɨcuã ɨcuã tuchɨ que ee ra. Sã embesa ji ñee nyii no. Eɨ̃ sɨ tuchɨ que ra, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ngasẽ ngue echoɨ echɨmbaaquiatu ataque je cote ra. Mbia tubɨrɨã tuchɨ que chɨ echɨmbaaquiatu mama huee ra. Ɨ que embesasa u ñee ɨcuã ɨcuã echɨmbaaquiatu je huee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús ngasẽ mose que mbia nyuruɨra tuchɨ mae erese ra. Oo tuchɨ que erese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","—¿Mbae rɨɨ̃ jẽɨngo ñee ɨcuã ɨcuãte jenyue re? ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Emo ngue ñee Jesús je ra. —Sererecua, seriirĩ aru quia ndeje co. Nde embucherõ sacuã. Aba checuayã ɨcuã equereco uchɨangui re co. Nyebe eriqui nguiã ñee eãte co. ");
INSERT INTO srqNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aba checuayã ɨcuã ndiqui seriirĩ isi isi beɨte co. Mbucoɨ coɨ beɨte equia íbii co. Echuru abe mbɨchoɨte. Ureɨ̃ abe quiti quitite. Nyebe equirãcuã neate riqui nguiã co. “Aba checuayã jẽjea seriirĩ sɨ”, ae rei que ndechɨmbaaquiatu je ra. Eaquiatuãte chõ ngue ra, ɨ que eru ñee Jesús j e ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús que ñee cote ra. —¿Mañɨ jenye quia seɨcuayãte re? ¿Ñimbirãcuã mbeɨte ra aba quia jẽje re? ɨ que Jesús ra. —Eriirĩ jendu rã seje, ɨ que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eriirĩ ngue ecurucuaẽ ee cote ra. Aba checuayã ngue eriirĩ mburirite Jesús rese mae mose ra. Mbucoɨ que íbii ra. Mbuchɨɨshao shao tuchɨ que ra. Echuru mbɨchoɨ tuchɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","—¿Manosete aba checuayã ndiqui ererequia re? ɨ que Jesús eru je ra. —Eñetẽ mosebe beɨ, ɨ que eru ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","—Tátaa eriqui emondo mondo beɨte co. Ama ye abe. Erɨɨcharã. Nde ejea aquiatu mose, ejea rã esɨ ure je, ɨ que eru ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús que ñee ee ra. —¿Mbaerã ereɨco “ndeaquiatu mose” ɨ seje re? Ae seɨcua quia nae, ũquɨ̃ je aɨco mbae raã aquiatu jate co resẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Eru que ñee ee ra. —Areɨcuate se resẽ. Semingo uquiabe jiri nderese ae, ɨ que eru ucheẽ mumbebote ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ɨ que mbia cuaẽ nguia ñumunua nua tuchɨ huee ra. Nyebe Jesús ñee asi nguiã aba checuayã ɨcuã je. —Aba cheuayã, mbia isa erembɨɨtaote quia hue. Erembucheẽ ngũiãte abe equia hue. Esẽ oso esɨ. Ereɨque sɨchɨ̃ nda oso echɨangui re jẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aba checuayã ngue tasẽte eriirĩ mburiri cote ra. Usẽ oso cote. Eraaque rã ngue eriirĩ nyɨ cote ra. Mano neɨ nguiã mbia je. ");
INSERT INTO srqNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús que emua eo rese ra. Juã turã ngue cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesús que oso ɨque tuchúaa cote ra. Echɨmbaaquiatu que ñee ee mbia tiámbaa cote ra. —¿Mbaerã aba checuayã useã oso urecheẽ mose ure re? ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús que ñee ee ra. —Jeñee eã mose Dios je, ã jẽjea aroneate. Jẽhuɨ eã mose jenyɨu sɨ, ã jẽjea aroneate no, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Galilea rɨ̃ ngue echoɨ hue sɨ ra. —Sã mbia jiranua nanderese, nandeso mose hue rɨ̃, ɨ que Jesús ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Uchɨmbaaquiatu ae que embaaquiatu quiatu oso quia ñeenda ruɨ ra. —Emo nda semee mbia ɨcuã je seɨquia sacuã. Seɨquia ji ra aquera sɨ tres días mose, ɨ que equia embaaquiatu quiatu ñeenda ruɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Echɨmbaaquiatu que echeẽ ɨcuayãte quia ra. —Ndecheẽ embiasa asa tuchɨ rã ure je, ɨ ãte que equia ee ra. Ɨreɨ̃ ɨreɨ̃te quiatu que equia esɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ngasẽ ngue Capernaum nda. Tuchúaa ɨque mose que ñee uchɨmbaaquiatu je ra. —¿Mbae rɨɨ̃ jenyu quia ñee ɨcuã ɨcuãte jenyue ñeenda ruɨ re? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Quɨrɨrɨ ja chõ ngue u ñee ndocoɨ̃ ee ra. —Ererecuarã nda se cote, ɨ jaaja chõ equia nyue ñeenda ruɨ reaẽ. Nyebe eriqui ɨreɨ̃ ɨreɨ̃te Jesús sɨ re. ");
INSERT INTO srqNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús que ngoi cote ra. —Jenyu ja rã. Tacheẽ jẽ ja je, ɨ que uchɨmbaaquiatu doce je ra. —“Ererecuarã se” ɨ mose emo, sã uataque rimbarã ño eriqui, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ãquẽ mo ngue emɨɨ eite re cote ra. Suɨ que ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ae siqui turã nguia mbi a riirĩ je serɨɨ̃ nae, seje abe chõ eriqui nguiã siqui turã. Ae eturã ndiqui seje nae, semondosa abe je chõ eturã ndiqui nguiã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan ngue ñee Jesús je ra. —Pe emo nyɨ aba checuayã ndirõ ndirõ mbia sɨ nderɨɨ̃ pe. Uremae ngue erese ra. Aque eriqui ãte nanderese aque. Nyebe uresiquisã nguiã, ɨ que Juan Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús que ñee ee ra. —Tei. ¡Jẽsiquisã quisãchɨ̃ nda jẽ! Emo mbia mae sayã naa mose serɨɨ̃, ñee ɨcuã eã nda seje aquere. ");
INSERT INTO srqNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Emo ɨcuã eã mose nande je, nanderesenda chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Emo sechɨmbaaquiatu ɨseɨ mbiu turã mose serɨɨ̃, Dios abe ra mbae turã mondo aque je. ");
INSERT INTO srqNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ae ra mbae ɨcuã saã uquia seɨcuasa mo je nae, ũquɨ̃ nda mbae rasi saã tuchɨ cote. Ũquɨ̃ nda aba mombo chõ ama ndɨsha ye nyii re chã. Sɨta resebe ecua ji mondo. Ɨ̃ nda mbae ɨcuã naa uquia eãte rei seɨcuasa je. ");
INSERT INTO srqNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ndeo nemingo mose mbae ɨcuã ndese, ndeo echisia mombo. Coche rei ra ereso ibate ndeo mɨɨ Nderequia, siqui beɨ sacuã huee. Oso rocoɨ̃ tata cuásuu, ndeo nyeremo nderao. Tata mungue aronea tuchɨ chõ hue jenda re. ");
INSERT INTO srqNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mbae rosei ra manoa mbeɨ huee. Tata ra uqueã mbeɨ huee no. ");
INSERT INTO srqNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ndei nemingo mose mbae ɨcuã ndese, ndei echisia mombo. Coche rei ra ereso ibate ndei mɨɨ nderequia, siqui beɨ sacuã huee. Nemombo rocoɨ̃ tata cuásuu, ndei nyeremo nderao. Tata mungue aronea tuchɨ chõ hue jenda re. ");
INSERT INTO srqNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mbae rosei ra manoa mbeɨ huee. Tata ra uqueã mbeɨ huee no. ");
INSERT INTO srqNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nderesa nemingo mose mbae ɨcuã ndese, nderesa echoo. Coche rei ra ereso Dios recua nderesa mɨɨ nderequia. Nemombo rocoɨ̃ tata cuásuu, nderesa nyeremo nderao. ");
INSERT INTO srqNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mbae rosei ra manoa mbeɨ huee. Tata ra uqueã mbeɨ huee no. ");
INSERT INTO srqNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tata ra mbia sei beɨ huee. ");
INSERT INTO srqNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Embiquesa rã ño jẽɨngo nguiã mbia je ã. Sã embiquesa turãte no. Eɨse quiachamba mose, eɨcuã tuchɨ ra cote. Embiquesa rã tuchɨ chõ jẽɨngo mbia je. Jẽɨngo turã ño nguia jenyɨese, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús que ngata sɨ oso cote ra. Judéaa que esɨ ra. Ama Jordán ndobeɨ que esɨ sobeɨ cote ra. Mbia que ñumunua nua tuchɨ quia ee ra. Mbaaquiatu quiatu que equia ra. Sã eriqui mbia mbaaquiatu quiatu beɨte no. ");
INSERT INTO srqNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseos mo abe que ngaẽ erea ra. —Tã nande Jesús je no. Ma ñee Dios cheẽ abi, ɨ que ñee nyue ra. —¿Coche mbia ngũinisi jea ubiã mose re? ɨ que ñee Jesús je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿Mbae ɨ Moisés embesa re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Fariseos que ñee ee ra. —“Jeninisi jea nonde, papel mbesa ji jemondo ee”, ɨ que Moisés ra, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús que ñee ee ra. —Jeãquĩ ãtãte quiatu ngue re. Nyebe Moisés ũquɨ̃ mbesa nguiã jẽje. ");
INSERT INTO srqNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ũquɨ̃ ɨ ãte que Dios quia mbia ao ramo mose nyii ra. Dios mbia ao mose, nyeremo ngue echao ra. Erãcuẽ ngue echao ra. Eninisirã abe que echao no nda. ");
INSERT INTO srqNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nyebe ra emo ndiqui ngũinisi rese beɨ. Ngu sɨ ɨsho. Usi sɨ abe no. Ngũinisi mɨɨ ndese siqui beɨ sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Co mɨɨ na siqui sacuã nyɨese cote. Nyeremo siqui rã eã ño cote re. Co mɨɨ siqui rã ño ũquɨ̃ cote re. ");
INSERT INTO srqNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ae Dios mbucha nyɨese nae, sã ũquɨ̃ huɨ eã mbeɨ nyesɨ, ɨ que Jesús ñee fariseos je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ngasẽ mose tuchúaa que echɨmbaaquiatu ñeembe ee ra. —Ndecheẽ embiasa turã na ure je, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús que ñee ee ra. —Ae ngũinisi jea nae, emo ndese siqui sacuã nae, eɨcuã tuchɨ chõ ũquɨ̃ nde. Adulterio ɨ que ũquɨ̃ je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Cuña mo ngu jea mose siqui sacuã emo ndese, eɨcuã tuchɨ chõ ũquɨ̃ no nde, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mbia que nguiirĩ ngurucuaẽ cuaẽ nguia Jesús je ra. Jesús oco oco sacuã erese. —¿Mbaerã jendiirĩ jendu quia co re? ɨ rei que echɨmbaaquiatu ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús que paama ɨ ñee uchɨmbaaquiatu je ra. —Jeñeechɨ̃ nguiã ee. Sã ae ae riqui nguiirĩ ndurucuaẽ cuaẽ seje. Eɨ̃ ño Dios rimba nguiã. Ucuasu raã naa eã. Mbia riirĩ na. ");
INSERT INTO srqNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mbia riirĩ na ño jẽɨngo Dios isi turã. Ɨ̃ mose ra Dios rimba tuchɨ jẽ cote, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mbia riirĩ ngue esuɨ suɨ ra. O que echono ñono earõ nda. Ñee turã ngue Dios je erɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Acuanɨndu mo ngue tu Jesús je ra. —Mbia mbaaquiatusa turãte nde. ¿Mbae turã mo nda asaã Dios je semingo beɨ sacuã nde? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús que ñee ee ra. —¿Mbaerã ereɨco “eturã” ɨ seje re? Dios mɨɨ ño eturã ndesẽ. ");
INSERT INTO srqNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dios cheẽ emumbayã. Echeẽ ereɨcuate quia co resẽ: “Emo ninisi rese ra ereɨcochɨ̃. Mbia ra ereɨquiachɨ̃. Mbae ra erembuquiachãchɨ̃. Erecheẽ ñooñochɨ̃ nda emo nɨɨ. Emo nda erembɨɨrɨ̃ ɨrɨ̃chɨ̃. Ndeturã ño nderu je. Ndesi abe je”, ɨ que Dios cheẽ nda, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Acuanɨndu que ñee ndei ee ra. —Ũquɨ̃ ngue amumbayã ja beɨ quia ra. Señetẽ mosenda beɨ, ɨ rei que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús que nyesecua tuchɨ mae mose erese ra. —Ã mɨɨ mo abe eresaã eãte. Nembae emondo mondo ja mbia mbaecha reã je. Nde ũquɨ̃ naa mose, mbae tubɨrɨã nda nembae ndeɨco mose ibate. Nembae mondo ja mose mbaecha reã je, seruɨ eɨco cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Acuanɨndu Jesús cheẽ andu mose que echɨã ndoso tuchɨ cote ra. Eya eã tuchɨ que oso Jesús recha ra. Mbaecha tuchɨte quiatu ngue ae re. ");
INSERT INTO srqNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús que mae mbia rese ra. —Mbaranguiatu ãte mbaecha je ngasẽ sacuã ibate, siqui beɨ sacuã huee, ɨ que ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Echɨmbaaquiatu que nyuruɨra tuchɨ eandu ra. Jesús que ñeembe ee ra. —Ae ndua ndua beɨte quia umbae tubɨrɨã ndese, mbaranguiatu ãte ũquɨ̃ je oso sacuã ibate Dios rese. ");
INSERT INTO srqNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sã ticuasu mo ndiqui oso aroneate ɨque aguja sorei rɨ̃ no. Eɨ̃ sɨ chõ mbaecha no nde. Oso aronea ibate Dios rese, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Echɨmbaaquiatu que nyuruɨra tuchɨbe u eandu no nda. —¿Aba quiatu ra oso Dios rea ibate re no? ɨ que ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús que mae erese ñee ee ra. —Ae mbia saã aroneate quia nae, Dios mɨɨ ño nda esaã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro que ñee Jesús je ra. —Ure que urembae uresecha ja ra. Siqui sacuã nderuɨ, ɨ que Pedro ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús que ñee ee ra. —Tacheẽ nyecua jẽje. Emo umbae secha ja mose siqui sacuã seruɨ, embae ra asɨbɨshorõ tuchɨ ee cote. Ae uchuchua secha. Ae ngõngue secha. Ae ngu secha. Ae usi secha. Ae nguiirĩ secha. Ae umbae ibi secha no. ");
INSERT INTO srqNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ũquɨ̃ mbae ja ra asɨbɨshorõ tuchɨ cien veces ereco mose íbii. Echuchua ata. Enongue ata. Esi ata. Eriirĩ ata. Ibi ata abe no. Ũquɨ̃ ja ra asɨbɨshorõ tuchɨ ee. Mbia ɨcuã ɨcuã tuchɨ ra ee serɨɨ̃. Aquere ra siqui beɨ tuchɨ Dios rese ibate cote. ");
INSERT INTO srqNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ae ererecua saã saã nguia namo nae, ererecua eã tuchɨ ra ũquɨ̃ m o cote. Ae ererecua eã namo nae, ũquɨ̃ mo nda ererecua cote, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalén ngue echoɨ quia ra. Jesús que oso quia enonde ra. Echɨmbaaquiatu que siquichete nyoɨ quia ra. Nyebe Jesús ererao nguiã mbia tiãsaa ñee sacuã ee. ");
INSERT INTO srqNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Co nyao quia Jerusalén co. Huee ra mbia semee sacerdotes rerecua je. Embesasa abe je. “Jesús jẽɨquia”, ɨ ra serɨɨ̃. Semee nda judíos eã je cote. Seɨquia sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mbia ra secheẽ saã saã. Seiruã nua abe ra eno. Sembucha chee ra ɨquia ira rese. Tres nyaashɨ̃ mose ra aquera sɨ, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobo que oso Jesús rɨɨchã ngõngue rese ra. Juan, ɨ equia ee. Zebedeo riirĩ ndei ũquɨ̃. —Urechu ñee ndeje aa, Urembaaquiatusa. Ae rɨɨ̃ nda urecheẽ ndeje nae, ũquɨ̃ je “eno” ere rã ure je, ɨ rei que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Mbae ra aba saã jẽje re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Ndeɨco mose ererecua tuchɨ, sã ure abe ureɨco ererecuarã nderese. Sã urecoi ja u ndejii. Co mɨɨ chɨ̃ ndequiato cuti. Enonge chɨ̃ ndequiato cutiã no, ɨ rei que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús que ñee ee ra. —Ae rɨɨ̃ jẽɨngo ñee seje nae, jẽirandu turã eãte ũquɨ̃ ndese. Ae rasi ra asaã tuchɨ nae, ¿ũquɨ̃ ndasi ra jẽsaã jẽ abe re? Bautizar ɨ ra seje, ¿eɨ̃ nda bautizar ɨ jẽ abe je re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Ae” ɨ que ñee ee ra. Jesús que ñee ee cote ra. —Ae beɨ. Ae rasi ra asaã tuchɨ nae, ũquɨ̃ ndasi ra jẽsaã tuchɨ rei jẽ abe. Bautizar ɨ ra seje, eɨ̃ sɨ rei ra bautizar ɨ jẽje no. ");
INSERT INTO srqNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","“Ererecuarã ure”, jenye rei que seje, ũquɨ̃ asaã aroneate se jẽje. Paba ae quiatu ra ũquɨ̃ saã. A e ebite, ũquɨ̃ nda emɨɨ ererecuarã, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Echɨmbaaquiatu ataque que jirandu erese ra. Echɨmbaaquiatu diez. Paama ɨ que Jacobo je ra. Juan je abe. ");
INSERT INTO srqNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús que “jenyu” ɨ ñee uchɨmbaaquiatu ja je cote ra. —Mbia ataque rerecua riqui ucuasu raã naa tuchɨ ngũimba je ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ũquɨ̃ nda jẽsaã eã jẽ. “Ererecua ra se”, ɨ mose jemo, sã ũquɨ̃ siquichõ uataque rimbarã. ");
INSERT INTO srqNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jemo “se rane jẽ” ɨ mose, sã ũquɨ̃ ndiqui beɨ mbae turã naa naa uataque je no. ");
INSERT INTO srqNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","“Sã mbia mbae turã naa naa seje”, ae eã ngue u ra. “Se quiatu mbae turã tasaã saã oso mbia je”, ae u nguiã. Co achu quia mano mbia tubɨrɨã ndiquicharõ sacuã co, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesús que ngasẽ Jericoo ra. Uchɨmbaaquiatu rese. Jesús ngata mose hue sɨ, mbia tubɨrɨãte que nyoɨ quia eruɨ ra. Eresayã mo ngue chɨ̃ ñeenda jie huee ra. Ache ache ɨ que huɨ̃ nda. Bartimeo, ɨ equia ee. Timeo ndiirĩ ngue ae ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jirandu mose Jesús rese que ñeemombo mombo ee ra. —¡Jesús! ¡David nducucha! ¡Ndeya eã ño serese jẽ! ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","—¡Equɨrɨrɨ chõ jẽ! ɨ tuchɨ rei que mbia ñee ee ra. —¡Sererecua! ¡David nducucha! ¡Ndeya eã ño serese jẽ! ɨbe que eresayã ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús que tiba ra. —Eresayã jendu rã, ɨ que ra. Mbia que ñee eresayã je ra. —Ndeya chõ jẽ. Ehuã. Jesús riqui ñee ndeje a, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Juã asi que oso oo Jesús rese ra. Uchɨatiquia recha. ");
INSERT INTO srqNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","—¿Mañɨ ae ra ndeje re? ɨ que Jesús ñee ee ra. —Seresa embuturã na, Sererecua, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús que ñee ee ra. —Eso cote. Seɨcuate que se ra. Nyebe nderesa nyerõ nguiã cote, ɨ que ee ra. Aque mose tuchɨ que eresayã ndesa turã ja cote ra. Jesús ruɨ que esɨ quia cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesús que Jerusalén curubite nyoɨ quia ra. Betfagé, ɨ que hue sucha je ra. Ibi ibate mo abe que chɨ̃ huee ra. Monte de los Olivos, ɨ que ee ra. Hue sɨ que Jesús uchɨmbaaquiatu nyeremo mo mondo ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ñee ngue ee ra. —Achɨ sucha chõ jẽso rã. Jengasẽ namo mose ra burro riirĩ cuasa mo ñɨ jẽje huee. Emo ngue nyuɨ eãte eátoo ra. Jenyura seru seje. ");
INSERT INTO srqNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Emo ñee mose jẽje, “¿mbaerã nda jenyura re?” ɨ mose jẽje, jeñee ee. “Nandererecua que ‘jendu’ ɨ ra. Mondo jeɨbe ra jẽje”, jenye ee, ɨ que Jesús ñee ũquɨ̃ nyeremo mondo ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nyoɨ que erea cote ra. Burro riirĩ ngue etea Jesús cheẽ nguire cote ra. Ecuasa que chɨ̃ taicuee eɨquesa jii ra. Nyura que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ae mbia chɨ huee nae, ũquɨ̃ mo ngue ñee ee ra. —¿Mbae rese jẽɨngo hue re? ¿Mbaerã jẽɨngo era era re? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesús cheẽ nduɨ sɨ que ũquɨ̃ ñee ee ra. “Eno” ɨ que mbia ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Burro riirĩ ngue ecuruchoɨ Jesús je cote ra. Huɨɨrao que echono ñono earõ nda. Jesús que nyuɨ eátoo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jesús que ngata oso quia burro átoo cote ra. Mbia tubɨrɨã ngue huɨɨrao mbiitee tee nyoɨ quia ibi rɨ̃ enonde ra. Emo ngue sɨndo mbiitee tee choɨ quia enonde no nda. Jesús oso sacuã hue rɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mbia ia tuchɨ que tasẽ tasẽ nyoɨ quia enonde ra. Eruɨ abe no. —Co nandererecua ru quia ngasẽte co. Co Dios chɨmbu ru quia ngasẽte nande je co. ");
INSERT INTO srqNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","David nducucha ru quia co. Nandererecua turã sacuã. Dios turã tuchɨ riqui nande je co, ɨ tuchɨ que mbia quia ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús que ngasẽ Jerusalén cote ra. Ɨ que que oso Dios chuchua cote ra. Mae ja mose mbae rese que esɨ Betania uchɨmbaaquiatu rese cote ra. Tenda quiatu ngue osote nguiã ee. ");
INSERT INTO srqNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ɨ que Jesús choɨ quia Betania sɨ isamamɨ nda. Eriãcuãte que oso quia ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ɨsho que mae higo i mo ndese ra. Ero rerecua que ra. —Ea mo tau, ɨ rei que oso erea ra. Ero achõte chõ ngue ee ra. Aque mose que eriqui ɨa eã nda. ");
INSERT INTO srqNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesús que ñee higo i je cote ra. —Mbia ra ndea u eã mbeɨ cote, ɨ que ee ra. Echɨmbaaquiatu abe que echeẽ ñandu ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ngasẽ ngue Jerusalén cote ra. Jesús que oso Dios chuchúaa ra. Huee que mbia riqui mbae isi isi beɨ ra. Mbae mondo mondo abe mbae isiquia rɨbɨshorõ. Ũquɨ̃ ja que Jesús mbusẽ mondo ra. Ae mbae isiquia sɨbɨshorõ shorõ nguia, ũquɨ̃ mbae abe que embuchiichere chere ja mesa ra. Mbae ja resebe. Ae nyurushɨ cuasu mondo mondo mbia je mbae rɨbɨshorõ nae, ũquɨ̃ nenda abe que embuchiichere chere ja ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesús que ñee ũquɨ̃ je ra. —Dios chuchua ite rɨ̃ jẽɨngochɨ̃ nguiã mbae rerao rao. ");
INSERT INTO srqNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","“‘Mbia cheẽsa Dios je’, ɨ ra mbia Dios chuchua je”, ɨ rei que embesa ji huɨ̃ nda. Jẽ nguia jẽɨcuã tuchɨte Dios chuchua je re. Mbae mbuquiachãsa chuchua jẽsaãte chɨ̃ nguiã ee, ɨ que Jesús ñee asite ũquɨ̃ je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sacerdote rerecua que chɨ Jesús cheẽ andu ra. Embesasa abe no. —¿Mañɨ nda aba Jesús ɨquia re? ɨ que eu ndua ndua ra. Mbia quiatu que oote Jesús cheẽ ndese ee ra. Nyebe eriqui nguiã Jesús ucuayãte. ");
INSERT INTO srqNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hue sucha qu e Jesús secha oso eresaitõ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ɨ que Jesús nyoɨ quia isamamɨ nda. Higo i cutite que echoɨ quia ra. Higo i ñimama ño nguia reaẽ. Erao abe mano ño nguia re no aẽ. ");
INSERT INTO srqNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro que ndua ñee Jesús je ra. ¡—Sã Sererecua! Higo i je que erecheẽ asi nae, mano ño equia cote reaẽ, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús que ñee ee ra. —Dios jẽɨcua tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tacheẽ nyecua jẽje. Jemo ñee mose sɨta ibate mo je, “esiri rã oso ama ndɨsha ye” ɨ mose sɨta ibate mo je, sã Dios ɨcua tuchɨ rã nyii. “Dios ra secheẽ mumbayã” ɨ tuchɨ mose uchɨangui re, Dios ra echeẽ mumbayã. Sɨta ra siri ee. ");
INSERT INTO srqNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“A emondo seje”, jenye mose Dios je, mondo ra jẽje. “Dios ra emondo seje”, jenye mose jeñɨangui re, mondo ra jẽje. ");
INSERT INTO srqNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Emo mbae ɨcuã naa mose jẽje, ũquɨ̃ ñee chɨ̃ mose jendese, jẽtesareɨ chõ ũquɨ̃ sɨ. Jẽtesareɨ chõ esɨ ñee nonde Dios je. Ũquɨ̃ mose ra jendu ibatenda abe jẽɨcuã mbutiã no. ");
INSERT INTO srqNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Jẽtesareɨã mose emo ɨcuã sɨ, Dios abe ra jẽɨcuã mbutiã eã mbeɨ jẽsɨ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nyebibe que echoɨ Jerusalén nda. Dios chuchuaqui rɨ̃ ngue Jesús riqui ngata ra. Sacerdote rerecua que nyoɨ ñee ee ra. Embesasa rese. Ameɨ ndese. ");
INSERT INTO srqNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—¿Mbaerã ereɨco mbia mbaaquiatu quiatu Dios chuchúaa re? ¿Aba “ũquɨ̃ esaã saã” ɨ quia ndeje re? ɨ que ũquɨ̃ ererecua ñee ja Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús que ñee ee ra. —Se rane tacheẽ jẽje. Se rane preguntar tae jẽje. Secheẽ jẽsɨbɨshorõ na nyii. Aquere quiatu ra jeñee asɨbɨshorõ cote. ");
INSERT INTO srqNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Aba ñee Juan je re? “Eso bautizar ɨ mbia je” ɨ ee re. ¿Dios eã ño ere? Jeñee seje, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ererecua que ndua ndua ja u cote ra. Ñee ñee ngue u nyue ra. —¿Mañɨ nande ra echeẽ ndɨbɨshorõ nde? “Dios que Juan mbu ra”, nande aroneate ee. Nyebe ra ñee nande je. “¿Mbaerã jẽɨngo eãte eruɨ re no?” ɨ quiarei ra nande je. ");
INSERT INTO srqNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Dios que embu eã nda”, nande aroneate ee no. Mbia ataque ra paama ɨ tuchɨ nande je. Juan quiatote quia mbia re, ɨ que ererecua ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ñee nyee que Jesús je cote ra. —Ureɨcuayãte. Aba chõ Juan mbu bautizar ɨ sacuã mbia je, ɨ que ee ra. Nyebe Jesús ñee nguiã ee. —Se abe quiatu tacheẽ eã jẽje no. Ae “ã esaã” ɨ seje nae, erɨɨ̃ nda acheẽ eã jẽje no, ɨ que Jesús ũquɨ̃ ererecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús que ejemplos saã saã mbia je ra. —Sã mbia ibicha mo ndiqui no. Sã eriqui uva i tiquia tiquia no. Sã etarõ no. Uva rique rirurã abe que echao ra. Sucha ibate mo abe que echao no nda. Uco raarõ turã ja sacuã. Ibicha que “sembae uvas jẽsaarõ” ɨ emo je cote ra. Al partido. Ae que oso ɨsho itõte cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uva quiche mose que ngũimba mo mondo rei umbaerã ndea ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Uva raarõsa que erimba mbucuasẽ ɨcuã ño nda. Iruã nua ño ngue ra. Eochɨ chõ ngue emondo mbuchebi ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Echa que ngũimba mo mondobe rei ereabe no nda. Aque abe que embucuasẽ ɨcuã no nda. Sɨta que emombo mombo erese no nda. Eãquĩ nduqui tuchɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ngũimba mo ngue emondobe aquere no nda. Aque quiatu que eɨquia tuchɨ cot e ra. Eɨ̃ eɨ̃ mbeɨ que eraarõsa quia echa rimba je ra. Emo emo ngue eiruã nua nda. Emo emo ngue eɨquia no nda. ");
INSERT INTO srqNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Aque mɨɨ tuchɨ que siquichõ echa rese cote ra. Eriirĩ tuchɨ chõ ngue aque re. Nyesecua tuchɨ que equia aque rese ra. Aque que emondo chee uva rea cote ra. “Ɨreɨ̃ ɨreɨ̃ jiri ra seriirĩ sɨ”, ɨ rei que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Eriirĩ ngasẽ mose que uva raarõsa ñee nyue ra. —¡Co eriirĩ ndu quia co cote jẽ! ¡Nandeɨquia rei jẽ! Ɨ̃ nda uvas nandembaerã ae tuchɨ cote, ɨ que ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eraarõsa que eriirĩ isi ɨcuã cote ra. Curuchoɨ que ɨquia pe jiri ra. Mano ngue cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Mañɨ nda echa quia eraarõsa je cote re? Echa ra eraarõsa ɨcuã ɨquia ja cote. Uva i ra emondo ja emo je eraarõ sacuã cote. ");
INSERT INTO srqNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Ã mbesa ji rese jemae ãte re? Sã emo ndiqui tuchua ao sɨta je no. Sɨta mo ngue equirirõ mombo ra. Eɨcuãte eriqui reɨ̃ nguiã ee. Aquere ndua sɨ erese. “Earonda sacuã turambi chõ eriqui re”, ɨ ndua sɨ uchɨmombo rese. Uchɨmombo que esirõ sɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dios chɨao chõ ũquɨ̃ nde. Dios chɨao turã tuchɨ riqui nande je ã, ɨ ñɨ embesa ji re, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","—Nanderɨɨ̃ ño eriqui nguiã ñee, ɨ que ũquɨ̃ ererecua ra. —Nandeisi rei serao jẽ, ɨ rei que nyue ra. Jesús isi aronea tuchɨ que mbia résaa ra. Eɨreɨ̃te quiatu ngue mbia tubɨrɨã sɨ re. ");
INSERT INTO srqNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ũquɨ̃ ererecua que fariseos mo mondochoɨ ñee Jesús je ra. Herodes chɨmbaaquiatu abe mondochoɨ erea. —Jesús nandembucheẽ ɨcuã na. Ɨ̃ nda mbia paama ɨ ee, ɨ rei que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Uturã ngue esaã ñooño Jesús je ra. —Jesús, co ereɨco mbia mbaaquiatu turãte co. Mbia jaje ndeturãte riqui co. Co ereɨco turãte mbia mbuchiabiã co. Mbia erembaaquiatu quiatu turãte quia Dios ɨcha rɨɨ̃ co. Nyebe urechu nguiã ñee ndeje a. ¿Coche mbia mbae isiquia mee mee Romanos nderecua je re? Impuestos. ");
INSERT INTO srqNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","¿Uremee mee nda ee re? ¿Uremee eã nda ee re no? ɨ que ñee Jesús je ra. Jesús que ũquɨ̃ ɨcuã ɨcuate ra. Nyebe ñee nguiã ee. —¿Mbaerã jẽɨngo “ɨ̃ nda Jesús ucheẽ nyabi”, ɨ serɨɨ̃ nde? Mbae isiquia jẽteacuquia ɨmbu seje. Tamae erese, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mbia que eteacuquia ee ra. —¿Aba mbae nombre ñɨ mbae isiquia rese a re? ¿Aba ãquĩ aingue abe ñɨ a re? ɨ que Jesús ee ra. Romanos nderecua, ɨ que mbia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesús que ñee ee cote ra. —Romano s nderecua mbaerã jemondo chõ ee. Dios mbaerã jemondo chõ ee no, ɨ que Jesús ee ra. Mbia que nyuruɨra jate u Jesús cheẽ andu ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","—Mbia raaque ra quera eã mbeɨ, ɨ que mbiamo nguia ñee nda. Saduceos ɨ que ũquɨ̃ mbia je ra. Ũquɨ̃ mo ngue nyoɨ ñee Jesús je ra. Tã ɨ sacuã ee. ");
INSERT INTO srqNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Sererecua, ã ngue Moisés mbesa nande je ra: “Emo ndiiriã mano mose, sã enongue mano je ninisi rerequia erendaque re. Sã tiirĩ ngõngue raaque rɨɨ̃”, ɨ que Moisés embesa nande je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Eriquii mo ngue siqui urerese ra. Seis que eribi ra. Eriquii que ngũinisirã quereco rei ra. Mano ño ngue tiirĩ ndocoɨ̃ ngũinisi recha ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Enongue que nguiquii checha quereco rei cote ra. Ae abe que mano ño tiirĩ ndocoɨ̃ no nda. Enongue que equereco no nda. ");
INSERT INTO srqNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ũquɨ̃ seis que ngõngue cheecha quereco ja rei ra. Mano ja chõ ngue erecha tiirĩ ndocoɨ̃ no nda. Eninisi eru cheecha que mano nyee chõ cote no nda. ");
INSERT INTO srqNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Siete rei que eru nyii ra. Mbia raaque quera sɨ ja mose, ¿abate ra equereco cote re? ɨ que saduceos ñee Jesús je ra. —Ma Jesús ñee ɨcuã, ɨ chõ ngue re. ");
INSERT INTO srqNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús que ñee ee ra. —Jẽɨngo Dios cheẽ ɨcuayãte ã. Jẽɨngo Dios cheẽ abi tuchɨ ã. Jẽɨngo Dios quirãcuã ɨcuayãte ã. ");
INSERT INTO srqNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ae raaque ra Dios mbuquera sɨ nae, ũquɨ̃ nda ngũinisi quereco eã mbeɨ huee cote. Ũquɨ̃ nda ngu quereco eã mbeɨ huee cote no. Angeles rã mbeɨ ra mbia riqui huee ibate cote. ");
INSERT INTO srqNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Moisés chɨmbesa rese jemae ãte re? Mbia raaque quera sɨ rɨɨ̃ ño ngue embesa nguiã. Ira ruri sendi quia, aque mose que Dios Moisés mbiirandu ũquɨ̃ ndese ra. “Abraham nderecua chõ aɨco nguiã se co. Isaac nderecua abe. Jacob nderecua abe no”, ɨ que Dios Moisés je aque mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ã ngue mano ndei nyii ra. Ereco siqui beɨ chõ nguiã namo ã. Mbia raaque rerecua eã ño Dios re. Mbia reco rerecua chõ ae re. ¿Ũquɨ̃ jẽɨcua eãte quia ã nde? ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Embesasa mo ngue chɨ̃ echeẽ andu ra. —Jesús ñee turã tuchɨchɨ̃ saduceos je, ɨ que uchɨangui re ra. Nyebe esɨ nguiã ñee ee. —Jesús, Dios cheẽ tubɨrɨãte riqui ã ndesẽ. Mbia echeẽ mumbayã sacuã. ¿Ma Dios cheẽ ndiita tuchɨ ma nde? ɨ que embesasa ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús que ñee ee ra. —Ã ño Dios cheẽ ndiita ã nde: “Secheẽ jeñandu rã, Israelitas. Dios mɨɨ tuchɨ chõ nandererecua re. ");
INSERT INTO srqNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Echesecua tuchɨ quia Dios rese. Ndechɨã je. Neaĩ je. Nendua ndua abe je. Ndequirãcuã abe je”, ɨ chõ Dios cheẽ ndiita nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ã abe rei ũquɨ̃ nduɨnda ã no: “Sã ereɨco nyesecua ndechɨese no. Eɨ̃ ere sɨ chõ nyesecua mbia rese”, ɨ. Ũquɨ̃ nyeremo ndei Dios cheẽ i tuchɨ ũquɨ̃, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Embesasa que ñee Jesús je cote ra. —Ae beɨ, Sererecua. Dios mɨɨ tuchɨ chõ nandererecua re. Emo abe mo eãte. ");
INSERT INTO srqNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nandechesecua tuchɨ mose Dios rese, ũquɨ̃ eturãte ee. Nandechesecua tuchɨ mose nandechɨã je. Nandendua ndua je. Nandeaĩ je. Nandequirãcuã je abe no. Nandechesecua tuchɨ mose mbia rese, ũquɨ̃ eturãte Dios je mbae mo sɨ. Sacrificio mo sɨ. Ofrenda mo sɨ, ɨ que embesasa ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","—Ñee aquiatute equia seje co, ɨ que Jesús uchɨangui re ra. —Dio s rimbarã tuchɨ chee ra nde, ɨ que ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús que mbia mbaaquiatu quiatu quia Dios chuchúaa ra. —¿Mbaerã embesasa riqui ñee nde? “David rucucha chõ Cristo re” ɨ re. ");
INSERT INTO srqNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David abe que “sererecua” ɨ Jesús je ra. Sã embesa ji ñee no: Dios que ñee Cristo sererecua je ra: “Ecoi sejii. Nde abe ra ererecua serese. Ae ndeucuayãte quia nae, ũquɨ̃ je ra ndequirãcuã ateacuquia tuchɨ. Ndequirãcuã tuchɨ chee ra ũquɨ̃ sɨ”, ɨ que Dios ñee sererecua je ra, ɨ que Espíritu Turã David mbucheẽ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David sɨ́ chõ “sererecua” ɨ nguiã Cristo je. Cristo David rucucha mose, ¿mbaerã David “sererecua” ɨ ee re? ɨ que Jesús embesasa je ra. Mbia tubɨrɨã ngue Jesús cheẽ chandu turã jate ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús que uchɨmbaaquiatu mbaaquiatu quiatu ra. —Embesasa rã nda jẽɨngochɨ̃ jẽ. Ũquɨ̃ ucuasu saã saã mbeɨte quia ã. Huɨɨrao turã equereco beɨte quia ã. “Sã mbia ererecua ɨ nande je”, ɨ beɨte equia ã. ");
INSERT INTO srqNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mbia renda turã abe eirabo rabo beɨte quia mbia sɨ ã. “Fiestacha jii quia taɨ̃ jẽ”, ɨ abe beɨte equia ã no. ");
INSERT INTO srqNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ari eru cheecha mbae abe embutiã tiãte quia ã no. Ucheẽ oco abe esaã saã mbeɨte quia Dios je ã no. “Ɨ̃ nda mbia mae nanderese”, ɨ chõ nguiã. Ũquɨ̃ nda Dios mbasi tuchɨ cote, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Emo mose que Jesús ñɨ Dios chuchúaa ra. Ofrenda riru nonde que eñɨ ngoi ra. Mae ngue mɨɨ mbia mbae isiquia mondo mondo mose eriru ye rese ra. Mbaecha atate que mbae isiquia tubɨrɨã mondo mondo quia eriru ye ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Eru cheecha mo ngue ngasẽ u cote ra. Nyeremoño tuchɨ que ae mbae isiquia mondo ra. Centavo mɨɨ mbuchecha tuchɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús que ñee uchɨmbaaquiatu je ra. —Jenyu. Tacheẽ nyecua jẽje. Eru cheecha mbaecha reã ngue mbae isiquia mondo tuchɨ mbia ataque sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mbaecha quiatu que umbae rire ñetẽ mondo mondo ra. Eru cheecha quiatu que umbae mɨɨ mondo ja ra, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús que oso usẽ Dios chuchua sɨ cote ra. Echɨmbaaquiatu mo ngue ñee ee ra. —Sã Dios chuchua turã tuchɨte jẽ. Eao ji turã tuchɨ sɨta je, ɨ que echɨmbaaquiatu mo ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús que ñee ee ra. —Ã ndese jẽɨngo mae ã nae, ũquɨ̃ nda mbia mbucoɨ ja cote. Sɨta mo nda chɨ eã nyuchuarõ Dios chuchua cote. Mbia ra Dios chuchua mbucoɨ ja tuchɨ cote, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesús que chɨ̃ ngoi huee ibi ibate mo nda. Monte de los Olivos, ɨ que hue je ra. Dios chuchua checuate que ee hue sɨ ra. Echɨmbaaquiatu que ngasẽ ñee ee ra. Pedro. Jacobo. Juan. Andrés. Ũquɨ̃ ja que ñee eísaa ra. ");
INSERT INTO srqNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Manosete ra ũquɨ̃ nde? ¿Mañɨ ure ra equia jirandu mbae ua nonde re? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús que ñee ee ra. —Jẽtesa jiri quia jẽ. Mbia mo nda jembɨɨrɨ̃ ɨrɨ̃chɨ̃ ñee jẽje jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","“Cristo chõ se re” ɨ ra mbia ñee ata atate jẽje. Ũquɨ̃ nda jeñanduchɨ̃ jẽ. Ũquɨ̃ nda mbia mbɨɨrɨ̃ ɨrɨ̃ jate. Ñee ñooño je chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mbia ra guerras saã saã tuchɨ. Mbia ra ñee ñee tuchɨ quia nyɨɨquia ɨquia je rɨɨ̃. Ũquɨ̃ mose ra jẽsiquichechɨ̃ jẽ. Ũquɨ̃ ja rane nda nyecua raque. Aque mose r a mbae ja ua eã ná. ");
INSERT INTO srqNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mbia ra guerras saã tuchɨ chee. Nyɨɨquia ɨquia tuchɨ rae. Mbia riãcuã tuchɨ ra aque mose no. Emo ñooñoa tuchɨ ra mbia rasi. Mangue chooñoa tuchɨ ra ibi nyere nyere. Jembasi ramo mose chõ nda ũquɨ̃ nde. Aquere ra jembasi tuchɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","¡Sã jẽ! Mbia ɨcuã ɨcuãte ra jẽje. Jembɨɨrɨ̃ ɨrɨ̃ ndae. Jemee mee ɨcuã nda mbia rerecua je. Jẽiruã nua nda mbia chumunuásaa. Nguerecua je ra mbia jenderao rao tuchɨ. Ererecua abe je chee ra secheẽ jẽsenei senei. ");
INSERT INTO srqNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Sequiato ra Dios cheẽ turã senei senei ná mbia ja je nyii. Mangue chooñoa jenda ja je. Aquere ra mbae ua ja cote. ");
INSERT INTO srqNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jemee mose mbia rerecua je, pare pare jenyechɨ̃ nda jẽ. “¿Manyae ra ũquɨ̃ ñee ndɨbɨshorõ nde?” jenyechɨ̃ nda pare pare ɨ jẽ. Espíritu Turã ae chõ nda jembucheẽ turã nguiã mbia je aque mose. Jẽ ae ra jeñee eã. Espíritu Turã ae chõ nda jembucheẽ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jenongue ra jemondo chee mbia ɨcuã je. Jẽɨquia sacuã. Jendu abe ra jemondo chee mbia ɨcuã je. Jendiirĩ abe ra jemondo chee mbia ɨcuã je. Mbia ɨcuã nda jemo ɨquia ɨquia chee. ");
INSERT INTO srqNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mbia mangue chooñoa jenda ra jẽucuayã tuchɨ serɨɨ̃. Ae ra siqui beɨ serese, ũquɨ̃ nda Dios mingo beɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Daniel que embesa Mbae Mbutiãsa Ɨcuã nɨɨ nda. Mbae Mbutiãsa Ɨcuã nda siqui nguecuáyaã. “Dios rendaque re taɨco se quiatu”, ɨ ra equia huee. (Ae ra mae nguia sechɨmbesa rese nae, sã ũquɨ̃ eɨcua.) Jemae mose Mbae Mbutiãsa Ɨcuã ndese, jeña esɨ. Ae siqui quia Judéaa, sã ũquɨ̃ uchã jeɨ choɨ ibi ibátee mo. ");
INSERT INTO srqNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ae ra siqui tuchua quite rese, sã ũquɨ̃ ɨqueã nyoɨ uchuchua uquichi mose. Sã echoɨ chõ uchã hue sɨ beɨ, umbae rirõ ndocoɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ae ra siqui úcoo, sã ũquɨ̃ nyebiã ngaẽ huɨɨrao rea. Sã hue sɨ beɨ chõ echoɨ uchã. ");
INSERT INTO srqNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aba mbia eã tuchɨ ra emo ãquẽ ndiru rerequia mose aque mose. Nguiirĩ mbuquiambu je abe no. ");
INSERT INTO srqNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Nyiiseĩ mose eã urechã” jenye Dios je. ");
INSERT INTO srqNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mbia ra mbae rasi saã tuchɨ aque mose. Mbae rasi que mbia saã eã jiri nyii ra. Aque ramo mose ra mbae rasi raã tuchɨ cote. Mbae ua beɨ sacuã ño ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ae rasi ra mbia saã tuchɨ nae, ũquɨ̃ nda Dios mbujua jiri uquiato rɨɨ̃. Ɨ̃ nda emo ñɨmbirãcuã eã tuchɨ rei ũquɨ̃ ndasi je. ");
INSERT INTO srqNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“A Cristo riqui a jẽ” ɨ mose emo jẽje, “nyia” jenyechɨ̃ nda ũquɨ̃ ñee mose jẽ. “Hue Cristo riqui hue jẽ” ɨ mose emo jẽje, “nyia” jenyechɨ̃ nda eno jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","“Cristo chõ se re” ɨchõɨño nda mbia ñee ata atate jẽje. “Dios cheẽ mbuchecuasa chõ se re” ɨchõɨño nda mbia ñee ata atate jẽje no. Mbia mae sayã nda esaã saã tuchɨ mbia mbɨɨrɨ̃ ɨrɨ̃ sacuã. Ũquɨ̃ Dios quiato abe chee mbɨɨrɨ̃ ɨrɨ̃ arõte. ");
INSERT INTO srqNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ũquɨ̃ nonde chõ aɨco nguiã jembiirandu randu co. ");
INSERT INTO srqNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Mbia ũquɨ̃ ndasi raã ja mose ra tenda checuayã mbeɨ cote. Nyasi abe no. ");
INSERT INTO srqNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nyasitata ra ngoɨ ngoɨ. Ibei jenda abe ra quiata quiata chee cote no. ");
INSERT INTO srqNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aque mose ra achu ibei rese. Senininya tuchɨ ra sechu mose. Sequirãcuã tuchɨ ra sechu mose no. ");
INSERT INTO srqNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Angeles serimba ra amondo mbia sechiisirõ munua nua sacuã. Ɨshonda ja. Mangue chooñoa jenda ja. Mbia sechiisirõ nda emunua nua ja seje cote. ");
INSERT INTO srqNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sã higuera riqui no. Sã ira mo ndiqui no. Ero quira usẽ ja mose, “iraro itõ ndacu ra cote”, ɨ chõ mbia nguiã aque mose. ");
INSERT INTO srqNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Eɨ̃ sɨ́ ra mbae ua ja nonde. Ae rɨɨ̃ aɨco ñee jẽje nae, ũquɨ̃ ndese jemae mose, “mbae ra ua ja cote” jenye ra cote. ");
INSERT INTO srqNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tacheẽ nyecua jẽje. Ã mbia riqui ngata ibi ã nae, ũquɨ̃ emo emo nda manoa mbae ua ja nonde. ");
INSERT INTO srqNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ibei ra ua. Ibi abe ra ua no. Secheẽ nguia ra ua eã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Manosete chõ nda mbae ua ja. Aɨco eɨcuayãte co. Mbia mo abe eɨcuayãte quia ã no. Angeles abe eɨcuayãte quia ã no. Paba mɨɨ ño eɨcua nguiã co. ");
INSERT INTO srqNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nyebe jẽɨngo quiatu quia eraarõ arõ mbeɨ. Jẽtesa tesa beɨ quia. Ma nyaashɨ̃ ño nda equeru. Jẽɨcuayãte equia ã. ");
INSERT INTO srqNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sã ererecua mo oso ɨsho itõte no. Sã ñee ngũimba je oso nonde no. —Sembae jẽsaarõ ja. Ã ndese jẽɨngo. Co rese eɨco nde. Quɨ rese eɨco nde no, ɨ que ñee ngũimba mɨɨ mɨɨ je ra. —Etesa tesa beɨ quia, ɨ que eɨquesa raarõsa je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Manosete chõ nda tuchuacha ru. Jẽɨcuayãte equia ã. Itondaru ramo mose eru arondete. Itondii mose eru arondete. Nguira cheẽ mose eru arondete no. Eresaitõ ndabe mose eru arondete no. Nyebe jẽtesa tesa beɨ quiatu quia. ");
INSERT INTO srqNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Jengue mose ra eruchɨ̃ jembuate jẽ. ");
INSERT INTO srqNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Jẽtesa tesa beɨ quia” ae chõ nguiã mbia ja je co. Jẽ mɨɨ je eã, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sacerdote rerecua que ñee ja nyue ra. Embesasa abe no. —¿Mañɨ nande ra equia Jesús isi nonde re? Eɨquia sacuã. ¿Mañɨ nande ra embɨɨrɨ̃ ɨrɨ̃ nde? ɨ que equia ñee ñee nyue ra. Achɨte que fiesta de la pascua ñɨ tu ee cote ra. Dos días. ");
INSERT INTO srqNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Fiesta mose eã nandeisi jẽ. Mbia ra paama ɨchɨ̃ nande je jẽ, ɨ que u ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús que siqui Simón Leproso chuchúaa ra. Betania, ɨ que hue je ra. Cuña mo ngue tu erea huee ra. Aba mbusɨmbusa mo ngue equeru ee ra. Sɨta ao ji ye que ereru ra. Embisẽ tuchɨ que equeru ra. Mbae isiquia mumbasa tuchɨ que ũquɨ̃ nda. Eriru churui que esiquio eichusẽ nonde Jesús ãquĩ ndese equiaru mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mbia que chɨ ja mae erese ra. Paama ɨ que cuña je ra. —¿Mbaerã eichusẽ ñooño nde? ");
INSERT INTO srqNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mbae isiquia rɨbɨshorõ ño nda aba emondo re. Mbaecha reã je emee mee sacuã, ɨ que ñee ɨcuã ɨcuã cuña je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús que ñee cote ra. —¿Mbaerã jẽɨngo ñee ũquɨ̃ nde? Sã cuña ae riqui ae. Ae esaã seje nae, eturãte seje ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mbaecha reã nguia ra chɨ arete íbii a. Jẽ mbae raãse mose ee, mbae jẽsaã turã mbeɨ ee ae. Se quia nda aɨco beɨ eã nguiã jendese aa. ");
INSERT INTO srqNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Seati nonde chõ ngue cuña aba mbusɨmbusa ichusẽ ja nguiã serese. ");
INSERT INTO srqNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tacheẽ nyecua jẽje. Mbia Dios cheẽ turã nenei nenei mose mbia ja je, cuña nyɨsaã abe ra esenei senei mangue chooñoa jenda ja je. Mbia ndua turã ja sacuã echɨsaã abe rese, ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, ɨ rei que Jesús chɨmbaaquiatu mo je ra. Aque que oso ñee sacerdote rerecua je ra. Jesús mee nonde ee. ");
INSERT INTO srqNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sacerdote rerecua ia ja que ũquɨ̃ andu ra. —Mbae isiquia uremee tuchɨ ndeje jẽ, ɨ que ee ra. Nyebe Judas riqui nguiã ndua ndua. —Mbia eãsa quiatu Jesús tamee ee, ɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Fiesta que tu cote ra. Aque fiesta mose beɨ que mbia riqui oveja ɨquia ɨquia querabe ra. Mbichae mbuchɨmatã iríã ngue eu eu quia aque mose querabe no nda. —¿Mangue ra oveja urembuchi mangue ndechɨurã nde? ɨ que echɨmbaaquiatu ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ñee ngue uchɨmbaaquiatu nyeremo je ra. —Jẽso sucha cuasu. Huee ra jemae emo i rerao rese. I ra equerao quia irasa mo ye. Aque ruɨ jẽso. ");
INSERT INTO srqNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Eɨque mose, aque tuchuacha je jeñee. “Jesús que urembu ñee sacuã ndeje ra. ‘¿Ma cuarto ra urecu quiaru oveja u que re? Sechɨmbaaquiatu rese’, ɨ que Jesús ñee ndeje ra”, jenye tuchuacha je. ");
INSERT INTO srqNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tuchuacha ra cuarto cuasu mee jẽje. Mbia quesa ibatenda ra emee jẽje. Embuquiche ji. Huee chõ oveja jembuchi nandequiaru sacuã, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nyebe echɨmbaaquiatu nyoɨ nguiã sucha cuasu. Jesús cheẽ nduɨ sɨ tuchɨ que mbae chɨ ja ee huee ra. Huee que oveja mbuchi huee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Itondaru ramo mose que Jesús ru uchɨmbaa quiatu ataque rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Quiaru mose que Jesús ñee ee cote ra. —Tacheẽ nyecua jẽje. A jẽɨngo quiaru serese a nae, jemo nda semondo mbia ɨcuã je, ɨ que ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Echɨmbaaquiatu ia eã tuchɨ que echeẽ mose ra. —¿Se ra aremondo ee re? ɨ ja jate que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús que ñee ee ra. —Doce jẽɨngo quiaru serese a nae, jemo ño ñene. Ae chɨ̃ quiaru serese aque plato ye sɨ́ a nae, aque chõ ñene. ");
INSERT INTO srqNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dios cheẽ nduɨ sɨ́ tuchɨ ra amano ndaque. Ae ra semee mbia ɨcuã je, aque ra mbae rasi saã tuchɨ quia. Aba mbia eã tuchɨ ra aque. “Taĩ sembuchecua jirichɨ̃ nguia curɨ”, ɨ chee ra aque, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Quiaru que u ra. Jesús que mbichae sirõ nda. Gracias ɨ que Dios je ra. Siquio que mbuchao chao ee cote ra. —Ã mbichae jẽu. Serete chõ ã nde, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Vino mbeisa que esirõ cote no nda. Gracias ɨ que Dios je ra. Mondo que uchɨmbaaquiatu oo cote ra. Mbei mbei ja que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús que ñee ee ra. —Seruqui chõ ã nde. Mbia ɨcuã mbutiã sacuã ño seruqui re. Dios cheẽ yasu ruɨ sɨ chõ seruqui riqui nguiã mbia ɨcuã mbutiã ã. ");
INSERT INTO srqNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tacheẽ nyecua jẽje. Vino mo nda ambei eã mbeɨ cote. Paba mbia rerecua tuchɨ mose, aque mose ramo nguia nda ambei nguiã cote, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ɨraseɨ raseɨ que cote ra. Nyoɨ que ibi ibate mo cote ra. Monte de los Olivos, ɨ que hue ibi je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús que ñee uchɨmbaaquiatu je huee ra. —Jẽɨreɨ̃te ra eriqui serɨɨ̃. Jeñɨmboseɨ̃ mboseɨ̃ nda oso serecha. Sã embesa ji riqui ñee no: “Mbia ra oveja raarõsa ɨquia. Ovejas ra ñɨmboseɨ̃ nyoɨ cote”, sã embesa ji riqui ɨ no. ");
INSERT INTO srqNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Seraaque quera sɨre ra aso se rane jendaarõ Galilea, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro que ñee ee ra. —Seataque ra ɨreɨ̃ ɨreɨ̃te raque ndesɨ. Se quia ra aɨreɨ̃ ɨreɨã mbeɨ ndesɨ, ɨ rei que Pedro ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús que ñee ee ra. —Tacheẽ nyecua ndeje. Nguira cheẽ nyeremo nonde ra erecheẽ ñooño tres veces serɨɨ̃ namo, Pedro. “Jesús aɨcuayãte resẽ”, ere chooño ño nda serɨɨ̃, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro que ñee ee ra. —Mbia ra seɨquia arõte raque nderɨɨ̃, acheẽ ñooño eã nda se nderɨɨ̃, ɨ rei que Pedro ra. Eɨ̃ ja que ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesús que oso Getsemaní cote ra. Uchɨ mbaaquiatu rese. —Jengoi rã u aa. Tacheẽ na oso Paba je pe jiri se, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pe quiti jiri que Pedro rerao ra. Jacobo rese. Juan abe no. Eya eã ndasi tuchɨ que tu ee aque mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ñee ngue ũquɨ̃ je ra. —Seya eã ndasi tuchɨ aɨco co. Seya eã ndasi ra seɨquia chee. Jenguchõ na jẽ aa. Jẽtesa tesa beɨ u aa, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesús que oso pe quiti jiri cote ra. Nyibi que u ngoi ngũíã ndese ñee Dios je ra. —Mbae rasi asaã sereãte, ɨ rei que ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Paba, mbae eresaã ja arõte nde. Ũquɨ̃ ndasi asaã sereãte raque quia co. Ae sebi riqui nae, ũquɨ̃ ndese semingo eã. Ae ndebite riqui nae, ũquɨ̃ ndese quiatu semingo, ɨ que Jesús ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nyebi que u uchɨmbaaquiatu je cote ra. Ɨ que eu uque ja ee cote ra. Ñee ngue Pedro je ra. —Simón, ¿ereque huɨ̃ a re? Ereɨco areã ñochɨ̃ tesa tesa s e ñee mose Dios je. ");
INSERT INTO srqNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jẽtesa tesa u. Jengue eã u ñee Dios je. Mbae ɨcuã tã ɨ eã sacuã jẽje. Jẽɨngo serete raque serese. Mbae ɨcuã nguiatu jembuti mbutite nguiã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nyebi sɨ que oso ñee Dios je ra. Hue rɨ̃ sɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nyebi que u uchɨmbaaquiatu je cote ra. Ɨ sɨ́ que u uque ee no nda. Eresa quiatu ngue eshɨu shɨute nguiã. —¿Mañɨ nda aba ñee nde? ɨ ja tuchɨ que echɨmbaaquiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Osobe que ñee Dios je pe jiri cote ra. Tres veces que aque cote ra. Uba rei que u ñee uchɨmbaaquiatu je ra. —Jengue tuchɨ cote. Jenguenea jẽucua cote. Semondo ra mbia ɨcuã je cote. Seɨquia sacuã. ");
INSERT INTO srqNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jẽhuã cote. Nyao cote. Ae ra semee mbia ɨcuã je, co eru quia semee sacuã co cote, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús cheẽ mosebe tuchɨ que Judas ru erea ra. Jesús chɨmbaaquiatu rei que ae ra. Aque rese que mbia cuaẽ tuchɨ quia ra. Tiquise abe que ecurucuaẽ nguia ra. Ira jua abe no. Sacerdote rerecua chõ ũquɨ̃ mbucuaẽ nguia reaẽ. Embesasa abe. Ameɨ abe. ");
INSERT INTO srqNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas ñee nyecuayã nguiatu quia ũquɨ̃ je nyii reaẽ. —Ae ritii ra asiite nae, aque chõ ñene. Aque jẽisi quiatu tuchɨ serao, ɨ quia equia ee nyii reaẽ. ");
INSERT INTO srqNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jesús rɨɨchã ngue esɨ saludar ɨ ee cote ra. Jesús ritii que esiite ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mbia que Jesús isi cuaẽ ecua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ũquɨ̃ mose que Jesús rimba mo uchuuru sirõ tiquise ra. Sacerdote rerecua rimba rese que tiquise uru ra. Eisa que echisia ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús que ñee mbia ja je cote ra. —¿Mbaerã jenyu quia tiquise rurucuaẽ serea co re? Ira jua abe no. Mbae mbuquiachãsa rea rocoɨ̃ jenyuchɨ̃ nguia serea co. ");
INSERT INTO srqNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tenda que amumba mumba beɨte rei quia jendese Dios chuchua resẽ. Mbia que ambaaquiatu quiatu beɨ rei quia huee resẽ. ¿Mbaerã seisiã nyucua aque mose re? Embesa ji ɨque sacuã ño jẽɨcuã ɨcuã ndiqui nguiã seje ã, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Echɨmbaaquiatu que nyoɨ ja chee uchã Jesús recha ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Acuanɨndu mɨɨ mo ngue oso eruɨ ra. Tiru mɨɨ ngue equereco nyɨati ra. Mbia que acuanɨndu abe isi rei ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Huɨɨrao que esecha oso uchã nda. Eɨrao eã tuchɨ que oso uchã nda. ");
INSERT INTO srqNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mbia que Jesús curuchoɨ sacerdote rerecua je cote ra. Huee que sacerdote rerecua ja chɨ ñumunua nda. Embesasa abe. Ameɨ ererecua ja abe no. ");
INSERT INTO srqNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro que embuchurucha rucha oso quia eruɨ ra. Ngasẽ nyee que sacerdote rerecua itaicuee ra. Hue que ngoi sacerdote rimba mo ndese ra. Nyee que huɨ̃ huee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sacerdote rerecua que chɨ ja huee ra. Ameɨ mbia rerecua ja abe no. Mbia rerecua ja tuchɨ. —Jesús nandeɨquia, ɨ rei que ñee ñee nyue ra. —¿Mbae ɨ ra aba mbia je Jesús rɨɨcharã nde? ɨ rei que u ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Emo emo ngue ñee ɨcuã ɨcuã ndei Jesús rɨɨ̃ nda. Ucheẽ ngue etasa tasa tuchɨ chõ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mbia mo abe que juã ñee ñooño erɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Jesús cheẽ ngue urechandu ra. Ñee ɨcuãte que Dios chuchua rɨɨ̃ nda. “Dios chuchua tambocoɨ mbia chɨao. Tres días mose ra Dios chuchuarã asaã no. Mbia chɨao eã nda ũquɨ̃ cote”, ɨ que urechandu Jesús cheẽ nda, ɨ que ũquɨ̃ ñee ñooño Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ucheẽ ngue etasa tasa beɨ chõ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Sacerdote rerecua que juã ñee Jesús je ra. —¿Echeẽ nda eresɨbɨshorõ eã mbeɨ re? ¿Mbae ɨ equia nderɨɨ̃ nde? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús que ñee eã mbeɨ echeẽ mose ra. Sacerdote rerecua que ñeembe ee ra. —¿Dios rucucha nde re? ¿Cristo nde re? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús que ñee ee ra. —Ae. Dios rucucha chõ se re. Jemae nda serese s e coi mose Dios quirãcuã jii. Sechu mose abe ibeishĩ ndese, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Sacerdote rerecua que paama ɨ tuchɨ Jesús cheẽ mose ra. Huɨɨrao que endoro ndoro chee ra. Ñee ngue ererecua ataque je ra. —Jesús riqui Dios rucucha raã naa co. Jeñandu jate equia ã. Sã mbia mo nandembiirandube eã cote. Nandemae ndei ngue erese re. ¿Ɨ jẽje re? ¿Mañɨ nande ra equia re? ɨ que sacerdote rerecua ñee mbia rerecua ataque je ra. —Eɨcuã tuchɨ que ra jẽ. Sã mbia eɨquia, ɨ jate que ererecua ñee Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mbia que ñinimbu nimbu Jesús ruba rese cote ra. Eresa que echati mbae mo je ra. Ucua ucua tuchɨ que erese cote ra. —¿Aba ucua ucua u nderese a re? Eɨcua no, ɨ que equia eresa ati ji je ra. Soldados abe que ucua ucua tuchɨ eresa rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro que chɨ̃mbeɨte ngoi itaicuee ra. Nyucuaaque mo ngue tu huee sacerdote rerecua rimba ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro que chɨ̃ nyee tata jii ee huee ra. —Jesús resenda que nde abe ra, ɨ que nyucuaaque ñee mae mose Pedro rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","—Tei. Ndecheẽ aɨcuayãte, ɨchõɨño ngue Pedro ñee ee ra. Hue sɨ que esɨ eɨquesa quiti cote ra. Usẽ mose que nguira ñee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nyucuaaque que maembe erese ra. —Co abe que Jesús resenda ra, ɨ que mbia ataque je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","—Tei. Aɨcuayãte se, ɨchõɨño ngue Pedro ee no nda. Ae chɨ huee nae, ũquɨ̃ mo ngue ñee ee cote ra. —Jesús resenda chõ nde abe resẽ. Galilea jenda chõ nde resẽ, ɨ que ñee Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro que jurar ɨ tuchɨ ñee ee ra. —Aɨcuayã tuchɨte se resẽ, ɨ que ñee ñooño sɨ no nda. ");
INSERT INTO srqNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aque mose tuchɨ que nguira ñee sɨ́ cote ra. Pedro que ndua Jesús cheẽ ndese cote ra. Sã Jesús ñee ee nyii no. —Nguira cheẽ nyeremo nonde ra erecheẽ ñooño tres veces serɨɨ̃, sã Jesús ɨ ee nyii no. Ũquɨ̃ ndese que Pedro ndua cote ra. Nyebe nyeseo tuchɨ nguiã cote. ");
INSERT INTO srqNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nyaashɨ̃ namo mose que sacerdote rerecua ñumunua ja ra. Ameɨ ererecua abe no. Embesasa abe no. Mbia rerecua jate que ñumunua nda. Jesús que echucua suruchoɨ Pilato je ra. Pilato rei mbia rerecua hue jenda ja. ");
INSERT INTO srqNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","—¿Judíos rerecua chõ nde re? ɨ que Pilato ñee ee ra. —Ae. Judios rerecua chõ se re, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sacerdote rerecua que ñee ñooño tuchɨ Jesús rɨɨ̃ nda. Ñee ɨcuã tuchɨ que erɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","—Sã ñee ɨcuã ɨcuãte nderɨɨ̃ jẽ. ¿Echeẽ nda eresɨbɨshorõ eã nde? ɨ que Pilato ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús que ñee ãte echeẽ mose ra. Nyebe Pilato nyuruɨra tuchɨ nguiã echeẽ eã mose. ");
INSERT INTO srqNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilato que mbia tarõ ji mo mbusẽ mbeɨ quia pascua mose ra. Co mɨɨ ngue embusẽ mbusẽ mbeɨ quia pascua mose ra. Ae je mbia riqui ñee, “aque embusẽ mondo” ɨ nae, aque chõ ngue embusẽ mbeɨ quia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Barrabás, ɨ que etarõ ji mo je ra. Emo abe que chɨ huee erese ra. Mbia ɨquiasa que ũquɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mbia que ñee ngaẽ Pilato je ra. —Mbia mɨɨ tarõ ji que erembusẽ mbeɨte quia, eɨnyere sɨ emo mbusẽ namo, ɨ ja que mbia ñee Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","—¿Judío rerecua ra ambusẽ mondo jẽje Jesús re? ɨ rei que Pilato ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","—Sacerdote rerecua riqui paama ɨ chooñote Jesús je ã, ɨ quiatu que Pilato ndua ndua uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","—Sã Pilato Barrabás mbusẽ mondo Jesús rendaque re, ɨ tuchɨ que sacerdotes ñee ja mbia je ra. Nyebe que mbia “Barrabás embusẽ mondo” ɨ chee Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","—¿Mañɨ ae quia ra Jesucristo je re no? ɨ que Pilato ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—Embucha ira rese, ɨ ja que mbia ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Mbae ɨcuã esaã nde? ɨ que Pilato ñee ee ra. —¡Embucha ira rese jẽ! ɨ beɨ beɨ que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","—Mbia turã jiri nda seje chã, ɨ chee que Pilato ra. Nyebe Barrabás mbusẽ mondo nguiã. Jesús quiatu que eiruã nua cote ra. —Jembucha ɨquia ira rese, ɨ que mbia je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldados que Jesús cuasa curuchoɨ ererecua chuchúaa ra. Huee que soldados ataque abe ngaẽ ja Jesús mama no nda. ");
INSERT INTO srqNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tiru ɨreɨ̃ ngue emingue ee cote ra. —Ererecua chõ nde re, ɨchõɨño ɨquia ɨquia ee. Nyu ritimei uma ji que emɨɨ eãquĩ ndese corona nda. ");
INSERT INTO srqNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","—Judío rerecua tuchɨ chõ nde re, ɨchõɨño ngue ɨquia ɨquia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ira que euru uru eãquĩ ndese ra. Ñinimbu nimbu abe que erese no nda. Ngoi ngoi que ngũíã ndese erimba raã naa ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ɨ quia ɨquia tuchɨ que eu ee ra. Aquere que tiru ɨreɨ̃ mbuɨ esɨ cote ra. Eɨraote que emingue ee cote ra. Curuchoɨ que embucha nonde ira rese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ɨ rei que emo u quia uco sɨ ra. Simón, ɨ que ee ra. Cirene jenda mo ngue ae ra. Alejandro ru que ra. Rufo ru abe no. Aque que soldados isi ira mbuchɨcuandasa ji rerao sacuã ee ra. Cruz, ɨ equia ee. Nguerao que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ngasẽ ngue pee cote ra. Gólgota, ɨ que hue je ra. Eresa cuare, ɨ chõ nguiã hue je. ");
INSERT INTO srqNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Huee que vino mondo rei Jesús je ra. Mirra je emumbarai. Mbei eã ngue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Soldados que Jesús mbucha ira rese ra. Aquere que sɨta ñetẽ mbaba mbaba o je cote ra. —Aba ra Jesús ɨrao querao ñɨ ja, ɨ que nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tenda chuɨ ite ramo mose que embucha ira rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mbia que letrero mɨɨ Jesús ãquĩ nguiti ibate ra. JESUS REI JUDIO RERECUA ɨ que embesa mɨɨ nda. Ũquɨ̃ nɨɨ ño eriqui nguiã eɨquia hue. ");
INSERT INTO srqNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mbia nyeremo abe que embucha ira rese Jesús chabe ra. Jesús rereco chobeɨ que emɨɨ ira rese ra. Mbae mbuquiachãsa tuchɨ que ũquɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Embesa ji cheẽ nguire que Jesús ɨquia mbia ɨcuã ndese cote ra. Sã embesa ji riqui ñee no: “Mbia ɨcuã ndese ra eɨquia, sã embesa ji ɨ ñee nyii no. ");
INSERT INTO srqNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mbia que ɨquia ɨquia quia Jesús cheẽ naa naa ecuã mose ra. Ñee ɨcuã ɨcuã ee. —“Dios chuchua ra ambucoɨ. Tres días mose ra ambuchuruambe” ere que equia. ");
INSERT INTO srqNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Equiche u nde ae hue sɨ no, ɨ tuchɨ que mbia quia ɨquia ɨquia ee ecuã mose ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sacerdote rerecua abe que ɨquia ɨquia chõ nguia ee ra. Embesasa abe no. Ũquɨ̃ ngue ñee ɨcuã ɨcuã ja quia erɨɨ̃ nda. —Mbia que embuquera quera rei nyii ra. Ae sɨ́ quera aroneate nguiã aque. ");
INSERT INTO srqNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Judío rerecua mose ae, sã ae ae nguichi ira sɨ. Cristo mose ae, sã ae ae nguichi no. Ɨ̃ nda uremae erese. Ɨ̃ nda ureɨcua cote, ɨ ja que ererecua ñee ɨcuã ɨcuã erɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tenda nandeite re mose que itondaru tu ra. Itondaru beɨ que mbia ja je tres horas ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tenda cheseco mose que Jesús ñeemombo cote ra. —Eloi, Eloi, ¿lama sabactani? ɨ que ñee mombo ra. —Dios sererecua, ¿mbaerã ereɨco huɨ sesɨ re? ɨ chõ ngue ñee nguiã. ");
INSERT INTO srqNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","—Elías je eriqui “quiatuchu” ɨ reae, ɨ rei que echeẽ andusa mo nda. ");
INSERT INTO srqNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Emo ngue esponja monde vinagre ye ra. Ira ai rese que embia ji mondo rei Jesús chúruu cote ra. —Esecha rei. Sã Elías ruãt e quia erea, ɨ que emo ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús que tasẽ mano mbeɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Aque mosechɨ tuchɨ que cortina nyisia Dios chuchua jenda ra. Ibate sɨ que eru nyisia íbii ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldado rerecua que chɨ̃ Jesús nonde mae erese ra. Emano ndese que eñɨ mae nda. —Dios riirĩ ño eriqui re, ɨ que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Cuña ngue chɨ jate ma e Jesús rese ɨsho ra. María Magdalena abe que chɨ̃ huee ra. Salomé abe no. María abe no. María rei José si. Jacobo Ñetẽ si abe no. ");
INSERT INTO srqNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ũquɨ̃ ngu e siqui beɨ quia Jesús ruɨ ra. Echɨurã ngue emɨɨ mɨɨ mbeɨ quia ee ra. Galiléaa eɨco mose beɨ. Cuña tubɨrɨãte abe que chɨ mae Jesús mbuchai rese huee ra. Ae nyoɨ Jesús rese Jerusalén, ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tenda que oso cote ra. Sábado nonde. Aque mose beɨ que mbia riqui mbae mbuquiche ja sábado sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Aque eresaitõ mose que José sɨ ñee Pilato je ra. Judío turã ngue ae ra. Arimatea jenda que ae ra. Judío rerecua que ae no nda. —Dios ra ererecua, ɨ beɨte que equia eraarõ arõ nda. Aque que ɨreɨ̃ ɨreɨ̃ ãte oso ñee Pilato je ra. —Jesús raaque emee na seje, ɨ que oso ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","—¿Mano jeɨ tuchɨ ere? ɨ tuchɨ que Pilato uchɨangui re ra. —Quiatuchu rã sembiirandu. ¿Jesús mano cote re? ɨ que Pilato ñee soldado rerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","—Mano ngue cote ra, ɨ que soldado rerecua ñee ee ra. Nyebe Pilato eraaque mondonguiã José je cote. ");
INSERT INTO srqNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José que Jesús raaque mbuquichi cote ra. Tirushĩ turã mo ngue eisi ra. Eraaque que echuma aque je cote ra. Iti que echoɨ sɨta rɨbɨcoɨ ji ɨmɨ ye ra. Nyati que sɨta cuasu mo je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena ngu e mae mɨ eati rese ra. María rese. José si que ae ra. ");
INSERT INTO srqNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jesús raaque ati ji que chɨbe sábado mose ra. Ɨ nyaashɨ̃ oso quia domingo mose, aque mose que cuña mo nyoɨ mae eatisa rese ra. María Magdalena. Salomé abe no. María abe no. Jacobo si rei ae. Ũquɨ̃ ja que aba mbushɨmbusa isi rei eichusẽ chusẽ sacuã Jesús raaque rese ra. ");
INSERT INTO srqNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tenda nyuɨ ramo mose que echoɨ eatísaa ra. ");
INSERT INTO srqNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","—¿Aba ra sɨta curuba nande je eatiquia re? ɨ rei que echoɨ quia ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ɨ que sɨta rurubai u ee cote ra. Sɨta cuasute quiatu ngue re. ");
INSERT INTO srqNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ɨque rei que echoɨ sɨta ɨmɨ ye ra. Acuanɨndu mo ngue chɨ̃ ngoi huee equiatocuti quiti ra. Huɨɨraoshĩ oco tuchɨ que ecunuɨ huee ra. Cuña ngue siquiche tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Acuanɨndu que ñee ee ra. —¿Mbaerã jẽɨngo siquiche re? Jesús raaque jẽsequia raque quia ã. Emoate a resẽ. Eraaque que quera sɨ no. Jemae eatisa rese ae. ");
INSERT INTO srqNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jẽso asi rã echɨmbaaquiatu mbiirandu erese. Pedro abe jembiirandu. “Jenonde ra esɨ Galilea. Jemae nda erese huee. Sã ñee jẽje nyii no”, jenye embiirandu, ɨ que acuanɨndu ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Cuña ngue siquichete echeẽ andu ra. Uchã ngue echoɨ eatisa sɨ ra. Ñee eã tuchɨ que mbia mo je ra. Esiquichete quiatu ngue re. ");
INSERT INTO srqNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús que quera sɨ nyaashɨ̃ namo mose domingo mose ra. María Magdalena nane je que nyecua ra. Aque sɨ chõ eriqui siete aba checuayã ɨcuã jea nyii reaẽ. ");
INSERT INTO srqNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ae que oso Jesús quiato mbiirandu ja cote ra. Ngasẽ mose ee que echɨ nyeseo jate eya eã ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","—Jesús que quera sɨ ra. Amae ngue erese ra, ɨ rei que embiirandu ra. Quera aroneate que ũquɨ̃ je ra. ");
INSERT INTO srqNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Aquere que nyecua uquiato nyeremo je ra. Ɨshote que sucha tubɨrɨã sɨ ra. Emo na tuchɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","—Jesús que quera sɨ nyecua ure je ra, ɨ rei que echoɨ uataque mbiirandu ra. Quera aroneate que ee no nda. ");
INSERT INTO srqNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aquere que Jesús nyecua uchɨmbaaquiatu ja je no nda. Once je. Ũquɨ̃ quiaru mose que nyecua ee ra. Ñee asi asi que ee ra. —¿Mbaerã jeñɨa ãtãte riqui re? ¿Mbaerã “nyia” jenye eã jembiirandu mose sequera rese re? ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","—Jẽso secheẽ nenei nenei mbia ja je. Mbia mangue chooñoa jenda ja je. ");
INSERT INTO srqNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mbia mo nda seɨcua ɨcua. Ũquɨ̃ je bautizar jenye. Ũquɨ̃ nda siqui beɨ cote. Ae ra seɨcuayã, ũquɨ̃ nda mbae rasi saã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Seɨcuasa ra mbia mae sayã saã saã tuchɨ. Aba checuayã ɨcuã nda ejea jea mbia sɨ serɨɨ̃. Mbia cheemo nda esaã. ");
INSERT INTO srqNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mbeɨ ra eisi isi o je. Aba ɨquiasa mbei mose ra erasiã. O ra echono ñono erasi arõ embucherõ sacuã, ɨ que Jesús uchɨmbaaquiatu mondo ra. ");
INSERT INTO srqNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesús ñee ja mose que Dios equerao ibate cote ra. Siqui beɨ sacuã Dios jii cote. ");
INSERT INTO srqNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Echɨmbaaquiatu que nyoɨ Dios cheẽ nenei nenei mbia ja je ra. Mangue chooñoa jenda ja je. Dios que siqui tuchɨ quia erese ra. Mbia mae sayã tuchɨ que esaã saã nguia ra. Mbia Dios cheẽ ɨcua sacuã. Amén.");
INSERT INTO srqNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Jesucristo que mbae saã saã tuchɨ quia huɨɨco mose íbii ra. Mbia atate que echɨsaã mbesa mbesa rei ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mae ndei equia erese nyii. Dios cheẽ esenei senei mbeɨ rei quia nyii. Jesucristo chɨsaã ndese que urembiirandu cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Se abe que airandu tuchɨ cote ra. Ae esaã saã nguia nyii nae, aque mosenda beɨ rese que airandu cote ra. Se abe ũquɨ̃ tambesa ja ndeje, Teófilo. Tasenei turã ja embuchiabiã ndeje. ");
INSERT INTO srqNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ae rese ereirandu randu nae, ũquɨ̃ ereɨcua tuchɨ sacuã ño aɨco nguiã embesa mbesa ndeje. Eɨ̃ nda “ae beɨ” ere chõ nguia Jesucristo chɨsaã saã je. ");
INSERT INTO srqNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Zacarías, ɨ que emo je ra. Sacerdote que ae ra. Herodes que siqui Judea mbia rerecuarã aque mose ra. Abías resenda rei Zacarías. Aarón ndiirĩ nducucha rei Zacarías. Eninisi abe rei Aarón ndiirĩ nducucha no. Elisabet, ɨ que eninisi je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías turãte que eriqui Dios je ra. Ngũinisi rese. Ũquɨ̃ ngue Dios cheẽ mumbayã mbeɨ quia ra. Eɨcuãte, ɨ aroneãte que mbia mo nguia erɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Eriiriã mbeɨ que eriqui ra. Tiiriã je rei Elisabet. Ari chee. Zacarías abe que ameɨte chee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Sacerdotes que nyuuru uru beɨte quia querabe mbae raã naa Dios chuchúaa ra. Nyebe que Zacarías abe riqui mbae raã naa Dios chuchúaa emo mose ra. Zacarías que oso ɨque tuchɨ Dios chuchua ra. Mbae mo ndei sacuã embushɨmbu. ");
INSERT INTO srqNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zacarías que mbae shɨmbu sei cote ra. Mbia cuabẽ ngue chɨ ja taicuee ñee ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Angel ibatenda mo ngue tu nyecua Zacarías je cote ra. Chɨ̃ ngue juã mbae shɨmbu reisa ji ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías mae mose ángel rese, siquiche tuchɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Angel que ñee Zacarías je cote ra. —¿Mbaerã ereɨco siquiche re? Dios que ndecheẽ ñandu ra. Elisabet nda tiirĩ ndeje cote. Juan, ere nderiirĩ je nyaacuquia mose. ");
INSERT INTO srqNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ndeyate ra cote. Nderiirĩ nyaacuquia mose ra mbia ia tuchɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nderiirĩ nda mbae turã saã saã tuchɨ quia Dios je. Mbaeri rasi mo nda embei eã tuchɨ. Espíritu Turã nda siqui tuchɨ erese. Esi rie ye ereco mose beɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nderiirĩ nda mbia Israel jenda mbuchebi ja Dios je. Dios ra ũquɨ̃ nderecuarã. ");
INSERT INTO srqNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nderiirĩ nda mbae mbuquiche ja Cristo tu nonde. Sã Dios Elías mbuquirãcuã no, eɨ̃ sɨ ra Dios uquirãcuã mee nderiirĩ je. Nderiirĩ nda mbia mbuturã turã nyɨese. Eru mbuturã turã nguiirĩ ndese. Eriirĩ mbuturã turã ngu rese no. Nderiirĩ nda aba cheẽ mumbasa mbaaquiatu quiatu. Aba cheẽ mumbayã sacuã cote. Nderiirĩ nda mbia mbuquiche ja Cristo tu nonde, ɨ que ibatenda ñee Zacarías je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías que ñee ángel je ra. —¿Mañɨ nda ũquɨ nde? ¿Ndecheẽ nda ɨque seje re? ¿Manyae ra eɨcua re? Ameɨte se. Seninisi abe arite, ɨ que Zacarías ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angel que ñee Zacarías je ra. —Se rei Gabriel. Dios rimba chõ aɨco co. Dios quia semondo rei nguiã ñee turã sacuã ndeje. ");
INSERT INTO srqNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","“Nyia” ere eã ñochɨ̃ secheẽ je. Nyebe ra ndeisayã. Ndecheẽ ngũíã nda eno. Nderiirĩ nda nyaacuquia chee. Nderiirĩ nyaacuquia mose ra erecheẽ nyecua cote. Secheẽ nda ɨo ja ndeje cote, ɨ que ángel Zacarías je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mbia que chɨ beɨ taicuee huee ra. Zacarías raarõ arõ. —¿Mbaerã Zacarías riqui itõ tuchɨte Dios chuchúaa re? ɨ que mbia ñee jate ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarías que usẽ nyee ra. Echeẽ ngũíã. O que emumbate mbate chõ nguia mbia je ra. —Zacarías mbae mo tea cuu Dios chuchua reae, ɨ que mbia ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zacarías que umbae tarea saã ja Dios chuchúaa ra. Tenda nongue mose. Emo ngue tu euru cote ra. Zacarías que oso uchuchua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aquere qu Eya uchɨ que cote ra. Eninisi que useã mbeɨ tuchua sɨ cinco meses ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Dios seriirina meeñɨ seje cote. Mbia ra ɨquia ɨquia eã seje cote, ɨ que Elisabet ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nyasi nongue mose que Dios ibatenda mondo mbia mo je ra. Gabriel, ɨ que aque ángel je ra. Aque que emondo sucha Nazaret ra. Galilea, ɨ que aque ibi je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","—Eso rã ñee nyucuaaque María je, ɨ que Dios ángel mondo ra. Emo ngue siquíã tuchɨ María rese ra. Eruã mbeɨ. José ninisibi rei María. José siquíã ndaque erese. David riirĩ nducucha rei José. ");
INSERT INTO srqNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angel que ɨque María ch María chuchua cote ra. —Acheẽ ngue u ndeje ra. Dios turã tuchɨ riqui ndeje co. Ndua beɨ nderese. Dios ia tuchɨte nderese acuanɨ mo sɨ, ɨ que ángel María je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María mae mose ibatenda rese que ñee uchɨangui re ra. —¿Mbaerã eru quia serea co re? ¿Mbaerã eru quia ñee seje co re? ɨ que María uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angel que ñeembe ee ra. —María, siquichechɨ̃ nda sesɨ re. Dios turã tuchɨ riqui ndeje co. ");
INSERT INTO srqNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Dios cheẽ turã ngue asenei u ndeje ra. Nanɨmbae ra nde cote. Nderiirina nda eretea cote. Jesús, ere nderiirĩ je. ");
INSERT INTO srqNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nderiirĩ quirãcuã tuchɨ rae. Dios quirãcuã ndiirĩ nda erereco. Mbia rerecua tuchɨ ra ae. Sã David riqui mbia rerecua nyii no, eɨ̃ nda nderiirĩ mbia rerecua tuchɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nderiirĩ nda judíos rerecua beɨ cote. Ua eã mbeɨ rae, ɨ que ángel ñee María je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María que ñee ángel je ra. —¿Mañɨ nda serío re? Seru eãte nyeresẽ, ɨ que María ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angel que ñee María je ra. —Espíritu Turã ae ra Dios riirĩ mondo nderie ye. Espíritu Turã nda ndereaquiatu beɨ quia. Dios quirãcuã nda siqui beɨ nderese. Nyebe ra Dios mbaerã tuchɨ nderiirĩ. Dios rucucha, ɨ ra nderiirĩ je. ");
INSERT INTO srqNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ndesi nongue ndiirĩ abe ra tiirĩ cote. Elisabet, ɨ equia ee nae, aque abe ra tiirĩ. Arite raque. Erie cuasu cote. Tiirĩ mbae, ɨ mbia quia ee nyii nae, aque ra tiirĩ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dios quiarei mbae ao ja, ɨ que ángel ñee María je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María que ñee ee ra. —Dios rimba chõ aɨco nguiã co. Sã ndecheẽ ique quia seje, ɨ que María ra. Angel que oso erecha cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","María que oso Elisabet ndea cote ra. Ñeenda ɨshote que ee ra. Sɨta ibate bate rɨ̃ ngue esɨ quia ra. Judea, ɨ hue ibi je. ");
INSERT INTO srqNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","María que ngasẽ Elisabet ndu chuchúaa ra. Zacarías, ɨ equia eru je. Ique que ñee Elisabet je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet María cheẽ andu mose, erie yenda que umɨ nda. Espíritu Turã ngue ɨque tuchɨ Elisabet chɨangui re cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabet que ñee nyecua tuchɨ María je ra. —Nde rese chõ Dios ia tuchɨ acuanɨ mo sɨ re. Dios ia tuchɨ nderie yenda rese abe no. ");
INSERT INTO srqNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Mbaerã Cristo si ru serea se re? Mbia rerecua eã ño se resẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Se ndecheẽ andu mose que serie yenda ia tuchɨ umɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dios cheẽ ngue ereisi turã nda. Nyebe Dios iate riqui nderese co. Nyebe ra Dios cheẽ ɨque tuchɨ ndeje cote, ɨ que Elisabet ñee María je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María que ñee cote ra. Acheẽ turã mbeɨ quia Dios rɨɨ̃ co. ");
INSERT INTO srqNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Seya beɨ riqui Dios rese co. Ae que serirõ mbae ɨcuã sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dios que nduate quia serese ra. Seaquiatuã ndaque. Nyebe ra mbia ia jate serese cote. ");
INSERT INTO srqNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dios quirãcuã ngue mbae turã saã tuchɨ seje ra. Ae mɨɨ ño eturã tuchɨ emo sɨ re. ");
INSERT INTO srqNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ae ndua turã nguia Dios rese nae, ũquɨ̃ ndese chõ Dios ia eã tuchɨ riqui nguiã. Eɨ̃ mbeɨ chõ Dios nguiã mbia je co. ");
INSERT INTO srqNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dios quirãcuã ngue mbae saã ja ra. Ucuasu raã naasa chõ Dios mboseɨ̃ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Siqui mingue je chõ Dios mɨɨ mɨɨ nguiã mbia rerecuarã. Ae ererecua uaquiatu saã saã nguia nae, ũquɨ̃ ño Dios sirõ nguiã. Ererecua eã ño ũquɨ̃ cote re. ");
INSERT INTO srqNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dios que mbae mee mee nguia mbaecha reã je ra. Mbaecha quia emboochɨ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Dios que siqui tuchɨ judíos rese ra. Tesareɨã mbeɨ esɨ. Eyayã mbeɨ erese no. ");
INSERT INTO srqNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Sã Dios ñee Abraham je no, ũquɨ̃ ngue embuchebiã mbeɨ ra. Ae ucheẽ mondo judíos jaje nae, ũquɨ̃ ngue embuchebiã mbeɨ no nda, ɨ que María ñee turã Dios rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María que siqui arete Elisabet rese ra. Tres meses. Aquere que eru nyebi uchuchúaa cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet rasi rasite que cote ra. Nyaa cuquia que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mbia que nyoɨ ja Elisabet ndea cote ra. Ejii jenda. Eresenda ja. —Dios turã tuchɨ riqui ndeje co. Ãquẽ mondo ndeje, ɨ ja que ee ra. Eya ja tuchɨ que erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho días mose que circuncisión naa eriirĩ je ra. Zacarías, ɨ nda mbia eriirĩ je chã nde. Eru rã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Esi quia que ñee nda. —Tei. Juan nande chõ ee, ɨ que esi ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mbia que ñee esi je ra. —¿Mbaerã nda “Juan” ere nderiirĩ je re? Juan mo eã nderesenda mo aa resẽ, ɨ rei que mbia esi je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mbia que o mbaaba aba Zacarías je ra. —¿Mañɨ nda nderiirĩ je re? ɨ ee. ");
INSERT INTO srqNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarías que ñomee mbia je ra. Nyebe mbia embesa sacuã mee nguiã ee. —Juan, ɨ chõ seriirĩ je, ɨ que Zacarías embesa ra. Mbia que nyuruɨra ja u mae erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aque ruɨbe que Zacarías ñee aquiatu cote ra. Ñee turã tuchɨ que equia Dios rɨɨ̃ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Zacarías cheẽ andure que mbia nyuruɨra jate ndua ndua hue jenda ra. Nyebe mbia ñɨmbiirandu ja nguiã sɨta ibate bate jenda. Judea, ɨ que hue ibi je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ae jirandu quia erese, ũquɨ̃ ngue ndua tuchɨ quia erese ra. —Mañɨ nda Zacarías riirĩ nguia reae. Nandemae nguia erese no, ɨ que mbia quia ndua ndua ra. Dios que siqui tuchɨ Zacarías ndiirĩ ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Espíritu Turã ngue siqui tuchɨ Zacarías rese ra. Nyebe Zacarías Dios cheẽ nenei nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Sã mbia ñee turã Dios rɨɨ̃ judíos rerecua rɨɨ̃. Uturã ngue eteacuquia nande je ra. Nanderirõ ngue mbae ɨcuã sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nanderirõ sacuã nandeɨcuã sɨ que Dios mondo nande je ra. David riirĩ nducucha que nanderirõ sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sã Dios ñee cose no. “Mbia rirõ sacuã nda ambu íbii”, ɨ cose no. Ucheẽ nenei neneisa que embuchecua mbia je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Jẽucuãyãsa sɨ ra jendirõsa jendeaquiatu beɨ”, ɨ que Dios nande je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Dios turãte que eriqui nandei ñiinda je ra. Abraham je abe que eturãte riqui ra. Ae Dios ñee Abraham je nyii nae, echeẽ ngue ɨo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Dios que ñee Abraham je nanderɨɨ̃ nyii ra. “Taendeaquiatu jẽucuãyãsa sɨ, jẽsiquicheã sacuã ɨco mose serese”, ɨ que Dios nanderɨɨ̃ cose ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nyebe ra nandeɨco turã mbeɨ Dios je. Ae ra nandemingo beɨ ɨcúe umbaerã. ");
INSERT INTO srqNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nde ra Ibatenda cheẽ esenei senei nguia mbia je, Ãquẽ. Dios riirĩ ndetã nda Dios cheẽ eresenei senei nguia mbia je, Ãquẽ. Mbia ɨcoquiatu sacuã Dios riirĩ je. ");
INSERT INTO srqNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Eɨ̃ mose ra Dios mbia rirõ eɨcuã sɨ. Eɨ̃ mose ra Dios mbia ɨcuã mbutiã esɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dios turãte quia eriqui nguiã nande je. Eriirĩ nda tu ibate sɨ mbae mbuchecua nande je. ");
INSERT INTO srqNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nandeaquiatuã mbaaquiatu sacuã ño eru nguiã aque. Nandemingo sacuã nyaashɨ̃ naanguia chõ eru nguiã aque, ɨ que Zacarías ñee ãquẽ je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ãquẽ ngue tiarõ ɨ ɨ oso quia cote ra. Dios rese que eriqui ɨ ɨ cote ra. Siqui beɨ que equia turúquiaa ra. Dios cheẽ ngue esenei senei nyee mbia je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aque mose que ererecua ñee nda. Augusto, ɨ que ee ra. —Censo nandesaã na mbia ja je, ɨ que ra. Mbia mbae nombre mbesa mbesa ja mose, “censo” ɨ que ũquɨ̃ je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Censo raã namo mose rei ũquɨ̃. Cirenio ngue Siria jenda rerecua aque mose ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","—Jenyusua sua jẽso ja pueblo. Nombre mbesa mbesa ja sacuã jembae, ɨ que ererecua mbia ja je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nyebe José choɨ nguiã Judea. Belén, ɨ que sucha je ra. Belén ño David chusua re. José i chõ David re. Nyebe José choɨ nguiã Belén. Umbae ibi recha. Nazaret recha. Galilea abe recha no. ");
INSERT INTO srqNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José que nyoɨ Belén umbae nombre mɨɨ sacuã nda. María rese. María que eninisibi ra. María riote que ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Siqui mose Belén ngue ãquẽ ndasi rasite María je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aque ramo ngue María nguiirĩ mbua ra. Ñuma ngue tiru je ra. Ticuasu quiarusa ye que eno nda. Mbia chuchua quiatu que eitãyãte ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hue jii que oveja raarõsa mo nyɨ isa ra. Ovejas que esaarõ arõ nguia turuquia rɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Angel ibatenda mo ngue tu embua tuchɨ ra. Dios nininya tuchɨ que tu overja raarõsa resae ra. Nyebe siquiche tuchɨ nguiã esɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angel que ñee ee ra. —¿Mbaerã jẽsiquichete riqui re? Mbae turã nɨɨ ño achu nguiã ñee jẽje co. Ae ra asenei jẽje, mbia mbia sacuã tuchɨ chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dios riirĩ ngue nyaacuquia namo Belén nda. Cristo, ɨ equia ee. Mbia rirõsa mbae ɨcuã sɨ chõ ae re. ");
INSERT INTO srqNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aque echɨ ticuasu quiarusa ye aque. Ema ji tiru je. Jemae nda erese huee. Jemae mose sechɨenei ndese, “Cristo chõ eriqui re”, jenye ra cote, ɨ que ángel ñee oveja raarõsa je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Angeles tubɨrɨãte que nyecua oveja raarõsa je cote ra. Angel ñiinda ndese. Ñee turã ja que Dios rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Sã mbia ñee turã ja Dios ibatenda rɨɨ̃. Sã Dios uquiato mbia ja ibi jenda, ɨ que ángeles ñee nyecha ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angeles que nyoɨbe ibate cote ra. Oveja raarõsa que ñee ñee nyue cote ra. —Nyaso rã Belén. Ae Dios senei senei nguia nande je nae, nyaso rã mae erese. Ae nyaacuquia namo nae, nyaso rã mae erese, ɨ que oveja raarõsa ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nyoɨ asi tuchɨ que mae erese ra. Ngasẽ ngue María je ra. José abe je. Ãquẽ abe je. Ɨ que ãquẽ u ticuasu quiarusa ye ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Oveja raarõsa que mbia mbiirandu ja erese ra. Ae ángel senei senei nguia ee María riirĩ nɨɨ, ũquɨ̃ ngue oveja raarõsa senei senei tuchɨ mbia je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Eandusa que nyuruɨra ja tuchɨ eandu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María que ndua ndua tuchɨ quia ũquɨ̃ ja rese uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Oveja raarõsa ia tuchɨ que nyoɨ nyebi ovejas je ra. Ñee turã turã tuchɨ que echoɨ quia Dios rɨɨ̃ nda. —Angel que ñee nande je, echeẽ nduɨ sɨ tuchɨ chõchɨ̃ mbae eɨ̃ ja, ɨ que ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ocho días mose que circuncisión naa ãquẽ je cote ra. Jesús, ɨ que ãquẽ je cote ra. Angel cheẽ nduɨ sɨ tuchɨ chõ “Jesús” ɨchɨ̃ ãquẽ je. Ae ángel ñee María je erio nonde nae, echeẽ nduɨ sɨ tuchɨ chõ “Jesús” ɨchɨ̃ María riirĩ je. ");
INSERT INTO srqNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Aquere que María ñimbitirõ Moisés cheẽ nduɨ sɨ cote ra. Aquere que ãquẽ nduruchoɨ Jerusalén cote ra. Ãquẽ mee sacuã Dios je. ");
INSERT INTO srqNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Embesa ji cheẽ nduɨ sɨ que ãquẽ mee Dios je ra. —Ae eriirĩ i erãcuẽ nae, ũquɨ̃ jemondo tuchɨ Dios je, ɨ quiatu ngue embesa ji rese re. ");
INSERT INTO srqNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jerusalén José riqui mose que sacrificio mee Dios je ra. Embesa ji cheẽ nduɨ sɨ. Sã embesa ji riqui ñee no: —Nyurusɨ nyeremo jemee Dios je. Ũquɨ̃ eã mose, nyurusɨ ñetẽ jemee ee no ae, ɨ que embesa ji cheẽ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ameɨ mo ngue siqui hue Jerusalén nda. Simeón, ɨ que ee ra. Ae que eturã tuchɨ ra. Ñee mbeɨ que equia Dios je ra. Ae que Dios riirĩ saarõ arõ tuchɨ quia ra. Judíos mbuɨ sacuã mbae ɨcuã sɨ. Espíritu Turã abe que siqui Simeón ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Espíritu Turã nguia ñee ndei Simeón je nyii. —Eremae nda Dios riirĩ ndese. Ndemano nonde ra eretea. Dios ra embu íbii, ɨ que Espíritu Turã ñee Simeón je nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Espíritu Turã ngue Simeón querao Dios chuchúaa ra. Embesa ji cheẽ nduɨ sɨ que José ãquẽ nduruchoɨ Dios chuchúaa aque mose sɨ ra. María reses. ");
INSERT INTO srqNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón ngue ãquẽ suɨ ra. Eya tuchɨ que erese ra. —¡Co chõ jẽ! ɨ que Simeón ñee turã Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dios, ndecheẽ ngue ɨo seje cote ra. Seyate aɨco co cote Sererao se cote. ");
INSERT INTO srqNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nderiirĩ ndese que amae cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ae erembu mbia rirõ sacuã mbae ɨcuã sɨ nae, aque rese aɨco mae co cote. ");
INSERT INTO srqNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mbia resae sacuã tuchɨ chõ nderiirĩ ndiqui re. Judíos eã abe ra etesae tuchɨ. Judíos abe je ra eturã tuchɨ no, ɨ que Simeón ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón ñee mose María riirĩ nɨɨ, José que nyuruɨra tuchɨ echeẽ andu ra. María rese. ");
INSERT INTO srqNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón ngue ñee turã María je ra. —Nderiirĩ nda judíos tubɨrɨã mingo turã. Ae siqui sereãte quia erese, ũquɨ̃ nguia ra emingo ɨcuã. Mbia ra ñee ɨcuã ɨcuã nguia nderiirĩ turã je. Eɨcuã je rocoɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ae ndua turãte quia nderiirĩ nɨɨ nae, ũquɨ̃ ndua ndua turã nda nyecua mbia je cote. Ae ndua ndua ɨcuã nguia, ũguɨ̃ ndua ndua abe ra nyecua mbia je cote no. Mbia ɨcuã nda nemundite nderiirĩ ndese, ɨ que Simeón María je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Huee que arite mo ndiqui ra. Dios cheẽ nenei neneisa que ae ra. Ana, ɨ equia ee. Fanuel, ɨ que eru eiruã siasa je ra. Aser, ɨ que ei ñiinda je ra. Ana yasu mose que ngurã ndea nyii ra. Siete años que eriqui ngu rese nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Eru eã ngue cote ra. Eru cheecha que siqui beɨte ra. Ochenta y cuatro años. Dios chuchúaa que eriqui beɨte ra. Ñee ñee mbeɨ Dios je. Quiaru rocoɨ. Isa abe. ");
INSERT INTO srqNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana ngue mae ãquẽ Jesús rese Dios chuchua cote ra. —¡Co chõ jẽ! ɨ tuchɨ que Dios je ra. Ñee turã tuchɨ que ãquẽ nɨɨ mbia jaje cote ra. Ae Dios riirĩ saarõ arõ nguia nae, ũquɨ̃ jaje que Ana ñee turã turã ãquẽ nɨɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José que mbae saã ja embesa ji cheẽ nguire ra. Aquere que echoɨ nyebi Galiléaa ra. Nazaret, ɨ equia echuchua je. ");
INSERT INTO srqNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","María riirĩ ngue tiarõ cote ra. Ñɨmbaaquiatu quiatu que equia cote ra. Ñɨmbirãcuã nacuãte que equia cote ra. Dios turã ngue siqui tuchɨ quia erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Aque tenda beɨ que José riqui nyoɨ choɨ Jerusalén nda. Fiesta de la pascua mose beɨ. María rese. ");
INSERT INTO srqNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús tiarõ namo mose, doce años mose que echoɨ sɨ fiesta de la pascua mose no nda. Jerusalén. ");
INSERT INTO srqNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Fiesta ua mose que ecuaẽ ndei quia nyebi ra. Jesús que siquichõ Jerusalén nda. Jesús abe oso reɨ̃ nguiã usi je. Ngu abe je. ");
INSERT INTO srqNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jerusalén ño eriquichõ neaẽ. Mbia ataque rese eru reɨ̃ nguiã esi je. Mbia que ngaẽ ngaẽ beɨ quia tenda mumba chee ra. —Ma Jesús ñɨ, ɨ rei que nguesenda je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tea eã mbeɨ que ra. Erea eã mose que eru sɨ chee nyebi Jerusalén nda. María rese. Erequia sacuã huee cote. ");
INSERT INTO srqNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tres días mose que erea huee cote ra. Dios chuchúaa que eriqui ee ra. Ñimbaaquiatu quiatu. Mbia mbaaquiatusa cheẽ andu andu que Jesús riqui ngoi huee ra. —¿Mañɨ equia re? Tachandu tuchɨ rã, ɨ ɨ que equia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jesús cheẽ aracua tuchɨ que eriqui mbia je ra. Nyebe mbia nyuruɨra nguiã echeẽ aracua andu. ");
INSERT INTO srqNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eru erea mose huee, ae abe que nyuruɨra ra. Esi abe nyuruɨra no. Esi que ñee ee ra. —¿Mbaerã eresoã urerese re, Echo? Ureya eã tuchɨ que eriqui nderequia asi asi ra, ɨ que María nguiirĩ je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús que ñee ee ra. —¿Mbaerã serequia mámbii re? Paba chuchua chõ ngue aɨco resẽ, ɨ que Jesús usi je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","María que Jesús cheẽ ɨcuayãte ra. José abe echeẽ ɨcuayã no. ");
INSERT INTO srqNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesús que oso uchuchua erese cote ra. Nazaret, ɨ equia sucha je. Usi cheẽ ngue emumbayã mbeɨ quia ra. Ngu cheẽ ngue emumbayã mbeɨ quia no nda. Esi que ndua ndua beɨ quia ũquɨ̃ Jesús chɨsaã ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús rete que siri siri oso quia cote ra. Ñɨmbaaracua racua que equia no nda. Dios iate que eriqui erese ra. Mbia abe iate que eriqui erese no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Aquere que Dios ñee Juan je ra. Zacarías riirĩ je. Tiberio siqui beɨ mose mbia ja rerecuarã. Quince años ereco mose mbia rerecuarã. Poncio Pilato que Judea jenda rerecua aque mose ra. Herodes que Galilea jenda rerecua ra. Felipe que Herodes nongue ra. Felipe que Iturea jenda rerecua ra. Traconite jenda rerecua abe que Felipe no nda. Lisanias que Abilinia jenda rerecua ra. Anás que sacerdote rerecua ra. Caifás abe que sacerdote rerecua ra. Ũquɨ̃ ererecua sique mose que Dios ñee Juan je turuquia re ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nyebe que Juan Dios cheẽ senei senei nguia mbia je ra. Ama Jordán ndurubinda jaje. Eɨ̃ ño ngue Juan nguia ñee mbia je ra. —Jẽhuɨ chõ jẽɨcuã sɨ. Dios jẽɨcuã mbutiã sacuã. Ũquɨ̃ mose nda bautizar ae jẽje chã, ɨ que Juan nguia ñee mbia ja je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaías chɨmbesa ɨo sacuã ño ngue Juan Dios cheẽ nenei nenei nguiã. Isaías chɨmbesa chõ ã nde: Emo nda ñeemombo mombo quia mbia je turúquiaa. “Ñeenda nandererecua mbaerã jembuquiche. Jẽɨngo quiatu nandererecua tu nonde. ");
INSERT INTO srqNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ñeenda jembuturã turã nandererecua mbaerã. Ibi cuaacua jembato mbato. Ibi ati ati jẽsimiambo ambo. Ñeenda chaa chaa jeñeengo. Ibi rashɨ̃ ndashɨ̃ jẽiti iti. ");
INSERT INTO srqNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","‘Mbia mingo beɨsa’, ɨ ja ra mbia ñee Dios je cote”, ɨ ra emo nguia turúquiaa, ɨ que Isaías embesa cose ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mbia que nyoɨ nyoɨ ja quia Juan ndea ra. Juan bautizar ɨ sacuã ee. Juan ngue ñee ee ra. —Mbeɨ rã ño jẽɨngo nguiã. Mbae ɨcuã nda jeɨ̃ jeɨ̃ mbia je, ¿ũquɨ̃ sɨ jenyu quia seje co re? ");
INSERT INTO srqNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Jẽ mbae ɨcuã ndecha mose Dios je, mbae turã jẽsaã saã mbeɨ quia ee cote. “Abraham ndiirĩ nducucha chõ nande re. Nyebe ra Dios nandemingo beɨ” ¡jenyechɨ̃ nda jẽ! Dios Abraham ndiirĩ nducucha chao arondete raque sɨta je. ");
INSERT INTO srqNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ira rã sɨ chõ mbia re. Sã ira mo ɨa eã no. Sã ea eã maña ño no. Sã eréi chõ no. Eɨ̃ serɨ̃ serɨ̃ ño Dios mbia je, mbia mbae turã naa eã mose, ɨ que Juan ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","—¿Mbae rese ra ureɨco Dios je re? ɨ que mbia Juan je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan ngue ñee ee ra. —Ndeɨrao nyeremo mose, enongue emondo eɨrao eã je. Ndechɨurã mose, emo emondo mbaecha reã je, ɨ que Juan mbia mbaaquiatu quiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Impuestos isi isiquia mo abe que nyoɨ Juan je ra. Juan bautizar ɨ sacuã ee. —¿Mbae rese ra ureɨco ure re? ɨ que ñee Juan je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—¡Mbae ra jembatachɨ̃ jẽ! ¡Cobrar jenye turã ño jẽ! Jẽɨcua quiatu chõ, ɨ que Juan ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldados mo abe que ñee Juan je ra. —¿Mbae rese ra ureɨco ure re no? ɨ que soldados ñee Juan je ra. Juan ngue ñee ee ra. —¡Mbia mbae ra jẽisi chooñochɨ̃ jẽ! “Co que mbae ɨcuã saã nda” ¡jenye chooñochɨ̃ nda emo je jẽ! Jembae ae chõ jendeco, ɨ que Juan ñee soldados je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mbia que mae quiatu quiatu quia Juan ndese ra. —Cristo chõ co reae, ɨ raque mae quiatu quiatu erese. ");
INSERT INTO srqNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan ngue ñee mbia jaje ra. —I achõ je chõ aɨco nguiã bautizar ɨ mbia je co. Co chɨ emo ndu quia seruɨ co. Ae quia equirãcuã tuchɨ sesɨ re. Ae quia eturã tuchɨ sesɨ re. Ae quia ra bautizar ɨ mbia je Espíritu Turã je. Mbia chɨã mbitirõ sacuã. Sã tata riqui mbae mbitirõ no. ");
INSERT INTO srqNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ae ra mbia umbae mɨɨ ɨcúe. Eturã achõ ño embae re. Ae embae eã nae, ũquɨ̃ nda esei cote. Ũquɨ̃ ndeisa ra ua eã mbeɨ tata. Sã mbia quiata a chiqui chiqui no. Sã ea mɨɨ ɨcúe no. Sã echuruique mombo tátaa no, ɨ que Juan ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Eɨ̃ ngue Juan nguia Dios cheẽ turã nenei nenei mbia je ra. Mbia mbaaquiatu tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ererecua Herodes je que Juan ñee nyee ra. Felipe ninisi rese siqui mose. —¿Mbaerã ereɨco ndenongue ninisi rese re? ɨ que Juan ererecua je ra. —Mbae ɨcuã eresaã saã ja techɨ̃ nguia re, ɨ tuchɨ que Juan ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ererecua que Juan ñee mumba beɨ chõ nda. Ererecua que Juan tarõ nyee cárcel nda. ");
INSERT INTO srqNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juan bautizar ɨ mose mbia jaje, Jesús je abe que bautizar ɨ ra. Jesús que ñee ñee nguia ngu je ra. Ibei que obo ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Espíritu Turã ngue nguichi Jesús rese ra. Nyurusɨ rã ño nguichi checua erese. Ibatenda que ñee ee ra. —Seriirĩ ño nde re. Sechesecua chõ nde re. Seyate nderese, ɨ que Ibatenda Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús treinta años mose que mbia mbaaquiatu quiatu ramo nda. —José riirĩ, ɨ ja que mbia Jesús je ra. Elí riirĩ nguia José re. ");
INSERT INTO srqNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí rei Matat ndiirĩ. Matat ndei Leví riirĩ. Leví rei Melqui riirĩ. Melqui rei Jana ndiirĩ. Jana ndei José riirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José rei Matatías riirĩ. Matatías rei Amós ndiirĩ. Amós ndei Nahum ndiirĩ. Nahum ndei Esli riirĩ. Esli rei Nagai riirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai rei Maat ndiirĩ. Maat ndei Matatías riirĩ. Matatías rei Semei ndiirĩ. Semei ndei José riirĩ. José rei Judá riirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá rei Joana ndiirĩ. Joana ndei Resa riirĩ. Resa rei Zorobabel riirĩ. Zorobabel rei Salatiel riirĩ. Salatiel rei Neri riirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri rei Melqui riirĩ. Melqui rei Adi riirĩ. Adi rei Cosam ndiirĩ. Cosam ndei Elmodam ndiirĩ. Elmodam ndei Er riirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er rei Josué riirĩ. Josué rei Eliezer riirĩ. Eliezer rei Jorim ndiirĩ. Jorim ndei Matat riirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat rei Leví riirĩ. Leví rei Simeón ndiirĩ. Simeón ndei Judá riirĩ. Judá rei José riirĩ. José rei Jonán ndiirĩ. Jonán ndei Eliaquim ndiirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim ndei Melea riirĩ. Melea rei Mainán ndiirĩ. Mainán ndei Matata riirĩ. Matata rei Natán ndiirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán ndei David riirĩ. David rei Isaí riirĩ. Isaí rei Obed riirĩ. Obed rei Booz riirĩ. Booz rei Salmón ndiirĩ. Salmón ndei Naasón ndiirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón ndei Aminadab riirĩ. Aminadab rei Aram ndiirĩ. Aram ndei Esrom ndiirĩ. Esrom ndei Fares riirĩ. Fares rei Judá riirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá rei Jacob riirĩ. Jacob rei Isaac riirĩ. Isaac rei Abraham ndiirĩ. Abraham ndei Taré riirĩ. Taré rei Nacor riirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor rei Serug riirĩ. Serug rei Ragau riirĩ. Ragau rei Peleg riirĩ. Peleg rei Heber riirĩ. Heber rei Sala riirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala rei Cainán ndiirĩ. Cainán ndei Arfaxad riirĩ. Arfaxad rei Sem ndiirĩ. Sem ndei Noé riirĩ. Noé rei Lamec ndiirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec ndei Matusalén ndiirĩ. Matusalén ndei Enoc ndiirĩ. Enoc ndei Jared riirĩ. Jared rei Mahalaleel riirĩ. Mahalaleel rei Cainán ndiirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán ndei Enós ndiirĩ. Enós ndei Set riirĩ. Set rei Adán ndiirĩ. Adán ndei Dios riirĩ. ");
INSERT INTO srqNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús que nyebi Ama Jordán sɨ ra. Espíritu Turã ngue siqui tuchɨ quia erese ra. Turúquiaa que Espíritu Turã Jesús rerao ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Huee que eriqui arete ra. Cuarenta días. Mbae mo ngue eu eã mbeɨ aque mose ra. Eriãcuãte que cote ra. —Tã tae rã Jesús je. Ma Jesús mbae ɨcuã naa, ɨ rei que diablo Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","—Nde Dios riirĩ mose, mbichae esaã co sɨta je no, ɨ rei que diablo Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús que ñee ee ra. —Tei. Eɨ̃ ngue embesa ji ñee nda: “Mbia chɨu achõ nda mbia mingo eã. Dios cheẽ nguia ra mbia mingo nguiã”, ɨ que embesa ji ra, ɨ que Jesús diablo je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aquere que diablo Jesús rerao ibi ibate mo nda. Ibate tuchɨ. Diablo que ibi teacuquia ja Jesús je ra. Ɨshonda abe reacuquia ja ee. Aque mose beɨ que ereacuquia ja ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Diablo que ñee Jesús je ra. —Sembae ja chõ ibi re. Se emondose mose emo je, amondo ra ee. Tamondo tuchɨ ndeje. Mbia ja rerecuarã nda aremɨɨ. Ndeɨco mose serese, tamondo ja ndeje. Serimbarã mose nde, tamondo ja ndeje no, ɨ rei que diablo ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús que ñee diablo je ra. —Quiatúae sesɨ ae, Satanás. ¿Mañɨ nda nderimba se re? “Dios ae rese chõ jẽɨngo”, ɨ que embesa ji ñee ndesẽ, ɨ que Jesús diablo je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aquere que diablo Jesús rerao Jerusalén nda. Querao que suruchuɨ ibate Dios chuchua arõ nda. Ibate tuchɨ echuchua. —Nde Dios riirĩ mose, eo oso íbii. Dios ra ndereaquiatu. Eremanoã nda oso ngoɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sã embesa ji riqui ñee no: Dios ra ángeles mondo ndereaquiatu sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Oje ra ndeisi. Nembuquichi mingue rae. Sɨta ra cua ɨã ndei je, ɨ que embesa ji ra, ɨ rei que diablo Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús que ñee diablo je ra. —Sã embesa ji ñee no: “‘Ma Dios sereaquiatu. Tã tae ee no’, jenyechɨ̃ nda Dios je”, ɨ ñɨ Dios cheẽ nde, ɨ que Jesús ñee diablo je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Diablo Jesús mbɨɨcuã aronea mose, secha chee que oso ra. —Emo mose jiri ra tã aebe ndeje jẽ, ɨ rei que uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús que oso nyebi Galiléaa cote ra. Espíritu Turã quirãcuã ngue siqui tuchɨ quia erese ra. Mbia hue jenda ja que jirandu ja tuchɨ quia erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Judíos chumunuásaa que Jesús riqui mbia mbaaquiatu quiatu ra. Mbia que ñee turã ja quia erɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús que ngasẽ Nazaret cote ra. Hue rei etiarõsa hue. Sábado mose que esɨ judíos chumunuásaa ra. Sábado mose beɨ que eriqui oso oso huee ra. Juã ngue embesa ji renei nonde mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mbia que Isaías chɨmbesa mondo Jesús oo ra. Isaías chɨmbesa que eequia cote ra. Ã embesa ji que esaã saã mbia je ra: ");
INSERT INTO srqNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu Turã ndiqui tuchɨ serese co. Dios que sererecúe ra. Echeẽ turã nenei nenei sacuã mbaecha reã je. Etarõi mbusẽ sacuã ño ngue Dios sererecúe ra. Eresayã ndesa ɨra sacuã ño ngue sererecúe no nda. Ae je ererecua ɨcuãte riqui nae, ũquɨ̃ mbusẽ sacuã ño ngue Dios sererecúe nguiã no. ");
INSERT INTO srqNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mbia je ñee ñee sacuã ngue Dios sererecúe no nda. “Namo ño Dios turã ndiqui nguiã”, ɨ sacuã mbia je, ɨ que Jesús embesa ji mbuchecua mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesús que embesa ji mumbi cote ra. Mondo que emo oo cote ra. Ngoi que cote ra. Mbia que mae mbeɨ quia erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesús que ñee mbia je ra. —Embesa ji que ambuchecua jẽje namo, aque ɨo quia jẽje a cote, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mbia que ñee turã ja quia Jesús rɨɨ̃ nda. —Jesús cheẽ turã tuchɨ quia eriqui re, ɨ ja tuchɨ que mbia nyuruɨra ra. —¿José riirĩ ño co re? ɨ que mbia quia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús que ñee mbia je ra. —“Mbia mae sayã ngue eresaã saã Capernaum nae, ũquɨ̃ mo esaã aa ndechuchúaa no”, jenye arõte seje sechuchúaa. ");
INSERT INTO srqNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tacheẽ nyecua rã jẽje. Dios cheẽ mbuchecuasa ɨshonda cheẽ nguia ra mbia isi turã mbeɨ quia. Nguecua jenda cheẽ nguia ra eisi turã eã. ");
INSERT INTO srqNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tacheẽ nyecua rã jẽje. Elías reco mose íbii, ama ngue nyaaquíã mbeɨ ra. Tres años ndobeɨ. Mbia riãcuã ja que aque mose ra. Eru cheecha tubɨrɨãte que chɨ rei hue Israel jenda ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","“Ũquɨ̃ eru cheecha mo je mbae echao turã”, ɨ ãte que Dios quia Elías je ra. “Sarepta jenda je quia mbae echao eru cheecha je”, ɨ quiatu que Dios ee ra. Judío eã je quiatu que Dios Elías mondo ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eliseo reco mose íbii, leprosos tubɨrɨãte que chɨ rei hue Israel jenda ra. Eliseo que hue jenda mo mbucheroã no nda. Ɨshonda mo nguiatu que embucherõ Siria jenda ra. Naamán, ɨ que ee ra, ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Judíos chumunuasa que Jesús riqui ñee mbia je ra. Mbia Jesús cheẽ andu mose que paama ɨ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mbia paama ɨ je que Jesús mombo sucha tubɨrɨã sɨ ra. Sɨta ibate que sucha tubɨrɨãte ra. Sɨta rimia mbucu que mbia Jesús rerao rei ra. Hue sɨ nda emombo nguiã ña. ");
INSERT INTO srqNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesús que oso chee mbia tubɨrɨã ite re sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús que oso Capernaum cote ra. Sucha tubɨrɨã mo. Galilea jenda. Sábado mose que mbia mbaaquiatu quiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ererecua rã ño ngue Jesús riqui mbia mbaaquiatu quiatu ra. Nyebe mbia riqui nguiã nyuruɨra tuchɨ echeẽ andu. ");
INSERT INTO srqNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Huee que ameɨ mo ndiqui mbia chumunuásaa ra. Aba checuayã ɨcuã nyɨreco rei ae. Aque que ñee asite Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Mbaerã erechu quia urerea co re, Jesús? Quiatúae urerecha ae. ¿Urerɨɨcharã ño erechu quia co re? Dios rucucha chõ nde re. Areɨcuate se, ɨ rei que aba checuayã ɨcuã Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús que ñee ee ra. —Equɨrɨrɨ chõ jẽ. Esẽ oso ameɨ ñɨangui sɨ, ɨ que Jesús ee ra. Jesús cheẽ mose que aba checuayã ameɨ mombo íbii ra. Mbia tubɨrɨãsaa. Usẽ ngue u ameɨ mbasiã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mbia turɨrɨã ngue nyuruɨra ja u erea ra. —Jesús quirãcuã ae ñee nguiã. Mbia rerecua rã ño eriqui nguiã ñee aba checuayã ɨcuã je. ¡Sã aba checuayã echeẽ mumbayã jẽ! ɨ tuchɨ que mbia nyuruɨra erea ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mbia que ñimbiirandu randu ja Jesús rese ra. Erurubinda jenda abe jirandu ja erese. ");
INSERT INTO srqNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús que usẽ mbia chumunuasa sɨ cote ra. Oso que ɨque Simón nyuchua cote ra. Ɨ que Simón nyari rasi u ee ra. Eracu tuchɨ que ee ra. —Embucherõ na, ɨ tuchɨ que mbia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús que oso nyibi earõ nda. Ñee ngue eracu je ra. —Etiba, ɨ que ee ra. Eracu que huɨ esɨ Jesús cheẽ nguire ra. Ari que juã cote ra. Mbae que echao chao mbia chɨurã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tenda ɨreɨ̃ mose que mbia nguesenda rasi rurucuaẽ cuaẽ ja Jesús je ra. Erasi chumumbara tuchɨ que ra. Jesús que o chono ñono ja erasi arõ embucherõ cherõ ja ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aba checuayã ɨcuã ngue usẽ usẽ nguia mbia sɨ Jesús cheẽ mose cote ra. —Nde rei Cristo Dios riirĩ, ɨ que usẽ usẽ mbia sɨ ra. —¡Jẽñee eã ño jẽ! ɨ tuchɨ que Jesús quia aba checuayã ɨcuã je ra. Ũquɨ̃ ngue Cristo ɨcua chõ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nyaashɨ̃ namo mose que Jesús sɨ turuquia a. ra. —Se ae taɨco mbɨrɨ̃ na, ɨ rei que ra. Mbia que nyoɨ eruɨ erea chee ra. —¡Eresochɨ̃ nda urerecha jẽ! Ure rese beɨ chõ eɨco, ɨ rei que mbia ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús que ñee ee ra. —Dios cheẽ tasenei senei pe quitinda je abe. Nyebe sembu nguiã, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jesús que mbia mbuchesea sea quia Galilea jenda ra. Dios cheẽ nenei nenei judíos chumunuásaa. ");
INSERT INTO srqNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Emo mose que Jesús riqui ama ndɨsha rimia ndese ra. Genesaret, ɨ que ama ndɨsha aque je ra. Mbia cuabẽ ngue ngaẽ ee huee ra. Dios cheẽ anduse rete que ra. Nyebe mbia tubɨrɨã Jesús mumbi ɨ ɨ tuchɨ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Canoa nyeremo abe que chɨ hue erimia ndese ra. Eoreã ja que ra. Echa que chɨ sɨra mbuasa ɨreɨ ɨreɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús que ua canoa nongue ye ra. Simón mbae que aque canoa nda. —Ama nimia ndecha jiri sererao mingo, ɨ que Jesús Simón je ra. Canoa ye que Jesús ñɨ erimia ndesenda mbaaquiatu quiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mbia mbaaquiatu jare que ñee Simón je ra. —Eriquiraasa rɨ̃ canoa jendao. Huee tarafa jemondo ii. Sɨra mbuasa jemondo ii, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón ngue ñee ee ra. —Nyaashɨ̃ nyee que ureɨco rei embuasa rerequia isa ra. Emo ngue uresiroã mbeɨ ra, Sererecua. Ma ndecheende tasaambe no, ɨ que Simón Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mbia que tarafa mondo ii cote ra. Sɨra tubɨrɨã mbua nonde. Tarafa soro serɨ̃ sɨra usi je. ");
INSERT INTO srqNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nyueru eru que canoa nongue yenda je ra. —Sɨra usite ure je. Jenyu rã. Nandembua ja rã canoa ye, ɨ que canoa nongue yenda je ñee nda. Canoa nyeremo puk ɨ ja sɨra je. Aete ñɨɨmɨ sɨra usi je. ");
INSERT INTO srqNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sɨra tubɨrɨãchɨ̃ sɨra eande nyii. Nyebe Simón Pedro nyuruɨra tuchɨ nguiã mae Jesús chɨmondo rese. Ngoi que ngũíã ndese ñee ee ra. —Seɨcuãte aɨco co, Sererecua. Serecha rei se ae, ɨ rei que Simón Pedro ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Echɨã nguia cuaãcuã ɨ tare nguiã. Eresenda abe chɨã cuaãcuã ɨ ja. Sɨra tubɨrɨã ndea. Sɨra mbua eande nyii. ");
INSERT INTO srqNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedeo riirĩ abe que chɨ ja Simón ndese huee ra. Jacobo, ɨ que enongue je ra. Juan, ɨ que enongue je no nda. Ũquɨ̃ chɨã abe que cuaãcuã ɨ ra. Jesús que ñee Simón je ra. —¡Eresiquichechɨ̃ nda jẽ! Sɨra rese ra ereɨcoã cote. Mbia ra ereru reru beɨ quia seje cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Canoa yenda ngasẽ mose ama nimíaa, umbae que esecha ja nyoɨ beɨ nonde Jesús rese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús que siqui tuchua mo nda. Hee que emo ndasi riqui ee ra. Leproso. Jesús rese mae mose que ngoi ngũíã ndese ee ra. Nyibi que ñee Jesús je ra. —Sererecua, nde sembucherõse mose, sembucherõ se, ɨ que leproso ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús que oco erese ra. —Echerõ cote, ɨ que ee ra. Echeẽ mosebe que nyerõ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús que ñee ee ra. —¡Erecheẽchɨ̃ nda mbia mo je jẽ! Eso nderasiã ndeacuquia sacerdote je cote. Moisés cheẽ nduɨ sɨ mbae mo emondo Dios je. Eɨ̃ nda mbia jirandu nderasiã ndese cote, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mbia que ñimbiirandu ɨ ɨ tuchɨ quia Jesús rese ra. Ngaẽ ngaẽ ja que equia echeẽ andu ra. Umbucherõ cherõ sacuã abe que eriqui ngaẽ ngaẽ erea ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesús que oso oso quia mbia tiámbaa ra. Ñee ñee Dios je. ");
INSERT INTO srqNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Emo mose que Jesús riqui mbia mbaaquiatu quiatu ra. Huee que fariseos mo nyɨ echeẽ andu andu ra. Embesasa abe que chɨ ra. Galilea jenda chõ ũquɨ̃ nde. Judea jenda abe no. Jerusalén jenda abe no. Huee que echɨ ja Jesús cheẽ andu ra. Dios quirãcuã ngue siqui tuchɨ Jesús rese ra. Erasi mbucherõ cherõ sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mbia que erasi mo curucuaẽ quisa ye ra. Emɨ sayã ngue ae ra. —Nandemingue serao Jesús je, ɨ rei que ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tuchua mbaranguiatuãte que ee ra. Mbia tubɨrɨã ngue tuchua mbiitãyã ee ra. Nyebe erasi ruruchoɨ nguiã suɨ tuchua arõ. Tei que endoro ra. Erasi que embuquichi ɨmbu quisa ye Jesús rɨmbe ra. Mbia ite rɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","—Ererucuaẽsa riqui seɨcua ũquɨ̃, ɨ que Jesús ñee uchɨangui re ra. Nyebe ñee nguiã emɨ sayã je. —Ndechɨsaã mbae ɨcuã ambutiã nguiã ndesɨ co, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Fariseos que ñee ñee nyue ra. Embesasa rese. —Jesús ñee ɨcuã ñochɨ̃ nguiã Dios rɨɨ̃ co. Dios ibatenda ae mbia chɨao ɨcuã mbutiã nguiã esɨ. Jesús aquiatuã ño ñene, ɨ rei que eu ñee ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús que ũquɨ̃ ndua ɨcuã ɨcuate ra. Nyebe ñee nguiã ee cote. —¿Mbaerã jẽɨngo ndua ɨcuã nde? ");
INSERT INTO srqNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ma mbaranguiatuã eã jiri jẽje re? ¿Mbia ɨcuã mbutiã ere? ¿Mbia rasi mbucherõ ere no? ¿Ma mbaranguiatuã eã jiri ũquɨ̃ jẽje re? ");
INSERT INTO srqNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Dios riirĩ ndei se. Mbia chɨao ɨcuã mbutiã aquiatu chõ se re. Sequirãcuã tateacuquia jẽje, ɨ que Jesús ñee ee ra. Ñee ngue erasi je cote ra. —Ehuã na. Ndechuchua eso cote. Ndequisa abe erao, ɨ que Jesús emɨ sayã je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jesús cheẽ ndurucha reã ngue emɨ sayã juã nda. Mbia que mae ja tuchɨ u erese ra. Uquisa abe que equerao ra. Eya tuchɨ que oso uchuchúaa ra. Ñee ñee turã ngue equia Dios rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mbia que nyuruɨra ja u mae emɨ sayã ngata rese ra. —Emɨ sayãte rei nyii. Ngata chõchɨ̃ cote, ɨ ja que mbia u mae nguiatu erese ra. Mbia ñee turã ja Dios rɨɨ̃ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Leví, ɨ que emo je ra. Ae que impuestos isi isi beɨ quia ererecua mbaerã nda. Jesús que ngasẽ ee emo mose ra. Huee que eñɨ ngoi plata isi isi ra. —Seruɨ beɨ eɨco, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ae Leví juã oso nguiã Jesús ruɨ. Mbae recha ja umbae. ");
INSERT INTO srqNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leví que fiesta saã tuchɨ Jesús je ra. Embuquiaru turã sacuã uchuchua. Impuestos isi isiquia ata que chɨ quiaru erese huee ra. Mbiamo abe que chɨ no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseos que ñee ɨcuãte Jesús chɨmbaaquiatu je ra. Embesasa rese ñee ɨcuã ee. —¿Mbaerã jẽɨngo quiaru impuestos isi isiquia rese re? Mbia ɨcuã ndese abe jẽɨngochɨ̃ nguiã quiaru, ɨ que ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús que ñee ee ra. —Sã mbia rasiã ndiqui aba mbucherõsa requia eãte no. Sã erasi chõ ndiqui erequia no. ");
INSERT INTO srqNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","“Jenyu seje”, aeã ngue u nguiã mbia turã je. Mbia ɨcuã je chõ ngue achu nguiã “jenyu seje” ɨ. “Jẽɨcuã sɨ jẽhuɨ”, ae chõ ngue u nguiã eɨcuã je, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mbia que ñee Jesús je ra. —Juanñɨmbaaquiatu huɨ huɨ uchɨu sɨ. Ñee nonde Dios je. Fariseos chɨmbaaquiatu abe huɨ huɨ uchɨu sɨ no. ¿Mbaerã ndechɨmbaaquiatu riqui huɨ ãte uchɨu sɨ re? ɨ que mbia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús que ñee ee ra. —Sã emo ngũinisirã isi ramo mose no. Sã eresenda iate riqui quiaru erese no. Sã huɨ aroneate uchɨu sɨ aque mose no. ");
INSERT INTO srqNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sã eru riqui mano emo mose no. Aque mose quia ra equiato huɨ uchɨu sɨ cote, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesús que ejemplo saã mbia je ra. —Sã emo ndiqui tiru yasu mɨɨ aroneate tiru ima sorei rese no. Ũquɨ̃ mose eɨcuãte cote. Eyasu ra quiata chõ esɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Sã emo eri rasi ramo nderecoquiatu eã eriru ima ye no. Mbae ɨre ima ye erecoquiatu aronea. Eri rasi ra ñimatã ño mbae ɨre ndoro. Eri ra uchẽ ja. Mbae ɨre abe mbɨɨcuãte ra cote. ");
INSERT INTO srqNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Eri yasu quia nda equerecoquiatu nguiã mbae ɨre yasu ye. Soroã sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Emo eri ima mbei mose, eyasu ra embei sereã cote. “Eima ño eturã nde”, ɨ chõ nguiã cote. Nyebe mbia riqui nguiã secheẽ yasu isi sereãte, ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sábado mo mose que Jesús sɨ quia mbiaco ite rɨ̃ nda. Uchɨmbaaquiatu rese. Echɨmbaaquiatu que quiata a ucua mɨɨ mɨɨ nyoɨ quia ecuã mose ra. Equiti quitire oo je que echoɨ quia eachãaña cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fariseos mo ngue ñee ee ra. —¿Mbaerã jẽɨngo mbae ɨshao shao sábado mose re? Co mose chõ mbia uquenea ucua resẽ, ɨ que fariseos ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús que ñee ee ra. —¿Embesa ji rese jemae eã David rɨɨ̃ nde? David riãcuãe que aque mose ra. Eresenda abe riãcuã ngue aque mose ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David que ɨque Dios chuchúaa ra. Mbichae Dios chuchua jenda que eu ra. Mee mee ngue nguesenda je ra. Eriãcuãte quia ñene. Sacerdote achõ mbaerã ndaque mbichae. ");
INSERT INTO srqNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sábado rerecua beɨ chõ se re, ɨ que Jesús ñee fariseos je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sábado nongue mose que Jesús sɨ judíos chumunuasa ra. Mbia que embaaquiatu quiatu huee ra. Huee que eo tomei mo ndiqui ee ra. Equiato cutinda tomei ngue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fariseos que mae nguiatu quia Jesús rese ra. Embesasa abe que mae nguiatu quia erese ra. —Mañɨ nda Jesús quia eo tomei je reae. Co sábado mose reae. Sã embucherõ jẽ. Nandecheẽ ɨcuã nda ee chã jẽ, ɨ que eu mae nguiatu Jesús rese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ũquɨ̃ ndua ɨcuã ngue Jesús ɨcua ra. Ñee ngue eo tomei je cote ra. —Ehuã na u mbia ite rɨ̃, ɨ que Jesús ee ra. Eo tomei ngue juã uã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús que ñee mbia je ra. —¿Mbae eturãte jẽje co tenda mose re? Sábado mose beɨ. ¿Coche mbae turã naa naa sábado mose re? ¿Coche mbae ɨcuã naa naa co mose re no? ¿Coche mbia mbucherõ co mose re no? ¿Coche mbia ɨquia co mose re no? ɨ que Jesús ñee mbia ja je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús que mae mbia ja rese cote ra. —Echomee secuti, ɨ que eo tomei je cote ra. Eo tomei ngue ñomee Jesús cheẽ mose ra. Aque mosechɨ que eo nyerõ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nyebe fariseos paama ɨ tuchɨ nguiã Jesús je. Sábado mose mbia mbucherõ mose. —¿Mañɨ nande ra Jesús je re? Nandeɨquia chõ nda reae, ɨ tuchɨ que eu ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jesús que oso mbia tiámbaa ra. Sɨta ibátee. Huee que eñɨ ñee mbeɨ Dios je nyaashɨ̃ nyee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nyaashɨ̃ mose que uchɨmbaaquiatu munua ja cote ra. Ũquɨ̃ doce mo ngue eirabo ra. —Sechɨmondo sacuã jẽ. Jaemondo ra secheẽ nenei nenei sacuã mbia je, ɨ que ũquɨ̃ doce je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ã mbia que eirabo ra: Simón (Pedro, ɨ abe que ee ra.) Andrés (Simón nongue rei ae.) Jacobo Juan Felipe Bartolomé ");
INSERT INTO srqNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo Tomás Jacobo (Alfeo riirĩ ndei ae.) Simón el Cananista ");
INSERT INTO srqNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas (Jacobo nongue rei ae.) Judas Iscariote (Aque que Jesús mondo mbia ɨcuã je ra.) Ũquɨ̃ ja que Jesús irabo ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús que nguichi u sɨta sɨ cote ra. Uchɨmbaaquiatu rese. Ibi túraã ngue ecuaẽ ngasẽ cote ra. Mbia tubɨrɨãte abe que chɨ huee ra. Judea jenda. Jerusalén jenda abe no. Tiro jenda abe no. Sidón jenda abe no. Ama nimia jenda rei ũquɨ̃. Ũquɨ̃ ngue ngaẽ nyiisaquia Jesús cheẽ ndese ra. Jesús embucherõ abe sacuã ngue ecuaẽ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ae rese aba checuayã ɨcuã ndiqui nae, ũquɨ̃ abe que Jesús mbucherõ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesús quirãcuã ngue mbia mbucherõ ja quia ra. Nyebe mbia riqui nguiã ocose ja Jesús rese. ");
INSERT INTO srqNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús que mae uchɨmbaaquiatu rese ñee nonde ee ra. —Jeyate riqui ã. Jẽ mbaecha reã ndaque. Dios quiatu ra jenderecuarã tuchɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Jẽyate riqui ã. Jeniãcuã ndaque. Jendio rete ra cote. Jẽyate riqui ã. Jenyeseo seo raque. Jẽɨquia ɨquia ra emo mose cote. ");
INSERT INTO srqNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mbia jemo ucuãyã mose, jemo mombo mose, ñee ɨcuã mose jẽje serɨɨ̃, jẽyate jẽɨngo ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jeñimbia tuchɨ chõ aque mose. Mbia ɨcuã mose jẽje. Dios quia ra mbae turã mondo jẽje ibate. Mbia ɨcuande jẽje nyii. Eɨ̃ sɨ que mbia ɨcuã nguia Dios rimba ñiinda je no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aba mbia eã tuchɨchɨ̃ jẽ, Mbaecha. Mbae ɨcuã nda tu jẽje. Jẽyare nyii. ");
INSERT INTO srqNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Aba mbia eã tuchɨchɨ̃ jẽ, quiaru tuchɨ je. Jeniãcuã tuchɨ ra cote. Aba mbia eã tuchɨchɨ̃ jẽ, ɨquia ɨquia je. Jenyeseo ra cote. ");
INSERT INTO srqNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Aba mbia eã tuchɨchɨ̃ jẽ mbia ñee turã mbeɨ mose jenɨɨ. Eɨ̃ sɨ rei que equia ñee turã turã dios abareã nimba je cose ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Aɨco ñee jẽje a. Ae eɨcuãte riqui jẽje, ũquɨ̃ ndese jenyesecua chõ. Jẽɨngo turã ño nguia jẽucuãyãsa je. ");
INSERT INTO srqNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Emo ñee ɨcuã mose jeje, jeñee turã ño ee. Jeñee turã ño Dios je erɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Emo ucua mose jenditii rese, “tasaã se abe”, jenyechɨ̃ ndae. Jenditii rɨbɨsho abe jẽteacuquia ee. Emo jẽɨrao rirõ mose jẽsɨ, jẽɨrao nongue abe rese jengueteã eã ño ee. ");
INSERT INTO srqNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Emo ache ache ɨ mose jẽje, jemondo chõ ee. Emo jembae reraochõ mose, “emondobe seje”, jenyechɨ̃ nda ee. ");
INSERT INTO srqNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sã jẽyate riqui mbia siqui turã mose jẽje no. Eɨ̃ jenye sɨ chõ nguia siqui turã mbia je no. ");
INSERT INTO srqNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ae eɨcuãte riqui jẽje nae, ũquɨ̃ ndese jenyesecua chõ. Ae nyesecua quia jendese nae, ũquɨ̃ mɨɨ ndese jenyesecua mose, eɨcuãte ũquɨ̃. Mbia ja rese quiatu jenyesecua. ");
INSERT INTO srqNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jẽɨngo turã nguiatu quia mbia ja rese. Ae eturã ndiqui jẽje, ũquɨ̃ mɨɨ ndese jẽɨngo turã mose, eɨcuãte ũquɨ̃. Jesús quiatoã abe chee siqui turã uquiato je. ");
INSERT INTO srqNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Emo prestar ɨ mose jembae je, jemondo chõ ee. Ae mbae mondo aroneate erɨbɨshorõ nae, jemondo beɨ chõ ee. “Cobrar tae ee”, jenyechɨ̃ ndae. Jesús quiatoã abe chee mbae mondo erɨbɨshorõsa je. “Mbae mo nda emondobe seje”, ɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Eɨ̃ jenyechɨ̃ nda jẽ abe. “Mbae mo nda emondobe seje chã” ¡jenyechɨ̃ nda jẽ abe jẽ! Jemondochõ ño ee. Ae eɨcuãte riqui jẽje, ũquɨ̃ ndese jenyesecua chõ. Ũquɨ̃ mose ra Dios mbae mee tuchɨ jẽje. Dios rã tuchɨ ra jẽ cote. Dios ia eãte quia eriqui nguiã eɨcuã ndese. Dios turãte quia eɨcuã je re. Eɨcuã ñee turã eã ndaque ee. ");
INSERT INTO srqNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jẽyayã ño mbia rese. Sã Dios abe eya eãte nanderese no. ");
INSERT INTO srqNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Co que eɨcuãte ra”, jenyechɨ̃ nda emo nɨɨ. “Jẽɨcuãte”, ɨã nda Dios jẽje chã. ¡Condenar jenyechɨ̃ nda emo je jẽ! Dios nda condenar ɨã jẽje chã. Emo ɨcuã mose jẽje, jẽtesareɨ chõ eɨcuã sɨ. Dios nda tesareɨ jẽɨcuã sɨ no ña. ");
INSERT INTO srqNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mbae jemee mee ño mbia je. Dios quia ra mbae mee tuchɨ jẽje cote. Mee turã nda jẽje. Eñetẽ nda emee eã jẽje. Embisẽ ño nda emee jẽje. Jẽ embisẽ mee mose emo je, Dios ra embisẽ mee jẽje no, ɨ que Jesús mbia mbaaquiatu quiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús que ejemplo saã mbia je ra. —Sã eresayã ja nyɨruchoɨ aronea no. Ngoɨ ja chõ nda echoɨ ibicua rie. ");
INSERT INTO srqNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Embaaquiatusa quiarei earacua tuchɨ uchɨmbaaquiatu sɨ. Embaaquiatu ja ji mose, earacua tuchɨ cote. Umbaaquiatusa rã sɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Mbaerã nda “eɨcuã” jenye emo je re? Jẽ jẽɨcuã tuchɨ mose esɨ. “Mbae ñetẽ ndiqui nderésaa aque”, jenyechɨ̃ nda emo je. Mbae cuasu siqui mose jendésaa jẽ quiatu. ");
INSERT INTO srqNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","“Mbae turã ndese chõ jẽɨngo”, jenyechɨ̃ nda jẽɨngo ɨcuã mose jẽ. Jẽturã nda jẽsaã ñooñochɨ̃ jẽ. “Mbae ñetẽ tasirõ nderesa sɨ”, jenyechɨ̃ nda mbae cuasu siqui mose jendésaa jẽ. Jẽ nane nguia jẽturã ndiqui. Aquere quiatu jeñee emo mingo turã cote. ");
INSERT INTO srqNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ira turã mose, ea abe turã ndae. Ira ɨcuã mose, ea abe ɨcuã ño nda eno. ");
INSERT INTO srqNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sã ira ae ea ae ae no. Higo a rã eã nda nyu a no. Ea ae eno nde. Uva a rã eã nda isio rashɨ̃ a no. Ea ae eno nde. ");
INSERT INTO srqNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Eɨ̃ sɨ chõ mbia no nde. Mbia turã nda ñee turã. Echɨangui renda quia eturãte re. Nyebe eriqui nguiã ñee turã. Mbia ɨcuã nda ñee ɨcuã no. Echɨangui renda quia eɨcuãte riqui nguiã. Nyebe eriqui nguiã ñee ɨcuã. Nandechuru achõ ñee eã nguiã. Nandechɨangui renda quia ñee nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Sererecua” jenye chõchɨ̃ seje secheẽ mumba mumbare. ");
INSERT INTO srqNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ae siqui serese secheẽ mumbayã nae, eturã tuchɨ chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Sã emo uchuchuarã ao no. Sã ibi rɨbɨcoɨ tuchɨ no. Sɨta je ngasẽ nyee. Sɨta arõ tuchua ao cote. Nyebe echuchua ãtãte riqui nguiã. Ama ndicuasu mose, iãcuã irãtã ndaque echuchua ite rɨ̃. Tuchua mbuquiata aroneate iãcuã irãtãte raque. Sɨta arõ nguia ngue uchuchua ao nguiã. Eɨ̃ sɨ chõ secheẽ mumbasa reã nde. Tuchua ãtã aosa rã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sã emo uchuchuarã ao no. Aque quiarei ibi rɨbɨcoɨ tuchɨã. Ibi arõchɨ chõ uchuchua ao nguiã. Iãcuã ngasẽ mose aque chuchua, mbucoɨ asi que mondo ra. Eɨ̃ sɨ chõ secheẽ mumbasa re. Ae uchuchua saã ibi arõchɨ nae, aque rã sɨ chõ ñene, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús cheẽ ngue tiba mbia je cote ra. Oso que Capernaum cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Soldados rerecua mo ngue siqui hue ra. Capitán ngue ae ra. Roma jenda que ae ra. Aque rimba rasi que chɨ hue erese ra. Ebite que erimba ra. Erimba rasi tuchɨ. Mano serɨ̃te que equia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Capitán ngue jirandu Jesús rese cote ra. Ñee ngue judíos ramei je ra. —“‘Echu serimba mbucherõ’, ɨ que capitán ñee ndeje ra”, jenye oso Jesús je, ɨ que capitán nda. ");
INSERT INTO srqNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Judíos ramei ngue ngasẽ Jesús je ra. —Capitán nimba embucherõ na oso ee. Capitán turãte quiatu ngue eriqui nguiã ure je. ");
INSERT INTO srqNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nandequiato turã tuchɨ que aque ra. Judíos quiato ja. Urechumunua nua sacuã ngue ae chao tuchua ra, ɨ que ameɨ ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús que oso ameɨ ndese ra. Capitán nyuchua rurubi mose que capitán uquiato mo mondo Jesús robeɨshɨ̃ nda. —Seɨcuãte se, Jesús. Sechuchua ra ereɨquechɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nyebe se asoã nguiã nderea. Ndecheẽ achõ je chõ nda serimba erembucherõ. ");
INSERT INTO srqNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Se abe sererecua no nde. Se echeẽ amumba aroneate. Soldados rerecua se no nde. Secheẽ abe emumbayã nguiã no. Eso, ɨ mose, secheẽ mumbayã no. Echu, ɨ mose, secheẽ mumbayã no. Se ñee mose serimba je, secheẽ mumbayãte no. Ndequirãcuã na eãte raque se, ɨ que capitán ucheẽ mondo Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Echeẽ andu mose que Jesús nyuruɨrate ra. Uba que ñee nguesenda je ra. —Tacheẽ nyecua jẽje. Capitán seɨcua tuchɨte quia co. Israel jenda mo embuchecha aroneate quia co, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Capitán nyɨmondo que nyebi nyoɨ uchuchúaa cote ra. Erimba mbucherõ ji que ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Isamamɨ ngue Jesús choɨ quia Naín cote ra. Echɨmbaaquiatu abe que nyoɨ quia erese ra. Mbia tubɨrɨãte que nyoɨ quia erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sucha ata rurubi mose que ngasẽ mbia tubɨriã je ra. Ɨ que eraaque ruruchoɨ quia etã sacuã nda. Aque mɨɨ tuchɨ rei ngue cuña ndiirĩ mo nde. Eru cheecha riirĩ. Aque que mano ño ee ra. Hue jenda mbia que nyoɨ jate quia esi rese ra. Eraaque ruɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesús que mae esi nyeseo rese ra. Jesús ia eãte que erese ra. —¡Echeseo eã ño jẽ! ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesús que oco eraaque rese ra. Eruruchoɨsa que tiba ee cote ra. —Echuruã, Acuanɨndu, ɨ que ñee eraaque je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Eraaque que nyuruã ñee cote ra. Jesús que embuquera ji mondo esi je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mbia que nyuruɨra ja erea ra. Ñee turã ja Dios rɨɨ̃. —Dios chɨmondo chõ co re, ɨ que mbia quia ñee Jesús rɨɨ̃ nda. —Dios riqui tesareɨã nande sɨ co, ɨ que mbia quia nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jesús chumbucherõ ndese que mbia riqui ñimbiirandu jate ra. Judea jenda jirandu ja erese. Erobeinda ja abe que jirandu erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan abe que jirandu Jesús chɨao rese ra. Erimba quiatu ngue embiirandu nguiã erese. ");
INSERT INTO srqNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nyebe Juan ñee nguiã ngũimba nyeremo je. —Nyeremo jẽso ñee Jesús je. “‘Cristo ra tu’, ɨ beɨ equia nae, ¿ae chõ nde re?” jenye oso ee. “¿Cristo ra uresaarõ arõ sɨ quia re?” jenye oso Jesús je, ɨ que Juan ngũimba mondochoɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Juan ñimondo que nyoɨ ngasẽ Jesús je ra. —Juan el Bautista que urembu ñee ndeje ra. ¿Cristo chõ nde re? ¿Cristo ra uresaarõ arõ sɨ quia re no? ¿Ae chõ nde re? ɨ que Juan nimba ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Juan nimba ngasẽte mose que Jesús riqui mbia rasi mbucherõ cherõ nda. Erasi chumumbara. Erasi cuabẽ. Aba checuayã ɨcuã abe que embusẽ mbusẽ nguia mbia sɨ ra. Eresayã abe que embu cherõ nyerõ nguia ra. Juan nimba que mae ja quia ũquɨ̃ mbucherõ ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesús que ñee Juan nimba je ra. —Ae rese jemae nae, ũquɨ̃ jẽsenei oso Juan je. Ae jeñandu nae, ũquɨ̃abe no. “Jesús que eresayã mbucherõ nyerõ nguia ra. Ecuatayã abe mbucuata cuata. Eɨre ndasi abe mbucherõ nyerõ. Eisayã abe mbucherõ nyerõ. Eraaque abe mbuquera. Ucheẽ turã esenei senei tuchɨ mbaecha reã je”, jenye oso Juan mbiirandu. ");
INSERT INTO srqNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Emo huɨ jeɨ eã mose sesɨ, aque iate ra siqui cote, ɨ que Jesús ucheẽ mondo Juan je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan ñimondo que nyoɨ nyebi ee cote ra. Jesús que ñee mbia ja je Juan nɨɨ cote ra. —¿Mbae rese mae jẽso turúquiaa re? ¿Quɨrɨrɨã idioi ɨchu ɨchu rese jẽso mae nde? ");
INSERT INTO srqNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Mbae rese mae jẽso re? ¿Emo ɨrao turã ndese jẽso mae nde? Tei. Eɨrao turã siquíã nguiã turuquia ñɨ. Ae siqui quia mbia rerecua chuchua nae, ũquɨ̃ ño eɨrao turã ndiqui nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Juan ndese mae ño ngue jẽso turúquiaa resẽ. Dios cheẽ nenei neneisa tuchɨ chõ ae emo sɨ re. Ae chõ mbia mingoquiatu quiatu nguiã se ñee sacuã ee aque. ");
INSERT INTO srqNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sã embesa ji riqui ñee no: Secheẽ nderaosa tamondo nderẽta. Ae ra mbia mingoquiatu ndeje, ɨ que embesa ji ñee nda. Juan nɨɨ ño embesa ji ñee nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Juan el Bautista quiarei ɨ tuchɨ raque mbia ñiinda ja sɨ. Dios cheẽ nenei neneisa ataque sɨ. Ae ra siqui tuchɨ Dios rese erimbarã cote nae, ũquɨ̃ nguia ra ɨ tuchɨ Juan sɨ cote, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mbia que Jesús cheẽ ñandu turã ja ra. Impuestos isi isiquia abe chee que echeẽ ñandu turã nda. —Dios turã tuchɨ, ɨ ja que mbia ra. Juan ngue bautizar ɨ ja ee nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseos achõ ño ngue Jesús cheẽ isi sereã nda. Embesasa rese. Ũquɨ̃ ngue siqui sereãte Dios cheẽ ndese ra. Nyebe Juan bautizar ɨ eã nguiã ee. ");
INSERT INTO srqNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús que ñeembe ee ra. —Mbia namonda siqui turã eãte quia aba cheẽ nduɨ ã. Mbia riirĩ na ño eriqui nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sã mbia riirĩ ndiqui ñumbusareɨ sareɨ no. Sã eriqui ñee ñee nyue no. “Flauta que asaã saã ndei jẽje ra. ¿Mbaerã jenyuruqui sereã nea nde?” sã ɨ chõ nyue no. “Mbae aba mbia eã ngue asaã ndei jẽje resẽ. ¿Mbaerã jẽyate erese re?” sã ɨ chõ mbia riirĩ nyue no. Ũquɨ̃ na sɨ chõ jẽɨngo nguiã aba cheẽ mumba ã. ");
INSERT INTO srqNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan el Bautista que tu rei jẽje ra. Jẽisi turã eã ngue ra. “Co eriqui quiaru sereãte nanderese co. Co eriqui mbae mbei sereãte nanderese co”, jenye chõchɨ̃ ee. “Aba checuayã ndesenda”, jenye chõ ngue ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Se abe que achu rei jẽje ra. Aquiaru rei quia jendese co. Mbae abe ambei rei quia jendese co. Se abe que jẽ seisi turãyã nda. “Quiaru tuchɨ je”, jenye chõchɨ̃ seje. “Mbae mbeisa”, jenye chõ ngue seje no nda. “Mbia ɨcuã quiato chõ ñene”, jenye que seje resẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ae earacuate nae, Dios aracua abe ra eɨcua, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","—Nandequiaru sechuchua, ɨ que fariseo mo ñee Jesús je ra. Jesús que oso erese ra. Ngoi que quiaru nonde ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Cuña ɨcuã mo ngue siqui hue jenda huee ra. Jirandu que Jesús rese ra. Oso que erea cote ra. Aba mbushɨmbusa que equerao erea ra. (Sɨta ao ji rei aba mbushɨmbusa riru.) ");
INSERT INTO srqNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesús quite quiti que eñɨ nyeseo ra. Nguesari je que Jesús i ɨreɨ ɨreɨ ra. Ua je que embɨɨru ɨru cote ra. Uchuru que embucha Jesús i rese eriite ra. Aba mbushɨmbusa que eicherẽ ei rese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jesús mbuquiarusa que ñee nguia uchɨangui re ra. —¿Mbaerã Jesús ñee asiã cuña ɨcuã je re? Jesús Dios riirĩ mose, ɨ̃ nda ñee asi rei ee, ɨ que fariseo uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús que ñee fariseo je ra. —Tacheẽ ndeje, Simón, ɨ que ee ra. —Eno. Echeẽ seje no, Sererecua, ɨ que fariseo ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús que ñee ee ra. —Sã mbia nyeremo deber ɨ ererecua mo je no. Sã enongue deber ɨ ee quinientos no. Sã enongue deber ɨ ee cincuenta no. ");
INSERT INTO srqNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ũquɨ̃ ja que pagar ɨ aronea ja. Nyebe ererecua ñee nguiã ee. “Mbae jemondo eã ño seje”, sã ɨ chõ ererecua ee no. ¿Aba eya tuchɨ nguerecua rese re? ɨ que Jesús ñee Simón je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón ngue ñee ee ra. —Ae deber ɨ tuchɨ ee nae, aque eya tuchɨ erese cote reae, ɨ que Simón ee ra. —Ae beɨ, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús que mae cuña ndese ñee Simón je ra. —Ndechuchúaa seɨque mose que sei ereɨreɨ eã nda. Co cuña nguiatu que sei ɨreɨ nguesari je ra. Ua je que sei mbɨɨru ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nde quiatu que seritii eresiite eã ndesẽ. Cuña nguiatu que sei siite nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nde que aba mbushɨmbusa ereichereã sea rese resẽ. Cuña nguiatu ngue aba mbushɨmbusa icherẽ nguiã sei rese. ");
INSERT INTO srqNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tacheẽ nyecua ndeje, Simón. Cuña ɨcuã tuchɨ raque. Eɨcuã ngue ambutiã ee namo nda. Nyebe eriqui nguiã nyesecua tuchɨ serese a. Ae “seɨcuã eã jiri se”, ɨ quia nae, ũquɨ̃ nguia ra nyesecua eã jiri serese. Se eɨcuã ambutiã ndaque, ɨ que Jesús Simón je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","—Ndeɨcuã ngue ambutiã ndesɨ ra, ɨ que Jesús ñee cuña je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ae que chɨ quiaru erese nae, ũquɨ̃ ngue ñee nyecuayã cuayã u nyue ra. —¿Mañɨ nda Jesús mbia ɨcuã mbutiã esɨ re? ɨ que eu ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús que ñee cuña je ra. —Seɨcuasa chõ nde re. Nyebe arerirõ nguiã ndeɨcuã sɨ. Ereɨco beɨ ra cote. Ndeya eso cote, ɨ que Jesús cuña je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jesús que sucha tubɨrɨã mbuchesea sea quia ra. Dios cheẽ turã ngue esenei senei nguia mbia je ra. Echɨmbaaquiatu doce abe que ngata quia erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Cuña echɨmbucherõ mo abe que ngata quia erese ra. Ae sɨ aba checuayã ɨcuã ndirõ nyii, ũquɨ̃ mo abe que ngata quia erese ra. María Magdalena que ngata quia erese ra. Ae sɨ aba checuayã siete rirõ nyii nae. ");
INSERT INTO srqNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana abe que ngata quia erese ra. Chuza ninisi que aque ra. Herodes resenda rei Chuza. Susana abe que ngata quia erese ra. Cuña ata que ngata quia erese ra. Ũquɨ̃ ngue umbae mee mee mbeɨ quia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mbia que ngaẽ ngaẽ ja quia Jesús rea ra. Suchamo jenda abe. Mbia ñumunua ja mose que Jesús ejemplo raã ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Sã emo sɨ mbae eɨ̃ mombiquia mbiquia no. Emombiquia mbiquia mose sã emo uqui uqui ñeenda ruɨ no. Sã mbia riqui irõ irõ erese no. Sã nguɨreɨ̃ abe eu chee no. ");
INSERT INTO srqNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sã emo uqui uqui sɨta arõ no. Sɨta aronda suri raque. Ibi irute quia ee re. Nyebe ñɨmama nguiã mano. ");
INSERT INTO srqNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sã emo ndiqui uqui uqui nyu réndaa no. Sã nyu abe suri erese no. Nyu ruri que echati asi u eriquisã nda. ");
INSERT INTO srqNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Sã emo uqui uqui ibi túraã no. Ũquɨ̃ nguiatu que ɨa turã nda, ɨ que Jesús mbia je ra. Aquere que ñee asite mbia je ra. —Jẽisa mose ¡secheẽ jeñandu turã na! ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","—Eresenei ngue mbae eɨ̃ nɨɨ, ũquɨ̃ embiasa turã na ure je, ɨ que echɨmbaaquiatu ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús que ñee ee ra. —Mbia rerecua tuchɨ quiarei Dios. Ae riqui nguiã ucheẽ mbiasa asa ja jẽje co. Mbia ataque quia siqui sereã erese co. Mbia ataque je quia eriqui nguiã ucheẽ mbiasa eã jiri. Ejemplos achõ esenei senei nguiã ee co. Eanduchõ sacuã. Eɨcua turã ndocoɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Secheẽ tambiasa jẽje cote. Dios cheẽ na sɨ chõ mbae eɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ae uqui uqui ñeenda ruɨ nae, ũquɨ̃ ndei mbia Dios cheẽ andu chooñosa rã ũquɨ̃. Ae Dios cheẽ andu chooño nae, ũquɨ̃ ñɨangui sɨ chõ diablo riqui nguiã Dios cheẽ ndirõ. Nyebe eriqui nguiã Dios ɨcuayã mbeɨ. Nyebe Dios riqui nguiã emingo beɨ eã. ");
INSERT INTO srqNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ae uqui uqui sɨta arõ nae, mbia mo na ño ũquɨ̃ no nde. Dios cheẽ andu mose, isi turã ndaque. Eyate raque erese. Mbae mo embiayã mose, huɨ jeɨ chõ esɨ cote. Mbae rao eã naanguia chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ae uqui uqui nyu réndaa nae, mbia mo na ño ũquɨ̃ no nde. Dios cheẽ andu turã ndaque. Siqui beɨ eã ño nguiã erese. Umbaerã achõ ndese chõ eriquichɨ̃ nguiã ndua. Ñimbusareɨ sareɨ beɨ chõchɨ̃ nguiã. Nyebe huɨ chõ nguiã Dios cheẽ sɨ. Nyebe Dios cheẽ ndiqui nguiã ɨa eã mbeɨ ee. ");
INSERT INTO srqNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ae uqui uqui ibi túraã nae, mbia mo na ño ũquɨ̃ no nde. Echɨã quishĩ ño ũquɨ̃ nde. Dios cheẽ andu mose, siqui beɨ erese. Ɨa ɨa beɨ raanguia cote. ");
INSERT INTO srqNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Sã nandeɨco lamparina mendi no. Sã nandeɨco eati eã no. Sã nandeɨco emɨɨ eã mbaequi re no. Erendi checua chõ nda nandemɨɨ nguiã. Mbia resae ja sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mbae checuayã nda nyecua ja emo mose. Ñemɨnde ra nyecua ja. ");
INSERT INTO srqNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Secheẽ jeñandu tuchɨ. Aba mo umbae rerequia mose, Dios ra emo mondobe ee. Emo embae eã mose, Dios ra embae sirõ ja esɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesusi que ngaẽ ndei ee ra. Jesús nongue ja rese. Mbia tubɨrɨãte que esiquisãte esɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","—Hue ndesi riqui nderequia taicuee hue. Ndenongue rese, ɨ que mbia Jesús mbiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús que ñee mbia je ra. —Ae Dios cheẽ andu turã nae, ae Dios cheẽ mumbayã nguia nae, ũquɨ̃ je chõ aɨco nguiã “senongue” ɨ. Ũquɨ̃ je chõ aɨco nguiã “taĩ” ɨ no, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Emo mose que Jesús ua canoa ye ra. Uchɨmbaaquiatu ja rese. —Nyao ama ndɨsha robeɨ, ɨ que Jesús ee ra. Nyoɨ que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ama ndɨsha rasa mose que Jesús sɨ quia uque ra. Ama ndiite re mose que quɨrɨrɨã ɨcuã ɨcuã ndu ee ra. I rebera que ɨque ɨque tuchɨ quia canoa ye ra. Nyebe canoa ñɨɨmɨ serɨ̃ tuchɨ nguiã ee. ");
INSERT INTO srqNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nyebe mbia Jesús mumba nguiã. —Urembaaquiatusa, echumumba. Nandemanochɨ̃ nda re, ɨ que ñee Jesús je ra. Jesús que nyuruã cote ra. Ñee quɨrɨrɨã je. Ama mbutiba. Quɨrɨrɨã ngue ti ɨ ee cote ra. Ama abe que ti ɨ no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","—¿Mbaerã jẽɨngo siquichete re? ¿Seɨcuayãte equia re? ɨ que Jesús uchɨmbaaquiatu je ra. Siquiche beɨ que equia ra. Nyuruɨra tuchɨ Jesús quirãcuã ndese mae. —Quɨrɨrɨã Jesús cheẽ mumbayã ñochɨ̃. Ama abe echeẽ mumbayã ñochɨ̃, ɨ que ñee ñee nyue cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ngasẽ nyee que sobeɨ ra. Gadara, ɨ que hue ibi je ra. Galilea mbuchecha tuchɨ que huee ra. Ama ndɨsha rasa. ");
INSERT INTO srqNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Canoa sɨ Jesús nguichi mose, hue jenda ameɨ mo ngue tu ee ra. Aba checuayã ɨcuã ngue siqui quia echɨangui re ra. Cosete ngue eriqui rei nguiã echɨangui re. Eɨrao eã mbeɨ que eriqui ra. Tuchuaqui re que eriqui uqueã nda. Mbia raaque tãsa beɨ chõ eriqui nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tu que ngoi ngũíã ndese Jesús resa quiti ra. Ñee asite que eu ee ra. —¿Mañɨ ere ra seje re, Jesús? Dios ibatenda riirĩ ño nde re. ¡Sembasichɨ̃ nda se jẽ! ɨ que ñee tuchɨ Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","—Esẽ esɨ, ɨ chõ Jesús aba checuayã ɨcuã je reaẽ. Aba checuayã ño aque ameɨ isi isi beɨ quia embɨɨcuã ɨcuã neaẽ. Mbia eo cuaacua raque quia cadenas je. Ei abe cuaacua raque no. Ucuasa ndoso ndosochõ mbeɨ que equia ra. Aba checuayã ño equerao rao quia turuquia ñɨ neaẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","—¿Mañɨ ndeje re? ɨ que Jesús ñee ee ra. —Etubɨrɨã, ɨ que seje ra. Ure cuabẽte quia ure re, ɨ que aba checuayã ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","—Uremondochɨ̃ nda tata cuasu, ɨ que aba checuayã ñee tuchɨ Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chɨasu socoɨ tubɨrɨã ngue chɨ quiaru huee ra. Sɨta ibate rese. Nyebe aba checuayã ñee Jesús je. —Chɨasu chɨangui re ureso rã, ɨ tuchɨ que equia ñee Jesús je ra. —Eno, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aba checuayã ɨcuã ngue usẽ ja ameɨ ñɨa sɨ cote ra. Chɨasu chɨangui re que echoɨ ra. Chɨasu que uchã ja choɨ nyiichere ama nimia mbucu rɨ̃ nda. Ama ndɨsha ye que echoɨ ja mano nda. ");
INSERT INTO srqNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chɨasu raarõsa que chɨ mae erese ra. Emundite que ra. Nyoɨ que uchã mbia mbiirandu ja chɨasu rese ra. Sucha tubɨrɨã jenda mbiirandu. Mbia ataque abe mbiirandu no. ");
INSERT INTO srqNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mbia que ngaẽ ja mae erese ra. Huee que Jesús riqui beɨte ra. Ae rese aba checuayã ndiqui nyii ameɨ nae, aque abe que chɨ̃ ngoi Jesús i jii ra. Huɨɨrao resebe cote. Earacuate que mbia je cote ra. Nyebe mbia nyuruɨra tuchɨ nguiã erea. ");
INSERT INTO srqNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","—Jesús que ameɨ mbucherõ aba checuayã ndirõ esɨ ra, ɨ que maesa erese ñee mbia ataque je ra. Maesa erese que esenei ja mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mbia hue jenda que siquiche ja Jesús sɨ cote ra. —Eso rã urerecha urerecua sɨ, ɨ ja que hue jenda ñee Jesús je ra. Nyebe Jesús ua nguiã canoa ye. Oso que nyebi sobeɨ cote ra. Gadara recha. ");
INSERT INTO srqNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ae rese aba checuayã ndiqui nyii nae, aque que ñee Jesús je ra. —Nderese taso beɨ, Jesús, ɨ rei que ee ra. Jesús que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Eso chõ ndechuchúaa. Mbae esenei ja nderesenda je. “Dios que sembucherõ nda”, ere oso mbae renei nenei ja nderesenda je, ɨ que Jesús ee ra. Umbucherõsa renei nenei ngue oso mbia ja je cote ra. Jesús renei nenei ja sucha jenda ja je. ");
INSERT INTO srqNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús chebi sɨ mose sobeɨ sɨ, mbia que chɨ eraarõ arõ nda. Ũquɨ̃ nguiatu que eisi turãte ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Emo ngue tu ñee Jesús je ra. Jairo, ɨ que ee ra. Judio munua nuasa que ae ra. Jesús i jii que ngoi ñee ee ra. —Nyao rã sechuchúaa. ");
INSERT INTO srqNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Seriirĩ nguasu jiri sɨ quia mano serɨ̃te seje quɨ. Seriirĩ mɨɨ tuchɨ se, ɨ tuchɨ que Jesús je ra. Jesús que oso erese ra. Mbia cuabẽ ngue nyoɨ ja eruɨ ra. Jesús mbiitãyãte que echoɨ quia ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ari mo abe que oso quia mbia ite rɨ̃ nda. Eruqui nda uchẽ uñe mbeɨ quia ee ra. Doce años nyee nda eruqui tibayã mbeɨ ee ra. Aba mbucherõsa abe nda embucherõ aroneate quia ee ra. Ari umbae mondo mondo ja raque quia ee. ");
INSERT INTO srqNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ari que tu Jesús quite quiti erɨɨchã nda. Eɨrao ai rese que oco ra. Aque mose tuchɨ que eruqui tiba ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","—¿Aba oco serese re? ɨ que Jesús mbi je cote ra. —Tei. Aba ãte, ɨ ja rei que mbia ee ra. Pedro que ñee ee ra. —Mbia tubɨrɨãte nyeresẽ. Mbia cuaẽ nguia ñimaña maña jate co resẽ. ¿Mbaerã ereɨco “¿aba oco serese re?” ɨ re? ɨ que echɨmbaaquiatu ñee ja ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús que ñee ee ra. —Tei. Emo ngue oco serese ra. Sequirãcuã ngue emo mbucherõ nda ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","—Jesús jiranduchɨ̃ serese, ɨ que ari uchɨangui re cote ra. Nyebe ngoi nguiã ngũíã ndese Jesús resa quiti. Titi titi ɨ ete que ra. Ñee nyecua que ee ra. —Sembucherõ sacuã ño aoco nguiã nderese. Aque mose tuchɨ chõ acherõchɨ̃, ɨ que ari erenei ja Jesús je ra. Mbia que echandu ja u ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús que ñee ee cote ra. —Seɨcuasa chõ nde re. Nyebe arembucherõ nguiã. Ndeya tuchɨ eso cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús cheẽ mosete que emo ndu Jairo chuchua sɨ ra. —Nderiirĩ ngue mano cote ra. ¿Mbaerã nda Jesús ererao ndechuchua cote re? ɨ que ñee Jairo je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús que echandu ra. Ñee ngue Jairo je ra. —¡Ndeya eã techɨ̃ nda jẽ! Seɨcua chõ se. Nderiirĩ nda quera sɨ, ɨ que eru je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ngasẽ ngue echuchúaa cote ra. Jesús que ɨque eraaque rea cote ra. Pedro rese. Jacobo abe rese. Juan abe rese. Eraaque ru abe rese no. Esi abe rese. Ũquɨ̃ achõ ngue emingue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mbia que chɨ ja nyeseo ãquẽ ndese ra. —Jenyeseochɨ̃ nguiã. Mano eã ño ñene. Uque chõ ñene, ɨ que Jesús ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mbia que ɨquia Jesús cheẽ mose ra. —Eraaquete nyeresẽ. ¿Mañɨ nda nyuruã nde? ɨ que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesús que eraaque o isi ra. —Echuruã na, Echo, ɨ que ñee asite ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Quera sɨ que nyuruã cote ra. —Nderiirĩ embuquiaru cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Eru que nyuruɨra tuchɨ mae erese ra. Esi abe nyuruɨra tuchɨ. —¡Emo nda jembiiranduchɨ̃ jẽ! ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","—Jenyu, ɨ que Jesús uchɨmbaaquiatu doce je ra. Uquirãcuã ngue emee mee ee ra. Aba checuayã ɨcuã jea jea sacuã mbia sɨ. Mbia rasi mbucherõ cherõ sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","—Jẽso Dios cheẽ nenei nenei mbia je. Jẽso mbia rasi abe mbucherõ cherõ. “Mbia rerecuarã tuchɨ ra Dios cote”, jenye oso secheẽ nenei nenei mbia je. ");
INSERT INTO srqNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mbae mo nda jendaochɨ̃ icua. Jenyɨtochoquia ra jendaochɨ̃. Mbae riru mo abe ra jendaochɨ̃ no. Jenyɨurã mo nda jendaochɨ̃ no. Mbae isiquia mo abe ra jendaochɨ̃ no. Jẽɨrao nongue abe ra jendaochɨ̃ no. ");
INSERT INTO srqNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Emo nyuchúaa jengue mose, hueechõ ño jẽɨngo uque. Jemba jembatechɨ̃ nda uque tuchua raamba amba. Hue sɨ chõ jẽso sucha tubɨrɨã mo secheẽ nenei nenei cote. ");
INSERT INTO srqNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sucha tubɨrɨã mo jenda jẽisi sereã mose, jẽsecha chõ. Jẽi tubi jembutomo tomo ee. Hue jenda huɨɨcuã ɨcua sacuã, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Echɨmbaaquiatu que nyoɨ choɨ beɨ quia sucha tubɨrɨã mbuchesea sea ra. Dios cheẽ turã nenei nenei mbia ja je. Mbia rasi mbucherõ cherõ no. ");
INSERT INTO srqNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes abe que jirandu Jesús chɨao rese ra. Embusiquichete que ra. Emo ngue ñee ndei ee ra. —Ae ereɨquia nae, Juan ɨ equia ee nae, aque que quera sɨ ra, ɨ rei que emo ñee Herodes je ra. Juan Jesús riqui reɨ̃ nguiã mbia je. ");
INSERT INTO srqNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Elías Jesús riqui reɨ̃ nguiã emo je no. —Dios cheẽ nenei neneisa ima quera sɨ je chõ ñene, ɨ rei que emo emo Jesús rɨɨ̃ no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes que ñee nda. —Juan ãquĩ ngue achisiamo tuchɨ. ¿Mañɨ nda quera sɨ re? ¿Aba Jesús re? Ae rese aɨco jirandu tuchɨte. Tamae erese no, ɨ que ndua ndua uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús chɨmondo ucheẽ nenei neneisa que nyebi ngaẽ ee ra. —Ã ngue uresaã saã nda, ɨ que mbae renei ja Jesús je ra. Mbia tiámbaa que Jesús ũquɨ̃ nderao ja rei ra. Betsaida rurubi jiri. ");
INSERT INTO srqNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mbia ataque jirandu mose que nyoɨ eruɨ ra. Jesús que eisi turã Dios cheẽ nenei nenei ee ra. Erasi abe mbucherõ cherõ ee. ");
INSERT INTO srqNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tenda oso mose que echimbaaquiatu ñee ndei ee ra. —Mbia emondo rã sucha tubɨrɨã nɨa. Sã echoɨ beɨ quiaru huee. Uque beɨ abe huee no. Mbae ãte nandecu a, ɨ rei que echɨmbaaquiatu Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—Jeño mbae jemondo ee echɨurã, ɨ que Jesús ee ra. —Tei. Mbae quia ra aba mondo ee. Cinco chõ ngue mbichae ra. Sɨra abe nyeremoñote nyeresẽ, ɨ que echɨmbaaquiatu Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mbia tubɨrɨã tuchɨ que chɨ ra. Cinco mil ndobeɨ. —Mbia jembucoi ja ɨno íbii. Eata jaaja jeñono mbucoi. Sã echɨ ngoi icúe cúe cincuenta jaaja, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jesús cheẽ nguire que ngoi ja cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús que mbichae sirõ cote ra. Sɨra abe rirõ. Mae ngue ibate ra. —Gracias, ɨ que ñee Dios je ra. Mbichae que esiquio quio ra. Sɨra abe no. Mondo mondo ja que uchɨmbaaquiatu je cote ra. —Jembuchao chao mbia tubɨrɨã je cote, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mbia que embuquiaru ja tuchɨ ra. Miãtã tuchɨ que ra. Mbia huɨsa tubɨrɨã ngue cote ra. Sɨra rire. Mbichae rire abe no. Doce iru que mbia mombisẽ esique sique je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Emo mose que Jesús ae riqui ñee ñee Dios je ra. Echɨmbaaquiatu abe que chɨ huee ra. —¿Aba aɨco reɨ̃ mbia je re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Echɨmbaaquiatu que ñee ee ra. —Juan el Bautista ereɨco reɨ̃ nguiã emo je co. Elías ereɨco reɨ̃ nguiã emo je no. Dios cheẽ nenei neneisa quera sɨ je ereɨco reɨ̃ nguiã emo je no, ɨ que echɨmbaaquiatu ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—¿Aba aɨco reɨ̃ jẽje co re? ɨ que Jesús ee ra. —Cristo chõ nde resẽ. Dios riirĩ ño nde resẽ, ɨ que Pedro Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","—Ũquɨ̃ nda jeñeechɨ̃ emo je jẽ, ɨ tuchɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesús que uchɨmbaaquiatu mbaaquiatu quiatu ra. —Mbiarã ngue Dios sembu ra. Mbia ra sembasi mbasi tuchɨ. Ameɨ nda huɨ ja sesɨ. Sacerdotes rerecua abe ra huɨ ja sesɨ. Embesasa abe ra huɨ ja sesɨ. Mbia ra seɨquia chee. Tres tenda mose ra aquera sɨ, ɨ que Jesús mbia eɨquia nonde ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","—Emo siquise mose seruɨ, sã huɨ ja mbae ubi sɨ. Sã cruz umbaerã nduɨ beɨ se rã sɨ. Sã eriqui seruɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Emo ndua beɨ mose ngueco rese, ereco ra ua esɨ. Emo huɨ mose ngueco sɨ seje, ũquɨ̃ nda siqui beɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Emo ngueco mumba chooño mose, eya eã mbeɨ rae. Mbaecha rete raque. ");
INSERT INTO srqNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Emo ɨreɨ̃ ɨreɨ̃ mose sesɨ, se abe chõ nda aɨreɨ̃ ɨreɨ̃ esɨ. Emo ɨreɨ̃ ɨreɨ̃ mose secheẽ sɨ, se abe chõ nda aɨreɨ̃ ɨreɨ̃ esɨ, sechu mose mbia rerecuarã. Dios quirãcuã nda sembu. Angeles rese ra achu aque mose. ");
INSERT INTO srqNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tacheẽ nyecua jẽje. Ã jẽɨngo serese ã nae, jemo nda jemae Dios quirãcuã ndese jemano nonde. Mbia rerecua tuchɨ ra Dios, jemo mano nonde, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ocho tendare que Jesús choɨ sɨta ibátee ra. Ñee sacuã Dios je huee. Pedro que oso erese ra. Jacobo abe. Juan abe. ");
INSERT INTO srqNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesús ñee mose Dios je que eruba ñimbiasu ra. Eɨrao abe que enininya ra. Eɨraoshĩ nininya tuchɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mbia nyeremo ngue nyecua u ibate sɨ ra. Jesús nininya mose que eriqui ñee ñee nyue erese ra. Moisés que enongue ra. Elías que enongue no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ũquɨ̃ ja que enininya Jesús rese ra. —Mbia ra Jesús ɨquia mbucha ira rese Jerusalén, ɨ que equia ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro reesite raque. Eresenda abe reesi esite raque. Uqueã mbeɨ quera. Jesús nininyate quiatu ngue ee re. Moisés abe nininyate quiatu ngue ee re. Elías abe nininya no. ");
INSERT INTO srqNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ibatenda que nyoɨ quia Jesús recha cote ra. —¿Manyae ra ñee Jesús je re? ɨ que Pedro ra. Nyebe ñee ɨru chõ nguiã ee. —Nandecu turãte aa, Sembaaquiatusa. Sucha ñetẽ uresaã saã na. Enongue nembaerã. Enongue Moisés mbaerã no. Enongue Elías mbaerã no, ɨ rei que Pedro ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro cheẽ mosete que ibeishĩ ndu eite ñɨ nda. Ibeishĩ ngue Moisés mbuchecuayã ee ra. Elías abe mbuchecuayã ee. Nyebe esiquiche nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Echeẽ mo ngue echandu ibeishĩ qui re ra. —Co rei sebi tuchɨ seriirĩ co. Echeẽ jeñandu beɨ quia, ɨ que Dios ee ibeishĩ qui re ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aquere que Jesús mɨɨ ndiqui uchɨmbaaquiatu rese ra. Umaesa que esenei eã ja emo je ra. Ñee ãte que emo je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Isamamɨmbe que ecuaẽ nguichi sɨta ibate sɨ ra. Mbia tubɨrɨã ngue ngaẽ Jesús rea ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ũquɨ̃ mo ngue ñee Jesús je ra. —Seriirĩ ndese emae, Urembaaquiatusa. Seriirĩ mɨɨte que se co ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Aba checuayã ɨcuã ndiqui eisi isi co. Embaasẽ asẽ mbeɨ. Emburiri riri. Echuru mbɨchoɨ. Erete munumbi numbi. Aba checuayã huɨ sereã mbeɨ seriirĩ sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","“Aba checuayã embusẽ seriirĩ sɨ”, ae rei ngue ndechɨmbaaquiatu je re. Embusẽ aroneate esɨ, ɨ que eru ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","—¿Mañɨ jenye quia seɨcuayãte re? ¿Secheẽ jemumba tuchɨ chõ nguia re? ¿Ñimbirãcuã mbeɨte ra aba quia jẽje re? ɨ que Jesús ñee ee ra. —Nderiirĩ eru rã seje, ɨ que eru je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jesús rurubite mose que aba checuayã eriirĩ mbucoɨ mondo ra. Mburiri tuchɨ que ra. Jesús que ñee asite aba checuayã ɨcuã je ra. Eriirĩ ngue embucherõ nda. Embucherõ ji que emondo eru je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Dios quirãcuã ndese mae ngue mbia nyuruɨra tuchɨ ra. Jesús chɨao rese mae ngue mbia nyuruɨra tuchɨ ra. Mbia nyuruɨra mose que Jesús ñee uchɨmbaaquiatu je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Mbiarã ngue achu ra. Mbia ra semee mbia ɨcuã je. Serɨɨcharã. Ũquɨ̃ sɨ ra jẽtesareɨchɨ̃, ɨ rei que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Echɨmbaaquiatu que Jesús cheẽ ɨcuayãte ra. Echecuayãte que ee ra. —Ndecheẽ embiasa ure je, ɨã ngue ñee ee ra. Ɨreɨ̃ ɨreɨ̃ ño ngue ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","—Se quia ra ererecuarã tuchɨ jẽsɨ, ɨ jaaja que echɨmbaaquiatu ñee nyue ra. Ñee ɨcuã ɨcuã nyee nyue. ");
INSERT INTO srqNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús que ũquɨ̃ ndua ndua ɨcuate ra. Nyebe ãquẽ mo mbucoi mɨɨ nguiã ujii. ");
INSERT INTO srqNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jesús que ñee ee ra. —Sã ãquẽ mo ndiqui siqui mingue no jẽ. Ae eturã ndiqui mbia riirĩ je serɨɨ̃ nae, seje abe chõ eturã ndiqui nguiã. Ae eturã ndiqui seje nae, semondosa je abe chõ eturã ndiqui nguiã. Ae ererecua sereãte riqui jemo nae, ũquɨ̃ nguia sebi re. ¿Mbaerã jẽɨngo “ererecuarã se” ɨ nyue re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan ngue ñee Jesús je ra. —Pe emo nyɨ aba checuayã ndirõ ndirõ mbia sɨ nderɨɨ̃ pe. Uremae ngue erese ra. Aque eriqui ãte nanderese aque. Nyebe uresiquisã nguiã, ɨ que Juan Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús que ñee ee ra. —Tei. ¡Jẽsiquisã quisãchɨ̃ nda jẽ! Emo ɨcuã eã mose nande je, nanderesenda chõ ũquɨ̃ nde, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","—Namo jiri ra aso ibate cote, ɨ que Jesús ndua ndua cote ra. —Taso Jerusalén, ɨ tuchɨ que equia ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesús que mbia mo mondo unonde ra. Ũquɨ̃ ngue ngasẽ sucha tubɨrɨã mo nda. Samaria jenda rei sucha. —Jesús ra uque aa jendese, ɨ rei que hue jenda je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Hue jenda que Jesús isi turã sereãte ra. —Jerusalén Jesús sɨ quia quɨ reae. Nyebe ureɨco nguiã eisi sereã aa, ɨ que hue jenda ñee ɨcuã Jesús chɨmondo je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jacobo jirandu mose que paama ɨ hue jenda je ra. Juan abe que paama ɨ hue jenda je ra. Ũquɨ̃ ngue ñee Jesús je ra. —Sã Elías tata mbu ibate sɨ mbia ɨcuã je cose no. ¿Eɨ̃ ure sɨ ra tata mbu ã ɨquia sacuã nde? ɨ que echɨmbaaquiatu ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús que uba ñee asite ee ra. —Jẽsecha chõ. Aba mingosa riirĩ ño jẽɨngo ã ndesẽ. ¿Jẽtesareɨ chõ nguia ũquɨ̃ sɨ re? ");
INSERT INTO srqNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mbia ɨquia sacuã ngue achuã ndesẽ. Mbia mingo beɨ sacuã ño ngue achu nguiã, ɨ que Jesús ra. Sucha tubɨrɨã mo ngue echoɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jesús ngata mose que mbia mo ñee ee ra. —Taɨco beɨ nderese. Ndeso mose manguiti, se abe ra aso beɨ quia nderese, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús que ñee ee ra. —¿Mbae rasi ra eresaã saã serese re? Eoita quia ecua jiri re. Nguɨreɨ̃ nguia equisa jiri no nde. Se quia sequisayã mbeɨ re, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","—Seruɨ eɨco beɨ, ɨ que Jesús emo je ra. —Sã seru mano na. Aquere quia ra aɨco beɨ nderuɨ, ɨ rei que aque ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús que ñee ee ra. —Sã mbia ataque chõ nderu chati. Nde quia eso Dios cheẽ nenei nenei mbia je, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Emo ngue ñee Jesús je ra. —Aɨco jee ra nderuɨ. “Co acua quia co”, tae rã oso sechuchua jenda je, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús que ñee ee ra. —“Achu jirichɨ̃ nguia Jesús ruɨ”, ɨ mose sequiato mo, aque ra ngaseã Dios je, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Aquere que Jesús mbia setenta irabo no nda. —Serẽta chõ jẽso jẽso quia sucha mbuchesea sea, ɨ que ee ra. Nyeremo nemo ngue embuchao chao quia mondo ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","—Secheẽ andusa reã ndei etubɨrɨã. Secheẽ nenei neneisa rei co mɨɨ jiri. “Dios, ndecheẽ nenei neneisa mo emondo tuchɨ. Mbia mbiirandu randu sacuã”, jenye chõ nguia Dios je. Sã echa mbae a ɨshao shaosa mondo ea ɨreɨ̃ mose no. ");
INSERT INTO srqNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jẽso cote. Sã nyacua ɨcuã ndiqui oveja je no. Eɨ̃ sɨ ra mbia ɨcuã ɨcuã jẽje. Nyacua rã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jẽochɨ chõ jẽso. Mbae riru ra jendaochɨ̃. Mbae isiquia abe ra jendaochɨ̃ no. Jẽiyao abe ra jendaochɨ̃. Jẽitõ itõchɨ̃ nda ñeenda cúa ñee sacuã mbia je. ");
INSERT INTO srqNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jẽɨque mose emo nyuchúaa, jeñee turã huee tuchua jenda je. “Dios nda jembia beɨ quia chã”, jenye hue jenda je. ");
INSERT INTO srqNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Hue jenda ia mose Dios rese, Dios ra siqui tuchɨ erese. Eya eã mose Dios rese, emo je quia jeñee. ");
INSERT INTO srqNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jemba jembatechɨ̃ nda uque tuchua raamba amba. Jengue mocoɨ̃ jiri quia huee. Ae hue jenda u u quia nae, jẽ abe jẽu quia erese. Jẽɨngo mose secheẽ nenei nenei mbia je, sã mbia mbae mondo mondo jẽje. ");
INSERT INTO srqNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Sucha tubɨrɨã jenda jẽisi turã mose, jẽquiaru quiaru erese. ");
INSERT INTO srqNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hue jenda ndasi jembucherõ nyerõ ee. Hue jenda je secheẽ jẽsenei senei. “Namo jiri ra jenderecuarã Dios cote”, jenye chõ hue jenda je. ");
INSERT INTO srqNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Sucha tubɨrɨã jenda mo jẽisi sereã nea mose, jeñee asi ee etaicúee. ");
INSERT INTO srqNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Urei tubi urembutomo nguia jendique jie a. Jẽtesareɨã sacuã urecheẽ sɨ. Jenderecuase rete raque Dios. Jẽisiã ñochɨ̃”, jenye chõ hue jenda mbiirandu. ");
INSERT INTO srqNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Se mbia ɨcuã mbasi mbasi mose, hue jenda ra ambasi mbasi tuchɨ Sodoma jenda sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Seya eãte jendese, Corazín jenda. Seya eãte jendese, Betsaida jenda. Jendasi tuchɨ chõ ndae. Mbia mae sayã ngue asaã saã jẽje nae, ũquɨ̃ naa mose Sidón jenda je, eɨ̃ nda hue jenda huɨɨcuã ndecha rei. Eɨ̃ nda Tiro jenda abe huɨɨcuã ndecha rei. Eɨ̃ nda eya eãte rei huɨɨcuã ndese. ");
INSERT INTO srqNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jẽ nguia jẽɨcuã jẽsecha sereãte rei. Nyebe ra Dios jembasi mbasi tuchɨ ũquɨ̃ sɨ quiatu. Dios mbia ɨcuã mbasi mbasi mose. ");
INSERT INTO srqNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jẽcuasu jẽsaã saã tuchɨ techɨ̃ nguia re, Capernaum jenda. Nyebe ra Dios jemondo tuchɨ tata cuasu. ");
INSERT INTO srqNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Secheẽ nenei neneisa chõ jẽ nde. Ae ra jeñee ñandu quia nae, secheẽ abe ra echandu. Ae ra jẽucuãyãte quia nae, se abe ucuãyã ndae. Ae ra seucuãyãte quia nae, sembusa abe ucuãyã nda eno, ɨ que Jesús ñee uchɨmondo setenta je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ũquɨ̃ setenta nyebi sɨ mose que eyate ra. —Aba checuayã ɨcuã urecheẽ mumbayã ñochɨ̃ nderɨɨ̃, Urererecua, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús que ñee ee ra. —Satanás que ngoɨ tuchɨ u ibei sɨ ra. Sã ama piriã ɨ asi no, eɨ̃ sɨ que eu ngoɨ ra. Amae tuchɨ que ecoɨ rese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sequirãcuã ngue amee tuchɨ jẽje ra. Jendeaquiatu sacuã. Jẽirõ sacuã mbeɨ tásie rese. Quiraẽ ndese. Seucuãyãsa riquisã sacuã. Sequirãcuã nda jendea quiatu mingo. ");
INSERT INTO srqNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ũquɨ̃ ndesechɨ̃ nda jẽya. Serese quia jẽya. Aba checuayã jeñee mumbayã mose ¡ũquɨ̃ ndesechɨ̃ nda jẽya no jẽ! Paba que nombre jembae mbesa mbesa mɨɨ ibate ra. Ũquɨ̃ ndese quia jẽya, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aque mosete que Espíritu Turã Jesús mbia tuchɨ ra. Ñee ngue ngu je ra. —Seyate aɨco nderese co, Paba. Ibi jenda rerecua ja chõ nde re. Ibei jenda abe rerecua ja chõ nde no nde. Ndecheẽ ngue erembuchecuayã mbia aquiatu tuchɨ je ra. Mbia riirĩ naanguia je chõ ngue erembuchecua nguiã. Ũquɨ̃ ño ngue eturã ndeje ra, Paba, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","—Seru que mbae mondo ja seje ra. Paba mɨɨ ño seɨcua tuchɨ nguiã. Paba riirĩ mɨɨ ño se re. Se mɨɨ ño Paba aɨcua tuchɨ nguiã no. Ae je ra Paba ateacuquia nae, ũquɨ̃ mɨɨ ño nda Paba ɨcua tuchɨ nguiã serese, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jesús que uba mae uchɨmbaaquiatu rese ra. Eísaa que ñee nda. —Coche jemae nguiã ã sechɨao rese. ");
INSERT INTO srqNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mbia rerecua ñiinda mae ja bite raque ã sechɨao rese. Dios cheẽ nenei neneisa abe mae ja bite raque ã ndese. Mae eã mbeɨ que equia sechɨao rese ra. Secheẽ andu bite raque. Secheẽ ngue echanuate ra, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","—Ma Jesús ucheẽ nyabi, ɨ que embesasa mo ñee oso Jesús rea ra. —¿Mbae rese ra aɨco siqui beɨ nonde re? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","—¿Mañɨ ño Voisés chɨmbesa re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Embesasa que ñee ee ra. —Eɨ̃ ño ngue Moisés embesa ra: “Echesecua tuchɨquia Dios rese. Ndechɨã ja je chõ eɨco nyesecua erese. Neaĩ abe je. Ndequirãcuã abe je. Nendua ndua abe je. Sã erechesecua ndechɨese no, eɨ̃ ere sɨ chõ nyesecua nde ji jenda rese”, ɨ que embesa ji ñee ndesẽ, ɨ que embesasa ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús que ñee ke ra. —Erecheẽ turãte. Ndkɨco mose ũquɨ̃ ndese, Paba ra nemingo beɨ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Embesasa que uturã saã saã Jesús je ra. —¿Aba se ji jenda re? ¿Aba rese ra achesecua re? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús que ñee ee ra. —Sã emo oso quia Jericó quiti no. Jerusaén sɨ. Sã mbia ɨcuã nyarõ erese ñeenda cúa no. Ucua ucua tuchɨ que erese ra. Embae que embuquiachã ja ra. Eɨrao abe rirõ ja esɨ no. Ecura curái que esecha ɨno ñeenda cúa rɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Aque ñeenca auɨ que sacerdote mo sɨ ra. Maeño ngue ecura curái rese ra. Nyucuaño ngue oso ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Levita mo abe que oso rei hue rɨ̃ no nda. Aque abe que maeño sɨ erese no nda. Ñeenda ibi chõ esɨ nguiia kcuaño no. ");
INSERT INTO srqNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Aquere que Samaria jenda mo oso hue rɨ̃ nda. Aque mae mose ecura curái rese, eya eã tuchɨ que aque quiatu ra. Aque quia echucuaño eã nguiã cote. ");
INSERT INTO srqNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Aque que tiba erese ra. Mbae quira que equiti quiti eiruã nua ji rese ra. Vino abe quiti erese. Esia ji que echucua chucua ee ra. Caballo umbae rese que erasi mbuchuɨ cote ra. Tuchua mo ngue ererao ra. Huee que eriqui eraarõ isa ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Isamamɨ ngue ñee tuchuacha je ra. —Taso cote. Ecura curái embucherõ nguia aa. Co mbae isiquia nyeremo tamondo ndeje. Embucherõ sacuã eisi co je. Co nyeremo chayã mose, mbae isiquia mo nda amondobe ndeje sechube mose, ɨ que Samaria jenda ñee tuchuacha je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Aba nyesecua ecura curái rese re? ¿Sacerdote ere? ¿Levita ere? ¿Samaria jenda ere? ɨ que Jesús embesasa je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Embesasa que ñee ee ra. —Samaria jenda chõ ngue nyesecua erese resẽ, ɨ que embesasa ñee Jesús je ra. Jesús que ñee ee ra. —Ae rã sɨ chõ eɨco nyesecua, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús que ngasẽ sucha tubɨrɨã mo nda. Cuña mo ngue eisi turã uchuchúaa ra. Marta, ɨ equia ee. ");
INSERT INTO srqNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","María, ɨ que Marta nongue je ra. Jesús i ji beɨ que María riqui ngoi ra. Jesús cheẽ ndese nyiisaquia beɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta que mbae chao chao ja tuchɨ quia ra. Erecoteã tuchɨ que eriqui ra. Oso que ñee Jesús je ra. —Mbae mo ndese senongue riquíã ño co resẽ. Echeẽ na ee. Siqui sacuã mbae mo ndese seje, ɨ rei que Marta Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús que ñee Marta je ra. —¿Mbaerã ereɨco siqui jate mbae rese re, Marta? ");
INSERT INTO srqNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Aque mɨɨ ndese chõ eɨco ndenongue rã sɨ ae, Marta. María riqui secheẽ andu andu a resẽ. Emo nda embuɨ eã secheẽ sɨ, ɨ que Jesús Marta je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Emo mose que Jesús chɨ ñee ngu je ra. Huɨ mose que echɨmbaaquiatu ñee ee cote ra. —Urererecua, urembaaquiatu rã ñee Dios je. Sã Juan uchɨmbaaquiatu mbaaquiatu no, ɨ que Jesús chɨmbaaquiatu ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús que ñee ee ra. —Eɨ̃ jenye chõ nguia Dios je ñee mose: Paba ibatenda, sã mbia ñee turã ja beɨ quia nderɨɨ̃. Mbia rerecuarã ja sacuã echu jeɨ íbii. Sã mbia ibatenda siqui beɨte ndebi rese no. Sã mbia ibi jenda abe riqui ndebi rese. ");
INSERT INTO srqNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ae ra ureu namo, ũquɨ̃ embu rã urechɨurã. ");
INSERT INTO srqNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ae uresaã ɨcuã ɨcuã ndeje nae, ũquɨ̃ embutiã ná uresɨ. Sã ureɨco tesareɨ mbia ɨcuã ɨcuã mose ure je no. “Mbae ɨcuã jẽsaã” ¡ɨchɨ̃ nda emo ure je jẽ! Urereaquiatu mbae ɨcuã sɨ. Eɨ̃ jenye chõ ñee mose Dios je, ɨ que Jesús embaaquiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús que ñeembe ee ra. —“Mbae embu seje”, jẽ ɨ mose jẽquiato je, ¿mee nda jẽje re? Sã jẽɨngo oso jẽquiato rea itondiite rete mose no. “Mbichae prestar ere rã seje. ");
INSERT INTO srqNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Sequiato mo ngue tu serea ra. ¿Mbae ra amee ee re?” jenye chõ ee. ");
INSERT INTO srqNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ae je jẽɨngo ñee nae, ¿mee eã nda jẽje re? Sã ñee jẽje no. “Jẽso rei. Seɨquesa ãtãte. Co achu seriirĩ ndese quisa ye co. Sehuã sereãte. Mbae mo amondo aronea tuchɨte ndeje”, ¿ɨ ra jẽje re? ");
INSERT INTO srqNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mondo eã aroneate jẽje jeñee mbeɨ beɨ mose ee. Nyuruã sereãte raque uquiato je. Ñee mbeɨ mose ee, nyuruã nda mbae mondo turã ee. ");
INSERT INTO srqNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Eɨ̃ sɨ chõ Dios no nde. Jeñee ɨ ɨ mose Dios je, mbae ra emondo jẽje no. Jẽ mbae mo ndequia ɨ ɨ mose, jẽtea rae. Jẽ eɨquesa mbu ɨ ɨ mose, mbuquiata ra jẽje cote. ");
INSERT INTO srqNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ae ñee ɨ ɨte quia Dios je nae, mbae ra Dios mondo ee. Ae mbae mo sequia ɨ ɨte quia nae, tea rae. Ae eɨquesa mbu ɨ ɨte quia nae, equia ra ee. ");
INSERT INTO srqNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Jendiirĩ “mbichae embu seje” ɨ mose, ¿sɨta ra eru mee ee re? Jendiirĩ “sɨra embu seje” ɨ mose ¿mbeɨ ra eru mondo ee re? ");
INSERT INTO srqNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Jendiirĩ “nguira chɨa embu seje” ɨ mose, ¿quiraẽ nda eru mondo ee re? ");
INSERT INTO srqNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mbia ɨcuã nyee mbae turã mondo mondo quia nguiirĩ je ã. Jendu Ibatenda quia ra mbae turã tuchɨ mee jẽje. Jendu ra Espíritu Turã mee jẽje, jeñee mose ee, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Emo mose que Jesús aba checuayã ɨcuã mbusẽ emo ñɨa sɨ ra. Aque aba checuayã nguia echeẽ mbaaquiatuãte nguiã. Jesús embusẽ mose que ñee cote ra. Ñee mose que mbia nyuruɨra tuchɨ mae erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Emo emo ngue ñee nda. —Aba checuayã ɨcuã nderecua tuchɨ chõ Satanás nde. Satanás quirãcuã je chõ Jesús riqui nguiã aba checuayã ɨcuã mbusẽ mbusẽ mbia sɨ co, ɨ rei que emo emo nda. ");
INSERT INTO srqNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","—Ma Jesús aquiatute, ɨ que mbia ñee nyue ra. —Jesús, mbia mae sayã mo esaã na ure je, ɨ que mbia ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús que ũquɨ̃ ndua ndua ɨcuate ra. Nyebe ñee nguiã ee. —Gobierno ɨcuã ɨcuã mose nyue, ua rae. Tuchuamo jenda ɨcuã ɨcuã mose nyue, ua ra eno. ");
INSERT INTO srqNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satanás ɨcuã ɨcuã mose nyue, Satanás quirãcuã nda ua no. Jeñee ñooño ño nguiã seje ã. “Satanás quirãcuã je chõ Jesús riqui nguiã aba checuayã mbusẽ mbusẽ mbia sɨ”, jenye chõchɨ̃ nguiã seje ã. ");
INSERT INTO srqNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Aba jeñɨmbaaquiatu mbirãcuã jẽ nde? Aba checuayã ɨcuã mbusẽ nonde re. ¿Satanás jeñɨmbaaquiatu mbirãcuã serese re? ");
INSERT INTO srqNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dios quirãcuã je quiatu aɨco aba checuayã mbusẽ mbusẽ mbia sɨ ã. “Dios quirãcuã ndese chõ ureɨco nguiã mae”, jenye eã ñochɨ̃ nguiã ã. ");
INSERT INTO srqNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Satanás quirãcuã tuchɨte raque. Umbae raarõ tuchɨte raque. “Sembae chɨ turãte a”, ɨ raque. ");
INSERT INTO srqNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Dios quiarei equirãcuã tuchɨ Satanás sɨ. Dios Satanás mbae sirõ ja arõte quia esɨ co. Dios Satanás mbae mbutiã ja arõte quia co. ");
INSERT INTO srqNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ae siqui ãte quia serese nae, ũquɨ̃ ɨcuã ño eriqui nguiã seje. Ae mbae a ɨshao shao raanguia eãte quia seje nae, ũquɨ̃ ɨcuã ño eriqui nguiã seje. ");
INSERT INTO srqNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aba checuayã ɨcuã usẽ mose emo ñɨa sɨ, ngata beɨ chõ nguiã. “¿Mangue ra sequenea aucua que re?” ɨ chõ nguiã. Uquenea ucua sacuã ngue etea eãte ra. “Tasobe rei nyebi. Ae sɨ achu usẽ, aque chɨã ye sɨ taso”, ɨ que aba checuayã nda. ");
INSERT INTO srqNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aba checuayã nyebi sɨ mose u, mbia chɨã ndecoteã eãte que ee ra. Tuchua tii ji raãte que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aba checuayã ɨcuã ngue nguesenda siete queru cote ra. Ique ja que echoɨ aque chɨangui re cote ra. Ae chɨangui re aba checuayã ɨcuã siete riqui nae, aque ɨcuã ɨ ɨ tuchɨ que cote ra. Ñiinda sɨ. Aba checuayã mɨɨ ngue siqui eye nyii ra. Etubɨrɨãte cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús cheẽ mose que cuña mo tasẽ tuchɨ ñee mombo ra. —Mbae roonde tuchɨñɨ ndesi je nye. Ae nembuquiambu quia, ɨ que cuña mo ñee mombo Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús que ñee ee ra. —Dios cheẽ andusa je quiatu mbae roonde riqui nguiã. Dios cheẽ mumbasa reã je quiatu mbae roonde riqui nguiã, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mbia que ngaẽ tuchɨ Jesús rɨɨchã nda. Jesús que ñee mbia je ra. —Co mosenda mbia ɨcuãte riqui ã. “Mbia mae sayã esaã ure je”, ɨ beɨte equia seje ã. Mbia mae sayã mɨɨ ño nda asaã ee. Jonás na sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sã Jonás ndiqui raque sɨra rie ye tres días nae, sã mbia Nínive jenda echeẽ andu cote nae. Jonás na sɨ ra asaã mbia je. Mbia co mosenda je mae sayã tasaã. ");
INSERT INTO srqNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","La reina de Seba quia eturã jiri mbia co mosenda sɨ re. Dios ra co mosenda mbasi tuchɨ la reina de Seba sɨ. Sã la reina de Seba tu ɨsho tuchɨ sɨ Salomón ñee andu no. Se quia acheẽ ndaque quia jẽje. Searacua tuchɨ raque se quiatu Salomón sɨ. Secheẽ jemumbate chõchɨ̃ NGUIA Ã: Nyebe ra Dios jembasi tuchɨ mbia ɨcuã ndea rea mose. ");
INSERT INTO srqNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nínive jenda quia eturã jiri co mosenda sɨ re. Dios ra co mosenda mbasi tuchɨ Nínive jenda sɨ. Sã Nínive jenda huɨɨcuã ndecha Jonás ñee mose ee no. Aɨco raque ñee jẽje, co mosenda je. Jẽ secheẽ jemumbate chõchɨ̃ nguia ã. Se quia raque ererecua tuchɨ Jonás sɨ. Nyebe ra Dios jembasi tuchɨ mbia ɨcuã ndea rea mose. ");
INSERT INTO srqNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nande lámpara mendi mose, nandemɨɨ aroneate mbaequi re. Nandemɨɨ aroneate mbae mo ye. Nandemingo quia ibate erenda rese. Mbia resae ja sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nanderesa quiarei mbae resae nanderete je. Nanderesa turã mose, nanderete abe ra oso turã. Naneeresa ɨcuã mose, nanderete abe ra oso ɨcuã ɨcuã no. ");
INSERT INTO srqNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tata rendi rã jẽɨngo beɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tata rendi rã jẽɨngo beɨ mose, jemae turã nda mbae ja rese cote. Sã tata rendi riqui nanderesae no, ɨ que Jesús mbia mbaaquiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús ñee jare que fariseo mo ñee ee cote ra. —Nyao rã sechuchúaa. Terequiaru serese, ɨ que ñee Jesús je ra. Jesús que oso erese ra. Ngoi que quiaru cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseo que ñee uchɨangui re ra. —Jesús choɨ quiiriã ño quiaruchɨ̃, ɨ que uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesús que ñee asi ee cote ra. —Jẽo achõ ño jẽɨreɨ ɨreɨchɨ̃ nguiã. Jeñɨangui renda quia eɨcuãte re. Jeñɨangui renda quia jẽɨreɨ ãte nguiã. Abeɨ chɨãte chõ jẽɨngochɨ̃ jeñɨangui re. ");
INSERT INTO srqNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nandeo achõ eã ño ngue Dios saã nguiã. Nandechɨangui renda abe chõ ngue Dios saã ndesẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Abeɨ chɨãte chõ jẽɨngochɨ̃ jeñɨangui re ã. Jeñɨangui renda turã mose, eɨ̃ nda jẽturã ja rei. ");
INSERT INTO srqNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Aba mbia eã tuchɨchɨ̃ jẽ, Fariseos. Mbae a jemondo mondo tuchɨ raque Dios je. Jenyesecua eãte quia erese jeñɨangui re re. Jẽɨngo turã eãte quia mbia rese no nde. Ũquɨ̃ jẽsaã jiri ae. Mbae a abe jemondo Dios je. ");
INSERT INTO srqNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Aba mbia eã tuchɨchɨ̃ jẽ, Fariseos. “¡Serendarã turã nguiatu se jẽ!” jenyete chɨ̃ nguiã mbia ñumunua mose. “Sã mbia sererecua ɨ nande je”, jenyete chɨ̃ nguiã no. ");
INSERT INTO srqNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aba mbia eã tuchɨchɨ̃ jẽ, Fariseos. Embesasa abe no. Jenguasu jẽsaã saã techɨ̃ nguiã mbia je. Mbia raaque tãsa rã ño jeñɨangui renda re. Jeñɨangui renda soõ ño nguiã. Erondeite. Sã eraaque tãsa yenda soõ no. Mbia jirandu eã ndaque jeñɨangui renda soõ ndese, ɨ que Jesús ñee fariseos je ra. Embesasa je abe no. ");
INSERT INTO srqNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Embesasa mo ngue ñee Jesús je cote ra. —¿Mbaerã ereɨco ñee ure abe je re? ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús que ñee ũquɨ̃ abe je ra. —Aba mbia eã tuchɨchɨ̃ jẽ abe. Jeñee tuchɨte quia mbia je ã. Dios cheẽ jembeta mbeta tuchɨchɨ̃ nguia mbia je ã. Mbia echeẽ mumbayã aroneate chee quia ã. Jẽ sɨ chõ jeñee jemumba mumba nguiã ã. ");
INSERT INTO srqNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Cose ndare rã sɨ jẽɨngo nguiã ã. Jenameɨ na sɨ. Sã ñɨ jenameɨ ɨcuã ɨcuã ndiqui Dios cheẽ mbuchecuasa je cose no. Eɨ̃ jenye sɨ chõ nguiã ã no. ");
INSERT INTO srqNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Dios quiarei earacua tuchɨ. Ae que ñee jẽje ra. “Secheẽ mbuchecuasa emo emo nda amondo mbia je. Mbia ɨcuã ɨcuãte ra secheẽ mbuchecuasa je. Secheẽ mbuchecuasa mo ɨquia chee, ɨ que Dios ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ae Dios quiato ɨquia ɨquia quia cose nae, ũquɨ̃ nɨɨ nda Dios jembasi cote. Sã mbia Abel ɨquia cose no. Sã mbia Zacarías abe ɨquia altar jii no. Sã mbia Dios quiato ɨquia ɨquia beɨ cose no. Ũquɨ̃ ja rɨɨ̃ nda Dios jembasi cote. ");
INSERT INTO srqNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Aba mbia eã tuchɨchɨ̃ jẽ. “Ure mɨɨ ño Dios cheẽ ureɨcua nguiã ã”, jenye chooño ño nguiã ã. Dios cheẽ jẽisi turã eãte quia ã. Mbia siquise mose Dios rese, jẽɨngo emingo eãte erese ã no. Jẽ abe chee jẽɨngo eãte erese ã no, ɨ que Jesús ñee embesasa je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jesús ñee jare que fariseos paama ɨ tuchɨ ee ra. Embesasa abe paama ɨ nguiã ee no. Ũquɨ̃ ngue ñee ñee tuchɨ Jesús je ra. —Sã Jesús ucheẽ tasa tasa nande je no. Ũquɨ̃ mose nandeisi serao policíaa, ɨ tuchɨ que ra. Nyebe eriqui nguiã Jesús rea chemɨ ñemɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mbia tubɨrɨã ngue ngaẽ ngaẽ nguia Jesús rea cote ra. Cuaacua ɨ tuchɨ que equia nyuera. Mbia tubɨrɨã tuchɨ. Jesús que ñee uchɨmbaaquiatu je cote ra. —¡Fariseos rã nda jẽɨngochɨ̃ jẽ! Uturã naa ñooño mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ae mbia saã nyecuayã cuayã nguia nae, ũquɨ̃ nda nyecua ja cote. Ũquɨ̃ nda mbia ɨcua ja cote. ");
INSERT INTO srqNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ae jeñee nguia itondaru jẽɨngo mose, ũquɨ̃ nda nyecua ja mbia je cote. Jeñee equia nyiisa isa nae, ũquɨ̃ abe ra nyecua ja mbia je no. ");
INSERT INTO srqNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Tacheẽ nyecua jẽje, Sequiato. Ae “taɨquia” ɨ quia jenɨɨ nae, ¡ũquɨ̃ sɨ ra jẽsiquichechɨ̃ jẽ! ");
INSERT INTO srqNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ae aba mombo serɨ̃te quia tata cuasu nae, aque sɨ quiatu jẽsiquiche. ¡Aque sɨ quiatu jẽsiquiche tuchɨ jẽ! ");
INSERT INTO srqNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nguireɨ̃ ndei aba queteamba eã jiri. Mbae isiquia mumba eã jiri raque. Dios quia nguireɨ̃ ɨcua jate nguiã. Dios ra tesareɨã nguireɨ̃ mo sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dios riqui jẽ mɨɨ mɨɨ ɨcua ja co. Dios riqui ngueteã jiri jendese nguireɨ̃ sɨ co. Nyebe jẽsiquicheã mbae mo sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Jesucristo quiato chõ se re”, ae ɨ quia mbia je nae, ũquɨ̃ nɨɨ nda acheẽ turã se abe. “Sequiato chõ ã nde”, ae ra se. Angeles ra ambiirandu ja ũquɨ̃ ndese. ");
INSERT INTO srqNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","“Jesucristo quiato chõ se re”, ae ɨã nguia mbia je nae, ũquɨ̃ nɨɨ nda acheẽ turã eã. “Sequiato eã ño ũquɨ̃ nde”, ae ra se. Angeles nda ambiirandu ja sequiato eã ndese. ");
INSERT INTO srqNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Emo ñee ɨcuã mose serɨɨ̃, Dios ra echeẽ ɨcuã mbutiã arõte. Emo ñee ɨcuã mose Espíritu Turã nɨɨ, ũquɨ̃ ɨcuã nguia ra Dios mbutiã eã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mbia ɨcuã ɨcuã nda jẽje serɨɨ̃. Jenderao mose mbia rerecua je, ¡jẽquɨcoɨ coɨchɨ̃ nda jẽ! “¿Mañɨ nande ra ñee ee re?” ¡jenyechɨ̃ nda jẽ! ");
INSERT INTO srqNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Huee quia ra Espíritu Turã ñee nguiã jẽje jembucheẽ sacuã, ɨ que Jesús ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Emo ngue ñee Jesús je ra. —Sererecua, senongue ɨcuã ɨcuãte seje. Echeẽ na senongueje. Ae ureru secha ure je nae, senongue embuchecha turã eãte seje, ɨ que mbia mo ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús que ñee ee ra. —¿Mbaerã nda re? “Mbia mbae embuchecha turã turã ee”, ɨã ngue Dios seje ra, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","—¡Emo mbae rese ra jemae maechɨ̃ eoseɨ sacuã jẽ! “Sembae tubɨrɨã mose ra seyate cote”, ¡jenyechɨ̃ nda jẽ! ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jesús que ñee ee ra. —Sã mbaecha mo ndiqui no. Ibicha. Sã embae ɨa tuchɨte no. ");
INSERT INTO srqNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","“¿Mañɨ ae ra se re? ¿Mangue ra aba ererecoquiatu re?” ɨ tuchɨ que mbaecha uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Sembae ruacuã tambucuasu tuchɨ. Quiata a ruacuã. Ɨ̃ nda sembae ɨque ja tuchɨ huee. Ae arecoquiatu quia ã nae, ũquɨ̃ nda tenda ata jiri tea seje chã. ");
INSERT INTO srqNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aquieɨ quieɨ eã mbeɨ ra se quia cote. Aquiaru quiaru chõ nda se quia cote. Mbae ra ambei mbei chõ nguia cote. Achɨmbia mbia chõ nda se quia cote”, ɨ raque mbaecha ñee uchɨangui re. ");
INSERT INTO srqNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dios que ñee ee ra. “Ndearacuayãte ereɨco co. Co isa chõ nda eremano. Ae ererecoquiatute quia nae, aba je chio nda ũquɨ̃ cote”, ɨ que Dios ñee mbaecha je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ae mbae munua nua mbeɨ quia nae, ererecoquiatu sacuã nae, earacuayã tuchɨ chõ ũquɨ̃ nde. Dios quiato eã ño ũquɨ̃ nde, ɨ que Jesús mbia mbaaquiatu quiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús que ñee uchɨmbaaquiatu je ra. —“¿Mbae ra nandeu re?” ¡jenyechɨ̃ nda quɨcoɨ coɨ jẽ! “¿Ma tiru ra nandemingue re?” ¡jenyechɨ̃ nda quɨcoɨ coɨ jẽ! ");
INSERT INTO srqNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mbia chɨu ae ra mbia mingo eã. Mbia ɨrao abe ra mbia mingo eã no. ");
INSERT INTO srqNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sã nguireɨ̃ no. Mbae tiquiayã ndaque. Mbae ɨshao eã ndaque no. Mbae ruacuã eãte raque embae. Dios quiarei embuquiaru quiaru. Jẽ nguiarei Dios queteamba tuchɨ nguireɨ̃ sɨ. Nguireɨ̃ ja sɨ. Jẽ abe Dios ae jembuquiaru nguiã jẽ no. ");
INSERT INTO srqNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mbia ae ra tiarõ eã. “Se ra atiarombe”, ɨ raque ndua ndua uchɨangui re. Dios ae mbia mbutiarõ arõ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jẽ mbae ñetẽ naa aquiatuã mose, ¿mbaerã jẽɨngo “mbae cuasu tasaã” ɨ re? Dios quia ra mbae saã ja jẽje. ");
INSERT INTO srqNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sã mbae uti turãte riqui no. Mbae ao ao eã ndaque. Ñinyu mburirã eã ndaque. Mbae uti quiarei eturã jiri Salomón sɨ. Salomón turãte raque. ");
INSERT INTO srqNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sã Dios quiata mbuturã no. Quiata mano jeɨte raque. ¿Mañɨ nda Dios jembɨɨrao eã jẽ nde no? ¿Mbaerã jẽɨngo Dios ɨcuayãte re? ");
INSERT INTO srqNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“¿Mbae ra nandeu re?” ¡jenyechɨ̃ nda pare pare ɨ jẽ! “¿Mbae ra nandembei re?” jenyechɨ̃ nda quɨcoɨ coɨ no jẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Eɨ̃ ño Dios quiatoã nguiã. Jẽ nguia jendu tesareɨã mbeɨte nguiã jẽsɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jẽ nguia jẽɨngo tuchɨ Dios rese jenderecuarã. Ũquɨ̃ mose ra Dios mbae mee mee mbeɨ jẽje. Jenyɨurã. Jeñimbeirã abe no. ");
INSERT INTO srqNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jẽsiquichechɨ̃ nda mbae mo sɨ, Seriirĩ. Jendu ra umbae mondo ja jẽje. Dios iate ra umbae mondo mose jẽje. ");
INSERT INTO srqNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jembae jemondochõ ño mbaecha reã je. Ɨ̃ nda jembae tubɨrɨã jẽɨngo mose ibate cote. Mbae riru ra soro soroã mbeɨ jembae ibate cote. Mbae ra ua eã mbeɨ huee. Mbia ra mbae mbuquiachãyã huee. Chicuaquiareɨ̃ eãte ra huee no. ");
INSERT INTO srqNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jẽ jembae mondo mondo mose ibate, jendua ra ibatenda rese cote. Jẽ jembae monoã mose emo je, ibatenda rese ra jendua eãte. ");
INSERT INTO srqNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","¡Jẽɨngoquiatu beɨ quia jẽ! Itondaru abe jẽɨngoquiatu quia. ");
INSERT INTO srqNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Sã ererecua mo no. Oso ngũinisirã nderequia no. Huee erimba mo ndiqui echuchua raarõ huee. Aque ererecua ru quia eɨquesa mbuu mbuu aque cote. Erimba eequia asi ee cote. ");
INSERT INTO srqNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Erimba uqueã mose nguerecua tu mose, ererecua ia tuchɨ ra erese. Ererecua ra embuquiaru turã. Ae sɨ́ chõ echara chara nguiã ngũimba je hue no. ");
INSERT INTO srqNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ererecua ra tu arõte itondáruu. Itondiite mose abe no. Erimba uqueã mose nguerecua tu mose, ererecua ia tuchɨ ra erese. ");
INSERT INTO srqNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Sã emo ñee ndeje no. “Co mose ra mbae mbuquiachãsa ru nembae rirõ”, ɨ ndeje no. Ũquɨ̃ mose ra erequeã. Nembae ra eresaarõ mbeɨ esɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eɨ̃ jenye jẽ abe ɨcoquiatu. Eɨ̃ ae ra u ibate sɨ. “Tu eãte rei rae”, ɨ mose quia ra achu, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro que ñee Jesús je ra. —¿Aba je ereɨco ñee ũquɨ̃ nde? ¿Ure mɨɨ je ere? ¿Mbia ja je ere? ɨ que Pedro ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús que ñee ee ra. —Dios rimba aba cheẽ mumbayã nɨɨ aɨco ñee co. Dios rimba aracua rɨɨãɨco ñee co. Sã ererecua ñee ngũimba turã je no. “¡Sembae esaarõ ja jẽ!” ɨ ee. “Serimba ataque embuquiaru quiaru ja quia no”, ɨ ee. ");
INSERT INTO srqNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Erimba echeẽ mumbayã mose, ererecua ia tuchɨ ra tu mose. Erimba abe ra eya no. ");
INSERT INTO srqNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ererecua ra ngũimba mɨɨ mbeɨ cote, umbae raarõ sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sã erimba ndua ndua uchɨangui re no. “Sererecua ra tu jeɨ ãte”, ɨ ndua ndua. Hue ñee ɨcuã ɨcuã uataque je huee cote. Iruã nua cote. Quiaru chooño cote. Mbae mbei chooño abe cote. Quiacua quiacua cote. ");
INSERT INTO srqNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sã ererecua ru quia ngũimba mbuate aque cote no. Ñee ee. “Mbae ra eresaaroã mbeɨ seje cote”, ɨ ngũimba je cote. Ngũimba iruã nua tuchɨ cote. Ae aba cheẽ mumbate quia, ũquɨ̃ ndese ra mbae rasi raã naa cote. ");
INSERT INTO srqNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ae nguerecua cheẽ ɨcuate quia nae, ũquɨ̃ nda ererecua mbasi mbasi beɨ ucheẽ mumba mose. ");
INSERT INTO srqNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ae nguerecua cheẽ ɨcua eãte quia nae, ũquɨ̃ nguia ra ererecua mbasi mbasiã jiri ucheẽ mumba mose. Ae Dios cheẽ ɨcua tuchɨ quia nae, ũquɨ̃ je ra Dios “mbae esaã tuchɨ seje”, ɨ. Ae je Dios mbae mondo tuchɨ nae, ũquɨ̃ je ra Dios “mbae esaã tuchɨ seje”, ɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ibate sɨ que achu íbii ra. Mbia mae sacuã sequirãcuã ndese. Mbia sequirãcuã ɨcua eã ñochɨ̃ namo nyee. ");
INSERT INTO srqNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mbia ra sembasi tuchɨ cote. Pare pare aete se quia ndua erese co. ");
INSERT INTO srqNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Achu reɨ̃ mbia mbuturã turã sacuã serimba je jẽje re? Tei. Achu chõ ngue mbia mbuchao chao nyesɨ resẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mbia chuchua jenda ra ñɨmbuchao chao nyesɨ. Nyeremo nda siqui serese serimbarã. Eataque ra ñɨmbuchao esɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Emo nda eɨcuãte ngu je serɨɨ̃. Emo nda eɨcuãte nguiirĩ je serɨɨ̃ no. Emo nda eɨcuãte usi je serɨɨ̃ no. Acuanɨ abe ra eɨcuãte uchari je no. Ari mo abe ra eɨcuãte nguiirĩ ninisi je no. Eɨ̃ sɨ ra mbia ɨcuã ɨcuã uchue serɨɨ̃ no, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús que ñeembe mbia je ra. —“Ama nda nyaaqui”, jenye beɨ quia pã ɨ mose ã. Ibei jẽɨcuate raque quia ã. ");
INSERT INTO srqNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","“Tenda rasite ra cote”, jenye beɨ quia quɨrɨrɨã ɨchu ɨchu mose ã no. ");
INSERT INTO srqNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ibei jẽɨcuate raque quia ã. Tenda abe jẽɨcuate raque quia ã no. Ama abe no. Dios rucucha ra tu mbia je, ¿mbaerã jẽɨngo ũquɨ̃ ɨcuayãte quiatu re? ¿Mbaerã jẽɨngo jẽaracua raã naa nde? ");
INSERT INTO srqNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Mbaerã jẽɨngo mae sereãte mbae turã ndese re? ");
INSERT INTO srqNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Emo ñee ɨcuã mose jenɨɨ mbia rerecua je, jẽturã ño ee. Jeñee turã ño ee. Jẽ ae chõ jeñɨmbuturã nguia erese. Ɨ̃ nda jenderao ɨcuã eã. Jenderao mose ra jẽtarõ mbeɨ cárcel. ");
INSERT INTO srqNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Huee ra jẽɨngo beɨ. Jembae mondo ja tuchɨ chee ee, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aque mose que mbia Jesús mbiirandu Pilato rɨɨ̃ nda. Pilato nda mbia Galilea jenda mo ɨquia ɨquia ra. Mbia ticuasu ɨquia ɨquia mose Dios mbaerã. ");
INSERT INTO srqNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús que ñee mbia je ra. —Ae Pilato ɨquia ɨquia quia nae, ¿ũquɨ̃ ɨcuãte riqui reɨ̃ mbia ataque sɨ re? Tei. Jẽɨcuã ja chõ jẽɨngo nguiã ã no. ");
INSERT INTO srqNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jẽhuɨ eã mose jẽɨcuã sɨ, jemano ja chõ nda jẽ abe. Ũquɨ̃ na sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Sã torre de Siloé ngoɨ mbia ati no. Dieciocho ɨquia. ¿Ũquɨ̃ eɨcuãte riqui reɨ̃ mbia ataque sɨ re? Tei. ");
INSERT INTO srqNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eɨ̃ ja chõ ñene. Jẽhuɨ eã mose jẽɨcuã sɨ, jemano ja chõ nda jẽ abe. Ũquɨ̃ na sɨ, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús que ñee mbia je ra. —Sã ameɨ mo ira tiquia rei no. Ɨa eã mbeɨ chõ ee no. “Ma taso erea no. Ɨa cote reae”, ɨ rei que ameɨ nda. Ei oreãte que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nyebe ameɨ ñee nguiã ngũimba je cote. “Ira a rea ngue aso rei nguiã. Ɨa eã mbeɨ chõchɨ̃ seje tres años. ¡Echisia chõ oso jẽ! Ibi riquisã ñooño uã aque”, ɨ que ameɨ ngũimba je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sã erimba ñee ameɨ je no. “Co tenda mose nandechisia eã na. Equi tambuturã. Mbae ruusɨ tachono ñono erao rese. ");
INSERT INTO srqNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma ɨa eãte co tenda. Ɨa eã mose, nandechisia chõ cote”, ɨ que erimba ameɨ je ra, ɨ que Jesús mbia mbaaquiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sábado mose que Jesús chɨ mbia mbaaquiatu quiatu ra. Judíos chumunuásaa. ");
INSERT INTO srqNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Cuña ndasi mo ngue siqui hue ra. Nyiituquia beɨ dieciocho años nyee. Aba checuayã ɨcuã nguia embasi nguiã. Ari que nguete isoã mbeɨ quia ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús que mae ari rasi rese ra. —Echu rã aa, ɨ que ee ra. —Cuña, nderasi ãte cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesús que o chono erese ra. Aque mose tuchɨ que ari nguete iso turã cote ra. Ari que ñee turã turã Dios je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ererecua judíos munuasa que paama ɨ tuchɨ Jesús je ra. Ari mbucherõ mose sábado. —Sábado eã mose chõ nandeɨco mbae rese ae. Sábado eã mose chõ nandeɨco erasi mbucherõ ae. Sábado mose chõ Dios mbae resẽ. Erasi mbucherõ aroneate co mose resẽ, ɨ rei que ererecua mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesús que ñee ee ra. —¿Mbaerã ereɨco ndeturã naa ñooño nde? ¿Sábado mose jẽɨngo ticuasu mbuɨ eã mbeɨ embiu sacuã nde? ");
INSERT INTO srqNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Mañɨ nande ra cuña ndasi mbucheroã co sábado mose re? Judía sɨ́ chõ nyeresẽ. Jẽ na sɨ. Satanás que embasi cosete ra. Dieciocho años chee. ¿Mañɨ ae ra erasi mbuɨ eã esɨ sábado mose re? ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mbia ataque iate que Jesús cheẽ mose ra. Jesús chɨao rese abe eyate no. Ae Jesús ucuãyãte quia, ũquɨ̃ ngue eɨreɨ̃ tuchɨ Jesús cheẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Jesús que ñeembe mbia je cote ra. —¿Mbae rã ño Dios rimba chã? Mbae eɨ̃ na ño Dios rimba re. Sã mbia mostaza eɨ̃ tiquia no. Ieɨ̃ ñetẽte raque etiquia ramo mose. Suri oso quia cote. Ecuasu tuchɨ chee cote. Nguireɨ̃ uquisa saã nyee erãquiã ndese. Eɨ̃ sɨ chõ Dios rimba re. Ũquɨ̃ mɨɨ ndaque nyii. Ñimbeta tuchɨ cote. Mbae eɨ̃ na. ");
INSERT INTO srqNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","¿Mbae rã ño Dios rimba chã? Levadura rã ño Dios rimba re. Sã mbia levadura ñetẽ mondo mbichae ao ramo mose no. Levadura oso quia mbichae mbuchɨmatã ja no. Eɨ̃ sɨ chõ Dios rimba re, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús que oso quia Jerusalén nda. Tiba tiba que oso quia mbia chuchua mbuchesea sea ra. Mbia mbaaquiatu quiatu. ");
INSERT INTO srqNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Emo ngue ñee Jesús je ra. —Sererecua, ¿mbia mɨɨ mɨɨ ño nda siqui ibate nderese re? ɨ que emo ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jesús que ñee ee ra. —¡Eɨquesa chumumbi rɨ̃ ño jẽso ɨque jẽ! “Hue rɨ̃ nda aso se abe ɨque”, ɨ ja jate raque rae. Tei. Ɨque ja eã nguia nda re. ");
INSERT INTO srqNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Emo mose ra eɨquesa amatã mbeɨ cote. Emo nda ɨqueã mbeɨ cote. Eɨquesa ra jembuu mbuu raque cote. “Sererecua, eɨquesa embuquiata rã ure je”, jenye raque ra seje cote. Acheẽ nda jẽje. “¿Mangue jenda jẽ nde? Jaẽɨcuayãte se”, ae ra jẽje cote. Eɨquesa ra ambuquiatayã mbeɨ jẽje cote. ");
INSERT INTO srqNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jeñee tuchɨ raque ra seje cote. “Urequiaru que equia nderese. Nde que urembaaquiatu quia. ¿Mañɨ ere ra urerecha re?” jenye raque ra seje cote. ");
INSERT INTO srqNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Acheẽ nda jẽje cote. “Jaẽɨcuayãte se. Jẽso serecha. Mbae ɨcuã ngue jẽsaã saãte quia resẽ”, ae ra se hue cote. ");
INSERT INTO srqNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hue ra jenyeseo seo seje huee cote. Jeñee nda seje. “Abraham ño siquichɨ̃ nderese hue. isaac abe no. Jacob abe no. Dios cheẽ mbuchecuasa ja abe no. Ure chõ urecuchɨ̃ taicuee a”, jenye ra nyeseo seo seje huee. ");
INSERT INTO srqNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mangue jenda chooñoa nda ngaẽ ngaẽ Dios rɨɨchã aque mose. Quiaru quiaru ra equia Dios rese. ");
INSERT INTO srqNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ae eaquiatute riqui raque namo nae, ũquɨ̃ mo nda eñetẽ na pee cote. Ae eaquiatuãte riqui raque namo nae, ũquɨ̃ mo nguia ra siqui ecuasurã tuchɨ pee cote, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aque nyaashɨ̃ mose que fariseos ngaẽ ñee Jesús je ra. —¡Eso a sɨ jẽ! Herodes ndeɨquia serɨ̃te quia co, ɨ que Jesús mbiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús que ñee ee ra. —Eoita rã ño Herodes re. Jẽso ñee ee. “Jesús que ñee ndeje ra. ‘Taɨco mbɨrɨmbe rã aba checuayã ɨcuã jea jea mbia sɨ. Taɨco mbɨrɨmbe rã mbia rasi mbucherõ cherõ. Namo. Isamamɨ abe. Isamamɨ nongue ra ahuɨ erecha cote’, ɨ que Jesús ndeje ra”, jenye oso Herodes je. ");
INSERT INTO srqNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Taɨcobe jiri namo. Isamamɨ. Isamamɨ nongue abe no. Jerusalén nguia nda seɨquia nguiã. Sã Dios cheẽ mbuchecuasa mano ja Jerusalén no. ");
INSERT INTO srqNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Tacheẽ na jẽje, Jerusalén jenda. Seya eãte aɨcochɨ̃ jendese co. Hue jẽɨngo mbia ɨquia ɨquia beɨte hue. Dios cheẽ mbuchecuasa ɨquia ɨquia. Dios chɨmondo abe ɨquia ɨquia no. Sã nguira riqui nguiire reaquiatu mondo ujeoqui re no. “Eɨ̃ tae jendeaquiatu”, ae beɨte rei nguiã jẽje co. Secheẽ jẽisi sereã mbeɨ chõchɨ̃ nguia ã. ");
INSERT INTO srqNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","¡Aɨco jendecha a cote jẽ! Jemae mae eã nda serese cote. “¡Co chɨ Dios rucucha ru quia co cote jẽ!” jenye mose, hue ramo nguia ra jemae serese cote. ");
INSERT INTO srqNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jesús que oso rei quiaru fariseo rerecua mo nyuchúaa ra. Sábado mose. Fariseos mo ngue chɨ erea chemɨ ñemɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Huee que emo ndasi riqui Jesús je ra. Erete ruru ja que ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús que ñee fariseos je ra. Embesasa je abe. —¿Eɨcuãte se erasi mbucherõ mose sábado mose re? Ɨ ere. Jeñee seje, ɨ rei que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jesús cheẽ mose que mbia mo ñee eãte ee ra. Jesús que erasi mbucherõ mondo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jesús que ñee fariseos je ra. —Sã jenimba ticuasu riqui jaã no, ngoɨ oso ibicua rie. ¿Sábado mose ra jẽsiquíã nde? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Fariseos que ñee sereãte echeẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mbia que erenda turã isirõ sirõ nguia ra. Ngoi sacuã ererecua ji. Ucuasu raã naa sacuã. Nyebe Jesús ñee nguiã ee. ");
INSERT INTO srqNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Jẽɨngo mose fiesta, ¡erenda turã mo nda jẽisirõchɨ̃ jẽ! Mbia chɨɨcuate mo nda tu arõ ndeje cote. ");
INSERT INTO srqNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Fiestacha ra ñee arõte ndeje. “Ehuã na nde. Erenda turã tamondo sequiato je”, ɨ arõte ra ndeje. Ndeɨreɨ̃te ra huee cote. Pe quiti jiri ra nembucoi cote. ");
INSERT INTO srqNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jẽɨngo mose fiesta, pe quiti jiri chõ jengoi. Erenda turã isirõ nocoĩ. Ɨ̃ nda fiestacha ñee ndeje. “Quiatuchu a jiri, Sequiato. Erenda turã tose”, ɨ sacuã ndeje. Ɨ̃ nda mbia mae ja nderese. ");
INSERT INTO srqNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ae ererecua saã saã nguia nae, ũquɨ̃ nda siqui eñetẽ na cote. Ae siqui minguete quia nae, ũquɨ̃ nda siqui ererecuarã cote, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Fiestacha abe je que ñee cote ra. —Nde fiesta raã mose, “jenyu quiaru serese”, ¡erechɨ̃ nda mbaecha jiri je jẽ! Erechɨ̃ nda ndenongue je. Erechɨ̃ nda ndequiato tuchɨ je. Ũquɨ̃ mose ra embuchebi ndeje. Dios quia ra embuchebiã ndeje cote. ");
INSERT INTO srqNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nde fiesta raã mose, “jenyu quiaru serese”, ere chõ mbaecha reã je. Ere chõ mbia rasi rasi je. Mbia cuatayã je. Mbia resayã je. ");
INSERT INTO srqNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nde fiesta raã naa mose ũquɨ̃ je, ũquɨ̃ nda embuchebiã ndeje. Dios quia ra embuchebi ndeje, Dios quiato quera sɨ mose. Ũquɨ̃ mose ra ndeya tuchɨ, ɨ que Jesús fiestacha je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ũquɨ̃ andu mose que emo ñee Jesús je ra. —Ababi tuchɨ siqui Dios rese ae ererecua tuchɨ mose, ɨ que emo ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús que ñee ee ra. —Sã emo fiesta raã no. “Jenyu quiaru serese”, ɨ sacuã mbia tubɨrɨã je. Mbia chɨurã ngue esaã tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Echɨurã quiche ja mose que ngũimba mo mondo cote ra. “Ae je acheẽ, sã ecuaẽ quiaru cote”, ɨ que ngũimba je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ateẽ. Aso eã nda se. Serecoteãte chõchɨ̃”, ɨ ja ja que ra. “Ibi mo ngue aisi ramote ra. Taso rã erea”, ɨ que emo ucheẽ mondo fiestacha je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ticuasu mo ngue aisi ramote ra. Cinco yuntas. Taso rã erea”, ɨ que emo ucheẽ mondo no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Seninisirã mo areco ramote co. Nyebe ra asoã quiaru nderese huee”, ɨ que emo ee no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Erimba que tu nyebi ñee nguerecua je ra. “Erecoteã ja jate que ra. Quiaru eã nda nderese”, ɨ que erimba embiirandu ja ra. Ererecua que paama ɨ ra. Ngaẽ eã mose erea. Ae ñeembe nguiã ngũimba je. “Eso ñee ũquɨ̃ je quiatu no. Mbaecha reã je. Mbia rasi rasi je. Mbia cuatayã je. Mbia resayã je. Ũquɨ̃ ja je echeẽ. Sã ecuaẽ quiaru serese”, ɨ que ererecua ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Emo mose jiri que erimba ru ñee nyebi ee ra. “Acheẽ ñee ja que ee ra. Co ecuaẽ ndaque nguiã co. Mbia mɨɨte que ra”, ɨ que erimba ñee fiestacha je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ererecua que ñeembe ee ra. “Esobe ñee ñee emo je no. Eru ja sechuchua. Quiaru sacuã serese. Ɨ̃ nda sechuchua mbiitãyã jiri. ");
INSERT INTO srqNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ae je acheẽ nyii, ũquɨ̃ nda quiaruã tuchɨ serese cote”, ɨ que ererecua ñee asi ra, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mbia tubɨrɨã ngue siqui quia Jesús ruɨ ra. Jesús que uba ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ae nyesecua tuchɨ quia ngu rese sesɨ, ũquɨ̃ nda serimba eã. Ae nyesecua tuchɨ quia usi rese sesɨ, ũquɨ̃ nda serimba eã no. Ak nyesecua tuchɨ quia ngũinisi rese sesɨ, ũquɨ̃ nda serimba eã no. Ae nyesecua tuchɨ quia nguiirĩ ndese sesɨ, ũquɨ̃ nda serimba eã no. Ae nyesecua tuchɨ quia ngõngue ndese sesɨ, ũquɨ̃ nda serimba eã no. Ae nyesecua tuchɨ quia ngueco rese sesɨ, ũquɨ̃ nda serimba eã no. Ũquɨ̃ ja ra serimba eã. ");
INSERT INTO srqNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ae mano sereãte serɨɨ̃, ũquɨ̃ nda serimba eã no. Ae siqui sereãte quia seruɨ, ũquɨ̃ nda serimba eã no. ");
INSERT INTO srqNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Sã emo ñee no. “Sechuchua tasaã na”, ɨ. “¿Manya mbae isiquia ra amumba sechuchua raã sacuã nde?” ɨ nyii eao nonde. ");
INSERT INTO srqNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sã uchuchua raã naa ndaque no. Ɨhuaẽ tiquia tiquia raque. Huɨ beɨ chõ esɨ cote. Hue mbia ɨquia ɨquia ee cote. ");
INSERT INTO srqNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Co uchuchua saã saã ndei cose. Saã ja eã mbeɨ chõchɨ̃ nae”, ɨ ra mbia ɨquia ɨquia ee. ");
INSERT INTO srqNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Sã soldados rerecua ɨcuã ɨcuã emo je no. Guerra raã serɨ̃ ee. Guerra raã nonde ra ndua ndua. “Ae quiatu que soldados tubɨrɨãte embae sesɨ ra”, ɨ uchɨangui re cote. ");
INSERT INTO srqNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nyebe guerra raã eã nguiã ee. Nyebe ucheẽ turã mondo nguiã ee. Ɨsho mose. “¡Nandeɨco turã ño nyɨese jẽ!” ɨ ee. ");
INSERT INTO srqNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","¡Eɨ̃ jenye sɨ chõ nguia jẽ! Jendua rã nguia nyii. Jẽ jembae recha ja eã mose, serimbarã eã nda jẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Embiquesa turãte raque. Embiquesa ɨse quiachamba mose, eɨcuã tuchɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ñio ye echã aronea cote. Eɨcuãte cote. Emombo beɨ chõ cote. Ae eisate riqui, secheẽ jeñandu, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mbia ɨcuã ngue Jesús sɨɨchã nguia ra. Ae impuestos isi isi quia, ũquɨ̃ abe que Jesús sɨɨchã nguia ra. Echeẽ andu sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nyebe fariseos ñee ɨcuã ɨcuã nguiã Jesús rɨɨ̃. Embesasa abe ñee ɨcuã ɨcuã nguiã erɨɨ̃ no. —¿Mbaerã Jesús riqui mbia ɨcuã isi turã turã nde? ¿Mbaerã eriqui quiaru erese re? ɨ que equia ñee Jesús mbutereã tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nyebe Jesús ñee nguiã ee. Embaaquiatu sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Sã emo nimba quiachã oveja no. Cien ndei erimba. Co mɨɨ ngue quiachã ee ra. Aque esɨ quia quiachã je requia aque. Eataque recha. Noventa y nueve recha. ");
INSERT INTO srqNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Quiachã je rea mose, suɨ cote. Equiaama cote. Eya tuchɨ erese cote. ");
INSERT INTO srqNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tu uchuchua cote. “Quiatuchu rã”, ɨ uquiato je cote. Nguesenda je abe no. “Quiachã je que atea cote ra. ¡Sã jẽ! Jẽya tuchɨ serese cote”, ɨ que uquiato je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tacheẽ nyecua jẽje. Quiachã je mo nyebi mose, Dios iate riqui co. Mbia ɨcuã tu mose ee, Dios iate riqui erese co. Ae uturã saã saã nguia nae, ae huɨɨcuã secha sereãte quia nae, ũquɨ̃ ndese quia Dios ia eãte re. ");
INSERT INTO srqNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Sã cuña mo mbae isiquia diez quereco no. Sã aque mɨɨ quiachã ndaque ee no. Lamparina ngue emendi eresae sacuã nda. Sã uchuchua tii no. Mbae isiquia rea chee. ");
INSERT INTO srqNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ereare que ñee uquiato ja je ra. “Quiachã je que atea cote ra. ¡Sã jẽ! Jẽya tuchɨ serese cote, ɨ que uquiato je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Aɨco ñee nyecua jẽje a. Mbia mo huɨ mose huɨɨcuã sɨ, ángeles ibatenda ia tuchɨ erese, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús que ñeembe ee ra. —Sã ameɨ mo eriirĩ nyeremo no. ");
INSERT INTO srqNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Eriirĩ ndiquii que ñee ngu je ra. “Paba, mbae isiquia ataque embu rã se sembaerã. Ndemano nonde”, ɨ que ñee ngu je ra. Ae eru mbae isiquia mbuchecha nguiã ee. Mondo eo cote. ");
INSERT INTO srqNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Isamamɨ nongue que eriirĩ nduɨnda umbae rerecoquiatu ra. Ae oso nguiã ɨsho cote. Ngu recha. Huee que mbae isiquia umbae mumba chooño ja ra. Mbae ɨcuã ndɨbɨshorõ. ");
INSERT INTO srqNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hue jenda mbia chɨu que uate cote ra. Ameɨ ndiirĩ abe riãcuã nyee que ra. Umbae mumba chooño jare. ");
INSERT INTO srqNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","“Taquieɨ quieɨ rã oso ererecua mo je”, ɨ chee. “Teasu socoɨ esaarõ na serimba”, ɨ chee ererecua mo ee. ");
INSERT INTO srqNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","“Teasu chɨu au chõ mbichɨ̃ ira a. Seriãcuã tuchɨchɨ̃”, ɨ chee ameɨ ndiirĩ. Emo ngue embuquiaruã mbeɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Paba rimba chɨchɨ̃ quiaru turãte sechuchua huee, seriãcuã mose aa. ");
INSERT INTO srqNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tasobe rei Paba rea. Tacheẽ ndei oso ee. ‘Seɨcuã tuchɨte que ndeje curɨ ra, Paba. Paba ibatenda je abe no. ");
INSERT INTO srqNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Seriirĩ ere eã seje cote. Nderimbarã taɨco cote’, tae rã oso Paba je”, ɨ que ndua ndua uchɨangui re cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ngu rea que esɨ cote ra. Ɨsho ereco mose que eru mae erese ra. Ameɨ ɨa eã tuchɨ que eriqui erese ra. Ameɨ ngue oso uchã nguiirĩ ndese oo ra. Equiaama. Eritii riite no. ");
INSERT INTO srqNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ngu je que eriirĩ ñee ndei cote ra. “Seɨcuã tuchɨte que ndeje curi ra, Paba. Paba ibatenda je abe no. Seriirĩ ere eã seje cote”, ɨ rei que ngu je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Eru que ñee ngũimba je cote ra. “Eɨrao turã mo emondo seriirĩ je. Eiyaorã abe mo emingue ee. Anillo mo abe emingue eo rese. ");
INSERT INTO srqNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ticuasu quira mo jẽquishĩ echo je. Nandequiaru tuchɨ erese. Fiesta nandesaã ee. ");
INSERT INTO srqNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Seriirĩ ngue mano naanguia oso curɨ resẽ. A eru quera sɨ raanguia seje a. Quiachã tuchɨ que oso serecha ra. A erube seje a cote”, ɨ que ameɨ ngũimba je ñee nda. Eya tuchɨ cote. Nyebe fiesta raã nguiã nguiirĩ je. ");
INSERT INTO srqNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ameɨ ndiirĩ nongue que siqui úcoo ra. Ngasẽ ndaque u quia uchuchúaa cote. Tõotõ ɨ que echandu ra. Mbia cheĩ cururi abe andu. ");
INSERT INTO srqNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ñee ngue erimba mo je ra. “¿Mbaerã eriqui toõtõ ɨ re? ¿Mbaerã mbia riqui nyuruqui re?” ɨ que ameɨ ndiirĩ ndiquii ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Erimba que ñee ee ra. “Ndenongue que tu ngasẽ nderu je ra. Nyebe ticuasu ɨquia nguiã ee”, ɨ que erimba ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ae enongue paama ɨ nguiã ngu je. Ɨque sereã nea ngu chuchúaa. Ae eru tu nguiã usẽ ñee ee taicuee. “Eɨque rã mae ndenongue rese”, ɨ rei que eru ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Eriirĩ ngue ñee ngu je ra. “Cosete que aɨco rei quieɨ quieɨ ndeje. Ndecheẽ ngue amumba mumba eãte quia emo mose. Mbae mo ngue ereɨquia eã mbeɨte seje. Sembae fiesta raã sacuã sequiato rese. ");
INSERT INTO srqNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ae tu ramo nderiirĩ, ¿mbaerã ticuasu mo ereɨquia ee re? Umbae que emumba chooño oso curɨ resẽ. Siqui siqui cuña ɨcuã ndese. ¿Mbaerã ereɨco fiesta raã ee re?” ɨ que eriirĩ ngu je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Eru que ñee echeẽ mose ra. “A ereɨco beɨte serese a resẽ, Echo. Sembae ja chõ nembaerã ndesẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ndenongue quiatu que quiachã nandesɨ resẽ. Mano naanguia oso nandesɨ. A eru sɨ quera raanguia nande je a. Nyebe fiesta nandesaã ee. Nandeya tuchɨ rã erese”, ɨ que eru nguiirĩ nongue je ra, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús que ñee uchɨmbaaquiatu je ra. —Sã ererecua mo mbaechate riqui no. Erimba mo ngue embae saarõ ja quia ra. “Nderimba que nembae mbuquiachã quiachã nguia ra”, ɨ que mbia mo ererecua mbiirandu cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ererecua que ñee ee ra. “¿Mbaerã mbia riqui ñee nderɨɨ̃ seje re? ¡Cuentas esaã saã mbia mbae ja jẽ! Sembae raarõsa eã nda nde cote”, ɨ que ererecua ngũimba je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Erimba que ndua ndua uchɨangui re cote ra. “¿Mañɨ ae ra sequia sererecua se mombo mose re? Sequirãcuã neate quieɨ quieɨ sacuã ndesẽ. Seɨreɨ̃te ache ache ɨ mbia je. ");
INSERT INTO srqNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ũquɨ̃ ño nda asaã ee nda. Ɨ̃ nda mbia seisi turã uchuchúaa sembae eã mose”, ɨ que erimba uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ae deber ɨ quia ererecua je, ũquɨ̃ je que erimba ñee nda. Co mɨɨ mɨɨ je. “¿Manya deber ere sererecua je re?” ɨ que erimba emo je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Cien latas de aceite que deber ae ee ra”, ɨ que erimba je ra. Erimba que ñee ee ra. “Nembae cuenta nandemombo chõ. Emo nandesaã asi. Cien eã nda cote. Cincuenta achõ ño nda cote”, ɨ que erimba ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ae deber ɨ quia ererecua je, ũquɨ̃ mo je que erimba ñee no nda. “¿Manya deber ere sererecua je re?” ɨ ee. “Cien bolsas de trigo que deber ae ee ra”, ɨ que erimba je ra. Erimba que ñee ee ra. “Nembae cuenta nandemombo chõ. Emo nandesaã asi. Cien eã nda cote. Ochenta achõ ño nda cote”, ɨ que erimba ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ererecua que jirandu erese cote ra. “Serimba aracua chõ eriquichɨ̃ nde no”, ɨ que ererecua ra. Mbia ibi jenda aracua tuchɨ chõchɨ̃ Dios quiato sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Acheẽ tuchɨ quia jẽje co. ¡Mbae isiquia jemondo mondo quia ibatenda je jẽ! Eɨ̃ nda jẽquiato jiri. Eɨ̃ nda Dios jẽisi quiatu turã ibate jembae ua mose. Huee ra jẽɨngo beɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ae mbae ñetẽ saarõ turãte quia, mbae tubɨrɨã abe ra esaarõ turã nguia. Ae mbae ñetẽ saarõ turã eãte quia, mbae tubɨrɨã abe ra esaarõ turãyã nguia no. ");
INSERT INTO srqNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jẽ jembae mondo turã eã mose Dios je, Dios ra mbae turã mondo eã jẽje ibate. ");
INSERT INTO srqNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jẽ Dios mbae raarõ turã eã mose, ¿aba quia ra mbae mondo jẽje jembaerã tuchɨ cote re? ");
INSERT INTO srqNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Co mɨɨ erimba siqui aronea ererecua nyeremo ndese. Ererecua nyeremo mose, huee ra erimba nguerecua nongue ucuãyã. Ererecua nongue ra ebite. Ae ndua beɨte quia mbae isiquia rese nae, ũquɨ̃ siqui aroneate Dios rese. Ae siqui beɨte quia Dios rese nae, ũquɨ̃ ndei ndua eã jiri mbae isiquia rese, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseos que chɨ Jesús cheẽ andu ja ra. Mbae isiquia quiato tuchɨ que ũquɨ̃ nda. Nyebe ñee ɨcuã nguiã Jesús cheẽ mose. ");
INSERT INTO srqNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nyebe Jesús ñee asite nguiã ũquɨ̃ je. —Jẽ nguiarei jẽturã jembuchecua tuchɨ mbia résaa. Dios quiarei jeñɨangui renda ɨcua tuchɨ quia co. Ae eturã abareãte riqui mbia je nae, ũquɨ̃ Dios ucuãyãte quia co. ");
INSERT INTO srqNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moisés chɨmbesa que mbia mbaaquiatu quiatu nyii ra. Dios cheẽ mbuchecuasa chɨmbesa abe que mbia mbaaquiatu quiatu nyii ra. Juan tu nonde. Juan ngue Dios cheẽ turã senei senei cote ra. “Mbia rerecuarã tuchɨ ra Dios cote”, ɨ beɨ que Juan nguia ee cote ra. Nyebe mbia riqui nguiã ñee. “Dios rimba ra se”, ɨ tuchɨ mbia quia ã cote. ");
INSERT INTO srqNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ibei ua arõte quia co. Ibi abe ua arõte quia co no. Embesa ji Dios cheẽ nguia ra uayã mbeɨ. Io ja rae. ");
INSERT INTO srqNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Mbia ngũinisi mombo mose, ngũinisirã mo nderequia mose, eɨcuã tuchɨ ũquɨ̃. Adulterio, ɨ que ũquɨ̃ je ra. Ae eru mombo, emo aque rerequia mose, eɨcuãte ũquɨ̃ abe no. ");
INSERT INTO srqNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sã mbaecha tuchɨ mo ndiqui no. Huɨɨrao turã mingue mingue beɨ. Huɨɨrao nininya mingue mingue beɨ. Fiesta que esaã saã mbeɨ quia ra. Umbae mbae isiquia mumba chooño mbae rese. ");
INSERT INTO srqNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sã mbaecha reã mo abe riqui no. Lázaro, ɨ que ee ra. Erete reechu echu que ra. Huee que Lázaro riqui chɨ̃ mbeɨ ngoi ra. Mbaecha chuchua taronda jii. ");
INSERT INTO srqNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lázaro riãcuã ngue ñee mbeɨ quia ra. “Mbaecha chɨu rire nda au rã ña”, ɨ tuchɨ que equia uchɨangui re ra. Ñooñoo ngue ngaẽ ngaẽ nguia erete reechu rere rere ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lázaro mbaecha reã ngue mano cote ra. Angeles que equerao mbae turãsa Abraham ndea ra. Mbaecha abe que mano nda. Mbia que echati ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mbaecha que oso tata cuasu cote ra. Isho que mae Abraham ndese ra. Lázaro abe. ");
INSERT INTO srqNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sã ñeemombo mombo Abraham je no. “Paba Abraham, ndeya eã jiri serese ae. Serasite aɨco tata réndii a. Lázaro embu rã. Sã o mbia rã i je sechuru mbia sacuã”, ɨ rei que mbaecha ñeemombo Abraham je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham ngue ñee ee cote ra. “Mbae tubɨrɨãte que nembae nyii resẽ. Lázaro quiatu que mbae rasi saã tuchɨ quia nyii ra. A eriqui turãte a cote, nde nderasi rasi mose cote. ");
INSERT INTO srqNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","A jenda mo oso aroneate erasa ndeje hue. Hue jenda abe tu aroneate erasa ure je aa no”, ɨ que Abraham mbaecha je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mbaecha que ñeemombobe Abraham je ra. “Lázaro chõ emondo Paba chuchúaa no, Abraham. ");
INSERT INTO srqNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Hue senongue cinco chɨ hue. Sã Lázaro sɨ ñee ee. Embiirandu. Ɨ̃ nda ecuaẽ eã mbae rasi raã a”, ɨ rei que mbaecha ñee Abraham je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham ngue ñee ee ra. “Ndenongue Moisés chɨmbesa rerequia hue. Dios cheẽ mbuchecuasa cheẽ abe rerequia hue no. Sã ũquɨ̃ mumbayã”, ɨ que Abraham ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mbaecha que ñeembe Abraham je ra. “Embesa ji rerequia raque. Mano je oso mose ñee ee, aque cheẽ nguia ra emumbayã cote. Huɨɨcuã nda esecha cote”, ɨ rei que mbaecha ñee Abraham je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham ngue ñee ee ra. “Ndenongue Moisés chɨmbesa mumba mumba mose, mano je cheẽ abe ra emumba no. Eraaque mo quera sɨ je ñee mose ee, aque cheẽ abe ra emumba no”, ɨ que Abraham ñee mbaecha je ra, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús que ñee uchɨmbaaquiatu je ra. —Mbae ɨcuã nguiarei siqui beɨ tuchɨ mbia mbɨɨcuã nonde. Ae ñee nguia mbia je nae, “mbae ɨcuã esaã” ɨ nae, eɨcuã tuchɨ chõ ũquɨ̃ nde. Ae “mbae ɨcuã esaã” ɨ nae, ũquɨ̃ nda mbae rasi saã tuchɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ae ra mbae ɨcuã saã uquia seɨcuasa mo je nae, ũquɨ̃ nda mbae rasi saã tuchɨ cote. Ũquɨ̃ nda aba mombo chõ ama ndɨsa ye nyii re chã. Sɨta resebe ecua ji mondo. Ɨ̃ nda mbae ɨcuã naa uquia eãte rei seɨcuasa je. ");
INSERT INTO srqNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Jẽɨngo chooñoa ño nguia jẽ! Nderesenda ɨcuã mose ndeje, echeẽ ño ee. “Nandeɨco turã ño”, ere ee. Huɨ mose huɨɨcuã sɨ, eɨcuã sɨ etesareɨ chõ nde. ");
INSERT INTO srqNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sã nderesenda mbae ɨcuã naa naa siete veces ndeje no. Sã ñee ndaque siete veces ndeje no. “Mbae ɨcuã nda asaã eã ndeje cote”, sã ɨ raque ndeje no. Eɨcuã sɨ etesareɨ chõ, eɨcuã mbeɨ beɨ raque, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesús chɨmbaaquiatu que ñee ee ra. —Dios eɨcua tuchɨ rã ure je, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesús que ñee ee ra. —Jẽ Dios ɨcua jiri mose, ɨ̃ nda mbae mo jeñee mumbayãte rei. Ɨ̃ nda jeñee ndei ira je. “Nde ae echisiqui. Nde ae sɨ echitiquia ama ndɨsha ite re”, ɨ ira je. Ɨ̃ nda ira jeñee mumbayãte rei, jẽ Dios ɨcua jiri mose. ");
INSERT INTO srqNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Sã emo nimba mo ndiqui beɨ turuquia rɨ̃ ticuasu raarõ arõ no. Ecuasẽ mose tuchúaa, ¿mañɨ nda ererecua ñee jeɨ ee re? “Equiaru rã”, ɨ jeɨ ee re. ");
INSERT INTO srqNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tei. I jeɨ eã nda ee. “Sechɨurã esaã naa seje. Sequiaru eteaquiatu rã nyii. Aquere quia terequiaru nde”, ɨ chõ nda ererecua ee. ");
INSERT INTO srqNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ererecua ra gracias ɨ eã ngũimba je. Erimbachõ ño ñene. ");
INSERT INTO srqNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Eɨ̃ sɨ chõ jẽ no nde. Dios rimbachõ ño jẽ no nde. Ae rɨɨ̃ Dios riqui ñee jẽje, ũquɨ̃ naa ja mose, ¡jẽɨngo mingue chõ nguia ee jẽ! “Ae rɨɨ̃ Dios ñee nande je nae, ũquɨ̃ mɨɨ ño ngue nandesaã nda. Erimbachõ ño nande re”, jenye chõ nguia ico mingue, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús que ngata sɨ Jerusalén ɨcha ruɨ ra. Galilea rɨ̃ ngue écoɨ quia ra. Samaria rɨ̃ abe que écoɨ quia ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jesús que ngasẽ sucha tubɨrɨã moo nda. Hue que mbia rasi mo chɨ ee ra. Diez que ra. Eɨre rasi ja que ra. Lepra, ɨ que ũquɨ̃ mbia rasi je ra. Erasi que chɨ ɨcúe ɨsho jiri Jesús sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ũquɨ̃ mbia rasi que ñeemombo mombo Jesús je ra. —¡Jesús! ¡Mbia mbaaquiatusa! Urembucherõ na ae, ɨ que ñeemombo mombo ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús que mae erese cote ra. Ñee ngue ee ra. —Eno. Jẽso jendete reacuquia sacerdotes je, ɨ que Jesús ee ra. Ecuata mose chõ ngue nyerõ ja ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ucherõ ndese mae mose que co mɨɨ ndu nyebi ñee Jesús je ra. Eya tuchɨ que ñeemombo mombo Dios rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ngoi que ngũíã ndese Jesús resa quiti ra. Nyibi que u ñee ee ra. Gracias ɨ tuchɨ que Jesús je cote ra. Samaria jenda que ae ra. Judío eã ngue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús que ñee nda. —Eatate que ambucherõ. ¿Ma eataque ma nde? ¿Ma nueve ma nde? Nyebiã ñochɨ̃ ecuaẽ gracias ɨ seje. ");
INSERT INTO srqNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Co mɨɨ tuchɨ chõ tuchɨ̃ nyebi gracias ɨ Dios je co. Judío eã ndaque, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesús que ñee erasi je cote ra. —Ehuã. Eso cote. Nde que seɨcua ra. Nyebe arembucherõ nguiã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","—¿Manosete ra Dios ru íbii mbia rerecuarã tuchɨ re? ɨ que fariseos ñee Jesús je ra. Jesús que ñee ee ra. —Mbia ra mae eã erese. ");
INSERT INTO srqNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“¡Aa chõ Dios riqui mbia rerecuarã jẽ!” ɨã ndae. “¡Pee chõ Dios riqui mbia rerecuarã jẽ!” ɨã nda eno. Mbia chɨangui re quiatu Dios riqui nguiã mbia rerecuarã, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesús que ñee uchɨmbaaquiatu je cote ra. —Namo jiri ra jẽ seoseɨ oseɨ setiã mose cote. “Jesús nda siqui mbɨrɨ̃ na nanderese chã”, jenye rei nda re. ");
INSERT INTO srqNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","“Hue Cristo riqui hue”, ɨchõɨño nda mbia jẽje serɨɨ̃. “Pe eriqui pe”, ɨchõɨño nda jẽje no. “Nyia” jenyechɨ̃ nda ee jẽ. Ñeeñooño ndae. ");
INSERT INTO srqNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sechecuayã nguia ra achuã. Mbia ra mae ja quiatu senininya rese seru mose. Sã mbia riqui mae jate ama pirirã ɨ rese no. Eɨ̃ ae quia ra u mbia mumae ja. ");
INSERT INTO srqNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sechube nonde ra mbia ɨcuã tuchɨ seje. Mbae rasi ra asaã tuchɨ rã. Ae siqui namo ã mbia, ũquɨ̃ nda seririrõ tuchɨ rã. ");
INSERT INTO srqNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sã Noé mosenda mbia siqui sereã tuchɨ Dios rese no. Eɨ̃ sɨ ra mbia siqui sereã Dios rese sechu nonde no. ");
INSERT INTO srqNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sã Noé mosenda mbia quiaru chooño no. Ndua rocoɨ̃ Dios rese. Sã ngũinisirã nderequia chooño no. Sã mbae raã ñooño ndua rocoɨ̃ Dios rese no. Sã Noé ɨque chee arca ye no. Sã ama ndicuasu tu cote no. Sã mbia mano ja no. ");
INSERT INTO srqNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Sã Lot mosenda abe mbia no. Sã quiaru chooño no. Sã mbae isi isi chooño no. Sã mbae eɨ̃ tiquia chooño no. Sã uchuchuarã naa ñooño no. Sã mbae raã ñooño no. Ndua rocoĩ Dios rese no. ");
INSERT INTO srqNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sã Lot usẽ nyee hue sɨ cote no. Sã Dios tata mbu ibate sɨ cote no. Sã Sodoma jenda oqueɨ ja aque mose no. ");
INSERT INTO srqNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Eɨ̃ sɨ ra mbia mbae raã ñooño. Seru mose chee. Ndua rocoĩ serese. ");
INSERT INTO srqNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Emo siqui mose taicuee se tu mose, ɨque eã nda uchuchua umbae rerecoquiatu. Ae siqui úcoo, nyebiã nda u uchuchua no. ");
INSERT INTO srqNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","¡Lot ninisi rã nda jẽɨngochɨ̃ jẽ! ");
INSERT INTO srqNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ae ngueteãte quia ngueco rese nae, ereco ra quiachã esɨ. Ae ngueteã eãte quia ngueco rese nae, aque reco quia ra quiachãyã esɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sechu mose, aque isa ra nyeremo chɨ uque quisa ye. Co mɨɨ nda arao. Enongue ra siquichõ. ");
INSERT INTO srqNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cuña nyeremo nda chɨ mbua tocho no. Co mɨɨ nda arao. Enongue ra siquichõ no. ");
INSERT INTO srqNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mbia nyeremo nda chɨ úcoo no. Co mɨɨ nda arao. Enongue ra siquichõ no, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","—¿Mangue ra ũquɨ̃ mangue re, Jesús? ɨ que echɨmbaaquiatu ra. Jesús que ñeembe ee ra. —Ae rɨ̃ mbae raaque riqui chɨ nae, huee ra urubu choɨ ja tuchɨ, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús que ñee uchɨmbaaquiatu je ra. —Sã mbia riqui ñee mbeɨ Dios je. Sã tesareɨã mbeɨ ñee Dios je. ");
INSERT INTO srqNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","3","Sã eru cheecha mo ndiqui no. Oso chɨɨbe ɨbe ñee ererecua je no. “Ae sembae quereco nae, sã aque sembae meembe seje”, ɨ chɨɨbeɨ ɨbeɨ ererecua je. Dios quiatoã ndaque ererecua. Mbia quiato biãte raque aque ererecua. ");
INSERT INTO srqNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Ererecua que eru cheecha cheẽ ñanduchõ nyii ra. Eru cheecha que ñee ɨ ɨ tuchɨ ee ra. Ererecua que ndua chee uchɨangui re ra. “Ari riqui ñee chɨɨbeɨ ɨbeɨ tuchɨchɨ̃ seje co. Echeẽ tamumbayã na”, ɨ chee que ererecua ra, ɨ que Jesús ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ñeembe que ee ra. —Sã ererecua ari cheẽ mumbayã nyee no. Ererecua ɨcuãte raque. ");
INSERT INTO srqNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eɨ̃ nda Dios uquiato cheẽ mumbayã no. Dios quiato riqui ñee ñee mbeɨ Dios je co. Arõ mose. Isa abe. Dios riqui uquiato ucuãyãsa riisu isu raque co. ");
INSERT INTO srqNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Dios ra uquiato cheẽ mumbayã nyee cote. Se tube mose íbii manya sequiato ra chɨ beɨ ñee Dios je reae, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ucuasu raã naasa mo ngue chɨ Jesús je ra. Mbia ataque ririrõte que equia ra. Mbia ataque isi teã teã mbeɨ. Nyebe Jesũs ñee nguiã ũquɨ̃ je. ");
INSERT INTO srqNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Sã mbia nyeremo nyoɨ ɨque Dios chuchua no. Ñee Dios je no. Co mɨɨ ngue fariseo ra. Enongue que impuestos isi isi quia ererecua mbaerã nda. Mbia mbɨɨrɨ̃ ɨrɨ̃sa que ae ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo que ñee ndei Dios je ra. “Dios, seturãte se. Mbia ɨcuã na eã ño se re. Co mbia mbɨɨrɨ̃ ɨrɨ̃sa rã eã ño se re. Mbae mbuquiachãsa eã ño se no nde. Acheẽ ñooño eã ño se re. Emo ninisi rese aɨcoãte se. Mbia ambɨɨrɨ̃ ɨrɨ̃ ãte quia co. ");
INSERT INTO srqNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aquiaruã mocoɨ̃te quia ndua beɨ nderese co. Diezmos amee mee mbeɨte quia ndeje co”, ɨ rei que fariseo ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Aba mbɨɨrɨ̃ ɨrɨ̃sa que chɨ̃ ɨsho ra. Uãquĩ ngue embucheseco ibi quiti ra. Uchɨã ngue eisi ñee Dios je ra. “Ndeyayã ño serese, Dios. Mbae ɨcuã asaã saã mbeɨ chõchɨ̃ nguia co. Seyayã tuchɨchɨ̃ seɨcuã ndese”, ɨ que ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tacheẽ nyecua rã jẽje. Dios que aba mbɨɨrɨ̃ ɨrɨ̃sa cheẽ isi turã nda. Ɨco minguete quiatu nguiã ñee ñee Dios je. Fariseo quiatu ngue uturã saã saã mbeɨte nguiã ñee Dios je. Nyebe Dios echeẽ ñanuate nguiã. Ae ucuasu saã saã nguia nae, ũquɨ̃ nda Dios isiãte. Ae ɨco tochei quia Dios je, ũquɨ̃ nguiatu ra Dios isi, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mbia que nguiirĩ ngurucuaẽ cuaẽ nguia Jesús je ra. Jesús oco oco sacuã erese. —¿Mbaerã jendiirĩ jendu quia co re? ɨ rei que Jesús chɨmbaaquiatu ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús quiatu que ñee nda. —Tei. Jẽsecha. Sã nguiirĩ ndurucuaẽ seje. Eɨ̃ ño Dios rimba re. Mbia riirĩ na. Ucuasu raã naa eã. ");
INSERT INTO srqNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mbia riirĩ na ño jẽɨngo Dios isi turã. Eɨ̃ jenye mose, Dios rimba tuchɨ ra jẽ cote, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ererecua mo ngue ñee Jesús je ra. —Mbia mbaaquiatusa turãte nde. ¿Mañɨ ae ra se siqui beɨ nonde ibate re? ɨ que ererecua ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús que ñee ee ra. —¿Mbaerã ereɨco eturã ɨ seje re? Dios mɨɨ ño eturã ndesẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Dios cheẽ ereɨcuate resẽ: “Emo ninisi rese ra ereɨcochɨ̃. Mbia mo nda ereɨquiachɨ̃ no. Mbae ra erembuquiachãchɨ̃. Erecheẽ ñooñochɨ̃ nda emo nɨɨ. Ndeturã ño nderu je. Ndeturã ño ndesi abe je”, ɨ que Dios cheẽ nda, ɨ que Jesús ñee ererecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ererecua que ñee ndei Jesús je ra. —Ũquɨ̃ ngue amumbayã ja beɨ quia ra. Señetẽ mosenda beɨ, ɨ rei que ererecua ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesús eandu mose que ñee ee ra. —Mbae mɨɨ mo abe eresaã eãte. Ã abe esaã. Nembae emondo mondo ja mbia mbaecha reã je. Nde ũquɨ̃ naa mose, mbae tubɨrɨã nda nde, ndeɨco mose ibate. Nembae mondo ja mose mbaecha reã je, seruɨ eɨco cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ererecua Jesús cheẽ andu mose que echosoi oso serɨ̃te cote ra. Mbaecha tuchɨte quiatu ngue ae re. ");
INSERT INTO srqNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús que mae mbaecha ia eã ndese ra. Ñee ngue mbia je cote ra. —Mbaranguiatu ãte mbaecha je ngasẽ sacuã ibate Dios rese. ");
INSERT INTO srqNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sã ticuasu mo ndiqui oso aroneate aguja sorei rɨ̃ no nae. Eɨ̃ sɨ chõ mbaecha no nde. Oso aronea ibate Dios rese, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","—¿Aba quia ra oso Dios rea re no? ɨ que mbia Jesús je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús que ñee ee ra. —Ae mbia saã aroneãte quia nae, Dios mɨɨ ño nda esaã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro que ñee Jesús je ra. —Ure que urembae uresecha ja ra. Siqui sacuã nderuɨ, ɨ que Pedro ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús que ñee ee ra. —Emo umbae recha ja mose Dios rɨɨ̃, Dios ra esɨbɨshorõ tuchɨ ee. Ae uchuchua secha. Ae ngu secha. Ae usi secha. Ae ngõngue secha. Ae ngũinisi secha. Ae nguiirĩ secha. ");
INSERT INTO srqNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ũquɨ̃ mbae ja ra Dios sɨbɨshorõ tuchɨ. Ibii mbia reco beɨ mose. Aquere ra Dios emingo beɨ ibate cote, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús que ñee ɨcúee uchɨmbaaquiatu doce je ra. —Co nandeso quia Jerusalén co. Ae Dios cheẽ mbuchecuasa mbesa mbesa quia serɨɨ̃ nyii nae, ũquɨ̃ nda ɨo ja cote. ");
INSERT INTO srqNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mbia ra semee judíos eã je cote. Mbia ra secheẽ naa naa. Ñee ɨcuã tuchɨ ra seje. Ñinimbu nimbu ra serese. ");
INSERT INTO srqNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Seiruã nua ndae. Seɨquia ra cote. Tres nyaashɨ̃ mose ra aquera sɨ, ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Echɨmbaaquiatu que echeẽ ɨcuayãte ra. —¿Mbae rɨɨ̃ eriqui ñee nande je re? ɨ que nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús Jericó rurubi mose que eresayã mo ndiqui ee ra. Ñeenda jie que eñɨ ache ache ɨ mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eresayã ngue mbia tubɨrɨã quɨcoɨ chandu ra. —¿Mbae ere? ɨ que eresayã emo je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Co Jesús coɨ quia co. Nazaret jenda coɨ quia co, ɨ que emo eresayã je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Eresayã ngue ñee mombo ra. —¡Jesús! ¡David rucucha! ¡Ndeya eã ño serese jẽ! ɨ que eresayã ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ae rane nyoɨ quia, ũquɨ̃ ngue ñee ndei eresayã je ra. —¡Equɨrɨrɨ chõ jẽ! ɨ rei que ee ra. —Jesús, ¡ndeya eã ño serese jẽ! ɨ bei beɨ que Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús que tiba cote ra. —Eresayã jendu rã, ɨ que mbia je ra. Eresayã ngue oso Jesús rɨɨchã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Mañɨ ae ra ndeje re? ɨ que Jesús ñee ee ra. —Seresa embuturã na, Sererecua, ɨ que eresayã nda. ");
INSERT INTO srqNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús que ñee ee ra. —Nderesa que cote ra. Seɨcuate quiatu ngue se re. Nyebe arembucherõ nguiã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aque mose tuchɨ que eresayã ndesa turã cote ra. Mae turã ngue cote ra. Jesús ruɨ que esɨ quia cote ra. Ñee turã turã tuchɨ que equia Dios rɨɨ̃ cote ra. Ae mae erese nae, ũquɨ̃ abe que ñee turã ja quia Dios je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús que ngasẽ Jericoo cote ra. Sucha tubɨrɨã ite rɨ̃ ngue esɨ quia ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mbia mbaecha mo ngue siqui ee huee ra. Zaqueo, ɨ que ee ra. Aba mbɨɨrɨ̃ ɨrɨ̃sa que ae ra. Impuestos isi isiquia rerecua que ae ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","—Jesús rese tamae. Jesús taɨcua rã, ɨ rei que Zaqueo ra. Mbia tubɨrɨã ngue Jesús chatite esɨ ra. Zaqueo jua tuchɨ que ra. Nyebe mae aroneate nguiã Jesús rese. ");
INSERT INTO srqNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Zaqueo que oso uchã Jesús nonde ra. Nyuɨ que oso ira mo ñɨ nda. Jesús ucua rese mae sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús que ngasẽ Zaqueoqui re cote ra. Soboiba que mae erese ra. —Equichi, Zaqueo. Taso ndechuchua nderese, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueo que nguichi asi u cote ra. Eyate que Jesús rerao uchuchúaa ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mbia que ñee ñee tuchɨ Jesús rɨɨ̃ cote ra. —¿Mbaerã Jesús sɨ quia mbia ɨcuã nyuchúaa aque re? ɨ tuchɨ que mbia ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueo que juã ñee Jesús je ra. —Sererecua, tacheẽ ndeje. Sembae tachisia nyibite rɨ̃ mondo sacuã mbia mbaecha reã je. Ae asirõ ñooño mbia sɨ nae, ũquɨ̃ tambuchebibe ee. Eata tambuchebibe ee, cuatro veces, ɨ que Zaqueo Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús que ñee ee cote ra. —Arerirõ ngue mbae ɨcuã sɨ namo nda. Judiote quiatu nde re. ");
INSERT INTO srqNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Quiachã je requia chõ achu nguiã ibate sɨ co. Quiachã je mingo beɨ sacuã abe chõ achu nguiã ibate sɨ co no, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mbia que Jesús cheẽ ñandu turã nguia ra. Jerusalén ndurubite que echoɨ quia ra. —Mbia rerecuarã ja ra Jesús cote reae, ɨ rei que mbia quia ndua ndua ra. Nyebe Jesús ñee nguiã ee. ");
INSERT INTO srqNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Sã mbia mo ndiqui oso ibimo ɨsho tuchɨ no. “Mbia rerecuarã eɨco nde cote”, ɨ nonde mbia pe jenda ee. Aquere ra eru mbia rerecuarã cote. ");
INSERT INTO srqNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sã ñee ja ngũimba je oso nonde no. Diez rei erimba. Mbae isiquia atate que embuchao chao ngũimba je ra. “Ã mbae isiquia jembaata ata oso quia. Sechu mose chee”, ɨ que ngũimba je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Sã hue jenda mbia aque ucuãyãte no. Comisión ngue emondo ra. “Aque urebiãte urererecuarã”, ɨ rei que comisión mondo ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Gobierno ngue emɨɨ mbeɨ chõ ererecuarã nda. Nyebe uba beɨ u nguiã uchuchua cote. Ngũimba je que ñee cote ra. Ũquɨ̃ diez. Ae je eriqui mbae isiquia mondo nae, ũquɨ̃. “¿Sechɨmee mbae isiquia jembaata ata rei re?” ɨ jaaja que ngũimba je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Erimba mo ngue ñee ee ra. “Ae. Aque mɨɨ ngue eremee ndei seje nyii, ambaatate que se cote ra. Diez que cote ra”, ɨ que nguerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ererecua que ñee ee ra. “Coche ñene. Serimba turãte nde. Mbae ñetẽ ngue eresaã turãte quia secheẽ nguire ra. Nyebe mbae cuasu tamondo ndeje cote. Diez pueblos rerecuarã nda nde cote”, ɨ que ererecua ngũimba ñiinda je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Erimba nongue que tu ñee ee cote ra. “Aque mɨɨ ngue eremee ndei seje nyii, ambaatate que se cote ra. Cinco que cote ra”, ɨ que nguerecua je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ererecua que ñee ae abe je no nda. “Eno. Cinco pueblos rerecuarã nda nde cote”, ɨ que aque ngũimba je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Erimba nongue que tu ñee ee cote ra. “Co nembae mbae isiquia co. Tiru ye que areco beɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Sesiquichete quiatu ngue ndesɨ re. Erequeteãte quiatu nguiã mbae rese. Ndechitiquia eã abe ereɨshao shaote quia co. Nyebe nembae mbae isiquia areco quiatuchõ ño nguiã ndeje”, ɨ que aque nguerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ererecua que paama ɨ tuchɨ ñee ee ra. “Serimba ɨcuã tuchɨchɨ̃ nde re. Nde sɨ́ chõ erecheẽ nguiã sembiirandu. ‘Nembae que ambaata eãte ra’, ere chõchɨ̃. ‘Areco quiatuchõ ño nguiã’, ere chõchɨ̃. Se ngueteã mose mbae rese ndeje ¿mbaerã secheẽ eremumba re? ");
INSERT INTO srqNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Mbaerã sembae mbae isiquia eremondo eã banco re? Ɨ̃ nda ñɨmbaata jiri rei seje”, ɨ que ererecua ñee asi aque ngũimba je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ae chɨ huee, ũquɨ̃ je que ererecua ñee nda. “Ae sembae quereco chooño nguia nae, jẽsirõ na esɨ. Ae diez quereco quia nae, aque je jemondo”, ɨ que ererecua ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mbia que ñee ererecua je ra. “¿Mbaerã nda re? Eatate ae resẽ. Diez que ae resẽ. ¿Mbaerã nda emo abe eremondo ee re?” ɨ que mbia ñee ererecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ererecua que ñee ee ra. “Ae embaete nae, mbae tamondobe ee. Ae mbae quereco ãte quia nae, embae tasirõ ja esɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Seucuãyãsa jendu ja rã. Ae ñee nguia serɨɨ̃. ‘Aque urebiãte urererecuarã’, ae ɨ quia serɨɨ̃. Ũquɨ̃ jendu ja. Ũquɨ̃ jẽɨquia ja sésaa”, ɨ que ererecua ra, ɨ que Jesús ñee mbia mbaaquiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús cheẽ jare que ngata sɨ Jerusalén ɨcha ruɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jerusalén ndurubite que echoɨ ngasẽ nda. Betfagé, ɨ que hue sucha je ra. Betania, ɨ que hue sucha erurubinda je no nda. Ibi ibate abe que chɨ̃ huee ra. Monte de los Olivos, ɨ que ee ra. Hue sɨ que uchɨmbaaquiatu nyeremo mondo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Aɨchɨ súchaa chõ jẽso rã. Burro riirĩ cuasa ra chɨ̃ jẽje hue. Ae ato emo nyuɨ ãte. Jenyura seru seje. ");
INSERT INTO srqNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“¿Mbaerã nda jenyura re?” ɨ mose emo jẽje, jeñee ee. “Nandererecua que jendu ɨ ra”, jenye ee, ɨ que Jesús ũquɨ̃ nyeremo mondo ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nyoɨ que súchaa ra. Ae rɨɨ̃ Jesús ñee ee nae, ũquɨ̃ ngue nyecua ja ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Burro riirĩ ngue etea ra. Era mose que echa ñee ee ra. —¿Mbaerã jẽɨngo era era re? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jesús chɨmbaaquiatu que ñee ee ra. —Nandererecua que jendu ɨ ra, ɨ que echa je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Burro riirĩ ngue ecuruchoɨ Jesús je cote ra. Echɨmbaaquiatu que huɨɨrao chono ñono burro arõ nda. Mbia que Jesús mbuchuɨ burro ato cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús ngata mose burro ato, mbia que huɨɨrao mbiitee ee ibi rɨ̃ nda. Jesús nonde. Jesús oso sacuã hue rɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jesús quiato tubɨrɨã tuchɨ que nyoɨ quia erese ra. Monte de los Olivos ɨcha re ngasẽ mose, Jesús quiato que tasẽ tasẽ tuchɨ ra. Eya tuchɨ que ra. Ñee mombo mombo turã ngue Dios je cote ra. —Jesús riqui mbia mae sayã naa naa tuchɨ mbia je co, ɨ que ñee mombo mombo turã Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mbia ia tuchɨ que tasẽ tasẽ nda. —Co nandererecua ru quia ngasẽte co. Co Dios chɨmbu ru quia ngasẽte nande je co. Dios turã tuchɨte nande je, ɨ que mbia ia tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Fariseos mo abe que chɨ huee ra. Ũquɨ̃ ngue ñee ndei Jesús je ra. —Ndechɨmbaaquiatu embaasẽ asẽ eã jiri ae, ɨ rei que Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús que ñee ee ra. —Sequiato ñeemombo mombo eã mose serɨɨ̃, eɨ̃ ndei ra sɨta ñeemombo mombo serɨɨ̃ cote, ɨ que ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús que ngasẽ serɨ̃te oso quia Jerusalén cote ra. Sucha checuate que esɨ quia ee cote ra. Jesús ia eã tuchɨ que Jerusalén ndese ra. Nyeseo que erese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jesús que ñee sucha tubɨrɨã je cote ra. Jerusalén je. —Seyayã tuchɨ aɨco nderese co, Jerusalén. Mbia mbiasa ereɨcuayã mbeɨ chõchɨ̃ nguia co. Echecuayã mbeɨ chõ eriquichɨ̃ ndeje co. ");
INSERT INTO srqNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mbae rasi ra eresaã tuchɨ cote. Ndeucuãyãsa ra nderiquisã tuchɨ cote. Nemama nda ecuaẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sucha ra embucoɨ ja ndeyenda. Sɨta ra embucoɨ ja tuchɨ mbia chuchua sɨ. Mbia ra mano ja ndeyenda cote. Dios quiatu ngue ereisiã mbeɨte nguiã. Dios sembu mose nderea, aque mose abe que seisiãte no nda, ɨ que Jesús ñee Jerusalén je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús que oso Dios chuchúaa ra. Huee que mbia riqui mbae isi isi querabe ra. Mbae mondo mondo abe mbae isiquia rɨbɨshorõ. Jesús que ũquɨ̃ mombo ja Dios chuchua sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesús que ñee mbia je ra. —“‘Mbia cheẽsa Dios je’, ɨ ra mbia Dios chuchua je”, ɨ que embesa ji ra. Jẽ nguia jẽɨcuã tuchɨte Dios chuchua je re. Mbae mbuquiachãsa chuchuarã ño jẽsaãte chɨ̃ nguiã Dios chuchua je, ɨ que Jesús ũquɨ̃ je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesús que mbia mbaaquiatu quiatu beɨ quia Dios chuchúaa ra. Ererecua cuabẽte que mae ɨcuã ɨcuã nguia erese ra. Sacerdote rerecua. Embesasa abe no. Mbia rerecua ja. Ũquɨ̃ ererecua ja que ñee ñee nguia nyue ra. —¿Mañɨ nande ra equia Jesús ɨquia sacuã nde? ɨ que ererecua quia ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ererecua que Jesús ɨquia aroneate ra. Mbia tubɨrɨãte quiatu que Jesús chandu quia ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Emo mose que Jesús riqui mbia mbaaquiatu quiatu Dios chuchúaa ra. Ererecua que ngaẽ ja ñee ee ra. Sacerdote rerecua. Embesasa abe no. Ameɨ abe no. ");
INSERT INTO srqNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ũquɨ̃ ngue ñee ja Jesús je ra. —¿Mbaerã ereɨco mbia mbaaquiatu quiatu re? ¿Aba “mbia embaaquiatu quiatu” ɨ ndeje re? ɨ que ererecua ja Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús que ñee ee ra. —Se rane tacheẽ jẽje. Se rane preguntar tae jẽje. ");
INSERT INTO srqNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Aba ñee Juan je re? “Eso bautizar ɨ mbia je” ɨ ee re. ¿Dios eã ño ere no? Jeñee seje, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ererecua que ndua ndua ja u ra. Ñee ñee ngue u nyue ra. —¿Mañɨ nande ra echeẽ ndobeɨshɨ̃ nde? “Dios que Juan mbu ra”, nande aroneate. Eɨ̃ nda ñee nande je. “¿Mbaerã jẽɨngoãte eruɨ re no?” ɨ quiarei ra nande je. ");
INSERT INTO srqNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Dios eã ngue embu ra”, nande aroneate no. Mbia ataque ra paama ɨ tuchɨ nande je. Nandeɨ eɨ ra sɨta je. Juan quiato tuchɨ que mbia, ɨ que ererecua ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ererecua que ñee nyee Jesús je ra. —Ureɨcuayãte. Aba chõ Juan mbu. Bautizar ɨ sacuã, ɨ que ererecua ñee ja ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesús abe que ñee ee cote ra. —Se abe ra acheẽ eã jẽje no. Aba chõ “ã esaã” ɨ seje. Acheẽ eã nda jẽje no, ɨ que ererecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús que mbia mbaaquiatu quiatu cote ra. —Sã mbia mo ndiqui no. Sã ibicha mo ndiqui no. Sã ibicha riqui uva i tiquia tiquia no. Sã ibicha riqui “sembae uvas jẽsaarõ”, ɨ emo je no. Sã eriqui oso itõte no. ");
INSERT INTO srqNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uva quiche mose que echa ngũimba mo mondo rei umbaerã ndea ra. Ae uva saarõ nguia nae, ũquɨ̃ ngue eisi ɨcuã tuchɨ ra. Ucua ucua que erese ra. Eochɨ que emondo mbuchebi ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Echa que ngũimba mo mondo rei ereabe no nda. Aque abe que eraarõsa isi ɨcuã no nda. Ucua ucua que aque abe rese no nda. Eochɨ que emondo mbuchebi ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Echa que emo abe mondo rei ra. Aque abe que eiruã nua mondo mbuchebi no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Echa ia eãte que ra. “¿Mañɨ ae ra se re? Seriirĩ quiatu tamondo erea cote. Ũquɨ̃ nda ɨreɨ̃ ɨreɨ̃ jiri esɨ cote reae”, ɨ rei que echa ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Uva raarõsa mae mose erese que ñee nyue ra. “¡Co eriirĩ ndu quia co cote jẽ! ¡Nandeɨquia rei jẽ! Ɨ̃ nda uvas nandembaerã ae cote”, ɨ que ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eraarõsa que eriirĩ querao pe jiri eɨquia ra. Eriirĩ ngue mano cote ra. ¿Mañɨ nda echa quia eraarõsa je cote re? ");
INSERT INTO srqNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Echa ra oso eraarõsa ɨquia ja cote. Ibi ra emondo emo je cote. Eraarõ sacuã, ɨ que Jesús mbia je ra. —¡Ũquɨ̃ nda ɨquechɨ̃ jẽ! ɨ que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús que mae erese ñee ee cote ra. —¿Ã embesa ji rese jemae ãte re? Sã emo ndiqui tuchua ao sɨta je no. Sã sɨta mo ndirirõ mombo no. Eɨcuãte eriqui reĩ nguiã ee. Aquere Dios emundua sɨ erese. “Earonda sacuã turambi chõ eriqui re”, ɨ ndua sɨ uchɨmombo rese. Sã uchɨmombo rirõ sɨ cote no, ɨ que embesa ji ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ae ra nyoɨ ngoɨ aque sɨta arõ nae, ũquɨ̃ nda huẽ. Aque sɨta ngoɨ mose emo arõ, ũquɨ̃ nda mano, ɨ que Jesús ra. —Aque sɨta rã ndei se, ɨ chõ ngue re. ");
INSERT INTO srqNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","—Nanderɨɨ̃ ño Jesús riqui nguiã ñee a. Nandeisi rei serao jẽ, ɨ rei que sacerdotes rerecua ñee nyue ra. Embesasa abe no. Ũquɨ̃ ngue paama ɨ ja Jesús je ra. Jesús isi aronea tuchɨte que mbia résaa ra. Eɨreɨ̃te quiatu ngue mbia tubɨrɨã sɨ re. ");
INSERT INTO srqNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ererecua que mbia ɨcuã mondo mondo quia Jesús cheẽ andu andu ra. —¡Jẽturã jẽsaã saã oso Jesús je jẽ! ¡Echeẽ ndese jenyiisaquia quiatu ure je jẽ! Mbae mo nɨɨ ñee ɨcuã mose, ¡nandeisi rei jẽ! Ererecua tuchɨ je nandemondo cote, ɨ ja que ererecua ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ae chɨ uturã naa naate Jesús je nae, ũquɨ̃ ngue ñee ee ra. —Jesús, co ereɨco mbia mbaaquiatu quiatu turãte co. Mbia jaje ndeturãte riqui co. Mbia erembaaquiatu quiatu turãte quia Dios ɨcha rɨɨ̃ co. ");
INSERT INTO srqNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nyebe ureɨco nguiã ñee ndeje a. ¿Coche mbia mbae isiquia mee mee mose Romano nderecua je re? ¿Uremee nda ee re? ¿Uremee eã nda ee re no? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús que ũquɨ̃ ɨcuã ɨcuate ra. Nyebe ñee nguiã ee. —¿Mbaerã jẽɨngo “ɨ̃ nda Jesús ucheẽ nyabi”, ɨ seje re? ");
INSERT INTO srqNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Mbae isiquia mo jẽteacuquia ɨmbu seje. ¿Aba mbae nombre ñɨ mbae isiquia rese a re? ¿Aba ãquĩ aingue abe ñɨ a re? ɨ que Jesús ee ra. —Romano nderecua, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús que ñee ee cote ra. —Romano nderecua mbaerã jemee ño ee. Dios mbaerã jemee ño ee, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesús que ucheẽ nyabi aroneate ee ra. Ũquɨ̃ ngue nyuruɨra jate u Jesús cheẽ andu ra. Nyebe eriqui ñee eã ee cote. ");
INSERT INTO srqNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","—Mbia raaque ra quera eã mbeɨ, ɨ que mbiamo nguia ñee nda. Saduceos ɨ que ũquɨ̃ je ra. Ũquɨ̃ mo ngue nyoɨ ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Ã ngue Moisés mbesa nande je ra: “Emo eriiriã mano mose, ngũinisi recha mose, sã enongue mano je ninisi rerequia. Sã tiirĩ ngõngue raaque rɨɨ̃”, ɨ que Moisés embesa nande je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sã eriquii mo ndiqui no. Eribi que seis ra. Eriquii que ngũinisirã quereco rei ra. Mano ño ngue tiirĩ ndocoɨ̃ ngũinisi recha ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Enongue que nguiquii cheecha quereco rei cote ra. Ae abe que mano ño tiirĩ ndocoɨ̃ no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Enongue abe que equereco rei cote no nda. Ae abe que mano ño tiirĩ ndocoɨ̃ no nda. Ũquɨ̃ seis ja que ngõngue cheecha quereco ja rei ra. Mano ja tuchɨ chõ ngue tiirĩ ndocoɨ̃ no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Eninisi eru cheecha abe que mano ño nyee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Siete que eru nyii resẽ. Mbia raaque quera sɨ mose, ¿abate ra equereco cote re? ɨ que saduceos ñee Jesús je ra. —Ma Jesús ñee ɨcuã no, ɨ chõ ngue re. ");
INSERT INTO srqNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús que ñee ee ra. —Aa chõ mbia riqui nguiã ngũinisi rerequia querabe. Siqui mose íbii. ");
INSERT INTO srqNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ae raaque ra Dios mbuquera sɨ nae, ae ra Dios mingo beɨ nyɨese nae, ũquɨ̃ nda ngũinisi quereco eã mbeɨ huee cote. Ũquɨ̃ nda ngu quereco eã mbeɨ huee cote no. ");
INSERT INTO srqNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Huee quiatu ra mbia manoã mbeɨ. Angeles rã mbeɨ ra mbia riqui huee cote. Dios riirĩ tuchɨ ra eriqui huee mose cote. Embuquerái quiatu ra cote. ");
INSERT INTO srqNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisés abe que mbia mbiirandu ra. “Mbia raaque quera quera beɨ quia co”, ɨ que Moisés ra. “‘Se rei Dios. Abraham nderecua chõ aɨco nguiã co. Isaac nderecua abe. Jacob nderecua abe no’, ɨ que Dios ra”, ɨ que Moisés embesa ra. Ira ruri rendi mose que Dios Moisés mbiirandu ũquɨ̃ ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ũquɨ̃ mano ndaque nyii. Ũquɨ̃ ndeco siqui beɨ chõ nguiã ũquɨ̃. Mbia raaque rerecua eã ño Dios re. Mbia reco rerecua chõ ñene. Mbia reco ja chõ siqui nguiã Dios je ã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","—Ndecheẽ turãte, ɨ que embesasa mo ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ae “Jesús nandembɨɨcuã” ɨ rei quia, ũquɨ̃ ngue ñee eã Jesús je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús que ñee mbia je ra. —Se abe tacheẽ jẽje cote. ¿Mbaerã mbia riqui ñee nde? “David rucucha chõ Cristo re” ɨ re. ");
INSERT INTO srqNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David sɨ que “sererecua” ɨ Cristo je ra. Sã David chɨmbesa Salmos no: Dios que ñee Cristo sererecua je ra. “Ecoi sejii. Nde abe ra ererecua serese. ");
INSERT INTO srqNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ae ndeucuãyãte quia nae, ũquɨ̃ je ra ndequirãcuã ateacuquia tuchɨ. Ndequirãcuã tuchɨ chee ra ũquɨ̃ sɨ”, ɨ que Dios sererecua je ra, ɨ que David embesa ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David sɨ chõ “sererecua” ɨ nguiã Cristo je. ¿Mañɨ nda David rucucha Cristo re? Jeñee ño seje, ɨ que Jesús ũquɨ̃ je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mbia ja résaa que Jesús ñee uchɨmbaaquiatu je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—¡Embesasa rã ño nda jẽɨngochɨ̃ je! Ũquɨ̃ ucuasu saã saã mbeɨte quia ã. Huɨɨrao turã equereco beɨte quia ã. “Sã mbia ererecua ɨ nande je”, ɨ beɨte equia ã. Mbia renda turã abe eirabo rabo beɨte quia mbia sɨ ã. “Fiestacha jii quia taɨ̃ jẽ”, ɨ abe beɨ equia ã no. ");
INSERT INTO srqNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ari eru cheecha mbae abe embutiã tiã nguia ã no. Ucheẽ oco abe esaã saã mbeɨte quia Dios je ã no. “Ɨ̃ nda mbia mae nanderese”, ɨ chõ nguiã. Ũquɨ̃ nda Dios mbasi tuchɨ cote, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús que nyoɨ nyoɨ quia Dios chuchúaa ra. Hue que mbia mbaecha riqui ofrenda mondo mondo ofrenda riru ye ra. ");
INSERT INTO srqNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Eru cheecha abe que siqui ra. Ae que centavos nyeremoño mondo ofrendarã nda. Mbaecha reãte quiatu ngue ae re. ");
INSERT INTO srqNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús que ñee nda. —Tacheẽ tuchɨ jẽje. Eru cheecha mbaecha reã ngue mbae mondo tuchɨ mbia ataque sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mbaecha quiatu que umbae rire ñetẽ mondo mondo ra. Eru cheecha quiatu nbbbbknnnkknnnnnn gue umbae mɨɨ mondo ja nguiã, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mbia que ñee ñee Dios chuchua turã nɨɨ nda. Tuchua mbarõ ji sɨta turã nɨɨ. Mbae aba queteamba rɨɨ̃ abe no, Dios chuchua jenda. Jesús que ñee mbia je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ae rese jẽɨngo mae nae, ũquɨ̃ nda mbiamo mbutiã ja cote. Sɨta mo nda chɨ eã nyuchuarõ cote. Mbia ra tuchua mbucoɨ ja tuchɨ. Dios chuchua ra chɨ̃ eã juã cote, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","—¿Manose ra ũquɨ̃ nde? ¿Mañɨ ure ra equia irandu mbae ua nonde re? ɨ que Jesús chɨmbaaquiatu ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús que ñee ee ra. —Jẽtesa jiri quia jẽ. Mbia ra jembɨɨrɨ̃ ɨrɨ̃chɨ̃ jẽ. “Cristo chõ se re”, ɨ ra mbia ñee ata atate jẽje. “Co rei é co cote”, ɨ ra mbia ñee ata atate jẽje no. Ũquɨ̃ nda jeñanduchɨ̃. Ñeeñooño je chõ ũquɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mbia ra ñee ñee tuchɨ nyɨɨquia ɨquia je rɨɨ̃. Guerra rɨɨ̃ abe no. Ũquɨ̃ mose ra jẽsiquichechɨ̃ jẽ. Ũquɨ̃ ja rane nda nyecua raque. Aque mose ra mbae ja ua eã ná, ɨ que Jesús mbia mbaaquiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","—Mbia ra guerra saã tuchɨ chee. Nyɨɨquia ɨquia tuchɨ rae. ");
INSERT INTO srqNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ibi ra nyere nyere tuchɨ. Mbia mo abe riãcuã tuchɨ ra aque mose. Emo ñooñoa tuchɨ ra mbia rasi. Mbia mae sayã nda nyecua tuchɨ ibei rɨ̃ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ũquɨ̃ nonde ra mbia ɨcuã ɨcuã tuchɨ jẽ je serɨɨ̃. Nguerecua je ra mbia jenderao rao tuchɨ. Ererecua abe ɨcuã ɨcuã tuchɨ ra jẽje. Jẽtarõ tarõ tuchɨ ra serɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ũquɨ̃ mose nda secheẽ jẽsenei senei tuchɨ mbia je chã. ");
INSERT INTO srqNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","¿Manyae ra ũquɨ̃ ñee ndɨbɨshorõ nde? jenyechɨ̃ nda ñee ũquɨ̃ nonde jẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Se chõ nda jaembucheẽ turã nguiã aque mose. Nyebe ra jẽucuayãsa jeñee ndɨbɨshorõ aroneate aque mose. ");
INSERT INTO srqNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jendu ra jemondo chee mbia ɨcuã je. Jenongue abe ra jemondo chee mbia ɨcuã je no. Jendesenda abe ra jemondo chee mbia ɨcuã je no. Jẽquiato abe no. Ũquɨ̃ nda jemo ɨquia chee no. ");
INSERT INTO srqNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mbia ra jẽucuãyã tuchɨ serɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Jẽsiquichechɨ̃ nda esɨ. Jaendeaquiatu tuchɨ ra aque mose. ");
INSERT INTO srqNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Jeñimbirãcuã mose ra Dios jemingo turã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Soldados Jerusalén mama mose, aque mose ra Jerusalén mbutiã cote. ");
INSERT INTO srqNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sã Judea jenda choɨ uchã ibi ibate rɨɨchã aque mose. Sã Jerusalén jenda abe choɨ uchã hue sɨ. Ae chɨ ɨsho ɨsho Jerusalén sɨ nae, sã ũquɨ̃ nyebibe eã Jerusalén ndɨɨchã aque mose. ");
INSERT INTO srqNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aque mose ra mbia mbae ɨcuã ja irara tuchɨ huɨɨcuã nɨɨ. Embesa ji cheẽ nda ɨque ja aque mose. ");
INSERT INTO srqNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aba mbia eã tuchɨ ra emo ãquẽ ndiru rerequia mose aque mose. Nguiirĩ mbuquiambu je abe no. Mbia ra mbae rasi saã tuchɨ aque mose. Mbae ɨcuã nda irara tuchɨ huɨɨcuã nɨɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aque mose ra mbia guerra raã tuchɨ. Mbia ra nyɨɨquia ɨquia aque mose. Jerusalén jenda ra sasẽ tuchɨ aque mose. Mbia ra ecuruchoɨ choɨ tuchɨ tarõ ɨsho. Judíos eã nda chɨ tuchɨ Jerusalén aque mose. Dios ra emondochoɨ chee hue sɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Mbia mae sayã ndese ra mbia mae tuchɨ ibei rɨ̃ cote. Tenda rese. Nyasi rese abe no. Nyasi tata rese abe no. Ama ndɨsha ra sieu tuchɨ quia aque mose cote. Mbia ra titi titi ɨ tuchɨ aque mose. Quiachã tuchɨ rae. ");
INSERT INTO srqNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mbia chɨã nda cuaãcuã ɨ tuchɨ aque mose. “Mbae rasi ra nandesaã tuchɨchɨ̃ nde”, ɨ tuchɨ ra titi titi ɨ. Ibei jenda abe chee ra quiata quiata cote. ");
INSERT INTO srqNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aque mose tuchɨ ra achube íbii cote. Ibeishĩ ndese ra achu. Senininya tuchɨ ra achu. Sequirãcuã tuchɨ ra achu. ");
INSERT INTO srqNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ũquɨ̃ ndese jemae mose, jẽo jẽo tuchɨ aque mose jẽ. Dios ra jendirõ jeɨ mbae ɨcuã sɨ aque mose cote, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús que ñeembe ee ra. —Sã higuera riqui no. Sã ira mo ndiqui no. ");
INSERT INTO srqNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ero quira usẽ ja mose, “iraro itõ ndacu ra cote”, ɨ chõ mbia nguiã aque mose cote. ");
INSERT INTO srqNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Eɨ̃ sɨ chõ nda mbia mae mbae ja rese cote. Ũquɨ̃ ndese mae mose, “achɨte Jesús ñɨ tu a cote”, jenye rae. “Mbia rerecua tuchɨ ra Dios cote”, jenye ra aque mose. ");
INSERT INTO srqNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ae siqui quia mbia aque mose nae, ũquɨ̃ nda manoã mbae ua ja mose chee. ");
INSERT INTO srqNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ibei ra ua. Ibi abe ra ua. Secheẽ nguia ra uayã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Mbia ndua eã mose serese ra achu cote. Ibi jenda ja ra ambua tuchɨ u. Jẽ nguia seraarõ arõ mbeɨ quia. Mbae ɨcuã ndese siqui rocoɨ̃. Quiacua siqui rocoɨ̃. Mbae rese ndua ata ata rocoɨ̃. Ũquɨ̃ ɨcuã ndese jẽɨngo mose, jaembuate ra u. ");
INSERT INTO srqNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jẽtesa beɨ quiatu quia serese. Jeñee mbeɨ quiatu quia Dios je. Ã mbae ɨcuã jeɨ̃ eã sacuã jẽje. Jẽɨngo turã sacuã serese sechu mose, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nyaashɨ̃ mose que Jesús riqui mbia mbaaquiatu quiatu Dios chuchua ra. Isa que eriqui oso oso beɨ Monte de los Olivos ra. ");
INSERT INTO srqNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Isamamɨmbe que mbia riqui ngaẽ ngaẽ ja beɨ echeẽ andu ra. Dios chuchúaa. ");
INSERT INTO srqNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Achɨte que fiesta de la pascua cote ra. Mbichae mbuchɨmatã iríã ngue mbia u u quia aque fiesta mose querabe ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sacerdotes rerecua que ñee ja nyue ra. Embesasa abe no. —Jesús nandeɨquia. ¿Mañɨ nande ra equia eɨquia nonde re? ɨ que equia ñee ñee nyue ra. Eɨreɨ̃te que eriqui mbia tubɨrɨã sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Judas Iscariote, ɨ que Jesús chɨmbaaquiatu mo je ra. Satanás que ɨque aque chɨangui re cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nyebe aque sɨ nguiã ñee sacerdotes rerecua je. Dios chuchua raarõsa je abe no. —Jesús tamondo jẽje. ¿Mañɨ nande ra equia ee re? ɨ que Judas ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ũquɨ̃ iate que Judas ñee mose ee ra. —Mbae isiquia ra uremee ndeje, ɨ que Judas je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas que eno ɨ mbia ñee mose ee ra. —Jesús tamondo rã jẽje mbia tiãsaa, ɨ que ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Fiesta que tu cote ra. Aque fiesta mose beɨ que mbia riqui oveja ɨquia ɨquia querabe ra. Mbichae mbuchɨmatã iríã ngue eu eu quia no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús que ñee Pedro je ra. Juan abe je. —Jẽso oveja mbuchi nande je, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ũquɨ̃ ngue ñee echeẽ mose ra. —¿Mangue ra aba embuchi mangue re? ɨ que Jesús cheẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús que ñee ee ra. —Jengasẽ mose sucha cuasu, emo i rerao rese ra jemae. I ra equerao quia irasa mo ye. Aque ruɨ jẽso beɨ quia ɨque chee echuchua. ");
INSERT INTO srqNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tuchuacha je jeñee. “Jesús que urembu ñee ndeje ra. ‘¿Ma cuarto ra urecu quiaru oveja u que re? Sechɨmbaaquiatu rese’, ɨ que Jesús ñee ndeje ra”, jenye tuchuacha je. ");
INSERT INTO srqNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tuchuacha ra cuarto cuasu mee jẽje. Mbia quesa ibatenda ra emee jẽje. Embuquiche ji. Huee chõ oveja jembuchi nandequiaru sacuã, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pedro que nyoɨ cote ra. Juan abe. Jesús cheẽ nduɨ sɨ tuchɨ que mbae eɨ̃ ja cote ra. Huee que oveja mbuchi cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mbae quiche ja mose que Jesús ngoi uchɨmbaaquiatu rese quiaru sacuã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús que ñee ee ra. —Co oveja que ause tuchɨ quia jendese semano nonde ra. Co mose pascua mose. ");
INSERT INTO srqNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pascua mo nda au eã mbeɨ jendese cote. Dios mbia rerecua tuchɨ mose chee, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesús que vino mbeisa isi cote ra. Gracias ɨ que Dios je ra. Ñee ngue uchɨmbaaquiatu je cote ra. —Co jẽisi. Jembei jaaja jẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Vino mo nda ambei eã mbeɨ cote. Dios mbia rerecua tuchɨ mose chee, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jesús que mbichae isi cote ra. Gracias ɨ que Dios je ra. Siquio que mbuchao chao ee cote ra. Ñee ngue ee cote ra. —Ã ndei serete rã ã. Serete ra mano jẽje cote. Jendua serete riquio ji rese ã mbichae u mose, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Eɨ̃ sɨ que Jesús vino mbeisa isi no nda. Quiaru jare. —Ã ndei seruqui rã ã. Mbia ɨcuã mbutiã sacuã tuchɨ chõ seruqui re. Dios cheẽ yasu ruɨ sɨ chõ seruqui riqui nguiã mbia ɨcuã mbutiã co. ");
INSERT INTO srqNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ae ra semee mbia ɨcuã je nae, aque abe riqui quiaru serese a. ");
INSERT INTO srqNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Co acua raque quia mano nonde co. Dios cheẽ nduɨ sɨ co. Ae semee nguia mbia ɨcuã je a nae, aque ra mbae rasi saã tuchɨ. Aba mbia eã tuchɨ rae, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Echɨmbaaquiatu que mae jaaja nyɨese ra. —Aba tuchɨ ra emee mbia ɨcuã je reae, ɨ ja jate que nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aquere que Jesús chɨmbaaquiatu ñee ɨcuã ɨcuã tuchɨ nyue ra. —Se quia ererecua tuchɨ ndesɨ re, ɨ jaaja que nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús que ñee ee ra. —Mbia ataque rerecua riqui ucuasu raã naa tuchɨ ngũimba je ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Eɨ̃ jenyechɨ̃ nda jẽ jẽ. “Ererecuarã se”, jenyechɨ̃ nda jẽ. Ae eaquiatu jiri jemo nae, sã ũquɨ̃ ndiqui uñetẽ naa naa ño. Sã ũquɨ̃ ndiqui tochei chõ nguia. Ae ererecua jemo nae, sã ũquɨ̃ ndiqui ererecua rimba rã tuchɨ chõ. ");
INSERT INTO srqNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ererecua ngoi chõ nguiã. Erimba mbae mee mee ño nguiã ee. Eɨ̃ eã ño se re. Se quia mbae amee mee nguiã jẽje co. ");
INSERT INTO srqNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jẽ nguiatu ngue jẽɨngo beɨte nguiã serese. Se mbae ɨcuã irara tuchɨ mose. ");
INSERT INTO srqNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nyebe ra jaemɨɨ tuchɨ mbia rerecuarã. Sã seru semɨɨ tuchɨ mbia rerecuarã no. ");
INSERT INTO srqNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Jẽɨngo tuchɨ ra serese, se ererecua tuchɨ mose. Jẽquiaru ra serese. Mbae mo abe ra jembei serese no. Israel ndiirĩ nderecua ja ra jẽ. Judíos rerecua ja ra jẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús que ñee Pedro je cote ra. —Simón, Satanás que ñee jenɨɨ nda. “Ndechɨmbaaquiatu emee na seje. Tã tae rã ee. Ma siqui beɨte Dios rese”, ɨ rei ngue Satanás jenɨɨ nde. ");
INSERT INTO srqNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Acheẽ tuchɨte que Dios je nderɨɨ̃ nda. Nde Dios ɨcua tuchɨ sacuã. Nde ubabe mose serese, nderesenda abe je echeẽ emingo sacuã serese, ɨ que Jesús Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro que ñee ee ra. —Sererecua chõ nde re. Aɨco beɨ ra se quia nderese. Mbia nda sematã ndei nguiã. Mbia nda seɨquia rei nguiã nderese, ɨ que Pedro ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús que ñee ee ra. —Tacheẽ nyecua ndeje, Pedro. Nguira cheẽ nonde ra erecheẽ ñooño tres veces serɨɨ̃ namo, Pedro. “Jesús aɨcuayãte resẽ”, ere chooño ño nda serɨɨ̃, ɨ que Jesús Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús que ñee uchɨmbaaquiatu je ra. —Jaemondo que mbia mbaaquiatu quiatu sacuã nyii, jẽochɨ que jaemondo. Mbae isiquia mo ngue jendao eã tuchɨ icua. Mbae rirurã mo abe que jendao eãte. Jẽiyao eã abe no. ¿Aque mose mbae eãte jẽje re? ɨ que Jesús ee ra. —Tei. Urembae tubɨrɨãte que ra, ɨ que echɨmbaaquiatu ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesús que ñee ee ra. —Ae jemo embae rirurã mo nae, jendao cote ae. Ae mbae isiquia mo nae, jendao cote ae. Ae echuuru eãte tiquise mo nae, sã emo isi huɨɨrao rɨbɨshorõ ae. ");
INSERT INTO srqNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sã embesa ji riqui ñee serɨɨ̃ no. “Mbia ɨcuã ndese ra Dios riirĩ mingo chee”, ɨ. Ũquɨ̃ nda ɨque cote. Embesa ji cheẽ nda ɨque ja tuchɨ serɨɨ̃ cote, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—Co tiquise nyeremo ñɨ co resẽ, ɨ que echɨmbaaquiatu echeẽ mose ra. —Coche ñene, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús que oso usẽ taicuee cote ra. Oso que Monte de los Olivos cote ra. Eɨ̃ mbeɨ que ae quia oso oso huee ra. Echɨmbaaquiatu que nyoɨ erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ngasẽ mose que ñee uchɨmbaaquiatu je ra. —Jeñee tuchɨ Dios je. Satanás tã ɨ eã sacuã jẽje, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesús que oso pe quiti jiri esɨ ra. Ngoi que ngũíã ndese ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Paba, ndebi mose sereaquiatu se, mbae rasi raã eã sacuã. Ae sebite nae, ũquɨ̃ esaã eã seje. Ae ndebite nae, ũquɨ̃ nguiatu esaã, ɨ que Jesús Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aque mose que ángel mo tu ibate sɨ ee ra. Embirãcuã sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús ia eã tuchɨte que ra. —Mbae rasi ra asaã tuchɨchɨ̃ nde, ɨ tuchɨ que ndua ndua ra. Ñee tuchɨ que Dios je ra. Eɨrɨeɨ ruqui que tiqui tiqui tuchɨ quia íbii ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jesús ñee jare Dios je que juã cote ra. Uchɨmbaaquiatu rea que esɨ ra. Ɨ que u uque ee ra. Eya eãte quiatu ngue re. ");
INSERT INTO srqNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ñee ngue ee ra. —¿Mbaerã jẽɨngo uque a re? Jenyuruã eae. Jeñee na Dios je. Satanás tã ɨ eã sacuã jẽje, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús cheẽ ua eã mose que mbia ngaẽ jate ee ra. Judas que tu quia mbia nonde ra. Jesús chɨmbaaquiatu raque que ae ra. Ae que Jesús sɨɨchã u eritii riite sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús que ñee Judas je ra. —¿Ereɨco seritii riite mbia ɨcuã je sereacuquia sacuã a re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesús resenda que mae u erese ra. Ñee ngue Jesús je ra. —Urererecua, ¿tiquise ra ureuru uru mbia rese re? ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jesús resenda mo ngue tiquise uru sacerdote rerecua rimba rese ra. Eisa sia. Eisa equiatocuti quitinda. ");
INSERT INTO srqNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","—Jẽhuɨ esɨ ae. Coche ñene, ɨ que Jesús ee ra. Oco que eisa rese embucherõ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesús rerao sacuã ño mbia ngaẽ nguia reaẽ. Sacerdotes rerecua. Policía abe no. Judíos rerecua abe no. Nyebe Jesús ñee nguiã ee. —¿Mbaerã jenyu quia tiquise reru serea co re? Ira jua abe no. Mbae mbuquiachãsa isi rã ño jenyuchɨ̃ nguia serea co. ");
INSERT INTO srqNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tenda que amumba mumba beɨte rei quia jendese resẽ. Mbia mbaaquiatu quiatu Dios chuchúaa resẽ. ¿Mbaerã jẽɨngo seisiã secua aque mose re? Isa chõ jenyuchɨ̃ serea co, mbia mae eã sacuã jendese. Itondaru rɨɨnda chõ jẽ nde, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mbia que Jesús isi nyucua cote ra. Sacerdotes rerecua chuchua que eruruchoɨ cote ra. Pedro que oso quia ɨshote eruɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Itaicuee que mbia tata mbucha ra. Huee que echɨ ngoi tata jii ra. Pedro abe que ngoi embɨrõ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nyucuaaque mo ngue chɨ̃ mae nguiatu tuchɨ Pedro rese ra. Tata rendi que etesaete ee ra. —Aque abe que Jesús resenda, ɨ que mae Pedro rese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro que ñee ee ra. —Tei. Jesús aɨcuayãte resẽ, ɨchõɨño ngue Pedro nyucuaaque je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Emo jiri mose que mbia mo mae Pedro rese ra. —Nde abe que Jesús resenda ra, ɨ que Pedro je ra. —Tei. Eresenda eã ño se resẽ, ɨchõɨño ngue Pedro ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Emo mose jiri que emo ñee ee no nda. —Jesús resenda chõ nde resẽ. Galilea jenda chõ nde abe resẽ, ɨ tuchɨ que Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro que ñee ee ra. —Tei. Ndecheẽ aɨcuayãte resẽ, ɨchõɨño ngue Pedro ee ra. Pedro cheẽ mose tuchɨ que nguira ñee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesús que uba mae Pedro rese nguira cheẽ mose cote ra. Pedro que ndua Jesús cheẽ ndese cote ra. —Nguira cheẽ nonde ra echeẽ ñooño tres veces serɨɨ̃, sã Jesús ɨ Pedro je nyii no. ");
INSERT INTO srqNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro ndua mose ũquɨ̃ ndese que esɨ nyeseo pe jiri ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ae Jesús isi mɨɨ nae, ũquɨ̃ ngue ɨquia ɨquia tuchɨ u Jesús je ra. Ucua ucua tuchɨ que u erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jesús resa abe que echati ra. Eruba rese que ucua ucua tuchɨ ra. —¿Aba ucua ucua quia nderuba rese a re? ɨ abe que equia Jesús resa ati ji je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ũquɨ̃ mɨɨ eã ngue eriqui ñee ee ra. Mbae ja rɨɨ̃ ngue embuqueta ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","I que nyaashɨ̃ u quia ra. Aque mose que ererecua ñumunua ja ra. Judíos rerecua. Sacerdotes rerecua abe no. Embesasa abe no. Ũquɨ̃ ñumunua mose que Jesús ruruchoɨ ee cote ra. Ererecua que ñee ja Jesús je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Cristo nde re? Echeẽ tuchɨ ure je no, ɨ que ererecua ñee Jesús je ra. —“Cristo chõ se re”, ae raque ra jẽje, “nyia”, jenye ãte ra secheẽ mose. ");
INSERT INTO srqNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Se abe preguntar ɨ mose jẽje mbae mo nɨɨ, jeñee ãte chõ nda secheẽ ndɨbɨshorõ. Jẽhuɨ eã abe ra sesɨ no. ");
INSERT INTO srqNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Namo jiri ra acoi Dios quiatocuti cote. Hue beɨ ra aɨ̃ cote. Dios quirãcuã na sɨ ra aɨco mbia rerecua cote, ɨ que Jesús ñee ererecua chumunua mose ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ñee ja que Jesús je cote ra. —¿Dios rucucha chõ nde re? ɨ ja que ñee Jesús je ra. —Ae. Dios rucucha rei se, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ererecua que ñee ja nyue ra. —¿Mbaerã nda mbia Jesús ɨcuã nenei ɨ ɨte nande je re? Jesús cheẽ ɨcuã ngue nandechandu rei nande abe resẽ. Sã mbia eɨquia, ɨ que ererecua ñee ja nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Judíos rerecua que juã ja cote ra. Jesús que ecuruchoɨ Pilato je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ũquɨ̃ ngue ñee ɨcuãte Pilato je Jesús rɨɨ̃ nda. —Jesús que mbia mbaaquiatu ɨcuã ɨcuãte quia ra jẽ. “Impuestos ra jemee meechɨ̃ mbia rerecua je”, ɨ chõ ngue equia mbia je ra jẽ. “Se chõ Cristo re. Mbia rerecuarã nda se”, ɨ que equia ra, ɨ que judíos rerecua ñee ɨcuã Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","—¿Judíos rerecua nde re? ɨ que Pilato ñee Jesús je ra. —Ae. Judíos rerecua chõ se re, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato que ñee mbia je cote ra. Sacerdotes rerecua je abe no. —“Mbae ɨcuã mo ngue Jesús saã nda”, ae aroneate erɨɨ̃, ɨ que Pilato ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Judíos que ñee asite ee ra. —Jesús riqui mbia mbaaquiatu ɨcuã ɨcuã tuchɨ co. Mbia mbesa chooño. Judíos mbaaquiatu ɨcuã ɨcuã ja. Galilea jenda rane. A jenda abe chee cote, ɨ que ñee asite Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Galilea jenda, ɨ mose que Pilato ñee ee ra. —¿Galilea jenda chõ Jesús re? ɨ que mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Ae. Galilea jenda chõ Jesús re, ɨ que mbia Pilato je ra. Nyebe Pilato Jesús mondo nguiã Herodes je. Galilea jenda rerecua quiatu ngue Herodes re. Herodes que siqui Jerusalén aque mose ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes que maese beɨte quia Jesús rese ra. Jesús rese que eriqui jirandu beɨte ra. —Jesús nda mbia mae sayã mo saã na serésaa chã, ɨ beɨte que equia ra. Nyebe eya tuchɨ nguiã mae mose Jesús rese cote. ");
INSERT INTO srqNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes que ñee atate rei Jesús je ra. Jesús que ñeeã mbeɨte echeẽ ndɨbɨshorõ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sacerdotes rerecua abe que chɨ ra. Embesasa abe no. Ũquɨ̃ ngue ñee ɨcuã ɨcuãte quia Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes que ɨquia ɨquia chõ nguia Jesús rɨɨ̃ nda. Erimba soldados abe no. Jesús ririrõ tuchɨ que equia ra. Tiru nininya tuchɨ que emingue Jesús je ra. Ererecua raã naa tuchɨ Jesús je. Aquere que Herodes embuchebi mondo Pilato je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aque mose ramo ngue Herodes quiato Pilato cote ra. Eɨcuã ɨcuã mbeɨte que eriqui nyue nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato que mbia rerecua munua ja ra. Sacerdote rerecua. Judíos rerecua abe no. Mbia ja abe no. ");
INSERT INTO srqNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ñee ngue mbia je cote ra. —Jẽ ngue Jesús jendu rei seje ra. “Mbia mbɨɨrɨ̃ ɨrɨ̃sa chõ Jesús re”, jenye rei que seje ra. Acheẽ ocote rei que ee jẽsaa ra. Ae jeñee ndei seje nae, ũquɨ̃ ɨcuã mo eãte seje Jesús rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes je abe mbae ɨcuã mo eãte Jesús rɨɨ̃. Herodes que Jesús mbube chõ nande je ra. ¿Mbaerã nda nandeɨquia re? Mbae ɨcuã mo ngue esaã eãte resẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tairuã nua ño. Aquere tambuɨ mondo, ɨ rei que Pilato ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pascua mose beɨ que Pilato riqui mbia matã ji mɨɨ mbuɨ beɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mbia que tasẽ tasẽte ñeemombo mombo Pilato je ra. —Jesús eɨquia. Barrabás quia embuɨ ure je, ɨ tuchɨ que mbia quia Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás tarõ ji que chɨ̃ nda. Mbia ɨquiasa tuchɨ que ae ra. Romanos nderecua je abe que eɨcuã ɨcuã tuchɨ riqui ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","—Jesús quia tambuɨ, ɨ rei que Pilato ñeembe mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","—Jesús embucha ira rese, ɨ tuchɨ que mbia quia tasẽ ɨ ɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato que ñee sɨ ee ra. Tres veces cote. —¿Mbaerã nda Jesús aɨquia re? ¿Mbae ɨcuã esaã nde? Mbae ɨcuã esaã eãte umano sacuã. Tairuã nua ño. Aquere tambuɨ mondo, ɨ rei que Pilato ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mbia que ñee mombo mombo tuchɨte ee ra. —¡Eɨquia jẽ! ¡Ira rese embucha jẽ! ɨ tuchɨ que mbia quia tasẽ tasẽ ee ra. Sacerdotes rerecua abe que tasẽ ɨ ɨte ra. Eno ɨ chee que Pilato cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato que mbia cheẽ mumbayã nyee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilato que Barrabás mbuɨ mondo cote ra. Mbia ɨquia ɨquiasate raque ae. Ñee ɨcuã ɨcuãsate raque ererecua je. Pilato que Jesús mee mbia je cote ra. Eɨquia sacuã. ");
INSERT INTO srqNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Soldados que Jesús curuchoɨ eɨquia sacuã cote ra. I rei que emo u quia uco sɨ ra. Simón, ɨ que ee ra. Cirene jenda mo ngue ae ra. Aque que soldados isi ra. Ira mbuchɨcuandasa ji rerao sacuã Jesús ruɨ. Cruz, ɨ equia ee. ");
INSERT INTO srqNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mbia tubɨrɨã ngue nyoɨ quia eruɨ ra. Cuña abe tubɨrɨã. Ũquɨ̃ ngue nyoɨ quia tasẽ tasẽ tuchɨ nyeseo erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús que uba mae ñee ee ra. —Cuña, jenyeseochɨ̃ nguiã serese. Jenyɨese quia jenyeseo. Jendiirĩ abe rese quia jenyeseo, Jerusalén jenda. ");
INSERT INTO srqNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mbae ɨcuã nda tuutu tuchɨ jẽje cote. Ae eriirĩ nderecua nae, ũquɨ̃ nda mbae rasi saã tuchɨ aque mose cote. Aque mose quiatu bichɨ̃ mbia riirĩ eã ja mbite re. Mbae ɨcuã tuchɨte quia nda aque mose cote re. ");
INSERT INTO srqNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Amano ño mbichɨ̃ se”, ɨ tuchɨ ra mbia aque mose cote. “Sɨta ibate tu chõ mbichɨ̃ seati”, ɨ tuchɨ ra mbia aque mose cote. ");
INSERT INTO srqNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Se chee mbia riquichɨ̃ sembasi mbasi a. Seɨcuã eã ndaque se. Mbia quiatu ra mbae rasi saã tuchɨ huɨɨcuã nɨɨ cote, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Soldados que mbia ɨcuã nyeremo curuchoɨ Jesús rese eɨquia sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ngasẽ ngue ibi ibate mo cote ra. Eresa cuare, ɨ que hue je ra. Huee que Jesús mbucha ira rese cote ra. Ũquɨ̃ mbia ɨcuã abe que embucha ira rese ra. Enongue que emɨɨ Jesús quiatocuti ra. Equiatocutiã ngue enongue mɨɨ no nda. ");
INSERT INTO srqNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mbia Jesús mbucha mose ira rese que Jesús ñee Dios je ra. —Paba, ã ɨcuã embutiã esɨ. Ñimbaaquiatuãte equia seɨquia ã, ɨ que Jesús Dios je ra. Soldados que sɨta ñetẽ mbaaba aba o je ra. —Aba ra ja. Aba mbaerã nda Jesús ɨrao reae, ɨ que nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mbia que chɨ ja tuchɨ mae erese ra. Ererecua abe chee que chɨ ɨquia ɨquia Jesús je ra. —Ma ndequirãcuãte. Mbia que erembucherõ cherõ tuchɨ quia. ¿Mbaerã ereɨco eɨ̃ ãte ndechue nde abe re? Dios riirĩ nde reaẽ, ɨ que ererecua u ɨquia ɨquia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldados abe que ɨquia ɨquia chõ nguia ee ra. Vinagre chiquino ngue emee ndei ee echɨmbei sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—¿Mbaerã ereɨco nguichi ãte ira sɨ nde ae re? Judíos rerecua rei nde reaẽ, ɨ que soldados ɨquia ɨquia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mbia que embesa ji mɨɨ Jesús ãquĩ quiti ibate ra. JUDIOS RERECUA CHÕ CO RE, ɨ que embesa ji huɨ̃ nda. Griego cheẽ. Latín ñee abe no. Hebreo cheẽ abe no. ");
INSERT INTO srqNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ae mbia ɨcuã mbucheseco ji chɨ Jesús rese nae, ũquɨ̃ mo ngue ñee ɨcuã Jesús je ra. —¿Mbaerã ereɨco nguichiã nde ae re? ¿Mbaerã ereɨco urembuquichiãte ure abe re? Dios riirĩ nde reaẽ, ɨ que ũquɨ̃ mo ñeemombo Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Enongue que ñee ee ra. —¿Mbaerã ereɨco ñee ũquɨ̃ Jesús je re? ¿Ndesiquiche ãte eriqui Dios sɨ re? Ereɨco mano Jesús rã sɨ a resẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nandeɨco mano nandeɨcuã nɨɨ a resẽ. Jesús quiatu que mbae ɨcuã saã eãte rei resẽ, ɨ que enongue ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aque sɨ́ que ñee Jesús je cote ra. —Jesús, endua serese nde ererecuarã mose, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús que ñee ee ra. —Tacheẽ nyecua ndeje. Ereɨco ra serese namo Dios rese seɨco mose, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tenda chɨ̃ mose nandeite re que itondaru ru cote ra. Ibi ja que itondaru ra. Itondaru beɨte que ra. Tenda nyeseco chee. Tres horas que ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tenda cuute que aque mose ra. Tiru mbucheseco ji Dios chuchua jenda que nyisia turã nda. ");
INSERT INTO srqNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesús que ñee mombo ngu je ra. —Paba, aso quia nderea aque, ɨ que ra. Mano ngue cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldado rerecua que mae tuchɨ huɨ̃ erese ra. Ae que ñee turã Dios rɨɨ̃ cote ra. —Mbae ɨcuã naasa eã tuchɨ chõ Jesús riqui re, ɨ que maende erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mbia tubɨrɨã chɨ quia mae ja erese nae, ũquɨ̃ ia eã tuchɨ que nyoɨ quia uchɨã isi cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mbia Jesús chɨɨcua ja que chɨ ɨsho mae erese ra. Ae cuña nyoɨ beɨte quia erese Galilea sɨ nae, ũquɨ̃ abe que chɨ ɨsho mae erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","I que mbia turã mo nguia huee ra. José, ɨ que ee ra. Judío mo ngue ae ra. Arimatea jenda que ae ra. Judíos rerecua mo ngue ae ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","José ia eãte que ererecua ataque rese Jesús ɨquia mose ra. Ae que Dios quiatote ra. —Dios ra ererecua, ɨ beɨte que equia eraarõ arõ nda. ");
INSERT INTO srqNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","—Jesús raaque emee na seje, ɨ que José oso ñee Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","José que Jesús raaque mbuquichi cote ra. Tiru je que ema nda. Sɨta rɨbɨcoɨ ji ɨmɨ ye que emondo ra. Mbia raaque mo ngue emondo eãte huee nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Viernes que aque mose ra. Mbia que ɨcoquiatu ja quia sábado nonde ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ae cuña nyoɨ beɨte quia Jesús rese Galilea sɨ nae, ũquɨ̃ ngue nyoɨ sɨta ɨmɨ ndese mae nda. Jesús raaque iti ji rese que mae tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nyebi que echoɨ uchuchua ra. Aba mbushɨmbusa que esaã nyoɨ ra. Sábado mose que ũquɨ̃ uquenea ucua cote ra. Dios cheẽ sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Isamamɨmbe tuchɨ que cuña nyoɨ domingo mose sɨta ɨmɨ ndese mae nda. Aba mbushɨmbusa que ecuruchoɨ rei eichusẽ chusẽ sacuã Jesús raaque rese ra. Cuña mo abe que nyoɨ quia erese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","I que sɨta eraaque atiquia ruruba ji u ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Cuña ngue ɨque rei nyoɨ sɨta ɨmɨ ye ra. Jesús raaque oreãte que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tiri ɨ tuchɨ que ra. —¿Mañɨ nda aba re? ɨ tuchɨ que ra. Aque mose que mbia nyeremo chɨ juã ee ra. Eɨrao nininya tuchɨ que chɨ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Cuña ngue titi titi ɨ tuchɨ u ra. Nyebe echɨ nguiã nyibi beɨte. Angeles que ñee ee ra. —¿Mbaerã jẽɨngo Jesús raaque requia requia a re? Quera sɨ que resẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Emoate a resẽ. Quera sɨ que resẽ. Sã ñee jẽje siqui mose Galilea no. ");
INSERT INTO srqNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Mbia ɨcuã nda seisi ɨquia. Sembucha ra ira rese. Tres días mose ra aquera sɨ”, ɨ que jẽje nyii resẽ, ɨ que ángeles ñee cuña je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ũquɨ̃ ndese que cuña ndua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Cuña ngue nyebi cuaẽ mbia mbiirandu ja cote ra. Jesús chɨmbaaquiatu once abe mbiirandu. ");
INSERT INTO srqNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","María Magdalena ɨ que mbia mbiirandusa je ra. Juana ɨ que emo je ra. María ɨ que enongue je ra. Jacobo si que María ra. Cuña mo abe abe que ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nyia ɨã ñochɨ̃ Jesús chɨmbaaquiatu cuña ñee mose ee. Cuña ñee ñooño neɨ nguiã ee. ");
INSERT INTO srqNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro que oso uchã sɨta ɨmɨ ndese mae nda. Nyurucua que mae erese ra. Jesús umanda achõ ngue chɨ ee ra. Pedro que nyebi oso quia ndua ndua Jesús oreã ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","I que Jesús quiato nyeremo nyoɨ quia aque mose ra. Emaús quiti que echoɨ quia ra. Dos leguas que Jerusalén sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ũquɨ̃ ngue nyoɨ quia ñee ñee nyue ra. Jesús mano nɨɨ. Jesús raaque oreã nɨɨ abe no. ");
INSERT INTO srqNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ũquɨ̃ ñee ñee ndɨɨchã ngue Jesús sɨ ra. Erese que Jesús sɨ quia ngata cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ũquɨ̃ ngue mae ndei Jesús rese ra. Icua eãte chõ ngue ra. Mbiamo nda eriqui reɨ̃ ee raẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús que ñee nyee ee ra. —¿Mbae rɨɨ̃ jẽɨngo ñee nyue ã nde? ¿Mbaerã jẽya eãte riqui re? ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ũquɨ̃ mo ngue ñee Jesús je cote ra. Cleofas, ɨ equia ee. —¿Ereiranuate erese re? ¿Nde mɨɨ ño ereiranua erese ndeɨco mose Jerusalén nde? ɨ que Cleofas ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Mbae rese? ɨ que Jesús ee ra. Ũquɨ̃ ngue ñeembe ee ra. —Jesús rese. Nazaret jenda rese. Dios cheẽ nenei neneisa tuchɨ rei que ae ra. Equirãcuã tuchɨ rei que ae ra. Mbia que mae ja tuchɨ rei equirãcuã ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mbia rerecua que Jesús ɨquia cote ra. Sacerdotes rerecua abe chõ ngue Jesús ɨquia nguiã. Nyebe soldados eɨquia nguiã mbucha ira rese cote. ");
INSERT INTO srqNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Israel jenda rerecua reɨ̃ nda ure je. Tres días chee namo cote emano mosenda beɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ureresenda cuña mo ngue ñee uremundi tuchɨ ra. Ũquɨ̃ ngue nyoɨ rei eatísaa nyaashɨ̃ namo mose ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesús raaque oreãte nda ee ra. Nyebe ecuaẽ nguiã urembiirandu cote. Angeles mo nda chɨ ee eatísaa ra. “Jesús que quera sɨ ra”, ɨ nda ángeles ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aquere que ureresenda mo abe nyoɨ eatísaa ra. Cuña ñee nduɨ sɨ que Jesús raaque oreãte ee ra. Jesús rese quiatu que mae eã nda, ɨ que Cleofas ñee Jesús sɨ́ je ra. Jesús eã nda eriqui reɨ̃ ee raẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesús que ñee ee cote ra. —¿Mbaerã jẽaquiatuãte riqui re? ¿Mbaerã jẽɨngo Dios cheẽ ɨcuayãte re? ¿Mbaerã jẽɨngo Dios cheẽ nenei neneisa chɨmbesa ɨcuayãte re? ");
INSERT INTO srqNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sã embesa ji ñee no. “Cristo ra mbae rasi saã ja oso nonde ibate”, ɨ que embesa ji no, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesús que Dios cheẽ mbuchecua ja ee cote ra. Ngasi rɨɨ̃. Umano nɨɨ abe no. Uquera rɨɨ̃ abe no. Moisés chɨmbesa que embuchecua ee ra. Aquere que Dios cheẽ nenei neneisa chɨmbesa abe mbuchecua ja ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ngasẽ ngue ũquɨ̃ nyuchúaa cote ra. Jesús que ngata ɨ abareã oso ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Jesús ngata ɨ abareã mose que ũquɨ̃ eriquisã nda. —Eitõ urerese aa ae. Tenda osote resẽ. Itondarute ra ndeje resẽ, ɨ que ñee ee ra. Nyebe Jesús ɨque nguiã echuchúaa erese. ");
INSERT INTO srqNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ngoi ja que quiaru nonde cote ra. Jesús abe que ngoi erese ra. Mbichae que esirõ o je cote ra. Gracias ɨ que Dios ibatenda je mbichae rɨɨ̃ nda. Mbichae que esiquio mondo ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ũquɨ̃ mose tuchɨ que Dios mbia mumae turã tuchɨ Jesús ɨcua sacuã cote ra. Jesús ɨcua ramo sacuã cote. Jesús que quiachã asi esɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ũquɨ̃ ngue ñee ñee nyue cote ra. —Jesús chõ eriqui reaẽ. Nyebe nandeya tuchɨte riqui nguiã Dios cheẽ mbuchecua checua mose nande je ñeenda cúa, ɨ que equia ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nyebe echoɨ jeɨ nguiã nyebi sɨ Jerusalén. Huee que Jesús chɨmbaaquiatu chɨ ñumunua ee ra. Eresenda mo abe rese. ");
INSERT INTO srqNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ũquɨ̃ ñumunua je que ñee ee ra. —Jesús que quera sɨ ra. Ae beɨ. Simón ngue mae erese ra, ɨ que ñumunua je ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aquere que ũquɨ̃ nyeremo ñee mbia chumunua je cote ra. —Jesús rese que uremae ñeenda cúa ra. Urembaaquiatu quiatu que umano nɨɨ nda. Uquera rɨɨ̃ abe no. Mbichae riquio mose ure je, aque mose ramo ngue Jesús ureɨcua ra, ɨ que mbia mbiirandu ja ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ũquɨ̃ ñee ua eã mose que Jesús nyecua ee ra. Mbia ite re. —Jẽya chõ serese, ɨ que ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mbia que titi titi ɨ tuchɨ u mae erese ra. Aba checuayã nda Jesús riqui reɨ̃ ee raẽ. ");
INSERT INTO srqNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús que ñee ee ra. —¿Mbaerã jẽsiquichete riqui re? ¿Mbaerã “Jesús chõ eriqui re” jenye eã seje re? ");
INSERT INTO srqNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","¡Sã jẽ! Jemae seo rese. Jemae sei abe rese ae. Jẽoco serese ae. ¡Sã se sɨ chõ jẽ! Aba checuayã nguia eroo eã nde. Equiangue eã abe no. Se rã eã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","O que eteacuquia ee cote ra. Hui abe que eteacuquia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","—Jesús chõ eriqui re, ɨ eã ngue ra. Ndua ndua chõ erese. Eyate raque erese. Jesús que ñeembe ee ra. —¿Mbae mo ndei eu sacuã aa re? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sɨra resi ji que emee ee ra. Irao abe que emee ee eretã ndesebe ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús que eisi eu beɨ ũquɨ̃ ndésaa cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jesús que ñee ee cote ra. —Sã acheẽ jẽje seɨco mose jendese nyii no. “Ae Moisés mbesa serɨɨ̃ nae, ũquɨ̃ nda ɨque ja serɨɨ̃ cote. Dios cheẽ nenei neneisa chɨmbesa abe ra ɨque ja cote. Salmos ndesenda cheẽ abe ra ɨque ja serɨɨ̃ cote”, ae que se quia jẽje nyii. Ũquɨ̃ ngue ɨque ja semano mose cote ra. Sequera mose abe no, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dios cheẽ ngue embuchecua checua ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jesús que ñeembe ee ra. —Sã embesa ji riqui ñee no: “Cristo ra mbae rasi saã tuchɨ mano nonde. Tres días mose ra quera sɨ. ");
INSERT INTO srqNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mbia ra echeẽ senei senei tuchɨ cote. Jerusalén jenda je rane nda erenei nenei. Mbia ja je ra erenei nenei cote. ‘Jẽɨcuã sɨ jẽhuɨ rã. Cristo jẽɨcuã mbutiã sacuã’, ɨ tuchɨ ra mbia ja je Cristo rɨɨ̃ cote”, ɨ que embesa ji quia nae. ");
INSERT INTO srqNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ũquɨ̃ ɨque quia ã cote. Jemae nguia erese ã cote. ");
INSERT INTO srqNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ae je Paba ñee jẽje nae, “Espíritu Turã tamondo jẽje”, ɨ equia jẽje nae, aque tamee jẽje cote. A jenguchõ na Jerusalén. Paba ibatenda uquirãcuã mee nyee jẽje, ɨ que Jesús ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesús que equerao ja pe jiri Jerusalén sɨ cote ra. Betania ɨ que hue sucha je ra. Jesús que o mumbate ñee uchɨmbaaquiatu je cote ra. —Sã Dios jendeaquiatu turã, ɨ ee. ");
INSERT INTO srqNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aque mose tuchɨ que Jesús sɨ nyuɨ ibate erecha cote ra. ");
INSERT INTO srqNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ũquɨ̃ ngue ñee turãte Jesús rɨɨ̃ nda. Eya tuchɨ que nyebi nyoɨ Jerusalén nda. ");
INSERT INTO srqNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Dios chuchua que eriqui beɨ nyoɨ ñee turã Dios rɨɨ̃ nda. Amén.");
INSERT INTO srqNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dios cheẽ nane tuchɨ que nyii ra. Mbae ja sɨ. Dios cheẽ ndei Jesús. Ae que siqui beɨ Dios rese ra. Dios sɨ rei Jesús. ");
INSERT INTO srqNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ae chõ ngue siqui beɨ Dios rese nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dios que mbae chao eã ae ae ra. Jesús rese ae mbae ao ja nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jesús chõ mbia mɨngo nguiã ã. Nandemɨngosa chõ nanderesae nguiã ã. ");
INSERT INTO srqNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nandemɨngosa chõ mbae tesae tuchɨ nguiã itondaru. Itondaru quia ra emungue aroneãte. ");
INSERT INTO srqNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dios que emo mbu cote ra. Juan, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juan ngue tu aba resaesa renei nenei mbia je ra. Mbia mbiirandu randu ja. Ɨ̃ nda mbia aba resaesa ɨcua ja, Juan ñee nguire. ");
INSERT INTO srqNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Aba resaesa eã ño Juan nde. Emo nɨɨ ño Juan ndiqui nguiã ñee. —Ae chõ nanderesae nguiã co, ɨ que Juan nda. ");
INSERT INTO srqNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aba resaesa que tu ibi cote ra. Aba resaesa chooñoã tuchɨ que ra. Ae chõ aba resae ja nguiã ã. ");
INSERT INTO srqNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aba resaesa que siqui íbii cote ra. Mbia que eɨcua eãte chõ nda. Mbae aosa ja raque ae. ");
INSERT INTO srqNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aba resaesa que tu rei nguesenda mbɨrõ nda. Eresenda que eisiteã ñochɨ̃ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mbia mɨɨ mɨɨ ño ngue eisi turã turã nguiã. Mbia mɨɨ mɨɨ ño ngue eɨcua ɨcua nguiã. Ũquɨ̃ je quia Dios riqui nguiã “seriirĩ” ɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mbia riirĩ na eã ño Dios riirĩ ndiqui nguiã nyaacuquia cuquia ã. Ãquẽ nyaacuquia rã eã ño Dios riirĩ ndiqui nguiã nyaacuquia cuquia ã cote. Sã emo ndiqui ngũinisi rese embiirĩ nae, ũquɨ̃ na eã ño Dios riirĩ ndiqui nguiã nyaacuquia cuquia ã. Dios ae chõ “seriirĩ” ɨ nguiã ee Dios ɨcua mose. ");
INSERT INTO srqNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jesús rei Dios cheẽ. Jesús que tu mbiarã cote ra. Mbia tuchɨ que ae cote ra. Siqui que equia urerese cote ra. Echɨsaã turã ndese que ureɨco mae cote ra. Eturã tuchɨ chõ ae re. Ngu rã sɨ chõ ae re. Ɨchõɨñosa reã tuchɨ chõ ae re. ");
INSERT INTO srqNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan ngue Jesús senei senei nguia mbia je ra. —Co rɨɨ̃ ngue acheẽ jẽje resẽ. “Ae ra tu seruɨ, aque quiarei ererecua tuchɨ sesɨ. Ae rane nguia siqui rei seã mose nyii”, ae rei que jẽje resẽ. Ae siqui co cote, ɨ que Juan mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesús turã tuchɨ que ra. Nyebe eriqui nguiã mbae turã mee mee mbeɨ nande je. ");
INSERT INTO srqNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dios cheẽ mumbayã sacuã ngue Moisés ñee ndei nguiã nande je. Jesús quiatu ngue tu nguiã cote. Dios turã nenei nenei nande je. Jesús quiatu ngue Dios cheẽ ñooñoa senei senei nguiã nande je no. ");
INSERT INTO srqNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Emo maeãte Dios rese. Eriirĩ ae que nandembiirandu randu quia Dios rese ra. Eriirĩ nguiarei ngu rã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judíos Jerusalén jenda que mbia mondochoɨ ñee Juan je ra. Sacerdotes mondo erea. Levitas mo ndese. —¿Aba nde re? ɨ sacuã Juan je. ");
INSERT INTO srqNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan ngue ñee nyecua tuchɨ ee ra. —Christo eã ño se re, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","—¿Abate nde re? ¿Elías chõ nde re? ɨ que judíos chɨmondo ñeembe Juan je ra. —Tei. Elías eã ño se re, ɨ que Juan ee ra. —Dios cheẽ mbuchecuasa ra tu, ɨ equia nae, ¿ae chõ nde re? ɨ que mbia ñee Juan je ra. —Tei, ɨ que Juan ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Judíos chɨmondo que ñeembe Juan je ra. —Ndecheẽ embuchecua ure je. ¿Abate nde re? Ɨ̃ nda ndecheẽ uresenei ũquɨ̃ je, ae urembu. ¿Mañɨ ure ra nderɨɨ̃ nde? ɨ que Juan je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan ngue ñee ee ra. —Tacheẽ jẽje cote. Aba chõ se chã. Mbia amingo quiatu quiatu quia co. Ae ñee mombo mombote quia mbia je turuquia ite re nae, ae chõ se re. —“Ñeenda jembuquiche nandererecua mbaerã”, ae ɨ quia, aque chõ se re, ɨ que Juan nda. (Isaías chɨmbesa ruɨ sɨ chõ Juan ñee nguiã.) ");
INSERT INTO srqNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ae ñee ñee nguia Juan je nae, ũquɨ̃ ndei fariseos chɨmondo ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Fariseos chɨmondo que ñee ee ra. —¿Mbaerã ereɨco bautizar ɨ re? Cristo eã ño nde resẽ. Elías eã ño nde resẽ. Dios cheẽ mbuchecuasa eã ño nde resẽ, ɨ que Juan je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan ngue ñee ee ra. —I je chõ aɨco nguiã bautizar ɨ. Emo nguia siqui raque quia jẽite re. Aque quia jẽɨcuayãte nguiã co. ");
INSERT INTO srqNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Enonde aɨco co. Aque ra tu seruɨ. Ae quia ererecua tuchɨ sesɨ re. Erã sɨ eã ño se re, ɨ que Juan fariseos chɨmondo je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betábara, ɨ que hue sucha je ra. Huee quia fariseos chɨmondo ñee nguiã Juan je. Ama Jordán ndobeɨ. Ae Juan ndiqui bautizar ɨ, huee. ");
INSERT INTO srqNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Isamamɨ nongue que Juan mae Jesús rese ra. Jesús que tu quia Juan ndɨɨchã nda. —Co mbia ɨcuã ndiquicharõ sacuã ndu quia co. Oveja riirĩ na eriqui Dios je. Ae ra nandeɨcuã mbutiã nandesɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Erɨ̃ ngue aɨco ñee jẽje. “Ae ra tu seruɨ, aque quiarei ererecua tuchɨ sesɨ. Ae rane nguia siqui rei seã mose nyii”, ae que se quia jẽje. Co chɨ eru quia co cote. ");
INSERT INTO srqNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Se sɨ́ que aɨcuayãte nyii ra. I je que bautizar ae quia mbia je cote ra. Ɨ̃ nda Israel jenda Cristo ɨcua, ɨ que Juan nda. ");
INSERT INTO srqNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan ngue ñee mbeɨ quia ra. —Espíritu Turã ndese que amae nda. Nguichi que u Jesús arõ nda. Nyurusɨ rã ngue eru nguichi earõ nda. Ibate sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","“¿Aba ra Cristo re?” ae beɨte que se quia ra. Dios que ñee seje ra. “¡I je eɨco bautizar ɨ mbia je jẽ! Ae arõ nda Espíritu Turã ndu nguichi beɨ nae, ae quiatu bautizar ɨ sacuã mbia je Espíritu Turã je”, ɨ que Dios seje ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Atea que se cote ra. Ae rei Dios riirĩ. Aɨcuate se cote, ɨ que Juan nda. ");
INSERT INTO srqNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Isamamɨ nongue que Juan ndiqui hue sɨ́ no nda. Nguesenda nyeremo ndese que eriqui ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ɨ que Jesús ucua quia ra. —Quɨ mbia ɨcuã ndiquicharõ sacuã coɨ quia quɨ. Oveja riirĩ na eriqui Dios je, ɨ que Juan Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Juan ndesenda nyeremo ngue Juan ñee ñandu ra. Nyoɨ que Jesús ruɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús que mae nguique quiti ra. —¿Mbae jẽsequia quia re? ɨ que mae erese ra. Ũquɨ̃ ngue ñee Jesús je ra. —Mbia mbaaquiatusa, ¿ma ndechuchua ma nde? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Jenyu mae erese, ɨ que Jesús ee ra. Nyoɨ que mae echuchua rese ra. Tenda nyesecote mose que echoɨ erese ra. Tenda oso cheete que echɨ erese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ũquɨ̃ nyeremo ngue Juan ñee ñandu ra. Siqui que Jesús ruɨ cote ra. Andrés, ɨ que ũquɨ̃ mo je ra. Simón Pedro nongue que ae ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés que oso asite ngõngue requia ra. Simón ndequia. —Dios chɨmondo que uretea ra. Cristo que uretea ra, ɨ que Andrés ngõngue je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés que ngõngue querao Jesús rea cote ra. Jesús que mae erese ra. Ñee ngue ee ra. —Simón ño nde re. Jonás ndiirĩ ño nde re. Cefas, ɨ ra ndeje cote. Cefas, ɨ chõ Pedro re, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Isamamɨ nongue que Jesús ñee nda. —Taso Galilea, ɨ que ra. Ngasẽ ngue Felipe je ra. —Seruɨ eɨco, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida jenda que Felipe ra. Hue jenda sɨ chõ Andrés re. Pedro rese. ");
INSERT INTO srqNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe que oso Natanael ndequia cote ra. —Ae rɨɨ̃ Moisés riqui embesa mbesa cose, aque que uretea ra. Ae rɨɨ̃ Dios cheẽ mbuchecuasa riqui embesa mbesa cose, aque que uretea cote ra. Jesús chõ eriqui re. Nazaret jenda chõ eriqui re. José riirĩ ño eriqui re, ɨ que Felipe Natanael je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael que ñee Felipe je ra. —¿Mbae turã mo nda tu Nazaret jenda re? ɨ que ra. —Echu erea ae, ɨ que Felipe ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael que tu Jesús rɨɨchã nda. Jesús que mae erese ra. —Co israelita turã tuchɨ mo ndu quia co. Aba mbɨɨrɨ̃ ɨrɨ̃sa reã tuchɨ mo ndu quia co, ɨ que Jesús Natanael nɨɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","—¿Mañɨ ere quia seɨcuate re? ɨ que Natanael Jesús je ra. —Amae ngue nderese ra. Felipe ‘quiatuchu’ ɨ nonde ndeje. Iraqui re que amae nderese ra. Higo iqui re, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael que ñeembe ee ra. —Mbia mbaaquiatusa, Dios ndiirĩ ño nde riqui re. Israel jenda rerecua tuchɨ chõ nde riqui re, ɨ que Natanael Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús que ñee ee ra. —¿Seɨcuate se re? “Iraqui re que amae nderese ra”, ae que ndeje, ¿aque beɨ beɨ seɨcua quia co re? Mbae turã tuchɨ rese ra eremae cote, aque sɨ, ɨ que Jesús Natanael je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús que ñee sɨ ee ra. —Tacheẽ nyecua jẽje. Ibei ra obo jẽje. Angeles nda nguichi quichi quia seje. Nyoɨ nyoɨ sɨ ra equia ibate. Angeles ibatenda. Dios rimba. Jemae nda erese, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tres días mose que emo ngũinisirã isi ra. Galilea. Caná, ɨ que hue sucha tubiriã je ra. Mbia que ñumunua nua fiesta raã ngũinisirã isi mose ra. Jesús si abe que siqui huee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús abe que siqui huee no nda. Uchɨmbaaquiatu rese. ");
INSERT INTO srqNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mbia que uva rique mbei u huee ra. Ua jeɨ que mbia je ra. Jesús si que ñee nda. —Uva rique que ua jeɨte ra, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús que ñee ee ra. —¿Mbaerã ereɨco ñee seje ũquɨ̃ nde, Taĩ? Achecua jeɨ eã nda mbia je, ɨ que Jesús usi je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Esi que ñee mbia rimba je ra. —¡Jesús cheẽ nduɨ sɨ chõ jẽɨngo jẽ! ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Cántaro atate que chɨ ra. Seis que cántaro ra. Sɨta ao ji. Ũquɨ̃ jie que judíos riqui nyoɨ nyoɨ querabe ra. Ũquɨ̃ cántaro jie que cien litros jaaja ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús que ñee mbia rimba je ra. —Cántaro jemombisẽ mbisẽ ja i je, ɨ que Jesús ee ra. Nyebe emombisẽ ja nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús que ñeembe ee ra. —Embisengue jenyarabe jiri mondo fiesta raã naasa je, ɨ que ee ra. Erimba que echara serao ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Uva rique rã sɨ chõ ngue i fiesta raã naasa je cote ra. Fiesta raã naasa que ubi erese ra. Eiranuã ngue ubi erese ra. Erimba achõ ño ngue jirandu ja nguiã. Ae ngũinisirã isi quia nae, aque je que fiesta raã naasa ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Mbia ja quiarei uva rique turã nane mee mee nguia mbia je querabe. Eturã mbei ja mose, ereã jiri mbei ruquia ruquia mbia je cote. Nde quia eturã tuchɨ ererecoquiatu nguiã. Huɨ beɨ sacuã cote, ɨ que ra. Jesús chɨsaã nɨɨ ño eriqui nguiã ñee. ");
INSERT INTO srqNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ũquɨ̃ nane ngue Jesús saã mbia mae sayã nyii ra. Uva rique rã sɨ tuchɨ que i raã nda. Ũquɨ̃ ngue esaã Galiléaa eriqui mose ra. Caná, ɨ que hue sucha tubɨrɨã je ra. Hue rane ngue Jesús uquirãcuã ndeacuquia mbia je ra. Echɨmbaaquiatu que Jesús ɨcua tuchɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Huesɨ que Jesús choɨ Capernaum nda. Usi rese. Ngõngue rese. Uchɨmbaaquiatu abe rese. Hue que echɨ itõ mocoĩte ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Fiesta rurubite mose que Jesús sɨ Jerusalén nda. Pascua, ɨ que judíos aque fiesta je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jesús que oso Dios chuchúaa ra. Huee que mbia chɨ ticuasu mee mee nyue mbae isiquia rɨbɨshorõ nda. Ovejas abe no. Nyurusɨ cuasu abe no. Emo ngue chɨ ngoi ra. Mbae isiquia que esɨbɨshorõ shorõ u ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mbia iruã nuãsa que Jesús saã nda. Esã nderecua. Aque je que Jesús mbia mbusẽ ja mondochoɨ Dios chuchua sɨ ra. Ticuasu abe. Ovejas abe. Ae mbae isiquia sɨbɨshorõ shorõ nguia, ũquɨ̃ mbae abe que embuchiichere chere ja mesa ra. Mbae isiquia mombo mombo íbii. ");
INSERT INTO srqNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ae nyurusɨ cuasu mee mee nguia mbia je nae, ũquɨ̃ je que Jesús ñee asite ra. —Ã nyurusɨ cuasu jendao Dios chuchua sɨ. Mbae isi isisa jẽsaã saã ñochɨ̃ u Paba chuchúaa a, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesús chɨmbaaquiatu que ndua ndua quia embesa ji rese ra. —Sebi tuchɨ ndechuchua, ɨ que embesa ji huɨ̃ nda. Ũquɨ̃ ndese que echɨmbaaquiatu ndua ndua ra. Jesús mbia ɨcuã mbusẽ mondochoɨ mose Dios chuchua sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judíos que ñee Jesús je ra. —¿Ma mbia mae sayã nda eresaã ure je re? Ure ndeɨcua sacuã. “Ererecua chõ eriqui re”, ure nda ndeje chã, ɨ que judíos ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús que ñee ee ra. —Jẽ Dios chuchua mbutiã mose, asiquicharõ nda se. Tres días mose ra asiquicharõ, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Judíos que ñeembe Jesús je ra. —Tenda atate que nanderu riqui itõte Dios chuchua ao ao resẽ. Cuarenta y seis años. ¿Mañɨ ere ra tres días eao ja nde re? ɨ que judíos Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nguete rɨɨ̃ ngue Jesús riqui ñee nda. Mbia chumunuasa rɨɨ̃ eã ño ngue ñee nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jesús quera sɨ mose ramo ngue echɨmbaaquiatu ndua aque echeẽ ndese cote ra. Embesa ji rese ndua. —Ɨ̃ nguia equia re, ɨ que echɨmbaaquiatu ndua ndua cote ra. Jesús quera sɨ mose. ");
INSERT INTO srqNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mbia tubɨrɨã ngue Jesús ɨcuate aque mose ra. Fiesta de la pascua mose. Siqui mose Jerusalén. Mbia mae sayã naa naa mose que mbia eɨcuate cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesús que mbia ndua ndua ɨcuate quia ra. Nyebe ñee tuchɨ eã nguiã mbia je. ");
INSERT INTO srqNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","—Ẽɨ ño mbia nguiã ã, ɨ aronea mbia mo Jesús mbiirandu. Jesús quiatu que mbia chɨã ɨcuate quia ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mbia mo ngue siqui ra. Nicodemo, ɨ que ee ra. Fariseo que ae ra. Judíos rerecua que ae ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Itondaru mo ngue esɨ Jesús rea ra. —Mbia mbaaquiatusa chõ nde re. Dios chɨmbu chõ nde re. Ureɨcuate que ra. Mbia mae sayã nda mbia mo saã eã, Dios siquíã mose erese, ɨ que Nicodemo Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús que ñee ee ra. —Tacheẽ nyecua ndeje. Ae nyaacuquia sɨ eã, ũquɨ̃ nda siquíã Dios rese, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo que ñee Jesús je ra. —¿Mañɨ nda mbia cuasu nyaacuquia sɨ re? ¿Usi riequi rɨ̃ nda esɨ sɨ re? ¿Nyaacuquia sɨ nonde re? ɨ que Nicodemo Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús que ñee ee ra. —Tacheẽ nyecua ndeje. Ae nyaacuquia i achõ je nae, ũquɨ̃ nda siquíã Dios rese. Ae nyaacuquia Espíritu Turã abe je nae, ũquɨ̃ nguia ra siqui Dios rese cote. ");
INSERT INTO srqNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mbia nyaacuquia mose, mbia sɨ́ chõ eriirĩ nde. Emo nyaacuquia mose Dios riirina, Dios rã sɨ chõ eno nde. ");
INSERT INTO srqNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Nducuã”, erechɨ̃ nda secheẽ mose jẽ. “¡Jenyaacuquia sɨ ja chõ jẽ!” se ɨ mose. ");
INSERT INTO srqNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","¿Mbaranguiti sɨ quɨrɨrɨã ndiqui ɨchu re? ¿Mbaranguiti ra esɨ re? Ereɨcuayãte. Quɨrɨrɨã erechandu raque. Eremae ãte erese. Eɨ̃ sɨ chõ Dios riirĩ nde. Ae nyaacuquia Dios je nae, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—¿Mañɨ ũquɨ̃ nde? ɨ que Nicodemo Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús que ñee ee ra. —¿Secheẽ ereɨcuayãte quia re? Mbia mbaaquiatusa raque nde. Judíos mbaaquiatusa raque nde. ");
INSERT INTO srqNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tacheẽ nyecua ndeje. Ae ureɨcua, ũquɨ̃ ño uresenei senei ndei nguiã jẽje. Ae rese uremae, ũquɨ̃ ño uresenei senei ndei nguiã jẽje. “Ɨchõɨño nguiã”, jenye chõchɨ̃ nguiã urecheẽ mose. ");
INSERT INTO srqNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","“Ɨchõɨño nguiã”, jenye chõchɨ̃ nguiã secheẽ mose. Ibi jenda renei nenei mose jẽje. Secheẽ nda jemumba tuchɨ cote, ibatenda nenei nenei mose jẽje. ");
INSERT INTO srqNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Emo nguichiãte ibei sɨ. Se mɨɨ ño ngue achu nguiã nguichi ibei sɨ. Mbiarã ño ngue achu nguiã. Asobe ra ibei. Ibei jenda chõ se re. ");
INSERT INTO srqNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sã Moisés mbeɨ raanguia mbuchecua mbia je turuquia re cose no. Eɨ̃ sɨ ra mbia sembucha ira rese. ");
INSERT INTO srqNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ɨ̃ nda seɨcuasa quiachã eã mbeɨ sesɨ. Ɨ̃ nda seɨcuasa siqui beɨ ibate serese. ");
INSERT INTO srqNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dios que nyesecua tuchɨte mbia ja rese ra. Nyebe nguiirĩ mɨɨ mbu nguiã mbia je. Eriirĩ ɨcua sa ra manoa. Siqui beɨ rae. ");
INSERT INTO srqNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mbia mbasi sacuã eã ngue Dios nguiirĩ mbu íbii ra. Mbia rirõ sacuã mbae ɨcuã sɨ quia ñɨ ngue Dios nguiirĩ mbu nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Eso tata cuasu”, ɨ eã nda Dios nguiirĩ ɨcuasa je. “Eso tata cuasu”, ɨ Dios quia nguiirĩ ɨcuasa reã je ã. Jesús ɨcua eãte quia ñene. ");
INSERT INTO srqNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Eso tata cuasu”, ɨ Dios quia nguiirĩ ɨcuasa reã je. Ebite quia ñɨ itondaru nyaashɨ̃ sɨ re. Nyaashɨ̃ tu mose íbii, isiteã ngue ra. Mbae ɨcuã ndese quia eriqui beɨte nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ae siqui beɨte quia mbae ɨcuã ndese, ũquɨ̃ nguia siquichete nguiã nyaashɨ̃ sɨ. Nyaashɨ̃ ndɨɨchã sereãte quia ñene. “Ɨ̃ nda mbia mae eã nandechɨsaã ndese mbae ɨcuã ndese”, ɨ ñene. ");
INSERT INTO srqNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ae mbae turã saã mbeɨte quia nae, ũquɨ̃ nguiatu nyaashɨ̃ sɨɨchã sete nguiã. Ɨ̃ nda echɨsaã saã nyecua mbia je. Ɨ̃ nda mbia ñee, “Dios quirãcuã nguia siquite nguiã erese”, ɨ ra mbia ñee, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jesús que nyoɨ Judéaa cote ra. Uchɨmbaaquiatu rese. Huee que eriqui mocoĩte ũquɨ̃ ndese ra. Huee que eriqui bautizar ɨ mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan abe que bautiza r ɨ quia mbia je ra. Enón, ɨ que sucha tubɨrɨã je ra. Salim ndurubi que ra. Hue quiatu ngue i tubɨrɨãte re. Mbia que ngaẽ ngaẽ nguia erea ra. Juan ngue bautizar ɨ quia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mbia Juan tarõ nonde mɨɨ ngue eriqui bautizar ɨ huee nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Judío mo ngue ñee ɨcuã ɨcuã Juan ñɨmbaaquiatu je ra. Bautizar ɨ rɨɨ̃. —¿Aba quia ra bautizar ɨ mbia mbitirõ sacuã nde? ɨ que ñee ɨcuã ɨcuã nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nyebe Juan ñɨmbaaquiatu nyoɨ nguiã ñee Juan je. —Ae rese ereɨco Ama Jordán ndobeɨ, ae abe riqui bautizar ɨ mbia je huee. Ae eresenei senei turã nguia ure je, aque. Mbia riqui tuchɨte eruɨ ã, ɨ que Juan ñɨmbaaquiatu ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan ngue ñee ee ra. —Coche ñene. Dios ibatenda quiarei. Emo siqui aroneate mbia rerecuarã, Dios emingo sereã mose. ");
INSERT INTO srqNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Cristo tu nonde que Dios sembu resẽ. Mbae mbuquiche ja sacuã Cristo tu nonde. “Cristo eã ño se resẽ”, ae checua rei que jẽje resẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jesús ruɨ ra mbia siqui ja. Sã emo ngũinisirã nguereco no nae. Sã eninisi riqui ngu rese no. Sã eru quiato abe eya erese no. Eru quiato rã ño seya riqui Jesús rese co, mbia siqui mose eruɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jesús quia ererecua tuchɨ riqui nguiã sesɨ co. Ererecua eã ño aɨco nguiã se co, ɨ que Juan nda. ");
INSERT INTO srqNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jesús rei ibatenda. Nyebe eaquiatu riqui nguiã mbia sɨ co. Ibi jenda chõ nande re. Ibi jenda rese achõ ño nandeaquiatu nande re. Ae quiarei ibatenda. ");
INSERT INTO srqNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ibatenda umaesa senei senei nguia mbia je co. Ae echandu ibate nae, ũquɨ̃ abe esenei senei nguia mbia je co. Mbia mɨɨ jiri riqui echeẽ andu andu ã. ");
INSERT INTO srqNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ũquɨ̃ mɨɨ mɨɨ ño Jesús cheẽ isi turã nguiã ã. Ũquɨ̃ mɨɨ “Dios ɨchõɨñosa reã”, ɨ tuchɨ nguiã ã. ");
INSERT INTO srqNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dios quiatu que Jesús mbu ra. Nyebe Jesús riqui Dios cheẽ nenei nenei co. Dios que Espíritu Turã mondo tuchɨte Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jesús rese Paba riqui nyesecua tuchɨte co. Erucucha quia ae re. Nyebe Paba uquirãcuã mee tuchɨ nguiã ee. Ɨ̃ nda Jesús riqui mbae rerecuarã ja. ");
INSERT INTO srqNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ae Dios rucucha ɨcua nae, ũquɨ̃ nda siqui beɨ Dios rese. Ae Dios rucucha ɨcuayã nae, ũquɨ̃ nda siquíã tuchɨ erese. Nyoɨ eã mbeɨ ra ibate. Dios ra ũquɨ̃ mondo tata cuásuu. ");
INSERT INTO srqNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Mbia que siqui tuchɨte Jesús ruɨ cote ra. Bautizar ɨ sacuã mbia je. Jesús sɨ́ que bautizar ɨ eã nda. Echɨmbaaquiatu quia ngue bautizar ɨ nguiã ee. —Fariseos riqui ndeucuãyãte ã. Mbia siqui tuchɨ mose nderuɨ, ɨ que mbia mo Jesús mbiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesús jirandu mose que esɨ Judea recha cote ra. —Tasobe Galilea, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria nɨ ngue esɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ngasẽ ngue Samaria ra. Sucha tubɨrɨã mo ngue ngasẽ nda. Sicar, ɨ que hue je ra. Jacob chɨmee ibi ndurubite que huee ra. Ae emee nguiirĩ José je. ");
INSERT INTO srqNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob chɨbɨcoɨ ibi que chɨ̃ huee ra. Noria. Jesús que ngoi huɨ̃ uquenea ucua huee ra. Noria ji. Tenda nandeite re mose. Ñeenda ɨshote que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jesús ae que tiba huee ra. Echɨmbaaquiatu que nyoɨ sucha tubɨrɨã nda. Mbae mo isi uchɨurã. Acuanɨ mo ngue tu ngasẽ i rea huee ra. Samaria jenda que ae ra. —I embu rã. Tayu, ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Judíos que ñee eã mbeɨ quia mbia Samaria jenda je querabe ra. Ɨsho beɨ que eriqui nyesɨ ra. Nyebe acuanɨ ñee nguiã Jesús je. —Judiote nde resẽ. ¿Mbaerã ereɨco ñee seje re? ¿Mbaerã ereɨco “i embu” ɨ seje re? Samaria jenda chõ se resẽ, ɨ que acuanɨ Jesús cheẽ ndɨbɨshorõ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús que ñee ee cote ra. —Dios chɨmee ereɨcuayãte quia co. Co ereɨco seɨcuayãte co. Eɨ̃ nda “i raanguia embu seje” ere rei seje. Seɨcua mose. Eɨ̃ nda i mbia mɨngo beɨsa amee ndeje, ɨ que Jesús acuanɨ je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Acuanɨ ngue ñee sɨ Jesús je ra. —Noria cuate nyeresẽ. I arasa ereru eãte quia a resẽ. Ma je quia ra i raanguia erechara seje. ");
INSERT INTO srqNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nanderu ñiinda abe nda íu íu quia a yenda ye resẽ. Jacob. Nguiirĩ ndese. Erimba abe nda íu íu quia a yenda ye resẽ. ¿Ndeaquiatute ae sɨ nde re? ɨ que acuanɨ Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús que ñee acuanɨ je ra. —Mbia íu mose a yenda jie, eɨseɨ jeɨ chõ nda eno. ");
INSERT INTO srqNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ae i raanguia mbei quia nae, ũquɨ̃ nda eɨseɨ chɨã mbeɨ cote. I raanguia sechɨmee nguia ra siqui beɨ echɨangui re. Uchɨ uchɨ beɨ ra equia echɨangui re. Emingo beɨ sacuã, ɨ que Jesús acuanɨ je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Acuanɨ ngue ñeembe Jesús je ra. —I raanguia embu nembae seje no. Eɨ̃ nda seɨseɨ chɨã mbeɨ. Eɨ̃ nda achu achu eã a jenda ara, ɨ que acuanɨ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Eso nderu rea. Eru seje a, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Seru eãte nyeresẽ, ɨ que acuanɨ nda. Jesús que ñee ee ra. —Ae beɨte. Nderu eãte que ereɨco namo co ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nderurã ngue eretea mocoĩte rei resẽ. Cinco. Ae erereco co nae, nderu tuchɨ eã ño aque re. Erecheẽ ñooño ãte rei nguiã seje a, ɨ que Jesús acuanɨ je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jesús cheẽ mose que acuanɨ ñeembe ee no nda. —Mbae mbuchecuasa nde reae. Dios resenda nde reae. ");
INSERT INTO srqNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ureramei nda ngaẽ ngaẽ nguia a ibi ato ra. Ñee ñee sacuã Dios je. “Jerusalén quiatu mbia cheẽsa Dios je re” jenye chõchɨ̃ nguiã judíos, ɨ que acuanɨ Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús que ñee acuanɨ je ra. —Tacheẽ nyecua ndeje. Mangue chooño ãte ra mbia ñee Dios je cote. Namo jiri. Jerusalén mɨɨ eã. A ibi ato mɨɨ eã no. ");
INSERT INTO srqNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jeñee mbeɨte raque equia Dios je ã. Dios ɨcuare rocoĩ. Ure quia ureɨco nguiã Dios ɨcuate ã. Judíos chõ ure re. Judío rei mbia rirõsa mbae ɨcuã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Namo jiri ra Dios quiatote ñee turã turã Dios rɨɨ̃ uchɨangui re. Mangue chooñoa cote. Dios quiatote ra ñee turã beɨ quia Dios rɨɨ̃ cote. Echeẽ nguire. ");
INSERT INTO srqNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios rei espíritu. Mae aronea erese. Nandechɨangui re chõ nandeɨco Dios andu ã. Nandechɨangui re nandecheẽ turã turã Dios rɨɨ̃. Dios cheẽ nguire, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Acuanɨ ngue ñee Jesús je ra. —Mesías ra tu ibate sɨ. “Cristo”, ɨ equia ee nae, aque ra tu íbii cote. Tu mose ra mbae mbuchecua ja mbia je. Ũquɨ̃ aɨcuate quia co, ɨ que acuanɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Cristo chõ se re. Ae je ereɨco ñee, ɨ que Jesús acuanɨ je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aque mose que Jesús chɨmbaaquiatu ngaẽ ngasẽ cote ra. —Jesús riquichɨ̃ ñee acuanɨ je a re, ɨ que eu nyuruɨrate mae erese ra. —¿Mbae jenye quia ñee nde? ɨ eã ngue emo nda. Ɨreɨ̃ ɨreɨ̃te quiatu ngue ñee Jesús je re. ");
INSERT INTO srqNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","—Se rei Cristo, ɨ mose que acuanɨ ía tuchɨ ra. Ñio ngue esecha oso ra. Mbia mbiirandu randu sucha tubɨrɨã jenda. ");
INSERT INTO srqNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—A emo ndiqui a. Semumbusẽ ja que ra. Cristo chõ ae reae. Nyao rã mae erese, ɨ que acuanɨ mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nyebe mbia nyoɨ ja nguiã ícuaa. Jirandu mae Jesús rese. Acuanɨ ñee nguire. ");
INSERT INTO srqNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","—Mbae mo eu, ɨ chɨɨbe ɨbe que echɨmbaaquiatu Jesús je ra. Acuanɨ oso mose sucha tubɨrɨã. ");
INSERT INTO srqNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Tei. Sechɨu jẽɨcuayãte jẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","—Emo mbae mo queru echɨurã ndeae, ɨ que echɨmbaaquiatu ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús que ñee ee ra. —Ae rɨɨ̃ Paba ñee seje nae, ũquɨ̃ tasaã mbeɨ quia ee. Paba cheẽ mumbayã mose, ũquɨ̃ ño sechɨu riqui nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Pete mbae ɨshao shao ñɨ pe”, jenye chõchɨ̃ nguiã ã. Mbiaco yenda ea ɨreɨ̃ ɨshao iriã na ño mbia riqui nguiã ã. Sã mbia riqui nyoɨ mbae a ɨshao shao no. Eɨ̃ jenye sɨ chõ nguia nyoɨ mbia reru reru seje. Serese siqui sacuã. ");
INSERT INTO srqNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","38","Sã emo ndiqui mbae a ɨshao shao no. Sã mbae acha riqui mbae mondo mondo ee eɨshao shao rɨbɨshorõ no. Sã emo ndiqui mbae eɨ̃ tiquia tiquia no. Sã emo ndiqui eɨshao shao equiche mose no. Eɨ̃ sɨ chõ secheẽ no nde. Sã emo ndiqui secheẽ nenei nenei nyii no. Aquere emo mbia reru reru seje no. Ae secheẽ nenei nenei quia nyii nae, ae mbia queru queru quia seje cote nae, ũquɨ̃ ia jate nyɨese cote. Ae emo ndiqui secheẽ nenei nenei nyii, huee jaemondo quia aque. Mbia reru reru sacuã seje. Se mbia mɨngo beɨ sacuã. Emo nane serenei nenei nguiã ee nyii. Jẽ jẽɨngo ereru reru seje ã cote. Jẽya jate riqui jenyɨese ã cote. Ae secheẽ nenei nenei quia nyii, ũquɨ̃ ndese jẽya jate, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","—Jesús que semumbusẽ ja ra, ɨ que acuanɨ ñee sucha tubɨrɨã jenda je ra. Nyebe mbia tubɨrɨã siqui nguiã Jesús ruɨ hue jenda cote. ");
INSERT INTO srqNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaria jenda que nyoɨ Jesús rea cote ra. —Eɨco are jiri ure rese, ɨ que mbia Jesús je ra. Nyebe Jesús itõ nguiã nyeremo huee. ");
INSERT INTO srqNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesús sɨ́ que mbia mbaaquiatu quiatu cote ra. Nyebe mbia tubɨrɨã siqui tuchɨ nguiã eruɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mbia que ñee acuanɨ je cote ra. —Nde chõ ngue urembiirandu rei nyii ra. Uremae ngue erese cote ra. Echeẽ ngue urechandu cote ra. Nyebe ureɨco nguiã eɨcua tuchɨ ã cote. Erecheẽ ñooñoa ngue ra. Cristo tuchɨ chõ ae re. Mbia rirõsa mbae ɨcuã sɨ chõ ae re, ɨ que mbia ñee acuanɨ je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Huee que Jesús itõ nyeremo nda. Samáriaa. Hue sɨ que esɨ sɨ nyuruã Galilea quiti ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","—Mbia ra Dios cheẽ nenei neneisa quereco turã eã hue jenda sɨ́ mose, ɨ que Jesús nyii ra. Nyebe esɨ nguiã Galiléaa. ");
INSERT INTO srqNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jesús que ngasẽ Galiléaa cote ra. Mbia hue jenda que embucuasẽ turã nda. Mae nguiatu equia erese Jerusalén neaẽ. Pascua mose. Mbia mae sayã nguiatu ngue Jesús saã saã nguiã ee nyii. Nyebe eyate nguiã Jesús cuasẽ mose cote. ");
INSERT INTO srqNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús que oso sɨ Caná de Galilea no nda. Ae eriqui i mbuchiicabo uva rique rã mbia je nyii nae, huee que esɨ sɨ ra. Hue rurubi que ererecua mo ndiirĩ ndasi riqui ra. Capernaum, ɨ que hue je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","—Jesús ru Judea sɨ a cote, ɨ que mbia ererecua mbiirandu ra. Nyebe ererecua sɨ nguiã Jesús rea cote. —Seriirĩ chɨ̃ mano serĩte quɨ. Nyao terembucherõ seje, ɨ que ererecua ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","—Mbia mae sayã naa eã mose ra jẽ seɨcuayã ñochɨ̃ nde, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Nyao jeɨ rã. Seriirĩ nda mano nyee re, ɨ que ererecua Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Esobe nyebi ndechuchúaa. Nderiirĩ ngue nyerõ nda, ɨ que Jesús ee ra. —Jesús ñee ñooño aroneate, ɨ que ererecua oso nyebi ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Echuchua rurubi que erimba ngaẽ erobeɨshɨ̃ ñee nda. —Nderiirĩ ngue nyerõte ra, ɨ que ñee embiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿Ma tenda seriirĩ ngasi ucua re? ɨ que ererecua ra. —Tenda nyiichere ramo mose que nderiirĩ ngacu ucua curɨ ra, ɨ que mbia ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","—Hue tenda tuchɨ que Jesús ñee seje curɨ ra. “Nderiirĩ ngue nyerõ nda”, ɨ seje curɨ, ɨ que ererecua ra. Nyebe eriqui nguiã Jesús ɨcua tuchɨ cote. Echuchua jenda abe que Jesús ɨcua ja cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judea sɨ que Jesús ru Galiléaa ra. Mbia mae sayã nyeremo ngue Jesús saã Galilea jenda je ra. I que esaã uva riquerã nyii ra. Ererecua riirĩ ngue embucherõ namo no nda. ");
INSERT INTO srqNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Aquere que judíos mbae fiesta ra. Jesús que oso Jerusalén fiesta mose ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Oveja ɨquesa que chɨ̃ huee ra. Mbia icua abe que chɨ̃ huee ra. Cinco tei que chɨ̃ hue eicua mama nda. Betesda, ɨ que judíos hue mbia icua je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mbia rasi que chɨ jate nyaara huee ra. Taiqui re. Eresayã. Ecuatayã. Echaacua. Mbia rasi chumumbara que chɨ huee ra. I rebera raarõ arõ. ");
INSERT INTO srqNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Angel mo nda nguichi quichi quia ra. I mumbera sacuã mbia rasi je. —Ae rane nda ua ama ndebera mose nae, aque rane nda nyerõ, ɨ que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ameɨ ndasi ima mo ngue chɨ beɨ aque rɨ̃ nda. Treinta y ocho años que ameɨ ndasi ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Aque que chɨ nyaara Jesús je ra. —Aa chõ erasi riqui beɨ a cose re, ɨ que Jesús uchɨangui re ra. —¿Erecherõ sete ere? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ameɨ ndasi que ñee ee ra. —Aba quia ra sembua i ye, i rebera mose. Mbia rane ngue secuã secuã nguia ra. I rebera mose, ɨ que erasi Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús que ñee ee ra. —Ẽhuã. Ndequisa erao. Eso, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Echeẽ mose que nyerõ nda. Uquisa que esirõ serao ra. Erasiã ngue oso cote ra. Sábado mose que Jesús embucherõ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nyebe judíos paama ɨ nguiã embucherõ mose sábado mose. —Co mose que mbia uquenea ucua ra. ¿Mbaerã nda ndequisa ererao re? ɨ que judíos Jesús chɨmbucherõ je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—Ae sembucherõ, aque que ñee seje ra: “Ndequisa erao. Eso”, ɨ que sembucherõsa seje ra, ɨ que judíos cheẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Judíos que ñee ee ra. —¿Aba aque re? ¿Aba “ndequisa erao”, ɨ ndeje re? ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","—Aɨcua eãte se. Aba chõ sembucherõ. Mbia tubɨrɨãte quiatu ngue re, ɨ que erasi judíos je ra. Jesús oso rei. ");
INSERT INTO srqNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Emo mose que Jesús ngasembe uchɨmbucherõ je ra. Dios chuchúaa. Ñee ngue ee ra. —¡Sã jẽ! Arembucherõ ngue se resẽ. ¡Mbae ɨcuã nda eresaã sɨchɨ̃ jẽ! Mbae mo nda jeɨ̃ tuchɨ ndeje cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ameɨ ngue oso judíos mbiirandu cote ra. —Jesús chõ sembucherõ nguia reaẽ, ɨ que judíos je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nyebe judíos paama ɨ nguiã Jesús je. Nandeɨquia, ɨ. Sábado mose quia Jesús riqui nguiã mbia mbucherõ cherõ judíos je. Judíos uquenea ucua mose. Nyebe judíos paama ɨ nguiã ee. ");
INSERT INTO srqNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús que ñee judíos je cote ra. —Paba recoteã mbeɨte riqui co. Namo abe. Se abe Paba rã sɨ serecoteã teã mbeɨte riqui co, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nyebe judíos riqui nguiã paama ɨ tuchɨ Jesús je. Ɨquia serɨ̃ serɨ̃te que cote ra. Jesús que judíos cheẽ mumba mumba ra. Mbia rasi mbucherõ cherõ sábado mose. —Dios rã sɨ aɨco co. Paba rei Dios, ɨ que Jesús ra. Nyebe judíos paama ɨ tuchɨ nguiã ee. ");
INSERT INTO srqNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús que ñeembe judíos je ra. —Dios rucucha rei se. Dios rucucha ae ra mbae saã eã. Se ae ra mbae asaã eã. Paba chɨsaã ndese maende ae aɨco nguiã mbae raã naa se abe co. Ae Paba saã saã nguia, ũquɨ̃ asaã saã ja quia se abe co. ");
INSERT INTO srqNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Dios rucucha rei se. Paba riqui nyesecua tuchɨ serese co. Paba riqui uchɨao reacuquia tuchɨ seje co. Uchɨao ra eteacuquia tuchɨ seje cote. Mbia mae sayã tuchɨ. Jenyuruɨra tuchɨ ra mae erese cote. ");
INSERT INTO srqNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Paba mbia raaque mbuquera quera. Se abe ra mbia raaque ambuquera quera. Ae amɨngo beɨ sete, ũquɨ̃ abe ra amɨngo beɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Paba ra mbia mo mondo eã tata cuásuu. “Nde chõ mbia equirirõ ndirõ mondo tata cuásuu”, ɨ que Paba seje ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ɨ̃ nda mbia ñee turã serɨɨ̃. Sã mbia riqui ñee turã Paba rɨɨ̃ no. Ae ñee turã eã nguia serɨɨ̃, ũquɨ̃ ñee turã eãte Paba abe rɨɨ̃ no. Dios rucucha rei se. Dios chɨmee ndei se. ");
INSERT INTO srqNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Tacheẽ nyecua jẽje. Secheẽ andusa ra siqui beɨ. Paba ɨcuasa ra siqui beɨ. Nyoɨ eã mbeɨ ra tata cuásuu. Paba ra emɨngo beɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tacheẽ nyecua jẽje. Namo jiri ra mbia raaque secheẽ andu. Secheẽ mumbasa reã nda siqui beɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Paba quiarei mbia mɨngo beɨsa. Se abe rei mbia mɨngo beɨsa Paba ruɨ sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Se abe ra mbia amondo tata cuásuu. “Nde chõ mbia equirirõ ndirõ mondo tata cuásuu”, ɨ que Paba seje ra. Se chɨ̃ erucucha. ");
INSERT INTO srqNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","¡Jenyuruɨra techɨ̃ nda secheẽ mose jẽ! Mbia raaque ra secheẽ ñandu ja chee. ");
INSERT INTO srqNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Júã ja ra ngua sɨ. Ae siqui turã, ũquɨ̃ nda Dios mɨngo beɨ cote. Ae siqui ɨcuã ɨcuã nguia, ũquɨ̃ nda nyoɨ tata cuásuu. ");
INSERT INTO srqNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Se ae ra mbae asaã eã. Paba cheẽ nduɨ sɨ chõ aɨco nguiã mbia mondo tata cuásuu. Paba cheẽ nduɨ sɨ chõ aɨco nguiã mbia mɨngo beɨ no. Paba cheẽ nda achabiã. Paba cheẽ nguire chõ aɨco nguiã mbae raã naa co. Se ae eã ño ñene. ");
INSERT INTO srqNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Se ae eã ño acheenei enei nguiã mbia je co. Ɨ̃ nda “ɨchõɨño” jenye rei seje. ");
INSERT INTO srqNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Aque emo ndiqui serenei nenei mbia je aque. Aque eriqui ñee ñooño eã serɨɨ̃ aque. ");
INSERT INTO srqNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jemo ngue jemondo Juan je. Jẽirandu sacuã serese. Juan ngue ñee ñooño eãte jẽje ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ae mbia ñee ñee serɨɨ̃, ũquɨ̃ ñee ndeseã aɨco nguiã se. “Dios riirĩ eã ño co re”, ɨ mose mbia serɨɨ̃, Dios riirĩ mbeɨ chõ se re. Jẽɨcuã mbutiã sacuã ño aɨco rei nguiã ñee jẽje. ");
INSERT INTO srqNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Tata rendi rã ndei Juan. Mbae resae ja raque. Huee que jengu mbɨrɨ̃ ndei erese ra. Jẽhuɨ jeɨ chõchɨ̃ esɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan ñee ngue mbia mbiirandu rei serese ra. Sechɨsaã nguia mbia mbiirandu tuchɨ serese Juan ñee sɨ. Dios cheẽ nguire ae aɨco nguiã mbae ao ao co. Sechɨsaã ndese mae jee mbia jirandu nguiã serese cote. “Dios chɨmondo quiarei Jesús”, ɨ mbia cote. ");
INSERT INTO srqNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Paba abe riqui serenei nenei mbia je co. Paba cheẽ jeñanuate raque. Jemae sayãte raque Paba no. ");
INSERT INTO srqNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Jẽ nguia seɨcuayãte nguiã co. Paba chɨmondo chõ se re. Nyebe Paba cheẽ chɨ̃ eãte jendese. ");
INSERT INTO srqNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Embesa ji rese jẽɨngo mae tuchɨte raque. “Embesa ji ra nandemɨngo beɨte”, jenyechɨ̃ nguiã. Serese jembiirandu sacuã ño embesa ji re. Se quiatu mbia mɨngosa tuchɨ re. ");
INSERT INTO srqNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jẽ nguia jẽɨngo sereãte nguiã serese. Ɨ̃ nda se jaemɨngo beɨte rei. ");
INSERT INTO srqNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Jẽɨngo eã mose Dios rese, sebiãte jeñee turã turã mose serɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Co aɨco jẽɨcuate co resẽ. Jenyesecua eãte quia Dios rese co resẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Paba que sembu resẽ. Jẽo eã ñochɨ̃ serese. Paba chɨmondo eã tu mose, aque rese quia ra jẽo tuchɨte cote. ");
INSERT INTO srqNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mbia resa rae jẽɨngochɨ̃ nguiã jẽturã naa naa. Dios je quiarei jẽturã eãte. ¿Mañɨ jenye quiatu ra equia seɨcua re? ");
INSERT INTO srqNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Se quia ra jẽɨcuã ambuchecua eã Paba je. Moisés chɨmbesa quia jẽɨcuã mbuchecua nguiã. “Moisés chɨmbesa rei mbia mɨngo beɨsa”, jenyechɨ̃ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés chɨmbesa jẽɨcua eãte quia ã. Nyebe jẽɨngo nguiã seɨcua eãte ã. Serɨɨ̃ ngue Moisés embesa ra. ");
INSERT INTO srqNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","“Nyia” jenye eã mose Moisés chɨmbesa je, “nyia” jenye eã nda secheẽ mose abe no, ɨ que Jesús judíos je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Aquere que Jesús choɨ ama ndɨsa rasa ra. Galilea, ɨ que ama ndɨsa je ra. Tiberias, ɨ abe que ee ra. Hue robeɨ que echoɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mbia que nyoɨ tuchɨte Jesús ruɨ ra. Mbia mae sayã ngue Jesús saã saã nguia ra. Echɨsaã ndese que mbia mae mae nda. Mbia rasi mbucherõ cherõ mose. ");
INSERT INTO srqNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Sɨta ibate rɨ̃ ngue Jesús choɨ ra. Huee que echɨ ngoi uchɨmbaaquiatu rese ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Fiesta de pascua rurubi que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mbia tubɨrɨã ngue ngaẽ nguia Jesús ruɨ ra. Jesús que mae erese ra. Ñee ngue Felipe je ra. —Mbia tubɨrɨã tuchɨ. ¿Mangue ra echɨurã nandeisi mangue re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús eɨcuate raque. —Mañɨ nda Felipe quia secheẽ mose reae, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe que ñee ee ra. —Doscientos plata mbia chayãte mbia chɨurã isi sacuã. Echayã tuchɨte, ɨ que Felipe ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrés abe que chɨ ra. Jesús chɨmbaaquiatu. Simón Pedro nongue. Ae que ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—A ãquẽ mo ndiqui a. Cinco mbichae rerequia a. Sɨra nyeremo abe rerequia a. Echayãte quiatu nda re. Mbia tubɨrɨãte quia ñene, ɨ que Andrés Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—“Jengoi ja”, jenye mbia je, ɨ que Jesús ra. Quiata turã ngue huee ra. Quiata tose que mbia ngoi ja ra. Mbia cuabẽ. Cinco mil que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús que mbichae isi cote ra. Ɨaanye, ɨ que ngu je cote ra. Mbichae rɨɨ̃. Mbichae que embuchao chao cote ra. Uchɨmbaaquiatu je que emondo mondo ra. Echɨmbaaquiatu que emondo mondo mbia je cote ra. Ae chɨ ngoi. Sɨra abe que embuchao chao mbia je ra. Mbia que eu ja ra. Mbia que echoseɨ chɨã chɨã nyee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mbia rio ja mose que Jesús ñee uchɨmbaaquiatu je cote ra. —¡Mbia chɨu sique jemunua nua jẽ! ¡Jendecoquiatu ja jẽ! ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Echɨu sique que emunua ja ra. Doce irairu que puk i ja ra. Mbichae sique sique. Cinco chõ ndei que mbichae nyii aẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mbia que mae tuchɨ Jesús rese ra. Mbichae mbeta rese ra. Ũquɨ̃ ndese que mbia riqui mae eã tuchɨ nyii ra. —Dios cheẽ nenei neneisa chõ co riqui re. Ae uresaarõ arõ nguia, ae chõ eriqui re, ɨ que mbia Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesús que mbia ɨcua ra. —Mbia ra seisichɨ̃ suruchoɨ ererecuarã nde, ɨ que ra. Nyebe esɨ sɨ nguiã mbia recha. Sɨta ibate rɨ̃ ngue esɨ erecha ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Itondaru ndaru que Jesús chɨmbaaquiatu choɨ ama ndɨ́saa ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nyuɨ nyuɨ que canoa ye cote ra. Aque echoɨchɨ̃ nguia iasa Capernaum aque. Jesús que nyebi eã mbeɨte u ee ra. Itondaru chee. Nyoɨ chee que erecha ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Quɨrɨrɨã ngue tu ɨcuã ɨcuã ee ra. Ama ndiite re mbia reco mose. I rebera que tu asi asi tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mbia que nyoɨ choɨ beɨ canoa ye ra. Una legua. Jesús que canoa curubite cote ra. I arõ ngue esɨ quia ngata ra. Canoa yenda que mae erese ra. Echɨã ngue cuaãcuã ɨ tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","—Se chõ nyeresẽ. ¿Mbaerã jẽɨngo siquiche sesɨ re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Canoa yenda que oote erese cote ra. Mbua que canoa ye ra. Ngasẽ asi que ecuaẽ íbii cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mbia cuabẽ ngue chɨ sobeɨ ra. Isamamɨ ngue Jesús tiãte ee ra. Nyebe ñee nguiã nyue. —Canoa mɨɨ ño ngue chɨ resẽ. Canoa ye eã ño Jesús sɨ iasa resẽ. Echɨmbaaquiatu achõ ño ngue nyoɨ iasa canoa ye resẽ. ¿Mangue Jesús riqui mangue re? ɨ que mbia cuabẽ u ñee Jesús requia ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Aque mose que canoa mo ngaẽ ngasẽ ee ra. Tiberias sɨ que canoa cuaẽ nda. Mbia mbichae usa rurubi que ecuaẽ tiba ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jesús tiã mbeɨ que mbia je huee ra. Mbichae úsaa ra. Echɨmbaaquiatu abe tiã ngue mbia je ra. Nyebe mbia choɨ nguiã erequia canoa ye. Ngasẽ ngue coquimo cote ra. Capernaum, ɨ que hue sucha je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mbia cuabẽ ngue ngaẽ ama ndasa coquimo ngote ra. Ngasẽ ngue Jesús je cote ra. —Mbia mbaaquiatusa, ¿manose erechu ngasẽ aa re? ɨ que mbia cuabẽ Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús que ñee ee ra. —Tacheẽ nyecua jẽje. Se jembuquiarure chõ jẽɨngo nguiã serese. Se jembiore chõ jẽɨngo nguiã serese. Sechɨsaã ɨcuare rocoɨ̃. Jemae sayã ngue asaã saã ndei quia resẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jenyɨurã ndese jẽɨngochɨ̃ nguiã ndua tuchɨte. Ũquɨ̃ nda ua jeɨte. Ae ua eã mbeɨte quia, ũquɨ̃ ndese quiatu jendua. Mbia mɨngo beɨsa rese quiatu jendua. Se rei mbia mɨngo beɨsa. Se rei Dios rucucha. Paba que uquirãcuã mondo seje ra, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mbia que ñeembe Jesús je ra. —¿Mañɨ ure ra equia re? ¿Mbae rese ra aba riqui Dios mbia re? ɨ que mbia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús que ñeembe ee ra. —Dios que sembu ra. Seɨcua quia se. Seɨcua mose ra Dios ia tuchɨ jendese cote, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","—¿Mbae mo nda eresaã na ure je re, uremae sayã nde? Ɨ̃ nda uremae nderese. Eɨ̃ ure ra ndeɨcua cote. ");
INSERT INTO srqNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Cose nda nanderameɨ ndiqui maná u u turuquia rɨ̃ nda. Sã embesa ji no: “Dios que mbichae mbu ibei sɨ mbia je ra”, sã embesa ji riqui ɨ no, ɨ que mbia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús que ñee ee ra. —Tacheẽ nyecua jẽje. Moisés eã ño ngue mbichae mondo nguiã mbia je ibei sɨ. Paba chõ ngue emondo nguiã ibei sɨ mbia je. Aque mbichae ra mbia mɨngo beɨ eã. Paba ra mbia mɨngo beɨsa mondo mbia je cote. ");
INSERT INTO srqNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Dios riqui mbichae mbuae mondo mondo mbia je co. Ae Dios mondo mondo nguiã mbia je co nae, aque que tu ibei sɨ ra. Aque rei mbia mɨngo beɨsa, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mbia que ñee Jesús je ra. —Aquembichae mbichae emondo mondo beɨ quia ure je, Urererecua, ɨ que mbia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús que ñee ee cote ra. —Mbichae rã ño se re. Mbia mɨngo beɨsa chõ se re. Serese siqui mose ra jeniãcuã eã mbeɨ. Serese siqui mose ra jẽɨseɨ eã mbeɨ. Jẽya beɨ rae. ");
INSERT INTO srqNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Jemae ndei que equia serese resẽ. Seɨcuayã mbeɨ chõchɨ̃ nguiã ã. Acheẽ ndei que jẽje nyii resẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ae Paba mee seje mbia nae, ũquɨ̃ nda siqui beɨ serese. Ũquɨ̃ nda aisi teã eã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Paba que sembu ibei sɨ resẽ. Secheẽ nguire eã ño aɨco nguiã mbae raã naa. Paba cheẽ nguire ae chõ aɨco nguiã mbae raã naa co. ");
INSERT INTO srqNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","“Ae amondo ndeje nae, ũquɨ̃ mo nda quiachãchɨ̃”, ɨ que Paba seje ra. Ambuquera ja ra se, se tube mose íbii. ");
INSERT INTO srqNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Se rei Dios rucucha. Paba que sembu ra. Ae seɨcuate nae, ũquɨ̃ nda siqui beɨ. “Ũquɨ̃ nda amɨngo beɨ”, ɨ que Paba ra. Ũquɨ̃ nda ambuquera ja, se tube mose íbii, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Judíos que paama ɨ Jesús je ra. —Se rei mbichae rã. Ibei sɨ que achu ra, ɨ mose que judíos ñee ɨcuã ɨcuã Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—Jesús chõ co re. José riirĩ ño co re. Eru rese que nandemae ndesẽ. Esi abe rese que nandemae ndesẽ. ¿Mbaerã eriquiñee nande je re? “Ibei sɨ que achu ra”, ɨ nande je re, ɨ que mbia ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús que ñee ee cote ra. —¿Mbaerã jẽɨngo ñee ɨcuã ɨcuã serɨɨ̃ nde? ");
INSERT INTO srqNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mbia ae ra siqui eã serese. Paba emɨngo mose serese, aque mose ra eriqui tuchɨ serese cote. Ũquɨ̃ nda ambuquera sɨ mɨngo sechube mose íbii. ");
INSERT INTO srqNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","“Dios ra mbia mbaaquiatu ja”, sã embesa ji riqui ɨ no. Nyebe ra Paba cheẽ andusa siqui beɨ serese. Nyebe ra Paba cheẽ mumbasa reã siqui beɨ serese. ");
INSERT INTO srqNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Emo ngue mae eãte Paba rese ra. Se mɨɨ ño ngue amae erese ra. Esɨ chõ ngue achu resẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tacheẽ nyecua jẽje. Ae seɨcuate quia nae, ũquɨ̃ nda siqui beɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Se rei mbichae rã. Mbia mɨngo beɨsa rei se. ");
INSERT INTO srqNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nanderameɨ ngue maná u u turã ndei quia turuquia re ra. Emo mose que mano mano ja ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mbichae mbuae chõ asenei senei nguiã jẽje co. Mbia mɨngo beɨsa rei mbichae mbuae. Aque que tu ibei sɨ ra. Ae mbichae mbuae u nae, ũquɨ̃ nda siqui beɨ. Ũquɨ̃ nda ua eã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Se rei mbichae. Ibei sɨ que achu ra. Mbia mɨngo beɨsa rei se. Ae seu nae, ũquɨ̃ nda siqui beɨ. Mbichae ra amee mbia mɨngo beɨ sacuã. Aque mbichae rei serete sɨ́. Seroo sɨ́, ɨ que Jesús judíos je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judíos que ñee ɨcuã ɨcuã nyue cote ra. —¿Mañɨ nda nguete mee nandechɨurã nde? ɨ que nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús que ñee ee cote ra. —Tacheẽ nyecua jẽje. Mbiarã ngue achu ra. Serete jẽu eã mose, jẽɨngo beɨ eã ndae. Seruqui jembei eã mose, jẽɨngo beɨ eã ndae. ");
INSERT INTO srqNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ae serete u quia nae, ũquɨ̃ nda siqui beɨ. Ae seruqui mbei quia nae, ũquɨ̃ nda siqui beɨ. Ũquɨ̃ nda ambuquera sɨ mɨngo, sechube mose íbii. ");
INSERT INTO srqNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Serete rei mbia chɨu rã. Seruqui rei mbia chimbei rã. ");
INSERT INTO srqNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ae serete u quia nae, ae seruqui mbei quia nae, ũquɨ̃ nda siqui beɨ sechɨangui re. Se abe ra aɨco beɨ echɨangui re. ");
INSERT INTO srqNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Paba riqui beɨ co. Paba riqui semɨngo se abe co. Eɨ̃ nda serete usa abe siqui beɨ. Amɨngo beɨ ra se. ");
INSERT INTO srqNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mbichae mbuae chõ asenei senei nguiã jẽje co. Ae tu ibei sɨ. Maná na eã ño aque mbichae re. Maná ngue nanderamei u u rei ra. Maná ngue mbia mɨngo beɨ eã nda. Emo mose que mano ja chõ nda. Ae sechɨmee u quia nae, ũquɨ̃ nguia ra siqui beɨ, ɨ que Jesús judíos je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Eɨ̃ ngue Jesús quia judíos mbaaquiatu quiatu ra. Capernaum. Judíos chumunuásaa. ");
INSERT INTO srqNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesús cheẽ andusa que ñee tuchɨ nyue ra. —Mbaranguiatuã tuchɨ chõ Jesús cheẽ ndiqui re. Echeẽ nandemumba eã aroneate quiatu quia re, ɨ que nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","—Mbia riqui ñee ɨcuã ɨcuã tuchɨchɨ̃ secheẽ nɨɨ, ɨ que Jesús uchɨangui re ra. Nyebe ucheẽ mbuchecua ee cote. —¿Mbaranguiatuãte secheẽ jẽje re? ");
INSERT INTO srqNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Mañɨ jenye ra mae mose serese re? Seso sɨ mose ibate re. ");
INSERT INTO srqNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nande rete nandemɨngo eã nguiã. Nande aĩ ño nandemɨngo nguiã. Secheẽ nguia ra mbia mɨngo beɨ ibátee. ");
INSERT INTO srqNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Seɨcua ja eãte quiatu nguiã ã. Jemo seɨcua eãte quia ã, ɨ que Jesús ee ra. Mbae ao ramo mosenda beɨ que Jesús mbia ɨcua uchɨangui re ra. —Ã nda seɨcua. Ã nda seɨcua eã. Co ra semondo mbia ɨcuã je, ɨ que Jesús mbia ɨcua uchɨangui re nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","—Acheẽ ngue jẽje nyii, ũquɨ̃ sɨ́ aɨco ñee jẽje a. Mbia ae ra siqui eã serese. Paba emɨngo mose serese, aque mose ra eriqui tuchɨ serese cote, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aque mosebe beɨ que mbia tubɨrɨã huɨ Jesús sɨ cote ra. Ae siqui erese nyii nae, ũquɨ̃ mo ngue huɨ ja esɨ cote ra. Ngatayã ngue equia eruɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús que ñee uchɨmbaaquiatu je cote ra. Doce je. —¿Jẽ abe ra jẽhuɨ sesɨ re? ɨ que uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro que ñee ee ra. —Tei, Urererecua. Aba ruɨ quia ra ureɨco cote. Ndecheẽ ño mbia mɨngo beɨsa resẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ureɨco ndeɨcua ã cote. Cristo rei nde. Dios rucucha rei nde, ɨ que Pedro ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús que ñee ee cote ra. —Jẽ doce que jaẽirabo rei ra. Sechɨmbaaquiatu sacuã. Jemo ngue diablo rã nda, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas Iscariote rɨɨ̃ ngue eriqui ñee nda. Diablo, ɨ. Simón ndiirĩ ndei Judas. Ae quia Jesús mee nguiã mbia ɨcuã je. Jesús chɨmbaaquiatu mo ndaque. ");
INSERT INTO srqNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","—Jesús nandeɨquia, ɨ rei que judíos quia ñee ñee nyue ra. Nyebe Jesús sɨ eã nguiã Judea cote. Galilea beɨ que eriqui ngata ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Fiesta rurubi mose que cote ra. Tuchua ñetẽ ngue judíos saã saã mbeɨ quia aque fiesta mose ra. Curubite que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesús nongue que ñee ja ee ra. —Eso rã Judea. Ɨ̃ nda ndechɨmbaaquiatu mae ja ndechɨsaã ndese Judea jenda. ");
INSERT INTO srqNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","¡Mbae esaã nyecua chõ mbia resa rae jẽ! Ɨ̃ nda mbia ndeɨcua ja. Co ereɨco mbia mae sayã naa naa co. Mbia resa rae quiatu esaã saã, ɨ que enongue ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesús nongue abe que Jesús ɨcuayãte ra. Nyia, ɨ eã Jesús cheẽ je. ");
INSERT INTO srqNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús que ñee ee cote ra. —Emo mose quia ra aso nyecua mbia je cote. Jẽ jẽso jẽ ae ae, jẽsose mose. ");
INSERT INTO srqNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dios cheẽ mumbasa riqui jẽucuayã eãte raque jẽ. Se quia eriqui nguiã seucuayãte ã. “Jenyɨsaã saã nguia eɨcuãte riqui nguiã”, ae quiatu nguiã ee co. Nyebe eriqui nguiã seucuayãte ã. ");
INSERT INTO srqNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jẽ ño jẽso fiesta rea. Se ra asoã. Emo mose quia nda achecua nguiã mbia je cote, ɨ que Jesús ngõngue je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesús que siqui are jiri Galilea cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jesús nongue que nyoɨ fiesta rea cote ra. Aquere que Jesús abe sɨ mingue cote ra. Ngasẽ nyecuayã ño ngue oso ra. —Mbia ra jiranduchɨ̃ serese re, ɨ que uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judíos rerecua que Jesús sequia sequia ja u ra. —¿Ma Jesús riqui ma nde? ɨ ja que fiesta mose ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mbia que ñee ata atate Jesús rɨɨ̃ nda. —Jesús turãte que, ɨ que emo emo nda. —Jesús turã eã ngue ra. Mbia mbɨɨrɨ̃ ɨrɨ̃te que equia no nda, ɨ que emo emo no nda. ");
INSERT INTO srqNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mbia que siquichete judíos rerecua sɨ ra. Nyebe mbia ucheẽ mbuchecua eã nguiã Jesús rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fiesta ite mose que Jesús sɨ Dios chuchua mbia mbaaquiatu quiatu cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judíos que nyuruɨra tuchɨ Jesús cheẽ andu ra. —Eaquiatute quia eriqui re. ¿Mangue eriqui ñimbaaquiatu mangue nyii re? ɨ que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús que ñee ee ra. —Secheẽ ae eã asenei senei nguiã jẽje co. Paba cheẽ ño asenei senei nguiã jẽje. Ae sembu. ");
INSERT INTO srqNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Emo siquise mose Dios cheẽ nduɨ, aque ra Dios cheẽ ɨcua tuchɨ. Aque ra ñee. “Ucheẽ ño eã Jesús senei senei nguiã mbia je co. Dios cheẽ ño esenei senei nguiã mbia je co”, ɨ ra aque ñee serɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","“¡Sã mbia ñee turã mbe ɨ serɨɨ̃ jẽ!” ɨ ra emo ucheẽ achõ nenei nenei. “¡Sã mbia ñee turã mbeɨ Dios rɨɨ̃ nguiatu jẽ!” ae chõ nguiã Dios cheẽ nenei nenei se co. Acheẽ ñooño eã ño nguiã co. Mbia ambɨɨrɨ̃ ɨrɨ̃ eã ño nguiã co. ");
INSERT INTO srqNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés que Dios cheẽ mbesa rei nande je ra. Nande emumbayã sacuã. Jẽ nguia rei Dios cheẽ mumba. ¿Mbaerã jẽɨngo seɨquia serɨ̃te re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mbia que ñee ee cote ra. —Emo ndiqui ndeɨquia serɨ̃ eãte co. Aba checuayã ɨcuã ae nembɨɨcuã ndeae, ɨ que mbia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús que ñee ee cote ra. —Mbia rasi mo ngue ambucherõ sábado mose. Aque mɨɨ ño ngue asaã ndei nguiã. Aque mɨɨ je chõ jẽɨngochɨ̃ nguiã nyuruɨrate mae serese. ");
INSERT INTO srqNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés que circuncisión teacuquia jẽje ra. Nanderameɨ nane ngue circuncisión saã nguiirĩ je ra. Nyebe jẽɨngo nguiã sábado mose abe circuncisión naa naa jendiirĩ je. ");
INSERT INTO srqNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moisés cheẽ nguire chõ jẽɨngo nguiã circuncisión naa naa jendiirĩ je ã. Sábado mose abe. ¿Mbaerã jẽɨngo paama ɨ seje mbia mbucherõ mose sábado mose re? ");
INSERT INTO srqNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","“Aque eɨcuãte”, jenye jeɨ chõchɨ̃ nguiã. Jẽirandu turã na erese nyii, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalén jenda que ñee ñee Jesús rɨɨ̃ cote ra. —A Jesús riqui ñee mbia je a. ¿Nandererecua ra Jesús ɨquia eã sɨ chõ nde? ");
INSERT INTO srqNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","A eñɨ nyecua ñee mbia ite re a. Nandererecua ñee eã tuchɨ chõchɨ̃ ee. Teachõ tuchɨ chõchɨ̃. ¿Cristo eriqui reɨ̃ nandererecua je re? ");
INSERT INTO srqNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Cristo eã ño Jesús re. Galilea jenda chõ ae re. Cristo tu mose quiatu ra nandeiranuate. Ma sɨ chõ nda eru, ɨ que Jerusalén jenda ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús que echeẽ ñandu ja ra. Dios chuchúaa eriqui mose mbia mbaaquiatu quiatu. Nyebe Jesús echeẽ ndɨbɨshorõ nguiã cote. —¿Ma sɨ achu co re? ¿Jẽ seɨcuate re? Se ae achu eã nguiã co. Sembu ji ae aɨco nguiã co. Ɨchõɨñosa reã ae ngue sembu nguiã. Ae rese jemae ãte nae, ae chõ sembu nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Se ae que amae erese ra. Esɨ que achu ra. Ae chõ sembu nguiã co, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mbia que paama ɨ Jesús cheẽ mose ra. —Jesús nandeisi etarõ sacuã, ɨ rei que mbia ñee nyue ra. Ae mbia eisiã ño nguiã. —Aque mose ra eremano, ɨ ãte quiarei Dios ee. ");
INSERT INTO srqNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mbia tubɨrɨã ngue Jesús ɨcua ɨcua ramo nguia cote ra. Nguerecuarã. —Cristo tuchɨ rei co. Co eriqui mbia mae sayã naa naa tuchɨ co. Emo aquiatu mo nda tuãte rei. Co mɨɨ tuchɨ chõ ndei Dios chɨmbu co, ɨ que mbia tubɨrɨã nguia ñee ñee Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseos que nyiisaquia mbia cheẽ ndese ra. Mbia ñee turã turã mose Jesús rɨɨ̃. Nyebe fariseos paama ɨ nguiã Jesús je. Policía jenda mo ngue emondo rei Jesús isi sacuã nda. Sacerdote rerecua abe que policía jenda mondo rei Jesús isi sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús que ñee nda. —Aɨco mbɨrɨ̃ ño nguiã jendese a cote. Aquere ra aso sɨ Paba rea. Ae sembu. ");
INSERT INTO srqNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jẽ nda serequia cote. Serea eãte ra se cote. Ae ra aso nae, huee jengasẽ aroneate, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judíos que ñee nyue ra. —Manguiti ra esɨ reae. Manguiti ra nandecuasẽ aroneate ee reae. Judíos siqui quia griegos rese nae, ũquɨ̃ ndea ra esɨ reae. Griegos mbaaquiatu sacuã ndeae. ");
INSERT INTO srqNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“Serequia ra se cote. Serea eãte ra se. Ae ra aso nae, huee jengasẽ aroneate”, ɨ chõchɨ̃ nguiã nande je. ¿Mbaerã eriqui ñee nande je ũquɨ̃ nde? ɨ que judíos u ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Fiesta ua nonde que mbia ñumunua tuchɨ cote ra. Fiesta mumba beɨ. Aque mose que Jesús ñɨ juã ñee mbia ite re ra. —“Emo ɨseɨ mose, sã eru serea. Ambɨu ra se. ");
INSERT INTO srqNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ae ra seɨcua nae, i riõ na nda ũquɨ̃. Iãcuã turã na nda ũquɨ̃”, sã embesa ji riqui ɨ no, ɨ que Jesus ucheẽ mbirãtãte mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","—Ae ra seɨcua nae, ũquɨ̃ je ra Espíritu Turã amondo, ɨ ñene. Espíritu Turã mbu nonde chõ eriqui nguiã ñee. Jesús oso eã mose ibate chõ eriqui nguiã ñee. ");
INSERT INTO srqNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mbia tubɨrɨã ngue chɨ Jesús cheẽ andu ra. Ũquɨ̃ mo ngue ñee nyue ra. —Co rei Dios cheẽ nenei neneisa co. Ae uresaarõ arõ nguia co, ɨ que u ñee Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Emo emo ngue ñee nda. —Co rei Cristo tuchɨ co, ɨ que ra. Emo emo ngue echeẽ sɨbɨ shorõ no nda. —Tei. ¿Mañɨ nda Galilea jenda Cristo re? Hue jenda eã ño nda Cristo ndesẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","“David riirĩ nda Cristo. Belén jenda ra Cristo, David rã sɨ”, sã embesa ji riqui ɨ no, ɨ que mbia ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hue rɨ̃ ja mbia ñee eãchɨ̃ Jesús rɨɨ̃. Mbia que ñee ata ata Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","—Jesús nandeisi serao tarõ, ɨ rei que emo emo ñee nda. Isiã sɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Policía jenda ochɨ que nyoɨ nyebi fariseos je cote ra. Sacerdotes rerecua je abe nyebi. —¿Mbaerã Jesús jendu eã ure je re? ɨ que ererecua policía jenda je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Policía jenda que ñee ee ra. —Aque Jesús riqui mbia mbaaquiatu turã tuchɨ aque. Ae rã sɨ emo mbia mbaaquiatu turã aronea, ɨ que policía jenda ñee mbia rerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseos que ñee policía jenda je cote ra. —¿Jẽ abe chee chõ Jesús jembɨɨrɨ̃ ɨrɨ̃ nguia re? ");
INSERT INTO srqNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nandererecua mo ngue “coche rei” ɨã tuchɨ Jesús je resẽ. Fariseos mo abe que “coche rei” ɨã tuchɨ Jesús je resẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ã mbia ataque riqui Dios cheẽ ɨcua eãte ã. Quiachã ja ra Dios sɨ, siqui mose Jesús rese, ɨ rei que fariseos ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo abe rei fariseo. Ae tu Jesús je isa nae, aque que ñee fariseos je ra. Uataque je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Emo nandembasi mbasi chooño aroneate. Echeẽ nandechandu rane nguiatu. Nandeirandu ja rã nguiatu erese. Embasi nonde. Eɨ̃ ngue Moisés embesa mɨɨ nande je ra, ɨ que Nicodemo uataque je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Fariseos que ñee ee cote ra. —¿Nde abe chõ Galilea jenda Jesús rese re? Embesa ji rese emae mae. Dios cheẽ nenei neneisa mo eãte que Galilea jenda resẽ, ɨ rei que fariseos ñee asi Nicodemo je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mbia que nyoɨ ja uchuchua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús que oso Monte de los Olivos ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Isamamɨ ngue Jesús sɨ nyebi sɨ Dios chuchúaa ra. Eresaitõ ndabe. Mbia que esɨɨchã tuchɨ ra. Jesús que ngoi ra. Mbia mbaaquiatu quiatu. ");
INSERT INTO srqNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Fariseos que cuña mo curucuaẽ Jesús je ra. Embesasa rese que cuña ndurucuaẽ ee ra. Cuña nda siqui emo ndu rese mbia je ra. Mbia ite re que fariseos cuña mɨɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ae cuña curucuaẽ nae, ũquɨ̃ ngue ñee Jesús je ra. —Urembaaquiatusa, mbia que mae cuña ndese ra. Emo ndu rese siqui mose. ");
INSERT INTO srqNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés que ñee nande je ra. “Ã jẽɨquia sɨta je”, ɨ que Moisés quia ã mbia rɨɨ̃ nda. ¿Mañɨ ere ra ã nɨɨ ñee nde re? ɨ que cuña ndurucuaẽsa ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","—Jesús nandembɨɨrɨ̃. Ɨ̃ nda ñee ɨcuã. Ɨ̃ nda mbia nandembɨɨcuã Jesús je cote, ɨchõ equia nyii reaẽ. Nyebe cuña ndurucuaẽchɨ̃ ee reaẽ. Jesús que nyatiquio chõ nda. Ibi que embesa mbesa o je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","—¿Mañɨ ere ra nde cuña je re? ɨ beɨ que mbia quia Jesús je ra. Jesús que juã ñee mbia je cote ra. —Jemo turã mbeɨte mose, sã aque rane cuña cheɨ sɨta je, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nyatiquio sɨ que ibi mbesa ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jesús cheẽ andu mose que mbia rerecua ɨreɨ̃ ireɨ̃ ja chõ nda. —Nandeɨcuã jate que, ɨ ja chõ ngue ñee uchɨangui re ra. Nyebe echoɨ nguiã usẽ ja. Ameɨ nane ja que ra. Eataque quia usẽ nguiã eruɨ cote. Ererecua que usẽ ja ra. Jesús ae que siquichõ nda. Cuña ndesechõ. ");
INSERT INTO srqNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús que juã mbia rerecua ruɨbe cote ra. Cuña je que ñee cote ra. —¿Ma nderurucuaẽsa ma nde? “Nandecheɨ rã sɨta je”, ¿ɨãte emo nguia nderɨɨ̃ co re? ɨ que Jesús ñee cuña je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Tei. Emo ñeeãte, Sererecua, ɨ que cuña Jesús je ra. Jesús que ñee ee cote ra. —Se abe ra acheẽ eã ndeje. Eso rei. ¡Mbae ɨcuã nda eresaã sɨchɨ̃ jẽ! ɨ que Jesús cuña je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús que ñee sɨ mbia je ra. —Mbia ja mbaaquiatusa chõ se re. Tata rendi rã ño aɨco nguiã mbia je co. Ae siqui seruɨ nae, ũquɨ̃ nda siquíã itondáruu. Ũquɨ̃ amɨngo beɨ quia querabe co, ɨ que Jesús mbia mbaaquiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseos que ñee Jesús je cote ra. —Ndechue chõ ereɨco nguiã ñee mbia je. Nyebe mbia “coche rei” ɨ aronea ndecheẽ je, ɨ que fariseos ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús que ñee echeẽ ndɨbɨshorõ nda. —Sechue acheẽ ndaque mbia je. “¡Ae beɨ jẽ!” ɨ chõ mbite raque aba secheẽ mose. Ae sɨ achu nae, huee jẽɨcuayãte. Ae ra aso nae, hue abe ra jẽɨcuayãte no. Se ae aɨcua nguiã co. ");
INSERT INTO srqNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jeñee ɨcuã jeɨ chõchɨ̃ nguiã aba rɨɨ̃. Mbae mumbusẽ ja mose rocoĩ. Eɨ̃ ae eã ño nguiã se. ");
INSERT INTO srqNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","“Co eɨcuãte”, ae eã nguiã se ae co. Paba rese chõ aɨco nguiã mbia mumbusẽ ja co. Nyebe aɨco nguiã ñee Paba cheẽ nduɨ sɨ co. ");
INSERT INTO srqNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“Mbia nyeremo ñee mose hue rɨ̃ sɨ, ‘ae beɨte’ jenye chõ”, ɨ que Moisés jẽje ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Sã ure nyeremo ure no. Paba rese. Ae sembu. Sã ureɨco ñee serɨɨ̃ Paba rese no. Ure nyeremo, ɨ que Jesús fariseos je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—¿Ma nderu riqui ma nde? ɨ que fariseos Jesús je ra. Jesús que ñee ee ra. —Paba jẽɨcuayãte quia ã. Se abe seɨcuayãte quia ã. Jẽ seɨcua mose, Paba abe ra jẽɨcua, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Eɨ̃ ngue Jesús quia mbia mbaaquiatu quiatu Dios chuchúaa ra. Ofrenda no nosa jii que eriqui mbia mbaaquiatu quiatu ra. Emo ngue Jesús isi ãte etarõ sacuã nda. —Aque mose ra eremano, ɨ ãte quiarei Dios ee. ");
INSERT INTO srqNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús que ñee sɨ fariseos je ra. —Aso sɨ ra Paba rea cote. Serequia requia rei nda se re. Jẽɨcuã mbeɨ ra jemano nyee. Ae ra aso nae, huee jengasẽ aroneate, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Judíos que ñee ñee nyue ra. —¿Mbaerã nda nandecuasẽ aroneate ee re? Nyɨɨquia ra reae, ɨ rei que ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús que ñee ee ra. —Ibi jenda chõ jẽ nde. Ibatenda chõ se re. Ibi jenda eã ño se re. ");
INSERT INTO srqNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nyebe aɨco nguiã ñee jẽje nyii. “Jẽɨcuã mbeɨ ra jemano nyee”, ae que jẽje nyii. Seɨcuayã mbeɨ mose ra jemano nyee jẽɨcuã mosebe, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Aba tuchɨ nde re? ɨ que mbia Jesús je ra. Jesús que ñee ee ra. —Cose ndare beɨ chõ aɨco nguiã serenei nenei jẽje co. ");
INSERT INTO srqNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mbae ra asenei tuchɨ jẽje reae. Secheẽ nda jẽɨcuã mbuchecua tuchɨ jẽje. Ae sembu nae, aque quiarei ñee ñooño aronea. Echeẽ ngue achandu ra. Ae cheẽ ño asenei senei mbeɨ nguiã mbia je co, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mbia rerecua que Jesús cheẽ ɨcuayã mbeɨ ra. —Dios rɨɨ̃ ño eriqui nguiã ñee, ɨã mbeɨ que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesús que ñeembe ee ra. —Mbiarã ngue achu ra. Jẽ nda sembucha ira rese cote. Aque mose ra mbae jẽɨcua jiri serɨɨ̃ cote. “Dios cheẽ nguire chõ eriqui mbia mbaaquiatu quiatu re”, jenye ra serɨɨ̃ cote. “Dios rucucha chõ eriqui re”, jenye ra serɨɨ̃ cote. ");
INSERT INTO srqNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ae sembu nae, aque riqui beɨ serese co. Echeẽ nguire aɨco beɨ embia co. Nyebe eriqui nguiã serechayã mbeɨ co, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús cheẽ mose que mbia Jesús ɨcua ɨcua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ae Jesús ɨcua quia judíos nae, ũquɨ̃ je que Jesús ñee nda. —Secheẽ sɨ jẽhuɨ eã mose, sechɨmbaaquiaturã tuchɨ ra jẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jẽ nda ɨchõɨñosa reã jẽɨcua tuchɨ cote. Mbia ɨcuã nderecua rimba eã nda jẽ cote, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mbia que ñee Jesús je ra. —Abraham nducucha rei ure. Mbia mo nimba eã mbeɨ que ureɨco resẽ. ¿Mbaerã ereɨco ñee ure je re? “Mbia sɨ taembuɨ mɨngo cote”, ɨ ure je re, ɨ que mbia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús que ñee ee cote ra. —Ae mbae ɨcuã saã saã nguia nae, ũquɨ̃ ndiqui beɨ eɨcuã nimbarã ã. ");
INSERT INTO srqNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Erimba ra siqui beɨ eã nguerecua rese. Nguiirĩ tuchɨ quiatu ra equereco beɨ nyɨese. ");
INSERT INTO srqNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Se jembuɨ mose mbae ɨcuã sɨ, eɨcuã nimbarã eã nda jẽɨngo cote. ");
INSERT INTO srqNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraham nducucha raque jẽ. Ũquɨ̃ aɨcuate raque. Ã jẽɨngo secheẽ isi turã eãte ã. Secheẽ jẽucuayã nguia ã. Nyebe jẽɨngo nguiã seɨquia serɨ̃te ã. ");
INSERT INTO srqNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ae Paba teacuquia seje nae, ũquɨ ño asenei senei nguiã jẽje co. Ae jendu teacuquia jẽje nae, ũquɨ̃ ndese chõ jẽɨngo nguiã jẽ ã no, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Abraham ño ureru resẽ. Urei resẽ, ɨ que mbia Jesús je ra. Jesús que ñee ee cote ra. —Abraham nducucha turã mose jẽ, eɨ̃ nguia nda jẽɨngo turã nguiã ña. Abraham nduɨ sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Dios que sembaaquiatu ra. Dios quiarei ñee ñooño eã. Echeẽ ño asenei senei nguiã jẽje co. Ũquɨ̃ je chõ jẽɨngo nguiã seɨquia serɨ̃te ã. Ɨ ãte que Abraham quia seje ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jendu rã sɨ chõ jẽɨngo nguiã ã, ɨ que Jesús ee ra. Mbia que ñee Jesús je cote ra. —Ureru ata ata eãte nyeresẽ. Dios mɨɨ ño ureru re, ɨ que ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús que ñeembe ee ra. —Dios jendu tuchɨ mose, eɨ̃ nguia nda jẽɨngo nguiã nyesecua serese chã. Ae quiarei sembu. Se ae eã achu nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ã jẽɨngo secheẽ andu sereãte ã. Nyebe jẽɨngo nguiã secheẽ ɨcua aroneate ã. ");
INSERT INTO srqNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Aba checuayã nderecua rei jendu. Erese beɨ chõ jẽɨngo nguiã ã. Echeẽ jemumbayã mbeɨ chõ nguiã ã. Mbia ɨquia ɨquiasa beɨ que ae ra. Cose ndare mosenda beɨ. Ñee ñooñosa reã quiato aronea tuchɨ quiarei ae. Ñee ñooño mbeɨte equia co. Ucheẽ achõ ño esenei senei nguiã mbia mbɨɨrɨ̃ ɨrɨ̃ querabe co. Ñee ñooñosa rerecua chõ aque re. ");
INSERT INTO srqNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Se quia acheẽ ñooño ãte rei nguiã jẽje. Secheẽ jẽucuayãte chõchɨ̃ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mbae ɨcuã ngue asaã eãte ra. Ũquɨ̃ jẽɨcuate raque. Acheẽ ñooño ãte sequia co resẽ. ¿Mbaerã jẽɨngo secheẽ andu sereã neate ã nde? ");
INSERT INTO srqNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dios quiato quia Dios cheẽ ñandu turã nguiã. Dios quiato eã ño jẽ nde. Nyebe jẽɨngo nguiã Dios cheẽ andu sereãte ã, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Judíos que ñee sɨ Jesús je ra. “Samaria jenda chõ nde reae. Aba checuayã nyɨreco chõ nde reae”, ure que nderɨɨ̃ nda. ¿Ae tuchɨ nde re? ɨ que judíos ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús que ñee ee ra. —Aba checuayã nyɨreco eã ño se resẽ. Co aɨco ñee turã tuchɨ Paba rɨɨ̃ co resẽ. Jẽ nguia jeñee ɨcuã mbeɨte nguiã serɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","“¡Sã mbia ñee turã serɨɨ̃ jẽ!” ae eã ño nguiã se co. Paba quia siqui nguiã ñee turã turãte serɨɨ̃ co. Ae quia ra mbia ɨcuã mbasi. ");
INSERT INTO srqNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tacheẽ nyecua jẽje. Ae secheẽ mumbayã nguia nae, ũquɨ̃ nda amɨngo beɨ. Ũquɨ̃ nda manoã mbeɨ, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Judíos que ñee Jesús je ra. —Aba checuayã nyɨreco tuchɨ chõ ereɨco nguiã co. ¿Mbaerã ereɨco ñee nde? “Mbia ra manoã, secheẽ mumbayã mose”, ɨ re. Abraham ngue mano. Nandei. Dios cheẽ nenei neneisa que mano ja resẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Nde ndeaquiatu tuchɨ Abraham sɨ re? Ae chee que mano. Dios cheẽ nenei neneisa chee que mano. ¿Abate nde re? “Mbia ra manoã”, ere chõte equia co, ɨ que judíos Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús que ñee ee cote ra. Se ae secheẽ turã mose serɨɨ̃, mbia ra seanduchõ. Paba quia ñee turã mbeɨ nguiã serɨɨ̃ co. Ae je jẽɨngo ñee. “Dios urererecua” ɨ raque erɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ã jẽɨngo Dios ɨcuayãte ã. Se quia aɨcuate nguiã co. “Dios aɨcuayã”, se ɨ mose, eɨ̃ nda acheẽ ñooñote rei jẽ na sɨ. Dios aɨcua tuchɨte. Echeẽ nduɨ chõ aɨco beɨ nguiã co. ");
INSERT INTO srqNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham ngue seraarõ arõ mbeɨ quia ra. “Tu rae”, ɨ beɨ que equia ñɨmbia serɨɨ̃ nda. Secuasẽ mose que eyate mae serese cote ra, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mbia que ñee Jesús je ra. —Cosete que Abraham mano ndesẽ. ¿Mañɨ ere mae erese re? Cincuenta años eãte nde resẽ, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús que ñee ee ra. —Tacheẽ nyecua jẽje. Cose ndare beɨ chõ aɨco nguiã co. Abraham tiã mosenda beɨ, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","—¡Sɨta je Jesús nandecheɨ jẽ! ɨ rei que mbia sɨta isi isi ra. Jesús que ñɨmɨ ñɨmɨ oso ra. Usẽ Dios chuchua sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ñeenda ruɨ que Jesús mae emo ndesayã ndese ra. Echaacuquia mosenda beɨ que eresayã nyobeɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jesús chɨmbaaquiatu que ñee ee ra. —Urembaaquiatusa, ¿abate mbae ɨcuã saã nyii re? Co resayã nonde re. Eru ereae. Esi ere no ae. Ae sɨ ere no ae. ¿Abate ere? ɨ que Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús que ñee ee ra. —Tei. Emo ngue mbae ɨcuã saã eãte rei ra. Mbia ra mae ja Dios quirãcuã ndese chã. Embucherõ mose. Nyebe eresayã nyaacuquia nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Arõ ño nandeɨco nguiã mbae raã naa. Itondaru mose, mbae rese nandeɨco aroneãte cote. Nyebe aɨco beɨ nguiã mbae rese Paba je co. Semano mose quia aɨco aroneãte nguiã mbae rese íbii cote. ");
INSERT INTO srqNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Seɨco mose íbii, aɨco mbia resaete co, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesús que ñinimbu íbii cote ra. Tuchu que esaã ngũendi je ra. Nguiti que eresayã ndesa rese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—Eso nderuba ɨreɨ cote. Ama Siloé eso eɨreɨ, ɨ que Jesús eresayã je ra. (“Echɨmondo”, ɨ chõ nguiã Siloé je.) Eresayã ngue oso nguesa ɨreɨ huee ra. Obei que eru quia mae turã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hue jenda que nyuruɨra jate mae erese ra. Ae mae nguia erese nyii nae, ũquɨ̃ ngue nyuruɨra tuchɨ mae erese cote ra. Eresa cherõ mose. —¿Co resayã ño ache ache ɨ quia nyii re? ¿Ae chõ ere? ɨ que mbia ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Ae eã ño ñene, ɨ que emo nda. —Ae chõ ñene, ɨ que emo emo no nda. Eresayã ngue ñee cote ra. —Se chõ nyeresẽ, ɨ que ñee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—¿Mañɨ nderesayã mae nde? ɨ que mbia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Eresayã ngue ñee nda. —Ae eriqui “Jesús” ɨ nae, aque que tuchu saã nda. Nguiti que seresa rese ra. “Eso nderuba ɨreɨ Ama Siloé”, ɨ que seje cote ra. Aso que se ra. Seruba ɨreɨ ji que amae cote ra, ɨ que eresayã mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Ma nderesa mbucherõsa riqui ma nde? ɨ que mbia eresayã je ra. —Quɨ chõ esɨ, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mbia que eresayã curuchoɨ fariseos je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ae mose Jesús eresayã mbucherõ nae, sábado mose que ra. Tuchu que esaã, aque mose que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","—¿Mañɨ ere nderesa ɨra re? ɨ que fariseos ee ra. —Tuchu que equiti seresa rese ra. Ae seresa aɨreɨ nguiã. Co aɨco mae co cote, ɨ que eresayã nda. ");
INSERT INTO srqNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fariseos mo ngue ñee nyue ra. —Ae eresa mbucherõ sábado mose nae, Dios cheẽ nenei neneisa eã ño aque re, ɨ rei que nyue ra. Emo emo ngue ñee no nda. —Eɨ̃ nguia nda eɨcuã mose mbia mae sayã naa naa eã nguiã nande je chã, ɨ que fariseos mo ñee nyue ra. Hue rɨ̃ ja eã ngue fariseos ñee Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Fariseos que ñee sɨ eresayã je ra. —Ae nembucherõ nae, ¿mañɨ ee re? ¿Mañɨ ere quia nde erɨɨ̃ co re? ɨ que ra. Eresayã ngue ñee nda. —Dios chɨmondo que ae ra, ɨ que eresayã nda. ");
INSERT INTO srqNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judíos que echeẽ ñandu sereã nda. Eresa turã mbeɨ mo eriqui reɨ̃ nguiã ee. Nyebe “jenyu” ɨ nguiã eresayã ndu je. Esi je abe no. —Nandeirandu rã erese, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Co nderiirĩ co re? ¿Eresayã nyobeɨ nyii re? ¿Eresayã nyaacuquia nyii re? ¿Mbae emumae nguia co cote re? ɨ que ñee eru je ra. Esi je abe. ");
INSERT INTO srqNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Eru que ñee ee ra. —Co rei seriirĩ co. Eresayã ngue nyaacuquia rei ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mañɨ ño equia mae co cote. Aba chõ embucherõ. Ureɨcuayãte. Jeñee nguia ee. Etiarõte nyeresẽ. Ae ra ñee jẽje, ɨ que eru ñee judio rerecua je ra. Esi abe. ");
INSERT INTO srqNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judíos rerecua quia ñee nguia nyue nyii reaẽ. —Emo ñee turã mose Jesús rɨɨ̃, ũquɨ̃ nandemombo beɨ mbia chumunuasa sɨ. “Dios chɨmbu rei Jesús”, ɨ mose, nandemombo beɨ mbia chumunuasa sɨ, ɨ quia ererecua quia ñee nyue nyii reaẽ. Nyebe eresayandu siquichete nguiã ñee turã Jesús rɨɨ̃. Esi abe no. ");
INSERT INTO srqNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nyebe eru riqui nguiã ñee ererecua je. —Jeñee nguia seriirĩ je. Etiarõte nyeresẽ, ɨ ee. Esiquichete quia ñene. ");
INSERT INTO srqNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","—Quiatuchu, ɨ sɨ que judíos rerecua eresayã je no nda. —Echeẽ turã Dios mɨɨ je. ¡Jesús abe je ra erecheẽ turãchɨ̃ jẽ! Eɨcuãte ae resẽ, ɨ rei que judíos rerecua eresayã je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Eresayã ngue ñee ee ra. —Aɨcuayãte se. Eɨcuãte ereae. Eturãte ere no ae. Aɨcuayãte se. Seresayã ngue nyii ra. Co aɨco mae co cote. Ũquɨ̃ mɨɨ ño aɨcua nguiã co, ɨ que eresayã judíos rerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—¿Mañɨ equia ndeje re? ¿Mañɨ nderesayã ɨra re? ɨ sɨ que eresayã je no nda. ");
INSERT INTO srqNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Eresayã ngue ñeembe ererecua je ra. —Acheẽ ndei que jẽje resẽ. Secheẽ ngue jemumb resẽ. ¿Mbaerã jẽɨngo “echeembe” ɨ seje ã nde? ¿Jẽ abe jẽɨngose rete sembucherõsa ruɨ re? ɨ que eresayã judíos rerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ererecua que ñee ɨcuãte ee cote ra. —Ae ruɨ chõ ereɨcochɨ̃ nguiã nde co. Moisés ruɨ chõ ureɨco nguiã ure ã. ");
INSERT INTO srqNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moisés je quiatu que Dios ñee nyii resẽ. Ũquɨ̃ ño ureɨcua nguiã ã. Ae nembucherõ nae, ma sɨ quiatu ñɨ ae ru. Ae quia ureɨcuayãte nguiã, ɨ que judíos rerecua ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Eresayã ngue ñee ee ra. —Seresa que embucherõ ndesẽ. “Dios chɨmbu”, jenye eã ñochɨ̃ equia ã. Seresa mbucherõsa raque ae. ");
INSERT INTO srqNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dios ra mbia ɨcuã ñee ñanuã. Ae Dios cheẽ mumbayã nguia nae, ũquɨ̃ ñee nguia ra Dios ñandu. ");
INSERT INTO srqNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Seresayã ngue achaacuquia rei nyii ra. Ae que sembucherõ nda. Emo abe ra ũquɨ̃ saã eã. ");
INSERT INTO srqNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dios chɨmbu eã mose, eɨ̃ nguia nda mbae raã eãte nguiã ña, ɨ que eresayã judíos rerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Judíos rerecua que ñee eresayã je ra. —Ndechaacuquia mosenda beɨ chõ ndeɨcuã ndiqui nguiã co. ¿Mbaerã ereɨco urembaaquiatu sete re? ɨ que judíos rerecua eresayã je ra. Nyebe que judíos rerecua eresayã mombo beɨ judíos chumunuasa sɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús que jirandu erese ra. Emombo mose. Nyebe esɨ nguiã ñee eresayã je. —¿Dios rucucha ereɨcuate quia co re? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—¿Aba chõ Dios rucucha re? Aɨcua sete quia co, ɨ que eresayã nda. ");
INSERT INTO srqNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Ae chõ se resẽ. Ae je chõ ereã ñee a resẽ. Eremae ndei serese resẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Eresayã ngue ngoi ngũíã ndese Jesús ji cote ra. —Areɨcua tuchɨ se cote, ɨ que Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús que ñee ee ra. —Achu que íbii ra. Mbia ɨcuã mbuchecua mbia je ra. Achu que eresayã ndesa mumae mae nda. Ae eresa nae, ũquɨ̃ mumae eã sacuã abe que achu ra, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fariseos mo abe que chɨ hue ra. Jesús cheẽ andu que ñee Jesús je ra. —¿Ureresayã ureɨco ure abe ã nde? ɨ que fariseos ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús que ñee ee ra. —Jendesayã mose, eɨ̃ nda jẽɨcuã ambuchecuayã ndei. “Seaquiatute”, jenyechɨ̃ equia ã. Nyebe aɨco nguiã jẽɨcuã mbuchecua jẽje co, ɨ que Jesús judíos rerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesús que ñee nda. —Tacheẽ nyecua jẽje. Ae ɨqueã nguia oveja chɨquesa rɨ̃ nae, mbae mbuquiachãsa chõ ũquɨ̃ nde. Echɨquesa eã ñɨ ɨque ɨque mose. ");
INSERT INTO srqNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ae ɨque ɨque quia oveja chɨquesa rɨ̃ nae, aque quia oveja raarõsa aque re. ");
INSERT INTO srqNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ae echɨquesa saarõ nguia nae, aque ra echɨquesa equia oveja raarõsa je cote. Eɨque sacuã. Oveja raarõsa cheẽ nda oveja ɨcua ja. Ñee mɨɨ mɨɨ nda umbae oveja je. Oveja ɨcua ja. Ae ra oveja nyoɨ usẽ eruɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Eraarõsa embusẽ ja mose etaronda sɨ, ae rane nda ngata oso quia erẽta. Oveja ra nyoɨ ja quia eruɨ. Echeẽ nguia eɨcuate nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Emo nduɨ ra echoɨ eã. Uchã ño nda emo sɨ. Echeẽ nguia eɨcuayãte nguiã, ɨ que Jesús ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús que eɨ̃ ndei ñee fariseos je ra. Ejemplo je. Oveja renei nenei ee. Jesús cheẽ andusa que echeẽ ɨcuayãte ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús que ñee sɨ ee ra. —Tacheẽ nyecua jẽje. Oveja chɨquesa rã ño se re. ");
INSERT INTO srqNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ae ngaẽ senonde nyii nae, mbae mbuquiachãsa ja chõ ũquɨ̃ nde. Nyebe ovejas eche sɨɨchã eã nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Oveja chɨquesa chõ se re. Ae seɨcua quia nae, ũquɨ̃ nda ateaquiatu beɨ mɨngo. Sã oveja mo ndiqui oso quiaru quiaru no. Sã eriqui cuaẽ nyebi chebi beɨ utaronda no. Eɨ̃ sɨ ra seɨcuasa quia siqui beɨ serese. ");
INSERT INTO srqNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mbae mbuquiachãsa quia ra tu mbae rirõ sacuã. Mbae mbutiã sacuã. Mbae ɨquia sacuã. Se quia nɨ achu nguiã mbia mɨngo beɨ sacuã. Mbia mbia tuchɨ nonde que achu ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Oveja raarõsa rei se. Ovejas ateaquiatu beɨ quia co. Amano nda emɨngo beɨ sacuã. ");
INSERT INTO srqNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ae ovejacha eã nae, aque ra ovejas saarõ ndaque, saarõ turã eã ndae. Uchã ño nda nyacua tu mose ovejas je. Nyacua ra ovejas isi embuquiachamba u quia. ");
INSERT INTO srqNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","“Echa eã ndei se re”, ɨ ra eraarõsa uchã erecha. Esiquiche mose. Oveja raarõ turã eã. ");
INSERT INTO srqNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Se quiarei oveja raarõsa turã. Sã Paba riqui seɨcuate co no. Sã aɨco Paba ɨcuate se abe co no. Eɨ̃ ae chõ nguiã oveja ɨcua sembae co no. Sembae abe seɨcua quia ã. Sembae ovejas mɨngo beɨ sacuã nda amano. ");
INSERT INTO srqNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ovejas mo abe que sembae no nda. A jenda eã ño ũquɨ̃ nde. Ũquɨ̃ abe ra aru a. Ũquɨ̃ nda secheẽ mumbayã no. Sembae oveja ra chɨ ja serese cote. Se mɨɨ ño nda asaarõ ja cote. ");
INSERT INTO srqNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Sesiquiche eã semano ndese. Sembae ovejas mɨngo sacuã. Nyebe Paba iate riqui nguiã serese co. Semanonde ra aquera sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Semano sereã mose, eɨ̃ nda mbia seɨquia aroneate rei. Se ae chõ amanosete nguiã mbia je. Se ae chõ nda aquera sɨ no. Paba quia uquirãcuã meete nguiã seje, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judíos que ñee ata atate nyue ra. Jesús cheẽ mose. Hue rɨ̃ sɨ ñee ja eã. ");
INSERT INTO srqNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Aba checuayã siquite Jesús rese co resẽ. ¿Mbaerã jẽɨngo echeẽ andu re? ɨ que emo emo uataque je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Emo emo ngue ñee no nda. —Ae rese aba checuayã ndiqui nae, ũquɨ̃ nda ñee turã eã ndesẽ. Aba checuayã nda mbia resayã mbucherõ eã ndesẽ, ɨ que emo emo no nda. ");
INSERT INTO srqNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mbia que ñumunua nua nguia Jerusalén cote ra. Dios chuchua ao mosenda ndese ndua ndua. Nyiiseĩte que aque mose ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús que oso Dios chuchúaa ra. Portal de Salomón ngue eriqui ngata ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Judíos que ngaẽ Jesús mama nda. Ñee ngue ee ra. —Ureɨco ndeɨcuayãte ã. ¿Manosete ra erecheẽ tuchɨ ure je re? Nde rɨɨ̃. Echɨmbu checua jiri ure je. Nde Cristo mose, ndecheẽ embuchecua ure je, ɨ que judíos ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús que ñee ee ra. —Acheẽ ndei que jẽje resẽ. Secheẽ jẽñanuã ño nguiã ã. Paba quirãcuã je chõ aɨco nguiã mbia mae sayã naa naa co. Ã ndese mae nda seɨcua nguiã ña. ");
INSERT INTO srqNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Acheẽ ndei que jẽje nyii resẽ. Serimba eã ño jẽ nde. Nyebe jẽɨngo nguiã secheẽ anuã. ");
INSERT INTO srqNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Serimba secheẽ ɨcua ja quia ã. Serimba aɨcua ja quia ã. Seruɨ ja serimba riqui ã. ");
INSERT INTO srqNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Serimba amɨngo beɨ quia co. Serimba ra quiachã eã mbeɨ. Emo eisi aronea tuchɨ sesɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Paba que emee serimbarã nda. Emo eisi aroneate Paba o sɨ. Ae quiarei equirãcuã tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aque mɨɨ ño ureɨco nguiã ã. Paba rese. Eɨ̃ sɨ tuchɨ ureɨco nguiã ã, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nyebe judíos paama ɨ nguiã ee. Sɨta que esirõ sirõ nda. —Jesús nandecheɨ, ɨ rei que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús que ñee ee ra. —Paba que sembuquirãcuã tuchɨ ra. Nyebe jemae sayã asaã saã tuchɨ nguiã jẽje. ¿Ũquɨ̃ mo nɨɨ jẽɨngo “nandecheɨ” ɨ seje re? ɨ que Jesús judíos je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judíos que ñee Jesús je ra. —Ndechɨao turã mo je eã ño ureɨco nguiã “nandecheɨ” ɨ ndeje. Erecheẽ ɨcuãte que Dios rɨɨ̃ ndesẽ. Dios eresaã saãte quia ure je co resẽ. Mbia sɨ chõ ndaque nde, ɨ que judíos Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús que ñee ee ra. —Sã embesa ji riqui ɨ no: “Jẽ ndei dioses, ɨ que Dios ra”, sã embesa ji riqui ɨ no. ");
INSERT INTO srqNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Embesa ji ñeeñooño aronea. “Dioses rei jẽ”, ɨ que Dios ucheẽ nenei neneisa je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dios que seirabo ra. Sembu que íbii cote ra. ¿Mbaerã jẽɨngo paama ɨ secheẽ mose re? “Dios riirĩ ño se re”, ɨ mose re. “Ndeɨcuãte chõchɨ̃ Dios je”, jenye chõchɨ̃ nguiã seje. ");
INSERT INTO srqNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Se mbae raã naa eã mose Paba rã sɨ, ũquɨ̃ mose quia secheẽ jeñanua. ");
INSERT INTO srqNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Paba rã sɨ mose, “coche ñene” jẽnye chõ sechɨsaã je. Secheẽ jeñandu sereã ndaque. Paba riqui serese co. Se abe aɨco Paba rese co. Ũquɨ̃ nda jẽɨcua cote, “coche ñene” ɨ mose sechɨsaã je, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","—Jesús nanderao etarõ sacuã, ɨ rei que mbia ra. Jesús que oso chee hue sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesús que oso Ama Jordán ndobeɨ ra. Ae Juan ndiqui bautizar ɨ nyii nae, huee que esɨ ra. Huee que Jesús riqui arete cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mbia que nyoɨ nyoɨ tuchɨte erea huee ra. Ñee ñee ngue nyue ra. —Juan ngue nandemae sayã mo saã eãte rei nande je. Nandembiirandu turã tuchɨchɨ̃ Jesús rɨɨ̃. Ɨchõɨño eã ño equia ñee nande je reaẽ, ɨ que mbia ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mbia tubɨrɨã ngue Jesús ɨcuua huee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Emo ndasi que chɨ ra. Lázaro, ɨ que ee ra. María, ɨ que enongue je ra. Marta, ɨ que enongue je no nda. Echari ja que ũquɨ̃ nda. Betania jenda ja que ũquɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María rei aba mbushɨmbusa ichusẽsa Jesús i rese. Ua je que esi esi ra. Enongue quia erasi re. Lázaro, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nyebe echari mbia mo mondo nguiã Jesús mbiirandu sacuã. —Ndequiato rasi que chɨ aque rɨ̃ nda, ɨ que echoɨ Jesús mbiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jirandu mose que Jesús ñee cote ra. —Mano sacuã eã ño erasi chɨ nguiã aque. Dios quirãcuã ndese mbia mae sacuã ño erasi chɨ nguiã aque. Se abe sequirãcuã ndese mae sacuã ño erasi chɨ nguiã aque, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús que nyesecua tuchɨ Marta rese ra. María rese. Lázaro rese abe no. ");
INSERT INTO srqNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lázaro rasi rese jirandu mose que esɨ jeɨ eã erea ra. Siquichõ ngue ra. Itõ nyeremo ngue huee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","—Nyaobe Judea cote, ɨ que uchɨmbaaquiatu je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Echɨmbaaquiatu que ñee ee ra. —Namote que judíos ndeɨguia serɨ̃te sɨta je. ¿Mbaerã nda ereso sɨ huee re? ɨ que Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Jesús que ñee ee ra. —Dios quiatu que sembu ra. Mbae raã naa sacuã ee. Echeẽ ngue asaã ja eãte ra. Nyebe emo seɨquia aroneate namo. Se echeẽ naa ja mose quia ra mbia seɨquia arõte cote, ɨ que ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Aquere que ñee sɨ uchɨmbaaquiatu je ra. —Nandequiato que uque cote ra. Lázaro. Taso emumba cote, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Uque mose u, ae ae ra ñumumba rei, ɨ que echɨmbaaquiatu ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","—Lázaro que mano nda, ɨ eã ngue Jesús ucheẽ mbuchecua tuchɨ ee ra. Lázaro mano tuchɨ raque. Lázaro uquechõ nei nguiã echɨmbaaquiatu je. ");
INSERT INTO srqNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jesús que ucheẽ mbuchecua ramo ee cote ra. —Lázaro que mano nda. ");
INSERT INTO srqNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Coche aɨco eã nguiã huee. Jẽ nda seɨcua tuchɨ cote. Nyao erea cote, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás que ñee echɨmbaaquiatu ataque je ra. —Nyao erese nande abe no. Sã mbia nandeɨquia nande abe rõ, ɨ que Tomás ra. “Eata”, ɨ que mbia quia Tomás je ra. Eata rei ae. ");
INSERT INTO srqNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ngasẽ ngue Betania cote ra. Mbia hue jenda que ñee Jesús je cote ra. —Co Lázaro ati ji chɨ itõ mocoĩte co resẽ. Cuatro días tuchɨte nyeresẽ, ɨ que mbia ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Aɨchɨte que Betania Jerusalén sɨ ra. Tres kilómetros que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nyebe judíos rane ngaẽ jate nguiã ngasẽ Jerusalén sɨ. María mbia jiri sacuã. Marta abe no. Enongue raaque ati ji mose. ");
INSERT INTO srqNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta jirandu mose Jesús rese que esɨ erobeɨshɨ̃ nda. Oo que erese ra. María quiatu que siquichõ tuchúaa ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta que ñee Jesús je ra. —Sererecua, ndeɨco mose a, eɨ̃ nda senongue manoãte rei. ");
INSERT INTO srqNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Dios ra ndecheẽ ñandu. “Mbae mo embu seje”, ɨ mose, ɨ que Marta Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Ndenongue ra quera sɨ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta que ñee ee cote ra. —Ae beɨ. Mbia raaque quera ja mose, aque mose ra senongue abe quera sɨ. Mbae ua ja mose ra quera sɨ. Aɨcuate raque se quia co, ɨ que Marta ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús que ñee ee ra. —Mbia raaque mbuquerasa rei se. Mbia mɨngosa rei se. Ae seɨcua quia nae, ũquɨ̃ nda mano ndaque, quera sɨ rae. ");
INSERT INTO srqNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ae seɨcua quia nae, ũquɨ̃ nda uayã mbeɨ. ¿Ũquɨ̃ ereɨcua quia co re? ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta que ñee ee ra. —Ae. Cristo chõ nde re. Dios rucucha chõ nde re. “Dios rucucha ra tu íbii”, ɨ que mbia quia nyii nae, ae chõ nde re, ɨ que Marta Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Aquere que Marta sɨ María mbiirandu ra. —Nandembaaquiatusa que tu ra. Hue que eriqui nderequia ra, ɨ que Marta ñee ngõngue ísaa ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Echeẽ nduɨbe tuchɨ que María sɨ juã asi Jesús rea ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús ngasẽ mose rocoĩ mbia chuchua ite re. Marta erobeɨshɨ̃sa beɨ que Jesús riqui ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mariaso rese que judíos chɨ mae ja ra. —Ngõngue atisa chõ María sɨ nguiã nyeseo quɨ, ɨ rei ngue judíos choɨ nguiã eruɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María que ngasẽ Jesús je ra. Ngoi que ngũíã ndese ejii ra. Ñee ngue ee ra. —Ndeɨco mose a senongue ndasi mose, eɨ̃ nda manoãte rei, ɨ que María Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","María que nyeseo ra. Judíos que chɨ erese, ũquɨ̃ abe que nyeseo no nda. Nyebe que Jesús abe ia eãte ra. Echɨã ngue ngoi eã tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—¿Mangue jenyati mangue re? ɨ que Jesús mbia je ra. —Nyao erea ae, ɨ que mbia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús que nyeseo ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Judíos que ñee nyue ra. —¡Sã jẽ! Nyesecua tuchɨ Lázaro rese. Eya eãte riqui erese co, ɨ que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Emo emo ngue ñee nda. —Jesús que eresayã ndesa mbucherõ. Eɨ̃ nda Lázaro rasi mbucherõ nde chaẽ. Eɨ̃ nda manoãte, ɨ que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús ia eãte que ngasẽ Lázaro atiguia ra. Sɨta ɨmɨ ye. Sɨta chõ ngue eatiquia no nda. ");
INSERT INTO srqNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—¡Sɨta eatiquia jẽjea jẽ! ɨ que Jesús mbia je ra. Marta que ñee Jesús cheẽ mose ra. —¡Enete ra nande je jẽ! Curɨte que mano ndesẽ. Cuatro días tuchɨ que ra, ɨ que Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús que ñee ee ra. —“Seɨcua tuchɨ mose ra eremae Dios quirãcuã ndese”, ae rei que ndeje nyii, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Sɨta eatiquia que mbia jea cote ra. Jesús que mae ibate quiti ra. Ñee Dios je. —Paba, secheẽ ngue erechandu. “Ɨaanye”, ae beɨ quia ndeje co. ");
INSERT INTO srqNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nde quiarei seandu beɨ. Mbia resa rae aɨco ñee ndeje a. “Dios chɨmondo chõ eriqui re”, ɨ nda ã serɨɨ̃ ña, ɨ que Jesús ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jesús que ñeemombo Lázaro raaque je cote ra. —Lázaro, ¡echu usẽ! ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Eraaque que usẽ u juã cote ra. Eo cuasa resebe que usẽ nda. Ei abe ecua ji tiru je. Eruba abe ecua ji tiru je. —Jenyura mondo, ɨ que Jesús mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Judíos que nyoɨ María rese, ũquɨ̃ ngue mae ja Jesús rese ra. Lázaro mbuquera mose. Ũquɨ̃ tubɨrɨã ngue Jesús ɨcua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","—Jesús que Lázaro raaque mbuchuruã nda, ɨ que emo nyoɨ fariseos mbiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Fariseos que ñumunua ja cote ra. Sacerdotes rerecua ja rese. Mbia rerecua ja. Ñee tuchɨ Jesús rɨɨ̃. —¿Mañɨ nande ra equia ee re? Mbia mae sayã naa naa tuchɨchɨ̃ equia aque. ");
INSERT INTO srqNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nande ereachõ mose ra mbia siqui ja techɨ̃ eruɨ re. ¡Roma jenda ra nandembae isichɨ̃ ibi jẽ! ¡Dios chuchua ra embucoɨchɨ̃ ngaẽ jẽ! ɨ que ererecua ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Caifás que sacerdote rerecua tuchɨ aque mose ra. Ae que ñee uataque je ra. —Mbae jẽɨcuayã tuchɨchɨ̃ nguia ã. ");
INSERT INTO srqNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jendua eã ñochɨ̃ equia ã. Aque mɨɨ ño nda mano nguiã nande ja je chã. Eɨ̃ nda judíos ua tuchɨ eã, ɨ que Caifás uataque je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás ae que ñee eã nda. Dios ae quiatu ngue embucheẽ nguiã ũquɨ̃. Sacerdote rerecua tuchɨte quiatu ngue ae re. Nyebe Dios embucheẽ nguiã. —Jesús ra mano judíos mɨngo ja sacuã. ");
INSERT INTO srqNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","A jenda achõ je eã nda Jesús mano. Dios riirĩ mangue chooñoa jenda je abe chõ nda Jesús mano nguiã. Dios riirĩ munua ja sacuã, ɨ que Caifás ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aque mose beɨ que judíos rerecua ñee ñee nyue ra. —¡Jesús nandeɨquia rei jẽ! ɨ que equia ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesús que nyecua eã judíos je cote ra. Judea sɨ que esɨ cote ra. Turuquia rurubi que esɨ ra. Efraín, ɨ que sucha tubɨrɨã je ra. Huee que eriqui arete uchɨmbaaquiatu rese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Fiesta de la pascua que ecurubite ra. Nyebe judíos nyoɨ choɨ ja nguiã Jerusalén. Suchamo jenda emo emo ngue nyoɨ jate ra. Pascua nonde que echoɨ huɨɨcuã mbitirõ sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mbia que Jesús sequia quia ra. —¿Tu ra fiesta re? ¿Tu eã nda re? ¿Tu aroneate jẽje re? ɨ que mbia ñee ñee nyue Jesús rɨɨ̃ nda. Ɨ que mbia u ñee Dios chuchúaa ra. ");
INSERT INTO srqNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mbia rerecua que ñee mbia je nyii ra. —Emo jirandu mose Jesús rese, sã urembiirandu jeɨ. Eɨ̃ nda ureisi. Eɨ̃ nda uretarõ mɨɨ, ɨ que sacerdote rerecua ñee nyii ra. Fariseos abe no. ");
INSERT INTO srqNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","—Seis días mose ra pascua cote, ɨ que mbia ra. Aque mose que Jesús sɨ Betania nda. Huee que Lázaro riqui ra. Ae Jesús mbuquera erua sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mbia que ñio mɨɨ Jesús chɨurã nda. Marta que echɨurã mondo mondo ee ra. Mbia je abe. Lázaro abe que chɨ̃ quiaru erese ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María que aba mbushɨmbusa queru Jesús je cote ra. Medio litro. Nardo, ɨ que ũquɨ̃ je ra. Mbae isiquia mumba tuchɨ que ũquɨ̃ nda. María que eichusẽ Jesús i rese ra. Ua je que esi esi ra. Tuchua mbushɨmbu ja que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iscariote abe que siqui ra. Simón ndiirĩ ngue aque ra. Jesús chɨmbaaquiatu mo ndei que aque ra. Ae quiatu que Jesús mee mbia ɨcuã je emo mose cote ra. Ae que ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Mbaerã eichusẽ ñooño nde? ¿Mbae isiquia rɨbɨshorõ ño nda aba emondo re? Tres cientos rɨbɨshorõ. Mbaecha reã je emee sacuã, ũquɨ̃ mbae isiquia, ɨ que Judas ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas ndua eã ndaque mbaecha reã ndese. Mbae mbuquiachãsa tuchɨ que ae ra. Mbae isiquia riru que equereco quia Jesús je ra. Eyenda que esirõ sirõ nguia mbuchemɨ chemɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús que ñee Judas je ra. —¡Erecheẽchɨ̃ nda María je jẽ! ¡Sã ae ae riqui jẽ! Seati nonde chõ aba mbushɨmbusa icherẽ nguiã serese. ");
INSERT INTO srqNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mbaecha reã nguia nda chɨ are jiri nguiã a. Se quia nda aɨco beɨ eã nguiã jẽje a, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Judíos que jirandu jate Jesús rese ra. Eriqui mose Betania. Nyoɨ jate que erea ra. Lázaro abe rea. Ae Jesús mbuquera erua sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nyebe judíos rerecua ñɨmbiirandu nguiã. —¡Lázaro abe nandeɨquia rei jẽ! ɨ que ererecua ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Judíos que siqui tuchɨte Jesús rese cote ra. Nguerecua que esecha jate cote ra. Lázaro que embuquera erua sɨ nyii. Ũquɨ̃ mbeɨ beɨ que nyii ra. Jesús oso Jerusalén ");
INSERT INTO srqNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mbia tubɨrɨã ngue nyoɨ Jerusalén nda. Pascua raã naã sacuã huee. Jesús abe que oso ra. Mbia que jirandu erese ra. Ecuasẽ nonde. ");
INSERT INTO srqNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mbia yate que Jesús cuasẽ mose ra. Sɨndo que ecuruchoɨ erobeɨshɨ̃ nda. Mbia que tasẽ tasẽ tuchɨ ra. —Eturã tuchɨ ruchɨ̃ nguia co. Dios rucucha ruchɨ̃ nguia co. Israel rerecua ruchɨ̃ nguia co cote, ɨ que mbia tasẽ tasẽ tuchɨ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús que ngasẽ burro riirĩ mo je ra. Nyuɨ que eato ra. Embesa ji ruɨ sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ɨ que embesa ji quia nyii ra: ¡Jẽɨreɨ̃ ɨreɨ̃chɨ̃ nda, Sion jenda! Co jenderecua ru quia co. Co eru quia burro átoo co, ɨ que embesa ji quia nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jesús chɨmbaaquiatu que ã ɨcuayãte nyii ra. Embesa ji. Jesús quera sɨ mose que ã ɨcua cote ra. —Embesa ji ruɨ sɨ chõ eriqui rei reaẽ, ɨ que echɨmbaaquiatu eɨcua ramo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesús que Lázaro mbuquera, ũquɨ̃ ndese maesa que mbia mbiirandu randu tuchɨ quia ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nyebe mbia nyoɨ ja tuchɨ nguiã Jesús robeɨshɨ̃. Jirandure Lázaro raaque mbuquera rese. ");
INSERT INTO srqNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseos que ñee ñee sɨ nyue no nda. —Jesús ruɨ ja tuchɨchɨ̃ mbia. ¿Mañɨ nda aba mbia je re? ɨ que ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Griegos mo abe que nyoɨ Jerusalén nda. Pascua raã naa Dios je. ");
INSERT INTO srqNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ũquɨ̃ ngue nyoɨ ñee Felipe je ra. Felipe que Betsaida jenda ra. Galilea jenda. —Uremaese rete Jesús rese, ɨ que griegos Felipe je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe que oso Andrés mbiirandu ra. Ũquɨ̃ ja que nyoɨ Jesús mbiirandu cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús que ñee ee ra. —Mbiarã ngue achu ibate sɨ ra. Semano nonde arubite cote. Sequera sɨ nonde arubite cote. ");
INSERT INTO srqNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tacheẽ nyecua jẽje. Ibasɨ eɨ̃ tiquia eã mose ra ɨa eã mbeɨ. Chɨ chooño mbeɨ rae. Etiquia mose ra suri cote. Ɨ a tuchɨ ra cote. Eɨ̃ ae ra se. Ibasɨ eɨ̃ na sɨ. Amano nda se. Mbia ra setiquia. ");
INSERT INTO srqNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ae nduate quia nyɨese nae, ũquɨ̃ nda nyoɨ eãte ibate. Ae ndua eãte quia nyɨese nae, ũquɨ̃ nguia ra nyoɨ ibate. Siqui beɨ sacuã huee. ");
INSERT INTO srqNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ae secheẽ mumba sereãte quia nae, sã ũquɨ̃ ndiqui beɨ seruɨ. Ae ra aɨco nae, huee ra ũquɨ̃ abe riqui. Ae secheẽ mumba sereãte quia nae, ũquɨ̃ nɨɨ nda Paba ñee turã. ");
INSERT INTO srqNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Seya eãte aɨco co. ¿Mañɨ ae ra ñee Paba je re? “Semɨngobe rei se ae. Sembasiã ndei se ae”, ae aroneate Paba je. Ã sacuã ño ngue achu resẽ. Sembasi sacuã ño ngue achu resẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Paba, ndequirãcuã eteacuquia mbia je, ɨ que Jesús ra. Ũquɨ̃ mose que echeẽ mo ndu ee ibate sɨ ra. —Sequirãcuã ngue ateacuquia mbia je ra. Ateacuquia sɨ ra mbia je, ɨ que ibatenda ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mbia que ibatenda cheẽ ñandu ja rei ra. Ae chɨ Jesús rese, ũquɨ̃. —Ama ndieu ereae, ɨ que mbia ra. —Tei. Angel mo ño ngue ñee nguiã Jesús je, ɨ que emo no nda. ");
INSERT INTO srqNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús que ñee mbia je cote ra. —Seje eã ño ngue ibatenda ñee ndesẽ. Jẽ eandu sacuã ño ngue ñee ndesẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Paba ra seɨcuasa reã mbasi ja cote. Mbia ɨcuã nderecua ra Paba mombo ibi jenda cote. ");
INSERT INTO srqNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Sembucha mose mɨɨ ibate, mbia ra siqui tuchɨ serese cote. Sucha mo jenda ja abete ra siqui serese cote, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","—Mbia ra seɨquia mɨɨ sembucha ira rese, ɨ ñene. ");
INSERT INTO srqNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mbia que ñee Jesús je cote ra. —“Cristo ra siqui beɨ”, ɨ que Dios cheẽ embesa ji urembiirandu. ¿Mbaerã erecheẽ nde? “Mbia ra sembucha ira rese”, ɨ re. ¿Aba quia Cristo re? ¿Aba quia tu mbiarã nde? ɨ que mbia ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús que ñee ee ra. —Taɨco mbɨrɨmbe jendese jembaaquiatu quiatu. Jendesaebe mbɨrɨ̃. Tata rendi rãte aɨco co. Tata rendi siqui mose jendese, ¡jengata turã ño nguia jẽ! Seɨcuasa reã ño siqui nguiã itondaru. Ũquɨ̃ quiachã ño nguiã ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tata rendi raãte aɨco co. Seɨco beebe mose jendese, seɨcua tuchɨ rã. Eɨ̃ nda jẽɨngo turã jendesae ji, ɨ que Jesús mbia je ra. Aquere que esɨ ñemɨ mbia sɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús que mbia mae sayã saã saã tuchɨte rei mbia je ra. Mbia que Jesús ɨcuayã mbeɨ chõ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ae Isaías mbesa mɨɨ nyii nae, ũquɨ̃ na sɨ chõ ngue mbia Jesús ɨcuayã cote ra. Eɨ̃ ngue Isaías embesa mɨɨ nda: Sererecua, ae uresenei senei nguia mbia je nae, ũquɨ̃ mbia ɨcua sereãte quia ã. Ndequirãcuã mbia tea sereãte quia ã, ɨ que Isaías embesa ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mbia que Jesús ɨcua aroneate ra. Isaías chɨmbesa rã sɨ chõ ngue ra. Eɨ̃ ngue Isaías embesa mɨɨ no nda: ");
INSERT INTO srqNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios que mbia chɨã matã nda. Nyebe eriqui mbae ɨcuayãte ã. Nyebe eriqui nguiã uba eãte serese. Se embitirõ sacuã, ɨ que Isaías chɨmbesa huɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías que Cristo quirãcuã tea nyii ra. Nyebe ã mbesa mɨɨ nguiã Jesús rɨɨ̃ a. ");
INSERT INTO srqNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Judíos tubɨrɨãte que Jesús ɨcua ra. Judíos rerecua emo emo abe que Jesús ɨcua rei ra. Siqui checuayã ño ngue Jesús ruɨ ra. Esiquichete quiatu ngue fariseos sɨ re. —¡Fariseos ra nandemombochɨ̃ mbia chumunuasa sɨ jẽ! ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","—Dios cheẽ nandemumbayã jẽ, ɨã ñochɨ̃ ngue re. —¡Mbia cheẽ nguiatu nandemumbayã jẽ! ɨ chõchɨ̃ ngue re. ");
INSERT INTO srqNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús que ñee irãtã mbia je ra. —Ae seɨcua quia nae, se mɨɨ ɨcua eã. Paba abe ɨcua. Ae sembu ibate sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ae mae nguia serese co nae, Paba abe rese mae. ");
INSERT INTO srqNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mbia resae sacuã ño achu nguiã co. Eɨ̃ nda seɨcuasa siquíã itondáruu. ");
INSERT INTO srqNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jẽɨngo secheẽ andu ã. Jemo secheẽ mumba mose, se ra ambasiã. Secheẽ ae ra embasi. Mbia mingo beɨ sacuã ño achu nguiã co. Mbia mbasi sacuã eã ño achu nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Secheẽ nguia ra seucuayãsa mbasi, mbae ua mose. Ibi ua mose. Secheẽ ae ra secheẽ mumbasa mondo tata cuasu. Secheẽ andu chooño nguiatu ngue re. ");
INSERT INTO srqNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Se ae eã ño acheẽ nguiã mbia je. Paba quia ñee nguiã seje. “Eɨ̃ ere mbia mbaaquiatu quiatu”, ɨ que Paba sembu ra. ");
INSERT INTO srqNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Paba cheẽ ndei mbia mɨngo beɨsa. Echeẽ mumbayã mose. Nyebe aɨco nguiã Paba cheẽ nenei nenei co. Secheẽ ae eã ño ñene. ");
INSERT INTO srqNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","—Namo jiri ra Paba sererao ibate ibi sɨ cote, ɨ que Jesús uchɨangui re ra. Nyesecua tuchɨ que equia uchɨmbaaquiatu rese ra. Mano nyee. ");
INSERT INTO srqNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesús que quiaru u uchɨmbaaquiatu rese isa ra. Pascua nonde. —Jesús emondo mbia ɨcuã je, ɨ que diablo Judas Iscariote je nyii ra. Simón ndiirĩ ndei aque. ");
INSERT INTO srqNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús que mbae ɨcua jate ra. —Dios sɨ chõ achu nguiã co. Asobe ra erea. Paba que uquirãcuã mee tuchɨ seje ra, ɨ que Jesús uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Quiaru jare que Jesús juã huɨɨrao mbuɨ ra. Ngũmbi que echucua toalla je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","I que eichusẽ mbae mo ye ra. Uchɨmbaaquiatu i que eɨreɨ ɨreɨ ra. Mbɨɨru ɨru que toalla je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pedro i nda eɨreɨ nguiã cote chã. —Sererecua chõ nde resẽ. ¿Mañɨ ere ra sei ɨreɨ re? ɨ que Simón Pedro ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús que ñee ee ra. —Ã ereɨcuayãte. Ae asaã saã nguia ã. Ereɨcua rei ra cote, ɨ que Jesús ñee Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Sei ra ereɨreɨ eã mbeɨ, ɨ rei que Pedro Jesús je ra. —Ndeɨreɨ eã mose, serese eã nda nde cote, ɨ que Jesús Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Sei achõ eã eɨreɨ rõ. Seo abe eɨreɨ no. Seãquĩ abe no, ɨ chee que Pedro ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús que ñee ee ra. —Ae echasu quiite, equishĩte ũquɨ̃ ndesẽ. Jẽi mɨɨ ño taɨreɨ. Jẽquishĩ ja eãte raque. Aque mɨɨte raque echɨã nondeɨ, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús que jirandu Judas rese ra. Nyebe eriqui nguiã ñee. —Aque mɨɨte raque echɨã nondeɨ, ɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ei ɨreɨ jare que huɨɨrao mingue cote ra. Ngoi sɨ que ra. Ae ñee nguiã nguesenda je. —Jẽi que aɨreɨ, ¿ũquɨ̃ jẽɨcuate rei quia re? ");
INSERT INTO srqNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nyebe jẽɨngo nguiã ñee seje. “Sererecua, Sembaaquiatusa”, ɨ seje. Coche jeñee nguiã seje. Ererecua rei se. ");
INSERT INTO srqNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jẽi que aɨreɨ ɨreɨ. Ererecua raque se. Nyebe jẽ abe jemo i jẽɨreɨ ɨreɨ ae. ");
INSERT INTO srqNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nyebe que ateacuquia jẽje resẽ. Seruɨ sɨchõ jẽɨngo emo i ɨreɨ ɨreɨ ae. ");
INSERT INTO srqNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tacheẽ nyecua jẽje. Se rei jenderecua. Se chõ aemondo mondo nguiã mbia mbaaquiatu sacuã. Jengasu ra jẽsaã saãchɨ̃ sesɨ jẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jẽ secheẽ ɨcua mose, secheẽ mumbayã mose, jẽya tuchɨ ra jẽɨngo. ");
INSERT INTO srqNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Jẽ ja je eã aɨco nguiã ñee a. Jaẽirabo que se resẽ. Jaẽɨcuate que se resẽ. “Ae quiaru serese nae, aque ɨcuãte ra seje cote”, sã embesa ji ɨ no. Embesa ji ruɨ sɨ ra jemo ɨcuã seje cote. Quiarure serese. ");
INSERT INTO srqNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","¡A aɨco ñee jeɨ jẽje a jẽ! Eɨcuã nonde seje. Eɨcuã mose seje, jẽ nda seɨcua cote. “Dios nducucha” jenye tuchɨ ra seje cote. ");
INSERT INTO srqNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tacheẽ nyecua jẽje. Ae secheẽ nenei neneisa isi quia nae, ũquɨ̃ nda seisi se abe. Ae seisi quia nae, Paba abe isi rae, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesús ia eã tuchɨ que cote ra. —Tacheẽ nyecua jẽje. Jemo nda semondo mbia ɨcuã je cote, ɨ que ñee nyecua uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Echɨmbaaquiatu que mae mae ja chõ nyɨese ra. —¿Aba ra re? ¿Aba ra re? ɨ jaaja nyue. ");
INSERT INTO srqNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jesús chesecua tuchɨ que chɨ̃ ngoi ejii ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Aque je que Simón Pedro o mee mee nda. —“¿Aba ra re?” ere ee, ɨ que Pedro ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jesús chesecua que ñɨmbucha ɨ ɨ ñee Jesús je ra. —¿Aba ra re? ɨ ee. ");
INSERT INTO srqNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús que ñee ee ra. —Mbichae monde ji ra amee jemo je. Ae je ra amee, aque ra semee mbia ɨcuã je, ɨ que Jesús ra. Mbichae que emonde mondo Judas Iscariote je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas mbichae u mose que Satanás ndu embɨɨcuã tuchɨ cote ra. Jesús que ñee ee ra. —Ae ra eresaã nae, ¡ũquɨ̃ esaã jeɨchõ jẽ! ɨ que Jesús Judas je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","—¿Mbae rɨɨ̃ Jesús riqui ñee Judas je re? ɨ que eataque ra. Mbia iranuã ja que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas que mbae isiquia quereco ja quia ra. —Mbae mo eisi rã nandechɨurã, ɨ reɨ̃ Jesús quia Judas je uchɨmbaaquiatu je. —Mbae mo emondo rã mbaecha reã je, ɨ reɨ̃ Jesús quia Judas je uchɨmbaaquiatu mo je. Echeẽ ngue eɨcuayã ja ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mbichae ure que Judas sɨ usẽ cote ra. Itondaruqui rɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas usẽ mose que Jesús ñee nda. —Mbiarã ngue achu ra. Sequirãcuã ndese ra mbia mae cote. Dios quirãcuã abe areco co. Dios quirãcuã abe rese ra mbia mae cote. ");
INSERT INTO srqNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Aɨco Dios quirãcuã ndeacuquia mbia je a cote. Dios abe ra sequirãcuã teacuquia mbia je cote. Sequirãcuã nda eteacuquia jeɨ mbia je cote. ");
INSERT INTO srqNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Seresenda, aɨco mbɨrɨ̃ ño nguiã jendese a cote. Serequia rei ra se cote. Acheẽ ngue judíos je, ũquɨ̃ sɨ́ aɨco ñee jẽje a. Ae ra aso nae, huee jengasẽ aroneãte. ");
INSERT INTO srqNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Aɨco secheẽ yasu nenei jẽje a. Secheẽ mumbayã sacuã. ¡Jenyesecua ja jenyɨese jẽ! Sã ñɨ aɨco nyesecua tuchɨ jendese no. ¡Eɨ̃ jenye nyesecua tuchɨ jenyɨese jẽ! ");
INSERT INTO srqNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Jenyesecua tuchɨ mose jenyɨese, mbia ra ñee ja tuchɨ jenɨɨ̃. “Eɨ̃ nguia Jesús chɨmbaaquiatu quia re”, ɨ ra mbia jẽje, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","—¿Manguiti ra ereso re? ɨ que Simón Pedro ñee Jesús je ra. —Ae ra aso nae, huee ereso aroneate namo. Emo mose jiri ra ereso seruɨ cote, ɨ que Jesús Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro que ñeembe ee ra. —¿Mbaerã nda asoã nderese namo nde? Seso sete nderese. Semano sete nderese, ɨ que Pedro Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús que ñee ee ra. —“Semano sete nderese”, erechɨ̃ nguiã seje. Co isa ra erecheẽ ñooño serɨɨ̃ tres veces. “Jesús aɨcuayãte resẽ”, ere chooño nda serɨɨ̃ nguira cheẽ nonde, ɨ que Jesús Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús que ñee uchɨmbaaquiatu je ra. —Jẽya eã eriquichɨ̃ nguiã. Dios jẽɨcua chõ ae. Se abe jẽɨcua chõ ae. ");
INSERT INTO srqNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ae Paba riqui, huee tuchua tubɨrɨãte. Ũquɨ̃ eande rae, eɨ̃ nda acheẽ eãte rei jẽje. Aso ra tuchuarã naã jẽje. ");
INSERT INTO srqNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Jenyuchuarã naa jare ra achube jendea cote, jenderao beɨ serese cote. Jẽ nda jẽɨngo beɨ serese pee cote, ae ra aɨco. ");
INSERT INTO srqNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ae ra aso, huee jẽɨcuate resẽ. Ñeenda abe jẽɨcuate resẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás que ñee ee ra. —Ureɨcuayãte nyeresẽ. ¿Mangue ra ereso mangue re? Ñeenda ra ureɨcua eãte chɨ nde, ɨ que Tomás Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús que ñee ee ra. —Ñeenda rei se. Ñee ñooñoã je rei se. Mbia mɨngo beɨsa rei se. Ae ra seɨcuayãte, ũquɨ̃ nda ngaseã mbeɨ Paba je. ");
INSERT INTO srqNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jẽ seɨcua mose, Paba abe jẽɨcuate quia ã. Jẽ Paba jẽɨcuate quia cote resẽ. Jemae ngue erese namo ndesẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe que ñee ee cote ra. —Nderu eteacuquia rã ure je. Ũquɨ̃ mɨɨ ño ureɨco nguiã ñee ndeje, ɨ que Felipe ra. ");
INSERT INTO srqNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús que ñee Felipe je ra. —Aɨco tuchɨte que jendese, Felipe. ¿Mbaerã ereɨco seɨcuayãte re? Ae mae nguia serese, Paba abe rese maete. ¿Mbaerã ereɨco ñee seje re? “Nderu eteacuquia ure je”, ɨ seje. ");
INSERT INTO srqNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Co aɨco Paba rese co resẽ. Paba abe riqui serese co. ¿Ũquɨ̃ ereɨcuayãte re? Ae aɨco ñee jẽje nae, secheẽ ae eã ño ũquɨ̃ nde. Paba riqui serese co. Ae abe riqui mbae raã naa serese co. ");
INSERT INTO srqNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Secheẽ jẽɨcua rã. Co aɨco Paba rese co. Paba abe riqui serese co. “Nyia”, jenye eã mose secheẽ je, sechɨsaã je chõ “nyia” jenye. ");
INSERT INTO srqNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tacheẽ nyecua jẽje. Ae seɨcua quia nae, ũquɨ̃ nda sechɨsaã saã saã se rã sɨ cote. Ũquɨ̃ nda mbae saã saã tuchɨ sesɨ. Co quia aso nguiã Paba rea se co. ");
INSERT INTO srqNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","“Mbae emondo ure je” ɨ mose seje, amondo ra jẽje. Jẽ seɨcua mose. Eɨ̃ ae ra Paba quirãcuã ndeacuquia mbia je. ");
INSERT INTO srqNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","“Mbae emondo ure je”, ɨ mose seje, amondo ra jẽje. Jẽ seɨcua mose. ");
INSERT INTO srqNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jenyesecua mose serese, secheẽ jemumbayã ae. ");
INSERT INTO srqNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tacheẽ Paba je. “Espíritu Turã emondo sechɨmbaaquiatu je”, ae ra Paba je. Espíritu Turã nda siqui beɨ jendese cote. Jẽquiato tuchɨ ra ae cote. ");
INSERT INTO srqNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Espíritu Turã nda ñee ñooñoã jẽje, jembaaquiatu quiatu. Ae ra siqui eã tuchɨ Dios quiatoã ndese. Espíritu Turã ɨcuayãte quia ñe ne. Jẽ nguia jẽɨcuate nguiã. Co Espíritu turã ndiqui jendese co. Siqui beɨ ra jendese. ");
INSERT INTO srqNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aso raque quia co. Esi cheecha rã nda jẽɨngoã. Achube ra jembirõ. ");
INSERT INTO srqNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aɨchɨte aɨ̃ oso a cote. Dios ɨcuasa reã nda mae eã serese cote. Jẽ nguia nda jemae nguiã serese. Aquera sɨ ra siqui beɨ nonde. Jẽ abe ra jẽɨngo beɨ serɨɨ̃ cote. ");
INSERT INTO srqNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Espíritu Turã tu mose ra jẽɨcuate cote. “Jesús riqui ngu rese co. Ã ureɨco Jesús rese ã. Jesús riqui urerese co”, jenye ra serɨɨ̃ cote. ");
INSERT INTO srqNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ae secheẽ ɨcua quia nae, ae secheẽ mumbayãte quia nae, ũquɨ̃ nguia nyesecuate nguiã serese. Paba nyesecuate ũquɨ̃ ndese. Se abe achesecuate ũquɨ̃ ndese. Tachecua ñɨmbucha ũquɨ̃ ndese, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, ɨ que echɨmbaaquiatu mo je ra. Judas Iscariote eã ño aque re. Judas mo ño aque re. Judas que ñee Jesús je ra. —¿Mbaerã nda erechecua ure je re? Mbia ja je nyecua rocoĩ, ɨ que Judas ra. ");
INSERT INTO srqNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús que ñee ee ra. —Ae nyesecuate quia serese, ũquɨ̃ secheẽ mumbayãte quia ã. Paba abe ra nyesecuate ũquɨ̃ ndese. Paba ra siqui ũquɨ̃ ndese. Se abe ra aɨco ũquɨ̃ ndese. ");
INSERT INTO srqNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ae nyesecua eãte quia serese, ũquɨ̃ secheẽ mumba mumbate quia ã. Secheẽ ae eã asenei senei nguiã jẽje co. Paba cheẽ ño asenei senei nguiã jẽje. Ae chõ sembu nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Seso nonde aɨco co renei nenei jẽje a. Sereco mosebe jendese. ");
INSERT INTO srqNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Paba ra Espíritu Turã mondo jẽje secheẽ nduɨ sɨ. Jẽquiato tuchɨ ra Espíritu Turã cote. Ae ra jembaaquiatu tuchɨ mbae ja rɨɨ̃ cote. Ae ra jemundua tuchɨ secheẽ ndese cote. ");
INSERT INTO srqNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Co aso quia co. Jẽyayã eã taemɨngo a. Seɨcuasa reã na sɨ eã taemɨngo. Ũquɨ̃ nguia eya eãte riqui nguiã. Sã seyate se no. Eɨ̃ tae jembia mɨngo a. ¡Jẽya beɨ chõ jẽ! ¡Jẽsiquicheã ño jẽ! ");
INSERT INTO srqNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Aso ra Paba rea cote. Aquere ra achube jembirõ. Ũquɨ̃ ndese que jẽirandu resẽ. Jenyesecua mose serese, eɨ̃ ndei ra jẽyate secheẽ ndese. “Taso Paba rea”, ɨ mose. Ae quiarei ɨ tuchɨ sesɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Seso nonde aɨco ñee tuchɨ jẽje a cote. “Ñee ñooñoã tuchɨ quia equia re”, jenye tuchɨ ra seso mose cote. Huee ra jẽ seɨcua tuchɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","A nda aɨcobe ñee ñee jẽje chã. Diablo quia tu nguiã co. Mbia ɨcuã nderecua ru quia co. Ae quiarei equirãcuã neã jiri sesɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Paba cheẽ nduɨ sɨ taɨco. Mbia seɨquia arondete raque. “Nyesecua tuchɨ quia equia ngu rese re”, ɨ ra mbia seje cote. Paba cheẽ mumbayã mose. Jẽhuã. Nyao, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús que ñeembe uchɨmbaaquiatu je ra. —Se rei ira i rã. ");
INSERT INTO srqNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Paba rei ira raarõsa rã. Ira rãquiã ndɨbɨsho ɨa eã mose, nyisia rae. Erãquiã ɨa mose, saarõ turã ndae. Mbeerera rera rae. Embitirõ sacuã. Ia tuchɨ sacuã cote. ");
INSERT INTO srqNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jẽ ngue secheẽ jẽisi turã ndesẽ. Nyebe Paba jembitirõ secheẽ je resẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jẽɨngo beɨ ñɨmbucha serese. Sã aɨco ñɨmbucha jendese no. Ira rãquiã ae ra ɨa eã. Siquíã mose ñɨmbucha hui rese. Eɨ̃ jenye ra jẽ. Mbae turã nda jẽsaã eã jẽ ae. Siquíã mose ñɨmbucha serese. ");
INSERT INTO srqNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Se rei ira i rã. Erãquiã na ndei jẽ. Jẽɨngo mose ñɨmbucha serese, seɨco mose ñɨmbucha jendese, jẽturã tuchɨ ra jẽɨngo cote. Jẽ ae ra mbae turã jẽsaã eã, siquíã mose ñɨmbucha serese. ");
INSERT INTO srqNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ae siquíã ñɨmbucha serese nae, ũquɨ̃ nda siqui ira rãquiã sia ji rã. Eɨru mose ra mbia emunua nua. Eréi sacuã. ");
INSERT INTO srqNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jẽɨngo beɨ mose serese, jeñee nda amumbayã. “Mbae embu ure je”, ɨ mose, amondo ra jẽje. Jẽtesareɨã mose secheẽ sɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Jẽɨngo turã mbeɨ mose, mbia ra ñee turã turã mbeɨ Paba rɨɨ̃. Jẽɨngo turã mbeɨ mose, “Jesús chɨmbaaquiatu tuchɨ quia eriqui re”, ɨ ra mbia jenɨɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Sã Paba riqui nyesecua serese nae, eɨ̃ ae sɨ equia nyesecua jendese co. Jẽɨngo beɨ ñɨmbucha serese. Eɨ̃ nda achesecua beɨ jendese. ");
INSERT INTO srqNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Paba cheẽ amumbayãte quia co. Nyebe Paba riqui nguiã nyesecuate serese co. Jẽ secheẽ mumbayã mose, achesecua beɨ tuchɨ ra jendese. ");
INSERT INTO srqNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Aɨco ñee jembaaquiatu co. Jembia sacuã. Sã seyate se no, se rã sɨ ra jẽya. ");
INSERT INTO srqNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ã ndei secheẽ ã: ¡Jenyesecua tuchɨ quia jenyɨese jẽ! Sã aɨco nyesecua tuchɨ jendese no. ");
INSERT INTO srqNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","“Se tamano sequiato rɨbɨshorõ”, ɨ mose emo, aque quiarei nyesecua tuchɨte uquiato rese. ");
INSERT INTO srqNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Sequiato rei jẽ, secheẽ mumbayã mose. ");
INSERT INTO srqNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Serimba” aeã nda jẽje cote. Ererecua quiatu “sequiato” ɨ ãte nguiã ngũimba je. Ñee ja eãte ngũimba je. Sã eriqui ñee ja uquiato je no. Se quia ñɨ Paba cheẽ asenei senei jate nguiã jẽje. Nyebe “sequiato” tae jẽje cote. “Serimba” ɨ rocoĩ. ");
INSERT INTO srqNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Jẽ ngue seirabo eã ndesẽ. Se quiatu ngue jaẽirabo nguiã. ¡Mbae turã ño jẽsaã saã mbeɨ quia seje jẽ! ¡Jenyɨsaã nda uachɨ̃ jẽ! Jẽ ngue seɨcuate. Nyebe jẽ “mbae mo embu ure je”, ɨ mose Paba je, mondo ra jẽje. ");
INSERT INTO srqNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ã ndei secheẽ jẽje ã: ¡Jenyesecua tuchɨ quia jenyɨese jẽ! ");
INSERT INTO srqNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Dios ɨcuasa reã nda jẽucuayãte cote. ¡Jẽɨcua quiatu jẽ! “Eɨ̃ ngue equia Jesús ucuayã nyii resẽ”, jenye ra cote. ");
INSERT INTO srqNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jaẽirabo que se ra. Nyebe jẽɨngo nguiã Dios ɨcuasa reã na eã. Nyebe eriqui nguiã jẽucuayãte ã. Jẽ ũquɨ̃ na mose, eɨ̃ nda eriqui turãte rei jendese. ");
INSERT INTO srqNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Acheẽ ngue jẽje nyii, ¡ũquɨ̃ ndese jendua jẽ! ¡Jengasu ra jẽsaã saãchɨ̃ sesɨ jẽ! Mbia ɨcuã mose seje, jẽje abe ra eɨcuã. Mbia secheẽ mumbayã mose, jẽ abe cheẽ mumbayã ndae. ");
INSERT INTO srqNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Serɨɨ̃ nda Dios ɨcuasa reã jeɨ̃ jeɨ̃ jẽje. Dios ɨcuayãte quiatu nguiã ã. Nyebe ra eɨcuã ɨcuãte jẽje. ");
INSERT INTO srqNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Achu que mbia mbaaquiatu quiatu ra. Nyebe ra Dios eɨcuã tea chooñoã cote. Eɨ̃ nda Dios eɨcuã tea chooño ndei. Se embaaquiatu eã mose. “Ureɨcuã ureɨcuayãte quia ã”, ɨ aronea ño emo cote re. ");
INSERT INTO srqNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ae seucuayãte quia, Paba abe ucuayãte equia ã. ");
INSERT INTO srqNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mbia mae sayã ngue ateacuquia tuchɨ rei ee ra. Sechɨsaã nda mbia mo saã eã. Eɨ̃ nda Dios mbia ɨcuã tea chooño ndei. Sechɨsaã ndese mae eã mose. Sechɨsaã ndese mae ndaque, seucuayã ño nguiã ã. Paba abe ucuayã ño nguiã ã. ");
INSERT INTO srqNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mbia riqui seucuayãte ã. Sã embesa ji riqui ñee no: “Mbia seucuayãte. Se mbae ɨcuã asaã eãte raque”, sã embesa ji riqui ɨ no. Ũquɨ̃ ɨquechɨ̃ cote. ");
INSERT INTO srqNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Seso mose Paba rea, Espíritu Turã tamondo jẽje. Jẽquiatorã. Ae ra tu Paba sɨ jẽje. Ae ra ñee ñooñoã jẽje. Ae ra jembaaquiatu quiatu turã serɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nyii mosenda beɨ chõ jẽɨngo nguiã serese. Nyebe ra jẽ abe mbia jembaaquiatu quiatu turã serɨɨ̃, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesús que ñee ɨ ɨ uchɨmbaaquiatu je ra. —A aɨco ñee jẽje a. Eɨ̃ nda jẽhuɨ eã sesɨ, mbia ɨcuã ɨcuã mose jẽje. ");
INSERT INTO srqNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mbia ra jendiquisã quisã, jẽso jẽso mose mbia chumunuasa. “Ã ureɨco rei nguiã mbae turã naa naa Dios je ã”, ɨ ra mbia jẽɨquia ɨquia mose. ");
INSERT INTO srqNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Seɨcuayãte quia ñe ne. Paba abe ɨcuayãte quiatu nguiã ã. Nyebe ra eriqui mbae raã ɨcuã ɨcuã jẽje. ");
INSERT INTO srqNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Eɨ̃ ae chõ nguiã ñee jẽje co. Eɨ̃ nda jendua secheẽ ndese, mbia ɨcuã ɨcuã mose jẽje. “Jesús cheẽ ɨquechɨ̃ cote”, jenye ra cote. Acheẽ jeɨ eã ngue jẽje ũquɨ̃ cose resẽ. Aɨcote quiatu ngue jendese re. ");
INSERT INTO srqNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Co quia asote nguiã Paba rea co cote. Ae sembu. “¿Manguete ra ereso mangue re?” ɨ eã ñochɨ̃ jemo seje. ");
INSERT INTO srqNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Se “taso” ɨ mose jẽje, jẽya eãte chõ jẽɨngochɨ̃ nguiã ã. ");
INSERT INTO srqNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tacheẽ nyecua jẽje. Coche aso nguiã jendecha co. Espíritu Turã nda ambu jẽje. Jẽquiatorã. Ae ra siqui jendese. Eɨ̃ nda Espíritu Turã tuãte rei. Seso eã mose jẽsɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Espíritu Turã tu mose ra ñee ñee mbia je. “Mbia ɨcuã ja chõ ñe ne. Jẽɨngo turã Dios resa rae. Dios ra Jesús ɨcuasa reã mbasi ja”, ɨ ra Espíritu Turã ñee mbia mbaaquiatu quiatu. ");
INSERT INTO srqNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","“Jẽ nguia Jesús jẽɨcuayãte nguiã ã. Nyebe jẽɨcuã ndiqui nguiã”, ɨ ra Espíritu Turã ñee mbia mbiirandu. ");
INSERT INTO srqNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Aso ra Paba rea cote. Mbia ra mae eãte serese cote. Nyebe ra Espíritu Turã mbia mundua mbae turã ndese cote. ");
INSERT INTO srqNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","“Dios ra diablo mondo tata cuasu. Nyebe ra mbia ɨcuã abe mondo tata cuasu”, ɨ ra Espíritu Turã ñee mbia mbiirandu. ");
INSERT INTO srqNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Taembaaquiatube jiri”, ae rei se. Jẽɨcuayã jeɨte chõ ndae. ");
INSERT INTO srqNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Espíritu Turã tu mose, ae ra jembaaquiatu quiatu turã mbae ja rese. Ñee ñooñoa tuchɨ rae. Ucheẽ ae ra esenei seneiã. Paba cheẽ ño esenei senei nguiã. Mbae tu nonde ra Espíritu Turã jembiirandu erese. ");
INSERT INTO srqNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Espíritu Turã nda jembaaquiatu quiatu secheẽ nɨɨ. Ũquɨ̃ mose ra mbia ñee turã turã serɨɨ̃ cote. ");
INSERT INTO srqNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ae Paba senei senei nguia, ũquɨ̃ asenei senei nguia se abe co. Nyebe ra Espíritu Turã jembaaquiatu quiatu secheẽ nɨɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Namo jiri ra jemae eã serese cote. Aquere ra jemaembe serese cote. Aso ra Paba rea, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Echɨmbaaquiatu que ñee ñee nyue ra. —¿Mbae ɨ Jesús quia re? “Namo jiri ra jemae eã serese cote. Aquere ra jemaembe serese cote. Aso ra Paba rea”, ɨ chõchɨ̃. ¿Mbae ũquɨ̃ nde? ");
INSERT INTO srqNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Mbaerã eriqui “namo jiri” ɨ re? ¿Mbae rɨɨ̃ eriqui ñee nde? Nandeiranuã tuchɨchɨ̃, ɨ que echɨmbaaquiatu ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús que jirandu erese ra. —“Ndecheẽ embiasa jiri ure je” ¿jenye sete seje re? “Namo jiri ra jemae eã serese cote. Aquere ra jemaembe serese cote”, ae que jẽje, ¿aque jẽɨcuayãte re? ");
INSERT INTO srqNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tacheẽ nyecua jẽje. Namo jiri ra jenyeseo. Jẽya eãte rae. Sequiatoã nda eya tuchɨ. Aquere ra jẽya tuchɨ cote no. Jẽya eande nyii. ");
INSERT INTO srqNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Serasichɨ̃ nda cote re”, ɨ ra esi ndua ndua ãquẽ nyaacuquia serɨ̃ mose. Eyayã tuchɨ ae. Ãquẽ nyaacuquia mose cote, eya tuchɨ ra cote. Ndua eã tuchɨ ra ngasi rese cote. Eya tuchɨ chõ nda nguiirĩ ndese cote. ");
INSERT INTO srqNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ãquẽ ndasi rã ño jẽ nde. Jẽya eãte namo. Setube mose jendea, jẽya tuchɨ ra cote. Emo nda jembia eã eã cote. ");
INSERT INTO srqNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ndecheẽ embiasa jiri ure je”, jenye eã nda seje cote. Tacheẽ nyecua jẽje. Jẽ seɨcuate. Nyebe jẽ “mbae mo embu ure je”, ɨ mose Paba je, mondo ra jẽje. ");
INSERT INTO srqNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","“Mbae mo embu ure je. Jesús ɨcuasa je”, jenye eã mbeɨte equia Paba je ã. Jeñee ee. Jeñee mose ee, mondo ra jẽje. Jẽya tuchɨ ra cote. ");
INSERT INTO srqNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Acheẽ tuchɨ rei que jẽje ra. Secheẽ ngue ambiasa tuchɨã jiri jẽje ra. Emo mose jiri quia ra secheẽ ambiasa tuchɨ jẽje cote. Paba rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Aque mose ra jeñee Paba je. “Mbae embu rã ure je”, jenye ra Paba je serɨɨ̃. Aque mose ra acheẽ eã ee jenɨɨ cote. Jẽ ae chõ nda jeñee ee cote. ");
INSERT INTO srqNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Paba sɨ́ nyesecua tuchɨte quia jendese co. Jenyesecuate quiatu nguiã serese ã. “Dios que Jesús mondo nande je resẽ”, jenye quiatu nguiã seje ã. Nyebe Paba riqui nguiã nyesecua tuchɨ jendese. ");
INSERT INTO srqNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Paba sɨ que achu íbii resẽ. Asobe ra ibi recha cote. Paba rea ra asobe ibátee cote, ɨ que Jesús ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Echɨmbaaquiatu que ñee ee ra. —Ereɨcochɨ̃ ñee nyecuate ure je a cote. Ndecheẽ erembiasa tuchɨchɨ̃ nguia ure je a cote. ");
INSERT INTO srqNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mbae ereɨcua ja tuchɨ quiatu quia nde reaẽ. Mbia ndua ndua ereɨcuate quia equia co reaẽ. Ñee nonde ndeje. Nyebe ureɨco nguiã ndeɨcuate ã. “Paba sɨ chõ erechu nguiã co”, ure equia ndeje ã, ɨ que echɨmbaaquiatu ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús que ñee ee cote ra. —Jẽ ngue seɨcuate rei nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Seandu rã se. Namo jiri ra jeñɨmbuchao chao oso sesɨ. Jẽso ja ra serecha namo. Se ae eã nda aɨco. Paba riqui nguiã serese co. ");
INSERT INTO srqNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Jẽ seɨcua mose, mbae ra jembia eã eã. Nyebe aɨco nguiã jembiirandu randu beɨte co. Mbia ɨcuã ɨcuã mbeɨte ra eriqui jẽje a íbii. ¡Jeñɨmbirãcuã jiri quia jẽ! Se quia sequirãcuã tuchɨ ibi jenda sɨ re, ɨ que Jesús ñee uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús ñee jare uchɨmbaaquiatu je que soboiba mae ibate ñee Dios je ra. —Paba, ndecheẽ ndiquichɨ̃ ɨo a cote. Seturã eteacuquia mbia je cote. Eɨ̃ nda se abe ndeturã ateacuquia mbia je. ");
INSERT INTO srqNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nde chõ ngue semɨɨ mbia rerecuarã, Paba. Mbia mɨngo beɨ sacuã. Mbia que eremee seje, ũquɨ̃ mɨngo beɨ sacuã. Se rei nderucucha. ");
INSERT INTO srqNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Paba, nde mɨɨ ndei Dios tuchɨ ereɨco co. Se rei Jesucristo ndechɨmbu ibate sɨ. Ae ndeɨcuate quia nae, se abe ɨcua equia nae, ũquɨ̃ nda siqui beɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ndeturã ngue ateacuquia mbia je ra. “Ã esaã íbii”, ere que seje, ũquɨ̃ ngue asaã ja cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Paba, seturã eteacuquiabe mbia je. Cose ndare rã. Mbae eã mosenda rã. Asobe ra siqui nderese. MSã ndeturã ereteacuquia mbia je nae, seturã abe eteacuquia mbia je. ");
INSERT INTO srqNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mbia que eremee seje, ũquɨ̃ ngue ambiirandu tuchɨ nderese ra. Nembae rei que nyii ra. Eremee ngue seje cote ra. Ndecheẽ ngue emumbayã nda. ");
INSERT INTO srqNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nde chõ ngue sembaaquiatu quiatu nguiã, Paba. Ndecheẽ ae chõ ã nde. Secheẽ eã ño ñe ne. Ũquɨ̃ ngue sechɨmbaaquiatu ɨcuate ra. ");
INSERT INTO srqNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Eresenei senei ngue seje, ũquɨ̃ ngue asenei senei ja ee ra. Nandecheẽ ngue eisi ja turãte ra. “Paba sɨ que Jesús ru ra. Paba que embu ra”, ɨ equia nderɨɨ̃ ã. ");
INSERT INTO srqNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Sechɨmbaaquiatu eteaquiatu, Paba. Seɨcuasa reã je eã ño aɨco nguiã “eteaquiatu” ɨ ndeje. Ae eremee seje nae, ũquɨ̃ je chõ aɨco nguiã “eteaquiatu” ɨ ndeje. Nderimbate quia ñe ne. ");
INSERT INTO srqNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ae nderimba nae, serimba chõ se abe re. Ae serimba nae, nderimba chõ ũquɨ̃ no nde. Serimba riqui ñee turã mbeɨ serɨɨ̃ ã. ");
INSERT INTO srqNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Asobe ra ndeje, Paba. A ra aɨcoã íbii cote. Serimba quia ra chɨchõ íbii. Eteaquiatu, Paba. Ae eremee seje, ũquɨ̃ eteaquiatu ndequirãcuã je. Mbae mɨɨ ndese ja chõ emundua ndua mɨngo. Sã nande nandendua ndua mbae mɨɨ ndese no nae. ");
INSERT INTO srqNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ae eremee seje, ũquɨ̃ ngue ateaquiatu quiatu quia ndequirãcuã je ra. Seɨco mose íbii. Emo ngue quiachã eãte sesɨ ra. Aque mɨɨ nda quiachã. Embesa ji cheẽ nduɨ sɨ ra aque mɨɨ quiachã. Huɨɨcuã je. Emo ngue quiachãyã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Aso ra nderea cote. Seɨco beebe mose íbii, aɨco ñee ñee ndeje serimba rɨɨ̃ a. Ɨ̃ nda eya quiatu chɨ a. Sã seyate se no. ");
INSERT INTO srqNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ndecheẽ ngue asenei senei ee ra. Ibi jenda eã ño se re. Serimba abe rei ibi jenda eã. Nyebe ibi jenda riqui nguiã serimba ucuayã. ");
INSERT INTO srqNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Serimba erao ibi sɨ”, ae eã ño nguiã ndeje co, Paba. “Eteaquiatu diablo sɨ”, ae chõ nguiã ndeje co. ");
INSERT INTO srqNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Se rã sɨ rei serimba. Ibi jenda eã ndiqui ã. ");
INSERT INTO srqNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Serimba emɨngo tuchɨ icúe nembaerã. Ndecheẽ je emɨngo icúe. Nde quia erecheẽ ñooño eãte nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sã nde sembu mbia je no, eɨ̃ ae sɨ chõ nguiã serimba mondo mondo mbia mbaaquiatu quiatu co. ");
INSERT INTO srqNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Aɨco ñɨmondo tuchɨ ndeje co, Paba. Mano sacuã serimba je. Ɨ̃ nda serimba abe ñɨmondo tuchɨ ndeje. ");
INSERT INTO srqNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ã nɨɨ achõ eã aɨco ñee ndeje. “Eteaquiatu” ɨ ndeje. Ã nda secheẽ senei senei emo je abe cote. Ũquɨ̃ abe ra seɨcua cote. Serimbarã. Ae ra seɨcua ɨcua nae, ũquɨ̃ abe eteaquiatu. ");
INSERT INTO srqNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mbae mɨɨ ndese ja chõ ũquɨ̃ emundua ndua mɨngo. Mbae mɨɨ naanguia tuchɨ emɨngo nanderese, Paba. Sã ereɨco serese no nae. Sã aɨco nderese no nae. Eɨ̃ nyere sɨ ũquɨ̃ mɨngo mbae mɨɨ na. Eɨ̃ nda mbia seɨcuasa reã ñee serɨɨ̃. “Dios chɨmbu quia eriqui re”, ɨ nda mbia ñee serɨɨ̃ ña. Seɨcuasa siqui mose mbae mɨɨ ndese. ");
INSERT INTO srqNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ndeturã ngue eremee seje, eɨ̃ ae que seturã mondo seɨcuasa je ra. Eɨ̃ nda eriqui mbae mɨɨ na. Sã nandeɨco mbae mɨɨ na nande no, Paba. ");
INSERT INTO srqNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nyebe aɨco nguiã seɨcuasa rese co. Nde ereɨco serese co no. Nyebe seɨcuasa riqui mbae mɨɨ na co. Eɨ̃ nda seɨcuasa reã ñee nderɨɨ̃. “Dios quia Jesús mbu quia reaẽ. Dios quia nyesecua quia Jesús ɨcuasa rese re. Jesús rese rã sɨ nyesecua”, ɨ nda mbia ñee nderɨɨ̃ ña. ");
INSERT INTO srqNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Paba, serimbarã ngue eremee seje. Ae ra aso, sã echoɨ serea siqui beɨ huee serese cote. Ndecheẽ turã andu sacuã serɨɨ̃ huee. Erecheẽ turã mbeɨte serɨɨ̃. Ibi eã mosenda beɨ chõ ereɨco nguiã nyesecua serese co. ");
INSERT INTO srqNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ndeturã tuchɨ, Paba. Seɨcuasa reã ndeɨcuayãte quia ã. Se quia areɨcuate nguiã co. Serimba abe que ndeɨcuate quia ã no nda. “Dios chɨmbu”, ɨ seje nderɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Arerenei nenei tuchɨ que serimba je ra. Tarerenei nenei tuchɨbe ee. Eɨ̃ nda nyesecua tuchɨ nyɨese. Sã ereɨco nyesecua tuchɨ serese no nae. Taɨco beɨ serimba rese cote, ɨ que Jesús Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús ñeende ngu je que echoɨ ama ñetẽ ndobeɨ ra. Cedrón, ɨ que aque ama je ra. Aque robeɨ que esɨ uchɨmbaaquiatu rese ra. Iraqui turã mo ngue echoɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesús que oso oso beɨte quia huee ra. Iraqui re. Uchɨmbaaquiatu rese. Nyebe Judas riqui nguiã hue ɨcuate. —Jesús tateacuquia checuayã mbia je, ɨ que Judas ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nyebe Judas mbia ruruchoɨ nguiã huee Jesús isi sacuã. Soldados que ecuruchoɨ ra. Policía jenda abe que ecuruchoɨ no nda. Sacerdotes rerecua chɨmondo rei policía. Fariseos chɨmondo abe no. Ũquɨ̃ ja que nyoɨ ngasẽ Jesús je ra. Tiquise que ecuruchoɨ quia ra. Lámparas abe no. Mbae rendi abe no. ");
INSERT INTO srqNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús que mbae ɨcuate ra. —Mbia ra jeɨ̃ jeɨ̃ seje, ɨ que eɨcuate ra. —¿Aba rea jenyu quia co re? ɨ que oso ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesús rea urechu quia co. Nazaret jenda, ɨ que mbia ñee nda. —Se chõ Jesús resẽ, ɨ que ee ra. Judas abe que siqui mbia rese huee ra. Ae que siqui Jesús mee mbia ɨcuã je huee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","—Se chõ Jesús resẽ, ɨ mose que mbia siri siri choɨ uquite quiti ra. Ngoɨ ngoɨ chee que echoɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","—¿Aba rea jenyu quia co re? ɨbe que Jesús ñee ee ra. —Jesús rea urechu quia co, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús que ñeembe ee ra. —“Se chõ nyeresẽ”, ae que jẽje. Serequia mose, sererao se ae. Sã seresenda chɨchõ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","—Ae Paba mee seje serimbarã, ũquɨ̃ mo quiachãyãte sesɨ, ɨ que Jesús nyii ra. Nyebe ñee nguiã mbia je cote. —Sã seresenda chɨchõ, ɨ mbia je cote. ");
INSERT INTO srqNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedro que uchuuru siqui tiquise ra. Sacerdote rerecua rimba rese que tiquise rerequɨe requia ra. Eisa que echisia equiatocuti quitinda ra. Malco, ɨ que aque je ra. Ae isa Pedro chisia. ");
INSERT INTO srqNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús que ñee Pedro je ra. —Ndechuuru emingue chõ eriru ye. Paba cheẽ tamumbayã na. Tachecuachõ na mbia je. Sã mbia ɨcuã sembasi tuchɨ cote, ɨ que Jesús Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Soldados que Jesús isi cote ra. Soldados rerecua rese. Policía rese. Ũquɨ̃ ja que Jesús isi ra. Nyucua que suruchoɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anás chuchua rane ngue eruruchoɨ ra. Anás ndiirĩ ngue Caifás ninisi ra. Caifás que sacerdote rerecua aque mose ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás sɨ́ quia que ñee nyii ra. —Aque mɨɨ ño nda mano nguiã nande ja je chã, ɨ que judíos je nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Mbia Jesús ruruchoɨ mose que Simón Pedro nyoɨ eruɨ ra. Jesús chɨmbaaquiatu nongue rese. Co mɨɨ ndese. Enongue que sacerdote rerecua ɨcua ra. Nyebe ɨque oso nguiã Jesús ruɨ. Sacerdote rerecua itaicuee. ");
INSERT INTO srqNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mbia que Pedro siquisã mɨɨ etaronda robeɨ ra. Sacerdote chɨɨcua que tu nyebi ñee echɨquesa raarõsa je cote ra. —Sã Pedro ɨque rã serese, ɨ que ra. Nyebe emingue nguiã cote. ");
INSERT INTO srqNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Echɨquesa raarõsa que ñee Pedro je ra. —¿Jesús resenda nde re? ɨ que nyucuaaque Pedro je ra. Echɨquesa raarõsa. —Tei, ɨchõɨño ngue Pedro ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nyiiseĩte mose que ra. Nyebe policía jenda tata mbucha nguiã. Sacerdote rimba rese. Ũquɨ̃ ja que chɨ nyee ra. Pedro que chɨ̃ nyee erese ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sacerdote rerecua que ñee Jesús je ra. —¿Aba ndechɨmbaaquiatu re? ¿Mbae rɨɨ̃ ereɨco mbia mbaaquiatu quiatu re? ɨ que ererecua ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús que ñee ee ra. —Se que acheẽ ja mbia resa rae ra. Mbia chumunua nuásaa ja que aɨco mbia mbaaquiatu quiatu ra. Dios chuchúaa abe no. Acheẽ nyecuayã cuayã eã ngue se quia mbia ísaa ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Mbaerã ereɨco ñee seje re? Secheẽ andusa je quia echeẽ. Sã ũquɨ̃ ñee. Mbae rɨɨ̃ acheẽ ee re. Ũquɨ̃ ngue secheẽ ñandu ja quia ra, ɨ que Jesús ererecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús cheẽ mose que policía jenda mo ucua eritii rese ra. —¿Mbaerã ereɨco ñee sacerdote rerecua je ũquɨ̃ nde? ɨ que policía mo ñee ucua Jesús rese ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús que ñee ee ra. —Secheẽ ɨcuã mose quia echeẽ seje. Mbae ɨcuã nɨɨ aɨco ñee nde. Secheẽ turã mose chõ erecuachɨ̃ nguiã serese, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anás que Jesús mondo Caifás je cote ra. Ecuasa que ecuruchoɨ Caifás je ra. Caifás que sacerdote rerecua ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro que nyee beɨte u tata ra. Mbia mo ngue ñee ee ra. —¿Jesús resenda nde re? ɨ ee. —Tei, ɨchõɨño ngue Pedro ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ae isa Pedro chisia nae, aque resenda que siqui huee ra. Sacerdote rerecua rimba chõ ae re. Ae que ñee Pedro je ra. —Nde rese amae iraqui re Jesús rese reae, ɨ que Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","—Tei, ɨchõɨño ngue Pedro ee no nda. Aque mose tuchɨ que nguira ñee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Policía jenda que Jesús curuchoɨ Caifás chuchua sɨ cote ra. Ererecua tuchɨ chuchúaa que eruruchoɨ cote ra. Pretorio, ɨ que hue tuchua je ra. Ɨ que nyaashɨ̃ u quia cote ra. Judíos que ɨqueã ererecua chuchua ra. Mbaeɨaete que abae chuchua ee ra. Pascua raã nonde. —Eɨ̃ nda oveja roo nandeuãte rei pascua mose, ɨque mose abae chuchua, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nyebe Pilato sɨ nguiã usẽ ñee ee. —¿Mbaerã jẽɨngo ñee Jesús je re? ¿Mbae ɨcuã esaã nde? ɨ que Pilato ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Mbia que ñee ee ra. —Jesús que mbae ɨcuã saã saãte ra. Eɨ̃ nda uremondoãte rei ndeje. Mbae ɨcuã naa naa eã mose, ɨ que mbia Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato que ñee mbia je ra. —Jẽ ae Jesús jendao ae. Jẽ ae jẽɨngo erese ae. Jẽ ae Jesús jembasi mbasi ae. Jenamei ñɨmbesa mumba mose, ɨ que Pilato ee ra. Judíos que ñee Pilato je ra. —Ure rei judíos. Ure mbia mo ureɨquia aroneate. Nde chõ echb ẽ. “Jẽɨquia” ere chõ soldados je, ɨ que mbia ñee Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesús cheẽ ɨquechɨ̃ cote. —Mbia ra seɨquia sembucha ira rese, ɨ rei nyii. Echeẽ ɨquechɨ̃ cote. ");
INSERT INTO srqNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato que ɨque sɨ oso uchuchúaa ra. Ae “quiatuchu” ɨ nguiã Jesús je. —¿Judíos rerecua tuchɨ nde re? ɨ que Pilato Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús que ñee ee ra. —¿Nde ae erecheẽ nguia seje a re? Emo ñee ndeje nyii reae, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato que ñee ee ra. —Judío eã ño se resẽ. Judíos sɨ́ chõ ngue nemondo seje resẽ. Sacerdote rerecua abe no. ¿Mbae ɨcuã eresaã nde? ɨ que Pilato ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús que ñee ee ra. —Ererecua raque se. Ererecua eã ño se a íbii re. Eɨ̃ nda serimba nyarõ tuchɨ rei serese, judíos ndiquisã quisã tuchɨ sesɨ. Ibi jenda rerecua eã ño se re, ɨ que Jesús Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—¿Ererecua rei nde re? ɨ sɨ que Pilato ñee Jesús je ra. Jesús que ñeembe ee ra. —Ae. Achu que íbii ra. Sechusua rei íbii. Achu que mbia mbiirandu randu Dios cheẽ nɨɨ nda. Ɨchõɨñosa reã ñee nɨɨ. Ɨchõɨñosa reã ndesenda ra seandu ja, ɨ que Jesús Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—¿Mbae ɨchõɨñosa reã nde? ɨ que Pilato ee ra. Aquere que Pilato usẽ sɨ oso ñee judíos je ra. —Mbae ɨcuã Jesús saã eãt e reae. ");
INSERT INTO srqNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pascua mose beɨ que aɨco etarõ ji mbusẽ mondo beɨ jẽje ra. ¿Aba ra ambusẽ mondo jẽje namo nde? ¿Judíos rerecua ra ambusẽ mondo jẽje re? ɨ que Pilato ñee mbia je Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mbia que ñee mombo mombo ja Pilato je ra. —Tei. Aque eã. Barrabás quia embusẽ ɨmbu ure je, ɨ ja que mbia ñee nda. Mbae mbuquiachãsa tuchɨ rei Barrabás. ");
INSERT INTO srqNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","—Jesús jẽiruã nua, ɨ que Pilato ra. Mbia que Jesús iruã nua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nyu ritiméi uma ji que soldados mɨɨ Jesús ãquĩ ndese ra. Tiru ɨreɨ̃ ngue emingue ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","—Judíos rerecua tuchɨ chõ nde re, ɨchõɨño ngue soldados ucua ucua Jesús rese ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato que usẽ sɨ oso ñee mbia je ra. —Secheẽ jeñandu rã. Acheẽ ndei que Jesús je ra. Mbae ɨcuã esaã eãte reae. Nyebe anosembe nguiã jẽje co, ɨ que Pilato ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesús que econosẽ mbia je ra. Nyu ritiméi uma ji que equerao quia uãquĩ ndese ra. Tiru ɨreɨ̃ ngue equerao quia nguete rese ra. —A Jesús a resẽ, ɨ que Pilato Jesús ndeacuquia mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sacerdote rerecua que chɨ ja huee ra. Policía jenda mo abe que chɨ huee ra. Ũquɨ̃ ja que ñee mombo mombo Pilato je ra. —¡Embucha ira rese! ¡Embucha ira rese! ɨ ja que ñee mombo mombo ee ra. Pilato que ñee ee ra. —Jẽ ño jembucha ira rese ae. Mbae ɨcuã esaã eã arõte seje, ɨ que Pilato mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judíos que ñee Pilato je cote ra. —“Dios rucucha rei se”, ɨchɨ̃ Jesús nguiã. Nyebe eɨquia. Sã embesa ji riqui ɨ no: “Ae Dios riirĩ saã saã nguia, aque jẽɨquia”, ɨ que embesa ji ra, ɨ que judíos ñee Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","—Dios rucucha, ɨ mose que Pilato siquiche tuchɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilato que ɨque sɨ oso ñee Jesús je ra. —¿Ma jenda rei nde re? ɨ que Pilato Jesús je ra. Jesús que ñee eã tuchɨ echeẽ mose ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato que ñee sɨ ee ra. —¿Mbaerã ereɨco ñee ãte secheẽ mose re? Arembucha arõte ira rese. Arembuɨ abe arõte se. Se chɨ̃ mbia rerecua, ɨ que Pilato ñee Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús que ñee Pilato je ra. —Dios nemɨɨ eã mose mbia rerecuarã, eɨ̃ nda ereoco ãte rei serese. Ae semondo ndeje, ae quiarei eɨcuã tuchɨ ndesɨ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Aque mose beɨ que Pilato ndua ndua Jesús rese ra. —Jesús tambuɨ mondo, ɨ raque ndua ndua. Judíos quiatu que ñee ee ra. —Nya. ¡Erembuɨchɨ̃ nda jẽ! Nde embuɨ mose, César quiato eã nda nde cote. “Ererecua rei se”, ɨ quia ñɨ Jesús re. Nyebe eɨcuãte riqui nguiã César je, ɨ que judíos tasẽ tasẽ Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","14","Judíos cheẽ andu mose que Pilato ngoi ngũenda tose ra. Huee que eriqui ñee mbeɨte mbia je ra. Gábata, ɨ que erenda je ra. “Sɨta mbiitee ji”, ɨ ñɨ Gábata re. —Jesús jendu rã seje, ɨ que Pilato policía jenda je cote ra. Pascua nonde. Mbia ɨco quiatu mose pascua nonde. Tenda nandeite re mose. —A jenderecua ñɨ a resẽ, ɨ que Pilato mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mbia que tasẽ tasẽ ee ra. —¡Eɨquia rei! ¡Embucha ira rese! ɨ que mbia Pilato je ra. —¿Se ra jenderecua aɨquia re? ɨ que Pilato mbia je ra. —Urererecua mo eãte nyeresẽ. César mɨɨ ño nyeresẽ, ɨ que sacerdote rerecua Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aque mose que Pilato Jesús mondo mbia je cote ra. —Jẽɨquia. Jembucha ira rese, ɨ que mbia je ra. Hue sɨ que mbia Jesús ruruchoɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús que usẽ oso cruz resebe cote ra. Mbia que ecuruchoɨ ibi ibátee ra. “Eresa cuare” ɨ que hue ibi ibate je ra. “Gólgota” ɨ que judío cheẽ hue je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Huee que soldados Jesús mbucha ira rese ra. mbia nyeremo abe que embucha ira rese ra. Co mɨɨ Jesús rɨbɨsho quiti. Enongue erɨbɨsho quiti no. Jesús que emɨɨ eite re ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato que letrero mbesa ra. JESUS DE NAZARET REI JUDIOS RERECUA, ɨ que embesa ra. Embesa ji que emɨɨ ibate Jesús ãquĩ nguiti ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Judíos tubɨrɨã ngue chɨ mae embesa ji rese ra. Sucha tubɨrɨã jiite quiatu ngue Jesús mbucha nguiã ira rese. Embesa ji que chɨ̃ mbia cheẽ mbuae jaaja ra. Judío cheẽ. Griego cheẽ. Latín ñee. ");
INSERT INTO srqNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sacerdotes rerecua que ñee ja Pilato je ra. —“Judíos rerecua” erechɨ̃ nguiã embesa. “Judios rerecua raã ñooño” ere chõ embesa mɨɨ ae, ɨ rei que judíos rerecua Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Ae ambesa, sã ũquɨ̃ ñɨ ño, ɨ que Pilato judíos rerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cuatro soldados que chɨ huee ra. Ũquɨ̃ ngue Jesús mbucha ira rese ra. Ũquɨ̃ ngue Jesús ɨrao isirõ sirõ ja ra. Jesús ɨrao mɨɨ ngue chɨchõ cote ra. Tejido turã tuchɨ que aque tiru ra. Eiasa eã tuchɨ que ra. Eao ji chõ eresebe que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Soldados que ñee nyue ra. —Aque ra nandechisia eã. Sɨta ñetẽ nandesurubaba baba rã nandechue. Aba ra ja. Aba ra eɨrao querao ja, ɨ que nyue ra. Sɨta ñetẽ ngue esurubaba baba uchue cote ra. Embesa ji cheẽ ɨquechɨ̃ cote. Jesús ɨrao soldados mbuchao chao mose. “Seɨrao que embuchao chao nyue ra. Sɨta ñetẽ ngue esurubaba baba uchue ra”, ɨ que embesa ji huɨ̃ nyii ra. Embesa ji ɨquechɨ̃ cote. ");
INSERT INTO srqNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús mbuchasa ira rese que cuña mo chɨ ra. Jesús si que ra. Esi nongue abe que ra. María Magdalena abe que ra. Cleofas ninisi abe que ra. María, ɨ que aque je ra. Ũquɨ̃ ngue chɨ ja Jesús ji ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Juan abe que chɨ Jesús si ji ra. Jesús mae mose usi rese que ñee ee ra. —Taĩ, aque quia nderiirina cote, ɨ usi je. Juan nɨɨ eriqui ñee. Jesuubi tuchɨ quia ñɨ Juan nde. ");
INSERT INTO srqNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","—Aque ndesirã cote, ɨ que Juan je cote ra. Juan ngue Jesús si querao beɨ uchuchua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","—Achɨmbirãcuã tuchɨ que mbae ja je Dios cheẽ nguire ra, ɨ que Jesús uchɨangui re cote ra. —Seɨseɨ, ɨ cote. ");
INSERT INTO srqNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Vinagre mo ngue chɨ̃ mbae mo ye huee ra. Mbia que esponja monde vinagre ye ra. Mondo que Jesús chúruu ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús que vinagre mocõ esponja resenda cote ra. —Dios cheẽ ngue asaã ja cote ra, ɨ que Jesús ra. Uãquĩ ngue embucheseco cote ra. Mano ngue cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Judíos que ñee nyue ra. —Ae embucha ji chɨ ira rese nae, sã ũquɨ̃ chɨã ira rese pascua mose huee, ɨ que mbia ra. Pascua nonde que embucha ira rese ra. Mbia ɨcoquiatu mose pascua nonde. Mbia chumunuasa tuchɨ quiarei pascua. Sábado mose rei pascua. Nyebe mbia ñee nguiã Pilato je. —Sã soldados ira resenda timasiquio ja jẽ. Eɨ̃ nda mano jeɨ. Eɨ̃ nda soldados ecuruchi sábado nonde, ɨ que judíos Pilato je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Soldados que nyoɨ ira resenda tima ndiquio ra. Ae chɨ Jesús rereco chobeɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ngasẽ mose Jesús je, eraaquete que ee ra. Nyebe etima ndiquio eã nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Soldado mo ngue Jesús cúa chɨõ tiquise je ra. Eruqui que uchẽ nda. Eri abe que uchẽ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nyebe aɨco nguiã ã mbesa mbesa a. Amae jee ngue erese re. Acheẽ ñooñoã se quia a. Eɨ̃ nda jẽ abe “ae beɨ jẽ” jenye Jesús rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Embesa ji cheẽ ngue ɨque cote ra. Jesús tima ndiquio eã mose. —Etima nda mbia siquio eã, ɨ que embesa ji nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","—Ae embucha uquia ira rese nae, ũquɨ̃ nda mae sɨ erese, ɨ abe que embesa ji huɨ̃ nyii no nda. ");
INSERT INTO srqNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","José de Arimatea, ɨ que emo je ra. Jesús rimba checuayã ngue ae ra. —Sã judíos jiranuã serese, ɨ que equia uchɨangui re ra. Ae que “Jesús rete embu seje” ɨ Pilato je ra. Pilato que “eno” ɨ ee ra. José que Jesús rete curuchi ira sɨ cote ra. Ae equerao nguiã. ");
INSERT INTO srqNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo abe que tu erea ra. Ae tu ñee Jesús je isa nyii nae, aque. Aque que tu aba mbushɨmbusa tubɨrɨã tuchɨ reru ra. Eraaque mbaerã ndei aba mbushɨmbusa. Ira shɨmbu turã mbucúɨ ji. Mbae a mbucúɨ ji abe no. ");
INSERT INTO srqNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ũquɨ̃ ja que Jesús rete querao cote ra. José. Nicodemo ndese. Aba mbushɨmbusa resebe que eraaque uma uma tiru je ra. Eɨ̃ mbeɨ que judíos quia mbia raaque je ra. Eati nonde. ");
INSERT INTO srqNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesús ɨquiasa rurubi que sɨta ɨmɨ mo ñɨ nda. Eao ramo ji. Mbia raaque mondosa eã nyii. ");
INSERT INTO srqNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Huee que Jesús raaque nduruchoɨ nyati ra. —Cochɨte quia sábado ru nguiã nande je co, ɨ que eati aɨchɨ chõ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo mose que María Magdalena nyoɨ mae Jesús tãsa rese ra. Nyaasɨ̃ nonde. Jesús atiquia nduruba ji que chɨ sɨta ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nyebe echoɨ nguiã uchã ñee Simón Pedro mbiirandu. Jesús chɨmbaaquiatu nongue abe mbiirandu. Ae Jesús quiato tuchɨ nae, aque. —Aba chõ nandererecua raaque sirõ suruchoɨ. Mangue eno mangue reae, ɨ que María Magdalena nda. ");
INSERT INTO srqNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nyebe Pedro sɨ nguiã ea tiquia rea. Uquiato rese. ");
INSERT INTO srqNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nyoɨ ja que uchã nda. Enongue rane ngue Pedro chucuã oso ngasẽ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nyibi que mae Jesús atiquia rese ra. Ɨ que Jesús umanda achõ u tiru ra. Ɨque tuchɨã ngue oso sɨta ɨmɨ nɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Aquere que Simón Pedro ngasẽ cote ra. Ae quiatu que ɨque oso sɨta ɨmɨ nɨ nda. Ae abe que mae Jesús umanda achõ ndese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Eãquĩ umanda rese abe que mae nda. Tiru ataque rese ja eã ngue eãquĩ umanda chɨ ra. Eacua ji que chɨ icúe ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ae rane ngasẽ nguia nyii nae, aque abe que ɨque tuchɨ oso sɨta ɨmɨ nɨ cote ra. Mae tuchɨ que Jesús oreã ndese cote ra. —Jesús quera chõ nguia re, ɨ que eɨcua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ũquɨ̃ ngue embesa ji ɨcuayãte ra. “Jesús ra quera sɨ”, ɨ que eɨcuayãte ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nyebi sɨ que echoɨ uchuchúaa ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María que chɨño nyeseo eatiquia jii ra. Echeseo que nyibi mae Jesús rua rese ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Angeles mo ngue chɨ huee nyeremo ee ra. Eɨraoshĩ ja que chɨ ee ra. Enongue que chɨ̃ ngoi Jesús ãquĩ ndúa quiti ra. Enongue ecuii rúa quiti no. ");
INSERT INTO srqNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Angeles que ñee María je ra. —¿Mbaerã ereɨco nyeseo re? ɨ que María je ra. —Aba chõ sererecua raaque querao. Nyebe aɨco nguiã nyeseo. Mangue chõ eriqui ererequia mangue, ɨ que María ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ucheẽ nduɨbe que mae ndei uquite quiti ra. Ɨ que Jesús uã ee ra. Ɨcua eãte que ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","—¿Mbaerã ereɨco nyeseo re? ¿Aba eresequia quia re? ɨ que Jesús María je ra. Ira a raarõsa Jesús riqui reɨ̃ nguiã María je. Nyebe María ñee nguiã ee. —¿Nde Jesús raaque ererao re? ¿Mangue erechono mangue re? Taso erea ae. Tarao ae, ɨ que María ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús que “María” ɨ María cheẽ mose ra. María que uba tuchɨ Jesús ɨcua cote ra. Judíos cheẽ ño ngue María ñee Jesús je ra. —Raboni, ɨ que ra. —Sembaaquiatusa, ɨ ñe ñee Jesús ɨcua re. ");
INSERT INTO srqNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús que ñee María je ra. ¡Seisi jeɨchɨ̃ nda re! ¡Aso ãte Paba rea resẽ! Eso rã ñee senongue je. “Jesús que ñee jẽje ra. ‘Aso ra ibate Paba rea. Dios rea. Ae abe chõ jendu re. Huee ra aso’, ɨ que Jesús ñee jẽje ra”, ere rã senongue je, ɨ que Jesús ñee María je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","María Magdalena que oso Jesús chɨmbaaquiatu mbiirandu ra. —Amaechɨ̃ Jesús rese, ɨ que ee ra. Jesús cheẽ ngue esenei ja ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Aque mose que domingo ra. Aque isa que Jesús chɨmbaaquiatu chɨ ñumunua nda. Etaronda matã ji que chɨ̃ nda. Siquichete quia judíos sɨ re. Jesús que oso ɨque uchɨmbaaquiatu mbuate ra. Eite re que esɨ ñee ee ra. —¡Jẽya eãte jirichɨ̃ nda jẽ! ɨ que Jesús ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aquere que Jesús o iõsa reacuquia ee ra. Ucúa iõsa abe no. Echɨmbaaquiatu ía tuchɨ que mae Jesús rese ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús que ñee sɨ ee ra. —¡Jẽya eãte jirichɨ̃ nda jẽ! Sã ñɨ Paba sembu no, eɨ̃ tae sɨ jemondo secheẽ nenei nenei sacuã mbia je, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jesús que uchɨmbaaquiatu ɨchu ñee nda. —Espíritu Turã ndu jẽje a cote, ɨ que eɨchu ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","—“Dios chõ jẽɨcuã mbutiã nguiã jẽsɨ co”, jenye mose emo je, Dios ra ũquɨ̃ ɨcuã mbutiã esɨ cote. “Dios chõ jẽɨcuã mbutiã eã nguiã jẽsɨ co”, jenye mose emo je, Dios ra ũquɨ̃ ɨcuã mbutiã eã esɨ, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás oreãte que Jesús nyecua mose uchɨmbaaquiatu je ra. Jesús chɨmbaaquiatu raque Tomás. Eata, ɨ que Tomás je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","—Jesús rese que uremae nda, ɨ que eataque embiirandu ra. Tomás que ñee nda. —Jesús eã ndei e. Se mae eã mose eo iõsa rese, se ocoã mose eo iõsa rese, se ocoã mose ecúa iõsa rese, “nyia” aeã nda se, ɨ que Tomás ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jesús chɨmbaaquiatu que ñumunua sɨ domingo nongue mose ra. Tomás abe que siqui uataque rese huee cote ra. Etaronda matã ji que chɨ̃ nda. Jesús que ɨque oso ra. Eite re que esɨ ñee ee ra. —¡Jẽya eãte jirichɨ̃ nda jẽ! ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ñee ngue Tomás je cote ra. —¡Sã seo jẽ! Seo iõsa rese eoco. Secúa iõsa rese abe eoco ae. “Jesús quera sɨ eãte” ¡ere sɨchɨ̃ nda jẽ! “Jesús que quera sɨ ra”, ere chõ cote, ɨ que Jesús ñee Tomás je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","—Sererecua. Nde rei sembae Dios, ɨ que Tomás Jesús ɨcua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús que ñee Tomás je ra. —Nde mae mose serese, aque mose chõ seɨcuachɨ̃. Mae eã mose serese chõ ngue emo ndiqui seɨcua ra. Ũquɨ̃ nguiarei eya tuchɨ ndesɨ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús que mbia mae sayã saã saã tuchɨ uchɨmbaaquiatu je ra. Ũquɨ̃ ambesa ja eã nguia a. ");
INSERT INTO srqNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ã nguia ambesa ja quia a. Jẽ Jesús ɨcua sacuã. —Jesús rei Cristo. Jesús rei Dios rucucha, jenye nda chã. Ũquɨ̃ ɨcua mose ra jẽɨngo beɨ. ");
INSERT INTO srqNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Aquere que Jesús nyecua sɨ uchɨmbaaquiatu je ra. Ama nimia ndese que eñɨ nda. Tiberias, ɨ que aque ama ndɨsa je ra. Eɨ̃ ngue Jesús uã nyecua ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Echɨmbaaquiatu que chɨ nyɨese ra. Simón Pedro. Tomás ndese. Ae je eriqui “Eata” ɨ. Natanael ndese. Caná de Galilea jenda rei Natanael. Zebedeo riirĩ abe que chɨ ra. Echɨmbaaquiatu nongue abe que chɨ nyeremo no nda. ");
INSERT INTO srqNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","—Taso rã sɨra rea, ɨ que Simón Pedro ra. —Ure abe ra ureso nderese, ɨ que eataque ee ra. Nyoɨ ja rei que sɨra rea ra. Nyuɨ ja que echoɨ canoa ye ra. Sɨra que embua mbua eãte aque isa ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Jesús que chɨ̃ erimia ndese echɨmbaaquiatu je ra. Jesús eã eriqui reɨ̃ nguiã ee. ");
INSERT INTO srqNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","—¿Sɨra mo jembua re, Ãquẽ? ɨ que Jesús ñee mombo ee ra. —Tei, ɨ que echɨmbaaquiatu ee ra. Jesús ɨcua rocoĩ. ");
INSERT INTO srqNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Sɨra mbua mbuasa jenduba canoa quiato cuti. Sɨra ra jembua cote, ɨ que Jesús ee ra. Jesús cheẽ ngue emumbayã nda. Sɨra que ua jate embua mbuasa ye cote ra. —Nandenosẽ ama sɨ. Nandechuchã canoa ye, ɨ rei que ra. Eusite que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ae Jesús quiatote, aque que ñee nda. —Jesús chõ eriqui re, ɨ que uataque je ra. Pedro eandu mose que huɨɨrao mingue asi oso ii ra. Jesús rea. Sɨra mbua mbua nonde quia huɨɨrao mbuɨ nguiã nyii. ");
INSERT INTO srqNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ɨsho tuchɨã ngue ama nimia nda. Cien metros chõ ngue ra. Pedro ataque que canoa querao ama nimia ndɨɨchã nda. Sɨra mbua mbuasa que ecuruchoɨ quia mbutiriri sɨra resebe ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nguichi que canoa sɨ ibi rɨ̃ cote ra. Ɨ que tata u ee ra. Sɨra mɨɨ ngue chɨ tata rɨ̃ ee ra. Mbichae abe que chɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","—Sɨra mo jendu rã. Ae jembua ramo, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro que nyuɨ oso canoa ye ra. Sɨra mbua mbuasa que embutiriri serao sonosẽ ama nimia ndese cote ra. Embisẽ sɨra resebe. Sɨra mbua mbuasa que soroãte enonosẽ mose ra. Sɨra cuasu achõte raque. Sɨra 153 raque. ");
INSERT INTO srqNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","—Jenyu quiaru cote, ɨ que Jesús ee ra. —¿Aba nde re? ɨ ãte que emo ñee ɨreɨ̃ nguíã ee ra. Mbia que Jesús ɨcua jate ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús que oso tátaa cote ra. Mbichae que esirõ nda. Mbuchao chao que uchɨmbaaquiatu je ra. Sɨra abe que embuchao chao ee ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesús que mano nyii ra. Quera sɨ que ra. Nyecua nyecua que uchɨmbaaquiatu je cote ra. Co rei tercera vez co. ");
INSERT INTO srqNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Quiaru jare que Jesús ñee Simón Pedro je ra. Jonas ndiirĩ ndei Simón Pedro. —Simón, ¿erechesecua tuchɨ quia serese ã sɨ re? ɨ que Jesús Pedro je ra. —Ae. Achesecua tuchɨte sequia nderese co resẽ. Seɨcuate se resẽ, ɨ que Pedro ñee ee ra. —Oveja raarõsa rã eɨco no. Seɨcuasa embaaquiatu quiatu quia secheẽ je no, ɨ que Jesús Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","—Simón, ¿erechesecuate quia serese re? ɨ sɨ que Jesús ñee Pedro je ra. Pedro que ñee ee ra. —Ae. Achesecua tuchɨte sequia nderese co resẽ. Seɨcuate se resẽ, ɨ sɨ que Pedro ñee ee ra. —Oveja raarõsa rã eɨco no. Seɨcuasa esaarõ turã nguia no, ɨ que Jesús Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","—Simón, ¿erechesecuate quia serese re? ɨ sɨ que Jesús ñee Pedro je ra. Co que tercera vez cote ra. Jesús ñee tres veces mose que Pedro ía eã tuchɨ ra. Pedro que ñee ee cote ra. —Mbae ereɨcua jate quia co, Sererecua. Achesecua tuchɨte sequia nderese co resẽ, ɨ que Pedro ñee Jesús je ra. —Oveja raarõsa rã eɨco no. Seɨcuasa esaarõ turã nguia no. ");
INSERT INTO srqNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tacheẽ nyecua ndeje, Pedro. Ndeyasu mose que ereɨco ndeɨrao mɨngue oso ngata chooño ndesose quiti ra. Nde ameɨ mose ra ndechiba ereɨra cote. Mbia ra ndecua cote. Ndeso sere ãsa quiti ra mbia nderuruchoɨ cote, ɨ que Jesús Pedro je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","—Eɨ̃ nda mbia Pedro ɨquia, ɨ chõ Jesús re. —Eɨ̃ nda Pedro Dios quirãcuã ndeacuquia mbia je, ɨ chõ Jesús re. —Eɨco seruɨ, ɨ que Jesús Pedro je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro que uba mae serese cote ra. Se rei Juan. Jesús nyesecua tuchɨ rei se. Se chõ ngue acoi huɨ̃ quiaru Jesús jii aque isa resẽ. Se chõ ngue “¿Aba ra nemee mbia ɨcuã je re?” ae Jesús je resẽ. ");
INSERT INTO srqNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro que mae serese cote ra. Ñee ngue Jesús je cote ra. —¿Mañɨ ɨte ra mbia quia Juan je re? ɨ que Pedro Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús que ñee ee ra. —¿Mbaete ere? Seruɨ chõ eɨcochõ nde. “Sechube mose chee ra Juan manoã”, se ɨ mose, manoã ndae. Eɨco chõ seruɨ nde, ɨ que Jesús Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","—Juan nda manoã mbeɨchɨ̃ nde, ɨ que Jesús ɨcuasa Juan nɨɨ cote ra. Jesús cheẽ abi chõchɨ̃. —Juan nda manoã, ɨre rocoĩ Jesús nyii. —Se cheẽ mose ra manoã, ɨ chõ ndei ngue Jesús re. —Juan nda manoã, ɨ ãte que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jesús chɨmbaaquiatu chõ se re. Se chõ ã ambesa ja nguiã. Amae jate que se quia Jesús chɨsaã ndese ra. Acheẽ ñooño eãte se quia ã mbesa mbesa co. ");
INSERT INTO srqNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús chɨsaã saã tubɨrɨãte quia ñene. Ambesa ja aroneãte quia a. Jesús chɨsaã saã mbesa ja mose, eɨ̃ ndei ra papel mbesa ji mbia recua mbiitayã jate. Amén.");
INSERT INTO srqNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Ambesa que ndeje nyii, Teófilo. Arembiirandu ja que Jesús chɨao rese. Ereco mose íbii. Jesús que mbia mbaaquiatu quiatu ereco mose íbii ra. Dios que equerao beɨ jiri ibate cote ra. Ũquɨ̃ ngue asenei senei ndeje nyii ra. Oso nonde ibate que ucheẽ nenei nenei sacuã irabo ra. Uchiirabo que embaaquiatu quiatu ra. Siqui que Espíritu Turã ndese mbia mbaaquiatu quiatu ra. Eaquiatu que esecha oso ibate cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Manonde que eru sɨ nyecua ũquɨ̃ je ra. Oso nonde ibate. Ngueco que eteacuquia cuquia sɨ ee ra. Cuarenta días que eriqui nyecua nyecua beɨ uchɨ mbaaquiatu je ra. Dios rese que eriqui embiirandu randu ra. Dios rei ererecua tuchɨ. Ae rɨɨ̃ eriqui embiirandu randu. ");
INSERT INTO srqNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jesús oso nonde ibate que eriqui ñee ñee uchɨmbaaquiatu je ra. —¡Jẽsochɨ̃ nda sucha tubɨrɨã sɨ jẽ! ¡Jẽsochɨ̃ nda Jerusalén sɨ jẽ! ¡Paba cheẽ nguire jengu Espíritu Turã ndaarõ aa jẽ! “Espíritu Turã tamondo jẽje”, ɨ que Paba jẽje ra. Aque rɨɨ̃ ngue acheẽ jẽje nyii resẽ, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","—I je que Juan bautizar ɨ mbia je ra. Namo jiri ra Espíritu Turã ndu. Ae ra ɨque jeñɨangui re. Eɨ̃ nda Espíritu Turã bautizar ɨ jẽje. I je eã cote. Espíritu Turã nda ɨque chõ jeñɨangui re cote, ɨ que Jesús uchɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Emo mose que Jesús chɨmbaaquiatu ñee ee ra. Jesús oso nonde ibate. —¿Manose ra urererecua ɨshonda erembutiã ure sɨ re? Israel jenda rei ure. ¿Namo nda ure mo eremɨɨ urererecuarã nde? ɨ que mbia Jesús je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús que ñee ee ra. —Manose chõ ndae. Paba mɨɨ eɨcua. Mbia eɨcuayã. Jẽ nguia jẽɨcuayãte nguiã no. Manosete chõ ndae. ");
INSERT INTO srqNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","¡Co rese chõ jendua jẽ! Espíritu Turã nda tu jẽje cote. Ae ra jembuquirãcuã. Ae ra jembucheẽ ñee serɨɨ̃. Jẽ nda jẽɨngo serenei nenei tuchɨ cote. Serenei nenei Jerusalén jenda je. Judea jenda je abe no. Samaria jenda je abe no. Mbia mangue chooñoa jenda ja je abe no. Ũquɨ̃ ja je jẽɨngo serenei nenei, ɨ que Jesús ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ñeende que Jesús sɨ ibate cote ra. Uchɨmbaaquiatu resa rae que esɨ erecha ra. Ibeishĩ ngue embuchecuayã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Echɨmbaaquiatu que soboiba beɨ u mae ibei rese ra. Ibei rese mae mose que mbia nyeremo ngaẽ erea ra. Ibate sɨ. Huee que echɨ ra. Eɨraoshĩ tuchɨ que ngaẽ ejii ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ibatenda que ñee ee ra. —Galilea jenda, ¿mbaerã jengu beɨte mae ibei rese a re? Jesús oso quia ibate nae, ae sɨ ra tube no. Jemae ngue u eso rese nae, eɨ̃ sɨ ra u íbii no, ɨ que ibatenda ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jesús chɨmbaaquiatu que nyoɨ nyebi hue recha ra. Monte de los Olivos recha. Nyoɨ que sucha tubɨrɨã Jerusalén cote ra. Aichɨ jiri. Monte de los Olivos rei Jerusalén ndurubi. ");
INSERT INTO srqNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ngasẽ ngue Jerusalén nda. Nyoɨ que uchuchúaa cote ra. Ã ja que ra. Pedro. Juan. Jacobo. Andrés. Felipe. Tomás. Bartolomé. Mateo. Alfeo riirĩ. Jacobo, ɨ ee. Simón el Cananista. Judas. Jacobo riirĩ ndei Judas. ");
INSERT INTO srqNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ũquɨ̃ ja que ñumunua mbeɨ beɨ quia ñee ñee Dios je ra. Ari abe no. Acuanɨ abe no. María abe no. Jesús si rei María. Jesús nongue abe no. Ũquɨ̃ ja que ñumunua mbeɨ beɨ quia ñee ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Emo jiri mose que Jesús ɨcuasa ñumunua ja ra. Ciento veinte que ra. Pedro que uã ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Seandu rã se, Seresenda. ¡Sã embesa ji ñee ñooño eã ño jẽ! Cose que Espíritu Turã ñee Judas rɨɨ̃ nda. David que embesa Espíritu Turã ñee nguire ra. Judas rɨɨ̃. Judas rei Jesús reacuquiasa mbia ɨcuã je. Jesús rerao nonde ɨquia. ");
INSERT INTO srqNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jesús que Judas irabo rei nyii ra. Nanderesendacuã. Nyebe rei Judas nanderesenda nyii. ");
INSERT INTO srqNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas que mbae isiquia isi ɨcuã nda. Mbae isiquia je que ibi mo isi ra. Hue ereco mose que mano nda. Ibate sɨ eru ngoɨ mano. Uãquĩ nguiti que eru ngoɨ ra. Erie que oo ra. Echɨɨque mburiri. ");
INSERT INTO srqNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalén jenda que jirandu ja erese ra. Acéldama, ɨ que hue ibi je cote ra. Mbia ruqui rua, ɨ chõ nguiã hue je. Ecoɨsa ibi je. ");
INSERT INTO srqNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ɨ̃ ñɨ embesa ji Salmos nde: Sã echuchua oreã mbeɨ. Sã mbia mo ndiquíã mbeɨ equi re. Sã eriquicharomba riqui Dios cheẽ nenei nenei cote, ɨ que embesa ji Judas rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Emo nandeirabo Judas riquicharõ. Mbia chɨ beɨ quia nanderese nae. Jesús nandembaaquiatu quiatu beɨ mose. ");
INSERT INTO srqNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juan mbia mbiirandu randu mosenda beɨ. Dios Jesús querao chee quia ibate. Ae siqui beɨte quia nanderese nae, ũquɨ̃ mo nandeirabo nanderesendacuã. Jesús quera rese mbia mbiirandu randu sacuã, Judas riquicharõ, ɨ que Pedro ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mbia nyeremo ngue etea cote ra. José Justo, ɨ emo je. Barsabás, ɨ abe ee no. Matías, ɨ enongue je. ");
INSERT INTO srqNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jesús chɨmbaaquiatu que ñee Dios je cote ra. —Urererecua, aba chɨã ereɨcuate quia co. Ã nyeremo ndiqui ã. ¿Aba ndechiirabo re? ¿Aba ereirabo urembɨrõ sacuã nde? ");
INSERT INTO srqNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","¿Aba eretea ndechɨmbaaquiatubirã nde? ¿Aba eretea Judas riquicharõ nde? Ae huɨ quia ndecheẽ sɨ. Ae oso quiachã ndesɨ cote. ¿Aba eretea eriquicharõ nde? ɨ que Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Sɨta que embaba mbaba o ye cote ra. —¿Aba Dios chiirabo re? ɨ ñene. Eɨ̃ ngue Matías irabo ra. Dios que Matías mɨngo Jesús chɨmbaaquiatu rese cote ra. Mbia once mbɨrõ. Docerã. Doce que Jesús chɨmbaaquiatu cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Fiesta de Pentecostés mose que Jesús ɨcuasa chɨ ja ñumunua nda. Hue mɨɨ ngue echɨ ja ñumunua nda. ");
INSERT INTO srqNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ibei rieu que embuate ra. Ama ndieu raanguia. Tuchua mbieu tuchɨ Jesús ɨcuasa je. ");
INSERT INTO srqNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tata rendi raanguia que tu nguichi eãquĩ ndes e ra. Jesús ɨcuasa ãquĩ ja rese. ");
INSERT INTO srqNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Espíritu Turã ngue ɨque tuchɨ hue jenda chɨangui re ra. Ɨque ja que Jesús ɨcuasa chɨangui re ra. Mbia que echeẽ ata mo saã saã cote ra. Echeẽ uchɨanuã ngue esaã saã nda. Espíritu Turã nguia rei embucheẽ echeemo. Mbia cheẽ mbuae jaaja que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Aque mose que judíos tubɨrɨã nyɨ Jerusalén nda. Ɨshonda tubɨrɨã nyɨ huee. Mangue chooñoa jenda ja chõ chɨ nguiã huee. Ũquɨ̃ ndei Dios cheẽ mumbasa reã judíos ataque rã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ibei rieu andu mose que ũquɨ̃ ngaẽ uchã nda. Nyuruɨra tuchɨ eandu. Jesús resenda mbia cheẽ mbuae saã saã ja chõchɨ̃ nguiã u. Espíritu Turã ño ngue embucheẽ nguiã. Mbiamo ñee ɨcuasa reã ndaque. Mbia que ucheẽ ñandu ñandu ja u ra. Jesús ɨcuasa ñee mose. Nyebe que mbia chɨ nguiã nyuruɨra eandu. ");
INSERT INTO srqNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mbia nyuruɨra ja eandu. —¿Mañɨ equia mbiamo ñee ɨcua ja re? Galilea jenda achõ ño ndaque ã, ɨ tuchɨ que mbia u nyuruɨra eandu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","11","—¿Mañɨ equia nande ja cheẽ naa naa ã nde? Nandecheẽ Jesús ɨcuasa saã jaaja chõchɨ̃ nguiã ã. Partia jenda cheẽ esaã saã ñochɨ̃ nguiã ã. Media jenda cheẽ abe no. Elam jenda cheẽ abe no. Mesopotami a jenda cheẽ abe no. Judea jenda cheẽ abe no. Capadocia jenda cheẽ abe no. Ponto jenda cheẽ abe no. Asia jenda cheẽ abe no. Frigia jenda cheẽ abe no. Panfilia jenda cheẽ abe no. Egipto jenda cheẽ abe no. Libia jenda cheẽ abe no. (Cirene ndobeɨ.) Roma jenda cheẽ abe no. (Roma jenda mo ndei judíos. Roma jenda ataque rei judíos eã.) Creta jenda cheẽ abe no. Arabia jenda cheẽ abe no. Jesús ɨcuasa ũquɨ̃ ñee saã saã ja chõchɨ̃ nguiã ã. Nandecheẽ esaã saã ja chõchɨ̃ nguiã ã. Jesús ɨcuasa riquichɨ̃ nandecheẽ naa naa tuchɨ Dios chɨao turã nenei nenei ã, ɨ ja que mbia ucheẽ andu jaaja mose. ");
INSERT INTO srqNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɨ jate que mbia u nyuruɨra eandu ra. Ndua ndua tuchɨ que u eandu ra. —Mañɨ equia ñee ã nde, ɨ nyue. Jesús ɨcuasa mbia cheẽ mbuae naa naa mose. ");
INSERT INTO srqNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Emo emo ngue ñee ɨcuã ɨcuã Jesús ɨcuasa je ra. —Quiacua chõ eriqui nguiã ã, ɨ raque Jesús ɨcuasa rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pedro que uã ñee mbia je cote ra. Nguesenda once rese que echɨ uã ñee mbia je ra. Tasẽ jiri ñee ee. —¡Seandu ja u jẽ! Tacheẽ jẽje, Jerusalén jenda. Judea jenda abe no. ");
INSERT INTO srqNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","¿Quiacua reɨ̃ Jesús ɨcuasa riqui jẽje re? Quiacua eã ño ñene. Tenda que nyuɨ ramote resẽ. Mbia quiacuasa eã ño huee tenda resẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ã nɨɨ ngue Joel embesa mbesa cose ra. Dios cheẽ mbuchecuasa que embesa ã nɨɨ nda. Eɨ̃ ngue embesa ra: ");
INSERT INTO srqNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Mbae ua jiri mos e ra Espíritu Turã amondo mbia ja je”, ɨ que Dios ra. “Jendiirĩ nda secheẽ mbuchecua mbia je. Acuanɨndu ra serea rea tuchɨ cuu. Ameɨ abe ra serea rea cuu no. ");
INSERT INTO srqNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aque mose ra Espíritu Turã amondo serimba ja je. Serimba ra secheẽ mbuchecua checua mbia je. ");
INSERT INTO srqNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mbia mae sayã nda asaã saã ibi rɨ̃ no. Eruqui rese ra mbia mae no. Tata rese ra mbia mae no. Tatashĩ ndese ra mbia mae no. ");
INSERT INTO srqNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mbia rerecua tu nonde ra tenda ñɨmoo. Eruqui rã nda nyasi mbia rerecua tu nonde”, ɨ que Dios ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","“Ndeya eã ño serese, Sererecua”, ɨ mose emo ñee Dios je, aque ra Dios sirõ eɨcuã sɨ, ɨ que Joel embesa ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israel jenda, ¡seandu rã! Nazaret jenda rɨɨ̃ aɨco ñee ñee jẽje a. Jesús rɨɨ̃. Dios que Jesús mbuquirãcuã tuchɨ ra. Nyebe que Jesús mbia mae sayã saã saã nda. Ũquɨ̃ ndese que jemae nda. ");
INSERT INTO srqNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","“Mbia ɨcuã nda seriirĩ ɨquia”, ɨ que Dios Jesús mano nonde ra. Jẽ nguia Jesús jẽɨquia tuchɨ nguiã cote. Jẽ nguia jemee nguiã mbia ɨcuã je. Eɨquia nonde. Dios rane ngue jirandu Jesús rese ra. “Mbia ɨcuã nda Jesús ɨquia”, ɨ que Dios quia nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Dios que Jesús mbuquera sɨ ra. Jesús mano mbeɨ aroneãte. ");
INSERT INTO srqNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David que Jesús cheẽ senei cose ra. Ã ngue ñee nda: Sererecua riqui sembuɨ eã mbeɨ co. Eriqui beɨ serese co. Mbae riqui sembusiquiche aroneãte co. ");
INSERT INTO srqNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nyebe seya tuchɨte riqui co. Nyebe aɨco ñee turãte Dios rɨɨ̃ co. Semano mose abe ra Dios huɨ eã mbeɨ sesɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Seaingue ra eresechayã semano mose, Sererecua. Serete abe ra erembuquera sɨ mɨngo. Ndechesecuate aɨco co. ");
INSERT INTO srqNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Semɨngosa tuchɨ rei nde. Sereco mose nderese ra seya tuchɨ, ɨ que David Jesús cheẽ nenei cose ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tacheẽ nyecua jẽje, Seresenda. Nanderu David que mano cose resẽ. Mbia que echati resẽ. Eatisa nandeɨcua ja quia co resẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David rei Dios cheẽ mbuchecuasa. Dios que ñee ee ra. “Nderiirĩ mo nda Cristo. Ae ra mbia rerecuarã tuchɨ. Nderiquicharõ nda mbia rerecuabi tuchɨ”, ɨ que Dios David je cose ra. “Dios ñee ñooñoa tuchɨ chõ nguiã”, ɨ que David ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David que Dios cheẽ ɨcuate quia ra. Nyebe que ñee Jesús rɨɨ̃ nda. “Seaingue ra eresechayã semano mose. Serete ra erembuquera sɨ mɨngo”, nyebe David ɨ nguiã Jesús rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios que Jesús mbuquera sɨ ra. Ũquɨ̃ ureɨcua ja quia ã. Nyebe ureɨco nguiã jembiirandu randu ũquɨ̃ ndese ã. ");
INSERT INTO srqNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dios que Jesús querao ibate nyɨese ra. Dios jii eriqui pee cote. Dios que Espíritu Turã mee Jesús je cote ra. Ucheẽ nguire que emee ee ra. Jesús riqui Espíritu Turã mondo ure je co. Ã Espíritu Turã nyɨsaã jeñandu ñandu quia ã. Espíritu Turã ndiqui ã mbucheẽ mbia mo ñee ã. ");
INSERT INTO srqNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","David osoã ibate aque mose. Jesús rɨɨ̃ ngue David embesa ra. Ã ngue embesa ra: Dios que ñee sererecua je ra. “Ecoi sejii. Nde abe ra ererecua serese. Ae ndeucuayãte quia nae, ũquɨ̃ je ra ndequirãcuã ateacuquia tuchɨ. Ndequirãcuã tuchɨ ra ũquɨ̃ sɨ”, ɨ que Dios sererecua je ra, ɨ que David embesa mbesa ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Jesús jembucha quia ira rese nae, ae sɨ Dios mɨngo mbia rerecuarã co. Ae nandesaarõ arõ nguia, ae sɨ rei Jesús. Jesús rese tẽirandu ja, Israel jenda, ɨ que Pedro ñee ocote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mbia ia eã tuchɨte que Pedro cheẽ andu ra. Ñee ngue Pedro je ra. Pedro resenda je abe. —¿Mañɨ ure ra equia re? ɨ que Pedro je ra. Jesús chɨmbaaquiatu ja je. ");
INSERT INTO srqNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro que echeẽ sɨbɨshorõ nda. —¡Jẽɨcuã sɨ jẽhuɨ rã jẽ! Sã bautizar ure jẽje Jesucristo rɨɨ̃. Dios jẽɨcuã mbutiã sacuã. Aquere ra Dios Espíritu Turã mondo jẽje. ");
INSERT INTO srqNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","“Espíritu Turã nda amondo jẽje. Jendiirĩ je abe ra amondo. Ɨshonda je abe ra amondo. Sechiirabo ja je ra Espíritu Turã amondo”, ɨ que Dios ñee nande je ra, ɨ que Pedro Dios cheẽ nenei nda. ");
INSERT INTO srqNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Eɨ̃ ngue Pedro ñee ocote mbia je ra. Ñee turã ngue ee ra. —Mbia ɨcuã achõte eriqui ibi jenda ã. Quiachã ja equia Dios sɨ ã. Ũquɨ̃ sɨ jẽhuɨ chõ. Jẽ abe jẽquiachãyã sacuã Dios sɨ, ɨ que Pedro mbia mbaaquiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","—¡Ae beɨte jẽ! ɨ que mbia tubɨrɨã Pedro cheẽ andu ra. Ũquɨ̃ j e que bautizar ɨ ra. Aque mose que mbia tres mil Jesús isi ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ũquɨ̃ abe que ñumunua nua nguia Jesús quiato ataque rese ra. Jesús chɨmbaaquiatu ñee ñee mose mbia je. Ñumunua nua ñee Dios je. Eturã mbeɨ que eriqui nyue ra. Mbichae que eu eu quia ndua ndua Jesús rese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mbia que siquiche ja Dios sɨ ra. Jesús chɨmbaaquiatu que Dios mbuquirãcuã nda. Nyebe mbia mae sayã naa naa tuchɨ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jesús ɨcuasa que ñumunua nua mbeɨ quia ra. Abeɨ tuchɨ que eriqui nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Umbae je que eriqui vender ɨ tuchɨ ra. Mbae isiquia que emee mee nguia mbaecha reã je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ñumunua nua mbeɨ que equia Dios chuchúaa ra. Quiaru quiaru que equia nyɨese uchuchúaa ra. Dios rɨɨ̃ ngue eriqui ñee turã turã nyue ra. Eya tuchɨ que eriqui Dios rese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Dios rɨɨ̃ ngue eriqui ñee turã turã nda. Mbia ataque que ñee turã turã nguia Jesús ɨcuasa rɨɨ̃ nda. Jesús ɨcuasa que Dios mbeta mbeta beɨ quia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Emo mose que Pedro nyoɨ quia Dios chuchúaa ra. Juan ndese. Tenda nyeseco mose. Hue tenda beɨ que mbia riqui ñee ñee Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Huee que ameɨ mo ngatayã ndiqui beɨ huee ra. Echaacuquia mosenda beɨ eiquieĩ ɨcuã. Mbia que ecuruchoɨ choɨ beɨ quia huee ra. Dios chuchúaa. Eɨquesa turã, ɨ que hue eɨquesa je ra. Huee que eriqui ecuatayã mɨɨ mɨɨ mbeɨ eɨquesa jii ra. Ache ache ɨ sacuã mbia ɨque mose Dios chuchúaa. ");
INSERT INTO srqNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Dios chuchúaa nda Pedro ɨque nguiã Juan ndese chã. Ecuatayã ngue mae erese ache ache ɨ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro que nguesa mbuɨ reã mae erese ra. Juan abe. —¡Ure rese emae jẽ! ɨ ecuatayã je. ");
INSERT INTO srqNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Eandu mose que mae erese ra. —Mbae mo nda emee seje reae, ɨ mae nguiatu erese. ");
INSERT INTO srqNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro que ñee ee ra. —Mbae isiquia eã ndaque sembae. Mbae mo nda asaã ndeje. Jesucristo quirãcuã nembucherõ na mbucuata. Ehuã na ngata. Nazaret jenda quirãcuã nembucherõ na, ɨ que Pedro ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro que eo isi ra. Mua ngue eo rese ra. Aque mosebe que ei nyerõ nda. Eiquieĩ abe nyerõ eo isi ruɨbe. ");
INSERT INTO srqNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ecuatayã ngue juã asi cote ra. Ngata cuata que ra. Ɨque Dios chuchúaa ũquɨ̃ ndese. Eya tuchɨ que ra. Oo oo tuchɨ que ra. Ɨaanye, ɨ tuchɨ que equia Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mbia que mae ja u ecuatayã ngata rese ra. Ñee turã mose Dios je que mbia nyiisaquia u echeẽ ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mbia que nyuruɨra u mae erese ra. Mbia que eɨcua ja ra. —Ecuatayã ño aque re. Ache ache ɨ beɨte que equia Dios chuchúaa, ae chõ co re, ɨ que mbia nyuruɨra tuchɨ mae erese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Embucherõ ji que Pedro chiba isi isi quia ra. Juan chiba abe no. Mbia que ngaẽ ucha mae erese ra. Nyuruɨra erea. Portal de Salomón, ɨ eɨquesa je. Huee que echɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro que mae mbia chumunua ndese ra. Ñee ngue ee ra. —¿Mbaerã jẽɨngo nyuruɨrate mae erese re, Israel jenda? ¿Mbaerã jẽɨngo nyuruɨ rate mae urerese re? Ure ae eã ño Ecuatayã urembucherõ nguiã. Urequirãcuã eã Ecuatayã mbucuata nguiã. Dios quiarei uquiracuã mee ee embucherõ. Urecuata turã embucherõ eã nguiã. ");
INSERT INTO srqNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dios rei nanderu rerecua beɨ. Abraham. Isaac. Jacob. Ũquɨ̃ nderecua beɨ Dios. Dios ñee turã mbeɨ nguiirĩ nɨɨ. Jesús rɨɨ̃. Ae que jemee ɨcuã mbia je eɨquia sacuã nda. “Jesús tambuɨ”, ɨ mose Pilato, ũquɨ̃ mose que jẽisi quiatu quiatu chõchɨ̃ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","“Embuɨ”, jenye eã ñochɨ̃ ngue Jesús turã nɨɨ nde. “Embuɨ”, jenye chõchɨ̃ ngue mbia ɨquiasa rɨɨ̃ nde. ");
INSERT INTO srqNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Eɨ̃ jenye chõchɨ̃ ngue mbia mɨngosa ɨquia nguiã. Dios que embuquera sɨ ra. Equera sɨ rese que uremae nda. Ã ureɨco mbia mbiirandu randu equera rese ã. ");
INSERT INTO srqNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ã jengu mae Ecuatayã ndese ã. Jẽ Ecuatayã jẽɨcuate resẽ. Jendesa rae que Dios embucherõ nda. Ure Jesús ureɨcuate quia ã. Nyebe Ecuatayã mbuquirãcuã nguiã. ");
INSERT INTO srqNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Jẽaquiatuã ño Jesús jẽɨquia nguiã, Seresenda. Jenderecua aquiatuã ño Jesús ɨquia nguiã no. ");
INSERT INTO srqNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dios quia que ucheẽ mbuchecuasa mbucheẽ cose ra. Cristo rɨɨ̃ embucheẽ. “Mbia ɨcuã ɨcuã nda Cristo je. Cristo mbasi mbasi rae”, ɨ que embuchecuasa cose ra. Ũquɨ̃ ñee nguire quia Cristo mbasi mbasi nguiã cote. ");
INSERT INTO srqNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","¡Jẽɨcuã sɨ jẽhuɨ chõ jẽ! Jemba rã Dios ɨcha cuti. Dios jẽɨcuã mbutiã sacuã. Eɨ̃ jenye mose ra Dios jembiate cote. ");
INSERT INTO srqNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Dios ra Jesucristo mbuquichi ɨmbu cote. Ae que emɨɨ jenderecua rã cos e ra. ");
INSERT INTO srqNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Namo ño nda Jesús riquichõ ibate. Dios mbae mbitirõ ja mose ra eru cote. Eɨ̃ ngue Dios cheẽ mbuchecuasa ñiinda ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nyebe Moisés ñee nguiã nanderu cose ndare je. “Dios ra nanderesenda mo isi. Dios cheẽ mbuchecua sacuã. ¡Ae cheẽ nda jemumba jirichɨ̃ jẽ! ");
INSERT INTO srqNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Echeẽ mumbasa ra Dios mbuquiachã nyesɨ”, ɨ que Moisés ñee nda. ");
INSERT INTO srqNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Dios cheẽ mbuchecuasa ja que mbia mbiirandu randu mbae rɨɨ̃ nda. Ae riqui nyecua namo ã cote. Samuel nane ngue mbia mbiirandu randu ã nɨɨ nda. Samuel nduɨnda ja abe que embiirandu randu ã nɨɨ no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jẽje chõ Dios cheẽ mbuchecuasa ñee ñee nguiã. “Seturãte ra jendiirĩ ja je”, ɨ que Dios ñee nanderu ñiinda je ra. Jẽje abe Dios ñee. Ucheẽ nda embuchebi eã. Dios que ñee Abraham je cose ra. “Nderiirĩ mo nda mbia mbia ja tuchɨ quia. Ibi jenda ra embia ja tuchɨ”, ɨ que Dios Abraham je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dios que nguiirĩ mondo íbii cote ra. Jẽ nane je que embu ra. Jembuturã sacuã. Jẽhuɨ sacuã jẽɨcuã sɨ, ɨ que Pedro judíos je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sacerdotes que ngaẽ cote ra. Pedro ñee mbeɨ mose mbia je. Juan abe ñee mose ee. Dios chuchua raarõsa abe que tu erese huee ra. Saduceos mo abe que ngaẽ erese huee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ũquɨ̃ paama ɨ ja Pedro je. Juan abe je. Mbia mbaaquiatu quiatu mose chõ ngue paama ɨ ra. —Jesús que quera sɨ manonde ra. Eɨ̃ nda mbia abe quera sɨ, ɨ que Pedro ee nyii ra. Nyebe ũquɨ̃ ndiqui nguiã paama ɨ ee. ");
INSERT INTO srqNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nyebe eisi suruchoɨ nguiã policíaa. Eresaitõ ño emingue nguiã tarõ. —Isamamɨ nguia nda nandechandu nguiã, ɨ que ererecua nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mbia tubɨrɨã Dios cheẽ ñandu erenei nenei mose. Eatate que Jesús ɨcua ra. Jesús ɨcuasa rei cinco mil hombres. ");
INSERT INTO srqNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Isamamɨ ngue mbia tubɨrɨã ñumunua nda. Judíos rerecua que ngaẽ ñumunua huee ra. Ameɨ abe que ngaẽ ñumunua erese ra. Embesasa abe que ngaẽ ñumunua erese no nda. Ũquɨ̃ ja que ñumunua Jerusalén nda. ");
INSERT INTO srqNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anás abe que chɨ̃ erese ra. Ae rei sacerdote rerecua. Caifás abe que chɨ̃ erese ra. Juan abe no. Alejandro abe no. Sacerdotes nducucha ja que chɨ ñɨmbaacua ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pedro que emɨɨ mbia ite re ra. Juan ndese. Mbia ñee ee cote. —¿Aba jembirãcuã nde? ¿Aba jembirãcuã nguia ecuatayã mbucuata nonde re? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Espíritu Turã ngue Pedro mbucheẽ cote ra. —Tacheẽ jẽje, mbia rerecua. Tacheẽ jẽ abe je, Ameɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“Ecuatayã ndese urembiirandu rã”, jenye chõ nguiã ure je ã. “¿Aba jembirãcuã ecuatayã mbucherõ nonde re?” jenye chõ nguiã ure je ã. ");
INSERT INTO srqNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tacheẽ nyecua jẽje. Sã mbia ureandu ja. Sã Israel jenda ureandu ja. A ecuatayã embucherõ ji riqui jendesa rae a. Jesucristo quirãcuã nguiarei embucherõ. Aque sɨ́ quirãcuã ño ñene. Ae jẽɨquia. Ae jembucha ira rese. Ae Dios mbuquera sɨ. Aque quirãcuã ño ñene. Nazaret jenda quirãcuã. ");
INSERT INTO srqNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ɨ̃huaẽ nandechirirõ na ño Jesús re. Sañɨ nandeɨco mae mae ɨ̃huae nandechirirõ ndese no. “Aque chõ ndei que eturã nda”, sañɨ nandeɨco erirõ ɨ no. Eɨ̃ nyee ra mbia Jesús ndɨɨchã ɨ no. Mbia ra eisi tuchɨ nguerecuarã cote. Jesús momboi isi. Eisire rocoĩ nyii. ");
INSERT INTO srqNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Aba mo eã ndei nanderirõsa nandeɨcuã sɨ. Jesús ae nanderirõ nguiã nandeɨcuã sɨ. Dios aba mo abe mbu eã nguiã mbia rirõ sacuã huɨɨcuã sɨ. Jesús ae ñene, ɨ que Pedro ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mbia rerecua nyuruɨra Pedro cheẽ andu. —¿Mbaerã eriqui siquicheãte ñee nde? Papel ndesenda eã ndaque. Mbia ataque rã ño ndaque, ɨ que ererecua nyue ra. Pedro rɨɨ̃. Juan nɨɨ. —Jesús resenda quia eriqui reaẽ. Nyebe eriqui siquicheãte ñee nde, ɨ nyue cote. ");
INSERT INTO srqNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Hue que embucherõ ji riqui huee ra. Nyebe mbia rerecua ñee ɨcuã aroneate erɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ererecua ñee ja cote. —Sã Pedro choɨ usẽ taicuee. Juan abe no. Nandecheẽ nandechue nande ae, ɨ que ererecua nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Mañɨ nande ra Pedro je re? ¿Mañɨ nande ra Juan abe je re no? Pedro chɨmbucherõ ndese mbia riqui jirandu randu jate ã. Jerusalén jenda riqui jirandu randu jate ã no. “Mbucheroã ngue ra”, nande aroneate. ");
INSERT INTO srqNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nandembusiquiche rã no. Ñee ñee sɨã nda equia Jesús rɨɨ̃ ña. Mbia nda jiranua nguia mámbɨɨ chã. Jesús rese chã. “¡Jesús cheẽ nda jẽsenei senei sɨchɨ̃ jẽ!” nande rã ee, ɨ que ererecua nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","—Jenyu, ɨ Pedro je cote. Juan abe je. —¡Mbia ra jembaaquiatuchɨ̃ Jesús rɨɨ̃ jẽ! ¡Jesús ra jẽsenei seneichɨ̃ mbia mo je jẽ! ɨ rei que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedro que echeẽ sɨbɨshorõ nda. Juan ndese. —¿Aba cheẽ nguia ra aba mumbayã nguia re? ¿Jeñee nguiatu ra aba mumbayã nguia re? Dios cheẽ aba mumba aroneate. ¿Ɨ jẽje re? ");
INSERT INTO srqNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","¿Mañɨ nda aba umaesa reneiã nde? ¿Mañɨ nda aba uchɨandu abe reneiã ne no? ɨ que Pedro ee ra. Juan abe. ");
INSERT INTO srqNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ererecua ñee ɨcuã Pedro je. Juan abe je. —Nandembusiquiche nandechesɨ, ɨ raque. Huɨ chõ ngue esɨ cote ra. Embasiã mondo cote. Ererecua ɨreɨ̃te mbia tubɨrɨã sɨ. Nyebe eɨruã nuã eã nguiã. Pedro ecuatayã mbucherõ mose mbia ñee turã turã ño nguia Dios rɨɨ̃ neaẽ. Nyebe ererecua ɨreɨ̃te riqui nguiã esɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ae Dios mbucherõ nae, aque ameɨ. Cuarenta años que ae ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Mbia rerecua huɨ ja Pedro sɨ. Juan abe sɨ. Nyoɨ nguesenda mbiirandu ja mbia rerecua cheẽ ndese. Ameɨ ñee ndese. Sacerdotes cheẽ ndese. Nguesenda mbiirandu ja. ");
INSERT INTO srqNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Eresenda eandu mose que ñee ja Dios je ra. Ñee nyecha ee. —Dios, urererecua tuchɨ nde. Nde rei mbae aosa. Ibei aosa. Ibi aosa. Ama abe aosa no. ");
INSERT INTO srqNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sã David erembucheẽ nderimba cose no. Sã eɨ̃ erembucheẽ no: ¿Mbaerã ño mbia pare pare ɨ ja re? ¿Mbaerã mbia riqui ndua ndua chõoñote mbae mo ndese re? ");
INSERT INTO srqNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ibi jenda rerecua ja rei eɨcuã Dios je. Mbia rerecua ja ñumunua ɨcuã Dios je. Ñumunua ɨcuã ja eriirí abe je no. Cristo je, sã David ɨ cose no. ");
INSERT INTO srqNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Eɨ̃ sɨ tuchɨ mbia rerecua quia ñumunua ɨcuã Jesús je co. Nderiirĩ turã je co. Herodes. Poncio Pilato. Judíos. Judíos eã abe no. Ũquɨ̃ ja que siqui ɨcuã ɨcuã nguia Jesús je ra. Ndechiirabo raque Jesús. ");
INSERT INTO srqNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Eɨ̃ ere que ñee cose, eɨ̃ sɨ eɨcuã nguia ã namo. ");
INSERT INTO srqNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Echiisaquia echeẽ ɨcuã ndese, Urererecua. Nandembusiquiche, ɨ tuchɨ equia ure rɨɨ̃ ã. Urembusiquicheã na, Urererecua. Urembusiquicheã ndecheẽ nenei nenei sacuã. ");
INSERT INTO srqNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ndequirãcuã embu ure je. Mbia rasi mbucherõ cherõ sacuã. Mbia mae sayã naa naa sacuã. Jesús rɨɨ̃. Nderiirĩ turã nɨɨ, ɨ que Pedro resenda ñee nyecha Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ñeende Dios je que ibi nyere ee ra. Ñumunuásaa que ibi nyere mbia je ra. Espíritu Turã ngue ɨque tuchɨ echɨangui re ra. Esiquicheãte que mbia mbiirandu randu Dios cheẽ ndese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Hue rɨ̃ ja Jesús ɨcuasa ndua ndua checha. Eɨcuasa tubɨrɨã. Ndua ndua ja. —Sembae ae chõ co re, ɨ eã emo umbae je. —Nandembaerã ja chõ ã nde, ɨ umbae ja je nyue. ");
INSERT INTO srqNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jesús chɨ mbaaquiatu que mbia mbiirandu randu tuchɨ Jesús quera resera. Jesús que uquirãcuã mee mee nguia uchɨmbaaquiatu je ra. Dios que siqui tuchɨ erese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Mbae tiã eã ngue eriqui Jesús ɨcuasa mo je ra. Tuchuacha que vender ɨ jaaja uchuchua je ra. Ibicha abe que vender ɨ jaaja umbae ibi je no nda. Mbae isiquia que emee mee Jesús chɨmbaaquiatu je cote ra. Jesús chɨmbaaquiatu que emee mee mbaecha reã ja je cote ra. Nyebe mbae tiã eãte riqui nguiã emo je. Jesús quiato mo je. ");
INSERT INTO srqNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sã José no. Bernabé, ɨ Jesús chɨmbaaquiatu José je. Mbia mbiasa, ɨ chõ nguiã Bernabé ɨ. Ae rei Chipre jenda. Levita mo ngue ae ra. ");
INSERT INTO srqNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ae rei ibicha. Ibi umbae je que vender ɨ ra. Mbae isiquia que emee Jesús chɨmbaaquiatu je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ananías, ɨ que emo je ra. Safira, ɨ que eninisi je ra. Ũquɨ̃ ngue vender ɨ ibi mo je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","—Mbae isiquia ataque nandembuchɨmɨ nandembaerã, ɨ nyue. Eataque que emee Jesús chɨmbaaquiatu je cote ra. Eninisi abe que eɨcua ja ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro que ñee Ananías je ra. —¿Mbaerã Satanás ndiqui ɨque ndechɨangui re re? ¿Mbaerã erecheẽ ñooño Espíritu Turã je re? ¿Mbaerã ño mbae isiquia ataque erembuchɨmɨ nde? ¿Mbaerã ño ibi rɨbɨshoronda erembuchɨmɨ nde? ");
INSERT INTO srqNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Mbaerã ño ere? Ibi rei nembae vender ɨ nonde. Mbae isiquia abe rei nembae. Mbia je rocoɨ̃ erecheẽ ñooñochɨ̃ nde. Dios je chõ erecheẽ ñooño nguiã, ɨ que Pedro ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananías eandu mose que esɨ ngoɨ mano nda. Eandusa que siquiche ja ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Acuanɨndu mo ngue ngaẽ eraaque uma nda. Nguruchoɨ que nyati ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Emo mose jiri que mano je ninisi ru ra. Tres horas. Jiranuãte que ngu rese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro que ñee ee ra. —¿Manya rei ibi rɨbɨshoronda re? ¿Nderu ibi rɨbɨshoronda queru ja rei re? ɨ que Pedro ee ra. —Ae. Ũquɨ̃ ja chõ nyeresẽ, ɨchõɨño ngue eninisi Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro ñee ee cote. —¿Mbaerã ere? ¿Mbaerã jendua nduachɨ̃ ũquɨ̃ ndese re? Jeñee ñooñochɨ̃ nguiã Espíritu Turã je. Ae nderu curuchoɨ nyati nae, ũquɨ̃ nyɨ nderaarõ arõ a. Eɨquesa ji a. A ecuaẽ ndererao sacuã a, ɨ que Pedro ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pedro cheẽ mose tuchɨ que esɨ ngoɨ mano nda. Ngu rã sɨ. Pedro resa rae mano. Acuanɨndu que ɨque ja eraaque rea ra. Nguruchoɨ que nyati ra. Eru atiquia jii que eruruchoɨ nyati ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jesús ɨcuasa que siquiche jate ra. Eandusa abe que siquiche jate no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jesús chɨmbaaquiatu que Dios quirãcuã teacuquia cuquia mbia je ra. Mbia mae sayã ngue esaã saã nguia mbia je ra. Milagros, ɨ que ũquɨ̃ je ra. Jesús ɨcuasa que ñumunua nua ja quia eɨquésaa ra. Portal de Salomón, ɨ que eɨquesa je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jesús ɨcuasa rɨɨ̃ ngue mbia ñee turã ja quia ra. Mbia ataque que siquichete ra. Nyebe ñumunua eã nguiã erese. ");
INSERT INTO srqNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jesús ɨcuasa tubɨrɨãt e que cote ra. Hombres tubɨrɨã. Mujeres abe tubɨrɨã no. ");
INSERT INTO srqNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Erasi abe que mbia curuchoɨ choɨ quia ñeenda jie ra. Huee que eriqui eno eno ngua ye ra. —Sã Pedro aĩ ño ubi ubi erasi rese, ɨ que mbia ñee Pedro ucua mose ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalén ndurubinda abe que ngaẽ ngaẽ nguia ra. Erasi rurucuaẽ cuaẽ Jerusalén. Aba checuayã nyɨreco abe que ecurucuaẽ cuaẽ nguia ra. Dios que embucherõ cherõ ja quia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Sacerdote rerecua que paama ɨ ra. Saduceos mo abe que chɨ erese ra. Ũquɨ̃ abe que paama ɨ no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nyebe que Jesús chɨmbaaquiatu isi ɨcuã nda. Tarõ ngue policíaa ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Isa que ibatenda mo nguichi ee ra. Angel. Etaronda que embuquiata ra. Jesús chɨmbaaquiatu que equerao itaicuee ra. Ñee nonde ee. ");
INSERT INTO srqNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Dios chuchúaa jẽso. Mbia je mbiirandu randu tuchɨ Dios cheẽ ndese. Dios cheẽ ndei aba mɨngosa. Aque rese mbia jembiirandu randu, ɨ que ibatenda Pedro je ra. Juan abe je. ");
INSERT INTO srqNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jesús chɨmbaaquiatu eandu mose que echoɨ Dios chuchúaa ra. Mbia mbaaquiatu quiatu que echoɨ ra. Isamamɨmbe cote. Isamamɨmbe echoɨ mbia mbaaquiatu. Sacerdote rerecua que “jenyu” ɨ mbia rerecua ja je ra. Sacerdote resenda abe. Ameɨ je abe ñee. Ñumunua ja u nyɨese. Ñee ngue policía raarõsa je cote ra. —Jẽso policíaa. Jesús chɨmbaaquiatu jendu rã ure je, ɨ rei que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ecuasẽ mose policíaa que Jesús chɨmbaaquiatu oreã ño ee ra. Ae nyebi chõ ecuaẽ nguiã sacerdote rerecua mbiirandu. Ñee ee. ");
INSERT INTO srqNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Puerta ãtã ngue chɨ̃ ndei nguiã ure je. Soldados ngue chɨ rei nguiã itaicuee. Eraarõ ndaque. Ureequia rei ngue re. Eoreã ngue ra. Jesús chɨmbaaquiatu oreãte que ure je ra, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sacerdote rerecua que nyuruɨra eandu ra. Dios chuchua raarõsa abe nyuruɨra eandu. —¿Mañɨ mañɨte equia re? ɨ que u ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Emo ngue tu ñee ee cote ra. —Huee que jenyɨtarõ nyɨ Dios chuchúaa ra. Mbia mbaaquiatu quiatu, ɨ que embiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Eandu mose que Dios chuchua raarõsa nyoɨ erea ra. Nguesenda rese echoɨ erea. Curucuaẽ ja nguerecua je. Curucuaẽ turã. —Mbia tubirɨã nda sɨta mombo mombochɨ̃ nande je, ɨ ñene. Nyebe eɨcuã eã ee. ");
INSERT INTO srqNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Jesús chɨmbaaquiatu que ecurucuaẽ mbia rerecua je ra. Sacerdote rerecua que ñee ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—“¡Mbia ra jembiirandu randuchɨ̃ Jesús rese jẽ!” ure rei que jẽje. Urecheẽ jemumba chõchɨ̃. Jerusalén jenda ja jembiirandu randu chõchɨ̃ nguiã. “Jesús ɨquiasa chõ ũquɨ̃ nde”, ¡jenyechɨ̃ nda ure rɨɨ̃ jẽ! ɨ que sacerdote rerecua Jesús chɨmbaaquiatu je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro que echeẽ sɨbɨshorõ nda. Nguesenda rese echeẽ ndɨbɨshorõ. —Dios cheẽ nguia aba mumba aroneate nguiã. Mbia cheẽ nguia nda aba mumba jiri nguiã ña. ");
INSERT INTO srqNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jẽ nguia Jesús jembucha nguiã ira rese. Eɨquia sacuã. Dios que embuquera sɨ ra. Nanderu rerecua que embuquera sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios que nguiirĩ mɨngo mbia rerecuarã tuchɨ cote ra. Ujii beɨ que emɨngo ra. Mbia rerecuarã. Mbia rirõ sacuã eɨcuã sɨ. Israel jenda mbuɨ sacuã huɨɨcuã sɨ. Dios eɨcuã mbutiã sacuã esɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ũquɨ̃ ndese que uremae ja ra. Nyebe ureɨco nguiã mbia mbiirandu randu ã. Espíritu Turã abe mae ja erese. Nyebe a e abe riqui nguiã mbia mbiirandu randu co. Dios quia Espíritu Turã mee mee nguiã ucheẽ mumbasa reã je, ɨ que Pedro ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ererecua que paama ɨ ja Pedro cheẽ mose ra. Nyebe eriqui nguiã eɨquia ja serɨ̃te. ");
INSERT INTO srqNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Fariseo mo abe que chɨ̃ erese ra. Gamaliel, ɨ que ee ra. Ae abe que ererecua ra. Mbia chɨɨcua jat e que ae ra. Mbia mbaaquiatu quiatusa que ae ra. Dios cheẽ nenei neneisa que ae ra. Ae que juã ñee nda. —Jesús chɨmbaaquiatu jemondo mbiirĩ conosẽ itaicuee, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ñee ngue ererecua uataque je cote ra. —Tacheẽ jẽje, Israel jenda. ¡Jendua tuchɨ jẽ! ¡Jẽocochɨ̃ nda Jesús chɨmbaaquiatu rese jẽ! ");
INSERT INTO srqNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","¿Teudas sɨ jẽtesareɨ re? ¿Jendua eãte quia erese re? Teudas quiatu ucuasu saã saã nguia resẽ. Erimbarã tubɨrɨãte chee. Cuatro cientos chee erimba. Mbia Teudas ɨquia chee. Teudas mano nyee. Erimba que saseɨ̃ saseɨ̃ ja chee. Erimba que ua ja ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Aquere que Judas abe riqui ra. Galilea jenda. Censo mose. Mbia que siqui jate eruɨ no nda. Erimbarã. Ae abe que mano cote ra. Erimba abe que saseɨ̃ saseɨ̃ nda. Erimba que ua ja no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nyebe ã jẽteachõ. Jesús chɨmbaaquiatu jẽteachõ. Sã ae ae quia ua, Dios siquiã mose erese. ");
INSERT INTO srqNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Dios quirãcuã siqui mose erese ra nandesiquisã aronea. ¿Mañɨ nande ra eriquisã nde? ¡Jesús rimba nandeteachõ ño jẽ! Dios quirãcuã nguia siqui rei erese. Dios je ra nandeɨcuã abareãte, ɨ que Gamaliel ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliel cheẽ nduɨ sɨ chõ ngue ererecua siqui ja nguiã cote. —Jenyu, ɨ nguiã Jesús chɨmbaaquiatu je cote. Iruã nua cote. —¡Mbia je ra Jesús cheẽ jẽsenei senei sɨchɨ̃ core jẽ! ɨ rei que ee ra. Ererecua que huɨ esɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jesús chɨmbaaquiatu que nyoɨ mbia rerecua recha cote ra. Eyate que nyoɨ ra. —Jesús rɨɨ̃ ño ureɨruã nua nguiã, ɨ que ra. Eya tuchɨ chõ ngue ra. ");
INSERT INTO srqNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mbia que embaaquiatu quiatu beɨ ra. Jesucristo rɨɨ̃ mbia mbiirandu randu beɨ. Mbia chuchua que embuchesea sea quia mbia mbiirandu randu Jesús rɨɨ̃ nda. Dios chuchúaa abe mbia mbiirandu randu. ");
INSERT INTO srqNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jesús quiato tubɨrɨãte que cote ra. Ae griego cheẽ saã nguia, ũquɨ̃ ngue paama ɨ ra. Ae judío cheẽ saã nguia, ũquɨ̃ je que paama ɨ ra. Jesús quiato ja raque. —Ureresenda eru cheecha ja ngue jembuquiaru ɨcuã ɨcuã ñochɨ̃ nguiã, ɨ que griegos judíos je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nyebe Jesús quiato rerecua mbia munua nguiã. Jesús quiato munua ja. Ñee sacuã ee. —Ã ureɨco Dios cheẽ nenei nenei mbeɨ mbia je ã. Urehuɨ aronea tuchɨ quiarei Dios cheẽ sɨ. Mbia urembuquiaru quiaru aroneate. Dios cheẽ nenei nenei ndocoɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nyebe Jesús quiato siete chõ jẽirabo. Mbia mbuquiaru sacuã. Mbia chɨɨcua siete chõ jẽirabo. Hombres aracua chõ jẽirabo. Espíritu Turã ndesenda tuchɨ chõ jẽirabo. Sã ũquɨ̃ ño mbia mbuquiaru quiaru quia. ");
INSERT INTO srqNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ure quiatu ra urecheẽ mbeɨ quia Dios je. Ure quiatu ra Dios cheẽ uresenei senei mbeɨ quia mbia je, ɨ que Jesús quiato rerecua ra. ");
INSERT INTO srqNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","—Coche ñene, ɨ jat e que Jesús quiato ra. Nyebe que siete irabo ra. Esteban irabo. Ae rei Jesús quiato tuchɨ. Ae rei Espíritu Turã ndesenda tuchɨ. Felipe. Prócoro. Nicanor. Timón. Parmenas. Nocolás. Ũquɨ̃ ja que eirabo ra. Nicolás ndei Antioquía jenda. Judío eã ngue ae ra. ");
INSERT INTO srqNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Curuchoɨ ja que Jesús quiato rerecua je ra. Jesús quiato rerecua que o chono ñono ja ũquɨ̃ ãquĩ arõ nda. Ũquɨ̃ siete ãquĩ arõ. Ñee ngue Dios je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mbia tubɨrɨã ngue Dios cheẽ isi isi quia ra. Jesús quiato tubɨrɨã tuchɨ que mbia Jerusalén jenda cote ra. Sacerdote tubɨrɨãte abe que Jesús quiato cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Dios que siqui tuchɨ Esteban ndese ra. Dios quirãcuã ngue siqui tuchɨ erese ra. Nyebe eriqui nguiã mbia mae sayã naa naa tuchɨ mbia je. ");
INSERT INTO srqNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mbia emo emo ngue paama ɨ Esteban je cote ra. Esclavos Libertados, ɨ que mbia chumunuasa mo je ra. Hue jenda que paama ɨ ee ra. Cirene jenda abe no. Alejandría jenda abe no. Cilicia jenda abe no. Asia jenda abe no. Ũquɨ̃ jate que paama ɨ Esteban je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ũquɨ̃ ngue Esteban ñee sobeɨshɨ̃ aroneate quia ra. Espíritu Turã nguia Esteban mbaaracuate nguiã. Espíritu Turã nguia Esteban mbuch eẽ aquiatute nguiã. Nyebe ũquɨ̃ ndiqui Esteban ñee ndɨbɨshorõ aroneate. ");
INSERT INTO srqNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Paama ɨsa que mbae isiquia mee mbia mo je ra. Ñee ñooño nonde Esteban nɨɨ. —Esteban ngue ñee ɨcuãte Moisés rɨɨ̃ nda. Esteban ngue ñee ɨcuãte Dios rɨɨ̃ no nda, ɨchõɨño nonde Esteban nɨɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ñee ñooño je que mbia mbɨɨcuãte Esteban je ra. Ameɨ abe mbɨɨcuãte Esteban je no. Embesasa abe mbɨɨcuãte Esteban je no. Nyebe mbia Esteban isi suruchoɨ nguiã ererecua je. ");
INSERT INTO srqNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ñee ñooño je que ñee ɨcuã sɨ Esteban nɨɨ huee no nda. —¡Esteban ngue ñee ɨcuã ɨcuãte quia Dios chuchua rɨɨ̃ nda jẽ! ¡Dios cheẽ nɨɨ abe que Esteban ndiqui ñee ɨcuã ɨcuãte ra jẽ! ɨchõɨño Esteban nɨɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","—¡Esteban ñee ngue urechandu ra jẽ! “Jesús ra Dios chuchua mbucoɨ. Moisés cheẽ nda Jesús mbutiã”, ¡ɨ que Esteban nda jẽ! ɨque ñee ñooño ererecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Mbia que mae ja u Esteban ndese cote ra. Ererecua abe que mae ja u erese ra. Ibatenda nduba rã tuchɨ quiarei Esteban. Eruba nininya tuchɨ quiarei ũquɨ̃ mose. ");
INSERT INTO srqNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sacerdote rerecua que ñee Esteban je cote ra. —¿Mbia ñee ñooño nguia nderɨɨ̃ nde? ɨ Esteban je. ");
INSERT INTO srqNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban ngue ñee oco ee cote ra. —Tacheẽ jẽje, Seresenda. Tacheẽ jẽje, Ameɨ. Dios Turã ngue nyecua u nanderu Abraham je ra. Abraham siqui mose Mesopotamia. Oso nonde Harán. ");
INSERT INTO srqNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dios que ñee Abraham je ra. “Ibi mo nguia eso. Nderecua esecha. Nderesenda abe esecha ja. Ibi mo tateacuquia ndeje. Huee eso rã. Huee quia tereɨco”, ɨ que Dios ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abraham ngue oso nguecua recha ja ra. Ibi Caldea recha ja. Oso ibi mo. Harán, ɨ que hue ibi je ra. Emo mose que eru mano ee ra. Aquere que Dios Abraham ndurucuaẽ aa ra. A nandeɨco a. Aa que erurucuaẽ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dios que ibi mo mee eã Abraham je ra. Ibi boque ñetẽ mo mee eã tuchɨ ee. “Ibi tamondo nderiirĩ mbaerã. Ndetiã mose ra amee nderiirĩ je”, ɨ que Dios ee ra. Abraham nguiirĩ ndea eã mose qu e Dios ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Nderiirĩ nda siqui ja rei mbiamo ndese. Ndetiámbaa. Mbiamo ndécuaa ra eriqui beɨ. Mbia ɨcuã tuchɨ ra eriqui nderiirĩ je. Mbia rimbarã nda nderiirĩ. Cuatro cientos años nda eriqui mbia rimbarã”, ɨ que Dios Abraham je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","“Nderiirĩ mbuquieɨ quieɨsa ra ambasi mbasi. Ũquɨ̃ mos e ra nderiirĩ cuaẽ usẽ aa. Aa ra ñee ñee turã seje aa cote”, ɨ que Dios ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios que ñee Abraham je ra. Abraham ngue Dios cheẽ ñanduchõ eã nda. Nyebe Dios circuncisión ndeacuquia Abraham je cote. Erãcoɨ̃ ɨre ai o ji je chõ eriqui nguiã circuncisión, ɨ ũquɨ̃ je. Dios cheẽ sɨ embutesareɨã sacuã ndei circuncisión. Nyebe Abraham circuncisión saã nguiirĩ je. Eɨtãquieɨ̃ mose. Ocho días mose. Isaac, ɨ que eriirĩ je ra. Isaac cuasu mose que ae abenguiirĩ tea ra. Jacob, ɨ que eriirĩ je ra. Isaac abe que circuncisión saã nguiirĩ je no nda. Embutesareɨã sacuã Dios cheẽ sɨ. Jacob abe que nguiirĩ tea ecuasu mose ra. Ae abe que circuncisión saã nguiirĩ je no nda. Doce eriirĩ. Ũquɨ̃ ndei nandei cose. ");
INSERT INTO srqNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","José, ɨ que Jacob riirĩ mo je ra. José nongue que paama ɨ ja José je ra. Nyebe José mee nguiã mbia rimbarã cote. Mbia que José isi suruchoɨ Egíptoo ra. Huee ab e que Dios riqui tuchɨ José rese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Mbia ɨcuã mose José je, huee que Dios riqui eraarõ tuchɨ ra. José ia eã eãte que eriqui ra. Dios embaaracua tuchɨ. Nyebe mbia rerecua turãte riqui nguiã ee. Faraón, ɨ Egipto jenda rerecua je. Ererecuabi tuchɨ que José riqui ra. Nyebe emɨngo nguiã ererecuarã. Egipto jenda rerecuarã. Nyebe emɨngo nguiã uchuchua jenda rerecuarã. ");
INSERT INTO srqNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Emo mose jiri que mbae tiã mbia je ra. Mbia chɨurã tiã ngue Egíptoo ra. Canaán abe mbia chɨurã tiã. Nandei riãcuã ja que eriqui cose ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Quiata a mbuae que Egíptoo ra. Jacob jirandu mose que nguiirĩ mondochoɨ erea ra. “Nandechɨurã mo jẽisi rã oso”, ɨ que emondochoɨ Egíptoo ra. Aque ramo tuchɨ que eriirĩ nyoɨ Egíptoo ra. Jacob ndiirĩ ndei nandei ja. ");
INSERT INTO srqNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Aquere que echoɨ sɨ uchɨurã ndea ra. Aque mose chõ ngue José nyecua nguiã ngõngue je cote ra. Nyeb e Faraón José nongue ɨcua nguiã cote. ");
INSERT INTO srqNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","José que ngõngue mondochoɨ ngu rea cote ra. Jacob, ɨ que eru je ra. “Nanderu jendu rã. Jeninisi abe jendu rã. Jendiirĩ abe jendu rã”, ɨ que José ee ra. Curucuaẽ ja que ra. Setenta y cinco que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Eɨ̃ ngue Jacob oso siri Egíptoo ra. Huee que eriqui beɨ ra. Mano nyee. Nandei ja abe que chɨ beɨ huee ra. Mano nyee. ");
INSERT INTO srqNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Emo mose que mbia Jacob quiangue ruruchoɨ Siquem nda. Ibicua rie que eno huee ra. Ae Abraham isi ibi nyii, huee que equiangue no nda. Huee que nandei quiangue no nda. Ae ibi Abraham isi quia Hanor ndiirĩ sɨ nae, huee que equiangue no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Cuatro cientos años nda nderiirĩ nyɨ beɨ Egíptoo. Aquere Ibi Canaán tamee ee”, ɨ quia Dios Abraham je nyii reaẽ. Cuatro cientos años ua jiri mose que nandei tubɨrɨãte cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","19","Aque mose que emo Egipto jenda rerecua rã cote ra. Ae que jiranuã José rese ra. Nyebe ngue eriqui nguiã nandei mbɨɨrɨ̃ ɨrɨ̃. Eɨcuã tuchɨ que eriqui nandei je ra. “Jendiirĩ ɨtãquieɨ̃ jẽsecha chõ. Sã ae ae mano ja”, ɨ que ererecua nandei je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Aque mose que Moisés nyaacuquia ra. Diosbi tuchɨ que Moisés ra. Nyaacuquia ramo mose. Tres nyasi que esi embutiarõ nyecuayã nda. Mbia rerecua sɨ. Eru abe siqui embutiarõ nyecuayã. Eɨtãquieɨ̃ mose. ");
INSERT INTO srqNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nguereco checuayã aroneate chee que ra. Nyebe ererecua riirĩ ngasẽ nguiã ee. Isi turã ngue ra. Mbutiarõ ngue nguiirina nda. Nyucuaaque que ererecua riirĩ nda. Ae que Moisés ɨtãquieɨ̃ mbutiarõ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nyebe Moisés mbaaquiatu tuchɨ nguiã Egipto jenda rã sɨ. Earacua tuchɨ que ecuasu mose cote ra. Ɨ tuchɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moisés que ndua tuchɨ uataque rese cote ra. “Taso rã israelitas rea”, ɨ que cuarenta años mose cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Oso que cote ra. Egipto jenda mo ɨcuã ɨcuã mose israelita mo je que Moisés sɨ ngasẽ nda. Moisés que esiquisã nda. Ɨquia que ra. Egipto jenda ɨquia que ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés que ñee uchɨangui re ra. “Sere senda ra seisi turã. Seɨcuate rae. ‘Dios chɨmbu chõ tu nguiã co. Urerirõ sacuã a sɨ’, ɨ ra seresenda serɨɨ̃”, ɨ rei ngue Moisés uchɨangui re re. Eresenda que eisiã ñochɨ̃ nguiã. ");
INSERT INTO srqNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Isamamɨ nongue que israelitas mo ɨcuã ɨcuã nyue ra. “Tacheẽ turã ee. Ɨ̃ nda eturã sɨ nyue”, ɨ rei que Moisés ra. “¿Mbaerã jẽɨcuã ɨcuã ndiqui jenyue re? Nande ja chõ nyeresẽ”, ɨ que Moisés ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ae rane eɨcuã ɨcuã ndiqui nyue nae, aque que ñee ɨcuã Moisés je ra. Moisés maña mondo. “¿Aba nemɨngo ererecuarã nde? Urereachõ ño ae”, ɨ que ñee ɨcuã Moisés je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","“Ae ereɨquia curɨ, ¿aque rã sɨ ra seɨquia re?” ɨ que ñee ɨcuã Moisés je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ã andu mose que Moisés sɨ uchã nda. Ibimo. Madián, ɨ que ibimo je ra. Huee que eriqui arete ra. Nguiirĩ nyeremo ngue etea huee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Huee que eriqui arete ra. Cuarenta años. Emo mose que esɨ turuquia rɨ̃ nda. Ibi ibate jii que eriqui ra. Sinaí, ɨ que hue je ra. Huee que ira ruri riqui sendi ee ra. Tata rendi mbɨrõ ngue ibatenda mo nyecua ee ra. Angel que nyecua Moisés je ra. Ira ruri rendi ite re que nyecua ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés que nyuruɨra tuchɨ erea ra. Erurubi que mae tuchɨ erese cote ra. Dios que ñee ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Dios chõ se re. Ndei rerecua chõ se re. Abraham nderecua. Isaac abe rerecua no. Jacob abe rerecua no. Ũquɨ̃ nderecua ja chõ se re”, ɨ que Dios ra. Moisés que titi titi ɨ ra. Siquichete que mae ndocoɨ̃ erese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dios que ñeembe ee ra. “Ndeiyao esirõ na. Seturã ño se re. Sésaa ndeiyao esirõ. ");
INSERT INTO srqNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Serimba rese aɨco mae mae mbeɨte Egíptoo co. Mbia ɨcuã tuchɨte ee. Mbia embasi mbasi beɨte. Amae mae mbeɨte que erese ra. Echeseo seo rese que aɨco mae mbeɨ ra. A achu erirõ sacuã a. Tasirõ eɨcuã sɨ cote. Eso Egíptoo. Taremondo Egipto cote”, ɨ que Dios Moisés je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Dios que Moisés mɨngo mbia rerecuarã cote ra. Mbia rirõ sacuã Egipto sɨ. Mbae ɨcuã sɨ. Mbia que Moisés isi sereã nea nyii ra. “¿Aba nemɨngo urererecuarã nde?” ɨ que mbia Moisé je nyii ra. Ũquɨ̃ sɨ́ je que Dios Moisés mondo sɨ ra. Ererecuarã. Dios que tata rendi ite renda mbucheẽ Moisés je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés que mbia mae sayã saã saã nguia nandei je ra. Mbia mae sayã tubɨrɨãte que esaã saã nguia ra. Moisés que mbia curuchoɨ Egipto sɨ cote ra. Curuchoɨ que Ama Ɨreɨ̃ ndasa ra. Moisés que mbia quereco beɨ turuquia ruɨ ra. Cuarenta años. Mbia mae sayã tubɨ rɨãte que esaã saã nguia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ameɨ mose que Moisés ñee mbia je ra. “Dios ra jemo irabo ucheẽ mbuchecua sacuã jẽje. Seraanguia sɨ ra eirabo. ¡Aque cheẽ nda jemumbachɨ̃ jẽ!” ɨ que Moisés israelitas je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisés beɨ chõ ngue ererecua ra. Moisés beɨ chõ ngue nandei quereco quia turuquia rɨ̃ ndesẽ. Ae je chõ ngue ángel ñee ndesẽ. Mbia chumunua mose Ibi Ibate Sinaí. Ibatenda mo ngue ñee ñee u Moisés je ra. Moisés que ñee ñee nandei je cote ra. Ibatenda cheẽ mbuchecua ee. Mbia mɨngosa cheẽ nenei nenei mbia je. Nandei je. ");
INSERT INTO srqNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Nandei que Moisés cheẽ ñandu sereãte quia ra. Echeẽ mumba mumba. “Nyaso rei nyebi Egipto ae”, ɨ que equia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nandei que ñee ñee Aarón je ra. Moisés cutiã ngue ñee ñee ee ra. “Mbae raanguia mo esaã jiri ure je ae. Imagen. Urererecuarã. Ae je nda ureɨco ñee ñee jiri chã. Ae nda urererao Egíptoo chã. Moisés tiãte ure je cote. Ae urereru Egipto sɨ. Maranguiti chõ esɨ urerecha”, ɨ que mbia Aarón je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nyebe que Aarón ticuasu raanguia raã ee ra. Imagen. Nandei que mbae ɨquia ɨquia ticuasu raanguia je ra. Eroo que emɨɨ ticuasu raanguia jii ra. Mendi que ee cote ra. Mbia ia tuchɨ que uchɨao rese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ũquɨ̃ ɨcuã tuchɨ que Dios je ra. Nyebe Dios huɨ nguiã nandei sɨ cote. Nandererecua, ɨ chõchɨ̃ mbia tenda je cote. Nyasi je abe no. Nyasi tata je abe no. Ũquɨ̃ je chõ mbia riquichɨ̃ ñee ñee. Ũquɨ̃ mose que Dios ucheẽ mbu cote ra. Dios cheẽ mbuchecuasa que Dios cheẽ senei senei mbia je ra. Co rei embesa ji co: Israelitas, ¿aba je jẽɨngo mbae roo mendi mendi cose re? Jẽɨngo mose turuquia cuarenta años mose. ¿Seje chõ jẽɨngo mbae roo mendi mendi cose re? ");
INSERT INTO srqNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tei. Seje eã ñene. Jenyɨao je chõ jẽɨngo mbae roo mendi resẽ. Tuchua ñetẽ jendaso raso beɨ chõchɨ̃. Mbae aingue raanguia resebe. Moloc, ɨ ee. Aque je chõ jẽɨngochɨ̃ nguiã ñee ñee. Seje ñee ñee ndocoɨ̃. Nyasi tata je abe jẽɨngochɨ̃ nguiã ñee ñee. Nyasi tata rei Refán mbae. Mbae raanguia jenyɨao je abete que jẽɨngo ñee ñee nda. Nyebe ra jaemondo jembae ibi sɨ. Babilonia ndobeɨ ra jaemondo. Mbia rimbarã nda jaemondo, ɨ que Dios nandei je cose ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Nandei que chɨ arete turúquiaa ra. Aque mos e que nandei riqui tuchua rurucuata beɨ cose ra. Mbae ɨre que tuchuarã cose ra. Aque tuchuaqui re que mbia riqui ndua ndua Dios rese ra. Dios que tuchua nyao uquia Moisés je ra. “¡Eɨ̃ ere chõ eao jẽ!” ɨ que Dios Moisés je ra. Dios cheẽ nduɨ sɨ tuchɨ que Moisés eao ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Moisés manonde que Josué nandei rerecua cote ra. Ae que nandei curuchoɨ turuquia sɨ cote ra. Ngasẽ nonde ibi mo je. Dios chɨmee, hue ibi je que ngasẽ cote ra. Nandei que guerra saã saã hue jenda je ra. Dios que mbia mombo ja hue jenda ra. Aque mose que nandei riqui tuchua ruruchoɨ beɨ ra. Tuchua, ɨ chõ nguiã mbae ɨre ao ji je. Aque tuchua que equereco beɨ quia ra. David abe mbia rerecua mose. ");
INSERT INTO srqNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios que siqui tuchɨ David rese ra. David que ñee ee ra. “Tuchua cuasu tasaã ndeje”, ɨ rei ngue David Dios je re. Jacob nderecua rei Dios. ");
INSERT INTO srqNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","David ndiirĩ nguiatu que tuchua saã Dios je ra. Salomón, ɨ que eriirĩ je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mbia rã eã ndei Dios. Dios siquíã tuchɨ chõ nguiã tuchuaqui re. Mbia chɨaoqui re. Dios cheẽ mbuchecuasa que Dios cheẽ saã nda: ");
INSERT INTO srqNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Se quia ererecua tuchɨ re. Ibatenda rerecua abe rei se. Ibi jenda rerecua abe rei se no. ¿Mañɨ nda mbia sechuchuarã ao re? Equi re ra aɨcoã ndesẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Se quiatu que mbae achao ja resẽ, ɨ que Dios nandei je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jeñɨa ɨcuã ñochɨ̃. Jẽisayã ñochɨ̃. Espíritu Turã jẽisiteã teã ñochɨ̃. Jendu rã sɨ chõ Espíritu Turã jẽisiteã teã ñochɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Jendu ɨcuã beɨ que eriqui Dios cheẽ mbuchecuasa ja je ra. Jendu que Dios cheẽ mbuchecuasa ɨquia ɨquia beɨ quia ra. Ibatenda Turã nda tu, ae ɨ quia cose nae, ũquɨ̃ abe que jendu ɨquia ɨquia quia cose resẽ. Ibatenda Turã tu mose que jemee ñochɨ̃ nguiã mbia ɨcuã je ra. Eɨquia nonde que jemee ñochɨ̃ nguiã mbia ɨcuã je. ");
INSERT INTO srqNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Dios que ángeles mbu rei jẽje ra. Ucheẽ nderu raque jẽje. Jẽ echeẽ mumbayã sacuã. Echeẽ ngue jemumba mumba beɨ chõchɨ̃ nguiã, ɨ que Esteban ñee oco tuchɨ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Eandusa que paama ɨ tuchɨ Esteban je ra. Esteban ɨ quia serɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Espíritu Turã ngue siqui tuchɨ Esteban ndese ra. Esteban ngue mae tuchɨ ibei rese mbia paama ɨ mose ee ra. Dios Turã ndese que mae ibate ra. Jesús rese abe que mae nda. Jesús que chɨ̃ juã Dios ji ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Esteban ngue ñee nda. —Jemae jẽ. Ibei nyɨequia rese aɨ̃ mae a. Huee mbia rucucha ñɨ juã Dios ji huee. Huee Jesús ñɨ juã Dios ji huee, ɨ que Esteban nda. ");
INSERT INTO srqNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mbia que tasẽ tasẽ tuchɨ paama ɨ ra. Huisacua que emɨtao ja Esteban ñee sɨ ra. —Nandecua recua erese, ɨ que o oe Esteban ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Mbia que Esteban curuchoɨ sucha tubɨrɨã sɨ ra. Huee que sɨta mombo mombo erese ra. Sɨta mombo mombosa que huɨɨrao mbuɨ mbuɨ acuanɨndu mo je ra. —Esaarõ, ɨ que ee ra. Saulo, ɨ que eɨeɨrao raarõsa je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mbia que sɨta mombo mombo Esteban ndese ra. Sɨta mombo mombo mose que Esteban ñee Ibatenda je ra. —Aque aso quia ndeje aque, Sererecua Jesús. Seisi cote, ɨ que Esteban Ibatenda je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ngoi que nguíã ndese cote ra. Tasẽ tasẽte que ñee mombo mombo ra. —Sererecua, ã ɨcuã ndaque seje. ¡Erembasi mbasichɨ̃ nda huɨɨcuã nɨɨ jẽ! ɨ que Esteban Jesús je ra. Esteban ngue mano cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","—Coche rei mano, ɨ que Saulo Esteban mano mose ra. Aque mose tuchɨ que mbia ɨcuã ɨcuã tuchɨ Jesús quiato je cote ra. Jerusalén jenda. Jesús quiato que nyoɨ ja ñɨmbuchao Judea rɨ̃ nda. Samaria rɨ̃ abe que echoɨ ñɨmbuchao ra. Jesús chɨmbaaquiatu achõ ngue chɨchõ Jerusalén nda. ");
INSERT INTO srqNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mbia turã mo ngue Esteban nyati ra. Nyeseo tuchɨ que eati mose ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo ɨcuã tuchɨ que eriqui Jesús quiato je ra. —Jesús quiato tambutiã, ɨ tuchɨ que Saulo quia ra. Nyebe eriqui nguiã mbia chuchua mbuchesea seate. Jesús quiato rea rea ererao sacuã tarõ policíaa. Saulo ɨcuã tuchɨ que eriqui Jesús quiato je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ae uchã nyoɨ quia Jerusalén sɨ nae, ũquɨ̃ ngue nyoɨ mbia mbiirandu randu tuchɨ quia Jesús rɨɨ̃ nda. Mbia recua ja que eriqui nyoɨ nyoɨ mbia mbiirandu randu Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe que oso Samáriaa ra. Sucha tubɨrɨã mo. Huee que eriqui mbia mbiirandu randu Jesús rɨɨ̃ no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Dios que Felipe mbuquirãcuã nda. Mbia mae sayã ngue esaã saã nda. Mbia tubɨrɨã ngue nyiisaquia tuchɨ quia echeẽ ndese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Aba checuayã ɨcuã ngue Felipe jea jea tuchɨ mbia sɨ ra. Aba checuayã ɨcuã ngue tasẽ tasẽ nguia huɨ mose mbia sɨ ra. Felipe que mbia cuatayã mbucuata ja quia ra. Mbia umɨ sayã abe que embucherõ cherõ nguia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nyebe hue jenda ia tuchɨ sucha tubɨrɨã jenda. ");
INSERT INTO srqNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Huee sucha tubɨrɨã ngue Simón ndiqui ra. Brujo que ae nyii ra. Ae que mbia mbɨɨrɨ̃ ɨrɨ̃ tuchɨ quia nyii ra. Mbia Samaria jenda chɨɨcua tuchɨ que ae ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mbia que nyiisaquia tuchɨ quia Simón ñee ndese cose ra. Mbia riirĩ abe que nyiisaquia quia echeẽ ndese ra. —Dios embuquirãcuã tuchɨ quia co, ɨ rei que mbia Simón nɨɨ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Simón ngue mbia mbɨɨrɨ̃ ɨrɨ̃ tuchɨ quia brujería je ra. Nyebe que mbia riqui nyiisaquia tuchɨ eres e nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Huee que Felipe Jesús renei nenei tuchɨ cote ra. —Dios ra mbia rerecuarã tuchɨ, ɨ que Felipe quia hue jenda je ra. Ũquɨ̃ mose que mbia Jesús ɨcua ɨcua tuchɨ ra. Bautizar ɨ que mbia atate je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón Brujo abe que Jesús ɨcua cote ra. Bautizar ɨ que ee ra. Felipe ruɨ beɨ que eriqui cote ra. Felipe que mbia mae sayã saã saã nguia ra. Simón ngue nyuruɨra tuchɨ quia mae erese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","—Samaria jenda riqui Dios cheẽ isi isi tuchɨ ã, ɨ que mbia Jerusalén jenda mbiirandu randu ra. Nyebe que Jerusalén jenda Pedro mondochoɨ Samáriaa ra. Juan abe mondo. ");
INSERT INTO srqNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ngasẽ mose que ñee Dios je ra. —Espíritu Turã emondo rã Jesús quiato a jenda je, ɨ que Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Espíritu Turã ɨqueã mose hue jenda chɨangui re que Pedro choɨ erea ra. Jesús rimbarã ño ngue mbia bautizar ɨ nguiã ee nyii. Espíritu Turã ɨqueã ño nguia echɨangui re nyii reaẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pedro que o chono Jesús quiato ãquĩ arõ nda. Juan ab e o chono earõ. Espíritu Turã ngue tu Jesús quiato je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simón ngue mae erese ra. O chono mose earõ. Espíritu Turã tu mose ee. Nyebe que mbae isiquia reacuquia Pedro je ra. Juan abe je. ");
INSERT INTO srqNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ñee ngue ee ra. —Sembaaquiatu se abe. Ndequirãcuã embu seje. Sã se abe seo tachono ñono mbia arõ. Sã se abe Espíritu Turã quirãcuã tamee mee mbia je. Mbae isiquia tamee jẽje jẽquirãcuã ndɨbɨshorõ, ɨ rei que Simón nda. ");
INSERT INTO srqNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro que ñee asi ee ra. —Sã mbae isiquia nembae quiachã ja. Nde abe equiachã tuchɨ. ¡Dios ra uquirãcuã mee eã mbae isiquia rɨbɨshorõ jẽ! ");
INSERT INTO srqNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ndeturã eã ñochɨ̃ ndechɨangui re. Nyebe ra Dios uquirãcuã mee eã ndeje. ");
INSERT INTO srqNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","¡Ndeɨcuã sɨ ehuɨ rã jẽ! Echeẽ ñee Dios je. Sã Dios nendua ɨcuã mbutiã ndesɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","¡Sã ndeɨcuã tuchɨ riqui ndechɨangui re jẽ! Ndeɨcuã aɨcuate quia co, ɨ que Pedro ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simón ngue ñee Pedro je cote ra. —Echeẽ turã Dios je serɨɨ̃. Sã Dios seɨcuã mbutiã. Ɨ̃ nda aquiachãyã esɨ, ɨ que Simón nda. ");
INSERT INTO srqNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedro que Dios cheẽ senei senei nguia ra. Juan abe esenei senei no. Aquere que echoɨ nyebi Jerusalén nda. Ñeend a cua jenda que embuchesea sea sucha tubɨrɨã nda. Samaria jenda mbuchesea sea Jesús renei nenei mbia je. ");
INSERT INTO srqNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Angel mo ngue tu Felipe je ra. Ibate sɨ que eru nguichi ñee ee ra. —Eso chõ turúquiaa. Eso chõ ñeenda ɨcoɨ̃ Jerusalén ɨcha. Gaza ɨcha abe, ɨ que ibatenda Felipe je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe que oso Dios cheẽ nguire ra. Echɨa o ji mo ngue esobeɨshɨ̃ ñeenda cúaa ra. Etiopía jenda rei echɨa o ji. Ae rei ererecua resenda. Candace, ɨ que ererecua je ra. Reina. Mbae isiquia Candace mbae que esaarõ arõ tuchɨ quia ee ra. Echɨa o ji oso quiatu quia Jerusalén nyii reaẽ. Oso quia equia Jerusalén ñee ñee sacuã Dios je nyii reaẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Uba que u quia uchuchua quiti cote ra. Carro ye que eru quia cote ra. Isaías chɨmbesa rese que eru quia mae mae carro ye ra. Dios cheẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Espíritu Turã ngue ñee Felipe je ra. —Eso rã carro jii, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe que oso ra. Oso que Etiopía jenda andu ra. Isaías chɨmbesa rese que esɨ quia maemae nda. Nyebe Felipe ñee ee. —¿Isaías chɨmbesa checuate eriqui ndeje re? ɨ que Felipe ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","—Tei. ¿Mañɨ ae ra eɨcua re? Aba mo eɨcuayãte seje resẽ. Echuɨ rã. Ecoi sejii. Sembaaquiatu rã se, ɨ que carro yenda ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ã Isaías chɨmbesa rese que eriqui mae mae nda. Ã ndei e ã: Nanderiquicharõsa rei oveja rã. Mbia que oveja querao eɨquiásaa ra. Mbia que ovejara nyisia sia ra. Oveja ñee ñeeã ee. Eɨ̃ ngue nanderiquicharõsa ñee ñeeã huɨɨquia mose ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nanderiquicharõsa turãte raque. Mbia ɨcuã tuchɨ ee. Mbia eɨquiachõ. Emosenda ɨcuã tuchɨte ee. Emosenda eɨquia chee. Nanderiquicharõsa siquíã ibi rɨ̃ cote, ɨ qu e Isaías embesa ra. Embesa ji rese que Etiopía jenda riqui mae mae nda. ");
INSERT INTO srqNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopía jenda que ñee Felipe je ra. —Embesa ji embuchecua seje. ¿Aba rɨɨ̃ Isaías riqui embesa mbesa re? ¿Mbiamo nɨɨ eriqui embesa re? ¿Ngũɨɨ̃ eriqui embesa re no? ɨ que Felipe je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipe que embuchecua ee ra. Mbaaquiatu tuchɨ que Jesús rɨɨ̃ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Carro que ngasẽ ama moo cote ra. —¡Co ama ñɨ co! ¿Aa ra bautizar ere seje re? ɨ que Etiopía jenda Felipe je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—¿Jesús ereɨcua quia cote re? Jesús ɨcua tuchɨ mose ra bautizar ae ndeje cote, ɨ que Felipe ee ra. Etiopía jenda ñee ee cote. —Jesús aɨcuate quia co cote. Jesucristo rei Dios ndiirĩ. Aɨcua sequia co cote, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Carro que embutiba cote ra. Nguichi que esɨ ra. Ama ndie que echoɨ ra. Felipe que bautizar ɨ ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Usẽ ngue ama sɨ cote ra. Espíritu Turã ngue Felipe querao hue sɨ cote ra. Etiopía jenda que mae eã mbeɨ Felipe rese cote ra. Etiopía jenda ia tuchɨ que oso ra. ");
INSERT INTO srqNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe que ngasẽ Azótoo ra. Sucha tubɨrɨã ngue embuchesea sea ra. Mbia mbiirandu randu tuchɨ Jesús cheẽ ndese. Ngasẽ nyee que Cesarea ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo ɨcuã mbeɨ que eriqui Jesús quiato je ra. Taɨquia ja, ɨ rei que equia ra. Nyebe que esɨ ñee sacerdote rerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","—Papel embesa rã sechɨraorã. Tarao Damáscoo. Judíos chumunua mose ereacuquia sacuã ee. Jesús quiat o hue jenda taru taru Jerusalén. Ecuasa taru taru quia etarõ sacuã policíaa. Mujeres abe taru. Hombres abe taru taru no, ɨ rei que Saulo ñee ɨcuã Jesús quiato rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Damasco rurubi mose que tata mo tu tuchɨ ee ra. Tata mo ngue tu tuchɨ ee ibate sɨ ra. Tata que Saulo tesae tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulo que ngoɨ oso íbii ra. Echeẽ mo ngue echandu ra. —¿Mbaerã ndeɨcuãte riqui seje re? ɨ que ibatenda ñee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo que ñee ee ra. —¿Aba nde re? ɨ ee. Ibatenda que ñee ee ra. —Jesús rei se. Seje quia ndeɨcuãte riquichɨ̃ nguiã. Ndeɨcuã mose seje, nde sɨ́ chõ ereɨco ñimbasi co. Sã ticuasu riqui nambacua mbuti no. Sã eriqui hui mbaba ira racua echɨ no. Ũquɨ̃ na tuchɨ quiarei nde, ɨ que Jesús ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo que titi titi ɨ eandu ra. —¿Mañɨ ae ra sequia se re, Sererecua? ɨ que Saulo Jesús je ra. —Ehuã. Eso sucha tubɨrɨã. Huee ra sequiato mo secheẽ nenei ndeje, ɨ que Jesús Saulo je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulo resend a que siquiche tuchɨ ra. Echeẽ andu mose. Mbia mo ndese que maeã nda. Nyebe siquichete echeẽ andu. ");
INSERT INTO srqNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo que juã ndei nguesa ɨra ra. Emae sayã tuchɨ. Eresayã ngue ra. Nyebe que mbia eo isi suruchoɨ sucha tubɨrɨã nda. Sucha tubɨrɨã Damáscoo. ");
INSERT INTO srqNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tres días que eresayã tuchɨ riqui ra. Aque mose que eresayã mbae mo uãte ra. Aque mose que yu eã no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Huee sucha tubɨrɨã ngue Jesús quiato mo ndiqui ra. Ananías, ɨ que ee ra. Aque nda Dios tea cuu ra. —Ananías, ɨ nda Dios eque re ra. —¿Mbae? ɨ nda Ananías e e ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","—Eso rã Ñeenda Chaa Chaareã. Huee que Judas chuchua ñɨ nda. Huee eso Saulo rea. Saulo rei Tarso jenda. Hue eriqui ñee ñee seje hue. ");
INSERT INTO srqNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Saulo que nderea cuu ra. Ereso que ndeo no erese cuu ra. Eresa que erembucherõ cuu ra. Ũquɨ̃ sɨ́ esaã oso ee, ɨ nda Dios Ananías je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías que teã ndei ra. —Mbia Saulo ɨcuã ɨcua tuchɨ quia co, Dios. Eɨcuã tuchɨ Jesús quiato Jerusalén jenda je. Mbia sembiirandu ja quia co, Dios. ");
INSERT INTO srqNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A eru Jesús quiato isi ererao sacuã a. Ũquɨ̃ je chõ sacerdote rerecua embu nguiã a. Uretarõ ja sacuã, ɨ que Ananías Dios je ra. Esiquichete que Saulo sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Dios que ñee ee ra. —Eso chõ erea. Ae quia airabo mɨngo serimbarã co. Ae ra Israel jenda mbiirandu randu secheẽ ndese. Ae ra mbia mangue chooñoa jenda abe mbiirandu randu secheẽ ndese no. Ae ra mbiamo nderecua abe mbiirandu randu secheẽ ndese no. ");
INSERT INTO srqNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Saulo secheẽ nenei nenei mose ra mbia embasi mbasi tuchɨ. Mbia ɨcuã ɨcuã tuchɨ ra ee serɨɨ̃ mambɨ. Ũquɨ̃ ndese Saulo tambiirandu, ɨ que Dios ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías que oso cote ra. Dios cheẽ nguire. Ɨque que Judas chuchúaa ra. O que echono Saulo rese ra. —Seresenda ereɨco co cote, Saulo. Jesús que nyecua ndeje ñeenda cúaa, ae sɨ́ sembu quia ndeje co. Jesús sembu ndeje co. Espíritu Turã ɨque sacuã ndechɨangui re. Nemae sacuã abe sembu co no, ɨ que Ananías Saulo je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Aque mose tuchɨ que sɨra quɨɨshɨ̃ naanguia tu ngoɨ eresa sɨ ra. Saulo que mae turã cote ra. Jesús quiato que bautizar ɨ Saulo je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Saulo que quiaru ñɨmbuquirãcuã cote ra. Itõ mocoɨ̃ jiri que Jesús quiato rese huee ra. Damasco jenda rese itõ mocoɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saulo que oso oso quia Jesús renei nenei judíos chumunuásaa ra. —Jesús rei Dios riirĩ, ɨ tuchɨ que equia mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mbia que nyuruɨra tuchɨ quia echeẽ andu ra. —Co chõ Jesús quiato ɨquia ɨquia quia cose nye. Jerusalén jenda. Co chõ tu a Jesús quiato rerao sacuã nye. Co chõ Jesús quiato queraose rete quia sacerdote rerecua je nye. Ae Jesús quiato riqui quia namo co cote, ɨ que mbia nyuruɨra Saulo rea ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulo quirãcuã tuchɨ que eriqui cote ra. Ererecua rã ño eriqui nguiã mbia mbaaquiatu quiatu Jesús rɨɨ̃. —Jesús rei Cristo. Ae jẽsaarõ arõ nguia, aque rei Jesús, ɨ tuchɨ que Saulo quia judíos je ra. Judíos Damasco jenda que Saulo cheẽ sɨbɨshorõ aronea nda. ");
INSERT INTO srqNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Emo mose jiri que judío rerecua ñee nyue ra. —¡Saulo nandeɨquia jẽ! ɨ rei que ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mbia mo ngue Saulo mbiirandu ra. —Nandeɨquia, ɨ nda mbia nderɨɨ̃ nda. Hue echɨ nyiquitirõ nderese eɨquésaa hue. Isa abe echɨ nyiquitirõ nderese hue, ɨ que embiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Itondaru mose que Jesús quiato mo Saulo mbuchemɨ nda. Nyuchã ngue iru ye ra. Iru resebe que embuquichi mondo etaronda robeɨ ra. Muralla robeɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo que oso Jerusalén cote ra. —Taɨco Jesús quiato rese, ɨ rei que ngasẽ nda. Jesús quiato que siquiche ja esɨ ra. —Saulo Jesús quiato saã saã ño nguiã nande je co, ɨ rei que mbia ra. Nyebe siquiche rei nguiã esɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bernabé mɨɨ ngue Saulo isi turã nda. Ae que Saulo querao Jesús quiato rerecua je ra. Embiirandu tuchɨ Saulo rese. —Saulo que oso rei Damáscoo ra. Nandererecua Jesús que nyecua ee ñeenda cúaa ra. Jesús que ñee ee ra. Saulo que siqui Jesús ruɨ cote ra. Saulo que siquicheã nguia Jesús renei nenei Damasco jenda je cote ra, ɨ que Bernabé uataque je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Aquere que Jesús quiato Saulo isi turã cote ra. Saulo que siqui are jiri Jerusalén cote ra. Hue jenda Jesús quiato rese que eriqui tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Saulo siquicheã ngue eriqui Jesús renei nenei mbia je ra. Ae griego cheẽ saã saã nguia nae, ũquɨ̃ je abe que erenei nenei nda. Ñee asi asi que Saulo je Jesús rɨɨ̃ nda. Saulo abe que ñee tuchɨ ee Jesús rɨɨ̃ nda. Nyebe mbia riqui nguiã “nandeɨquia” ɨ Saulo rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jesús quiato que jirandu erese ra. Nyebe Saulo ruruchoɨ nguiã Cesarea. Mondo que echuchúaa sɨ́ cote ra. Tarso, ɨ que Saulo chuchua je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Aquere que mbia ɨcuã ɨcuã eã Jesús quiato je cote ra. Judea jenda je. Galilea jenda abe je. Samaria jenda abe je no. Jesús quiato hue jenda que ñɨmbuquirãcuã nacuã ja ra. Siqui ɨ ɨ tuchɨ Jesús rese. Espíritu Turã ngue embeta mbeta ra. Etubɨrɨã nyee. Jesús quiato que Dios cheẽ mumba mumbayã nguia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro que mbia mbuchesea sea tuchɨ quia ra. Oso que Jesús quiato Lida jenda rea no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Hue que umɨ sayã mo ndiqui ra. Ae ngatayã mbeɨ quia ocho años. Nyaara beɨ chõ ngue equia ra. Eneas, ɨ que umɨ sayã je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro que ñee ee ra. —¡Jesús riqui nembucherõ a jẽ! Ehuã na. Nderua abe enua, ɨque Pedro umɨ sayã je ra. Ũquɨ̃ mose que nyerõ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mbia que mae ja u umɨ sayã ngata rese ra. Nyebe que mbia Jesús ɨcua ja cote ra. Lida jenda Jesús ɨcua ja. Sarón jenda abe que eɨcua ja n o nda. Ngãmeĩ ñee sɨ que huɨ Jesús isi cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Dorcas, ɨ que ari mo je ra. Jope jenda que ra. Dorcas, ɨ que griego cheẽ quiicuã je ra. Jesús quiato que ae ra. Ae que eturã mbeɨ riqui mbia je ra. Ae que mbae mee mee mbeɨ quia mbaecha reã je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Dorcas rasi que eɨquia cote ra. Mbia que eraaque mbuchasu ra. Mɨɨ ngue equesa nongue ibatenda ye ra. Segundo piso. ");
INSERT INTO srqNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pedro que siqui aɨchɨ ra. Lida, ɨ que sucha tubɨrɨã je ra. Nyebe que Jesús quiato mbia nyeremo mondochoɨ Pedro reru sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro que oso erese ra. Ngasẽ mose que mbia eruruchoɨ equesa ibatenda ra. Dorcas raaque rese mae. Hue eru chɨecha tubɨrɨ̃ a nyɨ nyeseo eraaque res e hue. Dor cas chɨmee tubɨrɨã ngue eteacuquia cuquia u nyue hue ra. Mbia ɨrao tubɨrɨã ngue Dorcas chɨao ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro que mbia mbusẽ ja mondo taicuee ra. Ngũíã ndese que ñee Dios je cote ra. Aquere que ñee eraaque je cote ra. —Ehuã na, Dorcas, ɨ que ee je ra. Eraaque que nguesa ɨra mae Pedro rese ra. Nyuruã ngue ngoi cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro que emua eo rese ra. Jenyu, ɨ que Jesús quiato je cote ra. Eru chɨecha ja je abe no. Ngaẽ ngue mae equera rese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mbia Jope jenda que jirandu tuchɨ erese ra. Nyebe que mbia tubɨrɨã Jesús ɨcua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro que itõ mocoɨ̃ hue ra. Sucha tubɨrɨã. Simón curtidor chuchúaa que eriqui uque ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Soldados rerecua mo ngue siqui sucha tubɨrɨã Cesaréaa ra. Italia jenda rei ũquɨ̃ soldados. Cien ngue soldados ra. Cornelio, ɨ que soldados rerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ae que ñee ñee mbeɨ quia Dios je ra. Ae que eturã ndiqui Dios je ra. Mbae isiquia que emee mee tuchɨ quia mbaecha reã je ra. Echuchua jenda abe que eturã ndiqui Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tenda nyeseco ramo mose que Cornelio ibatenda mo ndea cuu ra. Angel. Echecua tuchɨ que ee cuu ra. Ɨque que echuchúaa ee cuu ra. —Cornelio, ɨ que ñee ee cuu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio que mae quiatu tuchɨ erese ra. —¿Mbae ere, Sererecua? ɨ que siquiche ñee ee ra. Ibatenda que ñee ee cote ra. —Co ereɨco ñee ñee mbeɨte Dios je co. Co ereɨco mbae mo mee mee mbeɨte mbaecha reã je co. Nyebe Dios ia tuchɨ riqui nguiã nderese co. ");
INSERT INTO srqNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Huee que Simón Pedro mo ndiqui Jópee ra. Nderimba mo emondochoɨ erea. Ereru sacuã ñee ndeje. ");
INSERT INTO srqNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Huee eriqui Simón Curtidor chuchúaa huee. Am a ndɨsha rimia eriqui hue. Sã nderimba ecurucuaẽ hue sɨ. Ñee ñee sacuã ndeje, ɨ que ibatenda Cornelio je cuu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Dios chɨmondo ibatenda que oso Cornelio recha cote ra. Cornelio que ñumumba cote ra. Jenyu, ɨ que ngũimba nyeremo je ra. Aque mɨɨ soldado je abe no. Ae rei Cornelio raarõsa. Ae que ndua ndua beɨ quia Dios rese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ũquɨ̃ je que Cornelio uquereɨcuã nenei nenei ja ra. —Jẽso Pedro reru Jope sɨ, ɨ que ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","10","Isamamɨ ngue Cornelio rimba ngasẽ Jope rurubi cote ra. Aque mose que Pedro chɨ tuchua arõ nda. Huee rei equesa no. Huee que Pedro chɨ ñee ñee Dios je ra. Tenda ibate mose que Pedro riãcuã nda. Echɨurã ngue uchi ãte ra. Nyebe que uque u ra. Uchɨurã naa mose. Equereɨcuã ngue cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ibei que nyɨequia ee cuu ra. Tiru ɨcoɨ que tu ibei sɨ ra. Tiru chimangũiana isi ji que tu nguichi ee cuu ra. Echimangũiana isi ji ja. ");
INSERT INTO srqNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mbae tubɨrɨã ngue tu nguichi tiru ɨcoɨ y e ee cuu ra. Mbae chumumbara tuchɨ. Quiaa rɨɨnda ja. Mbeɨ abe n o. Nguireĩ abe no. Mbae ibi rɨɨnda ja tuchɨ que chɨ tiru ye cuu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pedro que echeẽ mo ñandu cote ra. —Ehuã na, Pedro. Emo eɨquia ndechɨurã, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","—Tei, Sererecua. Urechɨu eã ño ã ndesẽ. Ã mo ngue ureu eã mbeɨ quia ra. Mbaeɨae tuchɨ ure je judíos ja je, ɨ que Pedro ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dios que ñeembe ee ra. —¡Sechɨmee ndechɨurã nda ereisiteãchɨ̃ jẽ! ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Eɨ̃ sɨ que tiru ɨcoɨ ru tres veces ra. Mbae chumumba ra ja resebe. Tiru que oso beɨ ibate cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro que ñumumba cote ra. Ndua ndua tuchɨ que uquereɨcuã ndese ra. Aque mosete que Cornelio rimba ngasẽ nda. —¿Ma Simón chuchua ma nde? ɨ que ngasẽ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","—¿Simón Pedro riqui a re? ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro qu e ndua ndua beɨte quia uquereɨcuã ndese ra. Nyebe Espíritu Turã ñee nguiã ee. —Mbia tres ngaẽ nguia nderequia co. ");
INSERT INTO srqNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Equichi. Eso rã erese. ¡Esiquicheã oso erese jẽ! Se chõ ngue ambu nderea resẽ, ɨ que Dios Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro que nguichi u ee cote ra. Cornelio rimba je. —Serequia chõ jenyu nguiã co. ¿Mbaerã jẽɨngo serequia re? ɨ que Pedro ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","—Cornelio quia urembu nguiã nderea co. Ae rei soldados rerecua turã. Judío chɨɨcua tuchɨ que ae ra. Eturãte eriqui Dios je co. Angel que oso ñee Cornelio je ra. “Mbia emondo rã Pedro reru sacuã. Pedro cheẽ echandu rã”, ɨ que ángel Cornelio je ra, ɨ que Cornelio rimba Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","—Jenyu rã ɨque. Jengue a, ɨ que Pedro ee ra. Isamamɨ ngue Pedro oso erese cote ra. Jesús quiato Jope jenda abe que nyoɨ erese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Isamamɨ ngue ngasẽ Cesarea cote ra. Cornelio que esaarõ arõ nguia huee ra. Nguesenda rese que eriqui eraarõ arõ nda. Nguiirĩ abe rese que eriqui eraarõ arõ nda. —Jenyu Pedro raarõ serese. Echeẽ andu sacuã, ɨ nda nguesenda je nyii ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro que ngasẽ oso Cornelio chuchúaa ra. Cornelio que oo erese ra. Aquere que ngoi ngũíã ndese ñee ñee ee ra. Ibatenda Pedro riqui reĩ nguiã Cornelio je. ");
INSERT INTO srqNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedro que ñee ee ra. —Ehuã na. Dios eã ño se re. Nderã sɨ chõ se re. Mbia chõ se re, ɨ que Pedro ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ñee ñee ngue equia nyue cote ra. Nyoɨ que ɨque mbia tubɨrɨãsa cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedro que ñee ũquɨ̃ je ra. —Se rei judío. Judío siqui aronea ndaque mbiamo ndese. Judío ɨque aronea mbiamo nyuchúaa. Ũquɨ̃ jẽɨcua raque quia ã. Dios que ñee seje cuu ra. Dios que sembaaquiatu cuu ra. “Mbiamo abe que eturãte riqui ra. Mbiamo ndese abe eɨco jiri”, ɨ que Dios seje ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nyebe achu jeɨ nguiã ndecheẽ mose co. ¿Mbaerã “echu” ere seje re? ɨ que Pedro Cornelio je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio que ñee ee cote ra. —Hue tenda beɨ aɨco ñee ñee Dios je co. Tenda nyeseco mose aɨco beɨ ñee ñee Dios je co. Se cheẽ mose que ibatenda mo ndu seje ra. Angel. Tu que seje hace cuatro días ra. Tirushĩ tuchɨ que ecunua nda. ");
INSERT INTO srqNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ibatenda que ñee seje ra. “Cornelio, Dios ndecheẽ ñandu beɨ quia co. Dios mae mbeɨ quia nderese co. Mbae mee ndese mbaecha reã je eriqui mae co. Dios riqui ndeɨcuate co. ");
INSERT INTO srqNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mbia mo emondo rã Jópee. Hue Simón Pedro ndiqui hue. Hue eriqui Simón Curtidor chuchúaa hue. Ama ndɨsha rimiã ndese eriqui hue. Sã nderimba mo erurucuaẽ aa”, ɨ que ángel seje ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nyebe serimba amondo jeɨ nderea. Coche erechu nguiã seje aa. Ndecheẽ andu sacuã ño urecu nguiã aa. Dios cheẽ esenei na ure je cote. Ae Dios mondo ndeje, erenei sacuã ure je, ɨ que Cornelio Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro que ñee ee cote ra. —Judíos achõ je eã ño Dios turã ndiqui reaẽ. Mbiamo abe chõ ebi riqui reaẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mbiamo abe ɨreɨ̃ ɨreɨ̃ chɨ̃ nguiã Dios sɨ re. Ibimo jenda re. Ũquɨ̃ siqui turã ño nguiã Dios je reaẽ. Nyebe Dios abe eturã ndiqui ũquɨ̃ je reaẽ. Judíos achõ eã ndaque. ");
INSERT INTO srqNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios que ucheẽ turã mondo judíos je ra. Dios cheẽ turã ngue tu Jesucristo rɨɨ̃ nda. Ae rei aba mbiasa. Jesucristo rei mbia rerecua tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Judío recua ja que Dios cheẽ turã ndiqui ã ndesẽ. Juan Bautista reco mose que Dios cheẽ ngasẽ judíos ja je ra. Juan Bautista que Dios cheẽ senei senei Galilea ra. Aque mose rane ngue Dios cheẽ ngasẽ judíos ja je cote ra. Ũquɨ̃ jẽɨcua tuchɨ quia ã ndesẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jesús siqui turã jẽɨcua quia resẽ. Jesús Nazaret jenda siqui turã mbeɨ. Dios que Jesús mbuquirãcuã Espíritu Turã je ra. Dios que siqui tuchɨ erese ra. Nyebe eriqui nguiã mbae turã naa naa. Nyebe eriqui nguiã aba checuayã ɨcuã jea jea mbia sɨ. Ũquɨ̃ jẽɨcua quia ã ndesẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jesús chɨmbaaquiatu chõ ureɨco nguiã ã. Jesús chɨsaã ndese que ureɨco mae mae huee ra. Judea ruɨ ja. Jerusalén abe que ureɨco mae mae echɨsaã ndese ra. Huee Jesús reco mose que mbia eɨquia cote ra. Huee que mbia embucha ira rese ra. Eɨquia sacuã. ");
INSERT INTO srqNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Dios que Jesús mbuquera sɨ cote ra. Tres días mose. Dios que Jesús mbuchecua ure je cote ra. Mbia ja je embuchecuayã. Ure je achõ ngue embuchecua ra. Uchiirabo achõ je. Jesús renei nenei sacuã ngue Dios ureirabo ra. Urequiaru que Jesús rese ra. Jesús quera ɨco. Mbae mo abe que urembei erese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jesús que uremondo mbia mbiirandu randu sacuã ngũɨɨ̃ nda. “Secheẽ turã jẽsenei senei nguia mbia je. ‘Dios que Jesús mɨɨ nda. Mbia mano je ɨcuã ndea sacuã. Manoã je abe ɨcuã ndea sacuã. Jesús r a eɨcuã tea ja’, jenye quia mbia mbiirandu randu”, ɨ que Jesús ure je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Dios cheẽ mbuchecuasa ja que embesa mbesa Jesús rɨɨ̃ cose ra: “Dios turã nda eriqui Jesús ɨcuasa je. Dios ra Jesús ɨcuasa ɨcuã mbutiã tiã esɨ”, ɨ que Dios cheẽ mbuchecuasa ra, ɨ que Pedro Cornelio je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro cheẽ mose que Espíritu Turã ndu ɨque eandusa chɨangui re ra. Eandusa chɨangui re ja ɨque. ");
INSERT INTO srqNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pedro resenda judíos que nyuruɨra tuchɨ ra. —Judíos eã je abe chõ Dios riqui Espíritu Turã mondo mondo re, ɨ que judíos Jesús quiato u nyuruɨra ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Judíos eã ngue mbiamo ñee saã saã nda. Espíritu Turã ɨque mose echɨangui re. Ñee turã ja Dios rɨɨ̃. Nyebe judíos ñee. —Ã ñɨangui re abe Espíritu Turã ɨquechɨ̃. Judíos eã ndaque, ɨ que eandu ra. Pedro que ñee nguesenda je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Espíritu Turã ngue ɨque echɨangui re cote ra. Nyebe bautizar tae ee i je cote. Emo nda seriquisãyã, ɨ que Pedro ra. ");
INSERT INTO srqNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nyebe que Pedro bautizar ɨ ee ra. Jesucristo rimbarã ngue bautizar ɨ ee ra. Aquereque ñee ja Pedro je ra. —Eitõ mocoɨ̃ jiri quia ure rese aa, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jesús chɨmbaaquiatu que jirandu erese ra. Judíos eã ndese. Jesús quiato Judea jenda abe que jirandu erese ra. —Judíos eã abe riqui Dios cheẽ isi isi ã, ɨ que mbia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pedro que oso Jerusalén cote ra. Huee que judíos ñee asi asi ee cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","—Mbiamo je ereso chõchɨ̃. Judíos eã je ereso chõchɨ̃. Judíos eã ndese ereiaru chõchɨ̃, ɨ que ñee asi Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedro que embiirandu tuchɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Emo mose que aɨco Jope ra. Huee que aɨco ñee ñee Dios je ra. Mbae mo ngue atea cuu ra. Tiru ɨcoɨ mo ngue tu ibate sɨ cuu ra. Echimangũiana isi ji que tu nguichi seje cuu ra. Echimangũiana isi ji ja. ");
INSERT INTO srqNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mbae chumumbara tuchɨ que tu aque tiru ye cuu ra. Quiaa rɨɨnda ja. Mbeɨ abe no. Nguireĩ abe no. Mbae ibi rɨɨnda ja tuchɨ que chɨ tiru ye cuu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Echeẽ mo ngue tu seje cote ra. “Ehuã na, Pedro. Emo eɨquia ndechɨurã”, ɨ que seje cuu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Tei, Sererecua. Urechɨu eã ño ã ndesẽ. Ã mo ngue ureu eã mbeɨ quia ra. Mbaeɨae tuchɨ ure je judíos ja je”, ae rei que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Dios que ñeembe seje ra. “¡Sechɨmee ndechɨurã nda ereisi teãchɨ̃ jẽ!” ɨ que seje ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Eɨ̃ sɨ que tiru ɨcoɨ ru tres veces ra. Oso beɨ que ibate serecha cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Aque mosete que Cornelio rimba ngasẽ seje ra. Seruruchoɨ sacuã ngue ecuaẽ Cesarea sɨ ra. Tres que ngaẽ seruruchoɨ sacuã nda. ");
INSERT INTO srqNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","“Eso rã erese. ¡Esiquicheã oso erese jẽ!” ɨ que Espíritu Turã seje ra. Ã nanderesenda seis que nyoɨ serese ra. Urecuasẽ ngue emondosa chuchua ra. Cornelio chuchua. ");
INSERT INTO srqNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Cornelio que uquereɨcuã senei ure je ra. “Angel mo ngue tu ñee seje ra. ‘Mbia emondo Jópee Simón Pedro rea. ");
INSERT INTO srqNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ae ra ñee ñee nguia jẽje. Ndechuchua jenda je abe ra eriqui ñee ñee. Dios jendirõ sacuã jẽɨcuã sɨ’, ɨ que ángel seje ra”, ɨ que Cornelio seje ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Se ñee namo mose ee que Espíritu Turã nguichi ee ra. Ɨque que echɨangui re ra. Ɨque que nandechɨangui re nyii nae, eɨ̃ sɨ que ɨque Cornelio chɨangui re cote ra. Cornelio chuchua jenda chɨangui re abe. ");
INSERT INTO srqNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jesús cheẽ ndese que andua ndua cote ra. Ã ndei echeẽ ã: “I je que Juan bautizar ɨ rei mbia je ra. Espíritu Turã je bautizar tae jẽje cote”, ɨ que Jesús cose ra. Aque rese que andua ndua cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nande judíos achõ je eã ño Dios riqui nguiã Espíritu Turã mondo. Judí eã je abe chõ eriqui nguiã Espíritu Turã mondo. Jesús ɨcua mose. ¿Mañɨ ae ra Dios riquisã se re? ɨ que Pedro ñee oco judíos je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mbia que Pedro cheẽ sobeɨshɨãte ra. Ñee turã turã ngue Dios je cote ra. —Dios judío eã abe mbuɨ mbuɨ quiatu quia huɨɨcuã sɨ reaẽ. Judío eã abe chee ra siqui beɨ Dios rese nye, ɨ que judíos ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mbia ɨcuã tuchɨ que eriqui Jesús quiato je cote ra. Esteban ɨquia mosebe beɨ que mbia ɨcuã ndiqui Jesús quiato je ra. Nyebe Jesús quiato choɨ nguiã uchã Jerusalén sɨ. Emo nyoɨ Feníciaa. Emo nyoɨ Chipre no. Emo nyoɨ Antioquía no. Huee ja que echɨ Jesús cheẽ turã nenei nenei nda. Judíos achõ je que echɨ erenei nenei nda. Judío eã je erenei nenei eã. ");
INSERT INTO srqNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Chipre jenda rei emo. Cirene jenda rei emo no. Ũquɨ̃ nguia que nyoɨ Antioquíaa ra. Ũquɨ̃ nguiatu que Jesús cheẽ senei senei judío eã je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Dios quirãcuã ngue siqui tuchɨ embiirandusa rese ra. Nyebe que hue jenda tubɨrɨã Jesús ɨcua ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jesús quiato Jerusalén jenda que jirandu erese ra. Antioquía jenda rese. Nyebe Bernabé mondo Antioquíaa. ");
INSERT INTO srqNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bernabé que ngasẽ ñee Jesús quiato je ra. —Dios turã tuchɨ riqui nguiã jẽje co. Aque rese seyate riqui co. ¡Jẽɨngo tuchɨ nandererecua rese jẽ! ¡Jẽhuɨchɨ̃ nda esɨ jẽ! ɨ tuchɨ que Bernabé quia mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé turãt e que eriqui ra. Espíritu Turã ngue siqui tuchɨ erese ra. Ae que Dios ɨcua tuchɨ quia ra. Nyebe mbia tubɨrɨã ndiqui nguiã Jesús isi isi. ");
INSERT INTO srqNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Aquere que Bernabé sɨ Tarso ra. Oso que Saulo requia huee ra. Tea que ra. Nguerao que Antioquíaa ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Huee que echɨ beɨ Jesús quiato mbaaquiatu quiatu ra. Un año que echɨ huee ra. Mbia tubɨrɨã mbaaquiatu quiatu beɨ. Hue jenda je rane ngue “Cristianos” ɨ Cristo quiato je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Aque mose que Dios cheẽ mbuchecuasa mo ngaẽ Antioquíaa ra. Ngaẽ ngue Jerusalén sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Emo ngue juã ñee mbia je ra. Agabo, ɨ que ee ra. Espíritu Turã ngue Agabo mbucheẽ ñee nda. —Mbia chɨurã eã nda namo jiri. Mbia riãcuã ja ra cote, ɨ que Agabo ra. Echeẽ nguire tuchɨ que mbae ua cote ra. Mbia riãcuã tuchɨ que cote ra. Claudio mbia rerecua mose. ");
INSERT INTO srqNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nyebe Jesús quiato Antioquía jenda ñee ñee nyue. —Mbae mo nandemondo rã Jesús quiato Judea jenda je. Nandembae mbae mo nandemondo ee, ɨ que nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Eɨ̃ ngue umbae mondo mondo Judea jenda je ra. Mee mee ja que Saulo je ra. Bernabé abe je. Ũquɨ̃ ngue ecuruchoɨ cote ra. Ae emee nguiã Jesús quiato rerecua je. Judea jenda. ");
INSERT INTO srqNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Aque mose que ererecua ɨcuã tuchɨ riqui Jesús quiato je ra. Herodes, ɨ que ererecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ae que Jacobo ãquĩ ndoso ti quise je ra. Jacobo rei Juan nongue. ");
INSERT INTO srqNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Judíos ia tuchɨ que Jacobo ãquĩ ndoso mose ra. —Judíos tambiabe no, ɨ que ererecua ra. Nyebe Pedro abe isi nguiã. Fiesta de Pascua mose que Pedro isi nguiã. ");
INSERT INTO srqNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tarõ ngue mɨɨ mbia ɨcuã tarõsaa ra. Diez y seis soldados que chɨ eraarõ mbeɨ ra. —Pedro tamee je mbia je. Eɨquia sacuã. Fiesta ua mose r a amee ee, ɨ rei que ererecua uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nyebe que soldados Pedro tarõ ji raarõ tuchɨ u ra. Pedro resenda que ñee ñee tuchɨ Dios je ra. Jesús quiato mo. Ñee ñee tuchɨ que equia Pedro rɨɨ̃ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Isamamɨ nda ererecua Pedro mee nguiã mbia je chã nde. Eɨquia sacuã. —Isamamɨ nda amee mbia je, ɨ rei que Herodes ra. Aque isa que Pedro uque u soldados joõ ñɨ nda. Ecua ji que uque u ra. Cadena nyeremo je que ecua ɨno nda. Soldados nyeremo ngue uqueã u eraarõ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ibatenda mo ngue tu Pedro je isa ra. Angel. Nyaashɨ̃ na tuchɨ que tuchua ra. Mbae resae ja. Ibatenda que oco Pedro rese ra. Emumba. —¡Ehuã asi jẽ! ɨ que Pedro je ra. Ehuã mose que cadenas nyera eo sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","—Ndeɨrao emingue ja rã. Ndeiyao abe emingue, ɨ que ibatenda ee ra. Ae que Pedro emingue echeẽ mose ra. —Ndeɨrao aronda abe emingue. Nyao serese cote, ɨ que Pedro je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro que oso erese ra. Etaronda sɨ que Pedro rerao cote ra. —Seque re chõ aɨco rei co, ɨ rei que Pedro ra. Equereɨcuã eriqui reĩ nguiã ee. ");
INSERT INTO srqNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Eraarõsa cuaãcuã ngue echoɨ quia ra. Eraarõsa jiranua tuchɨ erese. Ngasẽ nyee que etaronda ɨcoɨ ra. Fierro que etaronda ra. Etaronda a e que nyeequia ee ra. Usẽ ngue ra. Pe jiri que echoɨ nyɨese ra. Ibatenda que oso Pedro recha cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","—Cu u eã ño eriqui re. Echecua chõ eriqui re, ɨ que Pedro eɨcua cote ra. —Dios chõ ibatenda mo mbu serirõ sacuã nde. Serirõ ño equia Herodes sɨ re. Judíos ra seɨquiayã cote, ɨ que Pedro uchɨangui re ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pedro que ndua ndua huɨ̃ nda. Ae esɨ nguiã María chuchúaa. María rei Juan Marcos si. Mbia tubɨrɨãte que chɨ ñumunua huee ra. Ñee ñee ngue u Dios je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro que ngasẽ eɨquesa mbuu mbuu ra. Nyucuaaque mo ngue oso rei ee ra. Rode, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedro cheẽ ngue eɨcua ra. Eya tuchɨ que nyebi asi oso mbia mbiirandu ra. Eɨquesa equia rocoɨ̃ Pedro je. —Hue Pedro ñɨ taicuee hue, ɨ que embiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","—Tei. Echeẽ ñooñoa na, ɨ chõ ngue mbia Rode je ra. —Ae beɨte. Acheẽ ñooñoa ño jẽje re, ɨ tuchɨ Rode. —Pedro eã ño ñene. Eãingue chõ ñee ndei ndeje, ɨ ja rei que mbia nyucuaaque je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Eɨquesa que Pedro mbuu mbuu beɨ huɨ̃ mbia je ra. Emo ngue oso cheete rei eequia ee ra. Pedro que ɨque cote ra. Ñumunua je que nyuruɨra tuchɨ mae erese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedro que mbia mbuquɨrɨrɨ o je ra. Mbae que esenei ja ee cote ra. —Eɨ̃ ngue Dios serirõ setarõsa sɨ ra, ɨ que erenei nenei ja ee ra. —Jacobo jembiirandu ja rã serese. Jesús quiato ja jembiirandu, ɨ que Pedro ra. Pedro que oso mbia recha cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Isamamɨmbe que soldados pare pare ɨ tuchɨ ra. Pedro oreã ndese mae. —¿Mañɨ Pedro usẽ nde? ɨ que u ñee ñee nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes que ñee nda. Ererecua. —Pedro jendu rã seje, ɨ rei que soldados je ra. Pedro oreã ngue ee ra. —Sembiirandu ja rã se. ¿Mañɨ Pedro sɨ usẽ nde? ɨ que ererecua soldados je ra. Soldados que eɨcuayãte ee ra. Nyebe que ererecua soldados ɨquia nguiã. Pedro raarõsa ɨquia ja. Aquere que Herodes sɨ siri Cesaréaa ra. Judea sɨ siri. ");
INSERT INTO srqNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes que mbia chɨurã mondo mondo Tiro jenda je nyii ra. Sidón jenda je abe no. Paama ɨ que ee cote ra. Nyebe echɨurã mondo monoa ee cote. Nyebe que ũquɨ̃ nyoɨ ja Herodes chuchúaa ra. —¡Nandeturã mbeɨ chõ ee jẽ! Ɨ̃ nda nandechɨurã mondobe nande je, ɨ que nyue ra. Herodes resenda mo ngue ñee turã ee ra. Blasto, ɨ que aque je ra. —Echeẽ turã turã Herodes je ure rɨɨ̃. Ɨ̃ nda eturambe ure je, ɨ que mbia Blasto je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Emo mose jiri que Herodes huɨɨrao turã mingue ra. Ngoi que ngũenda ɨcoɨ tose ra. Jenyu seje, ɨ que Tiro jenda je cote ra. Sidón jenda je abe no. Herodes que ñee ocote ũquɨ̃ je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mbia abe que ñeete ee cote ra. —Dios chõ nde resẽ. Dios cheẽ na sɨ nde. Mbia cheẽ na eã, ɨ que mbia Herodes mbucuasu ɨ ɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","—Dios eã ño se re, ɨ eã mbeɨ que Herodes mbia je ra. Ñee turã eã ngue equia Dios rɨɨ̃ nda. Nyebe Dios embasi nguiã. Nyebe Dios ángel mo mbu nguiã Herodes mbasi tuchɨ. Erosei que erie u ra. Eɨquia nonde. Mano ngue cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Jesús quiato que Jesús cheẽ senei senei tuchɨ quia ra. Mbia tubɨrɨã ngue echandu chandu quia ra. Mbia tubɨrɨã ngue Jesús ɨcua ɨcua quia cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé que nyoɨ Jerusalén nda. Saulo rese. Mbae isiquia ruruchoɨ sacuã. Mbae isiquia que emee mee Jesús quiato hue jenda je cot e ra. Nyoɨ que Antioquíaa cote ra. Juan Marcos abe que ecuruchoɨ nyɨese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jesús quiato que ñumunua nua nguia Antioquía jenda ra. Mbia mbaaquiatu quiatusa abe que chɨ erese ra. Dios cheẽ mbuchecuasa mo abe que chɨ erese ra. Bernabé, ɨ que emo je ra. Simón nondeɨ abe que ra. Lucio de Cirene abe que ra. Manaén abe que ra. Ae rei que Herodes resenda eñetẽ mose ra. Herodes ererecua nonde. Saulo abe que ra. Ũquɨ̃ ja que mbia mbaaquiatu quiatusa ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Emo mose que ũquɨ̃ nyɨ ñumunua nda. Ñee ñee ngue u Dios je ra. Uchɨu sɨ que huɨ ra. Ndua ndua sacuã Dios rese. Aque mose que Espíritu Turã ñee ee ra. —Bernabé jemee na seje. Saulo abe jemee na seje no. Ũquɨ̃ ngue airabo ra. Airabo que secheẽ nenei nenei sacuã nda, ɨ que Espíritu Turã ñee ñumunua je je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mbia que ñee turã mbeɨ Dios je ra. Quiaruã mbeɨ que u ra. O que echono ñono Bernabé ãquĩ ndese cote ra. Saulo ãquĩ ndese abe no. Mondo que Dios cheẽ nenei nenei sacuã cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Aquere que Espíritu Turã Bernabé curuchoɨ Selúciaa ra. Saulo rese. —Ama nduɨ nyao Chipre, ɨ que ua canoa cuasu ye ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ngasẽ ngue sucha tubɨrɨã Salamina nda. Salamina ndei Chipre jenda mo. Judíos chumunuasaa que echoɨ Dios cheẽ nenei nenei nda. Juan Marcos abe que siqui erese Dios cheẽ nenei nenei nda. ");
INSERT INTO srqNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tuchua que embuchesea sea tuchɨ ra. Ngasẽ nyee Pafos. Huee que brujo mo ndiqui ee ra. Barjesús, ɨ que brujo je ra. Judío mo ndei aque brujo. —Dios cheẽ mbuchecuasa rei se, ɨchõɨño mbeɨ que equia mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Brujo que siqui ererecua rese ra. Sergio Paulo, ɨ que ererecua je ra. Ererecua aquiatu tuchɨ que ra. —Jenyu, Dios cheẽ tachandu rã, ɨ que ererecua Bernabé je ra. Saulo je abe no. ");
INSERT INTO srqNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Brujo que Bernabé cheẽ siquisã nda. Pablo cheẽ abe riquisã. —Ɨ̃ nda sererecua Jesús ɨcuayã, ɨ tuchɨ brujo ũquɨ̃ ñee ndiquisã. Elimas, ɨ abe que brujo je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Espíritu Turã ngue siqui tuchɨ quia Pablo rese ra. Pablo, ɨ abe que equia Saulo je ra. Pablo que ma e quiatu brujo rese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ñee ngue ee ra. —Mbia mbɨɨrɨ̃ ɨrɨ̃sa tuchɨ quiarei nde. Diablo resenda tuchɨ quiarei nde. Mbae turã ndesenda reã tuchɨ quiarei nde. ¿Mbaerã ereɨco mbia riquisã quisã Dios ɨcha sɨ re? ¿Manose ra erehuɨ ũquɨ̃ sɨ re? ɨ que Pablo ñee ɨcuã ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","—Dios ra nembasi tuchɨ cote. Nderesayra cote. Tenda rese ra ereɨco mae eã are jiri, ɨ que Pablo brujo je ra. Echeẽ mosebe que eresa uque tuchɨ ra. Mae eã mbae rese cote. —Jenyiba taisi. ¡Sembucuata turã na nguia jẽ! ɨ tuchɨ eresayã nguia mbia je cote. ");
INSERT INTO srqNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ererecua que echandu ja ra. Nyebe ngue Jesús ɨcua nguiã cote. Nyuruɨra tuchɨ que huɨ̃ Jesús cheẽ andu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo que nyoɨ Pafos recha cote ra. Nguesenda rese que echoɨ ama nduɨ ra. Ngasẽ ngue Perge de Panfíliaa ra. Huee sɨ que Juan Marcos sɨ nyebi Jerusalén nda. Pablo recha. Bernabé abe recha. ");
INSERT INTO srqNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Emo mose que echoɨ Perge sɨ ra. Ngasẽ ngue sucha tubɨrɨã Antioquíaa ra. Pisidia, ɨ que hue ibi je ra. Sábado mose que ɨque judíos chumunuásaa ra. Huee que echɨ ngoi ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Judíos que leer ɨ Dios cheẽ je ra. Moisés chɨmbesa je. Dios cheẽ mbuchecuasa chɨmbesa je abe no. Aquere que judíos ñee Pablo je ra. Bernabé je abe no. —¿Mbia ra jembaaquiatu quiatu jẽ nde? ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pablo que juã cote ra. O je que mbia mbuquɨrɨrɨ ra. Ñee ngue ee cote ra. —Seandu rã se, Israelitas. Seandu rã se, Dios quiato. ");
INSERT INTO srqNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dios que Israelitas rerecua ra. Dios que nanderameɨ cose ndare irabo ra. Siqui tuchɨ que equia nanderameɨ ndese ra. Nanderameɨ chɨ mose Egipto. Dios que nanderameɨ mbeta mbeta ra. Dios quirãcuã ngue nanderameɨ sirõ nyee Egipto sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dios que nyecuachõ tuchɨ quia nanderameɨ je ra. Cuarenta años que eriqui nyecuachõ tuchɨ ra. Nanderameɨ chɨ mose turuquia. ");
INSERT INTO srqNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Sucha tubɨrɨã jenda que mano ja mbiamo nda. Dios que eɨquia ja ra. Siete rei sucha tubɨrɨã. Canaán jenda. Dios que ũquɨ̃ ɨquia ja nanderameɨ sɨ ra. Ũquɨ̃ mbae ibi que Dios mee nanderameɨ je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Dios que jueces mɨɨ mɨɨ nanderameɨ nderecuarã cote ra. Jueces que emɨɨ mɨɨ nguia cuatro cientos cincuenta años nda. Aquere que Dios Samuel mɨɨ nanderameɨ nderecuarã nda. ");
INSERT INTO srqNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Aquere que nanderameɨ ñee Dios je ra. “Rey mo nguia emɨɨ urererecuarã”, ɨ que Dios je ra. Nyebe que Dios Saúl mɨɨ ererecuarã nda. Rey. Ae rei Cis riirĩ. Cis rei Benjaminito. Saúl que siqui arete nanderameɨ nderecuarã nda. Cuarenta años que eriqui ererecuarã nda. ");
INSERT INTO srqNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Cuarenta años ua mose que Dios Saúl mombo cote ra. Dios que David mɨɨ nanderameɨ ndere cuarã cote ra. Saúl rendaque re. David rei Isaí riirĩ. Dios que ñee David je ra. “David sebi tuchɨ. Ae quia ra secheẽ mumba mumbayã”, ɨ que Dios cose ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","David sɨ́ que Jesús rameɨ nda. Dios que Jesús mbu Israel jenda rirõ sacuã huɨɨcuã sɨ ra. Ucheẽ nguire que Jesús mbu ra. Dios que ucheẽ mbuchebiã nda. ");
INSERT INTO srqNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesús tu nonde que Juan Bautista riqui ñee ñee nanderameɨ je ra. Israel jenda je. “Jẽɨcuã sɨ jẽhuɨ. Jemba Dios ɨcha ruɨ. Ɨ̃ nda bautizar ae jẽje”, ɨ tuchɨ que Juan nguia mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Umano nonde que Juan ñee mbia je ra. “Ae jẽsaarõ nguia nae, ae eã ño se re. Ae ra tu seruɨ. Ae rei ererecua tuchɨ sesɨ. Se oco aronea eiyao rese”, i que Juan ñee Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Seresenda, Abraham ndiirĩ ndei jẽ. Jemo ndiqui Dios ɨcua ã. Nande je quia Dios ucheẽ mondo nguiã. Nanderirõ sacuã nandeɨcuã sɨ. Dios que Jesús mondo nande je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalén jenda que Jesús ɨcuayãte ra. Ererecua ja que chɨ Jesús ɨcuayãte ra. Dios cheẽ mbesa ji abe que eɨcuayãte ra. Eraã naa mbeɨ raque sábado mose, eɨcuayã mbeɨ. Dios cheẽ mbuchecuasa cheẽ nguire que Jesús ɨquia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","“Jesús eɨquia rã”, ɨ tuchɨ que mbia quia Pilato je ra. Jesús ɨcuã eã ndaque. ");
INSERT INTO srqNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nyebe que Jesús mano ndei ra. Embesa ji cheẽ nguire que Jesús mano nda. Jesús raaque que embuquichi ira sɨ cote ra. Ñono ngue sɨta rɨbɨcoɨ ji ye ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Jesús que quera sɨ manonde cote ra. Dios que embuquera sɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galilea jenda que siqui beɨ quia Jesús rese Jerusalén nae, ũquɨ̃ ngue mae mae equera sɨ rese cote ra. Mae mae mbeɨ equia Jesús quera sɨ rese cote. Ũquɨ̃ ñee mbeɨ quia Jesús rɨɨ̃ ã cote. ");
INSERT INTO srqNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","A ureɨco Dios cheẽ turã nenei nenei jẽje a. Dios ñee ñee nguia nanderameɨ je nyii nae, ũquɨ̃ uresenei senei nguia jẽje a. ");
INSERT INTO srqNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nande je que Dios Jesús mbuquera sɨ ra. Ucheẽ nguire que embuquera sɨ ra. Dios ñee ñee nguia nanderameɨ je nyii nae, eɨ̃ sɨ que Jesús mbuquera ra. “Nde rei serucucha. Namo ngue arembuchecua mbia je ra”, ɨ que Dios Jesús rɨɨ̃ cose ra. Eɨ̃ ngue Salmo dos nda. ");
INSERT INTO srqNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios que Jesús mbuquera sɨ ra. Jesús roo ra soõ eã mbeɨ cote. Nyebe que Dios ñee nyii ra. “Seturãte ra jẽje. Seturã David je nyii nae, eɨ̃ sɨ ra seturãte jẽje”, ɨ que Dios ra. “Jesús tambuquera sɨ jẽje”, ɨ ñene. ");
INSERT INTO srqNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Co abe rei embesa ji. Ã ndei e ã: “Se rei Ibatenda rucucha turã. Ibatenda ra seroo sechayã. Seroo ra emoo eã. Sembuquera sɨ rae”, ɨ que embesa ji ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David que siqui turã mbeɨ quia uchabenda ja je ra. Dios cheẽ nguire que eriqui turã ee ra. Aquere que mano nda. Mbia que echati ngãmeɨ jii rɨ̃ nda. Aquere que David roo soõ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jesús roo quiatu que soõ eã nda. Dios que embuquera sɨ resẽ. Nyebe ae roo soõ eã nguiã. ");
INSERT INTO srqNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Seresenda, Jesús mɨɨ ndiqui nandeɨcuã mbutiã sacuã co. A ureɨco ũquɨ̃ nenei nenei jẽje a. Jẽirandu sacuã erese. ");
INSERT INTO srqNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Dios que ucheẽ senei senei nguia Moisés je nyii nae, aque cheẽ nguia r a aba ɨcuã mbutiã eã. Jesús mɨɨ ndiqui nandeɨcuã mbutiã sacuã co. Nande Jesús ɨcua mose. ");
INSERT INTO srqNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","“Mbae ɨcuã nda tuchɨ̃ jẽje”, ɨ que Dios cheẽ mbuchecuasa ra. Jẽtesa beɨ u jẽ. Sã Dios cheẽ mbuchecuasa ɨo eã jẽje. Eɨ̃ ngue Dios cheẽ mbuchecuasa ra: ");
INSERT INTO srqNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Co jẽ, mbae turã ucuayãsa. Je nyuruɨra rae. Jemano ndae. Mbia mae sayã nda asaã ndaque jẽje. Jẽɨcua sereãte ra equia. Mbia embuchecua raque jẽje. Nyebe ra jemano, ɨ que Dios cose ra, ɨ que Pablo ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pablo que usẽ nyoɨ echumunuasa sɨ cote ra. —Jenyube rã sábado nongue. Ũquɨ̃ jẽsenei seneimbe rã u ure je, ɨ que mbia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mbia que usẽ ja echumunuasa sɨ cote ra. Judíos tubɨrɨã ngue nyoɨ Pablo ruɨ ra. Bernabé ruɨ abe no. Judíos resenda tubɨrɨã abe no. Pablo que ñee tuchɨ mbia je ra. Bernabé rese. —Dios rese jẽɨngo tuchɨ jẽ, ɨ tuchɨ que equia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sábado nongue mose que sucha tubɨrɨã jenda ñumunua ja ra. Ñumunua nua ja Dios cheẽ andu. ");
INSERT INTO srqNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Judíos mo ngue chɨ mae mae mbia chumunua ndese ra. —Pablo cheẽ ño echanduchɨ̃ nguiã. Nandecheẽ andu rocoɨ̃, ɨ que judíos ngueteã mbia rese Pablo sɨ ra. Nyebe judíos ñee ɨcuã ɨcuã nguiã Pablo je. ");
INSERT INTO srqNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pablo que siquicheã tuchɨ ñee judíos je ra. Bernabé rese. —Jẽ nane je ureɨco rei Dios cheẽ nenei nenei ã. Dios cheẽ nguire ureɨco rei nguiã erenei nenei jẽ nane je ã. Ibate jẽɨngo beɨ sereã ñochɨ̃. Nyebe jẽɨngo nguiã Dios cheẽ isiteã teã ã. Nyebe ureso nguiã erenei nenei judíos eã je co. ");
INSERT INTO srqNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ã ngue Dios ñee ure je cose ra: “Aremingo que secheẽ nenei nenei sacuã mbia ja je ra. Judíos eã ja je. Mbia ibi jenda ja je. Secheẽ isiquia ra siqui beɨ”, ɨ que Dios ure je ra, ɨ que Pablo ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Judíos eã ia tuchɨ que Pablo cheẽ ndese ra. Ñee turã turã ngue Dios cheẽ nɨɨ nda. Dios que mbia irabo ata ra. Emingo beɨ sacuã ibate. Ũquɨ̃ ngue Jesús ɨcua ja cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Hue jenda ja que embucha mbucha quia Dios cheẽ nenei nenei nda. ");
INSERT INTO srqNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Judíos que mbia mbuqueta queta tuchɨ Pablo je ra. Bernabé je abe. Ari mbia chɨɨcua mbuqueta tuchɨ que ra. Ameɨ mbia chɨɨcua abe mbuqueta que ra. Nyebe mbia paama ɨ ja Pablo je. Bernabé je abe. Nyebe Pablo mombo nguiã hue sɨ. Bernabé abe mombo no. ");
INSERT INTO srqNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nyoɨ nonde que hui tubi mbutomo tomo mbia je ra. —Jẽɨcuã tẽɨcua, ɨ ñe hue jenda je re. Aquere que echoɨ Iconio nda. ");
INSERT INTO srqNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jesús quiato ia tuchɨ que chɨ ra. Espíritu Turã ngue siqui tuchɨ quia erese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablo que ngasẽ Iconio nda. Bernabé rese. Judíos chumunuasa que echoɨ ra. Dios cheẽ ngue esenei senei huee ra. Nyebe que judíos tubɨrɨã Jesús ɨcua ra. Judíos eã abe que eɨcua no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Judíos ataque que Jesús cheẽ isiteã teã no nda. Ũquɨ̃ ngue judíos eã mbɨɨcuã ɨcuã Pablo je ra. Bernabé je abe no. Ñee ɨcuã ɨcuã tuchɨ erɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pablo que chɨ arete huee ra. Bernabé abe no. Siquicheã tuchɨ que equia Dios cheẽ nenei nenei nda. Ebia tuchɨ Dios rese. Dios que embuquirãcuã nda. Nyebe que eriqui mbia mae sayã naa naa nda. —Ɨchõɨño eã ño equia re, ɨ chee mbia Pablo cheẽ je. Bernabé cheẽ je abe no. ");
INSERT INTO srqNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mbia cuabẽ ndua turã ja eã. Emo emo ngue siqui Jesús resenda ruɨ ra. Emo emo ngue siqui judíos ruɨ no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nyebe judíos ɨcuã ɨcuã Pablo je. Pablo resenda je abe no. Judíos eã abe eɨcuã ɨcuã ee no. Mbia rerecua abe que eɨcuã ɨcuã ee ra. —¡Pablo nandeɨquia jẽ! ¡Bernabé abe nandeɨquia jẽ! ¡Sɨta nande mombo mombo erese jẽ! ɨ rei que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pablo que jirandu erese ra. Bernabé abe. Nyebe echoɨ uchã sucha tubɨrɨã mo. Licaonia jenda. Listra, ɨ sucha tubɨrɨã mo je. Derbe, ɨ emo je. Hue rurubi que echoɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Hue jenda je que Dios cheẽ nenei nenei nda. ");
INSERT INTO srqNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ngasẽ ngue Listra ra. Huee que emo ngatayã ñɨ ee ra. Eɨtãquieɨ̃ mosenda beɨ ei ɨcuã. Nyebe ngatayã mbeɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Aque que Pablo cheẽ ñandu ra. —Sembucherõ arõ, ɨ ndua uchɨangui re. Pablo que eɨcua ra. Nyeb e mae nguiatu erese. ");
INSERT INTO srqNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ñee nyecua que ee ra. —Ehuã ndei rese, ɨ que Pablo ee ra. Ecuatayã ngue juã asi ngata cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mbia tubɨrɨã ngue chɨ mae Pablo chɨmbucherõ ndese ra. Nyebe ucheẽ naa naa u nyue. Pablo rɨɨ̃ ñee ñee. —Dios ngaẽ nguichi nande je mbia rã sɨ́ a, ɨ rei que nyuruɨra ra. Tasẽ tasẽ. Licaonia, ɨ hue jenda cheẽ je. ");
INSERT INTO srqNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mercurio reɨ̃ nda Pablo mbia je. Mercurio, ɨ mbia umbae dios mo je. Pablo que ñee mbeɨte quia ra. Nyebe “Mercurio” ɨ mbia ee. Jupiter reɨ̃ nda Bernabé mbia je. Jupiter, ɨ mbia umbae dios mo je no. ");
INSERT INTO srqNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Hue jenda que ñumunua nua nguia ñee ñee Jupiter je ra. Ae ñee ñee nguia Jupiter je, aque que ticuasu quimbae queru Pablo je ra. Ira uti resebe ereru ee. —Ticuasu nandeɨquia ɨquia rã Pablo je. Nandesei sei ee, ɨ ja que mbia ra. —Pablo rei Dios rã sɨ. Bernabé rese. Nyebe ticuasu nandeɨquia ɨquia rã ee. Dios raanguia je, ɨ rei que mbia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pablo que echandu ra. Bernabé rese. Nyebe huɨɨrao ndoro ndoro paama ɨ ee. —Ureya eã jendese, ɨ ñe ne. Ɨque que echoɨ mbia ite ite rɨ̃ nda. Ñee asi asi mbia je. ");
INSERT INTO srqNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¿Mbaerã nda re, mbia? ¿Mbaerã nda ticuasu jẽɨquia ure je re? Mbia chõ ure re. Jẽ na sɨ chõ ure resẽ. Dios eã ño ure resẽ. Nyebe urechu nguiã Dios cheẽ turã nenei nenei jẽje ã. Ã mbae ɨcuã jẽsecha ja chõ. Dios quiarei ereco. ¡Ae ruɨ jẽɨngo! Ae que ibei chao ra. Ae que ibi chao no nda. Ae que ama nyao no nda. Ae que mbae chao ja ra. Mbae aosa ruɨ jẽɨngo. ");
INSERT INTO srqNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dios que mbia teachõ cose ra. Mbia tesareɨ mose esɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Dios que eturã saã saã mbeɨ quia mbia je ra. Mbi a eɨcua sacuã. Dios chõ ama mbuchaaqui beɨ nguiã nande je. Ae quia mbae a mee mbeɨ nguiã nandechɨurã. Dios chõ nandembia mbia beɨ nguiã co, ɨ que Pablo mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Eɨ̃ ngue Pablo embiirandu Dios rese ra. Nyebe que mbia ticuasu ɨquia eã nyee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Emo jiri mose que judíos ngaẽ huee ra. Antioquía sɨ. Iconio sɨ abe no. Ũquɨ̃ ngue mbia mbɨɨcuã ɨcuã Pablo je ra. Nyebe que mbia sɨta mombo mombo tuchɨ Pablo rese ra. Pablo manote reɨ̃ nguiã ee. Mbia que ecuruchoɨ mbutiriri pe jiri sucha tubɨrɨã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Hue que Jesús ɨcuasa chɨ Pablo matãte hue ra. Pablo que juã quera cote ra. Osobe que nyebi sucha tubɨrɨã nda. Isamamɨ ngue esɨ Derbe ra. Bernabé rese. ");
INSERT INTO srqNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Dios cheẽ turã ngue esenei senei nguia huee ra. Derbe jenda je. Mbia tubɨrɨã ngue Jesús ɨcua hue jenda cote ra. Aquere que nyebi Lístraa ra. Icónioo abe. Antioquíaa abe. Huee sucha tubɨrɨã ngue echoɨ nyebi ra. ");
INSERT INTO srqNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pablo que Jesús ɨcuasa mbaaquiatu quiatu hue jenda ra. Bernabé rese. —¡Jesús rese jẽɨngo tuchɨ jẽ! Mbia ra nandembasi mbasi tuchɨ. Aquere ra Dios nandererecuarã tuchɨ cote, ɨ que Pablo mbia je ra. Bernabé rese. ");
INSERT INTO srqNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ameɨ mo ngue eirabo rabo mɨɨ ɨno huee ra. Jesús ɨcuasa rerecuarã no hue. Ñumunua je rerecuarã jaaja. Aquere que huɨ uchɨu sɨ ra. Quiaruã. Ñee ñee ngue equia Dios je ra. Ñee ñee ee ererecua namonda rɨɨ̃. —Ã jẽɨngo Dios ɨcuate ã. Sã Dios jendaarõ arõ, ɨ que Pablo ererecuarã je ra. Bernabé rese. ");
INSERT INTO srqNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nyoɨ que erecha cote ra. Pisidia, ɨ equia ibi je, hue rɨ̃ ngue echoɨ ra. Ngasẽ ngue Panfilia no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Jesús cheẽ turã ngue esenei senei sucha tubɨrɨã Perge jend a je ra. Aquere que echoɨ Atalia no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Hue sɨ que echoɨ ama nduɨ ra. Nguique riita quiti que ecuaẽ tiba Antioquía cote ra. Mbia hue jenda rane nguiatu que Pablo mondo Bernabé rese Dios cheẽ nenei nenei sacuã nyii ra. —Chã Dios turã jendeaquiatu jẽso mose, ɨ que ee nyii ra. Huee que tiba obei cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ngasẽ mose Antioquíaa, Jesús ɨcuasa que emunua nua cote ra. Mbae ja que esenei tuchɨ ee ra. —Dios que urereaquiatu tuchɨ quia ra. Dios que urembucheẽ ñee nguia judíos eã je ra. Dios que Jesús ɨcua tuchɨ ee ra. Nyebe etubɨrɨã ndiqui nguiã Jesús ɨcua cote, ure echeẽ nenei nenei mose, ɨ que Pablo ra. Bernabé rese. ");
INSERT INTO srqNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Chɨ arete que Antioquíaa ra. Jesús ɨcuasa ja rese echɨ huee. ");
INSERT INTO srqNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Judea jenda mo ngue ngaẽ Antioquíaa ra. Ngaẽ ngue Jesús ɨcuasa mbaaquiatu quiatu ɨcuã nda. —Circuncisión jẽsaã saã ja. Moisés cheẽ nguire jẽsaã saã, ɨ rei que Jesús ɨcuasa je ra. Eracoɨ̃ ɨre o ji je chõ eriqui nguiã circuncisión, ɨ ũquɨ̃ je. —Eɨ̃ jenye eã mose ra jẽsoã ibate, ɨ rei que ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","—Tei, eɨ̃ eã ñene, ɨ tuchɨ que Pablo ee ra. Bernabé rese. —Ae beɨte. Pablo ñee ñooño nguiã, ɨ tuchɨ Judea jenda. Nyebe ñee tuchɨ nguiã nyue circuncisión nɨɨ. Nyebe Jesús ɨcuasa mondochoɨ Jerusalén. Jirandu sacuã circuncisión ndese. Pablo mondochoɨ. Bernabé abe no. Mbia mo abe no. Ũquɨ̃ mondochoɨ ja. —Jẽso Jerusalén. Jeñee Jesús quiato rerecua je. “¿Circuncisión nda uresaã saã nde?” jenye oso ee. Sã Jesús quiato rerecua ñee jẽje. Jenyu ñee ure je cote, ɨ que ñee uchɨmondo je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jesús ɨcuasa que embucuata turã cote ra. Mondochoɨ Jerusalén. Fenicia ruɨ que echoɨ ra. Samaria ruɨ abe no. Judíos eã je rese que hue jenda mbiirandu randu ra. —Judíos eã abe que Jesús isi isi quia cote ra. Judíos eã ngue huɨ huɨ quia huɨɨcuã sɨ cote ra, ɨ que hue jenda mbiirandu randu ra. Jesús ɨcuasa ia tuchɨ que eandu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pablo que ngasẽ Jerusalén cote ra. Bernabé rese. Nguesenda rese no. Hue jenda Jesús ɨcuasa que eisi turã nda. Jesús quiato rerecua abe que eisi turã no nda. Pablo que Dios turã senei senei ee ra. —Dios quirãcuã ngue siqui quia ure rese ra. Ure echeẽ naa naa mose, ɨ que embiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Fariseos Jesús ɨcuasa mo ngue juã ñee cote ra. —Judíos eã Jesús ɨcua mose, circuncisión jẽsaã saã ee. Jeñee na ee. “Moisés cheẽ nduɨ jẽɨngo beɨ”, jenye chõ ee, ɨ rei que Fariseos ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nyebe Jesús quiato rerecua ñumunua ja aque rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ñee ñee tuchɨ nyue circuncisión nɨɨ. Aquere que Pedro juã ñee nda. —Tacheẽ se, Seresenda. Dios que seirabo cose ra. Ucheẽ turã nenei nenei sacuã judíos eã je. Ũquɨ̃ Jesús ɨcua sacuã ngue seirabo cose ra. Ũquɨ̃ jẽɨcuate quia ã. ");
INSERT INTO srqNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dios quia aba chɨã ɨcua jate nguiã co. Judíos eã je abe Dios Espíritu Turã mondo mondo cote. Nande achõ je eã emondo. Ũquɨ̃ abe je emondo mondo Jesús ɨcua mose no. “Judíos eã abe sequiato”, ɨ ñe Dios re. ");
INSERT INTO srqNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Judíos eã Jesús ɨcua mose, Dios ũquɨ̃ ñɨa mbiasu cote. Nande rã sɨ. Nyebe Dios riqui nguiã judíos eã je abe siqui turã. Nande rã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Mbaerã jẽɨngo Dios cheẽ abi abi chõ nde? Dios cheẽ jembeta mbeta chõchɨ̃ nguia re. Judíos eã je chõ jẽɨngochɨ̃ embeta re. Embeta ji chɨ̃ nda eãtã tuchɨ aba je cot e re. Ũquɨ̃ nanderu cose ndare saã aroneate. ");
INSERT INTO srqNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Dios turã nguia nandemɨngo beɨ nguiã ã. Dios turã nguia nandemɨngo beɨ nguiã ibate. Nande Jesucristo ɨcua mose. Dios turã nguia judíos eã abe mɨngo beɨ nguiã ã no. Nande rã sɨ no, ɨ que Pedro ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pablo que mbae senei ja mbia je cote ra. Bernabé rese. Mbia tubɨrɨã ngue quɨrɨrɨ cote ra. Nyiisaquia que Pablo cheẽ ndese ra. Bernabé cheẽ ndese abe. —Dios que urererao judíos eã je ra. Urembirãcuã tuchɨ que equia ee ra. Nyebe mbia mae sayã uresaã saã tuchɨ ee, ɨ que Pablo ra. Bernabé rese. ");
INSERT INTO srqNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pablo cheẽ huɨre que Jacobo ñee cote ra. —Seandu rã se, Seresenda. ");
INSERT INTO srqNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pedro que ñee jẽje namo nda. Dios turãte que judíos eã je ra. Dios que ũquɨ̃ mo irabo rabo nguesendarã nda. Pedro que jembiirandu erese namo nda. ");
INSERT INTO srqNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Eɨ̃ ngue Dios cheẽ mbuchecuasa embesa cosete ra. Nyebe eriqui nguiã eɨ̃ eɨ̃ ã cote. ");
INSERT INTO srqNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ã ndei embesa ji ã: Se rei Dios. David reco mose que serimba siqui tuchɨ serese ra. Aquere huɨ ja sesɨ cote. Achube ra echɨã mbitirõ sɨ cote. Siqui sɨ ra serese cote. ");
INSERT INTO srqNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Judíos eã abe ra siqui serese cote. Mbia sembaerã nda siqui ja serese cote, ɨ que Dios ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Eɨ̃ ngue Dios ñee mbia mbiirandu cose ra, ɨ que Jacobo ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","—Judíos eã mo ngue Dios ɨcua ɨcua quia cote ra. ¡Nandecheẽ nandembetayã jiri ee jẽ! ");
INSERT INTO srqNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","¡Nandecheẽ mɨɨ ño nandembesa mondo ee jẽ! Nandecheẽ mumbayã sacuã. “Mbia soo mondo mondo mose dios raanguia je, ¡aque soo ra jẽuchɨ̃ jẽ!” nande rã ee. “¡Jeninisi rese siqui rocoɨ̃ nda jẽɨngochɨ̃ emo ndese jẽ! ¡Jendu rese siqui rocoɨ̃ nda jẽɨngochɨ̃ emo ndes e jẽ!” nande chõ ee. “¡Eruqui resebe ra soo jẽuchɨ̃ jẽ! ¡Mbae ruqui ra jẽuchɨ̃ jẽ!” nande chõ ee. Ũquɨ̃ mɨɨ nandembesa rã mondo ee. Nandecheẽ mumbayã sacuã. ");
INSERT INTO srqNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ũquɨ̃ mɨɨ nande rã ee. Ũquɨ̃ ño mbia ñandu ñandu mbeɨ quia cose ndare beɨ. Mbia Moisés chɨmbesa saã saã sucha tubɨrɨã ja je. Sábado mose beɨ. Judíos chumunua nua mose, ɨ que Jacobo ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","—Coche ñene, ɨ ja Jesús quiato rerecua Jacobo cheẽ je. Jesús ɨcuasa ja abe. Nyebe mbia nyeremo mondo Pablo rese. Bernabé rese abe. Silas, ɨ que ee ra. Judas, ɨ que enongue je ra. Barsabás, ɨ abe que equia Judas je ra. Ũquɨ̃ ndei Jesús quiato rerecua mo. Ũquɨ̃ ngue emondo Antioquíaa ra. —Urecheẽ jẽsenei senei Jesús ɨcuasa hue jenda je, ɨ que Jerusalén jenda ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Jesús ɨcuasa que ucheẽ mbesa mondo ee ra. A rei embesai a: —Ure rei Jesús quiato rerecua. Ure rei Jesús ɨcuasa. A ureɨco embesa mbesa jẽje a, Jesús ɨcuasa. Judíos eã je. Antioquía jenda je. Siria jenda je. Cilicia jenda je. Saludos. ");
INSERT INTO srqNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ureresenda mo ngue nyoɨchɨ̃ jembaaquiatu ɨcuã ɨcuã nda. Ũquɨ̃ ñee jemɨngo asi asite rei. “Circuncisión jẽsaã saã”, ɨ chõchɨ̃ equia jẽje reaẽ. “Moises cheẽ nduɨ jẽɨngo beɨ”, ɨ chõchɨ̃ equia jẽje re. Ũquɨ̃ uremondo eã ñee jẽje. Ae ae chõ nyoɨ nguiã ñee ñooño jẽje. ");
INSERT INTO srqNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nyebe ureɨco nguiã ñumunua a. Emo ngue ureirabo emondo sacuã jendea ra. Nyeremo uremondo quia aque. Pablo rese. Bernabé abe rese. Urequiato tuchɨ que ũquɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ũquɨ̃ ɨreɨ̃ ɨreɨ̃ eã tuchɨ nyoɨ Jesucristo cheẽ nenei nenei. Mbia eɨquia arondete raque. Siquicheã tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Aque Judas uremondo quia jendea aque. Silas rese. Ũquɨ̃ nda jembiirandu ja. Ũquɨ̃ nda urecheẽ senei senei jẽje. ");
INSERT INTO srqNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Espíritu Turã ngue urembaaquiatu ra. Nyebe ra urecheẽ tuchɨã jẽje. Echeẽ mumbayã sacuã. Ã mɨɨ ño uremondo quia jẽje aque. ");
INSERT INTO srqNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","“Mbia soo mondo mondo mose dios raanguia je, ¡aque soo ra jẽuchɨ̃ jẽ! ¡Eruqui resebe ra soo jẽuchɨ̃ jẽ! ¡Mbae ruqui ra jẽuchɨ̃ jẽ! ¡Jeninisi rese siqui rocoɨ̃ nda jẽɨngochɨ̃ emo ndese jẽ! ¡Jendu rese siqui rocoɨ̃ nda jẽɨngochɨ̃ emo ndese jẽ!” Coche ũquɨ̃ jemumbayã nguiã. Aque mɨɨ ño urecheẽ urembesa mondo aque, ɨ que embesa ra. Eɨ̃ ngue Jerusalén jenda embesa ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Uchɨmondo que emondochoɨ turã nda. Ngasẽ ngue Antioquíaa cote ra. Jesús ɨcuasa hue jenda que emunua ja ra. Embesa ji que emee ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Echumunua mos e que leer ɨ ee cote ra. Eya tuchɨ que erese ra. Eya tuchɨ Jerusalén jenda chɨmbesa isi mose. ");
INSERT INTO srqNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Dios cheẽ mbuchecuasa rei Judas. Silas rese. Nyebe que ũquɨ̃ Dios cheẽ nenei nenei tuchɨ Jesús ɨcuasa je ra. Jesús ɨcuasa mbaaquiatu quiatu tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Chɨ are jiri que huee ra. Jesús ɨcuasa que embuchebi turã mondochoɨ cote ra. Nyoɨ que nyebi Jerusalén nda. ");
INSERT INTO srqNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silas que siquichõ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo abe que siquichõ Antioquíaa ra. Bernabé rese. Mbia que embaaquiatu quiatu quia ra. Dios cheẽ turã ngue esenei senei nguia ra. Jesús ɨcuasa tubɨrɨã ngue esenei senei erese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Aquere que Pablo ñee Bernabé je ra. —Nyao nanderique ruɨ Jesús ɨcuasa mbuchesea sea mae ja erese. Dios cheẽ ngue nandesenei senei, hue jenda mbuchesea sea nyao. Mañɨ Jesús ɨcuasa u mambɨ reae. Nyao erea, ɨ que Pablo ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","—Eno. Juan Marcos abe nanderao, ɨ rei que Bernabé ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","—Tei. Ae que nanderecha Panfíliaa nyii resẽ. Huɨ jeɨ que nande sɨ resẽ, nande Dios cheẽ nenei nenei mose. ¿Mañɨ nande ra ererao sɨ re? ɨ que Pablo ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ñee asi asi chee que nyue ra. Marcos rɨɨ̃. Nyebe que nyao nyesɨ ra. Bernabé que Marcos querao ra. Ama nduɨ que echoɨ Chípree ra. ");
INSERT INTO srqNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablo que ñee Silas je ra. —Nyao serese, ɨ que ee ra. Jesús ɨcuasa que ñee ee ra. —Chã Dios turã jendeaquiatu beɨ jẽso mose, ɨ ja que ee ra. Pablo que nyoɨ cote ra. Silas rese. ");
INSERT INTO srqNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria rɨ̃ ngue echoɨ ra. Cilicia rɨ̃ abe no. Hue jenda Jesús ɨcuasa mbaaquiatu quiatu que echoɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo que nyoɨ Dérbee ra. Lístraa abe echoɨ. Huee que Jesús ɨcuasa mo ndiqui ee ra. Timoteo, ɨ que ee ra. Esi rei judía. Esi rei Dios ɨcuasa. Judío eã ngue eru ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jesús ɨcuasa hue jenda que Timoteo ɨcua ja ra. Timoteo turãte, ɨ ja que Jesús quiato quia ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","—Timoteo tarao serese, ɨ que Pablo ra. Judíos tubɨrɨã ngue chɨ aque ibi ruɨ ra. —Judío eã ndei Timoteo ru, ɨ ja judíos. Nyebe Pablo circuncisión naa Timoteo je. Nguerao nguesendarã cote. ");
INSERT INTO srqNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nyoɨ que sucha tubɨrɨã mbuchesea sea cote ra. Jesús quiato rerecua cheẽ ngue esenei senei ja quia mbia je ra. Jerusalén jenda cheẽ. —¡Ũquɨ̃ ñee nda jemumba mumbachɨ̃ jẽ! ɨ que Pablo nyoɨ quia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Pablo que Jesús oseɨ uquia Jesús quiato je ra. Jesús ɨcuasa tubɨrɨã nɨa ngue esɨ quia cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","—Nyao Dios cheẽ nenei nenei Asia, ɨ rei ngue re. Espíritu Turã ngue nya ɨ ee ra. Nyebe echoɨ nguiã Frígiaa. Galáciaa abe. ");
INSERT INTO srqNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ngasẽ ngue Mísiaa ra. Nyao Bitinia, ɨ reɨ ngue re. Espíritu Turã ngue nya ɨ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Misia que echucuaño nyoɨ ra. Ngasẽ nyee Troas. ");
INSERT INTO srqNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Huee que Pablo Macedonia jenda mo ndea isa ra. Tea que cuu ra. Chɨ̃ nda juã ñee ñee Pablo je cuu ra. —¡Echu aa Macedóniaa jẽ! Echu urembaaquiatu quiatu, ɨ nda Pablo je cuu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nyebe ureso nguiã ereare. Se abe que aso erese ra. Se rei Lucas. —Dios urererao quia Macedonia co. Ucheẽ nenei nenei sacuã, ure que urechue cote ra. Nyebe urecuata nguiã cote. ");
INSERT INTO srqNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ama nduɨ que ureso Troas sɨ ra. Erɨɨmbe que ureso iasa ra. Urecuasẽ nyee que oso Samotracia ra. Isamamɨ ngue ureso Neápolis cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Hue sɨ que ureso ibi rɨ̃ nda. Urecuasẽ nyee oso sucha tubɨrɨã tuchɨ je. Filipos, ɨ hue sucha tubɨrɨã je. Romanos mbae rei sucha tubɨrɨã. Macedonia, ɨ que ibi ja je ra. Huee que urecu arete ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sábado mose que ureso ama nimíaa nda. Sucha tubɨrɨã ndecha. Huee que judíos riqui ñumunua nua mbeɨ ñee ñee Dios je ra. Ari que ngaẽ ngaẽ nguia huee ra. Acuanɨ mo ndese. Urecoi que Dios cheẽ nenei nenei ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lidia, ɨ que urecheẽ andusa mo je ra. Ae rei tiru rubi vender ɨsa. Ae rei Tiatira jenda. Ae rei Dios ɨcuasa. Dios que Pablo cheẽ mbuchecua ee ra. Pablo cheẽ ngue eisi ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nyebe que bautizar ɨ ee ra. Echuchua jenda je abe que bautizar ɨ ra. —Se Jesús resenda tuchɨ mose jẽje, jenyu uque sechuchúaa, ɨ que Lidia ure je ra. Ñee tuchɨ ure je. Nyebe urererao nguiã uchuchua. ");
INSERT INTO srqNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Emo mose que ureso quia mbia ndua nduásaa Dios rese ra. Nyucuaaque mo ngue uresobeɨshɨ̃ nda. Aba checuayã ɨcuã ngue siqui tuchɨ quia erese ra. Aba checuayã ɨcuã ngue mbae ɨcua ɨcua quia ee ra. Nyebe mbia mbae isiquia mee mee tuchɨ quia nyucuaaque rerecua je. Nyucuaaque cha je. ");
INSERT INTO srqNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nyucuaaque que tu Pablo ruɨ ra. Tu ure ja ruɨ. Ñee ngue urerɨɨ̃ nda. —Ã ndei Dios rimba ã. Ibatenda rimba. A echɨ aba ɨcuã mbutiãsa nenei nenei jẽje a. A echɨ Jesús renei nenei jẽje a, ɨ beɨ que nyucuaaque quia urerɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ɨ beɨ que nyucuaaque quia urerɨɨ̃ nda. Pablo que echeẽ nyoseɨ chɨã nyee ra. Uba que ñee aba checuayã ɨcuã je cote ra. —Jesús rɨɨ̃ aɨco ñee ndeje a. Esẽ nyucuaaque sɨ, ɨ que Pablo aba checuayã ɨcuã je ra. Echeẽ mosebe que usẽ esɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nyucuaaque rerecua que paama ɨ Pablo je ra. —Mbia ra mbae isiquia mondo monoa techɨ̃ nande je cote re, ɨ nyue. Nyebe que Pablo isi ra. Silas rese. Curuchoɨ que plaza ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Mondo que mbia rerecua je ra. —Ã ndei judíos ã. Mbia mbɨɨcuã ɨcuãte equia ñee ñee ã. ");
INSERT INTO srqNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","“Ure rã jẽɨngo”, ɨchɨ̃ nguiã nande je. Romanos ndaque nande. Ũquɨ̃ nandesaã aronea tuchɨ quiarei, ɨ que mbia nguerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nyebe que mbia paama ɨ Pablo je ra. Silas abe je. Ererecua que eɨrao mbuɨ asi ra. —Ira je jẽiruã nua, ɨ que ererecua ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mbia que eiruã nua tuchɨ ra. Tarõ ngue cote ra. —Jẽsaarõ tuchɨ, ɨ que ererecua eraarõsa je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Echeende que etarõ tuchɨ cote ra. Ei abe que emumbi ɨno ira je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pablo que ñee ñee nguia Dios je itondiite mose ra. Silas rese. Ɨraseɨ raseɨ abe no. Etarõi que echandu ja quia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Aque mose que ibi titi titi ɨ ra. Etarõsa abe que quiata quiata ja ra. Eiquesa abe que quiata ja ra. Eicuasa que nyera ja cadenas nda. Etarõ ji sɨ que nyera ja ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Eraarõsa que ñumumba ra. Eɨquesa eequia ji rese que mae nda. Etarõ ji uchã neɨ nguiã ee. Nyebe ñee nguiã. —Tachɨɨquia, ɨ que tiquise rirõ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pablo que tasẽ ee ra. —¿Mbaerã nda erechɨɨquia re? ¡A urecu chõte a resẽ! ɨ que Pablo ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","—Tata eru, ɨ que eraarõsa mbia mo je ra. Ɨque que Pablo rea cote ra. Titi titi ɨ tuchɨ que ra. Ngoi que ngũíã ndese Pablo je ra. Silas abe je. ");
INSERT INTO srqNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Eraarõsa que ecuruchoɨ taicuee cote ra. Ñee ee. —Sã Dios serirõ seɨcuã sɨ. ¿Mañɨ ae ra se re? Siqui beɨ sacuã Dios rese re, ɨ que eraarõsa ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pablo que ñee ee cote ra. Silas rese. —Jesucristo eɨcua. Ũquɨ̃ mose ra Dios nderirõ ndeɨcuã sɨ. Ũquɨ̃ mose ra Dios ndechuchua jenda abe rirõ huɨɨcuã sɨ, ɨ que Pablo ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Jesús cheẽ ngue esenei senei ee ra. Echuchua jenda je abe que erenei nenei nda. ");
INSERT INTO srqNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Pablo iruã nua ji que eraarõsa ɨreɨ ɨreɨ ra. Silas iruã nua ji abe. Itondii mose raque. Bautizar ɨ que eraarõsa je cote ra. Echuchua jenda ja je abe que bautizar ɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Eraarõsa que Pablo querao mbuquiaru uchuchúaa ra. Silas abe no. Ey a tuchɨ que ra. Echuchua jenda abe ia tuchɨ. —Nandeɨco Dios ɨcua co cote, ɨ ñene. Nyebe eya tuchɨ Dios rese. ");
INSERT INTO srqNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Isamamɨmbe que ererecua ñee policía je ra. —Jẽso Pablo mbusẽ cote. Silas abe jembusẽ, ɨ que ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Eraarõsa que ñee Pablo je ra. —A policía cuaẽ a. Jembusẽ sacuã. Huɨ que jẽsɨ ra. Jẽso turã cote, ɨ rei que eraarõsa Pablo je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","—Nya, ɨ que Pablo ee ra. —¿Mbaerã ererecua ureiruã ñooño nde? Mbiasa. Mbae ɨcuã naa mose rocoɨ̃. Romanos ndaque ur e abe. Uretarõ ñooño ngue ra. “Nandembusẽ checuayã”, ɨ raque ure je co cote. Tei. Sã ũquɨ̃ ngaẽ urembusẽ nyecua, ɨ que Pablo ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pablo cheẽ ngue policía senei nguerecua je ra. “Romanos”, ɨ mose que ererecua chɨã cuaãcuã ɨ ja ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ererecua que nyoɨ Pablo rea cote ra. Silas abe rea. —Ureɨcuã ñochɨ̃ jẽje. Ureɨcuã eã nda cote. Jẽso a sɨ cote, ɨ que ererecua embusẽ turã mondo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pablo que usẽ etarõsa sɨ cote ra. Silas rese. Nyoɨ que Lidia chuchua ra. Hue que echɨ mbɨrɨ̃ Jesús ɨcuasa mundua ndua ra. Nyoɨ que hue sɨ cote ra. Sucha tubɨrɨã sɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo que nyoɨ Antípolis rɨ̃ nda. Apolonia nɨ̃ abe echoɨ. Silas rese. Hue sɨ que echoɨ ngasẽ Tesalónicaa ra. Huee que judíos chumu nuasa mo huee ra. Sina goga, ɨ equia tuchua je. ");
INSERT INTO srqNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo que oso hue sábado mose ra. Querabe que eriqui oso oso beɨ judíos chumunuásaa ra. Tres sábado que Pablo mbia mbaaquiatu quiatu huee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Dios cheẽ ngue esenei senei ee ra. —“Mbia ra Cristo mbasi tuchɨ. Manonde ra quera sɨ”, ɨ que Dios cheẽ nda. Eɨ̃ ngue mbia Jesús je cote ra. Jesús ae rɨɨ̃ aɨco ñee ñee jẽje, ae rei Cristo. Ae jẽsaarõ arõ mbeɨte quia, aque rei Jesús, ɨ que Pablo embaaquiatu quiatu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Emo emo ngue Jesús isi cote ra. Siqui que Pablo ruɨ ra. Silas ruɨ abe. Griegos tubɨrɨã ngue siqui eruɨ no nda. Dios ɨcuasa rei ũquɨ̃. Griego ninisi tubɨrɨã abe que siqui Pablo ruɨ ra. Mbia chɨɨcua tuchɨ rei ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Judíos que ngueteãte quia mbia rese Pablo je ra. Mbia siqui mose Pablo ruɨ. Ae Dios cheẽ andu sereãte quia, ũquɨ̃ ngue ngueteãte quia mbia rese ra. Nyebe ngata chooño je munua nguiã. Ũquɨ̃ ngue sucha tubɨrɨã jenda mbupaama ɨ tuchɨ ra. Mbia tubɨrɨã ngue mbaba chee Jasón chuchua je cote ra. —¿Ma Pablo ma nde? ¿Ma Silas ma nde? Uremee nda mbia ɨcuã je, ɨ rei que judíos ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pablo oreã ngue ee ra. Silas abe oreã ngue ee ra. Nyebe que Jasón nduruchoɨ mbutiriri nguerecua je ra. Jasón ndesenda rese. Ñee nguerecua je. —Pablo ngaẽ ñochɨ̃ mbia mbɨɨcuã ɨcuã ja aa. Pe jenda mbɨɨcuã ɨcuã jare. ");
INSERT INTO srqNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasón eisi turã ñochɨ̃ nguia uchuchúaa a. Ũquɨ̃ ɨcuã ja que eriqui nandererecua je. César cheẽ emumba mumba beɨ chõchɨ̃ nguiã ã. “Jesús quia ererecua tuchɨ César sɨ re”, ɨ chõchɨ̃ Pablo, ɨ que mbia paama ɨ Pablo je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Mbia ataque eandu mose que paama ɨ ra. Ererecua abe que paama ɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ererecua que mbae isiquia isi Jasón sɨ ra. Jasón ndesenda sɨ abe. —Uremeembe ra jẽje Pablo choɨ mose, ɨ que ererecua ee ra. Ererecua que huɨ ja esɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jesús ɨcuasa que Pablo mondochoɨ jeɨ Berea ra. Silas rese. Aque isa mose beɨ. Ngasẽ ngue Berea ra. Nyoɨ que judíos chumunuasa cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Judíos Berea jenda que earacua ra. Tesalónica jenda sɨ. Berea jenda quiatu que Dios cheẽ ñanduse rete ra. Berea jenda que embesa ji tea jeɨ jeɨ ra. —Ma Pablo ñee Dios cheẽ nduɨ sɨ, ɨ que nyue ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nyebe que mbia tubɨrɨã Jesús ɨcua ra. Griegos tubɨrɨã abe que Jesús ɨcua ra. Griegos ninisi abe. Mbia chɨɨcua rei griego s ninisi. ");
INSERT INTO srqNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pablo que Dios cheẽ senei senei Berea jenda je ra. Judíos Tesalónica jenda que jirandu ra. Jirandure que echoɨ Beréaa mbia mbɨɨcuã ɨcuã Pablo je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Jesús ɨcuasa que Pablo mondo ama ndɨsha quiti ra. Silas que siquichõ Beréaa ra. Timoteo rese. ");
INSERT INTO srqNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ae Pablo curuchoɨ, ũquɨ̃ ngue tiba esɨ ra. Atenas, ɨ que sucha tubɨrɨã je ra. —A ureɨco nyebi a, ɨ que Pablo je ra. Echebi mose que Pablo ñee ee ra. —Silas jembu jeɨ seje. Timoteo rese, ɨ que Pablo ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pablo que siqui Silas raarõ arõ Atenas nda. Timoteo abe raarõ arõ. Dios abareã tubɨrɨã ngue huee ra. Ũquɨ̃ ndese quiatu que mbia riqui oo tuchɨ ra. Pablo que mae ɨcuã ũquɨ̃ ndese ra. Pablo que paama ite mbia rese mae nda. Mbia Dios abareã nderequia requia mose. ");
INSERT INTO srqNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nyebe Pablo oso oso beɨ nguiã judíos chumunuasa. Ñee ñee tuchɨ hue jenda je. Judíos eã je abe ñee ñee tuchɨ hue jenda mbia je. Dios ɨcuasa je. Plázaa abe que Pablo riqui ñee ñee tuchɨ mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epicúreos resenda mo ngue ngaẽ ñee tuchɨ Pablo je ra. Estoicos resenda mo abe que ngaẽ ñee Pablo je ra. —¿Mbae ɨchõte Pablo quia nande je re? Echeẽse rete eriqui reae, ɨ que emo emo nda. —Dios mo nɨɨ eriqui ñee ñee nande je reae, ɨ que emo emo nda. Pablo ñee ñee mose Jesús rɨɨ̃. Pablo Jesús quera renei nenei mose. ");
INSERT INTO srqNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mbia que Pablo curuchoɨ ibi ato mo cote ra. Huee que ererecua riqui ñumunua nua mbeɨ ra. Ñee ngue Pablo je cote ra. —¿Mbae rɨɨ̃ ereɨco ñee ure je re? Embuchecua ure je. ");
INSERT INTO srqNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ã ngue urechanuate quia ra. Ndecheẽ embuchecua ure je. ¿Mbae ere quia re? ɨ que mbia Pablo j e ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atenas jenda mɨngo uquia reã mbae mo ndese. Ae siqui Atenas jenda rese, ũquɨ̃ abe mɨngo uquia reã mbae mo ndese. Echeemo andu andu beɨ. Echeemo ndese beɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nyebe que Pablo juã mbia ite re ra. Ibi ato. Ñe e ngue mbia je cote ra. —Tacheẽ jẽje, Atenas jenda. Dios ata rete rese jẽɨngo reae. ");
INSERT INTO srqNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Secuatasa que amae mae dios tubɨrɨã jembae rese ra. Emo ndese que amae nda. “Co Dios mbia mae sayã”, jenye que embesa mɨ nda. Ae je jẽɨngo ñee ñee ũquɨ̃. Jemae sayã ndaque. Ae rɨɨ̃ aɨco ñe e jẽje co. ");
INSERT INTO srqNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Co Dios que ibi chao ra. Mbae ao ja. Ae rei mbae rerecua. Ibi rɨɨnda rerecua. Ibei jenda abe rerecua. Dios siquíã ño nguiã tuchuaqui re mbia chɨao. ");
INSERT INTO srqNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","—¿Aba ra mbae chao seje re? ɨ eã ngue Dios quia ra. Ae quiarei mbae meesa. Nandembuquiarusa rei ae. Nande mɨngosa rei ae. ");
INSERT INTO srqNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mbia mɨɨ ngue Dios chao ra. Aque rei mbia i ja aque. Emo eã ño nandeɨco nguiã ã. Nande ja chõ nandeɨco nguiã ã. Dios rei nandeaosa. Nyebe Dios mbae rerecua ja. —Co ra nyeacuquia co mose. Co ra mano co mose, ɨ beɨ que Dios quia ra. Mbia recuarã ngue Dios mee mee mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Dios que mbia mɨngo ibi rɨ̃ nda. Ɨ̃ nda mbia Dios requia. Ɨ̃ nda mbia Dios ɨcua. Ɨsho eãte Dios riqui a. Nande ja jii eriqui a. ");
INSERT INTO srqNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Dios rɨɨ̃ ae nandeɨco nguiã. Erɨɨ̃ ae nandeɨco nguiã ngata. Jemo abe que ñee nda. “Dios riirĩ ño nandeɨco ja nguiã ã”, ɨ que jemo nda. ");
INSERT INTO srqNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ae beɨ chõ nandeɨco nguiã ã. Dios riirĩ. “Dios” nandechɨ̃ nguiã mbia chɨao je. Oro ao ji je. Plata ao ji je. Sɨta ao ji je. ");
INSERT INTO srqNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dios que mbia ɨcuã teachõ cose ra. Mbia aquiatuã mose. Namo ño Dios riqui nguiã ñee mbia je co. “Jẽhuɨ chõ jẽɨcuã sɨ”, ɨ Dios quia mbia jaje co. ");
INSERT INTO srqNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Dios que Jesucristo irabo ra. Jesucristo turã mbeɨ. Jesucristo ra ñee emo je. “Jẽso tata cuasu”, ɨ ra ee. “Jẽso ibate”, ɨ ra emo je no. Manose chõ nda ñee. Dios mɨɨ ño eɨcua nguiã. Dios que Jesucristo mbuquera sɨ manonde ra. Nyebe ra Jesucristo emo mondo ibate. Emo mondo tata cuasu no. ");
INSERT INTO srqNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","—Jesucristo que quera sɨ manonde ra, ɨ que Pablo ee ra. Mbia que ɨquia ɨquia chõchɨ̃ nguiã Pablo cheẽ mose. Emo emo ngue ñee ee ra. —Emo mose quiatu ra ndecheẽ urechandu, ɨ que eataque ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pablo que oso mbia recha cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Emo emo ngue siqui eruɨ ra. Ae Jesús cheẽ isi turã, ũquɨ̃ ngue siqui beɨ eruɨ ra. Dionisio, ɨ que ũquɨ̃ mo je ra. Ae rei mbia rerecua mo. Dámaris, ɨ que cuña mo je ra. Emo emo abe que siqui Pablo ruɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pablo que oso Atenas ndecha cote ra. Ngasẽ ngue sucha tubɨrɨã mo cote ra. Corinto, ɨ que hue je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Hue que judío mo ndiqui ee ra. Aquila, ɨ que ee ra. Ponto jenda que ae ra. Priscila, ɨ que eninisi je ra. Ũquɨ̃ ngue ngaẽ namo Italia sɨ ra. Italia recha ramo. Claudio judíos mombo ja mose Roma sɨ. Pablo que oso Aquila chuchua ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pablo que tuchua saã saã nguia mbae ɨre je ra. Eɨ̃ ngue Aquila no nda. Tuchua raã naa mbeɨ mbae ɨre je. Nyebe Pablo siquichõ nguiã erese. Quieɨ quieɨ erese. ");
INSERT INTO srqNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sábado mose que Pablo riqui oso oso judíos chumunuasa ra. Hue que eriqui beɨ Dios cheẽ nenei nenei judíos je ra. Judíos eã je abe no. ");
INSERT INTO srqNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas que ngasẽ Macedonia sɨ cote ra. Timoteo rese. Pablo que Dios cheẽ senei senei tuchɨ quia judíos je cote ra. Jesús mbuchecua checua tuchɨ ee. —Jesús rei Cristo. Ae jẽsaarõ arõ mbeɨt e quia, aque rei Jesús, ɨ tuchɨ que Pablo ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Judíos que paama ɨ Pablo je cote ra. Ñee ɨcuã ɨcuã tuchɨ que ee ra. Nyebe Pablo huɨɨrao mbaaba aba ee. Taso jendecha, ɨ ñene. —“Aemɨngo beɨ ra se”, ɨ rei Dios nande je. Jẽ nguiarei Dios cheẽ isi sereã tuchɨ. “¿Mbaerã Dios cheẽ eresenei eã ure je re?” jenyechɨ̃ nda seje. ¡Dios cheẽ ngue asenei tuchɨ rei jẽje ra jẽ! Nyebe taendecha. Judíos eã je Dios cheẽ tasenei senei cote, ɨ que Pablo huɨɨrao mbaaba aba ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pablo que oso judíos recha cote ra. Judíos chumunuasa jii esɨ. Justo chuchúaa. Judío eã ndei Justo. Dios quiato que Justo ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispo que judíos chumunuasa rerecua ra. Aque que Jesús ɨcua cote ra. Echuchua jenda ja abe que Jesús ɨcua cote ra. Corinto jenda tubɨrɨã ngue Dios cheẽ ñandu ra. Mbia tubɨrɨã ngue Jesús ɨcua cote ra. Bautizar ɨ que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Itondaru mo ngue Pablo Jesús rea ra. Ñee ngue Pablo je cuu ra. —Eresiquichechɨ̃ nda mbia sɨ jẽ. Secheẽ esenei senei mbeɨ. Erehuɨchɨ̃ nda esɨ jẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Co aɨco nderea quiatu co. Mbae ɨcuã nda ɨ̃ eã ndeje. Secheẽ esenei senei mbeɨ. A jenda ra seɨcua ja jiri cote, ɨ que Jesús Pablo je cuu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pablo que siqui arete Corinto ra. Un año ndobeɨchõ jiri que eriqui huee ra. Mbia mbaaquiatu quiatu beɨ Dios rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galión ngue Acayo jenda rerecua ra. Aque mose que judíos ñɨmbɨɨcuã tuchɨ Pablo je ra. Oo que erese ra. Curuchoɨ que nguerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Judíos que ñee ererecua je ra. —Pablo que mbia mbaaquiatu ɨcuã ɨcuã nguia ra. Dios rɨɨ̃. Nandererecua cheẽ nduɨ eã, ɨ que judíos ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo nda ñee nguiã ña. Ererecua Galión nane nguia ñee nguiã esɨ. Ñee judíos je. —Mbae ɨcuã ndese que Pablo riqui ãte. Eɨ̃ nguia nda jeñee achandu nguiã ña. ");
INSERT INTO srqNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mbae ɨcuã ngue esaã eãte. Pablo cheẽ je chõ jẽɨngo nguiã paama ɨ. Judíos cheẽ nɨɨ ño jẽɨngo nguiã paama ɨ Pablo je. Nyebe ra jeñee achanua. Jẽ ae jeñee turã jenyue ae, ɨ que Galión judíos je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Mombo ja que uchuchua sɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Sóstenes, ɨ que judíos chumunua nuasa rerecua je ra. Judíos eã ngue paama ɨ Sóstenes je ra. Isi ɨcuã ngue ra. Iruã nua tuchɨ que ra. Ererecua Galión ndésaa que eiruã nua nda. Ererecua que teachõ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablo que siqui atate Coríntoo ra. —Co acua quia jendecha co, ɨ que uataque je cote ra. Jesús quiato je. Aquila abe que oso erese ra. Priscila abe no. Ngasẽ ngue ama nimíaa nda. Such a tubɨrɨã. Cencrea, ɨ que hue sucha tubɨrɨã je ra. Pablo que ua chisia cote ra. —Acheẽ ngue Dios je, aque que amumbayã nda, ɨ que ua sia cote ra. Siria ɨcha ruɨ que echoɨ cote ra. Ama ndɨsha ɨcoɨ tuchɨ ruɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Sucha tubɨrɨã je que ngasẽ cote ra. Efeso, ɨ que sucha tubɨrɨã je ra. Aquila que siquichõ eresebe huee ra. Priscila, ɨ que eninisi je ra. Pablo que oso judío s chumunuásaa ra. Ñee ñee tuchɨ que judíos je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","—Eɨco are jiri aa, ɨ rei que judíos ee ra. Pablo que echeẽ mumba beɨ oso ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","—Taso Jerusalén. Mbia chumunua mose taɨco rã Jerusalén. Achube ra mae jendese. Dios sembu mose ra achube mae jendese, ɨ que Pablo ra. Oso que Efeso sɨ cote ra. Ama ndɨsha ruɨ beɨ que echoɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ngasẽ ngue Cesaréaa ra. Hue sɨ que Pablo sɨ Jerusalén cote ra. Hue jenda rese que mae nda. Jesús quiato. Hue sɨ que esɨ Antioquíaa ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Siqui arete que Antioquíaa ra. Oso que Galacia cote ra. Frigia abe no. Sucha tubɨrɨã ngue embuchesea sea tuchɨ quia hue jenda ra. Jesús quiato mundua ndua hue jenda. ");
INSERT INTO srqNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Aque mose que judío mo ngasẽ huee ra. Efésoo. Apolos, ɨ que ee ra. Alejandría jenda que ae ra. Dios cheẽ nenei neneisa tuchɨ mbia je. Dios cheẽ ɨcuasa tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apolos que Dios ɨcha ɨcuate ra. Mbia que embaaquiatu quiatu turã tuchɨ quia ra. Mbia mbaaquiatu turã Jesús rɨɨ̃. Juan Bautista cheẽ achõ ngue eɨcua quia ra. Juan bautizar ɨ mose mbia je. ");
INSERT INTO srqNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos siquicheã tuchɨ que eriqui mbia mbaaquiatu quiatu ra. Judíos chumunuásaa. Aquil a que echandu ra. Priscila rese. Nyebe que ũquɨ̃ Apolos rerao mbaaquiatu quiatu tuchɨ ra. Dios ɨcha que embuchecua tuchɨ ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos que osose Acáyaa ra. Nyebe Jesús quiato emondo turã. Papel que embesa Acaya jenda je ra. Jesús quiato je Acaya jenda je. —Apolos jẽisi turã, ɨ ee. Apolos que ngasẽ cote ra. Ae Jesús ɨcua quia, ũquɨ̃ mbaaquiatu quiatu tuchɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos que judíos cheẽ siquisã tuchɨ ra. Judíos mbia mbaaquiatu chooño mose. Jesús rɨɨ̃ eã. Nyebe Apolos echeẽ ndiquisã. Dios cheẽ ngue esenei senei nguia ee ra. —Jesús rei Cristo. Ae jẽsaarõ arõ nguia, aque rei Jesús ɨ tuchɨ que Dios cheẽ nenei ee ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Sɨta ibate bate ite rɨ̃ ngue Pablo sɨ ra. Ngasẽ ngue Efeso cote ra. Apolos siqui mose Corinto. Jesús quiato mo je que Pablo ngasẽ Efésoo ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pablo que ñee ee ra. —Jẽ Jesús isi mose, ¿Espíritu Turã abe ɨque jeñɨangui re re? ɨ que Pablo ee ra. —Espíritu Turã ndese ureiranuate, ɨ que mbia Pablo je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pablo que ñee ee ra. —¿Mbae rɨɨ̃ bautizar ɨ jẽje re? ɨ que ra. —Juan ñee nɨɨ ngue bautizar ɨ ure je ra, ɨ que Pablo je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo que ñee ee ra. —Juan ngue bautizar ɨ mbia je ra. Mbia huɨ mose huɨɨcuã sɨ. “Ae ra tu seruɨ, aque jẽɨcua jẽ. Jesucristo chõ aque re”, ɨ que Juan nda, ɨ que Pablo ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pablo cheẽ andu mose que bautizar ɨ Jesús rɨɨ̃ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pablo que o chono earõ nda. Espíritu Turã ngue ɨque echɨangui re cote ra. Ucheemo ngue esaã saã nguia cote ra. Dios cheẽ ngue embuchecua checua quia mbia je cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Doce que ũquɨ̃ nda. Jesús quiato. ");
INSERT INTO srqNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pablo que oso oso quia judíos chumunuasa ra. Tres meses. Siquicheã tuchɨ que equia Dios cheẽ nenei nenei nda. —Ererecua tuchɨ quiarei Dios. Jesús jẽɨcua rã, ɨ que Pablo quia mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Emo emo ngue Pablo cheẽ ñandu sereã nda. Echeẽ mumba mumba. Jesús rɨɨ̃ ñee ɨcuã ɨcuã mbeɨ mbia ja je. Nyebe Pablo nyao nguiã esɨ. Pablo que Jesús quiato curuchoɨ esɨ ra. Curuchoɨ que Tiranno chuchúaa ra. Huee que eriqui embaaquiatu quiatu cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Dos años ngue Pablo riqui huee ra. Nyebe mbia Asia jenda jirandu ja nguiã Jesús rese. Judíos jirandu ja erese. Judíos eã abe no. ");
INSERT INTO srqNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pablo que mbae saã saã tuchɨ quia Dios quirãcuã je ra. Mbia mae sayã ngue esaã saã nguia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Mbia rasi mbucherõ sacuã ngue mbia riqui tiru mbucha mbucha Pablo rese ra. Ũquɨ̃ tiru que ecuruchoɨ choɨ quia mbia rasi je cote ra. Ũquɨ̃ tiru ruruchoɨ mose, mbia rasi que nyerõ nyerõ nguia cote ra. Aba checuayã ɨcuã abe que usẽ usẽ nguia mbia chɨã sɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Judíos mo ngue ngata beɨte quia ra. Sucha tubɨrɨã mbuchesea sea beɨ que equia ra. —Aba checuayã ɨcuã mbusẽ aquiatute que ure ra, ɨ que equia ra. —Jesús rɨɨ̃ aba checuayã ɨcuã nandembusẽ, ɨ rei que nyue ra. Nyebe que ñee aba checuayã ɨcuã mo je ra. —Jesús quirãcuã nɨɨ aɨco jembusẽ mbia sɨ co. Ae Pablo senei senei nguia, ɨ rei que judíos aba checuayã ɨcuã je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sacerdote rerecua riirĩ abe que eɨ̃ sɨ ra. Siete eriirĩ. Esceva, ɨ que sacerdote rerecua je ra. Judío que ae ra. Ae riirĩ ngue eɨ̃ sɨ rei no nda. ");
INSERT INTO srqNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ũquɨ̃ ngue ñee ndei aba checuayã ɨcuã je ra. Aba checuayã ɨcuã ngue echeẽ mumba ra. —Jesús aɨcua. Pablo abe aɨcua. ¿Aba chõ jẽ nde? Jaẽɨcuayãte se, ɨ que aba checuayã ɨcuã nda. ");
INSERT INTO srqNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Aba checuayã nyɨreco que oo erese cote ra. Ucua ucua tuchɨ que ũquɨ̃ ja rese cote ra. Ũquɨ̃ siete rese. Aba checuayã ɨcuã nyɨreco quirãcuã tuchɨ que esɨ ra. Aba checuayã nyɨreco que ũquɨ̃ mbasi ja ra. Nyebe ũquɨ̃ ndasi rasi uchã aba checuayã ɨcuã sɨ. Eɨrao eã ngu e nyoɨ uchã itaicuee rɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efeso, ɨ que hue sucha tubɨrɨã je ra. Hue jenda que jirandu ja erese ra. Judíos que jirandu ja erese ra. Judíos eã abe no. Nyebe hue jenda siquiche ja. Nyebe mbia ñee turã turã jate Jesús rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Jesús quiato mo ngue ngaẽ ngaẽ nguia ra. Eya eãte que huɨɨcuã ndese ra. Nyebe huɨɨcuã nenei nenei. ");
INSERT INTO srqNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mbia tubɨrɨã ngue mbae ɨcuã papel mbesa ji curucuaẽ nda. Libros de brujería. Munua ja que huee ra. Ũquɨ̃ ngue esei sei mbia ja résaa cote ra. Mba e isiquia ata tuchɨ raque que ũquɨ̃ libros isiquia ra. Cincuenta mil plata. ");
INSERT INTO srqNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Mbia tubɨrɨã ngue Dios cheẽ isi isi quia ra. Dios cheẽ ɨrãtãte que mbia tea quia cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Aquere que Pablo ñee nda. —Taso Macedonia. Acaya abe. Aquere ra aso Jerusalén cote. Jerusalén osore ra aso Roma cote, ɨ que ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nguesenda nyeremo ngue emondo Macedonia nda. Timoteo. Erasto rese. Pablo que siquichõ are jiri huee ra. Asia. ");
INSERT INTO srqNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Aque mose que mbia paama ɨ tuchɨ Jesús rɨɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demetrio quia rei mbia mbɨɨcuã ɨcuã nyii. Dios mbuae chuchua que esaã saã nguia ra. Mbae rendi ãtã je que eriqui sucha ñetẽ naa naa nda. Sucha ñetẽ tubɨrɨã ngue esaã saã nguia ra. Dios mbuae chuchuarã. Diana, ɨ que Dios mbuae je ra. Demetrio que mbae isi tuchɨ quia sucha ñetẽ ndɨbɨshorõ nda. Eresenda tubɨrɨãte que sucha ñetẽ naa naasa ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nguesenda ja que emunua nda. Dios mbuae chuchua raãsa que emunua ja ra. Ñee ngue ee ra. —Mbae nandeisi turãte rei nguiã nandechɨao rɨbɨshorõ ã. ");
INSERT INTO srqNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pablo riqui ñee ñee mbia je co. “Dios mbuae mbia chɨao rei eɨcuãte”, ɨ Pablo quia co. Mbia riqui echeẽ mumbayãte ã. A jendachõ eã ñene. Efeso mɨɨ eã ñene. Asia jenda abe eriqui echeẽ andu ã. ");
INSERT INTO srqNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ũquɨ̃ ɨcuãte nande je. Nandechɨao ra mbia isi isiã ñochɨ̃ cote re. Mbia ra huɨ ja chõchɨ̃ Diana chuchua sɨ cote re. Diana abe sɨ ra mbia huɨ chõchɨ̃ nde. Nandererecua tuchɨ que Diana. Mbia chɨɨcua tuchɨ que ae. Asia jenda chɨɨcua tuchɨ que ae. ¡Mbia ra huɨ chõchɨ̃ esɨ jẽ! ɨ que Demetrio ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demetrio resenda echeẽ andu mose que paama ɨte ra. —¡Diana quirãcuãte jẽ! ¡Efeso jenda rerecua quirãcuãte jẽ! ɨ tuchɨ que mbia tasẽ tasẽ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Hue jenda que paama ɨ ja ra. Pare pare ɨ tuchɨ. Pablo resenda nyeremo ngue eisi ra. Gayo. Aristarco rese. Macedonia jenda. Ũquɨ̃ nyeremo ngue ecuruchoɨ mbia chumunuásaa ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","—Taɨque se abe. Tacheẽ ñee mbia je, ɨ rei que Pablo ra. Jesús quiato que Pablo siquisã nda. ");
INSERT INTO srqNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asia jenda rerecua mo abe que ucheẽ mondo Pablo je ra. —¡Ereɨquechɨ̃ nda nde jẽ! ɨ Pablo je. Pablo quiato que ũquɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mbia que pare pare ɨ tuchɨ ra. Tasẽ tasẽ ja que ra. Hue rɨ̃ ja mbia ndua eãte. Mbae mɨɨ ndese ndua eã. Paama ɨ chooño ja. Eaquiatuã ño ñumunua ñooño nguiã. ");
INSERT INTO srqNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mbia mo ngue mbae senei senei ja Alejandro je ra. Judíos que Alejandro mua mbia ite re cote ra. —Echeẽ mbia ja je, ɨ que ee ra. Alejandro que o mee mbia je ra. —¡Jẽquɨrɨrɨ chõ jẽ! ɨ rei ngue ee re. —Mbia je tacheẽ. Ɨ̃ nda paama ɨã judíos je, ɨ rei ngue re. ");
INSERT INTO srqNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","—Judío chõ Alejandro riqui re, ɨ ja que mbia ra. Nyebe mbia riqui tasẽ tasẽ mbeɨte re. Dos horas. —¡Diana quirãcuãte jẽ! ¡Efeso jenda rerecua quirãcuãte jẽ! ɨ tuchɨ que mbia tasẽ tasẽ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Secretario rei ererecua mo. Aque que mbia cheẽ siquisã cote ra. Ñee ngue ee cote ra. —Tacheẽ jẽje, Efeso jenda. Efeso jenda chõ nande re. Diana ndei nandererecua. Nande rei Diana ndaarõsa. Diana naanguia ngue tu ibei sɨ, aque raarõsa chõ nande re. Diana chuchua raarõsa abe chõ nande re. Mbia jirandu jate ũquɨ̃ ndese. ");
INSERT INTO srqNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Emo eɨcuayã eãte. Nyebe jẽquɨrɨrɨ chõ jẽ. ¡Jẽaquiatuã jẽsaã saã eã ño jẽ! ");
INSERT INTO srqNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ae jẽisi seru nae, ũquɨ̃ mbae mbuquiachã eãte dios mbuae chuchúaa. Ũquɨ̃ ñee ɨcuã ɨcuã eãte dios mbuae rɨɨ̃. Dios mbuae jenderecua rɨɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrio ñee ɨcuãse mose emo nɨɨ, sã esɨ nandererecua chuchúaa. Demetrio resenda ñee ɨcuãse mose emo nɨɨ, sã echoɨ nandererecua chuchúaa. Huee chõ ererecua riqui nguiã mbia cheẽ andu. Sã echoɨ ja ererecua je. Sã ñee ñee ja nyue ererecua résaa. Mbae ɨcuã nɨɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mbae mo nɨɨ abe mose, jeñee mbia chumunua mose. ");
INSERT INTO srqNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Jesús quiato que nandeisi chooñochɨ̃ nda. Nandechɨmbɨɨcuã ñooño ño nguiã. Nandererecua ñee arõte nande je. Echeẽ nda nandesɨbɨshorõ eã, ɨ que secretario ra. ");
INSERT INTO srqNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Aquere que huɨ mbia sɨ ra. Mbia mbuɨ que cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Mbia quɨrɨrɨ mose que Pablo Jesús quiato munua nda. Embaaquiatu quiatu jiri. —Co acua quia co, ɨ que ee cote ra. Macedóniaa ngue echoɨ cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Hue jenda sucha mbuchesea seate que echoɨ ra. Jesús quiato mundua ndua. Ngasẽ ngue Gréciaa cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Huee que eriqui are jiri ra. Tres nyasi. —Taso Siria ama ndɨsha ruɨ, ɨ rei que cote ra. Jirandu que judíos ɨcuã ndese cote ra. —Nandeisi, ɨ nda judíos quia Pablo rɨɨ̃ nda. Nyebe Pablo ru nguiã nyebi sɨ Macedonia. ");
INSERT INTO srqNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ã ngue nyoɨ erese ra. Eata rete. Sópater. Berea jenda. Aristarco. Segundo abe. Tesalónica jenda rei ũquɨ̃. Gayo. Derbe jenda. Timoteo. Tíquico. Trófimo. Asia jenda rei ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ũquɨ̃ ja rane nguia nyoɨ nguiã ure sɨ. Troas que echɨ nguiã ureraarõ. ");
INSERT INTO srqNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Fiesta de Pascua mose que urecu Filipos ra. Aquere que ureso ama ndɨsha ruɨ cote ra. Cinco días que tu ure je ama ndɨsha ite re ra. Urecuasẽ namo ngue Troas cote ra. Ae ureraarõ arõ nguia, ũquɨ̃ ngue uresiiti cote ra. Urecu are jiri que hue cote ra. Siete días. ");
INSERT INTO srqNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Jesús quiato que ñumunua ja domingo mose cote ra. Mbichae sia sia nyue. Pablo que embaaquiatu quiatu quia ra. —Taso isamamɨ, ɨ que ra. Nyebe embaaquiatu quiatu itondiite mose chee. ");
INSERT INTO srqNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Sucha ibátee que echɨ ñumunua nda. Eironguia ibate tuchɨ que ra. Ibate tuchɨ que echɨ ñumunua nda. Tata rendi tubɨrɨã ngue etesae tuchɨ ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mbia mo ngue chɨ̃ ibate ra. Ventana tose. Etiarõ namo ngue ra. Eutico, ɨ que ee ra. Uque que huɨ̃ ngoi ibate ra. Pablo que ñee oco tuchɨ embeesi esi ra. Eque que tu ngoɨ ibate sɨ ra. Mano ndei que ra. Tambuchuruã, ɨ rei que emo nda. Eraaque chõ eriqui reaẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pablo que nguichi u erea ra. Oo tuchɨ que erese ra. Quiaama ngue ra. —¡Jẽsiquichechɨ̃ nda jẽ! Manoãte, ɨ que Pablo mbia je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pablo que osoɨ nyuɨ ra. Mbichae que echisia sia ra. U que ra. Mbia que embaaquiatu quiatube ra. Eresaitõ ndabe chee. Oso que erecha cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ae ngoɨ nae, erasiã ño ngue mbia curuchoɨchɨ̃ nguiã. Mbia ia tuchɨ que ngoɨ je rese cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pablo que ñee nda. —Ibi rɨ̃ taso se Asón. Hue sɨ ra aso jendese cote. Ama ndɨsha ruɨ, ɨ que ra. Nyebe ure rane ureso nguiã ama ndɨsha ruɨ. ");
INSERT INTO srqNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ae urecuasẽ nguiã Pablo je Asón cote. Pablo que oso urerese am a ndɨsha ruɨ cote ra. Canoa naanguia ye. Urecuasẽ ngue Mitilene cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Hue sɨ que ureso ra. Isamamɨ ngue ejoõ acua mo urechucuã cote ra. Quío, ɨ que hue ejoõ acua je ra. Isamamɨ nongue que urecuasẽ Samos cote ra. Hue sɨ que ureso Trogílioo ra. Huee que urequeneã ureucua ra. Isamamɨ ngue urecuasẽ Milétoo cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pablo que quɨcoɨ asi Asia sɨ ra. Nyebe uresoã Efésoo. —Tacuasẽ quicoɨ oso Jerusalén. Fiesta de Pentecostés taicusu oso ngasẽ, ɨ que Pablo ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mileto sɨ que Pablo emo mondo Efésoo ra. —Jenyu, ɨ que ameɨ je ra. Jesús quiato rerecua je. ");
INSERT INTO srqNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ũquɨ̃ ngue ngaẽ ee ra. Pablo que ñee ee ra. —Cosete que achu Asia ra. Seɨcuate raque se. Sechɨsaã jẽɨcuate raque. ");
INSERT INTO srqNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Dios cheẽ ngue asenei senei turã tuchɨ quia jẽje. Secuasu que asaã saã eãte quia jẽje. Acheseo tuchɨ que sequia mbia rese. Judíos que sembasi mbasi tuchɨ quia ra. “Taɨquia”, ɨ rei que judíos quia seje ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Dios cheẽ ngue asenei senei mbeɨte quia jẽje. Asiquicheã mbeɨ que sequia erenei nenei jẽje. Jembitirõ sacuã. Jeñumunua nua mose. Jenyuchúaa ja abe que aɨco Dios cheẽ nenei nenei jẽje. ");
INSERT INTO srqNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Acheẽ tuchɨ que jẽje. Judíos je. Judíos eã je ab e no. “¡Jẽɨcuã sɨ jẽhuɨ rã! Jesucristo jẽɨcua rã”, ae tuchɨ que sequia jẽje. ");
INSERT INTO srqNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Co aso quia Jerusalén co. Co Espíritu Turã sererao quia Jerusalén co. Mañɨ ño nda seje pee. ");
INSERT INTO srqNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Co mɨɨ ño aɨcua nguiã. Espíritu Turã ngue ñee seje ra. Sucha mbuchesea sea mose que eriqui ñee ñee seje. Mbia ɨcuãte ra seje. Sembasi rae. Sematã ndae. Setarõ ndae. Espíritu Turã ngue sembiirandu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Sesiquicheãte ũquɨ̃ sɨ. Sã seɨquia quiatu. “Dios turã esenei senei mbeɨ quia mbia je”, ɨ que Jesús seje ra. Aque mɨɨ ndese chõ aɨco nguiã ndu a co. Echeẽ mɨɨ ndese. Ɨ̃ nda echeẽ amumba eã. ");
INSERT INTO srqNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Dios nandererecua que asenei senei tuchɨ jẽje. Jemae eã mbeɨ ra serese cote. Aɨcuate se quia co. ");
INSERT INTO srqNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Jemo siqui sereã mose Jesús rese, se eã ño cote re. Jẽ ño cote re. Jẽ ja je chõ ngue asenei senei ndesẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Dios cheẽ ngue asenei senei jate jẽje. Asiquicheã mbeɨ que sequia erenei nenei jẽje. Dios cheẽ mo ngue atibo tibo eãte jẽje. ");
INSERT INTO srqNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","¡Jẽɨngo turã ño nyɨese jẽ! ¡Jesús quiato abe jẽteaquiatu quia jẽ! Espíritu Turã ngue ñee jẽje resẽ. “Jesús quiato rerecuarã jẽ”, ɨ que Espíritu Turã jẽje resẽ. Jesús quiato jẽteaquiatu quia jẽ. Ũquɨ̃ ndɨbɨshorõ ngue Jesús nguqui mondo ra. Umano mose. ");
INSERT INTO srqNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Seso mose ra emo ngaẽ ñee ñooño jẽje. Tambɨɨrɨ̃ ɨrɨ̃, ɨ ra jẽje. Eɨcuã ño ũquɨ̃ nde. Nyacua rã sɨ́. ");
INSERT INTO srqNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Jendese ra emo ndiqui. Jesús quiato mbaaquiatu ɨcuã ɨcuã. Jesús quiato mbɨɨrɨ̃ ɨrɨ̃. “Ɨ̃ nda Jesús quiato siqui nanderese”, ɨ ra ũquɨ̃. ");
INSERT INTO srqNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Jẽteaquiatu jẽ. Jaembaaquiatu quiatu tuchɨ que se. Tres años. Jẽ ja que jaembaaquiatu quiatu. Acheseo tuchɨ que sequia jendese. ");
INSERT INTO srqNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Aɨco jendecha Dios je a. Aɨco jendecha Dios turã je a. ¡Dios cheẽ turã jemumbayã mbeɨ quia jẽ! Dios cheẽ nda jembuquirãcuã. Dios cheẽ nda jemɨngo tuchɨ Jesús quiato rese. ");
INSERT INTO srqNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mbae isiquia que achoseɨ choseɨ ãte quia mbia mbae aẽ. Mbia ɨrao abe que achoseɨ chɨãte quia aẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Seɨcuate rei que equia aẽ. Se sɨ́ chõ aquieɨ quieɨ nguiã icua. Seresenda mbaerã abe que aquieɨ quieɨ quia aẽ. ");
INSERT INTO srqNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Jaembaaquiatu quiatu beɨte que se. “Jẽquieɨ quieɨ”, ae beɨte que sequia jẽje. “Mbaecha reã je mbae jemee mee”, ae que sequia jẽje. Jesús cheẽ ndese jendua. “Ae mbae meeño nguia emo je, eya tuchɨ chõ aque re. Ae eo jenda isi, aque quia eya tuchɨã jiri”, ɨ que Jesús nande je ra, ɨ que Pablo Efeso jenda je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Aquere que Pablo ngoi ngũíã ndese ra. Ñee ngue Dios je ra. Ũquɨ̃ ndes e ja. ");
INSERT INTO srqNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Mbia que nyese o ja Pablo rese ra. Quiaama ama ngue ra. Eritii que esiite it e ra. ");
INSERT INTO srqNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","—Jemae ɨã nda serese cote, ɨ que Pablo ee ra. Nyebe que eya eã tuchɨ ra. Pablo rese que echoɨ erasaa ra. Ama ndɨsha rimia ndese. Pablo so rese mae. ");
INSERT INTO srqNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Urecuata que ũquɨ̃ ndecha cote ra. Canoa naanguia ye que ureso cote ra. Cos que ureso ra. Isamamɨ ngue ureso Rodas cote ra. Hue sɨ que ureso Pátaraa cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Huee que canoa mo chɨ ure je ra. Fenisia rɨ̃ ngue esɨ quia ra. Aque ye que urea cote ra. Eye que ureso cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Chipre rese que uremae nda. Ejoõ acua. Ejii rɨ̃ ngue ureso ra. Síriaa que ureso ra. Tiro que ure cu mbɨrɨ̃ cote ra. Huee que canoa yenda jea jea ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Jesús quiato que urembɨrõ hue jenda ra. Siete días que ureɨco erese ra. Espíritu Turã ngue hue jenda mbucheẽ Pablo je ra. —¡Eresochɨ̃ nda Jerusalén jẽ! ɨ rei ngue Pablo je re. ");
INSERT INTO srqNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Aquere que ureso cote ra. Jesús quiato que nyoɨ ja urerese ra. Ama nimia ndese. Eresebe echoɨ urerese. Nguiirĩ abe ruruchoɨ. Ama ndɨsha rimia ndes e que urecoi ja urenía ndese ra. Ñee ñee Dios je. ");
INSERT INTO srqNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Urechɨquiaama ama ja que cote ra. —Co urecua quia co, ure que ee ra. Canoa ye que ureso cote ra. Hue jenda que nyoɨ nyebi uchuchúaa cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiro sɨ que ureso cote ra. Ureso que Tolemaida ra. Huee que urecheẽ ñee Jesús quiato je ra. Ureitõ mɨɨ ngue erese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Isamamɨ ngue ureso cote ra. Cesaréaa que urecuasẽ nda. Felipe chuchúaa que ureso ra. Ae que Jesús cheẽ nenei neneisa ra. Ae que mbaecha reã mbuquiaru sa ra. Diáconos, ɨ que mbaecha reã mbu quiarusa je ra. Aque chuchúaa que urecu ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Cuatro que Felipe rucucha ra. Eruã ja. Dios cheẽ nenei neneisa ja que ũquɨ̃ nda. ");
INSERT INTO srqNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Huee urecu are jiri mose que emo ndu ra. Judea sɨ. Agabo, ɨ que ee ra. Dios cheẽ nenei neneisa que ae abe ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ae que tu ure je ra. Pablo numbicuasa que eisi ra. O que echucua eye ra. Hui abe que echucua ra. Pablo numbicuasa je. Ñee ngue cote ra. —Espíritu Turã ndiqui ñee ndeje a. “Ɨ̃ nda judíos ndecua pee Jerusalén. Nemee nda judíos eã je cote”, ɨ que Espíritu Turã nda, ɨ que Agabo Pablo je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ure eandu mose queurecheẽ Pablo je ra. Cesarea jenda abe que ñee ee ra. —¡Eresochɨ̃ nda Jerusalén jẽ! ure ja rei ngue ee re. ");
INSERT INTO srqNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pablo que ñee ure je ra. —¿Mbaerã jẽɨngo nyeseo seo serese re? ¿Mbaerã jẽɨngo sembia eãte re? ¿Mbaete ere? Sã secua Jerusalén ae. Sã seɨquia Jesús rɨɨ̃ ae, ɨ que Pablo ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Pablo que uresiquisã aroneate ra. Nyebe urecheẽ eã nguiã e e cote. —Sã Dios ae riqui ñee ñee ee no, ure chee que ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ureɨco quiatu que cote ra. Ureso que Jerusalén cote ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Jesús quiato mo abe que nyoɨ urerese ra. Cesarea jenda. Chipre jenda mo ngue siqui Jerusalén nda. Masón, ɨ que ee ra. Jesús quiato tuchɨ que ra. Cose tuchɨ que eriqui Jesús rese ra. Cesarea jenda que urererao Masón nyuchúaa ra. Huee que urecu erese ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jesús quiato ia tuchɨ que urecuasẽ mose Jerusalén nda. Ureisi turã ngue ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Isamamɨ ngue Pablo sɨ Jacobo rea ra. Ure abe que ureso erese ra. Huee que ameɨ ja chɨ ra. Jesús quiato rerecua. ");
INSERT INTO srqNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pablo que ñee ee ra. Mba e renei nenei ja ee. —Dios que siqui tuchɨ serese ra. Se echeẽ nenei nenei mose judíos eã je, ɨ que Pablo Jesús quiato rerecua je ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pablo cheẽ andu mose que ñee turã turã Dios je ra. Ñee ngue Pablo je cote ra. —Jesús quiato tubɨrɨãte que judíos cote ra. “¡Moisés cheẽ nduɨ sɨ chõ nandeɨco jẽ!” ɨ tuchɨ que ũquɨ̃ nguia ra. ");
INSERT INTO srqNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ũquɨ̃ ndiqui ñee ɨcuã ɨcuã nderɨɨ̃ ũquɨ̃. “Pablo que judíos ataque mbuɨ Moisés cheẽ sɨ ra”, ɨ equia nderɨɨ̃ ũquɨ̃. “‘Coche rei Moisés cheẽ jemumba. ¡Circuncisión jẽsaãchɨ̃ jendiirĩ je jẽ! ¡Judíos ataque chɨsaã s