﻿USE sofia;
DROP TABLE IF EXISTS sofia.srponstl_vpl;
CREATE TABLE srponstl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES srponstl_vpl WRITE;
INSERT INTO srponstl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","U početku stvori Bog nebo i zemlju. ");
INSERT INTO srponstl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Međutim, zemlja je bila pusta i bezoblična, i tama se prostirala nad bezdanom, a Duh Božiji je lebdeo nad vodama. ");
INSERT INTO srponstl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tada reče Bog: „Neka bude svetlost!“ I postade svetlost. ");
INSERT INTO srponstl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Bog je video da je svetlost dobra, pa je razdelio svetlost od tame. ");
INSERT INTO srponstl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Svetlost je Bog nazvao „dan“, a tamu je nazvao „noć“. Prođe veče, svanu jutro – dan prvi. ");
INSERT INTO srponstl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Zatim reče Bog: „Neka se prostre svod posred voda da deli donje vode od gornjih voda!“ ");
INSERT INTO srponstl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Bog načini svod, te odvoji vode pod svodom od voda nad svodom. Tako se i zbilo. ");
INSERT INTO srponstl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Svod nazva Bog „nebo“. Prođe veče, svanu jutro – dan drugi. ");
INSERT INTO srponstl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Zatim reče Bog: „Vode pod svodom neka se saberu na jedno mesto i neka se pokaže kopno!“ Tako se i zbilo. ");
INSERT INTO srponstl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kopno je Bog nazvao „zemlja“, a vodena zborišta „more“. Vide Bog da je to dobro. ");
INSERT INTO srponstl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Zatim reče Bog: „Neka iz zemlje nikne bilje: ono koje u sebi nosi zrnevlje i drveta koja rađaju plod; sve bilje koje, svako prema svojoj vrsti, rađa na zemlji, i u sebi nosi svoje seme!“ Tako se i zbilo. ");
INSERT INTO srponstl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Iz zemlje iznikne bilje koje u sebi nosi zrnevlje, svako prema svojoj vrsti i drveta koja rađaju plodove sa semenom, svako prema svojoj vrsti. Vide Bog da je to dobro. ");
INSERT INTO srponstl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Prođe veče, svanu jutro – dan treći. ");
INSERT INTO srponstl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Zatim reče Bog: „Neka budu svetila na nebeskom svodu da dele dan od noći, i da označavaju utvrđena doba, dane i godine, ");
INSERT INTO srponstl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","te da svetle na nebeskom svodu osvetljavajući zemlju!“ Tako se i zbilo. ");
INSERT INTO srponstl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Bog je stvorio dva velika svetila: veće svetilo da upravlja danom i manje svetilo da upravlja noću – i zvezde. ");
INSERT INTO srponstl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Bog ih je postavio na nebeski svod da osvetljavaju zemlju, ");
INSERT INTO srponstl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","da upravljaju danom i noći i da dele svetlo od tame. Vide Bog da je to dobro. ");
INSERT INTO srponstl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Prođe veče, svanu jutro – dan četvrti. ");
INSERT INTO srponstl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Zatim reče Bog: „Neka provrve vodom živa bića, i ptice nek polete nad zemljom po nebeskom svodu!“ ");
INSERT INTO srponstl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Bog je stvorio i morske nemani i svakojaka živa bića što se kreću i vrve u vodi, te sve ptice krilate po svojim vrstama. Vide Bog da je to dobro. ");
INSERT INTO srponstl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Bog ih blagoslovi govoreći: „Plodite se i množite i napunite morske vode! Tako i ptice neka se namnože na zemlji!“ ");
INSERT INTO srponstl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Prođe veče, svanu jutro – dan peti. ");
INSERT INTO srponstl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Zatim reče Bog: „Neka zemlja proizvede živa bića, svako prema svojoj vrsti: stoku, gmizavce i divlje životinje svake vrste!“ Tako se i zbilo. ");
INSERT INTO srponstl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Bog stvori svakovrsne divlje životinje, svakovrsnu stoku i svakovrsne gmizavce što puze po zemlji. Vide Bog da je to dobro. ");
INSERT INTO srponstl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Zatim reče Bog: „Načinimo čoveka po svom liku, da liči na nas, da bude vladar ribama morskim, pticama u vazduhu i stoci po celoj zemlji, i svim gmizavcima što puze po zemlji!“ ");
INSERT INTO srponstl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tako stvori Bog čoveka po svom liku, po Božijem liku ga stvori, stvori ih – muško i žensko. ");
INSERT INTO srponstl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","I blagoslovi ih Bog govoreći: „Plodite se i množite se i napunite zemlju! Podložite je sebi i vladajte ribama morskim, pticama na nebu i svim živim bićima što puze po zemlji!“ ");
INSERT INTO srponstl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Zatim reče Bog: „Evo, dajem vam za hranu sve bilje na zemlji što u sebi nosi zrnevlje, i sva drveta što u svome plodu nose seme! Neka vam to bude za hranu. ");
INSERT INTO srponstl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","A divljim životinjama na zemlji, pticama u vazduhu i gmizavcima što puze po zemlji u kojima je dah života – dajem za hranu sve zeleno bilje.“ Tako se i zbilo. ");
INSERT INTO srponstl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Bog pogleda sve što je stvorio i sve je bilo veoma dobro. Prođe veče, svanu jutro – dan šesti. ");
INSERT INTO srponstl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Tako je dovršeno nebo i zemlja sa svim svojim mnoštvom. ");
INSERT INTO srponstl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Do sedmoga dana je Bog dovršio svoje delo koje je stvorio; sedmoga dana je počinuo od svih svojih dela. ");
INSERT INTO srponstl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tada je Bog blagoslovio sedmi dan i posvetio ga, jer je do tog dana dovršio stvaranje svih svojih dela koja je stvorio. ");
INSERT INTO srponstl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","To je izveštaj o poreklu neba i zemlje kad su bili stvoreni. Kada je Gospod Bog stvorio zemlju i nebo, ");
INSERT INTO srponstl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","još nije bilo nikakvog poljskog rastinja, niti je bilo izniklo ikakvo bilje po poljima. Gospod Bog, naime, još nije pustio kišu na zemlju, a nije bilo ni čoveka da obrađuje zemlju. ");
INSERT INTO srponstl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ipak, voda je izvirala iz zemlje i natapala tle. ");
INSERT INTO srponstl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Tada Gospod Bog načini čoveka od zemnog praha i udahnu mu u nosnice dah života, te posta čovek živo biće. ");
INSERT INTO srponstl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Onda je Gospod Bog zasadio vrt na istoku, u Edenu, i u njega smestio čoveka koga je načinio. ");
INSERT INTO srponstl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Gospod Bog je učinio da iz zemlje izrastu svakovrsna drveta primamljivog izgleda i dobra za hranu, te drvo života i drvo poznanja dobra i zla. ");
INSERT INTO srponstl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","U Edenu je izvirala reka koja je napajala vrt. Odande se granala u četiri reke. ");
INSERT INTO srponstl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Prvoj je ime Fison; ona protiče svom zemljom evilskom, u kojoj ima zlata. ");
INSERT INTO srponstl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Zlato te zemlje je dobro, a ima tamo i smole i oniksa. ");
INSERT INTO srponstl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Drugoj reci je ime Gion; ona protiče celom kuškom zemljom. ");
INSERT INTO srponstl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Trećoj reci je ime Tigar; ona teče istočnim delom Asirije. Četvrta je Eufrat. ");
INSERT INTO srponstl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Gospod Bog uzme čoveka i postavi ga u edenski vrt da ga obrađuje i da se stara o njemu. ");
INSERT INTO srponstl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Gospod Bog zapovedi čoveku: „Sa svakog drveta u vrtu slobodno jedi, ");
INSERT INTO srponstl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ali sa drveta poznanja dobra i zla ne smeš jesti! Jer, toga dana kada budeš okusio s njega, sigurno ćeš umreti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Zatim Gospod Bog reče: „Nije dobro da je čovek sam. Načiniću mu pomoćnika koji će mu priličiti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Gospod Bog je načinio iz zemlje sve divlje životinje, i sve ptice na nebu, pa ih je doveo čoveku da vidi kako će koju nazvati. Svako živo biće trebalo je da se zove onako kako ga je čovek nazvao. ");
INSERT INTO srponstl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Čovek je dao imena svoj stoci, svim pticama na nebu i divljim životinjama. Ipak, za čoveka se nije našao pomoćnik koji bi mu priličio. ");
INSERT INTO srponstl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Gospod Bog učini da čovek utone u dubok san. Kada je čovek zaspao, Bog uzme od njega jedno rebro, a mesto popuni mesom. ");
INSERT INTO srponstl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Od rebra što je uzeo od čoveka, Gospod Bog načini ženu i dovede je čoveku. ");
INSERT INTO srponstl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","A čovek reče: „Evo, ovo je kost od moje kosti i telo od moga tela! Neka se zato zove ’žena’, jer je od čoveka uzeta.“ ");
INSERT INTO srponstl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Stoga će čovek ostaviti svoga oca i svoju majku, te se priljubiti uz svoju ženu, pa će biti jedno telo. ");
INSERT INTO srponstl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Oboje su bili goli, i čovek i njegova žena, ali se nisu stideli. ");
INSERT INTO srponstl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Zmija je bila lukavija od svih divljih životinja koje je stvorio Gospod Bog. Ona reče ženi: „Zar vam je Bog stvarno rekao da ne smete jesti ni s jednog drveta u vrtu?“ ");
INSERT INTO srponstl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Žena odgovori zmiji: „Plodove sa drveta u vrtu smemo da jedemo, ");
INSERT INTO srponstl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","osim ploda sa drveta što je nasred vrta. Za njega je Bog rekao: ’Ne jedite s njega niti ga dotičite, inače ćete umreti!’“ ");
INSERT INTO srponstl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Zmija reče ženi: „Sigurno nećete umreti! ");
INSERT INTO srponstl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Naime, zna Bog da će vam se, kada okusite njegov plod, otvoriti oči, pa ćete biti kao bogovi koji poznaju dobro i zlo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Vide žena da je drvo dobro za jelo, za oči milo i primamljivo za mudrost. Uzme ona od njegovog ploda i pojede. Dala je i svom mužu koji je bio s njom, pa je i on jeo. ");
INSERT INTO srponstl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Uto im se oboma otvore oči i oni shvate da su goli. Zato su spleli smokvino lišće i napravili sebi pregače. ");
INSERT INTO srponstl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Tada su začuli korak Gospoda Boga, koji je šetao vrtom pri dnevnom povetarcu, pa su se sakrili među drvećem u vrtu. ");
INSERT INTO srponstl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Gospod Bog pozva čoveka: „Gde si!“ ");
INSERT INTO srponstl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","„Čuo sam tvoj korak u vrtu, ali sam se uplašio zato što sam go, pa sam se sakrio“ – odazva se čovek. ");
INSERT INTO srponstl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","„Ko ti je rekao da si go? – upita ga Bog. Zar si jeo plod sa drveta s kojeg sam ti zabranio da jedeš?“ ");
INSERT INTO srponstl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","„Žena koju si ti dao da bude sa mnom mi je dala plod sa drveta, pa sam jeo“ – odgovori čovek. ");
INSERT INTO srponstl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","„Šta si to učinila?“ – upita Gospod Bog ženu. „Zmija me je prevarila, pa sam jela“ – odgovori žena. ");
INSERT INTO srponstl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tada Gospod Bog reče zmiji: „Kad si to učinila, prokleta budi među svim životinjama i svim divljim zverima. Na svom trbuhu ćeš puzati i jesti prah celog svog veka!“ ");
INSERT INTO srponstl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Evo, zamećem neprijateljstvo između tebe i žene; između tvog potomstva i njenog potomstva: Ono će ti glavu satirati, a ti ćeš mu petu ujedati. ");
INSERT INTO srponstl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A ženi reče: „Umnožiću tvoje trudničke muke, te ćeš s mukom decu rađati. Žudećeš za svojim mužem, ali on će vladati nad tobom!“ ");
INSERT INTO srponstl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adamu, pak, reče: „Zato što si poslušao svoju ženu, te jeo plod sa drveta za koji sam ti zapovedio: ’Ne jedi s njega!’, evo: Zemlja neka bude prokleta zbog tebe, s mukom ćeš se od nje hraniti celog svog veka! ");
INSERT INTO srponstl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Rađaće ti trnje i korov, a hranićeš se poljskim biljem. ");
INSERT INTO srponstl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Svoj hleb ćeš jesti u znoju svoga lica dok se ne vratiš u zemlju, pošto si iz nje uzet. Jer prah si, i u prah ćeš se vratiti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Čovek dade svojoj ženi ime „Eva“, jer je postala majka svim živima. ");
INSERT INTO srponstl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","A Gospod Bog načini Adamu i njegovoj ženi odeću od kože, pa ih odenu. ");
INSERT INTO srponstl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Onda Gospod Bog reče: „Evo, čovek je sada postao kao jedan od nas znajući dobro i zlo. Stoga mu se ne sme dozvoliti da pruži ruku i uzme plod sa drveta, pa da ga pojede i živi večno.“ ");
INSERT INTO srponstl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Zato ga Gospod Bog istera iz edenskog vrta da obrađuje zemlju iz koje je i uzet. ");
INSERT INTO srponstl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Pošto je isterao čoveka, Gospod Bog je istočno od edenskog vrta postavio heruvime i plameni mač koji je vitlao tamo i amo, da stražare na putu koji vodi k drvetu života. ");
INSERT INTO srponstl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam leže sa svojom ženom Evom, te ona začne i rodi sina. Nazvala ga je Kajin, rekavši: „Stekla sam čoveka pomoću Gospoda.“ ");
INSERT INTO srponstl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Potom je rodila njegovog brata Avelja. Avelj je postao pastir sitne stoke, a Kajin zemljoradnik. ");
INSERT INTO srponstl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Jednog dana Kajin prinese Gospodu prinos od zemaljskih plodova. ");
INSERT INTO srponstl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","A Avelj prinese kao prinos najbolje delove mesa od prvine svoga stada. I Gospod blagonaklono pogleda na Aveljev prinos, ");
INSERT INTO srponstl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","a na Kajina i njegov prinos se nije ni obazreo. Zato se Kajin veoma naljuti i lice mu se namrgodi. ");
INSERT INTO srponstl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Gospod reče Kajinu: „Zašto se ljutiš i zašto ti se lice namrgodilo? ");
INSERT INTO srponstl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ako činiš dobro, nećeš li biti vedar? A ako ne činiš dobro, greh vreba pred vratima; on žudi da te svlada, ali ti moraš da ga nadvladaš.“ ");
INSERT INTO srponstl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kajin reče svome bratu Avelju: „Hajdemo u polje!“ Ali kada su se našli u polju, Kajin napadne svoga brata Avelja i ubije ga. ");
INSERT INTO srponstl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Zatim Gospod upita Kajina: „Gde je tvoj brat, Avelj?“ Kajin odgovori: „Ne znam. Zar sam ja čuvar svoga brata?“ ");
INSERT INTO srponstl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Gospod reče: „Šta si to učinio?! Glas krvi tvoga brata vapi k meni sa zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Stoga budi proklet: izgonim te sa zemlje koja je otvorila svoja usta da primi krv tvoga brata koju si prolio svojom rukom. ");
INSERT INTO srponstl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kada budeš obrađivao zemlju, ona ti neće davati svoj rod. Bićeš lutalica i begunac na zemlji!“ ");
INSERT INTO srponstl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kajin reče Gospodu: „Preteško je snositi moju kaznu. ");
INSERT INTO srponstl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Evo, danas me izgoniš s lica zemlje. Sakrivaću se pred tvojim licem, i biću lutalica i begunac na zemlji, a svako ko me nađe moći će da me ubije.“ ");
INSERT INTO srponstl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Gospod mu reče: „Ne! Ukoliko neko i ubije Kajina, na njemu će se izvršiti sedam puta veća osveta.“ Gospod tada stavi znak na Kajina, da ga ne ubije ko ga nađe. ");
INSERT INTO srponstl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kajin ode pred licem Gospodnjim i nastani se u zemlji Nod, istočno od Edena. ");
INSERT INTO srponstl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kajin leže sa svojom ženom, te ona zače i rodi Enoha. Kajin je sagradio grad i dao mu ime po imenu svoga sina – Enoh. ");
INSERT INTO srponstl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enohu se rodio Irad, Iradu Mehujael, Mehujaelu Metusael, Metusaelu Lameh. ");
INSERT INTO srponstl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameh je uzeo sebi dve žene: jedna se zvala Ada, a druga Sela. ");
INSERT INTO srponstl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada je rodila Javala koji je bio praotac onih što žive pod šatorom i uzgajaju sitnu stoku. ");
INSERT INTO srponstl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Njegovom bratu je bilo ime Juval. On je praotac onih koji sviraju liru i sviralu. ");
INSERT INTO srponstl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sela je rodila Tuval Kajina koji je kovao svaku vrstu oruđa od bronze i gvožđa. Njegova sestra se zvala Nama. ");
INSERT INTO srponstl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameh reče svojim ženama: „Ada i Sela, čujte moj glas! Žene Lamehove, besedu moju saslušajte. Čoveka sam ubio, jer me je ranio, mladića, jer me je udario. ");
INSERT INTO srponstl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ako će Kajinov život biti osvećen sedam puta više, Lamehov će biti sedamdeset sedam puta više.“ ");
INSERT INTO srponstl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam ponovo leže sa svojom ženom i ona rodi sina kome dade ime „Sit“, rekavši: „Bog mi je poklonio potomka umesto Avelja, koga je ubio Kajin.“ ");
INSERT INTO srponstl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","I Situ se rodio sin, kojemu je dao ime Enos. Otada se počelo prizivati ime Gospodnje. ");
INSERT INTO srponstl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ovo je zapis Adamovog rodoslova. Kada je Bog onog dana stvorio čoveka, načinio ga je po svom liku. ");
INSERT INTO srponstl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Stvorio ih je muško i žensko. Onog dana kada ih je stvorio, blagoslovio ih je i nazvao „čovek“. ");
INSERT INTO srponstl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Kada je Adamu bilo stotinu trideset godina rodio mu se sin, njemu sličnom. Dao mu je ime Sit. ");
INSERT INTO srponstl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Nakon što mu se rodio Sit, Adam je živeo još osam stotina godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam je ukupno živeo devet stotina trideset godina, te umro. ");
INSERT INTO srponstl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Kada je Situ bilo stotinu i pet godina, rodio mu se Enos. ");
INSERT INTO srponstl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Posle njegovog rođenja, Sit je živeo još osam stotina sedam godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sit je ukupno živeo devet stotina dvanaest godina, te umro. ");
INSERT INTO srponstl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Kada je Enosu bilo devedeset godina, rodio mu se Kajinan. ");
INSERT INTO srponstl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Nakon što mu se rodio Kajinan, Enos je živeo još osam stotina petnaest godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enos je ukupno živeo devet stotina pet godina, te umro. ");
INSERT INTO srponstl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kada je Kajinanu bilo sedamdeset godina, rodio mu se Maleleilo. ");
INSERT INTO srponstl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Nakon što mu se rodio Maleleilo, Kajinan je živeo još osam stotina četrdeset godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kajinan je ukupno živeo devet stotina deset godina, te umro. ");
INSERT INTO srponstl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Kada je Maleleilu bilo šezdeset pet godina, rodio mu se Jared. ");
INSERT INTO srponstl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Nakon što mu se rodio Jared, Maleleilo je živeo još osam stotina trideset godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Maleleilo je ukupno živeo osam stotina devedeset pet godina, te umro. ");
INSERT INTO srponstl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Kada je Jaredu bilo stotinu šezdeset dve godine, rodio mu se Enoh. ");
INSERT INTO srponstl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Nakon što mu se rodio Enoh, Jared je živeo još osam stotina godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared je ukupno živeo devet stotina šezdeset dve godine, te umro. ");
INSERT INTO srponstl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Kada je Enohu bilo šezdeset pet godina, rodio mu se Matusal. ");
INSERT INTO srponstl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Nakon Matusalovog rođenja Enoh je živeo sa Bogom još tri stotine godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoh je ukupno živeo tri stotine šezdeset pet godina. ");
INSERT INTO srponstl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoh je živeo sa Bogom, a onda nestao, jer ga je Bog uzeo. ");
INSERT INTO srponstl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Kada je Matusalu bilo stotinu osamdeset sedam godina, rodio mu se Lameh. ");
INSERT INTO srponstl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Nakon Lamehovog rođenja, Matusal je živeo još sedam stotina osamdeset dve godine, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Matusal je ukupno živeo devet stotina šezdeset devet godina, te umro. ");
INSERT INTO srponstl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Kada je Lamehu bilo stotinu osamdeset dve godine, rodio mu se sin. ");
INSERT INTO srponstl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Dao mu je ime „Noje“, rekavši: „On će nas utešiti u trudu i naporu naših ruku na zemlji koju je prokleo Gospod.“ ");
INSERT INTO srponstl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nakon Nojevog rođenja, Lameh je živeo još pet stotina devedeset pet godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameh je ukupno živeo sedam stotina sedamdeset sedam godina, te umro. ");
INSERT INTO srponstl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Kada je Noju bilo pet stotina godina, rodili su mu se Sim, Ham i Jafet. ");
INSERT INTO srponstl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Kada su ljudi počeli da se šire na zemlji i ćerke im se rodile, ");
INSERT INTO srponstl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","opaze sinovi Božiji da su ćerke ljudske lepe, pa su ih uzimali sebi za žene po svom izboru. ");
INSERT INTO srponstl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Gospod reče: „Neće moj Duh zauvek ostati u čoveku, jer je telesan. Stoga, neka mu životni vek bude stotinu dvadeset godina.“ ");
INSERT INTO srponstl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","U one dane, a i posle, kada su sinovi Božiji odlazili ćerkama ljudskim i one im rađale decu, na zemlji su se pojavili Nefilimi. Oni su bili od davnina čuveni ljudi. ");
INSERT INTO srponstl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Gospod je video da je čovekova pokvarenost na zemlji velika i da je svaka namera koju čovek kuje u sebi uvek samo zlo. ");
INSERT INTO srponstl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Gospod je požalio što je stvorio ljude na zemlji i to zaboli njegovo srce. ");
INSERT INTO srponstl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Tada Gospod reče: „Istrebiću sa lica zemlje ljude koje sam stvorio, zajedno sa životinjama, gmizavcima i pticama nebeskim, jer sam požalio što sam ih stvorio.“ ");
INSERT INTO srponstl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ipak, Noje je našao naklonost u Gospodnjim očima. ");
INSERT INTO srponstl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ovo je zapis o Noju. Noje je bio pravedan i besprekoran čovek među svojim savremenicima. Noje je živeo sa Bogom. ");
INSERT INTO srponstl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noju su se rodila tri sina: Sim, Ham i Jafet. ");
INSERT INTO srponstl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","No, zemlja se bila iskvarila pred Bogom; ispunila se nasiljem. ");
INSERT INTO srponstl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Bog pogleda na zemlju, a ono, cela zemlja se iskvarila i svaki čovek na zemlji se izopačio. ");
INSERT INTO srponstl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Bog reče Noju: „Odlučio sam da okončam život svim ljudima, jer se zemlja ispunila nasiljem zbog njih. Evo, istrebiću ih zajedno sa zemljom! ");
INSERT INTO srponstl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Zato napravi sebi plovilo od čempresovog drveta. U plovilu ćeš napraviti pregrade, a spolja i iznutra premazaćeš ga smolom. ");
INSERT INTO srponstl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","A evo kako ćeš ga napraviti: dužina će mu biti tri stotine lakata, širina pedeset lakata i visina trideset lakata. ");
INSERT INTO srponstl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Na plovilu načini otvor za svetlost i pokrij ga nadstrešnicom lakat od vrha. Vrata na plovilu postavi sa strane; neka ima donji, srednji i gornji sprat. ");
INSERT INTO srponstl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Evo, ja ću pustiti potopne vode na zemlju da istrebim svako živo biće pod nebom, sve što u sebi ima dah života. Sve na zemlji će izginuti! ");
INSERT INTO srponstl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ali sa tobom ću sklopiti savez. Ući ćeš u plovilo ti, tvoji sinovi, tvoja žena i žene tvojih sinova. ");
INSERT INTO srponstl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","A od svakog živog bića uvedi u plovilo po dvoje, da s tobom prežive; i neka budu muško i žensko. ");
INSERT INTO srponstl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Po dvoje od ptica prema njihovim vrstama, od životinja prema njihovim vrstama i od gmizavaca što puze po zemlji neka uđu k tebi da prežive. ");
INSERT INTO srponstl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Sa sobom ponesi svaku vrstu hrane pa čuvaj, da bude i tebi i njima za jelo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noje učini tako. Sve što mu je Bog zapovedio, on je to izvršio. ");
INSERT INTO srponstl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Tada Gospod reče Noju: „Uđi u plovilo ti i cela tvoja porodica, jer vidim da si ti jedini pravedan preda mnom u ovom naraštaju. ");
INSERT INTO srponstl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Od svih čistih životinja uzmi sa sobom po sedam parova: mužjaka sa ženkom, a od životinja koje nisu čiste uzmi po par: mužjaka sa ženkom. ");
INSERT INTO srponstl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Isto tako i od svih ptica nebeskih uzmi po sedam parova: mužjaka sa ženkom, da bi im se sačuvalo potomstvo na celoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Naime, za sedam dana ću pustiti kišu da pada na zemlju četrdeset dana i četrdeset noći, te ću istrebiti s lica zemlje svako živo biće koje sam načinio.“ ");
INSERT INTO srponstl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noje učini sve kako mu je Gospod zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noju je bilo šest stotina godina kada je potop došao na zemlju. ");
INSERT INTO srponstl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Zbog voda potopa Noje uđe u plovilo sa svojim sinovima, svojom ženom i ženama svojih sinova. ");
INSERT INTO srponstl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Od svih čistih životinja i od životinja koje nisu čiste, od ptica i od svega što puzi po zemlji, ");
INSERT INTO srponstl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","uđe k Noju u plovilo po dvoje, mužjak i ženka, kao što je Bog zapovedio Noju. ");
INSERT INTO srponstl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Kada se navršilo sedam dana, navale vode potopa na zemlju. ");
INSERT INTO srponstl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Šeststote godine Nojevog života, drugog meseca, sedamnaestoga dana tog meseca, provale svi izvori velikog bezdana i otvore se sva okna na nebesima. ");
INSERT INTO srponstl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Kiša je pljuštala po zemlji četrdeset dana i četrdeset noći. ");
INSERT INTO srponstl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tog istog dana uđu u plovilo Noje i njegovi sinovi: Sim, Ham i Jafet, Nojeva žena i tri žene njegovih sinova. ");
INSERT INTO srponstl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Sa njima su ušle sve životinje po svojim vrstama: stoka, gmizavci što puze po zemlji i svakojake ptice, sve što ima krila. ");
INSERT INTO srponstl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ušli su k Noju u plovilo dvoje po dvoje od svakog bića što u sebi ima dah života. ");
INSERT INTO srponstl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Životinje koje su ušle unutra bile su par: muško i žensko od svakog bića, baš kao što je Bog zapovedio Noju. Zatim je Gospod zatvorio vrata za njim. ");
INSERT INTO srponstl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Potop je trajao na zemlji četrdeset dana. Voda je neprestano rasla, tako da je ponela plovilo koje se odiglo od zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Voda je navaljivala i podigla se visoko nad zemljom, pa je plovilo počelo da plovi po površini vode. ");
INSERT INTO srponstl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Voda je navaljivala sve jače i jače nad zemljom, te je prekrila sve najviše gore pod celim nebom. ");
INSERT INTO srponstl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Nabujala voda se uzdigla petnaest lakata povrh gora. ");
INSERT INTO srponstl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tako su izginula sva bića koja se kreću po zemlji: ptice, stoka, zveri, svi gmizavci i svi ljudi. ");
INSERT INTO srponstl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Sve što je u svojim nozdrvama imalo dah života, sve što je bilo na kopnu, izginulo je. ");
INSERT INTO srponstl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Gospod je istrebio sva živa bića s lica zemlje: ljude, životinje, gmizavce i ptice na nebu – sve njih je istrebio sa zemlje. Ostao je samo Noje i oni što su bili s njim u plovilu. ");
INSERT INTO srponstl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Stotinu pedeset dana je voda gospodarila zemljom. ");
INSERT INTO srponstl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ipak, Bog se setio Noja i svih životinja i sve stoke što je bila s njim u plovilu; pokrenuo je vetar da duva nad zemljom i voda se povukla. ");
INSERT INTO srponstl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Zatvorili su se izvori bezdana i okna na nebesima, te je pljusak sa neba prestao. ");
INSERT INTO srponstl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Voda se postepeno povlačila sa zemlje. Nakon stotinu pedeset dana voda je opala. ");
INSERT INTO srponstl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","A sedamnaestoga dana sedmog meseca plovilo se zaustavilo na bregovima Ararata. ");
INSERT INTO srponstl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Voda je neprestano opadala do desetog meseca, a prvog dana tog meseca su se pokazali planinski vrhovi. ");
INSERT INTO srponstl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Nakon četrdeset dana Noje otvori prozor koji je načinio, ");
INSERT INTO srponstl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","pa pošalje gavrana koji je odletao i doletao dok se voda na zemlji nije isušila. ");
INSERT INTO srponstl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Onda je poslao golubicu da vidi da li se voda povukla sa zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ali golubica nije našla čvrsto tlo da spusti svoje noge, pa se vratila k Noju u plovilo zato što je voda još uvek pokrivala celu zemlju. On pruži ruku, uzme golubicu i unese je k sebi u plovilo. ");
INSERT INTO srponstl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Sačekao je još sedam dana pa je ponovo poslao golubicu iz plovila. ");
INSERT INTO srponstl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Golubica se vratila uveče, i gle, u kljunu joj svež maslinov list. Po tome je Noje znao da je opala voda sa zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Onda je pričekao još sedam dana pa je poslao golubicu. No, ona mu se nije više vratila. ");
INSERT INTO srponstl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Šest stotina prve godine Nojevog života, prvog meseca, prvog dana u mesecu, voda se povukla sa zemlje. Noje skine poklopac sa plovila, pogleda, a ono, površina zemlje suva. ");
INSERT INTO srponstl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Drugog meseca, dvadeset sedmoga dana u mesecu, zemlja je bila suva. ");
INSERT INTO srponstl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Bog reče Noju: ");
INSERT INTO srponstl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","„Izađi iz plovila ti, tvoja žena, tvoji sinovi i žene tvojih sinova s tobom. ");
INSERT INTO srponstl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Sa sobom povedi sva živa bića, sve životinje koje su s tobom: ptice, stoku i sve gmizavce što puze po zemlji. Neka vrve zemljom, plode se i množe se po zemlji!“ ");
INSERT INTO srponstl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","I Noje izađe sa svojim sinovima, sa svojom ženom i sa ženama svojih sinova. ");
INSERT INTO srponstl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","I sve životinje, svi gmizavci, sve ptice, sva stvorenja što puze po zemlji izađu iz plovila, vrsta za vrstom. ");
INSERT INTO srponstl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Tada Noje sagradi žrtvenik Gospodu, te uzme od sve čiste stoke i svih čistih ptica i prinese na žrtveniku žrtve svespalnice. ");
INSERT INTO srponstl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Gospod omirisa ugodni miris, pa reče u svom srcu: „Nikad više neću zemlju izručiti prokletstvu zbog čoveka, jer su čovekove namere zle od detinjstva, niti ću ikad više uništiti sva živa bića koja sam stvorio. ");
INSERT INTO srponstl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Sve dok bude zemlje, setve i žetve, studeni i vrućine, leta i zime, dana i noći, nikada neće prestati.“ ");
INSERT INTO srponstl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Zatim Bog blagoslovi Noja i njegove sinove i reče im: „Plodite se i množite i napunite zemlju. ");
INSERT INTO srponstl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bojaće vas se i strahovati od vas sve životinje na zemlji, sve ptice nebeske, sve što se kreće po zemlji, i sve ribe u moru; u vaše ruke su predate. ");
INSERT INTO srponstl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Sve što se kreće i živi biće vam za hranu, kao i zeleno bilje; sve vam to dajem. ");
INSERT INTO srponstl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ali meso s njegovim životom, to jest, s njegovom krvlju ne smete jesti. ");
INSERT INTO srponstl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","A ko prolije vašu krv u kojoj je vaš život, tražiću da odgovara za to. Tražiću da odgovara svaka životinja i svaki čovek za svoga brata. ");
INSERT INTO srponstl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ko prolije krv čovekovu, njegovu će krv čovek proliti, jer po svome liku stvori Bog čoveka. ");
INSERT INTO srponstl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","A vi, plodite se i množite i raširite po zemlji množeći se na njoj.“ ");
INSERT INTO srponstl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Još reče Bog Noju i njegovim sinovima što su bili s njim: ");
INSERT INTO srponstl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","„Evo, ja sklapam svoj savez s vama i s vašim potomstvom posle vas, ");
INSERT INTO srponstl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","i sa svim živim bićima s vama: s pticama, sa stokom i svim divljim životinjama na zemlji – s onima što su s vama izašle iz plovila – sa svim životinjama na zemlji. ");
INSERT INTO srponstl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ja ću se držati svog saveza s vama, te potopne vode nikad više neće uništiti sva živa bića, niti će ikad više potop pustošiti zemlju.“ ");
INSERT INTO srponstl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Još reče Bog: „Ovo je znak saveza koji sklapam između sebe i vas i svih živih bića što su s vama, savez za sva buduća pokolenja. ");
INSERT INTO srponstl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Svoju dugu postavljam u oblake da bude znak saveza između mene i zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","A kad navučem oblake nad zemljom i pojavi se duga u oblacima, ");
INSERT INTO srponstl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","tada ću se setiti svoga saveza između sebe i vas, i svakog živog bića, svakog stvorenja: neće više biti potopnih voda da zatru svako stvorenje. ");
INSERT INTO srponstl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kad se duga pojavi u oblacima, ja ću na nju pogledati i setiti se večnog saveza između Boga i svakog živog bića, svakog stvorenja na zemlji.“ ");
INSERT INTO srponstl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Na kraju reče Bog Noju: „Ovo je znak saveza koji sam sklopio između sebe i svakog stvorenja na zemlji.“ ");
INSERT INTO srponstl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nojevi sinovi, koji su izašli iz plovila, bili su: Sim, Ham i Jafet. Ham je otac Hananov. ");
INSERT INTO srponstl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ova trojica su Nojevi sinovi; od njih je poteklo čovečanstvo koje se raširilo po celoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noje počne da obrađuje zemlju i zasadi vinograd. ");
INSERT INTO srponstl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Jednom se on napije vina i opije, pa se svuče go nasred svog šatora. ");
INSERT INTO srponstl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, otac Hananov, opazi golotinju svoga oca, pa javi to dvojici svoje braće napolju. ");
INSERT INTO srponstl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Tada Sim i Jafet uzmu ogrtač, prebace ga sebi preko ramena, pa hodajući natraške pokriju očevu golotinju. Licem su bili okrenuti na drugu stranu, tako da nisu videli očevu golotinju. ");
INSERT INTO srponstl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kad se Noje otreznio od vina, doznao je šta mu je učinio najmlađi sin. ");
INSERT INTO srponstl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Tada Noje reče: „Proklet da je Hanan, svojoj braći najniži sluga neka bude!“ ");
INSERT INTO srponstl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Potom je rekao: „Neka je blagosloven Gospod, Bog Simov, Hanan neka mu sluga bude! ");
INSERT INTO srponstl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Neka Bog umnoži potomstvo Jafetovo, neka živi među šatorima Simovim, Hanan neka mu je sluga!“ ");
INSERT INTO srponstl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noje je živeo još tri stotine pedeset godina nakon potopa. ");
INSERT INTO srponstl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noje je ukupno živeo devet stotina pedeset godina i umro. ");
INSERT INTO srponstl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ovo je rodoslov Nojevih sinova: Sima, Hama i Jafeta. Njima su se rodili sinovi posle potopa. ");
INSERT INTO srponstl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafetovi sinovi su: Gomer, Magog, Midij, Javan, Tuval, Meseh i Tiras. ");
INSERT INTO srponstl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomerovi sinovi su: Ashenas, Rifat i Togarma. ");
INSERT INTO srponstl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javanovi sinovi su: Elisa i Tarsis, Kitim i Dodanim. ");
INSERT INTO srponstl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Od njih su se razgranali ostrvski narodi po svojim zemljama; svaki sa svojim jezikom, svojim rodovima i svojim narodima.) ");
INSERT INTO srponstl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamovi sinovi su: Kuš i Misraim, Fut i Hanan. ");
INSERT INTO srponstl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","A Kušovi sinovi su: Seva, Evila, Savata, Regma i Savataka. Regmini sinovi su: Sava i Dedan. ");
INSERT INTO srponstl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kušu se rodio Nevrod. Ovaj je postao prvi moćnik na zemlji. ");
INSERT INTO srponstl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","On je bio i moćni lovac pred Gospodom. Zato se kaže: „Kao Nevrod, moćni lovac pred Gospodom.“ ");
INSERT INTO srponstl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Njegovo carstvo su u početku sačinjavali: Vavilon, Oreh, Arhad i Halani u zemlji Senar. ");
INSERT INTO srponstl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Iz te zemlje je otišao u Asiriju i podigao Ninivu, Rehovot Ir i Halah, ");
INSERT INTO srponstl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","te Resen između Ninive i velikog grada Halaha. ");
INSERT INTO srponstl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Od Misraima su, pak, potekli Ludejci, Enemejci, Lavejci i Naftuhijci, ");
INSERT INTO srponstl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","pa Patrošani, Haslonjani (od kojih su potekli Filistejci) i Kaftoreji. ");
INSERT INTO srponstl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Hananu se rodio Sidon, njegov prvenac, i Het. ");
INSERT INTO srponstl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Od Hanana vode poreklo Jevusejci, Amorejci, Gergešani, ");
INSERT INTO srponstl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Evejci, Arukejci, Sinijci, ");
INSERT INTO srponstl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvađani, Samarjani, i Amaćani. Posle su se hananska plemena rasejala, ");
INSERT INTO srponstl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","tako da se granica Hananaca protezala od Sidona prema Geraru, sve do Gaze, pa prema Sodomi i Gomori, Admi i Sevojimu, sve do Lasa. ");
INSERT INTO srponstl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","To su Hamovi potomci, prema svojim plemenima i jezicima, po svojim zemljama i narodima. ");
INSERT INTO srponstl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","A i Simu, praocu svih sinova Everovih, starijem bratu Jafetovom, rodili su se sinovi. ");
INSERT INTO srponstl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Simovi sinovi: Elam, Asur, Arfaksad, Lud i Aram. ");
INSERT INTO srponstl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","A Aramovi sinovi su: Uz, Ul, Geter i Mas. ");
INSERT INTO srponstl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaksadu se, pak, rodio Sala, a Sali Ever. ");
INSERT INTO srponstl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Everu su se rodila dva sina: jedan se zvao Falek, jer su se za vreme njegovog života ljudi na zemlji podelili; a njegov brat se zvao Jektan. ");
INSERT INTO srponstl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jektanu su se rodili Elmodad, Salef, Acarmavet i Jarah, ");
INSERT INTO srponstl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dikla, ");
INSERT INTO srponstl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Oval, Avimail, Sava, ");
INSERT INTO srponstl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Evila i Jovav; svi ovi su bili Jektanovi sinovi. ");
INSERT INTO srponstl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Njihova su se naselja protezala od Mase do Safira, istočnog gorja. ");
INSERT INTO srponstl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","To su Simovi sinovi prema svojim plemenima i jezicima, zemljama i narodima. ");
INSERT INTO srponstl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","To su plemena Nojevih sinova prema svojim rodoslovima i narodima. Od njih su se razgranali narodi posle potopa. ");
INSERT INTO srponstl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","U ono vreme je sva zemlja imala isti jezik i iste reči. ");
INSERT INTO srponstl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","No, seleći se na istok, ljudi naiđu na dolinu u zemlji Senar, i tu se nastane. ");
INSERT INTO srponstl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Tada rekoše jedan drugome: „Hajde da pravimo opeke i da ih valjano ispečemo!“ Opeke su im bile umesto kamena, a smola im je služila umesto maltera. ");
INSERT INTO srponstl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Zatim rekoše: „Hajde da sagradimo sebi grad i kulu s vrhom do nebesa. Stecimo time sebi ugled, da se ne bismo rasejali po zemlji.“ ");
INSERT INTO srponstl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tada je Gospod sišao da vidi grad i kulu što su ljudi gradili. ");
INSERT INTO srponstl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Gospod reče: „Pošto su oni jedan narod i svi imaju isti jezik, onda je ovo tek početak njihovog delovanja. Zato im sad ništa neće biti neostvarivo što god da naume. ");
INSERT INTO srponstl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Hajde da siđemo i pobrkamo im jezik, da ne razumeju šta govore jedan drugome!“ ");
INSERT INTO srponstl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Tako ih je Gospod odatle rasuo po celoj zemlji, te su prestali da grade grad. ");
INSERT INTO srponstl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Zato mu je ime Vavilon, jer je tamo Gospod pobrkao jezik celoj zemlji, i odatle rasuo ljude po celoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ovo je Simov rodoslov: Dve godine posle potopa, kad je Simu bilo stotinu godina, rodio mu se Arfaksad. ");
INSERT INTO srponstl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Nakon što mu se rodio Arfaksad, Sim je živeo još pet stotina godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Kad je Arfaksadu bilo trideset pet godina, rodio mu se Sala. ");
INSERT INTO srponstl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nakon Salinog rođenja, Arfaksad je živeo još četiri stotine tri godine, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sali je bilo trideset godina kad mu se rodio Ever. ");
INSERT INTO srponstl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Posle Everovog rođenja, Sala je živeo još četiri stotine tri godine, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Kad su Everu bile trideset četiri godine, rodio mu se Falek. ");
INSERT INTO srponstl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nakon Falekovog rođenja, Ever je živeo još četiri stotine trideset godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Kad je Faleku bilo trideset godina, rodio mu se Ragav. ");
INSERT INTO srponstl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Posle Ragavovog rođenja, Falek je živeo još dve stotina devet godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Kad su Ragavu bile trideset dve godine, rodio mu se Seruh. ");
INSERT INTO srponstl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Posle Seruhovog rođenja, Ragav je živeo još dve stotine sedam godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Kad je Seruhu bilo trideset godina, rodio mu se Nahor. ");
INSERT INTO srponstl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nakon Nahorovog rođenja, Seruh je živeo još dve stotine godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Kad je Nahoru bilo dvadeset devet godina, rodio mu se Tara. ");
INSERT INTO srponstl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nakon Tarinog rođenja, Nahor je živeo još stotinu i devetnaest godina, te mu se rodilo još sinova i ćerki. ");
INSERT INTO srponstl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Kad je Tari bilo sedamdeset godina, rodili su mu se Avram, Nahor i Aran. ");
INSERT INTO srponstl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ovo je Tarin rodoslov: Tari su se rodili Avram, Nahor i Aran. Aranu se rodio Lot. ");
INSERT INTO srponstl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Aran je umro pre svoga oca Tare u svom rodnom kraju u Uru Haldejskom. ");
INSERT INTO srponstl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Avram i Nahor su se oženili. Avramovoj ženi je bilo ime Saraja, a Nahorovoj Melha; ova je bila ćerka Arana, koji je takođe bio otac Jeske. ");
INSERT INTO srponstl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Međutim, Saraja je bila nerotkinja, nije imala dece. ");
INSERT INTO srponstl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tara povede svoga sina Avrama, svoga unuka Lota, Aranovog sina, svoju snahu Saraju, ženu svoga sina Avrama, pa se s njima zaputi iz Ura Haldejskoga u Hanan. Tako dođu do Harana i tamo se nastane. ");
INSERT INTO srponstl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tara je živeo dve stotine pet godina. Umro je u Haranu. ");
INSERT INTO srponstl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Gospod reče Avramu: „Idi iz svoje zemlje, od svoje rodbine i doma svoga oca u zemlju koju ću ti pokazati. ");
INSERT INTO srponstl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Učiniću od tebe veliki narod, blagosloviću te i ime ti učiniti slavnim; ti sam ćeš biti blagoslov. ");
INSERT INTO srponstl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Blagosloviću one koji tebe blagoslove, a prokleću onog koji tebe proklinje. Po tebi će biti blagoslovena sva plemena na zemlji.“ ");
INSERT INTO srponstl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Avram je krenuo onako kako mu je rekao Gospod. Sa njim je pošao i Lot. Avramu je bilo sedamdeset pet godina kada je otišao iz Harana. ");
INSERT INTO srponstl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Avram je poveo sa sobom svoju ženu Saraju i Lota, sina svoga brata, i svu imovinu koju su stekli, zajedno sa svim slugama koje su pribavili u Haranu, te svi pođu za Hanan. Došavši u Hanan, ");
INSERT INTO srponstl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Avram je putovao do mesta Sihema – do velikog hrasta More. U to vreme su Hananci živeli u zemlji. ");
INSERT INTO srponstl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Gospod se ukazao Avramu i rekao mu: „Tvome potomstvu ću dati ovu zemlju.“ Na tom mestu je Avram sagradio žrtvenik Gospodu koji mu se ukazao. ");
INSERT INTO srponstl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Odatle je produžio prema brdima istočno od Vetilja, te je postavio svoj šator između Vetilja na zapadu i Gaja na istoku. Tu je Avram sagradio žrtvenik Gospodu i prizvao ime Gospodnje. ");
INSERT INTO srponstl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Avram je potom nastavio da putuje od mesta do mesta prema Negevu. ");
INSERT INTO srponstl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ali kad je u zemlji nastala glad, Avram se spustio u Egipat da tamo provede neko vreme; u zemlji je, naime, zavladala velika glad. ");
INSERT INTO srponstl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kad je bio nadomak Egipta, Avram reče svojoj ženi Saraji: „Brine me što si lepa žena. ");
INSERT INTO srponstl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Kada te Egipćani vide, reći će: ’To je njegova žena.’ Onda će me ubiti, a tebe ostaviti na životu. ");
INSERT INTO srponstl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Zato reci da si moja sestra, da bi se dobro ophodili prema meni, te da bi mi, zbog tebe, poštedeli život.“ ");
INSERT INTO srponstl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kad je Avram ušao u Egipat, opaze Egipćani da je žena veoma lepa. ");
INSERT INTO srponstl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","A kad su je opazile i faraonove sluge, pohvalile su je pred faraonom, pa su je odvele na faraonov dvor. ");
INSERT INTO srponstl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Zbog nje se faraon pokazao dobrim prema Avramu, tako da je ovaj stekao sitnu i krupnu stoku, magarce, sluge i sluškinje, magarice i kamile. ");
INSERT INTO srponstl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ali Gospod udari faraona i sav njegov dom opakim pošastima zbog Avramove žene Saraje. ");
INSERT INTO srponstl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Faraon pozva Avrama i reče mu: „Šta si mi to učinio? Zašto mi nisi rekao da je ona tvoja žena? ");
INSERT INTO srponstl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Zašto si rekao: ’Ona je moja sestra’, a ja je uzeo sebi za ženu? Evo ti sad tvoje žene. Uzmi je i odlazi!“ ");
INSERT INTO srponstl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Faraon ga onda preda svojim ljudima, a ovi ga isprate s njegovom ženom i svom njegovom imovinom. ");
INSERT INTO srponstl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","I tako ode Avram iz Egipta u Negev sa svojom ženom i svom svojom imovinom. S njim je bio i Lot. ");
INSERT INTO srponstl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Avram je bio veoma bogat stokom, srebrom i zlatom. ");
INSERT INTO srponstl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Putujući od mesta do mesta, iz Negeva je stigao do Vetilja, do mesta između Vetilja i Gaja, gde mu je isprva bio šator, ");
INSERT INTO srponstl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","do mesta na kome je ranije podigao žrtvenik. Tu je prizvao ime Gospodnje. ");
INSERT INTO srponstl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","A i Lot, koji je išao s Avramom, je imao ovaca, goveda i šatora. ");
INSERT INTO srponstl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Međutim, zemlja nije mogla da ih izdržava dok su bili zajedno; naime, njihova imovina je bila velika, tako da nisu mogli da žive zajedno. ");
INSERT INTO srponstl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Nastajale su svađe između pastira Avramove stoke i pastira Lotove stoke. U to vreme su u zemlji živeli Hananci i Ferežani. ");
INSERT INTO srponstl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Stoga Avram reče Lotu: „Neka ne bude svađe između tebe i mene, između mojih i tvojih pastira. Pa braća smo! ");
INSERT INTO srponstl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nije li cela zemlja pred tobom? Odvoj se od mene. Kreneš li ti na levo, ja ću na desno, kreneš li na desno, ja ću na levo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot je pogledao oko sebe i video da je sva Jordanska dolina dobro navodnjena, kao vrt Gospodnji, kao zemlja egipatska prema Soaru. To je bilo pre nego što je Gospod uništio Sodomu i Gomoru. ");
INSERT INTO srponstl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot izabere za sebe Jordansku dolinu i ode na istok. Tako su se odvojili jedan od drugog. ");
INSERT INTO srponstl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Avram je živeo u Hananu, a Lot je živeo u gradovima doline i razapeo svoje šatore sve do Sodome. ");
INSERT INTO srponstl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","A stanovnici Sodome su bili opaki: silno su grešili protiv Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Nakon što se Lot odelio, Gospod reče Avramu: „Podigni svoj pogled s mesta na kome si i pogledaj prema severu i jugu, istoku i zapadu, ");
INSERT INTO srponstl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","jer svu zemlju koju vidiš daću tebi i tvome potomstvu zauvek. ");
INSERT INTO srponstl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","A tvoje ću potomstvo učiniti brojnim kao prah na zemlji. Pa ako ko bude mogao da prebroji zrnca prašine, i tvoje će potomstvo moći da izbroji. ");
INSERT INTO srponstl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ustani i prođi zemljom uzduž i popreko, jer ću je tebi dati.“ ");
INSERT INTO srponstl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Avram pokupi svoje šatore i dođe i nastani se kod velikih hrastova Mamrije, što su kod Hevrona. Onde je podigao žrtvenik Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","U te dane, Amrafel car Senara, Arioh car Elasara, Kedor-Laomer car Elama i Tidal car Gojima, ");
INSERT INTO srponstl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","povedu rat protiv Bere, cara sodomskog, Varse, cara gomorskog, Šinaba, cara Adme, Simovora, cara Sevojima i cara Vale, to jest Soara. ");
INSERT INTO srponstl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Svi se oni skupe u dolinu Sidim, gde je Mrtvo more. ");
INSERT INTO srponstl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Dvanaest godina su bili potčinjeni Kedor-Laomeru, ali trinaeste godine se pobune. ");
INSERT INTO srponstl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Četrnaeste godine dođe Kedor-Laomer s carevima što su mu bili saveznici i potuku Refaimce u Astarot-Karnajimu, Zuzejce u Amu i Emijce na ravnici kirijatajimskoj, ");
INSERT INTO srponstl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","te Horijce na njihovoj gori Sir, blizu El-Farana, što je pokraj pustinje. ");
INSERT INTO srponstl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Onda se vrate nazad i dođu u En-Mispat, to jest Kadis, i osvoje celu oblast Amaličana i Amorejaca, koji su živeli u Hasason-Tamaru. ");
INSERT INTO srponstl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Tada se digne car Sodome, car Gomore, car Adme, car Sevojima i car Vale, to jest Soara, pa zametnu bitku protiv onih u dolini Sidim: ");
INSERT INTO srponstl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedor-Laomera, cara Elama, Tidala, cara Gojima, Amrafela, cara Senara, Arioha, cara Elasara – četiri cara protiv petorice. ");
INSERT INTO srponstl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Dolina Sidim je bila puna jama sa smolom. Carevi Sodome i Gomore, bežeći, upadnu u njih, a ostali pobegnu u gore. ");
INSERT INTO srponstl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","A pobednici odnesu sva dobra Sodome i Gomore i svu hranu, pa odu. ");
INSERT INTO srponstl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Odveli su i Lota, Avramovog sinovca, koji je živeo u Sodomi, sa svim njegovim dobrima. ");
INSERT INTO srponstl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ali neki begunac dođe i sve ispriča Avramu Jevrejinu, dok je boravio kod hrastova Amorejca Mamrije, brata Eshola i Anera, koji su bili njegovi saveznici. ");
INSERT INTO srponstl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kad je Avram čuo da mu je sinovac zarobljen, sabere svoje ljude vične boju – rođene u njegovom domu – njih tri stotine osamnaest, pa krene u poteru do Dana. ");
INSERT INTO srponstl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Onda ih je podelio u dve grupe, pa je noću napao onu vojsku i potukao je. Gonio ih je sve do Hove, severno od Damaska ");
INSERT INTO srponstl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","i povratio sav plen. Vratio je i svoga sinovca, Lota, sa njegovim dobrima, žene i ostali svet. ");
INSERT INTO srponstl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kad se nakon pobede nad Kedor-Laomerom i carevima koji su bili s njim, Avram vratio u dolinu Save, to jest u Carsku dolinu, izađe mu u susret car Sodome. ");
INSERT INTO srponstl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Tada Melhisedek, car Salima, donese hleb i vino. On je bio sveštenik Boga Svevišnjega. ");
INSERT INTO srponstl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","On blagoslovi Avrama rekavši: „Neka Bog Svevišnji, stvoritelj neba i zemlje, blagoslovi Avrama! ");
INSERT INTO srponstl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Neka je blagosloven Bog Svevišnji, što tebi u ruke izruči neprijatelje tvoje!“ Avram mu tada dade desetak od svega. ");
INSERT INTO srponstl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","A car sodomski reče Avramu: „Meni daj ljude, a ti uzmi dobra.“ ");
INSERT INTO srponstl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ali Avram mu reče: „Podižem ruku pred Gospodom, Bogom Svevišnjim, stvoriteljem neba i zemlje, ");
INSERT INTO srponstl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","da neću uzeti ni končića s remena od obuće, niti išta što ti pripada, da ne bi rekao: ’Ja sam učinio Avrama bogatim!’ ");
INSERT INTO srponstl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Za sebe neću ništa, osim što su moji momci pojeli. Deo plena neka uzmu ljudi koji su pošli sa mnom – Aner, Eshol i Mamrije.“ ");
INSERT INTO srponstl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Posle ovih događaja Gospod objavi svoju reč Avramu u viđenju, govoreći: „Ne boj se, Avrame, ja sam tvoj štit; nagrada tvoja je veoma velika.“ ");
INSERT INTO srponstl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","A Avram upita: „Gospode Bože, šta ćeš da mi daš? Ja nemam poroda, pa će naslednik mog doma biti Eliezer Damaštanin. ");
INSERT INTO srponstl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Pošto mi nisi dao potomstvo – produži Avram – evo, jedan od slugu u mome domu će biti moj naslednik.“ ");
INSERT INTO srponstl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ali Gospod mu ponovo uputi reč: „Neće ti taj biti naslednik, nego će ti naslednik biti tvoj potomak, od tebe samog.“ ");
INSERT INTO srponstl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Zatim ga Gospod izvede napolje i reče mu: „Pogledaj na nebo i prebroj zvezde ako ih možeš prebrojati. Toliko će biti tvoje potomstvo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Avram poverova Gospodu, i Gospod mu to uračuna u pravednost. ");
INSERT INTO srponstl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Zatim mu Bog reče: „Ja sam Gospod koji te je izveo iz Ura Haldejskog da ti dam ovu zemlju u posed.“ ");
INSERT INTO srponstl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ali Avram upita: „Gospode Bože, kako ću znati da ću je dobiti u posed?“ ");
INSERT INTO srponstl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Bog mu reče: „Prinesi mi junicu od tri godine, kozu od tri godine, ovna od tri godine, jednu grlicu i golubića.“ ");
INSERT INTO srponstl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Avram mu je doneo sve te životinje, rasekao ih na pola i sve polovine postavio jednu naspram druge; ptice nije rasecao. ");
INSERT INTO srponstl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","U taj čas se ptice grabljivice okome na mrtve životinje, ali ih je Avram terao. ");
INSERT INTO srponstl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","A kad je sunce bilo na zalasku, Avrama obuzme dubok san, a onda se na njega spusti gusta tama puna užasa. ");
INSERT INTO srponstl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Tada mu Bog reče: „Zacelo znaj da će tvoji potomci biti došljaci u zemlji koja neće biti njihova. Tamo će robovati i biti tlačeni četiri stotine godina. ");
INSERT INTO srponstl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ali narodu kome budu robovali ja ću suditi, a na kraju će izaći iz te zemlje sa velikim blagom. ");
INSERT INTO srponstl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","A ti ćeš se pridružiti svojim precima u miru; u dubokoj starosti bićeš sahranjen. ");
INSERT INTO srponstl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tvoji potomci će se vratiti za četvrtog naraštaja, jer se još nije navršila mera amorejskih zlodela.“ ");
INSERT INTO srponstl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kad je sunce zašlo i spustila se tama, odjednom se pojavi zadimljena peć i goruća baklja, koja je prošla između životinjskih polovina. ");
INSERT INTO srponstl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Toga dana je Gospod sklopio savez s Avramom, rekavši: „Tvome potomstvu dajem ovu zemlju, od reke u Egiptu do velike reke, reke Eufrata: ");
INSERT INTO srponstl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","zemlju Kenejaca, Kenezejaca, Kadmonejaca, ");
INSERT INTO srponstl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hetita, Ferežana, Refaimaca, ");
INSERT INTO srponstl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorejaca, Hananejaca, Gergešana i Jevusejaca.“ ");
INSERT INTO srponstl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","No, Avramova žena Saraja nije Avramu rađala dece. Ona je imala sluškinju Egipćanku koja se zvala Agara. ");
INSERT INTO srponstl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saraja reče Avramu: „Evo, Gospod me je učinio nerotkinjom. Idi i lezi s mojom sluškinjom, možda ću preko nje steći potomstvo.“ Avram je poslušao što mu je Saraja rekla. ");
INSERT INTO srponstl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tada je Avramova žena Saraja dovela Avramu svoju sluškinju Agaru Egipćanku i dala mu je za ženu (bilo je to deset godina nakon što se Avram naselio u Hananskoj zemlji). ");
INSERT INTO srponstl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Avram legne sa Agarom i ona zatrudni. Kad je videla da je zatrudnela, s prezirom je gledala na svoju gospodaricu. ");
INSERT INTO srponstl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saraja tada reče Avramu: „Tvoja je krivica što mi se nanosi ova nepravda. Predala sam svoju sluškinju u tvoj zagrljaj, ali otkako je opazila da je zatrudnela, počela je s prezirom da gleda na mene. Neka Gospod presudi ko je od nas dvoje kriv!“ ");
INSERT INTO srponstl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Avram odgovori Saraji: „Evo, tvoja sluškinja je u tvojoj vlasti. Kako ti se čini da je dobro, tako postupi prema njoj.“ Saraja poče tako zlostavljati Agaru, da je ova pobegla od nje. ");
INSERT INTO srponstl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","No, Anđeo Gospodnji je nađe kod izvora što je na putu za Sur, ");
INSERT INTO srponstl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","pa je zapita: „Agaro, sluškinjo Sarajina, odakle dolaziš i kuda ideš?“ Agara odgovori: „Bežim od svoje gospodarice Saraje.“ ");
INSERT INTO srponstl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Tada joj Anđeo Gospodnji reče: „Vrati se svojoj gospodarici i pokori joj se!“ ");
INSERT INTO srponstl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Anđeo Gospodnji joj uz to reče: „Veoma ću umnožiti tvoje potomstvo, tako da se neće moći prebrojiti!“ ");
INSERT INTO srponstl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Još joj reče Anđeo Gospodnji: „Evo, začela si i rodićeš sina. Daćeš mu ime ’Ismailo’, jer je Gospod čuo za tvoju nevolju. ");
INSERT INTO srponstl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","On će biti kao divlji magarac: ruka će se njegova na svakoga dizati, i svačija ruka na njega će se dizati, sa svom svojom braćom u neprijateljstvu će živeti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agara je nazvala Gospoda koji joj je govorio: „Ti si Bog koji me vidi!“ Agara je, naime, rekla: „Uistinu, videla sam onoga koji me vidi!“ ");
INSERT INTO srponstl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Zato se taj izvor zove „Vir Lahaj Roj“ i nalazi se između Kadisa i Varada. ");
INSERT INTO srponstl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agara je Avramu rodila sina. Avram je sinu koga mu je Agara rodila, dao ime Ismailo. ");
INSERT INTO srponstl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Avramu je bilo osamdeset šest godina kada mu je Agara rodila Ismaila. ");
INSERT INTO srponstl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Kad je Avramu bilo devedeset devet godina, ukazao mu se Gospod i rekao mu: „Ja sam Bog Svemoćni, po mojoj volji živi i budi besprekoran. ");
INSERT INTO srponstl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Savez svoj sklapam između sebe i tebe, i silno ću te umnožiti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Avram pade ničice, a Bog nastavi da mu govori: ");
INSERT INTO srponstl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","„Ovo je moj savez sa tobom: postaćeš otac mnogim narodima. ");
INSERT INTO srponstl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","I nećeš se više zvati Avram, nego će ti ’Avraham’ biti ime, jer sam te učinio ocem mnogih naroda. ");
INSERT INTO srponstl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Veoma, veoma plodnim ću te učiniti: od tebe će poteći narodi; i carevi će od tebe proisteći. ");
INSERT INTO srponstl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Savez svoj – savez večni – sklapam između sebe i tebe i između tvog potomstva posle tebe kroz sva pokolenja: ja ću biti Bog tebi i tvome potomstvu posle tebe. ");
INSERT INTO srponstl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Svu zemlju hanansku, zemlju u kojoj boraviš kao došljak, dajem u večni posed tebi i tvome potomstvu posle tebe; a ja ću biti njihov Bog.“ ");
INSERT INTO srponstl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Još reče Bog Avrahamu: „A ti drži moj savez, ti i tvoje potomstvo posle tebe, od pokolenja do pokolenja. ");
INSERT INTO srponstl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","A ovo je znak mog saveza između mene i tvog potomstva posle tebe, ovako ćete ga držati: svako muško među vama neka se obrezuje. ");
INSERT INTO srponstl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Obrezujte okrajak svoga tela, i to će biti znak saveza između mene i vas. ");
INSERT INTO srponstl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Svako muško među vama, od pokolenja do pokolenja, neka se obrezuje kad navrši osam dana; i rob, rođen u vašem domu i kupljeni za novac od stranaca koji nije vaš srodnik. ");
INSERT INTO srponstl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Da, čak i rob rođen u vašem domu, kao i kupljen za novac mora se obrezati. To će biti znak na vašem telu da je moj savez sa vama večni savez. ");
INSERT INTO srponstl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","A muškarac koji nije obrezao okrajak svog tela, neka se istrebi iz svog naroda, takav je prekršio moj savez.“ ");
INSERT INTO srponstl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Još reče Bog Avrahamu: „A Saraju, svoju ženu, nećeš više zvati Saraja; ime će joj biti ’Sara’. ");
INSERT INTO srponstl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nju ću blagosloviti; šta više, od nje ću ti dati sina. Ja ću je blagosloviti, te će postati majka narodima, i carevi će naroda od nje poteći.“ ");
INSERT INTO srponstl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Avraham pade ničice, pa se nasmeja i reče u sebi: „Može li se roditi sin čoveku od stotinu godina? Zar će Sara u devedesetoj roditi dete?“ ");
INSERT INTO srponstl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Avraham reče Bogu: „Neka samo Ismailo živi pod tvojim okriljem.“ ");
INSERT INTO srponstl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Bog reče Avrahamu: „Ipak će ti tvoja žena, Sara, roditi sina kome ćeš dati ime ’Isak’. Ja ću sklopiti svoj savez – večni savez – s njim i s njegovim potomstvom posle njega. ");
INSERT INTO srponstl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Uslišiću te i za Ismaila. Evo, blagosloviću ga i učiniti plodnim i veoma ga umnožiti. Dvanaest knezova će poteći od njega, te ću učiniti da od njega naraste veliki narod. ");
INSERT INTO srponstl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ali svoj ću savez sklopiti sa Isakom koga će ti Sara roditi iduće godine u ovo doba.“ ");
INSERT INTO srponstl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kad je Bog završio razgovor sa Avrahamom, uzneo se od njega. ");
INSERT INTO srponstl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Avraham je zatim uzeo svog sina Ismaila i sve robove rođene u njegovom domu, kao i one kupljene za novac – sve muške u Avrahamovom domu – pa ih je istog dana obrezao, kako mu je Bog rekao. ");
INSERT INTO srponstl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Avrahamu je bilo devedeset devet godina kada je bio obrezan. ");
INSERT INTO srponstl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ismailu je bilo trinaest godina kada je bio obrezan. ");
INSERT INTO srponstl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Avraham i njegov sin Ismailo su bili obrezani istoga dana. ");
INSERT INTO srponstl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Sa Avrahamom su bili obrezani i njegovi ukućani rođeni u njegovom domu, kao i svi oni kupljeni za novac od stranaca. ");
INSERT INTO srponstl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Gospod se ukazao Avrahamu kod hrastova Mamrije dok je ovaj sedeo na ulazu u šator tokom dnevne žege. ");
INSERT INTO srponstl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Avraham podigne pogled i ugleda tri čoveka kako stoje nedaleko od njega. Čim ih je ugledao, potrčao je s ulaza u šator njima u susret. Onda se poklonio do zemlje ");
INSERT INTO srponstl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","i rekao: „Gospode, ako sam stekao naklonost pred tobom, nemoj mimoići mene, svoga slugu. ");
INSERT INTO srponstl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Neka se donese malo vode: operite noge i odmorite se pod ovim drvetom. ");
INSERT INTO srponstl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Doneću hleba da se okrepite, pre nego što produžite svojim putem. Jer navratili ste k svome sluzi.“ Oni odgovoriše: „Učini kako si rekao.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Avraham je požurio Sari u šator i rekao: „Brzo uzmi tri mere brašna, umesi pogače i ispeci ih!“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Avraham onda požuri govedima, uhvati mlado i ugojeno tele, pa ga preda momku da ga brže zgotovi. ");
INSERT INTO srponstl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Onda je uzeo maslo, mleko i ono tele koje je zgotovio, pa je sve to izneo pred one posetioce. A on sam je stajao pred njima, pod drvetom, dok su oni jeli. ");
INSERT INTO srponstl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Onda su ga upitali: „Gde je tvoja žena Sara?“ Avraham odgovori: „Eno je u šatoru.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Gospod reče: „Zaista ću se vratiti k tebi dogodine u ovo vreme, i evo, tvoja žena Sara će imati sina.“ Sara je to slušala na ulazu u šator koji je bio iza njega. ");
INSERT INTO srponstl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","I Avraham i Sara su već bili ostareli i u odmaklim godinama. U Sare je, naime, bilo prestalo što biva u mlađih žena. ");
INSERT INTO srponstl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara se na to nasmejala u sebi rekavši: „Zar ću sada iskusiti radost, kad sam već uvenula, a moj gospodar ostareo?“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Gospod reče Avrahamu: „Zašto se smejala tvoja žena Sara i govorila: ’Zar ću sada roditi kad sam već ostarela?’ ");
INSERT INTO srponstl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Zar je za Gospoda išta nemoguće? Da, vratiću se k tebi dogodine u ovo vreme i Sara će imati sina.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Uplašivši se, Sara je poricala: „Ne, nisam se smejala!“ Ali Gospod joj reče: „Jesi, smejala si se.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Zatim su ljudi ustali i pogledali prema Sodomi. Avraham je pošao s njima da ih isprati. ");
INSERT INTO srponstl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Gospod reče: „Zar ću od Avrahama skrivati šta ću učiniti, ");
INSERT INTO srponstl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","kad ću od njega učiniti veliki i moćni narod, preko koga će biti blagosloveni svi narodi na zemlji? ");
INSERT INTO srponstl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Jer njega sam izabrao da pouči svoje sinove i svoj dom posle sebe da se drže Gospodnjeg puta čineći što je pravedno i pravo, da bi Gospod ostvario ono što je obećao Avrahamu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Gospod nastavi: „Glasna je tužba protiv Sodome i Gomore, jer je njihov greh veoma težak. ");
INSERT INTO srponstl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Sići ću, stoga, da vidim čine li zaista ono za šta ih tereti tužba što je k meni došla. Ako nije, znaću.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ljudi su se odande zaputili ka Sodomi, ali je Avraham ostao da stoji pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Avraham mu pristupi i reče: „Zar ćeš pogubiti i pravednoga s grešnikom? ");
INSERT INTO srponstl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Možda u gradu ima pedeset pravednika. Zar ćeš i njih da uništiš i ne oprostiš tom mestu radi onih pedeset koji budu u njemu? ");
INSERT INTO srponstl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Daleko bilo od tebe da učiniš takvu stvar! Zar da pogubiš pravednoga s grešnikom, pa da pravednika snađe isto što i grešnika? Daleko bilo od tebe! Zar ni sudija celog sveta da ne čini što je pravo?“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Gospod odgovori: „Ako u gradu Sodomi nađem pedeset pravednika, zbog njih ću oprostiti celom mestu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Avraham nastavi: „Usuđujem se, evo, da opet kažem nešto svome Gospodu, iako sam prah i pepeo. ");
INSERT INTO srponstl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Možda u gradu nedostaje pet od pedeset pravednika. Zar ćeš uništiti celo mesto zbog petorice?“ Gospod odgovori: „Ako nađem tamo četrdeset pet pravednika, neću ga uništiti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Avraham mu se ponovo obratio: „A ako se u njemu nađe četrdeset pravednika?“ Gospod odgovori: „Neću ga uništiti zbog tih četrdeset.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Avraham opet reče: „Neka se Gospod ne gnevi ako nastavim. Šta ako se tamo nađe trideset pravednika?“ Gospod odgovori: „Neću ga uništiti ako ih tamo nađem trideset.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Avraham će opet: „Usuđujem se, evo, da opet kažem nešto svome Gospodu. Ako ih se u gradu nađe dvadeset?“ „Neću uništiti grad zbog onih dvadeset.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Avraham opet reče: „Neka se moj Gospod ne ljuti ako mu se samo još jednom obratim. A ako se u gradu nađe samo deset pravednih?“ Gospod odgovori: „Neću ga uništiti zbog tih deset.“ ");
INSERT INTO srponstl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kad je završio razgovor s Avrahamom, Gospod je otišao, a Avraham se vratio kući. ");
INSERT INTO srponstl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Stignu ona dva anđela uveče u Sodomu baš kada je Lot sedeo kod gradskih vrata. Kad ih je video, Lot im je pošao u susret, poklonio se licem do zemlje ");
INSERT INTO srponstl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","i rekao: „Molim vas, gospodo, svratite u dom svoga sluge da provedete noć i operete noge; onda uranite, pa nastavite svojim putem.“ Oni odgovoriše: „Ne, prespavaćemo na ulici.“ ");
INSERT INTO srponstl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","No, Lot ih je toliko saletao da su oni konačno svratili k njemu i ušli u njegovu kuću. Onda ih je ugostio, ispekao beskvasni hleb, pa su jeli. ");
INSERT INTO srponstl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ali pre nego što su legli na počinak, žitelji grada – muškarci Sodome, stari i mladi – sav narod do poslednjeg čoveka, opkole kuću. ");
INSERT INTO srponstl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Onda su pozvali Lota i rekli mu: „Gde su oni ljudi što su noćas došli k tebi? Izvedi ih k nama da spavamo s njima!“ ");
INSERT INTO srponstl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot izađe k njima na ulaz, a vrata zatvori za sobom. ");
INSERT INTO srponstl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Onda im reče: „Braćo moja, molim vas, ne činite tog zla! ");
INSERT INTO srponstl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Evo, imam ovde dve ćerke koje još nisu bile u dodiru ni s jednim čovekom. Njih ću vam izvesti, pa činite s njima što vam je volja; ali ovim ljudima ne činite ništa, jer su došli pod senku moga krova.“ ");
INSERT INTO srponstl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Oni mu rekoše: „Skloni se odatle! Došao si ovde kao došljak, a već se postavljaš za sudiju. Sad ćemo s tobom da uradimo gore nego s njima.“ Onda silovito nasrnu na Lota i primaknu se vratima da ih razvale. ");
INSERT INTO srponstl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ali ona dvojica ispruže ruke, uvuku Lota k sebi i zatvore vrata. ");
INSERT INTO srponstl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","A one ljude što su bili pred vratima, stare i mlade, udare slepilom tako da nisu mogli da pronađu vrata. ");
INSERT INTO srponstl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Onda ona dvojica upitaše Lota: „Imaš li ovde još koga: zetove, sinove i ćerke, ili bilo koga u gradu? Izvedi ih iz mesta, ");
INSERT INTO srponstl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","jer ćemo ga uništiti. Teška je optužba što ga tereti pred Gospodom; on nas je poslao da ga uništimo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot je zatim izašao i rekao svojim budućim zetovima koji su bili vereni s njegovim ćerkama: „Ustajte! Odlazite iz ovog mesta jer će Gospod uništiti grad!“ Ali njima se činilo da to Lot zbija šalu. ");
INSERT INTO srponstl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","U sam osvit zore, anđeli navale na Lota govoreći: „Ustani i povedi svoju ženu i svoje dve ćerke koje su ovde, da ne budeš zatrt kad grad bude kažnjen!“ ");
INSERT INTO srponstl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Međutim, Lot je oklevao. Ali pošto mu se Gospod smilovao, oni ga uzmu za ruku, kao i njegovu ženu i njegove dve ćerke i bezbedno ih izvedu iz grada. ");
INSERT INTO srponstl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Čim su ih izveli, jedan od njih reče: „Beži da spaseš život! Ne osvrći se niti se igde u ravnici zaustavljaj. Beži u brda da ne budeš zatrt!“ ");
INSERT INTO srponstl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ali Lot im reče: „Nemoj, Gospode, molim te! ");
INSERT INTO srponstl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Tvoj je sluga našao naklonost pred tobom; šta više, iskazao si mi obilje svoje milosti spasivši mi život. Ali ja ne mogu da bežim u brda, jer će me snaći nesreća, te ću poginuti. ");
INSERT INTO srponstl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Evo, tu u blizini ima jedno malo mesto gde bih mogao da pobegnem. Nije li zaista malo? Dopusti mi da pobegnem tamo da spasem život.“ ");
INSERT INTO srponstl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Gospod mu odgovori: „Dobro, uslišiću ti i ovu molbu i neću zatrti grad o kome govoriš. ");
INSERT INTO srponstl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Brzo beži tamo, jer ne mogu ništa da učinim dok ti ne stigneš tamo.“ Zato se taj grad zove „Soar“. ");
INSERT INTO srponstl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Sunce je izlazilo nad zemljom kad je Lot ušao u Soar. ");
INSERT INTO srponstl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tada je Gospod na Sodomu i Gomoru sručio kišu od užarenog sumpora – s neba, od Gospoda – ");
INSERT INTO srponstl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","pa je uništio ove gradove i svu tu ravnicu, sve žitelje gradova i sve što je raslo na zemlji. ");
INSERT INTO srponstl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ali Lotova žena se okrete za sobom i pretvori se u stub soli. ");
INSERT INTO srponstl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Rano sledećeg jutra, Avraham ustane i vrati se na mesto gde je stajao pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Pogledao je prema Sodomi i Gomori i prema celoj ravnici, i ugledao kako se diže dim nad zemljom kao dim iz peći. ");
INSERT INTO srponstl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kad je Bog uništavao gradove u ravnici gde je Lot živeo, držao je na umu Avrahama, pa je izveo Lota odatle, i izbavio ga od istrebljenja. ");
INSERT INTO srponstl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot je napustio Soar, jer se plašio da ostane tamo, i nastanio se u brdima sa svoje dve ćerke. Živeo je sa njima u jednoj pećini. ");
INSERT INTO srponstl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Tada je starija ćerka rekla mlađoj: „Naš je otac ostareo, a u zemlji nema muža da bude sa nama, kao što je red po svemu svetu. ");
INSERT INTO srponstl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Hajde da napijemo našeg oca vinom i legnemo s njim. Tako ćemo preko našeg oca sačuvati potomstvo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Iste noći opiju one svoga oca vinom, pa starija ode i legne sa svojim ocem. On nije znao ni kad je legla ni kad je ustala. ");
INSERT INTO srponstl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ujutro je starija rekla mlađoj: „Evo, ja sam prošle noći legla sa našim ocem. Hajde da ga napijemo vinom i ove noći, pa idi i lezi s njim, kako bi preko našeg oca sačuvali potomstvo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tako one ponovo napiju svoga oca vinom, pa mlađa ćerka legne s njim. A on opet nije znao ni kad je ova legla ni kad je ustala. ");
INSERT INTO srponstl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Tako su obe ćerke Lotove ostale u drugom stanju sa svojim ocem. ");
INSERT INTO srponstl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Starija ćerka je rodila sina i dala mu ime „Moav“. On je praotac današnjih Moavaca. ");
INSERT INTO srponstl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","I mlađa je rodila sina. Dala mu je ime „Ven-Ami“. On je praotac današnjih Amonaca. ");
INSERT INTO srponstl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Odande Avraham ode u krajeve Negeva i nastani se između Kadisa i Sura. Dok je u Geraru živeo kao stranac, ");
INSERT INTO srponstl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Avraham je za svoju ženu Saru rekao da mu je sestra. Stoga je Avimeleh, car Gerara, poslao po Saru i uzeo je k sebi. ");
INSERT INTO srponstl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ali Bog se ukazao Avimelehu noću u snu i rekao mu: „Zbog žene koju si uzeo k sebi, moraš umreti, jer je ona udata žena.“ ");
INSERT INTO srponstl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Međutim, Avimeleh joj se nije približavao. Na to Avimeleh reče: „Gospode, zar ćeš i nedužan narod pobiti? ");
INSERT INTO srponstl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Nije li mi taj čovek rekao da mu je ona sestra? A i ona je rekla da joj je on brat. Učinio sam to čiste savesti, i nisam okaljao ruke.“ ");
INSERT INTO srponstl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Bog mu u snu odgovori: „Znam ja da si to učinio čiste savesti; u stvari, ja sam te sprečio da ne zgrešiš protiv mene; zato ti nisam dozvolio da je takneš. ");
INSERT INTO srponstl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Stoga sad vrati ženu njenom mužu; on je, naime, prorok, pa će se moliti za tebe da ne umreš. Ako li je ne vratiš, sigurno ćeš umreti i ti i svi tvoji.“ ");
INSERT INTO srponstl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Avimeleh ustane u rano jutro i pozva sve svoje sluge i ispriča im sve što se desilo. Ljude obuze veliki strah. ");
INSERT INTO srponstl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Avimeleh zatim pozva Avrahama i reče mu: „Šta si nam to učinio? I čime sam se to ogrešio o tebe, da na mene i moje carstvo svališ toliki greh? Poneo si se prema meni toliko loše, kako se niko ne bi poneo prema bilo kome.“ ");
INSERT INTO srponstl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Avimeleh upita Avrahama: „Šta te je navelo da učiniš takvu stvar?“ ");
INSERT INTO srponstl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Avraham odgovori: „Zaista sam mislio da nema Božijeg straha u ovom mestu, i da će me ubiti zbog moje žene. ");
INSERT INTO srponstl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","A ona je zaista moja sestra, ćerka moga oca, ali ne i moje majke, pa sam je oženio. ");
INSERT INTO srponstl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kad me je Bog poslao iz doma moga oca u tuđinu, ja sam joj rekao: ’Učini mi ovu uslugu: gde god pođemo, reci – on mi je brat.’“ ");
INSERT INTO srponstl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Avimeleh uze ovaca, krupne stoke, sluge i sluškinje, pa ih dade Avrahamu. Vratio mu je i njegovu ženu Saru. ");
INSERT INTO srponstl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Avimeleh reče: „Evo, moja ti je zemlja otvorena. Nastani se gde god ti se sviđa.“ ");
INSERT INTO srponstl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A Sari je rekao: „Evo, dajem tvom bratu hiljadu srebrnjaka, kao dokaz tvoje nevinosti pred svima što su s tobom; time si potpuno opravdana.“ ");
INSERT INTO srponstl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Zatim se Avraham pomolio, te je Gospod iscelio Avimeleha, njegovu ženu, i njegove sluškinje, te su ponovo mogle da rađaju. ");
INSERT INTO srponstl_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Gospod je, naime, zbog Sare, Avrahamove žene, učinio nerodnom svaku ženu u Avimelehovom domu. ");
INSERT INTO srponstl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Gospod je blagoslovio Saru, i učinio joj kao što je obećao. ");
INSERT INTO srponstl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara je zatrudnela i rodila Avrahamu sina u njegovoj starosti, u vreme kad je Bog rekao. ");
INSERT INTO srponstl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Svome sinu koga mu je rodila Sara, Avraham je dao ime Isak. ");
INSERT INTO srponstl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Avraham je obrezao svoga sina Isaka kad mu je bilo osam dana, kao što mu je Bog zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Avrahamu je bilo stotinu godina kad mu se rodio sin Isak. ");
INSERT INTO srponstl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tada Sara reče: „Bog me je zaista zasmejao, a i svako ko čuje o ovome smejaće se.“ ");
INSERT INTO srponstl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Dodala je još: „Ko bi ikada rekao Avrahamu da će mu Sara dojiti decu? Jer rodila sam mu sina u njegovoj starosti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Dete je raslo i bilo odbijeno od dojenja. Tog istog dana kad je Isak bio odbijen od dojenja, Avraham je napravio veliku gozbu. ");
INSERT INTO srponstl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Tek, Sara opazi da se sin Agare Egipćanke, koga je ova rodila Avrahamu, podsmeva Isaku. ");
INSERT INTO srponstl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ona reče Avrahamu: „Oteraj tu sluškinju i njenog sina, jer sin sluškinje neće deliti nasledstvo s mojim sinom Isakom!“ ");
INSERT INTO srponstl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Avrahamu je ovo teško palo, jer je i Ismailo bio njegov sin. ");
INSERT INTO srponstl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ali Bog reče Avrahamu: „Ne uzbuđuj se zbog dečaka i sluškinje. Poslušaj sve što ti je Sara rekla, jer će se tvoje potomstvo nastaviti preko Isaka. ");
INSERT INTO srponstl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ipak, i od sina tvoje sluškinje podići ću narod, zato što je tvoj potomak.“ ");
INSERT INTO srponstl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Rano ujutro je Avraham uzeo hleba i mešinu s vodom, te ih dao Agari. Onda je to stavio na njena ramena, pa ju je zajedno s dečakom otpremio. Ona je otišla i tumarala po vir-savejskoj pustinji. ");
INSERT INTO srponstl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Kada je nestalo vode iz mešine, odnela je dečaka pod jedan žbun, ");
INSERT INTO srponstl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","a sama otišla i sela malo dalje, toliko koliko se lukom i strelom može dobaciti. Govorila je u sebi: „Neću da gledam kako mi dete umire.“ Sela je tamo, i glasno zajecala. ");
INSERT INTO srponstl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ali Bog je čuo dečakov glas; Anđeo je Božiji pozvao Agaru s neba, govoreći joj: „Šta te muči, Agaro? Ne boj se, jer je Bog čuo vapaj dečakov tamo gde leži. ");
INSERT INTO srponstl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ustani, uzmi dečaka za ruku i podigni ga, jer ću od njega podići veliki narod.“ ");
INSERT INTO srponstl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Tada joj Bog otvori oči, te ona opazi izvor. Otišla je, napunila mešinu vodom, i napojila dečaka. ");
INSERT INTO srponstl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Bog je bio s dečakom. Odrastao je i živeo u pustinji i postao vešt u lovu lukom i strelom. ");
INSERT INTO srponstl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Dok je živeo u pustinji Faran, majka mu je dovela ženu iz Egipta. ");
INSERT INTO srponstl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","U to vreme Avimeleh u pratnji Fihola, zapovednika njegove vojske, reče Avrahamu: „Bog je s tobom u svemu što radiš. ");
INSERT INTO srponstl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Zato mi se ovde zakuni pred Bogom da nećeš varati mene, moju decu, niti mog naslednika. Kao što sam ja bio dobar prema tebi, tako i ti budi dobar prema meni i prema ovoj zemlji u kojoj boraviš kao stranac.“ ");
INSERT INTO srponstl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Avraham odgovori: „Zaklinjem se!“ ");
INSERT INTO srponstl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Onda je Avraham prekorio Avimeleha zbog bunara što su mu ga Avimelehove sluge otele. ");
INSERT INTO srponstl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Avimeleh odgovori: „Ne znam ko je to uradio, a ni ti mi nisi rekao. Tek sam danas čuo o tome.“ ");
INSERT INTO srponstl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Avraham uze ovaca i goveda, pa ih dade Avimelehu, te njih dvojica sklopiše savez. ");
INSERT INTO srponstl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Onda je izdvojio sedam jaganjaca iz stada. ");
INSERT INTO srponstl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Avimeleh upita Avrahama: „Šta znače ovih sedam jaganjaca što si ih izdvojio?“ ");
INSERT INTO srponstl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Avraham odgovori: „Primi ovih sedam jaganjaca iz moje ruke da mi budu svedok da sam ja iskopao ovaj bunar.“ ");
INSERT INTO srponstl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","To mesto se zove „Vir-Saveja“, jer su se tamo obojica zaklela. ");
INSERT INTO srponstl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Nakon što su sklopili savez kod Vir-Saveje, Avimeleh i zapovednik njegove vojske Fihol su se vratili u zemlju filistejsku. ");
INSERT INTO srponstl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","A Avraham je kod Vir-Saveje zasadio tamarisk, te prizvao ime Gospoda – večnog Boga. ");
INSERT INTO srponstl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Avraham je dugo živeo kao stranac u zemlji filistejskoj. ");
INSERT INTO srponstl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Posle ovih događaja Bog je iskušao Avrahama. Bog ga zovnu: „Avrahame!“ „Evo me!“ – odazva se Avraham. ");
INSERT INTO srponstl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Bog mu onda reče: „Uzmi svoga sina Isaka, tvoga jedinca koga voliš, i pođi s njim u zemlju Moriju, pa ga prinesi kao žrtvu svespalnicu na brdu koje ću ti pokazati.“ ");
INSERT INTO srponstl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ustane Avraham u rano jutro i osamari magarca. Sa sobom je poveo dva momka i svoga sina Isaka, i pošto je nasekao drva za svespalnicu, digao se i krenuo na mesto koje mu je Bog rekao. ");
INSERT INTO srponstl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Trećega dana Avraham podigne pogled i izdaleka ugleda ono mesto. ");
INSERT INTO srponstl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Avraham reče momcima: „Vi ostanite ovde s magarcem, a ja i dečak idemo gore. Kad se pomolimo, vratićemo se k vama.“ ");
INSERT INTO srponstl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Avraham uzme drva za žrtvu svespalnicu, natovari ih na svoga sina Isaka, a sam je poneo vatru i nož. Onda su obojica krenula. ");
INSERT INTO srponstl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isak reče svome ocu Avrahamu: „Oče!“ Avraham se odazva: „Evo me, sine!“ Isak mu reče: „Evo, tu su vatra i drva, ali gde je jagnje za žrtvu svespalnicu?“ ");
INSERT INTO srponstl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Avraham odgovori: „Bog će se postarati za jagnje za žrtvu svespalnicu, sine moj.“ Tako njih dvojica nastave put. ");
INSERT INTO srponstl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kad su stigli na mesto za koje im je Bog rekao, Avraham podigne žrtvenik, naslaže drva, pa sveže svoga sina Isaka i položi ga na žrtvenik povrh drva. ");
INSERT INTO srponstl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Tad Avraham uze nož da zakolje svoga sina. ");
INSERT INTO srponstl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ali Anđeo Gospodnji ga pozva s neba i reče mu: „Avrahame! Avrahame!“ On odgovori: „Evo me!“ ");
INSERT INTO srponstl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Anđeo Gospodnji reče: „Ne diži ruku na dečaka, niti mu šta čini! Sad znam da se bojiš Boga, jer mi nisi uskratio ni svoga sina jedinca.“ ");
INSERT INTO srponstl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Avraham se obazre, i gle, iza njega ovan; zapleli mu se rogovi u grmlje. Avraham priđe i uzme ovna, pa ga prinese na žrtvu svespalnicu umesto svoga sina. ");
INSERT INTO srponstl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Avraham nazva to mesto „Gospod će se postarati.“ Zato se i danas kaže: „Na brdu Gospodnjeg staranja.“ ");
INSERT INTO srponstl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Anđeo Gospodnji po drugi put pozva Avrahama s neba ");
INSERT INTO srponstl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","i reče mu: „Zaklinjem se samim sobom – govori Gospod – pošto si to učinio i nisi uskratio svoga sina jedinca, ");
INSERT INTO srponstl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","obilno ću te blagosloviti, i tvoje ću potomstvo umnožiti, te će biti brojno kao zvezde na nebu i kao pesak na morskoj obali. Tvoje će potomstvo osvajati vrata svojih neprijatelja. ");
INSERT INTO srponstl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Zato što si poslušao moj glas, svi će narodi na zemlji biti blagosloveni preko tvog potomstva.“ ");
INSERT INTO srponstl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Avraham se potom vratio k svojim momcima, te su se zajedno uputili u Vir-Saveju, gde je Avraham živeo. ");
INSERT INTO srponstl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Posle ovih događaja javili su Avrahamu: „Evo, i Melha je rodila decu tvome bratu Nahoru: ");
INSERT INTO srponstl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Njegovog prvenca Uza i njegovog brata Vuza, Kemuila, oca Aramovog, ");
INSERT INTO srponstl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keseda, Azava, Fildesa, Jedlafa i Vatuila.“ ");
INSERT INTO srponstl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Vatuilo je bio Revekin otac. Ovu osmoricu je Melha rodila Avrahamovom bratu Nahoru. ");
INSERT INTO srponstl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","A Nahorova inoča, koja se zvala Reuma, je rodila Tevaha, Gahama, Tahasa i Mahu. ");
INSERT INTO srponstl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara je živela stotinu dvadeset sedam godina. ");
INSERT INTO srponstl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Umrla je u Kirijat-Arvi, to jest u Hevronu u hananskoj zemlji. Avraham je žalio za Sarom i naricao za njom. ");
INSERT INTO srponstl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Zatim je Avraham ustao s mesta gde je ležala njegova pokojnica, i obratio se Hetitima: ");
INSERT INTO srponstl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","„Stranac sam i pridošlica među vama. Prodajte mi zemljište za grob kod vas, da bih mogao da otpremim i sahranim svoju pokojnicu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hetiti odgovoriše Avrahamu: ");
INSERT INTO srponstl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","„Čuj nas, gospodaru. Ti si knez Božiji među nama. Stoga sahrani svoju pokojnicu u našem najboljem grobu; niko od nas ti neće uskratiti svoj grob da u njega sahraniš svoju pokojnicu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Avraham je na to ustao i duboko se poklonio stanovnicima zemlje, Hetitima. ");
INSERT INTO srponstl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Zatim im je rekao: „Ako se, dakle, slažete da otpremim svoju pokojnicu i sahranim je kod vas, zauzmite se za mene kod Efrona, sina Coharova, ");
INSERT INTO srponstl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","da mi proda pećinu u Makpeli što je u njegovom vlasništvu. Ona se nalazi na kraju njegovog imanja. Neka mi je pred vama proda za punu cenu, da bih imao grob u svom vlasništvu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron je sedeo među Hetitima. Tada Efron, Hetit, odgovori Avrahamu, da ga čuju Hetiti svojim ušima – sve starešine što su došle kod gradskih vrata: ");
INSERT INTO srponstl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","„Nikako, gospodaru! Poslušaj me: dajem ti i njivu i pećinu na njoj. Dajem ti je pred svojim narodom; sahrani svoju pokojnicu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Avraham se duboko poklonio narodu te zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Avraham tada reče Efronu, da narod te zemlje čuje na svoje uši: „Saslušaj ti sada mene. Platiću ti novcem za tu poljanu. Primi to od mene, da mogu tamo da sahranim svoju pokojnicu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron odgovori Avrahamu: ");
INSERT INTO srponstl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","„Čuj me, moj gospodaru. Zemljište vredi četiri stotine srebrnih šekela. Šta je to za tebe i mene? Samo ti sahrani svoju pokojnicu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Avraham se složio s Efronom, pa mu je izbrojao novac koji je Efron tražio u prisutnosti svih Hetita: četiri stotine šekela srebra trgovačke mere. ");
INSERT INTO srponstl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Tako je Efronova poljana u Makpeli, što je nasuprot Mamriji, sa pećinom, stablima, i svim što je bilo na njivi, ");
INSERT INTO srponstl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","prešla u Avrahamovo vlasništvo u prisutnosti Hetita – svih starešina što su došle pred gradska vrata. ");
INSERT INTO srponstl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Nakon toga je Avraham sahranio svoju ženu Saru u pećini na poljani Makpela što je nasuprot Mamrije (kod Hevrona) u zemlji Hananskoj. ");
INSERT INTO srponstl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tako je poljana i pećina na njoj prešla od Hetita u Avrahamovo vlasništvo za sahranjivanje. ");
INSERT INTO srponstl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Avraham je bio već star i dobro odmakao u godinama. Gospod ga je bio blagoslovio u svemu. ");
INSERT INTO srponstl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Avraham reče najstarijem sluzi u svom domu, pod čijom upravom je bila sva njegova imovina: „Stavi ruku pod moje bedro, ");
INSERT INTO srponstl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","da te zakunem Gospodom, Bogom neba i zemlje, da mome sinu nećeš dovesti za ženu jednu od ćerki Hananaca među kojima živim, ");
INSERT INTO srponstl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","nego da ćeš otići u moju zemlju, u moj rodni kraj, te dovesti ženu za mog sina Isaka.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Sluga reče Avrahamu: „A šta ako žena neće da pođe u ovu zemlju? Treba li da se vratim i povedem tvoga sina u zemlju iz koje si ti došao?“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Avraham mu odgovori: „Pazi da ne odvedeš tamo moga sina! ");
INSERT INTO srponstl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Gospod, Bog nebeski, koji me je izveo iz doma moga oca i iz moje rodne zemlje, mi je govorio i zakleo se samim sobom, rekavši: ’Tvome potomstvu ću dati ovu zemlju.’ On će poslati anđela pred tobom, pa ćeš dovesti odande ženu za mog sina. ");
INSERT INTO srponstl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","A ako žena neće da pođe s tobom, onda te moja zakletva više ne obavezuje. Samo pazi da tamo ne vodiš moga sina.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tada je sluga stavio ruku pod Avrahamovo bedro, pa mu se zakleo da će učiniti što mu je Avraham rekao. ");
INSERT INTO srponstl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Sluga je uzeo deset kamila svoga gospodara, i poneo svakovrsna dobra svoga gospodara. Onda je ustao i krenuo u Aram-Naharajim, u Nahorov grad. ");
INSERT INTO srponstl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kod bunara, izvan grada, je pustio kamile da poležu. Bilo je veče, vreme kad žene dolaze da zahvataju vodu. ");
INSERT INTO srponstl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Onda se pomolio: „O, Gospode, Bože moga gospodara Avrahama, izađi mi danas u susret i iskaži milost mome gospodaru Avrahamu. ");
INSERT INTO srponstl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Evo, stojim ovde kod izvora, a ćerke meštana dolaze da zahvataju vodu. ");
INSERT INTO srponstl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Reći ću jednoj devojci: ’Spusti svoj krčag da se napijem.’ Ako ona odgovori: ’Pij! Napojiću i tvoje kamile’, neka ona bude ta koju si odredio za tvoga slugu Isaka. Po tome ću znati da si iskazao milost mome gospodaru.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","On još nije bio dorekao molitvu, kad dođe Reveka, koja se rodila Vatuilu, sinu Melhe, žene Avrahamovog brata Nahora, noseći krčag na ramenu. ");
INSERT INTO srponstl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Devojka je bila predivnog izgleda, devica koju muškarac nije dotakao. Sišla je k izvoru, napunila krčag, pa se vratila gore. ");
INSERT INTO srponstl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Sluga joj tada potrča u susret i reče joj: „Daj mi, molim te, malo vode iz tvog krčaga!“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ona mu odgovori: „Pij, gospodaru!“, pa je hitro spustila krčag na ruku i dala mu da pije. ");
INSERT INTO srponstl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kad ga je napojila, rekla je: „Naliću i tvojim kamilama da se napoje.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Brzo je izlila krčag u pojilo, pa se požurila k bunaru da ponovo zahvati vode. Zatim je napojila sve njegove kamile. ");
INSERT INTO srponstl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Čovek ju je ćutke posmatrao, ne bi li saznao da li je Gospod učinio njegov put uspešnim ili nije. ");
INSERT INTO srponstl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kad su se kamile napojile, čovek je uzeo zlatnu grivnu za njen nos tešku pola šekela, a za njene ruke dve zlatne narukvice teške deset šekela. ");
INSERT INTO srponstl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Sluga joj tada reče: „Reci mi, molim te, čija si ćerka? Ima li u kući tvoga oca mesta za nas da prenoćimo?“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ona odgovori: „Ja sam ćerka Vatuila, sina koga je Melha rodila Nahoru.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Još mu je rekla: „Kod nas ima puno slame i stočne hrane, a ima i mesta da se prenoći.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Čovek se tada poklonio i pao ničice pred Gospodom, ");
INSERT INTO srponstl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","govoreći: „Neka je blagosloven Gospod, Bog moga gospodara Avrahama, što nije uskratio svoju milost i vernost mome gospodaru. Gospod me je doveo pravo u kuću rođaka moga gospodara!“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Devojka je onda otrčala i ispričala sve ovo u kući svoje majke. ");
INSERT INTO srponstl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Reveka je imala brata koji se zvao Lavan. Lavan je otrčao napolje, ka čoveku kod studenca. ");
INSERT INTO srponstl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Čim je video grivnu i narukvice na rukama svoje sestre, i kad je čuo reči njegove sestre Reveke: „Ovako mi je govorio taj čovek“, otišao je k čoveku koji je stajao kod kamila na studencu. ");
INSERT INTO srponstl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Rekao mu je: „Dođi, blagosloveni od Gospoda! Zašto stojiš napolju? Ja sam već spremio kuću i mesto za kamile.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Čovek je došao u kuću i rastovario kamile. Lavan je onda dao stočne hrane i slame kamilama, a sluzi i ljudima koji su bili s njim je doneo vode da operu noge. ");
INSERT INTO srponstl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kad je postavio pred njega da jede, sluga reče: „Neću jesti dok ne kažem što imam da kažem.“ Lavan mu reče: „Govori onda!“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Sluga je počeo da priča: „Ja sam Avrahamov sluga. ");
INSERT INTO srponstl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Gospod je obilato blagoslovio moga gospodara, te je postao bogat. Dao mu je ovaca i goveda, srebra i zlata, slugu i sluškinja, kamila i magaraca. ");
INSERT INTO srponstl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, žena moga gospodara, mu je rodila sina u njegovoj starosti, kome je dao svu svoju imovinu. ");
INSERT INTO srponstl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Moj me je gospodar zakleo, rekavši: ’Ne uzimaj za ženu mome sinu neku devojku od Hananejaca, u čijoj zemlji živim. ");
INSERT INTO srponstl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Nego idi k porodici moga oca, k mojoj rodbini, da nađeš ženu za moga sina.’ ");
INSERT INTO srponstl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ja sam onda upitao svoga gospodara: ’A šta ako žena neće da pođe sa mnom?’ ");
INSERT INTO srponstl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","On mi odgovori: ’Gospod, čiji put sledim, poslaće svog anđela s tobom, i učiniti tvoj put uspešnim, pa ćeš dovesti ženu za moga sina od moje rodbine, iz porodice moga oca. ");
INSERT INTO srponstl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Zakletve ćeš biti razrešen kad odeš k mojoj rodbini. Ako ti oni ne daju devojku, onda te moja zakletva više ne obavezuje. ");
INSERT INTO srponstl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Danas, kad sam došao kod izvora, rekao sam Gospodu: ’O, Gospode, Bože moga gospodara Avrahama, ako ti je po volji, molim te učini uspešnim put na koji sam krenuo. ");
INSERT INTO srponstl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Evo, stojim kod izvora i devojci koja dođe da crpi vodu, reći ću: ’Daj mi da popijem malo vode iz tvoga krčaga.’ ");
INSERT INTO srponstl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ako ona kaže: ’Pij! Izvući ću vode i za tvoje kamile’, to će biti ona koju je Gospod odredio za sina moga gospodara. ");
INSERT INTO srponstl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ja još nisam bio dorekao molitvu u sebi, kad eto Reveke sa krčagom na ramenu. Sišla je k izvoru da zahvati vode. Ja joj rekoh: ’Daj mi, molim te, da pijem!’ ");
INSERT INTO srponstl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ona je brzo spustila krčag s ramena i rekla: ’Pij! Napojiću i tvoje kamile.’ Ja sam pio, a ona je napojila kamile. ");
INSERT INTO srponstl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Onda sam je upitao: ’Čija si ti ćerka?’ Ona odgovori: ’Ćerka sam Vatuila, koga je Nahoru rodila Melha.’ Tada sam joj stavio grivnu na nos, a narukvice na njene ruke. ");
INSERT INTO srponstl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Zatim sam pao ničice pred Gospodom i blagoslovio Gospoda, Boga moga gospodara Avrahama, koji me je vodio pravim putem da uzmem ćerku brata moga gospodara za njegovog sina. ");
INSERT INTO srponstl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","A sad, recite mi ako nameravate da iskažete milost i vernost mome gospodaru; ako ne nameravate, i to mi recite, tako da znam hoću li poći na desno ili na levo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Tada Lavan i Vatuilo odgovore: „Od Gospoda je ovo došlo; mi ti ne možemo reći ni da ni ne. ");
INSERT INTO srponstl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Evo, Reveka je tu: uzmi je i idi, pa neka bude žena tvome gospodaru, kako je Gospod rekao.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kad je Avrahamov sluga čuo ove reči, poklonio se Gospodu licem do zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Sluga je onda izvadio zlatnog i srebrnog nakita, i haljina, pa ih dao Reveki. Njenoj braći i majci je takođe dao dragocene darove. ");
INSERT INTO srponstl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Zatim su on i njegovi saputnici jeli i pili, pa su prenoćili tamo. Kad su ujutro ustali, sluga reče: „Dopustite mi da se vratim svome gospodaru.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ali njen brat i njena majka mu rekoše: „Neka devojka ostane s nama još desetak dana; onda možeš da ideš.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ali on im reče: „Ne zadržavajte me, kad je Gospod već učinio moj put uspešnim. Pustite me da idem k svome gospodaru!“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","A oni rekoše: „Pozovimo devojku i upitajmo je šta ona misli.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Pozvali su devojku i upitali je: „Da li hoćeš da pođeš sa ovim čovekom?“ Ona odgovori: „Hoću.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Tako oni otpreme svoju sestru i njenu dojilju sa Avrahamovim slugom i njegovim ljudima. ");
INSERT INTO srponstl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Onda su blagoslovili Reveku ovim rečima: „Sestro naša! Budi majka nebrojenim hiljadama, a tvoje potomstvo nek zauzme vrata svojih neprijatelja.“ ");
INSERT INTO srponstl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Onda su Reveka i njene sluškinje ustale, uzjahale kamile, te pošle za slugom. Sluga je preuzeo Reveku i otišao. ");
INSERT INTO srponstl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","A Isak se upravo vratio iz Vir Lahaj Roja; on je, naime, živeo u oblasti Negeva. ");
INSERT INTO srponstl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Predveče je izašao u polje da se prošeta. Podigne on pogled, kad ono, dolaze kamile. ");
INSERT INTO srponstl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","I Reveka je podigla pogled. Kad je videla Isaka sišla je s kamile ");
INSERT INTO srponstl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","i upitala slugu: „Ko je taj čovek što nam poljem dolazi u susret?“ Sluga odgovori: „To je moj gospodar.“ Ona je tada uzela veo i pokrila lice. ");
INSERT INTO srponstl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Zatim je sluga ispričao Isaku sve što je učinio. ");
INSERT INTO srponstl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isak je tada uveo Reveku u šator svoje majke, Sare, i oženio se njome. Ona mu je postala žena i on ju je voleo. Tako se Isak utešio za svojom majkom. ");
INSERT INTO srponstl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Avraham je uzeo sebi još jednu ženu; zvala se Hetura. ");
INSERT INTO srponstl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ona mu je rodila Zomrana, Joksana, Madana, Madijana, Jesvoka i Soijena. ");
INSERT INTO srponstl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan je bio otac Save i Dedana. Dedanovi potomci su: Asurci, Letušani i Leumljani. ");
INSERT INTO srponstl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madijanovi sinovi su: Gefa, Afir, Enoh, Avida i Eldaga. Sve su ovo Heturini potomci. ");
INSERT INTO srponstl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Avraham je svu svoju imovinu ostavio Isaku. ");
INSERT INTO srponstl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","A sinovima svojih inoča Avraham je dao darove, i još za života ih razaslao u istočne zemlje, daleko od svoga sina Isaka. ");
INSERT INTO srponstl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ovo su godine koje je Avraham doživeo: stotinu sedamdeset pet godina. ");
INSERT INTO srponstl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Onda je izdahnuo i umro u dubokoj starosti, star i sit života, te se pridružio svojim precima. ");
INSERT INTO srponstl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Sahranili su ga njegovi sinovi, Isak i Ismailo, u pećini Makpeli, na poljani Efrona Hetita, sina Cohara, što je nasuprot Mamrije; ");
INSERT INTO srponstl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","na poljani koju je Avraham kupio od Hetita. Tamo je sahranjen Avraham i njegova žena Sara. ");
INSERT INTO srponstl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Posle Avrahamove smrti, Bog je blagoslovio njegovog sina Isaka, koji je živeo kod Vir Lahaj Roja. ");
INSERT INTO srponstl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ovo je rodoslov Ismaila, sina Avrahamovog, koga mu je rodila Agara Egipćanka, Sarina sluškinja. ");
INSERT INTO srponstl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ovo su imena Ismailovih sinova po redosledu njihovog rođenja: njegov prvenac Navajot, pa Kedar, Avdeilo, Mivsam, ");
INSERT INTO srponstl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mišma, Duma, Masa, ");
INSERT INTO srponstl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafis i Kedma. ");
INSERT INTO srponstl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","To su sinovi Ismailovi; dvanaest knezova nad dvanaest plemena. Po njima su njihova naselja i taborišta dobila ime. ");
INSERT INTO srponstl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ovo su godine koje je Ismailo doživeo: stotinu trideset sedam godina. Izdahnuo je i umro i bio pridružen svojim precima. ");
INSERT INTO srponstl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Njegovo potomstvo se naselilo od Evile do Sura, koji je nasuprot Egiptu, na putu što vodi u Asiriju. Živeli su u neprijateljstvu sa svom svojom braćom. ");
INSERT INTO srponstl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ovo je rodoslov Avrahamovog sina Isaka. Avraham je, dakle, bio Isakov otac. ");
INSERT INTO srponstl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaku je bilo četrdeset godina kad se oženio Revekom, ćerkom Aramejca Vatuila, iz Padan-Arama, a sestrom Aramejca Lavana. ");
INSERT INTO srponstl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isak se pomolio Gospodu za svoju ženu, jer je bila nerotkinja. Gospod mu je uslišio molitvu, te je njegova žena Reveka zatrudnela. ");
INSERT INTO srponstl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Međutim, blizanci u njenoj utrobi se tako sudare, da je ona uzviknula: „Zašto mi se ovo dešava?“ Zato je otišla da upita Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Gospod joj odgovori: „Dva su plemena u tvojoj utrobi; dva će se naroda razdeliti tek što iz tvog krila izađu. Jedan će narod drugi nadjačati; stariji će mlađemu služiti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kad joj je došlo vreme da rodi, ispostavi se da su dva blizanca u njenoj utrobi. ");
INSERT INTO srponstl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Prvi koji je izašao bio je sav crven i kosmat kao kožuh. Zato su ga nazvali „Isav“. ");
INSERT INTO srponstl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Posle toga je izašao njegov brat držeći rukom Isava za petu. Zato su ga nazvali „Jakov“. Isaku je bilo šezdeset godina kada su mu se oni rodili. ");
INSERT INTO srponstl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Kad su dečaci odrasli, Isav postane vrstan lovac, čovek pustare. Jakov je bio miran čovek koji je provodio vreme u šatorima. ");
INSERT INTO srponstl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaku je Isav bio miliji, jer je voleo divljač, a Reveka je više volela Jakova. ");
INSERT INTO srponstl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Jednom je Jakov kuvao varivo. Isav je došao iz pustare, iznemogao. ");
INSERT INTO srponstl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Isav reče Jakovu: „Daj da se najedem tog crvenog variva, jer sam iznemogao!“ Zato mu je ime „Edom“. ");
INSERT INTO srponstl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakov mu reče: „Prvo mi ustupi tvoja prvenačka prava.“ ");
INSERT INTO srponstl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","A Isav mu odgovori: „Evo, samo što ne umrem; šta će mi prvenačka prava!“ ");
INSERT INTO srponstl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakov mu odvrati: „Najpre mi se zakuni.“ Isav se tada zakleo i ustupio Jakovu svoja prvenačka prava. ");
INSERT INTO srponstl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Onda je Jakov dao Isavu hleba i variva od sočiva. Isav se najeo i napio, pa je ustao i otišao. Tako je Isav prezreo svoja prvenačka prava. ");
INSERT INTO srponstl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","U zemlji je zavladala glad, drugačija od one što je bila u Avrahamovo vreme. Zato je Isak otišao u Gerar, k filistejskom caru, Avimelehu. ");
INSERT INTO srponstl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Gospod mu se ukazao i rekao mu: „Ne idi u Egipat, nego prebivaj u zemlji u koju te ja uputim. ");
INSERT INTO srponstl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Boravi u ovoj zemlji i ja ću biti s tobom, te ću te blagosloviti. A tebi i tvome potomstvu daću svu ovu zemlju, da izvršim zakletvu kojom sam se zakleo tvome ocu Avrahamu. ");
INSERT INTO srponstl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Tvoje potomstvo ću umnožiti kao zvezde na nebu i dati mu sve ove krajeve. Preko tvog potomstva biće blagosloveni svi narodi na zemlji, ");
INSERT INTO srponstl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","zato što je Avraham poslušao moj glas, i pokoravao se mojim zapovestima, odredbama i zakonima.“ ");
INSERT INTO srponstl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isak se tada naselio u Geraru. ");
INSERT INTO srponstl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kada su ga meštani pitali za njegovu ženu, on im rekao: „Ona mi je sestra.“ Plašio se, naime, da kaže da mu je ona žena, jer je mislio: „Ako kažem da mi je žena, meštani bi me mogli ubiti zbog Reveke, jer je veoma lepa.“ ");
INSERT INTO srponstl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak je već tamo bio duže vreme, kad ga je, jednom prilikom, filistejski car Avimeleh ugledao s prozora kako miluje svoju ženu Reveku. ");
INSERT INTO srponstl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Avimeleh je tada pozvao Isaka i rekao mu: „Ona je očigledno tvoja žena. Kako si mogao da kažeš: ’Ona mi je sestra’?“ Isak mu odgovori: „Pomislio sam: ’Da ne umrem zbog nje.’“ ");
INSERT INTO srponstl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Avimeleh mu tada reče: „Zašto si nam to učinio? Neko od ljudi je mogao da legne s tvojom ženom i tako bi na nas svalio krivicu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Tada je Avimeleh naredio celom narodu: „Ko god takne ovog čoveka ili njegovu ženu, izgubiće život sigurno.“ ");
INSERT INTO srponstl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isak je sejao u toj zemlji, i te mu je godine urodilo stostruko. Gospod ga je blagoslovio, ");
INSERT INTO srponstl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","pa se čovek obogatio. Bogatstvo mu se sve više uvećavalo, dok nije postao veoma bogat. ");
INSERT INTO srponstl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Stekao je i stada ovaca i goveda, te mnogo slugu, tako da su mu Filistejci zavideli. ");
INSERT INTO srponstl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Zato su Filistejci zatrpali sve bunare što su ih sluge njegovog oca Avrahama iskopale – u vreme njegovog oca Avrahama, napunivši ih zemljom. ");
INSERT INTO srponstl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Tada Avimeleh reče Isaku: „Idi od nas, jer si postao mnogo moćniji od nas!“ ");
INSERT INTO srponstl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isak je otišao odande i postavio šator u Gerarskoj dolini, gde se i naselio. ");
INSERT INTO srponstl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isak je ponovo iskopao bunare koji su bili iskopani u vreme njegovog oca Avrahama, a što su ih po njegovoj smrti zatrpali Filistejci. Bunarima je dao ista imena koja im je dao njegov otac. ");
INSERT INTO srponstl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Kopajući u dolini, Isakove sluge nađu izvor pitke vode. ");
INSERT INTO srponstl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Zbog toga su se gerarski pastiri posvađali sa Isakovim pastirima govoreći: „To je naša voda!“ Taj izvor su nazvali Esek, zato što su se svađali s njim. ");
INSERT INTO srponstl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Onda su iskopali drugi bunar, ali su se posvađali i zbog ovog. Zato su nazvali bunar Sitna. ");
INSERT INTO srponstl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Odande se preselio i iskopao još jedan bunar. Oko ovoga se nisu svađali. Zato ga je nazvao Rovot, rekavši: „Gospod nam je dao prostor da se umnožimo na zemlji.“ ");
INSERT INTO srponstl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Odande je otišao u Vir-Saveju. ");
INSERT INTO srponstl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Iste noći mu se Gospod ukazao u snu i rekao mu: „Ja sam Bog tvoga oca Avrahama. Ne boj se, jer ja sam s tobom. Blagosloviću te i umnožiti tvoje potomstvo zbog moga sluge Avrahama.“ ");
INSERT INTO srponstl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isak je tamo podigao žrtvenik i prizvao ime Gospodnje. Tamo postavi svoj šator, a njegove sluge iskopaju bunar. ");
INSERT INTO srponstl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Tada mu iz Gerara dođe Avimeleh sa svojim savetnikom Ohozatom i Fiholom, zapovednikom vojske. ");
INSERT INTO srponstl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak im reče: „Zašto ste došli k meni kad me mrzite i kad ste me oterali od sebe?“ ");
INSERT INTO srponstl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Oni odgovoriše: „Uvideli smo da je Gospod s tobom. Zato smo rekli: ’Hajde da se zakunemo jedni drugima, i sklopimo savez između sebe.’ ");
INSERT INTO srponstl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ti nama nećeš činiti zla, kao što ni mi tebe nismo dirali. Naprotiv, činili smo ti samo dobro i u miru te ispratili. Na kraju, ti si od Gospoda blagosloveni.“ ");
INSERT INTO srponstl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isak im je onda priredio gozbu, pa su jeli i pili. ");
INSERT INTO srponstl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kad su ujutro ustali, zakleli su se jedni drugima. Isak ih onda isprati i oni odu u miru. ");
INSERT INTO srponstl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tog dana dođu Isakove sluge i izveste ga o bunaru koji su iskopali. Rekli su mu: „Našli smo vodu!“ ");
INSERT INTO srponstl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Taj bunar su nazvali Saveja. Zato se taj grad sve do danas zove „Vir-Saveja“. ");
INSERT INTO srponstl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Kad je Isavu bilo četrdeset godina, uzeo je za ženu Juditu, ćerku Veira Hetita, i Vasematu, ćerku Elona Hetita. ");
INSERT INTO srponstl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","One su zagorčavale život Isaku i Reveki. ");
INSERT INTO srponstl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Kad je Isak ostareo, vid mu se ugasio, tako da nije mogao da vidi. Pozove on svoga starijeg sina Isava i reče mu: „Sine!“ Ovaj mu odgovori: „Evo me!“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak mu reče: „Evo, ostareo sam a ne znam kad ću umreti. ");
INSERT INTO srponstl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Zato uzmi sad svoj tobolac i luk, pa pođi u pustaru i ulovi neku divljač za mene. ");
INSERT INTO srponstl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Onda mi skuvaj ukusno jelo, onako kako volim, pa mi donesi da jedem, da te blagoslovim pre nego što umrem.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ali Reveka je čula šta je Isak rekao svome sinu Isavu. Kad je Isav otišao u pustaru da ulovi divljač svome ocu, ");
INSERT INTO srponstl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Reveka reče svome sinu Jakovu: „Evo, upravo sam čula kako tvoj otac govori tvome bratu Isavu: ");
INSERT INTO srponstl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","’Donesi mi divljač i skuvaj mi ukusno jelo da jedem, pa da te blagoslovim u prisustvu Gospodnjem pre nego što umrem.’ ");
INSERT INTO srponstl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Zato, sine moj, poslušaj me i učini ono što ti naredim. ");
INSERT INTO srponstl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Idi do stada pa mi donesi odande dva lepa jareta, a ja ću od njih pripremiti ukusno jelo za tvoga oca, baš kako on voli. ");
INSERT INTO srponstl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Onda to odnesi tvome ocu da jede, da te blagoslovi pre nego što umre.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakov reče svojoj majci Reveki: „Ali moj brat Isav je kosmat, a ja sam bez dlaka. ");
INSERT INTO srponstl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Šta ako me otac dotakne? Onda će me smatrati varalicom, pa ću na sebe navući prokletstvo, a ne blagoslov.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Njegova majka mu odgovori na to: „Tvoje prokletstvo neka padne na mene, sine moj. Samo ti mene slušaj i donesi mi jariće.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jakov ode pa ih donese svojoj majci, a ona od njih pripravi ukusno jelo, baš kako je njegov otac voleo. ");
INSERT INTO srponstl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Onda Reveka uzme najbolju odeću svoga starijega sina Isava što je imala u kući i u nju obuče svoga mlađeg sina Jakova. ");
INSERT INTO srponstl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","A jarećom kožom obloži njegove ruke i goli deo vrata. ");
INSERT INTO srponstl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Onda je u ruke svoga sina Jakova stavila ukusno jelo i hleb što je pripravila. ");
INSERT INTO srponstl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jakov ode k svome ocu i reče: „Oče!“ Ovaj se odazva: „Evo me. Koji si ti, moj sin?“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","„To sam ja, Isav, tvoj prvenac“ – odgovori Jakov svome ocu. „Učinio sam kako si mi rekao. A sad ustani, sedi i jedi od mog ulova, da bi mogao da me blagosloviš.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ali Isak upita svoga sina: „Kako to da si tako brzo uspeo, sine moj?“ Jakov odgovori: „Gospod, Bog tvoj, mi je u tome pomogao.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isak reče: „Primakni se, sine moj, da te dotaknem, da bih znao jesi li ti moj sin Isav ili nisi.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakov se primakao svome ocu Isaku, koji ga je, dotakavši, rekao: „Glas je Jakovljev, ali su ruke Isavove.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Nije ga prepoznao, jer su mu ruke bile kosmate kao ruke njegovog brata Isava. Zato ga je blagoslovio. ");
INSERT INTO srponstl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ipak, upitao ga je: „Jesi li ti zaista moj sin Isav?“ Jakov odgovori: „Jesam.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Onda Isak reče: „Prinesi mi da jedem od tvog ulova, sine moj, da bih te blagoslovio.“ Jakov mu je prineo da jede, pa je Isak jeo. Uz to mu je doneo i vina da pije. ");
INSERT INTO srponstl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Zatim mu je njegov otac Isak rekao: „Priđi, sine moj, da te poljubim.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jakov je prišao i Isak ga je poljubio. Isak je pri tom osetio miris odeće svoga sina pa ga je blagoslovio i rekao: „Gle, miris moga sina je kao miris polja što ih je Gospod blagoslovio. ");
INSERT INTO srponstl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Neka ti da Bog rosu s neba i rodnu zemlju, obilje žita i mladoga vina. ");
INSERT INTO srponstl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Neka ti služe narodi, i neka ti se klanjaju plemena. Budi vladar svojoj braći; sinovi majke tvoje ničice nek padaju pred tobom. Ko tebe proklinje, sam će proklet biti, a ko te blagosilja, blagosloven će biti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Kad je Isak blagoslovio Jakova, i čim je Jakov otišao od svoga oca Isaka, vrati se njegov brat Isav iz lova. ");
INSERT INTO srponstl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","I on je pripremio ukusno jelo i došao k svome ocu. Rekao mu je: „Oče moj, ustani i jedi od ulova svoga sina, da bi me blagoslovio.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","„Ko si ti?“ – upita ga njegov otac. Isav odgovori: „To sam ja, Isav, tvoj prvenac.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Čuvši to, Isak se sav prepao. Onda je rekao: „Ko je onda onaj što je ulovio divljač i doneo mi je? Ja sam to jeo pre nego što si ti došao. Njega sam blagoslovio, te će blagosloven i ostati.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Čuvši reči svoga oca, Isav glasno i gorko zarida. Onda reče svome ocu: „Blagoslovi i mene, oče moj!“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isak odgovori: „Došao je tvoj brat i na prevaru dobio tvoj blagoslov.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Isav reče na to: „Ne zove li se s pravom Jakov? Dvaput me je već prevario: oduzeo mi je prvorodstvo, a sada mi je oduzeo i blagoslov.“ Onda je rekao: „Zar za mene nisi sačuvao bar jedan blagoslov?“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak odgovori Isavu: „Eto, njega sam već postavio za gospodara nad tobom, a svu njegovu braću odredio za njegove sluge. Obezbedio sam ga žitom i mladim vinom. Šta sad mogu da učinim za tebe, sine moj?“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Isav mu reče: „Zar ti imaš samo jedan blagoslov, oče moj? Blagoslovi i mene, oče moj!“ Isav je jecao na sav glas. ");
INSERT INTO srponstl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tada mu reče njegov otac Isak: „Daleko od rodne zemlje tvoj dom će biti, i rosa je nebeska neće natapati. ");
INSERT INTO srponstl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Od svoga mača ćeš živeti, i svome ćeš bratu služiti. Ali jednom kad se usprotiviš, jaram ćeš njegov sa svog vrata zbaciti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Isav je omrznuo Jakova zbog blagoslova kojim ga je njegov otac blagoslovio. Govorio je u sebi: „Bliže se dani žalosti za mojim ocem; onda ću ubiti svoga brata Jakova.“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Kad su Reveki javili šta je rekao njen stariji sin Isav, pozvala je svog mlađeg sina Jakova i rekla mu: „Pazi! Tvoj brat Isav pomišlja na osvetu. Hoće da te ubije! ");
INSERT INTO srponstl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","A sad, sine moj, poslušaj moje reči. Ustani i beži k mome bratu, Lavanu, u Haran. ");
INSERT INTO srponstl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ostani kod njega nekoliko dana dok se ne stiša gnev tvoga brata. ");
INSERT INTO srponstl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","A čim se stiša gnev tvoga brata i on zaboravi šta si mu učinio, poslaću po tebe i dovešću te odande. Zašto da vas obojicu izgubim u jedan dan?“ ");
INSERT INTO srponstl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Reveka se zatim obrati Isaku: „Život mi se smučio zbog ovih Hetitkinja! Ako se i Jakov oženi jednom od žena ove zemlje, Hetitkinjom, šta će mi onda život!“ ");
INSERT INTO srponstl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isak pozva svoga sina Jakova i blagoslovi ga. Onda mu zapovedi: „Ne uzimaj sebi za ženu neku od hananskih devojaka. ");
INSERT INTO srponstl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Spremi se i pođi u Padan-Aram, u dom Vatuila, oca tvoje majke, i tamo uzmi sebi za ženu jednu od ćerki Lavana, brata tvoje majke. ");
INSERT INTO srponstl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","A Bog Svemoćni neka te blagoslovi i učini te rodnim i brojnim, tako da postaneš skup naroda. ");
INSERT INTO srponstl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Neka ti podari Avrahamov blagoslov, pa neka tvoje potomstvo zauzme zemlju u kojoj boraviš kao došljak, zemlju koju je Bog dao Avrahamu!“ ");
INSERT INTO srponstl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isak otpremi Jakova, te ovaj ode u Padan-Aram, k Lavanu, sinu Aramejca Vatuila, bratu Reveke, majke Jakova i Isava. ");
INSERT INTO srponstl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isav je video kad je Isak blagoslovio Jakova i poslao ga u Padan-Aram da tamo nađe sebi ženu, te da mu je zapovedio dok ga je blagosiljao: „Ne uzimaj sebi za ženu neku od hananskih devojaka!“, ");
INSERT INTO srponstl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","i da je Jakov poslušao svoga oca i svoju majku te otišao u Padan-Aram. ");
INSERT INTO srponstl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tada je Isav uvideo da su hananske devojke mrske njegovom ocu Isaku, ");
INSERT INTO srponstl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","pa je otišao k Ismailu, te se, pored žena koje je već imao, oženio Mahalatom, ćerkom Avrahamovog sina Ismaila, a Navajotovom sestrom. ");
INSERT INTO srponstl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","A Jakov ode iz Vir-Saveje i zaputi se u Haran. ");
INSERT INTO srponstl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kad je došao do nekog mesta, zaustavio se da prenoći, jer je sunce bilo zašlo. Uzeo je jedan kamen s onog mesta, stavio ga pod glavu, pa legao. ");
INSERT INTO srponstl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Usnio je san: lestve stoje na zemlji, a vrh im dopire do neba, i anđeli Božiji penju se i silaze po njima. ");
INSERT INTO srponstl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Na njima je, gore, stajao Gospod. On reče: „Ja sam Gospod, Bog tvoga pretka Avrahama i Bog Isakov. Zemlju na kojoj ležiš daću tebi i tvome potomstvu. ");
INSERT INTO srponstl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tvojih će potomaka biti kao praha zemaljskog; raširićeš se na zapad, istok, sever i jug. Preko tebe i tvoga potomstva će biti blagoslovena sva plemena na zemlji. ");
INSERT INTO srponstl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Evo, ja sam s tobom: čuvaću te gde god pođeš i dovešću te natrag u ovu zemlju. Neću te ostaviti, nego ću izvršiti što sam ti rekao.“ ");
INSERT INTO srponstl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jakov se tu probudi od sna i reče: „Zaista je Gospod na ovom mestu, a ja to nisam znao!“ ");
INSERT INTO srponstl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Sav prestrašen rekao je: „Kako je strašno ovo mesto! Nije to ništa drugo nego li Dom Božiji, a ovo su vrata nebeska.“ ");
INSERT INTO srponstl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jakov ustane ujutro, uzme onaj kamen što ga je stavio pod glavu, uspravi ga kao stub i na njega izlije ulje. ");
INSERT INTO srponstl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","To mesto je nazvao „Vetilj“. Taj grad se ranije zvao Luz. ");
INSERT INTO srponstl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jakov se tu zavetovao, rekavši: „Ako Bog bude sa mnom i sačuva me na ovom putu kojim idem, da mi hleba za jelo i odeće da se oblačim, ");
INSERT INTO srponstl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","i u miru se vratim u dom svoga oca i Gospod se kao Bog moj pokaže, ");
INSERT INTO srponstl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","onda će ovaj kamen što sam ga postavio kao stub, biti Dom Božiji. A od svega što mi budeš dao, tebi ću davati jednu desetinu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jakov nastavi putovanje i dođe u zemlju naroda istoka. ");
INSERT INTO srponstl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Odjednom spazi bunar u polju. Oko njega su plandovala tri stada ovaca, jer su ih pojili s tog bunara. Na bunaru je bio navaljen veliki kamen. ");
INSERT INTO srponstl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kada bi se stada okupila, pastiri bi odvaljali kamen s otvora i napojili ovce. Potom bi vratili kamen na svoje mesto, na otvor bunara. ");
INSERT INTO srponstl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakov ih upita: „Odakle ste, braćo moja?“ „Iz Harana smo“ – odgovoriše oni. ");
INSERT INTO srponstl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","„Poznajete li Nahorovog sina Lavana?“ – ponovo ih upita Jakov. Oni odgovore: „Poznajemo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","„Je li dobro?“ – nastavi Jakov. „Dobro je – odgovore pastiri. Evo, njegova ćerka, Rahilja, upravo dolazi sa stadom.“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jakov reče: „Dan je još u punom jeku. Nije vreme da se okupe stada. Napojite ovce i izvedite ih na pašu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Oni odgovoriše: „Ne možemo dok se ne okupe ostala stada i dok pastiri ne odvaljaju kamen s otvora bunara. Onda ćemo napojiti stada.“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Dok je on još razgovarao sa njima, dođe Rahilja sa ovcama svoga oca; bila je, naime, pastirica. ");
INSERT INTO srponstl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kad je Jakov video Rahilju, ćerku Lavana, brata njegove majke i njegove ovce, pristupio je bunaru i odvaljao kamen s njega, te je napojio ovce svoga ujaka Lavana. ");
INSERT INTO srponstl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Onda je poljubio Rahilju i glasno zaplakao. ");
INSERT INTO srponstl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Zatim je rekao Rahilji da je on sinovac njenog oca Lavana a sin Revekin. Na to ona otrči i obavesti svoga oca. ");
INSERT INTO srponstl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kad je Lavan čuo vest o Jakovu, sinu svoje sestre, potrčao mu je u susret, pa ga je zagrlio i poljubio. Zatim ga je doveo u svoju kuću. Jakov je potom ispričao Lavanu o svemu što mu se dogodilo. ");
INSERT INTO srponstl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Na to je Lavan rekao: „Ti si stvarno moja kost i moje telo!“ Pošto je Jakov proveo s njim celi mesec, ");
INSERT INTO srponstl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lavan reče Jakovu: „Zar da besplatno radiš za mene, samo zato što si mi rod? Kaži mi kakvu platu tražiš.“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","A Lavan je imao dve ćerke. Starija se zvala Lija a mlađa Rahilja. ");
INSERT INTO srponstl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lija nije imala lepe oči, ali je Rahilja bila stasita i naočita. ");
INSERT INTO srponstl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Pošto je voleo Rahilju, Jakov reče: „Radiću za tebe sedam godina za tvoju mlađu ćerku Rahilju.“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lavan odgovori Jakovu: „Bolje da je dam tebi nego nekom drugom čoveku. Ostani sa mnom.“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jakov je radio za Rahilju sedam godina. Pošto ju je voleo, činilo mu se da su godine prošle kao nekoliko dana. ");
INSERT INTO srponstl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Nakon toga Jakov reče Lavanu: „Moje se vreme navršilo. Zato mi daj moju ženu, jer hoću da budem s njom.“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tada Lavan okupi sve stanovnike tog mesta i priredi gozbu. ");
INSERT INTO srponstl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ali uveče uzme on svoju ćerku Liju i uvede je k Jakovu, te ovaj legne s njom. ");
INSERT INTO srponstl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lavan je svoju sluškinju Zelfu dao svojoj ćerki za sluškinju. ");
INSERT INTO srponstl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kad je svanulo, kad ono Lija! Jakov reče Lavanu: „Šta si mi to učinio? Zar nisam kod tebe radio za Rahilju? Zašto si me prevario?“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lavan odgovori: „Kod nas nije običaj da se mlađa ćerka uda pre starije. ");
INSERT INTO srponstl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Završi sa starijom ovu svadbenu sedmicu, pa ćemo ti dati i mlađu za narednih sedam godina u mojoj službi.“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakov je pristao. Kad je završio svadbenu sedmicu s Lijom, Lavan mu dade svoju ćerku Rahilju za ženu. ");
INSERT INTO srponstl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Svoju sluškinju, Valu, je dao svojoj ćerki Rahilji za sluškinju. ");
INSERT INTO srponstl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakov je onda legao i s Rahiljom i voleo ju je više nego Liju. I tako je radio za Lavana narednih sedam godina. ");
INSERT INTO srponstl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Gospod je video da je Lija nevoljena, pa ju je učinio plodnom; Rahilja je, pak, bila nerotkinja. ");
INSERT INTO srponstl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lija je zatrudnela i rodila sina. Dala mu je ime „Ruvim“, jer je rekla: „Gospod je video moju nevolju; sada će me moj muž voleti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ponovo je zatrudnela i rodila sina. Tada je rekla: „Gospod je čuo da sam nevoljena, pa mi je dao i ovog sina.“ Zato mu je dala ime „Simeun“. ");
INSERT INTO srponstl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lija je zatrudnela i treći put i rodila sina. Rekla je tada: „Sad će mi se moj muž prikloniti, jer sam mu rodila tri sina.“ Zato mu je dala ime „Levi“. ");
INSERT INTO srponstl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ponovo je zatrudnela i rodila sina. Tom prilikom je rekla: „Sada ću slaviti Gospoda.“ Zato ga je nazvala „Juda“. Potom je prestala da rađa. ");
INSERT INTO srponstl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Kada je Rahilja videla da ne može da rađa Jakovu decu, postala je zavidna na svoju sestru. Rekla je Jakovu: „Daj mi decu! Ako nećeš, ja ću umreti!“ ");
INSERT INTO srponstl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakov se naljutio na Rahilju i rekao joj: „Zar ja mogu zameniti Boga koji ti nije dao dece?“ ");
INSERT INTO srponstl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ona mu reče: „Evo, tu je moja sluškinja Vala. Lezi s njom, pa neka rodi na mojim kolenima, da tako i ja steknem potomstvo preko nje.“ ");
INSERT INTO srponstl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rahilja mu je dala svoju sluškinju Valu, pa je Jakov legao s njom. ");
INSERT INTO srponstl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Vala zatrudni i rodi Jakovu sina. ");
INSERT INTO srponstl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Tada je Rahilja rekla: „Bog je presudio u moju korist. Uslišio je moj glas i dao mi sina.“ Zato mu je dala ime „Dan“. ");
INSERT INTO srponstl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahiljina sluškinja, Vala, je ponovo zatrudnela i rodila Jakovu drugog sina. ");
INSERT INTO srponstl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Tada je rekla: „Silno sam se borila te sam nadvladala u borbi sa sestrom.“ Zato ga je nazvala „Neftalim“. ");
INSERT INTO srponstl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Kad je Lija videla da je prestala da rađa, uzela je svoju sluškinju Zelfu i dala je Jakovu za ženu. ");
INSERT INTO srponstl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Tako je i Zelfa, Lijina sluškinja, rodila Jakovu sina. ");
INSERT INTO srponstl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Tada je Lija rekla: „Došla nam je sreća!“ Zato mu je dala ime „Gad“. ");
INSERT INTO srponstl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Lijina sluškinja Zelfa je ponovo zatrudnela i rodila Jakovu drugog sina. ");
INSERT INTO srponstl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lija je tada rekla: „Blago meni! Žene će me zvati blaženom.“ Zato mu je dala ime „Asir“. ");
INSERT INTO srponstl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Jednom, u vreme pšenične žetve, Ruvim je išao poljem i našao mandragore. Doneo ih je svojoj majci, Liji. Rahilja reče Liji: „Daj mi, molim te, malo od mandragora tvoga sina!“ ");
INSERT INTO srponstl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","A Lija joj odgovori: „Zar ti nije dosta što si mi uzela muža, nego hoćeš da uzmeš i mandragore moga sina?“ Rahilja odgovori: „U redu. Neka Jakov legne s tobom ove noći u zamenu za mandragore tvoga sina.“ ");
INSERT INTO srponstl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kad se Jakov vratio uveče iz polja, izađe mu Lija u susret i reče: „Spavaćeš sa mnom ove noći, jer sam te dobila u zamenu za mandragore moga sina.“ Tako je te noći Jakov spavao sa Lijom. ");
INSERT INTO srponstl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Bog je uslišio Liju, te je zatrudnela i rodila Jakovu petog sina. ");
INSERT INTO srponstl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Tada Lija reče: „Bog me je nagradio zato što sam ustupila svoju sluškinju svome mužu.“ Zato mu je dala ime „Isahar“. ");
INSERT INTO srponstl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lija je ponovo zatrudnela i rodila Jakovu šestog sina. ");
INSERT INTO srponstl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Tada je rekla: „Bog me je darovao dragocenim darom; sada će me moj muž ceniti jer rodila sam mu šest sinova.“ Tome je dala ime „Zavulon“. ");
INSERT INTO srponstl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Potom je rodila i ćerku i dala joj ime „Dina“. ");
INSERT INTO srponstl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tada se Bog setio Rahilje: Bog ju je uslišio i učinio da može da rađa. ");
INSERT INTO srponstl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Zatrudnela je i rodila sina. Tom prilikom je rekla: „Bog je uklonio moju sramotu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Dala mu je ime „Josif“, dodavši: „Neka mi Gospod doda još jednog sina.“ ");
INSERT INTO srponstl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Nakon što je Rahilja rodila Josifa, Jakov reče Lavanu: „Pusti me da odem u svoje mesto u svojoj zemlji ");
INSERT INTO srponstl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Daj mi moje žene za koje sam radio kod tebe i moju decu, da mogu da odem. Ti dobro znaš kako sam radio za tebe.“ ");
INSERT INTO srponstl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","A Lavan mu reče: „Ako imaš i malo naklonosti za mene, ne idi! Po znamenjima sam shvatio da me je Gospod blagosiljao zbog tebe. ");
INSERT INTO srponstl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Daću ti platu koju sam odrediš.“ ");
INSERT INTO srponstl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakov mu odgovori: „Ti dobro znaš kako sam ti služio i koliko je stoka uznapredovala pod mojom brigom. ");
INSERT INTO srponstl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ono malo stoke što si imao pre mene se veoma uvećalo, i Gospod te je blagoslovio kud god sam pošao. Nije li sad vreme da se postaram i za svoju kuću?“ ");
INSERT INTO srponstl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lavan mu reče: „Koliko da ti platim?“ Jakov mu odgovori: „Nemoj da mi platiš ništa. Tvoja stada ću goniti na pašu i čuvati ih samo ako mi učiniš ovo: ");
INSERT INTO srponstl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Danas ću proći kroz sva tvoja stada i izdvojiti svaku ovcu crne boje i svaku šarenu i prugastu kozu. To će biti moja plata. ");
INSERT INTO srponstl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kad ubuduće budeš svojim očima proveravao moju platu, moje poštenje će svedočiti za mene: ako se u mome stadu nađe ijedna koza koja nije šarena i prugasta, ili jagnje koje nije crno, neka se smatra kao ukradeno.“ ");
INSERT INTO srponstl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","„Neka bude kako si rekao“ – odgovori Lavan. ");
INSERT INTO srponstl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ali tog istog dana Lavan izdvoji sve prugaste i šarene jarce, i sve prugaste i šarene koze – svaku koja je na sebi imala belo, kao i svu jagnjad crne boje, pa ih preda svojim sinovima. ");
INSERT INTO srponstl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Zatim se sa stadom udaljio na tri dana hoda od Jakova. Jakov je, pak, ostao da čuva ostatak njegovog stada. ");
INSERT INTO srponstl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jakov je tada uzeo mlade prutove od topole, badema i platana; na njima je izrezao pruge tako što je ogulio koru i otkrio belinu. ");
INSERT INTO srponstl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Prutove koje je ogulio postavio je u korita ispred stoke koja je dolazila da pije vodu iz pojila. Stoka je dolazila da pije i tu bi se parila. ");
INSERT INTO srponstl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","A pošto su se jarci i koze parili pred prućem, koze bi ojarile prugaste, riđaste i šarene jariće. ");
INSERT INTO srponstl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jakov je još izdvojio jagnjad na stranu, dok je ostatak ovaca okrenuo prema prugastim i sasvim crnim ovcama u Lavanovom stadu. Tako je sticao sebi stada koja nije mešao s Lavanovim stadima. ");
INSERT INTO srponstl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kad god bi se parila naprednija stoka, Jakov bi stavljao ono pruće u pojila, baš pred oči stoke kako bi se parila pred prućem. ");
INSERT INTO srponstl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Međutim, pred kržljavu stoku nije stavljao pruće. Tako je kržljavu dobijao Lavan a dobro razvijenu Jakov. ");
INSERT INTO srponstl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Čovek se tako veoma obogatio, stekao je mnogo stoke, slugu i sluškinja, kamila i magaraca. ");
INSERT INTO srponstl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Čuo je Jakov da Lavanovi sinovi govore: „Jakov je prisvojio sve što pripada našem ocu. Sve ovo bogatstvo je stekao od imovine našeg oca.“ ");
INSERT INTO srponstl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakov je primetio i po Lavanovom licu da se ovaj prema njemu ne drži kao ranije. ");
INSERT INTO srponstl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Tada Gospod reče Jakovu: „Vrati se u zemlju svojih otaca, u svoj rodni kraj, i ja ću biti s tobom.“ ");
INSERT INTO srponstl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jakov je tada pozvao Rahilju i Liju u polje gde je bilo njegovo stado, ");
INSERT INTO srponstl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","i rekao im: „Vidim po licu vašeg oca da se ne drži prema meni kao ranije. Ali sa mnom je bio Bog moga oca. ");
INSERT INTO srponstl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Vi i same znate da sam za vašeg oca radio svom svojom snagom. ");
INSERT INTO srponstl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Međutim, vaš otac me je varao i deset puta mi menjao platu. Ipak, Bog mu nije dopustio da mi nanese štetu. ");
INSERT INTO srponstl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ako bi on rekao: ’Svako šareno grlo će ti biti plata’, onda bi celo stado mladilo šarenu mladunčad. A ako bi rekao: ’Svako prugasto grlo će ti biti plata’, onda bi stado mladilo prugastu mladunčad. ");
INSERT INTO srponstl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tako je Bog uzimao stoku od vašeg oca i davao je meni. ");
INSERT INTO srponstl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Jednom, kad se stado parilo, u snu sam video da su jarci koji su se parili s kozama bili prugasti, mestimično beli i šareni. ");
INSERT INTO srponstl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tada me je Anđeo Božiji pozvao u snu: ’Jakove!’ Ja se odazvah: ’Evo me!’ ");
INSERT INTO srponstl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Anđeo mi reče: ’Podigni svoj pogled i uoči da su svi jarci koji se pare s kozama, prugasti, mestimično beli i šareni. Video sam, naime, sve što ti je Lavan učinio. ");
INSERT INTO srponstl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ja sam Bog koji ti se objavio u Vetilju, gde si pomazao stub i gde si učinio zavet sa mnom. Zato se sad spremi i napusti ovu zemlju, pa se vrati u svoju rodnu zemlju.’“ ");
INSERT INTO srponstl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rahilja i Lija mu odgovore na to: „Zar mi još imamo ikakav deo nasledstva u domu našeg oca? ");
INSERT INTO srponstl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nije li na nas gledao kao na tuđinke? Nas je prodao, a novac koji je za nas dobio je potrošio! ");
INSERT INTO srponstl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Sve to bogatstvo što ga je Bog uzeo od našeg oca pripada nama i našoj deci. Zato učini sve što ti je Bog rekao.“ ");
INSERT INTO srponstl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Tada se Jakov spremi, te posadi svoju decu i svoje žene na kamile. ");
INSERT INTO srponstl_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Zatim potera svu svoju stoku pred sobom, svu svoju imovinu koju je stekao, stoku koju je sabrao u Padan-Aramu, pa se zaputi k svome ocu, Isaku, u hanansku zemlju. ");
INSERT INTO srponstl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kad je Lavan otišao da striže svoje ovce, Rahilja je ukrala kućne idole koji su pripadali njenom ocu. ");
INSERT INTO srponstl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jakov je, pak, zavarao Lavana Aramejca time što nije dao da ovaj nasluti da će on pobeći. ");
INSERT INTO srponstl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Tako je Jakov pobegao sa svim što je bilo njegovo. Prešao je reku Eufrat i zaputio se prema galadskom gorju. ");
INSERT INTO srponstl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Trećeg dana su javili Lavanu da je Jakov pobegao. ");
INSERT INTO srponstl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ovaj je tada poveo svoje rođake i krenuo u poteru za Jakovom sedam dana hoda. Stigao ga je kod brda Galad. ");
INSERT INTO srponstl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ali Bog je došao k Aramejcu Lavanu noću, u snu i rekao mu: „Pazi da ne preduzimaš ništa protiv Jakova, ni dobro ni zlo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Lavan je, dakle, stigao Jakova. Jakov je postavio svoj šator na jednom brdu, a Lavan je sa svojim rođacima postavio svoj šator na brdu Galad. ");
INSERT INTO srponstl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lavan reče Jakovu: „Šta si to uradio? Obmanuo si me i pobegao sa mojim ćerkama kao da su ratne zarobljenice. ");
INSERT INTO srponstl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Zašto si tajno pobegao i obmanuo me? Da si mi rekao da ideš ja bih te ispratio s veseljem i pesmom, uz bubnjeve i lire. ");
INSERT INTO srponstl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","A nisi mi dao ni da izljubim svoju unučad i svoje ćerke. Zaista si ludo postupio. ");
INSERT INTO srponstl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","U mojoj je moći da vam naudim. Ali Bog tvoga oca mi je prošle noći rekao: ’Pazi da ne preduzimaš ništa protiv Jakova, ni dobro, ni zlo.’ ");
INSERT INTO srponstl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","U redu, sad, otišao si jer si čeznuo za očinskim domom, ali zašto si ukrao moje bogove?“ ");
INSERT INTO srponstl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakov odgovori Lavanu: „Bio sam se uplašio, jer sam mislio da ćeš oteti svoje ćerke od mene. ");
INSERT INTO srponstl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","A ako kod koga nađeš svoje bogove, taj neće ostati na životu. Pokaži ovde pred našim rođacima šta ja to imam kod sebe što je tvoje, pa nosi!“ Jakov, naime, nije znao da je Rahilja ukrala idole. ");
INSERT INTO srponstl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lavan je ušao u Jakovljev šator, pa u šator Lije, te u šator dveju sluškinja, ali tamo ništa nije našao. Onda je izašao iz Lijinog šatora i ušao u Rahiljin. ");
INSERT INTO srponstl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahilja je, pak, uzela idole i stavila ih u sedlo svoje kamile i sela na njih. Lavan je pretražio celi šator, ali idole nije našao. ");
INSERT INTO srponstl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","A Rahilja je rekla svome ocu: „Neka se ne ljuti moj gospodar što ne mogu da ustanem pred njim; snašlo me je, naime, ono što običava u žena.“ Tako je Lavan tražio, ali nije mogao da nađe idole. ");
INSERT INTO srponstl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Tada je Jakov planuo i stao da se prepire s Lavanom: „Koje je to moje zlodelo i koja je moja krivica, te me tako proganjaš? ");
INSERT INTO srponstl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Evo, ispremetao si celo moje pokućstvo, pa kakav si predmet iz svoga doma pronašao? Stavi ga ovde, pred moju i tvoju rodbinu, pa nek oni presude između nas dvojice. ");
INSERT INTO srponstl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Za ovih dvadeset godina koliko sam bio s tobom, tvoje ovce i koze se nisu jalovile, niti sam jeo od ovnova iz tvoga stada. ");
INSERT INTO srponstl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ono što bi divlja zver rastrgla, tebi nisam donosio, nego bih gubitak sam nadoknadio. To si zahtevao od mene bez obzira da li je grlo bilo ukradeno danju ili noću. ");
INSERT INTO srponstl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Danju me je satirala žega, a noću hladnoća. San se nije spuštao na moje oči. ");
INSERT INTO srponstl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Od ovih dvadeset godina koje sam proveo u tvojoj kući, četrnaest godina sam ti služio za tvoje dve ćerke, a šest godina za tvoje stado, iako si mi menjao platu deset puta. ");
INSERT INTO srponstl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Da sa mnom nije bio Bog moga oca, Bog Avrahamov i Strah Isakov, ti bi me otpustio praznih ruku. Ali Bog je video moju muku i trud mojih ruku, te je sinoć presudio.“ ");
INSERT INTO srponstl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lavan odgovori Jakovu: „Ćerke su moje ćerke, deca su moja deca, stado je moje stado i sve što vidiš je moje. A ipak, šta danas mogu da učinim ovim svojim ćerkama ili deci koju su rodile? ");
INSERT INTO srponstl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Stoga, hajde da ja i ti sklopimo savez, pa da to bude svedok između mene i tebe.“ ");
INSERT INTO srponstl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jakov je tada uzeo jedan kamen i uspravio ga kao stub. ");
INSERT INTO srponstl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Onda je rekao svojim rođacima: „Sakupite kamenje.“ Oni su uzeli kamenje i načinili od njega gomilu. Zatim su zajedno jeli kod te gomile. ");
INSERT INTO srponstl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lavan ju je nazvao Jegar-Sahaduta, a Jakov je nazvao Galed. ");
INSERT INTO srponstl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Onda Lavan reče: „Neka ova gomila danas bude svedok između tebe i mene.“ Zato je nazvana Galed, ");
INSERT INTO srponstl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ali i Mispa, jer je Lavan rekao: „Neka Gospod motri na mene i na tebe kad ne budemo videli jedan drugoga. ");
INSERT INTO srponstl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ako budeš zlostavljao moje ćerke, ili ako pored mojih ćerki uzmeš sebi druge žene, pa da i niko ne bude bio s nama, pazi: Gospod je svedok između mene i tebe.“ ");
INSERT INTO srponstl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lavan još reče Jakovu: „Evo, ovde je gomila a ovde je stub koji sam uspravio da bude međa između mene i tebe. ");
INSERT INTO srponstl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Svedok je ova gomila, a svedok je i ovaj stub, da ja neću prelaziti ovu gomilu da ti naudim, niti da ćeš ti prelaziti ovaj stub i ovu gomilu da meni naudiš. ");
INSERT INTO srponstl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Neka Bog Avrahamov i bog Nahorov, i bog njihovog oca, sude među nama.“ Jakov se tada zakleo Strahom svoga oca Isaka. ");
INSERT INTO srponstl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Zatim je Jakov prineo žrtvu na brdu i pozvao svoju rodbinu na obed. Nakon obeda su prenoćili na brdu. ");
INSERT INTO srponstl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","U rano jutro Lavan ustane, izljubi svoje unuke i ćerke i blagoslovi ih. Zatim krene i vrati se u svoje mesto. ");
INSERT INTO srponstl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakov je išao svojim putem, kad mu u susret izađu Božiji anđeli. ");
INSERT INTO srponstl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ugledavši ih, Jakov reče: „Ovo je Božiji tabor!“ Zato je to mesto nazvao Mahanajim. ");
INSERT INTO srponstl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakov je pred sobom poslao glasnike svome bratu Isavu u zemlju Sir, u edomsku pustaru. ");
INSERT INTO srponstl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Zapovedio im je: „Ovako recite mome gospodaru Isavu: ’Ovako kaže tvoj sluga Jakov: Živeo sam u tuđini kod Lavana i tamo sam se zadržao sve do sad. ");
INSERT INTO srponstl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Stekao sam volove, magarce, ovce, sluge i sluškinje. Šaljem ovu poruku mome gospodaru, ne bih li stekao tvoju naklonost.’“ ");
INSERT INTO srponstl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Glasnici su se vratili k Jakovu i rekli mu: „Bili smo kod tvoga brata Isava, i evo, on ti dolazi u susret sa četiri stotine svojih ljudi.“ ");
INSERT INTO srponstl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jakov se na to prepadne i uznemiri. Zato je podelio na dva tabora ljude sa njim, a takođe i ovce, stoku i kamile, ");
INSERT INTO srponstl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","misleći: „Ako Isav naiđe na jedan tabor i napadne ga, preostali tabor bi još mogao uteći.“ ");
INSERT INTO srponstl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jakov se tada pomolio: „O, Bože moga oca, Avrahama! O, Bože moga oca, Isaka! O, Gospode, koji si mi rekao: ’Vrati se u svoju zemlju, u svoje rodno mesto, i ja ću se pokazati dobrostivim prema tebi.’ ");
INSERT INTO srponstl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Nedostojan sam sve tvoje milosti i sve tvoje vernosti što si iskazao svome sluzi. Jer, nekada sam samo sa štapom prešao preko ovog Jordana, a sad imam dva tabora. ");
INSERT INTO srponstl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Izbavi me, molim te, iz ruku moga brata, iz ruku Isavovih, jer se bojim da bi mogao da dođe i ubije i mene i majke s decom. ");
INSERT INTO srponstl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","A ti si rekao: ’Svakako ću se pokazati dobrim prema tebi i učiniti da tvoga potomstva bude kao peska u moru, koji se od mnoštva ne da prebrojiti.’“ ");
INSERT INTO srponstl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Tu noć je proveo tamo. Onda je od stoke što je imao sa sobom pripremio dar za svoga brata Isava: ");
INSERT INTO srponstl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","dve stotine koza i dvadeset jaraca, dve stotine ovaca i dvadeset ovnova, ");
INSERT INTO srponstl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","trideset kamila dojilica sa njihovim mladuncima, četrdeset krava i deset bikova, dvadeset magarica i deset magaraca. ");
INSERT INTO srponstl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Njih je predao svojim slugama, svako stado posebno, i rekao im: „Vi krenite preda mnom, ali držite rastojanje među stadima.“ ");
INSERT INTO srponstl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Zatim je naredio prvome: „Kad sretneš moga brata Isava, i on te upita: ’Čiji si ti? Kuda ideš? Čija su ova stada pred tobom?’, ");
INSERT INTO srponstl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ti reci: ’Ona pripadaju tvome sluzi Jakovu; ovo je dar koji šalje svome gospodaru Isavu. On, evo, dolazi za nama.’“ ");
INSERT INTO srponstl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Takav je nalog izdao i drugom i trećem, kao i svim ostalima koji su išli za stadima, rekavši: „To ćete reći Isavu kad ga sretnete. ");
INSERT INTO srponstl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Takođe recite: ’Evo, tvoj sluga Jakov takođe ide za nama.’“ Mislio je, naime: „Umilostiviću prvo Isava darom koji ide preda mnom, a onda ću se suočiti s njim. Možda će mi tada oprostiti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tako je dar otišao pred njim, dok je on sam prenoćio u taboru. ");
INSERT INTO srponstl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Te noći Jakov ustane, uzme svoje dve žene i svoje dve sluškinje i svoje jedanaestoro dece, pa pređe Javok preko gaza. ");
INSERT INTO srponstl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Nakon što ih je prebacio preko gaza, prebacio je i svu svoju imovinu. ");
INSERT INTO srponstl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jakov je ostao sam, i tada se neki čovek rvao s njim sve do u osvit zore. ");
INSERT INTO srponstl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Kad je video da ne može da savlada Jakova, uganuo mu je zglob pri kuku, tako da se Jakovu iščašio kuk dok se rvao s njim. ");
INSERT INTO srponstl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Tada čovek reče: „Pusti me, jer sviće zora!“ „Neću te pustiti dok me ne blagosloviš!“ – odvrati Jakov. ");
INSERT INTO srponstl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Čovek ga upita: „Kako ti je ime?“ „Jakov“ – odgovori. ");
INSERT INTO srponstl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Onda čovek reče: „Više se nećeš zvati Jakov, nego ’Izrailj’, jer si se borio i sa Bogom i sa ljudima, ali si nadvladao.“ ");
INSERT INTO srponstl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Zatim je Jakov zapitao: „Reci mi, molim te, svoje ime.“ „Zašto me pitaš za moje ime?“ – odgovorio je. Tu ga je zatim blagoslovio. ");
INSERT INTO srponstl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakov je to mesto nazvao „Fanuil“, jer je rekao: „Video sam Boga licem u lice, ali sam ostao živ.“ ");
INSERT INTO srponstl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Sunce je granulo dok je Jakov prolazio Fanuil. Hramao je zbog svoga kuka. ");
INSERT INTO srponstl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Zato Izrailjci sve do danas ne jedu tetivu nad kukom iznad bedrenog zgloba, zato što je Jakovljev bedreni zglob bio iščašen u tetivi. ");
INSERT INTO srponstl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakov je podigao pogled i ugledao Isava kako dolazi i četiri stotine ljudi sa njim. Tada je podelio decu između Lije, Rahilje i dve sluškinje. ");
INSERT INTO srponstl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Sluškinje i njihovu decu je postavio na čelo, Liju i njenu decu iza njih, a Rahilju i Josifa na začelje. ");
INSERT INTO srponstl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","A on sam je pošao napred i poklonio se sedam puta do zemlje dok se nije približio svome bratu. ");
INSERT INTO srponstl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ali Isav mu potrči u susret, zagrli ga, padne mu oko vrata i zaplače. ");
INSERT INTO srponstl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Isav je onda podigao pogled i ugledao žene i decu. „Ko su ti ovi?“ – upitao je. „Deca koju je Bog milostivo podario tvome sluzi“ – odgovori Jakov. ");
INSERT INTO srponstl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Tada su pristupile sluškinje sa svojom decom i duboko se poklonile. ");
INSERT INTO srponstl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Zatim je pristupila i Lija sa svojom decom, te su se duboko poklonili. Na kraju su pristupili Josif i Rahilja, pa su se i oni duboko poklonili. ");
INSERT INTO srponstl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Isav je upitao: „Šta si naumio sa ovom povorkom koju sam sreo?“ Jakov odgovori: „Da steknem naklonost svoga gospodara.“ ");
INSERT INTO srponstl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Isav reče: „Ja imam dovoljno, brate moj. Zadrži svoje za sebe.“ ");
INSERT INTO srponstl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","„Nemoj, molim te – reče mu na to Jakov. Ako sam stekao tvoju naklonost, primi ovaj dar od mene. Jer, kad sam video tvoje lice, to je kao da sam video lice Božije, tako si me blagonaklono primio. ");
INSERT INTO srponstl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Stoga primi, molim te, dar koji sam ti doneo, jer Bog mi je bio naklonjen, pa imam svega.“ Jakov ga je toliko saletao da je Isav prihvatio. ");
INSERT INTO srponstl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","„Krenimo na put – reče Isav – i ja ću putovati s tobom.“ ");
INSERT INTO srponstl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jakov odgovori: „Moj gospodar zna da su deca nejaka, a i da moram da se brinem o ovcama i kravama koje doje. Budem li ih prebrzo terao samo jedan dan, sve stado će uginuti. ");
INSERT INTO srponstl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Zato neka moj gospodar krene ispred svoga sluge, a ja ću ići polako, uz korak sa stokom i uz korak sa decom, dok ne dođem k svome gospodaru u Sir.“ ");
INSERT INTO srponstl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Isav reče: „Daj makar da ti ostavim nekoliko svojih ljudi.“ Jakov odgovori: „Čemu? Neka steknem ja samo tvoju naklonost.“ ");
INSERT INTO srponstl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tako je Isav tog dana otišao svojim putem u Sir. ");
INSERT INTO srponstl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jakov, međutim, ode u Sokot, gde je sagradio sebi kuću, i štale za stada. Zato je to mesto nazvano Sokot. ");
INSERT INTO srponstl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Došavši iz Padan-Arama, Jakov je mirno prispeo u grad Sihem koji se nalazi u Hananu. Utaborio se pred gradom. ");
INSERT INTO srponstl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Od sinova Emora, oca Sihemova, je za stotinu kesita kupio komad zemlje, gde je postavio svoj šator. ");
INSERT INTO srponstl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Tu je podigao žrtvenik i nazvao ga „Bog je Bog Izrailjev“. ");
INSERT INTO srponstl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Jednom je Dina, koju je Lija rodila Jakovu, izašla da poseti žene te zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ali kad ju je video Evejac Sihem, sin Emora, kneza te oblasti, on je zgrabi, legne s njom i obeščasti je. ");
INSERT INTO srponstl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","No, bio je toliko privučen Dinom, Jakovljevom ćerkom, da se zaljubio u nju. Zato je nastojao da pridobije devojčino srce. ");
INSERT INTO srponstl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sihem je svom ocu Emoru rekao: „Uzmi mi ovu devojku za ženu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakov je čuo da je njegova ćerka Dina bila obeščašćena dok su njegovi sinovi bili u polju sa stadom. Ipak, ništa nije preduzimao dok se oni ne vrate. ");
INSERT INTO srponstl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","U međuvremenu, Emor, Sihemov otac, dođe k Jakovu da porazgovara s njim. ");
INSERT INTO srponstl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Uto se vrate Jakovljevi sinovi iz polja. Kad su čuli šta se dogodilo ljudi su bili žalosni i veoma ljuti, jer je Sihem počinio sramotu protiv Izrailja legavši s Jakovljevom ćerkom. Tako se šta nije činilo. ");
INSERT INTO srponstl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Emor im tada reče: „Moj se sin svom dušom zaljubio u vašu ćerku. Dajte mu je, molim vas, za ženu. ");
INSERT INTO srponstl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Hajde da se orodimo: vi nama dajte svoje ćerke, a uzimajte sebi naše ćerke. ");
INSERT INTO srponstl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Nastanite se među nama; zemlja je otvorena za vas. Živite, trgujte i stičite dobra u njoj.“ ");
INSERT INTO srponstl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Potom se Sihem obrati njenom ocu i njenoj braći: „Daću sve što zatražite, samo da zadobijem vašu naklonost. ");
INSERT INTO srponstl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Odredite miraz za nju i svadbeni dar. Daću koliko god zatražite, samo mi dajte devojku za ženu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Pošto je njihova sestra Dina bila obeščašćena, Jakovljevi sinovi odgovore Sihemu i njegovom ocu, Emoru, s prevarom na umu: ");
INSERT INTO srponstl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","„Takvu stvar ne možemo učiniti. Za nas bi, naime, bila sramota dati našu sestru neobrezanome. ");
INSERT INTO srponstl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Pristaćemo na to samo ako postanete kao mi, to jest, ako se svaki muškarac među vama obreže. ");
INSERT INTO srponstl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Onda ćemo vam davati naše ćerke, i uzimati vaše ćerke sebi, te se nastaniti među vama i postati jedan narod. ");
INSERT INTO srponstl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","A ako nas ne poslušate i ne obrežete se, mi ćemo uzeti našu sestru i otići.“ ");
INSERT INTO srponstl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Emoru i njegovom sinu Sihemu se ovaj zahtev učinio povoljnim. ");
INSERT INTO srponstl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Mladić, koji je bio najuvaženiji čovek u domu svoga oca, nije oklevao da ispuni ovaj zahtev, jer je voleo Jakovljevu ćerku. ");
INSERT INTO srponstl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Emor i Sihem odu pred kapiju svoga grada i obrate se svojim sugrađanima: ");
INSERT INTO srponstl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","„Ovi ljudi su prijateljski raspoloženi prema nama. Zato neka se nasele u zemlji, i neka trguju u njoj. Zemlja je dovoljno velika i za njih. Mi ćemo moći da uzimamo njihove ćerke za žene, a mi ćemo im davati svoje. ");
INSERT INTO srponstl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Međutim, ljudi će pristati da se nasele među nama i postanu s nama jedan narod samo ako se svaki muškarac među nama obreže kao što su oni obrezani. ");
INSERT INTO srponstl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Neće li tako njihova stada, njihova imovina i sva njihova stoka postati naši? Dajmo im naš pristanak, pa će se naseliti među nama.“ ");
INSERT INTO srponstl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Svi koji su izašli pred gradsku kapiju su poslušali Emora i njegovog sina Sihema, te su svi muškarci koji su došli pred gradsku kapiju bili obrezani. ");
INSERT INTO srponstl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ali trećeg dana, dok su oni bili u bolovima, dva Jakovljeva sina, Simeun i Levi, Dinina braća, uzmu svoje mačeve i nesmetano dođu u grad, te pobiju sve muškarce. ");
INSERT INTO srponstl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Poseku mačem i Emora i njegovog sina Sihema, odvedu Dinu iz Sihemove kuće, pa odu. ");
INSERT INTO srponstl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ostali sinovi Jakovljevi dođu, pa opljačkaju grad gde je njihova sestra bila obeščašćena. ");
INSERT INTO srponstl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Uzeli su i njihovu sitnu i krupnu stoku, magarce i sve što je bilo u gradu i na poljima, ");
INSERT INTO srponstl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","kao i sve što je bilo od vrednosti. Decu i žene su odveli u ropstvo, a sve što je bilo u kućama su opljačkali. ");
INSERT INTO srponstl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Tada Jakov reče Simeunu i Leviju: „Uvalili ste me u neprilike učinivši me mrskim stanovnicima zemlje, Hanancima i Ferežanima. Ja imam tek šaku ljudi; ako se oni udruže protiv mene i napadnu me, istrebiće i mene i moj dom.“ ");
INSERT INTO srponstl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Oni odgovoriše: „Zar da s našom sestrom postupaju kao sa bludnicom?“ ");
INSERT INTO srponstl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Bog reče Jakovu: „Ustani i idi gore u Vetilj i nastani se tamo. Onde podigni žrtvenik Bogu koji ti se ukazao kad si bežao od svoga brata Isava.“ ");
INSERT INTO srponstl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jakov reče svojoj porodici i svima koji su bili s njim: „Odbacite strane bogove iz vaše sredine, očistite se i presvucite odeću. ");
INSERT INTO srponstl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ustanimo i pođimo gore u Vetilj. Tamo ću podići žrtvenik Bogu koji me je uslišio kad sam bio u nevolji i koji je bio sa mnom kad sam pošao na put.“ ");
INSERT INTO srponstl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tada su oni predali Jakovu sve strane bogove koje su imali i naušnice što su im bile na ušima, pa ih Jakov zakopa pod hrast kod Sihema. ");
INSERT INTO srponstl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kad su krenuli na put, Božiji strah je obuzeo okolne gradove, te niko nije krenuo u poteru za Jakovljevim sinovima. ");
INSERT INTO srponstl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Tada je Jakov došao u Luz, to jest Vetilj, u hananskoj zemlji, i sav narod što je bio s njim. ");
INSERT INTO srponstl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Onde je podigao žrtvenik i nazvao to mesto „El-Vetilj“, jer mu se tamo objavio Bog kad je bežao od svog brata. ");
INSERT INTO srponstl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Tu je umrla Devora, Revekina dojilja. Sahranili su je niže Vetilja, pod hrastom, koji se otada zove „Tužni Hrast“. ");
INSERT INTO srponstl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Bog se ponovo objavio Jakovu kad se vratio iz Padan-Arama, i blagoslovio ga. ");
INSERT INTO srponstl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Bog mu reče: „Tvoje ime je Jakov, ali se nećeš više zvati Jakov, nego će ti ime biti ’Izrailj’.“ Tako ga je nazvao Izrailj. ");
INSERT INTO srponstl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Još mu reče Bog: „Ja sam Bog Svemoćni. Budi rodan i množi se. Od tebe će nastati narod i zbor naroda, i od tebe će carevi proisteći. ");
INSERT INTO srponstl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Zemlju koju sam dao Avrahamu i Isaku, predaću tebi i tvome potomstvu posle tebe.“ ");
INSERT INTO srponstl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Bog se onda uzneo od Jakova, s mesta gde mu je govorio. ");
INSERT INTO srponstl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Na mestu gde mu je Bog govorio, Jakov je uspravio stub od kamena, pa je na njega izlio žrtvu izlivnicu i prelio ga uljem. ");
INSERT INTO srponstl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Mesto na kome mu je Bog govorio je nazvao Vetilj. ");
INSERT INTO srponstl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Zatim su napustili Vetilj. Još je bio ostao deo puta do Efrate, kad Rahilja poče da se porađa. Snašli su je jaki trudovi. ");
INSERT INTO srponstl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Kako je porođaj bio težak, babica joj reče: „Ne boj se, jer i ovo ti je sin.“ ");
INSERT INTO srponstl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Na samrti, dok je izdisala, dala mu je ime Venoni, ali ga je otac nazvao „Venijamin“. ");
INSERT INTO srponstl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Kad je Rahilja umrla, sahranili su je na putu za Efratu, to jest, Vitlejem. ");
INSERT INTO srponstl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jakov je na Rahiljinom grobu postavio stub, koji sve do danas stoji na njenom grobu. ");
INSERT INTO srponstl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Izrailj je nastavio putovanje. Svoj šator je postavio s druge strane Migdal-Edera. ");
INSERT INTO srponstl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Dok je Izrailj boravio u toj zemlji, Ruvim ode i legne s Valom, inočom svoga oca. Izrailj dozna za to. Jakovljevih sinova je bilo dvanaest: ");
INSERT INTO srponstl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lijini sinovi su: Jakovljev prvenac Ruvim, Simeun, Levi, Juda, Isahar i Zavulon. ");
INSERT INTO srponstl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahiljini sinovi su: Josif i Venijamin. ");
INSERT INTO srponstl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Sinovi Vale, Rahiljine sluškinje su: Dan i Neftalim. ");
INSERT INTO srponstl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Sinovi Zelfe, Lijine sluškinje su: Gad i Asir. To su Jakovljevi sinovi koji su mu se rodili u Padan-Aramu. ");
INSERT INTO srponstl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakov ode k svome ocu Isaku u Mamriju, u Kirijat-Arvu, to jest Hevron, gde su nekad Avraham, a potom i Isak živeli kao stranci. ");
INSERT INTO srponstl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak je živeo stotinu osamdeset godina. ");
INSERT INTO srponstl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Onda je izdahnuo i umro, te se pridružio svojim precima, star i sit života. Sahranili su ga Isav i Jakov, njegovi sinovi. ");
INSERT INTO srponstl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ovo je rodoslov Isava, to jest Edoma. ");
INSERT INTO srponstl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isav je uzeo sebi za žene dve hananske devojke: Adu, ćerku Elona Hetita, i Olivemu, ćerku Ane, unuku Sevegona Evejca, ");
INSERT INTO srponstl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","i Vasematu, ćerku Ismailovu, Navajotovu sestru. ");
INSERT INTO srponstl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada je Isavu rodila Elifasa, a Vasemata mu je rodila Raguila. ");
INSERT INTO srponstl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Olivema je rodila Jeusa, Jegloma i Koreja. To su Isavovi sinovi koji su mu se rodili u Hananu. ");
INSERT INTO srponstl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Isav je uzeo svoje žene, svoje sinove, svoje ćerke, i sve svoje ljude iz svoga doma, svoju stoku – sitnu i krupnu, i svu svoju imovinu koju je stekao u Hananu, te se odvojio od svoga brata Jakova. ");
INSERT INTO srponstl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Naime, njihova imovina je bila isuviše velika da bi mogli da žive zajedno; zemlja u kojoj su živeli nije ih više mogla izdržavati zbog njihove stoke. ");
INSERT INTO srponstl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Zato se Isav, to jest Edom, nastanio u brdskoj oblasti Sira. ");
INSERT INTO srponstl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","A ovo je rodoslov Isava, praoca Edomaca, u brdskoj oblasti Sira. ");
INSERT INTO srponstl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ovo su imena Isavovih sinova: Elifas, sin Isavove žene Ade, Raguilo, sin Isavove žene Vasemate. ");
INSERT INTO srponstl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifasovi sinovi su bili: Teman, Omar, Sofar, Gotom i Kenez. ");
INSERT INTO srponstl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Tamna, inoča Isavovog sina Elifasa, je rodila Elifasu Amalika. To su potomci Isavove žene Ade. ");
INSERT INTO srponstl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ovo su sinovi Raguilovi: Nahat, Zara, Šama i Moze. To su potomci Isavove žene Vasemate. ");
INSERT INTO srponstl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ovo su sinovi Isavove žene Oliveme, ćerke Anine, unuke Sevegonove. Ona je rodila Isavu Jeusa, Jegloma i Koreja. ");
INSERT INTO srponstl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ovo su knezovi nad Isavovim potomcima. Sinovi Isavovog prvenca Elifasa su knezovi: Teman, Omar, Sofar, Kenez, ");
INSERT INTO srponstl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korej, Gotom i Amalik. Ovi knezovi su Elifasovi sinovi u Edomu, i potomci Isavove žene Ade. ");
INSERT INTO srponstl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ovo su potomci Isavovog sina Raguila. Knezovi: Nahat, Zara, Šama i Moze. Ovi knezovi su sinovi Raguilovi u edomskoj zemlji, a unuci Isavove žene Vasemate. ");
INSERT INTO srponstl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ovo su sinovi Isavove žene Oliveme. Knezovi: Jeus, Jeglom i Korej. To su potomci Isavove žene Oliveme, Anine ćerke. ");
INSERT INTO srponstl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","To su sinovi Isavovi, i to su knezovi u Edomu. ");
INSERT INTO srponstl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ovo su sinovi Sira Horijca, stanovnika one zemlje: Lotan, Soval, Sevegon, Ana, ");
INSERT INTO srponstl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Asar i Disan. Ovi Sirovi sinovi su knezovi Horijaca u edomskoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ovo su Lotanovi sinovi: sinovi Horije i Eman. Lotanova sestra je bila Tamna. ");
INSERT INTO srponstl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ovo su Sovalovi sinovi: Golam, Manahat, Eval, Šefo i Onam. ");
INSERT INTO srponstl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ovo su Sevegonovi sinovi: Aja i Ana. Ana je onaj što je našao izvore vruće vode u pustari, dok je napasao magarce svoga oca Sevegona. ");
INSERT INTO srponstl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anina deca su: Dison i Anina ćerka Olivema. ");
INSERT INTO srponstl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disanovi sinovi su: Amada, Asvan, Itran i Haran. ");
INSERT INTO srponstl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ovo su Asarovi sinovi: Valan, Zavan i Akan. ");
INSERT INTO srponstl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ovo su Disanovi sinovi: Uz i Aran. ");
INSERT INTO srponstl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ovo su knezovi Horijski: Lotan, Soval, Sevegon, Ana, ");
INSERT INTO srponstl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Asar i Rison. To su knezovi horijski po njihovim klanovima u zemlji Sir. ");
INSERT INTO srponstl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","A ovo su carevi koji su vladali u zemlji Edom, pre nego što je i jedan car zavladao nad izrailjskim narodom. ");
INSERT INTO srponstl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Nad Edomom je vladao Valak, Veorov sin, čiji grad se zvao Denava. ");
INSERT INTO srponstl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Kad je Valak umro, na njegovo mesto se zacario Jovav, sin Zarin iz Vosore. ");
INSERT INTO srponstl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Kad je Jovav umro, na njegovo mesto se zacario Asom iz zemlje Temanaca. ");
INSERT INTO srponstl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kad je Asom umro, na njegovo mesto se zacario Adad, Varadov sin, koji je potukao Madijance na moavskom polju. Njegov grad se zvao Avit. ");
INSERT INTO srponstl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kad je Adad umro, na njegovo mesto se zacario Samala iz Masreke. ");
INSERT INTO srponstl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kad je Samala umro, na njegovo mesto se zacario Saul iz Rovota na Reci. ");
INSERT INTO srponstl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Kad je Saul umro, na njegovo mesto se zacario Valenon, sin Ahvorov. ");
INSERT INTO srponstl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kad je Valenon, sin Ahvorov umro, na njegovo mesto se zacario Adar. Njegov grad se zvao Pau. Njegovoj ženi je bilo ime Metaveila, koja je bila ćerka Matraide, ćerke Mezahavove. ");
INSERT INTO srponstl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ovo su imena Isavovih knezova prema njihovim porodicama i naseobinama: Tamna, Gola, Jetet, ");
INSERT INTO srponstl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Olivema, Ila, Finon, ");
INSERT INTO srponstl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenez, Teman, Mivsar, ");
INSERT INTO srponstl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magedilo i Iram. To su bili edomski knezovi prema svojim naseobinama u zemlji koju su zaposeli. To je Isav, praotac Edomaca. ");
INSERT INTO srponstl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakov je živeo u zemlji gde je njegov otac živeo kao stranac – u zemlji hananskoj. ");
INSERT INTO srponstl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ovo je izveštaj o Jakovljevoj porodici. Josif, mladić od sedamnaest godina, je čuvao stada svoga oca sa sinovima Vale i Zelfe, koje su bile žene njegovog oca. Josif je njihovom ocu podnosio loše izveštaje o njima. ");
INSERT INTO srponstl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Izrailj je Josifa voleo više od svih svojih sinova, jer mu se ovaj rodio pod starost. Zato mu je napravio dugačku odoru s rukavima. ");
INSERT INTO srponstl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Njegova braća su primetila da ga njihov otac više voli nego li ijednog od njih, pa su ga toliko zamrzeli da nisu mogli ni da ga pozdrave. ");
INSERT INTO srponstl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Jednom je Josif usnio san i ispričao ga svojoj braći, zbog čega su ga oni još više zamrzeli. ");
INSERT INTO srponstl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","„Poslušajte, molim vas – rekao je Josif – san koji sam usnio. ");
INSERT INTO srponstl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Vezujemo mi žito u snoplje nasred polja, kad se najednom moj snop digne i uspravi. Uto se vaši snopovi okupe oko moga snopa i duboko mu se poklone.“ ");
INSERT INTO srponstl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Njegova braća mu rekoše: „Da ne misliš da se zacariš nad nama? Da nećeš, možda, da vladaš nad nama?“ Zbog njegovih snova i zbog njegovih reči su ga još više zamrzeli. ");
INSERT INTO srponstl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Josif je usnio još jedan san i ispričao ga svojoj braći: „Evo, usnio sam još jedan san. Sunce, mesec i jedanaest zvezda duboko su mi se poklonili.“ ");
INSERT INTO srponstl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ali, kad je ispričao san svome ocu i svojoj braći, njegov ga otac ukori: „Šta znači taj san koji si usnio? Zar ćemo doći ja, tvoja majka i tvoja braća i do zemlje ti se klanjati?“ ");
INSERT INTO srponstl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Njegova braća su mu zavidela, ali je njegov otac držao celu stvar na umu. ");
INSERT INTO srponstl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Jednom Josifova braća odu da čuvaju ovce svoga oca kod Sihema. ");
INSERT INTO srponstl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Izrailj reče Josifu: „Ne čuvaju li tvoja braća ovce kod Sihema? Hajde da te pošaljem k njima!“ „Dobro“ – odgovori Josif. ");
INSERT INTO srponstl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Otac mu onda reče: „Idi i vidi je li sve u redu s tvojom braćom i ovcama, pa mi javi.“ Tako ga je poslao iz hevronske doline. Josif je stigao u Sihem. ");
INSERT INTO srponstl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Neki čovek ga nađe kako luta po poljima, pa ga upita: „Šta tražiš?“ ");
INSERT INTO srponstl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Josif odgovori: „Tražim svoju braću. Reci mi, molim te, gde čuvaju stado.“ ");
INSERT INTO srponstl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Čovek mu odgovori: „Otišli su odavde. Čuo sam, naime, da su rekli: ’Hajdemo u Dotan!’“ Josif krene za svojom braćom i nađe ih kod Dotana. ");
INSERT INTO srponstl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ugledali su ga iz daljine. No, pre nego što im se približio, oni se dogovore da ga ubiju. ");
INSERT INTO srponstl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Rekli su jedan drugome: „Evo, stiže onaj sanjar. ");
INSERT INTO srponstl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Hajde sad da ga ubijemo i da ga bacimo u neku jamu! Reći ćemo da ga je proždrla divlja zver. Onda ćemo videti šta će biti od njegovih snova.“ ");
INSERT INTO srponstl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kad je to čuo Ruvim, gledao je da ga izbavi iz njihovih ruku, rekavši: „Nemojmo mu oduzimati život! ");
INSERT INTO srponstl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ne prolivajmo njegovu krv – nastavio je – bacite ga u ovu jamu tu u pustinji, ali ne dižite ruku na njega!“ Hteo je da ga tako izbavi iz njihovih ruku i da ga vrati njegovom ocu. ");
INSERT INTO srponstl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kad je Josif stigao k njima, oni svuku njegovu odoru, onu ukrašenu odoru koja je bila na njemu, ");
INSERT INTO srponstl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","pa ga zgrabe i bace u jamu. Jama je bila prazna; nije bilo vode u njoj. ");
INSERT INTO srponstl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Zatim su seli da jedu. Uto podignu pogled i ugledaju karavan Ismailjaca kako dolaze iz Galada. Njihove kamile su nosile mirišljavu smolu, melem, i smirnu. Išli su u Egipat. ");
INSERT INTO srponstl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Tada Juda reče: „Kakvu ćemo korist imati ako ubijemo našeg brata i prikrijemo njegovo ubistvo? ");
INSERT INTO srponstl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Hajde da ga prodamo Ismailjcima! Tako nećemo podići ruke na njega, jer on je, ipak, naš brat, naša krv.“ Njegova braća ga poslušaše. ");
INSERT INTO srponstl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","I kad su tu prolazili neki Madijanski trgovci, oni izvuku i podignu Josifa iz jame i prodaju ga Ismailjcima za dvadeset srebrnjaka, koji ga potom odvedu u Egipat. ");
INSERT INTO srponstl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kad se Ruvim vratio, video je da nema Josifa u jami. Tada je razdro svoju odeću. ");
INSERT INTO srponstl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Zatim se vratio svojoj braći i rekao: „Dečaka nema! Šta ću sad i kuda ću?“ ");
INSERT INTO srponstl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","No, oni uzmu Josifovu odoru, zakolju jedno jare i umoče odoru u krv. ");
INSERT INTO srponstl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Zatim uzmu ukrašenu odoru i donesu je svome ocu. Rekli su mu: „Našli smo ovo. Pogledaj da li je ovo odora tvoga sina ili nije.“ ");
INSERT INTO srponstl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jakov je prepoznao odoru, pa je rekao: „To je odora moga sina! Proždrla ga je divlja zver! Nema sumnje, Josif je rastrgnut na komade!“ ");
INSERT INTO srponstl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jakov je tada razdrao svoju odeću, stavio kostret oko struka, te je dugo vremena oplakivao svoga sina. ");
INSERT INTO srponstl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Svi njegovi sinovi i sve njegove ćerke su se trudili da ga uteše, ali je on odbijao da ga uteše. Govorio je: „Ne! U žalosti ću sići k svome sinu u Svet mrtvih.“ Tako je njegov otac naricao za njim. ");
INSERT INTO srponstl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","A Madijanci prodaju Josifa u Egipat Petefriju, dvoraninu faraonovom, zapovedniku njegove telesne straže. ");
INSERT INTO srponstl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","U to vreme se Juda odselio od svoje braće i nastanio kod Odolamejca po imenu Hira. ");
INSERT INTO srponstl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Tu je Juda zapazio ćerku nekog Hananca koji se zvao Šua, pa ju je uzeo za ženu i legao s njom. ");
INSERT INTO srponstl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ona je zatrudnela i rodila sina, kome je Juda dao ime Ir. ");
INSERT INTO srponstl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ponovo je zatrudnela i rodila sina, kome je dala ime Avnan. ");
INSERT INTO srponstl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Još jednom je rodila sina i dala mu ime Silom. Juda je bio u Hezivu kada ga je rodila. ");
INSERT INTO srponstl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda je oženio svoga prvenca Ira devojkom po imenu Tamara. ");
INSERT INTO srponstl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ali Ir je učinio zlo pred Gospodom, te ga je Gospod pogubio. ");
INSERT INTO srponstl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Tada Juda reče Avnanu: „Lezi s ženom svoga brata i izvrši prema njoj deversku dužnost i podigni potomstvo svome bratu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Znajući da se potomstvo neće računati kao njegovo, Avnan je ispuštao seme na zemlju kad god bi legao sa ženom svoga brata, da ne bi dao potomstvo svome bratu. ");
INSERT INTO srponstl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","To što je učinio bilo je zlo pred Gospodom i zato je Gospod i njega pogubio. ");
INSERT INTO srponstl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Juda reče svojoj snahi Tamari: „Ostani kao udovica u domu svoga oca dok ne odraste moj sin Silom.“ Mislio je, naime: „Samo da ne umre i on kao njegova braća.“ Zato je Tamara otišla da živi u domu svoga oca. ");
INSERT INTO srponstl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Nakon mnogo vremena umre Judina žena, ćerka Šuina. Kad su prošli dani žalosti, Juda ode gore u Timnu da striže ovce sa svojim prijateljem Odolamejcem Hirom. ");
INSERT INTO srponstl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamari jave: „Eno ti svekar ode u Timnu da striže ovce.“ ");
INSERT INTO srponstl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tada Tamara skine udovičko ruho, pokrije lice koprenom i umota se, te sedne na ulazu u Enajim što je na putu za Timnu. Videla je, naime, da je Silom odrastao, ali da mu je nisu dali za ženu. ");
INSERT INTO srponstl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kad ju je Juda ugledao, pomislio je da je bludnica, jer je bila pokrila lice. ");
INSERT INTO srponstl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Svrati on k njoj s puta i reče: „Daj da legnem s tobom.“ Nije znao, naime, da mu je to snaha. Ona mu reče: „Šta ćeš mi dati ako legneš sa mnom?“ ");
INSERT INTO srponstl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","„Poslaću ti jedno jare iz stada“ – odgovori Juda. Ona mu reče: „Može, ako ostaviš zalog dok ga ne pošalješ.“ ");
INSERT INTO srponstl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","„Kakav zalog da ti ostavim?“ – upita on. Ona reče: „Tvoj pečat, vrpcu i štap što ti je u ruci.“ Dao joj je i jedno i drugo. Potom legne s njom i ona zatrudni. ");
INSERT INTO srponstl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Onda je ustala i vratila se; skinula je koprenu s lica i ponovo obukla svoje udovičko ruho. ");
INSERT INTO srponstl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda pošalje jare preko svog prijatelja Odolamejca da otkupi zalog od one žene. No, ovaj je nije našao. ");
INSERT INTO srponstl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Pitao je ljude iz tog mesta: „Gde je hramska bludnica što je bila tu kod puta za Enajim?“ „Ovde nije bilo hramske bludnice“ – rekoše mu. ");
INSERT INTO srponstl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Odolamejac se vrati k Judi i reče: „Nisam je našao. Šta više, ljudi tog mesta su mi rekli da tamo nije bilo hramske bludnice.“ ");
INSERT INTO srponstl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda reče: „Da se ne obrukamo, nek ona zadrži to što ima. Eto, ja sam joj poslao jare, ali je ti nisi našao.“ ");
INSERT INTO srponstl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Oko tri meseca kasnije, jave Judi: „Tvoja snaha Tamara se odala bludničenju, pa je čak i zatrudnela u bludničenju.“ „Izvedite je – naredi Juda – pa neka se spali!“ ");
INSERT INTO srponstl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Dok su je izvodili, ona poruči svome svekru: „Ovo pripada čoveku s kojim sam zatrudnela. Pogledaj, molim te, da li prepoznaješ čiji je ovaj pečatnjak na vrpci i ovaj štap.“ ");
INSERT INTO srponstl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda ih prepozna, pa reče: „Ona je pravednija nego ja, koji je nisam dao svome sinu Silomu.“ I više joj nije pristupao. ");
INSERT INTO srponstl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kad je došlo vreme da rodi, ispostavi se da nosi blizance. ");
INSERT INTO srponstl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Dok se porađala, jedan od njih isturi ruku. Babica uzme njegovu ruku i priveže mu crveni konac oko ruke, rekavši: „Ovaj je izašao prvi.“ ");
INSERT INTO srponstl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ali baš tada on uvuče ruku, pa izađe njegov brat. Babica reče: „Kako li se samo probi?!“ Zato su mu dali ime „Fares“. ");
INSERT INTO srponstl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Potom je izašao njegov brat koji je na ruci imao crveni konac. Njega su nazvali „Zara“. ");
INSERT INTO srponstl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Josifa su doveli u Egipat, gde ga je od Ismailjaca, koji su ga tamo odveli, kupio Egipćanin Petefrije, faraonov dvoranin i zapovednik njegove telesne straže. ");
INSERT INTO srponstl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ali Gospod je bio s Josifom, te mu je sve polazilo za rukom. Zato je živeo u domu svoga gospodara Egipćanina. ");
INSERT INTO srponstl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Njegov gospodar je video da je Gospod s Josifom i da mu Gospod daje uspeh u svemu što radi. ");
INSERT INTO srponstl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tako je Josif zadobio njegovu naklonost, pa ga je postavio za upravitelja svoga doma i poverio mu svu svoju imovinu. ");
INSERT INTO srponstl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Od kako ga je postavio za nadglednika svoga doma i sve svoje imovine, Gospod je zbog Josifa blagoslovio Egipćaninov dom. Gospodnji blagoslov je bio nad svim što je Petefrije imao u kući i na polju. ");
INSERT INTO srponstl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tako je sve što je imao prepustio Josifovoj brizi, tako da nije brinuo ni za šta, osim za hranu koju je jeo. A Josif je bio stasit i naočit mladić. ");
INSERT INTO srponstl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Posle nekog vremena, žena njegovog gospodara baci oko na Josifa, pa mu reče: „Lezi sa mnom!“ ");
INSERT INTO srponstl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ali on to odbi i reče ženi svoga gospodara: „Vidi, od kako sam ja ovde, moj se gospodar ne brine ni o čemu u kući, nego je sve prepustio meni. ");
INSERT INTO srponstl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","On u ovoj kući nema više vlasti od mene; ništa mi nije uskratio osim tebe, jer si njegova žena. Pa kako bih mogao da učinim tako veliko zlo i zgrešim protiv Boga?“ ");
INSERT INTO srponstl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tako je nagovarala Josifa iz dana u dan, ali on nije pristajao ni da legne s njom ni da bude blizu nje. ");
INSERT INTO srponstl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Jednog dana Josif uđe u kuću da radi svoj posao. U kući nije bilo nikoga od slugu. ");
INSERT INTO srponstl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ona tada zgrabi njegov ogrtač i reče mu: „Lezi sa mnom!“ No, Josif ostavi ogrtač u njenoj ruci, te pobegne izjurivši napolje. ");
INSERT INTO srponstl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Kad je videla da je ostavio ogrtač u njenoj ruci i da je izjurio iz kuće, ");
INSERT INTO srponstl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ona pozva sluge i reče im: „Gledajte! Jevrejina nam je doveo da nas ismeva. Došao je tu da legne sa mnom, ali sam ja počela da vičem iz sveg glasa. ");
INSERT INTO srponstl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kad je čuo da sam povisila glas i počela da vičem, ostavio je svoj ogrtač kod mene i pobegao napolje.“ ");
INSERT INTO srponstl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Njegov ogrtač je držala uz sebe dok se njegov gospodar nije vratio kući. ");
INSERT INTO srponstl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Onda je i njemu ispričala istu priču: „Onaj rob Jevrejin koga si nam doveo, došao je k meni da me ismeva. ");
INSERT INTO srponstl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ali kad sam povisila glas i počela da vičem, on je ostavio svoj ogrtač kod mene i pobegao napolje.“ ");
INSERT INTO srponstl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kad je njegov gospodar čuo priču svoje žene, koja mu je rekla: „Eto, tako je sa mnom postupio tvoj rob“, razgnevio se. ");
INSERT INTO srponstl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tada gospodar zgrabi Josifa i baci ga u tamnicu, tamo gde su bili zatvoreni carski zatvorenici. Josif je ostao u tamnici. ");
INSERT INTO srponstl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ipak, Gospod je bio s njim i smilovao mu se, učinivši da Josif stekne naklonost upravitelja tamnice. ");
INSERT INTO srponstl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Upravitelj tamnice je poverio Josifu upravu nad svim zatvorenicima koji su bili u tamnici. ");
INSERT INTO srponstl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Upravitelj tamnice nije nadgledao ništa što je poverio Josifu, jer je s ovim bio Gospod koji mu je davao uspeh u svemu što bi preduzeo. ");
INSERT INTO srponstl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Posle izvesnog vremena, desilo se da su peharnik i pekar egipatskog cara zgrešili nešto protiv svoga gospodara, egipatskog cara. ");
INSERT INTO srponstl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faraon se razljuti na svoja dva dvoranina, na glavnog peharnika i na glavnog pekara, ");
INSERT INTO srponstl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","pa ih stavi u pritvor, u zgradu zapovednika telesne straže, u istu tamnicu gde je Josif bio zatvoren. ");
INSERT INTO srponstl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Zapovednik telesne straže je odredio Josifa da ih poslužuje. U pritvoru su proveli neko vreme. ");
INSERT INTO srponstl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Jedne noći obojica – peharnik i pekar egipatskog cara, koji su bili zatvoreni u tamnici – usnu san. Svaki čovek je usnio svoj san i svaki san je imao svoje značenje. ");
INSERT INTO srponstl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kad je Josif ujutro došao k njima, primetio je da su loše volje. ");
INSERT INTO srponstl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Upitao je tu dvojicu dvoranina koji su bili s njim u pritvoru, u zgradi njegovog gospodara: „Zašto su vam lica smrknuta?“ ");
INSERT INTO srponstl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Oni mu odgovore: „Usnuli smo snove, ali nema nikoga da nam ih protumači.“ Josif im na to reče: „Nije li Bog taj koji daje tumačenje snova? Hajde, ispričajte mi ih.“ ");
INSERT INTO srponstl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Glavni peharnik ispriča svoj san Josifu: „U svome sam snu video čokot loze pred sobom. ");
INSERT INTO srponstl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Na čokotu su bile tri mladice. Tek što je na njima poteralo lišće, mladice se rascvetaju i na njihovim grozdovima dozru zrna. ");
INSERT INTO srponstl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ja sam, pak, u ruci držao faraonov pehar. Onda sam uzeo ono grožđe, iscedio ga u faraonov pehar, i stavio pehar u faraonovu ruku.“ ");
INSERT INTO srponstl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josif mu reče: „Ovo je značenje sna: tri mladice su tri dana. ");
INSERT INTO srponstl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Za tri dana će ti faraon podići glavu i vratiće te u tvoju službu, pa ćeš opet stavljati pehar u faraonovu ruku kao kad si bio njegov peharnik. ");
INSERT INTO srponstl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Seti me se kad ti krene na dobro; budi, molim te, tako ljubazan da me spomeneš faraonu i izvučeš me iz ove tamnice. ");
INSERT INTO srponstl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ja sam, u stvari, silom bio odveden iz zemlje Jevreja, a ni ovde nisam učinio ništa za šta bi me strpali u ovu tamnicu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kad je glavni pekar video da je Josif dobro protumačio san, rekao je Josifu: „I ja sam usnio san: na glavi mi je bilo tri košare belog peciva. ");
INSERT INTO srponstl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","U gornjoj košari je bilo svakojakog peciva za faraona, ali su ga ptice jele iz košare na mojoj glavi.“ ");
INSERT INTO srponstl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josif mu odgovori: „Ovo je tumačenje sna: tri košare su tri dana. ");
INSERT INTO srponstl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nakon tri dana faraon će ti odrubiti glavu; obesiće te na drvo, pa će ptice jesti meso s tebe.“ ");
INSERT INTO srponstl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tako se i desi; trećega dana je bio faraonov rođendan, i on priredi gozbu za sve njegove dvorane. Glavnog peharnika i glavnog pekara je doveo iz tamnice pred svoje dvorane. ");
INSERT INTO srponstl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Glavnog peharnika je vratio u njegovu peharničku službu, te je ponovo stavljao pehar u faraonovu ruku, ");
INSERT INTO srponstl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","a glavnog pekara je obesio – po tumačenju koje im je dao Josif. ");
INSERT INTO srponstl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Međutim, glavni peharnik se nije setio Josifa. Zaboravio ga je. ");
INSERT INTO srponstl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Posle dve pune godine faraon je sanjao: i gle, stoji on kraj Nila. ");
INSERT INTO srponstl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Uto izađe iz Nila sedam lepih i debelih krava. Pasle su među trskom. ");
INSERT INTO srponstl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Međutim, iz Nila za njima izađe sedam drugih krava, ružnih i mršavih, te stanu uz one krave na obali Nila. ");
INSERT INTO srponstl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tada one ružne i mršave krave proždru onih sedam lepih i debelih krava. Tog časa se faraon probudio. ");
INSERT INTO srponstl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kad je zaspao, usnio je drugi san: i gle, sedam punih i jedrih klasova izrastu na jednoj stabljici. ");
INSERT INTO srponstl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","No, odjednom iznikne za njima sedam drugih klasova, šturih i opaljenih istočnim vetrom. ");
INSERT INTO srponstl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Tada onih sedam šturih klasova proždru onih sedam jedrih i punih klasova. Faraon se probudio, ali je shvatio da je i to bio san. ");
INSERT INTO srponstl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ujutro je faraon bio uznemiren, pa je pozvao sve egipatske gatare i mudrace. Faraon im je ispričao svoje snove, ali niko mu ih nije mogao protumačiti. ");
INSERT INTO srponstl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tada glavni peharnik reče faraonu: „Setih se danas mojih pogrešaka ");
INSERT INTO srponstl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","kad se ono faraon razljutio na svoje sluge, pa je bacio mene i glavnog pekara u pritvor, u kući zapovednika telesne straže. ");
INSERT INTO srponstl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Jedne noći smo obojica usnuli po san, i svaki san je imao svoje značenje. ");
INSERT INTO srponstl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tamo je sa nama bio jedan mladić, Jevrejin, rob zapovednika glavne straže. Mi smo mu ispričali naše snove, a on je protumačio i moj i njegov san. ");
INSERT INTO srponstl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Desilo se baš onako kako nam ih je protumačio; ja sam bio vraćen u službu, a onoga su obesili.“ ");
INSERT INTO srponstl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Faraon odmah pošalje po Josifa, te su ga žurno izveli iz tamnice. Nakon što se obrijao i obukao novu odeću, izašao je pred faraona. ");
INSERT INTO srponstl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Faraon reče Josifu: „Usnio sam san, ali ga niko ne može protumačiti. Čuo sam da se priča o tebi da možeš da protumačiš san čim ga čuješ.“ ");
INSERT INTO srponstl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josif odgovori: „Ja ne mogu, ali će Bog dati odgovor faraonu koji će ga umiriti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Faraon reče Josifu: „Sanjao sam da stojim na obali reke Nil, ");
INSERT INTO srponstl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","kad iz Nila izađe sedam debelih i lepih krava. Pasle su među trskom. ");
INSERT INTO srponstl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ali tada za njima izađe sedam drugih krava, jadnih, mršavih i veoma ružnih. U celoj egipatskoj zemlji nisam video tako ružnih krava. ");
INSERT INTO srponstl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tada te mršave i jadne krave proždru onih prvih sedam debelih krava. ");
INSERT INTO srponstl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","No, iako su ih progutale, nije se primećivalo da su im u trbuhu; izgledale su jadno kao i pre. U taj čas se probudim. ");
INSERT INTO srponstl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Zatim sam u snu video kako je na jednoj stabljici izraslo sedam klasova, punih i jedrih. ");
INSERT INTO srponstl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ali posle njih izraste sedam suvih, šturih i istočnim vetrom opaljenih klasova. ");
INSERT INTO srponstl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ti šturi klasovi proždru onih sedam dobrih klasova. Ispričao sam ovo i gatarima, ali niko nije znao da mi odgovori.“ ");
INSERT INTO srponstl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Josif reče faraonu: „Faraonovi snovi su, u stvari, jedan san: Bog ti je objavio šta će učiniti. ");
INSERT INTO srponstl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sedam lepih krava sedam su godina, kao što su i sedam punih klasova sedam godina; to je, dakle, samo jedan san. ");
INSERT INTO srponstl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sedam mršavih i jadnih krava koje su izašle posle njih, kao i onih sedam suvih, šturih i istočnim vetrom opaljenih klasova, su takođe sedam godina. To su sedam godina gladi. ");
INSERT INTO srponstl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","To je ono što sam već rekao faraonu: Bog mu je objavio šta će učiniti. ");
INSERT INTO srponstl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Dolazi, evo, sedam godina velikog obilja za ceo Egipat. ");
INSERT INTO srponstl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Posle njih će doći sedam godina gladi kada će se zaboraviti sve izobilje u Egiptu, jer će glad opustošiti zemlju. ");
INSERT INTO srponstl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Zbog gladi koja će uslediti, niko se neće sećati obilja u zemlji; glad će, naime, biti veoma teška. ");
INSERT INTO srponstl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","A to što se faraonov san ponovio, znači da se Bog čvrsto odlučio na to i da će to ubrzo i učiniti. ");
INSERT INTO srponstl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Zato neka sad faraon potraži razboritog i mudrog čoveka, pa neka ga postavi nad egipatskom zemljom. ");
INSERT INTO srponstl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Neka faraon još postavi nadglednike nad Egiptom da prikupljaju petinu od letine u Egiptu tokom sedam godina obilja. ");
INSERT INTO srponstl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Neka prikupljaju svu hranu tokom onih sedam godina koje dolaze, te neka po faraonovom ovlašćenju skladište žito po gradovima i čuvaju ga za hranu. ");
INSERT INTO srponstl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ta hrana neka služi kao zaliha za zemlju tokom sedam godina gladi koja će zadesiti Egipat, tako da zemlja ne bi propala zbog gladi.“ ");
INSERT INTO srponstl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Josifov odgovor se svideo faraonu i svim njegovim dvoranima. ");
INSERT INTO srponstl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Tada faraon reče svojim dvoranima: „Zar možemo naći čoveka kao što je on, čoveka u kome je Duh Božiji?“ ");
INSERT INTO srponstl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Zatim faraon reče Josifu: „Budući da ti je Bog obznanio sve ovo, nema nikog ko je tako razborit i mudar kao što si ti. ");
INSERT INTO srponstl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ti ćeš biti nadglednik moga doma, te će se sav moj narod pokoravati tvojim naredbama. Jedino ću ja, koji sam na prestolu, imati veću vlast od tebe. ");
INSERT INTO srponstl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Evo, postavljam te nad celom egipatskom zemljom“ – reče faraon. ");
INSERT INTO srponstl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Tada je faraon skinuo pečatni prsten sa svoje ruke i stavio ga na Josifov prst. Zatim ga je obukao u ruho od najboljeg lana, a oko vrata mu je stavio zlatan lanac. ");
INSERT INTO srponstl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Još je naredio da ga provezu kočijama kao njegovog zamenika, a pred njim su uzvikivali: „Na kolena!“ Tako ga je postavio nad celim Egiptom. ");
INSERT INTO srponstl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Uz to mu faraon reče: „Ja sam faraon, niko u celom Egiptu ne sme da makne ruku ili nogu bez tvog odobrenja.“ ");
INSERT INTO srponstl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faraon je Josifa nazvao Safnat-Paneah i dao mu za ženu Asenetu, ćerku Poti-Fere, sveštenika iz Ona. Tako je Josif dobio vlast nad Egiptom. ");
INSERT INTO srponstl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josifu je bilo trideset godina kad je stupio u službu faraona, egipatskog cara. Otišavši od faraona, Josif je obišao celu egipatsku zemlju. ");
INSERT INTO srponstl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Tokom sedam rodnih godina zemlja je obilno rađala. ");
INSERT INTO srponstl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","U tih sedam godina obilja koje su nastale u Egiptu, Josif je prikupljao svaku vrstu hrane i skladištio je po gradovima. Letinu sa okolnih polja je smeštao u svaki grad. ");
INSERT INTO srponstl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Žita koje je Josif prikupio bilo je mnogo kao peska u moru, tako da ga je prestao meriti; nije mu, naime, bilo mere. ");
INSERT INTO srponstl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Pre nego što su nastupile godine gladi, Josifu su se rodila dva sina koje mu je rodila Aseneta, ćerka Poti-Fere, sveštenika u Onu. ");
INSERT INTO srponstl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josif je svome prvencu dao ime „Manasija“, jer je rekao: „Bog mi je dao da zaboravim svu svoju muku i svu rodbinu u domu svoga oca.“ ");
INSERT INTO srponstl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Drugoga je nazvao „Jefrem“, rekavši: „Bog me je učinio rodnim u zemlji moje patnje.“ ");
INSERT INTO srponstl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Kad se navršilo onih sedam godina obilja koje su nastale u Egiptu, ");
INSERT INTO srponstl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","počele su da nastupaju godine gladi, baš kako je Josif i rekao. U svim zemljama je bilo gladi, ali je u celom Egiptu bilo hleba. ");
INSERT INTO srponstl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","A kad je glad zadesila i Egipat, narod zavapi faraonu za hleb. Tada faraon reče svim Egipćanima: „Idite k Josifu i učinite kako vam on kaže!“ ");
INSERT INTO srponstl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nastala je glad po celoj zemlji. I pošto je zavladala žestoka glad u celom Egiptu, Josif je otvorio sva skladišta, pa je prodavao žito Egipćanima. ");
INSERT INTO srponstl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Celi svet je dolazio Josifu u Egipat da kupuje žito, jer je glad bila žestoka po celom svetu. ");
INSERT INTO srponstl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kad je Jakov video da ima žita u Egiptu, rekao je svojim sinovima: „Šta se tu zgledate? ");
INSERT INTO srponstl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Čuo sam, evo, da ima žita u Egiptu. Siđite tamo i kupite nam ga odande, da ostanemo na životu i ne pomremo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tako desetorica Josifove braće siđu da kupe žito u Egiptu. ");
INSERT INTO srponstl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Jakov nije slao Josifovog brata Venijamina s njegovom braćom, misleći da bi mu se mogla desiti kakva nesreća. ");
INSERT INTO srponstl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Sinovi Izrailjevi su bili među onima koji su došli da kupe žito, jer je glad vladala i u hananskoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Josif, koji je bio namesnik nad zemljom, prodavao je žito celom narodu u zemlji. Dođu tako i Josifova braća i poklone mu se licem do zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Josif je prepoznao svoju braću čim ih je video, ali se prema njima držao kao stranac, te im se oštro obratio: „Odakle ste došli?“ Oni odgovore: „Iz hananske zemlje, došli smo da kupimo hranu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josif je, naime, prepoznao svoju braću, ali oni njega nisu prepoznali. ");
INSERT INTO srponstl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tada se Josif setio svojih snova koje je sanjao o njima, pa im je rekao: „Vi ste uhode! Došli ste da izvidite gde je zemlja najslabija.“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Oni odgovoriše: „Ne, gospodaru! Tvoje sluge su došle da kupe hrane. ");
INSERT INTO srponstl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Svi mi smo sinovi jednog čoveka. Tvoje sluge su pošteni ljudi, a ne uhode.“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","„Ne, nego ste uhode – tvrdio je Josif. Došli ste da izvidite gde je zemlja najslabija.“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ali oni mu rekoše: „Nas, tvojih slugu, bilo je dvanaestoro braće. Sinovi smo jednog čoveka u hananskoj zemlji. Eno, najmlađi je sad s našim ocem, a jednoga više nema.“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","No, Josif im je ponovo rekao: „Onako je kako sam rekao: vi ste uhode!“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ovako ću vas proveriti: „Tako mi faraona, nećete otići odavde ako ovamo ne dođe vaš najmlađi brat. ");
INSERT INTO srponstl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Pošaljite jednog od vas da dovede vašeg brata. Vi ostali ćete ostati u pritvoru i biti ispitani da se proveri da li govorite istinu ili ne. Inače, tako mi faraona, vi ste uhode.“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Potom ih je bacio u zatvor na tri dana. ");
INSERT INTO srponstl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Trećeg dana im je rekao: „Ja sam čovek koji se boji Boga. Zato učinite ovo što kažem i ostaćete u životu. ");
INSERT INTO srponstl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ako ste pošteni, neka jedan od vas braće ostane u zatvoru. Vi ostali idite i odnesite žito svojim izgladnelim porodicama. ");
INSERT INTO srponstl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Potom dovedite svog najmlađeg brata, da se potvrdi istinitost vaših reči, te da ne umrete.“ Tako su i učinili. ");
INSERT INTO srponstl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Oni, zatim, rekoše jedan drugome: „Zaista smo krivi zbog našeg brata. Gledali smo njegovu patnju dok nas je molio za milost, ali ga nismo slušali. Zato nas je i snašla ova nevolja.“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruvim im odvrati: „Nisam li vam rekao: ’Ne ogrešujte se o dečaka!’? Ali vi me niste slušali. Evo, sad se traži odgovornost za njegovu krv!“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Oni nisu znali da ih Josif razume, jer je govorio s njima preko prevodioca. ");
INSERT INTO srponstl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Tada se Josif udaljio od njih i zaplakao. Kad se vratio, ponovo je razgovarao s njima. Onda je izdvojio Simeuna između njih i naredio da ga svežu na njihove oči. ");
INSERT INTO srponstl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Josif je, potom, naredio da im napune žito u vreće, da im se vrati njihov novac u vreće, svakome posebno, te da im se da hrana za put. Tako im je i bilo učinjeno. ");
INSERT INTO srponstl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Natovare oni tako žito na svoje magarce i odu. ");
INSERT INTO srponstl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","No, u prenoćištu, jedan od njih otvori svoju vreću da nahrani svog magarca i ugleda svoj novac kako odozgo stoji u vreći. ");
INSERT INTO srponstl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Tada ovaj reče svojoj braći: „Moj novac je vraćen! Evo, tu je u mojoj vreći!“ Njima se oduzme srce. Tresući se, pitali su jedan drugoga: „Šta nam je to Bog uradio?“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kad su došli k svome ocu Jakovu u Hanan, ispričali su mu sve što im se desilo. Rekli su mu: ");
INSERT INTO srponstl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","„Čovek koji je gospodar zemlje je grubo govorio s nama i optužio nas da smo uhode. ");
INSERT INTO srponstl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ali mi smo mu rekli: ’Pošteni smo, nismo uhode. ");
INSERT INTO srponstl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Bilo nas je dvanaestoro braće; sinovi smo jednog oca. Jednoga više nema, a najmlađi je sad sa ocem u Hananu.’ ");
INSERT INTO srponstl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Tada nam je taj čovek, gospodar zemlje, rekao: ’Ovako ću znati da ste pošteni: ostavite jednog brata tu sa mnom, a vi ostali uzmite žito za vaše izgladnele porodice, pa idite. ");
INSERT INTO srponstl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Zatim dovedite svog najmlađeg brata, pa ću znati da niste uhode, nego pošteni ljudi. Tada ću vam vratiti vašeg brata, pa ćete moći da trgujete po zemlji.’“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ali dok su praznili svoje vreće, svaki od njih u svojoj vreći nađe svoju kesu sa novcem. Kad su oni i njihov otac ugledali kese sa novcem, uplašili su se. ");
INSERT INTO srponstl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","„Ostavljate me bez dece! – reče im njihov otac Jakov. Josifa nema, Simeuna nema, a sad i Venijamina hoćete da odvedete. Sve se urotilo protiv mene!“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tada Ruvim reče svome ocu: „Možeš da usmrtiš moja dva sina ako ti ga ne dovedem natrag. Poveri ga meni i ja ću ti ga vratiti.“ ");
INSERT INTO srponstl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ali Jakov reče: „Neće moj sin sići s vama! Njegov brat je mrtav, i on je ostao sam. Ako bi mu se desila nesreća na putu na koji polazite, onda biste moju sedu glavu u tuzi svalili u Svet mrtvih.“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Vladala je žestoka glad u zemlji. ");
INSERT INTO srponstl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kad su pojeli žito koje su doneli iz Egipta, reče im njihov otac: „Idite i kupite nam malo žita.“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Juda mu na to reče: „Onaj čovek nas je izričito upozorio: ’Ne izlazite mi na oči ako vaš brat ne bude s vama.’ ");
INSERT INTO srponstl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ako si spreman da pošalješ našeg brata s nama, mi ćemo sići i kupićemo ti hrane. ");
INSERT INTO srponstl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","A ako nećeš da ga pošalješ, ni mi nećemo ići, jer nam je onaj čovek rekao: ’Ne izlazite mi na oči ako vaš brat ne bude sa vama.’“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Izrailj im reče: „Zašto ste mi naneli bol rekavši tom čoveku da imate još jednog brata?“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Oni mu odgovoriše: „Taj čovek nas je pomno ispitivao o nama i o našoj porodici. Pitao je: ’Da li vam je otac još uvek živ? Imate li još kojeg brata?’ Mi smo mu odgovorili na pitanja. Kako smo mogli znati da će reći: ’Dovedite svoga brata’?“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Tada Juda reče svome ocu, Izrailju: „Pošalji dečaka sa mnom, pa da se spremimo i idemo, da ostanemo na životu i ne pomremo – ni mi, ni ti, ni naša deca. ");
INSERT INTO srponstl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ja jamčim za njega; mene smatraj odgovornim za njega. Ako ga ne vratim tebi i ne postavim ga pred tebe, neka sam ti kriv do veka. ");
INSERT INTO srponstl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Da nismo toliko oklevali, do sad bismo se već dva puta vratili.“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Njihov otac, Izrailj, im reče: „Kad je tako, neka bude. Ali, učinite ovo: ponesite u svoje torbe najbolje proizvode zemlje pa odnesite na dar onom čoveku: malo melema, malo meda i začina, te nešto smirne, pistacije i badema. ");
INSERT INTO srponstl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Sa sobom ponesite i dvostruko više novca, jer morate vratiti novac koji je stavljen odozgo u vaše vreće. Možda je bila greška. ");
INSERT INTO srponstl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Povedite i svoga brata, pa se spremite i vratite se onom čoveku. ");
INSERT INTO srponstl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Neka Bog Svemoćni učini da vam se onaj čovek smiluje, te vam pusti i drugog brata i Venijamina. A ako treba da ostanem bez dece, neka ostanem.“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Tako oni uzmu dar i dvostruko više novca, te povedu Venijamina. Onda se spreme i odu u Egipat, pa stupe pred Josifa. ");
INSERT INTO srponstl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kad ih je Josif video sa Venijaminom, rekao je upravitelju svoga doma: „Odvedi ove ljude u kuću, a potom zakolji jedno živinče i prigotovi ga, jer će oni obedovati sa mnom u podne.“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Sluga učini kako mu je Josif rekao, te ih je odveo u Josifovu kuću. ");
INSERT INTO srponstl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ljudi su se uplašili kad su bili dovedeni u Josifovu kuću. Mislili su: „Dovedeni smo ovde zbog novca koji nam se našao u vrećama prvi put. Sada će nas napasti i svladati, pa će nas uzeti za robove zajedno s našim magarcima.“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kad su bili na ulazu u kuću, oni pristupe upravitelju Josifovog doma i ");
INSERT INTO srponstl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","obrate mu se: „O, gospodaru! Mi smo tu već jednom dolazili da kupimo hrane. ");
INSERT INTO srponstl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ali kad smo došli u prenoćište, otvorili smo naše vreće i tamo je bio naš novac. Svaki od nas je, u svojoj vreći, odozgo, zatekao svoj novac, istu svotu. Evo, doneli smo ga sa sobom. ");
INSERT INTO srponstl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Sa sobom smo poneli još novca da kupimo hrane. Ne znamo ko nam je stavio novac u naše vreće.“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","„Budite spokojni! – reče im upravitelj. Ne plašite se! Vaš Bog i Bog vašeg oca je stavio blago u vaše vreće. Vaš novac je stigao k meni.“ Potom im je izveo Simeuna. ");
INSERT INTO srponstl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kad ih je doveo u Josifovu kuću, upravitelj im je dao vode da operu noge, a njihovim magarcima je dao hranu. ");
INSERT INTO srponstl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Zatim su pripremili dar da dočekaju Josifa kad stigne u podne, jer su čuli da će tamo ručati. ");
INSERT INTO srponstl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kad je Josif došao u kuću, oni mu donesu darove koji su poneli sa sobom i poklone mu se do zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Josif ih je upitao za zdravlje, i nastavio: „A je li zdrav vaš stari otac o kome ste mi govorili? Da li je još živ?“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","„Tvoj sluga, naš otac, još uvek je živ i u dobrom je zdravlju“ – odgovore oni i duboko mu se poklone. ");
INSERT INTO srponstl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Podigavši pogled, Josif opazi svoga brata Venijamina, sina svoje majke, pa upita: „Da li je ovo vaš najmlađi brat o kome ste mi pričali?“ Onda doda: „Neka ti Bog podari milost, sine moj!“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Josif se od samilosti potresao videvši svoga brata, pa je žurno izašao napolje tražeći gde da se isplače. Ušao je u jednu sobu i tamo se isplakao. ");
INSERT INTO srponstl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Onda se umio i izašao. Sabravši se, naredio je: „Neka se posluži ručak!“ ");
INSERT INTO srponstl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Josifu su služili ručak odvojeno, njima su služili odvojeno, i Egipćanima koji su jeli s njima su takođe služili odvojeno. Egipćani, naime, ne jedu sa Jevrejima, jer je to za njih odvratno. ");
INSERT INTO srponstl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Pred njim su sedeli po svojoj starosti, od prvorođenca do najmlađeg, na šta su se oni gledali u čudu. ");
INSERT INTO srponstl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Obroci su im se donosili s njegovog stola. Međutim, Venijaminov obed je bio pet puta veći. Tako su pili i gostili se s njim. ");
INSERT INTO srponstl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Josif naredi upravitelju svoga doma: „Napuni vreće ovih ljudi hranom onoliko koliko mogu poneti, a novac svakoga od njih stavi odozgo u njegovu vreću. ");
INSERT INTO srponstl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","A moj pehar, onaj srebrni pehar, stavi odozgo u vreću najmlađega zajedno s njegovim novcem za žito.“ Upravitelj učini onako kako mu je Josif rekao. ");
INSERT INTO srponstl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kad je svanulo jutro, otpremili su ljude i njihove magarce. ");
INSERT INTO srponstl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Oni još nisu bili otišli daleko od grada, kad Josif reče upravitelju svoga doma: „Ustani i pođi za onim ljudima. Kad ih stigneš, reci im: ’Zašto uzvraćate zlo za dobro? ");
INSERT INTO srponstl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Zar da ukradete pehar iz kog moj gospodar pije i iz kog čita budućnost? Učinili ste zlo!’“ ");
INSERT INTO srponstl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kad ih je stigao, rekao im je te reči. ");
INSERT INTO srponstl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Oni mu rekoše: „Zašto moj gospodar govori takve reči? Daleko bilo od tvojih slugu da učine takvu stvar! ");
INSERT INTO srponstl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Čak i novac koji smo našli odozgo u našim vrećama smo ti vratili iz hananske zemlje. Kako bismo, onda, mogli da ukrademo srebro ili zlato iz kuće tvoga gospodara? ");
INSERT INTO srponstl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","A ako kod nekog od tvojih slugu nađeš ono što pripada tvome gospodaru, taj će umreti, a mi ostali ćemo postati robovi tvome gospodaru.“ ");
INSERT INTO srponstl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","„U redu, neka bude kako ste rekli – složio se upravitelj. Ipak, samo onaj kod koga se pronađe pehar će mi biti rob. Vi ostali ćete biti bez krivice.“ ");
INSERT INTO srponstl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Brže-bolje su spustili svoje vreće na zemlju, te je svaki od njih otvorio svoju. ");
INSERT INTO srponstl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Upravitelj je pretraživao od najstarijeg pa do najmlađeg. Pehar je pronađen u Venijaminovoj vreći. ");
INSERT INTO srponstl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Na to oni razderu svoju odeću. Onda svaki natovari svog magarca, pa se vrate u grad. ");
INSERT INTO srponstl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Josif je još bio tamo kad su Juda i njegova braća stigla. Oni se bace pred njim na zemlju. ");
INSERT INTO srponstl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Josif im reče: „Šta ste to učinili? Zar niste znali da čovek kao ja otkriva budućnost?“ ");
INSERT INTO srponstl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda odgovori: „Šta možemo reći mome gospodaru? Šta da kažemo? Čime da se opravdamo? Bog je otkrio krivicu tvojih slugu. Evo nas, robovi smo moga gospodara, i mi i onaj kod koga je pehar nađen.“ ");
INSERT INTO srponstl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","„Daleko bilo od mene da učinim tako nešto! – reče Josif. Samo onaj kod koga je pehar nađen će biti moj rob. Vi ostali se mirno vratite svome ocu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Juda mu je tada pristupio i rekao: „Moj gospodaru, dozvoli svome sluzi da ti se obrati. Ne gnevi se na tvoga slugu, jer ti si kao faraon. ");
INSERT INTO srponstl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Moj gospodar je pitao svoje sluge: ’Imate li oca ili brata?’ ");
INSERT INTO srponstl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","A mi smo odgovorili mome gospodaru: ’Imamo starog oca i brata koji se rodio ocu pod starost. Taj je najmlađi. Njegov pravi brat je umro, tako da je on jedini ostao od svoje majke. Otac ga mnogo voli.’ ");
INSERT INTO srponstl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ti si zatim rekao: ’Dovedite ga k meni da ga vidim svojim očima!’ ");
INSERT INTO srponstl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","A mi smo ti odgovorili: ’Dečak ne može da napusti oca; ako ga ostavi, otac će umreti.’ ");
INSERT INTO srponstl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ali ti si rekao svojim slugama: ’Ako vaš najmlađi brat ne dođe s vama, ne izlazite mi na oči.’ ");
INSERT INTO srponstl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kad smo se vratili tvome sluzi, našem ocu, preneli smo mu reči moga gospodara. ");
INSERT INTO srponstl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Na to je naš otac rekao: ’Vratite se i kupite nam nešto hrane.’ ");
INSERT INTO srponstl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Mi smo mu rekli: ’Ne možemo da idemo tamo. Ići ćemo samo ako naš najmlađi brat pođe s nama. Ako on ne bude bio s nama, tom čoveku nećemo moći da izađemo na oči.’ ");
INSERT INTO srponstl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tvoj sluga, naš otac, nam je tada rekao: ’Vi znate da mi je moja žena rodila dva sina. ");
INSERT INTO srponstl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Jedan me je već napustio. Tada sam mislio: sigurno je rastrgnut! Od tada ga više nisam video. ");
INSERT INTO srponstl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ako i ovoga odvedete od mene, te i njega zadesi nesreća, s tugom ćete svaliti moju sedu glavu u Svet mrtvih.’ ");
INSERT INTO srponstl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Stoga, ako dečak ne bude s nama kad se vratim tvome sluzi, mome ocu – kome je dečak toliko prirastao srcu – ");
INSERT INTO srponstl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","presvisnuće kad vidi da dečaka nema sa nama. Tako će tvoje sluge s tugom svaliti u Svet mrtvih sedu glavu tvoga sluge, našeg oca. ");
INSERT INTO srponstl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","A ja, tvoj sluga, jemčio sam svom ocu za mladića, rekavši: ’Ako ti ga ne dovedem, nek budem kriv svome ocu do veka!’ ");
INSERT INTO srponstl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Zato te molim da tvoj sluga ostane kao rob kod moga gospodara umesto dečaka, a dečak neka se vrati sa svojom braćom. ");
INSERT INTO srponstl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Jer, kako da pođem gore svome ocu ako dečak ne bude sa mnom? Ne bih mogao da gledam jad koji bi shrvao moga oca.“ ");
INSERT INTO srponstl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Josif nije mogao više da se uzdržava pred svojim slugama, pa je povikao: „Neka svi izađu!“ Pošto niko od njegovih ljudi nije ostao s njim, Josif se otkrio svojoj braći. ");
INSERT INTO srponstl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Tada je glasno zaplakao, tako da su ga i Egipćani čuli. Čak je i faraonov dom dočuo za to. ");
INSERT INTO srponstl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","„Ja sam Josif! – rekao je svojoj braći. Je li moj otac zaista još živ?“ Njegova braća nisu mogla da odgovore svome bratu; bili su potpuno uplašeni pred njim. ");
INSERT INTO srponstl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Josif je zatim rekao svojoj braći: „Priđite k meni.“ Kad su prišli, rekao im je: „Ja sam vaš brat, Josif, koga ste prodali u Egipat. ");
INSERT INTO srponstl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","No, sada se nemojte žalostiti i gneviti na sebe što ste me prodali ovde. Bog me je, naime, poslao pred vama da vas održi u životu. ");
INSERT INTO srponstl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Već su dve godine od kako je glad u zemlji, a još pet godina neće biti ni oranja ni žetve. ");
INSERT INTO srponstl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Bog me je poslao pred vama da vam sačuvam potomstvo na zemlji i da vas održim u životu velikim izbavljenjem. ");
INSERT INTO srponstl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Stoga, niste me vi ovde poslali, nego Bog. On me je postavio faraonu za glavnog savetnika, za upravitelja celog njegovog doma, te za gospodara nad celim Egiptom. ");
INSERT INTO srponstl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Zato se brzo vratite mome ocu, pa mu recite: ’Tvoj sin Josif ti poručuje: Bog me je postavio za gospodara nad celim Egiptom. Zato dođi k meni, ne oklevaj! ");
INSERT INTO srponstl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nastanićeš se u kraju Gosenu, pa ćeš mi biti blizu: ti, tvoji sinovi, tvoji unuci, tvoje ovce i goveda, i sva tvoja imovina. ");
INSERT INTO srponstl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ja ću se tamo brinuti za tebe, jer glad će trajati još pet godina. Tako nećeš gladovati ni ti, ni tvoja porodica niti stoka što ti pripada.’ ");
INSERT INTO srponstl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Evo, vidite i svojim očima, kao što vidi i moj brat Venijamin, da sam to ja koji vam govorim. ");
INSERT INTO srponstl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ispričajte ocu o svoj mojoj slavi u Egiptu i o svemu što ste videli. Požurite i dovedite ovamo moga oca!“ ");
INSERT INTO srponstl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Onda je pao svome bratu Venijaminu oko vrata i zaplakao. Venijamin je takođe plakao zagrlivši Josifa. ");
INSERT INTO srponstl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Potom je plačući izljubio i svu ostalu braću. Posle toga su braća razgovarala. ");
INSERT INTO srponstl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Vest se pročula i na faraonovom dvoru: „Došla su Josifova braća!“ To je bilo drago faraonu i njegovim dvoranima. ");
INSERT INTO srponstl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faraon reče Josifu: „Reci svojoj braći ovako: ’Natovarite vašu stoku i idite u hanansku zemlju, ");
INSERT INTO srponstl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","pa povedite svoga oca i vratite se k meni. Ja ću vam dati najbolju zemlju u Egiptu, pa ćete se hraniti od obilja zemlje.’ ");
INSERT INTO srponstl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ti nadalje naredi: ’Učinite ovo: uzmite kola iz egipatske zemlje za vašu decu i za vaše žene, povedite svoga oca i dođite ovamo. ");
INSERT INTO srponstl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ne žalite za svojom imovinom, jer vama pripada najbolja zemlja u Egiptu.’“ ");
INSERT INTO srponstl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Sinovi Izrailjevi tako i učine. Po faraonovoj naredbi im je dao kola i hranu za put. ");
INSERT INTO srponstl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Svakome od njih je dao novu odeću, a Venijaminu je dao tri stotine srebrnjaka i pet pari nove odeće. ");
INSERT INTO srponstl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A svome ocu je poslao deset magaraca natovarenih najboljim proizvodima Egipta, te deset magarica natovarenih žitom, hlebom i namirnicama ocu za put. ");
INSERT INTO srponstl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Zatim je poslao svoju braću. Dok su odlazili, rekao im je: „Ne svađajte se putem!“ ");
INSERT INTO srponstl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Pođu oni tako gore iz Egipta i dođu svome ocu Jakovu u Hanan. ");
INSERT INTO srponstl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Zatim ga izveste: „Josif je još uvek živ! Šta više, on je vladar nad celom egipatskom zemljom.“ Jakovu se sledilo srce; nije mogao da im poveruje. ");
INSERT INTO srponstl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ali kad su mu preneli sve što im je Josif rekao i kad je video kola koja je Josif poslao da ga dovezu, živnuo je duh njihovog oca Jakova. ");
INSERT INTO srponstl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Tada Izrailj reče: „To je dovoljno! Moj sin, Josif, je još uvek živ! Otići ću da ga vidim pre nego što umrem.“ ");
INSERT INTO srponstl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tako se Izrailj dao na put sa svom svojom imovinom. Kad je došao u Vir-Saveju, prineo je žrtve Bogu svoga oca, Isaka. ");
INSERT INTO srponstl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","U noćnom viđenju, Bog zovnu Izrailja: „Jakove! Jakove!“ On se odazva: „Evo me!“ ");
INSERT INTO srponstl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","„Ja sam – reče – Bog tvoga oca. Ne boj se da siđeš u Egipat, jer ću tamo od tebe učiniti veliki narod. ");
INSERT INTO srponstl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ja ću sići s tobom u Egipat i ja sam ću te vratiti ovamo; a Josif će ti svojom rukom sklopiti oči.“ ");
INSERT INTO srponstl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jakov ode iz Vir-Saveje. Izrailjevi sinovi smestiše svoga oca, Jakova, svoju decu i svoje žene u kola koja je faraon poslao da ga povezu. ");
INSERT INTO srponstl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Sa sobom povedu svoju stoku i svoja dobra što su ih stekli u hananskoj zemlji, pa dođu u Egipat, Jakov i sve njegovo potomstvo. ");
INSERT INTO srponstl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","U Egipat je poveo svoje sinove, svoje unuke, svoje ćerke i ćerke svojih sinova, sve svoje potomstvo. ");
INSERT INTO srponstl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ovo su imena Izrailjevih sinova koji su otišli za Egipat – Jakov i njegovi potomci: Jakovljev prvenac Ruvim. ");
INSERT INTO srponstl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruvimovi sinovi: Enoh, Faluj, Esron i Harmija. ");
INSERT INTO srponstl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeunovi sinovi su: Jemuilo, Jamin, Aod, Jakin, Cohar i Saul, sin Hananke. ");
INSERT INTO srponstl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levijevi sinovi su: Girson, Kat i Merarije. ");
INSERT INTO srponstl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judini sinovi su: Ir, Avnan, Silom, Fares i Zara. Ir i Avnan su umrli u Hananu. Faresovi sinovi su bili: Esron i Jemuilo. ");
INSERT INTO srponstl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaharovi sinovi su: Tola, Fuva, Jov i Simron. ");
INSERT INTO srponstl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sinovi Zavulonovi su: Sared, Alon i Alilo. ");
INSERT INTO srponstl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","To su sinovi koje je Lija rodila Jakovu u Padan-Aramu i ćerku Dinu. Ukupno trideset tri potomaka. ");
INSERT INTO srponstl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadovi sinovi su: Sifjon, Agije, Sunije, Esvon, Irije, Arodije i Arilije. ");
INSERT INTO srponstl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asirovi sinovi su: Jemna, Jesva, Jesvija, Verija i njihova sestra Sera. Verijini sinovi su: Hever i Melhil. ");
INSERT INTO srponstl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","To su potomci Zelfe koju je Lavan dao svojoj ćerki Liji. Ona je rodila Jakovu njih šesnaest. ");
INSERT INTO srponstl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ovo su sinovi Jakovljeve žene Rahilje: Josif i Venijamin. ");
INSERT INTO srponstl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Josifu su se u Egiptu rodili Manasija i Jefrem. Njih mu je rodila Aseneta, ćerka Poti-Fere, sveštenika iz Ona. ");
INSERT INTO srponstl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Venijaminovi sinovi su: Vela, Veher, Asvil, Gira, Naman, Ihije, Ros, Mupim, Upim i Arad. ");
INSERT INTO srponstl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","To su Rahiljini potomci koje je rodila Jakovu. Ukupno četrnaest duša. ");
INSERT INTO srponstl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Danov je sin Asom. ");
INSERT INTO srponstl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Neftalimovi sinovi su: Jasil, Gunije, Jeser i Selim. ");
INSERT INTO srponstl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","To su sinovi Vale koju je Lavan dao svojoj ćerki Rahilji. Ona je rodila Jakovu njih sedam. ");
INSERT INTO srponstl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Svih onih koji su sa Jakovom otišli u Egipat, onih koji od njega potiču, ne uključujući žene Jakovljevih sinova, bilo je šezdeset šest. ");
INSERT INTO srponstl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Josifu su se rodila dva sina u Egiptu. Dakle, svih duša u Jakovljevom domu bilo je sedamdeset. ");
INSERT INTO srponstl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jakov je pred sobom poslao Josifu Judu da pokaže put do Gosena. Kad su stigli u gosenski kraj, ");
INSERT INTO srponstl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josif upregne svoja kola, pa pođe u susret svome ocu, Izrailju, u Gosen. Kada se pojavio pred njim, obisnuo mu se oko vrata i dugo plakao. ");
INSERT INTO srponstl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Izrailj reče Josifu: „Sad mogu da umrem, jer sam video tvoje lice, te znam da si još živ!“ ");
INSERT INTO srponstl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Tada Josif reče svojoj braći i domu svoga oca: „Ja ću sada otići i obavestiti faraona: ’Moja braća i dom moga oca, koji su bili u hananskoj zemlji, došli su k meni. ");
INSERT INTO srponstl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Oni su pastiri, bave se stočarstvom. Doterali su sa sobom sitnu i krupnu stoku, zajedno sa svim svojim imanjem.’ ");
INSERT INTO srponstl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kad vas faraon pozove i upita: ’Čime se bavite?’, ");
INSERT INTO srponstl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","vi recite: ’Tvoje sluge se bave stočarstvom od svoje mladosti pa sve do sad, isto kao i naši preci’, da biste mogli da se naselite u gosenskom kraju. Naime, Egipćanima su svi pastiri mrski.“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Josif ode i obavesti faraona: „Došli su moj otac i moja braća sa svojom krupnom i sitnom stokom i sa svom svojom imovinom iz Hanana. Eno ih u gosenskom kraju.“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Zatim je izdvojio petoricu između svoje braće i predstavio ih faraonu. ");
INSERT INTO srponstl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","„Čime se bavite?“ – upitao je faraon njegovu braću. „Tvoje sluge su pastiri, isto kao i naši preci“ – odgovore oni ");
INSERT INTO srponstl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","i nastave: „Došli smo da se zadržimo u zemlji kao stranci, jer nema više paše za stada tvojih slugu. Teška glad je zavladala u hananskoj zemlji. Stoga, dopusti svojim slugama da se nastane u gosenskom kraju.“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faraon reče Josifu: „Tvoj otac i tvoja braća su došli k tebi. ");
INSERT INTO srponstl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Egipatska zemlja ti je otvorena; nastani svoga oca i svoju braću u najboljem delu zemlje. Nastanite se u gosenskom kraju. Ako znaš da među njima ima sposobnih ljudi, postavi ih za nadglednike moje vlastite stoke.“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Zatim Josif dođe sa svojim ocem, Jakovom, i predstavi ga faraonu, a Jakov blagoslovi faraona. ");
INSERT INTO srponstl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faraon upita Jakova: „Koliko ti je godina?“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakov odgovori faraonu: „Godina mog lutalačkog života ima stotinu trideset. Neznatan je broj godina moga života, a bile su mukotrpne; brojem nisu dostigle godine lutalačkog života mojih otaca.“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jakov je blagoslovio faraona, pa je otišao od njega. ");
INSERT INTO srponstl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Josif je naselio svoga oca i svoju braću i dao im posed u najboljem delu egipatske zemlje, u Ramesinoj Krajini, kao što je faraon naredio. ");
INSERT INTO srponstl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josif je snabdevao hranom svoga oca, svoju braću i sav dom svoga oca, prema broju njihove dece. ");
INSERT INTO srponstl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Hrane nije bilo u celoj zemlji, jer je glad bila žestoka: iscrpila je i egipatsku i hanansku zemlju. ");
INSERT INTO srponstl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Josif je pokupio sav novac što se nalazio u Egiptu i Hananu u zamenu za žito koje se kupovalo i odneo ga u faraonov dvor. ");
INSERT INTO srponstl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kad je novca ponestalo u egipatskoj i hananskoj zemlji, svi Egipćani dođu k Josifu, i obrate mu se: „Daj nam hleba! Zašto da pomremo pred tvojim očima? Novca više nema!“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Josif im odgovori: „Pošto novca više nema, doterajte svoju stoku i ja ću vam dati hrane u zamenu za stoku.“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tako su doterali svoju stoku Josifu, a ovaj im je dao hrane u zamenu za konje, za krupnu i sitnu stoku, za goveda i magarce. Te godine ih je snabdevao hranom u zamenu za svu njihovu stoku. ");
INSERT INTO srponstl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ta godina je prošla. Naredne godine su ponovo došli k njemu i rekli mu: „Ne možemo sakriti od svoga gospodara da je nestalo novca, a sva naša stada stoke sada pripadaju našem gospodaru. Nije nam ostalo ništa za našeg gospodara osim naših vlastitih tela i zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Zašto da pomremo pred tvojim očima i da se naša polja pretvore u pustoš? Kupi nas i naša polja u zamenu za hranu. Tako ćemo mi i naša polja postati faraonovo vlasništvo. Daj nam seme da ne pomremo nego da preživimo i da se naša polja ne pretvore u pustoš!“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tako je Josif otkupio za faraona celu egipatsku zemlju. Svi Egipćani su prodali svoje njive, jer ih je glad žestoko pritisla. Tako je zemlja postala faraonovo vlasništvo. ");
INSERT INTO srponstl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","A narod je, od jednog kraja Egipta do drugog, stavio pod upravu gradova. ");
INSERT INTO srponstl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Jedino nije otkupio njive sveštenika, jer su sveštenici dobijali prihod od faraona i živeli od tog prihoda koji im je faraon davao. Iz tog razloga nisu prodali svoje njive. ");
INSERT INTO srponstl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Josif reče narodu: „Pošto sam danas kupio i vas i vašu zemlju za faraona, evo vam seme, pa zasejte zemlju. ");
INSERT INTO srponstl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Faraonu ćete davati jednu petinu od uroda, a četiri petine će ostati vama za sejanje njiva, za hranu vama, vašim ukućanima i vašoj deci.“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Oni na to rekoše: „Spasio si nam život! Samo neka nam bude blagonaklon naš gospodar i bićemo robovi faraonu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Josif je doneo zakon po kome jedna petina zemlje pripada faraonu. Taj zakon o zemlji u Egiptu važi sve do danas. Jedino svešteničke njive ne pripadaju faraonu. ");
INSERT INTO srponstl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Izrailj se nastanio u Egiptu, u gosenskom kraju. Tu su stekli vlasništvo nad zemljom; bili su plodni i veoma se umnožili. ");
INSERT INTO srponstl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakov je živeo sedamnaest godina u egipatskoj zemlji. Ukupna dužina Jakovljevog života je iznosila stotinu četrdeset sedam godina. ");
INSERT INTO srponstl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kad se približilo vreme da Izrailj umre, pozvao je svoga sina Josifa i rekao mu: „Ako hoćeš da mi iskažeš svoju naklonost, stavi ruku pod moje bedro i obećaj da ćeš mi iskazati blagonaklonost i odanost. Nemoj me sahraniti u Egiptu! ");
INSERT INTO srponstl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kad budem počinuo sa svojim precima, odnesi me iz Egipta i sahrani me u njihovom grobu.“ A on mu odgovori: „Uradiću kako si rekao.“ ");
INSERT INTO srponstl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Rekao mu je: „Zakuni mi se.“ Josif mu se zakleo a Izrailj mu se duboko poklonio na uzglavlju svoje postelje. ");
INSERT INTO srponstl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nakon ovih događanja, jave Josifu: „Otac ti se razboleo.“ Nato je Josif poveo svoja dva sina, Manasiju i Jefrema. ");
INSERT INTO srponstl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kad su Jakovu rekli: „Evo, došao ti je tvoj sin Josif“, Izrailj je prikupio snagu i seo na postelju. ");
INSERT INTO srponstl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakov reče Josifu: „Bog Svemoćni objavio mi se u Luzu, u hananskoj zemlji, i blagoslovio me. ");
INSERT INTO srponstl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Rekao mi je: ’Evo, učiniću te rodnim i brojnim, te učiniti da od tebe nastane skup naroda. A ovu zemlju daću tvome potomstvu posle tebe u večni posed.’ ");
INSERT INTO srponstl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Sada će tvoja dva sina, Jefrem i Manasija, koja su ti se rodila u Egiptu pre nego što sam došao k tebi, biti moji kao što su moji Ruvim i Simeun. ");
INSERT INTO srponstl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Potomci koji su ti se rodili posle njih biće tvoji. Oni će primiti svoje nasledstvo na ime svoje braće. ");
INSERT INTO srponstl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Dok sam se vraćao iz Padana, na putu mi umre Rahilja, u hananskoj zemlji, na domak Efrate. Sahranio sam je tamo, uz put za Efratu, sadašnji Vitlejem.“ ");
INSERT INTO srponstl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Kad je Izrailj video Josifove sinove, upitao je: „Ko su ovi?“ ");
INSERT INTO srponstl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","„To su moji sinovi koje mi je Bog dao ovde“ – odgovori Josif svome ocu. Izrailj reče: „Privedi mi ih da ih blagoslovim.“ ");
INSERT INTO srponstl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Izrailju su, naime, oči bile oslabile od starosti, pa nije video. Kad ih je priveo, Izrailj ih je poljubio i zagrlio. ");
INSERT INTO srponstl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Izrailj zatim reče Josifu: „Nisam se nadao da ću ikada više videti tvoje lice, a evo, Bog mi je dao da vidim i tvoje potomke.“ ");
INSERT INTO srponstl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Josif ih je tada skinuo sa njegovih kolena i poklonio mu se licem do zemlje. ");
INSERT INTO srponstl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Zatim Josif uzme svoja dva sina, Jefrema svojom desnicom, Izrailju s leva, a Manasiju svojom levicom, Izrailju s desna, pa mu ih primakne. ");
INSERT INTO srponstl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Međutim, Izrailj pruži svoju desnicu i položi je na Jefremovu glavu, a svoju levicu na Manasijinu, držeći ruke unakrst, iako je Manasija bio prvenac. ");
INSERT INTO srponstl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Potom je blagoslovio Josifa, rekavši: „Bog, čije su puteve sledili preci moji, Avraham i Isak, Bog koji je bio moj Pastir od mladosti moje, pa sve do danas, ");
INSERT INTO srponstl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Anđeo koji me je od svakog zla izbavljao, mladiće ove neka blagoslovi. Neka se po njima spominje ime moje i ime predaka mojih, Avrahama i Isaka. Po zemlji neka im se potomstvo razmnoži.“ ");
INSERT INTO srponstl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Kad je Josif video da je njegov otac položio svoju desnu ruku na Jefremovu glavu, nije mu bilo pravo. Zato je posegnuo za očevom rukom da je premesti sa Jefremove glave na Manasijinu glavu. ");
INSERT INTO srponstl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Rekao je svome ocu: „Ne tako, oče moj! Položi svoju ruku na glavu ovog drugog, jer je on prvenac.“ ");
INSERT INTO srponstl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Njegov otac je to odbio, rekavši: „Znam, sine moj, znam. Od njega će, takođe, nastati narod, i to veliki narod. Ipak, njegov mlađi brat će biti veći od njega, i njegovo potomstvo će postati mnoštvo naroda.“ ");
INSERT INTO srponstl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tog dana ih je blagoslovio, rekavši: „Tvojim će imenom blagosiljati Izrailj. Govoriće se: ’Neka ti Bog učini onako kako je učinio Jefremu i Manasiji!’“ Tako je Jefremu dodelio prvenaštvo nad Manasijom. ");
INSERT INTO srponstl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Izrailj zatim reče: „Evo, uskoro ću umreti, ali Bog će biti s vama i on će vas vratiti u zemlju vaših otaca. ");
INSERT INTO srponstl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Tebi dajem i Sihem, deo više nego tvojoj braći, koji sam lukom i mačem osvojio od Amorejaca.“ ");
INSERT INTO srponstl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jakov zatim pozva svoje ostale sinove i reče: „Okupite se da vam kažem šta će se zbiti sa vama u poslednjim danima. ");
INSERT INTO srponstl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Okupite se i čujte, sinovi Jakovljevi, čujte oca svoga Izrailja. ");
INSERT INTO srponstl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruvime, prvenče moj, ti si moja snaga, prvi plod si moje muževnosti. Dostojanstvom druge nadmašuješ, a po snazi ravna ti nema. ");
INSERT INTO srponstl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ipak, neobuzdan kao bujica, ti prvenac nećeš više biti. Jer na ležaj svoga oca si se popeo, na postelju si se moju popeo i tako je oskrnavio. ");
INSERT INTO srponstl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeun i Levije braća su rođena, mačevi njihovi oruđe su nasilja. ");
INSERT INTO srponstl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Na većanja njihova ja ne silazio, niti u savez sa njima ulazio. Jer u srdžbi ljude su pobili, iz obesti volove sakatili. ");
INSERT INTO srponstl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Proklet bio gnev njihov jer je prežestok, i jarost njihova, jer je preokrutna! Zato ću ih razdeliti po Jakovu i rasejati po Izrailju. ");
INSERT INTO srponstl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judo! Braća će te tvoja slaviti; ruka će tvoja biti na vratu neprijatelja tvojih, braća tvoja tebi će se klanjati. ");
INSERT INTO srponstl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judo, laviću! Od plena si, sine, sit otišao; kao lav je polegao, kao lavica se ispružio. Ko sme njega da izaziva? ");
INSERT INTO srponstl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Žezlo se carsko od Jude odvojiti neće, ni palica vladarska od njegovih nogu, dok ne dođe onaj kome pripada, kome će se narodi pokoriti. ");
INSERT INTO srponstl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Svoje magare za lozu privezuje, ždrebe magarice za čokot loze. Svoju odeću u vinu pere, svoju haljinu u krvi od vina. ");
INSERT INTO srponstl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Oči su mu mutne od vina, zubi su mu beli od mleka. ");
INSERT INTO srponstl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zavulon će živeti na obali mora, utočište biće brodovima, do Sidona biće mu granica. ");
INSERT INTO srponstl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isahar je magarac koščati što pod svojim samarom leži. ");
INSERT INTO srponstl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Videće on da je odmorište zgodno a zemlja prelepa, pa će svoja leđa pod teret staviti, i na službu ropsku će pristati. ");
INSERT INTO srponstl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan će svome narodu suditi; on je kao svako pleme Izrailjevo. ");
INSERT INTO srponstl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Nek Dan bude zmija na putu, ljuta guja pokraj staze što će konja za petu ujesti, a konjanik njegov nauznak će pasti. ");
INSERT INTO srponstl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Tvome se spasenju nadam, Gospode! ");
INSERT INTO srponstl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gada će napadati pljačkaši, no on će im za petama biti. ");
INSERT INTO srponstl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","U Asira obilje je hrane, za careve davaće poslastice. ");
INSERT INTO srponstl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftalim je košuta slobodna, koja divnu lanad mladi. ");
INSERT INTO srponstl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josif je loza rodna, loza rodna kraj izvora, koja grane preko zida pruža. ");
INSERT INTO srponstl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ljuto su ga strelci napali, strelama se na njega okomili, ");
INSERT INTO srponstl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ali luk on čvrsto zapet drži, mišice mu krepke, ojačale, rukom Boga, Jakog Jakovljevog, zaslugom Pastira, Stene Izrailja, ");
INSERT INTO srponstl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Bogom tvoga oca, koji ti pomaže, Svemoćnim koji te blagosilja blagoslovima odozgo s nebesa, blagoslovima odozdo iz bezdana, blagoslovima dojenja i rađanja. ");
INSERT INTO srponstl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Blagoslovi tvoga oca od blagoslova drevnih planina su obilniji, od obilja večnih brda izdašniji. Nek se oni spuste na glavu Josifovu, na teme posvećenog među braćom. ");
INSERT INTO srponstl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Venijamin je vuk grabljivi, jutrom jede lovinu, a naveče deli plen.“ ");
INSERT INTO srponstl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","To su sva Izrailjeva plemena, njih dvanaest. Ovo im je njihov otac rekao kad ih je blagosiljao. Svakoga od njih je blagoslovio posebnim blagoslovom. ");
INSERT INTO srponstl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Zatim im je zapovedio: „Uskoro ću se pridružiti svome narodu. Sahranite me sa mojim precima u pećinu koja se nalazi na polju Efrona Hetita. ");
INSERT INTO srponstl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","To je pećina na polju Makpeli, prema Mamriji u hananskoj zemlji, koju je Avraham, zajedno s poljem, kupio od Efrona Hetita za mesto sahranjivanja. ");
INSERT INTO srponstl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Tamo su sahranjeni Avraham i njegova žena Sara, tamo su sahranjeni Isak i njegova žena Reveka, a tamo sam sahranio i Liju. ");
INSERT INTO srponstl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Polje i pećina na njemu su kupljeni od potomaka Hetita.“ ");
INSERT INTO srponstl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Kad je Jakov dao ova uputstva svojim sinovima, privukao je svoje noge na postelju i izdahnuo, pridruživši se tako svome narodu. ");
INSERT INTO srponstl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Josif se baci preko očevog lica, pa se isplače nad njim i izljubi ga. ");
INSERT INTO srponstl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Zatim je zapovedio lekarima koji su bili u njegovoj službi da mu balzamuju oca. Lekari su balzamovali Izrailja. ");
INSERT INTO srponstl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Za to im je trebalo četrdeset dana, jer toliko traje balzamovanje. Egipćani su ga oplakivali sedamdeset dana. ");
INSERT INTO srponstl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Kad su dani žalosti prošli, Josif se obrati faraonovim dvoranima: „Ako sam stekao vašu naklonost, prenesite faraonu ovo: ");
INSERT INTO srponstl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","’Moj me je otac zakleo, rekavši: ’Evo, bliži mi se kraj. Sahrani me u grobu koji sam načinio za sebe u zemlji hananskoj.’ Sada mi dopusti da odem i sahranim svoga oca, a onda ću se vratiti.’“ ");
INSERT INTO srponstl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faraon mu reče: „Idi i sahrani svoga oca kako te je zakleo.“ ");
INSERT INTO srponstl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tako Josif ode da sahrani svoga oca. Sa njim su pošli i svi faraonovi dvorani – uglednici na njegovom dvoru i svi uglednici egipatske zemlje, ");
INSERT INTO srponstl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","kao i sva njegova porodica, njegova braća i porodica njegovog oca. U gosenskom kraju su ostala jedino njihova deca, ovce i goveda. ");
INSERT INTO srponstl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sa njim su išla i bojna kola i konjanici. Povorka je bila veoma duga. ");
INSERT INTO srponstl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kad su stigli do Atadovog gumna, koji je s one strane Jordana, održali su veliko i svečano naricanje. Josif je održao sedmodnevni obred žalosti za svojim ocem. ");
INSERT INTO srponstl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kad su stanovnici Hanana videli obred žalosti kod Atadovog gumna, rekli su: „To je egipatski svečani obred žalosti.“ Zato je to mesto nazvano Avel-Misraim. Ono se nalazi s one strane Jordana. ");
INSERT INTO srponstl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jakovljevi sinovi su mu učinili kako im je zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Njegovi sinovi su ga odneli u hanansku zemlju i sahranili u pećini na polju Makpela kod Mamrije. To polje je Avraham kupio od Efrona Hetita za sahranjivanje. ");
INSERT INTO srponstl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Nakon što je sahranio svoga oca, Josif se vratio u Egipat, on i njegova braća, i svi koji su pošli sa njim da sahrani svoga oca. ");
INSERT INTO srponstl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Videvši da im je otac mrtav, Josifova braća rekoše: „Šta ako je Josif još uvek kivan na nas, pa nam uzvrati za sve zlo što smo mu naneli?“ ");
INSERT INTO srponstl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Zato poruče oni Josifu: „Pred svoju smrt, tvoj otac je zapovedio: ");
INSERT INTO srponstl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","’Ovako recite Josifu: ’Oprosti svojoj braći nepravdu i greh koji su učinili postupajući onako zlo prema tebi.’ Oprosti, stoga, nepravdu slugama Boga tvoga oca.’“ Josif se zaplakao kad su mu to rekli. ");
INSERT INTO srponstl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Njegova braća lično dođu k njemu, bace se pred njega i kažu mu: „Evo nas, tvoji smo robovi!“ ");
INSERT INTO srponstl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ali Josif im reče: „Ne bojte se! Pa, zar sam ja umesto Boga? ");
INSERT INTO srponstl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Vi ste smišljali da mi naudite, ali Bog je to okrenuo na dobro. To je učinio da bi sačuvao na životu mnoge narode, kako to i jeste danas. ");
INSERT INTO srponstl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Zato se ne bojte! Ja ću se brinuti za vas i vašu decu.“ Tako ih je umirio ljubaznim rečima. ");
INSERT INTO srponstl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josif je ostao u Egiptu sa porodicom svoga oca. Živeo je stotinu deset godina. ");
INSERT INTO srponstl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Josif je dočekao da vidi Jefremovu decu do trećeg kolena. Mahirovi sinovi, Manasijini unuci su se takođe rodili na Josifovim kolenima. ");
INSERT INTO srponstl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Josif se obrati svojoj braći: „Evo, uskoro ću umreti. Bog će vas svakako posetiti i odvesti vas iz ove zemlje u zemlju koju je pod zakletvom obećao Avrahamu, Isaku i Jakovu.“ ");
INSERT INTO srponstl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Tada je Josif zakleo sinove Izrailjeve: „Bog će vam svakako priteći u pomoć. Tada ćete poneti moje kosti odavde.“ ");
INSERT INTO srponstl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Josifu je bilo stotinu deset godina kad je umro. Zatim su ga balzamovali i u Egiptu ga položili u kovčeg.");
INSERT INTO srponstl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ovo su imena sinova Izrailjevih koji su otišli sa Jakovom u Egipat, svaki sa svojom porodicom: ");
INSERT INTO srponstl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruvim, Simeun, Levije i Juda, ");
INSERT INTO srponstl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isahar, Zavulon, Venijamin, ");
INSERT INTO srponstl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftalim, Gad i Asir. ");
INSERT INTO srponstl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jakovljevih potomaka bilo je ukupno sedamdeset. Josif je već bio u Egiptu. ");
INSERT INTO srponstl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Potom Josif umre, a umru i njegova braća i sav onaj naraštaj. ");
INSERT INTO srponstl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Sinovi Izrailjevi su bili rodni, pa su se razmnožili. Postali su brojni i veoma silni, tako da su napunili zemlju. ");
INSERT INTO srponstl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Tada je nad Egiptom zavladao novi car koji nije poznavao Josifa. ");
INSERT INTO srponstl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","On je rekao svome narodu: „Evo, izrailjski narod je postao brojniji i moćniji od nas. ");
INSERT INTO srponstl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Hajde da postupimo mudro s njima, da ne bi postali još brojniji. Inače, ako izbije rat, oni će se udružiti s našim neprijateljima i zaratiti protiv nas, te napustiti zemlju.“ ");
INSERT INTO srponstl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Stoga postave nad njima nadglednike da ih tlače prinudnim radom. Oni su faraonu izgradili gradove-skladišta, Pitom i Ramesu. ");
INSERT INTO srponstl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ali, što su ih više tlačili, Izrailjci su bivali još brojniji i napredniji, tako da su se Egipćani užasnuli od njih. ");
INSERT INTO srponstl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Zato su ih Egipćani terali na ropski rad. ");
INSERT INTO srponstl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Zagorčavali su im život teškim radovima: pravljenjem maltera i opeke i raznim poljskim radovima. Sve ropske poslove su im nemilosrdno nametali. ");
INSERT INTO srponstl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Egipatski car je rekao i jevrejskim babicama, od kojih je jednoj bilo ime Šifra, a drugoj Fua: ");
INSERT INTO srponstl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","„Kad pomažete Jevrejkama pri porođaju, obratite pažnju na pol deteta: ako je muško, ubijte ga, a ako je žensko, neka živi.“ ");
INSERT INTO srponstl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ali babice su se bojale Boga i nisu učinile kako im je egipatski car naredio, nego su ostavljale u životu mušku decu. ");
INSERT INTO srponstl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Zato je egipatski car pozvao babice i upitao ih: „Zašto ste to činile? Zašto ste ostavljale u životu mušku decu?“ ");
INSERT INTO srponstl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Babice odgovore faraonu: „Jevrejke nisu kao egipatske žene. One su jače, pa rode pre nego što babica dođe k njima.“ ");
INSERT INTO srponstl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Bog je bio dobar prema babicama, a narod izrailjski se još više umnožio i postao veoma silan. ");
INSERT INTO srponstl_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","A pošto su se babice bojale Boga, on im je osnovao porodice. ");
INSERT INTO srponstl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Tada je faraon naredio celom narodu: „Svako muško dete koje se rodi Jevrejima neka se baci u Nil, a ženska deca neka se ostave u životu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","U to vreme neki čovek iz Levijevog plemena ode i oženi jednu devojku iz istog plemena. ");
INSERT INTO srponstl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Žena začne i rodi sina. Videvši da je lep, krila ga je tri meseca. ");
INSERT INTO srponstl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Kad više nije mogla da ga krije, uzela je košaru od papirusove trske, oblepila je smolom i katranom, stavila dečaka u nju i položila je u trsku kraj Nila. ");
INSERT INTO srponstl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Njegova sestra je stala podalje, da vidi šta će se desiti s njim. ");
INSERT INTO srponstl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","No, u Nil siđe faraonova ćerka da se okupa, dok su njene pratilje šetale uz obalu Nila. Uto spazi košaru u trsci, pa pošalje sluškinju da je donese. ");
INSERT INTO srponstl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Otvorivši je, ugleda dete! Dečak je plakao. Sažalivši se nad njim, reče: „Ovo je jedno od jevrejske dece.“ ");
INSERT INTO srponstl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Onda njegova sestra upita faraonovu ćerku: „Hoćeš li da odem i potražim ti dojilju među Jevrejkama da ti doji dete?“ ");
INSERT INTO srponstl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","„Idi“ – reče joj faraonova ćerka. Devojka ode i pozove detetovu majku. ");
INSERT INTO srponstl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Faraonova ćerka joj reče: „Uzmi ovo dete i odgoji mi ga, a ja ću ti plaćati.“ Tako je žena uzela dete i odgojila ga. ");
INSERT INTO srponstl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Kad je dečak porastao, odvela ga je faraonovoj ćerki, koja ga je posinila. Dala mu je ime „Mojsije“, rekavši: „Zato što sam ga izvadila iz vode.“ ");
INSERT INTO srponstl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Jednog dana, kad je Mojsije odrastao, ode on među svoje sunarodnike i vide njihov mukotrpni rad. Tada je video da jedan Egipćanin tuče jednog Jevrejina – jednog od njegovih sunarodnika. ");
INSERT INTO srponstl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mojsije se obazre oko sebe, i kad je video da nema nikoga, smrtno udari Egipćanina i sakrije ga u pesak. ");
INSERT INTO srponstl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kada je došao sledećeg dana, video je dva Jevrejina kako se tuku. „Zašto tučeš svoga druga?“ – reče on krivcu. ");
INSERT INTO srponstl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ovaj odgovori: „Ko je tebe postavio za glavara i sudiju nad nama? Hoćeš li i mene da ubiješ kao što si ubio onog Egipćanina?“ Mojsije se uplaši, pa reče: „Nema sumnje, već se zna o ovome!“ ");
INSERT INTO srponstl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kad je faraon ovo čuo, hteo je da pogubi Mojsija. Ali Mojsije pobegne od faraona i skloni se u madijansku zemlju. Tamo je seo kod jednog bunara. ");
INSERT INTO srponstl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","A madijanski sveštenik je imao sedam ćerki. Dođu one da zahvate vodu i napune pojila, da napoje stado ovaca svoga oca. ");
INSERT INTO srponstl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Međutim, dođu neki pastiri, pa ih oteraju. Tada Mojsije ustane i odbrani ih, te napoji njihovo stado. ");
INSERT INTO srponstl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Vrate se one svome ocu Raguilu, a on ih upita: „Zašto ste se danas tako brzo vratile?“ ");
INSERT INTO srponstl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","One odgovore: „Neki Egipćanin nas je odbranio od pastira. Čak nam je zahvatio vode i napojio stado.“ ");
INSERT INTO srponstl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","„Pa, gde je on? – upita on svoje ćerke. Zašto ste ostavile tog čoveka? Pozovite ga na obed.“ ");
INSERT INTO srponstl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mojsije je pristao da ostane kod tog čoveka, a ovaj je dao Mojsiju svoju ćerku Seforu za ženu. ");
INSERT INTO srponstl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ona začne i rodi sina. Mojsije mu je dao ime „Girsam“, rekavši: „Ja sam došljak u tuđoj zemlji.“ ");
INSERT INTO srponstl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Posle mnogo vremena umre egipatski car. Izrailjci su stenjali pod ropstvom. Ipak, iz ropstva se njihov vapaj uzdigao do Boga. ");
INSERT INTO srponstl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Gospod je čuo njihove uzdisaje, i setio se svoga saveza sa Avrahamom, Isakom i Jakovom. ");
INSERT INTO srponstl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Bog je pogledao na Izrailjce i prepoznao ih. ");
INSERT INTO srponstl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Jednom je Mojsije čuvao ovce Jotora, svoga tasta, madijanskog sveštenika. Goneći stado po pustari, dođe do Božije gore, do Horiva. ");
INSERT INTO srponstl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Tu mu se ukaže Anđeo Gospodnji u plamtećem ognju iz jednog grma. Pogleda on, kad ono, grm gori, ali ne sagoreva. ");
INSERT INTO srponstl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mojsije reče u sebi: „Hajde da priđem i osmotrim ovu čudnu pojavu, zašto grm ne sagoreva.“ ");
INSERT INTO srponstl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Kad je Gospod video da prilazi da osmotri, Bog ga zovne iz grma: „Mojsije, Mojsije!“ „Evo me“ – odazva se Mojsije. ");
INSERT INTO srponstl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Bog mu reče: „Ne prilazi ovamo! Izuj obuću sa svojih nogu, jer je mesto na kome stojiš sveto tlo.“ ");
INSERT INTO srponstl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","On nastavi: „Ja sam Bog tvoga oca; Bog Avrahamov, Bog Isakov i Bog Jakovljev.“ Mojsije na to zakloni svoje lice, jer se bojao da gleda u Boga. ");
INSERT INTO srponstl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Gospod mu opet reče: „Uistinu sam video nevolje moga naroda u Egiptu i čuo njegov vapaj zbog njegovih tlačitelja. Poznate su mi njegove muke. ");
INSERT INTO srponstl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Zato sam sišao da ga izbavim iz ruku egipatskih, te da ih odvedem iz egipatske zemlje u dobru i prostranu zemlju, u zemlju kojom teku med i mleko, u zemlju Hananaca, Hetita, Amorejaca, Ferežana, Evejaca i Jevusejaca. ");
INSERT INTO srponstl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","I evo, sad je vapaj Izrailjaca došao k meni, a i lično sam video kako ih Egipćani tlače. ");
INSERT INTO srponstl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","A sad hajde da te pošaljem k faraonu da izvedeš moj narod, Izrailjce, iz Egipta.“ ");
INSERT INTO srponstl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mojsije reče Bogu: „Ko sam ja da idem pred faraona i da izvedem Izrailjce iz Egipta?“ ");
INSERT INTO srponstl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Bog mu reče: „Ja ću biti s tobom, a ovo će biti znak da te ja šaljem: kad izvedeš narod iz Egipta, služićete Bogu na ovoj gori.“ ");
INSERT INTO srponstl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mojsije upita Boga: „Ako odem k Izrailjcima i kažem im: ’Bog vaših otaca me je poslao k vama’, šta da im kažem ako me upitaju: ’Kako mu je ime?’“ ");
INSERT INTO srponstl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","„Ja sam onaj koji jesam“ – odgovori Bog Mojsiju i nastavi: „Ovako kaži Izrailjcima: ’Ja Jesam’ me je poslao k vama.“ ");
INSERT INTO srponstl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Bog još reče Mojsiju: „Ovako reci Izrailjcima: ’Gospod, Bog vaših otaca, Bog Avrahamov, Bog Isakov i Bog Jakovljev, me je poslao k vama. To je moje ime doveka; po njemu neka me pamte od kolena do kolena.’ ");
INSERT INTO srponstl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Idi i okupi izrailjske starešine, pa im reci: ’Gospod, Bog vaših otaca, Bog Avrahamov, Isakov i Jakovljev mi se ukazao i rekao mi: „Posetio sam vas i video šta vam se čini u Egiptu. ");
INSERT INTO srponstl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Zato izjavljujem: ja ću vas izvesti iz egipatske bede u zemlju Hananaca, Hetita, Amorejaca, Ferežana, Evejaca i Jevusejaca, u zemlju kojom teku med i mleko.“’ ");
INSERT INTO srponstl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Oni će te poslušati, a ti ćeš otići sa izrailjskim starešinama k egipatskom caru, pa ćete mu reći: ’Gospod, Bog Jevreja, nas je sreo. Dozvoli nam sad da odemo tri dana hoda u pustinju, da prinesemo žrtvu Gospodu, Bogu svojemu.’ ");
INSERT INTO srponstl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ipak, ja znam da vam egipatski car neće dati da odete ako ga ne natera moćna ruka. ");
INSERT INTO srponstl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Zato ću ispružiti svoju ruku i udariti Egipat svakojakim čudesima koja ću učiniti u njemu. Posle toga će vas pustiti. ");
INSERT INTO srponstl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Još ću učiniti da se Egipćani odobrovolje prema ovom narodu, pa kad pođete, nećete otići praznih ruku. ");
INSERT INTO srponstl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Svaka žena će zatražiti od svoje susetke ili od stanarke u svojoj kući predmete od srebra i zlata, i odeću. Sve to stavite na svoje sinove i ćerke. Tako ćete opleniti Egipat.“ ");
INSERT INTO srponstl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ali Mojsije odgovori: „A šta ako mi ne poveruju i ne poslušaju me? Šta ako kažu: ’Gospod ti se nije ukazao’?“ ");
INSERT INTO srponstl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Gospod ga upita: „Šta je to u tvojoj ruci?“ „Štap“ – odgovori ovaj. ");
INSERT INTO srponstl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Bog mu reče: „Baci ga na zemlju!“ Mojsije baci štap na zemlju i ovaj se pretvori u zmiju. Mojsije ustukne od nje. ");
INSERT INTO srponstl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Gospod reče Mojsiju: „Pruži ruku i uhvati je za rep!“ Mojsije pruži ruku i uhvati je za rep, a ona se opet pretvori u štap u njegovoj ruci. ");
INSERT INTO srponstl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","„Eto, tako će poverovati da ti se ukazao Gospod, Bog njihovih otaca, Bog Avrahamov, Bog Isakov i Bog Jakovljev.“ ");
INSERT INTO srponstl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Gospod mu ponovo reče: „Uvuci svoju ruku u nedra!“ On uvuče svoju ruku u nedra. On izvuče ruku, a ono, ruka mu sva u gubi, bela kao sneg. ");
INSERT INTO srponstl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Bog mu zatim reče: „Vrati svoju ruku u nedra!“ Mojsije vrati ruku u nedra. Kad je izvukao, opet je bila kao i ostalo telo. ");
INSERT INTO srponstl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Bog reče: „Ako ti ne poveruju i ne poslušaju svedočanstvo prvog znaka, poverovaće svedočanstvu drugog znaka. ");
INSERT INTO srponstl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","A ako ne poveruju ni ovim dvoma znacima i ne poslušaju te, ti uzmi vode iz Nila i prolij na tlo, pa će se voda koju si uzeo iz Nila na tlu pretvoriti u krv.“ ");
INSERT INTO srponstl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ali Mojsije reče Gospodu: „Oprosti, Gospode, ali ja nisam rečit čovek. Nisam bio ni ranije, a nisam ni sad dok govoriš svome sluzi. Sporo govorim, a jezik mi se zapetlja.“ ");
INSERT INTO srponstl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Gospod mu odgovori: „Ko je dao usta čoveku? Ko ga čini nemim ili gluvim? Ko mu daje vid ili ga čini slepim? Zar nisam to ja, Gospod? ");
INSERT INTO srponstl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Zato idi sad, ja ću biti s tobom kad budeš govorio i poučiti te šta da kažeš.“ ");
INSERT INTO srponstl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","No, Mojsije reče: „Molim te, Gospode, pošalji nekog drugog.“ ");
INSERT INTO srponstl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Gospod se na to razgnevi na Mojsija, pa mu reče: „Nije li Aron, Levit, tvoj brat? Znam da je on veoma rečit. Evo, on ti upravo izlazi u susret. Kad te bude video, od srca će ti se obradovati. ");
INSERT INTO srponstl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ti ćeš govoriti s njim i preneti mu ove reči. Ja ću biti s tobom i s njim kad budete govorili, i poučiti vas šta da radite. ");
INSERT INTO srponstl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","On će govoriti narodu umesto tebe; on će ti biti umesto usta, a ti ćeš njemu biti umesto Boga. ");
INSERT INTO srponstl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Uzmi ovaj štap u svoju ruku. Njime ćeš činiti znakove.“ ");
INSERT INTO srponstl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mojsije se vrati svome tastu Jotoru, pa mu reče: „Dopusti mi da se vratim svojoj braći koja su u Egiptu, da vidim jesu li još u životu.“ „Pođi u miru“ – reče Jotor Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Zatim Gospod reče Mojsiju u Madijanu: „Idi, vrati se u Egipat, jer su pomrli svi koji su hteli da te ubiju.“ ");
INSERT INTO srponstl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mojsije uzme svoju ženu i svoje sinove, posadi ih na magarca, pa se vrati u egipatsku zemlju. U ruku je uzeo štap Božiji. ");
INSERT INTO srponstl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Gospod reče Mojsiju: „Kad se vratiš u Egipat, gledaj da pred faraonom učiniš sva čudesa za koja sam ti dao moć. Ipak, ja ću otvrdnuti njegovo srce, tako da neće pustiti narod da ode. ");
INSERT INTO srponstl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","A faraonu ćeš reći ovo: ’Govori Gospod: Izrailj je moj sin prvenac. ");
INSERT INTO srponstl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Rekao sam ti: „Pusti mog sina da mi služi. Odbiješ li da ga pustiš, čuvaj se: ja ću ubiti tvog prvenca.“’“ ");
INSERT INTO srponstl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ali kad su na putu stali da prenoće, Gospod navali na Mojsija da ga ubije. ");
INSERT INTO srponstl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Tada Sefora uzme kameni nož i obreže svoga sina, te se kožicom dotakne Mojsijevih nogu i reče: „Ti si mi krvav muž.“ ");
INSERT INTO srponstl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Tada ga je Gospod ostavio. Tom prilikom je rekla: „Krvav muž“, misleći na obrezanje. ");
INSERT INTO srponstl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Gospod reče Aronu: „Pođi u pustinju da sretneš Mojsija.“ On pođe. Kad se sastao sa Mojsijem na Božijoj gori, poljubio ga je. ");
INSERT INTO srponstl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Tada je Mojsije ispričao Aronu sve što je Gospod rekao kad ga je poslao, i o svim znacima koje mu je naredio da učini. ");
INSERT INTO srponstl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Zatim Mojsije i Aron odu i okupe sve izrailjske starešine. ");
INSERT INTO srponstl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aron je ispričao sve što je Gospod rekao Mojsiju, a Mojsije je učinio znakove na oči naroda. ");
INSERT INTO srponstl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Narod je tome poverovao. A kad su čuli da je Gospod posetio Izrailjce i da je video njihov jad, pali su na kolena i poklonili se Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Nakon toga Mojsije i Aron odu k faraonu i reknu mu: „Govori Gospod, Bog Izrailjev: ’Pusti moj narod da ode i u moju čast proslavi praznik u pustinji.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ali faraon odgovori: „Ko je taj Gospod, pa da poslušam šta on kaže, i da pustim Izrailjce da odu? Ja tog Gospoda ne znam, a niti ću pustiti Izrailjce da odu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","„Bog Jevreja se sreo sa nama – odgovore oni. Zato nas pusti da odemo tri dana hoda u pustinju i prinesemo žrtvu Gospodu, Bogu svojemu, da nas ne udari pomorom ili mačem.“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Nato egipatski car reče: „Mojsije i Arone, zašto odvraćate narod od njegovog posla? Vratite se svome poslu!“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Faraon još reče: „Eto, sad kad se narod u zemlji toliko umnožio, vi ih sprečavate u poslu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Tog istog dana faraon naredi upravnicima ropske tlake i njihovim nadzornicima: ");
INSERT INTO srponstl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","„Ne opskrbljujte više narod slamom za pravljenje opeke kao do sada. Neka idu sami i skupljaju slamu. ");
INSERT INTO srponstl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ipak, zahtevajte od njih istu količinu opeke koju su pravili do sad. Ne smanjujte je. To su lenštine! Zato i viču: ’Idemo da prinesemo žrtvu svome Bogu!’ ");
INSERT INTO srponstl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Naterajte taj svet da još teže radi; kad budu radili, neće obraćati pažnju na izmišljotine.“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Upravnici ropske tlake i nadzornici dođu i objave narodu: „Ovako kaže faraon: ’Neću vas više opskrbljivati slamom. ");
INSERT INTO srponstl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Idite sami i skupljajte je gde god je nađete. Ipak, posao vam neću olakšati.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Zato se narod raziđe po celoj egipatskoj zemlji da skuplja strnjiku umesto slame. ");
INSERT INTO srponstl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Upravnici ropske tlake su ih terali govoreći: „Dovršite svoj dnevni posao, kao kad ste dobijali slamu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","A izrailjske nadzornike, koje su faraonovi upravnici ropske tlake postavili, tukli su i ispitivali: „Zašto ni juče ni danas niste napravili propisanu količinu opeke kao ranije?“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Izrailjski nadzornici dođu i zavape k faraonu: „Zašto ovako postupaš sa svojim slugama? ");
INSERT INTO srponstl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Slama se više ne daje tvojim slugama, a ipak se od nas traži: ’Napravite opeku!’ Evo, sad i tuku tvoje sluge, a kriv je tvoj narod.“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ali faraon reče: „Lenštine ste vi, lenštine! Zato i kažete: ’Idemo da prinesemo žrtvu Gospodu.’ ");
INSERT INTO srponstl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Vraćajte se na posao! Slama vam se neće davati, ali morate napraviti istu količinu opeke.“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Izrailjski nadzornici su videli da im se loše piše zbog naredbe: „Ne smanjujte dnevnu količinu opeke.“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Kad su otišli od faraona, nabasali su na Mojsija i Arona, koji su ih čekali. ");
INSERT INTO srponstl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Nadzornici im rekoše: „Neka vas Gospod ima na oku i sudi vam, jer ste nas omrazili kod faraona i njegovih dvorana; dali ste im mač u ruke da nas pobiju.“ ");
INSERT INTO srponstl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mojsije se obrati Gospodu i reče: „O, Gospode, zašto si uvalio u nevolju ovaj narod? Zašto si me poslao? ");
INSERT INTO srponstl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Od kako sam stupio pred faraona da govorim u tvoje ime, on sve gore postupa s ovim narodom, a ti ništa ne činiš da izbaviš svoj narod.“ ");
INSERT INTO srponstl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Tada Gospod reče Mojsiju: „Sada ćeš videti šta ću učiniti faraonu. Moja moćna ruka će ga naterati da pusti Izrailjce; moja moćna ruka će ga naterati da ih istera iz svoje zemlje.“ ");
INSERT INTO srponstl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Još reče Bog Mojsiju: „Ja sam Gospod. ");
INSERT INTO srponstl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Avrahamu, Isaku i Jakovu sam se objavio pod imenom Bog Svemoćni. Ipak, njima se nisam otkrio pod imenom Gospod. ");
INSERT INTO srponstl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Šta više, sklopio sam svoj savez s njima da ću im dati hanansku zemlju, zemlju gde su živeli kao stranci. ");
INSERT INTO srponstl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","A još sam čuo i uzdisanje Izrailjaca koje Egipćani drže u ropstvu, pa sam se setio svoga saveza. ");
INSERT INTO srponstl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Zato reci Izrailjcima: ’Ja sam Gospod; ja ću vas izbaviti od egipatskog jarma i osloboditi vas od ropstva. Ja ću ispružiti svoju mišicu da ih strogo kaznim, i tako vas otkupim. ");
INSERT INTO srponstl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Uzeću vas sebi za narod, i ja ću biti vaš Bog. Tada ćete znati da sam vas ja, Gospod, vaš Bog, oslobodio od egipatskog jarma. ");
INSERT INTO srponstl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ja ću vas odvesti u zemlju za koju sam se zakleo da ću je dati Avrahamu, Isaku i Jakovu; ja ću vam je dati u posed. Ja sam Gospod.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mojsije je to preneo Izrailjcima, ali oni nisu hteli da ga slušaju, jer im je duh klonuo od teškog ropstva. ");
INSERT INTO srponstl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Tada Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","„Idi i reci faraonu, egipatskom caru, da pusti Izrailjce da odu iz njegove zemlje.“ ");
INSERT INTO srponstl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ali Mojsije reče Gospodu: „Evo, kad me Izrailjci nisu poslušali, kako će faraon poslušati mene koji sam nevešt u govoru?“ ");
INSERT INTO srponstl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","No, Gospod je ponovio što je već rekao Mojsiju i Aronu: zapovedio im je da idu k Izrailjcima, i da kažu faraonu, egipatskom caru, da pusti Izrailjce iz Egipta. ");
INSERT INTO srponstl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ovo su glavari rodova. Sinovi Izrailjevog prvenca Ruvima: Enoh, Faluj, Esron i Harmija. To su rodovi Ruvimovi. ");
INSERT INTO srponstl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Sinovi Simeunovi: Jemuilo, Jamin, Aod, Jakin, Cohar i Saul, sin jedne Hananke. To su rodovi Simeunovi. ");
INSERT INTO srponstl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ovo su imena Levijevih sinova s njihovim rodoslovom: Girson, Kat i Merarije. Levije je živeo stotinu trideset sedam godina. ");
INSERT INTO srponstl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Girsonovi sinovi su: Lovenije i Semaj sa svojim porodicama. ");
INSERT INTO srponstl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Katovi sinovi su: Amram, Isar, Hevron i Ozilo. Kat je ukupno živeo stotinu trideset tri godine. ");
INSERT INTO srponstl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merarijevi sinovi su: Molija i Musija. To su Levijevi rodovi po svojim porodicama. ");
INSERT INTO srponstl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram se oženio svojom tetkom Johavedom, koja mu je rodila Arona i Mojsija. Amram je ukupno živeo stotinu trideset sedam godina. ");
INSERT INTO srponstl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isarovi sinovi su: Korej, Nefeg i Zihrije. ");
INSERT INTO srponstl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ozilovi sinovi su: Misailo, Elisafan i Sitrija. ");
INSERT INTO srponstl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aron se oženio Jelisavetom, ćerkom Aminadavovom, sestrom Nasonovom, koja mu je rodila Nadava, Avijuda, Eleazara i Itamara. ");
INSERT INTO srponstl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Korejevi sinovi su: Asir, Elkana i Avijasaf. To su Korejeve porodice. ");
INSERT INTO srponstl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aronov sin, Eleazar, se oženio jednom od Futilovih ćerki, koja mu je rodila Finesa. To su glavari levitskih rodova po svojim porodicama. ");
INSERT INTO srponstl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","To je onaj Aron i onaj Mojsije kojima je Gospod rekao: „Izvedite Izrailjce iz Egipta po njihovim četama.“ ");
INSERT INTO srponstl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","To su isti Mojsije i Aron koji su rekli faraonu, egipatskom caru, da pusti Izrailjce iz Egipta. ");
INSERT INTO srponstl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Onog dana kad je Gospod govorio Mojsiju u Egiptu, ");
INSERT INTO srponstl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","rekao mu je: „Ja sam Gospod. Reci faraonu, egipatskom caru, sve što ti ja kažem.“ ");
INSERT INTO srponstl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ali Mojsije odgovori Gospodu: „Nevešt sam ja u govoru. Kako će me faraon poslušati?“ ");
INSERT INTO srponstl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Gospod je odgovorio Mojsiju: „Vidi! Postavio sam te da budeš kao Bog faraonu, a tvoj brat Aron biće tvoj prorok. ");
INSERT INTO srponstl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ti ćeš govoriti sve što sam ti zapovedio, a Aron će reći faraonu da pusti Izrailjce iz svoje zemlje. ");
INSERT INTO srponstl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ja ću, pak, otvrdnuti faraonovo srce, i izvesti mnogo svojih znakova i čuda u Egiptu. ");
INSERT INTO srponstl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pošto vas faraon neće poslušati, ja ću zamahnuti svojom rukom na Egipat i udariti ga velikim kaznama, pa ću izvesti svoje čete, svoj narod, Izrailjce, iz Egipta. ");
INSERT INTO srponstl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Kad pružim svoju ruku na Egipat i izvedem Izrailjce iz njihove sredine, Egipćani će znati da sam ja Gospod.“ ");
INSERT INTO srponstl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mojsije i Aron su učinili onako kako im je Gospod zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mojsiju je bilo osamdeset, a Aronu osamdeset tri godine kad su govorili s faraonom. ");
INSERT INTO srponstl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","„Kad faraon zatraži od vas: ’Učinite kakvo čudo’, ti onda reci Aronu: ’Uzmi štap i baci ga pred faraona’, a štap će se pretvoriti u zmiju.“ ");
INSERT INTO srponstl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mojsije i Aron stupe pred faraona i učine onako kako im je Gospod zapovedio. Aron baci štap pred faraona i pred njegove dvorane, koji se pretvori u zmiju. ");
INSERT INTO srponstl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ali faraon pozove mudrace i gatare, te ovi vračari učine isto svojim čaranjem. ");
INSERT INTO srponstl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Svaki od njih baci svoj štap, i svaki se pretvori u zmiju. Međutim, Aronov štap proguta njihove štapove. ");
INSERT INTO srponstl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ali faraonovo srce je otvrdnulo, te ih nije poslušao, baš kako je Gospod i rekao. ");
INSERT INTO srponstl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Gospod reče Mojsiju: „Faraonovo srce je tvrdo, te odbija da pusti narod. ");
INSERT INTO srponstl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Idi k faraonu ujutro, kad on dolazi k vodi, i čekaj na obali Nila da ga sretneš. U ruku uzmi štap koji se bio pretvorio u zmiju. ");
INSERT INTO srponstl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Reci mu ovo: ’Gospod, Bog Jevreja, poslao me je k tebi da ti kažem: „Pusti moj narod da mi služi u pustinji.“ Ali ti, evo, sve do sad nisi poslušao. ");
INSERT INTO srponstl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Govori Gospod: „Po ovome ćeš znati da sam ja Gospod. Evo, štapom koji mi je u ruci udariću po vodi u Nilu, pa će se pretvoriti u krv. ");
INSERT INTO srponstl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ribe u Nilu će uginuti, a Nil će se tako usmrdeti, da će se Egipćanima gaditi da piju vodu iz njega.“’“ ");
INSERT INTO srponstl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Gospod još reče Mojsiju: „Reci Aronu: ’Uzmi svoj štap i pruži svoju ruku nad egipatske vode: nad njihove reke, prokope, jezera, i na sva sabirališta vode, pa će se pretvoriti u krv.’ Krvi će biti po celom Egiptu, čak i u drvenim i kamenim posudama.“ ");
INSERT INTO srponstl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mojsije i Aron učine onako kako im je Gospod zapovedio. Aron podigne svoj štap i na oči faraona i njegovih dvorana udari po vodi u Nilu, na šta se sva voda u Nilu pretvori u krv. ");
INSERT INTO srponstl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Sva riba u Nilu je uginula, a Nil se tako usmrdeo da Egipćani nisu mogli da piju vodu iz njega. Krvi je bilo po celom Egiptu. ");
INSERT INTO srponstl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ali i gatari egipatski učine isto svojim čaranjem. No, faraonovo srce je i dalje bilo tvrdo, te ih nije poslušao, baš kako je Gospod rekao. ");
INSERT INTO srponstl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Faraon se okrenuo i otišao u svoj dvor, ne uzimajući ni ovo k srcu. ");
INSERT INTO srponstl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Sav je Egipat počeo da kopa oko Nila, jer nisu mogli da piju vodu iz Nila. ");
INSERT INTO srponstl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Tako je prošlo sedam dana od kako je Gospod udario Nil. ");
INSERT INTO srponstl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Gospod reče Mojsiju: „Idi k faraonu i reci mu: ’Govori Gospod: „Pusti moj narod da mi služi. ");
INSERT INTO srponstl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ali ako odbiješ da ih pustiš, čuvaj se: ja ću svu zemlju kazniti žabama. ");
INSERT INTO srponstl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nil će vrveti žabama. One će se uvući u tvoj dvor, u tvoju spavaću sobu, u tvoju postelju, u domove tvojih dvorana i tvog naroda, u tvoje pećnice i naćve. ");
INSERT INTO srponstl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Žabe će skakati po tebi, tvome narodu i po svim tvojim dvoranima.“’“ ");
INSERT INTO srponstl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Gospod nastavi da govori Mojsiju: „Reci Aronu: ’Ispruži svoju ruku sa svojim štapom nad reke, prokope i jezera, i učini da žabe izađu i navale na egipatsku zemlju.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aron ispruži svoju ruku nad egipatske vode i žabe izađoše i prekriše egipatsku zemlju. ");
INSERT INTO srponstl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ali i gatari su to isto učinili svojim čaranjem; i oni su učinili da žabe izađu i navale na egipatsku zemlju. ");
INSERT INTO srponstl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Tada faraon pozove Mojsija i Arona i reče im: „Molite se Gospodu da odstrani žabe od mene i moga naroda, pa ću pustiti narod da prinese žrtvu Gospodu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mojsije odgovori faraonu: „Ti imaš čast da mi kažeš kad hoćeš da se molim za tebe, za tvoje dvorane i za tvoj narod, da se žabe povuku od tebe, i tvojih kuća, i da ostanu u Nilu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","„Sutra“ – odgovori faraon. Mojsije reče: „Neka bude kako si rekao, da znaš da niko nije kao Gospod, naš Bog. ");
INSERT INTO srponstl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Žabe će se povući od tebe, tvojih domova, od tvojih dvorana i od tvoga naroda; ostaće samo u Nilu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Kad su Mojsije i Aron otišli od faraona, Mojsije zavapi k Gospodu zbog žaba, koje je doveo na faraona. ");
INSERT INTO srponstl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Gospod je učinio kako je Mojsije rekao: žabe su uginule po kućama, dvorištima i poljima. ");
INSERT INTO srponstl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Na gomile su ih skupljali, pa se zemlja usmrdela od njih. ");
INSERT INTO srponstl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","No, kada je faraon video da je nastalo olakšanje, otvrdnuo je srce, te ih nije poslušao, baš kako je Gospod rekao. ");
INSERT INTO srponstl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Gospod reče Mojsiju: „Reci Aronu: ’Zamahni svojim štapom i udari po prašini na tlu, i ona će se pretvoriti u komarce po celom Egiptu.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Tako su i učinili. Aron ispruži svoju ruku i udari njime po prašini na tlu. Komarci se stušte na ljude i na stoku. Sva prašina na tlu se pretvorila u komarce po celom Egiptu. ");
INSERT INTO srponstl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Gatari su takođe pokušali da stvore komarce svojim čaranjem, ali nisu mogli. Tako su se komarci stuštili na ljude i na stoku. ");
INSERT INTO srponstl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Tada gatari rekoše faraonu: „To je prst Božiji!“ Ali faraonovo srce je i dalje bilo tvrdo, i nije ih poslušao, baš kako je Gospod rekao. ");
INSERT INTO srponstl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Gospod reče Mojsiju: „Ustani u rano jutro i stupi pred faraona kad dolazi k vodi, pa mu reci: ’Ovo govori Gospod: pusti moj narod da mi služi. ");
INSERT INTO srponstl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Jer ako ne pustiš moj narod, čuvaj se: pustiću obade na tebe, na tvoje dvorane, na tvoj narod, i na tvoje kuće. Egipatske kuće će se napuniti obadima. Čak će i tlo na kome stoje vrveti od njih. ");
INSERT INTO srponstl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ipak, u taj dan ću izuzeti gosenski kraj, gde moj narod živi; tamo neće biti obada. Tako ćeš znati da sam ja, Gospod, u ovoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Tako ću napraviti razliku između tvog i mog naroda. Ovaj znak će se pokazati sutra.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Gospod tako i učini. Rojevi obada navale u faraonov dvor i u kuće njegovih dvorana. Sva je egipatska zemlja nastradala od obada. ");
INSERT INTO srponstl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Faraon pozva Mojsija i Arona i reče im: „Idite i prinesite žrtvu svome Bogu, ali tu, u zemlji.“ ");
INSERT INTO srponstl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mojsije mu odgovori: „Bilo bi neprimereno učiniti tako nešto. Žrtve koje prinosimo Gospodu, našem Bogu, Egipćanima su odvratne. Ako, dakle, na njihove oči prinesemo žrtve koje su Egipćanima odvratne, neće li nas kamenovati? ");
INSERT INTO srponstl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Zato moramo da odemo tri dana hoda u pustinju da prinesemo žrtve Gospodu, našem Bogu, kako nam je zapovedio.“ ");
INSERT INTO srponstl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","„Pustiću vas da odete u pustinju i prinesete žrtve Gospodu, svome Bogu – reče faraon – pod uslovom da ne idete predaleko. Pomolite se i za mene.“ ");
INSERT INTO srponstl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mojsije reče: „Evo, čim odem od tebe, ja ću se pomoliti Gospodu, i sutra će se obadi udaljiti od faraona, od njegovih dvorana, i od njegovog naroda. Samo da nas faraon opet ne prevari, te ne pusti narod da prinese žrtve Gospodu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Kad je Mojsije otišao od faraona, pomolio se Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Gospod je učinio što je Mojsije tražio; obadi su se udaljili od faraona, od njegovih dvorana i od njegovog naroda. Ni jedan jedini nije ostao. ");
INSERT INTO srponstl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ali faraon je i ovaj put otvrdnuo srce, pa nije pustio narod. ");
INSERT INTO srponstl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Tada Gospod reče Mojsiju: „Idi k faraonu i reci mu: ’Ovako kaže Gospod, Bog Jevreja: pusti moj narod da mi služi. ");
INSERT INTO srponstl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Jer ako odbiješ da ih pustiš, te ih i dalje budeš zadržavao, ");
INSERT INTO srponstl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","čuvaj se: ruka će Gospodnja udariti velikim pomorom tvoju stoku u poljima: tvoje konje, magarce, kamile, krupnu i sitnu stoku. ");
INSERT INTO srponstl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ali Gospod će napraviti razliku između stoke Izrailjaca i stoke Egipćana, tako da ništa što pripada Izrailjcima neće uginuti.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Gospod je odredio i vreme za to, rekavši: „Sutra će Gospod učiniti ovo u zemlji.“ ");
INSERT INTO srponstl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Gospod je to i učinio sutradan: sva egipatska stoka je uginula, dok od izrailjske stoke nijedno grlo nije uginulo. ");
INSERT INTO srponstl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraon pošalje ljude da se raspitaju, i zaista, ni jedno grlo koje pripada Izrailjcima nije uginulo. Ipak, faraonovo srce je ostalo tvrdo, pa nije pustio narod da ide. ");
INSERT INTO srponstl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Tada Gospod reče Mojsiju i Aronu: „Uzmite iz peći nekoliko punih šaka pepela, pa neka ga Mojsije, na faraonove oči, baci prema nebu. ");
INSERT INTO srponstl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Od toga će nastati sitna prašina koja će se razleteti po celoj egipatskoj zemlji, i od koje će po ljudima i životinjama izbijati veliki čirevi puni gnoja širom Egipta.“ ");
INSERT INTO srponstl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Oni uzmu pepela iz peći i stanu pred faraona. Onda Mojsije baci pepeo prema nebu, i čirevi puni gnoja izbiju po ljudima i životinjama. ");
INSERT INTO srponstl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Gatari nisu mogli da se pojave pred Mojsijem zbog čireva, jer su i po gatarima izbili čirevi, kao i po ostalim Egipćanima. ");
INSERT INTO srponstl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","No, Gospod je otvrdnuo faraonovo srce, pa ih nije poslušao, baš kako je Gospod rekao Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Tada Gospod reče Mojsiju: „Porani ujutro i stani pred faraona, pa mu reci: ’Ovako kaže Gospod, Bog Jevreja: pusti moj narod da mi služi. ");
INSERT INTO srponstl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Naime, ovaj put ću poslati sve svoje pošasti na tebe, na tvoje dvorane i na tvoj narod, tako da znaš da na celoj zemlji nema nikoga kao što sam ja. ");
INSERT INTO srponstl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Jer, da sam već ispružio svoju ruku i udario pomorom tebe i tvoj narod, nestalo bi te s lica zemlje. ");
INSERT INTO srponstl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Baš zato sam te i postavio da na tebi pokažem svoju silu, i da se moje ime razglasi po celom svetu. ");
INSERT INTO srponstl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ti, dakle, još uvek ugnjetavaš moj narod i ne puštaš ga da ide. ");
INSERT INTO srponstl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Evo, sutra ću pustiti tako strašan grad kakvog nije bilo u Egiptu od kako je postao, pa sve do sad. ");
INSERT INTO srponstl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Zato pošalji ljude da uteraju unutra tvoju stoku i sve što je tvoje na polju. Svaki čovek ili životinja koji se nađu na polju, a ne sklone se pod krov, poginuće kad grad počne da pljušti po njima.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Oni faraonovi dvorani, koji su se pobojali Gospodnje reči, uteraju svoje sluge i stoku pod krov. ");
INSERT INTO srponstl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","A oni koji nisu marili za Gospodnju reč, ostavili su svoje sluge i stoku u polju. ");
INSERT INTO srponstl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Tada Gospod reče Mojsiju: „Pruži svoju ruku prema nebu, pa neka zapljušti grad po celom Egiptu, po ljudima, životinjama i po svem bilju u Egiptu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mojsije pruži svoj štap prema nebu. Gospod pošalje gromove i grad, a munje se obore na zemlju. Gospod je zasuo gradom zemlju Egipćana. ");
INSERT INTO srponstl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Grad je pljuštao, a kroz njega su parale munje. Tako teškog grada nikada nije bilo u Egiptu otkako je naroda u njemu. ");
INSERT INTO srponstl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Grad je pobio u celom Egiptu sve što se našlo napolju, ljude i životinje; uništio je i sve bilje na poljima i polomio sve poljsko drveće. ");
INSERT INTO srponstl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Samo u gosenskom kraju, gde su živeli Izrailjci, nije bilo grada. ");
INSERT INTO srponstl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Tada je faraon pozvao Mojsija i Arona i rekao im: „Ovaj put sam sagrešio. Gospod je u pravu, a ja i moj narod smo krivi. ");
INSERT INTO srponstl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pomolite se Gospodu da prestanu ovi gromovi i grad, a ja ću vas pustiti da idete. Ne morate se duže zadržavati.“ ");
INSERT INTO srponstl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mojsije mu odgovori: „Čim izađem iz grada, podići ću svoje ruke k Gospodu i gromovi će prestati, a ni grada više neće biti, tako da znaš da zemlja pripada Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ipak, ja znam da se ni ti ni tvoji dvorani još uvek ne bojite Gospoda Boga.“ ");
INSERT INTO srponstl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Tako su propali lan i ječam, jer je ječam bio u klasu, a lan je tek propupeo. ");
INSERT INTO srponstl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Pšenica i raž nisu stradali, jer su pozna žita. ");
INSERT INTO srponstl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mojsije je otišao od faraona, izašao iz grada, te podigao ruke k Gospodu. Gromovi i grad su prestali, a ni kiša više nije padala na zemlju. ");
INSERT INTO srponstl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kad je faraon video da su prestali gromovi, grad i kiša, ponovo je zgrešio; otvrdnuli su srce i on i njegovi dvorani. ");
INSERT INTO srponstl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Pošto je faraonovo srce otvrdnulo, on nije pustio Izrailjce da idu, baš kako je Gospod rekao preko Mojsija. ");
INSERT INTO srponstl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Tada Gospod reče Mojsiju: „Idi k faraonu, jer sam otvrdnuo srce njemu i njegovim dvoranima, da bih učinio znakove među njima, ");
INSERT INTO srponstl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","te da bi ti pripovedao svojim sinovima i unucima kako sam strogo postupio s Egipćanima, i kakve sam znakove izveo među njima, da biste znali da sam ja Gospod.“ ");
INSERT INTO srponstl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mojsije i Aron dođu k faraonu i kažu mu: „Ovako kaže Gospod, Bog Jevreja: ’Dokle ćeš odbijati da mi se pokoriš? Pusti moj narod da mi služi. ");
INSERT INTO srponstl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Odbiješ li da ih pustiš, čuvaj se, jer ću sutra dovesti skakavce na tvoju zemlju. ");
INSERT INTO srponstl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Oni će prekriti površinu, tako da se zemlja neće videti, pa će pojesti sve što je ostalo posle grada. Poješće ti čak i drveće što je tek počelo da raste na polju. ");
INSERT INTO srponstl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ispuniće tvoj dvor, kuće tvojih dvorana, i kuće svih Egipćana. Tako nešto nisu videli ni tvoji oci, a ni oci tvojih otaca, otkako su se pojavili na zemlji pa do dana današnjeg.’“ Mojsije se okrene, pa ode od faraona. ");
INSERT INTO srponstl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Tada faraonu rekoše njegovi dvorani: „Dokle će nas ovaj odvlačiti u propast? Pusti te ljude da idu, pa neka služe Gospodu, svome Bogu. Zar ne vidiš da je Egipat propao?“ ");
INSERT INTO srponstl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Vrate oni Mojsija i Arona k faraonu, a on im reče: „Idite i služite Gospodu, svome Bogu! Ko sve ide?“ ");
INSERT INTO srponstl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mojsije odgovori: „Svi mi idemo, stari i mladi, naši sinovi i ćerke, naša sitna i krupna stoka, jer idemo da proslavimo praznik Gospodu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Faraon mu na to reče: „Tako bio Gospod s vama, ako vas pustim sa vašim ženama i decom! Vidi se da nemate dobre namere. ");
INSERT INTO srponstl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nikako! Neka idu samo odrasli muškarci da služe Gospodu, jer to je ono što ste tražili.“ Time su bili oterani od faraona. ");
INSERT INTO srponstl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Tada Gospod reče Mojsiju: „Ispruži svoju ruku nad egipatskom zemljom, pa će skakavci navaliti na Egipat i pojesti sve bilje što je ostalo od grada.“ ");
INSERT INTO srponstl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mojsije ispruži svoj štap nad Egiptom, a Gospod navede na zemlju istočni vetar koji je duvao celi dan i celu noć. Ujutro je vetar doneo skakavce. ");
INSERT INTO srponstl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Skakavci su navalili na celu egipatsku zemlju i spustili se na celu zemlju u ogromnom broju. Toliko skakavaca nikada ranije nije bilo, a niti će ih ikad više biti. ");
INSERT INTO srponstl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Pokrili su površinu cele zemlje, tako da je bila tamna. Pojeli su sve bilje u zemlji i svaki plod na drveću koji je ostao od grada. U celoj egipatskoj zemlji nije ostalo ni lista na drvetu, ni travke na polju. ");
INSERT INTO srponstl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Faraon brže-bolje pozove Mojsija i Arona, pa im reče: „Zgrešio sam protiv Gospoda, vašeg Boga, i protiv vas. ");
INSERT INTO srponstl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Oprostite mi moj greh još ovaj put i pomolite se Gospodu, vašem Bogu, da otkloni od mene ovu pogibeljnu pošast.“ ");
INSERT INTO srponstl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kad je Mojsije otišao od faraona, pomolio se Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Tada je Gospod pokrenuo veoma jak zapadni vetar koji je poneo skakavce i sručio ih u Crveno more. Nijedan jedini skakavac nije ostao u egipatskoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ipak, Gospod je učinio da otvrdne srce faraonu, pa nije pustio Izrailjce. ");
INSERT INTO srponstl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Tada Gospod reče Mojsiju: „Ispruži svoju ruku prema nebu, pa nek se spusti tama na Egipat, takva tama da se može opipati.“ ");
INSERT INTO srponstl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mojsije ispruži svoju ruku prema nebu i spusti se gusta tama na celi Egipat. Trajala je tri dana. ");
INSERT INTO srponstl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ta tri dana čovek čoveka nije mogao da vidi, i niko se nije micao sa svoga mesta. Međutim, u svim izrailjskim domovima bilo je svetla. ");
INSERT INTO srponstl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Tada faraon pozva Mojsija i reče: „Idite i služite Gospodu! Samo vaša sitna i krupna stoka neka ostane ovde. Vaše žene i deca mogu da idu s vama.“ ");
INSERT INTO srponstl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mojsije odgovori: „Moraš nam dati da Gospodu, svome Bogu, prinesemo prinose i žrtve svespalnice. ");
INSERT INTO srponstl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Prema tome, s nama idu i naša stada, neće ostati ni papak, jer od njih treba da izaberemo ono što ćemo prineti Gospodu, našem Bogu. Naime, mi ne znamo šta da prinesemo Gospodu, dok ne dođemo tamo.“ ");
INSERT INTO srponstl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ali Gospod je otvrdnuo faraonovo srce, te nije pristao da ih pusti. ");
INSERT INTO srponstl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","„Odlazi! – reče faraon Mojsiju. Dobro pazi da se više ne pojavljuješ preda mnom. Onog dana kad mi lice vidiš, umrećeš.“ ");
INSERT INTO srponstl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mojsije mu reče: „Tako će i biti; više ti neću videti lice.“ ");
INSERT INTO srponstl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Gospod reče Mojsiju: „Dovešću još jednu pošast na faraona i na Egipat. Posle toga će vas pustiti da idete odavde. I ne samo da će vas pustiti, izgnaće vas odavde. ");
INSERT INTO srponstl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","A izrailjskom narodu reci da svaki čovek zatraži od svog suseda i svaka žena od svoje susetke dragocenosti od srebra i zlata.“ ");
INSERT INTO srponstl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Gospod je učinio da Egipćani budu naklonjeni narodu. Šta više, sam Mojsije je uživao veliki ugled u Egiptu, među faraonovim dvoranima i narodom. ");
INSERT INTO srponstl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mojsije reče: „Ovako kaže Gospod: ’Oko ponoći proći ću Egiptom, ");
INSERT INTO srponstl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","te će svaki prvenac u Egiptu umreti: od faraonovog prvenca koji sedi na prestolu, do prvenca sluškinje što stoji za žrvnjem, te sva prvina od stoke. ");
INSERT INTO srponstl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tada će u celom Egiptu nastati veliko naricanje, kakvog nije bilo niti će ikad više biti. ");
INSERT INTO srponstl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","A kod Izrailjaca ni pas neće zarežati na čoveka ili na životinju. Po tome ćete znati da je Gospod napravio razliku između Egipćana i Izrailjaca.’ ");
INSERT INTO srponstl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Onda će tvoji službenici doći k meni, pasti ničice preda mnom i reći mi: ’Odlazite i ti i sav narod koji ide za tobom!’ Posle toga ću otići.“ Mojsije ode od faraona kipteći od gneva. ");
INSERT INTO srponstl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Gospod reče Mojsiju: „Faraon vas neće poslušati, zato da bih umnožio svoja čudesa u Egiptu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mojsije i Aron su učinili sva ova čuda pred faraonom, ali je Gospod otvrdnuo srce faraonu, te nije pustio Izrailjce iz Egipta. ");
INSERT INTO srponstl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Gospod reče Mojsiju i Aronu u Egiptu: ");
INSERT INTO srponstl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","„Ovaj mesec neka bude za vas početak meseci. Neka vam bude prvi mesec u godini. ");
INSERT INTO srponstl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Recite ovo svoj zajednici izrailjskoj: ’Desetog dana ovog meseca neka svako nabavi po jagnje za svoju porodicu; jedno po domaćinstvu. ");
INSERT INTO srponstl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ako je domaćinstvo suviše malo da ga pojede, neka ga podeli sa najbližim susedom, prema broju osoba i prema količini koju svako može da pojede. ");
INSERT INTO srponstl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Jagnje neka bude bez mane, muško, staro godinu dana. Možete da izaberete bilo jagnje bilo jare. ");
INSERT INTO srponstl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Čuvajte ga do četrnaestog dana ovog meseca, a onda neka ga sva sabrana izrailjska zajednica zakolje uveče. ");
INSERT INTO srponstl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Zatim neka uzmu nešto krvi i poškrope njome oba dovratka i nadvratnik kuće u kojoj će se jagnje jesti. ");
INSERT INTO srponstl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Te iste noći neka jedu meso pečeno na vatri, sa beskvasnim hlebom i gorkim zeljem. ");
INSERT INTO srponstl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ne jedite sirovo ili kuvano meso, nego ispečeno na vatri: sa glavom, nogama i iznutricama. ");
INSERT INTO srponstl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ne ostavljajte ništa do jutra. Ako nešto preostane do jutra, spalite na vatri. ");
INSERT INTO srponstl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","A ovako ćete ga jesti: opasanog struka, sa obućom na nogama i štapom u ruci. Ješćete ga u žurbi: to je pasha Gospodnja. ");
INSERT INTO srponstl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Jer te ću noći proći egipatskom zemljom i pobiti sve prvence u Egiptu, kako ljude tako životinje. Ja sam Gospod, i ja ću kazniti sve egipatske bogove. ");
INSERT INTO srponstl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","A krv neka vam služi kao znak na kućama u kojima živite. Kad budem opazio krv, proći ću mimo vas, tako da vas neće zadesiti zatirući pomor kad budem udario egipatsku zemlju. ");
INSERT INTO srponstl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Taj dan neka vam bude spomen-dan. Slavite ga kao praznik Gospodu. Praznujte ga od pokolenja do pokolenja; to je trajna uredba. ");
INSERT INTO srponstl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sedam dana jedite beskvasni hleb. Prvoga dana uklonite sav kvasac iz vaših kuća. Jer, ko god bi jeo nešto s kvascem između prvog i sedmog dana, taj neka se istrebi iz Izrailja. ");
INSERT INTO srponstl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Prvoga dana održavajte sveti sabor, a tako i sedmoga dana. Tih dana ne radite nikakva posla. Pripremaćete samo ono što svako mora da jede. ");
INSERT INTO srponstl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Slavite praznik Beskvasnih hlebova, jer sam baš tog dana izveo vaše čete iz Egipta. Slavite, stoga, ovaj dan od pokolenja do pokolenja; to je trajna uredba. ");
INSERT INTO srponstl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Od večeri četrnaestoga dana prvoga meseca do večeri dvadeset prvoga dana istoga meseca jedite beskvasni hleb. ");
INSERT INTO srponstl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sedam dana ne sme da se nađe kvasca u vašim kućama. Ko god bi jeo nešto s kvascem, taj neka se istrebi iz izrailjske zajednice, bilo da je stranac ili domaći. ");
INSERT INTO srponstl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ne jedite ništa što je s kvascem. U svim svojim naseobinama jedite beskvasni hleb.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mojsije je zatim sazvao sve izrailjske starešine i rekao im: „Idite i nabavite jagnjad za vaše porodice, pa zakoljite pashalno jagnje. ");
INSERT INTO srponstl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Zatim uzmite kitu izopa i zamočite je u krv koja je u zdeli, pa tom krvlju iz zdele poškropite nadvratnik i oba dovratka. Niko od vas neka ne izlazi preko kućnih vrata do jutra. ");
INSERT INTO srponstl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Kad Gospod bude prolazio da potuče Egipćane, videće krv na nadvratniku i na oba dovratka, pa će proći pokraj vrata, te neće dozvoliti Pogubitelju da uđe kroz vrata vaših kuća i potuče vas. ");
INSERT INTO srponstl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ova uputstva držite kao trajnu uredbu za sebe i za svoju decu. ");
INSERT INTO srponstl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","I kada uđete u zemlju koju će vam Gospod dati, vršite ovaj obred. ");
INSERT INTO srponstl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kad vas zapitaju vaša deca: ’Kakav je to obred?’, ");
INSERT INTO srponstl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","vi im recite: ’Ovo je pashalna žrtva Gospodu, koji je prošao pokraj kuća Izrailjaca u Egiptu kad je ubijao Egipćane, dok je naše domove pošteđivao.’“ A narod je kleknuo i poklonio se. ");
INSERT INTO srponstl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Izrailjci odu i učine onako kako je Gospod zapovedio Mojsiju i Aronu. ");
INSERT INTO srponstl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","A u ponoć Gospod pobije sve prvence u egipatskoj zemlji: od faraonovog prvenca koji sedi na prestolu do prvenca zatvorenika u tamnici, a tako i prvinu stoke. ");
INSERT INTO srponstl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Faraon se probudio te noći, kao i svi njegovi dvorani i svi Egipćani, jer se glasan lelek otegnuo Egiptom. Naime, nije bilo kuće u kojoj nije bilo mrtvaca. ");
INSERT INTO srponstl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Iste noći je faraon pozvao Mojsija i Arona i rekao im: „Ustajte i odlazite od mog naroda i vi i Izrailjci! Idite i služite Gospodu kako ste zahtevali. ");
INSERT INTO srponstl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Povedite svoju sitnu i krupnu stoku kako ste tražili, i idite pa i mene blagoslovite.“ ");
INSERT INTO srponstl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egipćani su terali narod da što pre ode iz zemlje, jer su govorili: „Svi ćemo izginuti!“ ");
INSERT INTO srponstl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Tako je narod poneo svoje još neuskislo testo, noseći ga na ramenima u naćvama uvijenim u ogrtače. ");
INSERT INTO srponstl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Izrailjci su, takođe, učinili onako kako im je Mojsije rekao: tražili su od Egipćana dragocenosti od srebra i zlata, i odeću. ");
INSERT INTO srponstl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Gospod je učinio da Egipćani budu blagonakloni prema narodu, pa su davali. Tako su oplenili Egipćane. ");
INSERT INTO srponstl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Izrailjci se zapute iz Ramese prema Sokotu. Bilo je oko šest stotina hiljada ratnika-pešaka, ne računajući žene i decu. ");
INSERT INTO srponstl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Sa njima je otišlo i mnoštvo različitih naroda i veoma mnogo stoke, krupne i sitne. ");
INSERT INTO srponstl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Zatim su od testa koje su poneli iz Egipta ispekli beskvasne lepinje. Testo nije bilo uskislo, jer su bili isterani iz Egipta, te nisu mogli da se duže zadržavaju. Zato nisu pripremili ni zalihe hrane za put. ");
INSERT INTO srponstl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Izrailjci su u Egiptu proveli ukupno četiri stotine trideset godina. ");
INSERT INTO srponstl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","A kada se navršilo četiri stotine trideset godina, na sam taj dan, sve čete Gospodnje su izašle iz egipatske zemlje. ");
INSERT INTO srponstl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Pošto je te noći Gospod probdeo da ih izvede iz Egipta, ova noć će za sve Izrailjce biti noć bdenja Gospodu za sva pokolenja. ");
INSERT INTO srponstl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Gospod reče Mojsiju i Aronu: „Ovo je uredba za Pashu: Nijedan stranac ne sme jesti pashalnu večeru. ");
INSERT INTO srponstl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Svaki rob, kupljen novcem i obrezan, može je jesti. ");
INSERT INTO srponstl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ipak, došljak ili najamnik ne mogu je jesti. ");
INSERT INTO srponstl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Jedite je u jednoj kući. Meso ne iznosite iz kuće. Ne lomite ni jednu kost žrtve. ");
INSERT INTO srponstl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Sva izrailjska zajednica mora da se pridržava ovoga. ");
INSERT INTO srponstl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ako stranac koji boravi kod tebe želi da proslavi Pashu Gospodu, svi muški u njegovom domu moraju da se obrežu. Tek onda može da je proslavi, jer će biti kao i žitelj zemlje. Nijedan neobrezani ne može da pristupi večeri. ");
INSERT INTO srponstl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Isti zakon neka važi i za domaćeg i za stranca koji boravi kod tebe.“ ");
INSERT INTO srponstl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Svi Izrailjci su učinili onako kako je Gospod zapovedio Mojsiju i Aronu. ");
INSERT INTO srponstl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Tog istog dana je Gospod izveo Izrailjce iz Egipta, četu po četu. ");
INSERT INTO srponstl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","„Posvetite mi svakog prvenca. Svako muško dete među Izrailjcima – prvenac majčine utrobe, kao i sva prvina stoke, meni pripadaju.“ ");
INSERT INTO srponstl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mojsije reče narodu: „Pamtite ovaj dan u koji ste izašli iz Egipta, iz kuće ropstva, jer vas je Gospod snažnom rukom izveo odande. Hleb s kvascem neka se ne jede! ");
INSERT INTO srponstl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Danas izlazite, u mesecu avivu. ");
INSERT INTO srponstl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","A kad te Gospod uvede u zemlju Hananaca, Hetita, Amorejaca, Evejaca i Jevusejaca, za koju se zakleo vašim ocima da će vam je dati, zemlju kojom teku med i mleko, vršićeš ovaj obred u ovom mesecu: ");
INSERT INTO srponstl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sedam dana jedite beskvasni hleb, a sedmoga dana neka bude praznik Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Beskvasni hleb će se jesti sedam dana. Hleb s kvascem ne sme ni da se vidi. Kvascu nigde ni traga da ne bude na svom tvom području. ");
INSERT INTO srponstl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Tog dana ćeš reći svome sinu: ’To je zbog onog što je Gospod učinio za mene kad sam izašao iz Egipta.’ ");
INSERT INTO srponstl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","To će ti biti kao znak na tvojoj ruci i podsetnik pred očima, da bi Gospodnji Zakon bio na tvojim ustima. Jer, Gospod te je snažnom rukom izveo iz Egipta. ");
INSERT INTO srponstl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Vršićeš ovu uredbu svake godine u naznačeno vreme. ");
INSERT INTO srponstl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","A kad te Gospod dovede u zemlju Hananaca, kako se zakleo tebi i tvojim ocima, i preda ti je, ");
INSERT INTO srponstl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","odvojićeš svakog prvenca majčine utrobe Gospodu. Isto tako će i sva muška prvina stoke pripadati Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Svako prvorođeno magare ćeš otkupiti jagnjetom ili jaretom. Ako ga ne otkupiš, slomi mu vrat. Otkupićeš i svakog prvenca od svojih sinova. ");
INSERT INTO srponstl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Kad te tvoj sin danas-sutra upita: ’Šta to znači?’, ti mu reci: ’Gospod nas je snagom svoje ruke izveo iz Egipta, iz kuće ropstva. ");
INSERT INTO srponstl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Kad je faraon tvrdoglavo odbio da nas pusti, Gospod je pobio sve prvence u egipatskoj zemlji: od prvenaca ljudi do prvine stoke. Zato ja Gospodu prinosim na žrtvu svaku mušku prvinu majčine utrobe, a svakog prvenca među svojim sinovima otkupljujem. ");
INSERT INTO srponstl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","To će ti biti kao znak na ruci i kao podsetnik pred tvojim očima da nas je Gospod snagom svoje ruke izveo iz Egipta.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","A kad je faraon pustio narod da ide, Gospod ih nije poveo putem koji vodi u filistejsku zemlju, iako je onuda bilo bliže. Gospod je, naime, rekao: „Kad narod vidi ratovanje, mogao bi da se predomisli i vrati u Egipat.“ ");
INSERT INTO srponstl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Zato ih je poveo zaobilaznim putem kroz pustinju prema Crvenom moru. Izrailjci su otišli iz Egipta u punoj ratnoj spremi. ");
INSERT INTO srponstl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mojsije je sa sobom poneo Josifove kosti, jer je ovaj tražio od Izrailjaca da mu se svečano zakunu: „Bog će vam svakako priteći u pomoć. Tada ćete odavde poneti sa sobom i moje kosti.“ ");
INSERT INTO srponstl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Izrailjci su krenuli iz Sokota, a utaborili se u Etamu, na rubu pustinje. ");
INSERT INTO srponstl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Gospod je išao pred njima danju u stubu od oblaka da im pokazuje put, a noću u stubu od ognja, da im osvetljava put, da bi mogli da putuju i danju i noću. ");
INSERT INTO srponstl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Stub od oblaka pred narodom nije odstupao danju, niti stub od ognja noću. ");
INSERT INTO srponstl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","„Reci Izrailjcima neka se vrate i utabore pred Pi-Hahirotom između Migdola i mora, nasuprot Vel-Sefona. Utaborite se nasuprot ovom mestu, uz more. ");
INSERT INTO srponstl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Faraon će reći: ’Izrailjci besciljno tumaraju zemljom; opkolila ih je pustinja.’ ");
INSERT INTO srponstl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","No, ja ću otvrdnuti srce faraonu, i on će krenuti u poteru za njima. Međutim, ja ću se proslaviti nad faraonom i svom njegovom vojskom. Tada će Egipćani znati da sam ja Gospod.“ Izrailjci tako i učine. ");
INSERT INTO srponstl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kad su egipatskog cara izvestili da je narod pobegao, faraon i njegovi dvorani se predomisle o narodu. Rekoše: „Šta to učinismo! Pustili smo Izrailjce i oni nam neće više robovati!“ ");
INSERT INTO srponstl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Zato je upregnuo svoja bojna kola i poveo svoju vojsku sa sobom. ");
INSERT INTO srponstl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Poveo je šest stotina najboljih bojnih kola zajedno sa ostalim bojnim kolima po Egiptu. Sva kola su imala zapovednike. ");
INSERT INTO srponstl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Gospod je otvrdnuo srce faraonu, egipatskom caru, te je ovaj krenuo u poteru za Izrailjcima, koji su izašli s uzdignutom pesnicom. ");
INSERT INTO srponstl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Egipćani su se dali u poteru za njima sa svim faraonovim konjima, bojnim kolima, konjanicima i vojskom, i konačno ih stigli kod Pi-Hahirota, nasuprot Vel-Sefona. ");
INSERT INTO srponstl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kad se faraon približio, Izrailjci su se osvrnuli i opazili da su im Egipćani za petama. U velikom strahu, Izrailjci zavape Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Onda rekoše Mojsiju: „Zar u Egiptu nije bilo grobova, nego si nas doveo tu u pustinju da pomremo? Šta je trebalo da nas izvodiš iz Egipta? ");
INSERT INTO srponstl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Nismo li ti ovo govorili i u Egiptu: ’Idi od nas, neka služimo Egipćanima! Jer bolje nam je da robujemo Egipćanima, nego da pomremo u pustinji!’“ ");
INSERT INTO srponstl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ali Mojsije odgovori narodu: „Ne bojte se! Ostanite na svom mestu, pa ćete videti šta će Gospod učiniti da vas spase danas. Naime, Egipćane koje danas vidite nikada više nećete videti. ");
INSERT INTO srponstl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Gospod će se boriti za vas. Budite spokojni!“ ");
INSERT INTO srponstl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Gospod upita Mojsija: „Zašto vapiš k meni? Reci Izrailjcima da krenu na put. ");
INSERT INTO srponstl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","A ti podigni svoj štap, ispruži svoju ruku nad morem i razdeli ga na dvoje, da Izrailjci mogu da prođu sred mora po suvom. ");
INSERT INTO srponstl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ja ću, evo, otvrdnuti srce Egipćanima, te će oni krenuti za njima, ali ja ću se proslaviti nad faraonom i svom njegovom vojskom, njegovim bojnim kolima i konjanicima. ");
INSERT INTO srponstl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Kad se proslavim nad faraonom, njegovim bojnim kolima i konjanicima, Egipćani će znati da sam ja Gospod.“ ");
INSERT INTO srponstl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Tada se Anđeo Gospodnji, koji je išao pred izrailjskim taborom, premestio iza njih. Stub od oblaka pred njima se takođe pomerio, došao im iza leđa i stao, ");
INSERT INTO srponstl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","našavši se između egipatskog tabora i izrailjskog tabora. Oblak je noću zamračivao jedne, dok je drugima svetleo, tako da cele noći nisu mogli da priđu jedni drugima. ");
INSERT INTO srponstl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mojsije ispruži svoju ruku nad morem, a Gospod pošalje jak istočni vetar koji je uzbijao vodu cele noći, učinivši da se more isuši. Voda se podelila, ");
INSERT INTO srponstl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","pa su Izrailjci hodali posred mora po suvom dnu. Voda im je stajala kao zid s desne i leve strane. ");
INSERT INTO srponstl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Tada se Egipćani sa svim faraonovim konjima, bojnim kolima i konjanicima spuste u more i počnu da ih gone. ");
INSERT INTO srponstl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Pred samu zoru, Gospod pogleda dole iz stuba od ognja i oblaka na egipatsku vojsku i u nju unese pometnju. ");
INSERT INTO srponstl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Zaglavio je točkove na bojnim kolima, tako da su se teškom mukom pokretali. „Bežimo od Izrailjaca – povikaše Egipćani – jer se Gospod bori za njih protiv Egipćana!“ ");
INSERT INTO srponstl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Gospod reče Mojsiju: „Ispruži ruku nad morem, da se voda vrati na Egipćane, na njihova bojna kola i konjanike.“ ");
INSERT INTO srponstl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mojsije ispruži ruku nad morem, i u osvit zore se voda vrati na svoje mesto. Egipćani su bežali od vode, ali ih je Gospod sručio usred mora. ");
INSERT INTO srponstl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Voda se vratila i potopila bojna kola i konjanike, svu faraonovu vojsku koja je bila krenula za Izrailjcima u more. Ni jedan od njih nije preživeo. ");
INSERT INTO srponstl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","A Izrailjci su hodali posred mora po suvom dnu, dok su im zidovi vode stajali s desna i s leva. ");
INSERT INTO srponstl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Tog dana je Gospod izbavio Izrailjce iz ruku Egipćana, a Izrailjci su videli mrtve Egipćane na morskoj obali. ");
INSERT INTO srponstl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Kad su Izrailjci videli veliku silu koju je Gospod pokazao nad Egipćanima, narod se pobojao Gospoda, pa su poverovali Gospodu i njegovom sluzi Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tada su Mojsije i Izrailjci zapevali ovu pesmu u slavu Gospoda: „Gospodu ću zapevati, jer se silno proslavio, konja i konjanika u more je svalio. ");
INSERT INTO srponstl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Gospod je moja sila i pesma, on mi je spasenje. On je moj Bog, slaviću Boga oca svoga, njega ću ja uzvisivati. ");
INSERT INTO srponstl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Gospod je ratnik, Gospod mu je ime. ");
INSERT INTO srponstl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Kola je faraonova i vojsku njegovu u more sručio, čelnici se vojni u moru Crvenom podavili. Tama ih je prekrila, ");
INSERT INTO srponstl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","u dubine su morske kao kamen potonuli. ");
INSERT INTO srponstl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Desnica se tvoja, Gospode, proslavila silom, desnica je tvoja, Gospode, zatrla dušmana. ");
INSERT INTO srponstl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Veličanstvom svoje slave oborio si one što se protiv tebe bune, svoj gnev si kao oganj poslao, proždro ih je kao slamu. ");
INSERT INTO srponstl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Na dah tvojih nozdrva sabraše se vode, stihije se morske kao zid uspraviše, u srcu mora bezdan se morski u tlo čvrsto pretvori. ");
INSERT INTO srponstl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Dušmanin reče: ’Goniću ih, uhvatiti, plen svoj podeliti, zasitiću njima svoju dušu; svoj ću mač isukati i silom ih porobiti.’ ");
INSERT INTO srponstl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Na dah tvojih usta more ih je prekrilo, potonuše kao olovo u moćnim vodama. ");
INSERT INTO srponstl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ko je kao ti, Gospode, među bogovima? Ko je kao ti, veličanstven u svetosti, strašan u slavi, tvorac čudesa? ");
INSERT INTO srponstl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ispružio si svoju desnicu i zemlja ih je progutala. ");
INSERT INTO srponstl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Svojom milošću ti si izveo narod, njega si ti otkupio, snagom si ga svojom poveo k stanu svoje svetosti. ");
INSERT INTO srponstl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Čuće to narodi, od straha zadrhtaće, strava obuzeće žitelje filistejske. ");
INSERT INTO srponstl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Smeli su se vladari edomski, zastrepeli knezovi moavski, klonuli su svi žitelji Hanana. ");
INSERT INTO srponstl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Užas i strah njih je obuzeo, mišicom si ih svojom moćnom zanemeo, skamenio, dok tvoj narod, Gospode, ne prođe, dok narod, koji si ti stekao, ne prođe. ");
INSERT INTO srponstl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Dovešćeš ih i zasaditi na gori koja tebi pripada, na mestu koje ti, o, Gospode, boravištem svojim učini, Svetilištem, Gospode, što ga tvoje ruke utemeljiše. ");
INSERT INTO srponstl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Gospod će carevati u veke vekova.“ ");
INSERT INTO srponstl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Kad su, dakle, faraonovi konji, bojna kola i konjanici pošli za njima u more, Gospod je vratio morske vode na njih, dok su Izrailjci hodali po suvom usred mora. ");
INSERT INTO srponstl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Potom je Aronova sestra Marija, proročica, uzela bubanj u ruku, a sve ostale žene su je pratile s bubnjevima i plešući. ");
INSERT INTO srponstl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Marija im je zapevala: „Zapevajte Gospodu jer se silno proslavio, konja i konjanika u more je svalio.“ ");
INSERT INTO srponstl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mojsije je poveo Izrailjce od Crvenog mora. Krenuli su prema pustinji Sur. Tri dana su putovali pustinjom, ali nisu našli vodu. ");
INSERT INTO srponstl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kad su došli u Maru, nisu mogli da piju vodu kod Mare, jer je bila gorka. Zato su to mesto nazvali Mara. ");
INSERT INTO srponstl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Narod je gunđao Mojsiju: „Šta ćemo da pijemo?“ ");
INSERT INTO srponstl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mojsije zavapi Gospodu. Gospod mu pokaže neko drvo. Mojsije baci to drvo u vodu i voda postane slatka. Tamo im je Gospod dao uredbe i pravo, i tamo ih je stavio na kušnju. ");
INSERT INTO srponstl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Rekao je: „Ako pažljivo slušaš glas Gospoda, Boga svoga, činiš što je pravo pred njim, i slušaš njegove zapovesti, te držiš sve njegove uredbe, nijedna od pošasti koje sam doveo na Egipat neće doći na tebe. Jer sam ja, Gospod, tvoj lekar.“ ");
INSERT INTO srponstl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Zatim su došli u Elim, gde je bilo dvanaest izvora i sedamdeset palmi. Utaborili su se tu, uz vodu. ");
INSERT INTO srponstl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Petnaestoga dana drugog meseca nakon izlaska iz Egipta, cela izrailjska zajednica ode iz Elima i dođe u pustinju Sin, koja se nalazi između Elima i Sinaja. ");
INSERT INTO srponstl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","U pustinji je cela izrailjska zajednica počela da gunđa protiv Mojsija i Arona. ");
INSERT INTO srponstl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Izrailjci su im govorili: „E, da smo samo pomrli od Gospodnje ruke u Egiptu! Tamo smo sedeli oko lonaca s mesom i jeli hleba do mile volje. A vi ste nas doveli u ovu pustinju da pomorite glađu sav ovaj zbor.“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Tada Gospod reče Mojsiju: „Evo, poslaću vam kišu hleba s neba. Neka narod izlazi i skuplja koliko mu je potrebno za taj dan. Tako ću ih iskušati da vidim hoće li slediti moj Zakon ili ne. ");
INSERT INTO srponstl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Šestog dana neka donesu i pripreme duplu meru onoga što skupljaju svakog dana.“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mojsije i Aron rekoše svim Izrailjcima: „Uveče ćete uvideti da vas je Gospod izveo iz Egipta, ");
INSERT INTO srponstl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","a ujutro ćete videti Gospodnju slavu, jer je Gospod čuo kako ste gunđali protiv njega. Ko smo mi da gunđate protiv nas?“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mojsije produži: „Uveče će vam Gospod dati da jedete mesa, a ujutro hleba do mile volje, jer je Gospod čuo kako mu prigovarate. Vi, naime, ne gunđate protiv nas, nego protiv Gospoda.“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mojsije reče Aronu: „Reci svoj izrailjskoj zajednici: ’Pristupite Gospodu jer je čuo vaše gunđanje!’“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Dok je Aron govorio svoj izrailjskoj zajednici, oni se okrenu prema pustinji, i tada se pojavi u oblaku slava Gospodnja. ");
INSERT INTO srponstl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Tada Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","„Čuo sam gunđanje Izrailjaca. Reci im ovako: ’Uveče ćete jesti meso, a ujutro hleba do mile volje. Tada ćete znati da sam ja Gospod, vaš Bog.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Uveče dolete prepelice i prekriju tabor, a ujutro je rosa bila svuda oko tabora. ");
INSERT INTO srponstl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Kad se sloj rose digao, površina pustinje je bila pokrivena nečim sitnim, pahuljastim, sličnim mrazu po zemlji. ");
INSERT INTO srponstl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Videvši to, Izrailjci su pitali jedni druge: „Šta je ovo?“, jer nisu znali šta je to. Mojsije im reče: „To je hleb koji vam je Gospod dao za hranu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ovo vam je Gospod zapovedio: „Skupite onoliko koliko je svakome dovoljno za hranu. Uzmite po gomer za svakog člana u svome šatoru.“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Izrailjci tako i učine. Neki su skupili više neki manje. ");
INSERT INTO srponstl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Kad su izmerili po gomer, onome koji je skupio više nije preostalo, a niti je nedostajalo onome koji je skupio manje; svako je skupio onoliko koliko mu je bilo potrebno. ");
INSERT INTO srponstl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mojsije im reče: „Niko da ne ostavlja od toga do sledećeg jutra.“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ali oni nisu slušali Mojsija, nego su ostavili nešto od toga do sutra. Međutim, to se ucrvlja i usmrdi. Mojsije se razgnevi na njih. ");
INSERT INTO srponstl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","To su skupljali svakoga jutra, svako koliko mu je trebalo. Ali čim bi granulo sunce, mana bi se istopila. ");
INSERT INTO srponstl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Šestog dana su skupili dva gomera po osobi. Svi knezovi zajednice dođu i izveste Mojsija o ovome. ");
INSERT INTO srponstl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mojsije im reče: „Gospod je zapovedio ovo: ’Sutra je dan odmora, sveta subota Gospodu. Pecite i kuvajte što god hoćete. Sve što ostane, sklonite i čuvajte za sutra.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Izrailjci ostave to za sutra, kako im je Mojsije zapovedio. To im se nije usmrdelo, a nije bilo ni crva u tome. ");
INSERT INTO srponstl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mojsije im reče: „Jedite danas, jer je danas subota Gospodu. Danas nećete naći manu na zemlji. ");
INSERT INTO srponstl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Skupljajte je šest dana, a sedmoga dana, u subotu, neće je biti.“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ipak, desilo se da su neki iz naroda i sedmoga dana izašli da je skupljaju, ali je nisu našli. ");
INSERT INTO srponstl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Gospod reče Mojsiju: „Dokle ćete odbijati da slušate moje zapovesti i zakone? ");
INSERT INTO srponstl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Držite na umu da vam je Gospod dao subotu; zato vam i daje hranu šestog dana za dva dana. Svako neka ostane gde je; neka niko ne izlazi iz svoga doma na sedmi dan.“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Tako se narod odmarao sedmoga dana. ");
INSERT INTO srponstl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Izrailjski narod je tu hranu nazvao manom. Bila je kao zrno korijandra; bila je bela i imala je ukus medenog kolačića. ");
INSERT INTO srponstl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mojsije reče: „Ovo je naredba koju je Gospod izdao: ’Napunite jedan gomer da se čuva za vaša buduća pokolenja, da vide hranu kojom sam vas hranio u pustinji kad sam vas izveo iz Egipta.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mojsije reče Aronu: „Uzmi jednu posudu i stavi u nju pun gomer mane, pa je položi pred Gospodom, da se čuva za buduća pokolenja.“ ");
INSERT INTO srponstl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aron je položio manu pred Svedočanstvo na čuvanje, kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Izrailjci su se hranili manom četrdeset godina, dok nisu ušli u zemlju gde su se naselili. Manom su se hranili dok nisu došli na granicu hananske zemlje. ");
INSERT INTO srponstl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Gomer je deseti deo efe.) ");
INSERT INTO srponstl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Cela izrailjska zajednica je krenula dalje iz pustinje Sin, putujući od postaje do postaje, kako je Gospod zapovedio. Utaborili su se kod Rafidina, ali tamo nije bilo vode da narod pije. ");
INSERT INTO srponstl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Tada je narod počeo da se svađa s Mojsijem, govoreći: „Daj nam da pijemo vode!“ Mojsije im odgovori: „Zašto se sa mnom svađate? Zašto iskušavate Gospoda?“ ");
INSERT INTO srponstl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Narod je bio žedan, pa je gunđao protiv Mojsija. Rekli su mu: „Zašto si nas izveo iz Egipta? Zar hoćeš da žeđu pomoriš nas, našu decu i našu stoku?“ ");
INSERT INTO srponstl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mojsije zavapi Gospodu: „Šta da radim s ovim narodom? Još malo pa će da me kamenuju!“ ");
INSERT INTO srponstl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Gospod odgovori Mojsiju: „Izađi pred narod i povedi sa sobom nekoliko izrailjskih starešina. Zatim uzmi u ruku svoj štap kojim si udario po Nilu, pa pođi. ");
INSERT INTO srponstl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Evo, ja ću stati pred tobom na stenu kod Horiva, a ti ćeš udariti po steni i iz nje će poteći voda da narod pije.“ Mojsije učini tako na oči izrailjskih starešina. ");
INSERT INTO srponstl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","To mesto je nazvao Masa i Meriva, jer su se tu Izrailjci svađali i iskušavali Gospoda govoreći: „Da li je Gospod među nama ili nije?“ ");
INSERT INTO srponstl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Tada naiđu Amaličani i zavojšte protiv Izrailjaca kod Rafidina. ");
INSERT INTO srponstl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mojsije reče Isusu Navinu: „Izaberi ljude, pa idi i zametni bitku protiv Amaličana. A ja ću sutra stati na vrh brda s Božijim štapom u svojoj ruci.“ ");
INSERT INTO srponstl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Isus Navin učini onako kako mu je rekao Mojsije, te ode u boj protiv Amaličana. A Mojsije, Aron i Or se popnu na vrh brda. ");
INSERT INTO srponstl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Dok su Mojsijeve ruke bile uzdignute, Izrailjci bi pobeđivali, a kad bi ih spustio, Amaličani bi pobeđivali. ");
INSERT INTO srponstl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","No, Mojsijeve ruke se umore. Zato su uzeli kamen i stavili ga pod njega, te je seo, a Aron i Or su mu držali ruke, jedan s jedne strane, a drugi s druge. Tako mu ruke nisu klonule do zalaska sunca. ");
INSERT INTO srponstl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Isus Navin porazi Amalika i njegov narod oštricom mača. ");
INSERT INTO srponstl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Tada Gospod reče Mojsiju: „Zapiši ovo u knjigu da se pamti i prenesi ovo Isusu Navinu: potpuno ću izbrisati sećanje na Amalika pod nebom!“ ");
INSERT INTO srponstl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mojsije podigne žrtvenik i nazva ga – „Gospod je moja zastava“ – ");
INSERT INTO srponstl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","jer je rekao: „Pošto se ruka podigla na Gospodnji presto, Gospod će voditi rat protiv Amalika od naraštaja do naraštaja.“ ");
INSERT INTO srponstl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mojsijev tast Jotor, madijanski sveštenik, je čuo sve što je Gospod učinio za Mojsija i za celi izrailjski narod, i kako je izveo Izrailjce iz Egipta. ");
INSERT INTO srponstl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Njegov tast, Jotor, je poveo sa sobom Mojsijevu ženu Seforu, koju je Mojsije bio otpustio ");
INSERT INTO srponstl_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","i njena dva sina. Jednome je bilo ime Girsam, jer je rekao: „Ja sam došljak u tuđoj zemlji.“ ");
INSERT INTO srponstl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Drugome je bilo ime Eliezer, jer je rekao: „Bog moga oca mi je bio u pomoći, i izbavio me od faraonovog mača.“ ");
INSERT INTO srponstl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Mojsijev tast, Jotor, i Mojsijeva žena i sinovi dođu u pustinju, gde se Mojsije bio utaborio kod Božije gore. ");
INSERT INTO srponstl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","On poruči Mojsiju: „Ja, tvoj tast Jotor, dolazim k tebi s tvojom ženom i njena dva sina.“ ");
INSERT INTO srponstl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mojsije je krenuo u susret svome tastu; poklonio mu se i poljubio ga. Upitali su se za zdravlje, pa su ušli u šator. ");
INSERT INTO srponstl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Tada je Mojsije ispričao svome tastu o svemu što je Gospod učinio s faraonom i Egipćanima zbog Izrailja, i o svim nevoljama koje su ih snašle na putu, te kako ih je Gospod izbavio. ");
INSERT INTO srponstl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jotor se radovao svemu dobru što je Gospod učinio Izrailjcima i kako ih je izbavio iz ruku Egipćana. ");
INSERT INTO srponstl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jotor reče: „Neka je blagosloven Gospod, koji vas je izbavio iz ruku Egipćana i ruku faraonovih, koji je izbavio narod iz egipatskih ruku. ");
INSERT INTO srponstl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Sad znam da je Gospod veći od svih bogova; tako im je učinio jer su oholo postupali s Izrailjem!“ ");
INSERT INTO srponstl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Tada je Jotor, Mojsijev tast, prineo žrtvu svespalnicu i druge žrtve Bogu. Zatim su došli Aron i sve izrailjske starešine da s Mojsijevim tastom pristupe obedu u Božijem prisustvu. ");
INSERT INTO srponstl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Sutradan je Mojsije seo da rešava sporove među narodom. Narod je stajao oko njega od jutra do večeri. ");
INSERT INTO srponstl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Kad je Mojsijev tast video šta sve Mojsije čini za narod, zapitao ga je: „Što se ti toliko baviš narodom? Zašto ti sediš sam, a sav narod stoji oko tebe od jutra do večeri?“ ");
INSERT INTO srponstl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mojsije odgovori svome tastu: „Zato što narod dolazi k meni da traži pravdu od Boga. ");
INSERT INTO srponstl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kad imaju neki spor, oni dolaze k meni. Onda ja presudim između jednog i drugog, i uputim ih u Božije odredbe i zakone.“ ");
INSERT INTO srponstl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","„Nije dobro to što radiš – reče mu njegov tast. ");
INSERT INTO srponstl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","I ti i ovaj narod s tobom ćete se potpuno iscrpsti. Pretežak je to posao za tebe; sam ga ne možeš obavljati. ");
INSERT INTO srponstl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Poslušaj sad moj savet koji ću ti dati i Bog će biti s tobom: ti zastupaj narod pred Bogom i iznosi njihove sporove pred Boga. ");
INSERT INTO srponstl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Objašnjavaj im uredbe i zakone i upućuj ih na put kojim treba da idu i na dela koja treba da čine. ");
INSERT INTO srponstl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ali izdvoj od sveg naroda sposobne ljude, bogobojazne i pouzdane, koji mrze mito, i postavi ih za glavare nad skupinama od hiljadu, stotinu, pedeset i deset. ");
INSERT INTO srponstl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Neka oni sude narodu u svako doba, a pred tebe neka iznose veće sporove. Manje sporove neka rešavaju sami. Olakšaj sebi teret: neka ga oni s tobom nose. ");
INSERT INTO srponstl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ako ovako učiniš, i Bog ti tako zapovedi, moći ćeš da izdržiš, a sav će ovaj narod zadovoljno otići svojoj kući.“ ");
INSERT INTO srponstl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mojsije je poslušao savet svoga tasta, pa je učinio kako je ovaj rekao. ");
INSERT INTO srponstl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mojsije je izabrao sposobne ljude od svih Izrailjaca, i postavio ih za glavare narodu: načelnike nad skupinama od hiljadu, stotinu, pedeset i deset, ");
INSERT INTO srponstl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","da sude narodu u svako doba. Teže slučajeve su iznosili pred Mojsija, a sve manje sporove su rešavali sami. ");
INSERT INTO srponstl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Zatim Mojsije otpremi svoga tasta, te se ovaj vrati u svoju zemlju. ");
INSERT INTO srponstl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Prvog dana trećeg meseca izlaska iz Egipta, na sam taj dan, Izrailjci dođu u Sinajsku pustinju. ");
INSERT INTO srponstl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Oni su bili krenuli iz Rafidina, pa su došli u Sinajsku pustinju. Izrailjci su se utaborili tu, u pustinji, pred gorom. ");
INSERT INTO srponstl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mojsije se uspne k Bogu, a Gospod ga pozove s gore i reče mu: „Ovako reci domu Jakovljevom, obznani Izrailjcima: ");
INSERT INTO srponstl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","’Vi ste videli šta sam učinio Egipćanima i kako sam vas nosio na orlovskim krilima i doveo vas k sebi. ");
INSERT INTO srponstl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","A sad, ako budete pažljivo slušali moj glas i držali moj savez, bićete mi najdragocenija svojina među svim narodima, jer moja je sva zemlja. ");
INSERT INTO srponstl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Vi ćete mi biti carstvo sveštenika i sveti narod.’ Ovo su reči koje ćeš preneti izrailjskom narodu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mojsije se vrati, okupi narodne starešine i prenese im sve što mu je Gospod zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","A sav narod odgovori u jedan glas: „Učinićemo sve što je Gospod rekao.“ Mojsije je preneo Gospodu što je narod rekao. ");
INSERT INTO srponstl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Gospod reče Mojsiju: „Evo, ja ću doći k tebi u gustom oblaku da narod čuje kad budem govorio s tobom, da ti zauvek veruju.“ Kad je Mojsije preneo Gospodu reči naroda, ");
INSERT INTO srponstl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Gospod mu reče: „Idi k narodu i posveti ih danas i sutra. Neka operu svoju odeću. ");
INSERT INTO srponstl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Trećeg dana neka budu spremni, jer će trećeg dana Gospod sići na goru Sinaj na oči sveg naroda. ");
INSERT INTO srponstl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Označi granicu oko gore za narod, i reci im: ’Pazite da se ne penjete na goru niti da se dotičite njenog podnožja! Ko se dotakne brda, sigurno će umreti. ");
INSERT INTO srponstl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ničija ruka neka ga se ne dotiče, jer će takav biti zasut kamenjem ili ustreljen strelom; bilo životinja ili čovek, neka ne ostane na životu. Kad se začuje otegnuti glas ovnujskog roga, tada neka se popnu na goru.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mojsije siđe s gore k narodu i posveti narod. Oni operu svoju odeću. ");
INSERT INTO srponstl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Mojsije im naredi: „Budite spremni za treći dan. Ne dotičite se žena!“ ");
INSERT INTO srponstl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","A trećega dana, u sam osvit, razlegne se grmljavina, munje počnu da sevaju, a gust se oblak nadvije nad gorom. Glas trube snažno odjeknu, a sav narod u taboru zadrhta od straha. ");
INSERT INTO srponstl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mojsije povede narod iz tabora u susret Bogu. Stali su u podnožju gore. ");
INSERT INTO srponstl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Cela gora Sinaj je bila obavijena dimom, jer je Gospod na nju sišao u ognju. Dim se dizao kao iz peći, a sva se gora tresla. ");
INSERT INTO srponstl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Zvuk trube bivao je sve jači i jači. Mojsije je govorio, a Bog mu je glasno odgovarao. ");
INSERT INTO srponstl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","I tako je Gospod sišao na goru Sinaj, na njen vrh. Tada je Gospod pozvao Mojsija da se uspne na vrh gore. Mojsije se uspne. ");
INSERT INTO srponstl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Gospod reče Mojsiju: „Siđi i upozori narod da se ne probija prema Gospodu da ga vidi, inače će mnogi izginuti. ");
INSERT INTO srponstl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","A sveštenici koji prilaze Gospodu neka se posvete, da ih Gospod ne bi pobio.“ ");
INSERT INTO srponstl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","„Narod ne može da uziđe na goru Sinaj – reče Mojsije – jer si nas ti sam opomenuo: ’Označi granice oko gore i proglasi je svetom.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","„Siđi, pa se uspni s Aronom – reče Gospod Mojsiju. Ali sveštenici i narod neka se ne probijaju gore, ka Gospodu, da ih ne bi pobio.“ ");
INSERT INTO srponstl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mojsije siđe k narodu i saopšti mu sve to. ");
INSERT INTO srponstl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","I Bog izgovori sve ove reči: ");
INSERT INTO srponstl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","„Ja sam Gospod, Bog tvoj, koji sam te izveo iz zemlje egipatske, iz kuće ropstva. ");
INSERT INTO srponstl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Nemoj imati druge bogove osim mene. ");
INSERT INTO srponstl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ne pravi sebi idola, ni obličja od bilo čega što je gore na nebesima, ili dole na zemlji, ili u vodi pod zemljom. ");
INSERT INTO srponstl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ne klanjaj im se, niti im služi. Jer sam ja, Gospod, tvoj Bog, ljubomorni Bog, koji kažnjava decu zbog krivice njihovih otaca, do trećeg i četvrtog kolena – onih koji me mrze, ");
INSERT INTO srponstl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ali iskazujem milost hiljadama koji me ljube i vrše moje zapovesti. ");
INSERT INTO srponstl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ne uzimaj uzalud ime Gospoda, Boga svoga, jer neće pred Gospodom biti bez krivice onaj koji uzalud izgovara njegovo ime. ");
INSERT INTO srponstl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sećaj se dana subotnjeg i posvećuj ga. ");
INSERT INTO srponstl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Šest dana radi i obavljaj sve svoje poslove. ");
INSERT INTO srponstl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","A sedmi dan je subota Gospodu, tvome Bogu. Ne radi nikakva posla, ni ti, ni tvoji sinovi i ćerke, ni tvoje sluge i sluškinje, ni tvoja stoka, ni stranac koji živi u tvojim gradovima. ");
INSERT INTO srponstl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Pa i Gospod je za šest dana stvorio nebo, zemlju i more i sve što je u njima, a u sedmi dan je počinuo. Zato je Gospod blagoslovio i posvetio dan subotnji. ");
INSERT INTO srponstl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Poštuj svoga oca i svoju majku, da bi ti se produžili dani na zemlji koju ti daje Gospod, Bog tvoj. ");
INSERT INTO srponstl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ne ubij! ");
INSERT INTO srponstl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ne čini preljube! ");
INSERT INTO srponstl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ne kradi! ");
INSERT INTO srponstl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ne svedoči lažno protiv bližnjega svoga! ");
INSERT INTO srponstl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ne poželi kuću bližnjega svoga, ni ženu njegovu, ni slugu njegovog, ni sluškinju njegovu, ni vola njegovog, ni magarca njegovog, niti išta što pripada tvome bližnjemu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Sav narod je bio svedok grmljavine i sevanja, svi su čuli glas trube i videli kako se gora dimi. Drhtali su i stajali podalje. ");
INSERT INTO srponstl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Onda su rekli Mojsiju: „Ti nam govori, a mi ćemo slušati. Neka nam Bog ne govori više, inače ćemo umreti!“ ");
INSERT INTO srponstl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","„Ne bojte se – odgovori Mojsije narodu – Bog je došao da vas ispita, te da pobudi svoj strah u vama, kako ne biste grešili.“ ");
INSERT INTO srponstl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Tako je narod ostao podalje, a Mojsije je pristupio gustoj tami gde je bio Bog. ");
INSERT INTO srponstl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Gospod reče Mojsiju: „Ovako reci Izrailjcima: ’Videli ste da sam govorio s vama s neba. ");
INSERT INTO srponstl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Zato ne pravite uz mene bogove od srebra, niti pravite sebi bogove od zlata. ");
INSERT INTO srponstl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Načini mi žrtvenik od zemlje i na njemu mi prinosi žrtve svespalnice i žrtve mira, svoju sitnu i krupnu stoku. Na svakom mestu gde odredim da se moje ime spominje, doći ću k tebi i blagosloviti te. ");
INSERT INTO srponstl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","A ako mi budeš gradio žrtvenik od kamena, ne gradi ga od tesanog kamena, jer ako spustiš svoje dleto na njega, oskrnavićeš ga. ");
INSERT INTO srponstl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ne uzlazi do mog žrtvenika po stepenicama, da se ne pokaže tvoja golotinja. ");
INSERT INTO srponstl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ovo su propisi koje ćeš im izložiti: ");
INSERT INTO srponstl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ako kupiš Jevrejina za roba, neka ti služi šest godina. Sedme godine neka ode kao slobodan čovek, bez ikakvog duga. ");
INSERT INTO srponstl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ako dođe sam, neka sam i ode. A ako ima ženu, neka njegova žena ode s njim. ");
INSERT INTO srponstl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ako mu njegov gospodar da ženu, i ona mu rodi sinove ili ćerke, žena i njena deca neka pripadnu gospodaru, a on neka ide sam. ");
INSERT INTO srponstl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ali ako rob kaže: ’Volim svoga gospodara, svoju ženu i svoju decu, neću da budem slobodan’, ");
INSERT INTO srponstl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","neka ga njegov gospodar dovede k Bogu. Zatim neka ga njegov gospodar privede k vratima ili dovratniku, i probuši mu šilom uho, pa neka mu služi zauvek. ");
INSERT INTO srponstl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Proda li ko svoju ćerku za sluškinju, ona neće biti oslobođena kao muški robovi. ");
INSERT INTO srponstl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ako nije po volji svome gospodaru, koji ju je odredio za sebe, neka joj dopusti da se otkupi. Stranom narodu je ne sme prodavati, jer nije postupao s njom po dogovoru. ");
INSERT INTO srponstl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","A ako je odredi za svoga sina, mora postupati s njom kao s ćerkom. ");
INSERT INTO srponstl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ukoliko se oženi drugom ženom, ne sme prvoj uskraćivati hranu, odeću i bračne odnose. ");
INSERT INTO srponstl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","A ako joj uskrati ovo troje, slobodna je da ode bez otkupnine. ");
INSERT INTO srponstl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Ako ko udari čoveka i ubije ga, neka se svakako kazni smrću. ");
INSERT INTO srponstl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ali ako to ne uradi namerno, nego Bog dopusti da mu ruka to učini, odrediću ti mesto gde može pobeći. ");
INSERT INTO srponstl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ako ko namerno napadne svoga bližnjeg i na prevaru ga ubije, odvuci ga i od moga žrtvenika, da se pogubi. ");
INSERT INTO srponstl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ko udari svoga oca ili svoju majku, neka se svakako kazni smrću. ");
INSERT INTO srponstl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ko otme čoveka i proda ga, ili ga drži u svojoj vlasti, neka se svakako kazni smrću. ");
INSERT INTO srponstl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ko prokune svoga oca ili svoju majku, neka se svakako kazni smrću. ");
INSERT INTO srponstl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Ako se ljudi posvađaju, pa jedan udari drugog kamenom ili pesnicom, ali ovaj ne umre, nego padne u postelju, ");
INSERT INTO srponstl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ali se kasnije oporavi i počne da izlazi uz pomoć štapa, oprašta se onome koji ga je udario. Ipak, taj mora da mu plati za gubitak vremena i da se pobrine za njegovo potpuno ozdravljenje. ");
INSERT INTO srponstl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ko udari svoga slugu ili sluškinju štapom, i oni umru od njegovog udarca, taj nek se kazni. ");
INSERT INTO srponstl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ali ako se sluga oporavi nakon dan-dva, onda vlasnik neće biti kažnjen, jer je sluga njegova svojina. ");
INSERT INTO srponstl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ako se ljudi potuku i udare trudnu ženu, te ona pobaci, ali ne bude druge štete, krivac mora da plati odštetu koju njen muž zatraži, uz odobrenje sudija. ");
INSERT INTO srponstl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Bude li kakve druge štete, kazna neka bude: život za život, ");
INSERT INTO srponstl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","oko za oko, zub za zub, ruka za ruku, noga za nogu, ");
INSERT INTO srponstl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","opekotina za opekotinu, rana za ranu, modrica za modricu. ");
INSERT INTO srponstl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ako ko udari svoga roba ili robinju u oko i izbije ga, neka ga oslobodi zbog oka. ");
INSERT INTO srponstl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ako ko svome robu ili robinji izbije zub, neka ga oslobodi zbog zuba. ");
INSERT INTO srponstl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ako vo ubode čoveka ili ženu i usmrti ih, zaspi vola kamenjem. Njegovo meso ne sme da se jede. Njegov vlasnik oslobađa se krivice. ");
INSERT INTO srponstl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ali ako je vo ubadao i ranije, a njegov vlasnik, i pored toga što je bio opomenut nije pazio na vola, pa vo usmrti čoveka ili ženu, vo neka se zaspe kamenjem. Njegov vlasnik neka se takođe pogubi. ");
INSERT INTO srponstl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Međutim, ako se od njega traži novčana nadoknada, on može da otkupi svoj život, ako plati sve što se od njega traži. ");
INSERT INTO srponstl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ako vo ubode dečaka ili devojčicu, na njemu će se primeniti isti zakonski postupak. ");
INSERT INTO srponstl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ako vo ubode roba ili robinju, njegov vlasnik neka isplati trideset srebrnih šekela njihovom gospodaru, a vo neka se kamenuje. ");
INSERT INTO srponstl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ako neko otvori bunar ili iskopa bunar, ali ga ne pokrije, pa u njega upadne vo ili magarac, ");
INSERT INTO srponstl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","vlasnik bunara mora da plati njegovom vlasniku odštetu u novcu. Uginula životinja neka pripadne njemu. ");
INSERT INTO srponstl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ako nečiji vo ubode vola koji pripada nekom drugom i usmrti ga, neka prodaju živog vola, pa neka podele novac. Mrtvog vola neka takođe podele. ");
INSERT INTO srponstl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Međutim, ako se zna da je vo ubadao i ranije, a njegov ga gospodar nije čuvao, on mora da nadoknadi vola za vola. Mrtva životinja neka pripadne njemu. ");
INSERT INTO srponstl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Ako neko ukrade vola ili grlo sitne stoke, pa ih zakolje ili ih proda, mora da ih nadoknadi: pet goveda za jednog vola i četiri ovce za jednu ovcu. ");
INSERT INTO srponstl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ako se lopov zatekne dok provaljuje, pa mu se zada udarac od koga umre, onaj koji ga ubije neće odgovarati za prolivenu krv. ");
INSERT INTO srponstl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ali ako se to desi po izlasku sunca, odgovaraće za prolivenu krv. Lopov mora da nadoknadi štetu. Ako nema ništa, treba ga prodati da otplati što je ukrao. ");
INSERT INTO srponstl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ako se ukradeno živinče nađe živo u njegovom vlasništvu, bilo vo, magarac ili grlo sitne stoke, mora da ga plati dvostruko. ");
INSERT INTO srponstl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ako neko napasa svoju stoku u nečijem polju ili vinogradu i dopusti joj da ga obrsti, neka nadoknadi štetu najboljim urodom iz svoga polja ili iz svoga vinograda. ");
INSERT INTO srponstl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ako izbije požar i zahvati žbunje, pa spali žito u snopu, klasu ili na celom polju, onaj koji je izazvao požar mora da nadoknadi štetu. ");
INSERT INTO srponstl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ako neko poveri svome bližnjemu novac ili stvari na čuvanje, a neko to ukrade iz kuće tog čoveka, lopov, ako se nađe, mora da plati dvostruko. ");
INSERT INTO srponstl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ako se lopov ne pronađe, vlasnik kuće neka stupi pred Boga, da se utvrdi da nije položio ruku na dobra svoga bližnjega. ");
INSERT INTO srponstl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","U svim slučajevima kršenja zakona o imovini – radilo se o volu, magarcu, sitnom grlu stoke, odeći, ili bilo kojoj izgubljenoj stvari za koju se tvrdi: ’To je moje!’, spor dve strane mora da se iznese pred Boga. Onaj koga Bog proglasi za krivca mora da plati dvostruko svome bližnjemu. ");
INSERT INTO srponstl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Ako neko poveri svome bližnjemu magarca, vola, grlo sitne stoke ili bilo kakvo živinče na čuvanje, pa ono ugine, povredi se, ili ga neko odvede, a nema svedoka, ");
INSERT INTO srponstl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","neka se čuvar zakune pred Gospodom da nije položio ruku na dobra svoga bližnjega. Vlasnik neka pristane na to, a čuvar ne mora da nadoknadi ništa. ");
INSERT INTO srponstl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ali ako mu je ukrao živinče, mora da nadoknadu štetu vlasniku. ");
INSERT INTO srponstl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ako divlja zver rastrgne živinče, neka ga donese kao dokaz, pa neće morati da nadoknadi štetu za rastrgnuto živinče. ");
INSERT INTO srponstl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ako neko pozajmi od svog bližnjeg živinče, ali se ono osakati ili ugine dok je vlasnik bio odsutan, neka nadoknadi štetu. ");
INSERT INTO srponstl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ukoliko je vlasnik bio prisutan, ne mora da plati odštetu. Ako je vlasnik unajmio živinče, cena najma pokriva gubitak. ");
INSERT INTO srponstl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ako neko zavede devojku koja nije zaručena i legne s njom, neka plati miraz za nju, pa neka je uzme za ženu. ");
INSERT INTO srponstl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ako njen otac odbije da mu je da, zavodnik neka plati novčani iznos u vrednosti miraza za devojku. ");
INSERT INTO srponstl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Ne ostavljaj vračaru u životu. ");
INSERT INTO srponstl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ko obleži živinče, neka se svakako pogubi. ");
INSERT INTO srponstl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ko prinese žrtvu drugim bogovima, osim samom Gospodu, neka se istrebi. ");
INSERT INTO srponstl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ne postupaj loše sa došljakom niti ga ugnjetavaj, jer ste i vi bili došljaci u Egiptu. ");
INSERT INTO srponstl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ne tlači udovicu ili siroče. ");
INSERT INTO srponstl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Jer, ako ih budeš tlačio, i oni zavape k meni, sigurno ću uslišiti njihove vapaje. ");
INSERT INTO srponstl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Moj gnev će planuti, pa ću vas pobiti mačem. Tada će vaše žene postati udovice, a vaša deca siročad. ");
INSERT INTO srponstl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ako pozajmiš novac nekome iz moga naroda, siromahu u tvojoj sredini, ne postupaj s njim kao zajmodavac: ne zahtevaj kamatu od njega. ");
INSERT INTO srponstl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ako uzmeš u zalog ogrtač svoga bližnjega, vrati mu ga pre nego što sunce zađe, ");
INSERT INTO srponstl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","jer mu je njegov ogrtač jedini pokrivač za telo. U čemu će, inače, spavati? Međutim, kad zavapi k meni, ja ću ga uslišiti, jer ja sam milosrdan. ");
INSERT INTO srponstl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ne proklinji Boga, niti govori ružno o knezu svoga naroda. ");
INSERT INTO srponstl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ne oklevaj da mi prineseš od obilja svoga žita i od svoga mladog vina i ulja. Meni ćeš dati prvenca od svojih sinova. ");
INSERT INTO srponstl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Isto ćeš činiti i sa krupnom i sitnom stokom: sedam dana neka ostane sa svojom majkom, a osmog dana ga donesi k meni. ");
INSERT INTO srponstl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Budite narod posvećen meni: ne jedite meso životinje koju je rastrgla divlja zver, nego ga bacite psima. ");
INSERT INTO srponstl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ne širi lažne glasine. Ne pristaj uz zlikovca da svedočiš lažno. ");
INSERT INTO srponstl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ne sledi većinu da činiš zlo, niti se priklanjaj većini u izvrtanju pravde kad svedočiš u parnici. ");
INSERT INTO srponstl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ne budi pristrasan prema siromahu u njegovoj parnici. ");
INSERT INTO srponstl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ako naiđeš na zalutalog vola ili magarca svog neprijatelja, svakako mu ga moraš dovesti natrag. ");
INSERT INTO srponstl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kad vidiš magarca onoga koji te mrzi da je pao pod svojim teretom, ne ostavljaj ga tako; moraš da mu pomogneš da se podigne sa svojim teretom. ");
INSERT INTO srponstl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ne izvrći pravdu na štetu svog siromaha u njegovoj parnici. ");
INSERT INTO srponstl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kloni se lažnih optužbi, ne ubijaj nevinog i pravednog, jer ja neću oprostiti zlikovcu. ");
INSERT INTO srponstl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ne primaj mito, jer mito zaslepljuje one koji jasno vide i izvrće reči pravednika. ");
INSERT INTO srponstl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ne ugnjetavajte došljaka, jer znate kako je došljaku. Pa i sami ste bili došljaci u Egiptu. ");
INSERT INTO srponstl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Šest godina zasejavaj zemlju i ubiri njen rod. ");
INSERT INTO srponstl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Sedme godine je ostavi da počiva neobrađena, da se od nje hrane siromasi tvoga naroda. Što ostane, neka divlje životinje pojedu. Isto tako ćeš činiti sa tvojim vinogradom i tvojim maslinjakom. ");
INSERT INTO srponstl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Šest dana radi svoj posao, a sedmoga dana prestani sa radom, da se odmori tvoj vo i tvoj magarac, i da odahne sin tvoje sluškinje i došljak. ");
INSERT INTO srponstl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Dobro pazite na sve što sam vam rekao. Ne prizivajte imena drugih bogova. Neka ih tvoja usta ne izuste. ");
INSERT INTO srponstl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Triput godišnje održavaj praznike u moju čast. ");
INSERT INTO srponstl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Slavi praznik Beskvasnih hlebova: sedam dana jedi beskvasni hleb, kako sam ti i zapovedio. Čini to u određeno vreme u mesecu avivu, jer si tog meseca izašao iz Egipta. Neka se niko ne pojavljuje preda mnom praznih ruku! ");
INSERT INTO srponstl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Slavi i praznik žetve prvim plodovima od uroda što ga seješ na polju. Takođe slavi i praznik berbe na kraju godine, kad s polja kupiš plodove svoga rada. ");
INSERT INTO srponstl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Triput godišnje neka se svi tvoji muški pojave pred Gospodom Bogom. ");
INSERT INTO srponstl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ne prinosi mi krv žrtve s nečim što sadrži kvasac. Salo od žrtve prinesene za moj praznik, neka ne ostane do jutra. ");
INSERT INTO srponstl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Najbolje prvine svoje zemlje donesi u Dom Gospoda, svoga Boga. Ne kuvaj jare u mleku njegove majke. ");
INSERT INTO srponstl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Evo, ja šaljem Anđela pred tobom da te čuva na putu, dok te ne dovede do mesta koje sam pripremio. ");
INSERT INTO srponstl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Čuvaj ga se i slušaj ga. Ne protivi mu se; on neće praštati vaše prestupe, jer je moje ime u njemu. ");
INSERT INTO srponstl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ali ako ga zaista budete slušali i radili sve što vam kažem, ja ću biti neprijatelj tvojim neprijateljima i protivnik tvojim protivnicima. ");
INSERT INTO srponstl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Jer, moj Anđeo će ići pred tobom i dovesti te do Amorejaca, Hetita, Ferežana, Hananaca, Evejaca i Jevusejaca, i ja ću ih istrebiti. ");
INSERT INTO srponstl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ne klanjaj se njihovim bogovima, niti im služi. Ne povodi se za onim što oni čine, nego poruši njihove idole i porazbijaj njihove svete stubove. ");
INSERT INTO srponstl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Služite Gospodu, svome Bogu, pa će blagosloviti tvoj hleb i vodu. Ja ću uklanjati pošast od tebe. ");
INSERT INTO srponstl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","U tvojoj zemlji neće biti pometkinje niti nerotkinje. Ja ću ti dati pun životni vek. ");
INSERT INTO srponstl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ja ću poslati svoj užas pred tobom; baciću u pometnju svaki narod koji susretneš, i učiniti da tvoji neprijatelji okrenu leđa i pobegnu od tebe. ");
INSERT INTO srponstl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Stršljene ću poslati pred tobom da nagnaju u beg Evejce, Hanance i Hetite ispred tebe. ");
INSERT INTO srponstl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Neću ih isterati pred tobom za godinu dana, da zemlja ne opusti i da se divlje životinje ne razmnože na tvoju štetu. ");
INSERT INTO srponstl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Teraću ih malo po malo pred tobom, dok se ne umnožiš i zaposedneš zemlju. ");
INSERT INTO srponstl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Postaviću ti granice: od Crvenog mora do Filistejskog mora, i od pustinje do Eufrata. Naime, ja ću u vaše ruke predati stanovnike zemlje, koje ćeš isterati pred sobom. ");
INSERT INTO srponstl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ne sklapaj savez sa njima i sa njihovim bogovima. ");
INSERT INTO srponstl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ne daj im da se nasele u tvojoj zemlji, da te ne navedu da grešiš protiv mene. Jer ako budeš služio njihovim bogovima, oni će ti biti zamka.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Bog reče Mojsiju: „Popni se k Gospodu, ti, Aron, Nadav i Avijud, te sedamdeset izrailjskih starešina. Poklonite se izdaleka. ");
INSERT INTO srponstl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Neka samo Mojsije pristupi Gospodu. Ostali neka ne prilaze. Narod neka se ne penje s njim.“ ");
INSERT INTO srponstl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mojsije ode i ispriča narodu sve Gospodnje reči i sve uredbe. Narod odgovori u jedan glas: „Vršićemo sve reči što ih je Gospod izrekao.“ ");
INSERT INTO srponstl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mojsije je napisao sve reči Gospodnje. Sledećeg jutra je poranio i podigao žrtvenik u podnožju gore i dvanaest stubova za dvanaest izrailjskih plemena. ");
INSERT INTO srponstl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Zatim je poslao izrailjske mladiće da prinesu žrtve svespalnice i da žrtvuju Gospodu junce kao žrtve mira. ");
INSERT INTO srponstl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","A Mojsije uzme polovinu krvi i ulije je u posude, a drugu polovinu izlije na žrtvenik. ");
INSERT INTO srponstl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Onda je uzeo Knjigu saveza i glasno je pročitao narodu. Oni odgovoriše: „Vršićemo sve što je Gospod rekao, i pokoravati se tome.“ ");
INSERT INTO srponstl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mojsije je, zatim, uzeo krv i njome poškropio narod, i rekao: „Evo krvi saveza koji je Gospod sklopio sa vama na temelju svih ovih reči.“ ");
INSERT INTO srponstl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Posle toga se Mojsije popeo sa Aronom, Nadavom, Avijudom i sedamdesetoricom izrailjskih starešina. ");
INSERT INTO srponstl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Oni su videli Boga Izrailjevog. Pod njegovim nogama je bilo nešto kao postolje od čistog safira, jasno kao sâmo nebo. ");
INSERT INTO srponstl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Bog nije dizao svoju ruku na glavare Izrailjaca. Gledali su Boga, jeli i pili. ");
INSERT INTO srponstl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Gospod reče Mojsiju: „Popni se k meni na goru. Ostani tamo, a ja ću ti dati kamene ploče sa Zakonom i zapovestima koje sam napisao za njihovu pouku.“ ");
INSERT INTO srponstl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mojsije ustane sa svojim pomoćnikom Isusom Navinom, i Mojsije se popne na goru Božiju. ");
INSERT INTO srponstl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Starešinama je rekao: „Vi nas čekajte ovde, dok se ne vratimo. Evo, Aron i Or su sa vama. Ko bude imao neki spor, neka se obrati njima.“ ");
INSERT INTO srponstl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mojsije se popne na goru, a oblak prekrije goru. ");
INSERT INTO srponstl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Slava Gospodnja se spustila na goru Sinaj, i oblak ju je obavijao šest dana. Sedmog dana Gospod pozove Mojsija iz oblaka. ");
INSERT INTO srponstl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Očima Izrailjaca je slava Gospodnja na vrhu gore izgledala kao sažižući oganj. ");
INSERT INTO srponstl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mojsije je ušao usred oblaka i popeo se na goru. Na gori je Mojsije proveo četrdeset dana i četrdeset noći. ");
INSERT INTO srponstl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","„Reci Izrailjcima da mi prikupe prilog. Primajte prilog od svakog čoveka koji od srca daje prilog za mene. ");
INSERT INTO srponstl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ovo je prilog koji ćete primati od njih: zlato, srebro, bronzu; ");
INSERT INTO srponstl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ljubičastu, skerletnu i tamno crvenu tkaninu, fini lan i kostret; ");
INSERT INTO srponstl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ovnujske kože obojene u crveno, fine kože; bagremovo drvo; ");
INSERT INTO srponstl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ulje za svetlo, začine za ulje pomazanja i miomirisni kad; ");
INSERT INTO srponstl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","oniks i drugo drago kamenje za ukivanje u oplećak i naprsnik. ");
INSERT INTO srponstl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Zatim mi sagradite Svetilište, pa ću se nastaniti među njima. ");
INSERT INTO srponstl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Napravi ovo Prebivalište i sve posuđe za njega tačno prema nacrtu koji ću ti pokazati. ");
INSERT INTO srponstl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Oni neka naprave Kovčeg od bagremovog drveta; dva i po lakta dug, lakat i po širok i lakat i po visok. ");
INSERT INTO srponstl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Obloži ga čistim zlatom, iznutra i spolja, i načini oko njega zlatan venac. ");
INSERT INTO srponstl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Zatim izlij četiri zlatna koluta i prikuj ih na njegove četiri strane; dva koluta na jednu stranu i dva koluta na drugu. ");
INSERT INTO srponstl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Onda načini drške od bagremovog drveta i obloži ih zlatom. ");
INSERT INTO srponstl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Provuci ih kroz kolutove s obe strane Kovčega da se Kovčeg nosi o njima. ");
INSERT INTO srponstl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Drške neka ostanu u kolutima na Kovčegu; neka se iz njih ne izvlače. ");
INSERT INTO srponstl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","U Kovčeg stavi Svedočanstvo koje ću ti dati. ");
INSERT INTO srponstl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Poklopac za Kovčeg napravi od čistog zlata. Neka bude dug dva i po lakta i širok lakat i po. ");
INSERT INTO srponstl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Zatim napravi dva heruvima od kovanog zlata. Prikuj ih na oba kraja poklopca; ");
INSERT INTO srponstl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","jednog heruvima na jedan kraj, a drugog heruvima na drugi kraj poklopca. Pričvrsti ih na obe strane poklopca, tako da s njim čine jednu celinu. ");
INSERT INTO srponstl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Heruvimi neka imaju podignuta krila prema gore, tako da zaklanjaju poklopac. Neka stoje licem okrenuti jedan prema drugome, tako da im lica budu okrenuta prema poklopcu. ");
INSERT INTO srponstl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Poklopac stavi na Kovčeg, a u Kovčeg stavi Svedočanstvo koje ću ti dati. ");
INSERT INTO srponstl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Sastajaću se s tobom kod poklopca, između dva heruvima što su na Kovčegu svedočanstva, i tamo ti saopštavati sve zapovesti za Izrailjce. ");
INSERT INTO srponstl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Napravi sto od bagremovog drveta. Neka bude dva lakta dug, jedan lakat širok i jedan i po lakat visok. ");
INSERT INTO srponstl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Obloži ga čistim zlatom, i obrubi ga zlatnim pojasom. ");
INSERT INTO srponstl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Napravi mu i dlan široki okvir oko njega, i obrubi ga zlatnim pojasom. ");
INSERT INTO srponstl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Zatim mu napravi četiri zlatna koluta i postavi ih na njegova četiri nožna ugla. ");
INSERT INTO srponstl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Kolutovi neka budu pod okvirom da drže drške za nošenje stola. ");
INSERT INTO srponstl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Drške napravi od bagremovog drveta i obloži ih zlatom. O njima će se nositi sto. ");
INSERT INTO srponstl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Napravi za njega: tanjire, čaše, vrčeve i pehare za izlivanje prinosa. Napravi ih od čistog zlata. ");
INSERT INTO srponstl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Na sto postavljaj hleb da stalno bude preda mnom. ");
INSERT INTO srponstl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Svećnjak napravi od čistog zlata. Njegovo postolje, stalak, čašice, pupoljke i latice – iskuj iz jednog komada. ");
INSERT INTO srponstl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Neka se grana u šest krakova: tri kraka s jedne strane stalka i tri kraka s druge strane stalka. ");
INSERT INTO srponstl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Na jednom kraku neka budu tri čašice u obliku bademovog cveta, svaka s pupoljcima i laticama. Na drugom kraku neka takođe budu tri čašice u obliku bademovog cveta, svaka s pupoljcima i laticama. Tako neka bude sa svih šest krakova koji izbijaju iz svećnjaka. ");
INSERT INTO srponstl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Sâm svećnjak neka ima četiri čašice u obliku bademovog cveta, svaka s pupoljcima i laticama. ");
INSERT INTO srponstl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Jedan pupoljak neka bude ispod prva dva kraka, drugi pupoljak ispod druga dva kraka, i treći pupoljak ispod poslednja dva kraka. Tako neka bude za svih šest krakova koji izbijaju iz svećnjaka. ");
INSERT INTO srponstl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Pupoljci i krakovi neka čine jednu celinu sa svećnjakom. Sve to neka bude iskovano od jednog komada čistog zlata. ");
INSERT INTO srponstl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Napravi i sedam svetiljki i postavi ih da osvetljavaju prostor ispred njega. ");
INSERT INTO srponstl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Mašice i pepeljare napravi od čistog zlata. ");
INSERT INTO srponstl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Za sve posuđe neka se upotrebi jedan talant čistog zlata. ");
INSERT INTO srponstl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Gledaj da napraviš to prema nacrtu koji ti je pokazan na gori. ");
INSERT INTO srponstl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Prebivalište napravi od deset zavesa: od finog lana, te od ljubičaste, skerletne i tamno crvene tkanine. Na njima neka budu veštinom umetnika izvezeni heruvimi. ");
INSERT INTO srponstl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Dužina svake zavese neka bude dvadeset osam lakata, a širina četiri lakta. Sve zavese neka budu iste mere. ");
INSERT INTO srponstl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pet zavesa neka budu spojene jedna za drugu, a tako i drugih pet zavesa neka budu spojene jedna za drugu. ");
INSERT INTO srponstl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Zatim načini petlje od ljubičaste tkanine pri rubu poslednje zavese spojenoga dela, a to isto načini pri rubu poslednje zavese u drugoj polovini spojenog dela. ");
INSERT INTO srponstl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Napravi pedeset petlji na prvoj zavesi i pedeset petlji pri rubu poslednje zavese drugog spojenog dela. Petlje neka budu jedna naspram druge. ");
INSERT INTO srponstl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Zatim napravi pedeset zlatnih kopči. Zavese ćeš kopčama sastaviti jednu s drugom, tako da Prebivalište bude jedna celina. ");
INSERT INTO srponstl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Potom od kozje dlake napravi zavese za Šator povrh Prebivališta; napravi jedanaest zavesa. ");
INSERT INTO srponstl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Svaka zavesa neka bude trideset lakata duga i četiri lakta široka; svih jedanaest zavesa neka budu iste mere. ");
INSERT INTO srponstl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Prvih pet zavesa sastavi posebno, a tako i ostalih šest zavesa sastavi posebno. Šestu zavesu udvostruči na prednjoj strani Šatora. ");
INSERT INTO srponstl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Zatim napravi pedeset petlji na rubu prvog spojenog dela, i pedeset petlji na rubu drugog spojenog dela. ");
INSERT INTO srponstl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Onda napravi pedeset bronzanih kopči, pa ih prikopčaj za petlje da spajaju Šator u jednu celinu. ");
INSERT INTO srponstl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Od preostalih zavesa, jednom polovinom pokrij zadnju stranu Prebivališta. ");
INSERT INTO srponstl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ostatak zavesa neka visi po jedan lakat duž obe strane Šatora, da ga pokriva. ");
INSERT INTO srponstl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Zatim napravi pokrivač za Šator od ovnujskih koža obojenih u crveno, a povrh njega pokrivač od finih koža. ");
INSERT INTO srponstl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Napravi i daske od bagremovog drveta za Prebivalište, koje će stajati uspravno. ");
INSERT INTO srponstl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Dužina svake daske biće deset lakata, a širina jedan i po lakat. ");
INSERT INTO srponstl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Svaka daska neka ima dva klina, tako da daske stoje uspravno jedna uz drugu. Tako učini sa svakom daskom za Prebivalište. ");
INSERT INTO srponstl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Napravi daske za Prebivalište: dvadeset dasaka za južnu stranu, ");
INSERT INTO srponstl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","i četrdeset srebrnih podnožja ispod dvadeset dasaka – dva podnožja ispod jedne daske, za njena dva klina, i dva podnožja ispod druge daske, za njena dva klina. ");
INSERT INTO srponstl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Tako i na severnoj strani Prebivališta neka bude dvadeset dasaka ");
INSERT INTO srponstl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","sa četrdeset srebrnih podnožja – dva podnožja ispod jedne daske, i po dva podnožja ispod svake naredne daske. ");
INSERT INTO srponstl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Za zapadnu stranu Prebivališta napravi šest dasaka. ");
INSERT INTO srponstl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Za uglove na zadnjoj strani Prebivališta napravi dve daske. ");
INSERT INTO srponstl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Neka stoje jedna uz drugu spojene na dnu, a na vrhu neka budu spojene jednim obručem. Neka tako obadve čine dva ugla. ");
INSERT INTO srponstl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Dakle, neka bude ukupno osam dasaka i šesnaest srebrnih podnožja; po dva podnožja za svaku dasku. ");
INSERT INTO srponstl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Napravi prečage od bagremovog drveta; pet prečaga za daske na jednoj strani Prebivališta, ");
INSERT INTO srponstl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","pet prečaga za daske na drugoj strani Prebivališta, i pet prečaga za daske na zadnjoj strani Prebivališta, prema zapadu. ");
INSERT INTO srponstl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Srednja prečaga neka se pruža sredinom dasaka s jednog kraja na drugi. ");
INSERT INTO srponstl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Daske obloži zlatom, a obruče za prečage napravi od zlata. Prečage obloži zlatom. ");
INSERT INTO srponstl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Podigni Prebivalište prema nacrtu koji ti je pokazan na gori. ");
INSERT INTO srponstl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Napravi zavesu od ljubičaste, skerletne i tamno crvene tkanine, i finog lana, a na njoj izvezi heruvime umetničkom veštinom. ");
INSERT INTO srponstl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Okači je na četiri zlatom obložena stuba od bagremovog drveta, sa kukama od zlata. Neka stoje na četiri srebrna podnožja. ");
INSERT INTO srponstl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Zavesu okači za kopče, pa donesi tamo, iza zavese, Kovčeg svedočanstva. Zavesa će vam deliti Svetinju od Svetinje nad svetinjama. ");
INSERT INTO srponstl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Stavi poklopac na Kovčeg svedočanstva u Svetinji nad svetinjama. ");
INSERT INTO srponstl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Sto postavi izvan zavese, a svećnjak na južnu stranu Prebivališta, nasuprot stola. Sto postavi na severnu stranu. ");
INSERT INTO srponstl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Napravi zastor za ulaz u Šator od ljubičaste, skerletne i tamno crvene tkanine, te od finog lana – vezom izvezen. ");
INSERT INTO srponstl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Za zastor napravi pet stubića od bagremovog drveta i obloži ih zlatom. Kuke za njih neka budu od zlata. Izlij za njih pet bronzanih podnožja. ");
INSERT INTO srponstl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Napravi žrtvenik od bagremovog drveta. Neka bude četvrtastog oblika: pet lakata dug, pet lakata širok, i tri lakta visok. ");
INSERT INTO srponstl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Na njegova četiri ugla napravi rogove, tako da žrtvenik i rogovi čine jednu celinu. Žrtvenik obloži bronzom. ");
INSERT INTO srponstl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Zatim napravi lonce za uklanjanje pepela, lopatice, kotliće i mašice. Sve posude načini od bronze. ");
INSERT INTO srponstl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Napravi za žrtvenik rešetku od bronze, u obliku mreže. Na mreži načini četiri bronzana obruča za njena četiri ugla. ");
INSERT INTO srponstl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Mrežu pričvrsti za okvir ispod žrtvenika, tako da doseže do polovine žrtvenika. ");
INSERT INTO srponstl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Onda napravi drške za žrtvenik od bagremovog drveta i obloži ih bronzom. ");
INSERT INTO srponstl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Drške neka se provuku kroz kolutove s obe strane žrtvenika, radi nošenja. ");
INSERT INTO srponstl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Napravi ga od dasaka, i neka bude šupalj. Kako ti je pokazano na gori, tako neka bude napravljen. ");
INSERT INTO srponstl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Napravi dvorište za Prebivalište. Na južnoj strani, zavese za dvorište neka budu od finog lana, dužine stotinu lakata za tu stranu. ");
INSERT INTO srponstl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Neka budu okačene o dvadeset stubova sa dvadeset bronzanih podnožja. Kuke i šipke za stubove neka budu od srebra. ");
INSERT INTO srponstl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Dužina zavese na severnoj strani takođe neka bude stotinu lakata. Neka bude dvadeset stubova sa dvadeset bronzanih podnožja. Kuke i šipke za stubove neka budu od srebra. ");
INSERT INTO srponstl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Širinu dvorišta, njegovu zapadnu stranu, neka pokriva pedeset lakata zavese. I tamo neka bude deset stubova sa deset podnožja. ");
INSERT INTO srponstl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Širina dvorišta na istoku neka bude pedeset lakata. ");
INSERT INTO srponstl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Zavese s jedne strane ulaza neka su petnaest lakata duge, sa svoja tri stuba i njihova tri podnožja. ");
INSERT INTO srponstl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Zavese za drugu stranu ulaza neka su takođe petnaest lakata duge, sa svoja tri stuba i njihova tri podnožja. ");
INSERT INTO srponstl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Za dvorišni ulaz daj da se vezom izveze dvadeset lakata dug zastor od ljubičaste, skerletne i tamno crvene tkanine, i finog lana. Neka bude na četiri stuba i njihova četiri podnožja. ");
INSERT INTO srponstl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Svi stubovi oko dvorišta neka budu spojeni srebrnim kukama. Njihova podnožja neka budu od bronze. ");
INSERT INTO srponstl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Dužina dvorišta neka bude stotinu lakata, širina pedeset lakata, a visina pet lakata, sa zavesama od finog lana i bronzanim podnožjima. ");
INSERT INTO srponstl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Sve potrepštine za Prebivalište, čemu god da služe, njegovi kočići, kao i svi kočići za dvorište, neka budu od bronze. ");
INSERT INTO srponstl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Zapovedi Izrailjcima da ti donesu čistog, sveže isceđenog, maslinovog ulja za svećnjak, da svetlo stalno gori. ");
INSERT INTO srponstl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aron i njegovi sinovi će ga postavljati u Šatoru od sastanka, izvan zavese koja je ispred Svedočanstva, da gori pred Gospodom, od večeri do jutra. To je trajna uredba za Izrailjce, od naraštaja do naraštaja. ");
INSERT INTO srponstl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Izdvoj od Izrailjaca svog brata Arona i njegove sinove: Nadava, Avijuda, Eleazara i Itamara, pa ih dovedi k sebi, da mi služe kao sveštenici. ");
INSERT INTO srponstl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Napravi svetu odoru za svog brata Arona na čast i ukras. ");
INSERT INTO srponstl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Reci svim veštim ljudima koje sam obdario mudrošću da naprave odoru za njegovo posvećenje, da bi mi služio kao sveštenik. ");
INSERT INTO srponstl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ovakvu će odoru napraviti: naprsnik, oplećak, plašt, vezenu košulju, turban i pojas. Takvu će odoru napraviti za tvog brata Arona i za njegove sinove, da mi služe kao sveštenici. ");
INSERT INTO srponstl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Neka upotrebe za nju zlato, ljubičastu, skerletnu i tamno crvenu tkaninu i fini lan. ");
INSERT INTO srponstl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Oplećak neka naprave od zlata, ljubičaste, skerletne i tamno crvene tkanine, i od finog lana – vešto izvezenog. ");
INSERT INTO srponstl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Neka na njemu budu dve naramenice da pričvršćuju oba njegova kraja. ");
INSERT INTO srponstl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Pojas kojim će se oplećak opasivati neka takođe bude od zlata, ljubičaste, skerletne i tamno crvene tkanine i finog lana, tako da s njim sačinjava jedan komad. ");
INSERT INTO srponstl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Zatim uzmi dva draga kamena oniksa i u njih ureži imena Izrailjevih sinova: ");
INSERT INTO srponstl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","šest imena na jednom kamenu i šest ostalih imena na drugom kamenu, prema redu njihovog rođenja. ");
INSERT INTO srponstl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ureži imena sinova Izrailjevih u dva kamena kao što zlatar urezuje pečate na prstenje, i optoči ih zlatnim okvirom. ");
INSERT INTO srponstl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Umetni ta dva draga kamena u naramenice oplećka u sećanje na sinove Izrailjeve. Aron će ih nositi na ramenima pred Gospodom kao potsetnik. ");
INSERT INTO srponstl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Onda napravi dva koluta od zlata, ");
INSERT INTO srponstl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","i dva lančića od čistog zlata u obliku upletene uzice, pa ih pričvrsti za kolutove. ");
INSERT INTO srponstl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Naprsnik za presuđivanje napravi umetničkom veštinom. Napravićeš ga na isti način kao oplećak: od zlata, ljubičaste, skerletne i tamno crvene tkanine, i finog lana. ");
INSERT INTO srponstl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Neka bude u obliku četvorougla, udvojen; pedalj dug i pedalj širok. ");
INSERT INTO srponstl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Poređaj na njemu četiri reda dragog kamenja. U prvom redu: rubin, topaz i smaragd; ");
INSERT INTO srponstl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","u drugom redu: malahit, safir i dijamant; ");
INSERT INTO srponstl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","u trećem redu: hijacint, ahat i ametist; ");
INSERT INTO srponstl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","a u četvrtom redu: hrisolit, oniks i jaspis. Neka budu optočeni zlatnim okvirom. ");
INSERT INTO srponstl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","To drago kamenje predstavljaće imena dvanaest sinova Izrailjevih; na svakom će biti urezano, kao na pečatu na prstenju, po jedno ime za svako od dvanaest plemena. ");
INSERT INTO srponstl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Napravi za naprsnik lančiće od čistog zlata u obliku upletene uzice. ");
INSERT INTO srponstl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Zatim napravi za naprsnik dva zlatna kolutića i pričvrsti ih na dva gornja ugla naprsnika. ");
INSERT INTO srponstl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Zlatne lančiće priveži za dva kolutića na uglovima naprsnika. ");
INSERT INTO srponstl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Oba kraja lančića priveži za dva okvira, pa ih pričvrsti za dve naramenice s prednje strane oplećka. ");
INSERT INTO srponstl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Onda napravi dva kolutića od zlata i pričvrsti ih za dva donja ugla naprsnika, pri rubu unutrašnje strane do oplećka. ");
INSERT INTO srponstl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Nadalje, napravi dva kolutića od zlata i pričvrsti ih za donji kraj naramenice oplećka, na njegovoj prednjoj strani, kod šava iznad pojasa oplećka. ");
INSERT INTO srponstl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Neka se kolutići naprsnika privežu za kolutiće oplećka uzicom od purpura, tako da naprsnik stoji iznad pojasa, kako ne bi spadao s oplećka. ");
INSERT INTO srponstl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aron će nositi imena sinova Izrailjevih na naprsniku za presuđivanje, na svom srcu, kad god bude ulazio u Svetinju, kao stalni potsetnik pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","U naprsnik za presuđivanje stavi Urim i Tumim, da budu na Aronovom srcu, kad god bude stupao pred Gospoda. Aron će ih nositi na srcu, te uvek donositi presude među Izrailjcima pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Plašt za oplećak napravi od ljubičaste tkanine. ");
INSERT INTO srponstl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","U njegovoj sredini neka bude prorez za glavu. Rub oko proreza neka se opšije vezenim okovratnikom, da se plašt ne bi cepao. ");
INSERT INTO srponstl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Zatim svuda oko ruba plašta napravi narove od ljubičaste, skerletne i tamno crvene tkanine, a između njih zvončiće od zlata: ");
INSERT INTO srponstl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","zvonce od zlata pa nar, zvonce od zlata pa nar, i tako svuda okolo uz rub plašta. ");
INSERT INTO srponstl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Neka ga Aron ima na sebi kad vrši službu, da se čuje kad ulazi u Svetinju pred Gospoda i kad izlazi – da ne bi umro. ");
INSERT INTO srponstl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Napravi pločicu od čistog zlata i na njoj ureži, kao na pečatu: ’Posvećen Gospodu’. ");
INSERT INTO srponstl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Priveži je ljubičastom vrpcom i postavi je na vrh turbana, s prednje strane. ");
INSERT INTO srponstl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Neka bude na Aronovom čelu. Aron će, pak, preuzeti na sebe krivice koje Izrailjci počine pri prinošenju svih svojih posvećenih prinosa. Pločica će uvek stajati na Aronovom čelu, kako bi našli smilovanje pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Zatim istkaj košulju od lana, i napravi turban od lana, i vezom izvezeni opasač. ");
INSERT INTO srponstl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aronovim sinovima napravi košulje sa opasačima i turbane, njima na čast i ukras, ");
INSERT INTO srponstl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","pa u njih obuci svog brata Arona i njegove sinove s njim. Zatim ih pomaži, uvedi u službu i posveti ih, da mi služe kao sveštenici. ");
INSERT INTO srponstl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Napravi im i gaće od lana da im pokrivaju goli deo tela, od struka do bedara. ");
INSERT INTO srponstl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Neka ih Aron i njegovi sinovi nose kad god ulaze u Šator od sastanka, ili kad pristupaju žrtveniku da vrše bogosluženje u Svetinji nad svetinjama, da ne navuku krivicu na sebe i umru. Ovo je trajna uredba za njega i njegovo potomstvo posle njega. ");
INSERT INTO srponstl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ovako ćeš postupiti s njima da ih posvetiš za moje sveštenstvo: uzmi jednog junca i dva ovna bez mane; ");
INSERT INTO srponstl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","onda uzmi beskvasni hleb, beskvasne kolače zamešene s uljem, i beskvasne lepinje premazane uljem. Napravi ih od pšeničnog brašna. ");
INSERT INTO srponstl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Stavi ih u jednu košaru i u njoj ih prinesi s juncem i dva ovna. ");
INSERT INTO srponstl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Onda dovedi Arona i njegove sinove na ulaz u Šator od sastanka i operi ih vodom. ");
INSERT INTO srponstl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Zatim uzmi odoru i obuci Arona u košulju, ogrtač oplećka, oplećak i naprsnik i opaši ga izvezenim pojasom oplećka. ");
INSERT INTO srponstl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Stavi mu turban na glavu i na njoj pričvrsti posvetni natpis. ");
INSERT INTO srponstl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Zatim uzmi ulje za pomazanje i pomaži ga izlivajući ulje na njegovu glavu. ");
INSERT INTO srponstl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Onda dovedi njegove sinove, obuci im košulje, ");
INSERT INTO srponstl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","opaši ih pojasevima – kako Arona tako i njegove sinove – i obavij im turbane. Tako neka im pripada sveštenstvo prema trajnoj uredbi. Tako ćeš uvesti u službu Arona i njegove sinove. ");
INSERT INTO srponstl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Dovedi onda junca pred Šator od sastanka, a Aron i njegovi sinovi neka polože ruke na njegovu glavu. ");
INSERT INTO srponstl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ti onda zakolji junca pred Gospodom kod ulaza u Šator od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Uzmi nešto od krvi junca i prstom je namaži na rogove žrtvenika, a ostatak krvi izlij podno žrtvenika. ");
INSERT INTO srponstl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Zatim skini sve salo oko iznutrica, jetrenu mrežicu, i oba bubrega s lojem, pa to spali na žrtveniku. ");
INSERT INTO srponstl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Meso junca, njegovu kožu i balegu spali izvan tabora. To je žrtva za greh. ");
INSERT INTO srponstl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Nakon toga uzmi jednog ovna, a Aron i njegovi sinovi neka polože ruke na njegovu glavu. ");
INSERT INTO srponstl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Zakolji ovna i uzmi nešto od njegove krvi, pa njome zapljusni žrtvenik sa svih strana. ");
INSERT INTO srponstl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ovna iseci na komade, operi mu iznutrice i noge, pa ih stavi na ostale delove i glavu. ");
INSERT INTO srponstl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Zatim celog ovna spali na žrtveniku. To je žrtva svespalnica Gospodu, ugodni miris, paljena žrtva za Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Onda uzmi drugog ovna. Aron i njegovi sinovi neka polože ruke na njegovu glavu, ");
INSERT INTO srponstl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","a ti ga zakolji. Onda uzmi nešto krvi i njome namaži resicu desnog uha Aronovog, te resicu desnog uha njegovih sinova, palac njihove desne ruke, i palac njihove desne noge. Ostatkom krvi zapljusni žrtvenik sa svih strana. ");
INSERT INTO srponstl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Zatim uzmi nešto krvi sa žrtvenika i ulja za pomazanje, pa njima poškropi Arona i njegovu odeždu, a tako i njegove sinove i njihove odežde. Tako će biti posvećen on i njegova odežda, kao i njegovi sinovi i njihove odežde. ");
INSERT INTO srponstl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Potom uzmi salo od ovna, salo s repa, salo oko iznutrica, jetrenu mrežicu, oba bubrega sa salom oko njih, i desnu plećku – jer je ovan žrtva za posvećenje – ");
INSERT INTO srponstl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","zatim jedan okrugli hleb, jedan kolač zamešen s uljem, i jednu lepinju iz košare sa beskvasnim hlebom što je pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Sve to položi na ruke Arona i njegovih sinova, pa prinesi žrtvu dizanicu pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Zatim uzmi to iz njihovih ruku, pa spali na žrtveniku povrh žrtve svespalnice, kao ugodni miris pred Gospodom. To je paljena žrtva Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Uzmi zatim grudi ovna koji je prinesen za Aronovo posvećenje i prinesi ih kao žrtvu dizanicu pred Gospodom. Taj deo neka pripadne tebi. ");
INSERT INTO srponstl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Posveti grudi koje su bile prinesene kao žrtva dizanica i but koji je bio prinesen kao žrtveni dar od ovna prinesenog za posvećenje Arona i njegovih sinova. ");
INSERT INTO srponstl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Aron i njegovi sinovi neka primaju taj deo od Izrailjaca, jer je to žrtva dizanica. Izrailjci će davati taj deo kada budu prinosili žrtve mira koje se podižu Gospodu. Ovo je trajna uredba. ");
INSERT INTO srponstl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aronove posvećene odežde neka pripadnu njegovim sinovima posle njega; u njima neka budu pomazani i uvedeni u službu. ");
INSERT INTO srponstl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Sin koji ga nasledi kao sveštenik, neka ih sedam dana nosi, kad uđe u Šator od sastanka da vrši bogosluženje u Svetinji. ");
INSERT INTO srponstl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Zatim uzmi ovna posvećenja i skuvaj njegovo meso na svetom mestu. ");
INSERT INTO srponstl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aron i njegovi sinovi neka jedu meso od tog ovna sa hlebom iz košare, na ulazu u Šator od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Dakle, što je bilo prineseno za njihovo otkupljenje prilikom njihovog uvođenja u službu – to neka jedu. Neovlašćen ne sme to da jede, jer je posvećeno. ");
INSERT INTO srponstl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ako preostane šta mesa i hleba, spali na vatri; to ne sme da se jede, jer je posvećeno. ");
INSERT INTO srponstl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Postupi sa Aronom i njegovim sinovima onako kako sam ti zapovedio. Sedam dana ih uvodi u službu. ");
INSERT INTO srponstl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Svakog dana prinesi junca kao žrtvu za greh – za otkupljenje. Prinesi i žrtvu za greh da otkupiš žrtvenik, a zatim ga pomaži da ga posvetiš. ");
INSERT INTO srponstl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sedam dana prinosi žrtvu otkupljenja za žrtvenik i posvećuj ga. Tada će žrtvenik postati presvet, i što god ga se dotakne biće posvećeno. ");
INSERT INTO srponstl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","A ovo ćeš stalno prinositi na žrtvu: dnevno dva jagnjeta od godinu dana. ");
INSERT INTO srponstl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Jedno jagnje prinesi ujutro, a drugo prinesi uveče. ");
INSERT INTO srponstl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","S prvim jagnjetom prinesi jednu desetinu efe brašna zamešenog s četvrtinom hina ulja od tučenih maslina, i žrtvu izlivnicu od četvrtine hina vina. ");
INSERT INTO srponstl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Drugo jagnje prinesi uveče. S njim prinesi istu žitnu žrtvu kao ujutro, i žrtvu izlivnicu na ugodni miris, paljenu žrtvu Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Neka se ova žrtva svespalnica prinosi na ulazu u Šator od sastanka, pred Gospodom, od pokolenja do pokolenja. Tamo ću se sastajati s tobom da ti govorim. ");
INSERT INTO srponstl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Tamo ću se sastajati i s Izrailjcima, i moja će slava posvetiti to mesto. ");
INSERT INTO srponstl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ja ću posvetiti Šator od sastanka i žrtvenik. Takođe ću posvetiti Arona i njegove sinove da mi služe kao sveštenici. ");
INSERT INTO srponstl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ja ću boraviti među Izrailjcima i biti njihov Bog. ");
INSERT INTO srponstl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Tada će znati da sam ja, Gospod, Bog njihov, koji ih je izveo iz Egipta da boravim među njima. Ja sam Gospod, Bog njihov! ");
INSERT INTO srponstl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Napravi žrtvenik za paljenje kada; napravi ga od bagremovog drveta. ");
INSERT INTO srponstl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Neka bude četvorouglast: jedan lakat dug, jedan lakat širok, i dva lakta visok. Njegovi rogovi neka budu iz jednog dela s njim. ");
INSERT INTO srponstl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Obloži ga čistim zlatom: njegovu gornju stranu, njegove strane unaokolo i njegove rogove. Obrubi ga zlatnim okvirom. ");
INSERT INTO srponstl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Zatim mu napravi po dva zlatna koluta na obe bočne strane i pričvrsti ih ispod okvira, da se kroz njih provuku drške za nošenje žrtvenika. ");
INSERT INTO srponstl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Drške napravi od bagremovog drveta i obloži ih zlatom. ");
INSERT INTO srponstl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Postavi žrtvenik ispred zavese što zaklanja Kovčeg svedočanstva, ispred poklopca nad svedočanstvom. Tu ću se sastajati s tobom. ");
INSERT INTO srponstl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Neka Aron na njemu pali mirisni kad. Paliće ga svakog jutra, kad bude pripremao svetla. ");
INSERT INTO srponstl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Neka ga Aron ponovo pali kad bude palio svetla uveče, tako da mirisni kad stalno gori pred Gospodom u sva pokolenja. ");
INSERT INTO srponstl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Na žrtveniku ne prinosite nikakav tuđi kad, ni žrtvu svespalnicu, ni prinos, ni žrtvu izlivnicu. ");
INSERT INTO srponstl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Jednom godišnje neka Aron izvrši obred otkupljenja nad rogovima prinoseći krv žrtve za otkupljenje greha. To neka se čini jednom godišnje za sva pokolenja. Jer, žrtvenik je presveta svetinja Gospodu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Gospod zatim reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","„Kad praviš popis Izrailjaca, neka svako ko se ubraja u popis da Gospodu otkupninu za svoj život, da ih ne pogodi pomor dok ih popisuješ. ");
INSERT INTO srponstl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Svako ko podleže popisu neka da: pola šekela – prema hramskoj meri (jedan šekel je dvadeset gera). Tih pola šekela će biti prinos Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Svi koji podležu popisu, dakle, oni od dvadeset godina pa naviše, davaće ovaj prinos Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Bogati neće davati više, niti siromašni manje od pola šekela, kada daju prinos Gospodu kao otkup za svoj život. ");
INSERT INTO srponstl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Zatim uzmi otkupni novac od Izrailjaca, i upotrebi ga za službu u Šatoru od sastanka. Neka to bude podsetnik Izrailjcima pred Gospodom, da ste otkupili svoje živote.“ ");
INSERT INTO srponstl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","„Napravi umivaonik od bronze sa bronzanim postoljem, za pranje. Postavi ga između Šatora od sastanka i žrtvenika, i nalij u njega vodu. ");
INSERT INTO srponstl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Neka Aron i njegovi sinovi peru u njemu ruke i noge. ");
INSERT INTO srponstl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kad god ulaze u Šator od sastanka, neka se operu vodom, da ne pomru. Takođe, kad god pristupaju žrtveniku da obavljaju službu i da prinose svespalnice Gospodu, ");
INSERT INTO srponstl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","neka operu ruke i noge, da ne pomru. Ovo je trajna uredba za Arona i njegovo potomstvo za sva njihova buduća pokolenja.“ ");
INSERT INTO srponstl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Zatim Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","„Uzmi najbolje začine: pet stotina šekela smirne, polovinu te mere cimeta, to jest, dve stotine pedeset šekela, dve stotine pedeset šekela mirišljave trske, ");
INSERT INTO srponstl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","pet stotina šekela kasije prema hramskoj meri, i hin maslinovog ulja. ");
INSERT INTO srponstl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Napravi od toga sveto ulje za pomazanje apotekarskom veštinom. To će biti sveto ulje za pomazanje. ");
INSERT INTO srponstl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Njime pomaži Šator od sastanka i Kovčeg svedočanstva; ");
INSERT INTO srponstl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","sto i sav njegov pribor; svećnjak i sav njegov pribor; kadioni žrtvenik; ");
INSERT INTO srponstl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","žrtvenik za žrtve svespalnice i sav njegov pribor, i umivaonik sa svojim postoljem. ");
INSERT INTO srponstl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Posveti ih, pa će biti presveta svetinja. Ko god ga se dotakne biće posvećen. ");
INSERT INTO srponstl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Zatim pomaži Arona i njegove sinove, i posveti ih da mi služe kao sveštenici. ");
INSERT INTO srponstl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","A Izrailjcima reci: ’Ovo je moje posvećeno ulje za pomazanje za sva pokolenja. ");
INSERT INTO srponstl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ono se ne sme izlivati na telo neposvećenog čoveka, niti ga pravite od istih sastojaka. Ono je sveto, pa sveto neka bude i vama. ");
INSERT INTO srponstl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ko god napravi ulje od istih sastojaka ili ga stavi na nekog tuđinca, neka se istrebi iz svog naroda.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Gospod još reče Mojsiju: „Uzmi začine: natafe, šeheleta, helbene, i čistog tamjana, sve u jednakim količinama, ");
INSERT INTO srponstl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","pa napravi miomirisni kad apotekarskom veštinom, posoljen, čist i svet. ");
INSERT INTO srponstl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Nešto od toga izmrvi u prah i stavi pred Svedočanstvo u Šatoru od sastanka, gde ću se sastajati s tobom. Ulje neka bude za vas presveta svetinja. ");
INSERT INTO srponstl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Miomirisni kad spravljen od ovih sastojaka ne smete praviti za sebe. To drži kao svetinju, jer je Gospodu posvećeno. ");
INSERT INTO srponstl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ko god za sebe napravi takav kad da mu miriše, neka se istrebi iz svoga naroda.“ ");
INSERT INTO srponstl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Gospod opet reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","„Vidi, ja sam po imenu pozvao Veseleila, sina Urijinog, sina Orovog, iz Judinog plemena. ");
INSERT INTO srponstl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ispunio sam ga Duhom Božijim, i podario mu mudrost, pronicljivost i znanje za svaku vrstu veštine: ");
INSERT INTO srponstl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","da vešto smišlja nacrte za izradu predmeta od zlata, srebra i bronze; ");
INSERT INTO srponstl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","da reže i umeće kamenje; da rezbari drvo, i da radi svakovrsne poslove. ");
INSERT INTO srponstl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Njemu sam pridodao Elijava, sina Ahisamakovog, iz Danovog plemena. Veštinom sam obdario i sve sposobne ljude, da naprave sve što sam zapovedio: ");
INSERT INTO srponstl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Šator od sastanka, Kovčeg svedočanstva s poklopcem na njemu; sav nameštaj za Šator; ");
INSERT INTO srponstl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","sto i njegov pribor; svećnjak od čistog zlata sa svim svojim priborom; kadioni žrtvenik; ");
INSERT INTO srponstl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","žrtvenik za žrtve svespalnice sa svim svojim priborom, i umivaonik sa svojim postoljem; ");
INSERT INTO srponstl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","pa izvezene odežde, posvećene odežde za sveštenika Arona i odežde za njegove sinove kad služe kao sveštenici; ");
INSERT INTO srponstl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ulje za pomazanje, i miomirisni kad za Svetinju. Neka učine sve kako sam zapovedio.“ ");
INSERT INTO srponstl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Zatim Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","„Reci ovo Izrailjcima: ’Držite moje subote, jer je to znak između mene i vas, od pokolenja do pokolenja, da biste znali da sam ja, Gospod, koji vas posvećujem. ");
INSERT INTO srponstl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Držite subotu, jer je sveta za vas. Ko god je oskrnavi, neka se svakako pogubi; ko god bude radio kakav posao u subotu, neka se istrebi iz svog naroda. ");
INSERT INTO srponstl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Šest dana neka se radi, a sedmog dana neka bude subota potpunog odmora posvećena Gospodu. Ko god bude radio kakav posao u subotu, neka se svakako pogubi. ");
INSERT INTO srponstl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Stoga, neka Izrailjci drže subotu, slaveći je kao večni savez od pokolenja do pokolenja. ");
INSERT INTO srponstl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","To će biti večni znak između mene i Izrailjaca, jer je Gospod za sedam dana stvorio nebo i zemlju, a u sedmi dan je prestao da radi i odahnuo.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kad je Gospod prestao da govori s Mojsijem na gori Sinaj, dao mu je dve ploče Svedočanstva, kamene ploče, ispisane Božijim prstom. ");
INSERT INTO srponstl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Kad je narod video da Mojsije dugo ne silazi s gore, sabrao se oko Arona i rekao mu: „Na noge! Napravi nam boga koji će ići pred nama, jer ne znamo šta se dogodilo sa onim Mojsijem koji nas je izveo iz Egipta.“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aron im odgovori: „Poskidajte zlatne naušnice sa ušiju svojih žena, sinova i ćerki, pa ih donesite k meni.“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Sav narod je poskidao zlatne naušnice sa svojih ušiju i doneo ih Aronu. ");
INSERT INTO srponstl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ovaj je to zatim uzeo od njih, rastopio zlato u kalupu i od toga napravio kip teleta. Narod reče: „Evo, tvojih bogova, Izrailju, koji su te izveli iz egipatske zemlje!“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Kad je Aron to video, sagradio je pred njim žrtvenik i objavio: „Sutra je praznik Gospodu!“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Sledećeg jutra su ustali, prineli žrtvu svespalnicu i pristupili sa žrtvama mira. Onda je narod posedao da jede i pije, i ustao da se zabavlja. ");
INSERT INTO srponstl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Tada Gospod reče Mojsiju: „Idi i siđi, jer se iskvario tvoj narod, koji si izveo iz zemlje egipatske! ");
INSERT INTO srponstl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Brzo su skrenuli s puta koji sam im zapovedio. Izlili su sebi kip teleta, klanjali mu se i prineli mu žrtve. I još su govorili: ’Ovo je bog tvoj, Izrailju, koji te je izveo iz Egipta!’“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Gospod nastavi: „Vidim da je ovaj narod tvrda vrata. ");
INSERT INTO srponstl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Zato me pusti sada da iskalim svoj gnev na njima i da ih pobijem. Onda ću od tebe učiniti veliki narod.“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Tada Mojsije stade da preklinje Gospoda, svoga Boga: „Zašto, Gospode, da iskaljuješ svoj gnev na tvoj narod koji si izveo iz Egipta velikom silom i moćnom rukom? ");
INSERT INTO srponstl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Zašto da Egipćani kažu: ’Sa zlom ih je namerom izveo, da ih pobije u gorama, i istrebi ih s lica zemlje’? Odvrati svoj plamteći gnev i odustani od nevolje kojom hoćeš da udariš svoj narod! ");
INSERT INTO srponstl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Seti se svojih slugu Avrahama, Isaka i Izrailja, kojima si se zakleo samim sobom, rekavši im: ’Umnožiću vaše potomstvo kao zvezde na nebu, i svu ovu zemlju koju sam vam obećao daću vašem potomstvu, da zauvek postane njihovo nasledstvo.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","I Gospod je odustao od nesreće, koju je nameravao da svali na svoj narod. ");
INSERT INTO srponstl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mojsije se okrene i siđe s gore. U rukama je nosio dve ploče Svedočanstva. Ploče su bile ispisane na obe strane; ispisane i s jedne i s druge strane. ");
INSERT INTO srponstl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ploče su bile Božije delo; reči na pločama je urezao sam Bog. ");
INSERT INTO srponstl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Isus Navin je čuo buku naroda koji je galamio, pa je rekao Mojsiju: „Ratna buka u taboru!“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mojsije mu na to reče: „Ne kliču to pobednici, niti žale pobeđeni, pevanje je sve što čujem.“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Kad se približio taboru i video tele i igranje, Mojsije planu gnevom. Baci on ploče iz ruku i razbije ih na podnožju gore. ");
INSERT INTO srponstl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Onda uzme tele, spali ga i izmrvi u prah, pa ga prospe u vodu i natera Izrailjce da je piju. ");
INSERT INTO srponstl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mojsije, potom, upita Arona: „Šta ti je skrivio ovaj narod, da si ga uvalio u tako veliki greh?“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","„Neka se moj gospodar ne gnevi – odgovori mu Aron. I sam znaš da je ovaj narod sklon zlu. ");
INSERT INTO srponstl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Oni su mi rekli: ’Napravi nam bogove koji će ići pred nama, jer ne znamo šta se dogodilo s onim čovekom Mojsijem, koji nas je izveo iz Egipta.’ ");
INSERT INTO srponstl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ja sam im onda rekao: ’Ko ima zlata, neka ga skine sa sebe.’ Oni su mi dali zlato, a ja sam ga bacio u vatru, i izašlo je ovo tele.“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mojsije je video da se narod razuzdao, jer ga je Aron prepustio razuzdanosti, na zluradost njegovih neprijatelja. ");
INSERT INTO srponstl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Tada Mojsije stade na ulaz u tabor i reče: „Ko je za Gospoda, neka stane uz mene.“ Svi Leviti se okupiše oko njega. ");
INSERT INTO srponstl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","On im reče: „Govori Gospod, Bog Izrailjev: ’Neka svako od vas pripaše mač o bedro! Vratite se i prođite kroz tabor, od ulaza do ulaza, pa neka svako ubije ko brata, ko prijatelja, ko suseda.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Leviti su učinili kako im je Mojsije naredio. Tog dana je palo oko tri hiljade ljudi. ");
INSERT INTO srponstl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Tada Mojsije reče: „Danas ste stupili u službu Gospodnju, svaki uz cenu sina ili brata, te vas je on blagoslovio danas.“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ujutro je Mojsije rekao narodu: „Veliki ste greh počinili. Ipak, ja ću se uspeti Gospodu, ne bih li ga, kako, umolio za otkupljenje vašeg greha.“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mojsije se vrati Gospodu i reče: „O, kako je velik greh počinio ovaj narod napravivši sebi boga od zlata! ");
INSERT INTO srponstl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ali sada im oprosti greh, a ako nećeš, izbriši i mene iz svoje knjige koju si napisao.“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Gospod reče Mojsiju: „Izbrisaću iz svoje knjige samo onog koji je zgrešio protiv mene. ");
INSERT INTO srponstl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","A ti sad povedi ovaj narod tamo gde sam ti rekao. Evo, moj Anđeo će ići pred tobom. A kad dođe vreme da ih kaznim, kazniću ih za njihov greh.“ ");
INSERT INTO srponstl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Gospod je udario narod pomorom zbog teleta, koje je Aron napravio. ");
INSERT INTO srponstl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Gospod reče Mojsiju: „Idi! Idi odavde gore, ti i narod koji si izveo iz Egipta, i pođi gore u zemlju za koju sam se zakleo Avrahamu, Isaku i Jakovu: ’Daću je tvom potomstvu.’ ");
INSERT INTO srponstl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","A ja ću poslati pred tobom Anđela i isteraću Hanance, Amorejce, Hetite, Ferežane, Evejce i Jevusejce ");
INSERT INTO srponstl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","i dovesti vas u zemlju kojom teku mleko i med. Ja neću poći gore s tobom, da vas ne bih istrebio na putu, jer ste narod tvrdovrat.“ ");
INSERT INTO srponstl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kad je narod čuo ove oštre reči, toliko se ožalostio da niko nije stavio na sebe nakit. ");
INSERT INTO srponstl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Gospod reče Mojsiju: „Reci Izrailjcima: ’Vi ste narod tvrdovrat. Kad bih samo za tren išao gore sa vama, pobio bih vas. Zato skinite sa sebe nakit, a ja ću videti kako da postupim s vama.’“ ");
INSERT INTO srponstl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Tako su Izrailjci poskidali sa sebe nakit kod gore Horiv. ");
INSERT INTO srponstl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mojsije je uzeo šator i postavio ga daleko izvan tabora. Nazvao ga je šator od sastanka. Ko god je hteo da traži volju Gospodnju, odlazio bi u šator od sastanka koji se nalazio izvan tabora. ");
INSERT INTO srponstl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","A kada bi Mojsije odlazio u šator, sav narod bi ustajao i svako bi stajao na ulazu u svoj šator i gledao za Mojsijem sve dok ovaj ne uđe u šator. ");
INSERT INTO srponstl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kad bi Mojsije ušao u šator, stub oblaka bi se spuštao i stajao na ulazu u šator, dok je Gospod razgovarao sa Mojsijem. ");
INSERT INTO srponstl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kada bi narod video da stub oblaka stoji na ulazu u šator, sav narod bi ustajao i svako bi se klanjao na ulazu svoga šatora. ");
INSERT INTO srponstl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Gospod je razgovarao s Mojsijem licem u lice, kao što bi neko razgovarao sa svojim prijateljem. Mojsije bi se zatim vratio u tabor. Međutim, njegov pomoćnik Isus, sin Navinov, mladić, ne bi napuštao šator. ");
INSERT INTO srponstl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mojsije se obrati Gospodu: „Ti si mi rekao: ’Povedi ovaj narod’, ali mi nisi objavio koga ćeš poslati sa mnom. Ti si takođe rekao: ’Poznajem te po imenu, i ti si našao naklonost preda mnom.’ ");
INSERT INTO srponstl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ako sam, dakle, našao naklonost pred tobom, otkrij mi svoje puteve da bih te poznavao i da bih i dalje nalazio tvoju naklonost. Uzmi u obzir da je ovaj narod tvoj narod.“ ");
INSERT INTO srponstl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Gospod na to reče: „Ja lično ću poći s tobom, i tako te uspokojiti.“ ");
INSERT INTO srponstl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mojsije reče: „Ako ti lično ne pođeš sa nama, ne izvodi nas odavde gore. ");
INSERT INTO srponstl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Kako će se znati da sam našao naklonost pred tobom, ja i tvoj narod, ako ne po tome što ćeš poći sa nama? Po tome ćemo se razlikovati, ja i tvoj narod, od svih drugih naroda na zemlji.“ ");
INSERT INTO srponstl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Gospod reče Mojsiju: „Učiniću sve što si tražio, zato što si našao naklonost preda mnom i zato što te poznajem po imenu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mojsije zamoli: „Pokaži mi svoju slavu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","„Učiniću da moja dobrota prođe pored tebe – reče Gospod – i izgovoriću pred tobom svoje ime Gospod. Smilovaću se kome hoću da se smilujem, i iskazaću milosrđe kome hoću da iskažem milosrđe. ");
INSERT INTO srponstl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Moje lice ne možeš videti – reče – jer nijedan čovek me ne može videti i ostati u životu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Gospod reče: „Evo, ovde kod mene je jedno mesto; stani na ovu stenu. ");
INSERT INTO srponstl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Kad moja slava bude prolazila, staviću te u procep stene i zakloniti te svojom rukom dok ne prođem. ");
INSERT INTO srponstl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Onda ću skloniti svoju ruku, pa ćeš me videti s leđa. No, moje lice se ne može videti.“ ");
INSERT INTO srponstl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Gospod reče Mojsiju: „Iskleši sebi dve kamene ploče kao što su bile one prve, a ja ću na njima ispisati iste reči koje su bile napisane na prvim pločama koje si razbio. ");
INSERT INTO srponstl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Budi gotov do jutra, a ujutro se uspni na goru Sinaj i stani tamo, na vrhu gore, pred mene. ");
INSERT INTO srponstl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Neka se niko ne penje s tobom; niko ne sme da se pojavi na celoj gori. Ni ovce ni goveda neka ne pasu pred gorom.“ ");
INSERT INTO srponstl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mojsije je isklesao dve kamene ploče kao što su bile pređašnje, pa se ujutro popeo na goru Sinaj noseći u rukama dve kamene ploče, kako mu je Gospod zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Tada je Gospod sišao u oblaku, stao kod Mojsija i izgovorio svoje ime: „Gospod!“ ");
INSERT INTO srponstl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Gospod je prošao pokraj njega i izgovorio svoje ime: „Gospod! Gospod! Bog milostivi i milosrdni, spor na srdžbu, bogat milošću i vernošću, ");
INSERT INTO srponstl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","iskazuje milost hiljadama, oprašta krivicu, prestup i greh, ali krivca ne ostavlja nekažnjena, nego kažnjava greh otaca na njihovoj deci i unucima sve do trećeg i četvrtog kolena.“ ");
INSERT INTO srponstl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mojsije odmah pade na zemlju i pokloni se Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Mojsije reče: „Ako sam stekao naklonost pred tobom, molim te, Gospode, da pođeš sa nama. Iako je ovaj narod tvrdovrat, oprosti nam krivicu i grehe, pa nas prihvati kao svoju baštinu.“ ");
INSERT INTO srponstl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Gospod na to reče: „Evo, sklapam savez: učiniću takva čuda pred tvojim narodom kakva nikada nisu bila učinjena ni u kojoj zemlji, ni u kojem narodu. Tada će svaki narod usred koga boraviš videti šta Gospod čini, jer ono što ću učiniti za tebe, biće zadivljujuće. ");
INSERT INTO srponstl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Drži sve što ti zapovedam danas. Evo, ja ću proterati pred tobom Amorejce, Hanance, Hetite, Ferežane, Evejce i Jevusejce. ");
INSERT INTO srponstl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Čuvaj se da ne sklopiš savez sa stanovništvom zemlje u koju ulaziš, da ne postanu zamka u tvojoj sredini. ");
INSERT INTO srponstl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Nego, porušite njihove žrtvenike, oborite njihove stubove i posecite Aštartine stubove. ");
INSERT INTO srponstl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ne služite ni jednom drugom bogu! Gospod je na glasu po svojoj ljubomori, jer je on ljubomorni Bog. ");
INSERT INTO srponstl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ne sklapaj savez sa stanovnicima one zemlje! Jer, kada budu bludničili sa svojim bogovima i prinosili im žrtve, pozivaće i tebe, te ćeš jesti od njihovih žrtava, ");
INSERT INTO srponstl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","i uzimati svojim sinovima njihove ćerke. Onda će one, kada budu bludničile sa svojim bogovima, navesti i tvoje sinove na blud sa svojim bogovima. ");
INSERT INTO srponstl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ne izlivaj sebi livene idole. ");
INSERT INTO srponstl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Održavaj praznik Beskvasnih hlebova. Sedam dana jedi beskvasne hlebove, kako sam ti zapovedio – u određeno vreme u mesecu avivu, jer si u tom mesecu izašao iz Egipta. ");
INSERT INTO srponstl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Svaki prvenac majčine utrobe meni pripada, kao i svaka prvina od tvoje sitne i krupne stoke. ");
INSERT INTO srponstl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Prvinu magarca otkupi jagnjetom, a ako ga ne otkupiš, zavrni mu vrat. Otkupi svakog prvenca od svojih sinova. Ne pojavljujte se preda mnom praznih ruku! ");
INSERT INTO srponstl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Šest dana radi, a sedmoga otpočini; moraš otpočinuti čak i za vreme oranja ili žetve. ");
INSERT INTO srponstl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Slavi praznik Sedmica – prvih snopova pšenične žetve i praznik Berbe pri kraju godine. ");
INSERT INTO srponstl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Triput godišnje neka se svi tvoji muški pojave pred Gospodom, Bogom Izrailjevim. ");
INSERT INTO srponstl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ja ću, naime, izgnati narode pred tobom i proširiti tvoje granice, tako da niko neće žudeti za tvojom zemljom kad triput godišnje budeš išao da se pojaviš pred Gospodom, Bogom svojim. ");
INSERT INTO srponstl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ne prinosi mi krv žrtve sa kvascem, niti ostavljaj žrtvu prinesenu za praznik Pashe do jutra. ");
INSERT INTO srponstl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Najbolje prvine svoje zemlje donesi u dom Gospoda, svoga Boga. Ne kuvaj jare u mleku njegove majke.“ ");
INSERT INTO srponstl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Gospod reče Mojsiju: „Napiši ove reči koje sam ti rekao, jer sam na osnovu ovih reči sklopio savez sa tobom i sa Izrailjem.“ ");
INSERT INTO srponstl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mojsije je proveo sa Gospodom četrdeset dana i četrdeset noći tokom kojih nije jeo hleba niti pio vode. Tada je na pločama napisao reči saveza – deset zapovesti. ");
INSERT INTO srponstl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mojsije je sišao sa gore Sinaj. Dok je silazio sa gore noseći u rukama dve ploče Svedočanstva, nije znao da mu se lice sjaji zbog razgovora sa Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Kada su Aron i Izrailjci videli da mu se lice sjaji, plašili su se da mu priđu. ");
INSERT INTO srponstl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mojsije ih je pozvao, pa su se vratili k njemu Aron i svi knezovi zajednice. Tada je Mojsije razgovarao sa njima. ");
INSERT INTO srponstl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Zatim su mu prišli i svi Izrailjci, a on im je preneo sve reči koje mu je Gospod rekao na gori Sinaj. ");
INSERT INTO srponstl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Kad je Mojsije završio razgovor sa njima, pokrio je sebi lice velom. ");
INSERT INTO srponstl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Kad god je Mojsije ulazio pred Gospoda da razgovara sa njim, skidao bi veo sve dok ne izađe. Kad bi izašao i preneo Izrailjcima što mu je Gospod zapovedio, ");
INSERT INTO srponstl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","oni bi videli da se Mojsijevo lice sjaji. Tada bi Mojsije vraćao veo na svoje lice, sve dok ne uđe da razgovara sa Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mojsije je okupio svu zajednicu Izrailjaca i rekao im: „Ovo je Gospod zapovedio da se čini: ");
INSERT INTO srponstl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Šest dana obavljaj sve svoje poslove, a sedmi dan neka vam bude sveta subota potpunog odmora Gospodu. Ko god bude radio na taj dan, neka se usmrti. ");
INSERT INTO srponstl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ne palite vatru po vašim mestima na subotnji dan.“ ");
INSERT INTO srponstl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mojsije reče celoj zajednici Izrailjaca: „Ovo je Gospod zapovedio: ");
INSERT INTO srponstl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","izdvojte prilog za Gospoda. Svako u koga je široko srce neka da prilog za Gospoda: zlato, srebro i bronzu; ");
INSERT INTO srponstl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ljubičastu, skerletnu i tamno crvenu tkaninu, fini lan i kostret; ");
INSERT INTO srponstl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ovnujske kože obojene u crveno, fine kože i bagremovo drvo; ");
INSERT INTO srponstl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ulje za svetlo, začine za ulje pomazanja i miomirisni kad; ");
INSERT INTO srponstl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","oniks i drugo drago kamenje za ukivanje u oplećak i naprsnik. ");
INSERT INTO srponstl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Ko god je vešt među vama neka dođe da napravi što je Gospod zapovedio: ");
INSERT INTO srponstl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Prebivalište – njegov Šator i pokrivač, kopče, daske, obruče, stubove i podnožja; ");
INSERT INTO srponstl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Kovčeg sa njegovim drškama, poklopac i pregradnu zavesu; ");
INSERT INTO srponstl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","sto sa njegovim drškama i svim njegovim priborom; prinesene hlebove; ");
INSERT INTO srponstl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","svećnjak za svetlo i sav njegov pribor, lampe i ulje za osvetljenje; ");
INSERT INTO srponstl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","kadioni žrtvenik sa svojim drškama, ulje pomazanja i začine za kađenje; zastor za ulaz u Prebivalište; ");
INSERT INTO srponstl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","žrtvenik za žrtve svespalnice sa bronzanom oplatom, drškama i svim njegovim priborom; umivaonik sa svojim postoljem; ");
INSERT INTO srponstl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","zavese za dvorište sa stubovima i podnožjima, i zastor za dvorišni ulaz; ");
INSERT INTO srponstl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","kočiće za Prebivalište i kočiće za dvorište sa njihovom užadi; ");
INSERT INTO srponstl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","izvezene odežde za službu u Svetinji – posvećene odežde za sveštenika Arona i odežde za svešteničku službu njegovih sinova.“ ");
INSERT INTO srponstl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Nakon toga je cela zajednica otišla od Mojsija. ");
INSERT INTO srponstl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Onda su došli svi koje je srce vuklo, svako darežljivog duha, pa su doneli prilog Gospodu za radove na Šatoru od sastanka, za njegovu službu i za posvećene odežde. ");
INSERT INTO srponstl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Došli su i muškarci i žene, svi darežljivog srca, i doneli broševe, naušnice, prstenje, narukvice, lančiće i razne predmete od zlata; svako od njih je doneo zlato kao posvetni dar za Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","I svako kod koga se našla ljubičasta, skerletna i tamno crvena tkanina, fini lan, kozja koža, uštavljene ovnujske kože, kože obojene u crveno ili fina koža, to je doneo. ");
INSERT INTO srponstl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Isto tako i svi koji su hteli da prinesu srebro ili bronzu donosili su to kao prinos Gospodu. Svi koji su imali bagremova drva donosili su ga za izradu svakovrsnih predmeta. ");
INSERT INTO srponstl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Sve žene vične predenju su donele što su isprele svojim rukama: ljubičastu, skerletnu i tamno crvenu tkaninu i fini lan. ");
INSERT INTO srponstl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Sve žene koje je srce poticalo, prele su kostret. ");
INSERT INTO srponstl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Knezovi su donosili oniks i drugo drago kamenje za umetanje u oplećak i naprsnik; ");
INSERT INTO srponstl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","začine i ulje za svetlo, za pomazanje i za miomirisni kad. ");
INSERT INTO srponstl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Svi Izrailjci – svi ljudi i žene koje je srce poticalo da prilože što god za posao koji je Gospod preko Mojsija zapovedio da se uradi – donosili su dobrovoljni prilog Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mojsije reče Izrailjcima: „Vidite! Gospod je po imenu pozvao Veseleila, sina Urijinog, sina Orovog, iz plemena Judinog. ");
INSERT INTO srponstl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","On ga je ispunio Duhom Božijim, i dao mu mudrost, pronicljivost i znanje za svaku vrstu veštine, ");
INSERT INTO srponstl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","da vešto smišlja nacrte za izradu predmeta od zlata, srebra i bronze; ");
INSERT INTO srponstl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","da reže i umeće kamenje; da rezbari drvo, i da radi svakovrsni umetnički posao. ");
INSERT INTO srponstl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Njemu i Elijavu, sinu Ahisamakovom, iz plemena Danovog, dao je sposobnost da poučavaju druge. ");
INSERT INTO srponstl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Obdario ih je umećem za izvođenje svakojakih radova: za rezbarenje, pravljenje nacrta, vezenje ljubičaste, skerletne i tamno crvene tkanine i finog lana, kao i za pletenje. Oni su vični svim poslovima i pravljenju nacrta. ");
INSERT INTO srponstl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Neka tako Veseleilo, Elijav i svi koje je Gospod obdario sposobnošću, umećem i razumom da znaju kako da urade sav posao na Svetinji, izvrše sve što je Gospod zapovedio.“ ");
INSERT INTO srponstl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mojsije pozva Veseleila, Elijava i sve sposobne ljude koje je Gospod obdario umećem; sve koje je poticalo srce da se late posla i urade ga. ");
INSERT INTO srponstl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Oni su tada primili sav dobrovoljni prilog od Mojsija koji su Izrailjci doneli za izvođenje radova oko Svetinje. No, kako su mu oni jutro za jutrom još uvek donosili priloge, ");
INSERT INTO srponstl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","dođoše svi majstori koji su obavljali radove na Svetinji – svaki sa posla na kome je radio – ");
INSERT INTO srponstl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","i rekoše Mojsiju: „Narod donosi i više nego što je potrebno da se obavi posao koji je Gospod zapovedio da se uradi.“ ");
INSERT INTO srponstl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Tada je Mojsije izdao naredbu koja je bila objavljena u taboru: „Neka više nijedan čovek ni žena ne pravi više ništa kao prilog za Svetinju.“ Tako je narod prestao da donosi. ");
INSERT INTO srponstl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Bilo je svega dovoljno da se uradi posao, čak je i preostalo. ");
INSERT INTO srponstl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Tada su svi sposobni ljudi, koji su bili među onima što su obavljali posao, sagradili Prebivalište od deset zavesa. Bile su načinjene od finog lana, ljubičaste, skerletne i tamno crvene tkanine, na kojima su bili veštinom umetnika izvezeni heruvimi. ");
INSERT INTO srponstl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Sve zavese su bile iste mere: dvadeset osam lakata u dužinu i četiri lakta u širinu. ");
INSERT INTO srponstl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Veseleilo je spojio pet zavesa jednu s drugom, a tako je i drugih pet zavesa spojio jednu s drugom. ");
INSERT INTO srponstl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Zatim je napravio petlje od ljubičaste tkanine pri rubu poslednje zavese spojenoga dela, a tako je napravio pri rubu poslednje zavese u drugoj polovini spojenog dela. ");
INSERT INTO srponstl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Napravio je pedeset petlji na prvoj zavesi i pedeset petlji pri rubu poslednje zavese drugog spojenog dela. Petlje su stajale jedna naspram druge. ");
INSERT INTO srponstl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Onda je napravio pedeset kopči od zlata, pa je njima spojio zavese jednu s drugom. Tako je Prebivalište bilo jedna celina. ");
INSERT INTO srponstl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Napravio je i zavese od kozje dlake za Šator povrh Prebivališta. Napravio je jedanaest zavesa. ");
INSERT INTO srponstl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Dužina svake zavese je bila trideset lakata, a širina svake zavese četiri lakta. Svih jedanaest zavesa su bile iste mere. ");
INSERT INTO srponstl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Prvih pet zavesa je spojio posebno, a ostalih šest zavesa posebno. ");
INSERT INTO srponstl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Napravio je pedeset petlji na rubu krajnje zavese jednog spojenog dela, i pedeset petlji na rubu drugog spojenog dela. ");
INSERT INTO srponstl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Zatim je napravio pedeset bronzanih kopči da drže Šator, tako da bude jedna celina. ");
INSERT INTO srponstl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Napravio je i pokrivač za Šator od ovnujskih koža obojenih u crveno, a povrh njega pokrivač od finih koža. ");
INSERT INTO srponstl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Onda je napravio daske od bagremovog drveta za Prebivalište, da stoje uspravno u njemu. ");
INSERT INTO srponstl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Svaka daska je bila deset lakata dugačka i jedan i po lakat široka. ");
INSERT INTO srponstl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Svaka daska je imala po dva klina da drži daske jednu uz drugu. To je napravio za sve daske u Prebivalištu. ");
INSERT INTO srponstl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Za južnu stranu Prebivališta napravio je dvadeset dasaka, ");
INSERT INTO srponstl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","i četrdeset srebrnih podnožja ispod dvadeset dasaka – dva podnožja ispod jedne daske, za njena dva klina, i dva podnožja ispod druge daske, za njena dva klina. ");
INSERT INTO srponstl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Tako je i na severnoj strani Prebivališta napravio dvadeset dasaka ");
INSERT INTO srponstl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","sa četrdeset srebrnih podnožja – dva podnožja ispod jedne daske, i po dva podnožja ispod svake naredne daske. ");
INSERT INTO srponstl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Za zapadnu stranu Prebivališta napravio je šest dasaka ");
INSERT INTO srponstl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","i dve daske za uglove Prebivališta na zadnjoj strani. ");
INSERT INTO srponstl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Bile su udvojene od dna, pa sve do vrha, gde su bile spojene jednim obručem. Tako je napravio po dve daske za oba ugla. ");
INSERT INTO srponstl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Bilo je, dakle, osam dasaka i šesnaest srebrnih podnožja; po dva podnožja za svaku dasku. ");
INSERT INTO srponstl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Zatim je napravio prečage od bagremovog drveta: pet prečaga za daske na jednoj strani Prebivališta, ");
INSERT INTO srponstl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","pet prečaga za daske na drugoj strani Prebivališta, i pet prečaga za zadnju stranu Prebivališta, prema zapadu. ");
INSERT INTO srponstl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Napravio je središnju prečagu, da se proteže sredinom dasaka, s jednog kraja na drugi. ");
INSERT INTO srponstl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Daske je obložio zlatom, a njihove obruče koje drže prečage je napravio od zlata. Prečage je obložio zlatom. ");
INSERT INTO srponstl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Napravio je i zavesu od ljubičaste, skerletne i tamno crvene tkanine, i finog lana, a na njoj izvezao heruvime umetničkom veštinom. ");
INSERT INTO srponstl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Za nju je napravio četiri stuba od bagremovog drveta i obložio ih zlatom. Njihove kuke su bile od zlata, i za njih je izlio četiri podnožja od srebra. ");
INSERT INTO srponstl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Za ulaz u Šator napravio je zastor od ljubičaste, skerletne i tamno crvene tkanine, i finog lana, vezom izvezenog, ");
INSERT INTO srponstl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","i pet stubića sa njegovim kukama. Vrhove stubova i njihove obruče je obložio zlatom, dok su njihovih pet podnožja bila od bronze. ");
INSERT INTO srponstl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Veseleilo je napravio Kovčeg od bagremovog drveta; dva i po lakta dug, lakat i po širok i lakat i po visok. ");
INSERT INTO srponstl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Obložio ga je čistim zlatom iznutra i spolja, i napravio mu zlatan venac unaokolo. ");
INSERT INTO srponstl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Zatim je izlio za njega četiri koluta od zlata za sve njegove četiri strane; dva koluta na jednoj strani i dva koluta na drugoj strani. ");
INSERT INTO srponstl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Napravio je i drške od bagremovog drveta i obložio ih zlatom. ");
INSERT INTO srponstl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Drške je provukao kroz kolutove s obe strane Kovčega za nošenje Kovčega. ");
INSERT INTO srponstl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Onda je napravio poklopac za Kovčeg od čistog zlata; dva i po lakta dužine i lakat i po širine. ");
INSERT INTO srponstl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Napravio je dva heruvima od kovanog zlata, i prikovao ih na oba kraja poklopca; ");
INSERT INTO srponstl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","jednog heruvima na jedan kraj, a drugog heruvima na drugi kraj poklopca. Heruvime je napravio tako da sa poklopcem čine jednu celinu. ");
INSERT INTO srponstl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Heruvimi su imali podignuta krila prema gore, tako da zaklanjaju poklopac. Bili su licem okrenuti jedan prema drugome, tako da su im lica bila okrenuta prema poklopcu. ");
INSERT INTO srponstl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Zatim je napravio sto od bagremovog drveta; dva lakta dug, jedan lakat širok i jedan i po lakat visok. ");
INSERT INTO srponstl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Obložio ga je čistim zlatom, i obrubio ga zlatnim pojasom. ");
INSERT INTO srponstl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Napravio mu je i dlan široki okvir oko njega, i obrubio ga zlatnim pojasom. ");
INSERT INTO srponstl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Za sto je izlio četiri zlatna koluta i postavio ih na njegova četiri nožna ugla. ");
INSERT INTO srponstl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Kolutovi su bili pod okvirom da drže drške za nošenje stola. ");
INSERT INTO srponstl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Drške za nošenje stola je napravio od bagremovog drveta i obložio ih zlatom. ");
INSERT INTO srponstl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Onda je od čistog zlata napravio pribor za sto: tanjire, čaše, zdele, vrčeve i pehare za izlivanje prinosa. ");
INSERT INTO srponstl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Svećnjak je napravio od čistog zlata. Njegovo postolje, stalak, čašice, pupoljci i latice bili su iskovani iz jednog komada. ");
INSERT INTO srponstl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Granao se u šest krakova: tri kraka s jedne strane stalka i tri kraka s druge strane stalka. ");
INSERT INTO srponstl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Na jednom kraku bile su tri čašice u obliku bademovog cveta, svaka s pupoljcima i laticama. Na drugom kraku su takođe bile tri čašice u obliku bademovog cveta, svaka s pupoljcima i laticama. Tako je bilo sa svih šest krakova koji izbijaju iz svećnjaka. ");
INSERT INTO srponstl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na svećnjaku je bilo četiri čašice u obliku bademovog cveta, svaka s pupoljcima i laticama. ");
INSERT INTO srponstl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Jedan pupoljak je bio ispod prva dva kraka, drugi pupoljak ispod druga dva kraka, i treći pupoljak ispod poslednja dva kraka. Tako je bilo na svih šest krakova koji izbijaju iz svećnjaka. ");
INSERT INTO srponstl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Pupoljci i krakovi činili su jednu celinu sa svećnjakom; sve je bilo iskovano od jednog komada čistog zlata. ");
INSERT INTO srponstl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Napravio je, zatim, sedam svetiljki sa mašicama i pepeljarama od čistog zlata. ");
INSERT INTO srponstl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Svećnjak sa svim njegovim priborom je napravio od jednog talanta čistog zlata. ");
INSERT INTO srponstl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Zatim je napravio kadioni žrtvenik od bagremovog drveta, jedan lakat dug, jedan lakat širok – četvorouglastog oblika – i dva lakta visok. Rogovi su mu bili napravljeni iz jednog dela s njim. ");
INSERT INTO srponstl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Obložio ga je čistim zlatom: njegovu gornju stranu, njegove strane unaokolo i njegove rogove, i obrubio ga zlatnim okvirom. ");
INSERT INTO srponstl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Na njemu je napravio po dva zlatna koluta ispod okvira na obe bočne strane, za drške kad se na njima nosi. ");
INSERT INTO srponstl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Drške je napravio od bagremovog drveta i obložio ih zlatom. ");
INSERT INTO srponstl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Onda je napravio sveto ulje za pomazanje i čisti miomirisni kad načinjen apotekarskom veštinom. ");
INSERT INTO srponstl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Zatim je napravio žrtvenik za žrtve svespalnice od bagremovog drveta, pet lakata dug, pet lakata širok – četvrtastog oblika – i tri lakta visok. ");
INSERT INTO srponstl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Na njegova četiri ugla napravio mu je rogove, tako da su rogovi bili iz jednog komada sa žrtvenikom, i obložio ga bronzom. ");
INSERT INTO srponstl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Napravio je i pribor za žrtvenik: lonce za uklanjanje pepela, lopatice, kotliće i mašice. Sve posude je načinio od bronze. ");
INSERT INTO srponstl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Za žrtvenik je napravio rešetku od bronze, u obliku mreže. Na mreži je načinio četiri bronzana obruča za njena četiri ugla. ");
INSERT INTO srponstl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Izlio je četiri koluta za četiri kraja bronzane rešetke za oslonac drškama. ");
INSERT INTO srponstl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Onda je napravio drške za žrtvenik od bagremovog drveta i obložio ih bronzom. ");
INSERT INTO srponstl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Drške je provukao kroz kolutove s obe strane žrtvenika, radi nošenja. Napravio ga je od dasaka, i bio je šupalj. ");
INSERT INTO srponstl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Zatim je napravio bronzani umivaonik sa bronzanim postoljem od ogledala žena koje su služile kod ulaza u Šator od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Zatim je napravio dvorište za Prebivalište. Zavese za dvorište na južnoj strani bile su od finog lana, dužine stotinu lakata. ");
INSERT INTO srponstl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Bile su okačene o dvadeset stubova sa dvadeset bronzanih podnožja. Kuke i šipke za stubove bili su od srebra. ");
INSERT INTO srponstl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Dužina zavese na severnoj strani je takođe bila stotinu lakata sa svojih dvadeset stubova i sa dvadeset bronzanih podnožja. Kuke i šipke za stubove su bile od srebra. ");
INSERT INTO srponstl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Na zapadnoj strani, bilo je pedeset lakata zavese sa deset stubova i deset podnožja. Kuke i šipke za stubove su bile od srebra. ");
INSERT INTO srponstl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Na prednjoj, istočnoj strani, bile su zavese od pedeset lakata. ");
INSERT INTO srponstl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Zavese s jedne strane ulaza bile su petnaest lakata duge, sa svoja tri stuba i njihova tri podnožja. ");
INSERT INTO srponstl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Zavese za drugu stranu ulaza bile su takođe petnaest lakata duge, sa svoja tri stuba i njihova tri podnožja. ");
INSERT INTO srponstl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Sve zavese unaokolo su bile od finog lana. ");
INSERT INTO srponstl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Podnožja za stubove su bila od bronze, a kuke na stubovima i njihove šipke od srebra. I vrhovi stubova su bili obloženi srebrom dok su svi dvorišni stubovi imali srebrne vrhove. ");
INSERT INTO srponstl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Zastor na dvorišnim vratima bio je vezom izvezen od ljubičaste, skerletne i tamno crvene tkanine i finog lana. Bio je dvadeset lakata dug i pet lakata visok, kao i dvorišne zavese. ");
INSERT INTO srponstl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Njihovih stubova bilo je četiri. Njihova podnožja su bila od bronze, a njegove kuke od srebra. Vrhovi stubova su bili obloženi srebrom, a njihove šipke su bile od srebra. ");
INSERT INTO srponstl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Svi kočići za Prebivalište i oko dvorišta su bili od bronze. ");
INSERT INTO srponstl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ovo je popis stvari koje su utrošene za Prebivalište – Prebivalište svedočanstva, koji je na Mojsijevu zapovest izvršen trudom Levita pod nadzorom Itamara, sina sveštenika Arona. ");
INSERT INTO srponstl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Veseleilo, sin Urijin, sin Orov, iz plemena Judinog, napravio je sve što je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","S njim je bio Elijav, sin Ahisamakov, iz plemena Danovog, rezbar, tkač i vezilac za ljubičastu, skerletnu i tamno crvenu tkaninu i fini lan. ");
INSERT INTO srponstl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Sveg zlata koje je upotrebljeno za radove na izgradnji Svetinje – priloženog zlata – dvadeset devet talanata sedam stotina trideset šekela, prema hramskom šekelu. ");
INSERT INTO srponstl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","A srebra koje je prikupljeno tokom popisivanja zajednice bilo je stotinu talanata i hiljadu i sedam stotina sedamdeset pet šekela, prema hramskom šekelu – ");
INSERT INTO srponstl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","jedna beka po glavi, to jest, pola šekela prema hramskoj meri, od svakoga koji je bio popisan, od dvadeset godina pa naviše; ukupno šest stotina tri hiljade pet stotina pedeset. ");
INSERT INTO srponstl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Stotinu talanata srebra je bilo utrošeno za izlivanje podnožja za Svetinju i podnožja za zavese; sto podnožja od stotinu talanata srebra – jedan talant za svako podnožje. ");
INSERT INTO srponstl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Od hiljadu sedam stotina sedamdeset pet šekela je napravio kuke za stubove, obložio im vrhove i napravio šipke za njih. ");
INSERT INTO srponstl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Priložene bronze bilo je sedamdeset talanata i dve hiljade četiri stotine šekela. ");
INSERT INTO srponstl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Napravio je i podnožja za ulaz u Šator od sastanka, bronzani žrtvenik s njegovom bronzanom rešetkom i sav pribor za žrtvenik; ");
INSERT INTO srponstl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","zatim, podnožja oko dvorišta, podnožja za dvorišnu kapiju, sve kočiće za Prebivalište, i sve kočiće oko dvorišta. ");
INSERT INTO srponstl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Od ljubičaste, skerletne i tamno crvene tkanine, napravili su svetu odoru za službu u Svetinji; napravili su posvećene odore za Arona, kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Oplećak su napravili od zlata, ljubičaste, skerletne i tamno crvene tkanine i finog lana. ");
INSERT INTO srponstl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Iskovali su pločice od zlata, pa su ih izrezali u niti da se vešto upletu u ljubičastu, skerletnu i tamno crvenu tkaninu i od finog lana – vešto izvezenog. ");
INSERT INTO srponstl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Za oplećak su napravili naramenice koje su bile sastavljene s njim na oba njegova kraja. ");
INSERT INTO srponstl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Pojas kojim se opasivao oplećak je takođe bio napravljen od zlata, ljubičaste, skerletne i tamno crvene tkanine i finog lana, tako da je s njim činio jednu celinu, kao što je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Zatim su oniks optočili okvirom od zlata. Na njemu su, kao na pečatnom prstenu, bila izrezana imena Izrailjevih sinova. ");
INSERT INTO srponstl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Umetnuli su ih u naramenice oplećka da budu podsetnik sinovima Izrailjevim, kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Potom su napravili naprsnik umetničkom veštinom, kao i oplećak: od zlata, ljubičaste, skerletne i tamno crvene tkanine i finog lana. ");
INSERT INTO srponstl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Bio je u obliku četvorougla, udvojen; bio je pedalj dužine, pedalj širine, i podvostručen. ");
INSERT INTO srponstl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Umetnuo je u njega četiri reda dragog kamenja. U prvom redu su bili: rubin, topaz i smaragd; ");
INSERT INTO srponstl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","u drugom redu: malahit, safir i dijamant; ");
INSERT INTO srponstl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","u trećem redu: hijacint, ahat i ametist; ");
INSERT INTO srponstl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","a u četvrtom redu: hrisolit, oniks i jaspis. Bili su optočeni zlatnim okvirom. ");
INSERT INTO srponstl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Bilo je dvanaest dragih kamenova sa imenima sinova Izrailjevih; na svakom je bilo urezano, kao na pečatu na prstenju, po jedno ime za svako od dvanaest plemena. ");
INSERT INTO srponstl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Za naprsnik su napravili lančiće od čistog zlata u obliku upletene uzice. ");
INSERT INTO srponstl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Zatim su napravili dva zlatna kolutića i pričvrstili ih na dva gornja ugla naprsnika. ");
INSERT INTO srponstl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Zlatne lančiće su privezali za dva kolutića na uglovima naprsnika. ");
INSERT INTO srponstl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Oba kraja lančića su privezali za dva okvira i pričvrstili ih za dve naramenice s prednje strane oplećka. ");
INSERT INTO srponstl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Onda su napravili dva kolutića od zlata i pričvrstili ih za dva donja ugla naprsnika, pri rubu unutrašnje strane do oplećka. ");
INSERT INTO srponstl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Zatim su napravili dva kolutića od zlata i pričvrstili ih za donji kraj naramenice oplećka, na njegovoj prednjoj strani, kod šava iznad pojasa oplećka. ");
INSERT INTO srponstl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Kolutiće naprsnika su privezali za kolutiće oplećka uzicom od purpura, da bi naprsnik stajao iznad pojasa, te da ne bi spadao s oplećka, baš kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Potom su napravili plašt za oplećak, sav istkan od ljubičaste tkanine. ");
INSERT INTO srponstl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","U njegovoj sredini je bio prorez za glavu, kao prorez na oklopu. Rub oko proreza bio je opšiven vezenim okovratnikom, da se plašt ne bi cepao. ");
INSERT INTO srponstl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Svuda oko donjeg ruba plašta napravili su narove od ljubičaste, skerletne i tamno crvene tkanine, i finog lana. ");
INSERT INTO srponstl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Napravili su zvončiće od čistog zlata i stavili ih između narova, svuda oko ruba plašta za službu, baš kako je Gospod zapovedio Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","zvonce pa nar, zvonce pa nar, i tako svuda okolo uz rub plašta, kao što je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Aronu i njegovim sinovima su istkali košulje od finog lana, ");
INSERT INTO srponstl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","lanene turbane, lanene kape i gaće od finog lana. ");
INSERT INTO srponstl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Pojasevi su bili vezom izvezeni od finog lana, ljubičaste, skerletne i tamno crvene tkanine, baš kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Zatim su napravili pločicu, posvetni natpis, od čistog zlata i na njemu urezali kao na pečatu: „Posvećen Gospodu“. ");
INSERT INTO srponstl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Privezali su je ljubičastom vrpcom i postavili je na vrh turbana, baš kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Tako su bili završeni svi radovi na Prebivalištu, Šatoru od sastanka. Izrailjci su uradili sve što je Gospod rekao Mojsiju da urade. ");
INSERT INTO srponstl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Onda su doneli Mojsiju Prebivalište, Šator od sastanka i sav njegov pribor: njegove kopče, njegove daske, njegove obruče, njegove stubove i podnožja; ");
INSERT INTO srponstl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","pokrivač od ovnujskih koža obojenih u crveno, pokrivač od finih koža i pregradnu zavesu; ");
INSERT INTO srponstl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Kovčeg svedočanstva sa svojim drškama i poklopac; ");
INSERT INTO srponstl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","sto sa svim njegovim priborom; prinesene hlebove; ");
INSERT INTO srponstl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","svećnjak od čistog zlata sa njegovim svećama – poređanim lampama – sa svim njegovim priborom, i ulje za osvetljenje; ");
INSERT INTO srponstl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","žrtvenik od zlata, ulje pomazanja i začine za kađenje i zastor za ulaz u Šator; ");
INSERT INTO srponstl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","bronzani žrtvenik sa bronzanom oplatom, drškama i svim njegovim priborom; umivaonik sa svojim postoljem; ");
INSERT INTO srponstl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","zavese za dvorište, sa stubovima i podnožjima, i zastor za dvorišni ulaz, njegovu užad i kočiće i sav pribor za službu u Prebivalištu, za Šator od sastanka; ");
INSERT INTO srponstl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","izvezene odežde za službu u Svetinji – posvećene odežde za sveštenika Arona i odežde za svešteničku službu njegovih sinova. ");
INSERT INTO srponstl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Izrailjci su uradili sav posao onako kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mojsije je, zatim, pregledao sve radove, pa kad je video da su uradili kako je Gospod zapovedio, blagoslovio ih je. ");
INSERT INTO srponstl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Tada je Gospod rekao Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","„Prvoga dana prvog meseca podigni Prebivalište, Šator od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Postavi tamo Kovčeg svedočanstva i zakloni ga zavesom. ");
INSERT INTO srponstl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Onda donesi sto i postavi na njega ono što treba postaviti; donesi i svećnjak i u njega stavi sveće. ");
INSERT INTO srponstl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Postavi zlatni kadioni žrtvenik ispred Kovčega svedočanstva i postavi zastor na ulaz u Prebivalište. ");
INSERT INTO srponstl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ispred ulaza u Prebivalište, Šator od sastanka, postavi žrtvenik za žrtve svespalnice. ");
INSERT INTO srponstl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Umivaonik stavi između Šatora od sastanka i žrtvenika i nalij u njega vodu. ");
INSERT INTO srponstl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Dvorište postavi okolo, a na dvorišnu kapiju postavi zastor. ");
INSERT INTO srponstl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Potom uzmi ulje za pomazanje i pomaži Prebivalište i sve što je u njemu i posveti ga i sav njegov pribor, pa će biti svet. ");
INSERT INTO srponstl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Pomaži i žrtvenik za žrtve svespalnice i sav njegov pribor i posveti ga. Tako će žrtvenik postati presvet. ");
INSERT INTO srponstl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Pomaži i umivaonik i njegovo postolje i posveti ga. ");
INSERT INTO srponstl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Zatim dovedi Arona i njegove sinove na ulaz u Šator od sastanka, pa ih okupaj vodom. ");
INSERT INTO srponstl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Arona obuci u posvećenu odeždu, pa ga pomaži i posveti da mi služi kao sveštenik. ");
INSERT INTO srponstl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Zatim dovedi njegove sinove, pa ih obuci u košulje. ");
INSERT INTO srponstl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Pomaži ih, kao što su pomazao njihovog oca, da mi služe kao sveštenici. Njihovo pomazanje će ih uvesti u svešteničku službu u sva pokolenja.“ ");
INSERT INTO srponstl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mojsije učini sve kako mu je Gospod zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Prebivalište je bilo podignuto prvog dana prvog meseca druge godine. ");
INSERT INTO srponstl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mojsije je podigao Prebivalište. Postavio je podnožja, a na njih daske, zatim je postavio prečage i uspravio stubove. ");
INSERT INTO srponstl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Onda je rasprostro Šator nad Prebivalištem i na njega od gore stavio pokrivač Šatora, baš kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Potom je uzeo Svedočanstvo i stavio ga u Kovčeg, stavio drške na Kovčeg i odozgo poklopio Kovčeg. ");
INSERT INTO srponstl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Kovčeg je doneo u Prebivalište, pa je obesio pregradnu zavesu da zakriva Kovčeg svedočanstva, kao što je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Sto je postavio u Šator od sastanka na severnoj strani Prebivališta, izvan zavese. ");
INSERT INTO srponstl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Na njega je poređao hlebove pred Gospodom, kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Svećnjak je postavio u Šator od sastanka nasuprot stolu, na južnoj strani Prebivališta. ");
INSERT INTO srponstl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Potom je upalio sveće pred Gospodom, kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ispred zavese u Šatoru od sastanka postavio je zlatni žrtvenik. ");
INSERT INTO srponstl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Na njemu je upalio miomirisni kad, kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Na ulaz u Prebivalište je postavio zastor. ");
INSERT INTO srponstl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Žrtvenik za žrtve svespalnice je postavio kod ulaza Prebivališta Šatora od sastanka i na njemu prineo žrtvu svespalnicu i žrtvu od žita, kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Umivaonik je postavio između Šatora od sastanka i žrtvenika, i u njega nalio vode za pranje. ");
INSERT INTO srponstl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Iz njega su Mojsije, Aron i njegovi sinovi prali ruke i noge. ");
INSERT INTO srponstl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Prali su se kad su ulazili u Šator od sastanka i kad su pristupali žrtveniku, kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mojsije je zatim podigao dvorište oko Prebivališta i žrtvenika i postavio zastor na dvorišnu kapiju. Tako je Mojsije završio posao. ");
INSERT INTO srponstl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Tada je oblak prekrio Šator od sastanka i slava Gospodnja je ispunila Prebivalište. ");
INSERT INTO srponstl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mojsije nije mogao da uđe u Šator od sastanka, jer je na njemu počivao oblak, a slava Gospodnja ispunjavala Prebivalište. ");
INSERT INTO srponstl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tokom celog njihovog putovanja, kad god bi se oblak podizao sa Prebivališta, Izrailjci bi kretali na put. ");
INSERT INTO srponstl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ali, ako se oblak ne bi digao, ni oni ne bi kretali na put, sve do dana kada bi se podizao. ");
INSERT INTO srponstl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Jer, u toku celog njihovog putovanja, oblak Gospodnji je bio nad Prebivalištem danju, dok je noću u oblaku bio oganj, pred očima celog doma Izrailjevog.");
INSERT INTO srponstl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Gospod pozva Mojsija i reče mu iz Šatora od sastanka: ");
INSERT INTO srponstl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","„Govori sinovima Izrailjevim i reci im: ’Kad ko od vas prinosi žrtvu Gospodu, neka je prinese od stoke, krupne ili sitne. ");
INSERT INTO srponstl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ako prinosi žrtvu svespalnicu od krupne stoke, neka prinese muško bez mane. Neka ga dovede na ulaz od Šatora od sastanka, da bi ga Gospod prihvatio. ");
INSERT INTO srponstl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Zatim neka položi ruke na glavu žrtve svespalnice, da bi bila prihvaćena kao otkup za njegov greh, ");
INSERT INTO srponstl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","i neka zakolje junca pred Gospodom. Onda neka sinovi Aronovi, sveštenici, prinesu krv i njome zapljusnu sve strane žrtvenika, koji je kod ulaza u Šator od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Neka se zatim žrtva svespalnica odere i iseče na delove. ");
INSERT INTO srponstl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Potom neka sinovi Aronovi nalože vatru na žrtveniku, a na vatru naslažu drva. ");
INSERT INTO srponstl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Zatim neka sinovi Aronovi, sveštenici, poređaju delove, glavu i salo, na drva što su na ognju na žrtveniku. ");
INSERT INTO srponstl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Drob i noge neka se operu, a sveštenik neka sve to spali na žrtveniku. To je svespalnica, žrtva koja se pali na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Ako prinosi žrtvu od sitne stoke, neka prinese jagnje ili jare kao žrtvu svespalnicu. Neka prinese muško bez mane. ");
INSERT INTO srponstl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Neka ga zakolje pred Gospodom, sa severne strane žrtvenika. A sinovi Aronovi, sveštenici, neka njegovom krvlju zapljusnu žrtvenik sa svih strana. ");
INSERT INTO srponstl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Neka zatim iseku žrtvu na delove, s glavom i lojem, a sveštenik neka poređa delove na drva koja su na ognju na žrtveniku. ");
INSERT INTO srponstl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Drob i noge neka operu u vodi, a sveštenik neka sve to prinese i spali na žrtveniku. To je svespalnica, žrtva koja se pali na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Ako prinosi Gospodu žrtvu svespalnicu od ptica, neka prinese na žrtvu grlicu ili golubića. ");
INSERT INTO srponstl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Neka ga sveštenik donese na žrtvenik, i otkine mu glavu. Potom neka ga spali na žrtveniku, a krv neka iscedi niz žrtvenik sa strane. ");
INSERT INTO srponstl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Gušu s njenom sadržinom neka ukloni i baci ih istočno od žrtvenika, gde se odlaže pepeo. ");
INSERT INTO srponstl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Onda neka ga raspori duž krila, ali tako da ih ne raskine. Tada neka ga sveštenik spali na žrtveniku, na drvima što su na vatri. To je svespalnica, žrtva koja se pali na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Ako neko hoće da prinese žitnu žrtvu Gospodu, neka prinese brašno na žrtvu; neka ga prelije uljem i na njega stavi tamjan. ");
INSERT INTO srponstl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Onda neka ga donese sinovima Aronovim, sveštenicima. Potom neka sveštenik zagrabi punu šaku brašna, ulje i sav tamjan, pa neka ga spali na žrtveniku za spomen, kao žrtvu koja se pali na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Što ostane od dara, neka pripadne Aronu i njegovim sinovima, kao najsvetiji deo od žrtava koje se pale Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ako neko hoće da prinese žitnu žrtvu koja se peče u peći, neka to budu beskvasne pogače od brašna umešene s uljem, ili beskvasni kolači preliveni uljem. ");
INSERT INTO srponstl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ako je tvoja žrtva pečena na tiganju, neka bude od brašna bez kvasca umešena s uljem. ");
INSERT INTO srponstl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Izlomi je na komade i prelij je uljem. To je žitna žrtva. ");
INSERT INTO srponstl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ako je tvoja žrtva pržena na tiganju, neka bude pripremljena od brašna i ulja. ");
INSERT INTO srponstl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Žitnu žrtvu pripremljenu na jedan od ovih načina prinesi Gospodu. Zatim je donesi svešteniku, a on neka je odnese na žrtvenik. ");
INSERT INTO srponstl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Potom sveštenik neka uzme deo od žitne žrtve za spomen, pa neka ga spali na žrtveniku. To je žrtva koja se pali na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Što ostane od žitne žrtve, neka pripadne Aronu i njegovim sinovima, kao najsvetiji deo od svespalnica koje se prinose Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Nijedna žrtva koju prinosite Gospodu, ne sme da bude pripremljena s kvascem; ništa što je ukvasano ili s medom ne smete paliti kao žrtvu Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Žrtvu od prvih plodova prinosite Gospodu, ali neka se ne prinose na žrtveniku kao ugodan miris. ");
INSERT INTO srponstl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Svaku žitnu žrtvu posoli. Ne propuštaj da solju saveza Boga svoga posoliš svoju žitnu žrtvu; svaku svoju žrtvu prinosi sa solju. ");
INSERT INTO srponstl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ako prinosiš Gospodu žitnu žrtvu od prvih plodova, prinesi je u vidu mladog klasja prženog na vatri, ili izdrobljenog svežeg žita. ");
INSERT INTO srponstl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Izlij na nju ulja i stavi na nju tamjana. To je žitna žrtva. ");
INSERT INTO srponstl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Neka zatim sveštenik spali na žrtveniku nešto od izdrobljenog žita i ulja, sa svim tamjanom, kao žrtvu koja se pali Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ako neko prinosi žrtvu mira od krupne stoke, neka prinese Gospodu muško ili žensko bez mane. ");
INSERT INTO srponstl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Zatim neka položi ruku na glavu njegove žrtve, i neka je zakolje na ulazu u Šator od sastanka. Tada neka sinovi Aronovi, sveštenici, zapljusnu krvlju sve strane žrtvenika. ");
INSERT INTO srponstl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Od žrtve mira, kao paljenu žrtvu Gospodu, neka prinese salo koje pokriva creva, i sve salo oko iznutrica. ");
INSERT INTO srponstl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","A bubrege i salo što je oko njih i na slabinama, te mrežicu što je na jetri, neka ukloni zajedno s bubrezima. ");
INSERT INTO srponstl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Onda neka sinovi Aronovi spale to na žrtveniku zajedno sa žrtvom svespalnicom, koja je na drvima što su na vatri. To je žrtva koja se pali na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ako neko prinosi žrtvu od sitne stoke, kao žrtvu mira Gospodu, neka prinese muško ili žensko bez mane. ");
INSERT INTO srponstl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ako na žrtvu prinosi ovcu, neka je donese pred Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Neka položi ruku na glavu žrtve, pa neka je zakolje ispred Šatora od sastanka. Onda neka sinovi Aronovi njenom krvlju zapljusnu žrtvenik sa svih strana. ");
INSERT INTO srponstl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Od žrtve mira, kao svespalnicu Gospodu, neka prinese: salo, ceo rep – neka ga otkine kod kičme – loj koji pokriva creva i svo salo oko iznutrica. ");
INSERT INTO srponstl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","A bubrege i salo što je oko njih i na slabinama, te mrežicu što je na jetri, neka ukloni zajedno s bubrezima. ");
INSERT INTO srponstl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Zatim neka sveštenik spali to na žrtveniku; to je hrana koja se pali na žrtvu Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ako prinosi kozu, neka je donese pred Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Neka položi ruku na njenu glavu, pa neka je zakolje ispred Šatora od sastanka. Onda neka sinovi Aronovi njenom krvlju zapljusnu žrtvenik sa svih strana. ");
INSERT INTO srponstl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Od žrtve, kao svespalnicu Gospodu, neka prinese: salo koje pokriva creva, i sve salo oko iznutrica. ");
INSERT INTO srponstl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","A bubrege i salo što je oko njih i na slabinama, te mrežicu što je na jetri, neka ukloni zajedno s bubrezima. ");
INSERT INTO srponstl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Neka sveštenik spali to na žrtveniku, kao svespalnicu na ugodan miris Gospodu. Sve salo pripada Gospodu! ");
INSERT INTO srponstl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ovo je večna uredba za vaša pokolenja, u svim vašim naseljima: ne jedite loja ni krvi!’“ ");
INSERT INTO srponstl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","„Govori Izrailjcima i reci im: ’Kada se neko nehotice ogreši o jednu od zapovesti Gospodnjih čineći što je zabranjeno: ");
INSERT INTO srponstl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Ako zgreši pomazani sveštenik, i time učini da greh padne na narod, neka za greh koji je počinio prinese iz krda junca bez mane Gospodu na žrtvu za greh. ");
INSERT INTO srponstl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Neka dovede junca pred Gospoda, kod ulaza u Šator od sastanka; neka položi ruku na junčevu glavu, te zakolje junca pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Onda pomazani sveštenik neka uzme nešto junčeve krvi i donese je u Šator od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Zatim neka sveštenik umoči prst u krv i delom krvi poškropi sedam puta pred Gospodom ispred zavese Svetinje. ");
INSERT INTO srponstl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Potom sveštenik neka namaže nešto krvi na rogove žrtvenika za paljenje kada pred Gospodom, koji se nalazi u Šatoru od sastanka. Svu ostalu krv neka izlije na podnožje žrtvenika za žrtve svespalnice, koji je kod ulaza u Šator od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Onda neka izvadi sve salo iz junca, žrtve za greh, salo koje pokriva creva i sve salo koje je oko iznutrica. ");
INSERT INTO srponstl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","A bubrege i salo što je oko njih i na slabinama, te mrežicu što je na jetri, neka ukloni zajedno s bubrezima, ");
INSERT INTO srponstl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","kao što se uklanja iz vola, žrtve mira. Neka ih zatim sveštenik spali na žrtveniku za žrtve svespalnice. ");
INSERT INTO srponstl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","A junčevu kožu sa svim njegovim telom, glavom i nogama, utrobom i balegom – ");
INSERT INTO srponstl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","sve što ostane od junca – neka odnese izvan tabora na čisto mesto, gde se prosipa pepeo, i neka ga spali na drvima; gde se prosipa pepeo, tamo neka bude spaljen. ");
INSERT INTO srponstl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ako sav zbor Izrailjev nehotice zgreši, a zboru ostane nepoznato u čemu je stvar, to jest, ako prekrše koju od Gospodnjih zapovesti čineći što je zabranjeno, i tako postanu krivi, ");
INSERT INTO srponstl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","onda, kad se dozna za greh koji su učinili, neka zbor prinese iz krda jednog junca na žrtvu za greh. Neka ga dovedu pred Šator od sastanka, ");
INSERT INTO srponstl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","a starešine zajednice, neka tu, pred Gospodom, polože ruke na junčevu glavu, pa neka zakolju junca pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Zatim neka pomazani sveštenik donese nešto junčeve krvi u Šator od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Onda neka sveštenik umoči prst u krv i neka poškropi sedam puta pred Gospodom ispred zavese. ");
INSERT INTO srponstl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Sa nešto krvi neka pomaže rogove žrtvenika koji stoji pred Gospodom u Šatoru od sastanka. Svu ostalu krv neka izlije na podnožje žrtvenika za žrtve svespalnice, koji je kod ulaza u Šator od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","A sve salo neka izvadi iz junca i neka ga spali na žrtveniku. ");
INSERT INTO srponstl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Sa juncem neka postupi onako kako je postupio s juncem žrtvom za greh. Kad sveštenik izvrši obred otkupljenja nad njima, biće im oprošteno. ");
INSERT INTO srponstl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Zatim neka iznese preostalog junca izvan tabora, i neka ga spali kao što je spalio prvog junca. To je žrtva za greh za zbor. ");
INSERT INTO srponstl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ako knez nehotice zgreši i prekrši jednu od zapovesti Gospoda, Boga svoga, čineći što je zabranjeno, i tako postane kriv, ");
INSERT INTO srponstl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ili mu ukažu na greh koji je učinio – neka prinese na žrtvu muško jare bez mane. ");
INSERT INTO srponstl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Neka položi ruku na glavu jareta i neka ga zakolje na mestu gde se kolju žrtve svespalnice pred Gospodom. To je žrtva za greh. ");
INSERT INTO srponstl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Zatim neka sveštenik uzme na prst nešto krvi od žrtve za greh i neka je stavi na rogove žrtvenika za žrtve svespalnice. Svu ostalu krv neka izlije na podnožje žrtvenika za žrtve svespalnice. ");
INSERT INTO srponstl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","A sve salo neka spali na žrtveniku, kao što se pali salo žrtve mira. Kad sveštenik izvrši nad njim obred otkupljenja, biće mu oprošteno. ");
INSERT INTO srponstl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ako neko iz naroda u zemlji nehotice zgreši i prekrši jednu od Gospodnjih zapovesti čineći što je zabranjeno i tako postane kriv, ");
INSERT INTO srponstl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ili mu ukažu na greh koji je počinio – neka za greh koji je počinio prinese na žrtvu žensko jare bez mane. ");
INSERT INTO srponstl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Zatim neka položi ruku na glavu žrtve za greh, i neka je zakolje na mestu za žrtve svespalnice. ");
INSERT INTO srponstl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Onda sveštenik neka uzme nešto od njene krvi na prst, pa neka stavi na rogove žrtvenika za žrtve svespalnice. Svu ostalu krv neka izlije na podnožje žrtvenika. ");
INSERT INTO srponstl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","A sve njeno salo neka izvadi, kao što se vadi salo iz žrtve mira, a sveštenik neka ga spali na žrtveniku na ugodan miris Gospodu. Kad sveštenik izvrši nad njim obred otkupljenja, biće mu oprošteno. ");
INSERT INTO srponstl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Ako dovodi jagnje kao žrtvu za greh, neka dovede žensko jagnje bez mane. ");
INSERT INTO srponstl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Zatim neka položi ruku na glavu žrtve za greh i neka je zakolje na mestu za žrtve svespalnice. ");
INSERT INTO srponstl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Tada sveštenik neka uzme nešto od njene krvi na prst i neka je stavi na rogove žrtvenika za žrtve svespalnice. Svu ostalu krv neka izlije na podnožje žrtvenika. ");
INSERT INTO srponstl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","A sve njeno salo neka izvadi, kao što se vadi salo iz žrtve mira, a sveštenik neka ga spali na žrtveniku povrh žrtava koje se pale Gospodu. Kad sveštenik izvrši nad njim obred otkupljenja za greh koji je učinio, biće mu oprošteno. ");
INSERT INTO srponstl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Ako neko sagreši tako što se ne odazove na sudski poziv kako bi dao izjavu pod zakletvom, iako je bio svedokom događaja, odnosno, ako je to video, ili je za to znao, snosiće krivicu. ");
INSERT INTO srponstl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ili ako neko dotakne nešto nečisto: strvinu nečiste zverke, ili strvinu nečiste stoke, ili strvinu nečistog gmizavca, ili bilo koju nečistu strvinu, pa se neznajući oskrnavi, ipak će biti kriv. ");
INSERT INTO srponstl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ili kad neko dotakne ljudsku nečistoću – čime god nečistim da se oskrnavi – a to mu ostane nepoznato, ali kasnije sazna, skrivio je. ");
INSERT INTO srponstl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ili ako se neko nepromišljeno zakune da će uraditi bilo zlo ili dobro – šta god da čovek nepromišljeno izgovori u zakletvi – a to mu ostane nepoznato, kad sazna kasnije za svoju krivicu u jednom od ovih slučajeva, ");
INSERT INTO srponstl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","te shvati da je skrivio u jednom od njih, neka prizna ono u čemu je zgrešio. ");
INSERT INTO srponstl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","A kao žrtvu za prestup koji je počinio, neka prinese Gospodu žensko grlo od sitne stoke, ovcu ili kozu, na žrtvu za greh. A sveštenik neka izvrši nad njim obred otkupljenja. ");
INSERT INTO srponstl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ako nije u stanju da priušti jagnje ili jare, neka Gospodu, kao žrtvu za prestup koji je počinio, prinese dve grlice, ili dva golubića, jednog na žrtvu za greh, a drugog na žrtvu svespalnicu. ");
INSERT INTO srponstl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Neka ih donese svešteniku, a ovaj neka prvo prinese ono što je određeno kao žrtva za greh. Zatim neka mu zavrne vrat tako da ga odvoji od glave, ali glavu neka mu ne otkine sasvim. ");
INSERT INTO srponstl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Onda neka krvlju žrtve za greh poškropi žrtvenik, a ostalu krv neka izlije na podnožje žrtvenika. To je žrtva za greh. ");
INSERT INTO srponstl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Drugog neka prinese na žrtvu svespalnicu, po propisu. Sveštenik neka izvrši obred otkupljenja nad njim za greh koji je počinio, i biće mu oprošteno. ");
INSERT INTO srponstl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ako nije u stanju da priušti dve grlice ili dva golubića, neka Gospodu, kao naknadu za počinjeni greh, prinese jednu desetinu efe brašna. Neka u njega ne dodaje ulja, niti stavlja tamjana na njega, jer je to žrtva za greh. ");
INSERT INTO srponstl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Brašno neka donese svešteniku, a sveštenik neka zagrabi od njega punu šaku za spomen, i neka to spali na žrtveniku kao paljenu žrtvu Gospodu. To je žrtva za greh. ");
INSERT INTO srponstl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Neka sveštenik izvrši nad njim obred otkupljenja za greh koji je počinio u bilo kojem od ovih slučajeva, i biće mu oprošteno. Ostalo neka pripadne svešteniku kao žitna žrtva.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","„Ako neko učini verolomstvo, tako što se nehotice ogreši o neku od svetih stvari Gospodnjih, neka Gospodu, kao naknadu, dovede iz stada jednog ovna bez mane, čiju ćeš vrednost u srebrnim šekelima određivati prema hramskom šekelu. To je žrtva za prestup. ");
INSERT INTO srponstl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kao žrtvu za prestup kojim se ogrešio o svetu stvar, neka nadoda petinu vrednosti i to neka preda svešteniku. Sveštenik neka izvrši nad njim obred otkupljenja ovnom, žrtvom za prestup, i biće mu oprošteno. ");
INSERT INTO srponstl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Ako neko zgreši tako što prekrši jednu od zapovesti Gospodnjih, te učini ono što je zabranjeno, a to mu ostane nepoznato, ipak će snositi odgovornost za svoju kaznu. ");
INSERT INTO srponstl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Taj neka svešteniku dovede iz stada ovna bez mane odgovarajuće vrednosti kao žrtvu za prestup. Sveštenik neka izvrši nad njim obred otkupljenja za greh koji je nehotice učinio, i biće mu oprošteno. ");
INSERT INTO srponstl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","To je žrtva za prestup; skrivio je protiv Gospoda.“ ");
INSERT INTO srponstl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Gospod još reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","„Čovek koji učini greh neverstva protiv Gospoda, tako što prevari svoga bližnjega u onome što mu je bilo dano na čuvanje ili u zalog; ili opljačka ili iskoristi svoga bližnjega; ");
INSERT INTO srponstl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ili nađe izgubljenu stvar i slaže; ili se lažno zakune za jednu od ovih stvari koju neko može da učini, te se ogreši jednom od njih; ");
INSERT INTO srponstl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ako, dakle, ovako zgreši i shvati svoju krivicu i vrati što je opljačkao, ili stekao iskorištavanjem, ili što mu je bilo dano na čuvanje, ili što je našao kao izgubljeno, ");
INSERT INTO srponstl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ili bilo šta za šta se lažno zakleo, neka to u celosti isplati vlasniku i nadoda petinu na dan kad prinese žrtvu za svoj greh. ");
INSERT INTO srponstl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Za žrtvu za prestup Gospodu neka donese svešteniku iz stada ovna bez mane prema vrednosti koju ti odrediš. ");
INSERT INTO srponstl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Kad sveštenik izvrši nad njim obred otkupljenja pred Gospodom, biće mu oprošteno ono čime je navukao na sebe greh, šta god to bilo.“ ");
INSERT INTO srponstl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","„Zapovedi Aronu i sinovima Izrailjevim i reci im: ’Ovo je zakon za žrtvu svespalnicu: svespalnica neka ostane na žrtveniku, na mestu spaljivanja, celu noć sve do jutra. Vatra na žrtveniku mora stalno da gori. ");
INSERT INTO srponstl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Sveštenik neka obuče svoju lanenu odeću i duge lanene gaće, a onda neka skupi pepeo nakon što oganj sagori svespalnicu na žrtveniku, i istrese ga pored žrtvenika. ");
INSERT INTO srponstl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Zatim neka skine sa sebe odeću i obuče drugu odeću, te neka odnese pepeo izvan tabora na čisto mesto. ");
INSERT INTO srponstl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Oganj na žrtveniku neka stalno gori; ne sme se gasiti. Neka sveštenik svako jutro naloži drva na oganj, neka na njega složi žrtvu svespalnicu i neka spali salo od žrtava mira. ");
INSERT INTO srponstl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Oganj na žrtveniku mora stalno da gori; ne sme se gasiti. ");
INSERT INTO srponstl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ovo je zakon za žitnu žrtvu: Aronovi sinovi neka je prinose pred Gospodom ispred žrtvenika. ");
INSERT INTO srponstl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Jedan od njih neka zagrabi šaku brašna i ulja od žitne žrtve i sav tamjan koji je na žitnoj žrtvi, pa neka to spali na žrtveniku kao spomen na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Što preostane od žrtve neka pojedu Aron i njegovi sinovi; hlebovi neka se jedu bez kvasca na posvećenom mestu; neka ih jedu u dvorištu Šatora od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ne smeju se peći sa kvascem. Deo od paljenih žrtava koje se meni prinose njima sam dao. To je najsvetiji deo, kao što je žrtva za greh i žrtva za prestup. ");
INSERT INTO srponstl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Svaki muškarac od potomaka Aronovih može jesti taj deo od žrtava koje se pale Gospodu. To je večna uredba za sve vaše naraštaje. Ko god ih se dotakne, postaće svet.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Gospod je govorio Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","„Ovo je prinos koji će Aron i njegovi sinovi prinositi Gospodu na dan pomazanja: desetinu efe brašna kao redovnu žitnu žrtvu, polovinu ujutro, a polovinu uveče. ");
INSERT INTO srponstl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Neka se priprema na tiganju sa uljem; neka bude dobro umešena. Žitnu žrtvu donesi izlomljenu na komade, pa je prinesi na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Neka je prinese jedan od Aronovih sinova, koji se pomazuje kao njegov naslednik. To je večna uredba. Žrtva neka se Gospodu potpuno spali. ");
INSERT INTO srponstl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Svaka žitna žrtva koju prinosi sveštenik neka se potpuno spali; ne sme se jesti.“ ");
INSERT INTO srponstl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","„Reci Aronu i njegovim sinovima: ’Ovo je zakon za žrtvu za greh: žrtva za greh neka se zakolje pred Gospodom na mestu gde se kolje žrtva svespalnica – presveta je. ");
INSERT INTO srponstl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Sveštenik koji prinosi žrtvu za greh može od nje jesti na svetom mestu, u dvorištu Šatora od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Što se god dotakne mesa postaće sveto, a ako krv poprska odeću, operi je na svetom mestu. ");
INSERT INTO srponstl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Zemljani lonac u kome se meso kuva mora se nakon toga razbiti, a ako je kuvano u bronzanom loncu, lonac neka se izriba i ispere vodom. ");
INSERT INTO srponstl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Svako muško među sveštenicima sme je jesti – presveta je. ");
INSERT INTO srponstl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Svaka žrtva za greh čija se krv donosi u Šator od sastanka da se izvrši obred otkupljenja na svetom mestu, neka se ne jede, nego neka se spali vatrom. ");
INSERT INTO srponstl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ovo je zakon o žrtvi za prestup. Ona je presveta. ");
INSERT INTO srponstl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Neka se žrtva za prestup kolje na mestu gde se kolju žrtve svespalnice, a njenom krvlju neka se zapljusne žrtvenik sa svih strana. ");
INSERT INTO srponstl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Neka se prinese sve njeno salo, rep i salo koje pokriva iznutrice, ");
INSERT INTO srponstl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","oba bubrega i salo što je oko njih i na slabinama; i mrežica što je na jetri neka se ukloni zajedno s bubrezima. ");
INSERT INTO srponstl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Neka to sveštenik spali na žrtveniku kao paljenu žrtvu Gospodu. To je žrtva za prestup. ");
INSERT INTO srponstl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Svako muško među sveštenicima sme je jesti. Neka se jede na svetom mestu. Ona je presveta. ");
INSERT INTO srponstl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Zakon o žrtvi za prestup isti je kao zakon o žrtvi za greh. Isti je zakon za obe: ona pripada svešteniku koji njome vrši obred otkupljenja. ");
INSERT INTO srponstl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Svešteniku koji prinosi nečiju žrtvu svespalnicu, neka pripadne koža od žrtve koju je prineo. ");
INSERT INTO srponstl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Svaka žitna žrtva koja se peče u peći, i svaka koja se pripravlja u kotliću ili na tiganju neka pripadne svešteniku koji je prinosi; njegova je. ");
INSERT INTO srponstl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Svaka žitna žrtva koja se mesi sa uljem ili nasuvo, neka pripadne svim sinovima Aronovim podjednako. ");
INSERT INTO srponstl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Ovo je zakon za žrtvu mira koja se prinosi Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ako je ko prinosi u znak zahvalnosti, neka uz žrtvu zahvalnicu prinese i beskvasne pogače umešene sa uljem, ili beskvasne kolače namazane uljem. ");
INSERT INTO srponstl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Uz pogače neka prinese i hleb od dizanog testa sa žrtvom mira, kao svoju zahvalnost. ");
INSERT INTO srponstl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Od svega što prinosi neka prinese po jedan kolač na dar Gospodu. To neka pripadne svešteniku koji škropi krv od žrtve mira. ");
INSERT INTO srponstl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","A meso od žrtve mira kojom zahvaljuje, neka se pojede na dan kada se prinese; ništa ne sme ostati do jutra. ");
INSERT INTO srponstl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ako neko prinosi žrtvu zavetnicu, ili dobrovoljnu žrtvu, meso neka se pojede na dan kad prinosi svoju žrtvu. Što od toga ostane, neka se pojede sutradan. ");
INSERT INTO srponstl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ako nešto mesa od žrtve ostane do trećega dana, neka se spali. ");
INSERT INTO srponstl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ako neko jede meso od žrtve mira i trećega dana, taj koji je prinosi neće biti ugodan Bogu; žrtva mu se neće računati, jer je meso postalo nečisto. Onaj koji jede od njega navući će na sebe krivicu. ");
INSERT INTO srponstl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Meso koje se dotakne čega nečistog neka se ne jede; neka se spali. Ko god je čist sme jesti meso. ");
INSERT INTO srponstl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ako bi neko jeo mesa od žrtve mira koja pripada Gospodu, a pritom bude nečist, taj neka se istrebi iz svog naroda. ");
INSERT INTO srponstl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ako se neko dotakne čega god nečistog: čovečije nečistoće, ili nečiste životinje, ili kakve god nečiste i gadne životinje, a zatim jede od mesa žrtve mira koja pripada Gospodu, takav neka se istrebi iz svoga naroda.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","„Reci narodu izrailjskom: ’Ne jedite nikakvog sala od volova, ovaca i koza! ");
INSERT INTO srponstl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Salo od uginule ili rastrgane životinje može se koristiti za bilo šta, ali ga ne smete jesti. ");
INSERT INTO srponstl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ko god bi jeo salo od životinje koja se prinosi na paljenu žrtvu Gospodu, neka se istrebi iz svoga naroda. ");
INSERT INTO srponstl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ni u jednom od svojih naselja ne smete jesti nikakve krvi, ni od ptica ni od stoke. ");
INSERT INTO srponstl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ako neko jede bilo kakvu krv, neka se istrebi iz svoga naroda.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","„Reci narodu izrailjskom: ’Onaj ko prinosi Gospodu žrtvu mira, neka donese Gospodu deo od žrtve mira. ");
INSERT INTO srponstl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Svojim rukama neka donese paljenu žrtvu Gospodu: salo s grudima. Grudi neka se podignu pred Gospodom kao žrtva dizanica, ");
INSERT INTO srponstl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","a sveštenik neka spali salo na žrtveniku. Grudi neka pripadnu Aronu i njegovim sinovima. ");
INSERT INTO srponstl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Desnu plećku od žrtve mira daj svešteniku kao dar. ");
INSERT INTO srponstl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Onome između Aronovih sinova koji prinosi krv i salo žrtve mira, neka pripadne desna plećka. ");
INSERT INTO srponstl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ja sam, naime, uskratio narodu izrailjskom grudi žrtve mira i plećku žrtvenoga dara, i dao ih Aronu, svešteniku, i njegovim sinovima. To im sleduje od naroda izrailjskog po večnoj uredbi.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","To je deo određen za Arona i njegove sinove od žrtava koje se pale Gospodu, na dan kada se uvode u službu kao sveštenici Gospodnji. ");
INSERT INTO srponstl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ovo je Gospod zapovedio Izrailjcima da im daju na dan njihovog pomazanja po večnoj uredbi za sve njihove naraštaje. ");
INSERT INTO srponstl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","To je zakon za žrtvu svespalnicu, za žitnu žrtvu, za žrtvu za greh, za žrtvu za prestup, za žrtvu posvećenja, i za žrtvu mira, ");
INSERT INTO srponstl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","koji je Gospod dao Mojsiju na gori Sinaju, na dan kad je zapovedio narodu izrailjskom da prinosi svoje žrtve Gospodu u Sinajskoj pustinji. ");
INSERT INTO srponstl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","„Uzmi Arona i njegove sinove; odeću, ulje posvećenja, junca žrtve za greh, dva ovna, košaru beskvasnih hlebova, ");
INSERT INTO srponstl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","i saberi celu zajednicu kod ulaza Šatora od sastanka.“ ");
INSERT INTO srponstl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mojsije učini kako mu je Gospod zapovedio. Kada se zajednica sabrala kod ulaza od Šatora od sastanka, ");
INSERT INTO srponstl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mojsije reče zajednici: „Ovo je Gospod zapovedio da se uradi!“ ");
INSERT INTO srponstl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Mojsije je doveo Arona i njegove sinove, pa ih je oprao u vodi. ");
INSERT INTO srponstl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Obukao ga je u odeždu i opasao ga opasačem. Zatim ga je obukao u košulju, i stavio na njega oplećak. Onda ga je opasao izvezenim pojasom i njime ga pričvrstio uz oplećak. ");
INSERT INTO srponstl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Stavio je na njega naprsnik, a u naprsnik je stavio Urim i Tumim. ");
INSERT INTO srponstl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Na glavu mu je stavio turban, a na čelo turbana metnuo je zlatnu pločicu, posvetni natpis, kao što je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Mojsije uze ulje za pomazanje i pomaza Prebivalište i sve stvari u njemu, i tako ga posveti. ");
INSERT INTO srponstl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Od tog ulja je poškropio žrtvenik sedam puta. Zatim je pomazao žrtvenik, sve njegovo posuđe, i umivaonik sa postoljem, da ih posveti. ");
INSERT INTO srponstl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Nešto od tog ulja je izlio na Aronovu glavu i pomazao ga, da ga posveti. ");
INSERT INTO srponstl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Mojsije je pristupio Aronovim sinovima i obukao ih u košulje, opasao ih pojasevima, i obmotao im turban oko glave, kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Potom je priveo junca, žrtvu za greh. Aron i njegovi sinovi su položili ruke na glavu junca, žrtve za greh, ");
INSERT INTO srponstl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","a Mojsije ga je zaklao. Onda je uzeo nešto krvi i svojim prstom je namazao na rogove žrtvenika i tako ga očistio. Ostalu krv je izlio podno žrtvenika. Tako ga je posvetio da se vrši obred otkupljenja na njemu. ");
INSERT INTO srponstl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mojsije je, zatim, uzeo sve salo što je oko creva, mrežicu na jetri, oba bubrega s lojem, i spalio ih na žrtveniku. ");
INSERT INTO srponstl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","A junca s njegovom kožom, mesom i balegom, spalio je izvan tabora, onako kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Potom je Mojsije doveo ovna za žrtvu svespalnicu, a Aron i njegovi sinovi su položili ruke ovnu na glavu. ");
INSERT INTO srponstl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Tada ga je Mojsije zaklao i krvlju zapljusnuo žrtvenik sa svih strana. ");
INSERT INTO srponstl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Nakon toga je isekao ovna na komade, pa je spalio glavu, delove i salo. ");
INSERT INTO srponstl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Utrobu i noge je oprao u vodi, pa je celog ovna spalio na žrtveniku. To je bila žrtva svespalnica na ugodni miris, paljena žrtva koja se prinosi Gospodu – onako kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Zatim je doveo drugog ovna, ovna za posvećenje. Aron i njegovi sinovi polože ruke na njegovu glavu, ");
INSERT INTO srponstl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","a Mojsije ga zakolje. Zatim je Mojsije uzeo nešto ovnove krvi, pa je njome namazao resu Aronovog desnog uha, palac njegove desne ruke, i palac njegove desne noge. ");
INSERT INTO srponstl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Onda je Mojsije doveo Aronove sinove. Mojsije im je namazao nešto od krvi na resu desnog uha, na palac desne ruke i na palac desne noge. Ostalom krvlju Mojsije je zapljusnuo žrtvenik sa svih strana. ");
INSERT INTO srponstl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Nakon toga je uzeo salo, rep, sve salo oko iznutrica, mrežicu s jetre, oba bubrega s njihovim salom, i desnu plećku. ");
INSERT INTO srponstl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Iz košare s hlebovima, koje su stajale pred Gospodom, uzeo je jednu beskvasnu lepinju, jedan hleb s uljem, i jedan kolač, i stavio ih na salo i na desnu plećku. ");
INSERT INTO srponstl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Mojsije je sve to stavio na ruke Aronu i na ruke njegovih sinova, i podigao ih kao žrtvu dizanicu pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mojsije je, zatim, uzeo to iz njihovih ruku i spalio na žrtveniku sa žrtvom svespalnicom. To je bila žrtva za posvećenje na ugodni miris, paljena žrtva Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Potom je Mojsije uzeo grudi i podigao ih kao žrtvu dizanicu pred Gospodom. To je bio Mojsijev deo od ovna, žrtve za posvećenje – kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Onda je Mojsije uzeo od ulja pomazanja i od krvi, koji su bili na žrtveniku, pa je poškropio Arona i njegovu odeždu, i njegove sinove i njihove odežde, pa je posvetio Arona i njegovu odeždu, i njegove sinove i njihove odežde. ");
INSERT INTO srponstl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Tada Mojsije reče Aronu i njegovim sinovima: „Skuvajte to meso na ulazu u Šator od sastanka i tamo ga jedite s hlebom iz košare s posvetnim hlebom, kao što sam zapovedio: ’Neka ga jedu Aron i njegovi sinovi.’ ");
INSERT INTO srponstl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Što ostane od mesa i hleba, neka se spali. ");
INSERT INTO srponstl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ne napuštajte ulaz Šatora od sastanka sedam dana, dok se ne navrše dani vašeg posvećenja. Naime, sedam dana će trajati vaše posvećenje. ");
INSERT INTO srponstl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Kako se danas činilo, tako je Gospod zapovedio da se i nadalje vrši obred otkupljenja za vas. ");
INSERT INTO srponstl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Na ulazu Šatora od sastanka ostanite sedam dana, danju i noću, držeći što je Gospod zapovedio, da ne izginete. Tako mi je bilo zapoveđeno.“ ");
INSERT INTO srponstl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aron i njegovi sinovi su izvršili sve reči koje im je Gospod zapovedio preko Mojsija. ");
INSERT INTO srponstl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Osmoga dana je Mojsije pozvao Arona, njegove sinove, i izrailjske starešine. ");
INSERT INTO srponstl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Rekao je Aronu: „Uzmi tele iz krda za žrtvu za greh, i ovna bez mane za žrtvu svespalnicu, pa ih dovedi pred Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","A Izrailjcima reci: ’Uzmite jarca za žrtvu za greh, i tele i jagnje, oboje od godinu dana, bez mane, za žrtvu svespalnicu, ");
INSERT INTO srponstl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","i vola i ovna za žrtvu mira da se žrtvuju pred Gospodom, i žitnu žrtvu umešenu sa uljem, jer će vam se danas Gospod ukazati.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Oni donesoše što im je Mojsije zapovedio ispred Šatora od sastanka. Tada je cela zajednica pristupila i stala pred Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mojsije reče: „Ovo su reči koje vam je Gospod zapovedio da činite, da bi vam se pokazala slava Gospodnja.“ ");
INSERT INTO srponstl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Tada Mojsije reče Aronu: „Pristupi žrtveniku i prinesi žrtvu za greh za sebe i žrtvu svespalnicu, pa učini obred otkupljenja za sebe i za narod. Onda prinesi žrtvu naroda i izvrši obred otkupljenja za njih, kao što je Gospod zapovedio.“ ");
INSERT INTO srponstl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aron pristupi žrtveniku i zakla za sebe tele – žrtvu za greh. ");
INSERT INTO srponstl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Zatim su mu njegovi sinovi doneli krv; on je umočio prst u krv i njome namazao rogove žrtvenika. Ostalu krv je izlio na podnožje žrtvenika. ");
INSERT INTO srponstl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Salo, bubrege, i mrežicu što je na jetri od žrtve za greh, spalio je na žrtveniku, kao što je Gospod rekao Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","A meso i kožu spalio je izvan tabora. ");
INSERT INTO srponstl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Zatim je zaklao žrtvu svespalnicu. Njegovi sinovi su mu dodali krv, a on je njome zapljusnuo žrtvenik sa svih strana. ");
INSERT INTO srponstl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Onda su mu dodali žrtvu svespalnicu, deo po deo, i glavu, a on je to spalio na žrtveniku. ");
INSERT INTO srponstl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Creva i noge je oprao, pa ih je spalio na žrtveniku sa žrtvom svespalnicom. ");
INSERT INTO srponstl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Zatim je doveo žrtvu za narod: uzeo je jarca, žrtvu za greh za narod, zaklao ga, i prineo ga kao žrtvu za greh, kao i prethodno. ");
INSERT INTO srponstl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Posle toga je doveo žrtvu svespalnicu i prineo je po propisu. ");
INSERT INTO srponstl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Potom je doneo žitnu žrtvu, pa je uzeo punu šaku od nje i spalio to na žrtveniku uz jutarnju žrtvu svespalnicu. ");
INSERT INTO srponstl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Potom je zaklao vola i ovna – žrtvu mira za narod. Aronovi sinovi su mu dodali od te krvi, kojom je zapljusnuo sve strane žrtvenika. ");
INSERT INTO srponstl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Salo od vola i ovna: rep, salo što pokriva creva, bubrege, mrežicu što je na jetri; ");
INSERT INTO srponstl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","te delove sala su položili na grudi, a Aron je spalio salo na žrtveniku. ");
INSERT INTO srponstl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Grudi i desnu plećku Aron je podigao kao žrtvu dizanicu pred Gospodom, kao što je Mojsije zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Zatim je Aron podigao ruke prema narodu i blagoslovio ga. Pošto je prineo žrtvu za greh, žrtvu svespalnicu i žrtvu mira, siđe. ");
INSERT INTO srponstl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Tada Mojsije i Aron dođu u Šator od sastanka. Kad su izašli blagoslovili su narod, a slava se Gospodnja pokazala celom narodu. ");
INSERT INTO srponstl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Tada siđe oganj od Gospoda i proguta žrtvu svespalnicu i delove sala na žrtveniku. Kad je sav narod to video, povikao je i pao ničice. ");
INSERT INTO srponstl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aronovi sinovi, Nadav i Avijud, svaki uzme svoju kadionicu, u njih stave vatru a na nju kad, pa su prineli pred Gospodom tuđi oganj, suprotno onome što im je zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Tada siđe oganj od Gospoda i proguta ih, te poginu pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Tada Mojsije reče Aronu: „To je ono što je Gospod rekao: ’Pokazaću svoju svetost preko onih koji su mi blizu, i proslaviću se pred svim narodom.’“ Aron je ćutao. ");
INSERT INTO srponstl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mojsije je pozvao Misaila i Elisafana, sinove Ozila, strica Aronovog, pa im je rekao: „Pristupite i iznesite svoju braću ispred Svetinje na mesto izvan tabora.“ ");
INSERT INTO srponstl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Oni pristupe i iznesu ih u njihovim odorama izvan tabora, kao što je Mojsije rekao. ");
INSERT INTO srponstl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Potom Mojsije reče Aronu i njegovim sinovima, Eleazaru i Itamaru: „Ne raščupavajte svoju kosu, i ne razdirite svoju odeću, da ne poginete i da on ne plane gnevom na svu zajednicu. A vaša braća, sav dom Izrailjev, mogu da oplakuju one koje je Gospod spalio. ");
INSERT INTO srponstl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ne napuštajte ulaz Šatora od sastanka da ne poginete, jer je ulje pomazanja Gospodnjeg na vama.“ Oni su učinili kako je Mojsije rekao. ");
INSERT INTO srponstl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Gospod reče Aronu: ");
INSERT INTO srponstl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","„Nemoj piti vina i žestoka pića, ni ti ni tvoji sinovi, kada ulazite u Šator od sastanka, da ne poginete. To je večna uredba za vaše naraštaje, ");
INSERT INTO srponstl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","da biste mogli praviti razliku između svetog i nesvetog, i između nečistog i čistog, ");
INSERT INTO srponstl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","i da biste učili Izrailjce svim uredbama koje im je Gospod rekao preko Mojsija.“ ");
INSERT INTO srponstl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mojsije reče Aronu i njegovim preostalim sinovima, Eleazaru i Itamaru: „Uzmite žitnu žrtvu što je ostala od paljene žrtve Gospodnje, i jedite je beskvasnu pored žrtvenika, jer je presveta. ");
INSERT INTO srponstl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Jedite je na svetom mestu; to je deo od paljene žrtve Gospodnje, koji sleduje tebi i tvojim sinovima, jer mi je tako zapoveđeno. ");
INSERT INTO srponstl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","A grudi žrtve dizanice i plećku žrtvenog dara jedite na čistom mestu, ti, tvoji sinovi i tvoje ćerke; to je deo od žrtava mira izrailjskog naroda, koji sleduje tebi i tvojim sinovima. ");
INSERT INTO srponstl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Plećka žrtvenog dara i grudi žrtve dizanice, zajedno sa delovima sala paljene žrtve, neka se donesu radi prinošenja žrtve dizanice pred Gospodom. To će biti deo koji sleduje tvojim sinovima i tebi doveka, kao što je Gospod zapovedio.“ ");
INSERT INTO srponstl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Onda se Mojsije raspitao o jarcu – žrtvi za greh, a on već spaljen! Razgnevivši se na Eleazara i Itamara, Aronove preostale sinove, rekao je: ");
INSERT INTO srponstl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","„Zašto niste jeli žrtvu za greh na svetom mestu, jer je presveta?! Ona vam je dana da ukloni krivicu zajednice i da izvrši za njih obred otkupljenja pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Pošto njena krv nije bila unesena u Svetinju, trebalo je da je jedete u Svetinji, kao što sam zapovedio.“ ");
INSERT INTO srponstl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aron odgovori Mojsiju: „Vidi, danas su prineli svoju žrtvu za greh i svoju žrtvu svespalnicu pred Gospodom, a evo šta me je zadesilo. Da sam danas jeo žrtvu za greh, da li bi to ugodilo Gospodu?“ ");
INSERT INTO srponstl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Kad je Mojsije to čuo, odobrio je to. ");
INSERT INTO srponstl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","„Recite Izrailjcima: ’Od svih životinja na zemlji, ovo su one koje smete jesti: ");
INSERT INTO srponstl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","svaku koja ima papke, i to razdvojene papke, i koja preživa, možete jesti. ");
INSERT INTO srponstl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Međutim, od onih životinja što preživaju, ili imaju razdvojene papke ne jedite: kamilu, jer iako preživa, nema razdvojene papke; nečista je za vas; ");
INSERT INTO srponstl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","daman, jer iako preživa, nema razdvojene papke; nečist je za vas; ");
INSERT INTO srponstl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","divljeg zeca, jer iako preživa, nema razdvojene papke; nečist je za vas; ");
INSERT INTO srponstl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","svinju, jer iako ima razdvojene papke, ne preživa; obredno je nečista za vas. ");
INSERT INTO srponstl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ne jedite njihovo meso, i ne dotičite njihovu strvinu; nečiste su za vas. ");
INSERT INTO srponstl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Od svega što je u vodi, ove jedite: sve što je u vodi, u morima ili rekama, i ima peraje i krljušt, to možete jesti. ");
INSERT INTO srponstl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","A sve što je u morima i rekama, a nema peraje i krljušt, od svega što vrvi u vodi, i od svih drugih živih bića – za vas je odvratno. ");
INSERT INTO srponstl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Držite ih za odvratne; ne jedite njihovo meso, i neka vam njihova lešina bude odvratna. ");
INSERT INTO srponstl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Sve što je u vodi, a nema peraje i krljušt – za vas je odvratno. ");
INSERT INTO srponstl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Ovo su ptice koje morate smatrati nečistima. Ne jedite ih, jer su odvratne za vas: orao, lešinar, jastreb, ");
INSERT INTO srponstl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","kraguj, kobac svake vrste, ");
INSERT INTO srponstl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","sve vrste gavrana, ");
INSERT INTO srponstl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","noj, sova, galeb, sve vrste kraguja, ");
INSERT INTO srponstl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ćuk, kormoran, buljina, ");
INSERT INTO srponstl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","labud, buljina, beloglavi sup, ");
INSERT INTO srponstl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","roda, sve vrste čaplji, pupavac i slepi miš. ");
INSERT INTO srponstl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Sva krilata bića koja gamižu i idu na četiri noge, za vas su odvratna. ");
INSERT INTO srponstl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Od svih bića koja gamižu i idu na četiri noge, ove možete jesti: one koje iznad svojih nogu imaju zglobove kojima skaču po zemlji. ");
INSERT INTO srponstl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Od ovih možete jesti: sve vrste skakavaca, sve vrste cvrčaka, i sve vrste argola i zrikavaca. ");
INSERT INTO srponstl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","A svako krilato biće koje gamiže, a ima četiri noge, za vas je odvratno. ");
INSERT INTO srponstl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ova će vas učiniti nečistima; ko god dotakne njihovu lešinu biće nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ko god ponese njihovu lešinu, neka opere svoju odeću; biće nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Svaka životinja koja ima nerazdvojene papke i ne preživa, za vas je nečista i nečist će biti svako ko ih se dotakne. ");
INSERT INTO srponstl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Sve što hoda na šapama među životinjama koje hodaju na četiri noge, za vas su nečiste. Ko god se dotakne njihove lešine, biće nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ko ponese njihovu lešinu, neka opere svoju odeću; biće nečist do večeri. Za vas su nečiste. ");
INSERT INTO srponstl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Od životinja što puze po zemlji za vas su nečiste: lasica, miš, i sve vrste velikih guštera, ");
INSERT INTO srponstl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","gekon, krokodil, zelembać, daždevnjak i kameleon. ");
INSERT INTO srponstl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Od životinja što puze te su nečiste za vas. Ko god ih dotakne kad uginu biće nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Kad neka od ovih životinja mrtva padne na nešto, to će biti nečisto, bilo to drvena posuda, odeća, koža, ili kostret, to jest, svaki predmet koji služi čemu. To neka se zamoči u vodu, i biće nečisto do večeri. Potom će biti čisto. ");
INSERT INTO srponstl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ako neka od njih upadne u bilo koju zemljanu posudu, sve što je u njoj biće nečisto. Zato je razbijte. ");
INSERT INTO srponstl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Svaka hrana koja se jede, ako u nju dospe voda iz takve posude, postaće nečista, i svako piće koje se pije biće nečisto ako je bilo u takvoj posudi. ");
INSERT INTO srponstl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ako lešina neke od ovih životinja padne na nešto, to će biti nečisto, bilo peć ili ognjište. To neka se razvali. One su nečiste i za vas će ostati nečiste. ");
INSERT INTO srponstl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ipak, izvor ili čatrnja gde se skuplja voda biće čisti, ali onaj ko dotakne njihovu lešinu biće nečist. ");
INSERT INTO srponstl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ako takva strvina padne na seme za setvu, seme će ostati čisto. ");
INSERT INTO srponstl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ali ako voda ovlaži seme i strvina padne na njega, za vas će biti nečisto. ");
INSERT INTO srponstl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Ako ugine životinja koju smete jesti, svako ko je dodirne biće nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Onaj koji pojede od njene strvine biće nečist do večeri, a ko ponese njenu strvinu neka opere svoju odeću i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Svaka životinja koja puzi po zemlji je odvratna. Neka se ne jede! ");
INSERT INTO srponstl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Sve što ide na trbuhu, i sve što se kreće na četiri noge, i sve što ima mnogo nogu, i sva bića što puze po zemlji, to ne smete jesti, jer su odvratne. ");
INSERT INTO srponstl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Nemojte se poganiti nijednim bićem koje puzi; ne skrnavite se njima da ne postanete nečisti. ");
INSERT INTO srponstl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Jer ja sam Gospod, Bog vaš! Zato budite sveti, jer sam ja svet. Ne skrnavite se nijednim bićem što puzi po zemlji. ");
INSERT INTO srponstl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ja sam Gospod koji vas je izveo iz zemlje egipatske da vam budem Bog. Stoga budete sveti, jer ja sam svet! ");
INSERT INTO srponstl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ovo su zakoni o životinjama, pticama i svakom živom biću koje vrvi u vodi, i svakom biću koje puzi po zemlji, ");
INSERT INTO srponstl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","da se pravi razlika između nečistog i čistog; između životinja koja se mogu jesti i životinja koja se ne mogu jesti.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","„Reci narodu izrailjskom: ’Kad koja žena zatrudni i rodi muško dete, biće nečista sedam dana; biće nečista kao u dane mesečnog reda. ");
INSERT INTO srponstl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Osmoga dana neka se dete obreže. ");
INSERT INTO srponstl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Neka u stanju čišćenja od svoje krvi ostane trideset tri dana; neka ne dotiče ništa sveto, i neka ne ulazi u Svetilište, dok se ne navrše dani njenog očišćenja. ");
INSERT INTO srponstl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","A ako rodi žensko dete, biće nečista dve nedelje, kao u toku mesečnog reda; neka u stanju čišćenja od svoje krvi ostane šezdeset šest dana. ");
INSERT INTO srponstl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Kad se navrše dani njenog čišćenja za sina ili za ćerku, neka na ulaz u Šator od sastanka dovede svešteniku jagnje od godinu dana za žrtvu svespalnicu, i golubića, ili grlicu, za žrtvu za greh. ");
INSERT INTO srponstl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","On će ga prineti pred Gospodom i izvršiti obred otkupljenja za nju, i biće očišćena od izliva svoje krvi. Ovo je zakon za ženu kada rodi muško ili žensko dete. ");
INSERT INTO srponstl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","A ako ne može sebi da priušti jagnje, neka uzme dve grlice ili dva golubića, jedno za žrtvu svespalnicu, a drugo za žrtvu za greh. Sveštenik će izvršiti obred otkupljenja za nju i biće čista.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","„Čovek na čijoj se koži pojavi otok, svrab ili svetla pega, i to se razvije u oboljenje na njegovoj koži koje izgleda kao guba, neka se dovede svešteniku, Aronu ili jednom od njegovih sinova, sveštenika. ");
INSERT INTO srponstl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Neka sveštenik pregleda oboljenje na njegovoj koži. Ako je dlaka na obolelom mestu pobelela, a obolelo mesto niže od kože na njegovom telu, to je guba. Kada ga sveštenik pregleda, neka ga proglasi nečistim. ");
INSERT INTO srponstl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ali ako je pega na njegovoj koži bela, i ne izgleda da je niža od kože, a dlaka na njoj nije pobelela, neka sveštenik zatvori obolelog na sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sedmoga dana neka ga sveštenik pregleda. Ako vidi da je oboljenje ostalo isto i da se nije proširilo po koži, neka ga sveštenik zatvori na još sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Sedmoga dana neka ga sveštenik ponovo pregleda. Ako primeti da se oboljenje povlači i da se nije proširilo po koži, neka ga proglasi čistim: to je svrab. Neka opere svoju odeću i biće čist. ");
INSERT INTO srponstl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ali ako se svrab proširi po koži nakon što ga sveštenik pregleda i proglasi čistim, neka se ponovo pojavi pred sveštenikom. ");
INSERT INTO srponstl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ako sveštenik vidi da se svrab proširio po koži, neka ga proglasi nečistim; to je guba. ");
INSERT INTO srponstl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Onaj ko oboli od gube mora da se dovede pred sveštenika. ");
INSERT INTO srponstl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Ako sveštenik primeti da je otok na koži beo, i da je od njega pobelela dlaka, i da je živo meso u otoku, ");
INSERT INTO srponstl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","to se guba pritajila na njegovoj koži. Sveštenik će ga proglasiti nečistim. Neće ga zatvoriti, jer je već nečist. ");
INSERT INTO srponstl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ali ako guba izbije po koži tako da prekrije celu kožu od glave do pete, gde god da sveštenik pogleda, ");
INSERT INTO srponstl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","neka ga sveštenik pregleda. Ako je guba prekrila celo njegovo telo, neka proglasi obolelog čistim. Pošto je sve pobelelo, čist je. ");
INSERT INTO srponstl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ali čim se na njemu pojavi živo meso, biće nečist. ");
INSERT INTO srponstl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kada sveštenik primeti živo meso, neka ga proglasi nečistim. Živo meso je nečisto; to je guba. ");
INSERT INTO srponstl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ako živo meso ponovo pobeli, neka dođe svešteniku. ");
INSERT INTO srponstl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ako, dakle, sveštenik vidi da je oboljenje pobelelo, neka sveštenik proglasi obolelog čistim: čist je. ");
INSERT INTO srponstl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Kada neko dobije čir na koži koji zaceli, ");
INSERT INTO srponstl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","a na tom mestu se pojavi beli otok, ili crvenkastobela mrlja, neka se pokaže svešteniku. ");
INSERT INTO srponstl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ako sveštenik primeti da otok izgleda niži od ostale kože, i da je dlaka pobelela, neka ga sveštenik proglasi nečistim. To je oboljenje, guba koja je izbila na čiru. ");
INSERT INTO srponstl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ako sveštenik primeti da na otoku nema bele dlake, i da nije niži od ostale kože, nego da se povlači, neka ga sveštenik zatvori na sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ako se proširi po koži, neka ga sveštenik proglasi nečistim: to je kožno oboljenje. ");
INSERT INTO srponstl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","No, ako svetla mrlja stoji gde jeste i ne širi se, to je ožiljak od čira. Neka ga sveštenik proglasi čistim. ");
INSERT INTO srponstl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ako neko ima opekotinu na koži, pa se na živom mesu na opekotini pojavi pega, bilo crvenkastobela ili bela, ");
INSERT INTO srponstl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","neka je sveštenik pregleda. Ako je dlaka na svetloj mrlji pobelela i izgleda niže od ostale kože, to je guba izbila na opekotini. Neka ga sveštenik proglasi nečistim. To je oboljenje gube. ");
INSERT INTO srponstl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ali, ako sveštenik primeti da dlaka na svetloj mrlji nije pobelela i da mrlja nije niža od ostale kože, nego da se povlači, neka ga sveštenik zatvori na sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Sedmoga dana, neka ga sveštenik pregleda. Ako se proširi po koži, neka ga sveštenik proglasi nečistim. To je oboljenje gube. ");
INSERT INTO srponstl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","No, ako svetla mrlja stoji gde jeste i ne širi se po koži, nego se povlači, neka ga sveštenik proglasi čistim. To je ožiljak od opekotine. ");
INSERT INTO srponstl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ako muškarac ili žena ima oboljenje na glavi, ili na bradi, ");
INSERT INTO srponstl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","neka sveštenik pregleda oboljenje. Ako izgleda da je niže od ostale kože, i da je na njemu dlaka žućkasta i tanka, neka ga sveštenik proglasi nečistim. To je šuga, oboljenje gube na glavi ili na bradi. ");
INSERT INTO srponstl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ali ako sveštenik nakon pregleda ustanovi da oboljenje, šuga, ne izgleda niže od ostale kože, i da nema crne dlake na njemu, neka sveštenik zatvori obolelog od šuge na sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sedmog dana neka sveštenik pregleda obolelog. Ako se šuga nije proširila, i nema žućkaste dlake na njoj, a šuga ne izgleda niža od ostale kože, ");
INSERT INTO srponstl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","neka se ošugavljeni obrije, ali neka ne obrije šugu. Sveštenik neka ga zatvori na još sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sedmog dana neka sveštenik pregleda obolelog od šuge. Ako primeti da se šuga nije proširila po koži, i da nije niža od ostale kože, neka ga sveštenik proglasi čistim. Neka opere svoju odeću i biće čist. ");
INSERT INTO srponstl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Međutim, ako se šuga proširi po koži nakon što je bio proglašen čistim, ");
INSERT INTO srponstl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","neka ga sveštenik pregleda. Ako primeti da se šuga proširila po koži, neka sveštenik ne gleda ima li žute dlake; nečist je. ");
INSERT INTO srponstl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ako on oceni da se šuga nije promenila, i da crna dlaka nije izrasla na njoj, šuga se izlečila: čist je. Sveštenik neka ga proglasi čistim. ");
INSERT INTO srponstl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Ako se na koži nekog čoveka ili žene pojave bele pege, ");
INSERT INTO srponstl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","neka sveštenik izvrši pregled. Ako su pege na koži zagasito bele, to je osip izbio na koži: čist je. ");
INSERT INTO srponstl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Ako nekom čoveku opadne kosa s glave, te oćelavi, čist je. ");
INSERT INTO srponstl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ako mu kosa opadne spreda, te mu oćelavi čelo, čist je. ");
INSERT INTO srponstl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ali ako mu se na ćelavom čelu ili ćelavom zatiljku pojavi belo oboljenje sa crvenilom, to je guba izbila po ćelavom čelu ili ćelavom zatiljku. ");
INSERT INTO srponstl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Neka ga sveštenik pregleda. Ako primeti oboljenje s belim otokom i crvenilom na njegovom ćelavom čelu ili ćelavom zatiljku, nalik gubi na koži, ");
INSERT INTO srponstl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","čovek je gubav, nečist je. Neka ga sveštenik proglasi nečistim; oboljenje mu je na glavi. ");
INSERT INTO srponstl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Onaj ko oboli od oboljenja gube, neka nosi razdrtu odeću; kosa neka mu bude raspuštena; a gornju usnu neka pokrije i neka viče: ’Nečist! Nečist!’ ");
INSERT INTO srponstl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","On će biti nečist dokle god je oboljenje na njemu. Pošto je nečist neka živi odvojeno: boravište će mu biti izvan tabora. ");
INSERT INTO srponstl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ako se oboljenje gube pojavi na vunenoj ili lanenoj odeći, ");
INSERT INTO srponstl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","bilo na osnovi bilo na potki, ili na koži, ili na bilo čemu izrađenom od vune; ");
INSERT INTO srponstl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","te ako je oboljenje na odeći, ili na koži, na osnovi ili na potki, ili bilo kakvom predmetu od kože, zelenkaste ili crvenkaste boje, to je oboljenje gube. Neka se pokaže svešteniku. ");
INSERT INTO srponstl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kada sveštenik pregleda oboljenje, neka zatvori zaraženi predmet na sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Sedmog dana neka pregleda zaraženi predmet. Ako se oboljenje proširilo po odeći, bilo na osnovi bilo na potki, ili na koži, ili na bilo čemu izrađenom od kože, čemu god da koža služi, to je zloćudno oboljenje gube; predmet je nečist. ");
INSERT INTO srponstl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Neka spali odeću, osnovu ili potku, bilo da je od vune ili od lana, ili kakav predmet od kože na kome se nađe oboljenje, jer je to zloćudna guba. To neka se spali! ");
INSERT INTO srponstl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Sveštenik neka izvrši pregled. Ako se oboljenje nije proširilo po odeći, osnovi ili potki, ili po bilo kakvom predmetu od kože, ");
INSERT INTO srponstl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","neka sveštenik naredi da se opere predmet na kome je oboljenje. Zatim neka ga zatvori na još sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Sveštenik neka pregleda zaraženi predmet nakon što je bio opran. Ako proceni da oboljenje nije promenilo izgled, iako se nije proširilo, nečist je. Neka se spali, bilo da se oboljenje nalazi na spoljašnjoj ili unutrašnjoj strani predmeta. ");
INSERT INTO srponstl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ako sveštenik vidi da se oboljenje povuklo nakon pranja, neka otkine to mesto s odeće, ili s kože, s osnove ili potke. ");
INSERT INTO srponstl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ali ako se oboljenje opet pojavi na odeći, na osnovi ili potki, ili na bilo kakvom predmetu od kože, što god je zahvaćeno oboljenjem, neka se to spali. ");
INSERT INTO srponstl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","A odeću, osnovu ili potku, ili bilo kakvu stvar od kože, s koje ode oboljenje nakon što je opereš, treba ponovo oprati i biće čista.“ ");
INSERT INTO srponstl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","To su propisi o oboljenju gube na odeći od vune ili lana, na osnovi ili na potki, ili na bilo kakvom predmetu od kože, da proglase šta je čisto ili nečisto. ");
INSERT INTO srponstl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","„Ovo će biti zakon za gubavoga u dan njegovog očišćenja. Kada ga dovedu svešteniku, ");
INSERT INTO srponstl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","sveštenik će izaći iz tabora. Ako vidi da se oboleli izlečio od gube, ");
INSERT INTO srponstl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","neka sveštenik zapovedi da se za čoveka koji će biti očišćen donesu dve žive i čiste ptice, kedrovo drvo, tamno crveno predivo i izop. ");
INSERT INTO srponstl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Neka sveštenik zapovedi da se jedna ptica zakolje nad svežom vodom u zemljanoj posudi. ");
INSERT INTO srponstl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Zatim neka uzme živu pticu, kedrovo drvo, tamnocrveno predivo i izop, pa neka ih umoči zajedno sa živom pticom u krv ptice koja je bila zaklana nad svežom vodom. ");
INSERT INTO srponstl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Potom neka sedam puta poškropi onoga koji se čisti od gube i proglasi ga čistim. Onda neka pusti živu pticu u polje. ");
INSERT INTO srponstl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","A očišćeni neka opere svoju odeću, neka obrije sve svoje dlake, i neka se okupa u vodi i biće čist. Posle toga neka se vrati u tabor, ali neka boravi izvan svog šatora sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","A sedmoga dana neka obrije sve svoje dlake na glavi, bradi, grudima, obrvama, i sve ostale dlake. Onda neka opere svoju odeću i okupa telo u vodi i biće čist. ");
INSERT INTO srponstl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Osmoga dana neka uzme dva jagnjeta bez mane, jedno žensko jagnje bez mane od godinu dana, tri desetine efe brašna zamešenog s uljem za žitnu žrtvu, i jedan log ulja. ");
INSERT INTO srponstl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Neka sveštenik koji vrši očišćenje, postavi sve to i čoveka koji se čisti, pred Gospodom, na ulaz Šatora od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Neka sveštenik uzme jedno muško jagnje i prinese ga kao žrtvu za prestup zajedno sa logom ulja. Neka ih podigne pred Gospodom kao žrtvu dizanicu. ");
INSERT INTO srponstl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Jagnje neka zakolje na svetom mestu gde je zaklao žrtvu za greh i žrtvu svespalnicu. Žrtva za prestup, kao žrtva za greh, pripada svešteniku; ona je presveta. ");
INSERT INTO srponstl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Neka sveštenik uzme nešto krvi žrtve za prestup, pa neka njome namaže desnu resicu uha onog koji se čisti, palac njegove desne ruke i palac njegove desne noge. ");
INSERT INTO srponstl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Sveštenik, zatim, neka uzme log ulja i izlije malo na dlan svoje leve ruke, ");
INSERT INTO srponstl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","i pošto umoči prst desne ruke u ulje koje mu je na dlanu leve ruke, neka prstom sedam puta poškropi ulje pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ostatkom ulja iz svog dlana, neka sveštenik, preko krvi žrtve za prestup, namaže desnu resicu uha onog što se čisti, desni palac njegove ruke i desni palac njegove noge. ");
INSERT INTO srponstl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Onim što ostane od ulja na njegovom dlanu, neka sveštenik pomaže glavu onoga koji se čisti. Tako će sveštenik izvršiti obred otkupljenja za njega pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Potom neka sveštenik prinese žrtvu za greh, i izvrši obred otkupljenja za onoga koji se čisti od svoje nečistote, a onda neka zakolje žrtvu svespalnicu. ");
INSERT INTO srponstl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Neka sveštenik prinese na žrtveniku žrtvu svespalnicu i žitnu žrtvu. Tako će sveštenik izvršiti obred otkupljenja za njega, pa će biti čist. ");
INSERT INTO srponstl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Ali ako je siromašan, te ne može sebi priuštiti ovo, neka uzme jedno muško jagnje kao žrtvu za prestup, da se podigne kao žrtva za njegovo otkupljenje, i jednu desetinu mere brašna zamešenog s uljem za žitnu žrtvu, jedan log ulja, ");
INSERT INTO srponstl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","dve grlice ili dva golubića, prema onome što može priuštiti, jednog kao žrtvu za greh, a drugog kao žrtvu svespalnicu. ");
INSERT INTO srponstl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Osam dana od svoga očišćenja, neka ih donese svešteniku na ulaz od Šatora od sastanka, pred Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Neka sveštenik uzme jagnje, žrtvu za prestup, log ulja, i neka ih podigne kao žrtvu dizanicu pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Tada neka zakolje jagnje, žrtvu za prestup, a sveštenik neka uzme nešto krvi žrtve za prestup, i namaže resicu desnog uha onoga koji se čisti, palac njegove desne ruke i palac njegove desne noge. ");
INSERT INTO srponstl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Onda neka sveštenik izlije malo ulja na dlan svoje leve ruke, ");
INSERT INTO srponstl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","i prstom desne ruke poškropi uljem što mu je u dlanu leve ruke sedam puta pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Nakon toga, neka sveštenik uljem iz njegovog dlana namaže resicu desnog uha onog koji se čisti, palac njegove desne ruke i palac njegove desne noge, tamo gde je stavljena krv žrtve za prestup. ");
INSERT INTO srponstl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ostatkom ulja što mu je u dlanu, neka sveštenik namaže glavu onoga koji se čisti, da izvrši obred otkupljenja za njega pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Zatim neka prinese jednu od grlica ili jednog od golubića, šta već može priuštiti; ");
INSERT INTO srponstl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","jedno za žrtvu za greh, a drugo za žrtvu svespalnicu, zajedno sa žitnom žrtvom – prema sopstvenim mogućnostima. Tako će sveštenik izvršiti obred otkupljenja pred Gospodom za onoga koji se čisti.“ ");
INSERT INTO srponstl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ovo je zakon za obolelog od gube, koji nema sredstava za svoje očišćenje. ");
INSERT INTO srponstl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","„Kada uđete u hanansku zemlju koju vam dajem u posed, a ja dovedem gubu na neku kuću u zemlji koju zaposednete, ");
INSERT INTO srponstl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","neka vlasnik kuće dođe i javi svešteniku: ’Pojavilo se nešto kao zarazno oboljenje u mojoj kući.’ ");
INSERT INTO srponstl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Tada neka sveštenik zapovedi da se kuća isprazni, pre nego što ode da pregleda oboljenje, da se ne bi onečistilo sve što je u kući. Nakon toga neka sveštenik uđe da pregleda kuću. ");
INSERT INTO srponstl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Neka pregleda kuću, pa ako primeti da je oboljenje po zidovima kuće u vidu udubljenja zelenkaste ili crvenkaste boje, koja izgledaju niža od površine zida, ");
INSERT INTO srponstl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","neka sveštenik izađe na kućna vrata i neka zatvori kuću na sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Sedmoga dana, neka se sveštenik vrati. Ako primeti da se oboljenje proširilo po zidovima kuće, ");
INSERT INTO srponstl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","neka zapovedi da se izvadi kamenje na kome je oboljenje i neka se izbaci izvan grada na nečisto mesto. ");
INSERT INTO srponstl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Potom neka se kuća ostruže iznutra, a ostrugani malter neka se izbaci izvan grada na nečisto mesto. ");
INSERT INTO srponstl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Onda neka uzmu drugo kamenje i stave ga umesto onoga kamenja. Zatim neka se uzme novi malter i kuća ponovo omalteriše. ");
INSERT INTO srponstl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ali ako oboljenje ponovo izbije na kući nakon što je kamenje bilo izvučeno, i nakon što je kuća bila ostrugana i omalterisana, ");
INSERT INTO srponstl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","neka sveštenik dođe i pogleda. Ako primeti da se oboljenje proširilo po kući, to je zloćudna guba u kući: kuća je nečista. ");
INSERT INTO srponstl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Neka se kuća sruši, a kamenje, drvena građa, i sav malter od kuće neka se odnesu izvan grada na nečisto mesto. ");
INSERT INTO srponstl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Ko uđe u kuću dok je zatvorena, biće nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","A ko spava u kući, neka opere svoju odeću. Takođe i onaj ko jede u kući, neka opere svoju odeću. ");
INSERT INTO srponstl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ako sveštenik dođe i primeti da se oboljenje nije proširilo po kući nakon što je kuća bila omalterisana, neka proglasi kuću čistom, jer se oboljenje izlečilo. ");
INSERT INTO srponstl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Za očišćenje kuće neka uzme dve ptice, kedrovinu, skerletno predivo i izop. ");
INSERT INTO srponstl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Zatim neka zakolje jednu pticu nad svežom vodom u zemljanoj posudi. ");
INSERT INTO srponstl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Neka, zatim, uzme kedrovinu, izop, skerletno predivo i živu pticu, i umoči ih u krv zaklane ptice i svežu vodu, te poškropi kuću sedam puta. ");
INSERT INTO srponstl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Pošto očisti kuću krvlju ptice, svežom vodom, živom pticom, kedrovinom, izopom i skerletnim predivom, ");
INSERT INTO srponstl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","neka pusti živu pticu u polje izvan grada. Tako će izvršiti obred otkupljenja za kuću, i biće čista. ");
INSERT INTO srponstl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ovo je zakon za svako oboljenje gube i šuge, ");
INSERT INTO srponstl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","za gubu na odeći ili kući, ");
INSERT INTO srponstl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","za otok, svrab, ili pegu, ");
INSERT INTO srponstl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","da se utvrdi kada je nešto nečisto, a kada čisto.“ Ovo je zakon za gubu. ");
INSERT INTO srponstl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","„Govorite narodu izrailjskom! Recite mu: ’Kada neki čovek ima izliv iz svoga tela, njegov izliv je nečist. ");
INSERT INTO srponstl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Njegova nečistoća je u ovome: bez obzira da li njegov izliv ističe iz tela, ili je izliv prestao da ističe iz tela, on je nečist. ");
INSERT INTO srponstl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Svaka postelja na koju legne onaj sa izlivom, biće nečista, i svaka stvar na koju sedne, biće nečista. ");
INSERT INTO srponstl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Onaj koji dotakne njegovu postelju, neka opere svoju odeću, okupa se u vodi i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Onaj koji sedne na stvar na kojoj sedi onaj sa izlivom, neka opere svoju odeću, okupa se u vodi i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Onaj koji dotakne telo onoga sa izlivom, neka opere svoju odeću, okupa se u vodi i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ako onaj sa izlivom pljune na čistog, neka taj opere svoju odeću, okupa se u vodi i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","I svako sedlo na koje sedne onaj sa izlivom, biće nečisto. ");
INSERT INTO srponstl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Svako ko se dotakne bilo čega što je bilo pod njim, biće nečist do večeri. A ko ponese takve stvari, neka opere svoju odeću, okupa se u vodi i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ako onaj sa izlivom dotakne nekoga, a nije prethodno oprao ruke u vodi, taj neka opere svoju odeću, okupa se u vodi i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ako onaj sa izlivom dotakne zemljanu posudu, neka se ona razbije, a bilo kakva drvena posuda neka se ispere vodom. ");
INSERT INTO srponstl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Kada se onaj koji ima izliv očisti od svoga izliva, neka izbroji sedam dana za svoje očišćenje. Onda neka opere svoju odeću i okupa se u svežoj vodi, pa će biti čist. ");
INSERT INTO srponstl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Osmoga dana neka uzme dve grlice ili dva golubića, donese ih pred Gospoda na ulaz Šatora od sastanka i preda ih svešteniku. ");
INSERT INTO srponstl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Neka sveštenik prinese jedno za žrtvu za greh, a drugo za žrtvu svespalnicu. Tako će sveštenik izvršiti nad njim otkupljenje pred Gospodom za njegov izliv. ");
INSERT INTO srponstl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Kad čovek ima izliv semena, neka opere u vodi sve svoje telo i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","I svaka tkanina i koža na kojoj se nađe izliv semena, neka se opere u vodi, i bude nečista do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ako žena legne sa muškarcem i on izlije seme, neka se oboje okupaju u vodi i budu nečisti do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Kad žena ima izliv, to jest, redovan izliv krvi iz svoga tela, biće nečista sedam dana, a ko god je dotakne biće nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Sve na šta legne biće nečisto, i sve na šta sedne biće nečisto. ");
INSERT INTO srponstl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ko god se dotakne njene postelje, neka opere svoju odeću, okupa se u vodi i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","I ko god se dotakne bilo kakve stvari na koju ona sedne, neka opere svoju odeću, okupa se u vodi i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Bilo to postelja ili stvar na kojoj ona sedi, kada je dotakne, biće nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ako neki čovek legne s njom, njena nečistoća će preći na njega. On će biti nečist sedam dana, a tako će i svaka postelja na koju legne biti nečista. ");
INSERT INTO srponstl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Ako žena ima izliv krvi mnogo dana, ali ne u vreme njene redovne nečistoće, ili ako se izliv nastavi nakon njene redovne nečistoće, biće nečista za sve vreme izliva. Ona će biti nečista kao u dane svoje redovne nečistoće. ");
INSERT INTO srponstl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Svaka postelja na kojoj bude ležala za sve vreme njenog izliva, za nju će biti kao postelja tokom njene nečistoće, i svaki predmet na koji sedne biće nečist, kao u vreme njene redovne nečistoće. ");
INSERT INTO srponstl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ko god je dotakne, biće nečist. Taj neka opere svoju odeću, okupa se u vodi i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","A ako se očisti od svoga izliva, neka izbroji sedam dana, pa će nakon toga biti čista. ");
INSERT INTO srponstl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Osmoga dana neka uzme za sebe dve grlice, ili dva golubića, i neka ih donese svešteniku, na ulaz Šatora od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Neka sveštenik prinese jedno kao žrtvu za greh, a drugo kao žrtvu svespalnicu pred Gospodom, radi nečistoće njenog izliva.’ ");
INSERT INTO srponstl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Držite Izrailjce dalje od njihove nečistoće, da ne onečiste moje Prebivalište, koje je među njima, i tako umru u svojoj nečistoći. ");
INSERT INTO srponstl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ovo je zakon za čoveka koji ima izliv: za onoga koji ima izliv semena, te tako postane nečist, ");
INSERT INTO srponstl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","i za ženu koja se ne oseća dobro zbog svoje redovne nečistoće, to jest, i za muško i za žensko koje ima izliv, i za čoveka koji legne sa ženom koja je nečista.“ ");
INSERT INTO srponstl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Gospod je govorio Mojsiju i Aronu nakon smrti dva Aronova sina, kada su stupili pred Gospoda i poginuli. ");
INSERT INTO srponstl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Gospod je rekao Mojsiju: „Reci svome bratu Aronu da ne dolazi u Svetinju iza zavese u svako doba, ispred poklopca nad Kovčegom, da ne bi umro, jer ja se pojavljujem u oblaku nad poklopcem. ");
INSERT INTO srponstl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Neka Aron ovako dođe u svetinju: sa juncem iz krda za žrtvu za greh, i ovnom za žrtvu svespalnicu. ");
INSERT INTO srponstl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Neka obuče na sebe svetu lanenu košulju i lanene gaće na svoje telo; neka se opaše lanenim pojasom, a na glavu neka stavi laneni turban. To je sveta odora. Neka se okupa u vodi, pa neka se obuče. ");
INSERT INTO srponstl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Neka od zajednice Izrailjaca uzme dva jarca za žrtvu za greh, i jednog ovna za žrtvu svespalnicu. ");
INSERT INTO srponstl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aron neka prinese junca za žrtvu za greh radi sebe, da izvrši obred otkupljenja za sebe i svoj dom. ");
INSERT INTO srponstl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Zatim neka uzme dva jarca i postavi ih pred Gospoda, na ulaz od Šatora od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Neka Aron baci kocku za ta dva jarca, jednu kocku za Gospoda, a drugu za Azazela. ");
INSERT INTO srponstl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Potom neka Aron dovede jarca kockom određenog za Gospoda, i prinese ga kao žrtvu za greh. ");
INSERT INTO srponstl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","A jarac, koji je kockom određen za Azazela, neka se živ postavi pred Gospoda, da se njime izvrši obred otkupljenja, i da se pošalje Azazelu u pustinju. ");
INSERT INTO srponstl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Tada neka Aron dovede junca, žrtvu za greh radi sebe, i izvrši obred otkupljenja za sebe i za svoj dom. Neka zakolje junca, žrtvu za greh radi sebe. ");
INSERT INTO srponstl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Neka, zatim, uzme kadionicu punu užarenog uglja sa žrtvenika pred Gospodom, i dve pune šake sitno istucanog mirisnoga kada, pa neka donese iza zavese. ");
INSERT INTO srponstl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Onda neka stavi kad na oganj pred Gospodom, tako da oblak od kada zakloni poklopac nad Svedočanstvom, da ne bi umro. ");
INSERT INTO srponstl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Nakon toga neka uzme nešto junčeve krvi i svojim prstom poškropi prednju, istočnu stranu poklopca, a nešto od krvi neka poškropi svojim prstom ispred poklopca sedam puta. ");
INSERT INTO srponstl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Zatim neka zakolje jarca, žrtvu za greh za narod. Onda neka donese njegovu krv iza zavese, pa neka uradi s njegovom krvlju kao što je uradio s krvlju junca; neka je poškropi na poklopac i ispred poklopca. ");
INSERT INTO srponstl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Tako će izvršiti obred otkupljenja za Svetinju zbog nečistoće Izrailjaca, zbog njihovih prestupa i svih njihovih greha. Neka isto uradi i sa Šatorom od sastanka, koji prebiva s njima usred njihove nečistoće. ");
INSERT INTO srponstl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Nijedan čovek ne sme biti u Šatoru od sastanka od časa kada on uđe da izvrši obred otkupljenja u Svetinji do časa kada izađe. Kad izvrši obred otkupljenja za sebe i za sav zbor Izrailjaca, ");
INSERT INTO srponstl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","neka izađe prema žrtveniku koji je pred Gospodom, i neka izvrši obred otkupljenja za njega. Neka uzme nešto junčeve i jarčeve krvi, pa neka njome namaže rogove žrtvenika sa svih strana. ");
INSERT INTO srponstl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Onda neka ga poškropi svojim prstom sedam puta. Tako će ga očistiti od svih nečistoća Izrailjaca, i posvetiti ga. ");
INSERT INTO srponstl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Kad završi obred otkupljenja za Svetinju, Šator od sastanka i žrtvenik, neka dovede živog jarca. ");
INSERT INTO srponstl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Neka Aron položi obe ruke na glavu živoga jarca i nad njim ispovedi sve krivice Izrailjaca, sve njihove prestupe, i sve njihove grehe. I pošto ih sve položi na glavu jarca, neka ga pošalje u pustinju s jednim čovekom koji je određen za to. ");
INSERT INTO srponstl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Tako će jarac poneti na sebi sve njihove krivice u pusti kraj. Kad pošalje jarca u pustinju, ");
INSERT INTO srponstl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","neka Aron uđe u Šator od sastanka, skine sa sebe lanenu odoru koju je obukao prilikom ulaska u Svetinju, i ostavi je tamo. ");
INSERT INTO srponstl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Potom neka okupa svoje telo u vodi na svetom mestu, i obuče svoju odeću. Nakon toga neka izađe i prinese žrtvu svespalnicu za sebe, za narod, i izvrši obred otkupljenja za sebe i za narod. ");
INSERT INTO srponstl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Salo žrtve za greh neka spali na žrtveniku. ");
INSERT INTO srponstl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Onaj koji šalje jarca Azazelu, neka opere svoju odeću i okupa svoje telo u vodi. Nakon toga neka uđe u tabor. ");
INSERT INTO srponstl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","A junac, žrtva za greh, i jarac, žrtva za greh, čija je krv unešena u Svetinju za obred otkupljenja, neka se iznesu izvan tabora da se spale: njihova koža, meso i balega. ");
INSERT INTO srponstl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Onaj koji ih spaljuje, neka opere svoju odeću i neka se okupa u vodi. Posle toga neka uđe u tabor. ");
INSERT INTO srponstl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Neka ovo bude za vas trajna uredba: sedmoga meseca, desetog dana, postite i ne radite nikakvog posla, kako domaći, tako i stranac koji boravi među vama. ");
INSERT INTO srponstl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Jer na ovaj dan biće izvršen obred otkupljenja za vas, da vas očisti od svih vaših greha, pa ćete biti čisti pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Za vas je to subota potpunog odmora kada ćete postiti. Ovo je trajna uredba. ");
INSERT INTO srponstl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Neka sveštenik, koji bude pomazan i posvećen za svešteničku službu umesto svoga oca, izvrši obred otkupljenja. Neka obuče svetu lanenu odoru, ");
INSERT INTO srponstl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","pa neka izvrši obred otkupljenja za sveto Svetilište, za Šator od sastanka i žrtvenik. Potom neka izvrši obred otkupljenja za sveštenike, i za sav sabrani narod. ");
INSERT INTO srponstl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Neka ovo bude trajna uredba za vas: obred otkupljenja za Izrailjce obavljaće se jedanput godišnje za sve njihove grehe.“ Mojsije je učinio onako kako mu je Gospod rekao. ");
INSERT INTO srponstl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","„Govori Aronu, njegovim sinovima, i svim Izrailjcima. Reci im: ’Ovo je Gospod zapovedio: ");
INSERT INTO srponstl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Svaki čovek iz doma Izrailjeva koji zakolje vola, ovcu, ili kozu u taboru, ili izvan tabora, ");
INSERT INTO srponstl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","a ne dovede ih na ulaz od Šatora od sastanka da ih prinese kao prinos Gospodu pred njegovim Prebivalištem, biće kriv za prolivenu krv: prolio je krv; neka se takav čovek istrebi iz svog naroda. ");
INSERT INTO srponstl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","To je zato da bi Izrailjci svoje žrtve, koje bi prinosili u polju, donosili pred Gospoda na ulaz Šatora od sastanka, k svešteniku, i prinosili ih kao žrtve mira Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Neka sveštenik zapljusne krvlju Gospodnji žrtvenik kod ulaza u Šator od sastanka, i spali salo na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Tako neće više svoje žrtve prinositi jarcima sa kojima bludniče. Neka ovo bude trajna uredba za njihove naraštaje.’ ");
INSERT INTO srponstl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Još im recite: ’Svaki čovek iz doma Izrailjeva, ili stranac što boravi među vama, koji prinosi žrtvu svespalnicu, ili drugu žrtvu, ");
INSERT INTO srponstl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","a ne donese je na ulaz Šatora od sastanka da je prinese Gospodu, neka se istrebi iz svog naroda. ");
INSERT INTO srponstl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Ako bilo koji čovek iz doma Izrailjeva, ili bilo koji stranac što boravi među vama, bude jeo krv, ja ću okrenuti svoje lice protiv takvoga što jede krv, i istrebiti ga iz njegovog naroda. ");
INSERT INTO srponstl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Jer je život živog bića u njegovoj krvi, a ja sam vam je dao da na žrtveniku vršite obred otkupljenja za svoje živote, jer krv je ono što vrši otkup za život. ");
INSERT INTO srponstl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Zato sam rekao Izrailjcima: niko od vas ne sme jesti krv, pa ni stranac koji boravi među vama. ");
INSERT INTO srponstl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Svaki čovek, bio on Izrailjac, ili stranac što boravi među vama, koji ulovi zverku ili pticu što se može jesti, neka iscedi njenu krv i zatrpa je zemljom. ");
INSERT INTO srponstl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Jer je život svakog živog bića njegova krv, a ja sam rekao Izrailjcima: ne jedite krvi nijednoga živog bića, jer je život svakog živog bića njegova krv. Ko god je bude jeo, neka bude istrebljen. ");
INSERT INTO srponstl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Ako neko pojede meso uginule, ili rastrgane životinje, bio domaći ili stranac, neka opere svoju odeću, okupa se u vodi, i bude nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ako se ne operu i ne okupaju svoje telo, snosiće odgovornost za svoju krivicu.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","„Govori Izrailjcima i reci im: ’Ja sam Gospod, Bog vaš. ");
INSERT INTO srponstl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ne povodite se za delima koja se čine u egipatskoj zemlji gde ste živeli, niti za delima hananske zemlje u koju vas dovodim. Ne sledite njihove zakone. ");
INSERT INTO srponstl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Vršite moje odredbe i držite moje propise sledeći ih. Ja sam Gospod, Bog vaš! ");
INSERT INTO srponstl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Držite moje propise i odredbe: ko ih vrši, po njima će steći život. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Neka niko od vas ne pristupa kome od svoje krvne rodbine da otkrije njihovu golotinju. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ne otkrivaj golotinju svoga oca ili svoje majke; majka ti je, ne otkrivaj njenu golotinju. ");
INSERT INTO srponstl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ne otkrivaj golotinju žene svoga oca; to je golotinja tvoga oca. ");
INSERT INTO srponstl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ne otkrivaj golotinju svoje sestre, ćerke svoga oca, ili ćerke svoje majke, bilo da se rodila u kući, ili izvan kuće. ");
INSERT INTO srponstl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ne otkrivaj golotinju ćerke svoga sina, ili ćerke svoje ćerke, jer je njihova golotinja tvoja golotinja. ");
INSERT INTO srponstl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ne otkrivaj golotinju ćerke žene svoga oca, koja se rodila tvome ocu: sestra ti je. ");
INSERT INTO srponstl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ne otkrivaj golotinju sestre svoga oca; ona je krvna rodbina tvoga oca. ");
INSERT INTO srponstl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ne otkrivaj golotinju sestre svoje majke, jer je ona krvna rodbina tvoje majke. ");
INSERT INTO srponstl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ne otkrivaj golotinju brata svoga oca: ne pristupaj njegovoj ženi; strina ti je. ");
INSERT INTO srponstl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ne otkrivaj golotinju svoje snahe: ona je žena tvoga sina; ne otkrivaj njenu golotinju. ");
INSERT INTO srponstl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ne otkrivaj golotinju žene svoga brata; to je golotinja tvoga brata. ");
INSERT INTO srponstl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ne otkrivaj golotinju žene i njene ćerke, niti uzimaj za ženu ćerku njenog sina, ili ćerku njene ćerke, da otkriješ njenu golotinju. Oni su krvna rodbina; to je izopačenost. ");
INSERT INTO srponstl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ne uzimaj sebi za ženu sestru svoje žene, da ne stvoriš suparništvo otkrivajući njenu golotinju dok ti je prva žena živa. ");
INSERT INTO srponstl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Ne pristupaj ženi da otkriješ njenu golotinju tokom njene redovne nečistoće. ");
INSERT INTO srponstl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Nemoj legati sa ženom svoga bližnjega; postaćeš nečist. ");
INSERT INTO srponstl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ne daj da nijedno tvoje dete bude žrtvovano Molohu; tako ćeš oskrnaviti ime svoga Boga. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ne legaj s muškarcem, kao što se leže sa ženom; to je odvratno. ");
INSERT INTO srponstl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ne legaj s nijednom životinjom: opoganićeš se njome. Nijedna žena se ne sme podati životinji da se s njom pari; to je izopačenost. ");
INSERT INTO srponstl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ne pogani se nijednim od ovog, jer su se ovim poganili narodi koje ja teram pred vama. ");
INSERT INTO srponstl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","I pošto se zemlja opoganila, kaznio sam je za njenu krivicu, te je zemlja izbljuvala svoje stanovništvo. ");
INSERT INTO srponstl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Zato držite moje propise i uredbe i ne činite ništa od ovih odvratnih stvari, ni domaći, ni stranac koji boravi među vama. ");
INSERT INTO srponstl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Jer, sve su te odvratne stvari činili ljudi, koji su pre vas živeli, pa je zemlja postala nečista. ");
INSERT INTO srponstl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Pazite da ne poganite zemlju; ona će izbljuvati vas, kao što je izbljuvala narod koji je u njoj živeo pre vas. ");
INSERT INTO srponstl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Ko god učini bilo koju od ovih odvratnosti; neka se istrebe iz svog naroda oni koji ih učine. ");
INSERT INTO srponstl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Stoga, držite se onog što vam nalažem, da ne sledite nijedan od odvratnih običaja koji su se činili pre vas. Ne poganite se njima. Ja sam Gospod, Bog vaš!’“ ");
INSERT INTO srponstl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","„Govori svoj izrailjskoj zajednici. Reci im: ’Budite sveti, jer sam svet ja, Gospod, Bog vaš! ");
INSERT INTO srponstl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Svako neka poštuje svoju majku i svoga oca. Držite subote. Ja sam Gospod, Bog vaš! ");
INSERT INTO srponstl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ne okrećite se za ništavnim idolima; ne pravite sebi livene bogove. Ja sam Gospod, Bog vaš! ");
INSERT INTO srponstl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Kada prinosite žrtvu mira Gospodu, prinesite je tako da bude primljena u vaše ime. ");
INSERT INTO srponstl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Neka se pojede istog dana kada se prinese, ili sutradan. Što ostane do trećeg dana, neka se spali. ");
INSERT INTO srponstl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ako se od nje bude jelo i trećeg dana, biće nečista, te neće biti primljena. ");
INSERT INTO srponstl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Onaj koji je bude jeo, navući će krivicu na sebe, jer je oskrnavio ono što je sveto Gospodu. Taj čovek neka se istrebi iz svoga naroda. ");
INSERT INTO srponstl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Kada žanjete urod svoje zemlje, ne žanjite do samog kraja svoje njive, i ne pabirčite što ostane od vaše žetve. ");
INSERT INTO srponstl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Nemoj pabirčiti ni svoj vinograd, ni kupiti zrna koja padnu s tvoga vinograda, nego ih ostavi siromahu i strancu. Ja sam Gospod, Bog vaš! ");
INSERT INTO srponstl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ne kradite! Ne lažite! Ne varajte jedan drugoga! ");
INSERT INTO srponstl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ne zaklinjite se lažno mojim imenom, i tako skrnaviti ime svoga Boga. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ne tlači svoga bližnjega! Ne pljačkaj! Ne zadržavaj kod sebe nadnicu radnikovu do jutra! ");
INSERT INTO srponstl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ne proklinji gluvoga, i ne postavljaj prepreke ispred slepog da se saplete, nego se boj Boga svoga! Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ne izvrćite pravdu: ne budi pristrasan prema siromahu, niti se stavljaj na stranu bogatoga. Sudi svome bližnjem po pravdi. ");
INSERT INTO srponstl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ne idi okolo da širiš klevete među svojim narodom. Ne ugrožavaj život svoga bližnjega. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Ne mrzi svoga brata u svome srcu. Ukori svoga bližnjega, da ne podlegneš grehu zbog njega. ");
INSERT INTO srponstl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ne osvećuj se, i ne gaji u sebi gnev protiv svojih sunarodnika, nego voli bližnjega svoga kao samoga sebe. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Drži moje propise: Ne daj da se tvoja stoka pari sa stokom druge vrste. Ne zasejavaj svoju njivu dvema vrstama semena. Ne odevaj se u odeću od dve različite tkanine. ");
INSERT INTO srponstl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Ako čovek legne sa robinjom koja je zaručena za drugog čoveka, ali nije otkupljena ili oslobođena, neka budu kažnjeni. Ipak, neće biti pogubljeni, jer ona nije slobodna. ");
INSERT INTO srponstl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","On neka dovede ovna, žrtvu za prestup, na ulaz Šatora od sastanka, kao žrtvu za prestup Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Neka sveštenik izvrši obred otkupljenja za njega ovnom, žrtvom za prestup, pred Gospodom za njegov greh, i biće mu oprošten greh koji je počinio. ");
INSERT INTO srponstl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Kad uđete u zemlju i zasadite bilo koju voćku, smatrajte njen plod zabranjenim. Tri godine će vam biti zabranjen; ne sme se jesti. ");
INSERT INTO srponstl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Četvrte godine neka sav njen rod bude posvećen za veselje u čast Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pete godine možete jesti njen plod. Tako će vam se urod uvećati. Ja sam Gospod, Bog vaš. ");
INSERT INTO srponstl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ne jedite ništa s krvlju. Ne gatajte i ne vračajte. ");
INSERT INTO srponstl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ne izbrijavajte svoje zulufe, i ne podrezujte krajeve svoje brade. ");
INSERT INTO srponstl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ne režite se po telu radi pokojnika, i ne iscrtavajte po sebi znakove. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Ne obeščašćuj svoje ćerke dajući je za bludnicu, da se zemlja ne bi odala bludu i ispunila pokvarenošću. ");
INSERT INTO srponstl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Držite moje subote, i poštujte moje Svetilište. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ne obraćajte se prizivačima duhova, niti tražite savet od vidovnjaka, da se ne onečistite o njih. Ja sam Gospod, Bog vaš! ");
INSERT INTO srponstl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Ustani pred sedom glavom, i ukazuj čast starcu; boj se svoga Boga! Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Ako se stranac nastani s tobom u vašoj zemlji, nemojte ga zlostavljati. ");
INSERT INTO srponstl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Stranac koji se nastani s vama neka vam bude kao domaći. Voli ga kao samog sebe, jer ste i vi bili stranci u Egiptu. Ja sam Gospod, Bog vaš! ");
INSERT INTO srponstl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ne budi nepošten kad meriš dužinu, težinu, ili količinu. ");
INSERT INTO srponstl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Koristi poštenu vagu, poštene tegove, poštenu efu i pošteni hin. Ja sam Gospod, Bog vaš, koji vas je izveo iz Egipta. ");
INSERT INTO srponstl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Držite sve moje propise, i sve moje odredbe, izvršavajući ih. Ja sam Gospod!’“ ");
INSERT INTO srponstl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","„Reci Izrailjcima: ’Svaki Izrailjac i svaki stranac koji boravi u Izrailju, koji da svoje dete Molohu, neka se svakako pogubi; narod zemlje neka ga zaspe kamenjem. ");
INSERT INTO srponstl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ja ću, lično, okrenuti svoje lice protiv tog čoveka i istrebiti ga iz njegovog naroda, jer je dao svoje dete Molohu i tako onečistio moje Svetilište i obeščastio moje sveto ime. ");
INSERT INTO srponstl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ali ako narod zemlje zatvori oči kada taj čovek da svoje dete Molohu, i ne pogubi ga, ");
INSERT INTO srponstl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ja ću okrenuti svoje lice protiv tog čoveka i njegovog roda, pa ću istrebiti iz njihovog naroda i njega i sve koji se budu odali bludu sa Molohom. ");
INSERT INTO srponstl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ako se neko obrati prizivačima duhova i vidovnjacima i krene za njima, te se tako oda bludu, ja ću okrenuti svoje lice protiv tog čoveka, pa ću ga istrebiti iz njegovog naroda. ");
INSERT INTO srponstl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Posvetite se i budite sveti, jer ja sam Gospod, Bog vaš. ");
INSERT INTO srponstl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Držite moje propise i vršite ih. Ja sam Gospod koji vas posvećuje. ");
INSERT INTO srponstl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ako neko prokune svoga oca ili svoju majku, neka se svakako pogubi; pošto je prokleo oca, ili majku, krv njegova pada na njegovu glavu. ");
INSERT INTO srponstl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ako čovek učini preljubu sa ženom svoga bližnjega, neka se svakako pogubi i preljubnik i preljubnica. ");
INSERT INTO srponstl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ako čovek legne sa ženom svoga oca, otkrio je golotinju svoga oca. Neka se svakako oboje pogube; krv njihova pada na njihovu glavu. ");
INSERT INTO srponstl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ako čovek legne sa svojom snahom, neka se svakako oboje pogube. Učinili su izopačeno delo; krv njihova pada na njihovu glavu. ");
INSERT INTO srponstl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ako čovek legne sa muškarcem kao što se leži sa ženom, počinili su odvratno delo. Neka se svakako oboje pogube; krv njihova pada na njihovu glavu. ");
INSERT INTO srponstl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ako čovek oženi ženu i njenu majku, to je pokvarenost. Neka se i on i njih dve spale. Tako neće biti pokvarenosti među vama. ");
INSERT INTO srponstl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ako čovek obleži životinju, neka se svakako pogubi. Životinja neka se ubije. ");
INSERT INTO srponstl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ako žena priđe životinji da se pari s njom, ubij i ženu i životinju. Neka se svakako pogube; krv njihova pada na njihovu glavu. ");
INSERT INTO srponstl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Ako čovek uzme za ženu svoju sestru, ćerku svoga oca, ili ćerku svoje majke, i on vidi njenu golotinju, i ona vidi njegovu golotinju, to je sramota. Neka se istrebe pred očima svoga naroda. Otkrio je golotinju svoje sestre; neka odgovara za svoju krivicu. ");
INSERT INTO srponstl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Čovek koji legne sa ženom dok ima mesečni red i otkrije njenu golotinju, otkrio je tako izvor njenog izliva, a ona je otkrila izvor svoje krvi. Neka se oboje istrebe iz svoga naroda. ");
INSERT INTO srponstl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Ne otkrivaj golotinju sestre svoje majke ili sestre svoga oca, jer bi tako otkrio golotinju svoga roda. Neka odgovaraju za svoju krivicu. ");
INSERT INTO srponstl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Čovek koji legne sa svojom strinom, otkrio je golotinju svoga strica. Neka plate sa svoj greh: umreće bez poroda. ");
INSERT INTO srponstl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ako čovek legne sa ženom svoga brata, to je nečisto. Otkrio je golotinju svoga brata; neka budu bez poroda. ");
INSERT INTO srponstl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Držite sve moje propise, sve moje uredbe, i vršite ih, da vas zemlja, u koju vas vodim da se naselite, ne bi izbljuvala. ");
INSERT INTO srponstl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ne sledite običaje naroda koje ja teram pred vama, jer oni su činili sve to, pa su mi postali mrski. ");
INSERT INTO srponstl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","A ja sam vam rekao: vi ćete primiti u posed zemlju; ja ću vam je dati u posed – zemlju kojom teku mleko i med. Ja sam Gospod, Bog vaš, koji vas je odvojio od drugih naroda. ");
INSERT INTO srponstl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Zato razlikujte čiste životinje od nečistih, i čiste ptice od nečistih. Ne opoganjujte se životinjom ni pticom, niti bilo čime što puzi po zemlji, što sam ja izdvojio za vas kao nečisto. ");
INSERT INTO srponstl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Budite mi sveti, jer sam svet ja, Gospod; ja sam vas odvojio od drugih naroda da budete moji. ");
INSERT INTO srponstl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Ako se među vama nađe čovek koji priziva duhove, ili je vidovnjak, neka se svakako pogubi kamenovanjem. Krv njihova pada na njih.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Gospod reče Mojsiju: „Govori sveštenicima, Aronovim sinovima. Reci im: ’Neka se niko od vas ne oskrnavi dodirujući pokojnika u svome narodu, ");
INSERT INTO srponstl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","izuzev onih koji su mu u krvnom srodstvu: svoje majke, oca, sina, ćerke, brata, ");
INSERT INTO srponstl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","sestre device s kojom je blizak, jer nije bila udata. Radi nje se može oskrnaviti. ");
INSERT INTO srponstl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ipak, neka se ne oskrnavi rodbinom sa ženine strane, i tako postane nečist. ");
INSERT INTO srponstl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Neka ne izbrijavaju nijedan deo svoje glave, i neka ne podrezuju krajeve svoje brade, niti se režu po telu. ");
INSERT INTO srponstl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Neka budu posvećeni svome Bogu; neka ne skrnave ime svoga Boga, jer oni prinose Gospodnje svespalnice. Zato neka budu sveti! ");
INSERT INTO srponstl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Neka se ne žene ženom okaljanom bludom, a ne smeju se ženiti ni ženom koja je razvedena od svoga muža, jer je sveštenik posvećen svome Bogu. ");
INSERT INTO srponstl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Smatraj ga svetim, jer on prinosi hleb tvoga Boga. Neka je i tebi svet, jer sam svet ja, Gospod, koji vas posvećujem. ");
INSERT INTO srponstl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ako se sveštenikova ćerka oskrnavi postavši bludnica, ona skrnavi svoga oca; neka bude spaljena. ");
INSERT INTO srponstl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Prvosveštenik, koji je nad svojom braćom, na čiju glavu je izliveno ulje pomazanja, i koji je posvećen da nosi odoru, ne sme raščupavati svoju kosu i derati svoju odeću. ");
INSERT INTO srponstl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","On ne sme prilaziti pokojniku, niti se sme skrnaviti svojim ocem i svojom majkom. ");
INSERT INTO srponstl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Neka ne izlazi iz Svetilišta, da ne bi oskrnavio Svetilište svoga Boga, jer je posvećen uljem posvećenja svoga Boga. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Neka uzme za ženu samo devicu. ");
INSERT INTO srponstl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","On ne sme uzimati za ženu udovicu, razvedenu i okaljanu bludom; sme se oženiti samo devicom iz svoga naroda, ");
INSERT INTO srponstl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","da ne bi oskrnavio svoje potomstvo među svojim narodom, jer ga ja, Gospod, posvećujem.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Gospod još reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","„Govori Aronu i reci mu: ’Neka niko od tvoga potomstva, uključujući i njihove buduće naraštaje, koji ima telesnu manu, ne pristupa da prinosi hleb svome Bogu. ");
INSERT INTO srponstl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Nijedan čovek sa telesnom manom ne sme pristupati: slepac, ili bogalj, ili ko ima oštećeno lice, ili neko izobličenje na telu; ");
INSERT INTO srponstl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","onaj ko ima slomljenu nogu ili ruku; ");
INSERT INTO srponstl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","grbavac, ili patuljastog rasta; onaj ko ima oštećeno oko, ili šugu, ili kakvo kožno oboljenje, ili ima zdrobljene mošnice. ");
INSERT INTO srponstl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Nijedan čovek iz Aronovog potomstva, koji ima telesnu manu, ne sme pristupati da prinosi paljenu žrtvu Gospodnju. Pošto ima telesnu manu, neka ne pristupa da prinosi hleb svoga Boga. ");
INSERT INTO srponstl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","On sme jesti hleb svoga Boga; ono što je najsvetije i sveto. ");
INSERT INTO srponstl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ipak, pošto ima telesnu manu, neka ne ulazi iza zavese, i neka ne pristupa žrtveniku, da ne bi oskrnavio moje Svetilište, jer ih ja, Gospod, posvećujem!’“ ");
INSERT INTO srponstl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Tako je Mojsije govorio Aronu, njegovim sinovima, i svim Izrailjcima. ");
INSERT INTO srponstl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","„Reci Aronu i njegovim sinovima da pažljivo postupaju sa posvećenim prilozima Izrailjaca, koje mi posvećuju, da ne bi oskrnavili moje sveto ime. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Reci im: ’Ako bilo ko od vaših potomaka, u svim vašim naraštajima, priđe posvećenim prinosima, koje Izrailjci posvećuju Gospodu, dok je nečist, neka se takav čovek istrebi preda mnom. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ako neko od Aronovih potomaka ima gubu ili izliv, neka ne jede od posvećenih prinosa dok se ne očisti. Ko god dotakne nešto što se onečistilo mrtvim telom, ili ima izliv semena, ");
INSERT INTO srponstl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ili dotakne kakvog gmizavca, pa postane nečist, ili dotakne čoveka i tako postane nečist – kakva god da je njegova nečistoća – ");
INSERT INTO srponstl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","čovek koji dotakne tako nešto, biće nečist do večeri. On ne sme jesti od posvećenih prinosa, dok ne opere telo u vodi. ");
INSERT INTO srponstl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Kad sunce zađe, biće čist. Nakon toga može da jede od posvećenih prinosa, jer to mu je hrana. ");
INSERT INTO srponstl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Neka ne jede crkotinu ili što je razderala zver, da se ne bi oskrnavio o nju. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Stoga neka čuvaju moj nalog, da ne navuku na sebe greh i ne umru radi njega, ukoliko se oskrnave. Ja sam Gospod koji ih posvećujem! ");
INSERT INTO srponstl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Neposvećeni neka ne jede posvećeni prinos. Posvećeni prinos ne smeju jesti ni gost sveštenikov ni njegov nadničar. ");
INSERT INTO srponstl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ali, ako sveštenik kupi nekoga novcem kao svojinu, taj može jesti prinos. Hleb smeju jesti i oni koji su rođeni u njegovom domu. ");
INSERT INTO srponstl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ako se sveštenikova ćerka uda za čoveka iz drugog plemena, ona ne sme jesti od svetih prinosa. ");
INSERT INTO srponstl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ako sveštenikova ćerka ostane udovica, ili je razvedena, a nema dece, pa se vrati u dom svoga oca, kao kad je bila mlada, ona sme da jede hleb svoga oca. Ipak, nijedan svetovnjak ne sme da jede. ");
INSERT INTO srponstl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Ako čovek nehotice pojede od svetog prinosa, neka da svešteniku nadoknadu za sveti prinos dodajući petinu njegove vrednosti. ");
INSERT INTO srponstl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Neka sveštenici ne skrnave posvećene prinose Izrailjaca, koje ih oni podižu Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Dopuštajući narodu da jede od njihovih prinosa, narod bi teretio greh koji zahteva nadoknadu, jer sam ja, Gospod, koji ih posvećuje.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","„Reci Aronu, njegovim sinovima, i svim Izrailjcima. Reci im: ’Ako neki čovek iz doma Izrailjeva, ili stranac koji boravi u Izrailju, žrtvuje prinos da se izvrši bilo kakav zavet, ili daje dragovoljni prilog, koji se prinosi Gospodu kao žrtva svespalnica – ");
INSERT INTO srponstl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","da bi bio primljen – mora prineti muško, bez mane, bilo to junac, ovca ili koza. ");
INSERT INTO srponstl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ne prinosite ništa što na sebi ima manu, jer vam to neće biti primljeno. ");
INSERT INTO srponstl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ako neko prinosi Gospodu žrtvu mira da izvrši zavet, ili daje dragovoljni prilog od krupne ili sitne stoke, neka bude bez mane da bi bilo primljeno; ne sme imati nikakav nedostatak. ");
INSERT INTO srponstl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ne prinosite Gospodu što je slepo, ili povređeno, ili osakaćeno, ili sa čirom, ili sa svrabom, ili sa šugom. Takvo ne stavljajte na žrtvenik da se prinese Gospodu kao paljena žrtva. ");
INSERT INTO srponstl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ipak, vola ili ovcu sa dužim ili kraćim udom možete prineti kao dobrovoljni prilog, ali to neće biti primljeno za zavet. ");
INSERT INTO srponstl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","A što ima nagnječene, zdrobljene, otkinute, ili odsečene mošnice, to ne prinosite Gospodu. Tako nešto nemojte činiti u svojoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Nijednu od ovih životinja ne primajte od stranca, da biste je prineli kao hranu svome Bogu, jer su osakaćene; na njima je mana, te vam to neće biti primljeno.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","„Kada se omlade muško tele, jagnje, ili koza, neka ostane sedam dana sa svojom majkom, a od osmoga dana pa naviše biće primljeno kao paljena žrtva Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ne koljite vola, ili ovcu, i njeno mlado u isti dan. ");
INSERT INTO srponstl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Kada prinosite Gospodu žrtvu zahvalnicu, prinesite je tako da vam bude primljena. ");
INSERT INTO srponstl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Neka se pojede istog dana; ništa ne ostavljajte do sledećeg jutra. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Čuvajte moje zapovedi i vršite ih. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ne skrnavite moje sveto ime, da bi moja svetost bila držana među narodom izrailjskim. Ja sam Gospod, koji vas posvećujem. ");
INSERT INTO srponstl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ja sam vas izveo iz egipatske zemlje, da bih vam bio Bog. Ja sam Gospod!“ ");
INSERT INTO srponstl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","„Govori narodu izrailjskom. Reci im: ’Ovo su Gospodnji praznici, kada ćete sazivati svete sabore. Ovo su moji praznici: ");
INSERT INTO srponstl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Šest dana radi, a sedmoga dana je subota potpunog odmora, sveti sabor. Ne radite nikakvog posla; neka Gospodnja subota bude po svim vašim mestima. ");
INSERT INTO srponstl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ovo su Gospodnji praznici, sveti sabori, koje ćeš proslavljati u određeno vreme: ");
INSERT INTO srponstl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Prvoga meseca, četrnaestog dana u mesecu, uveče, počinje Pasha Gospodnja. ");
INSERT INTO srponstl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","A petnaestoga dana istog meseca je Gospodnji praznik Beskvasnih hlebova. Jedite beskvasne hlebove sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Prvoga dana održavajte sveti sabor; ne radite nikakvog svakodnevnog posla. ");
INSERT INTO srponstl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Sedam dana prinosite Gospodu paljene žrtve. A sedmoga dana biće sveti sabor: ne radite nikakav posao.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","„Govori Izrailjcima. Reci im: ’Kad uđete u zemlju koju vam ja dajem, i počnete od nje žeti žetvu, prvi snop svoje žetve donesite svešteniku. ");
INSERT INTO srponstl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Tada neka on podigne snop pred Gospodom da budete primljeni. Sveštenik će ga podignuti narednog dana nakon subote. ");
INSERT INTO srponstl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Na dan kada podižete snop, prinesite jagnje od godinu dana, bez mane, kao žrtvu svespalnicu Gospodu, ");
INSERT INTO srponstl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","a uz njega desetinu efe brašna zamešenog s uljem, kao žitnu žrtvu. To je paljena žrtva, ugodni miris Gospodu. Uz njega ide i žrtva izlivnica od četvrtine hina vina. ");
INSERT INTO srponstl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Do tog dana, dok ne prinesete prinos svoga Boga, ne smete jesti hleb, prženo žito, ili sveže klasje. To je večna uredba za vaše naraštaje po svim vašim mestima. ");
INSERT INTO srponstl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Narednog dana nakon subote, pošto prinesete klas za žrtvu dizanicu, nabrojte sedam punih nedelja. ");
INSERT INTO srponstl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Nabrojte pedeset dana do prvoga dana nakon sedme subote, pa prinesite Gospodu žrtvu od novog žita. ");
INSERT INTO srponstl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Donesite iz svojih mesta dva hleba za žrtvu dizanicu, svaki od po dve desetine mere brašna. Neka budu pečeni s kvascem, kao prvina za Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Sa hlebom prinesite sedam jaganjaca bez mane, od godinu dana, jednog junca iz krda, i dva ovna, za žrtvu svespalnicu Gospodu, zajedno s njihovim žitnim žrtvama i žrtvama izlivnicama, kao paljenu žrtvu, ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Prinesite i jednog jarca kao žrtvu za greh, i dva jagnjeta od godinu dana, kao žrtvu mira. ");
INSERT INTO srponstl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Neka ih sveštenik podigne pred Gospodom s hlebom od prvina, kao žrtvu dizanicu, i sa ona dva jagnjeta. To je sveti prinos za Gospoda, koji sleduje svešteniku. ");
INSERT INTO srponstl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Istog dana sazovite sabor. Neka vam to bude sveti sabor. Ne radite nikakav svakodnevni posao! Ovo je trajna uredba za sve vaše naraštaje po svim vašim mestima. ");
INSERT INTO srponstl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Kad počnete žeti žetvu sa svoje zemlje, nemojte žeti do samog kraja svoga polja, niti pabirčiti posle svoje žetve. To ostavite siromahu i strancu. Ja sam Gospod, Bog vaš.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","„Govori Izrailjcima: ’Sedmoga meseca, prvoga dana u mesecu, neka vam bude potpuni počinak, spomen-dan objavljen glasom trube, sveti sabor. ");
INSERT INTO srponstl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ne radite nikakvog svakodnevnog posla. Prinesite Gospodu paljenu žrtvu.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","„A desetog dana sedmoga meseca je dan otkupljenja. Neka vam to bude sveti sabor. Postite i prinesite paljenu žrtvu Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ne radite nikakvog posla na taj dan, jer je to dan otkupljenja, kada će se izvršiti vaše otkupljenje pred Gospodom, Bogom vašim. ");
INSERT INTO srponstl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Onaj ko ne bude postio na ovaj dan, neka se istrebi iz svog naroda. ");
INSERT INTO srponstl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ko god se bude latio kakvog posla na ovaj dan, njega ću ja zatrti usred njegovog naroda. ");
INSERT INTO srponstl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ne radite nikakvog posla! To je trajna uredba za vaše naraštaje, po svim vašim mestima. ");
INSERT INTO srponstl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Neka vam to bude subota potpunog odmora. Postite! Proslavljajte svoju subotu od večeri devetog dana u mesecu do sledeće večeri.“ ");
INSERT INTO srponstl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","„Govori Izrailjcima: ’Petnaestog dana u sedmom mesecu je praznik Senica Gospodu, u trajanju od sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Prvoga dana je sveti sabor: ne radite nikakvog svakodnevnog posla. ");
INSERT INTO srponstl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Sedam dana prinosite Gospodu paljene žrtve, a osmoga dana neka vam bude sveti sabor. Tada ćete prinositi Gospodu paljene žrtve. To je svečani sabor; ne radite nikakvog posla. ");
INSERT INTO srponstl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","To su Gospodnji praznici, koje ćete slaviti kao svete sabore, prinoseći Gospodu paljene žrtve, žrtve svespalnice, žitne žrtve, prinose i žrtve izlivnice, svaku u određeni dan, ");
INSERT INTO srponstl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","osim Gospodnjih subota i vaših darova, i osim svih zaveta i dobrovoljnih priloga koje prinosite Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","A petnaestog dana u sedmom mesecu, kad prikupite prvine zemlje, sedam dana slavite Gospodnji praznik. Prvi i osmi dan neka budu dani potpunog odmora. ");
INSERT INTO srponstl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Na prvi dan uzmite najbolje plodove, palmove grane, grane s lisnatog drveća, i vrbe s potoka, pa se sedam dana veselite pred Gospodom, Bogom svojim. ");
INSERT INTO srponstl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Proslavljajte Gospodnji praznik sedam dana u godini. Ovo je trajna uredba za vaše naraštaje: slavite taj praznik sedmog meseca. ");
INSERT INTO srponstl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Živite u senicama sedam dana; svi rođeni u Izrailju neka žive u senicama, ");
INSERT INTO srponstl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","da bi vaši naraštaji znali da sam ja, Gospod, Bog vaš, učinio da narod izrailjski živi u senicama, kad sam ih izveo iz Egipta.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Tako je Mojsije saopštio Izrailjcima Gospodnje praznike. ");
INSERT INTO srponstl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","„Zapovedi Izrailjcima da ti donesu čistog, sveže isceđenog, maslinovog ulja za svećnjak, da svetlo stalno gori. ");
INSERT INTO srponstl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Neka ga Aron postavi u Šatoru od sastanka, izvan zavese Svedočanstva, da neprestano gori pred Gospodom, od večeri do jutra. To je trajna uredba za sve vaše naraštaje. ");
INSERT INTO srponstl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Neka Aron neprestano održava žiške na svećnjaku od čistog zlata pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Uzmi brašna i ispeci dvanaest pogača. Neka svaka pogača teži dve desetine efe. ");
INSERT INTO srponstl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Postavi ih u dva reda, po šest u svakom, na sto od čistog zlata pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Na svaki red stavi čistog tamjana, da hleb bude za spomen, paljenu žrtvu Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Neka ih Aron svake subote postavlja pred Gospodom, kao večni savez radi Izrailjaca. ");
INSERT INTO srponstl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Neka ih Aron i njegovi sinovi jedu na svetom mestu, jer je to najsvetiji deo od paljenih žrtava Gospodnjih. To je večna uredba.“ ");
INSERT INTO srponstl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","A sin jedne Izrailjke i Egipćanina, dođe među Izrailjce, i potuče se u taboru sa jednim Izrailjcem. ");
INSERT INTO srponstl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Međutim, sin te žene, Izrailjke, pogrdi ime Gospodnje proklinjući ga. Dovedu ga Mojsiju. Njegova majka se zvala Selomita, ćerka Davrijina, iz Danovog plemena. ");
INSERT INTO srponstl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Stavili su ga u pritvor, dok im se ne obznani Gospodnja odluka. ");
INSERT INTO srponstl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","„Izvedi izvan tabora bogohulnika, a svi koji su ga čuli neka polože ruke na njegovu glavu. Zatim neka ga cela zajednica kamenuje. ");
INSERT INTO srponstl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","A Izrailjcima reci: ’Ako neki čovek prokune svoga Boga, odgovaraće za svoj greh. ");
INSERT INTO srponstl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Onaj koji pogrdi ime Gospodnje, neka se svakako pogubi; neka ga cela zajednica zaspe kamenjem. Bio on stranac ili domaći, ako pogrdi ime Gospodnje, neka umre! ");
INSERT INTO srponstl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Ako neko oduzme život čoveku, neka se svakako pogubi. ");
INSERT INTO srponstl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ako neko usmrti živinče, neka plati odštetu: život za život. ");
INSERT INTO srponstl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ako neko nanese povredu svome bližnjemu, neka mu se uradi ono što je on uradio njemu. ");
INSERT INTO srponstl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Prelom za prelom, oko za oko, zub za zub. Kako je on drugome naneo povredu, tako neka se njemu nanese povreda. ");
INSERT INTO srponstl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ako neko ubije živinče, neka plati odštetu, a ko ubije čoveka, neka se pogubi. ");
INSERT INTO srponstl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Isti zakon važi za vas, kako za stranca, tako za domaćeg. Ja sam Gospod, Bog vaš.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Pošto je Mojsije saopštio Izrailjcima ovo, oni izvedu bogohulnika izvan tabora i zaspu ga kamenjem. Tako su Izrailjci učinili kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Gospod reče Mojsiju na gori Sinaj: ");
INSERT INTO srponstl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","„Govori Izrailjcima i reci im: ’Kad uđete u zemlju koju vam dajem, neka zemlja drži Gospodnju subotu. ");
INSERT INTO srponstl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Šest godina zasejavaj svoju njivu, i šest godina obrezuj svoj vinograd i sabiraj rod, ");
INSERT INTO srponstl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","a sedme godine neka bude subota potpunog odmora za zemlju, Gospodnja subota. Tada nemoj sejati svoju njivu i obrezivati svoj vinograd. ");
INSERT INTO srponstl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Nemoj žeti što sâmo rodi nakon tvoje žetve, niti brati grožđe od svoje neobrezane loze. To će biti godina subotnjeg odmora za zemlju. ");
INSERT INTO srponstl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Što zemlja rodi tokom svoje subote, to će vam biti za jelo. Sav njen urod neka bude za jelo tebi, tvome sluzi i tvojoj sluškinji; tvome najamniku, i došljaku koji boravi kod tebe; ");
INSERT INTO srponstl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","tvojoj stoci i zverima što žive na tvojoj zemlji. Sve što zemlja rodi, to se može jesti. ");
INSERT INTO srponstl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Nabroj sedam subotnjih godina, sedam puta po sedam godina, tako da ovih sedam subotnjih godina daju zbir od četrdeset devet godina. ");
INSERT INTO srponstl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Sedmoga meseca, desetoga dana, zapovedi da zatrubi truba; na dan otkupljenja, zatrubite u trube po svoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Posvetite pedesetu godinu, i proglasite slobodu u zemlji za sve njene stanovnike. To će vam biti oprosna godina. Tada neka se svaki od vas vrati na svoj posed, i svaki čovek neka se vrati u svoj rod. ");
INSERT INTO srponstl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Pedeseta godina neka vam bude oprosna. Ne sejte i ne žanjite što rodi nakon žetve, i ne obrezujte lozu, ");
INSERT INTO srponstl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","jer to je oprosna godina. Neka vam bude sveta: hranite se samo onim što rodi na njivi. ");
INSERT INTO srponstl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Te oprosne godine, neka se svaki čovek vrati na svoj posed. ");
INSERT INTO srponstl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Stoga, kada prodajete zemlju svome bližnjemu, ili je kupujete od njega, ne varajte svoga brata. ");
INSERT INTO srponstl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kad kupuješ od svoga bližnjega, platićeš samo za broj godina od oprosne godine; onaj ko prodaje naplatiće ti samo za ostatak žetvenih godina. ");
INSERT INTO srponstl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Što je više godina, to je veća cena; što je manje godina, to je manja cena, jer on ti prodaje broj žetvi. ");
INSERT INTO srponstl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ne varajte svog bližnjeg, nego se boj svoga Boga, jer ja sam Gospod, Bog vaš. ");
INSERT INTO srponstl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Vršite moje uredbe, i držite moje zakone. Vršite ih i živećete spokojno na zemlji. ");
INSERT INTO srponstl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Zemlja će davati svoj rod, pa ćete jesti do mile volje, i spokojno živeti u njoj. ");
INSERT INTO srponstl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ako se pitate: šta ćemo jesti sedme godine, kad ne budemo ni sejali, ni skupljali svoj urod? ");
INSERT INTO srponstl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Evo, ja ću vam poslati svoj blagoslov: šeste godine će zemlja roditi rod za tri godine. ");
INSERT INTO srponstl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","A kad budete sejali osme godine, hranićete se od starog uroda sve do devete godine, dok ne prispe njen urod. ");
INSERT INTO srponstl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Zemlja ne sme da se proda zauvek, jer zemlja pripada meni, a vi ste kod mene stranci i došljaci. ");
INSERT INTO srponstl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Gde god imate zemlju u posedu, morate dozvoliti da se zemlja otkupi. ");
INSERT INTO srponstl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ako tvoj brat osiromaši i proda svoj posed, neka dođe njegov najbliži rođak-staratelj i otkupi što je njegov brat prodao. ");
INSERT INTO srponstl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ko nema rođaka-staratelja, ali dođe do dovoljno sredstava da otkupi posed, ");
INSERT INTO srponstl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","neka izbroji godine od otkupa i isplati razliku čoveku kome ga je prodao. Onda neka se vrati na svoj posed. ");
INSERT INTO srponstl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","A ako nema dovoljno sredstava, posed će ostati u vlasništvu onoga koji ga je kupio do oprosne godine. U oprosnoj godini zemlja će biti vraćena, pa će se on vratiti na svoj posed. ");
INSERT INTO srponstl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Ako neko proda stambenu kuću u gradu opasanom zidinama, on može da je otkupi pre nego što istekne godina od njene prodaje. Rok za otkup biće jedna godina. ");
INSERT INTO srponstl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ako se kuća ne otkupi pre isteka pune godine, kuća u gradu opasanom zidinama preći će u trajno vlasništvo kupca i njegovih potomaka, te neće biti vraćena u oprosnoj godini. ");
INSERT INTO srponstl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Kuće po selima koje nisu ograđene zidinama, neka se vode kao njive; one se mogu otkupiti, ali se u oprosnoj godini moraju vratiti. ");
INSERT INTO srponstl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Međutim, Leviti će zauvek držati pravo otkupa kuća koje poseduju u levitskim gradovima. ");
INSERT INTO srponstl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ako jedan od Levita otkupi kuću, koja je prodana u jednom od gradova u njihovom posedu, ona mora da se vrati u oprosnoj godini, jer su kuće po levitskim gradovima njihovo vlasništvo među Izrailjcima. ");
INSERT INTO srponstl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Pašnjaci oko ovih gradova ne smeju se prodavati, jer to je njihovo vlasništvo za sva vremena. ");
INSERT INTO srponstl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Ako tvoj brat, koji živi uz tebe, osiromaši, te ne može da se izdržava, pomozi mu; neka živi uz tebe kao stranac ili došljak. ");
INSERT INTO srponstl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ne uzimaj kamatu od njega, i ne naplaćuj mu više, nego se boj svoga Boga. Neka tvoj brat živi uz tebe. ");
INSERT INTO srponstl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ne pozajmljuj mu novac s kamatom, i ne naplaćuj mu više za hranu. ");
INSERT INTO srponstl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ja sam Gospod, Bog vaš, koji sam vas izveo iz Egipta, da vam dam hanansku zemlju, i da vam budem Bog. ");
INSERT INTO srponstl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Ako osiromaši tvoj brat koji je uz tebe, i proda se tebi, ne teraj ga da radi kao rob. ");
INSERT INTO srponstl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Neka bude kod tebe kao najamnik i kao došljak, pa neka služi kod tebe do oprosne godine. ");
INSERT INTO srponstl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Tada može da ode od tebe sa svojom decom, i da se vrati u svoj rod i na posed svojih predaka. ");
INSERT INTO srponstl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Zato što su moje sluge koje sam izveo iz Egipta, ne smeju se prodavati kao što se prodaju robovi. ");
INSERT INTO srponstl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Nemoj gospodariti nemilosrdno nad njim, nego se boj svoga Boga. ");
INSERT INTO srponstl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Robove i robinje možete imati, ali od naroda koji žive oko vas. Njih možete kupovati kao robove i robinje. ");
INSERT INTO srponstl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Možete kupovati i decu došljaka i stranaca, koji žive među vama, ili one koji su rođeni u vašoj zemlji, i čije porodice žive među vama. Oni mogu da budu vaše vlasništvo. ");
INSERT INTO srponstl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Možete ih zadržati u vlasništvu za vašu decu posle vas, da ih naslede kao trajno vlasništvo. Oni neka vam služe kao robovi, ali nad vašom braćom Izrailjcima, niko da ne gospodari nemilosrdno. ");
INSERT INTO srponstl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Ako se stranac ili došljak obogati, a tvoj brat osiromaši, pa se proda strancu ili došljaku među vama, ili potomku iz strančevog roda, ");
INSERT INTO srponstl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","on ima pravo da bude otkupljen i nakon što se prodao. Neka ga otkupi neko od njegove braće, ");
INSERT INTO srponstl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ili neka ga otkupi stric, ili stričev sin, ili neko od najbliže porodice. Ukoliko se obogati, on može da otkupi samog sebe. ");
INSERT INTO srponstl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Neka s kupcem izračuna vreme od godine kada se prodao, pa do oprosne godine; cena za koju se prodao određivaće se prema broju godina. Vreme koje je proveo s vlasnikom neka mu se računa kao najamniku. ");
INSERT INTO srponstl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ako ostane još mnogo godina, on će, prema njihovom broju, platiti cenu za svoj otkup. ");
INSERT INTO srponstl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ako ostane malo godina do oprosne godine, on će platiti za svoj otkup prema njihovom broju. ");
INSERT INTO srponstl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Vreme koje je proveo s vlasnikom, neka mu se računa kao najamniku. Neka se ne gospodari nemilosrdno nad njim na tvoje oči. ");
INSERT INTO srponstl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ukoliko ne bude otkupljen ovako, on i njegova deca biće oslobođeni u oprosnoj godini. ");
INSERT INTO srponstl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Jer Izrailjci su moje sluge, koje sam izveo iz Egipta. Ja sam Gospod, Bog vaš! ");
INSERT INTO srponstl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ne pravite sebi ništavne idole, i ne podižite stubove, i ne postavljajte likove od kamena po svojoj zemlji da im se klanjate, jer ja sam Gospod, Bog vaš! ");
INSERT INTO srponstl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Držite moje subote i poštujte moje Svetilište. Ja sam Gospod! ");
INSERT INTO srponstl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ako budete sledili moje propise i verno držali i vršili moje zapovesti, ");
INSERT INTO srponstl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ja ću vam davati kišu u pravo vreme, pa će vam zemlja davati svoj rod, i stabla na polju rađati svoje plodove. ");
INSERT INTO srponstl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Vršidba će vam stizati berbu grožđa, a berba grožđa stizati setvu, pa ćete jesti svoj hleb i biti siti, i živeti spokojno u svojoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","I daću mir u zemlji, pa ćete odlaziti na počinak, i niko vas neće plašiti. Ja ću dati odmor zemlji od krvoločnih zveri, a mač neće prelaziti preko vaše zemlje. ");
INSERT INTO srponstl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Progonićete svoje neprijatelje, a oni će padati pred vama od mača. ");
INSERT INTO srponstl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Vaša će petorica terati stotinu, a vaših stotinu teraće deset hiljada. Neprijatelji vaši padaće pred vama od mača. ");
INSERT INTO srponstl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Okrenuću se k vama i učiniti vas rodnim i brojnim, te učvrstiti svoj savez s vama. ");
INSERT INTO srponstl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Hranićete se žitom iz starih zaliha, ali ćete izbacivati staro žito da napravite mesto za novo. ");
INSERT INTO srponstl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ja ću postaviti svoje Prebivalište među vama, i nećete mi biti mrski. ");
INSERT INTO srponstl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Hodiću među vama i biću vam Bog, a vi ćete biti moj narod. ");
INSERT INTO srponstl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ja sam Gospod, Bog vaš, koji vas je izveo iz Egipta, da im više ne budete robovi. Slomio sam prečage vašeg jarma, i učinio da uspravno hodate. ");
INSERT INTO srponstl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ali ako me ne poslušate, i ne budete vršili sve ove zapovesti, ");
INSERT INTO srponstl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","nego prezrete moje uredbe, i odbacite moje zakone; ako, dakle, ne budete izvršavali sve moje zapovesti, nego raskinete moj savez, ");
INSERT INTO srponstl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ovo ću učiniti s vama: dovešću na vas užas, bolest i groznicu, od koje se gubi vid, i gasi život. Sejaćete uzalud, jer će vam setvu pojesti vaši neprijatelji. ");
INSERT INTO srponstl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ja ću se okrenuti protiv vas, i vaši će vas neprijatelji tući, te će vaši dušmani zavladati nad vama. Bežaćete i kad vas niko ne bude gonio. ");
INSERT INTO srponstl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Ako me ni tada ne poslušate, kazniću vas sedam puta više za vaše grehe. ");
INSERT INTO srponstl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Skršiću snagu kojom se ponosite, i učiniću da nebo nad vama bude kao gvožđe, a zemlja pod vama kao bronza. ");
INSERT INTO srponstl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Uzalud ćete trošiti snagu, jer vam zemlja neće davati uroda, a drveće u zemlji neće rađati svoje plodove. ");
INSERT INTO srponstl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Ako mi se dalje budete protivili, i ne budete hteli da me slušate, umnožiću vaše rane sedam puta više za vaše grehe. ");
INSERT INTO srponstl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Poslaću i divlje zveri, koje će vas ostaviti bez dece, i istrebiti vašu stoku. One će vas desetkovati, tako da će opusteti vaši putevi. ");
INSERT INTO srponstl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Ako uprkos ovome odbijete moju stegu, i nastavite da mi se protivite, ");
INSERT INTO srponstl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ustaću protiv vas i udariti vas sedam puta gore za vaše grehe. ");
INSERT INTO srponstl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Dovešću na vas mač da izvrši osvetu za savez. Ako se povučete u svoje gradove, poslaću zarazu među vas, pa ćete biti izručeni u ruke neprijatelja. ");
INSERT INTO srponstl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Kad vam prekinem snabdevanje hlebom, deset će žena peći hleb u jednoj peći. Deliće vam hleb na meru; ješćete, ali se nećete nasititi. ");
INSERT INTO srponstl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Ako me ni tada ne poslušate, nego nastavite da mi se protivite, ");
INSERT INTO srponstl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","u svom ću se gnevu okrenuti protiv vas, i sedmostruko vas kazniti za vaše grehe. ");
INSERT INTO srponstl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ješćete meso svojih sinova i meso svojih ćerki. ");
INSERT INTO srponstl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","A ja ću uništiti vaše žrtvene bregove i poseći vaše stubove u čast sunca. Vaše ću leševe naslagati na vaše beživotne idole, i gadićete se mojoj duši. ");
INSERT INTO srponstl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Pretvoriću vaše gradove u ruševine, i opustošiću vaša svetilišta. Vaš kad mirisni više neću mirisati. ");
INSERT INTO srponstl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ja ću opustošiti zemlju, da će se nad njom zaprepastiti i vaši neprijatelji, koji će živeti u njoj. ");
INSERT INTO srponstl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","A vas ću rasejati po narodima; isukaću mač protiv vas, pa će vam zemlja opusteti, a vaši gradovi ležati u ruševinama. ");
INSERT INTO srponstl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","U to vreme, kad budete u zemlji svojih neprijatelja, zemlja će uživati u svojim subotama za sve vreme dok je pusta. Tada će zemlja počivati i uživati u svojim subotama. ");
INSERT INTO srponstl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Dokle god je pusta, ona će počivati, jer nije počivala tokom vaših subota, dok ste vi živeli u njoj. ");
INSERT INTO srponstl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","A preživelima od vas uteraću strah u kosti u zemlji njihovih neprijatelja; nagnaće ih u beg i šušanj lista kada se zaljulja. Bežaće kao gonjeni mačem; padaće iako ih niko neće progoniti. ");
INSERT INTO srponstl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","I saplitaće se jedan o drugoga, kao gonjeni mačem, iako ih niko neće progoniti. Tako se nećete moći održati pred svojim neprijateljima. ");
INSERT INTO srponstl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Propašćete među narodima; progutaće vas zemlja vaših neprijatelja. ");
INSERT INTO srponstl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","A preživeli među vama usahnuće u zemlji svojih neprijatelja zbog svojih krivica, i zbog krivica svojih predaka. ");
INSERT INTO srponstl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ali ako priznaju svoje krivice, i krivice svojih predaka – njihovog neverstva kojim su zgrešili protiv mene, ");
INSERT INTO srponstl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","zbog čega sam im se suprotstavio i odveo ih u zemlju njihovih neprijatelja; ako se tada ponizi njihovo neobrezano srce i plate za svoje krivice, ");
INSERT INTO srponstl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","setiću se svog saveza sa Jakovom, i svog saveza sa Isakom, i svog saveza sa Avrahamom, i setiću se zemlje. ");
INSERT INTO srponstl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Jer zemlja će im biti napuštena, pa će uživati svoje subote kad opusti bez njih. A oni će platiti za svoje krivice, zato što su prezreli moje zakone, i odbacili moje uredbe. ");
INSERT INTO srponstl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Pa i kad ih ovo snađe u zemlji njihovih neprijatelja, ja ih neću prezreti, niti će mi postati toliko mrski, da bih ih dokrajčio, i raskinuo svoj savez sa njima, jer ja sam Gospod, Bog njihov. ");
INSERT INTO srponstl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Radi njih ću se setiti saveza sa njihovim ocima koje sam izveo iz Egipta na oči naroda, da im budem Bog. Ja sam Gospod!’“ ");
INSERT INTO srponstl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ovo su uredbe, propisi i zakoni, koje je Gospod ustanovio između sebe i Izrailjaca na gori Sinaj preko Mojsija. ");
INSERT INTO srponstl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","„Govori Izrailjcima i reci im: ’Ako neko zavetuje Gospodu osobu, ali hoće da se otkupi, ovako ćeš vršiti procenu: ");
INSERT INTO srponstl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","muškarca između dvadeset i šezdeset godina starosti proceni na pedeset srebrnih šekela prema hramskom šekelu. ");
INSERT INTO srponstl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ako se radi o ženi proceni je na trideset šekela. ");
INSERT INTO srponstl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Muško između pet i dvadeset godina starosti proceni na dvadeset srebrnih šekela, a žensko na deset šekela. ");
INSERT INTO srponstl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Muško između mesec dana i pet godina starosti proceni na pet srebrnih šekela, a žensko na tri srebrna šekela. ");
INSERT INTO srponstl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Muško od šezdeset godina i starije proceni na petnaest šekela, a žensko na deset šekela. ");
INSERT INTO srponstl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ukoliko osoba ne može da plati procenjenu vrednost, neka dođe k svešteniku, koji će ga proceniti; sveštenik će proceniti onoga koji čini zavet prema njegovim mogućnostima. ");
INSERT INTO srponstl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ako neko donosi živinče kao prinos Gospodu, što god se daje Gospodu, sveto je. ");
INSERT INTO srponstl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Dobro živinče se ne sme nadomestiti, niti zameniti za loše, ili loše živinče za dobro. Ako se jedno živinče zameni drugim, tada će i zavetovano i zamenjeno biti sveto. ");
INSERT INTO srponstl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ako je živinče nečisto, te nije od onih koje se mogu prineti Gospodu, neka ga donese pred sveštenika. ");
INSERT INTO srponstl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Neka ga sveštenik proceni prema tome da li je dobro ili loše. Kakvu mu vrednost sveštenik odredi, tako će biti. ");
INSERT INTO srponstl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ako vlasnik hoće da ga otkupi, neka doda jednu petinu na procenjenu vrednost. ");
INSERT INTO srponstl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Ako neko zavetuje svoju kuću Gospodu, neka sveštenik proceni kuću prema tome da li je dobra ili loša. Kakvu mu vrednost sveštenik odredi, tako će biti. ");
INSERT INTO srponstl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ukoliko onaj koji zavetuje svoju kuću hoće da je otkupi, neka doda jednu petinu na procenjeni iznos, i biće njegova. ");
INSERT INTO srponstl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Ako neko zavetuje Gospodu jednu njivu od svog porodičnog imanja, proceni je prema količini semena koje ide u setvu: za jedan homer ječmenog semena pedeset srebrnih šekela. ");
INSERT INTO srponstl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ako zavetuje svoju njivu u oprosnoj godini, procenjena vrednost ostaje ista. ");
INSERT INTO srponstl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ako svoju njivu zavetuje nakon oprosne godine, sveštenik će proračunati cenu prema broju godina koje preostaju do naredne oprosne godine, pa će se njena procenjena vrednost srazmerno umanjiti. ");
INSERT INTO srponstl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ako onaj koji zavetuje njivu poželi da je otkupi, neka doda jednu petinu na procenjenu vrednost, i biće njegova. ");
INSERT INTO srponstl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","U slučaju da ne otkupi njivu, nego je proda drugome, više je ne može otkupiti. ");
INSERT INTO srponstl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kad njiva bude oslobođena u oprosnoj godini, neka bude posvećena kao njiva zavetovana Gospodu i postane sveštenikova imovina. ");
INSERT INTO srponstl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Ako neko zavetuje Gospodu njivu koju je kupio, ali nije deo njegovog porodičnog imanja, ");
INSERT INTO srponstl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","neka sveštenik proračuna njenu vrednost prema proceni do oprosne godine, i neka istoga dana isplati procenjeni iznos kao stvar posvećenu Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","U oprosnoj godini njiva će se vratiti onome od koga ju je kupio; onome koji drži njivu u posedu. ");
INSERT INTO srponstl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Svaka procena će se vršiti prema hramskom šekelu: u jednom šekelu ima dvadeset gera. ");
INSERT INTO srponstl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Prvina stoke, pošto je prvina, pripada Gospodu, i zato se ne može zavetovati. Bilo vo ili ovca, ono pripada Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ako je to jedna od nečistih životinja, ona se može otkupiti po procenjenoj vrednosti dodavši petinu cene. Ako se ne otkupi, neka se proda po procenjenoj vrednosti. ");
INSERT INTO srponstl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Šta god neko ima, pa zavetom posveti Gospodu, bilo to osoba, živinče, ili njiva na porodičnom imanju, ne sme se prodati, niti otkupiti. Sve što je zavetom posvećeno, najsvetije je Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Nijedna osoba, koja je određena za kleto uništenje, ne sme se otkupiti: mora svakako da se pogubi. ");
INSERT INTO srponstl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Desetak od svakog zemaljskog semena i od plodova sa stabala pripada Gospodu: to je sveto Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ako neko hoće da otkupi deo svog desetka, neka doda na to petinu cene. ");
INSERT INTO srponstl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Desetak od sve krupne i sitne stoke, svako deseto od onog što prolazi ispod pastirskog štapa, neka bude sveto Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Neka niko ne ispituje je li dobro ili loše, i neka se ne zamenjuje. A ako se zameni, tada će i prvo i zamenjeno biti sveto; ne sme se otkupiti.’“ ");
INSERT INTO srponstl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ovo su zapovesti koje je Gospod dao Mojsiju za Izrailjce na Sinajskoj gori.");
INSERT INTO srponstl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Prvoga dana drugoga meseca, druge godine nakon što su izašli iz Egipta, Gospod reče Mojsiju u Sinajskoj pustinji, u Šatoru od sastanka: ");
INSERT INTO srponstl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","„Izvršite popis sve zajednice sinova Izrailjevih po njihovim porodicama i njihovim otačkim domovima, prema broju imena svih muškaraca, jednog po jednog. ");
INSERT INTO srponstl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Ti i Aron zabeležite sve u Izrailju po njihovim jedinicama, od dvadeset godina pa naviše, koji su sposobni za vojsku. ");
INSERT INTO srponstl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","S vama će biti po jedan čovek iz svakog plemena, koji je glavar svog otačkog doma. ");
INSERT INTO srponstl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ovo su imena ljudi koji će vam pomagati: za Ruvimovo pleme, Elisur, Sedijurov sin; ");
INSERT INTO srponstl_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","za Simeunovo pleme, Surisadajev sin Salamilo; ");
INSERT INTO srponstl_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","za Judino pleme, Aminadavov sin Nason; ");
INSERT INTO srponstl_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","za Isaharovo pleme, Sogarov sin Natanailo, ");
INSERT INTO srponstl_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Za Zavulonovo pleme, Helonov sin Elijav. ");
INSERT INTO srponstl_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Za Josifove sinove: Amijudov sin Elisama, za Jefremovo pleme, i Fadasurov sin Gamalilo, za Manasijino pleme. ");
INSERT INTO srponstl_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Za Venijaminovo pleme, Gadeonijev sin Avidan; ");
INSERT INTO srponstl_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","za Danovo pleme, Amisadajev sin Ahijezer; ");
INSERT INTO srponstl_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","za Asirovo pleme, Ehranov sin Fagailo; ");
INSERT INTO srponstl_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","za Gadovo pleme, Deuelov sin Elisaf; ");
INSERT INTO srponstl_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","za Neftalimovo pleme, Enanov sin Ahirej.“ ");
INSERT INTO srponstl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ovi su bili izabrani od zajednice, knezovi svojih otačkih plemena, glavari Izrailjevih hiljada. ");
INSERT INTO srponstl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mojsije i Aron su uzeli ove ljude koji su bili određeni po imenu, ");
INSERT INTO srponstl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","pa su sabrali svu zajednicu prvoga dana drugog meseca. Oni su se, jedan po jedan, upisali u svoja rodoslovlja, po svojim porodicama, po svojim otačkim domovima, i po svojim imenima, od dvadeset godina pa naviše, ");
INSERT INTO srponstl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","kao što je Gospod zapovedio Mojsiju. Tako ih je popisao u Sinajskoj pustinji. ");
INSERT INTO srponstl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Od potomaka Ruvima, Izrailjevog prvenca, pojedinačno su bili popisani svi muškarci od dvadeset godina pa naviše, sposobni za vojsku, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Iz Ruvimovog plemena bilo je popisano četrdeset šest hiljada pet stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Od Simeunovih potomaka, pojedinačno su bili popisani svi muškarci sposobni za vojsku od dvadeset godina pa naviše, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Iz Simeunovog plemena bilo je popisano pedeset devet hiljada tri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Od Gadovih potomaka, pojedinačno su bili popisani svi muškarci sposobni za vojsku od dvadeset godina pa naviše, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Iz Gadovog plemena bilo je popisano četrdeset pet hiljada šest stotina pedeset. ");
INSERT INTO srponstl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Od Judinih potomaka, pojedinačno su bili popisani svi muškarci sposobni za vojsku od dvadeset godina pa naviše, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Iz Judinog plemena bilo je popisano sedamdeset četiri hiljade šest stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Od Isaharovih potomaka, pojedinačno su bili popisani svi muškarci od dvadeset godina pa naviše, sposobni za vojsku, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Iz Isaharovog plemena bilo je popisano pedeset četiri hiljade četiri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Od Zavulonovih potomaka, pojedinačno su bili popisani svi muškarci od dvadeset godina pa naviše, sposobni za vojsku, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Iz Zavulonovog plemena bilo je popisano pedeset sedam hiljada četiri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Od Josifovih potomaka: od Jefremovih potomaka, pojedinačno su bili popisani svi muškarci od dvadeset godina pa naviše, sposobni za vojsku, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Iz Jefremovog plemena bilo je popisano četrdeset hiljada pet stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Od Manasijinih potomaka, pojedinačno su bili popisani svi muškarci od dvadeset godina pa naviše sposobni za vojsku, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Iz Manasijinog plemena bilo je popisano trideset dve hiljade dve stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Od Venijaminovih potomaka, pojedinačno su bili popisani svi muškarci od dvadeset godina pa naviše, sposobni za vojsku, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Iz Venijaminovog plemena bilo je popisano trideset pet hiljada četiri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Od Danovih potomaka, pojedinačno su bili popisani svi muškarci od dvadeset godina pa naviše, sposobni za vojsku, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Iz Danovog plemena bilo je popisano šezdeset dve hiljade sedam stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Od Asirovih potomaka, pojedinačno su bili popisani svi muškarci od dvadeset godina pa naviše, sposobni za vojsku, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Iz Asirovog plemena bilo je popisano četrdeset jedna hiljada pet stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Od Neftalimovih potomaka, pojedinačno su bili popisani svi muškarci od dvadeset godina pa naviše, sposobni za vojsku, po svojim rodoslovima, po svojim porodicama i svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Iz Neftalimovog plemena bilo je popisano pedeset tri hiljade četiri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ovi popisani su bili oni koje je popisao Mojsije sa Aronom, uz pomoć dvanaest knezova, po jedan čovek na svaki otački dom. ");
INSERT INTO srponstl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Svi Izrailjci, koji su bili upisani u svoje otačke domove, od dvadeset godina pa naviše, bili su sposobni za vojsku u Izrailju. ");
INSERT INTO srponstl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Svih popisanih bilo je šest stotina tri hiljade pet stotina pedeset. ");
INSERT INTO srponstl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ipak, među njih se nisu vodili Leviti prema svom predačkom plemenu. ");
INSERT INTO srponstl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Naime, Gospod je rekao Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","„Neka se Levijevo pleme ne popisuje, i neka se ne popisuju sa ostalim Izrailjcima. ");
INSERT INTO srponstl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Nego, postavi Levite nad Prebivalištem svedočanstva, i nad svom opremom i svim što mu pripada. Oni će nositi Prebivalište sa svom opremom, služiti u njemu, i logorovati oko Prebivališta. ");
INSERT INTO srponstl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kad Prebivalište krene, neka ga Leviti rastave, a kad se Prebivalište zaustavi, neka ga Leviti podignu. Ako mu se približi tuđinac, neka se pogubi. ");
INSERT INTO srponstl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Ostali Izrailjci neka logoruju svaki u svome taboru, kod svoje zastave, i po svojim četama. ");
INSERT INTO srponstl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Leviti neka logoruju oko Prebivališta svedočanstva, da ne bi planuo gnev na izrailjsku zajednicu. Zato neka čuvaju stražu kod Prebivališta svedočanstva.“ ");
INSERT INTO srponstl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Izrailjci učine sve onako kako je Gospod zapovedio Mojsiju. Baš tako su učinili. ");
INSERT INTO srponstl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","„Neka Izrailjci logoruju svaki kod svoje zastave, pod grbom svoga očinskog doma. Neka se utabore oko Šatora od sastanka, ali podalje.“ ");
INSERT INTO srponstl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","S prednje strane, prema istoku, biće Judin tabor po svojim četama i pod svojom zastavom. Knez Judejaca je Nason, sin Aminadavov. ");
INSERT INTO srponstl_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Njegova vojska broji sedamdeset četiri hiljade šest stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Do njega će logorovati Isaharovo pleme. Knez Isaharovih potomaka je Natanailo, sin Sogarov. ");
INSERT INTO srponstl_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Njegova vojska broji pedeset četiri hiljade četiri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Zatim Zavulonovo pleme s knezom Zavulonovih potomaka Elijavom, sinom Helonovim. ");
INSERT INTO srponstl_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Njegova vojska broji pedeset sedam hiljada četiri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ukupan broj popisanih u Judinom taboru, po njihovim četama, bio je stotinu osamdeset šest hiljada četiri stotine. Neka oni prvi polaze. ");
INSERT INTO srponstl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Na jugu će biti zastava Ruvimovog tabora po svojim četama. Knez Ruvimovih potomaka je Elisur, sin Sedijurov. ");
INSERT INTO srponstl_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Njegova vojska broji četrdeset šest hiljada pet stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Do njega neka logoruje Simeunovo pleme. Knez Simeunovih potomaka je Salamilo, sin Surisadajev. ");
INSERT INTO srponstl_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Njegova vojska broji pedeset devet hiljada tri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Onda Gadovo pleme. Knez Gadovih potomaka je Elisaf, sin Raguilov. ");
INSERT INTO srponstl_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Njegova vojska broji četrdeset pet hiljada šest stotina pedeset. ");
INSERT INTO srponstl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ukupan broj popisanih po njihovim četama u Gadovom taboru bio je stotinu pedeset jedna hiljada četiri stotine pedeset. Oni neka polaze drugi. ");
INSERT INTO srponstl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Zatim neka krene Šator od sastanka, pošto se Levijev tabor nalazi usred drugih tabora. Svaki će poći prema mestu taborovanja, i pod svojom zastavom. ");
INSERT INTO srponstl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Na zapadu će biti zastava Jefremovog tabora po svojim četama. Knez Jefremovih potomaka je Elisama, sin Amijudov. ");
INSERT INTO srponstl_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Njegova vojska je brojila četrdeset hiljada pet stotina popisanih. ");
INSERT INTO srponstl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Do njega će biti Manasijino pleme. Knez Manasijinih potomaka je Gamalilo, sin Fadasurov. ");
INSERT INTO srponstl_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Njegova vojska broji trideset dve hiljade dve stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Potom sledi Venijaminovo pleme. Knez Venijaminovih potomaka je Avidan, sin Gadeonijev. ");
INSERT INTO srponstl_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Njegova vojska broji trideset pet hiljada četiri stotine popisanih. ");
INSERT INTO srponstl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ukupan broj popisanih u Jefremovom taboru po njihovim četama, bio je stotinu osam hiljada i stotinu. Oni neka polaze treći. ");
INSERT INTO srponstl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Na severu će biti zastava Danovog tabora po svojim četama. Knez Danovih potomaka je Ahijezer, sin Amisadajev. ");
INSERT INTO srponstl_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Njegova vojska broji šezdeset dve hiljade sedam stotina popisanih. ");
INSERT INTO srponstl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Do njega neka se utabori Asirovo pleme. Knez Asirovih potomaka je Fagailo, sin Ehranov. ");
INSERT INTO srponstl_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Njegova vojska broji četrdeset jednu hiljadu pet stotina popisanih. ");
INSERT INTO srponstl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Zatim sledi Neftalimovo pleme. Knez Neftalimovih potomaka je Ahirej, sin Enanov. ");
INSERT INTO srponstl_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Njegova vojska broji pedeset tri hiljade četiri stotine popisanih. ");
INSERT INTO srponstl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Ukupan broj popisanih u Danovom taboru, bio je stotinu pedeset sedam hiljada šest stotina. Oni neka kreću poslednji pod svojim zastavama. ");
INSERT INTO srponstl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","To su Izrailjci koji su popisani prema svojim otačkim domovima. Ukupan broj popisanih u taborima po njihovim četama je šest stotina tri hiljade pet stotina pedeset. ");
INSERT INTO srponstl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Leviti nisu bili popisani sa ostalim Izrailjcima, kao što je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Tako su Izrailjci izvršili sve što je Gospod zapovedio Mojsiju: tako su logorovali pod svojim zastavama i tako išli, svako prema svom rodu i otačkom domu. ");
INSERT INTO srponstl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ovo su Aronovi i Mojsijevi rodoslovi, iz vremena kad je Gospod govorio Mojsiju na Sinajskoj gori. ");
INSERT INTO srponstl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ovo su imena Aronovih sinova: prvenac Nadav, Avijud, Eleazar i Itamar. ");
INSERT INTO srponstl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","To su imena Aronovih sinova koji su bili pomazani i uvedeni u svešteničku službu. ");
INSERT INTO srponstl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Međutim, Nadav i Avijud su poginuli pred Gospodom, kad su prineli tuđi oganj pred Gospodom u Sinajskoj pustinji. A pošto nisu imali sinova, svešteničku službu su obavljali Eleazar i Itamar, pod svojim ocem Aronom. ");
INSERT INTO srponstl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","„Dovedi Levijevo pleme i postavi ga pred sveštenikom Aronom, pa neka mu služe. ");
INSERT INTO srponstl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Neka obavljaju dužnosti za njega i za svu zajednicu pred Šatorom od sastanka, dok služe u Prebivalištu. ");
INSERT INTO srponstl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Neka se staraju za sav nameštaj u Šatoru od sastanka, i brinu se za Izrailjce, dok služe u Prebivalištu. ");
INSERT INTO srponstl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Daj Levite Aronu i njegovim sinovima; oni su mu dodeljeni među Izrailjcima. ");
INSERT INTO srponstl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","A Arona i njegove sinove postavi da vrše svoju svešteničku službu. Ako tuđinac pristupi, neka se pogubi.“ ");
INSERT INTO srponstl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","„Ja sam, evo, uzeo Levite od Izrailjaca umesto svih prvenaca, koji su prvi plod utrobe među Izrailjcima. Leviti su moji! ");
INSERT INTO srponstl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Jer, moji su svi prvenci. Onoga dana kad sam pobio sve prvence u Egiptu, sebi sam posvetio svakog prvenca u Izrailju, i od ljudi i od stoke, da budu moji. Ja sam Gospod!“ ");
INSERT INTO srponstl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Gospod reče Mojsiju u Sinajskoj pustinji: ");
INSERT INTO srponstl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","„Popiši Levite prema njihovim otačkim domovima i rodovima; popiši svako muško od jednog meseca pa naviše.“ ");
INSERT INTO srponstl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Mojsije ih je popisao kako mu je bilo zapoveđeno po reči Gospodnjoj. ");
INSERT INTO srponstl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ovo su bili Leviti po svojim imenima: Girson, Kat i Merarije. ");
INSERT INTO srponstl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","A ovo su imena Girsonovih sinova po njihovim rodovima: Lovenije i Semaj. ");
INSERT INTO srponstl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Katovi sinovi po svojim rodovima su: Amram, Isar, Hevron i Ozilo. ");
INSERT INTO srponstl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merarijevi sinovi po svojim rodovima su: Molija i Musije. To su levitski rodovi po svojim otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Od Girsona potiču Lovenijev rod i Semajev rod. To su Girsonovi rodovi. ");
INSERT INTO srponstl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Broj svih popisanih muškaraca, od mesec dana pa naviše, bio je sedam hiljada pet stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Girsonovi rodovi su logorovali na zapadu, iza Prebivališta. ");
INSERT INTO srponstl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Knez otačkog doma Girsonovih rodova bio je Elisaf, sin Lailov. ");
INSERT INTO srponstl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Girsonovci su u Šatoru od sastanka bili zaduženi za Prebivalište, Šator i njegov pokrivač, i zavesu na ulazu od Šatora od sastanka; ");
INSERT INTO srponstl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","dvorišne zastore, zavesu na ulazu od dvorišta oko Prebivališta i žrtvenika, i njegovu užad, i za svaku njihovu službu. ");
INSERT INTO srponstl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Od Kata potiče Amramov, Isarov, Hevronov i Ozilov rod. To su Katovi rodovi. ");
INSERT INTO srponstl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ukupan broj svih muškaraca od jednog meseca pa naviše, bio je osam hiljada šest stotina. Oni su se starali za Svetinju. ");
INSERT INTO srponstl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Katovi rodovi su logorovali s južne strane Prebivališta. ");
INSERT INTO srponstl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Knez Katovih otačkih domova bio je Elisafan, sin Ozilov. ");
INSERT INTO srponstl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Oni su se brinuli za Kovčeg, sto, svećnjak, žrtvenike, za posuđe u Svetinji koje se koristilo pored ovih, zavesu, i za svaku hramsku službu. ");
INSERT INTO srponstl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Vrhovni starešina nad Levitima bio je Eleazar, sin sveštenika Arona. On je nadgledao one koji su se brinuli za Svetinju. ");
INSERT INTO srponstl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Od Merarija potiče rod Molijev i rod Musijev. To su Merarijevi rodovi. ");
INSERT INTO srponstl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Broj svih popisanih muškaraca, od jednog meseca pa naviše, bio je šest hiljada dve stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Knez otačkih domova u Merarijevim rodovima bio je Surilo, sin Avihejev. Oni su logorovali sa severne strane Prebivališta. ");
INSERT INTO srponstl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Dužnost Merarijevih sinova bila je da se brinu za daske Prebivališta, za njegove prevornice, stubove, podnožja, za sve posuđe i za svaku njihovu službu, ");
INSERT INTO srponstl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","kao i za stubove oko dvorišta, sa njihovim postoljima, kočićima i konopcima. ");
INSERT INTO srponstl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","S prednje strane Prebivališta, pred Šatorom od sastanka s istoka, logorovali su Mojsije, Aron i njegovi sinovi. Oni su vršili dužnosti u Svetilištu za Izrailjce. Svaki tuđinac koji bi pristupio, imao je da se pogubi. ");
INSERT INTO srponstl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Svih popisanih Levita koje je, po Gospodnjoj naredbi, popisao Mojsije s Aronom prema njihovim rodovima, svih muškaraca od jednog meseca pa naviše, bilo je dvadeset dve hiljade. ");
INSERT INTO srponstl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Gospod reče Mojsiju: „Popiši sve muške prvence među Izrailjcima od jednog meseca pa naviše, i napravi spisak s njihovim imenima. ");
INSERT INTO srponstl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Levite uzmi za mene – Ja sam Gospod – umesto svih izrailjskih prvenaca, a levitsku stoku umesto sve prvine stoke Izrailjaca.“ ");
INSERT INTO srponstl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Tako je Mojsije popisao sve izrailjske prvence, kao što mu je zapovedio Gospod. ");
INSERT INTO srponstl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ukupan broj muških prvenaca po njihovim imenima, od jednog meseca pa naviše, bio je dvadeset dve hiljade dve stotine sedamdeset tri. ");
INSERT INTO srponstl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","„Uzmi Levite umesto svih izrailjskih prvenaca i levitsku stoku umesto njihove stoke; neka Leviti pripadaju meni. Ja sam Gospod. ");
INSERT INTO srponstl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","A za otkupnu cenu za onih dve stotine sedamdeset tri izrailjska prvenca, koliko ih ima više od Levita, ");
INSERT INTO srponstl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","uzmi po pet šekela po glavi prema hramskom šekelu (jedan šekel teži dvadeset gera). ");
INSERT INTO srponstl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Otkupnu cenu za te što ih ima više daj Aronu i njegovim sinovima.“ ");
INSERT INTO srponstl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Mojsije je uzeo novac od otkupnine za one kojih je bilo više od onih koje su Leviti otkupili. ");
INSERT INTO srponstl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Mojsije je od izrailjskih prvenaca primio hiljadu tri stotine šezdeset pet šekela hramske mere. ");
INSERT INTO srponstl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mojsije je po naredbi Gospodnjoj predao novac od otkupa Aronu i njegovim sinovima, baš kao što je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","„Popiši Katove potomke između Levijevih potomaka prema njihovim rodovima i očinskim domovima, ");
INSERT INTO srponstl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","između trideset i pedeset godina, sve koji su sposobni za službu, koji će vršiti službu u Šatoru od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Ovo je služba Katovih potomaka: da se brinu za najsvetije stvari u Šatoru od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Kad tabor kreće na put, neka Aron i njegovi sinovi skinu pregradnu zavesu i njom pokriju Kovčeg svedočanstva. ");
INSERT INTO srponstl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Neka preko njega stave pokrivač od fine kože, a odozgo neka prostru tkaninu, potpuno ljubičastu. Zatim neka mu provuku drške. ");
INSERT INTO srponstl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Preko stola za prinesene hlebove, neka prostru ljubičastu tkaninu, pa neka stave na njega zdele, posude za kad, vedra i krčage za žrtve izlivnice. Neka hleb stalno stoji na njemu. ");
INSERT INTO srponstl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Preko njih neka prostru purpurnu tkaninu i prekriju to pokrivačem od fine kože. Potom neka mu provuku drške. ");
INSERT INTO srponstl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Zatim neka uzmu ljubičastu tkaninu i pokriju svećnjak za svetlo i njegove žiške, njegove usekače, njegove podmetače, i sve posude za ulje, koje služe za njegovu upotrebu. ");
INSERT INTO srponstl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Neka ga sa svim njegovim priborom zaviju u pokrivač od fine kože i stave ga na nosiljku. ");
INSERT INTO srponstl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Preko zlatnog žrtvenika neka prostru ljubičastu tkaninu, i pokriju ga pokrivačem od fine kože. Onda neka mu provuku drške. ");
INSERT INTO srponstl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Neka uzmu sve posude za službu koje se koriste u Svetinji, pa neka ih stave u ljubičastu tkaninu i pokriju ih pokrivačem od fine kože. Potom neka ih stave na nosiljku. ");
INSERT INTO srponstl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Neka uklone pepeo sa žrtvenika, i prostru preko njega skerletno platno. ");
INSERT INTO srponstl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Onda neka stave na njega sav pribor za njegovu upotrebu: kadionice, viljuške, lopatice, kotliće i sve posude za žrtvenik, pa neka preko njega prostru pokrivač od fine kože i provuku mu drške. ");
INSERT INTO srponstl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Nakon što Aron i njegovi sinovi završe s pokrivanjem Svetinje i svih svetih posuda prilikom polaska tabora na put, neka dođu Katovi potomci da ih ponesu. Ipak, neka ne dotiču svete stvari, da ne poginu. To su stvari u Šatoru od sastanka koje će nositi Katovi potomci. ");
INSERT INTO srponstl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","A Eleazar, sin sveštenika Arona, neka se stara za ulje za svetlo, za miomirisni kad, za dnevnu žitnu žrtvu i ulje posvećenja, za celo Prebivalište i sve što se nalazi u njemu, i za Svetinju i njene posude.“ ");
INSERT INTO srponstl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","„Ne dopustite da budu istrebljeni plemenski rodovi Katovih potomaka između Levita. ");
INSERT INTO srponstl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ovako postupajte s njima da ostanu u životu i ne izginu kad pristupaju Svetinji nad svetinjama: neka dođu Aron i njegovi sinovi i svakome odrede šta će raditi i nositi. ");
INSERT INTO srponstl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Oni neka ne ulaze da gledaju svete stvari, da ne bi izginuli.“ ");
INSERT INTO srponstl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","„Popiši Girsonove sinove po njihovim otačkim domovima i njihovim porodicama. ");
INSERT INTO srponstl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Popiši one od trideset godina pa naviše, sve do pedesete godine, sve koji su sposobni za službu, koji će obavljati službu u Šatoru od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Ovo je služba Girsonovih rodova, kako će raditi i šta će nositi: ");
INSERT INTO srponstl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","neka nose zavese Prebivališta i Šator od sastanka, njegov pokrivač i pokrivač od fine kože, koji ide preko njega, i pregradnu zavesu na ulazu u Šator od sastanka; ");
INSERT INTO srponstl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","zatim dvorišne zastore na ulazu od dvorišta što je oko Prebivališta i žrtvenika, njegove konopce i sav pribor za njihovu upotrebu. Oni će raditi sve što treba uraditi oko tih stvari. ");
INSERT INTO srponstl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Sve što treba nositi i uraditi, biće dužnost Girsonovih potomaka, po naredbi Arona i njegovih sinova; predaj im u nadležnost sve što treba da nose. ");
INSERT INTO srponstl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","To je služba Girsonovih potomaka u Šatoru od sastanka. Njihove dužnosti biće pod nadzorom Itamara, sina sveštenika Arona. ");
INSERT INTO srponstl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Potom popiši Merarijeve potomke po njihovim rodovima i otačkim domovima. ");
INSERT INTO srponstl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Popiši one od trideset godina pa naviše, sve do pedesete godine, sve koji su sposobni za službu, koji će obavljati službu u Šatoru od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Njihova dužnost je, pored svih ostalih dužnosti u Šatoru od sastanka, da nose: daske za Prebivalište, njegove prevornice, stubove i postolja; ");
INSERT INTO srponstl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","stubove oko dvorišta i njihova postolja, njihove kočiće, njihove konopce, i sav njihov pribor za svaku njihovu upotrebu; nabroj po imenu predmete koje su dužni da nose. ");
INSERT INTO srponstl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ovo je služba rodova Merarijevih potomaka, prema svim njihovim službama u Šatoru od sastanka, pod nadzorom Itamara, sina sveštenika Arona.“ ");
INSERT INTO srponstl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Tako su Mojsije, Aron i knezovi zajednice popisali Katove potomke po njihovim rodovima i otačkim domovima, ");
INSERT INTO srponstl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","od trideset godina naviše, pa do pedeset godina, sve sposobne za službu u Šatoru od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Broj popisanih po njihovim rodovima bio je dve hiljade sedam stotina pedeset. ");
INSERT INTO srponstl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","To je broj popisanih Katovih rodova, svih onih koji su služili u Šatoru od sastanka. Njih su popisali Mojsije i Aron, kao što je Gospod zapovedio preko Mojsija. ");
INSERT INTO srponstl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Girsonovi sinovi su bili popisani po njihovim rodovima i otačkim domovima, ");
INSERT INTO srponstl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","između trideset godina naviše, pa do pedeset godina, sposobnih da obavljaju službu u Šatoru od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Broj popisanih po svojim rodovima i otačkim domovima bio je dve hiljade šest stotina trideset. ");
INSERT INTO srponstl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","To je broj popisanih Girsonovih sinova, svih onih koji su služili u Šatoru od sastanka. Njih su popisali Mojsije i Aron, po Gospodnjoj zapovesti. ");
INSERT INTO srponstl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Popisanih iz rodova Merarijevih sinova prema svojim rodovima i otačkim domovima, ");
INSERT INTO srponstl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","između trideset i pedeset godina, svih sposobnih da obavljaju službu u Šatoru od sastanka; ");
INSERT INTO srponstl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","popisanih, dakle, po njihovim rodovima, bilo je tri hiljade dve stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","To je broj popisanih Merarijevih sinova koje su popisali Mojsije i Aron, kao što je Gospod zapovedio preko Mojsija. ");
INSERT INTO srponstl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Broj popisanih Levita, koje su popisali Mojsije, Aron i izrailjski knezovi po njihovim rodovima i otačkim domovima, ");
INSERT INTO srponstl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","između trideset i pedeset godina, koji su bili sposobni za službu služenja i službu nošenja u Šatoru od sastanka; ");
INSERT INTO srponstl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","tih popisanih bilo je osam hiljada pet stotina osamdeset. ");
INSERT INTO srponstl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Svaki od njih je bio popisan prema svome služenju i nošenju, onako kako je Gospod zapovedio preko Mojsija. ");
INSERT INTO srponstl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","„Zapovedi Izrailjcima da udalje iz tabora svakoga ko je gubav, svakoga ko ima izliv, i svakoga ko se onečistio o mrtvaca. ");
INSERT INTO srponstl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Udaljite iz tabora kako muško tako žensko, da ne onečiste njihov tabor usred koga ja prebivam među njima.“ ");
INSERT INTO srponstl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Izrailjci učine tako; udaljili su ih izvan tabora. Kako je Gospod rekao Mojsiju, tako su Izrailjci učinili. ");
INSERT INTO srponstl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","„Reci Izrailjcima: ’Kad muškarac ili žena učini kakav greh protiv drugoga, te se izneveri Gospodu i navuče na sebe krivicu, ");
INSERT INTO srponstl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","neka prizna svoj greh koji je učinio. Zatim neka da punu naknadu za svoj prestup, i neka doda na to jednu petinu onome kome je skrivio. ");
INSERT INTO srponstl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ali ako taj čovek nema rođaka kome bi pripala naknada, neka se naknada da Gospodu na ime sveštenika, osim ovna – otkupnice kojom će se izvršiti otkupljenje za njega. ");
INSERT INTO srponstl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Od svih svetih prinosa koje Izrailjci donose svešteniku, neka svaka žrtva dizanica pripadne njemu. ");
INSERT INTO srponstl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Njemu, dakle, neka pripadnu sveti prinosi svakog čoveka; što god je dano svešteniku, neka pripadne svešteniku.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","„Reci Izrailjcima, kaži im: ’Ako nečija žena zastrani i tako mu se izneveri, ");
INSERT INTO srponstl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","pa neko legne s njom, a njen muž ne zna za to, i ona prikrije da se onečistila, ali nema svedoka protiv nje pošto nije bila uhvaćena na delu; ");
INSERT INTO srponstl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ako ga obuzme duh ljubomore, te posumnja da mu se žena onečistila, ili ga obuzme ljubomora, pa posumnja na ženu, iako se nije onečistila, ");
INSERT INTO srponstl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","neka muž dovede svoju ženu k svešteniku. Neka donese sa sobom i prinos za nju: desetinu efe ječmenog brašna. Neka ga ne preliva uljem i neka ne meće na njega tamjana, jer je to žitna žrtva za ljubomoru, žitna žrtva za spomen radi sećanja na krivicu. ");
INSERT INTO srponstl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Zatim neka je sveštenik privede i postavi pred Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Neka sveštenik uzme svete vode u zemljanu posudu, i neka uzme nešto prašine s poda Prebivališta i stavi je u vodu. ");
INSERT INTO srponstl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Pošto je sveštenik postavio ženu pred Gospodom, neka joj raspusti kosu, a na njene ruke neka položi žitnu žrtvu za spomen, što je žitna žrtva za ljubomoru. Sveštenik neka uzme u svoje ruke vodu gorčine koja donosi prokletstvo. ");
INSERT INTO srponstl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Tada neka je sveštenik zakune i kaže ženi: ’Ako nijedan čovek nije legao sa tobom, i ako nisi zastranila i onečistila se dok si bila pod vlašću svoga muža, neka ti ne naudi ova voda gorčine koja donosi prokletstvo. ");
INSERT INTO srponstl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","A ako si zastranila i onečistila se dok si bila pod vlašću svoga muža, te je neki čovek osim tvoga muža legao s tobom“ – ");
INSERT INTO srponstl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","tu neka sveštenik zakune ženu ovom kletvom i kaže joj – „neka te Gospod učini predmetom proklinjanja i kletve usred tvoga naroda; neka Gospod učini da ti materica usahne a stomak ti otekne. ");
INSERT INTO srponstl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Neka ova voda gorčine, koja donosi prokletstvo, uđe u tvoju utrobu i učini da ti stomak otekne a materica ti usahne!’ A žena neka kaže na to: ’Amin, Amin!’ ");
INSERT INTO srponstl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Neka sveštenik napiše ova prokletstva na list i spere ih u vodi gorčine. ");
INSERT INTO srponstl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Zatim neka da ženi da popije vodu gorčine koja donosi prokletstvo, kako bi voda gorčine koja donosi prokletstvo ušla u nju i izazvala gorčinu. ");
INSERT INTO srponstl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Potom neka sveštenik uzme iz ženinih ruku žitnu žrtvu za ljubomoru, podigne je pred Gospodom i donese je na žrtvenik. ");
INSERT INTO srponstl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Onda neka sveštenik zahvati pregršt od žitne žrtve, kao njen spomen, i spali to na žrtveniku. Konačno, neka da ženi da popije vodu. ");
INSERT INTO srponstl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kad je napoji vodom, ako se oskrnavila i izneverila svome mužu, voda prokletstva će ući u nju i izazvati gorčinu, pa će joj stomak oteći a materica joj usahnuti; tako će ta žena postati prokletstvom u svom narodu. ");
INSERT INTO srponstl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","A ako se žena nije oskrnavila, neće joj biti ništa, te će moći da rađa potomstvo. ");
INSERT INTO srponstl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ovo je zakon o ljubomori, kad žena zastrani i onečisti se dok je pod vlašću svoga muža, ");
INSERT INTO srponstl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ili kad čoveka obuzme duh ljubomore, pa posumnja na ženu. Tada neka sveštenik postavi ženu pred Gospoda i primeni na njoj sav ovaj zakon. ");
INSERT INTO srponstl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Čovek će biti oslobođen krivice, a žena će ispaštati za svoju krivicu.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","„Govori Izrailjcima. Reci im: ’Ako neki muškarac ili žena hoće da učini poseban zavet, zavet kojim se posvećuje Gospodu za nazireja, ");
INSERT INTO srponstl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","neka se uzdržava i od vina i od žestokog pića, i neka ne pije vinsko sirće ni sirće od žestokog pića. Neka ne pije sok od grožđa, i neka ne jede grožđe, bilo da je sveže ili suvo. ");
INSERT INTO srponstl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Dok god traje njegovo nazirejstvo neka ne jede ništa od vinove loze, ni zrna ni ljusku. ");
INSERT INTO srponstl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Dok god traje njegovo nazirejstvo, neka britva ne prelazi preko njegove glave, dok se ne navrše dani koje je zavetovao Gospodu kao nazirej; neka bude svet i neka pusti da mu kosa na glavi raste. ");
INSERT INTO srponstl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Dok god je posvećen Gospodu kao nazirej, neka ne prilazi blizu mrtvaca. ");
INSERT INTO srponstl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Neka se ne skrnavi ni kad mu umru otac ili majka, brat ili sestra, jer znak nazirejstva nosi na svojoj glavi. ");
INSERT INTO srponstl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Dok god traje njegovo nazirejstvo posvećen je Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ako neko iznenada umre u njegovoj blizini, te tako onečisti kosu koju je posvetio, neka obrije svoju glavu na dan svoga očišćenja; neka je obrije sedmoga dana. ");
INSERT INTO srponstl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Osmoga dana neka na ulaz u Šator od sastanka donese svešteniku dve grlice ili dva golubića. ");
INSERT INTO srponstl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Neka sveštenik prinese jedno kao žrtvu za greh, a drugo kao žrtvu svespalnicu, da izvrši otkupljenje za njega jer se oskrnavio preko mrtvaca. Istoga dana neka posveti svoju glavu ");
INSERT INTO srponstl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","pa neka se ponovo posveti Gospodu za vreme svog nazirejskog zaveta, i neka donese jagnje od godinu dana kao žrtvu za prestup. Prethodno vreme se neće računati, jer je oskrnavio svoj nazirejski zavet. ");
INSERT INTO srponstl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ovo je zakon za nazireje u dan kad se navrši vreme njegovog nazirejskog zaveta: neka ga dovedu na ulaz od Šatora od sastanka, ");
INSERT INTO srponstl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","i neka donesu prinos Gospodu: jedno muško jagnje bez mane od godinu dana za žrtvu svespalnicu; jedno žensko jagnje bez mane od godinu dana kao žrtvu za greh; jednog ovna bez mane za žrtvu mira; ");
INSERT INTO srponstl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","košaru beskvasnog hleba od brašna – kolače umešene s uljem; beskvasne pogače namazane uljem; njihove žitne žrtve i žrtve izlivnice. ");
INSERT INTO srponstl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Neka ih sveštenik donese pred Gospoda i prinese žrtvu za njegov greh i njegovu žrtvu svespalnicu. ");
INSERT INTO srponstl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ovna neka prinese Gospodu kao žrtvu mira zajedno s košarom beskvasnog hleba. Sveštenik neka prinese žitnu žrtvu i žrtvu izlivnicu. ");
INSERT INTO srponstl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Zatim neka nazirej obrije svoju posvećenu glavu na ulazu u Šator od sastanka. Kosu sa svoje posvećene glave neka stavi u vatru ispod žrtve mira. ");
INSERT INTO srponstl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Potom neka sveštenik uzme plećku od skuvanog ovna, jedan beskvasni kolač iz košare, i jednu beskvasnu pogaču, pa neka to stavi na ruke nazireja, nakon što ovaj obrije svoju posvećenu kosu. ");
INSERT INTO srponstl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Neka ih sveštenik podigne kao žrtvu dizanicu pred Gospodom; oni su sveti deo za sveštenika zajedno sa grudima i butom žrtve dizanice. Posle toga nazirej može da pije vino. ");
INSERT INTO srponstl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Ovo je zakon za nazireja koji zavetuje dar Gospodu povrh onoga što može da priušti. Neka zavet kojim se obavezao bude u skladu sa njegovim nazirejstvom.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","„Reci Aronu i njegovim sinovima: ’Ovako blagosiljajte Izrailjce. Recite im: ");
INSERT INTO srponstl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","„Neka te Gospod blagoslovi i čuva; ");
INSERT INTO srponstl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","neka te Gospod obasja svojim licem i bude ti milostiv; ");
INSERT INTO srponstl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","neka Gospod okrene svoje lice k tebi i da ti mir.“’ ");
INSERT INTO srponstl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ovako neka prizivaju moje ime na potomke Izrailjeve i ja ću ih blagosloviti.“ ");
INSERT INTO srponstl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Onoga dana kad je završio s podizanjem Prebivališta Mojsije je pomazao i posvetio i njega i sve posuđe. Pomazao je i posvetio žrtvenik i sav njegov pribor. ");
INSERT INTO srponstl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Tada su pristupili izrailjski knezovi, glavari otačkih domova i plemenski knezovi, koji su nadzirali popisane, ");
INSERT INTO srponstl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","i doneli svoje prinose pred Gospoda: šest kola i dvanaest volova, jedna kola za dva kneza, po jedan vo za svakog kneza. Doneli su ih ispred Prebivališta. ");
INSERT INTO srponstl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Tada Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","„Primite ih od njih da rade u službi Šatora od sastanka; dajte ih Levitima, svakome prema njegovoj službi.“ ");
INSERT INTO srponstl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Mojsije je uzeo kola i volove i predao ih Levitima. ");
INSERT INTO srponstl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Dvoja kola sa četiri vola dao je Girsonovim potomcima prema njihovoj službi. ");
INSERT INTO srponstl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Četvora kola sa osam volova dao je Merarijevim sinovima prema njihovoj službi, pod vodstvom Itamara, sina sveštenika Arona. ");
INSERT INTO srponstl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Katovim sinovima ih nije dao, zato što je njihova služba da nose svete stvari na svojim ramenima. ");
INSERT INTO srponstl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Zatim su knezovi doneli prinos za posvećenje žrtvenika na dan njegovog pomazanja. Kad su knezovi doneli svoje prinose pred žrtvenik, ");
INSERT INTO srponstl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Gospod reče Mojsiju: „Neka svakoga dana po jedan knez donese svoj prinos za posvećenje žrtvenika.“ ");
INSERT INTO srponstl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Tog prvoga dana svoj je prinos doneo Nason, Aminadavov sin, iz Judinog plemena. ");
INSERT INTO srponstl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela; jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","jedan junac, jedan ovan i jedno jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","jedan jarac za žrtvu za greh; ");
INSERT INTO srponstl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","a za žrtvu mira dva vola, pet ovnova, pet jaraca, i pet muških jaganjaca od godinu dana. To je bio prinos Nasona, sina Aminadavovog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Drugoga dana svoj je prinos doneo Natanail, sin Sogarov, Isaharov knez. ");
INSERT INTO srponstl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela, jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","jedan junac, jedan ovan i jedno muško jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","jedan jarac za žrtvu za greh, ");
INSERT INTO srponstl_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","a za žrtvu mira dva vola, pet ovnova, pet jaraca i pet muških jaganjaca od godinu dana. To je bio prinos Natanaila, sina Sogarovog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Trećega dana svoj je prinos doneo Elijav, sin Helonov, knez Zavulonovih potomaka. ");
INSERT INTO srponstl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela, jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","jedan junac, jedan ovan, jedno muško jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","jedan jarac za žrtvu za greh; ");
INSERT INTO srponstl_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","a za žrtvu mira dva vola, pet ovnova, pet jaraca, i pet muških jaganjaca od godinu dana. To je bio prinos Elijava, sina Helonovog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Četvrtog dana svoj je prinos doneo Elisur, sin Sedijurov, knez Ruvimovih potomaka. ");
INSERT INTO srponstl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela, jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","jedan junac, jedan ovan, jedno muško jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","jedan jarac za žrtvu za greh; ");
INSERT INTO srponstl_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","a za žrtvu mira dva vola, pet ovnova, pet jaraca, i pet muških jaganjaca od godinu dana. To je bio prinos Elisura, sina Sedijurovog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Petog dana svoj je prinos doneo Salamilo, sin Surisadajev, knez Simeunovih potomaka. ");
INSERT INTO srponstl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela, jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","jedan junac, jedan ovan, jedno muško jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","jedan jarac za žrtvu za greh; ");
INSERT INTO srponstl_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","a za žrtvu mira dva vola, pet ovnova, pet jaraca, i pet muških jaganjaca od godinu dana. To je bio prinos Salamila, sina Surisadajevog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Šestog dana svoj je prinos doneo Elisaf, sin Deuelov, knez Gadovih potomaka. ");
INSERT INTO srponstl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela, jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","jedan junac, jedan ovan, jedno muško jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","jedan jarac za žrtvu za greh; ");
INSERT INTO srponstl_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","a za žrtvu mira dva vola, pet ovnova, pet jaraca, i pet muških jaganjaca od godinu dana. To je bio prinos Elisafa, sina Deuelovog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Sedmog dana svoj je prinos doneo Elisama, sin Amijudov, knez Jefremovih potomaka. ");
INSERT INTO srponstl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela, jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","jedan junac, jedan ovan, jedno jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","jedan jarac za žrtvu za greh; ");
INSERT INTO srponstl_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","a za žrtvu mira dva vola, pet ovnova, pet jaraca, i pet muških jaganjaca od godinu dana. To je bio prinos Elisame, sina Amijudovog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Osmoga dana svoj je prinos doneo Gamalilo, sin Fadasurov, knez Manasijinih potomaka. ");
INSERT INTO srponstl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela, jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno finog brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","jedan junac, jedan ovan, jedno jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","jedan jarac za žrtvu za greh; ");
INSERT INTO srponstl_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","a za žrtvu mira dva vola, pet ovnova, pet jaraca, i pet muških jaganjaca od godinu dana. To je bio prinos Gamalila, sina Fadasurovog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Devetoga dana svoj je prinos doneo Avidan, sin Gadeonijev, knez Venijaminovih potomaka. ");
INSERT INTO srponstl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela, jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","jedan junac, jedan ovan, jedno jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","jedan jarac za žrtvu za greh; ");
INSERT INTO srponstl_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","a za žrtvu mira dva vola, pet ovnova, pet jaraca, i pet muških jaganjaca od godinu dana. To je bio prinos Avidana, sina Gadeonijevog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Desetoga dana svoj je prinos doneo Ahijezer, sin Amisadajev, knez Danovih potomaka. ");
INSERT INTO srponstl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela, jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","jedan junac, jedan ovan, jedno jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","jedan jarac za žrtvu za greh; ");
INSERT INTO srponstl_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","a za žrtvu mira dva vola, pet ovnova, pet jaraca, i pet muških jaganjaca od godinu dana. To je bio prinos Ahijezera, sina Amisadajevog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Jedanaestoga dana svoj je prinos doneo Fagailo, sin Ehranov, knez Asirovih potomaka. ");
INSERT INTO srponstl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela, jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","jedan junac, jedan ovan, jedno jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","jedan jarac za žrtvu za greh; ");
INSERT INTO srponstl_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","a za žrtvu mira dva vola, pet ovnova, pet jaraca, i pet muških jaganjaca od godinu dana. To je bio prinos Fagaila, sina Ehranovog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Dvanaestoga dana svoj je prinos doneo Ahirej sin Enanov, knez Neftalimovih potomaka. ");
INSERT INTO srponstl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Njegov prinos je bio: jedna srebrna zdela teška stotinu trideset šekela, jedan srebrni kotao težak sedamdeset šekela prema hramskom šekelu, oboje puno brašna pomešanog s uljem za žitnu žrtvu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","jedna zlatna kadionica teška deset šekela, puna kada; ");
INSERT INTO srponstl_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","jedan junac, jedan ovan, jedno jagnje od godinu dana za žrtvu svespalnicu; ");
INSERT INTO srponstl_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","jedan jarac za žrtvu za greh; ");
INSERT INTO srponstl_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","a za žrtvu mira dva vola, pet ovnova, pet jaraca, i pet muških jaganjaca od godinu dana. To je bio prinos Ahireja, sina Enanovog. ");
INSERT INTO srponstl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","To su bili prinosi izrailjskih knezova za posvećenje žrtvenika u dan kad je bio pomazan: dvanaest srebrnih zdela, dvanaest srebrnih kotlova i dvanaest zlatnih kadionica. ");
INSERT INTO srponstl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Svaka srebrna zdela je težila stotinu trideset šekela, a svaki kotao je težio sedamdeset šekela. Ukupna težina srebra tih posuda je bila dve hiljade četiri stotine šekela, prema hramskom šekelu. ");
INSERT INTO srponstl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Bilo je dvanaest zlatnih kadionica punih kada, i svaka kadionica je težila deset šekela prema hramskom šekelu. Ukupna težina zlata od kadionica bila je stotinu dvadeset šekela. ");
INSERT INTO srponstl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ukupan broj stoke za žrtvu svespalnicu bio je: dvanaest junaca, dvanaest ovnova, dvanaest jaganjaca od godinu dana, s njihovim žitnim žrtvama, i dvanaest jaraca za žrtvu za greh. ");
INSERT INTO srponstl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Ukupan broj stoke za žrtvu mira bio je dvadeset četiri vola, šezdeset ovnova, šezdeset jaraca i šezdeset muških jaganjaca od godinu dana. To je bio prinos za posvećenje žrtvenika nakon njegovog pomazanja. ");
INSERT INTO srponstl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Kad je Mojsije ušao u Šator od sastanka da razgovara s Gospodom, čuo je kako mu govori glas odozgo, više poklopca, koji je bio na Kovčegu svedočanstva, između dva heruvima. Tada mu je govorio. ");
INSERT INTO srponstl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","„Govori Aronu i reci mu: ’Kada budeš postavljao svetiljke, neka sedam svetiljki svetle ispred svećnjaka.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aron učini tako; postavio je svetiljke da svetle ispred svećnjaka, kao što je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","A svećnjak je ovako bio napravljen: bio je iskovan od zlata, od postolja do latica; tako je bio iskovan. Svećnjak je bio napravljen prema slici koju je Gospod pokazao Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","„Uzmi Levite između naroda i očisti ih. ");
INSERT INTO srponstl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ovako ćeš postupiti s njima kako bi ih očistio: poškropi ih vodom očišćenja, a oni neka obriju britvom sve svoje telo i operu svoju odeću, pa će biti čisti. ");
INSERT INTO srponstl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Zatim neka uzmu jednog junca zajedno sa žitnom žrtvom od brašna zamešenog s uljem, a ti uzmi drugog junca za žrtvu za greh. ");
INSERT INTO srponstl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Onda dovedi Levite ispred Šatora od sastanka i saberi svu izrailjsku zajednicu. ");
INSERT INTO srponstl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Kad dovedeš Levite pred Gospoda, neka Izrailjci polože svoje ruke na Levite. ");
INSERT INTO srponstl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Tada neka Aron prinese Levite pred Gospodom, kao žrtvu dizanicu sinova Izrailjevih, da bi mogli obavljati službu Gospodnju. ");
INSERT INTO srponstl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Potom neka Leviti polože ruke juncima na glavu; ti prinesi jednog kao žrtvu za greh, a drugog kao žrtvu svespalnicu Gospodu za otkupljenje Levita. ");
INSERT INTO srponstl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Kad postaviš Levite pred Arona i pred njegove sinove, prinesi ih Gospodu kao žrtvu dizanicu. ");
INSERT INTO srponstl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Zatim izdvoj Levite između Izrailjaca da budu moji. ");
INSERT INTO srponstl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Nakon toga, kad ih očistiš i prineseš ih na žrtvu dizanicu, neka Leviti stupe u službu Šatora od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Naime, između Izrailjaca, oni su posvećeni za mene. Ja sam ih uzeo za sebe umesto svih koji se prvi rađaju iz majčine utrobe, umesto svih prvenaca potomaka Izrailjevih. ");
INSERT INTO srponstl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Jer, meni pripada svaki prvenac između potomaka Izrailjevih, kako od ljudi tako od stoke; ja sam ih posvetio za sebe onoga dana kad sam pobio sve prvence u Egiptu. ");
INSERT INTO srponstl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","A Levite sam uzeo umesto svih prvorođenaca među Izrailjcima. ");
INSERT INTO srponstl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Od Izrailjaca, Aronu i njegovim sinovima dodeljujem Levite, da obavljaju službu za Izrailjce u Šatoru od sastanka, i da vrše otkupljenje za Izrailjce, da ne bi došao pomor na Izrailjce kad dođu do Svetilišta.“ ");
INSERT INTO srponstl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mojsije, Aron i sva zajednica potomaka Izrailjevih učine s Levitima sve kako je Gospod zapovedio Mojsiju; Izrailjci su učinili s Levitima baš tako. ");
INSERT INTO srponstl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Leviti su se očistili od greha i oprali svoju odeću, a Aron ih je prineo kao žrtvu dizanicu pred Gospodom. Aron je izvršio nad njima obred otkupljenja da bi ih očistio. ");
INSERT INTO srponstl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Posle toga su Leviti došli da obavljaju službu u Šatoru od sastanka pred Aronom i njegovim sinovima. Kako je Gospod zapovedio Mojsiju za Levite, tako su učinili s njima. ");
INSERT INTO srponstl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Gospod opet reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","„Ovo je uredba za Levite: od dvadeset pet godina pa naviše, neka stupaju u službu da obavljaju službu u Šatoru od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","A kad ko navrši pedesetu godinu, neka se povuče iz službe i ne radi više. ");
INSERT INTO srponstl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","On može pomagati svojoj braći u vršenju službe u Šatoru od sastanka, ali neka ne obavlja službu. Ovako ćeš postupati s Levitima u vezi s njihovim dužnostima.“ ");
INSERT INTO srponstl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Gospod reče Mojsiju u Sinajskoj pustinji prvoga dana druge godine po njihovom izlasku iz Egipta: ");
INSERT INTO srponstl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","„Neka Izrailjci slave Pashu u određeno vreme. ");
INSERT INTO srponstl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Slavite je u njeno vreme, četrnaestog dana ovoga meseca, uveče; slavite je po svim njenim propisima i uputstvima.“ ");
INSERT INTO srponstl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Tako je Mojsije rekao Izrailjcima da slave Pashu. ");
INSERT INTO srponstl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Pashu su proslavili u Sinajskoj pustinji, prvog meseca četrnaestog dana, uveče. Izrailjci su učinili onako kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","A dogodilo se da su se neki ljudi onečistili o ljudski leš, te nisu mogli toga dana da slave Pashu. Tog dana su došli pred Mojsija i Arona, ");
INSERT INTO srponstl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","i rekli Mojsiju: „Da, onečistili smo se o ljudski leš, ali zašto nam se uskraćuje da prinesemo žrtvu Gospodu u njeno vreme zajedno sa ostalim Izrailjcima?“ ");
INSERT INTO srponstl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mojsije im odgovori: „Sačekajte da čujem šta će Gospod zapovediti za vas.“ ");
INSERT INTO srponstl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","„Reci Izrailjcima: ’Ako se neko od vas, ili od vaših potomaka onečisti o mrtvaca, ili je na dalekom putu, neka i on slavi Pashu Gospodnju. ");
INSERT INTO srponstl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Neka je slave drugoga meseca četrnaestog dana uveče. Neka jedu jagnje s beskvasnim hlebovima i gorkim zeljem. ");
INSERT INTO srponstl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ništa od njega ne sme ostati do sledećeg jutra, i neka mu ne prelome ni jednu kost. Neka je slave po svim njenim propisima i uputstvima. ");
INSERT INTO srponstl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ali ako je neko čist i nije na putu, pa propusti da proslavi Pashu, neka se takav istrebi iz svog naroda, jer nije prineo žrtvu Gospodu u njeno vreme. Taj će čovek ispaštati za svoj greh. ");
INSERT INTO srponstl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Ako stranac koji boravi sa vama hoće da slavi Pashu Gospodnju, neka je slavi u skladu s njenim propisima i uputstvima. Neka bude isti zakon za vas, kako za stranca tako za rođenog u zemlji.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Onoga dana kad je Prebivalište bilo podignuto, Šator svedočanstva je prekrio oblak, koji je od večeri do jutra bio u obliku ognja nad Prebivalištem. ");
INSERT INTO srponstl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Tako je bilo stalno: oblak ga je prekrivao danju, a noću je bio u obliku ognja. ");
INSERT INTO srponstl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Kad god se oblak podizao sa Šatora, Izrailjci bi kretali na put, a gde bi se oblak zaustavio, tamo bi se Izrailjci utaborili. ");
INSERT INTO srponstl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Izrailjci su polazili na Gospodnju zapovest i logorovali po Gospodnjoj zapovesti. Dok god bi oblak počivao nad Prebivalištem, oni bi logorovali. ");
INSERT INTO srponstl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Čak i kada bi se oblak zadržao nad Prebivalištem mnogo dana, Izrailjci su se držali Gospodnje naredbe, te nisu polazili. ");
INSERT INTO srponstl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","A kada bi se desilo da oblak nekoliko dana stoji nad Prebivalištem, oni bi na Gospodnju zapovest ostali u logoru i na Gospodnju zapovest polazili. ");
INSERT INTO srponstl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ako bi se desilo da se oblak zadrži od večeri do jutra, a ujutro se oblak podigne, i oni bi polazili. Kad god bi se oblak digao, bilo danju ili noću, oni bi polazili. ");
INSERT INTO srponstl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Bilo da je oblak počivao nad Prebivalištem dva dana, jedan mesec, ili duže vreme, Izrailjci bi ostali u taboru i ne bi polazili. Polazili bi kada bi se podizao. ");
INSERT INTO srponstl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Na Gospodnju zapovest su dizali tabor i na Gospodnju zapovest su polazili. Držali su Gospodnju naredbu, po Gospodnjoj zapovesti danoj preko Mojsija. ");
INSERT INTO srponstl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","„Načini sebi dve trube; načini ih od kovanog srebra, da ti služe za sazivanje zajednice i pokretanje tabora. ");
INSERT INTO srponstl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kad se one oglase, neka se sva zajednica sabere k tebi kod ulaza u Šator od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ako samo jedna zatrubi, neka se saberu k tebi knezovi, glavari Izrailjevih plemena. ");
INSERT INTO srponstl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Kad gromko zatrubite, neka krenu tabori koji su na istoku. ");
INSERT INTO srponstl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Kad gromko zatrubite po drugi put, neka krenu tabori na jugu. Neka gromko zatrube kad god tabor kreće. ");
INSERT INTO srponstl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Kad se okuplja zbor, zatrubite, ali ne gromko. ");
INSERT INTO srponstl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Neka Aronovi sinovi, sveštenici, trube u trube. To će biti trajna uredba za vas i vaše naraštaje. ");
INSERT INTO srponstl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Kad u svojoj zemlji stupite u rat protiv neprijatelja koji vas napada, gromko zatrubite u trube, pa će vas se setiti Gospod, Bog vaš, i bićete izbavljeni od svojih neprijatelja. ");
INSERT INTO srponstl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","U dan kad se budete radovali na svojim praznicima i na početku svojih meseci, zatrubite u trube, pa prinosite svoje žrtve svespalnice i svoje žrtve mira. Neka vam one budu spomen pred vašim Bogom. Ja sam Gospod, Bog vaš!“ ");
INSERT INTO srponstl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Dvadesetog dana, drugog meseca, druge godine, oblak se podigao sa Prebivališta svedočanstva, ");
INSERT INTO srponstl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","pa su Izrailjci krenuli iz Sinajske pustinje idući od mesta do mesta. Oblak se zaustavio u Faranskoj pustinji. ");
INSERT INTO srponstl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Tako su po prvi put krenuli na put po Gospodnjoj zapovesti danoj preko Mojsija. ");
INSERT INTO srponstl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Prvo je krenula zastava Judinog tabora, po svojim vojskama, na čelu sa Nasonom, sinom Aminadavovim. ");
INSERT INTO srponstl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nad vojskom Isaharovog plemena bio je Natanailo, sin Sogarov. ");
INSERT INTO srponstl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Nad vojskom Zavulonovog plemena bio je Elijav, sin Helonov. ");
INSERT INTO srponstl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Kad je Prebivalište bilo rastavljeno, Girsonovi i Merarijevi potomci su poneli Prebivalište. ");
INSERT INTO srponstl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Zatim je krenula zastava Ruvimovog tabora, na čelu sa Elisurom, sinom Sedijurovim. ");
INSERT INTO srponstl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Nad vojskom Simeunovog plemena bio je Salamilo, sin Surisadajev. ");
INSERT INTO srponstl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Nad vojskom Gadovog plemena bio je Elisaf, sin Deuelov. ");
INSERT INTO srponstl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Tada su Katovi potomci krenuli noseći svete stvari. Svetilište je bilo podignuto pre nego što su stigli. ");
INSERT INTO srponstl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Zatim je krenula zastava Jefremovog tabora po svojim vojskama, na čelu sa Elisamom, sinom Amijudovim. ");
INSERT INTO srponstl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Nad vojskom Manasijinog plemena bio je Gamalilo, sin Fadasurov ");
INSERT INTO srponstl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Nad vojskom Venijaminovog plemena bio je Avidan, sin Gadeonijev. ");
INSERT INTO srponstl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Onda je, kao prateća straža svih tabora, krenula zastava Danovog tabora, po svojim vojskama. Nad njihovom vojskom bio je Ahijezer, sin Amisadajev. ");
INSERT INTO srponstl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Nad vojskom Asirovog plemena bio je Fagailo, sin Ehranov. ");
INSERT INTO srponstl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Nad vojskom Neftalimovog plemena bio je Ahirej, sin Enanov. ");
INSERT INTO srponstl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","To je bio red po kome su Izrailjci putovali, kad su kretali po svojim četama. ");
INSERT INTO srponstl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mojsije reče svome tastu Hovavu, sinu Raguila Madijanca: „Putujemo na mesto za koje je Gospod rekao: ’Vama ću ga dati.’ Pođi s nama i činićemo ti dobro, jer je Gospod obećao dobro Izrailju.“ ");
INSERT INTO srponstl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","On mu odgovori: „Neću poći, nego ću se vratiti u svoju zemlju i u svoj rod.“ ");
INSERT INTO srponstl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mojsije mu reče: „Molim te, nemoj da nas ostaviš; ti, naime, znaš gde da se utaborimo u pustinji, pa ćeš nam biti poput očiju. ");
INSERT INTO srponstl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ako pođeš s nama, što god dobro Gospod učinio nama, isto dobro ćemo učiniti tebi.“ ");
INSERT INTO srponstl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Tako su sa Gore Gospodnje krenuli na trodnevni put. Ispred njih je išao Kovčeg Gospodnjeg saveza ta tri dana puta, da im nađe mesto za odmor. ");
INSERT INTO srponstl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Oblak Gospodnji je danju bio nad njima kad bi polazili iz tabora. ");
INSERT INTO srponstl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Kad je Kovčeg polazio, Mojsije je govorio: „Ustani, Gospode, neka se raziđu tvoji dušmani! Neka se razbeže pred tobom oni što te mrze!“ ");
INSERT INTO srponstl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","A kad se zaustavljao, govorio je: „Vrati se, Gospode, među Izrailjeve hiljade!“ ");
INSERT INTO srponstl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Međutim, narod je počeo da gunđa u Gospodnje uši radi svoga zlopaćenja. Kad je to Gospod čuo, raspalio se njegov gnev: planuo je Gospodnji oganj među njima, pa je proždro jedan kraj tabora. ");
INSERT INTO srponstl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Tada je narod zavapio k Mojsiju. Mojsije se pomolio Gospodu i oganj se ugasio. ");
INSERT INTO srponstl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Tako se to mesto prozvalo Tavera, jer je tamo planuo oganj Gospodnji. ");
INSERT INTO srponstl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ali svetinu među njima je spopala žudnja, pa su Izrailjci ponovo počeli da jadikuju i govore: „Ko će nas nahraniti mesom? ");
INSERT INTO srponstl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Sećamo se kako smo u Egiptu zabadava jeli ribu, pa krastavce, dinje, praziluk, i crni i beli luk. ");
INSERT INTO srponstl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Sada nam je duša u nosu, a ništa drugo ne vidimo osim ove mane!“ ");
INSERT INTO srponstl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana je bila kao zrno korijandra, a izgledala je kao bdelijum. ");
INSERT INTO srponstl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Narod je išao okolo i kupio je, a zatim su je mleli na žrvnjima, ili je mrvili u avanu, i kuvali u loncu. Od toga su pravili kolače, koji su imali ukus uljanih kolača. ");
INSERT INTO srponstl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Kada bi u toku noći rosa pala na tabor, na nju bi pala mana. ");
INSERT INTO srponstl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mojsije je čuo da narod jadikuje – svaka porodica na ulazu svog šatora. Tada se Gospod silno razgnevio, a Mojsije se ozlovoljio. ");
INSERT INTO srponstl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mojsije reče Gospodu: „Zašto zlopatiš svoga slugu? Zašto mi nisi iskazao naklonost, nego si natovario na mene teret sveg ovog naroda? ");
INSERT INTO srponstl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Jesam li ja začeo sav ovaj narod? Jesam li ih ja rodio, kad mi kažeš: ’Nosi ih u svome naručju, kao što dojilja nosi odojče’, u zemlju koju si uz zakletvu obećao njihovim precima? ");
INSERT INTO srponstl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Odakle mi meso za sav ovaj narod, jer mi vape govoreći: ’Daj nam meso da jedemo!’? ");
INSERT INTO srponstl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ne mogu sam da nosim sav ovaj narod, jer je to preteško za mene. ");
INSERT INTO srponstl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ako ćeš ovako da postupaš sa mnom, bolje je da me odmah ubiješ. A ako sam stekao naklonost pred tobom, ne daj da gledam svoju muku.“ ");
INSERT INTO srponstl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Gospod reče Mojsiju: „Okupi mi sedamdeset ljudi od izrailjskih starešina za koje znaš da su starešine naroda i njegovi nadglednici. Zatim ih dovedi pred Šator od sastanka i postavi ih tamo sa sobom. ");
INSERT INTO srponstl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Tada ću sići i govoriti tamo s tobom, pa ću uzeti od Duha koji je na tebi i staviti ga na njih. Tako će zajedno sa tobom nositi teret naroda, pa ga nećeš više nositi sam. ");
INSERT INTO srponstl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","A narodu reci: ’Posvetite se za sutra, pa ćete jesti meso, jer kukate u Gospodnje uši i govorite: „Ko će nas nahraniti mesom? Bilo nam je bolje u Egiptu.“ Gospod će vam dati meso, pa ćete se najesti. ");
INSERT INTO srponstl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","I nećete jesti samo dan ili dva, ni pet, ni deset ni dvadeset dana, ");
INSERT INTO srponstl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","nego čitav mesec, dok vam ne izađe na nos, te vam postane odvratno, jer ste prezreli Gospoda koji je među vama, i kukali pred njim govoreći: „Zbog čega smo to izlazili iz Egipta?“’“ ");
INSERT INTO srponstl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mojsije reče na to: „Ja sam među narodom koji broji šest stotina hiljada pešaka, a ti kažeš: ’Daću im mesa, pa će jesti mesec dana!’ ");
INSERT INTO srponstl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Da se zakolju i stada ovaca i krda goveda, da li bi to bilo dovoljno za njih? Čak i da se sve ribe izvuku iz mora, da li bi im to bilo dovoljno?“ ");
INSERT INTO srponstl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Gospod odgovori Mojsiju: „Zar je ruka Gospodnja tako kratka? Sada ćeš videti hoće li se ispuniti moja reč koju sam ti rekao, ili neće.“ ");
INSERT INTO srponstl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mojsije izađe i prenese narodu reči Gospodnje. Zatim je okupio sedamdeset starešina naroda i postavio ih oko Šatora. ");
INSERT INTO srponstl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","I Gospod se spustio u oblaku i govorio sa njim. Potom je uzeo nešto od Duha koji je bio na njemu i stavio ga na sedamdeset starešina. Kad je Duh počinuo na njima, počeli su da prorokuju, ali nisu više to ponovili. ");
INSERT INTO srponstl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","A u taboru su ostala dva čoveka. Jedan se zvao Eldad, a drugi Modad. Na njih se spustio Duh. Oni su bili među popisanim starešinama, ali nisu otišli u Šator, nego su prorokovali u taboru. ");
INSERT INTO srponstl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Tada neki momak otrči i javi Mojsiju: „Eldad i Modad prorokuju u taboru!“ ");
INSERT INTO srponstl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Isus Navin, Mojsijev pomoćnik, jedan od njegovih momaka, reče: „Mojsije, gospodaru moj, zabrani im!“ ");
INSERT INTO srponstl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ali Mojsije mu reče: „Zar si zavidan radi mene? E, kad bi svi u narodu Gospodnjem postali proroci! Kad bi samo Gospod stavio svoga Duha na njih!“ ");
INSERT INTO srponstl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Potom se Mojsije sa izrailjskim starešinama vratio u tabor. ");
INSERT INTO srponstl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Gospod je učinio da dune vetar, koji je doneo prepelice s mora i razasuo ih po taboru, na dan hoda s jedne strane tabora i na dan hoda s druge strane tabora, na dva lakta od zemlje. ");
INSERT INTO srponstl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Narod je ustao, pa je kupio prepelice sav dan i svu noć, i sav naredni dan. Onaj koji je najmanje skupio imao je deset homera. Zatim su ih razasuli svuda po taboru. ");
INSERT INTO srponstl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Dok im je meso još bilo u zubima – bilo je još nesažvakano – planu gnev Gospodnji na narod, i Gospod udari narod veoma velikim pomorom. ");
INSERT INTO srponstl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Zato se to mesto prozvalo Kivrot-Atava, jer su tamo sahranili narod koji se polakomio. ");
INSERT INTO srponstl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Iz Kivrot-Atave narod je krenuo u Asirot i utaborio se u Asirotu. ");
INSERT INTO srponstl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Marija i Aron su počeli da govore protiv Mojsija zbog kušanske žene koju je oženio; jer je uzeo za ženu Kušanku. ");
INSERT INTO srponstl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Rekli su: „Zar je Gospod govorio samo preko Mojsija? Nije li govorio i preko nas?“ Gospod je to čuo. ");
INSERT INTO srponstl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","A Mojsije je bio veoma ponizan čovek, najponizniji čovek na zemlji. ");
INSERT INTO srponstl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Gospod odmah reče Mojsiju, Aronu i Mariji: „Dođite, vas troje, u Šator od sastanka!“ Njih troje odu. ");
INSERT INTO srponstl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Gospod siđe u stubu od oblaka, pa stade na ulaz od Šatora i pozva: „Arone i Marija!“ Oni stupe napred. ");
INSERT INTO srponstl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Gospod reče: „Čujte moje reči: kad se među vama nađe prorok Gospodnji, ja mu se objavljujem u viđenju i govorim mu u snu. ");
INSERT INTO srponstl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ali sa mojim slugom Mojsijem nije tako; on je veran Bogu nad celim domom. ");
INSERT INTO srponstl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ja mu progovaram licem u lice, u zbilji, a ne u zagonetkama; on gleda obličje Gospodnje. Kako se, onda, ne bojite da govorite protiv moga sluge Mojsija?“ ");
INSERT INTO srponstl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Gospod planu svojim gnevom na njih i ode. ");
INSERT INTO srponstl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Kada se oblak podigao sa Šatora, a ono, Marija ogubavela, bela kao sneg. Aron se okrenuo prema Mariji, kad gle, ona gubava. ");
INSERT INTO srponstl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Tada Aron reče Mojsiju: „Molim te, moj gospodaru, nemoj nas kazniti za greh koji smo počinili u svojoj ludosti! ");
INSERT INTO srponstl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ne daj da ona bude kao mrtvo dete, koje izađe iz majčine utrobe s već napola raspadnutim telom!“ ");
INSERT INTO srponstl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Tada je Mojsije zavapio Gospodu i rekao: „O, Bože, molim te, isceli je!“ ");
INSERT INTO srponstl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Gospod reče Mojsiju: „Da joj je otac pljunuo u lice, ne bi li nosila svoju sramotu sedam dana? Neka bude odvojena izvan tabora sedam dana, a onda neka opet bude priključena.“ ");
INSERT INTO srponstl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Tako je Marija bila odvojena izvan tabora sedam dana. Narod nije polazio dok Marija nije bila ponovo priključena. ");
INSERT INTO srponstl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Posle toga je narod otišao iz Asirota, i utaborio se u Faranskoj pustinji. ");
INSERT INTO srponstl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","„Pošalji ljude da izvide hanansku zemlju, koju dajem Izrailjcima. Iz svakog otačkog plemena pošalji po jednog čoveka. Neka svaki od njih bude njihov knez.“ ");
INSERT INTO srponstl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Tako ih je Mojsije poslao iz Faranske pustinje po Gospodnjoj zapovedi. Svi su oni bili glavari Izrailjaca. ");
INSERT INTO srponstl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ovo su njihova imena: iz Ruvimovog plemena: Samuja, sin Zahurov; ");
INSERT INTO srponstl_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","iz Simeunovog plemena: Safat, sin Surin; ");
INSERT INTO srponstl_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","iz Judinog plemena: Halev, sin Jefonijin; ");
INSERT INTO srponstl_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","iz Isaharovog plemena: Igal, sin Josifov; ");
INSERT INTO srponstl_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","iz Jefremovog plemena: Osija, sin Navinov; ");
INSERT INTO srponstl_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","iz Venijaminovog plemena: Faltije, sin Rafujev; ");
INSERT INTO srponstl_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","iz Zavulonovog plemena: Gudilo, sin Sudin; ");
INSERT INTO srponstl_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","iz Josifovog plemena (iz Manasijinog plemena): Gadije, sin Susin; ");
INSERT INTO srponstl_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","iz Danovog plemena: Amilo, sin Gamalin; ");
INSERT INTO srponstl_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","iz Asirovog plemena: Satur sin Mihailov; ");
INSERT INTO srponstl_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","iz Neftalimovog plemena: Navija, sin Vofsijev; ");
INSERT INTO srponstl_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","iz Gadovog plemena: Gudilo, sin Makijev. ");
INSERT INTO srponstl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","To su imena ljudi koje je Mojsije poslao da izvide zemlju. A Mojsije je prozvao Osiju, sina Navinovog, Isus. ");
INSERT INTO srponstl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Kad ih je poslao da izvide hanansku zemlju, Mojsije im je rekao: „Idite gore u Negev, pa se uspnite na gorje! ");
INSERT INTO srponstl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Izvidite kakva je zemlja, da li je narod koji živi u njoj jak ili slab, ima li ih malo ili mnogo. ");
INSERT INTO srponstl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Da li je zemlja u kojoj žive dobra ili loša? Da li su gradovi u kojima žive neograđeni ili utvrđeni? ");
INSERT INTO srponstl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Da li je zemlja plodna ili neplodna? Ima li u njoj drveća ili nema? Budite hrabri i donesite od plodova zemlje.“ A bilo je vreme ranog grožđa. ");
INSERT INTO srponstl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Tada su otišli i izvideli zemlju od pustinje Cin do Reova, kod Levo-Amata. ");
INSERT INTO srponstl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Popeli su se u Negev i došli u Hevron, gde su živeli Enakovi potomci Ahiman, Sesaj i Talmaj. (Hevron je bio izgrađen sedam godina pre egipatskog Soana.) ");
INSERT INTO srponstl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Kad su došli do potoka Eshola, odsekli su lozu s jednim grozdom, koji su dvojica nosila na motki, a poneli su i narova i smokava. ");
INSERT INTO srponstl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","To mesto se prozvalo potok Eshol zbog grozda koji su tamo Izrailjci odsekli. ");
INSERT INTO srponstl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Iz izviđanja zemlje su se vratili posle četrdeset dana. ");
INSERT INTO srponstl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Po povratku su otišli k Mojsiju, Aronu i svoj izrailjskoj zajednici u Kadis u Faranskoj pustinji, i doneli izveštaj njima i svoj zajednici, a pokazali su im i plodove zemlje. ");
INSERT INTO srponstl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ispričali su mu: „Otišli smo u zemlju u koju si nas poslao, i zaista u njoj teku med i mleko. Ovo su njeni plodovi! ");
INSERT INTO srponstl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ali narod koji živi u zemlji je moćan, a gradovi su utvrđeni i veoma veliki. Tamo smo videli i Enakove potomke. ");
INSERT INTO srponstl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","U Negevu žive Amaličani, a u gorju žive Hetiti, Jevusejci i Amorejci. Hananci žive uz more i uz Jordan.“ ");
INSERT INTO srponstl_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Tada Halev utiša narod pred Mojsijem i reče: „Hajde, pođimo gore i osvojimo je, jer je možemo savladati!“ ");
INSERT INTO srponstl_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ali ljudi koji su otišli gore s njim rekoše: „Ne možemo ići gore na onaj narod, jer je jači od nas!“ ");
INSERT INTO srponstl_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Tako su među Izrailjcima raširili nepovoljan izveštaj o zemlji koju su izviđali, govoreći: „Zemlja kroz koju smo prošli da je izvidimo je zemlja koja proždire svoje stanovnike, a sav narod koji smo videli u njoj je gorostasan! ");
INSERT INTO srponstl_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Tamo smo videli i Nefilime – Enakovce divovskog porekla. Činilo nam se da smo prema njima kao skakavci, a tako se i njima činilo.“ ");
INSERT INTO srponstl_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Na to se sva zajednica uzbunila i udarila u viku; i narod je plakao one noći. ");
INSERT INTO srponstl_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Svi su Izrailjci gunđali protiv Mojsija i Arona; sva im je zajednica govorila: „E, da smo samo pomrli u Egiptu, ili u pustinji! ");
INSERT INTO srponstl_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Zašto nas Gospod vodi u ovu zemlju? Da poginemo od mača, a naše žene i deca da postanu roblje? Nije li bolje za nas da se vratimo u Egipat?“ ");
INSERT INTO srponstl_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Tada rekoše jedan drugom: „Hajde da postavimo vođu i vratimo se u Egipat!“ ");
INSERT INTO srponstl_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mojsije i Aron padoše ničice pred svom izrailjskom zajednicom. ");
INSERT INTO srponstl_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Tada su Isus, sin Navinov, i Halev, sin Jefonijin, koji su bili među onima što su uhodili zemlju, razderali svoju odeću ");
INSERT INTO srponstl_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","i rekli svoj izrailjskoj zajednici: „Zemlja kroz koju smo prošli da je izvidimo izvanredno je lepa zemlja! ");
INSERT INTO srponstl_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ako budemo ugodni Gospodu, on će nas uvesti u ovu zemlju i dati nam je. To je zemlja u kojoj teku med i mleko. ");
INSERT INTO srponstl_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Samo se ne bunite protiv Gospoda. Ne bojte se naroda zemlje, jer su za nas kao zalogaj hleba; njih nema ko da zaštiti, a s nama je Gospod. Ne bojte se!“ ");
INSERT INTO srponstl_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Međutim, sva je zajednica pretila da će ih kamenovati. Tada se slava Gospodnja ukazala svim Izrailjcima kod Šatora od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Gospod reče Mojsiju: „Dokle će me prezirati ovaj narod? Dokle će odbijati da mi veruju uprkos svih znakova koje sam učinio među njima? ");
INSERT INTO srponstl_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Udariću ih pomorom i zatrti ih, a od tebe ću učiniti narod veći i moćniji od njih.“ ");
INSERT INTO srponstl_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ali Mojsije reče Gospodu: „Kad to čuju Egipćani između kojih si izveo ovaj narod svojom silom, ");
INSERT INTO srponstl_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","oni će to reći stanovnicima ove zemlje. A oni su čuli da si ti, Gospode, usred ovoga naroda; da im se ti, Gospode, ukazuješ licem u lice, i da tvoj oblak stoji nad njima; da ideš pred njima, danju u stubu od oblaka, a noću u stubu od ognja. ");
INSERT INTO srponstl_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ako pobiješ ovaj narod do poslednjeg, onda će narodi, koji su čuli za tvoje ime, reći: ");
INSERT INTO srponstl_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","’Gospod nije mogao da dovede ovaj narod u zemlju koju im je uz zakletvu obećao, pa ih je zato pobio u pustinji.’ ");
INSERT INTO srponstl_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","A sad, Gospode, neka se pokaže tvoja sila, kao što si obećao, rekavši: ");
INSERT INTO srponstl_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","’Gospod je spor na srdžbu, bogat milošću, oprašta krivicu i prestup, ali krivca ne ostavlja nekažnjena, nego kažnjava nepravdu otaca na njihovoj deci i unucima sve do trećeg i četvrtog kolena.’ ");
INSERT INTO srponstl_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Oprosti krivicu ovom narodu po velikoj tvojoj milosti, kao što si mu opraštao od Egipta pa do sada.“ ");
INSERT INTO srponstl_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Gospod reče: „Opraštam po tvojoj reči. ");
INSERT INTO srponstl_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ali, tako mi života, i tako slava Gospodnja ispunila svu zemlju, ");
INSERT INTO srponstl_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ni jedan od ljudi koji su videli moju slavu i znakove koje sam učinio u Egiptu i u pustinji, a koji su me iskušavali deset puta i bili neposlušni mome glasu, ");
INSERT INTO srponstl_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","neće videti zemlju koju sam uz zakletvu obećao njihovim ocima. Ni jedan od tih što su me prezreli neće je videti. ");
INSERT INTO srponstl_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","A svoga slugu Haleva – zato što je drugačijeg duha i zato što se potpuno pouzdao u mene – njega ću odvesti u zemlju u koju je otišao, i njegovi će je potomci dobiti u posed. ");
INSERT INTO srponstl_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Pošto Amaličani i Hananci žive u dolini, sutra se vratite i idite u pustinju prema Crvenom moru.“ ");
INSERT INTO srponstl_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Zatim Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","„Dokle će ova opaka zajednica da gunđa protiv mene? Čuo sam prigovore Izrailjaca, koji gunđaju protiv mene. ");
INSERT INTO srponstl_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Reci im: ’Tako mi moga života – govori Gospod – učiniću vam ono što ste mi rekli na moje uši. ");
INSERT INTO srponstl_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Vaša će mrtva tela popadati po ovoj pustinji, svi vi koji ste uvedeni u razne popise, od dvadeset godina pa naviše, vi koji ste gunđali protiv mene; ");
INSERT INTO srponstl_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ni jedan od vas neće ući u zemlju za koju sam se uz podignutu ruku zakleo da ću vas naseliti u njoj, osim Haleva, sina Jefonijinog i Isusa, sina Navinovog. ");
INSERT INTO srponstl_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ipak, vašu decu, za koju ste rekli da će postati roblje, njih ću uvesti da upoznaju zemlju koju ste vi prezreli. ");
INSERT INTO srponstl_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","A vaša mrtva tela će popadati po ovoj pustinji. ");
INSERT INTO srponstl_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Vaša deca će biti pastiri u pustinji četrdeset godina i ispaštati zbog vašeg neverstva, dok vaša tela do poslednjeg ne propadaju mrtva u pustinji. ");
INSERT INTO srponstl_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ispaštaćete svoje krivice četrdeset godina, prema broju dana – četrdeset dana tokom kojih ste izviđali zemlju, za svaki dan po godinu. Tako ćete znati šta znači protiviti mi se.’ ");
INSERT INTO srponstl_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","To sam ja, Gospod, rekao, i ja ću to jamačno učiniti svoj ovoj opakoj zajednici koja se urotila protiv mene. U ovoj pustinji će skončati; tu će pomreti. ");
INSERT INTO srponstl_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","A ljudi koje je Mojsije poslao da izvide zemlju, i koji su se vratili i izazvali svu zajednicu da gunđa protiv njega donevši nepovoljan izveštaj o zemlji, ");
INSERT INTO srponstl_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","isti ti ljudi koji su doneli nepovoljan izveštaj o zemlji, pomrli su od pošasti pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Od tih ljudi koji su išli da izvide zemlju, preživeli su samo Isus, sin Navinov, i Halev, sin Jefonijin.“ ");
INSERT INTO srponstl_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Kad je Mojsije izgovorio ove reči svem izrailjskom narodu, narod se veoma ožalostio. ");
INSERT INTO srponstl_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ali u rano jutro oni ustanu i počnu da se penju na vrh gorja, govoreći: „Zgrešili smo, ali evo, idemo na mesto o kome je Gospod govorio.“ ");
INSERT INTO srponstl_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mojsije im reče: „Zašto prestupate zapovest Gospodnju? To neće uspeti. ");
INSERT INTO srponstl_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ne penjite se, jer Gospod nije među vama; inače ćete biti potučeni od svojih neprijatelja! ");
INSERT INTO srponstl_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Naime, ispred vas su Amaličani i Hananci, pa ćete izginuti od mača. Odvratili ste se od Gospoda, i zato Gospod neće biti s vama.“ ");
INSERT INTO srponstl_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ali oni prkosno nastaviše da se penju na vrh gorja, iako ni Mojsije, ni Kovčeg Gospodnjeg saveza, nisu pošli iz tabora. ");
INSERT INTO srponstl_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Tada su sišli Amaličani i Hananci koji su živeli u gorju, i potukli ih, goneći ih sve do Orme. ");
INSERT INTO srponstl_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","„Govori Izrailjcima. Reci im: ’Kad uđete u zemlju koju vam dajem da se u njoj naselite, ");
INSERT INTO srponstl_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","pa budete hteli da prinesete paljenu žrtvu Gospodu od krupne ili sitne stoke na ugodan miris Gospodu, bilo žrtvu svespalnicu ili žrtvu radi ispunjenja zaveta, ili dobrovoljnu žrtvu, ili u vreme praznika, ");
INSERT INTO srponstl_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","onaj ko prinosi prinos Gospodu, neka prinese i žitnu žrtvu, jednu desetinu efe brašna umešenog sa četvrtinom hina ulja. ");
INSERT INTO srponstl_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Za svako jagnje koje se prinosi na žrtvu svespalnicu ili neku drugu žrtvu, prinesi i četvrtinu hina vina za žrtvu izlivnicu. ");
INSERT INTO srponstl_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Za ovna, prinesi žitnu žrtvu od dve desetine efe brašna umešenog s jednom trećinom hina ulja, ");
INSERT INTO srponstl_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","a za žrtvu izlivnicu prinesi jednu trećinu hina vina na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Kad prinosiš Gospodu junca na žrtvu svespalnicu, bilo kao žrtvu za ispunjenje zaveta, ili kao žrtvu mira, ");
INSERT INTO srponstl_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","uz junca prinesi i žitnu žrtvu od tri desetine efe brašna zamešenog s pola hina ulja. ");
INSERT INTO srponstl_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Za žrtvu izlivnicu prinesi pola hina vina na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Tako treba učiniti sa svakim volom i ovnom, i sa svakim živinčetom, jagnjetom ili jaretom. ");
INSERT INTO srponstl_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Koliko god da ih prinesete, tako učinite sa svakim, koliko god da ih ima. ");
INSERT INTO srponstl_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Neka svako ko je rođen u zemlji postupi ovako kad prinosi paljenu žrtvu na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ako se stranac doseli k vama, ili se trajno nastani među vama, i hoće da prinese paljenu žrtvu na ugodni miris Gospodu, neka je prinese onako kako je vi prinosite. Ista je uredba i za vas i za stranca. ");
INSERT INTO srponstl_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","To je trajna uredba za vaše naraštaje. I vi i stranci bićete jednaki pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Isti zakon i isti propis važiće i za vas i za stranca koji boravi među vama.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","„Govori Izrailjcima. Reci im: ’Kad budete ušli u zemlju u koju vas vodim, ");
INSERT INTO srponstl_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","i budete jeli hleb te zemlje, prinesite prinos Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Od prvine testa prinesite prinos u vidu kolača; prinesite ga kao što se prinosi prinos s gumna. ");
INSERT INTO srponstl_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Prinosite Gospodu prinos od prvine testa od naraštaja do naraštaja. ");
INSERT INTO srponstl_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Ali ako nehotice zgrešite, pa ne izvršite sve ove zapovesti koje je Gospod dao Mojsiju; ");
INSERT INTO srponstl_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","sve što vam je Gospod zapovedio preko Mojsija, od dana kada vam je Gospod dao zapovest za sve vaše naraštaje, do sad, ");
INSERT INTO srponstl_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ukoliko je učinjeno nehotice, bez znanja zajednice, neka sva zajednica prinese od krupne stoke jednog junca kao žrtvu svespalnicu na ugodan miris Gospodu, zajedno sa žitnom žrtvom i žrtvom izlivnicom, po propisu, i jednog jarca za žrtvu za greh. ");
INSERT INTO srponstl_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Sveštenik neka izvrši obred otkupljenja za svu izrailjsku zajednicu i biće im oprošteno; greh, naime, nije bio učinjen namerno, a oni su prineli svoju žrtvu – paljenu žrtvu Gospodu – i žrtvu za greh radi svoje greške. ");
INSERT INTO srponstl_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Tako će biti oprošteno svoj izrailjskoj zajednici i svakom strancu koji je među njima, jer je sav narod nehotice zgrešio. ");
INSERT INTO srponstl_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Ako neko nehotice zgreši, neka prinese jedno žensko jare od godinu dana kao žrtvu za greh. ");
INSERT INTO srponstl_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Zatim neka sveštenik izvrši obred otkupljenja pred Gospodom za onoga ko je nehotice zgrešio, jer je nenamerno zgrešio; kad izvrši obred otkupljenja za njega, biće mu oprošteno. ");
INSERT INTO srponstl_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Bilo da se radi o Izrailjcu rođenom u zemlji ili o strancu među njima, isti zakon važi za svakog ko nehotice zgreši. ");
INSERT INTO srponstl_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ako neko iz prkosa uvredi Gospoda, bilo da je rođen u zemlji ili je stranac, neka se takav istrebi iz svoga naroda. ");
INSERT INTO srponstl_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Pošto je prezreo Gospodnju reč i prekršio njegovu zapovest, neka se takav čovek istrebi; njegova krivica ostaće na njemu.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Dok su Izrailjci bili u pustinji, našli su čoveka koji je skupljao granje na subotnji dan. ");
INSERT INTO srponstl_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Oni koji su ga našli da skuplja granje odveli su ga pred Mojsija, Arona i svu zajednicu. ");
INSERT INTO srponstl_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Stavili su ga pod stražu, jer još nije bilo jasno kako treba postupiti s njim. ");
INSERT INTO srponstl_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Gospod reče Mojsiju: „Neka se čovek svakako pogubi. Neka ga sva zajednica zaspe kamenjem izvan tabora.“ ");
INSERT INTO srponstl_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Tada ga je sva zajednica izvela izvan tabora i zasula ga kamenjem, te je umro, kao što je Gospod rekao Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","„Govori Izrailjcima. Reci im neka prave rese na skutima svoje odeće, od naraštaja do naraštaja, a na resu svakog skuta neka privezuju ljubičastu vrpcu. ");
INSERT INTO srponstl_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Imaćete resu da se, kad je vidite, setite svih Gospodnjih zapovesti i vršite ih, kako ne biste sledili svoje srce i svoje oči, koje vas navode na neverstvo. ");
INSERT INTO srponstl_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Tada ćete se sećati svih mojih zapovesti i vršiti ih, pa ćete biti sveti svom Bogu. ");
INSERT INTO srponstl_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ja sam Gospod, Bog vaš, koji sam vas izveo iz Egipta, da vam budem Bog. Ja sam Gospod, Bog vaš!“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","A Korej, sin Isarov, sin Katov, sin Levijev, Datan i Aviron, sinovi Elijavovi, i Avnan, sin Faletov, sin Ruvimov, ");
INSERT INTO srponstl_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","se pobuniše protiv Mojsija. S njima je bilo i dve stotine pedeset Izrailjaca, knezova zajednice, uglednih ljudi, koje je izabrala zajednica. ");
INSERT INTO srponstl_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Okupe se oni protiv Mojsija i Arona i kažu im: „Prevršili ste meru! Sva je zajednica sveta, svaki od njih, a Gospod je među njima. Vi se postavljate iznad Gospodnje zajednice!“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Kad je Mojsije to čuo, pao je ničice. ");
INSERT INTO srponstl_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Zatim je rekao Koreju i svoj njegovoj zajednici: „Ujutro će Gospod obznaniti ko je njegov i ko je svet, i kome dopušta da stupi pred njega. Onaj koga izabere, tome će dopustiti da stupa pred njega. ");
INSERT INTO srponstl_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Neka Korej i sva njegova zajednica urade ovo: uzmite kadionice, ");
INSERT INTO srponstl_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","pa sutra u njih stavite vatru, a na nju stavite kad pred Gospodom. Čovek koga Gospod izabere, taj će biti svet. Vi ste prevršili meru, sinovi Levijevi!“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Zatim Mojsije reče Koreju: „Čujte, sinovi Levijevi! ");
INSERT INTO srponstl_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Zar vam je malo što vas je Bog Izrailjev izdvojio iz sve Izrailjeve zajednice i dopustio da stupate pred njega, da obavljate službu u Gospodnjem Prebivalištu, i da stojite pred zajednicom i služite joj? ");
INSERT INTO srponstl_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","On je dozvolio tebi i svoj tvojoj braći sa tobom, sinovima Levijevim, da stupate pred njega, a vi još tražite i sveštenstvo. ");
INSERT INTO srponstl_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Stoga ste se ti i tvoja zajednica udružili protiv Gospoda; jer ko je Aron da gunđate protiv njega?“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Zatim je Mojsije poslao da pozovu Datana i Avirona, sina Elijavovog. Oni rekoše: „Mi nećemo doći gore. ");
INSERT INTO srponstl_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Nije li dovoljno što si nas izveo iz zemlje u kojoj teku med i mleko da nas pomoriš u pustinji, nego još hoćeš i da gospodariš nad nama? ");
INSERT INTO srponstl_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Osim toga, nisi nas doveo u zemlju u kojoj teku med i mleko, i nisi nam dao u posed njive i vinograde. Šta hoćeš? Da prevedeš ove ljude žedne preko vode? Nećemo doći gore.“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mojsije se vrlo naljuti i reče Gospodu: „Ne obaziri se na njihove prinose. Od njih nisam uzeo ni magarca, niti sam naudio kome od njih.“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","A Koreju Mojsije reče: „Pojavite se pred Gospodom, ti i tvoja zajednica. Budite sutra ovde ti, oni i Aron. ");
INSERT INTO srponstl_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Neka svaki uzme svoju kadionicu i u nju stavi kad, i prinese svoju kadionicu pred Gospoda, dve stotine pedeset kadionica. Ti i Aron uzmite svoje kadionice.“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Svaki čovek je uzeo svoju kadionicu i u nju stavio vatru i položio na nju kad. Zatim su stali na ulaz Šatora od sastanka sa Mojsijem i Aronom. ");
INSERT INTO srponstl_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kad je Korej okupio svu zajednicu na ulaz Šatora od sastanka, pojavila se slava Gospodnja svoj zajednici. ");
INSERT INTO srponstl_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Tada Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","„Odvojte se od ove zajednice, da ih dokrajčim za čas.“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ali oni padoše na zemlju i rekoše: „O, Bože duhova svih stvorenja, zar ćeš se razgneviti na svu zajednicu zato što je jedan čovek sagrešio?“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","„Reci zajednici: ’Odstupite od Korejevih, Datanovih, i Avironovih šatora.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mojsije ustane i ode k Datanu i Avironu; pratili su ga izrailjske starešine. ");
INSERT INTO srponstl_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Tada je rekao zajednici: „Odstupite od šatora ovih opakih ljudi, i ne dirajte ništa što im pripada, da ne izginete zbog njihovih greha.“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Tada su odstupili od šatora Koreja, Datana i Avirona. A Aviron i Datan su izašli i stali na ulaz svojih šatora sa svojim ženama, sinovima i malom decom. ");
INSERT INTO srponstl_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Tada Mojsije reče: „Ovako ćete znati da me je Gospod poslao da učinim sva ova dela, i da ih ne činim od svoje volje. ");
INSERT INTO srponstl_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ako ovi ljudi umru kao što svi ljudi umiru, te ih zadesi ono što zadesi sve ljude, onda me Gospod nije poslao. ");
INSERT INTO srponstl_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ali ako Gospod učini nešto neviđeno: ako zemlja otvori svoje ždrelo i proguta i njih i sve što je njihovo, pa živi siđu u Svet mrtvih, tada ćete znati da su ti ljudi prezreli Gospoda.“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Čim je izgovorio sve ove reči, rascepi se zemlja pod njima; ");
INSERT INTO srponstl_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","zemlja je otvorila svoje ždrelo i progutala i njih i njihove domove, sa svim Korejevim ljudima i svom njihovom imovinom. ");
INSERT INTO srponstl_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Tako su i oni i sve njihovo živi sišli u Svet mrtvih; zemlja se zatvorila nad njima, pa su nestali iz zbora. ");
INSERT INTO srponstl_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Sav se Izrailj, koji je bio oko njih, razbežao kad je čuo njihove krike, govoreći: „Bežimo, da i nas ne proguta zemlja!“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Tada je planuo oganj od Gospoda i proždro onih dve stotine pedeset ljudi, koji su prineli kad. ");
INSERT INTO srponstl_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Zatim Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","„Reci Eleazaru, sinu sveštenika Arona, da iz tog zgarišta izvadi kadionice – jer su posvećene – a vatru neka razbaca podalje. ");
INSERT INTO srponstl_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","A od kadionica ljudi koji su zgrešili po cenu svojih života, neka se iskuju pločice za oblaganje žrtvenika. Naime, prineli su ih pred Gospodom, pa su postale svete. Neka budu znak za Izrailjce.“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Sveštenik Eleazar je uzeo bronzane kadionice koje su prineli oni što su izgoreli, pa su ih iskovali u pločice za žrtvenik. ");
INSERT INTO srponstl_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","One su opomena Izrailjcima da niko neovlašćeni, koji nije od Aronovog potomstva, ne pristupa da prinese kad pred Gospodom, da ne bio prošao kao Korej i njegova zajednica, po reči koju mu je Gospod rekao preko Mojsija. ");
INSERT INTO srponstl_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ali već sledećeg dana, sav je izrailjski zbor gunđao protiv Mojsija i Arona. Govorili su: „Vi ste pobili narod Gospodnji!“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Dok se zbor sabirao protiv njih, Mojsije i Aron se okrenuše prema Šatoru od sastanka, kad gle, on pokriven oblakom i slava se Gospodnja pojavi. ");
INSERT INTO srponstl_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mojsije i Aron dođu pred Šator od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Tada Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","„Uklonite se od ove zajednice da ih istrebim za čas!“ Oni padoše ničice. ");
INSERT INTO srponstl_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mojsije reče Aronu: „Uzmi kadionicu i stavi u nju vatru sa žrtvenika, a na nju stavi kad, pa pohitaj k zajednici da izvršiš za nju obred otkupljenja, jer je planuo gnev Gospodnji; pomor je već počeo.“ ");
INSERT INTO srponstl_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aron uzme kadionicu, kao što mu je Mojsije rekao, i otrči usred zbora. A tamo, pomor već počeo među narodom. Tada je stavio kad i izvršio obred otkupljenja za narod. ");
INSERT INTO srponstl_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Stao je između mrtvih i živih i pošast je prestala. ");
INSERT INTO srponstl_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Od pošasti je pomrlo četrnaest hiljada sedam stotina, osim onih što su izginuli zbog Koreja. ");
INSERT INTO srponstl_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Pošto je pošast prestala, Aron se vratio k Mojsiju na ulaz Šatora od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Tada Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","„Govori Izrailjcima i uzmi od njih štapove prema njihovim otačkim domovima, po jedan štap od svakog kneza svoga otačkog doma – ukupno dvanaest štapova – i napiši ime svakog čoveka na njegovom štapu. ");
INSERT INTO srponstl_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Zatim napiši Aronovo ime na Levijevom štapu, jer na svaki otački dom ide po jedan štap. ");
INSERT INTO srponstl_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Stavi ih u Šator od sastanka pred Svedočanstvom, gde se sastajem sa vama. ");
INSERT INTO srponstl_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Kada štap onog čoveka koga je izaberem propupi, tada ću okončati gunđanje Izrailjaca protiv tebe.“ ");
INSERT INTO srponstl_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Mojsije je rekao Izrailjcima neka mu svi knezovi daju štap, za svakog kneza jedan štap prema njihovim otačkim domovima, ukupno dvanaest štapova. Aronov štap je bio među njihovim. ");
INSERT INTO srponstl_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mojsije položi štapove u Šator svedočanstva pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Sutradan, kad je Mojsije došao u Šator svedočanstva, a ono, Aronov štap iz Levijevog doma propupeo; poterali pupoljci, procvetali cvetovi i sazreli bademi. ");
INSERT INTO srponstl_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mojsije je izneo sve štapove koji su bili pred Gospodom i dao ih svim Izrailjcima. Svaki čovek je pogledao i uzeo svoj štap. ");
INSERT INTO srponstl_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Gospod reče Mojsiju: „Vrati Aronov štap u Svedočanstvo da se čuva kao opomena pobunjenicima. Tako će se okončati njihovo gunđanje protiv mene, pa neće izginuti.“ ");
INSERT INTO srponstl_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Kako mu je Gospod zapovedio, tako je Mojsije učinio. ");
INSERT INTO srponstl_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Tada Izrailjci rekoše Mojsiju: „Izgibosmo! Propadosmo! Svi propadosmo! ");
INSERT INTO srponstl_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ko god priđe Prebivalištu Gospodnjem, umreće! Zar ćemo izginuti do poslednjeg?“ ");
INSERT INTO srponstl_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Gospod reče Aronu: „Ti, tvoji sinovi i tvoj otački dom s tobom bićete odgovorni za krivice u Svetilištu. A ti i tvoji sinovi bićete odgovorni za krivice koje se tiču vašeg sveštenstva. ");
INSERT INTO srponstl_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Dovedi i svoju braću iz Levijevog plemena, tvog otačkog plemena, da ti se pridruže i da služe tebi i tvojim sinovima pred Šatorom svedočanstva. ");
INSERT INTO srponstl_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Oni će obavljati dužnosti za tebe i za sav Šator. Ipak, ne smeju prilaziti svetim stvarima i žrtveniku, da ne poginu i oni i vi. ");
INSERT INTO srponstl_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Neka ti se pridruže i obavljaju dužnosti u Šatoru od sastanka za celokupnu službu u Šatoru. Neovlašćeni neka vam ne prilaze. ");
INSERT INTO srponstl_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Obavljajte dužnosti u Svetinji i oko žrtvenika, da ne bi više dolazio gnev na Izrailjce. ");
INSERT INTO srponstl_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ja sam, evo, odvojio vašu braću Levite između Izrailjaca; njih sam vam dao na dar kao posvećene Gospodu da obavljaju službu u Šatoru od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","A vi i vaši sinovi pazite na svoje sveštenstvo u pogledu svih stvari koje se tiču žrtvenika i prostora iza zavese. Dajem vam na dar svešteničku službu. Ako neovlašćeni pristupi, neka se pogubi.“ ");
INSERT INTO srponstl_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Gospod reče Aronu: „Evo, predajem ti u dužnost moje prinose, sve svete prinose Izrailjaca. Dajem ih tebi i tvojim sinovima u deo; to je trajna uredba. ");
INSERT INTO srponstl_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ovo neka pripadne tebi od najsvetijih žrtava koje se pale: svaki njihov prinos, svaka njihova žrtva, svaka žrtva za greh i svaka žrtva za prestup, koja mi se prinosi kao najsvetija žrtva, neka pripadne tebi i tvojim sinovima. ");
INSERT INTO srponstl_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Jedite je na najsvetijem mestu; neka je jede svaki muškarac. Neka ti bude sveta! ");
INSERT INTO srponstl_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Neka i ovo bude tvoje: sve žrtve dizanice Izrailjaca koje oni prinose na dar, dajem tebi i tvojim sinovima s tobom; to je trajna uredba. Svako ko je čist u tvome domu može je jesti. ");
INSERT INTO srponstl_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Dajem ti i sve što je najbolje od ulja, vina i žita koje oni donose Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Prvi plodovi od svega što donose Gospodu s njihove zemlje biće tvoji. Svako ko je čist u tvome domu može da ih jede. ");
INSERT INTO srponstl_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","I sve što je posvećeno u Izrailju neka bude tvoje. ");
INSERT INTO srponstl_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Sve što se prvo rodi iz majčine utrobe, svako živo biće, čovek ili životinja, koje se prinosi Gospodu, biće tvoje. Ali prvenca, bilo od čoveka ili od životinje, moraš da otkupiš. Otkupi i prvinu nečistih životinja. ");
INSERT INTO srponstl_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Kad navrše mesec dana, otkupljuj ih po otkupnoj ceni od pet srebrnih šekela, prema hramskom šekelu, što je dvadeset gera. ");
INSERT INTO srponstl_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Međutim, ne otkupljuj prvenca od krave, ovce i koze; oni su posvećeni. Njihovom krvlju zapljusni žrtvenik, a njihovo salo spali kao paljenu žrtvu na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Njihovo meso neka pripadne tebi, kao i grudi žrtve dizanice i desna plećka. ");
INSERT INTO srponstl_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Sve svete prinose koje Izrailjci prinose Gospodu, dajem tebi i tvojim sinovima i ćerkama po trajnoj uredbi. To je večni savez potvrđen solju pred Gospodom, tebi i tvome potomstvu s tobom.“ ");
INSERT INTO srponstl_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Gospod reče Aronu: „Ti nećeš dobiti nasledstvo u njihovoj zemlji, niti ćeš dobiti deo među njima. Ja sam tvoj deo i tvoje nasledstvo među Izrailjcima. ");
INSERT INTO srponstl_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Levijevim potomcima dajem zauzvrat u nasledstvo desetinu od svega u Izrailju, radi njihove službe, službe koju vrše u Šatoru od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Zato neka Izrailjci ne pristupaju više Šatoru od sastanka, kako ne bi navukli na sebe greh, te izginuli. ");
INSERT INTO srponstl_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Leviti neka vrše službu u Šatoru od sastanka; ostali će navući na sebe krivicu. To je trajna uredba za njihove naraštaje među Izrailjcima. Ali, nasledstvo neće primiti u posed, ");
INSERT INTO srponstl_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","zato što Levitima dajem u nasledstvo desetinu od prinosa koje Izrailjci prinose na dar Gospodu. Zato sam rekao za njih: ’Oni neće dobiti nasledstvo meću Izrailjcima.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","„Govori Levitima i reci im: ’Kad primate od Izrailjaca desetinu koju sam vam od njih dao u nasledstvo, onda vi prinesite dar Gospodu: desetinu od desetine. ");
INSERT INTO srponstl_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","To će vam se računati u dar, isto kao žito sa gumna i vino iz muljare. ");
INSERT INTO srponstl_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Tako ćete i vi prinositi dar Gospodu od svih svojih desetina koje primate od Izrailjaca. Od njih ćete davati Gospodnji dar svešteniku Aronu. ");
INSERT INTO srponstl_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Od svih prinosa koje dobijate, prinesite Gospodu najbolji, najsvetiji deo.’ ");
INSERT INTO srponstl_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Reci im: ’Kad prinesete najbolji deo od njih, to će se Levitima računati isto kao i urod od gumna i urod od muljare. ");
INSERT INTO srponstl_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","To možete jesti na svakom mestu, vi i vaši ukućani, jer je to plata za vašu službu u Šatoru od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Kad prinesete najbolji deo od toga, nećete navući greh na sebe. Tako nećete oskrnaviti svete prinose Izrailjaca, i nećete izginuti.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","„Ovo je odredba zakona koju je Gospod zapovedio: reci Izrailjcima neka dovedu k tebi crvenu junicu, besprekornu, na kojoj nema mane, i na koju još nije bio stavljan jaram. ");
INSERT INTO srponstl_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Predaj je svešteniku Eleazaru. Neka je odvedu izvan tabora, pa neka je zakolju pred njim. ");
INSERT INTO srponstl_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Zatim neka Eleazar stavi nešto njene krvi na svoj prst i poškropi njome sedam puta u pravcu Šatora od sastanka. ");
INSERT INTO srponstl_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Potom neka junica bude spaljena na njegove oči; neka se spali njena koža, njeno meso, njena krv i njena balega. ");
INSERT INTO srponstl_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Onda neka sveštenik uzme nešto kedrovog drveta, izopa i skerletnog prediva, pa neka to baci u vatru. ");
INSERT INTO srponstl_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Neka sveštenik opere svoju odeću i svoje telo u vodi. Nakon toga, neka dođe u tabor. Ipak, sveštenik će biti nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Neka i onaj koji je obavio spaljivanje opere svoju odeću u vodi i opere svoje telo u vodi, i ostane nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Zatim neka jedan čist čovek skupi pepeo od junice i iznese ga izvan tabora, na čisto mesto, da se čuva za vodu očišćenja za Izrailjevu zajednicu; to je žrtva za greh. ");
INSERT INTO srponstl_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Onaj koji je skupljao juničin pepeo neka opere svoju odeću i bude nečist do večeri. To je trajna uredba i za Izrailjce i za stranca među njima. ");
INSERT INTO srponstl_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Svako ko dotakne mrtvo ljudsko telo biće nečist sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Taj neka se očisti vodom trećeg i sedmog dana. Ako se ne očisti trećeg i sedmog dana, neće biti čist. ");
INSERT INTO srponstl_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Svako ko dotakne leš preminulog čoveka, a ne očisti se, oskrnaviće Gospodnje Prebivalište. Takav čovek neka se istrebi iz Izrailja. Pošto nije bio poškropljen vodom očišćenja, nečist je, te njegova nečistoća ostaje na njemu. ");
INSERT INTO srponstl_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ovo je zakon kad čovek umre u šatoru: svako ko uđe u šator i svako ko je u šatoru biće nečist sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","I svaka otkrivena posuda koja nema poklopac na sebi biće nečista. ");
INSERT INTO srponstl_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ko god se nađe na otvorenom, pa dotakne ubijenog mačem, ili umrlog prirodnom smrću, ili dotakne ljudsku kost, ili grob, biće nečist sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Za onoga koji se oskrnavio, neka se odvadi malo pepela od spaljene žrtve za greh, i neka se u jednu posudu nalije na njega sveža voda. ");
INSERT INTO srponstl_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Zatim neka jedna čista osoba uzme izop, zamoči ga u vodu i poškropi šator i sve posuđe i sve osobe koje su tamo, ili onoga koji je dotaknuo kost, ili ubijenog, ili nekoga ko je umro prirodnom smrću, ili grob. ");
INSERT INTO srponstl_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Neka čista osoba poškropi oskrnavljenog trećeg i sedmog dana, koji će biti očišćen sedmog dana. Zatim neka opere svoju odeću, opere se vodom, i biće čist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","A čovek koji se oskrnavi, a ne očisti se, neka se istrebi iz zbora, jer je oskrnavio Svetilište Gospodnje. Pošto nije bio poškropljen vodom očišćenja, nečist je. ");
INSERT INTO srponstl_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","To će za njih biti večna uredba. Onaj ko škropi vodom očišćenja, neka opere svoju odeću, a onaj ko dotakne vodu očišćenja biće nečist do večeri. ");
INSERT INTO srponstl_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Sve što nečista osoba dotakne postaće nečisto, i osoba koja to dotakne biće nečista do večeri.“ ");
INSERT INTO srponstl_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Sva je zajednica Izrailjaca došla u pustinju Cin prvog meseca. Narod je boravio u Kadisu. Tamo je umrla Marija, i tamo su je sahranili. ");
INSERT INTO srponstl_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ali pošto nije bilo vode za zajednicu, oni su se okupili protiv Mojsija i Arona. ");
INSERT INTO srponstl_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Narod se prepirao s Mojsijem, govoreći: „Kamo sreće da smo izginuli kad su naša braća izginula pred Gospodom! ");
INSERT INTO srponstl_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Zašto ste doveli zbor Gospodnji u ovu pustinju? Da pomremo i mi i naša stoka? ");
INSERT INTO srponstl_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Zašto ste nas izveli iz Egipta? Da nas dovedete na ovo užasno mesto? Nema ovde ni žita, ni smokava, ni loze, ni narova, a nema ni vode za piće!“ ");
INSERT INTO srponstl_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mojsije i Aron napuste zbor i dođu na ulaz u Šator od sastanka, pa padnu ničice. Tada im se ukazala slava Gospodnja. ");
INSERT INTO srponstl_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","„Uzmi štap, i okupi zbor, ti i tvoj brat Aron, pa na njihove oči naredi steni da iz nje poteče voda. Tako ćeš iz stene izvesti vodu za njih i napojiti zajednicu i njihovu stoku.“ ");
INSERT INTO srponstl_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mojsije uzme štap pred Gospodom, kako mu je zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Kad su Mojsije i Aron okupili zbor pred stenom, Mojsije im reče: „Čujte, vi buntovnici! Hoćemo li vam izvesti vodu iz ove stene?“ ");
INSERT INTO srponstl_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Zatim Mojsije podiže ruku i dvaput udari svojim štapom po steni. Voda izbi u obilju, pa je pila i zajednica i njihova stoka. ");
INSERT INTO srponstl_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Tada Gospod reče Mojsiju i Aronu: „Zato što mi niste verovali, te niste objavili moju svetost pred očima Izrailjaca, nećete uvesti ovaj zbor u zemlju koju sam im dao.“ ");
INSERT INTO srponstl_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","To su vode Merive, gde su se Izrailjci svađali sa Gospodom, i gde je preko njih objavio svoju svetost. ");
INSERT INTO srponstl_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mojsije je iz Kadisa poslao glasnike caru Edoma: „Ovako kaže tvoj brat Izrailj: ’Ti znaš za sve nevolje koje su nas snašle. ");
INSERT INTO srponstl_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Naši preci su sišli u Egipat i živeli u njemu dugo vremena. Ali Egipćani su zlostavljali nas i naše pretke. ");
INSERT INTO srponstl_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","A kad smo zavapili Gospodu, on je čuo naš glas i poslao nam Anđela koji nas je izveo iz Egipta. Sad smo, evo, u Kadisu, gradu na rubu tvoga područja. ");
INSERT INTO srponstl_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Dopusti nam da prođemo kroz tvoju zemlju. Nećemo prolaziti preko vaših polja i kroz vaše vinograde, niti ćemo piti vodu iz vaših bunara. Ići ćemo carskim putem ne skrećući ni desno ni levo, dok ne prođemo kroz tvoje područje.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ali Edom odgovori: „Ne prelazi preko moje zemlje, da ne izađem pred tebe s mačem!“ ");
INSERT INTO srponstl_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Izrailjci mu odgovoriše: „Ići ćemo glavnim putem, i ako mi i naša stoka budemo pili tvoju vodu, platićemo. Samo ćemo proći pešice, ništa više.“ ");
INSERT INTO srponstl_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","„Ne prolazi!“ – odgovori on. Edom je izašao na njih sa silnom vojskom i jakim naoružanjem. ");
INSERT INTO srponstl_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Pošto je Edom odbio da dozvoli Izrailju da prođe kroz njegovo područje, Izrailj se okrenuo od njega. ");
INSERT INTO srponstl_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Potom je sva zajednica Izrailjaca otišla iz Kadisa i došla na goru Or. ");
INSERT INTO srponstl_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Na gori Or, na rubu edomske zemlje, Gospod reče Mojsiju i Aronu: ");
INSERT INTO srponstl_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","„Neka se Aron pridruži svome narodu, jer neće ući u zemlju koju sam dao Izrailjcima, zato što ste se pobunili protiv moje naredbe kod merivskih voda. ");
INSERT INTO srponstl_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Povedi Arona i njegovog sina Eleazara i izvedi ih na goru Or. ");
INSERT INTO srponstl_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Skini sa Arona njegovu odeću i obuci u nju njegovog sina Eleazara. A Aron neka se pridruži svome narodu; neka umre tamo.“ ");
INSERT INTO srponstl_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mojsije učini kako mu je Gospod zapovedio. Popeli su se na goru Or na oči cele zajednice. ");
INSERT INTO srponstl_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Tada je Mojsije skinuo sa Arona njegovu odeću i obukao u nju njegovog sina Eleazara. Aron je umro tamo na vrhu gore. Zatim su Mojsije i Eleazar sišli s gore. ");
INSERT INTO srponstl_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Kad je sva zajednica videla da je Aron izdahnuo, sav je dom Izrailjev oplakivao Arona trideset dana. ");
INSERT INTO srponstl_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kad je car Arada, Hananac koji je živeo u Negevu, čuo da Izrailj dolazi iz pravca Atarina, napao je Izrailjce i zarobio neke od njih. ");
INSERT INTO srponstl_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Tada se Izrailj zavetovao Gospodu, rekavši: „Ako predaš ovaj narod u naše ruke, izručićemo njegove gradove kletom uništenju.“ ");
INSERT INTO srponstl_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Gospod je uslišio Izrailjev glas i predao im Hanance. Izručili su kletom uništenju i njih i njihove gradove. Zato se to mesto prozvalo Orma. ");
INSERT INTO srponstl_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Sa gore Or su se zaputili putem prema Crvenom moru, da bi zaobišli edomsku zemlju. Ali narod je na putu postao nestrpljiv. ");
INSERT INTO srponstl_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Tada je narod rekao protiv Boga i protiv Mojsija: „Zašto ste nas izveli iz Egipta? Da pomremo u pustinji? Jer nema ni hleba ni vode, a ova jadna hrana nam se ogadila.“ ");
INSERT INTO srponstl_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Tada je Gospod poslao na narod otrovne zmije; one su ih ujedale, pa je pomrlo mnogo naroda u Izrailju. ");
INSERT INTO srponstl_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Narod je došao k Mojsiju i rekao: „Zgrešili smo kad smo govorili protiv Gospoda i protiv tebe. Pomoli se Gospodu da ukloni zmije od nas!“ Mojsije se pomolio za narod. ");
INSERT INTO srponstl_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Gospod reče Mojsiju: „Napravi zmiju otrovnicu i postavi je na stub. Bude li ko ujeden, neka pogleda na nju i preživeće.“ ");
INSERT INTO srponstl_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Mojsije napravi bronzanu zmiju i postavi je na stub. I kad bi zmija ujela nekog, taj bi pogledao u zmiju i ozdravio. ");
INSERT INTO srponstl_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Izrailjci su nastavili i utaborili se u Ovotu. ");
INSERT INTO srponstl_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Napustivši Ovot, utaborili su se kod Ije-Avarima, u pustinji nasuprot Moava, prema istoku. ");
INSERT INTO srponstl_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Odande su otišli i utaborili se kod potoka Zareda. ");
INSERT INTO srponstl_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Kad su otišli odande, utaborili su se na drugoj strani Arnona, koji je u pustinji i izvire na amorejskoj međi. Naime, Arnon je moavska granica, između Moavaca i Amorejaca. ");
INSERT INTO srponstl_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Zato se kaže u Knjizi Gospodnjih ratova: „Vajev kod Sufe i arnonski potoci, ");
INSERT INTO srponstl_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","s pritokama što dopiru do mesta Ara, i naslanjaju se na moavsku granicu.“ ");
INSERT INTO srponstl_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Odande odu do Vira, bunara gde je Gospod rekao Mojsiju: „Okupi narod da im dam vodu.“ ");
INSERT INTO srponstl_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Tada je Izrailj zapevao ovu pesmu: „Pokuljaj, bunare! Zapojte mu: ");
INSERT INTO srponstl_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Bunar su knezovi iskopali, izdubili ga velikaši narodni, žezlom i štapovima svojim.“ Iz pustinje odoše u Mantanain, ");
INSERT INTO srponstl_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","iz Mantanaina u Nahaliel, a iz Nahaliela u Vamot; ");
INSERT INTO srponstl_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","iz Vamota u dolinu što je u moavskoj zemlji, kod vrhunca Fasge što se nadvija nad pustarom. ");
INSERT INTO srponstl_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Izrailj je poslao glasnike Sihonu, amorejskom caru, s porukom: ");
INSERT INTO srponstl_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","„Dozvoli mi da prođem kroz tvoju zemlju. Nećemo skretati ni u polja ni u vinograde, i nećemo piti vodu iz bunara, nego ćemo ići carskim putem, dok ne prođemo tvoje područje.“ ");
INSERT INTO srponstl_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Međutim, Sihon nije dozvolio Izrailju da prođe kroz njegovo područje. Sihon je skupio sav svoj narod i izašao da presretne Izrailja u pustinji. Kad je došao do Jase, stupio je u boj protiv Izrailja. ");
INSERT INTO srponstl_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Izrailj ga je potukao oštrim mačem i osvojio njegovu zemlju od Arnona do Javoka, sve do Amonaca, jer je amonska granica bila utvrđena. ");
INSERT INTO srponstl_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Izrailj je zauzeo sve te gradove i nastanio se u svim amorejskim gradovima, Esevonu i svim njegovim selima. ");
INSERT INTO srponstl_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","A Esevon je bio grad amorejskog cara Sihona, koji je ratovao protiv pređašnjeg moavskog cara, od koga je oduzeo svu njegovu zemlju sve do Arnona. ");
INSERT INTO srponstl_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Zato pesnici kažu: „Dođite u Esevon da se podigne i utvrdi Sihonov grad! ");
INSERT INTO srponstl_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Jer suknu oganj iz Esevona, plamen iz grada Sihonovog, te proguta Ar moavski i stanovnike visina arnonskih. ");
INSERT INTO srponstl_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Teško tebi, Moave, propao si, narode Hamosov. Svoje je sinove učinio izbeglicama, a ćerke svoje zatočenicama Sihona, cara amorejskog. ");
INSERT INTO srponstl_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","I potukosmo ih; propade Esevon sve do Devona, opustošismo ih do Nofa što se pruža do Medeve.“ ");
INSERT INTO srponstl_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Tako se Izrailj nastanio u amorejskoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Nakon što je Mojsije poslao ljude da izvide Jazir, Izrailjci su osvojili njegova sela i izgnali Amorejce koji su tamo živeli. ");
INSERT INTO srponstl_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Potom su se okrenuli i krenuli gore putem za Vasan. Tada je Og, vasanski car, i sav njegov narod izašao protiv njih u boj kod Edrajina. ");
INSERT INTO srponstl_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Gospod reče Mojsiju: „Ne boj ga se, jer sam u tvoje ruke predao i njega, i sav njegov narod, i njegovu zemlju. Učini s njim kao što si učinio s amorejskim carem Sihonom, koji je živeo u Esevonu.“ ");
INSERT INTO srponstl_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Tada su potukli njega, njegove sinove i sav njegov narod, tako da mu nije ostao nijedan preživeli; a njegovu zemlju su zaposeli. ");
INSERT INTO srponstl_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Izrailjci su nastavili put. Utaborili su se na moavskim poljanama na drugoj strani Jordana nasuprot Jerihona. ");
INSERT INTO srponstl_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","A Valak, sin Seforov, je video sve što je Izrailj učinio Amorejcima. ");
INSERT INTO srponstl_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moava je obuzeo veliki strah od naroda, jer je bio mnogobrojan; Moava je obuzeo užas pred Izrailjcima. ");
INSERT INTO srponstl_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moavci rekoše madijanskim starešinama: „Ova rulja će obrstiti sve oko nas, kao što vo obrsti poljsku travu.“ Valak, sin Seforov, je u to vreme bio car Moava. ");
INSERT INTO srponstl_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Tada je poslao glasnike Valamu, sinu Veorovom, u Fatur, koji je kod Eufrata, u zemlju svoga naroda, da ga pozovu. Rekao je: „Evo, izašao je jedan narod iz Egipta i prekrio zemlju; živi tu, nasuprot mene. ");
INSERT INTO srponstl_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Dođi stoga i prokuni mi ovaj narod, jer je moćniji od mene, pa ću možda moći da ga savladam i isteram iz zemlje. Znam, naime, da koga ti blagosloviš, taj je blagosloven, a koga prokuneš, taj je proklet.“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Odu moavske i madijanske starešine noseći sa sobom nagradu za vračanje. Kad su došli Valamu, preneli su mu Valakove reči. ");
INSERT INTO srponstl_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","On im reče: „Prenoćite ovde, a ja ću vam odgovoriti onako kako mi Gospod bude rekao.“ Tako su moavski knezovi ostali sa Valamom. ");
INSERT INTO srponstl_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Bog dođe k Valamu i reče mu: „Ko su ovi ljudi s tobom?“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Valam odgovori Bogu: „Moavski car Valak, sin Seforov, poslao mi je ovu poruku: ");
INSERT INTO srponstl_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","’Evo, izašao je jedan narod iz Egipta i prekrio zemlju. Stoga, dođi i prokuni mi ih, pa ću možda moći da ih savladam i isteram.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Međutim, Bog odgovori Valamu: „Ne idi s njima! Ne proklinji taj narod, jer je blagosloven.“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ujutro Valam ustade i reče Valakovim knezovima: „Vratite se u svoju zemlju, jer je Gospod odbio da me pusti da pođem s vama.“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Knezovi Moava su ustali, vratili se Valaku i rekli mu: „Valam je odbio da pođe s nama.“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Valak je ponovo poslao knezove, brojnije i uglednije od prvih. ");
INSERT INTO srponstl_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Dođu oni k Valamu i poruče mu: „Govori Valak, sin Seforov: ’Nemoj oklevati da dođeš k meni, ");
INSERT INTO srponstl_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","jer ću te bogato nagraditi. Učiniću sve što mi kažeš, samo dođi i prokuni mi ovaj narod.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Valam odgovori Valakovim slugama: „Da mi Valak da i punu kuću srebra i zlata, ne bih mogao da prekršim zapovest Gospoda, Boga moga; ništa ne mogu da učinim, ni veliko ni malo. ");
INSERT INTO srponstl_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","A sad prenoćite i vi ovde, da vidim šta će mi još Gospod kazati.“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Bog dođe noću k Valamu i reče mu: „Ako su ovi ljudi došli da te pozovu, ustani i idi s njima, ali čini samo ono što ti zapovedim.“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ujutro Valam ustane, osedla svoju magaricu i ode sa moavskim knezovima. ");
INSERT INTO srponstl_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ali Bog se veoma razgnevio zato što je otišao. Dok je Valam jahao svoju magaricu u pratnji dvojice svojih slugu, na put mu se postavio Anđeo Gospodnji da ga spreči ");
INSERT INTO srponstl_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Kad je magarica ugledala Anđela Gospodnjeg kako stoji na putu sa isukanim mačem u ruci, skrenula je s puta i krenula preko polja. Valam je počeo da tuče magaricu da je vrati na put. ");
INSERT INTO srponstl_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Zatim je Anđeo Gospodnji stao na uzak put između vinograda, s ogradama s jedne i druge strane. ");
INSERT INTO srponstl_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","No, kad je magarica ugledala Anđela Gospodnjeg, pribila se uz zid i prignječila Valamovu nogu. On je opet istuče. ");
INSERT INTO srponstl_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Anđeo Gospodnji opet pođe ispred i stane u tesnac, gde se nije moglo skrenuti ni desno ni levo. ");
INSERT INTO srponstl_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Magarica je videla Anđela Gospodnjeg, pa je legla pod Valamom. Valam se toliko razgnevio da je počeo da je tuče štapom. ");
INSERT INTO srponstl_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Tada je Gospod otvorio usta magarici i ona reče Valamu: „Šta sam ti učinila da si me tako istukao tri puta?“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Valam odgovori: „To je zato što praviš budalu od mene! Da imam mač pri sebi, odmah bih te ubio!“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Magarica reče Valamu: „Nisam li ja tvoja magarica koju si oduvek jahao sve do danas? Jesam li ti ikada činila ovako nešto?“ On odgovori: „Nisi.“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Tada je Gospod otvorio Valamove oči. Kad je video Anđela kako stoji na putu sa isukanim mačem u ruci, poklonio se licem do zemlje. ");
INSERT INTO srponstl_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Anđeo Gospodnji mu reče: „Zašto si tri puta istukao magaricu? Evo, to sam ja sam izašao da te zaustavim, jer je tvoj put poguban preda mnom. ");
INSERT INTO srponstl_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Magarica me je videla, pa se okrenula od mene tri puta. Da se nije uklanjala od mene, zaista bih te ubio, a nju bih ostavio u životu.“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Valam odgovori Anđelu Gospodnjem: „Zgrešio sam. Nisam, naime, znao da ti stojiš na putu da me zaustaviš. Stoga, ako je to zlo u tvojim očima, ja ću se vratiti.“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Anđeo Gospodnji odgovori Valamu: „Idi sa tim ljudima, ali govori samo ono što ti kažem.“ Tako je Valam otišao sa Valakovim knezovima. ");
INSERT INTO srponstl_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Kad je Valak čuo da je Valam došao, izašao je da ga dočeka u moavskom gradu koji se nalazi kod Arnona, na samoj granici. ");
INSERT INTO srponstl_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Valak reče Valamu: „Zar nisam slao glasnike da te pozovu? Zašto mi nisi došao? Zar nisam u stanju da te bogato nagradim?“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Valam odgovori Valaku: „Evo, došao sam k tebi. Ali zar ja mogu da kažem bilo šta? Govoriću samo ono što mi Bog stavi na jezik.“ ");
INSERT INTO srponstl_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Valam ode sa Valakom. Došli su u Kirijat-Uzot. ");
INSERT INTO srponstl_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Tada je Valak prineo na žrtvu krupnu i sitnu stoku, pa je od toga poslao Valamu i knezovima, koji su bili s njim. ");
INSERT INTO srponstl_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Sledećeg jutra je poveo Valama i doveo ga na Vamot-Val, odakle je mogao da vidi jedan deo naroda. ");
INSERT INTO srponstl_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Valam reče Valaku: „Podigni mi ovde sedam žrtvenika i pripremi mi sedam junaca i sedam ovnova.“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Valak učini onako kako mu je Valam rekao. Zatim su Valak i Valam prineli na žrtveniku jednog junca i jednog ovna. ");
INSERT INTO srponstl_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Valam reče Valaku: „Ostani kod svoje svespalnice, a ja ću poći; možda će se Gospod sresti sa mnom, pa šta mi kaže, to ću govoriti.“ Tako ode on na uzvišicu. ");
INSERT INTO srponstl_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Gospod je sreo Valama, i Valam mu je rekao: „Pripremio sam sedam žrtvenika i na svakom žrtveniku prineo jednog junca i jednog ovna.“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Tada Gospod stavi reč u Valamova usta i reče: „Vrati se Valaku i govori tako.“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Kad se vratio Valaku, ovaj je stajao kod svoje svespalnice sa svim moavskim knezovima. ");
INSERT INTO srponstl_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Tada Valam izreče svoju priču: „Iz Arama me Valak dovede, car moavski iz gorja istočnog: ’Dođi – reče – Jakova mi prokuni, dođi i Izrailj prezri!’ ");
INSERT INTO srponstl_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Kako da prokunem koga Bog ne proklinje, i prezrem koga Gospod ne prezire? ");
INSERT INTO srponstl_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Jer gledam ga s planinskih vrhova, posmatram ga s gorskih uzvišenja; gle naroda koji živi izdvojeno, među narode on se ne računa. ");
INSERT INTO srponstl_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ko će izbrojiti prah Jakovljev, ko da izbroji četvrtinu Izrailja? O, kad bih umro smrću pravedničkom, kad bi i moj kraj bio kao njihov!“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Tada Valak reče Valamu: „Šta si mi to učinio? Doveo sam te da prokuneš moje neprijatelje, a ti si ih obilno blagoslovio.“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Valam odgovori: „Zar da ne kažem verno ono što mi je Gospod stavio u usta?“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Valak mu reče: „Pođi sa mnom na drugo mesto; odatle ćeš videti samo jedan njegov deo, a ne sav narod. Odande mi ga prokuni.“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Zatim ga je odveo u Zofimsko polje, na vrh Fasge. Tamo je podigao sedam žrtvenika i na svakom žrtveniku prineo po jednog junca i ovna. ");
INSERT INTO srponstl_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Valam reče Valaku: „Stani tu kod svoje svespalnice, a ja idem onamo da se sretnem s Gospodom.“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Gospod sretne Valama, stavi svoju reč u njegova usta i reče: „Vrati se Valaku i govori ovako.“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Kada se vratio k njemu, Valak je stajao kod svoje svespalnice sa moavskim knezovima. Valak ga upita: „Šta je Gospod rekao?“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Tada Valam izreče svoju priču: „Ustani, Valače, poslušaj me, sine Seforov! ");
INSERT INTO srponstl_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Bog nije čovek da bi slagao, ili potomak ljudski da bi se kajao. Zar je šta rekao da nije učinio, izrekao da nije ispunio? ");
INSERT INTO srponstl_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Zapovest mi dade da blagosiljam, blagoslov je dao i neću ga povući. ");
INSERT INTO srponstl_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ne nazire se nesreća u Jakovu, nevolja se ne vidi u Izrailju. S njim je Gospod, Bog njegov, carski mu poklik sred njega odzvanja! ");
INSERT INTO srponstl_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Bog ih je iz Egipta izveo, on je njemu kao rozi bivolovi. ");
INSERT INTO srponstl_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Protiv Jakova nema vračanja, protiv Izrailja nema gatanja. Nek se sada priča o Jakovu, o Izrailju nek se pripoveda: ’Evo, šta je Bog učinio!’ ");
INSERT INTO srponstl_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Kakav li je to samo narod! Kao lavica ustaje, kao lav se diže, ne leže dok ulov ne proždere i krvi se žrtava ne napije.“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Tada Valak reče Valamu: „Kad ga već ne možeš prokleti, nemoj ga ni blagosiljati!“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Valam odgovori Valaku: „Zar ti nisam rekao: ’Učiniću sve što mi Gospod bude rekao?’“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Valam reče Valaku: „Hajde da te odvedem na drugo mesto; možda će Bogu biti po volji da mi ih prokuneš odande!“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Valak povede Valama na vrh Fegora koji se nadvija nad pustarom. ");
INSERT INTO srponstl_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Valam reče Valaku: „Podigni mi ovde sedam žrtvenika i pripremi mi sedam junaca i sedam ovnova.“ ");
INSERT INTO srponstl_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Valak je uradio kako mu je Valam rekao, i prineo sedam junaca i sedam ovnova. ");
INSERT INTO srponstl_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Kad je Valam video da je Gospodu po volji da blagosilja Izrailja, nije više išao da traži znamenja kao prethodna dva puta, nego se okrenuo licem prema pustinji. ");
INSERT INTO srponstl_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Kad je Valam pogledao, video je kako Izrailj logoruje po svojim plemenima. Tada je Duh Gospodnji došao na njega, ");
INSERT INTO srponstl_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","pa je izrekao svoju priču. Rekao je: „Proroštvo Valama, sina Veorovog, proroštvo čoveka, koji jasno vidi, ");
INSERT INTO srponstl_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","proroštvo onoga što reči Božije čuje. On viđenje prima od Svemoćnoga, na tlo pada očima otvorenim. ");
INSERT INTO srponstl_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Kako su ti divni šatori, Jakove, i tvoja boravišta, Izrailju! ");
INSERT INTO srponstl_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Kao potoci granaju se, kao vrtovi pokraj reke, kao aloje koje Gospod posadi, kao kedrovi što su pokraj vode. ");
INSERT INTO srponstl_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Voda će poteći iz njegovih vedara, potomstvo mu biti nad mnogim vodama. Car će mu se uzdići nad Agagom, i carstvo se njegovo uzvisiti. ");
INSERT INTO srponstl_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Iz Egipta Bog ga je izveo, on je njemu kao rozi bivolovi. Neprijatelje će svoje proždreti, kosti im slomiti, strelama ih probosti. ");
INSERT INTO srponstl_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Spustio se kao lav, legao je kao lavica; ko sme njega da izaziva? Blaženi da su koji tebe blagosiljaju, prokleti da su koji tebe proklinju!“ ");
INSERT INTO srponstl_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Tu se Valak razgnevi na Valama, pljesnu dlanom o dlan, pa reče Valamu: „Pozvao sam te da prokuneš moje neprijatelje, a evo, ti si ih blagoslovio sva ova tri puta! ");
INSERT INTO srponstl_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Odlazi sada u svoje mesto! Rekao sam da ću te bogato nagraditi, ali Gospod ti je uskratio nagradu.“ ");
INSERT INTO srponstl_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Valam odgovori Valaku: „Zar nisam rekao i tvojim glasnicima koje si poslao: ");
INSERT INTO srponstl_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","’Da mi Valak da svoju kuću punu srebra i zlata, ne bih mogao da prekršim zapovest Gospodnju, kako bih na svoju ruku učinio bilo dobro, bilo zlo – govoriću ono što mi Gospod bude rekao’? ");
INSERT INTO srponstl_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","A sad, evo, idem svome narodu, hajde da ti saopštim šta će ovaj narod učiniti tvom narodu u poslednjim danima.“ ");
INSERT INTO srponstl_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Tada Valam izreče svoju priču: „Proroštvo Valama, sina Veorovog, proroštvo čoveka koji jasno vidi, ");
INSERT INTO srponstl_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","proroštvo onoga što Božije reči čuje, i poznaje mudrost Svevišnjega. On viđenje prima od Svemoćnoga, na tlo pada očima otvorenim. ");
INSERT INTO srponstl_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Vidim ga, ali ne u sadašnjosti, posmatram ga, ali ne iz bliza. Zvezda će izaći od Jakova, žezlo se podići od Izrailja; on će satrti krajeve moavske, i razbiti Sitove potomke. ");
INSERT INTO srponstl_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom će postati tuđa imovina, Sir, dušman njegov zaposednut biće, kad Izrailj nastupi sa silom! ");
INSERT INTO srponstl_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Vladar će od Jakova izaći, i istrebiti preživele iz grada.“ ");
INSERT INTO srponstl_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Zatim je pogledao prema Amaliku i izrekao svoju priču: „Amalik je bio prvi među narodima, ali mu je kraj u propasti.“ ");
INSERT INTO srponstl_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Onda je pogledao prema Keneju i izrekao svoju priču: „Čvrsto stoji tvoje stanište, gnezdo tvoje na steni počiva. ");
INSERT INTO srponstl_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","No, Kenej će biti istrebljen, kad ga Asirija u roblje odvede.“ ");
INSERT INTO srponstl_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ponovo Valam izreče svoju priču: „Jao! Ko će preživeti kad Bog učini ovo? ");
INSERT INTO srponstl_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Brodovi će doći iz Kitima, ali će i on propasti zauvek, kad pokori Asiriju i Evera.“ ");
INSERT INTO srponstl_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Potom Valam ustane i vrati se u svoje mesto, a Valak ode svojim putem. ");
INSERT INTO srponstl_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Dok je Izrailj boravio u Sitimu, narod je počeo da bludniči s Moavkama. ");
INSERT INTO srponstl_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","One su pozivale narod da prinosi žrtve njihovim bogovima, a narod je jeo i klanjao se njihovim bogovima. ");
INSERT INTO srponstl_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Tako je Izrailj pristao uz Val-Fegora. Zato je planuo Gospodnji gnev na Izrailja. ");
INSERT INTO srponstl_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Gospod reče Mojsiju: „Uzmi sve starešine naroda i povešaj ih usred bela dana pred Gospodom, da se Gospodnji gnev odvrati od Izrailja.“ ");
INSERT INTO srponstl_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Mojsije reče Izrailjevim sudijama: „Neka svako od vas pobije one svoje ljude koji su pristali uz Val-Fegora.“ ");
INSERT INTO srponstl_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Dok su oni plakali kod ulaza u Šator od sastanka, dođe neki Izrailjac i dovede jednu Madijanku svojoj braći, na Mojsijeve oči i na oči sve Izrailjeve zajednice. ");
INSERT INTO srponstl_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Kad je to video Fines, sin Eleazara, Aronovog sina, ustao je i napustio zajednicu. Uzme on koplje u ruku, ");
INSERT INTO srponstl_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ode za Izrailjcem u šator i oboje ih probode, i Izrailjca i ženu, nju kroz stomak. Tako je prestala pošast među Izrailjcima. ");
INSERT INTO srponstl_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Od pošasti je izginulo dvadeset četiri hiljade. ");
INSERT INTO srponstl_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","„Fines, sin Eleazara, Aronovog sina, je odvratio moj gnev od Izrailjaca, jer je svojom revnošću pokazao moju revnost među njima, pa nisam istrebio Izrailjce u svojoj revnosti. ");
INSERT INTO srponstl_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Zato mu reci: ’Evo, s njime sklapam savez mira. ");
INSERT INTO srponstl_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","To će njemu i njegovom potomstvu posle njega biti savez trajnog sveštenstva, zbog toga što je bio revnostan za svoga Boga i izvršio otkupljenje za Izrailjce.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ime pogubljenog Izrailjca, koji je bio ubijen sa madijanskom ženom, bilo je Zimrije. On je bio sin Salua, kneza jednog od Simeunovih otačkih domova. ");
INSERT INTO srponstl_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ime Madijanke koja je bila ubijena bilo je Hazvija. Ona je bila ćerka Sura, plemenskog glavara jednog roda u Madijanu. ");
INSERT INTO srponstl_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","„Napadni Madijance i pobij ih, ");
INSERT INTO srponstl_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","jer su vas zaveli u slučaju Fegora i njihove sestre Hazvije, ćerke madijanskog kneza, koja je bila ubijena u vreme pošasti koja se dogodila zbog Fegora.“ ");
INSERT INTO srponstl_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Gospod reče Mojsiju i svešteniku Eleazaru, sinu Aronovom: ");
INSERT INTO srponstl_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","„Izvršite popis sve zajednice sinova izrailjevih, od dvadeset godina pa naviše, po njihovim očinskim domovima, svakog ko je u Izrailju sposoban za vojsku.“ ");
INSERT INTO srponstl_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Mojsije i sveštenik Eleazar im rekoše na moavskim poljanama kod Jordana blizu Jerihona: ");
INSERT INTO srponstl_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","„Popišite ljude od dvadeset godina pa naviše, kao što je Gospod zapovedio Mojsiju.“ Ovo su bili Izrailjci koji su izašli iz Egipta: ");
INSERT INTO srponstl_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruvim, Izrailjev prvenac. Ruvimovi sinovi: od Enoha, porodica Enohova; od Faluja porodica Falujeva. ");
INSERT INTO srponstl_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Od Esrona, porodica Esronova, od Harmije porodica Harmijina. ");
INSERT INTO srponstl_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","To su Ruvimove porodice; bilo ih je popisano četrdeset tri hiljade sedam stotina trideset. ");
INSERT INTO srponstl_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Falujev sin bio je Elijav. ");
INSERT INTO srponstl_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Elijavovi sinovi: Namuilo, Datan i Aviron. Datan i Aviron su bili zastupnici zajednice, oni koji su se pobunili protiv Mojsija i Arona s Korejevim pristalicama, kada su se pobunili protiv Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Tada se zemlja otvorila svoje ždrelo i progutala i njih i Koreja. To je bilo onda kada su te pristalice izginule, a oganj progutao dve stotine pedeset ljudi. Tako su postali opomena. ");
INSERT INTO srponstl_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ipak, Korejevi sinovi nisu izginuli. ");
INSERT INTO srponstl_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeunovi sinovi po svojim porodicama: od Namuila porodica Namuilova; od Jamina porodica Jaminova; od Jakina porodica Jakinova; ");
INSERT INTO srponstl_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","od Zare porodica Zarina, od Saula porodica Saulova. ");
INSERT INTO srponstl_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","To su Simeunove porodice, ukupno dvadeset dve hiljade dve stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gadovi sinovi po svojim porodicama: od Sifona porodica Sifonova; od Agija porodica Agijeva; od Sunija porodica Sunijeva; ");
INSERT INTO srponstl_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","od Azena porodica Azenova; od Irija porodica Irijeva; ");
INSERT INTO srponstl_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","od Aroda porodica Arodova; od Arilija porodica Arilijeva. ");
INSERT INTO srponstl_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","To su porodice Gadovih sinova. Od njih je bilo popisanih četrdeset hiljada pet stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Judini sinovi: Ir i Avnan, ali Ir i Avnan su umrli u Hananu. ");
INSERT INTO srponstl_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Judini sinovi po svojim porodicama su bili: od Siloma porodica Silomova; od Faresa porodica Faresova; od Zare porodica Zarina. ");
INSERT INTO srponstl_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Faresovi sinovi su bili: od Esrona porodica Esronova; od Jemuila porodica Jemuilova. ");
INSERT INTO srponstl_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","To su Judine porodice. Od njih je bilo popisano sedamdeset šest hiljada pet stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isaharovi sinovi po svojim porodicama: od Tole porodica Tolina; od Fuve porodica Fuvina; ");
INSERT INTO srponstl_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Od Jasuva porodica Jasuvova; od Simrona porodica Simronova. ");
INSERT INTO srponstl_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","To su porodice Isaharove. Od njih je bilo popisano šezdeset četiri hiljade tri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zavulonovi sinovi po svojim porodicama: od Sareda porodica Saredova, od Alona porodica Alonova, od Alila porodica Alilova. ");
INSERT INTO srponstl_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","To su porodice Zavulonove. Od njih je bilo popisano šezdeset hiljada pet stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Josifovi sinovi po svojim porodicama: Manasija i Jefrem. ");
INSERT INTO srponstl_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manasijini sinovi: od Mahira porodica Mahirova, a Mahir rodi Galada, od Galada je porodica Galadova. ");
INSERT INTO srponstl_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ovo su Galadovi sinovi: od Ahijezera porodica Ahijezerova; od Heleka porodica Helekova; ");
INSERT INTO srponstl_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","od Esrila porodica Esrilova, od Sihema porodica Sihemova; ");
INSERT INTO srponstl_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","od Semida porodica Semidova; od Efera porodica Eferova. ");
INSERT INTO srponstl_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","A Salpad, sin Eferov, nije imao sinove nego ćerke. One su se zvale Mala, Nuja, Egla, Melha i Tersa. ");
INSERT INTO srponstl_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","To su Manasijine porodice. Od njih je bilo popisano pedeset dve hiljade sedam stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Jefremovi sinovi po svojim porodicama: od Sutala porodica Sutalova; od Vehera porodica Veherova; od Tahana porodica Tahanova, ");
INSERT INTO srponstl_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","sinovi Sutalovi: od Erana porodica Eranova. ");
INSERT INTO srponstl_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","To su porodice Jefremovih sinova. Od njih je bilo popisano trideset dve hiljade pet stotina. To su sinovi Josifovi po svojim porodicama. ");
INSERT INTO srponstl_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Venijaminovi sinovi po svojim porodicama: od Vele porodica Velina; od Asvila porodica Asvilova; od Ahirama porodica Ahiramova; ");
INSERT INTO srponstl_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","od Šufama porodica Šufamova; od Ufama porodica Ufamova. ");
INSERT INTO srponstl_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Velini sinovi su bili: Arad i Naman; od Arada porodica Aradova; od Namana porodica Namanova. ");
INSERT INTO srponstl_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","To su Venijaminovi sinovi po svojim porodicama. Od njih je bilo popisano četrdeset pet hiljada šest stotina. ");
INSERT INTO srponstl_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ovo je Danovo potomstvo po svojim porodicama: od Sameja porodica Samejeva. To je Danovo potomstvo po svojim porodicama. ");
INSERT INTO srponstl_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Od svih Samejevih porodica bilo je popisanih šezdeset četiri hiljade četiri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Asirovi sinovi po svojim porodicama: Od Jemne porodica Jemnina; od Jesvije porodica Jesvijeva: od Verija porodica Verijina. ");
INSERT INTO srponstl_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Verijini sinovi: od Hevera porodica Heverova; od Melhila porodica Melhilova. ");
INSERT INTO srponstl_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asirova ćerka zvala se Sera. ");
INSERT INTO srponstl_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","To su porodice Asirovih sinova. Od njih je bilo popisano pedeset tri hiljade četiri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Neftalimovi sinovi po svojim porodicama: od Jasila porodica Jasilova; od Gunija porodica Gunijeva; ");
INSERT INTO srponstl_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","od Jesera porodica Jeserova; od Selima porodica Selimova. ");
INSERT INTO srponstl_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","To je Neftalimov rod po svojim porodicama. Od njih je bilo popisano četrdeset pet hiljada četiri stotine. ");
INSERT INTO srponstl_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Popisanih Izrailjaca bilo je ukupno šest stotina jedna hiljada sedam stotina trideset. ");
INSERT INTO srponstl_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","„Ovima neka se podeli zemlja u nasledstvo prema broju imena. ");
INSERT INTO srponstl_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Većem plemenu daj veće nasledstvo, a manjem plemenu daj manje nasledstvo; neka se svakome da nasledstvo prema broju njegovih popisanih. ");
INSERT INTO srponstl_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Neka se zemlja podeli žrebom; neka je prime u nasledstvo prema imenima njihovih otačkih plemena. ");
INSERT INTO srponstl_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Nasledstvo neka se svakom plemenu podeli žrebom prema tome da li je veliko ili malo.“ ");
INSERT INTO srponstl_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","A ovo su popisani Leviti po svojim porodicama: od Girsona porodica Girsonova; od Kata porodica Katova i od Merarija porodica Merarijeva. ");
INSERT INTO srponstl_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ovo su Levijeve porodice: porodica Lovenijeva, porodica Hevronova, porodica Molijeva, porodica Musijeva, porodica Korejeva. A Katu se rodio Amram. ");
INSERT INTO srponstl_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amramovoj ženi ime je bilo Johaveda. Ona je bila Levijeva ćerka, koja mu se rodila u Egiptu. Ona je Amramu rodila Arona i Mojsija i njihovu sestru Mariju. ");
INSERT INTO srponstl_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aronu se rodio Nadav, Avijud, Eleazar i Itamar. ");
INSERT INTO srponstl_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Ali Nadav i Avijud su poginuli kad su prineli tuđi oganj pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Svih popisanih muškaraca od jednog meseca pa naviše bilo je dvadeset tri hiljade. Oni nisu bili popisani s Izrailjcima, pošto im nije dano nasledstvo među Izrailjcima. ");
INSERT INTO srponstl_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","To su oni koje je popisao Mojsije i sveštenik Eleazar, koji su popisali Izrailjce na moavskim poljanama kod Jordana nasuprot Jerihonu. ");
INSERT INTO srponstl_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Među ovima nije bilo nijednoga od onih koje su popisali Mojsije i Aron, kad su popisivali Izrailjce u Sinajskoj pustinji. ");
INSERT INTO srponstl_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Gospod je, naime, rekao: „Neka svakako pomru u pustinji!“ Od tih ni jedan nije preživeo osim Haleva, sina Jefonijinog, i Isusa, sina Navinovog. ");
INSERT INTO srponstl_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Tada su pristupile ćerke Salpada, sina Eferovog, sina Galadovog, sina Mahirovog, sina Manasijinog, sina Josifovog. On je bio iz Manasijine porodice. Ćerke su mu se zvale: Mala, Nuja, Egla, Melha i Tersa. ");
INSERT INTO srponstl_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Stale su pred Mojsija i sveštenika Eleazara, pred knezove i svu zajednicu, kod ulaza u Šator od sastanka, i rekle: ");
INSERT INTO srponstl_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","„Naš otac je umro u pustinji. On nije bio među onim pristalicama, Korejevim pristalicama, što su se pobunile protiv Gospoda, nego je umro zbog svog greha. Nije imao sinova. ");
INSERT INTO srponstl_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Zašto da ime našeg oca nestane iz njegove porodice zato što nije imao ni jednog sina? Daj nam posed među braćom našeg oca.“ ");
INSERT INTO srponstl_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mojsije donese njihov slučaj pred Gospoda. ");
INSERT INTO srponstl_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","„Salpadove ćerke su u pravu. Daj im posed u nasledstvo među braćom njihovog oca; prevedi na njih nasledstvo njihovog oca. ");
INSERT INTO srponstl_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","A Izrailjcima reci: ’Ako čovek umre a nema nijednog sina, prevedite nasledstvo na njegovu ćerku. ");
INSERT INTO srponstl_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ako nema ni ćerku, njegovo nasledstvo dajte njegovoj braći. ");
INSERT INTO srponstl_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ako nema ni braću, dajte njegovo nasledstvo braći njegovog oca. ");
INSERT INTO srponstl_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ako njegov otac nema braće, njegovo nasledstvo dajte u posed njegovom najbližem rođaku iz rodbine. Neka to Izrailjcima bude pravna uredba kao što je Gospod zapovedio Mojsiju.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Gospod reče Mojsiju: „Popni se na ovu goru Avarim i pogledaj zemlju koju sam dao Izrailjcima. ");
INSERT INTO srponstl_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Kad je pogledaš, pridružićeš se svome narodu, kao što mu se pridružio tvoj brat Aron, ");
INSERT INTO srponstl_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","jer ste se pobunili protiv moje reči u pustinji Cin kada se zajednica svađala, umesto da kod voda objavite moju svetost pred njihovim očima.“ (To su merivske vode kod Kadisa u pustinji Cin.) ");
INSERT INTO srponstl_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mojsije reče Gospodu: ");
INSERT INTO srponstl_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","„Neka Gospod, Bog duhova svih stvorenja, postavi jednog čoveka nad zajednicom, ");
INSERT INTO srponstl_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","koji će ih predvoditi u svemu što preduzimaju, koji će ih izvoditi i dovoditi. Tako Gospodnja zajednica neće biti kao stado bez pastira.“ ");
INSERT INTO srponstl_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Gospod reče Mojsiju: „Uzmi Isusa, sina Navinovog, čoveka u kome je moj Duh, i položi svoju ruku na njega. ");
INSERT INTO srponstl_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Postavi ga pred sveštenika Eleazara i pred svu zajednicu, i uvedi ga u službu u njihovoj prisutnosti. ");
INSERT INTO srponstl_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Zatim mu predaj deo svoje vlasti, da mu se pokorava sva izrailjska zajednica. ");
INSERT INTO srponstl_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Onda ga postavi pred sveštenika Eleazara, a on će za njega tražiti savet od Gospoda putem Urima. Na njegovu zapovest neka on i sva izrailjska zajednica polaze i na njegovu zapovest neka dolaze.“ ");
INSERT INTO srponstl_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mojsije učini kako mu je Gospod zapovedio. Uzeo je Isusa i postavio ga pred sveštenika Eleazara i pred svu zajednicu. ");
INSERT INTO srponstl_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Zatim je položio svoju ruku na njega u uveo ga u službu, kao što je Gospod rekao preko Mojsija. ");
INSERT INTO srponstl_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","„Zapovedi Izrailjcima i reci im: ’Pazite da prinosite moj prinos, hranu za moju paljenu žrtvu, moj ugodni miris, u vreme koje je određeno za njega.’ ");
INSERT INTO srponstl_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Reci im: ’Ovo je paljena žrtva koju ćete prinositi Gospodu: dnevno dva jagnjeta od godinu dana, bez mane, kao trajnu žrtvu svespalnicu. ");
INSERT INTO srponstl_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Jedno jagnje prinesi ujutro, a drugo prinesi uveče. ");
INSERT INTO srponstl_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Uz to, umešaj desetinu efe brašna s četvrt hina čistog, sveže isceđenog ulja. ");
INSERT INTO srponstl_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","To je trajna žrtva svespalnica ustanovljena na gori Sinaj, na ugodni miris – paljenu žrtvu Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Žrtva izlivnica će biti četvrt hina žestokog pića za svako jagnje. Neka se žrtva izlivnica Gospodu izlije u Svetinji. ");
INSERT INTO srponstl_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Drugo jagnje prinesi uveče. S njim prinesi istu žitnu žrtvu kao ujutro, i žrtvu izlivnicu na ugodni miris, paljenu žrtvu Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Na subotnji dan prinesi dva jagnjeta od godinu dana, bez mane, dve desetine efe brašna umešenog sa uljem za žitnu žrtvu, i žrtvu izlivnicu koja ide uz nju. ");
INSERT INTO srponstl_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","To je žrtva svespalnica za svaku subotu, pored svakodnevne žrtve svespalnice i žrtve izlivnice koja ide uz nju. ");
INSERT INTO srponstl_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Na početku vaših meseci prinesite žrtvu svespalnicu Gospodu: dva junca, dva ovna i sedam jaganjaca od godinu dana bez mane. ");
INSERT INTO srponstl_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Žitna žrtva uz svakog junca biće: tri desetine efe brašna umešenog s uljem. Žitna žrtva uz svakog ovna biće: dve desetine brašna umešenog s uljem. ");
INSERT INTO srponstl_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Žitna žrtva uz svako jagnje biće: dve desetine brašna umešenog s uljem. To je žrtva svespalnica – paljena žrtva na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Žrtva izlivnica koja ide uz njih biće: pola hina vina za svakog junca, jedna trećina hina vina za ovna, i jedna četvrtina hina vina za jagnje. To je žrtva svespalnica za svaki novi mesec tokom meseci u godini. ");
INSERT INTO srponstl_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Uz svakodnevnu svespalnicu, neka se Gospodu prinosi jedan jarac kao žrtva za greh, uz žrtvu izlivnicu koja ide s njom. ");
INSERT INTO srponstl_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Prvoga meseca, četrnaestog dana u mesecu počinje Pasha Gospodnja. ");
INSERT INTO srponstl_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","A petnaestoga dana istog meseca je praznik. Jedite beskvasne hlebove sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Prvoga dana održavajte sveti sabor; ne radite nikakvog svakodnevnog posla. ");
INSERT INTO srponstl_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Kao paljenu žrtvu, svespalnicu, prinesite Gospodu dva junca, jednog ovna i sedam jaganjaca od godinu dana, bez mane. ");
INSERT INTO srponstl_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Žitna žrtva koja ide uz njih biće: tri desetine efe brašna umešenog s uljem za svakog junca, dve desetine za ovna, ");
INSERT INTO srponstl_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","a jednu desetinu prinesi za svakog od sedam jaganjaca. ");
INSERT INTO srponstl_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Takođe, prinesi i jednog jarca, žrtvu za greh, da se izvrši otkupljenje za vas. ");
INSERT INTO srponstl_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ovo prinosite pored jutarnje žrtve svespalnice koja se svakodnevno prinosi. ");
INSERT INTO srponstl_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Ovako ćete činiti svaki dan za sedam dana. To je paljena žrtva, ugodni miris Gospodu. Neka se to prinosi uz svakodnevnu žrtvu svespalnicu i uz žrtvu izlivnicu koja ide s njom. ");
INSERT INTO srponstl_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","A sedmoga dana neka vam bude sveti sabor: ne radite nikakav posao. ");
INSERT INTO srponstl_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Na dan prvina, prilikom vašeg praznika Sedmica, kad prinesete Gospodu žitnu žrtvu od nove žetve, održavajte sveti sabor. Ne radite nikakav svakodnevni posao! ");
INSERT INTO srponstl_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Za žrtvu svespalnicu na ugodan miris Gospodu prinesite dva junca, jednog ovna i sedam jaganjaca od godinu dana. ");
INSERT INTO srponstl_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Žitna žrtva koja ide uz njih biće: tri desetine efe brašna umešenog s uljem za svakog junca, dve desetine za ovna, ");
INSERT INTO srponstl_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","a jednu desetinu za svakog od sedam jaganjaca; ");
INSERT INTO srponstl_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","i jednog jarca, da se izvrši otkupljenje za vas. ");
INSERT INTO srponstl_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Pored svakodnevne žrtve svespalnice, i žitne žrtve koja ide uz nju, prinesite uz nju i žrtvu izlivnicu. Neka vam budu bez mane. ");
INSERT INTO srponstl_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Prvog dana sedmog meseca održavajte sveti sabor. Ne radite nikakav svakodnevni posao. Neka vam to bude trubni dan. ");
INSERT INTO srponstl_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Tada prinesite kao žrtvu svespalnicu na ugodan miris Gospodu jednog junca, jednog ovna i sedam jaganjaca od godinu dana, bez mane. ");
INSERT INTO srponstl_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Žitna žrtva koja ide za njih biće: tri desetine efe brašna umešenog s uljem za junca, dve desetine za ovna, ");
INSERT INTO srponstl_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","i jedna desetina za svakog od sedam jaganjaca; ");
INSERT INTO srponstl_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","i jednog jarca, da se izvrši otkupljenje za vas. ");
INSERT INTO srponstl_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Pored mesečne žrtve svespalnice i žitne žrtve koja ide uz nju, i svakodnevne svespalnice i žitne žrtve koja ide uz nju, prinesite uz nju i propisanu žrtvu izlivnicu, na ugodan miris Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Desetog dana, istog sedmog meseca, održavajte sveti sabor. Postite i ne radite nikakav svakodnevni posao. ");
INSERT INTO srponstl_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Tada prinesite kao žrtvu svespalnicu na ugodan miris Gospodu jednog junca, jednog ovna i sedam jaganjaca od godinu dana. Neka budu bez mane. ");
INSERT INTO srponstl_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Žitna žrtva koja ide uz njih biće: tri desetine efe brašna umešenog s uljem za junca, dve desetine za ovna, ");
INSERT INTO srponstl_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","a jedna desetina za svakog od sedam jaganjaca; ");
INSERT INTO srponstl_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","i jednog jarca za žrtvu za greh, pored žrtve otkupljenja za greh, svakodnevne žrtve svespalnice, žitne žrtve koja ide uz nju i žrtve izlivnice koja ide uz njih. ");
INSERT INTO srponstl_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Petnaestog dana sedmog meseca održavajte sveti sabor. Ne radite nikakav svakodnevni posao. Praznik Gospodu proslavljajte sedam dana. ");
INSERT INTO srponstl_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Kao žrtvu svespalnicu, paljenu žrtvu na ugodan miris Gospodu, prinesite trinaest junaca, dva ovna i četrnaest jaganjaca od godinu dana. Neka budu bez mane. ");
INSERT INTO srponstl_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Žitna žrtva koja ide uz njih biće: tri desetine efe brašna umešenog s uljem za svakog od trinaest junaca, dve desetine za svakog ovna, ");
INSERT INTO srponstl_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","a jedna desetina za svakog od četrnaest jaganjaca; ");
INSERT INTO srponstl_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","i jednog jarca za žrtvu za greh, pored svakodnevne žrtve svespalnice, žitne žrtve koja ide uz nju i žrtve izlivnice koja ide uz nju. ");
INSERT INTO srponstl_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Drugog dana prinesite: dvanaest junaca, dva ovna, četrnaest jaganjaca bez mane, ");
INSERT INTO srponstl_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","sa žitnom žrtvom i žrtvom izlivnicom, prema propisanom broju junaca, ovnova i jaganjaca; ");
INSERT INTO srponstl_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","i jednog jarca za žrtvu za greh, pored svakodnevne žrtve svespalnice, žitne žrtve koja ide uz nju i žrtve izlivnice koja ide uz nju. ");
INSERT INTO srponstl_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Trećeg dana prinesite: jedanaest junaca, dva ovna i četrnaest jaganjaca od godinu dana, bez mane, ");
INSERT INTO srponstl_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","sa žitnom žrtvom i žrtvom izlivnicom, prema propisanom broju junaca, ovnova i jaganjaca; ");
INSERT INTO srponstl_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","i jednog jarca za žrtvu za greh, pored svakodnevne žrtve svespalnice, žitne žrtve koja ide uz nju i žrtve izlivnice koja ide uz nju. ");
INSERT INTO srponstl_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Četvrtog dana prinesite: deset junaca, dva ovna i četrnaest jaganjaca od godinu dana, bez mane, ");
INSERT INTO srponstl_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","sa žitnom žrtvom i žrtvom izlivnicom, prema propisanom broju junaca, ovnova i jaganjaca; ");
INSERT INTO srponstl_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","i jednog jarca za žrtvu za greh, pored svakodnevne žrtve svespalnice, žitne žrtve koja ide uz nju i žrtve izlivnice koja ide uz nju. ");
INSERT INTO srponstl_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Petog dana prinesite: devet junaca, dva ovna i četrnaest jaganjaca od godinu dana, bez mane, ");
INSERT INTO srponstl_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","sa žitnom žrtvom i žrtvom izlivnicom, prema propisanom broju junaca, ovnova i jaganjaca; ");
INSERT INTO srponstl_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","i jednog jarca za žrtvu za greh, pored svakodnevne žrtve svespalnice, žitne žrtve koja ide uz nju i žrtve izlivnice koja ide uz nju. ");
INSERT INTO srponstl_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Šestog dana prinesite: osam junaca, dva ovna i četrnaest jaganjaca od godinu dana, bez mane, ");
INSERT INTO srponstl_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","sa žitnom žrtvom i žrtvom izlivnicom, prema propisanom broju junaca, ovnova i jaganjaca; ");
INSERT INTO srponstl_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","i jednog jarca za žrtvu za greh, pored svakodnevne žrtve svespalnice, žitne žrtve koja ide uz nju i žrtve izlivnice koja ide uz nju. ");
INSERT INTO srponstl_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Sedmog dana prinesite: sedam junaca, dva ovna i četrnaest jaganjaca od godinu dana, bez mane, ");
INSERT INTO srponstl_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","sa žitnom žrtvom i žrtvom izlivnicom, prema propisanom broju junaca, ovnova i jaganjaca; ");
INSERT INTO srponstl_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","i jednog jarca za žrtvu za greh, pored svakodnevne žrtve svespalnice, žitne žrtve koja ide uz nju i žrtve izlivnice koja ide uz nju. ");
INSERT INTO srponstl_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Osmog dana održavajte svečani sabor. Ne radite nikakav svakodnevni posao. ");
INSERT INTO srponstl_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Kao žrtvu svespalnicu, paljenu žrtvu na ugodni miris Gospodu, prinesite jednog junca, jednog ovna i sedam jaganjaca bez mane; ");
INSERT INTO srponstl_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","žitnu žrtvu i žrtvu izlivnicu, prema propisanom broju junaca, ovnova i jaganjaca; ");
INSERT INTO srponstl_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","i jednog jarca za žrtvu za greh, pored svakodnevne žrtve svespalnice, žitne žrtve koja ide uz nju i žrtve izlivnice koja ide uz nju. ");
INSERT INTO srponstl_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","To prinosite Gospodu na svoje određene praznike, pored svojih zaveta i dobrovoljnih priloga, bilo da su to vaše žrtve svespalnice, žitne žrtve, žrtve izlivnice ili žrtve mira.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Tako je Mojsije rekao Izrailjcima sve što mu je Gospod zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mojsije reče glavarima plemena izrailjskog naroda: „Ovo je Gospod zapovedio: ");
INSERT INTO srponstl_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","’Ako neki čovek učini zavet Gospodu, ili položi zakletvu kojom se obaveže, neka ne pogazi svoju reč; neka učini ono što izađe iz njegovih usta. ");
INSERT INTO srponstl_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Ako žena učini zavet Gospodu u svojoj mladosti, ili se obaveže zakletvom dok je u kući svoga oca, ");
INSERT INTO srponstl_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","pa njen otac sazna za njen zavet ili zakletvu kojom se obavezala, ali joj ne prigovori, tada svi njeni zaveti i svaka zakletva kojom se obavezala ostaju na snazi. ");
INSERT INTO srponstl_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Ali ako joj otac to zabrani istog dana kad sazna, svi njeni zaveti i zakletve kojima se obavezala više ne važe. Gospod će joj oprostiti, jer joj je otac zabranio. ");
INSERT INTO srponstl_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Ako se uda dok je pod zavetom, ili se obavezala nepromišljenom izjavom, ");
INSERT INTO srponstl_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","pa njen muž sazna za to, ali joj ne prigovori istog dana kad sazna, tada svi njeni zaveti i obećanja kojima se obavezala ostaju na snazi. ");
INSERT INTO srponstl_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ako joj se muž usprotivi istog dana kad sazna, on time poništava zavet, ili nepromišljenu izjavu kojom se obavezala. A Gospod će joj oprostiti. ");
INSERT INTO srponstl_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Zavet udovice ili razvedene, sve čime se obavezala, i dalje je obavezuje. ");
INSERT INTO srponstl_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Ako žena učini zavet dok je u kući svog muža, ili se obaveže obećanjem uz zakletvu, ");
INSERT INTO srponstl_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","pa njen muž sazna za to, ali joj ne prigovori i ne zabrani joj, tada svi njeni zaveti i svako obećanje kojim se obavezala ostaju na snazi. ");
INSERT INTO srponstl_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ali ako ih muž poništi istog dana kad sazna za njih, ništa što je prešlo preko njenih usana ne važi. Pošto ih je njen muž poništio, Gospod će joj oprostiti. ");
INSERT INTO srponstl_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Svaki zavet i svaku zakletvu kojom se žena obaveže na neko samoodricanje, njen muž može da potvrdi ili poništi. ");
INSERT INTO srponstl_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ako dani prolaze, a muž joj ne prigovara, on potvrđuje sve njene zavete, ili sva obećanja kojima se obavezala. On ih je potvrdio, jer joj nije prigovorio istog dana kad je saznao za njih. ");
INSERT INTO srponstl_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ali ako ih poništi kasnije, pošto je već saznao za njih, sam će nositi njenu krivicu.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","To su odredbe koje je Gospod dao Mojsiju za muža i njegovu ženu, i za oca i njegovu ćerku u njenoj mladosti, dok je u kući svoga oca. ");
INSERT INTO srponstl_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","„Izvrši osvetu nad Madijancima zbog Izrailjaca. Potom ćeš se pridružiti svome narodu.“ ");
INSERT INTO srponstl_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mojsije reče narodu: „Naoružaj ljude među vama za rat, pa neka idu na Madijance da izvrše nad njima Gospodnju osvetu. ");
INSERT INTO srponstl_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Pošalji u bitku po hiljadu ljudi iz svakog izrailjskog plemena.“ ");
INSERT INTO srponstl_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Tako je od Izrailjevih hiljada bilo okupljeno dvanaest hiljada ljudi naoružanih za rat, po hiljadu iz svakog plemena. ");
INSERT INTO srponstl_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mojsije ih je poslao u rat, po hiljadu iz svakog plemena, zajedno sa Finesom, sinom sveštenika Eleazara, koji je poneo sa sobom posvećeno posuđe i ratne trube. ");
INSERT INTO srponstl_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Oni su zaratili protiv Madijana, baš kako je Gospod zapovedio Mojsiju i pobili mu sve muškarce. ");
INSERT INTO srponstl_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Pored ostalih pobili su i madijanske careve Evija, Rekema, Sura, Ora i Revu – pet madijanskih careva. Mačem su pogubili i Valama, sina Veorovog. ");
INSERT INTO srponstl_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Izrailjci su sa sobom poveli madijanske žene i decu, i zaplenili svu njihovu stoku, sva njihova stada i sva njihova dobra, ");
INSERT INTO srponstl_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","a sve njihove gradove po kojima su živeli spalili ognjem. ");
INSERT INTO srponstl_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Onda su uzeli plen i sve što je bilo oduzeto, i ljude i stoku, ");
INSERT INTO srponstl_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","pa su roblje, oduzeto i plen doveli Mojsiju, svešteniku Eleazaru i svoj Izrailjevoj zajednici u tabor na moavskim poljanama, kod Jordana, nasuprot Jerihonu. ");
INSERT INTO srponstl_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mojsije, sveštenik Eleazar i svi knezovi zajednice pođu im u susret izvan tabora. ");
INSERT INTO srponstl_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Mojsije se razbesneo na vojvode, na zapovednike hiljada i stotina, koji su se vraćali iz rata. ");
INSERT INTO srponstl_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Mojsije im reče: „Zar ste ostavili u životu sve žene? ");
INSERT INTO srponstl_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","A baš su one, na Valamov nagovor, navele Izrailjce da se iznevere Gospodu u slučaju Fegora, pa je Gospodnju zajednicu pogodila pošast! ");
INSERT INTO srponstl_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Stoga sad pobijte svu mušku decu i svaku ženu koja je spavala sa muškarcem. ");
INSERT INTO srponstl_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Ipak, poštedite za sebe svaku mladu devojku koja nije spavala sa muškarcem. ");
INSERT INTO srponstl_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Svaki od vas koji je ubio nekoga ili je dotakao ubijenog, neka logoruje sedam dana izvan tabora. Očistite sebe i svoje robove trećega i sedmoga dana. ");
INSERT INTO srponstl_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Neka se očisti i svako ruho, svaki kožni predmet, svaki predmet načinjen od kozje dlake, i svaki predmet od drveta.“ ");
INSERT INTO srponstl_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","A sveštenik Eleazar reče ratnicima koji su išli u bitku: „Ovo je odredba Zakona koji je Gospod dao Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","zlato, srebro, bronzu, gvožđe, kalaj i olovo, ");
INSERT INTO srponstl_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","sve što je otporno na vatru, neka se propusti kroz vatru i biće čisto. Ipak, neka se očisti i vodom očišćenja. A sve što nije otporno na vatru propustite kroz vodu. ");
INSERT INTO srponstl_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Sedmoga dana operite svoju odeću i bićete čisti. Potom se vratite u tabor.“ ");
INSERT INTO srponstl_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","„Ti, sveštenik Eleazar i glavari otačkih domova zajednice, izvršite popis plena, ljudi i stoke. ");
INSERT INTO srponstl_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Zatim podeli plen između ratnika koji su išli u bitku i cele zajednice. ");
INSERT INTO srponstl_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Od ratnika koji su išli u bitku odvoj deo za Gospoda: jednu glavu od svakih pet stotina, kako od ljudi tako od krupne stoke, magaraca i ovaca. ");
INSERT INTO srponstl_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Uzmite to od njihove polovine i dajte to svešteniku Eleazaru za prinos Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","A od polovine plena Izrailjaca uzmi jednu glavu od svakih pet stotina, kako od ljudi tako od krupne stoke, magaraca, ovaca – od svake stoke – i daj ih Levitima, koji su zaduženi za službu u Prebivalištu Gospodnjem.“ ");
INSERT INTO srponstl_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Mojsije i Eleazar učine kao što je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Plena što je ostao od oduzetog koje je zaplenila vojska bilo je: šest stotina sedamdeset pet hiljada ovaca, ");
INSERT INTO srponstl_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","sedamdeset dve hiljade grla goveda, ");
INSERT INTO srponstl_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","šezdeset jedna hiljada magaraca, ");
INSERT INTO srponstl_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","i trideset dve hiljade ljudskih duša – žena koje nisu spavale sa muškarcem. ");
INSERT INTO srponstl_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Dakle, polovina dela vojske koja je išla u bitku bila je: tri stotine trideset sedam hiljada pet stotina grla sitne stoke. ");
INSERT INTO srponstl_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Deo za Gospoda od sitne stoke bio je šest stotina sedamdeset pet ovaca. ");
INSERT INTO srponstl_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Bilo je trideset šest hiljada goveda, od kojih je Gospodnji deo bio sedamdeset dva grla; ");
INSERT INTO srponstl_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","magaraca je bilo trideset hiljada pet stotina, od kojih je Gospodnji deo bio šezdeset jedno grlo; ");
INSERT INTO srponstl_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","i šesnaest hiljada ljudskih duša, od kojih je Gospodnji deo bio trideset dve duše. ");
INSERT INTO srponstl_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mojsije je predao svešteniku Eleazaru deo, prinos za Gospoda, kao što je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Polovina dela Izrailjaca koju je Mojsije odvojio od ljudi koji su ratovali – ");
INSERT INTO srponstl_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","polovina koja je pripala zajednici, iznosila je: tri stotine trideset sedam hiljada pet stotina grla sitne stoke, ");
INSERT INTO srponstl_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","trideset šest hiljada goveda, ");
INSERT INTO srponstl_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","trideset hiljada pet stotina magaraca, ");
INSERT INTO srponstl_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","i šesnaest hiljada ljudskih duša. ");
INSERT INTO srponstl_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Od te polovine, koja je pripala Izrailjcima, Mojsije je uzeo po jedno od pedeset, i od ljudi i od stoke, i dao Levitima koji su bili zaduženi za službu u Prebivalištu Gospodnjem, kao što mu je Gospod zapovedio. ");
INSERT INTO srponstl_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Tada su Mojsiju pristupili vojni zapovednici nad hiljadama, knezovi nad hiljadama i stotinama, ");
INSERT INTO srponstl_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","i rekli mu: „Tvoje sluge su izvršile popis ratnika koji su bili pod našim vodstvom, i nijedan od nas ne nedostaje. ");
INSERT INTO srponstl_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","A mi smo doneli prinos Gospodu, šta je već ko našao, predmete od zlata, narukvice i grivne, prstenje, naušnice i ogrlice, da se izvrši otkupljenje za nas pred Gospodom.“ ");
INSERT INTO srponstl_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mojsije i Sveštenik Eleazar su uzeli od njih zlato, sav taj nakit. ");
INSERT INTO srponstl_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Svega zlata, žrtve dizanice koju su prineli Gospodu bilo je šesnaest hiljada sedam stotina pedeset šekela. ");
INSERT INTO srponstl_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","A vojnici su zadržali za sebe što su zaplenili. ");
INSERT INTO srponstl_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Potom su Mojsije i sveštenik Eleazar uzeli zlato od knezova nad hiljadama i stotinama i doneli ga u Šator od sastanka, kao spomen Izrailjcima pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","A Ruvimovci i Gadovci su imali silno mnoštvo stoke. Kad su Ruvimovci i Gadovci videli da je oblast Jazira i Galada pogodno mesto za stoku, ");
INSERT INTO srponstl_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","došli su k Mojsiju, svešteniku Eleazaru i knezovima zajednice i rekli: ");
INSERT INTO srponstl_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","„Atarot, Devon, Jazir, Namra, Esevon, Elealija, Sevama, Navav i Vean, ");
INSERT INTO srponstl_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","zemlja koju je Gospod pokorio pred izrailjskom zajednicom je pogodna zemlja za stoku, a tvoje sluge imaju stoku.“ ");
INSERT INTO srponstl_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Oni nastaviše: „Ako smo stekli naklonost pred tobom, neka se ova zemlja da tvojim slugama u posed. Ne vodi nas preko Jordana.“ ");
INSERT INTO srponstl_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mojsije odgovori Gadovcima i Ruvimovcima: „Zar da vaša braća idu u rat, a vi da ostanete ovde? ");
INSERT INTO srponstl_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Zašto odvraćate Izrailjce od prelaska u zemlju koju im je dao Gospod? ");
INSERT INTO srponstl_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Tako su postupili i vaši očevi kad sam ih poslao iz Kadis-Varnije da izvide zemlju. ");
INSERT INTO srponstl_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","I kad su otišli do potoka Eshola i videli zemlju, odvratili su Izrailjce od ulaska u zemlju koju im je dao Gospod. ");
INSERT INTO srponstl_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Tog dana je Gospod planuo gnevom i zakleo se govoreći: ");
INSERT INTO srponstl_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","’Nijedan od ljudi od dvadeset godina pa naviše koji su izašli iz Egipta, neće videti zemlju za koju sam se zakleo njihovim precima Avrahamu, Isaku i Jakovu, jer me nisu verno sledili, ");
INSERT INTO srponstl_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","osim Kenezejca Haleva, sina Jefonijinog, i Isusa, sina Navinovog, zato što su verno sledili Gospoda.’ ");
INSERT INTO srponstl_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Međutim, Gospod je planuo gnevom na Izrailj, pa je učinio da četrdeset godina lutaju po pustinji, dok nije pomro sav taj naraštaj koji je činio zlo pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","A sada ste, porode grešnički, stupili na mesto svojih predaka da još više navučete na Izrailja plamteći gnev Gospodnji. ");
INSERT INTO srponstl_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ako se odvratite od njega, on će ih i dalje ostaviti u pustinji; tako ćete upropastiti sav ovaj narod.“ ");
INSERT INTO srponstl_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","A oni mu pristupiše i rekoše: „Podigli bismo ovde samo obore za našu stoku i gradove za naše žene i decu, ");
INSERT INTO srponstl_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ali ćemo se naoružati i hitro stati na čelo Izrailjaca, dok ih ne dovedemo na njihovo mesto. A naše žene i deca neka ostanu u utvrđenim gradovima zbog stanovnika ove zemlje. ");
INSERT INTO srponstl_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Svojim se domovima nećemo vraćati sve dok svaki Izrailjac ne primi svoj deo u nasledstvo. ");
INSERT INTO srponstl_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Ipak, mi nećemo primiti svoj deo u nasledstvo sa njima, tamo s one strane Jordana i dalje, pošto nam je nasledstvo pripalo na ovoj, istočnoj strani Jordana.“ ");
INSERT INTO srponstl_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mojsije im reče: „Ako održite reč – ako naoružani pođete u rat pred Gospodom, ");
INSERT INTO srponstl_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","te svaki od vas naoružan pređe preko Jordana pred Gospodom, dok on ne istera ispred sebe svoje neprijatelje, ");
INSERT INTO srponstl_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","i dok zemlja ne bude pokorena pred Gospodom, onda se možete vratiti, pa ćete biti rešeni krivice pred Gospodom i pred Izrailjcima. Tada će vam ova zemlja pripasti u nasledstvo pred Gospodom. ");
INSERT INTO srponstl_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Ali ako ne uradite tako, zgrešićete protiv Gospoda. Znajte da ćete ispaštati za svoj greh. ");
INSERT INTO srponstl_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Podignite gradove za svoje žene i decu i torove za svoje ovce, ali uradite što ste obećali.“ ");
INSERT INTO srponstl_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gadovci i Ruvimovci odgovoriše Mojsiju: „Tvoje sluge će učiniti kao što naš gospodar zapoveda. ");
INSERT INTO srponstl_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Naša deca i žene, naša stada i stoka ostaće tamo u galadskim gradovima, ");
INSERT INTO srponstl_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","a tvoje sluge, svi koji su naoružani za rat, preći će da ratuju pred Gospodom, kao što naš gospodar kaže.“ ");
INSERT INTO srponstl_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Zatim je Mojsije radi njih izdao zapovest svešteniku Eleazaru, Isusu, sinu Navinovom i glavarima otačkih domova Izrailjevih plemena. ");
INSERT INTO srponstl_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Mojsije im reče: „Ako Gadovci i Ruvimovci, svi ljudi naoružani za rat, pređu s vama preko Jordana ispred Gospoda, i zemlja bude pokorena pred vama, vi ćete im dati galadsku zemlju u posed. ");
INSERT INTO srponstl_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ukoliko njihovi ljudi ne pređu naoružani s vama, neka prime svoj posed među vama u hananskoj zemlji.“ ");
INSERT INTO srponstl_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gadovci i Ruvimovci odgovore: „Učinićemo onako kako je Gospod rekao tvojim slugama. ");
INSERT INTO srponstl_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Preći ćemo pod oružjem pred Gospodom u hanansku zemlju, ali ćemo zadržati nasledstvo u našem posedu s ove strane Jordana.“ ");
INSERT INTO srponstl_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Zatim je Mojsije dodelio Gadovcima, Ruvimovcima i polovini plemena Manasije, Josifovog sina, carstvo amorejskog cara Sihona, i carstvo vasanskog cara Oga, zemlju sa gradovima unutar njenih granica, i okolne oblasti. ");
INSERT INTO srponstl_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gadovci su podigli Devon, Atarot, Aroir. ");
INSERT INTO srponstl_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atarot-Sofan, Jazir, Jogveju, ");
INSERT INTO srponstl_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","utvrđene gradove Vet-Nimru i Vet-Aran, i torove za ovce. ");
INSERT INTO srponstl_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ruvimovci su sagradili Esevon, Elealiju, Kirijatajim, ");
INSERT INTO srponstl_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Navav i Val-Meon, kojima su promenili imena, i Sivmu; gradovima koje su sagradili dali su drugačija imena. ");
INSERT INTO srponstl_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Potomci Mahira, sina Manasijinog, su otišli u Galad, osvojili ga i isterali iz njega Amorejce koji su bili u njemu. ");
INSERT INTO srponstl_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Mojsije je dao Galad Mahiru, sinu Manasijinom, koji se naselio u njemu. ");
INSERT INTO srponstl_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Manasijin sin Jair je otišao i osvojio njihova sela, koje je prozvao „Jairova sela“. ");
INSERT INTO srponstl_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Zatim je Novah otišao i osvojio Kenat sa njegovim naseljima, i prozvao ga Novah po svom imenu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ovo su postaje Izrailjaca, kada su izašli iz Egipta po svojim odredima pod vodstvom Mojsija i Arona. ");
INSERT INTO srponstl_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Mojsije je popisao mesta njihovog polaska od postaje do postaje, kako je zapovedio Gospod. Ovo su njihove postaje prema polaznim tačkama: ");
INSERT INTO srponstl_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Krenuli su iz Ramese prvog meseca petnaestog dana. Dan posle Pashe, Izrailjci su pobedonosno izašli naočigled svih Egipćana, ");
INSERT INTO srponstl_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","dok su Egipćani sahranjivali sve svoje prvorođence, koje je Gospod pobio među njima. A Gospod je izvršio pravdu i nad njihovim bogovima. ");
INSERT INTO srponstl_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Izrailjci su krenuli iz Ramese i ulogorili se u Sokotu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Krenuli su iz Sokota i ulogorili se u Etamu, koji je na rubu pustinje. ");
INSERT INTO srponstl_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Krenuli su iz Etama, skrenuli prema Pi-Hahirotu, koji je nasuprot Vel-Sefona, i ulogorili se pred Migdolom. ");
INSERT INTO srponstl_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Krenuli su iz Irota, pa su sredinom mora prešli u pustinju. Zatim su išli tri dana preko pustinje Etama i ulogorili se u Mari. ");
INSERT INTO srponstl_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Otišli su iz Mare i došli u Elim, gde je bilo dvanaest studenaca i sedamdeset palminih stabala, i tamo se ulogorili. ");
INSERT INTO srponstl_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Krenuli su iz Elima i ulogorili se kod Crvenog mora. ");
INSERT INTO srponstl_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Zatim su otišli od Crvenog mora i ulogorili se u pustinji Sin. ");
INSERT INTO srponstl_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Otišli su iz pustinje Sin i ulogorili se u Dafaki. ");
INSERT INTO srponstl_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Otišli su iz Dafake i ulogorili se u Elusi. ");
INSERT INTO srponstl_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Otišli su iz Eluse i ulogorili se u Rafidinu, gde nije bilo vode da narod pije. ");
INSERT INTO srponstl_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Otišli su iz Rafidina i ulogorili se u Sinajskoj pustinji. ");
INSERT INTO srponstl_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Kad su otišli iz Sinajske pustinje ulogorili su se u Kivrot-Atavi. ");
INSERT INTO srponstl_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Otišli su iz Kivrot-Atave i ulogorili se u Asirotu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Otišli su iz Asirota i ulogorili se u Ratami. ");
INSERT INTO srponstl_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Otišli su iz Ratame i ulogorili se u Rimon-Faresu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Otišli su iz Rimon-Faresa i ulogorili se u Livni. ");
INSERT INTO srponstl_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Otišli su iz Livne i ulogorili se u Resi. ");
INSERT INTO srponstl_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Otišli su iz Rese i ulogorili se u Kelati. ");
INSERT INTO srponstl_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Otišli su iz Kelate i ulogorili se kod gore Safera. ");
INSERT INTO srponstl_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Otišli su od gore Safera i ulogorili se u Haradi. ");
INSERT INTO srponstl_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Otišli su iz Harade i ulogorili se u Makelotu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Otišli su iz Makelota i došli u Katati. ");
INSERT INTO srponstl_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Otišli su iz Katate i ulogorili se u Tarati. ");
INSERT INTO srponstl_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Otišli su iz Tarate i ulogorili se u Meteki. ");
INSERT INTO srponstl_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Otišli su iz Meteke i ulogorili se u Asmoni. ");
INSERT INTO srponstl_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Otišli su iz Asmone i ulogorili se u Moserotu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Otišli su iz Moserota i ulogorili se u Vene-Jakane. ");
INSERT INTO srponstl_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Otišli su iz Vene-Jakane i ulogorili se u Hor-Gadgadi. ");
INSERT INTO srponstl_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Otišli su iz Hor-Gadgade i ulogorili se u Jotvati. ");
INSERT INTO srponstl_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Otišli su iz Jotvate i ulogorili se u Evroni. ");
INSERT INTO srponstl_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Otišli su iz Evrone i ulogorili se u Esion-Geveru. ");
INSERT INTO srponstl_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Otišli su iz Esion-Gevera i ulogorili se u pustinju Cin, to jest u Kadisu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Otišli su iz Kadisa i ulogorili se kod gore Or, na kraju edomske zemlje. ");
INSERT INTO srponstl_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Tada se sveštenik Aron popeo na goru Or po Gospodnjoj zapovesti i umro tamo, prvog dana petog meseca, u četrdesetoj godina po izlasku Izrailjaca iz Egipta. ");
INSERT INTO srponstl_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aronu je bilo stotinu dvadeset tri godine kad je umro na gori Or. ");
INSERT INTO srponstl_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","A car Arada, Hananac, koji je živeo u Negevu hananskom, čuo je o dolasku Izrailjaca. ");
INSERT INTO srponstl_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Zatim su otišli od gore Ora i ulogorili se u Salmonu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Otišli su iz Salmona i ulogorili se u Finonu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Otišli su iz Finona i ulogorili se u Ovotu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Otišli su iz Ovota i ulogorili se kod Ije-Avarima, na području Moava. ");
INSERT INTO srponstl_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Otišli su iz Ije-Avarima i ulogorili se u Devon-Gadu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Otišli su iz Devon-Gada i ulogorili se u Gelmon-Devlataimu. ");
INSERT INTO srponstl_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Otišli su iz Gelmon-Devlataima i ulogorili se kod avarimskih gora, pred Navavom. ");
INSERT INTO srponstl_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Otišli su iz avarimskih gora i ulogorili se na moavskim poljanama, kraj Jordana, kod Jerihona. ");
INSERT INTO srponstl_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Tako su logorovali kraj Jordana, na moavskim poljanama, od Vet-Jesimota pa sve do Avel-Sitima. ");
INSERT INTO srponstl_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Tamo, na moavskim poljanama, kraj Jordana kod Jerihona, Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","„Govori Izrailjcima i reci im: ’Kad preko Jordana pređete u hanansku zemlju, ");
INSERT INTO srponstl_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","isterajte pred sobom sve stanovnike zemlje. Uništite sve njihove kipove, zatrite sve njihove livene idole, i razorite sve njihove uzvišice. ");
INSERT INTO srponstl_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Zauzmite zemlju i nastanite se u njoj, jer sam je vama dao u posed. ");
INSERT INTO srponstl_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Zemlju podelite žrebom prema svojim porodicama. Većoj dajte veće nasledstvo a manjoj dajte manje nasledstvo. I šta kome žreb odredi to neka mu bude. Primićete nasledstvo prema otačkim plemenima. ");
INSERT INTO srponstl_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Ali ako ne isterate pred sobom stanovnike zemlje, oni koje ostavite biće vam iverje u očima i trnje u bokovima; oni će vas kinjiti u zemlji u kojoj živite. ");
INSERT INTO srponstl_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","A ono što sam naumio da učinim njima, to ću učiniti vama.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","„Zapovedi Izrailjcima i reci im: ’Kad uđete u hanansku zemlju, zemlja koja vam je pripala u posed imaće ove granice: ");
INSERT INTO srponstl_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Južni deo će vam se protezati od pustinje Cin uz Edom. Južna granica će vam se protezati s ruba Mrtvog mora na istoku, ");
INSERT INTO srponstl_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","pa će zavijati na jug prema Akravimskoj uzvišici, ići prema Cinu, nastavljati se južno od Kadis-Varnije, izbiti na Asar-Adar i prelaziti preko Asemone. ");
INSERT INTO srponstl_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Granica će, zatim, od Asemone skrenuti prema Egipatskom potoku i izbiti na more. ");
INSERT INTO srponstl_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Zapadna granica će vam biti Veliko more; to neka vam bude zapadna granica. ");
INSERT INTO srponstl_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Ovo će vam biti severna granica: omeđite je od Velikog mora pa do gore Ora. ");
INSERT INTO srponstl_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Od gore Ora omeđite sebi granicu do Levo-Amata, a kraj granice neka bude Sedad. ");
INSERT INTO srponstl_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Neka se granica pruža do Zefrona, a kraj neka joj bude kod Asar-Enana. Neka vam to bude severna granica. ");
INSERT INTO srponstl_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Zatim omeđite sebi granicu od Asar-Enana do Sefama. ");
INSERT INTO srponstl_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Od Sefama granica će se spuštati prema Rivli istočno od Ajina, i nastaviti da se spušta dok ne dođe do istočne obale jezera Hineret. ");
INSERT INTO srponstl_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Zatim će se granica spuštati na Jordan i završavati na Mrtvom moru. To će biti vaša zemlja sa granicama koje je okružuju.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Mojsije zapovedi Izrailjcima: „Ovo je zemlja koju ćete žrebom naslediti, za koju je Gospod zapovedio da je dobije devet i po plemena. ");
INSERT INTO srponstl_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Naime, otački domovi potomaka Ruvimovog plemena, otački domovi potomaka Gadovog plemena, već su primili svoje nasledstvo. Svoje nasledstvo je primila i polovina Manasijinog plemena. ");
INSERT INTO srponstl_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Dva i po plemena su uzeli svoje nasledstvo s druge strane Jordana, nasuprot Jerihona, s istočne strane.“ ");
INSERT INTO srponstl_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","„Ovo su imena ljudi koji će vam podeliti zemlju: sveštenik Eleazar i Isus, sin Navinov. ");
INSERT INTO srponstl_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Uzmi i po jednog kneza iz svakog plemena da raspodeljuju zemlju. ");
INSERT INTO srponstl_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Ovo su imena tih ljudi: Halev, sin Jefonijin, iz Judinog plemena; ");
INSERT INTO srponstl_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Samuilo, sin Amijudov, iz plemena Simeunovih potomaka; ");
INSERT INTO srponstl_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Eldad, sin Haslonov, iz Venijaminovog plemena; ");
INSERT INTO srponstl_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","knez Vukija, sin Jeklinov, iz plemena Danovih potomaka. ");
INSERT INTO srponstl_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Od Josifovih potomaka: knez Anilo, sin Ufidov, iz plemena Manasijinih potomaka; ");
INSERT INTO srponstl_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","knez Kemuilo, sin Saftanov, iz plemena Jefremovih potomaka; ");
INSERT INTO srponstl_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","knez Elisafan, sin Farnahov, iz plemena Zavulonovih potomaka; ");
INSERT INTO srponstl_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","knez Faltilo, sin Ozainov, iz plemena Isaharovih potomaka; ");
INSERT INTO srponstl_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","knez Ahijud, sin Selemijin, iz plemena Asirovih potomaka; ");
INSERT INTO srponstl_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","i knez Fadailo, sin Amijudov, iz Neftalimovog plemena.“ ");
INSERT INTO srponstl_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Ovima je Gospod zapovedio da raspodele nasledstvo Izrailjcima u hananskoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Gospod reče Mojsiju na moavskim poljanama kod Jordana nasuprot Jerihona: ");
INSERT INTO srponstl_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","„Zapovedi Izrailjcima neka od svog nasledstva koje poseduju daju Levitima gradove da u njima žive. Daj Levitima i pašnjake koji okružuju gradove. ");
INSERT INTO srponstl_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Gradovi u kojima će živeti neka budu njihovi, a pašnjaci neka budu za njihovu stoku i sve njihove životinje. ");
INSERT INTO srponstl_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Neka pašnjaci oko gradova koje ćeš dati Levitima, budu hiljadu lakata udaljeni od gradskog zida, svuda unaokolo. ");
INSERT INTO srponstl_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Izvan grada izmeri dve hiljade lakata na istočnoj strani grada, dve hiljade lakata na južnoj strani, dve hiljada lakata na zapadnoj strani i dve hiljade lakata na severnoj strani, tako da grad bude u sredini. To neka im pripadne kao gradski pašnjaci. ");
INSERT INTO srponstl_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Od gradova koje ćete dati Levitima, šest će biti gradovi-utočišta, gde ćete dozvoliti ubici da pobegne. Uz njih dodajte još četrdeset dva grada. ");
INSERT INTO srponstl_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Neka bude ukupno četrdeset osam gradova, sa njihovim pašnjacima, koje ćete dati Levitima ");
INSERT INTO srponstl_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Kad dajete gradove od poseda Izrailjaca, od većih plemena uzmite više, a od manjih uzmite manje. Neka svako pleme ustupi nešto gradova Levitima prema obimu nasledstva koje je primilo.“ ");
INSERT INTO srponstl_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Gospod reče Mojsiju: ");
INSERT INTO srponstl_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","„Govori Izrailjcima i reci im: ’Kad preko Jordana pređete u hanansku zemlju, ");
INSERT INTO srponstl_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","odvojte sebi gradove za gradove-utočišta, gde će pobeći neko ko nehotice ubije čoveka. ");
INSERT INTO srponstl_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Neka vam ti gradovi budu utočišta od osvetnika, da ubica ne bi umro pre nego što stane na sud pred zajednicu. ");
INSERT INTO srponstl_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Od gradova koje ćete dati, šest će vam biti gradovi-utočišta. ");
INSERT INTO srponstl_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Za gradove-utočišta dajte tri grada s druge strane Jordana, a tri grada u hananskoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Neka ovih šest gradova služe kao utočišta Izrailjcima, strancu i došljaku, gde će pobeći svako ko je nehotice ubio nekoga. ");
INSERT INTO srponstl_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Ali ako neko udari koga gvozdenom alatkom, te on umre, on je ubica; neka se ubica svakako pogubi. ");
INSERT INTO srponstl_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Ako neko udari koga kamenom iz ruke od koga se može poginuti, i taj umre, on je ubica; neka se ubica svakako pogubi. ");
INSERT INTO srponstl_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ako neko udari koga drvenim predmetom iz ruke od koga se može poginuti, i taj umre, on je ubica; neka se ubica svakako pogubi. ");
INSERT INTO srponstl_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Krvni osvetnik mora lično da ubije ubicu. Kada ga sretne neka ga ubije. ");
INSERT INTO srponstl_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Ako neko iz mržnje, namerno, baci nešto na koga, pa ga ubije, ");
INSERT INTO srponstl_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ili iz neprijateljstva rukom udari koga, pa on umre, neka taj što ga je udario bude svakako pogubljen; ubica je. Neka krvni osvetnik pogubi ubicu kada ga sretne. ");
INSERT INTO srponstl_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Ali ako ga slučajno gurne bez neprijateljstva, ili ako nehotice baci nešto na njega, ");
INSERT INTO srponstl_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ili, ne videći ga, slučajno ispusti na njega kakav kamen koji može da usmrti, pa on umre, a pritom mu nije bio neprijatelj, niti je nameravao da mu naudi, ");
INSERT INTO srponstl_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","tada neka zajednica, prema ovim propisima, prosudi između onoga koji je usmrtio i osvetnika. ");
INSERT INTO srponstl_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Neka zajednica izbavi ubicu iz ruku krvnog osvetnika, i neka ga vrati u grad-utočište u koji je pobegao. Neka ostane u njemu do smrti Prvosveštenika, koji je bio pomazan svetim uljem. ");
INSERT INTO srponstl_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Ako ubica stupi izvan granice grada-utočišta u koji je pobegao, ");
INSERT INTO srponstl_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","a krvni osvetnik naiđe na njega izvan granice njegovog grada-utočišta, pa krvni osvetnik ubije ubicu, neće biti kriv za prolivenu krv. ");
INSERT INTO srponstl_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Naime, ubica mora da ostane u gradu-utočištu do smrti Prvosveštenika. Posle smrti Prvosveštenika ubica može da se vrati u zemlju gde ima posed. ");
INSERT INTO srponstl_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Ovo su uredbe i propisi za vas i vaše naraštaje u svim vašim mestima. ");
INSERT INTO srponstl_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Ko god ubije čoveka neka se pogubi na svedočanstvo svedoka. Niko ne može da bude osuđen na smrt na osnovu svedočanstva jednog svedoka. ");
INSERT INTO srponstl_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Ne primajte otkupninu za život ubice koji je kriv za smrt; on mora svakako da se pogubi. ");
INSERT INTO srponstl_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Ne primajte otkupninu ni za onoga koji je pobegao u svoj grad-utočište, da bi se vratio i živeo u zemlji pre smrti Prvosveštenika. ");
INSERT INTO srponstl_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Ne oskrnavljujte zemlju u kojoj živite, jer krv oskrnavljuje zemlju. Nikakvo otkupljenje se ne može izvršiti za zemlju na kojoj je prolivena krv, osim krvlju onoga koji ju je prolio. ");
INSERT INTO srponstl_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Ne oskrnavljujte zemlju u kojoj živite, i gde ja prebivam; jer ja, Gospod, prebivam među Izrailjcima.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Glavari otačkih domova porodica potomaka Galada, sina Mahirovog, sina Manasijinog, iz rodova Josifovih potomaka, pristupe i obrate se Mojsiju i knezovima, glavarima otačkih domova Izrailjaca. ");
INSERT INTO srponstl_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Rekli su: „Gospod je zapovedio mome gospodaru da se Izrailjcima žrebom podeli nasledstvo. Gospod je takođe zapovedio mome gospodaru da se nasledstvo našeg brata Salpada da njegovim ćerkama. ");
INSERT INTO srponstl_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Međutim, ako se one udaju za nekoga iz drugog izrailjskog plemena, njihov deo nasledstva biće otuđen od nasledstva naših predaka i biti pripojen nasledstvu drugog plemena u koje se udaju. Tako će nam se oduzeti deo nasledstva koje nam je dodeljeno. ");
INSERT INTO srponstl_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","A kad Izrailjcima dođe oprosna godina, onda će njihov deo nasledstva preći u nasledstvo plemena u koje se udaju. Tako će njihov deo nasledstva biti otuđen od nasledstva naših predaka.“ ");
INSERT INTO srponstl_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Tada je Mojsije, prema Gospodnjoj reči, zapovedio Izrailjcima: „Istina je što potomci Josifovog plemena kažu. ");
INSERT INTO srponstl_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ovo je reč koju Gospod zapoveda za Salpadove ćerke: ’One mogu da se udaju za koga hoće, pod uslovom da se udaju u porodicu iz plemena svoga oca. ");
INSERT INTO srponstl_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Nasledstvo Izrailjaca se ne može prenositi s plemena na pleme; neka svi Izrailjci zadrže nasledstvo svojih otačkih plemena. ");
INSERT INTO srponstl_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Svaka ćerka koja nasledi deo u jednom od izrailjskih plemena mora da se uda u porodicu iz plemena svoga oca, kako bi svaki Izrailjac zadržao u posedu nasledstvo svojih otaca. ");
INSERT INTO srponstl_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Nasledstvo se ne može prenositi s plemena na pleme, jer sva izrailjska plemena moraju da zadrže svoje nasledstvo.’“ ");
INSERT INTO srponstl_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Salpadove ćerke su uradile onako kako je Gospod zapovedio Mojsiju. ");
INSERT INTO srponstl_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mala, Tersa, Egla, Melha i Nuja, Salpadove ćerke, udale su se za sinove svojih stričeva, ");
INSERT INTO srponstl_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","i tako postale žene Manasijinih sinova, Josifovih potomaka; pa je nasledstvo ostalo u plemenu porodice njihovog oca. ");
INSERT INTO srponstl_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Ovo su zapovedi i propisi koje je Gospod preko Mojsija dao Izrailjcima na moavskim poljanama nasuprot Jordana, blizu Jerihona.");
INSERT INTO srponstl_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Ovo su reči koje je Mojsije izgovorio svem Izrailju s one strane Jordana, u pustinji u Aravi nasuprot Sufu, između Farana i Tofela, Lavana, Asirota i Di Zahava. ");
INSERT INTO srponstl_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","A od Horiva do Kadis-Varnije preko gore Sir ima jedanaest dana hoda. ");
INSERT INTO srponstl_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Četrdesete godine prvoga dana jedanaestoga meseca, Mojsije je rekao Izrailjcima sve što mu je Gospod zapovedio da im kaže. ");
INSERT INTO srponstl_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Nakon što je porazio amorejskog cara Sihona koji je vladao u Esevonu i vasanskog cara Oga koji je vladao u Astarotu u Edrajinu, ");
INSERT INTO srponstl_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","s one strane Jordana, u zemlji moavskoj, Mojsije je počeo da objašnjava ovaj Zakon. Govorio je: ");
INSERT INTO srponstl_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","„Gospod, naš Bog, rekao nam je na Horivu: ’Dosta ste boravili na ovoj gori. ");
INSERT INTO srponstl_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Zaputite se u gorski kraj Amorejaca i svih njihovih suseda, u Aravu, u gorje, u ravnicu i Negev, u Primorje, u zemlju Hananaca, i u Livan sve do velike reke, reke Eufrata. ");
INSERT INTO srponstl_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Pogledajte! Predao sam vam ovu zemlju. Idite i zauzmite tu zemlju za koju se Gospod zakleo vašim ocima Avrahamu, Isaku i Jakovu, da će je dati njima i njihovom potomstvu posle njih.’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","U to vreme sam vam rekao: ’Ne mogu sam upravljati vama. ");
INSERT INTO srponstl_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Gospod vas je toliko umnožio da vas je danas kao zvezda na nebu. ");
INSERT INTO srponstl_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Gospod, Bog vaših otaca, neka vas umnoži hiljadu puta više! Neka vas blagoslovi, kao što vam je obećao! ");
INSERT INTO srponstl_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Kako bih, inače, ja sam mogao da nosim vaš teret, vaša bremena i sporove? ");
INSERT INTO srponstl_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Izaberite sebi iz svakoga plemena ljude mudre, razumne i iskusne da vam ih postavim za glavare.’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","A vi ste mi odgovorili: ’Dobro je to što si rekao da ćeš učiniti!’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Tada sam uzeo glavare plemena, ljude mudre i iskusne, pa sam ih postavio vama za glavare, za zapovednike jedinica od hiljadu, stotinu, pedeset i deset, i za plemenske zapovednike. ");
INSERT INTO srponstl_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","U to vreme sam zapovedio vašim sudijama: ’Saslušajte svoju braću i sudite pravedno kad neko ima spor sa svojim sunarodnikom, ili sa strancem. ");
INSERT INTO srponstl_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Ne budite pristrani u suđenju, nego saslušavajte kako malog, tako velikog. Ne plašite se nikoga, jer sud pripada Bogu. Ako je spor suviše težak za vas, donesite ga meni da čujem.’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","U to vreme sam vam zapovedio sve što imate da činite. ");
INSERT INTO srponstl_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Zatim smo otišli s Horiva, pa smo prešli svu onu veliku i zastrašujuću pustinju koju ste videli na putu prema gorskom kraju Amorejaca, kako nam je zapovedio Gospod, naš Bog. Tako smo došli u Kadis-Varniju. ");
INSERT INTO srponstl_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Ja sam vam tada rekao: ’Došli ste u gorski kraj Amorejaca, koji vam daje Gospod, Bog vaš. ");
INSERT INTO srponstl_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Vidi, Gospod, Bog tvoj, predao ti je ovu zemlju. Uspni se i osvoji je, kao što ti je rekao Gospod, Bog tvojih otaca. Ne boj se i ne strahuj!’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Tada ste mi svi vi pristupili i rekli: ’Hajde da pošaljemo ljude ispred nas da izvide zemlju i donesu nam izveštaj o putu kojim ćemo ići i gradovima u koje ćemo doći.’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Ovaj predlog mi se dopao. Zato sam odabrao između vas dvanaestoricu ljudi, iz svakog plemena po jednog. ");
INSERT INTO srponstl_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Oni su krenuli, uspeli se u gorje, te došli u dolinu Eshol i izvideli je. ");
INSERT INTO srponstl_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Onda su poneli u svojim rukama plodove te zemlje, pa su se spustili k nama i doneli nam izveštaj. Rekli su: ’Zemlja koju nam Gospod daje je dobra.’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Međutim, vi niste hteli da pođete gore, nego ste se pobunili protiv naredbe Gospoda, svoga Boga. ");
INSERT INTO srponstl_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Gunđali ste u svojim šatorima i govorili: ’Gospod nas mrzi! Izveo nas je iz Egipta da nas preda Amorejcima u ruke, kako bi nas istrebili. ");
INSERT INTO srponstl_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Kuda da idemo? Naša braća su napunila naše srce strahom, govoreći: „taj narod je veći i viši rastom od nas, a gradovi su im ogromni i opasani zidinama do nebesa. I Enakovce smo tamo videli!“’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Tada sam vam rekao: ’Ne strahujte! Ne bojte ih se! ");
INSERT INTO srponstl_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Gospod, Bog vaš, koji ide pred vama, ratovaće za vas, kao što je to činio u Egiptu na vaše oči. ");
INSERT INTO srponstl_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","U pustinji si video da te je Gospod, Bog tvoj, nosio kao što otac nosi svoga sina tokom celog puta koji ste prevalili sve dok niste došli do ovog mesta.’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Ali i pored toga niste se pouzdali u Gospoda, Boga svoga, ");
INSERT INTO srponstl_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","koji ide pred vama da vam potraži mesto za taborovanje – noću u ognju da vidite put na koji ste krenuli, a danju u oblaku. ");
INSERT INTO srponstl_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Kad je Gospod čuo šta ste rekli, razgnevio se i zakleo: ");
INSERT INTO srponstl_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","’Nijedan od ovih ljudi iz ovog zlog naraštaja neće videti dobru zemlju za koju sam se zakleo da ću je dati vašim ocima, ");
INSERT INTO srponstl_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","osim Haleva, sina Jefonijina. On će je videti! Njemu i njegovim sinovima ću dati zemlju u koju je stupio, zato što se potpuno pouzdao u Gospoda.’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Zbog vas se Gospod razgnevio i na mene, pa je rekao: ’Ni ti nećeš ući tamo! ");
INSERT INTO srponstl_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Isus, sin Navinov, koji stoji pred tobom, ući će tamo. Ohrabri ga, jer će on uvesti Izrailja da primi zemlju u posed. ");
INSERT INTO srponstl_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","A vaša deca, za koju ste rekli da će postati plen, oni će ući tamo. Njima ću dati da zauzmu zemlju. ");
INSERT INTO srponstl_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Vi, pak, krenite natrag i idite u pustinju prema Crvenom moru.’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Vi ste mi odgovorili: ’Zgrešili smo Gospodu. Krenućemo gore i ratovati kako je zapovedio Gospod, Bog naš.’ Svaki čovek je pripasao svoje oružje misleći da je lako uspeti se u gorski kraj. ");
INSERT INTO srponstl_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Tada mi je Gospod rekao: ’Reci im: „Ne penjite se i ne ratujte, jer neću biti među vama; inače ćete biti potučeni od svojih neprijatelja!“’ ");
INSERT INTO srponstl_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ja sam vam to rekao, ali vi niste poslušali. Pobunili ste se protiv onoga što je Gospod rekao, pa ste se pripasali i uspeli u gorje. ");
INSERT INTO srponstl_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Tada su izašli Amorejci koji žive u gorju i presreli vas goneći vas kao pčele. Tukli su vas od Sira do Orme. ");
INSERT INTO srponstl_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Onda ste se vratili i plakali pred Gospodom. Ali Gospod nije slušao vaš vapaj, niti se obazreo na vas. ");
INSERT INTO srponstl_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Zato ste ostali u Kadisu mnogo dana – onoliko koliko ste ostali tamo. ");
INSERT INTO srponstl_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Okrenuli smo se i zaputili u pustinju prema Crvenom moru kako nam je rekao Gospod. Dugo vremena smo se vrteli oko gore Sir. ");
INSERT INTO srponstl_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Tada mi je Gospod rekao: ");
INSERT INTO srponstl_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","’Dosta ste se vrteli oko ove gore. Okrenite se prema severu! ");
INSERT INTO srponstl_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Zapovedi narodu: „Sada prolazite kroz područje vaše braće, Isavovih potomaka, koji žive u Siru. Oni vas se boje, ali se vi dobro čuvajte! ");
INSERT INTO srponstl_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Ne upuštajte se u sukob sa njima, jer vam neću dati ni stopu od njihove zemlje. Naime, Sir sam dao Isavu u posed. ");
INSERT INTO srponstl_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Hranu od njih kupujte za novac, da imate šta da jedete, a takođe i vodu plaćajte novcem.“’ ");
INSERT INTO srponstl_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Jer, Gospod, Bog tvoj, koji te je blagoslovio u svim tvojim poduhvatima, zna da prolaziš kroz ovu veliku pustinju. Gospod, Bog tvoj, ovih je četrdeset godina bio s tobom, te ti ništa nije nedostajalo. ");
INSERT INTO srponstl_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Tako smo zaobišli svoju braću, potomke Isavove, koji žive u Siru, putem što vodi u Aravu, Elat i Esion-Gever, pa smo skrenuli na put što vodi u moavsku pustinju. ");
INSERT INTO srponstl_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Gospod mi reče: ’Ne napadaj Moavce, niti stupaj u rat s njima, jer ti neću dati u posed njihovu zemlju: Lotovim potomcima sam dao Ar u posed.’ ");
INSERT INTO srponstl_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Tamo su nekada živeli Emijci. Bio je to narod veliki i brojan; visoki kao Enakovci. ");
INSERT INTO srponstl_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Njih, kao i Enakovce, takođe svrstavaju u Refaimce, iako ih Moavci zovu Emijcima. ");
INSERT INTO srponstl_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","U Siru su nekada živeli Horijci. Isavovi potomci su prisvojili njihovu zemlju, istrebili ih i naselili se na njihovo mesto. To isto je učinio Izrailj u zemlji koju mu je Gospod dao u posed.) ");
INSERT INTO srponstl_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","’A sad ustanite i pređite preko potoka Zareda.’ Tako smo prešli preko potoka Zareda. ");
INSERT INTO srponstl_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Putovali smo trideset osam godina od Kadis-Varnije do prelaska potoka Zareda, sve dok nije pomro čitav taj naraštaj ljudi u taboru sposobnih za ratovanje, kao što im se Gospod zakleo. ");
INSERT INTO srponstl_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Šta više, Gospodnja ruka se okrenula protiv njih da ih smete usred tabora, dok svi nisu bili istrebljeni. ");
INSERT INTO srponstl_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","A kada su pomrli u narodu svi ljudi sposobni za ratovanje, ");
INSERT INTO srponstl_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Gospod mi reče: ");
INSERT INTO srponstl_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","’Danas prelaziš preko moavskog područja kod Ara. ");
INSERT INTO srponstl_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Kad se približiš Amoncima, ne napadaj ih, niti se upuštaj u sukob sa njima, jer ti neću dati u posed zemlju Amonaca. Naime, nju sam je dao u posed Lotovim potomcima.’ ");
INSERT INTO srponstl_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Ta zemlja je nekada pripadala Refaimcima, koje su Amonci zvali i ’Zamzumićanima’. ");
INSERT INTO srponstl_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","To je bio narod veliki i brojan; bili su visokog rasta kao Enakovci. Gospod ih je istrebio pred Amoncima koji su prisvojili njihovu zemlju i naselili se na njihovo mesto. ");
INSERT INTO srponstl_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","To su isto učinili i potomci Isava koji žive u Siru. Oni su istrebili Horijce, prisvojili njihovu zemlju i nastanili se na njihovo mesto gde žive sve do danas. ");
INSERT INTO srponstl_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","A Avince, koji su živeli u selima oko Gaze, istrebili su Kaftoreji, koji dolaze iz Kaftora, i naselili se na njihovo mesto.) ");
INSERT INTO srponstl_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","’Ustanite i nastavite put, pa pređite preko potoka Arnona! Evo, predao sam vam u ruke Sihona, cara esevonskog, Amorejca, i njegovu zemlju. Počni da je osvajaš! Stupi u rat protiv njega! ");
INSERT INTO srponstl_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Danas počinjem da pred tobom širim strah i trepet među narode pod celim nebom. Oni će čuti glasine o tebi, pa će drhtati od straha pred tobom i spopadaće ga užas od tebe.’ ");
INSERT INTO srponstl_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Tada sam iz pustinje Kedemot poslao glasnike esevonskom caru Sihonu s miroljubivom porukom: ");
INSERT INTO srponstl_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","’Dozvoli mi da prođem preko tvoje zemlje. Ići ću glavnim putem i neću skretati ni desno ni levo. ");
INSERT INTO srponstl_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Hranu za jelo i vodu za piće prodaj mi za novac. Samo mi dozvoli da prođem pešice, ");
INSERT INTO srponstl_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","dok ne pređem preko Jordana u zemlju koju nam daje Gospod, Bog naš. Tako su mi učinili i Isavovi potomci koji žive u Siru i Moavci koji žive u Aru.’ ");
INSERT INTO srponstl_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Ali Sihon, car esevonski, nije nam dao da prođemo, jer je Gospod, Bog tvoj, učinio njegov duh nepopustljivim a njegovo srce tvrdim, kako bi ga predao u tvoje ruke, kao što i jeste danas. ");
INSERT INTO srponstl_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Gospod mi reče: ’Evo, počeo sam da ti predajem Sihona i njegovu zemlju. Počni da osvajaš njegovu zemlju, kako bi je prisvojio!’ ");
INSERT INTO srponstl_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Tada je Sihon izašao pred nas, on i sav njegov narod u boj kod Jase. ");
INSERT INTO srponstl_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Ali, Gospod, Bog naš, nam ga je predao, tako da smo porazili njega, njegove sinove i njegov narod. ");
INSERT INTO srponstl_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","U to vreme smo zauzeli sve njegove gradove i izvršili kleto uništenje nad svakim gradom – nad muškarcima, ženama i decom – nikog živog nismo ostavili. ");
INSERT INTO srponstl_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Zaplenili smo samo stoku i odneli plen iz gradova koje smo osvojili. ");
INSERT INTO srponstl_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Od Aroira, koji se nalazi kod potoka Arnona i grada koji je kod potoka, sve do Galada, nije bilo grada koji je bio previsok za nas. Sve nam ih je predao Gospod, Bog naš. ");
INSERT INTO srponstl_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Samo se zemlji Amonaca nisi približavao: potoku Javoku, niti gradovima u gorju, baš kako je zapovedio Gospod, Bog naš. ");
INSERT INTO srponstl_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Zatim smo se okrenuli i krenuli gore putem za Vasan. Tada je Og, vasanski car, i sav njegov narod, izašao u boj protiv nas kod Edrajina. ");
INSERT INTO srponstl_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Tada mi Gospod reče: ’Ne boj ga se, jer sam u tvoje ruke predao i njega, i sav njegov narod i njegovu zemlju. Učini s njim kao što si učinio s amorejskim carem Sihonom, koji je živeo u Esevonu.’ ");
INSERT INTO srponstl_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Gospod, naš Bog, je predao u naše ruke vasanskog cara Oga i sav njegov narod; tako da mu nije ostao ni jedan preživeli. ");
INSERT INTO srponstl_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","U to vreme smo zauzeli sve njegove gradove. Nije bilo grada koji im nismo oduzeli – šezdeset gradova, to jest, celu oblast Argov, Ogovo carstvo u Vasanu. ");
INSERT INTO srponstl_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Svi ovi gradovi su bili utvrđeni visokim zidinama, vratima i prevornicama. Uz njih je bilo mnogo neutvrđenih sela. ");
INSERT INTO srponstl_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","I nad njima smo izvršili kleto uništenje, kao što smo učinili sa esevonskim carem Sihonom, kada smo izvršili kleto uništenje nad svim njihovim gradovima: nad muškarcima, ženama i decom. ");
INSERT INTO srponstl_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Zaplenili smo samo stoku i odneli plen iz gradova. ");
INSERT INTO srponstl_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Tako smo u ono vreme oteli zemlju iz ruku dvojice amorejskih careva, što se nalazi s one strane Jordana, od potoka Arnona do gore Ermon ");
INSERT INTO srponstl_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Sidonci zovu Ermon Sirjon a Amorejci ga zovu Senir), ");
INSERT INTO srponstl_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","sve gradove u ravnici, u celom Galadu, celom Vasanu, sve do Salke i Edrajina – gradove Ogovog carstva u Vasanu. ");
INSERT INTO srponstl_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Og, vasanski car, je jedini preostali Refaimac. Njegov gvozdeni krevet se još uvek nalazi u Ravi amonskoj. Bio je devet lakata dug i četiri lakta širok, mereno običnim laktom.) ");
INSERT INTO srponstl_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","U to vreme smo osvojili ovu zemlju od Aroira koji je kod potoka Arnona. Pola galadskog gorja i njegove gradove dao sam Ruvimovom i Gadovom plemenu. ");
INSERT INTO srponstl_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Što je ostalo od Galada i celi Vasan, Ogovo carstvo, dao sam polovini Manasijinog plemena. Cela argovska oblast i sav Vasan nekada su se zvali ’zemlja Refaimaca’. ");
INSERT INTO srponstl_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jair, Manasijin sin, je osvojio celi argovski kraj do gesurske i mahatske granice. Ta vasanska mesta je nazvao po sebi, tako da se i dan danas zovu ’Jairova sela’. ");
INSERT INTO srponstl_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Mahiru sam dao Galad. ");
INSERT INTO srponstl_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Ruvimovom i Gadovom plemenu sam dao područje od Galada kod potoka Arnona, čijom sredinom se pruža granica, sve do potoka Javoka, gde je Amonska granica. ");
INSERT INTO srponstl_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Jordan i Arava su služili kao granica koja se protezala od jezera Hineret do mora kod Arave – Mrtvog mora – podno obronaka Fasge na istoku. ");
INSERT INTO srponstl_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","U ono vreme sam vam zapovedio: ’Gospod, Bog vaš, dao vam je ovu zemlju da je zaposednete. Svi vi koji ste sposobni za boj krenite naoružani ispred svoje braće. ");
INSERT INTO srponstl_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Neka samo vaše žene, nejač i stoka – jer znam da imate mnogo stoke – ostanu u vašim gradovima koje sam vam dao. ");
INSERT INTO srponstl_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Kad Gospod da počinak vašoj braći i vama, te kad osvoje zemlju koju im Gospod daje s one strane Jordana, tada svaki čovek neka se vrati na posed koji sam vam dao.’ ");
INSERT INTO srponstl_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","U ono vreme sam zapovedio Isusu: ’Svojim očima si video sve što je Gospod, Bog tvoj, učinio ovoj dvojici careva; Gospod će tako učiniti i drugim carstvima kroz koja budeš prolazio. ");
INSERT INTO srponstl_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Ne plaši ih se, jer će se Gospod, Bog vaš, boriti za vas.’ ");
INSERT INTO srponstl_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","U ono vreme sam molio Gospoda: ");
INSERT INTO srponstl_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","’Gospode, Bože, ti si počeo da pokazuješ svome sluzi svoju veličinu i svoju moćnu ruku. Jer, koji to Bog na nebesima ili na zemlji može da čini takva dela i čudesa? ");
INSERT INTO srponstl_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Sada mi dopusti da uđem i vidim dobru zemlju s one strane Jordana, predivno gorje i Livan.’ ");
INSERT INTO srponstl_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Ali se Gospod naljutio na mene zbog vas i nije me poslušao. Gospod mi je rekao: ’Dosta! Ne pominji mi više ovo! ");
INSERT INTO srponstl_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Uspni se na vrh Fasge i digni svoj pogled prema zapadu i severu, prema jugu i istoku. Dobro pogledaj svojim očima, jer nećeš preći preko ovog Jordana. ");
INSERT INTO srponstl_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Isusa uvedi u dužnost; ohrabri ga i osokoli, jer će on predvoditi ovaj narod i dovesti ih da prime u posed ovu zemlju koju ćeš videti.’ ");
INSERT INTO srponstl_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Tako smo ostali u dolini kod Vet-Fegora. ");
INSERT INTO srponstl_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","A sad, Izrailju, poslušaj zapovesti i uredbe koje vas učim da držite, da biste mogli da živite, te da biste mogli da uđete i zaposednete zemlju koju vam daje Gospod, Bog vaših otaca. ");
INSERT INTO srponstl_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ne dodajte ništa onome što vam zapovedam, niti šta oduzimajte od toga, nego držite zapovesti Gospoda, Boga vašeg, koje vam nalažem. ");
INSERT INTO srponstl_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Svojim očima ste videli šta je Gospod učinio Val-Fegoru – kako je Gospod, Bog tvoj, istrebio iz tvoje sredine svakog ko je pošao za Val-Fegorom. ");
INSERT INTO srponstl_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","A vi, koji ste stali uz Gospoda, živi ste i danas. ");
INSERT INTO srponstl_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Evo, poučio sam vas o zapovestima i uredbama koje mi je Gospod, Bog moj, zapovedio da ih vršite u zemlji u koju ulazite da je zaposednete. ");
INSERT INTO srponstl_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Držite ih i vršite, jer će to biti vaša mudrost i razum u očima naroda. Kad budu čuli za sve ove uredbe, reći će: ’Samo je ovaj veliki narod mudar i razuman.’ ");
INSERT INTO srponstl_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Jer, ima li koji drugi veliki narod boga koji mu je toliko blizu kao što je nama blizu Gospod, Bog naš, kad god ga prizovemo? ");
INSERT INTO srponstl_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Koji to veliki narod ima tako pravedne zapovesti i uredbe, kao što je sav ovaj Zakon koji vam danas dajem? ");
INSERT INTO srponstl_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Samo pazi i dobro se čuvaj da ne zaboraviš događaje koje si video svojim očima. Neka ne iščile iz tvog sećanja celog tvog života; šta više, pouči o njima i svoju decu i svoje unuke. ");
INSERT INTO srponstl_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Onog dana kada si stajao na Horivu pred Gospodom, Bogom svojim, Gospod mi je rekao: ’Okupi mi narod da čuje moje reči, da nauče da me se boje dokle god žive u ovoj zemlji, i da tome nauče i svoju decu.’ ");
INSERT INTO srponstl_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Vi ste se primakli i stali u podnožje gore koja je bacala oganj sve do samog neba, dok je okolinu prekrivao mrak i gusta tama. ");
INSERT INTO srponstl_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Tada vam je Gospod progovorio iz ognja. Čuli ste zvuk reči, ali niste videli nikakav lik – čuli ste samo glas. ");
INSERT INTO srponstl_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","On vam je objavio svoj savez i zapovedio vam da vršite deset zapovesti koje je napisao na dve kamene ploče. ");
INSERT INTO srponstl_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","U ono vreme mi je Gospod zapovedio da naučite zapovesti i uredbe, kako biste ih vršili u zemlji u koju ulazite da je osvojite. ");
INSERT INTO srponstl_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Zato se dobro uzmite u pamet! Onoga dana kada vam je Gospod govorio na Horivu iz ognja, niste videli nikakav lik, ");
INSERT INTO srponstl_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","da se ne biste pokvarili, te da ne biste napravili sebi isklesani lik ili kip u obliku muških ili ženskih likova, ");
INSERT INTO srponstl_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","niti u obliku stoke što je na zemlji, ili ptica što lete po nebesima, ");
INSERT INTO srponstl_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","niti u obliku gmizavaca što puze po zemlji, ili riba što su u vodi pod zemljom. ");
INSERT INTO srponstl_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","I kad pogledaš na nebo i vidiš sunce, mesec i zvezde – svu vojsku nebesku, nemoj da se prevariš i počneš da im se klanjaš i da im služiš. Njih je Gospod, Bog tvoj, dao za sve narode pod celim nebom. ");
INSERT INTO srponstl_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","A vas je Gospod uzeo i izveo vas iz one usijane peći, Egipta, da budete njegov narod, njegova svojina, kao što i jeste danas. ");
INSERT INTO srponstl_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","No, Gospod se razgnevio na mene zbog vas i zakleo se da neću preći preko Jordana i ući u dobru zemlju koji ti Gospod, Bog tvoj daje u posed. ");
INSERT INTO srponstl_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","I eto, ja ću umreti u ovoj zemlji i neću preći preko Jordana, a vi ćete preći i zauzeti ovu dobru zemlju. ");
INSERT INTO srponstl_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Pazite da ne zaboravite savez koji je Gospod, Bog vaš, sklopio sa vama, da ne bi pravili sebi klesane likove bilo čega što vam je zabranio Gospod, Bog vaš. ");
INSERT INTO srponstl_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Jer, Gospod, Bog tvoj, oganj je koji spaljuje; on je ljubomorni Bog. ");
INSERT INTO srponstl_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","A, ako dobiješ sinove i unuke i ostanete u zemlji, pa se pokvarite i načinite sebi svakojake klesane likove čineći što je zlo u očima Gospoda, Boga tvoga, te izazovete njegov gnev, ");
INSERT INTO srponstl_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","evo – pozivam danas protiv vas nebo i zemlju kao svedoke – bićete brzo istrebljeni iz zemlje u koju idete preko Jordana da je zauzmete; nećete dugo ostati na njoj, nego ćete biti sasvim istrebljeni. ");
INSERT INTO srponstl_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Gospod će vas rasejati među narode. Od vas će preostati tek mali broj među narodima kojima će vas Gospod odvesti. ");
INSERT INTO srponstl_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Tamo ćete služiti bogovima koje su ljudske ruke načinile od drveta i kamena, koji ne mogu ni da vide ni da čuju, ni da jedu ni da mirišu. ");
INSERT INTO srponstl_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Odande ćete tražiti Gospoda, Boga svoga. Naći ćeš ga ako ga potražiš svim srcem svojim i svom dušom svojom. ");
INSERT INTO srponstl_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Kada budeš u nevolji i sve te ovo snađe u poslednjim danima, tada ćeš se okrenuti Gospodu, Bogu svome, pa ćeš slušati njegov glas. ");
INSERT INTO srponstl_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Jer, Gospod, Bog tvoj, milostivi je Bog; on te neće ostaviti ni uništiti, niti će zaboraviti savez koji je pod zakletvom sklopio s tvojim ocima. ");
INSERT INTO srponstl_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Stoga, ispitaj protekla vremena što su minula pre tebe, od kada je Bog stvorio čovečanstvo na zemlji, raspitaj se s jednog kraja neba do drugog: zar se ikada nešto tako veličanstveno dogodilo? Zar se tako nešto čulo? ");
INSERT INTO srponstl_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Zar je koji narod čuo da mu glas Božiji govori iz ognja, kao što si ti čuo i ostao živ? ");
INSERT INTO srponstl_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Ili, zar je ijedan bog pokušao da ode i uzme jedan narod za sebe iz drugog naroda kaznama, znacima i čudesima, ratom, moćnom rukom i ispruženom mišicom, te velikim strahom, kao što je sve to Gospod, Bog tvoj, uradio za tebe u Egiptu na tvoje oči? ");
INSERT INTO srponstl_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","To ti je pokazano da znaš da je Gospod pravi Bog i da osim njega nema drugog. ");
INSERT INTO srponstl_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Oglasio ti se s neba da se poučiš. Na zemlji ti je dozvolio da vidiš njegov veliki oganj i da čuješ njegove reči iz ognja. ");
INSERT INTO srponstl_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","A zato što je zavoleo tvoje oce, izabrao je njihovo potomstvo posle njih. Tebe je, pak, izveo iz Egipta svojom velikom silom, ");
INSERT INTO srponstl_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","da istera velike narode koji su brojniji od tebe, kako bi te uveo u zemlju i dao ti je u posed, kao što je to danas. ");
INSERT INTO srponstl_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Stoga, znaj danas i uzmi k srcu da je Gospod pravi Bog gore na nebesima i dole na zemlji; drugoga nema. ");
INSERT INTO srponstl_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Drži njegove zakone i zapovesti koje ti zapovedam danas, da dobro bude tebi i tvojim sinovima posle tebe i da proživiš dugo vremena na zemlji koju ti Gospod, Bog tvoj, daje u sve dane.“ ");
INSERT INTO srponstl_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Tada je Mojsije izdvojio tri grada istočno od Jordana, ");
INSERT INTO srponstl_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","gde svaki ubica može da pobegne ako slučajno ubije svoga bližnjeg prema kome nije gajio mržnju, te tako spase sebi život u jednom od tih gradova. ");
INSERT INTO srponstl_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","A ovo su gradovi: za Ruvimovo pleme – Vosor na pustinjskoj visoravni, za Gadovo pleme – Ramot u Galadu, za Manasijino pleme – Golan u Vasanu. ");
INSERT INTO srponstl_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Ovo je Zakon koji je Mojsije izložio Izrailjcima; ");
INSERT INTO srponstl_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ovo su propisi, uredbe i pravila koje je Mojsije saopštio Izrailjcima kad su izašli iz Egipta, ");
INSERT INTO srponstl_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","s one strane Jordana, u dolini nasuprot Vet-Fegora, u zemlji Sihona, amorejskog cara koji vlada u Esevonu. Njega su Mojsije i Izrailjci porazili kad su izašli iz Egipta ");
INSERT INTO srponstl_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","i osvojili njegovu zemlju, te zemlju Oga, cara vasanskog, dvaju amorejskih careva koji su živeli s druge strane Jordana, na istoku: ");
INSERT INTO srponstl_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","od Aroira, koji se nalazi na obali potoka Arnona do gore Siriona, to jest, Ermona, ");
INSERT INTO srponstl_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","i svu Aravu na istočnoj strani Jordana, sve do mora kod Arave, pod obroncima Fasge. ");
INSERT INTO srponstl_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Mojsije pozva sve Izrailjce i reče im: „Poslušaj, o Izrailju, sve propise i odredbe koje vam danas govorim na vaše uši! Naučite da ih držite, kako biste ih vršili. ");
INSERT INTO srponstl_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Gospod, Bog naš, je sa nama sklopio savez na Horivu. ");
INSERT INTO srponstl_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Gospod nije sklopio ovaj savez s vašim ocima, nego s nama svima koji smo ovde danas živi. ");
INSERT INTO srponstl_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Gospod je s vama govorio licem u lice na gori usred ognja. ");
INSERT INTO srponstl_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","U ono vreme sam stajao između Gospoda i vas da vam objavim reč Gospodnju, jer ste se uplašili od ognja, te se niste popeli na goru. On je rekao: ");
INSERT INTO srponstl_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","’Ja sam Gospod, Bog tvoj, koji sam te izveo iz zemlje egipatske, iz kuće ropstva. ");
INSERT INTO srponstl_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Nemoj imati druge bogove osim mene. ");
INSERT INTO srponstl_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Ne pravi sebi idola, ni obličja od bilo čega što je gore na nebesima, ili dole na zemlji, ili u vodi pod zemljom. ");
INSERT INTO srponstl_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Ne klanjaj im se, niti im služi. Jer sam ja, Gospod, tvoj Bog, ljubomorni Bog, koji kažnjava decu zbog krivice njihovih otaca, do trećeg i četvrtog kolena – onih koji me mrze, ");
INSERT INTO srponstl_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","ali iskazujem milost hiljadama koji me ljube i vrše moje zapovesti. ");
INSERT INTO srponstl_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Ne uzimaj uzalud ime Gospoda, Boga svoga, jer neće pred Gospodom biti bez krivice onaj koji uzalud izgovara njegovo ime. ");
INSERT INTO srponstl_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Drži dan subotnji, i posvećuj ga kako ti je zapovedio Gospod, Bog tvoj. ");
INSERT INTO srponstl_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Šest dana radi i obavljaj sve svoje poslove. ");
INSERT INTO srponstl_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","A sedmi dan je subota Gospodu, tvome Bogu. Ne radi nikakva posla, ni ti, ni tvoji sinovi i ćerke, ni tvoje sluge i sluškinje, ni tvoj vo, ni tvoj magarac, niti išta od tvoje stoke, ni stranac koji živi u tvojim gradovima, da bi se i tvoj sluga i tvoja sluškinja odmorili, kao ti. ");
INSERT INTO srponstl_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Seti se da si bio rob u Egiptu i da te je Gospod, Bog tvoj, izveo odande snažnom rukom i ispruženom mišicom. Zato ti je Gospod, Bog tvoj, zapovedio da vršiš dan subotnji. ");
INSERT INTO srponstl_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Poštuj svoga oca i svoju majku, kao što ti je zapovedio Gospod, Bog tvoj, da bi ti se produžili dani, i da bi ti bilo dobro na zemlji koju ti daje Gospod, Bog tvoj. ");
INSERT INTO srponstl_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Ne ubij! ");
INSERT INTO srponstl_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Ne čini preljube! ");
INSERT INTO srponstl_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Ne kradi! ");
INSERT INTO srponstl_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Ne svedoči lažno protiv bližnjega svoga! ");
INSERT INTO srponstl_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Ne poželi ženu bližnjega svoga. Ne priželjkuj kuću bližnjega svoga, ni polje njegovo, ni slugu njegovog, ni sluškinju njegovu, ni vola njegovog, ni magarca njegovog, niti išta što pripada tvome bližnjemu.’ ");
INSERT INTO srponstl_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Gospod nije ništa dodavao rečima koje je gromkim glasom saopštio celoj tvojoj zajednici na gori iz ognja, oblaka i guste tame. Upisao ih je na dve kamene ploče i predao mi ih. ");
INSERT INTO srponstl_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Kada ste čuli glas iz tame, dok je gora plamtela u ognju, pristupili ste mi sa svim glavarima vaših plemena i starešinama. ");
INSERT INTO srponstl_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Tada ste rekli: ’Evo, Gospod, Bog naš, pokazao nam je svoju slavu i svoje veličanstvo, te smo čuli njegov glas iz ognja. Danas smo videli da čovek može da ostane u životu iako mu Bog govori. ");
INSERT INTO srponstl_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Zašto sad da umremo? Naime, proždraće nas ovaj veliki oganj, pa ćemo umreti ako nastavimo da slušamo glas Gospoda, Boga našega. ");
INSERT INTO srponstl_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Jer, postoji li iko ko je čuo glas živoga Boga da govori usred ognja, kao mi, i ostao u životu? ");
INSERT INTO srponstl_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Ti pristupi i slušaj sve što kaže Gospod, Bog naš. Sve što ti saopšti Gospod, Bog naš, ti prenesi nama, a mi ćemo to poslušati i izvršiti.’ ");
INSERT INTO srponstl_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Gospod je čuo što ste mi rekli, pa mi je rekao: ’Poslušaću reči koje ti je ovaj narod uputio. Dobro je sve što su rekli. ");
INSERT INTO srponstl_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","O, kad bi se samo u srcu bojali mene i stalno se držali mojih zapovesti, da bi doveka bilo dobro njima i njihovoj deci! ");
INSERT INTO srponstl_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Idi i reci im neka se vrate u svoje šatore. ");
INSERT INTO srponstl_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","A ti ostani ovde sa mnom i ja ću ti reći sve zapovesti, propise i odredbe koje ćeš ih naučiti da vrše u zemlji koju im dajem u posed.’ ");
INSERT INTO srponstl_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Zato pazite da ih vršite, baš kao što vam je zapovedio Gospod, Bog vaš. Ne odstupajte od njih ni levo ni desno! ");
INSERT INTO srponstl_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","U potpunosti se držite puta koji vam je odredio Gospod, Bog vaš, da bi ostali u životu, da bi vam bilo dobro i da bi dugo proživeli u zemlji koju ćete zaposesti. ");
INSERT INTO srponstl_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Ovo su zapovesti, propisi i odredbe koje mi je Gospod, Bog vaš, naredio da vas njima poučim, kako biste ih vršili u zemlji u koju idete da je zauzmete, ");
INSERT INTO srponstl_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","da bi se ti, tvoja deca i tvoji unuci bojali Gospoda, Boga svoga, celog svog života, držeći sve uredbe i zapovesti koje ti nalažem, i tako imali dug život. ");
INSERT INTO srponstl_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Slušaj, Izrailju, drži ih i izvršavaj, da ti dobro bude i da se veoma umnožite u zemlji kojom teku med i mleko, kao što ti je obećao Gospod, Bog tvojih otaca. ");
INSERT INTO srponstl_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Čuj, Izrailju! Gospod, Bog naš, jedini je Gospod. ");
INSERT INTO srponstl_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Zato, voli Gospoda, Boga svoga, svim srcem svojim, svom dušom svojom i svom snagom svojom. ");
INSERT INTO srponstl_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Neka ove reči koje ti danas zapovedam budu na tvom srcu. ");
INSERT INTO srponstl_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Napominji ih svojim sinovima. Govori im o njima kad sediš u svojoj kući i kad ideš putem; kad ležeš i kad ustaješ. ");
INSERT INTO srponstl_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Priveži ih kao znak na svoju ruku, i neka ti budu kao zapis među očima. ");
INSERT INTO srponstl_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Napiši ih na dovratnicima svoga doma i na vratima tvojim. ");
INSERT INTO srponstl_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","A kad te Gospod, Bog tvoj, uvede u zemlju za koju se zakleo tvojim ocima, Avrahamu, Isaku i Jakovu, da će je dati tebi – u dobre i velike gradove koje nisi gradio; ");
INSERT INTO srponstl_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","u kuće pune svakovrsnih dobara, koje nisi napunio; na iskopane bunare, koje nisi kopao, u vinograde i maslinjake, koje nisi sadio, pa se sit najedeš – ");
INSERT INTO srponstl_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","pazi da ne zaboraviš Gospoda, koji te je izveo iz Egipta, iz kuće ropstva. ");
INSERT INTO srponstl_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Boj se Gospoda, Boga svoga, njemu služi i njegovim se imenom zaklinji. ");
INSERT INTO srponstl_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Ne idite za drugim bogovima, božanstvima naroda koji vas okružuju, ");
INSERT INTO srponstl_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","da ne plane gnev Gospoda, Boga tvoga, i istrebi vas s lica zemlje. Jer Gospod, Bog vaš, koji je među vama, ljubomorni je Bog. ");
INSERT INTO srponstl_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Ne iskušavajte Gospoda, Boga svoga, kao što ste ga iskušavali kod Mase. ");
INSERT INTO srponstl_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Predano držite zapovesti Gospoda, Boga svoga, njegove propise i uredbe koje vam je dao. ");
INSERT INTO srponstl_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Čini što je pravedno i dobro u njegovim očima, da ti bude dobro i da zaposedneš dobru zemlju koju je Gospod obećao tvojim ocima, ");
INSERT INTO srponstl_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","terajući sve tvoje neprijatelje pred tobom, kao što je Gospod rekao. ");
INSERT INTO srponstl_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","A kada te, danas – sutra, tvoj sin upita: ’Šta znače propisi, uredbe i pravila koje nam je zapovedio Gospod, Bog naš?’, ");
INSERT INTO srponstl_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ti mu reci: ’Nekada smo bili faraonovi robovi u Egiptu, ali nas je Gospod izveo iz Egipta snažnom rukom. ");
INSERT INTO srponstl_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Gospod je na naše oči činio velike i strašne znakove i čudesa protiv Egipta, protiv faraona i protiv celog njegovog doma. ");
INSERT INTO srponstl_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Izveo nas je odande, da nas dovede i da nam zemlju za koju se zakleo našim ocima. ");
INSERT INTO srponstl_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Gospod nam je zapovedio da vršimo sve ove uredbe, kako bismo se bojali Gospoda, Boga svoga, i da bi nam bilo dobro u sve dane, te da sačuvamo živote, kao što je to danas. ");
INSERT INTO srponstl_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Ovo će biti naša pravednost: da držimo i vršimo sve ove zapovesti pred Gospodom, Bogom našim, kao što nam je on zapovedio.’ ");
INSERT INTO srponstl_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Jer kad te Gospod, Bog tvoj, uvede u zemlju koju ideš da osvojiš, pa isteraš pred sobom mnoge narode: Hetite, Gergešane, Amorejce, Hanance, Ferežane, Evejce, Jevusejce – sedam naroda brojnijih i jačih od tebe – ");
INSERT INTO srponstl_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","i kad ih Gospod, Bog tvoj, preda u tvoje ruke, i ti ih poraziš, izvrši nad njima kleto uništenje. Ne sklapaj savez sa njima, niti im iskazuj milosti. ");
INSERT INTO srponstl_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Ne stupaj u brak s njima. Svoje ćerke ne udaji za njihove sinove, niti uzimaj njihove ćerke za svoje sinove, ");
INSERT INTO srponstl_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","jer će one odvratiti tvoje sinove od mene, da bi služili drugim bogovima. Tada će Gospodnji gnev planuti protiv vas, pa će te brzo istrebiti. ");
INSERT INTO srponstl_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Nego, ovako ćete postupati s njima: porušite njihove žrtvenike, oborite njihove stubove, posecite njihove Aštartine stubove i spalite njihove kipove. ");
INSERT INTO srponstl_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Jer, ti si narod posvećen Gospodu, Bogu svome. Tebe je Gospod, Bog tvoj, izabrao od svih naroda koji su na zemlji da budeš njegov narod, njegova najdragocenija svojina. ");
INSERT INTO srponstl_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Gospod vas nije zavoleo i izabrao zato što ste brojniji od drugih naroda – u stvari, vi ste bili najmanji od svih naroda – ");
INSERT INTO srponstl_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","nego zato što vas Gospod voli i drži zakletvu kojom se zakleo vašim ocima. Zato vas je Gospod izveo moćnom rukom i izbavio vas iz kuće ropstva, iz ruku faraona, cara egipatskoga. ");
INSERT INTO srponstl_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Stoga, znaj da je Gospod, Bog tvoj, pravi Bog, verni Bog koji drži svoj savez i iskazuje milost do hiljadu kolena onima koji ga vole i drže njegove zapovesti. ");
INSERT INTO srponstl_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","A onima koji ga mrze uzvraća ponaosob i uništava ih; onome koji ga mrzi uzvraća bez odlaganja. ");
INSERT INTO srponstl_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Zato, drži zapovesti, propise i uredbe koje ti danas zapovedam da ih vršiš. ");
INSERT INTO srponstl_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Ako budeš slušao ove uredbe, te ih budeš držao i vršio, Gospod, Bog tvoj, će držati svoj savez i milost, za koje se zakleo tvojim ocima. ");
INSERT INTO srponstl_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Tada će te voleti i blagosiljati te i umnožiti te. Blagosloviće plod tvoje utrobe, plod tvoje zemlje, tvoje žito, mlado vino i ulje, telad tvojih krava i prirast tvoje sitne stoke, na zemlji za koju se zakleo tvojim ocima da će je dati tebi. ");
INSERT INTO srponstl_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Od svih naroda ti ćeš biti najblagosloveniji. Među tobom neće biti jalovoga ni jalove, niti među tvojom stokom. ");
INSERT INTO srponstl_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Gospod će otkloniti od tebe svaku bolest. On te neće udariti opakim pošastima egipatskim za koje znaš, ali će udariti njima one koji te mrze. ");
INSERT INTO srponstl_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Uništi sve narode koje ti je predao Gospod, Bog tvoj. Neka se tvoje oko ne sažaljeva nad njima. Ne služi njihovim bogovima, jer će ti to biti zamka. ");
INSERT INTO srponstl_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Možda ćeš reći u sebi: ’Ovi narodi su brojniji od mene. Kako ću ih isterati?’ ");
INSERT INTO srponstl_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Ne boj ih se, nego se seti šta je Gospod, Bog tvoj, učinio faraonu i celom Egiptu! ");
INSERT INTO srponstl_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Svojim si očima video velike nevolje, znakove i čudesa, snažnu ruku i ispruženu mišicu, kojima te je Gospod, Bog tvoj, izveo. Tako će Gospod, Bog tvoj, učiniti sa svim narodima kojih se bojiš. ");
INSERT INTO srponstl_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Šta više, Gospod, Bog tvoj, će poslati stršljene na njih, dok ne izginu preostali koji se budu krili od tebe. ");
INSERT INTO srponstl_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Ne plaši ih se, jer je Gospod, Bog tvoj, u tvojoj sredini. On je Bog, veliki i strašni! ");
INSERT INTO srponstl_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Gospod, Bog tvoj, izgoniće ove narode pred tobom malo po malo. Nećeš moći da ih brzo istrebiš, da se zveri ne bi razmnožile protiv tebe. ");
INSERT INTO srponstl_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Gospod, Bog tvoj, će ih predati tebi; uneće među njih veliku pometnju, dok ne budu istrebljeni. ");
INSERT INTO srponstl_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","On će predati u tvoje ruke njihove careve da istrebiš njihovo ime pod nebom. Niko neće moći da ti se suprotstavi dok ih ne uništiš. ");
INSERT INTO srponstl_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Kipove njihovih bogova spali! Ne poželi njihovo srebro i zlato što je na njima; ne uzimaj ga da ne bi upao u zamku, jer je to odvratno Gospodu, Bogu tvome. ");
INSERT INTO srponstl_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Ne unosi grdobu u svoju kuću, da ne bi kao ona bio udaren kletim uništenjem. Neka ti bude mrska i odvratna, jer je određena za kleto uništenje. ");
INSERT INTO srponstl_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Drži i vrši sve zapovesti koje ti danas zapovedam, da biste se umnožili, te da biste ušli i osvojili zemlju, za koju se Gospod zakleo vašim ocima. ");
INSERT INTO srponstl_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Sećaj se celog puta kojim te je Gospod, Bog tvoj, vodio četrdeset godina u pustinji, da bi te obuzdao i iskušao, te da bi saznao šta ti je u srcu, da li ćeš vršiti njegove zapovesti ili ne. ");
INSERT INTO srponstl_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","On te je krotio, pustio te da gladuješ, pa te je nahranio manom za koju nisi znao ni ti ni tvoji preci, da te nauči da čovek ne živi samo od hleba, nego od svake reči koja izlazi iz usta Gospodnjih. ");
INSERT INTO srponstl_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Za tih četrdeset godina, odeća na tebi nije se pocepala, niti su ti noge oticale. ");
INSERT INTO srponstl_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Stoga, shvati u svom srcu da te Gospod, Bog tvoj, odgaja kao što otac odgaja sina. ");
INSERT INTO srponstl_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Drži zapovesti Gospoda, Boga svoga, da bi sledio njegove puteve i da bi ga se bojao. ");
INSERT INTO srponstl_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Jer, Gospod, Bog tvoj, vodi te u dobru zemlju, zemlju potoka, izvora i dubinskih voda što izviru u dolinama i brdima; ");
INSERT INTO srponstl_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","zemlju pšenice i ječma, loze, smokava i narova, zemlju maslina, ulja i meda; ");
INSERT INTO srponstl_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","zemlju u kojoj nećeš jesti hleb u siromaštvu, i gde ti ništa neće nedostajati; zemlju gde kamenje ima gvožđa, iz čijih ćeš brda iskopavati bakar. ");
INSERT INTO srponstl_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Tada ćeš se najesti i nasititi, pa ćeš blagosiljati Gospoda, Boga svoga, za dobru zemlju koju ti je dao. ");
INSERT INTO srponstl_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Pazi da ne zaboraviš Gospoda, Boga svoga, propuštajući da držiš njegove zapovesti, odredbe i propise, koje ti danas dajem. ");
INSERT INTO srponstl_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","A kad se najedeš i nasitiš, kad izgradiš dobre kuće i u njima se nastaniš, ");
INSERT INTO srponstl_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","kad se tvoja krupna i sitna stoka razmnoži, kad stekneš mnogo srebra i zlata i sva se tvoja imovina uveća, ");
INSERT INTO srponstl_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","nemoj da se uzoholiš u srcu i zaboraviš Gospoda, Boga svoga, koji te je izveo iz Egipta, iz kuće ropstva. ");
INSERT INTO srponstl_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","On je taj što te je vodio kroz veliku i strašnu pustinju, punu zmija otrovnica i škorpija, kroz suv i bezvodni kraj i izveo ti vodu iz stene tvrde kao kremen-kamen. ");
INSERT INTO srponstl_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","On te je hranio manom u pustinji za koju nisu znali tvoji preci, da te ukroti i iskuša, te da te na kraju učini srećnim. ");
INSERT INTO srponstl_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Nemoj tada da kažeš u svome srcu: ’Svojom silom i snagom svojih ruku sam stekao sebi ovo bogatstvo.’ ");
INSERT INTO srponstl_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Seti se da ti Gospod, Bog tvoj, daje snagu da stičeš bogatstvo, da ispuni svoj savez za koji se zakleo tvojim ocima, kao što je to danas. ");
INSERT INTO srponstl_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","A ako zaboraviš Gospoda, Boga svoga, pa kreneš za drugim bogovima te im budeš služio i klanjao im se, jamčim vam da ćete biti istrebljeni. ");
INSERT INTO srponstl_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Kao što Gospod istrebljuje narode pred vama, tako ćete i vi biti istrebljeni, jer niste poslušali glas Gospoda, Boga svoga. ");
INSERT INTO srponstl_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Slušaj, Izrailju! Danas prelaziš Jordan da uđeš i ovladaš narodima većim i brojnijim od tebe, i ogromnim gradovima opasanim do nebesa. ");
INSERT INTO srponstl_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Tu žive Enakovci, narod veliki i visokog rasta, za koji znaš i o kome si slušao: ’Ko će se suprotstaviti Enakovcima?’ ");
INSERT INTO srponstl_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Znaj danas da Gospod, Bog tvoj, ide ispred tebe kao oganj proždirući. On će ih istrebiti i pokoriti pred tobom, a ti ćeš ih isterati i brzo ih istrebiti, kao što ti je rekao Gospod. ");
INSERT INTO srponstl_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Nemoj reći u svome srcu kad ih Gospod, Bog tvoj, potera pred tobom: ’Gospod me je zbog moje pravednosti uveo da zauzmem ovu zemlju.’ Naprotiv, Gospod ih tera ispred tebe zbog opakosti tih naroda. ");
INSERT INTO srponstl_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Ne, nije zbog pravednosti i čestitosti tvoga srca to što ideš da zaposedneš tu zemlju; Gospod, Bog tvoj, tera pred tobom te narode zbog njihove opakosti, kao i da ispuni obećanje kojim se zakleo tvojim ocima, Avrahamu, Isaku i Jakovu. ");
INSERT INTO srponstl_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Znaj i to da ti Gospod, Bog tvoj, ne daje da zaposedneš ovu dobru zemlju zbog tvoje pravednosti; ti si, naime, narod tvrdovrat. ");
INSERT INTO srponstl_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Sećaj se i ne zaboravljaj kako si u pustinji izazivao Gospoda, Boga svoga, buneći se protiv Gospoda, od dana kada si izašao iz Egipta, pa sve dok niste stigli ovde. ");
INSERT INTO srponstl_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Na Horivu ste izazivali Gospoda, da se on toliko razgnevio na vas da je hteo da vas istrebi. ");
INSERT INTO srponstl_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","A kad sam se popeo na Horiv da uzmem kamene ploče, ploče saveza koji je Gospod sklopio sa vama, ostao sam na gori četrdeset dana i četrdeset noći, tokom kojih nisam jeo hleba ni pio vode. ");
INSERT INTO srponstl_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Tada mi je Gospod dao dve kamene ploče, napisane Božijim prstom. Na njima su bile sve reči koje vam je na gori saopštio Gospod na dan zbora. ");
INSERT INTO srponstl_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Kada se navršilo četrdeset dana i četrdeset noći, Gospod mi je dao dve kamene ploče, ploče saveza. ");
INSERT INTO srponstl_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Tada mi je Gospod rekao: ’Ustani i brzo siđi s ove gore, jer se pokvario narod koji si izveo iz Egipta. Brzo su skrenuli s puta na koji sam ih uputio; napravili su sebi livenog idola.’ ");
INSERT INTO srponstl_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Gospod mi reče: ’Video sam da je ovaj narod, narod tvrdovrat. ");
INSERT INTO srponstl_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","A sada me pusti da ih istrebim i da im zatrem ime pod nebom, a od tebe ću učiniti narod moćniji i brojniji od njih.’ ");
INSERT INTO srponstl_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Okrenuo sam se i sišao s gore, dok je gora plamtela ognjem. U rukama sam držao dve kamene ploče saveza. ");
INSERT INTO srponstl_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Tu sam video da ste zgrešili Gospodu, Bogu svome, načinivši sebi liveno tele. Brzo ste skrenuli s puta na koji vas je Gospod uputio. ");
INSERT INTO srponstl_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Tada sam dohvatio one kamene ploče, bacio ih iz svojih ruku i na vaše oči ih razbio. ");
INSERT INTO srponstl_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Onda sam pao ničice pred Gospodom ležeći četrdeset dana i četrdeset noći, kao prvi put. Hleba nisam jeo, niti sam pio vode, zbog sveg greha koji ste počinili; činili ste što je zlo u njegovim očima i time izazvali Gospoda na gnev. ");
INSERT INTO srponstl_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Naime, uplašio sam se gneva i srdžbe kojim se Gospod ražestio na vas, da vas istrebi. Ipak, Gospod me je poslušao i ovaj put. ");
INSERT INTO srponstl_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Gospod se veoma razgnevio i na Arona, pa je hteo i njega da istrebi. Tada sam molio Gospoda i za njega. ");
INSERT INTO srponstl_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","A vaš greh, vaše liveno tele, sam uzeo i spalio u vatri. Zatim sam ga izlomio i izmrvio sve dok od njega nije ostao samo prah. Prah sam bacio u potok koji teče s gore. ");
INSERT INTO srponstl_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Gospoda ste gnevili i u Taveri, Masi i Kivrot-Atavi. ");
INSERT INTO srponstl_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Kada vas je Gospod poslao iz Kadis-Varnije, rekao je: ’Popnite se i osvojite zemlju koju sam vam dao.’ Ali vi ste se pobunili protiv naredbe Gospoda, Boga svoga; niste mu poverovali, niti ste ga poslušali. ");
INSERT INTO srponstl_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Bunili ste se protiv Gospoda odkad vas poznajem. ");
INSERT INTO srponstl_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Pao sam ničice pred Gospodom i ležao tamo četrdeset dana i četrdeset noći, jer je Gospod rekao da će vas istrebiti. ");
INSERT INTO srponstl_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Tada sam molio Gospoda: ’Gospode, Bože, ne uništavaj narod svoj, baštinu svoju, koju si otkupio svojim veličanstvom i izveo iz Egipta svojom silnom rukom. ");
INSERT INTO srponstl_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Seti se tvojih slugu: Avrahama, Isaka i Jakova; ne obaziri se na tvrdoglavost ovog naroda, na njegovu opakost i greh, ");
INSERT INTO srponstl_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","da se ne bi govorilo u zemlji iz koje si nas izveo: „Gospod nije mogao da ih dovede u zemlju koju im je obećao. On ih je iz mržnje izveo, kako bi ih pobio u pustinji.“ ");
INSERT INTO srponstl_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","A oni su tvoj narod, tvoja baština, koju si izveo svojom velikom silom i ispruženom mišicom.’ ");
INSERT INTO srponstl_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","U to vreme mi je Gospod rekao: ’Iskleši sebi dve kamene ploče kao što su bile one prve, pa se popni k meni na goru; napravi i drveni Kovčeg. ");
INSERT INTO srponstl_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Ja ću, onda, napisati na pločama reči koje su bile napisane na prvim pločama koje si razbio. Stavi ih u Kovčeg.’ ");
INSERT INTO srponstl_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Tako sam napravio Kovčeg od bagremovog drveta, isklesao dve kamene ploče, kao što su bile one prve, pa sam se popeo na goru sa dve kamene ploče u rukama. ");
INSERT INTO srponstl_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Bog je napisao na pločama ono što je napisao prvi put; deset zapovesti koje vam je Gospod saopštio na gori iz ognja na dan zbora, i predao mi ih. ");
INSERT INTO srponstl_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Zatim sam se okrenuo i sišao s gore. Ploče sam stavio u Kovčeg koji sam napravio, kao što mi je Gospod zapovedio, i tamo su još uvek. ");
INSERT INTO srponstl_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(Iz Virota koji pripada Jakancima, Izrailjci su nastavili prema Moseri. Tamo je Aron umro i bio sahranjen. Na njegovo mesto su postavili za sveštenika njegovog sina, Eleazara. ");
INSERT INTO srponstl_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Odatle su nastavili za Gudgod, a iz Gudgoda za Jotvatu, u zemlju mnogih potoka. ");
INSERT INTO srponstl_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","U to vreme je Gospod izdvojio Levijevo pleme da nosi Kovčeg saveza Gospodnjeg, da stoji pred Gospodom, da mu služi i da blagosilja u njegovo ime, kao što je to danas. ");
INSERT INTO srponstl_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Zato Levi nema svoj deo baštine sa njegovom braćom. Sam Gospod je njegova baština, baš kao što mu je rekao Gospod, Bog tvoj.) ");
INSERT INTO srponstl_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Ja sam ostao na gori četrdeset dana i četrdeset noći, kao prvi put. Gospod me je poslušao i ovaj put, te nije hteo da te uništi. ");
INSERT INTO srponstl_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Gospod mi reče: ’Spremi se i kreni na put na čelu naroda, da odu i osvoje zemlju za koju sam se zakleo da ću je dati njihovim ocima.’ ");
INSERT INTO srponstl_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","A sad, Izrailju, šta to Gospod, Bog tvoj, traži od tebe? Samo to da se bojiš Gospoda, Boga svoga, da slediš sve njegove puteve, da ga voliš; da služiš Gospodu, Bogu svome, svim srcem svojim i svom dušom svojom, ");
INSERT INTO srponstl_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","i da držiš zapovesti i uredbe Gospodnje, koje ti danas nalažem, za tvoje dobro. ");
INSERT INTO srponstl_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Gle, Gospodu, Bogu tvome, pripada nebo, i nebo nad nebesima, te zemlja i sve što je na njoj. ");
INSERT INTO srponstl_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Jedino su tvoji oci prionuli Gospodu za srce; on ih je zavoleo i izabrao njihovo potomstvo posle njih između svih naroda, kao što je to danas. ");
INSERT INTO srponstl_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Zato obrežite svoje srce i ne ukrućujte više vratove. ");
INSERT INTO srponstl_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Jer, Gospod, Bog vaš, je Bog nad bogovima i Gospodar nad gospodarima, Bog veliki, moćni i strašni, koji nije pristrasan, ni podmitljiv. ");
INSERT INTO srponstl_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","On dodeljuje pravdu siromahu i udovici; voli stranca i daje mu hranu i odeću. ");
INSERT INTO srponstl_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Zato volite stranca, jer ste i sami bili stranci u Egiptu. ");
INSERT INTO srponstl_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Bojte se Gospoda, Boga svoga, njemu služite i njegovim se imenom kunite. ");
INSERT INTO srponstl_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","On je tvoja slava i Bog tvoj, koji je učinio za tebe ova velika i strašna dela koja si svojim očima video. ");
INSERT INTO srponstl_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Jer, tvoji preci odoše u Egipat sa sedamdeset duša, a sada vas je Gospod, Bog tvoj, razmnožio kao zvezde na nebu. ");
INSERT INTO srponstl_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Zato voli Gospoda, Boga svoga, i uvek drži njegove naredbe, propise, uredbe i zapovesti. ");
INSERT INTO srponstl_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Znajte danas, da vaši sinovi nisu ti što su iskusili karanje Gospoda, Boga vašeg, i videli njegovo veličanstvo, njegovu moćnu ruku i ispruženu mišicu, ");
INSERT INTO srponstl_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","znakove i njegova dela koja je učinio usred Egipta protiv faraona, cara egipatskoga, i sveg njegovog naroda; ");
INSERT INTO srponstl_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","šta je učinio sa egipatskom vojskom, njihovim konjima i bojnim kolima, kako ih je podavio u vodama Crvenog mora, dok su vam bili za petama, i kako ih je zatro Gospod do današnjega dana. ");
INSERT INTO srponstl_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Oni nisu videli šta je učinio za vas u pustinji dok niste došli na ovo mesto; ");
INSERT INTO srponstl_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","šta je učinio Datanu i Avironu, sinovima Elijava, potomka Ruvimovog, kad se otvorila zemlja usred Izrailja i progutala i njih i njihove domove, njihove šatore i svu njihovu imovinu. ");
INSERT INTO srponstl_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Ne, to su vaše oči videle sva velika dela koja je Gospod učinio. ");
INSERT INTO srponstl_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Zato držite sve zapovesti koje vam danas nalažem, da budete jaki, da uđete i osvojite zemlju u koju idete da je zauzmete, ");
INSERT INTO srponstl_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","te da dugo proživite na zemlji za koju se Gospod zakleo vašim ocima da će je dati vama i vašem potomstvu – zemlju kojom teku mleko i med. ");
INSERT INTO srponstl_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Jer, zemlja u koju ulaziš da je zauzmeš nije kao egipatska zemlja iz koje si izašao, gde si sejao svoje seme i navodnjavao ga svojom nogom, kao što se navodnjava povrtnjak. ");
INSERT INTO srponstl_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Zemlja u koju ulazite da je zauzmete zemlja je brda i dolina koja se navodnjava kišom sa neba. ");
INSERT INTO srponstl_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","To je zemlja o kojoj se sam Gospod, Bog tvoj, stara; zemlja nad kojom oči Gospoda, Boga tvog, stalno bdiju, od početka do kraja godine. ");
INSERT INTO srponstl_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Ako poslušate zapovesti koje vam danas zapovedam, i budete voleli Gospoda, Boga svoga, i služili mu svim svojim srcem i svom svojom dušom, ");
INSERT INTO srponstl_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","on će davati ranu i poznu kišu vašoj zemlji u pravo vreme, pa ćete sabirati svoje žito, svoje vino i svoje ulje; ");
INSERT INTO srponstl_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","davaće vam travu na vašem polju za vašu stoku, te ćete jesti i nasititi se. ");
INSERT INTO srponstl_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Pazite da se ne prevarite u svome srcu, pa zastranite služeći i klanjajući se drugim bogovima. ");
INSERT INTO srponstl_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Tada će gnev Gospodnji planuti protiv vas: nebesa će se zatvoriti i neće davati kišu, zemlja neće davati svoj rod, a vi ćete brzo nestati sa dobre zemlje koju vam Gospod daje. ");
INSERT INTO srponstl_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Zato usadite ove moje reči u srce svoje i u dušu svoju; privežite ih kao znak na svoju ruku; neka vam budu kao zapis među očima. ");
INSERT INTO srponstl_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Poučite njima svoju decu; govorite im o njima; kad sediš u kući, kad ideš putem, kad ležiš i kad ustaješ. ");
INSERT INTO srponstl_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Napiši ih na dovracima svoje kuće i na tvojim vratima, ");
INSERT INTO srponstl_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","da bi ti se umnožili dani i dani tvoje dece na zemlji za koju se Gospod zakleo tvojim ocima da će im je dati, dokle god bude neba nad zemljom. ");
INSERT INTO srponstl_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Ako budete predano držali ove zapovesti koje vam zapovedam da vršite, voleli Gospoda, Boga svoga, sledili sve njegove puteve i čvrsto se držali uz njega, ");
INSERT INTO srponstl_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","Gospod će poterati sve ove narode ispred vas, pa ćete razvlastiti narode koji su veći i brojniji od vas. ");
INSERT INTO srponstl_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Svako mesto gde bude stupila vaša noga, biće vaše; vaša granica će se protezati od pustinje do Livana i od reke Eufrata do Zapadnog mora. ");
INSERT INTO srponstl_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Niko neće moći da vam se odupre, jer će Gospod, Bog vaš, uliti strah i trepet po celoj zemlji u koju stupite, baš kao što vam je rekao. ");
INSERT INTO srponstl_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Vidi! Postavljam danas pred vas blagoslov i prokletstvo: ");
INSERT INTO srponstl_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","blagoslov ako poslušate zapovesti Gospoda, Boga svoga, koje vam ja danas nalažem, ");
INSERT INTO srponstl_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","a prokletstvo ako ne poslušate zapovesti Gospoda, Boga svoga, te skrenete sa puta na koji vas ja danas upućujem i krenete za drugim bogovima koje niste poznavali. ");
INSERT INTO srponstl_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","A kada te Gospod, Bog tvoj, uvede u zemlju u koju ideš da je zauzmeš, postavi blagoslov na goru Gerizim, a prokletstvo na goru Eval. ");
INSERT INTO srponstl_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Nisu li te gore s druge strane Jordana, na putu što vodi na zapad, u zemlji Hananaca koji žive u Aravi, nasuprot Galgalu, blizu hrasta More? ");
INSERT INTO srponstl_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Jer vi sad prelazite preko Jordana da uđete i zauzmete zemlju koju vam daje Gospod, Bog vaš. Vi ćete je zauzeti i živeti u njoj. ");
INSERT INTO srponstl_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Zato drži i vrši propise i uredbe koje danas postavljam pred vas. ");
INSERT INTO srponstl_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Ovo su propisi i uredbe koje ćete morati dosledno držati u zemlji koju ti je Gospod, Bog vaših otaca, predao da je zauzmeš u sve dane, dokle god živiš na zemlji. ");
INSERT INTO srponstl_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Potpuno uništi sva mesta gde su narodi, koje ćete proterati, služili svojim bogovima: na planinama, brdima i uzvišicama, i ispod svakog zelenog drveta. ");
INSERT INTO srponstl_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Porušite njihove žrtvenike, uništite njihove svete stubove, spalite Aštartine stubove, porazbijajte njihove kipove, zatrite im imena sa onih mesta. ");
INSERT INTO srponstl_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Gospodu, Bogu vašem, ne služite na taj način. ");
INSERT INTO srponstl_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Nego, tražite Gospoda, Boga vašeg, na mestu koje će on izabrati između svih tvojih plemena, da smesti svoje ime u Prebivalište. Tamo ćete ići. ");
INSERT INTO srponstl_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Tamo donosite žrtve svespalnice i ostale žrtve, vaše desetke i dobrovoljne priloge, te prvinu vaše krupne i sitne stoke. ");
INSERT INTO srponstl_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Ješćete tamo, pred Gospodom, Bogom svojim, i radovati se sa svojim domovima svemu što su vaše ruke postigle, čime te je blagoslovio Gospod, Bog tvoj. ");
INSERT INTO srponstl_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Ne radite onako kako mi danas radimo ovde, gde svako radi što mu se čini pravo, ");
INSERT INTO srponstl_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","jer još niste ušli u mesto počinka, u baštinu koju ti daje Gospod, Bog tvoj. ");
INSERT INTO srponstl_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Ali kad pređete preko Jordana i nastanite se u zemlji koju vam Gospod, Bog vaš, daje u posed, i da vam odmor od svih vaših neprijatelja koji vas okružuju, te budete živeli spokojno, ");
INSERT INTO srponstl_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","tada ćete donositi u mesto koje izabere Gospod, Bog vaš, sve što vam zapovedam: žrtve svespalnice i ostale žrtve, desetke, dobrovoljne priloge i sve zavetne darove koje budete zavetovali Gospodu. ");
INSERT INTO srponstl_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Tamo ćete se radovati pred Gospodom, vi, vaši sinovi i vaše ćerke, vaše sluge i sluškinje, i Levit koji bude živeo u tvojim gradovima, jer on nema sa vama udeo i nasledstvo. ");
INSERT INTO srponstl_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Pazi da ne prinosiš žrtve svespalnice gde ti zapne oko, ");
INSERT INTO srponstl_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","nego samo na mestu koje izabere Gospod u jednom od tvojih plemena. Tamo prinosi svoje žrtve svespalnice i tu radi sve što ti zapovedam. ");
INSERT INTO srponstl_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Kad god hoćeš, možeš da zakolješ i jedeš meso po svim svojim gradovima, prema blagoslovu koji ti daje Gospod, Bog tvoj. I čisti i nečisti mogu jesti srnu i jelena. ");
INSERT INTO srponstl_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Samo krv ne jedite; izlivajte je na zemlju kao vodu. ");
INSERT INTO srponstl_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","U svojim gradovima ne smeš jesti od desetka svoga žita, mladog vina, ulja, prvine svoje krupne i sitne stoke, niti išta od tvojih zavetnih darova i dobrovoljnih priloga. ");
INSERT INTO srponstl_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","To ćeš jesti samo pred Gospodom, Bogom svojim, na mestu koje odabere Gospod, Bog tvoj, ti, tvoji sinovi i tvoje ćerke, tvoje sluge i tvoje sluškinje, i Levit koji bude živeo u tvojim gradovima. Raduj se pred Gospodom, Bogom svojim, u svemu što preduzme ruka tvoja. ");
INSERT INTO srponstl_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Pazi da ne zanemariš Levita, dokle god živiš na svojoj zemlji. ");
INSERT INTO srponstl_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","A kad Gospod, Bog tvoj, proširi tvoje granice, kako ti je obećao, pa kažeš: ’Hoću da jedem mesa’, zato što ti se duša zaželi mesa, jedi mesa kad god ti se prohte. ");
INSERT INTO srponstl_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Ali, ako mesto koje Gospod, Bog tvoj, izabere da u njemu smesti svoje ime, bude daleko od tebe, onda zakolji od svoje krupne ili sitne stoke koju ti je dao Gospod, Bog tvoj – kao što sam ti zapovedio – te jedi po svojim gradovima kad god hoćeš. ");
INSERT INTO srponstl_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Jedi ga onako kao što bi se jela srna ili jelen; neka ga jedu i čisti i nečisti. ");
INSERT INTO srponstl_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Samo, pazi da ne jedeš krv, jer je krv život. Zato ne smeš da jedeš život sa mesom. ");
INSERT INTO srponstl_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Ne jedi je, n